﻿USE sofia;
DROP TABLE IF EXISTS sofia.cmn_ncvs_vpl;
CREATE TABLE cmn_ncvs_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cmn_ncvs_vpl WRITE;
INSERT INTO cmn_ncvs_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","起初，　神创造天地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","地是空虚混沌；深渊上一片黑暗；　神的灵运行在水面上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","神说：“要有光！”就有了光。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","神看光是好的，他就把光暗分开了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","神称光为昼，称暗为夜。有晚上，有早晨；这是第一日。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","神说：“众水之间要有穹苍，把水和水分开！”事就这样成了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","神造了穹苍，把穹苍以下的水和穹苍以上的水分开了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","神称穹苍为天。有晚上，有早晨；这是第二日。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","神说：“天下的水要聚在一处，使旱地露出来！”事就这样成了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","神称旱地为地，称水的聚处为海。　神看这是好的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","神说：“地上要长出青草、结种子的蔬菜和结果子的树木，各从其类，在地上的果子都包着核！”事就这样成了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","于是，地上长出了青草和结种子的蔬菜，各从其类；又长出结果子的树木，各从其类，果子都包着核。　神看这是好的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","有晚上，有早晨；这是第三日。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","神说：“在天上穹苍中，要有光体来分昼夜；这些光体要作为记号，定节令、日子和年岁； ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","它们要在天上穹苍中发光，照耀地上！”事就这样成了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","于是，　神造了两个大光体，大的管昼，小的管夜；又造了星星。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","神把这些光体安放在天上穹苍中，照耀地上， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","管昼夜，分光暗。　神看这是好的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","有晚上，有早晨；这是第四日。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","神说：“水要滋长生物；地上和天空之中，要有雀鸟飞翔！” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","于是，　神创造了大鱼和在水中滋生各种能活动的生物，各从其类；又创造了各种有翅膀的飞鸟，各从其类。　神看这是好的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","神就赐福给它们，说：“要繁殖增多，充满海洋；雀鸟也要在地上增多！” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","有晚上，有早晨；这是第五日。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","神说：“地上要生出活物来，各从其类；牲畜、昆虫和地上的野兽，各从其类！”事就这样成了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","于是，　神造了地上的野兽，各从其类；牲畜，各从其类；地上的各种昆虫，各从其类。　神看这是好的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","神说：“我们要照着我们的形象，按着我们的样式造人；使他们管理海里的鱼、空中的鸟、地上的牲畜，以及全地，和地上所有爬行的生物！” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","于是，　神照着自己的形象创造人；就是照着他的形象创造了人；他所创造的有男有女。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","神就赐福给他们，对他们说：“要繁殖增多，充满这地，征服它；也要管理海里的鱼、空中的鸟和地上爬行的所有生物。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","神说：“看哪！我把全地上结种子的各样蔬菜，和一切果树上有种子的果子，都赐给你们作食物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","至于地上的各种野兽，空中的各种飞鸟，和地上爬行有生命的各种活物，我把一切青草蔬菜赐给它们作食物。”事就这样成了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","神看他所造的一切都很好。有晚上，有早晨；这是第六日。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","这样，天地万物都造齐了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","第七日，　神完成了他所作的工；在第七日　神歇了他所作的一切工。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","神赐福第七日，把它分别为圣，因为在这一日，　神停了他一切所创造的工，歇息了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","这是创造天地的起源：耶和华　神造天地的时候， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","原野上还没有树木，田间的蔬菜还没有长起来，因为耶和华　神还没有降雨在地上，也没有人耕种土地； ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","不过有雾气从地面上升，滋润全地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","耶和华　神用地上的尘土造成人形，把生气吹进他的鼻孔里，那人就成了有生命的活人，名叫亚当。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","耶和华　神在东方的伊甸，栽了一个园子，把他所造的人放在那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","耶和华　神使各样的树从地上长起来，能悦人的眼目，也好作食物。园子中间又有生命树，和知善恶树。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","有一条河从伊甸流出来，灌溉那园子；从那里分支，成了四道河的源头。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","第一道河名叫比逊，就是环绕哈腓拉全地的，在那里有金子； ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","那地的金子是好的；在那里也有红玉和玛瑙。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","第二道河名叫基训，就是环绕古实全地的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","第三道河名叫底格里斯河（“底格里斯河”原文作“希底结”），就是流向亚述东边的。第四道河就是幼发拉底河（“幼发拉底河”原文作“伯拉河”）。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","耶和华　神把那人安置在伊甸园里，叫他耕种和看守那园子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","耶和华　神吩咐那人说：“园中各样树上的果子，你都可以吃； ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","只是那知善恶树的果子，你不可吃；因为你吃的时候，你必要死。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","耶和华　神说：“那人独居不好，我要为他造个和他相配的帮手。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","耶和华　神用泥土造了野地的各样野兽，和空中的各样飞鸟，把它们都带到那人面前，看他给它们叫什么名字；那人怎样叫各样有生命的活物，那就是它的名字。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","那人就给各样牲畜、空中的雀鸟，和野地的各样走兽起了名字；只是那人没有遇见一个和他相配的帮手。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","耶和华　神使那人沉睡。他熟睡的时候，耶和华　神取了他的一根肋骨，又使肉在原处复合。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","然后，耶和华　神用从那人身上所取的肋骨，造了一个女人，带她到那人面前。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","那人说：“这是我骨中的骨，肉中的肉；她当称为女人，因她是从男人身上取出来的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","因此人要离开父母，和妻子连合，二人成为一体。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","那时，夫妻二人赤身露体，彼此都不觉得羞耻。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","在耶和华　神所造野地所有的活物中，蛇是最狡猾的。蛇对女人说：“　神真的说过，你们不可吃园中任何树上的果子吗？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","女人对蛇说：“园中树上的果子，我们都可以吃； ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","只有园中那棵树上的果子，　神曾经说过：‘你们不可吃，也不可摸，免得你们死。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","蛇对女人说：“你们决不会死； ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","因为　神知道你们吃那果子的时候，你们的眼睛就开了；你们会像　神一样，能知道善恶。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","于是，女人见那棵树的果子好作食物，又悦人的眼目，而且讨人喜爱，能使人有智慧，就摘下果子来吃了；又给了和她在一起的丈夫，他也吃了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","二人的眼睛就开了，才知道自己是赤身露体的。于是把无花果树的叶子编缝起来，为自己做裙子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","天起凉风的时候，那人和他的妻子听见耶和华　神在园中行走的声音，就藏在园子的树林中，躲避耶和华　神的面。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","耶和华　神呼唤那人，对他说：“你在哪里？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","他回答：“我在园中听见你的声音，就害怕；因为我赤身露体，就藏了起来。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","耶和华　神说：“谁告诉你，你是赤身露体呢？难道你吃了我吩咐你不可吃的那树上的果子吗？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","那人说：“你所赐给我、和我在一起的那女人，她把树上的果子给我，我就吃了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","耶和华　神对女人说：“你作了什么事呢？”女人说：“那蛇欺哄我，我就吃了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","耶和华　神对蛇说：“因为你作了这事，就必在所有的牲畜和田野的活物中受咒诅；你要用肚子行走，一生都吃泥土。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","我要使你和女人彼此为仇，你的后裔和女人的后裔，也彼此为仇，女人的后裔要伤你的头，你要伤他的脚跟。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","耶和华　神对女人说：“我要大大增加你怀胎的痛苦，你必在痛苦中生产儿女；你要恋慕你的丈夫，他却要管辖你。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","耶和华　神又对亚当说：“因为你听从了你妻子的话，吃了我吩咐你不可吃的那树上的果子；地就必因你的缘故受咒诅；你必终生劳苦，才能从地里得吃的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","地要给你长出荆棘和蒺藜来；你也要吃田间的蔬菜； ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","你必汗流满面，才有饭吃，直到你归回地土，因为你是从地土取出来的；你既然是尘土，就要归回尘土。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","亚当给他的妻子起名叫夏娃，因为她是众生之母。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","耶和华　神为亚当和他的妻子做了皮衣，给他们穿上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","耶和华　神说：“那人和我们中间的一个相似，能知善恶；现在恐怕他伸出手来，摘取生命树上的果子吃，就永远活着。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","耶和华　神就把他赶出伊甸园，去耕种他自己也是从那里出来的地土。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","于是把亚当驱逐出去，又派基路伯在伊甸园的东边，拿着旋转发火焰的剑，把守到生命树去的路。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","亚当和他的妻子夏娃同房，夏娃就怀孕，生了该隐，就说：“借着耶和华的帮助，我得了一个男儿。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","她又生了该隐的弟弟亚伯。亚伯是牧羊的，该隐是种地的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","有一天，该隐把地里的出产拿来，当作礼物献给耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","亚伯也把自己羊群中一些头生的，和羊的脂油拿来献上。耶和华看中了亚伯和他的礼物； ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","只是没有看中该隐和他的礼物。该隐就非常忿怒，垂头丧气。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","耶和华对该隐说：“你为什么忿怒呢？你为什么垂头丧气呢？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","你若行得好，岂不可以抬起头来吗？你若行得不好，罪就伏在门口了；它要缠住你，你却要制伏它。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","该隐对他的弟弟亚伯说：“我们到田间去吧。”他们正在田间的时候，该隐就起来袭击他的弟弟亚伯，把他杀了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","耶和华问该隐：“你的弟弟亚伯在哪里？”他回答：“我不知道；难道我是看守我弟弟的吗？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","耶和华说：“你作了什么事呢？你弟弟的血有声音从地里向我呼叫。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","地开了口，从你手里接受了你弟弟的血，现在你要从这地受咒诅。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","你种地，地也不再给你效力；你必在地上流离失所。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","该隐对耶和华说：“我的刑罚太重，过于我所能担当。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","看哪，今日你赶逐我离开这地，以致我要躲避你的面；我必在地上流离失所，遇见我的，都要杀我。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","耶和华对该隐说：“绝不会这样，杀该隐的，必遭报七倍。”耶和华就给该隐立了一个记号，免得遇见他的人击杀他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","于是该隐从耶和华面前出去，住在伊甸东边的挪得地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","该隐和妻子同房，她就怀孕，生了以诺。该隐建造了一座城，就按着他儿子的名，给那城叫作以诺。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","以诺生以拿，以拿生米户雅利，米户雅利生玛土撒利，玛土撒利生拉麦。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","拉麦娶了两个妻子，一个名叫亚大，另一个名叫洗拉。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","亚大生雅八，雅八就是居住帐棚、牧养牲畜的人的鼻祖。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","雅八的兄弟名叫犹八；犹八是所有弹琴吹箫的人的鼻祖。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","洗拉也生了土八．该隐，就是打造各种铜铁器具的匠人；土八．该隐的妹妹是拿玛。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","拉麦对他的两个妻子说：“亚大和洗拉，要听我的声音；拉麦的妻子，聆听我的话：壮年人伤我，我必杀他；青年人损我，我必害他； ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","人若杀该隐，要遭报七倍；人若杀拉麦，必遭报七十个七倍！” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","亚当又和妻子同房，她就生了一个儿子，给他起名叫塞特，因为她说：“　神给我立了另一个后裔代替亚伯，因为该隐杀了他。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","塞特也生了一个儿子，就给他起名叫以挪士。那时人才开始呼求耶和华的名。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","以下是亚当后代的记录。　神创造人的时候，是按着自己的样式造的； ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","他创造了一男一女。在创造他们的时候，　神赐福给他们，称他们为人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","亚当一百三十岁的时候，生了一个儿子，样式和形象都和自己相似，就给他起名叫塞特。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","亚当生塞特以后，还活了八百年，并且生了其他的儿女。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","亚当共活了九百三十岁，就死了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","塞特一百零五岁的时候，生了以挪士。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","塞特生以挪士以后，还活了八百零七年，并且生了其他的儿女。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","塞特共活了九百一十二岁，就死了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","以挪士九十岁的时候，生了该南。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","以挪士生该南以后，还活了八百一十五年，并且生了其他的儿女。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","以挪士共活了九百零五岁，就死了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","该南七十岁的时候，生了玛勒列。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","该南生玛勒列以后，还活了八百四十年，并且生了其他的儿女。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","该南共活了九百一十岁，就死了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","玛勒列六十五岁的时候，生了雅列。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","玛勒列生雅列以后，还活了八百三十年，并且生了其他的儿女。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","玛勒列共活了八百九十五岁，就死了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","雅列一百六十二岁的时候，生了以诺。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","雅列生以诺以后，还活了八百年，并且生了其他的儿女。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","雅列共活了九百六十二岁，就死了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","以诺六十五岁的时候，生了玛土撒拉。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","以诺生玛土撒拉以后，和　神同行三百年，并且生了其他的儿女。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","以诺共活了三百六十五岁。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","以诺和　神同行，所以　神把他取去，他就不在了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","玛土撒拉一百八十七岁的时候，生了拉麦。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","玛土撒拉生拉麦以后，还活了七百八十二年，并且生了其他的儿女。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","玛土撒拉共活了九百六十九岁，就死了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","拉麦一百八十二岁的时候，生了一个儿子， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","就给他起名叫挪亚，说：“这儿子必使我们从地上的操作和手中的劳苦得着安慰，因为耶和华曾经咒诅这地。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","拉麦生挪亚以后，还活了五百九十五年，并且生了其他的儿女。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","拉麦共活了七百七十七岁，就死了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","挪亚五百岁的时候，就生了闪、含和雅弗。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","人在地上开始增多，又生养女儿的时候， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","神的众子看见人的女子美丽，就随意挑选，娶作妻子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","耶和华说：“人既然是属肉体的，我的灵就不永远住在他里面，但他的日子还有一百二十年。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","在那些日子，有巨人在地上；　神的儿子和人的女子结合，就生了上古英武有名的人物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","耶和华看见人在地上的罪恶很大，终日心里思念的，尽都是邪恶的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","于是，耶和华后悔造人在地上，心中忧伤。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","耶和华说：“我要把我创造的人，从地上消灭；无论是人或牲畜，是昆虫或是天空的飞鸟，我都要消灭，因为我后悔造了他们。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","只有挪亚在耶和华眼前蒙恩。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","以下是挪亚的后代。挪亚是个义人，是当时一个完全人。挪亚和　神同行。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","挪亚生了三个儿子，就是闪、含、雅弗。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","当时，世界在　神面前败坏了，地上满了强暴。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","神观看大地，看见世界已经败坏了；全人类在地上所行的都是败坏的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","神对挪亚说：“在我面前全人类的尽头已经来到，因为地上由于他们的缘故满了强暴。看哪，我要把他们和世界一起毁灭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","你要用歌斐木做一艘方舟。方舟里面要做一些舱房；方舟的内外都要涂上沥青。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","你要这样做方舟：方舟要长一百三十三公尺，宽二十二公尺，高十三公尺。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","方舟上面四周要做透光口，高四十四公寸；方舟的门要开在旁边；方舟要分为上中下三层建造。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","看哪，我要使洪水临到地上，消灭天下的生物，就是有生气的活物；在地上的都必定要死。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","我要和你立约。你可以进入方舟；你和你的儿子、妻子和儿媳，都可以和你一同进入方舟。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","所有的活物，你要把每样一对，就是一公一母，带进方舟，好和你一同保全生命。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","飞鸟各从其类，牲畜各从其类，地上所有爬行的动物，各从其类，每样一对，都要到你那里来，好保全生命。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","你要拿各种可吃的食物，积存起来，好作你和它们的食物。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","挪亚就这样作了；　神吩咐他的，他都照样作了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","耶和华对挪亚说：“你和你全家都要进入方舟，因为在这世代中，我见只有你在我面前是个义人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","洁净的牲畜，你要各带七公七母；不洁净的牲畜，你要各带一公一母； ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","空中的飞鸟，也要各带七公七母，以便传种，活在全地上； ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","因为再过七天，我就要一连四十昼夜降雨在地上，我把所造的一切生物都从地上除灭。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","挪亚就照着耶和华吩咐他的一切作了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","洪水临到地上的时候，挪亚刚好是六百岁。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","挪亚带着他的儿子、妻子和儿媳一同进了方舟，躲避洪水。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","洁净的牲畜和不洁净的牲畜，飞鸟和各种在地上爬行的动物， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","都是一公一母、一对一对来到挪亚那里，进入方舟，是照着　神吩咐挪亚的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","那七天一过，洪水就临到地上了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","挪亚六百岁那一年，二月十七日那一天，所有大渊的泉源都裂开了，天上的窗户都敞开了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","大雨倾盆下在地上，一连四十昼夜。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","就在那一天，挪亚带着他的儿子闪、含、雅弗，以及他的妻子和三个儿媳，一同进了方舟。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","他们一家，所有走兽各从其类，所有牲畜各从其类，所有在地上爬行的动物各从其类，所有有羽有翼的飞禽各从其类， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","有生命、有气息的，都是一对一对来到挪亚那里，进入方舟。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","那些进去的，都是有生命的，一公一母进去，是照着　神吩咐挪亚的。耶和华跟着就把方舟关起来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","洪水就临到地上四十天；水不断上涨，把方舟升起，于是方舟就从地上浮起来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","水势甚大，在地上大大上涨，方舟就在水面上漂来漂去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","水势在地面上越来越大，天下所有的高山都被淹没了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","水势浩大，比众山高出七公尺，山岭都被淹没了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","凡有生命仍在地上行动的，无论是飞鸟或是牲畜，走兽或是在地上滋生的各样小生物，以及所有的人都死了； ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","仍在陆地上，鼻孔里有气息的生灵都死了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","耶和华把地上的所有生物，从人类到牲畜，爬行动物，以及空中的飞鸟都除灭了；于是，这一切都从地上消灭了。只留下挪亚和那些与挪亚一同在方舟里的人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","水势浩大，在地上共一百五十天。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","神顾念挪亚和所有与他一同在方舟里的走兽和牲畜；　神使风吹过大地，水就渐渐退了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","深渊的泉源和天上的窗户，都关闭起来；天降的大雨也止住了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","水从地上不断退去，过了一百五十天，水就消退了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","七月十七日，方舟停在亚拉腊山上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","水继续消退，直到十月；到了十月初一，山顶都露出来了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","过了四十天，挪亚开了他所做的方舟的窗户， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","放了一只乌鸦出去。地上的水还没有干，那乌鸦就一直飞来飞去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","他又放了一只鸽子出去，要看看水从地上退了没有。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","因为遍地都是水，那鸽子找不着歇脚的地方，就回到挪亚的方舟那里；于是，挪亚伸出手去，把鸽子接进方舟里来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","他再等了七天，又把鸽子从方舟里放出去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","到了黄昏的时候，鸽子回到挪亚那里，嘴里叼着一块新摘下来的橄榄树叶，挪亚就知道地上的水已经退了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","挪亚再等了七天，又把鸽子放出去，鸽子就再没有回到他那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","到挪亚六百零一岁的时候，就在正月初一，地上的水都干了；挪亚移开方舟的盖看看，见地面已经干了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","到了二月二十七日，大地就都干了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","神告诉挪亚说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“你要从方舟出来，你和你的妻子、儿子，以及儿媳都要和你一同出来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","所有和你在一起有生命的活物：飞鸟、牲畜和一切在地上爬行的动物，你都要带出来，使它们可以在地上滋生、繁殖，也可以在地上增多。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","于是，挪亚出来了，他的儿子、妻子和儿媳都与他一同出来了； ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","各样走兽、牲畜、飞禽和各样在地上爬行的动物，各从自己的族类，都出了方舟。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","挪亚给耶和华筑了一座祭坛，拿各样洁净的牲畜和飞禽，献在祭坛上作为燔祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","耶和华闻了那馨香的气味，就心里说：“我必不再因人的缘故咒诅这地（因为人从小时开始心中所想的都是邪恶的）；我也必不再照着我作过的，击杀各样的活物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","大地尚存之日，播种、收割，寒暑、冬夏、白昼和黑夜必然循环不息。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","神赐福给挪亚和他的儿子，对他们说：“你们要繁殖增多，充满大地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","地上各样的走兽，空中各样的飞鸟，甚至地上各样爬行的动物，和海里各样的鱼类，都要对你们惊恐惧怕；这一切都已经交在你们手里了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","所有活着的动物都可以作你们的食物，我把这一切都赐给你们，好像我把青菜赐给了你们一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","唯独带着生命的肉，就是带着血的肉，你们却不可吃。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","流你们的血、害你们生命的，我必向他们追偿；无论是走兽或人类，甚至各人自己的兄弟，我必要他偿命。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","流人血的，人也必流他的血；因为　神造人，是按着他自己的形象。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","你们要繁殖增多；要在地上滋生、增多。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","神告诉挪亚和与他在一起的儿子说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“看哪，我现在与你们和你们的后裔立约， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","并且与所有跟你们在一起有生命的活物立约，包括飞鸟、牲畜和所有地上的走兽，就是与从方舟里出来的立约。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","我要与你们立约：凡有生命的必不再被洪水除灭，再没有洪水来毁灭大地了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","神说：“这就是我与你们，与一切跟你们同在有生命的活物所立之约的记号，直到万代； ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","我把天虹放在云彩中，作我与大地立约的记号。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","我使云彩遮盖大地时，天虹出现云彩中， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","我就记念我与你们和一切有生命的活物所立的约：水不再成为洪水，来毁灭凡有生命的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","天虹在云彩中出现，我看见了就记念我与地上一切有生命的活物，所立的永约。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","神对挪亚说：“这就是我与地上凡有生命的立约的记号。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","挪亚的儿子，从方舟里出来的，就是闪、含、雅弗；含是迦南的父亲。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","这三个人是挪亚的儿子，全地的人都是从这些人播散开来的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","挪亚作起农夫来，栽种葡萄园。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","他喝酒，喝醉了，就在帐棚里光着身子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","迦南的父亲含看见了自己父亲的下体，就去告诉在外面的两个兄弟。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","于是，闪和雅弗二人拿了件外衣，搭在自己的肩膀上，倒退着进去，盖上他们父亲的下体；因为他们背着脸，所以没有看见他们父亲的下体。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","挪亚酒醒以后，知道小儿子对他所作的事， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","就说：“迦南应当受咒诅，他必给自己的兄弟，作奴仆的奴仆。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","又说：“耶和华，闪的　神，是应当称颂的；愿迦南作他的奴仆。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","愿　神使雅弗扩展，使雅弗住在闪的帐棚里；愿迦南作他的奴仆。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","洪水以后，挪亚又活了三百五十年。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","挪亚共活了九百五十岁，就死了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","以下是挪亚的儿子闪、含、雅弗的后代。洪水以后，他们都生了儿子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","雅弗的儿子是歌篾、玛各、玛代、雅完、土巴、米设、提拉。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","歌篾的儿子是亚实基拿、利法、陀迦玛。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","雅完的儿子是以利沙、他施，基提人和多单人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","这些人的后裔分散居住在沿海的土地和岛屿上。各人随着自己的方言、宗族，住在自己的国土中。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","含的儿子是古实、埃及、弗和迦南。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","古实的儿子是西巴、哈腓拉、撒弗他、拉玛和撒弗提迦。拉玛的儿子是示巴和底但。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","古实又生宁录；宁录是世上第一位英雄。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","他在耶和华面前是个英勇的猎人；因此有句俗语说：“就像宁录一样，在耶和华面前是个英勇的猎人。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","他开始建国是在示拿地的巴别、以力、亚甲和甲尼。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","他从那地出来，到亚述去，建造了尼尼微、利河伯城、迦拉， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","和尼尼微与迦拉之间的利鲜，就是那大城。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","埃及生路低人，亚拿米人、利哈比人、拿弗土希人、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","帕斯鲁细人、迦斯路希人和迦斐托人；从迦斐托出来的有非利士人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","迦南生了长子西顿，又生赫， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","以及耶布斯人、亚摩利人、革迦撒人、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","希未人、亚基人、西尼人、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","亚瓦底人、洗玛利人、哈马人，后来迦南人的宗族分散了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","迦南人的境界是从西顿伸向基拉耳，直到迦萨；又伸向所多玛、蛾摩拉、押玛、洗扁，直到拉沙。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","这些人都是含的子孙，随着自己的宗族、方言，住在自己的国土中。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","雅弗的哥哥闪，就是希伯所有子孙的祖宗，他也生了孩子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","闪的儿子是以拦、亚述、亚法撒、路德和亚兰。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","亚兰的儿子是乌斯、户勒、基帖、玛施。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","亚法撒生沙拉，沙拉生希伯。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","希伯生了两个儿子，一个名叫法勒，因为他在世的时候，世人就分散了；法勒的兄弟名叫约坍。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","约坍生亚摩答、沙列、哈萨玛非、耶拉、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","哈多兰、乌萨、德拉、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","俄巴路、亚比玛利、示巴、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","阿斐、哈腓拉、约巴，这些人都是约坍的儿子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","他们居住的地方，是从米沙伸向西发，直到东边的山地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","这都是闪的子孙，随着自己的宗族、方言，住在自己的国土中。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","这些宗族都是挪亚的子孙，按着他们的族系住在列国中。洪水以后，地上的列国都是从这些宗族分出来的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","那时，全世界只有一种语言，大家说同样的话语。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","他们向东迁移的时候，在示拿地发现一块平原，就住在那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","他们彼此说：“来，我们做砖，把砖烧透吧！”他们就把砖当作石头，又把石漆当作灰泥。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","他们又说：“来，我们建一座城，造一座塔，塔顶要通天。我们要为自己立名，免得分散在全地上。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","耶和华下来，要看看世人建造的城和塔。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","耶和华说：“看哪，他们同是一个民族，有一样的语言，他们一开始就作这事，以后他们所要作的一切，就没有可以拦阻他们的了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","来，我们下去，在那里混乱他们的语言，使他们听不懂对方的话。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","于是，耶和华把他们从那里分散到全地上，他们就停止建造那城。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","因此，那城的名就叫巴别，因为耶和华在那里混乱了全地所有的人的语言，又从那里把他们分散在全地上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","以下是闪的后代。洪水以后两年，闪一百岁的时候，生了亚法撒。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","闪生亚法撒以后，又活了五百年，并且生了其他的儿女。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","亚法撒活到三十五岁，就生了沙拉。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","亚法撒生沙拉以后，又活了四百零三年，并且生了其他的儿女。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","沙拉活到三十岁，就生了希伯。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","沙拉生希伯以后，又活了四百零三年，并且生了其他的儿女。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","希伯活到三十四岁，就生了法勒。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","希伯生法勒以后，又活了四百三十年，并且生了其他的儿女。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","法勒活到三十岁，就生了拉吴。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","法勒生拉吴以后，又活了二百零九年，并且生了其他的儿女。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","拉吴活到三十二岁，就生了西鹿。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","拉吴生西鹿以后，又活了二百零七年，并且生了其他的儿女。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","西鹿活到三十岁，就生了拿鹤。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","西鹿生拿鹤以后，又活了二百年，并且生了其他的儿女。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","拿鹤活到二十九岁，就生了他拉。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","拿鹤生他拉以后，又活了一百一十九年，并且生了其他的儿女。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","他拉活到七十岁，就生了亚伯兰、拿鹤和哈兰。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","以下是他拉的后代：他拉生亚伯兰、拿鹤和哈兰；哈兰生罗得。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","哈兰在他父亲他拉之前，死在他出生之地，就是迦勒底的吾珥。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","亚伯兰和拿鹤都娶了妻子；亚伯兰的妻子名叫撒莱；拿鹤的妻子名叫密迦，是哈兰的女儿；哈兰是密迦和亦迦的父亲。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","撒莱不能生育，没有孩子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","他拉带着他的儿子亚伯兰和他的孙子，就是哈兰的儿子罗得，以及他的媳妇亚伯兰的妻子撒莱，一同出了迦勒底的吾珥，要到迦南地去；他们到了哈兰，就住在那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","他拉死在哈兰；他的寿数共二百零五岁。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","耶和华对亚伯兰说：“你要离开本地、本族、父家，到我指示你的地方去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","我必使你成为大国，赐福给你，使你的名为大，你也必使别人得福， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","给你祝福的，我必赐福给他；咒诅你的，我必咒诅他；地上的万族，都必因你得福。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","亚伯兰就照着耶和华吩咐他的去了；罗得也和他同去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","亚伯兰离开哈兰的时候，已经七十五岁。亚伯兰带着他的妻子撒莱和侄儿罗得以及他们在哈兰所积蓄的一切财物，和所获得的人口，一同出来，要到迦南地去。后来他们到了迦南地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","亚伯兰穿过那地，到了示剑的地方，摩利的橡树那里。当时，迦南人住在那地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","耶和华向亚伯兰显现，说：“我要把这地赐给你的后裔。”亚伯兰就在那里为向他显现的耶和华筑了一座祭坛。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","后来他从那里迁到伯特利东边的山地，搭起帐棚。西边是伯特利，东边是艾城；他在那里也为耶和华筑了一座祭坛，呼求耶和华的名。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","亚伯兰又起程，渐渐移到南地去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","当时，那地发生饥荒，亚伯兰就下到埃及去，要在那里寄居；因为那地的饥荒十分严重。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","快要到达埃及的时候，亚伯兰对他的妻子撒莱说：“看哪，我知道你是个美貌的女人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","埃及人看见你的时候，必会说：‘这是他的妻子’，他们就会杀我，却叫你活着。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","请你说你是我的妹妹，使我因你的缘故可以平安无事，我的性命也可以因你的缘故得以保全。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","果然，亚伯兰进入埃及的时候，埃及人就注视那女人，因为她十分美丽。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","法老的一些大臣看见了撒莱，就在法老面前称赞她；于是那女人被带进法老的宫里去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","亚伯兰因这女人的缘故就被优待，得了许多牛羊、公驴、母驴、仆婢和骆驼。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","耶和华因为亚伯兰的妻子撒莱的缘故，就用严重的灾病打击法老和他的全家。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","于是，法老把亚伯兰召了来，对他说：“你向我作的是什么？你为什么不告诉我她是你的妻子呢？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","你为什么说她是你的妹妹，以致我娶了她作妻子呢？现在，你的妻子在这里，带她走吧！” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","法老吩咐臣仆，他们就把亚伯兰和他的妻子，以及他所有的一切都送走了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","亚伯兰带着妻子和所有的一切，以及罗得，一同从埃及上到南地去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","亚伯兰有很多牲畜和金银。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","他从南地一站一站往前走，到伯特利去；到伯特利和艾城中间，就是他从前支搭帐棚的地方， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","也是他筑头一座祭坛的地方，亚伯兰就在那里求告耶和华的名。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","和亚伯兰同行的罗得，也有羊群、牛群和帐棚。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","那地容不下他们住在一起；因为他们的财物很多，所以他们再也不能住在一起。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","牧养亚伯兰牲畜的和牧养罗得牲畜的，起了纷争；当时迦南人和比利洗人还住在那地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","亚伯兰就对罗得说：“你我之间，切不可纷争；你的牧人和我的牧人之间，也不可纷争，因为我们是至亲。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","全地不都是在你面前吗？请你离开我吧！你若向左，我就向右；你若向右，我就向左。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","罗得举目，看见约旦河整个平原，直到琐珥，都有水灌溉；在耶和华毁灭所多玛和蛾摩拉之前，这地好像耶和华的园子，也像埃及地一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","罗得选择了约旦河整个平原，于是向东移动，他们就彼此分开了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","亚伯兰住在迦南地；罗得住在平原的城市中，渐渐挪移帐棚，直到所多玛。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","在耶和华看来，所多玛人是罪大恶极的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","罗得离开亚伯兰以后，耶和华对亚伯兰说：“你要举目，从你所在的地方向东南西北观看。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","你看见的地方，我都要赐给你和你的后裔，直到永远。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","我要使你的后裔好像地上灰尘那么多；若能数算地上的灰尘，才能数算你的后裔。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","你起来，纵横走遍这地，因为我必把这地赐给你。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","于是，亚伯兰渐渐挪移帐棚，来到希伯仑幔利的橡树附近，在那里居住，也在那里为耶和华筑了一座祭坛。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","当暗拉非作示拿王，亚略作以拉撒王，基大老玛作以拦王，提达作戈印王的时候， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","他们兴兵攻打所多玛王比拉、蛾摩拉王比沙、押玛王示纳、洗扁王善以别和比拉王。比拉就是琐珥。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","这五王在西订谷会合。西订谷就是盐海。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","他们服事了基大老玛已经有十二年，到第十三年就背叛了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","第十四年基大老玛和同盟的王都来了，在亚特律．加宁击败了利乏音人，在哈麦击败了苏西人，在沙微．基列亭击败了以米人， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","在何利人的西珥山击败了何利人，一直追击到靠近旷野的伊勒．巴兰。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","然后转到安．密巴，就是加低斯，攻占了亚玛力人全部的领土，也击败了住在哈洗逊．他玛的亚摩利人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","于是所多玛王、蛾摩拉王、押玛王、洗扁王和比拉王（比拉就是琐珥）都出来，在西订谷列阵，与他们交战； ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","就是与以拦王基大老玛、戈印王提达、示拿王暗拉非、以拉撒王亚略交战，就是四王与五王交战。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","西订谷有许多漆坑。所多玛王和蛾摩拉王逃跑的时候，都掉在坑里，其余的人都向着山上逃跑。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","四王就把所多玛和蛾摩拉所有的财物，以及一切粮食都拿走， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","连亚伯兰的侄儿罗得和罗得的财物也带走了。当时，罗得住在所多玛。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","有一个逃出来的人，跑来告诉希伯来人亚伯兰。那时，亚伯兰住在亚摩利人幔利的橡树那里。幔利和以实各，以及亚乃，都是兄弟；他们都是亚伯兰的盟友。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","亚伯兰一听见侄儿被人掳去，就抽调他家里生养的精练壮丁三百一十八人，一直追到但。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","亚伯兰和他的仆人漏夜分队攻击他们，结果击败了他们，又追赶他们直到大马士革北面的何把， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","将一切财物都夺回来，也把他的侄儿罗得和罗得的财物，以及妇女和族人，都夺了回来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","亚伯兰击败了基大老玛和与他联盟的王回来的时候，所多玛王出来，在沙微谷迎接他。沙微谷就是帝王谷。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","撒冷王麦基洗德也带着饼和酒出来；他是至高　神的祭司。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","他给亚伯兰祝福，说：“愿创造天地的主、至高的　神，赐福给亚伯兰。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","把敌人交在你手里的至高的　神，是应当称颂的！”亚伯兰就把所得的一切，拿出十分之一来，给了麦基洗德。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","所多玛王对亚伯兰说：“请你把人交给我，至于财物，你拿去吧。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","亚伯兰对所多玛王说：“我已经向创造天地的主、至高的　神耶和华举手起誓； ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","凡是你的东西，就是一根线，一条鞋带，我也不拿，免得你说：‘我使亚伯兰发了财。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","我什么都不要，除了仆人吃掉的以外，但与我同行的亚乃、以实各、幔利所应得的分，让他们拿去吧。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","这些事以后，耶和华的话在异象中临到亚伯兰说：“亚伯兰，你不要惧怕，我是你的盾牌；你的赏赐是很大的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","亚伯兰说：“主耶和华啊，我一向都没有孩子，你还能赐给我什么呢？这样，承受我家业的，就是大马士革人以利以谢了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","亚伯兰又说：“你既然没有给我后裔，那生在我家中的人，就是我的继承人了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","耶和华的话又临到亚伯兰说：“这人必不会作你的继承人；你亲生的才会是你的继承人。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","于是领他到外面去，说：“你向天观看，数点众星，看你能不能把它们数得清楚。”又对他说：“你的后裔将要这样众多。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","亚伯兰信耶和华，耶和华就以此算为他的义了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","耶和华又对亚伯兰说：“我是耶和华，曾经把你从迦勒底的吾珥领出来，为要把这地赐给你作产业。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","亚伯兰说：“主耶和华啊，我凭什么能知道我必得这地为业呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","耶和华对他说：“你给我拿一头三岁的母牛，一只三岁的母山羊，一只三岁的公绵羊，一只斑鸠和一只雏鸽。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","亚伯兰就把这一切拿了来，每样都从当中劈开，一半一半相对摆列；只是鸟却没有劈开。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","有鸷鸟下来，落在这些尸骸上，亚伯兰就把它们吓走了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","日落的时候，亚伯兰沉沉地睡着了，忽然有可怕的大黑暗落在他身上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","耶和华对亚伯兰说：“你要确实地知道，你的后裔必在外地寄居，也必服事那地的人，那地的人苦待他们四百年。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","他们所要服事的那国，我要亲自惩罚。后来他们必带着很多财物，从那里出来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","你必得享长寿，被人埋葬，平平安安地回到你列祖那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","到了第四代，他们必回到这里，因为亚摩利人的罪孽还没有满盈。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","日落天黑的时候，忽然有冒烟的炉和烧着的火把，从那些肉块中经过。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","就在那时候，耶和华与亚伯兰立约说：“我已经把这地赐给你的后裔了，就是从埃及河直到幼发拉底河之地； ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","就是基尼人、基尼洗人、甲摩尼人、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","赫人、比利洗人、利乏音人、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","亚摩利人、迦南人、革迦撒人、耶布斯人之地。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","亚伯兰的妻子撒莱，没有为他生孩子。撒莱却有一个婢女，是埃及人，名叫夏甲。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","撒莱对亚伯兰说：“请看，耶和华使我不能生育，求你去亲近我的婢女，或者我可以从她得孩子。”亚伯兰就听从了撒莱的话。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","亚伯兰在迦南地住满了十年，他的妻子撒莱，把自己的婢女埃及人夏甲，给了她的丈夫亚伯兰为妾。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","亚伯兰与夏甲亲近，夏甲就怀了孕。夏甲见自己有了孕，就轻看她的主母。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","撒莱对亚伯兰说：“我因你受屈；我把我的婢女送到你的怀中，她见自己有了孕，就轻看我。愿耶和华在你我之间主持公道。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","亚伯兰对撒莱说：“你的婢女在你手中，你看怎样好，就怎样待她吧。”于是撒莱虐待夏甲，她就从撒莱面前逃走了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","耶和华的使者在旷野的水泉旁边，就是在到书珥路上的水旁边，遇到了她， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","就问她：“撒莱的婢女夏甲啊，你从哪里来？要到哪里去？”夏甲回答：“我从我的主母撒莱面前逃出来。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","耶和华的使者对她说：“回到你主母那里去，服在她的手下！” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","耶和华的使者又对她说：“我必使你的后裔人丁兴旺，多到不可胜数。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","耶和华的使者再对她说：“看哪，你已经怀了孕，你要生一个儿子；你要给他起名叫以实玛利，因为耶和华听见了你的苦情。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","他将来为人，必像野驴。他的手要攻打人，人的手也要攻打他。他必住在众兄弟的东面。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","于是，夏甲给那对她说话的耶和华，起名叫“你是看顾人的　神”，因为她说：“在这里我不是也看见了那位看顾人的吗？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","因此，这井名叫庇耳．拉海．莱，是在加低斯和巴列之间。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","夏甲给亚伯兰生了一个儿子，亚伯兰就给夏甲所生的儿子，起名叫以实玛利。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","亚伯兰八十六岁的时候，夏甲给他生了以实玛利。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","亚伯兰九十九岁的时候，耶和华向他显现，对他说：“我是全能的　神，你要在我面前行事为人；你要作完全人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","我要与你立约，要使你的后裔人丁兴旺。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","于是亚伯兰俯伏在地，　神又告诉他，说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“看哪，这就是我和你所立的约：你要作多国的父。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","你的名不要再叫亚伯兰，要叫亚伯拉罕，因为我已经立了你作万国的父。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","我要使你极其昌盛，国度因你而立，君王必从你而出。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","我要与你，和你世世代代的后裔，坚立我的约，成为永远的约，使我作你和你的后裔的　神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","我要把你现在寄居的地，就是迦南全地，赐给你和你的后裔，作永远的产业，我也要作他们的　神。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","神又对亚伯拉罕说：“你和你世世代代的后裔都要谨守我的约。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","我与你和你的后裔所立的这约，是你们应当谨守的，就是你们所有的男子，都要受割礼。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","你们都要割去身上的包皮，这就是我与你们立约的记号了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","你们中间世世代代所有的男子，无论是在家里生的，或是用银子从不是属你后裔的外族人买来的，生下来第八日都要受割礼。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","在你家里生的，和你用银子买来的，都一定要受割礼。这样，我的约就刻在你们身上，作永远的约。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","但不受割礼的男子，就是没有割去身上的包皮的，那人必从民中剪除，因为他违背了我的约。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","神又对亚伯拉罕说：“至于你的妻子撒莱，不要再叫她的名撒莱，要叫撒拉。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","我必赐福给她，也必使她为你生一个儿子；我要赐福给她，她也要作多国的母，万族的君王必从她而出。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","亚伯拉罕就俯伏在地，笑了起来，心里说：“一百岁的人，还能生孩子吗？撒拉已经九十岁了，还能生育吗？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","亚伯拉罕对　神说：“愿以实玛利能在你面前活着！” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","神说：“你的妻子撒拉，真的要为你生一个儿子，你要给他起名叫以撒，我要与他坚立我的约，作他后裔的永约。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","至于以实玛利，我也应允你。看哪，我已经赐福给他；我必使他昌盛，子孙极其众多；他必生十二个族长；我也必使他成为大国。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","但我的约是要和以撒坚立的。这以撒，就是明年这时候，撒拉要为你生的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","神和亚伯拉罕说完了话，就离开他上升去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","就在那一天，亚伯拉罕照着　神吩咐他的，给他儿子以实玛利，和他家里所有的男子，无论是在家里生的，或是用银子买来的，都割去了他们身上的包皮。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","亚伯拉罕九十九岁的时候，割去了他身上的包皮。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","他的儿子以实玛利十三岁的时候，割去了他身上的包皮。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","就在那一天，亚伯拉罕和他的儿子以实玛利，都受了割礼。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","亚伯拉罕家里所有的男人，无论是在家里生的，或是用银子从外族人买来的，都与他一同受了割礼。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","耶和华在幔利橡树那里，向亚伯拉罕显现。那时，是一天中最热的时候，亚伯拉罕正坐在帐棚门口； ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","他举目观看，忽然看见三个人在他对面站着；亚伯拉罕看见了，就从帐棚门口跑去迎接他们，俯伏在地， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","说：“我主啊，我若在你眼前蒙恩，求你不要离开你的仆人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","让我叫人拿点水来，你们可以洗洗脚，然后在树下歇一歇。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","让我拿点饼来给你们吃，使你们可以恢复精力，然后再走，因为你们既然到了仆人这里来，就应该这样。”他们说：“就照着你所说的去作。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","亚伯拉罕赶快进帐棚，到撒拉那里，说：“你快拿三斗细面调和，作些饼。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","亚伯拉罕又跑到牛群里，牵了一头又嫩又好的牛犊，交给仆人；仆人就赶快去预备。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","亚伯拉罕又拿了乳酪、奶和预备好的牛犊肉来，摆在他们面前。他们吃的时候，亚伯拉罕在树下侍候他们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","他们问亚伯拉罕：“你的妻子撒拉在哪里？”他回答：“在帐棚里。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","其中一位说：“到明年这个时候，我必回到你这里来。那时，你的妻子撒拉必生一个儿子。”撒拉在那人后面的帐棚门口，也听见了这话。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","当时，亚伯拉罕和撒拉都老了，撒拉的月经也停止了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","撒拉心里暗笑，说：“现在我已经衰老了，我的丈夫也老了，我还有房事的乐趣吗？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","耶和华对亚伯拉罕说：“撒拉为什么暗笑说：‘我已经老了，真的还能生育吗？’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","耶和华岂有难成的事吗？到明年这个时候，我要回到你这里来，那时，撒拉必生一个儿子。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","撒拉害怕起来，就否认，说：“我没有笑。”但那位说：“不，你实在笑了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","三人就从那里起身，向着所多玛观望。亚伯拉罕与他们同行，要送他们一程。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","耶和华说：“我要作的事，岂可瞒着亚伯拉罕呢？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","亚伯拉罕必要成为强大兴盛的国，地上的万国，都必因他得福。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","我拣选了他，是要他吩咐子孙，和他的家属，遵守我耶和华的道，秉公行义，好叫我耶和华应许亚伯拉罕的话都可实现。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","耶和华说：“控告所多玛和蛾摩拉的声音甚大，他们的罪恶极重。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","我现在要下去，看看他们所行的，是不是全像那声闻于我的控告；如果不是，我也会知道的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","其中二人从那里动身，向所多玛走去，亚伯拉罕却仍然站在耶和华面前。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","亚伯拉罕上前说：“你真的要把义人和恶人一同除灭吗？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","假如城中有五十个义人，你还真的要除灭那地方，不为城里的五十个义人而赦免那地方吗？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","你绝不会作这样的事：把义人与恶人一同杀死，把义人和恶人一样看待，你绝不会这样！审判全地的主，岂可不行公义吗？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","耶和华说：“我若在所多玛城中找到五十个义人，我就因他们的缘故，赦免那地方所有的人。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","亚伯拉罕回答，说：“我虽然是灰尘，还大胆地对我主说话。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","假如这五十个义人中缺少了五个，你会因为缺少了五个就毁灭全城吗？”他说：“我若在那里找到四十五个，我也不会毁灭那城。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","亚伯拉罕再问他说：“假如在那里找到四十个呢？”他回答：“我因这四十个的缘故，也不这样作。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","亚伯拉罕说：“请我主不要动怒，容我再问：‘假如在那里找到三十个呢？’”他回答：“我若在那里找到三十个，也不这样作。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","亚伯拉罕说：“我再大胆地对我主说，假如在那里找到二十个呢？”他回答：“我因这二十个的缘故，也不毁灭那城。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","亚伯拉罕说：“请我主不要动怒，容我问这最后的一次，假如在那里找到十个呢？”他回答：“我因这十个的缘故，也不毁灭那城。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","耶和华与亚伯拉罕说完了话，就走了；亚伯拉罕也回到自己的地方去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","黄昏的时候，那两位天使到了所多玛，当时罗得正坐在所多玛的城门口。罗得一看见他们，就起来迎接他们，俯伏在地， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","说：“我主啊，请你们到仆人的家里住一夜，洗洗你们的脚，清早起来再赶路。”他们回答：“不，我们要在街上过夜。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","但由于罗得再三的请求，他们才肯跟他回去，进了他的家。罗得为他们预备了筵席，烤了无酵饼，他们就吃了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","他们还没有躺下睡觉，那城里的人，就是所多玛的男人，无论是年轻的或是年老的，都从各处来围住罗得的房子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","他们呼唤罗得，对他说：“今晚到你这里来的人在哪里？把他们带出来，我们要与他们同房。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","罗得出来，随手把门关上，到门口众人那里， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","说：“我的弟兄们，请不要作恶。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","看哪，我有两个女儿，是还没有和男人同房的，让我把她们带出来，你们高兴怎样待她们，就怎样行吧！只是这两个人，因为他们是到舍下来的，你们不可向他们作什么。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","众人却说：“滚开！”又说：“一个来这里寄居的人，竟作起审判官来；现在我们要害你，比害他们还要厉害。”众人就向罗得极力拥挤，他们冲前要打破房门。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","那两个人却伸出手来，把罗得拉进屋里去，并把门关上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","然后击打那些门外的人，使他们无论老少，都眼目昏眩，以致找不到门口。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","那二人对罗得说：“你这里还有什么人没有？无论是女婿、儿女，或是城中所有属你的人，都要把他们从这地方带走。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","我们快要毁灭这地方了，因为控告他们的声音在耶和华面前实在很大，所以耶和华派我们来毁灭这地方。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","于是罗得出去，告诉娶了他女儿的女婿说：“你们起来离开这地方；因为耶和华就要毁灭这城。”但是他的女婿以为他在开玩笑。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","天快亮的时候，两位天使催促罗得说：“起来，带你的妻子，和你这里的两个女儿出去，免得你因这城的罪孽被除灭。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","罗得还在犹豫不决的时候，二人因为耶和华宽容罗得，就拉着罗得的手，和他妻子的手，以及他两个女儿的手，把他们带出来，安置在城外。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","二人把他们带出来以后，其中一位说：“逃命吧，不要回头看，也不可留在这片平原上，要逃到山上去，免得你被除灭。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","罗得对他们说：“我主啊！请不要这样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","看哪，你仆人既然在你眼前蒙恩，你又向我大施慈爱，救活我的性命；可是我还逃不到山上，恐怕这灾祸就追上了我，我就死了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","看哪，这座城很近，可以逃到那里，那只是一座小城，请让我逃到那里去。那不是一座小城吗？这样我就可以活命了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","有一位天使对他说：“这事我也答应你，你所说的这城，我必不倾覆。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","你赶快逃到那里去，因为你还没有到达那里，我就不能作什么。”因此那城名叫琐珥。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","罗得到达琐珥的时候，太阳已经从地面升上来了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","当时，耶和华就使硫磺与火，从天上耶和华那里降与所多玛和蛾摩拉； ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","把那些城和全平原，以及城中所有的居民，连地上生长的，都毁灭了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","罗得的妻子向后一望，就变成了盐柱。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","亚伯拉罕清早起来，到他从前站在耶和华面前的地方， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","向所多玛和蛾摩拉，以及平原全地观望。不料，看见那地有烟上升，好像烧窑的烟一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","神毁灭那平原上的众城，倾覆罗得所住过的众城的时候，　神记念亚伯拉罕，把罗得从倾覆中救出来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","罗得因为怕住在琐珥，就与他的两个女儿，一同离开琐珥上了山，住在那里；他和两个女儿住在一个洞里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","大女儿对小女儿说：“我们的爸爸已经老了，这地又没有男人可以按着世上的常规进来与我们亲近。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","来吧，我们可以叫父亲喝酒，然后与他同睡，这样我们可以借着父亲保全后裔。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","当夜，她们叫父亲喝酒，大女儿就进去与父亲同睡，她什么时候躺下，什么时候起来，她父亲都不知道。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","第二天，大女儿对小女儿说：“昨夜我与父亲同睡了，今夜我们再叫父亲喝酒，你可以进去与他同睡，这样我们可以借着父亲保全后裔。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","当夜，她们又叫父亲喝酒，小女儿就起来，与父亲同睡；她什么时候躺下，什么时候起来，她父亲都不知道。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","这样，罗得的两个女儿，都从她们的父亲怀了孕。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","大女儿生了一个儿子，给他起名叫摩押，就是现在摩押人的始祖。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","小女儿也生了一个儿子，给他起名叫便．亚米，就是现在亚扪人的始祖。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","亚伯拉罕从那里迁到南地，就住在加低斯和书珥中间。亚伯拉罕寄居在基拉耳的时候， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","曾经提到他的妻子撒拉说：“她是我的妹妹。”于是基拉耳王亚比米勒派人来把撒拉取了去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","当夜，　神在梦中来到亚比米勒那里，对他说：“你该死，因为你接来的那女人，是个有夫之妇。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","亚比米勒还没有亲近撒拉，所以他说：“我主啊，连正义的人你也要杀害吗？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","那人岂不是对我说：‘她是我的妹妹’吗？就是那女人自己也说：‘他是我的哥哥’。我作这事，是手洁心清的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","神在梦中对他说：“我也知道你作这事，是问心无愧的，所以我也阻止你，免得你得罪我。因此我不容许你接触她。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","现在你要把那人的妻子还给他，因为他是先知，他要为你祷告，你才可以存活。你若不还给他，你当知道，你和所有属你的，都死定了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","亚比米勒清早起来，召了他的众臣仆来，把这一切都说给他们听，以致他们都很惧怕。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","亚比米勒把亚伯拉罕召了来，对他说：“你为什么向我们这样行呢？我在什么事上得罪了你，以致你给我和我的国带来这个大罪呢？你对我作了不应该作的事。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","亚比米勒又对亚伯拉罕说：“你为了什么缘故要这样作呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","亚伯拉罕回答：“因为我以为这地方必定没有敬畏　神的人，他们会因我妻子的缘故杀我。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","何况她也实在是我的妹妹；她原是我同父异母的妹妹，后来作了我的妻子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","神叫我离开我父家，在外飘流的时候，我对她说：‘我们无论到什么地方去，你都要对人说：“他是我的哥哥。”这就是你待我的恩情了。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","亚比米勒取了些牛羊、仆婢，送给亚伯拉罕，又把亚伯拉罕的妻子撒拉还给他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","亚比米勒说：“看哪，我的国土都在你面前，你喜欢哪里，就住在哪里吧。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","他又对撒拉说：“看哪，我给了你哥哥一千银子，作你在全家人面前的遮羞钱。这样，你在众人面前就算清白了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","亚伯拉罕祷告　神，　神就医好了亚比米勒和他的妻子，以及他的众婢女，使她们能生育。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","因为耶和华为了亚伯拉罕妻子撒拉的缘故，曾经使亚比米勒家中所有的妇女，都不能生育。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","耶和华照着以前所说的，眷顾撒拉；耶和华按着他的应许，给撒拉作成。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","亚伯拉罕年老的时候，撒拉怀了孕，到了　神应许的日期，就给亚伯拉罕生了一个儿子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","亚伯拉罕给撒拉为他所生的儿子，起名叫以撒。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","亚伯拉罕的儿子以撒生下来第八天，亚伯拉罕就照着　神吩咐他的，给以撒行了割礼。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","他儿子以撒出生的时候，亚伯拉罕正一百岁。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","撒拉说：“　神使我欢笑，凡听见的，也必为我欢笑。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","又说：“谁能告诉亚伯拉罕，撒拉要乳养儿女呢？在他年老的时候，我竟给他生了一个儿子。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","孩子渐渐长大，就断了奶。以撒断奶的那天，亚伯拉罕摆设盛大的筵席。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","撒拉看见那埃及人夏甲给亚伯拉罕所生的儿子在嬉戏，就对亚伯拉罕说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","“把这婢女和她的儿子赶出去，因为这婢女的儿子不能和我的儿子以撒一同承受产业。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","亚伯拉罕因他的儿子而非常烦恼。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","神对亚伯拉罕说：“不要因这童子和你的婢女而烦恼。撒拉对你说的话，你都要听从；因为以撒生的，才可以称为你的后裔。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","至于这婢女的儿子，我也要使他成为一国，因为他也是你的后裔。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","亚伯拉罕清早起来，拿饼和一皮袋水，给了夏甲，放在她的肩膀上，又把孩子交给她，就打发她离开。夏甲走了，在别是巴的旷野飘荡。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","皮袋里的水用尽了，夏甲就把孩子撇在一棵小树底下。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","然后自己走开，在离开约有一箭之远的地方，相对而坐，说：“我不忍眼看孩子死去。”就相对坐着，放声大哭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","神听见了童子的声音，他的使者就从天上呼叫夏甲，对她说：“夏甲啊，你为什么这样呢？不要害怕，因为孩子在那里所发的声音　神已经听见了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","起来，扶起孩子，尽力保护他；因为我要使他成为大国。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","神开了夏甲的眼睛，她就看见一口水井。她去把皮袋盛满了水，就给孩子喝。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","神与孩子同在，他渐渐长大，住在旷野，成了个弓箭手。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","他住在巴兰的旷野，他的母亲从埃及地给他娶了一个妻子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","那时，亚比米勒和他的军长非各对亚伯拉罕说：“在你所作的一切事上，　神都与你同在。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","现在你要在这里指着　神对我起誓，你不会以诡诈待我和我的子子孙孙。我怎样恩待了你，你也要怎样恩待我和你寄居的地方。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","亚伯拉罕回答：“我愿意起誓。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","亚伯拉罕因亚比米勒的仆人强占了一口水井，就指责亚比米勒。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","亚比米勒说：“谁作了这事，我不知道，你都没有告诉我；我现在才听见。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","于是亚伯拉罕牵了牛羊来，送给亚比米勒，二人就彼此立约。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","亚伯拉罕把羊群中的七只母羊羔，放在另外一处。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","亚比米勒问亚伯拉罕：“你把这七只母羊羔放在另外一处，是什么意思呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","亚伯拉罕回答：“意思就是：你从我手里接受这七只母羊羔，好作我挖了这口井的证据。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","因此那地方名叫别是巴，因为他们二人在那里起了誓。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","他们在别是巴立约以后，亚比米勒和他的军长非各，就起程回非利士地去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","亚伯拉罕在别是巴栽了一棵垂丝柳树，就在那里求告耶和华永活的　神的名。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","亚伯拉罕在非利士人的地方寄居了许多日子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","这些事以后，　神试验亚伯拉罕，对他说：“亚伯拉罕啊！”他回答：“我在这里。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","神说：“带着你的儿子，就是你所爱的独生子以撒，到摩利亚地去，在我所要指示你的一座山上，把他献为燔祭。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","亚伯拉罕清早起来，预备好了驴，带着两个童仆和自己的儿子以撒，也劈好了献燔祭用的柴，就起程到　神指示他的地方去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","第三日，亚伯拉罕举目观望，远远地看见了那地方。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","亚伯拉罕对他的童仆说：“你们和驴留在这里，我与孩子要到那边去敬拜，然后回到你们这里来。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","亚伯拉罕把献燔祭的柴，放在他儿子以撒的身上，自己手里拿着火与刀。他们二人一起向前走的时候， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","以撒问他父亲亚伯拉罕说：“爸爸！”亚伯拉罕回答：“我儿！有什么事？”以撒说：“你看，火与柴都有了，可是献燔祭用的羊羔在哪里呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","亚伯拉罕回答：“我儿，　神自己必亲自预备献燔祭用的羊羔。”于是二人继续一起前行。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","他们到了　神指示的地方，亚伯拉罕就在那里筑了一座祭坛，摆好了柴，捆绑了自己的儿子以撒，就把他放在祭坛的柴上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","亚伯拉罕伸手拿刀，要宰杀自己的儿子的时候， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","耶和华的使者从天上呼叫亚伯拉罕，说：“亚伯拉罕，亚伯拉罕！”亚伯拉罕回答：“我在这里。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","天使说：“不可在这孩子身上下手，一点也不可害他；现在我知道你是敬畏　神的了，因为你没有留下你的独生子不给我。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","亚伯拉罕举目观望，看见一只公绵羊，两角扣在稠密的小树丛中；亚伯拉罕就去取了那只公绵羊，把它献为燔祭，代替自己的儿子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","亚伯拉罕给那地方起名叫“耶和华以勒”。直到今日，人还说：“在耶和华的山上必有预备。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","耶和华的使者第二次从天上呼叫亚伯拉罕， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","说：“耶和华说：‘我指着自己起誓，你既然作了这事，没有留下你的独生子， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","我必定赐福给你，必使你的后裔繁多，像天上的星，海边的沙；你的后裔必占领仇敌的城门。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","地上万国都要因你的后裔得福，因为你听从了我的话。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","亚伯拉罕回到他的童仆那里；他们就起程，一起到别是巴去了；亚伯拉罕就住在别是巴。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","这些事以后，有人告诉亚伯拉罕说：“密迦也给你的兄弟拿鹤生了几个儿子； ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","长子是乌斯，他的弟弟是布斯，和亚兰的父亲基母利； ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","还有基薛、哈琐、必达、益拉和彼土利。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","（彼土利生了利百加。）”这八个人，都是密迦给亚伯拉罕的兄弟拿鹤生的儿子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","拿鹤的妾名叫流玛。她也生了提八、迦含、他辖和玛迦。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","撒拉享寿一百二十七岁，这是撒拉一生的岁数。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","撒拉死在迦南地的基列．亚巴，就是希伯仑；亚伯拉罕为撒拉哀恸哭号。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","亚伯拉罕从死者面前起来，对赫人说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“我是在你们中间寄居的外族人，求你们在你们中间给我一块坟地作产业，使我可以埋葬我死了的人，使她不露在我面前。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","赫人回答亚伯拉罕，说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“我主请听，你在我们中间是一位尊贵的王子，你可以在我们最好的坟地里埋葬你死了的人，我们必没有人阻止你在他的坟地埋葬你死了的人。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","于是，亚伯拉罕起来，向当地的赫人下拜， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","对他们说：“你们若有意使我埋葬我死了的人，使她不露在我的眼前，就请听我的话，为我请求琐辖的儿子以弗仑， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","叫他把他所拥有的，田头上那麦比拉洞卖给我。他可以按着十足的价银卖给我，使我在你们中间有产业作坟地。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","那时，以弗仑正坐在赫人中间。于是，赫人以弗仑就回答亚伯拉罕，所有来到城门口的赫人都听见他说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“我主，不要这样，请听我说，这块田我送给你，连其中的洞我也送给你。我在我的族人眼前送给你，让你可以埋葬你死了的人。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","亚伯拉罕就在当地的人面前下拜， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","然后在当地的人面前对以弗仑说：“请听我说，如果你愿意，我必定把地的价银给你，请你收下吧，让我可以在那里埋葬我死了的人。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","以弗仑回答亚伯拉罕，对他说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“我主，请听我说，一块值四百块（四千五百克）银子的田地，在你我之间，算得什么呢？你埋葬你死了的人吧。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","亚伯拉罕同意以弗仑说的价银，就照着他在赫人面前所说的，拿商人通用的银子，称了四百块（四千五百克）银子给以弗仑。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","于是，以弗仑在麦比拉，在幔利前面的那块地，包括那块田和其中的洞，田中和四周所有的树木， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","都在赫人眼前，就是在所有来到城门口的赫人眼前，归给亚伯拉罕作产业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","这事以后，亚伯拉罕把自己的妻子撒拉埋在迦南地，幔利前面麦比拉田间的洞里。幔利就是希伯仑。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","这样，那块田和田中的洞，就从赫人归给了亚伯拉罕为产业作坟地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","亚伯拉罕老迈了，年事已高，耶和华在一切事上都赐福给他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","亚伯拉罕对他家中，管理所有产业的老仆人说：“请把你的手放在我的大腿底下。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","我要你指着耶和华天地的　神起誓，不可从我现在居住的迦南人中，为我的儿子娶他们的女子为妻。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","你却要到我的故乡、我的亲族那里去，为我的儿子以撒娶妻。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","仆人问亚伯拉罕：“如果那女子不愿跟我到这地方来，我必须把你的儿子带回你原出之地去吗？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","亚伯拉罕对他说：“你要谨慎，切不可带我的儿子回到那里去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","耶和华天上的　神，就是领我离开我的父家和我亲族之地，曾经对我说话，又向我起誓的那位说：‘我必把这地赐给你的后裔。’他必在你前面差派他的使者，你就可以从那里为我的儿子娶妻。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","如果那女子不愿跟你来，我叫你所起的这誓就与你无关了。只是不可带我的儿子回到那里去。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","于是，仆人把手放在他主人亚伯拉罕的大腿下，为这事向亚伯拉罕起誓。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","那仆人从他主人的骆驼里取了十匹骆驼，带着主人各样的美物，起程往两河之间的亚兰去，到了拿鹤的城。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","黄昏时分，女人出来打水的时候，那仆人就叫骆驼跪在城外的水井旁边， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","然后祷告说：“耶和华我主人亚伯拉罕的　神啊，求你今日使我遇见好机会，施慈爱给我的主人亚伯拉罕。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","我现在站在水泉旁边，城内居民的女儿正出来打水。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","我对哪一个少女说：‘请你放下水瓶来，让我喝点水。’如果她回答：‘请喝，我也给你的骆驼喝。’愿那少女就作你选定给你仆人以撒的妻子。这样，我就知道你施慈爱给我的主人了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","话还没有说完，不料，利百加肩头上扛着水瓶出来了。利百加是彼土利所生的。彼土利是亚伯拉罕兄弟拿鹤的妻子密迦的儿子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","那少女容貌非常美丽，还是个处女，没有男人亲近过她。她下到水泉那里，打满了水瓶，又上来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","仆人就跑去迎着她，说：“请你把瓶里的水给我喝一点。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","那少女回答：“我主请喝。”就急忙把水瓶拿下来，托在手上给他喝。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","他喝足了，少女就说：“我也要为你的骆驼打水，直到它们都喝足了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","于是急忙把水瓶里的水倒在槽里，又跑到井旁去打水，给他所有的骆驼打上水来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","那人一句话也不说，只注视着她，要知道耶和华使他的道路亨通不亨通。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","骆驼喝足了，那人就拿出一个重近六克的金鼻环，戴在她的鼻子上，又拿出两个重一百一十四克的金手镯，套在她的手上， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","然后问她：“请你告诉我，你是谁的女儿？你父亲的家里有地方给我们住宿没有？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","她回答：“我是密迦给拿鹤所生的儿子彼土利的女儿。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","她又说：“我们有很多粮草和饲料，也有住宿的地方。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","那人就跪下敬拜耶和华， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","说：“耶和华我主人亚伯拉罕的　神是应当称颂的，因为他不断以慈爱和信实待我的主人；耶和华也一路引导我，到了我主人的兄弟家里。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","那少女就跑回去，把这些事都告诉了她母亲家里的人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","利百加有一个哥哥，名叫拉班。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","他看见了妹妹的鼻环和手上的手镯，又听见了妹妹利百加说：“那人对我这样这样说”，就跑去见外面水泉旁边的那人。他来到那人跟前的时候，见他仍然站在骆驼旁边的水泉那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","拉班说：“你这蒙耶和华赐福的，请进来吧，为什么站在外面呢？我已经收拾好了房间，也为骆驼预备了地方。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","那人就进了拉班的家。拉班卸了骆驼，拿粮草和饲料给骆驼吃，又拿水给那人和与他同来的人洗脚。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","然后在他面前摆上食物，但那人说：“除非等我说完了我的事，我不会吃。”拉班说：“请说。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","那人说：“我是亚伯拉罕的仆人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","耶和华厚厚地赐福我主人，他就昌大起来；耶和华又赐给他羊群、牛群、金银、仆婢、骆驼和驴。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","我主人的妻子撒拉年老的时候，给我主人生了一个儿子。我主人也把他一切所有的都给了这个儿子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","我主人要我起誓，说：‘你不可从我现在居住的迦南地中，为我的儿子娶迦南的女子为妻。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","你要到我的父家，和我的族人那里去，为我的儿子娶一个妻子。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","我问我主人：‘如果那女子不愿跟我回来呢？’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","他回答：‘我行事为人都在他面前的耶和华，必差派他的使者与你同去，使你的道路亨通，你就可以从我的族人和我的父家，给我的儿子娶一个妻子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","只要你到了我的族人那里去，我叫你起的誓就与你无关；他们若不把女子交给你，我叫你起的誓也与你无关。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","我今天到了水泉那里，就说：‘耶和华我主人亚伯拉罕的　神啊，你若叫我所走的道路亨通， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","那么，我现在站在水泉旁边，但愿有一个少女出来打水，我要对她说：“请你把瓶里的水给我喝一点。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","她若对我说：“你请喝，我还要打水给你的骆驼喝。”愿那女子就作耶和华给我主人的儿子所选定的妻子。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","我心里的话还没有说完，利百加就肩头扛着水瓶出来了，她下到水泉那里去打水；我就对她说：‘请给我水喝。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","她急忙从肩上拿下水瓶来，说：‘请喝，我还要给你的骆驼喝。’我喝了，她也打水给我的骆驼喝。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","于是我问她，说：‘你是谁的女儿？’她回答：‘我是密迦给拿鹤所生的儿子彼土利的女儿。’我就把鼻环戴在她的鼻子上，把手镯套在她的两手上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","然后我跪下敬拜耶和华，称颂耶和华我主人亚伯拉罕的　神，因为他引导我走恰当的路，使我得到我主人的兄弟的孙女，作我主人的儿子的妻子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","现在你们若愿意以慈爱和信实待我的主人，就请告诉我。如果不愿意，也请你们告诉我；使我可以知道怎样行。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","拉班和彼土利回答，说：“这事既然出于耶和华，我们就不能对你说好说歹。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","看哪，利百加就在你面前，你可以把她带去，照着耶和华所说的，作你主人儿子的妻子。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","亚伯拉罕的仆人听到了他们这些话，就俯伏在地敬拜耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","那仆人拿出金器、银器和衣服送给利百加，又把贵重的礼物送给她的哥哥和她的母亲。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","然后，仆人和与他同来的人才吃喝，并且住了一夜。他们早晨起来，仆人就说：“请打发我回到我主人那里去吧！” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","利百加的哥哥和母亲说：“让这女孩子和我们同住多几天，或是十天，然后她可以离去。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","仆人回答他们：“你们不要挽留我，耶和华既然使我的道路亨通，就请打发我回到我主人那里去。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","他们说：“我们可以把那女孩子叫来，问问她的意思。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","他们把利百加叫了来，问她：“你愿意与这人同去吗？”她回答：“我愿意去。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","于是，他们把自己的妹妹利百加，她的乳母和亚伯拉罕的仆人，以及同来的人，都打发走了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","他们给利百加祝福，对她说：“我们的妹妹啊，愿你作千万人之母；愿你的后裔，占领仇敌的城门。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","利百加和她的众使女就起来，骑上骆驼，跟着那人走；那仆人就带着利百加走了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","那时，以撒刚从庇耳．拉海．莱回来，他原本是住在南地的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","黄昏的时候，以撒出来田间默想。他举目观看，忽然看见来了些骆驼。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","利百加举目观看，看见了以撒，就下了骆驼， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","问那仆人：“在田间走来迎接我们的这人是谁？”仆人回答：“他是我的主人。”利百加就拿面纱蒙在面上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","仆人把所作的一切事，都告诉以撒。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","以撒领利百加进了他母亲撒拉的帐棚，并且娶了她。利百加就作了以撒的妻子。以撒爱利百加。以撒自从他母亲去世后，这才得了安慰。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","亚伯拉罕又娶了一个妻子，名叫基土拉。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","基土拉给他生了心兰、约珊、米但、米甸、伊施巴和书亚。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","约珊生了示巴和底但，而底但的子孙是亚书利人、利都示人和利乌米人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","米甸的儿子是以法、以弗、哈诺、亚比大和以勒大。这些人都是基土拉的子孙。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","亚伯拉罕把自己一切所有的都给了以撒。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","亚伯拉罕把礼物分给他庶出的众子，在自己还活着的时候，就打发他们离开他的儿子以撒，向东面行，往东方的地去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","亚伯拉罕一生的年日是一百七十五岁。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","亚伯拉罕寿高年老，享尽天年，气绝而死，归到他的先人那里去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","他的儿子以撒和以实玛利把他埋葬在麦比拉洞里。这洞是在幔利前面，赫人琐辖的儿子以弗仑的田间， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","就是亚伯拉罕从赫人那里买来的那块田。亚伯拉罕和他的妻子撒拉都埋葬在那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","亚伯拉罕死后，　神赐福给他的儿子以撒；那时，以撒住在庇耳．拉海．莱附近。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","以下是撒拉的婢女埃及人夏甲，给亚伯拉罕所生的儿子以实玛利的后代。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","以实玛利的众子，按着他们的家谱，名字如下：以实玛利的长子是尼拜约，其次是基达、押德别、米比衫、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","米施玛、度玛、玛撒、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","哈达、提玛、伊突、拿非施和基底玛。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","这些都是以实玛利的儿子。他们的村庄和营地都按着他们的名字命名；他们作了十二族的族长。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","以实玛利一生的岁数，是一百三十七岁；他气绝而死，归到他的先人那里去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","他的子孙住在哈腓拉直到埃及东面的书珥，通往亚述的道上。以实玛利却住在自己众兄弟的东面。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","以下是亚伯拉罕的儿子以撒的后代。亚伯拉罕生以撒。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","以撒娶利百加为妻的时候，正四十岁。利百加是巴旦．亚兰地、亚兰人彼土利的女儿，是亚兰人拉班的妹妹。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","以撒因为自己的妻子不生育，就为她恳求耶和华。耶和华应允了他，他的妻子利百加就怀了孕。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","双胎在她腹中彼此碰撞，她就说：“若是这样，我为什么活着呢？”她就去求问耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","耶和华回答她：“两国在你肚里，两族从你腹中要分出来；将来这族必强过那族，大的要服事小的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","到了生产的时候，她肚腹中果然是一对双生子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","先出来的，全身赤红有毛，像毛衣一样，他们就给他起名叫以扫。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","随后，他的弟弟也出来了，他的手抓住以扫的脚跟，因此就给他起名叫雅各。利百加生下两个儿子的时候，以撒年正六十岁。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","两个孩子渐渐长大；以扫善于打猎，喜欢生活在田野；雅各为人安静，常常住在帐棚里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","以撒爱以扫，因为他常吃以扫的野味；利百加却爱雅各。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","有一次，雅各正在煮豆汤的时候，以扫从田野回来，疲乏得很。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","以扫对雅各说：“求你把这红豆汤给我喝吧，因为我疲乏得很。”因此，以扫的名字又叫以东。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","雅各说：“你要先把你的长子名分卖给我。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","以扫说：“我快要死了，这长子名分对我有什么益处呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","雅各说：“你先向我起誓吧。”以扫就向他起了誓，把自己的长子名分卖给雅各。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","于是，雅各把饼和红豆汤给了以扫；以扫吃了，喝了，就起来走了。以扫就这样轻看了他的长子名分。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","从前在亚伯拉罕的时候，曾经有过一次饥荒，现在那地又有饥荒，以撒就到基拉耳去，到非利士人的王亚比米勒那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","耶和华向以撒显现，说：“你不要下到埃及去，要住在我所指示你的地方。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","你要寄居在这地，我必与你同在，必赐福给你，因为我要把这全地都赐给你和你的后裔，履行我向你父亲亚伯拉罕所起的誓。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","我必使你的后裔增多，好像天上的星那样多；我必把这全地都赐给你的后裔；地上的万国都必因你的后裔得福。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","这是因为亚伯拉罕听从了我的话，遵守了我的吩咐、我的命令、我的条例和我的律法。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","于是，以撒就住在基拉耳。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","那地方的人问起他的妻子，他就回答：“她是我的妹妹。”因为他不敢说：“她是我的妻子。”他心里想：“恐怕这地方的人，因利百加的缘故把我杀了，因为她容貌美丽。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","以撒在那里住了很久。有一天，非利士人的王亚比米勒从窗户里向外观望，看见以撒正在爱抚他的妻子利百加。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","亚比米勒于是把以撒召了来，对他说：“你看，她实在是你的妻子，你怎么说是你的妹妹呢？”以撒回答他：“因为我心里想：‘恐怕我因她的缘故丧命。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","亚比米勒说：“你向我们作的是什么事呢？人民中间险些有人与你的妻子同睡，那你就把我们陷在罪恶里了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","于是，亚比米勒吩咐全国人民，说：“凡是触犯这人或是他的妻子的，必被处死。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","以撒在那里耕种，那一年丰收百倍， 耶和华实在赐福给他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","他就日渐昌大，越来越富有，成了个大富翁。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","他拥有羊群、牛群和很多仆人，非利士人就嫉妒他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","他父亲亚伯拉罕在世的时候，所有由他父亲仆人挖的井，非利士人都塞住了，填满了土。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","亚比米勒对以撒说：“你离开我们去吧，因为你比我们强大得多了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","以撒于是离开那里，在基拉耳谷支搭帐棚，住在那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","他父亲亚伯拉罕在世的时候，仆人所挖的水井，在亚伯拉罕死后都被非利士人塞住了。以撒重新挖掘这些井，仍然照着他父亲所起的名字叫它们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","以撒的仆人在山谷里挖井，在那里挖得一口活水井。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","基拉耳的牧人与以撒的牧人争闹起来，说：“这水是我们的。”以撒就给那井起名叫埃色，因为他们与他相争。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","以撒的仆人又挖了另一口井，他们又为这井争闹起来，因此以撒给这井起名叫西提拿。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","以撒离开那里，又挖了另一口井；他们不再为这井争闹了，他就给那井起名利河伯，因为他说：“现在耶和华给我们宽阔的地方，我们必在这里繁盛起来了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","以撒从那里上到别是巴去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","那天晚上，耶和华向他显现，说：“我是你父亲亚伯拉罕的　神；你不要怕，因为我与你同在；我必为了我仆人亚伯拉罕的缘故，赐福给你，使你的后裔增多。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","以撒就在那里筑了一座祭坛，呼求耶和华的名；又在那里支搭帐棚；以撒的仆人也在那里挖了一口井。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","亚比米勒和他的朋友亚户撒，以及他的军长非各，从基拉耳来到以撒那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","以撒问他们：“你们既然恨我，把我从你们中间赶出来，为什么又到我这里来呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","他们回答：“我们实在看见耶和华与你同在，因此我们想：‘不如我们双方起誓。’让我们与你立约吧； ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","你不要伤害我们，正如我们从来没有触犯你，只有善待你，让你平平安安地离开。现在你是蒙耶和华赐福的了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","以撒就为他们摆设筵席，他们就一起吃喝。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","第二天，他们清早起来，彼此起誓；以撒就送他们走，他们平平安安地离开他走了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","那一天，以撒的仆人来把他们挖井的事告诉他，说：“我们找到水了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","以撒就给那井起名叫示巴，因此那城名叫别示巴，直到今日。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","以扫四十岁的时候，娶了赫人比利的女儿犹滴，和赫人以伦的女儿巴实抹为妻。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","她们二人常使以撒和利百加伤心难过。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","以撒年老，眼睛昏花，看不见东西了；他把他的大儿子以扫叫了来，对他说：“我儿啊！”以扫回答他：“我在这里。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","以撒说：“现在我已经老了，不知道什么时候会死。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","你现在拿你打猎的用具，就是你的箭囊和弓，出到田野去为我打猎。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","照我所喜欢的，给我预备美味的食物，拿来给我吃；好让我在未死以前给你祝福。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","以撒对他儿子以扫说话的时候，利百加也听见。以扫到田野去打猎，要带些野味回来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","利百加就对她儿子雅各说：“我听见你父亲对你的哥哥以扫这样说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘你去为我打些猎物回来，给我预备美味的食物，让我吃了，在我未死以前可以在耶和华面前给你祝福。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","我儿啊，现在你要听我的话，照着我吩咐你的去作。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","你快到羊群那里去，给我牵两只肥嫩的小山羊来，我要照你父亲所喜欢的，给他预备美味的食物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","然后你要拿去给你父亲吃，好让他在未死以前给你祝福。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","雅各对他的母亲利百加说：“但是哥哥以扫浑身是毛，而我却是个皮肤光滑的人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","万一我父亲摸着我，必以为我是骗子，那时我就必自招咒诅，而不是祝福了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","他母亲对他说：“我儿啊，愿你所招的咒诅归到我身上吧，你只管听我的话，去把羊牵来给我。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","他就去把羊羔牵来，交给他母亲，他母亲就照他父亲所喜欢的，预备美味的食物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","利百加又把大儿子以扫留在家里最好的衣服拿来，给她小儿子雅各穿上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","又用小山羊的皮，包在雅各的手上和他颈上光滑的地方。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","然后，她把自己所预备美味的食物和饼，放在她儿子雅各的手里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","雅各来到他父亲那里，说：“我父啊！”以撒说：“我在这里，我儿啊，你是谁？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","雅各对他父亲说：“我就是你的长子以扫，你吩咐我作的，我已经照样作了。请坐起来，吃我的猎物，好给我祝福。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","以撒问他的儿子：“我儿啊，你怎么这样快就猎到了呢？”雅各回答：“因为耶和华你的　神叫我碰着好机会。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","以撒对雅各说：“我儿啊，你上前来，让我摸摸你，看看你是不是我的儿子以扫。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","雅各就走近他父亲以撒身边，以撒摸着他，说：“声音是雅各的声音，手却是以扫的手。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","以撒认不出他来，因为他的手上有毛，好像他哥哥以扫的手一样，于是给他祝福。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","以撒问：“你真是我的儿子以扫吗？”他回答：“我是。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","以撒说：“把食物递给我，好让我吃我儿子的猎物，我就给你祝福。”雅各把食物递给他，他就吃了；又拿酒给他，他也喝了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","他父亲以撒对他说：“我儿啊，你上前来，和我亲嘴。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","他就上前和父亲亲嘴；他父亲一闻到他衣服的香气，就给他祝福，说：“看哪，我儿子的香气，好像蒙耶和华赐福的田地所发出的香气一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","愿　神赐给你天上的甘露，地上的沃土，以及大量五谷和美酒。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","愿万民服事你，愿万族向你下拜，愿你作你兄弟的主人，愿你母亲的子孙向你下拜。咒诅你的，愿他受咒诅；给你祝福的，愿他蒙福。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","以撒给雅各祝福完了，雅各刚刚从他父亲以撒那里出来的时候，他哥哥以扫就打猎回来了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","他也预备了美味的食物，拿来给他父亲，对他说：“请我父起来，吃你儿子的猎物，好给我祝福。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","他父亲以撒问他：“你是谁？”他回答：“我就是你的长子以扫。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","以撒就大大地战兢起来，说：“那么，刚才去打猎又拿猎物给我的是谁呢？在你未来以先，我已经吃了，又给他祝福了；他将来必定蒙福。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","以扫听了他父亲的话，就非常痛心，放声大哭，对他父亲说：“我父啊，求你也给我祝福。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","以撒说：“你弟弟已经前来，用诡计把你的祝福夺去了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","以扫说：“他名叫雅各不是很对吗？因为他欺骗了我两次。从前他夺去我的长子名分，现在他又夺去我的祝福。”以扫又说：“你再没有祝福留给我吗？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","以撒回答以扫，说：“我已经立他作你的主人，又把他所有的兄弟给了他作仆人，并且把五谷和美酒供给他了。我儿啊，我还可以为你作什么呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","以扫问他的父亲：“我父啊，你只有一个祝福吗？我父啊，求你也给我祝福。”以扫就放声大哭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","他父亲以撒回答他，说：“你住的地方必远离地上的沃土，远离天上的甘露。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","你必依靠刀剑生活，你必服事你的弟弟；到你自由的时候，你必从你的颈项上挣脱他的轭。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","以扫因为他父亲给雅各所祝的福，就怀恨雅各；以扫心里想：“为我父亲守丧的时候近了，到时我必杀我的弟弟雅各。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","有人把利百加大儿子以扫所说的话告诉了利百加，她就派人把她小儿子雅各叫了来，对他说：“你哥哥以扫想要杀你，报仇雪恨。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","我儿啊，现在你要听我的话；起来，逃到哈兰我哥哥拉班那里去吧。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","与他住些时日，等到你哥哥的怒气消了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","你哥哥对你消了怒气，忘记了你对他所作的事，我就派人去把你从那里接回来。我何必在一日之内丧失你们两个呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","利百加对以撒说：“我因为这些赫人女子，连性命都厌恶了。如果雅各也从这地的女子中，娶了像这样的赫人女子为妻，那我活着还有什么意思呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","以撒把雅各叫了来，给他祝福，并且吩咐他，说：“你不可娶迦南的女子为妻。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","起来，到巴旦．亚兰你外祖父彼土利的家里去，在那里娶你舅父拉班的一个女儿为妻。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","愿全能的　神赐福给你，使你繁殖增多，成为大族。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","愿　神把应许给亚伯拉罕的福，赐给你和你的后裔，使你可以得着你寄居的地为业，就是　神赐给亚伯拉罕的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","于是，以撒打发雅各去了，雅各就往巴旦．亚兰去，到了亚兰人彼土利的儿子拉班那里。拉班就是雅各和以扫的母亲利百加的哥哥。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","以扫见以撒给雅各祝福，又打发他到巴旦．亚兰去，在那里娶妻；又见以撒给雅各祝福的时候，吩咐他说：“你不可娶迦南的女子为妻”； ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","又见雅各听从了他父母的话，到巴旦．亚兰去了； ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","以扫就看出，他父亲以撒不喜欢迦南的女子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","于是，以扫到以实玛利那里去，在他两个妻子以外，娶了玛哈拉为妻。玛哈拉就是亚伯拉罕的儿子以实玛利的女儿，尼拜约的妹妹。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","雅各离开别是巴，到哈兰去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","来到一个地方，就在那里过夜，因为太阳已经落了。他拾起那地方的一块石头，把它放在头底下作枕头，就在那里躺下睡了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","他作了一个梦，梦见一个梯子立在地上，梯顶直通到天，　神的众使者在梯子上下往来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","耶和华站在梯子上，说：“我是耶和华你祖父亚伯拉罕的　神，也是以撒的　神，我要把你现在躺着的这块地赐给你和你的后裔。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","你的后裔必像地面的灰尘那么多；你必向东、南、西、北扩展；地上的万族必因你和你的后裔得福。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","我与你同在，你无论到哪里去，我必看顾你；我必领你回到这地方来，因为我必不离弃你，直到我实现了我对你所应许的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","雅各一觉醒来，说：“耶和华确实在这地方，我竟不知道！” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","他就惧怕起来，说：“这地方多么可畏啊，这不是别的地方，而是　神的殿，是天的门。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","雅各清早起来，把他曾经放在头底下作枕头的那块石头，立作石柱，在柱上浇了油。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","他就给那地方起名叫伯特利，但那城起初名叫路斯。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","于是雅各许了一个愿说：“如果　神与我同在，在我所走的路上看顾我，赐我食物吃，给我衣服穿， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","使我可以平平安安地回到我的父家，我就必定以耶和华为我的　神， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","我立作石柱的那块石头，必作　神的殿；你赐给我的一切，我必把十分之一献给你。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","雅各继续前行，到了东方人的地方。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","他看见田间有一口井；有三群羊躺卧在井旁，因为人都是用那井里的水给羊群喝；井口上有一块大石头。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","当所有羊群都到齐了，牧人就把井口的石头辊开，取水给羊群喝，然后把石头放回井口原处。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","雅各问这些牧人：“弟兄们，你们是哪里来的？”他们回答：“我们是从哈兰来的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","他问他们：“你们认识拿鹤的孙子拉班吗？”他们回答：“我们认识。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","雅各又问他们：“他平安吗？”他们回答：“平安。你看，他的女儿拉结领着羊群来了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","雅各说：“现在太阳还高，不是牲畜聚集的时候；你们取水给羊群喝，再去牧放吧。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","他们回答：“我们不能这样作，必须等到所有的羊群都到齐了，有人把井口的石头辊开，我们才可以取水给羊群喝。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","雅各还跟他们说话的时候，拉结领着她父亲的羊群来了。拉结原来是个牧羊女。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","雅各看见了舅父拉班的女儿拉结，和舅父拉班的羊群，就上前来，把井口的石头辊开，取水给舅父拉班的羊群喝。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","雅各和拉结亲嘴，就放声大哭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","雅各告诉拉结，自己是她父亲的外甥，是利百加的儿子。拉结就跑去告诉她的父亲。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","拉班听见了关于外甥雅各的消息，就跑去迎接他，拥抱他，和他亲嘴，带他到自己的家里。雅各就把一切经过都告诉拉班。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","拉班对雅各说：“你实在是我的骨肉。”雅各就与拉班同住了一个月。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","拉班对雅各说：“你因为是我的外甥，就要白白地服事我吗？告诉我，你要什么报酬？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","拉班有两个女儿；大的名叫利亚，小的名叫拉结。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","利亚的眼睛虽然可爱，拉结却生得身材美丽，样貌娟秀。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","雅各爱拉结，所以对拉班说：“我愿为你的小女儿拉结服事你七年。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","拉班说：“我把她给你，比给别人更好，你就与我同住吧。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","于是，雅各为拉结服事了拉班七年；他就看这七年好像几天一样，因为他爱拉结。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","雅各对拉班说：“期限到了，请把我的妻子给我，好让我与她亲近。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","拉班就摆设筵席，邀请了那地方所有的人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","到了晚上，拉班把自己的女儿利亚带来给雅各，雅各就与她亲近。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","拉班又把自己的婢女悉帕给了女儿利亚作婢女。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","到了早晨，雅各才看出原来是利亚，就对拉班说：“你向我作的是什么事呢？我服事你，不是为了拉结的缘故吗？你为什么欺骗我呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","拉班回答：“大女儿还没有出嫁，就先把小女儿嫁出去，我们这地方是没有这规矩的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","你与大女儿七天的庆典过了以后，我们也把小女儿给你，只是你要再服事我七年。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","于是雅各这样作了。他与利亚七天的庆典过了以后，拉班就把自己的女儿拉结给雅各为妻。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","拉班又把自己的婢女辟拉给了女儿拉结作婢女。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","雅各也与拉结亲近，并且爱拉结胜过爱利亚；于是他再服事了拉班七年。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","耶和华见利亚失宠，就使她生育，拉结却不生育。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","利亚怀孕，生了一个儿子，就给他起名叫流本，因为她说：“耶和华看见了我的苦情，现在我的丈夫必爱我了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","她又怀孕，生了一个儿子，就说：“耶和华因为听见我失宠，所以又赐给我这个儿子。”于是给他起名叫西缅。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","她又怀孕，生了一个儿子，就说：“这一次，我的丈夫要依恋我了，因为我已经给他生了三个儿子。”因此给孩子起名叫利未。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","她又怀孕，生了一个儿子，就说：“这一次，我要赞美耶和华了。”因此给孩子起名叫犹大。这样，她才停止了生育。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","拉结见自己没有给雅各生孩子，就嫉妒她的姊姊，对雅各说：“你要给我儿子，不然，我要死了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","雅各就向拉结生气，说：“使你不能生育的是　神，我能代替他吗？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","拉结说：“我的婢女辟拉在这里，你可以与她亲近，使她生子归我，我就可以从她得到孩子。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","于是，拉结把自己的婢女辟拉给了雅各为妾，雅各就与她亲近。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","辟拉怀孕，给雅各生了一个儿子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","拉结说：“　神为我伸了冤，也垂听了我的声音，赐给我一个儿子。”所以给他起名叫但。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","拉结的使女辟拉又怀孕，给雅各生了第二个儿子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","拉结说：“我与姊姊大大地相争，我得胜了。”于是给孩子起名叫拿弗他利。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","利亚见自己停止生育，就把她的婢女悉帕给了雅各为妾。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","利亚的婢女悉帕给雅各生了一个儿子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","利亚说：“我真幸运。”给他起名叫迦得。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","利亚的婢女悉帕又给雅各生了第二个儿子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","利亚说：“我真有福气，众女子都要称我是有福的。”于是给孩子起名叫亚设。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","到了收割麦子的时候，流本出去，在田间找到了一些风茄，就拿来给他母亲利亚。拉结对利亚说：“请你把你儿子的风茄分一些给我。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","利亚回答拉结：“你夺去了我的丈夫，还算小事吗？你还要夺去我儿子的风茄吗？”拉结说：“好吧，今夜就让他与你同睡，来交换你儿子的风茄。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","到了晚上，雅各从田间回来，利亚出去迎接他，说：“你要与我亲近，因为我实在用我儿子的风茄把你雇下了。”那一夜，雅各就与利亚同睡。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","神垂听了利亚的祷告，利亚就怀孕，给雅各生了第五个儿子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","利亚说：“　神给了我酬报，因为我把我的婢女给了我的丈夫。”于是给孩子起名叫以萨迦。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","利亚又怀孕，给雅各生了第六个儿子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","利亚说：“　神把美好的礼物送了给我，这一次我的丈夫要抬举我了，因为我给他生了六个儿子。”于是给孩子起名叫西布伦。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","后来利亚又生了一个女儿，给她起名叫底拿。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","神顾念拉结，垂听了她的祷告，使她能生育。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","拉结就怀孕，生了一个儿子，说：“　神把我的耻辱除去了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","于是给孩子起名叫约瑟，说：“愿耶和华再给我一个儿子。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","拉结生了约瑟以后，雅各对拉班说：“请你让我走吧，我好回到自己的地方，自己的故乡去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","请你把我服事你所得的妻子和儿女都给我，让我回去；我怎样服事了你，你是知道的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","拉班对他说：“我若蒙你赏脸，请你不要走，因为我得了神旨，知道耶和华赐福给我，是因你的缘故。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","他又说：“请你定你的工资吧，我必给你。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","雅各对拉班说：“我怎样服事了你，你的牲畜在我手里情形怎样，你是知道的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","我没来以前，你所有的很少，现在却大大地增加了；耶和华随着我的脚踪赐福给你。现在，我什么时候才能兴家立业呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","拉班问：“我该给你什么？”雅各回答：“你什么也不必给我；只要你答应我这一件事，我就继续牧放看守你的羊群。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","今天我要走遍你的羊群，凡有斑点的羊、黑色的绵羊和有斑点的山羊，都挑出来，作为我的工资。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","日后你来查看我的工资的时候，我好对你证明我的公道。凡在我手里没有斑点的山羊，或不是黑色的绵羊，都算是我偷来的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","拉班回答：“好吧，就照你的话去作。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","当日，拉班把有条纹和有斑点的公山羊、有斑点和有白纹的母山羊，以及所有黑色的绵羊，都挑出来交在自己的众子手里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","又使自己和雅各之间相距有三天的路程。雅各就牧放拉班其余的羊群。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","雅各拿杨树、杏树和枫树的嫩枝子，把树皮剥成白色的条纹，使枝子露出白的部分来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","然后把剥了皮的枝子插在水沟和水槽里，枝子正对着来喝水的羊群。羊群来喝水的时候，就彼此交配。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","羊群对着枝子交配，就生下有条纹和有斑点的小羊来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","雅各把羊羔分别出来，使拉班的羊，对着这些有条纹的和所有黑色的羊。他为自己另组羊群，不把它们放在拉班的羊群中。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","到了肥壮的羊群要交配的时候，雅各就在羊群的面前把枝子插在水沟里，使它们在枝子中间彼此交配。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","但当瘦弱的羊群交配的时候，雅各就不插枝子。这样，瘦弱的就归拉班，肥壮的就归雅各。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","于是，雅各变成非常富有，拥有很多羊群、仆婢、骆驼和驴。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","雅各听见拉班的众子谈论，说：“雅各把我们父亲所有的都夺去了，他这一切财物，都是从我们父亲的财产那里得来的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","雅各也注意到拉班的脸色，对自己不像从前那样了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","那时，耶和华对雅各说：“你要回到你列祖之地，到你的亲族那里去，我必与你同在。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","雅各就派人把拉结和利亚叫到田间的羊群那里去， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","对她们说：“我注意到你们父亲的脸色，对我不像从前那样了；但是我父亲的　神与我同在。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","我尽了我的力量来服事你们的父亲，这是你们知道的； ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","你们的父亲却欺骗了我，十次更改了我的工资；但　神不容许他伤害我。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","如果他说：‘有斑点的算是你的工资’，羊群所生的全部都有斑点；如果他说：‘有条纹的算是你的工资’，羊群所生的全部有条纹。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","这样，　神把你们父亲的牲畜夺来，赐给我了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","有一次，羊群交配的时候，我在梦中举目观看，看见爬在母羊身上的公山羊，都是有条纹、有斑点和有花斑的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","神的使者在梦中对我说：‘雅各。’我说：‘我在这里。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","他说：‘你举目观看，所有爬在母羊身上的公山羊，都是有条纹、有斑点和有花斑的，因为拉班向你所作的一切，我都看见了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","我就是伯特利的　神，你曾经在那里用油膏过石柱，又在那里向我许过愿。现在你要起程，离开这地，回到你的亲族那里去吧。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","拉结和利亚回答雅各，说：“在我们父亲的家里，我们还有可得的分和产业吗？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","他不是把我们看作外人吗？因为他把我们卖了，吞没了我们的身价。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","神从我们父亲夺回来的一切财物，都是属于我们和我们的儿女的。现在　神吩咐你的一切，你只管作吧。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","于是雅各起来，叫他的儿女和妻子们都骑上骆驼。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","又赶着他所有的牲畜，带着他所得的一切财物，就是他在巴旦．亚兰所得的一切牲畜，要到迦南地，他父亲以撒那里去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","当时拉班剪羊毛去了，拉结就偷了他父亲的神像。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","雅各瞒着亚兰人拉班，没有告诉拉班他将要逃走。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","于是，雅各带着他所有的一切逃走了。他起程渡过了大河，面对着基列山走去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","到了第三天，有人告诉拉班说雅各逃走了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","拉班就带着自己的众兄弟追赶他，追了七日的路程，才在基列山把他们追上了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","当天晚上，　神在梦中来到亚兰人拉班那里，对他说：“你要小心，不可与雅各说什么。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","拉班追上了雅各。当时雅各已经在山上支搭了帐棚；拉班和他的众兄弟，也在基列山上支搭了帐棚。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","拉班对雅各说：“你作的是什么事呢？你瞒着我，把我的女儿们当作战俘一样带走了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","你为什么暗中逃走，瞒着我不让我知道，使我可以欢欢喜喜地唱歌、击鼓、弹琴给你送行呢？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","你又不让我与我的外孙和女儿亲嘴。你所作的太糊涂了！ ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","我本来有能力可以伤害你，但昨天晚上，你们父亲的　神对我说：‘你要小心，不可与雅各说什么。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","现在你既然渴想你的父家，一定要回去，为什么又偷我的神像呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","雅各回答拉班，说：“我逃走，是因为我害怕，我心里想：恐怕你会把你的女儿们从我的手中抢走。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","至于你的神像，你在谁身上搜出来，那人就不该活着；你当着我们众兄弟面前查一查，如果在我这里有什么东西是你的，你只管拿去。”原来雅各不知拉结偷了神像。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","拉班进了雅各的帐棚、利亚的帐棚和两个婢女的帐棚，都没有搜出什么，于是从利亚的帐棚出来，进了拉结的帐棚。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","拉结已经把神像放在骆驼的鞍下，自己坐在上面。拉班搜遍了帐棚，但没有搜出什么。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","拉结对她父亲说：“求我主不要生气，我不能在你面前起来，因为我正有女人的经期。”这样，拉班彻底搜查了，也搜不出那神像来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","雅各就生气，与拉班争吵起来。雅各责问拉班说：“我到底有什么过犯，有什么罪恶，你竟这样急速地追赶我呢？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","你已经搜遍了我所有的家具，你有找到你家的东西没有？可以把它放在这里，在你我的众兄弟面前，让他们可以在你我中间判断一下。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","这二十年来，我与你在一起；你的母绵羊和母山羊没掉过胎，你羊群中的公羊，我没有吃过。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","被野兽撕裂的，我没有给你带回来，都是由我自己赔偿；无论白天偷去的，或是黑夜偷的，你都要我负责。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","我白天受尽炎热，黑夜受尽寒霜，不能入睡；我经常是这样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","我这二十年在你的家里，为你的两个女儿服事了你十四年；为你的羊群服事了你六年；你又十次改了我的工资。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","如果不是我父亲的　神，就是亚伯拉罕的　神，以撒所敬畏的　神，与我同在，你现在必定打发我空手回去。但　神看见了我的苦情和我手中的辛劳，所以他昨天晚上责备了你。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","拉班回答雅各，说：“这些女儿是我的女儿；这些孩子是我的孩子；这些羊群也是我的羊群。其实你眼所见的一切都是我的。但我今日向我的女儿和她们所生的孩子，能作什么呢？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","来吧，现在我和你可以立约，作为你我之间的证据。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","雅各就拿了一块石头，立作石柱。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","雅各又对自己的众兄弟说：“你们把石头堆聚起来。”他们就把石头拿来，堆成了一堆。他们又在石堆旁边吃喝。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","拉班称那石堆为伊迦尔．撒哈杜他，雅各却称那石堆为迦累得。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","拉班说：“今天这堆石头是你我之间的证据。”因此它名叫迦累得， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","又名叫米斯巴，因为拉班说：“我们彼此分离以后，愿耶和华在你我中间鉴察。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","你若苦待我的女儿，或在我的女儿以外，另娶妻子，虽然没有人在我们中间作证，但你要注意，　神就是你我之间的见证人。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","拉班又对雅各说：“你看这堆石头，看我在你我之间所竖立的石柱。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","这堆石头就是证据，这石柱也是证据：我决不越过这石堆到你那里去，你也决不可越过这石堆和石柱，到我这里来害我。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","但愿亚伯拉罕的　神、拿鹤的　神，就是他们父亲的　神，在我们中间判断。”雅各就指着他父亲以撒所敬畏的　神起誓。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","雅各又在山上献祭，叫了自己的众兄弟来吃饭。他们吃了饭，就在山上过夜。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","拉班清早起来，与他的外孙和女儿亲嘴，给他们祝福。然后拉班离开那里，回自己的地方去了。（本节在《马索拉抄本》为 32:1） ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","雅各继续他的路程，　神的众使者遇见他。（本节在《马索拉抄本》为 32:2） ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","雅各看见他们，就说：“这是　神的军队。”于是给那地方起名叫玛哈念。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","雅各先派使者到西珥地，就是以东的地区，他的哥哥以扫那里去， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","吩咐他们说：“你们要对我主以扫这样说：‘你的仆人雅各这样说：我在拉班那里寄居，一直到现在。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","我拥有牛、驴、羊群、仆婢，现在派人来报告我主，希望得到你的欢心。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","使者回到雅各那里说：“我们到了你哥哥以扫那里，他带着四百人，正迎着你来。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","雅各感到非常惧怕和焦虑，就把随行的人、羊群、牛群和骆驼，分成两队， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","心里想：“即使以扫来击杀这一队，余下的一队还可以逃脱。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","雅各说：“耶和华，我祖亚伯拉罕的　神，我父以撒的　神啊，你曾经对我说过：‘回到你自己的故乡，到你的亲族那里去，我必厚待你。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","你向你仆人所施的一切慈爱和信实，我实在不配得。从前我只拿着我的手杖过这约旦河；现在我却拥有这两队人马了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","求你救我脱离我哥哥以扫的手，因为我怕他来击杀我，连母亲和孩子也击杀了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","你曾经说过：‘我必厚待你，使你的后裔好像海边的沙一样，多到不可胜数。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","那天晚上，雅各在那里过夜。然后从他所拥有的牲畜中，取出一部分，作为给他哥哥以扫的礼物， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","就是母山羊二百只、公山羊二十只、母绵羊二百只、公绵羊二十只、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","哺乳的母骆驼三十匹，各带着驹子，母牛四十头、公牛十头、母驴二十头、公驴十头。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","雅各把这些分成一队一队，交在仆人的手里，又对仆人说：“你们先过去，每队之间要留一段距离。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","他又吩咐走在最前的仆人说：“我哥哥以扫遇见你的时候，如果问你：‘你的主人是谁？你要到哪里去？在你前面的这些牲畜是谁的？’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","你就要回答：‘是你仆人雅各的，是送给我主以扫的礼物，他自己也在我们后面。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","他又吩咐第二个、第三个和所有跟在队伍后面的人说：“你们遇见以扫的时候，都要这样对他说。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","你们还要说：‘你的仆人雅各在我们后面。’”因为他心里想：“我先送礼物去，借此与他和解，然后再与他见面，或者他会原谅我。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","于是礼物先过去了；那天晚上雅各在营中过夜。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","雅各那夜起来，带着他的两个妻子、两个婢女和十一个孩子，都过了雅博渡口。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","他带着他们，先打发他们过河，然后又打发他所有的都过去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","只留下雅各一人，有一个人来与他摔角，直到天快亮的时候。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","那人见自己不能胜过他，就在他的大腿窝上打了一下。于是，雅各与那人摔角的时候，大腿窝脱了节。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","那人说：“天快亮了，让我走吧。”雅各说：“如果你不给我祝福，我就不让你走。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","那人问他：“你叫什么名字？”他回答：“雅各。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","那人说：“你的名字不要再叫雅各，要叫以色列，因为你与　神与人较力，都得了胜。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","雅各问他，说：“请把你的名告诉我。”那人回答：“为什么问我的名呢？”他就在那里给雅各祝福。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","于是，雅各给那地方起名叫毗努伊勒，意思说：“我面对面看见了　神，我的性命仍得保全。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","雅各经过毗努伊勒的时候，太阳刚刚出来，照在他身上。他因为大腿的伤，跛脚行走。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","因此，以色列人直到现在都不吃大腿窝上的筋，因为那人在雅各的大腿窝上的筋打了一下。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","雅各举目观看，见以扫带着四百人来了；他就把孩子分开三队，交给利亚、拉结和两个婢女。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","他叫两个婢女和她们的孩子走在前头，利亚和她的孩子跟着，拉结和约瑟走在最后。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","他自己却走在他们前面，七次俯伏在地，直到走近他哥哥跟前。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","以扫跑来迎接他，拥抱他，伏在他颈项上，与他亲嘴；两个人都哭了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","以扫举目观看，看见妇人和孩子，就问：“这些与你同来的人是谁？”雅各回答：“是　神赐给你仆人的孩子。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","于是，两个婢女和她们的孩子上前下拜。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","利亚和她的孩子也上前下拜，随后，约瑟和拉结也上前下拜。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","以扫又问：“我遇见的这一群牲畜，是什么意思呢？”雅各回答：“是要讨我主喜悦的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","以扫说：“弟弟啊，我已经很富有了，你的仍归你吧。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","雅各说：“请不要这样，我若得你的喜悦，就求你从我手里收下这些礼物吧；因为我看见了你的面，就好像见了　神的面；你实在恩待了我。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","请你收下我带来给你的礼物，因为　神施恩给我，我什么都有了。”雅各再三恳求他，他才收下了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","以扫说：“我们起程前行吧，我和你一起走。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","雅各对他说：“我主知道孩子们还年幼娇嫩；牛羊也正在乳养的时候，需要我的照顾；如果要催赶它们走一天的路，恐怕所有牲畜都要死了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","请我主在仆人前头先行；我要照着在我面前群畜和孩子们的速度，慢慢前行，直走到西珥我主那里去。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","以扫说：“让我把跟随我的人留几个在你这里吧。”雅各说：“为什么要这样呢？只要我得我主的喜悦就是了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","于是，以扫在那一天回西珥去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","雅各却起程到疏割去，在那里为自己建造了一座房子，又为牲畜搭了些草棚，因此给那地方起名叫疏割。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","雅各从巴旦．亚兰回来的时候，平平安安地到了迦南地的示剑城，在城的对面支搭了帐棚。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","他支搭帐棚的那块地，是他用一百块银子向示剑的父亲哈抹的子孙买来的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","在那里雅各建了一座坛，给它起名叫伊利．伊罗伊．以色列。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","利亚给雅各所生的女儿底拿，出去要看看当地的女子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","当地的首长，希未人哈抹的儿子示剑，看见她，就拉住她，把她强奸，污辱了她。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","示剑的心恋慕雅各的女儿底拿，他深爱这少女，就用甜言蜜语安慰她。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","示剑对他父亲哈抹说：“求你为我聘这女子为妻。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","雅各听见示剑奸污了他的女儿底拿；但那时他的儿子正在田间看守他的牲畜，所以他没有作声，只等他们回来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","示剑的父亲哈抹出来见雅各，要与他商议。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","雅各的儿子听见了这事，就从田间回来；各人都感到非常悲痛和忿怒，因为示剑在以色列中作了丑事，就是把雅各的女儿奸污了，这是不应该作的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","哈抹与他们商议说：“我儿子示剑的心依恋你们家的女儿，请你们把她给我的儿子为妻吧。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","你们与我们可以彼此结亲；你们可以把女儿嫁给我们，也可以娶我们的女儿为妻。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","这样，你们可以与我们同住；这地就摆在你们面前，只管在其中居住，来往作买卖，购置产业吧。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","示剑对底拿的父亲和她的兄弟说：“但愿我得你们的喜悦，无论你们要什么，我必给你们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","任由你们向我要多重的聘金和多大的礼物，我必照你们所说的给你们，只要你们把这少女给我为妻就是了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","雅各的众子，因为示剑奸污了他们的妹妹底拿，就用欺诈的话回答示剑和他父亲哈抹， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","对他们说：“我们不能把妹妹给一个没有受割礼的人为妻，因为那是我们的耻辱。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","只有一个条件，我们才可以答允你们，就是你们当中所有的男子都受割礼，像我们一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","我们就可以把女儿嫁给你们，也可以娶你们的女儿为妻；我们可以与你们同住，大家成为一族人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","但如果你们不肯听从我们受割礼，我就要把我们家的女儿带走了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","哈抹和他儿子示剑觉得他们的提议很好。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","那少年就立刻照着去作，因为他喜爱雅各的女儿；他在他父亲的全家中又是最受尊敬的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","哈抹和他儿子示剑来到自己的城的门口，对城里的人说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“这些人与我们和平相处，不如让他们在这地居住，来往作买卖吧。这地两边都很宽阔，可以容纳他们；我们可以娶他们的女儿为妻，也可以把我们的女儿嫁给他们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","但是只有一个条件，这些人才应允与我们同住，大家成为一族人，就是我们中间所有的男子都受割礼，好像他们受了割礼一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","这样他们的牲畜、财产和所有的牲口，不都要归我们所有吗？只要我们应允他们的条件，他们就与我们同住了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","所有从城门出入的人，都听从了哈抹和他儿子示剑的话。于是，所有从城门出入的男子，都受了割礼。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","到了第三天，他们正在疼痛的时候，雅各的两个儿子，就是底拿的哥哥西缅和利未拿着刀剑，趁着他们想不到的时候，进了那城，把所有的男子都杀了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","又用刀剑杀了哈抹和他儿子示剑，然后从示剑的家里把底拿带走。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","雅各的儿子因为他们的妹妹被人奸污了，就来到被杀的人那里，抢掠那城， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","夺去他们的羊群、牛群和驴，以及城里和田间所有的， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","又把他们所有的财物、孩子和妇女都掳去。屋里所有的东西，都抢掠一空。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","雅各对西缅和利未说：“你们连累了我，使我在这地的居民，就是在迦南人和比利洗人中间，成了可憎的人。我们人数不多，如果他们联合起来对付我，攻击我，我和我的家就必灭绝了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","他们回答说：“他怎可以待我们的妹妹好像妓女一样呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","神对雅各说：“起来，上伯特利去，住在那里；你要在那里筑一座坛给　神，就是从前你逃避你哥哥以扫的时候，向你显现的那一位。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","雅各就对他的家人，和所有与他在一起的人说：“你们要除去你们中间外族人的神像，你们要洁净自己，更换你们的衣服。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","我们要起程，上伯特利去；我要在那里给　神筑一座祭坛，他就是在我遭患难的时候应允我的呼求，在我所行的路上与我同行的那一位。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","他们就把自己手中所有外族人的神像，和自己耳朵上的环子，都交给雅各；雅各把这些东西埋在示剑附近的橡树底下。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","他们出发了，　神使周围的城市都非常惧怕，他们就不追赶雅各的儿子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","于是雅各和与他在一起的人，到了迦南地的路斯，就是伯特利。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","他在那里筑了一座坛，就称那地方为伊勒．伯特利，因为他逃避他哥哥的时候，　神曾经在那里向他显现。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","利百加的乳母底波拉死了，葬在伯特利下边的橡树底下，所以给那棵树起名叫亚伦．巴古。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","雅各从巴旦．亚兰回来以后，　神再次向他显现，赐福给他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","神对他说：“你的名原是雅各，但以后不要再叫雅各，以色列才是你的名。”这样，　神给他改名叫以色列。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","神对他说：“我是全能的　神，你要繁殖增多，必有一大国从你而生，又必有很多君王从你而出。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","我赐给亚伯拉罕和以撒的地，我要赐给你，我也要把这地赐给你的后裔。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","神从与雅各谈话的地方，离开他上升去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","雅各就在　神与他谈话的地方，立了一根石柱；在柱上浇了奠祭和油。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","雅各给　神与他谈话的地方起名叫伯特利。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","他们从伯特利起程，离以法他还有一段路程的时候，拉结产期到了；但她遇到难产。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","她正在极辛苦的时候，接生婆对她说：“不要怕，你这次又得了一个儿子。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","拉结快要死了，正要断气的时候，她给她儿子起名叫便．俄尼；他的父亲却叫他便雅悯。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","拉结死了，葬在通往以法他的路旁。以法他就是伯利恒。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","雅各在她的坟墓上立了一根柱子，就是拉结的墓碑，到今天还在。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","以色列又起程前行，在以得台那边支搭了帐棚。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","以色列在那地居住的时候，流本竟去与他父亲的妾辟拉同睡；这事以色列也听见了。雅各共有十二个儿子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","利亚的儿子有：雅各的长子流本，以及西缅、利未、犹大、以萨迦和西布伦。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","拉结的儿子有：约瑟和便雅悯。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","拉结的婢女辟拉的儿子有：但和拿弗他利。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","利亚的婢女悉帕的儿子有：迦得和亚设。这些都是雅各在巴旦．亚兰所生的儿子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","雅各来到基列．亚巴的幔利他父亲以撒那里，基列．亚巴就是希伯仑，是亚伯拉罕和以撒寄居过的地方。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","以撒一生的年日共一百八十岁。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","以撒年纪老迈，享尽天年，就气绝而死，归到他的亲族那里去了；他儿子以扫和雅各把他葬了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","以下是以扫的后代（以扫就是以东）： ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","以扫娶了迦南的女子为妻，就是赫人以伦的女儿亚大，和希未人祭便的孙女，亚拿的女儿阿何利巴玛； ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","又娶了以实玛利的女儿、尼拜约的妹妹巴实抹。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","亚大给以扫生了以利法；巴实抹生了流珥。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","阿何利巴玛生了耶乌施、雅兰和可拉。这些都是以扫的儿子，是在迦南地生的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","以扫带着他的众妻子、儿女和家中所有的人，以及他的牲畜、所有的牲口和他在迦南地所得的一切财产，离开他的弟弟雅各到别的地方去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","因为他们都有很多财物，所以不能住在一起；又因他们牲畜很多的缘故，他们寄居的地方也容不下他们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","于是，以扫住在西珥山上。以扫就是以东。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","以下是西珥山以东人的始祖以扫的后代： ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","这些是以扫众子的名称：以利法是以扫的妻子亚大的儿子，流珥是以扫的妻子巴实抹的儿子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","以利法的儿子是提幔、阿抹、洗玻、迦坦和基纳斯。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","亭纳是以扫的儿子以利法的妾；她给以利法生了亚玛力。以上这些人是以扫的妻子亚大的子孙。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","流珥的儿子是拿哈、谢拉、沙玛和米撒。这些人是以扫的妻子巴实抹的子孙。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","以下是祭便的孙女、亚拿的女儿、以扫的妻子阿何利巴玛的儿子：她给以扫生了耶乌施、雅兰和可拉。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","以下是以扫子孙中的族长：以扫的长子以利法的子孙中，有提幔族长、阿抹族长、洗玻族长、基纳斯族长、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","可拉族长、迦坦族长、亚玛力族长。这些人是以东地以利法的族长，都是亚大的子孙。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","以扫的儿子流珥的子孙中，有拿哈族长、谢拉族长、沙玛族长和米撒族长。这些人是以东地流珥的族长，都是以扫的妻子巴实抹的子孙。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","以扫的妻子阿何利巴玛的子孙中，有耶乌施族长、雅兰族长和可拉族长。这些人是亚拿的女儿、以扫的妻子阿何利巴玛的族长。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","以上这些人就是以扫的子孙和他们的族长。以扫就是以东。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","以下是那地原有的居民，何利人西珥的儿子：罗坍、朔巴、祭便、亚拿、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","底顺、以察和底珊。这些人是以东地何利人西珥子孙中的族长。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","罗坍的儿子是何利和希幔；罗坍的妹妹是亭纳。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","朔巴的儿子是亚勒文、玛拿辖、以巴录、示玻和阿南。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","祭便的儿子是亚雅和亚拿。当年在旷野牧放他父亲祭便的驴，发现了温泉的，就是亚拿。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","亚拿的儿子是底顺；亚拿的女儿是阿何利巴玛。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","底顺的儿子是欣但、伊是班、益兰和基兰。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","以察的儿子是辟罕、撒番和亚干。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","底珊的儿子是乌斯和亚兰。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","以下是何利人的族长：罗坍族长、朔巴族长、祭便族长、亚拿族长、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","底顺族长、以察族长、底珊族长。这些都是何利人的族长，在西珥地按着他们的宗族作族长的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","以色列人还没有君王统治之前，在以东地作王的记在下面： ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","比珥的儿子比拉在以东作王，他的京城名叫亭哈巴。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","比拉死后，波斯拉人谢拉的儿子约巴接替他作王。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","约巴死后，从提幔地来的户珊接替他作王。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","户珊死后，比达的儿子哈达接替他作王；这哈达就是在摩押原野上击败了米甸人的；他的京城名叫亚未得。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","哈达死后，玛士利加人桑拉接替他作王。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","桑拉死后，大河边的利河伯人扫罗接替他作王。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","扫罗死后，亚革波的儿子巴勒．哈南接替他作王。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","亚革波的儿子巴勒．哈南死后，哈达接替他作王；他的京城名叫巴乌；他的妻子名叫米希他别，是米．萨合的孙女、玛特列的女儿。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","以下是以扫所出族长的名字（他们是按着自己的家族和住处命名的）：亭纳族长、亚勒瓦族长、耶帖族长、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","阿何利巴玛族长、以拉族长、比嫩族长、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","基纳斯族长、提幔族长、米比萨族长、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","玛基叠族长和以兰族长。这些都是以东人的族长，在所得作为产业的地上，按着他们的住处作族长。以东的始祖就是以扫。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","雅各住在他父亲寄居的地方，就是迦南地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","雅各的历史记在下面：约瑟十七岁的时候，与他的哥哥们一同牧羊。他是个孩童，与他父亲的妾，辟拉和悉帕的众子，常在一起。约瑟把他们的恶行报告给父亲。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","以色列爱约瑟过于爱其他的儿子，因为约瑟是他年老时生的。他给约瑟做了一件彩色长衣。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","约瑟的哥哥们见父亲爱约瑟过于爱他们，就恨约瑟，不能与他和和气气地说话。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","约瑟作了一个梦，把梦告诉哥哥们，他们就越发恨他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","约瑟对他们说：“请听我所作的这个梦： ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","我们正在田间捆麦子，我的麦捆忽然站立起来，你们的麦捆都来围着我的下拜。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","他的哥哥们对他说：“你真的要作我们的王吗？真的要管辖我们吗？”他们就为了约瑟的梦和他的话，越发恨他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","后来约瑟又作了一个梦，也把梦向哥哥们述说了。他说：“我又作了一个梦，我梦见太阳、月亮和十一颗星向我下拜。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","约瑟把梦向他父亲和哥哥们述说了，他父亲就斥责他，说：“你所作的这梦是什么梦呢？我和你母亲，以及你的兄弟，真的要来俯伏在地向你下拜吗？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","他哥哥们都嫉妒他，他父亲却把这事记在心里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","约瑟的哥哥们去了示剑，牧放他们父亲的羊群。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","以色列对约瑟说：“你的哥哥们不是在示剑牧放羊群吗？来吧，我要派你到他们那里去。”约瑟回答他：“我在这里。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","以色列对他说：“你去看看你的哥哥们是不是平安，羊群是不是平安，就回来告诉我。”于是打发他离开希伯仑谷，他就到示剑去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","有人遇见约瑟在田间迷了路，就问他说：“你找什么？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","他回答：“我正在找我的哥哥们，请你告诉我他们在哪里牧放羊群。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","那人说：“他们已经离开了这里；我听见他们说：‘我们要到多坍去。’”于是约瑟去追寻哥哥们，结果在多坍找到了他们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","他们远远就看见了他；趁他还没有走近，大家就谋害他，要把他杀死。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","他们彼此说：“看哪，那作梦的人来了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","来吧，我们把他杀了，丢在一个枯井里，就说有猛兽把他吃了。我们要看看他的梦将来要怎么样。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","流本听见了，要救约瑟脱离他们的手。他说：“我们不可取他的性命。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","流本又对他们说：“不可流他的血，可以把他丢在这旷野的枯井里，不可下手害他。”流本的意思是要救他脱离他们的手，把他带回去给他的父亲。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","约瑟到了哥哥们那里，他们就脱去他的外衣，就是他穿在身上的那件彩衣。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","他们拿住约瑟，把他丢在枯井里。那井是空的，里面没有水。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","他们坐下吃饭，举目观看，见有一群以实玛利人从基列来。他们的骆驼载着香料、乳香和没药，要带下埃及去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","犹大对他的众兄弟说：“我们杀了我们的兄弟，把他的血隐藏起来，究竟有什么益处呢？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","我们不如把他卖给以实玛利人，不要下手害他，因为他是我们的兄弟，我们的骨肉。”众兄弟就听从了他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","有些米甸的商人经过那里，约瑟的哥哥们就把约瑟从枯井里拉上来，以二十块银子把他卖给以实玛利人。以实玛利人就把约瑟带到埃及去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","流本回到枯井那里，见约瑟不在井里，就撕裂自己的衣服。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","他回到兄弟们那里去，说：“孩子不见了，我可到哪里去呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","于是，他们宰了一只公山羊，把约瑟的长衣蘸在血里； ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","然后打发人把彩衣送到他们父亲那里，说：“这是我们找到的。请你认一认，是你儿子的长衣不是？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","他认出这件长衣，就说：“是我儿子的长衣，有猛兽把他吃了。约瑟真的被撕碎了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","雅各就撕裂自己的衣服，腰束麻布，为他儿子哀悼了很多日子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","他所有的儿女都起来安慰他，他却不肯接受他们的安慰，说：“我要悲悲哀哀地下到阴间，到我的儿子那里去。”约瑟的父亲就为他哀哭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","米甸人后来把约瑟卖到埃及去，卖给法老的一个臣宰，军长波提乏。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","那时，犹大离开他的众兄弟下去，到一个亚杜兰人的家里居住，那人名叫希拉。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","犹大在那里看见迦南人书亚的女儿，就娶了她，与她亲近。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","她就怀了孕，生了一个儿子，犹大给他起名叫珥。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","她又怀孕，生了一个儿子，给他起名叫俄南。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","她再怀孕，又生了一个儿子，就给他起名叫示拉。她生示拉的时候，犹大正在基悉。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","犹大为自己的长子珥娶妻，名叫他玛。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","犹大的长子珥，在耶和华眼中是个恶人，所以耶和华取去他的性命。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","于是犹大对俄南说：“你去与你哥哥的妻子亲近，向她尽你作弟弟的本分，替你的哥哥立后。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","俄南知道生下来的孩子不会归自己，所以每次与哥哥的妻子亲近的时候，都遗精在地上，免得替自己的哥哥立后。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","俄南所作的，在耶和华眼中是件恶事，所以耶和华也取去他的性命。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","于是，犹大对他的媳妇他玛说：“你回到你父亲家里去守寡，等我的儿子示拉长大。”因为他心里想：“恐怕示拉也像他两个哥哥一样死去。”他玛就回去，住在她父亲的家里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","过了很多日子，犹大的妻子，书亚的女儿死了。守丧的时间过了以后，犹大就和他的朋友亚杜兰人希拉上亭拿去，到替他羊群剪毛的人那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","有人告诉他玛说：“你的公公现在上亭拿去剪羊毛。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","他玛见示拉已经长大了，还没有娶她为妻，就脱去守寡的衣服，用帕子蒙脸，遮蔽自己，坐在亭拿路上，伊拿印的城门口。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","犹大看见她，以为她是个妓女，因为她蒙着脸。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","犹大就过到她那边去，说：“来吧，让我与你亲近。”原来他不知道她就是自己的媳妇。他玛说：“你与我亲近要给我什么呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","犹大说：“我从羊群中拿一只小山羊送给你。”他玛说：“在你没有送来以前，你可以留些东西作为保证吗？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","犹大问：“你要我给你什么作保证呢？”他玛回答：“你的印戒，连同印的带子，以及你手里的杖。”犹大就给了她，与她亲近，她就从犹大怀了孕。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","他玛起来走了，脱去帕子，再穿上守寡的衣服。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","犹大托自己的朋友亚杜兰人，把一只小山羊送去，要从那女人手中取回保证物，却找不着她。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","希拉问那地方的人说：“伊拿印路旁的妓女在哪里呢？”他们回答：“这里是没有妓女的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","那人回去见犹大，说：“我找不着她，并且那地的人都说：‘这里是没有妓女的。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","犹大说：“那些东西任她拿去吧，免得我们被人嗤笑。我已经把这小山羊送了去，可是你找不着她。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","大约过了三个月，有人告诉犹大说：“你的媳妇他玛作了妓女，并且因此怀了孕。”犹大说：“把她拉出来，烧死她。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","他玛被拉出来的时候，派人去见她的公公说：“这些东西是谁的，我就是从谁怀了孕。”她又说：“请你认一认，这印戒、印的带子和手杖是谁的？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","犹大认出那些东西，就说：“她比我更有理，因为我没有把她给我的儿子示拉为妻。”从此犹大就不再与她亲近了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","到了他玛将要生产的时候，腹中竟是一对双胎。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","她正在生产的时候，一个孩子伸出一只手来。接生婆拿了一根朱红线，系在他的手上，说：“这一个是先出生的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","他把手收回去的时候，他的哥哥就出来了。接生婆说：“你为什么抢着出来呢？”因此，给他起名叫法勒斯。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","接着，手上系着一根朱红线的弟弟也出来了。因此，给他起名叫谢拉。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","约瑟被带下埃及去了。有一个埃及人，是法老的臣宰，军长波提乏，从那些带约瑟下来的以实玛利人手里买了他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","耶和华与约瑟同在，约瑟就事事顺利，住在他主人埃及人的家里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","他的主人见耶和华与他同在，又见耶和华使他手里所作的尽都顺利， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","约瑟就得主人的欢心，服事他的主人。他主人指派他管理他的家，把自己所有的一切都交在他手里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","自从主人指派约瑟管理他的家，和他所有的一切，耶和华就因约瑟的缘故，赐福给那埃及人的家。他家里和田间所有的一切，都蒙耶和华赐福。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","波提乏把自己所有的一切，都交在约瑟的手里。除了自己所吃的饭以外，其他的事他一概不管。约瑟生来体格壮健，容貌俊美。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","这些事以后，约瑟主人的妻子以目传情给约瑟，说：“与我同睡吧。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","约瑟不肯，对他主人的妻子说：“你看，家中的事我主人一概不管；他把他所有的一切，都交在我的手里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","在这家里没有比我大的。除你以外，我主人没有留下一样不交给我，因为你是他的妻子。我怎可以作这极恶的事，得罪　神呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","她虽然天天对约瑟这样说，约瑟却不听从她，不肯与她同睡，也不与她在一起。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","有一天，约瑟到屋里办事，家里的人没有一个在屋里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","妇人就抓住约瑟的衣服，说：“与我同睡吧。”约瑟把自己的衣服留在妇人的手里，跑到外面去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","妇人见约瑟把衣服留在她手里，跑到外面去， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","就把家里的人都叫了来，对他们说：“你们看，我丈夫带回家来的希伯来人想调戏我。他进到我这里来，要与我同睡，我就大声呼叫。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","他一听见我高声呼叫，就把衣服留在我身边，跑到外面去了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","妇人把约瑟的衣服放在她身边，等她的主人回家。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","她又用同样的话对他说：“你带回家来的希伯来人，竟进到这里来，要调戏我。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","我高声呼叫，他就把衣服留在我身边，跑到外面去了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","约瑟的主人听了他妻子对他所说的话，说：“你的仆人就是这样对待我。”他就非常生气。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","于是，约瑟的主人拿住约瑟，把他关在监里，就是王的囚犯被监禁的地方；约瑟就在那里坐监。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","但是，耶和华与约瑟同在，向他施慈爱，使他得到监狱长的欢心。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","因此，监狱长把监里所有的囚犯都交在约瑟手里；他们在那里所作的一切事务，都由约瑟负责处理。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","凡交在约瑟手里的事务，监狱长一概不闻不问；因为耶和华与约瑟同在，使他所作的尽都顺利。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","这些事以后，埃及王的酒政和膳长，得罪了他们的主人埃及王。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","法老就恼怒酒政和膳长这两个臣宰， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","把他们关在军长府内的监房里，就是约瑟被囚禁的地方。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","军长把他们交给约瑟，约瑟就侍候他们。他们在监房里过了好些日子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","他们二人，就是被关在监里的埃及王的酒政和膳长，同一夜各作了一个梦，二人的梦各有不同的解释。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","到了早晨，约瑟进去到他们那里，见他们神色不安， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","就问法老的两个臣宰，就是与他一同关在他主人府内的监房里的，说：“今天你们的脸色为什么这样难看呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","他们回答他：“我们各人作了一个梦，但没有人能够解释。”约瑟对他们说：“解梦不是出于　神吗？请把梦告诉我吧。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","酒政就把自己的梦告诉约瑟，对他说：“在梦里我看见我面前有一棵葡萄树。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","葡萄树上有三根枝子；树一发芽，就开了花，上头的葡萄都成熟了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","法老的杯在我手里，我拿了葡萄挤在法老的杯中，把杯递在法老的手里。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","约瑟对他说：“这梦的解释是这样：三根枝子就是三天。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","三天之内，法老必使你抬起头来，恢复你原来的职位；你仍要把杯递在法老的手里，好像先前作他的酒政时一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","不过，你一切顺利的时候，求你记念我，施恩给我，在法老面前提拔我，救我脱离这监狱。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","我实在是从希伯来人之地被拐来；就是在这里，我也没有作过什么事该被关在监牢里的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","膳长见梦解得好，就对约瑟说：“我也作了一个梦，在梦里我看见自己头上有三篮白饼。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","最上面的篮子里，有为法老烤的各种食物，但飞鸟来吃我头上篮子里的食物。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","约瑟回答：“这梦的解释是这样：三个篮子就是三天。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","三天之内，法老必砍下你的头来，把你挂在木头上，必有飞鸟来吃你身上的肉。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","到了第三日，就是法老的生日，他为臣仆摆设筵席，在他们面前把酒政和膳长提出监来， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","恢复了酒政原来的职位，叫他可以把杯递在法老的手中； ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","法老却把膳长挂起来，正如约瑟给他们的解释一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","但是酒政并不记念约瑟，竟把他忘记了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","过了两年，法老作了一个梦，梦见自己站在河边。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","有七头母牛从河里上来，又健美又肥壮，在芦苇中吃草。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","接着，又有另外七头母牛从河里上来，又丑陋又瘦弱，站在岸上其他母牛旁边。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","这些丑陋瘦弱的母牛，竟把那些健美肥壮的母牛吃掉，法老就醒了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","他又睡着，作了第二个梦，梦见一根麦茎，长出七个麦穗，又肥壮又美好。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","接着，又长出七个麦穗，又干瘦又被东风吹焦了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","这些干瘦的麦穗，竟把那七个又肥壮又饱满的麦穗吞下去，法老就醒了，原来是一个梦。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","到了早晨，法老心里烦乱，就派人去把埃及所有的术士和智慧人都召了来；法老把自己的梦告诉他们，但是没有人能替法老解梦。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","那时酒政告诉法老说：“我今日想起了我的过错。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","从前法老恼怒臣仆，把我和膳长关在军长府的监房里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","我们二人在同一夜都作了梦；我们的梦各有不同的解释。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","在那里有一个希伯来的少年人与我们在一起，他是军长的仆人，我们把梦告诉了他，他就替我们解梦，各人的梦有不同的解释。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","结果，事情都照着他给我们的解释实现了：我恢复了原职，膳长却被挂起来。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","法老于是派人去召约瑟。他们就急忙把约瑟从监里带出来。他剃了头、刮了脸、换了衣服，就进去见法老。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","法老对约瑟说：“我作了一个梦，没有人能够解释。我听见人说，你听了梦，就能解释。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","约瑟回答法老，说：“解梦不在于我，但　神必给法老一个吉祥的解答。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","法老告诉约瑟：“在梦里我看见我站在河边。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","有七头母牛从河里上来，又肥壮又健美，在芦苇中吃草。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","接着，又有另外七头母牛上来，又软弱又消瘦又十分丑陋，在埃及全地我没有见过这样丑陋的牛。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","这又消瘦又丑陋的母牛，竟把先前七头肥壮的母牛吃掉。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","它们吃了以后，却看不出它们是吃掉了肥牛，因为它们丑陋的样子仍是与先前一样。我就醒了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","在梦里我又看见一根麦茎，长出七个麦穗，又饱满又美好。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","接着，又长出了七个麦穗，又枯干又干瘦又被东风吹焦了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","这些干瘦的麦穗，竟把那七个美好的麦穗吞下去。我把梦告诉了术士，但是没有人能替我解答。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","约瑟对法老说：“法老的梦都是同一个意思，　神已经把所要作的事告诉法老了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","七头美好的母牛是七年，七个美好的麦穗也是七年；两个梦都是同一个意思。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","那接着上来的七头又消瘦又丑陋的母牛是七年，那七个不结实、被东风吹焦了的麦穗也是七年，都是七年饥荒。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","这就是我对法老所说：　神要作的事，他已经向法老显明了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","看哪，埃及全地必有七年大丰收。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","接着又必有七年饥荒；甚至埃及地所有的丰收都被人忘记了，饥荒必把这地毁灭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","因为接着而来的饥荒太严重了，使人不觉得这地有过丰收。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","至于法老两次作梦，是因为　神已经命定这事，并且要快快地实行。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","因此，法老要找一个有见识有智慧的人，派他管理埃及地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","法老要这样行，在国中指派官员，当七年丰收的时候，征收埃及地出产的五分之一。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","又叫他们把将要来的七个丰年的粮食收集起来，积蓄五谷归在法老的手下，收在各城里作粮食。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","这些粮食要储存起来，可以应付将来埃及地的七年饥荒，免得这地被饥荒所灭。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","法老和他的臣仆，都赞同这件事。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","于是法老对臣仆说：“像这样的人，有　神的灵在他里面，我们怎能找得着呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","法老对约瑟说：“　神既然把这事指示了你，就再没有人像你这样有见识有智慧了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","你可以掌管我的家，我的人民都要听从你的话；只有在王位上我比你大。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","法老又对约瑟说：“你看，我任命你治理埃及全地。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","于是，法老脱下他手上打印的戒指，戴在约瑟的手上；给他穿上细麻的衣服，把金颈链挂在他的颈项上； ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","又叫约瑟坐在他的副车，有人在他前面喊着：“跪下。”这样，法老任命了约瑟治理埃及全地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","法老对约瑟说：“我是法老，但在埃及全地，如果没有你的许可，没有人可以随意作事。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","法老给约瑟起名叫撒发那忒．巴内亚，又把安城的祭司波提非拉的女儿亚西纳，给约瑟为妻。约瑟出去巡行埃及全地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","约瑟侍立在埃及王法老面前的时候，年三十岁。约瑟从法老面前出来，遍行埃及全地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","在七个丰年的时候，地里的出产非常丰盛。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","约瑟把埃及七个丰年的一切粮食都收集起来，把粮食存放在城中；各城周围田地所出的粮食，也存放在各城中。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","约瑟积蓄了极多的五谷，好像海沙那样多，甚至他不再记下数量，因为实在无法计算。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","在荒年还没有来到以前，约瑟生了两个儿子，是安城的祭司波提非拉的女儿亚西纳给约瑟生的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","约瑟给长子起名叫玛拿西，因为他说：“　神使我忘记我所有的困苦，以及我父的全家。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","他给次子起名叫以法莲，因为他说：“　神使我在受苦之地繁盛起来。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","埃及地的七年丰收一结束， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","七年饥荒就随着来了，正像约瑟所说的一样。各地都有饥荒，只有埃及全地仍有粮食， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","等到埃及全地也要挨饿的时候，人民就向法老求粮。法老对所有的埃及人说：“你们到约瑟那里去，他吩咐你们什么，你们就作什么。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","当时饥荒遍及全国，约瑟就开了所有的粮仓，把粮食卖给埃及人，因为埃及地的饥荒非常严重。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","各地的人都到埃及去，向约瑟买粮，因为各地的饥荒都非常严重。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","雅各见埃及有粮食，就对儿子们说：“你们为什么彼此对望呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","他又说：“我听说埃及有粮食，你们下到那里去，给我们买些粮食，使我们可以活下去，不至饿死。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","于是，约瑟的十个哥哥就下去了，要从埃及买五谷。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","但雅各并没有打发约瑟的弟弟便雅悯与哥哥们同去，因为雅各说：“恐怕他会遇到灾害。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","以色列的众子也在前来买粮的人群中，因为迦南地也有饥荒。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","当时治理埃及地的官长是约瑟，卖粮给那地所有的人民的就是他。所以，约瑟的哥哥们来俯伏在地向他下拜。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","约瑟看见他的哥哥们，就认得他们，可是他装作陌生人，对他们说严厉的话，问他们：“你们是哪里来的？”他们回答：“我们是迦南地来买粮食的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","约瑟认得他的哥哥们，他们却不认得他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","约瑟想起从前所作关于他们的两个梦，就对他们说：“你们是间谍，是来侦察本地的虚实。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","他们对他说：“我主啊，不是这样，仆人们实在是来买粮食的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","我们都是一个人的儿子，是诚实人；仆人们并不是间谍。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","约瑟对他们说：“不是的，你们实在是来侦察本地的虚实。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","他们说：“仆人们本是兄弟十二人，我们都是迦南地一个人的儿子。最小的现在与我们的父亲在一起，还有一个不在了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","约瑟对他们说：“我刚才对你们说：‘你们是间谍。’这话实在不错。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","我要这样试试你们：我指着法老的性命起誓，如果你们最小的弟弟不到这里来，你们就决不得离开这里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","你们可以派你们中间一个人回去，把你们的弟弟带来；其余的人都要囚禁起来，好证明你们的话真实不真实。如果不真实，我指着法老的性命起誓，你们就是间谍。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","于是，约瑟把他们收在监房里三天。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","到了第三天，约瑟对他们说：“我是敬畏　神的，你们要这样作，就可以活着； ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","如果你们是诚实人，就叫你们兄弟中一个人囚禁在监里，你们其余的人可以带着粮食回去，解救你们家人的饥荒。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","然后把你们最小的弟弟带到我这里来，这样，就可以证明你们的话是真实的，你们就不必死了。”他们就照样作了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","他们彼此说：“我们在对待弟弟的事上实在有罪。他向我们求情的时候，我们看见他心里的痛苦，却不肯听他，所以这次苦难临到我们身上了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","流本回答他们，说：“我不是对你们说过：‘不要伤害那孩子’吗？可是你们不肯听，现在流他血的罪要向我们追讨。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","他们不知道约瑟听得明白，因为他们中间有人当传译。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","约瑟转身离开他们，哭了一阵，又回到他们那里，与他们说话。然后从他们中间拉出西缅来，在他们眼前把他捆绑起来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","约瑟吩咐人把五谷装满他们的袋，把他们的银子放回各人的布袋里；又给他们路上用的食物。一切就照样办了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","他们把粮食驮在他们的驴上，离开那里去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","到了住宿的地方，他们其中的一个人打开了布袋，要拿饲料喂驴的时候，才发现自己的银子还在袋口那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","于是对兄弟们说：“我的银子都归还了。你们看，就在我的布袋里。”他们就心里惊慌，彼此战战兢兢地说：“　神向我们作的是什么呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","他们回到迦南地他们的父亲雅各那里，把他们遭遇的一切事都告诉了他，说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“那地的主人对我们说了一些严厉的话，把我们当作侦察那地的间谍。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","我们对他说：‘我们是诚实人，并不是间谍。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","我们本是兄弟十二人，都是一个父亲的儿子；有一个不在了，最小的现在与我们的父亲一起在迦南地。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","那地的主人对我们说：‘我用这个办法就可以知道你们是不是诚实人：你们兄弟中要留下一人在我这里，其余的人可以带着粮食回去，解救你们家人的饥荒。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","然后把你们最小的弟弟带到我这里来，我就知道你们不是间谍，而是诚实人了。这样，我就把你们的兄弟交还给你们，你们也可以在这地自由来往。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","后来他们倒布袋的时候，不料各人的银包仍然在各人的布袋里。他们和他们的父亲看见了银包，就都惧怕起来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","他们的父亲雅各对他们说：“你们总是使我丧失儿子：约瑟没有了，西缅也没有了，你们还要把便雅悯带走；每一件事都是针对我。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","流本对他父亲说：“如果我不把他带回来给你，你可以杀死我的两个儿子；只管把他交给我吧，我必把他带回来给你。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","雅各说：“我的儿子不可与你们一同下去，因为他的哥哥死了，只剩下他一个；如果他在你们所走的路上遇到不幸，你们就使我这白发老人愁愁苦苦地下阴间去了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","那地的饥荒十分严重。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","他们把从埃及带回来的粮食都吃完了。他们的父亲就对他们说：“你们再去替我们买些粮食回来吧。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","犹大对他说：“那人认真地警告我们说：‘如果你们的弟弟不与你们一起来，你们就不得见我的面。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","如果你让我们的弟弟与我们同去，我们就下去替你买粮食。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","如果你不让他去，我们也不下去，因为那人对我们说：‘如果你们的弟弟不与你们一起来，你们就不得见我的面。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","以色列说：“你们为什么这样害我，告诉那人你们还有个弟弟呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","他们回答：“那人确实查问有关我们和我们亲属的事，说：‘你们的父亲还活着吗？你们还有其他的兄弟吗？’我们就照着这些话回答他。我们怎么知道他会说：‘你们必要把你们的弟弟带下来’呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","犹大对他父亲以色列说：“你若打发那孩子与我同去，我们就立刻起程，好叫我们和你，以及我们的孩子都可以存活，不至饿死。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","我愿意亲自担保他的安全，你可以从我手里追回他。如果我不把他带回来给你，交在你面前，我愿终生承担这罪。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","要不是我们耽延，现在第二次也回来了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","他们的父亲以色列对他们说：“如果必须如此，你们就这样作：你们把本地最好的出产放在袋里，带下去给那人作礼物，就是一点乳香、一点蜂蜜、香料、没药、粟子和杏仁。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","你们手里要多带一倍银子，因为你们要把那放回在你们袋口里的银子带回去，那可能是弄错了的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","你们带着你们的弟弟，起程再到那人那里去吧。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","愿全能的　神使那人怜悯你们，给你们释放你们那个兄弟和便雅悯。至于我，如果要丧失儿子，就丧失了吧。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","于是，他们带着这些礼物，手里拿着多一倍的银子，并且带着便雅悯，起程下到埃及去，站在约瑟面前。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","约瑟见便雅悯与他们同来，就对管家说：“把这些人带到我家里，要宰杀牲畜，预备筵席，因为在正午的时候，这些人要与我一起吃饭。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","管家就照着约瑟所吩咐的去作，把这些人带到约瑟的家里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","他们因为被领到约瑟的家里，就害怕起来，说：“我们被领到这里来，必定是为了头一次放回在我们袋里的银子，现在他们想攻击我们，制伏我们，逼我们作奴仆，又夺去我们的驴。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","他们于是走近约瑟的管家，在屋门口与他说话。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","他们说：“先生啊，我们头一次下来，实在是要买粮食的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","后来我们来到住宿的地方，打开布袋的时候，不料各人的银子仍然在各人的袋口里，分文不少；现在我们手里又带回来了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","我们手里又另外带来银子，是买粮食用的。我们不知道头一次谁把我们的银子放在我们的布袋里。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","管家说：“你们可以放心，不要害怕，是你们的　神，你们父亲的　神，把财宝赐给你们，放在你们的布袋里。你们的银子我早已收到了。”接着他把西缅带出来交给他们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","管家把他们领到约瑟的家里，给他们水洗脚，又给他们饲料喂驴。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","于是，他们预备好了礼物，等候约瑟中午到来，因为他们听说他们要在那里吃饭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","约瑟回到家里，他们就把手中的礼物带进屋里送给他，又俯伏在地向他下拜。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","约瑟先向他们问安，然后又问：“你们的父亲，就是你们所说的那老人家平安吗？他还在吗？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","他们回答：“你仆人我们的父亲平安，他还在。”于是他们低头下拜。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","约瑟举目观看，看见自己同母所生的弟弟便雅悯，就问：“这就是你们向我提过那最小的弟弟吗？”又说：“我儿啊，愿　神赐恩给你。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","约瑟爱弟弟之情激动起来，就急忙去找个可哭的地方。于是他进了自己的内室，在那里哭了一阵。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","他洗了面，然后出来，抑制着自己的感情，吩咐人说：“开饭吧。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","他们就给约瑟单独摆了一席，给那些人另外摆了一席，又给那些与约瑟一同吃饭的埃及人摆了一席，因为埃及人不能与希伯来人一同吃饭，这是埃及人所厌恶的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","约瑟使众兄弟在他面前排列坐下，都是照着他们长幼的次序。众兄弟就彼此对望，惊奇不已。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","约瑟拿起自己面前的食物，分给他们，但是便雅悯分得的食物，比别人多五倍。他们就与约瑟一同喝酒宴乐。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","约瑟吩咐管家说：“把粮食装满这些人的布袋，要尽他们所能携带的，又把各人的银子放在他们的袋口； ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","把我的银杯，放在最小的袋口，连同他买粮食的银子放进去。”管家就照着约瑟吩咐的话去作。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","早晨天一亮，那些人和他们的驴子都被打发走了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","他们出了城，走了不远，约瑟就对管家说：“起来，追赶那些人；追上了，就对他们说：‘你为什么以恶报善呢？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","这不是我主人喝酒和占卜用的杯吗？你们所作的，实在不对。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","管家追上了他们，就对他们说了这些话。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","他们对管家说：“我主为什么说这样的话呢？你的仆人绝不会作这样的事。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","你看，我们从前在袋口发现的银子，尚且从迦南地带来还给你，我们又怎会从你主人的家里偷取金银呢？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","在你仆人当中，无论在谁那里搜出来，谁就要死，我们也要作我主的奴仆。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","管家说：“现在就照你们的话作吧，只是在谁那里搜出来，谁就要作我的奴仆，其余的人都没有罪。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","于是，他们急忙把自己的布袋卸在地上，各人打开自己的布袋。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","管家就搜查，从最大的开始，查到最小的。那杯竟在便雅悯的布袋里搜出来了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","他们就撕裂自己的衣服，各人又把担子驮在驴上，回城去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","犹大和他的兄弟来到约瑟的家里，那时约瑟还在那里；他们就在他面前俯伏在地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","约瑟对他们说：“你们所作的是什么事呢？你们不知道像我这样的人必能占卜吗？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","犹大说：“我们对我主可以说什么呢？我们还有什么可说的呢？我们怎能证明自己是清白的呢？　神已经查出你仆人们的罪孽了。看哪，我们和那在他手里搜出杯来的，都是我主的奴仆了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","约瑟说：“我绝不能这样作。在谁的手里搜出杯来，谁就要作我的奴仆；你们其余的人，可以平平安安地上你们父亲那里去。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","犹大走近约瑟身边，说：“我主啊，求你容许仆人说一句话给我主听，请不要向仆人发烈怒，因为你好像法老一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","我主曾经问仆人们说：‘你们还有父亲或其他兄弟没有？’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","我们曾经回答我主：‘我们还有年老的父亲和最小的弟弟，是他年老时所生的。他的哥哥死了，他母亲只剩下他一个孩子，他父亲非常爱他。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","你就对仆人们说：‘把他带下来到我这里，我要亲眼看看他。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","我们对我主说：‘那孩子是不能离开他父亲的；如果离开了，他父亲必定死。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","你对仆人们说：‘如果你们最小的弟弟不与你们一同下来，你们就不得见我的面。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","于是，我们上到你仆人我们的父亲那里，就把我主的话告诉了他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","后来我们的父亲说：‘你们再去替我们买些粮食回来吧。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","我们就说：‘我们不能下去，如果有我们最小的弟弟与我们同去，我们就下去；因为我们最小的弟弟不与我们同去，我们就不得见那人的面。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","你仆人我的父亲对我们说：‘你们知道我的妻子只给我生了两个儿子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","一个已经离开我去了，我想他必定是被野兽撕碎了；直到现在，我也没有见过他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","现在你们又要把这个从我面前带去，如果他遇到不幸，你们就使我这个白发老人，悲悲惨惨地下阴间去了。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","我父亲的命与这孩子的命，是相连在一起的。现在我回到你仆人我的父亲那里，如果没有孩子与我们在一起， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","他一见没有孩子，就必定死；这样，你仆人们就使你仆人我们的父亲，这个白发老人，愁愁苦苦地下阴间去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","因为仆人曾经向父亲担保这孩子的安全，说：‘如果我不把他带回来交还给你，我就在父亲面前终生承担这罪。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","现在求你容许仆人留下，代替这孩子作我主的奴仆，让这孩子与他的哥哥们一同上去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","因为如果孩子没有与我同去，我怎能上去见我的父亲呢？恐怕我会看见灾祸临到我父亲身上。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","约瑟在所有侍立在他左右的人面前，不能自制，就喊叫说：“叫各人都离开我出去。”这样，约瑟向他的兄弟们表白自己身分的时候，没有别人在场。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","于是他放声大哭，埃及人听到了；法老一家也听闻这事。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","约瑟对他的兄弟们说：“我就是约瑟，我的父亲还在吗？”他的兄弟们不能回答他，因为他们在约瑟面前都非常惊惶。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","约瑟对他的兄弟们说：“请你们上前来。”他们就上前去。他说：“我就是被你们卖到埃及的弟弟约瑟。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","现在你们不要因为把我卖到这里来，而自忧自责。这原是　神差派我在你们以先来这里，为要保全性命。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","现在这地的饥荒已经有两年了，还有五年不能耕种，也没有收成。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","神差派我在你们以先来这里，为要给你们在地上留下余种，大大施行拯救，保全你们的性命。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","这样看来，差派我到这里来的，不是你们，而是　神。他立我作法老之父，作他全家之主，又作全埃及地的首相。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","你们要赶快上到我父亲那里去，对他说：‘你的儿子约瑟这样说：　神立我作了全埃及的主；请你下到我这里来，不要耽延。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","你和你的众儿孙、牛羊，以及你一切所有的，都可以住在歌珊地，与我相近。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","我要在那里供养你，因为还有五年的饥荒，免得你和你的家人，以及你一切所有的，都陷入穷困里。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","看哪，你们和我弟弟便雅悯都亲眼看见，是我亲口对你们说话。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","你们也要把我在埃及的一切尊荣，和你们所看见的一切，都告诉我的父亲，又要赶快把我的父亲接到这里来。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","于是，约瑟伏在他弟弟便雅悯的颈项上，哭起来了；便雅悯也伏在约瑟的颈项上哭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","他又与众兄弟亲嘴，拥抱着他们哭。然后，他的兄弟们就跟他说话。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","消息传到法老的家里，说：“约瑟的兄弟们来了。”法老和他的臣仆都很高兴。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","法老对约瑟说：“你要对你的兄弟们说：‘你们要这样作：使你们的牲口载满货物，起程到迦南地去， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","把你们的父亲和家人都接到我这里来；我要把埃及地美好的产物赐给你们，你们也可以吃这地肥美的食物。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","现在我再吩咐你对他们说：‘你们要这样作：从埃及地带些车辆回去，用来接你们的孩子和妻子，并且把你们的父亲接来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","不要顾惜你们的家具，因为埃及全地美好的产物都是你们的。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","以色列的儿子们就照样作了。约瑟照着法老所吩咐的，给了他们一些车辆和路上用的食物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","又给了他们各人一套新衣服，但是给便雅悯三千四百二十克银子和五套衣服。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","约瑟送去给他父亲的，有公驴十头，载着埃及美好的产物，以及母驴十头，载着五谷、饼和给他父亲在路上用的食物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","于是，约瑟打发他的兄弟们回去，他们走的时候，约瑟对他们说：“你们在路上不要争吵。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","他们离开埃及，上到迦南地他们父亲雅各那里去， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","告诉他，说：“约瑟还在，并且作了埃及全地的首相。”雅各的心冷淡麻木，因为他不相信他们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","他们就把约瑟对他们所说的一切话，都告诉了他。他们的父亲雅各看见了约瑟派来接他的车辆，心才苏醒过来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","以色列说：“够了！约瑟我的儿子还在；在我还没有死以前，我要去看看他。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","以色列带着他所有的一切起程，到了别是巴，就向他父亲以撒的　神献祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","神在夜间的异象中对以色列说：“雅各，雅各。”雅各说：“我在这里。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","神说：“我是　神，就是你父亲的　神；你不要怕下埃及去，因为我必使你在那里成为大国。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","我要亲自与你一同下到埃及去，也必把你带上来。约瑟要亲手合上你的眼给你送终。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","雅各就从别是巴起程。以色列的众子，用法老为雅各送来的车辆，接载他们的父亲雅各，以及他们的孩子和妻子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","他们又带着牲畜，和他们在迦南地所得的财物，来到埃及。这样，雅各和他所有的子孙，都一同来了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","雅各把他的众儿子、孙子、女儿、孙女和他所有的后裔，都一同带到埃及去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","来到埃及的以色列人，就是雅各和他的子孙，名单记在下面：雅各的长子是流本。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","流本的儿子是哈诺、法路、希斯仑和迦米。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","西缅的儿子是耶母利、雅悯、阿辖、雅斤、琐辖和迦南女子所生的扫罗。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","利未的儿子是革顺、哥辖和米拉利。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","犹大的儿子是珥、俄南、示拉、法勒斯和谢拉，但是珥和俄南都在迦南地死了。法勒斯的儿子是希斯伦和哈母勒。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","以萨迦的儿子是陀拉、普瓦、哟伯和伸仑。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","西布伦的儿子是西烈、以伦和雅利。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","以上这些人是利亚在巴旦．亚兰给雅各生的儿子，另外还有女儿底拿。这些子孙一共三十三人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","迦得的儿子是洗非芸、哈基、书尼、以斯本、以利、亚罗底和亚列利。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","亚设的儿子是音拿、亦施瓦、亦施韦和比利亚，还有他们的姊妹西拉。比利亚的儿子是希别和玛结。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","以上这些人是拉班给女儿利亚作婢女的悉帕给雅各生的子孙，一共十六人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","雅各的妻子拉结，生了约瑟和便雅悯。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","约瑟在埃及地生了玛拿西和以法莲，就是安城的祭司波提非拉的女儿亚西纳给约瑟生的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","便雅悯的儿子是比拉、比结、亚实别、基拉、乃幔、以希、罗实、母平、户平和亚勒。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","以上这些人是拉结给雅各生的子孙，一共十四人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","但的儿子是户伸。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","拿弗他利的儿子是雅薛、沽尼、耶色和示冷。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","以上这些人是拉班给女儿拉结作婢女的辟拉给雅各生的子孙，一共七人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","所有从雅各所生、与雅各一同来到埃及的人，除了他的儿妇之外，一共六十六人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","另外还有约瑟在埃及所生的两个儿子。雅各家来到埃及的所有成员，一共七十人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","雅各派犹大先到约瑟那里去，请约瑟指教他去歌珊的路。于是他们来到歌珊地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","约瑟预备了车，上去歌珊迎接他的父亲以色列。约瑟一看见他，就伏在他的颈项上，在他的颈项上哭了很久。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","以色列对约瑟说：“这一次我看见了你的面，知道你还在，我死了也甘心。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","约瑟对他的兄弟们和他的父家说：“我要上去告诉法老，对他说：‘我在迦南地的兄弟们和我的父家，都到我这里来了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","这些人都是牧羊人，以牧养牲畜为生。他们把自己的牛羊和一切所有的，都带来了。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","法老召见你们的时候，如果问你们：‘你们是作什么的？’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","你们就要回答：‘仆人们从幼年直到现在，都是以牧养牲畜为生。我们和我们的祖先都是一样。’这样，你们就可以住在歌珊地，因为埃及人厌恶所有牧羊的人。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","约瑟进去禀告法老，说：“我的父亲和兄弟们，带着他们的牛羊和他们所有的一切，都从迦南地来了，现在就在歌珊地。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","约瑟从他所有的兄弟当中，挑选了五个人，把他们带到法老面前。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","法老问约瑟的兄弟们说：“你们是作什么的？”他们回答法老：“仆人们是牧羊人，我们和我们的祖先都是一样。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","他们又对法老说：“我们来是要在这地寄居，因为迦南地的饥荒严重，你仆人们的羊群没有草吃，所以，现在求你容许你仆人住在歌珊地。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","法老对约瑟说：“你的父亲和兄弟们到你这里来了； ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","埃及地都在你面前，你只管叫你的父亲和兄弟们住在这地最好的地方，他们可以住在歌珊地。你如果知道他们中间有能干的人，可以派他们看管我的牲畜。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","约瑟把他父亲雅各带到法老面前，雅各就给法老祝福。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","法老问雅各：“你有多大年纪了？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","雅各回答法老：“我寄居在世的年日是一百三十岁。我一生的年日又少又苦，不及我祖先寄居在世的年日。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","雅各又给法老祝福，然后离开法老出去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","约瑟照着法老的吩咐安置他的父亲和兄弟们，把兰塞地，就是埃及地最好的地方，给他们作产业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","约瑟照着孩子的数目，用粮食供养他的父亲、兄弟们，以及父亲的家人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","那时，遍地都没有粮食，因为饥荒非常严重。埃及地和迦南地的人，因为饥荒的缘故都饿昏了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","约瑟收集了埃及地和迦南地所有的银子，就是众人买粮的银子；约瑟就把那些银子交到法老的王宫去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","埃及地和迦南地的银子都用尽了，埃及众人就来到约瑟那里，说：“银子已用完了。求你给我们粮食吧，我们为什么要饿死在你面前呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","约瑟回答：“如果银子用完了，可以把你们的牲畜给我，我就把粮食给你们，交换你们的牲畜。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","于是，他们把牲畜带到约瑟那里，约瑟就把粮食给他们，交换他们的马匹、羊群、牛群和驴。那一年，约瑟就用粮食交换他们所有的牲畜，来养活他们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","那一年过后，第二年他们又来到约瑟那里，对他说：“我们不向我主隐瞒，我们的银子都用尽了，牲畜也归了我主；在我主面前，除了我们的身体和田地以外，什么也没有剩下了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","为什么我们和我们的田地要在你面前消灭呢？求你用粮食买我们和我们的田地，我们和田地就必为法老效劳了。又求你给我们谷种，使我们可以活着，不至死亡，田地也不至荒芜。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","于是，约瑟为法老买了埃及所有的田地，因为埃及人遭遇了严重的饥荒，各人都卖了自己的田地。这样，那地就都归法老所有。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","至于人民，约瑟把他们迁到城市里去（“约瑟把他们迁到城市里去”有古卷及古译本作“使他们成了奴仆”），从埃及境内的一端，直到另一端。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","只有祭司的田地，约瑟没有买，因为祭司有从法老所得的粮饷；他们可以吃法老所给的粮饷，所以没有卖自己的田地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","约瑟对人民说：“看哪，我今日为法老买了你们和你们的田地。这里有谷种给你们，你们可以种地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","到了收割的时候，你们要把五分之一给法老，其余四分可以归你们自己，作田里的种子，又作你们以及你们家人和孩子的食物。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","他们说：“你救了我们；愿我们在我主面前得蒙喜悦，我们就作法老的奴仆。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","于是，约瑟为埃及的田地立了一个法例，直到今日还有效，就是五分之一归给法老；只有祭司的田地不归给法老。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","以色列人住在埃及国的歌珊地，他们在那里置业繁殖，人数非常众多。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","雅各在埃及地住了十七年；他一生的寿数是一百四十七岁。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","以色列的死期快到了，就把他儿子约瑟叫了来，对他说：“如果我在你面前蒙你喜悦，请你把手放在我的大腿底下起誓，要以慈爱和诚实对待我，不要把我埋葬在埃及。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","我与我的祖先同睡的时候，你要把我从埃及带出去，埋葬在他们的墓地里。”约瑟说：“我必照着你的话去作。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","雅各说：“你要向我起誓。”约瑟就向他起了誓，于是以色列靠着床头（“靠着床头”有古译本作“倚着杖头”﹝参来 11:21﹞）敬拜　神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","这些事以后，有人对约瑟说：“你的父亲病了。”约瑟就带着两个儿子玛拿西和以法莲同去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","有人告诉雅各，说：“你的儿子约瑟到你这里来了。”以色列就勉强在床上坐起来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","雅各对约瑟说：“全能的　神曾经在迦南地的路斯向我显现，赐福给我， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","对我说：‘我必使你繁殖增多，成为一大族；我必把这地赐给你的后裔，作永远的产业。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","我未到埃及见你之前，你在埃及地生了两个儿子，现在他们算是我的；以法莲和玛拿西是我的，好像流本和西缅是我的一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","你在他们以后所生的子孙，都是你的；不过，在继承产业的事上，他们可以归在他们哥哥的名下。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","至于我，我从巴旦回来的时候，在迦南地的路上，那里到以法他还有一段路程，拉结就死在我身边；我在那里把她埋葬在以法他的路旁。以法他就是伯利恒。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","以色列看见约瑟的儿子，就问：“他们是谁？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","约瑟回答父亲：“他们是我的儿子，是　神在这里赐给我的。”以色列说：“把他们领到我这里来，我要给他们祝福。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","以色列因为年老，眼睛昏花，看不清楚。约瑟领他们到他跟前去，他就与他们亲嘴，拥抱他们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","以色列对约瑟说：“我想不到可以看见你的面，现在　神竟使我见到你的后裔。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","约瑟把两个儿子从以色列膝上抱下来，自己脸伏在地下拜。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","约瑟领着他们两个到以色列的跟前，以法莲在约瑟的右边对着以色列的左边；玛拿西在约瑟的左边对着以色列的右边。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","但是，以色列两手交叉，右手按在次子以法莲的头上，左手按在长子玛拿西的头上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","要祝福约瑟，说：“愿我祖亚伯拉罕和以撒所侍候的　神，一生牧养我直到今日的　神， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","那救我脱离一切祸患的使者，赐福给这两个童子。愿我的名，我祖亚伯拉罕和以撒的名，借着他们得以流传；愿他们在地上生养众多。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","约瑟见他父亲把右手按在以法莲的头上，心里就不高兴，于是拿住他父亲的手，要从以法莲的头上移到玛拿西的头上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","约瑟对他父亲说：“爸爸啊，不是这样，这个才是长子，请你把右手按在他的头上。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","他父亲却不肯，说：“我知道，我儿啊，我知道，他也要成为一族，也要强大；只是他弟弟比他还要强大，他的后裔要成为多族。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","那一天，以色列给他们祝福，说：“以色列人要用你的名祝福人，说：‘愿　神使你像以法莲和玛拿西一样。’”于是，以色列立以法莲在玛拿西之上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","以色列又对约瑟说：“看哪，我快要死了，但是　神必与你们同在，必领你们回到你们祖先的土地去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","现在我把从前用刀和弓，从亚摩利人手中夺过来的那块山地赐给你，使你比众兄弟多得一份。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","雅各把他的众子叫来，说：“你们要聚集在一起，我要把你们日后必遇到的事告诉你们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","雅各的儿子们哪，你们要一起来听；要听你们父亲以色列的话。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","流本哪，你是我的长子，是我的力量，是我的初生子；你大有尊荣，权力超众； ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","但是你放纵情欲，好像水沸腾一样，你必不能居首位；因为你上了你父亲的床；上了我的榻，然后把它玷污了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","西缅和利未是兄弟；他们的刀剑是强暴的武器。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","我的灵啊，不可加入他们的阴谋；我的心啊，不可参与他们的集会，因为他们在怒中杀人，任意砍断牛的腿筋。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","他们的怒气可咒，因为非常暴烈；他们的烈怒可诅，因为十分凶猛；我要把他们分散在雅各家；把他们散居在以色列。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","犹大啊，你的兄弟们要称赞你；你的手必压住仇敌的颈项；你父亲的众子必向你下拜。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","犹大是只小狮子；我儿啊，你猎取了食物就上到洞穴去。他屈身伏卧，好像公狮，又像母狮，谁敢惊动他呢？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","权杖必不离开犹大，王圭必不离他两脚之间，直到细罗（“细罗”有古?本作“属他的那位”）来到，万族都要臣服他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","犹大把自己的驴驹拴在葡萄树旁，把自己的小驴系在上等的葡萄树旁；他在葡萄酒中洗净自己的衣服，在血红的葡萄汁中洗衣袍。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","他因饮酒而双眼发红，他因喝奶而牙齿雪白。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","西布伦必在沿海地带居住，他必成为船只停泊的港口，他的边界必伸到西顿。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","以萨迦是一头粗壮的驴，伏卧在羊圈（“羊圈”原文意思不详，或译：“重驮”）之间； ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","他看安居为美，他看肥地为佳，他屈肩负重，成了服苦的奴仆。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","但要审判自己的人民，作以色列的一个支派。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","但要作路上的蛇，道中的毒蛇，他要咬伤马蹄，使骑马的人向后坠落。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","耶和华啊，我向来等候你的拯救。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","迦得必被侵略者追逼，他却要追逼他们的脚跟。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","至于亚设，他的食物必定肥美，他有美食可以供奉君王。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","拿弗他利是只得释放的母鹿，发出优美的言语。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","约瑟是一根结果子的树枝，是一根泉旁结果子的树枝，他的枝条蔓延出墙外。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","弓箭手把他苦害，向他射箭敌对他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","但他的弓依然坚硬，他的手臂仍旧敏捷，这是出于雅各的大能者之手；出于以色列的牧者，以色列的磐石。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","是你父亲的　神帮助你，是那全能者赐给你；他把从天上来的福，地下深渊蕴藏着的福，哺乳和生育的福，都赐给你。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","你父亲的祝福，胜过我祖先的祝福（“胜过我祖先的祝福”有古?本作“胜过亘古的山冈”），胜过永远山岭上的美物。愿这些福都降在约瑟的头上，降在兄弟中作王子的那一位头上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","便雅悯是只撕掠的豺狼，早晨吞吃他的猎物，晚上瓜分他的掳物。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","这些就是以色列的十二支派；以上是他们父亲对他们所说的话，是按着各人的福分给他们所祝的福。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","雅各又嘱咐他们，对他们说：“我快要归到我的亲族那里去，你们要把我埋葬在赫人以弗仑田间的洞里，与我的祖先在一起。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","这个洞在迦南地，在幔利前面的麦比拉的田间。那地方原是亚伯拉罕向赫人以弗仑买下来作坟地的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","他们在那里埋葬了亚伯拉罕和他的妻子撒拉；又在那里埋葬了以撒和他的妻子利百加；我也在那里埋葬了利亚。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","那块田和田间的洞，是向赫人买来的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","雅各对他的众子嘱咐完了，就把双脚收回床上，气绝而死，归到他的亲族那里去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","约瑟伏在他父亲的脸上，为他哀哭，与他亲嘴。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","约瑟吩咐臣仆中作医生的，用香料包殓了他的父亲。他们就用香料包殓了以色列。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","这事足足费了四十天，因为用香料包殓尸体是需要这样长的时间。埃及人为他哀哭了七十天。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","为他哀哭的日子过了，约瑟就对法老家里的人说：“我若在你们面前得蒙喜悦，请你们代我禀告法老说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘我父亲曾经叫我起誓，说：“看哪，我快要死了；你要把我埋葬在迦南地，在我为自己所掘的坟墓里。”现在求你让我上去，埋葬我的父亲，之后我必定回来。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","法老说：“你可以上去，照着你父亲叫你起的誓，把他埋葬。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","于是，约瑟上去埋葬他的父亲。与他一同上去的，有法老所有的臣仆，法老家中的长老，和埃及地所有的长老， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","还有约瑟的全家，他的兄弟们和他父亲的家人；他们把孩子和牛羊留在歌珊地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","又有车辆和马兵与他一同上去，成了一大队行列。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","他们到了约旦河东岸的亚达禾场，就在那里大大地哀悼痛哭。约瑟为他父亲举哀七天。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","住在那地的迦南人看见了亚达禾场的哀悼，就说：“这是埃及人一场非常伤痛的哀悼。”因此，在约旦河东岸的那地方名叫亚伯．麦西。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","雅各的众子就照着父亲嘱咐他们的去作， ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","把雅各运到迦南地，葬在麦比拉田间的洞里。那地方在幔利的前面，是亚伯拉罕向赫人以弗仑买下来作坟地的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","约瑟埋葬了他父亲以后，就和他的众兄弟，以及所有与他一同上去埋葬他父亲的人都回埃及去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","约瑟的哥哥们看见父亲死了，就说：“或者约瑟仍然会怀恨我们，要报复我们从前向他所作的一切恶事。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","他们就打发人到约瑟那里，说：“你父亲未死以前曾经嘱咐说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘你们要对约瑟这样说：从前你的哥哥们恶待你，求你饶恕他们的过犯和罪恶。现在求你饶恕你父亲　神之仆人的过犯。’”约瑟听见这话就哭了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","他的哥哥们也亲自来了，俯伏在他面前，说：“看哪，我们是你的奴仆。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","约瑟对他们说：“你们不要害怕，我怎能代替　神呢？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","从前你们有意要害我，但　神有美好的意思在其中，为要成就今日的光景，使许多人的性命得以保全。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","现在你们不要害怕，我必供养你们和你们的孩子。”于是约瑟用仁慈的话安慰他们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","约瑟和他父亲的家人，都住在埃及。约瑟活了一百一十岁。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","约瑟见到以法莲的第三代子孙；玛拿西的儿子玛吉的众子，也归在约瑟的膝下。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","约瑟对他的兄弟们说：“我快要死了，但　神必定眷顾你们，领你们从这地上到他起誓应许给亚伯拉罕、以撒、雅各之地去。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","约瑟又叫以色列的子孙起誓，说：“　神必定眷顾你们，那时你们要把我的骸骨从这里带上去应许之地。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","约瑟死了，享寿一百一十岁。人用香料把他包殓了，放在棺材里，停在埃及。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","以色列的众子，各人带着家眷和雅各一同来到埃及。他们的名字是： ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","流本、西缅、利未、犹大、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","以萨迦、西布伦、便雅悯、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","但、拿弗他利、迦得、亚设。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","他们全是雅各所生的，共有七十人；那时约瑟已经在埃及了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","后来，约瑟和他所有的兄弟，以及那一代的人都死了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","以色列人生养繁殖众多，人数增加，极其强盛，遍满了那地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","那时，有一位不认识约瑟的新王兴起来，统治埃及。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","他对自己的人民说：“看哪，以色列民比我们众多强盛。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","来吧，我们要用巧计对付他们，恐怕他们增多起来，一旦发生战争，他们就与我们的仇敌联合，攻击我们，并且离开这地。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","于是，他们指派督工管辖他们，加重他们的重担苦害他们，他们为法老建造两座贮货城，就是比东和兰塞。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","但是，埃及人越苦害他们，他们就越发增多，越发繁殖。埃及人就惧怕以色列人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","于是，埃及人严严地使以色列人作苦工。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","埃及人使他们因作苦工而觉得命苦，他们要和泥、做砖、作田间各样的工；这一切苦工，埃及人都严严地驱使以色列人去作。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","埃及王吩咐两个希伯来接生妇，一个名叫施弗拉，一个名叫普阿， ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","说：“你们给希伯来妇人接生的时候，要看着她们临盆；若是男孩，你们要杀死他；若是女孩，她就可以活着。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","但是，接生妇却敬畏　神，不照着埃及王吩咐她们的去作，竟让男孩活着。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","于是，埃及王把接生妇叫了来，对她们说：“你们为什么作这事，让男孩活着呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","接生妇回答法老：“希伯来妇人与埃及妇人不同；她们很有活力，接生妇还没有来到，她们已经生产了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","神恩待接生妇；以色列民增多起来，而且非常强盛。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","接生妇因为敬畏　神，　神就为她们建立家室。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","法老吩咐他的众民说：“凡是希伯来人所生的男孩，你们都要把他投在河里；凡是女孩，就让她活着。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","有一个利未家的人去娶了一个利未女子为妻。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","那女人怀孕，生了一个儿子；见他俊美，就把他藏了三个月。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","直到她不能把他再藏了，就拿一个蒲草箱来，涂上沥青和石漆；把孩子放在里面，把箱子放在河边的芦苇丛中。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","孩子的姊姊远远地站着，要知道孩子究竟怎样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","那时，法老的女儿下到河边去洗澡；她的使女们在河边行走；她看见了在芦苇中的箱子，就打发自己的使女去把箱子拿过来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","她打开了，就看见那孩子；看哪，孩子哭了，她就怜悯他，说：“这是希伯来人的一个孩子。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","孩子的姊姊对法老的女儿说：“我去从希伯来妇人中给你请一个奶妈来，为你乳养这个孩子可以吗？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","法老的女儿回答：“你去吧。”童女就去把孩子的母亲请了来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","法老的女儿对她说：“你把这孩子抱去，替我乳养他，我必给你工钱。”妇人就抱了孩子去乳养他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","孩子长大了，妇人把他带到法老的女儿那里，他就作了法老女儿的儿子。她给孩子起名叫摩西，说：“因为我把他从水里拉出来。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","过了些日子，摩西长大了，有一次，他出去到他的同胞那里去，看见他们的重担，又看见一个埃及人打他的一个同胞希伯来人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","摩西左右观望，见没有人，就把那埃及人击杀了，埋藏在沙土里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","第二天他又出去，看见两个希伯来人彼此争斗着，就对那欺负人的说：“你为什么打你同族的人呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","那人回答：“谁立了你作我们的领袖和审判官呢？难道你想杀我，好像杀那个埃及人一样吗？”摩西就惧怕起来，心里想：“这事必定给人知道了！” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","法老听见这事，就设法要杀摩西；摩西躲避法老，就往米甸地去居住；有一天他坐在井旁。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","米甸的祭司有七个女儿，她们来打水，打满了水槽，要给父亲的羊群喝。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","有些牧人来了，把她们赶走；摩西却起来，救了她们，也给她们的羊群喝水。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","她们回到父亲流珥那里，父亲问：“今天你们为什么赶着回来呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","她们说：“有一个埃及人救我们脱离了牧羊人的手，而且还为我们打水给羊群喝。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","父亲对众女儿说：“他在哪里？你们为什么撇下那人呢？去请他来吃饭。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","摩西乐意和那人同住；那人把自己的女儿西坡拉给了摩西作妻子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","西坡拉生了一个儿子，摩西给他起名叫革舜，因为他说：“我在异地作了客旅。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","过了很久，埃及王死了。以色列人在捆锁中叹息，他们就呼求，在捆锁中的呼求达到　神那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","神听见他们的呼声，就记念他与亚伯拉罕、以撒、雅各所立的约。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","神看顾以色列人，也关注他们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","那时，摩西正在牧放他岳父米甸祭司叶忒罗的羊群。有一次，他把羊群领到旷野的尽头去，到了　神的山，就是何烈山。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","耶和华的使者从荆棘丛里的火焰中向摩西显现。摩西观看，看见荆棘被火烧着，却没有烧毁。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","摩西说：“我要到那边去，看看这大异象，这荆棘为什么烧不掉？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","耶和华见摩西要到那边去观看，　神就从荆棘丛里呼叫他，说：“摩西，摩西。”摩西说：“我在这里。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","耶和华说：“不可过到这里来；要把你脚上的鞋脱掉，因为你所站的地方是圣地。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","又说：“我是你父亲的　神、亚伯拉罕的　神、以撒的　神、雅各的　神。”摩西因为怕见　神，就把自己的脸蒙住了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","耶和华说：“我的子民在埃及所受的痛苦，我实在看见了；他们因受督工的辖制所发的呼声，我也听见了；他们的痛苦，我是知道的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","所以我下来，要救他们脱离埃及人的手，领他们脱离那地，到美好宽阔之地，到流奶与蜜之地，就是到迦南人、赫人、亚摩利人、比利洗人、希未人和耶布斯人的地方。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","现在以色列人的呼声已经达到我的面前，我也看见了埃及人对他们所施的压迫。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","所以现在你来，我要派你到法老那里去，使你可以把我的人民以色列人从埃及领出来。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","摩西对　神说：“我是谁，竟能到法老那里去，把以色列人从埃及领出来呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","神回答：“我必与你同在；你把人民从埃及领出来的时候，你们要在这山上事奉　神；这就是我派你去的凭据。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","摩西对　神说：“我到以色列人那里，对他们说：‘你们祖宗的　神差遣我到你们这里来’，他们必问我：‘他叫什么名字？’我要对他们说什么呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","神回答摩西：“我是‘自有永有者’。”又说：“你要对以色列人这样说：‘那自有者派我到你们这里来。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","神又对摩西说：“你要对以色列人这样说：‘耶和华你们祖宗的　神，就是亚伯拉罕的　神、以撒的　神、雅各的　神，差遣我到你们这里来；这就是我永久的名字，也是世世代代中我被记念的名字。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","你去召集以色列的长老，对他们说：‘耶和华你们祖宗的　神，就是亚伯拉罕的　神、以撒的　神、雅各的　神，向我显现，说：“我实在眷顾了你们，和鉴察了你们在埃及所遭遇的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","我也曾说：“我要把你们从埃及的痛苦中领出来，到迦南人、赫人、亚摩利人、比利洗人、希未人、耶布斯人之地去，就是到流奶与蜜之地去。”’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","他们必听你的话；你和以色列的长老要到埃及王那里去，对他说：‘耶和华希伯来人的　神遇见了我们。现在求你让我们走三天的路程到旷野去，好献祭给耶和华我们的　神。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","我也知道，如果不施行大能的手，埃及王决不会让你们走的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","因此，我要伸手，用我在埃及快要施行的一切异能，击打埃及；然后他才会让你们离去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","我必叫这民在埃及人的眼前蒙恩。因此你们离去的时候，就不至于空手而去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","但每个妇女要向她邻居的妇女，和寄居在她家中的妇女索取银器、金器和衣服，要给你们的儿女穿戴；这样，你们就把埃及人的财物掠夺了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","摩西回答：“看哪，他们必不信我，也不听我的话；因为他们必说：‘耶和华并没有向你显现。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","耶和华问摩西：“那在你手里的是什么？”他说：“是手杖。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","耶和华说：“把它丢在地上。”摩西把它一丢在地上，它就变了蛇；摩西就逃跑，离开了它。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","耶和华对摩西说：“伸出你的手来，捉住蛇的尾巴。”摩西就伸出手来，紧握着它，它在摩西的掌中又变回了手杖。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","“这样就使他们相信耶和华他们祖宗的　神，就是亚伯拉罕的　神、以撒的　神、雅各的　神曾向你显现了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","耶和华又再对摩西说：“现在把你的手放进怀里。”摩西就把手放进怀里；等他把手抽出来的时候，手就长满了痲风，像雪那样白。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","耶和华说：“把你的手再放进怀里。”摩西就把手再放进怀里；等他把手从怀里抽出来的时候，手就恢复过来，像身上别处的肉一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","耶和华又说：“如果他们不信你，也不听从头一个神迹的话，他们必信随后来的神迹。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","如果连这两个神迹他们也不信，也不听你的话，你就从河里取些水，倒在旱地上；你从河里取来的水就必在旱地上变成血。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","摩西对耶和华说：“主啊，我不是个会说话的人；以前不是，自从你对仆人说话以后也不是；因为我本是拙口笨舌的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","耶和华对他说：“谁造人的口呢？谁使人口哑、耳聋、眼明、眼瞎呢？不是我耶和华吗？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","现在去吧，我必赐你口才，指教你当说的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","摩西说：“主啊，请你差派你愿意差派的人。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","耶和华向摩西发怒，说：“不是有你的哥哥利未人亚伦吗？我知道他是有口才的；他现在出来要迎接你。他看见了你，心里就快乐。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","你要对他说话，把你要说的话放在他的口里；我必与你的口同在，也与他的口同在；我必指教你们当行的事。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","他要替你向人民说话，他要作你的口，你要作他的　神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","这手杖你要拿在手里，用来行神迹。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","于是，摩西起程回到他岳父叶忒罗那里，对他说：“请你容我离开这里，回到我在埃及的同胞那里，看看他们是否还在。”叶忒罗对摩西说：“你可以平平安安地去吧。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","耶和华在米甸对摩西说：“你要起程，回到埃及去，因为那些寻索你命的人都死了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","摩西就带着他的妻子和孩子，让他们骑在驴上，向着埃及地回去了；摩西手里拿着　神的杖。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","耶和华对摩西说：“你起程回到埃及去的时候，要留意我交在你手里的一切奇事，把它们行在法老面前；我却要使他的心刚硬，他就不让人民离开。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","你要对法老说：‘耶和华这样说：以色列是我的长子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","我曾对你说，要让我的儿子离开这里，好叫他事奉我。你还是拒绝让他离开，看哪！我必杀你的长子。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","在路上住宿的地方，耶和华遇见了摩西，就想要杀他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","西坡拉就拿了一把石刀，把她儿子的包皮割下来，把它丢到摩西的脚上，说：“你真是我的血郎了！” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","这样，耶和华才放了他。那时西坡拉说：“你是血郎，是因为割礼的缘故。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","耶和华对亚伦说：“你到旷野去迎接摩西。”他就去了；他在　神的山遇见了摩西，就和他亲嘴。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","摩西把耶和华派他所说的一切话，和吩咐他所行的一切神迹都告诉了亚伦。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","摩西和亚伦就去召集以色列人的长老。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","亚伦把耶和华对摩西所说的一切话都说了一遍，并且在人民的眼前行了这些神迹。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","人民就相信了；他们听见耶和华眷顾以色列人，也鉴察了他们的痛苦，就俯伏敬拜。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","后来，摩西和亚伦去对法老说：“耶和华以色列的　神这样说：让我的人民离开这里，叫他们可以在旷野向我守节。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","法老回答：“耶和华是谁，我要听他的话，让以色列人离开呢？我不认识耶和华，也不让以色列人离开。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","他们说：“希伯来人的　神遇见了我们；求你让我们走三天的路程到旷野去，献祭给耶和华我们的　神，免得他用瘟疫或刀剑击杀我们。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","埃及王对他们说：“摩西、亚伦哪，你们为什么使人民懒惰不作工呢？去挑你们的担子吧。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","法老又说：“你看，现在这地的民很多，你们竟叫他们歇下担子？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","就在那天，法老吩咐众民的督工和首领说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“你们不要像往日一样再把草给人民做砖，叫他们自己去捡草。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","他们往日做砖的数量，你们还是向他们要，一点也不可减少，因为他们是懒惰的，所以他们才呼喊说：‘让我们去献祭给我们的　神。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","你们要把更重的工作加在这些人的身上，好使他们专心作工，不听谎言。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","众民的督工和首领出来，告诉人民说：“法老这样说：‘我不再给你们草。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","你们自己能在哪里找到草，就到哪里去捡吧，但你们的工作一点也不可减少。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","于是，人民就分散到埃及全地，去拾禾秸作草。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","督工们催着说：“你们的工作，每天的本分，要在当天完成，像以前有草的时候一样。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","法老的督工责打他们派定的以色列人的首领，说：“你们昨天今天为什么没有做完指定要你们做的砖，像往日一样呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","以色列人的首领就来，向法老呼求说：“你为什么这样待你的仆人呢？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","没有草给你的仆人，但他们对我们说：‘你们做砖吧！’看哪，你的仆人受了责打，其实这是你自己人民的错。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","法老说：“你们确实是懒惰的，所以你们才说：‘让我们去献祭给耶和华。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","现在你们去作工吧；草是不给你们的，砖却要如数交上。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","以色列人的首领因有命令说：“你们每天本分要做的砖数不可减少”，就知道自己有祸了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","他们从法老那里出来的时候，遇见摩西和亚伦，正在站着等候他们， ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","就对他们说：“愿耶和华鉴察你们，审判你们，因为你们使我们的香气在法老眼前和他的臣仆眼前都发臭了，把刀放在他们的手里来杀我们。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","摩西回到耶和华那里，说：“主啊！你为什么苦待这人民呢？为什么差派我呢？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","自从我到法老那里，奉你的名说话以来，他就苦待这人民，你一点也没有拯救你自己的人民。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","耶和华对摩西说：“你现在必看见我要向法老行的事；因为我施展大能的手，他必让他们离去；我施展大能的手，他必把他们从自己的地赶出去。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","神告诉摩西说：“我是耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","我曾向亚伯拉罕、以撒、雅各显现为全能的　神，至于我的名字‘耶和华’，他们是不认识的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","我不但与他们确立了我的约，要把迦南地，就是他们作客寄居之地赐给他们； ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","而且我也听见了以色列人因埃及人所加的奴役而发的哀声，就记念我的约。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","所以，你要对以色列人说：‘我是耶和华，我要把你们从埃及人的重担底下救出来；我要拯救你们脱离他们的奴役；我要用伸出来的膀臂，并借着严厉的刑罚来救赎你们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","我要以你们作我的人民，我也要作你们的　神；你们要知道我是耶和华你们的　神，是把你们从埃及人的重担底下救出来的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","我举手起誓要给亚伯拉罕、以撒、雅各的地，我必领你们进去；我也必把那地赐给你们作产业；我是耶和华。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","摩西这样告诉以色列人，只是他们因为心里愁烦和苦工的缘故，就不肯听摩西的话。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","耶和华告诉摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“你要告诉埃及王法老，叫他让以色列人离开他的地。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","摩西在耶和华面前说：“看哪，以色列人尚且不肯听我的话，法老又怎会听我的话呢？因为我是个拙口笨舌的人。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","耶和华吩咐摩西和亚伦，命令他们到以色列人和埃及王法老那里去，把以色列人从埃及地领出来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","他们各家族首领的名字记在下面：以色列的长子流本的儿子是哈诺、法路、希斯伦、迦米；这些是流本的各家族。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","西缅的儿子是耶母利、雅悯、阿辖、雅斤、琐辖和迦南女子的儿子扫罗；这些是西缅的各家族。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","利未众子的名字按着他们的世代记在下面，就是革顺、哥辖、米拉利。利未一生的岁数是一百三十七岁。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","革顺的儿子，按着他们的家族，是立尼、示每。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","哥辖的儿子是暗兰、以斯哈、希伯伦、乌薛。哥辖一生的岁数是一百三十三岁。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","米拉利的儿子是抹利和母示。按着他们的世代，这些是利未的家族。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","暗兰娶了自己的姑母约基别为妻；约基别给他生了亚伦和摩西；暗兰一生的岁数是一百三十七岁。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","以斯哈的儿子是可拉、尼斐、细基利。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","乌薛的儿子是米沙利、以利撒反、西提利。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","亚伦娶了亚米拿达的女儿拿顺的妹妹以利沙巴作妻子；她给亚伦生了拿答、亚比户、以利亚撒、以他玛。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","可拉的儿子是亚惜、以利加拿、亚比亚撒；这些是可拉的各家族。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","亚伦的儿子以利亚撒娶了普铁的一个女儿为妻；她给以利亚撒生了非尼哈。按照他们的家族，这些就是利未人的各首领。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","这亚伦和摩西，耶和华曾经对他们说过：“你们要按着他们的军队，把以色列人从埃及地领出来。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","那对埃及王法老说要把以色列人从埃及领出来的，就是这摩西和亚伦。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","耶和华在埃及地对摩西说话的日子， ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","耶和华告诉摩西说：“我是耶和华，你要把我对你所说的一切话都告诉埃及王法老。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","摩西在耶和华面前说：“你看，我是个拙口笨舌的人，法老怎肯听我呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","耶和华对摩西说：“看哪，我使你在法老面前好像　神一样；你哥哥亚伦要作你的先知。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","我吩咐你的一切，你都要说；你哥哥亚伦要告诉法老，法老就让以色列人离开他的地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","我要使法老心硬，我也要在埃及地加增我的神迹奇事。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","可是法老不听你们的话，我必下手击打埃及；借着严厉的刑罚把我的军队，我的人民以色列人，从埃及地领出来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","我向埃及伸手，把以色列人从他们中间领出来的时候，埃及人就必知道我是耶和华。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","摩西和亚伦这样行了；耶和华怎样吩咐摩西和亚伦，他们就照样行了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","摩西和亚伦与法老说话的时候，摩西八十岁，亚伦八十三岁。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","耶和华告诉摩西和亚伦说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“如果法老告诉你们说：‘你们行件奇事吧’，你就要对亚伦说：‘拿你的手杖来，把它丢在法老面前，它就会变作蛇。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","摩西和亚伦就进到法老那里，照着耶和华吩咐他们的行了；亚伦把手杖丢在法老和法老的臣仆面前，手杖就变了蛇。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","于是，法老也把智慧人和行法术的人召了来；他们本是埃及的术士，也用他们的巫术照样行了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","他们各人都丢下自己的手杖，手杖就变了蛇；亚伦的手杖却吞了他们的手杖。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","法老心里刚硬，不肯听他们的话，就像耶和华所说的一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","耶和华对摩西说：“法老心里固执，拒绝让人民离去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","明天早晨你要到法老那里去。看哪，法老出来到水边去的时候，你要站在河边迎见他；那变过蛇的手杖，你要拿在手里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","你要对法老说：‘耶和华希伯来人的　神差我到你这里来，说：“让我的人民离开这里，好使他们可以在旷野事奉我”，你看，直到现在你还是不听。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","耶和华这样说：“看哪，我要用我手里的杖击打河中的水，水就必变成血；因此你就知道我是耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","河中的鱼必死亡，河水也必发臭，埃及人就必厌恶喝这河里的水。”’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","耶和华对摩西说：“你要对亚伦说：‘拿你的手杖来，把你的手伸在埃及的众水之上，就是在他们的江、河、池和所有水塘之上，使水都变成血。因此，在埃及全地，连木器石器中都必有血。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","摩西和亚伦就这样行了，就像耶和华所吩咐的；亚伦在法老面前和法老的臣仆面前举起手杖，击打河里的水，河里的水就都变了血。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","河里的鱼死了，河水发臭了，埃及人也不能喝这河里的水了；在埃及，全地都有血。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","埃及的术士也用他们的巫术这样行了；可是法老却心里刚硬，不肯听摩西和亚伦，就像耶和华所说的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","法老转身回到宫里去，也不把这事放在心上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","所有的埃及人都在河的周围掘地，要得水喝，因为他们不能喝这河里的水。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","耶和华击打尼罗河以后，满了七天。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","耶和华对摩西说：“你到法老那里去，对他说：‘耶和华这样说：“让我的人民离开这里，使他们可以事奉我。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","如果你拒绝让他们离开这里，看哪，我必用青蛙击打你的全境。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","河里必滋生青蛙；青蛙必上来，进到你的宫殿和卧房里去，跳上你的床，进你臣仆的房屋，跳上你人民的身上，进你的炉子和抟面盆。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","青蛙也必跳上你、你的人民和臣仆的身上。”’”（本章第1-4节在《马索拉抄本》为 7:26-29） ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","耶和华对摩西说：“你要对亚伦说把手中的杖伸在江、河、池之上，使青蛙上到埃及地来。”（本节在《马索拉抄本》为 8:1） ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","亚伦把手一伸在埃及的众水之上，青蛙就上来了，并且遮盖了埃及地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","众术士也用他们的巫术照样行了，使青蛙上了埃及地来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","法老把摩西和亚伦召了来，说：“请你们恳求耶和华，好叫他使青蛙离开我和我的人民，我就必让这人民离开这里，使他们可以向耶和华献祭。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","摩西回答法老：“请指示，我要在什么时候为你和你的臣仆，以及你的人民，恳求耶和华除灭青蛙，使青蛙离开你和你的宫殿，只留在河里呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","法老说：“明天。”摩西回答：“就照着你的话行吧，好叫你知道没有神像耶和华我们的　神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","青蛙必离开你和你的宫殿、你的臣仆和你的人民，只留在河里。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","于是，摩西和亚伦离开法老走了出来；摩西为了耶和华加在法老身上青蛙的灾害向耶和华呼求。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","耶和华就照着摩西的话行了；在房屋里、院子里和田野中的青蛙都死了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","有人把青蛙一堆一堆积聚起来，那地就发臭了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","法老一见灾祸平息了，就心里刚硬，不肯听他们的话，就像耶和华所说的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","耶和华对摩西说：“你要对亚伦说：‘伸出你的手杖，击打地上的尘土，使尘土在埃及全地都变成虱子。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","他们就这样行了；亚伦伸出手中的杖，击打地上的尘土，就在人身上和牲畜身上有了虱子；埃及全地所有地上的尘土都变成了虱子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","众术士也用他们的巫术照样行，要生出虱子来，却不能办到；所以在人身上和牲畜身上都有虱子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","众术士就对法老说：“这是　神的手指头。”法老却心里刚硬，不肯听摩西和亚伦，就像耶和华所说的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","耶和华对摩西说：“你要清早起来，站在法老面前；看哪，法老到水边来的时候，你要对他说：‘耶和华这样说：你要让我的人民离开这里，使他们可以事奉我。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","如果你不让我的人民离开这里，看哪，我必叫苍蝇落在你和你臣仆，以及人民的身上，进到你的宫殿；埃及人的房屋都必充满苍蝇，他们所在的地方也是这样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","那日，我必把我人民居住的地方歌珊分别出来，使那里没有苍蝇，为要使你知道在全地上只有我是耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","我必把我的人民和你的人民分别出来，明天必有这神迹。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","耶和华就这样行了；无数的苍蝇进了法老的宫殿和他臣仆的房屋，并且遍布埃及全地；那地就因为苍蝇的缘故毁坏了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","法老把摩西和亚伦召了来，对他们说：“你们去，在这地献祭给你们的　神吧。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","摩西回答：“决不可以这样行，因为我们要把埃及人看为可憎的祭物献给耶和华我们的　神；如果我们把埃及人看为可憎的祭物在他们眼前献上，难道他们不拿石头打死我们吗？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","我们要走三天的路程进到旷野，好照着耶和华吩咐我们的，向耶和华我们的　神献祭。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","法老回答：“我必让你们离开这里，你们可以在旷野献祭给耶和华你们的　神，只是你们不可走得太远；请你们为我祈祷。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","摩西说：“看哪，我要离开你出去，祈求耶和华，使苍蝇明天可以离开法老和法老的臣仆，以及法老的人民，只是不可再行欺骗，不让以色列人离开这里去献祭给耶和华。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","于是，摩西从法老那里出来，去祈求耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","耶和华就照着摩西的话行了，使苍蝇离开了法老和他的臣仆，以及他的人民，连一只也没有留下。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","可是，这一次法老还是心里刚硬，不肯让以色列人离开。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","耶和华对摩西说：“你要到法老那里去，对他说：‘耶和华希伯来人的　神这样说：“让我的人民离开这里，使他们可以事奉我。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","如果你拒绝他们离开这里，仍然强留他们， ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","看哪，耶和华的手必用严重的瘟疫加在你田间的牲畜身上，加在马、驴、骆驼、牛群、羊群身上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","耶和华必把以色列的牲畜和埃及人的牲畜分别出来；所有属于以色列人的，一只也不死去。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","耶和华就定了时候，说：“明天耶和华必在此地行这事。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","第二天，耶和华就行了这事，埃及人全部的牲畜都死了；可是属于以色列人的牲畜，一只也没有死去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","法老派人去看，果然看见属于以色列人的牲畜，连一只也没有死去。法老的心还是刚硬，不肯让以色列人离开。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","耶和华对摩西和亚伦说：“你们要两手拿满炉灰，摩西要在法老眼前把炉灰向天上扬起来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","这炉灰必在埃及全地变为微尘，在埃及全地的人和牲畜身上就必生出疹病和脓疮。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","摩西和亚伦取了炉灰，站在法老面前；摩西把炉灰向天上扬起来，人和牲畜身上就生出了疹病和脓疮。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","众术士因为生了疮的缘故，不能站在摩西的面前；因为众术士和所有埃及人身上都生了疮。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","耶和华使法老心里刚硬，他就不肯听摩西和亚伦的话，就像耶和华对摩西所说的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","耶和华对摩西说：“你要清早起来，站在法老面前，对他说：‘耶和华希伯来人的　神这样说：“让我的人民离开这里，使他们可以事奉我。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","因为这一次我要降下我的一切灾祸，打击你和你的臣仆及人民，为要使你知道在全地上没有神像我的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","如果我现在伸手用瘟疫击打你和你的人民，你就早已从地上消灭了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","然而我使你存留，是为了使你看见我的能力，并且在全地上传讲我的名。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","你仍然向我的人民自高，不让他们离开吗？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","看哪，明天大约这个时候，我必降下极重的冰雹，在埃及自建国以来，直到现在，未曾有过这样的冰雹的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","所以，你现在要派人去，把你的牲畜和田间所有属于你的，都收聚到安全的地方；因为凡在田间发现的人和牲畜而不收回家里去的，冰雹必落在他们身上，他们就必死亡。”’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","法老的臣仆中有惧怕耶和华这话的，就叫他的仆人和牲畜进屋里来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","但那不把耶和华这话放在心上的，却把他的仆人和牲畜留在田里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","耶和华对摩西说：“你要向天伸杖，使埃及全地都有冰雹，落在人身上、在牲畜身上和埃及地田间所有的蔬菜上。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","摩西把手杖向天一伸，耶和华就打雷（“打雷”原文作“　神的声音”）下雹，有火落在地上；耶和华使冰雹降在埃及地上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","那时有了冰雹，冰雹与火混杂在一起，十分严重；埃及全地自从建国以来，未曾有过这样的冰雹。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","在埃及全地，冰雹把田间的一切，连人和牲畜都击打了；冰雹又把田间的一切蔬菜击打了，也把田间的一切树木打断了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","只有在以色列人所在的歌珊地，没有冰雹。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","于是，法老把摩西和亚伦召了来，对他们说：“这一次我犯了罪了；耶和华是公义的，我和我的人民是有罪的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","请你们祈求耶和华吧，因为这雷声和冰雹已经够了；我决意让你们离开，你们不可再留在这里。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","摩西回答法老：“我一出城，就必向耶和华伸手祷告，雷声就必止住，也不再有冰雹了，好使你知道大地是属于耶和华的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","至于你和你的臣仆，我知道你们在耶和华　神的面前还是没有惧怕的心。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","那时，麻和大麦被冰雹击打了，因为大麦已经吐穗，麻也开了花。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","只是小麦和粗麦却没有被击打，因为它们还没有长成。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","摩西离开法老出城去了，就向耶和华伸手祷告，雷声和冰雹就止住了，雨也不再倾倒在地上了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","法老看见雨水、冰雹和雷声都止住了，就更加犯罪，他和他的臣仆都心里刚硬。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","法老的心刚硬，不肯让以色列人离开，就像耶和华借着摩西所说的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","耶和华对摩西说：“你要到法老那里去，因为我已经使他的心和他臣仆的心刚硬，为要在他们中间显出我这些神迹； ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","并且要你把愚弄埃及人的事，和我在他们中间显出的神迹，都讲给你的子孙听；使你们知道我是耶和华。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","摩西和亚伦就到法老那里去，对他说：“耶和华希伯来人的　神这样说：‘你拒绝在我面前谦卑要到几时呢？让我的人民离开吧，使他们可以事奉我。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","如果你拒绝让我的人民离开，看哪！明天我要使蝗虫进入你的境界； ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","蝗虫必遮盖地面，甚至人不能看见地；蝗虫必吃尽那避过灾难余剩的，那没有受冰雹击打，剩下留给你们的；它们也必吃尽田间给你们生长起来的一切树木。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","蝗虫必充满了你的宫殿，你所有臣仆的房屋，和所有埃及人的房屋；这是你祖宗和你祖宗的祖宗自从在世以来，直到今日，所没有见过的。’”摩西就转身，离开法老出去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","法老的臣仆对法老说：“这人成为我们的网罗要到几时呢？让这些人离开吧，使他们可以事奉耶和华他们的　神；埃及已经毁灭了，你还不知道吗？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","于是，摩西和亚伦被召回来到法老那里。法老对他们说：“你们去事奉耶和华你们的　神吧，但那些要去的是谁呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","摩西回答：“我们要和我们年少的与年老的同去，要和我们的儿女同去，也要和我们的羊群与牛群同去，因为我们必须向耶和华守节。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","法老对他们说：“我让你们和你们的孩子离开的时候，愿耶和华与你们同在；你们要谨慎，因为有祸患在你们面前。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","不可以这样，只有你们的男子可以去事奉耶和华，因为这原是你们要求的。”于是把他们从法老面前赶出去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","耶和华对摩西说：“你要向埃及地伸手，使蝗虫上埃及地来，吃尽地上所有的蔬菜，就是受冰雹击打后留下的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","摩西就向埃及地伸杖，整整的一日一夜，耶和华把东风吹在地上；到了早晨，东风把蝗虫吹来了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","蝗虫上到埃及全地来，停留在埃及全境。它们非常众多，以前没有像这样多的蝗虫，以后也没有。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","蝗虫遮盖了整个地面，以致大地都变黑了。它们吃尽了地上一切蔬菜，和树上所有的果子，就是受冰雹击打后留下来的。这样，在埃及全地，无论是树木，或田间的蔬菜，连一点青的也没有留下。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","于是，法老急忙把摩西和亚伦召了来，说：“我得罪了耶和华你们的　神，也得罪了你们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","现在求你只这一次赦免我的罪，也请你们求告耶和华你们的　神，使这一次的死亡离开我。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","摩西就离开法老出来，祈求耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","耶和华转了非常强大的西风，把蝗虫吹起来了，投进红海里；在埃及全境，连一只蝗虫也没留下。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","但是耶和华使法老的心刚硬，以致法老不肯让以色列人离开。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","耶和华对摩西说：“你要向天举手，使黑暗临到埃及地，这黑暗是可以触摸的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","摩西向天伸手，幽暗就临到埃及全地三天之久。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","三天之内，人彼此不能看见，谁也不能起来离开自己的地方；但是在所有以色列人居住的地方都有亮光。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","法老就把摩西召了来，说：“你们去事奉耶和华吧，你们的孩子也可以与你们同去；只是要把你们的羊群和牛群留下来。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","摩西回答：“你也要把献祭用的祭物和燔祭交给我们，使我们可以献给耶和华我们的　神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","我们的牲畜也要与我们同去，连一只也不留下；因为我们要从它们当中取出一些来事奉耶和华我们的　神；我们没有到达之前，还不知道要用什么事奉耶和华。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","但耶和华使法老心里刚硬，因此他不愿意让他们离开。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","法老对摩西说：“你离开我去吧，你要小心，不要再见我的面；因为你再见我面的时候，你必定死。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","摩西回答：“你说对了，我不再见你的面了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","耶和华对摩西说：“我再使一种灾祸临到法老和埃及，然后法老他必让你们离开这里。他让你们离开的时候，必全部赶逐你们离开这地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","现在你要告诉人民，叫他们男女各人向自己的邻舍索取银器金器。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","耶和华使人民在埃及人眼前蒙恩，同时摩西在埃及地，在法老臣仆的眼前和人民的眼前都成了伟大的人物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","摩西说：“耶和华这样说：‘大约半夜的时候，我要出去巡行埃及地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","在埃及地所有头生的都必死亡，就是从坐王位的法老的长子，直到推磨的婢女的长子，以及一切头生的牲畜都必死亡。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","在埃及全地必有大哀号；这样的哀号从前未曾有过，以后也必再没有。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","但是对于所有的以色列人，无论是人或是牲畜，连狗也不敢向他们叫吠；为要使你们知道耶和华是把埃及人和以色列人分别出来的’。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","你所有的臣仆都必下到我这里来，向我下跪说：‘你和所有跟从你的人民都出去吧’，然后我才出去。”于是摩西气忿忿地离开法老出去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","耶和华对摩西说：“法老必不听你们的话，好使我的神迹在埃及地加增起来。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","摩西和亚伦在法老面前行了这一切神迹；但耶和华使法老的心刚硬，所以他不肯让以色列人离开他的地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","耶和华在埃及地告诉摩西和亚伦说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“你们要以本月为正月，为一年的第一个月。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","你们要告诉以色列全体会众说：本月初十，他们各人要按着父家取羊羔，一家一只。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","如果一家的人太少，吃不了一只羊羔，家长就要和靠近他家的邻居按着人数共取一只。你们预备羊羔的时候，要按着各人的食量计算。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","你们的羊羔要毫无残疾，一岁以内的公羊；你们可以从绵羊或山羊里取。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","你们要把羊羔留到本月十四日，在黄昏的时候，以色列全体会众要把羊羔宰杀。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","他们要取点血，涂在吃羊羔的房屋两边的门柱和门楣上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","当那一夜，你们要吃羊羔的肉，肉要用火烤了，和无酵饼与苦菜一同吃， ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","不可吃生的，也不可用水煮；只可吃用火烤的。头、腿和内脏都一起吃。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","你们一点也不可留到早晨；如果有一点留到早晨，就要用火烧掉。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","你们要这样吃羊羔：腰间束上带，脚上穿着鞋，手中拿着杖，快速地吃；这是耶和华的逾越节。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","因为在那一夜我要走遍埃及地，把埃及地所有头生的，无论是人或是牲畜，都要杀掉；我也要审判埃及的一切神祇，我是耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","这血要在你们居住的房屋上作你们的记号；我击打埃及地的时候，一看见这血，就越过你们去，灾祸必不临到你们身上毁灭你们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","这一日必作你们的记念日；你们要守这日为耶和华的节；你们要世世代代守这节日作永远的定例。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","“你们要吃无酵饼七天；可是第一天就要把酵从你们的家中除去；因为从第一日起直到第七日，凡吃有酵之物的，那人必从以色列中被除灭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","第一日你们要有圣会，第七日你们也要有圣会；这两日之内，除了预备各人所要吃的以外，一切工作都不可作。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","你们要守无酵节，因为就在这一天，我把你们的军队从埃及地领出来；所以你们要世世代代守这一日作为永远的定例。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","从正月十四日晚上起，直到本月二十一日晚上止，你们要吃无酵饼。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","七日之内在你们的家中不可有酵；因为凡吃有酵之物的，无论是外国人或是本地人，那人必从以色列的会众中被剪除。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","凡是有酵的，你们都不可吃；在你们一切居住的地方，你们都要吃无酵饼。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","于是，摩西把以色列的众长老召了来，对他们说：“你们要按着家族自己选取羊羔，把这逾越节的羊羔宰杀了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","要拿一把牛膝草，蘸在盆中的血里，然后把盆里的血涂在门楣上和两边的门柱上；你们谁也不可出自己的房门，直到早晨。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","因为耶和华要走遍各处击打埃及人；他一看见门楣和两边的门柱上有血，就越过那门，不让那毁灭者进入你们的房屋来击杀你们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","这教训你们必须遵守，作为你和你的子孙永远的定例。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","日后，你们进了耶和华应许赐给你们的那地的时候，就必须守这敬拜之礼。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","日后，如果你们的子孙问你们：‘你们这敬拜之礼有什么意思？’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","你们就要回答：‘这是献给耶和华逾越节的祭。耶和华击杀埃及人的时候，越过了在埃及的以色列人的房屋，救了我们的家。’”于是人民低头敬拜。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","以色列人就去行了；耶和华怎样吩咐摩西和亚伦，以色列人就照样行了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","到了半夜，耶和华把埃及地所有的长子，就是从坐王位的法老的长子，直到监牢里遭囚禁的人的长子，以及所有头生的牲畜，都击杀了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","在那一夜，法老本人和他所有的臣仆，以及全埃及的人都起来了；在埃及有极大的哀号，因为没有一家不死人的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","夜里，法老把摩西和亚伦召了来，说：“你们和以色列人都起来，离开我的人民出去，照着你们所说的，去事奉耶和华吧； ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","也照着你们所说的，连羊群牛群都带着走吧，并且要为我祝福。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","埃及人催促以色列人，要他们赶快离开此地，因为他们说：“我们都要死了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","以色列人就拿了没有发过酵的生面，用衣服把抟面盆绑好，扛在肩头上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","以色列人照着摩西的话行了，他们向埃及人索取银器金器和衣服。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","耶和华使以色列人在埃及人眼前蒙恩，埃及人就给了他们所要求的。这样，他们就夺去了埃及人的财物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","以色列人从兰塞起行到疏割去，除了小孩子以外，步行的男人约有六十万。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","又有混杂多族的一群人和他们一同上去；他们还带着羊群牛群和无数的牲畜同去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","他们把从埃及带出来的生面烘成了无酵的圆饼。这生面原是没有发过酵的，因为他们被驱逐离开埃及，所以不能停留，也没有为自己预备食粮。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","以色列人住在埃及的时间共有四百三十年之久。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","就在四百三十年届满的那一天，耶和华的全军都从埃及地出来了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","这是向耶和华守的一夜，因为耶和华把他们从埃及地领出来，所以这一夜是所有以色列人世世代代向耶和华守的一夜。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","耶和华对摩西和亚伦说：“逾越节的定例是这样，凡是外族人都不可以吃羊羔的肉。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","但是各人用银子买回来的奴仆，如果你给他行了割礼，他就可以吃了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","寄居和受雇的都不可以吃。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","必须在同一间房子里吃，你不可把一点肉从房子里带到外面；羊羔的骨头，一根也不可折断。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","以色列全体会众都要守这逾越节。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","如果有外族人寄居在你们中间，也愿向耶和华守逾越节，他所有的男子都要受割礼，然后他才可以前来守逾越节；他就必像本地人一样，但所有未受割礼的人都不可以吃这羊羔。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","本地人和寄居在你们中间的外族人，都同属一例。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","所有以色列人都奉行了；耶和华怎样吩咐摩西和亚伦，他们就怎样行了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","就在这一天，耶和华按着他们的军队，把以色列人从埃及地领出来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","耶和华告诉摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“在以色列人中，你要把所有头生的都分别为圣归我；无论是人或是牲畜，凡是头生的都是我的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","摩西对人民说：“你们要记念这一天，就是从埃及为奴之家出来的这一天，因为耶和华用大能的手把你们从这里领出来；所以有酵之物都不可以吃。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","你们是在亚笔月这一日出来的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","日后耶和华领你进到迦南人、赫人、亚摩利人、希未人、耶布斯人之地，就是他向你的列祖起誓要赐给你的那流奶与蜜之地，那时你要在这月守这敬拜之礼。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","你要吃无酵饼七日，第七日要向耶和华守节。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","七日之中你要吃无酵饼；在你四境之内，不可见有发过酵之物在你面前，也不可见有酵在你那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","在那日，你要告诉你的儿子说：‘这是因为耶和华在我从埃及出来的时候为我所行的事。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","这要在你的手上作记号，在你额上作记念，好使耶和华的律法常在你的口中，因为耶和华曾用大能的手把你从埃及领出来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","所以，你要年年按着定期遵守这定例。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“日后，耶和华照着他向你和你的列祖所起的誓，把你领进迦南人之地，把这地赐给你之后， ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","你要把所有头生的奉献给耶和华，也要把你一切牲畜中所有头生的小牲口奉献给耶和华；公的都属耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","凡是头生的驴，你要用羊羔代赎；如果你不代赎，就要打断它的颈项；凡是你儿子中头生的人，你都要代赎。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","日后你的儿子若是问你们：‘这是什么意思？’你就要回答他：‘耶和华曾经用大能的手把我们从埃及为奴之家领出来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","那时法老心里刚硬，不让我们离开，耶和华就把埃及地所有头生的，无论是人或是牲畜都杀了；所以，我把所有头生的公牲口都献给耶和华为祭；但我所有头生的儿子，却都要代赎回来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","这要在你的手上作记号，在你的额上作头带；因为耶和华曾用大能的手把我们从埃及领出来。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","法老让人民离开的时候，虽然非利士的路很近，　神却不领他们从那里走，因为　神说：“恐怕百姓看见战争而后悔，就回埃及去。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","所以　神领人民绕道而行，走旷野的路到红海去；以色列人从埃及地上来的时候，都带着兵器。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","摩西带了约瑟的骸骨同去，因为约瑟曾经叫以色列人严肃地起誓，说：“　神必定眷顾你们；你们要把我的骸骨从这里也一同带去。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","他们从疏割起程，在旷野边界的以倘安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","耶和华在他们前面行，日间用云柱领他们的路，夜间用火柱光照他们，使他们日夜都可以行走。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","日间云柱，夜间火柱，都不离开众民的面前。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","耶和华告诉摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“你要吩咐以色列人转回过来，在比．哈希录前，密夺和海之间安营；你们要在巴力．洗分前，对着巴力．洗分，靠近海边的地方安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","法老必论到以色列人的事，说：‘他们在这地走迷了路，旷野把他们困住了。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","我要使法老的心刚硬，他就必追赶他们；这样，我就可以在法老身上和他的全军身上得到荣耀，埃及人就必知道我是耶和华。”于是以色列人就这样行了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","有人告诉埃及王说：“以色列人逃走了。”法老和他的臣仆对以色列人的心就改变了，他们说：“我们让以色列人离开，不再服事我们，我们作了什么事呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","法老就预备他的马车，带着他的人民一同去， ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","并且带着六百辆特选的马车和埃及所有的马车，每辆马车上都有马车长。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","耶和华使埃及王法老的心刚硬，法老就追赶以色列人；因为以色列是靠着耶和华高举的手出来的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","埃及人追赶他们，法老所有的马匹、战车和他的马兵与军队，就在海边，靠近比．哈希录，对着巴力．洗分他们安营的地方追上了他们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","法老走近的时候，以色列人举目观看，看见埃及人正追赶过来，就非常惧怕，向耶和华呼求。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","他们对摩西说：“难道埃及没有坟墓，你要把我们带来死在旷野吗？你为什么这样待我们，把我们从埃及领出来呢？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","我们在埃及的时候，不是对你说过：‘不要管我们，我们要服事埃及人’这话吗？因为服事埃及人比死在旷野还好。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","摩西对人民说：“不要惧怕，要站着，观看耶和华今天为你们施行的拯救；因为你们今天看见的埃及人，必永远不再看见了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","耶和华必为你们争战，你们必须安静，不要作声。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","耶和华对摩西说：“你为什么向我呼求呢？吩咐以色列人往前走。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","你要把你的杖举起来，向海伸手，把海分开，叫以色列人下到海中走干地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","看哪，我要使埃及人的心刚硬，他们就必跟着以色列人下去；这样，我必在法老和他的全军身上，以及他的马车和马兵身上得到荣耀。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","我在法老身上，以及他的马车和马兵身上得到荣耀的时候，埃及人就知道我是耶和华。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","在以色列营前行走的　神的使者，转到他们后面去；云柱也从他们前面转过去，立在他们后面。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","云柱来到埃及营和以色列营中间；云柱一边是黑暗的，一边却光照着黑夜。这样整夜彼此都不能接近。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","摩西向海伸手，耶和华就用极强的东风，一夜之间使海水退去；他使海变成干地，海水也分开了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","以色列人下到海中走干地，水在他们的左右作了墙垣。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","埃及人追赶过来，法老所有的马匹、马车和马兵，都跟着以色列人下到海中去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","到了晨更的时候，耶和华透过云柱火柱向下观看埃及人的军兵，并且使埃及人的军兵大起混乱。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","又使他们的车轮脱落，行驶困难，因此埃及人说：“我们从以色列人面前逃跑吧，因为耶和华为他们争战，攻击埃及人了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","耶和华对摩西说：“你要向海伸手，使水回流到埃及人身上，流到他们的战车和马兵身上。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","摩西就向海伸手，到了天亮的时候，海水流回原处；埃及人逆流逃跑的时候，耶和华就把他们投在海中。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","海水一回流，就淹没了马车、马兵和那些跟着以色列人下海去的法老的全军，连一个也没有余下。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","以色列人却在海中走干地，水在他们的左右作了墙垣。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","这样，耶和华就在那一天把以色列人从埃及人的手里拯救了出来；以色列人看见埃及人都死在海边。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","以色列人看见耶和华向埃及人所显大能的手，就敬畏耶和华，又信服耶和华和他的仆人摩西。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","那时，摩西和以色列人向耶和华唱了以下这首歌，说：“我要向耶和华歌唱，因为他高高地被高举起来；他把马匹和骑马的投在海中。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","耶和华是我的力量，我的诗歌，也成了我的拯救；这是我的　神，我要赞美他；他是我父的　神，我要尊崇他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","耶和华是战士，他的名是耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","他把法老的马车和军兵都投在海里，法老特选的官长都沉在红海中。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","波涛淹没了他们，他们好像石头坠到深海。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","耶和华啊，你的右手满有荣耀和能力；耶和华啊，你的右手击碎了仇敌。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","你以莫大的威荣，毁灭了那些起来攻击你的人；你发出烈怒，把他们烧灭像烧禾秸一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","你鼻孔中的气一发，海水就堆聚起来；水流直立像堤坝，深渊凝结于海心。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","仇敌说：‘我要追赶，我要追上，我要均分掳物；我要在他们身上得到满足；我要拔出刀来，亲手赶绝他们。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","你用风一吹，海就把他们淹没，他们就像铅一样沉在大水之中。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","耶和华啊，万神之中有谁像你呢？有谁像你荣耀圣洁，可颂可畏，施行奇事呢？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","你伸出右手，地就吞没他们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","你凭着慈爱，带领了你买赎的人民；你凭着能力，引导了他们到你的圣所。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","万民听见，就必战抖；疼痛恐惧抓住了非利士的居民。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","那时，以东的族长惊惶，摩押的英雄被战兢抓住，所有迦南的居民都胆战心寒。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","恐惧战兢临到他们身上；因着你大能的手臂，他们像石头一样寂然不动；直到你的人民过去，耶和华啊，直到你买赎的人民过去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","你要把他们领进去，栽种在你产业的山上，耶和华啊，就是在你为自己预备的住处；主啊，就是在你手建立的圣所上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","耶和华必作王，直到永永远远。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","因为法老的马匹、战车和马兵进到海中去的时候，耶和华使海水回流到他们身上；以色列人却在海中走干地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","亚伦的姊姊女先知米利暗，手里拿着鼓；所有的妇女都跟着她出来，击鼓跳舞。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","米利暗应和着她们说：“你们要向耶和华歌唱，因为他高高地被高举起来，他把马匹和骑马的投在海中。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","摩西命以色列人从红海起程，到书珥旷野去；他们在旷野走了三天，找不着水。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","后来到了玛拉，玛拉的水却不能喝，因为水苦。因此，那地名叫玛拉。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","人民就向摩西发怨言，说：“我们喝什么呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","摩西向耶和华呼叫，耶和华就向他指示一棵树；他把树丢进水里，水就变甜了。耶和华在那里为他们立了律例和典章，也在那里试验了他们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","耶和华又说：“如果你留意听耶和华你　神的声音，行他眼中看为正的事，侧耳听他的诫命，遵守他的一切律例；这样，我决不把加在埃及人身上的一切疾病加在你们身上，因为我是医治你的耶和华。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","后来他们到了以琳，那里有十二股水泉，七十棵棕树。他们就在那里靠近水边的地方安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","以色列全体会众从以琳起行，在出埃及以后第二个月十五日，来到以琳和西奈中间汛的旷野那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","以色列全体会众在旷野都向摩西和亚伦发怨言； ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","以色列人对他们说：“我们宁愿在埃及地坐在肉锅旁边，吃饭吃到饱的时候，死在耶和华的手里！你们倒把我们领出来，到这旷野，是要叫这全体会众饿死啊！” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","耶和华对摩西说：“看哪，我要把粮食从天上降给你们；人民可以出去，每天收取当天的分量，我好试验他们是否遵行我的律法。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","到第六天，他们把收进来的预备好，比每天收取的多一倍。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","摩西和亚伦对以色列众人说：“今晚你们必定知道是耶和华把你们从埃及地领出来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","明早你们必定看见耶和华的荣耀，因为耶和华听见了你们向他所发的怨言了。我们算什么，你们竟向我们发怨言呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","摩西又说：“耶和华晚上必给你们肉吃，早晨必给你们食物吃饱，因为耶和华听见了你们埋怨他所说的怨言了。我们算什么？你们的怨言不是向我们发的，而是向耶和华发的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","摩西对亚伦说：“你要对以色列全体会众说：‘你们走近耶和华面前，因为他已经听见了你们的怨言了。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","亚伦对以色列全体会众说话的时候，他们向着旷野观望，看见耶和华的荣耀在云中显现出来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","耶和华吩咐摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“以色列人的怨言，我已经听见了。你告诉他们说：‘黄昏的时候你们必吃肉，早晨的时候必有食物吃饱；这样，你们就知道我耶和华是你们的　神了。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","到了晚上，有鹌鹑飞上来，把营都遮盖了；到了早晨，营的四周有一层露水。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","露水上升以后，就见野地上有细小鳞状的东西，像小白霜一样细小的东西。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","以色列人看见了，就彼此对问说：“这是什么？”原来他们不知道那是什么。摩西对他们说：“这就是耶和华赐给你们吃的食物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","耶和华吩咐的话是这样的：‘你们要按着各人的食量收取，按着你们的人数为帐幕里的人收取，一人两公升。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","以色列人就这样行了；有的多收、有的少收。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","他们用升斗衡量的时候，多收的没有剩余，少收的也不缺乏；各人按着自己的食量收取。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","摩西对他们说：“谁也不可把一些留到早晨。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","他们却不听摩西的话，有人把一些留到早晨，就生虫发臭了。摩西就向他们发怒。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","他们每天早晨都按着各人的食量去收取；太阳一发热，就融化了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","到第六日，他们收取了两倍的食物，每人四公升；会众的首领都来告诉摩西。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","摩西对他们说：“耶和华这样说：‘明天是安息日，是向耶和华守的圣安息日。你们要烤的，就烤吧；要煮的，就煮吧；所有余剩的要自己保存着，直留到早晨。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","他们就照着摩西吩咐的，把余剩的留到早晨；竟然不发臭，里头也没有生虫。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","摩西说：“今天吃这个吧，因为今天是向耶和华守的安息日，今日你们在田野里必找不着。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","六天你们可以收取，但第七天是安息日，在那一天什么都没有了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","第七天民间有人出去收取，可是什么也找不着。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","耶和华对摩西说：“你们拒绝遵守我的诫命和律法，要到几时呢？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","你们看，耶和华把安息日赐给了你们，所以第六日他赐给你们两天的食物；第七天你们各人要住在家里，谁都不可离开自己的地方。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","于是人民在第七天都安息了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","以色列家给这食物起名叫“吗哪”，它像芫荽的种子，色白，味道像搀蜜的薄饼。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","摩西说：“耶和华吩咐的话是这样：要把满两公升的吗哪保留起来给你们的后代，好让他们可以看见当日我把你们从埃及地领出来的时候，在旷野给你们吃的食物。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","摩西对亚伦说：“拿一个罐子来，装满两公升吗哪，存放在耶和华面前，保留起来给你们的后代。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","亚伦就照着耶和华吩咐摩西的，把吗哪存留在法柜前。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","以色列人吃吗哪共四十年，直到进了有人居住的地方为止；他们吃吗哪，直到进入迦南地的边界为止。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","两公升就是当时的标准量器的十分之一。（“两公升就是当时的标准量器的十分之一”原文作“一俄梅珥就是一伊法的十分之一”） ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","以色列全体会众都照着耶和华的吩咐，一站一站，从汛的旷野起程，在利非订安营。在那里人民没有水喝。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","因此人民与摩西争吵，说：“给我们水喝吧。”摩西对他们说：“你们为什么与我争吵呢？你们为什么试探耶和华呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","人民在那里渴望得水喝，就向摩西发怨言，说：“你为什么把我们从埃及领上来，使我们和我们的儿女，以及我们的牲畜都渴死呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","摩西向耶和华呼求，说：“我要怎样对待这人民呢？他们几乎要用石头打死我了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","耶和华回答摩西：“你要到人民的面前，要带着以色列的几个长老和你一起，手里要拿着你先前击打河水的杖。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","看哪，我必在何烈山那里的磐石上站在你面前；你要击打磐石，就必有水从磐石流出来，使人民可以喝。”摩西就在以色列的长老眼前这样行了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","他给那地方起名叫玛撒，又叫米利巴，因为以色列人在那里争吵，又因为他们试探耶和华，说：“耶和华是不是在我们中间呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","那时亚玛力人来了，在利非订和以色列人争战。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","摩西对约书亚说：“你要为我们选出人来，出去和亚玛力人争战；明天我要站在山顶上，手里拿着　神的杖。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","于是，约书亚照着摩西吩咐他的行了，去和亚玛力人争战；摩西、亚伦和户珥都上了山顶。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","摩西举起手来的时候，以色列人就得胜；摩西把手放下来的时候，亚玛力人就得胜。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","可是摩西的两手疲乏了，他们就搬块石头来，放在摩西下面，他就坐在上面；亚伦和户珥，一边一个，扶着摩西的两手；这样，他的两手就稳住，直到日落的时候。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","约书亚用刀打败了亚玛力王和他的人民。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","耶和华对摩西说：“我要把亚玛力的名号从天下完全抹掉；你要把话写在书上作记念，也要告诉约书亚。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","摩西筑了一座祭坛，给它起名叫“耶和华尼西”。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","摩西又说：“向耶和华的旌旗举手，耶和华必世世代代和亚玛力人争战。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","摩西的岳父，米甸祭司叶忒罗，听见了　神为摩西和他自己的人民以色列所行的一切，就是耶和华怎样把以色列人从埃及领出来的事， ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","他就带着摩西的妻子西坡拉，摩西从前送了她回去， ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","又带着西坡拉的两个儿子，一个名叫革舜，因为摩西说：“我在异地作了客旅”； ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","一个名叫以利以谢，因为他说：“我父亲的　神是我的帮助，救我脱离了法老的刀。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","摩西的岳父叶忒罗，和摩西的妻子与两个儿子，来到旷野摩西那里，就是到　神的山，摩西安营的地方。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","叶忒罗叫人告诉摩西说：“你的岳父叶忒罗来见你，你的妻子和两个儿子也一同来了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","摩西出来迎接他的岳父，向他下拜，与他亲嘴，彼此问候，然后一起进了帐棚。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","摩西把耶和华为以色列的缘故，向法老和埃及人所作的一切，以及路上遭遇的一切困难，并且耶和华怎样拯救他们，都向他的岳父述说。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","叶忒罗因为耶和华为以色列人所行的美事，就是拯救他们脱离埃及人的手，就非常喜乐。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","叶忒罗说：“耶和华是应当称颂的，他拯救了你们脱离埃及人的手和法老的手；他也把这人民从埃及人的手下拯救出来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","现在我知道耶和华为至大，超乎万神之上，因为这在埃及人以狂傲的态度对以色列人的事上已经证明了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","摩西的岳父叶忒罗把燔祭和几样祭品拿来献给　神；亚伦和所有以色列的长老都来到　神面前，与摩西的岳父一同吃饭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","次日，摩西坐着审判人民的案件；人民从早到晚都站在摩西的身旁。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","摩西的岳父看见了摩西向人民所行的一切，就说：“你向人民作的是什么呢？你为什么独自坐着审判，所有的人民却从早到晚都站在你的身旁呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","摩西回答他岳父：“因为人民到我这里来求问　神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","他们有事件的时候，就到我这里来，我就在双方之间施行审判，使他们认识　神的条例和律法。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","摩西的岳父对摩西说：“你这样作不好。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","你必疲乏不堪；不但你自己，连与你在一起的人民也必疲乏不堪，因为这事太重，你不能独自一人去作。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","现在你要听我的话，我要给你出个主意，愿　神与你同在；你要代替人民到　神面前，把他们的事件带到　神那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","又要把规例和律法教导他们，使他们知道他们当走的路，应作的事。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","你要从人民中间选出有才能的人，就是敬畏　神、忠实可信、恨恶不义之财的人，设立他们作千夫长、百夫长、五十夫长、十夫长，去管理人民， ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","使他们随时可以审判人民的案件；所有大事件，他们要带到你这里来；所有小事件，他们可以自己审判。这样，你就轻省些，他们也可以和你一同分担此事。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","你若是这样行，　神也这样吩咐你，你就能站立得住，所有的人民也都能平平安安地归回自己的地方。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","于是，摩西听从他岳父的话，照着他所说的行了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","摩西从全体以色列人中选出了有才能的人，立他们作人民的首领，作千夫长、百夫长、五十夫长、十夫长。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","他们随时审判人民的案件；有困难的事件，他们就带到摩西那里；所有小事件，由他们自己审判。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","后来，摩西给他的岳父送行，他就回自己的地方去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","以色列人从埃及地出来以后，满了三个月的那一天，就来到西奈的旷野。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","他们从利非订起行，来到西奈的旷野，就在旷野安营；以色列人在那座山前安了营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","摩西上到　神那里去，耶和华从山上呼唤他，说：“你要这样告诉雅各家，吩咐以色列人说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘我向埃及人所行的，你们都看见了；也看见了我怎样像鹰一样把你们背在翅膀上，带领你们到我这里来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","现在你们若是实在听我的话，遵守我的约，你们就必在万民中作属我的产业，因为全地都是我的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","你们要归我作君尊的祭司和圣洁的国民。’这些话你都要对以色列人说。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","摩西去把人民的长老召了来，把耶和华吩咐他的这一切话都摆在他们面前。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","人民都一致地回答，说：“凡是耶和华吩咐的，我们都要遵行。”摩西就去把人民的话回复耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","耶和华对摩西说：“看哪，我要在密云中降临到你那里，为要使人民在我与你说话的时候可以听见，也可以永远信你。”于是，摩西把人民的话告诉了耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","耶和华对摩西说：“你到人民那里去，要他们今天明天分别为圣，又要他们洗净自己的衣服； ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","第三天，他们要准备好了，因为第三天耶和华要在全体人民眼前降临在西奈山。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","你要在山的周围给人民定界限，说：‘你们要谨慎，不可上山来，也不可触摸山脚；凡是触摸着那山的，必要把他处死。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","不可用手触摸他，必须用石头把他打死，或用箭射透；无论是牲畜，是人，都不得生存。’当号角声拖长的时候，你们才可以上到山上来。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","摩西从山上下来到人民那里去，使人民分别为圣，他们就把自己的衣服洗净了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","他对人民说：“第三天，你们要预备好了；不可亲近女人。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","到了第三天早晨的时候，山上有雷声、闪电和密云，并且角声非常强大，以致所有在营中的人民都颤抖。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","摩西率领人民出营去迎接　神，他们都站在山下。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","西奈全山冒烟，因为耶和华在火中降临到山上；山的烟向上升，好像火窑的烟一样。全山猛烈震动。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","角声越来越大，大到极点的时候，摩西就说话，　神用雷声回答摩西。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","耶和华降临在西奈山上，就是降临到山顶上；耶和华呼召摩西上山顶，他就上去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","耶和华对摩西说：“你下去警告人民，不可闯过来，到我这里观看，免得他们中间有很多人灭亡。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","又叫那些亲近耶和华的祭司分别为圣，恐怕耶和华忽然击杀他们。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","摩西对耶和华说：“人民不能上西奈山，因为你曾经警告我们，说：‘要给山定界限，也要把山分别为圣。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","耶和华对他说：“下去吧，你要和亚伦一起再上来，只是祭司和人民都不可闯过来，上到我这里，恐怕我忽然击杀他们。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","于是，摩西下到人民那里告诉他们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","神吩咐以下这一切话，说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“我是耶和华你的　神，曾经把你从埃及地，从为奴之家领出来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“除我以外，你不可有别的神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“不可为自己做偶像，也不可做天上、地下和地底下水中各物的形象。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","不可跪拜它们，也不可事奉它们，因为我耶和华你们的　神是忌邪的　神；恨恶我的，我必追讨他们的罪，从父亲到儿子，直到三四代。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","爱我和遵守我诫命的，我必向他们施慈爱，直到千代。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“不可妄称耶和华你　神的名，因为妄称耶和华的名的，耶和华必不以他为无罪。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“要记念安息日，守为圣日。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","六日要劳碌，作你一切工作。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","但第七日是耶和华你的　神的安息日；这一日，你和你的儿女，你的仆婢和牲畜，以及住在你城里的寄居者，不可作任何的工。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","因为耶和华在六日之内造天、地、海和其中的万物，第七日就歇息了；所以耶和华赐福安息日，定为圣日。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“要孝敬父母，使你在耶和华你的　神赐给你的地上得享长寿。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“不可杀人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“不可奸淫。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“不可偷盗。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“不可作假证供陷害你的邻舍。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“不可贪爱你邻舍的房屋；不可贪爱你邻舍的妻子、仆婢、牛驴和他的任何东西。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","全体人民都看见打雷、闪电、角声和冒着烟的山；人民看见了，就颤抖，远远地站着。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","他们对摩西说：“求你和我们说话吧，我们必定听你的话，不可让　神和我们说话，恐怕我们死亡。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","摩西回答人民：“不要惧怕，因为　神降临是要试验你们，叫你们常常敬畏他，不至犯罪。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","于是，人民远远地站着，摩西却走近　神所在的幽暗之中。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","耶和华对摩西说：“你要对以色列人这样说：‘你们亲自看见我从天上和你们说话了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","你们不可做银的神像和金的神像和我相比，你们决不可为自己做这些神像。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","你要为我筑一座土坛，把你的燔祭、平安祭和牛羊献在坛上；在我使人记念我名的地方，我都必到你那里去赐福你。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","你若是为我筑一座石坛，不可用凿过的石头来建筑，因为你在石头上一动用工具，就把坛污秽了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","你上我的坛，不可用梯级，免得在坛上露出你的下体来。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“你要在众民面前订立的典章是这样的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","如果你买希伯来人作奴仆，他要服事你六年；到第七年他可以自由出去，不必补偿什么。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","他若是单身来，就可以单身出去；他若是有妇之夫，他的妻子就可以和他同去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","他的主人若是给他妻子，妻子又给他生了儿女，那么妻子和儿女都要归给主人，他自己要单独出去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","如果那奴仆明明说：‘我爱我的主人和我的妻子儿女，不愿意自由出去。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","他的主人就要把他带到审判官（“审判官”原文作“　神”）那里，又要把他带到门前，或是门柱旁；他的主人要用锥子刺穿他的耳朵，他就要永远服事他的主人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","如果有人把女儿卖作婢女，婢女不可像男仆那样出去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","如果主人选定她归自己，以后又不喜欢她，就要准她赎身；主人没有权力可以把她卖给外族人，因为主人曾经欺骗了她。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","如果主人选定她归自己的儿子，就必须照着待女儿的规矩待她。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","如果他另娶一个妻子，那么，对她的饮食、衣着和性的需要，仍然不可减少。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","如果他不向她行这三样，她就可以自由出去，不必补偿什么。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“打人以致把人打死的，必要把那人处死。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","人若不是蓄意杀人，而是　神交在他手中的，我就给你设立一个地方，他可以逃到那里去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","若有人任意待他的邻舍，用诡计把他杀了，你要把他从我的祭坛那里拿去处死。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“打父母的，必要把那人处死。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“拐带人口的，无论是把人卖了，或是还留在他手中，必要把那人处死。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","咒骂父母的，必要把那人处死。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“如果人彼此争论，一个用石头或拳头打另一个，但他还没有死，不过要躺在床上， ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","以后，他若是能起来，能扶杖出外行走，那打他的就可算无罪，但要赔偿他停工的损失，并且要把他完全医好。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“如果有人用棍打他的奴仆或婢女，以致死在他的手下，他必须受刑罚； ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","但如果他还活一两天，那人就不必受刑罚，因为那奴仆是他的财产。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“如果人彼此争斗，击伤了怀孕的妇人，以致流产，但没有别的损害，那伤害她的必须按照妇人的丈夫要求的，和照着审判官断定的，缴纳罚款。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","如果有别的损害，你就要以命偿命， ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","以眼还眼，以牙还牙，以手还手，以脚还脚， ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","以烙还烙，以伤还伤，以打还打。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“如果有人击打他奴仆的一只眼，或婢女的一只眼，把眼打坏了，就要因他的眼的缘故让他自由离去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","如果有人打落了他奴仆的一只牙，或婢女的一只牙，就要因他的牙的缘故让他自由离去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“如果牛触了男人或女人，以致死亡，那牛必须用石头打死，只是不可吃牛的肉；牛的主人却不必受刑罚。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","如果那牛以前常常触人，牛主也曾经受过警告，他仍然不把牛拴好，以致触死了男人或是女人，就要用石头把那牛打死，牛主也必要处死。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","如果给他提出赎金，他就必须照着提出的数量全数缴付赎命金。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","牛无论触了人的儿子，或是触了人的女儿，都必须照着这定例办理。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","如果牛触了人的奴仆，或是婢女，必须把三百四十克银子给他的主人，那牛也必须用石头打死。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“如果有人把井敞开，或是有人挖了井，而不把井口遮盖，以致有牛或驴掉进里面， ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","井主要赔偿，要把银子还给牛主或驴主，死的牲畜可以归自己。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“如果有人的牛伤了他邻舍的牛，以致死亡，他们要把活牛卖了，平分银子，也要平分死牛。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","如果人知道那牛以前常常触人，牛主竟不把牛拴好，他必须赔偿，以牛还牛，死的可以归自己。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“如果人偷了牛或是羊，无论是宰了或是卖了，他必须赔偿，以五牛还一牛，以四羊还一羊。（本节在《马索拉抄本》为 21:37） ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","“窃贼挖窟窿入屋的时候，如果被人发现，把他打了，以致打死，打死人的就没有流人血的罪。（本节在《马索拉抄本》为 22:1） ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","如果太阳出来了，他就有流人血的罪。窃贼必须赔偿，如果他一无所有，就要卖身，还他所偷之物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","所偷之物，无论是牛、是驴，或是羊，如果发现在他手中仍然活着，他必须双倍偿还。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","如果有人在田间或葡萄园里放牲畜吃草，任由牲畜到别人的田里去吃草，就必须拿自己田间最好的，或自己葡萄园中最好的赔偿。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“如果火烧起来，烧着了荆棘，以致把别人堆积的禾捆、竖立的庄稼，或是田园都烧尽了，那点火的必须赔偿。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“如果人把银子或家中物件交给邻舍看守，这些东西从那人的家被偷去；如果把窃贼抓到了，窃贼就要双倍偿还。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","如果找不到窃贼，那家主必要到审判官（“审判官”原文作“　神”）那里，查明他有没有下手拿去邻舍的财物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","任何争讼的案件，无论是为了牛、驴、羊、衣服，或是什么遗失了的东西，如果一方说：‘这是我的’，这样，双方的案件就要带到审判官（“审判官”原文作“　神”）面前，审判官定谁有罪，谁就要双倍偿还给他的邻舍。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“如果人把驴、牛、羊，或是任何牲畜交给邻舍看守，牲畜死亡、受伤，或是被赶去，又没有人看见， ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","两人必须在耶和华面前起誓，表明他没有下手拿去邻舍的财物；如果物主接受那誓言，看守的人就不必赔偿。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","如果牲畜真的从看守的人那里被偷去，他就要赔偿给物主。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","如果真的被野兽撕碎了，看守的人就要把被撕碎的带来作证据，这样，他就不必赔偿。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“如果人向邻舍借什么，所借的无论是受了伤，或是死了，物主不在场，借的人就必须偿还。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","如果物主在场，他就不必偿还；若是雇来的，也不必偿还，因为他为雇价来的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“如果人引诱还没有许配人的处女，与她同寝，他必须交出聘礼，娶她为妻。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","如果处女的父亲坚决不肯把女儿嫁给他，他就要按照处女的聘礼，交出聘银来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“不可让行巫术的女人活着。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“凡与牲畜同寝的，那人必须处死。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“除了独一的耶和华以外，还献祭给别神的，那人必须灭绝。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","不可欺负寄居的，也不可压迫他，因为你们在埃及地也作过寄居的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","不可苦待任何孤儿寡妇。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","如果你们真的苦待他们，他们一向我呼求，我必定听他们的呼求， ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","并且我要发怒，用刀杀死你们，使你们的妻子成为寡妇，你们的儿女成为孤儿。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“如果你借钱给我的人民，就是与你们在一起的穷人，你对待他们不可像放债的人一样，不可在他们身上取利。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","如果你拿了邻居的衣服作抵押，必须在日落之前归还给他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","因为这是他唯一的铺盖，是他蔽体的衣服；如果没有了它，他拿什么睡觉呢？如果他向我呼求，我必应允，因为我是满有恩惠的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“不可咒骂　神，也不可咒诅你人民的领袖。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","要把你丰收的五谷和初榨的新酒献上，不可迟延；要把你头生的儿子献给我。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","对于牛羊头生的，你也要这样作；七天之内，可以和母的在一起，第八天就要把它献给我。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","你们要归我作圣洁的人；因此田间被野兽撕碎的肉，你们不可以吃，要把它丢给狗吃。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“不可传播谣言，也不可与恶人携手作假见证。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","不可随众行恶，不可在诉讼的事上随众说歪曲正义的话； ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","也不可在诉讼的事上偏护穷人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“如果你遇见你仇敌的牛或是驴走迷了路，就应该把它牵回来给他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","如果你看见恨你的人的驴伏在重担之下，不可走开不理它，你应该与驴主一同卸下重担。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","不可在穷人诉讼的事上歪曲正义。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","要远离虚假的事；不可杀无辜和正义的人，因为我决不以恶人为义人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","不可受贿赂，因为贿赂能使明眼人变瞎，又能歪曲义人的话。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","不可压迫寄居的，因为你们在埃及地也作过寄居的，知道寄居者的心情。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“六年之内你要耕种田地，收取地的出产； ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","但是第七年，你要让地歇息，不耕不种，使你民间的穷人可以有吃的；他们吃剩的，田间的野兽可以吃；你的葡萄园和橄榄园，也要这样作。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","六日之内，你要作你的工；但第七日你要安息，好使你的牛和驴可以歇息，并且使你婢女的儿子和寄居的也可以有时间喘息一下。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","我对你们所说的一切，你们都要小心谨守，你们不可提别神的名，也不可让人从你的口中听到。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“每年三次，你要为我守节。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","你要守无酵节，要照我吩咐的，在亚笔月内所定的日期，吃无酵饼七天，因为你是在这个月从埃及出来的。你们不可空手朝见我。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","又要守收割节，就是收在田间你劳碌耕种所得初熟之物的节；也要在年底守收藏节，就是在田间收集你劳碌所得之物的时候。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","一年三次，你所有的男丁都要朝见主耶和华的面。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“你不可把我祭牲的血和有酵的饼一同献上；也不可把我节日祭牲的脂油留过夜到早晨。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","要把你地上最上好的初熟之物带到耶和华你　神的殿中。不可用山羊羔母的奶去煮山羊羔。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“看哪，我在你面前差派使者，好在路上保护你，领你到我预备的地方去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","你们在他面前要谨慎，要听他的话，不可违背他；不然，他必不赦免你们的过犯，因为他是奉我的名来的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","如果你实在听他的话，遵行我吩咐的一切，我就要作你仇敌的仇敌，作你敌人的敌人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","我的使者必在你前面走，领你到亚摩利人、赫人、比利洗人、迦南人、希未人、耶布斯人那里去；我要把他们除掉。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","你不可跪拜他们的神像，也不可事奉它们，不可作他们所作的，不可模仿他们的行为，却要把神像完全拆毁，打碎他们的柱像。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","你们要事奉耶和华你们的　神，他就必赐福你的粮和你的水，我也必从你们中间除去疾病。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","在你的境内，必没有流产和不育的妇女；我必使你一生的寿数满足。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","我必在你面前展露我的威严；凡你所到的地方，我必使那里的人民慌乱，又使你所有的仇敌都转背而逃。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","我必在你面前打发大黄蜂，把希未人、迦南人、赫人，都从你面前驱逐出去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","我不在一年之内把他们从你面前驱逐出去，恐怕这地变为荒凉，又恐怕田野间的走兽多起来害你。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","我要渐渐地把他们从你面前驱逐出去，等到你的人数增多起来，承受那地为止。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","我要限定你的境界，从红海直到非利士海，从旷野直到大河。我要把那地的居民交在你手中，你要把他们从你面前驱逐出去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","不可与他们和他们的神立约。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","不可让他们住在你的境内，恐怕他们使你得罪我；如果你事奉他们的神，这必成为你的网罗。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","耶和华对摩西说：“你要上到耶和华这里来。你自己、亚伦、拿答、亚比户和以色列长老中的七十人都要上来，你们要远远下拜。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","只有摩西一人可以走近耶和华，他们却不可以亲近；人民也不可和摩西一同上来。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","摩西下来，把耶和华的一切话和一切典章都向人民讲述；人民都同声回答，说：“耶和华吩咐的一切话，我们都必遵行。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","摩西把耶和华的一切话都记下了；清早起来，在山下筑了一座祭坛，按着以色列十二支派立了十二根柱子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","又派了以色列人中的青年人去献燔祭，又向耶和华杀牛献为平安祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","摩西取了一半的血，盛在盆中；又取了另一半的血，洒在祭坛上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","他又把约书拿过来，念给人民听；他们说：“耶和华吩咐的一切话，我们都必遵行和听从。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","摩西就取了血来，洒在人民的身上，说：“看哪，这是立约的血，这约是耶和华按着这一切话与你们立的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","随后，摩西、亚伦、拿答、亚比户和以色列长老中的七十人都上了山。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","他们看见了以色列的　神；在　神的脚下有好像蓝宝石一样晶莹的铺路，好像天色一般明亮。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","他不伸手攻击以色列人中的显贵；他们看见　神，并且又吃又喝。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","耶和华对摩西说：“你要上山到我这里来，要住在这里；我要把石版，就是我所写的律法和诫命赐给你，使你可以教导人民。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","于是，摩西和他的侍从约书亚起来；摩西就上到　神的山那里去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","但摩西对长老说：“你们要在这里等候我们，直到我们再回到你们那里来。看哪！这里有亚伦和户珥与你们在一起，谁有诉讼的案件，都可以到他们那里去。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","摩西上到山上，有云彩把山遮盖着。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","耶和华的荣耀停在西奈山上，云彩把山遮盖了六天；第七天，耶和华从云彩中呼唤摩西。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","耶和华荣耀的景象，在以色列人眼前，好像在山顶上出现烈火。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","摩西进入云彩中，上到山上去；摩西在山上四十昼夜。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“你要告诉以色列民，叫他们给我送礼物来，所有心里乐意奉献的人，你们就可以收下他们给我的礼物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","以下是你们要从他们收取的礼物：金、银、铜、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","蓝色紫色朱红色线、细麻、山羊毛、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","染红的公羊皮、海狗皮、皂荚木、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","灯油、膏油的香料和焚香用的香料， ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","绿柱玉宝石和镶嵌在以弗得和胸牌上的宝石。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","他们要为我建造圣所，使我可以在他们中间居住。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","按着我指示你建造会幕和一切器具的样式，你们要照样建造。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“他们要用皂荚木做一个柜，长一百一十公分，宽六十六公分，高六十六公分。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","你要用纯金包柜，内外都要包上；柜上的四围要做金边。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","你要铸造四个金环，安放在柜的四脚上，两个环在这边，两个环在那边。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","你要用皂荚木做几根柜杠，并要用金包裹起来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","你要把柜杠穿在柜旁的环中，以便用杠抬柜。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","柜杠要常留在柜的环中，不可抽出环外。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","你要把我赐给你的法版放在柜里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","你要用纯金做施恩座，长一百一十公分，宽六十六公分。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","你要用黄金锤成两个基路伯，放在施恩座的两端。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","这端做个基路伯，那端做个基路伯，二基路伯要与施恩座连在一起制造，在施恩座的两端。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","二基路伯要在上面展开双翼，遮掩施恩座，基路伯的脸要彼此相对，他们的脸要朝着施恩座。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","你要把施恩座安放在柜顶，又要把我赐给你的法版放在柜里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","我要在那里和你相会，也要从施恩座上面，从二基路伯之间，告诉你一切我命令你传给以色列人的事。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“你要用皂荚木做一张桌子，长八十八公分，宽四十四公分，高六十六公分。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","你要用纯金包桌子，桌子的四围要做金边。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","你要给桌子的四围做七十五公厘宽的框边，框边上的四围要做金边。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","你要做四个金环，把金环安放在桌子的四角上，就是在桌子的四脚上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","环子要靠近框边，用来穿桌杠，以便抬桌子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","你要用皂荚木做几根桌杠，又要用金包裹起来，桌子要用桌杠来抬。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","你要做桌子上的盘子、碟子、酒杯和奠酒用的瓶，这些你要用纯金制造。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","你又要在桌子上，在我面前，常常摆放陈设饼。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“你要用纯金做一个灯台，那灯台你要用锤锤成；灯台的座、干、杯、球、花，都要与灯台连在一起。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","灯台的两边伸出六个枝子；一边有三个灯台枝子，另一边也有三个灯台枝子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","在第一个枝子上有三个杯，形状像杏花，有球、有花；在另外一个枝子也有三个杯，形状像杏花，有球、有花。从灯台伸出的六个枝子，都是这样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","灯台上有四个杯，形状像杏花，有球、有花。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","每两个枝子的下面有球和灯台相连，从灯台伸出来的六个枝子，都是这样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","球和枝子都要与灯台连在一起，都是从一块纯金锤成的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","你要做灯台上的七个灯盏，这些灯盏要放在灯台之上，使灯光照亮对面的地方。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","灯台上的灯剪和灯花盆，也是要纯金做的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","要用三十五公斤纯金做灯台和一切器具。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","你要留心照着在山上指示你的样式去做。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“你要用十幅幔子来做会幕；幔子要用捻的细麻、蓝色紫色朱红色线做成，并要用巧工绣上基路伯。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","每幅幔子要长十二公尺，宽两公尺，每幅幔子都要一样的尺寸。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","其中五幅幔子要彼此相连，另外五幅幔子也要彼此相连。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","其中一组相连的幔子最后一幅的边上，你要做蓝色的钮扣；在另一组相连的幔子最后一幅的边上，你也要这样做。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","在这幅幔子上，你要做五十个钮扣；在另一组幔子最后一幅的边上，你也要做五十个钮扣，这些钮扣要彼此相对。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","你要做五十个金钩，又要用钩使幔子相连起来，成为一整个会幕。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“你要用山羊毛做幔子，作会幕上面的帐棚，你要做十一幅幔子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","每幅幔子要长十三公尺，宽两公尺，十一幅幔子都要一样的尺寸。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","你要把五幅幔子连在一起，又把另外六幅幔子连在一起，你要在帐棚前面把第六幅幔子折叠起来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","在这一组相连的幔子最后一幅的边上，你要做五十个钮扣；在另一组相连的幔子最后一幅的边上，也要做五十个钮扣。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","你又要做五十个铜钩，把钩穿进钮扣中，使帐棚连起来，成为一整个帐棚。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","帐棚的幔子多出的那部分，即垂下来的半幅幔子，要垂在会幕的后面。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","帐棚幔子多出的长度，要这边五十公分，那边五十公分，并且要在会幕的两边，遮盖会幕。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","你又要用染红的公羊皮做帐棚的顶盖，在上面再盖上海狗皮。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“你要用皂荚木做会幕的竖板， ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","每块板要长四公尺，宽六十六公分。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","每块木板要有两个榫头，彼此连接，会幕的一切木板你都要这样做。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","你要给会幕做木板；给南边，就是向南的一面，做二十块木板， ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","在这二十块板底下，你要做四十个银插座；每块木板底下有两个插座连接它的两个榫头。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","你也要给会幕的另一边，就是北面，做二十块木板， ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","和四十个银插座。这块木板底下有两个插座，那块木板底下也有两个插座。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","给会幕的后面，就是西面，你要做六块木板。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","在会幕后面的两角上，你要做两块木板。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","木板的下截是要双的，一直连到上面的第一环那里，都是要双的。两块都要这样做，要成为两只角。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","所以要有八块木板，和十六个银插座，这块木板底下有两个插座，那块木板底下也有两个插座。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“你要用皂荚木做横闩，为会幕这边的木板做五个横闩， ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","为会幕那边的木板也做五个横闩，又为会幕的后边，即西边的木板，也做五个横闩。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","木板中部的中闩，要从这一端通到那一端， ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","木板要包金，你也要做板上的金环，用来穿上横闩，横闩也要包金。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","你要照着在山上指示你的样式立起会幕。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“你要用蓝色紫色朱红色线和捻的细麻做幔幕，并且要用巧工绣上基路伯。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","你要把幔幕挂在四根包金的皂荚木柱子上，柱上有金钩，柱脚安在四个银插座上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","你要把幔幕挂在钩子上，把法柜抬进幔幕里面，这幔幕要给你们把圣所和至圣所分开。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","你要把施恩座安在至圣所内的法柜上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","你要把桌子放在幔幕外，把灯台放在会幕的南边，与桌子相对；把桌子安在北面。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“你要给帐幕的门口做块帘子，要用蓝色紫色朱红色线和捻的细麻编织而成。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","你又要用皂荚木为帘子做五根柱子，柱子要包金，柱上有金钩，你也要为柱脚铸造五个铜插座。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“你要用皂荚木做祭坛，这坛要四方的：长两公尺两公寸，宽两公尺两公寸，高一公尺三公寸。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","要在祭坛的四拐角做四个角，角要与祭坛连在一块，祭坛要包上铜。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","要做盆，用来收去祭坛上的灰，又要做铲、盘、肉叉和火鼎；祭坛上的一切器具，你都要用铜来做。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","要为坛做一个铜网，网的四拐角上要做四个铜环。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","要把网安在祭坛下面的围腰板之下，使网从下面直达到祭坛的半腰。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","又要为祭坛做杠，就是皂荚木的杠，要包上铜。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","杠要穿在祭坛的环子里，抬祭坛的时候，杠就在祭坛的两边； ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","你要用木板做祭坛，祭坛是空心的。你要照着在山上指示你的去做。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“你要做会幕的院子。在南面，即向南的一面，要用捻的细麻为院子做帷幔，每边长四十四公尺。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","帷幔的柱子要二十根，铜插座二十个。柱子上的钩子和桁子都是银的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","北面也是一样，要有四十四公尺长的帷幔，帷幔的柱子二十根，铜插座二十个，柱子上的钩子和桁子都是银的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","院子的西面，也要有帷幔，宽二十二公尺。帷幔的柱子十根，插座十个。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","院子的东面，要有二十二公尺宽。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","门一面的帷幔要六公尺六公寸，帷幔的柱子三根，插座三个。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","门另一面的帷幔也要六公尺六公寸，帷幔的柱子三根，插座三个。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","院子的大门要有门帘，长九公尺，是用蓝色紫色朱红色线和捻的细麻，用刺绣的手工织成，柱子四根，插座四个。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","院子周围一切柱子，都要用银桁子相连起来。柱子上的钩子是银的，插座是铜的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","院子要长四十四公尺，宽二十二公尺，高两公尺两公寸；帷幔是细麻捻的，插座是铜的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","会幕中为礼拜用的一切器具和钉子，以及院子里的一切钉子，都是铜的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“你要吩咐以色列民把打成的纯橄榄油拿来给你，是为点灯用的，使灯常常点着。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","在会幕中法柜前的幔子外，亚伦和他的子孙，从晚上到早晨，要常在耶和华面前料理这灯。这要作以色列人世世代代的定例。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“你要从以色列人中使你的哥哥亚伦和他的众子，就是亚伦和他的众子：拿答、亚比户、以利亚撒、以他玛，都一同来到你面前，作事奉我的祭司。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","你要为你哥哥亚伦做圣衣，使他有荣耀，有华美。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","你又要吩咐所有心中有智慧的，就是我用智慧的灵充满的，给亚伦做衣服，使他成圣，作事奉我的祭司。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","这些就是他们要做的衣服：胸牌、以弗得、长外袍、杂色内袍、礼冠、腰带。他们要为你哥哥亚伦和他的众子做圣衣，使他们作事奉我的祭司。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","他们要拿金线、蓝色紫色朱红色线和细麻去做。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“他们要拿金线、蓝色紫色朱红色线和捻的细麻，用巧工来做以弗得。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","以弗得要有两条肩带，连接着两端，好使它相连在一起。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","以弗得上面的带子，它的巧工要和以弗得一样，用来束上以弗得，要用金线、蓝色紫色朱红色线和捻的细麻做成。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","你要取两块红宝石，把以色列众子的名字刻在上面， ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","六个名字在一块宝石上，其余六个名字在另一块宝石上，都是照着他们出生的次序。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","好像宝石雕刻匠刻印章一样，你要把以色列众子的名字刻在这两块宝石上，要把它们镶嵌在金槽中。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","你要把这两块宝石安放在以弗得的肩带上，作以色列民的记念石。亚伦在耶和华面前，用两肩担当他们的名字，作为记念。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","你要做金槽， ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","和两条纯金的链子，像做绳子一样拧成，把这像绳子一样的链子放置在二槽上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“你要用巧工做一个作判断用的胸牌，像以弗得的做法一样，要用金线、蓝色紫色朱红色线和捻的细麻做成。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","胸牌要四方的，双层的，长二十二公分，宽二十二公分。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","你要在胸牌上面镶上四行宝石：第一行是红宝石、黄玉、翡翠； ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","第二行是紫宝石、蓝宝石、金钢石； ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","第三行是黄玛瑙、白玛瑙、紫晶； ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","第四行是水苍玉、红玛瑙、碧玉。这些宝石都是镶在金槽里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","按着以色列众子的名字，这些宝石要有十二块；按着他们的名字刻印章，按他们的名字各代表十二个支派。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","你要在胸牌上做纯金的链子，像做绳子一样拧成。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","你要在胸牌上做两个金环，把这两个金环安在胸牌的两端之上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","你要把那两条金链子穿在胸牌两端的两个环子里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","你又要把那两条链子的另两端接在两槽上，连在以弗得前面的肩带上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","你又要做两个金环，安在胸牌下边的两端，就是靠近以弗得里面的边缘上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","你又要做两个金环，把它们安在以弗得前面两条肩带的下面，靠近相接的地方，在以弗得巧工织成的带子上面。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","你要用紫蓝色细线把胸牌的环子系在以弗得的环子上，使胸牌贴在以弗得巧工织成的带子上，免得胸牌从以弗得上脱下来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","亚伦进入圣所的时候，要把作决断用的胸牌，上面有以色列众子的名字，带在胸前，在耶和华面前常作记念。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","你要把乌陵和土明放在作决断用的胸牌里。亚伦进入耶和华面前的时候，它们要带在胸前；这样，亚伦就在耶和华面前常常把以色列众子的决断带在胸前。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“你要做以弗得的长外袍，全件要紫蓝色。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","在长外袍的正中，头部的地方，要有一个领口，领口的周围要有领边，是用纺织的细工织成，如同战袍的领口一样，免得长外袍破裂。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","在长外袍下摆的周围，你要用蓝色紫色朱红色线做石榴，在长外袍下摆周围的石榴中间，要缀上金铃。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","在长外袍下摆的周围缀上一个金铃、一个石榴、一个金铃、一个石榴， ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","长外袍要穿在亚伦的身上，好作事奉。他进入圣所到耶和华面前，以及出来的时候，他的声音必被听见，免得他死亡。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“你要用精金做一面牌子，在牌上像刻印章般刻着：‘归耶和华为圣’。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","你要用一条紫蓝色细线把牌子系住，好使它安在礼冠上，就是在礼冠的前面。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","这牌要在亚伦的额上，亚伦要担当干犯圣物的罪过，这些圣物是以色列人在一切圣礼物上分别为圣的；这牌要常在亚伦的额上，好使他们在耶和华面前可以得蒙悦纳。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","你要用细麻线编织杂色内袍，用细麻布做礼冠，又用刺绣的手工做腰带。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","“你也要为亚伦的儿子做内袍，为他们做腰带，又为他们做头巾，使他们有荣耀，有华美。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","你要把这些给你哥哥亚伦和他的儿子们穿上，又要膏抹他们，按立他们，把他们分别为圣，好使他们可以作我的祭司。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","你要给他们做白麻布裤子，遮盖裸体，裤子遮盖腰间，直到大腿。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","亚伦和他儿子进入会幕，或走近祭坛，在圣所里事奉的时候，都必须穿上裤子，免得他们担当罪过而死。这要给亚伦和他的后裔作永远的条例。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“你要把他们分别为圣，使他们作我的祭司，就必须这样作：取一头小公牛和两只没有残疾的公绵羊， ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","以及无酵饼、调油的无酵饼和抹油的无酵薄饼。这些你都要用细麦面来做。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","你要把这些饼放在篮子里，用篮子把饼带来献上，又把小公牛和两只绵羊牵来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","你要把亚伦和他儿子们带到会幕门口，用水给他们洗身。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","你要拿衣服来，给亚伦穿上杂色内袍、以弗得的长外袍、以弗得和胸牌，又束上巧工织成的以弗得的带子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","你要把礼冠戴在他头上，又把圣冠放在礼冠上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","你要把膏油拿来，倒在他头上，膏立他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","你也要把他的儿子带来，给他们穿上杂色内袍。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","要给亚伦和他儿子束上腰带，包上头巾；这样，他们就按永远的定例，得了祭司的职分。你又要把亚伦和他儿子们分别为圣。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“你要把公牛带到会幕来献上，亚伦和他儿子们要按手在公牛的头上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","你要在耶和华面前，在会幕门口，宰杀那公牛。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","你要取些公牛的血，用你的指头抹在祭坛的角上，把其余的血都倒在祭坛脚前。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","你要把一切遮盖内脏的脂油、肝叶、两个腰子和腰子上的脂油，都取出来，把它们焚烧在祭坛上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","至于公牛的肉、皮和粪，你都要在营外用火焚化。因为这是赎罪祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“你要把一只公绵羊牵来，亚伦和他儿子们要按手在这公绵羊的头上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","你要宰杀这公绵羊，取些羊血，洒在祭坛的周围。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","你要把公绵羊切成块子，再把内脏和羊腿洗净，放在肉块和羊头上面。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","你要把整只公绵羊焚烧在祭坛上；这是献给耶和华的燔祭，是献给耶和华馨香的火祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“你要把另一只公绵羊也牵来，亚伦和他儿子们要按手在这公绵羊的头上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","你要宰杀这公绵羊，取些血，抹在亚伦的右耳垂上，以及他儿子们的右耳垂上，又抹在他们右手的大拇指上，和他们右脚的大拇趾上；并且要把血洒在祭坛的周围。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","你要从坛上取一点血，也取一点膏油，弹在亚伦身上和他的衣服上，并且要弹在他儿子的身上和他们的衣服上。这样，他和他的衣服，他儿子和他们的衣服就都一同成圣。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","你要从这公绵羊身上取出脂油和肥尾巴，遮盖内脏的脂油和肝叶、两个腰子和腰子上的脂油，以及右腿，因为这是授圣职的时候，所要献的公绵羊， ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","你要从摆在耶和华面前载无酵饼的篮子里取一个圆饼、一个油饼和一个薄饼。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","你要把这一切都放在亚伦和他儿子的手上；你要在耶和华面前把他们摇动作摇祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","你要从他们手中接过来，向着祭坛把这些东西烧在燔祭之上，在耶和华面前作馨香之气，这是献给耶和华的火祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","“你要取亚伦授圣职的时候，所献的公绵羊的胸，在耶和华面前把它摇动作摇祭，这就是你的分。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","那作摇祭的胸和举祭的腿，你都要使它们成圣，就是亚伦和他儿子授圣职的时候，所献的公绵羊，被摇过被举过的部分。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","这要作为亚伦和他儿子们从以色列人所得的分，作为永远的定例，因为这是举祭。这举祭要从以色列人的平安祭中分别出来，归给耶和华作举祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“亚伦的圣衣要传给他的子孙，要穿着受膏，也要穿着受圣职。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","亚伦的子孙中，凡是接替他作祭司的，每逢进入会幕在圣所里事奉的时候，都要穿圣衣七天。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“你要把授圣职的时候所献的公绵羊取来，在圣洁的地方烧它的肉。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","亚伦和他的儿子要在会幕的门口吃这公绵羊的肉和篮子里的饼。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","他们要吃那些用来赎罪的东西，好使他们可以接受圣职，可以成圣；只是外人不可吃，因为这些东西是圣物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","授圣职的时候所献的肉和饼，如果有一点留到早晨，你要把留下的用火烧了，不可吃，因为这是圣物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“这样，你要照我吩咐你的，向亚伦和他的儿子行接受圣职的礼七天。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","你要每天献公牛一头作赎罪祭，用来赎罪；你为祭坛行赎罪祭的时候，你要洁净祭坛。而且你要用膏抹祭坛，使祭坛成圣。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","你要为祭坛行赎罪祭七天，也要使它成圣，这样，祭坛就成为至圣；一切触着祭坛的东西，都要成圣。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“这就是你要献在祭坛的：每天两只一岁的羊羔。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","第一只羊你要在早晨献上；第二只在傍晚的时候献上， ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","和这一只羊同献的，要用一公斤细面与一公升榨成的油混和，又要用一公升酒作奠祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","那另一只羊你要在傍晚的时候献上，照着早晨的素祭和它的奠祭一样办理，作馨香之气，作献给耶和华的火祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","这要作你们世世代代常献的燔祭，献在会幕的门口，耶和华的面前，我要在那里与你们相会，在那里和你们说话。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","我要在那里与以色列人相会，会幕就会因我的荣耀被尊为圣。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","我要使会幕和祭坛成圣，也要使亚伦和他的儿子成圣，作祭司事奉我。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","我要住在以色列人中间，我也要作他们的　神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","他们必知道我是耶和华他们的　神，就是从埃及地把他们领出来的，为要住在他们中间。我是耶和华他们的　神。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“你要做一座烧香的坛，你要用皂荚木做这座坛。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","坛要四方的：长四十五公分，宽四十五公分，高九十公分。坛的四角要与坛接连在一起。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","你要用纯金把坛包裹，坛顶、坛的四边和坛的四角都要包裹，你要给坛的四围做金牙边。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","在坛的两旁金牙边以下你要做两个金环，两边都有，用来穿木杠的地方，以便抬坛。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","你要用皂荚木做木杠，要用金把它们包裹。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","你要把坛放在法柜前面的幔幕前，面对着法柜上的施恩座，就是我与你相会的地方。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","亚伦要在坛上烧香料做的香，每天早晨整理灯的时候，要烧这香。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","傍晚，亚伦点灯的时候，也要烧这香，在耶和华面前作你们世世代代不断的香。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","在这坛上，你们不可献上凡香、燔祭、素祭，也不可在这坛上浇奠祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","亚伦每年一次要在坛的四角上行赎罪礼，每一次他都要用赎罪祭牲的血在坛上行赎罪礼；你们世世代代都要这样行，这坛要归耶和华为至圣。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“你要照着以色列人被数点的数目登记人数；你数点的时候，他们各人要为自己的性命把赎价归给耶和华，免得你数点的时候，他们中间有灾病。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","以下就是他们当缴纳的；凡是属于那些被数点的人的，每人要照着圣所的标准献银子六克；这六克银子是归给耶和华的礼物。这重量是圣所用的标准重量（“这重量是圣所用的标准重量”原文作“一舍客勒是二十季拉”）。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","凡是属于那些被数点的人，自二十岁以上的，要把礼物献给耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","富有的人不可多出，贫穷的也不可少出。各人要纳六克银子，作礼物献给耶和华，好为你们的性命作赎价。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","你要从以色列人收取这赎银，指定作会幕事奉的使用，好使它在耶和华面前为以色列人作个记念，也赎回你们的性命。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“你要做一个铜盆和一个铜座，用来洗濯。你要把盆放在会幕和祭坛之间，并且要把水放在盆中。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","亚伦和他的儿子要在盆里洗手洗脚。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","他们进会幕的时候，或是走近祭坛敬拜，给耶和华焚烧火祭的时候，都要用水洗濯，免得死亡。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","他们要洗手洗脚，免得死亡。这要作他们永远的定例，就是作亚伦和他的后裔世世代代永远的定例。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“你要取最上等的香料，就是流质的没药六公升，香玉桂是没药的一半，就是三公斤，香昌蒲三公斤。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","玉桂皮六公斤，都要按着圣所的标准重量，又橄榄油四公斤。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","你要把这些材料制成圣膏油，就是照着香膏配制师的方法配制成的香膏，是要作为圣膏油的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","你要用这膏油抹会幕和法柜， ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","桌子和桌子的所有器具，灯台和灯台的器具，以及香坛， ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","燔祭坛和坛上的所有器具，盆和盆座； ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","你要使它们成圣，使它们成为至圣；凡是触着它们的，都要成圣。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","你也要膏抹亚伦和他的儿子，好使他们成圣，作我的祭司。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","你要告诉以色列人说：‘你们世世代代要把这油归我为圣膏油。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","不可倒在常人的身上，也不可照着这配制的分量制相似的膏油；这膏油是圣的，你们也要以它为圣。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","无论谁配制相似的膏油，或把这膏油抹在外人的身上，这人就一定要从他的族人中被剪除。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","耶和华对摩西说：“你要取芬芳的香料，就是苏合香、香锭、白松香；这芬芳的香料和纯净的乳香，各样都要分量相等。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","你要照着香膏配制师的方法，用这些加上盐调和制成香，是清净圣洁的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","你要取一部分香，把它研成碎末，放在会幕里法柜前，就是我要与你相会的地方。你们要以这香为至圣。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","你所制的香，你们不可按着它的分量为自己配制；你要以这香为圣归给耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","无论谁制香和这香相似，为要闻香的味道的，这人就一定要从他的族人中被剪除。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“看哪，犹大支派中户珥的孙子，乌利的儿子比撒列，我已经提名召他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","我也用　神的灵充满了他，使他有智慧，有聪明，有知识，有能力作各样的手工， ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","可以设计巧工，可以用金、银、铜制造各物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","又可以雕刻宝石，镶嵌宝石；可以雕刻木头，制造各样巧工。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","看哪，我已经指派但支派中亚希撒抹的儿子亚何利亚伯和他同工；所有心里有智慧的人，我也把智慧赐给他们，使他们可以作我吩咐你的一切工作， ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","就是会幕、法柜和柜上的施恩座，以及会幕中一切的器具、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","桌子和桌子上的器具，纯金的灯台和灯台上的一切器具、香坛、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","燔祭坛和坛上的一切器具、洗濯盆和盆座、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","彩衣和亚伦祭司的圣衣，以及他儿子们供祭司职分的衣服、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","膏油和圣所使用的芬芳的香，他们都要照着我吩咐你的一切去作。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“你要吩咐以色列人说：你们务要守我的安息日，因为这是你我之间世世代代的记号，使你们知道我耶和华是把你们分别为圣的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","所以你们应该守安息日，因为这是你们的圣日；凡是违反这日的，必要把他处死；凡是在这日工作的，那人必要从他的族人中被剪除。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","六日可以工作，但第七日是歇工的安息日，是归耶和华为圣的，凡是在这安息日工作的，必须把那人处死。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","所以，以色列人要守安息日，他们世世代代要遵行安息日的规例，作为永远的约。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","这是我和以色列人中间永远的记号，因为六日之内耶和华创造了天地，但第七日就歇了工休息了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","耶和华在西奈山上与摩西说完了话，就把两块法版交给他，是　神用指头写的石版。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","人民见摩西迟迟不下山，就聚集到亚伦那里去，对他说：“起来，为我们做神像可以走在我们前头领路，因为那摩西，就是把我们从埃及地领出来的那个人，我们不知道他遭遇了什么事。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","亚伦对他们说：“把你们妻子和儿女戴在耳上的金环摘下来，送来给我。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","全体人民就把他们耳上的金耳环都摘下来，送来给亚伦。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","亚伦从他们手中接过来，用雕刻的工具雕刻，铸造了一个牛像；他们就说：“以色列啊，这就是你们的神，就是把你从埃及地领出来的那位。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","亚伦看见了，就在牛像面前筑了一座祭坛，并且宣告，说：“明日是耶和华的节日。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","次日清早，人民起来，就献上了燔祭，也带来了平安祭；然后他们坐下吃喝，起来玩乐。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","耶和华对摩西说：“你下山去吧，因为你的人民，就是你从埃及地领出来的，已经败坏了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","他们很快就偏离了我吩咐他们的道路，为自己铸造了一个牛像，向它跪拜，向它献祭，说：‘以色列啊，这就是你的神，就是把你从埃及地领出来的那位。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","耶和华对摩西说：“我看这人民，真是硬着颈项的人民。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","现在，你且由得我，让我向他们发烈怒，把他们消灭；我要使你成为大国。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","摩西就恳求耶和华他的　神施恩，说：“耶和华啊，你为什么向你的人民发烈怒呢？这人民是你用大能和全能的手从埃及地领出来的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","为什么让埃及人议论，说：‘把他们领出来是出于恶意的，要在山上杀死他们，在地上消灭他们’呢？求你回心转意，不发烈怒；求你改变初衷，不降祸给你的人民。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","求你记念你的仆人亚伯拉罕、以撒、雅各；你曾经指着自己向他们起誓，说：‘我必使你的后裔增多，好像天上的星一样；我必把我应许的这全地赐给你的后裔，他们必永远承受这地作产业。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","于是，耶和华改变初衷，不把他所说的祸降在他的人民身上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","摩西转身，从山上下来，手里拿着两块法版；法版是两面写的，这面和那面都写着字。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","法版是　神的工作，字是　神写的，刻在法版上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","约书亚听见人民呼喊的声音的时候，就对摩西说：“营里有战争的声音。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","摩西回答：“这不是战胜的呼声，也不是战败的呼声；我听见的是歌唱的声音。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","摩西走近营前的时候，看见了那牛犊，又看见了有人唱歌跳舞，他就发烈怒，把两块法版从他的手中摔掉，在山下把它们摔碎了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","又把他们所做的那牛犊拿过来，用火焚烧，磨到粉碎，撒在水面上，让以色列人喝。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","摩西对亚伦说：“这人民向你作了什么，你竟使他们陷在大罪里呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","亚伦回答：“求我主不要发烈怒，你知道这人民倾向罪恶。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","他们对我说：‘给我们做神像，可以在我们前面引路，因为那摩西，就是把我们从埃及地领出来的那个人，我们不知道他遭遇了什么事。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","我对他们说：‘凡是有金子的，都可以摘下来’，他们就给了我；我把它丢在火里，这牛犊就出来了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","摩西看见人民放肆原来是亚伦纵容他们，使他们成为那些起来与他们为敌的人的笑柄， ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","就站在营门中，说：“凡是属耶和华的，都可以到我这里来。”于是，所有利未的子孙都到他那里聚集。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","摩西对他们说：“耶和华以色列的　神这样说：‘你们各人要把自己的剑佩在大腿上，在营中往来行走，从这门到那门；你们各人要杀自己的兄弟、邻舍和亲人。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","利未的子孙照着摩西的话作了；那一天，人民中被杀的约有三千人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","摩西说：“今天你们要奉献自己归耶和华为圣，因为各人牺牲了自己的儿子和兄弟，好使耶和华今天赐福给你们。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","第二天，摩西对人民说：“你们犯了大罪，现在我要上耶和华那里去，或者我可以为你们赎罪。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","于是，摩西回到耶和华那里，说：“唉，这人民犯了大罪，为自己做了金神像。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","现在，如果你肯赦免他们的罪，那就好了；如果不肯，求你从你所写的册上把我涂抹吧。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","耶和华对摩西说：“谁得罪了我，我就要从我的册上把谁涂抹。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","现在你去吧，领这人民到我吩咐你的地方去。看哪，我的使者必在你前面引路；只是在我追讨的日子，我必追讨他们的罪。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","耶和华击杀人民是因为他们敬拜亚伦做的牛犊。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","耶和华对摩西说：“你和你从埃及地领出来的人民要离开这里，上我曾经起誓应许给亚伯拉罕、以撒、雅各的地去，我曾应许：‘我要把这地赐给你的后裔。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","我要差派使者在你前面；我要把迦南人、亚摩利人、赫人、比利洗人、希未人、耶布斯人赶出去， ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","你们要上那流奶与蜜的地方去；我不与你们一同上去，因为你们是硬着颈项的人民，免得我在路上把你们消灭。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","人民一听见这凶信，就悲伤起来，也没有人穿戴装饰。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","耶和华对摩西说：“你要对以色列人说：‘你们是硬着颈项的民；我若是霎时间与你们同行，我会把你们消灭的；所以，现在你们要把你们身上的装饰脱下来，使我知道我要怎样处置你们。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","于是，以色列人从何烈山以后，就把身上的装饰脱下来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","摩西一向把会幕支搭在营外，离营远些；摩西称它为会幕。凡是寻求耶和华的，就出到营外的会幕那里去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","摩西出营到会幕去的时候，全体的人民都起来，各人站在自己帐幕的门口，望着摩西，直到他进了会幕。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","摩西进会幕的时候，就有云柱降下来，停在会幕门口上面；耶和华就与摩西谈话。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","全体的人民看见了云柱停在会幕门口上面，就都起来，各人在自己帐幕的门口下拜。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","耶和华与摩西面对面说话，好像人对朋友说话一样。然后，摩西回到营里去，只有他的侍从，一个少年人，就是嫩的儿子约书亚，不离开会幕。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","摩西对耶和华说：“看，你吩咐我说：‘把这百姓领上去’，可是你却没有让我知道你要差派谁与我同去；只是你曾经说过：‘我按着你的名字认识你，你在我眼前也蒙了恩。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","现在我若是在你眼前蒙恩，求你把你的道路指示我，使我可以认识你，可以在你眼前蒙恩；也求你想到这民族是你的人民。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","耶和华说：“我必亲自与你同去，也必给你安息。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","摩西对他说：“你若是不亲自与我们同去，就不要把我们从这里领上去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","人在什么事上可以知道我和你的人民在你眼前蒙恩呢？不是因为你与我们同去，使我和你的人民可以和地上所有的人有分别吗？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","耶和华对摩西说：“你所说的这件事我也要作，因为你在我眼前蒙恩，并且我按着你的名字认识了你。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","摩西说：“求你给我看看你的荣耀。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","耶和华说：“我要使我的一切美善都在你面前经过，并且要把我的名字耶和华在你面前宣告出来；我要恩待谁，就恩待谁；我要怜悯谁，就怜悯谁。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","他又说：“你不能看我的脸，因为没有人看见了我还能活着。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","耶和华说：“看哪，我这里有个地方，你要站在磐石上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","我的荣耀经过的时候，我要把你放在磐石隙中，我要用我的手掌遮盖你，直到我过去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","然后，我要收回我的手掌，你就会看见我的背后，却不能看见我的脸。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","耶和华对摩西说：“你要凿出两块石版，好像先前的一样，我要把先前写在你摔碎了的石版上的字写在这两块石版上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","早晨之前，你要预备好了；到早晨的时候，你要上到西奈山来，在山顶上站在我面前。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","谁也不准同你一起上来，整个山都不准有人出现，也不准牛羊在这山前吃草。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","摩西就凿了两块石版，好像先前的一样。他一早起来，照着耶和华吩咐他的，上到西奈山去，手里拿着两块石版。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","耶和华在云彩中降下来，与摩西一同站在那里，并且宣告耶和华的名字。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","耶和华在摩西面前经过，并且宣告说：“耶和华，耶和华，是有怜悯有恩典的　神，不轻易发怒，并且有丰盛的慈爱和诚实， ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","为千千万万人留下慈爱，赦免罪孽、过犯和罪恶。一定要清除罪，追讨罪孽自父及子至孙，直到三四代。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","摩西急忙俯首在地敬拜， ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","说：“主啊，我若是在你眼前蒙恩，求我主与我们同行，因为这是硬着颈项的人民。又求你赦免我们的罪孽和我们的罪恶，把我们当作你的产业。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","耶和华说：“看哪，我要立约，我要在你全体的人民面前作奇妙的事，是在全地万国中没有行过的。在你四周的万民都必看见耶和华的作为，因为我向你所行的是可畏惧的事。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","我今天吩咐你的，你务要遵守。看哪，我要把亚摩利人、迦南人、赫人、比利洗人、希未人、耶布斯人，从你面前赶逐出去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","你要小心，不可与你所去的那地的居民立约，恐怕这事在你中间成为陷阱。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","他们的祭坛你们却要拆毁，他们的柱像你们要打碎，他们的亚舍拉你们要砍下。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","你不可敬拜别的神，因为耶和华是忌邪的　神，他名为忌邪者。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","恐怕你与那地的居民立约，他们随从自己的神行邪淫，给自己的神献祭的时候，有人叫你，你就吃他的祭物； ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","又恐怕你给你的儿子娶他们的女儿为妻，他们的女儿随从自己的神行邪淫的时候，使你的儿子也随从她们的神行邪淫。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","你不可为自己铸造神像。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“你要守除酵节，要照着我吩咐你的，在亚笔月内所定的时期吃无酵饼七天，因为你是在亚笔月从埃及出来的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","凡是头胎的都是我的；你的牲畜中，无论是牛或羊，凡是公的和头生的，都是我的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","头生的驴，你要用羊代赎，如果不代赎，就要打断它的颈项。你所有头胎的儿子，你都要代赎出来。没有人可以空手见我。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“你六日要工作，但第七天你要休息，在耕种和收割的时候，也要休息。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","在收割初熟麦子的时候，你要守七七节；在年底，你要过收割节。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","你所有的男子，都要一年三次去见主耶和华以色列的　神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","我要把列国从你面前赶出去，扩张你的境界；你一年三次上去面见耶和华你的　神的时候，必没有人贪图你的地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“你不可把我祭物的血和有酵的饼一同献上，逾越节的祭物也不可留到早晨。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","你要把你地里最早生产的初熟之物送到耶和华你的　神的殿里。不可用羊羔母的奶去煮羊羔。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","耶和华对摩西说：“你要把这些话写上，因为我是按着这些话与你和以色列人立约的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","摩西在那里与耶和华在一起共四十昼夜，不吃饭，也不喝水。他把这约的话写在两块版上，这就是十诫。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","摩西从西奈山下来的时候，手里拿着两块法版；摩西从山上下来的时候，不知道自己的脸皮因为与耶和华谈过话而发光。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","亚伦和全体以色列人看见了摩西，见他脸上发光，就害怕接近他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","摩西叫他们过来，于是，亚伦和会众中所有的首领才回到摩西那里去，摩西就与他们谈话。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","以后，全体以色列人都近前来，摩西就把耶和华在西奈山上与他所说的一切话都吩咐他们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","摩西和他们说完了话，就用帕子蒙上自己的脸。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","每逢摩西进到耶和华面前与他谈话的时候，就把帕子揭去，直到他出来。他出来了，就把耶和华吩咐他的对以色列人说。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","以色列人看见摩西的脸，见他的脸皮发光。摩西再用帕子蒙上自己的脸，直到他进去和耶和华说话为止。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","摩西召集了以色列全体会众，对他们说：“这就是耶和华吩咐的话，要你们遵行。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","六日要工作，但第七日是你们的圣日，要归耶和华为休息的安息日。凡是在这日工作的，必须把他处死。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","在安息日，不可在你们任何的住处生火。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","摩西告诉以色列全体会众说：“耶和华吩咐的是这样，他说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","‘你们要从你们中间拿礼物来给耶和华，凡是甘心乐意的，都可以把耶和华的礼物带来，就是金、银、铜、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","蓝色紫色朱红色线、细麻、山羊毛、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","染红的公羊皮、海狗皮、皂荚木、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","灯油，以及作膏油和芬芳的香的香料、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","红玛瑙宝石，以及可以镶嵌在以弗得和胸牌上的宝石。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“‘你们中间凡是心里有智慧的都要来，做耶和华吩咐的一切， ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","就是做帐幕、帐幕的棚罩、帐幕的盖、钩子、木板、横闩、柱子、帐幕的座、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","柜、柜杠、施恩座、遮盖至圣所的幔子、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","桌子、桌子的杠、桌子的一切器具、陈设饼、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","灯台、灯台的器具、灯盏、灯油、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","香坛、香坛的杠、膏油、芬芳的香、帐幕门口的门帘、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","燔祭坛、坛的铜网、坛杠、坛的一切器具、洗濯盆、盆座、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","院子的帷子、帷子的柱子、帷子的座、院子的门帘、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","帐幕的钉子、院子的钉子，以及这两处的绳子、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","在圣所供职用的彩衣、祭司亚伦的圣衣和他儿子供祭司职用的衣服。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","以色列全体会众从摩西面前离去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","凡是心里受感、灵里乐意的，都来了；他们把耶和华的礼物都带来了，用作会幕的工程和会幕中的一切使用，又用来做圣衣。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","凡是甘心乐意的，不论男女，都来了，把金针、耳环、戒指、手钏和各样的金器都送来。他们各人都把金子作礼物呈献给耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","凡是有蓝色紫色朱红色线、细麻、山羊毛、染红的公羊皮、海狗皮的，都送了来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","凡是奉献银子和铜为礼物的，都带了来作耶和华的礼物；凡是有皂荚木可以用作工程上任何使用的，都带了来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","凡是心中有智慧的妇女都亲手纺织，把所纺的蓝色紫色朱红色线都带了来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","凡是有心意又有智慧的妇女，都纺山羊毛。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","首领把红玛瑙宝石，以及可以镶嵌在以弗得和胸牌上的宝石都带了来； ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","又带来了香料、点灯用的油、膏油、芬芳的香。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","以色列人无论男女，凡是甘心乐意为作耶和华借摩西吩咐的一切工程的，都把自愿奉献的礼物带了来献给耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","摩西对以色列人说：“看哪，犹大支派中户珥的孙子、乌利的儿子比撒列，耶和华已经提名召他， ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","又用　神的灵充满他，使他有智慧，有聪明，有知识，有作一切巧工的技能。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","能巧设图案，用金、银、铜制造各物； ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","又能雕刻宝石，用来镶嵌；又能雕刻木头，用来制造各种巧工。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","耶和华又赐给他和但支派中亚希撒抹的儿子亚何利亚伯，心里有教导人的恩赐。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","耶和华又用智慧充满他们的心，使他们能作各种工作，雕刻的工，设图案的工，用蓝色紫色朱红色线和细麻刺绣的工，以及编织的工。他们能作各种工程，也能巧设图案。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","比撒列和亚何利亚伯，以及心里有智慧的，就是蒙耶和华赐与智慧与聪明，使他们知道怎样制造供圣所使用的一切工程的人，都照着耶和华吩咐的一切去作。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","于是，摩西把比撒列和亚何利亚伯，以及心里有智慧的，就是蒙耶和华赐他们心里有智慧的人，凡是心里受感要前来作这工的人，都召了来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","他们当着摩西面前，接收了以色列人为供圣所使用的工程带来的一切礼物。他们天天早晨还把自愿奉献的礼物带到摩西那里来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","凡是作圣所一切工的智慧人，各人都放下自己所作的工，来了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","他们告诉摩西：“人民带来的太多，超过耶和华吩咐所作工程使用的需要。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","于是摩西下令，他们就在营中宣告，说：“无论男女都不必再为圣所的工程奉献什么礼物。”这样，人民才被拦阻，不送什么礼物来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","因为所有的材料够作一切工程，而且有余。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","在作这工程的人中，凡是心里有智慧的，用十幅幔子作帐幕；这些幔子是用捻的细麻、蓝色紫色朱红色线做的，并且用设计的巧工绣上基路伯。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","每一幅幔子长十二公尺，每一幅幔子宽两公尺，所有的幔子都是一样的尺寸。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","他把五幅幔子一一相连；也使另外五幅幔子一一相连。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","在第一组相连的幔子末幅的边缘上，他做蓝色的钮扣；在另一组相连的幔子末幅的边缘上，他也照样作。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","在这一幅幔子上，他做了五十个钮扣；在第二幅相连的幔子的边缘上，他也做了五十个钮扣，这些钮扣都彼此相对。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","又做了五十个金钩，用钩子使幔子彼此相连。这样就成了一个帐幕。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","他又用山羊毛做了幔子，作为帐幕上的罩棚，共做了十一幅幔子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","每一幅幔子长十三公尺，宽两公尺，十一幅幔子都是一样的尺寸。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","他把五幅幔子相连在一起，又把另外六幅幔子相连在一起。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","在第一组相连的幔子末幅的边缘上，做了五十个钮扣；在第二组相连的幔子末幅的边缘上，也做了五十个钮扣。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","又做了五十个铜钩，使罩棚相连，可以成为一个。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","用染红的公羊皮做了罩棚的盖，又用海狗皮做盖，放在罩棚的盖上面。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","他替帐幕用皂荚木做了竖板。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","每块板长四公尺，宽六十六公分。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","每块板有两个榫头，彼此相连接；帐幕一切木板，他都这样做。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","他为帐幕做板，给南边，就是向南的方向做了二十块板。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","在这二十块板底下，做了四十个银座；这块板底下的两个银座用来连接板的两个榫头，那块板底下的两个银座用来连接它的两个榫头。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","他为帐幕的第二边，就是北面，也做了二十块板， ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","和四十个银座；这一块板底下有两个银座，那一块板底下也有两个银座。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","帐幕的后面，就是西面，做了六块板。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","他替帐幕后面两个角上做了两块板。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","板的下截是双的，直到上面的第一个环才接合完整；他把两块板都这样做了，形成两个角。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","所以共有八块板，十六个银座。每一块板底下都有两个银座。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","他又用皂荚木做了横闩，替帐幕这一边的板做了五个横闩， ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","替帐幕第二边的板也做了五个横闩，替帐幕后面，就是西面的板也做了五个横闩， ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","他又做了中间的横闩，穿过板腰，从这一端穿到那一端。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","他用金子把板包裹，也做了板上的金环，用作穿横闩的地方，并且也用金子把横闩包裹。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","他用蓝色紫色朱红色线和捻的细麻做了一幅幔幕，用巧设的图案手工绣上基路伯。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","他替幔幕做了四根皂荚木柱子，用金子包裹，柱钉是金的，又替柱子铸造四个银座。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","又用蓝色紫色朱红色线和捻的细麻，用绣花的手工做成帐幕的门帘； ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","又为门帘做了五根柱子和柱子上的钉子，用金子把柱顶和横杆包裹。但那五个座是铜的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","比撒列用皂荚木做了一个柜，长一百一十公分，宽六十六公分，高六十六公分， ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","用纯金把柜里外都包裹了，替柜的四周做了金牙边， ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","又铸造了四个金环，安放在柜的四脚上，这一边两个环，那一边两个环。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","又用皂荚木做了两根柜杠，包上黄金。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","把杠穿在柜旁的环内，可以抬柜。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","又用纯金做施恩座，长一百一十公分，宽六十六公分。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","又用黄金做了两个基路伯，是从施恩座的两端用锤锤成的； ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","这端一个基路伯，那端一个基路伯；他在施恩座的两端做了两个基路伯，和施恩座连在一起。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","两个基路伯高展着翅膀，用它们的翅膀遮掩着施恩座，它们的脸彼此相对；基路伯的脸都对着施恩座。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","他又用皂荚木做了一张桌子，长八十八公分，宽四十四公分，高六十六公分。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","用纯金把桌子包裹，替桌子的四周做了金牙边。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","又替桌子的四周做了七十五公厘宽的框子；框子的四周又做了金牙边。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","又替桌子铸造四个金环，把环子安放在桌子四脚的四角上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","环子靠近框子，是穿杠的地方，可以抬桌子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","又用皂荚木做了两根杠，用金子把杠包裹，可以抬桌子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","又用纯金做桌子的器皿，就是盘子、碟子、碗和奠酒用的杯。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","他用纯金做了一个灯台，他用锤锤成灯台；灯台的座和干，跟杯、球、花，都是连在一起的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","灯台的两边伸出六个枝子，这一边有三个灯台枝子，那一边也有三个灯台枝子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","在这一个枝子有三个杯，形状好像杏花，有球、有花；在那一个枝子上也有三个杯，形状好像杏花，有球、有花。从灯台那里伸出来的六个枝子都是这样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","灯台上有四个杯，形状好像杏花，有球、有花； ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","从灯台伸出的每两个枝子以下都有一个球，灯台的六个枝子都是这样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","这些球和枝子都是连在一起的，全都是一块纯金锤成的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","又用纯金做灯台的七个灯盏、烛剪和蜡花盘碟。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","他用了三十五公斤纯金做灯台和灯台的一切器具。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","他用皂荚木做了一座香坛，长四十四公分，宽四十四公分，是正方形的，高八十八公分；坛的四角是与坛连在一起的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","又用纯金把坛包裹，坛顶、坛的四边和坛的四角都包裹，又替坛做了金牙边。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","又替坛做了两个金环，安放在牙边以下，坛的两侧，就是坛的两旁，作穿杠的地方，用来抬坛。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","用皂荚木做了两根杠，用金包裹。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","又按着制香料者的制法，制圣膏油以及芬芳的纯香。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","他用皂荚木做燔祭坛，长两公尺两公寸，宽两公尺两公寸，成正方形，高一公尺三公寸。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","在坛的四个拐角做了四只角，角是与坛连在一起的；又用铜把坛包裹。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","又做坛上的一切器具，就是盆、铲、盘、肉叉和火盆；坛上的一切器具都是用铜做的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","又替坛做一个铜网，放在坛的围腰板以下，向下直到坛的半腰。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","又铸造四个环，放在铜网的四端之上，用作抬坛的地方。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","他用皂荚木做两根杠，用铜包裹， ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","把杠穿在坛两侧的环里，用来抬坛；坛是用木板做的，是空的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","他用铜做洗濯盆，又用铜做盆座，是用那些在会幕门口服事的妇女的铜镜做成的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","他又做院子；南面，就是向南的方向，用捻的细麻做院子的幔幕，共四十四公尺。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","幔幕的柱子有二十根，柱座有二十个，是铜做的；柱钩和横柱闩是银做的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","北面，有幔幕四十四公尺，幔幕的柱子有二十根，柱座有二十个，是铜做的；柱钩和横柱闩是银做的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","西面，有幔幕二十二公尺，幔幕的柱子有十根，柱座有十个；柱钩和横柱闩是银做的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","东面，就是日出的方向，有幔幕二十二公尺。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","门口这一边有幔幕六公尺六公寸；幔幕的柱子有三根，柱座有三个。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","门口那一边也是这样。院子门口的两边各有幔幕六公尺六公寸；幔幕的柱子有三根，柱座有三个。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","院子周围的一切幔幕都是用捻的细麻做的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","柱座是铜做的，柱钩和横柱闩是银做的，柱顶是用银包裹的；院子的一切柱子都是用银横闩相连起来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","院子的门帘，是用蓝色紫色朱红色线和捻的细麻，以及刺绣的手工做成的；长九公尺，以宽度来说，两公尺高，与院子的幔幕相配。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","幔幕的柱子有四根，柱座有四个，是铜做的；柱钩是银做的，柱顶和横柱闩是用银包裹的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","帐幕的一切钉子和院子四周的一切钉子，都是铜做的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","这是帐幕（就是法柜的帐幕）内利未人使用的物件的总数，是照着摩西的吩咐，经亚伦祭司的儿子以他玛的手计算的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","凡是耶和华吩咐摩西的，犹大支派户珥的孙子、乌利的儿子比撒列都做了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","与他同工的，有但支派亚希撒抹的儿子亚何利亚伯，是个雕刻匠、图案设计家，以及能用蓝色紫色朱红色线和细麻刺绣的人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","用来建造圣所整个工程使用的一切黄金，就是献作礼物的金子，按照圣所的标准，共有一千公斤。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","会众中被数点的人所出的银子，按照圣所的标准，共有三千四百三十公斤。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","凡是按着次序被数点的人，从二十岁以上的，有六十万三千五百五十人，按着圣所的标准，每人纳银六克。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","他用这三千四百公斤银子铸造圣所的柱座，和幔子的柱座；一百个柱座用了三千四百公斤银子，三十四公斤银子做一个柱座。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","他用三十公斤银子做柱钩，包裹柱顶，以及为柱顶做横柱闩。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","献作礼物的铜有二千四百二十五公斤。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","他用这些铜做会幕门口的柱座、铜坛和坛上的铜网，以及坛上的一切器具、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","院子四周的柱座、院子门口的柱座、帐幕的一切钉子和院子四周的一切钉子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","他们用蓝色紫色朱红色线做彩衣，在圣所供职时穿着；又照着耶和华吩咐摩西的，为亚伦做圣衣。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","又用金线、蓝色紫色朱红色线和捻的细麻做以弗得。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","他们把金子锤成薄片，剪成细线，用巧工织在蓝色紫色朱红色线和细麻之中。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","又为以弗得做相连的肩带，把以弗得的两端连接起来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","上面的带子，做法好像以弗得一样，与以弗得连在一起，都用金线、蓝色紫色朱红色线和捻的细麻做的，是照着耶和华吩咐摩西的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","他们预备了两块红玛瑙宝石，镶嵌在金槽里，又用刻图章的方法刻上以色列众子的名字， ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","把这两块宝石放在以弗得的两条肩带上，作以色列人的记念石，是照着耶和华吩咐摩西的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","他又用巧设的图案手工做胸牌，像做以弗得一样，用金线、蓝色紫色朱红色线和捻的细麻做的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","胸牌是正方形的；他们把胸牌做成双层，长二十二公分，宽二十二公分，是双层的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","又把四行宝石镶在上面，一行是红宝石、黄玉、翡翠，这是第一行。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","第二行是紫宝石、蓝宝石、金钢石。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","第三行是黄玛瑙、白玛瑙、紫晶。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","第四行是水苍玉、红玛瑙、碧玉；这些宝石都是镶在金槽里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","这些宝石代表以色列众子的名字，共有十二块；用刻图章的方法，每块刻上一个名字，十二块代表十二个支派。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","又在胸牌上用纯金做链子，像拧绳子一般做成。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","又做两个金槽和两个金环，把两个金环安放在胸牌的两端， ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","把那两条金绳穿在胸牌两端的环子里； ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","又把金绳的另两端接在两槽上，再把它们连在以弗得前面的肩带上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","他又做两个金环，安放在胸牌的两端，在胸牌的两边，就是在以弗得里面的边上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","他又做两个金环，安放在以弗得前面两条肩带的下边，靠近相连的地方，在以巧工做成的以弗得的肩带上面。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","他们用蓝色细带子把胸牌系住，就是把胸牌的环子和以弗得的环子系在一起，使胸牌可以贴在以巧工织成的以弗得的带子上，免得胸牌从以弗得上脱落，这是照着耶和华吩咐摩西的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","又做以弗得的外袍，是织成的，全件是蓝色的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","在外袍的中间有一领口，如同战袍的领口，领口的周围有领边，免得领口破裂。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","又在外袍的底边上，用蓝色紫色朱红色线和捻的细麻做石榴。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","他又用纯金做铃铛，把金铃安放在石榴中间，就是安放在外袍周围底边上的石榴中间： ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","一个金铃，一个石榴，一个金铃，一个石榴，在外袍周围的底边上，在供职时穿用；都是照着耶和华吩咐摩西的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","他又用织成的细麻布替亚伦和他的儿子做内袍， ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","并且用细麻做礼冠，用细麻做头巾，用捻的细麻做细麻布裤子， ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","以及用捻的细麻和蓝色紫色朱红色线，用刺绣的手工做腰带；都是照着耶和华吩咐摩西的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","他们用纯金做圣冠上的牌子，又用刻图章的方法，在上面刻着“归耶和华为圣”的字样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","又用一条蓝色细带子把牌子系住，系在礼冠的上面，都是照着耶和华吩咐摩西的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","于是，帐幕，就是会幕的一切工程都完成了；凡是耶和华吩咐摩西的，以色列人都照着作了；这样，他们就作完了会幕的一切工程。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","他们把帐幕、会幕和会幕的一切器具都带到摩西那里，就是钩子、木板、横闩、柱子、柱座、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","染红公山羊皮的盖、海狗皮的盖和遮盖至圣所的幔子、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","法柜、柜杠和施恩座， ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","桌子、桌子上的一切器具和陈设饼， ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","纯金的灯台与灯盏，就是摆列在灯台上的灯盏和灯台上的一切器具，以及点灯用的油； ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","金坛、膏油、芬芳的香和会幕的门帘； ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","铜坛、坛上的铜网、坛杠、坛上的一切器具、洗濯盆和盆座； ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","院子的幔幕、柱子、柱座、院子的门帘、绳子、钉子和帐幕，以及会幕一切使用的器具； ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","在圣所供职用的彩衣、祭司亚伦的圣衣和他儿子供祭司职的衣服。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","这一切工作，耶和华怎样吩咐摩西，以色列人就怎样作。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","摩西查看了一切工作，见他们所作的，完全是耶和华吩咐的，就给他们祝福。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","耶和华告诉摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“正月初一日，你要把会幕的帐幕竖立起来， ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","把法柜安放在里面，用幔子把法柜遮盖。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","把桌子搬进去，摆上陈设物；把灯台也搬进去，把灯台上的灯盏点着。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","把烧香用的金坛安放在法柜前，挂上帐幕的门帘。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","把燔祭坛安放在会幕的帐幕门口。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","把洗濯盆安放在会幕和祭坛的中间，把水盛在盆里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","又在周围竖立院子的幔幕，把院子的门帘挂上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","你要拿膏油来，抹帐幕和其中的一切器具，使帐幕和帐幕的一切器具成圣，就必成圣。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","又要抹燔祭坛和坛上的一切器具，使坛成圣，坛就必成为至圣。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","要抹洗濯盆和盆座，使它成圣。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","要把亚伦和他的众子带到会幕的门口来，用水给他们洗身。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","要把圣衣给亚伦穿上，又膏抹他，使他成圣，可以作我的祭司。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","你要把亚伦的儿子带来，给他们穿上内袍。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","要膏抹他们好像膏抹他们的父亲一样，使他们可以作祭司服事我；他们的膏抹使他们世世代代永远当祭司之职。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","摩西就这样作了；凡是耶和华吩咐他的，他都作了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","第二年正月初一日，帐幕就竖立起来了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","摩西竖立起帐幕，安上柱座，放上木板，安上横闩，竖立柱子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","把罩棚铺在帐幕上面，又把罩棚的上盖放在上面；都是照着耶和华吩咐摩西的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","摩西拿了法版，放在柜里，把杠穿在柜的两旁，把施恩座安放在约柜上面。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","把约柜抬进帐幕里去，挂上遮盖至圣所的幔子，把法柜遮盖着，是照着耶和华吩咐摩西的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","又把桌子安放在会幕里，放在帐幕的北面，幔子的外面。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","在桌子上把陈设饼摆在耶和华面前，都是照着耶和华吩咐摩西的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","摩西把灯台设立在会幕里，在帐幕的南面，与桌子相对。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","在耶和华面前把灯盏点着，是照着耶和华吩咐摩西的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","把金坛安设在会幕里，幔子的前面； ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","在坛上焚烧芬芳的香，是照着耶和华吩咐摩西的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","又挂上帐幕的门帘。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","把燔祭坛安放在会幕的帐幕门口，把燔祭和素祭献在坛上；是照着耶和华吩咐摩西的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","又把洗濯盆安放在会幕与祭坛之间，盆里盛水，作洗濯之用； ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","摩西、亚伦和亚伦的儿子，可以在这盆里洗手洗脚。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","每逢他们走进会幕，或是走近祭坛的时候，就要先洗濯；是照着耶和华吩咐摩西的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","摩西在帐幕和祭坛的周围，竖立起院子的幔幕，又挂上院子的门帘。这样摩西就完成了工程。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","当时，有云彩遮盖会幕，耶和华的荣耀充满了帐幕。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","摩西不能进入会幕，因为云彩停在会幕上面，并且耶和华的荣耀充满着帐幕。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","在以色列人所有的旅程中是这样的：每逢云彩从帐幕收上去的时候，他们就起程； ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","云彩若是不收上去，他们就不起程，直到云彩收上去的日子为止。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","因为以色列人所有的旅程中，日间有耶和华的云彩在帐幕上，夜间云中有火，显在以色列全家的眼前。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","耶和华呼叫摩西，从会幕里对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“你要告诉以色列人说：如果你们中间有人把供物献给耶和华，就要从牛群羊群中献家畜为供物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","他的供物若是献牛作燔祭，就要把一头没有残疾的公牛，牵到会幕门口，就可以在耶和华面前蒙悦纳。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","他要按手在燔祭牲的头上，燔祭就蒙悦纳，可以为他赎罪。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","他要在耶和华面前宰杀那公牛，亚伦子孙作祭司的，要奉上血，泼在会幕门口祭坛的四周。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","那人要剥去燔祭牲的皮，把燔祭牲切成块子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","亚伦子孙作祭司的，要把炭火放在祭坛上，把柴排列在火上； ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","亚伦子孙作祭司的，要把肉块和头，以及脂肪，排列在祭坛炭火上的木柴上面。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","那人又要用水洗净内脏和腿；祭司就把这一切全献在祭坛上焚烧，作为燔祭，就是献给耶和华馨香的火祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“人的供物若是献羊作燔祭，不论是绵羊或是山羊，总要献一只没有残疾的公羊。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","他要在耶和华面前，在祭坛的北面，把羊宰杀；亚伦子孙作祭司的，要把羊血泼在祭坛的四周。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","那人要把燔祭牲切成块子；祭司就把肉块、头和脂肪，排列在祭坛炭火上的木柴上面； ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","那人又要用水洗净内脏和腿，祭司就把这一切全献在祭坛上焚烧，作为燔祭，就是献给耶和华馨香的火祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“人若是献鸟类为燔祭作耶和华的供物，就要献斑鸠或雏鸽。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","祭司要把鸟带到祭坛那里，扭下它的头来，焚烧在祭坛上；又把鸟血挤出来，流在祭坛的壁上； ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","又要除掉鸟的嗉囊和脏物，丢在祭坛东边，倒灰的地方。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","然后要拿着两个翅膀把鸟撕裂，只是不可撕断。祭司要把它放在祭坛，在炭火上的木柴上面焚烧，作为燔祭，就是献给耶和华馨香的火祭。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“如果有人献素祭为供物给耶和华，他的供物要用细面；他要浇上油，加上乳香， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","带到亚伦子孙作祭司的那里，祭司就从其中取出一把浇了油的细面，连同所有的乳香，作供物的象征，焚烧在祭坛上，这是献给耶和华馨香的火祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","祭余剩的，要归给亚伦和他的子孙；这是献给耶和华的火祭中至圣之物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“如果你献炉里烤的物作素祭的供物，就要用细面调油所做的无酵饼，或是抹上油的无酵薄饼。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","你的供物若是用煎盘上做的物作素祭，就要用调油的无酵细面。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","你要把它擘成碎块，浇上油；这是素祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","你若是用浅锅中煎的物作素祭的供物，就要用细面调油做成。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","你要把这些东西做好，作献给耶和华的素祭，奉给祭司，让他带到祭坛。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","祭司要从素祭中举起象征的部分，焚烧在祭坛上，作献给耶和华馨香的火祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","素祭余剩的，要归给亚伦和他的子孙；这是献给耶和华的火祭中至圣之物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“你们献给耶和华的一切素祭，都不可发酵，因为任何酵与蜜，你们都不可焚烧作献给耶和华的火祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","你们可以把它们献给耶和华作初熟的供物；只是不可烧在祭坛上，作馨香的祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","你献作素祭的一切供物，都要用盐调和；在你的素祭上，不可缺少你　神立约的盐；你的一切供物，都要用盐调和献上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“如果你把初熟之物作素祭献给耶和华，就要献上烘过的新麦穗，就是碾过的新谷粒，作素祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","你要浇上油，加上乳香，这是素祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","祭司要把供物的象征部分，就是一部分碾过的麦粒和油，连同所有的乳香，一起焚烧，作献给耶和华的火祭。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“人的供物若是作平安祭，如果献的是牛，必须在耶和华面前献一头没有残疾的公牛或母牛； ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","他要按手在他的供物的头上，在会幕门口宰杀它；亚伦子孙作祭司的，要把血泼在祭坛的四周。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","他要从平安祭中奉上献给耶和华的火祭，就是把遮盖内脏的脂肪，和内脏上的一切脂肪， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","两肾和肾上近腰旁的脂肪，和肾旁的肝叶，一起取下。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","亚伦的子孙要把这些放在祭坛炭火上的木柴上面，在燔祭上焚烧，作献给耶和华馨香的火祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","人若是献羊作平安祭的供物给耶和华，必须献一只没有残疾的公羊或母羊。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","他献的供物若是一只绵羊羔，他要把它牵到耶和华面前， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","按手在他的供物的头上，在会幕门口宰杀它；亚伦的子孙要把羊血泼在祭坛的四周。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","他要从平安祭中奉上献给耶和华的火祭，就是把羊的脂肪，从靠近脊骨的地方取下来的整条肥尾巴，遮盖内脏的脂肪和在内脏上的一切脂肪， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","两肾和肾上近腰的脂肪，和肾旁的肝叶，一起取下。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","祭司把这些焚烧在祭坛上，是献给耶和华作食物的火祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“人的供物若是一只山羊，就要把羊牵到耶和华面前， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","按手在羊头上，然后在会幕门口宰杀它；亚伦的子孙要把血泼在祭坛的四周， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","他要从供物中奉上献给耶和华的火祭，就是把遮盖内脏的脂肪和内脏上的脂肪， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","两肾和肾上近腰的脂肪，和肾旁的肝叶，都要一起取下。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","祭司把这些焚烧在祭坛上，献给耶和华为食物作馨香的火祭。一切脂肪都是属于耶和华的， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","任何脂肪和血你们都不可吃。这是你们在一切住处一条世代永存的律例。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“你要告诉以色列人说：如果有人在耶和华吩咐不可行的事上无意犯了罪，他必须遵行以下条例中的一样： ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“如果受膏的祭司犯了罪，使人民陷在罪里，他就要为自己所犯的罪，献一头没有残疾的公牛给耶和华作赎罪祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","他要把公牛牵到耶和华面前，在会幕门口，按手在公牛头上，然后在耶和华面前宰杀那公牛， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","受膏的祭司要取一些公牛的血，带到会幕那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","祭司要把指头蘸在血里，在耶和华面前向着圣所的幔子，弹血七次。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","然后祭司要用血抹会幕里耶和华面前的香坛的四角；至于其余的牛血，都要倒在会幕门口的燔祭坛脚那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","他要取出赎罪祭的公牛所有的脂肪，就是遮盖内脏的脂肪和内脏上的一切脂肪， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","两肾和肾上近腰的脂肪，和肾旁的肝叶，都一起取下来， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","正如从平安祭的公牛取出来的一样。祭司要把这些焚烧在燔祭坛上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","至于公牛的皮和所有的肉，连头带腿，以及内脏和粪， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","就是整头公牛，要搬到营外洁净的地方，倒坛灰的地方，放在柴上用火焚烧，就在倒坛灰的地方焚烧。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“如果以色列全体会众无意犯罪，是隐而未现、会众看不出来的，但他们行了一件耶和华吩咐不可行的事，他们就有罪。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","当发觉他们犯了罪的时候，会众就要献一头公牛作赎罪祭，把它牵到会幕前面； ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","会众的长老要在耶和华面前按手在公牛的头上，然后在耶和华面前宰杀那公牛。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","受膏的祭司要把公牛的一些血，带到会幕那里； ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","祭司要把指头蘸在血里，在耶和华面前，向着幔子，弹血七次； ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","然后用血抹会幕里耶和华面前的坛角；至于其余的牛血，都要倒在会幕门口的燔祭坛脚那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","他要取出公牛所有的脂肪，焚烧在祭坛上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","处理这公牛与处理大祭司的赎罪祭公牛一样，要按同一条例执行。祭司为他们赎了罪，他们就蒙赦免。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","他要把这公牛搬到营外焚烧，好像焚烧前一头公牛一样，这是会众的赎罪祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“如果领袖无意犯了罪，行了一件耶和华他的　神吩咐不可行的事，他就有罪。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","他一发觉犯了罪，就要牵一只没有残疾的公山羊羔作供物， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","要按手在山羊的头上，然后在宰燔祭牲的地方，在耶和华面前宰杀它，这是赎罪祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","祭司要用指头取赎罪祭牲的一些血，抹燔祭坛的四角，其余的血要倒在燔祭坛脚那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","公羊所有的脂肪，都要焚烧在祭坛上，好像平安祭的脂肪一样；祭司为他赎了罪，他就蒙赦免。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“如果那地的居民中有人无意犯了罪，行了一件耶和华吩咐不可行的事，他就有罪。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","他一发觉犯了罪，就要为自己所犯的罪，牵一只没有残疾的母山羊作供物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","他要按手在赎罪祭牲的头上，然后在宰燔祭牲的地方，宰杀赎罪祭牲。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","祭司要用指头取一些羊血，抹燔祭坛的四角，其余的血都要倒在祭坛脚那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","母山羊所有的脂肪都要取出来，好像取出平安祭牲的脂肪一样；然后祭司要把这些焚烧在祭坛上，献给耶和华作馨香的祭。祭司为他赎了罪，他就蒙赦免。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“如果人献一只绵羊羔作赎罪祭的供物，就要牵一只没有残疾的母羊； ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","他要按手在赎罪祭牲的头上，然后在宰燔祭牲的地方宰杀它，作为赎罪祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","祭司要用指头取一些赎罪祭牲的血，抹燔祭坛的四角，其余的羊血，都要倒在祭坛脚那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","羊所有的脂肪都要取出来，好像取出平安祭绵羊羔的脂肪一样；祭司要把这些放在祭坛耶和华的火祭上面焚烧，祭司为他所犯的罪行赎罪，他就蒙赦免。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“如果有人犯罪：他听见发誓的声音（“发誓的声音”或译：“传召作证的声音”，或“发咒语的声音”）；他本是证人，却不肯把看见或知道的说出来，他就要担当自己的罪责。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","或人摸了什么不洁净的东西，无论是不洁净野兽的尸体，或是不洁净牲畜的尸体，或是不洁净昆虫的尸体，当时并不留意，他因为成了不洁净，就有罪了； ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","或有人摸了人的污秽，他没有留意玷污了什么污秽；他一知道，就有罪了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","或有人嘴唇轻率发誓，无论是出于恶意或是出于好意，他没有留意起了什么誓；他一知道，就有罪了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","如果他在任何一件事上犯了罪，就要承认自己所犯的罪； ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","他要为所犯的罪，把赎愆祭带到耶和华面前当作赎罪祭，就是羊群中的母羊，或绵羊羔或山羊；祭司就为他的罪行赎罪。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“他的经济能力若是不够献一只羊，他就要为所犯的罪，带两只斑鸠或两只雏鸽到耶和华面前作赎愆祭，一只作赎罪祭，一只作燔祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","他要把它们带到祭司那里，祭司就要先献上作为赎罪祭的一只，把鸟的头从颈项上扭断，只是不可撕断。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","然后他要把赎罪祭牲的一些血，弹在祭坛旁边，其余的血要在祭坛脚那里挤出来；这是赎罪祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","第二只作为燔祭的鸟，要按照燔祭的规则献上，祭司为他的罪行赎罪，他就蒙赦免。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“他的经济能力若是不够献两只斑鸠或两只雏鸽，就要为所犯的罪，带来一公斤的细面作赎罪祭的供物；供物不可浇上油，也不可加上乳香，因为这是赎罪祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","他要把供物带到祭司那里，祭司从其中取出一把，作为象征，放在祭坛耶和华的火祭上面焚烧；这是赎罪祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","祭司为他所犯的任何一样罪赎罪，他就蒙赦免。其余的祭物要归给祭司，好像素祭一样。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“如果有人在耶和华的圣物上不忠实，无意犯了罪，他就要依照你按着圣所衡量银子标准所估的银价，把他的赎愆祭牲，就是羊群中一只没有残疾的公绵羊，牵到耶和华面前作赎愆祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","他要补偿他在圣物上所亏欠的，另加五分之一，交给祭司；祭司要用赎愆祭的公绵羊为他赎罪，他就蒙赦免。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“如果有人犯了罪，行了一件耶和华吩咐不可行的事；他虽然不清楚，仍是有罪，他就要担当自己的罪责。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","他要依照你的估价，从羊群中把一只没有残疾的公绵羊牵来，给祭司作赎愆祭。祭司为他赎罪，那不清楚的无心之失，就蒙赦免。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","这是赎愆祭，他在耶和华面前实在有罪。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“如果有人犯罪，对耶和华不忠实，在人寄存给他的物上或抵押品上欺骗自己的同伴，或是抢夺，或是欺压自己的同胞， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","或是拾去人遗失的东西，却欺骗人，起假誓，行了任何一件人常犯的罪， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","他犯了罪，有了罪，就应归还他所抢夺的，或是欺压得来的，或是别人寄存在他那里的，或是他拾去的失物， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","或是他因起假誓所得的任何东西；在赔过的时候，他除了按原数偿还外，必须另外加上五分之一，交给原主； ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","还要照着你的估价，把赎愆祭牲，就是从羊群中取一只没有残疾的公绵羊，牵到耶和华面前，给祭司作赎愆祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","祭司在耶和华面前，为他所行的任何一件过失赎罪，他就蒙赦免。”（本章第1-7节在《马索拉抄本》为 5:20-26） ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","耶和华对摩西说：（本节在《马索拉抄本》为 6:1） ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“你要吩咐亚伦和他的子孙说：燔祭的律例是这样：燔祭要放在祭坛的柴上，通宵达旦；祭坛上的火，必须一直烧着。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","祭司要穿上细麻布外袍，又把细麻布裤子穿在身上；他要把祭坛上燔祭烧成的灰收起来，放在祭坛旁边； ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","然后脱去这些衣服，穿上别的衣服，把灰拿出营外洁净的地方。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","祭坛上的火，应常常烧着，不可熄灭；每天早晨，祭司要在上面烧柴，把燔祭排列在坛上，又在上面焚烧平安祭的脂肪。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","火必须不断在祭坛上烧着，不可熄灭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“素祭的律例是这样：亚伦的子孙要在耶和华面前的祭坛前献素祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","从其中取出一把作素祭的细面、油，和在素祭上所有的乳香，焚烧在祭坛上献给耶和华为馨香的祭，作供物的象征。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","亚伦和他的子孙要吃剩余的祭物，在圣洁的地方作无酵饼吃；他们要在会幕的院子里吃。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","烤饼的时候，不可加酵。这是我从献给我的火祭中，赐给他们的分，是至圣的，与赎罪祭和赎愆祭一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","亚伦的子孙中的男丁，都要从献给耶和华的火祭中吃这些祭物；这是你们世世代代永远的律例。人接触过这些祭物，必成为圣。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“亚伦和他的子孙，在受膏的日子要献给耶和华的供物，就是一公斤的细面，作常献的素祭，早晨献一半，晚上献一半。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","你要把这些细面在煎盘上用油调和作饼，烘（“烘”一词原意不明，有译本作“擘成块”）好了，你就拿进来；将擘成碎块的素祭献上，献给耶和华为馨香的祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","亚伦的子孙继承他作受膏立的祭司的，都要献这素祭，把它完全焚烧，献给耶和华，作永远的律例。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","凡是祭司献的素祭都要完全焚烧，不可以吃。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“你要告诉亚伦和他的儿子：赎罪祭的律例是这样：赎罪祭牲应在宰杀燔祭牲的地方，在耶和华面前宰杀，这是至圣的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","献这赎罪祭的祭司要吃这祭牲；在会幕院子里的圣洁地方吃。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","接触过这祭肉的，必成为圣。沾了祭牲的血，必须清理；血溅在衣服上，应该在圣洁的地方洗净， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","煮祭物的瓦器却要打碎；如果煮祭物的是铜器，只需用水冲洗。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","祭司家中的男丁，都可以吃祭肉；这是至圣的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","但是任何赎罪祭，如果它的血带进了会幕在圣所内进行赎罪，祭肉就不可吃；必须用火烧尽。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“赎愆祭的律例是这样：这祭是至圣的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","人在什么地方宰杀燔祭牲，就要在那里宰杀赎愆祭牲，它的血要泼在祭坛的四周。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","祭司要把祭牲的一切脂肪都献上，就是肥尾巴和遮盖内脏的脂肪， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","以及两个肾、肾上近腰旁的脂肪和肾旁的肝叶，一起取下。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","然后把这些焚烧在祭坛上，作献给耶和华的火祭，这是赎愆祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","祭司家中的男丁，都可以吃祭牲的肉，要在圣洁的地方吃；这是至圣的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","赎罪祭怎样，赎愆祭也怎样；两个祭的律例相同； ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","祭物要归主持赎罪的祭司，祭司替人献燔祭，祭牲的皮要归献燔祭的祭司。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","一切在炉里烤的，或在浅锅里或在煎盘上做的素祭，都要归给那献祭的祭司。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","一切用油调和，或是干的素祭，都要归给亚伦所有的子孙，大家均分。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“献给耶和华的平安祭的律例是这样： ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","人若是为感恩献祭，就要用调油的无酵饼和抹了油的无酵薄饼，以及用油调和了细面做的饼，与感恩祭一同献上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","他要把他的供物，连同有酵的饼，跟那为感恩而献的平安祭，一起献上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","他要从各物中，取出一个饼作为举祭，献给耶和华，归给那泼平安祭牲之血的祭司。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","“为感恩而献的平安祭的肉，只能在献祭那日吃，一点也不可留到早晨。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","他献的供物若是还愿祭，或是甘心祭，献祭那日可以吃；剩下的，第二天也可以吃。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","还剩下的祭肉，到了第三天，就要用火烧掉。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","如果在第三天吃平安祭的肉，必不蒙悦纳，他献上的也不再算为祭，因为祭肉已经成为不洁；吃这肉的人，必担当自己的罪责。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“祭肉若是接触了任何不洁，就不可以吃，要用火烧掉。洁净的人才可以吃祭肉； ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","身上不洁净的人吃了献与耶和华的平安祭的祭肉，那人必从自己的族人中被剪除。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","人若是摸了任何不洁，或是人的污秽，或是牲畜的污秽，或是任何不洁净的可憎之物，然后吃献给耶和华的平安祭的肉，那人必从自己的族人中被剪除。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“你要告诉以色列人说：所有公牛、绵羊或是山羊的脂肪，你们都不可吃。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","自死的或被野兽撕裂的动物的脂肪，可以作别的用途，只是你们决不可吃。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","因为无论何人吃了献给耶和华为火祭的牲畜的脂肪，那吃的人就必从自己的族人中被剪除。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","在你们的一切住处，任何血，无论是飞鸟或是牲畜的，你们都不可吃。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","无论谁吃了什么血，那人必从自己的族人中被剪除。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“你要告诉以色列人：向耶和华献平安祭的，必须从他的平安祭中取出奉给耶和华的供物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","亲手把献给耶和华的火祭带来，就是把脂肪连胸带来，在耶和华面前摇一摇，作为摇祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","祭司要把脂肪焚烧在祭坛上，胸归给亚伦和他的子孙。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","你们要从平安祭牲中，拿右后腿来作举祭，奉给祭司。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","亚伦的子孙中，谁献平安祭牲的血和脂肪，右后腿就归给他，是他的分。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","因为我从以色列人的平安祭中，取出了这摇祭的胸和举祭的后腿，给亚伦祭司和他的子孙，成为以色列人中永远的律例。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","“这是亚伦和他子孙，从奉献他们作耶和华的祭司那日开始，受膏立应得的分。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","就是耶和华膏立他们的时候，命令以色列人给他们的。这是世世代代永远的律例。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","以上关于燔祭、素祭、赎罪祭、赎愆祭、承受圣职祭和平安祭的律例， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","都是耶和华在西奈山吩咐摩西的，就是他在西奈的旷野吩咐以色列人，把他们的供物献给耶和华的时候所说的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“你要把亚伦和他的儿子，连同圣衣、膏油、赎罪祭的一头公牛、两只公绵羊，一篮无酵饼都带来， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","又要召集全体会众到会幕门口那里。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","于是摩西照着耶和华命令他的去行，会众就聚集到会幕门口那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","摩西对会众说：“这是耶和华吩咐我作的事。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","摩西领亚伦和他的儿子来，用水给他们洗身。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","然后给亚伦穿上内袍，束上腰带，穿上外袍，又加上以弗得，用巧工织成的以弗得带子束上，把以弗得系在他身上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","又给他佩上胸牌，把乌陵和土明放在胸牌里面， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","把礼冠戴在他头上；在礼冠前面安上金牌，就是圣冠，都是照着耶和华吩咐摩西的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","摩西取膏油，抹了帐幕和其中所有的东西，使它们分别为圣。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","又七次弹膏油在祭坛上，膏抹祭坛和祭坛的一切器皿，以及洗濯盆和盆座，使它们分别为圣。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","然后把膏油倒在亚伦的头上，膏立他，使他分别为圣。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","摩西把亚伦的儿子带来，给他们穿上内袍，束上腰带，包上裹头巾，都是照着耶和华吩咐摩西的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","他把赎罪祭的公牛牵来；亚伦和他的儿子按手在赎罪祭的公牛的头上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","摩西就宰杀公牛，取了血，用指头抹祭坛四角的周围，洁净祭坛，其余的血倒在祭坛脚那里，使祭坛成圣，为坛赎罪。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","摩西取出内脏上所有的脂肪、肾旁的肝叶、两个肾和肾上的脂肪，焚烧在祭坛上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","至于那公牛，它的皮、肉和粪，都要在营外用火烧掉，都是照着耶和华吩咐摩西的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","摩西把燔祭的公绵羊牵来，亚伦和他的儿子按手在公绵羊的头上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","摩西就宰杀公绵羊，把血泼在祭坛的四周。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","摩西把公绵羊切成块子以后，就把头、肉块和脂肪都焚烧了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","又用水洗净了内脏和腿之后，摩西就把整个公绵羊焚烧在祭坛上；这是燔祭，是献给耶和华馨香的火祭，都是耶和华吩咐摩西的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","他又把第二只公绵羊牵来，就是承受圣职所献的公绵羊；亚伦和他的儿子按手在公绵羊的头上； ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","摩西宰杀了羊，取了一些羊血，抹在亚伦的右耳垂上和右手的大拇指上，以及右脚的大拇趾上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","又把亚伦的儿子带来，摩西也把血抹在他们的右耳垂上和右手的大拇指上，以及右脚的大拇趾上；其余的血则泼在祭坛的四周。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","然后他取出脂肪、肥尾巴、内脏上所有的脂肪、肾旁的肝叶、两个肾、肾上的脂肪和右后腿； ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","又从在耶和华面前的无酵饼篮子里，取出一个无酵饼、一个油饼和一个薄饼，都放在脂肪和右后腿上； ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","他把这一切都放在亚伦手上和他儿子手上，在耶和华面前摇一摇作为摇祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","然后，摩西从他们的手上接过来，焚烧在祭坛的燔祭上；这些是承受圣职祭，是献给耶和华馨香的火祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","摩西取了祭牲的胸，在耶和华面前把它摇一摇作摇祭；这是承受圣职祭的公绵羊中，归给摩西的分，都是照着耶和华吩咐摩西的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","摩西拿了一些膏油和祭坛上的血，弹在亚伦和他的衣服上，以及他儿子和他们的衣服上；这样就使亚伦和他的衣服，他的儿子和他们的衣服都分别为圣。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","摩西对亚伦和他的儿子说：“你们要在会幕门口煮祭肉，也在那里吃祭肉和承受圣职祭篮子里的饼，照着我的吩咐，亚伦和他的儿子要吃这些。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","剩下来的肉和饼，你们要用火烧掉。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","七天之内，你们不可出会幕的门口，直到你们承受圣职礼的日子满了，因为主要用这七天使你们承受圣职（“使你们承受圣职”原文作“他充满你们的手”）。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","今天所行的，是照耶和华的吩咐而行，为你们赎罪。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","七天之内，你们昼夜都住在会幕门口，遵守耶和华的吩咐，免得你们死亡，因为耶和华是这样吩咐我。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","于是亚伦和他的儿子行了耶和华借着摩西吩咐的一切事。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","到了第八天，摩西把亚伦和他的儿子，以及以色列的众长老都召了来； ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","摩西对亚伦说：“你要取一头公牛犊来作赎罪祭，一只公绵羊作燔祭，两样都要没有残疾的；献在耶和华的面前。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","你也要告诉以色列人：你们要取一只公山羊作赎罪祭，又取一头一岁的牛犊和一只一岁的绵羊羔作燔祭，两样都要没有残疾的； ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","又取一头公牛和一只公绵羊作平安祭，宰献在耶和华面前；又取用油调和的素祭，因为今天耶和华要向你们显现。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","于是他们把摩西所吩咐的，带到会幕前面；全体会众都走近来，站在耶和华的面前。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","摩西说：“这是耶和华吩咐你们的事，你们要照着行，耶和华的荣耀就要向你们显现。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","然后摩西对亚伦说：“走到祭坛那里，献上你的赎罪祭和燔祭，为自己和人民赎罪；又献上人民的供物，按着耶和华的吩咐，为他们赎罪。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","于是亚伦走近祭坛，宰杀那为自己献的赎罪祭牛犊。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","亚伦的儿子奉上血，他就把手指蘸在血里，抹在祭坛的四角上，把剩下的血倒在祭坛脚那里； ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","赎罪祭牲的脂肪、肾和肝叶，他都焚烧在祭坛上，都是照着耶和华吩咐摩西的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","至于肉和皮，却在营外用火烧掉。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","亚伦宰杀了燔祭牲，他的儿子把血递给他，泼在祭坛的周围。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","他们跟着把燔祭牲一块一块连头递给他，焚烧在祭坛上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","亚伦又洗净了内脏和腿，在祭坛的燔祭上焚烧。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","他把人民的供物献上，又把那为人民作赎罪祭的公山羊牵来，宰杀了，献为赎罪祭，和先前献的一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","然后他按着规则献上燔祭， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","又献上素祭，从其中取了满满的一把，在祭坛上焚烧。这是在早晨的燔祭以外的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","亚伦又宰杀了那为人民作平安祭的公牛和公绵羊；亚伦的儿子把血递给他，泼在祭坛的周围。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","他们又把公牛和公绵羊的脂肪、肥尾巴、遮盖内脏的脂肪、两个肾和肝叶， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","都放在胸上，亚伦就把脂肪在祭坛上焚烧； ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","至于胸和右后腿，亚伦拿来作摇祭，在耶和华面前摇一摇；都是照着摩西吩咐的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","亚伦向众人举起手，为他们祝福；他献了赎罪祭、燔祭和平安祭，就下来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","摩西和亚伦进了会幕，出来就为众人祝福；耶和华的荣耀向众民显现。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","有火从耶和华面前出来，烧尽了祭坛上的燔祭和脂肪；众民看见了，就大声欢呼，俯伏在地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","亚伦的儿子拿答和亚比户各拿着自己的香炉，盛上火，加上香，在耶和华面前献上平常的火，是耶和华没有命令他们献的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","那时有火从耶和华面前出来，把他们烧灭，他们就死在耶和华面前。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","于是摩西对亚伦说：“这就是耶和华曾经告诉我们的，他说：‘在亲近我的人中，我要显为圣，在众人面前，我要得荣耀。’”亚伦就默然无语。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","摩西把亚伦叔父乌薛的儿子米沙利和以利撒反召了来，对他们说：“你们上前来，把你们的兄弟从圣所前抬到营外去。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","于是二人走近来，照着摩西的吩咐，把他们连同他们的衣服抬到营外去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","摩西对亚伦和他的儿子以利亚撒和以他玛说：“你们不要披头散发，不可撕裂你们的衣服，免得你们死亡，又免得耶和华向全体会众发怒。你们的亲族，以色列全家，却要为耶和华所烧死的人哀哭（“要为耶和华......哀哭”或译：“要为耶和华所燃起的焚烧哀哭”）。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","你们也不可走出会幕的门口，免得你们死亡，因为耶和华的膏油在你们身上。”他们就照着摩西的话行。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","耶和华对亚伦说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“你和你的儿子一起进会幕的时候，淡酒烈酒都不可喝，免得你们死亡，这要作你们世世代代永远的律例； ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","使你们可以把圣的和俗的，洁净的和不洁净的，分辨清楚； ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","可以把耶和华借着摩西告诉以色列人的一切律例，教训他们。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","摩西对亚伦和他剩下的儿子以利亚撒和以他玛说：“献给耶和华的火祭中剩下的素祭，你们要拿来在祭坛旁边作无酵饼吃，因为这是至圣的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","你们要在圣洁的地方吃，在献与耶和华的火祭中，这是你和你儿子的分，因为耶和华是这样吩咐我。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","至于作摇祭的胸和作举祭的后腿，你们也要在洁净的地方吃，你和你的儿女要一起吃，这是从以色列人献的平安祭中，给你和你儿子的分。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","至于作举祭的后腿，作摇祭的胸，他们要与火祭的脂肪一同带来，当作摇祭，在耶和华面前摇一摇。这都要归给你和与你在一起的儿子，当作永远的律例，都是照着耶和华所吩咐的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","那时，摩西急切地寻找那作赎罪祭的公山羊，发现已经烧了；他就向亚伦剩下的儿子以利亚撒和以他玛发怒，说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“这赎罪祭是至圣的，耶和华又把祭肉给你们，要叫你们担当会众的罪孽，在耶和华面前为他们赎罪，你们为什么没有在圣洁的地方吃呢？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","这祭牲的血既然没有带进圣所里去，你们就应该照着我所吩咐的，在圣所里吃这祭肉。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","亚伦对摩西说：“今天他们在耶和华面前已经献了赎罪祭和燔祭，而且有这样的灾祸临到我；如果今天我吃了赎罪祭的祭肉，耶和华怎能看为美好呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","摩西听了，也觉得合理。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","耶和华对摩西和亚伦说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“你们要告诉以色列人：地上所有的走兽中，你们可以吃的动物，就是这些： ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","分蹄有趾而且反刍的走兽，你们都可以吃。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","但你们不可吃下列反刍，或分蹄的走兽动物：骆驼，因为它反刍却不分蹄，你们应以为不洁净。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","石獾（本章动物名字多不能确定。“石獾”传统翻译作“沙番”或“山鼠”），因为它反刍却不分蹄，你们应以为不洁净。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","兔子，因为它反刍却不分蹄，你们应以为不洁净。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","猪，因为它分蹄有趾却不反刍，你们应以为不洁净。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","这些走兽的肉你们不可吃，它们的尸体你们不可摸，你们应视为不洁净。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“水中所有的活物你们可以吃的，就是这些：凡是在水中，有翅有鳞的，不论是在海里或是河里的，你们都可以吃。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","在水中游动或生存在水中的活物，无论是在海里或是河里，若是没有翅和鳞的，你们都要当作可憎之物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","它们是你们憎恶之物；它们的肉，你们不可吃；它们的尸体，你们要憎恶。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","所有在水里没有翅和鳞的活物，你们都要当作可憎之物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“在鸟类中，你们要憎恶，也不可吃这些雀鸟：兀鹰（雀鸟的名字中文翻译还未统一，它们的学名多不能确定）、雕、鹫、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","鸢、猎鹰等隼类， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","所有乌鸦类， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","鸵鸟、猫头鹰、海鸥、苍鹭等鹰类。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","鸱鹗、鸬鹚、大鸱枭、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","白鹭、塘鹅、鸨、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","鹳、红鹤等鹭鸶类，戴胜和蝙蝠。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“凡有翅膀、四足爬行的生物，你们都要当作可憎之物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","但在所有有翅膀、四足爬行的生物中，如果有足有腿，能在地上蹦跳的，你们都可以吃。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","在昆虫中，你们可以吃这些：蝗虫类、蚂蚱类、蟋蟀类和蚱蜢类。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","但是其他所有有翅膀四足的生物，你们都要当作可憎之物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“以下事物，会使你们成为不洁：触摸动物尸体的，就不洁净到晚上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","拾起它们的尸体的，就要洗净自己的衣服，并且不洁净到晚上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","所有分蹄却无趾的、不反刍的走兽，你们应以为不洁净，触摸它们的，就不洁净。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","所有用四足行走的动物中，用脚掌行走的，你们应以为不洁净，触摸它们尸体的，都不洁净到晚上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","拾起它们尸体的，就要洗净自己的衣服，并且不洁净到晚上。以上这些你们应以为不洁净。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“在地上爬行的生物中，你们应以为不洁净的是这些：鼬鼠、鼫鼠、蜥蜴这一类， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","以及壁虎、龙子、守宫、蛇医、变色龙。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","在所有爬行的生物中，你们应以这些为不洁净；它们死了以后，触摸它们的，都不洁净到晚上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","它们当中死了的，掉在什么东西上，无论是木器或是衣服，皮子或是布袋等任何器具，都成为不洁净，要放在水中。但仍不洁净到晚上，以后就真洁净了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","它们当中死了的，掉在什么瓦器里，其中不论是什么，都成为不洁净，你们要把瓦器打碎。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","瓦器的水若是滴在任何食物上，食物就成了不洁净，若是滴在装了饮料的器皿里，饮料也成为不洁净。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","它们尸体的任何部分掉在什么东西上，那东西就不洁净，无论是炉或是锅，都成为不洁净，应该打碎；你们应以这些为不洁净。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","但是水源和储水池仍算是洁净的。只有触摸水中尸体的，才是不洁净。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","它们尸体的一部分掉在要播种的种子上，种子还是洁净的； ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","但是，如果种子已经浇了水，它们尸体的一部分才掉在种子上面，你们应以这种子为不洁净。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“一只你们可以吃的走兽死了，谁摸了它的尸体，就不洁净到晚上； ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","谁吃了它的尸体，就要洗净自己的衣服，并且不洁净到晚上；谁拾起这尸体，也要洗净自己的衣服，并且不洁净到晚上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“所有在地上爬行的动物，都是可憎之物，都不可吃。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","凡是用肚子，或用四足或是多足在地上爬行的动物，你们都不可吃，因为它们是可憎之物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","你们不可因任何爬行的动物使自己成为可憎的，也不可因它们玷污自己，以致不洁净。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","因为我是耶和华你们的　神，所以你们要使自己成为圣洁。你们要分别为圣，因为我是圣洁的。你们不可因在地上爬行的任何动物玷污自己， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","因为我是耶和华，曾把你们从埃及地领上来，为要作你们的　神；你们要分别为圣，因为我是圣洁的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","以上就是有关走兽、飞禽、所有在水中游行的动物，和所有在地上爬行的动物的律例， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","为要把不洁净的和洁净的，可吃的生物和不可吃的生物，分别出来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“你要告诉以色列人：如果有妇人怀孕，生了男孩，她就不洁净七天，好像患病污秽的日子不洁净一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","第八天男婴要受割礼。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","妇人洁净产血的时期要住在家三十三天；得洁净的日子未满之前，她不可触摸任何圣物，也不可进入圣洁的地方。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","如果她生了女孩，就不洁净十四天，像月经污秽的日子一样；妇人洁净产血的时期，要住在家里六十六天。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“洁净的日子满了，不论是为男孩或是为女孩，她都要用一只一岁的绵羊羔作燔祭，一只雏鸽，或一只斑鸠作赎罪祭，带到会幕门口那里，交给祭司。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","祭司把供物献在耶和华面前，为她赎罪，她的血就洁净了。以上是生育男女的律例。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","她的经济能力若是不够献一只羊羔，她可以拿两只斑鸠，或是两只雏鸽，一只作燔祭，一只作赎罪祭；祭司要为她赎罪，她就洁净了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","耶和华对摩西和亚伦说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“如果有人在皮肉上生了瘤，或癣，或火斑，后来皮肉变成了大痲风病症（本章病名多不能确定它们的学名。传统翻译作“痲风”的希伯来字，本章用来形容不同的皮肤病症），就要把他带到一个作祭司的亚伦子孙那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","祭司要察看皮肉上的病症；如果患处的毛已经变白（“变白”或译：“较其他皮肉色泽显然为深”），病症的现象又深透皮下的肉，就是大痲风病症，祭司发现这样，就要宣布他为不洁净。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","火斑若是在他的皮肉上发白，但没有深透皮肤的现象，上面的毛也没有变白，祭司就要把患者隔离七天。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","到了第七天，祭司要察看他，如果看见病情止住了，皮上的患处没有蔓延，祭司还要把他再隔离七天。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","到了第七天，祭司要再察看他；如果看见患处色泽变淡，也没有在皮上蔓延，祭司就要宣布他为洁净，这不过是癣；他洗净衣服，就得洁净了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","但是祭司察看，宣布他洁净以后，癣若是在皮上蔓延，他就要再次给祭司察看。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","祭司要察看他；如果发现癣在皮上蔓延了，祭司就要宣布他为不洁净；这是大痲风。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“如果有人感染到大痲风，就要带他到祭司那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","祭司要察看，如果发现皮上有白色浮肿，毛已经变白，患处的肉红肿， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","这就是皮肉上的潜伏性痲风病发作，祭司要宣布他为不洁净；不必隔离观察，因为他已经不洁净。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","如果祭司认为痲风病已在皮上蔓延，从头到脚遮满了患病者全身的皮， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","那么祭司就要察看；如果看见痲风布满了他的全身，祭司就要宣布那患病者为洁净；因为全身变白，就算是洁净。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","但他身上什么时候出现红肿的肉，他就成为不洁净。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","祭司发现那红肿的肉，就要宣布他为不洁净；红肿的肉原来是不洁净的，是痲风病。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","但红肿的肉若是再复原，又变成白，他就要到祭司那里， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","祭司要察看；如果看见患处变白了，祭司就要宣布那患病者为洁净的；他就洁净了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“人若是在皮肉上生了疮，已经医好了； ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","但在长疮之处又起了白色浮肿，或是白中带红的火斑，他就要给祭司察看。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","祭司要察看；如果发现有深透皮肤的现象，上面的毛也变白了，祭司就要宣布他为不洁净；这就是在疮中发作出来的痲风病。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","但如果祭司察看病情，看见上面没有白毛，也没有深透皮肤，只是发暗而已，祭司就要把他隔离七天； ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","如果在皮肤上蔓延，祭司就要宣布他为不洁净；这就是痲风病。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","火斑若是在原处止住，没有蔓延，就是疮的疤痕，祭司就要宣布他为洁净。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“如果人的皮肉发炎，发炎红肿的肉成了火斑，白中带红，或是纯白， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","祭司就要察看病情；如果发现火斑中的毛变白了，又有深透皮肤的现象，这就是从发炎发作出来的痲风病。祭司就要宣布他为不洁净；这是痲风病。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","但如果祭司察看病情，看见火斑中没有白毛，也没有深透皮肤，只是发暗而已，祭司就要把他隔离七天。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","到了第七天，祭司要察看；火斑若是在皮上蔓延，祭司就要宣布他为不洁净，这是痲风病。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","火斑若是在原处止住，没有在皮上蔓延，只是发暗而已，这是发炎肿瘤，祭司就要宣布他为洁净，因为这只是发炎的疤痕。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“无论男女，如果在头上或是胡须上受到感染， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","祭司要察看那病；如果发现有深透皮肤的现象，而且还有黄色细毛，祭司就要宣布他为不洁净，这是癞痢，是头上或是胡须上的痲风病。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","祭司察看癞痢的患处；如果看见没有深透皮肤的现象，那里也没有黑毛，祭司就要把那患癞痢的人隔离七天。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","到了第七天，祭司要察看患处；如果看见癞痢没有蔓延，那里也没有黄毛，癞痢也没有深透皮肤的现象， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","那人就要剃去须发，患癞痢的地方却不可剃；祭司要把那患癞痢的人再隔离七天。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","到了第七天，祭司要再察看那癞痢；如果看见癞痢在皮上没有蔓延，也没有深透皮肤的现象，祭司就要宣布他为洁净；他洗净衣服，就洁净了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","但是他得洁净以后，癞痢若是在皮上蔓延， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","祭司就要察看；如果发现癞痢在皮上蔓延，祭司不必找黄毛，他已经不洁净。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","如果祭司认为，癞痢已经止住，那里也长了黑毛；癞痢已经痊愈，那人就洁净了，祭司要宣布他为洁净。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“无论男女，皮肉上若是起了斑点，白色的斑点， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","祭司就要察看；如果发现斑点在皮肉上呈灰白色，这是皮肤出疹，那人是洁净的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“人的头发若是掉下了，只不过是秃头，还是洁净的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","人的头顶上若是掉下了头发，只不过是秃额，他还是洁净的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","但是头顶秃处或是额前秃处，若有白中带红的病症，这就是痲风病，在他的头顶秃处或是额前处发作。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","祭司就要察看，如果发现在他头顶秃处或是额前秃处，有白中带红的浮肿病症，像皮肉上痲风病的现象， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","那人就是患了痲风病，就不洁净；祭司要宣布他为不洁净，那人头上染了痲风。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“身上患有痲风病的人，要撕裂自己的衣服，披头散发，遮盖上唇喊叫：‘不洁净！不洁净！’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","在他患病的日子里，他是不洁净的；他既然不洁净，就要独居，住在营外。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“染了痲风病的衣服，无论是羊毛衣服或是麻布衣服； ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","不论是编结的或是纺织的；是麻布的或是羊毛的；是皮子或是皮子做成的任何物件； ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","病症若是在衣服或皮子、编结物或纺织物，或任何皮子做成的器具上发绿或发红，那就是发霉（“发霉”与“恶性皮肤病”是同一希伯来字）的现象，要给祭司察看。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","祭司要察看那现象，把染了病症之物隔离七天。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","到了第七天，祭司要察看那病症；如果那病症在衣服、编结物、纺织物、皮子，或是任何皮子做成的物件上蔓延，这就是顽恶的霉，那件物件就不洁净了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","染上病症的衣服，无论是编结的或是纺织的，是羊毛或是麻布，或任何皮子做的物件，都要烧掉。因为那是顽恶的霉，所以要用火烧掉。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“但如果祭司察看病症，在衣服、编结物、纺织物，或是皮子做的任何物件上，没有蔓延， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","祭司就要吩咐人把它洗净，然后再隔离七天。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","洗净以后，祭司要察看；如果看见那病症没有转变，虽然没有蔓延，那物件仍是不洁净；要用火把它烧掉，因为里外都腐蚀了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","“但如果祭司察看的时候，看见它洗净以后，色泽暗淡了，就要把那部分从衣服或是皮子、编结物或纺织物上撕下来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","如果病症再出现在剩下的衣服、编结物、纺织物或任何皮子做的物件上，那就是病症仍然发作，染了病症的物件，要用火烧掉。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","如果病症离开了，经过洗净，剩下的衣服，无论编结的或是纺织的，或任何皮子做的物件，只要再洗一次，就洁净了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","以上是与羊毛衣服或是麻布衣服、编结的或纺织的或任何皮子做的物件有关的发霉律例，可以断定洁净，或是不洁净。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“患痲风病的人得洁净的日子，应守的律例如下：人要带他去见祭司。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","祭司要出到营外去察看，祭司若是看见患病的人身上的痲风病已经好了， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","就要吩咐人为那求洁净的人，拿两只洁净的活鸟、香柏木、朱红色线和牛膝草来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","祭司要吩咐人用瓦器盛活水，把一只鸟宰杀在上面。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","至于那只活鸟，祭司要把它与香柏木、朱红色线和牛膝草一起拿来，把这些物品和活鸟一同蘸于那在活水上宰杀的鸟血中， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","然后向那患痲风病求洁净的人身上弹七次，就可以宣布他洁净；又让那只活鸟飞到田野去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","那得洁净的人要洗自己的衣服，剃去身上所有的毛发，用水洗澡，就洁净了；然后他可以进营，只是还要在自己的帐幕外住七天。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","第七天，他要把身上一切的毛发都剃去；头发、胡须、眉毛和身上一切的毛发都剃去；又要洗衣服，用水洗身，就洁净了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“第八天，他要取两只没有残疾的公羊羔和一只没有残疾一岁的母羊羔，又要把调油的细面三公斤作素祭，以及三分之一公升油一同取来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","行洁净礼的祭司领那求洁净的人拿着这些祭物站在会幕门口，耶和华的面前。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","祭司取一只公羊羔，献作赎愆祭，取三分之一公升油一同献上；祭司把这两样当作摇祭，在耶和华面前摇一摇。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","他要在圣洁的地方，就是宰杀赎罪祭牲和燔祭牲的地方，宰杀那只公羊羔，因为赎愆祭牲，像赎罪祭牲一样，是至圣的，要归祭司； ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","祭司要取些赎愆祭牲的血，抹在得洁净的人的右耳垂上和右手的大拇指上，以及右脚的大拇趾上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","祭司又从那三分之一公升油中，取出一点来，倒在自己的左掌里； ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","把右手的一个指头，蘸在左掌的油里，在耶和华面前用指头把油弹七次。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","然后祭司要把手中剩下的油，抹在那得洁净的人的右耳垂上和右手的大拇指上，以及右脚的大拇趾上，就是抹在赎愆祭牲的血上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","祭司要把手中剩下的油，抹在那得洁净的人的头上；祭司在耶和华面前为他赎罪。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","祭司要献赎罪祭，为那得洁净的人赎罪，使他脱离污秽，然后宰杀燔祭牲。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","祭司要把燔祭和素祭献在祭坛上，为他赎罪，他就洁净了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“但如果他贫穷，经济能力不足，他只要拿一只公绵羊羔作赎愆祭，摇一摇为他赎罪；要把调油的细面一公斤作素祭，和三分之一公升的油一同拿来； ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","又要按他的经济能力，拿两只斑鸠或是两只雏鸽，一只作赎罪祭，一只作燔祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","第八天，他为了自己得洁净，要把这些祭物带到会幕门口，耶和华面前，交给祭司。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","祭司要取那只作赎愆祭的公羊羔和那三分之一公升油；祭司把这些，在耶和华面前摇一摇当作摇祭； ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","然后宰杀作赎愆祭的公羊羔，取一些赎愆祭牲的血，抹在那得洁净的人的右耳垂上和右手的大拇指上，以及右脚的大拇趾上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","祭司要把一些油倒在自己的左掌里； ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","用右手的一个指头把左掌中的油，在耶和华面前弹七次。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","祭司又要把手中的油，抹在那得洁净的人的右耳垂上和右手的大拇指上，以及右脚的大拇趾上，就是抹了赎愆祭牲的血的地方。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","祭司把手中剩下的油，抹在那得洁净的人的头上，在耶和华面前为他赎罪。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","那人就要按着自己的经济能力献上一只斑鸠，或是一只雏鸽。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","他要按着自己的经济能力，献上一只作赎罪祭，一只作燔祭，连同素祭一同献上。祭司要在耶和华面前，为求洁净的人赎罪。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","这是关于患了痲风病，但经济能力不足够预备正常洁净礼祭物的人，应守的律例。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","耶和华对摩西和亚伦说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“你们进了我赐给你们作产业的迦南地的时候，我给你们作产业之地的房屋，如果发霉， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","房主就要去告诉祭司：‘据我看来，房屋中似乎染了病症。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","祭司进去察看病症之前，要先吩咐人把房屋搬空，免得房屋里的一切都成了不洁；然后祭司才进去，察看那房屋。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","他要察看那病症，如果发现在房屋的墙上有发绿或是发红的腐蚀斑纹，而且有深透入墙的现象； ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","祭司就要从房屋里出来，到房门外去，把房屋隔离七天。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","第七天，祭司要回来察看，如果发现病症在房屋的墙上蔓延， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","祭司就要吩咐人把染有病症的石头挖出来，扔在城外不洁净的地方， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","要刮净房屋里面的四周，把刮下来的灰泥倒在城外不洁净的地方； ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","拿别的石头放进去代替挖出来的石头，然后用别的灰泥粉刷房屋。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“如果挖出石头，刮了房屋，粉刷了墙以后，病症再次在房屋里出现， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","祭司就要进去察看；如果发现病症在房屋里有蔓延的现象，这就是房屋里顽恶的发霉现象，那房屋就不洁净了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","要把房屋拆毁，把房屋里的石头、木头，以及所有的灰泥都搬到城外不洁净的地方去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","在房屋被关闭的期间，进去的人必不洁净到晚上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","在房屋里睡觉的人，要洗净自己的衣服；在房屋里吃饭的人，也要洗净自己的衣服。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“房屋粉刷以后，祭司进去察看，如果看见病症在房屋里没有蔓延，祭司就要宣布那房屋为洁净，因为已经复原了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","为了洁净那房屋，祭司要拿两只鸟、香柏木、朱红色线和牛膝草； ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","把一只鸟，在盛着活水的瓦器上宰杀； ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","然后拿香柏木、牛膝草、朱红色线和那只活鸟，都一同蘸在被宰杀的鸟血和活水中，向房屋弹七次。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","他就用鸟血、活水、活鸟、香柏木、牛膝草和朱红色线，洁净了那房屋； ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","然后让那只活鸟飞到城外的田野里去；他为房屋赎罪，房屋就洁净了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","以上是有关各种痲风病、癣疥、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","衣服和房屋发霉、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","肿瘤、疮癣和火斑的律例； ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","指示人知道什么时候不洁净，什么时候洁净。这是痲风病的律例。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","耶和华对摩西和亚伦说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“你们要告诉以色列人，对他们说：如果男子的下体有异常排泄，他的排泄物是不洁净的， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","这异常排泄就使他不洁净；无论下体仍有排泄流出，或是下体的排泄已经止住了，他都是不洁净的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","有异常排泄的人睡过的床，都是不洁净的；他坐过的家具，都必不洁净。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","谁触摸他的床，都要洗净自己的衣服，用水洗澡，并且不洁净到晚上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","谁坐了有异常排泄的人所坐过的家具，要洗净自己的衣服，用水洗澡，并且不洁净到晚上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","触摸了有异常排泄的人的身体，就要洗净自己的衣服，用水洗澡，并且不洁净到晚上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","有异常排泄症的人，若是吐唾沫在洁净的人身上，那人就要洁净自己的衣服，用水洗澡，并且不洁净到晚上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","有异常排泄的人坐过的鞍，都不洁净。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","谁触摸他身下任何东西，都不洁净到晚上；拿了这些东西的，要洗净自己的衣服，用水洗澡，并且不洁净到晚上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","谁触摸有异常排泄的人，而没有洗手，就要洗净自己的衣服，用水洗澡，并且不洁净到晚上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","有异常排泄的人摸过的瓦器，必须打碎；他摸过的任何木器，都要用水洗净。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“有异常排泄的人痊愈的时候，就要为自己得洁净计算七天，洗净自己的衣服，用活水洗身，就洁净了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","第八天，他要带两只斑鸠或是两只雏鸽，来到耶和华面前，在会幕门口交给祭司。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","祭司要把它们献上，一只作赎罪祭，一只作燔祭；祭司因那人的异常排泄，要在耶和华面前为他赎罪。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“人若是遗精，就要用水把全身洗净，并且不洁净到晚上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","无论是衣服或是皮革，被精液染污，都要用水洗净，并且不洁净到晚上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","至于女人，男人若是与她同睡性交，两人都要用水洗澡，并且不洁净到晚上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“如果女人身上排泄的是经血，她必污秽七天；摸她的，都不洁净到晚上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","在她污秽的时期，她躺过的东西，都不洁净；她坐过的东西，也都不洁净。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","触摸她的床的，都要洗净自己的衣服，用水洗澡，并且不洁净到晚上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","触摸她坐过的任何家具，都要洗净自己的衣服，用水洗澡，并且不洁净到晚上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","在女人的床上，或是在她坐过的家具上，如果有别的东西，人摸了它，就不洁净到晚上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","男人若是与那女人同睡，染上她的污秽，就不洁净七天；他躺过的床都不洁净。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“女人若是在月经污秽期以外，血漏多日；或是月经污秽期过长，患有血漏症；她在这些血漏的日子是不洁净的，好像她在月经污秽的日子不洁净一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","她在血漏症的日子躺过的床，都像她在月经污秽时的床一样；她所坐过的家具，都不洁净，像月经污秽的时候一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","触摸这些东西的，都不洁净；要洗净自己的衣服，用水洗澡，并且不洁净到晚上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","女人的血漏若是洁净了，她要计算七天，然后就洁净了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","第八天，她要拿两只斑鸠或两只雏鸽，带到会幕门口，交给祭司。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","祭司要献一只作赎罪祭，一只作燔祭；祭司要在耶和华面前，因那妇人血漏的不洁，为她赎罪。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“你们要这样叫以色列人远离他们的不洁，免得他们玷污我在他们中间的会幕，他们就因自己的不洁而死亡。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","以上是关于因为异常排泄和遗精，成为不洁净， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","以及患病污秽的妇女和患血漏的男女，还有男人与不洁净的女人同睡的律例。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","亚伦的两个儿子走近耶和华面前而死亡以后，耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","“你要告诉你的哥哥亚伦，不可随时进入圣所的幔子里面，到约柜上的施恩座，免得他死亡，因为我在施恩座上的彩云中显现。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","亚伦进入圣所时要带一头公牛犊作赎罪祭，一只公绵羊作燔祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","他要穿上细麻布的圣内袍，也要把细麻布的裤子穿在身上，腰束细麻布的带子，头戴细麻布礼冠；这些就是圣衣。他要先用水洗身，然后才穿上圣衣。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","他要从以色列的会众中，取两只公山羊作赎罪祭，一只公绵羊作燔祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","亚伦为自己的罪献上作赎罪祭的公牛，为自己和家人赎罪， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","然后把两只公山羊牵来，放在会幕门口，耶和华的面前； ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","亚伦要为这两只山羊抽签：一签归耶和华，另一签归阿撒泻勒（“阿撒泻勒”是希伯来文音译，这字原意不能确定）。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","亚伦要把那抽签归耶和华的山羊，献作赎罪祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","至于那抽签归阿撒泻勒的山羊，却要活活地摆在耶和华面前，用来赎罪，然后叫人把它送到旷野，归阿撒泻勒。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“亚伦要先为自己献上作赎罪祭的公牛，为自己和家人赎罪，他要把那为自己作赎罪祭的公牛宰杀。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","从耶和华面前的祭坛上，拿一个盛满火炭的香炉，又拿一捧捣细的芬芳香料，带进幔子里， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","在耶和华面前把香放在火上，使香的烟云遮掩约柜上的施恩座，免得他死亡。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","他要取些公牛的血，用指头弹在施恩座的东面，再用指头在施恩座的前面，弹血七次。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“然后他要宰杀那为人民作赎罪祭的公山羊，把血带进幔子里，弹羊血在施恩座的上面和施恩座的前面，好像弹公牛的血一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","他要为圣所赎罪，使圣所脱离以色列人的不洁和他们的过犯，就是他们的一切罪孽。然后他又要为会幕同样的赎罪。因为会幕和他们在一起，在他们的不洁中间。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","他进入至圣所赎罪的时候，会幕里不可有人；直到他为自己和家人，以及以色列全体会众，赎了罪出来为止。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","他出来，就到耶和华面前的祭坛那里，为坛赎罪。他要取一点公牛的血和山羊的血，抹祭坛的四角。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","又用指头向祭坛弹血七次，洁净祭坛，使它分别为圣，脱离以色列人的不洁。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“亚伦为圣所、会幕和祭坛赎了罪以后，就要把那只活山羊献上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","亚伦两手按在那只活山羊头上，承认以色列人的一切罪孽和他们的过犯，就是他们一切罪孽。把它们都归在那山羊的头上；然后经由已预定的人，把羊送到旷野里去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","那只山羊就担当他们的一切罪孽，把它们带到一个完全隔离的地；所以那人要把那只山羊送到旷野里去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“亚伦要进会幕，把他进圣所时所穿的细麻布衣服脱下，放在那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","然后在圣洁的地方用水洗身，穿回自己的衣服出来，把自己的燔祭和众民的燔祭献上，为自己和众民赎罪。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","赎罪祭牲的脂肪，他要焚烧在祭坛上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","那送走归阿撒泻勒的山羊的人，要洗净自己的衣服，用水洗身，然后才可以进到营里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","那作赎罪祭的公牛和作赎罪祭的公山羊，它们的血既然被带进去为圣所赎罪，它们的身体就要搬出营外去；它们的皮、肉和粪都要用火烧掉。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","那烧祭牲的人要洗净自己的衣服，用水洗身，然后才可以进营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“每逢七月十日，你们要刻苦己心，无论是本地人，或是寄居在你们中间的外人，什么的工，你们都不可作，这要作你们永远的律例。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","因为在这一天，他要为你们赎罪，使你们洁净，脱离你们一切罪孽，使你们在耶和华面前成为洁净。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","这是完全休歇的安息，你们要刻苦己心。这是永远的律例。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","那被膏立，承受圣职，接替他父亲作祭司的，要穿上细麻布衣服，就是圣洁的衣服，进行赎罪。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","他要为至圣所赎罪，又为会幕和祭坛赎罪，以及为祭司们和全体会众赎罪。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","每年一次，要因以色列人一切的罪，为他们赎罪。这是你们永远的律例。”于是亚伦照着耶和华吩咐摩西的去行。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“你要告诉亚伦和他的儿子，以及以色列人，对他们说：这是耶和华的吩咐： ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","以色列家的任何人，不论在营内，或在营外，宰杀公牛、绵羊或山羊， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","而不牵到会幕门口，耶和华的帐幕面前，献给耶和华作供物，流血的罪就要归到那人身上；他既然流了牲畜的血，就必从自己的族人中被剪除。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","这条例的目的是要以色列人把他们惯常在田野里宰杀的祭牲，带去给耶和华，到会幕门口交给祭司，好像献给耶和华作平安祭那样宰杀牲畜。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","祭司要把血泼在会幕门口耶和华的祭坛上，把脂肪焚烧，献给耶和华作馨香的祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","他们不可再杀祭牲，献给那些山羊，就是他们所随从行邪淫的鬼神。这要作他们世世代代永远的律例。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“你要对他们说：以色列家的任何人，或是在你们中间寄居的外人，献燔祭或是平安祭的时候， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","如果不牵到会幕门口，把它献给耶和华，那人就必从自己的族人中被剪除。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“以色列家的任何人，或是在你们中间寄居的外人，如果吃了任何血，我必向那吃血的人变脸，把他从自己的族人中剪除。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","因为动物的生命是在血里，我指定这祭坛上的血代替你们的生命，因为血里有生命，所以能代赎生命。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","所以我对以色列人说：你们中间任何人都不可吃血，在你们中间寄居的外人也不可吃血。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","任何以色列人，或是在你们中间寄居的外人中，有人打猎得了可以吃的禽兽，总要放尽它的血，用泥土掩盖。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","“因为所有动物的生命就在它们的血中，所以我对以色列人说：任何动物的血，你们都不可吃；因为所有动物的血，就是它的生命；吃血的，必被剪除。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","吃了自死的，或是被野兽撕裂的动物，无论是本地人或是寄居的，都要洗净自己的衣服，用水洗澡，并且不洁净到晚上，以后他才算洁净。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","但是，如果他不洗净衣服，也不洗身，他就要担当自己的罪责。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“你要告诉以色列人，对他们说：我是耶和华你们的　神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","你们从前住过的埃及地，那里的居民的行为，你们不可随从；我要领你们到的迦南地，那里的居民的行为，你们也不可仿效。你们不可跟随他们的风俗行。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","你们要遵行我的典章，谨守我的律例，要遵照奉行；我是耶和华你们的　神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","所以你们要谨守我的律例和典章；人应该遵行这些，按照它们生活，我是耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“你们任何人都不可亲近骨肉之亲，揭露她的下体；我是耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","你不可揭露你父亲的下体，就是你母亲的下体；她是你的母亲，你不可揭露她的下体。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","你父亲的妻子的下体，你不可揭露；那本是你父亲的下体。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","你姊妹的下体，无论是异母同父的，或是异父同母的，是在家里生的，或是在外面生的，你都不可揭露她们的下体。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","你的孙女，或是你的外孙女的下体，你都不可揭露，因为她们的下体就是你自己的下体。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","你的继母为你父亲所生的女儿的下体，是你的妹妹，你不可揭露她的下体。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","你不可揭露你姑母的下体；她是你父亲的骨肉之亲。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","你不可揭露你姨母的下体；她是你母亲的骨肉之亲。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","你不可揭露你叔伯的下体，不可亲近他的妻子，她本是你的婶母。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","你不可揭露你儿媳的下体；她是你儿子的妻子，你不可揭露她的下体。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","你不可揭露你兄弟妻子的下体；那本是你兄弟的下体。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","你不可揭露一个妇人的下体，又揭露她女儿的下体；不可娶她的孙女，或是她的外孙女，揭露她的下体；她们是骨肉之亲，这是丑恶的事。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","妻子还活着的时候，你不可另娶她的姊妹，作她的情敌，揭露她的下体。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“在污秽不洁中的妇女，你不可亲近她，揭露她的下体。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","你不可与你同伴的妻子私通，因她而玷污自己。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","你不可把你的儿子（“儿子”原文作“种子”或“精子”）献给摩洛，也不可亵渎你　神的名；我是耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","你不可与男人同睡交合，像与女人同睡交合一样，这是可憎的事。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","你不可与任何走兽同睡交合，因它而玷污自己；女人也不可站在走兽面前，与它交合；这是逆性的事。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“你们不可让这些事的任何一件玷污自己，因为我将要从你们面前赶出去的各族，就是被这些事玷污了自己。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","连地也被玷污，所以我追讨那地的罪孽，那地就把居民吐出去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","所以，你们要谨守我的律例和典章；这一切可憎的事，无论是本地人或是在你们中间寄居的外人，一件都不可作 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","（因为在你们以前住在那地的人，行了这一切可憎的事，就玷污了自己）； ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","免得你们玷污那地，那地就把你们吐出去，像吐出了在你们以前的各民族一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","无论什么人，行了一件这些可憎的事，必从自己的族人中被剪除。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","所以你们要谨守我的吩咐，免得你们行那些可憎的风俗，就是你们以前的人所行的，玷污了自己。我是耶和华你们的　神。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“你要告诉以色列全体会众，对他们说：你们要分别为圣，因为我耶和华你们的　神是圣洁的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","各人要孝敬父母，也要谨守我的安息日；我是耶和华你们的　神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","你们不可转向偶像，也不可为自己铸造神像；我是耶和华你们的　神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“如果你们献平安祭给耶和华，要使你们所献的蒙悦纳。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","祭牲的肉，要在你们献的那一天和第二天吃；如果有剩下的，到了第三天，就要用火烧掉。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","如果在第三天吃平安祭肉，这祭肉已经成为不洁净，不蒙悦纳。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","那吃祭肉的人，要担当自己的罪责，因为他亵渎了耶和华的圣物；那人必从自己的族人中被剪除。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“你们收割庄稼的时候，不可把角落的谷物都割尽，也不可拾取收割时遗下的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","不可把你葡萄园的果子都摘尽，也不可拾取你葡萄园中掉下的；要把它们留给穷人和寄居的外人；我是耶和华你们的　神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“你们不可偷窃，不可欺骗，不可彼此说谎。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","不可奉我的名起假誓，亵渎你　神的名；我是耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“不可欺压你的邻舍，也不可抢夺他的东西；雇工的工钱，不可扣留在你那里到早晨。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","不可咒骂聋子，也不可把绊脚石放在瞎子面前；却要敬畏你的　神；我是耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“你们审判的时候，不可行不义；不可偏袒穷人，也不可偏帮有权势的人；只要按着公义审判你的邻舍。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","你不可在你的族人中，到处搬弄是非，也不可危害你的邻舍；我是耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“你不可心里恨你的兄弟；应坦诚责备你的邻舍，免得你因他担当罪过。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","不可报复，也不可向你的族人怀恨，却要爱你的邻舍好像爱自己；我是耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“你们要谨守我的律例。不可使你的牲畜与不同类的交合；在你的田里不可撒两种不同类的种子；两样料子作成的衣服，你不可穿在身上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","如果人与女子同睡交合，而那女子是个婢女，已经许配了人，但还没有赎身，或是还没有得着自由，就应受惩罚，但不可把二人处死，因为婢女还没有得着自由。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","那人要把他的赎愆祭，就是一只作赎愆祭的公绵羊，带到会幕门口，耶和华面前。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","祭司要用那只作赎愆祭的公绵羊，在耶和华面前，为他所犯的罪赎罪，他所犯的罪必蒙赦免。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“你们进了那地，栽种了各样可作食物的果树的时候，你们要视初结的果子为不洁净，好像未受割礼的人。头三年的果子，你们不可以吃。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","第四年所结的一切果子，应分别为圣，是作称颂耶和华的供物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","到了第五年，你们才吃树上所结的果子，你们这样作，你们的生产就必增加；我是耶和华你们的　神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“你们不可吃带血的东西，不可占卜，不可算命。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","不可剃两边的头发，胡须的周围也不可刮掉。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","不可为死人的缘故，割伤你们的身体，也不可在你们的身上刺花纹；我是耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“不可辱没你的女儿，使她作娼妓，免得这地淫乱，充满丑恶的事。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","你们要谨守我的安息日，敬畏我的圣所；我是耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“你们不可转向那些交鬼的和行法术的；不可求问他们，玷污自己；我是耶和华你们的　神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“在白发的人面前，你要起立；要尊敬老年人，又要敬畏你的　神；我是耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“如果有外人在你们的地方，与你们一起寄居，你们不可欺负他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","与你们一起寄居的外人，要看他像你们中间的本地人一样；你要爱他好像爱自己，因为你们在埃及地也曾作过寄居的人；我是耶和华你们的　神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“你们审判的时候，在度、量、衡上，都不可偏差。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","要用公正的天平，公正的法码，公正的升斗，公正的容器；我是耶和华你们的　神，就是曾把你们从埃及地领出来的那位。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","你们要谨守遵行我的一切律例和一切典章；我是耶和华。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“你要对以色列人说：任何以色列人，或是在以色列中寄居的外人，把自己的儿子献给摩洛，必要把他处死；本地的人要用石头把他打死。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","我也要向那人变脸，把他从他的族人中剪除，因为他把自己的儿子献给摩洛，玷污了我的圣所，亵渎了我的圣名。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","如果有人把他的儿子献给摩洛，而本地的人掩目不看，不把他处死， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","我就要向那人和他的家族变脸，把他和所有跟随他与摩洛行邪淫的人，都从他们的族人中剪除。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“如果有人转向交鬼的和行法术的，随从他们行淫，我必向那人变脸，把他从他的族人中剪除。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","所以你们要使自己成为圣洁。你们要分别为圣，因为我是耶和华你们的　神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","你们要谨守遵行我的律例，我是使你们分别为圣的耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“咒骂自己父母的，必要把他处死；他咒骂自己的父母，必须承担流血的罪责。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“如果有人与别人的妻子通奸，就是与邻舍的妻子通奸，奸夫和淫妇都要处死。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","如果有人与父亲的妻子同睡，就是揭露了他父亲的下体，必要把他们二人处死；他们必须承担流血的罪责。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","如果有人与儿媳同睡，必要把他们二人处死；他们犯了乱伦的罪，必须承担流血的罪责。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","如果有人与男人同睡，像与女人同睡一样，他们二人行了可憎的事，必要把他们处死，他们必须承担流血的罪责。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","如果有人娶妻，又娶岳母，就是行了丑恶的事，要把他们三人用火烧死，好使你们中间不再有丑恶的事。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","如果有人与走兽同睡，必要把他处死，也要杀死那走兽。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","女人若是亲近任何走兽，与它交合，你们要杀了那女人和走兽；必要把他们处死；他们必须承担流血的罪责。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“如果有人娶了自己的姊妹，无论是异母同父的，或是异父同母的，他见了她的下体，她也见了他的下体，这是可耻的事；他们二人必要从自己族人的眼前被剪除。他揭露了自己姊妹的下体，必须担当自己的罪孽。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","如果有人与患血漏病的妇人同睡，揭露了她的下体，就揭露了她的血源，妇人也揭露了她自己的血源，他们二人必要从自己的族人中被剪除。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","你不可揭露姨母，或是姑母的下体，因为这是揭露了骨肉之亲的下体；这样作的人要担当自己的罪孽。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","如果有人与叔伯的妻子同睡，就是揭露了叔伯的下体，这样作的人要担当自己的罪；他们必无子女而死。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","如果有人娶了兄弟的妻子为妻，这是污秽的事，揭露了自己兄弟的下体；这样作的人必无子女。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“所以你们要谨守遵行我的一切律例和一切典章，免得我将要领你们进去居住的那地，把你们吐出来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","我从你们面前逐出的各民族，你们不可随从他们的风俗；因为他们行了这一切事，所以我厌恶他们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","但我对你们说过，你们要承受他们的土地；我要把这流奶与蜜之地，赐给你们作产业。我是耶和华你们的　神，把你们从万民中分别出来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","所以你们要把洁净的和不洁净的走兽，洁净的和不洁净的飞禽分别出来；你们不可因着那些我为你们分别出来，不洁净的走兽、飞禽，或任何在地上爬行的动物，使自己成为可憎恶的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","你们要归我为圣，因为我耶和华是圣洁的，我把你们从万民中分别出来，使你们归我。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“无论男女，是交鬼的或是行法术的，必要把他们处死，要用石头打死他们；他们必须承担流血的罪责。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","耶和华对摩西说：“你要告诉亚伦子孙作祭司的，对他们说：祭司不可在自己的族人中因死人玷污自己， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","除非骨肉至亲，例如父母、儿女、兄弟， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","或是仍是处女，未曾出嫁的姊妹等至亲，祭司才可以玷污自己。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","祭司不可为了姻亲而玷污，亵渎自己的圣职（全句或译：“祭司既为族人的首领，就不可从俗玷污”）。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","祭司不可剃光头发，胡须的周围不可剃掉，也不可纹身。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","他们要成为圣，归向他们的　神，不可亵渎他们　神的名，因为他们奉献耶和华的火祭，他们　神的食物，所以他们要成为圣。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","祭司不可娶被玷辱了的妓女为妻，也不可娶被丈夫离弃的女人为妻；因为祭司是归他的　神为圣的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","所以你要使他分别为圣，因为他把食物献给你的　神；你要以他为圣，因为我耶和华使你们分别为圣的，是圣洁的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","如果祭司的女儿羞辱自己去作妓女，就是羞辱了自己的父亲；她必须用火烧死。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“在兄弟中作大祭司的，头上倒了膏油，又受了圣职，得以穿着圣衣，就不可披头散发，也不可撕裂衣服。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","不可走近死尸，也不可为了父母玷污自己。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","他不可走出圣所，也不可亵渎他　神的圣所，因为他　神膏立了他，使他分别为圣，我是耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","他要娶处女为妻。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","寡妇、被休的妇人、受玷辱的妓女，他都不可以娶；他只可以娶自己族人中的处女为妻。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","不可在自己的族人中，羞辱他的后裔，因为我是使他们分别为圣的耶和华。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“你要告诉亚伦：你世世代代的后裔中，有残疾的，就不可走近来献他　神的食物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","因为有残疾的，无论是瞎眼、瘸腿、五官不正、畸形、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","断脚断手的、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","驼背、矮小、眼睛有毛病、长癣、生疹，或是肾子损坏的，都不可走近来， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","亚伦祭司的后裔中，有残疾的，都不可上前来献耶和华的火祭；他既有残疾，就不可上前来献他的　神的食物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","他　神的食物，无论是至圣的或是圣的，他都可以吃； ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","只因他有残疾，他就不可进到幔子前，也不可上前到我的祭坛那里，免得亵渎我的圣所；我是使他们分别为圣的耶和华。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","于是摩西告诉亚伦和亚伦的儿子，以及所有以色列人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“你要告诉亚伦和他的儿子，叫他们谨慎处理以色列人分别为圣归给我的圣物，免得他们亵渎我的圣名；我是耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","你要对他们说：你们世世代代的后裔中，若是不洁净，却接近以色列人分别为圣归耶和华的圣物，那人必从我面前被剪除；我是耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","亚伦的后裔中，患了痲风病，或是血漏症的，都不可吃圣物，直到他洁净了；触摸了任何尸体的不洁或遗精的人， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","或是触摸了任何使他玷污的爬虫，或是摸了使他成为不洁净的人（不论那人有什么不洁净）， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","摸了这些的人，必不洁净到晚上；如果他不用水洗身，就不可吃圣物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","日落之后，他就洁净了，可以吃圣物，因为那是他的食物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","自死的或是野兽撕裂的动物，他都不可吃，免得玷污自己；我是耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","他们要谨守我的命令，免得他们因亵渎，担罪而死；我是使他们分别为圣的耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“所有外族人都不可吃圣物；寄居在祭司家里的人或是受雇的雇工，都不可吃圣物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","但是祭司用自己银子买来的仆人，就可以吃圣物；生在祭司家里的人，他们可以吃他的食物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","祭司的女儿若是嫁给外族人，就不可吃举祭的圣物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","但祭司的女儿若是寡妇，或是被休的，而且没有孩子，又回到自己的父家，像她年轻的时候一样，她就可以吃她父亲的食物；只是任何外族人都不可吃。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","人若是误吃了圣物，就要加上五分之一，与圣物一起交给祭司。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","祭司不可亵渎以色列人献上给耶和华的圣物， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","免得他们因吃了圣物而担当罪孽过犯；因为我是使他们分别为圣的耶和华。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“你要告诉亚伦和亚伦的儿子，以及所有以色列人，对他们说：任何以色列家的人，或是在以色列中寄居的外人，奉献供物的时候，无论是为还愿，或是甘心献给耶和华的燔祭， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","就要把没有残疾的公牛，或公绵羊，或公山羊献上，才蒙悦纳。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","有残疾的，你们都不可献上，因为这是不蒙悦纳的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","人若是为了还愿，或是甘心把牛羊献给耶和华作平安祭，总要献上一只完全、没有任何瑕疵的祭物，才蒙悦纳。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","瞎眼、折伤、残废、伤口溃疡、长癣或生疹的牲畜，你们都不可献给耶和华，不可把这些当作火祭放在祭坛上献给耶和华， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","无论是公牛或是绵羊羔，如果肢体畸形或有缺陷的，你可以作甘心祭献上；如果作还愿祭献上，就不蒙悦纳。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","内脏损伤、压碎、破裂，或割掉的，你们都不可献与耶和华；在你们将来居住的地方，你们不可行这样的事； ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","也不可从外人手里接受这一类的牲畜，作你们　神的食物；因为这些都有损坏，有残疾，必不蒙悦纳。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“公牛或是绵羊或是山羊生下来以后，七天要与它的母亲在一起，从第八天开始，它就可以蒙悦纳，作献给耶和华火祭的供物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","无论是牛或羊，你们都不可在同一日之内宰杀母和子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","如果你们献感恩祭给耶和华，要献得可蒙悦纳。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","祭肉要当天吃完，一点都不可留到早晨；我是耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","你们要谨守遵行我的诫命；我是耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","你们不可亵渎我的圣名，我在以色列人中间要被尊为圣；我是使你们分别为圣的耶和华， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","曾把你们从埃及地领出来，要作你们的　神；我是耶和华。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“你要告诉以色列人，对他们说：我指定的节日，就是耶和华指定的节日，你们应当召集圣会。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“六日要工作，但第七日是完全休歇的安息日，应当有圣会；什么工你们都不可作；在你们的一切住处，这日是归耶和华的安息日。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“以下是耶和华的节日，你们在这些指定的日期要召集圣会。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","“正月十四日黄昏的时候，是耶和华的逾越节。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","这月十五日是耶和华的无酵节；你们要吃无酵饼七日。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","第一天应当有圣会，什么劳碌的工你们都不可作。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","这七天你们要每天献火祭给耶和华；第七日应当有圣会，什么劳碌的工你们都不可作。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“你要告诉以色列人，对他们说：你们到了我赐给你们的地，收割庄稼的时候，要把初熟庄稼的一捆带到祭司那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","他要在耶和华面前摇禾捆，在安息日的次日把它摇一摇，使你们蒙悦纳。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","你们摇禾捆的时候，要把一只一岁、没有瑕疵的公绵羊作燔祭献给耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","同献的素祭，是调油的细面两公斤，献给耶和华作馨香的火祭；同献的奠祭，是一公斤酒。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","无论是饼，是烘过的谷粒，或是新穗子，你们都不可吃，直等到你们把　神的供物带来的那天，才可以吃；这要在你们的一切住处，作世世代代永远的律例。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“你们要从安息日的次日，把禾捆带来作摇祭那日起，计算整整七个星期； ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","到第七个星期的次日，共计五十天；那天你们要献新的素祭给耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","要从你们的住处把两个饼带来作摇祭，每个是用细面两公斤，加酵烤成的，当作初熟之物献给耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","你们要把一岁、没有瑕疵的绵羊羔七只，公牛犊一头，公绵羊两只，作献给耶和华的燔祭，它们和同献的素祭、奠祭，是献给耶和华作馨香的火祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","你们又要献一只公山羊作赎罪祭，两只一岁的公绵羊作平安祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","祭司要把这些祭物与初熟祭的饼，一同作摇祭，在耶和华面前摇一摇，这些是耶和华的圣物，应归给祭司。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","在这一天你们要宣布，这是你们的圣会，什么劳碌的工你们都不可作。这要在你们一切住处，作世世代代永远的律例。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“你们收割你们的庄稼的时候，不可把角落的谷物割尽，也不可拾取你收割时遗下的；把它们留给穷人和寄居的外人；我是耶和华你们的　神。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“你要告诉以色列人：七月初一，你们必须完全休歇，要吹号筒作记念，应当有圣会。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","什么劳碌的工你们都不可作；你们要献火祭给耶和华。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“七月初十是赎罪日；你们应当有圣会，要刻苦己心，献火祭给耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","在这一天，什么工你们都不可作，因为这是赎罪日，要在耶和华你们的　神面前为你们赎罪。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","在这一天，不刻苦己心的人，必从他的族人中被剪除。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","在这一天，作什么工的人，我必把他从自己的族人中间消灭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","什么工你们都不可作，这要在你们的一切住处作世世代代永远的律例。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","这是你们完全休歇的安息日，并要刻苦己心；从这月初九晚上，到次日晚上，你们要守安息日。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“你要告诉以色列人：七月十五日是住棚节，要在耶和华面前守这七天的节期。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","第一天应当有圣会；什么劳碌的工你们都不可作。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","这七天你们每天都要献火祭给耶和华；第八天应当有圣会，要献火祭给耶和华，这是集会的日子，什么劳碌的工都不可作。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“以上是耶和华的节日，你们应当召集圣会，照着每日的规定献火祭给耶和华，就是燔祭、素祭、平安祭和奠祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","此外，还有耶和华的安息日，你们的供物，你们的一切还愿祭和甘心献的祭，这些是你们当献给耶和华的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“又在七月十五日，你们收了那地的出产以后，要守耶和华的节七日，第一天要完全休歇，第八天也要完全休歇。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","第一天你们要拿果树的美果、棕树枝、茂密的大树枝和溪边的杨柳枝，在耶和华你们的　神面前欢乐七天。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","你们每年七月，要守耶和华这七天的节期，这是你们世世代代永远的律例。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","你们要住在棚里七天；以色列所有的本地人都要住在棚里， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","好叫你们世世代代知道，我领以色列人出埃及地的时候，曾经使他们住在棚里；我是耶和华你们的　神。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","于是摩西把耶和华指定的节日告诉了以色列人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“你要吩咐以色列人，把点灯用的榨成的纯净橄榄油，拿来给你，使灯火长燃。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","在会幕中法柜的幔子外，亚伦要使这灯在耶和华面前通宵达旦地长燃；这是你们世世代代永远的律例。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","亚伦要不断地在耶和华面前，整理纯金灯台上的灯。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“你要取细面烤成十二个饼，每一个饼用两公斤细面。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","你要把饼摆列成两排，每排六个，放在耶和华面前精金的桌子上； ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","把纯乳香放在每排饼上，象征这些饼作献给耶和华的火祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","每一个安息日，亚伦都要把饼摆在耶和华面前，不可间断，这是以色列人永远的约。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","这饼要归给亚伦和他的子孙，他们要在圣洁的地方吃，因为这是至圣的，在献给耶和华的火祭中，他永远的分。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","有一个以色列妇人的儿子，父亲是埃及人，在以色列人中间出入；这以色列妇人的儿子在营里和一个以色列人争吵； ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","这以色列妇人的儿子亵渎耶和华的名，咒诅耶和华的名，人就把他带到摩西那里。（他母亲名叫示罗密，是但支派底伯利的女儿。） ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","他们拘留看守那人，等候耶和华给他们的指示。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“把那咒诅圣名的人拉出营外，听见的人都按手在他头上。然后全体会众要扔石头打死他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","你要告诉以色列人：咒诅　神的，必担当自己的罪。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","亵渎耶和华圣名的人，必被处死，全体会众要扔石头打他；不论是寄居的外人或是本地人，如果亵渎圣名，必被处死。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","打死人的，必被处死。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","打死牲畜的，必要赔偿牲畜，以命偿命。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","如果有人使他的同伴伤残；他怎样待人，人也必怎样待他； ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","以伤还伤，以眼还眼，以牙还牙；他怎样使人伤残，人也必怎样使他伤残。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","打死牲畜的，必要赔偿牲畜；打死人的，必被处死。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","无论是寄居的或是本地人，你们都应一律对待，因为我是耶和华你们的　神。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","于是摩西告诉了以色列人，他们就把那咒诅圣名的人带出营外，扔石头打死他。以色列人遵行了耶和华给摩西的吩咐。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","耶和华在西奈山对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“你要告诉以色列人，对他们说：你们到了我赐给你们的那地以后，地要守耶和华的安息。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","六年之内，你要耕种田地；六年之内，你要修剪葡萄园，收藏地的出产； ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","但是第七年，地要完全休歇，享受耶和华的安息；你不可耕种田地，也不可修剪葡萄园。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","你收割以后自然生长的庄稼，你不可收割；没有修剪的葡萄树果子，你也不可采摘；这一年，地要完全休歇。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","地在安息年的自然出产，是给你们作食物；就是给你，你的仆婢、雇工和寄居的，就是与你们一起居住的人； ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","甚至你的牲畜，以及你那地的走兽，都以安息年的出产作食物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“你又要为自己计算七个安息年，就是七个七年，你经过了七个安息年，四十九年的日子以后， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","在七月初十，你要吹角，在赎罪日，角声要响遍你的全地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","你们要把第五十年分别为圣，向全地所有居民宣布自由；这一年是你们的禧年，你们各人要归回自己的地业，归回自己的父家。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","第五十年是你们的禧年；这一年你们不可耕种，也不可收割自然生长的，也不可采摘没有修剪的葡萄树果子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","因为这是禧年，你们要当作圣年；你们可以吃地里的出产。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“在这禧年中，你们各人要归回自己的地业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","如果你卖什么给邻舍，或是从邻舍的手里买什么，你们不可欺负对方。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","你要按照下一个禧年以前还剩余的年数向邻舍买；他也要按照这年数可得的出产价值卖给你。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","年数多，你付的买价就要增多。年数少，你付的买价就要减少。因为他是按出产的数值卖给你。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","你们不可欺负对方，却要敬畏你的　神，因为我是耶和华你们的　神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“所以你们要遵行我的律例，谨守我的典章，遵照奉行，就可以在那地安然居住。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","地必生产果实，你们就可以吃饱，在那地安然居住。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","如果你们问：在第七年我们不耕种，也不收藏我们的出产，我们吃什么呢？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","在第六年，我必命我的福临到你们，地就会生产足够三年食用的出产。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","第八年你们耕种时，仍有旧粮吃；直到第九年，收成新粮的时候，你还有旧粮可吃。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“地不可永远卖掉，因为地是我的；你们在我面前不过是寄居的和客旅。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","在你们所得为业的全地，你们应该让人有赎地的权利。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","如果你的兄弟贫穷，卖了部分地业，他的至亲可以来，把兄弟所卖的赎回。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","如果没有代赎人，而他自己的经济能力改善，足够把地赎回， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","他就要计算卖地的年数，把余剩年数的出产数值还给那买主，他就可以收回自己的地业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","如果他没有足够的能力为自己收回卖了的地，他所卖的就要存在买主的手里，直到禧年；到了禧年，买主必须把地归还，卖地的人可以收回自己的地业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“如果有人卖了一所城内的住宅，在卖了以后的一整年之内，他有赎回的权利；在这些日子以内，他随时可赎回。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","如果满了一年期不赎回，那所城内的房屋，就要确定归买主世世代代为业；就算到了禧年，买主也不必交出退还。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","但房屋在四围没有城墙的村庄里，就要算为乡下的田地一样，是可以赎回的；到了禧年，买主要交出退还。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","至于利未人的城，就是他们所得为业的城，其中的房屋，利未人有随时可以赎回的权利。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","如果一个利未人在他所得为业的城里，没有赎回已经卖了的房屋，到了禧年，买主仍要交出退还；因为利未人城里的房屋，是他们在以色列人中的产业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","只是他们城郊之地不可出卖，因为是他们永远的地业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“如果你的兄弟贫穷，在你那里手头拮据，你要资助他，使他可以与你一同生活，像旅客寄居的一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","你不可向他收取高利，却要敬畏你的　神，使你的兄弟可以与你一同生活。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","你借钱给他，不可向他取利息；借粮给他，也不可要他多还。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","我是耶和华你们的　神，曾经把你们从埃及地领出来，要把迦南地赐给你们，而且要作你们的　神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“你的兄弟在你那里若是贫穷了，卖身给你，你不可逼他作奴仆的工作。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","他在你那里要像雇工和寄居的一样；他要服事你直到禧年。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","到了禧年，他和他的儿女要离开你，归回他本家，归回自己祖宗的地业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","因为他们是我的仆人，是我从埃及地领出来的，他们不可以卖作奴仆。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","你不可严严地辖制他，却要敬畏你的　神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","至于你需要的仆婢，可以来自你们四围的列国，你们可以从他们中间购买奴婢。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","你们也可以从那些与你们住在一起的外人的儿女中，或是从他们的家族中，就是那些与你们在一起，在你们境内所生的，购买奴婢；他们要作你们的产业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","你们要把他们留给你们的子孙作永远的产业，你们要从他们中间取奴仆；只是你们的兄弟以色列人，你们却不可苛刻管辖。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“在你中间寄居的外人或是客旅若是富足起来，你的兄弟在他那里却渐渐穷乏，把自己卖给住在你那里寄居的外人或客旅的家族， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","卖了自己以后，他仍有赎回的权利；他兄弟中的任何一个都可以赎他； ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","他的叔伯或是他叔伯的儿子可以赎他，他家族中的骨肉至亲也可以赎他；如果他自己的经济能力改善，也可以自赎。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","他要与买主计算，从卖身那一年起，直到禧年为止；照着年数的多少，按雇工的工价计算赎银。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","如果卖身时还有很多年才到禧年，他就要按着年数，照他卖身的价银按比例偿还他的赎价。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","如果距离禧年只有几年，他就按着年数，与买主计算，按雇工的工价，偿还他的赎价。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","买主要像每年雇用的工人那样待他。不可在你眼前苛刻地管辖他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","如果他不在这些年间把自己赎回，到了禧年，也可以和他的儿女一同离去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","因为以色列人都是属我的仆人；他们是我的仆人，是我把他们从埃及地领了出来的；我是耶和华你们的　神。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“你们不可为自己做偶像，不可为自己立雕像或神柱，也不可在你们的境内安置石像，向它跪拜；因为我是耶和华你们的　神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","你们要遵守我的安息日；敬畏我的圣所；我是耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","你们遵行我的律例，谨守我的诫命，遵照奉行， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","我就按时给你们降下雨露，使地生出土产，田野的树木也结果实。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","你们打禾，必打到摘葡萄的时候，摘葡萄必摘到撒种的时候；你们吃食物，吃得饱足，在你们的境内安然居住。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","我必使你们境内太平；你们睡觉，没有人惊吓你们；我使恶兽在境内绝迹；刀剑也不经过你们的地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","你们必追赶仇敌，他们必在你们面前倒在刀下。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","你们五个人必追赶一百人，一百人必追赶一万人；你们的仇敌必在你们面前倒在刀下。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","我眷顾你们，使你们繁殖增多，也必坚立我与你们所立的约。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","你们吃久藏的旧粮，要挪出旧粮，腾空给新粮。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","我必在你们中间安置我的居所，我的心也不厌弃你们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","我要在你们中间行走；我要作你们的　神，你们要作我的子民。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","我是耶和华你们的　神，曾经把你们从埃及地领出来，使你们不再作他们的奴仆；我折断了你们所负的轭，使你们挺身昂首地行走。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“但如果你们不听从我，不遵行这一切诫命； ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","如果你们弃绝我的律例，你们的心厌弃我的典章，不遵行我的一切诫命，违背我的约， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","我就要这样待你们：我必命惊慌临到你们，痨病热病使你们眼目昏花，心灵憔悴；你们必徒然撒种，因为你们的仇敌必吃尽你们的出产。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","我向你们变脸，你们就败在仇敌面前；恨恶你们的要管辖你们；虽然没有人追赶，你们仍然逃跑。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","经过这些以后，如果你们还不听从我，我就要因你们的罪加重七倍管教你们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","我必粉碎你们夸耀的力量；我要使你们的天像铁，你们的地像铜； ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","你们的气力徒然用尽；你们的地不出产，境内的树也不结果实。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“如果你们行事为人与我的心意相违，不肯听从我，我就要按着你们的罪，使灾祸加重七倍地临到你们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","打发野地的走兽到你们中间，夺去你们的儿女，残害你们的牲畜，减少你们的人口，使你们的道路荒凉。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“但如果你们经过这些事仍然不归向我，行事仍与我的心意相违， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","我也要与你们作对，按着你们的罪，再加重七倍击打你们； ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","使刀剑临到你们，报复背约的仇；聚集你们到城里，好使我打发瘟疫在你们中间，把你们交在仇敌的手里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","我断绝你们的粮食来源以后，十个女人要共用一个炉子给你们烤饼，她们配给定量的饼给你们；你们要吃，却吃不饱。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“如果你们经过这事，还是不听从我，行事仍与我的心意相违， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","我就必发烈怒，与你们作对；我要按着你们的罪，再加重七倍管教你们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","你们要吃自己儿子的肉，女儿的肉也要吃。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","我必毁坏你们的邱坛，砍倒你们的香坛，把你们的尸体扔在你们仆倒的偶像上面；我的心必厌弃你们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","我必使你们的城市变为荒场，使你们的圣所荒凉；我也不闻你们馨香的祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","我要使地荒凉，连住在那里的仇敌也惊奇。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","我要把你们分散在万国中，我又拔出刀来追赶你们；你们的地成为荒凉，你们的城市变成荒场。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","“当那地荒凉，你们又住在仇敌之地的时候，地就享受安息；那地要休歇，享受安息。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","因为你们居住在那里的时候，地不能在你们的安息年中享受安息，唯有在荒凉的日子，才可享安息。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","至于你们剩下的人，我必使他们在仇敌之地胆战心惊；风吹落叶也会吓跑他们；他们必逃跑，好像逃避刀剑一样；虽然无人追赶，他们却跌倒。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","虽然无人追赶，他们却像面临刀剑，彼此撞跌；你们在仇敌面前，不能站立得住。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","你们要在万国中灭亡；仇敌之地必吞灭你们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","你们剩下的人，必因自己的罪孽在仇敌之地消灭，也因犯了祖先的罪孽日渐衰弱。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“那时他们就会承认自己的罪孽和他们祖先的罪孽，就是他们对我不忠的过犯，又承认因为行事与我的心意相违， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","以致我也与他们作对，把他们带到他们的仇敌之地。如果他们未受割礼的心这样谦卑下来，情愿接受他们罪孽的刑罚， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","我就记念我与雅各所立的约，记念我与以撒所立的约，与亚伯拉罕所立的约；我也记念这地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","他们会离开这地，地在荒凉无人的时候，就可以享受安息，同时他们要接受他们罪孽的刑罚，因为他们弃绝了我的典章，他们的心厌弃了我的律例。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","虽然这样，他们住在仇敌之地的时候，我还是不弃绝他们，也不厌弃他们，不把他们灭绝，我不会违背我与他们所立的约；因为我是耶和华他们的　神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","因为他们的缘故，我要记念我与他们祖先所立的约；他们的祖先是我在列国眼前，从埃及地领出来的，为要作他们的　神；我是耶和华。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","这些是耶和华在西奈山，借着摩西颁布他和以色列人之间的律例、典章和法则。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“你要告诉以色列人，对他们说：如果人许特别的愿，献身给耶和华，就要依照你的估价献身价。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","你应该这样估价：从二十岁到六十岁的男人，你要按着圣所衡量银子的标准，估价五百五十克银子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","如果是女人，你要估价三百四十二克银子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","如果是五岁到二十岁，男子的估价是二百二十八克银子，女子是一百一十四克银子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","如果是一个月到五岁，男子的估价是五十七克银子，女子是三十四克银子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","如果是六十岁以上，男子的估价是一百七十一克银子，女子是一百一十四克银子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","那人若是贫穷，不能支付你估定的价，就要把他带到祭司面前，让祭司估定他的价；祭司就按着许愿的人的经济能力，估定他的价。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","如果所许的是可以献给耶和华为供物的牲畜，献给耶和华的任何牲畜，都要分别为圣。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","不可更换，也不可代替；无论是好的换坏的，或是坏的换好的，都不可以。如果人一定要以另一只牲畜代替以前所许的牲畜献上，那么以前所许的和用来交换的，都要分别为圣。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","所许的若是不洁净的牲畜，人不能把它献给耶和华为供物，就是把牲畜牵到祭司面前； ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","祭司要按牲畜的好坏估价；祭司估价多少，就是多少。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","如果他一定要把牲畜赎回，就要按你的估价，多付五分之一。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“如果有人把房屋分别为圣献给耶和华，祭司要按房屋的好坏估价，祭司估价多少，就定它价值多少。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","把自己房屋分别为圣的人，如果要赎回房屋，就要按你估定的价银，多加五分之一，房屋才可以归他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“如果有人把自己产业的一部分，分别为圣献给耶和华，你的估价要根据那地的撒种量：每撒大麦二十公斤，估价五百七十克银子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","如果他从禧年起，把自己的田地分别为圣，就要按照你的估价定那田地的价值。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","如果他在禧年以后，把自己的田地分别为圣，祭司就要照着到下一个禧年所剩余的年数，给他计算价银，然后从你的估价减去这价银。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","把自己田地分别为圣的人，如果一定要赎回田地，就要按你的估价，多付五分之一，田地才可以归他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","如果他不赎回田地，而卖给别人，他就再也不能赎回田地了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","到了禧年，买主就要交出那地归耶和华为圣，像永属耶和华的圣地一样，归祭司为产业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","如果人把买来的田地，不是自己承受为业的田地，分别为圣献给耶和华， ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","祭司就要按照你的估价，给他计算，直到禧年为止；价值多少，他必须当天付给你估定的价银，表示把那地献给耶和华为圣。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","到了禧年，那地要归还卖主，就是归还那承受那地为业的原主。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","你的一切估价，都要照着圣所衡量银子的标准。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“唯独牲畜的头一胎，无论是牛或是羊，既然头一胎是属于耶和华的，人就不能再把它分别为圣，因为这本是耶和华的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","但如果是不洁净的牲畜，他就要按照你的估价，加上五分之一把它赎回；如果不赎回，就要按照你的估价卖掉。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“一切永属耶和华的圣物，就是人永献给耶和华的物，无论是人或是牲畜，或是他承受作产业的田地，都不可以变卖，也不可以赎回；一切永献之物都是归耶和华为至圣的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","如果有人永献牲畜作永属耶和华的圣物，就不可赎回；必须把它杀死。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“地上的一切，无论是地上的种子或是树上的果子，十分之一是耶和华的，是归给耶和华为圣的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","如果人一定要赎回这十分之一，除物价以外，还要加上五分之一。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","牛群和羊群的十分之一，就是一切从牧人杖下经过的，每第十只都是归耶和华为圣的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","人不可理会是好或是坏，也不可把它更换；如果一定要更换，本来的与更换的，都要分别为圣，不能赎回。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","以上这些就是耶和华在西奈山，为以色列人吩咐摩西的律例。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","以色列人出埃及地以后，第二年二月一日，耶和华在西奈的旷野，在会幕里对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“你们要把以色列全体会众，按着他们的宗族、父家，根据人名数目，统计人口；所有男丁，都要按着人口登记。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","在以色列中，凡是二十岁以上，能出去打仗的，你和亚伦要按着他们的队伍数点他们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","每一个支派要有一人帮助你们；他们每一个都是他父家的首领。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","以下就是帮助你们的人的名字：属流本支派的，有示丢珥的儿子以利蓿； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","属西缅支派的，有苏利沙代的儿子示路蔑； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","属犹大支派的，有亚米拿达的儿子拿顺； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","属以萨迦支派的，有苏押的儿子拿坦业； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","属西布伦支派的，有希伦的儿子以利押； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","约瑟的子孙中，属以法莲支派的，有亚米忽的儿子以利沙玛；属玛拿西支派的，有比大蓿的儿子迦玛列； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","属便雅悯支派的，有基多尼的儿子亚比但。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","属但支派的，有亚米沙代的儿子亚希以谢； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","属亚设支派的，有俄兰的儿子帕结； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","属迦得支派的，有丢珥的儿子以利雅萨； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","属拿弗他利支派的，有以南的儿子亚希拉。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","这些人是从会众中选出来，都是他们宗族支派的领袖；他们是以色列的族长。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","于是，摩西和亚伦带着这些提名指定的人， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","在二月一日召集了全体会众；他们就照着他们的宗族，按照他们的父家，根据人名数目，二十岁以上的，都按着人口一一登记了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","耶和华怎样吩咐摩西，摩西就怎样在西奈的旷野数点了他们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","以色列的长子，流本子孙的后代，照着宗族、父家，根据人名数目，按着人口，二十岁以上，能出去打仗的男丁，都登记了； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","流本支派被数点的，共有四万六千五百人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","西缅子孙的后代，照着宗族、父家，根据人名数目，按着人口，二十岁以上，能出去打仗的男丁，都登记了； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","西缅支派被数点的，共有五万九千三百人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","迦得子孙的后代，照着他们的宗族、父家，根据人名数目，二十岁以上，凡是能出去打仗的，都登记了； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","迦得支派被数点的，共有四万五千六百五十人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","犹大子孙的后代，照着他们的宗族、父家，根据人名数目，二十岁以上，凡是能出去打仗的，都登记了； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","犹大支派被数点的，共有七万四千六百人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","以萨迦子孙的后代，照着他们的宗族、父家，根据人名数目，二十岁以上，凡是能出去打仗的，都登记了； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","以萨迦支派被数点的，共有五万四千四百人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","西布伦子孙的后代，照着他们的宗族、父家，根据人名数目，二十岁以上，凡是能出去打仗的，都登记了； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","西布伦支派被数点的，共有五万七千四百人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","约瑟的儿子，以法莲子孙的后代，照着他们的宗族、父家，根据人名数目，二十岁以上，凡是能出去打仗的，都登记了； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","以法莲支派被数点的，共有四万零五百人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","玛拿西子孙的后代，照着他们的宗族、父家，根据人名数目，二十岁以上，凡是能出去打仗的，都登记了； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","玛拿西支派被数点的，共有三万二千二百人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","便雅悯子孙的后代，照着他们的宗族、父家，根据人名数目，二十岁以上，凡是能出去打仗的，都登记了； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","便雅悯支派被数点的，共有三万五千四百人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","但子孙的后代，照着他们的宗族、父家，根据人名数目，二十岁以上，凡是能出去打仗的，都登记了； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","但支派被数点的，共有六万二千七百人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","亚设子孙的后代，照着宗族、父家，根据人名数目，二十岁以上，凡是能出去打仗的，都登记了； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","亚设支派被数点的，共有四万一千五百人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","拿弗他利子孙的后代，照着他们的宗族、父家，根据人名数目，二十岁以上，凡是能出去打仗的，都登记了； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","拿弗他利支派被数点的，共有五万三千四百人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","以上就是被数点的人数，是摩西和亚伦，以及以色列的首领十二人（每父家一人）所数点的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","这样，在以色列中，按着父家，二十岁以上，凡是能出去打仗的以色列人，都登记了； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","被数点的，共有六十万零三千五百五十人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","只有利未人没有按着他们家族的支派，数点在其中。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","因为耶和华曾对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“只有利未支派，你不可数点，也不可把他们的总数列入以色列人中。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","只要派利未人管理法柜的帐幕，和其中的一切器具，以及一切属于帐幕的事物；他们要抬帐幕和其中的一切器具；他们要办理帐幕的事，在帐幕四周安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","帐幕要起行的时候，利未人要把它拆卸下来；帐幕要支搭的时候，利未人要把它竖立起来；如果有外人走近，必须处死。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","以色列人安营，要依照他们的队伍，各归本营，各归本旗。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","但利未人要在法柜帐幕的四周安营，免得　神的忿怒临到以色列的会众；利未人要负看守法柜的帐幕的责任。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","以色列人就这样行了，耶和华怎样吩咐摩西，他们就怎样行。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","耶和华对摩西和亚伦说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“以色列人要各归自己的旗下，在自己父家的旗号下安营；他们要在会幕四周稍远的地方安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","在东方向着日出之地，按着队伍安营的，是犹大营的旗号；犹大人的领袖是亚米拿达的儿子拿顺。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","他的队伍被数点的，共有七万四千六百人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","在他旁边安营的，是以萨迦支派；以萨迦人的领袖是苏押的儿子拿坦业， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","他的队伍被数点的，共有五万四千四百人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","又有西布伦支派；西布伦人的领袖是希伦的儿子以利押。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","他的队伍被数点的，共有五万七千四百人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","凡是属犹大营，按着队伍被数点的，共有十八万六千四百人；他们要首先出发。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","“在南方，按着队伍，是流本营的旗号；流本人的领袖是示丢珥的儿子以利蓿。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","他的队伍被数点的，共有四万六千五百人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","在他旁边安营的，是西缅支派；西缅人的领袖是苏利沙代的儿子示路蔑。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","他的队伍被数点的，共有五万九千三百人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","又有迦得支派；迦得人的领袖是丢珥的儿子以利雅萨。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","他的队伍被数点的，共有四万五千六百五十人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","凡是属流本营，按着队伍被数点的，共有十五万一千四百五十人；他们要作第二队起行。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","“会幕和利未人的营要在众营中间前行；他们怎样安营，就怎样出发前行；各按本位，各归本旗。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","“在西方，按着队伍，是以法莲营的旗号；以法莲人的领袖是亚米忽的儿子以利沙玛。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","他的队伍被数点的，共有四万零五百人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","在他旁边的，是玛拿西支派，玛拿西人的领袖是比大蓿的儿子迦玛列。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","他的队伍被数点的，共有三万二千二百人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","又有便雅悯支派；便雅悯人的领袖是基多尼的儿子亚比但。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","他的队伍被数点的，共有三万五千四百人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","凡是属以法莲营，按着队伍被数点的，共有十万零八千一百人；他们要作第三队起行。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","“在北方，按着队伍，是但营的旗号；但人的领袖是亚米沙代的儿子亚希以谢。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","他的队伍被数点的，共有六万二千七百人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","在他旁边安营的，是亚设支派；亚设人的领袖是俄兰的儿子帕结。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","他的队伍被数点的，共有四万一千五百人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","又有拿弗他利支派；拿弗他利人的领袖是以南的儿子亚希拉。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","他的队伍被数点的，共有五万三千四百人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","凡是属但营被数点的，共有十五万七千六百人；他们要随着自己的旗号，最后起行。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","以上是照着他们的父家被数点的以色列人；所有按着他们的队伍在众营中被数点的，共有六十万零三千五百五十人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","只有利未人没有数点在以色列人中，这是耶和华吩咐摩西的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","以色列人就照着耶和华吩咐摩西的一切行了，他们随着自己的旗号安营，各人按着自己的宗族和父家起行。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","耶和华在西奈山上与摩西说话的日子，亚伦和摩西的后代如下。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","亚伦的儿子的名字如下：长子是拿答，还有亚比户、以利亚撒、以他玛。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","这就是亚伦的儿子的名字，他们是受膏的祭司，是摩西叫他们承受圣职担任祭司的职分的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","拿答和亚比户在西奈旷野把凡火献在耶和华面前的时候，死在耶和华面前；他们没有儿子；以利亚撒和以他玛，就在他们的父亲亚伦面前，担任祭司的职分。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“你要叫利未支派近前来，使他们站在亚伦祭司面前，可以服事他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","他们要替亚伦和全体会众，在会幕前尽上本分，办理帐幕的事。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","他们又要看守管理会幕里的一切器具，也要替以色列人尽上本分，办理帐幕的事。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","你要把利未人派给亚伦和他的儿子，因为他们是从以色列人中选出来完全给他的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","你要委派亚伦和他的儿子，使他们谨守自己祭司的职分；外人走近，必被治死。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","耶和华告诉摩西： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“看哪，我从以色列人中，拣选了利未人，代替以色列人所有头生的，就是他们的长子，所以利未人要归我。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","因为所有头生的，都是我的；我在埃及地击杀所有头生的那天，就把以色列中所有头生的，无论人畜，都分别为圣归我；他们要归我，我是耶和华。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","耶和华在西奈旷野对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“你要照着利未人的父家、宗族，数点他们；所有男丁，一个月以上的，你都要数点。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","于是，摩西照着耶和华的命令，就是耶和华吩咐他的，数点了利未人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","利未众子的名字是：革顺、哥辖、米拉利。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","革顺儿子的名字，按着宗族，是立尼和示每。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","哥辖的儿子，按着宗族，是暗兰、以斯哈、希伯伦、乌薛。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","米拉利的儿子，按着宗族，是抹利、母示。这些人按着他们的父家，都是利未人的宗族。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","属革顺的，有立尼家族和示每家族；这是革顺人的家族。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","根据所有男丁的数目，一个月以上，被数点的，共有七千五百人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","革顺人的家族，要在帐幕的后面，就是西方安营； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","革顺人家族的领袖是拉伊勒的儿子以利雅萨。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","革顺的子孙在会幕中的职分，是看守帐幕、罩棚、罩棚的顶盖和会幕门口的帘子， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","还有院子的帐幕、院子门口的帘子（院子是环绕帐幕和祭坛的），以及院子使用的一切绳子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","属哥辖的，有暗兰家族、以斯哈家族、希伯伦家族和乌薛家族；这是哥辖人的家族。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","根据所有男丁的数目，一个月以上的，共有八千六百人；他们要尽看守圣所的职分。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","哥辖子孙的家族要在帐幕的南方安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","哥辖家族的领袖是乌薛的儿子以利撒反。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","他们的职分是管理约柜、桌子、灯台、两座坛，以及他们在圣所内使用的器具、帘子和帐幕里使用的一切东西。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","亚伦祭司的儿子以利亚撒要作利未人众领袖中的领袖，要监察那些尽看守圣所职分的人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","属米拉利的，有抹利家族和母示家族；这些是米拉利的家族。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","根据所有男丁的数目，一个月以上，被数点的，共有六千二百人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","米拉利二家族的领袖，是亚比亥的儿子苏列；他们要在帐幕的北方安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","米拉利子孙的职分，是看守帐幕的木板、门闩、柱子、插座、一切器具，以及负责一切有关的事务， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","还有看守院子四周的柱子、插座、橛子和绳子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","在帐幕前面东边，就是在会幕向日出的方向安营的，是摩西、亚伦和亚伦的儿子；他们代替以色列人应尽的职责，看守圣所；外人近前来，必被治死。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","摩西和亚伦照着耶和华的命令，数点了所有的利未人；按着家族，凡是男丁，一个月以上被数点的，共有二万二千人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","耶和华对摩西说：“以色列人中所有头生的男子，一个月以上的，你都要数点；登记他们的姓名。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","我是耶和华，你要把利未人归我，代替以色列人所有头生的；也要把利未人的牲畜归我，代替以色列人中一切头生的牲畜。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","摩西就照着耶和华吩咐他的，把以色列人所有头生的都数点了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","根据人名的数目，一个月以上，凡是头生的男子，被数点的，共有二万二千二百七十三个。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“你要拣选利未人代替以色列人所有头生的，也要拣选利未人的牲畜代替以色列人的牲畜；利未人要归我，我是耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","至于那超过利未人总数的二百七十三个，需要赎回的以色列人的长子， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","你要每人收取赎银五十七克，要按照人数，根据圣所的秤收取，就是按照圣所的标准重量（“就是按照圣所的标准重量”，原文作“一舍客勒是二十季拉”）。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","你要把那超额人数的赎银，交给亚伦和他的儿子。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","于是，摩西就从那些被利未人赎回以外的人收取赎银； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","从头生的以色列人收取的银子，根据圣所的秤，共有六百八十二公斤。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","摩西照着耶和华的吩咐，把这赎银交给了亚伦和他的儿子，正如耶和华吩咐摩西的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","耶和华对摩西和亚伦说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“你要从利未人中，登记哥辖子孙的总数，照着他们的家族、父家， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","从三十岁以上，直到五十岁，能进来供职，在会幕里工作的，你都要登记。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","哥辖子孙在会幕里的工作就是管理至圣之物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","起营出发的时候，亚伦和他的儿子要进去，把遮盖至圣所的幔子卸下来，用来遮盖约柜； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","又把海狗皮罩盖在上面，再铺上纯蓝色的布，然后把杠穿上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","在陈设饼的桌子上，他们要铺上蓝色布，把盘子、碟子、杯和奠酒的爵摆在上面，桌子上也必须有常献饼； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","在这些物件上面，他们要铺上朱红色布，再盖上海狗皮罩，然后把杠穿上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","他们要拿蓝色布，把灯台和灯台上的灯盏、剪子、蜡花盘，以及为灯台所用一切盛油的器具遮盖起来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","他们又要把灯台和灯台的一切器具，都包在海狗皮里，然后放在抬架上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","在金坛上面，他们要铺上蓝色布，再盖上海狗皮罩，然后把杠穿上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","他们又要把圣所里供职使用的一切器具，都包在蓝色布里，再盖上海狗皮罩，然后放在抬架上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","他们要清除坛上的灰，把紫色布铺在坛上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","又要把在坛上供职使用的一切器具，就是火鼎、肉叉、铲子、盘子，都摆在上面；再盖上海狗皮罩，然后穿上杠。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","全营出发的时候，亚伦和他的儿子，把圣所和圣所的一切器具遮盖完了以后，哥辖的子孙就要来抬；只是他们不可触摸圣物，免得他们死亡。会幕里这些物件是哥辖的子孙应当抬的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","亚伦祭司的儿子以利亚撒的职务是看管点灯的油、芬芳的香、常献的素祭和膏油，也要看管整个帐幕和其中所有的一切，以及圣所和圣所的器具。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","耶和华对摩西和亚伦说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“你们不可把哥辖家族的派系从利未人中剪除； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","他们接近至圣之物的时候，亚伦和他的儿子要进去，指定他们各人当办的和当抬的工作；你们要这样待他们，好让他们活着，不至死亡； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","只是他们连片刻也不可进去观看圣物，免得他们死亡。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“你也要登记革顺子孙的总数，照着他们的父家、家族， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","从三十岁以上，直到五十岁，能进来供职，在会幕里工作的，你都要数点。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","革顺人的家庭所作的事和所抬的物如下： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","他们要抬帐幕的幔子、会幕和会幕的盖，以及盖在上面的海狗皮罩和会幕的门帘、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","院子的帷子、院子的门帘（院子是围绕帐幕和祭坛的）、绳子，以及一切使用的器具；有关这些器具所当作的，他们都要办理。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","革顺的子孙所有的任务，他们在一切当抬的和当办的事上，都要照着亚伦和他儿子的吩咐；他们当抬的，你们都要把职务分派给他们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","这是革顺子孙的家族在会幕里所办的事；他们的职务要受亚伦祭司的儿子以他玛的管理。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“米拉利的子孙，你也要照着他们的宗族，按着他们的家室数点他们； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","从三十岁以上，直到五十岁，能进来供职，在会幕里工作的，你都要数点。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","他们在会幕里的一切事奉，他们的职务，就是抬帐幕的木板、横闩、柱子和插座、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","院子四周的柱子、插座、橛子、绳子、一切用具和使用的东西；他们当抬的器具，你们要按着名字一一指定。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","这是米拉利子孙的家族在会幕里所办的一切事务，都受亚伦祭司的儿子以他玛的管理。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","摩西、亚伦和会众的领袖们，把哥辖的子孙，按着他们的宗族和父家， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","从三十岁以上，直到五十岁，能进来供职，在会幕里工作的，都数点了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","按着宗族，他们被数点的，共有二千七百五十人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","这是哥辖家族被数点的人数，是所有在会幕里办事的人数，就是摩西和亚伦，照着耶和华借摩西吩咐数点的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","革顺的子孙，按着他们的宗族和父家被数点的， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","从三十岁以上，直到五十岁，能进去供职，在会幕里工作的， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","按着他们的宗族和父家，被数点的人数，共有二千六百三十人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","这些是革顺子孙的家族被数点的人数，是一切在会幕里办事的，就是摩西和亚伦照着耶和华的吩咐数点的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","米拉利的子孙，按着宗族和父家， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","从三十岁以上，直到五十岁，能进去供职，在会幕里工作的，都数点了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","按着宗族，他们被数点的，共有三千二百人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","这些是米拉利子孙的家族被数点的人数，就是摩西和亚伦，照着耶和华的吩咐数点的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","被数点的利未人，就是摩西和亚伦，以及以色列的众领袖，按着宗族和家室数点的， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","从三十岁以上，直到五十岁，可以进去供职，在会幕里作抬物件的工作的， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","他们的人数，共有八千五百八十人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","照着耶和华借摩西吩咐的，把他们数点，各人按着自己所办的事和所抬的物件被数点，正如耶和华吩咐摩西的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“你要吩咐以色列人，把所有患痲风病的，患漏症的，以及因接触死人而不洁的，都送出营外； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","无论男女，你们都要送出去；你们要把他们送出营外，免得他们玷污自己的营，这营就是我居住的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","以色列人就这样行了，把他们送出营外；耶和华怎样吩咐摩西，以色列人就怎样行了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“你要对以色列人说：无论男女，如果犯了人所犯的任何罪，以致得罪耶和华，那人就有了罪； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","他要承认自己所犯的罪，把亏负人的损失，原数赔偿之外，另外加上五分之一，给予他亏负的人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","如果那人没有近亲可以把所亏负的赔偿给他，所亏负的，就要还给耶和华，就是归给祭司，此外还要献上为他赎罪的代罪公绵羊。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","以色列人的一切圣物中，奉给祭司为举祭的，都要归给祭司。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","各人所献的圣物，要归给祭司；人无论献给祭司什么，都要归给祭司。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“你要告诉以色列人说：无论什么人，如果他的妻子背离丈夫，对他不忠， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","有人和她同寝，事情瞒过了丈夫，没有被查出，没有见证人指证她，犯罪时也没有被人捉住； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","如果她的丈夫生了疑心，疑忌妻子，而妻子实在是被玷污了；又或者丈夫生了疑心，疑忌妻子，而妻子并没有被玷污， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","这人就要把妻子带到祭司那里，又要为她带来供物，就是大麦面一公斤，不可浇上油，也不可加上乳香，因为这是疑忌的素祭，是思念的素祭，使人思念罪孽。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“祭司要使那妇人走进来，站在耶和华面前。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","祭司要把圣水盛在瓦器里，又从帐幕的地面取些尘土，撒在水中。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","祭司要使那妇人站在耶和华面前，松开她的头发，把思念的素祭，就是疑忌的素祭，放在她的手中，祭司的手里要拿着使人招致咒诅的苦水。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","祭司要叫那妇人起誓，对她说：‘如果没有人与你同寝，作妻子时没有背弃丈夫被人玷污，你就免受这使人招致咒诅的苦水。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","但是，如果你作妻子时背弃了丈夫，被人玷污了；如果你在你的丈夫以外，曾与别的男人同寝’， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","这样，祭司就要叫那妇人发咒起誓，继续对她说：‘耶和华要使你的大腿消瘦，肚腹肿胀；愿耶和华叫你在你的族人中成为咒诅和起誓的话柄； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","愿这招致咒诅的水进入你的腹中，使你的肚腹肿胀，大腿消瘦。’那妇人要说：‘阿们、阿们。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“祭司要把这些咒诅的话写在卷上，又把所写的字洗在苦水里， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","又要叫那妇人喝这招致咒诅的苦水，这招致咒诅的水要进入她里面，就引起痛苦。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","祭司要从这妇人的手中取过那疑忌的素祭，把素祭在耶和华面前摇一摇，然后带到祭坛那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","祭司要从素祭中取出一把来，作为记念，放在祭坛上焚烧，然后才叫妇人喝这水。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","祭司叫她喝了这水以后，如果她被人玷污，对自己的丈夫不忠，这招致咒诅的水就必进入她里面，引起痛苦；她的肚腹必肿胀，大腿必消瘦；那妇人就要在她的族人中成为咒诅。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","但是，如果这妇人没有被玷污，而是贞洁的，就不致受害，并且要怀孕生子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“这是关于疑忌的律例：妻子在自己丈夫的权下，如果背离丈夫，被人玷污了； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","或是人生了疑忌的心，疑忌自己的妻子，他就要叫那妇人站在耶和华的面前，祭司要对她执行这法例。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","这样，男人可以免罪，妇人就要担当自己的罪孽。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“你要告诉以色列人，对他们说：‘无论男女，如果许了特别的愿，就是拿细耳人的愿，就要离俗归耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","他要戒除淡酒和浓酒；淡酒作的醋和浓酒作的醋，他都不可喝；不可喝任何葡萄汁，也不可吃鲜葡萄或干葡萄。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","在他离俗的日子，葡萄树上出产的，无论是葡萄核或是葡萄，都不可吃。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“‘在他许愿离俗的日子，不可用剃刀剃头；他要圣洁，直到他离俗归耶和华的日子满了，他要由他的头发长长。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","“‘在他离俗归耶和华的日子，不可走近死人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","他的父母、兄弟或是姊妹，死了的时候，他不可因他们玷污自己，因为离俗归他　神的记号，在他的头上； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","在他离俗的日子，他都是归耶和华为圣的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“‘如果在他身旁，突然有人死了，以致他离俗的头被玷污了，他就要在得洁净的日子剃头，就是在第七日剃头。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","第八天，他要把两只斑鸠，或是两只雏鸽，带到会幕门口交给祭司。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","祭司要献一只作赎罪祭，一只作燔祭，为他赎那因死人而玷污的罪；他要在当天使他的头成为圣洁， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","使他重新离俗归耶和华的日子，又要带一只一岁的公羊羔来作赎愆祭；以前的日子无效，因为他的离俗被玷污了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“‘拿细耳人的律例是这样：离俗的人的日子满了那天，人要把他带到会幕的门口； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","他要把供物献给耶和华，就是献一只完全没有残疾、一岁的公羊羔作燔祭，一只完全没有残疾、一岁的母羊羔作赎罪祭，一只完全没有残疾的公绵羊作平安祭， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","一篮无酵调油的细面饼和抹油的无酵薄饼，以及同献的素祭和奠祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","祭司要在耶和华面前献上这些供物，又要献上他的赎罪祭和燔祭； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","他又要把那只公绵羊和那一篮无酵饼，献给耶和华作平安祭；祭司也要把同献的素祭和奠祭献上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","拿细耳人要在会幕门口剃他离俗的头，把他离俗的头发拿去，放在平安祭下的火上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","拿细耳人剃去了自己离俗的头发以后，祭司就要取那煮过的公绵羊的一条前腿，又要从篮子里取一个无酵饼和一个无酵薄饼，都放在拿细耳人的手上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","祭司要把这些作为摇祭，在耶和华面前摇一摇；这些作摇祭献上的胸和作举祭的腿，同为圣物归给祭司；然后拿细耳人才可以喝酒。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“‘许愿的拿细耳人的律例是这样：他献给耶和华的供物是照着他离俗的愿，不是根据他手上所得的；他怎样许愿，就当怎样照着离俗的律例而行。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“你要告诉亚伦和他的儿子说：‘你们要这样为以色列人祝福，对他们说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","愿耶和华赐福你，保护你； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","愿耶和华使他的脸光照你，赐恩给你； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","愿耶和华敞脸垂顾你，赐你平安。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","他们要这样奉我的名为以色列人祝福，我也要为他们祝福。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","摩西竖立了帐幕的那天，就用膏抹它，使它成圣；又把其中的一切器具、祭坛和祭坛的一切器具，都用膏抹了，使它们成圣； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","以色列的众领袖，就是他们父家的首领，都来奉献；就是众支派的领袖，是管理那些被数点的人的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","他们把自己的供物带到耶和华的面前，就是六辆篷车和十二头公牛，每两个领袖奉献一辆篷车，每个领袖奉献一头公牛；他们把这些都送到帐幕的面前。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“你要把这些收下，好作会幕事务的使用；你要把这些交给利未人，要按照各人所办的事务给他们。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","于是摩西收下了车和牛，交给利未人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","他按着革顺子孙所办的事务，把两辆车和四头牛交给他们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","又按着米拉利子孙所办的事务，把四辆车和八头牛交给他们；他们都受亚伦祭司的儿子以他玛的管理； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","但是没有分给哥辖的子孙，因为他们所办的事是圣所的事，是要用肩头抬的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","用膏抹祭坛的日子，众领袖都献上奉献祭坛的礼物；众领袖把自己的供物献在祭坛前。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","耶和华对摩西说：“众领袖要献上自己奉献祭坛的供物，每天要有一位领袖来献上供物。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","头一天献上供物的，是犹大支派的亚米拿达的儿子拿顺。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","他的供物是一个银盘，重一公斤半，一个银碗，重八百克，都是按圣所的秤；这两样都盛满调油的细面作素祭； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","一个金盂，重一百一十克，盛满了香； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","一头公牛犊、一只公绵羊、一只一岁的公羊羔，作燔祭； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","一只公山羊作赎罪祭； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","作平安祭的，是两头公牛、五只公绵羊、五只公山羊、五只一岁的公羊羔；这是亚米拿达的儿子拿顺的供物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","第二天来献的，是以萨迦的领袖，苏押的儿子拿坦业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","他献上的供物是一个银盘，重一公斤半，一个银碗，重八百克，都是按圣所的秤；这两样都盛满调油的细面作素祭； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","一个金盂，重一百一十克，盛满了香； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","一头公牛犊、一只公绵羊、一只一岁的公羊羔，作燔祭； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","一只公山羊作赎罪祭； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","作平安祭的，是两头公牛、五只公绵羊、五只公山羊、五只一岁的公羊羔；这是苏押的儿子拿坦业的供物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","第三天来献的，是西布伦子孙的领袖，希伦的儿子以利押。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","他的供物是一个银盘，重一公斤半，一个银碗，重八百克，都是按圣所的秤；这两样都盛满调油的细面作素祭； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","一个金盂，重一百一十克，盛满了香； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","一头公牛犊、一只公绵羊、一只一岁的公羊羔，作燔祭； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","一只公山羊作赎罪祭； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","作平安祭的，是两头公牛、五只公绵羊、五只公山羊、五只一岁的公羊羔；这是希伦的儿子以利押的供物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","第四天来献的，是流本子孙的领袖，示丢珥的儿子以利蓿。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","他的供物是一个银盘，重一公斤半，一个银碗，重八百克，都是按圣所的秤；这两样都盛满调油的细面作素祭； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","一个金盂，重一百一十克，盛满了香； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","一头公牛犊、一只公绵羊、一只一岁的公羊羔，作燔祭； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","一只公山羊作赎罪祭； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","作平安祭的，是两头公牛、五只公绵羊、五只公山羊、五只一岁的公羊羔；这是示丢珥的儿子以利蓿的供物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","第五天来献的，是西缅子孙的领袖，苏利沙代的儿子示路蔑。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","他的供物是一个银盘，重一公斤半，一个银碗，重八百克，都是按圣所的秤；这两样都盛满调油的细面作素祭； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","一个金盂，重一百一十克，盛满了香； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","一头公牛犊、一只公绵羊、一只一岁的公羊羔，作燔祭； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","一只公山羊作赎罪祭； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","作平安祭的，是两头公牛、五只公绵羊、五只公山羊、五只一岁的公羊羔；这是苏利沙代的儿子示路蔑的供物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","第六天来献的，是迦得子孙的领袖，丢珥的儿子以利雅萨。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","他的供物是一个银盘，重一公斤半，一个银碗，重八百克，都是按圣所的秤；这两样都盛满调油的细面作素祭； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","一个金盂，重一百一十克，盛满了香； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","一头公牛犊、一只公绵羊、一只一岁的公羊羔，作燔祭； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","一只公山羊作赎罪祭； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","作平安祭的，是两头公牛、五只公绵羊、五只公山羊、五只一岁的公羊羔；这就是丢珥的儿子以利雅萨的供物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","第七天来献的，是以法莲子孙的领袖，亚米忽的儿子以利沙玛。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","他的供物是一个银盘，重一公斤半，一个银碗，重八百克，都是按圣所的秤；这两样都盛满调油的细面作素祭； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","一个金盂，重一百一十克，盛满了香； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","一头公牛犊、一只公绵羊、一只一岁的公羊羔，作燔祭； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","一只公山羊作赎罪祭； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","作平安祭的，是两头公牛、五只公绵羊、五只公山羊、五只一岁的公羊羔；这是亚米忽的儿子以利沙玛的供物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","第八天来献的，是玛拿西子孙的领袖，比大蓿的儿子迦玛列。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","他的供物是一个银盘，重一公斤半，一个银碗，重八百克，都是按圣所的秤；这两样都盛满调油的细面作素祭； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","一个金盂，重一百一十克，盛满了香； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","一头公牛犊、一只公绵羊、一只一岁的公羊羔，作燔祭； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","一只公山羊作赎罪祭； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","作平安祭的，是两头公牛、五只公绵羊、五只公山羊、五只一岁的公羊羔；这是比大蓿的儿子迦玛列的供物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","第九天来献供物的，是便雅悯子孙的领袖，基多尼的儿子亚比但。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","他的供物是一个银盘，重一公斤半，一个银碗，重八百克，都是按圣所的秤；这两样都盛满调油的细面作素祭； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","一个金盂，重一百一十克，盛满了香； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","一头公牛犊、一只公绵羊、一只一岁的公羊羔，作燔祭； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","一只公山羊作赎罪祭； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","作平安祭的，是两头公牛、五只公绵羊、五只公山羊、五只一岁的公羊羔；这是基多尼的儿子亚比但的供物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","第十天来献的，是但子孙的领袖，亚米沙代的儿子亚希以谢。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","他的供物是一个银盘，重一公斤半，一个银碗，重八百克，都是按圣所的秤；这两样都盛满调油的细面作素祭； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","一个金盂，重一百一十克，盛满了香； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","一头公牛犊、一只公绵羊、一只一岁的公羊羔，作燔祭； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","一只公山羊作赎罪祭； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","作平安祭的，是两头公牛、五只公绵羊、五只公山羊、五只一岁的公羊羔；这是亚米沙代的儿子亚希以谢的供物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","第十一天来献的，是亚设子孙的领袖，俄兰的儿子帕结。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","他的供物是一个银盘，重一公斤半，一个银碗，重八百克，都是按圣所的秤；这两样都盛满调油的细面作素祭； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","一个金盂，重一百一十克，盛满了香； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","一头公牛犊、一只公绵羊、一只一岁的公羊羔，作燔祭； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","一只公山羊作赎罪祭； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","作平安祭的，是两头公牛、五只公绵羊、五只公山羊、五只一岁的公羊羔；这是俄兰的儿子帕结的供物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","第十二天来献的，是拿弗他利子孙的领袖，以南的儿子亚希拉。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","他的供物是一个银盘，重一公斤半，一个银碗，重八百克，都是按圣所的秤；这两样都盛满调油的细面作素祭； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","一个金盂，重一百一十克，盛满了香； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","一头公牛犊、一只公绵羊、一只一岁的公羊羔，作燔祭； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","一头公山羊作赎罪祭； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","作平安祭的，是两头公牛、五只公绵羊、五只公山羊、五只一岁的公羊羔；这是以南的儿子亚希拉的供物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","用膏抹祭坛的日子，以色列的众领袖献上奉献祭坛的供物，共有银盘十二个、银碗十二个、金盂十二个， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","每个银盘重一公斤半，每个银碗重八百克；一切器皿的银子，按圣所的秤，共有二十七公斤零六百克； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","金盂十二个，盛满了香，按圣所的秤，每个金盂重一百一十克；这些金盂的金子，共有一公斤零三百二十克； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","作燔祭的牲畜，共有公牛犊十二头、公绵羊十二只、一岁的公羊羔十二只，还有同献的素祭，以及作赎罪祭的公山羊十二只； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","作平安祭的牲畜，共有公牛二十四头、公绵羊六十只、公山羊六十只、一岁的公羊羔六十只；这就是用膏抹祭坛以后，所献上奉献祭坛的供物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","摩西进入会幕要与耶和华说话的时候，就听见法柜的施恩座上，二基路伯中间，有与他说话的声音，是耶和华与他说话。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“你要告诉亚伦：‘你点灯的时候，七盏灯都要照向灯台的前面。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","亚伦就这样行了；他把灯台上的灯都点着了，使光照向灯台的前面，正如耶和华吩咐摩西的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","这灯台的做法是这样：是用金子锤出来的，从座到花都是锤出来的。摩西制造灯台，是照着耶和华指示的样式做的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“你要从以色列人中间选出利未人，洁净他们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","你洁净他们当这样行：要把除罪水洒在他们身上，又叫他们用剃刀剃全身；把衣服洗净，洁净自己。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","然后，叫他们取一头公牛犊和同献的素祭，就是用油调和的细面；你要另取一头公牛犊，作赎罪祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","你要把利未人带到会幕前面，又要召集以色列的全体会众； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","你要把利未人带到耶和华面前，以色列人要按手在他们身上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","亚伦要把利未人献在耶和华面前，作以色列人中的摇祭，使他们办理耶和华的事务。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","利未人要按手在那两头牛的头上；你要把一只作赎罪祭，一只作燔祭，献给耶和华，为利未人赎罪。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","你又要叫利未人站在亚伦和他的儿子们面前，把他们作摇祭献给耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","“这样，你要把利未人从以色列人中分别出来，利未人就要归我。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","以后，利未人可以进去办理会幕的事；你要洁净他们，把他们作摇祭献上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","因为他们是以色列人中完全献给我的；我选出了他们归我，是代替以色列人中所有头生的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","因为以色列人中所有头生的，连人带畜都是我的；我在埃及地击杀所有头生的那一天，就把他们分别为圣归我了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","我选出了利未人，代替以色列人中所有头生的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","我从以色列人中，把利未人赐给亚伦和他的众子，在会幕里办理以色列人的事务，又为以色列人赎罪，免得他们走近圣所的时候，就有灾祸临到他们。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","摩西、亚伦和以色列的全体会众，就向利未人这样行了；耶和华指着利未人吩咐摩西的，以色列人都照样向他们行了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","于是利未人洁净了自己，把衣服洗净；亚伦把他们作摇祭献在耶和华面前；亚伦又为他们赎罪，洁净他们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","然后，利未人才进去，在亚伦和他的众子面前，在会幕里办理他们的事务；耶和华指着利未人怎样吩咐摩西，以色列人就怎样向他们行了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“关于利未人的职责是这样：从二十五岁以上的，要进来办理会幕里的事务； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","到了五十岁，就要停止办理事务，不再办事； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","只要在会幕里帮助自己的兄弟，尽忠职守，事务却不必办理了。关于利未人的职守，你要这样向他们行。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","以色列人出埃及地以后，第二年正月，耶和华在西奈旷野吩咐摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“以色列人要在指定的时间守逾越节， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","就是本月十四日，黄昏的时候，你们要在指定的时间守这节，要照着这节的一切律例和一切典章而行。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","于是，摩西吩咐以色列人要守逾越节。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","他们就在正月十四日，黄昏的时候，在西奈旷野守了逾越节；耶和华怎样吩咐了摩西，以色列人就怎样行了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","有几个人因为触着死人而不洁净，以致他们不能在那一天守逾越节；当日他们来到摩西和亚伦面前。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","这些人对摩西说：“我们虽然因为接触死人而不洁净，为什么我们被拒绝，不能在以色列人中，在指定的时间献耶和华的供物呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","摩西对他们说：“你们且等候，我要去听耶和华对你们有什么吩咐。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“你要告诉以色列人说：你们或你们的后代中，如果有人因为接触死人而成为不洁净，或因到远方旅行，他还要向耶和华守逾越节； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","他们要在二月十四日，黄昏的时候，守逾越节，同时要吃无酵饼和苦菜； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","一点也不留到早晨，羊羔的骨头，一根也不可折断；他们要照着逾越节的一切律例守节。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","但那洁净的，又不在路上旅行的人，如果忽略守逾越节，那人就要从自己的民中被剪除，因为他没有在指定的时间内献上耶和华的供物，那人必担当自己的罪。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","如果有外人寄居在你们中间，想要向耶和华守逾越节，他就必须照着逾越节的条例和典章而行；不论是外人或是本地人，只有一样的条例。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","在竖立帐幕的那一天，有云彩遮盖着帐幕，就是法柜的帐幕；到了晚上，云彩在帐幕上，形状像火，直到早晨。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","常常是这样：白天有云彩遮盖帐幕，夜间云彩形状像火。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","云彩什么时候从会幕上收去，以色列人就起行；云彩在什么地方停住，以色列人就在那里安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","以色列人照着耶和华的吩咐起行，也照着耶和华的吩咐安营；云彩在帐幕上停留多久，他们就安营多久。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","如果云彩多日停留在帐幕上，以色列人就遵守耶和华的吩咐，不起行。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","有时云彩停留在帐幕上只有几天，他们就照着耶和华的吩咐安营；也照着耶和华的吩咐起行。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","有时云彩从晚上到早晨停住；到了早晨，云彩一收上去，他们就起行；有时云彩从白昼到晚上都停住；云彩一收上去，他们就起行。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","云彩停留在帐幕上不论有多久，或两天、或一月、或一年，以色列人就安营，不起行；云彩一收上去，他们就起行。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","他们照着耶和华的吩咐安营，也照着耶和华的吩咐起行。他们遵守耶和华吩咐的，就是照着耶和华借摩西吩咐的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“你要用银子作两枝号，要锤出来的，可以用来召集会众，也可以叫会众拔营起行。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","吹号的时候，全体会众都要到你那里，聚集在会幕的门口。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","如果单吹一枝，众领袖，就是以色列的族长，都要到你那里聚集。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","你们吹大声的时候，那在东边的营，都要起行。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","你们第二次吹大声的时候，那在南边的营，都要起行；他们要起行，必须吹大声。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","但召集会众的时候，你们要吹号，却不要吹大声。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","亚伦的子孙作祭司的要作吹号的；这要作你们世世代代永远的条例。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","你们在本地与欺压你们的仇敌作战的时候，就要吹大声，使你们在耶和华你们的　神面前得蒙记念，也得拯救脱离你们的仇敌。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","此外，在你们快乐的日子和指定的节期，以及月朔，你们献燔祭和平安祭的时候，也要吹号，这都要在你们的　神面前替你们作为记念；我是耶和华你们的　神。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","第二年二月二十日，云彩从法柜的帐幕收上去的时候， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","以色列人就从西奈旷野按站起行；云彩在巴兰旷野停住了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","这是他们第一次照着耶和华借摩西吩咐他们的起程。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","犹大营的旗号，按着他们的队伍，首先起行；统领队伍的，是亚米拿达的儿子拿顺。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","统领以萨迦支派队伍的，是苏押的儿子拿坦业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","统领西布伦支派队伍的，是希伦的儿子以利押。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","帐幕拆下来以后，革顺的子孙和米拉利的子孙，就抬着帐幕起行。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","流本营的旗号，按着他们的队伍起行；统领队伍的，是示丢珥的儿子以利蓿。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","统领西缅支派的，是苏利沙代的儿子示路蔑。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","统领迦得支派队伍的，是丢珥的儿子以利雅萨。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","哥辖人抬着圣物起行；他们到达之前，人已经把帐幕竖立起来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","以法莲营的旗号，按着他们的队伍起行；统领队伍的，是亚米忽的儿子以利沙玛。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","统领玛拿西支派队伍的，是比大蓿的儿子迦玛列。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","统领便雅悯支派队伍的，是基多尼的儿子亚比但。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","但营的旗号，作众营的后队，按着他们的队伍起行；统领队伍的，是亚米沙代的儿子亚希以谢。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","统领亚设支派队伍的，是俄兰的儿子帕结。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","统领拿弗他利支派队伍的，是以南的儿子亚希拉。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","这是以色列人起行的时候，按着他们的队伍起行的次序。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","摩西对自己的岳父米甸人流珥的儿子何巴说：“我们要起行到耶和华应许的地方去，他曾说：‘我要把那地赐给你们’，现在求你与我们同去，我们必善待你，因为耶和华对以色列已经应许福乐。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","何巴对摩西说：“我不去，我要归回我本地本族那里去。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","摩西说：“求你不要离开我们，因为你知道我们应怎样在旷野安营，你可以作我们的眼目。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","如果你与我们同去，将来耶和华用什么好处待我们，我们也必用什么好处待你。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","以色列人从耶和华的山起行，行了三天的路程，耶和华的约柜在他们前面行了三天的路程，为他们寻找安息的地方。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","他们拔营起行的时候，日间总有耶和华的云彩在他们上头。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","约柜起行的时候，摩西就说：“耶和华啊，求你起来，愿你的仇敌四散；愿恨你的人从你面前逃跑。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","约柜停住的时候，他就说：“耶和华啊，求你归来，回到以色列的千万人中。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","人民发怨言，恶声达到耶和华的耳中；耶和华听见了，就发烈怒；耶和华的火就在他们中间焚烧，烧毁了营地的边界。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","人民向摩西呼求，摩西恳求耶和华，火就熄了， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","就称那地方作他备拉，因为耶和华的火曾在他们中间焚烧。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","他们中间的闲杂人起了贪欲，甚至连以色列人也哭着说：“谁给我们肉吃呢？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","我们记得在埃及的时候，可以不花钱吃鱼，还有黄瓜、西瓜、韭菜、葱和蒜。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","现在我们的心都枯干了；除了这吗哪以外，在我们眼前，什么都没有。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","这吗哪仿佛芫荽子，又好像珍珠。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","人民走来走去，把吗哪拾起来，或用磨磨碎，或用臼捣碎，或用锅煮，或做成饼，它的滋味好像油饼的滋味。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","夜间露水降在营上的时候，吗哪也随着降下来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","摩西听见人民都在各人的帐棚门口哀哭，耶和华就大发烈怒，摩西也不高兴。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","摩西对耶和华说：“你为什么苦待你的仆人，为什么我没有在你面前蒙恩呢？竟把管理这人民的重担全放在我身上呢？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","这人民岂是我怀的胎，岂是我生的吗？你竟对我说：‘把他们抱在怀里，像养育之父抱吃奶的孩子，直抱到你起誓应许给他们们列祖的地方去。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","我从哪里得肉给这人民吃呢？因为他们都向我哭着说：‘你给我们肉吃吧！’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","我不能独自担当管理这人民的责任，因为实在太重了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","你既然这样待我，如果我在你面前蒙恩，求你把我杀了，免得我看见自己的苦楚。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","耶和华对摩西说：“你要从以色列的长老中为我召聚七十个人，就是你认识的民间的长老和官长，领他们到会幕那里，叫他们与你一同站在那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","我要在那里降临，与你说话，也要把在你身上的灵，分给他们，他们就与你一同担当管理人民的责任，免得你独自担当。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","你要对人民说：‘你们应当自洁，预备明天可以吃肉，因为你们哭着向耶和华说：“谁给我们肉吃呢？”所以耶和华必给你们肉吃。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","你们不是吃一天两天，不是吃五天十天，也不是吃二十天， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","而是吃一个整月，直到肉从你们的鼻孔里喷出来，成为你们厌恶的东西；因为你们轻视了住在你们中间的耶和华，在他面前哭着说：“我们为什么出埃及呢？”’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","摩西说：“这与我同住的人，能行的男人就有六十万，你还说：‘我要给他们肉吃，使他们可以吃一个整月。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","难道把羊群和牛群都给他们宰了，就够他们吃吗？或是把海里所有的鱼都给他们聚了来，就够他们吃吗？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","耶和华对摩西说：“耶和华的手臂缩短了吗？现在你要看看我的话应验不应验。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","于是摩西出来，把耶和华的话告诉人民，又从民间的长老中召聚了七十个人来，使他们站在会幕的周围。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","耶和华在云中降临，对摩西说话，把摩西身上的灵，分给那七十个长老；灵停在他们身上的时候，他们就说预言，以后却没有再说。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","那时还有两个人留在营里；一个名叫伊利达，一个名叫米达；灵也停在他们身上。他们原是在被录取的人中，却没有到会幕那里去；他们就在营里说预言。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","有个少年人跑来，告诉摩西：“伊利达和米达在营中说预言。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","摩西的侍从，嫩的儿子约书亚，就是摩西所拣选的，回答说：“我主，摩西，请你制止他们。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","摩西对他说：“你为我的缘故嫉妒吗？但愿耶和华的人民都是先知，但愿耶和华把他的灵降在他们身上。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","于是摩西和以色列的长老，都回营去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","有风从耶和华那里吹起，把鹌鹑由海面刮来，散落在营地；鹌鹑在营的四周，这边约有一天的路程，那边约有一天的路程，离地面约有一公尺。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","人民起来，那一天终日终夜，并次日一整天，都在捕捉鹌鹑，最少的也捕捉了约二千公升；他们都摆在营地的四周。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","肉在他们牙齿之间，还没有嚼烂，耶和华的怒气就向人民发作，用极重的灾祸击打他们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","于是那地方名叫基博罗．哈他瓦，因为他们在那里埋葬起了贪欲的人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","人民从基博罗．哈他瓦起行，到哈洗录去，就住在哈洗录。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","米利暗和亚伦，为了摩西所娶的古实女子的缘故，就出言反对摩西，因为他娶了一个古实女子为妻。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","他们说：“难道耶和华单单与摩西说话，不也与我们说话吗？”这话耶和华听见了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","摩西为人十分谦和，胜过世上所有的人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","耶和华忽然对摩西、亚伦和米利暗说：“你们三个人都出来，到会幕那里去。”他们三个人就出来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","耶和华在云柱中降临，停在会幕门口，呼召亚伦和米利暗；他们二人就前去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","耶和华说：“现在你们要听我的话，如果你们中间有先知，我耶和华必在异象中向他显现，在梦中与他说话。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","可是，对我的仆人摩西却不是这样，他是在我全家忠心的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","我要与他面对面说话，是亲自说的，不是用谜语；他必看见耶和华的形象，你们出言反对我的仆人摩西，为什么不惧怕呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","耶和华向他们发怒，就走了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","云彩从会幕上离开，米利暗就长了大痲风，像雪那样白；亚伦转身过来看米利暗，见她长了大痲风。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","亚伦就对摩西说：“我主啊，求你不要因我们行事愚昧所犯的罪，就把这罪加在我们身上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","求你不要叫她像个死胎，一出母腹，肉就半腐烂了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","于是摩西向耶和华哀求，说：“　神啊，求你医好她。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","耶和华对摩西说：“如果她的父亲吐唾沫在她脸上，她不是要蒙羞七天吗？现在把她关在营外七天，然后才让她回来。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","于是米利暗被关在营外七天；人民没有启程，直到把米利暗接回来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","然后，人民从哈洗录起行，在巴兰的旷野安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“你要派人窥探我赐给以色列人的迦南地；按着父家所属的支派，每支派要派一个人，个个都必须是他们的领袖。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","摩西就照着耶和华的吩咐，从巴兰的旷野派他们去了；他们都是以色列人的领袖。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","以下是他们的名字：属流本支派的是撒刻的儿子沙母亚。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","属西缅支派的是何利的儿子沙法。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","属犹大支派的是耶孚尼的儿子迦勒。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","属以萨迦支派的是约色的儿子以迦。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","属以法莲支派的是嫩的儿子何西亚。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","属便雅悯支派的是拉孚的儿子帕提。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","属西布伦支派的是梭底的儿子迦叠。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","属约瑟支派的，就是属玛拿西支派的，是苏西的儿子迦底。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","属但支派的是基玛利的儿子亚米利。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","属亚设支派的是米迦勒的儿子西帖。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","属拿弗他利支派的是瓦缚西的儿子拿比。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","属迦得支派的是玛基的儿子臼利。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","以上是摩西派去窥探那地的人的名字。摩西称嫩的儿子何西亚为约书亚。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","摩西派他们去窥探迦南地，对他们说：“你们要从这里上南地，然后上山地去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","看看那地怎样，住在那里的人是强是弱，是多是少； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","看看他们住的地怎样，是好是坏；看看他们所住的城镇怎样，是营地，还是城堡； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","看看那地怎样，是肥沃还是贫瘠，那里有树木没有。你们要壮胆，把那地的果子带些回来。”那时正是葡萄初熟的时候。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","他们上去窥探了那地，从寻的旷野到利合，直到哈玛关口。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","他们上到南地，到了希伯仑，在那里有亚衲族人的后裔亚希幔、示筛、挞买。原来希伯仑城比埃及的琐安城早建七年。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","他们来到以实各谷，从那里砍下了一根葡萄枝子，上头只有一挂葡萄，两个人用杠抬着回来；他们也带了些石榴和无花果回来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","因为以色列人从那里砍来的那挂葡萄，所以那地方叫作以实各谷。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","四十天以后，他们窥探那地完毕，就回来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","他们来到了巴兰旷野的加低斯，见摩西、亚伦和以色列的全体会众，向摩西、亚伦及全体会众报告，又把那地的果子给他们看。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","他们告诉摩西：“我们到了你派我们去的那地，果然是流奶与蜜的地，这就是那地的果子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","只是住在那地的人强壮，城又坚固又十分高大，并且我们在那里也看见了亚衲族人的后裔。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","有亚玛力人住在南地；赫人、耶布斯人、亚摩利人住在山地；迦南人住在海边和约旦河沿岸。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","迦勒在摩西面前使众人镇静，说：“我们立刻上去，占领那地吧！因为我们必能得胜。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","但是，那些与他同去的人却说：“我们不能上去攻击那民，因为他们比我们强。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","那些探子就他们窥探之地向以色列人报恶信，说：“我们经过要窥探的地方，是个吞吃居民的地方；我们在那里看见的人，个个都高大。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","在那里我们看见了巨人，就是亚衲人的子孙，是巨人的后裔；我们看自己好像是蚱蜢，他们看我们也是这样。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","当时，全体会众大声喧嚷；那夜众民都哭号。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","以色列人向摩西和亚伦发怨言；全体会众都对他们说：“但愿我们早死在埃及地，或死在这旷野。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","耶和华为什么把我们领到这地来，死在刀剑之下呢？我们的妻子和孩子要被掳掠。我们回埃及去，岂不更好吗？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","于是他们彼此说：“我们另立一个首领，回埃及去吧。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","摩西和亚伦就俯伏在以色列全体会众面前。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","窥探那地的人中，有嫩的儿子约书亚和耶孚尼的儿子迦勒；他们撕裂衣服， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","对以色列全体会众说：“我们去窥探的那地，是十分美好的地方。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","耶和华若是喜悦我们，就必把我们领进那地，把那地赐给我们，那地原是流奶与蜜的地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","只要你们不背叛耶和华，就不必怕那地的人，因为他们是我们的食物；荫庇他们的，已经离开他们了，耶和华却与我们同在；不要怕他们。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","全体会众都说要用石头打死他们二人。这时，耶和华的荣光在会幕中向以色列众人显现。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","耶和华对摩西说：“这民藐视我要到几时呢？我虽然在他们中间行了这些神迹，他们还是不信我要到几时呢？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","我要用瘟疫击杀他们，除灭他们；我要使你成为大国，比他们还强。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","摩西对耶和华说：“这样埃及人必听见这事，因为你曾用大能，把这民从他们中间领上来； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","埃及人也必告诉那地的居民。那地的居民也曾听见你耶和华是在这人民中间，你耶和华曾面对面的向人显现，你的云彩常停在他们上面；日间你在云柱中，夜间你在火柱中，走在他们前面。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","现在如果你把这人民杀死，像杀死一人，那些听见你名声的万国就必议论说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘因为耶和华不能把这民领进他向他们起誓应许的地，所以在旷野把他们杀了。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","现在求主大发能力，照着你说过的话： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘耶和华不轻易发怒，且有丰盛的慈爱；他赦免罪孽和过犯；绝不以有罪的为无罪，必追讨罪孽，自父到子，直到三四代。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","求你照着你的大慈爱，饶恕这人民的罪孽，好像你从埃及直到现在，常赦免这人民一样。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","耶和华说：“我就照着你的话，赦免他们； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","但是，我指着我的永生起誓，全地要被耶和华的荣耀充满。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","这些见过我的荣耀，和我在埃及与旷野所行的神迹的人，仍然试探了我这十次，不听从我的话； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","他们决不得看见我向他们的祖宗起誓应许之地；藐视我的，一个也不能看见那地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","但是我的仆人迦勒，因他另有一个心志，专心跟从我，我必把他领进他去过的那地；他的子孙也必得着那地为业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","现在亚玛力人和迦南人住在山谷中，明天你们要回转，从到红海路上，起行到旷野去。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","耶和华吩咐摩西和亚伦说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“这恶会众向我发怨言要到几时呢？以色列人向我所发的怨言，我都听见了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","你要对他们说：‘耶和华说，我指着我的永生起誓，我必照着你们所说给我听的，对待你们： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","你们的尸体必倒在这旷野；你们中间被数点过的，就是按着你们的数目，从二十岁以上，向我发过怨言的， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","都不得进入我起誓给你们居住的那地；只有耶孚尼的儿子迦勒和嫩的儿子约书亚才可以进去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","但是你们的孩子，就是你们所说他们必被掳掠的，我要把他们领进去，他们必得着你们厌弃的那地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","至于你们，你们的尸体必倒在这旷野。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","你们的儿女必在旷野飘流四十年，担当你们背信之罪，直到你们的尸体在旷野都灭尽了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","照着你们窥探那地的日数共四十天，一天算一年，你们要担当罪孽四十年，你们就知道我为什么与你们作对。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","我耶和华已经说了，我必要这样对待这聚集反抗我的恶会众；他们要在这旷野灭尽，在这里死亡。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","摩西派去窥探那地的人回来，因为带回有关那地的恶信，以致全体会众都向摩西发怨言， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","这些带回有关那地的恶信的人，都遭受瘟疫死在耶和华面前。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","只有嫩的儿子约书亚和耶孚尼的儿子迦勒，仍然活着。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","摩西把这些话告诉以色列众人，他们就非常悲哀。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","他们清早起来，上山顶去，说：“我们在这里；我们要上耶和华应许的地方去，因为我们犯了罪。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","摩西说：“你们为什么又违背耶和华的命令呢？这事必不能成功。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","你们不要上去，因为耶和华不在你们中间，免得你们在仇敌面前被杀败。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","因为亚玛力人和迦南人都在那里，在你们面前，你们必倒在刀下；因为你们转离不跟随耶和华，耶和华不与你们同在。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","他们却擅自上山顶去，但是耶和华的约柜和摩西并没有离开营地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","于是，亚玛力人和住在那山上的迦南人就下来，击杀他们，粉碎他们，直到何珥玛。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“你要告诉以色列人：你们进入我赐给你们居住之地的时候， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","如果要从牛群或羊群，拿牛羊作火祭献给耶和华，无论是燔祭，或是其他的祭，为要还特许的愿，或是作甘心的祭，或是在你们的节期献上的，都要献给耶和华作为馨香的祭； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","那献供物的，要把一公斤细面和一公斤油调和作素祭，献给耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","此外，无论是燔祭或是别的祭，为每只绵羊羔你要一同献上一公升作奠祭的酒。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","或是为每只公绵羊，你要一同献上两公斤细面，用一公升半油调和作素祭； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","你也要用一公升半酒作奠祭，献给耶和华作馨香的祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","你若是预备公牛犊作燔祭，或是别的祭，为要还特许的愿，或是作平安祭，献给耶和华， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","就要把三公斤细面，用两公升油调和作素祭，和公牛犊一同献上； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","也要用两公升酒作奠祭，献给耶和华为馨香的火祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","“献一头公牛，或一只公绵羊，或一只绵羊羔，或一只山羊羔，都要这样办理。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","照着你们预备的数目，每只都要这样办理。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","本地人献馨香的火祭给耶和华，都要这样办理。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","如果有外人与你们同住，或有人世世代代住在你们中间的，要献馨香的火祭给耶和华；你们怎样办理，他也要怎样办理。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","至于全众，无论是你们，或是与你们同住的外人，都一样的规例，作你们世世代代永远的规例；在耶和华面前，你们怎样，寄居的人也怎样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","你们和住在你们中间的外人，都只有一样的法规，一样的典章。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“你要告诉以色列人：你们到了我领你们进去的那地， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","吃那地的粮食的时候，就要把举祭献给耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","你们要用初熟的麦面作饼当举祭献上，你们献时，好像献上禾场的举祭一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","你们世世代代要把初熟的麦面作举祭献给耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“如果你们作错了事，没有守耶和华吩咐摩西的这一切命令， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","就是耶和华借摩西吩咐你们的一切事，从耶和华吩咐的那一天起，直到你们的世世代代； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","如果有无心之失，是会众不知道的，全体会众就要把一头公牛犊作燔祭，作为献给耶和华馨香的祭，并且照着规章把素祭和奠祭一同献上，又献一只公山羊作赎罪祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","祭司要为以色列全体会众赎罪，他们就必蒙赦免；因为这是无心之失，他们又因自己的无心之失，把供物，就是献给耶和华的火祭和赎罪祭，一起奉到耶和华面前， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","以色列全体会众和寄居在他们中间的外人，就必蒙赦免，因为全体人民都犯了无心之失。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“如果一个人误犯了罪，他就要献一只一岁的母山羊作赎罪祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","祭司要在耶和华面前为那误犯的人赎罪，因为他犯罪是出于无心；祭司为他赎罪，他就必蒙赦免。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","对于犯了无心之失的人，无论是本地人或是寄居在他们中间的外人，都有一样的法例。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","但那胆大妄为的人，无论是本地人或是寄居的，若是亵渎了耶和华，那人总要从民间剪除。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","因为他藐视耶和华的话，违犯耶和华的命令，那人必被剪除；他的罪孽要归到他身上。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","以色列人在旷野的时候，有一个人在安息日捡柴。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","遇见他捡柴的人，就把他带到摩西、亚伦和全体会众那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","他们把他收在监里，因为要怎样办他，还未明朗。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","耶和华对摩西说：“那人必须处死，全体会众要在营外用石头把他打死。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","于是全体会众把他拉出营外，用石头把他打死，正如耶和华吩咐摩西的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“你要告诉以色列人，叫他们世世代代在自己衣服的边上作繸子，又在繸子上，钉上一根蓝色的细带子； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","这要作你们的繸子，叫你们一看见，就记得耶和华的一切命令，并且遵行；不随从自己的心意和眼目乱跑，像你们素常乱跑行淫一样， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","好使你们记得，并且遵行我的一切命令，又使你们成为圣洁，归给你们的　神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","我是耶和华你们的　神，曾把你们从埃及地领出来，为要作你们的　神；我是耶和华你们的　神。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","利未的曾孙、哥辖的孙子、以斯哈的儿子可拉，和流本子孙中以利押的儿子大坍、亚比兰，与比勒的儿子安，带着人来， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","反抗摩西，还有以色列人中的二百五十个人，就是会众的领袖；会众中被选出有名望的人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","他们聚集起来反抗摩西和亚伦，对他们说：“你们太过分了，全体会众个个都是圣洁的，耶和华也在他们中间，你们为什么高抬自己，超过耶和华的会众呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","摩西听见了，就脸伏于地， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","对可拉和他的同党说：“到了早晨，耶和华就要使人知道谁是属他的；谁是圣洁的，就叫谁亲近他；谁是他拣选的，就叫谁亲近他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","你们要这样作：可拉和你的同党，你们要拿香炉来； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","明天你们要在耶和华面前，把火盛在炉中，把香放在上面；耶和华拣选谁，谁就是圣洁的，你们利未人太过分了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","摩西又对可拉说：“利未人哪，请听。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","以色列的　神把你们从以色列会众中分别出来，使你们亲近他，办理耶和华帐幕的事务，又站在会众面前替他们供职； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","耶和华又使你和你所有的兄弟，就是利未的子孙，一同亲近他，这在你们看来是小事吗？你们还要寻求祭司职分吗？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","所以你和你的同党聚集起来反抗耶和华；亚伦算什么呢？你们竟向他发怨言。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","摩西派人去把以利押的儿子大坍和亚比兰叫来；他们说：“我们不上去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","你把我们从流奶与蜜的地带上来，要在旷野杀死我们，这算小事吗？你还要自立为王管辖我们吗？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","况且你没有把我们领到流奶与蜜的地，也没有把田地和葡萄园给我们作产业。难道你要把这些人的眼睛剜出来吗？我们不上去。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","于是摩西大怒，对耶和华说：“求你不要悦纳他们的礼物，我没有夺过他们一头驴，也没有害过他们一个人。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","摩西对可拉说：“明天你和你的同党，以及亚伦，都要站在耶和华面前。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","你们各人要拿着自己的香炉，把香盛在上面；你们各人要把自己的香炉带到耶和华面前，共二百五十个香炉；你和亚伦也各人拿着自己的香炉。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","于是，他们各人拿着自己的香炉，盛上火，加上香，与摩西和亚伦一同站在会幕门口。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","可拉召聚了全体会众到会幕门口，来攻击摩西和亚伦，耶和华的荣光就向全体会众显现。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","耶和华对摩西和亚伦说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“你们要离开这会众，我好在眨眼间把他们吞灭。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","摩西和亚伦就俯伏在地，说：“　神啊，万人之灵的　神啊，一人犯罪，你就要向全体会众发怒吗？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“你要吩咐会众说：‘你们要离开可拉、大坍、亚比兰帐幕的四周。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","于是摩西起来，到大坍和亚比兰那里去；以色列的长老也随着他去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","摩西告诉会众：“你们要远离这些恶人的帐幕，凡是他们的东西，你们都不可摸，免得你们因他们的一切罪恶同遭毁灭。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","于是，众人离开了可拉、大坍、亚比兰帐幕的四周；大坍、亚比兰就带着妻子、儿女和小孩出来，站在自己的帐幕门口。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","摩西说：“由此你们可以知道，我作这一切事，是耶和华派我作的，并不是出于我自己的心意。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","如果这些人死亡像一般人死亡一样，或是他们所遭遇的像一般人的遭遇一样，那么就不是耶和华派我来的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","如果耶和华作一件新事，使地开口，把他们和他们所有的都吞下去，叫他们活活地下到阴间，这样你们就知道这些人是藐视耶和华了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","摩西说完了这一切话，他们脚下的地就裂开。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","地开了口，把他们和他们的家眷，以及一切属可拉的人和财物，都吞了下去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","这样，他们和一切属他们的，都活活地下到阴间，地在他们上面合闭，他们就从会众中灭亡了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","在他们四周的以色列众人，听见他们的呼叫，就都逃跑，说：“恐怕地也把我们吞下去。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","又有火从耶和华那里出来，把那献香的二百五十个人吞灭了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“你要吩咐亚伦祭司的儿子以利亚撒，叫他把那些香炉从火中拾起来，把火撒在别处，因为那些香炉是圣的； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","那些自害己命的人的香炉也是圣的，你们要把它们锤成薄片，用来包盖祭坛；那些香炉本是他们在耶和华面前献过的，所以已经成为圣的，并且可以给以色列作鉴戒。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","于是，以利亚撒祭司把被火焚烧的人献过的铜香炉拿起来，叫人锤成薄片，用来包盖祭坛， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","给以色列人作鉴戒，叫不是亚伦子孙的外人，不可近前来，在耶和华面前烧香，免得他像可拉和他的同党有一样的遭遇；这是照着耶和华借摩西吩咐以利亚撒的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","第二天，以色列全体会众都向摩西和亚伦发怨言，说：“你们害死了耶和华的子民。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","会众聚集攻击摩西和亚伦的时候，他们转身向会幕观看，见有云彩遮盖会幕，耶和华的荣光显现出来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","摩西和亚伦就来到会幕前面。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","耶和华吩咐摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“你们要离开这会众，我好在眨眼间把他们消灭。”他们二人就俯伏在地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","摩西对亚伦说：“你要拿着香炉，把坛上的火盛在里头，又加上香，快快带到会众那里去，为他们赎罪，因为有震怒从耶和华面前出来，瘟疫已经开始了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","亚伦照着摩西吩咐的把香炉拿来，跑到会众中间，果然，瘟疫已经在人民中间开始了；他就加上香，为人民赎罪。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","他站在死人与活人中间，瘟疫就止住了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","除了因可拉事件死亡的以外，因瘟疫死亡的有一万四千七百人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","亚伦回到会幕门口摩西那里，瘟疫已经止住了。（本章第36-50节在《马索拉抄本》为 17:1-15） ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","耶和华对摩西说：（本节在《马索拉抄本》为 17:16） ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“你要吩咐以色列人，要从他们手中取杖，按着父家每支派一根，从他们所有的领袖，按着他们的父家，共取十二根杖，你要把各人的名字写在各人的杖上； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","又要把亚伦的名字写在利未的杖上，因为照着他们父家各族长必有一根杖。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","你要把这些杖放在会幕里约柜前，就是我和你们相会的地方。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","我拣选的那人，他的杖必发芽；这样，我就必使以色列人向你们所发的怨言止息，不再达到我耳中。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","于是摩西吩咐以色列人，他们所有的领袖都把杖交给他，按着他们的父家，每个领袖一根杖，共有十二根杖；亚伦的杖也在其中。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","摩西就把杖放在约柜的会幕里，在耶和华面前。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","第二天，摩西进约柜的会幕去，不料，利未家亚伦的杖已经发了芽，生了花苞，开了花，结了熟杏。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","摩西就把所有的杖，从耶和华面前带出来，给以色列众人看；他们看见了，各人就把自己的杖拿了去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","耶和华对摩西说：“把亚伦的杖放回约柜前，给那些背叛的人留作证据，这样你就使他们向我发的怨言止息，免得他们死亡。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","摩西就这样行了，耶和华怎样吩咐他，他就怎样行了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","以色列人对摩西说：“我们要死了，我们灭亡了，我们都灭亡了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","走近耶和华帐幕的，都必定死；难道我们都要死吗？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","耶和华对亚伦说：“你和你的儿子，以及你父家的人，要与你一同担当干犯圣所的罪孽，你和你的儿子要与你一同担当干犯祭司职任的罪孽。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","你要带着你的亲族利未支派的人，就是你祖宗支派的人，与你一同前来，使他们与你联合，并且服事你；只是你和你的儿子要与你一同在约柜的会幕前供职。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","他们要守你所吩咐的，和会幕里的一切事，只是不可走近圣所的器具和祭坛，免得他们和你们都死亡。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","他们要与你联合，也要守会幕的本分，办理会幕的一切事务；只是外人不可走近你们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","你们要看守圣所和祭坛，免得震怒再临到以色列人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","我已经把你们的亲族利未人，从以色列人中拣选出来，给你们作礼物献与耶和华，为要办理会幕的事。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","你和你的儿子，要与你一同守你们祭司的职分，办理一切属祭坛和幔子内的事；你们要这样供职。我把祭司的职分赐给你们作服事我的赏赐；外人若是近前来，必被处死。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","耶和华对亚伦说：“我已经把保留归我的举祭，就是以色列人一切分别为圣的物，都赐给你和你的子孙，作为永远应得的分。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","以色列人所献一切不经过火、至圣的供物，就是一切素祭、一切赎罪祭和一切赎愆祭，都要作至圣的物，归给你和你的子孙。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","你要在至圣的地方吃，凡是男的都可以吃；你要以此物为圣。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","以色列人礼物中的举祭，与他们的摇祭，都是你的；我已经给了你和你的儿女，作为永远应得的分；在你家中洁净的人都可以吃。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","最好的油、最好的新酒和五谷，就是以色列人献给耶和华的初熟的物，我都赐给你。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","从他们地上带来给耶和华的初熟的物，都要归给你们；在你家中洁净的人，都可以吃。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","以色列中一切永献的物，都必归给你。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","有血肉生命头生的，无论是人或是牲畜，就是他们献给耶和华的，都必归给你；只是人类头生的，你总要赎出来；不洁净牲畜头生的，也要赎出来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","关于他们的赎价，一个月以上的，你要照你估定的价，按着圣所的秤，就是按照圣所的标准重量（“就是按照圣所的标准重量”，原文作“一舍客勒是二十季拉”），用五十七克银子赎出来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","只是头生的牛、头生的绵羊，或是头生的山羊，你不可赎出来；它们都是圣的。你要把它们的血洒在祭坛上，把它们的脂油焚烧，作为献给耶和华馨香的火祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","它们的肉却要归给你，像摇过的胸和右腿要归给你一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","以色列人奉献给耶和华圣物中的举祭，我都赐给了你和与你在一起的儿女，作永远应得的分；这是在耶和华面前给你和与你在一起的后裔作永远的盐约。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","耶和华对亚伦说：“你在以色列人的地不可有产业，在他们中间也不可有分；在以色列人中间，我就是你的分，是你的产业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“至于利未的子孙，我已经把以色列中所有的十分之一，赐给了他们作产业，这是为酬报他们在会幕里办理的事务。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","从今以后，以色列人不可走近会幕，免得他们负罪而死。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","唯独利未人要办理会幕的事，要担当他们的罪孽，这要作你们世世代代永远的条例；在以色列人中，他们不可有产业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","因为以色列人献给耶和华为举祭的十分之一，我已经赐给了利未人作产业；所以我对他们说：在以色列人中，他们不可有产业。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“你要告诉利未人：你们既然从以色列人手中，取得了我赐给你们作产业的十分之一，你们就要从这十分之一中，取出十分之一，献给耶和华作为举祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","这要算为你们的举祭，好像禾场上的五谷，又像榨酒池中的酒。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","这样，你们也要把从以色列人取得的十分之一，作举祭献给耶和华；你们要把献给耶和华的举祭，归给亚伦祭司。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","从你们得的一切礼物中，要把最好的，分别为圣，献给耶和华为举祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","所以你要对利未人说：‘如果你们把最好的献上，这就算为你们禾场上的粮和榨酒池中的酒了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","你们和你们的家人，随处都可以吃，因为这是你们的工价，是你们在会幕里办事的报酬。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","如果你们把最好的献上，就不致因此担罪。以色列人的圣物，你们不可亵渎，免得你们死亡。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","耶和华对摩西和亚伦说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“耶和华所定的律法是这样说：你要吩咐以色列人，把一头完全、没有残疾、未曾负过轭的红母牛，牵到你这里来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","你们要把牛交给以利亚撒祭司，他就要把牛牵到营外，在他面前把牛宰了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","以利亚撒祭司要用指头蘸牛血，向会幕前面洒七次。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","然后，在他面前把牛焚烧，牛的皮、肉、血和粪，都要焚烧。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","祭司要把香柏木、牛膝草、朱红色线，都丢在烧牛的火中。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","祭司要洗自己的衣服，并用水洗身，然后才可以进营；但祭司必不洁净到晚上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","那烧牛的人也要用水洗自己的衣服，并用水洗身，也必不洁净到晚上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","要由一个洁净的人收起母牛的灰，安放在营外洁净的地方，为以色列会众留作除污秽的水，这是除罪的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","那收起牛灰的人，要洗自己的衣服，必不洁净到晚上。这要给以色列人和寄居在他们中间的外人，作永远的定例。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“摸了任何死尸的，必不洁净七天。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","那人在第三天要用这样除污秽的水洁净自己，到第七天他就洁净了；如果他在第三天不洁净自己，到第七天他就不洁净了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","任何人摸了死尸，而不洁净自己的，就玷污了耶和华的帐幕，这人必要从以色列中剪除，因为这除污秽的水没有洒在他身上，所以他必不洁净；他的不洁还留在他身上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“如果人在会幕里死了，条例是这样的：进这会幕的和一切在会幕里的，都必不洁净七天。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","一切敞口的器皿，就是没有盖上盖的，都是不洁净的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","在田间摸了被刀杀死的，或是自己死的尸体，或是人的骨头，或是坟墓，就必不洁净七天。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","人要为这不洁净的人，拿些烧成的除罪灰，放在器皿里，倒上活水。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","要由一个洁净的人，拿牛膝草蘸在这水里，把水洒在会幕上和一切器皿，以及在那里的众人身上，又洒在摸了骨头，或是摸了被杀死的，或是摸了坟墓的人身上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","第三天和第七天，那洁净的人要洒水在不洁净的人身上，这样到第七天就使他洁净；他要洗自己的衣服，用水洗身，到晚上就洁净了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","“但那污秽而不洁净自己的，那人必从会众中被剪除，因为他玷污了耶和华的圣所；除污秽的水没有洒在他身上，他是不洁净的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","这要给你们作永远的定例。那洒了除污秽水的人，要洗自己的衣服；那摸了除污秽水的，必不洁净到晚上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","不洁净的人摸过的一切，必不洁净；摸了这物的人，也必不洁净到晚上。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","正月间，以色列全体会众到了寻的旷野，就住在加低斯；米利暗死在那里，也埋葬在那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","会众没有水喝，就聚集攻击摩西和亚伦。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","人民与摩西争闹，说：“但愿我们的兄弟在耶和华面前死去的时候，我们也一同死去！ ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","你们为什么把耶和华的会众领到这旷野来，使我们和我们的牲畜都死在这里呢？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","你们为什么使我们出埃及，领我们到这坏地方来呢？这里不能撒种，没有无花果树、葡萄树、石榴树，也没有水喝。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","摩西和亚伦于是离开会众，来到会幕门口，俯伏在地；耶和华的荣光向他们显现。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“你要拿着杖，和你的哥哥亚伦聚集会众，在他们眼前，吩咐磐石；这样你就可以使磐石流出水来，给会众和他们的牲畜喝。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","于是，摩西照着耶和华吩咐他的，从耶和华面前拿了杖去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","摩西和亚伦聚集了会众到磐石面前；摩西对他们说：“悖逆的人哪，你们要听，我们为你们使水从磐石中流出来吗？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","摩西举手，用杖击打磐石两次，就有很多水流出来，会众和他们的牲畜都喝了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","耶和华对摩西和亚伦说：“因为你们不信我，不在以色列人眼前尊我为圣，所以你们必不得领这会众进入我赐给他们的地。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","这就是米利巴水，因为以色列人在那里与耶和华争闹，耶和华在他们中间显为圣。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","摩西从加低斯派使者去见以东王说：“你的兄弟以色列这样说：你知道我们遭遇的一切困难， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","就是我们的列祖下到埃及去，我们在埃及住了很多日子；埃及人恶待我们和我们的列祖； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","我们向耶和华呼求，他就听了我们的声音，派使者把我们从埃及领出来；现在我们就在你边界上的城加低斯。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","求你容我们从你的地经过；我们不走过田地和葡萄园，也不喝井里的水，我们只走大路，不偏左也不偏右，直到走过了你的境地。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","以东王对使者说：“你不可从我这里经过，免得我带着刀出来攻击你。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","以色列人对他说：“我们要走大路上去，我们和牲畜若是喝了你的水，我必照价付你；不求别的事，只求你容我们步行经过。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","以东王说：“你不可经过。”他就率领很多人出来，要用强硬的手攻击以色列人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","这样，以东王不肯让以色列人从他的境内经过，以色列人就离开他去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","以色列全体会众从加低斯起行，到了何珥山。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","耶和华在以东地边界的何珥山对摩西和亚伦说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“亚伦要归到他本族人那里去，他必不得进入我赐给以色列人的那地，因为在米利巴水的事上，你们违背了我的吩咐。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","你要带着亚伦和他的儿子以利亚撒，一同上何珥山去； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","把亚伦的衣服脱下来，给他儿子以利亚撒穿上；亚伦就归到他本族人那里去，死在山上。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","摩西就照着耶和华吩咐的行了，三人当着全体会众的眼前上了何珥山。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","摩西把亚伦的衣服脱下来，给他的儿子以利亚撒穿上；亚伦就死在山顶那里。于是，摩西和以利亚撒从山上下来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","全体会众见亚伦死了，以色列全家就为亚伦哀哭了三十天。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","住在南地的迦南人亚拉得王，听说以色列人从亚他林路来，就与以色列人交战，掳了他们几个人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","于是以色列人向耶和华许愿，说：“如果你把这民交在我手里，我就必把他们的城尽行毁灭。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","耶和华听了以色列人的祈求，就把迦南人交给他们，于是他们把迦南人和他们的城尽行毁灭；那地方的名就叫何珥玛。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","他们从何珥山沿着到红海的路起行，要绕过以东地；众民因为这条路，心里烦躁， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","就反抗　神和摩西，说：“你们为什么把我们从埃及领上来，使我们死在旷野呢？这里没有粮食，又没有水，我们的心厌恶这淡薄的食物。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","于是耶和华打发火蛇进入人民中间；蛇咬他们，许多以色列人就死了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","人民来见摩西，说：“我们有罪了，因为我们出恶言攻击耶和华和你；求你向耶和华祷告，叫这些蛇离开我们。”于是摩西为众人祷告。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","耶和华对摩西说：“你要做一条火蛇，挂在杆上；被咬的，一看这蛇，就必得存活。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","摩西就做了一条铜蛇，挂在杆上；被蛇咬了的人，一望这铜蛇，就活了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","以色列人又起行，在阿伯安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","再从阿伯起行，在以耶．亚巴琳安营，就是摩押对面的旷野，向日出之地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","他们又从那里起行，在撒烈谷安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","又从那里起行，在亚嫩河那边安营；这亚嫩河是在旷野，从亚摩利人的境内流出来；原来亚嫩河就是摩押的边界，在摩押与亚摩利人之间。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","因此，在耶和华的战书上记着：“在苏法的哇哈伯，和亚嫩河的河谷， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","以及河谷的斜坡，这斜坡伸展到亚珥城的地方，就是靠近摩押边境的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","以色列人又从那里到了比珥（“比珥”意即“井”）；从前耶和华对摩西说：“你要聚集众民，我好把水给他们喝”，说的就是这个井。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","那时，以色列人就唱了这首歌，说：“井啊，涌上水来。你们要向这井歌唱。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","这井是领袖挖掘的，是民间的尊贵人，用圭用杖挖掘的。”以色列人从旷野到了玛他拿， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","从玛他拿到拿哈列，从拿哈列到巴末， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","从巴末到摩押地的谷，又到了俯瞰荒野的毗斯迦山顶。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","以色列人派使者去见亚摩利人的王西宏说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“求你容我们从你的地经过；我们不偏入田间和葡萄园，也不喝井里的水；我们只走大路，直到过了你的境界。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","西宏不容以色列人从他的境界经过，反而聚集了自己的人民，出到旷野去攻击以色列人，西宏到了雅杂，与以色列人交战。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","以色列人用刀击杀了他，占领了他的地，从亚嫩河到雅博河，直到亚扪人那里，因为雅谢是亚扪人的边界。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","以色列人夺取了这一切城，也住在亚摩利人的各城，就是希实本，与属于希实本的一切村庄。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","这希实本是亚摩利人的王西宏的京城；西宏曾经与摩押以前的王交战，从他手中夺去了所有的地，直到亚嫩河。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","因此诗人说：“你们来到希实本！愿西宏的城被重建，愿西宏的城坚立。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","因为有火从希实本发出，有火焰从西宏的城冒出，吞灭了摩押的亚珥，烧毁了亚嫩河的高冈。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","摩押啊，你有祸了，基抹的民哪，你们灭亡了；基抹使自己的男子逃亡，使自己的女子被掳，交给了亚摩利人的王西宏。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","我们射击他们，希实本就毁灭，直到底本。我们使地荒凉，直到挪法，挪法直伸到米底巴。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","这样，以色列人就住在亚摩利人的地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","摩西派人去窥探雅谢，以色列人就占领了雅谢的村镇，把那里的亚摩利人赶走。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","以色列人回头，沿着到巴珊的路上走；巴珊王噩和他的众民都出来迎着以色列人，在以得来与他们交战。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","耶和华对摩西说：“不要怕他，因为我已经把他和他的众民，以及他的地都交在你手里；你要待他，像从前待那住在希实本的亚摩利人的王西宏一样。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","于是，他们杀了噩和他的儿子，以及他的众民，没有留下一个，就占领了他的地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","以色列人起行，在摩押平原安营，就是在约旦河东边，耶利哥的对面。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","以色列人向亚摩利人所行的一切事，西拨的儿子巴勒都看见了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","摩押人十分惧怕这民，因为他们众多；摩押人因以色列人的缘故，十分恐慌。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","摩押人对米甸的长老说：“现在这群人要吞并我们四周的一切，好像牛吞吃田间的草一样。”那时西拨的儿子巴勒，作摩押王； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","他就派使者到比珥的儿子巴兰那里去，就是到大河的毗夺，亚扪人的地那里，去叫巴兰来，说：“你看，有一个民族从埃及出来，遮满了全地，如今住在我的对面。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","现在请你来，替我咒诅这民，因为他们比我强盛，或者我能够击败他们，把他们从这地赶出去；因为我知道你给谁祝福，谁就得福；你咒诅谁，谁就受咒诅。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","摩押的长老和米甸的长老，手里带着礼金去了；他们到了巴兰那里，把巴勒的话告诉他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","巴兰对他们说：“今夜你们留在这里，我必照着耶和华吩咐我的话答复你们。”于是，摩押的领袖就与巴兰同住。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","神来到巴兰那里，说：“与你在一起的这些人是谁？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","巴兰对　神说：“是摩押王西拨的儿子巴勒派到我这里来的人，他们说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘你看，从埃及出来的民族，遮满了全地；现在请你来，替我咒诅他们，或者我能够战胜他们，把他们赶走。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","神对巴兰说：“你不可与他们同去，也不可咒诅那民，因为他们是蒙福的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","巴兰早晨起来，对巴勒的领袖说：“你们回本地去吧，因为耶和华不准我与你们同去。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","摩押的领袖起来，回到巴勒那里，说：“巴兰不肯与我们同来。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","于是，巴勒又派比先前更多、更尊贵的领袖去， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","他们来到巴兰那里，对他说：“西拨的儿子巴勒这样说：‘求你不要推辞不到我这里来， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","因为我必使你大得尊荣；你向我说什么，我都照办；只求你替我咒诅这民。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","巴兰回答巴勒的臣仆说：“巴勒就算把他满屋的金银给我，但我不论作大事小事，也不能越过耶和华我　神的命令。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","现在请你们今夜也住在这里，等我得知耶和华还要向我说什么。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","当夜，　神来到巴兰那里，对他说：“这些人既然来请你，你就起程与他们同去，但是你只要遵行我吩咐你的事。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","巴兰早晨起来，备上驴，与摩押的领袖一同去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","神因为巴兰去就发怒；耶和华的使者站在路上敌挡他。那时他骑着驴，有两个仆人同行。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","驴看见了耶和华的使者站在路上，手里拿着拔出来的刀，就转离正路，走入田中去；巴兰就打驴，要叫它转回路上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","耶和华的使者站在葡萄园间的窄路上，两边都有围墙。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","驴看见了耶和华的使者，就紧挤在墙上，把巴兰的脚挤伤了，巴兰又打驴。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","耶和华的使者又往前行，站在狭窄之处，左右都没有转身的地方。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","驴看见了耶和华的使者，就卧在巴兰身下；巴兰大怒，就用自己的杖打驴。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","耶和华开了驴的口，驴就对巴兰说：“我向你作了什么，你竟打我这三次呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","巴兰对驴说：“因为你作弄我。但愿我手中有刀，现在就把你杀死。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","驴对巴兰说：“我不是你从起初一直所骑的驴吗？我以前曾向你这样行过吗？”巴兰说：“没有。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","那时，耶和华开了巴兰的眼睛，他就看见耶和华的使者站在路上，手里拿着拔出来的刀，巴兰就低头俯伏在地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","耶和华的使者对他说：“你为什么这三次打你的驴呢？看哪，是我来敌挡你，因为你走的路在我面前邪僻。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","驴看见了我，就三次从我面前转开；驴若是没有从我面前转开，我早已把你杀了，而留它活着。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","巴兰对耶和华的使者说：“我有罪了，我不知道是你站在路上阻挡我；现在你若是不喜欢我去，我就回去。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","耶和华的使者对巴兰说：“你与这些人同去吧，但是你只要说我吩咐你的话。”于是巴兰与巴勒的领袖一同去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","巴勒听见巴兰来了，就出去到摩押的京城迎接他；这城是在亚嫩河旁，在边界的尽头。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","巴勒对巴兰说：“我不是急切地派人到你那里去请你吗？你为什么不到我这里来呢？难道我不能使你得尊荣吗？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","巴兰对巴勒说：“看哪，我已经来到你这里，现在我怎能说什么呢？　神把什么话放在我口里，我就说什么。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","巴兰与巴勒同行，来到基列．胡琐。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","巴勒宰了牛羊，送给巴兰和与他在一起的领袖。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","到了早晨，巴勒带着巴兰上了巴力的高冈；巴兰就从那里观看以色列民的边界。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","巴兰对巴勒说：“你要在这里给我筑七座祭坛，给我预备七头公牛，七只公绵羊。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","巴勒照着巴兰吩咐的行了；巴勒和巴兰在每座祭坛上献一头公牛和一只公绵羊。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","巴兰对巴勒说：“你要站在你的燔祭旁边，我要往前去，或者耶和华会来迎见我；他指示我什么，我必告诉你。”于是巴兰上了一块高地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","神迎见巴兰；巴兰对　神说：“我已经预备了七座祭坛，在各座祭坛上献了一头公牛和一只公绵羊。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","耶和华把话传给巴兰，又说：“你要回到巴勒那里去，要这样这样说。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","他就回到巴勒那里，见他和摩押所有的领袖都站在燔祭旁边。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","巴兰就作歌，说：“巴勒把我从亚兰领出来，摩押王引我出东山，说：‘来吧，为我咒骂雅各，来啊，咒骂以色列。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","神没有咒诅的，我怎能咒诅呢？耶和华没有咒骂的，我怎能咒骂呢？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","我从高峰观看他们，从山上眺望他们；这是独居的民族，不列在万国之中。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","谁能数算雅各的灰尘？谁能计算以色列的四分之一呢？愿我的死像正直人的死，愿我之终如正直人之终。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","巴勒对巴兰说：“你向我作的是什么事呢？我领你来咒诅我的仇敌，你反倒给他们祝福。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","巴兰回答，说：“耶和华传给我的话，我怎能不谨慎说呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","巴勒对巴兰说：“请你与我到另一个地方去，从那里你可以看见他们；不过你不能看见他们全部，只能看见他们边界的一部分；在那里你要为我咒诅他们。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","于是巴勒带巴兰到了琐腓田，上了毗斯迦山顶，筑了七座祭坛，在每座祭坛上献了一头公牛和一只公绵羊。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","巴兰对巴勒说：“你要在这里站在你的燔祭旁边，等我到那边去迎见耶和华。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","耶和华见了巴兰，把话传给他，说：“你回到巴勒那里去，要这样这样说。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","巴兰回到巴勒那里，见他站在自己的燔祭旁边，摩押的领袖也与他在那里。巴勒问巴兰：“耶和华说了什么话呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","巴兰作歌，说：“巴勒啊，要起来听；西拨的儿子啊，侧耳听我。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","神不是人，必不致说谎，也不是人子，必不致后悔。他说话，怎能不作？他发言，怎能不作成？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","我奉命来祝福；　神要赐福，我不能改变。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","在雅各中不见罪孽，在以色列中也不见患难；耶和华他们的　神与他们同在，有君王欢呼的声音在他们中间。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","领他们出埃及的　神，对他们有如野牛的角。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","在雅各中没有观兆的，在以色列中也没有占卜；到了适当的时候，必有话对雅各和以色列说：‘　神为他们行了何等的大事！’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","这民族起来有如母狮，挺身好像公狮；不吃下猎物，不喝被杀的人的血，决不卧下。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","巴勒对巴兰说：“你一点不要咒诅他们，也不要祝福他们。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","巴兰回答巴勒说：“我不是告诉过你说：‘耶和华吩咐我的，我都必要遵行’吗？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","巴勒对巴兰说：“你来，我领你到另一个地方去，或者　神喜欢你，你就可以在那里为我咒诅他们。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","于是，巴勒领巴兰到了俯视旷野的毗珥山顶去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","巴兰对巴勒说：“你要在这里给我筑七座祭坛，也要为我预备七头公牛和七只公绵羊。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","巴勒就照着巴兰所说的行了，在每座祭坛上，献上一头公牛和一只公绵羊。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","巴兰见耶和华喜欢赐福以色列，就不再像前两次一样去求观兆的方法，却面向旷野。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","巴兰举目，看见以色列人按着支派居住，　神的灵就临到他身上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","他就作歌，说：“比珥的儿子巴兰说：‘有眼光的人说， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","得听　神的话语、得见全能者的异象、身体仆倒而眼目睁开的人说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","雅各啊，你的会幕多么佳美；以色列啊，你的帐幕多么美好！ ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","像扩展的棕林，如河边的园子，似耶和华栽种的沉香树，又像水旁的香柏树。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","必有水从他的桶中流出来，他的后裔必在多水之处；他的王必超过亚甲，他的国度必被高举。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","领他出埃及的　神，对他好像野牛的角；他要吞吃敌国，打碎他们的骨头，用箭射透他们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","他蹲伏躺下，好像公狮，又像母狮，谁敢使他起立呢？给你祝福的，愿他蒙福；咒诅你的，愿他受咒诅。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","巴勒向巴兰生气，就拍起手；巴勒对巴兰说：“我请你来咒诅我的敌人，如今你反倒祝福他们这三次。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","现在你逃回你的地方去吧；我说过我要大大地使你得尊荣，但是耶和华阻止你使你不得尊荣。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","巴兰对巴勒说：“我不是告诉了你派来的使者说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘就算巴勒把满屋的金银给我，我也不能越过耶和华的命令，随自己的心意行好行歹’吗？耶和华说什么，我就说什么。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","现在我要回我本族去了；你来，我要告诉你这个民族日后要怎样待你的人民。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","他就作歌，说：“比珥的儿子巴兰说：‘开着眼的人说， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","那得听　神的话语、明白至高者的知识、得见全能者的异象、身体仆倒而眼目睁开的人说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","我看见他，却不是现在；我望见他，却不是近处；必有一星从雅各而出，必有一杖从以色列兴起；他必打碎摩押的额角，粉碎一切舍特人的头顶。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","他必得以东作产业，又得仇敌之地西珥作产业；只有以色列人成为强壮。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","有一位从雅各而出的必掌大权，他要除灭城中余下的人。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","巴兰看见了亚玛力，就作歌，说：“亚玛力原是列国之首，他的结局却是灭亡。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","巴兰看见了基尼人，就作歌，说：“你的居所坚固，你的窝巢建在磐石中； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","但基尼必被毁灭；亚述要到几时才把你掳去呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","巴兰又作歌，说：“哀哉，　神决定这事，谁能得活呢？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","必有船从基提而来，苦害亚述，苦害希伯；他却要灭亡。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","于是巴兰起来，回自己的地方去；巴勒也回去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","以色列人住在什亭，人民与摩押的女子行起淫乱来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","那些女子叫以色列人来，一同给她们的神献祭，以色列人也吃了她们的祭物，跪拜她们的神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","以色列人与巴力．毗珥连合，耶和华就向以色列人发怒。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","耶和华对摩西说：“把人民的首领都捉来，在我耶和华面前对着太阳把他们悬挂起来，好使耶和华的烈怒可以转消，不向以色列人发作。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","于是摩西对以色列的审判官说：“你们各人要把与巴力．毗珥连合的人都杀了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","摩西和以色列全体会众在会幕门口哭泣的时候，以色列人中有一个人来，当着他们的面带了一个米甸女子到自己的兄弟那里去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","亚伦祭司的孙子、以利亚撒的儿子非尼哈看见了，就从会众中起来，手里拿着枪， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","跟着那以色列人，进入卧室，把他们两人刺透，就是刺透那以色列人和那女子。枪刺进了那女子的肚腹。这样，在以色列人中的瘟疫才止住。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","那时因瘟疫而死的，共有二万四千人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“亚伦祭司的孙子、以利亚撒的儿子非尼哈，使我的烈怒稍消，不向以色列人发作，因为他在他们中间以我忌邪的心为心，使我不因我忌邪的心把他们消灭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","因此你要说：‘现在我把平安之约赐给他， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","要给他和他的后裔作为永远担当祭司职分的约，因为他为他的　神有忌邪的心，为以色列人赎罪。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","那被杀的以色列人，就是与那米甸女子一同被杀的人，名叫心利，是撒路的儿子，是西缅支派中一个家族的领袖。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","那被杀的米甸女子，名叫哥斯比，是苏珥的女儿；这苏珥是米甸一个家族的族长。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“你要扰害米甸人，打击他们； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","因为他们用诡计扰害你们；在毗珥的事上，和他们的姊妹，米甸领袖的女儿哥斯比的事上，用诡计欺骗了你们。”这哥斯比在瘟疫的日子，因毗珥的事被杀了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","瘟疫以后，耶和华对摩西和亚伦的儿子以利亚撒说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“你们要把以色列会众，从二十岁以上，在以色列中能出去打仗的，按着他们的父家，计算数目。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","于是，摩西和以利亚撒祭司在摩押旷野，就是在耶利哥附近的约旦河边，告诉他们： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“从二十岁以上的，你们都要登记数目。”这是照着耶和华吩咐摩西的。从埃及地出来的以色列人计有： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","以色列的长子流本：流本的子孙，属哈诺的，有哈诺家族；属法路的，有法路家族； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","属希斯伦的，有希斯伦家族；属迦米的，有迦米家族。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","这些是流本的家族；他们被数点的，共有四万三千七百三十人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","法路的儿子是以利押； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","以利押的儿子是尼母利、大坍、亚比兰。这大坍和亚比兰原是从会众中选拔出来的，他们和可拉一党的人一起与耶和华争吵，也与摩西和亚伦争吵的时候， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","地开了口，把他们和可拉吞了下去；可拉与他的同党都死了，那时有火吞灭了二百五十个人，他们成了警戒。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","但是，可拉的子孙却没有死亡。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","西缅子孙，按着家族，属尼母利的，有尼母利家族；属雅悯的，有雅悯家族；属雅斤的，有雅斤家族； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","属谢拉的，有谢拉家族；属扫罗的，有扫罗家族。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","这些就是西缅的各家族，共有二万二千二百人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","迦得子孙，按着家族，属洗分的，有洗分家族；属哈基的，有哈基家族；属书尼的，有书尼家族； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","属阿斯尼的，有阿斯尼家族；属以利的，有以利家族； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","属亚律的，有亚律家族；属亚列利的，有亚列利家族。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","这些就是迦得子孙的各家族，按着他们各家族被数点的，共有四万零五百人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","犹大的儿子是珥和俄南；这珥和俄南都死在迦南地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","犹大子孙，按着家族，属示拉的，有示拉家族；属谢拉的，有谢拉家族。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","法勒斯的子孙，属希斯仑的，有希斯仑家族；属哈母勒的，有哈母勒家族。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","这些就是犹大的各家族，按着他们各家族被数点的，共有七万六千五百人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","以萨迦的子孙，按着家族，属陀拉的，有陀拉家族；属普瓦的，有普瓦家族； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","属雅述的，有雅述家族；属伸仑的，有伸仑家族。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","这些就是以萨迦的各家族，按着他们各家族被数点的，共有六万四千三百人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","西布伦的子孙，按着家族，属西烈的，有西烈家族；属以伦的，有以伦家族；属雅利的，有雅利家族。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","这些就是西布伦的各家族，按着他们各家族被数点的，共有六万零五百人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","约瑟的儿子，按着家族，有玛拿西和以法莲。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","玛拿西的子孙，属玛吉的，有玛吉家族；玛吉生基列；属基列的，有基列家族。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","以下就是基列的子孙：属伊以谢的，有伊以谢家族；属希勒的，有希勒家族； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","属亚斯列的，有亚斯列家族；属示剑的，有示剑家族； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","属示米大的，有示米大家族；属希弗的，有希弗家族。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","希弗的儿子西罗非哈没有儿子，只有女儿；西罗非哈的女儿名叫玛拉、挪阿、曷拉、密迦、得撒。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","这些就是玛拿西的各家族，他们被数点的，共有五万二千七百人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","以下就是以法莲的子孙：按着家族，属书提拉的，有书提拉家族；属比结的，有比结家族；属他罕的，有他罕家族。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","书提拉的子孙，属以兰的，有以兰家族。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","这些就是以法莲子孙的各家族，按着他们各家族被数点的，共有三万二千五百人。按着他们的家族，这些都是约瑟的子孙。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","便雅悯的子孙，按着家族，属比拉的，有比拉家族；属亚实别的，有亚实别家族；属亚希兰的，有亚希兰家族； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","属书反的，有书反家族；属户反的，有户反家族。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","比拉的众子是亚勒、乃幔；属亚勒的，有亚勒家族；属乃幔的，有乃幔家族。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","这些就是便雅悯的子孙，按着他们的家族，他们被数点的，共有四万五千六百人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","以下是但的子孙：按着家族，属书含的，有书含家族；按着家族，这些就是但的各家族。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","书含所有的家族，被数点的，共有六万四千四百人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","亚设的子孙，按着他们的家族，属音拿的，有音拿家族；属亦施苇的，有亦施苇家族；属比利亚的，有比利亚家族。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","比利亚的子孙，属希别的，有希别家族；属玛结的，有玛结家族。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","亚设的女儿名叫西拉。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","这些就是亚设子孙的各家族，按着他们各家族被数点的，共有五万三千四百人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","拿弗他利的子孙，按着家族，属雅薛的，有雅薛家族；属沽尼的，有沽尼家族； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","属耶色的，有耶色家族；属示冷的，有示冷家族。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","这些就是拿弗他利的各家族，按着他们各家族被数点的，共有四万五千四百人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","以上就是以色列人被数点的，共有六十万零一千七百三十人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“你要按着人名数目把地分配给他们作产业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","人数多的，你要把产业多分给他们；人数少的，你要把产业少分给他们；要按着数点的人数，把产业分给各人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","虽然这样，地还是要借着抽签分配；他们要按着自己父家支派的名字，承受产业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","你要按着所抽的签，照着人数的多少，把产业分配给他们。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","以下是按着家族被数点的利未人：属革顺的，有革顺家族；属哥辖的，有哥辖家族；属米拉利的，有米拉利家族。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","这些就是利未的各家族：有立尼家族、希伯伦家族、玛利家族、母示家族、可拉家族。哥辖生暗兰。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","暗兰的妻子，名叫约基别，是利未的女儿，是利未在埃及所生的；她给暗兰生了亚伦、摩西和他们的姊姊米利暗。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","亚伦生拿答、亚比户、以利亚撒、以他玛。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","拿答和亚比户在耶和华面前献凡火的时候，死了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","利未人中，从一个月以上被数点的所有男丁，共有二万三千人。在以色列人中没有数点他们，因为在以色列人中，没有把产业分给他们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","以上的人就是被摩西和以利亚撒祭司数点的；他们是在摩押平原，耶利哥对面约旦河边数点以色列人的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","这些人中间，没有一个是摩西和亚伦祭司从前在西奈旷野数点以色列人的时候，数点过的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","因为耶和华论到他们曾经说过：“他们必死在旷野。”所以除了耶孚尼的儿子迦勒和嫩的儿子约书亚以外，连一个也没有剩下。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","属约瑟的儿子玛拿西的各家族，有玛拿西的玄孙、玛吉的曾孙、基列的孙子、希弗的儿子西罗非哈的女儿，名叫玛拉、挪阿、曷拉、密迦、得撒；她们前来， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","站在会幕门口，在摩西和以利亚撒祭司、众领袖和全体会众面前，说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“我们的父亲死在旷野，他并不是在那聚集攻击耶和华的人之中，不属可拉一党的人；他死在自己的罪中，只是他没有儿子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","为什么因为我们的父亲没有儿子，就把他的名从他的家族中除掉呢？求你在我们父亲的兄弟中，给我们产业。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","于是摩西就把她们的案件呈到耶和华面前。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“西罗非哈的女儿说得有理，你一定要在她们父亲的兄弟中，给她们产业，要把她们父亲的产业给她们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","你也要告诉以色列人说：‘一个人死时，如果没有儿子，就要使他的产业归给他的女儿。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","如果他没有女儿，就要把他的产业给他的兄弟。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","如果他没有兄弟，就要把他的产业给他父系的兄弟。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","如果他父亲没有兄弟，你们就要把他的产业给他家族中最近的亲属，那人就要得他的产业。这要作以色列人的律例、典章，是照着耶和华吩咐摩西的。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","耶和华吩咐摩西说：“你要上这亚巴琳山去，看看我赐给以色列人的地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","看了以后，你也必归到你的本族那里去，像你哥哥亚伦归去一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","因为在寻的旷野，会众争闹的时候，你们违背了我的命令，没有在涌水之地，在会众眼前尊我为圣。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","摩西对耶和华说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“愿耶和华万人之灵的　神，立一个人治理会众， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","可以在他们面前出入；带领他们出入，免得耶和华的会众好像没有牧人的羊一样。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","耶和华对摩西说：“你要拣选嫩的儿子约书亚，他心里有圣灵，你要按手在他头上， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","叫他站在以利亚撒祭司和全体会众面前，当他们的面委派他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","你要把你的尊荣给他几分，好叫以色列全体会众都听从他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","他要站在以利亚撒祭司面前，以利亚撒要借着乌陵的判断，在耶和华面前为他求问；他和以色列众人，就是全体会众，都要按着以利亚撒的命令出入。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","于是，摩西照着耶和华吩咐他的去行；他把约书亚领来，叫他站在以利亚撒祭司和全体会众面前， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","按手在他头上，委派他，是照着耶和华借摩西吩咐的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“你要吩咐以色列人说：‘你们应献给我的供物，就是献给我作馨香的火祭的食物，要按着日期献给我。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","你又要对他们说：‘你们要献给耶和华的火祭是这样：没有残疾、一岁的公羊羔，每天两只，作为常献的燔祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","早晨要献一只，黄昏献一只； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","也要献一公斤细面，用捣成的油一公升调和，作为素祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","这就是常献的燔祭，是在西奈山规定，作为献给耶和华馨香的火祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","为每只公羊羔，要同献一公升作奠祭的酒；你要在圣所中把醇酒献给耶和华作奠祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","晚上你要献上另一只公羊羔，要照着早晨的素祭，和同献的奠祭献上，作馨香的火祭献给耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“‘在安息日，要献两只没有残疾、一岁的公羊羔，也要献两公斤细面，用油调和作素祭；还有同献的奠祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","这是安息日献的燔祭；在那常献的燔祭和同献的奠祭以外。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“‘每月第一日，你们要把燔祭献给耶和华，就是两头公牛犊、一只公绵羊、七只没有残疾一岁的公羊羔。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","为每头公牛，要献三公斤细面，用油调和作素祭；为每只公绵羊，要献两公斤细面，用油调和作素祭； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","为每只公羊羔，要献一公斤细面，用油调和作素祭；这是馨香的燔祭，是献给耶和华的火祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","每头公牛要献酒两公升作奠祭，每只公绵羊献酒一公升半，每只公羊羔献酒一公升。这是每月当献的燔祭，一年之中每个月都要这样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","又要把一只公山羊作赎罪祭献给耶和华，在那常献的燔祭和同献的奠祭以外。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“‘正月十四日，是耶和华的逾越节。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","这月十五日是节期；要吃无酵饼七日。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","第一日要有圣会，什么劳碌的工都不可作， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","只要献火祭给耶和华作燔祭，就是两头公牛犊、一只公绵羊和七只一岁的公羊羔，都要完全没有残疾的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","同献的素祭，是用油调和的细面，为每头公牛犊要献三公斤；为每只公绵羊要献两公斤； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","为那七只公羊羔，每只要献一公斤； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","还要献一只公山羊作赎罪祭，为你们赎罪。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","除了早晨的燔祭，就是常献的燔祭以外，还要把这些祭物献上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","一连七日，每日都要献上这样的祭物，给耶和华作馨香火祭的食物，是在常献的燔祭和同献的素祭以外的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","第七日你们要有圣会，什么劳碌的工都不可作。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“‘在初熟日，即七七节那一天，你们把新素祭献给耶和华的时候，要有圣会，什么劳碌的工都不可作， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","只要把燔祭作为馨香的祭献给耶和华，就是两头公牛犊、一只公绵羊、七只一岁的公羊羔。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","同献的素祭，是用油调和的细面，为每头公牛要献三公斤；为每只公绵羊，要献两公斤； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","为那七只公羊羔，每只要献一公斤； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","还要献一只公山羊，为你们赎罪； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","除了常献的燔祭以外，你们还要献上这些祭物和同献的奠祭，都要没有残疾的。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“‘七月第一日，你们要有圣会；什么劳碌的工都不可作。这是你们吹角的日子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","你们要把燔祭作馨香的祭献给耶和华，就是一头公牛犊、一只公绵羊、七只一岁没有残疾的公羊羔。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","同献的素祭，是用油调和的细面，为每头公牛要献上三公斤；为每只公绵羊要献上两公斤； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","为那七只公羊羔，每只要献一公斤； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","还要献一只公山羊作赎罪祭，为你们赎罪； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","在月初的燔祭和同献的素祭、常献的燔祭和同献的素祭，以及照例同献的奠祭以外，还要献上这些给耶和华作馨香的火祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“‘在七月十日，你们要有圣会，刻苦己心，什么都不可作， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","只要把燔祭作馨香的祭献给耶和华，就是一头公牛犊、一只公绵羊、七只一岁没有残疾的公羊羔。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","同献的素祭，是用油调和的细面，为每头公牛要献三公斤；为每只公绵羊要献两公斤。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","为那七只公羊羔，每只要献一公斤； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","在为赎罪的赎罪祭、常献的燔祭和同献的素祭，以及同献的奠祭以外，还要献一只公山羊作赎罪祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“‘七月十五日，你们要有圣会；什么劳碌的工都不可作，要向耶和华守节七天； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","你们要给耶和华献燔祭，作馨香的火祭，就是十三头公牛犊、两只公绵羊、十四只一岁没有残疾的公羊羔。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","同献的素祭，是用油调和的细面，为那十三头公牛，每只要献三公斤；为那两只公绵羊，每只要献两公斤； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","为那十四只公羊羔，每只要献一公斤； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","在常献的燔祭和同献的素祭，以及同献的奠祭以外，还要献一只公山羊作赎罪祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“‘第二日，要献公牛犊十二头、公绵羊两只、一岁没有残疾的公羊羔十四只， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","并且为公牛、公绵羊和公羊羔，按着数目，照着规例，献上同献的素祭和同献的奠祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","在常献的燔祭和同献的素祭，以及同献的奠祭以外，还要献一只公山羊作赎罪祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“‘第三日，要献公牛十一头、公绵羊两只、一岁没有残疾的公羊羔十四只； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","并且为公牛、公绵羊和公羊羔，按着数目，照着规例，献上同献的素祭和同献的奠祭； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","在常献的燔祭和同献的素祭，以及同献的奠祭以外，还要献一只公山羊作赎罪祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“‘第四日，要献公牛十头、公绵羊两只、一岁没有残疾的公羊羔十四只； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","并且为公牛、公绵羊和公羊羔，按着数目，照着规例，献上同献的素祭和同献的奠祭； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","在常献的燔祭和同献的素祭，以及同献的奠祭以外，还要献一只公山羊作赎罪祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“‘第五日，要献公牛九头、公绵羊两只、一岁没有残疾的公羊羔十四只； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","并且为公牛、公绵羊和公羊羔，按着数目，照着规例，献上同献的素祭和同献的奠祭； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","在常献的燔祭和同献的素祭，以及同献的奠祭以外，还要献上一只公山羊作赎罪祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“‘第六日，要献公牛八头、公绵羊两只、一岁没有残疾的公羊羔十四只； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","并且为公牛、公绵羊和公羊羔，按着数目，照着规例，献上同献的素祭和同献的奠祭； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","在常献的燔祭和同献的素祭，以及同献的奠祭以外，还要献上一只公山羊作赎罪祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“‘第七日，要献公牛七头、公绵羊两只、一岁没有残疾的公羊羔十四只； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","并且为公牛、公绵羊和公羊羔，按着数目，照着规例，献上同献的素祭和同献的奠祭； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","在常献的燔祭和同献的素祭，以及同献的奠祭以外，还要献上一只公山羊作赎罪祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“‘第八日，你们要有盛会；什么劳碌的工都不可作， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","只要给耶和华献燔祭，作馨香的火祭，就是公牛一头、公绵羊一只、一岁没有残疾的公羊羔七只； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","并且为公牛、公绵羊和公羊羔，按着数目，照着规例，献上同献的素祭和同献的奠祭； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","在常献的燔祭和同献的素祭，以及同献的奠祭以外，还要献一只公山羊作赎罪祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“‘在那些为还愿或是甘心所献，作你们的燔祭、素祭、奠祭，或是平安祭的以外，这些是在你们规定的时期内，要献给耶和华的祭物。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","于是，摩西照着耶和华吩咐他的一切话，对以色列人说了。（本节在《马索拉抄本》为 30:1） ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","摩西告诉以色列人众支派的领袖：“这是耶和华吩咐的话：（本节在《马索拉抄本》为 30:2） ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","如果人向耶和华许愿，或是起誓要约束自己，就不可食言，总要照着自己口里所出的一切话行。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","女子年幼还在父家的时候，如果向耶和华许愿要约束自己， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","她父亲若是听见她所许的愿和约束自己的话，却对她默不作声，她所许的一切愿和所说约束自己的话，就为有效。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","但是她父亲听见的时候，如果阻止她，她所许的愿和所说约束自己的话，就都为无效；耶和华也必赦免她，因为她父亲阻止她。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“如果她已嫁了丈夫，她许愿或嘴里说冒失话约束自己的时候， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","她丈夫听见了，但在听见的时候，默不作声，她所许的愿和约束自己的话，就为有效。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","但是她丈夫听见的时候，如果阻止她，就算废了她所许的愿和她嘴里所说约束自己的冒失话；耶和华也必赦免她。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“寡妇，或是离了婚的妇人所许的愿，就是她所说约束自己的一切话，都为有效。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","如果她在丈夫家里许了愿，或用誓言约束自己， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","她丈夫听见了，却默不作声，也没有阻止她，她所许的愿和所说一切约束自己的话，就为有效。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","但是她丈夫听见的时候，如果把这两样都废了，妇人口中所说一切关于许愿的话和约束自己的话，都必无效；她丈夫已经把这两样都废了，耶和华也必赦免她。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","“妇人所许的愿和刻苦约束自己所起的誓，她丈夫都可以确立，也可以废去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","如果她丈夫天天向她默不作声，那就算是确立她所许的愿和所说约束自己的一切话；因为丈夫在听见的日子，向她默不作声，就使这两样生效。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","但是，如果丈夫听了很久以后，才把这两样完全废去，他就要担当妻子的罪孽。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","以上是耶和华吩咐摩西的条例，是关于丈夫与妻子，父亲与女儿，女儿年幼在父家的时候的条例。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“你要在米甸人身上报以色列人的仇，然后要归到你本族那里去。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","摩西对人民说：“要从你们中间使一些人武装起来去作战，攻击米甸人，好在米甸人身上为耶和华报仇。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","你们要从以色列众支派中每支派打发一千人去打仗。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","于是从以色列千万人中，每支派选出一千人，共有一万二千人，都武装起来去打仗。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","摩西就打发每支派的一千人去打仗，并且派遣以利亚撒祭司的儿子非尼哈与他们一同去，非尼哈手里拿着圣所的器皿和吹大声的号筒。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","他们就照着耶和华吩咐摩西的，去与米甸人作战，杀死了所有的男人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","在那些被杀的人以外，还杀了米甸的五个王，就是以未、利金、苏珥、户珥和利巴；又用刀杀了比珥的儿子巴兰。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","以色列人掳了米甸人的妇女、孩子；又掳掠了他们所有的牲畜、羊群和财物； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","并用火烧了他们所住地方的一切城市和营寨； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","把一切夺来的和掳掠的，连人带牲畜都带走； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","他们把俘掳的人和掳来的，以及夺来的东西，都带到摩押平原，约旦河边，和耶利哥相对的营地那里，交给摩西和以利亚撒祭司，以及以色列的会众。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","摩西和以利亚撒祭司，以及会众所有的领袖，都出到营外迎接他们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","摩西对作战回来的军官，就是对千夫长和百夫长发怒。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","摩西对他们说：“你们让这些妇女存活吗？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","看哪，这些妇女因巴兰的计谋，使以色列人在毗珥的事上，得罪耶和华，以致瘟疫临到耶和华的会众身上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","现在你们要把所有的男孩都杀了，也要杀死所有与男人发生过关系的妇人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","但女孩子中，没有与男人发生过关系的，你们都可以让她们活着。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","你们要在营外驻扎七天，杀过人的和摸过死尸的，第三日和第七日都要洁净自己，你们和你们掳来的人都要这样行。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","你们也要洁净一切衣服、皮具、山羊毛织的物和木器。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","以利亚撒祭司对打仗回来的兵丁说：“这是耶和华吩咐摩西的律例： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","金、银、铜、铁、锡、铅， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","能够经火的东西，你们都要使它经火，就算是洁净了，但还要用除污水洁净它；不能经火的，你们要使它经过水。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","第七日，你们要洗衣服，就为洁净；然后才可以进营。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“你和以利亚撒祭司，以及会众的各族长，要计算俘掳的人和掠得的牲畜的总数。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","你要把掠夺得的分为两半，一半给出去打仗的人，一半给全体会众。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","你又要从出去打仗的人所得的，无论是人、牛、驴，或羊群之中，抽出五百分之一作贡物奉给耶和华； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","你们要从他们那一半中抽出，交给以利亚撒祭司，作耶和华的举祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","从以色列人那一半中，无论是人、牛、驴、羊群，或是各样牲畜，都要抽出五十分之一，交给负责看守耶和华帐幕的利未人。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","于是，摩西和以利亚撒祭司照着耶和华吩咐摩西的行了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","掠得的东西，就是打仗的人所掳掠剩下来的，共有羊六十七万五千只， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","牛七万二千头， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","驴六万一千头， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","没有与男人发生过关系的妇人三万二千人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","出去打仗的人的分，就是他们所得的那一半，羊共有三十三万七千五百只； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","这些羊群中，归耶和华作贡物的，有六百七十五只。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","牛三万六千头，归耶和华为贡物的，有七十二只。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","驴三万零五百头，归耶和华为贡物的有六十一匹。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","人口一万六千，归给耶和华作贡物的，有三十二人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","摩西照着耶和华吩咐他的，把贡物，就是耶和华的举祭，交给以利亚撒祭司。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","以色列人所得的那一半，就是摩西从打仗的人取来分给他们的 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","（属于会众的那一半，有羊三十三万七千五百只， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","牛三万六千头， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","驴三万零五百头， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","人口一万六千）； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","摩西照着耶和华吩咐他的，从属于以色列人的那一半，无论是人口或是牲畜，都抽出五十分之一，交给负责看守耶和华帐幕的利未人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","统领万军的军长、千夫长和百夫长，都来见摩西， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","对摩西说：“你仆人手下作战的士兵，已经计算总数，没有缺少一人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","现在我们把耶和华的供物，都送来了，就是我们各人所得的金器、脚链子、镯子、打印戒指、耳环、手钏，好在耶和华面前，为我们自己赎罪。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","摩西和以利亚撒祭司就收了他们的金子，就是各样金子做成的器皿。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","千夫长和百夫长献给耶和华为举祭的一切金子，共有两百多公斤。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","士兵都各自夺取了财物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","摩西和以利亚撒祭司就从千夫长和百夫长手中收了金子，把它带进会幕里去，在耶和华面前作以色列人的记念。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","流本子孙和迦得子孙的牲畜极其众多；他们看见雅谢地和基列地都是可牧放牲畜的地方， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","就来对摩西和以利亚撒祭司，以及会众的首领说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“亚大录、底本、雅谢、宁拉、希实本、以利亚利、示班、尼波、比稳， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","就是耶和华在以色列会众面前攻取的地，是可牧放牲畜的地，你仆人也有牲畜。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","他们又说：“如果我们在你眼前蒙恩，求你把这地给你的仆人作产业，不要叫我们过约旦河。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","摩西对迦得子孙和流本子孙说：“难道你们的兄弟去打仗，你们却坐在这里吗？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","你们为什么使以色列人灰心，不过河到耶和华赐给他们的地那里去呢？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","我从前从加低斯．巴尼亚派你们的先祖去窥探那地的时候，他们也是这样行。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","他们上到以实各谷，看了那地，就使以色列人灰心，不进耶和华赐给他们的地那里去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","当日耶和华的怒气发作，就起誓说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘从埃及上来二十岁以上的人，必不得看见我对亚伯拉罕、以撒、雅各起誓应许的地，因为他们没有专心跟从我。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","唯独基尼洗人耶孚尼的儿子迦勒，和嫩的儿子约书亚可以看见，因为他们专心跟从耶和华。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","耶和华的怒气向以色列人发作，使他们在旷野飘流了四十年，等到在耶和华眼前行恶的那一代都灭尽了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","现在，你们这些罪人的族类，也来接替你们的先祖，增添耶和华对以色列的烈怒！ ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","如果你们转离，不跟从他，他再要把以色列人撇在旷野，这样，你们就要把整个民族都毁灭了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","两支派的人走到摩西跟前，对他说：“我们要在这里给我们的牲畜筑羊圈，给我们的孩子建城邑。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","我们自己却要武装起来，行在以色列人前头上阵，直到把他们领到他们自己的地方，但我们的孩子因为这地居民的缘故，要住在坚固的城里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","我们决不回家，直等到以色列人各自承受了产业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","我们不与他们在约旦河西边之地同受产业，因为我们的产业是坐落在约旦河东边。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","摩西对他们说：“如果你们这样行，在耶和华面前武装起来去作战， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","你们所有武装起来的人，都要在耶和华面前过约旦河，直到他把他的仇敌从自己面前赶出去， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","直到那地在耶和华面前被征服了，然后才回家，这样你们对耶和华和对以色列就算无罪，这地也可以在耶和华面前归你们作产业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","如果你们不这样行，就得罪了耶和华；你们要知道你们的罪必追上你们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","现在你们只管照你们口中所出的话去行，为你们的孩子建城，为你们的羊群筑圈。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","迦得子孙和流本子孙告诉摩西：“你仆人必照着我主吩咐的去行。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","我们的孩子、妻子、羊群和所有的牲畜，都要留在基列的各城； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","但你的仆人，所有武装起来预备打仗的，都要照着我主所说的，在耶和华面前过去作战。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","于是，摩西为了他们，嘱咐以利亚撒祭司和嫩的儿子约书亚，以及以色列众支派的族长， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","对他们说：“迦得的子孙和流本的子孙，所有武装起来，在耶和华面前预备去作战的人，如果与你们一同过约旦河，那地在你们面前被征服了，你们就要把基列地给他们作产业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","他们若是不武装起来，与你们一同过去，他们就要在迦南地在你们中间同得产业。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","迦得的子孙和流本的子孙回答，说：“耶和华怎样吩咐仆人，我们就怎样行。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","我们要武装起来，在耶和华面前过河，到迦南地去；只是约旦河这边的地方，要归我们作产业。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","于是摩西把亚摩利王西宏的国，和巴珊王噩的国，连那地，和境内城市，以及那地周围的城市，都给了迦得的子孙、流本的子孙和约瑟的儿子玛拿西的半个支派。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","迦得的子孙修筑了底本、亚他录、亚罗珥、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","亚他录．朔反、雅谢、约比哈、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","伯．宁拉、伯．哈兰这些坚固的城市和羊圈。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","流本的子孙修筑了希实本、以利亚利、基列亭、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","尼波、巴力．免（以上的名字是改了的）、西比玛；又为他们修筑的城市起了别的名字。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","玛拿西的儿子玛吉的子孙到基列去，攻取了那地，把住在那里的亚摩利人赶走。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","摩西把基列给了玛拿西的儿子玛吉，玛吉就住在那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","玛拿西的儿子睚珥，去攻取了亚摩利人的村庄，就把这些村庄叫作哈倭特．睚珥。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","挪巴去攻取了基纳和基纳的小村镇，就用自己的名字叫基纳为挪巴。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","以下是以色列人按着他们的队伍，在摩西和亚伦的手下，从埃及地出来以后所行的路程。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","摩西照着耶和华的命令，把他们出发的路程记下来，他们出发的路程是这样： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","一月十五日，就是逾越节的次日，以色列人从兰塞起行，在所有埃及人眼前昂然无惧地出去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","那时，埃及人正在埋葬他们的长子，就是耶和华在他们中间击杀的，耶和华也对他们的神施行审判。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","以色列人从兰塞起行，在疏割安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","从疏割起行，在旷野边界的以倘安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","从以倘起行，转到比哈．希录，是在巴力．洗分前面，就在密夺对面安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","从比哈．希录起行，经过了海来到旷野，又在伊坦旷野走了三天的路程，就在玛拉安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","从玛拉起行，来到以琳；在以琳有十二股水泉，七十棵棕树；他们就在那里安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","从以琳起行，在红海边安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","从红海起行，在汛的旷野安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","从汛的旷野起行，在脱加安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","从脱加起行，在亚录安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","从亚录起行，在利非订安营，在那里众民没有水喝。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","从利非订起行，在西奈的旷野安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","从西奈的旷野起行，在基博罗．哈他瓦安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","从基博罗．哈他瓦起行，在哈洗录安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","从哈洗录起行，在利提玛安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","从利提玛起行，在临门．帕烈安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","从临门．帕烈起行，在立拿安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","从立拿起行，在勒撒安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","从勒撒起行，在基希拉他安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","从基希拉他起行，在沙斐山安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","从沙斐山起行，在哈拉大安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","从哈拉大起行，在玛吉希录安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","从玛吉希录起行，在他哈安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","从他哈起行，在他拉安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","从他拉起行，在密加安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","从密加起行，在哈摩拿安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","从哈摩拿起行，在摩西录安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","从摩西录起行，在比尼．亚干安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","从比尼．亚干起行，在曷．哈及甲安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","从曷．哈及甲起行，在约巴他安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","从约巴他起行，在阿博拿安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","从阿博拿起行，在以旬．迦别安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","从以旬．迦别起行，在寻的旷野安营，寻就是加低斯。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","从加低斯起行，在以东地边界上的何珥山安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","以色列人从埃及地出来以后四十年，五月一日，亚伦祭司照着耶和华的吩咐，上了何珥山，就死在那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","亚伦死在何珥山上的时候，是一百二十三岁。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","那时，住在迦南地南方的迦南人亚拉得王，听说以色列人来了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","以色列人从何珥山起行，在撒摩拿安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","从撒摩拿起行，在普嫩安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","从普嫩起行，在阿伯安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","从阿伯起行，在摩押边境的以耶．亚巴琳安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","从以耶．亚巴琳起行，在底本．迦得安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","从底本．迦得起行，在亚门．低比拉太音安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","从亚门．低比拉太音起行，在尼波前面的亚巴琳山安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","从亚巴琳山起行，在耶利哥对面，约旦河边的摩押平原安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","他们在摩押平原，沿着约旦河边安营，从帕．耶施末直到亚伯．什亭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","耶和华在摩押平原约旦河边，耶利哥对面对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“你要吩咐以色列说：‘你们过约旦河到了迦南地的时候， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","就要把所有的居民从你们面前赶出去，毁坏他们的一切雕像，以及一切铸像，又拆毁他们的一切邱坛。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","你们要占领那地，住在那里，因为我已经把那地赐给你们作产业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","你们要按着家族抽签承受那地作产业；人多的，要把产业多分给他们；人少的，要把产业少分给他们；抽签抽出那地归谁，就归谁；你们要按着宗族支派承受产业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","如果你们不把那地的居民从你们面前赶出去，所留下的人就必成为你们眼中的刺，肋旁的荆棘，在你们所住的地方扰害你们； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","并且我原计划怎样待他们，也要怎样待你们。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“你要吩咐以色列人说：‘你们进了迦南地的时候，归你们作产业的迦南地及它的四境就是以下这些地区。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","你们南面的地区要从寻的旷野，贴着以东边界；你们的南界要从盐海东面的尽头起； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","你们的边界要转到亚克拉滨坡的南边，经过寻，直达加低斯．巴尼亚的南边，又出到哈萨．亚达，过到押们； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","你们的边界要从押们转到埃及河，直达到海。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","“‘西界方面，你们有大海和海岸；这要作你们的西界。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","“‘你们的北界如下：从大海起画界，直到何珥山； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","从何珥山起画界，直到哈马口，使边界直到西达达； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","这边界再伸到西斐仑，直到哈萨．以难；这要作你们的北界。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","“‘你们要从哈萨．以难，画到示番为东界。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","这边界要从示番下到亚延东面的利比拉；这边界要继续伸展直达基尼烈湖的东边。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","这边界要下到约旦河，直到盐海。这要作你们的土地四周的边界。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","摩西吩咐以色列人说：“这就是你们要抽签承受为业之地，是耶和华吩咐给九个半支派的； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","因为流本子孙的支派和迦得子孙的支派，按着父家已经取得了产业，玛拿西的半个支派也取得了产业； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","这两个半支派已经在耶利哥对面，约旦河东岸，向日出之地得了产业。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“这是要把地业分配给你们的人的名字：以利亚撒祭司和嫩的儿子约书亚。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","你们又要从每支派中选出一个领袖，来帮助分配地业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","这些人的名字是：犹大支派有耶孚尼的儿子迦勒。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","西缅子孙的支派有亚米忽的儿子示母利。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","便雅悯支派有基斯伦的儿子以利达。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","但子孙的支派有一个领袖，是约利的儿子布基。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","约瑟的后裔，玛拿西子孙的支派有一个领袖，是以弗的儿子汉聂。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","以法莲子孙的支派有一个领袖，是拾弗但的儿子基母利。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","西布伦子孙的支派有一个领袖，是帕纳的儿子以利撒番。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","以萨迦子孙的支派有一个领袖，是阿散的儿子帕铁。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","亚设子孙的支派有一个领袖，是示罗米的儿子亚希忽。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","拿弗他利子孙的支派有一个领袖，是亚米忽的儿子比大黑。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","这些人，就是耶和华所吩咐，把产业分给迦南地的以色列人的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","耶和华在耶利哥对面，约旦河边的摩押平原，对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“你要吩咐以色列人，叫他们从所得为业的地中，把一些城给利未人居住，也把这些城周围的郊区给利未人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","这些城要归他们居住，城的郊区可以牧放他们的牛羊和一切牲畜，也可以存放他们的财物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","“你们给利未人的城郊，要从城墙起，周围向外量四百五十公尺。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","你们又要从城外，向东面量九百公尺，向南面量九百公尺，向西面量九百公尺，向北面量九百公尺，城在中间；这要归给他们作城外的郊区。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","你们分给利未人的城，其中要有六座避难城，让误杀人的可以逃到那里去，此外还要给他们四十二座城。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","这样，你们所要给利未人的城，共为四十八座，连城带城郊都要给他们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","从以色列人所得的地业中，你们要把一些城给利未人，人多的就要多给，人少的就要少给；每个支派要照着自己承受的产业，把城分给利未人。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“你要吩咐以色列人说：‘你们过约旦河，进到迦南地的时候， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","就要选择几座城，给你们作避难城，让误杀人的，就是无心杀死人的，可以逃到那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","它们可以作你们逃避报仇者的避难城，使误杀人的不至于死，直到他站在会众面前受审判。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","你们指定的城，要给你们作六座避难城。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","在约旦河东面，你们要分出三座城；在迦南地，你们也要分出三座城，都要作避难城。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","这六座城要给以色列人和外族人，以及他们中间居住的人作避难城，使无心杀人的人，都可以逃到那里去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","“‘如果人用铁器打人，以致把人打死，他就是故意杀人的；故意杀人的必被处死。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","如果人手里拿着可以打死人的石头打人，以致把人打死，他就是故意杀人的；故意杀人的必被处死。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","如果人手里拿着可以打死人的木器打人，以致把人打死，他就是故意杀人的；故意杀人的必被处死。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","报血仇的，要亲自把那故意杀人的杀死；一遇见他，就可以杀死他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","如果人因怀恨把人推倒，或是埋伏着向人扔东西，以致把人打死； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","或者因仇恨用手打人，以致把人打死；那打人的，必被处死，因为他是故意杀人的；报血仇的一遇见凶手，就可以杀死他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","“‘但是，如果人没有仇恨，忽然把人推倒，或是无意向人投掷什么器皿， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","或是因为没有看见，用任何可以打死人的石头，扔在人身上，以致把人打死，他本来与他无仇，也无意害他； ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","这样，会众就要照着典章，在打死人的和报血仇的人中间施行裁判。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","会众要把误杀人的，从报血仇的人手中救出来；他要住在城中，直到受膏的大祭司死了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","但误杀人的，若是出了他逃进的避难城的境界， ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","报血仇的在避难城境外遇着他，把他杀了，报血仇的就没有犯流人血的罪。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","因为那误杀人的应该住在避难城中，直到大祭司死了；大祭司死了以后，那误杀人的才可以回到他自己地业去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","“‘这在你们一切居住的地方，要作你们世世代代的律例典章。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","杀人的，要凭着几个见证人的口供，才可以把他处死；如果只有一个见证人，就不能指证把人处死。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","犯了死罪，故意杀人的，你们不可收取赎价代他赎命，因为他必被处死。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","逃到避难城的人，你们也不可收取他的赎价，使他在大祭司未死以前回到本地居住。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","这样，你们就没有玷污你们居住的地，因为血能玷污地；在地上如果有流人血的，除非流那故意杀人者的血，那地的血就不能得赎。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","你们不可玷污你所住的地，就是我居住的地，因为我耶和华是居住在以色列人中间的。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","约瑟后裔的家族中，有玛拿西的孙子、玛吉的儿子基列的子孙，他们族中的首领都前来，在摩西面前，在各家族作首领的领袖面前，和在以色列人面前说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","“耶和华曾经吩咐我主要凭抽签把地分给以色列人为业；我主也受了耶和华的吩咐，要把我们兄弟西罗非哈的产业分给他的众女儿。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","但是，如果她们嫁给以色列中别的支派的人，她们的产业就必从我们祖宗的产业中被取去，加在他们丈夫支派的产业上；这样，我们抽签所得的产业就失去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","到了以色列人的禧年，她们的产业就要加在她们丈夫支派的产业上；这样，她们的产业就要从我们祖宗支派的产业中被拿去了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","摩西照着耶和华的话，吩咐以色列说：“约瑟支派的人说得对。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","论到西罗非哈的众女儿，耶和华吩咐的话是这样：‘她们可以随意嫁自己喜欢的人，但是，只能嫁给同族同支派的人作妻子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","这样，以色列人的产业，就不会从一个支派转到另一个支派去；因为以色列人要各自守住自己祖宗支派的产业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","从以色列支派中得了产业的女子，要嫁给自己祖宗支派的人作妻子，好使以色列人可以各自承受自己祖宗的产业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","这样，以色列人的产业，就不会从一个支派转到另一个支派去；因为以色列人的支派要各自守住自己的产业。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","耶和华怎样吩咐摩西，西罗非哈的众女儿就怎样行。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","西罗非哈的女儿玛拉、得撒、曷拉、密迦、挪阿，都嫁给了自己叔伯的儿子作妻子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","她们嫁给了约瑟的儿子玛拿西子孙家族的人作妻子；她们的产业仍然留在自己的支派中。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","这是耶和华在耶利哥对面，约旦河边的摩押平原，借着摩西向以色列人吩咐的命令和典章。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","以下是摩西在约旦河东的旷野，疏弗对面的亚拉巴，就是在巴兰和陀弗、拉班、哈洗录、底撒哈之间，向以色列人所说的话。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","从何烈山经过西珥山的路，到达加低斯．巴尼亚，共有十一天的路程。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","出埃及以后第四十年十一月一日，摩西照着耶和华吩咐他一切关于以色列人的话，都告诉了他们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","当时，他已经击败了住在希实本的亚摩利人的王西宏，和住在亚斯他录与以得来的巴珊王噩。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","摩西在约旦河东的摩押地，开始讲解这律法，说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","“耶和华我们的　神，在何烈山告诉我们：‘你们在这山上住够了； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","现在你们要转回，起程到亚摩利人的山地去，到那些住在亚拉巴、山地、低地、南地、沿海一带、迦南人的地、黎巴嫩，直到大河，就是幼发拉底河一带的地方去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","看哪，我把这地摆在你面前，你们要进去，占领这地为业，就是耶和华向你们列祖亚伯拉罕、以撒、雅各起誓应许给他们和他们的后裔的地。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","“那时，我曾经对你们说：‘你们的重担，我独自一人无法担当。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","耶和华你们的　神使你们多起来；你们看，你们今日像天上的星那样多。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","愿耶和华你们列祖的　神，使你们比现在更多千倍，又照着他应许你们的话，赐福给你们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","我独自一人怎能担得起你们的重担、责任和你们争讼的事呢？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","你们要按着支派选出一些有智慧、有见识、有经验的人，我就立他们作你们的首领。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","你们回答我，说：‘你吩咐我们作的事很好。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","我就选出你们众支派中的领袖，就是有智慧有经验的人；按着你们的支派，立他们作管理你们的首领，就是作千夫长、百夫长、五十夫长、十夫长和其他官长。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","“那时，我吩咐你们的审判官，说：‘你们在兄弟中听讼，无论是兄弟彼此诉讼，或是与同居的外地人诉讼，都要按着公义审判。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","审判的时候，不可偏袒人；无论贵贱尊卑，都要一样地听讼；不可怕人的情面，因为审判是属于　神的；如果你们遇见难断的案件，可以呈到我这里来，让我审断。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","那时，我把你们当作的一切事，都吩咐了你们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","“我们照着耶和华我们的　神吩咐我们的，从何烈山起行，走过你们所见那大而可怕的旷野，沿着到亚摩利人山地的路而行；后来到了加低斯．巴尼亚。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","我对你们说：‘你们已经到了亚摩利人的山地，就是耶和华我们的　神赐给我们的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","看哪，耶和华你的　神已经把这地摆在你面前；你要照着耶和华你列祖的　神告诉你的上去，占领那地；不要害怕，也不要惊惶。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","你们众人都走到我这里来，说：‘我们要先派些人去，替我们窥探那地，然后把我们上去该走哪一条路，该进哪些城，向我们回报。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","这话我很同意，就从你们中间选了十二个人，每支派一人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","于是他们转身出发，上了山地，到了以实各谷，窥探那地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","他们手里拿着那地的果子，带下来到我们这里，并且向我们回报，说：‘耶和华我们的　神要赐给我们的地是美地。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","“但你们不肯上去，竟违背了耶和华你们的　神的吩咐； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","你们在帐幕里抱怨，说：‘耶和华因为恨我们，所以把我们从埃及地领出来，要把我们交在亚摩利人手中，消灭我们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","我们上哪里去呢？我们的兄弟使我们心灰意冷，说：那地的人比我们高大；他们的城邑又大又坚固，高耸入天；我们在那里还看见有亚衲族的人。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","我就对你们说：‘不要惊恐，不要害怕他们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","耶和华你们的　神，就是那走在你们前面的那一位，他必为你们作战，好像他在埃及，在你们面前，为你们所行的一切一样， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","并且在旷野里，你们也看见了耶和华你们的　神，怎样在你们所行的一切路上，背负你们，好像人背负自己的儿子一样，直到你们来到了这地方。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","虽然这样，你们还是不信耶和华你们的　神； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","他在路上走在你们前面，为你们寻找安营的地方；夜间用火柱，日间用云彩，指示你们当走的路。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","“耶和华听见了你们说话的声音，就恼怒，起誓说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","‘这个邪恶世代的人，连一个也不能看见我起誓应许赐给他们列祖的美地； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","只有耶孚尼的儿子迦勒可以看见；并且我要把他踏过的地赐给他和他的子孙，因为他专心跟从了我耶和华。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","因为你们的缘故，耶和华也向我发怒，说：‘你也不能进入那地； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","但是站在你面前侍候你的嫩的儿子约书亚，他可以进到那里去；你要鼓励他，因为他要使以色列人承受那地为业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","还有你们的小孩子，你们说要被掳掠的，和你们的儿女，就是今天还不知道善恶的，他们都要进入那地；我要把那地赐给他们，他们要占领那地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","至于你们，你们要转回，经往红海的路，起程到旷野里去。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","“那时你们回答我，说：‘我们得罪了耶和华；现在我们愿意照着耶和华我们　神的一切吩咐，上去作战。’于是你们都预备了兵器，轻率地上山去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","耶和华对我说：‘你要对他们说：“你们不要上去，也不要作战，因为我不在你们中间，免得你们在仇敌面前被击败。”’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","我就告诉你们，你们却不听从，竟违背耶和华的吩咐，擅自上山去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","住在那山上的亚摩利人，就出来攻击你们，好像蜂群一样追赶你们，在西珥击杀你们，直到何珥玛。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","你们就回来，在耶和华面前哭，但耶和华不听你们的声音，也不向你们侧耳。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","于是你们在加低斯住了许多日子。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","“以后，我们照着耶和华吩咐我的，回转过来，沿着往红海的路起程到旷野去；我们在西珥山绕行了很多日子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","耶和华对我说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","‘你们绕行这山的日子已经够了；现在要转向北去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","你要吩咐人民说：“你们的兄弟以扫的子孙，住在西珥，你们现在要经过他们的境界；他们必惧怕你们，所以你们要十分谨慎。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","不要与他们争执；他们的地，连脚掌那么大的一块，我都不给你们，因为我已经把西珥山赐给以扫作产业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","你们要用银子向他们买食物吃；也要用银子向他们买水喝。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","因为耶和华你的　神，对于你手里所作的一切事，都已经赐福给你；他也知道你怎样走这大旷野；这四十年来，耶和华你们的　神常与你同在，使你毫无缺乏。”’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","“于是我们离开我们住在西珥的兄弟以扫的子孙，继续前行；沿着亚拉巴的路，到了以拉他和以旬．迦别，然后转向摩押旷野的路去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","耶和华对我说：‘你不可敌视摩押人，也不可与他们争战；他们的地我不赐给你作产业，因为我已经把亚珥赐给了罗得的子孙作产业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","（以前有以米人住在那里，这族人人数众多，身体高大，像亚衲族人一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","这以米人，像亚衲族人一样，也算为利乏音人；但摩押人称他们为以米人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","以前何利人也住在西珥，但以扫的子孙占领了他们的产业，消灭了他们，住在他们那里，就像以色列在耶和华赐给他们作产业的地上所行的一样。） ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","现在你们要起来，过撒烈溪。’于是我们过了撒烈溪。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","自从我们离开加低斯．巴尼亚，直到过了撒烈溪的日子，共有三十八年，等到那世代的战士都从营中灭绝为止，正像耶和华向他们所起的誓一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","耶和华的手攻击了他们，把他们从营中除灭，直到灭尽为止。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","“所有战士都从民中死尽以后， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","耶和华就对我说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","‘你今天要经过摩押的境界亚珥； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","你走近亚扪人面前的时候，不可敌视他们，也不可与他们争执；亚扪人的地我不赐给你们作产业，因为我已经把那地赐给了罗得的子孙作产业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","（那地也算为利乏音人的地，以前利乏音人住在那里，但亚扪人称他们为散送冥。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","这族人人数众多，身体高大，像亚衲族人一样；但耶和华从亚扪人面前消灭了他们，亚扪人就占领了他们的地业，住在那里， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","好像耶和华从前为住在西珥的以扫的子孙所作的一样，就是把何利人从他们面前消灭，他们就占领了他们的地业，住在他们那里，直到今日。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","还有亚卫人，原先住在迦萨附近的各村庄里，有从迦斐托出来的迦斐托人把他们消灭了，住在他们那里。） ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","现在你要起来，出发，过亚嫩谷；看哪，我已经把亚摩利人希实本王西宏和他的土地，交在你的手里了；你要开始占领那地作产业，与他争战。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","就在今天，我要使天下万民听见你的消息都惊慌惧怕，而且因你的缘故发抖疼痛。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","“我从基底莫的旷野，派使者到希实本王西宏那里去，用和平的话说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","‘求你让我从你的地经过；我只走大道，不偏左也不偏右。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","你可以按着价钱把食物卖给我吃，也可以按着价钱把水卖给我喝；只要让我步行过去就是了； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","好像住在西珥的以扫子孙，和住在西珥的摩押人待我一样，等我过约旦河，进到耶和华我们的　神赐给我们的地去。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","但是希实本王西宏不肯让我们从他那里经过，因为耶和华我们的　神使他的心意顽固，使他的心刚硬，为要把他交在你的手里，像今日一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","耶和华对我说：‘看哪，我已经把西宏和他的地交给你了，你可以占领他的地作产业。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","“那时西宏和他所有的人民都出来，攻击我们，在雅杂与我们作战。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","耶和华我们的　神把他交给了我们，我们就把他、他的儿子们和他所有的人民都击杀了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","那时我们夺取了他所有的城邑，把每一座城，连男带女，以及小孩子都全部毁灭，没有留下一个存活的； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","只留下我们掠为己有的牲畜，和我们夺取城邑所得的战利品。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","从亚嫩谷旁边的亚罗珥和谷中的城，直到基列，没有一座城太高，是我们不能攻下的；耶和华我们的　神把这一切都交给我们了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","只有亚扪人的地，雅博河一带的地方，和山地的城市，以及耶和华我们的　神吩咐我们不可去的地方，我们都没有走近。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","“后来我们回转过来，沿着到巴珊的路上去；巴珊王噩和他的众民，都出来迎着我们，在以得来与我们作战。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","耶和华对我说：‘你不要怕他，因为我已经把他和他的众民，以及他的土地，都交在你的手里；你要待他，像从前你待希实本的亚摩利人的王西宏一样。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","于是耶和华我们的　神也把巴珊王噩和他的众民都交在我们的手里；我们击杀了他们，没有留下一个存活的人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","那时，我们掠夺了他所有的城；在巴珊王噩的国土里，亚珥歌的全境，共有六十座城，没有一座城不被我们所夺。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","这些城都是以高墙作堡垒，有城门，有门闩；此外，还有很多没有城墙的乡村。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","我们把这些都灭尽，像从前我们待希实本王西宏一样，把各城中的男女和小孩子都灭尽。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","只有城中所有的牲畜和夺得的财物，都掠为己有。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","那时，我们从约旦河东亚摩利人的两个王手里，把从亚嫩谷直到黑门山的地夺了过来， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","（西顿人称黑门山为西连，亚摩利人却称它为示尼珥。） ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","就是夺了平原上所有的城市，基列全境和巴珊全境，直到撒迦和以得来，这都是巴珊王噩国内的城市。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","（利乏音人的余民中，只留下巴珊王噩一人；看哪，他的床是铁的，长四公尺，宽两公尺，这是按一般的尺寸量度，现在不是还在亚扪人的拉巴吗？） ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","“那时，我们占领了那地，从亚嫩谷旁边的亚罗珥起，我把基列山地的一半和其中的城市，都给了流本人和迦得人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","基列其余的地方和巴珊全境，就是噩王的国土，我都给了玛拿西半个支派。亚珥歌全境就是巴珊全境，这叫作利乏音人的地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","玛拿西的儿子睚珥，占了亚珥歌全境，直到基述人和玛迦人的边界，就按着自己的名字称巴珊全境为哈倭特．睚珥，直到今日。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","我又把基列给了玛吉。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","从基列到亚嫩谷，以谷的中心为界，直到亚扪人边界的雅博河，我都给了流本人和迦得人； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","又把亚拉巴，和以约旦河为界，从基尼烈直到亚拉巴海，就是盐海，在毗斯迦山坡下东边的地方，都给了他们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","“那时，我吩咐你们：‘耶和华你们的　神，已经把这地赐给你们作产业了；你们所有的战士，都要预备好，在你们的兄弟以色列人面前过河去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","只有你们的妻子、小孩子和牲畜，可以留在我赐给你们的城里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","直到耶和华使你们的兄弟，像你们一样得了安身的地方；他们也占领了耶和华你们的　神在约旦河西赐给他们的地，然后你们各人才可以回到我赐给你们作产业的地去。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","那时，我吩咐约书亚：‘你亲眼看见了耶和华你们的　神向这两个王所行的一切；耶和华也必向你正要去的各国照样行。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","你们不要怕他们，因为耶和华你们的　神要为你们作战。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","“那时，我恳求耶和华，说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","‘主耶和华啊，你已经把你的伟大和你有能力的手显给你的仆人看；在天上地下，哪一个神能有像你所作的工作，能有像你所行的奇事呢？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","求你让我过去，看看约旦河西的美地，就是那美好的山地和黎巴嫩。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","但耶和华为了你们的缘故，向我发怒，不听我的恳求；耶和华对我说：‘罢了，不要向我再提这事了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","你要上毗斯迦山顶去，举目向东、南、西、北，亲眼观看，因为你不能过这约旦河。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","你却要吩咐约书亚，坚固他，鼓励他，因为他要在这人民前面过河去，使他们承受你看见的这地。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","于是我们住在伯．毗珥对面的谷中。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","“以色列人哪，现在你们要听我向来教训你们遵行的律例和典章，使你们可以活着，可以进去得着耶和华你们列祖的　神赐给你们的地作产业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","我吩咐你们的话，你们不可增加，也不可减少，好使你们遵守我吩咐你们的，就是耶和华你们的　神的命令。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","耶和华因巴力．毗珥的事所行的，你们都亲眼看见了；所有跟随巴力．毗珥的人，耶和华你们的　神都从你们中间消灭了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","只有你们紧紧倚靠耶和华你们的　神的人，今日全都活着。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","看哪，我照着耶和华我的　神吩咐我的，把律例和典章教训你们，好让你们在将要进去得为业的地上遵行。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","所以你们要谨守遵行，因为在万民的眼中看来，这就是你们的智慧和聪明；他们一听见这一切律例，就必定说：‘这大国的人真是有智慧，有聪明啊。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","哪一个大国的人有神与他们这样亲近，像耶和华我们的　神，在我们每次呼求他的时候，与我们亲近一样呢？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","又哪一个大国有这样公义的律例和典章，像我今日在你面前颁布的这一切律法呢？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","“你只要自己谨慎，又要谨守你的心思，免得你忘了你亲眼看见的事，又免得这些事在你有生之日离开你的心；总要把这些事传给你的子子孙孙， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","免得你忘了你在何烈山，站在耶和华你们的　神面前的那天。那时耶和华对我说：‘你要为我召集众民，我要叫他们听我的话，使他们在那地上生活的日子，可以学习敬畏我，又可以教训自己的儿女。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","那时，你们走前来，站在山下；山上有火烧着，火焰冲天，又有黑暗、密云和幽暗。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","耶和华从火中对你们说话；你们只听见声音，却没有看见形象；只有声音， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","把他的约，就是他吩咐你们遵守的那十条诫命，向你们宣布出来；又把它们写在两块石版上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","那时，耶和华也吩咐我把律例和典章教训你们，使你们在将要过去得为业的地上遵行。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","“所以你们要特别小心，谨慎自己，因为耶和华在何烈山从火中对你们说话的那一天，你们没有看见什么形象； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","恐怕你们败坏自己，为自己制造偶像，制造任何神像的形象，无论是男像或是女像， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","或是地上各种走兽的像，或是飞翔在空中各类有翅膀的雀鸟的像， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","或是地上各种爬行动物的像，或是地底下水里各样鱼类的像。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","又恐怕你抬头望天，看见日、月、星，就是天上万象的时候，就被勾引，去敬拜和事奉它们，那原是耶和华你们的　神分给天下万民享用的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","耶和华却把你们从埃及，从铁炉那里领出来，作他自己的产业，自己的人民，像今日一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","耶和华又因你们的缘故，向我发怒，并且起誓不让我过约旦河，也不容我进入耶和华你的　神赐给你作产业的那美地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","我只有死在此地，不得过约旦河；你们却可以过去，取得那美地作产业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","你们要自己谨慎，免得你们忘记了耶和华你们的　神与你们所立的约，你们就为自己制造偶像，制造任何神像的形象，就是耶和华你的　神吩咐你不可作的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","因为耶和华你的　神是烈火，是忌邪的　神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","“你们生子生孙，在那地住久了的时候，如果你们败坏自己，制造偶像，制造任何神像的形象，行耶和华你的　神看为恶的事，惹他发怒， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","我今日就呼天唤地向你们作证，你们必在过约旦河取得为业的地上迅速灭亡；你们必不能在那地长久生存，必全被消灭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","耶和华必使你们分散在万民中；在耶和华要领你们所到的万国中，你们剩下的人数必不多。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","在那里你们必事奉人手所做的神，就是用木头石头做成的，不能看、不能听、不能吃、不能闻的神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","但你们在那里必寻求耶和华你的　神；如果你一心一意寻找他，就必寻见。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","日后，你落在患难中，这些事都临到你身上的时候，你必归向耶和华你的　神，听从他的话； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","因为耶和华你的　神原是满有怜悯的　神，他必不丢弃你，不毁灭你，也不忘记他起誓与你的列祖所立的约。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","“你问问在你以前过去的日子，自从　神创造人在地上以来，从天这边到天那边，有没有人行过这样的大事，听过像这样的事呢？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","有没有一个民族听见　神在火中说话的声音，像你听见的一样，还能活着呢？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","有没有一位神尝试借着试验、神迹、奇事、战争、大能的手和伸出来的膀臂，以及大而可畏的事，把一国的人民从别的国中领出来，像耶和华你们的　神在埃及，在你们面前为你们所作的一切事呢？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","这是要显明给你看，使你知道，只有耶和华是　神；除了他以外，再没有别的神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","他从天上使你听见他的声音，为要教导你；又在地上使你看见他的大火，并且叫你听到他从火中所说的话。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","因为他爱你的列祖，所以才拣选了他们的后裔，用大能亲自把你从埃及领出来， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","为要把比你大比你强的民族，从你面前赶走，然后领你进去，把他们的地赐给你作产业，像今日一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","所以今天你要知道，也要记在心里；天上地下，只有耶和华是　神；除他以外，再没有别的神了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","你要遵守我今日吩咐你的律例和诫命，使你和你的子孙得享福乐，也使你在耶和华你的　神赐给你的那地上得享长寿。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","那时，摩西在约旦河东，日出的方向，把三座城分别出来， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","让那些素无仇恨、无心误杀人的，可以逃到那里去；逃到这三座城的一座去的，都可以活着： ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","为流本人，分出了在旷野平原的比悉；为迦得人，分出了基列的拉末；为玛拿西人，分出了巴珊的哥兰。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","以下是摩西在以色列人面前所立的律法， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","就是摩西在以色列人出埃及以后，对他们所说的法度、律例和典章； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","地点是在约旦河东，伯．毗珥对面的谷中，就是住在希实本的亚摩利人的王西宏的地。这西宏是摩西和以色列人出埃及后击杀的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","他们占领了他的地和巴珊王噩的地，就是两个亚摩利人的王，是住在约旦河东，日出的方向的； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","从亚嫩谷边的亚罗珥，直到西云山，西云山就是黑门山； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","还有约旦河东的亚拉巴全地，直到亚拉巴海，就是毗斯迦的山坡下。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","摩西把以色列人都召了来，对他们说：“以色列人哪，我今日讲给你们听的律例和典章，你们要听从，要学习，要谨慎遵行。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","耶和华我们的　神在何烈山与我们立了约。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","这约，耶和华不是与我们的列祖立的，而是与我们今日在这里还活着的人立的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","耶和华在山上，从火中，面对面的与你们说话。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","那时，我站在耶和华和你们中间，要把耶和华的话告诉你们；你们因为惧怕那火，所以没有上到山上来，耶和华说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","“‘我是耶和华你的　神，曾经把你从埃及地，从为奴之家领出来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","“‘除我以外，你不可有别的神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","“‘你不可为自己做偶像，也不可做天上、地下和地底下水中各物的形象。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","不可跪拜它们，也不可事奉它们，因为我耶和华你们的　神是忌邪的　神；恨恶我的，我必追讨他们的罪，从父亲到儿子，直到三四代。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","爱我和遵守我诫命的，我必向他们施慈爱，直到千代。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","“‘不可妄称耶和华你　神的名，因为妄称耶和华的名的，耶和华必不以他为无罪。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","“‘要遵守安息日为圣日，照着耶和华你　神吩咐你的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","六日要劳碌，作你一切工作。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","但第七日是属于耶和华你　神的安息日；这一日，你和你的儿女、仆婢、牛驴和一切牲畜，以及你城里的寄居者，不可作任何的工，好使你的仆婢可以和你一样享受安息。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","你要记住：你在埃及地作过奴仆；耶和华你的　神用大能的手和伸出来的膀臂，把你从那里领出来，因此耶和华你的　神吩咐你要守安息日。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","“‘要孝敬父母，照着耶和华你的　神吩咐你的，使你可以得享长寿，也使你在耶和华你的　神赐给你的地上，得享福乐。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","“‘不可杀人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","“‘不可奸淫。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","“‘不可偷盗。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","“‘不可作假证供陷害你的邻舍。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","“‘不可贪爱你邻舍的妻子；不可贪图你邻舍的房屋、田地、仆婢、牛驴和你邻舍的任何东西。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","“这些话就是耶和华在山上，从火中、密云中、幽暗里，大声对你们全体会众所说的，并没有加添什么；他把这些话写在两块石版上，交给了我。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","那时山上被火烧着，你们听见有声音从黑暗中发出来的时候，你们各支派的首领和你们的长老，都走到我这里来， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","说：‘看哪，耶和华我们的　神把他的荣耀和伟大显给我们看，我们又听见他从火中发出来的声音；今日我们看见了　神与人说话，而人还能活着。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","现在这大火快要吞灭我们了，我们为什么要冒死呢？如果我们再听见耶和华我们　神的声音，我们就必死亡。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","因为有血肉生命的人，有谁像我们一样，听见永活的　神从火中说话的声音，还能活着呢？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","现在求你走前去，听听耶和华我们的　神要说的一切话；然后你要把耶和华我们的　神对你所说的一切话，都告诉我们；我们就必听从，也必遵行。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","“你们对我说话的时候，耶和华听见了你们说话的声音；耶和华就对我说：‘这人民对你所说的话，我都听见了；他们所说的都很好。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","但愿他们常常存着这样的心，敬畏我，遵守我的一切诫命，使他们和他们的子孙永享福乐。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","你去对他们说：“你们回到自己的帐棚里去吧。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","至于你，你要站在我这里；我要把一切诫命、律例、典章，都告诉你；你要教导他们，使他们在我赐给他们作产业的地上遵行。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","所以，你们要照着耶和华你们的　神吩咐你们的，谨守遵行，不可偏离左右。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","你们要走在耶和华你们的　神吩咐你们走的路上，使你们可以活着，可以享福，并且使你在将要占领为业的地上，可以长久居住。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","“以下是耶和华你们的　神吩咐我教导你们的诫命、律例、典章，使你们在将要过去占领为业的地上遵行， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","好叫你和你的子子孙孙一生一世敬畏耶和华你的　神，遵守他的一切律例、诫命，就是我吩咐你的，使你的日子可以长久。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","以色列啊，你要听从，就谨守遵行，使你在流奶与蜜的地可以享福，人数大大增多，像耶和华你列祖的　神应许你的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","“以色列啊，你要听，耶和华我们的　神是独一的耶和华； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","你要全心、全性、全力爱耶和华你的　神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","我今日吩咐你的这些话，都要记在你的心上； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","你要把这些话不断地教训你的儿女，无论你坐在家里，或行在路上，或躺下，或起来的时候，都要谈论。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","你也要把这些话系在手上作记号，戴在额上作头带。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","又要写在你房屋的门柱上和城门上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","“耶和华你的　神领你进入他向你列祖亚伯拉罕、以撒、雅各起誓应许给你的地；那里有不是你建造的，又高大又美丽的城市， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","有装满各样美物的房子，不是你装满的；有凿成的水池，不是你凿成的；还有葡萄园和橄榄园，不是你栽种的；你可以吃，并且吃得饱足。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","那时，你要谨慎，免得你忘记了耶和华，就是把你从埃及地，从为奴之家领出来的那一位。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","你要敬畏耶和华你的　神，要事奉他，奉他的名起誓。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","不可随从别的神，就是你们周围各民族的神； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","因为在你们中间的耶和华你们的　神，是忌邪的　神，恐怕耶和华你的　神向你发怒，就把你从这地上消灭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","“你们不可试探耶和华你们的　神，像你们在玛撒试探他一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","要谨慎遵守耶和华你们的　神吩咐你的诫命、法度和律例。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","耶和华看为正为好的事，你都要去行，使你可以享福，并且可以进去占领耶和华向你的列祖起誓应许的那美地， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","照着耶和华说过的，把你所有的仇敌从你面前赶逐出去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","“日后，如果你的儿子问你：‘耶和华我们的　神吩咐的这法度、律例和典章，有什么意思呢？’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","你就要对你的儿子说：‘我们在埃及曾经作过法老的奴仆，耶和华却用大能把我们从埃及领了出来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","耶和华在我们眼前，把又伟大又厉害的神迹奇事行在埃及、法老和他全家的身上； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","却把我们从那里领出来，为要领我们进入他向我们列祖起誓应许的地，要把这地赐给我们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","耶和华又吩咐我们遵行这一切律例，敬畏耶和华我们的　神，使我们常常得享福乐，使我们的生命得着保全，像今日一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","我们在耶和华我们的　神面前，如果照着他吩咐我们的，谨守遵行这一切诫命，这就是我们的义了。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","“耶和华你的　神领你进入你要去得为业的地，从你面前赶走许多民族，就是赫人、革迦撒人、亚摩利人、迦南人、比利洗人、希未人、耶布斯人，共七个比你又大又强的民族。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","耶和华你的　神把他们交给你，你打败了他们的时候，你要完全毁灭他们，不可与他们立约，也不可恩待他们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","不可与他们通婚，不可把你的女儿嫁给他们的儿子，也不可为你的儿子娶他们的女儿。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","因为他必使你的儿子离开我，去事奉别的神，以致耶和华向你们发烈怒，就快快地把你们消灭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","你们却要这样待他们：拆毁他们的祭坛，打碎他们的神柱，砍下他们的亚舍拉，用火焚烧他们的雕像。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","“因为你是归耶和华你的　神作圣洁的子民的；耶和华你的　神从地上的万族中，拣选了你作他自己的产业，自己的子民。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","耶和华喜爱你们，拣选你们，并不是因为你们的人数比别的民族多，其实你们的人数在万族中是最少的； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","而是因为耶和华对你们的爱，又因为他遵守他向你们的列祖所起的誓，他才用大能的手把你们领出来，把你们从为奴之家，从埃及王法老的手里拯救出来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","所以你要知道耶和华你的　神，他是　神，是信实可靠的　神；他向爱他和守他诫命的人，守约并且施慈爱，直到千代。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","但向恨他的人，却要当面报应他们，把他们灭尽；恨他的，他都要当面报应他，决不迟延。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","所以你要谨守遵行我今日吩咐你的诫命、律例和典章。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","“如果你们听从这些典章，并且谨守遵行这一切，耶和华你的　神就必照着他向你的列祖所起的誓，向你守约并且施慈爱。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","他必爱你，赐福与你，使你人数增多，也必在他向你的列祖起誓应许给你的地上，赐福与你身所生的，你地所产的，使你的五谷、酒、油，以及牛犊和羊羔增产。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","你必蒙福胜过万民；在你中间没有不能生育的男女，也没有不能生殖的牲畜。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","耶和华必使一切病症离开你；你所知埃及各种的恶疾，他决不加在你身上，却加在一切恨你的人身上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","耶和华你的　神交给你的所有民族，你都要把他们消灭；你的眼不可怜惜他们；你也不可事奉他们的神，因为这必成为你的网罗。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","“如果你心里说：‘这些国的人比我多，我怎能把他们赶出去呢？’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","你不要怕他们，只要牢牢地记住，耶和华你的　神向法老和全埃及所行的事， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","就是你亲眼看见的大试验、神迹、奇事、大能的手和伸出来的膀臂，这都是耶和华你的　神领你出来的时候使用的；耶和华你的　神也必照样待你惧怕的所有民族。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","耶和华你的　神还要打发大黄蜂飞到他们中间，直到那些残存躲藏起来的人，都从你面前消灭为止。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","你不要因他们惊慌，因为耶和华你的　神是在你们中间，他是大而可畏的　神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","耶和华你的　神必把这些国的民，从你面前渐渐赶出去；你不可以把他们迅速地灭尽，恐怕田间的野兽多起来害你。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","耶和华你的　神必把他们交在你面前，使他们大起扰乱，直到他们全被消灭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","他也必把他们的君王交在你的手中，你必使他们的名从天下消灭；必没有一人能在你面前站立得住，直到你把他们都消灭了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","他们的神像，你们要用火焚烧；神像上的金银，你不可贪爱，也不可据为己有，免得你因此陷入网罗；因为这是耶和华你的　神厌恶的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","可厌恶的物，你不可带进家里去，免得你与那物一样成了当毁灭的；你要非常憎恨它，十分厌恶它，因为这是当毁灭的物。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","“我今日吩咐你的一切诫命，你们要谨守遵行，使你们可以存活，人数增加，并且可以进去得着耶和华向你们的列祖起誓应许的那地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","你也要记念耶和华你的　神这四十年在旷野引导你的一切路程，为要使你受苦，要试炼你，要知道你心里怎样，看看你肯守他的诫命不肯。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","他使你受苦，任你饥饿，把你和你的列祖不认识的吗哪赐给你吃，使你知道人活着，不是单靠食物，更要靠耶和华口里所出的一切话。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","这四十年来，你身上的衣服没有穿破，你的脚也没有肿起来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","因此你心里要明白，耶和华你的　神管教你，好像人管教他的儿子一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","所以你要谨守耶和华你的　神的诫命，遵行他的道路，敬畏他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","因为耶和华你的　神快要领你进入那美地；那地有河流，有泉，有源，水从谷中和山上流出来； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","那地有小麦、大麦、葡萄树、无花果树、石榴树；那地有橄榄树、油和蜜； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","你在那地必不缺乏食物，在那里你必一无所缺；那地的石头就是铁；从那里的山上，你可以挖出铜来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","你吃饱了，就要称颂耶和华你的　神，因为他把那美地赐了给你。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","“你要自己谨慎，免得忘记耶和华你的　神，不守他的诫命、典章、律例，就是我今日吩咐你的； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","恐怕你吃饱了，建造美好的房屋居住， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","你的牛羊加多，你的金银增添，你所有的一切都增加了， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","那时，你就心高气傲，忘记了耶和华你的　神，就是把你从埃及地，从为奴之家领出来的那一位。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","他引导你走过那大而可畏的旷野，那里有火蛇，有蝎子，有干旱无水之地；他曾经为你使水从坚硬的磐石中流出来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","他在旷野把你的列祖不认识的吗哪赐给你吃，是要使你受苦，要试炼你，使你终久得到福乐； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","恐怕你心里说：‘这财富是我的力量，是我手的能力使我得着的。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","你要记念耶和华你的　神，因为得财富的能力是他赐给你的，为要坚定他向你的列祖起誓所立的约，像今天一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","如果将来你真的忘记了耶和华你的　神，去随从别的神，事奉和敬拜他们，你们必定灭亡，这是我今日警告你们的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","耶和华从你们面前怎样使万国的民灭亡，你们也必照样灭亡，因为你们没有听从耶和华你们　神的话。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","“以色列啊，你要听，你今日快要过约旦河，进去赶出比你又大又强的列国，占领坚固、高得顶天的城市。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","那地的民族又高又大，就是亚衲族的人，是你知道的，你也听过有人指着他们说：‘谁能在亚衲族人面前站立得住呢？’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","所以今日你要知道，耶和华你的　神要像烈火一样在你面前过去；他要消灭他们，他要在你面前把他们征服；这样你就可以照着耶和华吩咐你的，把他们赶走，使他们迅速灭亡。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","耶和华你的　神把这些国的民从你面前驱逐出去以后，你心里不要说：‘耶和华把我领进来取得这地，是因着我的义。’其实耶和华从你面前把这些国的民赶出去，是因着他们的恶。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","你进去取得他们的地，并不是因着你的义，也不是因着你心里的正直，而是因着这些国的民的恶，耶和华你的　神才把他们从你面前赶出去，为要实践他向你的列祖亚伯拉罕、以撒、雅各，起誓应许的话。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","你要知道，耶和华你的　神把这美地赐给你作产业，并不是因着你的义；你本来是顽固的民族。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","“你要记住，不可忘记，你在旷野怎样惹耶和华你的　神发怒；自从你出了埃及地的那天起，直到你们来到这地方，你们常是反抗耶和华的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","你们在何烈山又惹耶和华发怒，以致耶和华向你们发怒，要灭绝你们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","那时，我上了山，要领受石版，就是耶和华与你们立约的石版；那时我在山上住了四十昼夜，不吃不喝。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT9_10","006_9_10","DEU","9","10","10","耶和华把那两块石版交给了我，是　神用手指写的；石版上所写的，是耶和华在大会之日，在山上从火中对你们所说的一切话。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT9_11","006_9_11","DEU","9","11","11","过了四十昼夜，耶和华把那两块石版，就是约版，交给了我。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","耶和华对我说：‘你起来，从这里赶快下去，因为你从埃及领出来的人已经败坏了，他们很快就偏离了我吩咐他们走的道路，为自己铸造了偶像。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT9_13","006_9_13","DEU","9","13","13","“耶和华又对我说：‘你看这民族真是一个顽固的民族。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT9_14","006_9_14","DEU","9","14","14","你不要管我，我要消灭他们，把他们的名字从天下除去；我要使你成为一个比他们更强更大的国。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","于是我转身，从山上下来，山上有火烧着；我手中拿着两块约版。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","我观看，见你们自己铸造了牛犊，很快就离开了耶和华吩咐你们走的道路。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","我拿着那两块石版，从我两手中扔下去，在你们眼前摔碎了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","为了你们所犯的一切罪，作了耶和华看为恶的事，惹他发怒，我就像先前那样，俯伏在耶和华面前，四十昼夜，不吃不喝。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","因为耶和华向你们大发烈怒，要消灭你们，我就很惧怕；但是那一次耶和华也听了我的恳求。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT9_20","006_9_20","DEU","9","20","20","耶和华也向亚伦发怒，要消灭他；那时候我也为亚伦祈祷。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT9_21","006_9_21","DEU","9","21","21","我把你们的罪，就是你们铸造的牛犊，拿去用火烧了，又把它捣碎，磨成细粉，像灰尘一样；我把这灰尘撒在从山上流下来的溪水中。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT9_22","006_9_22","DEU","9","22","22","“后来你们在他备拉、玛撒、基博罗．哈他瓦，又惹耶和华发怒。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT9_23","006_9_23","DEU","9","23","23","耶和华打发你们离开加低斯．巴尼亚，说：‘你们上去得我赐给你们作产业的地。’那时你们竟违背耶和华你们的　神的命令，不相信他，不听从他的话。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT9_24","006_9_24","DEU","9","24","24","自从我认识了你们那一天起，你们就常常悖逆耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT9_25","006_9_25","DEU","9","25","25","“因为耶和华说要消灭你们，我就俯伏在耶和华面前，共俯伏了四十昼夜。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT9_26","006_9_26","DEU","9","26","26","我祈求耶和华，说：‘主耶和华啊，求你不要毁灭你的子民，你的产业，就是你借着你的大能救赎，借着你有力的手从埃及领出来的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT9_27","006_9_27","DEU","9","27","27","求你记念你的仆人亚伯拉罕、以撒、雅各；不要看这民族的顽固、邪恶和罪过， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT9_28","006_9_28","DEU","9","28","28","免得你领我们从那里出来的那地的人说：“耶和华因为不能把他们领进他应许的地，又因为恨他们，所以才把他们领出来，要在旷野杀死他们。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT9_29","006_9_29","DEU","9","29","29","但是，他们是你的子民，是你的产业，又是你借着大能和伸出来的膀臂领出来的。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT10_1","006_10_1","DEU","10","1","1","“那时，耶和华对我说：‘你要凿出两块石版，和先前的一样，然后上山到我这里来；又要做一个木柜。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT10_2","006_10_2","DEU","10","2","2","我要把你摔碎的先前那两块版上的话，写在这两块版上；你要把它们放在柜中。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT10_3","006_10_3","DEU","10","3","3","于是我用皂荚木做了一个柜，又凿出了两块石版，和先前的一样；然后我手里拿着这两块石版，上山去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT10_4","006_10_4","DEU","10","4","4","耶和华把先前所写的，就是在集会的日子，在山上从火中告诉你们的十诫，都写在这两块版上；耶和华把石版交给了我。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT10_5","006_10_5","DEU","10","5","5","于是我转身从山上下来，把石版放在我所做的柜中，照着耶和华吩咐我的，现在石版还放在那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT10_6","006_10_6","DEU","10","6","6","“以色列人从比罗比尼．亚干起程，到了摩西拉。亚伦在那里死了，也埋葬在那里；他的儿子以利亚撒接替他供祭司的职分。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT10_7","006_10_7","DEU","10","7","7","他们从那里起程，到了谷歌大，又从谷歌大到约巴他，就是多溪水的地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT10_8","006_10_8","DEU","10","8","8","那时，耶和华把利未支派分别出来，叫他们抬耶和华的约柜，侍立在耶和华面前事奉他，并且奉他的名祝福，直到今日。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT10_9","006_10_9","DEU","10","9","9","所以利未人在兄弟中无分无业；照着耶和华你的　神应许他的，耶和华自己就是他的产业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT10_10","006_10_10","DEU","10","10","10","“我又像以前那样，在山上停留了四十昼夜；那一次耶和华也听了我的呼求，他不愿把你毁灭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT10_11","006_10_11","DEU","10","11","11","耶和华对我说：‘你起来，走在人民的前面，使他们可以进去，得着我向他们列祖起誓赐给他们的那地。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT10_12","006_10_12","DEU","10","12","12","“以色列啊，现在耶和华你的　神向你要的是什么呢？只要你敬畏耶和华你的　神，行在他的一切道路上，爱他，一心一意事奉耶和华你的　神， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT10_13","006_10_13","DEU","10","13","13","遵守耶和华的诫命和律例，就是我今日吩咐你的，为要叫你得福。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT10_14","006_10_14","DEU","10","14","14","看哪，天和天上的天，地和地上的一切都是属于耶和华你的　神的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT10_15","006_10_15","DEU","10","15","15","但耶和华只喜悦你的列祖，爱他们；他从万民中拣选了他们的后裔，就是你们，像今日一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT10_16","006_10_16","DEU","10","16","16","所以你们要给你们的心行割礼，不可再顽固。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT10_17","006_10_17","DEU","10","17","17","因为耶和华你们的　神，他是万神之神、万主之主、伟大有力和可畏的　神；他不徇情面，也不受贿赂。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT10_18","006_10_18","DEU","10","18","18","他为孤儿寡妇伸张正义，又把衣食给寄居的人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT10_19","006_10_19","DEU","10","19","19","所以你们要爱寄居的人，因为你们在埃及地也作过寄居的人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT10_20","006_10_20","DEU","10","20","20","你要敬畏耶和华你的　神，事奉他，依靠他，奉他的名起誓。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT10_21","006_10_21","DEU","10","21","21","他是你当颂赞的；他是你的　神，他为你作了那些大而可畏的事，就是你亲眼见过的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT10_22","006_10_22","DEU","10","22","22","你的列祖下到埃及的时候，一共不过七十人，现在耶和华你的　神却使你的人数像天上的星那么多了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT11_1","006_11_1","DEU","11","1","1","“所以你要爱耶和华你的　神，常常遵守他的吩咐、律例、典章和诫命。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT11_2","006_11_2","DEU","11","2","2","今日你们要知道，我并不是与你们的儿女说话，因为他们不知道，也没有见过耶和华你们的　神的管教、伟大有力的手和伸出来的膀臂， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT11_3","006_11_3","DEU","11","3","3","以及他在埃及向埃及王法老和法老的全国所行的神迹和作为； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT11_4","006_11_4","DEU","11","4","4","他们也没有见过他怎样对待埃及的军队、马匹和车辆；他们追赶你们的时候，耶和华怎样使红海的水淹没了他们，把他们灭绝，这事一直传到今日； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT11_5","006_11_5","DEU","11","5","5","并且耶和华在旷野怎样待你们，直到你们来到了这个地方； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT11_6","006_11_6","DEU","11","6","6","也没有见过他怎样对待流本的子孙以利押的儿子大坍、亚比兰；大地怎样在全体以色列人中间裂开了，把他们和他们的家人、帐棚，以及与他们在一起一切有生命之物都吞下去； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT11_7","006_11_7","DEU","11","7","7","只有你们亲眼看见了耶和华所作的一切伟大的作为。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT11_8","006_11_8","DEU","11","8","8","“所以你们要遵守我今日吩咐你的一切诫命，使你们坚强起来，可以进去得着你们将要过去得的那地， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT11_9","006_11_9","DEU","11","9","9","又使你们在耶和华向你们的列祖起誓应许赐给他们和他们后裔的地上，就是流奶与蜜的地，可以长久居住。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT11_10","006_11_10","DEU","11","10","10","因为你要进去得的那地，并不像你出来的埃及地；在那里你撒了种，还要用脚灌溉，像菜园一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT11_11","006_11_11","DEU","11","11","11","但你们要过去得为业的地，却是一个有山有谷的地，有天上雨水滋润的地， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT11_12","006_11_12","DEU","11","12","12","就是耶和华你的　神眷顾的地；从岁首到年终，耶和华你的　神的眼目常常眷顾这地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT11_13","006_11_13","DEU","11","13","13","“如果你们留心听我今日吩咐你们的诫命，爱耶和华你们的　神，一心一意事奉他， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT11_14","006_11_14","DEU","11","14","14","他必按时降雨在你们的地上，就是降秋雨和春雨，使你们可以丰收五谷、新酒和新油。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT11_15","006_11_15","DEU","11","15","15","他也必使田野为你的牲畜长出青草来，你也可以吃得饱足。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT11_16","006_11_16","DEU","11","16","16","你们要谨慎，免得你们的心受迷惑，你们就偏离了我，去事奉别的神，并且敬拜它们； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT11_17","006_11_17","DEU","11","17","17","叫耶和华的怒气向你发作，就把天封闭，不降下雨水，地也不生出土产，使你们从耶和华赐给你们的美地上，快快地灭亡。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT11_18","006_11_18","DEU","11","18","18","“所以你们要把我这些话放在心里，存在意念中；要系在手上作记号，戴在额上作头带。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT11_19","006_11_19","DEU","11","19","19","你们也要把这些话教训你们的儿女，无论你是坐在家里，行在路上，躺下，或是起来，都要讲论。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT11_20","006_11_20","DEU","11","20","20","你要把这些话写在你房屋的门柱上和城门上， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT11_21","006_11_21","DEU","11","21","21","为要叫你们和你们的子孙的日子，在耶和华向你们列祖起誓应许给他们的地上，可以增多，像天覆地的年日那样多。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT11_22","006_11_22","DEU","11","22","22","如果你们殷勤谨守遵行我吩咐你们的这一切诫命，爱耶和华你们的　神，行他的一切道路，又紧紧地依靠他， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT11_23","006_11_23","DEU","11","23","23","耶和华就必从你们面前把这些国民都赶出去，你们就必占领比你们大比你们强的国民的地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT11_24","006_11_24","DEU","11","24","24","你们脚掌所踏的地，都必属于你们；从旷野到黎巴嫩，从幼发拉底河直到西海，都要作你们的境界。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT11_25","006_11_25","DEU","11","25","25","必没有一人能在你们面前站立得住；耶和华你们的　神，必照着他对你们所说的，使害怕和惊惧你们的心临到你们将要踏足之地的居民。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT11_26","006_11_26","DEU","11","26","26","“看哪，我今日把祝福和咒诅都摆在你们面前。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT11_27","006_11_27","DEU","11","27","27","如果你们听从耶和华你们的　神的诫命，就是我今日吩咐你们的，你们就必蒙赐福； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT11_28","006_11_28","DEU","11","28","28","如果你们不听从耶和华你们的　神的诫命，偏离了我今日吩咐你们要走的道路，去随从你们素来不认识的别神，你们就必受咒诅。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT11_29","006_11_29","DEU","11","29","29","耶和华你的　神领你进入你要占领为业之地以后，你就要把祝福摆在基利心山上，把咒诅摆在以巴路山上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT11_30","006_11_30","DEU","11","30","30","这两座山不是在约旦河西、日落的地方，在住亚拉巴的迦南人之地，与吉甲相对，靠近摩利橡树那里吗？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT11_31","006_11_31","DEU","11","31","31","现在你们快要过约旦河，进去得耶和华你们的　神要赐给你们为业之地；你们取得了那地，就住在那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT11_32","006_11_32","DEU","11","32","32","你们要谨守遵行我今日在你们的面前颁布的一切律例和典章。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT12_1","006_12_1","DEU","12","1","1","“你们活在地上的一切日子，在耶和华你列祖的　神赐给你作产业的地上，要谨守遵行的律例和典章，就是这些： ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT12_2","006_12_2","DEU","12","2","2","你们要把你们赶走的列国的人事奉神的地方，无论是在高山上，在山冈上，或是在各青翠树下，都要完全毁坏； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT12_3","006_12_3","DEU","12","3","3","也要拆毁他们的祭坛，打碎他们的神柱；用火焚烧他们的亚舍拉，砍倒他们的神的雕像，并且把他们的名字从这地方除灭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT12_4","006_12_4","DEU","12","4","4","你们不可像他们那样事奉耶和华你的　神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT12_5","006_12_5","DEU","12","5","5","耶和华你们的　神从你们各支派中，选择了什么地方作立他名的居所，你们就当到那里求问他； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT12_6","006_12_6","DEU","12","6","6","把你们的燔祭和其他的祭物、十分之一的礼物和手中的贡献、还愿祭和甘心祭，以及牛群羊群中头生的，都要带到那里去； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT12_7","006_12_7","DEU","12","7","7","在那里，就是在耶和华你们的　神面前，你们和你们的家人都可以吃；并且要因你们手所作的一切事，都蒙耶和华你的　神赐福而欢乐。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT12_8","006_12_8","DEU","12","8","8","我们今日在这里所行的，是行各人看为正的事，你们将来不可以这样行； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT12_9","006_12_9","DEU","12","9","9","因为你们现在还没有到耶和华你的　神赐给你的安息地和产业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT12_10","006_12_10","DEU","12","10","10","但是你们过了约旦河，住在耶和华你们的　神使你们承受为业的地，又使你们太平，脱离你们周围的所有仇敌，安居乐业， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT12_11","006_12_11","DEU","12","11","11","那时，你要把我吩咐你们的燔祭和其他的祭物、十分之一的礼物和手中的贡献，以及你们向耶和华许愿要献的最美的一切还愿祭，都要带到耶和华你们的　神选择作为立他名的地方。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT12_12","006_12_12","DEU","12","12","12","你们和你们的儿女、仆婢，以及住在你们城里的利未人，都要在耶和华你们的　神面前欢乐，因为利未人在你们中间无分无业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT12_13","006_12_13","DEU","12","13","13","你要自己谨慎，不可在你看见的任何地方献上你的燔祭； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT12_14","006_12_14","DEU","12","14","14","只要在耶和华从你的一个支派中拣选的地方，在那里献上你的燔祭，在那里行我吩咐你的一切事。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT12_15","006_12_15","DEU","12","15","15","“不过在你的各城里，你都可以照着耶和华你的　神赐给你的福分，随意杀牲吃肉。不洁净的人和洁净的人都可以吃，像吃羚羊和鹿的肉一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT12_16","006_12_16","DEU","12","16","16","只有血，你们不可吃；要倒在地上，像倒水一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT12_17","006_12_17","DEU","12","17","17","你的五谷、新酒和新油的十分之一，你牛群羊群中头生的和你所许一切还愿的祭、你甘心献的祭和你手中的贡献，都不可在你的城里吃； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT12_18","006_12_18","DEU","12","18","18","你只要在耶和华你的　神面前，和在耶和华你的　神选择的地方吃，你和你的儿女、仆婢，以及在你城里的利未人，都可以吃；你也要因你手所作的一切事在耶和华你的　神面前欢乐。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT12_19","006_12_19","DEU","12","19","19","你要自己谨慎，你在你那地上的日子，永不可丢弃利未人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT12_20","006_12_20","DEU","12","20","20","“耶和华你的　神，照着他应许你的，扩张了你的境界的时候，如果你因心里渴想吃肉，说：‘我想吃肉。’那么，你就可以随意吃肉。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT12_21","006_12_21","DEU","12","21","21","耶和华你的　神选择作立他名的地方，如果离开你太远，你就可以照着我吩咐你的，把耶和华赐给你的牛羊取些宰杀了，可以在你的城里随意地吃。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT12_22","006_12_22","DEU","12","22","22","你吃那肉，好像人吃羚羊和鹿的肉一样；不洁净的人和洁净的人都可以一起吃。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT12_23","006_12_23","DEU","12","23","23","只是你要心意坚定，不可吃血，因为血就是生命；你不可把生命和肉一起吃。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT12_24","006_12_24","DEU","12","24","24","你不可吃血，要倒在地上，像倒水一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT12_25","006_12_25","DEU","12","25","25","你不可吃血，好使你和你的子子孙孙得享福乐，因为你行了耶和华看为正的事。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT12_26","006_12_26","DEU","12","26","26","只是你要把你应有的圣物和你的还愿祭，都带到耶和华选择的地方去， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT12_27","006_12_27","DEU","12","27","27","把你的燔祭、肉和血，都献在耶和华你的　神的祭坛上；其他的祭的血，要倒在耶和华你的　神的祭坛上；至于那肉，你却可以吃。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT12_28","006_12_28","DEU","12","28","28","你要谨慎听从我吩咐你的这一切话，好使你和你的子子孙孙永远得享福乐，因为你行了耶和华看为好为正的事。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT12_29","006_12_29","DEU","12","29","29","“耶和华你的　神把你将要进去赶走的列国的民，从你的面前除灭以后，你就得着他们的地，住在那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT12_30","006_12_30","DEU","12","30","30","那时，你要自己谨慎，不可在他们从你的面前被消灭以后，随从他们的恶俗而陷入网罗，也不可求问他们的神，说：‘这些国的人怎样事奉他们的神，我也要这样行。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT12_31","006_12_31","DEU","12","31","31","你不可向耶和华你的　神这样行，因为耶和华恨恶的一切可厌恶的事，他们都向他们的神行了，甚至把自己的儿女用火焚烧，献给他们的神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT12_32","006_12_32","DEU","12","32","32","“我吩咐你们的一切话，你们都要谨守遵行，不可加添，也不可减少。”（本节在《马索拉抄本》为 13:1） ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT13_1","006_13_1","DEU","13","1","1","“你们中间如果有先知，或作梦的人兴起来，给你显示神迹或奇事；（本节在《马索拉抄本》为 13:2） ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT13_2","006_13_2","DEU","13","2","2","他告诉你的神迹和奇事应验了，以致他对你说：‘我们去随从别的、你不认识的神，事奉他们吧。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT13_3","006_13_3","DEU","13","3","3","你不可听从那先知或作梦的人的话；因为耶和华你们的　神试验你们，要知道你们是不是一心一意爱耶和华你们的　神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT13_4","006_13_4","DEU","13","4","4","你们要顺从耶和华你们的　神，敬畏他，遵守他的诫命，听从他的话，事奉他，紧靠他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT13_5","006_13_5","DEU","13","5","5","至于那先知，或作梦的人，你们要把他处死，因为他说了叛逆的话，叛逆了那领你们出埃及地，救赎你脱离为奴之家的耶和华你们的　神，要你离弃耶和华你的　神吩咐你走的道路。这样你就把那恶从你们中间除掉了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT13_6","006_13_6","DEU","13","6","6","“你的同母兄弟或你的儿女，你怀中的妻子或视你如自己性命的朋友，如果暗中引诱你，说：‘我们去事奉别的神吧。’就是你和你的列祖向来不认识的， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT13_7","006_13_7","DEU","13","7","7","是你们周围各族的神，无论是离你近的，或是离你远的神；从地这边直到地那边的神， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT13_8","006_13_8","DEU","13","8","8","你都不可依从他，也不可听从他；你的眼不可顾惜他，你不可怜悯他，也不可袒护他； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT13_9","006_13_9","DEU","13","9","9","总要把他杀死，你要先向他动手，然后全民才动手打死他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT13_10","006_13_10","DEU","13","10","10","你要用石头打死他，因为他要使你离弃那领你出埃及地，脱离为奴之家的耶和华你的　神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT13_11","006_13_11","DEU","13","11","11","这样，全以色列听见了，必然害怕，就不会再在你们中间行这样的恶了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT13_12","006_13_12","DEU","13","12","12","“在耶和华你的　神赐给你居住的一座城中，如果你听说 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT13_13","006_13_13","DEU","13","13","13","有些匪徒从你中间出来，把本城的居民引离，说：‘我们去事奉别的神吧。’那些神是你们素来不认识的； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT13_14","006_13_14","DEU","13","14","14","你就要调查、研究，仔细访问，如果的确有这可厌恶的事行在你们中间， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT13_15","006_13_15","DEU","13","15","15","你就要用刀剑把那城里的居民杀掉，把那城和城里的一切，以及牲畜，都用刀剑完全毁灭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT13_16","006_13_16","DEU","13","16","16","并且把从城里掠夺的一切战利品，都要收集在那城的广场上，用火把城和在城里掠夺的一切战利品焚烧，献给耶和华你的　神；那城就要永远成为废墟，不可再建造。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT13_17","006_13_17","DEU","13","17","17","那当毁灭的物，一点也不可留在你手中，好使耶和华转意不发烈怒，反而向你施恩，怜悯你，照着他向你的列祖所起的誓，使你的人数增多； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT13_18","006_13_18","DEU","13","18","18","只要你听从耶和华你的　神的话，遵守我今日吩咐你的一切诫命，实行耶和华你的　神看为正的事，就必这样。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT14_1","006_14_1","DEU","14","1","1","“你们是耶和华你们的　神的儿女，不可为了死人割伤自己的身体，也不可使你们的额上光秃； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT14_2","006_14_2","DEU","14","2","2","因为你是属于耶和华你的　神的圣洁子民；耶和华从地上的万民中拣选了你们，特作他自己的子民。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT14_3","006_14_3","DEU","14","3","3","“可厌恶之物，你都不可吃。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT14_4","006_14_4","DEU","14","4","4","你们可以吃的牲畜是以下这些：牛、绵羊、山羊、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT14_5","006_14_5","DEU","14","5","5","鹿、羚羊、赤鹿、野山羊、麋鹿、野羊、野鹿。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT14_6","006_14_6","DEU","14","6","6","在走兽中，分蹄成两蹄趾，又反刍的走兽，你们都可以吃。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT14_7","006_14_7","DEU","14","7","7","但是那些反刍或分蹄的走兽中，你们不可吃的有：骆驼、兔子和石獾，因为它们反刍却不分蹄，就对你们不洁净。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT14_8","006_14_8","DEU","14","8","8","至于猪，因为它分蹄却不反刍，就对你们不洁净。它们的肉，你们不可吃；它们的尸体，你们不可触摸。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT14_9","006_14_9","DEU","14","9","9","“在水中，你们可以吃的，有以下这些：有鳍有鳞的，你们都可以吃。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT14_10","006_14_10","DEU","14","10","10","有鳍没有鳞的，你们都不可吃；这是对你们不洁净的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT14_11","006_14_11","DEU","14","11","11","“洁净的鸟类，你们都可以吃。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT14_12","006_14_12","DEU","14","12","12","你们不可吃的鸟类有以下这些：鹰、狗头鹰、红头鹰、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT14_13","006_14_13","DEU","14","13","13","鸢、隼、黑隼，以及这一类的鸟； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT14_14","006_14_14","DEU","14","14","14","乌鸦和这一类的鸟； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT14_15","006_14_15","DEU","14","15","15","驼鸟、夜鹰、海鹰、雀鹰，以及这一类的鸟； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT14_16","006_14_16","DEU","14","16","16","小猫头鹰、猫头鹰、角鸱、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT14_17","006_14_17","DEU","14","17","17","小枭、秃雕、鱼鹰、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT14_18","006_14_18","DEU","14","18","18","鹳、鹭，以及这一类的鸟；戴胜和蝙蝠。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT14_19","006_14_19","DEU","14","19","19","有翅膀的昆虫，对你们都不洁净，你们都不可吃。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT14_20","006_14_20","DEU","14","20","20","洁净的鸟类，你们都可以吃。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT14_21","006_14_21","DEU","14","21","21","“自死的动物，你们都不可吃；可以送给你城里的寄居者吃，或是卖给外族人吃，因为你是归耶和华为圣的子民；不可用山羊羔母的奶煮山羊羔。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT14_22","006_14_22","DEU","14","22","22","“你要把你撒种所产的，就是田地每年所出的，献上十分之一。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT14_23","006_14_23","DEU","14","23","23","又要把你的五谷、新酒和新油的十分之一，以及你牛群羊群中头生的，在耶和华你的　神面前吃，就是在他选择作他名的居所的地方吃，好使你可以学习常常敬畏耶和华你的　神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT14_24","006_14_24","DEU","14","24","24","耶和华你的　神赐福与你的时候，耶和华你的　神选择要立为他名的地方，如果离你太远，那路又太长，使你不能把供物带到那里去； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT14_25","006_14_25","DEU","14","25","25","你就可以换成银子，把银子拿在手里，到耶和华你的　神选择的地方去， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT14_26","006_14_26","DEU","14","26","26","你可以用这银子随意买牛羊、清酒和烈酒；你心想要的，都可以买；在那里，你和你的家人，都要在耶和华你的　神面前吃喝欢乐。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT14_27","006_14_27","DEU","14","27","27","住在你城里的利未人，你不可丢弃他，因为他在你们中间无分无业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT14_28","006_14_28","DEU","14","28","28","“每三年之末，你要把那一年的全部出产的十分之一取出来，积存在你的城里； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT14_29","006_14_29","DEU","14","29","29","这样，利未人（因为他在你们中间无分无业），以及在你城里的寄居者和孤儿寡妇，就可以来，吃得饱足；好叫耶和华你的　神，在你手所作的一切事上，赐福给你。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT15_1","006_15_1","DEU","15","1","1","“每七年的最后一年，你要施行豁免。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT15_2","006_15_2","DEU","15","2","2","豁免的方式是这样：债主都要把借给邻舍的一切豁免了，不可向邻舍和兄弟追讨，因为耶和华的豁免年已经宣告了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT15_3","006_15_3","DEU","15","3","3","如果借给外族人，你可以向他追讨，但借给你的兄弟，无论你借的是什么，你都要豁免。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT15_4","006_15_4","DEU","15","4","4","在你中间必没有穷人，因为在耶和华你的　神赐给你作产业的地上，耶和华必大大赐福给你。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT15_5","006_15_5","DEU","15","5","5","只要你留心听从耶和华你的　神的话，谨守遵行我今日吩咐你的一切诫命。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT15_6","006_15_6","DEU","15","6","6","因为耶和华你的　神，必照着他应许你的，赐福给你；你必借贷给许多国的民，却不会向他们借贷；你必统治许多国的民，他们却不会统治你。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT15_7","006_15_7","DEU","15","7","7","“但是在耶和华你的　神赐给你的地上，无论哪一座城里，在你中间如果有一个穷人，又是你的兄弟，你对这穷苦的兄弟不可硬着心肠，也不可袖手不理。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT15_8","006_15_8","DEU","15","8","8","你一定要向他伸手，照着他缺乏的借给他，补足他的缺乏。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT15_9","006_15_9","DEU","15","9","9","你要自己谨慎，不可心里起恶念，说：‘第七年的豁免年近了’，你就冷眼对待你穷苦的兄弟，什么都不给他，以致他因你求告耶和华，你就有罪了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT15_10","006_15_10","DEU","15","10","10","你必须给他，给他的时候，你不要心里难受，因为为了这事，耶和华你的　神必在你一切工作上，和你所办的一切事上，赐福给你。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT15_11","006_15_11","DEU","15","11","11","既然在地上必有穷人存在，所以我吩咐你说：‘你总要向你地上的困苦和贫穷的兄弟大伸援助之手。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT15_12","006_15_12","DEU","15","12","12","“你的兄弟，无论是希伯来男人，或是希伯来女人，如果卖身给你，要服事你六年；到第七年，就要让他离开你得自由。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT15_13","006_15_13","DEU","15","13","13","你使他自由离开的时候，不可让他空手而去； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT15_14","006_15_14","DEU","15","14","14","要从你的羊群、禾场、榨酒池中，多多地供给他；耶和华你的　神怎样赐福给你，你也要怎样分给他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT15_15","006_15_15","DEU","15","15","15","你要记得你在埃及地作过奴仆，耶和华你的　神救赎了你；因此我今日吩咐你这件事。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT15_16","006_15_16","DEU","15","16","16","如果他对你说：‘我不愿离开你。’他说这话是因为他爱你和你的家，又因为他喜欢和你相处， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT15_17","006_15_17","DEU","15","17","17","那么，你就要拿锥子，把他的耳朵在门上刺透，他就永远作你的奴仆；对待你的婢女，你也要这样行。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT15_18","006_15_18","DEU","15","18","18","你使他自由离开你的时候，不要为难，因为他服事了你六年，应得雇工双倍的工资；这样，耶和华你的　神必在你所作的一切事上，赐福给你。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT15_19","006_15_19","DEU","15","19","19","“你的牛群羊群中所生，是头生雄性的，你都要把它分别为圣归给耶和华你的　神。你的牛群中头生的，你不可用它去耕田；你的羊群中头生的，你不可给它剪毛。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT15_20","006_15_20","DEU","15","20","20","你和你的家人，年年要在耶和华选择的地方，在耶和华你的　神面前，吃这头生的牲畜。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT15_21","006_15_21","DEU","15","21","21","这头生的，如果有什么残疾，像瘸腿或是瞎眼，无论有任何严重的残疾，你都不可献给耶和华你的　神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT15_22","006_15_22","DEU","15","22","22","你可以在家里吃，不洁净的人和洁净的人都一样可以吃，像吃羚羊和鹿一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT15_23","006_15_23","DEU","15","23","23","只是不可吃它的血；要把血倒在地上，像倒水一样。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT16_1","006_16_1","DEU","16","1","1","“你要守亚笔月，向耶和华你的　神守逾越节，因为耶和华你的　神在亚笔月的一个晚上，把你从埃及地领出来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT16_2","006_16_2","DEU","16","2","2","你要在耶和华选择立为他名的居所的地方，把羊和牛作逾越节的祭牲献给耶和华你的　神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT16_3","006_16_3","DEU","16","3","3","你吃这祭的时候，不可和有酵的饼一同吃；七日之内，你要吃无酵饼，就是困苦饼，因为你是急急忙忙从埃及地出来的，好使你一生的年日都可以记念你从埃及地出来的日子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT16_4","006_16_4","DEU","16","4","4","七天之内，在你的全境不可见有酵。第一天晚上你献的祭肉，一点也不可剩下，留到早晨。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT16_5","006_16_5","DEU","16","5","5","你不能在耶和华你的　神赐给你的任何一座城里，宰杀逾越节的祭牲； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT16_6","006_16_6","DEU","16","6","6","只能在耶和华你的　神选择作他名的居所的地方，晚上日落的时候，就是你出埃及的时刻，宰杀逾越节的祭牲； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT16_7","006_16_7","DEU","16","7","7","你要在耶和华你的　神选择的地方，把祭肉煮了吃；到了早晨，你才可以回到家里去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT16_8","006_16_8","DEU","16","8","8","六日之内你要吃无酵饼；到了第七日，要向耶和华你的　神守圣会；什么工都不可作。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT16_9","006_16_9","DEU","16","9","9","“你要计算七个七日，从开镰收割禾稼的时候算起，共计七个七日。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT16_10","006_16_10","DEU","16","10","10","你要向耶和华你的　神举行七七节，照着耶和华你的　神赐福你的，尽你所能的献上你手里的甘心祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT16_11","006_16_11","DEU","16","11","11","你和你的儿女、仆婢，以及在你城里的利未人、在你们中间的寄居者、孤儿和寡妇，都要在耶和华你的　神选择作他名的居所的地方欢乐。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT16_12","006_16_12","DEU","16","12","12","你也要记得你在埃及作过奴仆；你要谨守遵行这些律例。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT16_13","006_16_13","DEU","16","13","13","“你从禾场上和榨酒池里收藏了出产以后，就要举行住棚节七日。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT16_14","006_16_14","DEU","16","14","14","在这节期以内，你和你的儿女、仆婢，以及住在你城里的利未人、寄居者、孤儿和寡妇，都要欢乐。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT16_15","006_16_15","DEU","16","15","15","你要在耶和华选择的地方，向耶和华你的　神守节七日，因为耶和华你的　神，要在你一切土产上，和你手所作的一切事上，赐福给你，你就满有欢乐。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT16_16","006_16_16","DEU","16","16","16","每年三次，就是在除酵节、七七节、住棚节，你所有的男丁都要在耶和华选择的地方，朝见耶和华你的　神；但不可空手朝见耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT16_17","006_16_17","DEU","16","17","17","各人要按手中的力量，照着耶和华你的　神赐你的福，奉献礼物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT16_18","006_16_18","DEU","16","18","18","“在耶和华你的　神赐给你的各城里，你要按着各支派设立审判官和官长；他们要按着公义的判断审判人民。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT16_19","006_16_19","DEU","16","19","19","不可屈枉正直，不可徇人的情面，不可收受贿赂，因为贿赂能使智慧人的眼变瞎，也能使义人的话颠倒过来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT16_20","006_16_20","DEU","16","20","20","你要追求公正公义，好使你能存活，并且能承受耶和华你的　神赐给你的地作产业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT16_21","006_16_21","DEU","16","21","21","“在你为耶和华你的　神筑的祭坛旁边，不可栽种什么树木，作亚舍拉。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT16_22","006_16_22","DEU","16","22","22","也不可为自己竖立神柱，这是耶和华你的　神所恨恶的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT17_1","006_17_1","DEU","17","1","1","“有残疾，或有什么缺点的牛羊，都不可献给耶和华你的　神，因为这是耶和华你的　神所憎恶的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT17_2","006_17_2","DEU","17","2","2","“在你中间，就是耶和华你的　神赐给你的任何一座城里，如果发现有人，无论是男是女，行耶和华你的　神眼中看为恶的事，违犯了他的约， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT17_3","006_17_3","DEU","17","3","3","去事奉别的神，并且敬拜它们，敬拜太阳或月亮，或任何天象，是我耶和华没有吩咐的； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT17_4","006_17_4","DEU","17","4","4","有人告诉你，你也听见了，就要好好调查；如果确有这些事，真的在以色列中行了这可憎可厌的事； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT17_5","006_17_5","DEU","17","5","5","你就要把那个行了这恶事的男人或女人带出来，到城门那里去，用石头把他们打死。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT17_6","006_17_6","DEU","17","6","6","凭着两个或三个见证人的口供，就可以把那该死的人处死；只是凭着一个见证人的口供，却不可以把人处死。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT17_7","006_17_7","DEU","17","7","7","见证人要先下手，然后众民也下手，把他处死。这样，你就把那恶从你中间除掉。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT17_8","006_17_8","DEU","17","8","8","“在你的城里如果有什么争讼的事：或是流血，或是诉讼，或是殴打，是你很难处决的案件，你就要起来，上到耶和华你的　神选择的地方， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT17_9","006_17_9","DEU","17","9","9","去见利未支派的祭司和当时的审判官，询问他们，他们就必指示你们怎样判断这案件。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT17_10","006_17_10","DEU","17","10","10","你要照着他们从耶和华选择的那地方，向你指示的话去行；他们指教你的，你都要谨守遵行。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT17_11","006_17_11","DEU","17","11","11","你要按着他们指教你的律法，和照着他们告诉你的判断去行；他们告诉你的话，你不可偏左或偏右。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT17_12","006_17_12","DEU","17","12","12","如果有人擅自行事，不听从祭司，就是侍立在那里事奉耶和华你的　神的，或是不听从审判官，那人就必须处死；这样，你就可以把这恶从以色列中肃清了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT17_13","006_17_13","DEU","17","13","13","众民都会听见，而且惧怕，也不再擅自行事了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT17_14","006_17_14","DEU","17","14","14","“你进了耶和华你的　神赐给你的地，占领了那地，居住在那里的时候，如果你说：‘我要立一位君王治理我，像我四围的列国一样。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT17_15","006_17_15","DEU","17","15","15","你总要立耶和华你的　神拣选的人作君王管理你；你要从你的兄弟中立一位作你的君王；不可立你的兄弟以外的人作王管理你。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT17_16","006_17_16","DEU","17","16","16","只是君王不可为自己加添马匹，也不可使人民回埃及去，为要加添马匹，因为耶和华曾经对你们说过：‘你们不可再回到那条路去。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT17_17","006_17_17","DEU","17","17","17","他也不可为自己加添妃嫔，恐怕他的心偏离了耶和华；也不可为自己积蓄极多的金钱。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT17_18","006_17_18","DEU","17","18","18","“他登上了国位的时候，就要把利未支派的祭司面前的律法书，为自己抄录一份副本。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT17_19","006_17_19","DEU","17","19","19","那份副本要常在他身边，他一生的年日都要诵读，好学习敬畏耶和华他的　神，谨守遵行这律法书上的一切话和这些律例。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT17_20","006_17_20","DEU","17","20","20","这样，他的心就不会高傲，轻看自己的兄弟，也不会偏左偏右，离了这诫命；好使他和他的子孙在以色列中，在他的国位上，可以日子长久。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT18_1","006_18_1","DEU","18","1","1","“利未支派的祭司和利未整个支派，在以色列中，必无分无业；他们所吃的，是献给耶和华的火祭和他们应得的一份。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT18_2","006_18_2","DEU","18","2","2","利未人在兄弟中必没有产业，耶和华就是他们的产业，正如耶和华应许他们的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT18_3","006_18_3","DEU","18","3","3","“祭司从人民应得的分是这样：人无论是献牛或是献羊，要把前腿、两腮和胃给祭司。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT18_4","006_18_4","DEU","18","4","4","你也要把初熟的五谷、新酒、新油和初剪的羊毛给他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT18_5","006_18_5","DEU","18","5","5","因为耶和华你的　神从你的各支派中把他拣选出来，使他和他的子孙，可以常常奉耶和华的名侍立供祭司的职。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT18_6","006_18_6","DEU","18","6","6","“如果有住在以色列中任何一座城里的利未人，离开了那里，一心一意到耶和华选择的地方去， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT18_7","006_18_7","DEU","18","7","7","他就可以奉耶和华他的　神的名供职，像他的众兄弟利未人在那里侍立在耶和华面前一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT18_8","006_18_8","DEU","18","8","8","除了他从父家承受的产业以外，他还可以得着和他的兄弟相等分量的祭物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT18_9","006_18_9","DEU","18","9","9","“你到了耶和华你的　神要赐给你的那地的时候，那些外族人可厌可恶的事，你不可学习去行。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT18_10","006_18_10","DEU","18","10","10","在你中间不可有人把自己的儿女献作火祭，也不可有占卜的、算命的、用法术的、行邪术的、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT18_11","006_18_11","DEU","18","11","11","念咒的、问鬼的、行巫术的、过阴的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT18_12","006_18_12","DEU","18","12","12","因为行这些事的，都是耶和华厌恶的；就是因为这些可厌可恶的事的缘故，耶和华你的　神才把他们从你的面前赶走。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT18_13","006_18_13","DEU","18","13","13","你要在耶和华你的　神面前作完全人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT18_14","006_18_14","DEU","18","14","14","“因为你要赶走的那些民族，都听从算命的和占卜的；至于你，耶和华你的　神却不容许你这样行。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT18_15","006_18_15","DEU","18","15","15","“耶和华你的　神要从你中间，就是从你的众兄弟中间，给你兴起一位先知来，像我一样；你们要听从他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT18_16","006_18_16","DEU","18","16","16","这正是你在何烈山开大会的日子，求耶和华你的　神的一切话，说：‘不要让我再听见耶和华我的　神的声音了；也不要让我再看见这大火了，免得我死亡。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT18_17","006_18_17","DEU","18","17","17","耶和华对我说：‘他们所说的都很好。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT18_18","006_18_18","DEU","18","18","18","我要从他们的兄弟中间，给他们兴起一位先知，像你一样；我要把我的话放在他口里，他必把我吩咐他们的一切话都对他们说。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT18_19","006_18_19","DEU","18","19","19","如果有人不听从他奉我的名所说的话，我必亲自追讨那人的罪。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT18_20","006_18_20","DEU","18","20","20","“‘不过，如果有先知擅自奉我的名，说我没有吩咐他说的话，或是奉别神的名说话，那先知就必须处死。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT18_21","006_18_21","DEU","18","21","21","如果你心里说：‘耶和华没有说过的话，我们怎能知道呢？’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT18_22","006_18_22","DEU","18","22","22","一位先知奉耶和华的名说话，如果那话不成就，也不应验，这话就不是耶和华说的；是那先知擅自说的，你不要怕他。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT19_1","006_19_1","DEU","19","1","1","“耶和华你的　神把列国的民剪除了，耶和华你的　神把他们的地赐给了你，你赶走了那些国民，住在他们的城市和房屋以后， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT19_2","006_19_2","DEU","19","2","2","你就要在耶和华你的　神赐给你得为业的地上，为自己分别三座城。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT19_3","006_19_3","DEU","19","3","3","你要为自己预备道路，又要把耶和华你的　神给你作产业的地分为三区，使误杀人的可以逃到那里去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT19_4","006_19_4","DEU","19","4","4","“误杀人的逃到那里，就可以存活，规例是这样：无意杀了人，彼此又素无仇恨的， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT19_5","006_19_5","DEU","19","5","5","譬如他和邻舍同进森林砍伐树木，他手里挥着斧子砍伐树木的时候，斧头竟脱了把，落在邻舍身上，以致那人死了，他就可以逃到这些城中的一座去，这样他就可以活命， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT19_6","006_19_6","DEU","19","6","6","免得报血仇的，心中怒火如焚的时候，追赶那误杀人的，因为路途长远，就追上了他，把他杀死；其实他没有该死的罪，因为他和那人素无仇恨。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT19_7","006_19_7","DEU","19","7","7","因此我吩咐你：‘你要为自己分别三座城。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT19_8","006_19_8","DEU","19","8","8","如果耶和华你的　神照着他向你列祖起过的誓，扩张你的境界，把他应许赐给你列祖的全地，都赐给了你， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT19_9","006_19_9","DEU","19","9","9","如果你谨守遵行我今日吩咐你的这一切诫命，爱耶和华你的　神，常常行他的道路，你就要在这三座城以外，再加添三座城； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT19_10","006_19_10","DEU","19","10","10","免得无辜人的血，流在耶和华你的　神要赐给你作产业的地上，以致流人血的罪归在你身上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT19_11","006_19_11","DEU","19","11","11","“但是，如果有人恨他的邻舍，埋伏着等他，起来攻击他，把他杀死了，然后逃到这些城中的一座； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT19_12","006_19_12","DEU","19","12","12","他本城的长老要派人去，把他从那里带出来，交在报血仇的人手中，好把他处死。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT19_13","006_19_13","DEU","19","13","13","你的眼睛不可顾惜他，却要把流无辜人的血的罪从以色列中除掉，好使你平安无事。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT19_14","006_19_14","DEU","19","14","14","“在耶和华你的　神要赐给你承受为业的地上，不可挪移你邻舍的地界，因为那是先人立定的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT19_15","006_19_15","DEU","19","15","15","“人无论有什么过错，或是犯了什么罪恶，不可凭着一个见证人的指证，总要凭着两个见证人的口供，或是三个见证人的口供，才可以确定。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT19_16","006_19_16","DEU","19","16","16","如果有强横的见证人起来，指证某人作恶， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT19_17","006_19_17","DEU","19","17","17","那么，两个彼此争讼的人，就要站在耶和华面前，和当时在职的祭司与审判官面前。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT19_18","006_19_18","DEU","19","18","18","审判官要仔细查问；如果见证人是个假证人，作假见证陷害自己的兄弟， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT19_19","006_19_19","DEU","19","19","19","你们就要像他想怎样对待自己的兄弟一样对待他，这样，你就把那恶从你们中间除掉。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT19_20","006_19_20","DEU","19","20","20","其余的人听见了，就必害怕，不敢再在你中间行这样的恶事了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT19_21","006_19_21","DEU","19","21","21","你的眼睛不可顾惜，要以命偿命，以眼还眼，以牙还牙，以手还手，以脚还脚。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT20_1","006_20_1","DEU","20","1","1","“你出去和你的仇敌作战的时候，看见马匹、车辆和比你多的人群，你不要怕他们，因为那把你们从埃及地领上来的耶和华你的　神，与你同在。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT20_2","006_20_2","DEU","20","2","2","你们快要上战场的时候，祭司要上前来，对人民说话， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT20_3","006_20_3","DEU","20","3","3","对他们说：‘以色列人哪，你们要听，你们今日快要和仇敌作战，你们不要胆怯，不要惧怕，不要惊慌，不要因他们的缘故战兢； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT20_4","006_20_4","DEU","20","4","4","因为耶和华你们的　神和你们同去，要为你们攻打你们的仇敌，要拯救你们。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT20_5","006_20_5","DEU","20","5","5","官长也要对人民宣告：‘谁建造了新房屋，还没有行过奉献礼的，他可以回家去，恐怕他死在战场上，别人去为他的房屋行奉献礼。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT20_6","006_20_6","DEU","20","6","6","谁栽种了葡萄园，还没有享用过它的果子的，他可以回家去，恐怕他死在战场上，别人去享用它的果子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT20_7","006_20_7","DEU","20","7","7","谁与女子订了婚，还没有迎娶的，他可以回家去，恐怕他死在战场上，别人去娶了她。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT20_8","006_20_8","DEU","20","8","8","官长又要对人民宣告：‘谁是惧怕、胆怯的，他可以回家去，恐怕他使他兄弟的心融化，像他的心一样。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT20_9","006_20_9","DEU","20","9","9","官长对人民讲完了话，就要指派军官统率他们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT20_10","006_20_10","DEU","20","10","10","“你临近一座城，要攻打那城的时候，要先向那城提和议。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT20_11","006_20_11","DEU","20","11","11","如果那城以和平的话回答你，给你开门，城里所有的人都要给你作苦工，服事你。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT20_12","006_20_12","DEU","20","12","12","如果那城不肯与你言和，却要与你作战，你就要围困那城。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT20_13","006_20_13","DEU","20","13","13","耶和华你的　神把城交在你手里的时候，你要用利刃杀尽城里所有的男丁。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT20_14","006_20_14","DEU","20","14","14","只有妇人、小孩子、牲畜和城里所有的一切，就是一切战利品，你都可以据为己有，你的仇敌的战利品，你都可以吃用，因为这是耶和华你的　神赐给你的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT20_15","006_20_15","DEU","20","15","15","离开你很远的各城，不是属于这些国民的城，你都要这样对待他们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT20_16","006_20_16","DEU","20","16","16","只是在耶和华你的　神赐给你作产业的这些国民的城市里，凡有气息的，连一个你也不可让他活着； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT20_17","006_20_17","DEU","20","17","17","只要照着耶和华你的　神吩咐你的，把赫人、亚摩利人、迦南人、比利洗人、希未人、耶布斯人，完全灭绝； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT20_18","006_20_18","DEU","20","18","18","免得他们教导你们学习一切可憎的事，就是他们对自己的神所行的事，以致他们得罪耶和华你们的　神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT20_19","006_20_19","DEU","20","19","19","“如果你围困一座城，很久才能攻取占领它，你就不可挥斧破坏那里的树木；因为你可以吃树上的果子，却不可以砍伐树木。难道田间的树木是人，可以被你围困的吗？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT20_20","006_20_20","DEU","20","20","20","只有你知道不结果子的树木，你才可以毁坏砍伐，用来建造围城的设备，攻击那与你作战的城，直到把它攻下为止。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT21_1","006_21_1","DEU","21","1","1","“在耶和华你的　神赐给你作产业的地上，如果发现有被杀的人，倒卧在田野，又不知道是谁杀死他的， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT21_2","006_21_2","DEU","21","2","2","这样，你的长老和审判官就要出去，量一下从被杀的人那里到四周城市的距离。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT21_3","006_21_3","DEU","21","3","3","看看哪一座城离那被杀的人最近，那城的长老就要从牛群中取一只母牛犊，就是还没有耕过地、没有负过轭的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT21_4","006_21_4","DEU","21","4","4","那城的长老要把母牛犊牵下去，到一个有活水长流的山谷，就是未曾耕种过、未曾撒过种的地方，在那里要打折母牛犊的颈项。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT21_5","006_21_5","DEU","21","5","5","利未支派的祭司的子孙要上前来，因为耶和华你的　神拣选了他们事奉他，奉耶和华的名祝福。一切争讼和一切殴打的事，都要凭他们的话决定。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT21_6","006_21_6","DEU","21","6","6","那城所有的长老，就是离那被杀的人最近的，都要在山谷中，在被折断颈项的母牛犊以上洗手。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT21_7","006_21_7","DEU","21","7","7","他们要声明，说：‘我们的手未曾流过这人的血，我们的眼也未曾看见这事。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT21_8","006_21_8","DEU","21","8","8","耶和华啊，求你赦免你的子民以色列，就是你救赎的，不要使流无辜人的血的罪归在你的子民以色列中间。’这样，他们流人血的罪就得到赦免了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT21_9","006_21_9","DEU","21","9","9","如果你行耶和华看为正的事，就可以从你中间除掉流无辜人的血的罪了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT21_10","006_21_10","DEU","21","10","10","“你出去和仇敌作战的时候，耶和华你的　神把他们交在你手里，你就把他们掳了去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT21_11","006_21_11","DEU","21","11","11","如果你在被掳的人中看见了容貌美好的女子，就恋慕她，要娶她作妻子， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT21_12","006_21_12","DEU","21","12","12","那么，你可以把她带进你的家里；她要剃头修甲， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT21_13","006_21_13","DEU","21","13","13","脱去被掳时所穿的衣服，住在你家里，为自己的父母哀哭一个月，然后你才可以亲近她；你作她的丈夫，她作你的妻子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT21_14","006_21_14","DEU","21","14","14","如果将来你不喜欢她，就要让她随意离去，决不可为了钱把她出卖，也不可以她为奴，因为你已经污辱了她。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT21_15","006_21_15","DEU","21","15","15","“如果人有两个妻子，一个是他喜爱的，一个是他不喜爱的，两个都给他生了儿子；但长子是他不喜爱的妻子生的； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT21_16","006_21_16","DEU","21","16","16","到了他把所有的产业分给儿子承受的日子，他不可把他喜爱的妻子的儿子立为长子，排在他不喜爱的妻子的儿子以上，他才是长子； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT21_17","006_21_17","DEU","21","17","17","却要承认他不喜爱的妻子的儿子为长子，把所有的产业分两分给他，因为这儿子是他强壮有力的时候所生的头生子，长子的权利本是属于他的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT21_18","006_21_18","DEU","21","18","18","“如果人有忤逆倔强的儿子，不听从父母的话；父母管教他以后，他还是不听从； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT21_19","006_21_19","DEU","21","19","19","他的父母就要捉住他，把他带到当地的城门，去见本城的长老， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT21_20","006_21_20","DEU","21","20","20","对本城的长老说：‘我们这个儿子忤逆倔强，不听从我们的话，是个贪食好酒的人。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT21_21","006_21_21","DEU","21","21","21","全城的人就要用石头打死他；这样，你就把那恶从你们中间除掉。以色列众人听见了，就都惧怕。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT21_22","006_21_22","DEU","21","22","22","“如果人犯了该死的罪，被处死以后，你就把他挂在木头上； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT21_23","006_21_23","DEU","21","23","23","他的尸体不可留在树上过夜，必须在当日把他埋葬，因为被挂在木头上的，是受　神咒诅的；这样，你就不至于玷污耶和华你的　神赐给你作产业的地了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT22_1","006_22_1","DEU","22","1","1","“如果你看见你兄弟的牛或羊走迷了，你不可不理，总要把它们牵回你的兄弟那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT22_2","006_22_2","DEU","22","2","2","如果你的兄弟离你很远，或是你不认识他，你就要把它牵到你家中，留在你那里，等到你的兄弟来寻找它，你就还给他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT22_3","006_22_3","DEU","22","3","3","对他的驴，你要这样行；对你的兄弟失去而被你找到的任何东西，你都要这样行，不可不理。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT22_4","006_22_4","DEU","22","4","4","如果你看见你兄弟的驴或牛跌倒在路上，你不可不理，总要帮助他把它们拉起来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT22_5","006_22_5","DEU","22","5","5","“妇女不可穿男子的服装；男子也不可穿妇人的衣服；因为这样作的人，都是耶和华你的　神厌恶的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT22_6","006_22_6","DEU","22","6","6","“如果你在路上遇见鸟窝，或是在树上，或是在地上；里面有雏鸟，或是有蛋；母鸟伏在雏鸟身上，或在蛋上；你不可连母带子一起取去； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT22_7","006_22_7","DEU","22","7","7","总要让母鸟飞去，只可以取子；这样你就可以得着好处，得享长寿。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT22_8","006_22_8","DEU","22","8","8","“如果你建造新房屋，要在屋顶上作栏杆；免得有人从那里跌下来，流血的罪就归到你家。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT22_9","006_22_9","DEU","22","9","9","“不可把两样的种子撒在你的葡萄园里，免得你所种的全部收成和葡萄园的出产，都要充公分别为圣归给圣殿。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT22_10","006_22_10","DEU","22","10","10","你不可用牛和驴一同耕地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT22_11","006_22_11","DEU","22","11","11","不可穿羊毛和细麻混合织成的布料。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT22_12","006_22_12","DEU","22","12","12","“你要在所披的外衣上，四边做繸子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT22_13","006_22_13","DEU","22","13","13","“如果人娶妻，和她同房之后，就恨她， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT22_14","006_22_14","DEU","22","14","14","捏造可耻的事毁谤她，破坏她的名誉，说：‘我娶了这个女子，和她亲近的时候，发现她没有贞洁的凭据。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT22_15","006_22_15","DEU","22","15","15","那少女的父母就要把那少女的贞洁凭据拿出来，带到城门去见本城的长老。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT22_16","006_22_16","DEU","22","16","16","少女的父亲要对长老说：‘我把我的女儿给这人作妻子，他却恨她， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT22_17","006_22_17","DEU","22","17","17","捏造可耻的事毁谤她，说：“我发现你的女儿没有贞洁的凭据。”其实这就是我女儿的凭据。’于是，他们就把衣服铺在那城的长老面前。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT22_18","006_22_18","DEU","22","18","18","那城的长老要把那人捉住，惩罚他， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT22_19","006_22_19","DEU","22","19","19","罚他一千一百四十克银子，交给那少女的父亲，因为他破坏了一个以色列处女的名誉；那少女仍要作他的妻子，终生不能休她。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT22_20","006_22_20","DEU","22","20","20","但如果这事是真的，少女没有贞洁的凭据， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT22_21","006_22_21","DEU","22","21","21","就要把那少女带到她父家的门口，本城的人要用石头把她打死，因为她在以色列中作了丑事，在她父家行了淫乱；这样，你就把那恶从你们中间除去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT22_22","006_22_22","DEU","22","22","22","“如果发现有人和有夫之妇同寝，就要把奸夫淫妇二人都处死；这样，你就把那恶从以色列中除掉了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT22_23","006_22_23","DEU","22","23","23","“如果有个少女，本来是处女，已经许配了人，有人在城里遇见了她，和她同寝， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT22_24","006_22_24","DEU","22","24","24","你们就要把他们二人带到当地的城门口，用石头打死他们。那少女该死，是因为她虽在城里，却没有呼叫；那男人该死，是因为他玷污了邻舍的妻子；这样，你就把那恶从你们中间除掉。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT22_25","006_22_25","DEU","22","25","25","如果有人在田间遇见了已经许配人的少女，拉住她，和她同寝，只要把那和她同寝的人处死。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT22_26","006_22_26","DEU","22","26","26","但你不可对付那少女，她并没有该死的罪。这件事就像一个人忽然起来攻击自己的邻舍，你把他杀了一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT22_27","006_22_27","DEU","22","27","27","因为那人在田间遇见那少女，那已经许配人的少女呼叫了，却没有人救她。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT22_28","006_22_28","DEU","22","28","28","“如果有人遇见一个少女，原是处女，还没有许配过人，就抓住她，和她同寝，又被人发现， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT22_29","006_22_29","DEU","22","29","29","那和她同寝的人就要把五百七十克银子给那少女的父亲，那少女要归作他的妻子，因为他玷污了她；他终生不能休她。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT22_30","006_22_30","DEU","22","30","30","“人不可娶父亲的妻子，也不可揭开父亲的衣襟。”（本节在《马索拉抄本》为 23:1） ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT23_1","006_23_1","DEU","23","1","1","“睾丸受伤的，或生殖器被割除的，不可进耶和华的会。（本节在《马索拉抄本》为 23:2） ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT23_2","006_23_2","DEU","23","2","2","私生子不可进耶和华的会；他的后代直到第十代，也不可进耶和华的会。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT23_3","006_23_3","DEU","23","3","3","亚扪人或摩押人不可进耶和华的会；他们的后代直到第十代，也永远不可进耶和华的会。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT23_4","006_23_4","DEU","23","4","4","因为你们出埃及的时候，他们没有拿食物和水在路上迎接你们，又因为他们从两河之间的亚兰的毗夺雇了比珥的儿子巴兰，来攻击你，咒诅你。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT23_5","006_23_5","DEU","23","5","5","但耶和华你的　神不愿听从巴兰；耶和华你的　神使咒诅的话变为你的祝福，因为耶和华你的　神爱你。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT23_6","006_23_6","DEU","23","6","6","你一生一世永不可寻求他们的平安和他们的福乐。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT23_7","006_23_7","DEU","23","7","7","“你不可厌恶以东人，因为他是你的兄弟；不可厌恶埃及人，因为你在他的地上作过寄居的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT23_8","006_23_8","DEU","23","8","8","他们所生的子孙到了第三代，就可以进耶和华的会。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT23_9","006_23_9","DEU","23","9","9","“你出兵安营攻打仇敌的时候，要谨守自己，远避一切恶事。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT23_10","006_23_10","DEU","23","10","10","“如果你们中间有人因为夜间偶然梦遗而不洁净，就要出到营外去，不可进入营中。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT23_11","006_23_11","DEU","23","11","11","到了黄昏的时候，他要用水洗澡；日落了，他才可以进入营中。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT23_12","006_23_12","DEU","23","12","12","你在营外要有厕所，你可以出到那里去便溺。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT23_13","006_23_13","DEU","23","13","13","在你的器械中，要有一把锹；你在外面便溺以后，可以用来铲土，转身把粪便掩盖。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT23_14","006_23_14","DEU","23","14","14","因为耶和华你的　神常在你的营中行走，要拯救你，要把你的仇敌交在你的面前；所以你的营要圣洁，免得他看见你那里有污秽的东西，就离开你。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT23_15","006_23_15","DEU","23","15","15","“如果一个奴仆离开了他的主人，逃到你那里来，你不可把他送交他的主人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT23_16","006_23_16","DEU","23","16","16","他要在你中间和你同住，住在他自己选择的地方，住在他喜欢的城市，你不可欺负他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT23_17","006_23_17","DEU","23","17","17","“以色列的女子中不可有庙妓，以色列的男子中不可有男庙妓。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT23_18","006_23_18","DEU","23","18","18","妓女所得的酬金，或男妓所得的代价，你不可带入耶和华你的　神的殿里还任何的愿，因为这两样都是耶和华你的　神厌恶的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT23_19","006_23_19","DEU","23","19","19","你借给你兄弟的银钱、食物，或是任何可以生利的东西，都不可取利。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT23_20","006_23_20","DEU","23","20","20","借给外族人，你倒可以取利；只是借给你的兄弟，你就不可取利；好使耶和华你的　神，在你要去得为业的地上，和你手里所办的一切事上，赐福给你。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT23_21","006_23_21","DEU","23","21","21","“如果你向耶和华你的　神许了愿，就不可迟延还愿，因为耶和华你的　神必向你追讨，那时你就有罪了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT23_22","006_23_22","DEU","23","22","22","如果你不许愿，你倒没有罪。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT23_23","006_23_23","DEU","23","23","23","你嘴里说出来的，你要谨守；你亲口应许的甘心祭，就是你向耶和华你的　神许的愿，你要实行。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT23_24","006_23_24","DEU","23","24","24","“你进了你邻舍的葡萄园，你可以随意吃饱葡萄，只是不可装在你的器皿里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT23_25","006_23_25","DEU","23","25","25","你进了你邻舍的麦田，你可以用手摘麦穗，只是不可在你邻舍的麦田里挥动镰刀。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT24_1","006_24_1","DEU","24","1","1","“人娶了妻子，得着她以后，如果发现她有丑事，以致不喜悦她，他就可以给她写休书，交在她手里，叫她离开夫家； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT24_2","006_24_2","DEU","24","2","2","她离开夫家以后，就可以去再嫁别人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT24_3","006_24_3","DEU","24","3","3","如果后夫又恨她，也给她写休书，交在她手里，叫她离开他的家；或者娶她为妻的后夫死了； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT24_4","006_24_4","DEU","24","4","4","那么，叫她离开的前夫，不可在她受了污辱以后，再娶她为妻，因为这在耶和华面前是可厌可恶的事；你不可使耶和华你的　神赐给你作产业的土地蒙受罪污。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT24_5","006_24_5","DEU","24","5","5","“如果人娶了新妇，不可从军出征，也不可派他担任什么公务，他可以在家赋闲一年，使他所娶的妻子快乐。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT24_6","006_24_6","DEU","24","6","6","“不可拿人的磨，或是上磨石作抵押，因为这等于拿人的生命作抵押。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT24_7","006_24_7","DEU","24","7","7","“如果发现有人拐带了以色列人的一个兄弟，把他当作奴隶看待，或是把他卖了，那拐带人的就要处死；这样，你就把那恶从你中间除掉。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT24_8","006_24_8","DEU","24","8","8","“在大痲风的灾病上，你要谨慎自己，照利未支派的祭司指教你们的一切，认真地谨守遵行；我怎样吩咐了他们，你们就要怎样谨守遵行。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT24_9","006_24_9","DEU","24","9","9","你当记得你们出了埃及，在路上的时候，耶和华你的　神向米利暗所行的事。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT24_10","006_24_10","DEU","24","10","10","“如果你借东西给你的邻舍，不论所借的是什么，总不可走进他的家里去拿抵押。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT24_11","006_24_11","DEU","24","11","11","你要站在外面，等那向你借贷的人把抵押拿出来给你。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT24_12","006_24_12","DEU","24","12","12","他若是个穷人，你不可留他的抵押过夜。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT24_13","006_24_13","DEU","24","13","13","到了日落的时候，你要把抵押品还给他，好使他可以用自己的衣服盖着睡觉，他就给你祝福，这在耶和华你的　神面前，就算是你的义了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT24_14","006_24_14","DEU","24","14","14","“困苦贫穷的雇工，无论是你的兄弟，或是寄居在你的地上你的城里的，你都不可欺压他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT24_15","006_24_15","DEU","24","15","15","你要当日给他工钱，不可等到日落，因为他贫穷，把心放在工钱上，免得他对你不满而呼求耶和华，你就有罪了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT24_16","006_24_16","DEU","24","16","16","“不可因儿子的罪处死父亲，也不可因父亲的罪处死儿子；各人要因自己的罪被处死。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT24_17","006_24_17","DEU","24","17","17","“你不可向寄居的和孤儿屈枉正直，也不可拿寡妇的衣服作抵押。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT24_18","006_24_18","DEU","24","18","18","你要记住你在埃及作过奴仆，耶和华你的　神把你从那里救赎出来；所以我吩咐你要遵行这话。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT24_19","006_24_19","DEU","24","19","19","“你在田间收割庄稼的时候，如果遗留一捆在田里，就不可再回去拾取，要留给寄居的、孤儿和寡妇；好使耶和华你的　神，在你手里所办的一切事上，赐福给你。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT24_20","006_24_20","DEU","24","20","20","你打橄榄树以后，枝上剩下的不可再打，要留给寄居的、孤儿和寡妇。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT24_21","006_24_21","DEU","24","21","21","你收取葡萄园的葡萄以后，剩下的不可再摘，要留给寄居的、孤儿和寡妇。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT24_22","006_24_22","DEU","24","22","22","你要记住你在埃及作过奴仆，所以我吩咐你遵行这话。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT25_1","006_25_1","DEU","25","1","1","“如果人与人之间有争讼的事，就上法庭去；审判官审判他们的时候，要定义人有理，定恶人有罪； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT25_2","006_25_2","DEU","25","2","2","如果有罪的人应受责打，审判官就要叫他伏下，当面按着他的罪，照着数目责打他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT25_3","006_25_3","DEU","25","3","3","只可打他四十下，不可再多；恐怕你多打了他，过了这数目，你的兄弟就在你眼前受辱了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT25_4","006_25_4","DEU","25","4","4","“牛在踹谷的时候，不可笼住它的嘴。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT25_5","006_25_5","DEU","25","5","5","“兄弟住在一起，他们中间如果有一个死了，没有留下儿子，死者的妻子就不可出嫁外人；她丈夫的兄弟要向她尽兄弟的本分，娶她为妻，和她同房。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT25_6","006_25_6","DEU","25","6","6","她所生的长子要归亡兄的名下，免得他的名字从以色列中被涂抹了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT25_7","006_25_7","DEU","25","7","7","那人如果不喜欢娶他兄弟的妻子，他兄弟的妻子就要到城门去见长老，说：‘我丈夫的兄弟不肯在以色列中为自己的哥哥立名，不肯对我尽兄弟的本分。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT25_8","006_25_8","DEU","25","8","8","本城的长老就要把那人叫来，对他说明；如果他坚持说：‘我不乐意娶她’， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT25_9","006_25_9","DEU","25","9","9","他哥哥的妻子就要当着长老的面前，走到那人跟前，脱去他脚上的鞋子，吐唾沫在他的脸上，说：‘那不为自己哥哥建立家室的，人人都要这样对待他。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT25_10","006_25_10","DEU","25","10","10","从此，在以色列中他的名字必称为‘脱鞋者之家’。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT25_11","006_25_11","DEU","25","11","11","“有两个人在一起打斗，如果其中一人的妻子走前来，要救她的丈夫脱离那打她丈夫的人的手，就伸手抓住那人的下体， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT25_12","006_25_12","DEU","25","12","12","你就要砍掉那妇人的手；你的眼不可顾惜。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT25_13","006_25_13","DEU","25","13","13","“你袋里不可有两样不同的法码，一大一小； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT25_14","006_25_14","DEU","25","14","14","你家里不可有两样不同的升斗，一大一小。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT25_15","006_25_15","DEU","25","15","15","你要有准确公正的法码，你要有准确公正的升斗，好使你在耶和华你的　神赐给你的地上，得享长寿。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT25_16","006_25_16","DEU","25","16","16","因为所有行这些事的，就是行不义的事的，都是耶和华你的　神厌恶的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT25_17","006_25_17","DEU","25","17","17","“你要记住你们出了埃及以后，亚玛力人在路上怎样对待你； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT25_18","006_25_18","DEU","25","18","18","怎样在路上遇见了你，趁你疲倦困乏的时候，攻击你后方所有软弱无力的人，并不敬畏　神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT25_19","006_25_19","DEU","25","19","19","所以耶和华你的　神使你脱离四围所有的仇敌，在耶和华你的　神赐给你作产业的地上，得享太平的时候，你务要把亚玛力这名号从天下涂抹，不可忘记。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT26_1","006_26_1","DEU","26","1","1","“将来，你进了耶和华你的　神赐给你作产业的地，占领那地，并且住在那里以后， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT26_2","006_26_2","DEU","26","2","2","就要从耶和华你的　神赐给你的地上，把地上各种初熟果子取些来，放在篮子里，到耶和华你的　神选择立为他名的居所的地方， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT26_3","006_26_3","DEU","26","3","3","去见当时作祭司的，对他说：‘我今日向耶和华你的　神表明，我已经来到了耶和华向我们的列祖起誓应许要赐给我们的地。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT26_4","006_26_4","DEU","26","4","4","祭司就要从你手里接过篮子，放在耶和华你的　神的祭坛前面。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT26_5","006_26_5","DEU","26","5","5","然后你要在耶和华你的　神面前说：‘我的祖先原是个飘泊流亡的亚兰人；他下到埃及，在那里寄居；他人数稀少，在那里却成了又大又强、人数又多的国。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT26_6","006_26_6","DEU","26","6","6","埃及人恶待我们，苦害我们，把苦工加在我们身上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT26_7","006_26_7","DEU","26","7","7","于是我们向耶和华我们列祖的　神呼求，耶和华听见了我们的声音，看见了我们所受的困苦、劳碌和压迫， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT26_8","006_26_8","DEU","26","8","8","耶和华就用大能的手和伸出来的膀臂，以及大而可畏的事、神迹和奇事，把我们从埃及领出来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT26_9","006_26_9","DEU","26","9","9","把我们领进这地方，把这地赐给我们，就是流奶与蜜的地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT26_10","006_26_10","DEU","26","10","10","耶和华啊，现在你看，我把你赐给我的土地的初熟果子带了来。’随后你要把篮子放在耶和华你的　神面前，在耶和华你的　神面前下拜。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT26_11","006_26_11","DEU","26","11","11","你和利未人，以及住在你们中间的外族人，都要因耶和华你的　神赐给你和你的家的一切好处而欢乐。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT26_12","006_26_12","DEU","26","12","12","“每逢第三年，就是十分献一之年，你把一切出产的十分之一完全取出，分给利未人、寄居的和孤儿寡妇，使他们在你的城中吃饱了以后， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT26_13","006_26_13","DEU","26","13","13","你就要在耶和华你的　神面前说：‘我已经把圣物从家里除去了，也分给了利未人、寄居的和孤儿寡妇，都照着你吩咐我的一切诫命；你的命令我都没有违背，也没有忘记。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT26_14","006_26_14","DEU","26","14","14","我守丧的时候，没有吃这圣物；我不洁的时候，没有把它除去，也没有把它送给死人；我听从了耶和华我的　神的话，都照着你吩咐我的一切行了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT26_15","006_26_15","DEU","26","15","15","求你从天上你圣洁的居所垂看，赐福给你的子民以色列，和你赐给我们的土地，就是你向我们的列祖起誓应许的那流奶与蜜的地。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT26_16","006_26_16","DEU","26","16","16","“耶和华你的　神今日吩咐你遵行这些律例和典章，所以你要一心一意谨守遵行。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT26_17","006_26_17","DEU","26","17","17","你今日承认了耶和华是你的　神，要遵行他的道，谨守他的律例、诫命和典章，听从他的话。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT26_18","006_26_18","DEU","26","18","18","耶和华今日照着他应许你的，也承认了你是他珍贵的子民，使你谨守他的一切诫命； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT26_19","006_26_19","DEU","26","19","19","他又使你得称赞、名誉和尊贵，超过他所造的列国之上，并且照着他说过的使你作圣洁的子民，归于耶和华你的　神。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT27_1","006_27_1","DEU","27","1","1","摩西和以色列的长老吩咐人民：“你们要遵守我今日吩咐你们的一切诫命。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT27_2","006_27_2","DEU","27","2","2","将来你们过约旦河，到了耶和华你的　神赐给你的土地的那一天，你要立起几块大石头，墁上石灰。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT27_3","006_27_3","DEU","27","3","3","你过河以后，要把这律法的一切话都写在石头上面，使你可以进入耶和华你的　神赐给你的土地，就是流奶与蜜的地，正如耶和华你列祖的　神应许你的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT27_4","006_27_4","DEU","27","4","4","所以，将来你们过了约旦河，就要在以巴路山上，照着我今日吩咐你们的，把这些石头立起来，墁上石灰。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT27_5","006_27_5","DEU","27","5","5","在那里你要为耶和华你的　神筑一座石坛，在石头上你不可动铁器。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT27_6","006_27_6","DEU","27","6","6","你要用没有凿过的整块石头筑耶和华你的　神的坛；在坛上你要献上燔祭给耶和华你的　神； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT27_7","006_27_7","DEU","27","7","7","又要献上平安祭，并且在那里吃喝；也要在耶和华你的　神面前欢乐。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT27_8","006_27_8","DEU","27","8","8","你要把这律法的一切话，都清清楚楚写在石头上。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT27_9","006_27_9","DEU","27","9","9","摩西和利未支派的祭司对以色列众人说：“以色列啊，要默默静听；今日你已经成为耶和华你的　神的子民了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT27_10","006_27_10","DEU","27","10","10","所以你要听从耶和华你的　神的话，遵行他的诫命和律例，就是我今日吩咐你的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT27_11","006_27_11","DEU","27","11","11","那天摩西又吩咐人民： ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT27_12","006_27_12","DEU","27","12","12","“你们过了约旦河以后，西缅、利未、犹大、以萨迦、约瑟、便雅悯等支派的人，要站在基利心山上为人民祝福； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT27_13","006_27_13","DEU","27","13","13","流本、迦得、亚设、西布伦、但、拿弗他利等支派的人，要站在以巴路山上宣布咒诅的话。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT27_14","006_27_14","DEU","27","14","14","利未人要向以色列众人大声说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT27_15","006_27_15","DEU","27","15","15","“‘制造耶和华厌恶的雕像或铸像，工人手中做的，并且在暗处设立的，那人必受咒诅。’众民都要应声说：‘阿们。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT27_16","006_27_16","DEU","27","16","16","“‘轻慢父母的，必受咒诅。’众民都要说：‘阿们。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT27_17","006_27_17","DEU","27","17","17","“‘移动邻舍地界的，必受咒诅。’众民都要说：‘阿们。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT27_18","006_27_18","DEU","27","18","18","“‘使瞎子走错路的，必受咒诅。’众民都要说：‘阿们。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT27_19","006_27_19","DEU","27","19","19","“‘对寄居的和孤儿寡妇屈枉正直的，必受咒诅。’众民都要说：‘阿们。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT27_20","006_27_20","DEU","27","20","20","“‘和父亲的妻子同寝的，必受咒诅，因为他揭开了他父亲的衣襟。’众民都要说：‘阿们。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT27_21","006_27_21","DEU","27","21","21","“‘和任何野兽同寝的，必受咒诅。’众民都要说：‘阿们。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT27_22","006_27_22","DEU","27","22","22","“‘和同父异母，或是同母异父的姊妹同寝的，必受咒诅。’众民都要说：‘阿们。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT27_23","006_27_23","DEU","27","23","23","“‘和岳母同寝的，必受咒诅。’众民都要说：‘阿们。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT27_24","006_27_24","DEU","27","24","24","“‘暗中杀害邻舍的，必受咒诅。’众民都要说：‘阿们。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT27_25","006_27_25","DEU","27","25","25","“‘接受贿赂杀人，流无辜人的血的，必受咒诅。’众民都要说：‘阿们。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT27_26","006_27_26","DEU","27","26","26","“‘不坚守这律法的话去遵行的，必受咒诅。’众民都要说：‘阿们。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_1","006_28_1","DEU","28","1","1","“如果你实在听从耶和华你的　神的话，谨守遵行他的一切诫命，就是我今日吩咐你的，耶和华你的　神必使你超过地上所有的民族。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_2","006_28_2","DEU","28","2","2","如果你听从耶和华你的　神的话，以下这一切福气必临到你身上，必把你追上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_3","006_28_3","DEU","28","3","3","你在城里必蒙福，在田间也必蒙福。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_4","006_28_4","DEU","28","4","4","你身所生的、土地所出的、牲畜所出的、牛生殖的和羊所产的，都必蒙福。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_5","006_28_5","DEU","28","5","5","你的篮子和你的抟面盆，都必蒙福。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_6","006_28_6","DEU","28","6","6","你出必蒙福，你入也必蒙福。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_7","006_28_7","DEU","28","7","7","“那起来攻击你的仇敌，耶和华必使他们在你面前被击败；他们从一条路出来攻击你，必在你面前从七条路逃跑。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_8","006_28_8","DEU","28","8","8","在你的仓房里和你手所办的一切事上，耶和华必吩咐福气临到你；在耶和华你的　神赐给你的地上，他必赐福给你。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_9","006_28_9","DEU","28","9","9","如果你谨守耶和华你的　神的诫命，遵守他的道路，耶和华就必照着他向你起过的誓，立你作他自己的圣民。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_10","006_28_10","DEU","28","10","10","地上万民见你被称为耶和华名下的人，就必惧怕你。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_11","006_28_11","DEU","28","11","11","在耶和华向你列祖起誓应许要赐给你的土地上，他必使你身上所生的、牲畜所产的、土地所出的，都丰富有余。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_12","006_28_12","DEU","28","12","12","耶和华必为你打开他天上的宝库，按时降雨在你的地上，在你手里所作的一切事上赐福给你；你要借贷给许多国的民，却不会向人借贷。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_13","006_28_13","DEU","28","13","13","耶和华必使你作头不作尾，居上不居下，只要你听从耶和华你的　神的诫命，就是我今日吩咐你的，谨守遵行； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_14","006_28_14","DEU","28","14","14","不可偏离我今日吩咐你的一切话，不偏左也不偏右，以致去随从和事奉别的神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_15","006_28_15","DEU","28","15","15","“但是，如果你不听从耶和华你　神的话，不谨守遵行我今日吩咐你的一切诫命和律例，以下这一切咒诅就必临到你身上，把你赶上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_16","006_28_16","DEU","28","16","16","你在城里必受咒诅，在田间也必受咒诅。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_17","006_28_17","DEU","28","17","17","你的篮子和抟面盆都必受咒诅。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_18","006_28_18","DEU","28","18","18","你身所生的、土地所出的、牛生殖的和羊所产的，都必受咒诅。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_19","006_28_19","DEU","28","19","19","你出必受咒诅，你入也必受咒诅。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_20","006_28_20","DEU","28","20","20","“耶和华必在你手所作的一切事上，使咒诅、纷乱和责备临到你身上，直到你被消灭，速速地灭亡，因为你行恶，离弃了我的缘故。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_21","006_28_21","DEU","28","21","21","耶和华必使瘟疫随着你，直到他把你从你进去得为业的地上灭绝了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_22","006_28_22","DEU","28","22","22","耶和华必用痨病、热病、炎症、疟疾、干旱、旱风和霉烂打击你；它们必追赶你，直到你灭亡。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_23","006_28_23","DEU","28","23","23","你头上的天必变成铜，你脚下的地必变成铁。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_24","006_28_24","DEU","28","24","24","耶和华必使你地上的雨水变为飞沙尘土，从天上下到你身上，直到你被消灭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_25","006_28_25","DEU","28","25","25","耶和华必使你在仇敌面前被击败；你从一条路出去攻击他们，必在他们面前从七条路逃跑；你必成为天下万国惊骇的对象。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_26","006_28_26","DEU","28","26","26","你的尸体必成为空中的飞鸟和地上的走兽的食物；必没有人来把它们吓走。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_27","006_28_27","DEU","28","27","27","“耶和华必用埃及人的疮、痔漏、牛皮癣、红疹打击你，这是你不能医治的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_28","006_28_28","DEU","28","28","28","耶和华必用癫狂、眼瞎、心乱打击你； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_29","006_28_29","DEU","28","29","29","你必在中午的时候摸索，好像瞎子在黑暗中摸索一样；你的道路必不亨通；你必日日受欺压、被抢夺，没有人拯救你。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_30","006_28_30","DEU","28","30","30","你和女子订了婚，别人必和她同寝；你建造房屋，必不得住在里面；你栽种葡萄园，必不得享用它的果子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_31","006_28_31","DEU","28","31","31","你的牛在你眼前被宰了，你必不得吃它的肉；你的驴从你面前被抢夺了，必不归还给你；你的羊群交给了你的仇敌，必没有人拯救。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_32","006_28_32","DEU","28","32","32","你的儿女必被交给别国的民，你必亲眼看见，日日为他们焦虑；你必无能为力。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_33","006_28_33","DEU","28","33","33","你土地的出产和你劳碌得来的一切，都必被你不认识的民族吃尽；你必常常受压迫和压制； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_34","006_28_34","DEU","28","34","34","你因亲眼看见的，必要疯狂。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_35","006_28_35","DEU","28","35","35","耶和华必用毒疮打击你的双膝和双腿，由踵至顶，使你无法医治。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_36","006_28_36","DEU","28","36","36","耶和华必把你和你所立统治你的君王，领到你和你的列祖都不认识的国那里去；在那里你必事奉别的神，就是木头石头所做的神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_37","006_28_37","DEU","28","37","37","在耶和华要领你去的各民族中，你必成为使人惊骇、使人嘲笑和讽刺的对象。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_38","006_28_38","DEU","28","38","38","“你带到田间的种子虽然很多，但收进来的却很少，因为蝗虫把它吞吃了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_39","006_28_39","DEU","28","39","39","你栽种修理葡萄园，必不得收葡萄，也不得喝葡萄酒，因为虫子把它吃尽了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_40","006_28_40","DEU","28","40","40","你全境必有橄榄树，却没有油抹身，因为你的橄榄还未成熟就脱落了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_41","006_28_41","DEU","28","41","41","你必生儿养女，却不是属你的，因为他们都要被掳去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_42","006_28_42","DEU","28","42","42","你所有的树木和你土地的出产，都必被害虫吃光。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_43","006_28_43","DEU","28","43","43","住在你中间的寄居者必渐渐高升，比你高而又高；你必渐渐下降，低而又低。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_44","006_28_44","DEU","28","44","44","他要借给你，你却不能借给他；他必作头，你必作尾。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_45","006_28_45","DEU","28","45","45","这一切咒诅必临到你，必追赶你，必把你追上，直到你被消灭，因为你不听从耶和华你的　神的话，没有遵守他吩咐你的诫命和律例。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_46","006_28_46","DEU","28","46","46","这些咒诅必在你和你的后裔身上成为异迹和奇事，直到永远。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_47","006_28_47","DEU","28","47","47","因为你在这样富足的时候，没有以欢乐和高兴的心来事奉耶和华你的　神， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_48","006_28_48","DEU","28","48","48","所以你必在饥饿、干渴、赤身露体和缺乏之中，去事奉耶和华派来攻击你的仇敌；他必把铁轭放在你的颈项上，直到把你消灭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_49","006_28_49","DEU","28","49","49","“耶和华必从远方，从地极把一国的民带来，像鹰一般飞来攻击你；这民的语言你不会听； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_50","006_28_50","DEU","28","50","50","这民脸无羞耻，不顾老年人的情面，也不恩待青年人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_51","006_28_51","DEU","28","51","51","他们必吞吃你牲畜所生的和你土地所产的，直到把你消灭；必不给你留下五谷、新酒和油、幼小的牛，以及肥嫩的羊，直到使你灭亡为止。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_52","006_28_52","DEU","28","52","52","他们必把你围困在你的各城里，直到在你的全境内你所倚靠高大和坚固的城墙都被攻陷；他们必把你围困在耶和华你的　神赐给你的全地的各城里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_53","006_28_53","DEU","28","53","53","你在仇敌围困和窘迫你的时候，要吃你身所生的，就是吃耶和华你的　神赐给你的儿女的肉。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_54","006_28_54","DEU","28","54","54","你们中间温柔嫩弱的男人，必敌视自己的兄弟、怀中的妻子和余剩的儿女； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_55","006_28_55","DEU","28","55","55","甚至在你的仇敌围困和窘迫你在各城里的时候，他要吃自己儿女的肉，却不肯分给他们任何人，因为他没有什么剩下的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_56","006_28_56","DEU","28","56","56","你们中间温柔娇嫩的妇人，素来因为温柔娇嫩不肯把脚掌踏在地上，现在必敌视自己怀中的丈夫和自己的儿女。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_57","006_28_57","DEU","28","57","57","她暗中把自己两腿之间出来的婴孩，和自己生的儿女吃掉，因为在你的仇敌围困和窘迫你在各城里的时候，她什么都没有了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_58","006_28_58","DEU","28","58","58","“如果你不谨守遵行写在这书上的这律法的一切话，不敬畏这荣耀和可畏的名，就是耶和华你的　神， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_59","006_28_59","DEU","28","59","59","耶和华就必使你和你的后裔遭受奇灾，就是大而长久的灾，毒而长久的病。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_60","006_28_60","DEU","28","60","60","他必使你惧怕的埃及人的各种疾病都临到你身上，紧紧地缠着你。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_61","006_28_61","DEU","28","61","61","又把这律法书上没有记载的各样灾病，都降在你身上，直到你被消灭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_62","006_28_62","DEU","28","62","62","你们以前虽然像天上的星那么多，现在剩下的人数却寥寥可数，因为你不听从耶和华你的　神的话。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_63","006_28_63","DEU","28","63","63","先前耶和华怎样喜欢你们得好处，使你们人数众多，将来也必怎样喜欢你们灭亡，把你们消灭；你们必从要进去得为业的地上被拔除。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_64","006_28_64","DEU","28","64","64","耶和华必使你分散在万民中，从地的这边到地的那边；在那里你要事奉你和你的列祖不认识的别的神，就是木头和石头做的神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_65","006_28_65","DEU","28","65","65","在那些国中，你必不得安息，也没有脚掌歇息的地方；耶和华却必使你在那里心中发颤，眼目憔悴，精神颓废。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_66","006_28_66","DEU","28","66","66","你未来的生命必悬而不定；你必昼夜恐惧，生命难保。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_67","006_28_67","DEU","28","67","67","因你心里的惧怕惊恐和你眼中看见的景象，早晨你必说：‘但愿现在是晚上！’晚上你必说：‘但愿现在是早晨！’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT28_68","006_28_68","DEU","28","68","68","耶和华必用船把你送回埃及去，走我曾经告诉你，你不得再见的那条路；在那里你们必卖身给你的仇敌作奴仆和作婢女，却没有人买。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT29_1","006_29_1","DEU","29","1","1","这些是耶和华在摩押地，吩咐摩西与以色列人所立的约的话，是耶和华和他们在何烈山所立的约以外的。（本节在《马索拉抄本》为 28:69） ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT29_2","006_29_2","DEU","29","2","2","摩西把以色列众人召了来，对他们说：“耶和华在埃及地，在你们面前，向法老和他的众臣仆，以及他的全国所行的一切，你们都看见了，（本节在《马索拉抄本》为 29:1） ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT29_3","006_29_3","DEU","29","3","3","就是你亲眼见过的大试验和神迹，以及那些大奇事； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT29_4","006_29_4","DEU","29","4","4","但是直到今日，耶和华还没有给你们一颗能明白的心，能看见的眼睛，能听见的耳朵。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT29_5","006_29_5","DEU","29","5","5","我在旷野四十年之久领导你们；你们身上的衣服没有穿破，脚上的鞋也没有穿坏。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT29_6","006_29_6","DEU","29","6","6","饭你们没有吃，清酒或烈酒你们没有喝，这是要使你们知道耶和华是你们的　神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT29_7","006_29_7","DEU","29","7","7","你们来到了这地方，希实本王西宏和巴珊王噩就出来，与我们交战，我们击败了他们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT29_8","006_29_8","DEU","29","8","8","夺取了他们的地，分给流本人、迦得人和玛拿西半个支派作产业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT29_9","006_29_9","DEU","29","9","9","所以你们要谨守这约的话，并且遵行，好使你们在所行的一切事上都亨通。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT29_10","006_29_10","DEU","29","10","10","“今日你们全都站在耶和华你们的　神面前；你们的首领、族长、长老、官长和以色列所有的男子， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT29_11","006_29_11","DEU","29","11","11","你们的小孩、妻子和在你营中的寄居者，以及为你们劈柴挑水的人，都站在耶和华你们的　神面前， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT29_12","006_29_12","DEU","29","12","12","为要叫你遵守耶和华你的　神今日与你所立的约，和他向你所起的誓； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT29_13","006_29_13","DEU","29","13","13","这样，他今日可以立你作他的子民，他可以作你的　神，正如他曾经对你说过的，又对你的列祖亚伯拉罕、以撒、雅各起过誓的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT29_14","006_29_14","DEU","29","14","14","“我不但与你们立这约，起这誓； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT29_15","006_29_15","DEU","29","15","15","而且也与那些今日和我们在这里，一同站在耶和华我们的　神面前的人，以及那些今日不与我们同在这里的人立这约，起这誓。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT29_16","006_29_16","DEU","29","16","16","你们清楚知道我们怎样在埃及地住过，怎样从列国中经过； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT29_17","006_29_17","DEU","29","17","17","你们也见过他们的可憎之物，和他们那里那些木、石、金、银的偶像。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT29_18","006_29_18","DEU","29","18","18","恐怕你们中间有男人或女人，家族或支派，今日心里偏离了耶和华我们的　神，去事奉那些国的神，又恐怕你们中间有恶根，生出毒草和苦堇来； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT29_19","006_29_19","DEU","29","19","19","如果人听了这咒诅的话，心里仍然自夸说：‘我虽然照着顽梗的心而行，使好人和恶人一起灭亡，我还有平安。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT29_20","006_29_20","DEU","29","20","20","耶和华必不肯饶恕他；耶和华的怒气和愤恨必向这人发作，这书上所写的一切咒诅都要降在那人身上，耶和华也必从天下涂抹他的名。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT29_21","006_29_21","DEU","29","21","21","耶和华必照着写在这律法书上的约的一切咒诅，把他从以色列众支派中分别出来，使他遭受灾祸。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT29_22","006_29_22","DEU","29","22","22","“后代的人，就是你们以后兴起来的子孙，和从远方来的外族人，看见了这地的灾难和耶和华降与这地的疾病， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT29_23","006_29_23","DEU","29","23","23","又看见了遍地有硫磺，有盐卤，有火烧，没有播种，没有出产，寸草不生，好像耶和华在烈怒和怒火中毁灭的所多玛、蛾摩拉、押玛、洗扁一样， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT29_24","006_29_24","DEU","29","24","24","看见了这些的人和万国的人都要问：‘耶和华为什么向这地这样行呢？为什么大发烈怒呢？’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT29_25","006_29_25","DEU","29","25","25","人就必回答：‘是因为他们离弃了耶和华他们列祖的　神的约，就是耶和华把他们从埃及地领出来的时候，与他们所立的； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT29_26","006_29_26","DEU","29","26","26","去事奉别的神，向他们叩拜，就是他们不认识的神，也是耶和华没有给他们指定要拜的神； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT29_27","006_29_27","DEU","29","27","27","所以耶和华向这地大发烈怒，把这书上所写的一切咒诅都降在这地上； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT29_28","006_29_28","DEU","29","28","28","于是耶和华在烈怒、忿怒和大怒中，把他们从他们的地土拔出来，丢在别的地方，像今天一样。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT29_29","006_29_29","DEU","29","29","29","“奥秘的事，是属于耶和华我们的　神的，只有显露的事，是永远属于我们和我们子孙的，好叫我们遵行这律法上的一切话。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT30_1","006_30_1","DEU","30","1","1","“当这一切事，就是我摆在你面前的祝福和咒诅，都临到你身上的时候，你在耶和华你的　神赶逐你去的万国中，你心里必回想这些话， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT30_2","006_30_2","DEU","30","2","2","你和你的子孙必一心一意归向耶和华你的　神，照着我今日吩咐你的一切听从他的话。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT30_3","006_30_3","DEU","30","3","3","那时，耶和华你的　神就必使你这被掳的人回归，他必怜悯你；耶和华你的　神必从你被分散到的万民中，把你再召集回来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT30_4","006_30_4","DEU","30","4","4","你被赶逐的人，就是在天涯海角，耶和华你的　神也必从那里把你召集回来，从那里把你带回。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT30_5","006_30_5","DEU","30","5","5","耶和华你的　神必领你进入你列祖所得之地，使你可以得着这地；他必善待你，他也必使你的人数增多，胜过你的列祖。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT30_6","006_30_6","DEU","30","6","6","耶和华你的　神必把你心里和你后裔心里的污秽除掉，要你一心一意爱耶和华你的　神，使你可以存活。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT30_7","006_30_7","DEU","30","7","7","耶和华你的　神必把这一切咒诅，加在你的仇敌和恨恶你、逼迫你的人身上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT30_8","006_30_8","DEU","30","8","8","你却要再听从耶和华的话，遵行他的一切诫命，就是我今日吩咐你的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT30_9","006_30_9","DEU","30","9","9","耶和华你的　神必使你手里所办的一切事、你身所生的、牲畜所出的、地土所产的，都丰盛有余，因为耶和华必再喜悦你，使你得福，像从前喜悦你的列祖一样； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT30_10","006_30_10","DEU","30","10","10","只要你听从耶和华你的　神的话，谨守这律法书上所写的诫命和律例；只要你一心一意回转归向耶和华你的　神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT30_11","006_30_11","DEU","30","11","11","“其实我今日吩咐你的这诫命，对你并不太难，离你也不太远。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT30_12","006_30_12","DEU","30","12","12","这诫命不是在天上，以致你说：‘谁替我们上到天上去，为我们取下来，使我们听见，就可以遵行呢？’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT30_13","006_30_13","DEU","30","13","13","也不是在海外，以致你说：‘谁替我们过海去，为我们取回来，使我们听见，就可以遵行呢？’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT30_14","006_30_14","DEU","30","14","14","其实这话离你很近，就在你口里，也在你心里，使你可以遵行。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT30_15","006_30_15","DEU","30","15","15","“你看，我今日把生命和福乐，死亡与灾祸，都摆在你的面前了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT30_16","006_30_16","DEU","30","16","16","如果你听从耶和华你的　神的诫命，就是我今日吩咐你的；爱耶和华你的　神，行他的道路，谨守他的诫命、律例、典章，使你可以存活，人数增多，耶和华你的　神就必在你要进去得为业的地上赐福给你。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT30_17","006_30_17","DEU","30","17","17","但是，如果你的心偏离了，不肯听从，却被人勾引，去敬拜和事奉别的神； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT30_18","006_30_18","DEU","30","18","18","我今日郑重地告诉你们，你们必要灭亡；在你过约旦河，进去得为业的地上，你的年日必不长久。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT30_19","006_30_19","DEU","30","19","19","我今日呼天唤地向你们作证，我把生与死，福与祸，都摆在你面前了；所以你要选择生命，好让你和你的后裔都可以活着， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT30_20","006_30_20","DEU","30","20","20","爱耶和华你的　神，听从他的话，紧靠他，因为那就是你的生命，你的长寿；这样，你才能在耶和华向你的列祖亚伯拉罕、以撒、雅各起誓应许要赐给他们的地上居住。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT31_1","006_31_1","DEU","31","1","1","摩西又把这些话告诉以色列众人， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT31_2","006_31_2","DEU","31","2","2","对他们说：“我现今一百二十岁，不能再照常出入了；耶和华也曾对我说：你必不得过这约旦河。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT31_3","006_31_3","DEU","31","3","3","耶和华你的　神要亲自领你们过去，从你们面前消灭这些国的民，使你们得着他们的地，照着耶和华说过的，约书亚要亲自领你们过去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT31_4","006_31_4","DEU","31","4","4","耶和华对待他们，必好像从前对待他消灭的亚摩利人的两个王西宏和噩，以及他们的国一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT31_5","006_31_5","DEU","31","5","5","耶和华必把他们交给你们，你们照着我吩咐你们的一切命令对待他们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT31_6","006_31_6","DEU","31","6","6","你们要坚强勇敢；不要害怕，也不要因他们畏惧，因为耶和华你的　神与你同去；他决不撇下你，也不离弃你。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT31_7","006_31_7","DEU","31","7","7","摩西把约书亚召了来，在以色列众人面前对他说：“你要坚强勇敢，因为你要和这人民一同进入耶和华向他们的列祖起誓，应许要赐给他们的地；你也要使他们得着那地为业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT31_8","006_31_8","DEU","31","8","8","耶和华亲自在你前头行，与你同在；他决不撇下你，也不离弃你；你不要害怕，也不要惊慌。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT31_9","006_31_9","DEU","31","9","9","摩西把这律法写好了，就交给抬耶和华约柜的利未支派的祭司子孙，和以色列的众长老。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT31_10","006_31_10","DEU","31","10","10","摩西吩咐他们：“每逢七年的最后一年，就是在豁免年的定期，住棚节期间， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT31_11","006_31_11","DEU","31","11","11","以色列众人来到耶和华你的　神选择的地方朝见他的时候，你要在以色列众人面前把这律法宣读给他们听。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT31_12","006_31_12","DEU","31","12","12","你要召集人民、男人、女人、孩子，以及你城里的寄居者，叫他们可以听见，叫他们可以学习，好敬畏耶和华你们的　神，谨守遵行这律法的一切话， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT31_13","006_31_13","DEU","31","13","13","也叫他们还不认识这律法的儿女可以听见，使他们在你们过约旦河去得为业的地上生活的时候，一生学习敬畏耶和华你们的　神。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT31_14","006_31_14","DEU","31","14","14","耶和华对摩西说：“看哪，你的死期临近了；你要把约书亚召来，你们二人要站在会幕里，我好吩咐他。”于是摩西和约书亚前去，一同站在会幕里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT31_15","006_31_15","DEU","31","15","15","耶和华在会幕里，在云柱中显现，这云柱停在会幕的门口上面。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT31_16","006_31_16","DEU","31","16","16","耶和华对摩西说：“看哪，你快要和你的列祖长眠了；这人民要起来，在他们所要去的地方，在那地的人中，与外族人的神行邪淫，离弃我，破坏我与他们所立的约。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT31_17","006_31_17","DEU","31","17","17","到了那日，我必向他们大发烈怒，离弃他们，掩面不顾他们，他们就必被吞灭，并且遭遇很多灾祸和患难。到了那日，他们必说：‘我们遭遇这些灾祸，不是因为我们的　神不在我们中间吗？’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT31_18","006_31_18","DEU","31","18","18","到了那日，因为他们偏向了别的神，和所作的一切恶事，我必掩面不顾他们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT31_19","006_31_19","DEU","31","19","19","所以，现在你们要为自己写下这首诗歌来，教导以色列人，放在他们口中，使这首诗歌成为我反对他们的见证。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT31_20","006_31_20","DEU","31","20","20","因为我把他们领进了我向他们的列祖起誓应许的地，就是流奶与蜜的地，他们在那里吃饱了，发胖了，就必偏向别的神，事奉他们，藐视我，破坏我的约。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT31_21","006_31_21","DEU","31","21","21","他们遭遇许多灾祸和患难的时候，这首诗歌就必在他们面前作证，因为这首诗歌必不会从他们后裔的口中忘记。其实，我还未领他们进入我起誓应许之地以先，他们今日心里所怀的意念，我都知道了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT31_22","006_31_22","DEU","31","22","22","摩西就在那一天写下了这首诗歌，教导以色列人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT31_23","006_31_23","DEU","31","23","23","耶和华吩咐嫩的儿子约书亚，说：“你当坚强勇敢，因为你要领以色列人进我向他们起誓应许的地，我必与你同在。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT31_24","006_31_24","DEU","31","24","24","摩西把这律法的话写在书上，直到写完了， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT31_25","006_31_25","DEU","31","25","25","摩西就吩咐抬耶和华约柜的利未人说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT31_26","006_31_26","DEU","31","26","26","“你们要把这律法书，放在耶和华你们的　神的约柜旁，可以在那里作反对你们的见证， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT31_27","006_31_27","DEU","31","27","27","因为我知道你们的悖逆和硬颈。看哪，我今日还活着与你们同在的时候，你们尚且悖逆耶和华，何况我死了以后呢？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT31_28","006_31_28","DEU","31","28","28","你们要把你们各支派的众长老和官长都召集到我这里来，我好把这些话说给他们听，并且呼天唤地对他们作证。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT31_29","006_31_29","DEU","31","29","29","因为我知道我死了以后，你们必完全败坏，偏离我吩咐你们的道路；在末后的日子必有灾祸临到你们身上，因为你们必行耶和华看为恶的事，以你们手所作的事，惹他发怒。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT31_30","006_31_30","DEU","31","30","30","于是摩西把这首诗歌的话，都说给以色列的全体会众听，直到说完了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT32_1","006_32_1","DEU","32","1","1","“天哪，留心吧，我要说话；地啊，聆听我口中的言语。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT32_2","006_32_2","DEU","32","2","2","我的教训下降如雨，我的言语滴落如露，像细雨落在青草上，像甘霖降在蔬菜上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT32_3","006_32_3","DEU","32","3","3","因为我要宣告耶和华的名；你们要尊崇我们的　神的伟大。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT32_4","006_32_4","DEU","32","4","4","他是磐石，他的作为完全，因为他一切所行的全都公平；他是诚实无伪的　神，又公义，又正直。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT32_5","006_32_5","DEU","32","5","5","这世代向他行事败坏，就不是他的儿女，满有弊病，这实在是个乖僻弯曲的世代。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT32_6","006_32_6","DEU","32","6","6","愚昧无知的人民哪，你们这样报答耶和华吗？他不是你的父，不是把你买回来的吗？他造了你，建立了你。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT32_7","006_32_7","DEU","32","7","7","你要回想古时的日子，思念历代以来的年月；问你的父亲，他必告诉你；问你的长者，他们必对你说。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT32_8","006_32_8","DEU","32","8","8","至高者把地业赐给列国的时候，把人类分开的时候，就照着以色列子孙的数目，立定了万民的境界。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT32_9","006_32_9","DEU","32","9","9","但耶和华的分就是他的子民，他的产业就是雅各。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT32_10","006_32_10","DEU","32","10","10","耶和华在旷野之地遇见了他，在荒凉之地和野兽吼叫的荒野，遇见了他，就环绕他，看顾他，保护他，好像保护自己眼中的瞳人一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT32_11","006_32_11","DEU","32","11","11","又像老鹰搅动巢窝，飞翔在雏鹰之上，扇展翅膀，接取雏鹰，背在自己的两翼之上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT32_12","006_32_12","DEU","32","12","12","耶和华独自领导了他，并没有外族人的神与他同在。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT32_13","006_32_13","DEU","32","13","13","耶和华使他乘驾地的高处，得吃田间的土产；又使他从岩石中吸蜜，从坚固的磐石中取油。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT32_14","006_32_14","DEU","32","14","14","也吃牛酪和羊乳，羊羔的脂肪，巴珊的公牛和公山羊，以及上好的麦子；也喝了葡萄汁酿成的酒。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT32_15","006_32_15","DEU","32","15","15","但耶书仑肥胖了，就踢跳，‘你肥胖了，你粗壮了，你饱满了，’他离弃了造他的　神，轻看了救他的磐石。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT32_16","006_32_16","DEU","32","16","16","他们以外族人的神激动了　神的愤恨，以可憎之事惹起了他的怒气。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT32_17","006_32_17","DEU","32","17","17","他们献祭给鬼魔（他们不是神），就是他们从来不认识的神，是近来新兴的，是你们的列祖所不惧怕的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT32_18","006_32_18","DEU","32","18","18","你轻忽了生你的磐石，你忘记了产你的　神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT32_19","006_32_19","DEU","32","19","19","因为他的儿女激怒了　神，耶和华看见了，就弃绝了他们， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT32_20","006_32_20","DEU","32","20","20","说：‘我必掩面不顾他们，要看看他们的结局怎样；因为他们是乖曲的一代，心里没有信实的人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT32_21","006_32_21","DEU","32","21","21","他们以不是神的神激动了我的愤恨，以虚无之物惹动了我的怒气；我也以不是子民的人激动他们的愤恨，以愚昧的国民惹动他们的怒气。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT32_22","006_32_22","DEU","32","22","22","因为在我的怒中有火燃烧起来，烧到阴间的深处，把大地和地的出产尽都吞灭，连山的根基也烧着了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT32_23","006_32_23","DEU","32","23","23","我要把灾祸加在他们身上，把我的箭向他们射尽。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT32_24","006_32_24","DEU","32","24","24","他们必因饥荒消瘦，被热病和毒症消灭；我也要打发野兽用牙齿咬他们，和土中的蛇类用毒液害他们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT32_25","006_32_25","DEU","32","25","25","外有刀剑，内有惊恐，使人丧亡，使少男少女，婴孩和白发老人，尽都丧亡。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT32_26","006_32_26","DEU","32","26","26","我原想：“我要把他们分散到各处，把他们的名号都从人间除灭。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT32_27","006_32_27","DEU","32","27","27","但我惧怕仇人激动我，恐怕敌人误会了，又恐怕他们说：“是我们的手高举了，并不是耶和华作了这一切事。”’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT32_28","006_32_28","DEU","32","28","28","因为他们是缺乏计谋的国，他们心中没有见识。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT32_29","006_32_29","DEU","32","29","29","如果你们有智慧，就可以明白这事，认清自己将来的结局了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT32_30","006_32_30","DEU","32","30","30","如果不是他们的磐石把他们出卖了，如果不是耶和华把他们交出来，一人怎能追赶一千人，二人怎能使万人逃跑呢？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT32_31","006_32_31","DEU","32","31","31","连我们的仇敌也自己断定，他们的磐石不像我们的磐石。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT32_32","006_32_32","DEU","32","32","32","因为他们的葡萄树，是所多玛的葡萄树所出的，是蛾摩拉的田地所生的；他们的葡萄是毒葡萄，每一挂都是苦的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT32_33","006_32_33","DEU","32","33","33","他们的酒是大蛇的毒液，是虺蛇的剧毒。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT32_34","006_32_34","DEU","32","34","34","这不是贮藏在我这里，封闭在我的宝库中吗？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT32_35","006_32_35","DEU","32","35","35","等到他们失足的时候，我要伸冤报应；因为他们遭遇灾难的日子近了，那预备要临到他们身上的事，必快快临到。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT32_36","006_32_36","DEU","32","36","36","耶和华要为自己的子民伸冤，为自己的仆人难过，因为耶和华看见他们的能力已经消逝，为奴的或自由的都没有剩下一人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT32_37","006_32_37","DEU","32","37","37","他必说：‘他们的神在哪里呢？他们投靠的磐石在哪里呢？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT32_38","006_32_38","DEU","32","38","38","就是向来吃他们祭牲脂肪的，喝他们奠祭之酒的神在哪里呢？让他们兴起来帮助你们吧，愿他们保护你们吧！ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT32_39","006_32_39","DEU","32","39","39","现在你们要知道，只有我是那一位，除我以外，并没有别的神；我使人死，也使人活；我打伤，我也医治；没有人可以从我的手里抢救出去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT32_40","006_32_40","DEU","32","40","40","我向天举手说：我活到永永远远； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT32_41","006_32_41","DEU","32","41","41","如果我磨亮了我的刀剑，如果我掌握了审判权，就必向我的仇敌伸冤，必向恨我的人报应。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT32_42","006_32_42","DEU","32","42","42","我要使我的箭饮血饮醉，就是被杀的人和被掳的人的血；我的刀剑要吃肉，就是吃仇敌长发首领的肉。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT32_43","006_32_43","DEU","32","43","43","列国啊，你们当与耶和华的子民一同欢呼，因为他要伸他仆人流血的冤，他要向他的仇人报复，他要救赎他的地和他的子民。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT32_44","006_32_44","DEU","32","44","44","摩西和嫩的儿子约书亚前来，把这首诗歌的一切话都说给人民听。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT32_45","006_32_45","DEU","32","45","45","摩西向以色列众人说完了这一切话， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT32_46","006_32_46","DEU","32","46","46","就对他们说：“我今日警告你们的一切话，你们都要放在心上，好吩咐你们的子孙谨守遵行这律法上的一切话。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT32_47","006_32_47","DEU","32","47","47","因为这不是空洞、与你们无关重要的事，而是你们的生命；借着这事，你们在过约旦河去得为业的地上，才可以日子长久。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT32_48","006_32_48","DEU","32","48","48","就在那一天，耶和华对摩西说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT32_49","006_32_49","DEU","32","49","49","“你要上这亚巴琳山去，就是尼波山，在耶利哥对面的摩押地，观看我赐给以色列人为业的迦南地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT32_50","006_32_50","DEU","32","50","50","你必死在你登上的山上，归到你的族人那里去，像你的哥哥亚伦死在何珥山上，归到他的族人那里去一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT32_51","006_32_51","DEU","32","51","51","因为你们在寻的旷野，在加低斯米利巴水边，在以色列人中间悖逆我，在以色列人中间没有尊我为圣。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT32_52","006_32_52","DEU","32","52","52","我赐给以色列人的地，你可以从对面观看，却不得进去。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT33_1","006_33_1","DEU","33","1","1","这是神人摩西，在死前给以色列人所祝的福。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT33_2","006_33_2","DEU","33","2","2","他说：“耶和华从西奈而来，从西珥光照他们，从巴兰山射出光辉，在千万圣者中来临，从他的右手有烈火的律法。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT33_3","006_33_3","DEU","33","3","3","他实在爱人民，他的众圣者都在你的手里；他们坐在你的脚前，各自领受你的话。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT33_4","006_33_4","DEU","33","4","4","摩西把律法吩咐我们，作为雅各会众的基业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT33_5","006_33_5","DEU","33","5","5","人民的众首领，以色列的各支派，一同会合的时候，耶和华就在耶书仑作王了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT33_6","006_33_6","DEU","33","6","6","愿流本生存，不致死亡，愿他的人数不致稀少。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT33_7","006_33_7","DEU","33","7","7","论到犹大，他这样说：“耶和华啊，求你垂听犹大的声音，领他归回自己的族人那里；他曾用手为自己奋斗，愿你帮助他抵挡仇敌。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT33_8","006_33_8","DEU","33","8","8","论到利未，他说：“耶和华啊，愿你的土明和乌陵属于倚靠你的利未人，就是你在玛撒试验过的，在米利巴水边与他们争论过的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT33_9","006_33_9","DEU","33","9","9","利未人论到自己的父母说：‘我没有看顾他们’；他不承认自己的兄弟，也不认识自己的儿女；因为他们谨守你的话，持守你的约。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT33_10","006_33_10","DEU","33","10","10","他们要把你的典章教训雅各，把你的律法教训以色列；他们要把香焚在你面前，把全牲的燔祭献在你的祭坛上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT33_11","006_33_11","DEU","33","11","11","耶和华啊，求你赐福他的能力，悦纳他手中的作为；那些起来攻击他和恨他的人，愿你刺透他们的腰，使他们不能再起来。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT33_12","006_33_12","DEU","33","12","12","论到便雅悯，他说：“耶和华所爱的，必在耶和华身边安然居住；耶和华终日庇护他，也必住在他的两肩之间。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT33_13","006_33_13","DEU","33","13","13","论到约瑟，他说：“愿他的地蒙耶和华赐福，得着从天上而来的上好之物，以及蕴藏在地里的泉水； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT33_14","006_33_14","DEU","33","14","14","得着从太阳而来的上好之物，每月所产的佳果； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT33_15","006_33_15","DEU","33","15","15","得着从太古之山而来的上品，从永远之岭而来的上好之物； ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT33_16","006_33_16","DEU","33","16","16","得着从地所出的上好之物，和其中所充满的；得着那住在荆棘中的耶和华的恩宠；愿这些都临到约瑟的头上，就是临到那在兄弟中作王子的人的头上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT33_17","006_33_17","DEU","33","17","17","他头生的公牛大有威严；他的两角是野牛的角，用来抵触万民，直到地极；这角是以法莲的万万，那角是玛拿西的千千。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT33_18","006_33_18","DEU","33","18","18","论到西布伦，他说：“西布伦啊，你出外的时候，要喜乐；以萨迦啊，你在帐棚里的时候，也要喜乐。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT33_19","006_33_19","DEU","33","19","19","他们要把万民召到山上来，在那里要献上公义的祭；因为他们要吸取海洋的丰富，沙土中埋藏着的宝藏。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT33_20","006_33_20","DEU","33","20","20","论到迦得，他说：“那使迦得扩张的，是应该称颂的，迦得蹲下如母狮，他撕裂膀臂，连头顶也撕裂。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT33_21","006_33_21","DEU","33","21","21","他为自己选择了头一份，因为在那里有指挥者的分存留着；他与人民的众首领一同来，他施行耶和华的公义，以及与以色列有关的典章。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT33_22","006_33_22","DEU","33","22","22","论到但，他说：“但是只幼狮，从巴珊跳出来。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT33_23","006_33_23","DEU","33","23","23","论到拿弗他利，他说：“拿弗他利啊，你饱受恩宠，满得耶和华的福，可以取得西方和南方为业。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT33_24","006_33_24","DEU","33","24","24","论到亚设，他说：“愿亚设蒙福，胜过众子，愿他得兄弟的喜悦；愿他把脚蘸在油中。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT33_25","006_33_25","DEU","33","25","25","你的门闩是铜的，是铁的，你的日子怎样，你的力量也必怎样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT33_26","006_33_26","DEU","33","26","26","没有人像耶书仑的　神，为了帮助你，他乘驾诸天，在他的威严中，他腾空行云。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT33_27","006_33_27","DEU","33","27","27","亘古的　神是你的居所；他永久的膀臂在你以下。他把仇敌从你面前赶出去，他发令说：‘毁灭吧！’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT33_28","006_33_28","DEU","33","28","28","所以以色列可以安然居住，雅各的本源，独处在产五谷新酒之地；他的天也滴下甘露。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT33_29","006_33_29","DEU","33","29","29","以色列啊，你是有福的；有谁像你呢？你这蒙耶和华拯救的子民，他是帮助你的盾牌，他是你威严的刀剑。你的仇敌必向你屈服；你必践踏他们的背脊。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT34_1","006_34_1","DEU","34","1","1","摩西从摩押平原上了尼波山，就是上了耶利哥对面的毗斯迦山顶。耶和华把全地指给他看，就是把基列直到但， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT34_2","006_34_2","DEU","34","2","2","拿弗他利全地，以法莲和玛拿西之地，犹大全地，直到西海， ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT34_3","006_34_3","DEU","34","3","3","南地和那平原，就是棕树城耶利哥的盆地，直到琐珥，都指给他看。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT34_4","006_34_4","DEU","34","4","4","耶和华对他说：“这就是我曾经向亚伯拉罕、以撒、雅各起誓应许之地，说：‘我要把这地赐给你的后裔。’现在我让你亲眼看见了，可是你不能过到那边去。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT34_5","006_34_5","DEU","34","5","5","于是耶和华的仆人摩西，照着耶和华所说的，死在摩押地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT34_6","006_34_6","DEU","34","6","6","耶和华把他埋葬在摩押地，伯．毗珥对面的山谷里，只是直到今日还没有人知道埋葬他的地方。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT34_7","006_34_7","DEU","34","7","7","摩西死的时候，已经一百二十岁；他的眼睛没有昏花，他的精力也没有衰退。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT34_8","006_34_8","DEU","34","8","8","以色列人在摩押平原为摩西哀哭了三十日；然后为摩西守丧哀哭的日子就满了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT34_9","006_34_9","DEU","34","9","9","嫩的儿子约书亚，因为摩西曾经按手在他身上，就充满了智慧的灵；以色列人就听从他，照着耶和华吩咐摩西的去行了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT34_10","006_34_10","DEU","34","10","10","以后在以色列中，再没有兴起一位先知像摩西一样的；他是耶和华面对面所认识的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT34_11","006_34_11","DEU","34","11","11","耶和华差遣他在埃及地，向法老和他的一切臣仆，以及他的全地行了一切神迹和奇事。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("DT34_12","006_34_12","DEU","34","12","12","摩西又在以色列众人眼前行了一切大能的事，和一切大而可畏的事。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","1","耶和华的仆人摩西死了以后，耶和华吩咐摩西的侍从，嫩的儿子约书亚，说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS1_2","007_1_2","JOS","1","2","2","“我的仆人摩西死了；现在你要起来，和全体人民过这约旦河，到我现在要赐给他们以色列人的地去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS1_3","007_1_3","JOS","1","3","3","你们脚掌踏过的每一处地方，我都照着我应许摩西的赐给你们了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS1_4","007_1_4","JOS","1","4","4","从旷野和这黎巴嫩，直到大河，就是幼发拉底河，赫人的全地，以至大海日落的地方，就是你们的疆界。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS1_5","007_1_5","JOS","1","5","5","你一生的日子必没有一人能在你面前立得住；我怎样与摩西同在，也必照样与你同在；我决不离开你，也不离弃你。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS1_6","007_1_6","JOS","1","6","6","你要坚强勇敢，因为你必使这人民得着我曾经向他们列祖起誓，要赐给他们的那地作产业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS1_7","007_1_7","JOS","1","7","7","你只要坚强，十分勇敢，谨守遵行我仆人摩西吩咐你的一切律法，不可偏离左右，好使你无论到哪里去，都可以亨通。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS1_8","007_1_8","JOS","1","8","8","这律法书不可离开你的口，要昼夜默诵，好使你谨守遵行书中所记的一切；这样，你的道路就必顺利，你必一路亨通。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS1_9","007_1_9","JOS","1","9","9","我不是吩咐过你要坚强勇敢吗？所以，你不要惧怕，也不要惊慌；因为你无论到哪里去，耶和华你的　神必与你同在。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS1_10","007_1_10","JOS","1","10","10","于是约书亚吩咐人民的官长说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS1_11","007_1_11","JOS","1","11","11","“你们要走遍营中，吩咐人民说：‘你们要预备粮食，因为三天之内，你们要过这约旦河，进去得耶和华你们的　神要赐给你们作产业的地。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS1_12","007_1_12","JOS","1","12","12","约书亚又对流本人、迦得人和玛拿西半个支派的人说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS1_13","007_1_13","JOS","1","13","13","“你们要记住耶和华的仆人摩西吩咐你们的话：‘耶和华你们的　神赐你们安息，他必把这地赐给你们。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS1_14","007_1_14","JOS","1","14","14","你们的妻子、孩子和牲畜，都可以留在约旦河东边、摩西赐给你们的地上；但你们所有英勇的战士，都要拿起武器，在你们的兄弟前面过河去，帮助他们； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS1_15","007_1_15","JOS","1","15","15","等到耶和华使你们的兄弟可以和你们一样安居，同样得着耶和华你们的　神要赐给他们作产业的地，你们才可以回到你们所得的地，以它作你们的产业，就是耶和华的仆人摩西在约旦河东边日出之地赐给你们的地方。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS1_16","007_1_16","JOS","1","16","16","他们回答约书亚，说：“你吩咐我们的一切，我们都必遵行；无论你差派我们到哪里去，我们都一定去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS1_17","007_1_17","JOS","1","17","17","我们从前怎样凡事听从摩西，现在也必照样听从你；唯愿耶和华你的　神与你同在，像与摩西同在一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS1_18","007_1_18","JOS","1","18","18","无论谁违背你的话，不听从你吩咐他的一切命令，那人必要处死。你只管坚强勇敢。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS2_1","007_2_1","JOS","2","1","1","于是，嫩的儿子约书亚从什亭秘密地差派两个探子，对他们说：“你们去窥探那地和耶利哥。”二人去了，来到一个名叫喇合的妓女家中，就在那里住宿。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS2_2","007_2_2","JOS","2","2","2","有人向耶利哥王报告：“今夜从以色列人那里有人进来，要窥探这地。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS2_3","007_2_3","JOS","2","3","3","耶利哥王派人到喇合那里，说：“把那些来到你这里，进了你家中的人带出来，因为他们来是要窥探全地的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS2_4","007_2_4","JOS","2","4","4","但那女人已把那两个人藏起来，还这样回答王：“不错，那些人到过我这里来，但是，我不知道他们是从哪里来的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS2_5","007_2_5","JOS","2","5","5","天黑、城门快要关的时候，那些人出去了；我不知道他们到哪里去。你们快去追赶，必可以追上他们。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS2_6","007_2_6","JOS","2","6","6","其实她领他们上了屋顶，把他们藏在堆放在屋顶的麻秸里面。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS2_7","007_2_7","JOS","2","7","7","那些人就沿着往约旦河的路上追赶他们，直到渡口；追赶的人一出城，城门就关上了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS2_8","007_2_8","JOS","2","8","8","两个探子还没有躺下睡觉，那女人就上屋顶到他们那里去， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS2_9","007_2_9","JOS","2","9","9","对他们二人说：“我知道耶和华已经把这地赐给你们了，你们使我们十分害怕，这地所有的居民都在你们面前胆战心惊。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS2_10","007_2_10","JOS","2","10","10","因为我们听见你们从埃及出来的时候，耶和华怎样使红海的水在你们面前干了，以及你们怎样对待约旦河东亚摩利人的两个王西宏和噩，把他们完全消灭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS2_11","007_2_11","JOS","2","11","11","我们听见了，就都心里惊怕；没有一人再有勇气在你们面前站立；因为耶和华你们的　神是天上、也是地上的　神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS2_12","007_2_12","JOS","2","12","12","现在求你们指着耶和华向我起誓：我既然恩待了你们，你们也要恩待我的父家，并且给我一个确实的凭据， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS2_13","007_2_13","JOS","2","13","13","放过我的父母、兄弟姊妹和他们所有的一切，救我们的命不致死亡。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS2_14","007_2_14","JOS","2","14","14","两个探子就对她说：“如果你不泄漏我们这次行动，我们愿以性命作你们的保证；耶和华把这地赐给我们的时候，我们必定以慈爱和诚实待你们。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS2_15","007_2_15","JOS","2","15","15","于是，那女人用绳子把二人从窗户缒下去，因为她的房屋是在城墙上，她就住在城墙上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS2_16","007_2_16","JOS","2","16","16","她对他们二人说：“你们要到山上去，免得追赶的人遇上你们；你们要在那里躲藏三天，等追赶的人回城，然后你们才可以走你们的路。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS2_17","007_2_17","JOS","2","17","17","他们二人对她说：“如果你不遵照我们的话行，你叫我们起的誓就与我们无关了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS2_18","007_2_18","JOS","2","18","18","你要留意，我们再到这地方的时候，你要把这条朱红色线系在你缒我们下去的窗户上；你也要把你的父母、兄弟和你父的全家，都聚集在你的屋里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS2_19","007_2_19","JOS","2","19","19","任何人走出你家门，到外面去的，他的血就必归到他自己的头上，与我们无关；任何人同你在屋里的，如果有人下手加害他，他的血就归到我们头上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS2_20","007_2_20","JOS","2","20","20","如果你泄漏了我们这次的行动，那么，你叫我们起的誓就与我们无关了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS2_21","007_2_21","JOS","2","21","21","那女人回答：“照你们的话，就这样吧。”于是打发他们二人走了。他们走了以后，她就把朱红色线系在窗户上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS2_22","007_2_22","JOS","2","22","22","二人离去，上到山上，在那里住了三天，等追赶的人回城去了；追赶的人一路搜寻他们，却找不着。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS2_23","007_2_23","JOS","2","23","23","二人于是下山回去，过了约旦河，回到嫩的儿子约书亚那里，把他们遭遇的一切事向他报告。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS2_24","007_2_24","JOS","2","24","24","他们又对约书亚说：“耶和华真的把那地全交在我们手里了；那地所有的居民都在我们面前胆战心惊。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS3_1","007_3_1","JOS","3","1","1","约书亚清早起来，和全体以色列人从什亭出发，来到约旦河，在那里住宿，等候过河。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS3_2","007_3_2","JOS","3","2","2","过了三天，官长走遍营中， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS3_3","007_3_3","JOS","3","3","3","吩咐人民说：“你们看见耶和华你们的　神的约柜，又看见抬约柜的利未支派的祭司的时候，就要从你们所住的地方出发，跟在约柜后面走。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS3_4","007_3_4","JOS","3","4","4","只是你们和约柜之间应有一段距离，相隔约一公里，不可走近约柜，好使你们知道你们应走的路，因为这条路你们以前没有走过。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS3_5","007_3_5","JOS","3","5","5","约书亚对人民说：“你们要自洁，因为明天耶和华要在你们中间行奇事。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS3_6","007_3_6","JOS","3","6","6","约书亚又吩咐祭司说：“你们要抬起约柜，在人民前面过河去。”于是他们抬起约柜，走在人民的前面。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS3_7","007_3_7","JOS","3","7","7","耶和华对约书亚说：“今天起，我要使你在以色列众人眼中成为尊大，这样他们就知道我怎样与摩西同在，也必照样与你同在。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS3_8","007_3_8","JOS","3","8","8","你要吩咐抬着约柜的祭司说：‘你们到了约旦河水边的时候，要站在约旦河中。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS3_9","007_3_9","JOS","3","9","9","约书亚对以色列人说：“你们走近这里来，聆听耶和华你们的　神的话。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS3_10","007_3_10","JOS","3","10","11","约书亚说：“看哪，全地之主的约柜必在你们前面过约旦河，你们因此就知道永活的　神是在你们中间，他必把迦南人、赫人、希未人、比利洗人、革迦撒人、亚摩利人和耶布斯人，从你们面前驱逐出去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS3_12","007_3_12","JOS","3","12","12","现在你们要从以色列众支派中选十二个人，每支派一人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS3_13","007_3_13","JOS","3","13","13","抬全地之主耶和华约柜的祭司的脚掌一踏进约旦河水里，约旦河的水必被截断，那从上游流下来的水必立起成垒。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS3_14","007_3_14","JOS","3","14","14","人民离开帐棚出发，要过约旦河的时候，抬约柜的祭司在人民的前面。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS3_15","007_3_15","JOS","3","15","15","抬约柜的祭司来到约旦河，他们的脚碰到水边的时候（原来约旦河水在收割的日子，常是涨过两岸的）， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS3_16","007_3_16","JOS","3","16","16","水就停住了，那从上游流下来的水立起成垒，在很远的地方，就是在撒拉但旁边的亚当城那里停住；那往下流入亚拉巴海，就是盐海的水完全被截断；于是人民就在耶利哥的对面过了河。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS3_17","007_3_17","JOS","3","17","17","抬耶和华约柜的祭司在约旦河中间的干地上站住，等以色列众人都在干地上走过去，直到全国的人都完全走过了约旦河为止。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS4_1","007_4_1","JOS","4","1","1","全国的人都完全过了约旦河以后，耶和华就吩咐约书亚说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS4_2","007_4_2","JOS","4","2","2","“你要从人民中选十二个人，每支派一人， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS4_3","007_4_3","JOS","4","3","3","吩咐他们说：‘你们要从这里，就是约旦河中间，祭司的脚所站的地方，取十二块石头，把它们带过来，放在你们今夜要住宿的地方。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS4_4","007_4_4","JOS","4","4","4","于是，约书亚把他从以色列人中挑选的十二个人，每支派一人，都召了来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS4_5","007_4_5","JOS","4","5","5","约书亚对他们说：“你们走到约旦河中间，在耶和华你们的　神的约柜前面，按着以色列十二支派的数目，每人拿起一块石头，扛在自己的肩上； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS4_6","007_4_6","JOS","4","6","6","这可以在你们中间作记号；如果日后你们的子孙问你们，说：‘这些石头对你们有什么意思？’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS4_7","007_4_7","JOS","4","7","7","你们就可以告诉他们：‘这是因为约旦河的水在耶和华的约柜前被截断了；约柜过约旦河的时候，约旦河的水被截断了。所以这些石头要给以色列人作记念，直到永远。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS4_8","007_4_8","JOS","4","8","8","以色列人就照着约书亚吩咐的行了；他们照着耶和华吩咐约书亚的，按着以色列十二支派的数目，从约旦河中间取了十二块石头，把它们带过去，到他们住宿的地方，就放在那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS4_9","007_4_9","JOS","4","9","9","约书亚又在约旦河中间，在抬约柜的祭司的脚所站的地方，竖立十二块石头；那些石头到今日还在那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS4_10","007_4_10","JOS","4","10","10","抬约柜的祭司站在约旦河中间，直到耶和华吩咐约书亚告诉人民的一切事，就是照着摩西吩咐约书亚的一切事，都办完了，人民就急忙过去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS4_11","007_4_11","JOS","4","11","11","全体人民都过了河以后，耶和华的约柜和祭司才在人民的面前过去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS4_12","007_4_12","JOS","4","12","12","流本人、迦得人和玛拿西半个支派的人，都照着摩西吩咐他们的，拿起武器，在以色列人前面过河去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS4_13","007_4_13","JOS","4","13","13","他们约有四万人，都装备好，预备打仗，在耶和华面前走过去，来到耶利哥的平原，等候作战。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS4_14","007_4_14","JOS","4","14","14","那一天耶和华使约书亚在以色列众人眼中成为尊大；在他一生的日子，人民敬畏他，好像敬畏摩西一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS4_15","007_4_15","JOS","4","15","15","耶和华吩咐约书亚说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS4_16","007_4_16","JOS","4","16","16","“吩咐抬约柜的祭司从约旦河上来。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS4_17","007_4_17","JOS","4","17","17","于是约书亚吩咐祭司说：“你们从约旦河上来。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS4_18","007_4_18","JOS","4","18","18","抬耶和华约柜的祭司从约旦河中间上来的时候，祭司的脚掌一提起来踏在干地上，约旦河的水就流回原处，像以前一样涨过两岸。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS4_19","007_4_19","JOS","4","19","19","正月初十，人民从约旦河上来以后，就在吉甲，在耶利哥的东边安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS4_20","007_4_20","JOS","4","20","20","约书亚把他们从约旦河取来的那十二块石头，竖立在吉甲。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS4_21","007_4_21","JOS","4","21","21","约书亚对以色列人说：“如果日后你们的子孙问他们的父亲说：‘这些石头是什么意思？’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS4_22","007_4_22","JOS","4","22","22","那时，你们就要告诉你们的子孙，说：‘以色列人曾经在干地上走过了这约旦河。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS4_23","007_4_23","JOS","4","23","23","因为耶和华你们的　神在你们面前使约旦河的水干了，直到你们都过了河，好像耶和华你们的　神从前对红海所行的，在我们面前使红海干了，直到我们都过了河一样； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS4_24","007_4_24","JOS","4","24","24","好使地上万民都认识耶和华的手，是有能力的手，也要使你们永远敬畏耶和华你们的　神。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS5_1","007_5_1","JOS","5","1","1","在约旦河西，亚摩利人的众王和靠近海边迦南人的众王，听见耶和华怎样使约旦河的水在以色列人面前干了，直到他们都过河去，他们都心里惊怕，因以色列人的缘故，勇气全失。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS5_2","007_5_2","JOS","5","2","2","那时，耶和华对约书亚说：“你要制造火石刀，第二次给以色列人行割礼。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS5_3","007_5_3","JOS","5","3","3","约书亚就制造了火石刀，在包皮山那里给以色列人行了割礼。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS5_4","007_5_4","JOS","5","4","4","约书亚给以色列人行割礼的原因是这样：所有从埃及出来的人民，就是所有能作战的男丁，出埃及以后，都死在旷野的路上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS5_5","007_5_5","JOS","5","5","5","因为所有从埃及出来的人民都受过割礼；唯有从埃及出来以后，所有在旷野的路上出生的人民，都没有受过割礼。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS5_6","007_5_6","JOS","5","6","6","以色列人在旷野走了四十年，直到全国的人，就是从埃及出来能作战的男丁，都灭尽了，因为他们不听耶和华的话；耶和华曾经向他们起誓，必不容许他们看见耶和华向他们列祖起誓要赐给我们的地，就是流奶与蜜的地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS5_7","007_5_7","JOS","5","7","7","他们的子孙，就是耶和华兴起来代替他们的，约书亚给他们行了割礼；这些人是未受割礼的人，因为他们在路上没有受过割礼。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS5_8","007_5_8","JOS","5","8","8","全国的人受了割礼之后，都住在营中自己的地方，直到痊愈。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS5_9","007_5_9","JOS","5","9","9","耶和华对约书亚说：“我今日把埃及的耻辱从你们身上辊去了。”因此，那地方名叫吉甲（“吉甲”意即“辊”），直到今日。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS5_10","007_5_10","JOS","5","10","10","以色列人在吉甲安营；正月十四日晚上，他们在耶利哥的平原守逾越节。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS5_11","007_5_11","JOS","5","11","11","逾越节后次日，他们吃了那地的出产；就在那一天，吃了无酵饼和烘的谷物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS5_12","007_5_12","JOS","5","12","12","他们吃了那地的出产之后，第二天吗哪就停止降下；以色列人不再有吗哪了；那一年他们却吃迦南地的出产。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS5_13","007_5_13","JOS","5","13","13","约书亚走近耶利哥的时候，抬头观看，看见一个人站在他对面，手里拿着拔出来的刀。约书亚走到他那里，对他说：“你是我们的人，还是我们的仇敌呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS5_14","007_5_14","JOS","5","14","14","那人回答：“不是的；我现在来是作耶和华军队的元帅。”约书亚就脸伏在地，向他下拜，对他说：“我主有什么事要吩咐仆人呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS5_15","007_5_15","JOS","5","15","15","耶和华军队的元帅对约书亚说：“把你脚上的鞋脱下来，因为你站的地方是圣地。”约书亚就照着行了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS6_1","007_6_1","JOS","6","1","1","耶利哥的城门因以色列人的缘故，就紧紧地关闭，没有人出入。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS6_2","007_6_2","JOS","6","2","2","耶和华对约书亚说：“看，我已经把耶利哥和耶利哥的王，以及英勇的战士，都交在你的手中了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS6_3","007_6_3","JOS","6","3","3","你们所有能作战的男丁要围绕这城，一天围绕一次，六天都要这样行； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS6_4","007_6_4","JOS","6","4","4","并派七个祭司拿着七个羊角，走在约柜的前面；到第七天，你们要绕城七次，祭司也要吹角。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS6_5","007_6_5","JOS","6","5","5","当羊角吹起长号，你们听见角声的时候，全体人民要大声呼喊，那时城墙就必塌陷；你们各人要向前直冲。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS6_6","007_6_6","JOS","6","6","6","于是嫩的儿子约书亚把祭司召了来，对他们说：“你们要抬起约柜；并派七个祭司拿着七个羊角，走在耶和华约柜的前面。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS6_7","007_6_7","JOS","6","7","7","他又对人民说：“你们前去绕城吧，拿武器的人要走在耶和华约柜的前面。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS6_8","007_6_8","JOS","6","8","8","约书亚吩咐人民以后，七个祭司拿着七个羊角，走在耶和华的前面，并且吹角，耶和华的约柜在他们后面跟着走。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS6_9","007_6_9","JOS","6","9","9","拿武器的人走在吹角的祭司前面，在约柜后面也有防卫的队伍跟着走，祭司一面走，一面吹角。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS6_10","007_6_10","JOS","6","10","10","约书亚吩咐人民说：“你们不可呼喊，不可让人听见你们的声音，连一句话也不可出口，等到我吩咐你们‘呼喊’的那天，你们才可以呼喊。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS6_11","007_6_11","JOS","6","11","11","这样，耶和华的约柜绕城而行，围绕了一次，众人就回到营中，在营里住宿。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS6_12","007_6_12","JOS","6","12","12","约书亚清早起来，祭司又抬起耶和华的约柜。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS6_13","007_6_13","JOS","6","13","13","拿着七个羊角的七位祭司，走在耶和华的约柜前面；一面走，一面吹角；拿武器的人走在他们前面，在耶和华的约柜后面也有防卫的队伍跟着走；祭司一面走，一面吹角。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS6_14","007_6_14","JOS","6","14","14","第二日，众人又绕城一次，然后回到营里去；六日他们都是这样行。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS6_15","007_6_15","JOS","6","15","15","到了第七日，清早黎明的时候，他们起来，以同样的方式绕城七次；只有这一日，他们绕城七次。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS6_16","007_6_16","JOS","6","16","16","到了第七次，祭司吹角的时候，约书亚就对人民说：“你们呼喊吧，因为耶和华已经把这城赐给你们了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS6_17","007_6_17","JOS","6","17","17","这城要完全毁灭，城和城中的一切都归耶和华；只有妓女喇合，和所有与她在家中的都可以存活，因为她收藏了我们派去的使者。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS6_18","007_6_18","JOS","6","18","18","不过你们要谨慎，不可取那当毁灭的物，恐怕你们贪心，取了那当毁灭的物，就使以色列营成为当毁灭的，使以色列营遭遇灾祸。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS6_19","007_6_19","JOS","6","19","19","可是，所有的金银和铜铁的器皿，都要归耶和华为圣，存入耶和华的库房中。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS6_20","007_6_20","JOS","6","20","20","于是人民呼喊，祭司也吹角。人民听见角声的时候，就大声呼喊，城墙就塌陷了；于是，人民冲入城中，人人向前，把城攻取。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS6_21","007_6_21","JOS","6","21","21","他们把城中的一切，无论男女老幼、牛羊和驴，都用刀杀尽。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS6_22","007_6_22","JOS","6","22","22","约书亚对窥探那地的两个人说：“你们进那妓女的家里去，照着你们向她所起的誓，把那女人和她所有的一切，都从家里带出来。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS6_23","007_6_23","JOS","6","23","23","那两个年轻密探就进去，把喇合和她的父母、兄弟、她所有的一切，以及她所有的亲属，都领出来，安置在以色列的营外。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS6_24","007_6_24","JOS","6","24","24","众人把城和城中的一切都用火烧了；只有金银和铜铁的器皿都放入耶和华圣所的库房里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS6_25","007_6_25","JOS","6","25","25","约书亚却放过妓女喇合和她的父家，以及她所有的一切；她住在以色列中，直到今日，因为她收藏了约书亚派去窥探耶利哥的使者。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS6_26","007_6_26","JOS","6","26","26","那时，约书亚要人民起誓，说：“起来重建这耶利哥城的，那人在耶和华面前是可咒可诅的；他立地基的时候必丧长子；他安城门的时候必失幼子。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS6_27","007_6_27","JOS","6","27","27","耶和华与约书亚同在；约书亚的名声传遍全地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS7_1","007_7_1","JOS","7","1","1","以色列人在那当毁灭的物上犯了不忠实的罪；因为犹大支派中，谢拉的曾孙、撒底的孙子、迦米的儿子亚干，取了当毁灭的物，耶和华就向以色列人发怒。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS7_2","007_7_2","JOS","7","2","2","那时，约书亚从耶利哥派人到伯特利东边，靠近伯．亚文的艾城去，吩咐他们说：“你们上去窥探那地。”那些人就上去，窥探艾城。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS7_3","007_7_3","JOS","7","3","3","他们回来，对约书亚说：“不需要全体人民都上去；只要大约二三千人就可以上去攻打艾城了；不必劳动全体人民都上那里去，因为那里的人很少。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS7_4","007_7_4","JOS","7","4","4","于是人民中约有三千人上那里去，但他们竟在艾城的人面前逃跑了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS7_5","007_7_5","JOS","7","5","5","艾城的人击杀了他们约三十六人；从城门前追赶他们，一直追到示巴琳；在山坡上把他们击溃；人民的心就极其惊怕。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS7_6","007_7_6","JOS","7","6","6","约书亚就撕裂自己的衣服，和以色列人的长老，在耶和华的约柜前，一同俯伏在地，直到晚上，也把尘土撒在头上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS7_7","007_7_7","JOS","7","7","7","约书亚说：“唉！主耶和华啊，你为什么领这人民过约旦河，为要把我们交在亚摩利人的手中，使我们灭亡呢？我们宁愿住在约旦河那边倒好。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS7_8","007_7_8","JOS","7","8","8","主啊！以色列人既然在仇敌面前转身逃跑，我还有什么可说的呢？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS7_9","007_7_9","JOS","7","9","9","迦南人和这地所有的居民听见了，就必围困我们，把我们的名字从这世上剪除，那时你为你的大名要怎样行呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS7_10","007_7_10","JOS","7","10","10","耶和华对约书亚说：“你起来，为什么这样脸伏在地呢？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS7_11","007_7_11","JOS","7","11","11","以色列人犯了罪，违背了我吩咐他们的约定，因为他们取了那当毁灭的物，他们偷窃，并且说谎，又把那当毁灭的物放在自己的物件中。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS7_12","007_7_12","JOS","7","12","12","所以，以色列人在他们的仇敌面前站立不住，在他们的仇敌面前转身逃跑，因为他们成了当毁灭的。如果你们不把那当毁灭的物从你们中间除掉，我就必不再与你们同在了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS7_13","007_7_13","JOS","7","13","13","你起来，要人民自洁，对他们说：‘你们要自洁，预备明天；因为耶和华以色列的　神这样说：以色列啊！你们中间有那当毁灭的物；除非你们把那当毁灭的物从你们中间除去，你们在仇敌的面前就不能站立得住。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS7_14","007_7_14","JOS","7","14","14","到了早晨，你们要按着支派前来，耶和华抽签抽中的支派，要按着宗族前来；耶和华抽签抽中的宗族，要按着家庭前来；耶和华抽签抽中的家庭，男丁要一个一个前来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS7_15","007_7_15","JOS","7","15","15","如果那藏有当毁灭的物的人被抽签抽中了，他和他所有的一切都要用火焚烧；因为他违背了耶和华的约，又因为他在以色列中作了愚昧的事。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS7_16","007_7_16","JOS","7","16","16","约书亚清早起来，要以色列人按着支派前来；结果，犹大支派被抽签抽中了； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS7_17","007_7_17","JOS","7","17","17","他要犹大宗族前来，结果，谢拉的家族被抽签抽中了；他要谢拉家族的男丁一个一个前来，结果，撒底被抽签抽中了； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS7_18","007_7_18","JOS","7","18","18","他要撒底家中的男丁一个一个前来，结果，亚干被抽签抽中了，亚干是迦米的儿子、撒底的孙子、谢拉的曾孙，是属于犹大支派的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS7_19","007_7_19","JOS","7","19","19","约书亚对亚干说：“我儿，我劝你把荣耀归给耶和华以色列的　神，向他认罪，告诉我你作了什么事，不可向我隐瞒。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS7_20","007_7_20","JOS","7","20","20","亚干回答约书亚，说：“我实在得罪了耶和华以色列的　神；我作过的事是这样的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS7_21","007_7_21","JOS","7","21","21","我在战利品中，看见了一件美丽的示拿衣服、二千二百八十克银子，和一条重五百七十克的金条；我因贪爱这些物件，就把它们拿去了；现在埋藏在我帐棚的地里，银子在底下。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS7_22","007_7_22","JOS","7","22","22","约书亚就派人跑到亚干的帐棚里，果然见到东西埋藏在那里，银子在底下。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS7_23","007_7_23","JOS","7","23","23","他们就把东西从帐棚中拿出来，带到约书亚和以色列人那里，摆在耶和华面前。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS7_24","007_7_24","JOS","7","24","24","约书亚和全体以色列人一起把谢拉的曾孙亚干和那银子、那件衣服、那金条，以及亚干的儿女、牛、驴、羊、帐棚和他所有的一切，都带上亚割谷去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS7_25","007_7_25","JOS","7","25","25","约书亚说：“你为什么给我们招惹灾祸呢？今天耶和华必使你遭受灾祸。”于是全体以色列人用石头把他打死。他们用石头打死他们以后，就把一切用火烧了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS7_26","007_7_26","JOS","7","26","26","众人又在亚干身上堆起了一大堆石头，这堆石头一直存到今日；于是耶和华就回心转意，不发烈怒。因此那地方名叫亚割谷，直到今日。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS8_1","007_8_1","JOS","8","1","1","耶和华对约书亚说：“你不要惧怕，也不要惊慌，你只管带领所有能作战的人，起来上艾城去；你看，我已经把艾城的王和他的人民、城市、土地都交在你手里了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS8_2","007_8_2","JOS","8","2","2","你怎样对待耶利哥和耶利哥的王，也要照样对待艾城和艾城的王；只是城中的战利品和牲畜，你们可以据为己有；你要在城后面设下攻城的伏兵。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS8_3","007_8_3","JOS","8","3","3","于是，约书亚和所有能作战的人都起来上艾城去；约书亚选了三万英勇的战士，漏夜派他们出去， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS8_4","007_8_4","JOS","8","4","4","吩咐他们说：“你们注意，要在城后面埋伏攻城；不可离城太远，人人都要作好准备。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS8_5","007_8_5","JOS","8","5","5","我和所有与我一起的人，要向城推进。城里的人像前一次出来攻击我们的时候，我们就在他们面前逃跑； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS8_6","007_8_6","JOS","8","6","6","他们必定出来追赶我们，我们就把他们引出城来，因为他们必定说：‘这些人像前一次一样在我们面前逃跑了。’所以我们要在他们面前逃跑。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS8_7","007_8_7","JOS","8","7","7","那时你们就要从埋伏的地方起来，占领那城，因为耶和华你们的　神必把城交在你们的手里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS8_8","007_8_8","JOS","8","8","8","你们占领了城以后，就要放火烧城；要照着耶和华的话行事；你们要谨慎，我已经吩咐你们了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS8_9","007_8_9","JOS","8","9","9","约书亚差派他们去了，他们就上到埋伏的地方去，住在伯特利和艾城的中间，就是在艾城的西边。那一夜，约书亚却在人民中间住宿。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS8_10","007_8_10","JOS","8","10","10","约书亚清早起来，召集人民上艾城去，他和以色列的长老走在人民的前面。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS8_11","007_8_11","JOS","8","11","11","所有与他在一起的战士都上去，迫近艾城，在城的北面安营；在约书亚和艾城中间有一个山谷， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS8_12","007_8_12","JOS","8","12","12","约书亚挑了大约五千人，要他们埋伏在伯特利和艾城中间，就是艾城的西面。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS8_13","007_8_13","JOS","8","13","13","于是他们把众民，就是在城北的全军和在城西的伏兵都布置好了。那一夜，约书亚走进了山谷之中。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS8_14","007_8_14","JOS","8","14","14","艾城的王看见了这情形，就和艾城的人急忙在清早起来，按着所定的时候出到亚拉巴，要与以色列人交战；王却不知道在城后面有伏兵要攻击他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS8_15","007_8_15","JOS","8","15","15","约书亚和以色列人在他们面前装败，沿着通往旷野的路逃跑。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS8_16","007_8_16","JOS","8","16","16","城里的众民都被召集，去追赶他们；艾城的人追赶约书亚的时候，就都被诱离城。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS8_17","007_8_17","JOS","8","17","17","艾城和伯特利城没有留下一个人不出来追赶以色列人；他们撇下了敞开的城门，去追赶以色列人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS8_18","007_8_18","JOS","8","18","18","耶和华对约书亚说：“你向着艾城伸出你手中的短枪，因为我要把城交在你手里。”约书亚就向着艾城伸出他手里的短枪。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS8_19","007_8_19","JOS","8","19","19","他一伸手，伏兵就从埋伏的地方急忙起来，冲进城去，把城夺取，并连忙放火烧城。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS8_20","007_8_20","JOS","8","20","20","艾城的人转身观看，看见城里浓烟冲天，就全身乏力，不能逃跑；往旷野逃跑的以色列人就转过来攻击追赶他们的人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS8_21","007_8_21","JOS","8","21","21","约书亚和以色列人看见伏兵已经夺取了城，又看见城中浓烟上升，就转回，击杀艾城的人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS8_22","007_8_22","JOS","8","22","22","伏兵也出城攻击艾城的人；艾城的人就被困在以色列人中间，前后受敌；于是以色列人把他们击杀，没有留下一个，也没有一个逃脱。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS8_23","007_8_23","JOS","8","23","23","他们活捉了艾城的王，把他解到约书亚那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS8_24","007_8_24","JOS","8","24","24","以色列人在田间、在旷野，杀尽了所有追赶他们的艾城的居民，艾城的人全部倒在刀下，直到完全消灭；接着，以色列众人回到艾城，用刀击杀了城中的人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS8_25","007_8_25","JOS","8","25","25","那一天被杀的人，连男带女，共有一万二千人，就是艾城所有的人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS8_26","007_8_26","JOS","8","26","26","约书亚没有收回伸出短枪的手，直到把艾城的居民都消灭为止。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS8_27","007_8_27","JOS","8","27","27","只有那城里的牲畜和战利品，以色列人照着耶和华吩咐约书亚的话，都据为己有。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS8_28","007_8_28","JOS","8","28","28","约书亚烧了艾城，使城永远成为废堆，一片荒凉，直到今日。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS8_29","007_8_29","JOS","8","29","29","他又把艾城的王悬在树上，直到黄昏的时候；日落的时候，约书亚吩咐人把尸体从树上拿下来，丢在城门口那里，又在尸体上堆起了一大堆石头，这堆石头一直存到今日。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS8_30","007_8_30","JOS","8","30","30","那时，约书亚在以巴路山上，为耶和华以色列的　神筑了一座祭坛， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS8_31","007_8_31","JOS","8","31","31","是照着耶和华的仆人摩西吩咐以色列人的，照着摩西律法书上所写的，用未经过铁器打凿的整块石块筑成的一座祭坛；在这祭坛之上，众人向耶和华献燔祭，也献平安祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS8_32","007_8_32","JOS","8","32","32","约书亚在那里，当着以色列人面前，把摩西所写的摩西律法抄写在石头上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS8_33","007_8_33","JOS","8","33","33","全体以色列人和他们的长老、官长，以及审判官，都站在约柜的两旁，在抬耶和华约柜的利未支派的祭司前面；无论是寄居的，或是本地人，一半对着基利心山，一半对着以巴路山；正如耶和华的仆人摩西以前所吩咐的，好为以色列民祝福。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS8_34","007_8_34","JOS","8","34","34","然后，约书亚宣读律法上一切祝福和咒诅的话，全都照着律法书上所写的一切。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS8_35","007_8_35","JOS","8","35","35","摩西吩咐的一切话，约书亚在以色列全体会众和妇女、小孩，以及在他们中间来往的寄居者面前，没有一句不向他们宣读出来的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS9_1","007_9_1","JOS","9","1","1","在约旦河西，住在山上、高原和对着黎巴嫩山大海沿岸所有的王，就是赫人、亚摩利人、迦南人、比利洗人、希未人、耶布斯人的王，听见了这些事的时候， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS9_2","007_9_2","JOS","9","2","2","就聚集起来，同心协力地要与约书亚和以色列人交战。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS9_3","007_9_3","JOS","9","3","3","基遍的居民听见了约书亚向耶利哥和艾城所行的事， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS9_4","007_9_4","JOS","9","4","4","就施诡计，假冒使者而来，把旧的布袋和破裂又修补过的旧皮酒袋驮在驴上， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS9_5","007_9_5","JOS","9","5","5","脚上穿着补过的旧鞋，身穿旧衣服，所带的食物又干又碎。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS9_6","007_9_6","JOS","9","6","6","他们去到吉甲营中约书亚那里，对约书亚和以色列人说：“我们是从远地来的，现在求你们和我们立约。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS9_7","007_9_7","JOS","9","7","7","以色列人对这些希未人说：“你们也许是这地的居民，若是这样，我们怎样和你们立约呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS9_8","007_9_8","JOS","9","8","8","他们对约书亚说：“我们是你的仆人。”约书亚问他们：“你们是什么人？是从哪里来的？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS9_9","007_9_9","JOS","9","9","9","他们回答约书亚：“你的仆人为了耶和华你　神的名从很远的地方而来，因为我们听见了他的名声和他在埃及所行的一切事， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS9_10","007_9_10","JOS","9","10","10","以及他对约旦河东亚摩利人的两个王，就是希实本王西宏和在亚斯他录的巴珊王噩，所行的一切事。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS9_11","007_9_11","JOS","9","11","11","所以我们的长老和我们本国所有的居民对我们说：‘你们手里要带着旅途用的干粮，去迎见以色列人，对他们说：我们是你们的仆人，现在求你们和我们立约。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS9_12","007_9_12","JOS","9","12","12","我们出门到你们这里来的时候，从家里带出来作干粮的这饼还是热的；看哪，现在都又干又碎了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS9_13","007_9_13","JOS","9","13","13","这些皮酒袋，我们盛酒的时候，还是新的；你看，现在都破裂了。我们这些衣服和鞋因路途遥远，都穿旧了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS9_14","007_9_14","JOS","9","14","14","以色列人取了他们一些食物，却没有求问耶和华的旨意。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS9_15","007_9_15","JOS","9","15","15","于是约书亚与他们议和，和他们立约，容他们存活；会众的首领也向他们起了誓。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS9_16","007_9_16","JOS","9","16","16","以色列人和他们立约之后，过了三天，才听见他们是自己的近邻，是住在这地的居民。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS9_17","007_9_17","JOS","9","17","17","于是，以色列人起程，第三日就到了他们的城市；他们的城市就是基遍、基非拉、比录、基列．耶琳。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS9_18","007_9_18","JOS","9","18","18","以色列人没有击杀他们，因为会众的首领曾经指着耶和华以色列的　神向他们起了誓，全体会众就都向首领发怨言。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS9_19","007_9_19","JOS","9","19","19","众首领对全体会众说：“我们曾经指着耶和华以色列的　神向他们起了誓，现在我们不能伤害他们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS9_20","007_9_20","JOS","9","20","20","我们要这样待他们，就是容他们存活，免得　神的忿怒因我们向他们所起的誓，临到我们身上。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS9_21","007_9_21","JOS","9","21","21","众首领又对会众说：“要让他们存活。”于是他们就给全体会众作了劈柴打水的人，这是按照众首领对他们的吩咐。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS9_22","007_9_22","JOS","9","22","22","约书亚把他们召了来，质问他们：“你们为什么欺骗我们说：‘我们离你们很远’，其实你们却是住在这地的？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS9_23","007_9_23","JOS","9","23","23","现在你们要受到咒诅，你们中间必不断有人作奴仆，为我　神的圣所作劈柴打水的人。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS9_24","007_9_24","JOS","9","24","24","他们回答约书亚，说：“因为你的仆人确实地听见，耶和华你的　神曾经吩咐他的仆人摩西，要把这整片土地赐给你们，并且要在你们面前把这地上所有的居民都消灭，因此，我们因你们的缘故，很怕丧命，才行了这事。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS9_25","007_9_25","JOS","9","25","25","现在，你看，我们都在你的手里，你看怎样处置我们算为好、算为对，就怎样行吧。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS9_26","007_9_26","JOS","9","26","26","约书亚就这样处置他们，救了他们脱离以色列人的手，以色列人就没有杀他们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS9_27","007_9_27","JOS","9","27","27","在那一天，约书亚指派他们在耶和华选择的地方，为会众和耶和华的祭坛作劈柴打水的人，直到今日。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS10_1","007_10_1","JOS","10","1","1","耶路撒冷王亚多尼．洗德听见约书亚占领了艾城，把城完全毁灭，约书亚怎样对待耶利哥和耶利哥的王，也照样对待艾城和艾城的王；又听见基遍的居民已经与以色列人议和，并可以住在这地， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS10_2","007_10_2","JOS","10","2","2","他们就非常惧怕。因为基遍是大城，好像一座王城；又因为基遍比艾城大，城里所有的人都是勇士。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS10_3","007_10_3","JOS","10","3","3","因此，耶路撒冷王亚多尼．洗德派人到希伯仑王何咸、耶末王毗兰、拉吉王雅非亚和伊矶伦王底璧那里去，对他们说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS10_4","007_10_4","JOS","10","4","4","“求你们上我这里来帮助我，我们好攻打基遍，因为基遍已经与约书亚和以色列人议和了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS10_5","007_10_5","JOS","10","5","5","于是亚摩利人的那五个王，就是耶路撒冷王、希伯仑王、耶末王、拉吉王和伊矶伦王，联合起来，带着他们所有的军队上去，在基遍的对面安营，攻打基遍。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS10_6","007_10_6","JOS","10","6","6","基遍人就派人到吉甲营中约书亚那里去，说：“不可丢弃你的仆人，求你快快上我们这里来拯救我们、帮助我们；因为住在山地的亚摩利人所有的王都集合起来攻击我们。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS10_7","007_10_7","JOS","10","7","7","于是约书亚和所有能作战的人，以及所有英勇的战士，都一起从吉甲上去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS10_8","007_10_8","JOS","10","8","8","耶和华对约书亚说：“你不要怕他们，因为我已经把他们交在你手里了；他们必没有一人能在你面前站立得住。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS10_9","007_10_9","JOS","10","9","9","于是约书亚乘夜从吉甲上去，突然来到他们那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS10_10","007_10_10","JOS","10","10","10","耶和华使他们在以色列人面前溃乱，约书亚在基遍大大地击杀他们，沿着伯．和仑的上坡路追赶他们，击打他们，直到亚西加和玛基大。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS10_11","007_10_11","JOS","10","11","11","他们从以色列人面前逃跑，正在下伯．和仑斜坡的时候，耶和华从天上降大冰雹在他们身上，一直到亚西加，打死他们；被冰雹打死的，比以色列人用刀杀死的还多。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS10_12","007_10_12","JOS","10","12","12","那时，就是耶和华把亚摩利人交给以色列人的时候，约书亚在以色列人面前对耶和华说：“太阳啊，停在基遍；月亮啊，停在亚雅仑谷。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS10_13","007_10_13","JOS","10","13","13","于是太阳停住，月亮站住，直到以色列人在仇敌的身上报了仇。这事不是写在《雅煞珥书》上吗？太阳在天空中站住，不急速下落，约有一整天。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS10_14","007_10_14","JOS","10","14","14","在这日以前或这日以后，耶和华听人的祷告，没有像这日一样的，因为耶和华为以色列作战。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS10_15","007_10_15","JOS","10","15","15","后来，约书亚和众以色列人回到吉甲营那里去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS10_16","007_10_16","JOS","10","16","16","那五个王逃跑了，躲藏在玛基大洞里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS10_17","007_10_17","JOS","10","17","17","有人告诉约书亚，说：“那五个王已经找到了，都躲藏在玛基大洞里。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS10_18","007_10_18","JOS","10","18","18","约书亚说：“你们把几块大石头辊到洞口那里去，并派人到洞口去看守他们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS10_19","007_10_19","JOS","10","19","19","你们却不可站着，要追赶你们的仇敌，从后面击杀他们，不可让他们逃进自己的城中，因为耶和华你们的　神已经把他们交在你们的手里了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS10_20","007_10_20","JOS","10","20","20","约书亚和以色列人把他们杀得惨败，直到把他们灭绝为止，那些逃脱的人都逃进设防的城里； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS10_21","007_10_21","JOS","10","21","21","众以色列人都平平安安回到玛基大营中约书亚那里。没有人敢说话攻击以色列人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS10_22","007_10_22","JOS","10","22","22","约书亚说：“你们打开洞口，把那五个王从洞里拉出来，带到我这里来。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS10_23","007_10_23","JOS","10","23","23","众人就照着执行，他们把那五个王，就是耶路撒冷王、希伯仑王、耶末王、拉吉王和伊矶伦王，从洞里拉出来，带到约书亚那里去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS10_24","007_10_24","JOS","10","24","24","众人把那五个王带到约书亚那里去的时候，约书亚把所有的以色列人都召了来，对那些与他同去作战的军长说：“你们走前来，把脚踏在这些王的颈项上。”他们就走前来，把脚踏在那些王的颈项上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS10_25","007_10_25","JOS","10","25","25","约书亚对他们说：“你们不要惧怕，不要惊慌；总要坚强勇敢，因为耶和华必这样对待你们要攻打的所有仇敌。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS10_26","007_10_26","JOS","10","26","26","随后，约书亚把那五个王杀死，悬在五棵树上；他们就悬在树上，直到晚上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS10_27","007_10_27","JOS","10","27","27","到了日落的时候，约书亚吩咐人把他们从树上取下来，丢在他们躲藏过的洞里，把几块大石头放在洞口；这些石头一直存到今日。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS10_28","007_10_28","JOS","10","28","28","在那天，约书亚占领了玛基大，用刀击杀了那城的人和那城的王，把城中所有的人完全毁灭，不容一人逃脱；他对待玛基大王就像对待耶利哥王一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS10_29","007_10_29","JOS","10","29","29","约书亚和跟他在一起的众以色列人从玛基大往立拿去，攻打立拿。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS10_30","007_10_30","JOS","10","30","30","耶和华把立拿和立拿的王也交在以色列人手里，约书亚用刀攻击那城，杀了城里所有的人，不容一人逃脱；他对待立拿王就像对待耶利哥王一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS10_31","007_10_31","JOS","10","31","31","约书亚和跟他在一起的众以色列人从立拿往拉吉去，对着拉吉安营，攻打这城。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS10_32","007_10_32","JOS","10","32","32","耶和华把拉吉交在以色列人手里，第二天约书亚就占领了拉吉，用刀攻击那城，杀了城中所有的人，跟他对立拿所行的一切一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS10_33","007_10_33","JOS","10","33","33","那时，基色王荷兰上来帮助拉吉，约书亚就把他和他的人民都击杀了，没有留下一人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS10_34","007_10_34","JOS","10","34","34","约书亚和与他在一起的众以色列人从拉吉往伊矶伦去，对着伊矶伦安营，攻打这城。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS10_35","007_10_35","JOS","10","35","35","那一天，他们占领了这城，用刀攻击那城，杀了城中所有的人；那一天约书亚把他们完全毁灭，跟他对拉吉所行的一切一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS10_36","007_10_36","JOS","10","36","36","约书亚和与他在一起的众以色列人从伊矶伦上希伯仑去，攻打这城。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS10_37","007_10_37","JOS","10","37","37","他们占领了这城，用刀攻击这城，杀了这城的王，又攻击属于这城的城镇，杀了城中所有的人，不容一人逃脱，跟他对伊矶伦所行的一切一样，把这城和城中所有的人完全毁灭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS10_38","007_10_38","JOS","10","38","38","约书亚和与他在一起的众以色列人回到了底璧，攻打这城。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS10_39","007_10_39","JOS","10","39","39","约书亚占领了这城，抓住这城的王，又占领了属于这城的一切城镇；以色列人用刀击杀他们，把城中所有的人都毁灭了；约书亚不容一人逃脱，他怎样对待希伯仑，也照样对待底璧和底璧的王；也好像他对待立拿和立拿的王一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS10_40","007_10_40","JOS","10","40","40","这样，约书亚击杀了全地的人，就是山地、南地、高原和山坡的人，以及那些地方所有的王，不容一人逃脱；约书亚照着耶和华以色列的　神的吩咐，把有气息的都完全毁灭了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS10_41","007_10_41","JOS","10","41","41","约书亚从加低斯．巴尼亚击杀他们，直到迦萨，又从歌珊全地击杀他们，直到基遍。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS10_42","007_10_42","JOS","10","42","42","约书亚在这一次战役中击败了这些王和占领了他们的地，是因为耶和华以色列的　神为以色列作战。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS10_43","007_10_43","JOS","10","43","43","于是约书亚和与他在一起的众以色列人回到吉甲营中。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS11_1","007_11_1","JOS","11","1","1","夏琐王耶宾一听见这些事，就派人去见玛顿王约巴、伸仑王、押煞王， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS11_2","007_11_2","JOS","11","2","2","以及住在北方山地、基尼烈南边的亚拉巴高原和西边多珥高地的众王， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS11_3","007_11_3","JOS","11","3","3","又去见在东方和西方的迦南人，住在山地的亚摩利人、赫人、比利洗人和耶布斯人，以及米斯巴地黑门山下的希未人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS11_4","007_11_4","JOS","11","4","4","这些王与他们所有的军队都一同出来，人数众多，好像海边的沙，还有很多马匹和车辆。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS11_5","007_11_5","JOS","11","5","5","这些王都联合起来，来到米伦水边，在那里一起安营，要与以色列人作战。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS11_6","007_11_6","JOS","11","6","6","耶和华对约书亚说：“你不要因他们惧怕，因为明天这个时候，我必使他们全数在以色列人面前被杀；你要砍断他们的马蹄筋，焚烧他们的车辆。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS11_7","007_11_7","JOS","11","7","7","于是约书亚和所有与他在一起能作战的人，在米伦水边突然迫近，攻打他们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS11_8","007_11_8","JOS","11","8","8","耶和华把他们交在以色列人手里，以色列人就击杀他们，追赶他们直到西顿大城、米斯利弗．玛音，以及在东边的米斯巴谷；以色列人击杀他们，没有留下一个。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS11_9","007_11_9","JOS","11","9","9","约书亚照着耶和华吩咐他的对待他们；他砍断了他们的马蹄筋，用火烧了他们的车辆。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS11_10","007_11_10","JOS","11","10","10","那时，约书亚转回来，占领了夏琐，用刀击杀了夏琐王，因为夏琐在这些国中素来是为首的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS11_11","007_11_11","JOS","11","11","11","以色列人用刀击杀了城中所有的人，把他们完全毁灭；有气息的一个也没有留下；约书亚又放火烧了夏琐。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS11_12","007_11_12","JOS","11","12","12","约书亚夺取了那些王的一切城镇，又擒获那些城镇所有的王；他用刀击杀了他们，把一切完全毁灭，正如耶和华仆人摩西所吩咐的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS11_13","007_11_13","JOS","11","13","13","至于那些立在土丘上的城，除了夏琐以外，以色列人都没有焚烧；约书亚只烧了夏琐。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS11_14","007_11_14","JOS","11","14","14","那些城所有的战利品和牲畜，以色列人都据为己有；只是把所有的人都用刀击杀了，直到把他们杀尽；有气息的，他们没有留下一个。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS11_15","007_11_15","JOS","11","15","15","耶和华怎样吩咐他的仆人摩西，摩西就怎样吩咐约书亚，约书亚也照样行了；耶和华吩咐摩西的一切，约书亚没有一样不办妥的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS11_16","007_11_16","JOS","11","16","16","这样，约书亚夺取了那整个地区，就是山地、整个南地、歌珊全地、高原、亚拉巴、以色列山地和山地的高原； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS11_17","007_11_17","JOS","11","17","17","从延伸至西珥的哈拉山，直到黑门山下黎巴嫩谷的巴力．迦得；约书亚擒获了那些地方所有的王，把他们都杀死了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS11_18","007_11_18","JOS","11","18","18","约书亚和这些王作战了很多的日子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS11_19","007_11_19","JOS","11","19","19","除了住在基遍的希未人以外，没有一座城与以色列人议和的；所有其他的城都是以色列人作战夺取的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS11_20","007_11_20","JOS","11","20","20","因为这是出于耶和华的旨意，他使他们心里刚硬，要与以色列人交战，好把他们完全毁灭，使他们不蒙怜悯，却要被消灭，正如耶和华吩咐摩西的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS11_21","007_11_21","JOS","11","21","21","那时约书亚来了，把在山地、希伯仑、底璧、亚拿伯、整个犹大山地、整个以色列山地所有的亚衲族人都剪除了。约书亚把他们与他们的城镇都完全毁灭了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS11_22","007_11_22","JOS","11","22","22","在以色列人的境内，没有留下一个亚衲族人，只在迦萨、迦特和亚实突还有余下的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS11_23","007_11_23","JOS","11","23","23","这样，约书亚照着耶和华吩咐摩西的一切话，夺取了那全地；于是，约书亚按着以色列的支派把地分给他们作产业。全地也就止息了战争。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS12_1","007_12_1","JOS","12","1","1","以色列人在约旦河东向日出之地击杀了那地的两个王，占领了他们的地，就是从亚嫩谷直到黑门山，和东边的亚拉巴全境。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS12_2","007_12_2","JOS","12","2","2","这两个王，一个是住在希实本的亚摩利人的王西宏；他管辖的地区，是从亚嫩谷旁的亚罗珥起，包括山谷中部和基列的一半，直到雅博河，就是亚扪人的境界； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS12_3","007_12_3","JOS","12","3","3","东边有亚拉巴，上至基尼烈海，下至亚拉巴海，就是盐海，东边是往伯．耶西末的路；南边直到毗斯迦的山麓。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS12_4","007_12_4","JOS","12","4","4","另一个是巴珊王噩，他是利乏音人的余民，住在亚斯他录和以得来； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS12_5","007_12_5","JOS","12","5","5","他管辖的地区，是黑门山、撒迦、巴珊全地，直到基述人和玛迦人的境界，还有基列的一半，直到希实本王西宏的境界。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS12_6","007_12_6","JOS","12","6","6","耶和华的仆人摩西和以色列人把这两个王击杀了。耶和华的仆人摩西把地分给流本人、迦得人和玛拿西半个支派的人作产业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS12_7","007_12_7","JOS","12","7","7","以下是约书亚和以色列人在约旦河西，从黎巴嫩谷的巴力．迦得，直到延伸至西珥的哈拉山等地，所击杀的众王；约书亚把那地分给以色列各支派作产业； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS12_8","007_12_8","JOS","12","8","8","就是赫人、亚摩利人、迦南人、比利洗人、希未人、耶布斯人所住的山地、高原、亚拉巴、山坡、旷野和南地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS12_9","007_12_9","JOS","12","9","9","他们的王，一个是耶利哥王，一个是伯特利旁边的艾城王， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS12_10","007_12_10","JOS","12","10","10","一个是耶路撒冷王，一个是希伯仑王， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS12_11","007_12_11","JOS","12","11","11","一个是耶末王，一个是拉吉王， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS12_12","007_12_12","JOS","12","12","12","一个是伊矶伦王，一个是基色王， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS12_13","007_12_13","JOS","12","13","13","一个是底璧王，一个是基德王， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS12_14","007_12_14","JOS","12","14","14","一个是何珥玛王，一个是亚拉得王， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS12_15","007_12_15","JOS","12","15","15","一个是立拿王，一个是亚杜兰王， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS12_16","007_12_16","JOS","12","16","16","一个是玛基大王，一个是伯特利王， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS12_17","007_12_17","JOS","12","17","17","一个是他普亚王，一个是希弗王， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS12_18","007_12_18","JOS","12","18","18","一个是亚弗王，一个是拉沙仑王， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS12_19","007_12_19","JOS","12","19","19","一个是玛顿王，一个是夏琐王， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS12_20","007_12_20","JOS","12","20","20","一个是伸仑．米仑王，一个是押煞王， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS12_21","007_12_21","JOS","12","21","21","一个是他纳王，一个是米吉多王， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS12_22","007_12_22","JOS","12","22","22","一个是基低斯王，一个是靠近迦密的约念王， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS12_23","007_12_23","JOS","12","23","23","一个是多珥山地的多珥王，一个是吉甲的戈印王， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS12_24","007_12_24","JOS","12","24","24","一个是得撒王，共计三十一个王。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS13_1","007_13_1","JOS","13","1","1","约书亚老了，年纪不小；耶和华对他说：“你已经老了，年纪不小；还有很多的地有待征服。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS13_2","007_13_2","JOS","13","2","2","还剩下来的地，就是非利士人的全境和基述人的全地， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS13_3","007_13_3","JOS","13","3","3","从埃及东面的西曷河，向北直到以革伦的境界（这都算是迦南人的地方），由五个非利士人的首领管辖的迦萨人、亚实突人、亚实基伦人、迦特人、以革伦人的地方；并且有亚卫人， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS13_4","007_13_4","JOS","13","4","4","他们是在南方，以及迦南人全境和属西顿人的米亚拉，直到亚弗和亚摩利人的境界； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS13_5","007_13_5","JOS","13","5","5","还有迦巴勒人的地和东面的黎巴嫩全境，从黑门山下的巴力．迦得，直到哈马口； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS13_6","007_13_6","JOS","13","6","6","从黎巴嫩直到米斯利弗．玛音，所有住在山地的居民，就是所有的西顿人，我必在以色列人面前把他们赶出去。你只要照着我吩咐你的，把这地抽签分给以色列人作产业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS13_7","007_13_7","JOS","13","7","7","现在你要把这地分给九个支派和玛拿西半个支派作产业。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS13_8","007_13_8","JOS","13","8","8","玛拿西另半个支派，跟流本人和迦得人，已经得了摩西在约旦河东赐给他们的产业，是照着耶和华的仆人摩西赐给他们的， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS13_9","007_13_9","JOS","13","9","9","就是从亚嫩谷边的亚罗珥和谷中间的城，以及米底巴的整片平原，直到底本； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS13_10","007_13_10","JOS","13","10","10","还有在希实本作王的亚摩利人的王西宏所有的城镇，直到亚扪人的境界； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS13_11","007_13_11","JOS","13","11","11","又有基列地、基述人和玛迦人的境界，以及整个黑门山、巴珊全地，直到撒迦； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS13_12","007_13_12","JOS","13","12","12","另有巴珊王噩的全国，他在亚斯他录和以得来作王；他是利乏音人留下的余民。这些地方的人，摩西都把他们击杀了，赶走了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS13_13","007_13_13","JOS","13","13","13","以色列人却没有赶走基述人和玛迦人；因此，基述人和玛迦人住在以色列人中间，直到今日。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS13_14","007_13_14","JOS","13","14","14","只有利未支派，摩西没有把产业给他们；他们的产业就是献给耶和华以色列的　神的火祭，正如耶和华对他们所说的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS13_15","007_13_15","JOS","13","15","15","摩西按着流本支派的家族，把产业给了他们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS13_16","007_13_16","JOS","13","16","16","他们的境界是从亚嫩谷边的亚罗珥起，包括谷中间的城、靠近米底巴的整片平原、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS13_17","007_13_17","JOS","13","17","17","希实本和平原上属希实本所有的城、底本、巴末．巴力、伯．巴力．勉、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS13_18","007_13_18","JOS","13","18","18","雅杂、基底莫、米法押、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS13_19","007_13_19","JOS","13","19","19","基列亭、西比玛、谷中山地上的细列哈．沙辖、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS13_20","007_13_20","JOS","13","20","20","伯．毗珥、毗斯迦山坡、伯．耶西末、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS13_21","007_13_21","JOS","13","21","21","平原上所有的城和亚摩利人的王西宏的全国。这西宏曾经在希实本作王，摩西把他和米甸的首领以未、利金、苏珥、户珥和利巴都击杀了。这些都是西宏的王侯，住在那地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS13_22","007_13_22","JOS","13","22","22","在以色列人所杀的人中，比珥的儿子占卜者巴兰也被他们用刀所杀。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS13_23","007_13_23","JOS","13","23","23","流本人领土的疆界是约旦河，这就是流本人按着家族得着的产业所包括的众城，和属于这些城的村庄。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS13_24","007_13_24","JOS","13","24","24","摩西按着迦得支派的家族把产业分给迦得支派。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS13_25","007_13_25","JOS","13","25","25","他们的境界包括雅谢和基列所有的城，以及亚扪人的一半土地，直到拉巴前面的亚罗珥； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS13_26","007_13_26","JOS","13","26","26","从希实本直到拉抹．米斯巴和比多宁，又从玛哈念直到底璧的境界； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS13_27","007_13_27","JOS","13","27","27","还有在谷中的伯．亚兰、伯．宁拉、疏割、撒分，就是希实本王西宏国中的余地，以约旦河作疆界，直到基尼烈海的底端，都在约旦河东。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS13_28","007_13_28","JOS","13","28","28","这就是迦得人按着家族得着的产业所包括的城镇，和属于这些城的村庄。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS13_29","007_13_29","JOS","13","29","29","摩西把产业分给玛拿西半个支派，是按着玛拿西半个支派的家族分给他们的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS13_30","007_13_30","JOS","13","30","30","他们的境界是从玛哈念起，包括巴珊全地、巴珊王噩的全国，并且在巴珊的睚珥的所有村落，共六十座城， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS13_31","007_13_31","JOS","13","31","31","还有基列的一半和亚斯他录、以得来，就是在巴珊，噩的王国的两座城，都是按着家族分给玛拿西的儿子玛吉的孙子，就是分给玛吉的一半孙子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS13_32","007_13_32","JOS","13","32","32","以上这些地方是摩西在约旦河东，耶利哥对面的摩押平原所分配的产业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS13_33","007_13_33","JOS","13","33","33","可是利未支派，摩西却没有把产业分给他们，因为耶和华以色列的　神就是他们的产业，正如耶和华对他们所说的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS14_1","007_14_1","JOS","14","1","1","以下这些地方是以色列人在迦南地分得的产业，就是以利亚撒祭司和嫩的儿子约书亚，以及以色列人各支派的族长分给他们的， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS14_2","007_14_2","JOS","14","2","2","是照着耶和华借着摩西所吩咐的，以抽签的方法把产业分给九个半支派。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS14_3","007_14_3","JOS","14","3","3","因为摩西在约旦河东已经把产业分给了那两个半支派；却没有把产业分给他们中间的利未人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS14_4","007_14_4","JOS","14","4","4","因为约瑟的子孙成了两个支派，就是玛拿西和以法莲，因此以色列人没有把地业分给在那地的利未人，只给他们一些城市居住，还有城市的郊野，可以牧放他们的牲畜，安置他们的财产。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS14_5","007_14_5","JOS","14","5","5","耶和华怎样吩咐摩西，以色列人就照样行，把地分配了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS14_6","007_14_6","JOS","14","6","6","犹大人来到吉甲约书亚那里，基尼洗人耶孚尼的儿子迦勒对约书亚说：“耶和华在加低斯．巴尼亚对神人摩西所说关于你和我的话，你是知道的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS14_7","007_14_7","JOS","14","7","7","耶和华的仆人摩西从加低斯．巴尼亚派我去窥探这地的时候，我正四十岁；我照着我心里所想的向他报告。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS14_8","007_14_8","JOS","14","8","8","可是，与我一同上去的众兄弟却使人民的心惊惧，我却完全顺从耶和华我的　神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS14_9","007_14_9","JOS","14","9","9","那天摩西起誓说：‘你的脚踏过的地都必归你和你的子孙作产业，直到永远，因为你完全顺从耶和华我的　神。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS14_10","007_14_10","JOS","14","10","10","现在你看，自从耶和华对摩西说了这话以后，耶和华照着所应许的，使我活了这四十五年，就是以色列人在旷野行走的时期；现在你看，我今日已经是八十五岁了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS14_11","007_14_11","JOS","14","11","11","今日我还是强壮，像摩西派我去的那天一样；无论是作战，或是出入，那时我的力量怎样，现在我的力量还是怎样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS14_12","007_14_12","JOS","14","12","12","现在求你把耶和华那日所应许的这山地赐给我；因为那天你也曾听见那里有亚衲人，又有宽大坚固的城；但耶和华与我同在，我就可以把他们赶出去，正如耶和华所应许的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS14_13","007_14_13","JOS","14","13","13","于是约书亚给迦勒祝福，把希伯仑赐给了耶孚尼的儿子迦勒作产业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS14_14","007_14_14","JOS","14","14","14","因此，希伯仑成了基尼洗人耶孚尼的儿子迦勒的产业，直到今日；因为他完全顺从耶和华以色列的　神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS14_15","007_14_15","JOS","14","15","15","希伯仑从前名叫基列．亚巴；亚巴是亚衲人中最伟大的人。全地也就止息了战争。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_1","007_15_1","JOS","15","1","1","犹大支派按着家族抽签所得的地业，是极南的部分，达到以东的边境，去到南边寻的旷野。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_2","007_15_2","JOS","15","2","2","他们南方的疆界是从盐海的极南部分起，就是从南边的海湾起； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_3","007_15_3","JOS","15","3","3","伸到亚克拉滨山坡的南边，经过寻，上到加低斯．巴尼亚的南边，又经过希斯仑，再上到亚达珥，绕过甲加， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_4","007_15_4","JOS","15","4","4","经过押们，伸展到埃及河，疆界直通到海；这就是他们南方的疆界。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_5","007_15_5","JOS","15","5","5","东方的疆界是从盐海直到约旦河口。北方的疆界是从约旦河口的海湾起， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_6","007_15_6","JOS","15","6","6","上到伯．曷拉，经过伯．亚拉巴的北边，再上到流本的儿子波罕的磐石那里； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_7","007_15_7","JOS","15","7","7","又从亚割谷上到底璧，再北转到河的南边亚都冥山坡对面的吉甲去；又经过隐．示麦水泉，直通到隐．罗结； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_8","007_15_8","JOS","15","8","8","再上到欣嫩子谷，到达耶布斯南面的山坡，耶布斯就是耶路撒冷；又上到欣嫩子谷西边的山顶，就是在利乏音的北端； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_9","007_15_9","JOS","15","9","9","又从山顶转到尼弗多亚的水泉，伸展到以弗仑山的众城；又转到巴拉，巴拉就是基列．耶琳； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_10","007_15_10","JOS","15","10","10","又从巴拉向西绕到西珥山，经过耶琳山坡的北边，耶琳就是基撒仑；又下到伯．示麦，经过亭纳； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_11","007_15_11","JOS","15","11","11","伸展到以革伦北面的山坡，转到施基仑，经过巴拉山，伸展到雅比聂，直通到海为止。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_12","007_15_12","JOS","15","12","12","西方的疆界就是大海和海岸。这是犹大人按着家族所得四围的境界。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_13","007_15_13","JOS","15","13","13","约书亚照着耶和华所吩咐的，把犹大人的一份地业，就是基列．亚巴，分给了耶孚尼的儿子迦勒；亚巴是亚衲人的祖先。基列．亚巴就是希伯仑。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_14","007_15_14","JOS","15","14","14","迦勒把亚衲人的三个子孙，就是示筛、亚希幔、挞买，从那里赶出去；他们是亚衲人的后代。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_15","007_15_15","JOS","15","15","15","他又从那里上去攻击底璧的居民；底璧从前名叫基列．西弗。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_16","007_15_16","JOS","15","16","16","迦勒说：“谁能攻打基列．西弗，把基列．西弗夺取，我就把我的女儿押撒给他作妻子。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_17","007_15_17","JOS","15","17","17","迦勒的兄弟基纳斯的儿子俄陀聂夺取了那城，迦勒就把女儿押撒给他作妻子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_18","007_15_18","JOS","15","18","18","押撒出嫁的时候，怂恿丈夫向她父亲求一块田地；押撒一下驴，迦勒问她：“你要什么？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_19","007_15_19","JOS","15","19","19","她回答：“求你给我祝福；你既然把南地给了我，求你也把水泉给我。”她父亲就把上泉和下泉都给了她。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_20","007_15_20","JOS","15","20","20","以下是犹大支派按着家族所得的产业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_21","007_15_21","JOS","15","21","21","犹大支派极南边的众城，接近以东边界的，有：甲薛、以得、雅姑珥、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_22","007_15_22","JOS","15","22","22","基拿、底摩拿、亚大达、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_23","007_15_23","JOS","15","23","23","基低斯、夏琐、以提楠、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_24","007_15_24","JOS","15","24","24","西弗、提炼、比亚绿、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_25","007_15_25","JOS","15","25","25","夏琐．哈大他、加略．希斯仑（加略．希斯仑就是夏琐）、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_26","007_15_26","JOS","15","26","26","亚曼、示玛、摩拉大、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_27","007_15_27","JOS","15","27","27","哈萨．迦大、黑实门、伯．帕列、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_28","007_15_28","JOS","15","28","28","哈萨．书亚、别是巴、比斯约他、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_29","007_15_29","JOS","15","29","29","巴拉、以因、以森、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_30","007_15_30","JOS","15","30","30","伊勒多腊、基失、何珥玛、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_31","007_15_31","JOS","15","31","31","洗革拉、麦连拿、三撒拿、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_32","007_15_32","JOS","15","32","32","利巴勿、实忻、亚因、临门，共二十九座城，还有属于这些城的村庄。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_33","007_15_33","JOS","15","33","33","在高原有以实陶、琐拉、亚实拿、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_34","007_15_34","JOS","15","34","34","撒挪亚、隐．干宁、他普亚、以楠、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_35","007_15_35","JOS","15","35","35","耶末、亚杜兰、梭哥、亚西加、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_36","007_15_36","JOS","15","36","36","沙拉音、亚底他音、基底拉、基底罗他音，共十四座城，还有属于这些城的村庄。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_37","007_15_37","JOS","15","37","37","又有洗楠、哈大沙、麦大．迦得、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_38","007_15_38","JOS","15","38","38","底连、米斯巴、约帖、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_39","007_15_39","JOS","15","39","39","拉吉、波斯加、伊矶伦、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_40","007_15_40","JOS","15","40","40","迦本、拉幔、基提利、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_41","007_15_41","JOS","15","41","41","基低罗、伯．大衮、拿玛、玛基大，共十六座城，还有属于这些城的村庄。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_42","007_15_42","JOS","15","42","42","又有立拿、以帖、亚珊、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_43","007_15_43","JOS","15","43","43","益弗他、亚实拿、尼悉、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_44","007_15_44","JOS","15","44","44","基伊拉、亚革悉、玛利沙，共九座城，还有属于这些城的村庄。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_45","007_15_45","JOS","15","45","45","又有以革伦，和属于以革伦的市镇村庄； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_46","007_15_46","JOS","15","46","46","从以革伦直到海，所有靠近亚实突的城和属于这些城的村庄。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_47","007_15_47","JOS","15","47","47","亚实突和属于亚实突的市镇村庄；迦萨和属于迦萨的市镇村庄；直到埃及小河和大海沿岸的地方。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_48","007_15_48","JOS","15","48","48","在山地有沙密、雅提珥、梭哥、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_49","007_15_49","JOS","15","49","49","大拿、基列．萨拿（基列．萨拿就是底璧）、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_50","007_15_50","JOS","15","50","50","亚拿伯、以实提莫、亚念、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_51","007_15_51","JOS","15","51","51","歌珊、何伦、基罗，共十一座城，还有属于这些城的村庄。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_52","007_15_52","JOS","15","52","52","又有亚拉、度玛、以珊、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_53","007_15_53","JOS","15","53","53","雅农、伯．他普亚、亚非加、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_54","007_15_54","JOS","15","54","54","宏他、基列．亚巴（基列．亚巴就是希伯仑）、洗珥，共九座城，还有属于这些城的村庄。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_55","007_15_55","JOS","15","55","55","又有玛云、迦密、西弗、淤他、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_56","007_15_56","JOS","15","56","56","耶斯列、约甸、撒挪亚、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_57","007_15_57","JOS","15","57","57","该隐、基比亚、亭纳，共十座城，还有属于这些城的村庄。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_58","007_15_58","JOS","15","58","58","又有哈忽、伯．夙、基突、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_59","007_15_59","JOS","15","59","59","玛腊、伯．亚诺、伊勒提君，共六座城，还有属于这些城的村庄。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_60","007_15_60","JOS","15","60","60","又有基列．巴力（基列．巴力就是基列．耶琳）、拉巴，共两座城，还有属于这些城的村庄。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_61","007_15_61","JOS","15","61","61","在旷野有伯．亚拉巴、密丁、西迦迦、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_62","007_15_62","JOS","15","62","62","匿珊、盐城、隐．基底，共六座城，还有属于这些城的村庄。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS15_63","007_15_63","JOS","15","63","63","至于住在耶路撒冷的耶布斯人，犹大人不能把他们赶走；所以耶布斯人在耶路撒冷与犹大人同住，直到今日。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS16_1","007_16_1","JOS","16","1","1","约瑟的子孙抽签所得的地业，是从靠近耶利哥的约旦河起，到耶利哥东边的水泉，经过从耶利哥上去的旷野，进到在山地的伯特利； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS16_2","007_16_2","JOS","16","2","2","又从伯特利到路斯，经过亚基人的境界亚他绿， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS16_3","007_16_3","JOS","16","3","3","又向西下到押利提人的境界，去到下伯．和仑和基色的境界，直通到海。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS16_4","007_16_4","JOS","16","4","4","约瑟的儿子玛拿西和以法莲，也得了他们的产业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS16_5","007_16_5","JOS","16","5","5","以下是以法莲人按着家族所得的境界：他们的产业在东方的疆界，是亚他绿．亚达，直到上伯．和仑。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS16_6","007_16_6","JOS","16","6","6","向西伸展到北面的密米他，又向东绕到他纳．示罗，经过雅挪哈的东边； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS16_7","007_16_7","JOS","16","7","7","从雅挪哈下到亚他绿，又到拿拉，和耶利哥接壤，伸展到约旦河； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS16_8","007_16_8","JOS","16","8","8","又从他普亚向西行，到加拿河，直通到海；这就是以法莲支派按着家族所得的产业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS16_9","007_16_9","JOS","16","9","9","此外在玛拿西人的产业中，还有些城镇分给以法莲人的，这些城镇都包括属于它们的村庄在内。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS16_10","007_16_10","JOS","16","10","10","可是他们没有把住在基色的迦南人赶走，于是迦南人住在以法莲中间，直到今日，成了作苦工的奴仆。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS17_1","007_17_1","JOS","17","1","1","玛拿西是约瑟的长子，他的支派抽签所得的地业记在下面；至于玛拿西的长子，基列的父亲玛吉，因为是个战士，所以得到基列和巴珊。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS17_2","007_17_2","JOS","17","2","2","玛拿西其余的子孙按着家族抽签分地，包括亚比以谢的子孙、希勒的子孙、亚斯列的子孙、示剑的子孙、希弗的子孙、示米大的子孙；这些都是约瑟的儿子玛拿西子孙中男丁的各家族。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS17_3","007_17_3","JOS","17","3","3","玛拿西的玄孙、玛吉的曾孙、基列的孙子、希弗的儿子西罗非哈没有儿子，只有女儿；他女儿们的名字是玛拉、挪阿、曷拉、密迦、得撒。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS17_4","007_17_4","JOS","17","4","4","她们来到以利亚撒祭司和嫩的儿子约书亚，以及众首领的面前，说：“耶和华曾经吩咐摩西，在我们的兄弟中把产业分给我们。”于是约书亚照着耶和华所吩咐的，在她们的叔伯中间，把产业分给她们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS17_5","007_17_5","JOS","17","5","5","这样，除了约旦河东的基列和巴珊地之外，还有十份地业归属玛拿西。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS17_6","007_17_6","JOS","17","6","6","因为玛拿西的孙女，在玛拿西的孩子中，也得了产业；基列地是属于玛拿西其余的子孙的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS17_7","007_17_7","JOS","17","7","7","玛拿西的疆界，是从亚设起，到示剑东面的密米他；又向南走，到隐．他普亚的居民那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS17_8","007_17_8","JOS","17","8","8","（他普亚地是属于玛拿西的，但是在玛拿西疆界上的他普亚城，却是属于以法莲的子孙的。） ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS17_9","007_17_9","JOS","17","9","9","玛拿西的疆界又下到加拿河，在加拿河的南边，玛拿西的众城镇中，有这些城镇是属于以法莲的。玛拿西的疆界，从河的北面起，直通到海。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS17_10","007_17_10","JOS","17","10","10","南面是属于以法莲的，北面是属于玛拿西的；玛拿西在西边的疆界就是海，北面与亚设相接，东面和以萨迦相连； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS17_11","007_17_11","JOS","17","11","11","在以萨迦和亚设的境内，伯．善和属于伯．善的市镇，以伯莲和属于以伯莲的市镇，多珥的居民和属于多珥的市镇，都属于玛拿西；还有三处山区，就是：隐．多珥的居民和属于隐．多珥的市镇，他衲的居民和属于他衲的市镇，米吉多的居民和属于米吉多的市镇。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS17_12","007_17_12","JOS","17","12","12","可是玛拿西的子孙却不能把这些城的居民赶走，迦南人决意住在那地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS17_13","007_17_13","JOS","17","13","13","以色列人强盛以后，就迫使迦南人作苦工，却没有把他们完全赶出去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS17_14","007_17_14","JOS","17","14","14","约瑟的子孙对约书亚说：“耶和华这样赐福我们，我们族大人多，你为什么只给我们抽一份签，分一份地作产业呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS17_15","007_17_15","JOS","17","15","15","约书亚对他们说：“如果你们族大人多，又嫌以法莲山地过于窄小，就可以上森林区去，在比利洗人和利乏音人之地那里自己砍伐树木。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS17_16","007_17_16","JOS","17","16","16","约瑟的子孙回答：“那山地容不下我们，并且住在谷地的所有迦南人，就是住在伯．善和属于伯．善的市镇的人，以及住在耶列斯谷的人，都有铁车。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS17_17","007_17_17","JOS","17","17","17","约书亚对约瑟家，就是对以法莲人和玛拿西人说：“你们族大人多，势力强大，不可以只抽一份地业； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS17_18","007_17_18","JOS","17","18","18","山地也要归给你们，那里虽然是森林，你们可以砍伐，开辟的土地都归给你们；迦南人虽然拥有铁车，势力强大，你们也能把他们赶出去。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS18_1","007_18_1","JOS","18","1","1","以色列全体会众聚集在示罗，把会幕竖立在那里，因为那地在他们面前被征服了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS18_2","007_18_2","JOS","18","2","2","以色列人其余的七个支派还没有得着产业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS18_3","007_18_3","JOS","18","3","3","约书亚对以色列人说：“耶和华你们列祖的　神赐给你们的地，你们迟迟不去占领，要到几时呢？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS18_4","007_18_4","JOS","18","4","4","你们每支派要选出三个人，我要派他们去；他们要起程走遍那地，把各支派的产业描绘下来，然后回到我这里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS18_5","007_18_5","JOS","18","5","5","他们要把地业分作七份，犹大留在南方他们的境界内；约瑟家留在北方他们的境界内。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS18_6","007_18_6","JOS","18","6","6","你们要把地划分七份，然后把图样拿给我；我要在这里，在耶和华我们的　神面前，为你们抽签。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS18_7","007_18_7","JOS","18","7","7","利未人在你们中间没有业分，因为耶和华祭司的职分就是他们的产业。迦得支派、流本支派和玛拿西半个支派，已经在约旦河东得了产业，就是耶和华的仆人摩西分给他们的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS18_8","007_18_8","JOS","18","8","8","那些人起程前去的时候，约书亚吩咐那些前去绘画那地的人说：“你们要去，走遍那地，绘画地形，然后回到我这里来，我要在示罗这里，在耶和华面前，为你们抽签。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS18_9","007_18_9","JOS","18","9","9","那些人就去了，走遍那地，并绘画下来，把众城分作七份记在册子上，然后回到示罗营中约书亚那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS18_10","007_18_10","JOS","18","10","10","约书亚就在示罗，在耶和华面前为他们抽签；约书亚在那里按着他们的支派把地分给以色列人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS18_11","007_18_11","JOS","18","11","11","便雅悯支派按着家族抽了签；他们抽签所得的境界，是在犹大子孙和约瑟子孙中间。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS18_12","007_18_12","JOS","18","12","12","他们的疆界，北边是从约旦河起，向上到耶利哥的北边，又向西上到山地，直到伯．亚文的旷野。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS18_13","007_18_13","JOS","18","13","13","又从那里向南经过路斯，路斯就是伯特利，再下到亚他绿．亚达，靠近下伯．和仑南边的山地； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS18_14","007_18_14","JOS","18","14","14","又从那里伸延，绕到西边再向南，从伯．和仑南边对面的山起，直到犹大人的城基列．巴力，基列．巴力就是基列．耶琳；这是西方的疆界。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS18_15","007_18_15","JOS","18","15","15","南方的疆界是从基列．耶琳的边缘起，向西伸展，去到尼弗多亚的水泉； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS18_16","007_18_16","JOS","18","16","16","又下到欣嫩子谷前面的山边，就是利乏音谷北面的山；再下到欣嫩谷，去到耶布斯人的南边，又下去隐．罗结； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS18_17","007_18_17","JOS","18","17","17","再转向北，伸展至隐．示麦，去到亚都冥斜坡对面的基利录，又下到流本的儿子波罕的磐石那里； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS18_18","007_18_18","JOS","18","18","18","又经过亚拉巴对面山坡的北边，直下到亚拉巴； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS18_19","007_18_19","JOS","18","19","19","又经过伯．曷拉的北边，直通到盐海的北湾，约旦河的南端；这是南方的疆界。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS18_20","007_18_20","JOS","18","20","20","东方的疆界是约旦河。这就是便雅悯各家族所得的产业四围的疆界。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS18_21","007_18_21","JOS","18","21","21","便雅悯支派按着家族所得的城就是：耶利哥、伯．曷拉、伊麦．基悉、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS18_22","007_18_22","JOS","18","22","22","伯．亚拉巴、洗玛莲、伯特利、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS18_23","007_18_23","JOS","18","23","23","亚文、巴拉、俄弗拉、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS18_24","007_18_24","JOS","18","24","24","基法．阿摩尼、俄弗尼、迦巴，共十二座城，还有属于这些城的村庄； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS18_25","007_18_25","JOS","18","25","25","又有基遍、拉玛、比录、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS18_26","007_18_26","JOS","18","26","26","米斯巴、基非拉、摩撒、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS18_27","007_18_27","JOS","18","27","27","利坚、伊利毗勒、他拉拉、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS18_28","007_18_28","JOS","18","28","28","洗拉、以利弗、耶布斯（耶布斯就是耶路撒冷）、基比亚、基列，共十四座城，还有属于这些城的村庄。这就是便雅悯人按着家族所得的产业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS19_1","007_19_1","JOS","19","1","1","为西缅，就是为西缅支派，按着家族抽出第二签；他们的产业是在犹大人的产业中间。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS19_2","007_19_2","JOS","19","2","2","他们所得的产业有别是巴、示巴、摩拉大、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS19_3","007_19_3","JOS","19","3","3","哈萨．书亚、巴拉、以森、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS19_4","007_19_4","JOS","19","4","4","伊利多拉、比土力、何珥玛、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS19_5","007_19_5","JOS","19","5","5","洗革拉、伯．玛加博、哈萨．苏撒、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS19_6","007_19_6","JOS","19","6","6","伯．利巴勿、沙鲁险，共十三座城，还有属于这些城的村庄； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS19_7","007_19_7","JOS","19","7","7","又有亚因、利门、以帖、亚珊，共四座城，还有属于这些城的村庄； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS19_8","007_19_8","JOS","19","8","8","以及这些城周围所有的村庄，直到巴拉．比珥，就是南地的拉玛。这就是西缅支派按着家族所得的产业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS19_9","007_19_9","JOS","19","9","9","西缅人的产业是从犹大人的地业中得来的；因为犹大人的分过大，所以西缅人在犹大人的产业中得了他们的产业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS19_10","007_19_10","JOS","19","10","10","为西布伦人，按着家族抽出第三签；他们产业的境界去到撒立； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS19_11","007_19_11","JOS","19","11","11","他们的疆界再向西上到玛拉拉，直达大巴设，再去到约念前面的河； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS19_12","007_19_12","JOS","19","12","12","又从撒立向东转到日出的方向，去到吉斯绿．他泊的境界，又伸展到他比拉，上到雅非亚； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS19_13","007_19_13","JOS","19","13","13","又从那里往东面日出的方向，经过迦特．希弗，到以特．加汛、临门，再伸展到尼亚； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS19_14","007_19_14","JOS","19","14","14","又绕过尼亚的北面，到哈拿顿，直通到伊弗他．伊勒谷； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS19_15","007_19_15","JOS","19","15","15","还有加他、拿哈拉、伸仑、以大拉、伯利恒，共有十二座城，还有属于这些城的村庄。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS19_16","007_19_16","JOS","19","16","16","这些城和属于这些城的村庄，就是西布伦人按着家族所得的产业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS19_17","007_19_17","JOS","19","17","17","为以萨迦，就是为以萨迦人，按着家族抽出第四签。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS19_18","007_19_18","JOS","19","18","18","他们的境界包括耶斯列、基苏律、书念、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS19_19","007_19_19","JOS","19","19","19","哈弗连、示按、亚拿哈拉、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS19_20","007_19_20","JOS","19","20","20","拉璧、基善、亚别、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS19_21","007_19_21","JOS","19","21","21","利蔑、隐．干宁、隐．哈大、伯．帕薛， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS19_22","007_19_22","JOS","19","22","22","又达到他泊、沙哈洗玛、伯．示麦，直通到约旦河，共十六座城，还有属于这些城的村庄。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS19_23","007_19_23","JOS","19","23","23","这些城和属于这些城的村庄，就是以萨迦支派按着家族所得的产业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS19_24","007_19_24","JOS","19","24","24","为亚设支派，按着家族抽出第五签。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS19_25","007_19_25","JOS","19","25","25","他们的境界包括黑甲、哈利、比田、押煞、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS19_26","007_19_26","JOS","19","26","26","亚拉米勒、亚末、米沙勒，向西直达迦密和希曷．立纳； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS19_27","007_19_27","JOS","19","27","27","又转往日出的方向，到伯．大衮，延伸到细步纶，向北去到伊弗他．伊勒谷、伯．以墨和尼业，又伸展到迦布勒的左边， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS19_28","007_19_28","JOS","19","28","28","到义伯仑、利合、哈们、加拿，直到西顿大城； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS19_29","007_19_29","JOS","19","29","29","又转到拉玛，直到设防的城推罗；再转到何萨，直通到海岸靠近亚革悉的地区； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS19_30","007_19_30","JOS","19","30","30","又有乌玛、亚弗、利合，共二十二座城，还有属于这些城的村庄。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS19_31","007_19_31","JOS","19","31","31","这些城和属于这些城的村庄，就是亚设支派按着家族所得的产业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS19_32","007_19_32","JOS","19","32","32","为拿弗他利人抽出第六签，就是拿弗他利人按着家族所得的产业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS19_33","007_19_33","JOS","19","33","33","他们的疆界，是从希利弗，从撒拿音的橡树林，从亚大米．尼吉和雅比聂起，去到拉共，直通到约旦河； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS19_34","007_19_34","JOS","19","34","34","又向西转到亚斯纳．他泊，从那里伸展到户割，南边达到西布伦，西边达到亚设，东边达到约旦河那里的犹大。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS19_35","007_19_35","JOS","19","35","35","设防的城有西丁、侧耳、哈末、拉甲、基尼烈、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS19_36","007_19_36","JOS","19","36","36","亚大玛、拉玛、夏琐、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS19_37","007_19_37","JOS","19","37","37","基低斯、以得来、隐．夏琐、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS19_38","007_19_38","JOS","19","38","38","以利稳、密大．伊勒、和琏、伯．亚纳、伯．示麦，共十九座城，还有属于这些城的村庄。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS19_39","007_19_39","JOS","19","39","39","这些城和属于这些城的村庄，就是拿弗他利支派按着家族所得的产业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS19_40","007_19_40","JOS","19","40","40","为但支派，按着家族抽出第七签。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS19_41","007_19_41","JOS","19","41","41","他们产业的境界包括：琐拉、以实陶、伊珥．示麦、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS19_42","007_19_42","JOS","19","42","42","沙拉宾、亚雅仑、伊提拉、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS19_43","007_19_43","JOS","19","43","43","以伦、亭拿他、以革伦、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS19_44","007_19_44","JOS","19","44","44","伊利提基、基比顿、巴拉、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS19_45","007_19_45","JOS","19","45","45","伊胡得、比尼．比拉、迦特．临门、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS19_46","007_19_46","JOS","19","46","46","美．耶昆、拉昆和约帕对面的地区。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS19_47","007_19_47","JOS","19","47","47","但人未能控制他们的境界，因此他们就上去攻打利善，夺取那城，用刀击杀了城中的人；他们占领利善，就住在城中，以他们祖先但的名字，把利善改名为但。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS19_48","007_19_48","JOS","19","48","48","这些城和属于这些城的村庄，就是但支派按着家族所得的产业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS19_49","007_19_49","JOS","19","49","49","以色列人按着疆界把地分完了之后，就在他们中间把产业分给嫩的儿子约书亚。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS19_50","007_19_50","JOS","19","50","50","他们照着耶和华所吩咐的，把约书亚所要的城，就是以法莲山地的亭拿．西拉，给了他；约书亚就修建那城，住在城中。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS19_51","007_19_51","JOS","19","51","51","以上就是以利亚撒祭司和嫩的儿子约书亚，以及以色列人各支派的族长，在示罗会幕的门口，在耶和华面前，借着抽签所分的产业。这样，他们就完成了分地的事。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS20_1","007_20_1","JOS","20","1","1","耶和华对约书亚说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS20_2","007_20_2","JOS","20","2","2","“你要告诉以色列人：‘你们要照着我借着摩西命令你们的，为自己设立避难城， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS20_3","007_20_3","JOS","20","3","3","好使那出于错误、并非蓄意杀人的，可以逃到那里去；这些城要成为你们逃避报血仇的人的避难所。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS20_4","007_20_4","JOS","20","4","4","那杀人的要逃到这些城中的一座，站在城门口，把自己的事情向城中的众长老述说，长老就要把他接入城中，到他们那里，并要给他地方，使他可以住在他们中间。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS20_5","007_20_5","JOS","20","5","5","如果报血仇的人追赶他，长老不可把他交在报血仇的人手里，因为他并非蓄意杀人，他以前与他并没有仇恨。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS20_6","007_20_6","JOS","20","6","6","那杀人的要住在那城里，直到他站在会众面前受审；等到当时的大祭司死了，才可以回到本城本家，回到他逃出来的城那里。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS20_7","007_20_7","JOS","20","7","7","于是以色列人在拿弗他利山地，把加利利的基低斯分别出来；在以法莲山地，把示剑分别出来；在犹大山地，把基列．亚巴分别出来，基列．亚巴就是希伯仑； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS20_8","007_20_8","JOS","20","8","8","又在约旦河东，耶利哥的东面，从流本支派中，指定在旷野平原上的比悉；从迦得支派中，指定在基列的拉末；从玛拿西支派中，指定在巴珊的哥兰。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS20_9","007_20_9","JOS","20","9","9","这些都是为所有的以色列人，和在他们中间寄居的外族人所指定的城，让误杀人的可以逃到那里，不致死在报血仇的人手里，直到他站在会众面前受审为止。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS21_1","007_21_1","JOS","21","1","1","那时，利未人的众族长来到以利亚撒祭司和嫩的儿子约书亚，以及以色列众支派的族长那里， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS21_2","007_21_2","JOS","21","2","2","在迦南地的示罗对他们说：“耶和华曾经借着摩西吩咐要给我们城市居住，和城的郊野可以牧放我们的牲畜。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS21_3","007_21_3","JOS","21","3","3","于是以色列人照着耶和华所吩咐的，从自己的产业中，把以下这些城市和城的郊野，给了利未人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS21_4","007_21_4","JOS","21","4","4","首先为哥辖家族抽出签来：利未支派亚伦祭司的子孙，从犹大支派、西缅支派和便雅悯支派，抽签得了十三座城。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS21_5","007_21_5","JOS","21","5","5","哥辖其余的子孙，从以法莲支派的家族、但支派和玛拿西半个支派，抽签得了十座城。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS21_6","007_21_6","JOS","21","6","6","革顺的子孙，从以萨迦支派的家族、亚设支派、拿弗他利支派和在巴珊的玛拿西半个支派，抽签得了十三座城。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS21_7","007_21_7","JOS","21","7","7","米拉利的子孙，按着家族，从流本支派、迦得支派和西布伦支派，得了十二座城。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS21_8","007_21_8","JOS","21","8","8","以色列人照着耶和华吩咐摩西的，借着抽签，把这些城市和城的郊野分给利未人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS21_9","007_21_9","JOS","21","9","9","他们从犹大支派和西缅支派中，把以下这些有提名的城分了 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS21_10","007_21_10","JOS","21","10","10","给利未支派、哥辖家族中亚伦的子孙，因为第一签是他们的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS21_11","007_21_11","JOS","21","11","11","以色列人把犹大山地的基列．亚巴，和它四围的郊野，给了他们；亚巴是亚衲族的祖宗，基列．亚巴就是希伯仑。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS21_12","007_21_12","JOS","21","12","12","属于那城的田地和村庄，他们却给了耶孚尼的儿子迦勒作产业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS21_13","007_21_13","JOS","21","13","13","以色列人把误杀人者的避难城希伯仑，和希伯仑的郊野，又把立拿和立拿的郊野给了亚伦祭司的子孙， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS21_14","007_21_14","JOS","21","14","14","还有雅提珥和雅提珥的郊野，以实提莫和以实提莫的郊野， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS21_15","007_21_15","JOS","21","15","15","何仑和何仑的郊野，底璧和底璧的郊野， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS21_16","007_21_16","JOS","21","16","16","亚因和亚因的郊野，淤他和淤他的郊野，伯．示麦和伯．示麦的郊野，共九座城，都是从这两个支派分出来的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS21_17","007_21_17","JOS","21","17","17","又从便雅悯支派中，分给他们基遍和基遍的郊野，迦巴和迦巴的郊野， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS21_18","007_21_18","JOS","21","18","18","亚拿突和亚拿突的郊野，亚勒们和亚勒们的郊野，共四座城。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS21_19","007_21_19","JOS","21","19","19","亚伦子孙众祭司所有的城，共十三座，还有这些城的郊野。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS21_20","007_21_20","JOS","21","20","20","利未支派哥辖子孙的家族，就是哥辖其余的子孙，抽签所得的城是从以法莲支派中分出来的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS21_21","007_21_21","JOS","21","21","21","以色列人把误杀人者的避难城，就是在以法莲山地的示剑和示剑的郊野，给了他们；又把基色和基色的郊野，给了他们； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS21_22","007_21_22","JOS","21","22","22","又有基伯先和基伯先的郊野，伯．和仑和伯．和仑的郊野，共四座城。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS21_23","007_21_23","JOS","21","23","23","又从但支派中，给了他们伊利提基和伊利提基的郊野，基比顿和基比顿的郊野， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS21_24","007_21_24","JOS","21","24","24","亚雅仑和亚雅仑的郊野，迦特．临门和迦特．临门的郊野，共四座城。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS21_25","007_21_25","JOS","21","25","25","又从玛拿西半个支派中，给了他们他纳和他纳的郊野，迦特．临门和迦特．临门的郊野，共两座城。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS21_26","007_21_26","JOS","21","26","26","哥辖子孙其余的家族所有的城共十座，还有这些城的郊野。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS21_27","007_21_27","JOS","21","27","27","以色列人又从玛拿西半个支派中，把误杀人者的避难城，就是在巴珊的哥兰，和哥兰的郊野，给了利未人的家族中革顺的子孙；又给了他们比．施提拉和比．施提拉的郊野，共两座城。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS21_28","007_21_28","JOS","21","28","28","又从以萨迦支派中，给了他们基善和基善的郊野，大比拉和大比拉的郊野， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS21_29","007_21_29","JOS","21","29","29","耶末和耶末的郊野，隐．干宁和隐．干宁的郊野，共四座城。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS21_30","007_21_30","JOS","21","30","30","又从亚设支派中，给了他们米沙勒和米沙勒的郊野，押顿和押顿的郊野， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS21_31","007_21_31","JOS","21","31","31","黑甲和黑甲的郊野，利合和利合的郊野，共四座城。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS21_32","007_21_32","JOS","21","32","32","以色列人又从拿弗他利支派中，把误杀人者的避难城，就是在加利利的基低斯和基低斯的郊野，给了他们；又给他们哈末．多珥和哈末．多珥的郊野，加珥但和加珥但的郊野，共三座城。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS21_33","007_21_33","JOS","21","33","33","革顺人按着家族所有的城共十三座，还有这些城的郊野。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS21_34","007_21_34","JOS","21","34","34","其余的利未人，米拉利的子孙的家族，从西布伦支派中分得约念和约念的郊野，加珥他和加珥他的郊野， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS21_35","007_21_35","JOS","21","35","35","丁拿和丁拿的郊野，拿哈拉和拿哈拉的郊野，共四座城。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS21_36","007_21_36","JOS","21","36","36","又从流本支派中，给了他们比悉和比悉的郊野，雅杂和雅杂的郊野， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS21_37","007_21_37","JOS","21","37","37","基底莫和基底莫的郊野，米法押和米法押的郊野，共四座城。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS21_38","007_21_38","JOS","21","38","38","以色列人又从迦得支派中，把误杀人者的避难城，就是在基列的拉末和拉末的郊野，给了他们；又给他们玛哈念和玛哈念的郊野， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS21_39","007_21_39","JOS","21","39","39","希实本和希实本的郊野，雅谢和雅谢的郊野，共四座城。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS21_40","007_21_40","JOS","21","40","40","利未人其余的家族，就是米拉利的子孙，按着家族抽签所得的城，共有十二座。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS21_41","007_21_41","JOS","21","41","41","在以色列人的地业中，利未人所得的城共四十八座，还有这些城的郊野。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS21_42","007_21_42","JOS","21","42","42","这些城周围都有自己的郊野，每一座都是这样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS21_43","007_21_43","JOS","21","43","43","这样，耶和华就把他从前起誓要赐给他们列祖的全地给了以色列人；以色列人占领了那地，就定居下来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS21_44","007_21_44","JOS","21","44","44","耶和华照着他向他们列祖起誓所说的一切话，使他们四境平静；他们所有的仇敌，没有一人能在他们面前站立得住；耶和华把他们所有的仇敌都交在他们手里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS21_45","007_21_45","JOS","21","45","45","耶和华向以色列家应许赐福的话，没有一句落空，都应验了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS22_1","007_22_1","JOS","22","1","1","那时，约书亚把流本人、迦得人和玛拿西半个支派的人召了来， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS22_2","007_22_2","JOS","22","2","2","对他们说：“耶和华的仆人摩西吩咐你们的一切，你们都遵守了；我吩咐你们的一切，你们也都听从了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS22_3","007_22_3","JOS","22","3","3","这许多日子以来，你们一直没有撇弃你们的兄弟，直到今日；耶和华你们的　神吩咐你们的命令，你们也遵守了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS22_4","007_22_4","JOS","22","4","4","现在耶和华你们的　神，照着他应许的，已经使你们兄弟得享平安；现在你们可以返回自己家里，回到耶和华的仆人摩西在约旦河东赐给你们作产业的地方去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS22_5","007_22_5","JOS","22","5","5","只是你们要谨慎遵守耶和华的仆人摩西吩咐你们的诫命和律法，爱耶和华你们的　神，遵行他的一切道路，谨守他的诫命，紧紧倚靠他，一心一意事奉他。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS22_6","007_22_6","JOS","22","6","6","于是约书亚给他们祝福，打发他们回去，他们就回自己的家里去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS22_7","007_22_7","JOS","22","7","7","摩西在巴珊已经把产业分给了玛拿西半个支派；至于另外半个支派，约书亚在约旦河西他们的兄弟中间，也把产业分给了他们。约书亚打发他们回家去的时候，给他们祝福， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS22_8","007_22_8","JOS","22","8","8","对他们说：“你们带着许多财物，许多牲畜和金、银、铜、铁，以及许多衣服，回自己的家去吧；也要把你们从仇敌夺得的战利品与你们的兄弟同分。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS22_9","007_22_9","JOS","22","9","9","于是流本人、迦得人和玛拿西半个支派的人，从迦南地的示罗起程，离开以色列人，回到他们所得的产业基列地去，就是照着耶和华借着摩西所吩咐，赐给他们的产业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS22_10","007_22_10","JOS","22","10","10","流本人、迦得人和玛拿西半个支派的人，来到迦南地靠近约旦河的地区，就在约旦河边那里筑了一座祭坛，那坛十分壮观。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS22_11","007_22_11","JOS","22","11","11","以色列人听见了这事，就说：“看哪，流本人、迦得人和玛拿西半个支派的人，在迦南地边境，靠近约旦河的地区，以色列人境内，筑了一座坛。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS22_12","007_22_12","JOS","22","12","12","以色列人听见了这事，以色列全体会众就聚集在示罗，要上去讨伐他们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS22_13","007_22_13","JOS","22","13","13","以色列人派以利亚撒祭司的儿子非尼哈，到基列地去见流本人、迦得人和玛拿西半个支派的人； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS22_14","007_22_14","JOS","22","14","14","又派十个首领与非尼哈同去，每一个都代表以色列的支派家族；他们是全体以色列各家族的领袖。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS22_15","007_22_15","JOS","22","15","15","他们去到基列地，流本人、迦得人和玛拿西半个支派的人那里，对他们说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS22_16","007_22_16","JOS","22","16","16","“耶和华的全体会众这样说：‘你们作的是什么事？竟对以色列的　神不忠，今日转离不跟从耶和华，为自己筑了一座坛，背叛了耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS22_17","007_22_17","JOS","22","17","17","从前拜毗珥的罪孽，我们还以为是小事吗？虽然有灾疫临到耶和华的会众，直到今日我们还没有洗净这罪呢。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS22_18","007_22_18","JOS","22","18","18","你们今日竟转离不跟从耶和华吗？今日你们既然背叛耶和华，明日他必向以色列全体会众发怒了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS22_19","007_22_19","JOS","22","19","19","如果你们认为所得的地业不洁净，你们可以过到耶和华的地业，就是耶和华的帐幕居住的地方，在我们中间得地业；只是不可背叛耶和华，也不可背叛我们，在耶和华我们的　神的坛以外，为自己筑另一座坛。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS22_20","007_22_20","JOS","22","20","20","从前谢拉的曾孙亚干，不是在当毁灭的物上犯了不忠的罪，以致　神的忿怒临到以色列全体会众吗？因他的罪孽而死的，还不只他一人呢！’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS22_21","007_22_21","JOS","22","21","21","于是流本人、迦得人和玛拿西半个支派的人回答以色列的统领说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS22_22","007_22_22","JOS","22","22","22","“大能者　神耶和华！大能者　神耶和华，他是知道的，愿以色列也知道；如果我们存心背叛，或是对耶和华不忠，今日就不要放过我们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS22_23","007_22_23","JOS","22","23","23","我们若是为自己筑坛，转离不跟从耶和华，或是把燔祭、素祭和平安祭献在坛上，愿耶和华亲自追究我们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS22_24","007_22_24","JOS","22","24","24","我们作这事，实在是有理由的，因为顾虑将来你们的子孙对我们的子孙说：‘你们与耶和华以色列的　神有什么关系呢？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS22_25","007_22_25","JOS","22","25","25","流本人和迦得人啊，耶和华定了约旦河作我们和你们中间的疆界；你们与耶和华无分了。’这样，你们的子孙就使我们的子孙不再敬畏耶和华了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS22_26","007_22_26","JOS","22","26","26","“因此我们说：‘我们筑一座坛吧，不是为了献燔祭，也不是为了献别的祭， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS22_27","007_22_27","JOS","22","27","27","而是为了在你们和我们中间，也在我们的后代中间作证据，使我们也可以在耶和华面前用燔祭、别的祭和平安祭事奉耶和华，免得你们的子孙将来对我们的子孙说：你们与耶和华无分了。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS22_28","007_22_28","JOS","22","28","28","因此我们说：‘将来有人对我们，或是对我们的后代这样说，我们就可以回答：你们看我们列祖所筑的坛，是耶和华的祭坛的模式，这并不是用来献燔祭，也不是用来献别的祭，而是在我们和你们中间作证据。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS22_29","007_22_29","JOS","22","29","29","我们决没有背叛耶和华的意思，今日要转离不跟从耶和华，在耶和华我们的　神的帐幕前的祭坛以外，另筑一座坛，为了献燔祭、素祭和别的祭。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS22_30","007_22_30","JOS","22","30","30","非尼哈祭司和会众的领袖，以及与祭司同来的以色列的统领，听了流本人、迦得人和玛拿西人说的话，都很满意。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS22_31","007_22_31","JOS","22","31","31","以利亚撒祭司的儿子非尼哈对流本人、迦得人和玛拿西人说：“今天我们知道耶和华是在我们中间的，因为你们并没有对耶和华不忠；现在你们已经救了以色列人脱离耶和华的手。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS22_32","007_22_32","JOS","22","32","32","以利亚撒祭司的儿子非尼哈和众领袖离开了流本人和迦得人，从基列地回到迦南地以色列人那里，把这事向他们报告。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS22_33","007_22_33","JOS","22","33","33","以色列人对这事都很满意，就称颂　神，不再说要上去讨伐流本人和迦得人，毁灭他们所住的地方了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS22_34","007_22_34","JOS","22","34","34","流本人和迦得人给那坛起名叫证坛，因为他们说：“这坛在我们中间证明耶和华是　神。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS23_1","007_23_1","JOS","23","1","1","耶和华使以色列人得享平安，不受四围仇敌的骚扰，已经有一段很长的日子；约书亚已经老了，年纪不小了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS23_2","007_23_2","JOS","23","2","2","约书亚就把全体以色列人、他们的长老、首领、审判官和官长，都召了来，对他们说：“我已经老了，年纪不小了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS23_3","007_23_3","JOS","23","3","3","耶和华你们的　神，因你们的缘故，向那些国家所行的一切事，你们都亲眼看见了；因为耶和华你们的　神为你们作战。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS23_4","007_23_4","JOS","23","4","4","你们看，剩下来的这些国家，连同我剪除的列国，从约旦河起，直到日落之处的大海，我都按着你们各支派，用抽签的方式，分给你们作产业了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS23_5","007_23_5","JOS","23","5","5","耶和华你们的　神必把他们从你们面前赶出去，驱逐他们离开你们，你们就必得着他们的地作产业，正如耶和华你们的　神所应许的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS23_6","007_23_6","JOS","23","6","6","所以你们要十分坚强，谨守遵行写在摩西律法书上的一切话，使你们不偏向左，不偏向右； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS23_7","007_23_7","JOS","23","7","7","使你们不与你们中间剩下的这些国家的人来往；他们的神的名字，你们不可提，不可指着他们起誓，不可事奉他们，也不可敬拜他们； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS23_8","007_23_8","JOS","23","8","8","只要照着你们一直以来所行的，紧紧倚靠耶和华你们的　神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS23_9","007_23_9","JOS","23","9","9","因为耶和华已经把又大又强的列国从你们面前赶出去；至于你们，直到今日，还没有一人能在你们面前站立得住。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS23_10","007_23_10","JOS","23","10","10","你们一人可以追赶千人，因为耶和华你们的　神，照着他应许你们的，为你们作战。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS23_11","007_23_11","JOS","23","11","11","你们自己要十分谨慎，爱耶和华你们的　神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS23_12","007_23_12","JOS","23","12","12","如果你们转离耶和华，与你们中间剩下的这些国家的余民联络，和他们通婚，互相来往， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS23_13","007_23_13","JOS","23","13","13","你们就必知道，耶和华你们的　神必不再把这些国家从你们面前赶出去；他们必要成为你们的网罗和陷阱，肋下的鞭和眼中的刺，直到你们从耶和华你们的　神赐给你们的这美地上灭亡为止。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS23_14","007_23_14","JOS","23","14","14","“看哪，我今天要走世人必经的路了。你们清清楚楚（“清清楚楚”原文作“一心一意”）知道耶和华你们的　神应许赐福给你们的话，没有一句落空；完全应验在你们身上，没有一句落空。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS23_15","007_23_15","JOS","23","15","15","耶和华你们的　神应许你们的一切福气怎样临到你们身上，耶和华也必照样使各样的灾祸临到你们身上，直到把你们从耶和华你们的　神赐给你们的这美地上消灭为止。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS23_16","007_23_16","JOS","23","16","16","如果你们违背了耶和华你们的　神吩咐你们遵守的约，去事奉别的神，敬拜他们，耶和华必向你们大发烈怒，使你们从他赐给你们的美地上迅速灭亡。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS24_1","007_24_1","JOS","24","1","1","约书亚在示剑召集以色列各支派，又把以色列的长老、首领、审判官和官长都召了来，他们就站在　神面前。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS24_2","007_24_2","JOS","24","2","2","约书亚对众民说：“耶和华以色列的　神这样说：‘古时你们的列祖，就是亚伯拉罕和拿鹤的父亲他拉，住在大河那边；他们事奉别的神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS24_3","007_24_3","JOS","24","3","3","我把你们的祖先亚伯拉罕，从大河那边带来，领他走遍迦南地，使他的后裔增多，把以撒赐给他； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS24_4","007_24_4","JOS","24","4","4","又把雅各和以扫赐给以撒，把西珥山赐给以扫作产业；雅各和他的子孙却下到埃及去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS24_5","007_24_5","JOS","24","5","5","我差派了摩西和亚伦，借着我在埃及所行的神迹，用灾疫击打埃及，然后把你们领出来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS24_6","007_24_6","JOS","24","6","6","我领你们的列祖离开埃及，他们去到海边；埃及人带着战车和马兵，追赶你们的列祖直到红海。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS24_7","007_24_7","JOS","24","7","7","你们的列祖呼求耶和华，他就以黑暗隔开你们和埃及人，又使海水复流淹没了他们；我在埃及所行的事，你们都亲眼见过；你们在旷野也住了许多日子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS24_8","007_24_8","JOS","24","8","8","我领你们到了住在约旦河东的亚摩利人的地，他们和你们争战，我把他们交在你们手里，你们就得了他们的地作产业；我也在你们面前把他们消灭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS24_9","007_24_9","JOS","24","9","9","那时摩押王西拨的儿子巴勒起来攻击以色列人；他派人把比珥的儿子巴兰召了来，咒诅你们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS24_10","007_24_10","JOS","24","10","10","我不肯听巴兰的话，结果他反而一而再祝福你们；这样，我就救了你们脱离他的手。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS24_11","007_24_11","JOS","24","11","11","你们过了约旦河，来到耶利哥；耶利哥的居民与你们作战，还有亚摩利人、比利洗人、迦南人、赫人、革迦撒人、希未人、耶布斯人，也跟你们作战；我把他们都交在你们手里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS24_12","007_24_12","JOS","24","12","12","我派了黄蜂飞在你们前面，把亚摩利人的两个王从你们面前赶走，并不是用你的刀，也不是用你的弓。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS24_13","007_24_13","JOS","24","13","13","我赐给你们的土地，不是你们劳苦开垦的；我赐给你们的城市，不是你们建造的，你们却住在城中；你们享用的葡萄园和橄榄园，也不是你们栽种的。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS24_14","007_24_14","JOS","24","14","14","“现在你们要敬畏耶和华，真诚地按着真理事奉他，把你们列祖在大河那边和在埃及事奉的神除掉，去事奉耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS24_15","007_24_15","JOS","24","15","15","如果你们认为事奉耶和华不好，那么今日你们就可以选择你们所要事奉的：是你们列祖在大河那边事奉的神呢，还是你们现在所住亚摩利人之地的神呢？至于我和父家，我们必事奉耶和华。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS24_16","007_24_16","JOS","24","16","16","众民回答：“我们绝对不会离弃耶和华，去事奉别的神； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS24_17","007_24_17","JOS","24","17","17","因为耶和华我们的　神把我们和我们的列祖，从埃及地为奴的家领出来，并且在我们眼前行了那些伟大的神迹；又在我们所行的一切路上，和我们经过的一切民族中间，他都保护了我们； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS24_18","007_24_18","JOS","24","18","18","耶和华又把所有的民族和住在这地的亚摩利人，都从我们面前赶走；所以我们必事奉耶和华，因为他是我们的　神。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS24_19","007_24_19","JOS","24","19","19","约书亚对众民说：“你们不能事奉耶和华，因为他是圣洁的　神；他是嫉妒的　神，他必不赦免你们的过犯和罪恶。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS24_20","007_24_20","JOS","24","20","20","如果你们离弃耶和华，去事奉外族人的神，那么在耶和华赐福给你们之后，他必转而降祸与你们，把你们消灭。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS24_21","007_24_21","JOS","24","21","21","众民对约书亚说：“不，我们必定事奉耶和华。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS24_22","007_24_22","JOS","24","22","22","约书亚对众民说：“你们选择了耶和华，要事奉他，你们为自己作证吧。”他们说：“我们愿意作证。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS24_23","007_24_23","JOS","24","23","23","约书亚说：“现在你们要除掉在你们中间外族人的神，一心归向耶和华以色列的　神。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS24_24","007_24_24","JOS","24","24","24","众民对约书亚说：“我们必事奉耶和华我们的　神，必听从他的话。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS24_25","007_24_25","JOS","24","25","25","那一天，约书亚就与众民立约，在示剑为他们订立律例和典章。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS24_26","007_24_26","JOS","24","26","26","约书亚把这些话都写在　神的律法书上；又拿一块大石头，立在耶和华圣所旁边的橡树下。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS24_27","007_24_27","JOS","24","27","27","约书亚对全体人民说：“看哪，这块石头可以向我们作证，因为它听见了耶和华对我们所说的一切话；所以这块石头要向你们作证，免得你们否认你们的　神。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS24_28","007_24_28","JOS","24","28","28","于是约书亚打发众民各自回到自己的地业去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS24_29","007_24_29","JOS","24","29","29","这些事以后，耶和华的仆人、嫩的儿子约书亚死了，那时他是一百一十岁。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS24_30","007_24_30","JOS","24","30","30","以色列人把他埋葬在他自己地业的境内，就是在以法莲山地上的亭拿．西拉，在迦实山的北边。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS24_31","007_24_31","JOS","24","31","31","约书亚在世的日子，和约书亚死后，那些知道耶和华为以色列人所行的一切事的长老还在世的日子，以色列人都事奉耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS24_32","007_24_32","JOS","24","32","32","以色列人从埃及带出来的约瑟骸骨，葬在示剑的一块田里；这块田是雅各从前用一百块银子向示剑的父亲哈抹的子孙那里买来的；这块田就成了约瑟子孙的产业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JS24_33","007_24_33","JOS","24","33","33","亚伦的儿子以利亚撒也死了；以色列人就把他埋葬在基比亚，就是他儿子非尼哈在以法莲山地所得的产业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG1_1","008_1_1","JDG","1","1","1","约书亚死后，以色列人求问耶和华说：“谁要为我们首先去攻打迦南人，与他们作战呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG1_2","008_1_2","JDG","1","2","2","耶和华回答：“犹大要先上去，看哪，我已经把那地交在他手中。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG1_3","008_1_3","JDG","1","3","3","犹大对自己的兄弟西缅说：“请你与我一同上我抽签所得的地业去，我们好与迦南人交战；以后我也与你一同到你抽签所得的地业去。”于是西缅与他一同去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG1_4","008_1_4","JDG","1","4","4","犹大上去了；耶和华就把迦南人和比利洗人交在他们手中；他们在比色击杀了一万人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG1_5","008_1_5","JDG","1","5","5","他们在那里遇见了比色王，就与他交战，击杀了迦南人和比利洗人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG1_6","008_1_6","JDG","1","6","6","比色王逃跑；他们追赶他，把他捉住，砍去了他手脚的大拇指。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG1_7","008_1_7","JDG","1","7","7","比色王说：“从前有七十个王，手脚的大拇指都被我砍去，在我的桌子底下拾取食物；现在　神照着我所行的，报应我了。”于是他们把他带到耶路撒冷，后来他就死在那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG1_8","008_1_8","JDG","1","8","8","犹大人攻打耶路撒冷，把城占领，用刀击杀了城中的居民，又放火烧城。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG1_9","008_1_9","JDG","1","9","9","后来，犹大人下去，与住在山地、南地和高原的迦南人交战。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG1_10","008_1_10","JDG","1","10","10","犹大人又去攻击住在希伯仑的迦南人，杀了示筛、亚希幔和挞买；希伯仑从前名叫基列．亚巴。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG1_11","008_1_11","JDG","1","11","11","他们从那里又去攻击底璧的居民；底璧从前名叫基列．西弗。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG1_12","008_1_12","JDG","1","12","12","迦勒说：“谁能攻打基列．西弗，把城攻取，我就把我的女儿押撒给他作妻子。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG1_13","008_1_13","JDG","1","13","13","迦勒的弟弟基纳斯的儿子俄陀聂攻取了那城，迦勒就把自己的女儿押撒给他作妻子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG1_14","008_1_14","JDG","1","14","14","押撒出嫁的时候，她劝俄陀聂向她父亲求一块田；押撒一下驴，迦勒就对她说：“你要什么？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG1_15","008_1_15","JDG","1","15","15","她回答：“请你给我一份礼物；你既然把我安置在南地，求你也把水泉赐给我。”迦勒就把上泉和下泉都给了她。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG1_16","008_1_16","JDG","1","16","16","摩西岳父的子孙基尼人，和犹大人一同离开棕树城，上到亚拉得以南的犹大旷野去，住在那里的人民中。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG1_17","008_1_17","JDG","1","17","17","犹大与他的兄弟西缅同去，击杀了住在洗法的迦南人，把那城完全毁灭。那城的名字就叫何珥玛。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG1_18","008_1_18","JDG","1","18","18","犹大又攻取了迦萨和迦萨的四境，亚实基伦和亚实基伦的四境，以革伦和以革伦的四境。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG1_19","008_1_19","JDG","1","19","19","耶和华与犹大同在，犹大就占领了山地；但不能赶走平原的居民，因为他们有铁车。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG1_20","008_1_20","JDG","1","20","20","犹大照着摩西的吩咐，把希伯仑给了迦勒；迦勒就从那里赶走亚衲子孙的三族。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG1_21","008_1_21","JDG","1","21","21","便雅悯人没有赶走住在耶路撒冷的耶布斯人，所以耶布斯人与便雅悯人一同住在耶路撒冷，直到今日。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG1_22","008_1_22","JDG","1","22","22","约瑟家也上去攻打伯特利；耶和华与他们同在。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG1_23","008_1_23","JDG","1","23","23","约瑟家派人去窥探伯特利。那城从前的名字叫路斯。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG1_24","008_1_24","JDG","1","24","24","窥探的人看见一个人从城里出来，就对他说：“请你把进城的路指示我们，我们必恩待你。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG1_25","008_1_25","JDG","1","25","25","那人把进城的路指示了他们，他们就用刀击杀了那城的居民，却把那人和他的全家都放走。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG1_26","008_1_26","JDG","1","26","26","那人到赫人之地去了，筑了一座城，给它起名叫路斯；直到今日那城还叫这名。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG1_27","008_1_27","JDG","1","27","27","玛拿西没有赶走伯．善和属于伯．善的乡村的居民，他纳和属于他纳的乡村的居民，多珥和属于多珥的乡村的居民，以伯莲和属于以伯莲的乡村的居民，米吉多和属于米吉多的乡村的居民；迦南人决意住在那地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG1_28","008_1_28","JDG","1","28","28","到以色列强盛了，就迫使迦南人作苦工，但没有把他们完全赶走。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG1_29","008_1_29","JDG","1","29","29","以法莲也没有把住在基色的迦南人赶走，于是迦南人还住在基色，在以法莲中间。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG1_30","008_1_30","JDG","1","30","30","西布伦没有把基伦的居民和拿哈拉的居民赶走；于是迦南人还住在西布伦中间，成了作苦工的人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG1_31","008_1_31","JDG","1","31","31","亚设没有把亚柯的居民和西顿的居民赶走，也没有把亚黑拉、亚革悉、黑巴、亚弗革和利合的居民赶走。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG1_32","008_1_32","JDG","1","32","32","于是亚设人住在当地的居民迦南人中间，因为他们没有把他们赶走。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG1_33","008_1_33","JDG","1","33","33","拿弗他利没有把伯．示麦的居民和伯．亚纳的居民赶走；于是他们就住在当地的居民迦南人中间；伯．示麦和伯．亚纳的居民成了给他们作苦工的人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG1_34","008_1_34","JDG","1","34","34","亚摩利人强迫但人退回山地上，不容他们下到平原来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG1_35","008_1_35","JDG","1","35","35","亚摩利人决意住在希烈山、亚雅伦和沙宾；但约瑟家的势力强大以后，他们就成了作苦工的人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG1_36","008_1_36","JDG","1","36","36","亚摩利人的境界，是从亚克拉滨山坡，从西拉直上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG2_1","008_2_1","JDG","2","1","1","耶和华的使者从吉甲上到波金来，说：“我曾经把你们从埃及领上来，带你们到我向你们列祖起誓应许的地方；我曾说过：‘我永不废弃我与你们所立的约； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG2_2","008_2_2","JDG","2","2","2","你们不可与这地的居民立约，要拆毁他们的祭坛。’你们竟没有听从我的话；你们作的是什么呢？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG2_3","008_2_3","JDG","2","3","3","因此我又说：‘我必不把他们从你们面前赶走，他们要作你们的敌人，他们的神要作你们的网罗。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG2_4","008_2_4","JDG","2","4","4","耶和华的使者对以色列众人说这些话的时候，众人就放声大哭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG2_5","008_2_5","JDG","2","5","5","于是给那地方起名叫波金；他们在那里向耶和华献祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG2_6","008_2_6","JDG","2","6","6","约书亚遣散了众人，以色列人就各归自己承受的地业，要占有那地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG2_7","008_2_7","JDG","2","7","7","约书亚在世的时候，以及他去世以后，那些见过耶和华为以色列人所行的大事的众长老还在的日子，众人都事奉耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG2_8","008_2_8","JDG","2","8","8","耶和华的仆人，嫩的儿子约书亚，在一百一十岁的时候就死了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG2_9","008_2_9","JDG","2","9","9","以色列人把他埋葬在他地业的境内，就是以法莲山地，在迦实山北面的亭拿．希烈。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG2_10","008_2_10","JDG","2","10","10","那一代的人都归到他们的列祖那里以后，有另一代的人兴起来了；他们不认识耶和华，也不知道耶和华为以色列人所行的事。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG2_11","008_2_11","JDG","2","11","11","以色列人行了耶和华看为恶的事，去事奉众巴力； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG2_12","008_2_12","JDG","2","12","12","他们离弃了领他们出埃及的耶和华、他们列祖的　神，去跟从别的神，就是他们周围各族的神，敬拜他们，惹耶和华发怒。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG2_13","008_2_13","JDG","2","13","13","他们离弃了耶和华，去事奉巴力和亚斯他录。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG2_14","008_2_14","JDG","2","14","14","耶和华的怒气向以色列人发作，就把他们交在抢掠的人手中，他们就抢掠他们；他又把他们完全交在他们四围的仇敌手中，以致他们在仇敌面前再不能站立得住。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG2_15","008_2_15","JDG","2","15","15","他们无论去哪里，耶和华的手总是加害他们，好像耶和华说过的，又像耶和华对他们起誓过的；他们就非常困苦。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG2_16","008_2_16","JDG","2","16","16","耶和华兴起了士师，士师就拯救他们脱离抢掠他们的人的手。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG2_17","008_2_17","JDG","2","17","17","但他们连士师也不听从，竟与别的神行了奸淫，敬拜他们；他们迅速偏离了他们列祖所行、听从耶和华命令的道路，他们没有照样行。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG2_18","008_2_18","JDG","2","18","18","耶和华为他们兴起士师的时候，耶和华就与那士师同在；那士师在世的日子，耶和华总是拯救他们脱离仇敌的手；因为他们在压迫和苦害他们的人底下发出哀声，耶和华就怜悯他们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG2_19","008_2_19","JDG","2","19","19","可是士师死了以后，他们就转而行恶，比他们的列祖更厉害，去随从别的神，事奉和敬拜他们，总不放弃他们的恶行和顽梗的行径。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG2_20","008_2_20","JDG","2","20","20","于是耶和华的怒气向以色列人发作，说：“因为这国的人违背我吩咐他们列祖的约，不听从我的话， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG2_21","008_2_21","JDG","2","21","21","因此，约书亚死后仍剩下来的列国，我也不再从他们面前赶走， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG2_22","008_2_22","JDG","2","22","22","为要借着他们试验以色列人，看他们肯不肯谨守遵行耶和华的道路，像他们的列祖一样谨守。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG2_23","008_2_23","JDG","2","23","23","这样，耶和华留下这些国的民，不迅速把他们赶走，也不把他们交在约书亚手里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG3_1","008_3_1","JDG","3","1","1","这些国的人是耶和华留下的，为要借着他们来试验以色列人，就是所有没有经验过迦南任何战争的人； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG3_2","008_3_2","JDG","3","2","2","好使以色列人的后代，那些以前没有经验过这些战争的人，知道学习争战。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG3_3","008_3_3","JDG","3","3","3","他留下的就是非利士人的五个首领，和所有迦南人、西顿人，以及住在黎巴嫩山上的希未人，从巴力．黑门山直到哈马口。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG3_4","008_3_4","JDG","3","4","4","他们留在那里，为要借着他们试验以色列人，要知道他们是否听从耶和华借摩西吩咐他们列祖的诫命。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG3_5","008_3_5","JDG","3","5","5","以色列人就住在迦南人、赫人、亚摩利人、比利洗人、希未人、耶布斯人中间； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG3_6","008_3_6","JDG","3","6","6","他们娶他们的女儿作妻子，也把自己的女儿嫁给他们的儿子，并且事奉他们的神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG3_7","008_3_7","JDG","3","7","7","以色列人行了耶和华看为恶的事，忘记了耶和华他们的　神，去事奉众巴力和亚舍拉。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG3_8","008_3_8","JDG","3","8","8","因此，耶和华的怒气向以色列人发作，把他们完全交在两河之间的亚兰王古珊．利萨田的手中；以色列人服事了古珊．利萨田八年。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG3_9","008_3_9","JDG","3","9","9","以色列人向耶和华哀求的时候，耶和华就为以色列人兴起一位拯救者拯救他们，就是迦勒的弟弟基纳斯的儿子俄陀聂。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG3_10","008_3_10","JDG","3","10","10","耶和华的灵临到他身上，他就治理以色列人；他出去作战，耶和华把亚兰王古珊．利萨田交在他手中，他的能力就胜过了古珊．利萨田。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG3_11","008_3_11","JDG","3","11","11","于是国中太平了四十年。后来基纳斯的儿子俄陀聂死了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG3_12","008_3_12","JDG","3","12","12","以色列人又行了耶和华看为恶的事，耶和华就使摩押王伊矶伦强盛起来，欺压以色列人，因为他们行了耶和华看为恶的事。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG3_13","008_3_13","JDG","3","13","13","伊矶伦集合了亚扪人和亚玛力人，前来击败了以色列人，占领了棕树城。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG3_14","008_3_14","JDG","3","14","14","于是以色列人服事了摩押王伊矶伦十八年。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG3_15","008_3_15","JDG","3","15","15","以色列人向耶和华哀求的时候，耶和华就为他们兴起一位拯救者，就是便雅悯人基拉的儿子以笏，是一个用左手的人。以色列人派他把贡物送给摩押王伊矶伦。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG3_16","008_3_16","JDG","3","16","16","以笏做了一把两刃的剑，长半公尺，缚在右腿上，在衣服底下。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG3_17","008_3_17","JDG","3","17","17","他把贡物呈献给摩押王伊矶伦；伊矶伦原是个非常肥胖的人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG3_18","008_3_18","JDG","3","18","18","以笏献完了贡物，就把抬贡物的众人打发走了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG3_19","008_3_19","JDG","3","19","19","自己却从靠近吉甲的众雕像那里回来，说：“王啊，我有一件机密的事要对你说。”王说：“暂不要说。”侍立左右的人都离开他出去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG3_20","008_3_20","JDG","3","20","20","以笏来到王那里；王独自一人坐在凉楼上。以笏说：“我有　神的话要告诉你。”王就从座位上站起来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG3_21","008_3_21","JDG","3","21","21","以笏就伸出左手，从右腿上拔出剑来，刺入王的腹中； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG3_22","008_3_22","JDG","3","22","22","连剑柄与剑身都刺进去了，肥肉把剑身夹住，因此他没有把剑从王的肚腹里拔出来；接着他就从窗户爬了出去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG3_23","008_3_23","JDG","3","23","23","以笏出到走廊，把凉楼上的门关起来，上了锁。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG3_24","008_3_24","JDG","3","24","24","以笏出来以后，王的仆人才来到；他们看见凉楼上的门锁着，就说：“王一定是在凉楼上大解。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG3_25","008_3_25","JDG","3","25","25","他们等到发慌了，见他还不打开凉楼的门，就拿钥匙来开；不料，看见他们的主人早已倒在地上死了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG3_26","008_3_26","JDG","3","26","26","他们耽延的时候，以笏已经逃跑了；他经过众雕像那里，逃到西伊拉去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG3_27","008_3_27","JDG","3","27","27","他去到以后，就在以法莲山地吹角；以色列人与他一同从山地上下来，他走在他们前头， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG3_28","008_3_28","JDG","3","28","28","对他们说：“你们跟随我，因为耶和华已经把你们的仇敌摩押人交在你们手中。”他们就跟随他下去，攻取约旦河的渡口，拦截摩押人，不让一个过去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG3_29","008_3_29","JDG","3","29","29","那时他们击杀了约有一万摩押人，都是强壮的、勇猛的人，没有一人逃脱。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG3_30","008_3_30","JDG","3","30","30","这样，从那天起，摩押就在以色列人的手下被制伏了，于是国中太平了八十年。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG3_31","008_3_31","JDG","3","31","31","以笏之后，有亚拿的儿子珊迦；他用赶牛棒击杀了六百非利士人；他也拯救了以色列人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG4_1","008_4_1","JDG","4","1","1","以笏死后，以色列人又行了耶和华看为恶的事。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG4_2","008_4_2","JDG","4","2","2","因此耶和华把他们交在迦南王耶宾手中，耶宾那时在夏琐作王；他的军长西西拉，住在夏罗设歌印。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG4_3","008_4_3","JDG","4","3","3","耶宾王有铁车九百辆，他极力欺压以色列人二十年，以色列人就哀求耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG4_4","008_4_4","JDG","4","4","4","有一位女先知底波拉，是拉比多的妻子，那时正治理以色列人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG4_5","008_4_5","JDG","4","5","5","她常坐在以法莲山地，拉玛和伯特利之间那棵底波拉棕树下；以色列人都上到她那里去听判断。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG4_6","008_4_6","JDG","4","6","6","底波拉派人去从拿弗他利的基低斯，把亚比挪庵的儿子巴拉召了来，对他说：“耶和华以色列的　神不是曾吩咐你说：‘你去向他泊山进军，从拿弗他利人和西布伦人中率领一万人与你同去吗？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG4_7","008_4_7","JDG","4","7","7","我必引耶宾的军长西西拉，和他的车辆与全军，到基顺河往你那里去；我必把他们交在你手里。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG4_8","008_4_8","JDG","4","8","8","巴拉对她说：“如果你与我同去，我就去；如果你不与我同去，我就不去。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG4_9","008_4_9","JDG","4","9","9","底波拉回答：“我必与你同去，只是你这次行程就没有光荣；因为耶和华要把西西拉交在一个妇人手里。”于是底波拉起来，与巴拉一同到基低斯去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG4_10","008_4_10","JDG","4","10","10","巴拉就召集西布伦人和拿弗他利人到基低斯；与他一同步行上去的有一万人，底波拉也与他一同上去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG4_11","008_4_11","JDG","4","11","11","摩西的岳父何巴的子孙基尼人希伯，曾经离开基尼族人，到靠近基低斯的撒拿音的橡树旁，支搭帐棚居住。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG4_12","008_4_12","JDG","4","12","12","有人告诉西西拉，亚比挪庵的儿子巴拉已经上了他泊山； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG4_13","008_4_13","JDG","4","13","13","西西拉就召集他所有的车辆，就是九百辆铁车，和与他在一起的众人，都从夏罗设歌印出来，到基顺河那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG4_14","008_4_14","JDG","4","14","14","底波拉对巴拉说：“你起来吧，因为今日就是耶和华把西西拉交在你手里的日子；耶和华不是在你前面出战吗？”于是巴拉和跟随他的一万人从他泊山下来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG4_15","008_4_15","JDG","4","15","15","耶和华用刀使西西拉和所有的车辆与全军，都在巴拉面前溃乱；西西拉下了车，步行逃跑。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG4_16","008_4_16","JDG","4","16","16","巴拉追赶西西拉的车辆和军队，直到夏罗设歌印；西西拉的全军都倒在刀下，连一个也没有留下。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG4_17","008_4_17","JDG","4","17","17","只有西西拉步行逃跑，到了基尼人希伯的妻子雅亿的帐棚那里；因为夏琐王耶宾与基尼人希伯的家友好。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG4_18","008_4_18","JDG","4","18","18","雅亿出来迎接西西拉，对他说：“请我主转过来，到我这里，不要惧怕。”西西拉就转到她那里去，就是转到她的帐棚里去；雅亿就用毛毡遮盖他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG4_19","008_4_19","JDG","4","19","19","西西拉对雅亿说：“请给我一点水喝，因为我渴了。”雅亿就打开盛奶的皮袋，给他喝了，再把他盖着。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG4_20","008_4_20","JDG","4","20","20","西西拉又对雅亿说：“请你站在帐棚门口，如果有人来问你：‘这里有人吗？’你就要回答：‘没有。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG4_21","008_4_21","JDG","4","21","21","希伯的妻子雅亿取了一根帐棚的橛子，手里拿着锤子，静悄悄地走到西西拉那里，把橛子钉在他的太阳穴里，直钉入地里；因为西西拉疲乏熟睡，就这样死了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG4_22","008_4_22","JDG","4","22","22","那时，巴拉追赶西西拉，雅亿出来迎接他，对他说：“来吧，我给你看你寻找的人。”他就进到她那里去；看见西西拉已经仆倒，死了；橛子还在他的太阳穴里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG4_23","008_4_23","JDG","4","23","23","这样，　神就在那一天，在以色列人面前，制伏了迦南王耶宾。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG4_24","008_4_24","JDG","4","24","24","以色列人的势力日渐强盛，胜过迦南王耶宾，终于把迦南王耶宾除灭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG5_1","008_5_1","JDG","5","1","1","那一天，底波拉和亚比挪庵的儿子巴拉唱起歌来说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG5_2","008_5_2","JDG","5","2","2","“你们要称颂耶和华，因为以色列中有勇士，因为有人民自愿从军。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG5_3","008_5_3","JDG","5","3","3","君王啊，你们要听；官长啊，你们要侧耳倾听；至于我，我要向耶和华歌唱；我要歌颂耶和华以色列的　神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG5_4","008_5_4","JDG","5","4","4","耶和华啊，你从西珥出发的时候，你从以东地行走的日子，地震天漏，密云也滴下雨。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG5_5","008_5_5","JDG","5","5","5","群山在耶和华面前震动；这西奈山在耶和华以色列的　神面前也是这样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG5_6","008_5_6","JDG","5","6","6","在亚拿的儿子珊迦的时候，在雅亿的日子，大道无人行走，行路的人绕道而行。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG5_7","008_5_7","JDG","5","7","7","以色列中的农村消失了，消失了，直到我底波拉兴起，直到我以色列的母亲兴起。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG5_8","008_5_8","JDG","5","8","8","以色列人选择了新的神，战争就临近城门；那时四万以色列人中，竟不见有一面盾牌、一枝长矛。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG5_9","008_5_9","JDG","5","9","9","我的心倾向以色列的官长，他们在民中甘愿牺牲自己；你们要称颂耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG5_10","008_5_10","JDG","5","10","10","骑白驴的，坐锦垫的，和路上的行人，你们都要歌唱。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG5_11","008_5_11","JDG","5","11","11","在打水的地方分开羊群的人发声，在那里人必歌颂耶和华公义的作为，就是他在以色列中的农村所行公义的作为；那时，耶和华的子民下到城门口。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG5_12","008_5_12","JDG","5","12","12","兴起，兴起，底波拉！兴起，兴起，唱歌吧！兴起，巴拉！亚比挪庵的儿子，掳掠你的俘虏吧！ ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG5_13","008_5_13","JDG","5","13","13","那时余剩的贵胄下来；耶和华带着勇士下到我这里来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG5_14","008_5_14","JDG","5","14","14","他们出自以法莲，他们的根在亚玛力人之地；有便雅悯在你的族人中跟随你，有官长从玛吉下来；有持着数点民数之权杖的，从西布伦出来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG5_15","008_5_15","JDG","5","15","15","以萨迦的领袖与底波拉在一起；以萨迦怎样，巴拉也怎样；他们都步行下到山谷去。在流本的众溪旁，有心怀大志的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG5_16","008_5_16","JDG","5","16","16","你为什么坐在羊圈之中，听呼唤群畜的笛声呢？在流本的众溪旁，有心怀大志的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG5_17","008_5_17","JDG","5","17","17","基列人在约旦河东边居住；但人为什么居留在船上呢？亚设人在海岸坐着，在港湾居住。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG5_18","008_5_18","JDG","5","18","18","西布伦人是敢死的民族；拿弗他利人在田野的高处，奋不顾身。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG5_19","008_5_19","JDG","5","19","19","众王都来争战；那时迦南众王争战，在米吉多水亭的他纳争战，却没有取得银钱。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG5_20","008_5_20","JDG","5","20","20","众星从天上争战，从它们的轨道与西西拉交战。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG5_21","008_5_21","JDG","5","21","21","基顺河的急流把他们冲没，古河的急流、基顺河的急流，我的心哪，你要努力践踏。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG5_22","008_5_22","JDG","5","22","22","那时马蹄沓沓，勇士急奔飞驰。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG5_23","008_5_23","JDG","5","23","23","耶和华的使者说：‘你们要咒诅米罗斯，大大咒诅其中的居民；因为他们不来帮助耶和华，不带领勇士帮助耶和华。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG5_24","008_5_24","JDG","5","24","24","愿基尼人希伯的妻子雅亿，比众妇女更有福气，比住在帐棚的妇女更有福气。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG5_25","008_5_25","JDG","5","25","25","西西拉求水，雅亿给了奶；用珍贵的盘子奉上乳酪。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG5_26","008_5_26","JDG","5","26","26","她伸手拿着帐棚的橛子，右手拿着匠人的锤子，击打西西拉，打破他的头，粉碎他的头颅，贯穿他的鬓角。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG5_27","008_5_27","JDG","5","27","27","西西拉在雅亿脚前屈身、仆倒、躺卧，在雅亿脚前屈身、仆倒；他在那里屈身，就在那里仆倒死亡。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG5_28","008_5_28","JDG","5","28","28","西西拉的母亲从窗户里向外观望，从窗棂中呼叫说：‘他的战车为什么迟迟不来呢？车轮为什么行得缓慢呢？’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG5_29","008_5_29","JDG","5","29","29","聪明的宫女回答她；她也自己回答说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG5_30","008_5_30","JDG","5","30","30","‘莫非他们正在分战利品？每个勇士分得一两个女子；西西拉得了彩衣作战利品，得了一两件绣花的彩衣作战利品，为我的颈项，得着绣花的彩衣作战利品吗？’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG5_31","008_5_31","JDG","5","31","31","耶和华啊，愿你所有的仇敌都这样灭亡；愿爱他的人像太阳出现，大有能力。”于是国中太平了四十年。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG6_1","008_6_1","JDG","6","1","1","以色列人又行了耶和华看为恶的事；耶和华就把他们交在米甸人手里七年。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG6_2","008_6_2","JDG","6","2","2","米甸人的势力胜过以色列人；以色列人因米甸人的缘故，就为自己在山上挖穴、挖洞，建营寨。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG6_3","008_6_3","JDG","6","3","3","每逢以色列人撒种以后，米甸人、亚玛力人和东方人都上来，欺压他们； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG6_4","008_6_4","JDG","6","4","4","对着他们安营，毁坏那地的出产，直到迦萨一带，他们没有留下牛、羊和驴，没有给以色列人留下一点养生之物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG6_5","008_6_5","JDG","6","5","5","因为他们带着牲畜和帐棚上来，像蝗虫那么多；他们来的人和骆驼无数，进入境内，毁坏全地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG6_6","008_6_6","JDG","6","6","6","以色列人在米甸人面前，落到极卑微的地步，他们就哀求耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG6_7","008_6_7","JDG","6","7","7","以色列人因米甸人的缘故，向耶和华呼求的时候， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG6_8","008_6_8","JDG","6","8","8","耶和华就差派一位先知到以色列人那里，对他们说：“耶和华以色列的　神这样说：‘我曾经把你们从埃及领上来，领你们出了为奴之家； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG6_9","008_6_9","JDG","6","9","9","我曾经把你们从埃及人的手拯救出来，拯救你们脱离所有欺压你们的人的手，把他们从你们面前赶走，把他们的地赐给你们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG6_10","008_6_10","JDG","6","10","10","我又对你们说：我是耶和华你们的　神；你们住在亚摩利人的地，不可敬畏他们的神。但你们没有听从我的话。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG6_11","008_6_11","JDG","6","11","11","耶和华的使者来到，坐在俄弗拉，一棵属于亚比以谢族人约阿施的橡树下；约阿施的儿子基甸正在压酒池里打麦子，为要躲避米甸人的抢夺。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG6_12","008_6_12","JDG","6","12","12","耶和华的使者向基甸显现，对他说：“大能的勇士啊，耶和华与你同在。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG6_13","008_6_13","JDG","6","13","13","基甸回答他，说：“唉，我的主，如果耶和华与我们同在，我们怎会遭遇这一切事呢？我们的列祖向我们讲述的，耶和华的一切奇事在哪里呢？他们曾说：‘耶和华不是把我们从埃及领上来吗？’现在他却拋弃了我们，把我们交在米甸人手中！” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG6_14","008_6_14","JDG","6","14","14","耶和华转向基甸，对他说：“你靠着你这能力，去拯救以色列人脱离米甸人的手吧；我不是差派了你吗？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG6_15","008_6_15","JDG","6","15","15","基甸对他说：“唉，我主啊，我凭着什么拯救以色列人呢？看哪，我的家族在玛拿西支派中是最卑微的，我在我的父家是最年轻的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG6_16","008_6_16","JDG","6","16","16","耶和华对他说：“因为我必与你同在，你就必击打米甸人，像击打一人一样。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG6_17","008_6_17","JDG","6","17","17","基甸又对他说：“如果我在你眼前蒙恩，求你给我一个凭据，证实是你与我说话。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG6_18","008_6_18","JDG","6","18","18","求你不要离开这里，等我回来，把我的礼物带来，摆在你面前。”他回答：“我必等你回来。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG6_19","008_6_19","JDG","6","19","19","基甸去预备了一只山羊羔，和十公斤面粉做的无酵饼，把肉放在篮子里，把汤盛在锅中，带到橡树之下，献上给他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG6_20","008_6_20","JDG","6","20","20","神的使者对基甸说：“把肉和无酵饼拿出来，摆在这块磐石上，把汤倒出来。”他就这样行了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG6_21","008_6_21","JDG","6","21","21","耶和华的使者伸出手中的杖，杖头一触着肉和无酵饼，就有火从磐石中上来，把肉和无酵饼都烧尽了；耶和华的使者就从基甸的眼前消失了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG6_22","008_6_22","JDG","6","22","22","基甸看出他是耶和华的使者，就说：“哀哉，我主耶和华啊，因为我面对面看见了耶和华的使者。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG6_23","008_6_23","JDG","6","23","23","耶和华对他说：“你放心好了，不要怕，你必不会死。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG6_24","008_6_24","JDG","6","24","24","基甸就在那里给耶和华筑了一座祭坛，称为耶和华沙龙；直到今日，这坛还在亚比以谢族的俄弗拉。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG6_25","008_6_25","JDG","6","25","25","当夜，耶和华对基甸说：“取你父亲的牛和另一头七岁大的牛来，拆毁你父亲的巴力祭坛，砍下坛旁的亚舍拉。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG6_26","008_6_26","JDG","6","26","26","在这坚固的地方上面，你要整整齐齐为耶和华你的　神筑一座祭坛，拿第二头牛作燔祭，用你砍下来的亚舍拉作柴。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG6_27","008_6_27","JDG","6","27","27","基甸就从他的仆人中选出了十个人，照着耶和华告诉他的行了；但因为害怕他的父家和城里的人，就不敢在日间行事，只好在晚上作了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG6_28","008_6_28","JDG","6","28","28","城里的人清早起来，见巴力的祭坛已被拆毁，坛旁的亚舍拉也被砍下来，并且看见那第二头牛献在新筑的祭坛上的时候， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG6_29","008_6_29","JDG","6","29","29","就彼此说：“谁作了这事呢？”他们追查寻访之后，就说：“是约阿施的儿子基甸作的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG6_30","008_6_30","JDG","6","30","30","城里的人对约阿施说：“把你的儿子领出来，把他处死，因为他拆毁了巴力的祭坛，砍下了坛旁的亚舍拉。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG6_31","008_6_31","JDG","6","31","31","约阿施对所有站着攻击他的人说：“你们要为巴力辩护吗？或是你们要救他呢？谁为他辩护，到早晨就必死亡。巴力若是神，有人拆毁了他的祭坛，就让他为自己辩护吧。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG6_32","008_6_32","JDG","6","32","32","因此，当日基甸被称为耶路．巴力，意思说：他拆毁了巴力的祭坛，让巴力与他争辩吧。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG6_33","008_6_33","JDG","6","33","33","那时，米甸人、亚玛力人和东方人，都聚集起来，过了河，在耶斯列平原安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG6_34","008_6_34","JDG","6","34","34","耶和华的灵降在基甸身上，他就吹角；亚比以谢族都应召来跟从他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG6_35","008_6_35","JDG","6","35","35","他派使者到玛拿西全地去，玛拿西人也都应召来跟从他；他又派使者到亚设、西布伦、拿弗他利去，他们也都上来与他们会合。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG6_36","008_6_36","JDG","6","36","36","基甸对　神说：“如果你按着你所说的，要借着我的手拯救以色列人； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG6_37","008_6_37","JDG","6","37","37","看哪，我要把一团新剪的羊毛放在禾场上；露水若是单单落在羊毛上，而全地都是干的，我就知道你要照着你所说的，借着我的手拯救以色列了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG6_38","008_6_38","JDG","6","38","38","第二天，基甸清早起来，情形果然是这样；他把羊毛一挤，就从羊毛中挤出一满盆的露水来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG6_39","008_6_39","JDG","6","39","39","基甸又对　神说：“求你不要向我发怒，我要再说这一次；求你让我把羊毛再试一试，但愿单单羊毛是干的，而全地都有露水。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG6_40","008_6_40","JDG","6","40","40","那一夜，　神也这样行了；单单羊毛是干的，全地都有露水。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG7_1","008_7_1","JDG","7","1","1","耶路．巴力，就是基甸，和所有与他在一起的人，清早起来，在哈律泉旁安营；米甸营就在他们的北面，靠近摩利山冈的平原上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG7_2","008_7_2","JDG","7","2","2","耶和华对基甸说：“与你在一起的人太多，我不能把米甸人交在你们手中，免得以色列人向我自夸：‘是我们自己的手救了我们。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG7_3","008_7_3","JDG","7","3","3","现在你要向众民宣告：‘害怕战栗的，可以回去，离开基列山。’”于是众民中有二万二千人回去，只剩下一万人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG7_4","008_7_4","JDG","7","4","4","耶和华对基甸说：“人还是太多，你要领他们下到水旁去，我要在那里为你试验他们。我指着谁对你说：‘这人可以与你同去’，他就可以与你同去；我指着谁对你说：‘这人不可以与你同去’，他就不可以与你同去。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG7_5","008_7_5","JDG","7","5","5","于是基甸带他们下到水边去；耶和华对基甸说：“用舌头舔水，像狗舔水的，你要把他们安置在一处；屈膝跪下喝水的，也要把他们安置在一处。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG7_6","008_7_6","JDG","7","6","6","用手捧到嘴边舔水的，总数共有三百人；其余的人都屈膝跪下喝水。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG7_7","008_7_7","JDG","7","7","7","耶和华对基甸说：“我要用这舔水的三百人拯救你们，把米甸人交在你们的手里，所有其他的人都可以各回自己的地方去。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG7_8","008_7_8","JDG","7","8","8","于是众民手里拿着食物和号角；所有其他的以色列人，基甸都打发他们各回自己的帐棚去，只留下这三百人。当时米甸营就在他们下面的平原里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG7_9","008_7_9","JDG","7","9","9","当夜，耶和华对基甸说：“起来，下去攻营，因为我已经把他们交在你手里了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG7_10","008_7_10","JDG","7","10","10","如果你害怕一人下去，可以带着你的童仆普拉一同下到营地那里去； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG7_11","008_7_11","JDG","7","11","11","你要听听他们说什么，然后你的手就必坚强起来，有胆量下去攻营了。”于是基甸带着他的童仆普拉一同下去，到营中驻军的边缘。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG7_12","008_7_12","JDG","7","12","12","那时米甸人、亚玛力人和所有的东方人，都散布在平原上，好像蝗虫那么多；他们的骆驼无数，好像海边的沙那么多。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG7_13","008_7_13","JDG","7","13","13","基甸到了，就听见一个人正在把他的梦告诉他的同伴，说：“我作了一个梦，梦见一个大麦饼滚入米甸营中，到了帐幕，把帐幕撞倒，帐幕就翻转朝上了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG7_14","008_7_14","JDG","7","14","14","他的同伴回答：“这不是别的，这是以色列人约阿施的儿子基甸的刀；　神已经把米甸和全营交在他手中了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG7_15","008_7_15","JDG","7","15","15","基甸听见了这梦的叙述和梦的讲解，就敬拜　神；然后返回以色列营中，说：“起来，因为耶和华已经把米甸的军队交在你们手里了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG7_16","008_7_16","JDG","7","16","16","于是他把三百人分作三队，把角和空瓶交在各人手里，又把火把放在瓶里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG7_17","008_7_17","JDG","7","17","17","然后对他们说：“你们要看着我，也要照样行事。注意！我到了营的边缘，我怎样行事，你们也要怎样行事。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG7_18","008_7_18","JDG","7","18","18","我和所有与我在一起的人吹角的时候，你们也要在全营的四周吹角，喊叫说：‘为耶和华！为基甸！’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG7_19","008_7_19","JDG","7","19","19","基甸和所有与他在一起的一百人，在半夜三更的起初，换更的时候，来到了营的边缘，就吹起角来，打破手中的瓦瓶。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG7_20","008_7_20","JDG","7","20","20","三队的人就都吹角，打破瓦瓶，左手紧握着火把，右手紧握着角不住地吹，并且喊叫说：“耶和华和基甸的刀！” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG7_21","008_7_21","JDG","7","21","21","他们在营的四周各站在自己的位置；全营的人都乱跑，他们一面叫喊，一面逃跑。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG7_22","008_7_22","JDG","7","22","22","三百人吹那三百枝角的时候，耶和华使全营的人用刀互相击杀，然后他们向着西利拉逃到伯．哈示他，直到靠近他巴的亚伯．米何拉河边。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG7_23","008_7_23","JDG","7","23","23","以色列人就从拿弗他利、亚设和玛拿西全地被召来，追赶米甸人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG7_24","008_7_24","JDG","7","24","24","基甸派遣了使者走遍以法莲山地，说：“你们要下来迎战米甸人，在他们前面把守约旦河的渡口，直到伯．巴拉。”于是以法莲的人都被召来，把守约旦河的渡口，直到伯．巴拉。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG7_25","008_7_25","JDG","7","25","25","他们捉住了米甸人的两个首领：俄立和西伊伯；把俄立杀在俄立磐石上，把西伊伯杀在西伊伯榨酒池那里；然后追赶米甸人，又把俄立和西伊伯的人头带到约旦河对岸，基甸那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG8_1","008_8_1","JDG","8","1","1","以法莲人对基甸说：“你去与米甸人争战的时候，没有召我们同去，你为什么这样待我们呢？”他们就与他激烈地争辩起来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG8_2","008_8_2","JDG","8","2","2","基甸对他们说：“我所行的怎能比得上你们呢？在以法莲拾取剩下的葡萄，不是比在亚比以谢收摘的葡萄更好吗？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG8_3","008_8_3","JDG","8","3","3","神已经把米甸人的两个首领：俄立和西伊伯，交在你们的手里了；我所行的怎能与你们相比呢？”基甸说了这话，他们的怒气就平息了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG8_4","008_8_4","JDG","8","4","4","基甸来到约旦河，就过了河；他和与他在一起的三百人虽然都很疲乏，仍然追赶敌人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG8_5","008_8_5","JDG","8","5","5","基甸对疏割人说：“求你们把几个饼给跟随我的人吃，因为他们疲乏了，我还要继续追赶米甸人和两个王西巴和撒慕拿。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG8_6","008_8_6","JDG","8","6","6","疏割人的首领回答：“西巴和撒慕拿现在不是已经在你的手里吗？我们应该把饼送给你的军队吃吗？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG8_7","008_8_7","JDG","8","7","7","基甸说：“好吧，耶和华把西巴和撒慕拿交在我手里的时候，我就必用野地的荆棘鞭打你们的身体。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG8_8","008_8_8","JDG","8","8","8","基甸从那里上到毗努伊勒，也向他们说了同样的话；毗努伊勒人回答他也像疏割人回答的一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG8_9","008_8_9","JDG","8","9","9","他亦对毗努伊勒人说：“我平平安安回来的时候，我必拆毁这座望楼。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG8_10","008_8_10","JDG","8","10","10","那时，西巴和撒慕拿正在加各，与他们在一起的军队约有一万五千人，就是东方人全营剩下的，因为有十二万持刀的已经倒下了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG8_11","008_8_11","JDG","8","11","11","基甸就从挪巴和约比哈东面，顺着住帐棚的人的路上去；在敌军以为安全而不戒备的时候，击败了敌军。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG8_12","008_8_12","JDG","8","12","12","西巴和撒慕拿逃跑；基甸追赶他们，捉住了米甸人的两个王西巴和撒慕拿，使全军都惊惶。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG8_13","008_8_13","JDG","8","13","13","约阿施的儿子基甸从战场沿着希列斯的山坡回来， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG8_14","008_8_14","JDG","8","14","14","捉住了疏割人中的一个青年人，查问他；他就把疏割的首领和长老的名字写给他，共七十七人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG8_15","008_8_15","JDG","8","15","15","基甸到了疏割人那里，就说：“你看，西巴和撒慕拿，你们为了他们曾经讥笑我说：‘西巴和撒慕拿现在不是在你的手里吗？我们应该把饼送给你那些疲乏的人吃吗？’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG8_16","008_8_16","JDG","8","16","16","于是拿住那城的长老，又拿起野地的荆棘，用荆棘把疏割人教训了一顿； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG8_17","008_8_17","JDG","8","17","17","又拆毁了毗努伊勒的望楼，杀死了那城里的人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG8_18","008_8_18","JDG","8","18","18","基甸问西巴和撒慕拿：“你们在他泊山上所杀的人，是什么模样的人？”他们回答：“他们像你一样，每一个都像王子的模样。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG8_19","008_8_19","JDG","8","19","19","基甸说：“他们是我的兄弟，是我母亲的儿子；我指着永活的耶和华起誓，如果你们从前让他们存活，我现在就不杀你们了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG8_20","008_8_20","JDG","8","20","20","于是对他的长子益帖说：“起来，把他们杀了吧。”但是那孩子不敢拔刀，只是害怕，因为他还是个孩子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG8_21","008_8_21","JDG","8","21","21","西巴和撒慕拿说：“你亲自起来杀我们吧；因为人怎样，他的力量也怎样。”于是基甸起来，把西巴和撒慕拿杀了，拿了他们骆驼颈项上的月牙圈。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG8_22","008_8_22","JDG","8","22","22","以色列人对基甸说：“你既然拯救我们脱离了米甸人的手，求你和你的子孙统治我们。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG8_23","008_8_23","JDG","8","23","23","基甸回答他们：“我不统治你们，我的子孙也不统治你们，唯有耶和华统治你们。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG8_24","008_8_24","JDG","8","24","24","基甸又对他们说：“我有一个要求：请把你们各人夺得的耳环给我。”原来敌人都戴金耳环，因为他们是以实玛利人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG8_25","008_8_25","JDG","8","25","25","他们回答：“我们愿意给你。”于是铺开一件外衣，各人把夺得的耳环丢在上面。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG8_26","008_8_26","JDG","8","26","26","基甸所要的金耳环，共重约二十公斤金子，此外还有米甸王身上的月牙圈、耳坠和紫红色的衣服，另外还有骆驼颈项上的链子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG8_27","008_8_27","JDG","8","27","27","基甸用这些金子做了一个以弗得，安置在他的城俄弗拉；后来以色列众人都在那里随从以弗得行了邪淫，因此这就成了基甸和他全家的网罗。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG8_28","008_8_28","JDG","8","28","28","这样，米甸人在以色列人面前就被制伏了，不能再抬起头来；基甸在世的日子，国中太平了四十年。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG8_29","008_8_29","JDG","8","29","29","约阿施的儿子耶路．巴力回去，住在自己家里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG8_30","008_8_30","JDG","8","30","30","基甸有七十个儿子，都是他亲生的，因为他有很多妻子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG8_31","008_8_31","JDG","8","31","31","他在示剑的妾，也给他生了一个儿子，他给他起名叫亚比米勒。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG8_32","008_8_32","JDG","8","32","32","约阿施的儿子基甸寿数满足而死，埋葬在亚比以谢族的俄弗拉，在他父亲约阿施的坟墓里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG8_33","008_8_33","JDG","8","33","33","基甸死了以后，以色列人又转去随从众巴力，行邪淫，并且以巴力．比利土作他们的神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG8_34","008_8_34","JDG","8","34","34","以色列人忘记了耶和华他们的　神，就是曾经拯救他们脱离四围仇敌之手的那位； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG8_35","008_8_35","JDG","8","35","35","也没有照着基甸向以色列人所施的一切恩惠，恩待耶路．巴力，就是基甸的家。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_1","008_9_1","JDG","9","1","1","耶路．巴力的儿子亚比米勒，到示剑去见他的众母舅，对他们和他母亲的全体族人说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_2","008_9_2","JDG","9","2","2","“请你们给示剑的众人说：‘是耶路．巴力的众子七十人都统治你们好呢？还是一个人统治你们好呢？’你们也要记得我是你们的骨肉。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_3","008_9_3","JDG","9","3","3","他的众母舅就把这一切话为他说给示剑的众人听；他们的心都倾向亚比米勒，因为他们说：“他本是我们的亲族。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_4","008_9_4","JDG","9","4","4","他们就从巴力．比利土的庙里，取了八百克银子给亚比米勒，亚比米勒用这些银子雇了一些无赖流氓，那些人就跟随了他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_5","008_9_5","JDG","9","5","5","他回到俄弗拉他父亲的家，把自己的兄弟，耶路．巴力的众子七十人，都杀在一块石头上；只剩下耶路．巴力的小儿子约坦，因为他藏了起来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_6","008_9_6","JDG","9","6","6","示剑的众人和伯特米罗人都聚集起来，到示剑橡树旁的望楼那里，立亚比米勒为王。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_7","008_9_7","JDG","9","7","7","有人把这事告诉了约坦，约坦就去，站在基利心山顶上，高声向他们呼喊，说：“示剑人哪，你们要听我的话，　神也就听你们的话。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_8","008_9_8","JDG","9","8","8","有一次，众树要去膏立一个王统治它们，就对橄榄树说：‘请你作王统治我们吧。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_9","008_9_9","JDG","9","9","9","橄榄树对它们说：‘我怎可以放弃生产人用来荣耀　神和尊崇人的油，飘摇在众树之上呢？’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_10","008_9_10","JDG","9","10","10","众树对无花果树说：‘请你来作王统治我们吧。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_11","008_9_11","JDG","9","11","11","无花果树对它们说：‘我怎可以放弃结出我的甜美果子，飘摇在众树之上呢？’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_12","008_9_12","JDG","9","12","12","众树对葡萄树说：‘请你来作王统治我们吧。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_13","008_9_13","JDG","9","13","13","葡萄树对它们说：‘我怎可以放弃生产那使　神和世人都喜乐的新酒，飘摇在众树之上呢？’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_14","008_9_14","JDG","9","14","14","于是众树都对荆棘说：‘请你来作王统治我们吧。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_15","008_9_15","JDG","9","15","15","荆棘对众树说：‘如果你们真诚地膏立我作王统治你们，就要来，投靠在我的荫下；否则，火必从荆棘里出来，吞灭黎巴嫩的香柏树。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_16","008_9_16","JDG","9","16","16","“现在你们立亚比米勒为王，你们若是诚实和正直，如果你们善待耶路．巴力和他的家，照着他手所作的待他； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_17","008_9_17","JDG","9","17","17","我父亲从前冒死为你们争战，把你们从米甸人手中救了出来； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_18","008_9_18","JDG","9","18","18","今日你们竟起来攻击我的父家，在一块石头上杀了他七十个儿子，又立了他的婢女所生的儿子亚比米勒作示剑人的王，因为他原是你们的亲族。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_19","008_9_19","JDG","9","19","19","今日你们若是按着诚实和正直待耶路．巴力和他的家，你们就可以因亚比米勒得喜乐，亚比米勒也可以因你们得喜乐。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_20","008_9_20","JDG","9","20","20","若不是这样，愿火从亚比米勒出来，吞灭示剑人和伯特米罗人；又愿火从示剑人和伯特米罗人出来，吞灭亚比米勒。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_21","008_9_21","JDG","9","21","21","接着约坦就逃跑了；他逃到比珥去，住在那里，躲避他的兄弟亚比米勒。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_22","008_9_22","JDG","9","22","22","亚比米勒治理以色列人三年。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_23","008_9_23","JDG","9","23","23","神差派邪恶的灵来到亚比米勒与示剑人中间，示剑人就背弃了亚比米勒。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_24","008_9_24","JDG","9","24","24","这是要报复对耶路．巴力七十个儿子的暴行，把流他们血的罪归到他们的兄弟亚比米勒身上，就是那杀害他们的；也归到示剑人身上，就是那些帮助亚比米勒去杀他自己的兄弟的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_25","008_9_25","JDG","9","25","25","示剑人在山顶上设下埋伏，路过他们那里的，他们都劫掠；有人把这事告诉亚比米勒。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_26","008_9_26","JDG","9","26","26","那时，以别的儿子迦勒与他的兄弟都来了，到示剑去，示剑人竟信任他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_27","008_9_27","JDG","9","27","27","他们出到田间去，收取葡萄，榨酒，举行庆祝会，进入他们的神庙吃喝，并且咒诅亚比米勒。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_28","008_9_28","JDG","9","28","28","以别的儿子迦勒说：“亚比米勒是谁？示剑是谁？竟要我们服事他呢？他不是耶路．巴力的儿子吗？他的副官不是西布勒吗？你们要服事示剑的始祖哈抹的后人啊；我们为什么要服事亚比米勒呢？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_29","008_9_29","JDG","9","29","29","但愿这些人民都归在我手下，我好把亚比米勒除掉。”迦勒又对亚比米勒说：“增添你的军队出来吧！” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_30","008_9_30","JDG","9","30","30","那城的首长西布勒听了以别的儿子迦勒的话，他的怒气就发作， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_31","008_9_31","JDG","9","31","31","秘密差派使者去见亚比米勒，说：“以别的儿子迦勒和他的兄弟已经到了示剑，他们正在煽动那城的人反叛你。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_32","008_9_32","JDG","9","32","32","现在，你和与你在一起的人，要在夜间起来，在野地埋伏。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_33","008_9_33","JDG","9","33","33","到了早晨，太阳出来的时候，你就要起来攻城；你要注意，迦勒和与他在一起的人出来对抗你的时候，你就把握机会对付他们。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_34","008_9_34","JDG","9","34","34","于是亚比米勒和与他在一起的人，都在夜间起来，分作四队，埋伏着等候示剑人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_35","008_9_35","JDG","9","35","35","以别的儿子迦勒出去，站在城门口；亚比米勒和与他在一起的人，从埋伏的地方起来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_36","008_9_36","JDG","9","36","36","迦勒看见了那些人，就对西布勒说：“你看，有人从山顶上下来。”西布勒说：“你看见山的影子以为是人。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_37","008_9_37","JDG","9","37","37","迦勒又说：“看哪，有人从高地下来，又有一队从米恶尼尼橡树的路径而来。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_38","008_9_38","JDG","9","38","38","西布勒对他说：“你曾经说过：‘亚比米勒是谁，竟要我们服事他呢？’现在你说这话的嘴在哪里呢？这不是你轻视的人吗？现在请你出去与他们交战吧。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_39","008_9_39","JDG","9","39","39","于是迦勒在示剑人面前出去，与亚比米勒争战。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_40","008_9_40","JDG","9","40","40","亚比米勒追赶迦勒，迦勒在他面前逃跑，直到城门口，有很多受伤的人仆倒。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_41","008_9_41","JDG","9","41","41","亚比米勒住在亚鲁玛；西布勒把迦勒和他的兄弟赶走，不许他们住在示剑。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_42","008_9_42","JDG","9","42","42","次日，城中众人出到田间去，有人把这事告诉亚比米勒。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_43","008_9_43","JDG","9","43","43","亚比米勒就把他的人分作三队，埋伏在田间；他在那里观看，见有人从城里出来，就起来攻击他们，把他们击杀了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_44","008_9_44","JDG","9","44","44","亚比米勒和与他在一起的一队人忽然冲过去，站在城门口；其他两队人也冲出来攻打所有在田间的人，把他们击杀了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_45","008_9_45","JDG","9","45","45","那一天，亚比米勒整天攻打那城，把城攻下了，杀了城中的众人；把城拆毁，又撒上盐。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_46","008_9_46","JDG","9","46","46","示剑楼的众人听见了这事，就逃入伊勒．比利土庙的地穴里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_47","008_9_47","JDG","9","47","47","有人告诉亚比米勒，说：“示剑楼所有的人都聚集在一起。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_48","008_9_48","JDG","9","48","48","亚比米勒和与他在一起的人都上了撒们山；亚比米勒手里拿着斧子，砍下一根树枝，拿起来放在自己的肩头上，然后对与他在一起的人说：“你们看我作什么，你们也要赶快照样作。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_49","008_9_49","JDG","9","49","49","于是众人也各自砍下一根树枝，跟随着亚比米勒，把树枝放在地穴上，放火烧了地穴，以致示剑楼的人都死了，男女约有一千人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_50","008_9_50","JDG","9","50","50","后来亚比米勒到提备斯去，安营攻打提备斯，攻取了那城。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_51","008_9_51","JDG","9","51","51","城中有一座坚固的城楼；那城所有的人，无论男女，都逃到那里去，关上门，上了楼顶。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_52","008_9_52","JDG","9","52","52","亚比米勒到了城楼前，攻打城楼；他走近城楼门口，要用火焚烧。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_53","008_9_53","JDG","9","53","53","有一个妇人把一块上磨石拋在亚比米勒的头上，打破了他的头盖骨。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_54","008_9_54","JDG","9","54","54","他急忙呼喊替他拿兵器的少年人，对他说：“拔出你的刀来，把我杀死吧。免得人讲论我说：‘他被一个妇人所杀。’”于是那少年人把他刺透，他就死了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_55","008_9_55","JDG","9","55","55","以色列人看见亚比米勒死了，就各回自己的地方去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_56","008_9_56","JDG","9","56","56","这样，　神报应了亚比米勒向他父亲所行的恶事，就是他杀了自己的兄弟七十个人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG9_57","008_9_57","JDG","9","57","57","神也把示剑人的一切恶事，都报应在他们的头上；耶路．巴力的儿子约坦的咒诅，也归到他们身上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG10_1","008_10_1","JDG","10","1","1","亚比米勒之后，有以萨迦人朵多的孙子，普瓦的儿子陀拉，兴起拯救以色列人；他住在以法莲山地的沙密。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG10_2","008_10_2","JDG","10","2","2","陀拉治理以色列人二十三年，就死了，埋葬在沙密。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG10_3","008_10_3","JDG","10","3","3","在他之后，有基列人睚珥兴起治理以色列人二十二年。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG10_4","008_10_4","JDG","10","4","4","他有三十个儿子，骑着三十头驴驹；他们有三十座城，叫作哈倭特．睚珥，直到今日都是在基列地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG10_5","008_10_5","JDG","10","5","5","睚珥死了以后，就埋葬在加们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG10_6","008_10_6","JDG","10","6","6","以色列人又行了耶和华看为恶的事，服事众巴力和亚斯他录，以及亚兰的神、西顿的神、摩押的神、亚扪人的神、非利士人的神；他们离弃了耶和华，不再服事他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG10_7","008_10_7","JDG","10","7","7","耶和华的怒气向以色列人发作，就把他们交在非利士人的手中和亚扪人的手中。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG10_8","008_10_8","JDG","10","8","8","从那一年起，他们就迫害欺压以色列人，就是所有在约旦河东边，住在亚摩利人之地的以色列人，共十八年。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG10_9","008_10_9","JDG","10","9","9","亚扪人又渡过约旦河去攻打犹大、便雅悯和以法莲家，以色列人就非常困苦。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG10_10","008_10_10","JDG","10","10","10","以色列人向耶和华哀求，说：“我们得罪了你，因为我们离弃了我们的　神，服事众巴力。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG10_11","008_10_11","JDG","10","11","11","耶和华对以色列人说：“我不是曾经拯救你们脱离埃及人、亚摩利人、亚扪人和非利士人吗？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG10_12","008_10_12","JDG","10","12","12","西顿人、亚玛力人、马云人也都压迫你们；你们向我哀求，我也拯救你们脱离他们的手。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG10_13","008_10_13","JDG","10","13","13","你们竟离弃了我，服事别的神，因此我不再拯救你们了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG10_14","008_10_14","JDG","10","14","14","你们去向你们拣选的神呼求吧！让他们在你们遭遇患难的时候拯救你们吧。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG10_15","008_10_15","JDG","10","15","15","以色列人对耶和华说：“我们犯了罪了，你任意对待我们吧；只求你今日拯救我们。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG10_16","008_10_16","JDG","10","16","16","以色列人就从他们中间除去外族人的神，事奉耶和华；耶和华的心因以色列人所受的患难，就很着急。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG10_17","008_10_17","JDG","10","17","17","当时亚扪人聚集起来，在基列安营；以色列人也聚集，在米斯巴安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG10_18","008_10_18","JDG","10","18","18","基列的人民和众领袖彼此说：“谁先去攻打亚扪人，谁就可以作基列所有居民的首领。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG11_1","008_11_1","JDG","11","1","1","基列人耶弗他是个英勇的战士；他是个妓女的儿子；耶弗他是基列所生的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG11_2","008_11_2","JDG","11","2","2","基列的妻子也给他生了几个儿子。他妻子的儿子长大了，就把耶弗他赶出去，对他说：“你不可以在我们的父家继承产业，因为你是另一个妇人的儿子。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG11_3","008_11_3","JDG","11","3","3","耶弗他就从他的兄弟面前逃跑，住在陀伯地；有些无赖聚集到他那里，与他一起出入。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG11_4","008_11_4","JDG","11","4","4","过了些日子，亚扪人与以色列人争战。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG11_5","008_11_5","JDG","11","5","5","亚扪人与以色列人争战的时候，基列的众长老就去，把耶弗他从陀伯请回来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG11_6","008_11_6","JDG","11","6","6","他们对耶弗他说：“请你来作我们的统帅，我们好攻打亚扪人。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG11_7","008_11_7","JDG","11","7","7","耶弗他对基列的长老说：“从前你们不是恨我，赶逐我离开我的父家吗？现在你们遭遇患难的时候，为什么到我这里来呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG11_8","008_11_8","JDG","11","8","8","基列的长老对耶弗他说：“现在我们回到你这里来，是要你与我们一同回去，与亚扪人争战，你要作我们基列所有居民的首领。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG11_9","008_11_9","JDG","11","9","9","耶弗他对基列的长老说：“如果你们带我回去，攻打亚扪人，耶和华把他们交在我面前，那么我就可以作你们的首领吗？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG11_10","008_11_10","JDG","11","10","10","基列的长老对耶弗他说：“有耶和华在我们中间作证，我们必定照着你的话行。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG11_11","008_11_11","JDG","11","11","11","于是耶弗他与基列的长老一同回去了，众人就立耶弗他作他们的首领，作他们的统帅；耶弗他在米斯巴，在耶和华面前，把自己的一切话都说了出来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG11_12","008_11_12","JDG","11","12","12","耶弗他派遣使者去见亚扪人的王，说：“我跟你有什么关系呢？你竟到我这里来攻打我的土地呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG11_13","008_11_13","JDG","11","13","13","亚扪人的王对耶弗他的使者说：“因以色列人从埃及上来的时候，夺了我的土地，从亚嫩河到雅博河，直到约旦河；现在你要把它和和平平地交还。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG11_14","008_11_14","JDG","11","14","14","耶弗他又再派使者去见亚扪人的王， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG11_15","008_11_15","JDG","11","15","15","对他说：“耶弗他这样说：‘以色列人并没有夺取过摩押地和亚扪人的土地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG11_16","008_11_16","JDG","11","16","16","以色列人从埃及上来的时候，是走过旷野到红海，到了加低斯； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG11_17","008_11_17","JDG","11","17","17","就派遣使者去见以东王，说：求你让我们经过你的领土。以东王却不答应；又派遣使者去见摩押王，摩押王也不肯；以色列人就住在加低斯。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG11_18","008_11_18","JDG","11","18","18","以后，他们走过旷野，绕过以东地和摩押地，到了摩押地的东边，在亚嫩河那边安营；他们并没有进入摩押境内，因为亚嫩河是摩押的边界。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG11_19","008_11_19","JDG","11","19","19","以色列人又派遣使者去见亚摩利人的王西宏，就是希实本王，对他说：求你让我们经过你的领土，到我们自己的地方去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG11_20","008_11_20","JDG","11","20","20","西宏却不信任以色列人，不让他们经过他的境界；西宏聚集了他所有的人民，在雅杂安营，与以色列人争战。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG11_21","008_11_21","JDG","11","21","21","耶和华以色列的　神，把西宏和他所有的人民都交在以色列人手中，以色列人击杀了他们，夺取了住在那地的亚摩利人的全地， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG11_22","008_11_22","JDG","11","22","22","占领了亚摩利人四周的境界，从亚嫩河到雅博河，从旷野直到约旦河。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG11_23","008_11_23","JDG","11","23","23","现在耶和华以色列的　神，已经把亚摩利人从他的子民以色列人面前赶走了，你竟要占有这地吗？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG11_24","008_11_24","JDG","11","24","24","你不是应占有你的神基抹要你占有的地吗？我们不是应占有耶和华我们的　神，从我们面前赶走的人的一切地吗？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG11_25","008_11_25","JDG","11","25","25","现在难道你比摩押王西拨的儿子巴勒还强吗？他曾经与以色列人争竞吗？或是与以色列人交战过吗？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG11_26","008_11_26","JDG","11","26","26","以色列人住在希实本和属希实本的村镇，亚罗珥和亚罗珥的村镇，以及亚嫩河沿岸的一切城市，已经有三百年了；在这时期内，你们为什么没有夺回这些地方呢？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG11_27","008_11_27","JDG","11","27","27","我没有得罪你，你竟恶待我，攻打我；愿审判者耶和华今日在以色列人和亚扪人中间，判断是非。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG11_28","008_11_28","JDG","11","28","28","但亚扪人的王不听从耶弗他差派人去对他所说的话。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG11_29","008_11_29","JDG","11","29","29","那时耶和华的灵临到耶弗他身上，他就经过基列和玛拿西，经过基列的米斯巴，又从基列的米斯巴去到亚扪人那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG11_30","008_11_30","JDG","11","30","30","耶弗他向耶和华许愿，说：“如果你真的把亚扪人交在我手里， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG11_31","008_11_31","JDG","11","31","31","我从亚扪人那里平平安安回来的时候，无论谁先从我的家门出来迎接我，他就必归耶和华，我也必把他当作燔祭。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG11_32","008_11_32","JDG","11","32","32","于是耶弗他去到亚扪人那里攻打他们，耶和华把他们交在他手里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG11_33","008_11_33","JDG","11","33","33","于是他从亚罗珥开始击杀他们，去到米匿，直到亚备勒．基拉明，共二十座城，是一场大击杀；这样，亚扪人就在以色列人面前被制伏了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG11_34","008_11_34","JDG","11","34","34","耶弗他回米斯巴去，到了自己的家，不料，他的女儿拿着鼓、跳着舞，出来迎接他；她是耶弗他的独生女，除她以外，耶弗他没有其他的儿女。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG11_35","008_11_35","JDG","11","35","35","耶弗他看见了她，就撕裂自己的衣服，说：“啊！我的女儿啊，你真使我忧愁，你叫我太作难了；因为我已经向耶和华开过口许愿，我不能收回。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG11_36","008_11_36","JDG","11","36","36","她对他说：“我的父亲啊，你既然向耶和华开过口许了愿，就照着你口里所说的向我行吧！因为耶和华已经在你的仇敌亚扪人身上，为你报了仇。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG11_37","008_11_37","JDG","11","37","37","她又对自己的父亲说：“请你准我这件事吧：给我两个月时间，让我和我的同伴去漫游山间，为我的童贞哀哭。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG11_38","008_11_38","JDG","11","38","38","耶弗他说：“你去吧！”就让她离去两个月；她就带着她的同伴去了，在山上为她的童贞哀哭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG11_39","008_11_39","JDG","11","39","39","两个月后，她回到她的父亲那里，她父亲就照他所许的愿向她行了。她没有与男人同过房。以后，在以色列中有个惯例： ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG11_40","008_11_40","JDG","11","40","40","以色列的女子年年都去哀悼基列人耶弗他的女儿，每年四日。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG12_1","008_12_1","JDG","12","1","1","以法莲人聚集起来，过河到了撒分，对耶弗他说：“你过去攻打亚扪人的时候，为什么没有召我们与你同去呢？我们要用火烧掉你和你的房屋。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG12_2","008_12_2","JDG","12","2","2","耶弗他对他们说：“我和我的人民跟亚扪人激烈争战的时候，我曾经呼求你们，你们却没有来救我们脱离他们的手。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG12_3","008_12_3","JDG","12","3","3","我见你们不来拯救我，我就拚命上去攻击亚扪人，耶和华就把他们交在我的手里。你们今日为什么上我这里来攻打我呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG12_4","008_12_4","JDG","12","4","4","于是耶弗他召集了基列所有的人，与以法莲人争战；基列人击杀了以法莲人，因为以法莲人曾经说过：“你们基列人在以法莲和玛拿西中间，不过是以法莲逃亡的人罢了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG12_5","008_12_5","JDG","12","5","5","基列人占领约旦河的各渡口，不容以法莲人过去。如果以法莲逃亡的人说：“让我过去吧。”基列人就问他：“你是以法莲人吗？”如果他说：“不是。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG12_6","008_12_6","JDG","12","6","6","基列人就对他说：“请说‘示播列’。”以法莲人因为发不出准确的字音，就说成“西播列”；基列人就把他捉住，在约旦河的渡口那里杀了；那时以法莲人死了四万二千人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG12_7","008_12_7","JDG","12","7","7","耶弗他治理以色列人共六年；基列人耶弗他死了以后，埋葬在基列的一座城里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG12_8","008_12_8","JDG","12","8","8","耶弗他之后，有伯利恒人以比赞治理以色列人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG12_9","008_12_9","JDG","12","9","9","他有三十个儿子，三十个女儿；女儿都嫁到外面去，又给他的儿子从外面娶了三十个女子作妻子。他治理以色列人共七年。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG12_10","008_12_10","JDG","12","10","10","以比赞死了，就埋葬在伯利恒。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG12_11","008_12_11","JDG","12","11","11","以比赞之后，有西布伦人以伦，治理以色列人共十年。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG12_12","008_12_12","JDG","12","12","12","西布伦人以伦死了以后，就埋葬在西布伦地的亚雅仑。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG12_13","008_12_13","JDG","12","13","13","以伦之后，有比拉顿人希列的儿子押顿治理以色列人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG12_14","008_12_14","JDG","12","14","14","他有四十个儿子，三十个孙子，骑着七十头驴驹；押顿治理以色列人共八年。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG12_15","008_12_15","JDG","12","15","15","比拉顿人希列的儿子押顿死了，埋葬在以法莲地，就是在亚玛力人的山地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG13_1","008_13_1","JDG","13","1","1","以色列人又行了耶和华看为恶的事，耶和华就把他们交在非利士人手中四十年。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG13_2","008_13_2","JDG","13","2","2","那时有一个琐拉人，是属于但支派的，名叫玛挪亚；他的妻子不能生育，没有孩子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG13_3","008_13_3","JDG","13","3","3","耶和华的使者向那妇人显现，对她说：“你向来不能生育，没有孩子，现在你必要怀孕，生一个儿子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG13_4","008_13_4","JDG","13","4","4","现在你要谨慎，清酒或烈酒都不可喝，各样不洁的东西也不可吃。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG13_5","008_13_5","JDG","13","5","5","看哪！你必怀孕，生一个儿子；不可用剃刀剃他的头，这孩子从在母腹开始就归　神作拿细耳人；他必拯救以色列人脱离非利士人的手。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG13_6","008_13_6","JDG","13","6","6","妇人就回去，告诉她的丈夫说：“有一位神人到我这里来，他的容貌像　神使者的容貌，非常可畏，我没有问他从哪里来，他也没有告诉我他的名字。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG13_7","008_13_7","JDG","13","7","7","他对我说：‘你必要怀孕，生一个儿子；现在清酒或烈酒你都不可喝，各样不洁的东西你也不可吃，因为这孩子从在母腹开始，一直到死，都必归耶和华作拿细耳人。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG13_8","008_13_8","JDG","13","8","8","玛挪亚就恳求耶和华，说：“啊，主啊，求你叫你派来的神人再到我们这里吧！好指教我们要怎样对待将要生下来的孩子。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG13_9","008_13_9","JDG","13","9","9","神听了玛挪亚的声音。妇人正坐在田间的时候，　神的使者又来到她那里，她的丈夫玛挪亚却没有与她在一起。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG13_10","008_13_10","JDG","13","10","10","妇人急忙跑去告诉丈夫，对他说：“那天到我这里来的那人，又向我显现了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG13_11","008_13_11","JDG","13","11","11","玛挪亚起来，跟着他的妻子出去，来到那人跟前，问他：“你就是向这个妇人说过话的人吗？”他回答：“我就是。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG13_12","008_13_12","JDG","13","12","12","玛挪亚说：“你的话应验的时候，这孩子的生活方式怎样？他要作什么呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG13_13","008_13_13","JDG","13","13","13","耶和华的使者对玛挪亚说：“我对妇人所说的一切话，她都要谨守。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG13_14","008_13_14","JDG","13","14","14","从葡萄树所产的，她都不可吃；清酒或烈酒，她都不可喝；各样不洁的东西，她也不可吃；我吩咐她的，她都要谨守。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG13_15","008_13_15","JDG","13","15","15","玛挪亚对耶和华的使者说：“请留下，好让我为你预备一只山羊羔。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG13_16","008_13_16","JDG","13","16","16","耶和华的使者对玛挪亚说：“你虽然要我留下，我却不吃你的食物；如果你预备燔祭，就当献给耶和华。”原来玛挪亚还不知道他是耶和华的使者。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG13_17","008_13_17","JDG","13","17","17","玛挪亚问耶和华的使者：“你叫什么名字？到你的话应验的时候，我们好把尊荣归你。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG13_18","008_13_18","JDG","13","18","18","耶和华的使者对他说：“你为什么问我的名字呢？我的名是奇妙的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG13_19","008_13_19","JDG","13","19","19","玛挪亚取了一只山羊羔和素祭，在磐石上献与那行奇事的耶和华；玛挪亚和他的妻子一直在观看。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG13_20","008_13_20","JDG","13","20","20","火焰从祭坛上往天升起的时候，耶和华的使者在祭坛上的火焰中也升上去了；玛挪亚和他的妻子看见了，就俯伏在地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG13_21","008_13_21","JDG","13","21","21","耶和华的使者没有再向玛挪亚和他的妻子显现，那时玛挪亚才知道他是耶和华的使者。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG13_22","008_13_22","JDG","13","22","22","玛挪亚对他的妻子说：“我们必定要死，因为我们看见了　神。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG13_23","008_13_23","JDG","13","23","23","他的妻子却对他说：“如果耶和华有意要杀我们，就必不从我们的手里接纳燔祭和素祭，也必不会把这一切事指示我们，更不会在这个时候向我们宣布这些事啊。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG13_24","008_13_24","JDG","13","24","24","后来那妇人生了一个儿子，她就给他起名叫参孙；孩子渐渐长大了，耶和华赐福给他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG13_25","008_13_25","JDG","13","25","25","在玛哈尼．但（“玛哈尼．但”意即“但的军营”），就是在琐拉和以实陶中间，耶和华的灵开始感动参孙。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG14_1","008_14_1","JDG","14","1","1","参孙下到亭拿，在亭拿看见了一个女子，是一个非利士人的女儿。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG14_2","008_14_2","JDG","14","2","2","参孙上来告诉他的父母，说：“我在亭拿看见一个女子，是一个非利士人的女儿；现在请你们把她娶来给我作妻子。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG14_3","008_14_3","JDG","14","3","3","他的父母对他说：“在你兄弟的女儿中，或是在你所有的族人中，难道没有一个女子，以致你要去从那些未受割礼的非利士人中娶妻呢？”参孙对他的父亲说：“请你把她娶来给我，因为我看中她。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG14_4","008_14_4","JDG","14","4","4","他的父母却不知道这事是出于耶和华，因为他正在找机会攻击非利士人。那时非利士人正统治着以色列人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG14_5","008_14_5","JDG","14","5","5","参孙跟他的父母下到亭拿去，到了亭拿的葡萄园；忽然见一只少壮狮子向他吼叫。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG14_6","008_14_6","JDG","14","6","6","耶和华的灵大大感动参孙，他虽然手里没有武器，竟把狮子撕裂，像人撕裂山羊羔一样；他没有把他所作的这事告诉他的父母。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG14_7","008_14_7","JDG","14","7","7","参孙下去，和那女子说话，就看中了她。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG14_8","008_14_8","JDG","14","8","8","过了些日子，参孙回去迎娶那女子，他转向一旁去看看那只死了的狮子；看见有一群蜂子和一些蜂蜜在狮子的尸体内。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG14_9","008_14_9","JDG","14","9","9","他刮了些蜂蜜，放在手里，就走了；他一面走，一面吃，直走到他的父母那里去；他又把蜂蜜给了他们，他们也吃了；但是他没有告诉他们这蜂蜜是从狮子的尸体内刮下来的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG14_10","008_14_10","JDG","14","10","10","参孙的父亲下去见那女子，参孙在那里摆设了筵席，因为青年人都惯常这样行。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG14_11","008_14_11","JDG","14","11","11","众人看见参孙，就请了三十个人陪伴他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG14_12","008_14_12","JDG","14","12","12","参孙对他们说：“现在让我给你们出一个谜语，你们在七天婚宴之内，如果能猜出来，把它的意思清楚告诉我，我就给你们三十件内衣、三十套衣服。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG14_13","008_14_13","JDG","14","13","13","如果你们不能告诉我，你们就要给我三十件内衣、三十套衣服。”他们对他说：“请你把谜语说给我们听。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG14_14","008_14_14","JDG","14","14","14","参孙对他们说：“可吃的从吃者出来；甜的从强者出来。”他们过了三日都不能说出谜语的意思。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG14_15","008_14_15","JDG","14","15","15","到了第四天，他们对参孙的妻子说：“你要引诱你的丈夫，使他把谜语的意思告诉我们，否则我们用火烧你和你的父家。难道你们请了我们来，是要夺取我们所有的吗？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG14_16","008_14_16","JDG","14","16","16","参孙的妻子在丈夫面前哭哭啼啼，说：“你只是恨我，不是爱我；你给我的族人设谜语，却没有把谜语的意思告诉我。”参孙对她说：“连我父母我都没有告诉，怎能告诉你呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG14_17","008_14_17","JDG","14","17","17","在那七天婚宴期内，她在丈夫跟前常常哭哭啼啼；到了第七天，因为她催逼着参孙，参孙才告诉她；于是她把谜语的意思告诉她的族人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG14_18","008_14_18","JDG","14","18","18","到了第七天太阳未落以前，城里的人就对参孙说：“有什么比蜂蜜还甜呢？有什么比狮子还强呢？”参孙对他们说：“你们若不是用我的母牛犊耕田，你们就不会猜出我的谜语的意思来。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG14_19","008_14_19","JDG","14","19","19","耶和华的灵大大感动参孙，参孙就下到亚实基伦，击杀了他们中间三十个人，拿了剥下来的衣服，把三十套衣服给了那些把谜语的意思说出来的人；参孙怒气冲冲地上自己的父家去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG14_20","008_14_20","JDG","14","20","20","参孙的妻子却归了一个陪伴参孙的人，就是作过他伴郎的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG15_1","008_15_1","JDG","15","1","1","过了些日子，到收割麦子的时候，参孙带着一只山羊羔去看他的妻子；他心里说：“我要进内室去见我的妻子。”但是他妻子的父亲不让他进去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG15_2","008_15_2","JDG","15","2","2","她父亲说：“我以为你非常恨她，所以我把她给了你的一个同伴；她的妹妹不是比她更美丽吗？你可以娶来代替她啊。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG15_3","008_15_3","JDG","15","3","3","参孙对他们说：“这次如果我加害非利士人，就可以不必负责了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG15_4","008_15_4","JDG","15","4","4","于是参孙去捉了三百只狐狸，又拿了火把来，把狐狸尾巴对尾巴缚在一起，又把一枝火把插在两条尾巴中间。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG15_5","008_15_5","JDG","15","5","5","他点着了火把，就放狐狸进入非利士人的禾田里，把堆积的禾捆，和未割的禾稼，以及橄榄园都烧了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG15_6","008_15_6","JDG","15","6","6","非利士人问：“这是谁作的呢？”有人回答：“是亭拿人的女婿参孙作的，因为他岳父把他的妻子给了他的同伴。”于是非利士人上去，放火烧了那女子和她的父亲。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG15_7","008_15_7","JDG","15","7","7","参孙对他们说：“你们既然这样行，我必在你们身上报仇，然后才肯罢休。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG15_8","008_15_8","JDG","15","8","8","参孙击打他们，连腿带腰都砍断了，那是一场极大的杀戮；然后他下去，住在以坦磐石的穴中。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG15_9","008_15_9","JDG","15","9","9","非利士人上去，在犹大安营，在利希散开。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG15_10","008_15_10","JDG","15","10","10","犹大人说：“你们为什么上来攻打我们呢？”他们说：“我们上来是要捆绑参孙，要报复他向我们所行的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG15_11","008_15_11","JDG","15","11","11","于是有三千犹大人下到以坦磐石的穴中去，对参孙说：“非利士人统治我们，你不知道吗？你为什么向我们行这事呢？”参孙对他们说：“他们怎样待我，我也怎样待他们。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG15_12","008_15_12","JDG","15","12","12","犹大人对他说：“我们下来要捆绑你，把你交在非利士人手里。”参孙对他们说：“你们要向我发誓，你们不亲自杀害我。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG15_13","008_15_13","JDG","15","13","13","他们告诉他说：“我们不会杀害你，我们只要把你捆绑住，交在非利士人手里，我们决不杀死你。”于是他们用两条新绳子把参孙捆绑起来，从磐石的穴里把他带上来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG15_14","008_15_14","JDG","15","14","14","参孙来到利希，非利士人就吶喊着出来迎接他，耶和华的灵大大临到参孙身上，他臂上的绳子就像被火烧的麻一样，他的捆绑都从他的手上落下来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG15_15","008_15_15","JDG","15","15","15","他找着一块新鲜的驴腮骨，就伸手拾起来，击杀了一千人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG15_16","008_15_16","JDG","15","16","16","参孙说：“我用驴腮骨杀人成堆；我用驴腮骨击杀了一千人。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG15_17","008_15_17","JDG","15","17","17","说完了，就把那腮骨从手里拋出去，因此那地方就叫拉末．利希（“拉末．利希”意即“腮骨的山”）。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG15_18","008_15_18","JDG","15","18","18","参孙非常口渴，就呼求耶和华说：“你既然借着你仆人的手施行这么大的拯救，现在我怎可以渴死，落在未受割礼的人手中呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG15_19","008_15_19","JDG","15","19","19","于是　神在利希使一洼地裂开，就有水从那里涌出来；参孙喝了，就恢复精神，活力充足；因此那泉名叫隐．哈歌利（“隐．哈歌利”意即“呼求者之泉”），那泉直到今日还在利希。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG15_20","008_15_20","JDG","15","20","20","在非利士人统治的日子，参孙治理以色列人二十年。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG16_1","008_16_1","JDG","16","1","1","参孙往迦萨去，在那里看见一个妓女，就进去与她亲近。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG16_2","008_16_2","JDG","16","2","2","有人告诉迦萨人说：“参孙到这里来了。”他们就把他围住，整夜在城门口埋伏着，整夜默不作声，心里说：“等到早晨天亮，我们才杀他。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG16_3","008_16_3","JDG","16","3","3","参孙睡到半夜，就在半夜起来，抓紧城门的门扇和两边门柱，把它们与门闩一起拔起来，放在自己的肩头上，扛到希伯仑对面的山顶去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG16_4","008_16_4","JDG","16","4","4","后来参孙在梭烈谷又爱上了一个妇人，名叫大利拉。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG16_5","008_16_5","JDG","16","5","5","非利士人的领袖上到妇人那里去，对她说：“请你引诱他，看看他因什么缘故有这样大的力气，我们用什么方法才能胜过他，把他捆绑，好制伏他；我们每人就给你十二公斤银子。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG16_6","008_16_6","JDG","16","6","6","大利拉对参孙说：“求你告诉我，你因什么缘故有这样大的力气，要用什么方法才能捆绑你，好把你制伏。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG16_7","008_16_7","JDG","16","7","7","参孙对她说：“如果人用七条未干的青绳子捆绑我，我就会软弱无力，像平常人一样。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG16_8","008_16_8","JDG","16","8","8","于是非利士人的领袖把七条未干的青绳子，带上来给那妇人，她就用那些绳子把参孙捆绑起来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG16_9","008_16_9","JDG","16","9","9","有人埋伏在她的内室里等候着；她对参孙说：“参孙哪，非利士人上来捉你了！”参孙就挣断绳子，像麻线被火烧断一样。这样，他力气的由来，还是没有人知道。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG16_10","008_16_10","JDG","16","10","10","大利拉对参孙说：“你作弄我，向我说谎；现在求你告诉我，用什么东西才能把你捆绑。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG16_11","008_16_11","JDG","16","11","11","参孙对她说：“如果人用从未使用过的新绳子把我紧紧地捆绑起来，我就软弱无力，像平常人一样。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG16_12","008_16_12","JDG","16","12","12","于是大利拉把新绳子拿了来，把参孙捆绑了，对他说：“参孙哪，非利士人上来捉你了！”当时有人埋伏在她的内室里等候着。参孙把绳子从手臂上挣断下来，像挣断一根线一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG16_13","008_16_13","JDG","16","13","13","大利拉对参孙说：“到现在你还是作弄我，向我说谎；求你告诉我，人怎样才能捆绑你。”参孙对她说：“如果你把我头上的七条发辫与织布机上的纬线编织在一起就可以了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG16_14","008_16_14","JDG","16","14","14","于是大利拉把他的发辫与织布机上的纬线同织在一起，再用木橛钉紧，对参孙说：“参孙哪，非利士人上来捉你了！”参孙从睡梦中醒来，竟把织布机上的木橛，和纬线都拔了出来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG16_15","008_16_15","JDG","16","15","15","大利拉对参孙说：“你既然对我不真心，你怎能说：‘我爱你’？你这三次作弄我，没有告诉我你这么大的力气是哪里来的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG16_16","008_16_16","JDG","16","16","16","大利拉天天用话逼他，催他，以致他的心烦得要死。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG16_17","008_16_17","JDG","16","17","17","参孙就把他心中的一切告诉了她，对她说：“向来没有人用剃刀剃过我的头，因为我自出母胎就归　神作拿细耳人，如果人剃去我的头发，我的力气就离开了我，我就软弱无力，像所有人一样。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG16_18","008_16_18","JDG","16","18","18","大利拉见参孙把心中的一切都告诉了她，就派人去请非利士人的领袖来，说：“这一次你们上来吧！因为他已经把心中的一切都告诉了我。”于是非利士人的领袖上到妇人那里，手里带着银子上去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG16_19","008_16_19","JDG","16","19","19","大利拉使参孙睡在自己的膝上，又叫了一个人来，把参孙头上的七条发辫都剃去；大利拉就克制了他，因他的力气离开了他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG16_20","008_16_20","JDG","16","20","20","大利拉说：“参孙哪，非利士人上来捉你了！”参孙从睡梦中醒来，心里说：“我要像前几次一样挣扎出去，必能脱身。”但他不知道耶和华已经离开他了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG16_21","008_16_21","JDG","16","21","21","非利士人把他捉住，剜去了他的眼睛，带他下到迦萨，用铜链捆绑着他，他就在监牢里推磨。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG16_22","008_16_22","JDG","16","22","22","但是他的头发被剃去以后，又开始生长起来了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG16_23","008_16_23","JDG","16","23","23","非利士人的领袖聚集起来，要给他们的神大衮献大祭，并且欢乐庆祝；他们说：“我们的神把我们的仇敌参孙交在我们手中了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG16_24","008_16_24","JDG","16","24","24","众人看见了参孙，就赞美他们的神，说：“我们的神把我们的仇敌，就是那毁坏我们的地，又杀死我们很多人的，交在我们手中了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG16_25","008_16_25","JDG","16","25","25","他们心里正在高兴的时候，就说：“叫参孙来，给我们耍耍把戏。”于是有人把参孙从监牢里叫出来；参孙就在他们面前耍把戏，他们又把他放在两根柱子中间。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG16_26","008_16_26","JDG","16","26","26","参孙对拉着他手的童子说：“请你让我摸摸支撑着这庙宇的柱子，我要在柱子上靠一靠。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG16_27","008_16_27","JDG","16","27","27","那时房子里满了男男女女，非利士人的领袖也在那里；在房子的平顶上约有三千男女，都在观看参孙耍把戏。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG16_28","008_16_28","JDG","16","28","28","参孙呼求耶和华，说：“主耶和华啊，求你记念我；　神啊，求你加强我这一次的力量，只这一次罢了，使我尽一次在非利士人身上报那剜我双眼的仇！” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG16_29","008_16_29","JDG","16","29","29","参孙就抱住那支撑着房子中间的两根柱子，右手抱一根，左手抱一根。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG16_30","008_16_30","JDG","16","30","30","然后参孙说：“让我与非利士人同归于尽吧！”于是尽力屈身，房子就倒塌，压在众领袖和房子里所有的人身上。这样，参孙死的时候杀死的人，比他活着的时候杀死的人还多。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG16_31","008_16_31","JDG","16","31","31","参孙的众兄弟和他父亲的全家都下来，收殓他的尸体，把他抬上去，埋葬在琐拉和以实陶之间，在他父亲玛挪亚的坟墓里。参孙治理了以色列人二十年。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG17_1","008_17_1","JDG","17","1","1","以法莲山地有一个人，名叫米迦。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG17_2","008_17_2","JDG","17","2","2","他对自己的母亲说：“你那十二公斤银子被人拿去了，关于这事你曾说了咒诅的话，我也亲自听见了。看哪！那些银子在我这里，是我拿去了。”他母亲说：“愿我儿蒙耶和华赐福。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG17_3","008_17_3","JDG","17","3","3","米迦就把那十二公斤银子归还给他母亲；他母亲说：“我把这些银子从我手中分别为圣，为我的儿子归给耶和华，好做一个雕像，一个铸像；现在，我要还给你。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG17_4","008_17_4","JDG","17","4","4","米迦把银子还给他母亲以后，他母亲取出二千三百克银子交给银匠，制造一个雕像和一个铸像，都放在米迦的家里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG17_5","008_17_5","JDG","17","5","5","米迦这人有一间神庙，又制造以弗得和家中的神像，并且立了他的一个儿子作祭司。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG17_6","008_17_6","JDG","17","6","6","在那些日子，以色列中没有王，各人都行自己看为对的事。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG17_7","008_17_7","JDG","17","7","7","有一个犹大伯利恒的青年人，是属犹大家族的；他本是个利未人，在那里寄居。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG17_8","008_17_8","JDG","17","8","8","这人离开犹大的伯利恒城，要找一个可以寄居的地方；途中，他到了以法莲山地，米迦的家那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG17_9","008_17_9","JDG","17","9","9","米迦问他：“你是从哪里来的？”他回答米迦：“我是个利未人，是从犹大的伯利恒来的，我来要找一个可以寄居的地方。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG17_10","008_17_10","JDG","17","10","10","米迦对他说：“你与我住在一起吧，作我的师父和祭司；我每年给你一百一十四克银子、一套衣服和食用。”利未人就进了米迦的家。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG17_11","008_17_11","JDG","17","11","11","他同意与那人同住；那人看待这青年人好像自己的一个儿子一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG17_12","008_17_12","JDG","17","12","12","米迦立了这利未青年作他的祭司，住在米迦的家里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG17_13","008_17_13","JDG","17","13","13","米迦说：“现在我知道耶和华必善待我，因为有一个利未人作我的祭司。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG18_1","008_18_1","JDG","18","1","1","在那些日子，以色列中没有王。那时，但支派还在寻找可居住的地业，因为直到那一天，在以色列的众支派中，但支派仍没有得着地业。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG18_2","008_18_2","JDG","18","2","2","于是但人从琐拉和以实陶，差派他们家族中的五个勇士，去窥探查察那地，对他们说：“你们去查察那地吧。”他们来到以法莲山地，进了米迦的家，就在那里住宿。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG18_3","008_18_3","JDG","18","3","3","他们在米迦的家附近，认出那青年利未人的口音来，就过去他那里问他：“谁带你到这里来？你在这里作什么？你在这里有什么？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG18_4","008_18_4","JDG","18","4","4","他回答他们：“米迦如此这般待我；他雇了我，我就作了他的祭司。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG18_5","008_18_5","JDG","18","5","5","他们对他说：“请你求问　神，使我们知道我们要走的道路是否顺利。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG18_6","008_18_6","JDG","18","6","6","祭司对他们说：“你们平安地去吧，你们要走的道路是蒙耶和华悦纳的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG18_7","008_18_7","JDG","18","7","7","于是那五个人离开了，来到拉亿，看见那里的人民安然居住，好像西顿人一样，生活平静安稳；在那地又没有人掌权，使他们受屈辱；他们离西顿人也很远，也没有与别人来往。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG18_8","008_18_8","JDG","18","8","8","他们回到琐拉和以实陶自己的族人那里去；族人问他们：“你们有什么话说？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG18_9","008_18_9","JDG","18","9","9","他们回答：“起来，我们上去攻击他们吧。因为我们已经看过那地，见那地十分美好，你们还静坐不动吗？不可再迟延，要赶快去取得那地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG18_10","008_18_10","JDG","18","10","10","你们到了那里的时候，你们必遇见安然居住的人民；那地的两边宽阔，　神已经把那地交在你们手里；那地百物俱全，一无所缺。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG18_11","008_18_11","JDG","18","11","11","于是但人的家族中有六百人，带着兵器从那里出发，就是从琐拉和以实陶出发。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG18_12","008_18_12","JDG","18","12","12","他们上去，在犹大的基列．耶琳安营；因此人把那地方叫作玛哈尼．但（“玛哈尼．但”意即“但的军营”），直到现在；这地方是在基列．耶琳的西边。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG18_13","008_18_13","JDG","18","13","13","他们从那里经过，往以法莲山地去，来到米迦的家。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG18_14","008_18_14","JDG","18","14","14","从前去窥探拉亿地的五个人，对他们的族人说：“这些屋子里有以弗得、神像、雕像和铸像，你们知道吗？现在你们要考虑一下应该怎样行。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG18_15","008_18_15","JDG","18","15","15","于是他们五人转身，进入米迦的家，来到那青年利未人的屋里，向他问安。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG18_16","008_18_16","JDG","18","16","16","那六百但人，带着兵器，都站在门口。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG18_17","008_18_17","JDG","18","17","17","从前去窥探那地的五个人上前，进入里面，把雕像、以弗得、神像和铸像都拿去了；祭司和带着兵器的六百人都站在门口。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG18_18","008_18_18","JDG","18","18","18","当那五个人进了米迦的家，拿走雕像、以弗得、神像和铸像的时候，祭司就问他们：“你们作什么呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG18_19","008_18_19","JDG","18","19","19","他们回答他：“不要出声，用手掩着你的嘴，跟我们走吧，好作我们的师父和祭司。你作一家的祭司好呢？还是作以色列中一个支派一个家族的祭司好呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG18_20","008_18_20","JDG","18","20","20","祭司心里高兴，就拿着以弗得、神像和雕像，来到众人中间。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG18_21","008_18_21","JDG","18","21","21","他们就转身离去，把妇孺和牲畜，以及财物，都放在前面。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG18_22","008_18_22","JDG","18","22","22","他们离开米迦的家很远的时候，在米迦的家附近各家的人，都被召集出来，去追赶但人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG18_23","008_18_23","JDG","18","23","23","他们呼叫但人；但人转过脸来，问米迦：“你召集了这么多人出来作什么？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG18_24","008_18_24","JDG","18","24","24","米迦回答：“你们把我所做的神像和我的祭司都带走了，我还有什么呢？你们怎么还问我：‘你作什么’呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG18_25","008_18_25","JDG","18","25","25","但人对米迦说：“不要再让我们听见你的声音，恐怕有暴躁的人攻击你们，以致你和你全家尽都丧失性命。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG18_26","008_18_26","JDG","18","26","26","但人继续走他们的路；米迦见他们比自己强，就转身回自己的家去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG18_27","008_18_27","JDG","18","27","27","但人把米迦所做的神像和他的祭司都带走，他们来到拉亿，去到平静安居的人民那里，就用刀剑击杀了他们，又用火烧了那城。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG18_28","008_18_28","JDG","18","28","28","没有人搭救，因为离西顿很远，他们又与别人没有来往。这城位于靠近伯．利合的山谷中。但人重建那城，住在其中。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG18_29","008_18_29","JDG","18","29","29","按着他们的祖宗，以色列所生的儿子但的名字，给那城起名叫但；其实那城原先的名字叫拉亿。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG18_30","008_18_30","JDG","18","30","30","但人就为自己把那雕像立起来；摩西的孙子、革顺的儿子约拿单和他的子孙，都作了但支派的祭司，直到那地遭受掳掠的日子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG18_31","008_18_31","JDG","18","31","31","神的殿在示罗有多少日子，但人为自己设立米迦所做的雕像也有多少日子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG19_1","008_19_1","JDG","19","1","1","在以色列中没有王的日子，有一个利未人寄居在以法莲山地的偏远地区；他从犹大的伯利恒给自己娶了一个女子作妾。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG19_2","008_19_2","JDG","19","2","2","他的妾背夫行淫，离开丈夫，回到犹大的伯利恒她父亲的家那里去了，在那里住了四个月的日子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG19_3","008_19_3","JDG","19","3","3","她的丈夫起来，带着一个仆人和两头驴去追她，用话打动她的心，叫她回来。她把丈夫带到自己父家，那少女的父亲见了那人，就欢欢喜喜迎接他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG19_4","008_19_4","JDG","19","4","4","那人的岳父，就是女子的父亲，强留那人，那人就与他同住了三天；他们一起吃喝，在那里住宿。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG19_5","008_19_5","JDG","19","5","5","到了第四天，他们清早起来，那人起身要走；那女子的父亲对女婿说：“请吃点饼增添心力，然后再走。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG19_6","008_19_6","JDG","19","6","6","于是二人坐下，一起吃喝；女子的父亲对那人说：“请你答应再过一夜，畅快你的心。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG19_7","008_19_7","JDG","19","7","7","那人起来要走，他的岳父强留他，他又在那里过了一夜。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG19_8","008_19_8","JDG","19","8","8","到了第五天，他清早起来要走；那女子的父亲说：“请吃点饼增添心力，等到日头西斜再走吧。”于是他们耽延，直到日头西斜；二人一同吃饭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG19_9","008_19_9","JDG","19","9","9","那人和他的妾，以及他的仆人起来要走的时候，他的岳父，就是那女子的父亲，对他说：“看哪，天快晚了！请再住一夜。看哪，日头西斜了！请在这里再住一夜，畅快你的心；明天可以清早起来，上路回家去。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG19_10","008_19_10","JDG","19","10","10","那人不愿再住一夜，就带着自己的妾和两头备好了的驴，起来走了，来到耶布斯对面；耶布斯就是耶路撒冷。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG19_11","008_19_11","JDG","19","11","11","他们走近耶布斯的时候，日头快要落了；仆人对主人说：“来，让我们转到这耶布斯人的城去，好在那里住宿。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG19_12","008_19_12","JDG","19","12","12","主人对他说：“我们不可转到这座不是以色列人居住的外族人的城里去，我们过到基比亚去吧。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG19_13","008_19_13","JDG","19","13","13","又对他的仆人说：“来吧，我们可以到这些地方其中一个去投宿，或在基比亚或在拉玛。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG19_14","008_19_14","JDG","19","14","14","于是他们走路过去；他们走近便雅悯人的基比亚的时候，日头已经落了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG19_15","008_19_15","JDG","19","15","15","他们从那里转身，要进基比亚去住宿；他们进去，坐在城里的广场上，因为没有人接待他们到家里去住宿。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG19_16","008_19_16","JDG","19","16","16","到晚上，有一个老年人从田间工作回来；那人原是以法莲山地的人，寄居在基比亚；那地方的人却是便雅悯人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG19_17","008_19_17","JDG","19","17","17","那老年人举目，看见那个旅客在城里的广场上，就问他：“你要到哪里去？你从哪里来？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG19_18","008_19_18","JDG","19","18","18","利未人回答他：“我们是从犹大的伯利恒过来的，要到以法莲山地的偏远地区去，我原是那地方的人；我去过犹大的伯利恒，现在我要到我的家去（“到我的家去”原文作“到耶和华的殿去”），但没有人接待我到家里去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG19_19","008_19_19","JDG","19","19","19","其实我有粮草、有饲料，可以喂驴；我和我的妾，以及与你的仆人在一起的那个青年人，都有饼和酒吃喝，一无所缺。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG19_20","008_19_20","JDG","19","20","20","那老年人说：“愿你平安，你所缺乏的，由我负责好了；只是不可在广场上过夜。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG19_21","008_19_21","JDG","19","21","21","于是把他领到自己的家里，用饲料喂了驴，他们洗了脚，就吃喝起来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG19_22","008_19_22","JDG","19","22","22","他们心里正畅快的时候，忽然城里有些无赖之徒，围绕房子，不住地敲门，对老房主说：“把进入你家的那个人带出来，我们要与他交合。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG19_23","008_19_23","JDG","19","23","23","那房主出来见他们，对他们说：“我的众兄弟啊，不可这样，请你们不要作恶；这人既然进了我的家，你们就不要作这羞耻的事。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG19_24","008_19_24","JDG","19","24","24","这里有我的女儿，还是处女，并且有这人的妾，我把她们领出来，让你们污辱她们；你们看怎样好，就怎样待她们吧。只是对这个人，你们却不要作这羞耻的事。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG19_25","008_19_25","JDG","19","25","25","那些人却不肯听从他的话，那人就抓住自己的妾，拉出外边去交给他们，他们就与她交合，整夜污辱她；直到早晨，天色破晓的时候，才放她走。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG19_26","008_19_26","JDG","19","26","26","天快亮的时候，那女子回到留她主人住宿的那人的房子门口，就仆倒在那里，直到天亮。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG19_27","008_19_27","JDG","19","27","27","到早晨，她的主人起来，开了房门，出去要上路的时候，就看见那妇人，就是他的妾，仆倒在门口，她的双手搭在门槛上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG19_28","008_19_28","JDG","19","28","28","他对那妇人说：“起来，我们走吧！”可是却没有回答。那人就把她驮在驴上，起程回自己的地方去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG19_29","008_19_29","JDG","19","29","29","他到了家里，就拿起刀来，抓住自己的妾，把她的肢体切成十二块，叫人送到以色列的全境去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG19_30","008_19_30","JDG","19","30","30","看见的人都说：“自从以色列人从埃及地上来的日子，直到今日，这样的事并没有发生过，也没有看见过；你们要思想，要商议，要讨论。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG20_1","008_20_1","JDG","20","1","1","于是以色列众人都出来，从但到别是巴，以及基列地的众人，都在米斯巴耶和华面前聚集起来如同一人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG20_2","008_20_2","JDG","20","2","2","全民的领袖，就是以色列众支派的领袖，都站在　神子民的会中；拿刀的步兵共有四十万人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG20_3","008_20_3","JDG","20","3","3","（以色列人上到米斯巴来，便雅悯人听见了。）以色列人说：“这件恶事是怎样发生的？你们说吧。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG20_4","008_20_4","JDG","20","4","4","那利未人，就是被害的妇人的丈夫，回答说：“我和我的妾到了便雅悯的基比亚，要在那里住宿。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG20_5","008_20_5","JDG","20","5","5","基比亚人民起来攻击我，在夜间包围我住的房子攻击我，有意杀害我；他们把我的妾污辱致死。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG20_6","008_20_6","JDG","20","6","6","我就把我的妾切成块子，送到以色列的各地业，因为基比亚人在以色列中行了极羞耻的恶事。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG20_7","008_20_7","JDG","20","7","7","以色列人哪，你们都要说出你们的意见，也要在这里提出你们的对策。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG20_8","008_20_8","JDG","20","8","8","于是众人都起来如同一人，说：“我们当中谁都不回自己的帐棚，谁都不回自己的家。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG20_9","008_20_9","JDG","20","9","9","现在我们要这样对待基比亚人：我们要照着所抽的签上去攻打他们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG20_10","008_20_10","JDG","20","10","10","我们要从以色列各支派中，每百人抽取十人，每千人抽取百人，每万人抽取千人，好为人民运送粮食；等他们到了便雅悯的基比亚的时候，就可以照着他们在以色列中所行的一切羞耻的事惩罚他们。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG20_11","008_20_11","JDG","20","11","11","于是以色列众人彼此联合，如同一人，聚集起来攻击那城。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG20_12","008_20_12","JDG","20","12","12","以色列各支派打发人到便雅悯的各家去，说：“你们中间怎么发生了这样的恶事呢？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG20_13","008_20_13","JDG","20","13","13","现在你们要把那些人，基比亚的无赖之徒，交出来，我们好处死他们，从以色列中除掉这恶。”只是便雅悯人却不肯听从他们的兄弟以色列人的话。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG20_14","008_20_14","JDG","20","14","14","便雅悯人从各城出来聚集，往基比亚去，要与以色列人交战。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG20_15","008_20_15","JDG","20","15","15","那时便雅悯人，从各城里被数点的，共有二万六千拿刀的，另外被数点的，还有基比亚的居民，共有七百精兵。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG20_16","008_20_16","JDG","20","16","16","在这些人中，还有七百精兵是善用左手的，个个都能用机弦拋石，毫发不差。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG20_17","008_20_17","JDG","20","17","17","除了便雅悯人以外，以色列人被数点的，共有四十万拿刀的，个个都是战士。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG20_18","008_20_18","JDG","20","18","18","以色列人就起来，上伯特利去求问　神，说：“我们之中谁应首先上去，与便雅悯人交战呢？”耶和华说：“犹大应首先上去。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG20_19","008_20_19","JDG","20","19","19","以色列人早晨起来，对着基比亚安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG20_20","008_20_20","JDG","20","20","20","以色列人出来，要与便雅悯人交战；以色列人在基比亚面前列阵等待他们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG20_21","008_20_21","JDG","20","21","21","便雅悯人从基比亚出来，那一天使二万二千以色列人倒地身亡。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG20_22","008_20_22","JDG","20","22","22","众民，就是以色列人，都奋勇起来，又在头一天列阵的地方列阵。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG20_23","008_20_23","JDG","20","23","23","事前，以色列人上伯特利去，在耶和华面前哀哭直到晚上，然后求问耶和华，说：“我们再去与我们的兄弟便雅悯人交战，可以不可以？”耶和华说：“你们可以上去攻打他们。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG20_24","008_20_24","JDG","20","24","24","第二天，以色列人就前去攻打便雅悯人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG20_25","008_20_25","JDG","20","25","25","便雅悯人第二天也从基比亚出来，迎战以色列人，又使一万八千以色列人倒地身亡，都是拿刀的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG20_26","008_20_26","JDG","20","26","26","以色列众人，就是全体人民，又上到伯特利，坐在耶和华面前哀哭，那日禁食直到晚上，然后在耶和华面前献上燔祭和平安祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG20_27","008_20_27","JDG","20","27","27","那时，　神的约柜在那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG20_28","008_20_28","JDG","20","28","28","那时，亚伦的孙子、以利亚撒的儿子非尼哈，侍立在约柜前供职。以色列人求问耶和华，说：“我们应再出去与我们的兄弟便雅悯人交战呢？还是休战呢？”耶和华说：“你们应上去，因为明天我必把他们交在你们手中。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG20_29","008_20_29","JDG","20","29","29","以色列人在基比亚四周设下伏兵。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG20_30","008_20_30","JDG","20","30","30","第三天，以色列人又上去攻打便雅悯人，在基比亚前面列阵，像前两次一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG20_31","008_20_31","JDG","20","31","31","便雅悯人也出来迎敌，他们被引出城外，在两条大路上，一条通往伯特利，一条通往基比亚，像前两次一样，动手杀敌，在田间杀死以色列人约有三十个。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG20_32","008_20_32","JDG","20","32","32","便雅悯人说：“他们仍像前一次一样，败在我们面前了。”以色列人却说：“我们逃跑吧，引他们离开城市出到大路上来。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG20_33","008_20_33","JDG","20","33","33","以色列众人都从自己的地方起来，在巴力．他玛列阵；以色列的伏兵，从基比亚西边埋伏的地方冲出来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG20_34","008_20_34","JDG","20","34","34","全以色列中的精兵，有一万人前来攻打基比亚，战争非常激烈；便雅悯人还不知道灾祸快要临到他们的身上了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG20_35","008_20_35","JDG","20","35","35","耶和华在以色列人面前击败了便雅悯人；那天以色列人消灭便雅悯人，共二万五千一百名，都是拿刀的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG20_36","008_20_36","JDG","20","36","36","这样，便雅悯人就看出自己被击败了。原来以色列人倚靠在基比亚前面设下的伏兵，就对便雅悯人诈败。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG20_37","008_20_37","JDG","20","37","37","伏兵急忙冲入基比亚，用刀击杀了全城的人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG20_38","008_20_38","JDG","20","38","38","以色列人与伏兵预先约定，就是从城里放火，以烟气上升为号。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG20_39","008_20_39","JDG","20","39","39","以色列人在战场上撤退的时候，便雅悯人就动手杀人，刺死以色列人约三十个，心里说：“他们真的像头一次战阵一样，在我们面前被击败了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG20_40","008_20_40","JDG","20","40","40","当烟柱信号从城中上升的时候，便雅悯人就转身观看，只见全城烟火冲天。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG20_41","008_20_41","JDG","20","41","41","那时，以色列人又转身回来，便雅悯人就非常惊慌，因为看见灾祸临到自己身上了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG20_42","008_20_42","JDG","20","42","42","他们在以色列人面前转身，向旷野的路上逃走，战争却紧随着他们；那些从各城里出来的人也在他们中间消灭他们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG20_43","008_20_43","JDG","20","43","43","以色列人包围了便雅悯人，追赶他们，在他们歇息之地，直到基比亚对面日出之处，践踏他们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG20_44","008_20_44","JDG","20","44","44","便雅悯人中倒毙的共有一万八千人，全都是勇士。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG20_45","008_20_45","JDG","20","45","45","其余的人转身，向着旷野逃跑，到了临门的磐石那里；以色列人在大路上除灭了他们五千人，追赶他们直到基顿，又击杀了他们二千人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG20_46","008_20_46","JDG","20","46","46","所以那一天便雅悯人倒毙的，共有二万五千人，都是拿刀的，全部是勇士。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG20_47","008_20_47","JDG","20","47","47","剩下的六百人转身，向着旷野逃跑，到了临门的磐石那里，就在临门的磐石那里住了四个月。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG20_48","008_20_48","JDG","20","48","48","以色列人又回到便雅悯人那里，把全城的人和牲畜，以及一切遇见的，都用刀杀尽；又把他们碰见的一切城市放火烧毁了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG21_1","008_21_1","JDG","21","1","1","以色列人在米斯巴曾经起誓说：“我们中间不可有人把自己的女儿嫁给便雅悯人作妻子。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG21_2","008_21_2","JDG","21","2","2","众人来到伯特利，在那里坐在　神面前直到晚上，放声大哭， ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG21_3","008_21_3","JDG","21","3","3","说：“耶和华以色列的　神啊，今日以色列中缺少了一个支派，为什么在以色列中发生这事呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG21_4","008_21_4","JDG","21","4","4","次日，众人清早起来，在那里筑了一座祭坛，献上燔祭和平安祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG21_5","008_21_5","JDG","21","5","5","以色列人彼此说：“以色列各支派中，谁没有与会众上到耶和华面前来呢？”因为他们曾经起过很严厉的誓，说：“不上米斯巴到耶和华面前的，必把他处死。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG21_6","008_21_6","JDG","21","6","6","以色列人为他们的兄弟便雅悯难过，说：“今天以色列中有一个支派被剪除了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG21_7","008_21_7","JDG","21","7","7","我们曾经指着耶和华起过誓，必不把我们的女儿给便雅悯人作妻子，那么现在我们当怎样办理，使他们剩下的人有妻子呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG21_8","008_21_8","JDG","21","8","8","他们又彼此问：“以色列各支派中，有谁没有上米斯巴到耶和华面前来的呢？”他们就发现基列．雅比中没有一人去到营中会众那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG21_9","008_21_9","JDG","21","9","9","众人被数点的时候，就发现基列．雅比的居民中没有一人在那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG21_10","008_21_10","JDG","21","10","10","因此会众从勇士中差派一万二千人到那里去，吩咐他们说：“你们去用刀击杀基列．雅比的居民，连妇女与孩子都要杀。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG21_11","008_21_11","JDG","21","11","11","你们要这样行，你们要把所有的男子，和所有与男子同过房的女子，完全毁灭。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG21_12","008_21_12","JDG","21","12","12","他们在基列．雅比的居民中，找到了四百个未曾与人同房，也未曾与男子同寝的年轻少女，就把她们带到迦南地的示罗营那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG21_13","008_21_13","JDG","21","13","13","全体会众又派人到临门的磐石那里，对便雅悯人说话，向他们宣告和平。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG21_14","008_21_14","JDG","21","14","14","那时便雅悯人回来了，以色列人就把他们保留的基列．雅比的女子给他们作妻子，但还是不够。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG21_15","008_21_15","JDG","21","15","15","众人为便雅悯人难过，因为耶和华使以色列众支派中有了缺口。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG21_16","008_21_16","JDG","21","16","16","会众中的长老说：“便雅悯的女子既然都被除灭了，我们应怎样行，使那些余下的人有妻子呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG21_17","008_21_17","JDG","21","17","17","又说：“便雅悯逃脱的人应有地业，免得有个支派从以色列中被消灭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG21_18","008_21_18","JDG","21","18","18","但是我们不能把我们自己的女儿给他们作妻子。”因为以色列人曾经起誓说：“把女儿给便雅悯人作妻子的，是可咒诅的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG21_19","008_21_19","JDG","21","19","19","他们又说：“看哪，每年在示罗都举行耶和华的节期；示罗就是在伯特利的北面，从伯特利上示剑的大路的东面，在利波拿的南面。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG21_20","008_21_20","JDG","21","20","20","于是他们吩咐便雅悯人说：“你们去在葡萄园中设下埋伏； ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG21_21","008_21_21","JDG","21","21","21","在那里观看，示罗的女子出来跳舞的时候，你们就从葡萄园出来，从示罗的女子中，各抢一个作妻子，然后回便雅悯地去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG21_22","008_21_22","JDG","21","22","22","如果她们的父亲或是兄弟来与我们争论，我们就对他们说：‘求你们恩待他们吧，因为我们在战场上没有给他们留下女子作妻子，而且这次又不是你们把女儿给他们；若是你们给的，你们就有罪了。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG21_23","008_21_23","JDG","21","23","23","于是便雅悯人照样行了：按着他们的数目，从跳舞的女子中强抢她们作妻子，然后离开那里，回到自己的地业去，重建城市，住在其中。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG21_24","008_21_24","JDG","21","24","24","那时，以色列人离开那里，各人回到自己的支派和自己的家族去；他们离开那里，各人回到自己的地业去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("JG21_25","008_21_25","JDG","21","25","25","在那些日子，以色列中没有王，各人都行自己看为对的事。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","在士师统治期间，国内发生了饥荒。有一个人带着妻子和两个儿子，从犹大的伯利恒前往摩押地去，寄居在那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","这个人名叫以利米勒，妻子名叫拿俄米，两个儿子叫玛伦和基连，都是犹大伯利恒的以法他人。他们到了摩押地，就在那里住下来了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","后来拿俄米的丈夫以利米勒去世了，留下她和两个儿子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","他们娶了摩押女子作妻子，一个名叫俄耳巴，一个名叫路得。他们在那里住了约有十年。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","后来，玛伦和基连二人也死了，留下拿俄米，既没有了两个儿子，又没有了丈夫。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","拿俄米还在摩押地的时候，因为听说耶和华眷顾他的子民，赐粮食给他们，就带着两个媳妇动身从摩押地回来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","她离开居住的地方，两个媳妇也随她出发，要回到犹大地去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","拿俄米对两个媳妇说：“去吧，你们还是各自回娘家吧。愿耶和华恩待你们，像你们善待已死的人和我一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","愿耶和华使你们各人有机会再嫁（“有机会再嫁”原文作“在丈夫家里”），找到归宿。”跟着亲吻她们，她们就发声大哭， ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","说：“不，我们一定要跟你一起回到你同胞那里去。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","拿俄米说：“我女儿啊，你们回去吧，为什么要跟我去呢？我肚子里还有儿子作你们的丈夫吗？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","走吧，我女儿啊，你们回去吧，因为我太老，不能嫁人了，就算我说我还有希望今天晚上有个丈夫，又生儿子， ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","你们可以等到他们长大吗？你们可以为他们守节而不嫁人吗？不行，我女儿啊，我为你们非常难过，因为耶和华伸手对付我。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","她们又放声大哭。俄耳巴就和婆婆吻别，路得却舍不得离开拿俄米。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","拿俄米说：“你看，你嫂嫂已经回到她同胞和她的神那里去了。你也跟着嫂嫂回去吧。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","路得说：“请不要逼我离开你回去，不跟从你。你到哪里去，我也要到哪里去；你在哪里过夜，我也要在哪里过夜；你的同胞就是我的同胞，你的　神就是我的　神； ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","你死在哪里，我也要死在哪里，葬在哪里。除非死亡把你我分离；如果我离开你，愿耶和华加倍惩罚我。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","拿俄米看路得坚决要跟她走，就不再多费唇舌了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","她们双双上路，来到伯利恒。她们到达的时候，全城都因她们的缘故骚动起来。妇女们说：“这是拿俄米吗？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","拿俄米对她们说：“不要叫我拿俄米，叫我玛拉吧，因为全能者使我吃尽了苦头。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","我满满地出去，耶和华却使我空空地回来，你们为什么还叫我拿俄米呢？耶和华折磨我，全能者加害于我。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","拿俄米就这样回来了。她媳妇摩押女子路得随着她从摩押地回来。她们到达伯利恒，正是开始收割大麦的时候。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","拿俄米的丈夫以利米勒有个同族的亲戚，名叫波阿斯，是个大财主。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","摩押女子路得对拿俄米说：“让我到田里去，我在谁的眼前蒙恩，我就跟在谁的背后捡麦穗。”拿俄米说：“女儿啊，你尽管去。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","路得就去了，来到田里，在收割的人背后捡麦穗。她恰巧来到以利米勒同族的人波阿斯那块田。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","波阿斯刚好从伯利恒来，对收割的人说：“愿耶和华与你们同在。”他们回答：“愿耶和华赐福与你。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","波阿斯问那监督收割的仆人：“那是谁家的姑娘呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","监督收割的仆人回答：“她是跟拿俄米从摩押地回来的摩押女子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","她说：‘请让我捡一点麦穗吧。让我跟在收割的人背后，在禾捆堆中捡些零碎的穗子。’于是她来了。除了在房子里休息了一会儿之外，从早晨到现在一直都留在这里。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","波阿斯对路得说：“女儿啊，听我说，不要到别人田里去捡麦穗，也不要离开这里，要常常与我的女佣人在一起。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","你看他们在哪块田里收割，就跟着女佣人去。我不是已经吩咐仆人不可欺负你吗？假如你渴了，就到水缸那里去，喝仆人打来的水。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","路得就俯伏在地叩拜，对他说：“我是个外族人，为什么会在你眼前蒙恩，蒙你关照呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","波阿斯回答她说：“自从你丈夫去世以后，你对婆婆所行的，和你怎样离开父母与出生之地，来到素来不认识的人中间，这一切我都知道得很清楚了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","愿耶和华照你所作的报答你；你来投靠在耶和华以色列　神的翅膀下，愿他充充足足酬报你。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","路得说：“主人啊，但愿我在你眼前蒙恩，虽然我连你的婢女都不是，你还是安慰我，对我这么好。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","到了吃饭的时候，波阿斯对路得说：“你过来，吃一点饼吧，拿饼块蘸在醋里。”路得就在收割的人旁边坐下来。波阿斯把一些烘好的麦穗递给她，她吃饱了，还有剩下的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","她再起来去捡麦穗的时候，波阿斯吩咐仆人说：“就算她在禾捆堆中捡麦穗，也不可以辱骂她。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","甚至要故意为她从禾捆中抽些出来，留给她去捡，千万不可责备她。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","路得就这样在田里捡麦穗，直到傍晚。她把捡来的麦穗打了，约有二十二公升大麦， ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","然后带回城里去。路得把捡来的麦子拿给婆婆看，把吃剩的给了婆婆。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","婆婆问她：“你今天在哪里捡麦穗？在哪里工作呢？愿那关照你的人蒙福。”路得就告诉婆婆她在谁那里工作，说：“我今天在一个名叫波阿斯的人那里工作。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","拿俄米对媳妇说：“愿不断施慈爱给活人和死人的耶和华赐福给他。”拿俄米又对她说：“这个人是我们的亲人，有买赎权的一位近亲。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","摩押女子路得说：“他还告诉我：‘紧跟着我的仆人捡麦穗，直到全部收割完毕。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","拿俄米对媳妇路得说：“我女儿啊，这样才好，要与他的女佣人一起去，免得在别人的田里遭受敌视。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","她就紧跟着波阿斯的女佣人捡麦穗，直到大麦和小麦都收割好了。路得一直与婆婆住在一起。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","路得的婆婆拿俄米对她说：“女儿啊，我不是应当为你找个归宿，使你得到幸福吗？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","你常常和他的女佣人在一起的波阿斯不是我们的亲戚吗？他今天晚上要在禾场上簸大麦。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","你洗个澡，抹上香膏，穿上斗篷，就下到禾场去。不过，那个人还没有吃喝完毕，别让他认出你来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","等到他躺下来，你要弄清楚他所躺的地方，进去掀露他的脚，然后躺下去。他就会告诉你该作什么。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","路得对她说：“你吩咐的，我就去作。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","于是，她下到禾场去，照着婆婆吩咐的一切去作。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","波阿斯吃喝完了，心里舒畅，就去躺在麦堆的旁边。路得悄悄地来，掀露他的脚，躺卧下去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","到了夜半，波阿斯惊醒过来，一翻身就看到一个女子躺在他的脚边， ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","就说：“你是谁？”她回答：“我是你的婢女路得，请用你的衣襟遮盖你的婢女，因为你是我的有买赎权的近亲。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","波阿斯说：“我女儿，愿你蒙耶和华赐福。你末后表现的爱心比起初更大，因为年轻人无论贫富，你都没有跟从。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","我女儿，现在你不要怕，你所说的，我一定去作。本城的人都知道你是个贤慧的女人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","不错，我是你那有买赎权的近亲，可惜还有一个有买赎权的近亲比我更亲。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","今晚你就在这里过夜，明早如果他肯尽买赎你的本分，好，就由他来履行；假如他不愿意这样作，我指着永活的耶和华起誓，我一定尽买赎你的本分。你只管躺到天亮吧。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","路得躺在波阿斯脚边直到早晨。因为波阿斯说过不可以让人知道有女人来过禾场，路得就趁天色未明，人们彼此无法辨认的时候就起来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","他又说：“拿你所披的外衣来，把它打开。”她打开了，他就量了六簸箕大麦，放在她的肩上。路得就进城去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","到她婆婆那里，婆婆就问：“我女儿，怎样了？”路得就把那人对她所作的一切都告诉了婆婆， ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","又说：“他给我这六簸箕大麦，对我说：‘不要空手去见你婆婆。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","拿俄米说：“我女儿，你尽管安静等候，直到你知道事情怎样了结，因为那人今天不把事情办妥，绝不歇息。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","波阿斯去到城门，坐在那里，波阿斯所说那个有买赎权的近亲刚巧路过那里。波阿斯说：“喂，老兄，过来坐一下吧。”他就过去坐下来了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","波阿斯又邀请城里的十个长老，对他们说：“请坐在这里。”他们就坐下来了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","他对那个有买赎权的近亲说：“从摩押地回来的拿俄米，现在要卖我们族兄以利米勒的那块地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","我想把这一件事告诉你，请你在众民的长老，还有在座的各位面前，把它买下来吧。如果你肯赎就赎，假如不肯，就说出来，让我知道；因为除了你当赎它以外，我是第一候补。”那人说：“我肯赎。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","波阿斯说：“你从拿俄米手中买下那块地的时候，你也得娶（“娶”原文作“买”）已死的人的妻子摩押女子路得，使已死的人的名字留在他的产业上。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","那有买赎权的近亲说：“那我就不能赎它了，只怕损害了我的产业。你可以赎我当赎的，因为我没有办法赎了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","从前在以色列，无论买赎或是交易，决定什么事，当事人就要脱鞋给对方。这是以色列中作证的方式。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","那有买赎权的近亲对波阿斯说：“你自己买下来吧。”就把鞋脱下来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","波阿斯对长老和众人说：“今天你们都是见证人，所有属于以利米勒、基连和玛伦的，我都从拿俄米手中买下来了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","我也娶了（“娶了”原文作“买了”）玛伦的妻子摩押女子路得作妻子，使已死的人的名字留在他的产业上，免得他的名字在本族本乡中除掉。今天你们都是见证人。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","聚集在城门的众人和长老都说：“我们都是见证人。愿耶和华使进你家的这女人，像建立以色列家的拉结和利亚二人一样。愿你在以法他显大，在伯利恒扬名。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","愿耶和华从这少妇赐你后裔，使你的家像他玛从犹大所生法勒斯的家一般。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","于是波阿斯娶了路得作妻子，与她亲近。耶和华使她怀孕生了一个儿子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","妇女对拿俄米说：“耶和华是应当称颂的，因为他今天没有断绝你有买赎权的近亲，愿他在以色列中扬名。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","他必苏醒你的生命，养你的老，因为他是爱你的媳妇所生的；有她比有七个儿子更好。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","拿俄米把孩子接过来，抱在怀中，作他的保姆。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","邻近的妇女要给他起名字，说：“拿俄米生了孩子了。”就给他起名叫俄备得；这俄备得是耶西的父亲，耶西是大卫的父亲。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","以下是法勒斯的后代：法勒斯生希斯仑， ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","希斯仑生兰，兰生亚米拿达， ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","亚米拿达生拿顺，拿顺生撒门， ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","撒门生波阿斯，波阿斯生俄备得， ");
INSERT INTO cmn_ncvs_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","俄备得生耶西，耶西生大卫。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S11_1","010_1_1","1SA","1","1","1","在以法莲山地的拉玛．琐非，有一个以法莲人名叫以利加拿，是耶罗罕的儿子、以利户的孙子、托户的曾孙、苏弗的玄孙。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S11_2","010_1_2","1SA","1","2","2","他有两个妻子，一个名叫哈拿，另一个名叫毗尼拿。毗尼拿有孩子，哈拿却没有孩子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S11_3","010_1_3","1SA","1","3","3","这人每年都从他的本城上示罗去敬拜，献祭给万军之耶和华。在示罗有以利的两个儿子，何弗尼和非尼哈，作耶和华的祭司。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S11_4","010_1_4","1SA","1","4","4","以利加拿在献祭的那天，就把祭肉分给妻子毗尼拿和她所有的儿女。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S11_5","010_1_5","1SA","1","5","5","但他当面只分给哈拿一份；他虽然爱哈拿，耶和华却使哈拿不能怀孕。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S11_6","010_1_6","1SA","1","6","6","因为耶和华使哈拿不能怀孕，她的对头就尽力刺激她，使她苦恼。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S11_7","010_1_7","1SA","1","7","7","年年都是这样；每逢她上耶和华殿的时候，毗尼拿总是刺激哈拿，使她哭泣，吃不下饭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S11_8","010_1_8","1SA","1","8","8","她的丈夫以利加拿对她说：“哈拿，你为什么哭泣？为什么不吃饭，为什么心里难过呢？你有我不是比有十个儿子更好吗？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S11_9","010_1_9","1SA","1","9","9","哈拿在示罗吃喝完了，就起来。（那时以利祭司在耶和华殿的门柱旁边，坐在椅子上。） ");
INSERT INTO cmn_ncvs_vpl VALUES ("S11_10","010_1_10","1SA","1","10","10","她心里愁苦，就向耶和华祷告，流泪痛哭， ");
INSERT INTO cmn_ncvs_vpl VALUES ("S11_11","010_1_11","1SA","1","11","11","并且许愿，说：“万军之耶和华啊，你若是看顾使女的困苦，记念我，不忘记你的使女，赐给使女一个儿子，我就必把他一生献给耶和华，不剃他的头。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S11_12","010_1_12","1SA","1","12","12","哈拿向耶和华祷告了很久，以利一直在注视她的嘴。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S11_13","010_1_13","1SA","1","13","13","原来哈拿是在心中诉说，只见她的嘴唇在动，却听不见她的声音，因此以利以为她是个喝醉了的女人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S11_14","010_1_14","1SA","1","14","14","以利就对她说：“你要醉到几时呢？快快醒过来吧！” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S11_15","010_1_15","1SA","1","15","15","哈拿回答：“我主啊，不是的。我是个心灵愁苦的妇人，淡酒烈酒都没有喝，只不过在耶和华面前倾吐我的心意。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S11_16","010_1_16","1SA","1","16","16","不要把你的使女看作不检点的女子，我因为极度愁苦和激动，才一直倾诉到现在。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S11_17","010_1_17","1SA","1","17","17","以利回答：“平平安安回去吧！愿以色列的　神把你所求的赐给你。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S11_18","010_1_18","1SA","1","18","18","哈拿说：“愿你的婢女在你眼前蒙恩！”于是这妇人回去，并且吃饭，脸上再没有愁容。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S11_19","010_1_19","1SA","1","19","19","第二天，他们清早起来，在耶和华面前敬拜，然后回到他们的家乡拉玛，回到自己的家里去。以利加拿和妻子哈拿同房；耶和华顾念哈拿， ");
INSERT INTO cmn_ncvs_vpl VALUES ("S11_20","010_1_20","1SA","1","20","20","她就怀孕；时候到了，就生了一个儿子，哈拿给他起名叫撒母耳，因为她说：“他是我从耶和华那里求来的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S11_21","010_1_21","1SA","1","21","21","以利加拿和他全家都上示罗去，向耶和华献年祭和还所许的愿； ");
INSERT INTO cmn_ncvs_vpl VALUES ("S11_22","010_1_22","1SA","1","22","22","哈拿却没有上去，因为她对丈夫说：“等孩子断了奶，我才带他去朝见耶和华。他要永远住在那里。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S11_23","010_1_23","1SA","1","23","23","她丈夫以利加拿对她说：“你看怎样好，就怎样作吧。你可以留在这里，等到你给孩子断了奶，但愿耶和华实现他的话。”于是哈拿留在家里乳养孩子，直到给他断了奶。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S11_24","010_1_24","1SA","1","24","24","她给孩子断了奶之后，就带他一同上去，又带了一头三岁的公牛、十公斤面和一皮袋酒。她把孩子带到示罗耶和华的殿那里；那时孩子还很小。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S11_25","010_1_25","1SA","1","25","25","他们宰了公牛以后，就带孩子到以利那里， ");
INSERT INTO cmn_ncvs_vpl VALUES ("S11_26","010_1_26","1SA","1","26","26","妇人说：“我主啊，我敢指着我主的性命起誓，我就是从前在这里站在你旁边，向耶和华祷告的那个妇人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S11_27","010_1_27","1SA","1","27","27","那时我祈求为要得这孩子，耶和华已经把我向他所求的赐给我了， ");
INSERT INTO cmn_ncvs_vpl VALUES ("S11_28","010_1_28","1SA","1","28","28","所以我现在把他献给耶和华，他的一生是属于耶和华的。”于是他就在那里敬拜耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S12_1","010_2_1","1SA","2","1","1","哈拿祷告说：“我的心因耶和华喜乐，我的角因耶和华高举，我的口向仇敌大大夸耀，因为我以你的救恩为乐。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S12_2","010_2_2","1SA","2","2","2","没有人像耶和华那么圣洁，因为除你以外没有别的神，也没有磐石像我们的　神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S12_3","010_2_3","1SA","2","3","3","你们不要多说骄傲的话，也不要口出狂妄之言，因为耶和华是全知的　神，人的一切行为他都鉴察。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S12_4","010_2_4","1SA","2","4","4","勇士的弓都被折断，跌倒的人却以力量束腰。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S12_5","010_2_5","1SA","2","5","5","饱足的，要劳碌觅食，饥饿的，不再饥饿；不能生育的，生了七个儿女，有过许多儿女的，反倒衰微。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S12_6","010_2_6","1SA","2","6","6","耶和华使人死，也使人活；使人下阴间，也使人从阴间上来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S12_7","010_2_7","1SA","2","7","7","耶和华使人贫穷，也使人富足；使人降卑，也使人升高。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S12_8","010_2_8","1SA","2","8","8","他从灰尘中抬举贫寒的人，从粪堆中提拔穷乏的人，使他们与显贵同坐，承受尊贵的座位。大地的柱子属于耶和华，他把全地安放在柱子上面。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S12_9","010_2_9","1SA","2","9","9","耶和华必保护虔诚人的脚步，却使恶人在黑暗中灭亡，因为人得胜不是靠着力量。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S12_10","010_2_10","1SA","2","10","10","至高者在天上打雷，耶和华必打碎与他作对的人。耶和华要审判地的四极，却要赐力量给他所立的王，高举他膏立之人的角。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S12_11","010_2_11","1SA","2","11","11","后来，以利加拿回拉玛自己的家去。那孩子却留在以利祭司面前事奉耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S12_12","010_2_12","1SA","2","12","12","以利的两个儿子是无赖，不尊重耶和华， ");
INSERT INTO cmn_ncvs_vpl VALUES ("S12_13","010_2_13","1SA","2","13","13","也不理会当时祭司待人民的规矩。有人献祭，在煮肉的时候，祭司的仆人就来，手里拿着三齿的叉， ");
INSERT INTO cmn_ncvs_vpl VALUES ("S12_14","010_2_14","1SA","2","14","14","把叉子插入煎盘里，或鼎里，或釜里，或锅里，叉子插上来的，祭司都拿去。所有到示罗来的以色列人，祭司都是这样待他们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S12_15","010_2_15","1SA","2","15","15","还有，在焚烧脂油以前，祭司的仆人就来，对献祭的人说：“把祭肉交给祭司烧烤吧，因为他不会向你要煮过的肉，单要生的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S12_16","010_2_16","1SA","2","16","16","如果那人对仆人说：“必须先把脂油焚烧了，然后你才可以随意去拿。”他就说：“不可以，你现在就要给我，否则我就抢去。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S12_17","010_2_17","1SA","2","17","17","这样，那两个青年人在耶和华面前所犯的罪很大，因为他们藐视献给耶和华的祭物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S12_18","010_2_18","1SA","2","18","18","那时，撒母耳还是个孩童，束着细麻布的以弗得，在耶和华面前事奉。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S12_19","010_2_19","1SA","2","19","19","撒母耳的母亲每年为他做一件小外袍，她和丈夫一同上来献年祭的时候，就带来给他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S12_20","010_2_20","1SA","2","20","20","以利给以利加拿和他的妻子祝福，说：“愿耶和华从这妇人身上还给你后裔，代替你献给耶和华的孩子。”他们就回自己的地方去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S12_21","010_2_21","1SA","2","21","21","耶和华眷顾哈拿，她再怀孕，先后生了三个儿子和两个女儿。那孩子撒母耳在耶和华面前，渐渐长大。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S12_22","010_2_22","1SA","2","22","22","以利已经老了，听见自己的儿子对待以色列人的一切事，又听见他们与在会幕门口侍应的妇女同寝。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S12_23","010_2_23","1SA","2","23","23","以利就对他们说：“你们为什么作这些事？我亲自从众民那里听见了你们的恶行。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S12_24","010_2_24","1SA","2","24","24","我儿啊，不要这样，因为我听见的消息很不好，你们使耶和华的子民违背律法。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S12_25","010_2_25","1SA","2","25","25","如果有人得罪人，有官长（“官长”原文作“　神”）惩罚他；如果有人得罪耶和华，有谁为他求情呢？”他们却不听父亲的话，因为耶和华有意要杀他们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S12_26","010_2_26","1SA","2","26","26","那孩子撒母耳的身量，耶和华和众人对他的喜爱，都不断增长。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S12_27","010_2_27","1SA","2","27","27","有一位神人来见以利，对他说：“耶和华这样说：‘你父家在埃及法老家为奴的时候，我不是向他们显现吗？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("S12_28","010_2_28","1SA","2","28","28","我不是从以色列众支派中，选出他们作我的祭司，上我的坛烧香，在我面前穿以弗得吗？我不是把以色列人所献的火祭，都赐给了你的父家吗？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("S12_29","010_2_29","1SA","2","29","29","你们为什么还以妒羡的眼光，轻视我所吩咐要献上的祭牲和礼物呢？你为什么尊重你的儿子过于尊重我，用我子民以色列所献一切最好的礼物自肥呢？’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("S12_30","010_2_30","1SA","2","30","30","因此，耶和华以色列的　神说：‘我曾说：你的家和你的父家，必永远行在我面前。’现在耶和华却说：‘我决不容你们这样行了，因为尊重我的，我必尊重他；藐视我的，必受到轻视。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S12_31","010_2_31","1SA","2","31","31","日子快到了，我要砍下你和你父亲的膀臂，使你家中再没有有权势的长者。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S12_32","010_2_32","1SA","2","32","32","我赐给以色列人的一切福分，你必像一个对头，以嫉妒的眼光来看；而在你的家中，必永远再没有有权势的长者。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S12_33","010_2_33","1SA","2","33","33","我必不从我的祭坛那里灭绝你家的人，免得你的眼睛昏花，心灵忧伤，但所有你家中增添的人都必像世人一样死去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S12_34","010_2_34","1SA","2","34","34","你的两个儿子何弗尼和非尼哈所要遭遇的事，是给你的一个证据：他们二人必同日而死。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S12_35","010_2_35","1SA","2","35","35","我要为自己兴起一位忠心的祭司，他必依照我的心意行事；我要为他建立一个稳固的家，他一生必行在我的受膏者面前。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S12_36","010_2_36","1SA","2","36","36","你家中剩下的人，都要来向他下拜；求一个银币，一块饼，也要说：求你容我参与祭司的职务，使我可以有点饼吃。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S13_1","010_3_1","1SA","3","1","1","那孩子撒母耳在以利面前事奉耶和华，在那些日子，耶和华的言语稀少，异象也不常有。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S13_2","010_3_2","1SA","3","2","2","有一天，以利躺卧在自己的地方，他的眼睛早已昏花，不能看得清楚了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S13_3","010_3_3","1SA","3","3","3","神的灯还没有熄灭，撒母耳躺卧在耶和华的殿中，就是安放　神约柜的地方。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S13_4","010_3_4","1SA","3","4","4","耶和华呼唤撒母耳，他说：“我在这里。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S13_5","010_3_5","1SA","3","5","5","他就跑到以利那里，说：“你呼唤我，我在这里。”以利说：“我没有呼唤你，回去睡吧。”他就回去睡了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S13_6","010_3_6","1SA","3","6","6","耶和华再次呼唤撒母耳，他就起来走到以利那里，说：“你呼唤我，我在这里。”以利说：“我儿，我没有呼唤你，回去睡吧。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S13_7","010_3_7","1SA","3","7","7","那时撒母耳还没有认识耶和华，因为耶和华的话还没有向他启示。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S13_8","010_3_8","1SA","3","8","8","耶和华第三次呼唤撒母耳，他又起来，走到以利那里，说：“你呼唤我，我在这里。”以利就明白是耶和华呼唤这孩子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S13_9","010_3_9","1SA","3","9","9","因此以利对撒母耳说：“去睡吧！如果他呼唤你，你就说：‘耶和华啊！请说，仆人敬听。’”于是撒母耳回去，仍然睡在自己的地方。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S13_10","010_3_10","1SA","3","10","10","耶和华又来站着，像前几次一样呼唤：“撒母耳，撒母耳！”他回答：“请说！仆人敬听。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S13_11","010_3_11","1SA","3","11","11","耶和华对撒母耳说：“看哪！我要在以色列中行一件事，听见的人，都必耳鸣； ");
INSERT INTO cmn_ncvs_vpl VALUES ("S13_12","010_3_12","1SA","3","12","12","在那日，我必在以利身上彻底实现我论到他的家所说的一切话。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S13_13","010_3_13","1SA","3","13","13","我曾告诉他：‘我必按着他所知道的罪孽永远处罚他的家。这罪就是他的儿子自招咒诅，他也不责备他们。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("S13_14","010_3_14","1SA","3","14","14","所以我向以利家起了誓：‘以利家的罪孽永远不能用祭物或供物来买赎。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S13_15","010_3_15","1SA","3","15","15","撒母耳睡到天亮，他就开了耶和华殿的门。但撒母耳不敢把异象告诉以利。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S13_16","010_3_16","1SA","3","16","16","以利呼唤撒母耳，说：“我儿撒母耳！”他回答：“我在这里。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S13_17","010_3_17","1SA","3","17","17","以利说：“耶和华对你说了什么话呢？你不要向我隐瞒，他对你所说的一切话，如果你向我隐瞒一句，愿　神对付你，并且加倍对付你。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S13_18","010_3_18","1SA","3","18","18","于是撒母耳把一切话都告诉了以利，一句也没有隐瞒。以利说：“他是耶和华，他看怎么好，就怎么行吧。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S13_19","010_3_19","1SA","3","19","19","撒母耳渐渐长大，耶和华与他同在，使他所说的一切话，没有一句落空。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S13_20","010_3_20","1SA","3","20","20","从但到别是巴，以色列人都知道撒母耳被耶和华确立为先知。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S13_21","010_3_21","1SA","3","21","21","耶和华又在示罗显现，因为耶和华在示罗借着他的话向撒母耳启示自己。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S14_1","010_4_1","1SA","4","1","1","撒母耳的话传遍了以色列。那时，以色列人出去迎战非利士人，他们靠近以便以谢安营，非利士人却在亚弗安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S14_2","010_4_2","1SA","4","2","2","非利士人列阵，要与以色列人交战。战事展开后，以色列人败在非利士人面前，非利士人在战场上杀了约四千人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S14_3","010_4_3","1SA","4","3","3","军队回到营里，以色列的长老说：“今天耶和华为什么在非利士人面前击败我们呢？我们要把耶和华的约柜从示罗抬到我们这里来。约柜一到我们中间，就会拯救我们脱离仇敌的手。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S14_4","010_4_4","1SA","4","4","4","于是他们派人到示罗去，从那里把坐在二基路伯中间万军之耶和华的约柜抬来；以利的两个儿子，何弗尼和非尼哈，也与　神的约柜一同来了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S14_5","010_4_5","1SA","4","5","5","耶和华的约柜来到营中的时候，以色列众人就大声欢呼，大地也回声响应。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S14_6","010_4_6","1SA","4","6","6","非利士人听见了欢呼的声音，就问：“在希伯来人的营中为什么有这样大声的欢呼呢？”后来才知道耶和华的约柜来到了营中。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S14_7","010_4_7","1SA","4","7","7","非利士人就害怕起来，他们说：“有神来到他们的营中了。”又说：“我们有祸了！因为从来没有这样的事。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S14_8","010_4_8","1SA","4","8","8","我们有祸了！从前在旷野用各样灾祸击打埃及人的，就是这些神。谁能救我们脱离这些大能之神的手呢？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("S14_9","010_4_9","1SA","4","9","9","非利士人哪！你们要刚强，要作大丈夫，免得你们作希伯来人的奴仆，好像他们作过你们的奴仆一样；你们要作大丈夫，作战吧！” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S14_10","010_4_10","1SA","4","10","10","于是非利士人起来作战，以色列人就被击败，各人都往自己的帐棚逃跑。这是一场大屠杀，以色列人中有三万步兵阵亡。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S14_11","010_4_11","1SA","4","11","11","神的约柜也被抢去，以利的两个儿子何弗尼和非尼哈也死了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S14_12","010_4_12","1SA","4","12","12","有一个便雅悯人跑离战场，衣服撕裂，头蒙尘土，当天来到示罗。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S14_13","010_4_13","1SA","4","13","13","他来到的时候，以利正在路旁坐在自己的椅子上观望，因为他为　神的约柜担忧战栗。那人进城里报信，全城的人就都喊叫起来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S14_14","010_4_14","1SA","4","14","14","以利听见喊叫的声音，就问：“这喧嚷的声音是什么意思呢？”那人急忙前来，向以利报告。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S14_15","010_4_15","1SA","4","15","15","那时以利九十八岁了，眼睛发直，不能看见。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S14_16","010_4_16","1SA","4","16","16","那人告诉以利：“我是从战场上来的，今天从战场上逃回来。”以利问：“我儿，事情怎么样？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S14_17","010_4_17","1SA","4","17","17","报信的人回答，说：“以色列人在非利士人面前逃跑，伤亡惨重，你两个儿子何弗尼和非尼哈也都死了，民中被杀的甚多，　神的约柜也被抢去了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S14_18","010_4_18","1SA","4","18","18","因为以利年老体重，报信的人一提到　神的约柜，以利就从椅子上往后跌倒在门旁，颈骨折断而死。以利治理了以色列四十年。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S14_19","010_4_19","1SA","4","19","19","以利的媳妇，非尼哈的妻子怀了孕，产期近了；她一听见　神的约柜被抢去，以及她公公和丈夫都死了的消息，就忽然感到疼痛，曲身生产了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S14_20","010_4_20","1SA","4","20","20","她快要死的时候，站在旁边的妇女们对她说：“不要怕，你生了一个儿子！”她却不回答，也不理会。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S14_21","010_4_21","1SA","4","21","21","她给孩子起名叫以迦博，说：“荣耀已经离开以色列了。”这是因为　神的约柜被抢去，又因为她的公公和丈夫都死了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S14_22","010_4_22","1SA","4","22","22","她说：“荣耀已经离开了以色列，因为　神的约柜被抢去了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S15_1","010_5_1","1SA","5","1","1","非利士人抢去了　神的约柜，就把它从以便以谢运到亚实突。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S15_2","010_5_2","1SA","5","2","2","非利士人抢去　神的约柜，把它抬进大衮庙，放在大衮神像的旁边。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S15_3","010_5_3","1SA","5","3","3","第二天清早，亚实突人起来，看见大衮神像仆倒在地，俯伏在耶和华的约柜面前。他们就把大衮神像竖立起来，放回原处。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S15_4","010_5_4","1SA","5","4","4","再次日早晨，他们起来的时候，看见大衮神像又仆倒在地，俯伏在耶和华的约柜面前，大衮的头和双手也都在门槛上折断了，只剩下大衮的身体。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S15_5","010_5_5","1SA","5","5","5","因此大衮的祭司和所有进亚实突大衮庙的人，都不踏大衮庙的门槛，直到现在。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S15_6","010_5_6","1SA","5","6","6","耶和华的手重重地压在亚实突人身上，败坏他们，用痔疮击打亚实突和亚实突四境的人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S15_7","010_5_7","1SA","5","7","7","亚实突人看见这种情形，就说：“以色列　神的约柜不可再留在我们这里，因为他的手重重地加在我们和我们的神大衮身上。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S15_8","010_5_8","1SA","5","8","8","他们就派人去召集非利士人各城的首领前来，问他们：“我们要怎样处理以色列　神的约柜呢？”他们回答：“把以色列　神的约柜运到迦特去吧。”他们就把它运到迦特去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S15_9","010_5_9","1SA","5","9","9","运到那里以后，耶和华的手攻击那城，引起很大的恐慌。他击打全城的人，不分老幼，使痔疮在他们中间蔓延。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S15_10","010_5_10","1SA","5","10","10","于是他们把　神的约柜送到以革伦。　神的约柜到了以革伦的时候，以革伦人就喊叫：“他们把以色列　神的约柜运到我们这里来，是要杀害我们和我们的人啊！” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S15_11","010_5_11","1SA","5","11","11","于是他们派人去召集非利士人各城的首领前来，对他们说：“请把以色列　神的约柜送回原处，免得它杀害我们和我们的人民。”死亡的恐慌笼罩全城，因为　神的手重重地压在那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S15_12","010_5_12","1SA","5","12","12","没有死的人都遭受痔疮的打击；那城的哀声，上达于天。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S16_1","010_6_1","1SA","6","1","1","耶和华的约柜在非利士人的地方有七个月之久。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S16_2","010_6_2","1SA","6","2","2","非利士人把众祭司和占卜的都召了来，问他们：“我们应该怎样处理耶和华的约柜呢？请告诉我们，要怎样才能把它送回原处呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S16_3","010_6_3","1SA","6","3","3","他们回答：“你们把以色列　神的约柜送回去的时候，不可空空地把它送回去，却要偿还赔罪的礼物，这样，你们就可以得着医治，也可以知道，为什么他的手没有离开你们。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S16_4","010_6_4","1SA","6","4","4","非利士人问：“我们应当偿给他什么作赔罪的礼物呢？”他们回答：“要按照非利士人各城首领的数目，用五个金痔疮和五只金老鼠作赔罪的礼物，因为你们所有的人和你们各城的首领所遭遇的，都是一样的灾祸。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S16_5","010_6_5","1SA","6","5","5","所以你们要做痔疮的像和毁坏田地的老鼠的像，还要把荣耀归给以色列的　神。也许他会向你们、你们的神和你们的田地手下留情。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S16_6","010_6_6","1SA","6","6","6","你们为什么要硬着心，像以前埃及人和法老那样呢？　神严严地对付他们以后，他们不是放走了以色列人，以色列人不是真的离开了吗？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("S16_7","010_6_7","1SA","6","7","7","现在你们要预备一辆新车和两头仍在乳养小牛、未曾负过轭的母牛，把它们紧紧套在车上，把小牛从它们身边带回棚里去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S16_8","010_6_8","1SA","6","8","8","你们要把耶和华的约柜搬来，放在车上，把那些偿给他作赔罪礼物的金器放在盒子里，放置在约柜旁边，然后把它送上路，让它自己走。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S16_9","010_6_9","1SA","6","9","9","你们要留意看，如果它是走向自己的境界，往伯．示麦去，那么就是耶和华降这大灾给我们；如果不是这样，我们就知道，不是他的手攻击我们，我们遭遇的不过是偶然的事。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S16_10","010_6_10","1SA","6","10","10","非利士人就照着去行。他们牵来两头还在乳养小牛的母牛，把它们紧紧套在车上，把小牛关在棚里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S16_11","010_6_11","1SA","6","11","11","他们又把耶和华的约柜，装金老鼠和痔疮像的盒子，都放在车上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S16_12","010_6_12","1SA","6","12","12","牛向着伯．示麦的路上直奔，如同走在一条大路上，一面走一面叫，不偏左也不偏右。非利士各城的首领在后面跟着走，直到伯．示麦的边界。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S16_13","010_6_13","1SA","6","13","13","那时，伯．示麦人正在谷中收割麦子，他们举目观看，看见了约柜，就欢欢喜喜迎见约柜。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S16_14","010_6_14","1SA","6","14","14","牛车到了伯．示麦人约书亚的田间，就停在那里；那里有一块大石，他们把做那车的木料劈开，又把那两只母牛作燔祭献给耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S16_15","010_6_15","1SA","6","15","15","利未人把耶和华的约柜，与它一同送来装有金器的盒子，都搬了下来，放在大石上；那一天，伯．示麦人向耶和华献上燔祭，又献上其他的祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S16_16","010_6_16","1SA","6","16","16","非利士人的五个首领看见了，当天就回以革伦去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S16_17","010_6_17","1SA","6","17","17","这些金痔疮，就是非利士人偿给耶和华作赔罪的礼物的，一个是为亚实突，一个是为迦萨，一个是为亚实基伦，一个是为迦特，一个是为以革伦。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S16_18","010_6_18","1SA","6","18","18","金老鼠的数目是按照非利士人五个首领所有的城市的数目，包括设防城和乡村。他们安放耶和华约柜的那块大石，直到现在还是在伯．示麦人约书亚的田间，是一个证物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S16_19","010_6_19","1SA","6","19","19","耶和华因为伯．示麦人偷窥他的约柜，就击杀他们；他击杀了七十人（“七十人”大多数抄本都作“五万零七十人”，少数抄本作“七十人”）。众人因为耶和华用大灾击杀他们，就哀哭起来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S16_20","010_6_20","1SA","6","20","20","伯．示麦人说：“在耶和华这位圣洁的　神面前，谁能站立得住呢？他可以从我们这里上到哪里去呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S16_21","010_6_21","1SA","6","21","21","于是他们派遣使者到基列．耶琳的居民那里去，对他们说：“非利士人把耶和华的约柜送回来了。你们下来把它接到你们那里去吧。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S17_1","010_7_1","1SA","7","1","1","基列．耶琳人就前来，把耶和华的约柜抬上去；他们把它抬到山上亚比拿达的家中，又把他的儿子以利亚撒分别为圣，看守耶和华的约柜。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S17_2","010_7_2","1SA","7","2","2","约柜停留在基列．耶琳很久，有二十年之久，以色列全家都痛悔寻求耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S17_3","010_7_3","1SA","7","3","3","于是撒母耳对以色列全家说：“如果你们一心归向耶和华，就当把外族的神和亚斯他录从你们中间除掉，专心归向耶和华，单单事奉他，他必救你们脱离非利士人的手。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S17_4","010_7_4","1SA","7","4","4","以色列人就除掉众巴力和亚斯他录，单单事奉耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S17_5","010_7_5","1SA","7","5","5","撒母耳又说：“你们要把以色列众人都聚集在米斯巴，我好为你们向耶和华祷告。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S17_6","010_7_6","1SA","7","6","6","于是，他们聚集在米斯巴，打了水，浇奠在耶和华面前；当日他们禁食，并且在那里说：“我们得罪了耶和华。”撒母耳就在米斯巴治理以色列人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S17_7","010_7_7","1SA","7","7","7","非利士人听见以色列人集合在米斯巴，各城的领袖就上来攻打以色列人；以色列人听见了，都害怕起来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S17_8","010_7_8","1SA","7","8","8","以色列人对撒母耳说：“请你不要静默，为我们呼求耶和华我们的　神吧，好叫他拯救我们脱离非利士人的手。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S17_9","010_7_9","1SA","7","9","9","撒母耳就牵来一只还在吃奶的羊羔，把它作全牲的燔祭献给耶和华，又为以色列人向耶和华呼求，耶和华就应允他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S17_10","010_7_10","1SA","7","10","10","撒母耳正在献上燔祭的时候，非利士人前来要与以色列人争战。当天，耶和华发出极大的雷声，攻击非利士人，使他们溃乱，他们就在以色列人面前被击败。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S17_11","010_7_11","1SA","7","11","11","于是以色列人从米斯巴出去，追赶非利士人，击杀他们，直到伯．甲的下边。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S17_12","010_7_12","1SA","7","12","12","撒母耳搬来了一块石头，把它竖立在米斯巴和善之间，给这块石头起名叫以便以谢，说：“直到现在，耶和华都帮助我们。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S17_13","010_7_13","1SA","7","13","13","这样，非利士人就被制伏了，不再侵犯以色列的境界。撒母耳在世的日子，耶和华的手一直攻击非利士人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S17_14","010_7_14","1SA","7","14","14","非利士人从以色列人夺得的城市，自以革伦直到迦特，都归还以色列人；属于这些城市的四境，以色列人也从非利士人手中夺回。那时，以色列人和亚摩利人和平相处。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S17_15","010_7_15","1SA","7","15","15","撒母耳终生作以色列人的士师。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S17_16","010_7_16","1SA","7","16","16","他每年都巡回伯特利、吉甲和米斯巴，在这些地方治理以色列人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S17_17","010_7_17","1SA","7","17","17","然后，他回到拉玛，因为他的家在那里。他也在那里治理以色列人，并且在那里为耶和华筑了一座祭坛。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S18_1","010_8_1","1SA","8","1","1","撒母耳年老的时候，立了他的儿子作以色列人的士师。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S18_2","010_8_2","1SA","8","2","2","他的长子名叫约珥，次子名叫亚比亚，都在别是巴作士师。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S18_3","010_8_3","1SA","8","3","3","两个儿子都没有行撒母耳的道路，反而转去追求不义之财，收受贿赂，屈枉正直。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S18_4","010_8_4","1SA","8","4","4","于是以色列所有的长老都集合起来，到拉玛去见撒母耳， ");
INSERT INTO cmn_ncvs_vpl VALUES ("S18_5","010_8_5","1SA","8","5","5","对他说：“你老了，看哪，你的儿子不行你的道路，现在求你为我们立一个王治理我们，好像列国一样。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S18_6","010_8_6","1SA","8","6","6","他们说“求你为我们立一个王治理我们”这件事，使撒母耳很不高兴，他就祷告耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S18_7","010_8_7","1SA","8","7","7","耶和华对撒母耳说：“众民对你所说的一切，你只管听从，因为他们不是厌弃你，而是厌弃我，不要我作他们的王。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S18_8","010_8_8","1SA","8","8","8","自从我把他们从埃及领上来的那天起，直到现在，他们怎样离开我，事奉别的神，他们对我所行的一切，也照样对你行。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S18_9","010_8_9","1SA","8","9","9","现在你只管听从他们的话，但必须郑重警告他们，告诉他们那要统治他们的王要怎样治理他们。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S18_10","010_8_10","1SA","8","10","10","于是，撒母耳把耶和华所讲的一切话都告诉那些向他要求一个王的民众， ");
INSERT INTO cmn_ncvs_vpl VALUES ("S18_11","010_8_11","1SA","8","11","11","说：“那要统治你们的王将这样治理你们：他必征用你们的儿子，派他们作他的战车兵、骑兵、在车前奔走的前锋， ");
INSERT INTO cmn_ncvs_vpl VALUES ("S18_12","010_8_12","1SA","8","12","12","又派他们作千夫长、五十夫长，替他耕田、收他的庄稼、替他制造作战的武器和战车上的装备。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S18_13","010_8_13","1SA","8","13","13","他必征用你们的女儿作配香膏的、烧饭的和烤饼的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S18_14","010_8_14","1SA","8","14","14","他必夺去你们最好的田地、葡萄园和橄榄园，赐给自己的臣仆。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S18_15","010_8_15","1SA","8","15","15","你们撒种所得的和葡萄园所出的，他都征收十分之一，赐给他的太监和臣仆。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S18_16","010_8_16","1SA","8","16","16","他又必征收你们的仆婢、最精壮的青年和驴，替他工作。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S18_17","010_8_17","1SA","8","17","17","你们的羊群，他要征收十分之一；连你们自己也作他的奴仆。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S18_18","010_8_18","1SA","8","18","18","到时，你们必因你们为自己拣选的王而哀求，那时耶和华却不应允你们。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S18_19","010_8_19","1SA","8","19","19","众民竟不肯听从撒母耳的话，说：“不，我们要一个王治理我们， ");
INSERT INTO cmn_ncvs_vpl VALUES ("S18_20","010_8_20","1SA","8","20","20","让我们也像列国一样，有自己的王治理我们，帅领我们出征，为我们作战。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S18_21","010_8_21","1SA","8","21","21","撒母耳听了众民的一切话，就向耶和华复述。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S18_22","010_8_22","1SA","8","22","22","耶和华对撒母耳说：“你只管听从他们的话，为他们立一个王。”于是撒母耳对以色列人说：“你们各人回自己的城去吧。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S19_1","010_9_1","1SA","9","1","1","有一个便雅悯人，名叫基士，是亚别的儿子。亚别是洗罗的儿子，洗罗是比歌拉的儿子，比歌拉是亚斐亚的儿子。（这便雅悯人是个大财主。） ");
INSERT INTO cmn_ncvs_vpl VALUES ("S19_2","010_9_2","1SA","9","2","2","他有一个儿子，名叫扫罗，既年轻又英俊；在以色列人中，没有一个能比他更英俊的。他比人高出一个头。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S19_3","010_9_3","1SA","9","3","3","扫罗的父亲基士有几头母驴走失了，他就对他的儿子扫罗说：“你带一个仆人，动身去寻找母驴吧！” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S19_4","010_9_4","1SA","9","4","4","扫罗走遍以法莲山地，又走遍沙利沙地，但他们都没有找到。他们又走遍沙琳地，母驴也不在那里；又走遍便雅悯地，还是找不到。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S19_5","010_9_5","1SA","9","5","5","他们到了苏弗地，扫罗对跟随他的仆人说：“来，我们回去吧，恐怕我父亲不为母驴挂心，反而为我们担忧了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S19_6","010_9_6","1SA","9","6","6","仆人对他说：“看哪，这城里有一位神人，很受人敬重，他所说的，都必应验。现在，我们到他那里去吧，也许他会告诉我们当走的路。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S19_7","010_9_7","1SA","9","7","7","扫罗对仆人说：“如果我们去，有什么可以送给那人呢？因为我们袋里的食物都已经用尽了，也没有礼物可以送给那神人，我们还有什么呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S19_8","010_9_8","1SA","9","8","8","仆人回答扫罗：“看哪！我手里有三克银子，可以送给那神人，请他告诉我们应该走的路。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S19_9","010_9_9","1SA","9","9","9","从前在以色列中，有人去求问　神的时候，就这样说：“来，我们去见先见吧。”因为今天称为先知的，从前称为先见。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S19_10","010_9_10","1SA","9","10","10","扫罗对仆人说：“你说的好。来，我们去吧！”于是他们到那神人所住的城里去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S19_11","010_9_11","1SA","9","11","11","他们正上山坡要进城的时候，就遇见几个少女出来打水。他们就问那些少女：“先见在这里吗？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S19_12","010_9_12","1SA","9","12","12","那些少女回答他们说：“在这里！他就在你们前面，现在快去吧！他今天正到这城里来，因为今天在邱?上，人民有献祭的事。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S19_13","010_9_13","1SA","9","13","13","你们一进城，在他登上邱坛吃祭物之前，必遇见他。因为他未到，众人不能先吃，他必先为祭物祝谢，然后客人才可以吃。现在你们上去吧！今天，你们必可遇见他。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S19_14","010_9_14","1SA","9","14","14","于是二人上那城去；他们正进城的时候，撒母耳就迎着他们出来，要上邱坛去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S19_15","010_9_15","1SA","9","15","15","原来，在扫罗来到的前一天，耶和华已经启示撒母耳说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("S19_16","010_9_16","1SA","9","16","16","“明天大约这个时候，我要差派一个人从便雅悯地到你那里去，你要膏立他作我子民以色列人的领袖。他要拯救我的子民脱离非利士人的手。我眷顾了我的子民，因为他们的哀求已经达到我这里。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S19_17","010_9_17","1SA","9","17","17","撒母耳看见了扫罗，耶和华就对撒母耳说：“你看，这就是我对你所说的那人，他要统治我的子民。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S19_18","010_9_18","1SA","9","18","18","扫罗在城门口，走近撒母耳跟前，说：“请告诉我先见的家在哪里？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S19_19","010_9_19","1SA","9","19","19","撒母耳回答扫罗：“我就是先见，请你在我前面上邱坛去。今天你们要与我一同吃饭，明天早晨我就送你回去。你心里的一切事，我都会告诉你。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S19_20","010_9_20","1SA","9","20","20","至于你前三天失了的母驴，你不必为它们担心，因为都已经找到了。以色列众人所渴求的是谁呢？不是你和你的父家吗？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S19_21","010_9_21","1SA","9","21","21","扫罗回答：“我不是以色列众支派中最微小的便雅悯人吗？我的家族不是便雅悯支派的家族中最微小的吗？你为什么对我说这样的话呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S19_22","010_9_22","1SA","9","22","22","撒母耳把扫罗和扫罗的仆人领进了客厅，使他们坐在客人中的首位；那里约有三十人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S19_23","010_9_23","1SA","9","23","23","撒母耳对厨师说：“我交给你，吩咐你存放好的那一份祭肉，现在可以拿来。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S19_24","010_9_24","1SA","9","24","24","厨师就把那条腿肉拿上来，摆在扫罗面前。撒母耳说：“这是为你留下的，现在摆在你面前，请吃吧！因为这是我邀请众人的时候，特地为这时刻保留的。”于是，当天扫罗就与撒母耳一同吃饭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S19_25","010_9_25","1SA","9","25","25","他们从邱坛下来，进到城里；撒母耳和扫罗在房顶上说话。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S19_26","010_9_26","1SA","9","26","26","他们清早起来；天快亮的时候，撒母耳在房顶上呼叫扫罗说：“起来吧，我要送你回去。”扫罗就起来。于是，他与撒母耳二人一起到外面去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S19_27","010_9_27","1SA","9","27","27","他们下到城边的时候，撒母耳对扫罗说：“吩咐你的仆人先走。（仆人就先走了。）你暂且留在这里，我好把　神的话讲给你听。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S110_1","010_10_1","1SA","10","1","1","撒母耳拿了一瓶膏油，倒在扫罗的头上，又与他亲嘴，说：“耶和华不是已经膏立你作他产业的领袖吗？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("S110_2","010_10_2","1SA","10","2","2","今天你离开我以后，在便雅悯境内的泄撒，靠近拉结坟墓的旁边，必遇见两个人。他们会对你说：‘你去寻找的那几头母驴已经找到了。现在你父亲放下了母驴的事，反而为你担忧，说：我为我的儿子要怎么办呢？’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("S110_3","010_10_3","1SA","10","3","3","你要从那里再往前去，直到他泊的橡树那里，必遇见三个上伯特利去敬拜　神的人，一个带着三只山羊羔，一个带着三个饼，一个带着一皮袋酒。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S110_4","010_10_4","1SA","10","4","4","他们必向你问安，并且给你两个饼，你要从他们手中接过来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S110_5","010_10_5","1SA","10","5","5","然后，你要到　神的山去，那里有非利士人的驻军。你进城的时候，会遇见一班先知从邱坛上下来。在他们前面有鼓瑟的、打鼓的、吹笛的、弹琴的。他们都受感说话。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S110_6","010_10_6","1SA","10","6","6","耶和华的灵必大大感动你，你就要与他们一同受感说话，变成另一个人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S110_7","010_10_7","1SA","10","7","7","这些征兆临到你的时候，你就可以见机行事，因为　神与你同在。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S110_8","010_10_8","1SA","10","8","8","你要在我以先下到吉甲去，我也要下到你那里去献燔祭和平安祭。你要等候七天，等我到了你那里，指示你所当行的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S110_9","010_10_9","1SA","10","9","9","扫罗转身离开撒母耳的时候，　神就改变了他，赐给他一颗新心。那一天，这一切征兆都实现了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S110_10","010_10_10","1SA","10","10","10","扫罗到了那山，有一班先知迎面而来。　神的灵大大感动他，他就在他们中间受感说话。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S110_11","010_10_11","1SA","10","11","11","所有以前认识扫罗的人，看见他和他们一起受感说话，就彼此说：“基士的儿子怎么啦！扫罗也列在先知中间吗？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S110_12","010_10_12","1SA","10","12","12","那里有一个人回答：“这些人的父亲是谁呢？”因此，后来有句俗语说：“扫罗也列在先知中间吗？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S110_13","010_10_13","1SA","10","13","13","扫罗受感说话完了以后，就到邱坛去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S110_14","010_10_14","1SA","10","14","14","扫罗的叔叔问扫罗和他的仆人说：“你们到哪里去了？”他回答：“找母驴去。我们找不到，就去见撒母耳。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S110_15","010_10_15","1SA","10","15","15","扫罗的叔叔说：“你把撒母耳对你们所说的话告诉我。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S110_16","010_10_16","1SA","10","16","16","扫罗对他叔叔说：“他清楚地告诉我们，母驴已经找到了。”至于撒母耳所说有关王国的事，扫罗却没有告诉他的叔叔。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S110_17","010_10_17","1SA","10","17","17","撒母耳召集众民到米斯巴耶和华那里， ");
INSERT INTO cmn_ncvs_vpl VALUES ("S110_18","010_10_18","1SA","10","18","18","对他们说：“耶和华以色列的　神这样说：‘我把你们以色列人从埃及带上来，我救你们脱离埃及人的手，又救你们脱离所有欺压你们的列国人的手。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("S110_19","010_10_19","1SA","10","19","19","你们今天却离弃了那位拯救你们脱离一切灾难和困苦的　神，竟对他说：‘求你立一个王统治我们。’现在你们要按着你们的支派和家族，站在耶和华面前。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S110_20","010_10_20","1SA","10","20","20","撒母耳使以色列众支派都近前来，抽签抽中了便雅悯支派； ");
INSERT INTO cmn_ncvs_vpl VALUES ("S110_21","010_10_21","1SA","10","21","21","他又使便雅悯支派按着家族近前来，抽签抽中了马特利；再抽签抽中了基士的儿子扫罗。众人寻找他，却找不到。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S110_22","010_10_22","1SA","10","22","22","于是他们求问耶和华：“那人到这里来了没有？”耶和华说：“他躲在那些物件中。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S110_23","010_10_23","1SA","10","23","23","他们就跑过去，把他从那里领出来；他站在众人中间，比众人都高出一个头。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S110_24","010_10_24","1SA","10","24","24","撒母耳对众民说：“你们看见耶和华所拣选的人没有？在众人中没有一个可与他相比。”众人就大声欢呼：“愿王万岁！” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S110_25","010_10_25","1SA","10","25","25","撒母耳把国法对众人述说了，又记在书上，存放在耶和华面前，然后遣散众人，各回自己的家去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S110_26","010_10_26","1SA","10","26","26","扫罗也回基比亚自己的家里去了，有一些勇士与他一起回去；他们的心都被　神感动。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S110_27","010_10_27","1SA","10","27","27","但是有些流氓说：“这人怎能拯救我们呢？”就藐视他，也没有送他礼物。扫罗却没有说什么。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S111_1","010_11_1","1SA","11","1","1","亚扪人拿辖上来，安营攻击基列．雅比。所有的雅比人都对拿辖说：“你与我们立约，我们就服事你。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S111_2","010_11_2","1SA","11","2","2","亚扪人拿辖对他们说：“这是我与你们立约的条件：我要剜出你们各人的右眼，用来羞辱以色列众人。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S111_3","010_11_3","1SA","11","3","3","雅比的长老对他说：“请你宽限我们七天，好让我们派遣使者到以色列的全境去；如果没有人拯救我们，我们就出来向你投降。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S111_4","010_11_4","1SA","11","4","4","使者到了扫罗住的基比亚，把这些话说给众民听，众民就都放声大哭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S111_5","010_11_5","1SA","11","5","5","那时，扫罗正从田里赶牛回来，问说：“什么事啊？为什么人都在哭呢？”于是有人把雅比人的话告诉他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S111_6","010_11_6","1SA","11","6","6","扫罗听了这些话，　神的灵大大感动他，他就非常忿怒。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S111_7","010_11_7","1SA","11","7","7","他牵来一对牛，把它们切成碎块，交给使者，送到以色列的全境去，说：“不出来跟从扫罗和撒母耳的，他的牛也必受到这样的对待。”因众民惧怕耶和华，他们就都出来，如同一人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S111_8","010_11_8","1SA","11","8","8","扫罗在比色数点他们。以色列人共有三十万，犹大人有三万。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S111_9","010_11_9","1SA","11","9","9","扫罗对前来的使者说：“你们要这样对基列．雅比人说：‘明天中午，你们必得拯救。’”使者回去告诉基列．雅比人，他们就欢喜了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S111_10","010_11_10","1SA","11","10","10","雅比人对亚扪人说：“明天我们出来向你们投降，你们看怎么好，就怎么待我们吧。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S111_11","010_11_11","1SA","11","11","11","第二天，扫罗把众人分成三队。在晨更的时候，他们进了亚扪人的营中，击杀他们，直到中午；残余的人都星散了，他们中间没有两个人留在一起的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S111_12","010_11_12","1SA","11","12","12","众民对撒母耳说：“那说‘扫罗怎能作我们的王’的是谁呢？把那些人交出来，我们好杀死他们。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S111_13","010_11_13","1SA","11","13","13","扫罗说：“今天不可以杀人，因为今天是耶和华在以色列中施行拯救的日子。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S111_14","010_11_14","1SA","11","14","14","撒母耳对众民说：“来吧，我们往吉甲去，好在那里重新建立王国。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S111_15","010_11_15","1SA","11","15","15","众民就都到吉甲去，在那里在耶和华面前立扫罗为王，又在那里在耶和华面前献平安祭。扫罗和以色列众民都在那里，非常欢喜。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S112_1","010_12_1","1SA","12","1","1","撒母耳对以色列人说：“看哪！我已经听从了你们向我所说的一切话，为你们立了一个王。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S112_2","010_12_2","1SA","12","2","2","现在，有这王领导你们。至于我，我已经年老发白，我的儿子也都在你们那里；我自幼年直到今日都领导你们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S112_3","010_12_3","1SA","12","3","3","看哪，我在这里！你们只管在耶和华面前，以及在他的受膏者面前，作证指控我：我夺过谁的牛？抢过谁的驴？欺负过谁？虐待过谁？从谁手里受过贿赂，以致我的眼睛因此被蒙住呢？如果有，我必偿还给你们。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S112_4","010_12_4","1SA","12","4","4","他们回答：“你没有欺负过我们，没有虐待过我们，也没有从谁手里取过什么东西。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S112_5","010_12_5","1SA","12","5","5","撒母耳对他们说：“今天耶和华在你们中间作见证，他的膏立者也作见证；你们在我手里没有找到什么。”他们说：“愿他作证。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S112_6","010_12_6","1SA","12","6","6","撒母耳对人民说：“从前选立摩西和亚伦，又把你们的列祖从埃及地领上来的，是耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S112_7","010_12_7","1SA","12","7","7","现在你们要站住，我要在耶和华面前与你们讲论耶和华向你们的列祖所行一切公义的事。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S112_8","010_12_8","1SA","12","8","8","从前雅各到了埃及，后来你们的列祖哀求耶和华，耶和华就差遣摩西和亚伦去把你们的列祖从埃及领出来，又使他们在这地方居住。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S112_9","010_12_9","1SA","12","9","9","他们却忘记了耶和华他们的　神，　神就把他们交在夏琐的将军西西拉的手中，以及非利士人和摩押王的手中，于是这些人常常攻打他们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S112_10","010_12_10","1SA","12","10","10","他们就哀求耶和华，说：‘我们犯了罪，因为我们背弃了耶和华，又去服事巴力和亚斯他录。现在求你救我们脱离仇敌的手，我们就必事奉你。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("S112_11","010_12_11","1SA","12","11","11","于是耶和华差遣耶路．巴力、比但、耶弗他、撒母耳，救你们脱离四围仇敌的手，你们才可以安然居住。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S112_12","010_12_12","1SA","12","12","12","可是，你们看到亚扪王拿辖来攻击你们，就对我说：‘不行，我们要有一个王来统治我们。’其实，耶和华你们的　神是你们的王。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S112_13","010_12_13","1SA","12","13","13","现在，你们所拣选、所要求的王在这里。看哪！耶和华已经立了一个王统治你们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S112_14","010_12_14","1SA","12","14","14","如果你们敬畏耶和华，事奉他，听从他的话，不违背他的命令，你们和统治你们的王就必跟从耶和华你们的　神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S112_15","010_12_15","1SA","12","15","15","但是，如果你们不听从耶和华的话，违背他的命令，耶和华的手就必攻击你们，好像攻击你们的列祖一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S112_16","010_12_16","1SA","12","16","16","现在你们要站着，看耶和华在你们眼前将要施行的这件大事。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S112_17","010_12_17","1SA","12","17","17","现今不是收割麦子的时候吗？我要向耶和华呼求，他就会打雷降雨，你们就可以知道，又可以看见，你们为自己要求立王的事，在耶和华看来，是行了极大的恶事。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S112_18","010_12_18","1SA","12","18","18","于是撒母耳向耶和华呼求，耶和华就在那天打雷降雨，众民就非常惧怕耶和华和撒母耳。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S112_19","010_12_19","1SA","12","19","19","众民对撒母耳说：“求你为仆人向耶和华你的　神祷告，免得我们死亡，因为我们为自己要求立王的事，是在我们的一切罪上又增加了这一件恶事。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S112_20","010_12_20","1SA","12","20","20","撒母耳对人民说：“不要惧怕！虽然你们行了这一切恶事，只是不可偏离不跟随耶和华，总要一心事奉他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S112_21","010_12_21","1SA","12","21","21","不可偏离耶和华，去追随那些空虚的偶像，因为它们本是空虚的，对人没有什么益处，也不能救人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S112_22","010_12_22","1SA","12","22","22","耶和华为了自己的大名的缘故，必不丢弃他的子民，因为他喜欢使你们作他的子民。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S112_23","010_12_23","1SA","12","23","23","至于我，我决不停止为你们祷告，以致得罪耶和华；我要把善道正路教导你们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S112_24","010_12_24","1SA","12","24","24","你们只要敬畏耶和华，诚实全心事奉他，因为你们已经看过他为你们所作的是何等大的事。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S112_25","010_12_25","1SA","12","25","25","如果你们继续行恶，你们和你们的王就必一同灭亡。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S113_1","010_13_1","1SA","13","1","1","扫罗登基的时候年三十岁，作了以色列王四十二年（原文缺完整的年数，这里是按《七十士译本》加上的）。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S113_2","010_13_2","1SA","13","2","2","他从以色列人中为自己拣选了三千人；两千人和扫罗一同驻在密抹和伯特利山，一千人与约拿单一同驻在便雅悯的基比亚。其余的人，扫罗都遣散他们各回自己的家去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S113_3","010_13_3","1SA","13","3","3","约拿单攻打非利士人在迦巴的驻军，非利士人听见了；扫罗就在全地吹角，说：“让希伯来人都听见。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S113_4","010_13_4","1SA","13","4","4","以色列众人听说扫罗攻打了非利士人的驻军，又听说非利士人憎恨以色列人，就应召在吉甲跟随扫罗。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S113_5","010_13_5","1SA","13","5","5","非利士人聚集起来，要与以色列人交战，他们有战车三千（“三千”原文作“三万”，这里参考一些《七十士译本》的抄本及叙利亚译本翻译）辆、骑兵六千人、步兵像海边的沙那么多。他们上来，在伯．亚文东边的密抹安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S113_6","010_13_6","1SA","13","6","6","以色列人看见自己情况危急，处境窘迫，众人就藏在山洞、岩穴、地洞里和地坑之中。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S113_7","010_13_7","1SA","13","7","7","有些希伯来人渡过了约旦河，逃到迦得和基列地。但是扫罗仍然留在吉甲，跟随他的众人都恐惧战兢。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S113_8","010_13_8","1SA","13","8","8","扫罗照着撒母耳所定的日期等了七天，但撒母耳还没有来到吉甲，众人就离开扫罗散去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S113_9","010_13_9","1SA","13","9","9","扫罗说：“你们把燔祭和平安祭带到我这里来。”他就献上燔祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S113_10","010_13_10","1SA","13","10","10","他刚刚献完了燔祭，撒母耳就来到了；扫罗出去迎接他，向他问安。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S113_11","010_13_11","1SA","13","11","11","撒母耳说：“你作了什么事？”扫罗回答：“因为我看见众民都离开我散去了，你又没有照所定的日子来到，而非利士人正在密抹聚集起来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S113_12","010_13_12","1SA","13","12","12","我心里想：‘非利士人现在就要下到吉甲来攻打我，我却还没有向耶和华求恩。’所以我就勉强自己把燔祭献上了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S113_13","010_13_13","1SA","13","13","13","撒母耳对扫罗说：“你作了糊涂事了！你没有谨守耶和华你的　神吩咐你的命令。如果你谨守，耶和华就必在以色列中坚立你的王位，直到永远。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S113_14","010_13_14","1SA","13","14","14","但现在你的王位必不长久，耶和华已经为自己找到一个合他心意的人，立他作自己子民的领袖，因为你没有谨守耶和华所吩咐你的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S113_15","010_13_15","1SA","13","15","15","于是撒母耳动身，从吉甲上便雅悯的基比亚去；扫罗数点跟随他的人，约有六百人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S113_16","010_13_16","1SA","13","16","16","扫罗和他的儿子约拿单，以及跟随他们的人都停留在便雅悯的迦巴，非利士人却在密抹安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S113_17","010_13_17","1SA","13","17","17","有突击队从非利士人的营里出来，分成三队，一队往俄弗拉向书亚地去， ");
INSERT INTO cmn_ncvs_vpl VALUES ("S113_18","010_13_18","1SA","13","18","18","一队往伯．和仑去，一队往洗波音谷对面的境界向旷野去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S113_19","010_13_19","1SA","13","19","19","那时，以色列全地找不到一个铁匠，因为非利士人说：“恐怕希伯来人制造刀剑或枪矛。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S113_20","010_13_20","1SA","13","20","20","以色列众人要磨锄头、犁头、斧头和铲子，就各自下到非利士人那里去磨。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S113_21","010_13_21","1SA","13","21","21","磨锄头或犁头的价钱是七克银子，磨三齿叉、斧头或刺棒的价钱是四克银子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S113_22","010_13_22","1SA","13","22","22","所以，到了争战的时候，跟随扫罗和约拿单的众民，没有一个手里有刀或枪的，只有扫罗和他的儿子约拿单有刀枪。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S113_23","010_13_23","1SA","13","23","23","有一队非利士人的驻军出到密抹的隘口去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S114_1","010_14_1","1SA","14","1","1","有一天，扫罗的儿子约拿单对替他拿武器的仆人说：“来！我们过到非利士人的驻军那边去吧。”但他没有告诉父亲。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S114_2","010_14_2","1SA","14","2","2","那时扫罗在基比亚的边界，坐在米矶仑的石榴树下，跟随他的约有六百人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S114_3","010_14_3","1SA","14","3","3","其中有亚希突的儿子亚希亚带着以弗得；亚希突是以迦博的哥哥，非尼哈的儿子，以利的孙子。以利从前在示罗作耶和华的祭司。约拿单去了，众人都不知道。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S114_4","010_14_4","1SA","14","4","4","约拿单设法要经过那个隘口到非利士人的驻军那里去，隘口的两边各有一个山峰，一个名叫播薛，另一个名叫西尼。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S114_5","010_14_5","1SA","14","5","5","一个高峰向北，与密抹相对，另一个向南，与迦巴相对。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S114_6","010_14_6","1SA","14","6","6","约拿单对替他拿武器的仆人说：“来！我们过到这些未受割礼的人的驻军那里去，也许耶和华会为我们动工，因为不论人多或人少，都不能妨碍耶和华施行拯救。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S114_7","010_14_7","1SA","14","7","7","替他拿武器的仆人对他说：“照你的心意作吧！去吧，我必与你同心。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S114_8","010_14_8","1SA","14","8","8","约拿单说：“我们要过到那些人那里去，让他们看见我们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S114_9","010_14_9","1SA","14","9","9","如果他们对我们这样说：‘你们站住！等我们到你们那里去。’我们就站在原地，不上他们那里去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S114_10","010_14_10","1SA","14","10","10","如果他们对我们这样说：‘你们上到我们这里来吧！’我们就上去，这就是我们的凭据，因为耶和华已经把他们交在我们的手里了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S114_11","010_14_11","1SA","14","11","11","他们二人就让非利士人的驻军看见。非利士人说：“看哪！有希伯来人从他们躲藏的洞里出来了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S114_12","010_14_12","1SA","14","12","12","驻军中有人应声对约拿单和替他拿武器的人说：“你们上我们这里来吧！我们有一件事要告诉你们。”约拿单对替他拿武器的人说：“你跟我上去，因为耶和华已经把他们交在以色列人的手里了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S114_13","010_14_13","1SA","14","13","13","约拿单手脚并用地爬了上去，替他拿武器的人跟着他。非利士人在约拿单面前倒下，替他拿武器的也跟在后面把他们杀死。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S114_14","010_14_14","1SA","14","14","14","约拿单和替他拿武器的第一次杀敌，约杀死了二十人，都是在四分之一公顷的范围内杀的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S114_15","010_14_15","1SA","14","15","15","于是在营房里，在田野中和在众人中间，都有恐慌，驻军和突击队也都恐惧，地也震动，这是从　神而来的恐惧。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S114_16","010_14_16","1SA","14","16","16","在便雅悯的基比亚，扫罗的瞭望兵看见非利士人的大军溃败，四处逃窜。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S114_17","010_14_17","1SA","14","17","17","于是扫罗对跟随他的众民说：“你们数点一下，看看谁从我们这里出去了。”他们一数点，就发现约拿单和替他拿武器的不在那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S114_18","010_14_18","1SA","14","18","18","扫罗对亚希亚说：“把　神的约柜运来！”因为那时　神的约柜在以色列人那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S114_19","010_14_19","1SA","14","19","19","扫罗正对祭司说话的时候，非利士营中的骚乱越来越大，扫罗就对祭司说：“住手吧！” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S114_20","010_14_20","1SA","14","20","20","扫罗和所有跟随他的人就聚集起来，到了战场，就看见非利士人用刀互相击杀，十分混乱。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S114_21","010_14_21","1SA","14","21","21","那些从前归顺非利士人的希伯来人，就是混杂在营里与非利士人一起上来的，现在也转过来，与那些跟从扫罗和约拿单的以色列人在一起。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S114_22","010_14_22","1SA","14","22","22","那些躲藏在以法莲山地的以色列众人一听见非利士人逃跑，也就在战场上紧紧追赶他们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S114_23","010_14_23","1SA","14","23","23","那一天，耶和华拯救了以色列人。战争伸展到伯．亚文。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S114_24","010_14_24","1SA","14","24","24","那一天，以色列人处境很窘迫，因为扫罗叫众人起誓说：“不等到晚上，不等到我向敌人报了仇，就吃食物的，那人必受咒诅。”所以众民都没有尝过食物。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S114_25","010_14_25","1SA","14","25","25","众人进了树林，林中地上有蜂蜜。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S114_26","010_14_26","1SA","14","26","26","他们进了树林，看见有蜂蜜流出来，却没有人敢伸手取蜜入口，因为众人都害怕所起的誓。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S114_27","010_14_27","1SA","14","27","27","约拿单没有听见他父亲叫众民所起的誓，所以伸出手中的杖，用杖头蘸在蜂房里，转手送进口里，他的眼睛就明亮了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S114_28","010_14_28","1SA","14","28","28","众民中有一个人说：“你父亲曾经叫众人严严地起誓说：‘今天吃食物的，那人必受咒诅。’所以众人都疲乏了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S114_29","010_14_29","1SA","14","29","29","约拿单说：“我父亲连累了这地的人。你们看！我尝了这一点蜂蜜以后，我的眼睛就明亮了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S114_30","010_14_30","1SA","14","30","30","今天众民若是随意吃了从他们的仇敌夺得的东西，不是更好吗？如今被击杀的非利士人，不是更多吗？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S114_31","010_14_31","1SA","14","31","31","那一天，他们击杀非利士人，从密抹直到亚雅仑；众人都非常疲乏了， ");
INSERT INTO cmn_ncvs_vpl VALUES ("S114_32","010_14_32","1SA","14","32","32","就急忙抢夺战利品；他们捉住了羊、牛或牛犊，就地宰杀，带着血一起吃了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S114_33","010_14_33","1SA","14","33","33","有人告诉扫罗说：“众民吃了带着血的肉，得罪耶和华了。”他说：“你们作了不忠的事了，立刻把一块大石头滚到我这里来。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S114_34","010_14_34","1SA","14","34","34","扫罗又说：“你们分散到众人中去，对他们说：‘你们各人要把自己的牛羊带到我面前来，在这里宰了吃；不可吃带着血的肉，得罪耶和华。’”于是当天晚上，众人都各把自己的牛羊带到那里宰了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S114_35","010_14_35","1SA","14","35","35","扫罗为耶和华筑了一座祭坛，这是他初次为耶和华筑的祭坛。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S114_36","010_14_36","1SA","14","36","36","扫罗说：“我们趁着晚上下去追赶非利士人，抢掠他们，直到天亮，不让他们留下一人。”他们说：“你看怎么好，就怎么行吧！”但祭司说：“我们先在这里亲近　神！” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S114_37","010_14_37","1SA","14","37","37","扫罗求问　神：“我可以下去追赶非利士人吗？你把他们交在以色列人的手里吗？”那天　神没有回答他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S114_38","010_14_38","1SA","14","38","38","扫罗说：“民间的众领袖啊，你们都要走近这里来；你们要查看今天我们犯了什么罪。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S114_39","010_14_39","1SA","14","39","39","我指着拯救以色列、永活的耶和华起誓，即使是我的儿子约拿单犯了罪，他也一定要死。”众人中没有一人回答他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S114_40","010_14_40","1SA","14","40","40","于是扫罗对以色列众人说：“你们站在这里，我和我的儿子约拿单站在那边。”众民回答扫罗：“你看怎么好，就怎么行吧！” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S114_41","010_14_41","1SA","14","41","41","扫罗祷告耶和华以色列的　神说：“求你指示实情！”于是抽签，抽中了约拿单和扫罗；众民都没事。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S114_42","010_14_42","1SA","14","42","42","扫罗说：“你们再抽签，看是我，或是我的儿子约拿单。”结果抽中约拿单。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S114_43","010_14_43","1SA","14","43","43","扫罗对约拿单说：“告诉我，你作了什么事？”约拿单告诉他：“我用我手中的杖头尝了一点蜂蜜。我在这里，我愿意死！” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S114_44","010_14_44","1SA","14","44","44","扫罗说：“约拿单啊！你必定要死，否则，愿　神加倍惩罚我。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S114_45","010_14_45","1SA","14","45","45","众民对扫罗说：“约拿单在以色列人中行了这样大的拯救，难道一定要他死吗？绝对不可以！我们指着永活的耶和华起誓，连他一根头发也不可落在地上，因为他今天是与　神一同作工。”这样，众民救了约拿单，使他免了一死。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S114_46","010_14_46","1SA","14","46","46","扫罗上去，不再追赶非利士人；非利士人也回到自己的地方去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S114_47","010_14_47","1SA","14","47","47","扫罗取得了以色列的王国以后，常常攻打四围的一切仇敌，就是摩押人、亚扪人、以东人、琐巴众王和非利士人，他无论往哪里去，都得到胜利。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S114_48","010_14_48","1SA","14","48","48","扫罗行事勇敢，击败了亚玛力人，把以色列人从抢掠他们的人手中救了出来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S114_49","010_14_49","1SA","14","49","49","扫罗的儿子是约拿单、亦施韦和麦基舒亚。他的两个女儿，长女名叫米拉，次女名叫米甲。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S114_50","010_14_50","1SA","14","50","50","扫罗的妻子名叫亚希暖，是亚希玛斯的女儿。扫罗军队的元帅名叫押尼珥，是尼珥的儿子，尼珥是扫罗的叔叔。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S114_51","010_14_51","1SA","14","51","51","扫罗的父亲基士和押尼珥的父亲尼珥都是亚别的儿子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S114_52","010_14_52","1SA","14","52","52","扫罗的一生常常与非利士人有猛烈的争战。每逢扫罗看见任何勇士或有能力的人，就都招募归他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S115_1","010_15_1","1SA","15","1","1","撒母耳对扫罗说：“耶和华差遣我膏立你作他子民以色列的王，所以现在你要听耶和华的话。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S115_2","010_15_2","1SA","15","2","2","万军之耶和华这样说：‘以色列人从埃及上来的时候，亚玛力人对他们所行的，在路上攻击他们的事，我必要惩罚。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S115_3","010_15_3","1SA","15","3","3","现在你要去攻打亚玛力人，彻底毁灭他们所有的一切，不可怜惜他们。无论男女、孩童，或吃奶的婴儿，牛羊、骆驼、驴子，都要杀死。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S115_4","010_15_4","1SA","15","4","4","于是扫罗招聚众人，在提拉因数点他们，共有步兵二十万，另有犹大人一万。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S115_5","010_15_5","1SA","15","5","5","扫罗到了亚玛力人的城市，就在山谷中设下伏兵。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S115_6","010_15_6","1SA","15","6","6","扫罗又对基尼人说：“你们走吧！离开亚玛力人下去吧！免得我把你们与他们一同消灭。因为以色列众人从埃及上来的时候，你们曾经以慈爱待他们。”于是基尼人离开亚玛力人去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S115_7","010_15_7","1SA","15","7","7","扫罗击杀亚玛力人，从哈腓拉直到埃及东的书珥， ");
INSERT INTO cmn_ncvs_vpl VALUES ("S115_8","010_15_8","1SA","15","8","8","生擒了亚玛力人的王亚甲，用刀杀灭了所有人民。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S115_9","010_15_9","1SA","15","9","9","但扫罗和众人怜惜亚甲，也爱惜上好的牛羊、肥牛犊、羊羔和一切美好的东西。他们不愿彻底毁灭这些；凡是卑贱的、没有价值的，他们就彻底毁灭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S115_10","010_15_10","1SA","15","10","10","耶和华的话临到撒母耳说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("S115_11","010_15_11","1SA","15","11","11","“我后悔立了扫罗为王，因为他已经离去不跟随我，也不执行我的命令了。”撒母耳非常忿怒，整夜哀求耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S115_12","010_15_12","1SA","15","12","12","撒母耳清早起来，要在早晨去见扫罗；有人告诉撒母耳：“扫罗到了迦密，在那里为自己立了一座纪念碑，然后转身下到吉甲去了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S115_13","010_15_13","1SA","15","13","13","撒母耳到了扫罗那里，扫罗对他说：“愿耶和华赐福给你！我已经执行了耶和华的命令。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S115_14","010_15_14","1SA","15","14","14","撒母耳说：“我耳中听见有羊叫牛鸣的声音，到底是什么呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S115_15","010_15_15","1SA","15","15","15","扫罗回答：“这是众民从亚玛力人那里带来的，因为他们爱惜这些上好的牛羊，要献给耶和华你的　神为祭；其余的，我们都已经彻底毁灭了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S115_16","010_15_16","1SA","15","16","16","撒母耳对扫罗说：“住口吧！让我把耶和华昨天晚上对我所说的话告诉你。”扫罗对他说：“请说。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S115_17","010_15_17","1SA","15","17","17","撒母耳说：“从前你虽然自以为微小，不是作了以色列众支派的首领吗？耶和华膏立了你作以色列的王， ");
INSERT INTO cmn_ncvs_vpl VALUES ("S115_18","010_15_18","1SA","15","18","18","差遣你去，说：‘你去彻底毁灭那些犯罪的亚玛力人，攻打他们，直到把他们全部毁灭。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("S115_19","010_15_19","1SA","15","19","19","你为什么没有听从耶和华的话，急于夺取战利品，作了耶和华看为恶的事呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S115_20","010_15_20","1SA","15","20","20","扫罗回答撒母耳：“我实在听从了耶和华的话，行了耶和华差遣我行的路；我把亚玛力人的王亚甲带了回来，又把亚玛力人都彻底毁灭了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S115_21","010_15_21","1SA","15","21","21","可是众民却从那些战利品中，取了应当毁灭之物中上好的牛羊，要在吉甲献给耶和华你的　神为祭。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S115_22","010_15_22","1SA","15","22","22","撒母耳说：“耶和华喜悦燔祭和平安祭，岂像喜悦人听从耶和华的话呢？听从胜过献祭，听命胜过公羊的脂油。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S115_23","010_15_23","1SA","15","23","23","因为悖逆与行邪术的罪相同，顽梗与拜虚无偶像一样，因为你弃绝了耶和华的话，耶和华也弃绝了你作王。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S115_24","010_15_24","1SA","15","24","24","于是扫罗对撒母耳说：“我犯了罪了，我违背了耶和华的命令和你的话，因为我害怕众人，听从了他们的话。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S115_25","010_15_25","1SA","15","25","25","现在求你赦免我的罪，与我一同回去，我好敬拜耶和华。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S115_26","010_15_26","1SA","15","26","26","撒母耳回答扫罗：“我不与你一同回去，因为你弃绝了耶和华的话，耶和华也弃绝你作以色列的王。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S115_27","010_15_27","1SA","15","27","27","撒母耳转身要走，扫罗拉着他外袍的衣边，衣边就撕裂了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S115_28","010_15_28","1SA","15","28","28","撒母耳就对他说：“今天耶和华把以色列国从你身上撕裂，赐给比你更好的人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S115_29","010_15_29","1SA","15","29","29","以色列的大能者必不说谎，也不后悔。因为他不是世人，他决不后悔。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S115_30","010_15_30","1SA","15","30","30","扫罗说：“我犯了罪了，但是求你在我人民的长老面前和以色列人面前给我面子，与我一同回去，我好敬拜耶和华你的　神。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S115_31","010_15_31","1SA","15","31","31","于是撒母耳跟着扫罗回去，扫罗就敬拜耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S115_32","010_15_32","1SA","15","32","32","随后撒母耳说：“把亚玛力人的王亚甲带到我这里来！”亚甲欢欢喜喜走到他面前，心里说：“死亡的痛苦必定过去了！” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S115_33","010_15_33","1SA","15","33","33","撒母耳说：“你的刀怎样使妇人丧子，你的母亲在妇人中也要怎样丧子。”于是撒母耳在吉甲，在耶和华面前把亚甲斩成碎块。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S115_34","010_15_34","1SA","15","34","34","后来撒母耳回拉玛去，扫罗也上他所住的基比亚自己的家去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S115_35","010_15_35","1SA","15","35","35","撒母耳直到死的日子，再没有看见扫罗。撒母耳为扫罗悲伤，因为耶和华后悔立了扫罗作以色列的王。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S116_1","010_16_1","1SA","16","1","1","耶和华对撒母耳说：“你为扫罗悲哀要到几时呢？我已经弃绝他作以色列的王了。你把膏油盛满了角，然后去吧！我要差派你到伯利恒人耶西那里去，因为我在他的众子中，已经预定了一个为我作王。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S116_2","010_16_2","1SA","16","2","2","撒母耳说：“我怎能去呢？扫罗听见了，必定杀我。”耶和华说：“你可以带一头母牛犊去，就说：‘我来是要向耶和华献祭。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("S116_3","010_16_3","1SA","16","3","3","你要请耶西参加献祭的筵席，我就会指示你当作的。我指示你的那人，你要为我膏立他。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S116_4","010_16_4","1SA","16","4","4","于是撒母耳照着耶和华的话去行。他到了伯利恒的时候，城里的长老就都战战兢兢地出来迎接他，说：“你是为平安来的吗？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S116_5","010_16_5","1SA","16","5","5","他回答：“是为平安来的。我来是要向耶和华献祭。你们要自洁，与我一同参加献祭的筵席。”撒母耳使耶西和他的儿子自洁，邀请他们来参加献祭的筵席。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S116_6","010_16_6","1SA","16","6","6","他们来到的时候，撒母耳看见以利押，就心里想：“在耶和华面前的这位，必是他所要膏立的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S116_7","010_16_7","1SA","16","7","7","但耶和华对撒母耳说：“不要看他的外貌和他高大的身材，因为我不拣选他。耶和华看人不像人看人，人是看外表，耶和华是看内心。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S116_8","010_16_8","1SA","16","8","8","耶西叫亚比拿达在撒母耳面前经过，撒母耳说：“这也不是耶和华所拣选的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S116_9","010_16_9","1SA","16","9","9","耶西又叫沙玛经过。撒母耳说：“耶和华也不拣选这个。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S116_10","010_16_10","1SA","16","10","10","耶西叫他的七个儿子都在撒母耳面前经过。但撒母耳对耶西说：“这些都不是耶和华所拣选的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S116_11","010_16_11","1SA","16","11","11","撒母耳问耶西：“孩子们全都在这里吗？”耶西回答：“还有一个最小的，正在牧羊。”撒母耳对耶西说：“你派人去把他带回来，因为他没有来到以前，我们决不入席。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S116_12","010_16_12","1SA","16","12","12","耶西就派人去把大卫带回来。他面色红润，眼目清秀，外貌英俊。耶和华说：“就是这一个，你起来膏立他吧！” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S116_13","010_16_13","1SA","16","13","13","撒母耳就拿起盛油的角，在他的兄长中膏立他。从那天起，耶和华的灵就大大感动大卫。后来撒母耳动身往拉玛去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S116_14","010_16_14","1SA","16","14","14","耶和华的灵离开了扫罗。有恶鬼从耶和华那里来惊扰他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S116_15","010_16_15","1SA","16","15","15","扫罗的臣仆对他说：“看哪！有恶鬼从　神那里来惊扰你。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S116_16","010_16_16","1SA","16","16","16","愿我们的主吩咐你面前的臣仆，去寻找一位善于弹琴的人；从　神那里来的灵临到你身上的时候，他可以弹琴，你就好了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S116_17","010_16_17","1SA","16","17","17","扫罗对他的臣仆说：“你们可以为我找一个善于弹琴的人，带到我这里来。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S116_18","010_16_18","1SA","16","18","18","有一个仆人回答：“我见过伯利恒人耶西的一个儿子，他善于弹琴，是个大能的勇士，又是个战士，谈吐合宜，容貌俊美，耶和华也与他同在。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S116_19","010_16_19","1SA","16","19","19","于是扫罗派遣使者去见耶西，说：“请你叫你放羊的儿子大卫到我这里来。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S116_20","010_16_20","1SA","16","20","20","耶西就牵来一头驴子，驮上饼、一皮袋酒和一只山羊羔，交给他的儿子大卫送给扫罗。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S116_21","010_16_21","1SA","16","21","21","大卫到了扫罗那里，就侍立在他面前。扫罗很爱他，他就作了替扫罗拿武器的人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S116_22","010_16_22","1SA","16","22","22","扫罗再派人到耶西那里去，说：“请你让大卫侍立在我面前吧，因为我喜欢他。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S116_23","010_16_23","1SA","16","23","23","每逢从　神那里来的恶鬼临到扫罗身上的时候，大卫就拿起琴来弹奏，扫罗就舒服畅快，恶鬼也离开了他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_1","010_17_1","1SA","17","1","1","非利士人聚集他们的军队作战。他们聚集在属犹大的梭哥，在梭哥和亚西加之间的以弗．大悯安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_2","010_17_2","1SA","17","2","2","扫罗和以色列人也聚集起来，在以拉谷安营；他们列出战阵，要迎战非利士人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_3","010_17_3","1SA","17","3","3","非利士人站在这边山上，以色列人站在那边山上，中间有山谷分隔。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_4","010_17_4","1SA","17","4","4","有一个挑战的人从非利士人的军营中出来，名叫歌利亚，是迦特人，身高三公尺。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_5","010_17_5","1SA","17","5","5","他头戴铜盔，身穿铠甲，铠甲的铜重五十七公斤。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_6","010_17_6","1SA","17","6","6","他的腿上有铜护膝，两肩之间背着一根铜枪。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_7","010_17_7","1SA","17","7","7","另外，他手上拿着矛，矛杆有织布的机轴那么粗，矛头的铁重七公斤。还有一个拿大盾牌的人在他前面走。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_8","010_17_8","1SA","17","8","8","歌利亚站着，向着以色列人的军队喊叫，对他们说：“你们为什么出来这里摆列战阵呢？我不是非利士人吗？你们不是扫罗的仆人吗？你们自己挑选一个人，叫他下到我这里来吧。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_9","010_17_9","1SA","17","9","9","如果他能与我决斗，击杀了我，我们就作你们的奴仆；但是，如果我能胜过他，击杀了他，你们就作我们的奴仆，服事我们。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_10","010_17_10","1SA","17","10","10","那非利士人又说：“今天我向以色列人的军队骂阵。你们派一个人出来，我们可以决斗！” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_11","010_17_11","1SA","17","11","11","扫罗和以色列众人听见了那非利士人所说的这些话，就都惊惶，非常害怕。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_12","010_17_12","1SA","17","12","12","大卫是犹大伯利恒的以法他人耶西的儿子；耶西有八个儿子。在扫罗的日子，耶西已经年纪老迈了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_13","010_17_13","1SA","17","13","13","耶西的三个大儿子跟随了扫罗去作战。去了作战的这三个儿子的名字是：长子以利押、次子亚比拿达、三子沙玛。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_14","010_17_14","1SA","17","14","14","大卫是最小的，那三个年长的都跟随扫罗去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_15","010_17_15","1SA","17","15","15","大卫有时离开扫罗，回到伯利恒牧放他父亲的羊群。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_16","010_17_16","1SA","17","16","16","那非利士人每天早晚都近前来，站着骂阵，一连有四十天之久。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_17","010_17_17","1SA","17","17","17","有一天，耶西对他的儿子大卫说：“你拿这十公斤烘了的谷子和这十个饼去给你的哥哥们；你要跑到营里去给你的哥哥们， ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_18","010_17_18","1SA","17","18","18","又拿这十块乳酪去给他们的千夫长，看看你的哥哥们平安不平安，把他们的家书带回来。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_19","010_17_19","1SA","17","19","19","扫罗和大卫的哥哥们，以及以色列众人都在以拉谷与非利士人作战。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_20","010_17_20","1SA","17","20","20","大卫清早起来，把羊群托给一个看守的人，就照着耶西所吩咐他的，带着食物去了。他来到军营中的时候，军队正出去列阵，吶喊助阵。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_21","010_17_21","1SA","17","21","21","以色列人和非利士人都摆列阵势，互相对峙。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_22","010_17_22","1SA","17","22","22","大卫把身上的东西留在看守物件的人手中，跑到战阵上去，向他的哥哥们问安。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_23","010_17_23","1SA","17","23","23","大卫正与他们说话的时候，那个讨战的人，就是迦特的非利士人，名叫歌利亚，从非利士人阵中上来；他说的又是同样的那些话，大卫都听见了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_24","010_17_24","1SA","17","24","24","所有的以色列人一看见那人，就都从他面前逃跑，非常害怕。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_25","010_17_25","1SA","17","25","25","以色列人彼此说：“这个上来的人你们看见了吗？他上来是要向以色列人骂阵的。如果有人能击杀他，王必赏赐他大财富，把自己的女儿给他作妻子，并且使他的父家在以色列中免纳税，免服役。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_26","010_17_26","1SA","17","26","26","大卫问站在他旁边的人说：“如果有人击杀这个非利士人，除去以色列人的耻辱，那人会得到怎么的对待呢？这未受割礼的非利士人是谁呢？竟敢向永活的　神的军队骂阵？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_27","010_17_27","1SA","17","27","27","于是众民用以上的那些话回答他说：“如果有人能击杀他，那人必得这样的对待。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_28","010_17_28","1SA","17","28","28","大卫与那些人说话的时候，他的大哥以利押听见了，就向大卫发怒，说：“你为什么下这里来呢？在旷野的那几只羊你托了给谁呢？我知道你的骄傲和你心里的恶意。你下来是要看打仗。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_29","010_17_29","1SA","17","29","29","大卫说：“我现在作了什么事呢？不是只说了一句话吗？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_30","010_17_30","1SA","17","30","30","大卫离开他的哥哥，转向另一个人，问同样的问题。众民还是用先前的话回答他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_31","010_17_31","1SA","17","31","31","有人听见大卫所说的这些话，就告诉扫罗；扫罗就派人去把大卫接来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_32","010_17_32","1SA","17","32","32","大卫对扫罗说：“大家都不要因这非利士人丧胆，你的仆人要去与这非利士人决斗。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_33","010_17_33","1SA","17","33","33","扫罗对大卫说：“你不能去与这非利士人决斗，因为你年纪还轻，那人从小就作战士。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_34","010_17_34","1SA","17","34","34","大卫对扫罗说：“你仆人是为父亲放羊的，有时狮子或熊来了，从羊群中抓去一只小羊， ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_35","010_17_35","1SA","17","35","35","我就出去追赶它，击打它，从它的嘴里把小羊救出来。如果它起来攻击我，我就揪住它的胡须，击打它，把它杀死。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_36","010_17_36","1SA","17","36","36","你仆人不但击杀过狮子，也击杀过熊。这个未受割礼的非利士人也必像一只狮子或熊一样，因为他向永活的　神的军队骂阵。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_37","010_17_37","1SA","17","37","37","大卫又说：“那曾救我脱离狮爪和熊掌的耶和华，也必救我脱离这非利士人的手。”于是扫罗对大卫说：“你去吧！愿耶和华与你同在。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_38","010_17_38","1SA","17","38","38","扫罗把自己的战袍给大卫穿上，把铜盔戴在他的头上，又给他穿上铠甲。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_39","010_17_39","1SA","17","39","39","大卫把刀佩带在战袍上。因为他以前没有穿过，现在试着走一下。大卫对扫罗说：“穿戴着这些东西，我不能走动，因为我从前没有穿过。”大卫就把这些装备从身上脱下来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_40","010_17_40","1SA","17","40","40","他手中拿着自己的杖，又从溪里挑选了五块光滑的石子，放在口袋里，就是牧人用的那种袋子，手里又拿着甩石的机弦，就向那非利士人走近去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_41","010_17_41","1SA","17","41","41","那非利士人也向着大卫慢慢走过来，拿大盾牌的人在他前面走。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_42","010_17_42","1SA","17","42","42","那非利士人观看，看见了大卫，就藐视他，因为他年纪还轻，面色红润，外貌英俊。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_43","010_17_43","1SA","17","43","43","那非利士人对大卫说：“难道我是一条狗吗？你竟拿杖来攻击我。”于是指着自己的神咒诅大卫。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_44","010_17_44","1SA","17","44","44","那非利士人又对大卫说：“你到我这里来吧！我要把你的肉给空中的飞鸟和田野的走兽吃。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_45","010_17_45","1SA","17","45","45","大卫回答那非利士人：“你来攻击我是靠刀、靠枪，但我来攻击你是靠万军之耶和华的名；万军之耶和华就是你所辱骂的以色列军队的　神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_46","010_17_46","1SA","17","46","46","今天耶和华要把你交在我手里，我必击杀你，砍下你的头。今天我还要把非利士人军队的尸体给空中的飞鸟和地上的野兽吃。这样，全地的人就都知道以色列中有一位　神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_47","010_17_47","1SA","17","47","47","也使这些人群都知道，耶和华拯救人不是靠刀，不是靠枪，因为战争的胜败在于耶和华，他必把你们交在我们的手里。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_48","010_17_48","1SA","17","48","48","那非利士人起身，迎着大卫慢慢走过来；大卫也赶快往阵上跑去，迎战那非利士人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_49","010_17_49","1SA","17","49","49","大卫伸手入口袋里，从里面拿出了一块石子来，用机弦甩去，击中了那非利士人的前额；石子穿入前额里面，他就仆倒，面伏于地。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_50","010_17_50","1SA","17","50","50","这样，大卫用机弦和一块石子胜过了那非利士人。大卫击杀了那非利士人，但他手中没有刀。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_51","010_17_51","1SA","17","51","51","大卫跑过去，站在那非利士人的身边，拿起他的刀来，把刀从鞘中拔出来，杀死他，又用刀砍下他的头。非利士人看见他们的勇士死了，就都逃跑。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_52","010_17_52","1SA","17","52","52","以色列人和犹大人就起来，高声吶喊，追赶非利士人，直到迦特的入口和以革伦的城门。被刺死的非利士人都倒在沙拉音的路上，直到迦特和以革伦。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_53","010_17_53","1SA","17","53","53","以色列人穷追非利士人回来以后，就抢掠他们的营房。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_54","010_17_54","1SA","17","54","54","大卫拿起那非利士人的头，把它带到耶路撒冷去，却把那人的武器放在自己的帐棚里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_55","010_17_55","1SA","17","55","55","扫罗看见大卫出去迎战那非利士人，就问元帅押尼珥：“押尼珥啊，这个年轻人是谁的儿子？”押尼珥回答：“我敢指着王起誓，我不知道。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_56","010_17_56","1SA","17","56","56","王说：“你去问问这个少年是谁的儿子。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_57","010_17_57","1SA","17","57","57","大卫击杀了那非利士人回来的时候，押尼珥迎接他，把他带到扫罗面前，大卫手中还拿着那非利士人的头。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S117_58","010_17_58","1SA","17","58","58","扫罗问他：“年轻人啊，你是谁的儿子？”大卫回答：“我是你仆人伯利恒人耶西的儿子。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S118_1","010_18_1","1SA","18","1","1","大卫对扫罗说完了话，约拿单的心和大卫的心就深相契合。约拿单爱大卫如同爱自己的命。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S118_2","010_18_2","1SA","18","2","2","从那天起，扫罗就把大卫留下来，不让他回到父家去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S118_3","010_18_3","1SA","18","3","3","约拿单与大卫立盟约，因为他爱大卫如同爱自己的命。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S118_4","010_18_4","1SA","18","4","4","约拿单把自己身上的外袍脱下来给大卫，又把自己的战衣、刀、弓和腰带都给了他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S118_5","010_18_5","1SA","18","5","5","扫罗无论差派大卫到哪里去，他都去，并且凡事亨通。于是扫罗立他作军兵的将领。所有的人民和扫罗的臣仆都非常高兴。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S118_6","010_18_6","1SA","18","6","6","大卫击杀了那非利士人，与众人一同回来的时候，妇女们从以色列各城里出来，唱歌、跳舞、打鼓、欢呼、击磬迎接扫罗王。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S118_7","010_18_7","1SA","18","7","7","妇女们跳舞、歌唱，说：“扫罗杀死千千！大卫杀死万万！” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S118_8","010_18_8","1SA","18","8","8","扫罗非常恼怒，不喜欢这话，就说：“他们给大卫万万，只给我千千，就只剩下王位没给他。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S118_9","010_18_9","1SA","18","9","9","从那天起，扫罗就妒忌大卫。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S118_10","010_18_10","1SA","18","10","10","第二天，从　神那里来的恶鬼降在扫罗身上，他就在家中胡言乱语。大卫照常弹琴，扫罗手里拿着枪。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S118_11","010_18_11","1SA","18","11","11","扫罗把枪掷过去，心里说：“我要把大卫刺在墙上。”大卫两次避开了他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S118_12","010_18_12","1SA","18","12","12","扫罗惧怕大卫，因为耶和华与大卫同在，却离开了扫罗。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S118_13","010_18_13","1SA","18","13","13","因此扫罗使大卫离开自己，立他作千夫长，大卫就领导众民出入。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S118_14","010_18_14","1SA","18","14","14","大卫所行的一切都亨通，因为耶和华与他同在。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S118_15","010_18_15","1SA","18","15","15","扫罗看见大卫所行的十分亨通，就怕他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S118_16","010_18_16","1SA","18","16","16","但是所有的以色列人和犹大人都爱大卫，因为他领导他们出入。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S118_17","010_18_17","1SA","18","17","17","扫罗对大卫说：“我的大女儿米拉在这里。我要把她赐给你作妻子；只要你作我的勇士，为耶和华争战。”原来扫罗心里说：“我不好亲手害他，让非利士人害他吧。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S118_18","010_18_18","1SA","18","18","18","大卫回答扫罗：“我是谁？我是什么身分？我父家在以色列人中算得什么？我怎么作王的女婿呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S118_19","010_18_19","1SA","18","19","19","到了扫罗的女儿米拉该嫁给大卫的时候，扫罗却把她给了米何拉人亚得列作妻子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S118_20","010_18_20","1SA","18","20","20","扫罗的女儿米甲爱大卫。有人把这事告诉扫罗，扫罗就欢喜， ");
INSERT INTO cmn_ncvs_vpl VALUES ("S118_21","010_18_21","1SA","18","21","21","心里想：“我要把米甲给大卫，利用米甲作他的陷阱，好让非利士人的手害他。”于是扫罗对大卫说：“你今天可以第二次作我的女婿。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S118_22","010_18_22","1SA","18","22","22","扫罗吩咐他的臣仆：“你们要私下对大卫说：‘王喜欢你，他的臣仆也都爱你，现在你要作王的女婿！’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S118_23","010_18_23","1SA","18","23","23","于是扫罗的臣仆把这些话说给大卫听。大卫说：“你们以为作王的女婿是一件小事吗？我是个贫穷卑微的人。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S118_24","010_18_24","1SA","18","24","24","扫罗的臣仆把大卫所说的这些话都报告了扫罗。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S118_25","010_18_25","1SA","18","25","25","扫罗说：“你们要对大卫这样说：‘王不要什么聘礼，只要一百个非利士人的包皮，好在王的仇敌身上报仇。’”扫罗企图使大卫死在非利士人的手里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S118_26","010_18_26","1SA","18","26","26","扫罗的臣仆把这些话告诉了大卫，大卫就乐意作王的女婿。在日期未满之时， ");
INSERT INTO cmn_ncvs_vpl VALUES ("S118_27","010_18_27","1SA","18","27","27","大卫和跟随他的人就起身出去，在非利士人中击杀了二百人，把他们的包皮带回来，满数交给王，要作王的女婿。于是扫罗把他的女儿米甲给大卫作妻子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S118_28","010_18_28","1SA","18","28","28","扫罗看见耶和华与大卫同在，又知道自己的女儿米甲也爱大卫， ");
INSERT INTO cmn_ncvs_vpl VALUES ("S118_29","010_18_29","1SA","18","29","29","就更怕大卫，常常与他为敌。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S118_30","010_18_30","1SA","18","30","30","非利士人的领袖常常出征，每逢他们出征，大卫作事都比扫罗所有的臣仆所作的更亨通，所以他的名字极为人尊重。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S119_1","010_19_1","1SA","19","1","1","扫罗吩咐他的儿子约拿单和他所有的臣仆要把大卫杀死，但扫罗的儿子约拿单非常喜爱大卫。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S119_2","010_19_2","1SA","19","2","2","约拿单告诉大卫：“我父亲扫罗正设法要杀死你。所以明天早晨你要小心，留在隐密的地方里，躲藏起来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S119_3","010_19_3","1SA","19","3","3","我会出去，到你藏身的那块田那里，站在我父亲旁边，和他谈论你的事。我看看情形怎样，然后告诉你。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S119_4","010_19_4","1SA","19","4","4","约拿单向父亲扫罗替大卫说好话，说：“王不要得罪你的仆人大卫，因为他没有得罪你；并且他所作的，对你大有好处。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S119_5","010_19_5","1SA","19","5","5","他冒着生命的危险击杀了那非利士人，耶和华为以色列人施行了大拯救，那时你看见了，也很欢喜。现在你为什么要犯罪，无缘无故杀死大卫，流无辜人的血呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S119_6","010_19_6","1SA","19","6","6","扫罗听了约拿单的话，就起誓，说：“我指着永活的耶和华起誓，大卫必不会被杀死。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S119_7","010_19_7","1SA","19","7","7","约拿单叫大卫来，把这一切话都告诉他；约拿单把大卫带到扫罗那里，他就像以前一样，侍候在扫罗面前。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S119_8","010_19_8","1SA","19","8","8","后来，又有战事；大卫出去与非利士人交战，大败他们，他们就在大卫面前逃跑。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S119_9","010_19_9","1SA","19","9","9","从耶和华那里来的恶鬼又临到扫罗身上；那时扫罗坐在屋里，手里拿着枪。大卫正在弹琴， ");
INSERT INTO cmn_ncvs_vpl VALUES ("S119_10","010_19_10","1SA","19","10","10","扫罗就想用枪刺杀大卫，把他刺在墙上，但大卫从扫罗面前躲开了，他的枪刺在墙上。那天晚上大卫逃跑，就逃脱了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S119_11","010_19_11","1SA","19","11","11","扫罗派人到大卫家里去监视他，要在第二天早晨杀死他。大卫的妻子米甲告诉他说：“今天晚上你若不逃命，明天就会被杀死。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S119_12","010_19_12","1SA","19","12","12","于是米甲从窗口把大卫缒下去，大卫就离开那里逃走，逃脱了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S119_13","010_19_13","1SA","19","13","13","米甲把家中的一尊神像拿来，放在床上，把头枕在用山羊毛弄成的枕头上，再用衣服盖着。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S119_14","010_19_14","1SA","19","14","14","扫罗派人来捉拿大卫，米甲说：“他病了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S119_15","010_19_15","1SA","19","15","15","扫罗又派人去看大卫说：“你们把他连床一起抬到我这里来，我好杀死他。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S119_16","010_19_16","1SA","19","16","16","奉派的人进去，看见床上有一尊家中的神像，头枕在用山羊毛弄成的枕头上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S119_17","010_19_17","1SA","19","17","17","扫罗问米甲：“你为什么这样欺骗我，放了我的仇敌，让他逃走呢？”米甲回答扫罗：“他对我说：‘放我走！否则我要杀死你。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S119_18","010_19_18","1SA","19","18","18","大卫逃跑，逃脱了，来到拉玛见撒母耳，把扫罗对他所作的一切都告诉了撒母耳。然后他和撒母耳去拿约，住在那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S119_19","010_19_19","1SA","19","19","19","有人告诉扫罗：“大卫住在拉玛的拿约。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S119_20","010_19_20","1SA","19","20","20","于是扫罗派人去捉大卫。派去的人看见一群先知正在受感说话，撒母耳站着带领他们。那时，　神的灵也临到扫罗的使者身上，他们都受感说话。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S119_21","010_19_21","1SA","19","21","21","有人把这事告诉了扫罗，他就再派别的人去，这些人也受感说话。扫罗第三次派人去，他们也受感说话。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S119_22","010_19_22","1SA","19","22","22","后来，扫罗也亲自到拉玛去，到了西沽的大井，就问人，说：“撒母耳和大卫在哪里？”有一个人回答：“在拉玛的拿约。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S119_23","010_19_23","1SA","19","23","23","扫罗就从那里往拉玛的拿约去。　神的灵也临到他身上，他一面走，一面受感说话，直到他到了拉玛的拿约。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S119_24","010_19_24","1SA","19","24","24","他脱掉了自己的衣服，也在撒母耳面前受感说话。那一日，他整天整夜赤着身子躺着，因此有一句俗语说：“扫罗也列在先知中吗？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S120_1","010_20_1","1SA","20","1","1","大卫从拉玛的拿约逃走，来见约拿单，说：“我作了什么？我有什么罪孽？我在你父亲面前犯了什么罪，他竟寻索我的性命呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S120_2","010_20_2","1SA","20","2","2","约拿单对他说：“绝对没有这事，你必不会死。我父亲作事，无论大小，没有不让我知道的，为什么这事他偏要隐瞒我呢？不会这样的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S120_3","010_20_3","1SA","20","3","3","大卫再起誓说：“你父亲一定知道我在你眼中蒙恩，就心里想：‘不要让约拿单知道这事，免得他伤心。’可是，我指着永活的耶和华，又指着你的性命起誓，我离死只差一步。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S120_4","010_20_4","1SA","20","4","4","约拿单对大卫说：“你心里想要什么，我必为你作成。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S120_5","010_20_5","1SA","20","5","5","大卫就对约拿单说：“你看，明天是初一，我本该与王一同坐席。但是，求你容我去藏在田里，直到后天晚上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S120_6","010_20_6","1SA","20","6","6","如果你父亲不见我在座，你就说：‘大卫恳求我让他赶回他的本城伯利恒去，因为他全家在那里有献年祭的事。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("S120_7","010_20_7","1SA","20","7","7","如果你父亲这样说：‘好！’那么仆人就平安无事了；如果他大大发怒，你就知道，他决意要害我了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S120_8","010_20_8","1SA","20","8","8","求你以慈爱待仆人，因为你曾与仆人在耶和华面前立盟约。如果我有罪孽，你就亲手把我杀死，为什么要把我交给你父亲呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S120_9","010_20_9","1SA","20","9","9","约拿单说：“绝对没有这事，如果我知道我父亲决意要害你，我会不告诉你吗？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S120_10","010_20_10","1SA","20","10","10","大卫对约拿单说：“如果你父亲严厉地回答你，谁来告诉我呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S120_11","010_20_11","1SA","20","11","11","约拿单对大卫说：“你来，我们出到田里去吧！”他们二人就出到田里去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S120_12","010_20_12","1SA","20","12","12","约拿单对大卫说：“愿耶和华以色列的　神作证，明天或后天约在这个时候，我探出了我父亲的意思，如果他对你有好感，那时我会不派人来告诉你吗？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("S120_13","010_20_13","1SA","20","13","13","假如我父亲有意要害你，我若是不告诉你，不让你走，不使你平平安安地离去，愿耶和华加倍惩罚我。愿耶和华与你同在，好像从前与我父亲同在一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S120_14","010_20_14","1SA","20","14","14","我活着的时候，求你以耶和华的慈爱待我，使我不致于死。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S120_15","010_20_15","1SA","20","15","15","我死了以后，耶和华从地上一一剪除大卫的仇敌的时候，你也不可向我的家永远断绝你的慈爱。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S120_16","010_20_16","1SA","20","16","16","于是约拿单与大卫家立盟约，说：“愿耶和华借大卫仇敌的手追讨违背盟约的罪。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S120_17","010_20_17","1SA","20","17","17","约拿单由于爱大卫，就使大卫再起誓；他爱大卫如同爱自己的命。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S120_18","010_20_18","1SA","20","18","18","约拿单对大卫说：“明天是初一，因为你的座位空着，人必注意到你不在。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S120_19","010_20_19","1SA","20","19","19","到后天，你要赶快下去，到你以前出事那天藏身的地方，在以色磐石旁边等候。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S120_20","010_20_20","1SA","20","20","20","我要向磐石旁边射三支箭，好像射箭靶一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S120_21","010_20_21","1SA","20","21","21","然后，我要派一个仆人去，说：‘你去把箭找回来。’如果我对那仆人说：‘看哪！箭在你的后面，把箭拿回来。’你就可以回来，因为我指着永活的耶和华起誓，你必平安无事。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S120_22","010_20_22","1SA","20","22","22","如果我对仆人说：‘看哪！箭在你的前面。’你就要离去，因为是耶和华打发你去的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S120_23","010_20_23","1SA","20","23","23","至于你我之间所说的这事，有耶和华永远在你我之间作证。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S120_24","010_20_24","1SA","20","24","24","于是大卫在田里藏起来。到了初一，王坐席吃饭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S120_25","010_20_25","1SA","20","25","25","王照常坐在他的座位上，就是靠墙的座位，约拿单坐在对面，押尼珥坐在扫罗旁边，大卫的座位却空着。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S120_26","010_20_26","1SA","20","26","26","那天扫罗没有说什么，因为他心里想：“这是恰巧的事，或许大卫沾染了不洁，还没有得到洁净。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S120_27","010_20_27","1SA","20","27","27","次日，就是初二，大卫的座位仍是空着。于是扫罗问他的儿子约拿单：“为什么耶西的儿子昨天今天都没有来吃饭呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S120_28","010_20_28","1SA","20","28","28","约拿单回答扫罗：“大卫恳切地求我让他回伯利恒去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S120_29","010_20_29","1SA","20","29","29","他说：‘求你让我去，因为我们的家在城里有献祭的事，我哥哥吩咐我去。所以，我若是在你眼前蒙恩，求你让我离开，看看我的哥哥们。’因此，大卫没有来赴王的筵席。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S120_30","010_20_30","1SA","20","30","30","于是扫罗向约拿单发怒，对他说：“你这邪僻悖逆妇人所生的，我岂不知道你喜悦耶西的儿子，自取羞辱，也羞辱生你的母亲吗？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("S120_31","010_20_31","1SA","20","31","31","因为只要耶西的儿子还活在这世上，你和你的国就不能稳固。现在，你要派人去把他抓到我这里来，因为他是该死的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S120_32","010_20_32","1SA","20","32","32","约拿单回答他父亲扫罗说：“为什么要把他处死呢？他作了什么事呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S120_33","010_20_33","1SA","20","33","33","扫罗向着约拿单把枪掷过去，要刺杀他。约拿单就知道，他父亲已经决意要杀死大卫。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S120_34","010_20_34","1SA","20","34","34","约拿单怒气冲冲地从席间退去，初二这天，他没有吃饭；因为他父亲羞辱了大卫，他就为大卫担忧。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S120_35","010_20_35","1SA","20","35","35","到了早晨，约拿单照着与大卫约定的时候，出到田里去，有一个小童与他在一起。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S120_36","010_20_36","1SA","20","36","36","他对那童仆说：“你跑去，把我所射的箭找回来。”那童仆跑去的时候，约拿单就把箭射到他前面。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S120_37","010_20_37","1SA","20","37","37","那童仆到了约拿单的箭射到的地方，约拿单就在那童仆的背后喊叫：“箭不是在你的前面吗？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S120_38","010_20_38","1SA","20","38","38","约拿单又在那童仆的背后喊叫：“赶快跑去！不要停留！”那童仆就把箭拾起来，回到他主人那里去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S120_39","010_20_39","1SA","20","39","39","那童仆一点也不知道这是什么意思，只有约拿单和大卫知道。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S120_40","010_20_40","1SA","20","40","40","约拿单把自己的武器交给他的童仆，对他说：“你带回城里去吧！” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S120_41","010_20_41","1SA","20","41","41","那童仆一离去，大卫就从石堆的南边起来，脸伏于地，叩拜了三次。二人互相亲嘴，相对哭泣，大卫哭得更悲痛。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S120_42","010_20_42","1SA","20","42","42","约拿单对大卫说：“你平平安安走吧！我们二人曾指着耶和华的名起誓说：‘愿耶和华在你我之间，也在我的后裔和你的后裔之间作证，直到永远。’”大卫就起身离开，约拿单也回城里去了（“大卫就起身离开，约拿单也回城里去了。”在《马索拉抄本》为 21:1）。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S121_1","010_21_1","1SA","21","1","1","大卫到了挪伯祭司亚希米勒那里，亚希米勒战战兢兢地迎接大卫，对他说：“你为什么独自一人，没有人跟随你呢？”（本节在《马索拉抄本》为 21:2） ");
INSERT INTO cmn_ncvs_vpl VALUES ("S121_2","010_21_2","1SA","21","2","2","大卫对亚希米勒祭司说：“王吩咐我作一件事，对我说：‘我差派你，吩咐你去办的这事，你不要让任何人知道，我已经指示我的仆人在某地会面。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("S121_3","010_21_3","1SA","21","3","3","现在你手中有什么？求你给我五个饼，或是别的食物。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S121_4","010_21_4","1SA","21","4","4","祭司回答大卫：“我手中没有普通的饼，只有圣饼。只有那些没有亲近过女人的年轻人，才可以吃的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S121_5","010_21_5","1SA","21","5","5","大卫回答祭司说：“像以往我出征的时候一样，这次我们出征前，确实没有亲近女人。虽然这是一次普通的任务，众仆人的器皿还是清洁的，何况今天这些器皿更加是清洁的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S121_6","010_21_6","1SA","21","6","6","于是祭司把圣饼给他，因为在那里没有别的饼，只有陈设饼，就是那些刚从耶和华面前拿下来，为要换上热的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S121_7","010_21_7","1SA","21","7","7","那天有一个扫罗的臣仆在那里，留在耶和华面前。他名叫多益，是以东人，是扫罗牧羊人中的领袖。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S121_8","010_21_8","1SA","21","8","8","大卫问亚希米勒：“你手下有枪有刀没有？因为王的事很急迫，所以我手里连刀剑或其他武器都没有带来。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S121_9","010_21_9","1SA","21","9","9","祭司回答：“有一把刀，是你从前在以拉谷击杀的那非利士人歌利亚的刀。这刀用布包着，放在以弗得后面，你若是要拿去自用，就拿去吧，因为这里除了这刀以外，再没有别的武器了。”大卫说：“没有比这更好的刀了，请你给我吧！” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S121_10","010_21_10","1SA","21","10","10","那一天大卫起来，从扫罗面前逃走，到了迦特王亚吉那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S121_11","010_21_11","1SA","21","11","11","亚吉的臣仆对亚吉说：“这不是那地的王大卫吗？那里的妇女不是指着他跳舞歌唱说：‘扫罗杀死千千，大卫杀死万万’吗？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S121_12","010_21_12","1SA","21","12","12","大卫把这些话记在心里，他非常怕迦特王亚吉， ");
INSERT INTO cmn_ncvs_vpl VALUES ("S121_13","010_21_13","1SA","21","13","13","就在众人面前假装神智不健全，在他们手下装疯，在城门的门扇上胡乱涂写，又让唾沫流到胡须上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S121_14","010_21_14","1SA","21","14","14","亚吉就对他的臣仆说：“你们看，这个人疯了，你们为什么把他带到我这里来呢？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("S121_15","010_21_15","1SA","21","15","15","难道我缺少疯子吗？你们竟把这人带来我面前发疯。这人怎可以进我的家呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S122_1","010_22_1","1SA","22","1","1","大卫离开那里，逃到亚杜兰洞。他哥哥们和他父亲的全家听到了，就都下到他那里去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S122_2","010_22_2","1SA","22","2","2","凡是受窘迫的、负债的、心里不满的，都聚集到大卫那里，他就成了他们的领袖。那时，跟从他的约有四百人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S122_3","010_22_3","1SA","22","3","3","大卫从那里到摩押的米斯巴去，对摩押王说：“求你容许我父母来住在你们这里，直到我知道　神要为我作什么。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S122_4","010_22_4","1SA","22","4","4","于是大卫把他们留在摩押王那里。大卫住在山寨的日子有多久，他父母也与摩押王同住多久。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S122_5","010_22_5","1SA","22","5","5","迦得先知对大卫说：“你不要留在山寨，要到犹大地去。”大卫就离开那里，往哈列的森林去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S122_6","010_22_6","1SA","22","6","6","扫罗听见发现了大卫和跟从他的人的行踪。那时扫罗在基比亚坐在山上一棵垂柳树下，手中拿着枪，众臣仆侍立在他周围。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S122_7","010_22_7","1SA","22","7","7","扫罗就对侍立在他周围的臣仆说：“便雅悯人哪，你们要听！耶西的儿子能把田地和葡萄园赐给你们各人吗？他能立你们各人作千夫长、作百夫长吗？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("S122_8","010_22_8","1SA","22","8","8","你们竟都同谋陷害我。我的儿子与耶西的儿子立盟约的时候，没有人告诉我；我的儿子挑唆我的臣仆陷害我，就像今天一样，你们中间也没有人关心我，告诉我。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S122_9","010_22_9","1SA","22","9","9","那时以东人多益与扫罗的臣仆侍立在那里，他回答说：“我曾看见耶西的儿子到了挪伯亚希突的儿子亚希米勒那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S122_10","010_22_10","1SA","22","10","10","亚希米勒为他求问耶和华，给他粮食，又把非利士人歌利亚的刀给他。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S122_11","010_22_11","1SA","22","11","11","扫罗就派人去把亚希突的儿子，亚希米勒祭司和他父亲的全家，就是在挪伯的众祭司，都召了来；他们众人都来见王。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S122_12","010_22_12","1SA","22","12","12","扫罗说：“亚希突的儿子啊！你要听。”他回答：“我主啊！我在这里。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S122_13","010_22_13","1SA","22","13","13","扫罗对他说：“你为什么与耶西的儿子合谋陷害我？把食物和刀给他，又为他求问　神，使他起来陷害我，就像今天一样呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S122_14","010_22_14","1SA","22","14","14","亚希米勒回答王说：“在你所有的臣仆中，有谁像大卫那样忠心呢？他是王的女婿，又是你的卫队的队长，并且在你朝中是受敬重的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S122_15","010_22_15","1SA","22","15","15","我岂是今天才开始为他求问　神的呢？绝对不是。请王不要归罪于我和我父的全家，因为这整件事无论大小，我都不知道。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S122_16","010_22_16","1SA","22","16","16","王说：“亚希米勒啊！你和你父的全家都是该死的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S122_17","010_22_17","1SA","22","17","17","王就对侍立在他周围的卫兵说：“你们转过去，把耶和华的祭司杀死，因为他们与大卫携手，又因为他们知道大卫逃跑，也不告诉我。”但王的臣仆不愿下手杀害耶和华的祭司。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S122_18","010_22_18","1SA","22","18","18","于是王对多益说：“你转过去把祭司击杀。”以东人多益就转过去把祭司击杀了。那一天，他杀了八十五个穿以弗得的人， ");
INSERT INTO cmn_ncvs_vpl VALUES ("S122_19","010_22_19","1SA","22","19","19","又用刀击杀了祭司城挪伯，无论男女，孩童或吃奶的婴儿，牛驴或羊，都用刀杀尽。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S122_20","010_22_20","1SA","22","20","20","亚希突的儿子亚希米勒有一个儿子，名叫亚比亚他，逃过了大难，就逃去跟随大卫。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S122_21","010_22_21","1SA","22","21","21","亚比亚他把扫罗杀害耶和华祭司的事告诉了大卫， ");
INSERT INTO cmn_ncvs_vpl VALUES ("S122_22","010_22_22","1SA","22","22","22","大卫就对亚比亚他说：“那一天我见以东人多益在那里，就知道他必定会告诉扫罗。你父全家每个人的死，我都有责任。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S122_23","010_22_23","1SA","22","23","23","你可以住在我这里。不要惧怕，因为那寻索你命的，正在寻索我的命，你与我在一起就可保安全。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S123_1","010_23_1","1SA","23","1","1","有人告诉大卫：“看哪，非利士人正在攻打基伊拉，并且抢掠禾场。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S123_2","010_23_2","1SA","23","2","2","大卫就求问耶和华说：“我可以去击打这些非利士人吗？”耶和华对大卫说：“你可以去击打非利士人，拯救基伊拉。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S123_3","010_23_3","1SA","23","3","3","跟随大卫的人对他说：“看哪，我们在犹大地这里尚且惧怕，何况到基伊拉去攻打非利士人的军兵呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S123_4","010_23_4","1SA","23","4","4","于是大卫再求问耶和华。耶和华回答他说：“你只管起来，下到基伊拉去，因为我必把非利士人交在你的手里。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S123_5","010_23_5","1SA","23","5","5","大卫和跟随他的人就到基伊拉去，与非利士人争战，掳走了他们的牲畜，又在他们中间杀戮多人。这样，大卫拯救了基伊拉的居民。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S123_6","010_23_6","1SA","23","6","6","亚希米勒的儿子亚比亚他逃到基伊拉去见大卫的时候，是手里带着以弗得下来的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S123_7","010_23_7","1SA","23","7","7","有人告诉扫罗，大卫到了基伊拉，扫罗就说：“　神把他交在我的手中了，因为他进了一座有门有闩的城，把自己关闭起来了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S123_8","010_23_8","1SA","23","8","8","于是扫罗召集众人去争战，要下到基伊拉去，围困大卫和跟随他的人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S123_9","010_23_9","1SA","23","9","9","大卫知道扫罗设计害他，就对亚比亚他祭司说：“把以弗得拿来！” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S123_10","010_23_10","1SA","23","10","10","大卫说：“耶和华以色列的　神啊！你仆人确实听见了扫罗想要到基伊拉来，为了我的缘故要毁灭这城。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S123_11","010_23_11","1SA","23","11","11","基伊拉人会把我交在扫罗的手里吗？扫罗会照着你仆人所听到的下来吗？耶和华以色列的　神啊！求你告诉你仆人。”耶和华说：“他必下来。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S123_12","010_23_12","1SA","23","12","12","大卫又说：“基伊拉人会把我和跟随我的人交在扫罗手里吗？”耶和华说：“他们必把你们交出来。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S123_13","010_23_13","1SA","23","13","13","大卫和跟从他的人，约有六百人，就起身离开基伊拉，到处漂泊。有人告诉扫罗，大卫已经逃离了基伊拉，扫罗就不出去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S123_14","010_23_14","1SA","23","14","14","大卫住在旷野的山寨里，又住在亚弗旷野的山里。扫罗天天寻索大卫，　神却不把大卫交在他手里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S123_15","010_23_15","1SA","23","15","15","大卫惧怕，因为扫罗出来寻索他的命。那时大卫住在西弗旷野的何列斯那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S123_16","010_23_16","1SA","23","16","16","扫罗的儿子约拿单起身，到何列斯去见大卫，鼓励他，使他靠　神坚强起来， ");
INSERT INTO cmn_ncvs_vpl VALUES ("S123_17","010_23_17","1SA","23","17","17","对他说：“你不要惧怕！我父亲扫罗的手必不能害你。你必要作以色列的王，我要在你以下位居第二，这事连我父亲扫罗也知道了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S123_18","010_23_18","1SA","23","18","18","于是他们二人在耶和华面前立了约。大卫仍住在何列斯，约拿单却回自己的家去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S123_19","010_23_19","1SA","23","19","19","西弗人上到基比亚去见扫罗，说：“大卫不是在我们这里的何列斯的山寨，就是在旷野南边的哈基拉山上藏着吗？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("S123_20","010_23_20","1SA","23","20","20","王啊，现在请下来，请你随着你的心愿下来，我们必亲自把他交在王的手里。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S123_21","010_23_21","1SA","23","21","21","扫罗说：“愿耶和华赐福你们，因为你们关心我。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S123_22","010_23_22","1SA","23","22","22","你们要去再确实查看他脚踪所到的地方，有谁看见他在那里，因为有人对我说，他非常狡猾。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S123_23","010_23_23","1SA","23","23","23","你们要去查看他所有藏身的地方，确定以后再回来见我，我就与你们同去；如果他在本地，我必从犹大的千门万户中把他搜出来。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S123_24","010_23_24","1SA","23","24","24","于是西弗人起身，在扫罗以先到西弗去了。那时大卫和跟随他的人却在玛云旷野，就是在荒野南边的亚拉巴。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S123_25","010_23_25","1SA","23","25","25","扫罗和跟随他的人去寻找大卫。有人告诉大卫，他就下到磐石那里，留在玛云旷野。扫罗听见了，就在玛云旷野追赶大卫。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S123_26","010_23_26","1SA","23","26","26","扫罗在山这边走，大卫和跟随他的人却在山那边走。大卫匆匆忙忙逃避扫罗，扫罗和跟随他的人却四面包围大卫和跟随他的人，要把他们捉住。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S123_27","010_23_27","1SA","23","27","27","那时忽有使者来见扫罗说：“请你赶快回去，因为非利士人来突击这地。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S123_28","010_23_28","1SA","23","28","28","于是扫罗不再追赶大卫，回去迎战非利士人。因此这地方被称为西拉．哈玛希罗结。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S123_29","010_23_29","1SA","23","29","29","大卫从那里上去，住在隐．基底的山寨里。（本节在《马索拉抄本》为 24:1） ");
INSERT INTO cmn_ncvs_vpl VALUES ("S124_1","010_24_1","1SA","24","1","1","扫罗追赶非利士人回来的时候，有人告诉他说：“看哪，大卫在隐．基底的旷野。”（本节在《马索拉抄本》为 24:2） ");
INSERT INTO cmn_ncvs_vpl VALUES ("S124_2","010_24_2","1SA","24","2","2","扫罗就从以色列人中选出三千精兵，带领他们到野羊磐石去搜索大卫和跟随他的人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S124_3","010_24_3","1SA","24","3","3","到了路旁的羊圈，那里有一个洞，扫罗进去大解；那时，大卫和跟随他的人正坐在洞里的深处。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S124_4","010_24_4","1SA","24","4","4","跟随大卫的人对他说：“耶和华曾应许你说：‘我要把你的仇敌交在你的手里，你可以随意待他。’看哪！今天就是时候了。”于是大卫起来，悄悄地割下扫罗外袍的衣边。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S124_5","010_24_5","1SA","24","5","5","事后，大卫为了割下扫罗的衣边，心中自责， ");
INSERT INTO cmn_ncvs_vpl VALUES ("S124_6","010_24_6","1SA","24","6","6","就对跟随他的人说：“我在耶和华面前绝对不能这样对待我主耶和华的受膏者，我绝对不能动手攻击他，因为他是耶和华的受膏者。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S124_7","010_24_7","1SA","24","7","7","大卫用这些话阻止了跟随他的人，不让他们起来攻击扫罗。扫罗起来，出了山洞，继续走他的路去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S124_8","010_24_8","1SA","24","8","8","随后，大卫也起来，离开了山洞，在扫罗背后呼叫，说：“我主！我王！”扫罗回头向后看的时候，大卫就脸伏于地，向他叩拜。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S124_9","010_24_9","1SA","24","9","9","大卫对扫罗说：“你为什么听信人的话，说：‘大卫想要害你’呢？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("S124_10","010_24_10","1SA","24","10","10","现在你亲眼看到，今天耶和华在山洞里，把你交在我手里。有人叫我杀你，我却爱惜你。我说：‘我不敢下手伤害我主，因为他是耶和华的受膏者。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("S124_11","010_24_11","1SA","24","11","11","我父啊，请看，你外袍的衣边在我手中。我割下了你外袍的衣边，却没有杀你。你从此可以知道，也可以看出我手中没有邪恶，也没有过犯。我虽然没有得罪你，你却要猎取我的性命。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S124_12","010_24_12","1SA","24","12","12","愿耶和华在你我之间判断是非；愿耶和华在你身上为我伸冤。我的手却不敢伤害你。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S124_13","010_24_13","1SA","24","13","13","正如古时的格言：‘恶事出于恶人。’所以，我的手不敢伤害你。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S124_14","010_24_14","1SA","24","14","14","以色列的王出去追捕谁呢？你现在追赶谁呢？不过是追赶一条死狗，一只跳蚤吧了！ ");
INSERT INTO cmn_ncvs_vpl VALUES ("S124_15","010_24_15","1SA","24","15","15","愿耶和华在你我中间施行审判，断定是非；愿他鉴察，为我的案件伸冤，救我脱离你的手。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S124_16","010_24_16","1SA","24","16","16","大卫对扫罗说完了这些话，扫罗就说：“我儿大卫啊，这是你的声音吗？”于是扫罗放声大哭， ");
INSERT INTO cmn_ncvs_vpl VALUES ("S124_17","010_24_17","1SA","24","17","17","对大卫说：“你比我公义，因为你以良善待我，我却以恶待你。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S124_18","010_24_18","1SA","24","18","18","今天你所作的说明了你以良善待我，因为耶和华把我交在你手里，你却没有杀我。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S124_19","010_24_19","1SA","24","19","19","如果人遇见仇敌，怎会让他平平安安离去呢？愿耶和华因你今天对我所作的报答你。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S124_20","010_24_20","1SA","24","20","20","现在我知道你必要作王，以色列的王国必在你手里坚立起来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S124_21","010_24_21","1SA","24","21","21","现在你要指着耶和华向我起誓，不剪除我的后裔，也不从我父家消灭我的名。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S124_22","010_24_22","1SA","24","22","22","于是大卫向扫罗起誓，扫罗就回自己的家去了，大卫和跟随他的人也上山寨去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S125_1","010_25_1","1SA","25","1","1","撒母耳死了，以色列众人都聚集起来，为他哀哭，把他埋葬在拉玛他自己的家里。大卫起身，下到巴兰的旷野去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S125_2","010_25_2","1SA","25","2","2","在玛云有一个人，他的产业在迦密。他是一个很富有的人，有绵羊三千只，山羊一千只，那时他正在迦密剪羊毛。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S125_3","010_25_3","1SA","25","3","3","那人名叫拿八，他的妻子名叫亚比该。这女人既聪明，又美丽。但那男人为人粗暴，又行事凶恶。他是个迦密族的人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S125_4","010_25_4","1SA","25","4","4","大卫在旷野听说拿八正在剪羊毛， ");
INSERT INTO cmn_ncvs_vpl VALUES ("S125_5","010_25_5","1SA","25","5","5","就差派十个仆人，对他们说：“你们上迦密去见拿八，以我的名义向他问安。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S125_6","010_25_6","1SA","25","6","6","你们要这样说：‘愿你长寿！愿你平安！愿你的家平安！愿你所有的一切都平安！ ");
INSERT INTO cmn_ncvs_vpl VALUES ("S125_7","010_25_7","1SA","25","7","7","现在我听说有人为你剪羊毛。你的牧人与我们在一起的时候，我们都没有侮辱他们；他们在迦密的日子，也从没有遗失过什么。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S125_8","010_25_8","1SA","25","8","8","你可以问问你的仆人，他们必会告诉你。愿我派来的这些仆人在你眼前蒙恩，因为我们是在好日子来的，请你把手中所有的，随便赏赐一点给你的仆人和你的儿子大卫。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S125_9","010_25_9","1SA","25","9","9","大卫的仆人到了，就以大卫的名义，把这些话都对拿八说了，然后等候答复。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S125_10","010_25_10","1SA","25","10","10","拿八回答大卫的仆人说：“大卫是谁？耶西的儿子是谁？现在离开主人逃走的仆人太多了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S125_11","010_25_11","1SA","25","11","11","我怎能把我的饼、我的水，和我为剪羊毛的人宰杀的肉，给那些我不知道从哪里来的人呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S125_12","010_25_12","1SA","25","12","12","于是大卫的仆人转回原路，回去了。他们到了以后，就把这一切话都告诉大卫。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S125_13","010_25_13","1SA","25","13","13","大卫对跟随他的人说：“你们各人都佩上刀。”他们各人就佩上自己的刀，大卫也佩上自己的刀。跟随大卫上去的约有四百人，有二百人留下来看守器具。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S125_14","010_25_14","1SA","25","14","14","拿八的一个仆人告诉拿八的妻子亚比该说：“大卫从旷野派遣使者来向我们的主人问候，主人却辱骂了他们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S125_15","010_25_15","1SA","25","15","15","但是，那些人对我们很好。我们在田野与他们往来的时候，他们都没有侮辱我们，我们也从没有遗失过什么。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S125_16","010_25_16","1SA","25","16","16","我们与他们在一起牧羊的日子，他们日夜都作保护我们的墙。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S125_17","010_25_17","1SA","25","17","17","现在，你要想一想，看看你该怎么办，因为灾祸必定临到我们的主人和他的全家。他是一个性情凶恶的人，没有人敢对他说话。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S125_18","010_25_18","1SA","25","18","18","亚比该急忙拿了两百个饼、两皮袋酒、五只预备好了的羊、十七公斤烘好了的穗子、一百个葡萄饼、两百个无花果饼，都驮在驴背上， ");
INSERT INTO cmn_ncvs_vpl VALUES ("S125_19","010_25_19","1SA","25","19","19","然后对她的仆人说：“你们先去，我随着你们来。”这事她却没有告诉她的丈夫拿八。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S125_20","010_25_20","1SA","25","20","20","亚比该骑着驴，正从山坡下来，忽见大卫和跟随他的人也正从对面迎着她走下来，亚比该就与他相遇了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S125_21","010_25_21","1SA","25","21","21","大卫曾经说过：“我在旷野看守这人一切所有的，使他一切所有的一样也没有失落，实在是白费心机了。他竟然对我以恶报善。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S125_22","010_25_22","1SA","25","22","22","如果我让这人一切所有的，就是一个男丁，留到明天早晨，　神怎样惩罚大卫的仇敌，愿他也怎样加倍惩罚我。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S125_23","010_25_23","1SA","25","23","23","亚比该见了大卫，就急忙从驴背下来，俯伏在大卫面前，脸伏于地，向他叩拜。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S125_24","010_25_24","1SA","25","24","24","她又俯伏在大卫的脚前，说：“我王啊，愿这罪孽归我。求你容婢女向你讲话，求你听婢女所说的话。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S125_25","010_25_25","1SA","25","25","25","请我主不要把这个性情凶恶的人拿八放在心上。因为他的名字怎样，他的为人也怎样。他名叫拿八，他也真是愚笨。我主派来的仆人，你的婢女并没有看见。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S125_26","010_25_26","1SA","25","26","26","我主啊，现在我指着永活的耶和华，又在你面前起誓，耶和华既然阻止了你流人的血，又阻止了你亲手报仇，愿你的仇敌和那些谋害我主的人，都像拿八一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S125_27","010_25_27","1SA","25","27","27","现在，请把你婢女给我主带来的这礼物，赐给跟随我主的仆人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S125_28","010_25_28","1SA","25","28","28","求你饶恕你婢女的过犯。耶和华必为我主建立一个坚固的家，因为我主为耶和华争战；在你一生的日子里，在你身上也找不到什么过错。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S125_29","010_25_29","1SA","25","29","29","虽然有人起来追赶你，寻索你的命，我主的性命必得保全在耶和华你的　神生命的囊中。至于你仇敌的命，耶和华却要甩去，像从甩石机甩出去一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S125_30","010_25_30","1SA","25","30","30","将来耶和华照着他应许的一切善待了你，立了你作以色列的领袖的时候， ");
INSERT INTO cmn_ncvs_vpl VALUES ("S125_31","010_25_31","1SA","25","31","31","我主就不致因为无缘无故流人的血或亲自报仇而良心不安，心里有愧了。耶和华恩待了我主以后，求你记念你的婢女。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S125_32","010_25_32","1SA","25","32","32","大卫对亚比该说：“耶和华以色列的　神是应当称颂的！他今天差派你来迎接我。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S125_33","010_25_33","1SA","25","33","33","你的智慧和你的为人也是应当称赞的，因为你今天阻止了我流人的血，又阻止了我亲手报仇。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S125_34","010_25_34","1SA","25","34","34","我指着那拦阻了我加害你的永活的耶和华以色列的　神起誓，如果你不及时来迎见我，到明天早晨，拿八所有的男丁必不留一个。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S125_35","010_25_35","1SA","25","35","35","大卫从亚比该手中接受了她带来给他的东西，就对她说：“你平平安安回家去吧！你看，我已经听了你的话，也答应了你的请求。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S125_36","010_25_36","1SA","25","36","36","亚比该到了拿八那里，他正在家中摆设筵席，好像帝王的筵席一样。拿八心里畅快，喝得烂醉如泥，所以无论大事小事亚比该都没有告诉他，直到第二天早晨。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S125_37","010_25_37","1SA","25","37","37","到了早晨，拿八酒醒了，他的妻子才把这些事告诉他，他就吓得魂不附体，立刻中风瘫痪了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S125_38","010_25_38","1SA","25","38","38","大约过了十天，耶和华击打拿八，他就死了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S125_39","010_25_39","1SA","25","39","39","大卫听见拿八死了，就说：“耶和华是应当称颂的，因为他为我伸了拿八羞辱我的冤，又阻止了仆人行恶，也使拿八的恶归到他自己的头上。”于是大卫派人去对亚比该说要娶她作他的妻子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S125_40","010_25_40","1SA","25","40","40","大卫的仆人到了迦密去见亚比该，对她说：“大卫差派我们到你这里来，要娶你作他的妻子。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S125_41","010_25_41","1SA","25","41","41","亚比该就起来，面伏于地叩拜，说：“婢女愿意作女仆，洗我主人的脚！” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S125_42","010_25_42","1SA","25","42","42","亚比该急忙起来，骑上驴，带着五个跟随她的女仆，跟从大卫的使者去了，就作了大卫的妻子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S125_43","010_25_43","1SA","25","43","43","大卫先娶了耶斯列人亚希暖，她们二人都作了他的妻子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S125_44","010_25_44","1SA","25","44","44","扫罗已经把他的女儿米甲，就是大卫的妻子，赐给了迦琳人拉亿的儿子帕提作妻子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S126_1","010_26_1","1SA","26","1","1","西弗人基比亚来见扫罗，说：“大卫不是在旷野前面的哈基拉山中躲藏起来吗？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S126_2","010_26_2","1SA","26","2","2","扫罗就动身，下到西弗旷野去，跟随他的有三千以色列精兵，要在西弗的旷野寻索大卫。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S126_3","010_26_3","1SA","26","3","3","那时，扫罗在旷野前面的哈基拉山的路旁安营，大卫仍然住在旷野。大卫看见扫罗来到旷野追寻他， ");
INSERT INTO cmn_ncvs_vpl VALUES ("S126_4","010_26_4","1SA","26","4","4","就派出探子，知道扫罗已经到了纳康。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S126_5","010_26_5","1SA","26","5","5","大卫起来，来到扫罗安营的地方，看见扫罗和他的元帅，尼珥的儿子押尼珥睡卧的地方。扫罗睡在军营的中央，众人都在他的周围安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S126_6","010_26_6","1SA","26","6","6","大卫问赫人亚希米勒和洗鲁雅的儿子约押的兄弟亚比筛，说：“谁愿与我一起下到扫罗的营里去呢？”亚比筛回答：“我愿与你一起下去。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S126_7","010_26_7","1SA","26","7","7","于是大卫和亚比筛趁着夜里到了众军那里。扫罗正躺在军营的中央睡着了，他的矛插在头旁的地上；押尼珥和众军都躺在他的周围。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S126_8","010_26_8","1SA","26","8","8","亚比筛对大卫说：“今天　神把你的仇敌交在你手里了。现在求你容我用矛把他刺透在地上，一刺就够，不必再刺。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S126_9","010_26_9","1SA","26","9","9","大卫却对亚比筛说：“不可杀死他，因为有谁伸手伤害耶和华的受膏者而无罪呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S126_10","010_26_10","1SA","26","10","10","大卫说：“我指着永活的耶和华起誓，他或被耶和华击打，或死期到了，或下到战场阵亡了， ");
INSERT INTO cmn_ncvs_vpl VALUES ("S126_11","010_26_11","1SA","26","11","11","我在耶和华面前，绝对不敢伸手伤害耶和华的受膏者。现在，你可以把扫罗头旁的矛和水袋拿来，我们就走吧！” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S126_12","010_26_12","1SA","26","12","12","于是大卫从扫罗的头旁拿了矛和水袋，他们二人就走了。没有人看见，没有人知道，也没有人醒来。他们都睡着了，因为耶和华使他们沉睡。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S126_13","010_26_13","1SA","26","13","13","然后大卫过到另一边去，远远地站在山顶上，两者之间的距离很远。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S126_14","010_26_14","1SA","26","14","14","大卫呼叫众人和尼珥的儿子押尼珥说：“押尼珥啊，你不答话吗？”押尼珥回答说：“你是谁，竟敢呼叫王？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S126_15","010_26_15","1SA","26","15","15","大卫对押尼珥说：“你不是一个男子汉吗？以色列人中有谁能与你相比呢？众民中有一个人来要杀害王你的主，你为什么没有保护王你的主呢？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("S126_16","010_26_16","1SA","26","16","16","你所作的这事不好。我指着永活的耶和华起誓，你们都是该死的，因为你们没有保护你的主，就是耶和华的受膏者。现在你看看王头旁的矛和水袋在哪里？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S126_17","010_26_17","1SA","26","17","17","扫罗认出是大卫的声音，就说：“我儿大卫啊！这是你的声音吗？”大卫说：“我主我王啊！是我的声音。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S126_18","010_26_18","1SA","26","18","18","又说：“我主为什么这样追赶仆人呢？我作了什么？我手里犯了什么过错？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("S126_19","010_26_19","1SA","26","19","19","现在求我主我王听你仆人的话。如果是耶和华激动你攻击我，愿耶和华收纳祭物；如果是人激动你，愿他们在耶和华面前受咒诅，因为他们今天把我赶出来，不容我在耶和华的产业上有分，说：‘你去服事别的神吧！’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("S126_20","010_26_20","1SA","26","20","20","现在，求王不要让我的血流在远离耶和华的地上，因为以色列王出来寻索我的性命，就像人在山中猎取一只鹧鸪一样。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S126_21","010_26_21","1SA","26","21","21","扫罗说：“我有罪了，我儿大卫啊，你回来吧！因为今天你看我的命为宝贵，我必不再害你。看哪！我作了糊涂事了，并且错得很厉害。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S126_22","010_26_22","1SA","26","22","22","大卫回答说：“看哪！王的矛在这里，可以叫一个仆人过来拿去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S126_23","010_26_23","1SA","26","23","23","耶和华必按着各人的公义和信实报答他；今天耶和华把你交在我手里，我却不愿伸手伤害耶和华的受膏者。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S126_24","010_26_24","1SA","26","24","24","看哪，我今天怎样看重你的命，愿耶和华也怎样看重我的命，并且救我脱离一切患难。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S126_25","010_26_25","1SA","26","25","25","扫罗对大卫说：“我儿大卫啊，愿你得福，你必作成你所要作的，也必得胜。”于是大卫离去了，扫罗也回自己的地方去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S127_1","010_27_1","1SA","27","1","1","大卫心里说：“总有一天，我会死在扫罗的手里，我倒不如逃奔到非利士人的国土，扫罗对我就会死心，不再在以色列全境寻索我，我就可以逃脱他的手了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S127_2","010_27_2","1SA","27","2","2","于是大卫起来，和跟随他的六百人都越过边界，到迦特王玛俄的儿子亚吉那里去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S127_3","010_27_3","1SA","27","3","3","大卫和跟随他的人，以及他们各人的家眷，都与亚吉一同住在迦特。大卫的两个妻子，就是耶斯列人亚希暖和作过拿八妻子的迦密人亚比该也都住在那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S127_4","010_27_4","1SA","27","4","4","有人告诉扫罗，大卫已经逃到迦特去了，扫罗就不再寻索他了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S127_5","010_27_5","1SA","27","5","5","大卫对亚吉说：“我若是在你眼前蒙恩，求你在这地的城市中，给我一个地方，让我住在那里。为什么要你的仆人与你一同住在王城呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S127_6","010_27_6","1SA","27","6","6","那天，亚吉就把洗革拉赐给大卫，因此，洗革拉直到今日还是属犹大王的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S127_7","010_27_7","1SA","27","7","7","大卫在非利士人的乡镇居住的日子，共有一年零四个月。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S127_8","010_27_8","1SA","27","8","8","大卫和跟随他的人上去袭击基述人、基色人和亚玛力人，这些人自古以来就是这地的居民，居于书珥到埃及地之间。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S127_9","010_27_9","1SA","27","9","9","大卫攻打那地，无论男女，都不让一人存活，又掳走了牛、羊、驴子、骆驼和衣服，然后回来，到亚吉那里去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S127_10","010_27_10","1SA","27","10","10","亚吉问：“你们今天袭击了什么地方呢？”大卫回答：“我们袭击了犹大的南方，耶拉蔑的南部，和基尼的南方。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S127_11","010_27_11","1SA","27","11","11","无论男女，大卫都不让一人活着带到迦特来，他说：“恐怕他们把我们的事告诉别人，说：‘大卫作了这样的事，他住在非利士人乡镇的日子，常常这样作。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S127_12","010_27_12","1SA","27","12","12","亚吉相信了大卫，心里说：“他在自己的族人以色列中留下了臭名，他必永远作我的仆人了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S128_1","010_28_1","1SA","28","1","1","那时，非利士人聚集他们的军队，要与以色列人争战。亚吉对大卫说：“你要清楚知道，你和跟随你的人都要在军队中与我一同出征。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S128_2","010_28_2","1SA","28","2","2","大卫回答亚吉说：“仆人所能作的事你都知道。”于是亚吉对大卫说：“好吧，我要立你永远作我的护卫长。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S128_3","010_28_3","1SA","28","3","3","那时，撒母耳死了，以色列众人都为他哀哭，把他埋葬在拉玛他自己的城里。扫罗曾经把交鬼的和行巫术的，都从国中除去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S128_4","010_28_4","1SA","28","4","4","非利士人聚集起来，来到书念安营；扫罗也聚集以色列众人，在基利波安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S128_5","010_28_5","1SA","28","5","5","扫罗看见了非利士人的军队，就惧怕，他的心大大发抖。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S128_6","010_28_6","1SA","28","6","6","扫罗求问耶和华，耶和华却没有借着梦，或乌陵，或先知回答他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S128_7","010_28_7","1SA","28","7","7","于是扫罗对他的臣仆说：“你们要为我寻找一个能交鬼的女人，我好去求问她。”他的臣仆回答他说：“在隐．多珥有一个能交鬼的女人。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S128_8","010_28_8","1SA","28","8","8","于是扫罗改装易服，带着两个人与他一同去了。他们夜里到了那女人那里。扫罗说：“请你用交鬼的法术，把我所告诉你的那人为我招上来。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S128_9","010_28_9","1SA","28","9","9","那女人回答他：“你是知道扫罗所作的，他已经把交鬼的和行巫术的，都从国中剪除了，你为什么要陷害我的命，使我死呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S128_10","010_28_10","1SA","28","10","10","扫罗指着耶和华起誓说：“我指着永活的耶和华起誓，你必不因这事受惩罚。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S128_11","010_28_11","1SA","28","11","11","那女人问：“我要为你招谁上来呢？”扫罗回答：“为我招撒母耳上来。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S128_12","010_28_12","1SA","28","12","12","那女人看见了撒母耳，就大声呼叫。那女人对扫罗说：“你为什么欺骗我？你就是扫罗！” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S128_13","010_28_13","1SA","28","13","13","王对她说：“不要惧怕。你看见了什么？”那女人回答扫罗：“我看见有神灵从地里上来。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S128_14","010_28_14","1SA","28","14","14","扫罗问她：“他的容貌怎样？”她回答：“上来的是一个身披外袍的老人。”扫罗知道那人是撒母耳，就脸伏于地向他叩拜。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S128_15","010_28_15","1SA","28","15","15","撒母耳对扫罗说：“你为什么搅扰我，把我招上来呢？”扫罗说：“我非常苦恼，非利士人正在攻打我，　神又离开了我，不再借着先知或异梦回答我。所以我请你上来，指示我应该怎样行。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S128_16","010_28_16","1SA","28","16","16","撒母耳说：“耶和华既然离开了你，又成了你的敌人，你为什么还问我呢？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("S128_17","010_28_17","1SA","28","17","17","耶和华已经照着他借我所说的话行了，他把王国从你手中夺去，赐给别人，就是大卫。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S128_18","010_28_18","1SA","28","18","18","因为你没有听从耶和华的话，没有执行他对亚玛力人所怀的烈怒，所以今天耶和华向你行了这样的事， ");
INSERT INTO cmn_ncvs_vpl VALUES ("S128_19","010_28_19","1SA","28","19","19","并且耶和华必把以色列和你一起都交在非利士人手里；明天你和你的儿子们都要和我一起了。耶和华必把以色列的军队交在非利士人手里。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S128_20","010_28_20","1SA","28","20","20","扫罗立刻全身仆倒在地上，他因撒母耳的话，非常惧怕，又因为他已经一日一夜没有吃饭，所以一点气力也没有。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S128_21","010_28_21","1SA","28","21","21","那女人来到扫罗面前，见他非常惊慌，就对他说：“你看，婢女听从了你的话；我冒着生命危险，听从了你对我所说的话。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S128_22","010_28_22","1SA","28","22","22","现在求你也听从婢女的话，允许我在你面前摆上一点食物。你吃了，身体就有气力，可以走路。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S128_23","010_28_23","1SA","28","23","23","扫罗不肯，说：“我不吃。”可是他的臣仆和那女人再三劝他，他才听从了他们的话，从地上起来，坐在床上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S128_24","010_28_24","1SA","28","24","24","那女人的家里有一头肥牛犊，她急忙把它宰了，又拿点面粉，搓好了，烤成无酵饼， ");
INSERT INTO cmn_ncvs_vpl VALUES ("S128_25","010_28_25","1SA","28","25","25","送到扫罗和他臣仆的面前；他们吃了以后，当夜就起身离去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S129_1","010_29_1","1SA","29","1","1","非利士人把他们所有的军队都聚集在亚弗，以色列人却在耶斯列的泉旁安营。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S129_2","010_29_2","1SA","29","2","2","非利士人的首领各率领百人或千人前进；大卫和跟随他的人也跟在亚吉的后面前进。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S129_3","010_29_3","1SA","29","3","3","非利士人的领袖说：“这些希伯来人在这里作什么？”亚吉对非利士人的领袖说：“这人不是以色列王扫罗的臣仆大卫吗？他已经在我这里有好些年日了。自从他降服我的一天，直到今日，我未曾发现他有什么过错。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S129_4","010_29_4","1SA","29","4","4","非利士人的领袖向亚吉发怒，对他说：“你叫这人回去，好让他回到你为他安排的地方去。他不可与我们一同下战场，免得他在战场上成为我们的对头。这人可用什么去得他主人的欢心呢？岂不是用我们这些人的头吗？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("S129_5","010_29_5","1SA","29","5","5","这人不就是大卫吗？从前以色列的妇女向他歌唱跳舞说：‘扫罗杀死千千，大卫杀死万万！’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S129_6","010_29_6","1SA","29","6","6","亚吉把大卫叫来，对他说：“我指着永活的耶和华说，你是正直的人，你与我在军中出入，我感到很满意，因为自从你到我这里来的那一天，直到今日，我未曾在你身上找到什么过失；只是各首领不喜欢你。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S129_7","010_29_7","1SA","29","7","7","现在，你可以回去，平平安安走吧！不要行非利士人的首领看为恶的事。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S129_8","010_29_8","1SA","29","8","8","大卫对亚吉说：“我作了什么呢？自从我来到你面前的那一天，直到今日，你在仆人身上找到什么，使我不能与我主我王的仇敌争战呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S129_9","010_29_9","1SA","29","9","9","亚吉回答大卫，说：“我知道你在我眼中是个好人，像　神的使者一样；只是非利士人的领袖曾经说过：‘他不可与我们一同上战场。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("S129_10","010_29_10","1SA","29","10","10","所以明天早晨，你和跟你来的人，就是你主人的仆人都要清早起来。你们明天早晨都要早起，天一亮你们就要离开。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S129_11","010_29_11","1SA","29","11","11","于是大卫和跟随他的人清早起来，一早就离开，回到非利士人的地去。非利士人也上耶斯列去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S130_1","010_30_1","1SA","30","1","1","第三天，大卫和跟随他的人到了洗革拉。那时亚玛力人袭击了南地和洗革拉。他们攻破了洗革拉，又放火焚烧。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S130_2","010_30_2","1SA","30","2","2","他们把妇女和城里所有的人，无论大小都掳走了。他们没有杀人，都带着他们从原路回去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S130_3","010_30_3","1SA","30","3","3","大卫和跟随他的人到了那城，看见城已经被火烧毁，他们的妻子、儿女都被掳走了， ");
INSERT INTO cmn_ncvs_vpl VALUES ("S130_4","010_30_4","1SA","30","4","4","就放声大哭，直哭到没有力气再哭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S130_5","010_30_5","1SA","30","5","5","大卫的两个妻子，耶斯列人亚希暖和作过拿八妻子的迦密人亚比该，也都被掳去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S130_6","010_30_6","1SA","30","6","6","大卫处境非常困难，因为众人都为自己的儿女心中苦恼，说要用石头打死大卫；但大卫靠着耶和华他的　神坚强起来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S130_7","010_30_7","1SA","30","7","7","大卫对亚希米勒的儿子、亚比亚他祭司说：“请你把以弗得带到我这里来。”亚比亚他就把以弗得带到大卫那里去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S130_8","010_30_8","1SA","30","8","8","大卫求问耶和华说：“我可以追赶这群匪徒吗？我可以追上他们吗？”耶和华回答他：“你可以追赶，你必定追上，也必定把一切救回来。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S130_9","010_30_9","1SA","30","9","9","于是大卫和跟随他的六百人出发。他们到了比梭溪，有些跟不上的就留在那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S130_10","010_30_10","1SA","30","10","10","有二百人太疲乏，不能渡过比梭溪，就留在那里，大卫和四百人继续追赶。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S130_11","010_30_11","1SA","30","11","11","他们在田野里遇见一个埃及人，就把他带到大卫那里。他们给他饭吃，又给他水喝。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S130_12","010_30_12","1SA","30","12","12","又给他一块无花果饼，两个葡萄饼。他吃了，精神就恢复过来，因为他已经三天三夜没有吃东西，没有喝水了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S130_13","010_30_13","1SA","30","13","13","大卫问他：“你是属谁的？你从哪里来？”他回答：“我是个埃及的青年人，是亚玛力人的奴仆。因为我三天前病了，我的主人就把我丢弃了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S130_14","010_30_14","1SA","30","14","14","我们侵袭了基利提的南方和属犹大地的南方，以及迦勒地的南方，又用火烧了洗革拉。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S130_15","010_30_15","1SA","30","15","15","大卫对他说：“你愿意带我下到那一群匪徒那里吗？”他回答：“如果你指着　神向我起誓，不杀死我，也不把我交在我主人手里，我就带你下到那一群匪徒那里去。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S130_16","010_30_16","1SA","30","16","16","他带大卫下去。匪徒们都分散在各处，正在吃喝、跳舞，因为他们从非利士地和犹大地抢来的战利品很多。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S130_17","010_30_17","1SA","30","17","17","大卫击杀他们，从黄昏直到次日的晚上。除了四百个骑骆驼的年轻人逃跑了以外，他们当中一个人也没有逃脱。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S130_18","010_30_18","1SA","30","18","18","亚玛力人抢去的一切，大卫都救回来了，也救回了他的两个妻子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S130_19","010_30_19","1SA","30","19","19","无论大小，不分男女，无论是他们抢来的，或是被人掳去的，大卫都夺回来，没有失落一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S130_20","010_30_20","1SA","30","20","20","大卫夺了所有的羊群和牛群，跟从大卫的人把它们赶到原有的群畜面前，说：“这是大卫的战利品。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S130_21","010_30_21","1SA","30","21","21","大卫来到那二百人那里，那些人因太疲乏不能跟随大卫去，而留在比梭溪旁；他们出来迎接大卫和跟随他的众人。大卫接近众人的时候，就向他们问安。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S130_22","010_30_22","1SA","30","22","22","与大卫一起去的那些人中，有些恶人和流氓说：“他们没有和我们一起去，我们就不把夺回来的战利品分给他们，只把他们各人的妻子和儿子还给他们，让他们领回去就是了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S130_23","010_30_23","1SA","30","23","23","大卫说：“兄弟们，耶和华赐给我们的，你们不可以这样作。他保护了我们，又把那些攻击我们的匪徒交在我们手里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S130_24","010_30_24","1SA","30","24","24","这事谁要听从你们呢？下战场的得多少，留守武器的也得多少，应当大家平分。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S130_25","010_30_25","1SA","30","25","25","从那天起，大卫定此为以色列的律例典章，直到今日。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S130_26","010_30_26","1SA","30","26","26","大卫到了洗革拉，就从战利品中取一部分送给他的朋友、犹大的长老，说：“看哪，这是从耶和华的仇敌那里得来的战利品，送给你们作礼物。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S130_27","010_30_27","1SA","30","27","27","他送礼物给在伯特利的、在南地拉末的、在雅提珥的、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S130_28","010_30_28","1SA","30","28","28","在亚罗珥的、在息末的、在以实提莫的、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S130_29","010_30_29","1SA","30","29","29","在拉哈勒的、在耶拉蔑各城的、在基尼各城的、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S130_30","010_30_30","1SA","30","30","30","在何珥玛的、在歌拉珊的、在亚挞的、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S130_31","010_30_31","1SA","30","31","31","在希伯仑的人，又送给一切大卫及其跟随者所到过之地的人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S131_1","010_31_1","1SA","31","1","1","非利士人与以色列人交战。以色列人从非利士人面前逃跑，有很多人在基利波山上倒毙。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S131_2","010_31_2","1SA","31","2","2","非利士人紧紧追赶扫罗和他的众子，击杀了扫罗的儿子约拿单、亚比拿达和麦基舒亚。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S131_3","010_31_3","1SA","31","3","3","战争激烈，扫罗受到猛烈的攻击，弓箭手发现了他，射箭的人射中了他，他的伤势严重； ");
INSERT INTO cmn_ncvs_vpl VALUES ("S131_4","010_31_4","1SA","31","4","4","扫罗就对替他拿兵器的人说：“拔出你的刀来，把我刺透，免得这些未受割礼的人来把我刺透，戏弄我。”但替他拿兵器的人不肯这样作，因为他非常害怕。于是扫罗拿过刀来，自己伏在刀上死了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S131_5","010_31_5","1SA","31","5","5","替他拿兵器的人看见扫罗死了，他也伏在自己的刀上，与扫罗一起死了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S131_6","010_31_6","1SA","31","6","6","这样，扫罗和他的三个儿子，以及替他拿兵器的人，还有所有跟随他的人，都在那一天一同死了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S131_7","010_31_7","1SA","31","7","7","在山谷那边，和约旦河那边的以色列人，看见以色列人逃跑，扫罗和他的儿子都死了，他们就弃城逃跑。非利士人就来住在城中。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S131_8","010_31_8","1SA","31","8","8","第二天，非利士人来剥那些被杀的人的衣物的时候，发现扫罗和他的三个儿子都倒毙在基利波山上， ");
INSERT INTO cmn_ncvs_vpl VALUES ("S131_9","010_31_9","1SA","31","9","9","就砍下他的头，解下他的兵器，又派人到非利士地的各处，去向他们的偶像的庙和人民报信。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S131_10","010_31_10","1SA","31","10","10","他们把扫罗的兵器放在亚斯他录的庙里，又把他的尸体钉在伯．珊的城墙上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S131_11","010_31_11","1SA","31","11","11","基列．雅比的居民听见非利士人向扫罗所行的事， ");
INSERT INTO cmn_ncvs_vpl VALUES ("S131_12","010_31_12","1SA","31","12","12","所有的勇士就动身，走了一整夜，把扫罗的尸体和他三个儿子的尸体都从伯．珊的城墙上取下来，带回雅比，在那里把他们烧了， ");
INSERT INTO cmn_ncvs_vpl VALUES ("S131_13","010_31_13","1SA","31","13","13","又把他们的骸骨埋葬在雅比的垂柳树下，并且禁食七天。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S21_1","011_1_1","2SA","1","1","1","扫罗死后，大卫杀退了亚玛力人回来，就在洗革拉住了两天。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S21_2","011_1_2","2SA","1","2","2","第三天，忽然有一个人从扫罗的营回来，衣服撕裂，头上蒙灰。这人一来到大卫面前，就俯伏在地上叩拜他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S21_3","011_1_3","2SA","1","3","3","大卫问他：“你从哪里来？”他对他说：“我是从以色列的营中逃出来的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S21_4","011_1_4","2SA","1","4","4","大卫又问他：“情况怎么样？请你告诉我！”他回答：“众人都逃离战场，他们中间不但有许多人倒地阵亡，连扫罗和他的儿子约拿单也死了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S21_5","011_1_5","2SA","1","5","5","于是，大卫问那向他报信的年轻人：“你怎么知道扫罗和他的儿子死了呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S21_6","011_1_6","2SA","1","6","6","那个向大卫报信的年轻人回答：“我刚巧在基利波山，看见扫罗靠在自己的矛枪上，又见有战车和马兵紧紧地追赶他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S21_7","011_1_7","2SA","1","7","7","他回头看到我，就呼唤我。我说：‘我在这里。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("S21_8","011_1_8","2SA","1","8","8","他问我：‘你是谁？’我回答他：‘我是亚玛力人。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("S21_9","011_1_9","2SA","1","9","9","于是他对我说：‘请你站到我身边来，把我杀死，因为痛苦抓住我，我却还死不了。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("S21_10","011_1_10","2SA","1","10","10","我就站到他身边去，把他杀了，因为我知道他一倒下，就不能再活了。我摘下他头上的王冠，取下他臂上的手镯，带到这里来奉给我主。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S21_11","011_1_11","2SA","1","11","11","大卫就抓住自己的衣服，把它们全都撕裂。所有与他在一起的人也都是这样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S21_12","011_1_12","2SA","1","12","12","他们为了扫罗、他的儿子约拿单、耶和华的子民和以色列家的缘故悲哀、哭泣、禁食直到晚上，因为他们已经倒毙在刀下。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S21_13","011_1_13","2SA","1","13","13","大卫问那向他报信的年轻人：“你是哪里的人？”他回答：“我是个寄居这地的亚玛力人的儿子。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S21_14","011_1_14","2SA","1","14","14","大卫对他说：“你伸手毁灭耶和华的受膏者，怎么还不惧怕呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S21_15","011_1_15","2SA","1","15","15","于是大卫叫了一个年轻人来，说：“你上前去，砍倒他。”那年轻人击杀他，他就死了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S21_16","011_1_16","2SA","1","16","16","大卫对他说：“你流人血的罪要归到自己的头上，因为你亲口作证指控自己说：‘我杀了耶和华的受膏者。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S21_17","011_1_17","2SA","1","17","17","大卫为扫罗和他的儿子约拿单作了这首哀歌。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S21_18","011_1_18","2SA","1","18","18","他又吩咐要把这首“弓歌”教导犹大人。（这首歌记录在《雅煞珥书》上。） ");
INSERT INTO cmn_ncvs_vpl VALUES ("S21_19","011_1_19","2SA","1","19","19","“以色列啊！尊荣的人都在高处被杀，勇士怎么都已仆倒！ ");
INSERT INTO cmn_ncvs_vpl VALUES ("S21_20","011_1_20","2SA","1","20","20","你们不要在迦特报道，不要在亚实基伦的街上宣扬，免得非利士的女子欢喜，免得未受割礼之人的女子快乐。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S21_21","011_1_21","2SA","1","21","21","基利波的群山啊！愿雨露都不降在你们上面，愿你们的田地不产供物。因为勇士的盾牌在那里玷污，扫罗的盾牌没有用油抹亮。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S21_22","011_1_22","2SA","1","22","22","不见被杀者的血、勇士的脂油，约拿单的弓不缩回，扫罗的剑也不空空返回。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S21_23","011_1_23","2SA","1","23","23","扫罗和约拿单，生时相亲相爱，死时也不分离。他们比鹰还快速，比狮子更勇猛。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S21_24","011_1_24","2SA","1","24","24","以色列的女子啊！你们要为扫罗哭泣，他曾给你们穿上紫色豪华的衣服，又给你们的外衣加上金饰。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S21_25","011_1_25","2SA","1","25","25","勇士怎么会在战阵上倒毙，约拿单在高处被刺死！ ");
INSERT INTO cmn_ncvs_vpl VALUES ("S21_26","011_1_26","2SA","1","26","26","我的兄弟约拿单啊！我为你悲痛，你是我最好的朋友，你对我的爱情远超过妇女的爱情。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S21_27","011_1_27","2SA","1","27","27","勇士怎么会倒毙！争战的武器怎么会毁灭！” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S22_1","011_2_1","2SA","2","1","1","这事以后，大卫求问耶和华说：“我可以上犹大的一座城去吗？”耶和华回答：“你上去吧。”大卫又问：“我应该上到哪里去呢？”他回答：“上希伯仑去！” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S22_2","011_2_2","2SA","2","2","2","于是大卫带着他的两个妻子，一个是耶斯列人亚希暖，一个是作过迦密人拿八妻子的亚比该，上到那里去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S22_3","011_2_3","2SA","2","3","3","大卫也把与他在一起的人，和他们各人的家眷都带上去。他们就在希伯仑的城镇里住下来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S22_4","011_2_4","2SA","2","4","4","于是犹大人来到希伯仑，在那里膏立了大卫作王，统治犹大家。有人报告大卫说：“埋葬扫罗的是基列．雅比人。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S22_5","011_2_5","2SA","2","5","5","大卫就差派使者到基列．雅比人那里去，对他们说：“愿耶和华赐福给你们，因为你们厚待了你们的主扫罗，把他埋葬了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S22_6","011_2_6","2SA","2","6","6","你们既作了这事，现在就愿耶和华以慈爱和诚实待你们，我也要善待你们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S22_7","011_2_7","2SA","2","7","7","现在你们要坚强，要作勇敢的人，因为你们的主扫罗已经死了；犹大家已经膏立了我作他们的王了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S22_8","011_2_8","2SA","2","8","8","当时，扫罗的元帅尼珥的儿子押尼珥已经领着扫罗的儿子伊施波设，把他带过河到玛哈念去， ");
INSERT INTO cmn_ncvs_vpl VALUES ("S22_9","011_2_9","2SA","2","9","9","并且立了他作王，统治基列、亚书利、耶斯列、以法莲、便雅悯和以色列众人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S22_10","011_2_10","2SA","2","10","10","扫罗的儿子伊施波设作以色列王的时候，已经四十岁；他作王共两年。犹大家却追随大卫。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S22_11","011_2_11","2SA","2","11","11","大卫在希伯仑作王统治犹大家的时候共有七年零六个月。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S22_12","011_2_12","2SA","2","12","12","尼珥的儿子押尼珥带着扫罗的儿子伊施波设的仆从，离开玛哈念，到基遍去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S22_13","011_2_13","2SA","2","13","13","洗鲁雅的儿子约押和大卫的臣仆也出来，在基遍的水池旁边与他们会面。大家都坐下，一队在水池这边，一队在水池那边。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S22_14","011_2_14","2SA","2","14","14","押尼珥对约押说：“让年轻人起来，在我们面前比比武。”约押说：“好！叫他们起来。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S22_15","011_2_15","2SA","2","15","15","他们就起来，按着人数走过去：属便雅悯，就是属扫罗的儿子伊施波设的，有十二人；属大卫臣仆的也有十二人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S22_16","011_2_16","2SA","2","16","16","他们各人都紧紧抓住对手的头，用刀刺进对手的肋旁，于是他们全都倒毙。所以在基遍那地方就叫作希利甲．哈素林。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S22_17","011_2_17","2SA","2","17","17","那天的战事非常激烈，结果押尼珥和以色列人败在大卫的臣仆面前。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S22_18","011_2_18","2SA","2","18","18","洗鲁雅的三个儿子约押、亚比筛和亚撒黑都在那里。亚撒黑的腿轻快如野地的羚羊一般。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S22_19","011_2_19","2SA","2","19","19","亚撒黑追赶押尼珥，紧紧地跟着他，不偏左，也不偏右。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S22_20","011_2_20","2SA","2","20","20","押尼珥往后瞧着，说：“你是亚撒黑吗？”他回答：“我正是。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S22_21","011_2_21","2SA","2","21","21","押尼珥对他说：“你或转左或转右，抓住一个年轻人，夺去他的武器吧！”可是亚撒黑不愿意离开不追赶他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S22_22","011_2_22","2SA","2","22","22","押尼珥再一次对亚撒黑说：“你离开，别追赶我！我为什么要把你砍倒在地上呢？以后怎么还有脸见你的哥哥约押呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S22_23","011_2_23","2SA","2","23","23","亚撒黑不肯离开，所以押尼珥就用枪的尾端刺入了他的肚子，枪从他的背后穿出。亚撒黑仆倒在那里，当场死了。所有来到亚撒黑倒毙的地方的人，都站住不动。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S22_24","011_2_24","2SA","2","24","24","约押和亚比筛却继续追赶押尼珥。日落的时候，他们来到亚玛山，就在通往基遍旷野的路旁，基亚的对面。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S22_25","011_2_25","2SA","2","25","25","便雅悯人集结在押尼珥后面，站在一座山头上，列成一个队伍。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S22_26","011_2_26","2SA","2","26","26","押尼珥对约押喊叫，说：“刀剑要不停地杀人吗？你不知道结局是痛苦的吗？你要等到什么时候才吩咐人民转去，不追赶自己的兄弟呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S22_27","011_2_27","2SA","2","27","27","约押说：“我指着永活的　神起誓，如果你们没有说过比武的话，大家必在早晨的时候离去，不再追赶自己的兄弟。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S22_28","011_2_28","2SA","2","28","28","于是约押吹响号角，众人就站住，不再追赶以色列人，也不再打仗了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S22_29","011_2_29","2SA","2","29","29","押尼珥和属他的人，整夜走过亚拉巴，渡过约旦河，又走过毕伦，才回到玛哈念。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S22_30","011_2_30","2SA","2","30","30","约押追赶押尼珥回来，集合所有人的时候，发现在大卫的臣仆中，除了亚撒黑以外，还少了十九个人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S22_31","011_2_31","2SA","2","31","31","但大卫的臣仆击杀便雅悯人和跟随押尼珥的人，共有三百六十人死了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S22_32","011_2_32","2SA","2","32","32","他们把亚撒黑抬回去，埋葬在伯利恒他父亲的坟墓里。约押和属他的人走了一整夜，天亮的时候才回到希伯仑。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S23_1","011_3_1","2SA","3","1","1","扫罗家和大卫家之间的战争相持很久。大卫家逐渐兴盛，扫罗家却日趋衰微。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S23_2","011_3_2","2SA","3","2","2","大卫在希伯仑生了几个儿子：他的长子暗嫩，是耶斯列人亚希暖所生的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S23_3","011_3_3","2SA","3","3","3","次子基利押，是作过迦密人拿八的妻子亚比该所生的。三子押沙龙，是基述王达买的女儿玛迦所生的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S23_4","011_3_4","2SA","3","4","4","四子亚多尼雅，是哈及所生的。五子示法提雅，是亚比他所生的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S23_5","011_3_5","2SA","3","5","5","六子以特念，是大卫妻子以格拉所生的。这些儿子都是大卫在希伯仑所生的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S23_6","011_3_6","2SA","3","6","6","当扫罗家和大卫家交战的时候，押尼珥在扫罗家的权势日渐强大。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S23_7","011_3_7","2SA","3","7","7","扫罗有一个妃子，名叫利斯巴，是爱亚的女儿。伊施波设对押尼珥说：“你为什么亲近我父亲的妃子呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S23_8","011_3_8","2SA","3","8","8","押尼珥因伊施波设的话非常忿怒，说：“我是犹大的狗头吗？今天我厚待你的父亲扫罗家、他的兄弟和他的朋友，没有把你交在大卫的手中；可是，今天你竟为了这女人的事来找我的错！ ");
INSERT INTO cmn_ncvs_vpl VALUES ("S23_9","011_3_9","2SA","3","9","10","我若不按着耶和华向大卫所起誓应许的去行：废去扫罗家的王国，建立大卫的王位，使他统治以色列和犹大，从但直到别是巴，愿　神降罚押尼珥，重重地降罚他。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S23_11","011_3_11","2SA","3","11","11","伊施波设因为惧怕押尼珥，就连一句话也不敢回答他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S23_12","011_3_12","2SA","3","12","12","押尼珥差派使者代表他去见大卫，说：“这地是属谁的呢？”又说：“你与我立约，我就必帮助你，使全以色列都归顺你。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S23_13","011_3_13","2SA","3","13","13","大卫说：“好！我与你立约。不过，我要求你一件事：你来见我面的时候，首先要把扫罗的女儿米甲带来，否则你必不得见我的面。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S23_14","011_3_14","2SA","3","14","14","后来，大卫差派使者去见扫罗的儿子伊施波设，说：“请你把我的妻子米甲还给我，她是我从前用一百个非利士人的包皮聘下的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S23_15","011_3_15","2SA","3","15","15","于是伊施波设派人去，把米甲从拉亿的儿子她丈夫帕铁那里接回来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S23_16","011_3_16","2SA","3","16","16","米甲的丈夫与她一起去，跟在她后面，一边走、一边哭，一直跟到巴户琳。押尼珥对他说：“你去吧！回去吧！”他只好回去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S23_17","011_3_17","2SA","3","17","17","押尼珥与以色列的长老商议说：“从前你们希望大卫作你们的王。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S23_18","011_3_18","2SA","3","18","18","现在可以实现了！因为耶和华曾经论到大卫说：‘我要借着我的仆人大卫的手，把我的子民以色列从非利士人和他们所有敌人的手中拯救出来。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S23_19","011_3_19","2SA","3","19","19","押尼珥也把这话说给便雅悯人听，然后又去希伯仑，把以色列人和便雅悯全都同意的一切事说给大卫听。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S23_20","011_3_20","2SA","3","20","20","押尼珥带着二十个人，来到希伯仑见大卫的时候，大卫就为押尼珥和与他同来的人摆设筵席。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S23_21","011_3_21","2SA","3","21","21","后来，押尼珥对大卫说：“让我去把以色列众人召集到我主我王这里来，好叫他们与你立约，这样你就可以照着自己的心愿统治所有的人。”于是大卫打发押尼珥回去，他就平平安安地走了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S23_22","011_3_22","2SA","3","22","22","那时，大卫的臣仆和约押攻击敌人回来，带回许多的战利品。当时，押尼珥不在希伯仑大卫那里，因为大卫已经打发他离去，他也平平安安地走了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S23_23","011_3_23","2SA","3","23","23","约押和跟随他的全军一到达，就有人告诉约押，尼珥的儿子押尼珥曾经来见过王。王打发他离去，他已经平平安安地走了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S23_24","011_3_24","2SA","3","24","24","约押进去见王，说：“你作了什么事？尼珥的儿子押尼珥来见你，你为什么把他送走？现在他已经平平安安地走了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S23_25","011_3_25","2SA","3","25","25","你认识尼珥的儿子押尼珥，他来是要欺骗你，是要了解你的起居行动和你所作的一切事。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S23_26","011_3_26","2SA","3","26","26","约押从大卫那里出来，就差派使者去追赶押尼珥，使者从西拉的水井那里把他带回来。可是，大卫一点都不知道。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S23_27","011_3_27","2SA","3","27","27","押尼珥回到了希伯仑，约押就拉他到城门旁边与他密谈。约押就在那里刺透他的肚子，他就死了。这样，他替自己的兄弟亚撒黑报了血仇。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S23_28","011_3_28","2SA","3","28","28","事后大卫听到了，就说：“关于尼珥的儿子押尼珥的血案，我和我的国家，在耶和华面前永远是无辜的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S23_29","011_3_29","2SA","3","29","29","愿这流人血的罪归到约押的头上和他父亲的全家！又愿约押家不断有患血漏病的、长痲风的、拿拐杖的、倒毙在剑下的和缺乏粮食的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S23_30","011_3_30","2SA","3","30","30","因押尼珥在基遍的战场上，杀死了他们的兄弟亚撒黑，约押和他的兄弟亚比筛就杀了押尼珥。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S23_31","011_3_31","2SA","3","31","31","大卫对约押和与他在一起的众人说：“你们要撕裂衣服，腰束麻布，在押尼珥面前哀哭！”大卫王也走在棺木后面。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S23_32","011_3_32","2SA","3","32","32","他们把押尼珥埋葬在希伯仑。王在押尼珥的墓旁放声大哭，众人也都哭了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S23_33","011_3_33","2SA","3","33","33","王又为押尼珥作了哀歌，说：“难道押尼珥死去，要像愚妄的人死去一样吗？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("S23_34","011_3_34","2SA","3","34","34","你的手没有被绳索绑住，你的脚也没有被铜链锁住，你倒毙，好像人在暴徒面前倒毙一样！”于是，众民又为押尼珥哀哭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S23_35","011_3_35","2SA","3","35","35","还在白天的时候，众人都来劝大卫吃点饭；大卫起誓说：“我若在日落以前吃饭或吃什么东西，愿　神降罚我，重重地降罚我。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S23_36","011_3_36","2SA","3","36","36","众人看见了，就都喜悦。王所作的一切，他们都很喜悦。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S23_37","011_3_37","2SA","3","37","37","那一天众人和全以色列都知道，杀死尼珥的儿子押尼珥，并不是出于王的意思。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S23_38","011_3_38","2SA","3","38","38","王对他的臣仆说：“你们不知道今天在以色列中，有一位将领和伟人倒毙了吗？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("S23_39","011_3_39","2SA","3","39","39","今天我虽然受膏为王，但我还是幼弱的。洗鲁雅的两个儿子太强了，非我所能应付。愿耶和华照着恶人所行的恶，报应恶人。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S24_1","011_4_1","2SA","4","1","1","扫罗的儿子伊施波设听见押尼珥在希伯仑死了，就怕得手都发软，以色列众人也都惊惶失措。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S24_2","011_4_2","2SA","4","2","2","扫罗的儿子伊施波设有两个统率突击队的将领，一个名叫巴拿，一个名叫利甲，他们是便雅悯支派比录人临门的儿子。（比录也算是便雅悯的一部分。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S24_3","011_4_3","2SA","4","3","3","比录人原先逃到基他音，就在那里寄居，直到今日。） ");
INSERT INTO cmn_ncvs_vpl VALUES ("S24_4","011_4_4","2SA","4","4","4","扫罗的儿子约拿单有一个儿子，双腿都跛了。扫罗和约拿单死亡的消息从耶斯列传到的时候，他才五岁。他的乳母抱着他逃跑。乳母在慌忙中逃跑，孩子掉了下来，腿就瘸了。他的名字叫米非波设。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S24_5","011_4_5","2SA","4","5","5","比录人临门的儿子利甲和巴拿出去，约在正午炎热的时候，来到了伊施波设的家。伊施波设正在睡午觉。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S24_6","011_4_6","2SA","4","6","6","他们进了屋里，假装要拿麦子，就刺透伊施波设的肚腹，然后利甲和他的兄弟巴拿都逃脱了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S24_7","011_4_7","2SA","4","7","7","他们进屋子的时候，伊施波设正在自己的卧室里躺在床上，他们刺透他，把他杀死，然后割下他的头，拿着头颅在亚拉巴的路上走了一夜， ");
INSERT INTO cmn_ncvs_vpl VALUES ("S24_8","011_4_8","2SA","4","8","8","把伊施波设的头带到希伯仑去见大卫，对王说：“你的仇敌扫罗过去常常寻索你的命。看哪！这是他儿子伊施波设的头。今天耶和华在扫罗和他后裔的身上为我主我王报了仇了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S24_9","011_4_9","2SA","4","9","9","大卫回答比录人临门的儿子利甲和他的兄弟巴拿，说：“我指着那曾救赎我的命脱离一切患难的永活的耶和华起誓： ");
INSERT INTO cmn_ncvs_vpl VALUES ("S24_10","011_4_10","2SA","4","10","10","从前有人向我报信说：‘看哪！扫罗死了。’他自以为是报好消息，我却抓住他，把他杀在洗革拉，这就是我给他作报好消息的酬报。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S24_11","011_4_11","2SA","4","11","11","何况恶人在义人的家里，把义人杀在床上。现在我怎能不从你们手中追讨流他血的罪，把你们从这世上除灭呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S24_12","011_4_12","2SA","4","12","12","于是，大卫吩咐年轻人把他们杀了，并且砍断他们的手脚，把身体挂在希伯仑的水池旁边；却把伊施波设的头拿去，埋葬在希伯仑押尼珥的坟墓里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S25_1","011_5_1","2SA","5","1","1","以色列众支派都到希伯仑来见大卫，说：“看哪！我们都是你的骨肉至亲。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S25_2","011_5_2","2SA","5","2","2","从前扫罗作我们的王的时候，领导以色列人行动的是你。耶和华也曾对你说：‘你要牧养我的子民以色列，要作以色列的领袖。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S25_3","011_5_3","2SA","5","3","3","以色列的众长老都到希伯仑来见王。大卫王在希伯仑耶和华面前与他们立约，他们就膏立大卫作以色列的王。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S25_4","011_5_4","2SA","5","4","4","大卫登基的时候是三十岁，在位共四十年。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S25_5","011_5_5","2SA","5","5","5","他在希伯仑作犹大的王七年零六个月；在耶路撒冷作全以色列和犹大的王三十三年。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S25_6","011_5_6","2SA","5","6","6","大卫和随从他的人到了耶路撒冷，要攻打住在那地的耶布斯人。耶布斯人对大卫说：“你不能进这里来，这些瞎眼的、跛脚的就能把你抵挡住。”他们心里想：“大卫决不能进那里去。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S25_7","011_5_7","2SA","5","7","7","大卫却攻取了锡安的保障，就是大卫的城。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S25_8","011_5_8","2SA","5","8","8","那一天大卫说：“攻打耶布斯人的，要把大卫心中恨恶的‘瞎子’和‘瘸子’丢进水沟里。”因此有句俗语说：“瞎眼的或瘸腿的，都不能进殿里。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S25_9","011_5_9","2SA","5","9","9","后来大卫住在保障里，称保障为“大卫的城”。大卫又从米罗向里面周围筑墙。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S25_10","011_5_10","2SA","5","10","10","大卫渐渐强大，因为耶和华万军的　神与他同在。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S25_11","011_5_11","2SA","5","11","11","推罗王希兰差派使者来见大卫，又送来香柏木、木匠和石匠，他们就给大卫建造宫殿。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S25_12","011_5_12","2SA","5","12","12","大卫就知道耶和华已经立他作以色列的王，又因自己的子民以色列的缘故，使他的国兴盛。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S25_13","011_5_13","2SA","5","13","13","大卫离开希伯仑后，在耶路撒冷又娶了多位妃嫔，并且生了很多儿女。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S25_14","011_5_14","2SA","5","14","14","以下这些就是他在耶路撒冷所生的孩子的名字：沙母亚、朔罢、拿单、所罗门、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S25_15","011_5_15","2SA","5","15","15","益辖、以利书亚、尼斐、雅非亚、 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S25_16","011_5_16","2SA","5","16","16","以利沙玛、以利雅大、以利法列。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S25_17","011_5_17","2SA","5","17","17","非利士人听见有人膏立了大卫作王统治以色列人，就全体上来搜寻大卫。大卫听见了，就下到保障去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S25_18","011_5_18","2SA","5","18","18","非利士人来到，散布在利乏音谷。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S25_19","011_5_19","2SA","5","19","19","大卫求问耶和华说：“我可以上去攻打非利士人吗？你会把他们交在我手里吗？”耶和华对大卫说：“你可以上去，我必把非利士人交在你手里。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S25_20","011_5_20","2SA","5","20","20","于是大卫来到巴力．毗拉心，在那里击败了非利士人，说：“耶和华在我面前冲破我的敌人，好像洪水冲破堤岸一般。”因此他给那地方起名叫巴力．毗拉心。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S25_21","011_5_21","2SA","5","21","21","非利士人把他们的神像遗弃在那里，大卫和跟随他的人就把它们拿走了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S25_22","011_5_22","2SA","5","22","22","非利士人又上来，散布在利乏音谷。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S25_23","011_5_23","2SA","5","23","23","大卫又求问耶和华，耶和华说：“你不要直接上去，要绕到他们后面，从桑林对面攻打他们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S25_24","011_5_24","2SA","5","24","24","你一听到桑林树梢上有脚步的声音，就要赶快行动，因为那时耶和华已经在你前面出去击杀非利士人的军队了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S25_25","011_5_25","2SA","5","25","25","于是大卫照着耶和华所吩咐他的去作，击杀非利士人，从迦巴直到基色。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S26_1","011_6_1","2SA","6","1","1","大卫又聚集以色列中所有拣选出来的三万人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S26_2","011_6_2","2SA","6","2","2","大卫和与他在一起的众人起程前去，要从巴拉．犹大把　神的约柜运来，这约柜的名称是以坐在二基路伯之上万军之耶和华的名字而起的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S26_3","011_6_3","2SA","6","3","3","他们把　神的约柜从山冈上亚比拿达的家里抬出来，安放在一辆新车上；亚比拿达的两个儿子，乌撒和亚希约赶着这辆新车， ");
INSERT INTO cmn_ncvs_vpl VALUES ("S26_4","011_6_4","2SA","6","4","4","车上有　神的约柜。亚希约走在约柜的前面。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S26_5","011_6_5","2SA","6","5","5","大卫和以色列全家在耶和华面前用各种松木制造的乐器，就是用琴、瑟、鼓、钹、锣，作乐跳舞。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S26_6","011_6_6","2SA","6","6","6","他们到了拿艮的打禾场的时候，因为牛几乎绊倒，乌撒就伸手扶住　神的约柜。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S26_7","011_6_7","2SA","6","7","7","耶和华的怒气向乌撒发作；　神因这错误的举动，就当场击杀他，他就死在　神的约柜旁边。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S26_8","011_6_8","2SA","6","8","8","大卫因为耶和华击杀了乌撒，就很生气，因此称那地方为毗列斯．乌撒，直到今日。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S26_9","011_6_9","2SA","6","9","9","那一天，大卫惧怕耶和华，说：“耶和华的约柜怎可以到我这里来呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S26_10","011_6_10","2SA","6","10","10","于是大卫不肯把耶和华的约柜运进大卫的城到他那里去，却转运到迦特人俄别．以东的家里去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S26_11","011_6_11","2SA","6","11","11","耶和华的约柜在迦特人俄别．以东的家停留了三个月，耶和华赐福给俄别．以东和他的全家。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S26_12","011_6_12","2SA","6","12","12","有人告诉大卫王：“耶和华因为　神的约柜的缘故，赐福给俄别．以东的家和一切属他的。”大卫就去，欢欢喜喜把　神的约柜从俄别．以东的家中抬上大卫的城里去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S26_13","011_6_13","2SA","6","13","13","那些抬耶和华的约柜的人走了六步，大卫就献一头公牛和一只肥畜为祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S26_14","011_6_14","2SA","6","14","14","大卫束着细麻布的以弗得，在耶和华面前极力跳舞。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S26_15","011_6_15","2SA","6","15","15","这样，大卫和以色列全家，以欢呼和角声，把耶和华的约柜抬了上来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S26_16","011_6_16","2SA","6","16","16","耶和华的约柜运进大卫城的时候，扫罗的女儿米甲从窗户往外观看，看见大卫王在耶和华面前跳跃舞蹈，心里就鄙视他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S26_17","011_6_17","2SA","6","17","17","他们把耶和华的约柜抬进去，安放在帐棚里它自己的地方，就是安放在大卫给它支搭的帐棚里，大卫就在耶和华面前献上燔祭和平安祭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S26_18","011_6_18","2SA","6","18","18","大卫献完了燔祭和平安祭，就奉万军之耶和华的名给人民祝福。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S26_19","011_6_19","2SA","6","19","19","又分给众人，就是分给以色列全体群众，无论男女，每人一个饼、一个枣饼、一个葡萄干饼；然后众人就各归各家去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S26_20","011_6_20","2SA","6","20","20","大卫回去要给自己的家人祝福。扫罗的女儿米甲出来迎见大卫，说：“以色列王今天多么荣耀啊！他今天竟在众臣仆的婢女眼前，赤身露体，就像一个卑贱的人露体一样。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S26_21","011_6_21","2SA","6","21","21","大卫对米甲说：“我是在耶和华面前跳舞；耶和华拣选了我，使我高过你父亲和他的全家，立我作耶和华的子民以色列的领袖，所以我要在耶和华面前跳舞作乐。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S26_22","011_6_22","2SA","6","22","22","我还要比今天这样更卑贱，我要自视卑微。至于你所说的那些婢女，她们倒要尊重我。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S26_23","011_6_23","2SA","6","23","23","扫罗的女儿米甲，一直到她死的日子，都没有生育。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S27_1","011_7_1","2SA","7","1","1","那时，王住在自己的宫中，耶和华使他安享太平，不受周围仇敌的侵扰。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S27_2","011_7_2","2SA","7","2","2","王对拿单先知说：“你看！我自己住在香柏木的宫里，耶和华的约柜却停在帐幕内。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S27_3","011_7_3","2SA","7","3","3","拿单对王说：“你可以照着你心所想的一切去作，因为耶和华与你同在。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S27_4","011_7_4","2SA","7","4","4","那天晚上，耶和华的话临到拿单说： ");
INSERT INTO cmn_ncvs_vpl VALUES ("S27_5","011_7_5","2SA","7","5","5","“你去对我的仆人大卫说：耶和华这样说：‘你要建造一座殿宇给我居住吗？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("S27_6","011_7_6","2SA","7","6","6","因为自从我把以色列人从埃及带上来的那天起，直到今日，我都没有住过殿宇。我一直都住在帐棚和会幕里，到处漂泊。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S27_7","011_7_7","2SA","7","7","7","我与以色列众人一起走过的地方，我可曾对以色列的一个支派的官长，就是我所吩咐要牧养我子民以色列的，说：你们为什么不给我建造一座香柏木的殿宇呢？’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("S27_8","011_7_8","2SA","7","8","8","现在你要对我的仆人大卫这样说：‘万军之耶和华这样说：我把你从牧场中、从照顾羊群的工作中拣选出来，使你作我子民以色列的领袖， ");
INSERT INTO cmn_ncvs_vpl VALUES ("S27_9","011_7_9","2SA","7","9","9","你无论到哪里去，我都与你同在；我必在你面前剪除你所有的仇敌。我要使你得享大名，像世上那些伟人的名一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S27_10","011_7_10","2SA","7","10","10","我要为我的子民以色列选定一个地方，不再受骚扰；恶人也不能再像以前那样苦待他们， ");
INSERT INTO cmn_ncvs_vpl VALUES ("S27_11","011_7_11","2SA","7","11","11","像我立了士师治理我的子民以色列的那天以来那样。我要使你安享太平，不受你所有的仇敌侵扰。耶和华向你宣告，耶和华要亲自为你建立一个朝代。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S27_12","011_7_12","2SA","7","12","12","到了你的寿数满足，你与你的列祖一起长眠的时候，我必兴起你亲生的后裔接替你，并且我要坚固他的国。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S27_13","011_7_13","2SA","7","13","13","他必为我的名建造一座殿宇，我要永远坚固他的国位。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S27_14","011_7_14","2SA","7","14","14","我要作他的父亲，他要作我的儿子，他若是犯了罪，我要用人的刑杖、用世人的鞭子纠正他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S27_15","011_7_15","2SA","7","15","15","但我的慈爱必不离开他，像离开在你面前的扫罗一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S27_16","011_7_16","2SA","7","16","16","你的家和你的王国，也必在我的面前永远坚定，你的王位也必永远坚立。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S27_17","011_7_17","2SA","7","17","17","拿单按着这一切话，又照着全部的默示，都对大卫说了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S27_18","011_7_18","2SA","7","18","18","于是，大卫王进去，坐在耶和华面前，说：“主耶和华啊！我是谁，我的家又算什么，你竟带领我到这地步？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("S27_19","011_7_19","2SA","7","19","19","主耶和华啊，这在你眼中还看为小事，你也说到你仆人的家未来的事。主耶和华啊，这岂是人常遇到的事吗？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("S27_20","011_7_20","2SA","7","20","20","主耶和华啊，你认识你的仆人，大卫还有什么话可以对你说呢？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("S27_21","011_7_21","2SA","7","21","21","你因自己应许的缘故，又按照自己的心意，行了这大事，为要使你仆人明白。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S27_22","011_7_22","2SA","7","22","22","主耶和华啊，因此，你是伟大的！按照我们耳朵所听见的，没有像你的，除了你以外，再没有别的　神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S27_23","011_7_23","2SA","7","23","23","世上有哪一个国家像你的子民以色列呢？　神曾亲自救赎他们，使他们作自己的子民，又为他自己立名，为他们作了大事，为你的地作了可畏的事；在你的子民面前，就是你从埃及救赎出来归你自己的子民面前，赶出了列国的人和他们的神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S27_24","011_7_24","2SA","7","24","24","你为自己坚立了你的子民以色列，使他们永远作你的子民；耶和华啊，你也作了他们的　神。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S27_25","011_7_25","2SA","7","25","25","耶和华　神啊！你所应许关于你仆人和他的家的话，现在求你永远坚守，并且照着你所说的去行吧； ");
INSERT INTO cmn_ncvs_vpl VALUES ("S27_26","011_7_26","2SA","7","26","26","这样，你的名必永远为大，以致人要说：‘万军之耶和华是以色列的　神。’你仆人大卫的家也必在你面前得坚立。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S27_27","011_7_27","2SA","7","27","27","万军之耶和华以色列的　神啊！因为你曾启示你的仆人说：‘我要为你建立家室。’所以你的仆人才敢来向你作这样的祷告。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S27_28","011_7_28","2SA","7","28","28","主耶和华啊！你是　神；你的话是真实可信的。你向你仆人应许了这美好的福分。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S27_29","011_7_29","2SA","7","29","29","现在求你乐意赐福给你仆人的家，使它在你面前可以永远存在。主耶和华啊！因为你曾经这样应许，愿你仆人的家因你的赐福永远蒙福。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S28_1","011_8_1","2SA","8","1","1","这事以后，大卫攻打非利士人，制伏了他们。大卫从非利士人手中取得了京城的控制权。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S28_2","011_8_2","2SA","8","2","2","他又击败摩押人，使他们躺在地上，用绳子量他们，把量两绳的杀死，让量一绳的存活。这样，摩押人就臣服大卫，给他进贡。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S28_3","011_8_3","2SA","8","3","3","琐巴王利合的儿子哈大底谢，往幼发拉底河去要夺回他统治这河的势力的时候，大卫就攻打他。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S28_4","011_8_4","2SA","8","4","4","大卫从他那里掳获了骑兵一千七百，步兵二万；除了留下足够拉一百辆铁车的马以外，大卫把其他所有拉战车的马都砍断蹄筋。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S28_5","011_8_5","2SA","8","5","5","大马士革的亚兰人来协助琐巴王哈大底谢，大卫就击杀了亚兰人二万二千。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S28_6","011_8_6","2SA","8","6","6","于是大卫在大马士革的亚兰地驻军。这样亚兰人就臣服大卫，给他进贡。大卫无论到什么地方去，耶和华都使他得胜。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S28_7","011_8_7","2SA","8","7","7","大卫夺取了哈大底谢臣仆所拿的金盾牌，带回耶路撒冷。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S28_8","011_8_8","2SA","8","8","8","大卫王又从哈大底谢的两座城比他和比罗他夺取了大量的铜。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S28_9","011_8_9","2SA","8","9","9","哈马王陀以听见大卫打败了哈大底谢的全军， ");
INSERT INTO cmn_ncvs_vpl VALUES ("S28_10","011_8_10","2SA","8","10","10","就差派他的儿子约兰去见大卫王，向他问安，祝贺他，因为大卫和哈大底谢争战，竟击败了他。原来陀以常常与哈大底谢争战。约兰手里还带着一些银器、金器和铜器。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S28_11","011_8_11","2SA","8","11","11","大卫王也把这些器皿，连同他从他征服的各国得来的金银都一起分别为圣，献给耶和华。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S28_12","011_8_12","2SA","8","12","12","就是从以东、摩押、亚扪人、非利士人、亚玛力人所得来的，以及从琐巴王利合的儿子哈大底谢获得的战利品。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S28_13","011_8_13","2SA","8","13","13","大卫在盐谷击杀了一万八千以东人回来以后，就大有名声。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S28_14","011_8_14","2SA","8","14","14","他又在以东设立防军；他在以东各地都设立防军，所有以东人就都臣服大卫。大卫无论到什么地方去，耶和华都使他得胜。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S28_15","011_8_15","2SA","8","15","15","大卫作王统治全以色列，以公平和正义对待所有的人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S28_16","011_8_16","2SA","8","16","16","洗鲁雅的儿子约押作军队的统帅，亚希律的儿子约沙法作史官， ");
INSERT INTO cmn_ncvs_vpl VALUES ("S28_17","011_8_17","2SA","8","17","17","亚希突的儿子撒督和亚比亚他的儿子亚希米勒作祭司长，西莱雅作书记， ");
INSERT INTO cmn_ncvs_vpl VALUES ("S28_18","011_8_18","2SA","8","18","18","耶何耶大的儿子比拿雅统管基利提人和比利提人；大卫的众子都作领袖。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S29_1","011_9_1","2SA","9","1","1","大卫问：“扫罗家还有剩下的人没有？我要因约拿单的缘故，以慈爱待他。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S29_2","011_9_2","2SA","9","2","2","扫罗家有一个仆人，名叫洗巴。有人叫他来见大卫；王问他：“你是洗巴吗？”他回答：“仆人正是。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S29_3","011_9_3","2SA","9","3","3","王又问：“扫罗家还有人没有？我要以　神的慈爱待他。”洗巴回答王说：“还有约拿单的一个儿子，他双脚残废了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S29_4","011_9_4","2SA","9","4","4","王又问他说：“他在哪里？”洗巴回答王说：“他在罗．底巴亚米利的儿子玛吉家里。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S29_5","011_9_5","2SA","9","5","5","于是大卫王派人去把他从罗．底巴亚米利的儿子玛吉家里接来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S29_6","011_9_6","2SA","9","6","6","扫罗的孙子，约拿单的儿子米非波设来到大卫面前，俯伏叩拜。大卫说：“米非波设！”他回答：“仆人在这里。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S29_7","011_9_7","2SA","9","7","7","大卫对他说：“你不要怕，我必因你父亲约拿单的缘故，以慈爱待你，把你祖父扫罗所有的田地都归还给你；你也可以常常与我同席吃饭。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S29_8","011_9_8","2SA","9","8","8","米非波设再叩拜说：“仆人算什么？你竟然眷顾我这个像条死狗的人！” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S29_9","011_9_9","2SA","9","9","9","王把扫罗的仆人洗巴召来，对他说：“我已经把属于扫罗，以及他全家所有的一切，给了你主人的孙子。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S29_10","011_9_10","2SA","9","10","10","你和你的儿子，以及你的仆人，都要替他耕种田地；你要把所收获的拿来，供他食用。米非波设要常常与我同席吃饭。”洗巴有十五个儿子，二十个仆人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S29_11","011_9_11","2SA","9","11","11","洗巴对王说：“我主我王吩咐仆人的一切，仆人都必遵行。”于是米非波设与王同桌吃饭，像是王的一个儿子一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S29_12","011_9_12","2SA","9","12","12","米非波设有一个小儿子，名叫米迦。住在洗巴家里的人，都作了米非波设的仆人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S29_13","011_9_13","2SA","9","13","13","这样，米非波设住在耶路撒冷，常常与王同席吃饭。可是他的双腿都是瘸的。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S210_1","011_10_1","2SA","10","1","1","后来，亚扪人的王死了，他的儿子哈嫩继承他作王。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S210_2","011_10_2","2SA","10","2","2","大卫说：“我要恩待拿辖的儿子哈嫩，像他父亲恩待我一样。”于是大卫差派自己的臣仆，为他丧父的事安慰他。大卫的臣仆到了亚扪人境内时， ");
INSERT INTO cmn_ncvs_vpl VALUES ("S210_3","011_10_3","2SA","10","3","3","亚扪人的众领袖对他们的主哈嫩说：“大卫差派这些慰问的人到你这里来，你以为他是尊敬你父亲吗？他派遣臣仆到你这里来，不是为了要窥探这城，侦察清楚，然后把城倾覆吗？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S210_4","011_10_4","2SA","10","4","4","于是哈嫩拿住大卫的臣仆，把他们的胡须剃去一半，又把他们的外袍割去半截，露出臀部，然后才放他们走。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S210_5","011_10_5","2SA","10","5","5","有人告诉大卫，他就派人去迎接他们，因为他们非常羞耻。王就说：“你们可以住在耶利哥，等到你们的胡须长长了才回来。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S210_6","011_10_6","2SA","10","6","6","亚扪人知道大卫憎恶他们，就派人去招募伯．利合的亚兰人和琐巴的亚兰人，步兵二万，玛迦王的人一千，陀伯人一万二千。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S210_7","011_10_7","2SA","10","7","7","大卫听见了，就差派约押和全体勇士出去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S210_8","011_10_8","2SA","10","8","8","亚扪人出来，在城门前摆阵，琐巴和利合的亚兰人，陀伯人和玛迦人，也分别在郊野摆阵。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S210_9","011_10_9","2SA","10","9","9","约押看见自己前后受敌，就从以色列所有的精兵中，挑选一部分出来，使他们摆阵去迎战亚兰人， ");
INSERT INTO cmn_ncvs_vpl VALUES ("S210_10","011_10_10","2SA","10","10","10","他把其余的人交在他兄弟亚比筛手下，使他们摆阵去迎战亚扪人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S210_11","011_10_11","2SA","10","11","11","约押对亚比筛说：“如果亚兰人比我强，你就来帮助我。如果亚扪人比你强，我就去帮助你。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S210_12","011_10_12","2SA","10","12","12","你要刚强；为了我们的人民和我们　神的众城镇，我们要刚强！愿耶和华成全他看为美的事。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S210_13","011_10_13","2SA","10","13","13","于是约押和与他在一起的人前进，攻击亚兰人；亚兰人在约押面前逃跑。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S210_14","011_10_14","2SA","10","14","14","亚扪人看见亚兰人逃跑，他们也在亚比筛面前逃跑，逃进城里去了。约押就从亚扪人那里回来，回到耶路撒冷去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S210_15","011_10_15","2SA","10","15","15","亚兰人见自己被以色列人击败，就再聚集起来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S210_16","011_10_16","2SA","10","16","16","哈大底谢差遣人把幼发拉底河那边的亚兰人调来。他们来到了希兰，由哈大底谢的将军朔法率领他们。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S210_17","011_10_17","2SA","10","17","17","有人告诉了大卫，他就聚集所有的以色列人，渡过约旦河，来到了希兰。亚兰人摆好了阵迎击大卫，与他交战。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S210_18","011_10_18","2SA","10","18","18","亚兰人却在以色列人面前逃跑。大卫杀了亚兰七百名驾驶战车的军兵，四万骑兵。又击杀了亚兰军队的将军朔法，他就死在那里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S210_19","011_10_19","2SA","10","19","19","所有臣服于哈大底谢的王看见自己被以色列人打败，就与以色列人议和，臣服于他们。于是亚兰人害怕，不敢再帮助亚扪人了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S211_1","011_11_1","2SA","11","1","1","过了年，在列王出征的时候，大卫派遣约押和自己的臣仆，以及以色列众军一同出征。他们歼灭了亚扪人，并且包围了拉巴。大卫却留在耶路撒冷。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S211_2","011_11_2","2SA","11","2","2","有一天近黄昏的时候，大卫从床上起来，在王宫的平顶上散步。他从平顶上看见一个妇人在洗澡；这妇人容貌美丽。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S211_3","011_11_3","2SA","11","3","3","大卫派人去查问那妇人是谁。有人说：“这不是以连的女儿、赫人乌利亚的妻子拔示巴吗？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S211_4","011_11_4","2SA","11","4","4","于是大卫差派使者去把她接来。她来到大卫那里，大卫就与她同房。那时她的月经刚得洁净。事后，她就回家去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S211_5","011_11_5","2SA","11","5","5","后来那妇人怀了孕，就打发人去告诉大卫，说：“我怀孕了！” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S211_6","011_11_6","2SA","11","6","6","大卫派人到约押那里，说：“你打发赫人乌利亚到我这里来。”约押就打发乌利亚去见大卫。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S211_7","011_11_7","2SA","11","7","7","乌利亚来到大卫那里，大卫就问约押和士兵可好，又问战场上的情形怎样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S211_8","011_11_8","2SA","11","8","8","大卫对乌利亚说：“你回家去，洗洗脚吧！”乌利亚就离开了王宫。随后王的一份礼物也跟着送去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S211_9","011_11_9","2SA","11","9","9","乌利亚却和他主人的臣仆一同睡在王宫门外，没有回到自己家里去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S211_10","011_11_10","2SA","11","10","10","有人告诉大卫说：“乌利亚没有下到自己家里去。”大卫就问乌利亚：“你不是从远路回来吗？为什么不下到自己家里去呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S211_11","011_11_11","2SA","11","11","11","乌利亚回答大卫说：“约柜、以色列人和犹大人都住在棚里，我主人约押和我主人的臣仆都在野地安营，我怎能回家吃喝，与妻子同睡呢？我指着王和王的生命发誓：我绝不敢作这样的事。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S211_12","011_11_12","2SA","11","12","12","大卫对乌利亚说：“你今天还留在这里，明天我才打发你去。”那一天，乌利亚就留在耶路撒冷。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S211_13","011_11_13","2SA","11","13","13","次日，大卫召了乌利亚来，叫乌利亚与他一起吃喝，使他喝醉。到了晚上，乌利亚出去，与他主人的臣仆一同睡在自己的床铺上，还是没有下到自己家里去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S211_14","011_11_14","2SA","11","14","14","到了早晨，大卫写了一封给约押的信，交乌利亚亲手带去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S211_15","011_11_15","2SA","11","15","15","他在信里写着说：“要把乌利亚派到战斗最猛烈的前线去，然后你们就退到他后边，让他被击杀。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S211_16","011_11_16","2SA","11","16","16","那时，约押正在围城，他知道哪里有强悍的守军，就派乌利亚到那里去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S211_17","011_11_17","2SA","11","17","17","城里的人出来，与约押交战。大卫的仆人中有一些倒毙了，赫人乌利亚也死了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S211_18","011_11_18","2SA","11","18","18","于是，约押派人去把战事的一切情形都报告大卫。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S211_19","011_11_19","2SA","11","19","19","他又吩咐那使者说：“你把战事的一切情形对王说完了以后， ");
INSERT INTO cmn_ncvs_vpl VALUES ("S211_20","011_11_20","2SA","11","20","20","王若是大怒，责问你：‘你们为什么那样靠近那城争战呢？你们不知道敌人会从城墙上射箭下来吗？ ");
INSERT INTO cmn_ncvs_vpl VALUES ("S211_21","011_11_21","2SA","11","21","21","从前击杀了耶路．比设的儿子亚比米勒的是谁呢？不是一个妇人从城墙上把一块磨石丢在他身上，他就死在提备斯吗？你们为什么靠近城墙呢？’你就回答：‘王的仆人赫人乌利亚也死了。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S211_22","011_11_22","2SA","11","22","22","于是那使者去了；他一来到，就把约押差遣他所要说的一切都报告了大卫。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S211_23","011_11_23","2SA","11","23","23","那使者又对大卫说：“那些人比我们强，他们出到旷野攻打我们，我们把他们赶回城门口。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S211_24","011_11_24","2SA","11","24","24","那时射手从城墙上射王的仆人；王的仆人中有些阵亡了，你的仆人赫人乌利亚也死了。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S211_25","011_11_25","2SA","11","25","25","大卫对那使者说：“你要对约押这样说：‘不要为这件事难过，因为刀剑有时吞灭这人，有时吞灭那人。你只要加紧攻打这城，把城毁灭。’你要这样鼓励他。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S211_26","011_11_26","2SA","11","26","26","乌利亚的妻子听到丈夫乌利亚死了，就为他哀哭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S211_27","011_11_27","2SA","11","27","27","守丧期一过，大卫就派人去把拔示巴接到宫里，她就作了大卫的妻子，给大卫生了一个儿子。大卫所作的这事，耶和华看为恶。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S212_1","011_12_1","2SA","12","1","1","耶和华差派拿单去见大卫。于是拿单来到大卫那里，对他说：“在一座城里有两个人，一个富有，一个贫穷。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S212_2","011_12_2","2SA","12","2","2","那富有的有极多牛羊， ");
INSERT INTO cmn_ncvs_vpl VALUES ("S212_3","011_12_3","2SA","12","3","3","那贫穷的除了买来养的一只母羊羔以外，什么也没有。那小羊在他家里和他的儿女一同长大，小羊吃他的食物，喝他杯中的饮料，睡在他的怀里，就像他的女儿一样。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S212_4","011_12_4","2SA","12","4","4","有一个旅客来到富翁那里，他舍不得从自己的牛群羊群中取一头出来，款待到他那里来的旅客，却取了那穷人的母羊羔，款待到他那里来的客人。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S212_5","011_12_5","2SA","12","5","5","大卫就非常恼怒那人，对拿单说：“我指着永活的耶和华起誓，作这事的人该死。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S212_6","011_12_6","2SA","12","6","6","他必须四倍赔偿这羊羔，因为他作了这事，又因他没有怜悯的心。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S212_7","011_12_7","2SA","12","7","7","拿单对大卫说：“你就是那人！耶和华以色列的　神这样说：‘我膏立了你作以色列的王，把你从扫罗的手里救了出来， ");
INSERT INTO cmn_ncvs_vpl VALUES ("S212_8","011_12_8","2SA","12","8","8","把你主人的家赐给你，把你主人的妻妾交在你怀里，又把以色列和犹大家赐给你。你若是还以为太少，我还可以多多加给你。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S212_9","011_12_9","2SA","12","9","9","你为什么藐视耶和华的话，行他看为恶的事呢？你用刀击杀了赫人乌利亚，娶了他的妻子作你的妻子，你借着亚扪人的刀杀了乌利亚。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S212_10","011_12_10","2SA","12","10","10","所以，从今以后，刀剑必不离开你的家，因为你藐视了我，娶了赫人乌利亚的妻子作你的妻子。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("S212_11","011_12_11","2SA","12","11","11","耶和华这样说：‘看哪！我必从你家中兴起祸患攻击你；我要在你的眼前把你的妃嫔拿去赐给别人。他要在光天化日之下与她们同床。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S212_12","011_12_12","2SA","12","12","12","你在暗中行了这事，我却要在所有以色列人面前，在光天化日之下行这事报应你。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S212_13","011_12_13","2SA","12","13","13","大卫对拿单说：“我得罪了耶和华了。”拿单对大卫说：“耶和华已经除去了你的罪，你必不至于死。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S212_14","011_12_14","2SA","12","14","14","只是因为你作了这事，使耶和华的仇敌大得亵渎的机会，所以你所生的儿子必定死。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S212_15","011_12_15","2SA","12","15","15","于是拿单回自己的家去了。耶和华击打乌利亚的妻子给大卫所生的孩子，他就害了重病。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S212_16","011_12_16","2SA","12","16","16","大卫为那孩子恳求　神，并且禁食。他进房里去，终夜躺在地上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S212_17","011_12_17","2SA","12","17","17","他家中的老侍从站在他旁边，要把他从地上扶起来，他却不肯，也不与他们一起吃饭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S212_18","011_12_18","2SA","12","18","18","到了第七天，孩子死了。大卫的臣仆不敢告诉他孩子死了，因为他们说：“看哪，孩子还活着的时候，我们劝他，他尚且不听我们的话。现在我们怎么能告诉他孩子已经死了呢？他会伤心欲绝的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S212_19","011_12_19","2SA","12","19","19","大卫看见他的臣仆彼此低声耳语，就知道孩子已经死了。他问臣仆说：“孩子死了吗？”他们回答：“死了！” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S212_20","011_12_20","2SA","12","20","20","于是大卫从地上起来，洗澡，抹膏，更换衣服，进耶和华的殿去敬拜，然后回到自己的宫里去，吩咐人给他摆上饭，他就吃了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S212_21","011_12_21","2SA","12","21","21","臣仆问他：“你为什么这样作呢？孩子还活着的时候，你为他禁食哭泣；孩子死了，你倒起来吃饭！” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S212_22","011_12_22","2SA","12","22","22","他回答：“孩子还活着的时候，我禁食哭泣，因为我想：‘也许耶和华怜悯我，让孩子可以活着。’ ");
INSERT INTO cmn_ncvs_vpl VALUES ("S212_23","011_12_23","2SA","12","23","23","现在他死了，我为什么还要禁食呢？我还能使他回来吗？我要到他那里去，他却不能回到我这里来。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S212_24","011_12_24","2SA","12","24","24","大卫安慰他的妻子拔示巴，进到她那里去，与她同睡。她生了一个儿子，大卫给他起名叫所罗门；耶和华也喜爱他， ");
INSERT INTO cmn_ncvs_vpl VALUES ("S212_25","011_12_25","2SA","12","25","25","就差派拿单先知去，照着耶和华的吩咐，给他起名叫耶底底亚。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S212_26","011_12_26","2SA","12","26","26","那时，约押正在攻打亚扪人的拉巴，攻取了王城。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S212_27","011_12_27","2SA","12","27","27","约押派遣使者去见大卫，说：“我攻打拉巴，已经攻取了水城。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S212_28","011_12_28","2SA","12","28","28","现在，请你聚集其余的人民，安营攻打这城，把城攻取；免得我攻取了这城，人就以我的名字来叫这城。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S212_29","011_12_29","2SA","12","29","29","于是大卫聚集所有的人民，向拉巴进军；攻打那城，把它攻取了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S212_30","011_12_30","2SA","12","30","30","大卫从他们的王的头上夺取了王冠。王冠的金子重三十五公斤，上面嵌有宝石，人把这冠冕戴在大卫的头上。大卫又从这城里带走了许多战利品， ");
INSERT INTO cmn_ncvs_vpl VALUES ("S212_31","011_12_31","2SA","12","31","31","又把那城里的人民带出去，使他们用锯子、铁耙、铁斧作工，或使他们在砖窑服役。大卫对待亚扪各城的居民都是这样。后来，大卫和众人都回耶路撒冷去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S213_1","011_13_1","2SA","13","1","1","大卫的儿子押沙龙有一个美丽的妹妹，名叫他玛；大卫的儿子暗嫩爱上了她。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S213_2","011_13_2","2SA","13","2","2","暗嫩为了他妹妹他玛的缘故，因爱成病。因为他玛还是处女，所以暗嫩看来很难对她采取什么行动。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S213_3","011_13_3","2SA","13","3","3","暗嫩有一个朋友，名叫约拿达，是大卫的哥哥示米亚的儿子。约拿达是一个非常狡猾的人。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S213_4","011_13_4","2SA","13","4","4","他问暗嫩说：“王子啊！你为什么一天比一天瘦弱呢？你可以告诉我吗？”暗嫩说：“我爱上了我兄弟押沙龙的妹妹他玛。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S213_5","011_13_5","2SA","13","5","5","约拿达对他说：“你可以躺在床上装病。你父亲来看你的时候，你就对他说：‘求你叫我的妹妹他玛来，把食物递给我吃；叫她在我眼前预备食物，好使我可以看见，也可以从她的手中取食。’” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S213_6","011_13_6","2SA","13","6","6","于是暗嫩躺着装病。王来看他，暗嫩对王说：“求你叫我的妹妹他玛来，叫她在我眼前给我做两个饼，我可以从她的手里拿过来吃。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S213_7","011_13_7","2SA","13","7","7","大卫就派人到宫里去对他玛说：“你到你哥哥暗嫩的屋里去，为他预备食物。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S213_8","011_13_8","2SA","13","8","8","他玛就到她哥哥暗嫩的屋里去；暗嫩正躺着。他玛取了点面，把面和好，就在暗嫩面前做饼，并且把饼烤熟了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S213_9","011_13_9","2SA","13","9","9","她拿过锅来，在他面前把饼倒出来，暗嫩却不肯吃，他说：“叫众人离开我出去！”众人就都离开他出去了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S213_10","011_13_10","2SA","13","10","10","暗嫩对他玛说：“把食物带到卧房来，我好从你的手里拿过来吃。”他玛拿着她做好的饼，进了卧房，到她哥哥暗嫩那里去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S213_11","011_13_11","2SA","13","11","11","他玛上到他面前，给他吃的时候，暗嫩却拉住她，对她说：“妹妹，来与我同寝吧！” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S213_12","011_13_12","2SA","13","12","12","他玛对他说：“不要！哥哥！不要污辱我！在以色列中不可作这样的事。你不要作这丑事。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S213_13","011_13_13","2SA","13","13","13","至于我，我到哪里除去我的耻辱呢？至于你，你在以色列中也会成了一个愚妄的人。现在请你去对王说，他必不会禁止我归你的。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S213_14","011_13_14","2SA","13","14","14","但暗嫩不肯听她的话，他又比他玛有力，就污辱了她，与她同寝。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S213_15","011_13_15","2SA","13","15","15","事后，暗嫩非常恨她；他对他玛的恨比以前对她的爱更大，所以暗嫩对她说：“你起来！走吧！” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S213_16","011_13_16","2SA","13","16","16","他玛却对他说：“我的哥哥啊，不！你赶我出去的这罪比你刚才与我所行的罪更大了。”但是暗嫩不肯听她的话， ");
INSERT INTO cmn_ncvs_vpl VALUES ("S213_17","011_13_17","2SA","13","17","17","就叫了侍候他的仆人来，说：“把这女人从我面前赶到外面去，然后把门锁上。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S213_18","011_13_18","2SA","13","18","18","那时他玛身上穿着长袖彩衣，因为未嫁的公主都是这样穿的。那侍候暗嫩的仆人把她赶到外面去，随后把门锁上。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S213_19","011_13_19","2SA","13","19","19","他玛把尘土撒在自己的头上，撕裂身上的长袖彩衣，又把一只手放在头上，一边行走一边哭叫。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S213_20","011_13_20","2SA","13","20","20","她哥哥押沙龙问她：“是不是你哥哥暗嫩与你亲近了？我妹妹啊，你现在不要作声，他是你的哥哥，你不要把这事放在心上。”于是他玛孤单凄凉地住在她哥哥押沙龙的家里。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S213_21","011_13_21","2SA","13","21","21","大卫王听见了这一切事，就非常生气。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S213_22","011_13_22","2SA","13","22","22","押沙龙什么话都没有对暗嫩说。押沙龙恨暗嫩，因为暗嫩污辱了他的妹妹他玛。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S213_23","011_13_23","2SA","13","23","23","两年以后，在以法莲边界的巴力．夏琐，押沙龙雇了人为他剪羊毛，押沙龙邀请王所有的儿子到那里去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S213_24","011_13_24","2SA","13","24","24","押沙龙去见王说：“看哪！现在你的仆人雇了人剪羊毛；请王和王的臣仆与我一同去。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S213_25","011_13_25","2SA","13","25","25","王对押沙龙说：“不！我儿，我们不必都去，免得我们成为你的重担。”押沙龙再三勉强王去，王还是不肯去，只是为他祝福。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S213_26","011_13_26","2SA","13","26","26","押沙龙说：“王若是不去，求王让我的哥哥暗嫩与我一同去。”王问他：“为什么要他与你一同去呢？” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S213_27","011_13_27","2SA","13","27","27","押沙龙再三求王，王就派暗嫩和王所有的儿子与他一同去。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S213_28","011_13_28","2SA","13","28","28","押沙龙吩咐他的仆人说：“你们注意！暗嫩酒酣耳热的时候，我对你们说：‘击杀暗嫩！’你们就把他杀死。不要惧怕，这不是我吩咐你们的吗？你们要坚强，作勇敢的人。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S213_29","011_13_29","2SA","13","29","29","押沙龙的仆人就照押沙龙所吩咐的，向暗嫩行了。王所有的儿子就起来，各人骑上自己的骡子逃跑了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S213_30","011_13_30","2SA","13","30","30","他们还在路上的时候，有消息传到大卫那里，说：“押沙龙杀了王所有的儿子，没有剩下一个。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S213_31","011_13_31","2SA","13","31","31","王就起来，撕裂衣服，躺在地上。侍立在他身旁的所有臣仆，也都撕裂衣服。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S213_32","011_13_32","2SA","13","32","32","大卫的哥哥示米亚的儿子约拿达说：“我主不要以为所有的年轻人、王的儿子都被杀死了。其实死的只有暗嫩一人；自从暗嫩污辱了押沙龙的妹妹他玛那一天起，押沙龙就定意要杀死他了。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S213_33","011_13_33","2SA","13","33","33","现在我主我王不要把这事放在心上，以为王所有的儿子都死了。其实死的只有暗嫩一人。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S213_34","011_13_34","2SA","13","34","34","押沙龙逃走了。守望的年轻人举目观看，看见许多人从后面山坡旁边的路而来。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S213_35","011_13_35","2SA","13","35","35","约拿达对王说：“看哪！王的儿子都回来了。正如你仆人所说的，事情果然是这样。” ");
INSERT INTO cmn_ncvs_vpl VALUES ("S213_36","011_13_36","2SA","13","36","36","他刚说完了，王的众子就都来到了，他们都放声大哭；王和他所有的臣仆也都号咷痛哭。 ");
INSERT INTO cmn_ncvs_vpl VALUES ("S213_37","011_13_37","2SA","13","37","37","押沙龙逃亡，走到基述王亚米忽的儿子达买那里去了。大卫天天为他的儿子哀伤。 ");
INSERT INTO cmn_ncvs_vpl 