﻿USE sofia;
DROP TABLE IF EXISTS sofia.cmn_cu89t_vpl;
CREATE TABLE cmn_cu89t_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cmn_cu89t_vpl WRITE;
INSERT INTO cmn_cu89t_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","起初，上帝創造天地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","地是空虛混沌，淵面黑暗；上帝的靈運行在水面上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","上帝說：「要有光」，就有了光。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","上帝看光是好的，就把光暗分開了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","上帝稱光為「晝」，稱暗為「夜」。有晚上，有早晨，這是頭一日。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","上帝說：「諸水之間要有空氣，將水分為上下。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","上帝就造出空氣，將空氣以下的水、空氣以上的水分開了。事就這樣成了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","上帝稱空氣為「天」。有晚上，有早晨，是第二日。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","上帝說：「天下的水要聚在一處，使旱地露出來。」事就這樣成了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","上帝稱旱地為「地」，稱水的聚處為「海」。上帝看着是好的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","上帝說：「地要發生青草和結種子的菜蔬，並結果子的樹木，各從其類，果子都包着核。」事就這樣成了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","於是地發生了青草和結種子的菜蔬，各從其類；並結果子的樹木，各從其類；果子都包着核。上帝看着是好的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","有晚上，有早晨，是第三日。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","上帝說：「天上要有光體，可以分晝夜，作記號，定節令、日子、年歲， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","並要發光在天空，普照在地上。」事就這樣成了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","於是上帝造了兩個大光，大的管晝，小的管夜，又造眾星， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","就把這些光擺列在天空，普照在地上， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","管理晝夜，分別明暗。上帝看着是好的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","有晚上，有早晨，是第四日。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","上帝說：「水要多多滋生有生命的物；要有雀鳥飛在地面以上，天空之中。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","上帝就造出大魚和水中所滋生各樣有生命的動物，各從其類；又造出各樣飛鳥，各從其類。上帝看着是好的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","上帝就賜福給這一切，說：「滋生繁多，充滿海中的水；雀鳥也要多生在地上。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","有晚上，有早晨，是第五日。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","上帝說：「地要生出活物來，各從其類；牲畜、昆蟲、野獸，各從其類。」事就這樣成了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","於是上帝造出野獸，各從其類；牲畜，各從其類；地上一切昆蟲，各從其類。上帝看着是好的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","上帝說：「我們要照着我們的形像、按着我們的樣式造人，使他們管理海裏的魚、空中的鳥、地上的牲畜，和全地，並地上所爬的一切昆蟲。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","上帝就照着自己的形像造人，乃是照着他的形像造男造女。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","上帝就賜福給他們，又對他們說：「要生養眾多，遍滿地面，治理這地，也要管理海裏的魚、空中的鳥，和地上各樣行動的活物。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","上帝說：「看哪，我將遍地上一切結種子的菜蔬和一切樹上所結有核的果子全賜給你們作食物。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","至於地上的走獸和空中的飛鳥，並各樣爬在地上有生命的物，我將青草賜給牠們作食物。」事就這樣成了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","上帝看着一切所造的都甚好。有晚上，有早晨，是第六日。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","天地萬物都造齊了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","到第七日，上帝造物的工已經完畢，就在第七日歇了他一切的工，安息了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","上帝賜福給第七日，定為聖日；因為在這日，上帝歇了他一切創造的工，就安息了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","創造天地的來歷，在耶和華上帝造天地的日子，乃是這樣， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","野地還沒有草木，田間的菜蔬還沒有長起來；因為耶和華上帝還沒有降雨在地上，也沒有人耕地， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","但有霧氣從地上騰，滋潤遍地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","耶和華上帝用地上的塵土造人，將生氣吹在他鼻孔裏，他就成了有靈的活人，名叫 亞當。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","耶和華上帝在東方的伊甸立了一個園子，把所造的人安置在那裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","耶和華上帝使各樣的樹從地裏長出來，可以悅人的眼目，其上的果子好作食物。園子當中又有生命樹和分別善惡的樹。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","有河從伊甸流出來，滋潤那園子，從那裏分為四道： ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","第一道名叫比遜，就是環繞哈腓拉全地的。在那裏有金子， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","並且那地的金子是好的；在那裏又有珍珠和紅瑪瑙。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","第二道河名叫基訓，就是環繞古實全地的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","第三道河名叫底格里斯，流在亞述的東邊。第四道河就是幼發拉底河。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","耶和華上帝將那人安置在伊甸園，使他修理，看守。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","耶和華上帝吩咐他說：「園中各樣樹上的果子，你可以隨意吃， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","只是分別善惡樹上的果子，你不可吃，因為你吃的日子必定死！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","耶和華上帝說：「那人獨居不好，我要為他造一個配偶幫助他。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","耶和華上帝用土所造成的野地各樣走獸和空中各樣飛鳥都帶到那人面前，看他叫甚麼。那人怎樣叫各樣的活物，那就是牠的名字。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","那人便給一切牲畜和空中飛鳥、野地走獸都起了名；只是那人沒有遇見配偶幫助他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","耶和華上帝使他沉睡，他就睡了；於是取下他的一條肋骨，又把肉合起來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","耶和華上帝就用那人身上所取的肋骨造成一個女人，領她到那人跟前。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","那人說： 這是我骨中的骨， 肉中的肉， 可以稱她為「女人」， 因為她是從「男人」身上取出來的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","因此，人要離開父母，與妻子連合，二人成為一體。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","當時夫妻二人赤身露體，並不羞恥。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","耶和華上帝所造的，惟有蛇比田野一切的活物更狡猾。蛇對女人說：「上帝豈是真說不許你們吃園中所有樹上的果子嗎？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","女人對蛇說：「園中樹上的果子，我們可以吃， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","惟有園當中那棵樹上的果子，上帝曾說：『你們不可吃，也不可摸，免得你們死。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","蛇對女人說：「你們不一定死； ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","因為上帝知道，你們吃的日子眼睛就明亮了，你們便如上帝能知道善惡。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","於是女人見那棵樹的果子好作食物，也悅人的眼目，且是可喜愛的，能使人有智慧，就摘下果子來吃了，又給她丈夫，她丈夫也吃了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","他們二人的眼睛就明亮了，才知道自己是赤身露體，便拿無花果樹的葉子為自己編做裙子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","天起了涼風，耶和華上帝在園中行走。那人和他妻子聽見上帝的聲音，就藏在園裏的樹木中，躲避耶和華上帝的面。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","耶和華上帝呼喚那人，對他說：「你在哪裏？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","他說：「我在園中聽見你的聲音，我就害怕；因為我赤身露體，我便藏了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","耶和華說：「誰告訴你赤身露體呢？莫非你吃了我吩咐你不可吃的那樹上的果子嗎？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","那人說：「你所賜給我、與我同居的女人，她把那樹上的果子給我，我就吃了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","耶和華上帝對女人說：「你做的是甚麼事呢？」女人說：「那蛇引誘我，我就吃了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","耶和華上帝對蛇說： 你既做了這事，就必受咒詛， 比一切的牲畜野獸更甚； 你必用肚子行走， 終身吃土。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","我又要叫你和女人彼此為仇； 你的後裔和女人的後裔也彼此為仇。 女人的後裔要傷你的頭； 你要傷他的腳跟。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","又對女人說： 我必多多加增你懷胎的苦楚； 你生產兒女必多受苦楚。 你必戀慕你丈夫； 你丈夫必管轄你。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","又對亞當說： 你既聽從妻子的話， 吃了我所吩咐你不可吃的那樹上的果子， 地必為你的緣故受咒詛； 你必終身勞苦才能從地裏得吃的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","地必給你長出荊棘和蒺藜來； 你也要吃田間的菜蔬。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","你必汗流滿面才得糊口， 直到你歸了土， 因為你是從土而出的。 你本是塵土，仍要歸於塵土。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","亞當給他妻子起名叫夏娃，因為她是眾生之母。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","耶和華上帝為亞當和他妻子用皮子做衣服給他們穿。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","耶和華上帝說：「那人已經與我們相似，能知道善惡；現在恐怕他伸手又摘生命樹的果子吃，就永遠活着。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","耶和華上帝便打發他出伊甸園去，耕種他所自出之土。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","於是把他趕出去了；又在伊甸園的東邊安設基路伯和四面轉動發火焰的劍，要把守生命樹的道路。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","有一日，那人和他妻子夏娃同房，夏娃就懷孕，生了該隱，便說：「耶和華使我得了一個男子。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","又生了該隱的兄弟亞伯。亞伯是牧羊的；該隱是種地的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","有一日，該隱拿地裏的出產為供物獻給耶和華； ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","亞伯也將他羊群中頭生的和羊的脂油獻上。耶和華看中了亞伯和他的供物， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","只是看不中該隱和他的供物。該隱就大大地發怒，變了臉色。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","耶和華對該隱說：「你為甚麼發怒呢？你為甚麼變了臉色呢？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","你若行得好，豈不蒙悅納？你若行得不好，罪就伏在門前。它必戀慕你，你卻要制伏它。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","該隱與他兄弟亞伯說話；二人正在田間。該隱起來打他兄弟亞伯，把他殺了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","耶和華對該隱說：「你兄弟亞伯在哪裏？」他說：「我不知道！我豈是看守我兄弟的嗎？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","耶和華說：「你做了甚麼事呢？你兄弟的血有聲音從地裏向我哀告。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","地開了口，從你手裏接受你兄弟的血。現在你必從這地受咒詛。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","你種地，地不再給你效力；你必流離飄蕩在地上。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","該隱對耶和華說：「我的刑罰太重，過於我所能當的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","你如今趕逐我離開這地，以致不見你面；我必流離飄蕩在地上，凡遇見我的必殺我。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","耶和華對他說：「凡殺該隱的，必遭報七倍。」耶和華就給該隱立一個記號，免得人遇見他就殺他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","於是該隱離開耶和華的面，去住在伊甸東邊挪得之地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","該隱與妻子同房，他妻子就懷孕，生了以諾。該隱建造了一座城，就按着他兒子的名將那城叫做以諾。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","以諾生以拿；以拿生米戶雅利；米戶雅利生瑪土撒利；瑪土撒利生拉麥。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","拉麥娶了兩個妻：一個名叫亞大，一個名叫洗拉。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","亞大生雅八；雅八就是住帳棚、牧養牲畜之人的祖師。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","雅八的兄弟名叫猶八；他是一切彈琴吹簫之人的祖師。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","洗拉又生了土八‧該隱；他是打造各樣銅鐵利器的。土八‧該隱的妹子是拿瑪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","拉麥對他兩個妻子說： 亞大、洗拉，聽我的聲音； 拉麥的妻子，細聽我的話語： 壯年人傷我，我把他殺了； 少年人損我，我把他害了 。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","若殺該隱，遭報七倍， 殺拉麥，必遭報七十七倍。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","亞當又與妻子同房，她就生了一個兒子，起名叫塞特，意思說：「上帝另給我立了一個兒子代替亞伯，因為該隱殺了他。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","塞特也生了一個兒子，起名叫以挪士。那時候，人才求告耶和華的名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","亞當的後代記在下面。（當上帝造人的日子，是照着自己的樣式造的， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","並且造男造女。在他們被造的日子，上帝賜福給他們，稱他們為「人」。） ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","亞當活到一百三十歲，生了一個兒子，形像樣式和自己相似，就給他起名叫塞特。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","亞當生塞特之後，又在世八百年，並且生兒養女。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","亞當共活了九百三十歲就死了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","塞特活到一百零五歲，生了以挪士。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","塞特生以挪士之後，又活了八百零七年，並且生兒養女。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","塞特共活了九百一十二歲就死了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","以挪士活到九十歲，生了該南。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","以挪士生該南之後，又活了八百一十五年，並且生兒養女。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","以挪士共活了九百零五歲就死了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","該南活到七十歲，生了瑪勒列。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","該南生瑪勒列之後，又活了八百四十年，並且生兒養女。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","該南共活了九百一十歲就死了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","瑪勒列活到六十五歲，生了雅列。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","瑪勒列生雅列之後，又活了八百三十年，並且生兒養女。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","瑪勒列共活了八百九十五歲就死了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","雅列活到一百六十二歲，生了以諾。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","雅列生以諾之後，又活了八百年，並且生兒養女。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","雅列共活了九百六十二歲就死了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","以諾活到六十五歲，生了瑪土撒拉。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","以諾生瑪土撒拉之後，與上帝同行三百年，並且生兒養女。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","以諾共活了三百六十五歲。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","以諾與上帝同行，上帝將他取去，他就不在世了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","瑪土撒拉活到一百八十七歲，生了拉麥。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","瑪土撒拉生拉麥之後，又活了七百八十二年，並且生兒養女。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","瑪土撒拉共活了九百六十九歲就死了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","拉麥活到一百八十二歲，生了一個兒子， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","給他起名叫挪亞，說：「這個兒子必為我們的操作和手中的勞苦安慰我們；這操作勞苦是因為耶和華咒詛地。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","拉麥生挪亞之後，又活了五百九十五年，並且生兒養女。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","拉麥共活了七百七十七歲就死了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","挪亞五百歲生了閃、含、雅弗。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","當人在世上多起來、又生女兒的時候， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","上帝的兒子們看見人的女子美貌，就隨意挑選，娶來為妻。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","耶和華說：「人既屬乎血氣，我的靈就不永遠住在他裏面；然而他的日子還可到一百二十年。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","那時候有偉人在地上，後來上帝的兒子們和人的女子們交合生子；那就是上古英武有名的人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","耶和華見人在地上罪惡很大，終日所思想的盡都是惡， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","耶和華就後悔造人在地上，心中憂傷。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","耶和華說：「我要將所造的人和走獸，並昆蟲，以及空中的飛鳥，都從地上除滅，因為我造他們後悔了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","惟有挪亞在耶和華眼前蒙恩。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","挪亞的後代記在下面。挪亞是個義人，在當時的世代是個完全人。挪亞與上帝同行。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","挪亞生了三個兒子，就是閃、含、雅弗。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","世界在上帝面前敗壞，地上滿了強暴。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","上帝觀看世界，見是敗壞了；凡有血氣的人在地上都敗壞了行為。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","上帝就對挪亞說：「凡有血氣的人，他的盡頭已經來到我面前；因為地上滿了他們的強暴，我要把他們和地一併毀滅。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","你要用歌斐木造一隻方舟，分一間一間地造，裏外抹上松香。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","方舟的造法乃是這樣：要長三百肘，寬五十肘，高三十肘。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","方舟上邊要留透光處，高一肘。方舟的門要開在旁邊。方舟要分上、中、下三層。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","看哪，我要使洪水氾濫在地上，毀滅天下；凡地上有血肉、有氣息的活物，無一不死。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","我卻要與你立約；你同你的妻，與兒子兒婦，都要進入方舟。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","凡有血肉的活物，每樣兩個，一公一母，你要帶進方舟，好在你那裏保全生命。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","飛鳥各從其類，牲畜各從其類，地上的昆蟲各從其類，每樣兩個，要到你那裏，好保全生命。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","你要拿各樣食物積蓄起來，好作你和牠們的食物。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","挪亞就這樣行。凡上帝所吩咐的，他都照樣行了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","耶和華對挪亞說：「你和你的全家都要進入方舟；因為在這世代中，我見你在我面前是義人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","凡潔淨的畜類，你要帶七公七母；不潔淨的畜類，你要帶一公一母； ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","空中的飛鳥也要帶七公七母，可以留種，活在全地上； ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","因為再過七天，我要降雨在地上四十晝夜，把我所造的各種活物都從地上除滅。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","挪亞就遵着耶和華所吩咐的行了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","當洪水氾濫在地上的時候，挪亞整六百歲。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","挪亞就同他的妻和兒子兒婦都進入方舟，躲避洪水。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","潔淨的畜類和不潔淨的畜類，飛鳥並地上一切的昆蟲， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","都是一對一對地，有公有母，到挪亞那裏進入方舟，正如上帝所吩咐挪亞的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","過了那七天，洪水氾濫在地上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","當挪亞六百歲，二月十七日那一天，大淵的泉源都裂開了，天上的窗戶也敞開了， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","四十晝夜降大雨在地上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","正當那日，挪亞和他三個兒子閃、含、雅弗，並挪亞的妻子和三個兒婦，都進入方舟。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","他們和百獸，各從其類，一切牲畜，各從其類，爬在地上的昆蟲，各從其類，一切禽鳥，各從其類，都進入方舟。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","凡有血肉、有氣息的活物，都一對一對地到挪亞那裏，進入方舟。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","凡有血肉進入方舟的，都是有公有母，正如上帝所吩咐挪亞的。耶和華就把他關在方舟裏頭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","洪水氾濫在地上四十天，水往上長，把方舟從地上漂起。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","水勢浩大，在地上大大地往上長，方舟在水面上漂來漂去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","水勢在地上極其浩大，天下的高山都淹沒了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","水勢比山高過十五肘，山嶺都淹沒了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","凡在地上有血肉的動物，就是飛鳥、牲畜、走獸，和爬在地上的昆蟲，以及所有的人，都死了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","凡在旱地上、鼻孔有氣息的生靈都死了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","凡地上各類的活物，連人帶牲畜、昆蟲，以及空中的飛鳥，都從地上除滅了，只留下挪亞和那些與他同在方舟裏的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","水勢浩大，在地上共一百五十天。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","上帝記念挪亞和挪亞方舟裏的一切走獸牲畜。上帝叫風吹地，水勢漸落。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","淵源和天上的窗戶都閉塞了，天上的大雨也止住了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","水從地上漸退。過了一百五十天，水就漸消。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","七月十七日，方舟停在亞拉臘山上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","水又漸消，到十月初一日，山頂都現出來了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","過了四十天，挪亞開了方舟的窗戶， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","放出一隻烏鴉去；那烏鴉飛來飛去，直到地上的水都乾了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","他又放出一隻鴿子去，要看看水從地上退了沒有。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","但遍地上都是水，鴿子找不着落腳之地，就回到方舟挪亞那裏，挪亞伸手把鴿子接進方舟來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","他又等了七天，再把鴿子從方舟放出去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","到了晚上，鴿子回到他那裏，嘴裏叼着一個新擰下來的橄欖葉子，挪亞就知道地上的水退了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","他又等了七天，放出鴿子去，鴿子就不再回來了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","到挪亞六百零一歲，正月初一日，地上的水都乾了。挪亞撤去方舟的蓋觀看，便見地面上乾了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","到了二月二十七日，地就都乾了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","上帝對挪亞說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","「你和你的妻子、兒子、兒婦都可以出方舟。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","在你那裏凡有血肉的活物，就是飛鳥、牲畜，和一切爬在地上的昆蟲，都要帶出來，叫牠在地上多多滋生，大大興旺。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","於是挪亞和他的妻子、兒子、兒婦都出來了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","一切走獸、昆蟲、飛鳥，和地上所有的動物，各從其類，也都出了方舟。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","挪亞為耶和華築了一座壇，拿各類潔淨的牲畜、飛鳥獻在壇上為燔祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","耶和華聞那馨香之氣，就心裏說：「我不再因人的緣故咒詛地（人從小時心裏懷着惡念），也不再按着我才行的滅各種的活物了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","地還存留的時候，稼穡、寒暑、冬夏、晝夜就永不停息了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","上帝賜福給挪亞和他的兒子，對他們說：「你們要生養眾多，遍滿了地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","凡地上的走獸和空中的飛鳥都必驚恐，懼怕你們，連地上一切的昆蟲並海裏一切的魚都交付你們的手。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","凡活着的動物都可以作你們的食物。這一切我都賜給你們，如同菜蔬一樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","惟獨肉帶着血，那就是牠的生命，你們不可吃。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","流你們血、害你們命的，無論是獸是人，我必討他的罪，就是向各人的弟兄也是如此。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","凡流人血的，他的血也必被人所流，因為上帝造人是照自己的形像造的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","你們要生養眾多，在地上昌盛繁茂。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","上帝曉諭挪亞和他的兒子說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","「我與你們和你們的後裔立約， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","並與你們這裏的一切活物－就是飛鳥、牲畜、走獸，凡從方舟裏出來的活物－立約。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","我與你們立約，凡有血肉的，不再被洪水滅絕，也不再有洪水毀壞地了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","上帝說：「我與你們並你們這裏的各樣活物所立的永約是有記號的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","我把虹放在雲彩中，這就可作我與地立約的記號了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","我使雲彩蓋地的時候，必有虹現在雲彩中， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","我便記念我與你們和各樣有血肉的活物所立的約，水就再不氾濫、毀壞一切有血肉的物了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","虹必現在雲彩中，我看見，就要記念我與地上各樣有血肉的活物所立的永約。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","上帝對挪亞說：「這就是我與地上一切有血肉之物立約的記號了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","出方舟挪亞的兒子就是閃、含、雅弗。含是迦南的父親。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","這是挪亞的三個兒子，他們的後裔分散在全地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","挪亞作起農夫來，栽了一個葡萄園。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","他喝了園中的酒便醉了，在帳棚裏赤着身子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","迦南的父親含看見他父親赤身，就到外邊告訴他兩個弟兄。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","於是閃和雅弗拿件衣服搭在肩上，倒退着進去，給他父親蓋上；他們背着臉就看不見父親的赤身。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","挪亞醒了酒，知道小兒子向他所做的事， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","就說： 迦南當受咒詛， 必給他弟兄作奴僕的奴僕； ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","又說： 耶和華－閃的上帝是應當稱頌的！ 願迦南作閃的奴僕。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","願上帝使雅弗擴張， 使他住在閃的帳棚裏； 又願迦南作他的奴僕。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","洪水以後，挪亞又活了三百五十年。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","挪亞共活了九百五十歲就死了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","挪亞的兒子閃、含、雅弗的後代記在下面。洪水以後，他們都生了兒子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","雅弗的兒子是歌篾、瑪各、瑪代、雅完、土巴、米設、提拉。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","歌篾的兒子是亞實基拿、利法、陀迦瑪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","雅完的兒子是以利沙、他施、基提、多單。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","這些人的後裔將各國的地土、海島分開居住，各隨各的方言、宗族立國。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","含的兒子是古實、麥西、弗、迦南。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","古實的兒子是西巴、哈腓拉、撒弗他、拉瑪、撒弗提迦。拉瑪的兒子是示巴、底但。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","古實又生寧錄，他為世上英雄之首。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","他在耶和華面前是個英勇的獵戶，所以俗語說：「像寧錄在耶和華面前是個英勇的獵戶。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","他國的起頭是巴別、以力、亞甲、甲尼，都在示拿地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","他從那地出來往亞述去，建造尼尼微、利河伯、迦拉， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","和尼尼微、迦拉中間的利鮮，這就是那大城。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","麥西生路低人、亞拿米人、利哈比人、拿弗土希人、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","帕斯魯細人、迦斯路希人、迦斐託人；從迦斐託出來的有非利士人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","迦南生長子西頓，又生赫 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","和耶布斯人、亞摩利人、革迦撒人、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","希未人、亞基人、西尼人、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","亞瓦底人、洗瑪利人、哈馬人，後來迦南的諸族分散了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","迦南的境界是從西頓向基拉耳的路上，直到迦薩，又向所多瑪、蛾摩拉、押瑪、洗扁的路上，直到拉沙。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","這就是含的後裔，各隨他們的宗族、方言，所住的地土、邦國。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","雅弗的哥哥閃，是希伯子孫之祖，他也生了兒子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","閃的兒子是以攔、亞述、亞法撒、路德、亞蘭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","亞蘭的兒子是烏斯、戶勒、基帖、瑪施。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","亞法撒生沙拉；沙拉生希伯。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","希伯生了兩個兒子，一個名叫法勒，因為那時人就分地居住；法勒的兄弟名叫約坍。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","約坍生亞摩答、沙列、哈薩瑪非、耶拉、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","哈多蘭、烏薩、德拉、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","俄巴路、亞比瑪利、示巴、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","阿斐、哈腓拉、約巴，這都是約坍的兒子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","他們所住的地方是從米沙直到西發東邊的山。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","這就是閃的子孫，各隨他們的宗族、方言，所住的地土、邦國。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","這些都是挪亞三個兒子的宗族，各隨他們的支派立國。洪水以後，他們在地上分為邦國。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","那時，天下人的口音、言語都是一樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","他們往東邊遷移的時候，在示拿地遇見一片平原，就住在那裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","他們彼此商量說：「來吧！我們要做磚，把磚燒透了。」他們就拿磚當石頭，又拿石漆當灰泥。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","他們說：「來吧！我們要建造一座城和一座塔，塔頂通天，為要傳揚我們的名，免得我們分散在全地上。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","耶和華降臨，要看看世人所建造的城和塔。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","耶和華說：「看哪，他們成為一樣的人民，都是一樣的言語，如今既做起這事來，以後他們所要做的事就沒有不成就的了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","我們下去，在那裏變亂他們的口音，使他們的言語彼此不通。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","於是耶和華使他們從那裏分散在全地上；他們就停工，不造那城了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","因為耶和華在那裏變亂天下人的言語，使眾人分散在全地上，所以那城名叫巴別。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","閃的後代記在下面。洪水以後二年，閃一百歲生了亞法撒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","閃生亞法撒之後又活了五百年，並且生兒養女。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","亞法撒活到三十五歲，生了沙拉。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","亞法撒生沙拉之後又活了四百零三年，並且生兒養女。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","沙拉活到三十歲，生了希伯。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","沙拉生希伯之後又活了四百零三年，並且生兒養女。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","希伯活到三十四歲，生了法勒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","希伯生法勒之後又活了四百三十年，並且生兒養女。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","法勒活到三十歲，生了拉吳。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","法勒生拉吳之後又活了二百零九年，並且生兒養女。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","拉吳活到三十二歲，生了西鹿。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","拉吳生西鹿之後又活了二百零七年，並且生兒養女。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","西鹿活到三十歲，生了拿鶴。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","西鹿生拿鶴之後又活了二百年，並且生兒養女。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","拿鶴活到二十九歲，生了他拉。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","拿鶴生他拉之後又活了一百一十九年，並且生兒養女。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","他拉活到七十歲，生了亞伯蘭、拿鶴、哈蘭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","他拉的後代記在下面。他拉生亞伯蘭、拿鶴、哈蘭；哈蘭生羅得。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","哈蘭死在他的本地迦勒底的吾珥，在他父親他拉之先。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","亞伯蘭、拿鶴各娶了妻：亞伯蘭的妻子名叫撒萊；拿鶴的妻子名叫密迦，是哈蘭的女兒；哈蘭是密迦和亦迦的父親。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","撒萊不生育，沒有孩子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","他拉帶着他兒子亞伯蘭和他孫子哈蘭的兒子羅得，並他兒婦亞伯蘭的妻子撒萊，出了迦勒底的吾珥，要往迦南地去；他們走到哈蘭，就住在那裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","他拉共活了二百零五歲，就死在哈蘭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","耶和華對亞伯蘭說：「你要離開本地、本族、父家，往我所要指示你的地去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","我必叫你成為大國。我必賜福給你，叫你的名為大；你也要叫別人得福。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","為你祝福的，我必賜福與他；那咒詛你的，我必咒詛他。地上的萬族都要因你得福。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","亞伯蘭就照着耶和華的吩咐去了；羅得也和他同去。亞伯蘭出哈蘭的時候年七十五歲。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","亞伯蘭將他妻子撒萊和姪兒羅得，連他們在哈蘭所積蓄的財物、所得的人口，都帶往迦南地去。他們就到了迦南地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","亞伯蘭經過那地，到了示劍地方、摩利橡樹那裏。那時迦南人住在那地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","耶和華向亞伯蘭顯現，說：「我要把這地賜給你的後裔。」亞伯蘭就在那裏為向他顯現的耶和華築了一座壇。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","從那裏他又遷到伯特利東邊的山，支搭帳棚；西邊是伯特利，東邊是艾。他在那裏又為耶和華築了一座壇，求告耶和華的名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","後來亞伯蘭又漸漸遷往南地去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","那地遭遇饑荒。因饑荒甚大，亞伯蘭就下埃及去，要在那裏暫居。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","將近埃及，就對他妻子撒萊說：「我知道你是容貌俊美的婦人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","埃及人看見你必說：『這是他的妻子』，他們就要殺我，卻叫你存活。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","求你說，你是我的妹子，使我因你得平安，我的命也因你存活。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","及至亞伯蘭到了埃及，埃及人看見那婦人極其美貌。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","法老的臣宰看見了她，就在法老面前誇獎她。那婦人就被帶進法老的宮去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","法老因這婦人就厚待亞伯蘭，亞伯蘭得了許多牛、羊、駱駝、公驢、母驢、僕婢。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","耶和華因亞伯蘭妻子撒萊的緣故，降大災與法老和他的全家。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","法老就召了亞伯蘭來，說：「你這向我做的是甚麼事呢？為甚麼沒有告訴我她是你的妻子？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","為甚麼說她是你的妹子，以致我把她取來要作我的妻子？現在你的妻子在這裏，可以帶她走吧。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","於是法老吩咐人將亞伯蘭和他妻子，並他所有的都送走了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","亞伯蘭帶着他的妻子與羅得，並一切所有的，都從埃及上南地去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","亞伯蘭的金、銀、牲畜極多。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","他從南地漸漸往伯特利去，到了伯特利和艾的中間，就是從前支搭帳棚的地方， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","也是他起先築壇的地方；他又在那裏求告耶和華的名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","與亞伯蘭同行的羅得也有牛群、羊群、帳棚。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","那地容不下他們；因為他們的財物甚多，使他們不能同居。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","當時，迦南人與比利洗人在那地居住。亞伯蘭的牧人和羅得的牧人相爭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","亞伯蘭就對羅得說：「你我不可相爭，你的牧人和我的牧人也不可相爭，因為我們是骨肉。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","遍地不都在你眼前嗎？請你離開我：你向左，我就向右；你向右，我就向左。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","羅得舉目看見約旦河的全平原，直到瑣珥，都是滋潤的，那地在耶和華未滅所多瑪、蛾摩拉以先如同耶和華的園子，也像埃及地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","於是羅得選擇約旦河的全平原，往東遷移；他們就彼此分離了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","亞伯蘭住在迦南地，羅得住在平原的城邑，漸漸挪移帳棚，直到所多瑪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","所多瑪人在耶和華面前罪大惡極。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","羅得離別亞伯蘭以後，耶和華對亞伯蘭說：「從你所在的地方，你舉目向東西南北觀看； ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","凡你所看見的一切地，我都要賜給你和你的後裔，直到永遠。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","我也要使你的後裔如同地上的塵沙那樣多，人若能數算地上的塵沙才能數算你的後裔。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","你起來，縱橫走遍這地，因為我必把這地賜給你。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","亞伯蘭就搬了帳棚，來到希伯崙幔利的橡樹那裏居住，在那裏為耶和華築了一座壇。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","當暗拉非作示拿王，亞略作以拉撒王，基大老瑪作以攔王，提達作戈印王的時候， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","他們都攻打所多瑪王比拉、蛾摩拉王比沙、押瑪王示納、洗扁王善以別，和比拉王；比拉就是瑣珥。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","這五王都在西訂谷會合；西訂谷就是鹽海。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","他們已經事奉基大老瑪十二年，到十三年就背叛了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","十四年，基大老瑪和同盟的王都來在亞特律‧加寧，殺敗了利乏音人，在哈麥殺敗了蘇西人，在沙微‧基列亭殺敗了以米人， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","在何利人的西珥山殺敗了何利人，一直殺到靠近曠野的伊勒‧巴蘭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","他們回到安‧密巴，就是加低斯，殺敗了亞瑪力全地的人，以及住在哈洗遜‧他瑪的亞摩利人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","於是所多瑪王、蛾摩拉王、押瑪王、洗扁王，和比拉王（比拉就是瑣珥）都出來，在西訂谷擺陣，與他們交戰， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","就是與以攔王基大老瑪、戈印王提達、示拿王暗拉非、以拉撒王亞略交戰；乃是四王與五王交戰。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","西訂谷有許多石漆坑。所多瑪王和蛾摩拉王逃跑，有掉在坑裏的，其餘的人都往山上逃跑。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","四王就把所多瑪和蛾摩拉所有的財物，並一切的糧食都擄掠去了； ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","又把亞伯蘭的姪兒羅得和羅得的財物擄掠去了。當時羅得正住在所多瑪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","有一個逃出來的人告訴希伯來人亞伯蘭；亞伯蘭正住在亞摩利人幔利的橡樹那裏。幔利和以實各並亞乃都是弟兄，曾與亞伯蘭聯盟。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","亞伯蘭聽見他姪兒被擄去，就率領他家裏生養的精練壯丁三百一十八人，直追到但， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","便在夜間，自己同僕人分隊殺敗敵人，又追到大馬士革左邊的何把， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","將被擄掠的一切財物奪回來，連他姪兒羅得和他的財物，以及婦女、人民也都奪回來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","亞伯蘭殺敗基大老瑪和與他同盟的王回來的時候，所多瑪王出來，在沙微谷迎接他；沙微谷就是王谷。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","又有撒冷王麥基洗德帶着餅和酒出來迎接；他是至高上帝的祭司。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","他為亞伯蘭祝福，說：「願天地的主、至高的上帝賜福與亞伯蘭！ ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","至高的上帝把敵人交在你手裏，是應當稱頌的！」亞伯蘭就把所得的拿出十分之一來，給麥基洗德。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","所多瑪王對亞伯蘭說：「你把人口給我，財物你自己拿去吧！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","亞伯蘭對所多瑪王說：「我已經向天地的主－至高的上帝耶和華起誓： ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","凡是你的東西，就是一根線、一根鞋帶，我都不拿，免得你說：『我使亞伯蘭富足！』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","只有僕人所吃的，並與我同行的亞乃、以實各、幔利所應得的分，可以任憑他們拿去。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","這事以後，耶和華在異象中有話對亞伯蘭說：「亞伯蘭，你不要懼怕！我是你的盾牌，必大大地賞賜你。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","亞伯蘭說：「主耶和華啊，我既無子，你還賜我甚麼呢？並且要承受我家業的是大馬士革人以利以謝。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","亞伯蘭又說：「你沒有給我兒子；那生在我家中的人就是我的後嗣。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","耶和華又有話對他說：「這人必不成為你的後嗣；你本身所生的才成為你的後嗣。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","於是領他走到外邊，說：「你向天觀看，數算眾星，能數得過來嗎？」又對他說：「你的後裔將要如此。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","亞伯蘭信耶和華，耶和華就以此為他的義。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","耶和華又對他說：「我是耶和華，曾領你出了迦勒底的吾珥，為要將這地賜你為業。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","亞伯蘭說：「主耶和華啊，我怎能知道必得這地為業呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","他說：「你為我取一隻三年的母牛，一隻三年的母山羊，一隻三年的公綿羊，一隻斑鳩，一隻雛鴿。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","亞伯蘭就取了這些來，每樣劈開，分成兩半，一半對着一半地擺列，只有鳥沒有劈開。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","有鷙鳥下來，落在那死畜的肉上，亞伯蘭就把牠嚇飛了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","日頭正落的時候，亞伯蘭沉沉地睡了；忽然有驚人的大黑暗落在他身上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","耶和華對亞伯蘭說：「你要的確知道，你的後裔必寄居別人的地，又服事那地的人；那地的人要苦待他們四百年。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","並且他們所要服事的那國，我要懲罰，後來他們必帶着許多財物從那裏出來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","但你要享大壽數，平平安安地歸到你列祖那裏，被人埋葬。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","到了第四代，他們必回到此地，因為亞摩利人的罪孽還沒有滿盈。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","日落天黑，不料有冒煙的爐並燒着的火把從那些肉塊中經過。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","當那日，耶和華與亞伯蘭立約，說：「我已賜給你的後裔，從埃及河直到幼發拉底大河之地， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","就是基尼人、基尼洗人、甲摩尼人、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","赫人、比利洗人、利乏音人、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","亞摩利人、迦南人、革迦撒人、耶布斯人之地。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","亞伯蘭的妻子撒萊不給他生兒女。撒萊有一個使女，名叫夏甲，是埃及人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","撒萊對亞伯蘭說：「耶和華使我不能生育。求你和我的使女同房，或者我可以因她得孩子。」亞伯蘭聽從了撒萊的話。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","於是亞伯蘭的妻子撒萊將使女埃及人夏甲給了丈夫為妾；那時亞伯蘭在迦南已經住了十年。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","亞伯蘭與夏甲同房，夏甲就懷了孕；她見自己有孕，就小看她的主母。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","撒萊對亞伯蘭說：「我因你受屈。我將我的使女放在你懷中，她見自己有了孕，就小看我。願耶和華在你我中間判斷。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","亞伯蘭對撒萊說：「使女在你手下，你可以隨意待她。」撒萊苦待她，她就從撒萊面前逃走了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","耶和華的使者在曠野書珥路上的水泉旁遇見她， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","對她說：「撒萊的使女夏甲，你從哪裏來？要往哪裏去？」夏甲說：「我從我的主母撒萊面前逃出來。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","耶和華的使者對她說：「你回到你主母那裏，服在她手下」； ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","又說：「我必使你的後裔極其繁多，甚至不可勝數」； ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","並說：「你如今懷孕要生一個兒子，可以給他起名叫以實瑪利，因為耶和華聽見了你的苦情。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","他為人必像野驢。他的手要攻打人，人的手也要攻打他；他必住在眾弟兄的東邊。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","夏甲就稱那對她說話的耶和華為「看顧人的上帝」。因而說：「在這裏我也看見那看顧我的嗎？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","所以這井名叫庇耳‧拉海‧萊。這井正在加低斯和巴列中間。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","後來夏甲給亞伯蘭生了一個兒子；亞伯蘭給他起名叫以實瑪利。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","夏甲給亞伯蘭生以實瑪利的時候，亞伯蘭年八十六歲。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","亞伯蘭年九十九歲的時候，耶和華向他顯現，對他說：「我是全能的上帝。你當在我面前作完全人， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","我就與你立約，使你的後裔極其繁多。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","亞伯蘭俯伏在地；上帝又對他說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","「我與你立約：你要作多國的父。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","從此以後，你的名不再叫亞伯蘭，要叫亞伯拉罕，因為我已立你作多國的父。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","我必使你的後裔極其繁多；國度從你而立，君王從你而出。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","我要與你並你世世代代的後裔堅立我的約，作永遠的約，是要作你和你後裔的上帝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","我要將你現在寄居的地，就是迦南全地，賜給你和你的後裔永遠為業，我也必作他們的上帝。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","上帝又對亞伯拉罕說：「你和你的後裔必世世代代遵守我的約。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","你們所有的男子都要受割禮；這就是我與你並你的後裔所立的約，是你們所當遵守的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","你們都要受割禮；這是我與你們立約的證據。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","你們世世代代的男子，無論是家裏生的，是在你後裔之外用銀子從外人買的，生下來第八日，都要受割禮。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","你家裏生的和你用銀子買的，都必須受割禮。這樣，我的約就立在你們肉體上作永遠的約。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","但不受割禮的男子必從民中剪除，因他背了我的約。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","上帝又對亞伯拉罕說：「你的妻子撒萊不可再叫撒萊，她的名要叫撒拉。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","我必賜福給她，也要使你從她得一個兒子。我要賜福給她，她也要作多國之母；必有百姓的君王從她而出。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","亞伯拉罕就俯伏在地喜笑，心裏說：「一百歲的人還能得孩子嗎？撒拉已經九十歲了，還能生養嗎？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","亞伯拉罕對上帝說：「但願以實瑪利活在你面前。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","上帝說：「不然，你妻子撒拉要給你生一個兒子，你要給他起名叫以撒。我要與他堅定所立的約，作他後裔永遠的約。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","至於以實瑪利，我也應允你：我必賜福給他，使他昌盛，極其繁多。他必生十二個族長；我也要使他成為大國。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","到明年這時節，撒拉必給你生以撒，我要與他堅定所立的約。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","上帝和亞伯拉罕說完了話，就離開他上升去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","正當那日，亞伯拉罕遵着上帝的命，給他的兒子以實瑪利和家裏的一切男子，無論是在家裏生的，是用銀子買的，都行了割禮。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","亞伯拉罕受割禮的時候年九十九歲。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","他兒子以實瑪利受割禮的時候年十三歲。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","正當那日，亞伯拉罕和他兒子以實瑪利一同受了割禮。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","家裏所有的人，無論是在家裏生的，是用銀子從外人買的，也都一同受了割禮。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","耶和華在幔利橡樹那裏向亞伯拉罕顯現出來。那時正熱，亞伯拉罕坐在帳棚門口， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","舉目觀看，見有三個人在對面站着。他一見，就從帳棚門口跑去迎接他們，俯伏在地， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","說：「我主，我若在你眼前蒙恩，求你不要離開僕人往前去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","容我拿點水來，你們洗洗腳，在樹下歇息歇息。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","我再拿一點餅來，你們可以加添心力，然後往前去。你們既到僕人這裏來，理當如此。」他們說：「就照你說的行吧。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","亞伯拉罕急忙進帳棚見撒拉，說：「你速速拿三細亞細麵調和做餅。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","亞伯拉罕又跑到牛群裏，牽了一隻又嫩又好的牛犢來，交給僕人，僕人急忙預備好了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","亞伯拉罕又取了奶油和奶，並預備好的牛犢來，擺在他們面前，自己在樹下站在旁邊，他們就吃了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","他們問亞伯拉罕說：「你妻子撒拉在哪裏？」他說：「在帳棚裏。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","三人中有一位說：「到明年這時候，我必要回到你這裏；你的妻子撒拉必生一個兒子。」撒拉在那人後邊的帳棚門口也聽見了這話。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","亞伯拉罕和撒拉年紀老邁，撒拉的月經已斷絕了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","撒拉心裏暗笑，說：「我既已衰敗，我主也老邁，豈能有這喜事呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","耶和華對亞伯拉罕說：「撒拉為甚麼暗笑，說：『我既已年老，果真能生養嗎？』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","耶和華豈有難成的事嗎？到了日期，明年這時候，我必回到你這裏，撒拉必生一個兒子。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","撒拉就害怕，不承認，說：「我沒有笑。」那位說：「不然，你實在笑了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","三人就從那裏起行，向所多瑪觀看，亞伯拉罕也與他們同行，要送他們一程。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","耶和華說：「我所要做的事豈可瞞着亞伯拉罕呢？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","亞伯拉罕必要成為強大的國；地上的萬國都必因他得福。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","我眷顧他，為要叫他吩咐他的眾子和他的眷屬遵守我的道，秉公行義，使我所應許亞伯拉罕的話都成就了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","耶和華說：「所多瑪和蛾摩拉的罪惡甚重，聲聞於我。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","我現在要下去，察看他們所行的，果然盡像那達到我耳中的聲音一樣嗎？若是不然，我也必知道。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","二人轉身離開那裏，向所多瑪去；但亞伯拉罕仍舊站在耶和華面前。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","亞伯拉罕近前來，說：「無論善惡，你都要剿滅嗎？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","假若那城裏有五十個義人，你還剿滅那地方嗎？不為城裏這五十個義人饒恕其中的人嗎？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","將義人與惡人同殺，將義人與惡人一樣看待，這斷不是你所行的。審判全地的主豈不行公義嗎？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","耶和華說：「我若在所多瑪城裏見有五十個義人，我就為他們的緣故饒恕那地方的眾人。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","亞伯拉罕說：「我雖然是灰塵，還敢對主說話。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","假若這五十個義人短了五個，你就因為短了五個毀滅全城嗎？」他說：「我在那裏若見有四十五個，也不毀滅那城。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","亞伯拉罕又對他說：「假若在那裏見有四十個怎麼樣呢？」他說：「為這四十個的緣故，我也不做這事。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","亞伯拉罕說：「求主不要動怒，容我說，假若在那裏見有三十個怎麼樣呢？」他說：「我在那裏若見有三十個，我也不做這事。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","亞伯拉罕說：「我還敢對主說話，假若在那裏見有二十個怎麼樣呢？」他說：「為這二十個的緣故，我也不毀滅那城。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","亞伯拉罕說：「求主不要動怒，我再說這一次，假若在那裏見有十個呢？」他說：「為這十個的緣故，我也不毀滅那城。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","耶和華與亞伯拉罕說完了話就走了；亞伯拉罕也回到自己的地方去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","那兩個天使晚上到了所多瑪；羅得正坐在所多瑪城門口，看見他們，就起來迎接，臉伏於地下拜， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","說：「我主啊，請你們到僕人家裏洗洗腳，住一夜，清早起來再走。」他們說：「不！我們要在街上過夜。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","羅得切切地請他們，他們這才進去，到他屋裏。羅得為他們預備筵席，烤無酵餅，他們就吃了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","他們還沒有躺下，所多瑪城裏各處的人，連老帶少，都來圍住那房子， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","呼叫羅得說：「今日晚上到你這裏來的人在哪裏呢？把他們帶出來，任我們所為。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","羅得出來，把門關上，到眾人那裏， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","說：「眾弟兄，請你們不要做這惡事。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","我有兩個女兒，還是處女，容我領出來，任憑你們的心願而行；只是這兩個人既然到我舍下，不要向他們做甚麼。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","眾人說：「退去吧！」又說：「這個人來寄居，還想要作官哪！現在我們要害你比害他們更甚。」眾人就向前擁擠羅得，要攻破房門。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","只是那二人伸出手來，將羅得拉進屋去，把門關上， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","並且使門外的人，無論老少，眼都昏迷；他們摸來摸去，總尋不着房門。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","二人對羅得說：「你這裏還有甚麼人嗎？無論是女婿是兒女，和這城中一切屬你的人，你都要將他們從這地方帶出去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","我們要毀滅這地方；因為城內罪惡的聲音在耶和華面前甚大，耶和華差我們來，要毀滅這地方。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","羅得就出去，告訴娶了他女兒的女婿們說：「你們起來離開這地方，因為耶和華要毀滅這城。」他女婿們卻以為他說的是戲言。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","天明了，天使催逼羅得說：「起來！帶着你的妻子和你在這裏的兩個女兒出去，免得你因這城裏的罪惡同被剿滅。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","但羅得遲延不走。二人因為耶和華憐恤羅得，就拉着他的手和他妻子的手，並他兩個女兒的手，把他們領出來，安置在城外； ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","領他們出來以後，就說：「逃命吧！不可回頭看，也不可在平原站住。要往山上逃跑，免得你被剿滅。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","羅得對他們說：「我主啊，不要如此！ ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","你僕人已經在你眼前蒙恩；你又向我顯出莫大的慈愛，救我的性命。我不能逃到山上去，恐怕這災禍臨到我，我便死了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","看哪，這座城又小又近，容易逃到，這不是一個小的嗎？求你容我逃到那裏，我的性命就得存活。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","天使對他說：「這事我也應允你；我不傾覆你所說的這城。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","你要速速地逃到那城；因為你還沒有到那裏，我不能做甚麼。」因此那城名叫瑣珥。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","羅得到了瑣珥，日頭已經出來了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","當時，耶和華將硫磺與火從天上耶和華那裏降與所多瑪和蛾摩拉， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","把那些城和全平原，並城裏所有的居民，連地上生長的，都毀滅了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","羅得的妻子在後邊回頭一看，就變成了一根鹽柱。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","亞伯拉罕清早起來，到了他從前站在耶和華面前的地方， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","向所多瑪和蛾摩拉與平原的全地觀看，不料，那地方煙氣上騰，如同燒窯一般。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","當上帝毀滅平原諸城的時候，他記念亞伯拉罕，正在傾覆羅得所住之城的時候，就打發羅得從傾覆之中出來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","羅得因為怕住在瑣珥，就同他兩個女兒從瑣珥上去，住在山裏；他和兩個女兒住在一個洞裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","大女兒對小女兒說：「我們的父親老了，地上又無人按着世上的常規進到我們這裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","來！我們可以叫父親喝酒，與他同寢。這樣，我們好從他存留後裔。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","於是，那夜她們叫父親喝酒，大女兒就進去和她父親同寢；她幾時躺下，幾時起來，父親都不知道。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","第二天，大女兒對小女兒說：「我昨夜與父親同寢。今夜我們再叫他喝酒，你可以進去與他同寢。這樣，我們好從父親存留後裔。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","於是，那夜她們又叫父親喝酒，小女兒起來與她父親同寢；她幾時躺下，幾時起來，父親都不知道。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","這樣，羅得的兩個女兒都從她父親懷了孕。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","大女兒生了兒子，給他起名叫摩押，就是現今摩押人的始祖。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","小女兒也生了兒子，給他起名叫便‧亞米，就是現今亞捫人的始祖。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","亞伯拉罕從那裏向南地遷去，寄居在加低斯和書珥中間的基拉耳。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","亞伯拉罕稱他的妻撒拉為妹子，基拉耳王亞比米勒差人把撒拉取了去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","但夜間，上帝來，在夢中對亞比米勒說：「你是個死人哪！因為你取了那女人來；她原是別人的妻子。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","亞比米勒卻還沒有親近撒拉；他說：「主啊，連有義的國，你也要毀滅嗎？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","那人豈不是自己對我說『她是我的妹子』嗎？就是女人也自己說：『他是我的哥哥。』我做這事是心正手潔的。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","上帝在夢中對他說：「我知道你做這事是心中正直；我也攔阻了你，免得你得罪我，所以我不容你沾着她。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","現在你把這人的妻子歸還他；因為他是先知，他要為你禱告，使你存活。你若不歸還他，你當知道，你和你所有的人都必要死。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","亞比米勒清早起來，召了眾臣僕來，將這些事都說給他們聽，他們都甚懼怕。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","亞比米勒召了亞伯拉罕來，對他說：「你怎麼向我這樣行呢？我在甚麼事上得罪了你，你竟使我和我國裏的人陷在大罪裏？你向我行不當行的事了！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","亞比米勒又對亞伯拉罕說：「你見了甚麼才做這事呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","亞伯拉罕說：「我以為這地方的人總不懼怕上帝，必為我妻子的緣故殺我。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","況且她也實在是我的妹子；她與我是同父異母，後來作了我的妻子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","當上帝叫我離開父家、飄流在外的時候，我對她說：『我們無論走到甚麼地方，你可以對人說：他是我的哥哥；這就是你待我的恩典了。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","亞比米勒把牛、羊、僕婢賜給亞伯拉罕，又把他的妻子撒拉歸還他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","亞比米勒又說：「看哪，我的地都在你面前，你可以隨意居住」； ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","又對撒拉說：「我給你哥哥一千銀子，作為你在閤家人面前遮羞的，你就在眾人面前沒有不是了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","亞伯拉罕禱告上帝，上帝就醫好了亞比米勒和他的妻子，並他的眾女僕，她們便能生育。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","因耶和華為亞伯拉罕的妻子撒拉的緣故，已經使亞比米勒家中的婦人不能生育。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","耶和華按着先前的話眷顧撒拉，便照他所說的給撒拉成就。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","當亞伯拉罕年老的時候，撒拉懷了孕；到上帝所說的日期，就給亞伯拉罕生了一個兒子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","亞伯拉罕給撒拉所生的兒子起名叫以撒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","以撒生下來第八日，亞伯拉罕照着上帝所吩咐的，給以撒行了割禮。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","他兒子以撒生的時候，亞伯拉罕年一百歲。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","撒拉說：「上帝使我喜笑，凡聽見的必與我一同喜笑」； ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","又說：「誰能預先對亞伯拉罕說『撒拉要乳養嬰孩』呢？因為在他年老的時候，我給他生了一個兒子。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","孩子漸長，就斷了奶。以撒斷奶的日子，亞伯拉罕設擺豐盛的筵席。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","當時，撒拉看見埃及人夏甲給亞伯拉罕所生的兒子戲笑， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","就對亞伯拉罕說：「你把這使女和她兒子趕出去！因為這使女的兒子不可與我的兒子以撒一同承受產業。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","亞伯拉罕因他兒子的緣故很憂愁。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","上帝對亞伯拉罕說：「你不必為這童子和你的使女憂愁。凡撒拉對你說的話，你都該聽從；因為從以撒生的，才要稱為你的後裔。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","至於使女的兒子，我也必使他的後裔成立一國，因為他是你所生的。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","亞伯拉罕清早起來，拿餅和一皮袋水，給了夏甲，搭在她的肩上，又把孩子交給她，打發她走。夏甲就走了，在別是巴的曠野走迷了路。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","皮袋的水用盡了，夏甲就把孩子撇在小樹底下， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","自己走開約有一箭之遠，相對而坐，說：「我不忍見孩子死」，就相對而坐，放聲大哭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","上帝聽見童子的聲音；上帝的使者從天上呼叫夏甲說：「夏甲，你為何這樣呢？不要害怕，上帝已經聽見童子的聲音了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","起來！把童子抱在懷中，我必使他的後裔成為大國。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","上帝使夏甲的眼睛明亮，她就看見一口水井，便去將皮袋盛滿了水，給童子喝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","上帝保佑童子，他就漸長，住在曠野，成了弓箭手。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","他住在巴蘭的曠野；他母親從埃及地給他娶了一個妻子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","當那時候，亞比米勒同他軍長非各對亞伯拉罕說：「凡你所行的事都有上帝的保佑。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","我願你如今在這裏指着上帝對我起誓，不要欺負我與我的兒子，並我的子孫。我怎樣厚待了你，你也要照樣厚待我與你所寄居這地的民。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","亞伯拉罕說：「我情願起誓。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","從前，亞比米勒的僕人霸佔了一口水井，亞伯拉罕為這事指責亞比米勒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","亞比米勒說：「誰做這事，我不知道，你也沒有告訴我，今日我才聽見了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","亞伯拉罕把羊和牛給了亞比米勒，二人就彼此立約。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","亞伯拉罕把七隻母羊羔另放在一處。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","亞比米勒問亞伯拉罕說：「你把這七隻母羊羔另放在一處，是甚麼意思呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","他說：「你要從我手裏受這七隻母羊羔，作我挖這口井的證據。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","所以他給那地方起名叫別是巴，因為他們二人在那裏起了誓。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","他們在別是巴立了約，亞比米勒就同他軍長非各起身回非利士地去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","亞伯拉罕在別是巴栽上一棵垂絲柳樹，又在那裏求告耶和華－永生上帝的名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","亞伯拉罕在非利士人的地寄居了多日。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","這些事以後，上帝要試驗亞伯拉罕，就呼叫他說：「亞伯拉罕！」他說：「我在這裏。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","上帝說：「你帶着你的兒子，就是你獨生的兒子，你所愛的以撒，往摩利亞地去，在我所要指示你的山上，把他獻為燔祭。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","亞伯拉罕清早起來，備上驢，帶着兩個僕人和他兒子以撒，也劈好了燔祭的柴，就起身往上帝所指示他的地方去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","到了第三日，亞伯拉罕舉目遠遠地看見那地方。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","亞伯拉罕對他的僕人說：「你們和驢在此等候，我與童子往那裏去拜一拜，就回到你們這裏來。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","亞伯拉罕把燔祭的柴放在他兒子以撒身上，自己手裏拿着火與刀；於是二人同行。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","以撒對他父親亞伯拉罕說：「父親哪！」亞伯拉罕說：「我兒，我在這裏。」以撒說：「請看，火與柴都有了，但燔祭的羊羔在哪裏呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","亞伯拉罕說：「我兒，上帝必自己預備作燔祭的羊羔。」於是二人同行。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","他們到了上帝所指示的地方，亞伯拉罕在那裏築壇，把柴擺好，捆綁他的兒子以撒，放在壇的柴上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","亞伯拉罕就伸手拿刀，要殺他的兒子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","耶和華的使者從天上呼叫他說：「亞伯拉罕！亞伯拉罕！」他說：「我在這裏。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","天使說：「你不可在這童子身上下手。一點不可害他！現在我知道你是敬畏上帝的了；因為你沒有將你的兒子，就是你獨生的兒子，留下不給我。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","亞伯拉罕舉目觀看，不料，有一隻公羊，兩角扣在稠密的小樹中。亞伯拉罕就取了那隻公羊來，獻為燔祭，代替他的兒子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","亞伯拉罕給那地方起名叫「耶和華以勒」，直到今日人還說：「在耶和華的山上必有預備。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","耶和華的使者第二次從天上呼叫亞伯拉罕說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","「耶和華說：『你既行了這事，不留下你的兒子，就是你獨生的兒子，我便指着自己起誓說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","論福，我必賜大福給你；論子孫，我必叫你的子孫多起來，如同天上的星，海邊的沙。你子孫必得着仇敵的城門， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","並且地上萬國都必因你的後裔得福，因為你聽從了我的話。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","於是亞伯拉罕回到他僕人那裏，他們一同起身往別是巴去，亞伯拉罕就住在別是巴。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","這事以後，有人告訴亞伯拉罕說：「密迦給你兄弟拿鶴生了幾個兒子， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","長子是烏斯，他的兄弟是布斯和亞蘭的父親基母利， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","並基薛、哈瑣、必達、益拉、彼土利（彼土利生利百加）。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","這八個人都是密迦給亞伯拉罕的兄弟拿鶴生的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","拿鶴的妾名叫流瑪，生了提八、迦含、他轄，和瑪迦。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","撒拉享壽一百二十七歲，這是撒拉一生的歲數。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","撒拉死在迦南地的基列‧亞巴，就是希伯崙。亞伯拉罕為她哀慟哭號。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","後來亞伯拉罕從死人面前起來，對赫人說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","「我在你們中間是外人，是寄居的。求你們在這裏給我一塊地，我好埋葬我的死人，使她不在我眼前。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","赫人回答亞伯拉罕說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","「我主請聽。你在我們中間是一位尊大的王子，只管在我們最好的墳地裏埋葬你的死人；我們沒有一人不容你在他的墳地裏埋葬你的死人。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","亞伯拉罕就起來，向那地的赫人下拜， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","對他們說：「你們若有意叫我埋葬我的死人，使她不在我眼前，就請聽我的話，為我求瑣轄的兒子以弗崙， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","把田頭上那麥比拉洞給我，他可以按着足價賣給我，作我在你們中間的墳地。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","當時以弗崙正坐在赫人中間。於是，赫人以弗崙在城門出入的赫人面前對亞伯拉罕說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","「不然，我主請聽。我送給你這塊田，連田間的洞也送給你，在我同族的人面前都給你，可以埋葬你的死人。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","亞伯拉罕就在那地的人民面前下拜， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","在他們面前對以弗崙說：「你若應允，請聽我的話。我要把田價給你，求你收下，我就在那裏埋葬我的死人。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","以弗崙回答亞伯拉罕說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","「我主請聽。值四百舍客勒銀子的一塊田，在你我中間還算甚麼呢？只管埋葬你的死人吧！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","亞伯拉罕聽從了以弗崙，照着他在赫人面前所說的話，把買賣通用的銀子平了四百舍客勒給以弗崙。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","於是，麥比拉、幔利前、以弗崙的那塊田和其中的洞，並田間四圍的樹木， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","都定準歸與亞伯拉罕，乃是他在赫人面前並城門出入的人面前買妥的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","此後，亞伯拉罕把他妻子撒拉埋葬在迦南地幔利前的麥比拉田間的洞裏。（幔利就是希伯崙）。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","從此，那塊田和田間的洞就藉着赫人定準歸與亞伯拉罕作墳地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","亞伯拉罕年紀老邁，向來在一切事上耶和華都賜福給他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","亞伯拉罕對管理他全業最老的僕人說：「請你把手放在我大腿底下。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","我要叫你指着耶和華－天地的主起誓，不要為我兒子娶這迦南地中的女子為妻。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","你要往我本地本族去，為我的兒子以撒娶一個妻子。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","僕人對他說：「倘若女子不肯跟我到這地方來，我必須將你的兒子帶回你原出之地嗎？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","亞伯拉罕對他說：「你要謹慎，不要帶我的兒子回那裏去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","耶和華－天上的主曾帶領我離開父家和本族的地，對我說話，向我起誓說：『我要將這地賜給你的後裔。』他必差遣使者在你面前，你就可以從那裏為我兒子娶一個妻子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","倘若女子不肯跟你來，我使你起的誓就與你無干了，只是不可帶我的兒子回那裏去。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","僕人就把手放在他主人亞伯拉罕的大腿底下，為這事向他起誓。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","那僕人從他主人的駱駝裏取了十匹駱駝，並帶些他主人各樣的財物，起身往美索不達米亞去，到了拿鶴的城。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","天將晚，眾女子出來打水的時候，他便叫駱駝跪在城外的水井那裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","他說：「耶和華－我主人亞伯拉罕的上帝啊，求你施恩給我主人亞伯拉罕，使我今日遇見好機會。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","我現今站在井旁，城內居民的女子們正出來打水。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","我向那一個女子說：『請你拿下水瓶來，給我水喝。』她若說：『請喝！我也給你的駱駝喝。』願那女子就作你所預定給你僕人以撒的妻。這樣，我便知道你施恩給我主人了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","話還沒有說完，不料，利百加肩頭上扛着水瓶出來。利百加是彼土利所生的；彼土利是亞伯拉罕兄弟拿鶴妻子密迦的兒子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","那女子容貌極其俊美，還是處女，也未曾有人親近她。她下到井旁，打滿了瓶，又上來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","僕人跑上前去迎着她，說：「求你將瓶裏的水給我一點喝。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","女子說：「我主請喝！」就急忙拿下瓶來，托在手上給他喝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","女子給他喝了，就說：「我再為你的駱駝打水，叫駱駝也喝足。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","她就急忙把瓶裏的水倒在槽裏，又跑到井旁打水，就為所有的駱駝打上水來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","那人定睛看她，一句話也不說，要曉得耶和華賜他通達的道路沒有。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","駱駝喝足了，那人就拿一個金環，重半舍客勒，兩個金鐲，重十舍客勒，給了那女子， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","說：「請告訴我，你是誰的女兒？你父親家裏有我們住宿的地方沒有？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","女子說：「我是密迦與拿鶴之子彼土利的女兒」； ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","又說：「我們家裏足有糧草，也有住宿的地方。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","那人就低頭向耶和華下拜， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","說：「耶和華－我主人亞伯拉罕的上帝是應當稱頌的，因他不斷地以慈愛誠實待我主人。至於我，耶和華在路上引領我，直走到我主人的兄弟家裏。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","女子跑回去，照着這些話告訴她母親和她家裏的人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","利百加有一個哥哥，名叫拉班，看見金環，又看見金鐲在他妹子的手上，並聽見他妹子利百加的話，說那人對我如此如此說。拉班就跑出來往井旁去，到那人跟前，見他仍站在駱駝旁邊的井旁那裏， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","便對他說：「你這蒙耶和華賜福的，請進來，為甚麼站在外邊？我已經收拾了房屋，也為駱駝預備了地方。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","那人就進了拉班的家。拉班卸了駱駝，用草料餵上，拿水給那人和跟隨的人洗腳； ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","把飯擺在他面前，叫他吃，他卻說：「我不吃，等我說明白我的事情再吃。」拉班說：「請說。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","他說：「我是亞伯拉罕的僕人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","耶和華大大地賜福給我主人，使他昌大，又賜給他羊群、牛群、金銀、僕婢、駱駝，和驢。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","我主人的妻子撒拉年老的時候給我主人生了一個兒子；我主人也將一切所有的都給了這個兒子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","我主人叫我起誓說：『你不要為我兒子娶迦南地的女子為妻。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","你要往我父家、我本族那裏去，為我的兒子娶一個妻子。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","我對我主人說：『恐怕女子不肯跟我來。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","他就說：『我所事奉的耶和華必要差遣他的使者與你同去，叫你的道路通達，你就得以在我父家、我本族那裏，給我的兒子娶一個妻子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","只要你到了我本族那裏，我使你起的誓就與你無干。他們若不把女子交給你，我使你起的誓也與你無干。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","「我今日到了井旁，便說：『耶和華－我主人亞伯拉罕的上帝啊，願你叫我所行的道路通達。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","我如今站在井旁，對哪一個出來打水的女子說：請你把你瓶裏的水給我一點喝； ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","她若說：你只管喝，我也為你的駱駝打水；願那女子就作耶和華給我主人兒子所預定的妻。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","我心裏的話還沒有說完，利百加就出來，肩頭上扛着水瓶，下到井旁打水。我便對她說：『請你給我水喝。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","她就急忙從肩頭上拿下瓶來，說：『請喝！我也給你的駱駝喝。』我便喝了；她又給我的駱駝喝了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","我問她說：『你是誰的女兒？』她說：『我是密迦與拿鶴之子彼土利的女兒。』我就把環子戴在她鼻子上，把鐲子戴在她兩手上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","隨後我低頭向耶和華下拜，稱頌耶和華－我主人亞伯拉罕的上帝；因為他引導我走合式的道路，使我得着我主人兄弟的孫女，給我主人的兒子為妻。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","現在你們若願以慈愛誠實待我主人，就告訴我；若不然，也告訴我，使我可以或向左，或向右。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","拉班和彼土利回答說：「這事乃出於耶和華，我們不能向你說好說歹。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","看哪，利百加在你面前，可以將她帶去，照着耶和華所說的，給你主人的兒子為妻。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","亞伯拉罕的僕人聽見他們這話，就向耶和華俯伏在地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","當下僕人拿出金器、銀器，和衣服送給利百加，又將寶物送給她哥哥和她母親。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","僕人和跟從他的人吃了喝了，住了一夜。早晨起來，僕人就說：「請打發我回我主人那裏去吧。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","利百加的哥哥和她母親說：「讓女子同我們再住幾天，至少十天，然後她可以去。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","僕人說：「耶和華既賜給我通達的道路，你們不要耽誤我，請打發我走，回我主人那裏去吧。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","他們說：「我們把女子叫來問問她」， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","就叫了利百加來，問她說：「你和這人同去嗎？」利百加說：「我去。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","於是他們打發妹子利百加和她的乳母，同亞伯拉罕的僕人，並跟從僕人的，都走了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","他們就給利百加祝福說： 我們的妹子啊，願你作千萬人的母！ 願你的後裔得着仇敵的城門！ ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","利百加和她的使女們起來，騎上駱駝，跟着那僕人，僕人就帶着利百加走了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","那時，以撒住在南地，剛從庇耳‧拉海‧萊回來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","天將晚，以撒出來在田間默想，舉目一看，見來了些駱駝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","利百加舉目看見以撒，就急忙下了駱駝， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","問那僕人說：「這田間走來迎接我們的是誰？」僕人說：「是我的主人。」利百加就拿帕子蒙上臉。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","僕人就將所辦的一切事都告訴以撒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","以撒便領利百加進了他母親撒拉的帳棚，娶了她為妻，並且愛她。以撒自從他母親不在了，這才得了安慰。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","亞伯拉罕又娶了一妻，名叫基土拉。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","基土拉給他生了心蘭、約珊、米但、米甸、伊施巴，和書亞。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","約珊生了示巴和底但。底但的子孫是亞書利族、利都是族，和利烏米族。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","米甸的兒子是以法、以弗、哈諾、亞比大，和以勒大。這都是基土拉的子孫。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","亞伯拉罕將一切所有的都給了以撒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","亞伯拉罕把財物分給他庶出的眾子，趁着自己還在世的時候打發他們離開他的兒子以撒，往東方去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","亞伯拉罕一生的年日是一百七十五歲。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","亞伯拉罕壽高年邁，氣絕而死，歸到他列祖那裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","他兩個兒子以撒、以實瑪利把他埋葬在麥比拉洞裏。這洞在幔利前、赫人瑣轄的兒子以弗崙的田中， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","就是亞伯拉罕向赫人買的那塊田。亞伯拉罕和他妻子撒拉都葬在那裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","亞伯拉罕死了以後，上帝賜福給他的兒子以撒。以撒靠近庇耳‧拉海‧萊居住。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","撒拉的使女埃及人夏甲給亞伯拉罕所生的兒子是以實瑪利。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","以實瑪利兒子們的名字，按着他們的家譜記在下面。以實瑪利的長子是尼拜約，又有基達、亞德別、米比衫、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","米施瑪、度瑪、瑪撒、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","哈大、提瑪、伊突、拿非施、基底瑪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","這是以實瑪利眾子的名字，照着他們的村莊、營寨，作了十二族的族長。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","以實瑪利享壽一百三十七歲，氣絕而死，歸到他列祖那裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","他子孫的住處在他眾弟兄東邊，從哈腓拉直到埃及前的書珥，正在亞述的道上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","亞伯拉罕的兒子以撒的後代記在下面。亞伯拉罕生以撒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","以撒娶利百加為妻的時候正四十歲。利百加是巴旦‧亞蘭地的亞蘭人彼土利的女兒，是亞蘭人拉班的妹子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","以撒因他妻子不生育，就為她祈求耶和華；耶和華應允他的祈求，他的妻子利百加就懷了孕。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","孩子們在她腹中彼此相爭，她就說：「若是這樣，我為甚麼活着呢？」她就去求問耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","耶和華對她說： 兩國在你腹內； 兩族要從你身上出來。 這族必強於那族； 將來大的要服事小的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","生產的日子到了，腹中果然是雙子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","先產的身體發紅，渾身有毛，如同皮衣，他們就給他起名叫以掃。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","隨後又生了以掃的兄弟，手抓住以掃的腳跟，因此給他起名叫雅各。利百加生下兩個兒子的時候，以撒年正六十歲。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","兩個孩子漸漸長大，以掃善於打獵，常在田野；雅各為人安靜，常住在帳棚裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","以撒愛以掃，因為常吃他的野味；利百加卻愛雅各。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","有一天，雅各熬湯，以掃從田野回來累昏了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","以掃對雅各說：「我累昏了，求你把這紅湯給我喝。」因此以掃又叫以東。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","雅各說：「你今日把長子的名分賣給我吧。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","以掃說：「我將要死，這長子的名分於我有甚麼益處呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","雅各說：「你今日對我起誓吧。」以掃就對他起了誓，把長子的名分賣給雅各。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","於是雅各將餅和紅豆湯給了以掃，以掃吃了喝了，便起來走了。這就是以掃輕看了他長子的名分。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","在亞伯拉罕的日子，那地有一次饑荒；這時又有饑荒，以撒就往基拉耳去，到非利士人的王亞比米勒那裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","耶和華向以撒顯現，說：「你不要下埃及去，要住在我所指示你的地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","你寄居在這地，我必與你同在，賜福給你，因為我要將這些地都賜給你和你的後裔。我必堅定我向你父亞伯拉罕所起的誓。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","我要加增你的後裔，像天上的星那樣多，又要將這些地都賜給你的後裔。並且地上萬國必因你的後裔得福－ ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","都因亞伯拉罕聽從我的話，遵守我的吩咐和我的命令、律例、法度。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","以撒就住在基拉耳。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","那地方的人問到他的妻子，他便說：「那是我的妹子。」原來他怕說：「是我的妻子」；他心裏想：「恐怕這地方的人為利百加的緣故殺我」，因為她容貌俊美。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","他在那裏住了許久。有一天，非利士人的王亞比米勒從窗戶裏往外觀看，見以撒和他的妻子利百加戲玩。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","亞比米勒召了以撒來，對他說：「她實在是你的妻子，你怎麼說她是你的妹子？」以撒說：「我心裏想，恐怕我因她而死。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","亞比米勒說：「你向我們做的是甚麼事呢？民中險些有人和你的妻同寢，把我們陷在罪裏。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","於是亞比米勒曉諭眾民說：「凡沾着這個人，或是他妻子的，定要把他治死。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","以撒在那地耕種，那一年有百倍的收成。耶和華賜福給他， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","他就昌大，日增月盛，成了大富戶。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","他有羊群牛群，又有許多僕人，非利士人就嫉妒他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","當他父親亞伯拉罕在世的日子，他父親的僕人所挖的井，非利士人全都塞住，填滿了土。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","亞比米勒對以撒說：「你離開我們去吧。因為你比我們強盛得多。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","以撒就離開那裏，在基拉耳谷支搭帳棚，住在那裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","當他父親亞伯拉罕在世之日所挖的水井因非利士人在亞伯拉罕死後塞住了，以撒就重新挖出來，仍照他父親所叫的叫那些井的名字。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","以撒的僕人在谷中挖井，便得了一口活水井。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","基拉耳的牧人與以撒的牧人爭競，說：「這水是我們的。」以撒就給那井起名叫埃色，因為他們和他相爭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","以撒的僕人又挖了一口井，他們又為這井爭競，因此以撒給這井起名叫西提拿。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","以撒離開那裏，又挖了一口井，他們不為這井爭競了，他就給那井起名叫利河伯。他說：「耶和華現在給我們寬闊之地，我們必在這地昌盛。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","以撒從那裏上別是巴去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","當夜耶和華向他顯現，說：「我是你父親亞伯拉罕的上帝，不要懼怕！因為我與你同在，要賜福給你，並要為我僕人亞伯拉罕的緣故，使你的後裔繁多。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","以撒就在那裏築了一座壇，求告耶和華的名，並且支搭帳棚；他的僕人便在那裏挖了一口井。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","亞比米勒，同他的朋友亞戶撒和他的軍長非各，從基拉耳來見以撒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","以撒對他們說：「你們既然恨我，打發我走了，為甚麼到我這裏來呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","他們說：「我們明明地看見耶和華與你同在，便說，不如我們兩下彼此起誓，彼此立約， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","使你不害我們，正如我們未曾害你，一味地厚待你，並且打發你平平安安地走。你是蒙耶和華賜福的了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","以撒就為他們設擺筵席，他們便吃了喝了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","他們清早起來彼此起誓。以撒打發他們走，他們就平平安安地離開他走了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","那一天，以撒的僕人來，將挖井的事告訴他說：「我們得了水了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","他就給那井起名叫示巴；因此那城叫做別是巴，直到今日。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","以掃四十歲的時候娶了赫人比利的女兒猶滴，與赫人以倫的女兒巴實抹為妻。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","她們常使以撒和利百加心裏愁煩。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","以撒年老，眼睛昏花，不能看見，就叫了他大兒子以掃來，說：「我兒。」以掃說：「我在這裏。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","他說：「我如今老了，不知道哪一天死。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","現在拿你的器械，就是箭囊和弓，往田野去為我打獵， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","照我所愛的做成美味，拿來給我吃，使我在未死之先給你祝福。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","以撒對他兒子以掃說話，利百加也聽見了。以掃往田野去打獵，要得野味帶來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","利百加就對她兒子雅各說：「我聽見你父親對你哥哥以掃說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","『你去把野獸帶來，做成美味給我吃，我好在未死之先，在耶和華面前給你祝福。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","現在，我兒，你要照着我所吩咐你的，聽從我的話。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","你到羊群裏去，給我拿兩隻肥山羊羔來，我便照你父親所愛的給他做成美味。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","你拿到你父親那裏給他吃，使他在未死之先給你祝福。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","雅各對他母親利百加說：「我哥哥以掃渾身是有毛的，我身上是光滑的； ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","倘若我父親摸着我，必以我為欺哄人的，我就招咒詛，不得祝福。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","他母親對他說：「我兒，你招的咒詛歸到我身上；你只管聽我的話，去把羊羔給我拿來。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","他便去拿來，交給他母親；他母親就照他父親所愛的做成美味。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","利百加又把家裏所存大兒子以掃上好的衣服給她小兒子雅各穿上， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","又用山羊羔皮包在雅各的手上和頸項的光滑處， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","就把所做的美味和餅交在她兒子雅各的手裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","雅各到他父親那裏說：「我父親！」他說：「我在這裏。我兒，你是誰？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","雅各對他父親說：「我是你的長子以掃；我已照你所吩咐我的行了。請起來坐着，吃我的野味，好給我祝福。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","以撒對他兒子說：「我兒，你如何找得這麼快呢？」他說：「因為耶和華－你的上帝使我遇見好機會得着的。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","以撒對雅各說：「我兒，你近前來，我摸摸你，知道你真是我的兒子以掃不是。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","雅各就挨近他父親以撒。以撒摸着他，說：「聲音是雅各的聲音，手卻是以掃的手。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","以撒就辨不出他來；因為他手上有毛，像他哥哥以掃的手一樣，就給他祝福； ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","又說：「你真是我兒子以掃嗎？」他說：「我是。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","以撒說：「你遞給我，我好吃我兒子的野味，給你祝福。」雅各就遞給他，他便吃了，又拿酒給他，他也喝了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","他父親以撒對他說：「我兒，你上前來與我親嘴。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","他就上前與父親親嘴。他父親一聞他衣服上的香氣，就給他祝福，說： 我兒的香氣 如同耶和華賜福之田地的香氣一樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","願上帝賜你天上的甘露， 地上的肥土， 並許多五穀新酒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","願多民事奉你， 多國跪拜你。 願你作你弟兄的主； 你母親的兒子向你跪拜。 凡咒詛你的，願他受咒詛； 為你祝福的，願他蒙福。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","以撒為雅各祝福已畢，雅各從他父親那裏才出來，他哥哥以掃正打獵回來， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","也做了美味，拿來給他父親，說：「請父親起來，吃你兒子的野味，好給我祝福。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","他父親以撒對他說：「你是誰？」他說：「我是你的長子以掃。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","以撒就大大地戰兢，說：「你未來之先，是誰得了野味拿來給我呢？我已經吃了，為他祝福；他將來也必蒙福。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","以掃聽了他父親的話，就放聲痛哭，說：「我父啊，求你也為我祝福！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","以撒說：「你兄弟已經用詭計來將你的福分奪去了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","以掃說：「他名雅各，豈不是正對嗎？因為他欺騙了我兩次：他從前奪了我長子的名分，你看，他現在又奪了我的福分。」以掃又說：「你沒有留下為我可祝的福嗎？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","以撒回答以掃說：「我已立他為你的主，使他的弟兄都給他作僕人，並賜他五穀新酒可以養生。我兒，現在我還能為你做甚麼呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","以掃對他父親說：「父啊，你只有一樣可祝的福嗎？我父啊，求你也為我祝福！」以掃就放聲而哭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","他父親以撒說： 地上的肥土必為你所住； 天上的甘露必為你所得。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","你必倚靠刀劍度日， 又必事奉你的兄弟； 到你強盛的時候， 必從你頸項上掙開他的軛。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","以掃因他父親給雅各祝的福，就怨恨雅各，心裏說：「為我父親居喪的日子近了，到那時候，我要殺我的兄弟雅各。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","有人把利百加大兒子以掃的話告訴利百加，她就打發人去，叫了她小兒子雅各來，對他說：「你哥哥以掃想要殺你，報仇雪恨。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","現在，我兒，你要聽我的話：起來，逃往哈蘭、我哥哥拉班那裏去， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","同他住些日子，直等你哥哥的怒氣消了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","你哥哥向你消了怒氣，忘了你向他所做的事，我便打發人去把你從那裏帶回來。為甚麼一日喪你們二人呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","利百加對以撒說：「我因這赫人的女子連性命都厭煩了；倘若雅各也娶赫人的女子為妻，像這些一樣，我活着還有甚麼益處呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","以撒叫了雅各來，給他祝福，並囑咐他說：「你不要娶迦南的女子為妻。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","你起身往巴旦‧亞蘭去，到你外祖彼土利家裏，在你母舅拉班的女兒中娶一女為妻。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","願全能的上帝賜福給你，使你生養眾多，成為多族， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","將應許亞伯拉罕的福賜給你和你的後裔，使你承受你所寄居的地為業，就是上帝賜給亞伯拉罕的地。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","以撒打發雅各走了，他就往巴旦‧亞蘭去，到亞蘭人彼土利的兒子拉班那裏。拉班是雅各、以掃的母舅。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","以掃見以撒已經給雅各祝福，而且打發他往巴旦‧亞蘭去，在那裏娶妻，並見祝福的時候囑咐他說：「不要娶迦南的女子為妻」， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","又見雅各聽從父母的話往巴旦‧亞蘭去了， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","以掃就曉得他父親以撒看不中迦南的女子， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","便往以實瑪利那裏去，在他二妻之外又娶了瑪哈拉為妻。她是亞伯拉罕兒子以實瑪利的女兒，尼拜約的妹子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","雅各出了別是巴，向哈蘭走去； ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","到了一個地方，因為太陽落了，就在那裏住宿，便拾起那地方的一塊石頭枕在頭下，在那裏躺臥睡了， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","夢見一個梯子立在地上，梯子的頭頂着天，有上帝的使者在梯子上，上去下來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","耶和華站在梯子以上，說：「我是耶和華－你祖亞伯拉罕的上帝，也是以撒的上帝；我要將你現在所躺臥之地賜給你和你的後裔。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","你的後裔必像地上的塵沙那樣多，必向東西南北開展；地上萬族必因你和你的後裔得福。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","我也與你同在。你無論往哪裏去，我必保佑你，領你歸回這地，總不離棄你，直到我成全了向你所應許的。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","雅各睡醒了，說：「耶和華真在這裏，我竟不知道！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","就懼怕，說：「這地方何等可畏！這不是別的，乃是上帝的殿，也是天的門。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","雅各清早起來，把所枕的石頭立作柱子，澆油在上面。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","他就給那地方起名叫伯特利；但那地方起先名叫路斯。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","雅各許願說：「上帝若與我同在，在我所行的路上保佑我，又給我食物吃，衣服穿， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","使我平平安安地回到我父親的家，我就必以耶和華為我的上帝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","我所立為柱子的石頭也必作上帝的殿；凡你所賜給我的，我必將十分之一獻給你。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","雅各起行，到了東方人之地， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","看見田間有一口井，有三群羊臥在井旁；因為人飲羊群都是用那井裏的水。井口上的石頭是大的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","常有羊群在那裏聚集，牧人把石頭轉離井口飲羊，隨後又把石頭放在井口的原處。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","雅各對牧人說：「弟兄們，你們是哪裏來的？」他們說：「我們是哈蘭來的。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","他問他們說：「拿鶴的孫子拉班，你們認識嗎？」他們說：「我們認識。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","雅各說：「他平安嗎？」他們說：「平安。看哪，他女兒拉結領着羊來了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","雅各說：「日頭還高，不是羊群聚集的時候，你們不如飲羊，再去放一放。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","他們說：「我們不能，必等羊群聚齊，人把石頭轉離井口才可飲羊。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","雅各正和他們說話的時候，拉結領着她父親的羊來了，因為那些羊是她牧放的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","雅各看見母舅拉班的女兒拉結和母舅拉班的羊群，就上前把石頭轉離井口，飲他母舅拉班的羊群。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","雅各與拉結親嘴，就放聲而哭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","雅各告訴拉結，自己是她父親的外甥，是利百加的兒子，拉結就跑去告訴她父親。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","拉班聽見外甥雅各的信息，就跑去迎接，抱着他，與他親嘴，領他到自己的家。雅各將一切的情由告訴拉班。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","拉班對他說：「你實在是我的骨肉。」雅各就和他同住了一個月。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","拉班對雅各說：「你雖是我的骨肉，豈可白白地服事我？請告訴我，你要甚麼為工價？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","拉班有兩個女兒，大的名叫利亞，小的名叫拉結。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","利亞的眼睛沒有神氣，拉結卻生得美貌俊秀。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","雅各愛拉結，就說：「我願為你小女兒拉結服事你七年。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","拉班說：「我把她給你，勝似給別人，你與我同住吧！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","雅各就為拉結服事了七年；他因為深愛拉結，就看這七年如同幾天。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","雅各對拉班說：「日期已經滿了，求你把我的妻子給我，我好與她同房。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","拉班就擺設筵席，請齊了那地方的眾人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","到晚上，拉班將女兒利亞送來給雅各，雅各就與她同房。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","拉班又將婢女悉帕給女兒利亞作使女。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","到了早晨，雅各一看是利亞，就對拉班說：「你向我做的是甚麼事呢？我服事你，不是為拉結嗎？你為甚麼欺哄我呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","拉班說：「大女兒還沒有給人，先把小女兒給人，在我們這地方沒有這規矩。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","你為這個滿了七日，我就把那個也給你，你再為她服事我七年。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","雅各就如此行。滿了利亞的七日，拉班便將女兒拉結給雅各為妻。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","拉班又將婢女辟拉給女兒拉結作使女。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","雅各也與拉結同房，並且愛拉結勝似愛利亞，於是又服事了拉班七年。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","耶和華見利亞失寵，就使她生育，拉結卻不生育。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","利亞懷孕生子，就給他起名叫呂便，因而說：「耶和華看見我的苦情，如今我的丈夫必愛我。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","她又懷孕生子，就說：「耶和華因為聽見我失寵，所以又賜給我這個兒子」，於是給他起名叫西緬。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","她又懷孕生子，起名叫利未，說：「我給丈夫生了三個兒子，他必與我聯合。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","她又懷孕生子，說：「這回我要讚美耶和華」，因此給他起名叫猶大。這才停了生育。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","拉結見自己不給雅各生子，就嫉妒她姊姊，對雅各說：「你給我孩子，不然我就死了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","雅各向拉結生氣，說：「叫你不生育的是上帝，我豈能代替他作主呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","拉結說：「有我的使女辟拉在這裏，你可以與她同房，使她生子在我膝下，我便因她也得孩子。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","拉結就把她的使女辟拉給丈夫為妾；雅各便與她同房， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","辟拉就懷孕，給雅各生了一個兒子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","拉結說：「上帝伸了我的冤，也聽了我的聲音，賜我一個兒子」，因此給他起名叫但。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","拉結的使女辟拉又懷孕，給雅各生了第二個兒子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","拉結說：「我與我姊姊大大相爭，並且得勝」，於是給他起名叫拿弗他利。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","利亞見自己停了生育，就把使女悉帕給雅各為妾。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","利亞的使女悉帕給雅各生了一個兒子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","利亞說：「萬幸！」於是給他起名叫迦得 。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","利亞的使女悉帕又給雅各生了第二個兒子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","利亞說：「我有福啊，眾女子都要稱我是有福的」，於是給他起名叫亞設。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","割麥子的時候，呂便往田裏去，尋見風茄，拿來給他母親利亞。拉結對利亞說：「請你把你兒子的風茄給我些。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","利亞說：「你奪了我的丈夫還算小事嗎？你又要奪我兒子的風茄嗎？」拉結說：「為你兒子的風茄，今夜他可以與你同寢。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","到了晚上，雅各從田裏回來，利亞出來迎接他，說：「你要與我同寢，因為我實在用我兒子的風茄把你雇下了。」那一夜，雅各就與她同寢。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","上帝應允了利亞，她就懷孕，給雅各生了第五個兒子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","利亞說：「上帝給了我價值，因為我把使女給了我丈夫」，於是給他起名叫以薩迦。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","利亞又懷孕，給雅各生了第六個兒子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","利亞說：「上帝賜我厚賞；我丈夫必與我同住，因我給他生了六個兒子」，於是給他起名西布倫。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","後來又生了一個女兒，給她起名叫底拿。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","上帝顧念拉結，應允了她，使她能生育。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","拉結懷孕生子，說：「上帝除去了我的羞恥」， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","就給他起名叫約瑟，意思說：「願耶和華再增添我一個兒子。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","拉結生約瑟之後，雅各對拉班說：「請打發我走，叫我回到我本鄉本土去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","請你把我服事你所得的妻子和兒女給我，讓我走；我怎樣服事你，你都知道。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","拉班對他說：「我若在你眼前蒙恩，請你仍與我同住，因為我已算定，耶和華賜福與我是為你的緣故」； ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","又說：「請你定你的工價，我就給你。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","雅各對他說：「我怎樣服事你，你的牲畜在我手裏怎樣，是你知道的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","我未來之先，你所有的很少，現今卻發大眾多，耶和華隨我的腳步賜福與你。如今，我甚麼時候才為自己興家立業呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","拉班說：「我當給你甚麼呢？」雅各說：「甚麼你也不必給我，只有一件事，你若應承，我便仍舊牧放你的羊群。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","今天我要走遍你的羊群，把綿羊中凡有點的、有斑的，和黑色的，並山羊中凡有斑的、有點的，都挑出來；將來這一等的就算我的工價。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","以後你來查看我的工價，凡在我手裏的山羊不是有點有斑的，綿羊不是黑色的，那就算是我偷的；這樣便可證出我的公義來。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","拉班說：「好啊！我情願照着你的話行。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","當日，拉班把有紋的、有斑的公山羊，有點的、有斑的、有雜白紋的母山羊，並黑色的綿羊，都挑出來，交在他兒子們的手下， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","又使自己和雅各相離三天的路程。雅各就牧養拉班其餘的羊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","雅各拿楊樹、杏樹、楓樹的嫩枝，將皮剝成白紋，使枝子露出白的來， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","將剝了皮的枝子，對着羊群，插在飲羊的水溝裏和水槽裏，羊來喝的時候，牝牡配合。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","羊對着枝子配合，就生下有紋的、有點的、有斑的來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","雅各把羊羔分出來，使拉班的羊與這有紋和黑色的羊相對，把自己的羊另放一處，不叫他和拉班的羊混雜。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","到羊群肥壯配合的時候，雅各就把枝子插在水溝裏，使羊對着枝子配合。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","只是到羊瘦弱配合的時候就不插枝子。這樣，瘦弱的就歸拉班，肥壯的就歸雅各。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","於是雅各極其發大，得了許多的羊群、僕婢、駱駝，和驢。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","雅各聽見拉班的兒子們有話說：「雅各把我們父親所有的都奪了去，並藉着我們父親的，得了這一切的榮耀。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","雅各見拉班的氣色向他不如從前了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","耶和華對雅各說：「你要回你祖、你父之地，到你親族那裏去，我必與你同在。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","雅各就打發人，叫拉結和利亞到田野羊群那裏來， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","對她們說：「我看你們父親的氣色向我不如從前了；但我父親的上帝向來與我同在。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","你們也知道，我盡了我的力量服事你們的父親。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","你們的父親欺哄我，十次改了我的工價；然而上帝不容他害我。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","他若說：『有點的歸你作工價』，羊群所生的都有點；他若說：『有紋的歸你作工價』，羊群所生的都有紋。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","這樣，上帝把你們父親的牲畜奪來賜給我了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","羊配合的時候，我夢中舉目一看，見跳母羊的公羊都是有紋的、有點的、有花斑的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","上帝的使者在那夢中呼叫我說：『雅各。』我說：『我在這裏。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","他說：『你舉目觀看，跳母羊的公羊都是有紋的、有點的、有花斑的；凡拉班向你所做的，我都看見了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","我是伯特利的上帝；你在那裏用油澆過柱子，向我許過願。現今你起來，離開這地，回你本地去吧！』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","拉結和利亞回答雅各說：「在我們父親的家裏還有我們可得的分嗎？還有我們的產業嗎？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","我們不是被他當作外人嗎？因為他賣了我們，吞了我們的價值。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","上帝從我們父親所奪出來的一切財物，那就是我們和我們孩子們的。現今凡上帝所吩咐你的，你只管去行吧！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","雅各起來，使他的兒子和妻子都騎上駱駝， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","又帶着他在巴旦‧亞蘭所得的一切牲畜和財物，往迦南地、他父親以撒那裏去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","當時拉班剪羊毛去了，拉結偷了他父親家中的神像。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","雅各背着亞蘭人拉班偷走了，並不告訴他， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","就帶着所有的逃跑。他起身過大河，面向基列山行去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","到第三日，有人告訴拉班，雅各逃跑了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","拉班帶領他的眾弟兄去追趕，追了七日，在基列山就追上了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","夜間，上帝到亞蘭人拉班那裏，在夢中對他說：「你要小心，不可與雅各說好說歹。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","拉班追上雅各。雅各在山上支搭帳棚；拉班和他的眾弟兄也在基列山上支搭帳棚。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","拉班對雅各說：「你做的是甚麼事呢？你背着我偷走了，又把我的女兒們帶了去，如同用刀劍擄去的一般。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","你為甚麼暗暗地逃跑，偷着走，並不告訴我，叫我可以歡樂、唱歌、擊鼓、彈琴地送你回去？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","又不容我與外孫和女兒親嘴？你所行的真是愚昧！ ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","我手中原有能力害你，只是你父親的上帝昨夜對我說：『你要小心，不可與雅各說好說歹。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","現在你雖然想你父家，不得不去，為甚麼又偷了我的神像呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","雅各回答拉班說：「恐怕你把你的女兒從我奪去，所以我逃跑。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","至於你的神像，你在誰那裏搜出來，就不容誰存活。當着我們的眾弟兄，你認一認，在我這裏有甚麼東西是你的，就拿去。」原來雅各不知道拉結偷了那些神像。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","拉班進了雅各、利亞，並兩個使女的帳棚，都沒有搜出來，就從利亞的帳棚出來，進了拉結的帳棚。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","拉結已經把神像藏在駱駝的馱簍裏，便坐在上頭。拉班摸遍了那帳棚，並沒有摸着。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","拉結對她父親說：「現在我身上不便，不能在你面前起來，求我主不要生氣。」這樣，拉班搜尋神像，竟沒有搜出來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","雅各就發怒斥責拉班說：「我有甚麼過犯，有甚麼罪惡，你竟這樣火速地追我？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","你摸遍了我一切的家具，你搜出甚麼來呢？可以放在你我弟兄面前，叫他們在你我中間辨別辨別。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","我在你家這二十年，你的母綿羊、母山羊沒有掉過胎。你群中的公羊，我沒有吃過； ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","被野獸撕裂的，我沒有帶來給你，是我自己賠上。無論是白日，是黑夜，被偷去的，你都向我索要。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","我白日受盡乾熱，黑夜受盡寒霜，不得合眼睡着，我常是這樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","我這二十年在你家裏，為你的兩個女兒服事你十四年，為你的羊群服事你六年，你又十次改了我的工價。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","若不是我父親以撒所敬畏的上帝，就是亞伯拉罕的上帝與我同在，你如今必定打發我空手而去。上帝看見我的苦情和我的勞碌，就在昨夜責備你。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","拉班回答雅各說：「這女兒是我的女兒，這些孩子是我的孩子，這些羊群也是我的羊群；凡在你眼前的都是我的。我的女兒並她們所生的孩子，我今日能向他們做甚麼呢？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","來吧！你我二人可以立約，作你我中間的證據。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","雅各就拿一塊石頭立作柱子， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","又對眾弟兄說：「你們堆聚石頭。」他們就拿石頭來堆成一堆，大家便在旁邊吃喝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","拉班稱那石堆為伊迦爾‧撒哈杜他，雅各卻稱那石堆為迦累得。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","拉班說：「今日這石堆作你我中間的證據。」因此這地方名叫迦累得， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","又叫米斯巴，意思說：「我們彼此離別以後，願耶和華在你我中間鑒察。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","你若苦待我的女兒，又在我的女兒以外另娶妻，雖沒有人知道，卻有上帝在你我中間作見證。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","拉班又說：「你看我在你我中間所立的這石堆和柱子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","這石堆作證據，這柱子也作證據。我必不過這石堆去害你；你也不可過這石堆和柱子來害我。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","但願亞伯拉罕的上帝和拿鶴的上帝，就是他們父親的上帝，在你我中間判斷。」雅各就指着他父親以撒所敬畏的上帝起誓， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","又在山上獻祭，請眾弟兄來吃飯。他們吃了飯，便在山上住宿。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","拉班清早起來，與他外孫和女兒親嘴，給他們祝福，回往自己的地方去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","雅各仍舊行路，上帝的使者遇見他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","雅各看見他們就說：「這是上帝的軍兵」，於是給那地方起名叫瑪哈念。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","雅各打發人先往西珥地去，就是以東地，見他哥哥以掃， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","吩咐他們說：「你們對我主以掃說：『你的僕人雅各這樣說：我在拉班那裏寄居，直到如今。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","我有牛、驢、羊群、僕婢，現在打發人來報告我主，為要在你眼前蒙恩。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","所打發的人回到雅各那裏，說：「我們到了你哥哥以掃那裏，他帶着四百人，正迎着你來。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","雅各就甚懼怕，而且愁煩，便把那與他同在的人口和羊群、牛群、駱駝分做兩隊， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","說：「以掃若來擊殺這一隊，剩下的那一隊還可以逃避。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","雅各說：「耶和華－我祖亞伯拉罕的上帝，我父親以撒的上帝啊，你曾對我說：『回你本地本族去，我要厚待你。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","你向僕人所施的一切慈愛和誠實，我一點也不配得；我先前只拿着我的杖過這約旦河，如今我卻成了兩隊了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","求你救我脫離我哥哥以掃的手；因為我怕他來殺我，連妻子帶兒女一同殺了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","你曾說：『我必定厚待你，使你的後裔如同海邊的沙，多得不可勝數。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","當夜，雅各在那裏住宿，就從他所有的物中拿禮物要送給他哥哥以掃： ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","母山羊二百隻，公山羊二十隻，母綿羊二百隻，公綿羊二十隻， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","奶崽子的駱駝三十隻－各帶着崽子，母牛四十隻，公牛十隻，母驢二十匹，驢駒十匹； ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","每樣各分一群，交在僕人手下，就對僕人說：「你們要在我前頭過去，使群群相離，有空閒的地方」； ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","又吩咐儘先走的說：「我哥哥以掃遇見你的時候，問你說：『你是哪家的人？要往哪裏去？你前頭這些是誰的？』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","你就說：『是你僕人雅各的，是送給我主以掃的禮物；他自己也在我們後邊。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","又吩咐第二、第三，和一切趕群畜的人說：「你們遇見以掃的時候也要這樣對他說； ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","並且你們要說：『你僕人雅各在我們後邊。』」因雅各心裏說：「我藉着在我前頭去的禮物解他的恨，然後再見他的面，或者他容納我。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","於是禮物先過去了；那夜，雅各在隊中住宿。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","他夜間起來，帶着兩個妻子，兩個使女，並十一個兒子，都過了雅博渡口， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","先打發他們過河，又打發所有的都過去， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","只剩下雅各一人。有一個人來和他摔跤，直到黎明。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","那人見自己勝不過他，就將他的大腿窩摸了一把，雅各的大腿窩正在摔跤的時候就扭了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","那人說：「天黎明了，容我去吧！」雅各說：「你不給我祝福，我就不容你去。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","那人說：「你名叫甚麼？」他說：「我名叫雅各。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","那人說：「你的名不要再叫雅各，要叫以色列；因為你與上帝與人較力，都得了勝。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","雅各問他說：「請將你的名告訴我。」那人說：「何必問我的名？」於是在那裏給雅各祝福。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","雅各便給那地方起名叫毗努伊勒，意思說：「我面對面見了上帝，我的性命仍得保全。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","日頭剛出來的時候，雅各經過毗努伊勒，他的大腿就瘸了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","故此，以色列人不吃大腿窩的筋，直到今日，因為那人摸了雅各大腿窩的筋。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","雅各舉目觀看，見以掃來了，後頭跟着四百人，他就把孩子們分開交給利亞、拉結，和兩個使女， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","並且叫兩個使女和她們的孩子在前頭，利亞和她的孩子在後頭，拉結和約瑟在儘後頭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","他自己在他們前頭過去，一連七次俯伏在地才就近他哥哥。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","以掃跑來迎接他，將他抱住，又摟着他的頸項，與他親嘴，兩個人就哭了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","以掃舉目看見婦人孩子，就說：「這些和你同行的是誰呢？」雅各說：「這些孩子是上帝施恩給你的僕人的。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","於是兩個使女和她們的孩子前來下拜； ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","利亞和她的孩子也前來下拜；隨後約瑟和拉結也前來下拜。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","以掃說：「我所遇見的這些群畜是甚麼意思呢？」雅各說：「是要在我主面前蒙恩的。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","以掃說：「兄弟啊，我的已經夠了，你的仍歸你吧！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","雅各說：「不然，我若在你眼前蒙恩，就求你從我手裏收下這禮物；因為我見了你的面，如同見了上帝的面，並且你容納了我。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","求你收下我帶來給你的禮物；因為上帝恩待我，使我充足。」雅各再三地求他，他才收下了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","以掃說：「我們可以起身前往，我在你前頭走。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","雅各對他說：「我主知道孩子們年幼嬌嫩，牛羊也正在乳養的時候，若是催趕一天，群畜都必死了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","求我主在僕人前頭走，我要量着在我面前群畜和孩子的力量慢慢地前行，直走到西珥我主那裏。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","以掃說：「容我把跟隨我的人留幾個在你這裏。」雅各說：「何必呢？只要在我主眼前蒙恩就是了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","於是，以掃當日起行，回往西珥去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","雅各就往疏割去，在那裏為自己蓋造房屋，又為牲畜搭棚；因此那地方名叫疏割。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","雅各從巴旦‧亞蘭回來的時候，平平安安地到了迦南地的示劍城，在城東支搭帳棚， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","就用一百塊銀子向示劍的父親、哈抹的子孫買了支帳棚的那塊地， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","在那裏築了一座壇，起名叫伊利‧伊羅伊‧以色列 。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","利亞給雅各所生的女兒底拿出去，要見那地的女子們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","那地的主－希未人、哈抹的兒子示劍看見她，就拉住她，與她行淫，玷辱她。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","示劍的心繫戀雅各的女兒底拿，喜愛這女子，甜言蜜語地安慰她。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","示劍對他父親哈抹說：「求你為我聘這女子為妻。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","雅各聽見示劍玷污了他的女兒底拿。那時他的兒子們正和群畜在田野，雅各就閉口不言，等他們回來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","示劍的父親哈抹出來見雅各，要和他商議。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","雅各的兒子們聽見這事，就從田野回來，人人忿恨，十分惱怒；因示劍在以色列家做了醜事，與雅各的女兒行淫，這本是不該做的事。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","哈抹和他們商議說：「我兒子示劍的心戀慕這女子，求你們將她給我的兒子為妻。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","你們與我們彼此結親；你們可以把女兒給我們，也可以娶我們的女兒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","你們與我們同住吧！這地都在你們面前，只管在此居住，做買賣，置產業。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","示劍對女兒的父親和弟兄們說：「但願我在你們眼前蒙恩，你們向我要甚麼，我必給你們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","任憑向我要多重的聘金和禮物，我必照你們所說的給你們；只要把女子給我為妻。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","雅各的兒子們因為示劍玷污了他們的妹子底拿，就用詭詐的話回答示劍和他父親哈抹， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","對他們說：「我們不能把我們的妹子給沒有受割禮的人為妻，因為那是我們的羞辱。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","惟有一件才可以應允：若你們所有的男丁都受割禮，和我們一樣， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","我們就把女兒給你們，也娶你們的女兒；我們便與你們同住，兩下成為一樣的人民。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","倘若你們不聽從我們受割禮，我們就帶着妹子走了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","哈抹和他的兒子示劍喜歡這話。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","那少年人做這事並不遲延，因為他喜愛雅各的女兒；他在他父親家中也是人最尊重的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","哈抹和他兒子示劍到本城的門口，對本城的人說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","「這些人與我們和睦，不如許他們在這地居住，做買賣；這地也寬闊，足可容下他們。我們可以娶他們的女兒為妻，也可以把我們的女兒嫁給他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","惟有一件事我們必須做，他們才肯應允和我們同住，成為一樣的人民：就是我們中間所有的男丁都要受割禮，和他們一樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","他們的群畜、貨財，和一切的牲口豈不都歸我們嗎？只要依從他們，他們就與我們同住。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","凡從城門出入的人就都聽從哈抹和他兒子示劍的話；於是凡從城門出入的男丁都受了割禮。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","到第三天，眾人正在疼痛的時候，雅各的兩個兒子，就是底拿的哥哥西緬和利未，各拿刀劍，趁着眾人想不到的時候來到城中，把一切男丁都殺了， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","又用刀殺了哈抹和他兒子示劍，把底拿從示劍家裏帶出來就走了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","雅各的兒子們因為他們的妹子受了玷污，就來到被殺的人那裏，擄掠那城， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","奪了他們的羊群、牛群，和驢，並城裏田間所有的； ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","又把他們一切貨財、孩子、婦女，並各房中所有的，都擄掠去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","雅各對西緬和利未說：「你們連累我，使我在這地的居民中，就是在迦南人和比利洗人中，有了臭名。我的人丁既然稀少，他們必聚集來擊殺我，我和全家的人都必滅絕。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","他們說：「他豈可待我們的妹子如同妓女嗎？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","上帝對雅各說：「起來！上伯特利去，住在那裏；要在那裏築一座壇給上帝，就是你逃避你哥哥以掃的時候向你顯現的那位。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","雅各就對他家中的人並一切與他同在的人說：「你們要除掉你們中間的外邦神，也要自潔，更換衣裳。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","我們要起來，上伯特利去，在那裏我要築一座壇給上帝，就是在我遭難的日子應允我的禱告、在我行的路上保佑我的那位。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","他們就把外邦人的神像和他們耳朵上的環子交給雅各；雅各都藏在示劍那裏的橡樹底下。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","他們便起行前往。上帝使那周圍城邑的人都甚驚懼，就不追趕雅各的眾子了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","於是雅各和一切與他同在的人到了迦南地的路斯，就是伯特利。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","他在那裏築了一座壇，就給那地方起名叫伊勒‧伯特利；因為他逃避他哥哥的時候，上帝在那裏向他顯現。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","利百加的奶母底波拉死了，就葬在伯特利下邊橡樹底下；那棵樹名叫亞倫‧巴古。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","雅各從巴旦‧亞蘭回來，上帝又向他顯現，賜福與他， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","且對他說：「你的名原是雅各，從今以後不要再叫雅各，要叫以色列。」這樣，他就改名叫以色列。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","上帝又對他說：「我是全能的上帝；你要生養眾多，將來有一族和多國的民從你而生，又有君王從你而出。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","我所賜給亞伯拉罕和以撒的地，我要賜給你與你的後裔。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","上帝就從那與雅各說話的地方升上去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","雅各便在那裏立了一根石柱，在柱子上奠酒，澆油。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","雅各就給那地方起名叫伯特利。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","他們從伯特利起行，離以法他還有一段路程，拉結臨產甚是艱難。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","正在艱難的時候，收生婆對她說：「不要怕，你又要得一個兒子了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","她將近於死，靈魂要走的時候，就給她兒子起名叫便‧俄尼；他父親卻給他起名叫便雅憫。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","拉結死了，葬在以法他的路旁；以法他就是伯利恆。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","雅各在她的墳上立了一統碑，就是拉結的墓碑，到今日還在。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","以色列起行前往，在以得臺那邊支搭帳棚。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","以色列住在那地的時候，呂便去與他父親的妾辟拉同寢，以色列也聽見了。 雅各共有十二個兒子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","利亞所生的是雅各的長子呂便，還有西緬、利未、猶大、以薩迦、西布倫。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","拉結所生的是約瑟、便雅憫。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","拉結的使女辟拉所生的是但、拿弗他利。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","利亞的使女悉帕所生的是迦得、亞設。這是雅各在巴旦‧亞蘭所生的兒子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","雅各來到他父親以撒那裏，到了基列‧亞巴的幔利，乃是亞伯拉罕和以撒寄居的地方；基列‧亞巴就是希伯崙。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","以撒共活了一百八十歲。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","以撒年紀老邁，日子滿足，氣絕而死，歸到他列祖那裏。他兩個兒子以掃、雅各把他埋葬了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","以掃就是以東，他的後代記在下面。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","以掃娶迦南的女子為妻，就是赫人以倫的女兒亞大和希未人祭便的孫女、亞拿的女兒阿何利巴瑪， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","又娶了以實瑪利的女兒、尼拜約的妹子巴實抹。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","亞大給以掃生了以利法；巴實抹生了流珥； ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","阿何利巴瑪生了耶烏施、雅蘭、可拉。這都是以掃的兒子，是在迦南地生的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","以掃帶着他的妻子、兒女，與家中一切的人口，並他的牛羊、牲畜，和一切貨財，就是他在迦南地所得的，往別處去，離了他兄弟雅各。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","因為二人的財物群畜甚多，寄居的地方容不下他們，所以不能同居。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","於是以掃住在西珥山裏；以掃就是以東。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","以掃是西珥山裏以東人的始祖，他的後代記在下面。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","以掃眾子的名字如下。以掃的妻子亞大生以利法；以掃的妻子巴實抹生流珥。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","以利法的兒子是提幔、阿抹、洗玻、迦坦、基納斯。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","亭納是以掃兒子以利法的妾；她給以利法生了亞瑪力。這是以掃的妻子亞大的子孫。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","流珥的兒子是拿哈、謝拉、沙瑪、米撒。這是以掃妻子巴實抹的子孫。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","以掃的妻子阿何利巴瑪是祭便的孫女，亞拿的女兒；她給以掃生了耶烏施、雅蘭、可拉。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","以掃子孫中作族長的記在下面。以掃的長子以利法的子孫中，有提幔族長、阿抹族長、洗玻族長、基納斯族長、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","可拉族長、迦坦族長、亞瑪力族長。這是在以東地從以利法所出的族長，都是亞大的子孫。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","以掃的兒子流珥的子孫中，有拿哈族長、謝拉族長、沙瑪族長、米撒族長。這是在以東地從流珥所出的族長，都是以掃妻子巴實抹的子孫。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","以掃的妻子阿何利巴瑪的子孫中，有耶烏施族長、雅蘭族長、可拉族長。這是從以掃妻子，亞拿的女兒，阿何利巴瑪子孫中所出的族長。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","以上的族長都是以掃的子孫；以掃就是以東。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","那地原有的居民－何利人西珥的子孫記在下面：就是羅坍、朔巴、祭便、亞拿、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","底順、以察、底珊。這是從以東地的何利人西珥子孫中所出的族長。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","羅坍的兒子是何利、希幔；羅坍的妹子是亭納。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","朔巴的兒子是亞勒文、瑪拿轄、以巴錄、示玻、阿南。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","祭便的兒子是亞雅、亞拿（當時在曠野放他父親祭便的驢，遇着溫泉的，就是這亞拿）。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","亞拿的兒子是底順；亞拿的女兒是阿何利巴瑪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","底順的兒子是欣但、伊是班、益蘭、基蘭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","以察的兒子是辟罕、撒番、亞干。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","底珊的兒子是烏斯、亞蘭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","從何利人所出的族長記在下面：就是羅坍族長、朔巴族長、祭便族長、亞拿族長、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","底順族長、以察族長、底珊族長。這是從何利人所出的族長，都在西珥地，按着宗族作族長。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","以色列人未有君王治理以先，在以東地作王的記在下面。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","比珥的兒子比拉在以東作王，他的京城名叫亭哈巴。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","比拉死了，波斯拉人謝拉的兒子約巴接續他作王。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","約巴死了，提幔地的人戶珊接續他作王。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","戶珊死了，比達的兒子哈達接續他作王；這哈達就是在摩押地殺敗米甸人的，他的京城名叫亞未得。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","哈達死了，瑪士利加人桑拉接續他作王。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","桑拉死了，大河邊的利河伯人掃羅接續他作王。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","掃羅死了，亞革波的兒子巴勒‧哈南接續他作王。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","亞革波的兒子巴勒‧哈南死了，哈達接續他作王，他的京城名叫巴烏；他的妻子名叫米希她別，是米‧薩合的孫女，瑪特列的女兒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","從以掃所出的族長，按着他們的宗族、住處、名字記在下面：就是亭納族長、亞勒瓦族長、耶帖族長、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","阿何利巴瑪族長、以拉族長、比嫩族長、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","基納斯族長、提幔族長、米比薩族長、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","瑪基疊族長、以蘭族長。這是以東人在所得為業的地上，按着他們的住處。（所有的族長都是以東人的始祖以掃的後代。） ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","雅各住在迦南地，就是他父親寄居的地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","雅各的記略如下。 約瑟十七歲與他哥哥們一同牧羊。他是個童子，與他父親的妾辟拉、悉帕的兒子們常在一處。約瑟將他哥哥們的惡行報給他們的父親。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","以色列原來愛約瑟過於愛他的眾子，因為約瑟是他年老生的；他給約瑟做了一件彩衣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","約瑟的哥哥們見父親愛約瑟過於愛他們，就恨約瑟，不與他說和睦的話。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","約瑟做了一夢，告訴他哥哥們，他們就越發恨他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","約瑟對他們說：「請聽我所做的夢： ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","我們在田裏捆禾稼，我的捆起來站着，你們的捆來圍着我的捆下拜。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","他的哥哥們回答說：「難道你真要作我們的王嗎？難道你真要管轄我們嗎？」他們就因為他的夢和他的話越發恨他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","後來他又做了一夢，也告訴他的哥哥們說：「看哪，我又做了一夢，夢見太陽、月亮，與十一個星向我下拜。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","約瑟將這夢告訴他父親和他哥哥們，他父親就責備他說：「你做的這是甚麼夢！難道我和你母親、你弟兄果然要來俯伏在地，向你下拜嗎？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","他哥哥們都嫉妒他，他父親卻把這話存在心裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","約瑟的哥哥們往示劍去放他們父親的羊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","以色列對約瑟說：「你哥哥們不是在示劍放羊嗎？你來，我要打發你往他們那裏去。」約瑟說：「我在這裏。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","以色列說：「你去看看你哥哥們平安不平安，群羊平安不平安，就回來報信給我」；於是打發他出希伯崙谷，他就往示劍去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","有人遇見他在田野走迷了路，就問他說：「你找甚麼？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","他說：「我找我的哥哥們，求你告訴我，他們在何處放羊。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","那人說：「他們已經走了，我聽見他們說要往多坍去。」約瑟就去追趕他哥哥們，遇見他們在多坍。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","他們遠遠地看見他，趁他還沒有走到跟前，大家就同謀要害死他， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","彼此說：「你看！那做夢的來了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","來吧！我們將他殺了，丟在一個坑裏，就說有惡獸把他吃了。我們且看他的夢將來怎麼樣。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","呂便聽見了，要救他脫離他們的手，說：「我們不可害他的性命」； ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","又說：「不可流他的血，可以把他丟在這野地的坑裏，不可下手害他。」呂便的意思是要救他脫離他們的手，把他歸還他的父親。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","約瑟到了他哥哥們那裏，他們就剝了他的外衣，就是他穿的那件彩衣， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","把他丟在坑裏；那坑是空的，裏頭沒有水。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","他們坐下吃飯，舉目觀看，見有一夥米甸 的以實瑪利人從基列來，用駱駝馱着香料、乳香、沒藥，要帶下埃及去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","猶大對眾弟兄說：「我們殺我們的兄弟，藏了他的血有甚麼益處呢？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","我們不如將他賣給以實瑪利人，不可下手害他；因為他是我們的兄弟，我們的骨肉。」眾弟兄就聽從了他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","有些米甸的商人從那裏經過，哥哥們就把約瑟從坑裏拉上來，講定二十舍客勒銀子，把約瑟賣給以實瑪利人。他們就把約瑟帶到埃及去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","呂便回到坑邊，見約瑟不在坑裏，就撕裂衣服， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","回到兄弟們那裏，說：「童子沒有了。我往哪裏去才好呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","他們宰了一隻公山羊，把約瑟的那件彩衣染了血， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","打發人送到他們的父親那裏，說：「我們撿了這個；請認一認是你兒子的外衣不是？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","他認得，就說：「這是我兒子的外衣。有惡獸把他吃了，約瑟被撕碎了！撕碎了！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","雅各便撕裂衣服，腰間圍上麻布，為他兒子悲哀了多日。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","他的兒女都起來安慰他，他卻不肯受安慰，說：「我必悲哀着下陰間，到我兒子那裏。」約瑟的父親就為他哀哭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","米甸人帶約瑟到埃及，把他賣給法老的內臣－護衛長波提乏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","那時，猶大離開他弟兄下去，到一個亞杜蘭人名叫希拉的家裏去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","猶大在那裏看見一個迦南人名叫書亞的女兒，就娶她為妻，與她同房， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","她就懷孕生了兒子，猶大給他起名叫珥。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","她又懷孕生了兒子，母親給他起名叫俄南。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","她復又生了兒子，給他起名叫示拉。她生示拉的時候，猶大正在基悉。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","猶大為長子珥娶妻，名叫她瑪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","猶大的長子珥在耶和華眼中看為惡，耶和華就叫他死了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","猶大對俄南說：「你當與你哥哥的妻子同房，向她盡你為弟的本分，為你哥哥生子立後。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","俄南知道生子不歸自己，所以同房的時候便遺在地，免得給他哥哥留後。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","俄南所做的在耶和華眼中看為惡，耶和華也就叫他死了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","猶大心裏說：「恐怕示拉也死，像他兩個哥哥一樣」，就對他兒婦她瑪說：「你去，在你父親家裏守寡，等我兒子示拉長大。」她瑪就回去，住在她父親家裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","過了許久，猶大的妻子書亞的女兒死了。猶大得了安慰，就和他朋友亞杜蘭人希拉上亭拿去，到他剪羊毛的人那裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","有人告訴她瑪說：「你的公公上亭拿剪羊毛去了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","她瑪見示拉已經長大，還沒有娶她為妻，就脫了她作寡婦的衣裳，用帕子蒙着臉，又遮住身體，坐在亭拿路上的伊拿印城門口。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","猶大看見她，以為是妓女，因為她蒙着臉。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","猶大就轉到她那裏去，說：「來吧！讓我與你同寢。」他原不知道是他的兒婦。她瑪說：「你要與我同寢，把甚麼給我呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","猶大說：「我從羊群裏取一隻山羊羔，打發人送來給你。」她瑪說：「在未送以先，你願意給我一個當頭嗎？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","他說：「我給你甚麼當頭呢？」她瑪說：「你的印、你的帶子，和你手裏的杖。」猶大就給了她，與她同寢，她就從猶大懷了孕。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","她瑪起來走了，除去帕子，仍舊穿上作寡婦的衣裳。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","猶大託他朋友亞杜蘭人送一隻山羊羔去，要從那女人手裏取回當頭來，卻找不着她， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","就問那地方的人說：「伊拿印路旁的妓女在哪裏？」他們說：「這裏並沒有妓女。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","他回去見猶大說：「我沒有找着她，並且那地方的人說：『這裏沒有妓女。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","猶大說：「我把這山羊羔送去了，你竟找不着她。任憑她拿去吧，免得我們被羞辱。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","約過了三個月，有人告訴猶大說：「你的兒婦她瑪作了妓女，且因行淫有了身孕。」猶大說：「拉出她來，把她燒了！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","她瑪被拉出來的時候便打發人去見她公公，對他說：「這些東西是誰的，我就是從誰懷的孕。請你認一認，這印和帶子並杖都是誰的？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","猶大承認說：「她比我更有義，因為我沒有將她給我的兒子示拉。」從此猶大不再與她同寢了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","她瑪將要生產，不料她腹裏是一對雙生。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","到生產的時候，一個孩子伸出一隻手來；收生婆拿紅線拴在他手上，說：「這是頭生的。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","隨後這孩子把手收回去，他哥哥生出來了；收生婆說：「你為甚麼搶着來呢？」因此給他起名叫法勒斯。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","後來，他兄弟那手上有紅線的也生出來，就給他起名叫謝拉。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","約瑟被帶下埃及去。有一個埃及人，是法老的內臣－護衛長波提乏，從那些帶下他來的以實瑪利人手下買了他去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","約瑟住在他主人埃及人的家中，耶和華與他同在，他就百事順利。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","他主人見耶和華與他同在，又見耶和華使他手裏所辦的盡都順利， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","約瑟就在主人眼前蒙恩，伺候他主人，並且主人派他管理家務，把一切所有的都交在他手裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","自從主人派約瑟管理家務和他一切所有的，耶和華就因約瑟的緣故賜福與那埃及人的家；凡家裏和田間一切所有的都蒙耶和華賜福。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","波提乏將一切所有的都交在約瑟的手中，除了自己所吃的飯，別的事一概不知。 約瑟原來秀雅俊美。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","這事以後，約瑟主人的妻以目送情給約瑟，說：「你與我同寢吧！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","約瑟不從，對他主人的妻說：「看哪，一切家務，我主人都不知道；他把所有的都交在我手裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","在這家裏沒有比我大的；並且他沒有留下一樣不交給我，只留下了你，因為你是他的妻子。我怎能作這大惡，得罪上帝呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","後來她天天和約瑟說，約瑟卻不聽從她，不與她同寢，也不和她在一處。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","有一天，約瑟進屋裏去辦事，家中人沒有一個在那屋裏， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","婦人就拉住他的衣裳，說：「你與我同寢吧！」約瑟把衣裳丟在婦人手裏，跑到外邊去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","婦人看見約瑟把衣裳丟在她手裏跑出去了， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","就叫了家裏的人來，對他們說：「你們看！他帶了一個希伯來人進入我們家裏，要戲弄我們。他到我這裏來，要與我同寢，我就大聲喊叫。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","他聽見我放聲喊起來，就把衣裳丟在我這裏，跑到外邊去了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","婦人把約瑟的衣裳放在自己那裏，等着他主人回家， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","就對他如此如此說：「你所帶到我們這裏的那希伯來僕人進來要戲弄我， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","我放聲喊起來，他就把衣裳丟在我這裏，跑出去了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","約瑟的主人聽見他妻子對他所說的話，說「你的僕人如此如此待我」，他就生氣， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","把約瑟下在監裏，就是王的囚犯被囚的地方。於是約瑟在那裏坐監。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","但耶和華與約瑟同在，向他施恩，使他在司獄的眼前蒙恩。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","司獄就把監裏所有的囚犯都交在約瑟的手下；他們在那裏所辦的事都是經他的手。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","凡在約瑟手下的事，司獄一概不察，因為耶和華與約瑟同在；耶和華使他所做的盡都順利。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","這事以後，埃及王的酒政和膳長得罪了他們的主－埃及王， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","法老就惱怒酒政和膳長這二臣， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","把他們下在護衛長府內的監裏，就是約瑟被囚的地方。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","護衛長把他們交給約瑟，約瑟便伺候他們；他們有些日子在監裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","被囚在監之埃及王的酒政和膳長二人同夜各做一夢，各夢都有講解。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","到了早晨，約瑟進到他們那裏，見他們有愁悶的樣子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","他便問法老的二臣，就是與他同囚在他主人府裏的，說：「你們今日為甚麼面帶愁容呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","他們對他說：「我們各人做了一夢，沒有人能解。」約瑟說：「解夢不是出於上帝嗎？請你們將夢告訴我。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","酒政便將他的夢告訴約瑟說：「我夢見在我面前有一棵葡萄樹， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","樹上有三根枝子，好像發了芽，開了花，上頭的葡萄都成熟了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","法老的杯在我手中，我就拿葡萄擠在法老的杯裏，將杯遞在他手中。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","約瑟對他說：「你所做的夢是這樣解：三根枝子就是三天； ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","三天之內，法老必提你出監，叫你官復原職，你仍要遞杯在法老的手中，和先前作他的酒政一樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","但你得好處的時候，求你記念我，施恩與我，在法老面前提說我，救我出這監牢。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","我實在是從希伯來人之地被拐來的；我在這裏也沒有做過甚麼，叫他們把我下在監裏。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","膳長見夢解得好，就對約瑟說：「我在夢中見我頭上頂着三筐白餅； ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","極上的筐子裏有為法老烤的各樣食物，有飛鳥來吃我頭上筐子裏的食物。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","約瑟說：「你的夢是這樣解：三個筐子就是三天； ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","三天之內，法老必斬斷你的頭，把你掛在木頭上，必有飛鳥來吃你身上的肉。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","到了第三天，是法老的生日，他為眾臣僕設擺筵席，把酒政和膳長提出監來， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","使酒政官復原職，他仍舊遞杯在法老手中； ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","但把膳長掛起來，正如約瑟向他們所解的話。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","酒政卻不記念約瑟，竟忘了他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","過了兩年，法老做夢，夢見自己站在河邊， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","有七隻母牛從河裏上來，又美好又肥壯，在蘆荻中吃草。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","隨後又有七隻母牛從河裏上來，又醜陋又乾瘦，與那七隻母牛一同站在河邊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","這又醜陋又乾瘦的七隻母牛吃盡了那又美好又肥壯的七隻母牛。法老就醒了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","他又睡着，第二回做夢，夢見一棵麥子長了七個穗子，又肥大又佳美， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","隨後又長了七個穗子，又細弱又被東風吹焦了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","這細弱的穗子吞了那七個又肥大又飽滿的穗子。法老醒了，不料是個夢。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","到了早晨，法老心裏不安，就差人召了埃及所有的術士和博士來；法老就把所做的夢告訴他們，卻沒有人能給法老圓解。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","那時酒政對法老說：「我今日想起我的罪來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","從前法老惱怒臣僕，把我和膳長下在護衛長府內的監裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","我們二人同夜各做一夢，各夢都有講解。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","在那裏同着我們有一個希伯來的少年人，是護衛長的僕人，我們告訴他，他就把我們的夢圓解，是按着各人的夢圓解的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","後來正如他給我們圓解的成就了：我官復原職，膳長被掛起來了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","法老遂即差人去召約瑟，他們便急忙帶他出監，他就剃頭，刮臉，換衣裳，進到法老面前。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","法老對約瑟說：「我做了一夢，沒有人能解；我聽見人說，你聽了夢就能解。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","約瑟回答法老說：「這不在乎我，上帝必將平安的話回答法老。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","法老對約瑟說：「我夢見我站在河邊， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","有七隻母牛從河裏上來，又肥壯又美好，在蘆荻中吃草。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","隨後又有七隻母牛上來，又軟弱又醜陋又乾瘦，在埃及遍地，我沒有見過這樣不好的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","這又乾瘦又醜陋的母牛吃盡了那以先的七隻肥母牛， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","吃了以後卻看不出是吃了，那醜陋的樣子仍舊和先前一樣。我就醒了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","我又夢見一棵麥子，長了七個穗子，又飽滿又佳美， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","隨後又長了七個穗子，枯槁細弱，被東風吹焦了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","這些細弱的穗子吞了那七個佳美的穗子。我將這夢告訴了術士，卻沒有人能給我解說。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","約瑟對法老說：「法老的夢乃是一個。上帝已將所要做的事指示法老了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","七隻好母牛是七年，七個好穗子也是七年；這夢乃是一個。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","那隨後上來的七隻又乾瘦又醜陋的母牛是七年，那七個虛空、被東風吹焦的穗子也是七年，都是七個荒年。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","這就是我對法老所說，上帝已將所要做的事顯明給法老了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","埃及遍地必來七個大豐年， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","隨後又要來七個荒年，甚至在埃及地都忘了先前的豐收，全地必被饑荒所滅。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","因那以後的饑荒甚大，便不覺得先前的豐收了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","至於法老兩回做夢，是因上帝命定這事，而且必速速成就。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","所以，法老當揀選一個有聰明有智慧的人，派他治理埃及地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","法老當這樣行，又派官員管理這地。當七個豐年的時候，征收埃及地的五分之一， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","叫他們把將來豐年一切的糧食聚斂起來，積蓄五穀，收存在各城裏做食物，歸於法老的手下。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","所積蓄的糧食可以防備埃及地將來的七個荒年，免得這地被饑荒所滅。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","法老和他一切臣僕都以這事為妙。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","法老對臣僕說：「像這樣的人，有上帝的靈在他裏頭，我們豈能找得着呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","法老對約瑟說：「上帝既將這事都指示你，可見沒有人像你這樣有聰明有智慧。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","你可以掌管我的家；我的民都必聽從你的話。惟獨在寶座上我比你大。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","法老又對約瑟說：「我派你治理埃及全地。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","法老就摘下手上打印的戒指，戴在約瑟的手上，給他穿上細麻衣，把金鍊戴在他的頸項上， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","又叫約瑟坐他的副車，喝道的在前呼叫說：「跪下。」這樣，法老派他治理埃及全地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","法老對約瑟說：「我是法老，在埃及全地，若沒有你的命令，不許人擅自辦事。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","法老賜名給約瑟，叫撒發那忒‧巴內亞，又將安城的祭司波提非拉的女兒亞西納給他為妻。約瑟就出去巡行埃及地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","約瑟見埃及王法老的時候年三十歲。他從法老面前出去，遍行埃及全地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","七個豐年之內，地的出產極豐極盛， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","約瑟聚斂埃及地七個豐年一切的糧食，把糧食積存在各城裏；各城周圍田地的糧食都積存在本城裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","約瑟積蓄五穀甚多，如同海邊的沙，無法計算，因為穀不可勝數。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","荒年未到以前，安城的祭司波提非拉的女兒亞西納給約瑟生了兩個兒子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","約瑟給長子起名叫瑪拿西，因為他說：「上帝使我忘了一切的困苦和我父的全家。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","他給次子起名叫以法蓮，因為他說：「上帝使我在受苦的地方昌盛。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","埃及地的七個豐年一完， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","七個荒年就來了。正如約瑟所說的，各地都有饑荒；惟獨埃及全地有糧食。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","及至埃及全地有了饑荒，眾民向法老哀求糧食，法老對他們說：「你們往約瑟那裏去，凡他所說的，你們都要做。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","當時饑荒遍滿天下，約瑟開了各處的倉，糶糧給埃及人；在埃及地饑荒甚大。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","各地的人都往埃及去，到約瑟那裏糴糧，因為天下的饑荒甚大。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","雅各見埃及有糧，就對兒子們說：「你們為甚麼彼此觀望呢？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","我聽見埃及有糧，你們可以下去，從那裏為我們糴些來，使我們可以存活，不至於死。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","於是，約瑟的十個哥哥都下埃及糴糧去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","但約瑟的兄弟便雅憫，雅各沒有打發他和哥哥們同去，因為雅各說：「恐怕他遭害。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","來糴糧的人中有以色列的兒子們，因為迦南地也有饑荒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","當時治理埃及地的是約瑟；糶糧給那地眾民的就是他。約瑟的哥哥們來了，臉伏於地，向他下拜。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","約瑟看見他哥哥們，就認得他們，卻裝作生人，向他們說些嚴厲話，問他們說：「你們從哪裏來？」他們說：「我們從迦南地來糴糧。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","約瑟認得他哥哥們，他們卻不認得他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","約瑟想起從前所做的那兩個夢，就對他們說：「你們是奸細，來窺探這地的虛實。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","他們對他說：「我主啊，不是的。僕人們是糴糧來的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","我們都是一個人的兒子，是誠實人；僕人們並不是奸細。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","約瑟說：「不然，你們必是窺探這地的虛實來的。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","他們說：「僕人們本是弟兄十二人，是迦南地一個人的兒子，頂小的現今在我們的父親那裏，有一個沒有了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","約瑟說：「我才說你們是奸細，這話實在不錯。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","我指着法老的性命起誓，若是你們的小兄弟不到這裏來，你們就不得出這地方，從此就可以把你們證驗出來了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","須要打發你們中間一個人去，把你們的兄弟帶來。至於你們，都要囚在這裏，好證驗你們的話真不真，若不真，我指着法老的性命起誓，你們一定是奸細。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","於是約瑟把他們都下在監裏三天。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","到第三天，約瑟對他們說：「我是敬畏上帝的；你們照我的話行就可以存活。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","你們如果是誠實人，可以留你們中間的一個人囚在監裏，但你們可以帶着糧食回去，救你們家裏的饑荒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","把你們的小兄弟帶到我這裏來，如此，你們的話便有證據，你們也不至於死。」他們就照樣而行。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","他們彼此說：「我們在兄弟身上實在有罪。他哀求我們的時候，我們見他心裏的愁苦，卻不肯聽，所以這場苦難臨到我們身上。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","呂便說：「我豈不是對你們說過，不可傷害那孩子嗎？只是你們不肯聽，所以流他血的罪向我們追討。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","他們不知道約瑟聽得出來，因為在他們中間用通事傳話。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","約瑟轉身退去，哭了一場，又回來對他們說話，就從他們中間挑出西緬來，在他們眼前把他捆綁。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","約瑟吩咐人把糧食裝滿他們的器具，把各人的銀子歸還在各人的口袋裏，又給他們路上用的食物，人就照他的話辦了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","他們就把糧食馱在驢上，離開那裏去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","到了住宿的地方，他們中間有一個人打開口袋，要拿料餵驢，才看見自己的銀子仍在口袋裏， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","就對弟兄們說：「我的銀子歸還了，看哪，仍在我口袋裏！」他們就提心吊膽，戰戰兢兢地彼此說：「這是上帝向我們做甚麼呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","他們來到迦南地、他們的父親雅各那裏，將所遭遇的事都告訴他，說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","「那地的主對我們說嚴厲的話，把我們當作窺探那地的奸細。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","我們對他說：『我們是誠實人，並不是奸細。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","我們本是弟兄十二人，都是一個父親的兒子，有一個沒有了，頂小的如今同我們的父親在迦南地。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","那地的主對我們說：『若要我知道你們是誠實人，可以留下你們中間的一個人在我這裏，你們可以帶着糧食回去，救你們家裏的饑荒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","把你們的小兄弟帶到我這裏來，我便知道你們不是奸細，乃是誠實人。這樣，我就把你們的弟兄交給你們，你們也可以在這地做買賣。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","後來他們倒口袋，不料，各人的銀包都在口袋裏；他們和父親看見銀包就都害怕。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","他們的父親雅各對他們說：「你們使我喪失我的兒子：約瑟沒有了，西緬也沒有了，你們又要將便雅憫帶去；這些事都歸到我身上了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","呂便對他父親說：「我若不帶他回來交給你，你可以殺我的兩個兒子。只管把他交在我手裏，我必帶他回來交給你。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","雅各說：「我的兒子不可與你們一同下去；他哥哥死了，只剩下他，他若在你們所行的路上遭害，那便是你們使我白髮蒼蒼、悲悲慘慘地下陰間去了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","那地的饑荒甚大。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","他們從埃及帶來的糧食吃盡了，他們的父親就對他們說：「你們再去給我糴些糧來。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","猶大對他說：「那人諄諄地告誡我們說：『你們的兄弟若不與你們同來，你們就不得見我的面。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","你若打發我們的兄弟與我們同去，我們就下去給你糴糧； ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","你若不打發他去，我們就不下去，因為那人對我們說：『你們的兄弟若不與你們同來，你們就不得見我的面。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","以色列說：「你們為甚麼這樣害我，告訴那人你們還有兄弟呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","他們回答說：「那人詳細問到我們和我們的親屬，說：『你們的父親還在嗎？你們還有兄弟嗎？』我們就按着他所問的告訴他，焉能知道他要說『必須把你們的兄弟帶下來』呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","猶大又對他父親以色列說：「你打發童子與我同去，我們就起身下去，好叫我們和你，並我們的婦人孩子，都得存活，不至於死。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","我為他作保；你可以從我手中追討，我若不帶他回來交在你面前，我情願永遠擔罪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","我們若沒有耽擱，如今第二次都回來了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","他們的父親以色列說：「若必須如此，你們就當這樣行：可以將這地土產中最好的乳香、蜂蜜、香料、沒藥、榧子、杏仁都取一點，收在器具裏，帶下去送給那人作禮物， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","又要手裏加倍地帶銀子，並將歸還在你們口袋內的銀子仍帶在手裏；那或者是錯了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","也帶着你們的兄弟，起身去見那人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","但願全能的上帝使你們在那人面前蒙憐憫，釋放你們的那弟兄和便雅憫回來。我若喪了兒子，就喪了吧！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","於是，他們拿着那禮物，又手裏加倍地帶銀子，並且帶着便雅憫，起身下到埃及，站在約瑟面前。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","約瑟見便雅憫和他們同來，就對家宰說：「將這些人領到屋裏。要宰殺牲畜，預備筵席，因為晌午這些人同我吃飯。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","家宰就遵着約瑟的命去行，領他們進約瑟的屋裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","他們因為被領到約瑟的屋裏，就害怕，說：「領我們到這裏來，必是因為頭次歸還在我們口袋裏的銀子，找我們的錯縫，下手害我們，強取我們為奴僕，搶奪我們的驢。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","他們就挨近約瑟的家宰，在屋門口和他說話， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","說：「我主啊，我們頭次下來實在是要糴糧。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","後來到了住宿的地方，我們打開口袋，不料，各人的銀子，分量足數，仍在各人的口袋內，現在我們手裏又帶回來了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","另外又帶下銀子來糴糧。不知道先前誰把銀子放在我們的口袋裏。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","家宰說：「你們可以放心，不要害怕，是你們的上帝和你們父親的上帝賜給你們財寶在你們的口袋裏；你們的銀子，我早已收了。」他就把西緬帶出來，交給他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","家宰就領他們進約瑟的屋裏，給他們水洗腳，又給他們草料餵驢。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","他們就預備那禮物，等候約瑟晌午來，因為他們聽見要在那裏吃飯。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","約瑟來到家裏，他們就把手中的禮物拿進屋去給他，又俯伏在地，向他下拜。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","約瑟問他們好，又問：「你們的父親－就是你們所說的那老人家平安嗎？他還在嗎？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","他們回答說：「你僕人－我們的父親平安；他還在。」於是他們低頭下拜。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","約瑟舉目看見他同母的兄弟便雅憫，就說：「你們向我所說那頂小的兄弟就是這位嗎？」又說：「小兒啊，願上帝賜恩給你！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","約瑟愛弟之情發動，就急忙尋找可哭之地，進入自己的屋裏，哭了一場。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","他洗了臉出來，勉強隱忍，吩咐人擺飯。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","他們就為約瑟單擺了一席，為那些人又擺了一席，也為和約瑟同吃飯的埃及人另擺了一席，因為埃及人不可和希伯來人一同吃飯；那原是埃及人所厭惡的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","約瑟使眾弟兄在他面前排列坐席，都按着長幼的次序，眾弟兄就彼此詫異。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","約瑟把他面前的食物分出來，送給他們；但便雅憫所得的比別人多五倍。他們就飲酒，和約瑟一同宴樂。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","約瑟吩咐家宰說：「把糧食裝滿這些人的口袋，儘着他們的驢所能馱的，又把各人的銀子放在各人的口袋裏， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","並將我的銀杯和那少年人糴糧的銀子一同裝在他的口袋裏。」家宰就照約瑟所說的話行了； ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","天一亮就打發那些人帶着驢走了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","他們出城走了不遠，約瑟對家宰說：「起來，追那些人去，追上了就對他們說：『你們為甚麼以惡報善呢？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","這不是我主人飲酒的杯嗎？豈不是他占卜用的嗎？你們這樣行是作惡了。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","家宰追上他們，將這些話對他們說了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","他們回答說：「我主為甚麼說這樣的話呢？你僕人斷不能做這樣的事。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","你看，我們從前在口袋裏所見的銀子，尚且從迦南地帶來還你，我們怎能從你主人家裏偷竊金銀呢？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","你僕人中無論在誰那裏搜出來，就叫他死，我們也作我主的奴僕。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","家宰說：「現在就照你們的話行吧！在誰那裏搜出來，誰就作我的奴僕；其餘的都沒有罪。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","於是他們各人急忙把口袋卸在地下，各人打開口袋。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","家宰就搜查，從年長的起到年幼的為止，那杯竟在便雅憫的口袋裏搜出來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","他們就撕裂衣服，各人把馱子抬在驢上，回城去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","猶大和他弟兄們來到約瑟的屋中，約瑟還在那裏，他們就在他面前俯伏於地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","約瑟對他們說：「你們做的是甚麼事呢？你們豈不知像我這樣的人必能占卜嗎？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","猶大說：「我們對我主說甚麼呢？還有甚麼話可說呢？我們怎能自己表白出來呢？上帝已經查出僕人的罪孽了。我們與那在他手中搜出杯來的都是我主的奴僕。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","約瑟說：「我斷不能這樣行！在誰的手中搜出杯來，誰就作我的奴僕；至於你們，可以平平安安地上你們父親那裏去。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","猶大挨近他，說：「我主啊，求你容僕人說一句話給我主聽，不要向僕人發烈怒，因為你如同法老一樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","我主曾問僕人們說：『你們有父親有兄弟沒有？』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","我們對我主說：『我們有父親，已經年老，還有他老年所生的一個小孩子。他哥哥死了，他母親只撇下他一人，他父親疼愛他。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","你對僕人說：『把他帶到我這裏來，叫我親眼看看他。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","我們對我主說：『童子不能離開他父親，若是離開，他父親必死。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","你對僕人說：『你們的小兄弟若不與你們一同下來，你們就不得再見我的面。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","我們上到你僕人－我們父親那裏，就把我主的話告訴了他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","我們的父親說：『你們再去給我糴些糧來。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","我們就說：『我們不能下去。我們的小兄弟若和我們同往，我們就可以下去。因為，小兄弟若不與我們同往，我們必不得見那人的面。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","你僕人－我父親對我們說：『你們知道我的妻子給我生了兩個兒子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","一個離開我出去了；我說他必是被撕碎了，直到如今我也沒有見他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","現在你們又要把這個帶去離開我，倘若他遭害，那便是你們使我白髮蒼蒼、悲悲慘慘地下陰間去了。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","我父親的命與這童子的命相連。如今我回到你僕人－我父親那裏，若沒有童子與我們同在， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","我們的父親見沒有童子，他就必死。這便是我們使你僕人－我們的父親白髮蒼蒼、悲悲慘慘地下陰間去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","因為僕人曾向我父親為這童子作保，說：『我若不帶他回來交給父親，我便在父親面前永遠擔罪。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","現在求你容僕人住下，替這童子作我主的奴僕，叫童子和他哥哥們一同上去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","若童子不和我同去，我怎能上去見我父親呢？恐怕我看見災禍臨到我父親身上。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","約瑟在左右站着的人面前情不自禁，吩咐一聲說：「人都要離開我出去！」約瑟和弟兄們相認的時候並沒有一人站在他面前。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","他就放聲大哭；埃及人和法老家中的人都聽見了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","約瑟對他弟兄們說：「我是約瑟。我的父親還在嗎？」他弟兄不能回答，因為在他面前都驚惶。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","約瑟又對他弟兄們說：「請你們近前來。」他們就近前來。他說：「我是你們的兄弟約瑟，就是你們所賣到埃及的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","現在，不要因為把我賣到這裏自憂自恨。這是上帝差我在你們以先來，為要保全生命。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","現在這地的饑荒已經二年了，還有五年不能耕種，不能收成。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","上帝差我在你們以先來，為要給你們存留餘種在世上，又要大施拯救，保全你們的生命。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","這樣看來，差我到這裏來的不是你們，乃是上帝。他又使我如法老的父，作他全家的主，並埃及全地的宰相。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","你們要趕緊上到我父親那裏，對他說：『你兒子約瑟這樣說：上帝使我作全埃及的主，請你下到我這裏來，不要耽延。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","你和你的兒子孫子，連牛群羊群，並一切所有的，都可以住在歌珊地，與我相近。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","我要在那裏奉養你；因為還有五年的饑荒，免得你和你的眷屬，並一切所有的，都敗落了。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","況且你們的眼和我兄弟便雅憫的眼都看見是我親口對你們說話。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","你們也要將我在埃及一切的榮耀和你們所看見的事都告訴我父親，又要趕緊地將我父親搬到我這裏來。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","於是約瑟伏在他兄弟便雅憫的頸項上哭，便雅憫也在他的頸項上哭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","他又與眾弟兄親嘴，抱着他們哭，隨後他弟兄們就和他說話。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","這風聲傳到法老的宮裏，說：「約瑟的弟兄們來了。」法老和他的臣僕都很喜歡。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","法老對約瑟說：「你吩咐你的弟兄們說：『你們要這樣行：把馱子抬在牲口上，起身往迦南地去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","將你們的父親和你們的眷屬都搬到我這裏來，我要把埃及地的美物賜給你們，你們也要吃這地肥美的出產。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","現在我吩咐你們要這樣行：從埃及地帶着車輛去，把你們的孩子和妻子，並你們的父親都搬來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","你們眼中不要愛惜你們的家具，因為埃及全地的美物都是你們的。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","以色列的兒子們就如此行。約瑟照着法老的吩咐給他們車輛和路上用的食物， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","又給他們各人一套衣服，惟獨給便雅憫三百銀子，五套衣服； ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","送給他父親公驢十匹，馱着埃及的美物，母驢十匹，馱着糧食與餅和菜，為他父親路上用。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","於是約瑟打發他弟兄們回去，又對他們說：「你們不要在路上相爭。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","他們從埃及上去，來到迦南地、他們的父親雅各那裏， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","告訴他說：「約瑟還在，並且作埃及全地的宰相。」雅各心裏冰涼，因為不信他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","他們便將約瑟對他們說的一切話都告訴了他。他們父親雅各又看見約瑟打發來接他的車輛，心就甦醒了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","以色列說：「罷了！罷了！我的兒子約瑟還在，趁我未死以先，我要去見他一面。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","以色列帶着一切所有的，起身來到別是巴，就獻祭給他父親以撒的上帝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","夜間，上帝在異象中對以色列說：「雅各！雅各！」他說：「我在這裏。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","上帝說：「我是上帝，就是你父親的上帝。你下埃及去不要害怕，因為我必使你在那裏成為大族。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","我要和你同下埃及去，也必定帶你上來；約瑟必給你送終。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","雅各就從別是巴起行。以色列的兒子們使他們的父親雅各和他們的妻子、兒女都坐在法老為雅各送來的車上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","他們又帶着迦南地所得的牲畜、貨財來到埃及。雅各和他的一切子孫都一同來了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","雅各把他的兒子、孫子、女兒、孫女，並他的子子孫孫，一同帶到埃及。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","來到埃及的以色列人名字記在下面。雅各和他的兒孫：雅各的長子是呂便。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","呂便的兒子是哈諾、法路、希斯倫、迦米。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","西緬的兒子是耶母利、雅憫、阿轄、雅斤、瑣轄，還有迦南女子所生的掃羅。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","利未的兒子是革順、哥轄、米拉利。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","猶大的兒子是珥、俄南、示拉、法勒斯、謝拉；惟有珥與俄南死在迦南地。法勒斯的兒子是希斯崙、哈母勒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","以薩迦的兒子是陀拉、普瓦、約伯、伸崙。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","西布倫的兒子是西烈、以倫、雅利。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","這是利亞在巴旦‧亞蘭給雅各所生的兒子，還有女兒底拿。兒孫共有三十三人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","迦得的兒子是洗非芸、哈基、書尼、以斯本、以利、亞羅底、亞列利。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","亞設的兒子是音拿、亦施瓦、亦施韋、比利亞，還有他們的妹子西拉。比利亞的兒子是希別、瑪結。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","這是拉班給他女兒利亞的婢女悉帕從雅各所生的兒孫，共有十六人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","雅各之妻拉結的兒子是約瑟和便雅憫。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","約瑟在埃及地生了瑪拿西和以法蓮，就是安城的祭司波提非拉的女兒亞西納給約瑟生的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","便雅憫的兒子是比拉、比結、亞實別、基拉、乃幔、以希、羅實、母平、戶平、亞勒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","這是拉結給雅各所生的兒孫，共有十四人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","但的兒子是戶伸。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","拿弗他利的兒子是雅薛、沽尼、耶色、示冷。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","這是拉班給他女兒拉結的婢女辟拉從雅各所生的兒孫，共有七人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","那與雅各同到埃及的，除了他兒婦之外，凡從他所生的，共有六十六人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","還有約瑟在埃及所生的兩個兒子。雅各家來到埃及的共有七十人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","雅各打發猶大先去見約瑟，請派人引路往歌珊去；於是他們來到歌珊地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","約瑟套車往歌珊去，迎接他父親以色列，及至見了面，就伏在父親的頸項上，哭了許久。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","以色列對約瑟說：「我既得見你的面，知道你還在，就是死我也甘心。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","約瑟對他的弟兄和他父的全家說：「我要上去告訴法老，對他說：『我的弟兄和我父的全家從前在迦南地，現今都到我這裏來了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","他們本是牧羊的人，以養牲畜為業；他們把羊群牛群和一切所有的都帶來了。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","等法老召你們的時候，問你們說：『你們以何事為業？』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","你們要說：『你的僕人，從幼年直到如今，都以養牲畜為業，連我們的祖宗也都以此為業。』這樣，你們可以住在歌珊地，因為凡牧羊的都被埃及人所厭惡。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","約瑟進去告訴法老說：「我的父親和我的弟兄帶着羊群牛群，並一切所有的，從迦南地來了，如今在歌珊地。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","約瑟從他弟兄中挑出五個人來，引他們去見法老。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","法老問約瑟的弟兄說：「你們以何事為業？」他們對法老說：「你僕人是牧羊的，連我們的祖宗也是牧羊的。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","他們又對法老說：「迦南地的饑荒甚大，僕人的羊群沒有草吃，所以我們來到這地寄居。現在求你容僕人住在歌珊地。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","法老對約瑟說：「你父親和你弟兄到你這裏來了， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","埃及地都在你面前，只管叫你父親和你弟兄住在國中最好的地；他們可以住在歌珊地。你若知道他們中間有甚麼能人，就派他們看管我的牲畜。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","約瑟領他父親雅各進到法老面前，雅各就給法老祝福。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","法老問雅各說：「你平生的年日是多少呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","雅各對法老說：「我寄居在世的年日是一百三十歲，我平生的年日又少又苦，不及我列祖在世寄居的年日。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","雅各又給法老祝福，就從法老面前出去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","約瑟遵着法老的命，把埃及國最好的地，就是蘭塞境內的地，給他父親和弟兄居住，作為產業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","約瑟用糧食奉養他父親和他弟兄，並他父親全家的眷屬，都是照各家的人口奉養他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","饑荒甚大，全地都絕了糧，甚至埃及地和迦南地的人因那饑荒的緣故都餓昏了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","約瑟收聚了埃及地和迦南地所有的銀子，就是眾人糴糧的銀子，約瑟就把那銀子帶到法老的宮裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","埃及地和迦南地的銀子都花盡了，埃及眾人都來見約瑟，說：「我們的銀子都用盡了，求你給我們糧食，我們為甚麼死在你面前呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","約瑟說：「若是銀子用盡了，可以把你們的牲畜給我，我就為你們的牲畜給你們糧食。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","於是他們把牲畜趕到約瑟那裏，約瑟就拿糧食換了他們的牛、羊、驢、馬；那一年因換他們一切的牲畜，就用糧食養活他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","那一年過去，第二年他們又來見約瑟，說：「我們不瞞我主，我們的銀子都花盡了，牲畜也都歸了我主。我們在我主眼前，除了我們的身體和田地之外，一無所剩。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","你何忍見我們人死地荒呢？求你用糧食買我們和我們的地，我們和我們的地就要給法老效力。又求你給我們種子，使我們得以存活，不致死亡，地土也不致荒涼。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","於是，約瑟為法老買了埃及所有的地，埃及人因被饑荒所迫，各都賣了自己的田地；那地就都歸了法老。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","至於百姓，約瑟叫他們，從埃及這邊直到埃及那邊，都各歸各城。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","惟有祭司的地，約瑟沒有買，因為祭司有從法老所得的常俸。他們吃法老所給的常俸，所以他們不賣自己的地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","約瑟對百姓說：「我今日為法老買了你們和你們的地，看哪，這裏有種子給你們，你們可以種地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","後來打糧食的時候，你們要把五分之一納給法老，四分可以歸你們做地裏的種子，也做你們和你們家口孩童的食物。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","他們說：「你救了我們的性命。但願我們在我主眼前蒙恩，我們就作法老的僕人。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","於是約瑟為埃及地定下常例，直到今日：法老必得五分之一，惟獨祭司的地不歸法老。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","以色列人住在埃及的歌珊地。他們在那裏置了產業，並且生育甚多。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","雅各住在埃及地十七年，雅各平生的年日是一百四十七歲。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","以色列的死期臨近了，他就叫了他兒子約瑟來，說：「我若在你眼前蒙恩，請你把手放在我大腿底下，用慈愛和誠實待我，請你不要將我葬在埃及。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","我與我祖我父同睡的時候，你要將我帶出埃及，葬在他們所葬的地方。」約瑟說：「我必遵着你的命而行。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","雅各說：「你要向我起誓。」約瑟就向他起了誓，於是以色列在床頭上敬拜上帝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","這事以後，有人告訴約瑟說：「你的父親病了。」他就帶着兩個兒子瑪拿西和以法蓮同去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","有人告訴雅各說：「請看，你兒子約瑟到你這裏來了。」以色列就勉強在床上坐起來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","雅各對約瑟說：「全能的上帝曾在迦南地的路斯向我顯現，賜福與我， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","對我說：『我必使你生養眾多，成為多民，又要把這地賜給你的後裔，永遠為業。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","我未到埃及見你之先，你在埃及地所生的以法蓮和瑪拿西這兩個兒子是我的，正如呂便和西緬是我的一樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","你在他們以後所生的就是你的，他們可以歸於他們弟兄的名下得產業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","至於我，我從巴旦來的時候，拉結死在我眼前，在迦南地的路上，離以法他還有一段路程，我就把她葬在以法他的路上（以法他就是伯利恆）。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","以色列看見約瑟的兩個兒子，就說：「這是誰？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","約瑟對他父親說：「這是上帝在這裏賜給我的兒子。」以色列說：「請你領他們到我跟前，我要給他們祝福。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","以色列年紀老邁，眼睛昏花，不能看見。約瑟領他們到他跟前，他就和他們親嘴，抱着他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","以色列對約瑟說：「我想不到得見你的面，不料，上帝又使我得見你的兒子。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","約瑟把兩個兒子從以色列兩膝中領出來，自己就臉伏於地下拜。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","隨後，約瑟又拉着他們兩個，以法蓮在他的右手裏，對着以色列的左手，瑪拿西在他的左手裏，對着以色列的右手，領他們到以色列的跟前。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","以色列伸出右手來，按在以法蓮的頭上（以法蓮乃是次子），又剪搭過左手來，按在瑪拿西的頭上（瑪拿西原是長子）。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","他就給約瑟祝福說：「願我祖亞伯拉罕和我父以撒所事奉的上帝，就是一生牧養我直到今日的上帝， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","救贖我脫離一切患難的那使者，賜福與這兩個童子。願他們歸在我的名下和我祖亞伯拉罕、我父以撒的名下。又願他們在世界中生養眾多。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","約瑟見他父親把右手按在以法蓮的頭上，就不喜悅，便提起他父親的手，要從以法蓮頭上挪到瑪拿西的頭上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","約瑟對他父親說：「我父，不是這樣。這本是長子，求你把右手按在他的頭上。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","他父親不從，說：「我知道，我兒，我知道。他也必成為一族，也必昌大。只是他的兄弟將來比他還大；他兄弟的後裔要成為多族。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","當日就給他們祝福說：「以色列人要指着你們祝福說：『願上帝使你如以法蓮、瑪拿西一樣。』」於是立以法蓮在瑪拿西以上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","以色列又對約瑟說：「我要死了，但上帝必與你們同在，領你們回到你們列祖之地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","並且我從前用弓用刀從亞摩利人手下奪的那塊地，我都賜給你，使你比眾弟兄多得一分。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","雅各叫了他的兒子們來，說：「你們都來聚集，我好把你們日後必遇的事告訴你們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","雅各的兒子們，你們要聚集而聽， 要聽你們父親以色列的話。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","呂便哪，你是我的長子， 是我力量強壯的時候生的， 本當大有尊榮，權力超眾。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","但你放縱情慾，滾沸如水， 必不得居首位； 因為你上了你父親的床， 污穢了我的榻。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","西緬和利未是弟兄； 他們的刀劍是殘忍的器具。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","我的靈啊，不要與他們同謀； 我的心哪，不要與他們聯絡； 因為他們趁怒殺害人命， 任意砍斷牛腿大筋。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","他們的怒氣暴烈可咒； 他們的忿恨殘忍可詛。 我要使他們分居在雅各家裏， 散住在以色列地中。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","猶大啊，你弟兄們必讚美你； 你手必掐住仇敵的頸項； 你父親的兒子們必向你下拜。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","猶大是個小獅子； 我兒啊，你抓了食便上去。 你屈下身去，臥如公獅， 蹲如母獅，誰敢惹你？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","圭必不離猶大， 杖必不離他兩腳之間， 直等細羅來到， 萬民都必歸順。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","猶大把小驢拴在葡萄樹上， 把驢駒拴在美好的葡萄樹上。 他在葡萄酒中洗了衣服， 在葡萄汁中洗了袍褂。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","他的眼睛必因酒紅潤； 他的牙齒必因奶白亮。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","西布倫必住在海口， 必成為停船的海口； 他的境界必延到西頓。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","以薩迦是個強壯的驢， 臥在羊圈之中。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","他以安靜為佳，以肥地為美， 便低肩背重，成為服苦的僕人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","但必判斷他的民， 作以色列支派之一。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","但必作道上的蛇，路中的虺， 咬傷馬蹄，使騎馬的墜落於後。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","耶和華啊，我向來等候你的救恩。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","迦得必被敵軍追逼， 他卻要追逼他們的腳跟。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","亞設之地必出肥美的糧食， 且出君王的美味。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","拿弗他利是被釋放的母鹿； 他出嘉美的言語。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","約瑟是多結果子的樹枝， 是泉旁多結果的枝子； 他的枝條探出牆外。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","弓箭手將他苦害， 向他射箭，逼迫他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","但他的弓仍舊堅硬； 他的手健壯敏捷。 這是因以色列的牧者，以色列的磐石－ 就是雅各的大能者。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","你父親的上帝必幫助你； 那全能者必將天上所有的福， 地裏所藏的福，以及生產乳養的福，都賜給你。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","你父親所祝的福 勝過我祖先所祝的福， 如永世的山嶺，至極的邊界； 這些福必降在約瑟的頭上， 臨到那與弟兄迥別之人的頂上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","便雅憫是個撕掠的狼， 早晨要吃他所抓的， 晚上要分他所奪的。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","這一切是以色列的十二支派；這也是他們的父親對他們所說的話，為他們所祝的福，都是按着各人的福分為他們祝福。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","他又囑咐他們說：「我將要歸到我列祖那裏，你們要將我葬在赫人以弗崙田間的洞裏，與我祖我父在一處， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","就是在迦南地幔利前、麥比拉田間的洞；那洞和田是亞伯拉罕向赫人以弗崙買來為業，作墳地的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","他們在那裏葬了亞伯拉罕和他妻子撒拉，又在那裏葬了以撒和他的妻子利百加；我也在那裏葬了利亞。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","那塊田和田間的洞原是向赫人買的。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","雅各囑咐眾子已畢，就把腳收在床上，氣絕而死，歸他列祖那裏去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","約瑟伏在他父親的面上哀哭，與他親嘴。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","約瑟吩咐伺候他的醫生用香料薰他父親，醫生就用香料薰了以色列。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","薰屍的常例是四十天；那四十天滿了，埃及人為他哀哭了七十天。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","為他哀哭的日子過了，約瑟對法老家中的人說：「我若在你們眼前蒙恩，請你們報告法老說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","『我父親要死的時候叫我起誓說：你要將我葬在迦南地，在我為自己所掘的墳墓裏。』現在求你讓我上去葬我父親，以後我必回來。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","法老說：「你可以上去，照着你父親叫你起的誓，將他葬埋。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","於是約瑟上去葬他父親。與他一同上去的，有法老的臣僕和法老家中的長老，並埃及國的長老， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","還有約瑟的全家和他的弟兄們，並他父親的眷屬；只有他們的婦人孩子，和羊群牛群，都留在歌珊地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","又有車輛馬兵，和他一同上去；那一幫人甚多。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","他們到了約旦河外、亞達的禾場，就在那裏大大地號咷痛哭。約瑟為他父親哀哭了七天。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","迦南的居民見亞達禾場上的哀哭，就說：「這是埃及人一場極大的哀哭。」因此那地方名叫亞伯‧麥西，是在約旦河東。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","雅各的兒子們就遵着他父親所吩咐的辦了， ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","把他搬到迦南地，葬在幔利前、麥比拉田間的洞裏；那洞和田是亞伯拉罕向赫人以弗崙買來為業，作墳地的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","約瑟葬了他父親以後，就和眾弟兄，並一切同他上去葬他父親的人，都回埃及去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","約瑟的哥哥們見父親死了，就說：「或者約瑟懷恨我們，照着我們從前待他一切的惡足足地報復我們。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","他們就打發人去見約瑟，說：「你父親未死以先吩咐說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","『你們要對約瑟這樣說：從前你哥哥們惡待你，求你饒恕他們的過犯和罪惡。』如今求你饒恕你父親上帝之僕人的過犯。」他們對約瑟說這話，約瑟就哭了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","他的哥哥們又來俯伏在他面前，說：「我們是你的僕人。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","約瑟對他們說：「不要害怕，我豈能代替上帝呢？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","從前你們的意思是要害我，但上帝的意思原是好的，要保全許多人的性命，成就今日的光景。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","現在你們不要害怕，我必養活你們和你們的婦人孩子。」於是約瑟用親愛的話安慰他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","約瑟和他父親的眷屬都住在埃及。約瑟活了一百一十歲。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","約瑟得見以法蓮第三代的子孫。瑪拿西的孫子、瑪吉的兒子也養在約瑟的膝上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","約瑟對他弟兄們說：「我要死了，但上帝必定看顧你們，領你們從這地上去，到他起誓所應許給亞伯拉罕、以撒、雅各之地。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","約瑟叫以色列的子孫起誓說：「上帝必定看顧你們；你們要把我的骸骨從這裏搬上去。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","約瑟死了，正一百一十歲。人用香料將他薰了，把他收殮在棺材裏，停在埃及。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","以色列的眾子，各帶家眷，和雅各一同來到埃及。他們的名字記在下面。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","有呂便、西緬、利未、猶大、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","以薩迦、西布倫、便雅憫、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","但、拿弗他利、迦得、亞設。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","凡從雅各而生的，共有七十人。約瑟已經在埃及。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","約瑟和他的弟兄，並那一代的人，都死了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","以色列人生養眾多，並且繁茂，極其強盛，滿了那地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","有不認識約瑟的新王起來，治理埃及， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","對他的百姓說：「看哪，這以色列民比我們還多，又比我們強盛。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","來吧，我們不如用巧計待他們，恐怕他們多起來，日後若遇甚麼爭戰的事，就連合我們的仇敵攻擊我們，離開這地去了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","於是埃及人派督工的轄制他們，加重擔苦害他們。他們為法老建造兩座積貨城，就是比東和蘭塞。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","只是越發苦害他們，他們越發多起來，越發蔓延；埃及人就因以色列人愁煩。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","埃及人嚴嚴地使以色列人做工， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","使他們因做苦工覺得命苦；無論是和泥，是做磚，是做田間各樣的工，在一切的工上都嚴嚴地待他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","有希伯來的兩個收生婆，一名施弗拉，一名普阿；埃及王對她們說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","「你們為希伯來婦人收生，看她們臨盆的時候，若是男孩，就把他殺了；若是女孩，就留她存活。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","但是收生婆敬畏上帝，不照埃及王的吩咐行，竟存留男孩的性命。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","埃及王召了收生婆來，說：「你們為甚麼做這事，存留男孩的性命呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","收生婆對法老說：「因為希伯來婦人與埃及婦人不同；希伯來婦人本是健壯的，收生婆還沒有到，她們已經生產了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","上帝厚待收生婆。以色列人多起來，極其強盛。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","收生婆因為敬畏上帝，上帝便叫她們成立家室。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","法老吩咐他的眾民說：「以色列人所生的男孩，你們都要丟在河裏；一切的女孩，你們要存留她的性命。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","有一個利未家的人娶了一個利未女子為妻。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","那女人懷孕，生一個兒子，見他俊美，就藏了他三個月， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","後來不能再藏，就取了一個蒲草箱，抹上石漆和石油，將孩子放在裏頭，把箱子擱在河邊的蘆荻中。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","孩子的姊姊遠遠站着，要知道他究竟怎麼樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","法老的女兒來到河邊洗澡，她的使女們在河邊行走。她看見箱子在蘆荻中，就打發一個婢女拿來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","她打開箱子，看見那孩子。孩子哭了，她就可憐他，說：「這是希伯來人的一個孩子。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","孩子的姊姊對法老的女兒說：「我去在希伯來婦人中叫一個奶媽來，為你奶這孩子，可以不可以？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","法老的女兒說：「可以。」童女就去叫了孩子的母親來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","法老的女兒對她說：「你把這孩子抱去，為我奶他，我必給你工價。」婦人就抱了孩子去奶他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","孩子漸長，婦人把他帶到法老的女兒那裏，就作了她的兒子。她給孩子起名叫摩西，意思說：「因我把他從水裏拉出來。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","後來，摩西長大，他出去到他弟兄那裏，看他們的重擔，見一個埃及人打希伯來人的一個弟兄。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","他左右觀看，見沒有人，就把埃及人打死了，藏在沙土裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","第二天他出去，見有兩個希伯來人爭鬥，就對那欺負人的說：「你為甚麼打你同族的人呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","那人說：「誰立你作我們的首領和審判官呢？難道你要殺我，像殺那埃及人嗎？」摩西便懼怕，說：「這事必是被人知道了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","法老聽見這事，就想殺摩西，但摩西躲避法老，逃往米甸地居住。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","一日，他在井旁坐下。米甸的祭司有七個女兒；她們來打水，打滿了槽，要飲父親的群羊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","有牧羊的人來，把她們趕走了，摩西卻起來幫助她們，又飲了她們的群羊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","她們來到父親流珥那裏；他說：「今日你們為何來得這麼快呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","她們說：「有一個埃及人救我們脫離牧羊人的手，並且為我們打水飲了群羊。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","他對女兒們說：「那個人在哪裏？你們為甚麼撇下他呢？你們去請他來吃飯。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","摩西甘心和那人同住；那人把他的女兒西坡拉給摩西為妻。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","西坡拉生了一個兒子，摩西給他起名叫革舜，意思說：「因我在外邦作了寄居的。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","過了多年，埃及王死了。以色列人因做苦工，就歎息哀求，他們的哀聲達於上帝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","上帝聽見他們的哀聲，就記念他與亞伯拉罕、以撒、雅各所立的約。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","上帝看顧以色列人，也知道他們的苦情。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","摩西牧養他岳父米甸祭司葉忒羅的羊群；一日領羊群往野外去，到了上帝的山，就是何烈山。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","耶和華的使者從荊棘裏火焰中向摩西顯現。摩西觀看，不料，荊棘被火燒着，卻沒有燒毀。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","摩西說：「我要過去看這大異象，這荊棘為何沒有燒壞呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","耶和華上帝見他過去要看，就從荊棘裏呼叫說：「摩西！摩西！」他說：「我在這裏。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","上帝說：「不要近前來。當把你腳上的鞋脫下來，因為你所站之地是聖地」； ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","又說：「我是你父親的上帝，是亞伯拉罕的上帝，以撒的上帝，雅各的上帝。」摩西蒙上臉，因為怕看上帝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","耶和華說：「我的百姓在埃及所受的困苦，我實在看見了；他們因受督工的轄制所發的哀聲，我也聽見了。我原知道他們的痛苦， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","我下來是要救他們脫離埃及人的手，領他們出了那地，到美好、寬闊、流奶與蜜之地，就是到迦南人、赫人、亞摩利人、比利洗人、希未人、耶布斯人之地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","現在以色列人的哀聲達到我耳中，我也看見埃及人怎樣欺壓他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","故此，我要打發你去見法老，使你可以將我的百姓以色列人從埃及領出來。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","摩西對上帝說：「我是甚麼人，竟能去見法老，將以色列人從埃及領出來呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","上帝說：「我必與你同在。你將百姓從埃及領出來之後，你們必在這山上事奉我；這就是我打發你去的證據。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","摩西對上帝說：「我到以色列人那裏，對他們說：『你們祖宗的上帝打發我到你們這裏來。』他們若問我說：『他叫甚麼名字？』我要對他們說甚麼呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","上帝對摩西說：「我是自有永有的」；又說：「你要對以色列人這樣說：『那自有的打發我到你們這裏來。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","上帝又對摩西說：「你要對以色列人這樣說：『耶和華－你們祖宗的上帝，就是亞伯拉罕的上帝，以撒的上帝，雅各的上帝，打發我到你們這裏來。』耶和華是我的名，直到永遠；這也是我的紀念，直到萬代。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","你去招聚以色列的長老，對他們說：『耶和華－你們祖宗的上帝，就是亞伯拉罕的上帝，以撒的上帝，雅各的上帝，向我顯現，說：我實在眷顧了你們，我也看見埃及人怎樣待你們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","我也說：要將你們從埃及的困苦中領出來，往迦南人、赫人、亞摩利人、比利洗人、希未人、耶布斯人的地去，就是到流奶與蜜之地。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","他們必聽你的話。你和以色列的長老要去見埃及王，對他說：『耶和華－希伯來人的上帝遇見了我們，現在求你容我們往曠野去，走三天的路程，為要祭祀耶和華－我們的上帝。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","我知道雖用大能的手，埃及王也不容你們去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","我必伸手在埃及中間施行我一切的奇事，攻擊那地，然後他才容你們去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","我必叫你們在埃及人眼前蒙恩，你們去的時候就不至於空手而去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","但各婦女必向她的鄰舍，並居住在她家裏的女人，要金器銀器和衣裳，好給你們的兒女穿戴。這樣你們就把埃及人的財物奪去了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","摩西回答說：「他們必不信我，也不聽我的話，必說：『耶和華並沒有向你顯現。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","耶和華對摩西說：「你手裏是甚麼？」他說：「是杖。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","耶和華說：「丟在地上。」他一丟下去，就變作蛇；摩西便跑開。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","耶和華對摩西說：「伸出手來，拿住牠的尾巴，牠必在你手中仍變為杖； ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","如此好叫他們信耶和華－他們祖宗的上帝，就是亞伯拉罕的上帝，以撒的上帝，雅各的上帝，是向你顯現了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","耶和華又對他說：「把手放在懷裏。」他就把手放在懷裏，及至抽出來，不料，手長了大痲瘋，有雪那樣白。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","耶和華說：「再把手放在懷裏。」他就再把手放在懷裏，及至從懷裏抽出來，不料，手已經復原，與周身的肉一樣； ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","又說：「倘或他們不聽你的話，也不信頭一個神蹟，他們必信第二個神蹟。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","這兩個神蹟若都不信，也不聽你的話，你就從河裏取些水，倒在旱地上，你從河裏取的水必在旱地上變作血。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","摩西對耶和華說：「主啊，我素日不是能言的人，就是從你對僕人說話以後，也是這樣。我本是拙口笨舌的。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","耶和華對他說：「誰造人的口呢？誰使人口啞、耳聾、目明、眼瞎呢？豈不是我－耶和華嗎？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","現在去吧，我必賜你口才，指教你所當說的話。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","摩西說：「主啊，你願意打發誰，就打發誰去吧！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","耶和華向摩西發怒說：「不是有你的哥哥利未人亞倫嗎？我知道他是能言的；現在他出來迎接你，他一見你，心裏就歡喜。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","你要將當說的話傳給他；我也要賜你和他口才，又要指教你們所當行的事。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","他要替你對百姓說話；你要以他當作口，他要以你當作上帝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","你手裏要拿這杖，好行神蹟。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","於是，摩西回到他岳父葉忒羅那裏，對他說：「求你容我回去見我在埃及的弟兄，看他們還在不在。」葉忒羅對摩西說：「你可以平平安安地去吧！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","耶和華在米甸對摩西說：「你要回埃及去，因為尋索你命的人都死了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","摩西就帶着妻子和兩個兒子，叫他們騎上驢，回埃及地去。摩西手裏拿着上帝的杖。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","耶和華對摩西說：「你回到埃及的時候，要留意將我指示你的一切奇事行在法老面前。但我要使他的心剛硬，他必不容百姓去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","你要對法老說：『耶和華這樣說：以色列是我的兒子，我的長子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","我對你說過：容我的兒子去，好事奉我。你還是不肯容他去。看哪，我要殺你的長子。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","摩西在路上住宿的地方，耶和華遇見他，想要殺他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","西坡拉就拿一塊火石，割下他兒子的陽皮，丟在摩西腳前，說：「你真是我的血郎了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","這樣，耶和華才放了他。西坡拉說：「你因割禮就是血郎了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","耶和華對亞倫說：「你往曠野去迎接摩西。」他就去，在上帝的山遇見摩西，和他親嘴。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","摩西將耶和華打發他所說的言語和囑咐他所行的神蹟都告訴了亞倫。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","摩西、亞倫就去招聚以色列的眾長老。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","亞倫將耶和華對摩西所說的一切話述說了一遍，又在百姓眼前行了那些神蹟， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","百姓就信了。以色列人聽見耶和華眷顧他們，鑒察他們的困苦，就低頭下拜。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","後來摩西、亞倫去對法老說：「耶和華－以色列的上帝這樣說：『容我的百姓去，在曠野向我守節。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","法老說：「耶和華是誰，使我聽他的話，容以色列人去呢？我不認識耶和華，也不容以色列人去！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","他們說：「希伯來人的上帝遇見了我們。求你容我們往曠野去，走三天的路程，祭祀耶和華－我們的上帝，免得他用瘟疫、刀兵攻擊我們。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","埃及王對他們說：「摩西、亞倫！你們為甚麼叫百姓曠工呢？你們去擔你們的擔子吧！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","又說：「看哪，這地的以色列人如今眾多，你們竟叫他們歇下擔子！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","當天，法老吩咐督工的和官長說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","「你們不可照常把草給百姓做磚，叫他們自己去撿草。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","他們素常做磚的數目，你們仍舊向他們要，一點不可減少；因為他們是懶惰的，所以呼求說：『容我們去祭祀我們的上帝。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","你們要把更重的工夫加在這些人身上，叫他們勞碌，不聽虛謊的言語。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","督工的和官長出來對百姓說：「法老這樣說：『我不給你們草。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","你們自己在哪裏能找草，就往那裏去找吧！但你們的工一點不可減少。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","於是百姓散在埃及遍地，撿碎稭當作草。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","督工的催着說：「你們一天當完一天的工，與先前有草一樣。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","法老督工的，責打他所派以色列人的官長，說：「你們昨天今天為甚麼沒有照向來的數目做磚、完你們的工作呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","以色列人的官長就來哀求法老說：「為甚麼這樣待你的僕人？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","督工的不把草給僕人，並且對我們說：『做磚吧！』看哪，你僕人挨了打，其實是你百姓的錯。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","但法老說：「你們是懶惰的！你們是懶惰的！所以說：『容我們去祭祀耶和華。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","現在你們去做工吧！草是不給你們的，磚卻要如數交納。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","以色列人的官長聽說「你們每天做磚的工作一點不可減少」，就知道是遭遇禍患了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","他們離了法老出來，正遇見摩西、亞倫站在對面， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","就向他們說：「願耶和華鑒察你們，施行判斷；因你們使我們在法老和他臣僕面前有了臭名，把刀遞在他們手中殺我們。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","摩西回到耶和華那裏，說：「主啊，你為甚麼苦待這百姓呢？為甚麼打發我去呢？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","自從我去見法老，奉你的名說話，他就苦待這百姓，你一點也沒有拯救他們。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","耶和華對摩西說：「現在你必看見我向法老所行的事，使他因我大能的手容以色列人去，且把他們趕出他的地。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","上帝曉諭摩西說：「我是耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","我從前向亞伯拉罕、以撒、雅各顯現為全能的上帝；至於我名耶和華，他們未曾知道。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","我與他們堅定所立的約，要把他們寄居的迦南地賜給他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","我也聽見以色列人被埃及人苦待的哀聲，我也記念我的約。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","所以你要對以色列人說：『我是耶和華；我要用伸出來的膀臂重重地刑罰埃及人，救贖你們脫離他們的重擔，不做他們的苦工。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","我要以你們為我的百姓，我也要作你們的上帝。你們要知道我是耶和華－你們的上帝，是救你們脫離埃及人之重擔的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","我起誓應許給亞伯拉罕、以撒、雅各的那地，我要把你們領進去，將那地賜給你們為業。我是耶和華。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","摩西將這話告訴以色列人，只是他們因苦工愁煩，不肯聽他的話。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","耶和華曉諭摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","「你進去對埃及王法老說，要容以色列人出他的地。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","摩西在耶和華面前說：「以色列人尚且不聽我的話，法老怎肯聽我這拙口笨舌的人呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","耶和華吩咐摩西、亞倫往以色列人和埃及王法老那裏去，把以色列人從埃及地領出來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","以色列人家長的名字記在下面。以色列長子呂便的兒子是哈諾、法路、希斯倫、迦米；這是呂便的各家。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","西緬的兒子是耶母利、雅憫、阿轄、雅斤、瑣轄，和迦南女子的兒子掃羅；這是西緬的各家。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","利未眾子的名字按着他們的後代記在下面：就是革順、哥轄、米拉利。利未一生的歲數是一百三十七歲。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","革順的兒子按着家室是立尼、示每。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","哥轄的兒子是暗蘭、以斯哈、希伯倫、烏薛。哥轄一生的歲數是一百三十三歲。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","米拉利的兒子是抹利和母示；這是利未的家，都按着他們的後代。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","暗蘭娶了他父親的妹妹約基別為妻，她給他生了亞倫和摩西。暗蘭一生的歲數是一百三十七歲。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","以斯哈的兒子是可拉、尼斐、細基利。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","烏薛的兒子是米沙利、以利撒反、西提利。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","亞倫娶了亞米拿達的女兒，拿順的妹妹，以利沙巴為妻，她給他生了拿答、亞比戶、以利亞撒、以他瑪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","可拉的兒子是亞惜、以利加拿、亞比亞撒；這是可拉的各家。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","亞倫的兒子以利亞撒娶了普鐵的一個女兒為妻，她給他生了非尼哈。這是利未人的家長，都按着他們的家。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","耶和華說：「將以色列人按着他們的軍隊從埃及地領出來。」這是對那亞倫、摩西說的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","對埃及王法老說要將以色列人從埃及領出來的，就是這摩西、亞倫。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","當耶和華在埃及地對摩西說話的日子， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","他向摩西說：「我是耶和華；我對你說的一切話，你都要告訴埃及王法老。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","摩西在耶和華面前說：「看哪，我是拙口笨舌的人，法老怎肯聽我呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","耶和華對摩西說：「我使你在法老面前代替上帝，你的哥哥亞倫是替你說話的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","凡我所吩咐你的，你都要說。你的哥哥亞倫要對法老說，容以色列人出他的地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","我要使法老的心剛硬，也要在埃及地多行神蹟奇事。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","但法老必不聽你們；我要伸手重重地刑罰埃及，將我的軍隊以色列民從埃及地領出來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","我伸手攻擊埃及，將以色列人從他們中間領出來的時候，埃及人就要知道我是耶和華。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","摩西、亞倫這樣行；耶和華怎樣吩咐他們，他們就照樣行了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","摩西、亞倫與法老說話的時候，摩西八十歲，亞倫八十三歲。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","耶和華曉諭摩西、亞倫說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","「法老若對你們說：『你們行件奇事吧！』你就吩咐亞倫說：『把杖丟在法老面前，使杖變作蛇。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","摩西、亞倫進去見法老，就照耶和華所吩咐的行。亞倫把杖丟在法老和臣僕面前，杖就變作蛇。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","於是法老召了博士和術士來；他們是埃及行法術的，也用邪術照樣而行。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","他們各人丟下自己的杖，杖就變作蛇；但亞倫的杖吞了他們的杖。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","法老心裏剛硬，不肯聽從摩西、亞倫，正如耶和華所說的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","耶和華對摩西說：「法老心裏固執，不肯容百姓去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","明日早晨，他出來往水邊去，你要往河邊迎接他，手裏要拿着那變過蛇的杖， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","對他說：『耶和華－希伯來人的上帝打發我來見你，說：容我的百姓去，好在曠野事奉我。到如今你還是不聽。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","耶和華這樣說：我要用我手裏的杖擊打河中的水，水就變作血；因此，你必知道我是耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","河裏的魚必死，河也要腥臭，埃及人就要厭惡吃這河裏的水。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","耶和華曉諭摩西說：「你對亞倫說：『把你的杖伸在埃及所有的水以上，就是在他們的江、河、池、塘以上，叫水都變作血。在埃及遍地，無論在木器中，石器中，都必有血。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","摩西、亞倫就照耶和華所吩咐的行。亞倫在法老和臣僕眼前舉杖擊打河裏的水，河裏的水都變作血了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","河裏的魚死了，河也腥臭了，埃及人就不能吃這河裏的水；埃及遍地都有了血。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","埃及行法術的，也用邪術照樣而行。法老心裏剛硬，不肯聽摩西、亞倫，正如耶和華所說的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","法老轉身進宮，也不把這事放在心上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","埃及人都在河的兩邊挖地，要得水喝，因為他們不能喝這河裏的水。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","耶和華擊打河以後滿了七天。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","耶和華吩咐摩西說：「你進去見法老，對他說：『耶和華這樣說：容我的百姓去，好事奉我。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","你若不肯容他們去，我必使青蛙糟蹋你的四境。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","河裏要滋生青蛙；這青蛙要上來進你的宮殿和你的臥房，上你的床榻，進你臣僕的房屋，上你百姓的身上，進你的爐訿和你的摶麵盆， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","又要上你和你百姓並你眾臣僕的身上。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","耶和華曉諭摩西說：「你對亞倫說：『把你的杖伸在江、河、池以上，使青蛙到埃及地上來。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","亞倫便伸杖在埃及的諸水以上，青蛙就上來，遮滿了埃及地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","行法術的也用他們的邪術照樣而行，叫青蛙上了埃及地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","法老召了摩西、亞倫來，說：「請你們求耶和華使這青蛙離開我和我的民，我就容百姓去祭祀耶和華。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","摩西對法老說：「任憑你吧，我要何時為你和你的臣僕並你的百姓祈求，除滅青蛙離開你和你的宮殿只留在河裏呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","他說：「明天。」摩西說：「可以照你的話吧，好叫你知道沒有像耶和華－我們上帝的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","青蛙要離開你和你的宮殿，並你的臣僕與你的百姓，只留在河裏。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","於是摩西、亞倫離開法老出去。摩西為擾害法老的青蛙呼求耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","耶和華就照摩西的話行。凡在房裏、院中、田間的青蛙都死了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","眾人把青蛙聚攏成堆，遍地就都腥臭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","但法老見災禍鬆緩，就硬着心，不肯聽他們，正如耶和華所說的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","耶和華吩咐摩西說：「你對亞倫說：『伸出你的杖擊打地上的塵土，使塵土在埃及遍地變作虱子。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","他們就這樣行。亞倫伸杖擊打地上的塵土，就在人身上和牲畜身上有了虱子；埃及遍地的塵土都變成虱子了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","行法術的也用邪術要生出虱子來，卻是不能。於是在人身上和牲畜身上都有了虱子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","行法術的就對法老說：「這是上帝的手段。」法老心裏剛硬，不肯聽摩西、亞倫，正如耶和華所說的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","耶和華對摩西說：「你清早起來，法老來到水邊，你站在他面前，對他說：『耶和華這樣說：容我的百姓去，好事奉我。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","你若不容我的百姓去，我要叫成群的蒼蠅到你和你臣僕並你百姓的身上，進你的房屋，並且埃及人的房屋和他們所住的地都要滿了成群的蒼蠅。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","當那日，我必分別我百姓所住的歌珊地，使那裏沒有成群的蒼蠅，好叫你知道我是天下的耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","我要將我的百姓和你的百姓分別出來。明天必有這神蹟。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","耶和華就這樣行。蒼蠅成了大群，進入法老的宮殿，和他臣僕的房屋；埃及遍地就因這成群的蒼蠅敗壞了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","法老召了摩西、亞倫來，說：「你們去，在這地祭祀你們的上帝吧！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","摩西說：「這樣行本不相宜，因為我們要把埃及人所厭惡的祭祀耶和華－我們的上帝；若把埃及人所厭惡的在他們眼前獻為祭，他們豈不拿石頭打死我們嗎？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","我們要往曠野去，走三天的路程，照着耶和華－我們上帝所要吩咐我們的祭祀他。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","法老說：「我容你們去，在曠野祭祀耶和華－你們的上帝；只是不要走得很遠。求你們為我祈禱。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","摩西說：「我要出去求耶和華，使成群的蒼蠅明天離開法老和法老的臣僕並法老的百姓；法老卻不可再行詭詐，不容百姓去祭祀耶和華。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","於是摩西離開法老去求耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","耶和華就照摩西的話行，叫成群的蒼蠅離開法老和他的臣僕並他的百姓，一個也沒有留下。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","這一次法老又硬着心，不容百姓去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","耶和華吩咐摩西說：「你進去見法老，對他說：『耶和華－希伯來人的上帝這樣說：容我的百姓去，好事奉我。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","你若不肯容他們去，仍舊強留他們， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","耶和華的手加在你田間的牲畜上，就是在馬、驢、駱駝、牛群、羊群上，必有重重的瘟疫。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","耶和華要分別以色列的牲畜和埃及的牲畜，凡屬以色列人的，一樣都不死。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","耶和華就定了時候，說：「明天耶和華必在此地行這事。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","第二天，耶和華就行這事。埃及的牲畜幾乎都死了，只是以色列人的牲畜，一個都沒有死。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","法老打發人去看，誰知以色列人的牲畜連一個都沒有死。法老的心卻是固執，不容百姓去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","耶和華吩咐摩西、亞倫說：「你們取幾捧爐灰，摩西要在法老面前向天揚起來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","這灰要在埃及全地變作塵土，在人身上和牲畜身上成了起泡的瘡。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","摩西、亞倫取了爐灰，站在法老面前。摩西向天揚起來，就在人身上和牲畜身上成了起泡的瘡。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","行法術的在摩西面前站立不住，因為在他們身上和一切埃及人身上都有這瘡。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","耶和華使法老的心剛硬，不聽他們，正如耶和華對摩西所說的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","耶和華對摩西說：「你清早起來，站在法老面前，對他說：『耶和華－希伯來人的上帝這樣說：容我的百姓去，好事奉我。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","因為這一次我要叫一切的災殃臨到你和你臣僕並你百姓的身上，叫你知道在普天下沒有像我的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","我若伸手用瘟疫攻擊你和你的百姓，你早就從地上除滅了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","其實，我叫你存立，是特要向你顯我的大能，並要使我的名傳遍天下。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","你還向我的百姓自高，不容他們去嗎？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","到明天約在這時候，我必叫重大的冰雹降下，自從埃及開國以來，沒有這樣的冰雹。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","現在你要打發人把你的牲畜和你田間一切所有的催進來；凡在田間不收回家的，無論是人是牲畜，冰雹必降在他們身上，他們就必死。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","法老的臣僕中，懼怕耶和華這話的，便叫他的奴僕和牲畜跑進家來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","但那不把耶和華這話放在心上的，就將他的奴僕和牲畜留在田裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","耶和華對摩西說：「你向天伸杖，使埃及遍地的人身上和牲畜身上，並田間各樣菜蔬上，都有冰雹。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","摩西向天伸杖，耶和華就打雷下雹，有火閃到地上；耶和華下雹在埃及地上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","那時，雹與火攙雜，甚是厲害，自從埃及成國以來，遍地沒有這樣的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","在埃及遍地，雹擊打了田間所有的人和牲畜，並一切的菜蔬，又打壞田間一切的樹木。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","惟獨以色列人所住的歌珊地沒有冰雹。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","法老打發人召摩西、亞倫來，對他們說：「這一次我犯了罪了。耶和華是公義的；我和我的百姓是邪惡的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","這雷轟和冰雹已經夠了。請你們求耶和華，我就容你們去，不再留住你們。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","摩西對他說：「我一出城，就要向耶和華舉手禱告；雷必止住，也不再有冰雹，叫你知道全地都是屬耶和華的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","至於你和你的臣僕，我知道你們還是不懼怕耶和華上帝。」（ ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","那時，麻和大麥被雹擊打；因為大麥已經吐穗，麻也開了花。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","只是小麥和粗麥沒有被擊打，因為還沒有長成。） ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","摩西離了法老出城，向耶和華舉手禱告；雷和雹就止住，雨也不再澆在地上了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","法老見雨和雹與雷止住，就越發犯罪；他和他的臣僕都硬着心。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","法老的心剛硬，不容以色列人去，正如耶和華藉着摩西所說的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","耶和華對摩西說：「你進去見法老。我使他和他臣僕的心剛硬，為要在他們中間顯我這些神蹟， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","並要叫你將我向埃及人所做的事，和在他們中間所行的神蹟，傳於你兒子和你孫子的耳中，好叫你們知道我是耶和華。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","摩西、亞倫就進去見法老，對他說：「耶和華－希伯來人的上帝這樣說：『你在我面前不肯自卑要到幾時呢？容我的百姓去，好事奉我。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","你若不肯容我的百姓去，明天我要使蝗蟲進入你的境內， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","遮滿地面，甚至看不見地，並且吃那冰雹所剩的和田間所長的一切樹木。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","你的宮殿和你眾臣僕的房屋，並一切埃及人的房屋，都要被蝗蟲佔滿了；自從你祖宗和你祖宗的祖宗在世以來，直到今日，沒有見過這樣的災。』」摩西就轉身離開法老出去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","法老的臣僕對法老說：「這人為我們的網羅要到幾時呢？容這些人去事奉耶和華－他們的上帝吧！埃及已經敗壞了，你還不知道嗎？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","於是摩西、亞倫被召回來見法老；法老對他們說：「你們去事奉耶和華－你們的上帝；但那要去的是誰呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","摩西說：「我們要和我們老的少的、兒子女兒同去，且把羊群牛群一同帶去，因為我們務要向耶和華守節。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","法老對他們說：「我容你們和你們婦人孩子去的時候，耶和華與你們同在吧！你們要謹慎；因為有禍在你們眼前， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","不可都去！你們這壯年人去事奉耶和華吧，因為這是你們所求的。」於是把他們從法老面前攆出去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","耶和華對摩西說：「你向埃及地伸杖，使蝗蟲到埃及地上來，吃地上一切的菜蔬，就是冰雹所剩的。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","摩西就向埃及地伸杖，那一晝一夜，耶和華使東風颳在埃及地上；到了早晨，東風把蝗蟲颳了來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","蝗蟲上來，落在埃及的四境，甚是厲害；以前沒有這樣的，以後也必沒有。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","因為這蝗蟲遮滿地面，甚至地都黑暗了，又吃地上一切的菜蔬和冰雹所剩樹上的果子。埃及遍地，無論是樹木，是田間的菜蔬，連一點青的也沒有留下。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","於是法老急忙召了摩西、亞倫來，說：「我得罪耶和華－你們的上帝，又得罪了你們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","現在求你，只這一次，饒恕我的罪，求耶和華－你們的上帝使我脫離這一次的死亡。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","摩西就離開法老去求耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","耶和華轉了極大的西風，把蝗蟲颳起，吹入紅海；在埃及的四境連一個也沒有留下。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","但耶和華使法老的心剛硬，不容以色列人去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","耶和華對摩西說：「你向天伸杖，使埃及地黑暗；這黑暗似乎摸得着。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","摩西向天伸杖，埃及遍地就烏黑了三天。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","三天之久，人不能相見，誰也不敢起來離開本處；惟有以色列人家中都有亮光。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","法老就召摩西來，說：「你們去事奉耶和華；只是你們的羊群牛群要留下；你們的婦人孩子可以和你們同去。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","摩西說：「你總要把祭物和燔祭牲交給我們，使我們可以祭祀耶和華－我們的上帝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","我們的牲畜也要帶去，連一蹄也不留下；因為我們要從其中取出來，事奉耶和華－我們的上帝。我們未到那裏，還不知道用甚麼事奉耶和華。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","但耶和華使法老的心剛硬，不肯容他們去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","法老對摩西說：「你離開我去吧，你要小心，不要再見我的面！因為你見我面的那日你就必死！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","摩西說：「你說得好！我必不再見你的面了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","耶和華對摩西說：「我再使一樣的災殃臨到法老和埃及，然後他必容你們離開這地。他容你們去的時候，總要催逼你們都從這地出去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","你要傳於百姓的耳中，叫他們男女各人向鄰舍要金器銀器。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","耶和華叫百姓在埃及人眼前蒙恩，並且摩西在埃及地、法老臣僕，和百姓的眼中看為極大。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","摩西說：「耶和華這樣說：『約到半夜，我必出去巡行埃及遍地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","凡在埃及地，從坐寶座的法老直到磨子後的婢女所有的長子，以及一切頭生的牲畜，都必死。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","埃及遍地必有大哀號；從前沒有這樣的，後來也必沒有。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","至於以色列中，無論是人是牲畜，連狗也不敢向他們搖舌，好叫你們知道耶和華是將埃及人和以色列人分別出來。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","你這一切臣僕都要俯伏來見我，說：『求你和跟從你的百姓都出去』，然後我要出去。」於是，摩西氣忿忿地離開法老，出去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","耶和華對摩西說：「法老必不聽你們，使我的奇事在埃及地多起來。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","摩西、亞倫在法老面前行了這一切奇事；耶和華使法老的心剛硬，不容以色列人出離他的地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","耶和華在埃及地曉諭摩西、亞倫說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","「你們要以本月為正月，為一年之首。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","你們吩咐以色列全會眾說：本月初十日，各人要按着父家取羊羔，一家一隻。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","若是一家的人太少，吃不了一隻羊羔，本人就要和他隔壁的鄰舍共取一隻。你們預備羊羔，要按着人數和飯量計算。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","要無殘疾、一歲的公羊羔，你們或從綿羊裏取，或從山羊裏取，都可以。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","要留到本月十四日，在黃昏的時候，以色列全會眾把羊羔宰了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","各家要取點血，塗在吃羊羔的房屋左右的門框上和門楣上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","當夜要吃羊羔的肉；用火烤了，與無酵餅和苦菜同吃。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","不可吃生的，斷不可吃水煮的，要帶着頭、腿、五臟，用火烤了吃。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","不可剩下一點留到早晨；若留到早晨，要用火燒了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","你們吃羊羔當腰間束帶，腳上穿鞋，手中拿杖，趕緊地吃；這是耶和華的逾越節。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","因為那夜我要巡行埃及地，把埃及地一切頭生的，無論是人是牲畜，都擊殺了，又要敗壞埃及一切的神。我是耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","這血要在你們所住的房屋上作記號；我一見這血，就越過你們去。我擊殺埃及地頭生的時候，災殃必不臨到你們身上滅你們。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","「你們要記念這日，守為耶和華的節，作為你們世世代代永遠的定例。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","你們要吃無酵餅七日。頭一日要把酵從你們各家中除去；因為從頭一日起，到第七日為止，凡吃有酵之餅的，必從以色列中剪除。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","頭一日你們當有聖會，第七日也當有聖會。這兩日之內，除了預備各人所要吃的以外，無論何工都不可做。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","你們要守無酵節，因為我正當這日把你們的軍隊從埃及地領出來。所以，你們要守這日，作為世世代代永遠的定例。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","從正月十四日晚上，直到二十一日晚上，你們要吃無酵餅。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","在你們各家中，七日之內不可有酵；因為凡吃有酵之物的，無論是寄居的，是本地的，必從以色列的會中剪除。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","有酵的物，你們都不可吃；在你們一切住處要吃無酵餅。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","於是，摩西召了以色列的眾長老來，對他們說：「你們要按着家口取出羊羔，把這逾越節的羊羔宰了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","拿一把牛膝草，蘸盆裏的血，打在門楣上和左右的門框上。你們誰也不可出自己的房門，直到早晨。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","因為耶和華要巡行擊殺埃及人，他看見血在門楣上和左右的門框上，就必越過那門，不容滅命的進你們的房屋，擊殺你們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","這例，你們要守着，作為你們和你們子孫永遠的定例。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","日後，你們到了耶和華按着所應許賜給你們的那地，就要守這禮。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","你們的兒女問你們說：『行這禮是甚麼意思？』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","你們就說：『這是獻給耶和華逾越節的祭。當以色列人在埃及的時候，他擊殺埃及人，越過以色列人的房屋，救了我們各家。』」於是百姓低頭下拜。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","耶和華怎樣吩咐摩西、亞倫，以色列人就怎樣行。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","到了半夜，耶和華把埃及地所有的長子，就是從坐寶座的法老，直到被擄囚在監裏之人的長子，以及一切頭生的牲畜，盡都殺了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","法老和一切臣僕，並埃及眾人，夜間都起來了。在埃及有大哀號，無一家不死一個人的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","夜間，法老召了摩西、亞倫來，說：「起來！連你們帶以色列人，從我民中出去，依你們所說的，去事奉耶和華吧！ ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","也依你們所說的，連羊群牛群帶着走吧！並要為我祝福。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","埃及人催促百姓，打發他們快快出離那地，因為埃及人說：「我們都要死了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","百姓就拿着沒有酵的生麵，把摶麵盆包在衣服中，扛在肩頭上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","以色列人照着摩西的話行，向埃及人要金器、銀器，和衣裳。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","耶和華叫百姓在埃及人眼前蒙恩，以致埃及人給他們所要的。他們就把埃及人的財物奪去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","以色列人從蘭塞起行，往疏割去；除了婦人孩子，步行的男人約有六十萬。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","又有許多閒雜人，並有羊群牛群，和他們一同上去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","他們用埃及帶出來的生麵烤成無酵餅。這生麵原沒有發起；因為他們被催逼離開埃及，不能耽延，也沒有為自己預備甚麼食物。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","以色列人住在埃及共有四百三十年。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","正滿了四百三十年的那一天，耶和華的軍隊都從埃及地出來了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","這夜是耶和華的夜；因耶和華領他們出了埃及地，所以當向耶和華謹守，是以色列眾人世世代代該謹守的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","耶和華對摩西、亞倫說：「逾越節的例是這樣：外邦人都不可吃這羊羔。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","但各人用銀子買的奴僕，既受了割禮就可以吃。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","寄居的和雇工人都不可吃。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","應當在一個房子裏吃；不可把一點肉從房子裏帶到外頭去。羊羔的骨頭一根也不可折斷。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","以色列全會眾都要守這禮。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","若有外人寄居在你們中間，願向耶和華守逾越節，他所有的男子務要受割禮，然後才容他前來遵守，他也就像本地人一樣；但未受割禮的，都不可吃這羊羔。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","本地人和寄居在你們中間的外人同歸一例。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","耶和華怎樣吩咐摩西、亞倫，以色列眾人就怎樣行了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","正當那日，耶和華將以色列人按着他們的軍隊，從埃及地領出來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","耶和華曉諭摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","「以色列中凡頭生的，無論是人是牲畜，都是我的，要分別為聖歸我。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","摩西對百姓說：「你們要記念從埃及為奴之家出來的這日，因為耶和華用大能的手將你們從這地方領出來。有酵的餅都不可吃。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","亞筆月間的這日是你們出來的日子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","將來耶和華領你進迦南人、赫人、亞摩利人、希未人、耶布斯人之地，就是他向你的祖宗起誓應許給你那流奶與蜜之地，那時你要在這月間守這禮。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","你要吃無酵餅七日，到第七日要向耶和華守節。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","這七日之久，要吃無酵餅；在你四境之內不可見有酵的餅，也不可見發酵的物。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","當那日，你要告訴你的兒子說：『這是因耶和華在我出埃及的時候為我所行的事。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","這要在你手上作記號，在你額上作紀念，使耶和華的律法常在你口中，因為耶和華曾用大能的手將你從埃及領出來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","所以你每年要按着日期守這例。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","「將來，耶和華照他向你和你祖宗所起的誓將你領進迦南人之地，把這地賜給你， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","那時你要將一切頭生的，並牲畜中頭生的，歸給耶和華；公的都要屬耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","凡頭生的驢，你要用羊羔代贖；若不代贖，就要打折牠的頸項。凡你兒子中頭生的都要贖出來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","日後，你的兒子問你說：『這是甚麼意思？』你就說：『耶和華用大能的手將我們從埃及為奴之家領出來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","那時法老幾乎不容我們去，耶和華就把埃及地所有頭生的，無論是人是牲畜，都殺了。因此，我把一切頭生的公牲畜獻給耶和華為祭，但將頭生的兒子都贖出來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","這要在你手上作記號，在你額上作經文，因為耶和華用大能的手將我們從埃及領出來。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","法老容百姓去的時候，非利士地的道路雖近，上帝卻不領他們從那裏走；因為上帝說：「恐怕百姓遇見打仗後悔，就回埃及去。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","所以上帝領百姓繞道而行，走紅海曠野的路。以色列人出埃及地，都帶着兵器上去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","摩西把約瑟的骸骨一同帶去；因為約瑟曾叫以色列人嚴嚴地起誓，對他們說：「上帝必眷顧你們，你們要把我的骸骨從這裏一同帶上去。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","他們從疏割起行，在曠野邊的以倘安營。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","日間，耶和華在雲柱中領他們的路；夜間，在火柱中光照他們，使他們日夜都可以行走。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","日間雲柱，夜間火柱，總不離開百姓的面前。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","耶和華曉諭摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","「你吩咐以色列人轉回，安營在比‧哈希錄前，密奪和海的中間，對着巴力‧洗分，靠近海邊安營。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","法老必說：『以色列人在地中繞迷了，曠野把他們困住了。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","我要使法老的心剛硬，他要追趕他們，我便在法老和他全軍身上得榮耀；埃及人就知道我是耶和華。」於是以色列人這樣行了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","有人告訴埃及王說：「百姓逃跑。」法老和他的臣僕就向百姓變心，說：「我們容以色列人去，不再服事我們，這做的是甚麼事呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","法老就預備他的車輛，帶領軍兵同去， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","並帶着六百輛特選的車和埃及所有的車，每輛都有車兵長。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","耶和華使埃及王法老的心剛硬，他就追趕以色列人，因為以色列人是昂然無懼地出埃及。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","埃及人追趕他們，法老一切的馬匹、車輛、馬兵，與軍兵就在海邊上，靠近比‧哈希錄，對着巴力‧洗分，在他們安營的地方追上了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","法老臨近的時候，以色列人舉目看見埃及人趕來，就甚懼怕，向耶和華哀求。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","他們對摩西說：「難道在埃及沒有墳地，你把我們帶來死在曠野嗎？你為甚麼這樣待我們，將我們從埃及領出來呢？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","我們在埃及豈沒有對你說過，不要攪擾我們，容我們服事埃及人嗎？因為服事埃及人比死在曠野還好。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","摩西對百姓說：「不要懼怕，只管站住！看耶和華今天向你們所要施行的救恩。因為，你們今天所看見的埃及人必永遠不再看見了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","耶和華必為你們爭戰；你們只管靜默，不要作聲。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","耶和華對摩西說：「你為甚麼向我哀求呢？你吩咐以色列人往前走。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","你舉手向海伸杖，把水分開。以色列人要下海中走乾地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","我要使埃及人的心剛硬，他們就跟着下去。我要在法老和他的全軍、車輛、馬兵上得榮耀。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","我在法老和他的車輛、馬兵上得榮耀的時候，埃及人就知道我是耶和華了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","在以色列營前行走上帝的使者，轉到他們後邊去；雲柱也從他們前邊轉到他們後邊立住。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","在埃及營和以色列營中間有雲柱，一邊黑暗，一邊發光，終夜兩下不得相近。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","摩西向海伸杖，耶和華便用大東風，使海水一夜退去，水便分開，海就成了乾地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","以色列人下海中走乾地，水在他們的左右作了牆垣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","埃及人追趕他們，法老一切的馬匹、車輛，和馬兵都跟着下到海中。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","到了晨更的時候，耶和華從雲火柱中向埃及的軍兵觀看，使埃及的軍兵混亂了； ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","又使他們的車輪脫落，難以行走，以致埃及人說：「我們從以色列人面前逃跑吧！因耶和華為他們攻擊我們了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","耶和華對摩西說：「你向海伸杖，叫水仍合在埃及人並他們的車輛、馬兵身上。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","摩西就向海伸杖，到了天一亮，海水仍舊復原。埃及人避水逃跑的時候，耶和華把他們推翻在海中， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","水就回流，淹沒了車輛和馬兵。那些跟着以色列人下海法老的全軍，連一個也沒有剩下。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","以色列人卻在海中走乾地；水在他們的左右作了牆垣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","當日，耶和華這樣拯救以色列人脫離埃及人的手，以色列人看見埃及人的死屍都在海邊了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","以色列人看見耶和華向埃及人所行的大事，就敬畏耶和華，又信服他和他的僕人摩西。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","那時，摩西和以色列人向耶和華唱歌說： 我要向耶和華歌唱，因他大大戰勝， 將馬和騎馬的投在海中。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","耶和華是我的力量，我的詩歌， 也成了我的拯救。 這是我的上帝，我要讚美他， 是我父親的上帝，我要尊崇他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","耶和華是戰士； 他的名是耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","法老的車輛、軍兵，耶和華已拋在海中； 他特選的軍長都沉於紅海。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","深水淹沒他們； 他們如同石頭墜到深處。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","耶和華啊，你的右手施展能力，顯出榮耀； 耶和華啊，你的右手摔碎仇敵。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","你大發威嚴，推翻那些起來攻擊你的； 你發出烈怒如火，燒滅他們像燒碎稭一樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","你發鼻中的氣，水便聚起成堆， 大水直立如壘， 海中的深水凝結。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","仇敵說：我要追趕，我要追上； 我要分擄物，我要在他們身上稱我的心願。 我要拔出刀來，親手殺滅他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","你叫風一吹，海就把他們淹沒； 他們如鉛沉在大水之中。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","耶和華啊，眾神之中，誰能像你？ 誰能像你－至聖至榮， 可頌可畏，施行奇事？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","你伸出右手， 地便吞滅他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","你憑慈愛領了你所贖的百姓； 你憑能力引他們到了你的聖所。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","外邦人聽見就發顫； 疼痛抓住非利士的居民。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","那時，以東的族長驚惶， 摩押的英雄被戰兢抓住， 迦南的居民心都消化了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","驚駭恐懼臨到他們。 耶和華啊，因你膀臂的大能， 他們如石頭寂然不動， 等候你的百姓過去， 等候你所贖的百姓過去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","你要將他們領進去，栽於你產業的山上－ 耶和華啊，就是你為自己所造的住處； 主啊，就是你手所建立的聖所。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","耶和華必作王，直到永永遠遠！ ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","法老的馬匹、車輛，和馬兵下到海中，耶和華使海水回流，淹沒他們；惟有以色列人在海中走乾地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","亞倫的姊姊，女先知米利暗，手裏拿着鼓；眾婦女也跟她出去拿鼓跳舞。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","米利暗應聲說： 你們要歌頌耶和華，因他大大戰勝， 將馬和騎馬的投在海中。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","摩西領以色列人從紅海往前行，到了書珥的曠野，在曠野走了三天，找不着水。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","到了瑪拉，不能喝那裏的水；因為水苦，所以那地名叫瑪拉。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","百姓就向摩西發怨言，說：「我們喝甚麼呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","摩西呼求耶和華，耶和華指示他一棵樹。他把樹丟在水裏，水就變甜了。 耶和華在那裏為他們定了律例、典章，在那裏試驗他們； ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","又說：「你若留意聽耶和華－你上帝的話，又行我眼中看為正的事，留心聽我的誡命，守我一切的律例，我就不將所加與埃及人的疾病加在你身上，因為我－耶和華是醫治你的。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","他們到了以琳，在那裏有十二股水泉，七十棵棕樹；他們就在那裏的水邊安營。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","以色列全會眾從以琳起行，在出埃及後第二個月十五日到了以琳和西奈中間、汛的曠野。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","以色列全會眾在曠野向摩西、亞倫發怨言， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","說：「巴不得我們早死在埃及地、耶和華的手下；那時我們坐在肉鍋旁邊，吃得飽足。你們將我們領出來，到這曠野，是要叫這全會眾都餓死啊！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","耶和華對摩西說：「我要將糧食從天降給你們。百姓可以出去，每天收每天的分，我好試驗他們遵不遵我的法度。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","到第六天，他們要把所收進來的預備好了，比每天所收的多一倍。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","摩西、亞倫對以色列眾人說：「到了晚上，你們要知道是耶和華將你們從埃及地領出來的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","早晨，你們要看見耶和華的榮耀，因為耶和華聽見你們向他所發的怨言了。我們算甚麼，你們竟向我們發怨言呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","摩西又說：「耶和華晚上必給你們肉吃，早晨必給你們食物得飽；因為你們向耶和華發的怨言，他都聽見了。我們算甚麼，你們的怨言不是向我們發的，乃是向耶和華發的。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","摩西對亞倫說：「你告訴以色列全會眾說：『你們就近耶和華面前，因為他已經聽見你們的怨言了。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","亞倫正對以色列全會眾說話的時候，他們向曠野觀看，不料，耶和華的榮光在雲中顯現。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","耶和華曉諭摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","「我已經聽見以色列人的怨言。你告訴他們說：『到黃昏的時候，你們要吃肉，早晨必有食物得飽，你們就知道我是耶和華－你們的上帝。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","到了晚上，有鵪鶉飛來，遮滿了營；早晨在營四圍的地上有露水。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","露水上升之後，不料，野地面上有如白霜的小圓物。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","以色列人看見，不知道是甚麼，就彼此對問說：「這是甚麼呢？」摩西對他們說：「這就是耶和華給你們吃的食物。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","耶和華所吩咐的是這樣：你們要按着各人的飯量，為帳棚裏的人，按着人數收起來，各拿一俄梅珥。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","以色列人就這樣行；有多收的，有少收的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","及至用俄梅珥量一量，多收的也沒有餘，少收的也沒有缺；各人按着自己的飯量收取。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","摩西對他們說：「所收的，不許甚麼人留到早晨。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","然而他們不聽摩西的話，內中有留到早晨的，就生蟲變臭了；摩西便向他們發怒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","他們每日早晨，按着各人的飯量收取，日頭一發熱，就消化了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","到第六天，他們收了雙倍的食物，每人兩俄梅珥。會眾的官長來告訴摩西； ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","摩西對他們說：「耶和華這樣說：『明天是聖安息日，是向耶和華守的聖安息日。你們要烤的就烤了，要煮的就煮了，所剩下的都留到早晨。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","他們就照摩西的吩咐留到早晨，也不臭，裏頭也沒有蟲子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","摩西說：「你們今天吃這個吧！因為今天是向耶和華守的安息日；你們在田野必找不着了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","六天可以收取，第七天乃是安息日，那一天必沒有了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","第七天，百姓中有人出去收，甚麼也找不着。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","耶和華對摩西說：「你們不肯守我的誡命和律法，要到幾時呢？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","你們看！耶和華既將安息日賜給你們，所以第六天他賜給你們兩天的食物，第七天各人要住在自己的地方，不許甚麼人出去。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","於是百姓第七天安息了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","這食物，以色列家叫嗎哪；樣子像芫荽子，顏色是白的，滋味如同攙蜜的薄餅。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","摩西說：「耶和華所吩咐的是這樣：『要將一滿俄梅珥嗎哪留到世世代代，使後人可以看見我當日將你們領出埃及地，在曠野所給你們吃的食物。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","摩西對亞倫說：「你拿一個罐子，盛一滿俄梅珥嗎哪，存在耶和華面前，要留到世世代代。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","耶和華怎麼吩咐摩西，亞倫就怎麼行，把嗎哪放在法櫃前存留。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","以色列人吃嗎哪共四十年，直到進了有人居住之地，就是迦南的境界。（ ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","俄梅珥就是伊法十分之一。） ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","以色列全會眾都遵耶和華的吩咐，按着站口從汛的曠野往前行，在利非訂安營。百姓沒有水喝， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","所以與摩西爭鬧，說：「給我們水喝吧！」摩西對他們說：「你們為甚麼與我爭鬧？為甚麼試探耶和華呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","百姓在那裏甚渴，要喝水，就向摩西發怨言，說：「你為甚麼將我們從埃及領出來，使我們和我們的兒女並牲畜都渴死呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","摩西就呼求耶和華說：「我向這百姓怎樣行呢？他們幾乎要拿石頭打死我。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","耶和華對摩西說：「你手裏拿着你先前擊打河水的杖，帶領以色列的幾個長老，從百姓面前走過去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","我必在何烈的磐石那裏，站在你面前。你要擊打磐石，從磐石裏必有水流出來，使百姓可以喝。」摩西就在以色列的長老眼前這樣行了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","他給那地方起名叫瑪撒，又叫米利巴；因以色列人爭鬧，又因他們試探耶和華，說：「耶和華是在我們中間不是？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","那時，亞瑪力人來在利非訂，和以色列人爭戰。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","摩西對約書亞說：「你為我們選出人來，出去和亞瑪力人爭戰。明天我手裏要拿着上帝的杖，站在山頂上。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","於是約書亞照着摩西對他所說的話行，和亞瑪力人爭戰。摩西、亞倫，與戶珥都上了山頂。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","摩西何時舉手，以色列人就得勝，何時垂手，亞瑪力人就得勝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","但摩西的手發沉，他們就搬石頭來，放在他以下，他就坐在上面。亞倫與戶珥扶着他的手，一個在這邊，一個在那邊，他的手就穩住，直到日落的時候。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","約書亞用刀殺了亞瑪力王和他的百姓。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","耶和華對摩西說：「我要將亞瑪力的名號從天下全然塗抹了；你要將這話寫在書上作紀念，又念給約書亞聽。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","摩西築了一座壇，起名叫「耶和華尼西」， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","又說：「耶和華已經起了誓，必世世代代和亞瑪力人爭戰。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","摩西的岳父，米甸祭司葉忒羅，聽見上帝為摩西和上帝的百姓以色列所行的一切事，就是耶和華將以色列從埃及領出來的事， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","便帶着摩西的妻子西坡拉，就是摩西從前打發回去的， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","又帶着西坡拉的兩個兒子，一個名叫革舜，因為摩西說：「我在外邦作了寄居的」； ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","一個名叫以利以謝，因為他說：「我父親的上帝幫助了我，救我脫離法老的刀。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","摩西的岳父葉忒羅帶着摩西的妻子和兩個兒子來到上帝的山，就是摩西在曠野安營的地方。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","他對摩西說：「我是你岳父葉忒羅，帶着你的妻子和兩個兒子來到你這裏。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","摩西迎接他的岳父，向他下拜，與他親嘴，彼此問安，都進了帳棚。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","摩西將耶和華為以色列的緣故向法老和埃及人所行的一切事，以及路上所遭遇的一切艱難，並耶和華怎樣搭救他們，都述說與他岳父聽。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","葉忒羅因耶和華待以色列的一切好處，就是拯救他們脫離埃及人的手，便甚歡喜。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","葉忒羅說：「耶和華是應當稱頌的；他救了你們脫離埃及人和法老的手，將這百姓從埃及人的手下救出來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","我現今在埃及人向這百姓發狂傲的事上得知，耶和華比萬神都大。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","摩西的岳父葉忒羅把燔祭和平安祭獻給上帝。亞倫和以色列的眾長老都來了，與摩西的岳父在上帝面前吃飯。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","第二天，摩西坐着審判百姓，百姓從早到晚都站在摩西的左右。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","摩西的岳父看見他向百姓所做的一切事，就說：「你向百姓做的是甚麼事呢？你為甚麼獨自坐着，眾百姓從早到晚都站在你的左右呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","摩西對岳父說：「這是因百姓到我這裏來求問上帝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","他們有事的時候就到我這裏來，我便在兩造之間施行審判；我又叫他們知道上帝的律例和法度。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","摩西的岳父說：「你這做的不好。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","你和這些百姓必都疲憊；因為這事太重，你獨自一人辦理不了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","現在你要聽我的話。我為你出個主意，願上帝與你同在。你要替百姓到上帝面前，將案件奏告上帝； ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","又要將律例和法度教訓他們，指示他們當行的道，當做的事； ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","並要從百姓中揀選有才能的人，就是敬畏上帝、誠實無妄、恨不義之財的人，派他們作千夫長、百夫長、五十夫長、十夫長，管理百姓， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","叫他們隨時審判百姓，大事都要呈到你這裏，小事他們自己可以審判。這樣，你就輕省些，他們也可以同當此任。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","你若這樣行，上帝也這樣吩咐你，你就能受得住，這百姓也都平平安安歸回他們的住處。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","於是，摩西聽從他岳父的話，按着他所說的去行。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","摩西從以色列人中揀選了有才能的人，立他們為百姓的首領，作千夫長、百夫長、五十夫長、十夫長。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","他們隨時審判百姓，有難斷的案件就呈到摩西那裏，但各樣小事他們自己審判。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","此後，摩西讓他的岳父去，他就往本地去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","以色列人出埃及地以後，滿了三個月的那一天，就來到西奈的曠野。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","他們離了利非訂，來到西奈的曠野，就在那裏的山下安營。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","摩西到上帝那裏，耶和華從山上呼喚他說：「你要這樣告訴雅各家，曉諭以色列人說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","『我向埃及人所行的事，你們都看見了，且看見我如鷹將你們背在翅膀上，帶來歸我。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","如今你們若實在聽從我的話，遵守我的約，就要在萬民中作屬我的子民，因為全地都是我的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","你們要歸我作祭司的國度，為聖潔的國民。』這些話你要告訴以色列人。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","摩西去召了民間的長老來，將耶和華所吩咐他的話都在他們面前陳明。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","百姓都同聲回答說：「凡耶和華所說的，我們都要遵行。」摩西就將百姓的話回覆耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","耶和華對摩西說：「我要在密雲中臨到你那裏，叫百姓在我與你說話的時候可以聽見，也可以永遠信你了。」 於是，摩西將百姓的話奏告耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","耶和華又對摩西說：「你往百姓那裏去，叫他們今天明天自潔，又叫他們洗衣服。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","到第三天要預備好了，因為第三天耶和華要在眾百姓眼前降臨在西奈山上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","你要在山的四圍給百姓定界限，說：『你們當謹慎，不可上山去，也不可摸山的邊界；凡摸這山的，必要治死他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","不可用手摸他，必用石頭打死，或用箭射透；無論是人是牲畜，都不得活。到角聲拖長的時候，他們才可到山根來。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","摩西下山往百姓那裏去，叫他們自潔，他們就洗衣服。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","他對百姓說：「到第三天要預備好了。不可親近女人。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","到了第三天早晨，在山上有雷轟、閃電，和密雲，並且角聲甚大，營中的百姓盡都發顫。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","摩西率領百姓出營迎接上帝，都站在山下。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","西奈全山冒煙，因為耶和華在火中降於山上。山的煙氣上騰，如燒窯一般，遍山大大地震動。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","角聲漸漸地高而又高，摩西就說話，上帝有聲音答應他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","耶和華降臨在西奈山頂上，耶和華召摩西上山頂，摩西就上去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","耶和華對摩西說：「你下去囑咐百姓，不可闖過來到我面前觀看，恐怕他們有多人死亡； ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","又叫親近我的祭司自潔，恐怕我忽然出來擊殺他們。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","摩西對耶和華說：「百姓不能上西奈山，因為你已經囑咐我們說：『要在山的四圍定界限，叫山成聖。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","耶和華對他說：「下去吧，你要和亞倫一同上來；只是祭司和百姓不可闖過來上到我面前，恐怕我忽然出來擊殺他們。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","於是摩西下到百姓那裏告訴他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","上帝吩咐這一切的話說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","「我是耶和華－你的上帝，曾將你從埃及地為奴之家領出來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","「除了我以外，你不可有別的神。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","「不可為自己雕刻偶像，也不可做甚麼形像彷彿上天、下地，和地底下、水中的百物。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","不可跪拜那些像，也不可事奉它，因為我耶和華－你的上帝是忌邪的上帝。恨我的，我必追討他的罪，自父及子，直到三四代； ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","愛我、守我誡命的，我必向他們發慈愛，直到千代。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","「不可妄稱耶和華－你上帝的名；因為妄稱耶和華名的，耶和華必不以他為無罪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","「當記念安息日，守為聖日。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","六日要勞碌做你一切的工， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","但第七日是向耶和華－你上帝當守的安息日。這一日你和你的兒女、僕婢、牲畜，並你城裏寄居的客旅，無論何工都不可做； ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","因為六日之內，耶和華造天、地、海，和其中的萬物，第七日便安息，所以耶和華賜福與安息日，定為聖日。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","「當孝敬父母，使你的日子在耶和華－你上帝所賜你的地上得以長久。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","「不可殺人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","「不可姦淫。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","「不可偷盜。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","「不可作假見證陷害人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","「不可貪戀人的房屋；也不可貪戀人的妻子、僕婢、牛驢，並他一切所有的。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","眾百姓見雷轟、閃電、角聲、山上冒煙，就都發顫，遠遠地站立， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","對摩西說：「求你和我們說話，我們必聽；不要上帝和我們說話，恐怕我們死亡。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","摩西對百姓說：「不要懼怕；因為上帝降臨是要試驗你們，叫你們時常敬畏他，不致犯罪。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","於是百姓遠遠地站立；摩西就挨近上帝所在的幽暗之中。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","耶和華對摩西說：「你要向以色列人這樣說：『你們自己看見我從天上和你們說話了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","你們不可做甚麼神像與我相配，不可為自己做金銀的神像。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","你要為我築土壇，在上面以牛羊獻為燔祭和平安祭。凡記下我名的地方，我必到那裏賜福給你。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","你若為我築一座石壇，不可用鑿成的石頭，因你在上頭一動家具，就把壇污穢了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","你上我的壇，不可用臺階，免得露出你的下體來。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","「你在百姓面前所要立的典章是這樣： ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","你若買希伯來人作奴僕，他必服事你六年；第七年他可以自由，白白地出去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","他若孤身來就可以孤身去；他若有妻，他的妻就可以同他出去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","他主人若給他妻子，妻子給他生了兒子或女兒，妻子和兒女要歸主人，他要獨自出去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","倘或奴僕明說：『我愛我的主人和我的妻子兒女，不願意自由出去。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","他的主人就要帶他到審判官那裏，又要帶他到門前，靠近門框，用錐子穿他的耳朵，他就永遠服事主人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","「人若賣女兒作婢女，婢女不可像男僕那樣出去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","主人選定她歸自己，若不喜歡她，就要許她贖身；主人既然用詭詐待她，就沒有權柄賣給外邦人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","主人若選定她給自己的兒子，就當待她如同女兒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","若另娶一個，那女子的吃食、衣服，並好合的事，仍不可減少。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","若不向她行這三樣，她就可以不用錢贖，白白地出去。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","「打人以致打死的，必要把他治死。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","人若不是埋伏着殺人，乃是上帝交在他手中，我就設下一個地方，他可以往那裏逃跑。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","人若任意用詭計殺了他的鄰舍，就是逃到我的壇那裏，也當捉去把他治死。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","「打父母的，必要把他治死。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","「拐帶人口，或是把人賣了，或是留在他手下，必要把他治死。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","「咒罵父母的，必要把他治死。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","「人若彼此相爭，這個用石頭或是拳頭打那個，尚且不至於死，不過躺臥在床， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","若再能起來扶杖而出，那打他的可算無罪；但要將他耽誤的工夫用錢賠補，並要將他全然醫好。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","「人若用棍子打奴僕或婢女，立時死在他的手下，他必要受刑。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","若過一兩天才死，就可以不受刑，因為是用錢買的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","「人若彼此爭鬥，傷害有孕的婦人，甚至墜胎，隨後卻無別害，那傷害她的，總要按婦人的丈夫所要的，照審判官所斷的，受罰。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","若有別害，就要以命償命， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","以眼還眼，以牙還牙，以手還手，以腳還腳， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","以烙還烙，以傷還傷，以打還打。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","「人若打壞了他奴僕或是婢女的一隻眼，就要因他的眼放他去得以自由。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","若打掉了他奴僕或是婢女的一個牙，就要因他的牙放他去得以自由。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","「牛若觸死男人或是女人，總要用石頭打死那牛，卻不可吃牠的肉；牛的主人可算無罪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","倘若那牛素來是觸人的，有人報告了牛主，他竟不把牛拴着，以致把男人或是女人觸死，就要用石頭打死那牛，牛主也必治死。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","若罰他贖命的價銀，他必照所罰的贖他的命。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","牛無論觸了人的兒子或是女兒，必照這例辦理。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","牛若觸了奴僕或是婢女，必將銀子三十舍客勒給他們的主人，也要用石頭把牛打死。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","「人若敞着井口，或挖井不遮蓋，有牛或驢掉在裏頭， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","井主要拿錢賠還本主人，死牲畜要歸自己。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","「這人的牛若傷了那人的牛，以至於死，他們要賣了活牛，平分價值，也要平分死牛。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","人若知道這牛素來是觸人的，主人竟不把牛拴着，他必要以牛還牛，死牛要歸自己。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","「人若偷牛或羊，無論是宰了，是賣了，他就要以五牛賠一牛，四羊賠一羊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","人若遇見賊挖窟窿，把賊打了，以至於死，就不能為他有流血的罪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","若太陽已經出來，就為他有流血的罪。賊若被拿，總要賠還。若他一無所有，就要被賣，頂他所偷的物。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","若他所偷的，或牛，或驢，或羊，仍在他手下存活，他就要加倍賠還。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","「人若在田間或在葡萄園裏放牲畜，任憑牲畜上別人的田裏去吃，就必拿自己田間上好的和葡萄園上好的賠還。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","「若點火焚燒荊棘，以致將別人堆積的禾捆，站着的禾稼，或是田園，都燒盡了，那點火的必要賠還。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","「人若將銀錢或家具交付鄰舍看守，這物從那人的家被偷去，若把賊找到了，賊要加倍賠還； ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","若找不到賊，那家主必就近審判官，要看看他拿了原主的物件沒有。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","「兩個人的案件，無論是為甚麼過犯，或是為牛，為驢，為羊，為衣裳，或是為甚麼失掉之物，有一人說：『這是我的』，兩造就要將案件稟告審判官，審判官定誰有罪，誰就要加倍賠還。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","「人若將驢，或牛，或羊，或別的牲畜，交付鄰舍看守，牲畜或死，或受傷，或被趕去，無人看見， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","那看守的人要憑着耶和華起誓，手裏未曾拿鄰舍的物，本主就要罷休，看守的人不必賠還。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","牲畜若從看守的那裏被偷去，他就要賠還本主； ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","若被野獸撕碎，看守的要帶來當作證據，所撕的不必賠還。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","「人若向鄰舍借甚麼，所借的或受傷，或死，本主沒有同在一處，借的人總要賠還； ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","若本主同在一處，他就不必賠還；若是雇的，也不必賠還，本是為雇價來的。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","「人若引誘沒有受聘的處女，與她行淫，他總要交出聘禮，娶她為妻。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","若女子的父親決不肯將女子給他，他就要按處女的聘禮，交出錢來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","「行邪術的女人，不可容她存活。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","「凡與獸淫合的，總要把他治死。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","「祭祀別神，不單單祭祀耶和華的，那人必要滅絕。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","「不可虧負寄居的，也不可欺壓他，因為你們在埃及地也作過寄居的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","不可苦待寡婦和孤兒； ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","若是苦待他們一點，他們向我一哀求，我總要聽他們的哀聲， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","並要發烈怒，用刀殺你們，使你們的妻子為寡婦，兒女為孤兒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","「我民中有貧窮人與你同住，你若借錢給他，不可如放債的向他取利。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","你即或拿鄰舍的衣服作當頭，必在日落以先歸還他； ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","因他只有這一件當蓋頭，是他蓋身的衣服，若是沒有，他拿甚麼睡覺呢？他哀求我，我就應允，因為我是有恩惠的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","「不可毀謗上帝；也不可毀謗你百姓的官長。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","「你要從你莊稼中的穀和酒醡中滴出來的酒拿來獻上，不可遲延。 「你要將頭生的兒子歸給我。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","你牛羊頭生的，也要這樣；七天當跟着母，第八天要歸給我。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","「你們要在我面前為聖潔的人。因此，田間被野獸撕裂牲畜的肉，你們不可吃，要丟給狗吃。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","「不可隨夥佈散謠言；不可與惡人連手妄作見證。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","不可隨眾行惡；不可在爭訟的事上隨眾偏行，作見證屈枉正直； ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","也不可在爭訟的事上偏護窮人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","「若遇見你仇敵的牛或驢失迷了路，總要牽回來交給他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","若看見恨你人的驢壓臥在重馱之下，不可走開，務要和驢主一同抬開重馱。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","「不可在窮人爭訟的事上屈枉正直。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","當遠離虛假的事。不可殺無辜和有義的人，因我必不以惡人為義。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","不可受賄賂；因為賄賂能叫明眼人變瞎了，又能顛倒義人的話。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","「不可欺壓寄居的；因為你們在埃及地作過寄居的，知道寄居的心。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","「六年你要耕種田地，收藏土產， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","只是第七年要叫地歇息，不耕不種，使你民中的窮人有吃的；他們所剩下的，野獸可以吃。你的葡萄園和橄欖園也要照樣辦理。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","「六日你要做工，第七日要安息，使牛、驢可以歇息，並使你婢女的兒子和寄居的都可以舒暢。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","「凡我對你們說的話，你們要謹守。別神的名，你不可提，也不可從你口中傳說。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","「一年三次，你要向我守節。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","你要守除酵節，照我所吩咐你的，在亞筆月內所定的日期，吃無酵餅七天。誰也不可空手朝見我，因為你是這月出了埃及。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","又要守收割節，所收的是你田間所種、勞碌得來初熟之物。並在年底收藏，要守收藏節。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","一切的男丁要一年三次朝見主耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","「不可將我祭牲的血和有酵的餅一同獻上；也不可將我節上祭牲的脂油留到早晨。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","「地裏首先初熟之物要送到耶和華－你上帝的殿。 「不可用山羊羔母的奶煮山羊羔。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","「看哪，我差遣使者在你前面，在路上保護你，領你到我所預備的地方去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","他是奉我名來的；你們要在他面前謹慎，聽從他的話，不可惹 他，因為他必不赦免你們的過犯。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","「你若實在聽從他的話，照着我一切所說的去行，我就向你的仇敵作仇敵，向你的敵人作敵人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","「我的使者要在你前面行，領你到亞摩利人、赫人、比利洗人、迦南人、希未人、耶布斯人那裏去，我必將他們剪除。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","你不可跪拜他們的神，不可事奉他，也不可效法他們的行為，卻要把神像盡行拆毀，打碎他們的柱像。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","你們要事奉耶和華－你們的上帝，他必賜福與你的糧與你的水，也必從你們中間除去疾病。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","你境內必沒有墜胎的，不生產的。我要使你滿了你年日的數目。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","凡你所到的地方，我要使那裏的眾民在你面前驚駭，擾亂，又要使你一切仇敵轉背逃跑。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","我要打發黃蜂飛在你前面，把希未人、迦南人、赫人攆出去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","我不在一年之內將他們從你面前攆出去，恐怕地成為荒涼，野地的獸多起來害你。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","我要漸漸地將他們從你面前攆出去，等到你的人數加多，承受那地為業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","我要定你的境界，從紅海直到非利士海，又從曠野直到大河。我要將那地的居民交在你手中，你要將他們從你面前攆出去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","不可和他們並他們的神立約。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","他們不可住在你的地上，恐怕他們使你得罪我。你若事奉他們的神，這必成為你的網羅。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","耶和華對摩西說：「你和亞倫、拿答、亞比戶，並以色列長老中的七十人，都要上到我這裏來，遠遠地下拜。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","惟獨你可以親近耶和華；他們卻不可親近；百姓也不可和你一同上來。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","摩西下山，將耶和華的命令典章都述說與百姓聽。眾百姓齊聲說：「耶和華所吩咐的，我們都必遵行。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","摩西將耶和華的命令都寫上。清早起來，在山下築一座壇，按以色列十二支派立十二根柱子， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","又打發以色列人中的少年人去獻燔祭，又向耶和華獻牛為平安祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","摩西將血一半盛在盆中，一半灑在壇上； ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","又將約書念給百姓聽。他們說：「耶和華所吩咐的，我們都必遵行。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","摩西將血灑在百姓身上，說：「你看！這是立約的血，是耶和華按這一切話與你們立約的憑據。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","摩西、亞倫、拿答、亞比戶，並以色列長老中的七十人，都上了山。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","他們看見以色列的上帝，他腳下彷彿有平鋪的藍寶石，如同天色明淨。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","他的手不加害在以色列的尊者身上。他們觀看上帝；他們又吃又喝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","耶和華對摩西說：「你上山到我這裏來，住在這裏，我要將石版並我所寫的律法和誡命賜給你，使你可以教訓百姓。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","摩西和他的幫手約書亞起來，上了上帝的山。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","摩西對長老說：「你們在這裏等着，等到我們再回來，有亞倫、戶珥與你們同在。凡有爭訟的，都可以就近他們去。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","摩西上山，有雲彩把山遮蓋。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","耶和華的榮耀停於西奈山；雲彩遮蓋山六天，第七天他從雲中召摩西。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","耶和華的榮耀在山頂上，在以色列人眼前，形狀如烈火。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","摩西進入雲中上山，在山上四十晝夜。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","耶和華曉諭摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","「你告訴以色列人當為我送禮物來；凡甘心樂意的，你們就可以收下歸我。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","所要收的禮物：就是金、銀、銅， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","藍色、紫色、朱紅色線，細麻，山羊毛， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","染紅的公羊皮，海狗皮，皂莢木， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","點燈的油並做膏油和香的香料， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","紅瑪瑙與別樣的寶石，可以鑲嵌在以弗得和胸牌上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","又當為我造聖所，使我可以住在他們中間。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","製造帳幕和其中的一切器具都要照我所指示你的樣式。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","「要用皂莢木做一櫃，長二肘半，寬一肘半，高一肘半。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","要裏外包上精金，四圍鑲上金牙邊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","也要鑄四個金環，安在櫃的四腳上；這邊兩環，那邊兩環。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","要用皂莢木做兩根槓，用金包裹。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","要把槓穿在櫃旁的環內，以便抬櫃。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","這槓要常在櫃的環內，不可抽出來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","必將我所要賜給你的法版放在櫃裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","要用精金做施恩座 ，長二肘半，寬一肘半。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","要用金子錘出兩個基路伯來，安在施恩座的兩頭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","這頭做一個基路伯，那頭做一個基路伯，二基路伯要接連一塊，在施恩座的兩頭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","二基路伯要高張翅膀，遮掩施恩座。基路伯要臉對臉，朝着施恩座。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","要將施恩座安在櫃的上邊，又將我所要賜給你的法版放在櫃裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","我要在那裏與你相會，又要從法櫃施恩座上二基路伯中間，和你說我所要吩咐你傳給以色列人的一切事。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","「要用皂莢木做一張桌子，長二肘，寬一肘，高一肘半。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","要包上精金，四圍鑲上金牙邊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","桌子的四圍各做一掌寬的橫樑，橫樑上鑲着金牙邊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","要做四個金環，安在桌子的四角上，就是桌子四腳上的四角。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","安環子的地方要挨近橫樑，可以穿槓抬桌子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","要用皂莢木做兩根槓，用金包裹，以便抬桌子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","要做桌子上的盤子、調羹，並奠酒的爵和瓶；這都要用精金製作。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","又要在桌子上，在我面前，常擺陳設餅。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","「要用精金做一個燈臺。燈臺的座和幹與杯、球、花，都要接連一塊錘出來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","燈臺兩旁要杈出六個枝子：這旁三個，那旁三個。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","這旁每枝上有三個杯，形狀像杏花，有球，有花；那旁每枝上也有三個杯，形狀像杏花，有球，有花。從燈臺杈出來的六個枝子都是如此。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","燈臺上有四個杯，形狀像杏花，有球，有花。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","燈臺每兩個枝子以下有球與枝子接連一塊。燈臺出的六個枝子都是如此。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","球和枝子要接連一塊，都是一塊精金錘出來的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","要做燈臺的七個燈盞。祭司要點這燈，使燈光對照。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","燈臺的蠟剪和蠟花盤也是要精金的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","做燈臺和這一切的器具要用精金一他連得。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","要謹慎做這些物件，都要照着在山上指示你的樣式。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","「你要用十幅幔子做帳幕。這些幔子要用撚的細麻和藍色、紫色、朱紅色線製造，並用巧匠的手工繡上基路伯。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","每幅幔子要長二十八肘，寬四肘，幔子都要一樣的尺寸。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","這五幅幔子要幅幅相連；那五幅幔子也要幅幅相連。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","在這相連的幔子末幅邊上要做藍色的鈕扣；在那相連的幔子末幅邊上也要照樣做。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","要在這相連的幔子上做五十個鈕扣；在那相連的幔子上也做五十個鈕扣，都要兩兩相對。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","又要做五十個金鉤，用鉤使幔子相連，這才成了一個帳幕。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","「你要用山羊毛織十一幅幔子，作為帳幕以上的罩棚。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","每幅幔子要長三十肘，寬四肘；十一幅幔子都要一樣的尺寸。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","要把五幅幔子連成一幅，又把六幅幔子連成一幅，這第六幅幔子要在罩棚的前面摺上去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","在這相連的幔子末幅邊上要做五十個鈕扣；在那相連的幔子末幅邊上也做五十個鈕扣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","又要做五十個銅鉤，鉤在鈕扣中，使罩棚連成一個。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","罩棚的幔子所餘那垂下來的半幅幔子，要垂在帳幕的後頭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","罩棚的幔子所餘長的，這邊一肘，那邊一肘，要垂在帳幕的兩旁，遮蓋帳幕。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","又要用染紅的公羊皮做罩棚的蓋；再用海狗皮做一層罩棚上的頂蓋。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","「你要用皂莢木做帳幕的豎板。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","每塊要長十肘，寬一肘半； ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","每塊必有兩榫相對。帳幕一切的板都要這樣做。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","帳幕的南面要做板二十塊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","在這二十塊板底下要做四十個帶卯的銀座，兩卯接這塊板上的兩榫，兩卯接那塊板上的兩榫。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","帳幕第二面，就是北面，也要做板二十塊 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","和帶卯的銀座四十個；這板底下有兩卯，那板底下也有兩卯。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","帳幕的後面，就是西面，要做板六塊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","帳幕後面的拐角要做板兩塊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","板的下半截要雙的，上半截要整的，直頂到第一個環子；兩塊都要這樣做兩個拐角。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","必有八塊板和十六個帶卯的銀座；這板底下有兩卯，那板底下也有兩卯。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","「你要用皂莢木做閂：為帳幕這面的板做五閂， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","為帳幕那面的板做五閂，又為帳幕後面的板做五閂。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","板腰間的中閂要從這一頭通到那一頭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","板要用金子包裹，又要做板上的金環套閂；閂也要用金子包裹。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","要照着在山上指示你的樣式立起帳幕。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","「你要用藍色、紫色、朱紅色線，和撚的細麻織幔子，以巧匠的手工繡上基路伯。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","要把幔子掛在四根包金的皂莢木柱子上，柱子上當有金鉤，柱子安在四個帶卯的銀座上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","要使幔子垂在鉤子下，把法櫃抬進幔子內；這幔子要將聖所和至聖所隔開。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","又要把施恩座安在至聖所內的法櫃上， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","把桌子安在幔子外帳幕的北面；把燈臺安在帳幕的南面，彼此相對。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","「你要拿藍色、紫色、朱紅色線，和撚的細麻，用繡花的手工織帳幕的門簾。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","要用皂莢木為簾子做五根柱子，用金子包裹。柱子上當有金鉤；又要為柱子用銅鑄造五個帶卯的座。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","「你要用皂莢木做壇。這壇要四方的，長五肘，寬五肘，高三肘。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","要在壇的四拐角上做四個角，與壇接連一塊，用銅把壇包裹。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","要做盆，收去壇上的灰，又做鏟子、盤子、肉鍤子、火鼎；壇上一切的器具都用銅做。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","要為壇做一個銅網，在網的四角上做四個銅環， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","把網安在壇四面的圍腰板以下，使網從下達到壇的半腰。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","又要用皂莢木為壇做槓，用銅包裹。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","這槓要穿在壇兩旁的環子內，用以抬壇。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","要用板做壇，壇是空的，都照着在山上指示你的樣式做。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","「你要做帳幕的院子。院子的南面要用撚的細麻做帷子，長一百肘。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","帷子的柱子要二十根，帶卯的銅座二十個。柱子上的鉤子和杆子都要用銀子做。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","北面也當有帷子，長一百肘，帷子的柱子二十根，帶卯的銅座二十個。柱子上的鉤子和杆子都要用銀子做。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","院子的西面當有帷子，寬五十肘，帷子的柱子十根，帶卯的座十個。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","院子的東面要寬五十肘。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","門這邊的帷子要十五肘，帷子的柱子三根，帶卯的座三個。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","門那邊的帷子也要十五肘，帷子的柱子三根，帶卯的座三個。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","院子的門當有簾子，長二十肘，要拿藍色、紫色、朱紅色線，和撚的細麻，用繡花的手工織成，柱子四根，帶卯的座四個。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","院子四圍一切的柱子都要用銀杆連絡，柱子上的鉤子要用銀做，帶卯的座要用銅做。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","院子要長一百肘，寬五十肘，高五肘，帷子要用撚的細麻做，帶卯的座要用銅做。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","帳幕各樣用處的器具，並帳幕一切的橛子，和院子裏一切的橛子，都要用銅做。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","「你要吩咐以色列人，把那為點燈搗成的清橄欖油拿來給你，使燈常常點着。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","在會幕中法櫃前的幔外，亞倫和他的兒子，從晚上到早晨，要在耶和華面前經理這燈。這要作以色列人世世代代永遠的定例。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","「你要從以色列人中，使你的哥哥亞倫和他的兒子拿答、亞比戶、以利亞撒、以他瑪一同就近你，給我供祭司的職分。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","你要給你哥哥亞倫做聖衣為榮耀，為華美。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","又要吩咐一切心中有智慧的，就是我用智慧的靈所充滿的，給亞倫做衣服，使他分別為聖，可以給我供祭司的職分。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","所要做的就是胸牌、以弗得、外袍、雜色的內袍、冠冕、腰帶，使你哥哥亞倫和他兒子穿這聖服，可以給我供祭司的職分。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","要用金線和藍色、紫色、朱紅色線，並細麻去做。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","「他們要拿金線和藍色、紫色、朱紅色線，並撚的細麻，用巧匠的手工做以弗得。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","以弗得當有兩條肩帶，接上兩頭，使它相連。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","其上巧工織的帶子，要和以弗得一樣的做法，用以束上，與以弗得接連一塊，要用金線和藍色、紫色、朱紅色線，並撚的細麻做成。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","要取兩塊紅瑪瑙，在上面刻以色列兒子的名字： ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","六個名字在這塊寶石上，六個名字在那塊寶石上，都照他們生來的次序。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","要用刻寶石的手工，彷彿刻圖書，按着以色列兒子的名字，刻這兩塊寶石，要鑲在金槽上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","要將這兩塊寶石安在以弗得的兩條肩帶上，為以色列人做紀念石。亞倫要在兩肩上擔他們的名字，在耶和華面前作為紀念。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","要用金子做二槽， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","又拿精金，用擰工彷彿擰繩子，做兩條鍊子，把這擰成的鍊子搭在二槽上。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","「你要用巧匠的手工做一個決斷的胸牌。要和以弗得一樣的做法：用金線和藍色、紫色、朱紅色線，並撚的細麻做成。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","這胸牌要四方的，疊為兩層，長一虎口，寬一虎口。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","要在上面鑲寶石四行：第一行是紅寶石、紅璧璽、紅玉； ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","第二行是綠寶石、藍寶石、金鋼石； ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","第三行是紫瑪瑙、白瑪瑙、紫晶； ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","第四行是水蒼玉、紅瑪瑙、碧玉。這都要鑲在金槽中。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","這些寶石都要按着以色列十二個兒子的名字，彷彿刻圖書，刻十二個支派的名字。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","要在胸牌上用精金擰成如繩的鍊子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","在胸牌上也要做兩個金環，安在胸牌的兩頭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","要把那兩條擰成的金鍊子，穿過胸牌兩頭的環子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","又要把鍊子的那兩頭接在兩槽上，安在以弗得前面肩帶上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","要做兩個金環，安在胸牌的兩頭，在以弗得裏面的邊上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","又要做兩個金環，安在以弗得前面兩條肩帶的下邊，挨近相接之處，在以弗得巧工織的帶子以上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","要用藍細帶子把胸牌的環子與以弗得的環子繫住，使胸牌貼在以弗得巧工織的帶子上，不可與以弗得離縫。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","亞倫進聖所的時候，要將決斷胸牌，就是刻着以色列兒子名字的，帶在胸前，在耶和華面前常作紀念。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","又要將烏陵和土明放在決斷的胸牌裏；亞倫進到耶和華面前的時候，要帶在胸前，在耶和華面前常將以色列人的決斷牌帶在胸前。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","「你要做以弗得的外袍，顏色全是藍的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","袍上要為頭留一領口，口的周圍織出領邊來，彷彿鎧甲的領口，免得破裂。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","袍子周圍底邊上要用藍色、紫色、朱紅色線做石榴。在袍子周圍的石榴中間要有金鈴鐺： ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","一個金鈴鐺一個石榴，一個金鈴鐺一個石榴，在袍子周圍的底邊上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","亞倫供職的時候要穿這袍子。他進聖所到耶和華面前，以及出來的時候，袍上的響聲必被聽見，使他不至於死亡。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","「你要用精金做一面牌，在上面按刻圖書之法刻着『歸耶和華為聖』。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","要用一條藍細帶子將牌繫在冠冕的前面。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","這牌必在亞倫的額上，亞倫要擔當干犯聖物條例的罪孽；這聖物是以色列人在一切的聖禮物上所分別為聖的。這牌要常在他的額上，使他們可以在耶和華面前蒙悅納。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","要用雜色細麻線織內袍，用細麻布做冠冕，又用繡花的手工做腰帶。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","「你要為亞倫的兒子做內袍、腰帶、裹頭巾，為榮耀，為華美。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","要把這些給你的哥哥亞倫和他的兒子穿戴，又要膏他們，將他們分別為聖，好給我供祭司的職分。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","要給他們做細麻布褲子，遮掩下體；褲子當從腰達到大腿。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","亞倫和他兒子進入會幕，或就近壇，在聖所供職的時候必穿上，免得擔罪而死。這要為亞倫和他的後裔作永遠的定例。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","「你使亞倫和他兒子成聖，給我供祭司的職分，要如此行：取一隻公牛犢，兩隻無殘疾的公綿羊， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","無酵餅和調油的無酵餅，與抹油的無酵薄餅；這都要用細麥麵做成。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","這餅要裝在一個筐子裏，連筐子帶來，又把公牛和兩隻公綿羊牽來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","要使亞倫和他兒子到會幕門口來，用水洗身。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","要給亞倫穿上內袍和以弗得的外袍，並以弗得，又帶上胸牌，束上以弗得巧工織的帶子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","把冠冕戴在他頭上，將聖冠加在冠冕上， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","就把膏油倒在他頭上膏他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","要叫他的兒子來，給他們穿上內袍。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","給亞倫和他兒子束上腰帶，包上裹頭巾，他們就憑永遠的定例得了祭司的職任。又要將亞倫和他兒子分別為聖。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","「你要把公牛牽到會幕前，亞倫和他兒子要按手在公牛的頭上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","你要在耶和華面前，在會幕門口，宰這公牛。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","要取些公牛的血，用指頭抹在壇的四角上，把血都倒在壇腳那裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","要把一切蓋臟的脂油與肝上的網子，並兩個腰子和腰子上的脂油，都燒在壇上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","只是公牛的皮、肉、糞都要用火燒在營外。這牛是贖罪祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","「你要牽一隻公綿羊來，亞倫和他兒子要按手在這羊的頭上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","要宰這羊，把血灑在壇的周圍。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","要把羊切成塊子，洗淨五臟和腿，連塊子帶頭，都放在一處。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","要把全羊燒在壇上，是給耶和華獻的燔祭，是獻給耶和華為馨香的火祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","「你要將那一隻公綿羊牽來，亞倫和他兒子要按手在羊的頭上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","你要宰這羊，取點血抹在亞倫的右耳垂上和他兒子的右耳垂上，又抹在他們右手的大拇指上和右腳的大拇指上；並要把血灑在壇的四圍。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","你要取點膏油和壇上的血，彈在亞倫和他的衣服上，並他兒子和他兒子的衣服上，他們和他們的衣服就一同成聖。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","「你要取這羊的脂油和肥尾巴，並蓋臟的脂油與肝上的網子，兩個腰子和腰子上的脂油並右腿（這是承接聖職所獻的羊）。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","再從耶和華面前裝無酵餅的筐子中取一個餅，一個調油的餅和一個薄餅， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","都放在亞倫的手上和他兒子的手上，作為搖祭，在耶和華面前搖一搖。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","要從他們手中接過來，燒在耶和華面前壇上的燔祭上，是獻給耶和華為馨香的火祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","「你要取亞倫承接聖職所獻公羊的胸，作為搖祭，在耶和華面前搖一搖，這就可以作你的分。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","那搖祭的胸和舉祭的腿，就是承接聖職所搖的、所舉的，是歸亞倫和他兒子的。這些你都要成為聖， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","作亞倫和他子孫從以色列人中永遠所得的分，因為是舉祭。這要從以色列人的平安祭中，作為獻給耶和華的舉祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","「亞倫的聖衣要留給他的子孫，可以穿着受膏，又穿着承接聖職。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","他的子孫接續他當祭司的，每逢進會幕在聖所供職的時候，要穿七天。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","「你要將承接聖職所獻公羊的肉煮在聖處。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","亞倫和他兒子要在會幕門口吃這羊的肉和筐內的餅。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","他們吃那些贖罪之物，好承接聖職，使他們成聖；只是外人不可吃，因為這是聖物。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","那承接聖職所獻的肉或餅，若有一點留到早晨，就要用火燒了，不可吃這物，因為是聖物。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","「你要這樣照我一切所吩咐的，向亞倫和他兒子行承接聖職的禮七天。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","每天要獻公牛一隻為贖罪祭。你潔淨壇的時候，壇就潔淨了；且要用膏抹壇，使壇成聖。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","要潔淨壇七天，使壇成聖，壇就成為至聖。凡挨着壇的都成為聖。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","「你每天所要獻在壇上的就是兩隻一歲的羊羔； ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","早晨要獻這一隻，黃昏的時候要獻那一隻。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","和這一隻羊羔同獻的，要用細麵伊法十分之一與搗成的油一欣四分之一調和，又用酒一欣四分之一作為奠祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","那一隻羊羔要在黃昏的時候獻上，照着早晨的素祭和奠祭的禮辦理，作為獻給耶和華馨香的火祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","這要在耶和華面前、會幕門口，作你們世世代代常獻的燔祭。我要在那裏與你們相會，和你們說話。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","我要在那裏與以色列人相會，會幕就要因我的榮耀成為聖。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","我要使會幕和壇成聖，也要使亞倫和他的兒子成聖，給我供祭司的職分。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","我要住在以色列人中間，作他們的上帝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","他們必知道我是耶和華－他們的上帝，是將他們從埃及地領出來的，為要住在他們中間。我是耶和華－他們的上帝。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","「你要用皂莢木做一座燒香的壇。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","這壇要四方的，長一肘，寬一肘，高二肘；壇的四角要與壇接連一塊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","要用精金把壇的上面與壇的四圍，並壇的四角，包裹；又要在壇的四圍鑲上金牙邊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","要做兩個金環安在牙子邊以下，在壇的兩旁，兩根橫撐上，作為穿槓的用處，以便抬壇。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","要用皂莢木做槓，用金包裹。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","要把壇放在法櫃前的幔子外，對着法櫃上的施恩座，就是我要與你相會的地方。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","亞倫在壇上要燒馨香料做的香；每早晨他收拾燈的時候，要燒這香。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","黃昏點燈的時候，他要在耶和華面前燒這香，作為世世代代常燒的香。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","在這壇上不可奉上異樣的香，不可獻燔祭、素祭，也不可澆上奠祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","亞倫一年一次要在壇的角上行贖罪之禮。他一年一次要用贖罪祭牲的血在壇上行贖罪之禮，作為世世代代的定例。這壇在耶和華面前為至聖。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","耶和華曉諭摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","「你要按以色列人被數的，計算總數，你數的時候，他們各人要為自己的生命把贖價奉給耶和華，免得數的時候在他們中間有災殃。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","凡過去歸那些被數之人的，每人要按聖所的平，拿銀子半舍客勒；這半舍客勒是奉給耶和華的禮物（一舍客勒是二十季拉）。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","凡過去歸那些被數的人，從二十歲以外的，要將這禮物奉給耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","他們為贖生命將禮物奉給耶和華，富足的不可多出，貧窮的也不可少出，各人要出半舍客勒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","你要從以色列人收這贖罪銀，作為會幕的使用，可以在耶和華面前為以色列人作紀念，贖生命。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","耶和華曉諭摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","「你要用銅做洗濯盆和盆座，以便洗濯。要將盆放在會幕和壇的中間，在盆裏盛水。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","亞倫和他的兒子要在這盆裏洗手洗腳。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","他們進會幕，或是就近壇前供職給耶和華獻火祭的時候，必用水洗濯，免得死亡。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","他們洗手洗腳就免得死亡。這要作亞倫和他後裔世世代代永遠的定例。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","耶和華曉諭摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","「你要取上品的香料，就是流質的沒藥五百舍客勒，香肉桂一半，就是二百五十舍客勒，菖蒲二百五十舍客勒， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","桂皮五百舍客勒，都按着聖所的平，又取橄欖油一欣， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","按做香之法調和做成聖膏油。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","要用這膏油抹會幕和法櫃， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","桌子與桌子的一切器具，燈臺和燈臺的器具，並香壇、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","燔祭壇，和壇的一切器具，洗濯盆和盆座。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","要使這些物成為聖，好成為至聖；凡挨着的都成為聖。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","要膏亞倫和他的兒子，使他們成為聖，可以給我供祭司的職分。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","你要對以色列人說：『這油，我要世世代代以為聖膏油。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","不可倒在別人的身上，也不可按這調和之法做與此相似的。這膏油是聖的，你們也要以為聖。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","凡調和與此相似的，或將這膏膏在別人身上的，這人要從民中剪除。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","耶和華吩咐摩西說：「你要取馨香的香料，就是拿他弗、施喜列、喜利比拿；這馨香的香料和淨乳香各樣要一般大的分量。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","你要用這些加上鹽，按做香之法做成清淨聖潔的香。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","這香要取點搗得極細，放在會幕內、法櫃前，我要在那裏與你相會。你們要以這香為至聖。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","你們不可按這調和之法為自己做香；要以這香為聖，歸耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","凡做香和這香一樣，為要聞香味的，這人要從民中剪除。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","耶和華曉諭摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","「看哪，猶大支派中，戶珥的孫子、烏利的兒子比撒列，我已經提他的名召他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","我也以我的靈充滿了他，使他有智慧，有聰明，有知識，能做各樣的工， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","能想出巧工，用金、銀、銅製造各物， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","又能刻寶石，可以鑲嵌，能雕刻木頭，能做各樣的工。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","我分派但支派中、亞希撒抹的兒子亞何利亞伯與他同工。凡心裏有智慧的，我更使他們有智慧，能做我一切所吩咐的， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","就是會幕和法櫃，並其上的施恩座，與會幕中一切的器具， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","桌子和桌子的器具，精金的燈臺和燈臺的一切器具並香壇， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","燔祭壇和壇的一切器具，並洗濯盆與盆座， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","精工做的禮服，和祭司亞倫並他兒子用以供祭司職分的聖衣， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","膏油和為聖所用馨香的香料。他們都要照我一切所吩咐的去做。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","耶和華曉諭摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","「你要吩咐以色列人說：『你們務要守我的安息日；因為這是你我之間世世代代的證據，使你們知道我－耶和華是叫你們成為聖的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","所以你們要守安息日，以為聖日。凡干犯這日的，必要把他治死；凡在這日做工的，必從民中剪除。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","六日要做工，但第七日是安息聖日，是向耶和華守為聖的。凡在安息日做工的，必要把他治死。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","故此，以色列人要世世代代守安息日為永遠的約。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","這是我和以色列人永遠的證據；因為六日之內耶和華造天地，第七日便安息舒暢。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","耶和華在西奈山和摩西說完了話，就把兩塊法版交給他，是上帝用指頭寫的石版。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","百姓見摩西遲延不下山，就大家聚集到亞倫那裏，對他說：「起來！為我們做神像，可以在我們前面引路；因為領我們出埃及地的那個摩西，我們不知道他遭了甚麼事。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","亞倫對他們說：「你們去摘下你們妻子、兒女耳上的金環，拿來給我。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","百姓就都摘下他們耳上的金環，拿來給亞倫。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","亞倫從他們手裏接過來，鑄了一隻牛犢，用雕刻的器具做成。他們就說：「以色列啊，這是領你出埃及地的神。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","亞倫看見，就在牛犢面前築壇，且宣告說：「明日要向耶和華守節。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","次日清早，百姓起來獻燔祭和平安祭，就坐下吃喝，起來玩耍。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","耶和華吩咐摩西說：「下去吧，因為你的百姓，就是你從埃及地領出來的，已經敗壞了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","他們快快偏離了我所吩咐的道，為自己鑄了一隻牛犢，向它下拜獻祭，說：『以色列啊，這就是領你出埃及地的神。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","耶和華對摩西說：「我看這百姓真是硬着頸項的百姓。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","你且由着我，我要向他們發烈怒，將他們滅絕，使你的後裔成為大國。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","摩西便懇求耶和華－他的上帝說：「耶和華啊，你為甚麼向你的百姓發烈怒呢？這百姓是你用大力和大能的手從埃及地領出來的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","為甚麼使埃及人議論說『他領他們出去，是要降禍與他們，把他們殺在山中，將他們從地上除滅』？求你轉意，不發你的烈怒，後悔，不降禍與你的百姓。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","求你記念你的僕人亞伯拉罕、以撒、以色列。你曾指着自己起誓說：『我必使你們的後裔像天上的星那樣多，並且我所應許的這全地，必給你們的後裔，他們要永遠承受為業。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","於是耶和華後悔，不把所說的禍降與他的百姓。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","摩西轉身下山，手裏拿着兩塊法版。這版是兩面寫的，這面那面都有字， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","是上帝的工作，字是上帝寫的，刻在版上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","約書亞一聽見百姓呼喊的聲音，就對摩西說：「在營裏有爭戰的聲音。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","摩西說：「這不是人打勝仗的聲音，也不是人打敗仗的聲音；我所聽見的乃是人歌唱的聲音。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","摩西挨近營前就看見牛犢，又看見人跳舞，便發烈怒，把兩塊版扔在山下摔碎了， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","又將他們所鑄的牛犢用火焚燒，磨得粉碎，撒在水面上，叫以色列人喝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","摩西對亞倫說：「這百姓向你做了甚麼？你竟使他們陷在大罪裏！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","亞倫說：「求我主不要發烈怒。這百姓專於作惡，是你知道的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","他們對我說：『你為我們做神像，可以在我們前面引路；因為領我們出埃及地的那個摩西，我們不知道他遭了甚麼事。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","我對他們說：『凡有金環的可以摘下來』，他們就給了我。我把金環扔在火中，這牛犢便出來了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","摩西見百姓放肆（亞倫縱容他們，使他們在仇敵中間被譏刺）， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","就站在營門中，說：「凡屬耶和華的，都要到我這裏來！」於是利未的子孫都到他那裏聚集。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","他對他們說：「耶和華－以色列的上帝這樣說：『你們各人把刀跨在腰間，在營中往來，從這門到那門，各人殺他的弟兄與同伴並鄰舍。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","利未的子孫照摩西的話行了。那一天百姓中被殺的約有三千。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","摩西說：「今天你們要自潔，歸耶和華為聖，各人攻擊他的兒子和弟兄，使耶和華賜福與你們。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","到了第二天，摩西對百姓說：「你們犯了大罪。我如今要上耶和華那裏去，或者可以為你們贖罪。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","摩西回到耶和華那裏，說：「唉！這百姓犯了大罪，為自己做了金像。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","倘或你肯赦免他們的罪......不然，求你從你所寫的冊上塗抹我的名。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","耶和華對摩西說：「誰得罪我，我就從我的冊上塗抹誰的名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","現在你去領這百姓，往我所告訴你的地方去，我的使者必在你前面引路；只是到我追討的日子，我必追討他們的罪。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","耶和華殺百姓的緣故是因他們同亞倫做了牛犢。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","耶和華吩咐摩西說：「我曾起誓應許亞伯拉罕、以撒、雅各說：『要將迦南地賜給你的後裔。』現在你和你從埃及地所領出來的百姓，要從這裏往那地去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","我要差遣使者在你前面，攆出迦南人、亞摩利人、赫人、比利洗人、希未人、耶布斯人， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","領你到那流奶與蜜之地。我自己不同你們上去；因為你們是硬着頸項的百姓，恐怕我在路上把你們滅絕。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","百姓聽見這凶信就悲哀，也沒有人佩戴妝飾。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","耶和華對摩西說：「你告訴以色列人說：『耶和華說：你們是硬着頸項的百姓，我若一霎時臨到你們中間，必滅絕你們。現在你們要把身上的妝飾摘下來，使我可以知道怎樣待你們。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","以色列人從住何烈山以後，就把身上的妝飾摘得乾淨。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","摩西素常將帳棚支搭在營外，離營卻遠，他稱這帳棚為會幕。凡求問耶和華的，就到營外的會幕那裏去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","當摩西出營到會幕去的時候，百姓就都起來，各人站在自己帳棚的門口，望着摩西，直等到他進了會幕。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","摩西進會幕的時候，雲柱降下來，立在會幕的門前，耶和華便與摩西說話。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","眾百姓看見雲柱立在會幕門前，就都起來，各人在自己帳棚的門口下拜。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","耶和華與摩西面對面說話，好像人與朋友說話一般。摩西轉到營裏去，惟有他的幫手－一個少年人嫩的兒子約書亞不離開會幕。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","摩西對耶和華說：「你吩咐我說：『將這百姓領上去』，卻沒有叫我知道你要打發誰與我同去，只說：『我按你的名認識你，你在我眼前也蒙了恩。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","我如今若在你眼前蒙恩，求你將你的道指示我，使我可以認識你，好在你眼前蒙恩。求你想到這民是你的民。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","耶和華說：「我必親自和你同去，使你得安息。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","摩西說：「你若不親自和我同去，就不要把我們從這裏領上去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","人在何事上得以知道我和你的百姓在你眼前蒙恩呢？豈不是因你與我們同去、使我和你的百姓與地上的萬民有分別嗎？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","耶和華對摩西說：「你這所求的我也要行；因為你在我眼前蒙了恩，並且我按你的名認識你。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","摩西說：「求你顯出你的榮耀給我看。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","耶和華說：「我要顯我一切的恩慈，在你面前經過，宣告我的名。我要恩待誰就恩待誰；要憐憫誰就憐憫誰」； ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","又說：「你不能看見我的面，因為人見我的面不能存活。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","耶和華說：「看哪，在我這裏有地方，你要站在磐石上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","我的榮耀經過的時候，我必將你放在磐石穴中，用我的手遮掩你，等我過去， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","然後我要將我的手收回，你就得見我的背，卻不得見我的面。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","耶和華吩咐摩西說：「你要鑿出兩塊石版，和先前你摔碎的那版一樣；其上的字我要寫在這版上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","明日早晨，你要預備好了，上西奈山，在山頂上站在我面前。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","誰也不可和你一同上去，遍山都不可有人，在山根也不可叫羊群牛群吃草。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","摩西就鑿出兩塊石版，和先前的一樣。清晨起來，照耶和華所吩咐的上西奈山去，手裏拿着兩塊石版。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","耶和華在雲中降臨，和摩西一同站在那裏，宣告耶和華的名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","耶和華在他面前宣告說：「耶和華，耶和華，是有憐憫有恩典的上帝，不輕易發怒，並有豐盛的慈愛和誠實， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","為千萬人存留慈愛，赦免罪孽、過犯，和罪惡，萬不以有罪的為無罪，必追討他的罪，自父及子，直到三、四代。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","摩西急忙伏地下拜， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","說：「主啊，我若在你眼前蒙恩，求你在我們中間同行，因為這是硬着頸項的百姓。又求你赦免我們的罪孽和罪惡，以我們為你的產業。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","耶和華說：「我要立約，要在百姓面前行奇妙的事，是在遍地萬國中所未曾行的。在你四圍的外邦人就要看見耶和華的作為，因我向你所行的是可畏懼的事。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","「我今天所吩咐你的，你要謹守。我要從你面前攆出亞摩利人、迦南人、赫人、比利洗人、希未人、耶布斯人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","你要謹慎，不可與你所去那地的居民立約，恐怕成為你們中間的網羅； ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","卻要拆毀他們的祭壇，打碎他們的柱像，砍下他們的木偶。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","不可敬拜別神；因為耶和華是忌邪的上帝，名為忌邪者。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","只怕你與那地的居民立約，百姓隨從他們的神，就行邪淫，祭祀他們的神，有人叫你，你便吃他的祭物， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","又為你的兒子娶他們的女兒為妻，他們的女兒隨從她們的神，就行邪淫，使你的兒子也隨從她們的神行邪淫。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","「不可為自己鑄造神像。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","「你要守除酵節，照我所吩咐你的，在亞筆月內所定的日期吃無酵餅七天，因為你是這亞筆月內出了埃及。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","凡頭生的都是我的；一切牲畜頭生的，無論是牛是羊，公的都是我的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","頭生的驢要用羊羔代贖，若不代贖就要打折牠的頸項。凡頭生的兒子都要贖出來。誰也不可空手朝見我。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","「你六日要做工，第七日要安息，雖在耕種收割的時候也要安息。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","在收割初熟麥子的時候要守七七節；又在年底要守收藏節。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","你們一切男丁要一年三次朝見主耶和華－以色列的上帝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","我要從你面前趕出外邦人，擴張你的境界。你一年三次上去朝見耶和華－你上帝的時候，必沒有人貪慕你的地土。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","「你不可將我祭物的血和有酵的餅一同獻上。逾越節的祭物也不可留到早晨。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","地裏首先初熟之物要送到耶和華－你上帝的殿。不可用山羊羔母的奶煮山羊羔。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","耶和華吩咐摩西說：「你要將這些話寫上，因為我是按這話與你和以色列人立約。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","摩西在耶和華那裏四十晝夜，也不吃飯也不喝水。耶和華將這約的話，就是十條誡，寫在兩塊版上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","摩西手裏拿着兩塊法版下西奈山的時候，不知道自己的面皮因耶和華和他說話就發了光。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","亞倫和以色列眾人看見摩西的面皮發光就怕挨近他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","摩西叫他們來；於是亞倫和會眾的官長都到他那裏去，摩西就與他們說話。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","隨後以色列眾人都近前來，他就把耶和華在西奈山與他所說的一切話都吩咐他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","摩西與他們說完了話就用帕子蒙上臉。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","但摩西進到耶和華面前與他說話就揭去帕子，及至出來的時候便將耶和華所吩咐的告訴以色列人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","以色列人看見摩西的面皮發光。摩西又用帕子蒙上臉，等到他進去與耶和華說話就揭去帕子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","摩西招聚以色列全會眾，對他們說：「這是耶和華所吩咐的話，叫你們照着行： ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","六日要做工，第七日乃為聖日，當向耶和華守為安息聖日。凡這日之內做工的，必把他治死。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","當安息日，不可在你們一切的住處生火。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","摩西對以色列全會眾說：「耶和華所吩咐的是這樣： ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","你們中間要拿禮物獻給耶和華，凡樂意獻的可以拿耶和華的禮物來，就是金、銀、銅， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","藍色、紫色、朱紅色線，細麻，山羊毛， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","染紅的公羊皮，海狗皮，皂莢木， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","點燈的油，並做膏油和香的香料， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","紅瑪瑙與別樣的寶石，可以鑲嵌在以弗得和胸牌上。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","「你們中間凡心裏有智慧的都要來做耶和華一切所吩咐的： ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","就是帳幕和帳幕的罩棚，並帳幕的蓋、鉤子、板、閂、柱子、帶卯的座， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","櫃和櫃的槓，施恩座和遮掩櫃的幔子， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","桌子和桌子的槓與桌子的一切器具，並陳設餅， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","燈臺和燈臺的器具，燈盞並點燈的油， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","香壇和壇的槓，膏油和馨香的香料，並帳幕門口的簾子， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","燔祭壇和壇的銅網，壇的槓並壇的一切器具，洗濯盆和盆座， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","院子的帷子和帷子的柱子，帶卯的座和院子的門簾， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","帳幕的橛子並院子的橛子，和這兩處的繩子， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","精工做的禮服和祭司亞倫並他兒子在聖所用以供祭司職分的聖衣。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","以色列全會眾從摩西面前退去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","凡心裏受感和甘心樂意的都拿耶和華的禮物來，用以做會幕和其中一切的使用，又用以做聖衣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","凡心裏樂意獻禮物的，連男帶女，各將金器，就是胸前鍼、耳環、打印的戒指，和手釧帶來獻給耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","凡有藍色、紫色、朱紅色線，細麻，山羊毛，染紅的公羊皮，海狗皮的，都拿了來； ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","凡獻銀子和銅給耶和華為禮物的都拿了來；凡有皂莢木可做甚麼使用的也拿了來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","凡心中有智慧的婦女親手紡線，把所紡的藍色、紫色、朱紅色線，和細麻都拿了來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","凡有智慧、心裏受感的婦女就紡山羊毛。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","眾官長把紅瑪瑙和別樣的寶石，可以鑲嵌在以弗得與胸牌上的，都拿了來； ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","又拿香料做香，拿油點燈，做膏油。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","以色列人，無論男女，凡甘心樂意獻禮物給耶和華的，都將禮物拿來，做耶和華藉摩西所吩咐的一切工。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","摩西對以色列人說：「猶大支派中，戶珥的孫子、烏利的兒子比撒列，耶和華已經提他的名召他， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","又以上帝的靈充滿了他，使他有智慧、聰明、知識，能做各樣的工， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","能想出巧工，用金、銀、銅製造各物， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","又能刻寶石，可以鑲嵌，能雕刻木頭，能做各樣的巧工。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","耶和華又使他，和但支派中亞希撒抹的兒子亞何利亞伯，心裏靈明，能教導人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","耶和華使他們的心滿有智慧，能做各樣的工，無論是雕刻的工，巧匠的工，用藍色、紫色、朱紅色線，和細麻、繡花的工，並機匠的工，他們都能做，也能想出奇巧的工。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","「比撒列和亞何利亞伯，並一切心裏有智慧的，就是蒙耶和華賜智慧聰明、叫他知道做聖所各樣使用之工的，都要照耶和華所吩咐的做工。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","凡耶和華賜他心裏有智慧、而且受感前來做這工的，摩西把他們和比撒列並亞何利亞伯一同召來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","這些人就從摩西收了以色列人為做聖所並聖所使用之工所拿來的禮物。百姓每早晨還把甘心獻的禮物拿來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","凡做聖所一切工的智慧人各都離開他所做的工， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","來對摩西說：「百姓為耶和華吩咐使用之工所拿來的，富富有餘。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","摩西傳命，他們就在全營中宣告說：「無論男女，不必再為聖所拿甚麼禮物來。」這樣才攔住百姓不再拿禮物來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","因為他們所有的材料夠做一切當做的物，而且有餘。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","他們中間，凡心裏有智慧做工的，用十幅幔子做帳幕。這幔子是比撒列用撚的細麻和藍色、紫色、朱紅色線製造的，並用巧匠的手工繡上基路伯。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","每幅幔子長二十八肘，寬四肘，都是一樣的尺寸。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","他使這五幅幔子幅幅相連，又使那五幅幔子幅幅相連； ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","在這相連的幔子末幅邊上做藍色的鈕扣，在那相連的幔子末幅邊上也照樣做； ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","在這相連的幔子上做五十個鈕扣，在那相連的幔子上也做五十個鈕扣，都是兩兩相對； ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","又做五十個金鉤，使幔子相連。這才成了一個帳幕。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","他用山羊毛織十一幅幔子，作為帳幕以上的罩棚。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","每幅幔子長三十肘，寬四肘；十一幅幔子都是一樣的尺寸。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","他把五幅幔子連成一幅，又把六幅幔子連成一幅； ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","在這相連的幔子末幅邊上做五十個鈕扣，在那相連的幔子末幅邊上也做五十個鈕扣； ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","又做五十個銅鉤，使罩棚連成一個； ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","並用染紅的公羊皮做罩棚的蓋，再用海狗皮做一層罩棚上的頂蓋。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","他用皂莢木做帳幕的豎板。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","每塊長十肘，寬一肘半； ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","每塊有兩榫相對。帳幕一切的板都是這樣做。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","帳幕的南面做板二十塊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","在這二十塊板底下又做四十個帶卯的銀座：兩卯接這塊板上的兩榫，兩卯接那塊板上的兩榫。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","帳幕的第二面，就是北面，也做板二十塊 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","和帶卯的銀座四十個：這板底下有兩卯，那板底下也有兩卯。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","帳幕的後面，就是西面，做板六塊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","帳幕後面的拐角做板兩塊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","板的下半截是雙的，上半截是整的，直到第一個環子；在帳幕的兩個拐角上都是這樣做。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","有八塊板和十六個帶卯的銀座，每塊板底下有兩卯。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","他用皂莢木做閂：為帳幕這面的板做五閂， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","為帳幕那面的板做五閂，又為帳幕後面的板做五閂， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","使板腰間的中閂從這一頭通到那一頭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","用金子將板包裹，又做板上的金環套閂；閂也用金子包裹。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","他用藍色、紫色、朱紅色線，和撚的細麻織幔子，以巧匠的手工繡上基路伯。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","為幔子做四根皂莢木柱子，用金包裹，柱子上有金鉤，又為柱子鑄了四個帶卯的銀座。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","拿藍色、紫色、朱紅色線，和撚的細麻，用繡花的手工織帳幕的門簾； ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","又為簾子做五根柱子和柱子上的鉤子，用金子把柱頂和柱子上的杆子包裹。柱子有五個帶卯的座，是銅的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","比撒列用皂莢木做櫃，長二肘半，寬一肘半，高一肘半。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","裏外包上精金，四圍鑲上金牙邊， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","又鑄四個金環，安在櫃的四腳上：這邊兩環，那邊兩環。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","用皂莢木做兩根槓，用金包裹。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","把槓穿在櫃旁的環內，以便抬櫃。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","用精金做施恩座，長二肘半，寬一肘半。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","用金子錘出兩個基路伯來，安在施恩座的兩頭， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","這頭做一個基路伯，那頭做一個基路伯，二基路伯接連一塊，在施恩座的兩頭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","二基路伯高張翅膀，遮掩施恩座；基路伯是臉對臉，朝着施恩座。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","他用皂莢木做一張桌子，長二肘，寬一肘，高一肘半， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","又包上精金，四圍鑲上金牙邊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","桌子的四圍各做一掌寬的橫樑，橫樑上鑲着金牙邊， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","又鑄了四個金環，安在桌子四腳的四角上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","安環子的地方是挨近橫梁，可以穿槓抬桌子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","他用皂莢木做兩根槓，用金包裹，以便抬桌子； ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","又用精金做桌子上的器皿，就是盤子、調羹，並奠酒的瓶和爵。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","他用精金做一個燈臺；這燈臺的座和幹，與杯、球、花，都是接連一塊錘出來的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","燈臺兩旁杈出六個枝子：這旁三個，那旁三個。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","這旁每枝上有三個杯，形狀像杏花，有球有花；那旁每枝上也有三個杯，形狀像杏花，有球有花。從燈臺杈出來的六個枝子都是如此。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","燈臺上有四個杯，形狀像杏花，有球有花。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","燈臺每兩個枝子以下有球，與枝子接連一塊；燈臺杈出的六個枝子都是如此。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","球和枝子是接連一塊，都是一塊精金錘出來的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","用精金做燈臺的七個燈盞，並燈臺的蠟剪和蠟花盤。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","他用精金一他連得做燈臺和燈臺的一切器具。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","他用皂莢木做香壇，是四方的，長一肘，寬一肘，高二肘，壇的四角與壇接連一塊； ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","又用精金把壇的上面與壇的四面並壇的四角包裹，又在壇的四圍鑲上金牙邊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","做兩個金環，安在牙子邊以下，在壇的兩旁、兩根橫撐上，作為穿槓的用處，以便抬壇。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","用皂莢木做槓，用金包裹。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","又按做香之法做聖膏油和馨香料的淨香。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","他用皂莢木做燔祭壇，是四方的，長五肘，寬五肘，高三肘， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","在壇的四拐角上做四個角，與壇接連一塊，用銅把壇包裹。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","他做壇上的盆、鏟子、盤子、肉鍤子、火鼎；這一切器具都是用銅做的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","又為壇做一個銅網，安在壇四面的圍腰板以下，從下達到壇的半腰。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","為銅網的四角鑄四個環子，作為穿槓的用處。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","用皂莢木做槓，用銅包裹， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","把槓穿在壇兩旁的環子內，用以抬壇，並用板做壇；壇是空的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","他用銅做洗濯盆和盆座，是用會幕門前伺候的婦人之鏡子做的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","他做帳幕的院子。院子的南面用撚的細麻做帷子，寬一百肘。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","帷子的柱子二十根，帶卯的銅座二十個；柱子上的鉤子和杆子都是用銀子做的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","北面也有帷子，寬一百肘。帷子的柱子二十根，帶卯的銅座二十個；柱子上的鉤子和杆子都是用銀子做的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","院子的西面有帷子，寬五十肘。帷子的柱子十根，帶卯的座十個；柱子的鉤子和杆子都是用銀子做的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","院子的東面，寬五十肘。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","15","門這邊的帷子十五肘，那邊也是一樣。帷子的柱子三根，帶卯的座三個。在門的左右各有帷子十五肘，帷子的柱子三根，帶卯的座三個。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","院子四面的帷子都是用撚的細麻做的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","柱子帶卯的座是銅的，柱子上的鉤子和杆子是銀的，柱頂是用銀子包的。院子一切的柱子都是用銀杆連絡的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","院子的門簾是以繡花的手工，用藍色、紫色、朱紅色線，和撚的細麻織的，寬二十肘，高五肘，與院子的帷子相配。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","帷子的柱子四根，帶卯的銅座四個；柱子上的鉤子和杆子是銀的；柱頂是用銀子包的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","帳幕一切的橛子和院子四圍的橛子都是銅的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","這是法櫃的帳幕中利未人所用物件的總數，是照摩西的吩咐，經祭司亞倫的兒子以他瑪的手數點的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","凡耶和華所吩咐摩西的都是猶大支派戶珥的孫子、烏利的兒子比撒列做的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","與他同工的有但支派中亞希撒抹的兒子亞何利亞伯；他是雕刻匠，又是巧匠，又能用藍色、紫色、朱紅色線，和細麻繡花。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","為聖所一切工作使用所獻的金子，按聖所的平，有二十九他連得並七百三十舍客勒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","會中被數的人所出的銀子，按聖所的平，有一百他連得並一千七百七十五舍客勒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","凡過去歸那些被數之人的，從二十歲以外，有六十萬零三千五百五十人。按聖所的平，每人出銀半舍客勒，就是一比加。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","用那一百他連得銀子鑄造聖所帶卯的座和幔子柱子帶卯的座；一百他連得共一百帶卯的座，每帶卯的座用一他連得。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","用那一千七百七十五舍客勒銀子做柱子上的鉤子，包裹柱頂並柱子上的杆子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","所獻的銅有七十他連得並二千四百舍客勒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","用這銅做會幕門帶卯的座和銅壇，並壇上的銅網和壇的一切器具， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","並院子四圍帶卯的座和院門帶卯的座，與帳幕一切的橛子和院子四圍所有的橛子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","比撒列用藍色、紫色、朱紅色線做精緻的衣服，在聖所用以供職，又為亞倫做聖衣，是照耶和華所吩咐摩西的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","他用金線和藍色、紫色、朱紅色線，並撚的細麻做以弗得； ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","把金子錘成薄片，剪出線來，與藍色、紫色、朱紅色線，用巧匠的手工一同繡上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","又為以弗得做兩條相連的肩帶，接連在以弗得的兩頭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","其上巧工織的帶子和以弗得一樣的做法，用以束上，與以弗得接連一塊，是用金線和藍色、紫色、朱紅色線，並撚的細麻做的，是照耶和華所吩咐摩西的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","又琢出兩塊紅瑪瑙，鑲在金槽上，彷彿刻圖書，按着以色列兒子的名字雕刻； ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","將這兩塊寶石安在以弗得的兩條肩帶上，為以色列人做紀念石，是照耶和華所吩咐摩西的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","他用巧匠的手工做胸牌，和以弗得一樣的做法，用金線與藍色、紫色、朱紅色線，並撚的細麻做的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","胸牌是四方的，疊為兩層；這兩層長一虎口，寬一虎口， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","上面鑲着寶石四行：第一行是紅寶石、紅璧璽、紅玉； ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","第二行是綠寶石、藍寶石、金鋼石； ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","第三行是紫瑪瑙、白瑪瑙、紫晶； ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","第四行是水蒼玉、紅瑪瑙、碧玉。這都鑲在金槽中。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","這些寶石都是按着以色列十二個兒子的名字，彷彿刻圖書，刻十二個支派的名字。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","在胸牌上，用精金擰成如繩子的鍊子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","又做兩個金槽和兩個金環，安在胸牌的兩頭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","把那兩條擰成的金鍊子穿過胸牌兩頭的環子， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","又把鍊子的那兩頭接在兩槽上，安在以弗得前面肩帶上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","做兩個金環，安在胸牌的兩頭，在以弗得裏面的邊上， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","又做兩個金環，安在以弗得前面兩條肩帶的下邊，挨近相接之處，在以弗得巧工織的帶子以上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","用一條藍細帶子把胸牌的環子和以弗得的環子繫住，使胸牌貼在以弗得巧工織的帶子上，不可與以弗得離縫，是照耶和華所吩咐摩西的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","他用織工做以弗得的外袍，顏色全是藍的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","袍上留一領口，口的周圍織出領邊來，彷彿鎧甲的領口，免得破裂。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","在袍子底邊上，用藍色、紫色、朱紅色線，並撚的細麻做石榴， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","又用精金做鈴鐺，把鈴鐺釘在袍子周圍底邊上的石榴中間： ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","一個鈴鐺一個石榴，一個鈴鐺一個石榴，在袍子周圍底邊上用以供職，是照耶和華所吩咐摩西的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","他用織成的細麻布為亞倫和他的兒子做內袍， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","並用細麻布做冠冕和華美的裹頭巾，用撚的細麻布做褲子， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","又用藍色、紫色、朱紅色線，並撚的細麻，以繡花的手工做腰帶，是照耶和華所吩咐摩西的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","他用精金做聖冠上的牌，在上面按刻圖書之法，刻着「歸耶和華為聖」。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","又用一條藍細帶子將牌繫在冠冕上，是照耶和華所吩咐摩西的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","帳幕，就是會幕，一切的工就這樣做完了。凡耶和華所吩咐摩西的，以色列人都照樣做了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","他們送到摩西那裏。帳幕和帳幕的一切器具，就是鉤子、板、閂、柱子、帶卯的座， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","染紅公羊皮的蓋、海狗皮的頂蓋，和遮掩櫃的幔子， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","法櫃和櫃的槓並施恩座， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","桌子和桌子的一切器具並陳設餅， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","精金的燈臺和擺列的燈盞，與燈臺的一切器具，並點燈的油， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","金壇、膏油、馨香的香料、會幕的門簾， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","銅壇和壇上的銅網，壇的槓並壇的一切器具，洗濯盆和盆座， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","院子的帷子和柱子，並帶卯的座，院子的門簾、繩子、橛子，並帳幕和會幕中一切使用的器具， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","精工做的禮服，和祭司亞倫並他兒子在聖所用以供祭司職分的聖衣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","這一切工作都是以色列人照耶和華所吩咐摩西做的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","耶和華怎樣吩咐的，他們就怎樣做了。摩西看見一切的工都做成了，就給他們祝福。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","耶和華曉諭摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","「正月初一日，你要立起帳幕， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","把法櫃安放在裏面，用幔子將櫃遮掩。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","把桌子搬進去，擺設上面的物。把燈臺搬進去，點其上的燈。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","把燒香的金壇安在法櫃前，掛上帳幕的門簾。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","把燔祭壇安在帳幕門前。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","把洗濯盆安在會幕和壇的中間，在盆裏盛水。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","又在四圍立院帷，把院子的門簾掛上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","用膏油把帳幕和其中所有的都抹上，使帳幕和一切器具成聖，就都成聖。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","又要抹燔祭壇和一切器具，使壇成聖，就都成為至聖。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","要抹洗濯盆和盆座，使盆成聖。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","要使亞倫和他兒子到會幕門口來，用水洗身。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","要給亞倫穿上聖衣，又膏他，使他成聖，可以給我供祭司的職分； ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","又要使他兒子來，給他們穿上內袍。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","怎樣膏他們的父親，也要照樣膏他們，使他們給我供祭司的職分。他們世世代代凡受膏的，就永遠當祭司的職任。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","摩西這樣行，都是照耶和華所吩咐他的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","第二年正月初一日，帳幕就立起來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","摩西立起帳幕，安上帶卯的座，立上板，穿上閂，立起柱子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","在帳幕以上搭罩棚，把罩棚的頂蓋蓋在其上，是照耶和華所吩咐他的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","又把法版放在櫃裏，把槓穿在櫃的兩旁，把施恩座安在櫃上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","把櫃抬進帳幕，掛上遮掩櫃的幔子，把法櫃遮掩了，是照耶和華所吩咐他的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","又把桌子安在會幕內，在帳幕北邊，在幔子外。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","在桌子上將餅陳設在耶和華面前，是照耶和華所吩咐他的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","又把燈臺安在會幕內，在帳幕南邊，與桌子相對， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","在耶和華面前點燈，是照耶和華所吩咐他的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","把金壇安在會幕內的幔子前， ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","在壇上燒了馨香料做的香，是照耶和華所吩咐他的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","又掛上帳幕的門簾。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","在會幕的帳幕門前，安設燔祭壇，把燔祭和素祭獻在其上，是照耶和華所吩咐他的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","把洗濯盆安在會幕和壇的中間，盆中盛水，以便洗濯。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","摩西和亞倫並亞倫的兒子在這盆裏洗手洗腳。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","他們進會幕或就近壇的時候，便都洗濯，是照耶和華所吩咐他的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","在帳幕和壇的四圍立了院帷，把院子的門簾掛上。這樣，摩西就完了工。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","當時，雲彩遮蓋會幕，耶和華的榮光就充滿了帳幕。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","摩西不能進會幕；因為雲彩停在其上，並且耶和華的榮光充滿了帳幕。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","每逢雲彩從帳幕收上去，以色列人就起程前往； ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","雲彩若不收上去，他們就不起程，直等到雲彩收上去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","日間，耶和華的雲彩是在帳幕以上；夜間，雲中有火，在以色列全家的眼前。在他們所行的路上都是這樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","耶和華從會幕中呼叫摩西，對他說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","「你曉諭以色列人說：你們中間若有人獻供物給耶和華，要從牛群羊群中獻牲畜為供物。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","「他的供物若以牛為燔祭，就要在會幕門口獻一隻沒有殘疾的公牛，可以在耶和華面前蒙悅納。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","他要按手在燔祭牲的頭上，燔祭便蒙悅納，為他贖罪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","他要在耶和華面前宰公牛；亞倫子孫作祭司的，要奉上血，把血灑在會幕門口、壇的周圍。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","那人要剝去燔祭牲的皮，把燔祭牲切成塊子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","祭司亞倫的子孫要把火放在壇上，把柴擺在火上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","亞倫子孫作祭司的，要把肉塊和頭並脂油擺在壇上火的柴上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","但燔祭的臟腑與腿要用水洗。祭司就要把一切全燒在壇上，當作燔祭，獻與耶和華為馨香的火祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","「人的供物若以綿羊或山羊為燔祭，就要獻上沒有殘疾的公羊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","要把羊宰於壇的北邊，在耶和華面前；亞倫子孫作祭司的，要把羊血灑在壇的周圍。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","要把燔祭牲切成塊子，連頭和脂油，祭司就要擺在壇上火的柴上； ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","但臟腑與腿要用水洗，祭司就要全然奉獻，燒在壇上。這是燔祭，是獻與耶和華為馨香的火祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","「人奉給耶和華的供物，若以鳥為燔祭，就要獻斑鳩或是雛鴿為供物。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","祭司要把鳥拿到壇前，揪下頭來，把鳥燒在壇上；鳥的血要流在壇的旁邊； ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","又要把鳥的嗉子和髒物除掉，丟在壇的東邊倒灰的地方。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","要拿着鳥的兩個翅膀，把鳥撕開，只是不可撕斷；祭司要在壇上、在火的柴上焚燒。這是燔祭，是獻與耶和華為馨香的火祭。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","「若有人獻素祭為供物給耶和華，要用細麵澆上油，加上乳香， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","帶到亞倫子孫作祭司的那裏；祭司就要從細麵中取出一把來，並取些油和所有的乳香，然後要把所取的這些作為紀念，燒在壇上，是獻與耶和華為馨香的火祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","素祭所剩的要歸給亞倫和他的子孫；這是獻與耶和華的火祭中為至聖的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","「若用爐中烤的物為素祭，就要用調油的無酵細麵餅，或是抹油的無酵薄餅。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","若用鐵鏊上做的物為素祭，就要用調油的無酵細麵， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","分成塊子，澆上油；這是素祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","若用煎盤做的物為素祭，就要用油與細麵做成。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","要把這些東西做的素祭帶到耶和華面前，並奉給祭司，帶到壇前。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","祭司要從素祭中取出作為紀念的，燒在壇上，是獻與耶和華為馨香的火祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","素祭所剩的要歸給亞倫和他的子孫。這是獻與耶和華的火祭中為至聖的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","「凡獻給耶和華的素祭都不可有酵；因為你們不可燒一點酵、一點蜜當作火祭獻給耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","這些物要獻給耶和華作為初熟的供物，只是不可在壇上獻為馨香的祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","凡獻為素祭的供物都要用鹽調和，在素祭上不可缺了你上帝立約的鹽。一切的供物都要配鹽而獻。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","若向耶和華獻初熟之物為素祭，要獻上烘了的禾穗子，就是軋了的新穗子，當作初熟之物的素祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","並要抹上油，加上乳香；這是素祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","祭司要把其中作為紀念的，就是一些軋了的禾穗子和一些油，並所有的乳香，都焚燒，是向耶和華獻的火祭。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","「人獻供物為平安祭，若是從牛群中獻，無論是公的是母的，必用沒有殘疾的獻在耶和華面前。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","他要按手在供物的頭上，宰於會幕門口。亞倫子孫作祭司的，要把血灑在壇的周圍。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","從平安祭中，將火祭獻給耶和華，也要把蓋臟的脂油和臟上所有的脂油， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","並兩個腰子和腰子上的脂油，就是靠腰兩旁的脂油，與肝上的網子和腰子，一概取下。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","亞倫的子孫要把這些燒在壇的燔祭上，就是在火的柴上，是獻與耶和華為馨香的火祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","「人向耶和華獻供物為平安祭，若是從羊群中獻，無論是公的是母的，必用沒有殘疾的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","若獻一隻羊羔為供物，必在耶和華面前獻上， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","並要按手在供物的頭上，宰於會幕前。亞倫的子孫要把血灑在壇的周圍。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","從平安祭中，將火祭獻給耶和華，其中的脂油和整肥尾巴都要在靠近脊骨處取下，並要把蓋臟的脂油和臟上所有的脂油， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","兩個腰子和腰子上的脂油，就是靠腰兩旁的脂油，並肝上的網子和腰子，一概取下。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","祭司要在壇上焚燒，是獻給耶和華為食物的火祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","「人的供物若是山羊，必在耶和華面前獻上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","要按手在山羊頭上，宰於會幕前。亞倫的子孫要把血灑在壇的周圍， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","15","又把蓋臟的脂油和臟上所有的脂油，兩個腰子和腰子上的脂油，就是靠腰兩旁的脂油，並肝上的網子和腰子，一概取下，獻給耶和華為火祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","祭司要在壇上焚燒，作為馨香火祭的食物。脂油都是耶和華的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","在你們一切的住處，脂油和血都不可吃；這要成為你們世世代代永遠的定例。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","耶和華對摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","「你曉諭以色列人說：若有人在耶和華所吩咐不可行的甚麼事上誤犯了一件， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","或是受膏的祭司犯罪，使百姓陷在罪裏，就當為他所犯的罪把沒有殘疾的公牛犢獻給耶和華為贖罪祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","他要牽公牛到會幕門口，在耶和華面前按手在牛的頭上，把牛宰於耶和華面前。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","受膏的祭司要取些公牛的血帶到會幕， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","把指頭蘸於血中，在耶和華面前對着聖所的幔子彈血七次， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","又要把些血抹在會幕內、耶和華面前香壇的四角上，再把公牛所有的血倒在會幕門口、燔祭壇的腳那裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","要把贖罪祭公牛所有的脂油，乃是蓋臟的脂油和臟上所有的脂油， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","並兩個腰子和腰子上的脂油，就是靠腰兩旁的脂油，與肝上的網子和腰子，一概取下， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","與平安祭公牛上所取的一樣；祭司要把這些燒在燔祭的壇上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","公牛的皮和所有的肉，並頭、腿、臟、腑、糞， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","就是全公牛，要搬到營外潔淨之地、倒灰之所，用火燒在柴上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","「以色列全會眾若行了耶和華所吩咐不可行的甚麼事，誤犯了罪，是隱而未現、會眾看不出來的， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","會眾一知道所犯的罪就要獻一隻公牛犢為贖罪祭，牽到會幕前。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","會中的長老就要在耶和華面前按手在牛的頭上，將牛在耶和華面前宰了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","受膏的祭司要取些公牛的血帶到會幕， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","把指頭蘸於血中，在耶和華面前對着幔子彈血七次， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","又要把些血抹在會幕內、耶和華面前壇的四角上，再把所有的血倒在會幕門口、燔祭壇的腳那裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","把牛所有的脂油都取下，燒在壇上； ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","收拾這牛，與那贖罪祭的牛一樣。祭司要為他們贖罪，他們必蒙赦免。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","他要把牛搬到營外燒了，像燒頭一個牛一樣；這是會眾的贖罪祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","「官長若行了耶和華－他上帝所吩咐不可行的甚麼事，誤犯了罪， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","所犯的罪自己知道了，就要牽一隻沒有殘疾的公山羊為供物， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","按手在羊的頭上，宰於耶和華面前、宰燔祭牲的地方；這是贖罪祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","祭司要用指頭蘸些贖罪祭牲的血，抹在燔祭壇的四角上，把血倒在燔祭壇的腳那裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","所有的脂油，祭司都要燒在壇上，正如平安祭的脂油一樣。至於他的罪，祭司要為他贖了，他必蒙赦免。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","「民中若有人行了耶和華所吩咐不可行的甚麼事，誤犯了罪， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","所犯的罪自己知道了，就要為所犯的罪牽一隻沒有殘疾的母山羊為供物， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","按手在贖罪祭牲的頭上，在那宰燔祭牲的地方宰了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","祭司要用指頭蘸些羊的血，抹在燔祭壇的四角上，所有的血都要倒在壇的腳那裏， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","又要把羊所有的脂油都取下，正如取平安祭牲的脂油一樣。祭司要在壇上焚燒，在耶和華面前作為馨香的祭，為他贖罪，他必蒙赦免。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","「人若牽一隻綿羊羔為贖罪祭的供物，必要牽一隻沒有殘疾的母羊， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","按手在贖罪祭牲的頭上，在那宰燔祭牲的地方宰了作贖罪祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","祭司要用指頭蘸些贖罪祭牲的血，抹在燔祭壇的四角上，所有的血都要倒在壇的腳那裏， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","又要把所有的脂油都取下，正如取平安祭羊羔的脂油一樣。祭司要按獻給耶和華火祭的條例，燒在壇上。至於所犯的罪，祭司要為他贖了，他必蒙赦免。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","「若有人聽見發誓的聲音，他本是見證，卻不把所看見的、所知道的說出來，這就是罪；他要擔當他的罪孽。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","或是有人摸了不潔的物，無論是不潔的死獸，是不潔的死畜，是不潔的死蟲，他卻不知道，因此成了不潔，就有了罪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","或是他摸了別人的污穢，無論是染了甚麼污穢，他卻不知道，一知道了就有了罪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","或是有人嘴裏冒失發誓，要行惡，要行善，無論人在甚麼事上冒失發誓，他卻不知道，一知道了就要在這其中的一件上有了罪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","他有了罪的時候，就要承認所犯的罪， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","並要因所犯的罪，把他的贖愆祭牲－就是羊群中的母羊，或是一隻羊羔，或是一隻山羊－牽到耶和華面前為贖罪祭。至於他的罪，祭司要為他贖了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","「他的力量若不夠獻一隻羊羔，就要因所犯的罪，把兩隻斑鳩或是兩隻雛鴿帶到耶和華面前為贖愆祭：一隻作贖罪祭，一隻作燔祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","把這些帶到祭司那裏，祭司就要先把那贖罪祭獻上，從鳥的頸項上揪下頭來，只是不可把鳥撕斷， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","也把些贖罪祭牲的血彈在壇的旁邊，剩下的血要流在壇的腳那裏；這是贖罪祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","他要照例獻第二隻為燔祭。至於他所犯的罪，祭司要為他贖了，他必蒙赦免。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","「他的力量若不夠獻兩隻斑鳩或是兩隻雛鴿，就要因所犯的罪帶供物來，就是細麵伊法十分之一為贖罪祭；不可加上油，也不可加上乳香，因為是贖罪祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","他要把供物帶到祭司那裏，祭司要取出自己的一把來作為紀念，按獻給耶和華火祭的條例燒在壇上；這是贖罪祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","至於他在這幾件事中所犯的罪，祭司要為他贖了，他必蒙赦免。剩下的麵都歸與祭司，和素祭一樣。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","耶和華曉諭摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","「人若在耶和華的聖物上誤犯了罪，有了過犯，就要照你所估的，按聖所的舍客勒拿銀子，將贖愆祭牲－就是羊群中一隻沒有殘疾的公綿羊－牽到耶和華面前為贖愆祭； ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","並且他因在聖物上的差錯要償還，另外加五分之一，都給祭司。祭司要用贖愆祭的公綿羊為他贖罪，他必蒙赦免。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","「若有人犯罪，行了耶和華所吩咐不可行的甚麼事，他雖然不知道，還是有了罪，就要擔當他的罪孽； ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","也要照你所估定的價，從羊群中牽一隻沒有殘疾的公綿羊來，給祭司作贖愆祭。至於他誤行的那錯事，祭司要為他贖罪，他必蒙赦免。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","這是贖愆祭，因他在耶和華面前實在有了罪。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","耶和華曉諭摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","「若有人犯罪，干犯耶和華，在鄰舍交付他的物上，或是在交易上行了詭詐，或是搶奪人的財物，或是欺壓鄰舍， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","或是在撿了遺失的物上行了詭詐，說謊起誓，在這一切的事上犯了甚麼罪； ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","他既犯了罪，有了過犯，就要歸還他所搶奪的，或是因欺壓所得的，或是人交付他的，或是人遺失他所撿的物， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","或是他因甚麼物起了假誓，就要如數歸還，另外加上五分之一，在查出他有罪的日子要交還本主。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","也要照你所估定的價，把贖愆祭牲－就是羊群中一隻沒有殘疾的公綿羊－牽到耶和華面前，給祭司為贖愆祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","祭司要在耶和華面前為他贖罪；他無論行了甚麼事，使他有了罪，都必蒙赦免。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","耶和華曉諭摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","「你要吩咐亞倫和他的子孫說，燔祭的條例乃是這樣：燔祭要放在壇的柴上，從晚上到天亮，壇上的火要常常燒着。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","祭司要穿上細麻布衣服，又要把細麻布褲子穿在身上，把壇上所燒的燔祭灰收起來，倒在壇的旁邊； ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","隨後要脫去這衣服，穿上別的衣服，把灰拿到營外潔淨之處。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","壇上的火要在其上常常燒着，不可熄滅。祭司要每日早晨在上面燒柴，並要把燔祭擺在壇上，在其上燒平安祭牲的脂油。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","在壇上必有常常燒着的火，不可熄滅。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","「素祭的條例乃是這樣：亞倫的子孫要在壇前把這祭獻在耶和華面前。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","祭司要從其中－就是從素祭的細麵中－取出自己的一把，又要取些油和素祭上所有的乳香，燒在壇上，奉給耶和華為馨香素祭的紀念。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","所剩下的，亞倫和他子孫要吃，必在聖處不帶酵而吃，要在會幕的院子裏吃。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","烤的時候不可攙酵。這是從所獻給我的火祭中賜給他們的分，是至聖的，和贖罪祭並贖愆祭一樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","凡獻給耶和華的火祭，亞倫子孫中的男丁都要吃這一分，直到萬代，作他們永得的分。摸這些祭物的，都要成為聖。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","耶和華曉諭摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","「當亞倫受膏的日子，他和他子孫所要獻給耶和華的供物，就是細麵伊法十分之一，為常獻的素祭：早晨一半，晚上一半。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","要在鐵鏊上用油調和做成，調勻了，你就拿進來；烤好了分成塊子，獻給耶和華為馨香的素祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","亞倫的子孫中，接續他為受膏的祭司，要把這素祭獻上，要全燒給耶和華。這是永遠的定例。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","祭司的素祭都要燒了，卻不可吃。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","耶和華曉諭摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","「你對亞倫和他的子孫說，贖罪祭的條例乃是這樣：要在耶和華面前、宰燔祭牲的地方宰贖罪祭牲；這是至聖的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","為贖罪獻這祭的祭司要吃，要在聖處，就是在會幕的院子裏吃。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","凡摸這祭肉的要成為聖；這祭牲的血若彈在甚麼衣服上，所彈的那一件要在聖處洗淨。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","惟有煮祭物的瓦器要打碎；若是煮在銅器裏，這銅器要擦磨，在水中涮淨。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","凡祭司中的男丁都可以吃；這是至聖的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","凡贖罪祭，若將血帶進會幕在聖所贖罪，那肉都不可吃，必用火焚燒。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","「贖愆祭的條例乃是如此：這祭是至聖的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","人在那裏宰燔祭牲，也要在那裏宰贖愆祭牲；其血，祭司要灑在壇的周圍。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","又要將肥尾巴和蓋臟的脂油， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","兩個腰子和腰子上的脂油，就是靠腰兩旁的脂油，並肝上的網子和腰子，一概取下。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","祭司要在壇上焚燒，為獻給耶和華的火祭，是贖愆祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","祭司中的男丁都可以吃這祭物；要在聖處吃，是至聖的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","贖罪祭怎樣，贖愆祭也是怎樣，兩個祭是一個條例。獻贖愆祭贖罪的祭司要得這祭物。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","獻燔祭的祭司，無論為誰奉獻，要親自得他所獻那燔祭牲的皮。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","凡在爐中烤的素祭和煎盤中做的，並鐵鏊上做的，都要歸那獻祭的祭司。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","凡素祭，無論是油調和的是乾的，都要歸亞倫的子孫，大家均分。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","「人獻與耶和華平安祭的條例乃是這樣： ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","他若為感謝獻上，就要用調油的無酵餅和抹油的無酵薄餅，並用油調勻細麵做的餅，與感謝祭一同獻上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","要用有酵的餅和為感謝獻的平安祭，與供物一同獻上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","從各樣的供物中，他要把一個餅獻給耶和華為舉祭，是要歸給灑平安祭牲血的祭司。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","為感謝獻平安祭牲的肉，要在獻的日子吃，一點不可留到早晨。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","若所獻的是為還願，或是甘心獻的，必在獻祭的日子吃，所剩下的第二天也可以吃。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","但所剩下的祭肉，到第三天要用火焚燒； ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","第三天若吃了平安祭的肉，這祭必不蒙悅納，人所獻的也不算為祭，反為可憎嫌的，吃這祭肉的，就必擔當他的罪孽。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","「挨了污穢物的肉就不可吃，要用火焚燒。至於平安祭的肉，凡潔淨的人都要吃； ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","只是獻與耶和華平安祭的肉，人若不潔淨而吃了，這人必從民中剪除。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","有人摸了甚麼不潔淨的物，或是人的不潔淨，或是不潔淨的牲畜，或是不潔可憎之物，吃了獻與耶和華平安祭的肉，這人必從民中剪除。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","耶和華對摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","「你曉諭以色列人說：牛的脂油、綿羊的脂油、山羊的脂油，你們都不可吃。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","自死的和被野獸撕裂的，那脂油可以做別的使用，只是你們萬不可吃。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","無論何人吃了獻給耶和華當火祭牲畜的脂油，那人必從民中剪除。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","在你們一切的住處，無論是雀鳥的血是野獸的血，你們都不可吃。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","無論是誰吃血，那人必從民中剪除。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","耶和華對摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","「你曉諭以色列人說：獻平安祭給耶和華的，要從平安祭中取些來奉給耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","他親手獻給耶和華的火祭，就是脂油和胸，要帶來，好把胸在耶和華面前作搖祭，搖一搖。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","祭司要把脂油在壇上焚燒，但胸要歸亞倫和他的子孫。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","你們要從平安祭中把右腿作舉祭，奉給祭司。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","亞倫子孫中，獻平安祭牲血和脂油的，要得這右腿為分； ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","因為我從以色列人的平安祭中，取了這搖的胸和舉的腿給祭司亞倫和他子孫，作他們從以色列人中所永得的分。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","這是從耶和華火祭中，作亞倫受膏的分和他子孫受膏的分，正在摩西叫他們前來給耶和華供祭司職分的日子， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","就是在摩西膏他們的日子，耶和華吩咐以色列人給他們的。這是他們世世代代永得的分。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","這就是燔祭、素祭、贖罪祭、贖愆祭，和平安祭的條例，並承接聖職的禮， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","都是耶和華在西奈山所吩咐摩西的，就是他在西奈曠野吩咐以色列人獻供物給耶和華之日所說的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","耶和華曉諭摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","「你將亞倫和他兒子一同帶來，並將聖衣、膏油，與贖罪祭的一隻公牛、兩隻公綿羊、一筐無酵餅都帶來， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","又招聚會眾到會幕門口。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","摩西就照耶和華所吩咐的行了；於是會眾聚集在會幕門口。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","摩西告訴會眾說：「這就是耶和華所吩咐當行的事。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","摩西帶了亞倫和他兒子來，用水洗了他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","給亞倫穿上內袍，束上腰帶，穿上外袍，又加上以弗得，用其上巧工織的帶子把以弗得繫在他身上， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","又給他戴上胸牌，把烏陵和土明放在胸牌內， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","把冠冕戴在他頭上，在冠冕的前面釘上金牌，就是聖冠，都是照耶和華所吩咐摩西的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","摩西用膏油抹帳幕和其中所有的，使它成聖； ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","又用膏油在壇上彈了七次，又抹了壇和壇的一切器皿，並洗濯盆和盆座，使它成聖； ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","又把膏油倒在亞倫的頭上膏他，使他成聖。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","摩西帶了亞倫的兒子來，給他們穿上內袍，束上腰帶，包上裹頭巾，都是照耶和華所吩咐摩西的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","他牽了贖罪祭的公牛來，亞倫和他兒子按手在贖罪祭公牛的頭上， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","就宰了公牛。摩西用指頭蘸血，抹在壇上四角的周圍，使壇潔淨，把血倒在壇的腳那裏，使壇成聖，壇就潔淨了； ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","又取臟上所有的脂油和肝上的網子，並兩個腰子與腰子上的脂油，都燒在壇上； ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","惟有公牛，連皮帶肉並糞，用火燒在營外，都是照耶和華所吩咐摩西的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","他奉上燔祭的公綿羊；亞倫和他兒子按手在羊的頭上， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","就宰了公羊。摩西把血灑在壇的周圍， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","把羊切成塊子，把頭和肉塊並脂油都燒了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","用水洗了臟腑和腿，就把全羊燒在壇上為馨香的燔祭，是獻給耶和華的火祭，都是照耶和華所吩咐摩西的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","他又奉上第二隻公綿羊，就是承接聖職之禮的羊；亞倫和他兒子按手在羊的頭上， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","就宰了羊。摩西把些血抹在亞倫的右耳垂上和右手的大拇指上，並右腳的大拇指上， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","又帶了亞倫的兒子來，把些血抹在他們的右耳垂上和右手的大拇指上，並右腳的大拇指上，又把血灑在壇的周圍。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","取脂油和肥尾巴，並臟上一切的脂油與肝上的網子，兩個腰子和腰子上的脂油，並右腿， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","再從耶和華面前、盛無酵餅的筐子裏取出一個無酵餅，一個油餅，一個薄餅，都放在脂油和右腿上， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","把這一切放在亞倫的手上和他兒子的手上作搖祭，在耶和華面前搖一搖。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","摩西從他們的手上拿下來，燒在壇上的燔祭上，都是為承接聖職獻給耶和華馨香的火祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","摩西拿羊的胸作為搖祭，在耶和華面前搖一搖，是承接聖職之禮，歸摩西的分，都是照耶和華所吩咐摩西的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","摩西取點膏油和壇上的血，彈在亞倫和他的衣服上，並他兒子和他兒子的衣服上，使他和他們的衣服一同成聖。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","摩西對亞倫和他兒子說：「把肉煮在會幕門口，在那裏吃，又吃承接聖職筐子裏的餅，按我所吩咐的說 ：『這是亞倫和他兒子要吃的。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","剩下的肉和餅，你們要用火焚燒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","你們七天不可出會幕的門，等到你們承接聖職的日子滿了，因為主叫你們七天承接聖職。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","像今天所行的都是耶和華吩咐行的，為你們贖罪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","七天你們要晝夜住在會幕門口，遵守耶和華的吩咐，免得你們死亡，因為所吩咐我的就是這樣。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","於是亞倫和他兒子行了耶和華藉着摩西所吩咐的一切事。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","到了第八天，摩西召了亞倫和他兒子，並以色列的眾長老來， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","對亞倫說：「你當取牛群中的一隻公牛犢作贖罪祭，一隻公綿羊作燔祭，都要沒有殘疾的，獻在耶和華面前。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","你也要對以色列人說：『你們當取一隻公山羊作贖罪祭，又取一隻牛犢和一隻綿羊羔，都要一歲、沒有殘疾的，作燔祭， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","又取一隻公牛，一隻公綿羊作平安祭，獻在耶和華面前，並取調油的素祭，因為今天耶和華要向你們顯現。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","於是他們把摩西所吩咐的，帶到會幕前；全會眾都近前來，站在耶和華面前。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","摩西說：「這是耶和華吩咐你們所當行的；耶和華的榮光就要向你們顯現。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","摩西對亞倫說：「你就近壇前，獻你的贖罪祭和燔祭，為自己與百姓贖罪，又獻上百姓的供物，為他們贖罪，都照耶和華所吩咐的。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","於是，亞倫就近壇前，宰了為自己作贖罪祭的牛犢。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","亞倫的兒子把血奉給他，他就把指頭蘸在血中，抹在壇的四角上，又把血倒在壇腳那裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","惟有贖罪祭的脂油和腰子，並肝上取的網子，都燒在壇上，是照耶和華所吩咐摩西的； ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","又用火將肉和皮燒在營外。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","亞倫宰了燔祭牲，他兒子把血遞給他，他就灑在壇的周圍， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","又把燔祭一塊一塊地、連頭遞給他，他都燒在壇上； ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","又洗了臟腑和腿，燒在壇上的燔祭上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","他奉上百姓的供物，把那給百姓作贖罪祭的公山羊宰了，為罪獻上，和先獻的一樣； ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","也奉上燔祭，照例而獻。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","他又奉上素祭，從其中取一滿把，燒在壇上；這是在早晨的燔祭以外。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","亞倫宰了那給百姓作平安祭的公牛和公綿羊。他兒子把血遞給他，他就灑在壇的周圍； ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","又把公牛和公綿羊的脂油、肥尾巴，並蓋臟的脂油與腰子，和肝上的網子，都遞給他； ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","把脂油放在胸上，他就把脂油燒在壇上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","胸和右腿，亞倫當作搖祭，在耶和華面前搖一搖，都是照摩西所吩咐的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","亞倫向百姓舉手，為他們祝福。他獻了贖罪祭、燔祭、平安祭就下來了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","摩西、亞倫進入會幕，又出來為百姓祝福，耶和華的榮光就向眾民顯現。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","有火從耶和華面前出來，在壇上燒盡燔祭和脂油；眾民一見，就都歡呼，俯伏在地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","亞倫的兒子拿答、亞比戶各拿自己的香爐，盛上火，加上香，在耶和華面前獻上凡火，是耶和華沒有吩咐他們的， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","就有火從耶和華面前出來，把他們燒滅，他們就死在耶和華面前。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","於是摩西對亞倫說：「這就是耶和華所說：『我在親近我的人中要顯為聖；在眾民面前，我要得榮耀。』」亞倫就默默不言。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","摩西召了亞倫叔父烏薛的兒子米沙利、以利撒反來，對他們說：「上前來，把你們的親屬從聖所前抬到營外。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","於是二人上前來，把他們穿着袍子抬到營外，是照摩西所吩咐的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","摩西對亞倫和他兒子以利亞撒、以他瑪說：「不可蓬頭散髮，也不可撕裂衣裳，免得你們死亡，又免得耶和華向會眾發怒；只要你們的弟兄以色列全家為耶和華所發的火哀哭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","你們也不可出會幕的門，恐怕你們死亡，因為耶和華的膏油在你們的身上。」他們就照摩西的話行了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","耶和華曉諭亞倫說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","「你和你兒子進會幕的時候，清酒、濃酒都不可喝，免得你們死亡；這要作你們世世代代永遠的定例。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","使你們可以將聖的、俗的，潔淨的、不潔淨的，分別出來； ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","又使你們可以將耶和華藉摩西曉諭以色列人的一切律例教訓他們。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","摩西對亞倫和他剩下的兒子以利亞撒、以他瑪說：「你們獻給耶和華火祭中所剩的素祭，要在壇旁不帶酵而吃，因為是至聖的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","你們要在聖處吃；因為在獻給耶和華的火祭中，這是你的分和你兒子的分；所吩咐我的本是這樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","所搖的胸，所舉的腿，你們要在潔淨地方吃。你和你的兒女都要同吃；因為這些是從以色列人平安祭中給你，當你的分和你兒子的分。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","所舉的腿，所搖的胸，他們要與火祭的脂油一同帶來當搖祭，在耶和華面前搖一搖；這要歸你和你兒子，當作永得的分，都是照耶和華所吩咐的。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","當下摩西急切地尋找作贖罪祭的公山羊，誰知已經焚燒了，便向亞倫剩下的兒子以利亞撒、以他瑪發怒，說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","「這贖罪祭既是至聖的，主又給了你們，為要你們擔當會眾的罪孽，在耶和華面前為他們贖罪，你們為何沒有在聖所吃呢？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","看哪，這祭牲的血並沒有拿到聖所裏去，你們本當照我所吩咐的，在聖所裏吃這祭肉。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","亞倫對摩西說：「今天他們在耶和華面前獻上贖罪祭和燔祭，我又遇見這樣的災，若今天吃了贖罪祭，耶和華豈能看為美呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","摩西聽見這話，便以為美。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","耶和華對摩西、亞倫說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","「你們曉諭以色列人說，在地上一切走獸中可吃的乃是這些： ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","凡蹄分兩瓣、倒嚼的走獸，你們都可以吃。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","但那倒嚼或分蹄之中不可吃的乃是：駱駝－因為倒嚼不分蹄，就與你們不潔淨； ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","沙番－因為倒嚼不分蹄，就與你們不潔淨； ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","觠子－因為倒嚼不分蹄，就與你們不潔淨； ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","豬－因為蹄分兩瓣，卻不倒嚼，就與你們不潔淨。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","這些獸的肉，你們不可吃；死的，你們不可摸，都與你們不潔淨。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","「水中可吃的乃是這些：凡在水裏、海裏、河裏、有翅有鱗的，都可以吃。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","凡在海裏、河裏，並一切水裏游動的活物，無翅無鱗的，你們都當以為可憎。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","這些無翅無鱗、以為可憎的，你們不可吃牠的肉；死的也當以為可憎。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","凡水裏無翅無鱗的，你們都當以為可憎。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","「雀鳥中你們當以為可憎、不可吃的乃是：鵰、狗頭鵰、紅頭鵰、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","鷂鷹、小鷹與其類； ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","烏鴉與其類； ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","鴕鳥、夜鷹、魚鷹、鷹與其類； ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","鴞鳥、鸕鶿、貓頭鷹、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","角鴟、鵜鶘、禿鵰、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","鸛、鷺鷥與其類；戴鵀與蝙蝠。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","「凡有翅膀用四足爬行的物，你們都當以為可憎。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","只是有翅膀用四足爬行的物中，有足有腿，在地上蹦跳的，你們還可以吃。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","其中有蝗蟲、螞蚱、蟋蟀與其類；蚱蜢與其類；這些你們都可以吃。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","但是有翅膀有四足的爬物，你們都當以為可憎。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","「這些都能使你們不潔淨。凡摸了死的，必不潔淨到晚上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","凡拿了死的，必不潔淨到晚上，並要洗衣服。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","凡走獸分蹄不成兩瓣、也不倒嚼的，是與你們不潔淨；凡摸了的就不潔淨。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","凡四足的走獸，用掌行走的，是與你們不潔淨；摸其屍的，必不潔淨到晚上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","拿其屍的，必不潔淨到晚上，並要洗衣服。這些是與你們不潔淨的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","「地上爬物與你們不潔淨的乃是這些：鼬鼠、鼫鼠、蜥蜴與其類； ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","壁虎、龍子、守宮、蛇醫、蝘蜓。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","這些爬物都是與你們不潔淨的。在牠死了以後，凡摸了的，必不潔淨到晚上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","其中死了的，掉在甚麼東西上，這東西就不潔淨，無論是木器、衣服、皮子、口袋，不拘是做甚麼工用的器皿，須要放在水中，必不潔淨到晚上，到晚上才潔淨了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","若有死了掉在瓦器裏的，其中不拘有甚麼，就不潔淨，你們要把這瓦器打破了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","其中一切可吃的食物，沾水的就不潔淨，並且那樣器皿中一切可喝的，也必不潔淨。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","其中已死的，若有一點掉在甚麼物件上，那物件就不潔淨，不拘是爐子，是鍋臺，就要打碎，都不潔淨，也必與你們不潔淨。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","但是泉源或是聚水的池子仍是潔淨；惟挨了那死的，就不潔淨。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","若是死的，有一點掉在要種的子粒上，子粒仍是潔淨； ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","若水已經澆在子粒上，那死的有一點掉在上頭，這子粒就與你們不潔淨。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","「你們可吃的走獸若是死了，有人摸牠，必不潔淨到晚上； ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","有人吃那死了的走獸，必不潔淨到晚上，並要洗衣服；拿了死走獸的，必不潔淨到晚上，並要洗衣服。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","「凡地上的爬物是可憎的，都不可吃。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","凡用肚子行走的和用四足行走的，或是有許多足的，就是一切爬在地上的，你們都不可吃，因為是可憎的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","你們不可因甚麼爬物使自己成為可憎的，也不可因這些使自己不潔淨，以致染了污穢。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","我是耶和華－你們的上帝；所以你們要成為聖潔，因為我是聖潔的。你們也不可在地上的爬物污穢自己。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","我是把你們從埃及地領出來的耶和華，要作你們的上帝；所以你們要聖潔，因為我是聖潔的。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","這是走獸、飛鳥，和水中游動的活物，並地上爬物的條例。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","要把潔淨的和不潔淨的，可吃的與不可吃的活物，都分別出來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","耶和華對摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","「你曉諭以色列人說：若有婦人懷孕生男孩，她就不潔淨七天，像在月經污穢的日子不潔淨一樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","第八天，要給嬰孩行割禮。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","婦人在產血不潔之中，要家居三十三天。她潔淨的日子未滿，不可摸聖物，也不可進入聖所。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","她若生女孩，就不潔淨兩個七天，像污穢的時候一樣，要在產血不潔之中，家居六十六天。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","「滿了潔淨的日子，無論是為男孩是為女孩，她要把一歲的羊羔為燔祭，一隻雛鴿或是一隻斑鳩為贖罪祭，帶到會幕門口交給祭司。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","祭司要獻在耶和華面前，為她贖罪，她的血源就潔淨了。這條例是為生育的婦人，無論是生男生女。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","她的力量若不夠獻一隻羊羔，她就要取兩隻斑鳩或是兩隻雛鴿，一隻為燔祭，一隻為贖罪祭。祭司要為她贖罪，她就潔淨了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","耶和華曉諭摩西、亞倫說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","「人的肉皮上若長了癤子，或長了癬，或長了火斑，在他肉皮上成了大痲瘋的災病，就要將他帶到祭司亞倫或亞倫作祭司的一個子孫面前。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","祭司要察看肉皮上的災病，若災病處的毛已經變白，災病的現象深於肉上的皮，這便是大痲瘋的災病。祭司要察看他，定他為不潔淨。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","若火斑在他肉皮上是白的，現象不深於皮，其上的毛也沒有變白，祭司就要將有災病的人關鎖七天。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","第七天，祭司要察看他，若看災病止住了，沒有在皮上發散，祭司還要將他關鎖七天。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","第七天，祭司要再察看他，若災病發暗，而且沒有在皮上發散，祭司要定他為潔淨，原來是癬；那人就要洗衣服，得為潔淨。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","但他為得潔淨，將身體給祭司察看以後，癬若在皮上發散開了，他要再將身體給祭司察看。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","祭司要察看，癬若在皮上發散，就要定他為不潔淨，是大痲瘋。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","「人有了大痲瘋的災病，就要將他帶到祭司面前。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","祭司要察看，皮上若長了白癤，使毛變白，在長白癤之處有了紅瘀肉， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","這是肉皮上的舊大痲瘋，祭司要定他為不潔淨，不用將他關鎖，因為他是不潔淨了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","大痲瘋若在皮上四外發散，長滿了患災病人的皮，據祭司察看，從頭到腳無處不有， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","祭司就要察看，全身的肉若長滿了大痲瘋，就要定那患災病的為潔淨；全身都變為白，他乃潔淨了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","但紅肉幾時顯在他的身上就幾時不潔淨。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","祭司一看那紅肉就定他為不潔淨。紅肉本是不潔淨，是大痲瘋。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","紅肉若復原，又變白了，他就要來見祭司。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","祭司要察看，災病處若變白了，祭司就要定那患災病的為潔淨，他乃潔淨了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","「人若在皮肉上長瘡，卻治好了， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","在長瘡之處又起了白癤，或是白中帶紅的火斑，就要給祭司察看。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","祭司要察看，若現象窪於皮，其上的毛也變白了，就要定他為不潔淨，是大痲瘋的災病發在瘡中。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","祭司若察看，其上沒有白毛，也沒有窪於皮，乃是發暗，就要將他關鎖七天。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","若在皮上發散開了，祭司就要定他為不潔淨，是災病。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","火斑若在原處止住，沒有發散，便是瘡的痕跡，祭司就要定他為潔淨。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","「人的皮肉上若起了火毒，火毒的瘀肉成了火斑，或是白中帶紅的，或是全白的， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","祭司就要察看，火斑中的毛若變白了，現象又深於皮，是大痲瘋在火毒中發出，就要定他為不潔淨，是大痲瘋的災病。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","但是祭司察看，在火斑中若沒有白毛，也沒有窪於皮，乃是發暗，就要將他關鎖七天。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","到第七天，祭司要察看他，火斑若在皮上發散開了，就要定他為不潔淨，是大痲瘋的災病。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","火斑若在原處止住，沒有在皮上發散，乃是發暗，是起的火毒，祭司要定他為潔淨，不過是火毒的痕跡。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","「無論男女，若在頭上有災病，或是男人鬍鬚上有災病， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","祭司就要察看；這災病現象若深於皮，其間有細黃毛，就要定他為不潔淨，這是頭疥，是頭上或是鬍鬚上的大痲瘋。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","祭司若察看頭疥的災病，現象不深於皮，其間也沒有黑毛，就要將長頭疥災病的關鎖七天。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","第七天，祭司要察看災病，若頭疥沒有發散，其間也沒有黃毛，頭疥的現象不深於皮， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","那人就要剃去鬚髮，但他不可剃頭疥之處。祭司要將那長頭疥的，再關鎖七天。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","第七天，祭司要察看頭疥，頭疥若沒有在皮上發散，現象也不深於皮，就要定他為潔淨，他要洗衣服，便成為潔淨。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","但他得潔淨以後，頭疥若在皮上發散開了， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","祭司就要察看他。頭疥若在皮上發散，就不必找那黃毛，他是不潔淨了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","祭司若看頭疥已經止住，其間也長了黑毛，頭疥已然痊癒，那人是潔淨了，就要定他為潔淨。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","「無論男女，皮肉上若起了火斑，就是白火斑， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","祭司就要察看，他們肉皮上的火斑若白中帶黑，這是皮上發出的白癬，那人是潔淨了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","「人頭上的髮若掉了，他不過是頭禿，還是潔淨。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","他頂前若掉了頭髮，他不過是頂門禿，還是潔淨。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","頭禿處或是頂門禿處若有白中帶紅的災病，這就是大痲瘋發在他頭禿處或是頂門禿處， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","祭司就要察看，他起的那災病若在頭禿處或是頂門禿處有白中帶紅的，像肉皮上大痲瘋的現象， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","那人就是長大痲瘋，不潔淨的，祭司總要定他為不潔淨，他的災病是在頭上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","「身上有長大痲瘋災病的，他的衣服要撕裂，也要蓬頭散髮，蒙着上唇，喊叫說：『不潔淨了！不潔淨了！』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","災病在他身上的日子，他便是不潔淨；他既是不潔淨，就要獨居營外。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","「染了大痲瘋災病的衣服，無論是羊毛衣服、是麻布衣服， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","無論是在經上、在緯上，是麻布的、是羊毛的，是在皮子上，或在皮子做的甚麼物件上， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","或在衣服上、皮子上，經上、緯上，或在皮子做的甚麼物件上，這災病若是發綠，或是發紅，是大痲瘋的災病，要給祭司察看。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","祭司就要察看那災病，把染了災病的物件關鎖七天。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","第七天，他要察看那災病，災病或在衣服上，經上、緯上，皮子上，若發散，這皮子無論當作何用，這災病是蠶食的大痲瘋，都是不潔淨了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","那染了災病的衣服，或是經上、緯上，羊毛上，麻衣上，或是皮子做的甚麼物件上，他都要焚燒；因為這是蠶食的大痲瘋，必在火中焚燒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","「祭司要察看，若災病在衣服上，經上、緯上，或是皮子做的甚麼物件上，沒有發散， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","祭司就要吩咐他們，把染了災病的物件洗了，再關鎖七天。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","洗過以後，祭司要察看，那物件若沒有變色，災病也沒有消散，那物件就不潔淨，是透重的災病，無論正面反面，都要在火中焚燒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","洗過以後，祭司要察看，若見那災病發暗，他就要把那災病從衣服上，皮子上，經上、緯上，都撕去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","若仍現在衣服上，或是經上、緯上、皮子做的甚麼物件上，這就是災病又發了，必用火焚燒那染災病的物件。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","所洗的衣服，或是經，或是緯，或是皮子做的甚麼物件，若災病離開了，要再洗，就潔淨了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","這就是大痲瘋災病的條例，無論是在羊毛衣服上，麻布衣服上，經上、緯上，和皮子做的甚麼物件上，可以定為潔淨或是不潔淨。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","耶和華曉諭摩西說：「 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","長大痲瘋得潔淨的日子，其例乃是這樣：要帶他去見祭司； ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","祭司要出到營外察看，若見他的大痲瘋痊癒了， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","就要吩咐人為那求潔淨的拿兩隻潔淨的活鳥和香柏木、朱紅色線，並牛膝草來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","祭司要吩咐用瓦器盛活水，把一隻鳥宰在上面。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","至於那隻活鳥，祭司要把牠和香柏木、朱紅色線並牛膝草一同蘸於宰在活水上的鳥血中， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","用以在那長大痲瘋求潔淨的人身上灑七次，就定他為潔淨，又把活鳥放在田野裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","求潔淨的人當洗衣服，剃去毛髮，用水洗澡，就潔淨了；然後可以進營，只是要在自己的帳棚外居住七天。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","第七天，再把頭上所有的頭髮與鬍鬚、眉毛，並全身的毛，都剃了；又要洗衣服，用水洗身，就潔淨了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","「第八天，他要取兩隻沒有殘疾的公羊羔和一隻沒有殘疾、一歲的母羊羔，又要把調油的細麵伊法十分之三為素祭，並油一羅革，一同取來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","行潔淨之禮的祭司要將那求潔淨的人和這些東西安置在會幕門口、耶和華面前。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","祭司要取一隻公羊羔獻為贖愆祭，和那一羅革油一同作搖祭，在耶和華面前搖一搖； ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","把公羊羔宰於聖地，就是宰贖罪祭牲和燔祭牲之地。贖愆祭要歸祭司，與贖罪祭一樣，是至聖的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","祭司要取些贖愆祭牲的血，抹在求潔淨人的右耳垂上和右手的大拇指上，並右腳的大拇指上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","祭司要從那一羅革油中取些倒在自己的左手掌裏， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","把右手的一個指頭蘸在左手的油裏，在耶和華面前用指頭彈七次。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","將手裏所剩的油抹在那求潔淨人的右耳垂上和右手的大拇指上，並右腳的大拇指上，就是抹在贖愆祭牲的血上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","祭司手裏所剩的油要抹在那求潔淨人的頭上，在耶和華面前為他贖罪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","祭司要獻贖罪祭，為那本不潔淨、求潔淨的人贖罪；然後要宰燔祭牲， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","把燔祭和素祭獻在壇上，為他贖罪，他就潔淨了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","「他若貧窮不能預備夠數，就要取一隻公羊羔作贖愆祭，可以搖一搖，為他贖罪；也要把調油的細麵伊法十分之一為素祭，和油一羅革一同取來； ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","又照他的力量取兩隻斑鳩或是兩隻雛鴿，一隻作贖罪祭，一隻作燔祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","第八天，要為潔淨，把這些帶到會幕門口、耶和華面前，交給祭司。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","祭司要把贖愆祭的羊羔和那一羅革油一同作搖祭，在耶和華面前搖一搖。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","要宰了贖愆祭的羊羔，取些贖愆祭牲的血，抹在那求潔淨人的右耳垂上和右手的大拇指上，並右腳的大拇指上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","祭司要把些油倒在自己的左手掌裏， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","把左手裏的油，在耶和華面前，用右手的一個指頭彈七次， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","又把手裏的油抹些在那求潔淨人的右耳垂上和右手的大拇指上，並右腳的大拇指上，就是抹贖愆祭之血的原處。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","祭司手裏所剩的油要抹在那求潔淨人的頭上，在耶和華面前為他贖罪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","那人又要照他的力量獻上一隻斑鳩或是一隻雛鴿， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","就是他所能辦的，一隻為贖罪祭，一隻為燔祭，與素祭一同獻上；祭司要在耶和華面前為他贖罪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","這是那有大痲瘋災病的人、不能將關乎得潔淨之物預備夠數的條例。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","耶和華曉諭摩西、亞倫說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","「你們到了我賜給你們為業的迦南地，我若使你們所得為業之地的房屋中有大痲瘋的災病， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","房主就要去告訴祭司說：『據我看，房屋中似乎有災病。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","祭司還沒有進去察看災病以前，就要吩咐人把房子騰空，免得房子裏所有的都成了不潔淨；然後祭司要進去察看房子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","他要察看那災病，災病若在房子的牆上有發綠或發紅的凹斑紋，現象窪於牆， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","祭司就要出到房門外，把房子封鎖七天。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","第七天，祭司要再去察看，災病若在房子的牆上發散， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","就要吩咐人把那有災病的石頭挖出來，扔在城外不潔淨之處； ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","也要叫人刮房內的四圍，所刮掉的灰泥要倒在城外不潔淨之處； ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","又要用別的石頭代替那挖出來的石頭，要另用灰泥墁房子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","「他挖出石頭，刮了房子，墁了以後，災病若在房子裏又發現， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","祭司就要進去察看，災病若在房子裏發散，這就是房內蠶食的大痲瘋，是不潔淨。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","他就要拆毀房子，把石頭、木頭、灰泥都搬到城外不潔淨之處。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","在房子封鎖的時候，進去的人必不潔淨到晚上； ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","在房子裏躺着的必洗衣服；在房子裏吃飯的也必洗衣服。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","「房子墁了以後，祭司若進去察看，見災病在房內沒有發散，就要定房子為潔淨，因為災病已經消除。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","要為潔淨房子取兩隻鳥和香柏木、朱紅色線並牛膝草， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","用瓦器盛活水，把一隻鳥宰在上面， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","把香柏木、牛膝草、朱紅色線，並那活鳥，都蘸在被宰的鳥血中與活水中，用以灑房子七次。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","要用鳥血、活水、活鳥、香柏木、牛膝草，並朱紅色線，潔淨那房子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","但要把活鳥放在城外田野裏。這樣潔淨房子，房子就潔淨了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","這是為各類大痲瘋的災病和頭疥， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","並衣服與房子的大痲瘋， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","以及癤子、癬、火斑所立的條例， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","指明何時為潔淨，何時為不潔淨。這是大痲瘋的條例。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","耶和華對摩西、亞倫說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","「你們曉諭以色列人說：人若身患漏症，他因這漏症就不潔淨了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","他患漏症，無論是下流的，是止住的，都是不潔淨。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","他所躺的床都為不潔淨，所坐的物也為不潔淨。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","凡摸那床的，必不潔淨到晚上，並要洗衣服，用水洗澡。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","那坐患漏症人所坐之物的，必不潔淨到晚上，並要洗衣服，用水洗澡。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","那摸患漏症人身體的，必不潔淨到晚上，並要洗衣服，用水洗澡。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","若患漏症人吐在潔淨的人身上，那人必不潔淨到晚上，並要洗衣服，用水洗澡。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","患漏症人所騎的鞍子也為不潔淨。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","凡摸了他身下之物的，必不潔淨到晚上；拿了那物的，必不潔淨到晚上，並要洗衣服，用水洗澡。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","患漏症的人沒有用水涮手，無論摸了誰，誰必不潔淨到晚上，並要洗衣服，用水洗澡。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","患漏症人所摸的瓦器就必打破；所摸的一切木器也必用水涮洗。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","「患漏症的人痊癒了，就要為潔淨自己計算七天，也必洗衣服，用活水洗身，就潔淨了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","第八天，要取兩隻斑鳩或是兩隻雛鴿，來到會幕門口、耶和華面前，把鳥交給祭司。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","祭司要獻上一隻為贖罪祭，一隻為燔祭；因那人患的漏症，祭司要在耶和華面前為他贖罪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","「人若夢遺，他必不潔淨到晚上，並要用水洗全身。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","無論是衣服是皮子，被精所染，必不潔淨到晚上，並要用水洗。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","若男女交合，兩個人必不潔淨到晚上，並要用水洗澡。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","「女人行經，必污穢七天；凡摸她的，必不潔淨到晚上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","女人在污穢之中，凡她所躺的物件都為不潔淨，所坐的物件也都不潔淨。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","凡摸她床的，必不潔淨到晚上，並要洗衣服，用水洗澡。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","凡摸她所坐甚麼物件的，必不潔淨到晚上，並要洗衣服，用水洗澡。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","在女人的床上，或在她坐的物上，若有別的物件，人一摸了，必不潔淨到晚上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","男人若與那女人同房，染了她的污穢，就要七天不潔淨；所躺的床也為不潔淨。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","「女人若在經期以外患多日的血漏，或是經期過長，有了漏症，她就因這漏症不潔淨，與她在經期不潔淨一樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","她在患漏症的日子所躺的床、所坐的物都要看為不潔淨，與她月經的時候一樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","凡摸這些物件的，就為不潔淨，必不潔淨到晚上，並要洗衣服，用水洗澡。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","女人的漏症若好了，就要計算七天，然後才為潔淨。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","第八天，要取兩隻斑鳩或是兩隻雛鴿，帶到會幕門口給祭司。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","祭司要獻一隻為贖罪祭，一隻為燔祭；因那人血漏不潔，祭司要在耶和華面前為她贖罪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","「你們要這樣使以色列人與他們的污穢隔絕，免得他們玷污我的帳幕，就因自己的污穢死亡。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","這是患漏症和夢遺而不潔淨的， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","並有月經病的和患漏症的，無論男女，並人與不潔淨女人同房的條例。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","亞倫的兩個兒子近到耶和華面前死了。死了之後，耶和華曉諭摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","「要告訴你哥哥亞倫，不可隨時進聖所的幔子內、到櫃上的施恩座前，免得他死亡，因為我要從雲中顯現在施恩座上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","亞倫進聖所，要帶一隻公牛犢為贖罪祭，一隻公綿羊為燔祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","要穿上細麻布聖內袍，把細麻布褲子穿在身上，腰束細麻布帶子，頭戴細麻布冠冕；這都是聖服。他要用水洗身，然後穿戴。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","要從以色列會眾取兩隻公山羊為贖罪祭，一隻公綿羊為燔祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","「亞倫要把贖罪祭的公牛奉上，為自己和本家贖罪； ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","也要把兩隻公山羊安置在會幕門口、耶和華面前， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","為那兩隻羊拈鬮，一鬮歸與耶和華，一鬮歸與阿撒瀉勒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","亞倫要把那拈鬮歸與耶和華的羊獻為贖罪祭， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","但那拈鬮歸與阿撒瀉勒的羊要活着安置在耶和華面前，用以贖罪，打發人送到曠野去，歸與阿撒瀉勒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","「亞倫要把贖罪祭的公牛牽來宰了，為自己和本家贖罪； ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","拿香爐，從耶和華面前的壇上盛滿火炭，又拿一捧搗細的香料，都帶入幔子內， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","在耶和華面前，把香放在火上，使香的煙雲遮掩法櫃上的施恩座，免得他死亡； ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","也要取些公牛的血，用指頭彈在施恩座的東面，又在施恩座的前面彈血七次。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","「隨後他要宰那為百姓作贖罪祭的公山羊，把羊的血帶入幔子內，彈在施恩座的上面和前面，好像彈公牛的血一樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","他因以色列人諸般的污穢、過犯，就是他們一切的罪愆，當這樣在聖所行贖罪之禮，並因會幕在他們污穢之中，也要照樣而行。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","他進聖所贖罪的時候，會幕裏不可有人，直等到他為自己和本家並以色列全會眾贖了罪出來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","他出來，要到耶和華面前的壇那裏，在壇上行贖罪之禮，又要取些公牛的血和公山羊的血，抹在壇上四角的周圍； ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","也要用指頭把血彈在壇上七次，潔淨了壇，從壇上除掉以色列人諸般的污穢，使壇成聖。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","「亞倫為聖所和會幕並壇獻完了贖罪祭，就要把那隻活着的公山羊奉上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","兩手按在羊頭上，承認以色列人諸般的罪孽過犯，就是他們一切的罪愆，把這罪都歸在羊的頭上，藉着所派之人的手，送到曠野去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","要把這羊放在曠野，這羊要擔當他們一切的罪孽，帶到無人之地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","「亞倫要進會幕，把他進聖所時所穿的細麻布衣服脫下，放在那裏， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","又要在聖處用水洗身，穿上衣服，出來，把自己的燔祭和百姓的燔祭獻上，為自己和百姓贖罪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","贖罪祭牲的脂油要在壇上焚燒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","那放羊歸與阿撒瀉勒的人要洗衣服，用水洗身，然後進營。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","作贖罪祭的公牛和公山羊的血既帶入聖所贖罪，這牛羊就要搬到營外，將皮、肉、糞用火焚燒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","焚燒的人要洗衣服，用水洗身，然後進營。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","「每逢七月初十日，你們要刻苦己心，無論是本地人，是寄居在你們中間的外人，甚麼工都不可做；這要作你們永遠的定例。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","因在這日要為你們贖罪，使你們潔淨。你們要在耶和華面前得以潔淨，脫盡一切的罪愆。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","這日你們要守為聖安息日，要刻苦己心；這為永遠的定例。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","那受膏、接續他父親承接聖職的祭司要穿上細麻布的聖衣，行贖罪之禮。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","他要在至聖所和會幕與壇行贖罪之禮，並要為眾祭司和會眾的百姓贖罪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","這要作你們永遠的定例－就是因以色列人一切的罪，要一年一次為他們贖罪。」 於是，亞倫照耶和華所吩咐摩西的行了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","耶和華對摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","「你曉諭亞倫和他兒子並以色列眾人說，耶和華所吩咐的乃是這樣： ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","凡以色列家中的人宰公牛，或是綿羊羔，或是山羊，不拘宰於營內營外， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","若未曾牽到會幕門口、耶和華的帳幕前獻給耶和華為供物，流血的罪必歸到那人身上。他流了血，要從民中剪除。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","這是為要使以色列人把他們在田野裏所獻的祭帶到會幕門口、耶和華面前，交給祭司，獻與耶和華為平安祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","祭司要把血灑在會幕門口、耶和華的壇上，把脂油焚燒，獻給耶和華為馨香的祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","他們不可再獻祭給他們行邪淫所隨從的鬼魔；這要作他們世世代代永遠的定例。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","「你要曉諭他們說：凡以色列家中的人，或是寄居在他們中間的外人，獻燔祭或是平安祭， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","若不帶到會幕門口獻給耶和華，那人必從民中剪除。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","「凡以色列家中的人，或是寄居在他們中間的外人，若吃甚麼血，我必向那吃血的人變臉，把他從民中剪除。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","因為活物的生命是在血中。我把這血賜給你們，可以在壇上為你們的生命贖罪；因血裏有生命，所以能贖罪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","因此，我對以色列人說：你們都不可吃血；寄居在你們中間的外人也不可吃血。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","凡以色列人，或是寄居在他們中間的外人，若打獵得了可吃的禽獸，必放出牠的血來，用土掩蓋。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","「論到一切活物的生命，就在血中。所以我對以色列人說：無論甚麼活物的血，你們都不可吃，因為一切活物的血就是他的生命。凡吃了血的，必被剪除。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","凡吃自死的，或是被野獸撕裂的，無論是本地人，是寄居的，必不潔淨到晚上，都要洗衣服，用水洗身，到了晚上才為潔淨。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","但他若不洗衣服，也不洗身，就必擔當他的罪孽。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","耶和華對摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","「你曉諭以色列人說：我是耶和華－你們的上帝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","你們從前住的埃及地，那裏人的行為，你們不可效法，我要領你們到的迦南地，那裏人的行為也不可效法，也不可照他們的惡俗行。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","你們要遵我的典章，守我的律例，按此而行。我是耶和華－你們的上帝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","所以，你們要守我的律例典章；人若遵行，就必因此活着。我是耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","「你們都不可露骨肉之親的下體，親近他們。我是耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","不可露你母親的下體，羞辱了你父親。她是你的母親，不可露她的下體。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","不可露你繼母的下體；這本是你父親的下體。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","你的姊妹，不拘是異母同父的，是異父同母的，無論是生在家生在外的，都不可露她們的下體。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","不可露你孫女或是外孫女的下體，露了她們的下體就是露了自己的下體。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","你繼母從你父親生的女兒本是你的妹妹，不可露她的下體。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","不可露你姑母的下體；她是你父親的骨肉之親。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","不可露你姨母的下體；她是你母親的骨肉之親。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","不可親近你伯叔之妻，羞辱了你伯叔；她是你的伯叔母。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","不可露你兒婦的下體；她是你兒子的妻，不可露她的下體。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","不可露你弟兄妻子的下體；這本是你弟兄的下體。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","不可露了婦人的下體，又露她女兒的下體，也不可娶她孫女或是外孫女，露她們的下體；她們是骨肉之親，這本是大惡。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","你妻還在的時候，不可另娶她的姊妹作對頭，露她的下體。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","「女人行經不潔淨的時候，不可露她的下體，與她親近。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","不可與鄰舍的妻行淫，玷污自己。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","不可使你的兒女經火歸與摩洛，也不可褻瀆你上帝的名。我是耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","不可與男人苟合，像與女人一樣；這本是可憎惡的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","不可與獸淫合，玷污自己。女人也不可站在獸前，與牠淫合；這本是逆性的事。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","「在這一切的事上，你們都不可玷污自己；因為我在你們面前所逐出的列邦，在這一切的事上玷污了自己； ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","連地也玷污了，所以我追討那地的罪孽，那地也吐出它的居民。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","故此，你們要守我的律例典章。這一切可憎惡的事，無論是本地人，是寄居在你們中間的外人，都不可行，（ ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","在你們以先居住那地的人行了這一切可憎惡的事，地就玷污了，） ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","免得你們玷污那地的時候，地就把你們吐出，像吐出在你們以先的國民一樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","無論甚麼人，行了其中可憎的一件事，必從民中剪除。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","所以，你們要守我所吩咐的，免得你們隨從那些可憎的惡俗，就是在你們以先的人所常行的，以致玷污了自己。我是耶和華－你們的上帝。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","耶和華對摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","「你曉諭以色列全會眾說：你們要聖潔，因為我耶和華－你們的上帝是聖潔的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","你們各人都當孝敬父母，也要守我的安息日。我是耶和華－你們的上帝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","你們不可偏向虛無的神，也不可為自己鑄造神像。我是耶和華－你們的上帝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","你們獻平安祭給耶和華的時候，要獻得可蒙悅納。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","這祭物要在獻的那一天和第二天吃，若有剩到第三天的，就必用火焚燒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","第三天若再吃，這就為可憎惡的，必不蒙悅納。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","凡吃的人必擔當他的罪孽；因為他褻瀆了耶和華的聖物，那人必從民中剪除。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","「在你們的地收割莊稼，不可割盡田角，也不可拾取所遺落的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","不可摘盡葡萄園的果子，也不可拾取葡萄園所掉的果子；要留給窮人和寄居的。我是耶和華－你們的上帝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","「你們不可偷盜，不可欺騙，也不可彼此說謊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","不可指着我的名起假誓，褻瀆你上帝的名。我是耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","「不可欺壓你的鄰舍，也不可搶奪他的物。雇工人的工價，不可在你那裏過夜，留到早晨。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","不可咒罵聾子，也不可將絆腳石放在瞎子面前，只要敬畏你的上帝。我是耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","「你們施行審判，不可行不義；不可偏護窮人，也不可重看有勢力的人，只要按着公義審判你的鄰舍。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","不可在民中往來搬弄是非，也不可與鄰舍為敵，置之於死。我是耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","「不可心裏恨你的弟兄；總要指摘你的鄰舍，免得因他擔罪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","不可報仇，也不可埋怨你本國的子民，卻要愛人如己。我是耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","「你們要守我的律例。不可叫你的牲畜與異類配合；不可用兩樣攙雜的種種你的地，也不可用兩樣攙雜的料做衣服穿在身上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","「婢女許配了丈夫，還沒有被贖、得釋放，人若與她行淫，二人要受刑罰，卻不把他們治死，因為婢女還沒有得自由。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","那人要把贖愆祭，就是一隻公綿羊牽到會幕門口、耶和華面前。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","祭司要用贖愆祭的羊在耶和華面前贖他所犯的罪，他的罪就必蒙赦免。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","「你們到了迦南地，栽種各樣結果子的樹木，就要以所結的果子如未受割禮的一樣。三年之久，你們要以這些果子，如未受割禮的，是不可吃的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","但第四年所結的果子全要成為聖，用以讚美耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","第五年，你們要吃那樹上的果子，好叫樹給你們結果子更多。我是耶和華－你們的上帝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","「你們不可吃帶血的物；不可用法術，也不可觀兆。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","頭的周圍不可剃，鬍鬚的周圍也不可損壞。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","不可為死人用刀劃身，也不可在身上刺花紋。我是耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","「不可辱沒你的女兒，使她為娼妓，恐怕地上的人專向淫亂，地就滿了大惡。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","你們要守我的安息日，敬我的聖所。我是耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","「不可偏向那些交鬼的和行巫術的；不可求問他們，以致被他們玷污了。我是耶和華－你們的上帝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","「在白髮的人面前，你要站起來；也要尊敬老人，又要敬畏你的上帝。我是耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","「若有外人在你們國中和你同居，就不可欺負他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","和你們同居的外人，你們要看他如本地人一樣，並要愛他如己，因為你們在埃及地也作過寄居的。我是耶和華－你們的上帝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","「你們施行審判，不可行不義；在尺、秤、升、斗上也是如此。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","要用公道天平、公道法碼、公道升斗、公道秤。我是耶和華－你們的上帝，曾把你們從埃及地領出來的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","你們要謹守遵行我一切的律例典章。我是耶和華。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","耶和華對摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","「你還要曉諭以色列人說：凡以色列人，或是在以色列中寄居的外人，把自己的兒女獻給摩洛的，總要治死他；本地人要用石頭把他打死。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","我也要向那人變臉，把他從民中剪除；因為他把兒女獻給摩洛，玷污我的聖所，褻瀆我的聖名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","那人把兒女獻給摩洛，本地人若佯為不見，不把他治死， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","我就要向這人和他的家變臉，把他和一切隨他與摩洛行邪淫的人都從民中剪除。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","「人偏向交鬼的和行巫術的，隨他們行邪淫，我要向那人變臉，把他從民中剪除。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","所以你們要自潔成聖，因為我是耶和華－你們的上帝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","你們要謹守遵行我的律例；我是叫你們成聖的耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","凡咒罵父母的，總要治死他；他咒罵了父母，他的罪要歸到他身上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","「與鄰舍之妻行淫的，姦夫淫婦都必治死。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","與繼母行淫的，就是羞辱了他父親，總要把他們二人治死，罪要歸到他們身上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","與兒婦同房的，總要把他們二人治死；他們行了逆倫的事，罪要歸到他們身上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","人若與男人苟合，像與女人一樣，他們二人行了可憎的事，總要把他們治死，罪要歸到他們身上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","人若娶妻，並娶其母，便是大惡，要把這三人用火焚燒，使你們中間免去大惡。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","人若與獸淫合，總要治死他，也要殺那獸。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","女人若與獸親近，與牠淫合，你要殺那女人和那獸，總要把他們治死，罪要歸到他們身上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","「人若娶他的姊妹，無論是異母同父的，是異父同母的，彼此見了下體，這是可恥的事；他們必在本民的眼前被剪除。他露了姊妹的下體，必擔當自己的罪孽。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","婦人有月經，若與她同房，露了她的下體，就是露了婦人的血源，婦人也露了自己的血源，二人必從民中剪除。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","不可露姨母或是姑母的下體，這是露了骨肉之親的下體；二人必擔當自己的罪孽。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","人若與伯叔之妻同房，就羞辱了他的伯叔；二人要擔當自己的罪，必無子女而死。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","人若娶弟兄之妻，這本是污穢的事，羞辱了他的弟兄；二人必無子女。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","「所以，你們要謹守遵行我一切的律例典章，免得我領你們去住的那地把你們吐出。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","我在你們面前所逐出的國民，你們不可隨從他們的風俗；因為他們行了這一切的事，所以我厭惡他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","但我對你們說過，你們要承受他們的地，就是我要賜給你們為業、流奶與蜜之地。我是耶和華－你們的上帝，使你們與萬民有分別的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","所以，你們要把潔淨和不潔淨的禽獸分別出來；不可因我給你們分為不潔淨的禽獸，或是滋生在地上的活物，使自己成為可憎惡的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","你們要歸我為聖，因為我－耶和華是聖的，並叫你們與萬民有分別，使你們作我的民。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","「無論男女，是交鬼的或行巫術的，總要治死他們。人必用石頭把他們打死，罪要歸到他們身上。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","耶和華對摩西說：「你告訴亞倫子孫作祭司的說：祭司不可為民中的死人沾染自己， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","除非為他骨肉之親的父母、兒女、弟兄， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","和未曾出嫁、作處女的姊妹，才可以沾染自己。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","祭司既在民中為首，就不可從俗沾染自己。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","不可使頭光禿；不可剃除鬍鬚的周圍，也不可用刀劃身。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","要歸上帝為聖，不可褻瀆上帝的名；因為耶和華的火祭，就是上帝的食物，是他們獻的，所以他們要成為聖。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","不可娶妓女或被污的女人為妻，也不可娶被休的婦人為妻，因為祭司是歸上帝為聖。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","所以你要使他成聖，因為他奉獻你上帝的食物；你要以他為聖，因為我－使你們成聖的耶和華－是聖的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","祭司的女兒若行淫辱沒自己，就辱沒了父親，必用火將她焚燒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","「在弟兄中作大祭司、頭上倒了膏油、又承接聖職、穿了聖衣的，不可蓬頭散髮，也不可撕裂衣服。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","不可挨近死屍，也不可為父母沾染自己。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","不可出聖所，也不可褻瀆上帝的聖所，因為上帝膏油的冠冕在他頭上。我是耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","他要娶處女為妻。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","寡婦或是被休的婦人，或是被污為妓的女人，都不可娶；只可娶本民中的處女為妻。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","不可在民中辱沒他的兒女，因為我是叫他成聖的耶和華。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","耶和華對摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","「你告訴亞倫說：你世世代代的後裔，凡有殘疾的，都不可近前來獻他上帝的食物。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","因為凡有殘疾的，無論是瞎眼的、瘸腿的、塌鼻子的、肢體有餘的、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","折腳折手的、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","駝背的、矮矬的、眼睛有毛病的、長癬的、長疥的，或是損壞腎子的，都不可近前來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","祭司亞倫的後裔，凡有殘疾的，都不可近前來，將火祭獻給耶和華。他有殘疾，不可近前來獻上帝的食物。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","上帝的食物，無論是聖的，至聖的，他都可以吃。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","但不可進到幔子前，也不可就近壇前；因為他有殘疾，免得褻瀆我的聖所。我是叫他成聖的耶和華。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","於是，摩西曉諭亞倫和亞倫的子孫，並以色列眾人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","耶和華對摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","「你吩咐亞倫和他子孫說：要遠離以色列人所分別為聖、歸給我的聖物，免得褻瀆我的聖名。我是耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","你要對他們說：你們世世代代的後裔，凡身上有污穢、親近以色列人所分別為聖、歸耶和華聖物的，那人必在我面前剪除。我是耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","亞倫的後裔，凡長大痲瘋的，或是有漏症的，不可吃聖物，直等他潔淨了。無論誰摸那因死屍不潔淨的物，或是遺精的人， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","或是摸甚麼使他不潔淨的爬物，或是摸那使他不潔淨的人（不拘那人有甚麼不潔淨）， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","摸了這些人、物的，必不潔淨到晚上；若不用水洗身，就不可吃聖物。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","日落的時候，他就潔淨了，然後可以吃聖物，因為這是他的食物。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","自死的或是被野獸撕裂的，他不可吃，因此污穢自己。我是耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","所以他們要守我所吩咐的，免得輕忽了，因此擔罪而死。我是叫他們成聖的耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","「凡外人不可吃聖物；寄居在祭司家的，或是雇工人，都不可吃聖物； ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","倘若祭司買人，是他的錢買的，那人就可以吃聖物；生在他家的人也可以吃。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","祭司的女兒若嫁外人，就不可吃舉祭的聖物。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","但祭司的女兒若是寡婦，或是被休的，沒有孩子，又歸回父家，與她青年一樣，就可以吃她父親的食物；只是外人不可吃。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","若有人誤吃了聖物，要照聖物的原數加上五分之一交給祭司。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","祭司不可褻瀆以色列人所獻給耶和華的聖物， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","免得他們在吃聖物上自取罪孽，因為我是叫他們成聖的耶和華。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","耶和華對摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","「你曉諭亞倫和他子孫，並以色列眾人說：以色列家中的人，或在以色列中寄居的，凡獻供物，無論是所許的願，是甘心獻的，就是獻給耶和華作燔祭的， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","要將沒有殘疾的公牛，或是綿羊，或是山羊獻上，如此方蒙悅納。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","凡有殘疾的，你們不可獻上，因為這不蒙悅納。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","凡從牛群或是羊群中，將平安祭獻給耶和華，為要還特許的願，或是作甘心獻的，所獻的必純全無殘疾的才蒙悅納。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","瞎眼的、折傷的、殘廢的、有瘤子的、長癬的、長疥的都不可獻給耶和華，也不可在壇上作為火祭獻給耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","無論是公牛是綿羊羔，若肢體有餘的，或是缺少的，只可作甘心祭獻上；用以還願，卻不蒙悅納。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","腎子損傷的，或是壓碎的，或是破裂的，或是騸了的，不可獻給耶和華，在你們的地上也不可這樣行。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","這類的物，你們從外人的手，一樣也不可接受作你們上帝的食物獻上；因為這些都有損壞，有殘疾，不蒙悅納。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","耶和華曉諭摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","「才生的公牛，或是綿羊或是山羊，七天當跟着母；從第八天以後，可以當供物蒙悅納，作為耶和華的火祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","無論是母牛是母羊，不可同日宰母和子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","你們獻感謝祭給耶和華，要獻得可蒙悅納。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","要當天吃，一點不可留到早晨。我是耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","「你們要謹守遵行我的誡命。我是耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","你們不可褻瀆我的聖名；我在以色列人中，卻要被尊為聖。我是叫你們成聖的耶和華， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","把你們從埃及地領出來，作你們的上帝。我是耶和華。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","耶和華對摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","「你曉諭以色列人說：耶和華的節期，你們要宣告為聖會的節期。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","六日要做工，第七日是聖安息日，當有聖會；你們甚麼工都不可做。這是在你們一切的住處向耶和華守的安息日。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","耶和華的節期，就是你們到了日期要宣告為聖會的，乃是這些。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","「正月十四日，黃昏的時候，是耶和華的逾越節。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","這月十五日是向耶和華守的無酵節；你們要吃無酵餅七日。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","第一日當有聖會，甚麼勞碌的工都不可做； ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","要將火祭獻給耶和華七日。第七日是聖會，甚麼勞碌的工都不可做。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","耶和華對摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","「你曉諭以色列人說：你們到了我賜給你們的地，收割莊稼的時候，要將初熟的莊稼一捆帶給祭司。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","他要把這一捆在耶和華面前搖一搖，使你們得蒙悅納。祭司要在安息日的次日把這捆搖一搖。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","搖這捆的日子，你們要把一歲、沒有殘疾的公綿羊羔獻給耶和華為燔祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","同獻的素祭，就是調油的細麵伊法十分之二，作為馨香的火祭，獻給耶和華。同獻的奠祭，要酒一欣四分之一。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","無論是餅，是烘的子粒，是新穗子，你們都不可吃，直等到把你們獻給上帝的供物帶來的那一天才可以吃。這在你們一切的住處作為世世代代永遠的定例。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","「你們要從安息日的次日，獻禾捆為搖祭的那日算起，要滿了七個安息日。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","到第七個安息日的次日，共計五十天，又要將新素祭獻給耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","要從你們的住處取出細麵伊法十分之二，加酵，烤成兩個搖祭的餅，當作初熟之物獻給耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","又要將一歲、沒有殘疾的羊羔七隻、公牛犢一隻、公綿羊兩隻，和餅一同奉上。這些與同獻的素祭和奠祭要作為燔祭獻給耶和華，就是作馨香的火祭獻給耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","你們要獻一隻公山羊為贖罪祭，兩隻一歲的公綿羊羔為平安祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","祭司要把這些和初熟麥子做的餅一同作搖祭，在耶和華面前搖一搖；這是獻與耶和華為聖物歸給祭司的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","當這日，你們要宣告聖會；甚麼勞碌的工都不可做。這在你們一切的住處作為世世代代永遠的定例。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","「在你們的地收割莊稼，不可割盡田角，也不可拾取所遺落的；要留給窮人和寄居的。我是耶和華－你們的上帝。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","耶和華對摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","「你曉諭以色列人說：七月初一，你們要守為聖安息日，要吹角作紀念，當有聖會。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","甚麼勞碌的工都不可做；要將火祭獻給耶和華。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","耶和華曉諭摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","「七月初十是贖罪日；你們要守為聖會，並要刻苦己心，也要將火祭獻給耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","當這日，甚麼工都不可做；因為是贖罪日，要在耶和華－你們的上帝面前贖罪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","當這日，凡不刻苦己心的，必從民中剪除。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","凡這日做甚麼工的，我必將他從民中除滅。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","你們甚麼工都不可做。這在你們一切的住處作為世世代代永遠的定例。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","你們要守這日為聖安息日，並要刻苦己心。從這月初九日晚上到次日晚上，要守為安息日。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","耶和華對摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","「你曉諭以色列人說：這七月十五日是住棚節，要在耶和華面前守這節七日。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","第一日當有聖會，甚麼勞碌的工都不可做。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","七日內要將火祭獻給耶和華。第八日當守聖會，要將火祭獻給耶和華。這是嚴肅會，甚麼勞碌的工都不可做。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","「這是耶和華的節期，就是你們要宣告為聖會的節期；要將火祭、燔祭、素祭、祭物，並奠祭，各歸各日，獻給耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","這是在耶和華的安息日以外，又在你們的供物和所許的願，並甘心獻給耶和華的以外。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","「你們收藏了地的出產，就從七月十五日起，要守耶和華的節七日。第一日為聖安息；第八日也為聖安息。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","第一日要拿美好樹上的果子和棕樹上的枝子，與茂密樹的枝條並河旁的柳枝，在耶和華－你們的上帝面前歡樂七日。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","每年七月間，要向耶和華守這節七日。這為你們世世代代永遠的定例。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","你們要住在棚裏七日；凡以色列家的人都要住在棚裏， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","好叫你們世世代代知道，我領以色列人出埃及地的時候曾使他們住在棚裏。我是耶和華－你們的上帝。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","於是，摩西將耶和華的節期傳給以色列人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","耶和華曉諭摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","「要吩咐以色列人，把那為點燈搗成的清橄欖油拿來給你，使燈常常點着。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","在會幕中法櫃的幔子外，亞倫從晚上到早晨必在耶和華面前經理這燈。這要作你們世世代代永遠的定例。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","他要在耶和華面前常收拾精金燈臺上的燈。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","「你要取細麵，烤成十二個餅，每餅用麵伊法十分之二。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","要把餅擺列兩行，每行六個，在耶和華面前精金的桌子上； ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","又要把淨乳香放在每行餅上，作為紀念，就是作為火祭獻給耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","每安息日要常擺在耶和華面前；這為以色列人作永遠的約。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","這餅是要給亞倫和他子孫的；他們要在聖處吃，為永遠的定例，因為在獻給耶和華的火祭中是至聖的。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","有一個以色列婦人的兒子，他父親是埃及人，一日閒遊在以色列人中。這以色列婦人的兒子和一個以色列人在營裏爭鬥。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","這以色列婦人的兒子褻瀆了聖名，並且咒詛，就有人把他送到摩西那裏。（他母親名叫示羅密，是但支派底伯利的女兒。） ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","他們把那人收在監裏，要得耶和華所指示的話。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","耶和華曉諭摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","「把那咒詛聖名的人帶到營外。叫聽見的人都放手在他頭上；全會眾就要用石頭打死他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","你要曉諭以色列人說：凡咒詛上帝的，必擔當他的罪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","那褻瀆耶和華名的，必被治死；全會眾總要用石頭打死他。不管是寄居的是本地人，他褻瀆耶和華名的時候，必被治死。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","打死人的，必被治死； ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","打死牲畜的，必賠上牲畜，以命償命。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","人若使他鄰舍的身體有殘疾，他怎樣行，也要照樣向他行： ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","以傷還傷，以眼還眼，以牙還牙。他怎樣叫人的身體有殘疾，也要照樣向他行。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","打死牲畜的，必賠上牲畜；打死人的，必被治死。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","不管是寄居的是本地人，同歸一例。我是耶和華－你們的上帝。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","於是，摩西曉諭以色列人，他們就把那咒詛聖名的人帶到營外，用石頭打死。以色列人就照耶和華所吩咐摩西的行了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","耶和華在西奈山對摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","「你曉諭以色列人說：你們到了我所賜你們那地的時候，地就要向耶和華守安息。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","六年要耕種田地，也要修理葡萄園，收藏地的出產。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","第七年，地要守聖安息，就是向耶和華守的安息，不可耕種田地，也不可修理葡萄園。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","遺落自長的莊稼不可收割；沒有修理的葡萄樹也不可摘取葡萄。這年，地要守聖安息。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","地在安息年所出的，要給你和你的僕人、婢女、雇工人，並寄居的外人當食物。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","這年的土產也要給你的牲畜和你地上的走獸當食物。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","「你要計算七個安息年，就是七七年。這便為你成了七個安息年，共是四十九年。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","當年七月初十日，你要大發角聲；這日就是贖罪日，要在遍地發出角聲。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","第五十年，你們要當作聖年，在遍地給一切的居民宣告自由。這年必為你們的禧年，各人要歸自己的產業，各歸本家。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","第五十年要作為你們的禧年。這年不可耕種；地中自長的，不可收割；沒有修理的葡萄樹也不可摘取葡萄。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","因為這是禧年，你們要當作聖年，吃地中自出的土產。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","「這禧年，你們各人要歸自己的地業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","你若賣甚麼給鄰舍，或是從鄰舍的手中買甚麼，彼此不可虧負。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","你要按禧年以後的年數向鄰舍買；他也要按年數的收成賣給你。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","年歲若多，要照數加添價值；年歲若少，要照數減去價值，因為他照收成的數目賣給你。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","你們彼此不可虧負，只要敬畏你們的上帝，因為我是耶和華－你們的上帝。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","「我的律例，你們要遵行，我的典章，你們要謹守，就可以在那地上安然居住。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","地必出土產，你們就要吃飽，在那地上安然居住。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","你們若說：『這第七年我們不耕種，也不收藏土產，吃甚麼呢？』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","我必在第六年將我所命的福賜給你們，地便生三年的土產。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","第八年，你們要耕種，也要吃陳糧，等到第九年出產收來的時候，你們還吃陳糧。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","「地不可永賣，因為地是我的；你們在我面前是客旅，是寄居的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","在你們所得為業的全地，也要准人將地贖回。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","你的弟兄若漸漸窮乏，賣了幾分地業，他至近的親屬就要來把弟兄所賣的贖回。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","若沒有能給他贖回的，他自己漸漸富足，能夠贖回， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","就要算出賣地的年數，把餘剩年數的價值還那買主，自己便歸回自己的地業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","倘若不能為自己得回所賣的，仍要存在買主的手裏直到禧年；到了禧年，地業要出買主的手，自己便歸回自己的地業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","「人若賣城內的住宅，賣了以後，一年之內可以贖回；在一整年，必有贖回的權柄。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","若在一整年之內不贖回，這城內的房屋就定准永歸買主，世世代代為業；在禧年也不得出買主的手。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","但房屋在無城牆的村莊裏，要看如鄉下的田地一樣，可以贖回；到了禧年，都要出買主的手。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","然而利未人所得為業的城邑，其中的房屋，利未人可以隨時贖回。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","若是一個利未人不將所賣的房屋贖回，是在所得為業的城內，到了禧年就要出買主的手，因為利未人城邑的房屋是他們在以色列人中的產業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","只是他們各城郊野之地不可賣，因為是他們永遠的產業。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","「你的弟兄在你那裏若漸漸貧窮，手中缺乏，你就要幫補他，使他與你同住，像外人和寄居的一樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","不可向他取利，也不可向他多要；只要敬畏你的上帝，使你的弟兄與你同住。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","你借錢給他，不可向他取利；借糧給他，也不可向他多要。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","我是耶和華－你們的上帝，曾領你們從埃及地出來，為要把迦南地賜給你們，要作你們的上帝。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","「你的弟兄若在你那裏漸漸窮乏，將自己賣給你，不可叫他像奴僕服事你。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","他要在你那裏像雇工人和寄居的一樣，要服事你直到禧年。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","到了禧年，他和他兒女要離開你，一同出去歸回本家，到他祖宗的地業那裏去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","因為他們是我的僕人，是我從埃及地領出來的，不可賣為奴僕。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","不可嚴嚴地轄管他，只要敬畏你的上帝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","至於你的奴僕、婢女，可以從你四圍的國中買。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","並且那寄居在你們中間的外人和他們的家屬，在你們地上所生的，你們也可以從其中買人；他們要作你們的產業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","你們要將他們遺留給你們的子孫為產業，要永遠從他們中間揀出奴僕；只是你們的弟兄以色列人，你們不可嚴嚴地轄管。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","「住在你那裏的外人，或是寄居的，若漸漸富足，你的弟兄卻漸漸窮乏，將自己賣給那外人，或是寄居的，或是外人的宗族， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","賣了以後，可以將他贖回。無論是他的弟兄， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","或伯叔、伯叔的兒子，本家的近支，都可以贖他。他自己若漸漸富足，也可以自贖。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","他要和買主計算，從賣自己的那年起，算到禧年；所賣的價值照着年數多少，好像工人每年的工價。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","若缺少的年數多，就要按着年數從買價中償還他的贖價。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","若到禧年只缺少幾年，就要按着年數和買主計算，償還他的贖價。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","他和買主同住，要像每年雇的工人，買主不可嚴嚴地轄管他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","他若不這樣被贖，到了禧年，要和他的兒女一同出去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","因為以色列人都是我的僕人，是我從埃及地領出來的。我是耶和華－你們的上帝。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","「你們不可做甚麼虛無的神像，不可立雕刻的偶像或是柱像，也不可在你們的地上安甚麼鏨成的石像，向它跪拜，因為我是耶和華－你們的上帝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","你們要守我的安息日，敬我的聖所。我是耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","「你們若遵行我的律例，謹守我的誡命， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","我就給你們降下時雨，叫地生出土產，田野的樹木結果子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","你們打糧食要打到摘葡萄的時候，摘葡萄要摘到撒種的時候；並且要吃得飽足，在你們的地上安然居住。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","我要賜平安在你們的地上；你們躺臥，無人驚嚇。我要叫惡獸從你們的地上熄滅；刀劍也必不經過你們的地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","你們要追趕仇敵，他們必倒在你們刀下。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","你們五個人要追趕一百人，一百人要追趕一萬人；仇敵必倒在你們刀下。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","我要眷顧你們，使你們生養眾多，也要與你們堅定所立的約。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","你們要吃陳糧，又因新糧挪開陳糧。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","我要在你們中間立我的帳幕；我的心也不厭惡你們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","我要在你們中間行走；我要作你們的上帝，你們要作我的子民。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","我是耶和華－你們的上帝，曾將你們從埃及地領出來，使你們不作埃及人的奴僕；我也折斷你們所負的軛，叫你們挺身而走。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","「你們若不聽從我，不遵行我的誡命， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","厭棄我的律例，厭惡我的典章，不遵行我一切的誡命，背棄我的約， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","我待你們就要這樣：我必命定驚惶，叫眼目乾癟、精神消耗的癆病熱病轄制你們。你們也要白白地撒種，因為仇敵要吃你們所種的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","我要向你們變臉，你們就要敗在仇敵面前。恨惡你們的，必轄管你們；無人追趕，你們卻要逃跑。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","你們因這些事若還不聽從我，我就要為你們的罪加七倍懲罰你們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","我必斷絕你們因勢力而有的驕傲，又要使覆你們的天如鐵，載你們的地如銅。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","你們要白白地勞力；因為你們的地不出土產，其上的樹木也不結果子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","「你們行事若與我反對，不肯聽從我，我就要按你們的罪加七倍降災與你們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","我也要打發野地的走獸到你們中間，搶吃你們的兒女，吞滅你們的牲畜，使你們的人數減少，道路荒涼。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","「你們因這些事若仍不改正歸我，行事與我反對， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","我就要行事與你們反對，因你們的罪擊打你們七次。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","我又要使刀劍臨到你們，報復你們背約的仇；聚集你們在各城內，降瘟疫在你們中間，也必將你們交在仇敵的手中。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","我要折斷你們的杖，就是斷絕你們的糧。那時，必有十個女人在一個爐子給你們烤餅，按分量秤給你們；你們要吃，也吃不飽。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","「你們因這一切的事若不聽從我，卻行事與我反對， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","我就要發烈怒，行事與你們反對，又因你們的罪懲罰你們七次。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","並且你們要吃兒子的肉，也要吃女兒的肉。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","我又要毀壞你們的邱壇，砍下你們的日像，把你們的屍首扔在你們偶像的身上；我的心也必厭惡你們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","我要使你們的城邑變為荒涼，使你們的眾聖所成為荒場；我也不聞你們馨香的香氣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","我要使地成為荒場，住在其上的仇敵就因此詫異。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","我要把你們散在列邦中；我也要拔刀追趕你們。你們的地要成為荒場；你們的城邑要變為荒涼。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","「你們在仇敵之地居住的時候，你們的地荒涼，要享受眾安息；正在那時候，地要歇息，享受安息。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","地多時為荒場，就要多時歇息；地這樣歇息，是你們住在其上的安息年所不能得的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","至於你們剩下的人，我要使他們在仇敵之地心驚膽怯。葉子被風吹的響聲，要追趕他們；他們要逃避，像人逃避刀劍，無人追趕，卻要跌倒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","無人追趕，他們要彼此撞跌，像在刀劍之前。你們在仇敵面前也必站立不住。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","你們要在列邦中滅亡；仇敵之地要吞吃你們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","你們剩下的人必因自己的罪孽和祖宗的罪孽在仇敵之地消滅。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","「他們要承認自己的罪和他們祖宗的罪，就是干犯我的那罪，並且承認自己行事與我反對， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","我所以行事與他們反對，把他們帶到仇敵之地。那時，他們未受割禮的心若謙卑了，他們也服了罪孽的刑罰， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","我就要記念我與雅各所立的約，與以撒所立的約，與亞伯拉罕所立的約，並要記念這地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","他們離開這地，地在荒廢無人的時候就要享受安息。並且他們要服罪孽的刑罰；因為他們厭棄了我的典章，心中厭惡了我的律例。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","雖是這樣，他們在仇敵之地，我卻不厭棄他們，也不厭惡他們，將他們盡行滅絕，也不背棄我與他們所立的約，因為我是耶和華－他們的上帝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","我卻要為他們的緣故記念我與他們先祖所立的約。他們的先祖是我在列邦人眼前、從埃及地領出來的，為要作他們的上帝。我是耶和華。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","這些律例、典章，和法度是耶和華與以色列人在西奈山藉着摩西立的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","耶和華對摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","「你曉諭以色列人說：人還特許的願，被許的人要按你所估的價值歸給耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","你估定的，從二十歲到六十歲的男人，要按聖所的平，估定價銀五十舍客勒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","若是女人，你要估定三十舍客勒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","若是從五歲到二十歲，男子你要估定二十舍客勒，女子估定十舍客勒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","若是從一月到五歲，男子你要估定五舍客勒，女子估定三舍客勒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","若是從六十歲以上，男人你要估定十五舍客勒，女人估定十舍客勒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","他若貧窮，不能照你所估定的價，就要把他帶到祭司面前，祭司要按許願人的力量估定他的價。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","「所許的若是牲畜，就是人獻給耶和華為供物的，凡這一類獻給耶和華的，都要成為聖。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","人不可改換，也不可更換，或是好的換壞的，或是壞的換好的。若以牲畜更換牲畜，所許的與所換的都要成為聖。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","若牲畜不潔淨，是不可獻給耶和華為供物的，就要把牲畜安置在祭司面前。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","祭司就要估定價值；牲畜是好是壞，祭司怎樣估定，就要以怎樣為是。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","他若一定要贖回，就要在你所估定的價值以外加上五分之一。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","「人將房屋分別為聖，歸給耶和華，祭司就要估定價值。房屋是好是壞，祭司怎樣估定，就要以怎樣為定。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","將房屋分別為聖的人，若要贖回房屋，就必在你所估定的價值以外加上五分之一，房屋仍舊歸他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","「人若將承受為業的幾分地分別為聖，歸給耶和華，你要按這地撒種多少估定價值，若撒大麥一賀梅珥，要估價五十舍客勒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","他若從禧年將地分別為聖，就要以你所估定的價為定。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","倘若他在禧年以後將地分別為聖，祭司就要按着未到禧年所剩的年數推算價值，也要從你所估的減去價值。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","將地分別為聖的人若定要把地贖回，他便要在你所估的價值以外加上五分之一，地就准定歸他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","他若不贖回那地，或是將地賣給別人，就再不能贖了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","但到了禧年，那地從買主手下出來的時候，就要歸耶和華為聖，和永獻的地一樣，要歸祭司為業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","他若將所買的一塊地，不是承受為業的，分別為聖歸給耶和華， ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","祭司就要將你所估的價值給他推算到禧年。當日，他要以你所估的價銀為聖，歸給耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","到了禧年，那地要歸賣主，就是那承受為業的原主。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","凡你所估定的價銀都要按着聖所的平：二十季拉為一舍客勒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","「惟獨牲畜中頭生的，無論是牛是羊，既歸耶和華，誰也不可再分別為聖，因為這是耶和華的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","若是不潔淨的牲畜生的，就要按你所估定的價值加上五分之一贖回；若不贖回，就要按你所估定的價值賣了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","「但一切永獻的，就是人從他所有永獻給耶和華的，無論是人，是牲畜，是他承受為業的地，都不可賣，也不可贖。凡永獻的是歸給耶和華為至聖。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","凡從人中當滅的都不可贖，必被治死。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","「地上所有的，無論是地上的種子是樹上的果子，十分之一是耶和華的，是歸給耶和華為聖的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","人若要贖這十分之一的甚麼物，就要加上五分之一。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","凡牛群羊群中，一切從杖下經過的，每第十隻要歸給耶和華為聖。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","不可問是好是壞，也不可更換；若定要更換，所更換的與本來的牲畜都要成為聖，不可贖回。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","這就是耶和華在西奈山為以色列人所吩咐摩西的命令。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","以色列人出埃及地後，第二年二月初一日，耶和華在西奈的曠野、會幕中曉諭摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","「你要按以色列全會眾的家室、宗族、人名的數目計算所有的男丁。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","凡以色列中，從二十歲以外，能出去打仗的，你和亞倫要照他們的軍隊數點。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","每支派中必有一人作本支派的族長，幫助你們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","他們的名字：屬呂便的，有示丟珥的兒子以利蓿； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","屬西緬的，有蘇利沙代的兒子示路蔑； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","屬猶大的，有亞米拿達的兒子拿順； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","屬以薩迦的，有蘇押的兒子拿坦業； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","屬西布倫的，有希倫的兒子以利押； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","約瑟子孫、屬以法蓮的，有亞米忽的兒子以利沙瑪；屬瑪拿西的，有比大蓿的兒子迦瑪列； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","屬便雅憫的，有基多尼的兒子亞比但； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","屬但的，有亞米沙代的兒子亞希以謝； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","屬亞設的，有俄蘭的兒子帕結； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","屬迦得的，有丟珥的兒子以利雅薩； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","屬拿弗他利的，有以南的兒子亞希拉。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","這都是從會中選召的，各作本支派的首領，都是以色列軍中的統領。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","於是，摩西、亞倫帶着這些按名指定的人， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","當二月初一日招聚全會眾。會眾就照他們的家室、宗族、人名的數目，從二十歲以外的，都述說自己的家譜。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","耶和華怎樣吩咐摩西，他就怎樣在西奈的曠野數點他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","21","以色列的長子，呂便子孫的後代，照着家室、宗族、人名的數目，從二十歲以外，凡能出去打仗、被數的男丁，共有四萬六千五百名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","23","西緬子孫的後代，照着家室、宗族、人名的數目，從二十歲以外，凡能出去打仗、被數的男丁，共有五萬九千三百名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","25","迦得子孫的後代，照着家室、宗族、人名的數目，從二十歲以外，凡能出去打仗、被數的，共有四萬五千六百五十名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","27","猶大子孫的後代，照着家室、宗族、人名的數目，從二十歲以外，凡能出去打仗、被數的，共有七萬四千六百名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","29","以薩迦子孫的後代，照着家室、宗族、人名的數目，從二十歲以外，凡能出去打仗、被數的，共有五萬四千四百名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","31","西布倫子孫的後代，照着家室、宗族、人名的數目，從二十歲以外，凡能出去打仗、被數的，共有五萬七千四百名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","33","約瑟子孫屬以法蓮子孫的後代，照着家室、宗族、人名的數目，從二十歲以外，凡能出去打仗、被數的，共有四萬零五百名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","35","瑪拿西子孫的後代，照着家室、宗族、人名的數目，從二十歲以外，凡能出去打仗、被數的，共有三萬二千二百名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","37","便雅憫子孫的後代，照着家室、宗族、人名的數目，從二十歲以外，凡能出去打仗、被數的，共有三萬五千四百名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","39","但子孫的後代，照着家室、宗族、人名的數目，從二十歲以外，凡能出去打仗、被數的，共有六萬二千七百名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","41","亞設子孫的後代，照着家室、宗族、人名的數目，從二十歲以外，凡能出去打仗、被數的，共有四萬一千五百名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","43","拿弗他利子孫的後代，照着家室、宗族、人名的數目，從二十歲以外，凡能出去打仗、被數的，共有五萬三千四百名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","這些就是被數點的，是摩西、亞倫，和以色列中十二個首領所數點的；這十二個人各作各宗族的代表。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","46","這樣，凡以色列人中被數的，照着宗族，從二十歲以外，能出去打仗、被數的，共有六十萬零三千五百五十名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","利未人卻沒有按着支派數在其中， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","因為耶和華曉諭摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","「惟獨利未支派你不可數點，也不可在以色列人中計算他們的總數。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","只要派利未人管法櫃的帳幕和其中的器具，並屬乎帳幕的；他們要抬帳幕和其中的器具，並要辦理帳幕的事，在帳幕的四圍安營。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","帳幕將往前行的時候，利未人要拆卸；將支搭的時候，利未人要豎起。近前來的外人必被治死。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","以色列人支搭帳棚，要照他們的軍隊，各歸本營，各歸本纛。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","但利未人要在法櫃帳幕的四圍安營，免得忿怒臨到以色列會眾；利未人並要謹守法櫃的帳幕。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","以色列人就這樣行。凡耶和華所吩咐摩西的，他們就照樣行了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","耶和華曉諭摩西、亞倫說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","「以色列人要各歸自己的纛下，在本族的旗號那裏，對着會幕的四圍安營。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","在東邊，向日出之地，照着軍隊安營的是猶大營的纛。有亞米拿達的兒子拿順作猶大人的首領。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","他軍隊被數的，共有七萬四千六百名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","挨着他安營的是以薩迦支派。有蘇押的兒子拿坦業作以薩迦人的首領。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","他軍隊被數的，共有五萬四千四百名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","又有西布倫支派。希倫的兒子以利押作西布倫人的首領。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","他軍隊被數的，共有五萬七千四百名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","凡屬猶大營、按着軍隊被數的，共有十八萬六千四百名，要作第一隊往前行。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","「在南邊，按着軍隊是呂便營的纛。有示丟珥的兒子以利蓿作呂便人的首領。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","他軍隊被數的，共有四萬六千五百名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","挨着他安營的是西緬支派。蘇利沙代的兒子示路蔑作西緬人的首領。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","他軍隊被數的，共有五萬九千三百名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","又有迦得支派。丟珥的兒子以利雅薩作迦得人的首領。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","他軍隊被數的，共有四萬五千六百五十名， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","凡屬呂便營、按着軍隊被數的，共有十五萬一千四百五十名，要作第二隊往前行。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","「隨後，會幕要往前行，有利未營在諸營中間。他們怎樣安營就怎樣往前行，各按本位，各歸本纛。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","「在西邊，按着軍隊是以法蓮營的纛。亞米忽的兒子以利沙瑪作以法蓮人的首領。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","他軍隊被數的，共有四萬零五百名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","挨着他的是瑪拿西支派。比大蓿的兒子迦瑪列作瑪拿西人的首領。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","他軍隊被數的，共有三萬二千二百名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","又有便雅憫支派。基多尼的兒子亞比但作便雅憫人的首領。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","他軍隊被數的，共有三萬五千四百名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","凡屬以法蓮營、按着軍隊被數的，共有十萬零八千一百名，要作第三隊往前行。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","「在北邊，按着軍隊是但營的纛。亞米沙代的兒子亞希以謝作但人的首領。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","他軍隊被數的，共有六萬二千七百名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","挨着他安營的是亞設支派。俄蘭的兒子帕結作亞設人的首領。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","他軍隊被數的，共有四萬一千五百名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","又有拿弗他利支派。以南的兒子亞希拉作拿弗他利人的首領。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","他軍隊被數的，共有五萬三千四百名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","凡但營被數的，共有十五萬七千六百名，要歸本纛作末隊往前行。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","這些以色列人，照他們的宗族，按他們的軍隊，在諸營中被數的，共有六十萬零三千五百五十名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","惟獨利未人沒有數在以色列人中，是照耶和華所吩咐摩西的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","以色列人就這樣行，各人照他們的家室、宗族歸於本纛，安營起行，都是照耶和華所吩咐摩西的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","耶和華在西奈山曉諭摩西的日子，亞倫和摩西的後代如下： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","亞倫的兒子，長子名叫拿答，還有亞比戶、以利亞撒、以他瑪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","這是亞倫兒子的名字，都是受膏的祭司，是摩西叫他們承接聖職供祭司職分的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","拿答、亞比戶在西奈的曠野向耶和華獻凡火的時候就死在耶和華面前了。他們也沒有兒子。以利亞撒、以他瑪在他們的父親亞倫面前供祭司的職分。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","耶和華曉諭摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","「你使利未支派近前來，站在祭司亞倫面前好服事他， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","替他和會眾在會幕前守所吩咐的，辦理帳幕的事。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","又要看守會幕的器具，並守所吩咐以色列人的，辦理帳幕的事。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","你要將利未人給亞倫和他的兒子，因為他們是從以色列人中選出來給他的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","你要囑咐亞倫和他的兒子謹守自己祭司的職任。近前來的外人必被治死。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","耶和華曉諭摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","「我從以色列人中揀選了利未人，代替以色列人一切頭生的；利未人要歸我。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","因為凡頭生的是我的；我在埃及地擊殺一切頭生的那日就把以色列中一切頭生的，連人帶牲畜都分別為聖歸我；他們定要屬我。我是耶和華。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","耶和華在西奈的曠野曉諭摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","「你要照利未人的宗族、家室數點他們。凡一個月以外的男子都要數點。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","於是摩西照耶和華所吩咐的數點他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","利未眾子的名字是革順、哥轄、米拉利。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","革順的兒子，按着家室，是立尼、示每。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","哥轄的兒子，按着家室，是暗蘭、以斯哈、希伯倫、烏薛。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","米拉利的兒子，按着家室，是抹利、母示。這些按着宗族是利未人的家室。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","屬革順的，有立尼族、示每族。這是革順的二族。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","其中被數、從一個月以外所有的男子共有七千五百名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","這革順的二族要在帳幕後西邊安營。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","拉伊勒的兒子以利雅薩作革順人宗族的首領。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","革順的子孫在會幕中所要看守的，就是帳幕和罩棚，並罩棚的蓋與會幕的門簾， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","院子的帷子和門簾（院子是圍帳幕和壇的），並一切使用的繩子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","屬哥轄的，有暗蘭族、以斯哈族、希伯倫族、烏薛族。這是哥轄的諸族。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","按所有男子的數目，從一個月以外看守聖所的，共有八千六百名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","哥轄兒子的諸族要在帳幕的南邊安營。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","烏薛的兒子以利撒反作哥轄宗族家室的首領。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","他們所要看守的是約櫃、桌子、燈臺、兩座壇與聖所內使用的器皿，並簾子和一切使用之物。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","祭司亞倫的兒子以利亞撒作利未人眾首領的領袖，要監察那些看守聖所的人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","屬米拉利的，有抹利族、母示族。這是米拉利的二族。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","他們被數的，按所有男子的數目，從一個月以外的，共有六千二百名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","亞比亥的兒子蘇列作米拉利二宗族的首領。他們要在帳幕的北邊安營。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","米拉利子孫的職分是看守帳幕的板、閂、柱子、帶卯的座，和帳幕一切所使用的器具， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","院子四圍的柱子、帶卯的座、橛子，和繩子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","在帳幕前東邊，向日出之地安營的是摩西、亞倫，和亞倫的兒子。他們看守聖所，替以色列人守耶和華所吩咐的。近前來的外人必被治死。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","凡被數的利未人，就是摩西、亞倫照耶和華吩咐所數的，按着家室，從一個月以外的男子，共有二萬二千名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","耶和華對摩西說：「你要從以色列人中數點一個月以外、凡頭生的男子，把他們的名字記下。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","我是耶和華。你要揀選利未人歸我，代替以色列人所有頭生的，也取利未人的牲畜代替以色列所有頭生的牲畜。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","摩西就照耶和華所吩咐的把以色列人頭生的都數點了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","按人名的數目，從一個月以外、凡頭生的男子，共有二萬二千二百七十三名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","耶和華曉諭摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","「你揀選利未人代替以色列人所有頭生的，也取利未人的牲畜代替以色列人的牲畜。利未人要歸我；我是耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","以色列人中頭生的男子比利未人多二百七十三個，必當將他們贖出來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","你要按人丁，照聖所的平，每人取贖銀五舍客勒（一舍客勒是二十季拉）， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","把那多餘之人的贖銀交給亞倫和他的兒子。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","於是摩西從那被利未人所贖以外的人取了贖銀。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","從以色列人頭生的所取之銀，按聖所的平，有一千三百六十五舍客勒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","摩西照耶和華的話把這贖銀給亞倫和他的兒子，正如耶和華所吩咐的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","耶和華曉諭摩西、亞倫說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","「你從利未人中，將哥轄子孫的總數，照他們的家室、宗族， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","從三十歲直到五十歲，凡前來任職、在會幕裏辦事的，全都計算。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","哥轄子孫在會幕搬運至聖之物，所辦的事乃是這樣： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","起營的時候，亞倫和他兒子要進去摘下遮掩櫃的幔子，用以蒙蓋法櫃， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","又用海狗皮蓋在上頭，再蒙上純藍色的毯子，把槓穿上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","又用藍色毯子鋪在陳設餅的桌子上，將盤子、調羹、奠酒的爵，和杯擺在上頭。桌子上也必有常設的餅。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","在其上又要蒙朱紅色的毯子，再蒙上海狗皮，把槓穿上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","要拿藍色毯子，把燈臺和燈臺上所用的燈盞、剪子、蠟花盤，並一切盛油的器皿，全都遮蓋。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","又要把燈臺和燈臺的一切器具包在海狗皮裏，放在抬架上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","在金壇上要鋪藍色毯子，蒙上海狗皮，把槓穿上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","又要把聖所用的一切器具包在藍色毯子裏，用海狗皮蒙上，放在抬架上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","要收去壇上的灰，把紫色毯子鋪在壇上； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","又要把所用的一切器具，就是火鼎、肉鍤子、鏟子、盤子，一切屬壇的器具都擺在壇上，又蒙上海狗皮，把槓穿上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","將要起營的時候，亞倫和他兒子把聖所和聖所的一切器具遮蓋完了，哥轄的子孫就要來抬，只是不可摸聖物，免得他們死亡。會幕裏這些物件是哥轄子孫所當抬的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","「祭司亞倫的兒子以利亞撒所要看守的是點燈的油與香料，並當獻的素祭和膏油，也要看守全帳幕與其中所有的，並聖所和聖所的器具。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","耶和華曉諭摩西、亞倫說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","「你們不可將哥轄人的支派從利未人中剪除。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","他們挨近至聖物的時候，亞倫和他兒子要進去派他們各人所當辦的，所當抬的。這樣待他們，好使他們活着，不致死亡。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","只是他們連片時不可進去觀看聖所，免得他們死亡。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","耶和華曉諭摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","「你要將革順子孫的總數，照着宗族、家室， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","從三十歲直到五十歲，凡前來任職、在會幕裏辦事的，全都數點。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","革順人各族所辦的事、所抬的物乃是這樣： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","他們要抬帳幕的幔子和會幕，並會幕的蓋與其上的海狗皮，和會幕的門簾， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","院子的帷子和門簾（院子是圍帳幕和壇的）、繩子，並所用的器具，不論是做甚麼用的，他們都要經理。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","革順的子孫在一切抬物辦事之上都要憑亞倫和他兒子的吩咐；他們所當抬的，要派他們看守。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","這是革順子孫的各族在會幕裏所辦的事；他們所看守的，必在祭司亞倫兒子以他瑪的手下。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","「至於米拉利的子孫，你要照着家室、宗族把他們數點。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","從三十歲直到五十歲，凡前來任職、在會幕裏辦事的，你都要數點。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","他們辦理會幕的事，就是抬帳幕的板、閂、柱子，和帶卯的座， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","院子四圍的柱子和其上帶卯的座、橛子、繩子，並一切使用的器具。他們所抬的器具，你們要按名指定。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","這是米拉利子孫各族在會幕裏所辦的事，都在祭司亞倫兒子以他瑪的手下。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","摩西、亞倫與會眾的諸首領將哥轄的子孫，照着家室、宗族， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","從三十歲直到五十歲，凡前來任職、在會幕裏辦事的，都數點了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","被數的共有二千七百五十名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","這是哥轄各族中被數的，是在會幕裏辦事的，就是摩西、亞倫照耶和華藉摩西所吩咐數點的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","革順子孫被數的，照着家室、宗族， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","40","從三十歲直到五十歲，凡前來任職、在會幕裏辦事的，共有二千六百三十名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","這是革順子孫各族中被數的，是在會幕裏辦事的，就是摩西、亞倫照耶和華藉摩西所吩咐數點的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","米拉利子孫中各族被數的，照着家室、宗族， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","44","從三十歲直到五十歲，凡前來任職、在會幕裏辦事的，共有三千二百名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","這是米拉利子孫各族中被數的，就是摩西、亞倫照耶和華藉摩西所吩咐數點的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","凡被數的利未人，就是摩西、亞倫並以色列眾首領，照着家室、宗族所數點的， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","48","從三十歲直到五十歲，凡前來任職、在會幕裏做抬物之工的，共有八千五百八十名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","摩西按他們所辦的事、所抬的物，憑耶和華的吩咐數點他們；他們這樣被摩西數點，正如耶和華所吩咐他的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","耶和華曉諭摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","「你吩咐以色列人，使一切長大痲瘋的，患漏症的，並因死屍不潔淨的，都出營外去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","無論男女都要使他們出到營外，免得污穢他們的營；這營是我所住的。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","以色列人就這樣行，使他們出到營外。耶和華怎樣吩咐摩西，以色列人就怎樣行了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","耶和華對摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","「你曉諭以色列人說：無論男女，若犯了人所常犯的罪，以致干犯耶和華，那人就有了罪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","他要承認所犯的罪，將所虧負人的，如數賠還，另外加上五分之一，也歸與所虧負的人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","那人若沒有親屬可受所賠還的，那所賠還的就要歸與服事耶和華的祭司；至於那為他贖罪的公羊是在外。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","以色列人一切的聖物中，所奉給祭司的舉祭都要歸與祭司。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","各人所分別為聖的物，無論是甚麼，都要歸給祭司。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","耶和華對摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","「你曉諭以色列人說：人的妻若有邪行，得罪她丈夫， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","有人與她行淫，事情嚴密，瞞過她丈夫，而且她被玷污，沒有作見證的人，當她行淫的時候也沒有被捉住， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","她丈夫生了疑恨的心，疑恨她，她是被玷污，或是她丈夫生了疑恨的心，疑恨她，她並沒有被玷污， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","這人就要將妻送到祭司那裏，又為她帶着大麥麵伊法十分之一作供物，不可澆上油，也不可加上乳香；因為這是疑恨的素祭，是思念的素祭，使人思念罪孽。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","「祭司要使那婦人近前來，站在耶和華面前。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","祭司要把聖水盛在瓦器裏，又從帳幕的地上取點塵土，放在水中。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","祭司要叫那婦人蓬頭散髮，站在耶和華面前，把思念的素祭，就是疑恨的素祭，放在她手中。祭司手裏拿着致咒詛的苦水， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","要叫婦人起誓，對她說：『若沒有人與你行淫，也未曾背着丈夫做污穢的事，你就免受這致咒詛苦水的災。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","你若背着丈夫行了污穢的事，在你丈夫以外有人與你行淫， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","（祭司叫婦人發咒起誓），願耶和華叫你大腿消瘦，肚腹發脹，使你在你民中被人咒詛，成了誓語； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","並且這致咒詛的水入你的腸中，要叫你的肚腹發脹，大腿消瘦。』婦人要回答說：『阿們，阿們。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","「祭司要寫這咒詛的話，將所寫的字抹在苦水裏， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","又叫婦人喝這致咒詛的苦水；這水要進入她裏面變苦了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","祭司要從婦人的手中取那疑恨的素祭，在耶和華面前搖一搖，拿到壇前； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","又要從素祭中取出一把，作為這事的紀念，燒在壇上，然後叫婦人喝這水。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","叫她喝了以後，她若被玷污，得罪了丈夫，這致咒詛的水必進入她裏面變苦了，她的肚腹就要發脹，大腿就要消瘦，那婦人便要在他民中被人咒詛。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","若婦人沒有被玷污，卻是清潔的，就要免受這災，且要懷孕。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","「妻子背着丈夫行了污穢的事， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","或是人生了疑恨的心，疑恨他的妻，就有這疑恨的條例。那時他要叫婦人站在耶和華面前，祭司要在她身上照這條例而行。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","男人就為無罪，婦人必擔當自己的罪孽。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","耶和華對摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","「你曉諭以色列人說：無論男女許了特別的願，就是拿細耳人的願，要離俗歸耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","他就要遠離清酒濃酒，也不可喝甚麼清酒濃酒做的醋；不可喝甚麼葡萄汁，也不可吃鮮葡萄和乾葡萄。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","在一切離俗的日子，凡葡萄樹上結的，自核至皮所做的物，都不可吃。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","「在他一切許願離俗的日子，不可用剃頭刀剃頭，要由髮綹長長了。他要聖潔，直到離俗歸耶和華的日子滿了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","在他離俗歸耶和華的一切日子，不可挨近死屍。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","他的父母或是弟兄姊妹死了的時候，他不可因他們使自己不潔淨，因為那離俗歸上帝的憑據是在他頭上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","在他一切離俗的日子是歸耶和華為聖。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","「若在他旁邊忽然有人死了，以致沾染了他離俗的頭，他要在第七日，得潔淨的時候，剃頭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","第八日，他要把兩隻斑鳩或兩隻雛鴿帶到會幕門口，交給祭司。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","祭司要獻一隻作贖罪祭，一隻作燔祭，為他贖那因死屍而有的罪，並要當日使他的頭成為聖潔。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","他要另選離俗歸耶和華的日子，又要牽一隻一歲的公羊羔來作贖愆祭；但先前的日子要歸徒然，因為他在離俗之間被玷污了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","「拿細耳人滿了離俗的日子乃有這條例：人要領他到會幕門口， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","他要將供物奉給耶和華，就是一隻沒有殘疾、一歲的公羊羔作燔祭，一隻沒有殘疾、一歲的母羊羔作贖罪祭，和一隻沒有殘疾的公綿羊作平安祭， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","並一筐子無酵調油的細麵餅，與抹油的無酵薄餅，並同獻的素祭和奠祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","祭司要在耶和華面前獻那人的贖罪祭和燔祭； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","也要把那隻公羊和那筐無酵餅獻給耶和華作平安祭，又要將同獻的素祭和奠祭獻上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","拿細耳人要在會幕門口剃離俗的頭，把離俗頭上的髮放在平安祭下的火上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","他剃了以後，祭司就要取那已煮的公羊一條前腿，又從筐子裏取一個無酵餅和一個無酵薄餅，都放在他手上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","祭司要拿這些作為搖祭，在耶和華面前搖一搖；這與所搖的胸、所舉的腿同為聖物，歸給祭司。然後拿細耳人可以喝酒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","「許願的拿細耳人為離俗所獻的供物，和他以外所能得的獻給耶和華，就有這條例。他怎樣許願就當照離俗的條例行。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","耶和華曉諭摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","「你告訴亞倫和他兒子說：你們要這樣為以色列人祝福，說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","『願耶和華賜福給你，保護你。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","願耶和華使他的臉光照你，賜恩給你。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","願耶和華向你仰臉，賜你平安。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","他們要如此奉我的名為以色列人祝福；我也要賜福給他們。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","摩西立完了帳幕，就把帳幕用膏抹了，使它成聖，又把其中的器具和壇，並壇上的器具，都抹了，使它成聖。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","當天，以色列的眾首領，就是各族的族長，都來奉獻。他們是各支派的首領，管理那些被數的人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","他們把自己的供物送到耶和華面前，就是六輛篷子車和十二隻公牛。每兩個首領奉獻一輛車，每首領奉獻一隻牛。他們把這些都奉到帳幕前。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","耶和華曉諭摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","「你要收下這些，好作會幕的使用，都要照利未人所辦的事交給他們。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","於是摩西收了車和牛，交給利未人， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","把兩輛車，四隻牛，照革順子孫所辦的事交給他們， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","又把四輛車，八隻牛，照米拉利子孫所辦的事交給他們；他們都在祭司亞倫的兒子以他瑪手下。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","但車與牛都沒有交給哥轄子孫；因為他們辦的是聖所的事，在肩頭上抬聖物。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","用膏抹壇的日子，首領都來行奉獻壇的禮，眾首領就在壇前獻供物。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","耶和華對摩西說：「眾首領為行奉獻壇的禮，要每天一個首領來獻供物。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","頭一日獻供物的是猶大支派的亞米拿達的兒子拿順。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","他的供物是：一個銀盤子，重一百三十舍客勒，一個銀碗，重七十舍客勒，都是按聖所的平，也都盛滿了調油的細麵作素祭； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","一個金盂，重十舍客勒，盛滿了香； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","一隻公牛犢，一隻公綿羊，一隻一歲的公羊羔作燔祭； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","一隻公山羊作贖罪祭； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","兩隻公牛，五隻公綿羊，五隻公山羊，五隻一歲的公羊羔作平安祭。這是亞米拿達兒子拿順的供物。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","第二日來獻的是以薩迦子孫的首領、蘇押的兒子拿坦業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","他獻為供物的是：一個銀盤子，重一百三十舍客勒，一個銀碗，重七十舍客勒，都是按聖所的平，也都盛滿了調油的細麵作素祭； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","一個金盂，重十舍客勒，盛滿了香； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","一隻公牛犢，一隻公綿羊，一隻一歲的公羊羔作燔祭； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","一隻公山羊作贖罪祭； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","兩隻公牛，五隻公綿羊，五隻公山羊，五隻一歲的公羊羔作平安祭。這是蘇押兒子拿坦業的供物。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","第三日來獻的是西布倫子孫的首領、希倫的兒子以利押。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","他的供物是：一個銀盤子，重一百三十舍客勒，一個銀碗，重七十舍客勒，都是按聖所的平，也都盛滿了調油的細麵作素祭； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","一個金盂，重十舍客勒，盛滿了香； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","一隻公牛犢，一隻公綿羊，一隻一歲的公羊羔作燔祭； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","一隻公山羊作贖罪祭； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","兩隻公牛，五隻公綿羊，五隻公山羊，五隻一歲的公羊羔作平安祭。這是希倫兒子以利押的供物。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","第四日來獻的是呂便子孫的首領、示丟珥的兒子以利蓿。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","他的供物是：一個銀盤子，重一百三十舍客勒，一個銀碗，重七十舍客勒，都是按聖所的平，也都盛滿了調油的細麵作素祭； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","一個金盂，重十舍客勒，盛滿了香； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","一隻公牛犢，一隻公綿羊，一隻一歲的公羊羔作燔祭； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","一隻公山羊作贖罪祭； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","兩隻公牛，五隻公綿羊，五隻公山羊，五隻一歲的公羊羔作平安祭。這是示丟珥的兒子以利蓿的供物。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","第五日來獻的是西緬子孫的首領、蘇利沙代的兒子示路蔑。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","他的供物是：一個銀盤子，重一百三十舍客勒，一個銀碗，重七十舍客勒，都是按聖所的平，也都盛滿了調油的細麵作素祭； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","一個金盂，重十舍客勒，盛滿了香； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","一隻公牛犢，一隻公綿羊，一隻一歲的公羊羔作燔祭； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","一隻公山羊作贖罪祭； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","兩隻公牛，五隻公綿羊，五隻公山羊，五隻一歲的公羊羔作平安祭。這是蘇利沙代兒子示路蔑的供物。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","第六日來獻的是迦得子孫的首領、丟珥的兒子以利雅薩。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","他的供物是：一個銀盤子，重一百三十舍客勒，一個銀碗，重七十舍客勒，都是按聖所的平，也都盛滿了調油的細麵作素祭； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","一個金盂，重十舍客勒，盛滿了香； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","一隻公牛犢，一隻公綿羊，一隻一歲的公羊羔作燔祭； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","一隻公山羊作贖罪祭； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","兩隻公牛，五隻公綿羊，五隻公山羊，五隻一歲的公羊羔作平安祭。這是丟珥的兒子以利雅薩的供物。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","第七日來獻的是以法蓮子孫的首領、亞米忽的兒子以利沙瑪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","他的供物是：一個銀盤子，重一百三十舍客勒，一個銀碗，重七十舍客勒，都是按聖所的平，也都盛滿了調油的細麵作素祭； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","一個金盂，重十舍客勒，盛滿了香； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","一隻公牛犢，一隻公綿羊，一隻一歲的公羊羔作燔祭； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","一隻公山羊作贖罪祭； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","兩隻公牛，五隻公綿羊，五隻公山羊，五隻一歲的公羊羔作平安祭。這是亞米忽兒子以利沙瑪的供物。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","第八日來獻的是瑪拿西子孫的首領、比大蓿的兒子迦瑪列。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","他的供物是：一個銀盤子，重一百三十舍客勒，一個銀碗，重七十舍客勒，都是按聖所的平，也都盛滿了調油的細麵作素祭； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","一個金盂，重十舍客勒，盛滿了香； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","一隻公牛犢，一隻公綿羊，一隻一歲的公羊羔作燔祭； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","一隻公山羊作贖罪祭； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","兩隻公牛，五隻公綿羊，五隻公山羊，五隻一歲的公羊羔作平安祭。這是比大蓿兒子迦瑪列的供物。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","第九日來獻的是便雅憫子孫的首領、基多尼的兒子亞比但。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","他的供物是：一個銀盤子，重一百三十舍客勒，一個銀碗，重七十舍客勒，都是按聖所的平，也都盛滿了調油的細麵作素祭； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","一個金盂，重十舍客勒，盛滿了香； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","一隻公牛犢，一隻公綿羊，一隻一歲的公羊羔作燔祭； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","一隻公山羊作贖罪祭； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","兩隻公牛，五隻公綿羊，五隻公山羊，五隻一歲的公羊羔作平安祭。這是基多尼兒子亞比但的供物。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","第十日來獻的是但子孫的首領、亞米沙代的兒子亞希以謝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","他的供物是：一個銀盤子，重一百三十舍客勒，一個銀碗，重七十舍客勒，都是按聖所的平，也都盛滿了調油的細麵作素祭； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","一個金盂，重十舍客勒，盛滿了香； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","一隻公牛犢，一隻公綿羊，一隻一歲的公羊羔作燔祭； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","一隻公山羊作贖罪祭； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","兩隻公牛，五隻公綿羊，五隻公山羊，五隻一歲的公羊羔作平安祭。這是亞米沙代兒子亞希以謝的供物。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","第十一日來獻的是亞設子孫的首領、俄蘭的兒子帕結。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","他的供物是：一個銀盤子，重一百三十舍客勒，一個銀碗，重七十舍客勒，都是按聖所的平，也都盛滿了調油的細麵作素祭； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","一個金盂，重十舍客勒，盛滿了香； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","一隻公牛犢，一隻公綿羊，一隻一歲的公羊羔作燔祭； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","一隻公山羊作贖罪祭； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","兩隻公牛，五隻公綿羊，五隻公山羊，五隻一歲的公羊羔作平安祭。這是俄蘭兒子帕結的供物。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","第十二日來獻的是拿弗他利子孫的首領、以南兒子亞希拉。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","他的供物是：一個銀盤子，重一百三十舍客勒，一個銀碗，重七十舍客勒，都是按聖所的平，也都盛滿了調油的細麵作素祭； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","一個金盂，重十舍客勒，盛滿了香； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","一隻公牛犢，一隻公綿羊，一隻一歲的公羊羔作燔祭； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","一隻公山羊作贖罪祭； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","兩隻公牛，五隻公綿羊，五隻公山羊，五隻一歲的公羊羔作平安祭。這是以南兒子亞希拉的供物。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","用膏抹壇的日子，以色列的眾首領為行獻壇之禮所獻的是：銀盤子十二個，銀碗十二個，金盂十二個； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","每盤子重一百三十舍客勒，每碗重七十舍客勒。一切器皿的銀子，按聖所的平，共有二千四百舍客勒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","十二個金盂盛滿了香，按聖所的平，每盂重十舍客勒，所有的金子共一百二十舍客勒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","作燔祭的，共有公牛十二隻，公羊十二隻，一歲的公羊羔十二隻，並同獻的素祭作贖罪祭的公山羊十二隻； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","作平安祭的，共有公牛二十四隻，公綿羊六十隻，公山羊六十隻，一歲的公羊羔六十隻。這就是用膏抹壇之後，為行奉獻壇之禮所獻的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","摩西進會幕要與耶和華說話的時候，聽見法櫃的施恩座以上、二基路伯中間有與他說話的聲音，就是耶和華與他說話。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","耶和華曉諭摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","「你告訴亞倫說：點燈的時候，七盞燈都要向燈臺前面發光。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","亞倫便這樣行。他點燈臺上的燈，使燈向前發光，是照耶和華所吩咐摩西的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","這燈臺的做法是用金子錘出來的，連座帶花都是錘出來的。摩西製造燈臺，是照耶和華所指示的樣式。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","耶和華曉諭摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","「你從以色列人中選出利未人來，潔淨他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","潔淨他們當這樣行：用除罪水彈在他們身上，又叫他們用剃頭刀刮全身，洗衣服，潔淨自己。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","然後叫他們取一隻公牛犢，並同獻的素祭，就是調油的細麵；你要另取一隻公牛犢作贖罪祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","將利未人奉到會幕前，招聚以色列全會眾。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","將利未人奉到耶和華面前，以色列人要按手在他們頭上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","亞倫也將他們奉到耶和華面前，為以色列人當作搖祭，使他們好辦耶和華的事。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","利未人要按手在那兩隻牛的頭上；你要將一隻作贖罪祭，一隻作燔祭，獻給耶和華，為利未人贖罪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","你也要使利未人站在亞倫和他兒子面前，將他們當作搖祭奉給耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","「這樣，你從以色列人中將利未人分別出來，利未人便要歸我。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","此後利未人要進去辦會幕的事，你要潔淨他們，將他們當作搖祭奉上； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","因為他們是從以色列人中全然給我的，我揀選他們歸我，是代替以色列人中一切頭生的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","以色列人中一切頭生的，連人帶牲畜，都是我的。我在埃及地擊殺一切頭生的那天，將他們分別為聖歸我。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","我揀選利未人代替以色列人中一切頭生的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","我從以色列人中將利未人當作賞賜給亞倫和他的兒子，在會幕中辦以色列人的事，又為以色列人贖罪，免得他們挨近聖所，有災殃臨到他們中間。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","摩西、亞倫，並以色列全會眾便向利未人如此行。凡耶和華指着利未人所吩咐摩西的，以色列人就向他們這樣行。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","於是利未人潔淨自己，除了罪，洗了衣服；亞倫將他們當作搖祭奉到耶和華面前，又為他們贖罪，潔淨他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","然後利未人進去，在亞倫和他兒子面前，在會幕中辦事。耶和華指着利未人怎樣吩咐摩西，以色列人就怎樣向他們行了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","耶和華曉諭摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","「利未人是這樣：從二十五歲以外，他們要前來任職，辦會幕的事。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","到了五十歲要停工退任，不再辦事， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","只要在會幕裏，和他們的弟兄一同伺候，謹守所吩咐的，不再辦事了。至於所吩咐利未人的，你要這樣向他們行。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","以色列人出埃及地以後，第二年正月，耶和華在西奈的曠野吩咐摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","「以色列人應當在所定的日期守逾越節， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","就是本月十四日黃昏的時候，你們要在所定的日期守這節，要按這節的律例典章而守。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","於是摩西吩咐以色列人守逾越節。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","他們就在西奈的曠野，正月十四日黃昏的時候，守逾越節。凡耶和華所吩咐摩西的，以色列人都照樣行了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","有幾個人因死屍而不潔淨，不能在那日守逾越節。當日他們到摩西、亞倫面前， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","說：「我們雖因死屍而不潔淨，為何被阻止、不得同以色列人在所定的日期獻耶和華的供物呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","摩西對他們說：「你們暫且等候，我可以去聽耶和華指着你們是怎樣吩咐的。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","耶和華對摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","「你曉諭以色列人說：你們和你們後代中，若有人因死屍而不潔淨，或在遠方行路，還要向耶和華守逾越節。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","他們要在二月十四日黃昏的時候，守逾越節。要用無酵餅與苦菜，和逾越節的羊羔同吃。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","一點不可留到早晨；羊羔的骨頭一根也不可折斷。他們要照逾越節的一切律例而守。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","那潔淨而不行路的人若推辭不守逾越節，那人要從民中剪除；因為他在所定的日期不獻耶和華的供物，應該擔當他的罪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","若有外人寄居在你們中間，願意向耶和華守逾越節，他要照逾越節的律例典章行，不管是寄居的是本地人，同歸一例。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","立起帳幕的那日，有雲彩遮蓋帳幕，就是法櫃的帳幕；從晚上到早晨，雲彩在其上，形狀如火。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","常是這樣，雲彩遮蓋帳幕，夜間形狀如火。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","雲彩幾時從帳幕收上去，以色列人就幾時起行；雲彩在哪裏停住，以色列人就在那裏安營。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","以色列人遵耶和華的吩咐起行，也遵耶和華的吩咐安營。雲彩在帳幕上停住幾時，他們就住營幾時。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","雲彩在帳幕上停留許多日子，以色列人就守耶和華所吩咐的不起行。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","有時雲彩在帳幕上幾天，他們就照耶和華的吩咐住營，也照耶和華的吩咐起行。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","有時從晚上到早晨，有這雲彩在帳幕上；早晨雲彩收上去，他們就起行。有時晝夜雲彩停在帳幕上，收上去的時候，他們就起行。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","雲彩停留在帳幕上，無論是兩天，是一月，是一年，以色列人就住營不起行；但雲彩收上去，他們就起行。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","他們遵耶和華的吩咐安營，也遵耶和華的吩咐起行。他們守耶和華所吩咐的，都是憑耶和華吩咐摩西的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","耶和華曉諭摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","「你要用銀子做兩枝號，都要錘出來的，用以招聚會眾，並叫眾營起行。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","吹這號的時候，全會眾要到你那裏，聚集在會幕門口。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","若單吹一枝，眾首領，就是以色列軍中的統領，要聚集到你那裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","吹出大聲的時候，東邊安的營都要起行。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","二次吹出大聲的時候，南邊安的營都要起行。他們將起行，必吹出大聲。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","但招聚會眾的時候，你們要吹號，卻不要吹出大聲。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","亞倫子孫作祭司的要吹這號；這要作你們世世代代永遠的定例。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","你們在自己的地，與欺壓你們的敵人打仗，就要用號吹出大聲，便在耶和華－你們的上帝面前得蒙紀念，也蒙拯救脫離仇敵。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","在你們快樂的日子和節期，並月朔，獻燔祭和平安祭，也要吹號，這都要在你們的上帝面前作為紀念。我是耶和華－你們的上帝。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","第二年二月二十日，雲彩從法櫃的帳幕收上去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","以色列人就按站往前行，離開西奈的曠野，雲彩停住在巴蘭的曠野。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","這是他們照耶和華藉摩西所吩咐的，初次往前行。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","按着軍隊首先往前行的是猶大營的纛。統領軍隊的是亞米拿達的兒子拿順。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","統領以薩迦支派軍隊的是蘇押的兒子拿坦業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","統領西布倫支派軍隊的是希倫的兒子以利押。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","帳幕拆卸，革順的子孫和米拉利的子孫就抬着帳幕先往前行。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","按着軍隊往前行的是呂便營的纛。統領軍隊的是示丟珥的兒子以利蓿。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","統領西緬支派軍隊的是蘇利沙代的兒子示路蔑。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","統領迦得支派軍隊的是丟珥的兒子以利雅薩。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","哥轄人抬着聖物先往前行。他們未到以前，抬帳幕的已經把帳幕支好。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","按着軍隊往前行的是以法蓮營的纛，統領軍隊的是亞米忽的兒子以利沙瑪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","統領瑪拿西支派軍隊的是比大蓿的兒子迦瑪列。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","統領便雅憫支派軍隊的是基多尼的兒子亞比但。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","在諸營末後的是但營的纛，按着軍隊往前行。統領軍隊的是亞米沙代的兒子亞希以謝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","統領亞設支派軍隊的是俄蘭的兒子帕結。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","統領拿弗他利支派軍隊的是以南的兒子亞希拉。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","以色列人按着軍隊往前行，就是這樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","摩西對他岳父－米甸人流珥的兒子何巴－說：「我們要行路，往耶和華所應許之地去；他曾說：『我要將這地賜給你們。』現在求你和我們同去，我們必厚待你，因為耶和華指着以色列人已經應許給好處。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","何巴回答說：「我不去；我要回本地本族那裏去。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","摩西說：「求你不要離開我們；因為你知道我們要在曠野安營，你可以當作我們的眼目。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","你若和我們同去，將來耶和華有甚麼好處待我們，我們也必以甚麼好處待你。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","以色列人離開耶和華的山，往前行了三天的路程；耶和華的約櫃在前頭行了三天的路程，為他們尋找安歇的地方。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","他們拔營往前行，日間有耶和華的雲彩在他們以上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","約櫃往前行的時候，摩西就說：「耶和華啊，求你興起！願你的仇敵四散！願恨你的人從你面前逃跑！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","約櫃停住的時候，他就說：「耶和華啊，求你回到以色列的千萬人中！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","眾百姓發怨言，他們的惡語達到耶和華的耳中。耶和華聽見了就怒氣發作，使火在他們中間焚燒，直燒到營的邊界。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","百姓向摩西哀求，摩西祈求耶和華，火就熄了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","那地方便叫做他備拉，因為耶和華的火燒在他們中間。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","他們中間的閒雜人大起貪慾的心；以色列人又哭號說：「誰給我們肉吃呢？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","我們記得，在埃及的時候不花錢就吃魚，也記得有黃瓜、西瓜、韭菜、誄、蒜。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","現在我們的心血枯竭了，除這嗎哪以外，在我們眼前並沒有別的東西。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","這嗎哪彷彿芫荽子，又好像珍珠。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","百姓周圍行走，把嗎哪收起來，或用磨推，或用臼搗，煮在鍋中，又做成餅，滋味好像新油。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","夜間露水降在營中，嗎哪也隨着降下。） ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","摩西聽見百姓各在各家的帳棚門口哭號。耶和華的怒氣便大發作，摩西就不喜悅。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","摩西對耶和華說：「你為何苦待僕人？我為何不在你眼前蒙恩，竟把這管理百姓的重任加在我身上呢？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","這百姓豈是我懷的胎，豈是我生下來的呢？你竟對我說：『把他們抱在懷裏，如養育之父抱吃奶的孩子，直抱到你起誓應許給他們祖宗的地去。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","我從哪裏得肉給這百姓吃呢？他們都向我哭號說：『你給我們肉吃吧！』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","管理這百姓的責任太重了，我獨自擔當不起。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","你這樣待我，我若在你眼前蒙恩，求你立時將我殺了，不叫我見自己的苦情。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","耶和華對摩西說：「你從以色列的長老中招聚七十個人，就是你所知道作百姓的長老和官長的，到我這裏來，領他們到會幕前，使他們和你一同站立。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","我要在那裏降臨，與你說話，也要把降於你身上的靈分賜他們，他們就和你同當這管百姓的重任，免得你獨自擔當。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","又要對百姓說：『你們應當自潔，預備明天吃肉，因為你們哭號說：誰給我們肉吃！我們在埃及很好。這聲音達到了耶和華的耳中，所以他必給你們肉吃。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","你們不止吃一天、兩天、五天、十天、二十天， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","要吃一個整月，甚至肉從你們鼻孔裏噴出來，使你們厭惡了，因為你們厭棄住在你們中間的耶和華，在他面前哭號說：我們為何出了埃及呢！』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","摩西對耶和華說：「這與我同住的百姓、步行的男人有六十萬，你還說：『我要把肉給他們，使他們可以吃一個整月。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","難道給他們宰了羊群牛群，或是把海中所有的魚都聚了來，就夠他們吃嗎？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","耶和華對摩西說：「耶和華的膀臂豈是縮短了嗎？現在要看我的話向你應驗不應驗。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","摩西出去，將耶和華的話告訴百姓，又招聚百姓的長老中七十個人來，使他們站在會幕的四圍。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","耶和華在雲中降臨，對摩西說話，把降與他身上的靈分賜那七十個長老。靈停在他們身上的時候，他們就受感說話，以後卻沒有再說。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","但有兩個人仍在營裏，一個名叫伊利達，一個名叫米達。他們本是在那些被錄的人中，卻沒有到會幕那裏去。靈停在他們身上，他們就在營裏說預言。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","有個少年人跑來告訴摩西說：「伊利達、米達在營裏說預言。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","摩西的幫手，嫩的兒子約書亞，就是摩西所揀選的一個人，說：「請我主摩西禁止他們。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","摩西對他說：「你為我的緣故嫉妒人嗎？惟願耶和華的百姓都受感說話！願耶和華把他的靈降在他們身上！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","於是，摩西和以色列的長老都回到營裏去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","有風從耶和華那裏颳起，把鵪鶉由海面颳來，飛散在營邊和營的四圍；這邊約有一天的路程，那邊約有一天的路程，離地面約有二肘。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","百姓起來，終日終夜，並次日一整天，捕取鵪鶉；至少的也取了十賀梅珥，為自己擺列在營的四圍。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","肉在他們牙齒之間尚未嚼爛，耶和華的怒氣就向他們發作，用最重的災殃擊殺了他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","那地方便叫做基博羅‧哈他瓦，因為他們在那裏葬埋那起貪慾之心的人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","百姓從基博羅‧哈他瓦走到哈洗錄，就住在哈洗錄。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","摩西娶了古實女子為妻。米利暗和亞倫因他所娶的古實女子就毀謗他，說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","「難道耶和華單與摩西說話，不也與我們說話嗎？」這話耶和華聽見了。（ ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","摩西為人極其謙和，勝過世上的眾人。） ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","耶和華忽然對摩西、亞倫、米利暗說：「你們三個人都出來，到會幕這裏。」他們三個人就出來了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","耶和華在雲柱中降臨，站在會幕門口，召亞倫和米利暗，二人就出來了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","耶和華說：「你們且聽我的話：你們中間若有先知，我－耶和華必在異象中向他顯現，在夢中與他說話。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","我的僕人摩西不是這樣；他是在我全家盡忠的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","我要與他面對面說話，乃是明說，不用謎語，並且他必見我的形像。你們毀謗我的僕人摩西，為何不懼怕呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","耶和華就向他們二人發怒而去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","雲彩從會幕上挪開了，不料，米利暗長了大痲瘋，有雪那樣白。亞倫一看米利暗長了大痲瘋， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","就對摩西說：「我主啊，求你不要因我們愚昧犯罪，便將這罪加在我們身上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","求你不要使她像那出母腹、肉已半爛的死胎。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","於是摩西哀求耶和華說：「上帝啊，求你醫治她！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","耶和華對摩西說：「她父親若吐唾沫在她臉上，她豈不蒙羞七天嗎？現在要把她在營外關鎖七天，然後才可以領她進來。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","於是米利暗關鎖在營外七天。百姓沒有行路，直等到把米利暗領進來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","以後百姓從哈洗錄起行，在巴蘭的曠野安營。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","耶和華曉諭摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","「你打發人去窺探我所賜給以色列人的迦南地，他們每支派中要打發一個人，都要作首領的。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","摩西就照耶和華的吩咐從巴蘭的曠野打發他們去；他們都是以色列人的族長。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","他們的名字：屬呂便支派的有撒刻的兒子沙母亞。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","屬西緬支派的有何利的兒子沙法。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","屬猶大支派的有耶孚尼的兒子迦勒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","屬以薩迦支派的有約色的兒子以迦。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","屬以法蓮支派的有嫩的兒子何希阿。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","屬便雅憫支派的有拉孚的兒子帕提。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","屬西布倫支派的有梭底的兒子迦疊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","約瑟的子孫，屬瑪拿西支派的有穌西的兒子迦底。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","屬但支派的有基瑪利的兒子亞米利。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","屬亞設支派的有米迦勒的兒子西帖。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","屬拿弗他利支派的有縛西的兒子拿比。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","屬迦得支派的有瑪基的兒子臼利。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","這就是摩西所打發、窺探那地之人的名字。摩西就稱嫩的兒子何希阿為約書亞。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","摩西打發他們去窺探迦南地，說：「你們從南地上山地去， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","看那地如何，其中所住的民是強是弱，是多是少， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","所住之地是好是歹，所住之處是營盤是堅城。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","又看那地土是肥美是瘠薄，其中有樹木沒有。你們要放開膽量，把那地的果子帶些來。」（那時正是葡萄初熟的時候。） ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","他們上去窺探那地，從尋的曠野到利合，直到哈馬口。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","他們從南地上去，到了希伯崙；在那裏有亞衲族人亞希幔、示篩、撻買。（原來希伯崙城被建造比埃及的鎖安城早七年。） ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","他們到了以實各谷，從那裏砍了葡萄樹的一枝，上頭有一掛葡萄，兩個人用槓抬着，又帶了些石榴和無花果來。（ ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","因為以色列人從那裏砍來的那掛葡萄，所以那地方叫做以實各谷。） ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","過了四十天，他們窺探那地才回來， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","到了巴蘭曠野的加低斯，見摩西、亞倫，並以色列的全會眾，回報摩西、亞倫，並全會眾，又把那地的果子給他們看； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","又告訴摩西說：「我們到了你所打發我們去的那地，果然是流奶與蜜之地；這就是那地的果子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","然而住那地的民強壯，城邑也堅固寬大，並且我們在那裏看見了亞衲族的人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","亞瑪力人住在南地；赫人、耶布斯人、亞摩利人住在山地；迦南人住在海邊並約旦河旁。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","迦勒在摩西面前安撫百姓，說：「我們立刻上去得那地吧！我們足能得勝。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","但那些和他同去的人說：「我們不能上去攻擊那民，因為他們比我們強壯。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","探子中有人論到所窺探之地，向以色列人報惡信，說：「我們所窺探、經過之地是吞吃居民之地，我們在那裏所看見的人民都身量高大。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","我們在那裏看見亞衲族人，就是偉人；他們是偉人的後裔。據我們看，自己就如蚱蜢一樣；據他們看，我們也是如此。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","當下，全會眾大聲喧嚷；那夜百姓都哭號。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","以色列眾人向摩西、亞倫發怨言；全會眾對他們說：「巴不得我們早死在埃及地，或是死在這曠野。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","耶和華為甚麼把我們領到那地，使我們倒在刀下呢？我們的妻子和孩子必被擄掠。我們回埃及去豈不好嗎？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","眾人彼此說：「我們不如立一個首領回埃及去吧！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","摩西、亞倫就俯伏在以色列全會眾面前。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","窺探地的人中，嫩的兒子約書亞和耶孚尼的兒子迦勒撕裂衣服， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","對以色列全會眾說：「我們所窺探、經過之地是極美之地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","耶和華若喜悅我們，就必將我們領進那地，把地賜給我們；那地原是流奶與蜜之地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","但你們不可背叛耶和華，也不要怕那地的居民；因為他們是我們的食物，並且蔭庇他們的已經離開他們。有耶和華與我們同在，不要怕他們！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","但全會眾說：「拿石頭打死他們二人。」忽然，耶和華的榮光在會幕中向以色列眾人顯現。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","耶和華對摩西說：「這百姓藐視我要到幾時呢？我在他們中間行了這一切神蹟，他們還不信我要到幾時呢？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","我要用瘟疫擊殺他們，使他們不得承受那地，叫你的後裔成為大國，比他們強勝。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","摩西對耶和華說：「埃及人必聽見這事；因為你曾施展大能，將這百姓從他們中間領上來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","埃及人要將這事傳給迦南地的居民；那民已經聽見你－耶和華是在這百姓中間；因為你面對面被人看見，有你的雲彩停在他們以上。你日間在雲柱中，夜間在火柱中，在他們前面行。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","如今你若把這百姓殺了，如殺一人，那些聽見你名聲的列邦必議論說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","『耶和華因為不能把這百姓領進他向他們起誓應許之地，所以在曠野把他們殺了。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","現在求主大顯能力，照你所說過的話說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","『耶和華不輕易發怒，並有豐盛的慈愛，赦免罪孽和過犯；萬不以有罪的為無罪，必追討他的罪，自父及子，直到三、四代。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","求你照你的大慈愛赦免這百姓的罪孽，好像你從埃及到如今常赦免他們一樣。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","耶和華說：「我照着你的話赦免了他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","然我指着我的永生起誓，遍地要被我的榮耀充滿。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","這些人雖看見我的榮耀和我在埃及與曠野所行的神蹟，仍然試探我這十次，不聽從我的話， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","他們斷不得看見我向他們的祖宗所起誓應許之地。凡藐視我的，一個也不得看見； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","惟獨我的僕人迦勒，因他另有一個心志，專一跟從我，我就把他領進他所去過的那地；他的後裔也必得那地為業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","亞瑪力人和迦南人住在谷中，明天你們要轉回，從紅海的路往曠野去。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","耶和華對摩西、亞倫說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","「這惡會眾向我發怨言，我忍耐他們要到幾時呢？以色列人向我所發的怨言，我都聽見了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","你們告訴他們，耶和華說：『我指着我的永生起誓，我必要照你們達到我耳中的話待你們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","你們的屍首必倒在這曠野，並且你們中間凡被數點、從二十歲以外、向我發怨言的， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","必不得進我起誓應許叫你們住的那地；惟有耶孚尼的兒子迦勒和嫩的兒子約書亞才能進去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","但你們的婦人孩子，就是你們所說、要被擄掠的，我必把他們領進去，他們就得知你們所厭棄的那地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","至於你們，你們的屍首必倒在這曠野； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","你們的兒女必在曠野飄流四十年，擔當你們淫行的罪，直到你們的屍首在曠野消滅。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","按你們窺探那地的四十日，一年頂一日，你們要擔當罪孽四十年，就知道我與你們疏遠了， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","我－耶和華說過，我總要這樣待這一切聚集敵我的惡會眾；他們必在這曠野消滅，在這裏死亡。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","摩西所打發、窺探那地的人回來，報那地的惡信，叫全會眾向摩西發怨言， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","這些報惡信的人都遭瘟疫，死在耶和華面前。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","其中惟有嫩的兒子約書亞和耶孚尼的兒子迦勒仍然存活。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","摩西將這些話告訴以色列眾人，他們就甚悲哀。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","清早起來，上山頂去，說：「我們在這裏，我們有罪了；情願上耶和華所應許的地方去。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","摩西說：「你們為何違背耶和華的命令呢？這事不能順利了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","不要上去；因為耶和華不在你們中間，恐怕你們被仇敵殺敗了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","亞瑪力人和迦南人都在你們面前，你們必倒在刀下；因你們退回不跟從耶和華，所以他必不與你們同在。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","他們卻擅敢上山頂去，然而耶和華的約櫃和摩西沒有出營。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","於是亞瑪力人和住在那山上的迦南人都下來擊打他們，把他們殺退了，直到何珥瑪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","耶和華對摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","「你曉諭以色列人說：你們到了我所賜給你們居住的地， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","若願意從牛群羊群中取牛羊作火祭，獻給耶和華，無論是燔祭是平安祭，為要還特許的願，或是作甘心祭，或是逢你們節期獻的，都要奉給耶和華為馨香之祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","那獻供物的就要將細麵伊法十分之一，並油一欣四分之一，調和作素祭，獻給耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","無論是燔祭是平安祭，你要為每隻綿羊羔，一同預備奠祭的酒一欣四分之一。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","為公綿羊預備細麵伊法十分之二，並油一欣三分之一，調和作素祭， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","又用酒一欣三分之一作奠祭，獻給耶和華為馨香之祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","你預備公牛作燔祭，或是作平安祭，為要還特許的願，或是作平安祭，獻給耶和華， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","就要把細麵伊法十分之三，並油半欣，調和作素祭，和公牛一同獻上， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","又用酒半欣作奠祭，獻給耶和華為馨香的火祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","「獻公牛、公綿羊、綿羊羔、山羊羔，每隻都要這樣辦理。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","照你們所預備的數目，按着隻數都要這樣辦理。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","凡本地人將馨香的火祭獻給耶和華，都要這樣辦理。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","若有外人和你們同居，或有人世世代代住在你們中間，願意將馨香的火祭獻給耶和華，你們怎樣辦理，他也要照樣辦理。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","至於會眾，你們和同居的外人都歸一例，作為你們世世代代永遠的定例，在耶和華面前，你們怎樣，寄居的也要怎樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","你們並與你們同居的外人當有一樣的條例，一樣的典章。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","耶和華對摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","「你曉諭以色列人說：你們到了我所領你們進去的那地， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","吃那地的糧食，就要把舉祭獻給耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","你們要用初熟的麥子磨麵，做餅當舉祭奉獻；你們舉上，好像舉禾場的舉祭一樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","你們世世代代要用初熟的麥子磨麵，當舉祭獻給耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","「你們有錯誤的時候，不守耶和華所曉諭摩西的這一切命令， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","就是耶和華藉摩西一切所吩咐你們的，自那日以至你們的世世代代， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","若有誤行，是會眾所不知道的，後來全會眾就要將一隻公牛犢作燔祭，並照典章把素祭和奠祭一同獻給耶和華為馨香之祭，又獻一隻公山羊作贖罪祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","祭司要為以色列全會眾贖罪，他們就必蒙赦免，因為這是錯誤。他們又因自己的錯誤，把供物，就是向耶和華獻的火祭和贖罪祭，一並奉到耶和華面前。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","以色列全會眾和寄居在他們中間的外人就必蒙赦免，因為這罪是百姓誤犯的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","「若有一個人誤犯了罪，他就要獻一歲的母山羊作贖罪祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","那誤行的人犯罪的時候，祭司要在耶和華面前為他贖罪，他就必蒙赦免。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","以色列中的本地人和寄居在他們中間的外人，若誤行了甚麼事，必歸一樣的條例。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","但那擅敢行事的，無論是本地人是寄居的，他褻瀆了耶和華，必從民中剪除。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","因他藐視耶和華的言語，違背耶和華的命令，那人總要剪除；他的罪孽要歸到他身上。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","以色列人在曠野的時候，遇見一個人在安息日撿柴。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","遇見他撿柴的人，就把他帶到摩西、亞倫並全會眾那裏， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","將他收在監內；因為當怎樣辦他，還沒有指明。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","耶和華吩咐摩西說：「總要把那人治死；全會眾要在營外用石頭把他打死。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","於是全會眾將他帶到營外，用石頭打死他，是照耶和華所吩咐摩西的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","耶和華曉諭摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","「你吩咐以色列人，叫他們世世代代在衣服邊上做繸子，又在底邊的繸子上釘一根藍細帶子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","你們佩帶這繸子，好叫你們看見就記念遵行耶和華一切的命令，不隨從自己的心意、眼目行邪淫，像你們素常一樣； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","使你們記念遵行我一切的命令，成為聖潔，歸與你們的上帝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","「我是耶和華－你們的上帝，曾把你們從埃及地領出來，要作你們的上帝。我是耶和華－你們的上帝。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","利未的曾孫、哥轄的孫子、以斯哈的兒子可拉，和呂便子孫中以利押的兒子大坍、亞比蘭，與比勒的兒子安， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","並以色列會中的二百五十個首領，就是有名望選入會中的人，在摩西面前一同起來， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","聚集攻擊摩西、亞倫，說：「你們擅自專權！全會眾個個既是聖潔，耶和華也在他們中間，你們為甚麼自高，超過耶和華的會眾呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","摩西聽見這話就俯伏在地， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","對可拉和他一黨的人說：「到了早晨，耶和華必指示誰是屬他的，誰是聖潔的，就叫誰親近他；他所揀選的是誰，必叫誰親近他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","可拉啊，你們要這樣行，你和你的一黨要拿香爐來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","明日，在耶和華面前，把火盛在爐中，把香放在其上。耶和華揀選誰，誰就為聖潔。你們這利未的子孫擅自專權了！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","摩西又對可拉說：「利未的子孫哪，你們聽我說！ ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","以色列的上帝從以色列會中將你們分別出來，使你們親近他，辦耶和華帳幕的事，並站在會眾面前替他們當差。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","耶和華又使你和你一切弟兄－利未的子孫－一同親近他，這豈為小事？你們還要求祭司的職任嗎？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","你和你一黨的人聚集是要攻擊耶和華。亞倫算甚麼，你們竟向他發怨言呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","摩西打發人去召以利押的兒子大坍、亞比蘭。他們說：「我們不上去！ ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","你將我們從流奶與蜜之地領上來，要在曠野殺我們，這豈為小事？你還要自立為王轄管我們嗎？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","並且你沒有將我們領到流奶與蜜之地，也沒有把田地和葡萄園給我們為業。難道你要剜這些人的眼睛嗎？我們不上去！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","摩西就甚發怒，對耶和華說：「求你不要享受他們的供物。我並沒有奪過他們一匹驢，也沒有害過他們一個人。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","摩西對可拉說：「明天，你和你一黨的人，並亞倫，都要站在耶和華面前； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","各人要拿一個香爐，共二百五十個，把香放在上面，到耶和華面前。你和亞倫也各拿自己的香爐。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","於是他們各人拿一個香爐，盛上火，加上香，同摩西、亞倫站在會幕門前。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","可拉招聚全會眾到會幕門前，要攻擊摩西、亞倫；耶和華的榮光就向全會眾顯現。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","耶和華曉諭摩西、亞倫說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","「你們離開這會眾，我好在轉眼之間把他們滅絕。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","摩西、亞倫就俯伏在地，說：「上帝，萬人之靈的上帝啊，一人犯罪，你就要向全會眾發怒嗎？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","耶和華曉諭摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","「你吩咐會眾說：『你們離開可拉、大坍、亞比蘭帳棚的四圍。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","摩西起來，往大坍、亞比蘭那裏去；以色列的長老也隨着他去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","他吩咐會眾說：「你們離開這惡人的帳棚吧，他們的物件，甚麼都不可摸，恐怕你們陷在他們的罪中，與他們一同消滅。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","於是眾人離開可拉、大坍、亞比蘭帳棚的四圍。大坍、亞比蘭帶着妻子、兒女、小孩子，都出來，站在自己的帳棚門口。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","摩西說：「我行的這一切事本不是憑我自己心意行的，乃是耶和華打發我行的，必有證據使你們知道。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","這些人死若與世人無異，或是他們所遭的與世人相同，就不是耶和華打發我來的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","倘若耶和華創作一件新事，使地開口，把他們和一切屬他們的都吞下去，叫他們活活地墜落陰間，你們就明白這些人是藐視耶和華了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","摩西剛說完了這一切話，他們腳下的地就開了口， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","把他們和他們的家眷，並一切屬可拉的人丁、財物，都吞下去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","這樣，他們和一切屬他們的，都活活地墜落陰間；地口在他們上頭照舊合閉，他們就從會中滅亡。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","在他們四圍的以色列眾人聽他們呼號，就都逃跑，說：「恐怕地也把我們吞下去。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","又有火從耶和華那裏出來，燒滅了那獻香的二百五十個人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","耶和華曉諭摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","「你吩咐祭司亞倫的兒子以利亞撒從火中撿起那些香爐來，把火撒在別處，因為那些香爐是聖的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","把那些犯罪、自害己命之人的香爐，叫人錘成片子，用以包壇。那些香爐本是他們在耶和華面前獻過的，所以是聖的，並且可以給以色列人作記號。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","於是祭司以利亞撒將被燒之人所獻的銅香爐拿來，人就錘出來，用以包壇， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","給以色列人作紀念，使亞倫後裔之外的人不得近前來在耶和華面前燒香，免得他遭可拉和他一黨所遭的。這乃是照耶和華藉着摩西所吩咐的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","第二天，以色列全會眾都向摩西、亞倫發怨言說：「你們殺了耶和華的百姓了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","會眾聚集攻擊摩西、亞倫的時候，向會幕觀看，不料，有雲彩遮蓋了，耶和華的榮光顯現。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","摩西、亞倫就來到會幕前。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","耶和華吩咐摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","「你們離開這會眾，我好在轉眼之間把他們滅絕。」他們二人就俯伏於地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","摩西對亞倫說：「拿你的香爐，把壇上的火盛在其中，又加上香，快快帶到會眾那裏，為他們贖罪；因為有忿怒從耶和華那裏出來，瘟疫已經發作了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","亞倫照着摩西所說的拿來，跑到會中，不料，瘟疫在百姓中已經發作了。他就加上香，為百姓贖罪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","他站在活人死人中間，瘟疫就止住了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","除了因可拉事情死的以外，遭瘟疫死的，共有一萬四千七百人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","亞倫回到會幕門口，到摩西那裏，瘟疫已經止住了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","耶和華對摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","「你曉諭以色列人，從他們手下取杖，每支派一根；從他們所有的首領，按着支派，共取十二根。你要將各人的名字寫在各人的杖上， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","並要將亞倫的名字寫在利未的杖上，因為各族長必有一根杖。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","你要把這些杖存在會幕內法櫃前，就是我與你們相會之處。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","後來我所揀選的那人，他的杖必發芽。這樣，我必使以色列人向你們所發的怨言止息，不再達到我耳中。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","於是摩西曉諭以色列人，他們的首領就把杖交給他，按着支派，每首領一根，共有十二根；亞倫的杖也在其中。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","摩西就把杖存在法櫃的帳幕內，在耶和華面前。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","第二天，摩西進法櫃的帳幕去。誰知利未族亞倫的杖已經發了芽，生了花苞，開了花，結了熟杏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","摩西就把所有的杖從耶和華面前拿出來，給以色列眾人看；他們看見了，各首領就把自己的杖拿去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","耶和華吩咐摩西說：「把亞倫的杖還放在法櫃前，給這些背叛之子留作記號。這樣，你就使他們向我發的怨言止息，免得他們死亡。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","摩西就這樣行。耶和華怎樣吩咐他，他就怎樣行了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","以色列人對摩西說：「我們死啦！我們滅亡啦！都滅亡啦！ ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","凡挨近耶和華帳幕的是必死的。我們都要死亡嗎？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","耶和華對亞倫說：「你和你的兒子，並你本族的人，要一同擔當干犯聖所的罪孽。你和你的兒子也要一同擔當干犯祭司職任的罪孽。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","你要帶你弟兄利未人，就是你祖宗支派的人前來，使他們與你聯合，服事你，只是你和你的兒子，要一同在法櫃的帳幕前供職。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","他們要守所吩咐你的，並守全帳幕，只是不可挨近聖所的器具和壇，免得他們和你們都死亡。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","他們要與你聯合，也要看守會幕，辦理帳幕一切的事，只是外人不可挨近你們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","你們要看守聖所和壇，免得忿怒再臨到以色列人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","我已將你們的弟兄利未人從以色列人中揀選出來歸耶和華，是給你們為賞賜的，為要辦理會幕的事。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","你和你的兒子要為一切屬壇和幔子內的事一同守祭司的職任。你們要這樣供職；我將祭司的職任給你們當作賞賜事奉我。凡挨近的外人必被治死。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","耶和華曉諭亞倫說：「我已將歸我的舉祭，就是以色列人一切分別為聖的物，交給你經管；因你受過膏，把這些都賜給你和你的子孫，當作永得的分。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","以色列人歸給我至聖的供物，就是一切的素祭、贖罪祭、贖愆祭，其中所有存留不經火的，都為至聖之物，要歸給你和你的子孫。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","你要拿這些當至聖物吃；凡男丁都可以吃。你當以此物為聖。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","以色列人所獻的舉祭並搖祭都是你的；我已賜給你和你的兒女，當作永得的分；凡在你家中的潔淨人都可以吃。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","凡油中、新酒中、五穀中至好的，就是以色列人所獻給耶和華初熟之物，我都賜給你。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","凡從他們地上所帶來給耶和華初熟之物也都要歸與你。你家中的潔淨人都可以吃。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","以色列中一切永獻的都必歸與你。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","他們所有奉給耶和華的，連人帶牲畜，凡頭生的，都要歸給你；只是人頭生的，總要贖出來；不潔淨牲畜頭生的，也要贖出來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","其中在一月之外所當贖的，要照你所估定的價，按聖所的平，用銀子五舍客勒贖出來（一舍客勒是二十季拉）。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","只是頭生的牛，或是頭生的綿羊和山羊，必不可贖，都是聖的，要把牠的血灑在壇上，把牠的脂油焚燒，當作馨香的火祭獻給耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","牠的肉必歸你，像被搖的胸、被舉的右腿歸你一樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","凡以色列人所獻給耶和華聖物中的舉祭，我都賜給你和你的兒女，當作永得的分。這是給你和你的後裔、在耶和華面前作為永遠的鹽約。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","耶和華對亞倫說：「你在以色列人的境內不可有產業，在他們中間也不可有分。我就是你的分，是你的產業。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","「凡以色列中出產的十分之一，我已賜給利未的子孫為業；因他們所辦的是會幕的事，所以賜給他們為酬他們的勞。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","從今以後，以色列人不可挨近會幕，免得他們擔罪而死。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","惟獨利未人要辦會幕的事，擔當罪孽；這要作你們世世代代永遠的定例。他們在以色列人中不可有產業； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","因為以色列人中出產的十分之一，就是獻給耶和華為舉祭的，我已賜給利未人為業。所以我對他們說：『在以色列人中不可有產業。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","耶和華吩咐摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","「你曉諭利未人說：你們從以色列人中所取的十分之一，就是我給你們為業的，要再從那十分之一中取十分之一作為舉祭獻給耶和華， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","這舉祭要算為你們場上的穀，又如滿酒醡的酒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","這樣，你們從以色列人中所得的十分之一也要作舉祭獻給耶和華，從這十分之一中，將所獻給耶和華的舉祭歸給祭司亞倫。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","奉給你們的一切禮物，要從其中將至好的，就是分別為聖的，獻給耶和華為舉祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","所以你要對利未人說：你們從其中將至好的舉起，這就算為你們場上的糧，又如酒醡的酒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","你們和你們家屬隨處可以吃；這原是你們的賞賜，是酬你們在會幕裏辦事的勞。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","你們從其中將至好的舉起，就不致因這物擔罪。你們不可褻瀆以色列人的聖物，免得死亡。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","耶和華曉諭摩西、亞倫說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","「耶和華命定律法中的一條律例乃是這樣說：你要吩咐以色列人，把一隻沒有殘疾、未曾負軛、純紅的母牛牽到你這裏來， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","交給祭司以利亞撒；他必牽到營外，人就把牛宰在他面前。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","祭司以利亞撒要用指頭蘸這牛的血，向會幕前面彈七次。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","人要在他眼前把這母牛焚燒；牛的皮、肉、血、糞都要焚燒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","祭司要把香柏木、牛膝草、朱紅色線都丟在燒牛的火中。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","祭司必不潔淨到晚上，要洗衣服，用水洗身，然後可以進營。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","燒牛的人必不潔淨到晚上，也要洗衣服，用水洗身。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","必有一個潔淨的人收起母牛的灰，存在營外潔淨的地方，為以色列會眾調做除污穢的水。這本是除罪的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","收起母牛灰的人必不潔淨到晚上，要洗衣服。這要給以色列人和寄居在他們中間的外人作為永遠的定例。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","「摸了人死屍的，就必七天不潔淨。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","那人到第三天要用這除污穢的水潔淨自己，第七天就潔淨了。他若在第三天不潔淨自己，第七天就不潔淨了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","凡摸了人死屍、不潔淨自己的，就玷污了耶和華的帳幕，這人必從以色列中剪除；因為那除污穢的水沒有灑在他身上，他就為不潔淨，污穢還在他身上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","「人死在帳棚裏的條例乃是這樣：凡進那帳棚的，和一切在帳棚裏的，都必七天不潔淨。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","凡敞口的器皿，就是沒有紮上蓋的，也是不潔淨。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","無論何人在田野裏摸了被刀殺的，或是屍首，或是人的骨頭，或是墳墓，就要七天不潔淨。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","要為這不潔淨的人拿些燒成的除罪灰放在器皿裏，倒上活水。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","必當有一個潔淨的人拿牛膝草蘸在這水中，把水灑在帳棚上，和一切器皿並帳棚內的眾人身上，又灑在摸了骨頭，或摸了被殺的，或摸了自死的，或摸了墳墓的那人身上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","第三天和第七天，潔淨的人要灑水在不潔淨的人身上，第七天就使他成為潔淨。那人要洗衣服，用水洗澡，到晚上就潔淨了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","「但那污穢而不潔淨自己的，要將他從會中剪除，因為他玷污了耶和華的聖所。除污穢的水沒有灑在他身上，他是不潔淨的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","這要給你們作為永遠的定例。並且那灑除污穢水的人要洗衣服。凡摸除污穢水的，必不潔淨到晚上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","不潔淨人所摸的一切物就不潔淨；摸了這物的人必不潔淨到晚上。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","正月間，以色列全會眾到了尋的曠野，就住在加低斯。米利暗死在那裏，就葬在那裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","會眾沒有水喝，就聚集攻擊摩西、亞倫。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","百姓向摩西爭鬧說：「我們的弟兄曾死在耶和華面前，我們恨不得與他們同死。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","你們為何把耶和華的會眾領到這曠野、使我們和牲畜都死在這裏呢？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","你們為何逼着我們出埃及、領我們到這壞地方呢？這地方不好撒種，也沒有無花果樹、葡萄樹、石榴樹，又沒有水喝。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","摩西、亞倫離開會眾，到會幕門口，俯伏在地；耶和華的榮光向他們顯現。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","耶和華曉諭摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","「你拿着杖去，和你的哥哥亞倫招聚會眾，在他們眼前吩咐磐石發出水來，水就從磐石流出，給會眾和他們的牲畜喝。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","於是摩西照耶和華所吩咐的，從耶和華面前取了杖去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","摩西、亞倫就招聚會眾到磐石前。摩西說：「你們這些背叛的人聽我說：我為你們使水從這磐石中流出來嗎？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","摩西舉手，用杖擊打磐石兩下，就有許多水流出來，會眾和他們的牲畜都喝了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","耶和華對摩西、亞倫說：「因為你們不信我，不在以色列人眼前尊我為聖，所以你們必不得領這會眾進我所賜給他們的地去。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","這水名叫米利巴水，是因以色列人向耶和華爭鬧，耶和華就在他們面前顯為聖。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","摩西從加低斯差遣使者去見以東王，說：「你的弟兄以色列人這樣說：『我們所遭遇的一切艱難， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","就是我們的列祖下到埃及，我們在埃及久住；埃及人惡待我們的列祖和我們， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","我們哀求耶和華的時候，他聽了我們的聲音，差遣使者把我們從埃及領出來。這事你都知道。如今，我們在你邊界上的城加低斯。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","求你容我們從你的地經過。我們不走田間和葡萄園，也不喝井裏的水，只走大道，不偏左右，直到過了你的境界。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","以東王說：「你不可從我的地經過，免得我帶刀出去攻擊你。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","以色列人說：「我們要走大道上去；我們和牲畜若喝你的水，必給你價值。不求別的，只求你容我們步行過去。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","以東王說：「你們不可經過！」就率領許多人出來，要用強硬的手攻擊以色列人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","這樣，以東王不肯容以色列人從他的境界過去。於是他們轉去，離開他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","以色列全會眾從加低斯起行，到了何珥山。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","耶和華在附近以東邊界的何珥山上曉諭摩西、亞倫說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","「亞倫要歸到他列祖那裏。他必不得入我所賜給以色列人的地；因為在米利巴水，你們違背了我的命。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","你帶亞倫和他的兒子以利亞撒上何珥山， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","把亞倫的聖衣脫下來，給他的兒子以利亞撒穿上；亞倫必死在那裏，歸他列祖。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","摩西就照耶和華所吩咐的行。三人當着會眾的眼前上了何珥山。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","摩西把亞倫的聖衣脫下來，給他的兒子以利亞撒穿上，亞倫就死在山頂那裏。於是摩西和以利亞撒下了山。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","全會眾，就是以色列全家，見亞倫已經死了，便都為亞倫哀哭了三十天。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","住南地的迦南人亞拉得王，聽說以色列人從亞他林路來，就和以色列人爭戰，擄了他們幾個人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","以色列人向耶和華發願說：「你若將這民交付我手，我就把他們的城邑盡行毀滅。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","耶和華應允了以色列人，把迦南人交付他們，他們就把迦南人和迦南人的城邑盡行毀滅。那地方的名便叫何珥瑪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","他們從何珥山起行，往紅海那條路走，要繞過以東地。百姓因這路難行，心中甚是煩躁， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","就怨讟上帝和摩西說：「你們為甚麼把我們從埃及領出來、使我們死在曠野呢？這裏沒有糧，沒有水，我們的心厭惡這淡薄的食物。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","於是耶和華使火蛇進入百姓中間，蛇就咬他們。以色列人中死了許多。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","百姓到摩西那裏，說：「我們怨讟耶和華和你，有罪了。求你禱告耶和華，叫這些蛇離開我們。」於是摩西為百姓禱告。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","耶和華對摩西說：「你製造一條火蛇，掛在杆子上；凡被咬的，一望這蛇，就必得活。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","摩西便製造一條銅蛇，掛在杆子上；凡被蛇咬的，一望這銅蛇就活了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","以色列人起行，安營在阿伯。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","又從阿伯起行，安營在以耶‧亞巴琳，與摩押相對的曠野，向日出之地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","從那裏起行，安營在撒烈谷。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","從那裏起行，安營在亞嫩河那邊。這亞嫩河是在曠野，從亞摩利的境界流出來的；原來亞嫩河是摩押的邊界，在摩押和亞摩利人搭界的地方。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","所以耶和華的戰記上說：「蘇法的哇哈伯與亞嫩河的谷， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","並向亞珥城眾谷的下坡，是靠近摩押的境界。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","以色列人從那裏起行，到了比珥。從前耶和華吩咐摩西說：「招聚百姓，我好給他們水喝」，說的就是這井。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","當時，以色列人唱歌說： 井啊，湧上水來！ 你們要向這井歌唱。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","這井是首領和民中的尊貴人 用圭用杖所挖所掘的。 以色列人從曠野往瑪他拿去， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","從瑪他拿到拿哈列，從拿哈列到巴末， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","從巴末到摩押地的谷，又到那下望曠野之毗斯迦的山頂。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","以色列人差遣使者去見亞摩利人的王西宏，說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","「求你容我們從你的地經過；我們不偏入田間和葡萄園，也不喝井裏的水，只走大道，直到過了你的境界。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","西宏不容以色列人從他的境界經過，就招聚他的眾民出到曠野，要攻擊以色列人，到了雅雜與以色列人爭戰。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","以色列人用刀殺了他，得了他的地，從亞嫩河到雅博河，直到亞捫人的境界，因為亞捫人的境界多有堅壘。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","以色列人奪取這一切的城邑，也住亞摩利人的城邑，就是希實本與希實本的一切鄉村。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","這希實本是亞摩利王西宏的京城；西宏曾與摩押的先王爭戰，從他手中奪取了全地，直到亞嫩河。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","所以那些作詩歌的說： 你們來到希實本； 願西宏的城被修造，被建立。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","因為有火從希實本發出， 有火焰出於西宏的城， 燒盡摩押的亞珥和亞嫩河邱壇的祭司。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","摩押啊，你有禍了！ 基抹的民哪，你們滅亡了！ 基抹的男子逃奔， 女子被擄，交付亞摩利的王西宏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","我們射了他們； 希實本直到底本盡皆毀滅。 我們使地變成荒場，直到挪法； 這挪法直延到米底巴。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","這樣，以色列人就住在亞摩利人之地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","摩西打發人去窺探雅謝，以色列人就佔了雅謝的鎮市，趕出那裏的亞摩利人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","以色列人轉回，向巴珊去。巴珊王噩和他的眾民都出來，在以得來與他們交戰。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","耶和華對摩西說：「不要怕他！因我已將他和他的眾民，並他的地，都交在你手中；你要待他像從前待住希實本的亞摩利王西宏一般。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","於是他們殺了他和他的眾子，並他的眾民，沒有留下一個，就得了他的地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","以色列人起行，在摩押平原、約旦河東，對着耶利哥安營。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","以色列人向亞摩利人所行的一切事，西撥的兒子巴勒都看見了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","摩押人因以色列民甚多，就大大懼怕，心內憂急， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","對米甸的長老說：「現在這眾人要把我們四圍所有的一概餂盡，就如牛餂盡田間的草一般。」那時西撥的兒子巴勒作摩押王。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","他差遣使者往大河邊的毗奪去，到比珥的兒子巴蘭本鄉那裏，召巴蘭來，說：「有一宗民從埃及出來，遮滿地面，與我對居。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","這民比我強盛，現在求你來為我咒詛他們，或者我能得勝，攻打他們，趕出此地。因為我知道，你為誰祝福，誰就得福；你咒詛誰，誰就受咒詛。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","摩押的長老和米甸的長老手裏拿着卦金，到了巴蘭那裏，將巴勒的話都告訴了他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","巴蘭說：「你們今夜在這裏住宿，我必照耶和華所曉諭我的回報你們。」摩押的使臣就在巴蘭那裏住下了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","上帝臨到巴蘭那裏，說：「在你這裏的人都是誰？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","巴蘭回答說：「是摩押王西撥的兒子巴勒打發人到我這裏來，說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","『從埃及出來的民遮滿地面，你來為我咒詛他們，或者我能與他們爭戰，把他們趕出去。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","上帝對巴蘭說：「你不可同他們去，也不可咒詛那民，因為那民是蒙福的。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","巴蘭早晨起來，對巴勒的使臣說：「你們回本地去吧，因為耶和華不容我和你們同去。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","摩押的使臣就起來，回巴勒那裏去，說：「巴蘭不肯和我們同來。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","巴勒又差遣使臣，比先前的又多又尊貴。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","他們到了巴蘭那裏，對他說：「西撥的兒子巴勒這樣說：『求你不容甚麼事攔阻你不到我這裏來， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","因為我必使你得極大的尊榮。你向我要甚麼，我就給你甚麼；只求你來為我咒詛這民。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","巴蘭回答巴勒的臣僕說：「巴勒就是將他滿屋的金銀給我，我行大事小事也不得越過耶和華－我上帝的命。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","現在我請你們今夜在這裏住宿，等我得知耶和華還要對我說甚麼。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","當夜，上帝臨到巴蘭那裏，說：「這些人若來召你，你就起來同他們去，你只要遵行我對你所說的話。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","巴蘭早晨起來，備上驢，和摩押的使臣一同去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","上帝因他去就發了怒；耶和華的使者站在路上敵擋他。他騎着驢，有兩個僕人跟隨他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","驢看見耶和華的使者站在路上，手裏有拔出來的刀，就從路上跨進田間，巴蘭便打驢，要叫牠回轉上路。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","耶和華的使者就站在葡萄園的窄路上；這邊有牆，那邊也有牆。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","驢看見耶和華的使者，就貼靠牆，將巴蘭的腳擠傷了；巴蘭又打驢。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","耶和華的使者又往前去，站在狹窄之處，左右都沒有轉折的地方。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","驢看見耶和華的使者，就臥在巴蘭底下，巴蘭發怒，用杖打驢。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","耶和華叫驢開口，對巴蘭說：「我向你行了甚麼，你竟打我這三次呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","巴蘭對驢說：「因為你戲弄我，我恨不能手中有刀，把你殺了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","驢對巴蘭說：「我不是你從小時直到今日所騎的驢嗎？我素常向你這樣行過嗎？」巴蘭說：「沒有。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","當時，耶和華使巴蘭的眼目明亮，他就看見耶和華的使者站在路上，手裏有拔出來的刀，巴蘭便低頭俯伏在地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","耶和華的使者對他說：「你為何這三次打你的驢呢？我出來敵擋你，因你所行的，在我面前偏僻。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","驢看見我就三次從我面前偏過去；驢若沒有偏過去，我早把你殺了，留牠存活。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","巴蘭對耶和華的使者說：「我有罪了。我不知道你站在路上阻擋我；你若不喜歡我去，我就轉回。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","耶和華的使者對巴蘭說：「你同這些人去吧！你只要說我對你說的話。」於是巴蘭同着巴勒的使臣去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","巴勒聽見巴蘭來了，就往摩押京城去迎接他；這城是在邊界上，在亞嫩河旁。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","巴勒對巴蘭說：「我不是急急地打發人到你那裏去召你嗎？你為何不到我這裏來呢？我豈不能使你得尊榮嗎？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","巴蘭說：「我已經到你這裏來了！現在我豈能擅自說甚麼呢？上帝將甚麼話傳給我，我就說甚麼。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","巴蘭和巴勒同行，來到基列‧胡瑣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","巴勒宰了牛羊，送給巴蘭和陪伴的使臣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","到了早晨，巴勒領巴蘭到巴力的高處；巴蘭從那裏觀看以色列營的邊界。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","巴蘭對巴勒說：「你在這裏給我築七座壇，為我預備七隻公牛，七隻公羊。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","巴勒照巴蘭的話行了。巴勒和巴蘭在每座壇上獻一隻公牛，一隻公羊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","巴蘭對巴勒說：「你站在你的燔祭旁邊，我且往前去，或者耶和華來迎見我。他指示我甚麼，我必告訴你。」於是巴蘭上一淨光的高處。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","上帝迎見巴蘭；巴蘭說：「我預備了七座壇，在每座壇上獻了一隻公牛，一隻公羊。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","耶和華將話傳給巴蘭，又說：「你回到巴勒那裏，要如此如此說。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","他就回到巴勒那裏，見他同摩押的使臣都站在燔祭旁邊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","巴蘭便題起詩歌說： 巴勒引我出亞蘭， 摩押王引我出東山，說： 來啊，為我咒詛雅各； 來啊，怒罵以色列。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","上帝沒有咒詛的，我焉能咒詛？ 耶和華沒有怒罵的，我焉能怒罵？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","我從高峰看他，從小山望他； 這是獨居的民，不列在萬民中。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","誰能數點雅各的塵土？ 誰能計算以色列的四分之一？ 我願如義人之死而死； 我願如義人之終而終。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","巴勒對巴蘭說：「你向我做的是甚麼事呢？我領你來咒詛我的仇敵，不料，你竟為他們祝福。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","他回答說：「耶和華傳給我的話，我能不謹慎傳說嗎？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","巴勒說：「求你同我往別處去，在那裏可以看見他們；你不能全看見，只能看見他們邊界上的人。在那裏要為我咒詛他們。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","於是領巴蘭到了瑣腓田，上了毗斯迦山頂，築了七座壇；每座壇上獻一隻公牛，一隻公羊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","巴蘭對巴勒說：「你站在這燔祭旁邊，等我往那邊去迎見耶和華。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","耶和華臨到巴蘭那裏，將話傳給他；又說：「你回到巴勒那裏，要如此如此說。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","他就回到巴勒那裏，見他站在燔祭旁邊；摩押的使臣也和他在一處。巴勒問他說：「耶和華說了甚麼話呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","巴蘭就題詩歌說： 巴勒，你起來聽； 西撥的兒子，你聽我言。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","上帝非人，必不致說謊， 也非人子，必不致後悔。 他說話豈不照着行呢？ 他發言豈不要成就呢？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","我奉命祝福； 上帝也曾賜福，此事我不能翻轉。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","他未見雅各中有罪孽， 也未見以色列中有奸惡。 耶和華－他的上帝和他同在； 有歡呼王的聲音在他們中間。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","上帝領他們出埃及； 他們似乎有野牛之力。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","斷沒有法術可以害雅各， 也沒有占卜可以害以色列。 現在必有人論及雅各，就是論及以色列說： 上帝為他行了何等的大事！ ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","這民起來，彷彿母獅， 挺身，好像公獅， 未曾吃野食， 未曾喝被傷者之血，決不躺臥。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","巴勒對巴蘭說：「你一點不要咒詛他們，也不要為他們祝福。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","巴蘭回答巴勒說：「我豈不是告訴你說『凡耶和華所說的，我必須遵行』嗎？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","巴勒對巴蘭說：「來吧，我領你往別處去，或者上帝喜歡你在那裏為我咒詛他們。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","巴勒就領巴蘭到那下望曠野的毗珥山頂上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","巴蘭對巴勒說：「你在這裏為我築七座壇，又在這裏為我預備七隻公牛，七隻公羊。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","巴勒就照巴蘭的話行，在每座壇上獻一隻公牛，一隻公羊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","巴蘭見耶和華喜歡賜福與以色列，就不像前兩次去求法術，卻面向曠野。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","巴蘭舉目，看見以色列人照着支派居住。上帝的靈就臨到他身上， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","他便題起詩歌說： 比珥的兒子巴蘭說， 眼目閉住的人說， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","得聽上帝的言語， 得見全能者的異象， 眼目睜開而仆倒的人說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","雅各啊，你的帳棚何等華美！ 以色列啊，你的帳幕何其華麗！ ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","如接連的山谷， 如河旁的園子， 如耶和華所栽的沉香樹， 如水邊的香柏木。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","水要從他的桶裏流出； 種子要撒在多水之處。 他的王必超過亞甲； 他的國必要振興。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","上帝領他出埃及； 他似乎有野牛之力。 他要吞吃敵國， 折斷他們的骨頭， 用箭射透他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","他蹲如公獅， 臥如母獅，誰敢惹他？ 凡給你祝福的，願他蒙福； 凡咒詛你的，願他受咒詛。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","巴勒向巴蘭生氣，就拍起手來，對巴蘭說：「我召你來為我咒詛仇敵，不料，你這三次竟為他們祝福。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","如今你快回本地去吧！我想使你得大尊榮，耶和華卻阻止你不得尊榮。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","巴蘭對巴勒說：「我豈不是對你所差遣到我那裏的使者說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","『巴勒就是將他滿屋的金銀給我，我也不得越過耶和華的命，憑自己的心意行好行歹。耶和華說甚麼，我就要說甚麼』？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","「現在我要回本族去。你來，我告訴你這民日後要怎樣待你的民。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","他就題起詩歌說： 比珥的兒子巴蘭說： 眼目閉住的人說， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","得聽上帝的言語， 明白至高者的意旨， 看見全能者的異象， 眼目睜開而仆倒的人說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","我看他卻不在現時； 我望他卻不在近日。 有星要出於雅各，有杖要興於以色列， 必打破摩押的四角，毀壞擾亂之子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","他必得以東為基業， 又得仇敵之地西珥為產業； 以色列必行事勇敢。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","有一位出於雅各的，必掌大權； 他要除滅城中的餘民。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","巴蘭觀看亞瑪力，就題起詩歌說： 亞瑪力原為諸國之首， 但他終必沉淪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","巴蘭觀看基尼人，就題起詩歌說： 你的住處本是堅固； 你的窩巢做在巖穴中。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","然而基尼必至衰微， 直到亞述把你擄去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","巴蘭又題起詩歌說： 哀哉！上帝行這事，誰能得活？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","必有人乘船從基提界而來， 苦害亞述，苦害希伯； 他也必至沉淪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","於是巴蘭起來，回他本地去；巴勒也回去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","以色列人住在什亭，百姓與摩押女子行起淫亂。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","因為這女子叫百姓來，一同給她們的神獻祭，百姓就吃她們的祭物，跪拜她們的神。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","以色列人與巴力‧毗珥連合，耶和華的怒氣就向以色列人發作。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","耶和華吩咐摩西說：「將百姓中所有的族長在我面前對着日頭懸掛，使我向以色列人所發的怒氣可以消了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","於是摩西吩咐以色列的審判官說：「凡屬你們的人，有與巴力‧毗珥連合的，你們各人要把他們殺了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","摩西和以色列全會眾正在會幕門前哭泣的時候，誰知，有以色列中的一個人，當他們眼前，帶着一個米甸女人到他弟兄那裏去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","祭司亞倫的孫子，以利亞撒的兒子非尼哈看見了，就從會中起來，手裏拿着槍， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","跟隨那以色列人進亭子裏去，便將以色列人和那女人由腹中刺透。這樣，在以色列人中瘟疫就止息了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","那時遭瘟疫死的，有二萬四千人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","耶和華曉諭摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","「祭司亞倫的孫子，以利亞撒的兒子非尼哈，使我向以色列人所發的怒消了；因他在他們中間，以我的忌邪為心，使我不在忌邪中把他們除滅。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","因此，你要說：『我將我平安的約賜給他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","這約要給他和他的後裔，作為永遠當祭司職任的約；因他為上帝有忌邪的心，為以色列人贖罪。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","那與米甸女人一同被殺的以色列人，名叫心利，是撒路的兒子，是西緬一個宗族的首領。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","那被殺的米甸女人，名叫哥斯比，是蘇珥的女兒；這蘇珥是米甸一個宗族的首領。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","耶和華曉諭摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","「你要擾害米甸人，擊殺他們； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","因為他們用詭計擾害你們，在毗珥的事上和他們的姊妹、米甸首領的女兒哥斯比的事上，用這詭計誘惑了你們；這哥斯比，當瘟疫流行的日子，因毗珥的事被殺了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","瘟疫之後，耶和華曉諭摩西和祭司亞倫的兒子以利亞撒說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","「你們要將以色列全會眾，按他們的宗族，凡以色列中從二十歲以外、能出去打仗的，計算總數。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","摩西和祭司以利亞撒在摩押平原與耶利哥相對的約旦河邊向以色列人說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","「將你們中間從二十歲以外的計算總數」；是照耶和華吩咐出埃及地的摩西和以色列人的話。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","以色列的長子是呂便。呂便的眾子：屬哈諾的，有哈諾族；屬法路的，有法路族； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","屬希斯倫的，有希斯倫族；屬迦米的，有迦米族； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","這就是呂便的各族；其中被數的，共有四萬三千七百三十名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","法路的兒子是以利押。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","以利押的眾子是尼母利、大坍、亞比蘭。這大坍、亞比蘭，就是從會中選召的，與可拉一黨同向耶和華爭鬧的時候也向摩西、亞倫爭鬧； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","地便開口吞了他們，和可拉、可拉的黨類一同死亡。那時火燒滅了二百五十個人；他們就作了警戒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","然而可拉的眾子沒有死亡。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","按着家族，西緬的眾子：屬尼母利的，有尼母利族；屬雅憫的，有雅憫族；屬雅斤的，有雅斤族； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","屬謝拉的，有謝拉族；屬掃羅的，有掃羅族。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","這就是西緬的各族，共有二萬二千二百名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","按着家族，迦得的眾子：屬洗分的，有洗分族；屬哈基的，有哈基族；屬書尼的，有書尼族； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","屬阿斯尼的，有阿斯尼族；屬以利的，有以利族； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","屬亞律的，有亞律族；屬亞列利的，有亞列利族。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","這就是迦得子孫的各族，照他們中間被數的，共有四萬零五百名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","猶大的兒子是珥和俄南。這珥和俄南死在迦南地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","按着家族，猶大其餘的眾子：屬示拉的，有示拉族；屬法勒斯的，有法勒斯族；屬謝拉的，有謝拉族。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","法勒斯的兒子：屬希斯崙的，有希斯崙族；屬哈母勒的，有哈母勒族。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","這就是猶大的各族，照他們中間被數的，共有七萬六千五百名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","按着家族，以薩迦的眾子：屬陀拉的，有陀拉族；屬普瓦的，有普瓦族； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","屬雅述的，有雅述族；屬伸崙的，有伸崙族。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","這就是以薩迦的各族，照他們中間被數的，共有六萬四千三百名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","按着家族，西布倫的眾子：屬西烈的，有西烈族；屬以倫的，有以倫族；屬雅利的，有雅利族。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","這就是西布倫的各族，照他們中間被數的，共有六萬零五百名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","按着家族，約瑟的兒子有瑪拿西、以法蓮。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","瑪拿西的眾子：屬瑪吉的，有瑪吉族；瑪吉生基列；屬基列的，有基列族。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","基列的眾子：屬伊以謝的，有伊以謝族；屬希勒的，有希勒族； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","屬亞斯烈的，有亞斯烈族；屬示劍的，有示劍族； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","屬示米大的，有示米大族；屬希弗的，有希弗族。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","希弗的兒子：西羅非哈沒兒子，只有女兒。西羅非哈女兒的名字就是瑪拉、挪阿、曷拉、密迦、得撒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","這就是瑪拿西的各族；他們中間被數的，共有五萬二千七百名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","按着家族，以法蓮的眾子：屬書提拉的，有書提拉族；屬比結的，有比結族；屬他罕的，有他罕族。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","書提拉的眾子：屬以蘭的，有以蘭族。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","這就是以法蓮子孫的各族，照他們中間被數的，共有三萬二千五百名。按着家族，這都是約瑟的子孫。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","按着家族，便雅憫的眾子：屬比拉的，有比拉族；屬亞實別的，有亞實別族；屬亞希蘭的，有亞希蘭族； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","屬書反的，有書反族；屬戶反的，有戶反族。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","比拉的眾子是亞勒、乃幔。屬 亞勒 的，有亞勒族；屬乃幔的，有乃幔族。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","按着家族，這就是便雅憫的子孫，其中被數的，共有四萬五千六百名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","按着家族，但的眾子：屬書含的，有書含族。按着家族，這就是但的各族。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","照其中被數的，書含所有的各族，共有六萬四千四百名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","按着家族，亞設的眾子：屬音拿的，有音拿族；屬亦施韋的，有亦施韋族；屬比利亞的，有比利亞族。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","比利亞的眾子：屬希別的，有希別族；屬瑪結的，有瑪結族。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","亞設的女兒名叫西拉。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","這就是亞設子孫的各族，照他們中間被數的，共有五萬三千四百名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","按着家族，拿弗他利的眾子：屬雅薛的，有雅薛族；屬沽尼的，有沽尼族； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","屬耶色的，有耶色族；屬示冷的，有示冷族。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","按着家族，這就是拿弗他利的各族；他們中間被數的，共有四萬五千四百名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","以色列人中被數的，共有六十萬零一千七百三十名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","耶和華曉諭摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","「你要按着人名的數目將地分給這些人為業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","人多的，你要把產業多分給他們；人少的，你要把產業少分給他們；要照被數的人數，把產業分給各人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","雖是這樣，還要拈鬮分地。他們要按着祖宗各支派的名字承受為業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","要按着所拈的鬮，看人數多，人數少，把產業分給他們。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","利未人，按着他們的各族被數的：屬革順的，有革順族；屬哥轄的，有哥轄族；屬米拉利的，有米拉利族。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","利未的各族有立尼族、希伯倫族、瑪利族、母示族、可拉族。哥轄生暗蘭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","暗蘭的妻名叫約基別，是利未女子，生在埃及。她給暗蘭生了亞倫、摩西，並他們的姊姊米利暗。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","亞倫生拿答、亞比戶、以利亞撒、以他瑪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","拿答、亞比戶在耶和華面前獻凡火的時候就死了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","利未人中，凡一個月以外、被數的男丁，共有二萬三千。他們本來沒有數在以色列人中；因為在以色列人中，沒有分給他們產業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","這些就是被摩西和祭司以利亞撒所數的；他們在摩押平原與耶利哥相對的約旦河邊數點以色列人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","但被數的人中，沒有一個是摩西和祭司亞倫從前在西奈的曠野所數的以色列人， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","因為耶和華論到他們說：「他們必要死在曠野。」所以，除了耶孚尼的兒子迦勒和嫩的兒子約書亞以外，連一個人也沒有存留。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","屬約瑟的兒子瑪拿西的各族，有瑪拿西的玄孫，瑪吉的曾孫，基列的孫子，希弗的兒子西羅非哈的女兒，名叫瑪拉、挪阿、曷拉、密迦、得撒。她們前來， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","站在會幕門口，在摩西和祭司以利亞撒，並眾首領與全會眾面前，說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","「我們的父親死在曠野。他不與可拉同黨聚集攻擊耶和華，是在自己罪中死的；他也沒有兒子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","為甚麼因我們的父親沒有兒子就把他的名從他族中除掉呢？求你們在我們父親的弟兄中分給我們產業。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","於是，摩西將她們的案件呈到耶和華面前。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","耶和華曉諭摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","「西羅非哈的女兒說得有理。你定要在她們父親的弟兄中，把地分給她們為業；要將她們父親的產業歸給她們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","你也要曉諭以色列人說：『人若死了沒有兒子，就要把他的產業歸給他的女兒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","他若沒有女兒，就要把他的產業給他的弟兄。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","他若沒有弟兄，就要把他的產業給他父親的弟兄。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","他父親若沒有弟兄，就要把他的產業給他族中最近的親屬，他便要得為業。』這要作以色列人的律例典章，是照耶和華吩咐摩西的。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","耶和華對摩西說：「你上這亞巴琳山，觀看我所賜給以色列人的地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","看了以後，你也必歸到你列祖那裏，像你哥哥亞倫一樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","因為你們在尋的曠野，當會眾爭鬧的時候，違背了我的命，沒有在湧水之地、會眾眼前尊我為聖。」（這水就是尋的曠野加低斯米利巴水。） ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","摩西對耶和華說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","「願耶和華萬人之靈的上帝，立一個人治理會眾， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","可以在他們面前出入，也可以引導他們，免得耶和華的會眾如同沒有牧人的羊群一般。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","耶和華對摩西說：「嫩的兒子約書亞是心中有聖靈的；你將他領來，按手在他頭上， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","使他站在祭司以利亞撒和全會眾面前，囑咐他， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","又將你的尊榮給他幾分，使以色列全會眾都聽從他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","他要站在祭司以利亞撒面前；以利亞撒要憑烏陵的判斷，在耶和華面前為他求問。他和以色列全會眾都要遵以利亞撒的命出入。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","於是摩西照耶和華所吩咐的將約書亞領來，使他站在祭司以利亞撒和全會眾面前， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","按手在他頭上，囑咐他，是照耶和華藉摩西所說的話。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","耶和華曉諭摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","「你要吩咐以色列人說：『獻給我的供物，就是獻給我作馨香火祭的食物，你們要按日期獻給我』； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","又要對他們說：你們要獻給耶和華的火祭，就是沒有殘疾、一歲的公羊羔，每日兩隻，作為常獻的燔祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","早晨要獻一隻，黃昏的時候要獻一隻； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","又用細麵伊法十分之一，並搗成的油一欣四分之一，調和作為素祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","這是西奈山所命定為常獻的燔祭，是獻給耶和華為馨香的火祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","為這一隻羊羔，要同獻奠祭的酒一欣四分之一。在聖所中，你要將醇酒奉給耶和華為奠祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","晚上，你要獻那一隻羊羔，必照早晨的素祭和同獻的奠祭獻上，作為馨香的火祭，獻給耶和華。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","「當安息日，要獻兩隻沒有殘疾、一歲的公羊羔，並用調油的細麵伊法十分之二為素祭，又將同獻的奠祭獻上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","這是每安息日獻的燔祭；那常獻的燔祭和同獻的奠祭在外。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","「每月朔，你們要將兩隻公牛犢，一隻公綿羊，七隻沒有殘疾、一歲的公羊羔，獻給耶和華為燔祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","每隻公牛要用調油的細麵伊法十分之三作為素祭；那隻公羊也用調油的細麵伊法十分之二作為素祭； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","每隻羊羔要用調油的細麵伊法十分之一作為素祭和馨香的燔祭，是獻給耶和華的火祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","一隻公牛要奠酒半欣，一隻公羊要奠酒一欣三分之一，一隻羊羔也奠酒一欣四分之一。這是每月的燔祭，一年之中要月月如此。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","又要將一隻公山羊為贖罪祭，獻給耶和華；要獻在常獻的燔祭和同獻的奠祭以外。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","「正月十四日是耶和華的逾越節。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","這月十五日是節期，要吃無酵餅七日。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","第一日當有聖會；甚麼勞碌的工都不可做。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","當將公牛犢兩隻，公綿羊一隻，一歲的公羊羔七隻，都要沒有殘疾的，用火獻給耶和華為燔祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","同獻的素祭用調油的細麵；為一隻公牛要獻伊法十分之三；為一隻公羊要獻伊法十分之二； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","為那七隻羊羔，每隻要獻伊法十分之一。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","並獻一隻公山羊作贖罪祭，為你們贖罪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","你們獻這些，要在早晨常獻的燔祭以外。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","一連七日，每日要照這例把馨香火祭的食物獻給耶和華，是在常獻的燔祭和同獻的奠祭以外。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","第七日當有聖會，甚麼勞碌的工都不可做。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","「七七節莊稼初熟，你們獻新素祭給耶和華的日子，當有聖會；甚麼勞碌的工都不可做。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","只要將公牛犢兩隻，公綿羊一隻，一歲的公羊羔七隻，作為馨香的燔祭獻給耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","同獻的素祭用調油的細麵；為每隻公牛要獻伊法十分之三；為一隻公羊要獻伊法十分之二； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","為那七隻羊羔，每隻要獻伊法十分之一。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","並獻一隻公山羊為你們贖罪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","這些，你們要獻在常獻的燔祭和同獻的素祭並同獻的奠祭以外，都要沒有殘疾的。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","「七月初一日，你們當有聖會；甚麼勞碌的工都不可做，是你們當守為吹角的日子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","你們要將公牛犢一隻，公綿羊一隻，沒有殘疾、一歲的公羊羔七隻，作為馨香的燔祭獻給耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","同獻的素祭用調油的細麵；為一隻公牛要獻伊法十分之三；為一隻公羊要獻伊法十分之二； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","為那七隻羊羔，每隻要獻伊法十分之一。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","又獻一隻公山羊作贖罪祭，為你們贖罪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","這些是在月朔的燔祭和同獻的素祭，並常獻的燔祭與同獻的素祭，以及照例同獻的奠祭以外，都作為馨香的火祭獻給耶和華。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","「七月初十日，你們當有聖會；要刻苦己心，甚麼工都不可做。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","只要將公牛犢一隻，公綿羊一隻，一歲的公羊羔七隻，都要沒有殘疾的，作為馨香的燔祭獻給耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","同獻的素祭用調油的細麵：為一隻公牛要獻伊法十分之三；為一隻公羊要獻伊法十分之二； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","為那七隻羊羔，每隻要獻伊法十分之一。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","又獻一隻公山羊為贖罪祭。這是在贖罪祭和常獻的燔祭，與同獻的素祭並同獻的奠祭以外。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","「七月十五日，你們當有聖會；甚麼勞碌的工都不可做，要向耶和華守節七日。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","又要將公牛犢十三隻，公綿羊兩隻，一歲的公羊羔十四隻，都要沒有殘疾的，用火獻給耶和華為馨香的燔祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","同獻的素祭用調油的細麵；為那十三隻公牛，每隻要獻伊法十分之三；為那兩隻公羊，每隻要獻伊法十分之二； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","為那十四隻羊羔，每隻要獻伊法十分之一。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","並獻一隻公山羊為贖罪祭，這是在常獻的燔祭和同獻的素祭並同獻的奠祭以外。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","「第二日要獻公牛犢十二隻，公綿羊兩隻，沒有殘疾、一歲的公羊羔十四隻； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","並為公牛、公羊，和羊羔，按數照例，獻同獻的素祭和同獻的奠祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","又要獻一隻公山羊為贖罪祭。這是在常獻的燔祭和同獻的素祭並同獻的奠祭以外。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","「第三日要獻公牛十一隻，公羊兩隻，沒有殘疾、一歲的公羊羔十四隻； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","並為公牛、公羊，和羊羔，按數照例，獻同獻的素祭和同獻的奠祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","又要獻一隻公山羊為贖罪祭。這是在常獻的燔祭和同獻的素祭並同獻的奠祭以外。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","「第四日要獻公牛十隻，公羊兩隻，沒有殘疾、一歲的公羊羔十四隻； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","並為公牛、公羊，和羊羔，按數照例，獻同獻的素祭和同獻的奠祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","又要獻一隻公山羊為贖罪祭。這是在常獻的燔祭和同獻的素祭並同獻的奠祭以外。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","「第五日要獻公牛九隻，公羊兩隻，沒有殘疾、一歲的公羊羔十四隻； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","並為公牛、公羊，和羊羔，按數照例，獻同獻的素祭和同獻的奠祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","又要獻一隻公山羊為贖罪祭。這是在常獻的燔祭和同獻的素祭並同獻的奠祭以外。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","「第六日要獻公牛八隻，公羊兩隻，沒有殘疾、一歲的公羊羔十四隻； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","並為公牛、公羊，和羊羔，按數照例，獻同獻的素祭和同獻的奠祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","又要獻一隻公山羊為贖罪祭。這是在常獻的燔祭和同獻的素祭並同獻的奠祭以外。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","「第七日要獻公牛七隻，公羊兩隻，沒有殘疾、一歲的公羊羔十四隻； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","並為公牛、公羊，和羊羔，按數照例，獻同獻的素祭和同獻的奠祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","又要獻一隻公山羊為贖罪祭。這是在常獻的燔祭和同獻的素祭並同獻的奠祭以外。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","「第八日你們當有嚴肅會；甚麼勞碌的工都不可做； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","只要將公牛一隻，公羊一隻，沒有殘疾、一歲的公羊羔七隻作火祭，獻給耶和華為馨香的燔祭； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","並為公牛、公羊，和羊羔，按數照例，獻同獻的素祭和同獻的奠祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","又要獻一隻公山羊為贖罪祭。這是在常獻的燔祭和同獻的素祭並同獻的奠祭以外。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","「這些祭要在你們的節期獻給耶和華，都在所許的願並甘心所獻的以外，作為你們的燔祭、素祭、奠祭，和平安祭。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","於是，摩西照耶和華所吩咐他的一切話告訴以色列人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","摩西曉諭以色列各支派的首領說：「耶和華所吩咐的乃是這樣： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","人若向耶和華許願或起誓，要約束自己，就不可食言，必要按口中所出的一切話行。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","女子年幼、還在父家的時候，若向耶和華許願，要約束自己， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","她父親也聽見她所許的願並約束自己的話，卻向她默默不言，她所許的願並約束自己的話就都要為定。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","但她父親聽見的日子若不應承她所許的願和約束自己的話，就都不得為定；耶和華也必赦免她，因為她父親不應承。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","她若出了嫁，有願在身，或是口中出了約束自己的冒失話， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","她丈夫聽見的日子，卻向她默默不言，她所許的願並約束自己的話就都要為定。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","但她丈夫聽見的日子，若不應承，就算廢了她所許的願和她出口約束自己的冒失話；耶和華也必赦免她。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","寡婦或是被休的婦人所許的願，就是她約束自己的話，都要為定。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","她若在丈夫家裏許了願或起了誓，約束自己， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","丈夫聽見，卻向她默默不言，也沒有不應承，她所許的願並約束自己的話就都要為定。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","丈夫聽見的日子，若把這兩樣全廢了，婦人口中所許的願或是約束自己的話就都不得為定，因她丈夫已經把這兩樣廢了；耶和華也必赦免她。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","凡她所許的願和刻苦約束自己所起的誓，她丈夫可以堅定，也可以廢去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","倘若她丈夫天天向她默默不言，就算是堅定她所許的願和約束自己的話；因丈夫聽見的日子向她默默不言，就使這兩樣堅定。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","但她丈夫聽見以後，若使這兩樣全廢了，就要擔當婦人的罪孽。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","這是丈夫待妻子，父親待女兒，女兒年幼、還在父家，耶和華所吩咐摩西的律例。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","耶和華吩咐摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","「你要在米甸人身上報以色列人的仇，後來要歸到你列祖那裏。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","摩西吩咐百姓說：「要從你們中間叫人帶兵器出去攻擊米甸，好在米甸人身上為耶和華報仇。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","從以色列眾支派中，每支派要打發一千人去打仗。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","於是從以色列千萬人中，每支派交出一千人，共一萬二千人，帶着兵器預備打仗。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","摩西就打發每支派的一千人去打仗，並打發祭司以利亞撒的兒子非尼哈同去；非尼哈手裏拿着聖所的器皿和吹大聲的號筒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","他們就照耶和華所吩咐摩西的，與米甸人打仗，殺了所有的男丁。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","在所殺的人中，殺了米甸的五王，就是以未、利金、蘇珥、戶珥、利巴，又用刀殺了比珥的兒子巴蘭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","以色列人擄了米甸人的婦女孩子，並將他們的牲畜、羊群，和所有的財物都奪了來，當作擄物， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","又用火焚燒他們所住的城邑和所有的營寨， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","把一切所奪的、所擄的，連人帶牲畜都帶了去， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","將所擄的人，所奪的牲畜、財物，都帶到摩押平原，在約旦河邊與耶利哥相對的營盤，交給摩西和祭司以利亞撒，並以色列的會眾。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","摩西和祭司以利亞撒，並會眾一切的首領，都出到營外迎接他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","摩西向打仗回來的軍長，就是千夫長、百夫長，發怒， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","對他們說：「你們要存留這一切婦女的活命嗎？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","這些婦女因巴蘭的計謀，叫以色列人在毗珥的事上得罪耶和華，以致耶和華的會眾遭遇瘟疫。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","所以，你們要把一切的男孩和所有已嫁的女子都殺了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","但女孩子中，凡沒有出嫁的，你們都可以存留她的活命。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","你們要在營外駐紮七日；凡殺了人的，和一切摸了被殺的，並你們所擄來的人口，第三日，第七日，都要潔淨自己， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","也要因一切的衣服、皮物、山羊毛織的物，和各樣的木器，潔淨自己。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","祭司以利亞撒對打仗回來的兵丁說：「耶和華所吩咐摩西律法中的條例乃是這樣： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","金、銀、銅、鐵、錫、鉛， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","凡能見火的，你們要叫它經火就為潔淨，然而還要用除污穢的水潔淨它；凡不能見火的，你們要叫它過水。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","第七日，你們要洗衣服，就為潔淨，然後可以進營。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","耶和華曉諭摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","「你和祭司以利亞撒，並會眾的各族長，要計算所擄來的人口和牲畜的總數。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","把所擄來的分作兩半：一半歸與出去打仗的精兵，一半歸與全會眾。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","又要從出去打仗所得的人口、牛、驢、羊群中，每五百取一，作為貢物奉給耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","從他們一半之中，要取出來交給祭司以利亞撒，作為耶和華的舉祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","從以色列人的一半之中，就是從人口、牛、驢、羊群、各樣牲畜中，每五十取一，交給看守耶和華帳幕的利未人。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","於是摩西和祭司以利亞撒照耶和華所吩咐摩西的行了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","除了兵丁所奪的財物以外，所擄來的：羊六十七萬五千隻； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","牛七萬二千隻； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","驢六萬一千匹； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","女人共三萬二千口，都是沒有出嫁的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","出去打仗之人的分，就是他們所得的那一半，共計羊三十三萬七千五百隻， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","從其中歸耶和華為貢物的，有六百七十五隻； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","牛三萬六千隻，從其中歸耶和華為貢物的，有七十二隻； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","驢三萬零五百匹，從其中歸耶和華為貢物的，有六十一匹； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","人一萬六千口，從其中歸耶和華的，有三十二口。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","摩西把貢物，就是歸與耶和華的舉祭，交給祭司以利亞撒，是照耶和華所吩咐摩西的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","以色列人所得的那一半，就是摩西從打仗的人取來分給他們的。（ ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","會眾的那一半有：羊三十三萬七千五百隻； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","牛三萬六千隻； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","驢三萬零五百匹； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","人一萬六千口。） ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","無論是人口是牲畜，摩西每五十取一，交給看守耶和華帳幕的利未人，是照耶和華所吩咐摩西的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","帶領千軍的各軍長，就是千夫長、百夫長，都近前來見摩西， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","對他說：「僕人權下的兵已經計算總數，並不短少一人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","如今我們將各人所得的金器，就是腳鍊子、鐲子、打印的戒指、耳環、手釧，都送來為耶和華的供物，好在耶和華面前為我們的生命贖罪。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","摩西和祭司以利亞撒就收了他們的金子，都是打成的器皿。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","千夫長、百夫長所獻給耶和華為舉祭的金子共有一萬六千七百五十舍客勒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","各兵丁都為自己奪了財物。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","摩西和祭司以利亞撒收了千夫長、百夫長的金子，就帶進會幕，在耶和華面前作為以色列人的紀念。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","呂便子孫和迦得子孫的牲畜極其眾多；他們看見雅謝地和基列地是可牧放牲畜之地， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","就來見摩西和祭司以利亞撒，並會眾的首領，說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","「亞大錄、底本、雅謝、寧拉、希實本、以利亞利、示班、尼波、比穩， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","就是耶和華在以色列會眾前面所攻取之地，是可牧放牲畜之地，你僕人也有牲畜」； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","又說：「我們若在你眼前蒙恩，求你把這地給我們為業，不要領我們過約旦河。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","摩西對迦得子孫和呂便子孫說：「難道你們的弟兄去打仗，你們竟坐在這裏嗎？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","你們為何使以色列人灰心喪膽、不過去進入耶和華所賜給他們的那地呢？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","我先前從加低斯‧巴尼亞打發你們先祖去窺探那地，他們也是這樣行。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","他們上以實各谷，去窺探那地回來的時候，使以色列人灰心喪膽，不進入耶和華所賜給他們的地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","當日，耶和華的怒氣發作，就起誓說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","『凡從埃及上來、二十歲以外的人斷不得看見我對亞伯拉罕、以撒、雅各起誓應許之地，因為他們沒有專心跟從我。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","惟有基尼洗族耶孚尼的兒子迦勒和嫩的兒子約書亞可以看見，因為他們專心跟從我。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","耶和華的怒氣向以色列人發作，使他們在曠野飄流四十年，等到在耶和華眼前行惡的那一代人都消滅了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","誰知，你們起來接續先祖，增添罪人的數目，使耶和華向以色列大發烈怒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","你們若退後不跟從他，他還要把以色列人撇在曠野，便是你們使這眾民滅亡。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","兩支派的人挨近摩西，說：「我們要在這裏為牲畜壘圈，為婦人孩子造城。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","我們自己要帶兵器行在以色列人的前頭，好把他們領到他們的地方；但我們的婦人孩子，因這地居民的緣故，要住在堅固的城內。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","我們不回家，直等到以色列人各承受自己的產業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","我們不和他們在約旦河那邊一帶之地同受產業，因為我們的產業是坐落在約旦河東邊這裏。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","摩西對他們說：「你們若這樣行，在耶和華面前帶着兵器出去打仗， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","所有帶兵器的人都要在耶和華面前過約旦河，等他趕出他的仇敵， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","那地被耶和華制伏了，然後你們可以回來，向耶和華和以色列才為無罪，這地也必在耶和華面前歸你們為業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","倘若你們不這樣行，就得罪耶和華，要知道你們的罪必追上你們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","如今你們口中所出的，只管去行，為你們的婦人孩子造城，為你們的羊群壘圈。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","迦得子孫和呂便子孫對摩西說：「僕人要照我主所吩咐的去行。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","我們的妻子、孩子、羊群，和所有的牲畜都要留在基列的各城。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","但你的僕人，凡帶兵器的，都要照我主所說的話，在耶和華面前過去打仗。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","於是，摩西為他們囑咐祭司以利亞撒和嫩的兒子約書亞，並以色列眾支派的族長，說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","「迦得子孫和呂便子孫，凡帶兵器在耶和華面前去打仗的，若與你們一同過約旦河，那地被你們制伏了，你們就要把基列地給他們為業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","倘若他們不帶兵器和你們一同過去，就要在迦南地你們中間得產業。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","迦得子孫和呂便子孫回答說：「耶和華怎樣吩咐僕人，僕人就怎樣行。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","我們要帶兵器，在耶和華面前過去，進入迦南地，只是約旦河這邊、我們所得為業之地仍歸我們。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","摩西將亞摩利王西宏的國和巴珊王噩的國，連那地和周圍的城邑，都給了迦得子孫和呂便子孫，並約瑟的兒子瑪拿西半個支派。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","迦得子孫建造底本、亞他錄、亞羅珥、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","亞他錄‧朔反、雅謝、約比哈、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","伯‧寧拉、伯‧哈蘭，都是堅固城。他們又壘羊圈。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","呂便子孫建造希實本、以利亞利、基列亭、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","尼波、巴力‧免、西比瑪（尼波、巴力‧免，名字是改了的），又給他們所建造的城另起別名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","瑪拿西的兒子瑪吉，他的子孫往基列去，佔了那地，趕出那裏的亞摩利人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","摩西將基列賜給瑪拿西的兒子瑪吉，他子孫就住在那裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","瑪拿西的子孫睚珥去佔了基列的村莊，就稱這些村莊為哈倭特‧睚珥。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","挪巴去佔了基納和基納的鄉村，就按自己的名稱基納為挪巴。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","以色列人按着軍隊，在摩西、亞倫的手下出埃及地所行的路程記在下面。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","摩西遵着耶和華的吩咐記載他們所行的路程，其路程乃是這樣： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","正月十五日，就是逾越節的次日，以色列人從蘭塞起行，在一切埃及人眼前昂然無懼地出去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","那時，埃及人正葬埋他們的長子，就是耶和華在他們中間所擊殺的；耶和華也敗壞他們的神。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","以色列人從蘭塞起行，安營在疏割。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","從疏割起行，安營在曠野邊的以倘。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","從以倘起行，轉到比‧哈希錄，是在巴力‧洗分對面，就在密奪安營。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","從比‧哈希錄對面起行，經過海中到了書珥曠野，又在伊坦的曠野走了三天的路程，就安營在瑪拉。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","從瑪拉起行，來到以琳（以琳有十二股水泉，七十棵棕樹），就在那裏安營。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","從以琳起行，安營在紅海邊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","從紅海邊起行，安營在汛的曠野。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","從汛的曠野起行，安營在脫加。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","從脫加起行，安營在亞錄。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","從亞錄起行，安營在利非訂；在那裏，百姓沒有水喝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","從利非訂起行，安營在西奈的曠野。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","從西奈的曠野起行，安營在基博羅‧哈他瓦。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","從基博羅‧哈他瓦起行，安營在哈洗錄。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","從哈洗錄起行，安營在利提瑪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","從利提瑪起行，安營在臨門‧帕烈。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","從臨門‧帕烈起行，安營在立拿。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","從立拿起行，安營在勒撒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","從勒撒起行，安營在基希拉他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","從基希拉他起行，安營在沙斐山。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","從沙斐山起行，安營在哈拉大。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","從哈拉大起行，安營在瑪吉希錄。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","從瑪吉希錄起行，安營在他哈。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","從他哈起行，安營在他拉。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","從他拉起行，安營在密加。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","從密加起行，安營在哈摩拿。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","從哈摩拿起行，安營在摩西錄。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","從摩西錄起行，安營在比尼‧亞干。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","從比尼‧亞干起行，安營在曷‧哈及甲。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","從曷‧哈及甲起行，安營在約巴他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","從約巴他起行，安營在阿博拿。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","從阿博拿起行，安營在以旬‧迦別。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","從以旬‧迦別起行，安營在尋的曠野，就是加低斯。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","從加低斯起行，安營在何珥山，以東地的邊界。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","以色列人出了埃及地後四十年，五月初一日，祭司亞倫遵着耶和華的吩咐上何珥山，就死在那裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","亞倫死在何珥山的時候年一百二十三歲。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","住在迦南南地的迦南人亞拉得王聽說以色列人來了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","以色列人從何珥山起行，安營在撒摩拿。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","從撒摩拿起行，安營在普嫩。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","從普嫩起行，安營在阿伯。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","從阿伯起行，安營在以耶‧亞巴琳，摩押的邊界。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","從以耶‧亞巴琳起行，安營在底本‧迦得。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","從底本‧迦得起行，安營在亞門‧低比拉太音。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","從亞門‧低比拉太音起行，安營在尼波對面的亞巴琳山裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","從亞巴琳山起行，安營在摩押平原－約旦河邊、耶利哥對面。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","他們在摩押平原沿約旦河邊安營，從伯‧耶施末直到亞伯‧什亭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","耶和華在摩押平原－約旦河邊、耶利哥對面曉諭摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","「你吩咐以色列人說：你們過約旦河進迦南地的時候， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","就要從你們面前趕出那裏所有的居民，毀滅他們一切鏨成的石像和他們一切鑄成的偶像，又拆毀他們一切的邱壇。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","你們要奪那地，住在其中，因我把那地賜給你們為業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","你們要按家室拈鬮，承受那地；人多的，要把產業多分給他們；人少的，要把產業少分給他們。拈出何地給何人，就要歸何人。你們要按宗族的支派承受。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","倘若你們不趕出那地的居民，所容留的居民就必作你們眼中的刺，肋下的荊棘，也必在你們所住的地上擾害你們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","而且我素常有意怎樣待他們，也必照樣待你們。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","耶和華曉諭摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","「你吩咐以色列人說：你們到了迦南地，就是歸你們為業的迦南四境之地， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","南角要從尋的曠野，貼着以東的邊界；南界要從鹽海東頭起， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","繞到亞克拉濱坡的南邊，接連到尋，直通到加低斯‧巴尼亞的南邊，又通到哈薩‧亞達，接連到押們， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","從押們轉到埃及小河，直通到海為止。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","「西邊要以大海為界；這就是你們的西界。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","「北界要從大海起，劃到何珥山， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","從何珥山劃到哈馬口，通到西達達， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","又通到西斐崙，直到哈薩‧以難。這要作你們的北界。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","「你們要從哈薩‧以難劃到示番為東界。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","這界要從示番下到亞延東邊的利比拉，又要達到基尼烈湖的東邊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","這界要下到約旦河，通到鹽海為止。這四圍的邊界以內，要作你們的地。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","摩西吩咐以色列人說：「這地就是耶和華吩咐拈鬮給九個半支派承受為業的； ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","因為呂便支派和迦得支派按着宗族受了產業，瑪拿西半個支派也受了產業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","這兩個半支派已經在耶利哥對面、約旦河東、向日出之地受了產業。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","耶和華曉諭摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","「要給你們分地為業之人的名字是祭司以利亞撒和嫩的兒子約書亞。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","又要從每支派中選一個首領幫助他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","這些人的名字：猶大支派有耶孚尼的兒子迦勒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","西緬支派有亞米忽的兒子示母利。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","便雅憫支派有基斯倫的兒子以利達。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","但支派有一個首領，約利的兒子布基。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","約瑟的子孫瑪拿西支派有一個首領，以弗的兒子漢聶。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","以法蓮支派有一個首領，拾弗但的兒子基母利。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","西布倫支派有一個首領，帕納的兒子以利撒番。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","以薩迦支派有一個首領，阿散的兒子帕鐵。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","亞設支派有一個首領，示羅米的兒子亞希忽。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","拿弗他利支派有一個首領，亞米忽的兒子比大黑。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","這些人就是耶和華所吩咐、在迦南地把產業分給以色列人的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","耶和華在摩押平原－約旦河邊、耶利哥對面曉諭摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","「你吩咐以色列人，要從所得為業的地中把些城給利未人居住，也要把這城四圍的郊野給利未人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","這城邑要歸他們居住，城邑的郊野可以牧養他們的牛羊和各樣的牲畜，又可以安置他們的財物。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","你們給利未人的郊野，要從城根起，四圍往外量一千肘。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","另外東量二千肘，南量二千肘，西量二千肘，北量二千肘，為邊界，城在當中；這要歸他們作城邑的郊野。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","你們給利未人的城邑，其中當有六座逃城，使誤殺人的可以逃到那裏。此外還要給他們四十二座城。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","你們要給利未人的城，共有四十八座，連城帶郊野都要給他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","以色列人所得的地業從中要把些城邑給利未 人；人多的就多給，人少的就少給；各支派要按所承受為業之地把城邑給利未人。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","耶和華曉諭摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","「你吩咐以色列人說：你們過約旦河，進了迦南地， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","就要分出幾座城，為你們作逃城，使誤殺人的可以逃到那裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","這些城可以作逃避報仇人的城，使誤殺人的不至於死，等他站在會眾面前聽審判。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","你們所分出來的城，要作六座逃城。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","在約旦河東要分出三座城，在迦南地也要分出三座城，都作逃城。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","這六座城要給以色列人和他們中間的外人，並寄居的，作為逃城，使誤殺人的都可以逃到那裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","「倘若人用鐵器打人，以致打死，他就是故殺人的；故殺人的必被治死。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","若用可以打死人的石頭打死了人，他就是故殺人的；故殺人的必被治死。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","若用可以打死人的木器打死了人，他就是故殺人的；故殺人的必被治死。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","報血仇的必親自殺那故殺人的，一遇見就殺他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","人若因怨恨把人推倒，或是埋伏往人身上扔物，以致於死， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","或是因仇恨用手打人，以致於死，那打人的必被治死。他是故殺人的；報血仇的一遇見就殺他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","「倘若人沒有仇恨，忽然將人推倒，或是沒有埋伏把物扔在人身上， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","或是沒有看見的時候用可以打死人的石頭扔在人身上，以致於死，本來與他無仇，也無意害他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","會眾就要照典章，在打死人的和報血仇的中間審判。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","會眾要救這誤殺人的脫離報血仇人的手，也要使他歸入逃城。他要住在其中，直等到受聖膏的大祭司死了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","但誤殺人的，無論甚麼時候，若出了逃城的境外， ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","報血仇的在逃城境外遇見他，將他殺了，報血仇的就沒有流血之罪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","因為誤殺人的該住在逃城裏，等到大祭司死了。大祭司死了以後，誤殺人的才可以回到他所得為業之地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","這在你們一切的住處，要作你們世世代代的律例典章。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","「無論誰故殺人，要憑幾個見證人的口把那故殺人的殺了，只是不可憑一個見證的口叫人死。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","故殺人、犯死罪的，你們不可收贖價代替他的命；他必被治死。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","那逃到逃城的人，你們不可為他收贖價，使他在大祭司未死以先再來住在本地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","這樣，你們就不污穢所住之地，因為血是污穢地的；若有在地上流人血的，非流那殺人者的血，那地就不得潔淨。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","你們不可玷污所住之地，就是我住在其中之地，因為我－耶和華住在以色列人中間。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","約瑟的後裔，瑪拿西的孫子，瑪吉的兒子基列，他子孫中的諸族長來到摩西和作首領的以色列人族長面前，說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","「耶和華曾吩咐我主拈鬮分給以色列人為業，我主也受了耶和華的吩咐將我們兄弟西羅非哈的產業分給他的眾女兒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","她們若嫁以色列別支派的人，就必將我們祖宗所遺留的產業加在她們丈夫支派的產業中。這樣，我們拈鬮所得的產業就要減少了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","到了以色列人的禧年，這女兒的產業就必加在她們丈夫支派的產業上。這樣，我們祖宗支派的產業就減少了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","摩西照耶和華的話吩咐以色列人說：「約瑟支派的人說得有理。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","論到西羅非哈的眾女兒，耶和華這樣吩咐說：她們可以隨意嫁人，只是要嫁同宗支派的人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","這樣，以色列人的產業就不從這支派歸到那支派，因為以色列人要各守各祖宗支派的產業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","凡在以色列支派中得了產業的女子必作同宗支派人的妻，好叫以色列人各自承受他祖宗的產業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","這樣，他們的產業就不從這支派歸到那支派，因為以色列支派的人要各守各的產業。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","耶和華怎樣吩咐摩西，西羅非哈的眾女兒就怎樣行。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","西羅非哈的女兒瑪拉、得撒、曷拉、密迦、挪阿都嫁了他們伯叔的兒子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","她們嫁入約瑟兒子、瑪拿西子孫的族中；她們的產業仍留在同宗支派中。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","這是耶和華在摩押平原－約旦河邊、耶利哥對面－藉着摩西所吩咐以色列人的命令典章。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","以下所記的是摩西在約旦河東的曠野、疏弗對面的亞拉巴－就是巴蘭、陀弗、拉班、哈洗錄、底撒哈中間－向以色列眾人所說的話。（ ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","從何烈山經過西珥山到加低斯‧巴尼亞有十一天的路程。） ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","出埃及第四十年十一月初一日，摩西照耶和華藉着他所吩咐以色列人的話都曉諭他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","那時，他已經擊殺了住希實本的亞摩利王西宏和住以得來、亞斯他錄的巴珊王噩。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","摩西在約旦河東的摩押地講律法說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","「耶和華－我們的上帝在何烈山曉諭我們說：你們在這山上住的日子夠了； ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","要起行轉到亞摩利人的山地和靠近這山地的各處，就是亞拉巴、山地、高原、南地，沿海一帶迦南人的地，並黎巴嫩山又到幼發拉底大河。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","如今我將這地擺在你們面前；你們要進去得這地，就是耶和華向你們列祖亞伯拉罕、以撒、雅各起誓應許賜給他們和他們後裔為業之地。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","「那時，我對你們說：『管理你們的重任，我獨自擔當不起。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","耶和華－你們的上帝使你們多起來。看哪，你們今日像天上的星那樣多。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","惟願耶和華－你們列祖的上帝使你們比如今更多千倍，照他所應許你們的話賜福與你們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","但你們的麻煩，和管理你們的重任，並你們的爭訟，我獨自一人怎能擔當得起呢？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","你們要按着各支派選舉有智慧、有見識、為眾人所認識的，我立他們為你們的首領。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","你們回答我說：『照你所說的行了為妙。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","我便將你們各支派的首領，有智慧、為眾人所認識的，照你們的支派，立他們為官長、千夫長、百夫長、五十夫長、十夫長，管理你們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","「當時，我囑咐你們的審判官說：『你們聽訟，無論是弟兄彼此爭訟，是與同居的外人爭訟，都要按公義判斷。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","審判的時候，不可看人的外貌；聽訟不可分貴賤，不可懼怕人，因為審判是屬乎上帝的。若有難斷的案件，可以呈到我這裏，我就判斷。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","那時，我將你們所當行的事都吩咐你們了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","「我們照着耶和華－我們上帝所吩咐的從何烈山起行，經過你們所看見那大而可怕的曠野，往亞摩利人的山地去，到了加低斯‧巴尼亞。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","我對你們說：『你們已經到了耶和華－我們上帝所賜給我們的亞摩利人之山地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","看哪，耶和華－你的上帝已將那地擺在你面前，你要照耶和華－你列祖的上帝所說的上去得那地為業；不要懼怕，也不要驚惶。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","你們都就近我來說：『我們要先打發人去，為我們窺探那地，將我們上去該走何道，必進何城，都回報我們。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","這話我以為美，就從你們中間選了十二個人，每支派一人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","於是他們起身上山地去，到以實各谷，窺探那地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","他們手裏拿着那地的果子下來，到我們那裏，回報說：『耶和華－我們的上帝所賜給我們的是美地。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","「你們卻不肯上去，竟違背了耶和華－你們上帝的命令， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","在帳棚內發怨言說：『耶和華因為恨我們，所以將我們從埃及地領出來，要交在亞摩利人手中，除滅我們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","我們上哪裏去呢？我們的弟兄使我們的心消化，說那地的民比我們又大又高，城邑又廣大又堅固，高得頂天，並且我們在那裏看見亞衲族的人。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","我就對你們說：『不要驚恐，也不要怕他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","在你們前面行的耶和華－你們的上帝必為你們爭戰，正如他在埃及和曠野，在你們眼前所行的一樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","你們在曠野所行的路上，也曾見耶和華－你們的上帝撫養你們，如同人撫養兒子一般，直等你們來到這地方。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","你們在這事上卻不信耶和華－你們的上帝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","他在路上，在你們前面行，為你們找安營的地方；夜間在火柱裏，日間在雲柱裏，指示你們所當行的路。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","「耶和華聽見你們這話，就發怒，起誓說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","『這惡世代的人，連一個也不得見我起誓應許賜給你們列祖的美地； ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","惟有耶孚尼的兒子迦勒必得看見，並且我要將他所踏過的地賜給他和他的子孫，因為他專心跟從我。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","耶和華為你的緣故也向我發怒，說：『你必不得進入那地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","伺候你、嫩的兒子約書亞，他必得進入那地；你要勉勵他，因為他要使以色列人承受那地為業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","並且你們的婦人孩子，就是你們所說、必被擄掠的，和今日不知善惡的兒女，必進入那地。我要將那地賜給他們，他們必得為業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","至於你們，要轉回，從紅海的路往曠野去。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","「那時，你們回答我說：『我們得罪了耶和華，情願照耶和華－我們上帝一切所吩咐的上去爭戰。』於是你們各人帶着兵器，爭先上山地去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","耶和華吩咐我說：『你對他們說：不要上去，也不要爭戰；因我不在你們中間，恐怕你們被仇敵殺敗了。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","我就告訴了你們，你們卻不聽從，竟違背耶和華的命令，擅自上山地去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","住那山地的亞摩利人就出來攻擊你們，追趕你們，如蜂擁一般，在西珥殺退你們，直到何珥瑪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","你們便回來，在耶和華面前哭號；耶和華卻不聽你們的聲音，也不向你們側耳。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","於是你們在加低斯住了許多日子。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","「此後，我們轉回，從紅海的路往曠野去，是照耶和華所吩咐我的。我們在西珥山繞行了許多日子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","耶和華對我說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","『你們繞行這山的日子夠了，要轉向北去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","你吩咐百姓說：你們弟兄以掃的子孫住在西珥，你們要經過他們的境界。他們必懼怕你們，所以你們要分外謹慎。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","不可與他們爭戰；他們的地，連腳掌可踏之處，我都不給你們，因我已將西珥山賜給以掃為業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","你們要用錢向他們買糧吃，也要用錢向他們買水喝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","因為耶和華－你的上帝在你手裏所辦的一切事上已賜福與你。你走這大曠野，他都知道了。這四十年，耶和華－你的上帝常與你同在，故此你一無所缺。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","「於是，我們離了我們弟兄以掃子孫所住的西珥，從亞拉巴的路，經過以拉他、以旬‧迦別，轉向摩押曠野的路去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","耶和華吩咐我說：『不可擾害摩押人，也不可與他們爭戰。他們的地，我不賜給你為業，因我已將亞珥賜給羅得的子孫為業。』（ ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","先前，有以米人住在那裏，民數眾多，身體高大，像亞衲人一樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","這以米人像亞衲人；也算為利乏音人；摩押人稱他們為以米人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","先前，何利人也住在西珥，但以掃的子孫將他們除滅，得了他們的地，接着居住，就如以色列在耶和華賜給他為業之地所行的一樣。） ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","現在，起來過撒烈溪！於是我們過了撒烈溪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","自從離開加低斯‧巴尼亞，到過了撒烈溪的時候，共有三十八年，等那世代的兵丁都從營中滅盡，正如耶和華向他們所起的誓。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","耶和華的手也攻擊他們，將他們從營中除滅，直到滅盡。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","「兵丁從民中都滅盡死亡以後， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","耶和華吩咐我說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","『你今天要從摩押的境界亞珥經過， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","走近亞捫人之地，不可擾害他們，也不可與他們爭戰。亞捫人的地，我不賜給你們為業，因我已將那地賜給羅得的子孫為業。』（ ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","那地也算為利乏音人之地，先前利乏音人住在那裏，亞捫人稱他們為散送冥。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","那民眾多，身體高大，像亞衲人一樣，但耶和華從亞捫人面前除滅他們，亞捫人就得了他們的地，接着居住。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","正如耶和華從前為住西珥的以掃子孫將何利人從他們面前除滅、他們得了何利人的地、接着居住一樣，直到今日。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","從迦斐託出來的迦斐託人將先前住在鄉村直到迦薩的亞衛人除滅，接着居住。） ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","你們起來前往，過亞嫩谷；我已將亞摩利人希實本王西宏和他的地交在你手中，你要與他爭戰，得他的地為業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","從今日起，我要使天下萬民聽見你的名聲都驚恐懼怕，且因你發顫傷慟。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","「我從基底莫的曠野差遣使者去見希實本王西宏，用和睦的話說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","『求你容我從你的地經過，只走大道，不偏左右。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","你可以賣糧給我吃，也可以賣水給我喝，只要容我步行過去， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","就如住西珥的以掃子孫和住亞珥的摩押人待我一樣，等我過了約旦河，好進入耶和華－我們上帝所賜給我們的地。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","但希實本王西宏不容我們從他那裏經過；因為耶和華－你的上帝使他心中剛硬，性情頑梗，為要將他交在你手中，像今日一樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","耶和華對我說：『從此起首，我要將西宏和他的地交給你；你要得他的地為業。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","那時，西宏和他的眾民出來攻擊我們，在雅雜與我們交戰。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","耶和華－我們的上帝將他交給我們，我們就把他和他的兒子，並他的眾民，都擊殺了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","我們奪了他的一切城邑，將有人煙的各城，連女人帶孩子，盡都毀滅，沒有留下一個。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","惟有牲畜和所奪的各城，並其中的財物，都取為自己的掠物。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","從亞嫩谷邊的亞羅珥和谷中的城，直到基列，耶和華－我們的上帝都交給我們了，沒有一座城高得使我們不能攻取的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","惟有亞捫人之地，凡靠近雅博河的地，並山地的城邑，與耶和華－我們上帝所禁止我們去的地方，都沒有挨近。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","「以後，我們轉回，向巴珊去。巴珊王噩和他的眾民都出來，在以得來與我們交戰。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","耶和華對我說：『不要怕他！因我已將他和他的眾民，並他的地，都交在你手中；你要待他像從前待住希實本的亞摩利王西宏一樣。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","於是耶和華－我們的上帝也將巴珊王噩和他的眾民都交在我們手中；我們殺了他們，沒有留下一個。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","那時，我們奪了他所有的城，共有六十座，沒有一座城不被我們所奪。這為亞珥歌伯的全境，就是巴珊地噩王的國。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","這些城都有堅固的高牆，有門有閂。此外還有許多無城牆的鄉村。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","我們將這些都毀滅了，像從前待希實本王西宏一樣，把有人煙的各城，連女人帶孩子，盡都毀滅； ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","惟有一切牲畜和城中的財物都取為自己的掠物。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","那時，我們從約旦河東兩個亞摩利王的手將亞嫩谷直到黑門山之地奪過來（ ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","這黑門山，西頓人稱為西連，亞摩利人稱為示尼珥）， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","就是奪了平原的各城、基列全地、巴珊全地，直到撒迦和以得來，都是巴珊王噩國內的城邑。（ ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","利乏音人所剩下的只有巴珊王噩。他的床是鐵的，長九肘，寬四肘，都是以人肘為度。現今豈不是在亞捫人的拉巴嗎？）」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","「那時，我們得了這地。從亞嫩谷邊的亞羅珥起，我將基列山地的一半，並其中的城邑，都給了呂便人和迦得人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","其餘的基列地和巴珊全地，就是噩王的國，我給了瑪拿西半支派。亞珥歌伯全地乃是巴珊全地；這叫做利乏音人之地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","瑪拿西的子孫睚珥佔了亞珥歌伯全境，直到基述人和瑪迦人的交界，就按自己的名稱這巴珊地為哈倭特‧睚珥，直到今日。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","我又將基列給了瑪吉。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","從基列到亞嫩谷，以谷中為界，直到亞捫人交界的雅博河，我給了呂便人和迦得人， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","又將亞拉巴和靠近約旦河之地，從基尼烈直到亞拉巴海，就是鹽海，並毗斯迦山根東邊之地，都給了他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","「那時，我吩咐你們說：『耶和華－你們的上帝已將這地賜給你們為業；你們所有的勇士都要帶着兵器，在你們的弟兄以色列人前面過去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","但你們的妻子、孩子、牲畜（我知道你們有許多的牲畜）可以住在我所賜給你們的各城裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","等到你們弟兄在約旦河那邊，也得耶和華－你們上帝所賜給他們的地，又使他們得享平安，與你們一樣，你們才可以回到我所賜給你們為業之地。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","那時我吩咐約書亞說：『你親眼看見了耶和華－你上帝向這二王所行的；耶和華也必向你所要去的各國照樣行。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","你不要怕他們，因那為你爭戰的是耶和華－你的上帝。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","「那時，我懇求耶和華說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","『主耶和華啊，你已將你的大力大能顯給僕人看。在天上，在地下，有甚麼神能像你行事、像你有大能的作為呢？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","求你容我過去，看約旦河那邊的美地，就是那佳美的山地和黎巴嫩。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","但耶和華因你們的緣故向我發怒，不應允我，對我說：『罷了！你不要向我再提這事。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","你且上毗斯迦山頂去，向東、西、南、北舉目觀望，因為你必不能過這約旦河。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","你卻要囑咐約書亞，勉勵他，使他膽壯；因為他必在這百姓前面過去，使他們承受你所要觀看之地。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","於是我們住在伯‧毗珥對面的谷中。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","「以色列人哪，現在我所教訓你們的律例典章，你們要聽從遵行，好叫你們存活，得以進入耶和華－你們列祖之上帝所賜給你們的地，承受為業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","所吩咐你們的話，你們不可加添，也不可刪減，好叫你們遵守我所吩咐的，就是耶和華－你們上帝的命令。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","耶和華因巴力‧毗珥的事所行的，你們親眼看見了。凡隨從巴力‧毗珥的人，耶和華－你們的上帝都從你們中間除滅了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","惟有你們專靠耶和華－你們上帝的人，今日全都存活。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","我照着耶和華－我上帝所吩咐的將律例典章教訓你們，使你們在所要進去得為業的地上遵行。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","所以你們要謹守遵行；這就是你們在萬民眼前的智慧、聰明。他們聽見這一切律例，必說：『這大國的人真是有智慧，有聰明！』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","哪一大國的人有神與他們相近，像耶和華－我們的上帝、在我們求告他的時候與我們相近呢？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","又哪一大國有這樣公義的律例典章、像我今日在你們面前所陳明的這一切律法呢？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","「你只要謹慎，殷勤保守你的心靈，免得忘記你親眼所看見的事，又免得你一生、這事離開你的心；總要傳給你的子子孫孫。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","你在何烈山站在耶和華－你上帝面前的那日，耶和華對我說：『你為我招聚百姓，我要叫他們聽見我的話，使他們存活在世的日子，可以學習敬畏我，又可以教訓兒女這樣行。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","那時你們近前來，站在山下；山上有火焰沖天，並有昏黑、密雲、幽暗。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","耶和華從火焰中對你們說話，你們只聽見聲音，卻沒有看見形像。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","他將所吩咐你們當守的約指示你們，就是十條誡，並將這誡寫在兩塊石版上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","那時耶和華又吩咐我將律例典章教訓你們，使你們在所要過去得為業的地上遵行。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","「所以，你們要分外謹慎；因為耶和華在何烈山、從火中對你們說話的那日，你們沒有看見甚麼形像。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","惟恐你們敗壞自己，雕刻偶像，彷彿甚麼男像女像， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","或地上走獸的像，或空中飛鳥的像， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","或地上爬物的像，或地底下水中魚的像。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","又恐怕你向天舉目觀看，見耶和華－你的上帝為天下萬民所擺列的日月星，就是天上的萬象，自己便被勾引敬拜事奉它。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","耶和華將你們從埃及領出來，脫離鐵爐，要特作自己產業的子民，像今日一樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","耶和華又因你們的緣故向我發怒，起誓必不容我過約旦河，也不容我進入耶和華－你上帝所賜你為業的那美地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","我只得死在這地，不能過約旦河；但你們必過去得那美地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","你們要謹慎，免得忘記耶和華－你們上帝與你們所立的約，為自己雕刻偶像，就是耶和華－你上帝所禁止你做的偶像； ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","因為耶和華－你的上帝乃是烈火，是忌邪的上帝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","「你們在那地住久了，生子生孫，就雕刻偶像，彷彿甚麼形像，敗壞自己，行耶和華－你上帝眼中看為惡的事，惹他發怒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","我今日呼天喚地向你們作見證，你們必在過約旦河得為業的地上速速滅盡！你們不能在那地上長久，必盡行除滅。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","耶和華必使你們分散在萬民中；在他所領你們到的萬國裏，你們剩下的人數稀少。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","在那裏，你們必事奉人手所造的神，就是用木石造成、不能看、不能聽、不能吃、不能聞的神。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","但你們在那裏必尋求耶和華－你的上帝。你盡心盡性尋求他的時候，就必尋見。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","日後你遭遇一切患難的時候，你必歸回耶和華－你的上帝，聽從他的話。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","耶和華－你上帝原是有憐憫的上帝；他總不撇下你，不滅絕你，也不忘記他起誓與你列祖所立的約。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","33","「你且考察在你以前的世代，自上帝造人在世以來，從天這邊到天那邊，曾有何民聽見上帝在火中說話的聲音，像你聽見還能存活呢？這樣的大事何曾有、何曾聽見呢？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","上帝何曾從別的國中將一國的人民領出來，用試驗、神蹟、奇事、爭戰、大能的手，和伸出來的膀臂，並大可畏的事，像耶和華－你們的上帝在埃及，在你們眼前為你們所行的一切事呢？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","這是顯給你看，要使你知道，惟有耶和華－他是上帝，除他以外，再無別神。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","他從天上使你聽見他的聲音，為要教訓你，又在地上使你看見他的烈火，並且聽見他從火中所說的話。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","因他愛你的列祖，所以揀選他們的後裔，用大能親自領你出了埃及， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","要將比你強大的國民從你面前趕出，領你進去，將他們的地賜你為業，像今日一樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","所以，今日你要知道，也要記在心上，天上地下惟有耶和華他是上帝，除他以外，再無別神。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","我今日將他的律例誡命曉諭你，你要遵守，使你和你的子孫可以得福，並使你的日子在耶和華－你上帝所賜的地上得以長久。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","「那時，摩西在約旦河東，向日出之地，分定三座城， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","使那素無仇恨、無心殺了人的，可以逃到這三城之中的一座城，就得存活： ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","為呂便人分定曠野平原的比悉；為迦得人分定基列的拉末；為瑪拿西人分定巴珊的哥蘭。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","摩西在以色列人面前所陳明的律法－ ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","就是摩西在以色列人出埃及後所傳給他們的法度、律例、典章； ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","在約旦河東伯‧毗珥對面的谷中，在住希實本、亞摩利王西宏之地；這西宏是摩西和以色列人出埃及後所擊殺的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","他們得了他的地，又得了巴珊王噩的地，就是兩個亞摩利王，在約旦河東向日出之地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","從亞嫩谷邊的亞羅珥，直到西雲山，就是黑門山。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","還有約旦河東的全亞拉巴，直到亞拉巴海，靠近毗斯迦山根。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","摩西將以色列眾人召了來，對他們說：「以色列人哪，我今日曉諭你們的律例典章，你們要聽，可以學習，謹守遵行。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","耶和華－我們的上帝在何烈山與我們立約。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","這約不是與我們列祖立的，乃是與我們今日在這裏存活之人立的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","耶和華在山上，從火中，面對面與你們說話－ ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","那時我站在耶和華和你們中間，要將耶和華的話傳給你們；因為你們懼怕那火，沒有上山－說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","「『我是耶和華－你的上帝，曾將你從埃及地為奴之家領出來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","「『除了我以外，你不可有別的神。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","「『不可為自己雕刻偶像，也不可做甚麼形像，彷彿上天、下地和地底下、水中的百物。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","不可跪拜那些像，也不可事奉它，因為我耶和華－你的上帝是忌邪的上帝。恨我的，我必追討他的罪，自父及子，直到三、四代； ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","愛我、守我誡命的，我必向他們發慈愛，直到千代。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","「『不可妄稱耶和華－你上帝的名；因為妄稱耶和華名的，耶和華必不以他為無罪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","「『當照耶和華－你上帝所吩咐的守安息日為聖日。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","六日要勞碌做你一切的工， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","但第七日是向耶和華－你上帝當守的安息日。這一日，你和你的兒女、僕婢、牛、驢、牲畜，並在你城裏寄居的客旅，無論何工都不可做，使你的僕婢可以和你一樣安息。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","你也要記念你在埃及地作過奴僕；耶和華－你上帝用大能的手和伸出來的膀臂將你從那裏領出來。因此，耶和華－你的上帝吩咐你守安息日。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","「『當照耶和華－你上帝所吩咐的孝敬父母，使你得福，並使你的日子在耶和華－你上帝所賜你的地上得以長久。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","「『不可殺人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","「『不可姦淫。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","「『不可偷盜。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","「『不可作假見證陷害人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","「『不可貪戀人的妻子；也不可貪圖人的房屋、田地、僕婢、牛、驢，並他一切所有的。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","「這些話是耶和華在山上，從火中、雲中、幽暗中，大聲曉諭你們全會眾的；此外並沒有添別的話。他就把這話寫在兩塊石版上，交給我了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","「那時，火焰燒山，你們聽見從黑暗中出來的聲音；你們支派中所有的首領和長老都來就近我， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","說：『看哪，耶和華－我們上帝將他的榮光和他的大能顯給我們看，我們又聽見他的聲音從火中出來。今日我們得見上帝與人說話，人還存活。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","現在這大火將要燒滅我們，我們何必冒死呢？若再聽見耶和華－我們上帝的聲音就必死亡。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","凡屬血氣的，曾有何人聽見永生上帝的聲音從火中出來，像我們聽見還能存活呢？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","求你近前去，聽耶和華－我們上帝所要說的一切話，將他對你說的話都傳給我們，我們就聽從遵行。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","「你們對我說的話，耶和華都聽見了。耶和華對我說：『這百姓的話，我聽見了；他們所說的都是。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","惟願他們存這樣的心敬畏我，常遵守我的一切誡命，使他們和他們的子孫永遠得福。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","你去對他們說：你們回帳棚去吧！ ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","至於你，可以站在我這裏，我要將一切誡命、律例、典章傳給你；你要教訓他們，使他們在我賜他們為業的地上遵行。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","所以，你們要照耶和華－你們上帝所吩咐的謹守遵行，不可偏離左右。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","耶和華－你們上帝所吩咐你們行的，你們都要去行，使你們可以存活得福，並使你們的日子在所要承受的地上得以長久。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","「這是耶和華－你們上帝所吩咐教訓你們的誡命、律例、典章，使你們在所要過去得為業的地上遵行， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","好叫你和你子子孫孫一生敬畏耶和華－你的上帝，謹守他的一切律例誡命，就是我所吩咐你的，使你的日子得以長久。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","以色列啊，你要聽，要謹守遵行，使你可以在那流奶與蜜之地得以享福，人數極其增多，正如耶和華－你列祖的上帝所應許你的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","「以色列啊，你要聽！耶和華－我們上帝是獨一的主。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","你要盡心、盡性、盡力愛耶和華－你的上帝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","我今日所吩咐你的話都要記在心上， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","也要殷勤教訓你的兒女。無論你坐在家裏，行在路上，躺下，起來，都要談論。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","也要繫在手上為記號，戴在額上為經文； ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","又要寫在你房屋的門框上，並你的城門上。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","「耶和華－你的上帝領你進他向你列祖亞伯拉罕、以撒、雅各起誓應許給你的地。那裏有城邑，又大又美，非你所建造的； ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","有房屋，裝滿各樣美物，非你所裝滿的；有鑿成的水井，非你所鑿成的；還有葡萄園、橄欖園，非你所栽種的；你吃了而且飽足。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","那時你要謹慎，免得你忘記將你從埃及地、為奴之家領出來的耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","你要敬畏耶和華－你的上帝，事奉他，指着他的名起誓。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","不可隨從別神，就是你們四圍國民的神； ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","因為在你們中間的耶和華－你上帝是忌邪的上帝，惟恐耶和華－你上帝的怒氣向你發作，就把你從地上除滅。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","「你們不可試探耶和華－你們的上帝，像你們在瑪撒那樣試探他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","要留意遵守耶和華－你們上帝所吩咐的誡命、法度、律例。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","耶和華眼中看為正、看為善的，你都要遵行，使你可以享福，並可以進去得耶和華向你列祖起誓應許的那美地， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","照耶和華所說的，從你面前攆出你的一切仇敵。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","「日後，你的兒子問你說：『耶和華－我們上帝吩咐你們的這些法度、律例、典章是甚麼意思呢？』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","你就告訴你的兒子說：『我們在埃及作過法老的奴僕；耶和華用大能的手將我們從埃及領出來， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","在我們眼前，將重大可怕的神蹟奇事施行在埃及地和法老並他全家的身上， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","將我們從那裏領出來，要領我們進入他向我們列祖起誓應許之地，把這地賜給我們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","耶和華又吩咐我們遵行這一切律例，要敬畏耶和華－我們的上帝，使我們常得好處，蒙他保全我們的生命，像今日一樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","我們若照耶和華－我們上帝所吩咐的一切誡命謹守遵行，這就是我們的義了。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","「耶和華－你上帝領你進入要得為業之地，從你面前趕出許多國民，就是赫人、革迦撒人、亞摩利人、迦南人、比利洗人、希未人、耶布斯人，共七國的民，都比你強大。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","耶和華－你上帝將他們交給你擊殺，那時你要把他們滅絕淨盡，不可與他們立約，也不可憐恤他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","不可與他們結親。不可將你的女兒嫁他們的兒子，也不可叫你的兒子娶他們的女兒； ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","因為他必使你兒子轉離不跟從主，去事奉別神，以致耶和華的怒氣向你們發作，就速速地將你們滅絕。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","你們卻要這樣待他們：拆毀他們的祭壇，打碎他們的柱像，砍下他們的木偶，用火焚燒他們雕刻的偶像。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","因為你歸耶和華－你上帝為聖潔的民；耶和華－你上帝從地上的萬民中揀選你，特作自己的子民。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","「耶和華專愛你們，揀選你們，並非因你們的人數多於別民，原來你們的人數在萬民中是最少的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","只因耶和華愛你們，又因要守他向你們列祖所起的誓，就用大能的手領你們出來，從為奴之家救贖你們脫離埃及王法老的手。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","所以，你要知道耶和華－你的上帝，他是上帝，是信實的上帝；向愛他、守他誡命的人守約，施慈愛，直到千代； ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","向恨他的人當面報應他們，將他們滅絕。凡恨他的人必報應他們，決不遲延。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","所以，你要謹守遵行我今日所吩咐你的誡命、律例、典章。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","「你們果然聽從這些典章，謹守遵行，耶和華－你上帝就必照他向你列祖所起的誓守約，施慈愛。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","他必愛你，賜福與你，使你人數增多，也必在他向你列祖起誓應許給你的地上賜福與你身所生的，地所產的，並你的五穀、新酒，和油，以及牛犢、羊羔。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","你必蒙福勝過萬民；你們的男女沒有不能生養的，牲畜也沒有不能生育的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","耶和華必使一切的病症離開你；你所知道埃及各樣的惡疾，他不加在你身上，只加在一切恨你的人身上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","耶和華－你上帝所要交給你的一切人民，你要將他們除滅；你眼不可顧惜他們。你也不可事奉他們的神，因這必成為你的網羅。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","「你若心裏說，這些國的民比我更多，我怎能趕出他們呢？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","你不要懼怕他們，要牢牢記念耶和華－你上帝向法老和埃及全地所行的事， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","就是你親眼所看見的大試驗、神蹟、奇事，和大能的手，並伸出來的膀臂，都是耶和華－你上帝領你出來所用的。耶和華－你上帝必照樣待你所懼怕的一切人民。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","並且耶和華－你上帝必打發黃蜂飛到他們中間，直到那剩下而藏躲的人從你面前滅亡。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","你不要因他們驚恐，因為耶和華－你上帝在你們中間是大而可畏的上帝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","耶和華－你上帝必將這些國的民從你面前漸漸趕出；你不可把他們速速滅盡，恐怕野地的獸多起來害你。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","耶和華－你上帝必將他們交給你，大大地擾亂他們，直到他們滅絕了； ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","又要將他們的君王交在你手中，你就使他們的名從天下消滅。必無一人能在你面前站立得住，直到你將他們滅絕了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","他們雕刻的神像，你們要用火焚燒；其上的金銀，你不可貪圖，也不可收取，免得你因此陷入網羅；這原是耶和華－你上帝所憎惡的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","可憎的物，你不可帶進家去；不然，你就成了當毀滅的，與那物一樣。你要十分厭惡，十分憎嫌，因為這是當毀滅的物。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","「我今日所吩咐的一切誡命，你們要謹守遵行，好叫你們存活，人數增多，且進去得耶和華向你們列祖起誓應許的那地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","你也要記念耶和華－你的上帝在曠野引導你這四十年，是要苦煉你，試驗你，要知道你心內如何，肯守他的誡命不肯。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","他苦煉你，任你飢餓，將你和你列祖所不認識的嗎哪賜給你吃，使你知道，人活着不是單靠食物，乃是靠耶和華口裏所出的一切話。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","這四十年，你的衣服沒有穿破，你的腳也沒有腫。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","你當心裏思想，耶和華－你上帝管教你，好像人管教兒子一樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","你要謹守耶和華－你上帝的誡命，遵行他的道，敬畏他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","因為耶和華－你上帝領你進入美地，那地有河，有泉，有源，從山谷中流出水來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","那地有小麥、大麥、葡萄樹、無花果樹、石榴樹、橄欖樹，和蜜。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","你在那地不缺食物，一無所缺。那地的石頭是鐵，山內可以挖銅。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","你吃得飽足，就要稱頌耶和華－你的上帝，因他將那美地賜給你了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","「你要謹慎，免得忘記耶和華－你的上帝，不守他的誡命、典章、律例，就是我今日所吩咐你的； ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","恐怕你吃得飽足，建造美好的房屋居住， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","你的牛羊加多，你的金銀增添，並你所有的全都加增， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","你就心高氣傲，忘記耶和華－你的上帝，就是將你從埃及地為奴之家領出來的， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","引你經過那大而可怕的曠野，那裏有火蛇、蠍子、乾旱無水之地。他曾為你使水從堅硬的磐石中流出來， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","又在曠野將你列祖所不認識的嗎哪賜給你吃，是要苦煉你，試驗你，叫你終久享福； ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","恐怕你心裏說：『這貨財是我力量、我能力得來的。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","你要記念耶和華－你的上帝，因為得貨財的力量是他給你的，為要堅定他向你列祖起誓所立的約，像今日一樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","你若忘記耶和華－你的上帝，隨從別神，事奉敬拜，你們必定滅亡；這是我今日警戒你們的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","耶和華在你們面前怎樣使列國的民滅亡，你們也必照樣滅亡，因為你們不聽從耶和華－你們上帝的話。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","「以色列啊，你當聽！你今日要過約旦河，進去趕出比你強大的國民，得着廣大堅固、高得頂天的城邑。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","那民是亞衲族的人，又大又高，是你所知道的；也曾聽見有人指着他們說：『誰能在亞衲族人面前站立得住呢？』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","你今日當知道，耶和華－你的上帝在你前面過去，如同烈火，要滅絕他們，將他們制伏在你面前。這樣，你就要照耶和華所說的趕出他們，使他們速速滅亡。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","「耶和華－你的上帝將這些國民從你面前攆出以後，你心裏不可說：『耶和華將我領進來得這地是因我的義。』其實，耶和華將他們從你面前趕出去是因他們的惡。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","你進去得他們的地，並不是因你的義，也不是因你心裏正直，乃是因這些國民的惡，耶和華－你的上帝將他們從你面前趕出去，又因耶和華要堅定他向你列祖亞伯拉罕、以撒、雅各起誓所應許的話。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","「你當知道，耶和華－你上帝將這美地賜你為業，並不是因你的義；你本是硬着頸項的百姓。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","你當記念不忘，你在曠野怎樣惹耶和華－你上帝發怒。自從你出了埃及地的那日，直到你們來到這地方，你們時常悖逆耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","你們在何烈山又惹耶和華發怒；他惱怒你們，要滅絕你們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","我上了山，要領受兩塊石版，就是耶和華與你們立約的版。那時我在山上住了四十晝夜，沒有吃飯，也沒有喝水。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT9_10","006_9_10","DEU","9","10","10","耶和華把那兩塊石版交給我，是上帝用指頭寫的。版上所寫的是照耶和華在大會的日子、在山上、從火中對你們所說的一切話。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT9_11","006_9_11","DEU","9","11","11","過了四十晝夜，耶和華把那兩塊石版，就是約版，交給我。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","對我說：『你起來，趕快下去！因為你從埃及領出來的百姓已經敗壞了自己；他們快快地偏離了我所吩咐的道，為自己鑄成了偶像。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT9_13","006_9_13","DEU","9","13","13","「耶和華又對我說：『我看這百姓是硬着頸項的百姓。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT9_14","006_9_14","DEU","9","14","14","你且由着我，我要滅絕他們，將他們的名從天下塗抹，使你的後裔比他們成為更大更強的國。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","於是我轉身下山，山被火燒着，兩塊約版在我兩手之中。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","我一看見你們得罪了耶和華－你們的上帝，鑄成了牛犢，快快地偏離了耶和華所吩咐你們的道， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","我就把那兩塊版從我手中扔下去，在你們眼前摔碎了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","因你們所犯的一切罪，行了耶和華眼中看為惡的事，惹他發怒，我就像從前俯伏在耶和華面前四十晝夜，沒有吃飯，也沒有喝水。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","我因耶和華向你們大發烈怒，要滅絕你們，就甚害怕；但那次耶和華又應允了我。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT9_20","006_9_20","DEU","9","20","20","耶和華也向亞倫甚是發怒，要滅絕他；那時我又為亞倫祈禱。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT9_21","006_9_21","DEU","9","21","21","我把那叫你們犯罪所鑄的牛犢用火焚燒，又搗碎磨得很細，以致細如灰塵，我就把這灰塵撒在從山上流下來的溪水中。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT9_22","006_9_22","DEU","9","22","22","「你們在他備拉、瑪撒、基博羅‧哈他瓦又惹耶和華發怒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT9_23","006_9_23","DEU","9","23","23","耶和華打發你們離開加低斯‧巴尼亞，說：『你們上去得我所賜給你們的地。』那時你們違背了耶和華－你們上帝的命令，不信服他，不聽從他的話。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT9_24","006_9_24","DEU","9","24","24","自從我認識你們以來，你們常常悖逆耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT9_25","006_9_25","DEU","9","25","25","「我因耶和華說要滅絕你們，就在耶和華面前照舊俯伏四十晝夜。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT9_26","006_9_26","DEU","9","26","26","我祈禱耶和華說：『主耶和華啊，求你不要滅絕你的百姓。他們是你的產業，是你用大力救贖的，用大能從埃及領出來的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT9_27","006_9_27","DEU","9","27","27","求你記念你的僕人亞伯拉罕、以撒、雅各，不要想念這百姓的頑梗、邪惡、罪過， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT9_28","006_9_28","DEU","9","28","28","免得你領我們出來的那地之人說，耶和華因為不能將這百姓領進他所應許之地，又因恨他們，所以領他們出去，要在曠野殺他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT9_29","006_9_29","DEU","9","29","29","其實他們是你的百姓，你的產業，是你用大能和伸出來的膀臂領出來的。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT10_1","006_10_1","DEU","10","1","1","「那時，耶和華吩咐我說：『你要鑿出兩塊石版，和先前的一樣，上山到我這裏來，又要做一木櫃。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT10_2","006_10_2","DEU","10","2","2","你先前摔碎的那版，其上的字我要寫在這版上；你要將這版放在櫃中。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT10_3","006_10_3","DEU","10","3","3","於是我用皂莢木做了一櫃，又鑿出兩塊石版，和先前的一樣，手裏拿這兩塊版上山去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT10_4","006_10_4","DEU","10","4","4","耶和華將那大會之日、在山上從火中所傳與你們的十條誡，照先前所寫的，寫在這版上，將版交給我了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT10_5","006_10_5","DEU","10","5","5","我轉身下山，將這版放在我所做的櫃中，現今還在那裏，正如耶和華所吩咐我的。」 （ ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT10_6","006_10_6","DEU","10","6","6","以色列人從比羅比尼‧亞干起行，到了摩西拉。亞倫死在那裏，就葬在那裏。他兒子以利亞撒接續他供祭司的職分。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT10_7","006_10_7","DEU","10","7","7","他們從那裏起行，到了谷歌大，又從谷歌大到了有溪水之地的約巴他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT10_8","006_10_8","DEU","10","8","8","那時，耶和華將利未支派分別出來，抬耶和華的約櫃，又侍立在耶和華面前事奉他，奉他的名祝福，直到今日。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT10_9","006_10_9","DEU","10","9","9","所以利未人在他弟兄中無分無業，耶和華是他的產業，正如耶和華－你上帝所應許他的。） ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT10_10","006_10_10","DEU","10","10","10","「我又像從前在山上住了四十晝夜。那次耶和華也應允我，不忍將你滅絕。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT10_11","006_10_11","DEU","10","11","11","耶和華吩咐我說：『你起來引導這百姓，使他們進去得我向他們列祖起誓應許所賜之地。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT10_12","006_10_12","DEU","10","12","12","「以色列啊，現在耶和華－你上帝向你所要的是甚麼呢？只要你敬畏耶和華－你的上帝，遵行他的道，愛他，盡心盡性事奉他， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT10_13","006_10_13","DEU","10","13","13","遵守他的誡命律例，就是我今日所吩咐你的，為要叫你得福。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT10_14","006_10_14","DEU","10","14","14","看哪，天和天上的天，地和地上所有的，都屬耶和華－你的上帝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT10_15","006_10_15","DEU","10","15","15","耶和華但喜悅你的列祖，愛他們，從萬民中揀選他們的後裔，就是你們，像今日一樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT10_16","006_10_16","DEU","10","16","16","所以你們要將心裏的污穢除掉，不可再硬着頸項。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT10_17","006_10_17","DEU","10","17","17","因為耶和華－你們的上帝－他是萬神之神，萬主之主，至大的上帝，大有能力，大而可畏，不以貌取人，也不受賄賂。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT10_18","006_10_18","DEU","10","18","18","他為孤兒寡婦伸冤，又憐愛寄居的，賜給他衣食。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT10_19","006_10_19","DEU","10","19","19","所以你們要憐愛寄居的，因為你們在埃及地也作過寄居的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT10_20","006_10_20","DEU","10","20","20","你要敬畏耶和華－你的上帝，事奉他，專靠他，也要指着他的名起誓。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT10_21","006_10_21","DEU","10","21","21","他是你所讚美的，是你的上帝，為你做了那大而可畏的事，是你親眼所看見的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT10_22","006_10_22","DEU","10","22","22","你的列祖七十人下埃及；現在耶和華－你的上帝使你如同天上的星那樣多。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT11_1","006_11_1","DEU","11","1","1","「你要愛耶和華－你的上帝，常守他的吩咐、律例、典章、誡命。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT11_2","006_11_2","DEU","11","2","2","你們今日當知道，我本不是和你們的兒女說話；因為他們不知道，也沒有看見耶和華－你們上帝的管教、威嚴、大能的手，和伸出來的膀臂， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT11_3","006_11_3","DEU","11","3","3","並他在埃及中向埃及王法老和其全地所行的神蹟奇事； ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT11_4","006_11_4","DEU","11","4","4","也沒有看見他怎樣待埃及的軍兵、車馬，他們追趕你們的時候，耶和華怎樣使紅海的水淹沒他們，將他們滅絕，直到今日， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT11_5","006_11_5","DEU","11","5","5","並他在曠野怎樣待你們，以致你們來到這地方； ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT11_6","006_11_6","DEU","11","6","6","也沒有看見他怎樣待呂便子孫以利押的兒子大坍、亞比蘭，地怎樣在以色列人中間開口，吞了他們和他們的家眷，並帳棚與跟他們的一切活物。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT11_7","006_11_7","DEU","11","7","7","惟有你們親眼看見耶和華所做的一切大事。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT11_8","006_11_8","DEU","11","8","8","「所以，你們要守我今日所吩咐的一切誡命，使你們膽壯，能以進去，得你們所要得的那地， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT11_9","006_11_9","DEU","11","9","9","並使你們的日子在耶和華向你們列祖起誓、應許給他們和他們後裔的地上得以長久；那是流奶與蜜之地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT11_10","006_11_10","DEU","11","10","10","你要進去得為業的那地，本不像你出來的埃及地。你在那裏撒種，用腳澆灌，像澆灌菜園一樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT11_11","006_11_11","DEU","11","11","11","你們要過去得為業的那地乃是有山有谷、雨水滋潤之地， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT11_12","006_11_12","DEU","11","12","12","是耶和華－你上帝所眷顧的；從歲首到年終，耶和華－你上帝的眼目時常看顧那地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT11_13","006_11_13","DEU","11","13","13","「你們若留意聽從我今日所吩咐的誡命，愛耶和華－你們的上帝，盡心盡性事奉他， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT11_14","006_11_14","DEU","11","14","14","他必按時降秋雨春雨在你們的地上，使你們可以收藏五穀、新酒，和油， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT11_15","006_11_15","DEU","11","15","15","也必使你吃得飽足，並使田野為你的牲畜長草。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT11_16","006_11_16","DEU","11","16","16","你們要謹慎，免得心中受迷惑，就偏離正路，去事奉敬拜別神。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT11_17","006_11_17","DEU","11","17","17","耶和華的怒氣向你們發作，就使天閉塞不下雨，地也不出產，使你們在耶和華所賜給你們的美地上速速滅亡。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT11_18","006_11_18","DEU","11","18","18","「你們要將我這話存在心內，留在意中，繫在手上為記號，戴在額上為經文； ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT11_19","006_11_19","DEU","11","19","19","也要教訓你們的兒女，無論坐在家裏，行在路上，躺下，起來，都要談論； ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT11_20","006_11_20","DEU","11","20","20","又要寫在房屋的門框上，並城門上， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT11_21","006_11_21","DEU","11","21","21","使你們和你們子孫的日子在耶和華向你們列祖起誓、應許給他們的地上得以增多，如天覆地的日子那樣多。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT11_22","006_11_22","DEU","11","22","22","你們若留意謹守遵行我所吩咐這一切的誡命，愛耶和華－你們的上帝，行他的道，專靠他， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT11_23","006_11_23","DEU","11","23","23","他必從你們面前趕出這一切國民，就是比你們更大更強的國民，你們也要得他們的地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT11_24","006_11_24","DEU","11","24","24","凡你們腳掌所踏之地都必歸你們；從曠野和黎巴嫩，並幼發拉底大河，直到西海，都要作你們的境界。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT11_25","006_11_25","DEU","11","25","25","必無一人能在你們面前站立得住；耶和華－你們的上帝必照他所說的，使懼怕驚恐臨到你們所踏之地的居民。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT11_26","006_11_26","DEU","11","26","26","「看哪，我今日將祝福與咒詛的話都陳明在你們面前。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT11_27","006_11_27","DEU","11","27","27","你們若聽從耶和華－你們上帝的誡命，就是我今日所吩咐你們的，就必蒙福。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT11_28","006_11_28","DEU","11","28","28","你們若不聽從耶和華－你們上帝的誡命，偏離我今日所吩咐你們的道，去事奉你們素來所不認識的別神，就必受禍。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT11_29","006_11_29","DEU","11","29","29","及至耶和華－你的上帝領你進入要去得為業的那地，你就要將祝福的話陳明在基利心山上，將咒詛的話陳明在以巴路山上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT11_30","006_11_30","DEU","11","30","30","這二山豈不是在約旦河那邊，日落之處，在住亞拉巴的迦南人之地與吉甲相對，靠近摩利橡樹嗎？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT11_31","006_11_31","DEU","11","31","31","你們要過約旦河，進去得耶和華－你們上帝所賜你們為業之地，在那地居住。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT11_32","006_11_32","DEU","11","32","32","你們要謹守遵行我今日在你們面前所陳明的一切律例典章。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT12_1","006_12_1","DEU","12","1","1","「你們存活於世的日子，在耶和華－你們列祖的上帝所賜你們為業的地上，要謹守遵行的律例典章乃是這些： ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT12_2","006_12_2","DEU","12","2","2","你們要將所趕出的國民事奉神的各地方，無論是在高山，在小山，在各青翠樹下，都毀壞了； ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT12_3","006_12_3","DEU","12","3","3","也要拆毀他們的祭壇，打碎他們的柱像，用火焚燒他們的木偶，砍下他們雕刻的神像，並將其名從那地方除滅。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT12_4","006_12_4","DEU","12","4","4","你們不可照他們那樣事奉耶和華－你們的上帝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT12_5","006_12_5","DEU","12","5","5","但耶和華－你們的上帝從你們各支派中選擇何處為立他名的居所，你們就當往那裏去求問， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT12_6","006_12_6","DEU","12","6","6","將你們的燔祭、平安祭、十分取一之物，和手中的舉祭，並還願祭、甘心祭，以及牛群羊群中頭生的，都奉到那裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT12_7","006_12_7","DEU","12","7","7","在那裏，耶和華－你們上帝的面前，你們和你們的家屬都可以吃，並且因你手所辦的一切事蒙耶和華－你的上帝賜福，就都歡樂。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT12_8","006_12_8","DEU","12","8","8","我們今日在這裏所行的是各人行自己眼中看為正的事，你們將來不可這樣行； ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT12_9","006_12_9","DEU","12","9","9","因為你們還沒有到耶和華－你上帝所賜你的安息地，所給你的產業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT12_10","006_12_10","DEU","12","10","10","但你們過了約旦河，得以住在耶和華－你們上帝使你們承受為業之地，又使你們太平，不被四圍的一切仇敵擾亂，安然居住。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT12_11","006_12_11","DEU","12","11","11","那時要將我所吩咐你們的燔祭、平安祭、十分取一之物，和手中的舉祭，並向耶和華許願獻的一切美祭，都奉到耶和華－你們上帝所選擇要立為他名的居所。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT12_12","006_12_12","DEU","12","12","12","你們和兒女、僕婢，並住在你們城裏無分無業的利未人，都要在耶和華－你們的上帝面前歡樂。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT12_13","006_12_13","DEU","12","13","13","你要謹慎，不可在你所看中的各處獻燔祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT12_14","006_12_14","DEU","12","14","14","惟獨耶和華從你那一支派中所選擇的地方，你就要在那裏獻燔祭，行我一切所吩咐你的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT12_15","006_12_15","DEU","12","15","15","「然而，在你各城裏都可以照耶和華－你上帝所賜你的福分，隨心所欲宰牲吃肉；無論潔淨人不潔淨人都可以吃，就如吃羚羊與鹿一般。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT12_16","006_12_16","DEU","12","16","16","只是不可吃血，要倒在地上，如同倒水一樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT12_17","006_12_17","DEU","12","17","17","你的五穀、新酒，和油的十分之一，或是牛群羊群中頭生的，或是你許願獻的，甘心獻的，或是手中的舉祭，都不可在你城裏吃。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT12_18","006_12_18","DEU","12","18","18","但要在耶和華－你的上帝面前吃，在耶和華－你上帝所要選擇的地方，你和兒女、僕婢，並住在你城裏的利未人，都可以吃；也要因你手所辦的，在耶和華－你上帝面前歡樂。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT12_19","006_12_19","DEU","12","19","19","你要謹慎，在你所住的地方永不可丟棄利未人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT12_20","006_12_20","DEU","12","20","20","「耶和華－你的上帝照他所應許擴張你境界的時候，你心裏想要吃肉，說：『我要吃肉』，就可以隨心所欲地吃肉。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT12_21","006_12_21","DEU","12","21","21","耶和華－你上帝所選擇要立他名的地方若離你太遠，就可以照我所吩咐的，將耶和華賜給你的牛羊取些宰了，可以隨心所欲在你城裏吃。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT12_22","006_12_22","DEU","12","22","22","你吃那肉，要像吃羚羊與鹿一般；無論潔淨人不潔淨人都可以吃。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT12_23","006_12_23","DEU","12","23","23","只是你要心意堅定，不可吃血，因為血是生命；不可將血與肉同吃。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT12_24","006_12_24","DEU","12","24","24","不可吃血，要倒在地上，如同倒水一樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT12_25","006_12_25","DEU","12","25","25","不可吃血。這樣，你行耶和華眼中看為正的事，你和你的子孫就可以得福。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT12_26","006_12_26","DEU","12","26","26","只是你分別為聖的物和你的還願祭要奉到耶和華所選擇的地方去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT12_27","006_12_27","DEU","12","27","27","你的燔祭，連肉帶血，都要獻在耶和華－你上帝的壇上。平安祭的血要倒在耶和華－你上帝的壇上；平安祭的肉，你自己可以吃。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT12_28","006_12_28","DEU","12","28","28","你要謹守聽從我所吩咐的一切話，行耶和華－你上帝眼中看為善，看為正的事。這樣，你和你的子孫就可以永遠享福。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT12_29","006_12_29","DEU","12","29","29","「耶和華－你上帝將你要去趕出的國民從你面前剪除，你得了他們的地居住， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT12_30","006_12_30","DEU","12","30","30","那時就要謹慎，不可在他們除滅之後隨從他們的惡俗，陷入網羅，也不可訪問他們的神說：『這些國民怎樣事奉他們的神，我也要照樣行。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT12_31","006_12_31","DEU","12","31","31","你不可向耶和華－你的上帝這樣行，因為他們向他們的神行了耶和華所憎嫌所恨惡的一切事，甚至將自己的兒女用火焚燒，獻與他們的神。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT12_32","006_12_32","DEU","12","32","32","凡我所吩咐的，你們都要謹守遵行，不可加添，也不可刪減。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT13_1","006_13_1","DEU","13","1","1","「你們中間若有先知或是做夢的起來，向你顯個神蹟奇事， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT13_2","006_13_2","DEU","13","2","2","對你說：『我們去隨從你素來所不認識的別神，事奉它吧。』他所顯的神蹟奇事雖有應驗， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT13_3","006_13_3","DEU","13","3","3","你也不可聽那先知或是那做夢之人的話；因為這是耶和華－你們的上帝試驗你們，要知道你們是盡心盡性愛耶和華－你們的上帝不是。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT13_4","006_13_4","DEU","13","4","4","你們要順從耶和華－你們的上帝，敬畏他，謹守他的誡命，聽從他的話，事奉他，專靠他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT13_5","006_13_5","DEU","13","5","5","那先知或是那做夢的既用言語叛逆那領你們出埃及地、救贖你脫離為奴之家的耶和華－你們的上帝，要勾引你離開耶和華－你上帝所吩咐你行的道，你便要將他治死。這樣，就把那惡從你們中間除掉。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT13_6","006_13_6","DEU","13","6","6","「你的同胞弟兄，或是你的兒女，或是你懷中的妻，或是如同你性命的朋友，若暗中引誘你，說：『我們不如去事奉你和你列祖素來所不認識的別神－ ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT13_7","006_13_7","DEU","13","7","7","是你四圍列國的神。』無論是離你近，離你遠，從地這邊到地那邊的神， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT13_8","006_13_8","DEU","13","8","8","你不可依從他，也不可聽從他，眼不可顧惜他。你不可憐恤他，也不可遮庇他， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT13_9","006_13_9","DEU","13","9","9","總要殺他；你先下手，然後眾民也下手，將他治死。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT13_10","006_13_10","DEU","13","10","10","要用石頭打死他，因為他想要勾引你離開那領你出埃及地為奴之家的耶和華－你的上帝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT13_11","006_13_11","DEU","13","11","11","以色列眾人都要聽見害怕，就不敢在你們中間再行這樣的惡了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT13_12","006_13_12","DEU","13","12","13","「在耶和華－你上帝所賜你居住的各城中，你若聽人說，有些匪類從你們中間的一座城出來勾引本城的居民，說：『我們不如去事奉你們素來所不認識的別神』； ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT13_14","006_13_14","DEU","13","14","14","你就要探聽，查究，細細地訪問，果然是真，準有這可憎惡的事行在你們中間， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT13_15","006_13_15","DEU","13","15","15","你必要用刀殺那城裏的居民，把城裏所有的，連牲畜，都用刀殺盡。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT13_16","006_13_16","DEU","13","16","16","你從那城裏所奪的財物都要堆積在街市上，用火將城和其內所奪的財物都在耶和華－你上帝面前燒盡；那城就永為荒堆，不可再建造。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT13_17","006_13_17","DEU","13","17","18","那當毀滅的物連一點都不可粘你的手。你要聽從耶和華－你上帝的話，遵守我今日所吩咐你的一切誡命，行耶和華－你上帝眼中看為正的事，耶和華就必轉意，不發烈怒，恩待你，憐恤你，照他向你列祖所起的誓使你人數增多。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT14_1","006_14_1","DEU","14","1","1","「你們是耶和華－你們上帝的兒女。不可為死人用刀劃身，也不可將額上剃光； ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT14_2","006_14_2","DEU","14","2","2","因為你歸耶和華－你上帝為聖潔的民，耶和華從地上的萬民中揀選你特作自己的子民。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT14_3","006_14_3","DEU","14","3","3","「凡可憎的物都不可吃。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT14_4","006_14_4","DEU","14","4","4","可吃的牲畜就是牛、綿羊、山羊、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT14_5","006_14_5","DEU","14","5","5","鹿、羚羊、誁子、野山羊、麋鹿、黃羊、青羊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT14_6","006_14_6","DEU","14","6","6","凡分蹄成為兩瓣又倒嚼的走獸，你們都可以吃。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT14_7","006_14_7","DEU","14","7","7","但那些倒嚼或是分蹄之中不可吃的乃是駱駝、觠子、沙番－因為是倒嚼不分蹄，就與你們不潔淨； ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT14_8","006_14_8","DEU","14","8","8","豬－因為是分蹄卻不倒嚼，就與你們不潔淨。這些獸的肉，你們不可吃，死的也不可摸。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT14_9","006_14_9","DEU","14","9","9","「水中可吃的乃是這些：凡有翅有鱗的都可以吃； ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT14_10","006_14_10","DEU","14","10","10","凡無翅無鱗的都不可吃，是與你們不潔淨。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT14_11","006_14_11","DEU","14","11","11","「凡潔淨的鳥，你們都可以吃。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT14_12","006_14_12","DEU","14","12","12","不可吃的乃是鵰、狗頭鵰、紅頭鵰、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT14_13","006_14_13","DEU","14","13","13","鸇、小鷹、鷂鷹與其類， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT14_14","006_14_14","DEU","14","14","14","烏鴉與其類， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT14_15","006_14_15","DEU","14","15","15","鴕鳥、夜鷹、魚鷹、鷹與其類， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT14_16","006_14_16","DEU","14","16","16","鴞鳥、貓頭鷹、角鴟、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT14_17","006_14_17","DEU","14","17","17","鵜鶘、禿鵰、鸕鶿、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT14_18","006_14_18","DEU","14","18","18","鸛、鷺鷥與其類，戴鵀與蝙蝠。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT14_19","006_14_19","DEU","14","19","19","凡有翅膀爬行的物是與你們不潔淨，都不可吃。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT14_20","006_14_20","DEU","14","20","20","凡潔淨的鳥，你們都可以吃。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT14_21","006_14_21","DEU","14","21","21","「凡自死的，你們都不可吃，可以給你城裏寄居的吃，或賣與外人吃，因為你是歸耶和華－你上帝為聖潔的民。 「不可用山羊羔母的奶煮山羊羔。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT14_22","006_14_22","DEU","14","22","22","「你要把你撒種所產的，就是你田地每年所出的，十分取一分； ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT14_23","006_14_23","DEU","14","23","23","又要把你的五穀、新酒、和油的十分之一，並牛群羊群中頭生的，吃在耶和華－你上帝面前，就是他所選擇要立為他名的居所。這樣，你可以學習時常敬畏耶和華－你的上帝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT14_24","006_14_24","DEU","14","24","24","當耶和華－你上帝賜福與你的時候，耶和華－你上帝所選擇要立為他名的地方若離你太遠，那路也太長，使你不能把這物帶到那裏去， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT14_25","006_14_25","DEU","14","25","25","你就可以換成銀子，將銀子包起來，拿在手中，往耶和華－你上帝所要選擇的地方去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT14_26","006_14_26","DEU","14","26","26","你用這銀子，隨心所欲，或買牛羊，或買清酒濃酒，凡你心所想的都可以買；你和你的家屬在耶和華－你上帝的面前吃喝快樂。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT14_27","006_14_27","DEU","14","27","27","「住在你城裏的利未人，你不可丟棄他，因為他在你們中間無分無業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT14_28","006_14_28","DEU","14","28","28","每逢三年的末一年，你要將本年的土產十分之一都取出來，積存在你的城中。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT14_29","006_14_29","DEU","14","29","29","在你城裏無分無業的利未人，和你城裏寄居的，並孤兒寡婦，都可以來，吃得飽足。這樣，耶和華－你的上帝必在你手裏所辦的一切事上賜福與你。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT15_1","006_15_1","DEU","15","1","1","「每逢七年末一年，你要施行豁免。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT15_2","006_15_2","DEU","15","2","2","豁免的定例乃是這樣：凡債主要把所借給鄰舍的豁免了；不可向鄰舍和弟兄追討，因為耶和華的豁免年已經宣告了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT15_3","006_15_3","DEU","15","3","3","若借給外邦人，你可以向他追討；但借給你弟兄，無論是甚麼，你要鬆手豁免了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT15_4","006_15_4","DEU","15","4","5","你若留意聽從耶和華－你上帝的話，謹守遵行我今日所吩咐你這一切的命令，就必在你們中間沒有窮人了（在耶和華－你上帝所賜你為業的地上，耶和華必大大賜福與你。） ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT15_6","006_15_6","DEU","15","6","6","因為耶和華－你的上帝必照他所應許你的賜福與你。你必借給許多國民，卻不致向他們借貸；你必管轄許多國民，他們卻不能管轄你。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT15_7","006_15_7","DEU","15","7","7","「在耶和華－你上帝所賜你的地上，無論哪一座城裏，你弟兄中若有一個窮人，你不可忍着心、揝着手不幫補你窮乏的弟兄。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT15_8","006_15_8","DEU","15","8","8","總要向他鬆開手，照他所缺乏的借給他，補他的不足。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT15_9","006_15_9","DEU","15","9","9","你要謹慎，不可心裏起惡念，說：『第七年的豁免年快到了』，你便惡眼看你窮乏的弟兄，甚麼都不給他，以致他因你求告耶和華，罪便歸於你了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT15_10","006_15_10","DEU","15","10","10","你總要給他，給他的時候心裏不可愁煩；因耶和華－你的上帝必在你這一切所行的，並你手裏所辦的事上，賜福與你。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT15_11","006_15_11","DEU","15","11","11","原來那地上的窮人永不斷絕；所以我吩咐你說：『總要向你地上困苦窮乏的弟兄鬆開手。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT15_12","006_15_12","DEU","15","12","12","「你弟兄中，若有一個希伯來男人或希伯來女人被賣給你，服事你六年，到第七年就要任他自由出去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT15_13","006_15_13","DEU","15","13","13","你任他自由的時候，不可使他空手而去， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT15_14","006_15_14","DEU","15","14","14","要從你羊群、禾場、酒醡之中多多地給他；耶和華－你的上帝怎樣賜福與你，你也要照樣給他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT15_15","006_15_15","DEU","15","15","15","要記念你在埃及地作過奴僕，耶和華－你的上帝將你救贖；因此，我今日吩咐你這件事。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT15_16","006_15_16","DEU","15","16","16","他若對你說：『我不願意離開你』，是因他愛你和你的家，且因在你那裏很好， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT15_17","006_15_17","DEU","15","17","17","你就要拿錐子將他的耳朵在門上刺透，他便永為你的奴僕了。你待婢女也要這樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT15_18","006_15_18","DEU","15","18","18","你任他自由的時候，不可以為難事，因他服事你六年，較比雇工的工價多加一倍了。耶和華－你的上帝就必在你所做的一切事上賜福與你。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT15_19","006_15_19","DEU","15","19","19","「你牛群羊群中頭生的，凡是公的，都要分別為聖，歸耶和華－你的上帝。牛群中頭生的，不可用牠耕地；羊群中頭生的，不可剪毛。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT15_20","006_15_20","DEU","15","20","20","這頭生的，你和你的家屬，每年要在耶和華所選擇的地方，在耶和華－你上帝面前吃。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT15_21","006_15_21","DEU","15","21","21","這頭生的若有甚麼殘疾，就如瘸腿的、瞎眼的，無論有甚麼惡殘疾，都不可獻給耶和華－你的上帝； ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT15_22","006_15_22","DEU","15","22","22","可以在你城裏吃；潔淨人與不潔淨人都可以吃，就如吃羚羊與鹿一般。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT15_23","006_15_23","DEU","15","23","23","只是不可吃牠的血；要倒在地上，如同倒水一樣。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT16_1","006_16_1","DEU","16","1","1","「你要注意亞筆月，向耶和華－你的上帝守逾越節，因為耶和華－你的上帝在亞筆月夜間領你出埃及。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT16_2","006_16_2","DEU","16","2","2","你當在耶和華所選擇要立為他名的居所，從牛群羊群中，將逾越節的祭牲獻給耶和華－你的上帝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT16_3","006_16_3","DEU","16","3","3","你吃這祭牲，不可吃有酵的餅；七日之內要吃無酵餅，就是困苦餅－你本是急忙出了埃及地－要叫你一生一世記念你從埃及地出來的日子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT16_4","006_16_4","DEU","16","4","4","在你四境之內，七日不可見麵酵，頭一日晚上所獻的肉，一點不可留到早晨。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT16_5","006_16_5","DEU","16","5","5","在耶和華－你上帝所賜的各城中，你不可獻逾越節的祭； ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT16_6","006_16_6","DEU","16","6","6","只當在耶和華－你上帝所選擇要立為他名的居所，晚上日落的時候，乃是你出埃及的時候，獻逾越節的祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT16_7","006_16_7","DEU","16","7","7","當在耶和華－你上帝所選擇的地方把肉烤了吃，次日早晨就回到你的帳棚去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT16_8","006_16_8","DEU","16","8","8","你要吃無酵餅六日，第七日要向耶和華－你的上帝守嚴肅會，不可做工。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT16_9","006_16_9","DEU","16","9","9","「你要計算七七日：從你開鐮收割禾稼時算起，共計七七日。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT16_10","006_16_10","DEU","16","10","10","你要照耶和華－你上帝所賜你的福，手裏拿着甘心祭，獻在耶和華－你的上帝面前，守七七節。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT16_11","006_16_11","DEU","16","11","11","你和你兒女、僕婢，並住在你城裏的利未人，以及在你們中間寄居的與孤兒寡婦，都要在耶和華－你上帝所選擇立為他名的居所，在耶和華－你的上帝面前歡樂。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT16_12","006_16_12","DEU","16","12","12","你也要記念你在埃及作過奴僕。你要謹守遵行這些律例。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT16_13","006_16_13","DEU","16","13","13","「你把禾場的穀、酒醡的酒收藏以後，就要守住棚節七日。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT16_14","006_16_14","DEU","16","14","14","守節的時候，你和你兒女、僕婢，並住在你城裏的利未人，以及寄居的與孤兒寡婦，都要歡樂。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT16_15","006_16_15","DEU","16","15","15","在耶和華所選擇的地方，你當向耶和華－你的上帝守節七日；因為耶和華－你上帝在你一切的土產上和你手裏所辦的事上要賜福與你，你就非常地歡樂。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT16_16","006_16_16","DEU","16","16","16","你一切的男丁要在除酵節、七七節、住棚節，一年三次，在耶和華－你上帝所選擇的地方朝見他，卻不可空手朝見。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT16_17","006_16_17","DEU","16","17","17","各人要按自己的力量，照耶和華－你上帝所賜的福分，奉獻禮物。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT16_18","006_16_18","DEU","16","18","18","「你要在耶和華－你上帝所賜的各城裏，按着各支派設立審判官和官長。他們必按公義的審判判斷百姓。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT16_19","006_16_19","DEU","16","19","19","不可屈枉正直；不可看人的外貌。也不可受賄賂；因為賄賂能叫智慧人的眼變瞎了，又能顛倒義人的話。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT16_20","006_16_20","DEU","16","20","20","你要追求至公至義，好叫你存活，承受耶和華－你上帝所賜你的地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT16_21","006_16_21","DEU","16","21","21","「你為耶和華－你的上帝築壇，不可在壇旁栽甚麼樹木作為木偶。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT16_22","006_16_22","DEU","16","22","22","也不可為自己設立柱像；這是耶和華－你上帝所恨惡的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT17_1","006_17_1","DEU","17","1","1","「凡有殘疾，或有甚麼惡病的牛羊，你都不可獻給耶和華－你的上帝，因為這是耶和華－你上帝所憎惡的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT17_2","006_17_2","DEU","17","2","2","「在你們中間，在耶和華－你上帝所賜你的諸城中，無論哪座城裏，若有人，或男或女，行耶和華－你上帝眼中看為惡的事，違背了他的約， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT17_3","006_17_3","DEU","17","3","3","去事奉敬拜別神，或拜日頭，或拜月亮，或拜天象，是主不曾吩咐的； ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT17_4","006_17_4","DEU","17","4","4","有人告訴你，你也聽見了，就要細細地探聽，果然是真，準有這可憎惡的事行在以色列中， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT17_5","006_17_5","DEU","17","5","5","你就要將行這惡事的男人或女人拉到城門外，用石頭將他打死。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT17_6","006_17_6","DEU","17","6","6","要憑兩三個人的口作見證將那當死的人治死；不可憑一個人的口作見證將他治死。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT17_7","006_17_7","DEU","17","7","7","見證人要先下手，然後眾民也下手將他治死。這樣，就把那惡從你們中間除掉。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT17_8","006_17_8","DEU","17","8","8","「你城中若起了爭訟的事，或因流血，或因爭競，或因毆打，是你難斷的案件，你就當起來，往耶和華－你上帝所選擇的地方 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT17_9","006_17_9","DEU","17","9","9","去見祭司利未人，並當時的審判官，求問他們，他們必將判語指示你。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT17_10","006_17_10","DEU","17","10","10","他們在耶和華所選擇的地方指示你的判語，你必照着他們所指教你的一切話謹守遵行。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT17_11","006_17_11","DEU","17","11","11","要按他們所指教你的律法，照他們所斷定的去行；他們所指示你的判語，你不可偏離左右。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT17_12","006_17_12","DEU","17","12","12","若有人擅敢不聽從那侍立在耶和華－你上帝面前的祭司，或不聽從審判官，那人就必治死；這樣，便將那惡從以色列中除掉。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT17_13","006_17_13","DEU","17","13","13","眾百姓都要聽見害怕，不再擅敢行事。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT17_14","006_17_14","DEU","17","14","14","「到了耶和華－你上帝所賜你的地，得了那地居住的時候，若說：『我要立王治理我，像四圍的國一樣。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT17_15","006_17_15","DEU","17","15","15","你總要立耶和華－你上帝所揀選的人為王。必從你弟兄中立一人；不可立你弟兄以外的人為王。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT17_16","006_17_16","DEU","17","16","16","只是王不可為自己加添馬匹，也不可使百姓回埃及去，為要加添他的馬匹，因耶和華曾吩咐你們說：『不可再回那條路去。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT17_17","006_17_17","DEU","17","17","17","他也不可為自己多立妃嬪，恐怕他的心偏邪；也不可為自己多積金銀。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT17_18","006_17_18","DEU","17","18","18","他登了國位，就要將祭司利未人面前的這律法書，為自己抄錄一本， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT17_19","006_17_19","DEU","17","19","19","存在他那裏，要平生誦讀，好學習敬畏耶和華－他的上帝，謹守遵行這律法書上的一切言語和這些律例， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT17_20","006_17_20","DEU","17","20","20","免得他向弟兄心高氣傲，偏左偏右，離了這誡命。這樣，他和他的子孫便可在以色列中，在國位上年長日久。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT18_1","006_18_1","DEU","18","1","1","「祭司利未人和利未全支派必在以色列中無分無業；他們所吃用的就是獻給耶和華的火祭和一切所捐的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT18_2","006_18_2","DEU","18","2","2","他們在弟兄中必沒有產業；耶和華是他們的產業，正如耶和華所應許他們的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT18_3","006_18_3","DEU","18","3","3","祭司從百姓所當得的分乃是這樣：凡獻牛或羊為祭的，要把前腿和兩腮並脾胃給祭司。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT18_4","006_18_4","DEU","18","4","4","初收的五穀、新酒和油，並初剪的羊毛，也要給他； ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT18_5","006_18_5","DEU","18","5","5","因為耶和華－你的上帝從你各支派中將他揀選出來，使他和他子孫永遠奉耶和華的名侍立，事奉。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT18_6","006_18_6","DEU","18","6","6","「利未人無論寄居在以色列中的哪一座城，若從那裏出來，一心願意到耶和華所選擇的地方， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT18_7","006_18_7","DEU","18","7","7","就要奉耶和華－他上帝的名事奉，像他眾弟兄利未人侍立在耶和華面前事奉一樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT18_8","006_18_8","DEU","18","8","8","除了他賣祖父產業所得的以外，還要得一分祭物與他們同吃。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT18_9","006_18_9","DEU","18","9","9","「你到了耶和華－你上帝所賜之地，那些國民所行可憎惡的事，你不可學着行。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT18_10","006_18_10","DEU","18","10","10","你們中間不可有人使兒女經火，也不可有占卜的、觀兆的、用法術的、行邪術的、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT18_11","006_18_11","DEU","18","11","11","用迷術的、交鬼的、行巫術的、過陰的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT18_12","006_18_12","DEU","18","12","12","凡行這些事的都為耶和華所憎惡；因那些國民行這可憎惡的事，所以耶和華－你的上帝將他們從你面前趕出。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT18_13","006_18_13","DEU","18","13","13","你要在耶和華－你的上帝面前作完全人。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT18_14","006_18_14","DEU","18","14","14","「因你所要趕出的那些國民都聽信觀兆的和占卜的，至於你，耶和華－你的上帝從來不許你這樣行。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT18_15","006_18_15","DEU","18","15","15","耶和華－你的上帝要從你們弟兄中間給你興起一位先知，像我，你們要聽從他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT18_16","006_18_16","DEU","18","16","16","正如你在何烈山大會的日子求耶和華－你上帝一切的話，說：『求你不再叫我聽見耶和華－我上帝的聲音，也不再叫我看見這大火，免得我死亡。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT18_17","006_18_17","DEU","18","17","17","耶和華就對我說：『他們所說的是。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT18_18","006_18_18","DEU","18","18","18","我必在他們弟兄中間給他們興起一位先知，像你。我要將當說的話傳給他；他要將我一切所吩咐的都傳給他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT18_19","006_18_19","DEU","18","19","19","誰不聽他奉我名所說的話，我必討誰的罪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT18_20","006_18_20","DEU","18","20","20","若有先知擅敢託我的名說我所未曾吩咐他說的話，或是奉別神的名說話，那先知就必治死。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT18_21","006_18_21","DEU","18","21","21","你心裏若說：『耶和華所未曾吩咐的話，我們怎能知道呢？』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT18_22","006_18_22","DEU","18","22","22","先知託耶和華的名說話，所說的若不成就，也無效驗，這就是耶和華所未曾吩咐的，是那先知擅自說的，你不要怕他。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT19_1","006_19_1","DEU","19","1","1","「耶和華－你上帝將列國之民剪除的時候，耶和華－你上帝也將他們的地賜給你，你接着住他們的城邑並他們的房屋， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT19_2","006_19_2","DEU","19","2","2","就要在耶和華－你上帝所賜你為業的地上分定三座城。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT19_3","006_19_3","DEU","19","3","3","要將耶和華－你上帝使你承受為業的地分為三段；又要預備道路，使誤殺人的，都可以逃到那裏去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT19_4","006_19_4","DEU","19","4","4","「誤殺人的逃到那裏可以存活，定例乃是這樣：凡素無仇恨，無心殺了人的， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT19_5","006_19_5","DEU","19","5","5","就如人與鄰舍同入樹林砍伐樹木，手拿斧子一砍，本想砍下樹木，不料，斧頭脫了把，飛落在鄰舍身上，以致於死，這人逃到那些城的一座城，就可以存活， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT19_6","006_19_6","DEU","19","6","6","免得報血仇的，心中火熱追趕他，因路遠就追上，將他殺死；其實他不該死，因為他與被殺的素無仇恨。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT19_7","006_19_7","DEU","19","7","7","所以我吩咐你說，要分定三座城。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT19_8","006_19_8","DEU","19","8","8","耶和華－你上帝若照他向你列祖所起的誓擴張你的境界，將所應許賜你列祖的地全然給你， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT19_9","006_19_9","DEU","19","9","9","你若謹守遵行我今日所吩咐的這一切誡命，愛耶和華－你的上帝，常常遵行他的道，就要在這三座城之外，再添三座城， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT19_10","006_19_10","DEU","19","10","10","免得無辜之人的血流在耶和華－你上帝所賜你為業的地上，流血的罪就歸於你。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT19_11","006_19_11","DEU","19","11","11","「若有人恨他的鄰舍，埋伏着起來擊殺他，以致於死，便逃到這些城的一座城， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT19_12","006_19_12","DEU","19","12","12","本城的長老就要打發人去，從那裏帶出他來，交在報血仇的手中，將他治死。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT19_13","006_19_13","DEU","19","13","13","你眼不可顧惜他，卻要從以色列中除掉流無辜血的罪，使你可以得福。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT19_14","006_19_14","DEU","19","14","14","「在耶和華－你上帝所賜你承受為業之地，不可挪移你鄰舍的地界，那是先人所定的。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT19_15","006_19_15","DEU","19","15","15","「人無論犯甚麼罪，作甚麼惡，不可憑一個人的口作見證，總要憑兩三個人的口作見證才可定案。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT19_16","006_19_16","DEU","19","16","16","若有凶惡的見證人起來，見證某人作惡， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT19_17","006_19_17","DEU","19","17","17","這兩個爭訟的人就要站在耶和華面前，和當時的祭司，並審判官面前， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT19_18","006_19_18","DEU","19","18","18","審判官要細細地查究，若見證人果然是作假見證的，以假見證陷害弟兄， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT19_19","006_19_19","DEU","19","19","19","你們就要待他如同他想要待的弟兄。這樣，就把那惡從你們中間除掉。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT19_20","006_19_20","DEU","19","20","20","別人聽見都要害怕，就不敢在你們中間再行這樣的惡了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT19_21","006_19_21","DEU","19","21","21","你眼不可顧惜，要以命償命，以眼還眼，以牙還牙，以手還手，以腳還腳。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT20_1","006_20_1","DEU","20","1","1","「你出去與仇敵爭戰的時候，看見馬匹、車輛，並有比你多的人民，不要怕他們，因為領你出埃及地的耶和華－你上帝與你同在。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT20_2","006_20_2","DEU","20","2","2","你們將要上陣的時候，祭司要到百姓面前宣告 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT20_3","006_20_3","DEU","20","3","3","說：『以色列人哪，你們當聽，你們今日將要與仇敵爭戰，不要膽怯，不要懼怕戰兢，也不要因他們驚恐； ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT20_4","006_20_4","DEU","20","4","4","因為耶和華－你們的上帝與你們同去，要為你們與仇敵爭戰，拯救你們。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT20_5","006_20_5","DEU","20","5","5","官長也要對百姓宣告說：『誰建造房屋，尚未奉獻，他可以回家去，恐怕他陣亡，別人去奉獻。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT20_6","006_20_6","DEU","20","6","6","誰種葡萄園，尚未用所結的果子，他可以回家去，恐怕他陣亡，別人去用。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT20_7","006_20_7","DEU","20","7","7","誰聘定了妻，尚未迎娶，他可以回家去，恐怕他陣亡，別人去娶。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT20_8","006_20_8","DEU","20","8","8","官長又要對百姓宣告說：『誰懼怕膽怯，他可以回家去，恐怕他弟兄的心消化，和他一樣。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT20_9","006_20_9","DEU","20","9","9","官長對百姓宣告完了，就當派軍長率領他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT20_10","006_20_10","DEU","20","10","10","「你臨近一座城、要攻打的時候，先要對城裏的民宣告和睦的話。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT20_11","006_20_11","DEU","20","11","11","他們若以和睦的話回答你，給你開了城，城裏所有的人都要給你效勞，服事你； ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT20_12","006_20_12","DEU","20","12","12","若不肯與你和好，反要與你打仗，你就要圍困那城。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT20_13","006_20_13","DEU","20","13","13","耶和華－你的上帝把城交付你手，你就要用刀殺盡這城的男丁。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT20_14","006_20_14","DEU","20","14","14","惟有婦女、孩子、牲畜，和城內一切的財物，你可以取為自己的掠物。耶和華－你上帝把你仇敵的財物賜給你，你可以吃用。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT20_15","006_20_15","DEU","20","15","15","離你甚遠的各城，不是這些國民的城，你都要這樣待他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT20_16","006_20_16","DEU","20","16","16","但這些國民的城，耶和華－你上帝既賜你為業，其中凡有氣息的，一個不可存留； ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT20_17","006_20_17","DEU","20","17","17","只要照耶和華－你上帝所吩咐的將這赫人、亞摩利人、迦南人、比利洗人、希未人、耶布斯人都滅絕淨盡， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT20_18","006_20_18","DEU","20","18","18","免得他們教導你們學習一切可憎惡的事，就是他們向自己神所行的，以致你們得罪耶和華－你們的上帝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT20_19","006_20_19","DEU","20","19","19","「你若許久圍困、攻打所要取的一座城，就不可舉斧子砍壞樹木；因為你可以吃那樹上的果子，不可砍伐。田間的樹木豈是人，叫你糟蹋嗎？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT20_20","006_20_20","DEU","20","20","20","惟獨你所知道不是結果子的樹木可以毀壞、砍伐，用以修築營壘，攻擊那與你打仗的城，直到攻塌了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT21_1","006_21_1","DEU","21","1","1","「在耶和華－你上帝所賜你為業的地上，若遇見被殺的人倒在田野，不知道是誰殺的， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT21_2","006_21_2","DEU","21","2","2","長老和審判官就要出去，從被殺的人那裏量起，直量到四圍的城邑， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT21_3","006_21_3","DEU","21","3","3","看哪城離被殺的人最近，那城的長老就要從牛群中取一隻未曾耕地、未曾負軛的母牛犢， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT21_4","006_21_4","DEU","21","4","4","把母牛犢牽到流水、未曾耕種的山谷去，在谷中打折母牛犢的頸項。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT21_5","006_21_5","DEU","21","5","5","祭司利未的子孫要近前來；因為耶和華－你的上帝揀選了他們事奉他，奉耶和華的名祝福，所有爭訟毆打的事都要憑他們判斷。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT21_6","006_21_6","DEU","21","6","6","那城的眾長老，就是離被殺的人最近的，要在那山谷中，在所打折頸項的母牛犢以上洗手， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT21_7","006_21_7","DEU","21","7","7","禱告說：『我們的手未曾流這人的血；我們的眼也未曾看見這事。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT21_8","006_21_8","DEU","21","8","8","耶和華啊，求你赦免你所救贖的以色列民，不要使流無辜血的罪歸在你的百姓以色列中間。』這樣，流血的罪必得赦免。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT21_9","006_21_9","DEU","21","9","9","你行耶和華眼中看為正的事，就可以從你們中間除掉流無辜血的罪。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT21_10","006_21_10","DEU","21","10","10","「你出去與仇敵爭戰的時候，耶和華－你的上帝將他們交在你手中，你就擄了他們去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT21_11","006_21_11","DEU","21","11","11","若在被擄的人中見有美貌的女子，戀慕她，要娶她為妻， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT21_12","006_21_12","DEU","21","12","12","就可以領她到你家裏去；她便要剃頭髮，修指甲， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT21_13","006_21_13","DEU","21","13","13","脫去被擄時所穿的衣服，住在你家裏哀哭父母一個整月，然後可以與她同房。你作她的丈夫，她作你的妻子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT21_14","006_21_14","DEU","21","14","14","後來你若不喜悅她，就要由她隨意出去，決不可為錢賣她，也不可當婢女待她，因為你玷污了她。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT21_15","006_21_15","DEU","21","15","15","「人若有二妻，一為所愛，一為所惡，所愛的、所惡的都給他生了兒子，但長子是所惡之妻生的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT21_16","006_21_16","DEU","21","16","16","到了把產業分給兒子承受的時候，不可將所愛之妻生的兒子立為長子，在所惡之妻生的兒子以上， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT21_17","006_21_17","DEU","21","17","17","卻要認所惡之妻生的兒子為長子，將產業多加一分給他；因這兒子是他力量強壯的時候生的，長子的名分本當歸他。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT21_18","006_21_18","DEU","21","18","18","「人若有頑梗悖逆的兒子，不聽從父母的話，他們雖懲治他，他仍不聽從， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT21_19","006_21_19","DEU","21","19","19","父母就要抓住他，將他帶到本地的城門、本城的長老那裏， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT21_20","006_21_20","DEU","21","20","20","對長老說：『我們這兒子頑梗悖逆，不聽從我們的話，是貪食好酒的人。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT21_21","006_21_21","DEU","21","21","21","本城的眾人就要用石頭將他打死。這樣，就把那惡從你們中間除掉，以色列眾人都要聽見害怕。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT21_22","006_21_22","DEU","21","22","22","「人若犯該死的罪，被治死了，你將他掛在木頭上， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT21_23","006_21_23","DEU","21","23","23","他的屍首不可留在木頭上過夜，必要當日將他葬埋，免得玷污了耶和華－你上帝所賜你為業之地。因為被掛的人是在上帝面前受咒詛的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT22_1","006_22_1","DEU","22","1","1","「你若看見弟兄的牛或羊失迷了路，不可佯為不見，總要把牠牽回來交給你的弟兄。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT22_2","006_22_2","DEU","22","2","2","你弟兄若離你遠，或是你不認識他，就要牽到你家去，留在你那裏，等你弟兄來尋找就還給他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT22_3","006_22_3","DEU","22","3","3","你的弟兄無論失落甚麼，或是驢，或是衣服，你若遇見，都要這樣行，不可佯為不見。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT22_4","006_22_4","DEU","22","4","4","你若看見弟兄的牛或驢跌倒在路上，不可佯為不見，總要幫助他拉起來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT22_5","006_22_5","DEU","22","5","5","「婦女不可穿戴男子所穿戴的，男子也不可穿婦女的衣服，因為這樣行都是耶和華－你上帝所憎惡的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT22_6","006_22_6","DEU","22","6","6","「你若路上遇見鳥窩，或在樹上或在地上，裏頭有雛或有蛋，母鳥伏在雛上或在蛋上，你不可連母帶雛一併取去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT22_7","006_22_7","DEU","22","7","7","總要放母，只可取雛；這樣你就可以享福，日子得以長久。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT22_8","006_22_8","DEU","22","8","8","「你若建造房屋，要在房上的四圍安欄杆，免得有人從房上掉下來，流血的罪就歸於你家。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT22_9","006_22_9","DEU","22","9","9","「不可把兩樣種子種在你的葡萄園裏，免得你撒種所結的和葡萄園的果子都要充公。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT22_10","006_22_10","DEU","22","10","10","不可並用牛、驢耕地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT22_11","006_22_11","DEU","22","11","11","不可穿羊毛、細麻兩樣攙雜料做的衣服。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT22_12","006_22_12","DEU","22","12","12","「你要在所披的外衣上四圍做繸子。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT22_13","006_22_13","DEU","22","13","13","「人若娶妻，與她同房之後恨惡她， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT22_14","006_22_14","DEU","22","14","14","信口說她，將醜名加在她身上，說：『我娶了這女子，與她同房，見她沒有貞潔的憑據』； ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT22_15","006_22_15","DEU","22","15","15","女子的父母就要把女子貞潔的憑據拿出來，帶到本城門長老那裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT22_16","006_22_16","DEU","22","16","16","女子的父親要對長老說：『我將我的女兒給這人為妻，他恨惡她， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT22_17","006_22_17","DEU","22","17","17","信口說她，說：我見你的女兒沒有貞潔的憑據；其實這就是我女兒貞潔的憑據。』父母就把那布鋪在本城的長老面前。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT22_18","006_22_18","DEU","22","18","18","本城的長老要拿住那人，懲治他， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT22_19","006_22_19","DEU","22","19","19","並要罰他一百舍客勒銀子，給女子的父親，因為他將醜名加在以色列的一個處女身上。女子仍作他的妻，終身不可休她。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT22_20","006_22_20","DEU","22","20","20","但這事若是真的，女子沒有貞潔的憑據， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT22_21","006_22_21","DEU","22","21","21","就要將女子帶到她父家的門口，本城的人要用石頭將她打死；因為她在父家行了淫亂，在以色列中做了醜事。這樣，就把那惡從你們中間除掉。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT22_22","006_22_22","DEU","22","22","22","「若遇見人與有丈夫的婦人行淫，就要將姦夫淫婦一併治死。這樣，就把那惡從以色列中除掉。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT22_23","006_22_23","DEU","22","23","23","「若有處女已經許配丈夫，有人在城裏遇見她，與她行淫， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT22_24","006_22_24","DEU","22","24","24","你們就要把這二人帶到本城門，用石頭打死－女子是因為雖在城裏卻沒有喊叫；男子是因為玷污別人的妻。這樣，就把那惡從你們中間除掉。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT22_25","006_22_25","DEU","22","25","25","「若有男子在田野遇見已經許配人的女子，強與她行淫，只要將那男子治死。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT22_26","006_22_26","DEU","22","26","26","但不可辦女子；她本沒有該死的罪，這事就類乎人起來攻擊鄰舍，將他殺了一樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT22_27","006_22_27","DEU","22","27","27","因為男子是在田野遇見那已經許配人的女子，女子喊叫，並無人救她。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT22_28","006_22_28","DEU","22","28","28","「若有男子遇見沒有許配人的處女，抓住她，與她行淫，被人看見， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT22_29","006_22_29","DEU","22","29","29","這男子就要拿五十舍客勒銀子給女子的父親；因他玷污了這女子，就要娶她為妻，終身不可休她。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT22_30","006_22_30","DEU","22","30","30","「人不可娶繼母為妻；不可掀開他父親的衣襟。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT23_1","006_23_1","DEU","23","1","1","「凡外腎受傷的，或被閹割的，不可入耶和華的會。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT23_2","006_23_2","DEU","23","2","2","「私生子不可入耶和華的會；他的子孫，直到十代，也不可入耶和華的會。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT23_3","006_23_3","DEU","23","3","3","「亞捫人或是摩押人不可入耶和華的會；他們的子孫，雖過十代，也永不可入耶和華的會。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT23_4","006_23_4","DEU","23","4","4","因為你們出埃及的時候，他們沒有拿食物和水在路上迎接你們，又因他們雇了美索不達米亞的毗奪人比珥的兒子巴蘭來咒詛你們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT23_5","006_23_5","DEU","23","5","5","然而耶和華－你的上帝不肯聽從巴蘭，卻使那咒詛的言語變為祝福的話，因為耶和華－你的上帝愛你。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT23_6","006_23_6","DEU","23","6","6","你一生一世永不可求他們的平安和他們的利益。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT23_7","006_23_7","DEU","23","7","7","「不可憎惡以東人，因為他是你的弟兄。不可憎惡埃及人，因為你在他的地上作過寄居的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT23_8","006_23_8","DEU","23","8","8","他們第三代子孫可以入耶和華的會。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT23_9","006_23_9","DEU","23","9","9","「你出兵攻打仇敵，就要遠避諸惡。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT23_10","006_23_10","DEU","23","10","10","「你們中間，若有人夜間偶然夢遺，不潔淨，就要出到營外，不可入營； ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT23_11","006_23_11","DEU","23","11","11","到傍晚的時候，他要用水洗澡，及至日落了才可以入營。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT23_12","006_23_12","DEU","23","12","12","「你在營外也該定出一個地方作為便所。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT23_13","006_23_13","DEU","23","13","13","在你器械之中當預備一把鍬，你出營外便溺以後，用以鏟土，轉身掩蓋。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT23_14","006_23_14","DEU","23","14","14","因為耶和華－你的上帝常在你營中行走，要救護你，將仇敵交給你，所以你的營理當聖潔，免得他見你那裏有污穢，就離開你。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT23_15","006_23_15","DEU","23","15","15","「若有奴僕脫了主人的手，逃到你那裏，你不可將他交付他的主人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT23_16","006_23_16","DEU","23","16","16","他必在你那裏與你同住，在你的城邑中，要由他選擇一個所喜悅的地方居住；你不可欺負他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT23_17","006_23_17","DEU","23","17","17","「以色列的女子中不可有妓女；以色列的男子中不可有孌童。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT23_18","006_23_18","DEU","23","18","18","娼妓所得的錢，或孌童所得的價，你不可帶入耶和華－你上帝的殿還願，因為這兩樣都是耶和華－你上帝所憎惡的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT23_19","006_23_19","DEU","23","19","19","「你借給你弟兄的，或是錢財或是糧食，無論甚麼可生利的物，都不可取利。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT23_20","006_23_20","DEU","23","20","20","借給外邦人可以取利，只是借給你弟兄不可取利。這樣，耶和華－你上帝必在你所去得為業的地上和你手裏所辦的一切事上賜福與你。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT23_21","006_23_21","DEU","23","21","21","「你向耶和華－你的上帝許願，償還不可遲延；因為耶和華－你的上帝必定向你追討，你不償還就有罪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT23_22","006_23_22","DEU","23","22","22","你若不許願，倒無罪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT23_23","006_23_23","DEU","23","23","23","你嘴裏所出的，就是你口中應許甘心所獻的，要照你向耶和華－你上帝所許的願謹守遵行。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT23_24","006_23_24","DEU","23","24","24","「你進了鄰舍的葡萄園，可以隨意吃飽了葡萄，只是不可裝在器皿中。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT23_25","006_23_25","DEU","23","25","25","你進了鄰舍站着的禾稼，可以用手摘穗子，只是不可用鐮刀割取禾稼。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT24_1","006_24_1","DEU","24","1","1","「人若娶妻以後，見她有甚麼不合理的事，不喜悅她，就可以寫休書交在她手中，打發她離開夫家。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT24_2","006_24_2","DEU","24","2","2","婦人離開夫家以後，可以去嫁別人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT24_3","006_24_3","DEU","24","3","3","後夫若恨惡她，寫休書交在她手中，打發她離開夫家，或是娶她為妻的後夫死了， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT24_4","006_24_4","DEU","24","4","4","打發她去的前夫不可在婦人玷污之後再娶她為妻，因為這是耶和華所憎惡的；不可使耶和華－你上帝所賜為業之地被玷污了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT24_5","006_24_5","DEU","24","5","5","「新娶妻之人不可從軍出征，也不可託他辦理甚麼公事，可以在家清閒一年，使他所娶的妻快活。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT24_6","006_24_6","DEU","24","6","6","「不可拿人的全盤磨石或是上磨石作當頭，因為這是拿人的命作當頭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT24_7","006_24_7","DEU","24","7","7","「若遇見人拐帶以色列中的一個弟兄，當奴才待他，或是賣了他，那拐帶人的就必治死。這樣，便將那惡從你們中間除掉。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT24_8","006_24_8","DEU","24","8","8","「在大痲瘋的災病上，你們要謹慎，照祭司利未人一切所指教你們的留意遵行。我怎樣吩咐他們，你們要怎樣遵行。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT24_9","006_24_9","DEU","24","9","9","當記念出埃及後，在路上，耶和華－你上帝向米利暗所行的事。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT24_10","006_24_10","DEU","24","10","10","「你借給鄰舍，不拘是甚麼，不可進他家拿他的當頭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT24_11","006_24_11","DEU","24","11","11","要站在外面，等那向你借貸的人把當頭拿出來交給你。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT24_12","006_24_12","DEU","24","12","12","他若是窮人，你不可留他的當頭過夜。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT24_13","006_24_13","DEU","24","13","13","日落的時候，總要把當頭還他，使他用那件衣服蓋着睡覺，他就為你祝福；這在耶和華－你上帝面前就是你的義了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT24_14","006_24_14","DEU","24","14","14","「困苦窮乏的雇工，無論是你的弟兄或是在你城裏寄居的，你不可欺負他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT24_15","006_24_15","DEU","24","15","15","要當日給他工價，不可等到日落－因為他窮苦，把心放在工價上－恐怕他因你求告耶和華，罪便歸你了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT24_16","006_24_16","DEU","24","16","16","「不可因子殺父，也不可因父殺子；凡被殺的都為本身的罪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT24_17","006_24_17","DEU","24","17","17","「你不可向寄居的和孤兒屈枉正直，也不可拿寡婦的衣裳作當頭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT24_18","006_24_18","DEU","24","18","18","要記念你在埃及作過奴僕。耶和華－你的上帝從那裏將你救贖，所以我吩咐你這樣行。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT24_19","006_24_19","DEU","24","19","19","「你在田間收割莊稼，若忘下一捆，不可回去再取，要留給寄居的與孤兒寡婦。這樣，耶和華－你上帝必在你手裏所辦的一切事上賜福與你。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT24_20","006_24_20","DEU","24","20","20","你打橄欖樹，枝上剩下的，不可再打；要留給寄居的與孤兒寡婦。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT24_21","006_24_21","DEU","24","21","21","你摘葡萄園的葡萄，所剩下的，不可再摘；要留給寄居的與孤兒寡婦。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT24_22","006_24_22","DEU","24","22","22","你也要記念你在埃及地作過奴僕，所以我吩咐你這樣行。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT25_1","006_25_1","DEU","25","1","1","「人若有爭訟，來聽審判，審判官就要定義人有理，定惡人有罪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT25_2","006_25_2","DEU","25","2","2","惡人若該受責打，審判官就要叫他當面伏在地上，按着他的罪照數責打。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT25_3","006_25_3","DEU","25","3","3","只可打他四十下，不可過數；若過數，便是輕賤你的弟兄了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT25_4","006_25_4","DEU","25","4","4","「牛在場上踹穀的時候，不可籠住牠的嘴。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT25_5","006_25_5","DEU","25","5","5","「弟兄同居，若死了一個，沒有兒子，死人的妻不可出嫁外人，她丈夫的兄弟當盡弟兄的本分，娶她為妻，與她同房。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT25_6","006_25_6","DEU","25","6","6","婦人生的長子必歸死兄的名下，免得他的名在以色列中塗抹了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT25_7","006_25_7","DEU","25","7","7","那人若不願意娶他哥哥的妻，他哥哥的妻就要到城門長老那裏，說：『我丈夫的兄弟不肯在以色列中興起他哥哥的名字，不給我盡弟兄的本分。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT25_8","006_25_8","DEU","25","8","8","本城的長老就要召那人來問他，他若執意說：『我不願意娶她』， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT25_9","006_25_9","DEU","25","9","9","他哥哥的妻就要當着長老到那人的跟前，脫了他的鞋，吐唾沫在他臉上，說：『凡不為哥哥建立家室的都要這樣待他。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT25_10","006_25_10","DEU","25","10","10","在以色列中，他的名必稱為脫鞋之家。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT25_11","006_25_11","DEU","25","11","11","「若有二人爭鬥，這人的妻近前來，要救她丈夫脫離那打她丈夫之人的手，抓住那人的下體， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT25_12","006_25_12","DEU","25","12","12","就要砍斷婦人的手，眼不可顧惜她。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT25_13","006_25_13","DEU","25","13","13","「你囊中不可有一大一小兩樣的法碼。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT25_14","006_25_14","DEU","25","14","14","你家裏不可有一大一小兩樣的升斗。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT25_15","006_25_15","DEU","25","15","15","當用對準公平的法碼，公平的升斗。這樣，在耶和華－你上帝所賜你的地上，你的日子就可以長久。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT25_16","006_25_16","DEU","25","16","16","因為行非義之事的人都是耶和華－你上帝所憎惡的。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT25_17","006_25_17","DEU","25","17","17","「你要記念你們出埃及的時候，亞瑪力人在路上怎樣待你。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT25_18","006_25_18","DEU","25","18","18","他們在路上遇見你，趁你疲乏困倦擊殺你儘後邊軟弱的人，並不敬畏上帝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT25_19","006_25_19","DEU","25","19","19","所以耶和華－你上帝使你不被四圍一切的仇敵擾亂，在耶和華－你上帝賜你為業的地上得享平安。那時，你要將亞瑪力的名號從天下塗抹了，不可忘記。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT26_1","006_26_1","DEU","26","1","1","「你進去得了耶和華－你上帝所賜你為業之地居住， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT26_2","006_26_2","DEU","26","2","2","就要從耶和華－你上帝賜你的地上將所收的各種初熟的土產取些來，盛在筐子裏，往耶和華－你上帝所選擇要立為他名的居所去， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT26_3","006_26_3","DEU","26","3","3","見當時作祭司的，對他說：『我今日向耶和華－你上帝明認，我已來到耶和華向我們列祖起誓應許賜給我們的地。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT26_4","006_26_4","DEU","26","4","4","祭司就從你手裏取過筐子來，放在耶和華－你上帝的壇前。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT26_5","006_26_5","DEU","26","5","5","你要在耶和華－你上帝面前說：『我祖原是一個將亡的亞蘭人，下到埃及寄居。他人口稀少，在那裏卻成了又大又強、人數很多的國民。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT26_6","006_26_6","DEU","26","6","6","埃及人惡待我們，苦害我們，將苦工加在我們身上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT26_7","006_26_7","DEU","26","7","7","於是我們哀求耶和華－我們列祖的上帝，耶和華聽見我們的聲音，看見我們所受的困苦、勞碌、欺壓， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT26_8","006_26_8","DEU","26","8","8","他就用大能的手和伸出來的膀臂，並大可畏的事與神蹟奇事，領我們出了埃及， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT26_9","006_26_9","DEU","26","9","9","將我們領進這地方，把這流奶與蜜之地賜給我們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT26_10","006_26_10","DEU","26","10","10","耶和華啊，現在我把你所賜給我地上初熟的土產奉了來。』隨後你要把筐子放在耶和華－你上帝面前，向耶和華－你的上帝下拜。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT26_11","006_26_11","DEU","26","11","11","你和利未人，並在你們中間寄居的，要因耶和華－你上帝所賜你和你家的一切福分歡樂。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT26_12","006_26_12","DEU","26","12","12","「每逢三年，就是十分取一之年，你取完了一切土產的十分之一，要分給利未人和寄居的，與孤兒寡婦，使他們在你城中可以吃得飽足。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT26_13","006_26_13","DEU","26","13","13","你又要在耶和華－你上帝面前說：『我已將聖物從我家裏拿出來，給了利未人和寄居的，與孤兒寡婦，是照你所吩咐我的一切命令。你的命令我都沒有違背，也沒有忘記。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT26_14","006_26_14","DEU","26","14","14","我守喪的時候，沒有吃這聖物；不潔淨的時候，也沒有拿出來，又沒有為死人送去。我聽從了耶和華－我上帝的話，都照你所吩咐的行了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT26_15","006_26_15","DEU","26","15","15","求你從天上、你的聖所垂看，賜福給你的百姓以色列與你所賜給我們的地，就是你向我們列祖起誓賜我們流奶與蜜之地。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT26_16","006_26_16","DEU","26","16","16","「耶和華－你的上帝今日吩咐你行這些律例典章，所以你要盡心盡性謹守遵行。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT26_17","006_26_17","DEU","26","17","17","你今日認耶和華為你的上帝，應許遵行他的道，謹守他的律例、誡命、典章，聽從他的話。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT26_18","006_26_18","DEU","26","18","18","耶和華今日照他所應許你的，也認你為他的子民，使你謹守他的一切誡命， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT26_19","006_26_19","DEU","26","19","19","又使你得稱讚、美名、尊榮，超乎他所造的萬民之上，並照他所應許的使你歸耶和華－你上帝為聖潔的民。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT27_1","006_27_1","DEU","27","1","1","摩西和以色列的眾長老吩咐百姓說：「你們要遵守我今日所吩咐的一切誡命。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT27_2","006_27_2","DEU","27","2","2","你們過約旦河，到了耶和華－你上帝所賜給你的地，當天要立起幾塊大石頭，墁上石灰， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT27_3","006_27_3","DEU","27","3","3","把這律法的一切話寫在石頭上。你過了河，可以進入耶和華－你上帝所賜你流奶與蜜之地，正如耶和華－你列祖之上帝所應許你的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT27_4","006_27_4","DEU","27","4","4","你們過了約旦河，就要在以巴路山上照我今日所吩咐的，將這些石頭立起來，墁上石灰。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT27_5","006_27_5","DEU","27","5","5","在那裏要為耶和華－你的上帝築一座石壇；在石頭上不可動鐵器。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT27_6","006_27_6","DEU","27","6","6","要用沒有鑿過的石頭築耶和華－你上帝的壇，在壇上要將燔祭獻給耶和華－你的上帝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT27_7","006_27_7","DEU","27","7","7","又要獻平安祭，且在那裏吃，在耶和華－你的上帝面前歡樂。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT27_8","006_27_8","DEU","27","8","8","你要將這律法的一切話明明地寫在石頭上。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT27_9","006_27_9","DEU","27","9","9","摩西和祭司利未人曉諭以色列眾人說：「以色列啊，要默默靜聽。你今日成為耶和華－你上帝的百姓了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT27_10","006_27_10","DEU","27","10","10","所以要聽從耶和華－你上帝的話，遵行他的誡命律例，就是我今日所吩咐你的。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT27_11","006_27_11","DEU","27","11","11","當日，摩西囑咐百姓說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT27_12","006_27_12","DEU","27","12","12","「你們過了約旦河，西緬、利未、猶大、以薩迦、約瑟、便雅憫六個支派的人都要站在基利心山上為百姓祝福。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT27_13","006_27_13","DEU","27","13","13","呂便、迦得、亞設、西布倫、但、拿弗他利六個支派的人都要站在以巴路山上宣布咒詛。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT27_14","006_27_14","DEU","27","14","14","利未人要向以色列眾人高聲說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT27_15","006_27_15","DEU","27","15","15","「『有人製造耶和華所憎惡的偶像，或雕刻，或鑄造，就是工匠手所做的，在暗中設立，那人必受咒詛！』百姓都要答應說：『阿們！』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT27_16","006_27_16","DEU","27","16","16","「『輕慢父母的，必受咒詛！』百姓都要說：『阿們！』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT27_17","006_27_17","DEU","27","17","17","「『挪移鄰舍地界的，必受咒詛！』百姓都要說：『阿們！』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT27_18","006_27_18","DEU","27","18","18","「『使瞎子走差路的，必受咒詛！』百姓都要說：『阿們！』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT27_19","006_27_19","DEU","27","19","19","「『向寄居的和孤兒寡婦屈枉正直的，必受咒詛！』百姓都要說：『阿們！』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT27_20","006_27_20","DEU","27","20","20","「『與繼母行淫的，必受咒詛！因為掀開他父親的衣襟。』百姓都要說：『阿們！』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT27_21","006_27_21","DEU","27","21","21","「『與獸淫合的，必受咒詛！』百姓都要說：『阿們！』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT27_22","006_27_22","DEU","27","22","22","「『與異母同父，或異父同母的姊妹行淫的，必受咒詛！』百姓都要說：『阿們！』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT27_23","006_27_23","DEU","27","23","23","「『與岳母行淫的，必受咒詛！』百姓都要說：『阿們！』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT27_24","006_27_24","DEU","27","24","24","「『暗中殺人的，必受咒詛！』百姓都要說：『阿們！』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT27_25","006_27_25","DEU","27","25","25","「『受賄賂害死無辜之人的，必受咒詛！』百姓都要說：『阿們！』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT27_26","006_27_26","DEU","27","26","26","「『不堅守遵行這律法言語的，必受咒詛！』百姓都要說：『阿們！』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_1","006_28_1","DEU","28","1","1","「你若留意聽從耶和華－你上帝的話，謹守遵行他的一切誡命，就是我今日所吩咐你的，他必使你超乎天下萬民之上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_2","006_28_2","DEU","28","2","2","你若聽從耶和華－你上帝的話，這以下的福必追隨你，臨到你身上： ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_3","006_28_3","DEU","28","3","3","你在城裏必蒙福，在田間也必蒙福。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_4","006_28_4","DEU","28","4","4","你身所生的，地所產的，牲畜所下的，以及牛犢、羊羔，都必蒙福。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_5","006_28_5","DEU","28","5","5","你的筐子和你的摶麵盆都必蒙福。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_6","006_28_6","DEU","28","6","6","你出也蒙福，入也蒙福。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_7","006_28_7","DEU","28","7","7","「仇敵起來攻擊你，耶和華必使他們在你面前被你殺敗；他們從一條路來攻擊你，必從七條路逃跑。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_8","006_28_8","DEU","28","8","8","在你倉房裏，並你手所辦的一切事上，耶和華所命的福必臨到你。耶和華－你上帝也要在所給你的地上賜福與你。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_9","006_28_9","DEU","28","9","9","你若謹守耶和華－你上帝的誡命，遵行他的道，他必照着向你所起的誓立你作為自己的聖民。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_10","006_28_10","DEU","28","10","10","天下萬民見你歸在耶和華的名下，就要懼怕你。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_11","006_28_11","DEU","28","11","11","你在耶和華向你列祖起誓應許賜你的地上，他必使你身所生的，牲畜所下的，地所產的，都綽綽有餘。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_12","006_28_12","DEU","28","12","12","耶和華必為你開天上的府庫，按時降雨在你的地上。在你手裏所辦的一切事上賜福與你。你必借給許多國民，卻不致向他們借貸。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_13","006_28_13","DEU","28","13","14","你若聽從耶和華－你上帝的誡命，就是我今日所吩咐你的，謹守遵行，不偏左右，也不隨從事奉別神，耶和華就必使你作首不作尾，但居上不居下。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_15","006_28_15","DEU","28","15","15","「你若不聽從耶和華－你上帝的話，不謹守遵行他的一切誡命律例，就是我今日所吩咐你的，這以下的咒詛都必追隨你，臨到你身上： ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_16","006_28_16","DEU","28","16","16","你在城裏必受咒詛，在田間也必受咒詛。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_17","006_28_17","DEU","28","17","17","你的筐子和你的摶麵盆都必受咒詛。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_18","006_28_18","DEU","28","18","18","你身所生的，地所產的，以及牛犢、羊羔，都必受咒詛。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_19","006_28_19","DEU","28","19","19","你出也受咒詛，入也受咒詛。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_20","006_28_20","DEU","28","20","20","耶和華因你行惡離棄他，必在你手裏所辦的一切事上，使咒詛、擾亂、責罰臨到你，直到你被毀滅，速速地滅亡。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_21","006_28_21","DEU","28","21","21","耶和華必使瘟疫貼在你身上，直到他將你從所進去得為業的地上滅絕。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_22","006_28_22","DEU","28","22","22","耶和華要用癆病、熱病、火症、瘧疾、刀劍、旱風、霉爛攻擊你。這都要追趕你，直到你滅亡。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_23","006_28_23","DEU","28","23","23","你頭上的天要變為銅，腳下的地要變為鐵。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_24","006_28_24","DEU","28","24","24","耶和華要使那降在你地上的雨變為塵沙，從天臨在你身上，直到你滅亡。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_25","006_28_25","DEU","28","25","25","「耶和華必使你敗在仇敵面前，你從一條路去攻擊他們，必從七條路逃跑。你必在天下萬國中拋來拋去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_26","006_28_26","DEU","28","26","26","你的屍首必給空中的飛鳥和地上的走獸作食物，並無人鬨趕。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_27","006_28_27","DEU","28","27","27","耶和華必用埃及人的瘡並痔瘡、牛皮癬與疥攻擊你，使你不能醫治。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_28","006_28_28","DEU","28","28","28","耶和華必用癲狂、眼瞎、心驚攻擊你。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_29","006_28_29","DEU","28","29","29","你必在午間摸索，好像瞎子在暗中摸索一樣。你所行的必不亨通，時常遭遇欺壓、搶奪，無人搭救。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_30","006_28_30","DEU","28","30","30","你聘定了妻，別人必與她同房；你建造房屋，不得住在其內；你栽種葡萄園，也不得用其中的果子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_31","006_28_31","DEU","28","31","31","你的牛在你眼前宰了，你必不得吃牠的肉；你的驢在你眼前被搶奪，不得歸還；你的羊歸了仇敵，無人搭救。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_32","006_28_32","DEU","28","32","32","你的兒女必歸與別國的民；你的眼目終日切望，甚至失明，你手中無力拯救。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_33","006_28_33","DEU","28","33","33","你的土產和你勞碌得來的，必被你所不認識的國民吃盡。你時常被欺負，受壓制， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_34","006_28_34","DEU","28","34","34","甚至你因眼中所看見的，必致瘋狂。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_35","006_28_35","DEU","28","35","35","耶和華必攻擊你，使你膝上腿上，從腳掌到頭頂，長毒瘡無法醫治。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_36","006_28_36","DEU","28","36","36","「耶和華必將你和你所立的王領到你和你列祖素不認識的國去；在那裏你必事奉木頭石頭的神。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_37","006_28_37","DEU","28","37","37","你在耶和華領你到的各國中，要令人驚駭、笑談、譏誚。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_38","006_28_38","DEU","28","38","38","你帶到田間的種子雖多，收進來的卻少，因為被蝗蟲吃了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_39","006_28_39","DEU","28","39","39","你栽種、修理葡萄園，卻不得收葡萄，也不得喝葡萄酒，因為被蟲子吃了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_40","006_28_40","DEU","28","40","40","你全境有橄欖樹，卻不得其油抹身，因為樹上的橄欖不熟自落了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_41","006_28_41","DEU","28","41","41","你生兒養女，卻不算是你的，因為必被擄去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_42","006_28_42","DEU","28","42","42","你所有的樹木和你地裏的出產必被蝗蟲所吃。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_43","006_28_43","DEU","28","43","43","在你中間寄居的，必漸漸上升，比你高而又高；你必漸漸下降，低而又低。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_44","006_28_44","DEU","28","44","44","他必借給你，你卻不能借給他；他必作首，你必作尾。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_45","006_28_45","DEU","28","45","45","這一切咒詛必追隨你，趕上你，直到你滅亡；因為你不聽從耶和華－你上帝的話，不遵守他所吩咐的誡命律例。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_46","006_28_46","DEU","28","46","46","這些咒詛必在你和你後裔的身上成為異蹟奇事，直到永遠！ ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_47","006_28_47","DEU","28","47","47","「因為你富有的時候，不歡心樂意地事奉耶和華－你的上帝， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_48","006_28_48","DEU","28","48","48","所以你必在飢餓、乾渴、赤露、缺乏之中事奉耶和華所打發來攻擊你的仇敵。他必把鐵軛加在你的頸項上，直到將你滅絕。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_49","006_28_49","DEU","28","49","49","「耶和華要從遠方、地極帶一國的民，如鷹飛來攻擊你。這民的言語，你不懂得。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_50","006_28_50","DEU","28","50","50","這民的面貌凶惡，不顧恤年老的，也不恩待年少的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_51","006_28_51","DEU","28","51","51","他們必吃你牲畜所下的和你地土所產的，直到你滅亡。你的五穀、新酒，和油，以及牛犢、羊羔，都不給你留下，直到將你滅絕。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_52","006_28_52","DEU","28","52","52","他們必將你困在你各城裏，直到你所倚靠、高大堅固的城牆都被攻塌。他們必將你困在耶和華－你上帝所賜你遍地的各城裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_53","006_28_53","DEU","28","53","53","你在仇敵圍困窘迫之中，必吃你本身所生的，就是耶和華－你上帝所賜給你的兒女之肉。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_54","006_28_54","DEU","28","54","54","你們中間，柔弱嬌嫩的人必惡眼看他弟兄和他懷中的妻，並他餘剩的兒女； ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_55","006_28_55","DEU","28","55","55","甚至在你受仇敵圍困窘迫的城中，他要吃兒女的肉，不肯分一點給他的親人，因為他一無所剩。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_56","006_28_56","DEU","28","56","56","你們中間，柔弱嬌嫩的婦人，是因嬌嫩柔弱不肯把腳踏地的，必惡眼看她懷中的丈夫和她的兒女。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_57","006_28_57","DEU","28","57","57","她兩腿中間出來的嬰孩與她所要生的兒女，她因缺乏一切就要在你受仇敵圍困窘迫的城中將他們暗暗地吃了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_58","006_28_58","DEU","28","58","59","「這書上所寫律法的一切話是叫你敬畏耶和華－你上帝可榮可畏的名。你若不謹守遵行，耶和華就必將奇災，就是至大至長的災，至重至久的病，加在你和你後裔的身上， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_60","006_28_60","DEU","28","60","60","也必使你所懼怕、埃及人的病都臨到你，貼在你身上， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_61","006_28_61","DEU","28","61","61","又必將沒有寫在這律法書上的各樣疾病、災殃降在你身上，直到你滅亡。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_62","006_28_62","DEU","28","62","62","你們先前雖然像天上的星那樣多，卻因不聽從耶和華－你上帝的話，所剩的人數就稀少了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_63","006_28_63","DEU","28","63","63","先前耶和華怎樣喜悅善待你們，使你們眾多，也要照樣喜悅毀滅你們，使你們滅亡；並且你們從所要進去得的地上必被拔除。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_64","006_28_64","DEU","28","64","64","耶和華必使你們分散在萬民中，從地這邊到地那邊，你必在那裏事奉你和你列祖素不認識、木頭石頭的神。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_65","006_28_65","DEU","28","65","65","在那些國中，你必不得安逸，也不得落腳之地；耶和華卻使你在那裏心中跳動，眼目失明，精神消耗。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_66","006_28_66","DEU","28","66","66","你的性命必懸懸無定；你晝夜恐懼，自料性命難保。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_67","006_28_67","DEU","28","67","67","你因心裏所恐懼的，眼中所看見的，早晨必說，巴不得到晚上才好；晚上必說，巴不得到早晨才好。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT28_68","006_28_68","DEU","28","68","68","耶和華必使你坐船回埃及去，走我曾告訴你不得再見的路；在那裏你必賣己身與仇敵作奴婢，卻無人買。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT29_1","006_29_1","DEU","29","1","1","這是耶和華在摩押地吩咐摩西與以色列人立約的話，是在他和他們於何烈山所立的約之外。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT29_2","006_29_2","DEU","29","2","2","摩西召了以色列眾人來，對他們說：「耶和華在埃及地，在你們眼前向法老和他眾臣僕，並他全地所行的一切事，你們都看見了， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT29_3","006_29_3","DEU","29","3","3","就是你親眼看見的大試驗和神蹟，並那些大奇事。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT29_4","006_29_4","DEU","29","4","4","但耶和華到今日沒有使你們心能明白，眼能看見，耳能聽見。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT29_5","006_29_5","DEU","29","5","5","我領你們在曠野四十年，你們身上的衣服並沒有穿破，腳上的鞋也沒有穿壞。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT29_6","006_29_6","DEU","29","6","6","你們沒有吃餅，也沒有喝清酒濃酒。這要使你們知道，耶和華是你們的上帝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT29_7","006_29_7","DEU","29","7","7","你們來到這地方，希實本王西宏、巴珊王噩都出來與我們交戰，我們就擊殺了他們， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT29_8","006_29_8","DEU","29","8","8","取了他們的地給呂便支派、迦得支派，和瑪拿西半支派為業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT29_9","006_29_9","DEU","29","9","9","所以你們要謹守遵行這約的話，好叫你們在一切所行的事上亨通。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT29_10","006_29_10","DEU","29","10","11","「今日，你們的首領、族長、長老、官長、以色列的男丁，你們的妻子兒女，和營中寄居的，以及為你們劈柴挑水的人，都站在耶和華－你們的上帝面前， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT29_12","006_29_12","DEU","29","12","12","為要你順從耶和華－你上帝今日與你所立的約，向你所起的誓。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT29_13","006_29_13","DEU","29","13","13","這樣，他要照他向你所應許的話，又向你列祖亞伯拉罕、以撒、雅各所起的誓，今日立你作他的子民，他作你的上帝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT29_14","006_29_14","DEU","29","14","14","我不但與你們立這約，起這誓， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT29_15","006_29_15","DEU","29","15","15","凡與我們一同站在耶和華－我們上帝面前的，並今日不在我們這裏的人，我也與他們立這約，起這誓。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT29_16","006_29_16","DEU","29","16","16","「我們曾住過埃及地，也從列國經過；這是你們知道的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT29_17","006_29_17","DEU","29","17","17","你們也看見他們中間可憎之物，並他們木、石、金、銀的偶像。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT29_18","006_29_18","DEU","29","18","18","惟恐你們中間，或男或女，或族長或支派長，今日心裏偏離耶和華－我們的上帝，去事奉那些國的神；又怕你們中間有惡根生出苦菜和茵蔯來， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT29_19","006_29_19","DEU","29","19","19","聽見這咒詛的話，心裏仍是自誇說：『我雖然行事心裏頑梗，連累眾人，卻還是平安。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT29_20","006_29_20","DEU","29","20","20","耶和華必不饒恕他；耶和華的怒氣與憤恨要向他發作，如煙冒出，將這書上所寫的一切咒詛都加在他身上。耶和華又要從天下塗抹他的名， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT29_21","006_29_21","DEU","29","21","21","也必照着寫在律法書上、約中的一切咒詛將他從以色列眾支派中分別出來，使他受禍。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT29_22","006_29_22","DEU","29","22","22","你們的後代，就是以後興起來的子孫，和遠方來的外人，看見這地的災殃，並耶和華所降與這地的疾病， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT29_23","006_29_23","DEU","29","23","23","又看見遍地有硫磺，有鹽鹵，有火跡，沒有耕種，沒有出產，連草都不生長－好像耶和華在忿怒中所傾覆的所多瑪、蛾摩拉、押瑪、洗扁一樣－ ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT29_24","006_29_24","DEU","29","24","24","所看見的人，連萬國人，都必問說：『耶和華為何向此地這樣行呢？這樣大發烈怒是甚麼意思呢？』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT29_25","006_29_25","DEU","29","25","25","人必回答說：『是因這地的人離棄了耶和華－他們列祖的上帝，領他們出埃及地的時候與他們所立的約， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT29_26","006_29_26","DEU","29","26","26","去事奉敬拜素不認識的別神，是耶和華所未曾給他們安排的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT29_27","006_29_27","DEU","29","27","27","所以耶和華的怒氣向這地發作，將這書上所寫的一切咒詛都降在這地上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT29_28","006_29_28","DEU","29","28","28","耶和華在怒氣、忿怒、大惱恨中將他們從本地拔出來，扔在別的地上，像今日一樣。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT29_29","006_29_29","DEU","29","29","29","「隱祕的事是屬耶和華－我們上帝的；惟有明顯的事是永遠屬我們和我們子孫的，好叫我們遵行這律法上的一切話。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT30_1","006_30_1","DEU","30","1","1","「我所陳明在你面前的這一切咒詛都臨到你身上；你在耶和華－你上帝追趕你到的萬國中必心裏追念祝福的話； ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT30_2","006_30_2","DEU","30","2","2","你和你的子孫若盡心盡性歸向耶和華－你的上帝，照着我今日一切所吩咐的聽從他的話； ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT30_3","006_30_3","DEU","30","3","3","那時，耶和華－你的上帝必憐恤你，救回你這被擄的子民；耶和華－你的上帝要回轉過來，從分散你到的萬民中將你招聚回來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT30_4","006_30_4","DEU","30","4","4","你被趕散的人，就是在天涯的，耶和華－你的上帝也必從那裏將你招聚回來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT30_5","006_30_5","DEU","30","5","5","耶和華－你的上帝必領你進入你列祖所得的地，使你可以得着；又必善待你，使你的人數比你列祖眾多。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT30_6","006_30_6","DEU","30","6","6","耶和華－你上帝必將你心裏和你後裔心裏的污穢除掉，好叫你盡心盡性愛耶和華－你的上帝，使你可以存活。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT30_7","006_30_7","DEU","30","7","7","耶和華－你的上帝必將這一切咒詛加在你仇敵和恨惡你、逼迫你的人身上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT30_8","006_30_8","DEU","30","8","8","你必歸回，聽從耶和華的話，遵行他的一切誡命，就是我今日所吩咐你的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT30_9","006_30_9","DEU","30","9","10","你若聽從耶和華－你上帝的話，謹守這律法書上所寫的誡命律例，又盡心盡性歸向耶和華－你的上帝，他必使你手裏所辦的一切事，並你身所生的，牲畜所下的，地土所產的，都綽綽有餘；因為耶和華必再喜悅你，降福與你，像從前喜悅你列祖一樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT30_11","006_30_11","DEU","30","11","11","「我今日所吩咐你的誡命不是你難行的，也不是離你遠的； ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT30_12","006_30_12","DEU","30","12","12","不是在天上，使你說：『誰替我們上天取下來，使我們聽見可以遵行呢？』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT30_13","006_30_13","DEU","30","13","13","也不是在海外，使你說：『誰替我們過海取了來，使我們聽見可以遵行呢？』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT30_14","006_30_14","DEU","30","14","14","這話卻離你甚近，就在你口中，在你心裏，使你可以遵行。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT30_15","006_30_15","DEU","30","15","15","「看哪，我今日將生與福，死與禍，陳明在你面前。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT30_16","006_30_16","DEU","30","16","16","吩咐你愛耶和華－你的上帝，遵行他的道，謹守他的誡命、律例、典章，使你可以存活，人數增多，耶和華－你上帝就必在你所要進去得為業的地上賜福與你。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT30_17","006_30_17","DEU","30","17","17","倘若你心裏偏離，不肯聽從，卻被勾引去敬拜事奉別神， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT30_18","006_30_18","DEU","30","18","18","我今日明明告訴你們，你們必要滅亡；在你過約旦河、進去得為業的地上，你的日子必不長久。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT30_19","006_30_19","DEU","30","19","19","我今日呼天喚地向你作見證；我將生死禍福陳明在你面前，所以你要揀選生命，使你和你的後裔都得存活； ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT30_20","006_30_20","DEU","30","20","20","且愛耶和華－你的上帝，聽從他的話，專靠他；因為他是你的生命，你的日子長久也在乎他。這樣，你就可以在耶和華向你列祖亞伯拉罕、以撒、雅各起誓應許所賜的地上居住。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT31_1","006_31_1","DEU","31","1","1","摩西去告訴以色列眾人 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT31_2","006_31_2","DEU","31","2","2","說：「我現在一百二十歲了，不能照常出入；耶和華也曾對我說：『你必不得過這約旦河。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT31_3","006_31_3","DEU","31","3","3","耶和華－你們的上帝必引導你們過去，將這些國民在你們面前滅絕，你們就得他們的地。約書亞必引導你們過去，正如耶和華所說的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT31_4","006_31_4","DEU","31","4","4","耶和華必待他們，如同從前待他所滅絕的亞摩利二王西宏與噩以及他們的國一樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT31_5","006_31_5","DEU","31","5","5","耶和華必將他們交給你們；你們要照我所吩咐的一切命令待他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT31_6","006_31_6","DEU","31","6","6","你們當剛強壯膽，不要害怕，也不要畏懼他們，因為耶和華－你的上帝和你同去。他必不撇下你，也不丟棄你。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT31_7","006_31_7","DEU","31","7","7","摩西召了約書亞來，在以色列眾人眼前對他說：「你當剛強壯膽！因為，你要和這百姓一同進入耶和華向他們列祖起誓應許所賜之地；你也要使他們承受那地為業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT31_8","006_31_8","DEU","31","8","8","耶和華必在你前面行；他必與你同在，必不撇下你，也不丟棄你。不要懼怕，也不要驚惶。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT31_9","006_31_9","DEU","31","9","9","摩西將這律法寫出來，交給抬耶和華約櫃的祭司利未子孫和以色列的眾長老。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT31_10","006_31_10","DEU","31","10","10","摩西吩咐他們說：「每逢七年的末一年，就在豁免年的定期住棚節的時候， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT31_11","006_31_11","DEU","31","11","11","以色列眾人來到耶和華－你上帝所選擇的地方朝見他。那時，你要在以色列眾人面前將這律法念給他們聽。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT31_12","006_31_12","DEU","31","12","12","要招聚他們男、女、孩子，並城裏寄居的，使他們聽，使他們學習，好敬畏耶和華－你們的上帝，謹守、遵行這律法的一切話， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT31_13","006_31_13","DEU","31","13","13","也使他們未曾曉得這律法的兒女得以聽見，學習敬畏耶和華－你們的上帝，在你們過約旦河要得為業之地，存活的日子，常常這樣行。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT31_14","006_31_14","DEU","31","14","14","耶和華對摩西說：「你的死期臨近了；要召約書亞來，你們二人站在會幕裏，我好囑咐他。」於是摩西和約書亞去站在會幕裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT31_15","006_31_15","DEU","31","15","15","耶和華在會幕裏雲柱中顯現，雲柱停在會幕門以上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT31_16","006_31_16","DEU","31","16","16","耶和華又對摩西說：「你必和你列祖同睡。這百姓要起來，在他們所要去的地上，在那地的人中，隨從外邦神行邪淫，離棄我，違背我與他們所立的約。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT31_17","006_31_17","DEU","31","17","17","那時，我的怒氣必向他們發作；我也必離棄他們，掩面不顧他們，以致他們被吞滅，並有許多的禍患災難臨到他們。那日他們必說：『這些禍患臨到我們，豈不是因我們的上帝不在我們中間嗎？』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT31_18","006_31_18","DEU","31","18","18","那時，因他們偏向別神所行的一切惡，我必定掩面不顧他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT31_19","006_31_19","DEU","31","19","19","現在你要寫一篇歌，教導以色列人，傳給他們，使這歌見證他們的不是； ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT31_20","006_31_20","DEU","31","20","20","因為我將他們領進我向他們列祖起誓應許那流奶與蜜之地，他們在那裏吃得飽足，身體肥胖，就必偏向別神，事奉他們，藐視我，背棄我的約。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT31_21","006_31_21","DEU","31","21","21","那時，有許多禍患災難臨到他們，這歌必在他們面前作見證，他們後裔的口中必念誦不忘。我未領他們到我所起誓應許之地以先，他們所懷的意念我都知道了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT31_22","006_31_22","DEU","31","22","22","當日摩西就寫了一篇歌，教導以色列人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT31_23","006_31_23","DEU","31","23","23","耶和華囑咐嫩的兒子約書亞說：「你當剛強壯膽，因為你必領以色列人進我所起誓應許他們的地；我必與你同在。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT31_24","006_31_24","DEU","31","24","24","摩西將這律法的話寫在書上，及至寫完了， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT31_25","006_31_25","DEU","31","25","25","就吩咐抬耶和華約櫃的利未人說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT31_26","006_31_26","DEU","31","26","26","「將這律法書放在耶和華－你們上帝的約櫃旁，可以在那裏見證以色列人的不是； ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT31_27","006_31_27","DEU","31","27","27","因為我知道你們是悖逆的，是硬着頸項的。我今日還活着與你們同在，你們尚且悖逆耶和華，何況我死後呢？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT31_28","006_31_28","DEU","31","28","28","你們要將你們支派的眾長老和官長都招聚了來，我好將這些話說與他們聽，並呼天喚地見證他們的不是。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT31_29","006_31_29","DEU","31","29","29","我知道我死後，你們必全然敗壞，偏離我所吩咐你們的道，行耶和華眼中看為惡的事，以手所做的惹他發怒；日後必有禍患臨到你們。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT31_30","006_31_30","DEU","31","30","30","摩西將這一篇歌的話都說與以色列全會眾聽。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT32_1","006_32_1","DEU","32","1","1","諸天哪，側耳，我要說話； 願地也聽我口中的言語。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT32_2","006_32_2","DEU","32","2","2","我的教訓要淋漓如雨； 我的言語要滴落如露， 如細雨降在嫩草上， 如甘霖降在菜蔬中。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT32_3","006_32_3","DEU","32","3","3","我要宣告耶和華的名； 你們要將大德歸與我們的上帝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT32_4","006_32_4","DEU","32","4","4","他是磐石，他的作為完全； 他所行的無不公平， 是誠實無偽的上帝， 又公義，又正直。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT32_5","006_32_5","DEU","32","5","5","這乖僻彎曲的世代向他行事邪僻； 有這弊病就不是他的兒女。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT32_6","006_32_6","DEU","32","6","6","愚昧無知的民哪，你們這樣報答耶和華嗎？ 他豈不是你的父、將你買來的嗎？ 他是製造你、建立你的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT32_7","006_32_7","DEU","32","7","7","你當追想上古之日， 思念歷代之年； 問你的父親，他必指示你； 問你的長者，他必告訴你。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT32_8","006_32_8","DEU","32","8","8","至高者將地業賜給列邦，將世人分開， 就照以色列人的數目立定萬民的疆界。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT32_9","006_32_9","DEU","32","9","9","耶和華的分本是他的百姓； 他的產業本是雅各。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT32_10","006_32_10","DEU","32","10","10","耶和華遇見他在曠野－ 荒涼野獸吼叫之地， 就環繞他，看顧他， 保護他，如同保護眼中的瞳人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT32_11","006_32_11","DEU","32","11","11","又如鷹攪動巢窩， 在雛鷹以上兩翅搧展， 接取雛鷹，背在兩翼之上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT32_12","006_32_12","DEU","32","12","12","這樣，耶和華獨自引導他， 並無外邦神與他同在。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT32_13","006_32_13","DEU","32","13","13","耶和華使他乘駕地的高處， 得吃田間的土產； 又使他從磐石中咂蜜， 從堅石中吸油； ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT32_14","006_32_14","DEU","32","14","14","也吃牛的奶油， 羊的奶，羊羔的脂油， 巴珊所出的公綿羊和山羊， 與上好的麥子， 也喝葡萄汁釀的酒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT32_15","006_32_15","DEU","32","15","15","但耶書崙漸漸肥胖，粗壯， 光潤，踢跳，奔跑， 便離棄造他的上帝， 輕看救他的磐石； ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT32_16","006_32_16","DEU","32","16","16","敬拜別神，觸動上帝的憤恨， 行可憎惡的事，惹了他的怒氣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT32_17","006_32_17","DEU","32","17","17","所祭祀的鬼魔並非真神， 乃是素不認識的神， 是近來新興的， 是你列祖所不畏懼的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT32_18","006_32_18","DEU","32","18","18","你輕忽生你的磐石， 忘記產你的上帝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT32_19","006_32_19","DEU","32","19","19","耶和華看見他的兒女惹動他， 就厭惡他們，說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT32_20","006_32_20","DEU","32","20","20","我要向他們掩面， 看他們的結局如何。 他們本是極乖僻的族類， 心中無誠實的兒女。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT32_21","006_32_21","DEU","32","21","21","他們以那「不算為神」的觸動我的憤恨， 以虛無的神惹了我的怒氣。 我也要以那「不成子民」的觸動他們的憤恨， 以愚昧的國民惹了他們的怒氣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT32_22","006_32_22","DEU","32","22","22","因為在我怒中有火燒起， 直燒到極深的陰間， 把地和地的出產盡都焚燒， 山的根基也燒着了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT32_23","006_32_23","DEU","32","23","23","我要將禍患堆在他們身上， 把我的箭向他們射盡。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT32_24","006_32_24","DEU","32","24","24","他們必因飢餓消瘦， 被炎熱苦毒吞滅。 我要打發野獸用牙齒咬他們， 並土中腹行的，用毒氣害他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT32_25","006_32_25","DEU","32","25","25","外頭有刀劍，內室有驚恐， 使人喪亡，使少男、童女、 吃奶的、白髮的，盡都滅絕。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT32_26","006_32_26","DEU","32","26","26","我說，我必將他們分散遠方， 使他們的名號從人間除滅。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT32_27","006_32_27","DEU","32","27","27","惟恐仇敵惹動我， 只怕敵人錯看，說：是我們手的能力， 並非耶和華所行的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT32_28","006_32_28","DEU","32","28","28","因為以色列民毫無計謀， 心中沒有聰明。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT32_29","006_32_29","DEU","32","29","29","惟願他們有智慧， 能明白這事，肯思念他們的結局。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT32_30","006_32_30","DEU","32","30","30","若不是他們的磐石賣了他們， 若不是耶和華交出他們， 一人焉能追趕他們千人？ 二人焉能使萬人逃跑呢？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT32_31","006_32_31","DEU","32","31","31","據我們的仇敵自己斷定， 他們的磐石不如我們的磐石。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT32_32","006_32_32","DEU","32","32","32","他們的葡萄樹是所多瑪的葡萄樹， 蛾摩拉田園所生的； 他們的葡萄是毒葡萄， 全掛都是苦的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT32_33","006_32_33","DEU","32","33","33","他們的酒是大蛇的毒氣， 是虺蛇殘害的惡毒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT32_34","006_32_34","DEU","32","34","34","這不都是積蓄在我這裏， 封鎖在我府庫中嗎？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT32_35","006_32_35","DEU","32","35","35","他們失腳的時候，伸冤報應在我； 因他們遭災的日子近了； 那要臨在他們身上的必速速來到。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT32_36","006_32_36","DEU","32","36","36","耶和華見他百姓毫無能力， 無論困住的、自由的都沒有剩下， 就必為他們伸冤， 為他的僕人後悔。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT32_37","006_32_37","DEU","32","37","37","他必說：他們的神， 他們所投靠的磐石， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT32_38","006_32_38","DEU","32","38","38","就是向來吃他們祭牲的脂油， 喝他們奠祭之酒的，在哪裏呢？ 他可以興起幫助你們， 護衛你們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT32_39","006_32_39","DEU","32","39","39","你們如今要知道： 我，惟有我是上帝； 在我以外並無別神。 我使人死，我使人活； 我損傷，我也醫治， 並無人能從我手中救出來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT32_40","006_32_40","DEU","32","40","40","我向天舉手說： 我憑我的永生起誓： ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT32_41","006_32_41","DEU","32","41","41","我若磨我閃亮的刀， 手掌審判之權， 就必報復我的敵人， 報應恨我的人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT32_42","006_32_42","DEU","32","42","42","我要使我的箭飲血飲醉， 就是被殺被擄之人的血。 我的刀要吃肉， 乃是仇敵中首領之頭的肉。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT32_43","006_32_43","DEU","32","43","43","你們外邦人當與主的百姓一同歡呼； 因他要伸他僕人流血的冤， 報應他的敵人， 潔淨他的地，救贖他的百姓。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT32_44","006_32_44","DEU","32","44","44","摩西和嫩的兒子約書亞去將這歌的一切話說給百姓聽。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT32_45","006_32_45","DEU","32","45","45","摩西向以色列眾人說完了這一切的話， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT32_46","006_32_46","DEU","32","46","46","又說：「我今日所警教你們的，你們都要放在心上；要吩咐你們的子孫謹守遵行這律法上的話。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT32_47","006_32_47","DEU","32","47","47","因為這不是虛空、與你們無關的事，乃是你們的生命；在你們過約旦河要得為業的地上必因這事日子得以長久。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT32_48","006_32_48","DEU","32","48","48","當日，耶和華吩咐摩西說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT32_49","006_32_49","DEU","32","49","49","「你上這亞巴琳山中的尼波山去，在摩押地與耶利哥相對，觀看我所要賜給以色列人為業的迦南地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT32_50","006_32_50","DEU","32","50","50","你必死在你所登的山上，歸你列祖去，像你哥哥亞倫死在何珥山上，歸他的列祖一樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT32_51","006_32_51","DEU","32","51","51","因為你們在尋的曠野，加低斯的米利巴水，在以色列人中沒有尊我為聖，得罪了我。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT32_52","006_32_52","DEU","32","52","52","我所賜給以色列人的地，你可以遠遠地觀看，卻不得進去。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT33_1","006_33_1","DEU","33","1","1","以下是神人摩西在未死之先為以色列人所祝的福： ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT33_2","006_33_2","DEU","33","2","2","他說：耶和華從西奈而來， 從西珥向他們顯現， 從巴蘭山發出光輝， 從萬萬聖者中來臨， 從他右手為百姓傳出烈火的律法。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT33_3","006_33_3","DEU","33","3","3","他疼愛百姓； 眾聖徒都在他手中。 他們坐在他的腳下， 領受他的言語。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT33_4","006_33_4","DEU","33","4","4","摩西將律法傳給我們， 作為雅各會眾的產業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT33_5","006_33_5","DEU","33","5","5","百姓的眾首領， 以色列的各支派， 一同聚會的時候， 耶和華在耶書崙中為王。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT33_6","006_33_6","DEU","33","6","6","願呂便存活，不致死亡； 願他人數不致稀少。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT33_7","006_33_7","DEU","33","7","7","為猶大祝福說： 求耶和華俯聽猶大的聲音， 引導他歸於本族； 他曾用手為自己爭戰， 你必幫助他攻擊敵人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT33_8","006_33_8","DEU","33","8","8","論利未說： 耶和華啊，你的土明和烏陵 都在你的虔誠人那裏。 你在瑪撒曾試驗他， 在米利巴水與他爭論。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT33_9","006_33_9","DEU","33","9","9","他論自己的父母說： 我未曾看見； 他也不承認弟兄， 也不認識自己的兒女。 這是因利未人遵行你的話， 謹守你的約。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT33_10","006_33_10","DEU","33","10","10","他們要將你的典章教訓雅各， 將你的律法教訓以色列。 他們要把香焚在你面前， 把全牲的燔祭獻在你的壇上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT33_11","006_33_11","DEU","33","11","11","求耶和華降福在他的財物上， 悅納他手裏所辦的事。 那些起來攻擊他和恨惡他的人， 願你刺透他們的腰， 使他們不得再起來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT33_12","006_33_12","DEU","33","12","12","論便雅憫說： 耶和華所親愛的必同耶和華安然居住； 耶和華終日遮蔽他，也住在他兩肩之中。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT33_13","006_33_13","DEU","33","13","13","論約瑟說： 願他的地蒙耶和華賜福， 得天上的寶物、甘露， 以及地裏所藏的泉水； ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT33_14","006_33_14","DEU","33","14","14","得太陽所曬熟的美果， 月亮所養成的寶物； ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT33_15","006_33_15","DEU","33","15","15","得上古之山的至寶， 永世之嶺的寶物； ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT33_16","006_33_16","DEU","33","16","16","得地和其中所充滿的寶物， 並住荊棘中上主的喜悅。 願這些福都歸於約瑟的頭上， 歸於那與弟兄迥別之人的頂上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT33_17","006_33_17","DEU","33","17","17","他為牛群中頭生的，有威嚴； 他的角是野牛的角， 用以牴觸萬邦，直到地極。 這角是以法蓮的萬萬， 瑪拿西的千千。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT33_18","006_33_18","DEU","33","18","18","論西布倫說： 西布倫哪，你出外可以歡喜。 以薩迦啊，在你帳棚裏可以快樂。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT33_19","006_33_19","DEU","33","19","19","他們要將列邦召到山上， 在那裏獻公義的祭； 因為他們要吸取海裏的豐富， 並沙中所藏的珍寶。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT33_20","006_33_20","DEU","33","20","20","論迦得說： 使迦得擴張的應當稱頌！ 迦得住如母獅； 他撕裂膀臂，連頭頂也撕裂。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT33_21","006_33_21","DEU","33","21","21","他為自己選擇頭一段地， 因在那裏有設立律法者的分存留。 他與百姓的首領同來； 他施行耶和華的公義 和耶和華與以色列所立的典章。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT33_22","006_33_22","DEU","33","22","22","論但說： 但為小獅子， 從巴珊跳出來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT33_23","006_33_23","DEU","33","23","23","論拿弗他利說： 拿弗他利啊，你足沾恩惠， 滿得耶和華的福， 可以得西方和南方為業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT33_24","006_33_24","DEU","33","24","24","論亞設說： 願亞設享受多子的福樂， 得他弟兄的喜悅， 可以把腳蘸在油中。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT33_25","006_33_25","DEU","33","25","25","你的門閂是銅的，鐵的。 你的日子如何，你的力量也必如何。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT33_26","006_33_26","DEU","33","26","26","耶書崙哪，沒有能比上帝的。 他為幫助你，乘在天空， 顯其威榮，駕行穹蒼。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT33_27","006_33_27","DEU","33","27","27","永生的上帝是你的居所； 他永久的膀臂在你以下。 他在你前面攆出仇敵， 說：毀滅吧。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT33_28","006_33_28","DEU","33","28","28","以色列安然居住； 雅各的本源獨居五穀新酒之地。 他的天也滴甘露。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT33_29","006_33_29","DEU","33","29","29","以色列啊，你是有福的！ 誰像你這蒙耶和華所拯救的百姓呢？ 他是你的盾牌，幫助你， 是你威榮的刀劍。 你的仇敵必投降你； 你必踏在他們的高處。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT34_1","006_34_1","DEU","34","1","1","摩西從摩押平原登尼波山，上了那與耶利哥相對的毗斯迦山頂。耶和華把基列全地直到但， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT34_2","006_34_2","DEU","34","2","2","拿弗他利全地，以法蓮、瑪拿西的地，猶大全地直到西海， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT34_3","006_34_3","DEU","34","3","3","南地和棕樹城耶利哥的平原，直到瑣珥，都指給他看。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT34_4","006_34_4","DEU","34","4","4","耶和華對他說：「這就是我向亞伯拉罕、以撒、雅各起誓應許之地，說：『我必將這地賜給你的後裔。』現在我使你眼睛看見了，你卻不得過到那裏去。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT34_5","006_34_5","DEU","34","5","5","於是，耶和華的僕人摩西死在摩押地，正如耶和華所說的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT34_6","006_34_6","DEU","34","6","6","耶和華將他埋葬在摩押地、伯‧毗珥對面的谷中，只是到今日沒有人知道他的墳墓。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT34_7","006_34_7","DEU","34","7","7","摩西死的時候年一百二十歲；眼目沒有昏花，精神沒有衰敗。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT34_8","006_34_8","DEU","34","8","8","以色列人在摩押平原為摩西哀哭了三十日，為摩西居喪哀哭的日子就滿了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT34_9","006_34_9","DEU","34","9","9","嫩的兒子約書亞；因為摩西曾按手在他頭上，就被智慧的靈充滿，以色列人便聽從他，照着耶和華吩咐摩西的行了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT34_10","006_34_10","DEU","34","10","10","以後以色列中再沒有興起先知像摩西的。他是耶和華面對面所認識的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT34_11","006_34_11","DEU","34","11","11","耶和華打發他在埃及地向法老和他的一切臣僕，並他的全地，行各樣神蹟奇事， ");
INSERT INTO cmn_cu89t_vpl VALUES ("DT34_12","006_34_12","DEU","34","12","12","又在以色列眾人眼前顯大能的手，行一切大而可畏的事。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","1","耶和華的僕人摩西死了以後，耶和華曉諭摩西的幫手，嫩的兒子約書亞，說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS1_2","007_1_2","JOS","1","2","2","「我的僕人摩西死了。現在你要起來，和眾百姓過這約旦河，往我所要賜給以色列人的地去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS1_3","007_1_3","JOS","1","3","3","凡你們腳掌所踏之地，我都照着我所應許摩西的話賜給你們了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS1_4","007_1_4","JOS","1","4","4","從曠野和這黎巴嫩，直到幼發拉底大河，赫人的全地，又到大海日落之處，都要作你們的境界。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS1_5","007_1_5","JOS","1","5","5","你平生的日子，必無一人能在你面前站立得住。我怎樣與摩西同在，也必照樣與你同在；我必不撇下你，也不丟棄你。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS1_6","007_1_6","JOS","1","6","6","你當剛強壯膽！因為你必使這百姓承受那地為業，就是我向他們列祖起誓應許賜給他們的地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS1_7","007_1_7","JOS","1","7","7","只要剛強，大大壯膽，謹守遵行我僕人摩西所吩咐你的一切律法，不可偏離左右，使你無論往哪裏去，都可以順利。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS1_8","007_1_8","JOS","1","8","8","這律法書不可離開你的口，總要晝夜思想，好使你謹守遵行這書上所寫的一切話。如此，你的道路就可以亨通，凡事順利。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS1_9","007_1_9","JOS","1","9","9","我豈沒有吩咐你嗎？你當剛強壯膽！不要懼怕，也不要驚惶；因為你無論往哪裏去，耶和華－你的上帝必與你同在。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS1_10","007_1_10","JOS","1","10","10","於是，約書亞吩咐百姓的官長說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS1_11","007_1_11","JOS","1","11","11","「你們要走遍營中，吩咐百姓說：『當預備食物；因為三日之內你們要過這約旦河，進去得耶和華－你們上帝賜你們為業之地。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS1_12","007_1_12","JOS","1","12","12","約書亞對呂便人、迦得人，和瑪拿西半支派的人說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS1_13","007_1_13","JOS","1","13","13","「你們要追念耶和華的僕人摩西所吩咐你們的話說：『耶和華－你們的上帝使你們得享平安，也必將這地賜給你們。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS1_14","007_1_14","JOS","1","14","14","你們的妻子、孩子，和牲畜都可以留在約旦河東、摩西所給你們的地；但你們中間一切大能的勇士都要帶着兵器在你們的弟兄前面過去，幫助他們， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS1_15","007_1_15","JOS","1","15","15","等到耶和華使你們的弟兄像你們一樣得享平安，並且得着耶和華－你們上帝所賜他們為業之地，那時才可以回你們所得之地，承受為業，就是耶和華的僕人摩西在約旦河東、向日出之地所給你們的。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS1_16","007_1_16","JOS","1","16","16","他們回答約書亞說：「你所吩咐我們行的，我們都必行；你所差遣我們去的，我們都必去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS1_17","007_1_17","JOS","1","17","17","我們從前在一切事上怎樣聽從摩西，現在也必照樣聽從你；惟願耶和華－你的上帝與你同在，像與摩西同在一樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS1_18","007_1_18","JOS","1","18","18","無論甚麼人違背你的命令，不聽從你所吩咐他的一切話，就必治死他。你只要剛強壯膽！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS2_1","007_2_1","JOS","2","1","1","當下，嫩的兒子約書亞從什亭暗暗打發兩個人作探子，吩咐說：「你們去窺探那地和耶利哥。」於是二人去了，來到一個妓女名叫喇合的家裏，就在那裏躺臥。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS2_2","007_2_2","JOS","2","2","2","有人告訴耶利哥王說：「今夜有以色列人來到這裏窺探此地。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS2_3","007_2_3","JOS","2","3","3","耶利哥王打發人去見喇合說：「那來到你這裏、進了你家的人要交出來，因為他們來窺探全地。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS2_4","007_2_4","JOS","2","4","4","女人將二人隱藏，就回答說：「那人果然到我這裏來；他們是哪裏來的我卻不知道。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS2_5","007_2_5","JOS","2","5","5","天黑、要關城門的時候，他們出去了，往哪裏去我卻不知道。你們快快地去追趕，就必追上。」（ ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS2_6","007_2_6","JOS","2","6","6","先是女人領二人上了房頂，將他們藏在那裏所擺的麻稭中。） ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS2_7","007_2_7","JOS","2","7","7","那些人就往約旦河的渡口追趕他們去了。追趕他們的人一出去，城門就關了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS2_8","007_2_8","JOS","2","8","8","二人還沒有躺臥，女人就上房頂，到他們那裏， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS2_9","007_2_9","JOS","2","9","9","對他們說：「我知道耶和華已經把這地賜給你們，並且因你們的緣故我們都驚慌了。這地的一切居民在你們面前心都消化了； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS2_10","007_2_10","JOS","2","10","10","因為我們聽見你們出埃及的時候，耶和華怎樣在你們前面使紅海的水乾了，並且你們怎樣待約旦河東的兩個亞摩利王西宏和噩，將他們盡行毀滅。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS2_11","007_2_11","JOS","2","11","11","我們一聽見這些事，心就消化了。因你們的緣故，並無一人有膽氣。耶和華－你們的上帝本是上天下地的上帝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS2_12","007_2_12","JOS","2","12","12","現在我既是恩待你們，求你們指着耶和華向我起誓，也要恩待我父家，並給我一個實在的證據， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS2_13","007_2_13","JOS","2","13","13","要救活我的父母、弟兄、姊妹，和一切屬他們的，拯救我們性命不死。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS2_14","007_2_14","JOS","2","14","14","二人對她說：「你若不洩漏我們這件事，我們情願替你們死。耶和華將這地賜給我們的時候，我們必以慈愛誠實待你。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS2_15","007_2_15","JOS","2","15","15","於是女人用繩子將二人從窗戶裏縋下去；因她的房子是在城牆邊上，她也住在城牆上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS2_16","007_2_16","JOS","2","16","16","她對他們說：「你們且往山上去，恐怕追趕的人碰見你們；要在那裏隱藏三天，等追趕的人回來，然後才可以走你們的路。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS2_17","007_2_17","JOS","2","17","17","二人對她說：「你要這樣行。不然，你叫我們所起的誓就與我們無干了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS2_18","007_2_18","JOS","2","18","18","我們來到這地的時候，你要把這條朱紅線繩繫在縋我們下去的窗戶上，並要使你的父母、弟兄，和你父的全家都聚集在你家中。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS2_19","007_2_19","JOS","2","19","19","凡出了你家門往街上去的，他的罪 必歸到自己的頭上，與我們無干了。凡在你家裏的，若有人下手害他，流他血的罪就歸到我們的頭上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS2_20","007_2_20","JOS","2","20","20","你若洩漏我們這件事，你叫我們所起的誓就與我們無干了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS2_21","007_2_21","JOS","2","21","21","女人說：「照你們的話行吧！」於是打發他們去了，又把朱紅線繩繫在窗戶上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS2_22","007_2_22","JOS","2","22","22","二人到山上，在那裏住了三天，等着追趕的人回去了。追趕的人一路找他們，卻找不着。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS2_23","007_2_23","JOS","2","23","23","二人就下山回來，過了河，到嫩的兒子約書亞那裏，向他述說所遭遇的一切事； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS2_24","007_2_24","JOS","2","24","24","又對約書亞說：「耶和華果然將那全地交在我們手中；那地的一切居民在我們面前心都消化了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS3_1","007_3_1","JOS","3","1","1","約書亞清早起來，和以色列眾人都離開什亭，來到約旦河，就住在那裏，等候過河。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS3_2","007_3_2","JOS","3","2","2","過了三天，官長走遍營中， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS3_3","007_3_3","JOS","3","3","3","吩咐百姓說：「你們看見耶和華－你們上帝的約櫃，又見祭司利未人抬着，就要離開所住的地方，跟着約櫃去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS3_4","007_3_4","JOS","3","4","4","只是你們和約櫃相離要量二千肘，不可與約櫃相近，使你們知道所當走的路，因為這條路你們向來沒有走過。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS3_5","007_3_5","JOS","3","5","5","約書亞吩咐百姓說：「你們要自潔，因為明天耶和華必在你們中間行奇事。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS3_6","007_3_6","JOS","3","6","6","約書亞又吩咐祭司說：「你們抬起約櫃，在百姓前頭過去。」於是他們抬起約櫃，在百姓前頭走。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS3_7","007_3_7","JOS","3","7","7","耶和華對約書亞說：「從今日起，我必使你在以色列眾人眼前尊大，使他們知道我怎樣與摩西同在，也必照樣與你同在。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS3_8","007_3_8","JOS","3","8","8","你要吩咐抬約櫃的祭司說：『你們到了約旦河的水邊上，就要在約旦河水裏站住。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS3_9","007_3_9","JOS","3","9","9","約書亞對以色列人說：「你們近前來，聽耶和華－你們上帝的話。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS3_10","007_3_10","JOS","3","10","11","約書亞說：「看哪，普天下主的約櫃必在你們前頭過去，到約旦河裏，因此你們就知道在你們中間有永生上帝；並且他必在你們面前趕出迦南人、赫人、希未人、比利洗人、革迦撒人、亞摩利人、耶布斯人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS3_12","007_3_12","JOS","3","12","12","你們現在要從以色列支派中揀選十二個人，每支派一人， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS3_13","007_3_13","JOS","3","13","13","等到抬普天下主耶和華約櫃的祭司把腳站在約旦河水裏，約旦河的水，就是從上往下流的水，必然斷絕，立起成壘。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS3_14","007_3_14","JOS","3","14","14","百姓離開帳棚要過約旦河的時候，抬約櫃的祭司乃在百姓的前頭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS3_15","007_3_15","JOS","3","15","15","他們到了約旦河，腳一入水（原來約旦河水在收割的日子漲過兩岸）， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS3_16","007_3_16","JOS","3","16","16","那從上往下流的水便在極遠之地、撒拉但旁的亞當城那裏停住，立起成壘；那往亞拉巴的海，就是鹽海，下流的水全然斷絕。於是百姓在耶利哥的對面過去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS3_17","007_3_17","JOS","3","17","17","抬耶和華約櫃的祭司在約旦河中的乾地上站定，以色列眾人都從乾地上過去，直到國民盡都過了約旦河。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS4_1","007_4_1","JOS","4","1","1","國民盡都過了約旦河，耶和華就對約書亞說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS4_2","007_4_2","JOS","4","2","2","「你從民中要揀選十二個人，每支派一人， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS4_3","007_4_3","JOS","4","3","3","吩咐他們說：『你們從這裏，從約旦河中、祭司腳站定的地方，取十二塊石頭帶過去，放在你們今夜要住宿的地方。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS4_4","007_4_4","JOS","4","4","4","於是，約書亞將他從以色列人中所預備的那十二個人，每支派一人，都召了來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS4_5","007_4_5","JOS","4","5","5","對他們說：「你們下約旦河中，過到耶和華－你們上帝的約櫃前頭，按着以色列人十二支派的數目，每人取一塊石頭扛在肩上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS4_6","007_4_6","JOS","4","6","6","這些石頭在你們中間可以作為證據。日後，你們的子孫問你們說：『這些石頭是甚麼意思？』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS4_7","007_4_7","JOS","4","7","7","你們就對他們說：『這是因為約旦河的水在耶和華的約櫃前斷絕；約櫃過約旦河的時候，約旦河的水就斷絕了。這些石頭要作以色列人永遠的紀念。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS4_8","007_4_8","JOS","4","8","8","以色列人就照約書亞所吩咐的，按着以色列人支派的數目，從約旦河中取了十二塊石頭，都遵耶和華所吩咐約書亞的行了。他們把石頭帶過去，到他們所住宿的地方，就放在那裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS4_9","007_4_9","JOS","4","9","9","約書亞另把十二塊石頭立在約旦河中，在抬約櫃的祭司腳站立的地方；直到今日，那石頭還在那裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS4_10","007_4_10","JOS","4","10","10","抬約櫃的祭司站在約旦河中，等到耶和華曉諭約書亞吩咐百姓的事辦完了，是照摩西所吩咐約書亞的一切話。 於是百姓急速過去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS4_11","007_4_11","JOS","4","11","11","眾百姓盡都過了河，耶和華的約櫃和祭司就在百姓面前過去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS4_12","007_4_12","JOS","4","12","12","呂便人、迦得人、瑪拿西半支派的人都照摩西所吩咐他們的，帶着兵器在以色列人前頭過去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS4_13","007_4_13","JOS","4","13","13","約有四萬人都準備打仗，在耶和華面前過去，到耶利哥的平原，等候上陣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS4_14","007_4_14","JOS","4","14","14","當那日，耶和華使約書亞在以色列眾人眼前尊大。在他平生的日子，百姓敬畏他，像從前敬畏摩西一樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS4_15","007_4_15","JOS","4","15","15","耶和華曉諭約書亞說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS4_16","007_4_16","JOS","4","16","16","「你吩咐抬法櫃的祭司從約旦河裏上來。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS4_17","007_4_17","JOS","4","17","17","約書亞就吩咐祭司說：「你們從約旦河裏上來。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS4_18","007_4_18","JOS","4","18","18","抬耶和華約櫃的祭司從約旦河裏上來，腳掌剛落旱地，約旦河的水就流到原處，仍舊漲過兩岸。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS4_19","007_4_19","JOS","4","19","19","正月初十日，百姓從約旦河裏上來，就在吉甲，在耶利哥的東邊安營。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS4_20","007_4_20","JOS","4","20","20","他們從約旦河中取來的那十二塊石頭，約書亞就立在吉甲， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS4_21","007_4_21","JOS","4","21","21","對以色列人說：「日後你們的子孫問他們的父親說：『這些石頭是甚麼意思？』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS4_22","007_4_22","JOS","4","22","22","你們就告訴他們說：『以色列人曾走乾地過這約旦河； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS4_23","007_4_23","JOS","4","23","23","因為耶和華－你們的上帝在你們前面使約旦河的水乾了，等着你們過來，就如耶和華－你們的上帝從前在我們前面使紅海乾了，等着我們過來一樣， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS4_24","007_4_24","JOS","4","24","24","要使地上萬民都知道，耶和華的手大有能力，也要使你們永遠敬畏耶和華－你們的上帝。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS5_1","007_5_1","JOS","5","1","1","約旦河西亞摩利人的諸王和靠海迦南人的諸王，聽見耶和華在以色列人前面使約旦河的水乾了，等到我們過去，他們的心因以色列人的緣故就消化了，不再有膽氣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS5_2","007_5_2","JOS","5","2","2","那時，耶和華吩咐約書亞說：「你製造火石刀，第二次給以色列人行割禮。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS5_3","007_5_3","JOS","5","3","3","約書亞就製造了火石刀，在「除皮山」那裏給以色列人行割禮。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS5_4","007_5_4","JOS","5","4","4","約書亞行割禮的緣故，是因為從埃及出來的眾民，就是一切能打仗的男丁，出了埃及以後，都死在曠野的路上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS5_5","007_5_5","JOS","5","5","5","因為出來的眾民都受過割禮；惟獨出埃及以後、在曠野的路上所生的眾民都沒有受過割禮。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS5_6","007_5_6","JOS","5","6","6","以色列人在曠野走了四十年，等到國民，就是出埃及的兵丁，都消滅了，因為他們沒有聽從耶和華的話。耶和華曾向他們起誓，必不容他們看見耶和華向他們列祖起誓、應許賜給我們的地，就是流奶與蜜之地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS5_7","007_5_7","JOS","5","7","7","他們的子孫，就是耶和華所興起來接續他們的，都沒有受過割禮；因為在路上沒有給他們行割禮，約書亞這才給他們行了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS5_8","007_5_8","JOS","5","8","8","國民都受完了割禮，就住在營中自己的地方，等到痊癒了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS5_9","007_5_9","JOS","5","9","9","耶和華對約書亞說：「我今日將埃及的羞辱從你們身上滾去了。」因此，那地方名叫吉甲，直到今日。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS5_10","007_5_10","JOS","5","10","10","以色列人在吉甲安營。正月十四日晚上，在耶利哥的平原守逾越節。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS5_11","007_5_11","JOS","5","11","11","逾越節的次日，他們就吃了那地的出產；正當那日吃無酵餅和烘的穀。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS5_12","007_5_12","JOS","5","12","12","他們吃了那地的出產，第二日嗎哪就止住了，以色列人也不再有嗎哪了。那一年，他們卻吃迦南地的出產。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS5_13","007_5_13","JOS","5","13","13","約書亞靠近耶利哥的時候，舉目觀看，不料，有一個人手裏有拔出來的刀，對面站立。約書亞到他那裏，問他說：「你是幫助我們呢，是幫助我們敵人呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS5_14","007_5_14","JOS","5","14","14","他回答說：「不是的，我來是要作耶和華軍隊的元帥。」約書亞就俯伏在地下拜，說：「我主有甚麼話吩咐僕人。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS5_15","007_5_15","JOS","5","15","15","耶和華軍隊的元帥對約書亞說：「把你腳上的鞋脫下來，因為你所站的地方是聖的。」約書亞就照着行了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS6_1","007_6_1","JOS","6","1","1","耶利哥的城門因以色列人就關得嚴緊，無人出入。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS6_2","007_6_2","JOS","6","2","2","耶和華曉諭約書亞說：「看哪，我已經把耶利哥和耶利哥的王，並大能的勇士，都交在你手中。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS6_3","007_6_3","JOS","6","3","3","你們的一切兵丁要圍繞這城，一日圍繞一次，六日都要這樣行。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS6_4","007_6_4","JOS","6","4","4","七個祭司要拿七個羊角走在約櫃前。到第七日，你們要繞城七次，祭司也要吹角。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS6_5","007_6_5","JOS","6","5","5","他們吹的角聲拖長，你們聽見角聲，眾百姓要大聲呼喊，城牆就必塌陷，各人都要往前直上。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS6_6","007_6_6","JOS","6","6","6","嫩的兒子約書亞召了祭司來，吩咐他們說：「你們抬起約櫃來，要有七個祭司拿七個羊角走在耶和華的約櫃前」； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS6_7","007_6_7","JOS","6","7","7","又對百姓說：「你們前去繞城，帶兵器的要走在耶和華的約櫃前。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS6_8","007_6_8","JOS","6","8","8","約書亞對百姓說完了話，七個祭司拿七個羊角走在耶和華面前吹角；耶和華的約櫃在他們後面跟隨。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS6_9","007_6_9","JOS","6","9","9","帶兵器的走在吹角的祭司前面，後隊隨着約櫃行。祭司一面走一面吹。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS6_10","007_6_10","JOS","6","10","10","約書亞吩咐百姓說：「你們不可呼喊，不可出聲，連一句話也不可出你們的口，等到我吩咐你們呼喊的日子，那時才可以呼喊。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS6_11","007_6_11","JOS","6","11","11","這樣，他使耶和華的約櫃繞城，把城繞了一次；眾人回到營裏，就在營裏住宿。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS6_12","007_6_12","JOS","6","12","12","約書亞清早起來，祭司又抬起耶和華的約櫃。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS6_13","007_6_13","JOS","6","13","13","七個祭司拿七個羊角在耶和華的約櫃前，時常行走吹角；帶兵器的在他們前面走，後隊隨着耶和華的約櫃行。祭司一面走一面吹。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS6_14","007_6_14","JOS","6","14","14","第二日，眾人把城繞了一次，就回營裏去。六日都是這樣行。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS6_15","007_6_15","JOS","6","15","15","第七日清早，黎明的時候，他們起來，照樣繞城七次；惟獨這日把城繞了七次。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS6_16","007_6_16","JOS","6","16","16","到了第七次，祭司吹角的時候，約書亞吩咐百姓說：「呼喊吧，因為耶和華已經把城交給你們了！ ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS6_17","007_6_17","JOS","6","17","17","這城和其中所有的都要在耶和華面前毀滅；只有妓女喇合與她家中所有的可以存活，因為她隱藏了我們所打發的使者。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS6_18","007_6_18","JOS","6","18","18","至於你們，務要謹慎，不可取那當滅的物，恐怕你們取了那當滅的物就連累以色列的全營，使全營受咒詛。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS6_19","007_6_19","JOS","6","19","19","惟有金子、銀子，和銅鐵的器皿都要歸耶和華為聖，必入耶和華的庫中。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS6_20","007_6_20","JOS","6","20","20","於是百姓呼喊，祭司也吹角。百姓聽見角聲，便大聲呼喊，城牆就塌陷，百姓便上去進城，各人往前直上，將城奪取； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS6_21","007_6_21","JOS","6","21","21","又將城中所有的，不拘男女老少，牛羊和驢，都用刀殺盡。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS6_22","007_6_22","JOS","6","22","22","約書亞吩咐窺探地的兩個人說：「你們進那妓女的家，照着你們向她所起的誓，將那女人和她所有的都從那裏帶出來。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS6_23","007_6_23","JOS","6","23","23","當探子的兩個少年人就進去，將喇合與她的父母、弟兄，和她所有的，並她一切的親眷，都帶出來，安置在以色列的營外。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS6_24","007_6_24","JOS","6","24","24","眾人就用火將城和其中所有的焚燒了；惟有金子、銀子，和銅鐵的器皿都放在耶和華殿的庫中。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS6_25","007_6_25","JOS","6","25","25","約書亞卻把妓女喇合與她父家，並她所有的，都救活了；因為她隱藏了約書亞所打發窺探耶利哥的使者，她就住在以色列中，直到今日。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS6_26","007_6_26","JOS","6","26","26","當時，約書亞叫眾人起誓說：「有興起重修這耶利哥城的人，當在耶和華面前受咒詛。 他立根基的時候，必喪長子， 安門的時候，必喪幼子。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS6_27","007_6_27","JOS","6","27","27","耶和華與約書亞同在，約書亞的聲名傳揚遍地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS7_1","007_7_1","JOS","7","1","1","以色列人在當滅的物上犯了罪；因為猶大支派中，謝拉的曾孫，撒底的孫子，迦米的兒子亞干取了當滅的物；耶和華的怒氣就向以色列人發作。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS7_2","007_7_2","JOS","7","2","2","當下，約書亞從耶利哥打發人往伯特利東邊、靠近伯‧亞文的艾城去，吩咐他們說：「你們上去窺探那地。」他們就上去窺探艾城。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS7_3","007_7_3","JOS","7","3","3","他們回到約書亞那裏，對他說：「眾民不必都上去，只要二三千人上去就能攻取艾城；不必勞累眾民都去，因為那裏的人少。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS7_4","007_7_4","JOS","7","4","4","於是民中約有三千人上那裏去，竟在艾城人面前逃跑了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS7_5","007_7_5","JOS","7","5","5","艾城的人擊殺了他們三十六人，從城門前追趕他們，直到示巴琳，在下坡殺敗他們；眾民的心就消化如水。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS7_6","007_7_6","JOS","7","6","6","約書亞便撕裂衣服；他和以色列的長老把灰撒在頭上，在耶和華的約櫃前俯伏在地，直到晚上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS7_7","007_7_7","JOS","7","7","7","約書亞說：「哀哉！主耶和華啊，你為甚麼竟領這百姓過約旦河，將我們交在亞摩利人的手中，使我們滅亡呢？我們不如住在約旦河那邊倒好。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS7_8","007_7_8","JOS","7","8","8","主啊，以色列人既在仇敵面前轉背逃跑，我還有甚麼可說的呢？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS7_9","007_7_9","JOS","7","9","9","迦南人和這地一切的居民聽見了就必圍困我們，將我們的名從地上除滅。那時你為你的大名要怎樣行呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS7_10","007_7_10","JOS","7","10","10","耶和華吩咐約書亞說：「起來！你為何這樣俯伏在地呢？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS7_11","007_7_11","JOS","7","11","11","以色列人犯了罪，違背了我所吩咐他們的約，取了當滅的物；又偷竊，又行詭詐，又把那當滅的放在他們的家具裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS7_12","007_7_12","JOS","7","12","12","因此，以色列人在仇敵面前站立不住。他們在仇敵面前轉背逃跑，是因成了被咒詛的；你們若不把當滅的物從你們中間除掉，我就不再與你們同在了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS7_13","007_7_13","JOS","7","13","13","你起來，叫百姓自潔，對他們說：『你們要自潔，預備明天，因為耶和華－以色列的上帝這樣說：以色列啊，你們中間有當滅的物，你們若不除掉，在仇敵面前必站立不住！』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS7_14","007_7_14","JOS","7","14","14","到了早晨，你們要按着支派近前來；耶和華所取的支派，要按着宗族近前來；耶和華所取的宗族，要按着家室近前來；耶和華所取的家室，要按着人丁，一個一個地近前來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS7_15","007_7_15","JOS","7","15","15","被取的人有當滅的物在他那裏，他和他所有的必被火焚燒；因他違背了耶和華的約，又因他在以色列中行了愚妄的事。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS7_16","007_7_16","JOS","7","16","16","於是，約書亞清早起來，使以色列人按着支派近前來，取出來的是猶大支派； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS7_17","007_7_17","JOS","7","17","17","使猶大支派近前來，就取了謝拉的宗族；使謝拉的宗族，按着家室人丁，一個一個地近前來，取出來的是撒底； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS7_18","007_7_18","JOS","7","18","18","使撒底的家室，按着人丁，一個一個地近前來，就取出猶大支派的人謝拉的曾孫，撒底的孫子，迦米的兒子亞干。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS7_19","007_7_19","JOS","7","19","19","約書亞對亞干說：「我兒，我勸你將榮耀歸給耶和華－以色列的上帝，在他面前認罪，將你所做的事告訴我，不要向我隱瞞。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS7_20","007_7_20","JOS","7","20","20","亞干回答約書亞說：「我實在得罪了耶和華－以色列的上帝。我所做的事如此如此： ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS7_21","007_7_21","JOS","7","21","21","我在所奪的財物中看見一件美好的示拿衣服，二百舍客勒銀子，一條金子重五十舍客勒，我就貪愛這些物件，便拿去了。現今藏在我帳棚內的地裏，銀子在衣服底下。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS7_22","007_7_22","JOS","7","22","22","約書亞就打發人跑到亞干的帳棚裏。那件衣服果然藏在他帳棚內，銀子在底下。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS7_23","007_7_23","JOS","7","23","23","他們就從帳棚裏取出來，拿到約書亞和以色列眾人那裏，放在耶和華面前。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS7_24","007_7_24","JOS","7","24","24","約書亞和以色列眾人把謝拉的曾孫亞干和那銀子、那件衣服、那條金子，並亞干的兒女、牛、驢、羊、帳棚，以及他所有的，都帶到亞割谷去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS7_25","007_7_25","JOS","7","25","25","約書亞說：「你為甚麼連累我們呢？今日耶和華必叫你受連累。」於是以色列眾人用石頭打死他，將石頭扔在其上，又用火焚燒他所有的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS7_26","007_7_26","JOS","7","26","26","眾人在亞干身上堆成一大堆石頭，直存到今日。於是耶和華轉意，不發他的烈怒。因此那地方名叫亞割谷，直到今日。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS8_1","007_8_1","JOS","8","1","1","耶和華對約書亞說：「不要懼怕，也不要驚惶。你起來，率領一切兵丁上艾城去，我已經把艾城的王和他的民、他的城，並他的地，都交在你手裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS8_2","007_8_2","JOS","8","2","2","你怎樣待耶利哥和耶利哥的王，也當照樣待艾城和艾城的王。只是城內所奪的財物和牲畜，你們可以取為自己的掠物。你要在城後設下伏兵。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS8_3","007_8_3","JOS","8","3","3","於是，約書亞和一切兵丁都起來，要上艾城去。約書亞選了三萬大能的勇士，夜間打發他們前往， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS8_4","007_8_4","JOS","8","4","4","吩咐他們說：「你們要在城後埋伏，不可離城太遠，都要各自準備。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS8_5","007_8_5","JOS","8","5","5","我與我所帶領的眾民要向城前往。城裏的人像初次出來攻擊我們的時候，我們就在他們面前逃跑， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS8_6","007_8_6","JOS","8","6","6","他們必出來追趕我們，直到我們引誘他們離開城；因為他們必說：『這些人像初次在我們面前逃跑。』所以我們要在他們面前逃跑， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS8_7","007_8_7","JOS","8","7","7","你們就從埋伏的地方起來，奪取那城，因為耶和華－你們的上帝必把城交在你們手裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS8_8","007_8_8","JOS","8","8","8","你們奪了城以後，就放火燒城，要照耶和華的話行。這是我吩咐你們的。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS8_9","007_8_9","JOS","8","9","9","約書亞打發他們前往，他們就上埋伏的地方去，住在伯特利和艾城的中間，就是在艾城的西邊。這夜約書亞卻在民中住宿。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS8_10","007_8_10","JOS","8","10","10","約書亞清早起來，點齊百姓，他和以色列的長老在百姓前面上艾城去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS8_11","007_8_11","JOS","8","11","11","眾民，就是他所帶領的兵丁，都上去，向前直往，來到城前，在艾城北邊安營。在約書亞和艾城中間有一山谷。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS8_12","007_8_12","JOS","8","12","12","他挑了約有五千人，使他們埋伏在伯特利和艾城的中間，就是在艾城的西邊， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS8_13","007_8_13","JOS","8","13","13","於是安置了百姓，就是城北的全軍和城西的伏兵。這夜約書亞進入山谷之中。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS8_14","007_8_14","JOS","8","14","14","艾城的王看見這景況，就和全城的人，清早急忙起來，按所定的時候，出到亞拉巴前，要與以色列人交戰；王卻不知道在城後有伏兵。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS8_15","007_8_15","JOS","8","15","15","約書亞和以色列眾人在他們面前裝敗，往那通曠野的路逃跑。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS8_16","007_8_16","JOS","8","16","16","城內的眾民都被招聚，追趕他們；艾城人追趕的時候，就被引誘離開城。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS8_17","007_8_17","JOS","8","17","17","艾城和伯特利城沒有一人不出來追趕以色列人的，撇了敞開的城門，去追趕以色列人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS8_18","007_8_18","JOS","8","18","18","耶和華吩咐約書亞說：「你向艾城伸出手裏的短槍，因為我要將城交在你手裏。」約書亞就向城伸出手裏的短槍。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS8_19","007_8_19","JOS","8","19","19","他一伸手，伏兵就從埋伏的地方急忙起來，奪了城，跑進城去，放火焚燒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS8_20","007_8_20","JOS","8","20","20","艾城的人回頭一看，不料，城中煙氣沖天，他們就無力向左向右逃跑。那往曠野逃跑的百姓便轉身攻擊追趕他們的人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS8_21","007_8_21","JOS","8","21","21","約書亞和以色列眾人見伏兵已經奪了城，城中煙氣飛騰，就轉身回去，擊殺艾城的人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS8_22","007_8_22","JOS","8","22","22","伏兵也出城迎擊艾城人，艾城人就困在以色列人中間，前後都是以色列人。於是以色列人擊殺他們，沒有留下一個，也沒有一個逃脫的， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS8_23","007_8_23","JOS","8","23","23","生擒了艾城的王，將他解到約書亞那裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS8_24","007_8_24","JOS","8","24","24","以色列人在田間和曠野殺盡所追趕一切艾城的居民。艾城人倒在刀下，直到滅盡；以色列眾人就回到艾城，用刀殺了城中的人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS8_25","007_8_25","JOS","8","25","25","當日殺斃的人，連男帶女共有一萬二千，就是艾城所有的人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS8_26","007_8_26","JOS","8","26","26","約書亞沒有收回手裏所伸出來的短槍，直到把艾城的一切居民盡行殺滅。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS8_27","007_8_27","JOS","8","27","27","惟獨城中的牲畜和財物，以色列人都取為自己的掠物，是照耶和華所吩咐約書亞的話。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS8_28","007_8_28","JOS","8","28","28","約書亞將艾城焚燒，使城永為高堆、荒場，直到今日； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS8_29","007_8_29","JOS","8","29","29","又將艾城王掛在樹上，直到晚上。日落的時候，約書亞吩咐人把屍首從樹上取下來，丟在城門口，在屍首上堆成一大堆石頭，直存到今日。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS8_30","007_8_30","JOS","8","30","30","那時，約書亞在以巴路山上為耶和華－以色列的上帝築一座壇， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS8_31","007_8_31","JOS","8","31","31","是用沒有動過鐵器的整石頭築的，照着耶和華僕人摩西所吩咐以色列人的話，正如摩西律法書上所寫的。眾人在這壇上給耶和華奉獻燔祭和平安祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS8_32","007_8_32","JOS","8","32","32","約書亞在那裏，當着以色列人面前，將摩西所寫的律法抄寫在石頭上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS8_33","007_8_33","JOS","8","33","33","以色列眾人，無論是本地人、是寄居的，和長老、官長，並審判官，都站在約櫃兩旁，在抬耶和華約櫃的祭司利未人面前，一半對着基利心山，一半對着以巴路山，為以色列民祝福，正如耶和華僕人摩西先前所吩咐的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS8_34","007_8_34","JOS","8","34","34","隨後，約書亞將律法上祝福、咒詛的話，照着律法書上一切所寫的，都宣讀了一遍。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS8_35","007_8_35","JOS","8","35","35","摩西所吩咐的一切話，約書亞在以色列全會眾和婦女、孩子，並他們中間寄居的外人面前，沒有一句不宣讀的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS9_1","007_9_1","JOS","9","1","1","約旦河西，住山地、高原，並對着黎巴嫩山沿大海一帶的諸王，就是赫人、亞摩利人、迦南人、比利洗人、希未人、耶布斯人的諸王，聽見這事， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS9_2","007_9_2","JOS","9","2","2","就都聚集，同心合意地要與約書亞和以色列人爭戰。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS9_3","007_9_3","JOS","9","3","3","基遍的居民聽見約書亞向耶利哥和艾城所行的事， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS9_4","007_9_4","JOS","9","4","4","就設詭計，假充使者，拿舊口袋和破裂縫補的舊皮酒袋馱在驢上， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS9_5","007_9_5","JOS","9","5","5","將補過的舊鞋穿在腳上，把舊衣服穿在身上；他們所帶的餅都是乾的，長了霉了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS9_6","007_9_6","JOS","9","6","6","他們到吉甲營中見約書亞，對他和以色列人說：「我們是從遠方來的，現在求你與我們立約。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS9_7","007_9_7","JOS","9","7","7","以色列人對這些希未人說：「只怕你們是住在我們中間的；若是這樣，怎能和你們立約呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS9_8","007_9_8","JOS","9","8","8","他們對約書亞說：「我們是你的僕人。」約書亞問他們說：「你們是甚麼人？是從哪裏來的？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS9_9","007_9_9","JOS","9","9","9","他們回答說：「僕人從極遠之地而來，是因聽見耶和華－你上帝的名聲和他在埃及所行的一切事， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS9_10","007_9_10","JOS","9","10","10","並他向約旦河東的兩個亞摩利王，就是希實本王西宏和在亞斯他錄的巴珊王噩一切所行的事。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS9_11","007_9_11","JOS","9","11","11","我們的長老和我們那地的一切居民對我們說：『你們手裏要帶着路上用的食物去迎接以色列人，對他們說：我們是你們的僕人；現在求你們與我們立約。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS9_12","007_9_12","JOS","9","12","12","我們出來要往你們這裏來的日子，從家裏帶出來的這餅還是熱的；看哪，現在都乾了，長了霉了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS9_13","007_9_13","JOS","9","13","13","這皮酒袋，我們盛酒的時候還是新的；看哪，現在已經破裂。我們這衣服和鞋，因為道路甚遠，也都穿舊了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS9_14","007_9_14","JOS","9","14","14","以色列人受了他們些食物，並沒有求問耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS9_15","007_9_15","JOS","9","15","15","於是約書亞與他們講和，與他們立約，容他們活着；會眾的首領也向他們起誓。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS9_16","007_9_16","JOS","9","16","16","以色列人與他們立約之後，過了三天才聽見他們是近鄰，住在以色列人中間的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS9_17","007_9_17","JOS","9","17","17","以色列人起行，第三天到了他們的城邑，就是基遍、基非拉、比錄、基列‧耶琳。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS9_18","007_9_18","JOS","9","18","18","因為會眾的首領已經指着耶和華－以色列的上帝向他們起誓，所以以色列人不擊殺他們；全會眾就向首領發怨言。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS9_19","007_9_19","JOS","9","19","19","眾首領對全會眾說：「我們已經指着耶和華－以色列的上帝向他們起誓，現在我們不能害他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS9_20","007_9_20","JOS","9","20","20","我們要如此待他們，容他們活着，免得有忿怒因我們所起的誓臨到我們身上。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS9_21","007_9_21","JOS","9","21","21","首領又對會眾說：「要容他們活着。」於是他們為全會眾作了劈柴挑水的人，正如首領對他們所說的話。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS9_22","007_9_22","JOS","9","22","22","約書亞召了他們來，對他們說：「為甚麼欺哄我們說『我們離你們甚遠』呢？其實你們是住在我們中間。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS9_23","007_9_23","JOS","9","23","23","現在你們是被咒詛的！你們中間的人必斷不了作奴僕，為我上帝的殿作劈柴挑水的人。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS9_24","007_9_24","JOS","9","24","24","他們回答約書亞說：「因為有人實在告訴你的僕人，耶和華－你的上帝曾吩咐他的僕人摩西，把這全地賜給你們，並在你們面前滅絕這地的一切居民，所以我們為你們的緣故甚怕喪命，就行了這事。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS9_25","007_9_25","JOS","9","25","25","現在我們在你手中，你以怎樣待我們為善為正，就怎樣做吧！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS9_26","007_9_26","JOS","9","26","26","於是約書亞這樣待他們，救他們脫離以色列人的手，以色列人就沒有殺他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS9_27","007_9_27","JOS","9","27","27","當日約書亞使他們在耶和華所要選擇的地方，為會眾和耶和華的壇作劈柴挑水的人，直到今日。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS10_1","007_10_1","JOS","10","1","1","耶路撒冷王亞多尼‧洗德聽見約書亞奪了艾城，盡行毀滅，怎樣待耶利哥和耶利哥的王，也照樣待艾城和艾城的王，又聽見基遍的居民與以色列人立了和約，住在他們中間， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS10_2","007_10_2","JOS","10","2","2","就甚懼怕；因為基遍是一座大城，如都城一般，比艾城更大，並且城內的人都是勇士。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS10_3","007_10_3","JOS","10","3","3","所以耶路撒冷王亞多尼‧洗德打發人去見希伯崙王何咸、耶末王毗蘭、拉吉王雅非亞，和伊磯倫王底璧，說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS10_4","007_10_4","JOS","10","4","4","「求你們上來幫助我，我們好攻打基遍，因為他們與約書亞和以色列人立了和約。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS10_5","007_10_5","JOS","10","5","5","於是五個亞摩利王，就是耶路撒冷王、希伯崙王、耶末王、拉吉王、伊磯倫王，大家聚集，率領他們的眾軍上去，對着基遍安營，攻打基遍。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS10_6","007_10_6","JOS","10","6","6","基遍人就打發人往吉甲的營中去見約書亞，說：「你不要袖手不顧你的僕人，求你速速上來拯救我們，幫助我們，因為住山地亞摩利人的諸王都聚集攻擊我們。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS10_7","007_10_7","JOS","10","7","7","於是約書亞和他一切兵丁，並大能的勇士，都從吉甲上去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS10_8","007_10_8","JOS","10","8","8","耶和華對約書亞說：「不要怕他們；因為我已將他們交在你手裏，他們無一人能在你面前站立得住。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS10_9","007_10_9","JOS","10","9","9","約書亞就終夜從吉甲上去，猛然臨到他們那裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS10_10","007_10_10","JOS","10","10","10","耶和華使他們在以色列人面前潰亂。約書亞在基遍大大地殺敗他們，追趕他們，在伯‧和崙的上坡路擊殺他們，直到亞西加和瑪基大。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS10_11","007_10_11","JOS","10","11","11","他們在以色列人面前逃跑，正在伯‧和崙下坡的時候，耶和華從天上降大冰雹在他們身上，直降到亞西加，打死他們。被冰雹打死的，比以色列人用刀殺死的還多。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS10_12","007_10_12","JOS","10","12","12","當耶和華將亞摩利人交付以色列人的日子，約書亞就禱告耶和華，在以色列人眼前說： 日頭啊，你要停在基遍； 月亮啊，你要止在亞雅崙谷。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS10_13","007_10_13","JOS","10","13","13","於是日頭停留，月亮止住， 直等國民向敵人報仇。 這事豈不是寫在雅煞珥書上嗎？日頭在天當中停住，不急速下落，約有一日之久。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS10_14","007_10_14","JOS","10","14","14","在這日以前，這日以後，耶和華聽人的禱告，沒有像這日的，是因耶和華為以色列爭戰。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS10_15","007_10_15","JOS","10","15","15","約書亞和以色列眾人回到吉甲的營中。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS10_16","007_10_16","JOS","10","16","16","那五王逃跑，藏在瑪基大洞裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS10_17","007_10_17","JOS","10","17","17","有人告訴約書亞說：「那五王已經找到了，都藏在瑪基大洞裏。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS10_18","007_10_18","JOS","10","18","18","約書亞說：「你們把幾塊大石頭滾到洞口，派人看守， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS10_19","007_10_19","JOS","10","19","19","你們卻不可耽延，要追趕你們的仇敵，擊殺他們儘後邊的人，不容他們進自己的城邑，因為耶和華－你們的上帝已經把他們交在你們手裏。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS10_20","007_10_20","JOS","10","20","20","約書亞和以色列人大大殺敗他們，直到將他們滅盡；其中剩下的人都進了堅固的城。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS10_21","007_10_21","JOS","10","21","21","眾百姓就安然回瑪基大營中，到約書亞那裏。沒有一人敢向以色列人饒舌。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS10_22","007_10_22","JOS","10","22","22","約書亞說：「打開洞口，將那五王從洞裏帶出來，領到我面前。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS10_23","007_10_23","JOS","10","23","23","眾人就這樣行，將那五王，就是耶路撒冷王、希伯崙王、耶末王、拉吉王、伊磯倫王，從洞裏帶出來，領到約書亞面前。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS10_24","007_10_24","JOS","10","24","24","帶出那五王到約書亞面前的時候，約書亞就召了以色列眾人來，對那些和他同去的軍長說：「你們近前來，把腳踏在這些王的頸項上。」他們就近前來，把腳踏在這些王的頸項上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS10_25","007_10_25","JOS","10","25","25","約書亞對他們說：「你們不要懼怕，也不要驚惶。應當剛強壯膽，因為耶和華必這樣待你們所要攻打的一切仇敵。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS10_26","007_10_26","JOS","10","26","26","隨後約書亞將這五王殺死，掛在五棵樹上。他們就在樹上直掛到晚上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS10_27","007_10_27","JOS","10","27","27","日頭要落的時候，約書亞一吩咐，人就把屍首從樹上取下來，丟在他們藏過的洞裏，把幾塊大石頭放在洞口，直存到今日。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS10_28","007_10_28","JOS","10","28","28","當日，約書亞奪了瑪基大，用刀擊殺城中的人和王；將其中一切人口盡行殺滅，沒有留下一個。他待瑪基大王，像從前待耶利哥王一樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS10_29","007_10_29","JOS","10","29","29","約書亞和以色列眾人從瑪基大往立拿去，攻打立拿。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS10_30","007_10_30","JOS","10","30","30","耶和華將立拿和立拿的王也交在以色列人手裏。約書亞攻打這城，用刀擊殺了城中的一切人口，沒有留下一個。他待立拿王，像從前待耶利哥王一樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS10_31","007_10_31","JOS","10","31","31","約書亞和以色列眾人從立拿往拉吉去，對着拉吉安營，攻打這城。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS10_32","007_10_32","JOS","10","32","32","耶和華將拉吉交在以色列人的手裏。第二天約書亞就奪了拉吉，用刀擊殺了城中的一切人口，是照他向立拿一切所行的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS10_33","007_10_33","JOS","10","33","33","那時基色王荷蘭上來幫助拉吉，約書亞就把他和他的民都擊殺了，沒有留下一個。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS10_34","007_10_34","JOS","10","34","34","約書亞和以色列眾人從拉吉往伊磯倫去，對着伊磯倫安營，攻打這城。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS10_35","007_10_35","JOS","10","35","35","當日就奪了城，用刀擊殺了城中的人。那日，約書亞將城中的一切人口盡行殺滅，是照他向拉吉一切所行的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS10_36","007_10_36","JOS","10","36","36","約書亞和以色列眾人從伊磯倫上希伯崙去，攻打這城， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS10_37","007_10_37","JOS","10","37","37","就奪了希伯崙和屬希伯崙的諸城邑，用刀將城中的人與王，並那些城邑中的人口，都擊殺了，沒有留下一個，是照他向伊磯倫所行的，把城中的一切人口盡行殺滅。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS10_38","007_10_38","JOS","10","38","38","約書亞和以色列眾人回到底璧，攻打這城， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS10_39","007_10_39","JOS","10","39","39","就奪了底璧和屬底璧的城邑，又擒獲底璧的王，用刀將這些城中的人口盡行殺滅，沒有留下一個。他待底璧和底璧王，像從前待希伯崙和立拿與立拿王一樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS10_40","007_10_40","JOS","10","40","40","這樣，約書亞擊殺全地的人，就是山地、南地、高原、山坡的人，和那些地的諸王，沒有留下一個。將凡有氣息的盡行殺滅，正如耶和華－以色列的上帝所吩咐的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS10_41","007_10_41","JOS","10","41","41","約書亞從加低斯‧巴尼亞攻擊到迦薩，又攻擊歌珊全地，直到基遍。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS10_42","007_10_42","JOS","10","42","42","約書亞一時殺敗了這些王，並奪了他們的地，因為耶和華－以色列的上帝為以色列爭戰。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS10_43","007_10_43","JOS","10","43","43","於是約書亞和以色列眾人回到吉甲的營中。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS11_1","007_11_1","JOS","11","1","1","夏瑣王耶賓聽見這事，就打發人去見瑪頓王約巴、伸崙王、押煞王， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS11_2","007_11_2","JOS","11","2","2","與北方山地、基尼烈南邊的亞拉巴高原，並西邊多珥山岡的諸王； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS11_3","007_11_3","JOS","11","3","3","又去見東方和西方的迦南人，與山地的亞摩利人、赫人、比利洗人、耶布斯人，並黑門山根米斯巴地的希未人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS11_4","007_11_4","JOS","11","4","4","這些王和他們的眾軍都出來，人數多如海邊的沙，並有許多馬匹車輛。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS11_5","007_11_5","JOS","11","5","5","這諸王會合，來到米倫水邊，一同安營，要與以色列人爭戰。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS11_6","007_11_6","JOS","11","6","6","耶和華對約書亞說：「你不要因他們懼怕。明日這時，我必將他們交付以色列人全然殺了。你要砍斷他們馬的蹄筋，用火焚燒他們的車輛。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS11_7","007_11_7","JOS","11","7","7","於是約書亞率領一切兵丁，在米倫水邊突然向前攻打他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS11_8","007_11_8","JOS","11","8","8","耶和華將他們交在以色列人手裏，以色列人就擊殺他們，追趕他們到西頓大城，到米斯利弗‧瑪音，直到東邊米斯巴的平原，將他們擊殺，沒有留下一個。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS11_9","007_11_9","JOS","11","9","9","約書亞就照耶和華所吩咐他的去行，砍斷他們馬的蹄筋，用火焚燒他們的車輛。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS11_10","007_11_10","JOS","11","10","10","當時，約書亞轉回奪了夏瑣，用刀擊殺夏瑣王。（素來夏瑣在這諸國中是為首的。） ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS11_11","007_11_11","JOS","11","11","11","以色列人用刀擊殺城中的人口，將他們盡行殺滅；凡有氣息的沒有留下一個。約書亞又用火焚燒夏瑣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS11_12","007_11_12","JOS","11","12","12","約書亞奪了這些王的一切城邑，擒獲其中的諸王，用刀擊殺他們，將他們盡行殺滅，正如耶和華僕人摩西所吩咐的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS11_13","007_11_13","JOS","11","13","13","至於造在山岡上的城，除了夏瑣以外，以色列人都沒有焚燒。約書亞只將夏瑣焚燒了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS11_14","007_11_14","JOS","11","14","14","那些城邑所有的財物和牲畜，以色列人都取為自己的掠物；惟有一切人口都用刀擊殺，直到殺盡；凡有氣息的沒有留下一個。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS11_15","007_11_15","JOS","11","15","15","耶和華怎樣吩咐他僕人摩西，摩西就照樣吩咐約書亞，約書亞也照樣行。凡耶和華所吩咐摩西的，約書亞沒有一件懈怠不行的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS11_16","007_11_16","JOS","11","16","16","約書亞奪了那全地，就是山地、一帶南地、歌珊全地、高原、亞拉巴、以色列的山地，和山下的高原。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS11_17","007_11_17","JOS","11","17","17","從上西珥的哈拉山，直到黑門山下黎巴嫩平原的巴力‧迦得，並且擒獲那些地的諸王，將他們殺死。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS11_18","007_11_18","JOS","11","18","18","約書亞和這諸王爭戰了許多年日。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS11_19","007_11_19","JOS","11","19","19","除了基遍的希未人之外，沒有一城與以色列人講和的，都是以色列人爭戰奪來的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS11_20","007_11_20","JOS","11","20","20","因為耶和華的意思是要使他們心裏剛硬，來與以色列人爭戰，好叫他們盡被殺滅，不蒙憐憫，正如耶和華所吩咐摩西的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS11_21","007_11_21","JOS","11","21","21","當時約書亞來到，將住山地、希伯崙、底璧、亞拿伯、猶大山地、以色列山地所有的亞衲族人剪除了。約書亞將他們和他們的城邑盡都毀滅。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS11_22","007_11_22","JOS","11","22","22","在以色列人的地沒有留下一個亞衲族人，只在迦薩、迦特，和亞實突有留下的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS11_23","007_11_23","JOS","11","23","23","這樣，約書亞照着耶和華所吩咐摩西的一切話奪了那全地，就按着以色列支派的宗族將地分給他們為業。於是國中太平，沒有爭戰了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS12_1","007_12_1","JOS","12","1","1","以色列人在約旦河外向日出之地擊殺二王，得他們的地，就是從亞嫩谷直到黑門山，並東邊的全亞拉巴之地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS12_2","007_12_2","JOS","12","2","2","這二王，有住希實本、亞摩利人的王西宏。他所管之地是從亞嫩谷邊的亞羅珥和谷中的城，並基列一半，直到亞捫人的境界，雅博河 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS12_3","007_12_3","JOS","12","3","3","與約旦河東邊的亞拉巴，直到基尼烈海，又到亞拉巴的海，就是鹽海，通伯‧耶西末的路，以及南方，直到毗斯迦的山根。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS12_4","007_12_4","JOS","12","4","4","又有巴珊王噩。他是利乏音人所剩下的，住在亞斯他錄和以得來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS12_5","007_12_5","JOS","12","5","5","他所管之地是黑門山、撒迦、巴珊全地，直到基述人和瑪迦人的境界，並基列一半，直到希實本王西宏的境界。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS12_6","007_12_6","JOS","12","6","6","這二王是耶和華僕人摩西和以色列人所擊殺的；耶和華僕人摩西將他們的地賜給呂便人、迦得人，和瑪拿西半支派的人為業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS12_7","007_12_7","JOS","12","7","7","約書亞和以色列人在約旦河西擊殺了諸王。他們的地是從黎巴嫩平原的巴力‧迦得，直到上西珥的哈拉山。約書亞就將那地按着以色列支派的宗族分給他們為業， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS12_8","007_12_8","JOS","12","8","8","就是赫人、亞摩利人、迦南人、比利洗人、希未人、耶布斯人的山地、高原亞拉巴、山坡、曠野，和南地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS12_9","007_12_9","JOS","12","9","9","他們的王：一個是耶利哥王，一個是靠近伯特利的艾城王， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS12_10","007_12_10","JOS","12","10","10","一個是耶路撒冷王，一個是希伯崙王， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS12_11","007_12_11","JOS","12","11","11","一個是耶末王，一個是拉吉王， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS12_12","007_12_12","JOS","12","12","12","一個是伊磯倫王，一個是基色王， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS12_13","007_12_13","JOS","12","13","13","一個是底璧王，一個是基德王， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS12_14","007_12_14","JOS","12","14","14","一個是何珥瑪王，一個是亞拉得王， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS12_15","007_12_15","JOS","12","15","15","一個是立拿王，一個是亞杜蘭王， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS12_16","007_12_16","JOS","12","16","16","一個是瑪基大王，一個是伯特利王， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS12_17","007_12_17","JOS","12","17","17","一個是他普亞王，一個是希弗王， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS12_18","007_12_18","JOS","12","18","18","一個是亞弗王，一個是拉沙崙王， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS12_19","007_12_19","JOS","12","19","19","一個是瑪頓王，一個是夏瑣王， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS12_20","007_12_20","JOS","12","20","20","一個是伸崙‧米崙王，一個是押煞王， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS12_21","007_12_21","JOS","12","21","21","一個是他納王，一個是米吉多王， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS12_22","007_12_22","JOS","12","22","22","一個是基低斯王，一個是靠近迦密的約念王， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS12_23","007_12_23","JOS","12","23","23","一個是多珥山岡的多珥王，一個是吉甲的戈印王， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS12_24","007_12_24","JOS","12","24","24","一個是得撒王；共計三十一個王。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS13_1","007_13_1","JOS","13","1","1","約書亞年紀老邁，耶和華對他說：「你年紀老邁了，還有許多未得之地， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS13_2","007_13_2","JOS","13","2","2","就是非利士人的全境和基述人的全地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS13_3","007_13_3","JOS","13","3","3","從埃及前的西曷河往北，直到以革倫的境界，就算屬迦南人之地。有非利士人五個首領所管的迦薩人、亞實突人、亞實基倫人、迦特人、以革倫人之地，並有南方亞衛人之地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS13_4","007_13_4","JOS","13","4","4","又有迦南人的全地，並屬西頓人的米亞拉到亞弗，直到亞摩利人的境界。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS13_5","007_13_5","JOS","13","5","5","還有迦巴勒人之地，並向日出的全黎巴嫩，就是從黑門山根的巴力‧迦得，直到哈馬口。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS13_6","007_13_6","JOS","13","6","6","山地的一切居民，從黎巴嫩直到米斯利弗‧瑪音，就是所有的西頓人，我必在以色列人面前趕出他們去。你只管照我所吩咐的，將這地拈鬮分給以色列人為業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS13_7","007_13_7","JOS","13","7","7","現在你要把這地分給九個支派和瑪拿西半個支派為業。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS13_8","007_13_8","JOS","13","8","8","瑪拿西那半支派和呂便、迦得二支派已經受了產業，就是耶和華的僕人摩西在約旦河東所賜給他們的： ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS13_9","007_13_9","JOS","13","9","9","是從亞嫩谷邊的亞羅珥和谷中的城，並米底巴的全平原，直到底本， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS13_10","007_13_10","JOS","13","10","10","和在希實本作王亞摩利王西宏的諸城，直到亞捫人的境界； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS13_11","007_13_11","JOS","13","11","11","又有基列地、基述人、瑪迦人的地界，並黑門全山、巴珊全地，直到撒迦； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS13_12","007_13_12","JOS","13","12","12","又有巴珊王噩的全國－他在亞斯他錄和以得來作王（利乏音人所存留的只剩下他）。這些地的人都是摩西所擊殺、所趕逐的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS13_13","007_13_13","JOS","13","13","13","以色列人卻沒有趕逐基述人、瑪迦人；這些人仍住在以色列中，直到今日。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS13_14","007_13_14","JOS","13","14","14","只是利未支派，摩西 沒有把產業分給他們。他們的產業乃是獻與耶和華－以色列上帝的火祭，正如耶和華所應許他們的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS13_15","007_13_15","JOS","13","15","15","摩西按着呂便支派的宗族分給他們產業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS13_16","007_13_16","JOS","13","16","16","他們的境界是亞嫩谷邊的亞羅珥和谷中的城，靠近米底巴的全平原； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS13_17","007_13_17","JOS","13","17","17","希實本並屬希實本平原的各城，底本、巴末‧巴力、伯‧巴力‧勉、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS13_18","007_13_18","JOS","13","18","18","雅雜、基底莫、米法押、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS13_19","007_13_19","JOS","13","19","19","基列亭、西比瑪、谷中山的細列‧哈沙轄、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS13_20","007_13_20","JOS","13","20","20","伯‧毗珥、毗斯迦山坡、伯‧耶西末； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS13_21","007_13_21","JOS","13","21","21","平原的各城，並亞摩利王西宏的全國。這西宏曾在希實本作王，摩西把他和米甸的族長以未、利金、蘇珥、戶珥、利巴擊殺了；這都是住那地屬西宏為首領的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS13_22","007_13_22","JOS","13","22","22","那時以色列人在所殺的人中，也用刀殺了比珥的兒子術士巴蘭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS13_23","007_13_23","JOS","13","23","23","呂便人的境界就是約旦河與靠近約旦河的地。以上是呂便人按着宗族所得為業的諸城，並屬城的村莊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS13_24","007_13_24","JOS","13","24","24","摩西按着迦得支派的宗族分給他們產業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS13_25","007_13_25","JOS","13","25","25","他們的境界是雅謝和基列的各城，並亞捫人的一半地，直到拉巴前的亞羅珥； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS13_26","007_13_26","JOS","13","26","26","從希實本到拉抹‧米斯巴和比多寧，又從瑪哈念到底璧的境界， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS13_27","007_13_27","JOS","13","27","27","並谷中的伯‧亞蘭、伯‧寧拉、疏割、撒分，就是希實本王西宏國中的餘地，以及約旦河與靠近約旦河的地，直到基尼烈海的極邊，都在約旦河東。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS13_28","007_13_28","JOS","13","28","28","以上是迦得人按着宗族所得為業的諸城，並屬城的村莊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS13_29","007_13_29","JOS","13","29","29","摩西把產業分給瑪拿西半支派，是按着瑪拿西半支派的宗族所分的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS13_30","007_13_30","JOS","13","30","30","他們的境界是從瑪哈念起，包括巴珊全地，就是巴珊王噩的全國，並在巴珊、睚珥的一切城邑，共六十個。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS13_31","007_13_31","JOS","13","31","31","基列的一半，並亞斯他錄、以得來，就是屬巴珊王噩國的二城，是按着宗族給瑪拿西的兒子瑪吉的一半子孫。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS13_32","007_13_32","JOS","13","32","32","以上是摩西在約旦河東對着耶利哥的摩押平原所分給他們的產業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS13_33","007_13_33","JOS","13","33","33","只是利未支派，摩西沒有把產業分給他們。耶和華－以色列的上帝是他們的產業，正如耶和華所應許他們的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS14_1","007_14_1","JOS","14","1","1","以色列人在迦南地所得的產業，就是祭司以利亞撒和嫩的兒子約書亞，並以色列各支派的族長所分給他們的，都記在下面， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS14_2","007_14_2","JOS","14","2","2","是照耶和華藉摩西所吩咐的，把產業拈鬮分給九個半支派。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS14_3","007_14_3","JOS","14","3","3","原來，摩西在約旦河東已經把產業分給那兩個半支派，只是在他們中間沒有把產業分給利未人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS14_4","007_14_4","JOS","14","4","4","因為約瑟的子孫是兩個支派，就是瑪拿西和以法蓮，所以沒有把地分給利未人，但給他們城邑居住，並城邑的郊野，可以牧養他們的牲畜，安置他們的財物。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS14_5","007_14_5","JOS","14","5","5","耶和華怎樣吩咐摩西，以色列人就照樣行，把地分了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS14_6","007_14_6","JOS","14","6","6","那時，猶大人來到吉甲見約書亞，有基尼洗族耶孚尼的兒子迦勒對約書亞說：「耶和華在加低斯‧巴尼亞指着我與你對神人摩西所說的話，你都知道了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS14_7","007_14_7","JOS","14","7","7","耶和華的僕人摩西從加低斯‧巴尼亞打發我窺探這地，那時我正四十歲；我按着心意回報他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS14_8","007_14_8","JOS","14","8","8","然而，同我上去的眾弟兄使百姓的心消化；但我專心跟從耶和華－我的上帝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS14_9","007_14_9","JOS","14","9","9","當日摩西起誓說：『你腳所踏之地定要歸你和你的子孫永遠為業，因為你專心跟從耶和華－我的上帝。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS14_10","007_14_10","JOS","14","10","10","自從耶和華對摩西說這話的時候，耶和華照他所應許的使我存活這四十五年；其間以色列人在曠野行走。看哪，現今我八十五歲了， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS14_11","007_14_11","JOS","14","11","11","我還是強壯，像摩西打發我去的那天一樣；無論是爭戰，是出入，我的力量那時如何，現在還是如何。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS14_12","007_14_12","JOS","14","12","12","求你將耶和華那日應許我的這山地給我；那裏有亞衲族人，並寬大堅固的城，你也曾聽見了。或者耶和華照他所應許的與我同在，我就把他們趕出去。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS14_13","007_14_13","JOS","14","13","13","於是約書亞為耶孚尼的兒子迦勒祝福，將希伯崙給他為業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS14_14","007_14_14","JOS","14","14","14","所以希伯崙作了基尼洗族耶孚尼的兒子迦勒的產業，直到今日，因為他專心跟從耶和華－以色列的上帝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS14_15","007_14_15","JOS","14","15","15","希伯崙從前名叫基列‧亞巴；亞巴是亞衲族中最尊大的人。於是國中太平，沒有爭戰了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_1","007_15_1","JOS","15","1","1","猶大支派按着宗族拈鬮所得之地是在儘南邊，到以東的交界，向南直到尋的曠野。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_2","007_15_2","JOS","15","2","2","他們的南界是從鹽海的儘邊，就是從朝南的海汊起， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_3","007_15_3","JOS","15","3","3","通到亞克拉濱坡的南邊，接連到尋，上到加低斯‧巴尼亞的南邊，又過希斯崙，上到亞達珥，繞到甲加， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_4","007_15_4","JOS","15","4","4","接連到押們，通到埃及小河，直通到海為止。這就是他們的南界。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_5","007_15_5","JOS","15","5","5","東界是從鹽海南邊到約旦河口。北界是從約旦河口的海汊起， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_6","007_15_6","JOS","15","6","6","上到伯‧曷拉，過伯‧亞拉巴的北邊，上到呂便之子波罕的磐石； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_7","007_15_7","JOS","15","7","7","從亞割谷往北，上到底璧，直向河南亞都冥坡對面的吉甲；又接連到隱‧示麥泉，直通到隱‧羅結， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_8","007_15_8","JOS","15","8","8","上到欣嫩子谷，貼近耶布斯的南界（耶布斯就是耶路撒冷）；又上到欣嫩谷西邊的山頂，就是在利乏音谷極北的邊界； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_9","007_15_9","JOS","15","9","9","又從山頂延到尼弗多亞的水源，通到以弗崙山的城邑，又延到巴拉（巴拉就是基列‧耶琳）； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_10","007_15_10","JOS","15","10","10","又從巴拉往西繞到西珥山，接連到耶琳山的北邊（耶琳就是基撒崙）；又下到伯‧示麥過亭納， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_11","007_15_11","JOS","15","11","11","通到以革倫北邊，延到施基崙，接連到巴拉山；又通到雅比聶，直通到海為止。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_12","007_15_12","JOS","15","12","12","西界就是大海和靠近大海之地。這是猶大人按着宗族所得之地四圍的交界。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_13","007_15_13","JOS","15","13","13","約書亞照耶和華所吩咐的，將猶大人中的一段地，就是基列‧亞巴，分給耶孚尼的兒子迦勒。亞巴是亞衲族的始祖（基列‧亞巴就是希伯崙）。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_14","007_15_14","JOS","15","14","14","迦勒就從那裏趕出亞衲族的三個族長，就是示篩、亞希幔、撻買； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_15","007_15_15","JOS","15","15","15","又從那裏上去，攻擊底璧的居民。（這底璧從前名叫基列‧西弗。） ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_16","007_15_16","JOS","15","16","16","迦勒說：「誰能攻打基列‧西弗將城奪取，我就把我女兒押撒給他為妻。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_17","007_15_17","JOS","15","17","17","迦勒兄弟基納斯的兒子俄陀聶奪取了那城，迦勒就把女兒押撒給他為妻。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_18","007_15_18","JOS","15","18","18","押撒過門的時候，勸丈夫向她父親求一塊田，押撒一下驢，迦勒問她說：「你要甚麼？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_19","007_15_19","JOS","15","19","19","她說：「求你賜福給我，你既將我安置在南地，求你也給我水泉。」她父親就把上泉下泉賜給她。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_20","007_15_20","JOS","15","20","20","以下是猶大支派按着宗族所得的產業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_21","007_15_21","JOS","15","21","21","猶大支派儘南邊的城邑，與以東交界相近的，就是甲薛、以得、雅姑珥、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_22","007_15_22","JOS","15","22","22","基拿、底摩拿、亞大達、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_23","007_15_23","JOS","15","23","23","基低斯、夏瑣、以提楠、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_24","007_15_24","JOS","15","24","24","西弗、提鍊、比亞綠、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_25","007_15_25","JOS","15","25","25","夏瑣‧哈大他、加略‧希斯崙（加略‧希斯崙就是夏瑣）、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_26","007_15_26","JOS","15","26","26","亞曼、示瑪、摩拉大、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_27","007_15_27","JOS","15","27","27","哈薩‧迦大、黑實門、伯‧帕列、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_28","007_15_28","JOS","15","28","28","哈薩‧書亞、別是巴、比斯約他、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_29","007_15_29","JOS","15","29","29","巴拉、以因、以森、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_30","007_15_30","JOS","15","30","30","伊勒多臘、基失、何珥瑪、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_31","007_15_31","JOS","15","31","31","洗革拉、麥瑪拿、三撒拿、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_32","007_15_32","JOS","15","32","32","利巴勿、實忻、亞因、臨門，共二十九座城，還有屬城的村莊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_33","007_15_33","JOS","15","33","33","在高原有以實陶、瑣拉、亞實拿、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_34","007_15_34","JOS","15","34","34","撒挪亞、隱‧干寧、他普亞、以楠、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_35","007_15_35","JOS","15","35","35","耶末、亞杜蘭、梭哥、亞西加、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_36","007_15_36","JOS","15","36","36","沙拉音、亞底他音、基底拉、基底羅他音，共十四座城，還有屬城的村莊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_37","007_15_37","JOS","15","37","37","又有洗楠、哈大沙、麥大‧迦得、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_38","007_15_38","JOS","15","38","38","底連、米斯巴、約帖、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_39","007_15_39","JOS","15","39","39","拉吉、波斯加、伊磯倫、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_40","007_15_40","JOS","15","40","40","迦本、拉幔、基提利、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_41","007_15_41","JOS","15","41","41","基低羅、伯‧大袞、拿瑪、瑪基大，共十六座城，還有屬城的村莊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_42","007_15_42","JOS","15","42","42","又有立拿、以帖、亞珊、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_43","007_15_43","JOS","15","43","43","益弗他、亞實拿、尼悉、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_44","007_15_44","JOS","15","44","44","基伊拉、亞革悉、瑪利沙，共九座城，還有屬城的村莊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_45","007_15_45","JOS","15","45","45","又有以革倫和屬以革倫的鎮市村莊； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_46","007_15_46","JOS","15","46","46","從以革倫直到海，一切靠近亞實突之地，並屬其地的村莊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_47","007_15_47","JOS","15","47","47","亞實突和屬亞實突的鎮市村莊；迦薩和屬迦薩的鎮市村莊；直到埃及小河，並大海和靠近大海之地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_48","007_15_48","JOS","15","48","48","在山地有沙密、雅提珥、梭哥、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_49","007_15_49","JOS","15","49","49","大拿、基列‧薩拿（基列‧薩拿就是底璧）、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_50","007_15_50","JOS","15","50","50","亞拿伯、以實提莫、亞念、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_51","007_15_51","JOS","15","51","51","歌珊、何倫、基羅，共十一座城，還有屬城的村莊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_52","007_15_52","JOS","15","52","52","又有亞拉、度瑪、以珊、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_53","007_15_53","JOS","15","53","53","雅農、伯‧他普亞、亞非加、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_54","007_15_54","JOS","15","54","54","宏他、基列‧亞巴（基列‧亞巴就是希伯崙）、洗珥，共九座城，還有屬城的村莊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_55","007_15_55","JOS","15","55","55","又有瑪雲、迦密、西弗、淤他、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_56","007_15_56","JOS","15","56","56","耶斯列、約甸、撒挪亞、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_57","007_15_57","JOS","15","57","57","該隱、基比亞、亭納，共十座城，還有屬城的村莊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_58","007_15_58","JOS","15","58","58","又有哈忽、伯‧夙、基突、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_59","007_15_59","JOS","15","59","59","瑪臘、伯‧亞諾、伊勒提君，共六座城，還有屬城的村莊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_60","007_15_60","JOS","15","60","60","又有基列‧巴力（基列‧巴力就是基列‧耶琳）、拉巴，共兩座城，還有屬城的村莊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_61","007_15_61","JOS","15","61","61","在曠野有伯‧亞拉巴、密丁、西迦迦、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_62","007_15_62","JOS","15","62","62","匿珊、鹽城、隱‧基底，共六座城，還有屬城的村莊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS15_63","007_15_63","JOS","15","63","63","至於住耶路撒冷的耶布斯人，猶大人不能把他們趕出去，耶布斯人卻在耶路撒冷與猶大人同住，直到今日。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS16_1","007_16_1","JOS","16","1","1","約瑟的子孫拈鬮所得之地是從靠近耶利哥的約旦河起，以耶利哥東邊的水為界：從耶利哥上去，通過山地的曠野，到伯特利； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS16_2","007_16_2","JOS","16","2","2","又從伯特利到路斯，接連到亞基人的境界，至亞他綠； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS16_3","007_16_3","JOS","16","3","3","又往西下到押利提人的境界，到下伯‧和崙的境界，直到基色，通到海為止。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS16_4","007_16_4","JOS","16","4","4","約瑟的兒子瑪拿西、以法蓮就得了他們的地業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS16_5","007_16_5","JOS","16","5","5","以法蓮子孫的境界，按着宗族所得的，記在下面：他們地業的東界是亞他綠‧亞達到上伯‧和崙； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS16_6","007_16_6","JOS","16","6","6","往西通到北邊的密米他，又向東繞到他納‧示羅，又接連到雅挪哈的東邊； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS16_7","007_16_7","JOS","16","7","7","從雅挪哈下到亞他綠，又到拿拉，達到耶利哥，通到約旦河為止； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS16_8","007_16_8","JOS","16","8","8","從他普亞往西，到加拿河，直通到海為止。這就是以法蓮支派按着宗族所得的地業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS16_9","007_16_9","JOS","16","9","9","另外在瑪拿西人地業中得了些城邑和屬城的村莊。這都是分給以法蓮子孫的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS16_10","007_16_10","JOS","16","10","10","他們沒有趕出住基色的迦南人；迦南人卻住在以法蓮人中間，成為做苦工的僕人，直到今日。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS17_1","007_17_1","JOS","17","1","1","瑪拿西是約瑟的長子，他的支派拈鬮所得之地記在下面。至於瑪拿西的長子基列之父 瑪吉，因為是勇士就得了基列和巴珊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS17_2","007_17_2","JOS","17","2","2","瑪拿西其餘的子孫，按着宗族拈鬮分地，就是亞比以謝子孫，希勒子孫，亞斯列子孫，示劍子孫，希弗子孫，示米大子孫；這些按着宗族，都是約瑟兒子瑪拿西子孫的男丁。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS17_3","007_17_3","JOS","17","3","3","瑪拿西的玄孫，瑪吉的曾孫，基列的孫子，希弗的兒子西羅非哈沒有兒子，只有女兒。他的女兒名叫瑪拉、挪阿、曷拉、密迦、得撒； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS17_4","007_17_4","JOS","17","4","4","她們來到祭司以利亞撒和嫩的兒子約書亞並眾首領面前，說：「耶和華曾吩咐摩西在我們弟兄中分給我們產業。」於是約書亞照耶和華所吩咐的，在她們伯叔中，把產業分給她們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS17_5","007_17_5","JOS","17","5","5","除了約旦河東的基列和巴珊地之外，還有十分地歸瑪拿西， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS17_6","007_17_6","JOS","17","6","6","因為瑪拿西的孫女們在瑪拿西的孫子中得了產業。基列地是屬瑪拿西其餘的子孫。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS17_7","007_17_7","JOS","17","7","7","瑪拿西的境界：從亞設起，到示劍前的密米他，往北到隱‧他普亞居民之地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS17_8","007_17_8","JOS","17","8","8","他普亞地歸瑪拿西，只是瑪拿西境界上的他普亞城歸以法蓮子孫。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS17_9","007_17_9","JOS","17","9","9","其界下到加拿河的南邊。在瑪拿西城邑中的這些城邑都歸以法蓮。瑪拿西的地界是在河北直通到海為止； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS17_10","007_17_10","JOS","17","10","10","南歸以法蓮，北歸瑪拿西，以海為界；北邊到亞設，東邊到以薩迦。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS17_11","007_17_11","JOS","17","11","11","瑪拿西在以薩迦和亞設境內，有伯‧善和屬伯‧善的鎮市，以伯蓮和屬以伯蓮的鎮市，多珥的居民和屬多珥的鎮市；又有三處山岡，就是隱‧多珥和屬隱‧多珥的鎮市；他納的居民和屬他納的鎮市，米吉多的居民和屬米吉多的鎮市。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS17_12","007_17_12","JOS","17","12","12","只是瑪拿西子孫不能趕出這些城的居民，迦南人偏要住在那地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS17_13","007_17_13","JOS","17","13","13","及至以色列人強盛了，就使迦南人做苦工，沒有把他們全然趕出。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS17_14","007_17_14","JOS","17","14","14","約瑟的子孫對約書亞說：「耶和華到如今既然賜福與我們，我們也族大人多，你為甚麼僅將一鬮一段之地分給我們為業呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS17_15","007_17_15","JOS","17","15","15","約書亞說：「你們如果族大人多，嫌以法蓮山地窄小，就可以上比利洗人、利乏音人之地，在樹林中砍伐樹木。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS17_16","007_17_16","JOS","17","16","16","約瑟的子孫說：「那山地容不下我們，並且住平原的迦南人，就是住伯‧善和屬伯‧善的鎮市，並住耶斯列平原的人，都有鐵車。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS17_17","007_17_17","JOS","17","17","17","約書亞對約瑟家，就是以法蓮和瑪拿西人，說：「你是族大人多，並且強盛，不可僅有一鬮之地， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS17_18","007_17_18","JOS","17","18","18","山地也要歸你，雖是樹林，你也可以砍伐；靠近之地必歸你。迦南人雖有鐵車，雖是強盛，你也能把他們趕出去。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS18_1","007_18_1","JOS","18","1","1","以色列的全會眾都聚集在示羅，把會幕設立在那裏，那地已經被他們制伏了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS18_2","007_18_2","JOS","18","2","2","以色列人中其餘的七個支派還沒有分給他們地業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS18_3","007_18_3","JOS","18","3","3","約書亞對以色列人說：「耶和華－你們列祖的上帝所賜給你們的地，你們耽延不去得，要到幾時呢？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS18_4","007_18_4","JOS","18","4","4","你們每支派當選舉三個人，我要打發他們去，他們就要起身走遍那地，按着各支派應得的地業寫明，就回到我這裏來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS18_5","007_18_5","JOS","18","5","5","他們要將地分做七分；猶大仍在南方，住在他的境內。約瑟家仍在北方，住在他的境內。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS18_6","007_18_6","JOS","18","6","6","你們要將地分做七分，寫明了拿到我這裏來。我要在耶和華－我們上帝面前，為你們拈鬮。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS18_7","007_18_7","JOS","18","7","7","利未人在你們中間沒有分，因為供耶和華祭司的職任就是他們的產業。迦得支派、呂便支派，和瑪拿西半支派已經在約旦河東得了地業，就是耶和華僕人摩西所給他們的。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS18_8","007_18_8","JOS","18","8","8","劃地勢的人起身去的時候，約書亞囑咐他們說：「你們去走遍那地，劃明地勢，就回到我這裏來。我要在示羅這裏，耶和華面前，為你們拈鬮。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS18_9","007_18_9","JOS","18","9","9","他們就去了，走遍那地，按着城邑分做七分，寫在冊子上，回到示羅營中見約書亞。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS18_10","007_18_10","JOS","18","10","10","約書亞就在示羅，耶和華面前，為他們拈鬮。約書亞在那裏，按着以色列人的支派，將地分給他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS18_11","007_18_11","JOS","18","11","11","便雅憫支派，按着宗族拈鬮所得之地，是在猶大、約瑟子孫中間。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS18_12","007_18_12","JOS","18","12","12","他們的北界是從約旦河起，往上貼近耶利哥的北邊；又往西通過山地，直到伯‧亞文的曠野； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS18_13","007_18_13","JOS","18","13","13","從那裏往南接連到路斯，貼近路斯（路斯就是伯特利），又下到亞他綠‧亞達，靠近下伯‧和崙南邊的山； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS18_14","007_18_14","JOS","18","14","14","從那裏往西，又轉向南，從伯‧和崙南對面的山，直達到猶大人的城基列‧巴力（基列‧巴力就是基列‧耶琳）；這是西界。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS18_15","007_18_15","JOS","18","15","15","南界是從基列‧耶琳的儘邊起，往西達到尼弗多亞的水源； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS18_16","007_18_16","JOS","18","16","16","又下到欣嫩子谷對面山的儘邊，就是利乏音谷北邊的山；又下到欣嫩谷，貼近耶布斯的南邊；又下到隱‧羅結； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS18_17","007_18_17","JOS","18","17","17","又往北通到隱‧示麥，達到亞都冥坡對面的基利綠；又下到呂便之子波罕的磐石； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS18_18","007_18_18","JOS","18","18","18","又接連到亞拉巴對面，往北下到亞拉巴； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS18_19","007_18_19","JOS","18","19","19","又接連到伯‧曷拉的北邊，直通到鹽海的北汊，就是約旦河的南頭；這是南界。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS18_20","007_18_20","JOS","18","20","20","東界是約旦河。這是便雅憫人按着宗族，照他們四圍的交界所得的地業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS18_21","007_18_21","JOS","18","21","21","便雅憫支派按着宗族所得的城邑就是：耶利哥、伯‧曷拉、伊麥‧基悉、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS18_22","007_18_22","JOS","18","22","22","伯‧亞拉巴、洗瑪臉、伯特利、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS18_23","007_18_23","JOS","18","23","23","亞文、巴拉、俄弗拉、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS18_24","007_18_24","JOS","18","24","24","基法‧阿摩尼、俄弗尼、迦巴，共十二座城，還有屬城的村莊； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS18_25","007_18_25","JOS","18","25","25","又有基遍、拉瑪、比錄、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS18_26","007_18_26","JOS","18","26","26","米斯巴、基非拉、摩撒、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS18_27","007_18_27","JOS","18","27","27","利堅、伊利毗勒、他拉拉、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS18_28","007_18_28","JOS","18","28","28","洗拉、以利弗、耶布斯（耶布斯就是耶路撒冷）、基比亞、基列，共十四座城，還有屬城的村莊。這是便雅憫人按着宗族所得的地業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS19_1","007_19_1","JOS","19","1","1","為西緬支派的人，按着宗族，拈出第二鬮。他們所得的地業是在猶大人地業中間。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS19_2","007_19_2","JOS","19","2","2","他們所得為業之地就是：別是巴（或名示巴）、摩拉大、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS19_3","007_19_3","JOS","19","3","3","哈薩‧書亞、巴拉、以森、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS19_4","007_19_4","JOS","19","4","4","伊利多拉、比土力、何珥瑪、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS19_5","007_19_5","JOS","19","5","5","洗革拉、伯‧瑪加博、哈薩‧蘇撒、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS19_6","007_19_6","JOS","19","6","6","伯‧利巴勿、沙魯險，共十三座城，還有屬城的村莊； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS19_7","007_19_7","JOS","19","7","7","又有亞因、利門、以帖、亞珊，共四座城，還有屬城的村莊； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS19_8","007_19_8","JOS","19","8","8","並有這些城邑四圍一切的村莊，直到巴拉‧比珥，就是南地的拉瑪。這是西緬支派按着宗族所得的地業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS19_9","007_19_9","JOS","19","9","9","西緬人的地業是從猶大人地業中得來的；因為猶大人的分過多，所以西緬人在他們的地業中得了地業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS19_10","007_19_10","JOS","19","10","10","為西布倫人，按着宗族，拈出第三鬮。他們地業的境界是到撒立； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS19_11","007_19_11","JOS","19","11","11","往西上到瑪拉拉，達到大巴設，又達到約念前的河； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS19_12","007_19_12","JOS","19","12","12","又從撒立往東轉向日出之地，到吉斯綠‧他泊的境界，又通到大比拉，上到雅非亞； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS19_13","007_19_13","JOS","19","13","13","從那裏往東，接連到迦特‧希弗，至以特‧加汛，通到臨門，臨門延到尼亞； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS19_14","007_19_14","JOS","19","14","14","又繞過尼亞的北邊，轉到哈拿頓，通到伊弗他‧伊勒谷。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS19_15","007_19_15","JOS","19","15","15","還有加他、拿哈拉、伸崙、以大拉、伯利恆，共十二座城，還有屬城的村莊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS19_16","007_19_16","JOS","19","16","16","這些城並屬城的村莊就是西布倫人按着宗族所得的地業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS19_17","007_19_17","JOS","19","17","17","為以薩迦人，按着宗族，拈出第四鬮。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS19_18","007_19_18","JOS","19","18","18","他們的境界是到耶斯列、基蘇律、書念、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS19_19","007_19_19","JOS","19","19","19","哈弗連、示按、亞拿哈拉、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS19_20","007_19_20","JOS","19","20","20","拉璧、基善、亞別、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS19_21","007_19_21","JOS","19","21","21","利篾、隱‧干寧、隱‧哈大、伯‧帕薛； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS19_22","007_19_22","JOS","19","22","22","又達到他泊、沙哈洗瑪、伯‧示麥，直通到約旦河為止，共十六座城，還有屬城的村莊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS19_23","007_19_23","JOS","19","23","23","這些城並屬城的村莊就是以薩迦支派按着宗族所得的地業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS19_24","007_19_24","JOS","19","24","24","為亞設支派，按着宗族，拈出第五鬮。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS19_25","007_19_25","JOS","19","25","25","他們的境界是黑甲、哈利、比田、押煞、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS19_26","007_19_26","JOS","19","26","26","亞拉米勒、亞末、米沙勒；往西達到迦密，又到希曷‧立納， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS19_27","007_19_27","JOS","19","27","27","轉向日出之地，到伯‧大袞，達到細步綸；往北到伊弗他‧伊勒谷，到伯‧以墨和尼業，也通到迦步勒的左邊； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS19_28","007_19_28","JOS","19","28","28","又到義伯崙、利合、哈們、加拿，直到西頓大城； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS19_29","007_19_29","JOS","19","29","29","轉到拉瑪和堅固城泰爾；又轉到何薩，靠近亞革悉一帶地方，直通到海； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS19_30","007_19_30","JOS","19","30","30","又有烏瑪、亞弗、利合，共二十二座城，還有屬城的村莊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS19_31","007_19_31","JOS","19","31","31","這些城並屬城的村莊就是亞設支派按着宗族所得的地業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS19_32","007_19_32","JOS","19","32","32","為拿弗他利人，按着宗族，拈出第六鬮。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS19_33","007_19_33","JOS","19","33","33","他們的境界是從希利弗從撒拿音的橡樹，從亞大米‧尼吉和雅比聶，直到拉共，通到約旦河； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS19_34","007_19_34","JOS","19","34","34","又轉向西到亞斯納‧他泊，從那裏通到戶割，南邊到西布倫，西邊到亞設，又向日出之地，達到約旦河那裏的猶大。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS19_35","007_19_35","JOS","19","35","35","堅固的城就是：西丁、側耳、哈末、拉甲、基尼烈、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS19_36","007_19_36","JOS","19","36","36","亞大瑪、拉瑪、夏瑣、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS19_37","007_19_37","JOS","19","37","37","基低斯、以得來、隱‧夏瑣、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS19_38","007_19_38","JOS","19","38","38","以利穩、密大‧伊勒、和璉、伯‧亞納、伯‧示麥，共十九座城，還有屬城的村莊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS19_39","007_19_39","JOS","19","39","39","這些城並屬城的村莊就是拿弗他利支派按着宗族所得的地業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS19_40","007_19_40","JOS","19","40","40","為但支派，按着宗族，拈出第七鬮。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS19_41","007_19_41","JOS","19","41","41","他們地業的境界是瑣拉、以實陶、伊珥‧示麥、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS19_42","007_19_42","JOS","19","42","42","沙拉賓、亞雅崙、伊提拉、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS19_43","007_19_43","JOS","19","43","43","以倫、亭拿他、以革倫、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS19_44","007_19_44","JOS","19","44","44","伊利提基、基比頓、巴拉、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS19_45","007_19_45","JOS","19","45","45","伊胡得、比尼‧比拉、迦特‧臨門、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS19_46","007_19_46","JOS","19","46","46","美‧耶昆、拉昆，並約帕對面的地界。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS19_47","007_19_47","JOS","19","47","47","但人的地界越過原得的地界；因為但人上去攻取利善，用刀擊殺城中的人，得了那城，住在其中，以他們先祖但的名將利善改名為但。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS19_48","007_19_48","JOS","19","48","48","這些城並屬城的村莊就是但支派按着宗族所得的地業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS19_49","007_19_49","JOS","19","49","49","以色列人按着境界分完了地業，就在他們中間將地給嫩的兒子約書亞為業， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS19_50","007_19_50","JOS","19","50","50","是照耶和華的吩咐，將約書亞所求的城，就是以法蓮山地的亭拿‧西拉城，給了他。他就修那城，住在其中。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS19_51","007_19_51","JOS","19","51","51","這就是祭司以利亞撒和嫩的兒子約書亞，並以色列各支派的族長，在示羅會幕門口，耶和華面前，拈鬮所分的地業。這樣，他們把地分完了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS20_1","007_20_1","JOS","20","1","1","耶和華曉諭約書亞說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS20_2","007_20_2","JOS","20","2","2","「你吩咐以色列人說：你們要照着我藉摩西所曉諭你們的，為自己設立逃城， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS20_3","007_20_3","JOS","20","3","3","使那無心而誤殺人的，可以逃到那裏。這些城可以作你們逃避報血仇人的地方。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS20_4","007_20_4","JOS","20","4","4","那殺人的要逃到這些城中的一座城，站在城門口，將他的事情說給城內的長老們聽。他們就把他收進城裏，給他地方，使他住在他們中間。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS20_5","007_20_5","JOS","20","5","5","若是報血仇的追了他來，長老不可將他交在報血仇的手裏；因為他是素無仇恨，無心殺了人的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS20_6","007_20_6","JOS","20","6","6","他要住在那城裏，站在會眾面前聽審判，等到那時的大祭司死了，殺人的才可以回到本城本家，就是他所逃出來的那城。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS20_7","007_20_7","JOS","20","7","7","於是，以色列人在拿弗他利山地分定加利利的基低斯；在以法蓮山地分定示劍；在猶大山地分定基列‧亞巴（基列‧亞巴就是希伯崙）； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS20_8","007_20_8","JOS","20","8","8","又在約旦河外耶利哥東，從呂便支派中，在曠野的平原，設立比悉；從迦得支派中設立基列的拉末；從瑪拿西支派中設立巴珊的哥蘭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS20_9","007_20_9","JOS","20","9","9","這都是為以色列眾人和在他們中間寄居的外人所分定的城邑，使誤殺人的都可以逃到那裏，不死在報血仇人的手中，等他站在會眾面前聽審判。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS21_1","007_21_1","JOS","21","1","1","那時，利未人的眾族長來到祭司以利亞撒和嫩的兒子約書亞，並以色列各支派的族長面前， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS21_2","007_21_2","JOS","21","2","2","在迦南地的示羅對他們說：「從前耶和華藉着摩西吩咐給我們城邑居住，並城邑的郊野可以牧養我們的牲畜。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS21_3","007_21_3","JOS","21","3","3","於是以色列人照耶和華所吩咐的，從自己的地業中，將以下所記的城邑和城邑的郊野給了利未人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS21_4","007_21_4","JOS","21","4","4","為哥轄族拈鬮：利未人的祭司、亞倫的子孫，從猶大支派、西緬支派、便雅憫支派的地業中，按鬮得了十三座城。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS21_5","007_21_5","JOS","21","5","5","哥轄其餘的子孫，從以法蓮支派、但支派、瑪拿西半支派的地業中，按鬮得了十座城。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS21_6","007_21_6","JOS","21","6","6","革順的子孫，從以薩迦支派、亞設支派、拿弗他利支派、住巴珊的瑪拿西半支派的地業中，按鬮得了十三座城。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS21_7","007_21_7","JOS","21","7","7","米拉利的子孫，按着宗族，從呂便支派、迦得支派、西布倫支派的地業中，按鬮得了十二座城。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS21_8","007_21_8","JOS","21","8","8","以色列人照着耶和華藉摩西所吩咐的，將這些城邑和城邑的郊野，按鬮分給利未人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS21_9","007_21_9","JOS","21","9","10","從猶大支派、西緬支派的地業中，將以下所記的城給了利未支派哥轄宗族亞倫的子孫；因為給他們拈出頭一鬮， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS21_11","007_21_11","JOS","21","11","11","將猶大山地的基列‧亞巴和四圍的郊野給了他們。亞巴是亞衲族的始祖。（基列‧亞巴就是希伯崙）。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS21_12","007_21_12","JOS","21","12","12","惟將屬城的田地和村莊給了耶孚尼的兒子迦勒為業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS21_13","007_21_13","JOS","21","13","13","以色列人將希伯崙，就是誤殺人的逃城和屬城的郊野，給了祭司亞倫的子孫；又給他們立拿和屬城的郊野， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS21_14","007_21_14","JOS","21","14","14","雅提珥和屬城的郊野，以實提莫和屬城的郊野， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS21_15","007_21_15","JOS","21","15","15","何崙和屬城的郊野，底璧和屬城的郊野， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS21_16","007_21_16","JOS","21","16","16","亞因和屬城的郊野，淤他和屬城的郊野，伯‧示麥和屬城的郊野，共九座城，都是從這二支派中分出來的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS21_17","007_21_17","JOS","21","17","17","又從便雅憫支派的地業中給了他們基遍和屬城的郊野，迦巴和屬城的郊野， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS21_18","007_21_18","JOS","21","18","18","亞拿突和屬城的郊野，亞勒們和屬城的郊野，共四座城。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS21_19","007_21_19","JOS","21","19","19","亞倫子孫作祭司的共有十三座城，還有屬城的郊野。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS21_20","007_21_20","JOS","21","20","20","利未支派中哥轄的宗族，就是哥轄其餘的子孫，拈鬮所得的城有從以法蓮支派中分出來的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS21_21","007_21_21","JOS","21","21","21","以色列人將以法蓮山地的示劍，就是誤殺人的逃城和屬城的郊野，給了他們；又給他們基色和屬城的郊野， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS21_22","007_21_22","JOS","21","22","22","基伯先和屬城的郊野，伯‧和崙和屬城的郊野，共四座城； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS21_23","007_21_23","JOS","21","23","23","又從但支派的地業中給了他們伊利提基和屬城的郊野，基比頓和屬城的郊野， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS21_24","007_21_24","JOS","21","24","24","亞雅崙和屬城的郊野，迦特‧臨門和屬城的郊野，共四座城； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS21_25","007_21_25","JOS","21","25","25","又從瑪拿西半支派的地業中給了他們他納和屬城的郊野，迦特‧臨門和屬城的郊野，共兩座城。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS21_26","007_21_26","JOS","21","26","26","哥轄其餘的子孫共有十座城，還有屬城的郊野。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS21_27","007_21_27","JOS","21","27","27","以色列人又從瑪拿西半支派的地業中將巴珊的哥蘭，就是誤殺人的逃城和屬城的郊野，給了利未支派革順的子孫；又給他們比‧施提拉和屬城的郊野，共兩座城； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS21_28","007_21_28","JOS","21","28","28","又從以薩迦支派的地業中給了他們基善和屬城的郊野，大比拉和屬城的郊野， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS21_29","007_21_29","JOS","21","29","29","耶末和屬城的郊野，隱‧干寧和屬城的郊野，共四座城； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS21_30","007_21_30","JOS","21","30","30","又從亞設支派的地業中給了他們米沙勒和屬城的郊野，押頓和屬城的郊野， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS21_31","007_21_31","JOS","21","31","31","黑甲和屬城的郊野，利合和屬城的郊野，共四座城； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS21_32","007_21_32","JOS","21","32","32","又從拿弗他利支派的地業中將加利利的基低斯，就是誤殺人的逃城和屬城的郊野，給了他們；又給他們哈末‧多珥和屬城的郊野，加珥坦和屬城的郊野，共三座城。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS21_33","007_21_33","JOS","21","33","33","革順人按着宗族所得的城，共十三座，還有屬城的郊野。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS21_34","007_21_34","JOS","21","34","34","其餘利未支派米拉利子孫，從西布倫支派的地業中所得的，就是約念和屬城的郊野，加珥他和屬城的郊野， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS21_35","007_21_35","JOS","21","35","35","丁拿和屬城的郊野，拿哈拉和屬城的郊野，共四座城； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS21_36","007_21_36","JOS","21","36","36","又從呂便支派的地業中給了他們比悉和屬城的郊野，雅雜和屬城的郊野， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS21_37","007_21_37","JOS","21","37","37","基底莫和屬城的郊野，米法押和屬城的郊野，共四座城； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS21_38","007_21_38","JOS","21","38","38","又從迦得支派的地業中，將基列的拉末，就是誤殺人的逃城和屬城的郊野，給了他們；又給他們瑪哈念和屬城的郊野， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS21_39","007_21_39","JOS","21","39","39","希實本和屬城的郊野，雅謝和屬城的郊野，共四座城。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS21_40","007_21_40","JOS","21","40","40","其餘利未支派的人，就是米拉利的子孫，按着宗族拈鬮所得的，共十二座城。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS21_41","007_21_41","JOS","21","41","41","利未人在以色列人的地業中所得的城，共四十八座，並有屬城的郊野。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS21_42","007_21_42","JOS","21","42","42","這些城四圍都有屬城的郊野，城城都是如此。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS21_43","007_21_43","JOS","21","43","43","這樣，耶和華將從前向他們列祖起誓所應許的全地賜給以色列人，他們就得了為業，住在其中。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS21_44","007_21_44","JOS","21","44","44","耶和華照着向他們列祖起誓所應許的一切話，使他們四境平安；他們一切仇敵中，沒有一人在他們面前站立得住。耶和華把一切仇敵都交在他們手中。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS21_45","007_21_45","JOS","21","45","45","耶和華應許賜福給以色列家的話一句也沒有落空，都應驗了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS22_1","007_22_1","JOS","22","1","1","當時，約書亞召了呂便人、迦得人，和瑪拿西半支派的人來， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS22_2","007_22_2","JOS","22","2","2","對他們說：「耶和華僕人摩西所吩咐你們的，你們都遵守了；我所吩咐你們的，你們也都聽從了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS22_3","007_22_3","JOS","22","3","3","你們這許多日子，總沒有撇離你們的弟兄，直到今日，並守了耶和華－你們上帝所吩咐你們當守的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS22_4","007_22_4","JOS","22","4","4","如今耶和華－你們上帝照着他所應許的，使你們弟兄得享平安，現在可以轉回你們的帳棚，到耶和華的僕人摩西在約旦河東所賜你們為業之地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS22_5","007_22_5","JOS","22","5","5","只要切切地謹慎遵行耶和華僕人摩西所吩咐你們的誡命律法，愛耶和華－你們的上帝，行他一切的道，守他的誡命，專靠他，盡心盡性事奉他。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS22_6","007_22_6","JOS","22","6","6","於是約書亞為他們祝福，打發他們去，他們就回自己的帳棚去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS22_7","007_22_7","JOS","22","7","7","瑪拿西那半支派，摩西早已在巴珊分給他們地業。這半支派，約書亞在約旦河西，在他們弟兄中，分給他們地業。約書亞打發他們回帳棚的時候為他們祝福， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS22_8","007_22_8","JOS","22","8","8","對他們說：「你們帶許多財物，許多牲畜和金、銀、銅、鐵，並許多衣服，回你們的帳棚去，要將你們從仇敵奪來的物，與你們眾弟兄同分。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS22_9","007_22_9","JOS","22","9","9","於是呂便人、迦得人、瑪拿西半支派的人從迦南地的示羅起行，離開以色列人，回往他們得為業的基列地，就是照耶和華藉摩西所吩咐的得了為業之地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS22_10","007_22_10","JOS","22","10","10","呂便人、迦得人，和瑪拿西半支派的人到了靠近約旦河的一帶迦南地，就在約旦河那裏築了一座壇；那壇看着高大。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS22_11","007_22_11","JOS","22","11","11","以色列人聽說呂便人、迦得人、瑪拿西半支派的人靠近約旦河邊，在迦南地屬以色列人的那邊築了一座壇。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS22_12","007_22_12","JOS","22","12","12","全會眾一聽見，就聚集在示羅，要上去攻打他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS22_13","007_22_13","JOS","22","13","13","以色列人打發祭司以利亞撒的兒子非尼哈，往基列地去見呂便人、迦得人、瑪拿西半支派的人； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS22_14","007_22_14","JOS","22","14","14","又打發十個首領與非尼哈同去，就是以色列每支派的一個首領，都是以色列軍中的統領。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS22_15","007_22_15","JOS","22","15","15","他們到了基列地，見呂便人、迦得人，和瑪拿西半支派的人，對他們說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS22_16","007_22_16","JOS","22","16","16","「耶和華全會眾這樣說，你們今日轉去不跟從耶和華，干犯以色列的上帝，為自己築一座壇，悖逆了耶和華，這犯的是甚麼罪呢？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS22_17","007_22_17","JOS","22","17","17","從前拜毗珥的罪孽還算小嗎？雖然瘟疫臨到耶和華的會眾，到今日我們還沒有洗淨這罪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS22_18","007_22_18","JOS","22","18","18","你們今日竟轉去不跟從耶和華嗎？你們今日既悖逆耶和華，明日他必向以色列全會眾發怒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS22_19","007_22_19","JOS","22","19","19","你們所得為業之地，若嫌不潔淨，就可以過到耶和華之地，就是耶和華的帳幕所住之地，在我們中間得地業。只是不可悖逆耶和華，也不可得罪我們，在耶和華－我們上帝的壇以外為自己築壇。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS22_20","007_22_20","JOS","22","20","20","從前謝拉的曾孫亞干豈不是在那當滅的物上犯了罪，就有忿怒臨到以色列全會眾嗎？那人在所犯的罪中不獨一人死亡。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS22_21","007_22_21","JOS","22","21","21","於是呂便人、迦得人、瑪拿西半支派的人回答以色列軍中的統領說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS22_22","007_22_22","JOS","22","22","22","「大能者上帝耶和華！大能者上帝耶和華！他是知道的！以色列人也必知道！我們若有悖逆的意思，或是干犯耶和華（願你今日不保佑我們）， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS22_23","007_22_23","JOS","22","23","23","為自己築壇，要轉去不跟從耶和華，或是要將燔祭、素祭、平安祭獻在壇上，願耶和華親自討我們的罪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS22_24","007_22_24","JOS","22","24","24","我們行這事並非無故，是特意做的，說：恐怕日後你們的子孫對我們的子孫說：『你們與耶和華－以色列的上帝有何關涉呢？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS22_25","007_22_25","JOS","22","25","25","因為耶和華把約旦河定為我們和你們這呂便人、迦得人的交界，你們與耶和華無分了。』這樣，你們的子孫就使我們的子孫不再敬畏耶和華了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS22_26","007_22_26","JOS","22","26","26","因此我們說：『不如為自己築一座壇，不是為獻燔祭，也不是為獻別的祭， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS22_27","007_22_27","JOS","22","27","27","乃是為你我中間和你我後人中間作證據，好叫我們也在耶和華面前獻燔祭、平安祭，和別的祭事奉他，免得你們的子孫日後對我們的子孫說，你們與耶和華無分了。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS22_28","007_22_28","JOS","22","28","28","所以我們說：『日後你們對我們，或對我們的後人這樣說，我們就可以回答說，你們看我們列祖所築的壇是耶和華壇的樣式；這並不是為獻燔祭，也不是為獻別的祭，乃是為作你我中間的證據。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS22_29","007_22_29","JOS","22","29","29","我們在耶和華－我們上帝帳幕前的壇以外，另築一座壇，為獻燔祭、素祭，和別的祭，悖逆耶和華，今日轉去不跟從他，我們斷沒有這個意思。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS22_30","007_22_30","JOS","22","30","30","祭司非尼哈與會中的首領，就是與他同來以色列軍中的統領，聽見呂便人、迦得人、瑪拿西人所說的話，就都以為美。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS22_31","007_22_31","JOS","22","31","31","祭司以利亞撒的兒子非尼哈對呂便人、迦得人、瑪拿西人說：「今日我們知道耶和華在我們中間，因為你們沒有向他犯了這罪。現在你們救以色列人脫離耶和華的手了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS22_32","007_22_32","JOS","22","32","32","祭司以利亞撒的兒子非尼哈與眾首領離了呂便人、迦得人，從基列地回往迦南地，到了以色列人那裏，便將這事回報他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS22_33","007_22_33","JOS","22","33","33","以色列人以這事為美，就稱頌上帝，不再提上去攻打呂便人、迦得人、毀壞他們所住的地了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS22_34","007_22_34","JOS","22","34","34","呂便人、迦得人給壇起名叫證壇，意思說：這壇在我們中間證明耶和華是上帝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS23_1","007_23_1","JOS","23","1","1","耶和華使以色列人安靜，不與四圍的一切仇敵爭戰，已經多日。約書亞年紀老邁， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS23_2","007_23_2","JOS","23","2","2","就把以色列眾人的長老、族長、審判官，並官長都召了來，對他們說：「我年紀已經老邁。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS23_3","007_23_3","JOS","23","3","3","耶和華－你們的上帝因你們的緣故向那些國所行的一切事，你們親眼看見了，因那為你們爭戰的是耶和華－你們的上帝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS23_4","007_23_4","JOS","23","4","4","我所剪除和所剩下的各國，從約旦河起到日落之處的大海，我已經拈鬮分給你們各支派為業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS23_5","007_23_5","JOS","23","5","5","耶和華－你們的上帝必將他們從你們面前趕出去，使他們離開你們，你們就必得他們的地為業，正如耶和華－你們的上帝所應許的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS23_6","007_23_6","JOS","23","6","6","所以，你們要大大壯膽，謹守遵行寫在摩西律法書上的一切話，不可偏離左右。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS23_7","007_23_7","JOS","23","7","7","不可與你們中間所剩下的這些國民攙雜。他們的神，你們不可提他的名，不可指着他起誓，也不可事奉、叩拜； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS23_8","007_23_8","JOS","23","8","8","只要照着你們到今日所行的，專靠耶和華－你們的上帝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS23_9","007_23_9","JOS","23","9","9","因為耶和華已經把又大又強的國民從你們面前趕出；直到今日，沒有一人在你們面前站立得住。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS23_10","007_23_10","JOS","23","10","10","你們一人必追趕千人，因耶和華－你們的上帝照他所應許的，為你們爭戰。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS23_11","007_23_11","JOS","23","11","11","你們要分外謹慎，愛耶和華－你們的上帝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS23_12","007_23_12","JOS","23","12","12","你們若稍微轉去，與你們中間所剩下的這些國民聯絡，彼此結親，互相往來， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS23_13","007_23_13","JOS","23","13","13","你們要確實知道，耶和華－你們的上帝必不再將他們從你們眼前趕出；他們卻要成為你們的網羅、機檻、肋上的鞭、眼中的刺，直到你們在耶和華－你們上帝所賜的這美地上滅亡。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS23_14","007_23_14","JOS","23","14","14","「我現在要走世人必走的路。你們是一心一意地知道，耶和華－你們上帝所應許賜福與你們的話沒有一句落空，都應驗在你們身上了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS23_15","007_23_15","JOS","23","15","15","耶和華－你們上帝所應許的一切福氣怎樣臨到你們身上，耶和華也必照樣使各樣禍患臨到你們身上，直到把你們從耶和華－你們上帝所賜的這美地上除滅。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS23_16","007_23_16","JOS","23","16","16","你們若違背耶和華－你們上帝吩咐你們所守的約，去事奉別神，叩拜他，耶和華的怒氣必向你們發作，使你們在他所賜的美地上速速滅亡。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS24_1","007_24_1","JOS","24","1","1","約書亞將以色列的眾支派聚集在示劍，召了以色列的長老、族長、審判官，並官長來，他們就站在上帝面前。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS24_2","007_24_2","JOS","24","2","2","約書亞對眾民說：「耶和華－以色列的上帝如此說：『古時你們的列祖，就是亞伯拉罕和拿鶴的父親他拉，住在大河那邊事奉別神， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS24_3","007_24_3","JOS","24","3","3","我將你們的祖宗亞伯拉罕從大河那邊帶來，領他走遍迦南全地，又使他的子孫眾多，把以撒賜給他； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS24_4","007_24_4","JOS","24","4","4","又把雅各和以掃賜給以撒，將西珥山賜給以掃為業；後來雅各和他的子孫下到埃及去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS24_5","007_24_5","JOS","24","5","5","我差遣摩西、亞倫，並照我在埃及中所行的降災與埃及，然後把你們領出來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS24_6","007_24_6","JOS","24","6","6","我領你們列祖出埃及，他們就到了紅海；埃及人帶領車輛馬兵追趕你們列祖到紅海。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS24_7","007_24_7","JOS","24","7","7","你們列祖哀求耶和華，他就使你們和埃及人中間黑暗了，又使海水淹沒埃及人。我在埃及所行的事，你們親眼見過。你們在曠野也住了許多年日。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS24_8","007_24_8","JOS","24","8","8","我領你們到約旦河東亞摩利人所住之地。他們與你們爭戰，我將他們交在你們手中，你們便得了他們的地為業；我也在你們面前將他們滅絕。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS24_9","007_24_9","JOS","24","9","9","那時，摩押王西撥的兒子巴勒起來攻擊以色列人，打發人召了比珥的兒子巴蘭來咒詛你們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS24_10","007_24_10","JOS","24","10","10","我不肯聽巴蘭的話，所以他倒為你們連連祝福。這樣，我便救你們脫離巴勒的手。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS24_11","007_24_11","JOS","24","11","11","你們過了約旦河，到了耶利哥；耶利哥人、亞摩利人、比利洗人、迦南人、赫人、革迦撒人、希未人、耶布斯人都與你們爭戰；我把他們交在你們手裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS24_12","007_24_12","JOS","24","12","12","我打發黃蜂飛在你們前面，將亞摩利人的二王從你們面前攆出，並不是用你的刀，也不是用你的弓。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS24_13","007_24_13","JOS","24","13","13","我賜給你們地土，非你們所修治的；我賜給你們城邑，非你們所建造的。你們就住在其中，又得吃非你們所栽種的葡萄園、橄欖園的果子。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS24_14","007_24_14","JOS","24","14","14","「現在你們要敬畏耶和華，誠心實意地事奉他，將你們列祖在大河那邊和在埃及所事奉的神除掉，去事奉耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS24_15","007_24_15","JOS","24","15","15","若是你們以事奉耶和華為不好，今日就可以選擇所要事奉的：是你們列祖在大河那邊所事奉的神呢？是你們所住這地的亞摩利人的神呢？至於我和我家，我們必定事奉耶和華。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS24_16","007_24_16","JOS","24","16","16","百姓回答說：「我們斷不敢離棄耶和華去事奉別神； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS24_17","007_24_17","JOS","24","17","17","因耶和華－我們的上帝曾將我們和我們列祖從埃及地的為奴之家領出來，在我們眼前行了那些大神蹟，在我們所行的道上，所經過的諸國，都保護了我們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS24_18","007_24_18","JOS","24","18","18","耶和華又把住此地的亞摩利人都從我們面前趕出去。所以，我們必事奉耶和華，因為他是我們的上帝。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS24_19","007_24_19","JOS","24","19","19","約書亞對百姓說：「你們不能事奉耶和華；因為他是聖潔的上帝，是忌邪的上帝，必不赦免你們的過犯罪惡。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS24_20","007_24_20","JOS","24","20","20","你們若離棄耶和華去事奉外邦神，耶和華在降福之後，必轉而降禍與你們，把你們滅絕。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS24_21","007_24_21","JOS","24","21","21","百姓回答約書亞說：「不然，我們定要事奉耶和華。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS24_22","007_24_22","JOS","24","22","22","約書亞對百姓說：「你們選定耶和華，要事奉他，你們自己作見證吧！」他們說：「我們願意作見證。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS24_23","007_24_23","JOS","24","23","23","約書亞說：「你們現在要除掉你們中間的外邦神，專心歸向耶和華－以色列的上帝。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS24_24","007_24_24","JOS","24","24","24","百姓回答約書亞說：「我們必事奉耶和華－我們的上帝，聽從他的話。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS24_25","007_24_25","JOS","24","25","25","當日，約書亞就與百姓立約，在示劍為他們立定律例典章。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS24_26","007_24_26","JOS","24","26","26","約書亞將這些話都寫在上帝的律法書上，又將一塊大石頭立在橡樹下耶和華的聖所旁邊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS24_27","007_24_27","JOS","24","27","27","約書亞對百姓說：「看哪，這石頭可以向我們作見證；因為是聽見了耶和華所吩咐我們的一切話，倘或你們背棄你們的上帝，這石頭就可以向你們作見證。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS24_28","007_24_28","JOS","24","28","28","於是約書亞打發百姓各歸自己的地業去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS24_29","007_24_29","JOS","24","29","29","這些事以後，耶和華的僕人嫩的兒子約書亞，正一百一十歲，就死了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS24_30","007_24_30","JOS","24","30","30","以色列人將他葬在他地業的境內，就是在以法蓮山地的亭拿‧西拉，在迦實山的北邊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS24_31","007_24_31","JOS","24","31","31","約書亞在世和約書亞死後，那些知道耶和華為以色列人所行諸事的長老還在的時候，以色列人事奉耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS24_32","007_24_32","JOS","24","32","32","以色列人從埃及所帶來約瑟的骸骨，葬埋在示劍，就是在雅各從前用一百塊銀子向示劍的父親、哈抹的子孫所買的那塊地裏；這就作了約瑟子孫的產業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JS24_33","007_24_33","JOS","24","33","33","亞倫的兒子以利亞撒也死了，就把他葬在他兒子非尼哈所得以法蓮山地的小山上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG1_1","008_1_1","JDG","1","1","1","約書亞死後，以色列人求問耶和華說：「我們中間誰當首先上去攻擊迦南人，與他們爭戰？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG1_2","008_1_2","JDG","1","2","2","耶和華說：「猶大當先上去，我已將那地交在他手中。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG1_3","008_1_3","JDG","1","3","3","猶大對他哥哥西緬說：「請你同我到拈鬮所得之地去，好與迦南人爭戰；以後我也同你到你拈鬮所得之地去。」於是西緬與他同去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG1_4","008_1_4","JDG","1","4","4","猶大就上去；耶和華將迦南人和比利洗人交在他們手中。他們在比色擊殺了一萬人， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG1_5","008_1_5","JDG","1","5","5","又在那裏遇見亞多尼‧比色，與他爭戰，殺敗迦南人和比利洗人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG1_6","008_1_6","JDG","1","6","6","亞多尼‧比色逃跑；他們追趕，拿住他，砍斷他手腳的大拇指。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG1_7","008_1_7","JDG","1","7","7","亞多尼‧比色說：「從前有七十個王，手腳的大拇指都被我砍斷，在我桌子底下拾取零碎食物。現在上帝按着我所行的報應我了。」於是他們將亞多尼‧比色帶到耶路撒冷，他就死在那裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG1_8","008_1_8","JDG","1","8","8","猶大人攻打耶路撒冷，將城攻取，用刀殺了城內的人，並且放火燒城。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG1_9","008_1_9","JDG","1","9","9","後來猶大人下去，與住山地、南地，和高原的迦南人爭戰。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG1_10","008_1_10","JDG","1","10","10","猶大人去攻擊住希伯崙的迦南人，殺了示篩、亞希幔、撻買。希伯崙從前名叫基列‧亞巴。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG1_11","008_1_11","JDG","1","11","11","他們從那裏去攻擊底壁的居民；底壁從前名叫基列‧西弗。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG1_12","008_1_12","JDG","1","12","12","迦勒說：「誰能攻打基列‧西弗，將城奪取，我就把我女兒押撒給他為妻。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG1_13","008_1_13","JDG","1","13","13","迦勒兄弟基納斯的兒子俄陀聶奪取了那城，迦勒就把女兒押撒給他為妻。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG1_14","008_1_14","JDG","1","14","14","押撒過門的時候，勸丈夫向她父親求一塊田。押撒一下驢，迦勒問她說：「你要甚麼？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG1_15","008_1_15","JDG","1","15","15","她說：「求你賜福給我，你既將我安置在南地，求你也給我水泉。」迦勒就把上泉下泉賜給她。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG1_16","008_1_16","JDG","1","16","16","摩西的內兄是基尼人，他的子孫與猶大人一同離了棕樹城，往亞拉得以南的猶大曠野去，就住在民中。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG1_17","008_1_17","JDG","1","17","17","猶大和他哥哥西緬同去，擊殺了住洗法的迦南人，將城盡行毀滅，那城的名便叫何珥瑪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG1_18","008_1_18","JDG","1","18","18","猶大又取了迦薩和迦薩的四境，亞實基倫和亞實基倫的四境，以革倫和以革倫的四境。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG1_19","008_1_19","JDG","1","19","19","耶和華與猶大同在，猶大就趕出山地的居民，只是不能趕出平原的居民，因為他們有鐵車。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG1_20","008_1_20","JDG","1","20","20","以色列人照摩西所說的，將希伯崙給了迦勒；迦勒就從那裏趕出亞衲族的三個族長。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG1_21","008_1_21","JDG","1","21","21","便雅憫人沒有趕出住耶路撒冷的耶布斯人。耶布斯人仍在耶路撒冷與便雅憫人同住，直到今日。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG1_22","008_1_22","JDG","1","22","22","約瑟家也上去攻打伯特利；耶和華與他們同在。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG1_23","008_1_23","JDG","1","23","23","約瑟家打發人去窺探伯特利（那城起先名叫路斯）。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG1_24","008_1_24","JDG","1","24","24","窺探的人看見一個人從城裏出來，就對他說：「求你將進城的路指示我們，我們必恩待你。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG1_25","008_1_25","JDG","1","25","25","那人將進城的路指示他們，他們就用刀擊殺了城中的居民，但將那人和他全家放去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG1_26","008_1_26","JDG","1","26","26","那人往赫人之地去，築了一座城，起名叫路斯。那城到如今還叫這名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG1_27","008_1_27","JDG","1","27","27","瑪拿西沒有趕出伯‧善和屬伯‧善鄉村的居民，他納和屬他納鄉村的居民，多珥和屬多珥鄉村的居民，以伯蓮和屬以伯蓮鄉村的居民，米吉多和屬米吉多鄉村的居民；迦南人卻執意住在那些地方。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG1_28","008_1_28","JDG","1","28","28","及至以色列強盛了，就使迦南人做苦工，沒有把他們全然趕出。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG1_29","008_1_29","JDG","1","29","29","以法蓮沒有趕出住基色的迦南人。於是迦南人仍住在基色，在以法蓮中間。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG1_30","008_1_30","JDG","1","30","30","西布倫沒有趕出基倫的居民和拿哈拉的居民。於是迦南人仍住在西布倫中間，成了服苦的人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG1_31","008_1_31","JDG","1","31","31","亞設沒有趕出亞柯和西頓的居民，亞黑拉和亞革悉的居民，黑巴、亞弗革與利合的居民。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG1_32","008_1_32","JDG","1","32","32","於是，亞設因為沒有趕出那地的迦南人，就住在他們中間。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG1_33","008_1_33","JDG","1","33","33","拿弗他利沒有趕出伯‧示麥和伯‧亞納的居民，於是拿弗他利就住在那地的迦南人中間；然而伯‧示麥和伯‧亞納的居民成了服苦的人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG1_34","008_1_34","JDG","1","34","34","亞摩利人強逼但人住在山地，不容他們下到平原； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG1_35","008_1_35","JDG","1","35","35","亞摩利人卻執意住在希烈山和亞雅崙並沙賓。然而約瑟家勝了他們，使他們成了服苦的人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG1_36","008_1_36","JDG","1","36","36","亞摩利人的境界，是從亞克拉濱坡，從西拉而上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG2_1","008_2_1","JDG","2","1","1","耶和華的使者從吉甲上到波金，對以色列人說：「我使你們從埃及上來，領你們到我向你們列祖起誓應許之地。我又說：『我永不廢棄與你們所立的約。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG2_2","008_2_2","JDG","2","2","2","你們也不可與這地的居民立約，要拆毀他們的祭壇。你們竟沒有聽從我的話！為何這樣行呢？』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG2_3","008_2_3","JDG","2","3","3","因此我又說：『我必不將他們從你們面前趕出；他們必作你們肋下的荊棘。他們的神必作你們的網羅。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG2_4","008_2_4","JDG","2","4","4","耶和華的使者向以色列眾人說這話的時候，百姓就放聲而哭； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG2_5","008_2_5","JDG","2","5","5","於是給那地方起名叫波金。眾人在那裏向耶和華獻祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG2_6","008_2_6","JDG","2","6","6","從前約書亞打發以色列百姓去的時候，他們各歸自己的地業，佔據地土。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG2_7","008_2_7","JDG","2","7","7","約書亞在世和約書亞死後，那些見耶和華為以色列人所行大事的長老還在的時候，百姓都事奉耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG2_8","008_2_8","JDG","2","8","8","耶和華的僕人、嫩的兒子約書亞，正一百一十歲就死了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG2_9","008_2_9","JDG","2","9","9","以色列人將他葬在他地業的境內，就是在以法蓮山地的亭拿‧希烈，在迦實山的北邊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG2_10","008_2_10","JDG","2","10","10","那世代的人也都歸了自己的列祖。後來有別的世代興起，不知道耶和華，也不知道耶和華為以色列人所行的事。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG2_11","008_2_11","JDG","2","11","11","以色列人行耶和華眼中看為惡的事，去事奉諸巴力， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG2_12","008_2_12","JDG","2","12","12","離棄了領他們出埃及地的耶和華－他們列祖的上帝，去叩拜別神，就是四圍列國的神，惹耶和華發怒； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG2_13","008_2_13","JDG","2","13","13","並離棄耶和華，去事奉巴力和亞斯她錄。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG2_14","008_2_14","JDG","2","14","14","耶和華的怒氣向以色列人發作，就把他們交在搶奪他們的人手中，又將他們付與四圍仇敵的手中，甚至他們在仇敵面前再不能站立得住。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG2_15","008_2_15","JDG","2","15","15","他們無論往何處去，耶和華都以災禍攻擊他們，正如耶和華所說的話，又如耶和華向他們所起的誓；他們便極其困苦。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG2_16","008_2_16","JDG","2","16","16","耶和華興起士師，士師就拯救他們脫離搶奪他們人的手。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG2_17","008_2_17","JDG","2","17","17","他們卻不聽從士師，竟隨從叩拜別神，行了邪淫，速速地偏離他們列祖所行的道，不如他們列祖順從耶和華的命令。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG2_18","008_2_18","JDG","2","18","18","耶和華為他們興起士師，就與那士師同在。士師在世的一切日子，耶和華拯救他們脫離仇敵的手。他們因受欺壓擾害，就哀聲歎氣，所以耶和華後悔了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG2_19","008_2_19","JDG","2","19","19","及至士師死後，他們就轉去行惡，比他們列祖更甚，去事奉叩拜別神，總不斷絕頑梗的惡行。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG2_20","008_2_20","JDG","2","20","20","於是耶和華的怒氣向以色列人發作。他說：「因這民違背我吩咐他們列祖所守的約，不聽從我的話， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG2_21","008_2_21","JDG","2","21","21","所以約書亞死的時候所剩下的各族，我必不再從他們面前趕出， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG2_22","008_2_22","JDG","2","22","22","為要藉此試驗以色列人，看他們肯照他們列祖謹守遵行我的道不肯。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG2_23","008_2_23","JDG","2","23","23","這樣耶和華留下各族，不將他們速速趕出，也沒有交付約書亞的手。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG3_1","008_3_1","JDG","3","1","1","耶和華留下這幾族，為要試驗那不曾知道與迦南爭戰之事的以色列人， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG3_2","008_3_2","JDG","3","2","2","好叫以色列的後代又知道又學習未曾曉得的戰事。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG3_3","008_3_3","JDG","3","3","3","所留下的就是非利士的五個首領和一切迦南人、西頓人，並住黎巴嫩山的希未人，從巴力‧黑們山直到哈馬口。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG3_4","008_3_4","JDG","3","4","4","留下這幾族，為要試驗以色列人，知道他們肯聽從耶和華藉摩西吩咐他們列祖的誡命不肯。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG3_5","008_3_5","JDG","3","5","5","以色列人竟住在迦南人、赫人、亞摩利人、比利洗人、希未人、耶布斯人中間， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG3_6","008_3_6","JDG","3","6","6","娶他們的女兒為妻，將自己的女兒嫁給他們的兒子，並事奉他們的神。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG3_7","008_3_7","JDG","3","7","7","以色列人行耶和華眼中看為惡的事，忘記耶和華－他們的上帝，去事奉諸巴力和亞舍拉， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG3_8","008_3_8","JDG","3","8","8","所以耶和華的怒氣向以色列人發作，就把他們交在美索不達米亞王古珊‧利薩田的手中。以色列人服事古珊‧利薩田八年。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG3_9","008_3_9","JDG","3","9","9","以色列人呼求耶和華的時候，耶和華就為他們興起一位拯救者救他們，就是迦勒兄弟基納斯的兒子俄陀聶。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG3_10","008_3_10","JDG","3","10","10","耶和華的靈降在他身上，他就作了以色列的士師，出去爭戰。耶和華將美索不達米亞王古珊‧利薩田交在他手中，他便勝了古珊‧利薩田。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG3_11","008_3_11","JDG","3","11","11","於是國中太平四十年。基納斯的兒子俄陀聶死了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG3_12","008_3_12","JDG","3","12","12","以色列人又行耶和華眼中看為惡的事，耶和華就使摩押王伊磯倫強盛，攻擊以色列人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG3_13","008_3_13","JDG","3","13","13","伊磯倫招聚亞捫人和亞瑪力人，去攻打以色列人，佔據棕樹城。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG3_14","008_3_14","JDG","3","14","14","於是以色列人服事摩押王伊磯倫十八年。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG3_15","008_3_15","JDG","3","15","15","以色列人呼求耶和華的時候，耶和華就為他們興起一位拯救者，就是便雅憫人基拉的兒子以笏；他是左手便利的。以色列人託他送禮物給摩押王伊磯倫。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG3_16","008_3_16","JDG","3","16","16","以笏打了一把兩刃的劍，長一肘，帶在右腿上衣服裏面。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG3_17","008_3_17","JDG","3","17","17","他將禮物獻給摩押王伊磯倫（原來伊磯倫極其肥胖）； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG3_18","008_3_18","JDG","3","18","18","以笏獻完禮物，便將抬禮物的人打發走了， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG3_19","008_3_19","JDG","3","19","19","自己卻從靠近吉甲鑿石之地回來，說：「王啊，我有一件機密事奏告你。」王說：「迴避吧！」於是左右侍立的人都退去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG3_20","008_3_20","JDG","3","20","20","以笏來到王面前；王獨自一人坐在涼樓上。以笏說：「我奉上帝的命報告你一件事。」王就從座位上站起來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG3_21","008_3_21","JDG","3","21","21","以笏便伸左手，從右腿上拔出劍來，刺入王的肚腹， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG3_22","008_3_22","JDG","3","22","22","連劍把都刺進去了。劍被肥肉夾住，他沒有從王的肚腹拔出來，且穿通了後身。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG3_23","008_3_23","JDG","3","23","23","以笏就出到遊廊，將樓門盡都關鎖。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG3_24","008_3_24","JDG","3","24","24","以笏出來之後，王的僕人到了，看見樓門關鎖，就說：「他必是在樓上大解。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG3_25","008_3_25","JDG","3","25","25","他們等煩了，見仍不開樓門，就拿鑰匙開了，不料，他們的主人已死，倒在地上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG3_26","008_3_26","JDG","3","26","26","他們耽延的時候，以笏就逃跑了，經過鑿石之地，逃到西伊拉； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG3_27","008_3_27","JDG","3","27","27","到了，就在以法蓮山地吹角。以色列人隨着他下了山地，他在前頭引路， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG3_28","008_3_28","JDG","3","28","28","對他們說：「你們隨我來，因為耶和華已經把你們的仇敵摩押人交在你們手中。」於是他們跟着他下去，把守約旦河的渡口，不容摩押一人過去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG3_29","008_3_29","JDG","3","29","29","那時擊殺了摩押人約有一萬，都是強壯的勇士，沒有一人逃脫。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG3_30","008_3_30","JDG","3","30","30","這樣，摩押就被以色列人制伏了。國中太平八十年。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG3_31","008_3_31","JDG","3","31","31","以笏之後，有亞拿的兒子珊迦，他用趕牛的棍子打死六百非利士人。他也救了以色列人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG4_1","008_4_1","JDG","4","1","1","以笏死後，以色列人又行耶和華眼中看為惡的事， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG4_2","008_4_2","JDG","4","2","2","耶和華就把他們付與在夏瑣作王的迦南王耶賓手中；他的將軍是西西拉，住在外邦人的夏羅設。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG4_3","008_4_3","JDG","4","3","3","耶賓王有鐵車九百輛。他大大欺壓以色列人二十年，以色列人就呼求耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG4_4","008_4_4","JDG","4","4","4","有一位女先知名叫底波拉，是拉比多的妻，當時作以色列的士師。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG4_5","008_4_5","JDG","4","5","5","她住在以法蓮山地拉瑪和伯特利中間，在底波拉的棕樹下。以色列人都上她那裏去聽判斷。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG4_6","008_4_6","JDG","4","6","6","她打發人從拿弗他利的基低斯將亞比挪菴的兒子巴拉召了來，對他說：「耶和華－以色列的上帝吩咐你說：『你率領一萬拿弗他利和西布倫人上他泊山去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG4_7","008_4_7","JDG","4","7","7","我必使耶賓的將軍西西拉率領他的車輛和全軍往基順河，到你那裏去；我必將他交在你手中。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG4_8","008_4_8","JDG","4","8","8","巴拉說：「你若同我去，我就去；你若不同我去，我就不去。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG4_9","008_4_9","JDG","4","9","9","底波拉說：「我必與你同去，只是你在所行的路上得不着榮耀，因為耶和華要將西西拉交在一個婦人手裏。」於是底波拉起來，與巴拉一同往基低斯去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG4_10","008_4_10","JDG","4","10","10","巴拉就招聚西布倫人和拿弗他利人到基低斯，跟他上去的有一萬人。底波拉也同他上去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG4_11","008_4_11","JDG","4","11","11","摩西岳父 何巴的後裔，基尼人希百曾離開基尼族，到靠近基低斯、撒拿音的橡樹旁支搭帳棚。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG4_12","008_4_12","JDG","4","12","12","有人告訴西西拉說：「亞比挪菴的兒子巴拉已經上他泊山了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG4_13","008_4_13","JDG","4","13","13","西西拉就聚集所有的鐵車九百輛和跟隨他的全軍，從外邦人的夏羅設出來，到了基順河。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG4_14","008_4_14","JDG","4","14","14","底波拉對巴拉說：「你起來，今日就是耶和華將西西拉交在你手的日子。耶和華豈不在你前頭行嗎？」於是巴拉下了他泊山，跟隨他有一萬人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG4_15","008_4_15","JDG","4","15","15","耶和華使西西拉和他一切車輛全軍潰亂，在巴拉面前被刀殺敗；西西拉下車步行逃跑。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG4_16","008_4_16","JDG","4","16","16","巴拉追趕車輛、軍隊，直到外邦人的夏羅設。西西拉的全軍都倒在刀下，沒有留下一人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG4_17","008_4_17","JDG","4","17","17","只有西西拉步行逃跑，到了基尼人希百之妻雅億的帳棚，因為夏瑣王耶賓與基尼人希百家和好。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG4_18","008_4_18","JDG","4","18","18","雅億出來迎接西西拉，對他說：「請我主進來，不要懼怕」；西西拉就進了她的帳棚。雅億用被將他遮蓋。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG4_19","008_4_19","JDG","4","19","19","西西拉對雅億說：「我渴了，求你給我一點水喝。」雅億就打開皮袋，給他奶子喝，仍舊把他遮蓋。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG4_20","008_4_20","JDG","4","20","20","西西拉又對雅億說：「請你站在帳棚門口，若有人來問你說：『有人在這裏沒有？』你就說：『沒有。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG4_21","008_4_21","JDG","4","21","21","西西拉疲乏沉睡。希百的妻雅億取了帳棚的橛子，手裏拿着錘子，輕悄悄地到他旁邊，將橛子從他鬢邊釘進去，釘入地裏。西西拉就死了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG4_22","008_4_22","JDG","4","22","22","巴拉追趕西西拉的時候，雅億出來迎接他說：「來吧，我將你所尋找的人給你看。」他就進入帳棚，看見西西拉已經死了，倒在地上，橛子還在他鬢中。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG4_23","008_4_23","JDG","4","23","23","這樣，上帝使迦南王耶賓被以色列人制伏了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG4_24","008_4_24","JDG","4","24","24","從此以色列人的手越發有力，勝了迦南王耶賓，直到將他滅絕了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG5_1","008_5_1","JDG","5","1","1","那時，底波拉和亞比挪菴的兒子巴拉作歌，說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG5_2","008_5_2","JDG","5","2","2","因為以色列中有軍長率領， 百姓也甘心犧牲自己， 你們應當頌讚耶和華！ ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG5_3","008_5_3","JDG","5","3","3","君王啊，要聽！ 王子啊，要側耳而聽！ 我要向耶和華歌唱； 我要歌頌耶和華－以色列的上帝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG5_4","008_5_4","JDG","5","4","4","耶和華啊，你從西珥出來， 由以東地行走。 那時地震天漏， 雲也落雨。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG5_5","008_5_5","JDG","5","5","5","山見耶和華的面就震動， 西奈山見耶和華－以色列上帝的面也是如此。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG5_6","008_5_6","JDG","5","6","6","在亞拿之子珊迦的時候， 又在雅億的日子， 大道無人行走， 都是繞道而行。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG5_7","008_5_7","JDG","5","7","7","以色列中的官長停職， 直到我底波拉興起， 等我興起作以色列的母。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG5_8","008_5_8","JDG","5","8","8","以色列人選擇新神， 爭戰的事就臨到城門。 那時，以色列四萬人中 豈能見盾牌槍矛呢？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG5_9","008_5_9","JDG","5","9","9","我心傾向以色列的首領， 他們在民中甘心犧牲自己。 你們應當頌讚耶和華！ ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG5_10","008_5_10","JDG","5","10","10","騎白驢的、坐繡花毯子的、行路的， 你們都當傳揚！ ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG5_11","008_5_11","JDG","5","11","11","在遠離弓箭響聲打水之處， 人必述說耶和華公義的作為， 就是他治理以色列公義的作為。 那時耶和華的民下到城門。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG5_12","008_5_12","JDG","5","12","12","底波拉啊，興起！興起！ 你當興起，興起，唱歌。 亞比挪菴的兒子巴拉啊，你當奮興， 擄掠你的敵人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG5_13","008_5_13","JDG","5","13","13","那時有餘剩的貴冑和百姓一同下來； 耶和華降臨，為我攻擊勇士。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG5_14","008_5_14","JDG","5","14","14","有根本在亞瑪力人的地， 從以法蓮下來的； 便雅憫在民中跟隨你。 有掌權的從瑪吉下來； 有持杖檢點民數的從西布倫下來； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG5_15","008_5_15","JDG","5","15","15","以薩迦的首領與底波拉同來； 以薩迦怎樣，巴拉也怎樣。 眾人都跟隨巴拉衝下平原； 在呂便的溪水旁有心中定大志的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG5_16","008_5_16","JDG","5","16","16","你為何坐在羊圈內 聽群中吹笛的聲音呢？ 在呂便的溪水旁有心中設大謀的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG5_17","008_5_17","JDG","5","17","17","基列人安居在約旦河外。 但人為何等在船上？ 亞設人在海口靜坐， 在港口安居。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG5_18","008_5_18","JDG","5","18","18","西布倫人是拚命敢死的； 拿弗他利人在田野的高處也是如此。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG5_19","008_5_19","JDG","5","19","19","君王都來爭戰。 那時迦南諸王在米吉多水旁的他納爭戰， 卻未得擄掠銀錢。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG5_20","008_5_20","JDG","5","20","20","星宿從天上爭戰， 從其軌道攻擊西西拉。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG5_21","008_5_21","JDG","5","21","21","基順古河把敵人沖沒； 我的靈啊，應當努力前行。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG5_22","008_5_22","JDG","5","22","22","那時壯馬馳驅， 踢跳，奔騰。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG5_23","008_5_23","JDG","5","23","23","耶和華的使者說： 應當咒詛米羅斯， 大大咒詛其中的居民； 因為他們不來幫助耶和華， 不來幫助耶和華攻擊勇士。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG5_24","008_5_24","JDG","5","24","24","願基尼人希百的妻雅億比眾婦人多得福氣， 比住帳棚的婦人更蒙福祉。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG5_25","008_5_25","JDG","5","25","25","西西拉求水， 雅億給他奶子， 用寶貴的盤子給他奶油。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG5_26","008_5_26","JDG","5","26","26","雅億左手拿着帳棚的橛子， 右手拿着匠人的錘子， 擊打西西拉， 打傷他的頭， 把他的鬢角打破穿通。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG5_27","008_5_27","JDG","5","27","27","西西拉在她腳前曲身仆倒， 在她腳前曲身倒臥； 在那裏曲身，就在那裏死亡。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG5_28","008_5_28","JDG","5","28","28","西西拉的母親從窗戶裏往外觀看， 從窗櫺中呼叫說： 他的戰車為何耽延不來呢？ 他的車輪為何行得慢呢？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG5_29","008_5_29","JDG","5","29","29","聰明的宮女安慰她， 她也自言自語地說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG5_30","008_5_30","JDG","5","30","30","他們莫非得財而分？ 每人得了一兩個女子？ 西西拉得了彩衣為擄物， 得繡花的彩衣為掠物。 這彩衣兩面繡花， 乃是披在被擄之人頸項上的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG5_31","008_5_31","JDG","5","31","31","耶和華啊， 願你的仇敵都這樣滅亡！ 願愛你的人如日頭出現，光輝烈烈！ 這樣，國中太平四十年。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG6_1","008_6_1","JDG","6","1","1","以色列人又行耶和華眼中看為惡的事，耶和華就把他們交在米甸人手裏七年。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG6_2","008_6_2","JDG","6","2","2","米甸人壓制以色列人；以色列人因為米甸人，就在山中挖穴、挖洞、建造營寨。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG6_3","008_6_3","JDG","6","3","3","以色列人每逢撒種之後，米甸人、亞瑪力人，和東方人都上來攻打他們， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG6_4","008_6_4","JDG","6","4","4","對着他們安營，毀壞土產，直到迦薩，沒有給以色列人留下食物，牛、羊、驢也沒有留下； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG6_5","008_6_5","JDG","6","5","5","因為那些人帶着牲畜帳棚來，像蝗蟲那樣多，人和駱駝無數，都進入國內，毀壞全地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG6_6","008_6_6","JDG","6","6","6","以色列人因米甸人的緣故，極其窮乏，就呼求耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG6_7","008_6_7","JDG","6","7","7","以色列人因米甸人的緣故，呼求耶和華， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG6_8","008_6_8","JDG","6","8","8","耶和華就差遣先知到以色列人那裏，對他們說：「耶和華－以色列的上帝如此說：『我曾領你們從埃及上來，出了為奴之家， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG6_9","008_6_9","JDG","6","9","9","救你們脫離埃及人的手，並脫離一切欺壓你們之人的手，把他們從你們面前趕出，將他們的地賜給你們』； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG6_10","008_6_10","JDG","6","10","10","又對你們說：『我是耶和華－你們的上帝。你們住在亞摩利人的地，不可敬畏他們的神。你們竟不聽從我的話。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG6_11","008_6_11","JDG","6","11","11","耶和華的使者到了俄弗拉，坐在亞比以謝族人約阿施的橡樹下。約阿施的兒子基甸正在酒醡那裏打麥子，為要防備米甸人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG6_12","008_6_12","JDG","6","12","12","耶和華的使者向基甸顯現，對他說：「大能的勇士啊，耶和華與你同在！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG6_13","008_6_13","JDG","6","13","13","基甸說：「主啊，耶和華若與我們同在，我們何致遭遇這一切事呢？我們的列祖不是向我們說『耶和華領我們從埃及上來』嗎？他那樣奇妙的作為在哪裏呢？現在他卻丟棄我們，將我們交在米甸人手裏。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG6_14","008_6_14","JDG","6","14","14","耶和華觀看基甸，說：「你靠着你這能力去從米甸人手裏拯救以色列人，不是我差遣你去的嗎？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG6_15","008_6_15","JDG","6","15","15","基甸說：「主啊，我有何能拯救以色列人呢？我家在瑪拿西支派中是至貧窮的。我在我父家是至微小的。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG6_16","008_6_16","JDG","6","16","16","耶和華對他說：「我與你同在，你就必擊打米甸人，如擊打一人一樣。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG6_17","008_6_17","JDG","6","17","17","基甸說：「我若在你眼前蒙恩，求你給我一個證據，使我知道與我說話的就是主。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG6_18","008_6_18","JDG","6","18","18","求你不要離開這裏，等我歸回將禮物帶來供在你面前。」主說：「我必等你回來。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG6_19","008_6_19","JDG","6","19","19","基甸去預備了一隻山羊羔，用一伊法細麵做了無酵餅，將肉放在筐內，把湯盛在壺中，帶到橡樹下，獻在使者面前。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG6_20","008_6_20","JDG","6","20","20","上帝的使者吩咐基甸說：「將肉和無酵餅放在這磐石上，把湯倒出來。」他就這樣行了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG6_21","008_6_21","JDG","6","21","21","耶和華的使者伸出手內的杖，杖頭挨了肉和無酵餅，就有火從磐石中出來，燒盡了肉和無酵餅。耶和華的使者也就不見了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG6_22","008_6_22","JDG","6","22","22","基甸見他是耶和華的使者，就說：「哀哉！主耶和華啊，我不好了，因為我覿面看見耶和華的使者。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG6_23","008_6_23","JDG","6","23","23","耶和華對他說：「你放心，不要懼怕，你必不致死。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG6_24","008_6_24","JDG","6","24","24","於是基甸在那裏為耶和華築了一座壇，起名叫「耶和華沙龍」。（這壇在亞比以謝族的俄弗拉直到如今。） ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG6_25","008_6_25","JDG","6","25","25","當那夜，耶和華吩咐基甸說：「你取你父親的牛來，就是那七歲的第二隻牛，並拆毀你父親為巴力所築的壇，砍下壇旁的木偶， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG6_26","008_6_26","JDG","6","26","26","在這磐石上整整齊齊地為耶和華－你的上帝築一座壇，將第二隻牛獻為燔祭，用你所砍下的木偶作柴。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG6_27","008_6_27","JDG","6","27","27","基甸就從他僕人中挑了十個人，照着耶和華吩咐他的行了。他因怕父家和本城的人，不敢在白晝行這事，就在夜間行了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG6_28","008_6_28","JDG","6","28","28","城裏的人清早起來，見巴力的壇拆毀，壇旁的木偶砍下，第二隻牛獻在新築的壇上， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG6_29","008_6_29","JDG","6","29","29","就彼此說：「這事是誰做的呢？」他們訪查之後，就說：「這是約阿施的兒子基甸做的。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG6_30","008_6_30","JDG","6","30","30","城裏的人對約阿施說：「將你兒子交出來，好治死他；因為他拆毀了巴力的壇，砍下壇旁的木偶。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG6_31","008_6_31","JDG","6","31","31","約阿施回答站着攻擊他的眾人說：「你們是為巴力爭論嗎？你們要救他嗎？誰為他爭論，趁早將誰治死！巴力若果是神，有人拆毀他的壇，讓他為自己爭論吧！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG6_32","008_6_32","JDG","6","32","32","所以當日人稱基甸為耶路‧巴力，意思說：「他拆毀巴力的壇，讓巴力與他爭論。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG6_33","008_6_33","JDG","6","33","33","那時，米甸人、亞瑪力人，和東方人都聚集過河，在耶斯列平原安營。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG6_34","008_6_34","JDG","6","34","34","耶和華的靈降在基甸身上，他就吹角；亞比以謝族都聚集跟隨他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG6_35","008_6_35","JDG","6","35","35","他打發人走遍瑪拿西地，瑪拿西人也聚集跟隨他；又打發人去見亞設人、西布倫人、拿弗他利人，他們也都出來與他們會合。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG6_36","008_6_36","JDG","6","36","36","基甸對上帝說：「你若果照着所說的話，藉我手拯救以色列人， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG6_37","008_6_37","JDG","6","37","37","我就把一團羊毛放在禾場上：若單是羊毛上有露水，別的地方都是乾的，我就知道你必照着所說的話，藉我手拯救以色列人。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG6_38","008_6_38","JDG","6","38","38","次日早晨基甸起來，見果然是這樣；將羊毛擠一擠，從羊毛中擰出滿盆的露水來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG6_39","008_6_39","JDG","6","39","39","基甸又對上帝說：「求你不要向我發怒，我再說這一次：讓我將羊毛再試一次。但願羊毛是乾的，別的地方都有露水。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG6_40","008_6_40","JDG","6","40","40","這夜上帝也如此行：獨羊毛上是乾的，別的地方都有露水。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG7_1","008_7_1","JDG","7","1","1","耶路‧巴力就是基甸，他和一切跟隨的人早晨起來，在哈律泉旁安營。米甸營在他們北邊的平原，靠近摩利岡。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG7_2","008_7_2","JDG","7","2","2","耶和華對基甸說：「跟隨你的人過多，我不能將米甸人交在他們手中，免得以色列人向我誇大，說：『是我們自己的手救了我們。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG7_3","008_7_3","JDG","7","3","3","現在你要向這些人宣告說：『凡懼怕膽怯的，可以離開基列山回去。』」於是有二萬二千人回去，只剩下一萬。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG7_4","008_7_4","JDG","7","4","4","耶和華對基甸說：「人還是過多；你要帶他們下到水旁，我好在那裏為你試試他們。我指點誰說：『這人可以同你去』，他就可以同你去；我指點誰說：『這人不可同你去』，他就不可同你去。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG7_5","008_7_5","JDG","7","5","5","基甸就帶他們下到水旁。耶和華對基甸說：「凡用舌頭舔水，像狗舔的，要使他單站在一處；凡跪下喝水的，也要使他單站在一處。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG7_6","008_7_6","JDG","7","6","6","於是用手捧着舔水的有三百人，其餘的都跪下喝水。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG7_7","008_7_7","JDG","7","7","7","耶和華對基甸說：「我要用這舔水的三百人拯救你們，將米甸人交在你手中；其餘的人都可以各歸各處去。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG7_8","008_7_8","JDG","7","8","8","這三百人就帶着食物和角；其餘的以色列人，基甸都打發他們各歸各的帳棚，只留下這三百人。米甸營在他下邊的平原裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG7_9","008_7_9","JDG","7","9","9","當那夜，耶和華吩咐基甸說：「起來，下到米甸營裏去，因我已將他們交在你手中。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG7_10","008_7_10","JDG","7","10","10","倘若你怕下去，就帶你的僕人普拉下到那營裏去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG7_11","008_7_11","JDG","7","11","11","你必聽見他們所說的，然後你就有膽量下去攻營。」於是基甸帶着僕人普拉下到營旁。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG7_12","008_7_12","JDG","7","12","12","米甸人、亞瑪力人，和一切東方人都布散在平原，如同蝗蟲那樣多。他們的駱駝無數，多如海邊的沙。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG7_13","008_7_13","JDG","7","13","13","基甸到了，就聽見一人將夢告訴同伴說：「我做了一夢，夢見一個大麥餅滾入米甸營中，到了帳幕，將帳幕撞倒，帳幕就翻轉傾覆了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG7_14","008_7_14","JDG","7","14","14","那同伴說：「這不是別的，乃是以色列人約阿施的兒子基甸的刀；上帝已將米甸和全軍都交在他的手中。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG7_15","008_7_15","JDG","7","15","15","基甸聽見這夢和夢的講解，就敬拜上帝，回到以色列營中，說：「起來吧！耶和華已將米甸的軍隊交在你們手中了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG7_16","008_7_16","JDG","7","16","16","於是基甸將三百人分作三隊，把角和空瓶交在各人手裏（瓶內都藏着火把）， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG7_17","008_7_17","JDG","7","17","17","吩咐他們說：「你們要看我行事：我到了營的旁邊怎樣行，你們也要怎樣行。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG7_18","008_7_18","JDG","7","18","18","我和一切跟隨我的人吹角的時候，你們也要在營的四圍吹角，喊叫說：『耶和華和基甸的刀！』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG7_19","008_7_19","JDG","7","19","19","基甸和跟隨他的一百人，在三更之初才換更的時候，來到營旁，就吹角，打破手中的瓶。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG7_20","008_7_20","JDG","7","20","20","三隊的人就都吹角，打破瓶子，左手拿着火把，右手拿着角，喊叫說：「耶和華和基甸的刀！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG7_21","008_7_21","JDG","7","21","21","他們在營的四圍各站各的地方；全營的人都亂竄。三百人吶喊，使他們逃跑。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG7_22","008_7_22","JDG","7","22","22","三百人就吹角，耶和華使全營的人用刀互相擊殺，逃到西利拉的伯‧哈示他，直逃到靠近他巴的亞伯‧米何拉。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG7_23","008_7_23","JDG","7","23","23","以色列人就從拿弗他利、亞設，和瑪拿西全地聚集來追趕米甸人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG7_24","008_7_24","JDG","7","24","24","基甸打發人走遍以法蓮山地，說：「你們下來攻擊米甸人，爭先把守約旦河的渡口，直到伯‧巴拉。」於是以法蓮的眾人聚集，把守約旦河的渡口，直到伯‧巴拉， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG7_25","008_7_25","JDG","7","25","25","捉住了米甸人的兩個首領：一名俄立，一名西伊伯；將俄立殺在俄立磐石上，將西伊伯殺在西伊伯酒醡那裏；又追趕米甸人，將俄立和西伊伯的首級帶過約旦河，到基甸那裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG8_1","008_8_1","JDG","8","1","1","以法蓮人對基甸說：「你去與米甸人爭戰，沒有招我們同去，為甚麼這樣待我們呢？」他們就與基甸大大地爭吵。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG8_2","008_8_2","JDG","8","2","2","基甸對他們說：「我所行的豈能比你們所行的呢？以法蓮拾取剩下的葡萄不強過亞比以謝所摘的葡萄嗎？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG8_3","008_8_3","JDG","8","3","3","上帝已將米甸人的兩個首領俄立和西伊伯交在你們手中；我所行的豈能比你們所行的呢？」基甸說了這話，以法蓮人的怒氣就消了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG8_4","008_8_4","JDG","8","4","4","基甸和跟隨他的三百人到約旦河過渡，雖然疲乏，還是追趕。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG8_5","008_8_5","JDG","8","5","5","基甸對疏割人說：「求你們拿餅來給跟隨我的人吃，因為他們疲乏了；我們追趕米甸人的兩個王西巴和撒慕拿。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG8_6","008_8_6","JDG","8","6","6","疏割人的首領回答說：「西巴和撒慕拿已經在你手裏，你使我們將餅給你的軍兵嗎？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG8_7","008_8_7","JDG","8","7","7","基甸說：「耶和華將西巴和撒慕拿交在我手之後，我就用野地的荊條和枳棘打傷你們。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG8_8","008_8_8","JDG","8","8","8","基甸從那裏上到毗努伊勒，對那裏的人也是這樣說；毗努伊勒人也與疏割人回答他的話一樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG8_9","008_8_9","JDG","8","9","9","他向毗努伊勒人說：「我平平安安回來的時候，我必拆毀這樓。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG8_10","008_8_10","JDG","8","10","10","那時西巴和撒慕拿，並跟隨他們的軍隊都在加各，約有一萬五千人，就是東方人全軍所剩下的；已經被殺約有十二萬拿刀的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG8_11","008_8_11","JDG","8","11","11","基甸就由挪巴和約比哈東邊，從住帳棚人的路上去，殺敗了米甸人的軍兵，因為他們坦然無懼。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG8_12","008_8_12","JDG","8","12","12","西巴和撒慕拿逃跑；基甸追趕他們，捉住米甸的二王西巴和撒慕拿，驚散全軍。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG8_13","008_8_13","JDG","8","13","13","約阿施的兒子基甸由希列斯坡從陣上回來， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG8_14","008_8_14","JDG","8","14","14","捉住疏割的一個少年人，問他：「疏割的首領長老是誰？」他就將首領長老七十七個人的名字寫出來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG8_15","008_8_15","JDG","8","15","15","基甸到了疏割，對那裏的人說：「你們從前譏誚我說：『西巴和撒慕拿已經在你手裏，你使我們將餅給跟隨你的疲乏人嗎？』現在西巴和撒慕拿在這裏。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG8_16","008_8_16","JDG","8","16","16","於是捉住那城內的長老，用野地的荊條和枳棘責打 疏割人； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG8_17","008_8_17","JDG","8","17","17","又拆了毗努伊勒的樓，殺了那城裏的人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG8_18","008_8_18","JDG","8","18","18","基甸問西巴和撒慕拿說：「你們在他泊山所殺的人是甚麼樣式？」回答說：「他們好像你，各人都有王子的樣式。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG8_19","008_8_19","JDG","8","19","19","基甸說：「他們是我同母的弟兄，我指着永生的耶和華起誓，你們從前若存留他們的性命，我如今就不殺你們了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG8_20","008_8_20","JDG","8","20","20","於是對他的長子益帖說：「你起來殺他們。」但益帖因為是童子，害怕，不敢拔刀。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG8_21","008_8_21","JDG","8","21","21","西巴和撒慕拿說：「你自己起來殺我們吧！因為人如何，力量也是如何。」基甸就起來，殺了西巴和撒慕拿，奪獲他們駱駝項上戴的月牙圈。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG8_22","008_8_22","JDG","8","22","22","以色列人對基甸說：「你既救我們脫離米甸人的手，願你和你的兒孫管理我們。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG8_23","008_8_23","JDG","8","23","23","基甸說：「我不管理你們，我的兒子也不管理你們，惟有耶和華管理你們。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG8_24","008_8_24","JDG","8","24","24","基甸又對他們說：「我有一件事求你們：請你們各人將所奪的耳環給我。」（原來仇敵是以實瑪利人，都是戴金耳環的。） ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG8_25","008_8_25","JDG","8","25","25","他們說：「我們情願給你」，就鋪開一件外衣，各人將所奪的耳環丟在其上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG8_26","008_8_26","JDG","8","26","26","基甸所要出來的金耳環重一千七百舍客勒金子。此外還有米甸王所戴的月環、耳墜，和所穿的紫色衣服，並駱駝項上的金鍊子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG8_27","008_8_27","JDG","8","27","27","基甸以此製造了一個以弗得，設立在本城俄弗拉。後來以色列人拜那以弗得行了邪淫；這就作了基甸和他全家的網羅。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG8_28","008_8_28","JDG","8","28","28","這樣，米甸人被以色列人制伏了，不敢再抬頭。基甸還在的日子，國中太平四十年。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG8_29","008_8_29","JDG","8","29","29","約阿施的兒子耶路‧巴力回去，住在自己家裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG8_30","008_8_30","JDG","8","30","30","基甸有七十個親生的兒子，因為他有許多的妻。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG8_31","008_8_31","JDG","8","31","31","他的妾住在示劍，也給他生了一個兒子。基甸與他起名叫亞比米勒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG8_32","008_8_32","JDG","8","32","32","約阿施的兒子基甸，年紀老邁而死，葬在亞比以謝族的俄弗拉，在他父親約阿施的墳墓裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG8_33","008_8_33","JDG","8","33","33","基甸死後，以色列人又去隨從諸巴力行邪淫，以巴力‧比利土為他們的神。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG8_34","008_8_34","JDG","8","34","34","以色列人不記念耶和華－他們的上帝，就是拯救他們脫離四圍仇敵之手的， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG8_35","008_8_35","JDG","8","35","35","也不照着耶路‧巴力，就是基甸向他們所施的恩惠厚待他的家。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_1","008_9_1","JDG","9","1","1","耶路‧巴力的兒子亞比米勒到了示劍見他的眾母舅，對他們和他外祖全家的人說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_2","008_9_2","JDG","9","2","2","「請你們問示劍的眾人說，是耶路‧巴力的眾子七十人都管理你們好呢？還是一人管理你們好呢？你們又要記念我是你們的骨肉。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_3","008_9_3","JDG","9","3","3","他的眾母舅便將這一切話為他說給示劍人聽，示劍人的心就歸向亞比米勒。他們說：「他原是我們的弟兄」； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_4","008_9_4","JDG","9","4","4","就從巴力‧比利土的廟中取了七十舍客勒銀子給亞比米勒；亞比米勒用以雇了些匪徒跟隨他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_5","008_9_5","JDG","9","5","5","他往俄弗拉到他父親的家，將他弟兄、耶路‧巴力的眾子七十人都殺在一塊磐石上；只剩下耶路‧巴力的小兒子約坦，因為他躲藏了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_6","008_9_6","JDG","9","6","6","示劍人和米羅人都一同聚集，往示劍橡樹旁的柱子那裏，立亞比米勒為王。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_7","008_9_7","JDG","9","7","7","有人將這事告訴約坦，他就去站在基利心山頂上，向眾人大聲喊叫說：「示劍人哪，你們要聽我的話，上帝也就聽你們的話。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_8","008_9_8","JDG","9","8","8","有一時，樹木要膏一樹為王，管理他們，就去對橄欖樹說：『請你作我們的王。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_9","008_9_9","JDG","9","9","9","橄欖樹回答說：『我豈肯止住供奉神和尊重人的油，飄颻在眾樹之上呢？』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_10","008_9_10","JDG","9","10","10","樹木對無花果樹說：『請你來作我們的王。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_11","008_9_11","JDG","9","11","11","無花果樹回答說：『我豈肯止住所結甜美的果子，飄颻在眾樹之上呢？』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_12","008_9_12","JDG","9","12","12","樹木對葡萄樹說：『請你來作我們的王。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_13","008_9_13","JDG","9","13","13","葡萄樹回答說：『我豈肯止住使神和人喜樂的新酒，飄颻在眾樹之上呢？』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_14","008_9_14","JDG","9","14","14","眾樹對荊棘說：『請你來作我們的王。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_15","008_9_15","JDG","9","15","15","荊棘回答說：『你們若誠誠實實地膏我為王，就要投在我的蔭下；不然，願火從荊棘裏出來，燒滅黎巴嫩的香柏樹。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_16","008_9_16","JDG","9","16","16","「現在你們立亞比米勒為王，若按誠實正直善待耶路‧巴力和他的全家，這就是酬他的勞。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_17","008_9_17","JDG","9","17","17","從前我父冒死為你們爭戰，救了你們脫離米甸人的手。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_18","008_9_18","JDG","9","18","18","你們如今起來攻擊我的父家，將他眾子七十人殺在一塊磐石上，又立他婢女所生的兒子亞比米勒為示劍人的王；他原是你們的弟兄。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_19","008_9_19","JDG","9","19","19","你們如今若按誠實正直待耶路‧巴力和他的家，就可因亞比米勒得歡樂，他也可因你們得歡樂； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_20","008_9_20","JDG","9","20","20","不然，願火從亞比米勒發出，燒滅示劍人和米羅眾人，又願火從示劍人和米羅人中出來，燒滅亞比米勒。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_21","008_9_21","JDG","9","21","21","約坦因怕他弟兄亞比米勒，就逃跑，來到比珥，住在那裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_22","008_9_22","JDG","9","22","22","亞比米勒管理以色列人三年。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_23","008_9_23","JDG","9","23","23","上帝使惡魔降在亞比米勒和示劍人中間，示劍人就以詭詐待亞比米勒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_24","008_9_24","JDG","9","24","24","這是要叫耶路‧巴力七十個兒子所受的殘害歸與他們的哥哥亞比米勒，又叫那流他們血的罪歸與幫助他殺弟兄的示劍人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_25","008_9_25","JDG","9","25","25","示劍人在山頂上設埋伏，等候亞比米勒。凡從他們那裏經過的人，他們就搶奪。有人將這事告訴亞比米勒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_26","008_9_26","JDG","9","26","26","以別的兒子迦勒和他的弟兄來到示劍，示劍人都信靠他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_27","008_9_27","JDG","9","27","27","示劍人出城到田間去，摘下葡萄，踹酒，設擺筵宴，進他們神的廟中吃喝，咒詛亞比米勒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_28","008_9_28","JDG","9","28","28","以別的兒子迦勒說：「亞比米勒是誰？示劍是誰？使我們服事他呢？他不是耶路‧巴力的兒子嗎？他的幫手不是西布勒嗎？你們可以服事示劍的父親哈抹的後裔。我們為何服事亞比米勒呢？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_29","008_9_29","JDG","9","29","29","惟願這民歸我的手下，我就除掉亞比米勒。」迦勒又對亞比米勒說：「增添你的軍兵出來吧。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_30","008_9_30","JDG","9","30","30","邑宰西布勒聽見以別的兒子迦勒的話，就發怒， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_31","008_9_31","JDG","9","31","31","悄悄地打發人去見亞比米勒，說：「以別的兒子迦勒和他的弟兄到了示劍，煽惑城中的民攻擊你。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_32","008_9_32","JDG","9","32","32","現在你和跟隨你的人今夜起來，在田間埋伏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_33","008_9_33","JDG","9","33","33","到早晨太陽一出，你就起來闖城。迦勒和跟隨他的人出來攻擊你的時候，你便向他們見機而做。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_34","008_9_34","JDG","9","34","34","於是，亞比米勒和跟隨他的眾人夜間起來，分作四隊，埋伏等候示劍人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_35","008_9_35","JDG","9","35","35","以別的兒子迦勒出去，站在城門口。亞比米勒和跟隨他的人從埋伏之處起來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_36","008_9_36","JDG","9","36","36","迦勒看見那些人，就對西布勒說：「看哪，有人從山頂上下來了。」西布勒說：「你看見山的影子，以為是人。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_37","008_9_37","JDG","9","37","37","迦勒又說：「看哪，有人從高處下來，又有一隊從米惡尼尼橡樹的路上而來。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_38","008_9_38","JDG","9","38","38","西布勒對他說：「你曾說，亞比米勒是誰，叫我們服事他？你所誇的口在哪裏呢？這不是你所藐視的民嗎？你現在出去，與他們交戰吧！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_39","008_9_39","JDG","9","39","39","於是迦勒率領示劍人出去，與亞比米勒交戰。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_40","008_9_40","JDG","9","40","40","亞比米勒追趕迦勒；迦勒在他面前逃跑，有許多受傷仆倒的，直到城門。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_41","008_9_41","JDG","9","41","41","亞比米勒住在亞魯瑪。西布勒趕出迦勒和他弟兄，不准他們住在示劍。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_42","008_9_42","JDG","9","42","42","次日，民出到田間，有人告訴亞比米勒； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_43","008_9_43","JDG","9","43","43","他就把他的人分作三隊，埋伏在田間，看見示劍人從城裏出來，就起來擊殺他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_44","008_9_44","JDG","9","44","44","亞比米勒和跟隨他的一隊向前闖去，站在城門口；那兩隊直闖到田間，擊殺了眾人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_45","008_9_45","JDG","9","45","45","亞比米勒整天攻打城，將城奪取，殺了其中的居民，將城拆毀，撒上了鹽。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_46","008_9_46","JDG","9","46","46","示劍樓的人聽見了，就躲入巴力‧比利土廟的衛所。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_47","008_9_47","JDG","9","47","47","有人告訴亞比米勒說：「示劍樓的人都聚在一處。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_48","008_9_48","JDG","9","48","48","亞比米勒和跟隨他的人就都上撒們山。亞比米勒手拿斧子，砍下一根樹枝，扛在肩上，對跟隨他的人說：「你們看我所行的，也當趕緊照樣行。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_49","008_9_49","JDG","9","49","49","眾人就各砍一枝，跟隨亞比米勒，把樹枝堆在衛所的四圍，放火燒了衛所，以致示劍樓的人都死了，男女約有一千。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_50","008_9_50","JDG","9","50","50","亞比米勒到提備斯，向提備斯安營，就攻取了那城。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_51","008_9_51","JDG","9","51","51","城中有一座堅固的樓；城裏的眾人，無論男女，都逃進樓去，關上門，上了樓頂。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_52","008_9_52","JDG","9","52","52","亞比米勒到了樓前攻打，挨近樓門，要用火焚燒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_53","008_9_53","JDG","9","53","53","有一個婦人把一塊上磨石拋在亞比米勒的頭上，打破了他的腦骨。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_54","008_9_54","JDG","9","54","54","他就急忙喊叫拿他兵器的少年人，對他說：「拔出你的刀來，殺了我吧！免得人議論我說，他為一個婦人所殺。」於是少年人把他刺透，他就死了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_55","008_9_55","JDG","9","55","55","以色列人見亞比米勒死了，便各回自己的地方去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_56","008_9_56","JDG","9","56","56","這樣，上帝報應亞比米勒向他父親所行的惡，就是殺了弟兄七十個人的惡。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG9_57","008_9_57","JDG","9","57","57","示劍人的一切惡，上帝也都報應在他們頭上；耶路‧巴力的兒子約坦的咒詛歸到他們身上了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG10_1","008_10_1","JDG","10","1","1","亞比米勒以後，有以薩迦人朵多的孫子、普瓦的兒子陀拉興起，拯救以色列人。他住在以法蓮山地的沙密。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG10_2","008_10_2","JDG","10","2","2","陀拉作以色列的士師二十三年，就死了，葬在沙密。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG10_3","008_10_3","JDG","10","3","3","在他以後有基列人睚珥興起，作以色列的士師二十二年。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG10_4","008_10_4","JDG","10","4","4","他有三十個兒子，騎着三十匹驢駒。他們有三十座城邑，叫作哈倭特‧睚珥，直到如今，都是在基列地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG10_5","008_10_5","JDG","10","5","5","睚珥死了，就葬在加們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG10_6","008_10_6","JDG","10","6","6","以色列人又行耶和華眼中看為惡的事，去事奉諸巴力和亞斯她錄，並亞蘭的神、西頓的神、摩押的神、亞捫人的神、非利士人的神，離棄耶和華，不事奉他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG10_7","008_10_7","JDG","10","7","7","耶和華的怒氣向以色列人發作，就把他們交在非利士人和亞捫人的手中。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG10_8","008_10_8","JDG","10","8","8","從那年起，他們擾害欺壓約旦河那邊、住亞摩利人之基列地的以色列人，共有十八年。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG10_9","008_10_9","JDG","10","9","9","亞捫人又渡過約旦河去攻打猶大和便雅憫，並以法蓮族。以色列人就甚覺窘迫。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG10_10","008_10_10","JDG","10","10","10","以色列人哀求耶和華說：「我們得罪了你；因為離棄了我們上帝，去事奉諸巴力。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG10_11","008_10_11","JDG","10","11","11","耶和華對以色列人說：「我豈沒有救過你們脫離埃及人、亞摩利人、亞捫人，和非利士人嗎？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG10_12","008_10_12","JDG","10","12","12","西頓人、亞瑪力人、馬雲人也都欺壓你們；你們哀求我，我也拯救你們脫離他們的手。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG10_13","008_10_13","JDG","10","13","13","你們竟離棄我，事奉別神！所以我不再救你們了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG10_14","008_10_14","JDG","10","14","14","你們去哀求所選擇的神；你們遭遇急難的時候，讓他救你們吧！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG10_15","008_10_15","JDG","10","15","15","以色列人對耶和華說：「我們犯罪了，任憑你隨意待我們吧！只求你今日拯救我們。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG10_16","008_10_16","JDG","10","16","16","以色列人就除掉他們中間的外邦神，事奉耶和華。耶和華因以色列人受的苦難，就心中擔憂。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG10_17","008_10_17","JDG","10","17","17","當時亞捫人聚集，安營在基列。以色列人也聚集，安營在米斯巴。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG10_18","008_10_18","JDG","10","18","18","基列的民和眾首領彼此商議說：「誰能先去攻打亞捫人，誰必作基列一切居民的領袖。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG11_1","008_11_1","JDG","11","1","1","基列人耶弗他是個大能的勇士，是妓女的兒子。耶弗他是基列所生的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG11_2","008_11_2","JDG","11","2","2","基列的妻也生了幾個兒子：他妻所生的兒子長大了，就趕逐耶弗他，說：「你不可在我們父家承受產業，因為你是妓女的兒子。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG11_3","008_11_3","JDG","11","3","3","耶弗他就逃避他的弟兄，去住在陀伯地，有些匪徒到他那裏聚集，與他一同出入。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG11_4","008_11_4","JDG","11","4","4","過了些日子，亞捫人攻打以色列。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG11_5","008_11_5","JDG","11","5","5","亞捫人攻打以色列的時候，基列的長老到陀伯地去，要叫耶弗他回來； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG11_6","008_11_6","JDG","11","6","6","對耶弗他說：「請你來作我們的元帥，我們好與亞捫人爭戰。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG11_7","008_11_7","JDG","11","7","7","耶弗他回答基列的長老說：「從前你們不是恨我、趕逐我出離父家嗎？現在你們遭遇急難為何到我這裏來呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG11_8","008_11_8","JDG","11","8","8","基列的長老回答耶弗他說：「現在我們到你這裏來，是要你同我們去，與亞捫人爭戰；你可以作基列一切居民的領袖。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG11_9","008_11_9","JDG","11","9","9","耶弗他對基列的長老說：「你們叫我回去，與亞捫人爭戰，耶和華把他交給我，我可以作你們的領袖嗎？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG11_10","008_11_10","JDG","11","10","10","基列的長老回答耶弗他說：「有耶和華在你我中間作見證，我們必定照你的話行。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG11_11","008_11_11","JDG","11","11","11","於是耶弗他同基列的長老回去，百姓就立耶弗他作領袖、作元帥。耶弗他在米斯巴將自己的一切話陳明在耶和華面前。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG11_12","008_11_12","JDG","11","12","12","耶弗他打發使者去見亞捫人的王，說：「你與我有甚麼相干，竟來到我國中攻打我呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG11_13","008_11_13","JDG","11","13","13","亞捫人的王回答耶弗他的使者說：「因為以色列人從埃及上來的時候佔據我的地，從亞嫩河到雅博河，直到約旦河。現在你要好好地將這地歸還吧！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG11_14","008_11_14","JDG","11","14","14","耶弗他又打發使者去見亞捫人的王， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG11_15","008_11_15","JDG","11","15","15","對他說：「耶弗他如此說，以色列人並沒有佔據摩押地和亞捫人的地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG11_16","008_11_16","JDG","11","16","16","以色列人從埃及上來乃是經過曠野到紅海，來到加低斯， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG11_17","008_11_17","JDG","11","17","17","就打發使者去見以東王，說：『求你容我從你的地經過。』以東王卻不應允。又照樣打發使者去見摩押王，他也不允准。以色列人就住在加低斯。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG11_18","008_11_18","JDG","11","18","18","他們又經過曠野，繞着以東和摩押地，從摩押地的東邊過來，在亞嫩河邊安營，並沒有入摩押的境內，因為亞嫩河是摩押的邊界。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG11_19","008_11_19","JDG","11","19","19","以色列人打發使者去見亞摩利王西宏，就是希實本的王，對他說：『求你容我們從你的地經過，往我們自己的地方去。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG11_20","008_11_20","JDG","11","20","20","西宏卻不信服以色列人，不容他們經過他的境界，乃招聚他的眾民在雅雜安營，與以色列人爭戰。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG11_21","008_11_21","JDG","11","21","21","耶和華－以色列的上帝將西宏和他的眾民都交在以色列人手中，以色列人就擊殺他們，得了亞摩利人的全地： ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG11_22","008_11_22","JDG","11","22","22","從亞嫩河到雅博河，從曠野直到約旦河。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG11_23","008_11_23","JDG","11","23","23","耶和華－以色列的上帝在他百姓以色列面前趕出亞摩利人，你竟要得他們的地嗎？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG11_24","008_11_24","JDG","11","24","24","你的神基抹所賜你的地你不是得為業嗎？耶和華－我們的上帝在我們面前所趕出的人，我們就得他的地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG11_25","008_11_25","JDG","11","25","25","難道你比摩押王西撥的兒子巴勒還強嗎？他曾與以色列人爭競，或是與他們爭戰嗎？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG11_26","008_11_26","JDG","11","26","26","以色列人住希實本和屬希實本的鄉村，亞羅珥和屬亞羅珥的鄉村，並沿亞嫩河的一切城邑，已經有三百年了；在這三百年之內，你們為甚麼沒有取回這些地方呢？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG11_27","008_11_27","JDG","11","27","27","原來我沒有得罪你，你卻攻打我，惡待我。願審判人的耶和華今日在以色列人和亞捫人中間判斷是非。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG11_28","008_11_28","JDG","11","28","28","但亞捫人的王不肯聽耶弗他打發人說的話。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG11_29","008_11_29","JDG","11","29","29","耶和華的靈降在耶弗他身上，他就經過基列和瑪拿西，來到基列的米斯巴，又從米斯巴來到亞捫人那裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG11_30","008_11_30","JDG","11","30","30","耶弗他就向耶和華許願，說：「你若將亞捫人交在我手中， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG11_31","008_11_31","JDG","11","31","31","我從亞捫人那裏平平安安回來的時候，無論甚麼人，先從我家門出來迎接我，就必歸你，我也必將他獻上為燔祭。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG11_32","008_11_32","JDG","11","32","32","於是耶弗他往亞捫人那裏去，與他們爭戰；耶和華將他們交在他手中， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG11_33","008_11_33","JDG","11","33","33","他就大大殺敗他們，從亞羅珥到米匿，直到亞備勒‧基拉明，攻取了二十座城。這樣亞捫人就被以色列人制伏了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG11_34","008_11_34","JDG","11","34","34","耶弗他回米斯巴到了自己的家，不料，他女兒拿着鼓跳舞出來迎接他，是他獨生的，此外無兒無女。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG11_35","008_11_35","JDG","11","35","35","耶弗他看見她，就撕裂衣服，說：「哀哉！我的女兒啊，你使我甚是愁苦，叫我作難了；因為我已經向耶和華開口許願，不能挽回。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG11_36","008_11_36","JDG","11","36","36","他女兒回答說：「父啊，你既向耶和華開口，就當照你口中所說的向我行，因耶和華已經在仇敵亞捫人身上為你報仇」； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG11_37","008_11_37","JDG","11","37","37","又對父親說：「有一件事求你允准：容我去兩個月，與同伴在山上，好哀哭我終為處女。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG11_38","008_11_38","JDG","11","38","38","耶弗他說：「你去吧！」就容她去兩個月。她便和同伴去了，在山上為她終為處女哀哭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG11_39","008_11_39","JDG","11","39","39","兩月已滿，她回到父親那裏，父親就照所許的願向她行了。女兒終身沒有親近男子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG11_40","008_11_40","JDG","11","40","40","此後以色列中有個規矩，每年以色列的女子去為基列人耶弗他的女兒哀哭四天。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG12_1","008_12_1","JDG","12","1","1","以法蓮人聚集，到了北方，對耶弗他說：「你去與亞捫人爭戰，為甚麼沒有招我們同去呢？我們必用火燒你和你的房屋。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG12_2","008_12_2","JDG","12","2","2","耶弗他對他們說：「我和我的民與亞捫人大大爭戰；我招你們來，你們竟沒有來救我脫離他們的手。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG12_3","008_12_3","JDG","12","3","3","我見你們不來救我，我就拚命前去攻擊亞捫人，耶和華將他們交在我手中。你們今日為甚麼上我這裏來攻打我呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG12_4","008_12_4","JDG","12","4","4","於是耶弗他招聚基列人，與以法蓮人爭戰。基列人擊殺以法蓮人，是因他們說：「你們基列人在以法蓮、瑪拿西中間，不過是以法蓮逃亡的人。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG12_5","008_12_5","JDG","12","5","5","基列人把守約旦河的渡口，不容以法蓮人過去。以法蓮逃走的人若說：「容我過去。」基列人就問他說：「你是以法蓮人不是？」他若說：「不是」， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG12_6","008_12_6","JDG","12","6","6","就對他說：「你說『示播列』。」以法蓮人因為咬不真字音，便說「西播列」。基列人就將他拿住，殺在約旦河的渡口。那時以法蓮人被殺的有四萬二千人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG12_7","008_12_7","JDG","12","7","7","耶弗他作以色列的士師六年。基列人耶弗他死了，葬在基列的一座城裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG12_8","008_12_8","JDG","12","8","8","耶弗他以後，有伯利恆人以比讚作以色列的士師。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG12_9","008_12_9","JDG","12","9","9","他有三十個兒子，三十個女兒；女兒都嫁出去了。他給眾子從外鄉娶了三十個媳婦。他作以色列的士師七年。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG12_10","008_12_10","JDG","12","10","10","以比讚死了，葬在伯利恆。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG12_11","008_12_11","JDG","12","11","11","以比讚之後，有西布倫人以倫，作以色列的士師十年。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG12_12","008_12_12","JDG","12","12","12","西布倫人以倫死了，葬在西布倫地的亞雅崙。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG12_13","008_12_13","JDG","12","13","13","以倫之後，有比拉頓人希列的兒子押頓作以色列的士師。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG12_14","008_12_14","JDG","12","14","14","他有四十個兒子，三十個孫子，騎着七十匹驢駒。押頓作以色列的士師八年。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG12_15","008_12_15","JDG","12","15","15","比拉頓人希列的兒子押頓死了，葬在以法蓮地的比拉頓，在亞瑪力人的山地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG13_1","008_13_1","JDG","13","1","1","以色列人又行耶和華眼中看為惡的事，耶和華將他們交在非利士人手中四十年。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG13_2","008_13_2","JDG","13","2","2","那時，有一個瑣拉人，是屬但族的，名叫瑪挪亞。他的妻不懷孕，不生育。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG13_3","008_13_3","JDG","13","3","3","耶和華的使者向那婦人顯現，對她說：「向來你不懷孕，不生育，如今你必懷孕生一個兒子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG13_4","008_13_4","JDG","13","4","4","所以你當謹慎，清酒濃酒都不可喝，一切不潔之物也不可吃。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG13_5","008_13_5","JDG","13","5","5","你必懷孕生一個兒子，不可用剃頭刀剃他的頭，因為這孩子一出胎就歸上帝作拿細耳人。他必起首拯救以色列人脫離非利士人的手。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG13_6","008_13_6","JDG","13","6","6","婦人就回去對丈夫說：「有一個神人到我面前來，他的相貌如上帝使者的相貌，甚是可畏。我沒有問他從哪裏來，他也沒有將他的名告訴我， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG13_7","008_13_7","JDG","13","7","7","卻對我說：『你要懷孕生一個兒子，所以清酒濃酒都不可喝，一切不潔之物也不可吃；因為這孩子從出胎一直到死，必歸上帝作拿細耳人。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG13_8","008_13_8","JDG","13","8","8","瑪挪亞就祈求耶和華說：「主啊，求你再差遣那神人到我們這裏來，好指教我們怎樣待這將要生的孩子。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG13_9","008_13_9","JDG","13","9","9","上帝應允瑪挪亞的話；婦人正坐在田間的時候，上帝的使者又到她那裏，她丈夫瑪挪亞卻沒有同她在一處。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG13_10","008_13_10","JDG","13","10","10","婦人急忙跑去告訴丈夫說：「那日到我面前來的人，又向我顯現。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG13_11","008_13_11","JDG","13","11","11","瑪挪亞起來跟隨他的妻來到那人面前，對他說：「與這婦人說話的就是你嗎？」他說：「是我。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG13_12","008_13_12","JDG","13","12","12","瑪挪亞說：「願你的話應驗！我們當怎樣待這孩子，他後來當怎樣呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG13_13","008_13_13","JDG","13","13","13","耶和華的使者對瑪挪亞說：「我告訴婦人的一切事，她都當謹慎。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG13_14","008_13_14","JDG","13","14","14","葡萄樹所結的都不可吃，清酒濃酒都不可喝，一切不潔之物也不可吃。凡我所吩咐的，她都當遵守。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG13_15","008_13_15","JDG","13","15","15","瑪挪亞對耶和華的使者說：「求你容我們款留你，好為你預備一隻山羊羔。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG13_16","008_13_16","JDG","13","16","16","耶和華的使者對瑪挪亞說：「你雖然款留我，我卻不吃你的食物，你若預備燔祭就當獻與耶和華。」原來瑪挪亞不知道他是耶和華的使者。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG13_17","008_13_17","JDG","13","17","17","瑪挪亞對耶和華的使者說：「請將你的名告訴我，到你話應驗的時候，我們好尊敬你。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG13_18","008_13_18","JDG","13","18","18","耶和華的使者對他說：「你何必問我的名，我名是奇妙的。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG13_19","008_13_19","JDG","13","19","19","瑪挪亞將一隻山羊羔和素祭在磐石上獻與耶和華，使者行奇妙的事；瑪挪亞和他的妻觀看， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG13_20","008_13_20","JDG","13","20","20","見火焰從壇上往上升，耶和華的使者在壇上的火焰中也升上去了。瑪挪亞和他的妻看見，就俯伏於地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG13_21","008_13_21","JDG","13","21","21","耶和華的使者不再向瑪挪亞和他的妻顯現，瑪挪亞才知道他是耶和華的使者。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG13_22","008_13_22","JDG","13","22","22","瑪挪亞對他的妻說：「我們必要死，因為看見了上帝。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG13_23","008_13_23","JDG","13","23","23","他的妻卻對他說：「耶和華若要殺我們，必不從我們手裏收納燔祭和素祭，並不將這一切事指示我們，今日也不將這些話告訴我們。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG13_24","008_13_24","JDG","13","24","24","後來婦人生了一個兒子，給他起名叫參孫。孩子長大，耶和華賜福與他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG13_25","008_13_25","JDG","13","25","25","在瑪哈尼‧但，就是瑣拉和以實陶中間，耶和華的靈才感動他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG14_1","008_14_1","JDG","14","1","1","參孫下到亭拿，在那裏看見一個女子，是非利士人的女兒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG14_2","008_14_2","JDG","14","2","2","參孫上來稟告他父母說：「我在亭拿看見一個女子，是非利士人的女兒，願你們給我娶來為妻。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG14_3","008_14_3","JDG","14","3","3","他父母說：「在你弟兄的女兒中，或在本國的民中，豈沒有一個女子，何致你去在未受割禮的非利士人中娶妻呢？」參孫對他父親說：「願你給我娶那女子，因我喜悅她。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG14_4","008_14_4","JDG","14","4","4","他的父母卻不知道這事是出於耶和華，因為他找機會攻擊非利士人。那時，非利士人轄制以色列人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG14_5","008_14_5","JDG","14","5","5","參孫跟他父母下亭拿去，到了亭拿的葡萄園，見有一隻少壯獅子向他吼叫。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG14_6","008_14_6","JDG","14","6","6","耶和華的靈大大感動參孫，他雖然手無器械，卻將獅子撕裂，如同撕裂山羊羔一樣。他行這事並沒有告訴父母。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG14_7","008_14_7","JDG","14","7","7","參孫下去與女子說話，就喜悅她； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG14_8","008_14_8","JDG","14","8","8","過了些日子，再下去要娶那女子，轉向道旁要看死獅，見有一群蜂子和蜜在死獅之內， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG14_9","008_14_9","JDG","14","9","9","就用手取蜜，且吃且走；到了父母那裏，給他父母，他們也吃了；只是沒有告訴這蜜是從死獅之內取來的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG14_10","008_14_10","JDG","14","10","10","他父親下去見女子。參孫在那裏設擺筵宴，因為向來少年人都有這個規矩。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG14_11","008_14_11","JDG","14","11","11","眾人看見參孫，就請了三十個人陪伴他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG14_12","008_14_12","JDG","14","12","12","參孫對他們說：「我給你們出一個謎語，你們在七日筵宴之內，若能猜出意思告訴我，我就給你們三十件裏衣，三十套衣裳； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG14_13","008_14_13","JDG","14","13","13","你們若不能猜出意思告訴我，你們就給我三十件裏衣，三十套衣裳。」他們說：「請將謎語說給我們聽。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG14_14","008_14_14","JDG","14","14","14","參孫對他們說： 吃的從吃者出來； 甜的從強者出來。 他們三日不能猜出謎語的意思。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG14_15","008_14_15","JDG","14","15","15","到第七天，他們對參孫的妻說：「你誆哄你丈夫，探出謎語的意思告訴我們，免得我們用火燒你和你父家。你們請了我們來，是要奪我們所有的嗎？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG14_16","008_14_16","JDG","14","16","16","參孫的妻在丈夫面前啼哭說：「你是恨我，不是愛我，你給我本國的人出謎語，卻沒有將意思告訴我。」參孫回答說：「連我父母我都沒有告訴，豈可告訴你呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG14_17","008_14_17","JDG","14","17","17","七日筵宴之內，她在丈夫面前啼哭，到第七天逼着他，他才將謎語的意思告訴他妻，他妻就告訴本國的人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG14_18","008_14_18","JDG","14","18","18","到第七天，日頭未落以前，那城裏的人對參孫說： 有甚麼比蜜還甜呢？ 有甚麼比獅子還強呢？ 參孫對他們說： 你們若非用我的母牛犢耕地， 就猜不出我謎語的意思來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG14_19","008_14_19","JDG","14","19","19","耶和華的靈大大感動參孫，他就下到亞實基倫，擊殺了三十個人，奪了他們的衣裳，將衣裳給了猜出謎語的人。參孫發怒，就上父家去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG14_20","008_14_20","JDG","14","20","20","參孫的妻便歸了參孫的陪伴，就是作過他朋友的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG15_1","008_15_1","JDG","15","1","1","過了些日子，到割麥子的時候，參孫帶着一隻山羊羔去看他的妻，說：「我要進內室見我的妻。」他岳父不容他進去， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG15_2","008_15_2","JDG","15","2","2","說：「我估定你是極其恨她，因此我將她給了你的陪伴。她的妹子不是比她還美麗嗎？你可以娶來代替她吧！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG15_3","008_15_3","JDG","15","3","3","參孫說：「這回我加害於非利士人不算有罪。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG15_4","008_15_4","JDG","15","4","4","於是參孫去捉了三百隻狐狸，將狐狸尾巴一對一對地捆上，將火把捆在兩條尾巴中間， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG15_5","008_15_5","JDG","15","5","5","點着火把，就放狐狸進入非利士人站着的禾稼，將堆集的禾捆和未割的禾稼，並橄欖園盡都燒了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG15_6","008_15_6","JDG","15","6","6","非利士人說：「這事是誰做的呢？」有人說：「是亭拿人的女婿參孫，因為他岳父將他的妻給了他的陪伴。」於是非利士人上去，用火燒了婦人和她的父親。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG15_7","008_15_7","JDG","15","7","7","參孫對非利士人說：「你們既然這樣行，我必向你們報仇才肯罷休。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG15_8","008_15_8","JDG","15","8","8","參孫就大大擊殺他們，連腿帶腰都砍斷了。他便下去，住在以坦磐的穴內。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG15_9","008_15_9","JDG","15","9","9","非利士人上去安營在猶大，布散在利希。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG15_10","008_15_10","JDG","15","10","10","猶大人說：「你們為何上來攻擊我們呢？」他們說：「我們上來是要捆綁參孫；他向我們怎樣行，我們也要向他怎樣行。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG15_11","008_15_11","JDG","15","11","11","於是有三千猶大人下到以坦磐的穴內，對參孫說：「非利士人轄制我們，你不知道嗎？你向我們行的是甚麼事呢？」他回答說：「他們向我怎樣行，我也要向他們怎樣行。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG15_12","008_15_12","JDG","15","12","12","猶大人對他說：「我們下來是要捆綁你，將你交在非利士人手中。」參孫說：「你們要向我起誓，應承你們自己不害死我。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG15_13","008_15_13","JDG","15","13","13","他們說：「我們斷不殺你，只要將你捆綁交在非利士人手中。」於是用兩條新繩捆綁參孫，將他從以坦磐帶上去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG15_14","008_15_14","JDG","15","14","14","參孫到了利希，非利士人都迎着喧嚷。耶和華的靈大大感動參孫，他臂上的繩就像火燒的麻一樣，他的綁繩都從他手上脫落下來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG15_15","008_15_15","JDG","15","15","15","他見一塊未乾的驢腮骨，就伸手拾起來，用以擊殺一千人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG15_16","008_15_16","JDG","15","16","16","參孫說： 我用驢腮骨殺人成堆， 用驢腮骨殺了一千人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG15_17","008_15_17","JDG","15","17","17","說完這話，就把那腮骨從手裏拋出去了。那地便叫拉末‧利希。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG15_18","008_15_18","JDG","15","18","18","參孫甚覺口渴，就求告耶和華說：「你既藉僕人的手施行這麼大的拯救，豈可任我渴死、落在未受割禮的人手中呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG15_19","008_15_19","JDG","15","19","19","上帝就使利希的窪處裂開，有水從其中湧出來。參孫喝了，精神復原；因此那泉名叫隱‧哈歌利，那泉直到今日還在利希。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG15_20","008_15_20","JDG","15","20","20","當非利士人轄制以色列人的時候，參孫作以色列的士師二十年。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG16_1","008_16_1","JDG","16","1","1","參孫到了迦薩，在那裏看見一個妓女，就與她親近。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG16_2","008_16_2","JDG","16","2","2","有人告訴迦薩人說：「參孫到這裏來了！」他們就把他團團圍住，終夜在城門悄悄埋伏，說：「等到天亮我們便殺他。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG16_3","008_16_3","JDG","16","3","3","參孫睡到半夜，起來，將城門的門扇、門框、門閂，一齊拆下來，扛在肩上，扛到希伯崙前的山頂上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG16_4","008_16_4","JDG","16","4","4","後來，參孫在梭烈谷喜愛一個婦人，名叫大利拉。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG16_5","008_16_5","JDG","16","5","5","非利士人的首領上去見那婦人，對她說：「求你誆哄參孫，探探他因何有這麼大的力氣，我們用何法能勝他，捆綁剋制他。我們就每人給你一千一百舍客勒銀子。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG16_6","008_16_6","JDG","16","6","6","大利拉對參孫說：「求你告訴我，你因何有這麼大的力氣，當用何法捆綁剋制你。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG16_7","008_16_7","JDG","16","7","7","參孫回答說：「人若用七條未乾的青繩子捆綁我，我就軟弱像別人一樣。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG16_8","008_16_8","JDG","16","8","8","於是非利士人的首領拿了七條未乾的青繩子來，交給婦人，她就用繩子捆綁參孫。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG16_9","008_16_9","JDG","16","9","9","有人預先埋伏在婦人的內室裏。婦人說：「參孫哪，非利士人拿你來了！」參孫就掙斷繩子，如掙斷經火的麻線一般。這樣，他力氣的根由人還是不知道。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG16_10","008_16_10","JDG","16","10","10","大利拉對參孫說：「你欺哄我，向我說謊言。現在求你告訴我當用何法捆綁你。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG16_11","008_16_11","JDG","16","11","11","參孫回答說：「人若用沒有使過的新繩捆綁我，我就軟弱像別人一樣。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG16_12","008_16_12","JDG","16","12","12","大利拉就用新繩捆綁他，對他說：「參孫哪，非利士人拿你來了！」有人預先埋伏在內室裏。參孫將臂上的繩掙斷了，如掙斷一條線一樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG16_13","008_16_13","JDG","16","13","13","大利拉對參孫說：「你到如今還是欺哄我，向我說謊言。求你告訴我，當用何法捆綁你。」參孫回答說：「你若將我頭上的七條髮綹，與緯線同織就可以了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG16_14","008_16_14","JDG","16","14","14","於是大利拉將他的髮綹與緯線同織，用橛子釘住，對他說：「參孫哪，非利士人拿你來了！」參孫從睡中醒來，將機上的橛子和緯線一齊都拔出來了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG16_15","008_16_15","JDG","16","15","15","大利拉對參孫說：「你既不與我同心，怎麼說你愛我呢？你這三次欺哄我，沒有告訴我，你因何有這麼大的力氣。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG16_16","008_16_16","JDG","16","16","16","大利拉天天用話催逼他，甚至他心裏煩悶要死。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG16_17","008_16_17","JDG","16","17","17","參孫就把心中所藏的都告訴了她，對她說：「向來人沒有用剃頭刀剃我的頭，因為我自出母胎就歸上帝作拿細耳人；若剃了我的頭髮，我的力氣就離開我，我便軟弱像別人一樣。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG16_18","008_16_18","JDG","16","18","18","大利拉見他把心中所藏的都告訴了她，就打發人到非利士人的首領那裏，對他們說：「他已經把心中所藏的都告訴了我，請你們再上來一次。」於是非利士人的首領手裏拿着銀子，上到婦人那裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG16_19","008_16_19","JDG","16","19","19","大利拉使參孫枕着她的膝睡覺，叫了一個人來剃除他頭上的七條髮綹。於是大利拉剋制他，他的力氣就離開他了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG16_20","008_16_20","JDG","16","20","20","大利拉說：「參孫哪，非利士人拿你來了！」參孫從睡中醒來，心裏說：「我要像前幾次出去活動身體」；他卻不知道耶和華已經離開他了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG16_21","008_16_21","JDG","16","21","21","非利士人將他拿住，剜了他的眼睛，帶他下到迦薩，用銅鍊拘索他；他就在監裏推磨。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG16_22","008_16_22","JDG","16","22","22","然而他的頭髮被剃之後，又漸漸長起來了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG16_23","008_16_23","JDG","16","23","23","非利士人的首領聚集，要給他們的神大袞獻大祭，並且歡樂，因為他們說：「我們的神將我們的仇敵參孫交在我們手中了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG16_24","008_16_24","JDG","16","24","24","眾人看見參孫，就讚美他們的神說：「我們的神將毀壞我們地、殺害我們許多人的仇敵交在我們手中了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG16_25","008_16_25","JDG","16","25","25","他們正宴樂的時候，就說：「叫參孫來，在我們面前戲耍戲耍。」於是將參孫從監裏提出來，他就在眾人面前戲耍。他們使他站在兩柱中間。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG16_26","008_16_26","JDG","16","26","26","參孫向拉他手的童子說：「求你讓我摸着托房的柱子，我要靠一靠。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG16_27","008_16_27","JDG","16","27","27","那時房內充滿男女，非利士人的眾首領也都在那裏。房的平頂上約有三千男女觀看參孫戲耍。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG16_28","008_16_28","JDG","16","28","28","參孫求告耶和華說：「主耶和華啊，求你眷念我。上帝啊，求你賜我這一次的力量，使我在非利士人身上報那剜我雙眼的仇。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG16_29","008_16_29","JDG","16","29","29","參孫就抱住托房的那兩根柱子：左手抱一根，右手抱一根， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG16_30","008_16_30","JDG","16","30","30","說：「我情願與非利士人同死！」就盡力屈身，房子倒塌，壓住首領和房內的眾人。這樣，參孫死時所殺的人比活着所殺的還多。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG16_31","008_16_31","JDG","16","31","31","參孫的弟兄和他父的全家都下去取他的屍首，抬上來葬在瑣拉和以實陶中間，在他父瑪挪亞的墳墓裏。參孫作以色列的士師二十年。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG17_1","008_17_1","JDG","17","1","1","以法蓮山地有一個人名叫米迦。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG17_2","008_17_2","JDG","17","2","2","他對母親說：「你那一千一百舍客勒銀子被人拿去，你因此咒詛，並且告訴了我。看哪，這銀子在我這裏，是我拿去了。」他母親說：「我兒啊，願耶和華賜福與你！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG17_3","008_17_3","JDG","17","3","3","米迦就把這一千一百舍客勒銀子還他母親。他母親說：「我分出這銀子來為你獻給耶和華，好雕刻一個像，鑄成一個像。現在我還是交給你。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG17_4","008_17_4","JDG","17","4","4","米迦將銀子還他母親，他母親將二百舍客勒銀子交給銀匠，雕刻一個像，鑄成一個像，安置在米迦的屋內。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG17_5","008_17_5","JDG","17","5","5","這米迦有了神堂，又製造以弗得和家中的神像，分派他一個兒子作祭司。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG17_6","008_17_6","JDG","17","6","6","那時以色列中沒有王，各人任意而行。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG17_7","008_17_7","JDG","17","7","7","猶大的伯利恆有一個少年人，是猶大族的利未人，他在那裏寄居。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG17_8","008_17_8","JDG","17","8","8","這人離開猶大的伯利恆城，要找一個可住的地方。行路的時候，到了以法蓮山地，走到米迦的家。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG17_9","008_17_9","JDG","17","9","9","米迦問他說：「你從哪裏來？」他回答說：「從猶大的伯利恆來。我是利未人，要找一個可住的地方。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG17_10","008_17_10","JDG","17","10","10","米迦說：「你可以住在我這裏，我以你為父、為祭司。我每年給你十舍客勒銀子，一套衣服和度日的食物。」利未人就進了他的家。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG17_11","008_17_11","JDG","17","11","11","利未人情願與那人同住；那人看這少年人如自己的兒子一樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG17_12","008_17_12","JDG","17","12","12","米迦分派這少年的利未人作祭司，他就住在米迦的家裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG17_13","008_17_13","JDG","17","13","13","米迦說：「現在我知道耶和華必賜福與我，因我有一個利未人作祭司。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG18_1","008_18_1","JDG","18","1","1","那時，以色列中沒有王。但支派的人仍是尋地居住；因為到那日子，他們還沒有在以色列支派中得地為業。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG18_2","008_18_2","JDG","18","2","2","但人從瑣拉和以實陶打發本族中的五個勇士，去仔細窺探那地，吩咐他們說：「你們去窺探那地。」他們來到以法蓮山地，進了米迦的住宅，就在那裏住宿。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG18_3","008_18_3","JDG","18","3","3","他們臨近米迦的住宅，聽出那少年利未人的口音來，就進去問他說：「誰領你到這裏來？你在這裏做甚麼？你在這裏得甚麼？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG18_4","008_18_4","JDG","18","4","4","他回答說：「米迦待我如此如此，請我作祭司。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG18_5","008_18_5","JDG","18","5","5","他們對他說：「請你求問上帝，使我們知道所行的道路通達不通達。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG18_6","008_18_6","JDG","18","6","6","祭司對他們說：「你們可以平平安安地去，你們所行的道路是在耶和華面前的。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG18_7","008_18_7","JDG","18","7","7","五人就走了，來到拉億，見那裏的民安居無慮，如同西頓人安居一樣。在那地沒有人掌權擾亂他們；他們離西頓人也遠，與別人沒有來往。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG18_8","008_18_8","JDG","18","8","8","五人回到瑣拉和以實陶，見他們的弟兄；弟兄問他們說：「你們有甚麼話？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG18_9","008_18_9","JDG","18","9","9","他們回答說：「起來，我們上去攻擊他們吧！我們已經窺探那地，見那地甚好。你們為何靜坐不動呢？要急速前往得那地為業，不可遲延。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG18_10","008_18_10","JDG","18","10","10","你們到了那裏，必看見安居無慮的民，地也寬闊。上帝已將那地交在你們手中；那地百物俱全，一無所缺。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG18_11","008_18_11","JDG","18","11","11","於是但族中的六百人，各帶兵器，從瑣拉和以實陶前往， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG18_12","008_18_12","JDG","18","12","12","上到猶大的基列‧耶琳，在基列‧耶琳後邊安營。因此那地方名叫瑪哈尼‧但，直到今日。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG18_13","008_18_13","JDG","18","13","13","他們從那裏往以法蓮山地去，來到米迦的住宅。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG18_14","008_18_14","JDG","18","14","14","從前窺探拉億地的五個人對他們的弟兄說：「這宅子裏有以弗得和家中的神像，並雕刻的像與鑄成的像，你們知道嗎？現在你們要想一想當怎樣行。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG18_15","008_18_15","JDG","18","15","15","五人就進入米迦的住宅，到了那少年利未人的房內問他好。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG18_16","008_18_16","JDG","18","16","16","那六百但人各帶兵器，站在門口。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG18_17","008_18_17","JDG","18","17","17","窺探地的五個人走進去，將雕刻的像、以弗得、家中的神像，並鑄成的像，都拿了去。祭司和帶兵器的六百人，一同站在門口。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG18_18","008_18_18","JDG","18","18","18","那五個人進入米迦的住宅，拿出雕刻的像、以弗得、家中的神像，並鑄成的像，祭司就問他們說：「你們做甚麼呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG18_19","008_18_19","JDG","18","19","19","他們回答說：「不要作聲，用手摀口，跟我們去吧！我們必以你為父、為祭司。你作一家的祭司好呢？還是作以色列一族一支派的祭司好呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG18_20","008_18_20","JDG","18","20","20","祭司心裏喜悅，便拿着以弗得和家中的神像，並雕刻的像，進入他們中間。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG18_21","008_18_21","JDG","18","21","21","他們就轉身離開那裏，妻子、兒女、牲畜、財物都在前頭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG18_22","008_18_22","JDG","18","22","22","離米迦的住宅已遠，米迦的近鄰都聚集來，追趕但人， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG18_23","008_18_23","JDG","18","23","23","呼叫但人。但人回頭問米迦說：「你聚集這許多人來做甚麼呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG18_24","008_18_24","JDG","18","24","24","米迦說：「你們將我所做的神像和祭司都帶了去，我還有所剩的嗎？怎麼還問我說『做甚麼』呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG18_25","008_18_25","JDG","18","25","25","但人對米迦說：「你不要使我們聽見你的聲音，恐怕有性暴的人攻擊你，以致你和你的全家盡都喪命。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG18_26","008_18_26","JDG","18","26","26","但人還是走他們的路。米迦見他們的勢力比自己強盛，就轉身回家去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG18_27","008_18_27","JDG","18","27","27","但人將米迦所做的神像和他的祭司都帶到拉億，見安居無慮的民，就用刀殺了那民，又放火燒了那城， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG18_28","008_18_28","JDG","18","28","28","並無人搭救；因為離西頓遠，他們又與別人沒有來往。城在平原，那平原靠近伯‧利合。但人又在那裏修城居住， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG18_29","008_18_29","JDG","18","29","29","照着他們始祖以色列之子但的名字，給那城起名叫但；原先那城名叫拉億。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG18_30","008_18_30","JDG","18","30","30","但人就為自己設立那雕刻的像。摩西的孫子、革舜的兒子約拿單，和他的子孫作但支派的祭司，直到那地遭擄掠的日子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG18_31","008_18_31","JDG","18","31","31","上帝的殿在示羅多少日子，但人為自己設立米迦所雕刻的像也在但多少日子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG19_1","008_19_1","JDG","19","1","1","當以色列中沒有王的時候，有住以法蓮山地那邊的一個利未人，娶了一個猶大伯利恆的女子為妾。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG19_2","008_19_2","JDG","19","2","2","妾行淫離開丈夫，回猶大的伯利恆，到了父家，在那裏住了四個月。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG19_3","008_19_3","JDG","19","3","3","她丈夫起來，帶着一個僕人、兩匹驢去見她，用好話勸她回來。女子就引丈夫進入父家。她父見了那人，便歡歡喜喜地迎接。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG19_4","008_19_4","JDG","19","4","4","那人的岳父，就是女子的父親，將那人留下住了三天。於是二人一同吃喝、住宿。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG19_5","008_19_5","JDG","19","5","5","到第四天，利未人清早起來要走，女子的父親對女婿說：「請你吃點飯，加添心力，然後可以行路。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG19_6","008_19_6","JDG","19","6","6","於是二人坐下一同吃喝。女子的父親對那人說：「請你再住一夜，暢快你的心。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG19_7","008_19_7","JDG","19","7","7","那人起來要走，他岳父強留他，他又住了一宿。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG19_8","008_19_8","JDG","19","8","8","到第五天，他清早起來要走，女子的父親說：「請你吃點飯，加添心力，等到日頭偏西再走。」於是二人一同吃飯。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG19_9","008_19_9","JDG","19","9","9","那人同他的妾和僕人起來要走，他岳父，就是女子的父親，對他說：「看哪，日頭偏西了，請你再住一夜；天快晚了，可以在這裏住宿，暢快你的心。明天早早起行回家去。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG19_10","008_19_10","JDG","19","10","10","那人不願再住一夜，就備上那兩匹驢，帶着妾起身走了，來到耶布斯的對面（耶布斯就是耶路撒冷。） ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG19_11","008_19_11","JDG","19","11","11","臨近耶布斯的時候，日頭快要落了，僕人對主人說：「我們不如進這耶布斯人的城裏住宿。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG19_12","008_19_12","JDG","19","12","12","主人回答說：「我們不可進不是以色列人住的外邦城，不如過到基比亞去」； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG19_13","008_19_13","JDG","19","13","13","又對僕人說：「我們可以到一個地方，或住在基比亞，或住在拉瑪。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG19_14","008_19_14","JDG","19","14","14","他們就往前走。將到便雅憫的基比亞，日頭已經落了； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG19_15","008_19_15","JDG","19","15","15","他們進入基比亞要在那裏住宿，就坐在城裏的街上，因為無人接他們進家住宿。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG19_16","008_19_16","JDG","19","16","16","晚上，有一個老年人從田間做工回來。他原是以法蓮山地的人，住在基比亞；那地方的人卻是便雅憫人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG19_17","008_19_17","JDG","19","17","17","老年人舉目看見客人坐在城裏的街上，就問他說：「你從哪裏來？要往哪裏去？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG19_18","008_19_18","JDG","19","18","18","他回答說：「我們從猶大的伯利恆來，要往以法蓮山地那邊去。我原是那裏的人，到過猶大的伯利恆，現在我往耶和華的殿去，在這裏無人接我進他的家。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG19_19","008_19_19","JDG","19","19","19","其實我有糧草可以餵驢，我與我的妾，並我的僕人，有餅有酒，並不缺少甚麼。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG19_20","008_19_20","JDG","19","20","20","老年人說：「願你平安！你所需用的我都給你，只是不可在街上過夜。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG19_21","008_19_21","JDG","19","21","21","於是領他們到家裏，餵上驢，他們就洗腳吃喝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG19_22","008_19_22","JDG","19","22","22","他們心裏正歡暢的時候，城中的匪徒圍住房子，連連叩門，對房主老人說：「你把那進你家的人帶出來，我們要與他交合。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG19_23","008_19_23","JDG","19","23","23","那房主出來對他們說：「弟兄們哪，不要這樣作惡；這人既然進了我的家，你們就不要行這醜事。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG19_24","008_19_24","JDG","19","24","24","我有個女兒，還是處女，並有這人的妾，我將她們領出來任憑你們玷辱她們，只是向這人不可行這樣的醜事。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG19_25","008_19_25","JDG","19","25","25","那些人卻不聽從他的話。那人就把他的妾拉出去交給他們，他們便與她交合，終夜凌辱她，直到天色快亮才放她去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG19_26","008_19_26","JDG","19","26","26","天快亮的時候，婦人回到她主人住宿的房門前，就仆倒在地，直到天亮。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG19_27","008_19_27","JDG","19","27","27","早晨，她的主人起來開了房門，出去要行路，不料那婦人仆倒在房門前，兩手搭在門檻上； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG19_28","008_19_28","JDG","19","28","28","就對婦人說：「起來，我們走吧！」婦人卻不回答。那人便將她馱在驢上，起身回本處去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG19_29","008_19_29","JDG","19","29","29","到了家裏，用刀將妾的屍身切成十二塊，使人拿着傳送以色列的四境。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG19_30","008_19_30","JDG","19","30","30","凡看見的人都說：「從以色列人出埃及地，直到今日，這樣的事沒有行過，也沒有見過。現在應當思想，大家商議當怎樣辦理。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG20_1","008_20_1","JDG","20","1","1","於是以色列從但到別是巴，以及住基列地的眾人都出來，如同一人，聚集在米斯巴耶和華面前。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG20_2","008_20_2","JDG","20","2","2","以色列民的首領，就是各支派的軍長，都站在上帝百姓的會中；拿刀的步兵共有四十萬。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG20_3","008_20_3","JDG","20","3","3","以色列人上到米斯巴，便雅憫人都聽見了。以色列人說：「請你將這件惡事的情由對我們說明。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG20_4","008_20_4","JDG","20","4","4","那利未人，就是被害之婦人的丈夫，回答說：「我和我的妾到了便雅憫的基比亞住宿。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG20_5","008_20_5","JDG","20","5","5","基比亞人夜間起來，圍了我住的房子，想要殺我，又將我的妾強姦致死。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG20_6","008_20_6","JDG","20","6","6","我就把我妾的屍身切成塊子，使人拿着傳送以色列得為業的全地，因為基比亞人在以色列中行了兇淫醜惡的事。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG20_7","008_20_7","JDG","20","7","7","你們以色列人都當籌劃商議。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG20_8","008_20_8","JDG","20","8","8","眾民都起來如同一人，說：「我們連一人都不回自己帳棚、自己房屋去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG20_9","008_20_9","JDG","20","9","9","我們向基比亞人必這樣行，照所掣的籤去攻擊他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG20_10","008_20_10","JDG","20","10","10","我們要在以色列各支派中，一百人挑取十人，一千人挑取百人，一萬人挑取千人，為民運糧，等大眾到了便雅憫的基比亞，就照基比亞人在以色列中所行的醜事征伐他們。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG20_11","008_20_11","JDG","20","11","11","於是以色列眾人彼此連合如同一人，聚集攻擊那城。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG20_12","008_20_12","JDG","20","12","12","以色列眾支派打發人去，問便雅憫支派的各家說：「你們中間怎麼做了這樣的惡事呢？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG20_13","008_20_13","JDG","20","13","13","現在你們要將基比亞的那些匪徒交出來，我們好治死他們，從以色列中除掉這惡。」便雅憫人卻不肯聽從他們弟兄以色列人的話。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG20_14","008_20_14","JDG","20","14","14","便雅憫人從他們的各城裏出來，聚集到了基比亞，要與以色列人打仗。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG20_15","008_20_15","JDG","20","15","15","那時便雅憫人從各城裏點出拿刀的，共有二萬六千；另外還有基比亞人點出七百精兵。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG20_16","008_20_16","JDG","20","16","16","在眾軍之中有揀選的七百精兵，都是左手便利的，能用機弦甩石打人，毫髮不差。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG20_17","008_20_17","JDG","20","17","17","便雅憫人之外，點出以色列人拿刀的，共有四十萬，都是戰士。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG20_18","008_20_18","JDG","20","18","18","以色列人就起來，到伯特利去求問上帝說：「我們中間誰當首先上去與便雅憫人爭戰呢？」耶和華說：「猶大當先上去。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG20_19","008_20_19","JDG","20","19","19","以色列人早晨起來，對着基比亞安營。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG20_20","008_20_20","JDG","20","20","20","以色列人出來，要與便雅憫人打仗，就在基比亞前擺陣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG20_21","008_20_21","JDG","20","21","21","便雅憫人就從基比亞出來，當日殺死以色列人二萬二千。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG20_22","008_20_22","JDG","20","22","22","以色列人彼此奮勇，仍在頭一日擺陣的地方又擺陣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG20_23","008_20_23","JDG","20","23","23","未擺陣之先，以色列人上去，在耶和華面前哭號，直到晚上，求問耶和華說：「我們再去與我們弟兄便雅憫人打仗可以不可以？」耶和華說：「可以上去攻擊他們。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG20_24","008_20_24","JDG","20","24","24","第二日，以色列人就上前攻擊便雅憫人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG20_25","008_20_25","JDG","20","25","25","便雅憫人也在這日從基比亞出來，與以色列人接戰，又殺死他們一萬八千，都是拿刀的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG20_26","008_20_26","JDG","20","26","26","以色列眾人就上到伯特利，坐在耶和華面前哭號，當日禁食直到晚上；又在耶和華面前獻燔祭和平安祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG20_27","008_20_27","JDG","20","27","28","那時，上帝的約櫃在那裏；亞倫的孫子、以利亞撒的兒子非尼哈侍立在約櫃前。以色列人問耶和華說：「我們當再出去與我們弟兄便雅憫人打仗呢？還是罷兵呢？」耶和華說：「你們當上去，因為明日我必將他們交在你們手中。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG20_29","008_20_29","JDG","20","29","29","以色列人在基比亞的四圍設下伏兵。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG20_30","008_20_30","JDG","20","30","30","第三日，以色列人又上去攻擊便雅憫人，在基比亞前擺陣，與前兩次一樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG20_31","008_20_31","JDG","20","31","31","便雅憫人也出來迎敵，就被引誘離城；在田間兩條路上，一通伯特利，一通基比亞，像前兩次，動手殺死以色列人約有三十個。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG20_32","008_20_32","JDG","20","32","32","便雅憫人說：「他們仍舊敗在我們面前。」但以色列人說：「我們不如逃跑，引誘他們離開城到路上來。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG20_33","008_20_33","JDG","20","33","33","以色列眾人都起來，在巴力‧他瑪擺陣，以色列的伏兵從馬利‧迦巴埋伏的地方衝上前去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG20_34","008_20_34","JDG","20","34","34","有以色列人中的一萬精兵，來到基比亞前接戰，勢派甚是凶猛；便雅憫人卻不知道災禍臨近了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG20_35","008_20_35","JDG","20","35","35","耶和華使以色列人殺敗便雅憫人。那日，以色列人殺死便雅憫人二萬五千一百，都是拿刀的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG20_36","008_20_36","JDG","20","36","36","於是便雅憫人知道自己敗了。先是以色列人；因為靠着在基比亞前所設的伏兵，就在便雅憫人面前詐敗。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG20_37","008_20_37","JDG","20","37","37","伏兵急忙闖進基比亞，用刀殺死全城的人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG20_38","008_20_38","JDG","20","38","38","以色列人預先同伏兵約定在城內放火，以煙氣上騰為號。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG20_39","008_20_39","JDG","20","39","39","以色列人臨退陣的時候，便雅憫人動手殺死以色列人，約有三十個，就說：「他們仍像前次被我們殺敗了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG20_40","008_20_40","JDG","20","40","40","當煙氣如柱從城中上騰的時候，便雅憫人回頭觀看，見全城的煙氣沖天。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG20_41","008_20_41","JDG","20","41","41","以色列人又轉身回來，便雅憫人就甚驚惶，因為看見災禍臨到自己了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG20_42","008_20_42","JDG","20","42","42","他們在以色列人面前轉身往曠野逃跑；以色列人在後面追殺。那從各城裏出來的，也都夾攻殺滅他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG20_43","008_20_43","JDG","20","43","43","以色列人圍繞便雅憫人，追趕他們，在他們歇腳之處、對着日出之地的基比亞踐踏他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG20_44","008_20_44","JDG","20","44","44","便雅憫人死了的有一萬八千，都是勇士。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG20_45","008_20_45","JDG","20","45","45","其餘的人轉身向曠野逃跑，往臨門磐去。以色列人在道路上殺了他們五千人，如拾取遺穗一樣，追到基頓又殺了他們二千人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG20_46","008_20_46","JDG","20","46","46","那日便雅憫死了的共有二萬五千人，都是拿刀的勇士。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG20_47","008_20_47","JDG","20","47","47","只剩下六百人，轉身向曠野逃跑，到了臨門磐，就在那裏住了四個月。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG20_48","008_20_48","JDG","20","48","48","以色列人又轉到便雅憫地，將各城的人和牲畜，並一切所遇見的，都用刀殺盡，又放火燒了一切城邑。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG21_1","008_21_1","JDG","21","1","1","以色列人在米斯巴曾起誓說：「我們都不將女兒給便雅憫人為妻。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG21_2","008_21_2","JDG","21","2","2","以色列人來到伯特利，坐在上帝面前直到晚上，放聲痛哭， ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG21_3","008_21_3","JDG","21","3","3","說：「耶和華－以色列的上帝啊，為何以色列中有這樣缺了一支派的事呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG21_4","008_21_4","JDG","21","4","4","次日清早，百姓起來，在那裏築了一座壇，獻燔祭和平安祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG21_5","008_21_5","JDG","21","5","5","以色列人彼此問說：「以色列各支派中，誰沒有同會眾上到耶和華面前來呢？」先是以色列人起過大誓說，凡不上米斯巴到耶和華面前來的，必將他治死。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG21_6","008_21_6","JDG","21","6","6","以色列人為他們的弟兄便雅憫後悔，說：「如今以色列中絕了一個支派了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG21_7","008_21_7","JDG","21","7","7","我們既在耶和華面前起誓說，必不將我們的女兒給便雅憫人為妻，現在我們當怎樣辦理、使他們剩下的人有妻呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG21_8","008_21_8","JDG","21","8","8","又彼此問說：「以色列支派中誰沒有上米斯巴到耶和華面前來呢？」他們就查出基列‧雅比沒有一人進營到會眾那裏； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG21_9","008_21_9","JDG","21","9","9","因為百姓被數的時候，沒有一個基列‧雅比人在那裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG21_10","008_21_10","JDG","21","10","10","會眾就打發一萬二千大勇士，吩咐他們說：「你們去用刀將基列‧雅比人連婦女帶孩子都擊殺了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG21_11","008_21_11","JDG","21","11","11","所當行的就是這樣：要將一切男子和已嫁的女子盡行殺戮。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG21_12","008_21_12","JDG","21","12","12","他們在基列‧雅比人中，遇見了四百個未嫁的處女，就帶到迦南地的示羅營裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG21_13","008_21_13","JDG","21","13","13","全會眾打發人到臨門磐的便雅憫人那裏，向他們說和睦的話。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG21_14","008_21_14","JDG","21","14","14","當時便雅憫人回來了，以色列人就把所存活基列‧雅比的女子給他們為妻，還是不夠。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG21_15","008_21_15","JDG","21","15","15","百姓為便雅憫人後悔，因為耶和華使以色列人缺了一個支派。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG21_16","008_21_16","JDG","21","16","16","會中的長老說：「便雅憫中的女子既然除滅了，我們當怎樣辦理、使那餘剩的人有妻呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG21_17","008_21_17","JDG","21","17","17","又說：「便雅憫逃脫的人當有地業，免得以色列中塗抹了一個支派。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG21_18","008_21_18","JDG","21","18","18","只是我們不能將自己的女兒給他們為妻；因為以色列人曾起誓說，有將女兒給便雅憫人為妻的，必受咒詛。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG21_19","008_21_19","JDG","21","19","19","他們又說：「在利波拿以南，伯特利以北，在示劍大路以東的示羅，年年有耶和華的節期」； ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG21_20","008_21_20","JDG","21","20","20","就吩咐便雅憫人說：「你們去，在葡萄園中埋伏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG21_21","008_21_21","JDG","21","21","21","若看見示羅的女子出來跳舞，就從葡萄園出來，在示羅的女子中各搶一個為妻，回便雅憫地去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG21_22","008_21_22","JDG","21","22","22","他們的父親或是弟兄若來與我們爭競，我們就說：『求你們看我們的情面，施恩給這些人，因我們在爭戰的時候沒有給他們留下女子為妻。這也不是你們將女子給他們的；若是你們給的，就算有罪。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG21_23","008_21_23","JDG","21","23","23","於是便雅憫人照樣而行，按着他們的數目從跳舞的女子中搶去為妻，就回自己的地業去，又重修城邑居住。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG21_24","008_21_24","JDG","21","24","24","當時以色列人離開那裏，各歸本支派、本宗族、本地業去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("JG21_25","008_21_25","JDG","21","25","25","那時，以色列中沒有王，各人任意而行。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","當士師秉政的時候，國中遭遇饑荒。在猶大的伯利恆，有一個人帶着妻子和兩個兒子往摩押地去寄居。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","這人名叫以利米勒，他的妻名叫拿俄米；他兩個兒子，一個名叫瑪倫，一個名叫基連，都是猶大伯利恆的以法他人。他們到了摩押地，就住在那裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","後來拿俄米的丈夫以利米勒死了，剩下婦人和她兩個兒子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","這兩個兒子娶了摩押女子為妻，一個名叫俄珥巴，一個名叫路得，在那裏住了約有十年。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","瑪倫和基連二人也死了，剩下拿俄米，沒有丈夫，也沒有兒子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","她就與兩個兒婦起身，要從摩押地歸回；因為她在摩押地聽見耶和華眷顧自己的百姓，賜糧食與他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","於是她和兩個兒婦起行離開所住的地方，要回猶大地去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","拿俄米對兩個兒婦說：「你們各人回娘家去吧。願耶和華恩待你們，像你們恩待已死的人與我一樣！ ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","願耶和華使你們各在新夫家中得平安！」於是拿俄米與她們親嘴。她們就放聲而哭， ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","說：「不然，我們必與你一同回你本國去。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","拿俄米說：「我女兒們哪，回去吧！為何要跟我去呢？我還能生子作你們的丈夫嗎？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","我女兒們哪，回去吧！我年紀老邁，不能再有丈夫；即或說，我還有指望，今夜有丈夫可以生子， ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","你們豈能等着他們長大呢？你們豈能等着他們不嫁別人呢？我女兒們哪，不要這樣。我為你們的緣故甚是愁苦，因為耶和華伸手攻擊我。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","兩個兒婦又放聲而哭，俄珥巴與婆婆親嘴而別，只是路得捨不得拿俄米。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","拿俄米說：「看哪，你嫂子已經回她本國和她所拜的神那裏去了，你也跟着你嫂子回去吧！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","路得說：「不要催我回去不跟隨你。你往哪裏去，我也往那裏去；你在哪裏住宿，我也在那裏住宿；你的國就是我的國，你的上帝就是我的上帝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","你在哪裏死，我也在那裏死，也葬在那裏。除非死能使你我相離！不然，願耶和華重重地降罰與我。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","拿俄米見路得定意要跟隨自己去，就不再勸她了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","於是二人同行，來到伯利恆。她們到了伯利恆，合城的人就都驚訝。婦女們說：「這是拿俄米嗎？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","拿俄米對她們說：「不要叫我拿俄米，要叫我瑪拉，因為全能者使我受了大苦。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","我滿滿地出去，耶和華使我空空地回來。耶和華降禍與我；全能者使我受苦。既是這樣，你們為何還叫我拿俄米呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","拿俄米和她兒婦摩押女子路得，從摩押地回來到伯利恆，正是動手割大麥的時候。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","拿俄米的丈夫以利米勒的親族中，有一個人名叫波阿斯，是個大財主。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","摩押女子路得對拿俄米說：「容我往田間去，我蒙誰的恩，就在誰的身後拾取麥穗。」拿俄米說：「女兒啊，你只管去。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","路得就去了，來到田間，在收割的人身後拾取麥穗。她恰巧到了以利米勒本族的人波阿斯那塊田裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","波阿斯正從伯利恆來，對收割的人說：「願耶和華與你們同在！」他們回答說：「願耶和華賜福與你！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","波阿斯問監管收割的僕人說：「那是誰家的女子？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","監管收割的僕人回答說：「是那摩押女子，跟隨拿俄米從摩押地回來的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","她說：『請你容我跟着收割的人拾取打捆剩下的麥穗。』她從早晨直到如今，除了在屋子裏坐一會兒，常在這裏。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","波阿斯對路得說：「女兒啊，聽我說，不要往別人田裏拾取麥穗，也不要離開這裏，要常與我使女們在一處。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","我的僕人在那塊田收割，你就跟着他們去。我已經吩咐僕人不可欺負你；你若渴了，就可以到器皿那裏喝僕人打來的水。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","路得就俯伏在地叩拜，對他說：「我既是外邦人，怎麼蒙你的恩，這樣顧恤我呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","波阿斯回答說：「自從你丈夫死後，凡你向婆婆所行的，並你離開父母和本地，到素不認識的民中，這些事人全都告訴我了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","願耶和華照你所行的賞賜你。你來投靠耶和華－以色列上帝的翅膀下，願你滿得他的賞賜。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","路得說：「我主啊，願在你眼前蒙恩。我雖然不及你的一個使女，你還用慈愛的話安慰我的心。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","到了吃飯的時候，波阿斯對路得說：「你到這裏來吃餅，將餅蘸在醋裏。」路得就在收割的人旁邊坐下；他們把烘了的穗子遞給她。她吃飽了，還有餘剩的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","她起來又拾取麥穗，波阿斯吩咐僕人說：「她就是在捆中拾取麥穗，也可以容她，不可羞辱她； ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","並要從捆裏抽出些來，留在地下任她拾取，不可叱嚇她。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","這樣，路得在田間拾取麥穗，直到晚上，將所拾取的打了，約有一伊法大麥。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","她就把所拾取的帶進城去給婆婆看，又把她吃飽了所剩的給了婆婆。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","婆婆問她說：「你今日在哪裏拾取麥穗，在哪裏做工呢？願那顧恤你的得福。」路得就告訴婆婆說：「我今日在一個名叫波阿斯的人那裏做工。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","拿俄米對兒婦說：「願那人蒙耶和華賜福，因為他不斷地恩待活人死人。」拿俄米又說：「那是我們本族的人，是一個至近的親屬。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","摩押女子路得說：「他對我說：『你要緊隨我的僕人拾取麥穗，直等他們收完了我的莊稼。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","拿俄米對兒婦路得說：「女兒啊，你跟着他的使女出去，不叫人遇見你在別人田間，這才為好。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","於是路得與波阿斯的使女常在一處拾取麥穗，直到收完了大麥和小麥。路得仍與婆婆同住。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","路得的婆婆拿俄米對她說：「女兒啊，我不當為你找個安身之處，使你享福嗎？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","你與波阿斯的使女常在一處，波阿斯不是我們的親族嗎？他今夜在場上簸大麥； ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","你要沐浴抹膏，換上衣服，下到場上，卻不要使那人認出你來。你等他吃喝完了， ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","到他睡的時候，你看準他睡的地方，就進去掀開他腳上的被，躺臥在那裏，他必告訴你所當做的事。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","路得說：「凡你所吩咐的，我必遵行。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","路得就下到場上，照她婆婆所吩咐她的而行。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","波阿斯吃喝完了，心裏歡暢，就去睡在麥堆旁邊。路得便悄悄地來掀開他腳上的被，躺臥在那裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","到了夜半，那人忽然驚醒，翻過身來，不料有女子躺在他的腳下。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","他就說：「你是誰？」回答說：「我是你的婢女路得。求你用你的衣襟遮蓋我，因為你是我一個至近的親屬。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","波阿斯說：「女兒啊，願你蒙耶和華賜福。你末後的恩比先前更大；因為少年人無論貧富，你都沒有跟從。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","女兒啊，現在不要懼怕，凡你所說的，我必照着行；我本城的人都知道你是個賢德的女子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","我實在是你一個至近的親屬，只是還有一個人比我更近。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","你今夜在這裏住宿，明早他若肯為你盡親屬的本分，就由他吧！倘若不肯，我指着永生的耶和華起誓，我必為你盡了本分，你只管躺到天亮。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","路得便在他腳下躺到天快亮，人彼此不能辨認的時候就起來了。波阿斯說：「不可使人知道有女子到場上來」； ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","又對路得說：「打開你所披的外衣。」她打開了，波阿斯就撮了六簸箕大麥，幫她扛在肩上，她便進城去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","路得回到婆婆那裏，婆婆說：「女兒啊，怎麼樣了？」路得就將那人向她所行的述說了一遍， ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","又說：「那人給了我六簸箕大麥，對我說：『你不可空手回去見你的婆婆。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","婆婆說：「女兒啊，你只管安坐等候，看這事怎樣成就，因為那人今日不辦成這事必不休息。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","波阿斯到了城門，坐在那裏，恰巧波阿斯所說的那至近的親屬經過。波阿斯說：「某人哪，你來坐在這裏。」他就來坐下。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","波阿斯又從本城的長老中揀選了十人，對他們說：「請你們坐在這裏。」他們就都坐下。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","波阿斯對那至近的親屬說：「從摩押地回來的拿俄米，現在要賣我們族兄以利米勒的那塊地； ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","我想當贖那塊地的是你，其次是我，以外再沒有別人了。你可以在這裏的人面前和我本國的長老面前說明，你若肯贖就贖，若不肯贖就告訴我。」那人回答說：「我肯贖。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","波阿斯說：「你從拿俄米手中買這地的時候，也當娶死人的妻摩押女子路得，使死人在產業上存留他的名。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","那人說：「這樣我就不能贖了，恐怕於我的產業有礙。你可以贖我所當贖的，我不能贖了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","從前，在以色列中要定奪甚麼事，或贖回，或交易，這人就脫鞋給那人。以色列人都以此為證據。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","那人對波阿斯說：「你自己買吧！」於是將鞋脫下來了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","波阿斯對長老和眾民說：「你們今日作見證，凡屬以利米勒和基連、瑪倫的，我都從拿俄米手中置買了； ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","又娶了瑪倫的妻摩押女子路得為妻，好在死人的產業上存留他的名，免得他的名在本族本鄉滅沒。你們今日可以作見證。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","在城門坐着的眾民和長老都說：「我們作見證。願耶和華使進你家的這女子，像建立以色列家的拉結、利亞二人一樣。又願你在以法他得亨通，在伯利恆得名聲。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","願耶和華從這少年女子賜你後裔，使你的家像她瑪從猶大所生法勒斯的家一般。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","於是，波阿斯娶了路得為妻，與她同房。耶和華使她懷孕生了一個兒子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","婦人們對拿俄米說：「耶和華是應當稱頌的！因為今日沒有撇下你，使你無至近的親屬。願這孩子在以色列中得名聲。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","他必提起你的精神，奉養你的老，因為是愛慕你的那兒婦所生的。有這兒婦比有七個兒子還好！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","拿俄米就把孩子抱在懷中，作他的養母。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","鄰舍的婦人說：「拿俄米得孩子了！」就給孩子起名叫俄備得。這俄備得是耶西的父，耶西是大衛的父。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","法勒斯的後代記在下面：法勒斯生希斯崙； ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","希斯崙生蘭；蘭生亞米拿達； ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","亞米拿達生拿順；拿順生撒門； ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","撒門生波阿斯；波阿斯生俄備得； ");
INSERT INTO cmn_cu89t_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","俄備得生耶西；耶西生大衛。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S11_1","010_1_1","1SA","1","1","1","以法蓮山地的拉瑪‧瑣非有一個以法蓮人，名叫以利加拿，是蘇弗的玄孫，託戶的曾孫，以利戶的孫子，耶羅罕的兒子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S11_2","010_1_2","1SA","1","2","2","他有兩個妻：一名哈拿，一名毗尼拿。毗尼拿有兒女，哈拿沒有兒女。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S11_3","010_1_3","1SA","1","3","3","這人每年從本城上到示羅，敬拜祭祀萬軍之耶和華；在那裏有以利的兩個兒子何弗尼、非尼哈當耶和華的祭司。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S11_4","010_1_4","1SA","1","4","4","以利加拿每逢獻祭的日子，將祭肉分給他的妻毗尼拿和毗尼拿所生的兒女； ");
INSERT INTO cmn_cu89t_vpl VALUES ("S11_5","010_1_5","1SA","1","5","5","給哈拿的卻是雙分，因為他愛哈拿。無奈耶和華不使哈拿生育。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S11_6","010_1_6","1SA","1","6","6","毗尼拿見耶和華不使哈拿生育，就作她的對頭，大大激動她，要使她生氣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S11_7","010_1_7","1SA","1","7","7","每年上到耶和華殿的時候，以利加拿都以雙分給哈拿；毗尼拿仍是激動她，以致她哭泣不吃飯。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S11_8","010_1_8","1SA","1","8","8","她丈夫以利加拿對她說：「哈拿啊，你為何哭泣，不吃飯，心裏愁悶呢？有我不比十個兒子還好嗎？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S11_9","010_1_9","1SA","1","9","9","他們在示羅吃喝完了，哈拿就站起來。祭司以利在耶和華殿的門框旁邊，坐在自己的位上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S11_10","010_1_10","1SA","1","10","10","哈拿心裏愁苦，就痛痛哭泣，祈禱耶和華， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S11_11","010_1_11","1SA","1","11","11","許願說：「萬軍之耶和華啊，你若垂顧婢女的苦情，眷念不忘婢女，賜我一個兒子，我必使他終身歸與耶和華，不用剃頭刀剃他的頭。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S11_12","010_1_12","1SA","1","12","12","哈拿在耶和華面前不住地祈禱，以利定睛看她的嘴。（ ");
INSERT INTO cmn_cu89t_vpl VALUES ("S11_13","010_1_13","1SA","1","13","13","原來哈拿心中默禱，只動嘴唇，不出聲音，因此以利以為她喝醉了。） ");
INSERT INTO cmn_cu89t_vpl VALUES ("S11_14","010_1_14","1SA","1","14","14","以利對她說：「你要醉到幾時呢？你不應該喝酒。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S11_15","010_1_15","1SA","1","15","15","哈拿回答說：「主啊，不是這樣。我是心裏愁苦的婦人，清酒濃酒都沒有喝，但在耶和華面前傾心吐意。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S11_16","010_1_16","1SA","1","16","16","不要將婢女看作不正經的女子。我因被人激動，愁苦太多，所以祈求到如今。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S11_17","010_1_17","1SA","1","17","17","以利說：「你可以平平安安地回去。願以色列的上帝允准你向他所求的！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S11_18","010_1_18","1SA","1","18","18","哈拿說：「願婢女在你眼前蒙恩。」於是婦人走去吃飯，面上再不帶愁容了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S11_19","010_1_19","1SA","1","19","19","次日清早，他們起來，在耶和華面前敬拜，就回拉瑪。到了家裏，以利加拿和妻哈拿同房，耶和華顧念哈拿， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S11_20","010_1_20","1SA","1","20","20","哈拿就懷孕。日期滿足，生了一個兒子，給他起名叫撒母耳，說：「這是我從耶和華那裏求來的。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S11_21","010_1_21","1SA","1","21","21","以利加拿和他全家都上示羅去，要向耶和華獻年祭，並還所許的願。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S11_22","010_1_22","1SA","1","22","22","哈拿卻沒有上去，對丈夫說：「等孩子斷了奶，我便帶他上去朝見耶和華，使他永遠住在那裏。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S11_23","010_1_23","1SA","1","23","23","她丈夫以利加拿說：「就隨你的意行吧！可以等兒子斷了奶。但願耶和華應驗他的話。」於是婦人在家裏乳養兒子，直到斷了奶； ");
INSERT INTO cmn_cu89t_vpl VALUES ("S11_24","010_1_24","1SA","1","24","24","既斷了奶，就把孩子帶上示羅，到了耶和華的殿；又帶了三隻公牛，一伊法細麵，一皮袋酒。（那時，孩子還小。） ");
INSERT INTO cmn_cu89t_vpl VALUES ("S11_25","010_1_25","1SA","1","25","25","宰了一隻公牛，就領孩子到以利面前。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S11_26","010_1_26","1SA","1","26","26","婦人說：「主啊，我敢在你面前起誓，從前在你這裏站着祈求耶和華的那婦人，就是我。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S11_27","010_1_27","1SA","1","27","27","我祈求為要得這孩子；耶和華已將我所求的賜給我了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S11_28","010_1_28","1SA","1","28","28","所以，我將這孩子歸與耶和華，使他終身歸與耶和華。」 於是在那裏敬拜耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S12_1","010_2_1","1SA","2","1","1","哈拿禱告說： 我的心因耶和華快樂； 我的角因耶和華高舉。 我的口向仇敵張開； 我因耶和華的救恩歡欣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S12_2","010_2_2","1SA","2","2","2","只有耶和華為聖； 除他以外沒有可比的， 也沒有磐石像我們的上帝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S12_3","010_2_3","1SA","2","3","3","人不要誇口說驕傲的話， 也不要出狂妄的言語； 因耶和華是大有智識的上帝， 人的行為被他衡量。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S12_4","010_2_4","1SA","2","4","4","勇士的弓都已折斷； 跌倒的人以力量束腰。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S12_5","010_2_5","1SA","2","5","5","素來飽足的，反作用人求食； 飢餓的，再不飢餓。 不生育的，生了七個兒子； 多有兒女的，反倒衰微。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S12_6","010_2_6","1SA","2","6","6","耶和華使人死，也使人活， 使人下陰間，也使人往上升。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S12_7","010_2_7","1SA","2","7","7","他使人貧窮，也使人富足， 使人卑微，也使人高貴。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S12_8","010_2_8","1SA","2","8","8","他從灰塵裏抬舉貧寒人， 從糞堆中提拔窮乏人， 使他們與王子同坐， 得着榮耀的座位。 地的柱子屬於耶和華； 他將世界立在其上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S12_9","010_2_9","1SA","2","9","9","他必保護聖民的腳步， 使惡人在黑暗中寂然不動； 人都不能靠力量得勝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S12_10","010_2_10","1SA","2","10","10","與耶和華爭競的，必被打碎； 耶和華必從天上以雷攻擊他， 必審判地極的人， 將力量賜與所立的王， 高舉受膏者的角。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S12_11","010_2_11","1SA","2","11","11","以利加拿往拉瑪回家去了。那孩子在祭司以利面前事奉耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S12_12","010_2_12","1SA","2","12","12","以利的兩個兒子是惡人，不認識耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S12_13","010_2_13","1SA","2","13","13","這二祭司待百姓是這樣的規矩：凡有人獻祭，正煮肉的時候，祭司的僕人就來，手拿三齒的叉子， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S12_14","010_2_14","1SA","2","14","14","將叉子往罐裏，或鼎裏，或釜裏，或鍋裏一插，插上來的肉，祭司都取了去。凡上到示羅的以色列人，他們都是這樣看待。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S12_15","010_2_15","1SA","2","15","15","又在未燒脂油以前，祭司的僕人就來對獻祭的人說：「將肉給祭司，叫他烤吧。他不要煮過的，要生的。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S12_16","010_2_16","1SA","2","16","16","獻祭的人若說：「必須先燒脂油，然後你可以隨意取肉。」僕人就說：「你立時給我，不然我便搶去。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S12_17","010_2_17","1SA","2","17","17","如此，這二少年人的罪在耶和華面前甚重了，因為他們藐視耶和華的祭物。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S12_18","010_2_18","1SA","2","18","18","那時，撒母耳還是孩子，穿着細麻布的以弗得，侍立在耶和華面前。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S12_19","010_2_19","1SA","2","19","19","他母親每年為他做一件小外袍，同着丈夫上來獻年祭的時候帶來給他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S12_20","010_2_20","1SA","2","20","20","以利為以利加拿和他的妻祝福，說：「願耶和華由這婦人再賜你後裔，代替你從耶和華求來的孩子。」他們就回本鄉去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S12_21","010_2_21","1SA","2","21","21","耶和華眷顧哈拿，她就懷孕生了三個兒子，兩個女兒。那孩子撒母耳在耶和華面前漸漸長大。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S12_22","010_2_22","1SA","2","22","22","以利年甚老邁，聽見他兩個兒子待以色列眾人的事，又聽見他們與會幕門前伺候的婦人苟合， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S12_23","010_2_23","1SA","2","23","23","他就對他們說：「你們為何行這樣的事呢？我從這眾百姓聽見你們的惡行。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S12_24","010_2_24","1SA","2","24","24","我兒啊，不可這樣！我聽見你們的風聲不好，你們使耶和華的百姓犯了罪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S12_25","010_2_25","1SA","2","25","25","人若得罪人，有士師審判他；人若得罪耶和華，誰能為他祈求呢？」然而他們還是不聽父親的話，因為耶和華想要殺他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S12_26","010_2_26","1SA","2","26","26","孩子撒母耳漸漸長大，耶和華與人越發喜愛他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S12_27","010_2_27","1SA","2","27","27","有神人來見以利，對他說：「耶和華如此說：『你祖父在埃及法老家作奴僕的時候，我不是向他們顯現嗎？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("S12_28","010_2_28","1SA","2","28","28","在以色列眾支派中，我不是揀選人作我的祭司，使他燒香，在我壇上獻祭，在我面前穿以弗得，又將以色列人所獻的火祭都賜給你父家嗎？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("S12_29","010_2_29","1SA","2","29","29","我所吩咐獻在我居所的祭物，你們為何踐踏？尊重你的兒子過於尊重我，將我民以色列所獻美好的祭物肥己呢？』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S12_30","010_2_30","1SA","2","30","30","因此，耶和華－以色列的上帝說：『我曾說，你和你父家必永遠行在我面前；現在我卻說，決不容你們這樣行。因為尊重我的，我必重看他；藐視我的，他必被輕視。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S12_31","010_2_31","1SA","2","31","31","日子必到，我要折斷你的膀臂和你父家的膀臂，使你家中沒有一個老年人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S12_32","010_2_32","1SA","2","32","32","在上帝使以色列人享福的時候，你必看見我居所的敗落。在你家中必永遠沒有一個老年人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S12_33","010_2_33","1SA","2","33","33","我必不從我壇前滅盡你家中的人；那未滅的必使你眼目乾癟、心中憂傷。你家中所生的人都必死在中年。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S12_34","010_2_34","1SA","2","34","34","你的兩個兒子何弗尼、非尼哈所遭遇的事可作你的證據：他們二人必一日同死。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S12_35","010_2_35","1SA","2","35","35","我要為自己立一個忠心的祭司；他必照我的心意而行。我要為他建立堅固的家；他必永遠行在我的受膏者面前。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S12_36","010_2_36","1SA","2","36","36","你家所剩下的人都必來叩拜他，求塊銀子，求個餅，說：求你賜我祭司的職分，好叫我得點餅吃。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S13_1","010_3_1","1SA","3","1","1","童子撒母耳在以利面前事奉耶和華。當那些日子，耶和華的言語稀少，不常有默示。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S13_2","010_3_2","1SA","3","2","2","一日，以利睡臥在自己的地方；他眼目昏花，看不分明。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S13_3","010_3_3","1SA","3","3","3","上帝的燈在上帝耶和華殿內約櫃那裏，還沒有熄滅，撒母耳已經睡了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S13_4","010_3_4","1SA","3","4","4","耶和華呼喚撒母耳。撒母耳說：「我在這裏！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S13_5","010_3_5","1SA","3","5","5","就跑到以利那裏，說：「你呼喚我？我在這裏。」以利回答說：「我沒有呼喚你，你去睡吧。」他就去睡了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S13_6","010_3_6","1SA","3","6","6","耶和華又呼喚撒母耳。撒母耳起來，到以利那裏，說：「你呼喚我？我在這裏。」以利回答說：「我的兒，我沒有呼喚你，你去睡吧。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S13_7","010_3_7","1SA","3","7","7","那時撒母耳還未認識耶和華，也未得耶和華的默示。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S13_8","010_3_8","1SA","3","8","8","耶和華第三次呼喚撒母耳。撒母耳起來，到以利那裏，說：「你又呼喚我？我在這裏。」以利才明白是耶和華呼喚童子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S13_9","010_3_9","1SA","3","9","9","因此以利對撒母耳說：「你仍去睡吧；若再呼喚你，你就說：『耶和華啊，請說，僕人敬聽！』」撒母耳就去，仍睡在原處。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S13_10","010_3_10","1SA","3","10","10","耶和華又來站着，像前三次呼喚說：「撒母耳啊！撒母耳啊！」撒母耳回答說：「請說，僕人敬聽！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S13_11","010_3_11","1SA","3","11","11","耶和華對撒母耳說：「我在以色列中必行一件事，叫聽見的人都必耳鳴。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S13_12","010_3_12","1SA","3","12","12","我指着以利家所說的話，到了時候，我必始終應驗在以利身上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S13_13","010_3_13","1SA","3","13","13","我曾告訴他必永遠降罰與他的家，因他知道兒子作孽，自招咒詛，卻不禁止他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S13_14","010_3_14","1SA","3","14","14","所以我向以利家起誓說：『以利家的罪孽，雖獻祭奉禮物，永不能得贖去。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S13_15","010_3_15","1SA","3","15","15","撒母耳睡到天亮，就開了耶和華的殿門，不敢將默示告訴以利。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S13_16","010_3_16","1SA","3","16","16","以利呼喚撒母耳說：「我兒撒母耳啊！」撒母耳回答說：「我在這裏！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S13_17","010_3_17","1SA","3","17","17","以利說：「耶和華對你說甚麼，你不要向我隱瞞；你若將上帝對你所說的隱瞞一句，願他重重地降罰與你。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S13_18","010_3_18","1SA","3","18","18","撒母耳就把一切話都告訴了以利，並沒有隱瞞。以利說：「這是出於耶和華，願他憑自己的意旨而行。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S13_19","010_3_19","1SA","3","19","19","撒母耳長大了，耶和華與他同在，使他所說的話一句都不落空。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S13_20","010_3_20","1SA","3","20","20","從但到別是巴所有的以色列人都知道耶和華立撒母耳為先知。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S13_21","010_3_21","1SA","3","21","21","耶和華又在示羅顯現；因為耶和華將自己的話默示撒母耳，撒母耳就把這話傳遍以色列地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S14_1","010_4_1","1SA","4","1","1","以色列人出去與非利士人打仗，安營在以便以謝；非利士人安營在亞弗。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S14_2","010_4_2","1SA","4","2","2","非利士人向以色列人擺陣。兩軍交戰的時候，以色列人敗在非利士人面前；非利士人在戰場上殺了他們的軍兵約有四千人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S14_3","010_4_3","1SA","4","3","3","百姓回到營裏，以色列的長老說：「耶和華今日為何使我們敗在非利士人面前呢？我們不如將耶和華的約櫃從示羅抬到我們這裏來，好在我們中間救我們脫離敵人的手。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S14_4","010_4_4","1SA","4","4","4","於是百姓打發人到示羅，從那裏將坐在二基路伯上萬軍之耶和華的約櫃抬來。以利的兩個兒子何弗尼、非尼哈與上帝的約櫃同來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S14_5","010_4_5","1SA","4","5","5","耶和華的約櫃到了營中，以色列眾人就大聲歡呼，地便震動。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S14_6","010_4_6","1SA","4","6","6","非利士人聽見歡呼的聲音，就說：「在希伯來人營裏大聲歡呼，是甚麼緣故呢？」隨後就知道耶和華的約櫃到了營中。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S14_7","010_4_7","1SA","4","7","7","非利士人就懼怕起來，說：「有神到了他們營中」；又說：「我們有禍了！向來不曾有這樣的事。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S14_8","010_4_8","1SA","4","8","8","我們有禍了！誰能救我們脫離這些大能之神的手呢？從前在曠野用各樣災殃擊打埃及人的，就是這些神。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S14_9","010_4_9","1SA","4","9","9","非利士人哪，你們要剛強，要作大丈夫，免得作希伯來人的奴僕，如同他們作你們的奴僕一樣。你們要作大丈夫，與他們爭戰。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S14_10","010_4_10","1SA","4","10","10","非利士人和以色列人打仗，以色列人敗了，各向各家奔逃，被殺的人甚多，以色列的步兵仆倒了三萬。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S14_11","010_4_11","1SA","4","11","11","上帝的約櫃被擄去，以利的兩個兒子何弗尼、非尼哈也都被殺了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S14_12","010_4_12","1SA","4","12","12","當日，有一個便雅憫人從陣上逃跑，衣服撕裂，頭蒙灰塵，來到示羅。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S14_13","010_4_13","1SA","4","13","13","到了的時候，以利正在道旁坐在自己的位上觀望，為上帝的約櫃心裏擔憂。那人進城報信，合城的人就都呼喊起來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S14_14","010_4_14","1SA","4","14","14","以利聽見呼喊的聲音就問說：「這喧嚷是甚麼緣故呢？」那人急忙來報信給以利。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S14_15","010_4_15","1SA","4","15","15","那時以利九十八歲了，眼目發直，不能看見。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S14_16","010_4_16","1SA","4","16","16","那人對以利說：「我是從陣上來的，今日我從陣上逃回。」以利說：「我兒，事情怎樣？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S14_17","010_4_17","1SA","4","17","17","報信的回答說：「以色列人在非利士人面前逃跑，民中被殺的甚多！你的兩個兒子何弗尼、非尼哈也都死了，並且上帝的約櫃被擄去。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S14_18","010_4_18","1SA","4","18","18","他一提上帝的約櫃，以利就從他的位上往後跌倒，在門旁折斷頸項而死；因為他年紀老邁，身體沉重。以利作以色列的士師四十年。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S14_19","010_4_19","1SA","4","19","19","以利的兒婦、非尼哈的妻懷孕將到產期，她聽見上帝的約櫃被擄去，公公和丈夫都死了，就猛然疼痛，曲身生產； ");
INSERT INTO cmn_cu89t_vpl VALUES ("S14_20","010_4_20","1SA","4","20","20","將要死的時候，旁邊站着的婦人們對她說：「不要怕！你生了男孩子了。」她卻不回答，也不放在心上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S14_21","010_4_21","1SA","4","21","21","她給孩子起名叫以迦博，說：「榮耀離開以色列了！」這是因上帝的約櫃被擄去，又因她公公和丈夫都死了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S14_22","010_4_22","1SA","4","22","22","她又說：「榮耀離開以色列，因為上帝的約櫃被擄去了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S15_1","010_5_1","1SA","5","1","1","非利士人將上帝的約櫃從以便以謝抬到亞實突。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S15_2","010_5_2","1SA","5","2","2","非利士人將上帝的約櫃抬進大袞廟，放在大袞的旁邊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S15_3","010_5_3","1SA","5","3","3","次日清早，亞實突人起來，見大袞仆倒在耶和華的約櫃前，臉伏於地，就把大袞仍立在原處。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S15_4","010_5_4","1SA","5","4","4","又次日清早起來，見大袞仆倒在耶和華的約櫃前，臉伏於地，並且大袞的頭和兩手都在門檻上折斷，只剩下大袞的殘體。（ ");
INSERT INTO cmn_cu89t_vpl VALUES ("S15_5","010_5_5","1SA","5","5","5","因此，大袞的祭司和一切進亞實突、大袞廟的人都不踏大袞廟的門檻，直到今日。） ");
INSERT INTO cmn_cu89t_vpl VALUES ("S15_6","010_5_6","1SA","5","6","6","耶和華的手重重加在亞實突人身上，敗壞他們，使他們生痔瘡。亞實突和亞實突的四境都是如此。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S15_7","010_5_7","1SA","5","7","7","亞實突人見這光景，就說：「以色列上帝的約櫃不可留在我們這裏，因為他的手重重加在我們和我們神大袞的身上」； ");
INSERT INTO cmn_cu89t_vpl VALUES ("S15_8","010_5_8","1SA","5","8","8","就打發人去請非利士的眾首領來聚集，問他們說：「我們向以色列上帝的約櫃應當怎樣行呢？」他們回答說：「可以將以色列上帝的約櫃運到迦特去。」於是將以色列上帝的約櫃運到那裏去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S15_9","010_5_9","1SA","5","9","9","運到之後，耶和華的手攻擊那城，使那城的人大大驚慌，無論大小都生痔瘡。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S15_10","010_5_10","1SA","5","10","10","他們就把上帝的約櫃送到以革倫。上帝的約櫃到了，以革倫人就喊嚷起來說：「他們將以色列上帝的約櫃運到我們這裏，要害我們和我們的眾民！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S15_11","010_5_11","1SA","5","11","11","於是打發人去請非利士的眾首領來，說：「願你們將以色列上帝的約櫃送回原處，免得害了我們和我們的眾民！」原來上帝的手重重攻擊那城，城中的人有因驚慌而死的； ");
INSERT INTO cmn_cu89t_vpl VALUES ("S15_12","010_5_12","1SA","5","12","12","未曾死的人都生了痔瘡。合城呼號，聲音上達於天。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S16_1","010_6_1","1SA","6","1","1","耶和華的約櫃在非利士人之地七個月。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S16_2","010_6_2","1SA","6","2","2","非利士人將祭司和占卜的聚了來，問他們說：「我們向耶和華的約櫃應當怎樣行？請指示我們用何法將約櫃送回原處。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S16_3","010_6_3","1SA","6","3","3","他們說：「若要將以色列上帝的約櫃送回去，不可空空地送去，必要給他獻賠罪的禮物，然後你們可得痊癒，並知道他的手為何不離開你們。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S16_4","010_6_4","1SA","6","4","4","非利士人說：「應當用甚麼獻為賠罪的禮物呢？」他們回答說：「當照非利士首領的數目，用五個金痔瘡，五個金老鼠，因為在你們眾人和你們首領的身上都是一樣的災。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S16_5","010_6_5","1SA","6","5","5","所以當製造你們痔瘡的像和毀壞你們田地老鼠的像，並要歸榮耀給以色列的上帝，或者他向你們和你們的神，並你們的田地，把手放輕些。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S16_6","010_6_6","1SA","6","6","6","你們為何硬着心像埃及人和法老一樣呢？上帝在埃及人中間行奇事，埃及人豈不釋放以色列人，他們就去了嗎？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("S16_7","010_6_7","1SA","6","7","7","現在你們應當造一輛新車，將兩隻未曾負軛有乳的母牛套在車上，使牛犢回家去，離開母牛。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S16_8","010_6_8","1SA","6","8","8","把耶和華的約櫃放在車上，將所獻賠罪的金物裝在匣子裏，放在櫃旁，將櫃送去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S16_9","010_6_9","1SA","6","9","9","你們要看看：車若直行以色列的境界到伯‧示麥去，這大災就是耶和華降在我們身上的；若不然，便可以知道不是他的手擊打我們，是我們偶然遇見的。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S16_10","010_6_10","1SA","6","10","10","非利士人就這樣行：將兩隻有乳的母牛套在車上，將牛犢關在家裏， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S16_11","010_6_11","1SA","6","11","11","把耶和華的約櫃和裝金老鼠並金痔瘡像的匣子都放在車上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S16_12","010_6_12","1SA","6","12","12","牛直行大道，往伯‧示麥去，一面走一面叫，不偏左右。非利士的首領跟在後面，直到伯‧示麥的境界。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S16_13","010_6_13","1SA","6","13","13","伯‧示麥人正在平原收割麥子，舉目看見約櫃，就歡喜了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S16_14","010_6_14","1SA","6","14","14","車到了伯‧示麥人約書亞的田間，就站住了。在那裏有一塊大磐石，他們把車劈了，將兩隻母牛獻給耶和華為燔祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S16_15","010_6_15","1SA","6","15","15","利未人將耶和華的約櫃和裝金物的匣子拿下來，放在大磐石上。當日伯‧示麥人將燔祭和平安祭獻給耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S16_16","010_6_16","1SA","6","16","16","非利士人的五個首領看見，當日就回以革倫去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S16_17","010_6_17","1SA","6","17","17","非利士人獻給耶和華作賠罪的金痔瘡像，就是這些：一個是為亞實突，一個是為迦薩，一個是為亞實基倫，一個是為迦特，一個是為以革倫。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S16_18","010_6_18","1SA","6","18","18","金老鼠的數目是照非利士五個首領的城邑，就是堅固的城邑和鄉村，以及大磐石。這磐石是放耶和華約櫃的，到今日還在伯‧示麥人約書亞的田間。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S16_19","010_6_19","1SA","6","19","19","耶和華因伯‧示麥人擅觀他的約櫃，就擊殺了他們七十人；那時有五萬人在那裏。百姓因耶和華大大擊殺他們，就哀哭了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S16_20","010_6_20","1SA","6","20","20","伯‧示麥人說：「誰能在耶和華這聖潔的上帝面前侍立呢？這約櫃可以從我們這裏送到誰那裏去呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S16_21","010_6_21","1SA","6","21","21","於是打發人去見基列‧耶琳的居民，說：「非利士人將耶和華的約櫃送回來了，你們下來將約櫃接到你們那裏去吧！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S17_1","010_7_1","1SA","7","1","1","基列‧耶琳人就下來，將耶和華的約櫃接上去，放在山上亞比拿達的家中，分派他兒子以利亞撒看守耶和華的約櫃。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S17_2","010_7_2","1SA","7","2","2","約櫃在基列‧耶琳許久。過了二十年，以色列全家都傾向耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S17_3","010_7_3","1SA","7","3","3","撒母耳對以色列全家說：「你們若一心歸順耶和華，就要把外邦的神和亞斯她錄從你們中間除掉，專心歸向耶和華，單單地事奉他。他必救你們脫離非利士人的手。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S17_4","010_7_4","1SA","7","4","4","以色列人就除掉諸巴力和亞斯她錄，單單地事奉耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S17_5","010_7_5","1SA","7","5","5","撒母耳說：「要使以色列眾人聚集在米斯巴，我好為你們禱告耶和華。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S17_6","010_7_6","1SA","7","6","6","他們就聚集在米斯巴，打水澆在耶和華面前，當日禁食，說：「我們得罪了耶和華。」於是撒母耳在米斯巴審判以色列人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S17_7","010_7_7","1SA","7","7","7","非利士人聽見以色列人聚集在米斯巴，非利士的首領就上來要攻擊以色列人。以色列人聽見，就懼怕非利士人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S17_8","010_7_8","1SA","7","8","8","以色列人對撒母耳說：「願你不住地為我們呼求耶和華－我們的上帝，救我們脫離非利士人的手。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S17_9","010_7_9","1SA","7","9","9","撒母耳就把一隻吃奶的羊羔獻與耶和華作全牲的燔祭，為以色列人呼求耶和華；耶和華就應允他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S17_10","010_7_10","1SA","7","10","10","撒母耳正獻燔祭的時候，非利士人前來要與以色列人爭戰。當日，耶和華大發雷聲，驚亂非利士人，他們就敗在以色列人面前。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S17_11","010_7_11","1SA","7","11","11","以色列人從米斯巴出來，追趕非利士人，擊殺他們，直到伯‧甲的下邊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S17_12","010_7_12","1SA","7","12","12","撒母耳將一塊石頭立在米斯巴和善的中間，給石頭起名叫以便以謝，說：「到如今耶和華都幫助我們。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S17_13","010_7_13","1SA","7","13","13","從此，非利士人就被制伏，不敢再入以色列人的境內。撒母耳作士師的時候，耶和華的手攻擊非利士人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S17_14","010_7_14","1SA","7","14","14","非利士人所取以色列人的城邑，從以革倫直到迦特，都歸以色列人了。屬這些城的四境，以色列人也從非利士人手下收回。那時以色列人與亞摩利人和好。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S17_15","010_7_15","1SA","7","15","15","撒母耳平生作以色列的士師。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S17_16","010_7_16","1SA","7","16","16","他每年巡行到伯特利、吉甲、米斯巴，在這幾處審判以色列人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S17_17","010_7_17","1SA","7","17","17","隨後回到拉瑪，因為他的家在那裏；也在那裏審判以色列人，且為耶和華築了一座壇。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S18_1","010_8_1","1SA","8","1","1","撒母耳年紀老邁，就立他兒子作以色列的士師。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S18_2","010_8_2","1SA","8","2","2","長子名叫約珥，次子名叫亞比亞；他們在別是巴作士師。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S18_3","010_8_3","1SA","8","3","3","他兒子不行他的道，貪圖財利，收受賄賂，屈枉正直。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S18_4","010_8_4","1SA","8","4","4","以色列的長老都聚集，來到拉瑪見撒母耳， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S18_5","010_8_5","1SA","8","5","5","對他說：「你年紀老邁了，你兒子不行你的道。現在求你為我們立一個王治理我們，像列國一樣。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S18_6","010_8_6","1SA","8","6","6","撒母耳不喜悅他們說「立一個王治理我們」，他就禱告耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S18_7","010_8_7","1SA","8","7","7","耶和華對撒母耳說：「百姓向你說的一切話，你只管依從；因為他們不是厭棄你，乃是厭棄我，不要我作他們的王。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S18_8","010_8_8","1SA","8","8","8","自從我領他們出埃及到如今，他們常常離棄我，事奉別神。現在他們向你所行的，是照他們素來所行的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S18_9","010_8_9","1SA","8","9","9","故此你要依從他們的話，只是當警戒他們，告訴他們將來那王怎樣管轄他們。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S18_10","010_8_10","1SA","8","10","10","撒母耳將耶和華的話都傳給求他立王的百姓，說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("S18_11","010_8_11","1SA","8","11","11","「管轄你們的王必這樣行：他必派你們的兒子為他趕車、跟馬，奔走在車前； ");
INSERT INTO cmn_cu89t_vpl VALUES ("S18_12","010_8_12","1SA","8","12","12","又派他們作千夫長、五十夫長，為他耕種田地，收割莊稼，打造軍器和車上的器械； ");
INSERT INTO cmn_cu89t_vpl VALUES ("S18_13","010_8_13","1SA","8","13","13","必取你們的女兒為他製造香膏，做飯烤餅； ");
INSERT INTO cmn_cu89t_vpl VALUES ("S18_14","010_8_14","1SA","8","14","14","也必取你們最好的田地、葡萄園、橄欖園賜給他的臣僕。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S18_15","010_8_15","1SA","8","15","15","你們的糧食和葡萄園所出的，他必取十分之一給他的太監和臣僕； ");
INSERT INTO cmn_cu89t_vpl VALUES ("S18_16","010_8_16","1SA","8","16","16","又必取你們的僕人婢女，健壯的少年人和你們的驢，供他的差役。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S18_17","010_8_17","1SA","8","17","17","你們的羊群他必取十分之一，你們也必作他的僕人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S18_18","010_8_18","1SA","8","18","18","那時你們必因所選的王哀求耶和華，耶和華卻不應允你們。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S18_19","010_8_19","1SA","8","19","19","百姓竟不肯聽撒母耳的話，說：「不然！我們定要一個王治理我們， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S18_20","010_8_20","1SA","8","20","20","使我們像列國一樣，有王治理我們，統領我們，為我們爭戰。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S18_21","010_8_21","1SA","8","21","21","撒母耳聽見百姓這一切話，就將這話陳明在耶和華面前。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S18_22","010_8_22","1SA","8","22","22","耶和華對撒母耳說：「你只管依從他們的話，為他們立王。」撒母耳對以色列人說：「你們各歸各城去吧！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S19_1","010_9_1","1SA","9","1","1","有一個便雅憫人，名叫基士，是便雅憫人亞斐亞的玄孫，比歌拉的曾孫，洗羅的孫子，亞別的兒子，是個大能的勇士。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S19_2","010_9_2","1SA","9","2","2","他有一個兒子，名叫掃羅，又健壯、又俊美，在以色列人中沒有一個能比他的；身體比眾民高過一頭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S19_3","010_9_3","1SA","9","3","3","掃羅的父親基士丟了幾頭驢，他就吩咐兒子掃羅說：「你帶一個僕人去尋找驢。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S19_4","010_9_4","1SA","9","4","4","掃羅就走過以法蓮山地，又過沙利沙地，都沒有找着；又過沙琳地，驢也不在那裏；又過便雅憫地，還沒有找着。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S19_5","010_9_5","1SA","9","5","5","到了蘇弗地，掃羅對跟隨他的僕人說：「我們不如回去，恐怕我父親不為驢掛心，反為我們擔憂。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S19_6","010_9_6","1SA","9","6","6","僕人說：「這城裏有一位神人，是眾人所尊重的，凡他所說的全都應驗。我們不如往他那裏去，或者他能將我們當走的路指示我們。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S19_7","010_9_7","1SA","9","7","7","掃羅對僕人說：「我們若去，有甚麼可以送那人呢？我們囊中的食物都吃盡了，也沒有禮物可以送那神人，我們還有甚麼沒有？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S19_8","010_9_8","1SA","9","8","8","僕人回答掃羅說：「我手裏有銀子一舍客勒的四分之一，可以送那神人，請他指示我們當走的路。」（ ");
INSERT INTO cmn_cu89t_vpl VALUES ("S19_9","010_9_9","1SA","9","9","9","從前以色列中，若有人去問上帝，就說：「我們問先見去吧！」現在稱為「先知」的，從前稱為「先見」。） ");
INSERT INTO cmn_cu89t_vpl VALUES ("S19_10","010_9_10","1SA","9","10","10","掃羅對僕人說：「你說的是，我們可以去。」於是他們往神人所住的城裏去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S19_11","010_9_11","1SA","9","11","11","他們上坡要進城，就遇見幾個少年女子出來打水，問她們說：「先見在這裏沒有？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S19_12","010_9_12","1SA","9","12","12","女子回答說：「在這裏，他在你們前面。快去吧！他今日正到城裏，因為今日百姓要在邱壇獻祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S19_13","010_9_13","1SA","9","13","13","在他還沒有上邱壇吃祭物之先，你們一進城必遇見他；因他未到，百姓不能吃，必等他先祝祭，然後請的客才吃。現在你們上去，這時候必遇見他。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S19_14","010_9_14","1SA","9","14","14","二人就上去；將進城的時候，撒母耳正迎着他們來，要上邱壇去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S19_15","010_9_15","1SA","9","15","15","掃羅未到的前一日，耶和華已經指示撒母耳說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("S19_16","010_9_16","1SA","9","16","16","「明日這時候，我必使一個人從便雅憫地到你這裏來，你要膏他作我民以色列的君。他必救我民脫離非利士人的手；因我民的哀聲上達於我，我就眷顧他們。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S19_17","010_9_17","1SA","9","17","17","撒母耳看見掃羅的時候，耶和華對他說：「看哪，這人就是我對你所說的，他必治理我的民。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S19_18","010_9_18","1SA","9","18","18","掃羅在城門裏走到撒母耳跟前，說：「請告訴我，先見的寓所在哪裏？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S19_19","010_9_19","1SA","9","19","19","撒母耳回答說：「我就是先見。你在我前面上邱壇去，因為你們今日必與我同席；明日早晨我送你去，將你心裏的事都告訴你。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S19_20","010_9_20","1SA","9","20","20","至於你前三日所丟的那幾頭驢，你心裏不必掛念，已經找着了。以色列眾人所仰慕的是誰呢？不是仰慕你和你父的全家嗎？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S19_21","010_9_21","1SA","9","21","21","掃羅說：「我不是以色列支派中至小的便雅憫人嗎？我家不是便雅憫支派中至小的家嗎？你為何對我說這樣的話呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S19_22","010_9_22","1SA","9","22","22","撒母耳領掃羅和他僕人進了客堂，使他們在請來的客中坐首位；客約有三十個人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S19_23","010_9_23","1SA","9","23","23","撒母耳對廚役說：「我交給你收存的那一分祭肉現在可以拿來。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S19_24","010_9_24","1SA","9","24","24","廚役就把收存的腿拿來，擺在掃羅面前，撒母耳說：「這是所留下的，放在你面前。吃吧！因我請百姓的時候，特意為你存留這肉到此時。」 當日，掃羅就與撒母耳同席。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S19_25","010_9_25","1SA","9","25","25","眾人從邱壇下來進城，撒母耳和掃羅在房頂上說話。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S19_26","010_9_26","1SA","9","26","26","次日清早起來，黎明的時候，掃羅在房頂上。撒母耳呼叫他說：「起來吧，我好送你回去。」掃羅就起來，和撒母耳一同出去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S19_27","010_9_27","1SA","9","27","27","二人下到城角，撒母耳對掃羅說：「要吩咐僕人先走（僕人就先走了）；你且站在這裏，等我將上帝的話傳與你聽。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S110_1","010_10_1","1SA","10","1","1","撒母耳拿瓶膏油倒在掃羅的頭上，與他親嘴，說：「這不是耶和華膏你作他產業的君嗎？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("S110_2","010_10_2","1SA","10","2","2","你今日與我離別之後，在便雅憫境內的泄撒，靠近拉結的墳墓，要遇見兩個人。他們必對你說：『你去找的那幾頭驢已經找着了。現在你父親不為驢掛心，反為你擔憂，說：我為兒子怎麼才好呢？』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S110_3","010_10_3","1SA","10","3","3","你從那裏往前行，到了他泊的橡樹那裏，必遇見三個往伯特利去拜上帝的人：一個帶着三隻山羊羔，一個帶着三個餅，一個帶着一皮袋酒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S110_4","010_10_4","1SA","10","4","4","他們必問你安，給你兩個餅，你就從他們手中接過來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S110_5","010_10_5","1SA","10","5","5","此後你到上帝的山，在那裏有非利士人的防兵。你到了城的時候，必遇見一班先知從邱壇下來，前面有鼓瑟的、擊鼓的、吹笛的、彈琴的，他們都受感說話。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S110_6","010_10_6","1SA","10","6","6","耶和華的靈必大大感動你，你就與他們一同受感說話；你要變為新人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S110_7","010_10_7","1SA","10","7","7","這兆頭臨到你，你就可以趁時而做，因為上帝與你同在。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S110_8","010_10_8","1SA","10","8","8","你當在我以先下到吉甲，我也必下到那裏獻燔祭和平安祭。你要等候七日，等我到了那裏，指示你當行的事。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S110_9","010_10_9","1SA","10","9","9","掃羅轉身離別撒母耳，上帝就賜他一個新心。當日這一切兆頭都應驗了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S110_10","010_10_10","1SA","10","10","10","掃羅到了那山，有一班先知遇見他，上帝的靈大大感動他，他就在先知中受感說話。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S110_11","010_10_11","1SA","10","11","11","素來認識掃羅的，看見他和先知一同受感說話，就彼此說：「基士的兒子遇見甚麼了？掃羅也列在先知中嗎？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S110_12","010_10_12","1SA","10","12","12","那地方有一個人說：「這些人的父親是誰呢？」此後有句俗語說：「掃羅也列在先知中嗎？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S110_13","010_10_13","1SA","10","13","13","掃羅受感說話已畢，就上邱壇去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S110_14","010_10_14","1SA","10","14","14","掃羅的叔叔問掃羅和他僕人說：「你們往哪裏去了？」回答說：「找驢去了。我們見沒有驢，就到了撒母耳那裏。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S110_15","010_10_15","1SA","10","15","15","掃羅的叔叔說：「請將撒母耳向你們所說的話告訴我。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S110_16","010_10_16","1SA","10","16","16","掃羅對他叔叔說：「他明明地告訴我們驢已經找着了。」至於撒母耳所說的國事，掃羅卻沒有告訴叔叔。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S110_17","010_10_17","1SA","10","17","17","撒母耳將百姓招聚到米斯巴耶和華那裏， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S110_18","010_10_18","1SA","10","18","18","對他們說：「耶和華－以色列的上帝如此說：『我領你們以色列人出埃及，救你們脫離埃及人的手，又救你們脫離欺壓你們各國之人的手。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S110_19","010_10_19","1SA","10","19","19","你們今日卻厭棄了救你們脫離一切災難的上帝，說：『求你立一個王治理我們。』現在你們應當按着支派、宗族都站在耶和華面前。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S110_20","010_10_20","1SA","10","20","20","於是，撒母耳使以色列眾支派近前來掣籤，就掣出便雅憫支派來； ");
INSERT INTO cmn_cu89t_vpl VALUES ("S110_21","010_10_21","1SA","10","21","21","又使便雅憫支派按着宗族近前來，就掣出瑪特利族，從其中又掣出基士的兒子掃羅。眾人尋找他卻尋不着， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S110_22","010_10_22","1SA","10","22","22","就問耶和華說：「那人到這裏來了沒有？」耶和華說：「他藏在器具中了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S110_23","010_10_23","1SA","10","23","23","眾人就跑去從那裏領出他來。他站在百姓中間，身體比眾民高過一頭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S110_24","010_10_24","1SA","10","24","24","撒母耳對眾民說：「你們看耶和華所揀選的人，眾民中有可比他的嗎？」眾民就大聲歡呼說：「願王萬歲！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S110_25","010_10_25","1SA","10","25","25","撒母耳將國法對百姓說明，又記在書上，放在耶和華面前，然後遣散眾民，各回各家去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S110_26","010_10_26","1SA","10","26","26","掃羅往基比亞回家去，有上帝感動的一群人跟隨他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S110_27","010_10_27","1SA","10","27","27","但有些匪徒說：「這人怎能救我們呢？」就藐視他，沒有送他禮物；掃羅卻不理會。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S111_1","010_11_1","1SA","11","1","1","亞捫人的王拿轄上來，對着基列‧雅比安營。雅比眾人對拿轄說：「你與我們立約，我們就服事你。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S111_2","010_11_2","1SA","11","2","2","亞捫人拿轄說：「你們若由我剜出你們各人的右眼，以此凌辱以色列眾人，我就與你們立約。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S111_3","010_11_3","1SA","11","3","3","雅比的長老對他說：「求你寬容我們七日，等我們打發人往以色列的全境去；若沒有人救我們，我們就出來歸順你。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S111_4","010_11_4","1SA","11","4","4","使者到了掃羅住的基比亞，將這話說給百姓聽，百姓就都放聲而哭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S111_5","010_11_5","1SA","11","5","5","掃羅正從田間趕牛回來，問說：「百姓為甚麼哭呢？」眾人將雅比人的話告訴他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S111_6","010_11_6","1SA","11","6","6","掃羅聽見這話，就被上帝的靈大大感動，甚是發怒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S111_7","010_11_7","1SA","11","7","7","他將一對牛切成塊子，託付使者傳送以色列的全境，說：「凡不出來跟隨掃羅和撒母耳的，也必這樣切開他的牛。」於是耶和華使百姓懼怕，他們就都出來，如同一人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S111_8","010_11_8","1SA","11","8","8","掃羅在比色數點他們：以色列人有三十萬，猶大人有三萬。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S111_9","010_11_9","1SA","11","9","9","眾人對那使者說：「你們要回覆基列‧雅比人說，明日太陽近午的時候，你們必得解救。」使者回去告訴雅比人，他們就歡喜了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S111_10","010_11_10","1SA","11","10","10","於是雅比人對亞捫人說：「明日我們出來歸順你們，你們可以隨意待我們。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S111_11","010_11_11","1SA","11","11","11","第二日，掃羅將百姓分為三隊，在晨更的時候入了亞捫人的營，擊殺他們直到太陽近午，剩下的人都逃散，沒有二人同在一處的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S111_12","010_11_12","1SA","11","12","12","百姓對撒母耳說：「那說『掃羅豈能管理我們』的是誰呢？可以將他交出來，我們好殺死他。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S111_13","010_11_13","1SA","11","13","13","掃羅說：「今日耶和華在以色列中施行拯救，所以不可殺人。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S111_14","010_11_14","1SA","11","14","14","撒母耳對百姓說：「我們要往吉甲去，在那裏立國。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S111_15","010_11_15","1SA","11","15","15","眾百姓就到了吉甲那裏，在耶和華面前立掃羅為王，又在耶和華面前獻平安祭。掃羅和以色列眾人大大歡喜。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S112_1","010_12_1","1SA","12","1","1","撒母耳對以色列眾人說：「你們向我所求的，我已應允了，為你們立了一個王； ");
INSERT INTO cmn_cu89t_vpl VALUES ("S112_2","010_12_2","1SA","12","2","2","現在有這王在你們前面行。我已年老髮白，我的兒子都在你們這裏。我從幼年直到今日都在你們前面行。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S112_3","010_12_3","1SA","12","3","3","我在這裏，你們要在耶和華和他的受膏者面前給我作見證。我奪過誰的牛，搶過誰的驢，欺負過誰，虐待過誰，從誰手裏受過賄賂因而眼瞎呢？若有，我必償還。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S112_4","010_12_4","1SA","12","4","4","眾人說：「你未曾欺負我們，虐待我們，也未曾從誰手裏受過甚麼。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S112_5","010_12_5","1SA","12","5","5","撒母耳對他們說：「你們在我手裏沒有找着甚麼，有耶和華和他的受膏者今日為證。」他們說：「願他為證。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S112_6","010_12_6","1SA","12","6","6","撒母耳對百姓說：「從前立摩西、亞倫，又領你們列祖出埃及地的是耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S112_7","010_12_7","1SA","12","7","7","現在你們要站住，等我在耶和華面前對你們講論耶和華向你們和你們列祖所行一切公義的事。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S112_8","010_12_8","1SA","12","8","8","從前雅各到了埃及，後來你們列祖呼求耶和華，耶和華就差遣摩西、亞倫領你們列祖出埃及，使他們在這地方居住。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S112_9","010_12_9","1SA","12","9","9","他們卻忘記耶和華－他們的上帝，他就把他們付與夏瑣將軍西西拉的手裏，和非利士人並摩押王的手裏。於是這些人常來攻擊他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S112_10","010_12_10","1SA","12","10","10","他們就呼求耶和華說：『我們離棄耶和華，事奉巴力和亞斯她錄，是有罪了。現在求你救我們脫離仇敵的手，我們必事奉你。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S112_11","010_12_11","1SA","12","11","11","耶和華就差遣耶路‧巴力、比但、耶弗他、撒母耳救你們脫離四圍仇敵的手，你們才安然居住。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S112_12","010_12_12","1SA","12","12","12","你們見亞捫人的王拿轄來攻擊你們，就對我說：『我們定要一個王治理我們。』其實耶和華－你們的上帝是你們的王。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S112_13","010_12_13","1SA","12","13","13","現在，你們所求所選的王在這裏。看哪，耶和華已經為你們立王了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S112_14","010_12_14","1SA","12","14","14","你們若敬畏耶和華，事奉他，聽從他的話，不違背他的命令，你們和治理你們的王也都順從耶和華－你們的上帝就好了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S112_15","010_12_15","1SA","12","15","15","倘若不聽從耶和華的話，違背他的命令，耶和華的手必攻擊你們，像從前攻擊你們列祖一樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S112_16","010_12_16","1SA","12","16","16","現在你們要站住，看耶和華在你們眼前要行一件大事。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S112_17","010_12_17","1SA","12","17","17","這不是割麥子的時候嗎？我求告耶和華，他必打雷降雨，使你們又知道又看出，你們求立王的事是在耶和華面前犯大罪了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S112_18","010_12_18","1SA","12","18","18","於是撒母耳求告耶和華，耶和華就在這日打雷降雨，眾民便甚懼怕耶和華和撒母耳。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S112_19","010_12_19","1SA","12","19","19","眾民對撒母耳說：「求你為僕人們禱告耶和華－你的上帝，免得我們死亡；因為我們求立王的事正是罪上加罪了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S112_20","010_12_20","1SA","12","20","20","撒母耳對百姓說：「不要懼怕！你們雖然行了這惡，卻不要偏離耶和華，只要盡心事奉他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S112_21","010_12_21","1SA","12","21","21","若偏離耶和華去順從那不能救人的虛神是無益的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S112_22","010_12_22","1SA","12","22","22","耶和華既喜悅選你們作他的子民，就必因他的大名不撇棄你們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S112_23","010_12_23","1SA","12","23","23","至於我，斷不停止為你們禱告，以致得罪耶和華。我必以善道正路指教你們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S112_24","010_12_24","1SA","12","24","24","只要你們敬畏耶和華，誠誠實實地盡心事奉他，想念他向你們所行的事何等大。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S112_25","010_12_25","1SA","12","25","25","你們若仍然作惡，你們和你們的王必一同滅亡。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S113_1","010_13_1","1SA","13","1","1","掃羅登基年四十歲；作以色列王二年的時候， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S113_2","010_13_2","1SA","13","2","2","就從以色列中揀選了三千人：二千跟隨掃羅在密抹和伯特利山，一千跟隨約拿單在便雅憫的基比亞；其餘的人掃羅都打發各回各家去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S113_3","010_13_3","1SA","13","3","3","約拿單攻擊在迦巴的非利士人的防營，非利士人聽見了。掃羅就在遍地吹角，意思說，要使希伯來人聽見。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S113_4","010_13_4","1SA","13","4","4","以色列眾人聽見掃羅攻擊非利士人的防營，又聽見以色列人為非利士人所憎惡，就跟隨掃羅聚集在吉甲。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S113_5","010_13_5","1SA","13","5","5","非利士人聚集，要與以色列人爭戰，有車三萬輛，馬兵六千，步兵像海邊的沙那樣多，就上來在伯‧亞文東邊的密抹安營。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S113_6","010_13_6","1SA","13","6","6","以色列百姓見自己危急窘迫，就藏在山洞、叢林、石穴、隱密處，和坑中。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S113_7","010_13_7","1SA","13","7","7","有些希伯來人過了約旦河，逃到迦得和基列地。掃羅還是在吉甲，百姓都戰戰兢兢地跟隨他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S113_8","010_13_8","1SA","13","8","8","掃羅照着撒母耳所定的日期等了七日。撒母耳還沒有來到吉甲，百姓也離開掃羅散去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S113_9","010_13_9","1SA","13","9","9","掃羅說：「把燔祭和平安祭帶到我這裏來。」掃羅就獻上燔祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S113_10","010_13_10","1SA","13","10","10","剛獻完燔祭，撒母耳就到了。掃羅出去迎接他，要問他好。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S113_11","010_13_11","1SA","13","11","11","撒母耳說：「你做的是甚麼事呢？」掃羅說：「因為我見百姓離開我散去，你也不照所定的日期來到，而且非利士人聚集在密抹。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S113_12","010_13_12","1SA","13","12","12","所以我心裏說：恐怕我沒有禱告耶和華。非利士人下到吉甲攻擊我，我就勉強獻上燔祭。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S113_13","010_13_13","1SA","13","13","13","撒母耳對掃羅說：「你做了糊塗事了，沒有遵守耶和華－你上帝所吩咐你的命令。若遵守，耶和華必在以色列中堅立你的王位，直到永遠。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S113_14","010_13_14","1SA","13","14","14","現在你的王位必不長久。耶和華已經尋着一個合他心意的人，立他作百姓的君，因為你沒有遵守耶和華所吩咐你的。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S113_15","010_13_15","1SA","13","15","15","撒母耳就起來，從吉甲上到便雅憫的基比亞。 掃羅數點跟隨他的，約有六百人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S113_16","010_13_16","1SA","13","16","16","掃羅和他兒子約拿單，並跟隨他們的人，都住在便雅憫的迦巴；但非利士人安營在密抹。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S113_17","010_13_17","1SA","13","17","17","有掠兵從非利士營中出來，分為三隊：一隊往俄弗拉向書亞地去， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S113_18","010_13_18","1SA","13","18","18","一隊往伯‧和崙去，一隊往洗波音谷對面的地境向曠野去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S113_19","010_13_19","1SA","13","19","19","那時，以色列全地沒有一個鐵匠；因為非利士人說，恐怕希伯來人製造刀槍。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S113_20","010_13_20","1SA","13","20","20","以色列人要磨鋤、犂、斧、鏟，就下到非利士人那裏去磨。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S113_21","010_13_21","1SA","13","21","21","但有銼可以銼鏟、犂、三齒叉、斧子，並趕牛錐。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S113_22","010_13_22","1SA","13","22","22","所以到了爭戰的日子，跟隨掃羅和約拿單的人沒有一個手裏有刀有槍的，惟獨掃羅和他兒子約拿單有。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S113_23","010_13_23","1SA","13","23","23","非利士人的一隊防兵到了密抹的隘口。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S114_1","010_14_1","1SA","14","1","1","有一日，掃羅的兒子約拿單對拿他兵器的少年人說：「我們不如過到那邊，到非利士人的防營那裏去。」但他沒有告訴父親。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S114_2","010_14_2","1SA","14","2","2","掃羅在基比亞的儘邊，坐在米磯崙的石榴樹下，跟隨他的約有六百人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S114_3","010_14_3","1SA","14","3","3","在那裏有亞希突的兒子亞希亞，穿着以弗得。（亞希突是以迦博的哥哥，非尼哈的兒子，以利的孫子。以利從前在示羅作耶和華的祭司。）約拿單去了，百姓卻不知道。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S114_4","010_14_4","1SA","14","4","4","約拿單要從隘口過到非利士防營那裏去。這隘口兩邊各有一個山峰：一名播薛，一名西尼； ");
INSERT INTO cmn_cu89t_vpl VALUES ("S114_5","010_14_5","1SA","14","5","5","一峰向北，與密抹相對，一峰向南，與迦巴相對。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S114_6","010_14_6","1SA","14","6","6","約拿單對拿兵器的少年人說：「我們不如過到未受割禮人的防營那裏去，或者耶和華為我們施展能力；因為耶和華使人得勝，不在乎人多人少。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S114_7","010_14_7","1SA","14","7","7","拿兵器的對他說：「隨你的心意行吧。你可以上去，我必跟隨你，與你同心。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S114_8","010_14_8","1SA","14","8","8","約拿單說：「我們要過到那些人那裏去，使他們看見我們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S114_9","010_14_9","1SA","14","9","9","他們若對我們說：『你們站住，等我們到你們那裏去』，我們就站住，不上他們那裏去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S114_10","010_14_10","1SA","14","10","10","他們若說：『你們上到我們這裏來』，這話就是我們的證據；我們便上去，因為耶和華將他們交在我們手裏了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S114_11","010_14_11","1SA","14","11","11","二人就使非利士的防兵看見。非利士人說：「希伯來人從所藏的洞穴裏出來了！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S114_12","010_14_12","1SA","14","12","12","防兵對約拿單和拿兵器的人說：「你們上到這裏來，我們有一件事指示你們。」約拿單就對拿兵器的人說：「你跟隨我上去，因為耶和華將他們交在以色列人手裏了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S114_13","010_14_13","1SA","14","13","13","約拿單就爬上去，拿兵器的人跟隨他。約拿單殺倒非利士人，拿兵器的人也隨着殺他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S114_14","010_14_14","1SA","14","14","14","約拿單和拿兵器的人起頭所殺的約有二十人，都在一畝地的半犂溝之內。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S114_15","010_14_15","1SA","14","15","15","於是在營中、在田野、在眾民內都有戰兢，防兵和掠兵也都戰兢，地也震動，戰兢之勢甚大。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S114_16","010_14_16","1SA","14","16","16","在便雅憫的基比亞，掃羅的守望兵看見非利士的軍眾潰散，四圍亂竄。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S114_17","010_14_17","1SA","14","17","17","掃羅就對跟隨他的民說：「你們查點查點，看從我們這裏出去的是誰？」他們一查點，就知道約拿單和拿兵器的人沒有在這裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S114_18","010_14_18","1SA","14","18","18","那時上帝的約櫃在以色列人那裏。掃羅對亞希亞說：「你將上帝的約櫃運了來。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S114_19","010_14_19","1SA","14","19","19","掃羅正與祭司說話的時候，非利士營中的喧嚷越發大了；掃羅就對祭司說：「停手吧！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S114_20","010_14_20","1SA","14","20","20","掃羅和跟隨他的人都聚集，來到戰場，看見非利士人用刀互相擊殺，大大惶亂。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S114_21","010_14_21","1SA","14","21","21","從前由四方來跟隨非利士軍的希伯來人現在也轉過來，幫助跟隨掃羅和約拿單的以色列人了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S114_22","010_14_22","1SA","14","22","22","那藏在以法蓮山地的以色列人聽說非利士人逃跑，就出來緊緊地追殺他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S114_23","010_14_23","1SA","14","23","23","那日，耶和華使以色列人得勝，一直戰到伯‧亞文。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S114_24","010_14_24","1SA","14","24","24","掃羅叫百姓起誓說，凡不等到晚上向敵人報完了仇吃甚麼的，必受咒詛。因此這日百姓沒有吃甚麼，就極其困憊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S114_25","010_14_25","1SA","14","25","25","眾民進入樹林，見有蜜在地上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S114_26","010_14_26","1SA","14","26","26","他們進了樹林，見有蜜流下來，卻沒有人敢用手取蜜入口，因為他們怕那誓言。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S114_27","010_14_27","1SA","14","27","27","約拿單沒有聽見他父親叫百姓起誓，所以伸手中的杖，用杖頭蘸在蜂房裏，轉手送入口內，眼睛就明亮了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S114_28","010_14_28","1SA","14","28","28","百姓中有一人對他說：「你父親曾叫百姓嚴嚴地起誓說，今日吃甚麼的，必受咒詛；因此百姓就疲乏了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S114_29","010_14_29","1SA","14","29","29","約拿單說：「我父親連累你們了。你看，我嘗了這一點蜜，眼睛就明亮了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S114_30","010_14_30","1SA","14","30","30","今日百姓若任意吃了從仇敵所奪的物，擊殺的非利士人豈不更多嗎？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S114_31","010_14_31","1SA","14","31","31","這日，以色列人擊殺非利士人，從密抹直到亞雅崙。百姓甚是疲乏， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S114_32","010_14_32","1SA","14","32","32","就急忙將所奪的牛羊和牛犢宰於地上，肉還帶血就吃了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S114_33","010_14_33","1SA","14","33","33","有人告訴掃羅說：「百姓吃帶血的肉，得罪耶和華了。」掃羅說：「你們有罪了，今日要將大石頭滾到我這裏來。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S114_34","010_14_34","1SA","14","34","34","掃羅又說：「你們散在百姓中，對他們說，你們各人將牛羊牽到我這裏來宰了吃，不可吃帶血的肉得罪耶和華。」這夜，百姓就把牛羊牽到那裏宰了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S114_35","010_14_35","1SA","14","35","35","掃羅為耶和華築了一座壇，這是他初次為耶和華築的壇。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S114_36","010_14_36","1SA","14","36","36","掃羅說：「我們不如夜裏下去追趕非利士人，搶掠他們，直到天亮，不留他們一人。」眾民說：「你看怎樣好就去行吧！」祭司說：「我們先當親近上帝。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S114_37","010_14_37","1SA","14","37","37","掃羅求問上帝說：「我下去追趕非利士人可以不可以？你將他們交在以色列人手裏不交？」這日上帝沒有回答他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S114_38","010_14_38","1SA","14","38","38","掃羅說：「你們百姓中的長老都上這裏來，查明今日是誰犯了罪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S114_39","010_14_39","1SA","14","39","39","我指着救以色列－永生的耶和華起誓，就是我兒子約拿單犯了罪，他也必死。」但百姓中無一人回答他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S114_40","010_14_40","1SA","14","40","40","掃羅就對以色列眾人說：「你們站在一邊，我與我兒子約拿單也站在一邊。」百姓對掃羅說：「你看怎樣好就去行吧！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S114_41","010_14_41","1SA","14","41","41","掃羅禱告耶和華－以色列的上帝說：「求你指示實情。」於是掣籤掣出掃羅和約拿單來；百姓盡都無事。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S114_42","010_14_42","1SA","14","42","42","掃羅說：「你們再掣籤，看是我，是我兒子約拿單」，就掣出約拿單來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S114_43","010_14_43","1SA","14","43","43","掃羅對約拿單說：「你告訴我，你做了甚麼事？」約拿單說：「我實在以手裏的杖，用杖頭蘸了一點蜜嘗了一嘗。這樣我就死嗎？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S114_44","010_14_44","1SA","14","44","44","掃羅說：「約拿單哪，你定要死！若不然，願上帝重重地降罰與我。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S114_45","010_14_45","1SA","14","45","45","百姓對掃羅說：「約拿單在以色列人中這樣大行拯救，豈可使他死呢？斷乎不可！我們指着永生的耶和華起誓，連他的一根頭髮也不可落地，因為他今日與上帝一同做事。」於是百姓救約拿單免了死亡。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S114_46","010_14_46","1SA","14","46","46","掃羅回去，不追趕非利士人；非利士人也回本地去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S114_47","010_14_47","1SA","14","47","47","掃羅執掌以色列的國權，常常攻擊他四圍的一切仇敵，就是摩押人、亞捫人、以東人，和瑣巴諸王，並非利士人。他無論往何處去，都打敗仇敵。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S114_48","010_14_48","1SA","14","48","48","掃羅奮勇攻擊亞瑪力人，救了以色列人脫離搶掠他們之人的手。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S114_49","010_14_49","1SA","14","49","49","掃羅的兒子是約拿單、亦施韋、麥基舒亞。他的兩個女兒：長女名米拉，次女名米甲。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S114_50","010_14_50","1SA","14","50","50","掃羅的妻名叫亞希暖，是亞希瑪斯的女兒。掃羅的元帥名叫押尼珥，是尼珥的兒子；尼珥是掃羅的叔叔。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S114_51","010_14_51","1SA","14","51","51","掃羅的父親基士，押尼珥的父親尼珥，都是亞別的兒子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S114_52","010_14_52","1SA","14","52","52","掃羅平生常與非利士人大大爭戰。掃羅遇見有能力的人或勇士，都招募了來跟隨他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S115_1","010_15_1","1SA","15","1","1","撒母耳對掃羅說：「耶和華差遣我膏你為王，治理他的百姓以色列；所以你當聽從耶和華的話。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S115_2","010_15_2","1SA","15","2","2","萬軍之耶和華如此說：『以色列人出埃及的時候，在路上亞瑪力人怎樣待他們，怎樣抵擋他們，我都沒忘。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S115_3","010_15_3","1SA","15","3","3","現在你要去擊打亞瑪力人，滅盡他們所有的，不可憐惜他們，將男女、孩童、吃奶的，並牛、羊、駱駝，和驢盡行殺死。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S115_4","010_15_4","1SA","15","4","4","於是掃羅招聚百姓在提拉因，數點他們，共有步兵二十萬，另有猶大人一萬。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S115_5","010_15_5","1SA","15","5","5","掃羅到了亞瑪力的京城，在谷中設下埋伏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S115_6","010_15_6","1SA","15","6","6","掃羅對基尼人說：「你們離開亞瑪力人下去吧，恐怕我將你們和亞瑪力人一同殺滅；因為以色列人出埃及的時候，你們曾恩待他們。」於是基尼人離開亞瑪力人去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S115_7","010_15_7","1SA","15","7","7","掃羅擊打亞瑪力人，從哈腓拉直到埃及前的書珥， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S115_8","010_15_8","1SA","15","8","8","生擒了亞瑪力王亞甲，用刀殺盡亞瑪力的眾民。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S115_9","010_15_9","1SA","15","9","9","掃羅和百姓卻憐惜亞甲，也愛惜上好的牛、羊、牛犢、羊羔，並一切美物，不肯滅絕。凡下賤瘦弱的，盡都殺了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S115_10","010_15_10","1SA","15","10","10","耶和華的話臨到撒母耳說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("S115_11","010_15_11","1SA","15","11","11","「我立掃羅為王，我後悔了；因為他轉去不跟從我，不遵守我的命令。」撒母耳便甚憂愁，終夜哀求耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S115_12","010_15_12","1SA","15","12","12","撒母耳清早起來，迎接掃羅。有人告訴撒母耳說：「掃羅到了迦密，在那裏立了紀念碑，又轉身下到吉甲。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S115_13","010_15_13","1SA","15","13","13","撒母耳到了掃羅那裏，掃羅對他說：「願耶和華賜福與你，耶和華的命令我已遵守了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S115_14","010_15_14","1SA","15","14","14","撒母耳說：「我耳中聽見有羊叫、牛鳴，是從哪裏來的呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S115_15","010_15_15","1SA","15","15","15","掃羅說：「這是百姓從亞瑪力人那裏帶來的；因為他們愛惜上好的牛羊，要獻與耶和華－你的上帝；其餘的，我們都滅盡了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S115_16","010_15_16","1SA","15","16","16","撒母耳對掃羅說：「你住口吧！等我將耶和華昨夜向我所說的話告訴你。」掃羅說：「請講。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S115_17","010_15_17","1SA","15","17","17","撒母耳對掃羅說：「從前你雖然以自己為小，豈不是被立為以色列支派的元首嗎？耶和華膏你作以色列的王。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S115_18","010_15_18","1SA","15","18","18","耶和華差遣你，吩咐你說，你去擊打那些犯罪的亞瑪力人，將他們滅絕淨盡。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S115_19","010_15_19","1SA","15","19","19","你為何沒有聽從耶和華的命令，急忙擄掠財物，行耶和華眼中看為惡的事呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S115_20","010_15_20","1SA","15","20","20","掃羅對撒母耳說：「我實在聽從了耶和華的命令，行了耶和華所差遣我行的路，擒了亞瑪力王亞甲來，滅盡了亞瑪力人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S115_21","010_15_21","1SA","15","21","21","百姓卻在所當滅的物中，取了最好的牛羊，要在吉甲獻與耶和華－你的上帝。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S115_22","010_15_22","1SA","15","22","22","撒母耳說： 耶和華喜悅燔祭和平安祭， 豈如喜悅人聽從他的話呢？ 聽命勝於獻祭； 順從勝於公羊的脂油。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S115_23","010_15_23","1SA","15","23","23","悖逆的罪與行邪術的罪相等； 頑梗的罪與拜虛神和偶像的罪相同。 你既厭棄耶和華的命令， 耶和華也厭棄你作王。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S115_24","010_15_24","1SA","15","24","24","掃羅對撒母耳說：「我有罪了，我因懼怕百姓，聽從他們的話，就違背了耶和華的命令和你的言語。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S115_25","010_15_25","1SA","15","25","25","現在求你赦免我的罪，同我回去，我好敬拜耶和華。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S115_26","010_15_26","1SA","15","26","26","撒母耳對掃羅說：「我不同你回去；因為你厭棄耶和華的命令，耶和華也厭棄你作以色列的王。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S115_27","010_15_27","1SA","15","27","27","撒母耳轉身要走，掃羅就扯住他外袍的衣襟，衣襟就撕斷了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S115_28","010_15_28","1SA","15","28","28","撒母耳對他說：「如此，今日耶和華使以色列國與你斷絕，將這國賜與比你更好的人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S115_29","010_15_29","1SA","15","29","29","以色列的大能者必不致說謊，也不致後悔；因為他迥非世人，決不後悔。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S115_30","010_15_30","1SA","15","30","30","掃羅說：「我有罪了，雖然如此，求你在我百姓的長老和以色列人面前抬舉我，同我回去，我好敬拜耶和華－你的上帝。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S115_31","010_15_31","1SA","15","31","31","於是撒母耳轉身跟隨掃羅回去，掃羅就敬拜耶和華。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S115_32","010_15_32","1SA","15","32","32","撒母耳說：「要把亞瑪力王亞甲帶到我這裏來。」亞甲就歡歡喜喜地來到他面前，心裏說，死亡的苦難必定過去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S115_33","010_15_33","1SA","15","33","33","撒母耳說：「你既用刀使婦人喪子，這樣，你母親在婦人中也必喪子。」於是，撒母耳在吉甲耶和華面前將亞甲殺死。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S115_34","010_15_34","1SA","15","34","34","撒母耳回了拉瑪。掃羅上他所住的基比亞，回自己的家去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S115_35","010_15_35","1SA","15","35","35","撒母耳直到死的日子，再沒有見掃羅；但撒母耳為掃羅悲傷，是因耶和華後悔立他為以色列的王。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S116_1","010_16_1","1SA","16","1","1","耶和華對撒母耳說：「我既厭棄掃羅作以色列的王，你為他悲傷要到幾時呢？你將膏油盛滿了角，我差遣你往伯利恆人耶西那裏去；因為我在他眾子之內，預定一個作王的。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S116_2","010_16_2","1SA","16","2","2","撒母耳說：「我怎能去呢？掃羅若聽見，必要殺我。」耶和華說：「你可以帶一隻牛犢去，就說：『我來是要向耶和華獻祭。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S116_3","010_16_3","1SA","16","3","3","你要請耶西來吃祭肉，我就指示你所當行的事。我所指給你的人，你要膏他。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S116_4","010_16_4","1SA","16","4","4","撒母耳就照耶和華的話去行。到了伯利恆，那城裏的長老都戰戰兢兢地出來迎接他，問他說：「你是為平安來的嗎？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S116_5","010_16_5","1SA","16","5","5","他說：「為平安來的，我是給耶和華獻祭。你們當自潔，來與我同吃祭肉。」撒母耳就使耶西和他眾子自潔，請他們來吃祭肉。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S116_6","010_16_6","1SA","16","6","6","他們來的時候，撒母耳看見以利押，就心裏說，耶和華的受膏者必定在他面前。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S116_7","010_16_7","1SA","16","7","7","耶和華卻對撒母耳說：「不要看他的外貌和他身材高大，我不揀選他。因為，耶和華不像人看人：人是看外貌；耶和華是看內心。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S116_8","010_16_8","1SA","16","8","8","耶西叫亞比拿達從撒母耳面前經過，撒母耳說：「耶和華也不揀選他。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S116_9","010_16_9","1SA","16","9","9","耶西又叫沙瑪從撒母耳面前經過，撒母耳說：「耶和華也不揀選他。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S116_10","010_16_10","1SA","16","10","10","耶西叫他七個兒子都從撒母耳面前經過，撒母耳說：「這都不是耶和華所揀選的。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S116_11","010_16_11","1SA","16","11","11","撒母耳對耶西說：「你的兒子都在這裏嗎？」他回答說：「還有個小的，現在放羊。」撒母耳對耶西說：「你打發人去叫他來；他若不來，我們必不坐席。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S116_12","010_16_12","1SA","16","12","12","耶西就打發人去叫了他來。他面色光紅，雙目清秀，容貌俊美。耶和華說：「這就是他，你起來膏他。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S116_13","010_16_13","1SA","16","13","13","撒母耳就用角裏的膏油，在他諸兄中膏了他。從這日起，耶和華的靈就大大感動大衛。撒母耳起身回拉瑪去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S116_14","010_16_14","1SA","16","14","14","耶和華的靈離開掃羅，有惡魔從耶和華那裏來擾亂他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S116_15","010_16_15","1SA","16","15","15","掃羅的臣僕對他說：「現在有惡魔從上帝那裏來擾亂你。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S116_16","010_16_16","1SA","16","16","16","我們的主可以吩咐面前的臣僕，找一個善於彈琴的來，等上帝那裏來的惡魔臨到你身上的時候，使他用手彈琴，你就好了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S116_17","010_16_17","1SA","16","17","17","掃羅對臣僕說：「你們可以為我找一個善於彈琴的，帶到我這裏來。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S116_18","010_16_18","1SA","16","18","18","其中有一個少年人說：「我曾見伯利恆人耶西的一個兒子善於彈琴，是大有勇敢的戰士，說話合宜，容貌俊美，耶和華也與他同在。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S116_19","010_16_19","1SA","16","19","19","於是掃羅差遣使者去見耶西，說：「請你打發你放羊的兒子大衛到我這裏來。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S116_20","010_16_20","1SA","16","20","20","耶西就把幾個餅和一皮袋酒，並一隻山羊羔，都馱在驢上，交給他兒子大衛，送與掃羅。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S116_21","010_16_21","1SA","16","21","21","大衛到了掃羅那裏，就侍立在掃羅面前。掃羅甚喜愛他，他就作了掃羅拿兵器的人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S116_22","010_16_22","1SA","16","22","22","掃羅差遣人去見耶西，說：「求你容大衛侍立在我面前，因為他在我眼前蒙了恩。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S116_23","010_16_23","1SA","16","23","23","從上帝那裏來的惡魔臨到掃羅身上的時候，大衛就拿琴，用手而彈，掃羅便舒暢爽快，惡魔離了他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_1","010_17_1","1SA","17","1","1","非利士人招聚他們的軍旅，要來爭戰；聚集在屬猶大的梭哥，安營在梭哥和亞西加中間的以弗‧大憫。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_2","010_17_2","1SA","17","2","2","掃羅和以色列人也聚集，在以拉谷安營，擺列隊伍，要與非利士人打仗。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_3","010_17_3","1SA","17","3","3","非利士人站在這邊山上，以色列人站在那邊山上，當中有谷。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_4","010_17_4","1SA","17","4","4","從非利士營中出來一個討戰的人，名叫歌利亞，是迦特人，身高六肘零一虎口； ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_5","010_17_5","1SA","17","5","5","頭戴銅盔，身穿鎧甲，甲重五千舍客勒； ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_6","010_17_6","1SA","17","6","6","腿上有銅護膝，兩肩之中背負銅戟； ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_7","010_17_7","1SA","17","7","7","槍桿粗如織布的機軸，鐵槍頭重六百舍客勒。有一個拿盾牌的人在他前面走。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_8","010_17_8","1SA","17","8","8","歌利亞對着以色列的軍隊站立，呼叫說：「你們出來擺列隊伍做甚麼呢？我不是非利士人嗎？你們不是掃羅的僕人嗎？可以從你們中間揀選一人，使他下到我這裏來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_9","010_17_9","1SA","17","9","9","他若能與我戰鬥，將我殺死，我們就作你們的僕人；我若勝了他，將他殺死，你們就作我們的僕人，服事我們。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_10","010_17_10","1SA","17","10","10","那非利士人又說：「我今日向以色列人的軍隊罵陣。你們叫一個人出來，與我戰鬥。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_11","010_17_11","1SA","17","11","11","掃羅和以色列眾人聽見非利士人的這些話，就驚惶，極其害怕。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_12","010_17_12","1SA","17","12","12","大衛是猶大伯利恆的以法他人耶西的兒子。耶西有八個兒子。當掃羅的時候，耶西已經老邁。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_13","010_17_13","1SA","17","13","13","耶西的三個大兒子跟隨掃羅出征。這出征的三個兒子：長子名叫以利押，次子名叫亞比拿達，三子名叫沙瑪。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_14","010_17_14","1SA","17","14","14","大衛是最小的；那三個大兒子跟隨掃羅。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_15","010_17_15","1SA","17","15","15","大衛有時離開掃羅，回伯利恆放他父親的羊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_16","010_17_16","1SA","17","16","16","那非利士人早晚都出來站着，如此四十日。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_17","010_17_17","1SA","17","17","17","一日，耶西對他兒子大衛說：「你拿一伊法烘了的穗子和十個餅，速速地送到營裏去，交給你哥哥們； ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_18","010_17_18","1SA","17","18","18","再拿這十塊奶餅，送給他們的千夫長，且問你哥哥們好，向他們要一封信來。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_19","010_17_19","1SA","17","19","19","掃羅與大衛的三個哥哥和以色列眾人，在以拉谷與非利士人打仗。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_20","010_17_20","1SA","17","20","20","大衛早晨起來，將羊交託一個看守的人，照着他父親所吩咐的話，帶着食物去了。到了輜重營，軍兵剛出到戰場，吶喊要戰。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_21","010_17_21","1SA","17","21","21","以色列人和非利士人都擺列隊伍，彼此相對。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_22","010_17_22","1SA","17","22","22","大衛把他帶來的食物留在看守物件人的手下，跑到戰場，問他哥哥們安。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_23","010_17_23","1SA","17","23","23","與他們說話的時候，那討戰的，就是屬迦特的非利士人歌利亞，從非利士隊中出來，說從前所說的話；大衛都聽見了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_24","010_17_24","1SA","17","24","24","以色列眾人看見那人，就逃跑，極其害怕。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_25","010_17_25","1SA","17","25","25","以色列人彼此說：「這上來的人你看見了嗎？他上來是要向以色列人罵陣。若有能殺他的，王必賞賜他大財，將自己的女兒給他為妻，並在以色列人中免他父家納糧當差。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_26","010_17_26","1SA","17","26","26","大衛問站在旁邊的人說：「有人殺這非利士人，除掉以色列人的恥辱，怎樣待他呢？這未受割禮的非利士人是誰呢？竟敢向永生上帝的軍隊罵陣嗎？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_27","010_17_27","1SA","17","27","27","百姓照先前的話回答他說：「有人能殺這非利士人，必如此如此待他。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_28","010_17_28","1SA","17","28","28","大衛的長兄以利押聽見大衛與他們所說的話，就向他發怒，說：「你下來做甚麼呢？在曠野的那幾隻羊，你交託了誰呢？我知道你的驕傲和你心裏的惡意，你下來特為要看爭戰！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_29","010_17_29","1SA","17","29","29","大衛說：「我做了甚麼呢？我來豈沒有緣故嗎？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_30","010_17_30","1SA","17","30","30","大衛就離開他轉向別人，照先前的話而問；百姓仍照先前的話回答他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_31","010_17_31","1SA","17","31","31","有人聽見大衛所說的話，就告訴了掃羅；掃羅便打發人叫他來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_32","010_17_32","1SA","17","32","32","大衛對掃羅說：「人都不必因那非利士人膽怯。你的僕人要去與那非利士人戰鬥。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_33","010_17_33","1SA","17","33","33","掃羅對大衛說：「你不能去與那非利士人戰鬥；因為你年紀太輕，他自幼就作戰士。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_34","010_17_34","1SA","17","34","34","大衛對掃羅說：「你僕人為父親放羊，有時來了獅子，有時來了熊，從群中啣一隻羊羔去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_35","010_17_35","1SA","17","35","35","我就追趕牠，擊打牠，將羊羔從牠口中救出來。牠起來要害我，我就揪着牠的鬍子，將牠打死。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_36","010_17_36","1SA","17","36","36","你僕人曾打死獅子和熊，這未受割禮的非利士人向永生上帝的軍隊罵陣，也必像獅子和熊一般。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_37","010_17_37","1SA","17","37","37","大衛又說：「耶和華救我脫離獅子和熊的爪，也必救我脫離這非利士人的手。」掃羅對大衛說：「你可以去吧！耶和華必與你同在。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_38","010_17_38","1SA","17","38","38","掃羅就把自己的戰衣給大衛穿上，將銅盔給他戴上，又給他穿上鎧甲。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_39","010_17_39","1SA","17","39","39","大衛把刀跨在戰衣外，試試能走不能走；因為素來沒有穿慣，就對掃羅說：「我穿戴這些不能走，因為素來沒有穿慣。」於是摘脫了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_40","010_17_40","1SA","17","40","40","他手中拿杖，又在溪中挑選了五塊光滑石子，放在袋裏，就是牧人帶的囊裏；手中拿着甩石的機弦，就去迎那非利士人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_41","010_17_41","1SA","17","41","41","非利士人也漸漸地迎着大衛來，拿盾牌的走在前頭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_42","010_17_42","1SA","17","42","42","非利士人觀看，見了大衛，就藐視他；因為他年輕，面色光紅，容貌俊美。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_43","010_17_43","1SA","17","43","43","非利士人對大衛說：「你拿杖到我這裏來，我豈是狗呢？」非利士人就指着自己的神咒詛大衛。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_44","010_17_44","1SA","17","44","44","非利士人又對大衛說：「來吧！我將你的肉給空中的飛鳥、田野的走獸吃。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_45","010_17_45","1SA","17","45","45","大衛對非利士人說：「你來攻擊我，是靠着刀槍和銅戟；我來攻擊你，是靠着萬軍之耶和華的名，就是你所怒罵帶領以色列軍隊的上帝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_46","010_17_46","1SA","17","46","46","今日耶和華必將你交在我手裏。我必殺你，斬你的頭，又將非利士軍兵的屍首給空中的飛鳥、地上的野獸吃，使普天下的人都知道以色列中有上帝； ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_47","010_17_47","1SA","17","47","47","又使這眾人知道耶和華使人得勝，不是用刀用槍，因為爭戰的勝敗全在乎耶和華。他必將你們交在我們手裏。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_48","010_17_48","1SA","17","48","48","非利士人起身，迎着大衛前來。大衛急忙迎着非利士人，往戰場跑去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_49","010_17_49","1SA","17","49","49","大衛用手從囊中掏出一塊石子來，用機弦甩去，打中非利士人的額，石子進入額內，他就仆倒，面伏於地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_50","010_17_50","1SA","17","50","50","這樣，大衛用機弦甩石，勝了那非利士人，打死他；大衛手中卻沒有刀。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_51","010_17_51","1SA","17","51","51","大衛跑去，站在非利士人身旁，將他的刀從鞘中拔出來，殺死他，割了他的頭。非利士眾人看見他們討戰的勇士死了，就都逃跑。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_52","010_17_52","1SA","17","52","52","以色列人和猶大人便起身吶喊，追趕非利士人，直到迦特和以革倫的城門。被殺的非利士人倒在沙拉音的路上，直到迦特和以革倫。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_53","010_17_53","1SA","17","53","53","以色列人追趕非利士人回來，就奪了他們的營盤。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_54","010_17_54","1SA","17","54","54","大衛將那非利士人的頭拿到耶路撒冷，卻將他軍裝放在自己的帳棚裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_55","010_17_55","1SA","17","55","55","掃羅看見大衛去攻擊非利士人，就問元帥押尼珥說：「押尼珥啊，那少年人是誰的兒子？」押尼珥說：「我敢在王面前起誓，我不知道。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_56","010_17_56","1SA","17","56","56","王說：「你可以問問那幼年人是誰的兒子。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_57","010_17_57","1SA","17","57","57","大衛打死非利士人回來，押尼珥領他到掃羅面前，他手中拿着非利士人的頭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S117_58","010_17_58","1SA","17","58","58","掃羅問他說：「少年人哪，你是誰的兒子？」大衛說：「我是你僕人伯利恆人耶西的兒子。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S118_1","010_18_1","1SA","18","1","1","大衛對掃羅說完了話，約拿單的心與大衛的心深相契合。約拿單愛大衛，如同愛自己的性命。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S118_2","010_18_2","1SA","18","2","2","那日掃羅留住大衛，不容他再回父家。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S118_3","010_18_3","1SA","18","3","3","約拿單愛大衛如同愛自己的性命，就與他結盟。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S118_4","010_18_4","1SA","18","4","4","約拿單從身上脫下外袍，給了大衛，又將戰衣、刀、弓、腰帶都給了他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S118_5","010_18_5","1SA","18","5","5","掃羅無論差遣大衛往何處去，他都做事精明。掃羅就立他作戰士長，眾百姓和掃羅的臣僕無不喜悅。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S118_6","010_18_6","1SA","18","6","6","大衛打死了那非利士人，同眾人回來的時候，婦女們從以色列各城裏出來，歡歡喜喜，打鼓擊磬，歌唱跳舞，迎接掃羅王。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S118_7","010_18_7","1SA","18","7","7","眾婦女舞蹈唱和，說：「掃羅殺死千千，大衛殺死萬萬。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S118_8","010_18_8","1SA","18","8","8","掃羅甚發怒，不喜悅這話，就說：「將萬萬歸大衛，千千歸我，只剩下王位沒有給他了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S118_9","010_18_9","1SA","18","9","9","從這日起，掃羅就怒視大衛。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S118_10","010_18_10","1SA","18","10","10","次日，從上帝那裏來的惡魔大大降在掃羅身上，他就在家中胡言亂語。大衛照常彈琴，掃羅手裏拿着槍。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S118_11","010_18_11","1SA","18","11","11","掃羅把槍一掄，心裏說，我要將大衛刺透，釘在牆上。大衛躲避他兩次。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S118_12","010_18_12","1SA","18","12","12","掃羅懼怕大衛；因為耶和華離開自己，與大衛同在。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S118_13","010_18_13","1SA","18","13","13","所以掃羅使大衛離開自己，立他為千夫長，他就領兵出入。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S118_14","010_18_14","1SA","18","14","14","大衛做事無不精明，耶和華也與他同在。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S118_15","010_18_15","1SA","18","15","15","掃羅見大衛做事精明，就甚怕他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S118_16","010_18_16","1SA","18","16","16","但以色列和猶大眾人都愛大衛，因為他領他們出入。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S118_17","010_18_17","1SA","18","17","17","掃羅對大衛說：「我將大女兒米拉給你為妻，只要你為我奮勇，為耶和華爭戰。」掃羅心裏說：「我不好親手害他，要藉非利士人的手害他。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S118_18","010_18_18","1SA","18","18","18","大衛對掃羅說：「我是誰，我是甚麼出身，我父家在以色列中是何等的家，豈敢作王的女婿呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S118_19","010_18_19","1SA","18","19","19","掃羅的女兒米拉到了當給大衛的時候，掃羅卻給了米何拉人亞得列為妻。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S118_20","010_18_20","1SA","18","20","20","掃羅的次女米甲愛大衛。有人告訴掃羅，掃羅就喜悅。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S118_21","010_18_21","1SA","18","21","21","掃羅心裏說：「我將這女兒給大衛，作他的網羅，好藉非利士人的手害他。」所以掃羅對大衛說：「你今日可以第二次作我的女婿。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S118_22","010_18_22","1SA","18","22","22","掃羅吩咐臣僕說：「你們暗中對大衛說：『王喜悅你，王的臣僕也都喜愛你，所以你當作王的女婿。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S118_23","010_18_23","1SA","18","23","23","掃羅的臣僕就照這話說給大衛聽。大衛說：「你們以為作王的女婿是一件小事嗎？我是貧窮卑微的人。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S118_24","010_18_24","1SA","18","24","24","掃羅的臣僕回奏說，大衛所說的如此如此。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S118_25","010_18_25","1SA","18","25","25","掃羅說：「你們要對大衛這樣說：『王不要甚麼聘禮，只要一百非利士人的陽皮，好在王的仇敵身上報仇。』」掃羅的意思要使大衛喪在非利士人的手裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S118_26","010_18_26","1SA","18","26","26","掃羅的臣僕將這話告訴大衛，大衛就歡喜作王的女婿。日期還沒有到， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S118_27","010_18_27","1SA","18","27","27","大衛和跟隨他的人起身前往，殺了二百非利士人，將陽皮滿數交給王，為要作王的女婿。於是掃羅將女兒米甲給大衛為妻。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S118_28","010_18_28","1SA","18","28","28","掃羅見耶和華與大衛同在，又知道女兒米甲愛大衛， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S118_29","010_18_29","1SA","18","29","29","就更怕大衛，常作大衛的仇敵。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S118_30","010_18_30","1SA","18","30","30","每逢非利士軍長出來打仗，大衛比掃羅的臣僕做事精明，因此他的名被人尊重。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S119_1","010_19_1","1SA","19","1","1","掃羅對他兒子約拿單和眾臣僕說，要殺大衛；掃羅的兒子約拿單卻甚喜愛大衛。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S119_2","010_19_2","1SA","19","2","2","約拿單告訴大衛說：「我父掃羅想要殺你，所以明日早晨你要小心，到一個僻靜地方藏身。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S119_3","010_19_3","1SA","19","3","3","我就出到你所藏的田裏，站在我父親旁邊與他談論。我看他情形怎樣，我必告訴你。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S119_4","010_19_4","1SA","19","4","4","約拿單向他父親掃羅替大衛說好話，說：「王不可得罪王的僕人大衛；因為他未曾得罪你，他所行的都與你大有益處。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S119_5","010_19_5","1SA","19","5","5","他拚命殺那非利士人，耶和華為以色列眾人大行拯救；那時你看見，甚是歡喜，現在為何無故要殺大衛，流無辜人的血，自己取罪呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S119_6","010_19_6","1SA","19","6","6","掃羅聽了約拿單的話，就指着永生的耶和華起誓說：「我必不殺他。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S119_7","010_19_7","1SA","19","7","7","約拿單叫大衛來，把這一切事告訴他，帶他去見掃羅。他就仍然侍立在掃羅面前。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S119_8","010_19_8","1SA","19","8","8","此後又有爭戰的事。大衛出去與非利士人打仗，大大殺敗他們，他們就在他面前逃跑。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S119_9","010_19_9","1SA","19","9","9","從耶和華那裏來的惡魔又降在掃羅身上（掃羅手裏拿槍坐在屋裏），大衛就用手彈琴。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S119_10","010_19_10","1SA","19","10","10","掃羅用槍想要刺透大衛，釘在牆上，他卻躲開，掃羅的槍刺入牆內。當夜大衛逃走，躲避了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S119_11","010_19_11","1SA","19","11","11","掃羅打發人到大衛的房屋那裏窺探他，要等到天亮殺他。大衛的妻米甲對他說：「你今夜若不逃命，明日你要被殺。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S119_12","010_19_12","1SA","19","12","12","於是米甲將大衛從窗戶裏縋下去，大衛就逃走，躲避了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S119_13","010_19_13","1SA","19","13","13","米甲把家中的神像放在床上，頭枕在山羊毛裝的枕頭上，用被遮蓋。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S119_14","010_19_14","1SA","19","14","14","掃羅打發人去捉拿大衛，米甲說：「他病了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S119_15","010_19_15","1SA","19","15","15","掃羅又打發人去看大衛，說：「當連床將他抬來，我好殺他。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S119_16","010_19_16","1SA","19","16","16","使者進去，看見床上有神像，頭枕在山羊毛裝的枕頭上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S119_17","010_19_17","1SA","19","17","17","掃羅對米甲說：「你為甚麼這樣欺哄我，放我仇敵逃走呢？」米甲回答說：「他對我說：『你放我走，不然我要殺你。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S119_18","010_19_18","1SA","19","18","18","大衛逃避，來到拉瑪見撒母耳，將掃羅向他所行的事述說了一遍。他和撒母耳就往拿約去居住。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S119_19","010_19_19","1SA","19","19","19","有人告訴掃羅，說大衛在拉瑪的拿約。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S119_20","010_19_20","1SA","19","20","20","掃羅打發人去捉拿大衛。去的人見有一班先知都受感說話，撒母耳站在其中監管他們；打發去的人也受上帝的靈感動說話。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S119_21","010_19_21","1SA","19","21","21","有人將這事告訴掃羅，他又打發人去，他們也受感說話。掃羅第三次打發人去，他們也受感說話。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S119_22","010_19_22","1SA","19","22","22","然後掃羅自己往拉瑪去，到了西沽的大井，問人說：「撒母耳和大衛在哪裏呢？」有人說：「在拉瑪的拿約。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S119_23","010_19_23","1SA","19","23","23","他就往拉瑪的拿約去。上帝的靈也感動他，一面走一面說話，直到拉瑪的拿約。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S119_24","010_19_24","1SA","19","24","24","他就脫了衣服，在撒母耳面前受感說話，一晝一夜露體躺臥。因此有句俗語說：「掃羅也列在先知中嗎？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S120_1","010_20_1","1SA","20","1","1","大衛從拉瑪的拿約逃跑，來到約拿單那裏，對他說：「我做了甚麼？有甚麼罪孽呢？在你父親面前犯了甚麼罪，他竟尋索我的性命呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S120_2","010_20_2","1SA","20","2","2","約拿單回答說：「斷然不是！你必不致死。我父做事，無論大小，沒有不叫我知道的。怎麼獨有這事隱瞞我呢？決不如此。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S120_3","010_20_3","1SA","20","3","3","大衛又起誓說：「你父親準知我在你眼前蒙恩。他心裏說，不如不叫約拿單知道，恐怕他愁煩。我指着永生的耶和華，又敢在你面前起誓，我離死不過一步。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S120_4","010_20_4","1SA","20","4","4","約拿單對大衛說：「你心裏所求的，我必為你成就。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S120_5","010_20_5","1SA","20","5","5","大衛對約拿單說：「明日是初一，我當與王同席，求你容我去藏在田野，直到第三日晚上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S120_6","010_20_6","1SA","20","6","6","你父親若見我不在席上，你就說：『大衛切求我許他回本城伯利恆去，因為他全家在那裏獻年祭。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S120_7","010_20_7","1SA","20","7","7","你父親若說好，僕人就平安了；他若發怒，你就知道他決意要害我。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S120_8","010_20_8","1SA","20","8","8","求你施恩與僕人，因你在耶和華面前曾與僕人結盟。我若有罪，不如你自己殺我，何必將我交給你父親呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S120_9","010_20_9","1SA","20","9","9","約拿單說：「斷無此事！我若知道我父親決意害你，我豈不告訴你呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S120_10","010_20_10","1SA","20","10","10","大衛對約拿單說：「你父親若用厲言回答你，誰來告訴我呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S120_11","010_20_11","1SA","20","11","11","約拿單對大衛說：「你我且往田野去。」二人就往田野去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S120_12","010_20_12","1SA","20","12","12","約拿單對大衛說：「願耶和華－以色列的上帝為證。明日約在這時候，或第三日，我探我父親的意思，若向你有好意，我豈不打發人告訴你嗎？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("S120_13","010_20_13","1SA","20","13","13","我父親若有意害你，我不告訴你使你平平安安地走，願耶和華重重地降罰與我。願耶和華與你同在，如同從前與我父親同在一樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S120_14","010_20_14","1SA","20","14","14","你要照耶和華的慈愛恩待我，不但我活着的時候免我死亡， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S120_15","010_20_15","1SA","20","15","15","就是我死後，耶和華從地上剪除你仇敵的時候，你也永不可向我家絕了恩惠。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S120_16","010_20_16","1SA","20","16","16","於是約拿單與大衛家結盟，說：「願耶和華藉大衛的仇敵追討背約的罪。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S120_17","010_20_17","1SA","20","17","17","約拿單因愛大衛如同愛自己的性命，就使他再起誓。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S120_18","010_20_18","1SA","20","18","18","約拿單對他說：「明日是初一，你的座位空設，人必理會你不在那裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S120_19","010_20_19","1SA","20","19","19","你等三日，就要速速下去，到你從前遇事所藏的地方，在以色磐石那裏等候。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S120_20","010_20_20","1SA","20","20","20","我要向磐石旁邊射三箭，如同射箭靶一樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S120_21","010_20_21","1SA","20","21","21","我要打發童子，說：『去把箭找來。』我若對童子說：『箭在後頭，把箭拿來』，你就可以回來；我指着永生的耶和華起誓，你必平安無事。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S120_22","010_20_22","1SA","20","22","22","我若對童子說：『箭在前頭』，你就要去，因為是耶和華打發你去的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S120_23","010_20_23","1SA","20","23","23","至於你我今日所說的話，有耶和華在你我中間為證，直到永遠。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S120_24","010_20_24","1SA","20","24","24","大衛就去藏在田野。到了初一日，王坐席要吃飯。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S120_25","010_20_25","1SA","20","25","25","王照常坐在靠牆的位上，約拿單侍立，押尼珥坐在掃羅旁邊，大衛的座位空設。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S120_26","010_20_26","1SA","20","26","26","然而這日掃羅沒有說甚麼，他想大衛遇事，偶染不潔，他必定是不潔。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S120_27","010_20_27","1SA","20","27","27","初二日大衛的座位還空設。掃羅問他兒子約拿單說：「耶西的兒子為何昨日、今日沒有來吃飯呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S120_28","010_20_28","1SA","20","28","28","約拿單回答掃羅說：「大衛切求我容他往伯利恆去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S120_29","010_20_29","1SA","20","29","29","他說：『求你容我去，因為我家在城裏有獻祭的事；我長兄吩咐我去。如今我若在你眼前蒙恩，求你容我去見我的弟兄』；所以大衛沒有赴王的席。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S120_30","010_20_30","1SA","20","30","30","掃羅向約拿單發怒，對他說：「你這頑梗背逆之婦人所生的，我豈不知道你喜悅耶西的兒子，自取羞辱，以致你母親露體蒙羞嗎？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("S120_31","010_20_31","1SA","20","31","31","耶西的兒子若在世間活着，你和你的國位必站立不住。現在你要打發人去，將他捉拿交給我；他是該死的。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S120_32","010_20_32","1SA","20","32","32","約拿單對父親掃羅說：「他為甚麼該死呢？他做了甚麼呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S120_33","010_20_33","1SA","20","33","33","掃羅向約拿單掄槍要刺他，約拿單就知道他父親決意要殺大衛。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S120_34","010_20_34","1SA","20","34","34","於是約拿單氣忿忿地從席上起來，在這初二日沒有吃飯。他因見父親羞辱大衛，就為大衛愁煩。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S120_35","010_20_35","1SA","20","35","35","次日早晨，約拿單按着與大衛約會的時候出到田野，有一個童子跟隨。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S120_36","010_20_36","1SA","20","36","36","約拿單對童子說：「你跑去，把我所射的箭找來。」童子跑去，約拿單就把箭射在童子前頭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S120_37","010_20_37","1SA","20","37","37","童子到了約拿單落箭之地，約拿單呼叫童子說：「箭不是在你前頭嗎？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S120_38","010_20_38","1SA","20","38","38","約拿單又呼叫童子說：「速速地去，不要遲延！」童子就拾起箭來，回到主人那裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S120_39","010_20_39","1SA","20","39","39","童子卻不知道這是甚麼意思，只有約拿單和大衛知道。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S120_40","010_20_40","1SA","20","40","40","約拿單將弓箭交給童子，吩咐說：「你拿到城裏去。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S120_41","010_20_41","1SA","20","41","41","童子一去，大衛就從磐石的南邊出來，俯伏在地，拜了三拜；二人親嘴，彼此哭泣，大衛哭得更慟。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S120_42","010_20_42","1SA","20","42","42","約拿單對大衛說：「我們二人曾指着耶和華的名起誓說：『願耶和華在你我中間，並你我後裔中間為證，直到永遠。』如今你平平安安地去吧！」大衛就起身走了；約拿單也回城裏去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S121_1","010_21_1","1SA","21","1","1","大衛到了挪伯祭司亞希米勒那裏，亞希米勒戰戰兢兢地出來迎接他，問他說：「你為甚麼獨自來，沒有人跟隨呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S121_2","010_21_2","1SA","21","2","2","大衛回答祭司亞希米勒說：「王吩咐我一件事說：『我差遣你委託你的這件事，不要使人知道。』故此我已派定少年人在某處等候我。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S121_3","010_21_3","1SA","21","3","3","現在你手下有甚麼？求你給我五個餅或是別樣的食物。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S121_4","010_21_4","1SA","21","4","4","祭司對大衛說：「我手下沒有尋常的餅，只有聖餅；若少年人沒有親近婦人才可以給。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S121_5","010_21_5","1SA","21","5","5","大衛對祭司說：「實在約有三日我們沒有親近婦人；我出來的時候，雖是尋常行路，少年人的器皿還是潔淨的；何況今日不更是潔淨嗎？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S121_6","010_21_6","1SA","21","6","6","祭司就拿聖餅給他；因為在那裏沒有別樣餅，只有更換新餅，從耶和華面前撤下來的陳設餅。 （ ");
INSERT INTO cmn_cu89t_vpl VALUES ("S121_7","010_21_7","1SA","21","7","7","當日有掃羅的一個臣子留在耶和華面前。他名叫多益，是以東人，作掃羅的司牧長。） ");
INSERT INTO cmn_cu89t_vpl VALUES ("S121_8","010_21_8","1SA","21","8","8","大衛問亞希米勒說：「你手下有槍有刀沒有？因為王的事甚急，連刀劍器械我都沒有帶。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S121_9","010_21_9","1SA","21","9","9","祭司說：「你在以拉谷殺非利士人歌利亞的那刀在這裏，裹在布中，放在以弗得後邊，你要就可以拿去；除此以外，再沒有別的。」大衛說：「這刀沒有可比的！求你給我。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S121_10","010_21_10","1SA","21","10","10","那日大衛起來，躲避掃羅，逃到迦特王亞吉那裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S121_11","010_21_11","1SA","21","11","11","亞吉的臣僕對亞吉說：「這不是以色列國王大衛嗎？那裏的婦女跳舞唱和，不是指着他說『掃羅殺死千千，大衛殺死萬萬』嗎？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S121_12","010_21_12","1SA","21","12","12","大衛將這話放在心裏，甚懼怕迦特王亞吉， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S121_13","010_21_13","1SA","21","13","13","就在眾人面前改變了尋常的舉動，在他們手下假裝瘋癲，在城門的門扇上胡寫亂畫，使唾沫流在鬍子上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S121_14","010_21_14","1SA","21","14","14","亞吉對臣僕說：「你們看，這人是瘋子。為甚麼帶他到我這裏來呢？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("S121_15","010_21_15","1SA","21","15","15","我豈缺少瘋子，你們帶這人來在我面前瘋癲嗎？這人豈可進我的家呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S122_1","010_22_1","1SA","22","1","1","大衛就離開那裏，逃到亞杜蘭洞。他的弟兄和他父親的全家聽見了，就都下到他那裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S122_2","010_22_2","1SA","22","2","2","凡受窘迫的、欠債的、心裏苦惱的都聚集到大衛那裏；大衛就作他們的頭目，跟隨他的約有四百人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S122_3","010_22_3","1SA","22","3","3","大衛從那裏往摩押的米斯巴去，對摩押王說：「求你容我父母搬來，住在你們這裏，等我知道上帝要為我怎樣行。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S122_4","010_22_4","1SA","22","4","4","大衛領他父母到摩押王面前。大衛住山寨多少日子，他父母也住摩押王那裏多少日子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S122_5","010_22_5","1SA","22","5","5","先知迦得對大衛說：「你不要住在山寨，要往猶大地去。」大衛就離開那裏，進入哈列的樹林。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S122_6","010_22_6","1SA","22","6","6","掃羅在基比亞的拉瑪，坐在垂絲柳樹下，手裏拿着槍，眾臣僕侍立在左右。掃羅聽見大衛和跟隨他的人在何處， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S122_7","010_22_7","1SA","22","7","7","就對左右侍立的臣僕說：「便雅憫人哪，你們要聽我的話！耶西的兒子能將田地和葡萄園賜給你們各人嗎？能立你們各人作千夫長百夫長嗎？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("S122_8","010_22_8","1SA","22","8","8","你們竟都結黨害我！我的兒子與耶西的兒子結盟的時候，無人告訴我；我的兒子挑唆我的臣子謀害我，就如今日的光景，也無人告訴我，為我憂慮。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S122_9","010_22_9","1SA","22","9","9","那時以東人多益站在掃羅的臣僕中，對他說：「我曾看見耶西的兒子到了挪伯，亞希突的兒子亞希米勒那裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S122_10","010_22_10","1SA","22","10","10","亞希米勒為他求問耶和華，又給他食物，並給他殺非利士人歌利亞的刀。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S122_11","010_22_11","1SA","22","11","11","王就打發人將祭司亞希突的兒子亞希米勒和他父親的全家，就是住挪伯的祭司都召了來；他們就來見王。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S122_12","010_22_12","1SA","22","12","12","掃羅說：「亞希突的兒子，要聽我的話！」他回答說：「主啊，我在這裏。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S122_13","010_22_13","1SA","22","13","13","掃羅對他說：「你為甚麼與耶西的兒子結黨害我，將食物和刀給他，又為他求問上帝，使他起來謀害我，就如今日的光景？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S122_14","010_22_14","1SA","22","14","14","亞希米勒回答王說：「王的臣僕中有誰比大衛忠心呢？他是王的女婿，又是王的參謀，並且在王家中是尊貴的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S122_15","010_22_15","1SA","22","15","15","我豈是從今日才為他求問上帝呢？斷不是這樣！王不要將罪歸我和我父的全家；因為這事，無論大小，僕人都不知道。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S122_16","010_22_16","1SA","22","16","16","王說：「亞希米勒啊，你和你父的全家都是該死的！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S122_17","010_22_17","1SA","22","17","17","王就吩咐左右的侍衛說：「你們去殺耶和華的祭司；因為他們幫助大衛，又知道大衛逃跑，竟沒有告訴我。」掃羅的臣子卻不肯伸手殺耶和華的祭司。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S122_18","010_22_18","1SA","22","18","18","王吩咐多益說：「你去殺祭司吧！」以東人多益就去殺祭司，那日殺了穿細麻布以弗得的八十五人； ");
INSERT INTO cmn_cu89t_vpl VALUES ("S122_19","010_22_19","1SA","22","19","19","又用刀將祭司城挪伯中的男女、孩童、吃奶的，和牛、羊、驢盡都殺滅。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S122_20","010_22_20","1SA","22","20","20","亞希突的兒子亞希米勒有一個兒子，名叫亞比亞他，逃到大衛那裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S122_21","010_22_21","1SA","22","21","21","亞比亞他將掃羅殺耶和華祭司的事告訴大衛。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S122_22","010_22_22","1SA","22","22","22","大衛對亞比亞他說：「那日我見以東人多益在那裏，就知道他必告訴掃羅。你父的全家喪命，都是因我的緣故。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S122_23","010_22_23","1SA","22","23","23","你可以住在我這裏，不要懼怕。因為尋索你命的就是尋索我的命；你在我這裏可得保全。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S123_1","010_23_1","1SA","23","1","1","有人告訴大衛說：「非利士人攻擊基伊拉，搶奪禾場。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S123_2","010_23_2","1SA","23","2","2","所以大衛求問耶和華說：「我去攻打那些非利士人可以不可以？」耶和華對大衛說：「你可以去攻打非利士人，拯救基伊拉。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S123_3","010_23_3","1SA","23","3","3","跟隨大衛的人對他說：「我們在猶大地這裏尚且懼怕，何況往基伊拉去攻打非利士人的軍旅呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S123_4","010_23_4","1SA","23","4","4","大衛又求問耶和華。耶和華回答說：「你起身下基伊拉去，我必將非利士人交在你手裏。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S123_5","010_23_5","1SA","23","5","5","大衛和跟隨他的人往基伊拉去，與非利士人打仗，大大殺敗他們，又奪獲他們的牲畜。這樣，大衛救了基伊拉的居民。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S123_6","010_23_6","1SA","23","6","6","亞希米勒的兒子亞比亞他逃到基伊拉見大衛的時候，手裏拿着以弗得。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S123_7","010_23_7","1SA","23","7","7","有人告訴掃羅說：「大衛到了基伊拉。」掃羅說：「他進了有門有閂的城，困閉在裏頭；這是上帝將他交在我手裏了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S123_8","010_23_8","1SA","23","8","8","於是掃羅招聚眾民，要下去攻打基伊拉城，圍困大衛和跟隨他的人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S123_9","010_23_9","1SA","23","9","9","大衛知道掃羅設計謀害他，就對祭司亞比亞他說：「將以弗得拿過來。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S123_10","010_23_10","1SA","23","10","10","大衛禱告說：「耶和華－以色列的上帝啊，你僕人聽真了掃羅要往基伊拉來，為我的緣故滅城。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S123_11","010_23_11","1SA","23","11","11","基伊拉人將我交在掃羅手裏不交？掃羅照着你僕人所聽的話下來不下來？耶和華－以色列的上帝啊，求你指示僕人！」耶和華說：「掃羅必下來。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S123_12","010_23_12","1SA","23","12","12","大衛又說：「基伊拉人將我和跟隨我的人交在掃羅手裏不交？」耶和華說：「必交出來。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S123_13","010_23_13","1SA","23","13","13","大衛和跟隨他的約有六百人，就起身出了基伊拉，往他們所能往的地方去。有人告訴掃羅，大衛離開基伊拉逃走；於是掃羅不出來了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S123_14","010_23_14","1SA","23","14","14","大衛住在曠野的山寨裏，常在西弗曠野的山地。掃羅天天尋索大衛，上帝卻不將大衛交在他手裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S123_15","010_23_15","1SA","23","15","15","大衛知道掃羅出來尋索他的命。那時，他住在西弗曠野的樹林裏； ");
INSERT INTO cmn_cu89t_vpl VALUES ("S123_16","010_23_16","1SA","23","16","16","掃羅的兒子約拿單起身，往那樹林裏去見大衛，使他倚靠上帝得以堅固， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S123_17","010_23_17","1SA","23","17","17","對他說：「不要懼怕！我父掃羅的手必不加害於你；你必作以色列的王，我也作你的宰相。這事我父掃羅知道了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S123_18","010_23_18","1SA","23","18","18","於是二人在耶和華面前立約。大衛仍住在樹林裏，約拿單回家去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S123_19","010_23_19","1SA","23","19","19","西弗人上到基比亞見掃羅，說：「大衛不是在我們那裏的樹林裏山寨中、曠野南邊的哈基拉山藏着嗎？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("S123_20","010_23_20","1SA","23","20","20","王啊，請你隨你的心願下來，我們必親自將他交在王的手裏。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S123_21","010_23_21","1SA","23","21","21","掃羅說：「願耶和華賜福與你們，因你們顧恤我。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S123_22","010_23_22","1SA","23","22","22","請你們回去，再確實查明他的住處和行蹤，是誰看見他在那裏，因為我聽見人說他甚狡猾。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S123_23","010_23_23","1SA","23","23","23","所以要看準他藏匿的地方，回來據實地告訴我，我就與你們同去。他若在猶大的境內，我必從千門萬戶中搜出他來。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S123_24","010_23_24","1SA","23","24","24","西弗人就起身，在掃羅以先往西弗去。 大衛和跟隨他的人卻在瑪雲曠野南邊的亞拉巴。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S123_25","010_23_25","1SA","23","25","25","掃羅和跟隨他的人去尋找大衛；有人告訴大衛，他就下到磐石，住在瑪雲的曠野。掃羅聽見，便在瑪雲的曠野追趕大衛。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S123_26","010_23_26","1SA","23","26","26","掃羅在山這邊走，大衛和跟隨他的人在山那邊走。大衛急忙躲避掃羅；因為掃羅和跟隨他的人，四面圍住大衛和跟隨他的人，要拿獲他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S123_27","010_23_27","1SA","23","27","27","忽有使者來報告掃羅說：「非利士人犯境搶掠，請王快快回去！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S123_28","010_23_28","1SA","23","28","28","於是掃羅不追趕大衛，回去攻打非利士人。因此那地方名叫西拉‧哈瑪希羅結。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S123_29","010_23_29","1SA","23","29","29","大衛從那裏上去，住在隱‧基底的山寨裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S124_1","010_24_1","1SA","24","1","1","掃羅追趕非利士人回來，有人告訴他說：「大衛在隱‧基底的曠野。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S124_2","010_24_2","1SA","24","2","2","掃羅就從以色列人中挑選三千精兵，率領他們往野羊的磐石去，尋索大衛和跟隨他的人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S124_3","010_24_3","1SA","24","3","3","到了路旁的羊圈，在那裏有洞，掃羅進去大解。大衛和跟隨他的人正藏在洞裏的深處。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S124_4","010_24_4","1SA","24","4","4","跟隨的人對大衛說：「耶和華曾應許你說：『我要將你的仇敵交在你手裏，你可以任意待他。』如今時候到了！」大衛就起來，悄悄地割下掃羅外袍的衣襟。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S124_5","010_24_5","1SA","24","5","5","隨後大衛心中自責，因為割下掃羅的衣襟； ");
INSERT INTO cmn_cu89t_vpl VALUES ("S124_6","010_24_6","1SA","24","6","6","對跟隨他的人說：「我的主乃是耶和華的受膏者，我在耶和華面前萬不敢伸手害他，因他是耶和華的受膏者。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S124_7","010_24_7","1SA","24","7","7","大衛用這話攔住跟隨他的人，不容他們起來害掃羅。掃羅起來，從洞裏出去行路。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S124_8","010_24_8","1SA","24","8","8","隨後大衛也起來，從洞裏出去，呼叫掃羅說：「我主，我王！」掃羅回頭觀看，大衛就屈身、臉伏於地下拜。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S124_9","010_24_9","1SA","24","9","9","大衛對掃羅說：「你為何聽信人的讒言，說大衛想要害你呢？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("S124_10","010_24_10","1SA","24","10","10","今日你親眼看見在洞中，耶和華將你交在我手裏；有人叫我殺你，我卻愛惜你，說：『我不敢伸手害我的主，因為他是耶和華的受膏者。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S124_11","010_24_11","1SA","24","11","11","我父啊，看看你外袍的衣襟在我手中。我割下你的衣襟，沒有殺你；你由此可以知道我沒有惡意叛逆你。你雖然獵取我的命，我卻沒有得罪你。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S124_12","010_24_12","1SA","24","12","12","願耶和華在你我中間判斷是非，在你身上為我伸冤，我卻不親手加害於你。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S124_13","010_24_13","1SA","24","13","13","古人有句俗語說：『惡事出於惡人。』我卻不親手加害於你。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S124_14","010_24_14","1SA","24","14","14","以色列王出來要尋找誰呢？追趕誰呢？不過追趕一條死狗，一個虼蚤就是了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S124_15","010_24_15","1SA","24","15","15","願耶和華在你我中間施行審判，斷定是非，並且鑒察，為我伸冤，救我脫離你的手。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S124_16","010_24_16","1SA","24","16","16","大衛向掃羅說完這話，掃羅說：「我兒大衛，這是你的聲音嗎？」就放聲大哭， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S124_17","010_24_17","1SA","24","17","17","對大衛說：「你比我公義；因為你以善待我，我卻以惡待你。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S124_18","010_24_18","1SA","24","18","18","你今日顯明是以善待我；因為耶和華將我交在你手裏，你卻沒有殺我。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S124_19","010_24_19","1SA","24","19","19","人若遇見仇敵，豈肯放他平安無事地去呢？願耶和華因你今日向我所行的，以善報你。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S124_20","010_24_20","1SA","24","20","20","我也知道你必要作王，以色列的國必堅立在你手裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S124_21","010_24_21","1SA","24","21","21","現在你要指着耶和華向我起誓，不剪除我的後裔，在我父家不滅沒我的名。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S124_22","010_24_22","1SA","24","22","22","於是大衛向掃羅起誓，掃羅就回家去；大衛和跟隨他的人上山寨去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S125_1","010_25_1","1SA","25","1","1","撒母耳死了，以色列眾人聚集，為他哀哭，將他葬在拉瑪－他自己的墳墓裏。 大衛起身，下到巴蘭的曠野。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S125_2","010_25_2","1SA","25","2","2","在瑪雲有一個人，他的產業在迦密，是一個大富戶，有三千綿羊，一千山羊；他正在迦密剪羊毛。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S125_3","010_25_3","1SA","25","3","3","那人名叫拿八，是迦勒族的人；他的妻名叫亞比該，是聰明俊美的婦人。拿八為人剛愎凶惡。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S125_4","010_25_4","1SA","25","4","4","大衛在曠野聽見說拿八剪羊毛， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S125_5","010_25_5","1SA","25","5","5","大衛就打發十個僕人，吩咐他們說：「你們上迦密去見拿八，提我的名問他安。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S125_6","010_25_6","1SA","25","6","6","要對那富戶如此說：『願你平安，願你家平安，願你一切所有的都平安。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S125_7","010_25_7","1SA","25","7","7","現在我聽說有人為你剪羊毛，你的牧人在迦密的時候和我們在一處，我們沒有欺負他們，他們也未曾失落甚麼。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S125_8","010_25_8","1SA","25","8","8","可以問你的僕人，他們必告訴你。所以願我的僕人在你眼前蒙恩，因為是在好日子來的。求你隨手取點賜與僕人和你兒子大衛。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S125_9","010_25_9","1SA","25","9","9","大衛的僕人到了，將這話提大衛的名都告訴了拿八，就住了口。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S125_10","010_25_10","1SA","25","10","10","拿八回答大衛的僕人說：「大衛是誰？耶西的兒子是誰？近來悖逆主人奔逃的僕人甚多， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S125_11","010_25_11","1SA","25","11","11","我豈可將飲食和為我剪羊毛人所宰的肉給我不知道從哪裏來的人呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S125_12","010_25_12","1SA","25","12","12","大衛的僕人就轉身從原路回去，照這話告訴大衛。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S125_13","010_25_13","1SA","25","13","13","大衛向跟隨他的人說：「你們各人都要帶上刀！」眾人就都帶上刀，大衛也帶上刀。跟隨大衛上去的約有四百人，留下二百人看守器具。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S125_14","010_25_14","1SA","25","14","14","有拿八的一個僕人告訴拿八的妻亞比該說：「大衛從曠野打發使者來問我主人的安，主人卻辱罵他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S125_15","010_25_15","1SA","25","15","15","但是那些人待我們甚好；我們在田野與他們來往的時候，沒有受他們的欺負，也未曾失落甚麼。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S125_16","010_25_16","1SA","25","16","16","我們在他們那裏牧羊的時候，他們晝夜作我們的保障。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S125_17","010_25_17","1SA","25","17","17","所以你當籌劃，看怎樣行才好；不然，禍患定要臨到我主人和他全家。他性情凶暴，無人敢與他說話。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S125_18","010_25_18","1SA","25","18","18","亞比該急忙將二百餅，兩皮袋酒，五隻收拾好了的羊，五細亞烘好了的穗子，一百葡萄餅，二百無花果餅，都馱在驢上， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S125_19","010_25_19","1SA","25","19","19","對僕人說：「你們前頭走，我隨着你們去。」這事她卻沒有告訴丈夫拿八。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S125_20","010_25_20","1SA","25","20","20","亞比該騎着驢，正下山坡，見大衛和跟隨他的人從對面下來，亞比該就迎接他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S125_21","010_25_21","1SA","25","21","21","大衛曾說：「我在曠野為那人看守所有的，以致他一樣不失落，實在是徒然了！他向我以惡報善。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S125_22","010_25_22","1SA","25","22","22","凡屬拿八的男丁，我若留一個到明日早晨，願上帝重重降罰與我！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S125_23","010_25_23","1SA","25","23","23","亞比該見大衛，便急忙下驢，在大衛面前臉伏於地叩拜， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S125_24","010_25_24","1SA","25","24","24","俯伏在大衛的腳前，說：「我主啊，願這罪歸我！求你容婢女向你進言，更求你聽婢女的話。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S125_25","010_25_25","1SA","25","25","25","我主不要理這壞人拿八，他的性情與他的名相稱；他名叫拿八，他為人果然愚頑。但我主所打發的僕人，婢女並沒有看見。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S125_26","010_25_26","1SA","25","26","26","我主啊，耶和華既然阻止你親手報仇，取流血的罪，所以我指着永生的耶和華、又敢在你面前起誓說：『願你的仇敵和謀害你的人都像拿八一樣。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S125_27","010_25_27","1SA","25","27","27","如今求你將婢女送來的禮物給跟隨你的僕人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S125_28","010_25_28","1SA","25","28","28","求你饒恕婢女的罪過。耶和華必為我主建立堅固的家，因我主為耶和華爭戰；並且在你平生的日子查不出有甚麼過來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S125_29","010_25_29","1SA","25","29","29","雖有人起來追逼你，尋索你的性命，你的性命卻在耶和華－你的上帝那裏蒙保護，如包裹寶器一樣；你仇敵的性命，耶和華必拋去，如用機弦甩石一樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S125_30","010_25_30","1SA","25","30","31","我主現在若不親手報仇流無辜人的血，到了耶和華照所應許你的話賜福與你，立你作以色列的王，那時我主必不致心裏不安，覺得良心有虧。耶和華賜福與我主的時候，求你記念婢女。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S125_32","010_25_32","1SA","25","32","32","大衛對亞比該說：「耶和華－以色列的上帝是應當稱頌的，因為他今日使你來迎接我。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S125_33","010_25_33","1SA","25","33","33","你和你的見識也當稱讚；因為你今日攔阻我親手報仇、流人的血。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S125_34","010_25_34","1SA","25","34","34","我指着阻止我加害於你的耶和華－以色列永生的上帝起誓，你若不速速地來迎接我，到明日早晨，凡屬拿八的男丁必定不留一個。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S125_35","010_25_35","1SA","25","35","35","大衛受了亞比該送來的禮物，就對她說：「我聽了你的話，准了你的情面，你可以平平安安地回家吧！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S125_36","010_25_36","1SA","25","36","36","亞比該到拿八那裏，見他在家裏設擺筵席，如同王的筵席；拿八快樂大醉。亞比該無論大小事都沒有告訴他，就等到次日早晨。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S125_37","010_25_37","1SA","25","37","37","到了早晨，拿八醒了酒，他的妻將這些事都告訴他，他就魂不附體，身僵如石頭一般。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S125_38","010_25_38","1SA","25","38","38","過了十天，耶和華擊打拿八，他就死了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S125_39","010_25_39","1SA","25","39","39","大衛聽見拿八死了，就說：「應當稱頌耶和華，因他伸了拿八羞辱我的冤，又阻止僕人行惡；也使拿八的惡歸到拿八的頭上。」於是大衛打發人去，與亞比該說，要娶她為妻。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S125_40","010_25_40","1SA","25","40","40","大衛的僕人到了迦密見亞比該，對她說：「大衛打發我們來見你，想要娶你為妻。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S125_41","010_25_41","1SA","25","41","41","亞比該就起來，俯伏在地，說：「我情願作婢女，洗我主僕人的腳。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S125_42","010_25_42","1SA","25","42","42","亞比該立刻起身，騎上驢，帶着五個使女，跟從大衛的使者去了，就作了大衛的妻。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S125_43","010_25_43","1SA","25","43","43","大衛先娶了耶斯列人亞希暖，她們二人都作了他的妻。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S125_44","010_25_44","1SA","25","44","44","掃羅已將他的女兒米甲，就是大衛的妻，給了迦琳人拉億的兒子帕提為妻。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S126_1","010_26_1","1SA","26","1","1","西弗人到基比亞見掃羅，說：「大衛不是在曠野前的哈基拉山藏着嗎？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S126_2","010_26_2","1SA","26","2","2","掃羅就起身，帶領以色列人中挑選的三千精兵下到西弗的曠野，要在那裏尋索大衛。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S126_3","010_26_3","1SA","26","3","3","掃羅在曠野前的哈基拉山，在道路上安營。大衛住在曠野，聽說掃羅到曠野來追尋他， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S126_4","010_26_4","1SA","26","4","4","就打發人去探聽，便知道掃羅果然來到。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S126_5","010_26_5","1SA","26","5","5","大衛起來，到掃羅安營的地方，看見掃羅和他的元帥尼珥的兒子押尼珥睡臥之處；掃羅睡在輜重營裏，百姓安營在他周圍。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S126_6","010_26_6","1SA","26","6","6","大衛對赫人亞希米勒和洗魯雅的兒子約押的兄弟亞比篩說：「誰同我下到掃羅營裏去？」亞比篩說：「我同你下去。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S126_7","010_26_7","1SA","26","7","7","於是大衛和亞比篩夜間到了百姓那裏，見掃羅睡在輜重營裏；他的槍在頭旁，插在地上。押尼珥和百姓睡在他周圍。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S126_8","010_26_8","1SA","26","8","8","亞比篩對大衛說：「現在上帝將你的仇敵交在你手裏，求你容我拿槍將他刺透在地，一刺就成，不用再刺。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S126_9","010_26_9","1SA","26","9","9","大衛對亞比篩說：「不可害死他。有誰伸手害耶和華的受膏者而無罪呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S126_10","010_26_10","1SA","26","10","10","大衛又說：「我指着永生的耶和華起誓，他或被耶和華擊打，或是死期到了，或是出戰陣亡； ");
INSERT INTO cmn_cu89t_vpl VALUES ("S126_11","010_26_11","1SA","26","11","11","我在耶和華面前，萬不敢伸手害耶和華的受膏者。現在你可以將他頭旁的槍和水瓶拿來，我們就走。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S126_12","010_26_12","1SA","26","12","12","大衛從掃羅的頭旁拿了槍和水瓶，二人就走了，沒有人看見，沒有人知道，也沒有人醒起，都睡着了，因為耶和華使他們沉沉地睡了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S126_13","010_26_13","1SA","26","13","13","大衛過到那邊去，遠遠地站在山頂上，與他們相離甚遠。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S126_14","010_26_14","1SA","26","14","14","大衛呼叫百姓和尼珥的兒子押尼珥說：「押尼珥啊，你為何不答應呢？」押尼珥說：「你是誰？竟敢呼叫王呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S126_15","010_26_15","1SA","26","15","15","大衛對押尼珥說：「你不是個勇士嗎？以色列中誰能比你呢？民中有人進來要害死王－你的主，你為何沒有保護王－你的主呢？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("S126_16","010_26_16","1SA","26","16","16","你這樣是不好的！我指着永生的耶和華起誓，你們都是該死的；因為沒有保護你們的主，就是耶和華的受膏者。現在你看看王頭旁的槍和水瓶在哪裏。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S126_17","010_26_17","1SA","26","17","17","掃羅聽出是大衛的聲音，就說：「我兒大衛，這是你的聲音嗎？」大衛說：「主－我的王啊，是我的聲音」； ");
INSERT INTO cmn_cu89t_vpl VALUES ("S126_18","010_26_18","1SA","26","18","18","又說：「我做了甚麼？我手裏有甚麼惡事？我主竟追趕僕人呢？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("S126_19","010_26_19","1SA","26","19","19","求我主我王聽僕人的話：若是耶和華激發你攻擊我，願耶和華收納祭物；若是人激發你，願他在耶和華面前受咒詛；因為他現今趕逐我，不容我在耶和華的產業上有分，說：『你去事奉別神吧！』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S126_20","010_26_20","1SA","26","20","20","現在求王不要使我的血流在離耶和華遠的地方。以色列王出來是尋找一個虼蚤，如同人在山上獵取一個鷓鴣一般。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S126_21","010_26_21","1SA","26","21","21","掃羅說：「我有罪了！我兒大衛，你可以回來，因你今日看我的性命為寶貴；我必不再加害於你。我是糊塗人，大大錯了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S126_22","010_26_22","1SA","26","22","22","大衛說：「王的槍在這裏，可以吩咐一個僕人過來拿去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S126_23","010_26_23","1SA","26","23","23","今日耶和華將王交在我手裏，我卻不肯伸手害耶和華的受膏者。耶和華必照各人的公義誠實報應他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S126_24","010_26_24","1SA","26","24","24","我今日重看你的性命，願耶和華也重看我的性命，並且拯救我脫離一切患難。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S126_25","010_26_25","1SA","26","25","25","掃羅對大衛說：「我兒大衛，願你得福！你必做大事，也必得勝。」於是大衛起行，掃羅回他的本處去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S127_1","010_27_1","1SA","27","1","1","大衛心裏說：「必有一日我死在掃羅手裏，不如逃奔非利士地去。掃羅見我不在以色列的境內，就必絕望，不再尋索我；這樣我可以脫離他的手。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S127_2","010_27_2","1SA","27","2","2","於是大衛起身，和跟隨他的六百人投奔迦特王－瑪俄的兒子亞吉去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S127_3","010_27_3","1SA","27","3","3","大衛和他的兩個妻，就是耶斯列人亞希暖和作過拿八妻的迦密人亞比該，並跟隨他的人，連各人的眷屬，都住在迦特的亞吉那裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S127_4","010_27_4","1SA","27","4","4","有人告訴掃羅說：「大衛逃到迦特。」掃羅就不再尋索他了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S127_5","010_27_5","1SA","27","5","5","大衛對亞吉說：「我若在你眼前蒙恩，求你在京外的城邑中賜我一個地方居住。僕人何必與王同住京都呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S127_6","010_27_6","1SA","27","6","6","當日亞吉將洗革拉賜給他，因此洗革拉屬猶大王，直到今日。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S127_7","010_27_7","1SA","27","7","7","大衛在非利士地住了一年零四個月。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S127_8","010_27_8","1SA","27","8","8","大衛和跟隨他的人上去，侵奪基述人、基色人、亞瑪力人之地。這幾族歷來住在那地，從書珥直到埃及。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S127_9","010_27_9","1SA","27","9","9","大衛擊殺那地的人，無論男女都沒有留下一個，又奪獲牛、羊、駱駝、驢，並衣服，回來見亞吉。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S127_10","010_27_10","1SA","27","10","10","亞吉說：「你們今日侵奪了甚麼地方呢？」大衛說：「侵奪了猶大的南方、耶拉篾的南方、基尼的南方。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S127_11","010_27_11","1SA","27","11","11","無論男女，大衛沒有留下一個帶到迦特來。他說：「恐怕他們將我們的事告訴人，說大衛住在非利士地的時候常常這樣行。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S127_12","010_27_12","1SA","27","12","12","亞吉信了大衛，心裏說：「大衛使本族以色列人憎惡他，所以他必永遠作我的僕人了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S128_1","010_28_1","1SA","28","1","1","那時，非利士人聚集軍旅，要與以色列人打仗。亞吉對大衛說：「你當知道，你和跟隨你的人都要隨我出戰。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S128_2","010_28_2","1SA","28","2","2","大衛對亞吉說：「僕人所能做的事，王必知道。」亞吉對大衛說：「這樣，我立你永遠作我的護衛長。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S128_3","010_28_3","1SA","28","3","3","那時撒母耳已經死了，以色列眾人為他哀哭，葬他在拉瑪，就是在他本城裏。掃羅曾在國內不容有交鬼的和行巫術的人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S128_4","010_28_4","1SA","28","4","4","非利士人聚集，來到書念安營；掃羅聚集以色列眾人在基利波安營。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S128_5","010_28_5","1SA","28","5","5","掃羅看見非利士的軍旅就懼怕，心中發顫。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S128_6","010_28_6","1SA","28","6","6","掃羅求問耶和華，耶和華卻不藉夢，或烏陵，或先知回答他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S128_7","010_28_7","1SA","28","7","7","掃羅吩咐臣僕說：「當為我找一個交鬼的婦人，我好去問她。」臣僕說：「在隱‧多珥有一個交鬼的婦人。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S128_8","010_28_8","1SA","28","8","8","於是掃羅改了裝，穿上別的衣服，帶着兩個人，夜裏去見那婦人。掃羅說：「求你用交鬼的法術，將我所告訴你的死人，為我招上來。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S128_9","010_28_9","1SA","28","9","9","婦人對他說：「你知道掃羅從國中剪除交鬼的和行巫術的。你為何陷害我的性命，使我死呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S128_10","010_28_10","1SA","28","10","10","掃羅向婦人指着耶和華起誓說：「我指着永生的耶和華起誓，你必不因這事受刑。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S128_11","010_28_11","1SA","28","11","11","婦人說：「我為你招誰上來呢？」回答說：「為我招撒母耳上來。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S128_12","010_28_12","1SA","28","12","12","婦人看見撒母耳，就大聲呼叫，對掃羅說：「你是掃羅，為甚麼欺哄我呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S128_13","010_28_13","1SA","28","13","13","王對婦人說：「不要懼怕，你看見了甚麼呢？」婦人對掃羅說：「我看見有神從地裏上來。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S128_14","010_28_14","1SA","28","14","14","掃羅說：「他是怎樣的形狀？」婦人說：「有一個老人上來，身穿長衣。」掃羅知道是撒母耳，就屈身，臉伏於地下拜。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S128_15","010_28_15","1SA","28","15","15","撒母耳對掃羅說：「你為甚麼攪擾我，招我上來呢？」掃羅回答說：「我甚窘急；因為非利士人攻擊我，上帝也離開我，不再藉先知或夢回答我。因此請你上來，好指示我應當怎樣行。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S128_16","010_28_16","1SA","28","16","16","撒母耳說：「耶和華已經離開你，且與你為敵，你何必問我呢？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("S128_17","010_28_17","1SA","28","17","17","耶和華照他藉我說的話，已經從你手裏奪去國權，賜與別人，就是大衛。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S128_18","010_28_18","1SA","28","18","18","因你沒有聽從耶和華的命令；他惱怒亞瑪力人，你沒有滅絕他們，所以今日耶和華向你這樣行， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S128_19","010_28_19","1SA","28","19","19","並且耶和華必將你和以色列人交在非利士人的手裏。明日你和你眾子必與我在一處了；耶和華必將以色列的軍兵交在非利士人手裏。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S128_20","010_28_20","1SA","28","20","20","掃羅猛然仆倒，挺身在地，因撒母耳的話甚是懼怕；那一晝一夜，沒有吃甚麼，就毫無氣力。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S128_21","010_28_21","1SA","28","21","21","婦人到掃羅面前，見他極其驚恐，對他說：「婢女聽從你的話，不顧惜自己的性命，遵從你所吩咐的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S128_22","010_28_22","1SA","28","22","22","現在求你聽婢女的話，容我在你面前擺上一點食物，你吃了，可以有氣力行路。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S128_23","010_28_23","1SA","28","23","23","掃羅不肯，說：「我不吃。」但他的僕人和婦人再三勸他，他才聽了他們的話，從地上起來，坐在床上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S128_24","010_28_24","1SA","28","24","24","婦人急忙將家裏的一隻肥牛犢宰了，又拿麵摶成無酵餅烤了， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S128_25","010_28_25","1SA","28","25","25","擺在掃羅和他僕人面前。他們吃完，當夜就起身走了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S129_1","010_29_1","1SA","29","1","1","非利士人將他們的軍旅聚到亞弗；以色列人在耶斯列的泉旁安營。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S129_2","010_29_2","1SA","29","2","2","非利士人的首領各率軍隊，或百或千，挨次前進；大衛和跟隨他的人同着亞吉跟在後邊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S129_3","010_29_3","1SA","29","3","3","非利士人的首領說：「這些希伯來人在這裏做甚麼呢？」亞吉對他們說：「這不是以色列王掃羅的臣子大衛嗎？他在我這裏有些年日了。自從他投降我直到今日，我未曾見他有過錯。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S129_4","010_29_4","1SA","29","4","4","非利士人的首領向亞吉發怒，對他說：「你要叫這人回你所安置他的地方，不可叫他同我們出戰，恐怕他在陣上反為我們的敵人。他用甚麼與他主人復和呢？豈不是用我們這些人的首級嗎？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("S129_5","010_29_5","1SA","29","5","5","從前以色列的婦女跳舞唱和說：『掃羅殺死千千，大衛殺死萬萬』，所說的不是這個大衛嗎？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S129_6","010_29_6","1SA","29","6","6","亞吉叫大衛來，對他說：「我指着永生的耶和華起誓，你是正直人。你隨我在軍中出入，我看你甚好。自從你投奔我到如今，我未曾見你有甚麼過失；只是眾首領不喜悅你。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S129_7","010_29_7","1SA","29","7","7","現在你可以平平安安地回去，免得非利士人的首領不歡喜你。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S129_8","010_29_8","1SA","29","8","8","大衛對亞吉說：「我做了甚麼呢？自從僕人到你面前，直到今日，你查出我有甚麼過錯，使我不去攻擊主－我王的仇敵呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S129_9","010_29_9","1SA","29","9","9","亞吉說：「我知道你在我眼前是好人，如同上帝的使者一般；只是非利士人的首領說：『這人不可同我們出戰。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S129_10","010_29_10","1SA","29","10","10","故此你和跟隨你的人，就是你本主的僕人，要明日早晨起來，等到天亮回去吧！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S129_11","010_29_11","1SA","29","11","11","於是大衛和跟隨他的人早晨起來，回往非利士地去。非利士人也上耶斯列去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S130_1","010_30_1","1SA","30","1","1","第三日，大衛和跟隨他的人到了洗革拉。亞瑪力人已經侵奪南地，攻破洗革拉，用火焚燒， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S130_2","010_30_2","1SA","30","2","2","擄了城內的婦女和其中的大小人口，卻沒有殺一個，都帶着走了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S130_3","010_30_3","1SA","30","3","3","大衛和跟隨他的人到了那城，不料，城已燒毀，他們的妻子兒女都被擄去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S130_4","010_30_4","1SA","30","4","4","大衛和跟隨他的人就放聲大哭，直哭得沒有氣力。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S130_5","010_30_5","1SA","30","5","5","大衛的兩個妻－耶斯列人亞希暖和作過拿八妻的迦密人亞比該，也被擄去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S130_6","010_30_6","1SA","30","6","6","大衛甚是焦急，因眾人為自己的兒女苦惱，說：「要用石頭打死他。」大衛卻倚靠耶和華－他的上帝，心裏堅固。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S130_7","010_30_7","1SA","30","7","7","大衛對亞希米勒的兒子祭司亞比亞他說：「請你將以弗得拿過來。」亞比亞他就將以弗得拿到大衛面前。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S130_8","010_30_8","1SA","30","8","8","大衛求問耶和華說：「我追趕敵軍，追得上追不上呢？」耶和華說：「你可以追，必追得上，都救得回來。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S130_9","010_30_9","1SA","30","9","9","於是，大衛和跟隨他的六百人來到比梭溪；有不能前去的就留在那裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S130_10","010_30_10","1SA","30","10","10","大衛卻帶着四百人往前追趕，有二百人疲乏，不能過比梭溪，所以留在那裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S130_11","010_30_11","1SA","30","11","11","這四百人在田野遇見一個埃及人，就帶他到大衛面前，給他餅吃，給他水喝， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S130_12","010_30_12","1SA","30","12","12","又給他一塊無花果餅，兩個葡萄餅。他吃了，就精神復原；因為他三日三夜沒有吃餅，沒有喝水。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S130_13","010_30_13","1SA","30","13","13","大衛問他說：「你是屬誰的？你是哪裏的人？」他回答說：「我是埃及的少年人，是亞瑪力人的奴僕；因我三日前患病，我主人就把我撇棄了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S130_14","010_30_14","1SA","30","14","14","我們侵奪了基利提的南方和屬猶大的地，並迦勒地的南方，又用火燒了洗革拉。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S130_15","010_30_15","1SA","30","15","15","大衛問他說：「你肯領我們到敵軍那裏不肯？」他回答說：「你要向我指着上帝起誓，不殺我，也不將我交在我主人手裏，我就領你下到敵軍那裏。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S130_16","010_30_16","1SA","30","16","16","那人領大衛下去，見他們散在地上，吃喝跳舞，因為從非利士地和猶大地所擄來的財物甚多。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S130_17","010_30_17","1SA","30","17","17","大衛從黎明直到次日晚上，擊殺他們，除了四百騎駱駝的少年人之外，沒有一個逃脫的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S130_18","010_30_18","1SA","30","18","18","亞瑪力人所擄去的財物，大衛全都奪回，並救回他的兩個妻來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S130_19","010_30_19","1SA","30","19","19","凡亞瑪力人所擄去的，無論大小、兒女、財物，大衛都奪回來，沒有失落一個。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S130_20","010_30_20","1SA","30","20","20","大衛所奪來的牛群羊群，跟隨他的人趕在原有的群畜前邊，說：「這是大衛的掠物。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S130_21","010_30_21","1SA","30","21","21","大衛到了那疲乏不能跟隨、留在比梭溪的二百人那裏。他們出來迎接大衛並跟隨的人。大衛前來問他們安。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S130_22","010_30_22","1SA","30","22","22","跟隨大衛人中的惡人和匪類說：「這些人既然沒有和我們同去，我們所奪的財物就不分給他們，只將他們各人的妻子兒女給他們，使他們帶去就是了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S130_23","010_30_23","1SA","30","23","23","大衛說：「弟兄們，耶和華所賜給我們的，不可不分給他們；因為他保佑我們，將那攻擊我們的敵軍交在我們手裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S130_24","010_30_24","1SA","30","24","24","這事誰肯依從你們呢？上陣的得多少，看守器具的也得多少；應當大家平分。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S130_25","010_30_25","1SA","30","25","25","大衛定此為以色列的律例典章，從那日直到今日。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S130_26","010_30_26","1SA","30","26","26","大衛到了洗革拉，從掠物中取些送給他朋友猶大的長老，說：「這是從耶和華仇敵那裏奪來的，送你們為禮物。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S130_27","010_30_27","1SA","30","27","27","他送禮物給住伯特利的，南地拉末的，雅提珥的； ");
INSERT INTO cmn_cu89t_vpl VALUES ("S130_28","010_30_28","1SA","30","28","28","住亞羅珥的，息末的，以實提莫的； ");
INSERT INTO cmn_cu89t_vpl VALUES ("S130_29","010_30_29","1SA","30","29","29","住拉哈勒的，耶拉篾各城的，基尼各城的； ");
INSERT INTO cmn_cu89t_vpl VALUES ("S130_30","010_30_30","1SA","30","30","30","住何珥瑪的，歌拉珊的，亞撻的； ");
INSERT INTO cmn_cu89t_vpl VALUES ("S130_31","010_30_31","1SA","30","31","31","住希伯崙的，並大衛和跟隨他的人素來所到之處的人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S131_1","010_31_1","1SA","31","1","1","非利士人與以色列人爭戰。以色列人在非利士人面前逃跑，在基利波有被殺仆倒的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S131_2","010_31_2","1SA","31","2","2","非利士人緊追掃羅和他兒子們，就殺了掃羅的兒子約拿單、亞比拿達、麥基舒亞。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S131_3","010_31_3","1SA","31","3","3","勢派甚大，掃羅被弓箭手追上，射傷甚重， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S131_4","010_31_4","1SA","31","4","4","就吩咐拿他兵器的人說：「你拔出刀來，將我刺死，免得那些未受割禮的人來刺我，凌辱我。」但拿兵器的人甚懼怕，不肯刺他；掃羅就自己伏在刀上死了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S131_5","010_31_5","1SA","31","5","5","拿兵器的人見掃羅已死，也伏在刀上死了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S131_6","010_31_6","1SA","31","6","6","這樣，掃羅和他三個兒子，與拿他兵器的人，以及跟隨他的人，都一同死亡。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S131_7","010_31_7","1SA","31","7","7","住平原那邊並約旦河西的以色列人，見以色列軍兵逃跑，掃羅和他兒子都死了，也就棄城逃跑。非利士人便來住在其中。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S131_8","010_31_8","1SA","31","8","8","次日，非利士人來剝那被殺之人的衣服，看見掃羅和他三個兒子仆倒在基利波山， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S131_9","010_31_9","1SA","31","9","9","就割下他的首級，剝了他的軍裝，打發人到 非利士地的四境，報信與他們廟裏的偶像和眾民； ");
INSERT INTO cmn_cu89t_vpl VALUES ("S131_10","010_31_10","1SA","31","10","10","又將掃羅的軍裝放在亞斯她錄廟裏，將他的屍身釘在伯‧珊的城牆上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S131_11","010_31_11","1SA","31","11","11","基列‧雅比的居民聽見非利士人向掃羅所行的事， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S131_12","010_31_12","1SA","31","12","12","他們中間所有的勇士就起身，走了一夜，將掃羅和他兒子的屍身從伯‧珊城牆上取下來，送到雅比那裏，用火燒了； ");
INSERT INTO cmn_cu89t_vpl VALUES ("S131_13","010_31_13","1SA","31","13","13","將他們骸骨葬在雅比的垂絲柳樹下，就禁食七日。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S21_1","011_1_1","2SA","1","1","1","掃羅死後，大衛擊殺亞瑪力人回來，在洗革拉住了兩天。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S21_2","011_1_2","2SA","1","2","2","第三天，有一人從掃羅的營裏出來，衣服撕裂，頭蒙灰塵，到大衛面前伏地叩拜。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S21_3","011_1_3","2SA","1","3","3","大衛問他說：「你從哪裏來？」他說：「我從以色列的營裏逃來。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S21_4","011_1_4","2SA","1","4","4","大衛又問他說：「事情怎樣？請你告訴我。」他回答說：「百姓從陣上逃跑，也有許多人仆倒死亡；掃羅和他兒子約拿單也死了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S21_5","011_1_5","2SA","1","5","5","大衛問報信的少年人說：「你怎麼知道掃羅和他兒子約拿單死了呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S21_6","011_1_6","2SA","1","6","6","報信的少年人說：「我偶然到基利波山，看見掃羅伏在自己槍上，有戰車、馬兵緊緊地追他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S21_7","011_1_7","2SA","1","7","7","他回頭看見我，就呼叫我。我說：『我在這裏。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S21_8","011_1_8","2SA","1","8","8","他問我說：『你是甚麼人？』我說：『我是亞瑪力人。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S21_9","011_1_9","2SA","1","9","9","他說：『請你來，將我殺死；因為痛苦抓住我，我的生命尚存。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S21_10","011_1_10","2SA","1","10","10","我準知他仆倒必不能活，就去將他殺死，把他頭上的冠冕、臂上的鐲子拿到我主這裏。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S21_11","011_1_11","2SA","1","11","11","大衛就撕裂衣服，跟隨他的人也是如此， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S21_12","011_1_12","2SA","1","12","12","而且悲哀哭號，禁食到晚上，是因掃羅和他兒子約拿單，並耶和華的民以色列家的人，倒在刀下。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S21_13","011_1_13","2SA","1","13","13","大衛問報信的少年人說：「你是哪裏的人？」他說：「我是亞瑪力客人的兒子。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S21_14","011_1_14","2SA","1","14","14","大衛說：「你伸手殺害耶和華的受膏者，怎麼不畏懼呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S21_15","011_1_15","2SA","1","15","15","大衛叫了一個少年人來，說：「你去殺他吧！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S21_16","011_1_16","2SA","1","16","16","大衛對他說：「你流人血的罪歸到自己的頭上，因為你親口作見證說：『我殺了耶和華的受膏者。』」少年人就把他殺了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S21_17","011_1_17","2SA","1","17","17","大衛作哀歌，弔掃羅和他兒子約拿單， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S21_18","011_1_18","2SA","1","18","18","且吩咐將這歌教導猶大人。這歌名叫「弓歌」，寫在雅煞珥書上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S21_19","011_1_19","2SA","1","19","19","歌中說：以色列啊， 你尊榮者在山上被殺！ 大英雄何竟死亡！ ");
INSERT INTO cmn_cu89t_vpl VALUES ("S21_20","011_1_20","2SA","1","20","20","不要在迦特報告； 不要在亞實基倫街上傳揚； 免得非利士的女子歡樂； 免得未受割禮之人的女子矜誇。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S21_21","011_1_21","2SA","1","21","21","基利波山哪，願你那裏沒有雨露！ 願你田地無土產可作供物！ 因為英雄的盾牌在那裏被污丟棄； 掃羅的盾牌彷彿未曾抹油。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S21_22","011_1_22","2SA","1","22","22","約拿單的弓箭非流敵人的血不退縮； 掃羅的刀劍非剖勇士的油不收回。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S21_23","011_1_23","2SA","1","23","23","掃羅和約拿單－ 活時相悅相愛，死時也不分離 －他們比鷹更快，比獅子還強。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S21_24","011_1_24","2SA","1","24","24","以色列的女子啊，當為掃羅哭號！ 他曾使你們穿朱紅色的美衣， 使你們衣服有黃金的妝飾。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S21_25","011_1_25","2SA","1","25","25","英雄何竟在陣上仆倒！ 約拿單何竟在山上被殺！ ");
INSERT INTO cmn_cu89t_vpl VALUES ("S21_26","011_1_26","2SA","1","26","26","我兄約拿單哪，我為你悲傷！ 我甚喜悅你！ 你向我發的愛情奇妙非常， 過於婦女的愛情。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S21_27","011_1_27","2SA","1","27","27","英雄何竟仆倒！ 戰具何竟滅沒！ ");
INSERT INTO cmn_cu89t_vpl VALUES ("S22_1","011_2_1","2SA","2","1","1","此後，大衛問耶和華說：「我上猶大的一個城去可以嗎？」耶和華說：「可以。」大衛說：「我上哪一個城去呢？」耶和華說：「上希伯崙去。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S22_2","011_2_2","2SA","2","2","2","於是大衛和他的兩個妻－一個是耶斯列人亞希暖，一個是作過迦密人拿八妻的亞比該－都上那裏去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S22_3","011_2_3","2SA","2","3","3","大衛也將跟隨他的人和他們各人的眷屬一同帶上去，住在希伯崙的城邑中。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S22_4","011_2_4","2SA","2","4","4","猶大人來到希伯崙，在那裏膏大衛作猶大家的王。 有人告訴大衛說：「葬埋掃羅的是基列‧雅比人。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S22_5","011_2_5","2SA","2","5","5","大衛就差人去見基列‧雅比人，對他們說：「你們厚待你們的主－掃羅，將他葬埋。願耶和華賜福與你們！ ");
INSERT INTO cmn_cu89t_vpl VALUES ("S22_6","011_2_6","2SA","2","6","6","你們既行了這事，願耶和華以慈愛誠實待你們，我也要為此厚待你們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S22_7","011_2_7","2SA","2","7","7","現在你們的主－掃羅死了，猶大家已經膏我作他們的王，所以你們要剛強奮勇。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S22_8","011_2_8","2SA","2","8","8","掃羅的元帥尼珥的兒子押尼珥，曾將掃羅的兒子伊施波設帶過河，到瑪哈念， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S22_9","011_2_9","2SA","2","9","9","立他作王，治理基列、亞書利、耶斯列、以法蓮、便雅憫，和以色列眾人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S22_10","011_2_10","2SA","2","10","10","掃羅的兒子伊施波設登基的時候年四十歲，作以色列王二年；惟獨猶大家歸從大衛。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S22_11","011_2_11","2SA","2","11","11","大衛在希伯崙作猶大家的王，共七年零六個月。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S22_12","011_2_12","2SA","2","12","12","尼珥的兒子押尼珥和掃羅的兒子伊施波設的僕人從瑪哈念出來，往基遍去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S22_13","011_2_13","2SA","2","13","13","洗魯雅的兒子約押和大衛的僕人也出來，在基遍池旁與他們相遇；一班坐在池這邊，一班坐在池那邊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S22_14","011_2_14","2SA","2","14","14","押尼珥對約押說：「讓少年人起來，在我們面前戲耍吧！」約押說：「可以。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S22_15","011_2_15","2SA","2","15","15","就按着定數起來：屬掃羅兒子伊施波設的便雅憫人過去十二名，大衛的僕人也過去十二名， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S22_16","011_2_16","2SA","2","16","16","彼此揪頭，用刀刺肋，一同仆倒。所以，那地叫做希利甲‧哈素林，就在基遍。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S22_17","011_2_17","2SA","2","17","17","那日的戰事凶猛，押尼珥和以色列人敗在大衛的僕人面前。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S22_18","011_2_18","2SA","2","18","18","在那裏有洗魯雅的三個兒子：約押、亞比篩、亞撒黑。亞撒黑腳快如野鹿一般； ");
INSERT INTO cmn_cu89t_vpl VALUES ("S22_19","011_2_19","2SA","2","19","19","亞撒黑追趕押尼珥，直追趕他不偏左右。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S22_20","011_2_20","2SA","2","20","20","押尼珥回頭說：「你是亞撒黑嗎？」回答說：「是。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S22_21","011_2_21","2SA","2","21","21","押尼珥對他說：「你或轉向左轉向右，拿住一個少年人，剝去他的戰衣。」亞撒黑卻不肯轉開不追趕他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S22_22","011_2_22","2SA","2","22","22","押尼珥又對亞撒黑說：「你轉開不追趕我吧！我何必殺你呢？若殺你，有甚麼臉見你哥哥約押呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S22_23","011_2_23","2SA","2","23","23","亞撒黑仍不肯轉開。故此，押尼珥就用槍鐏刺入他的肚腹，甚至槍從背後透出，亞撒黑就在那裏仆倒而死。眾人趕到亞撒黑仆倒而死的地方，就都站住。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S22_24","011_2_24","2SA","2","24","24","約押和亞比篩追趕押尼珥，日落的時候，到了通基遍曠野的路旁，基亞對面的亞瑪山。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S22_25","011_2_25","2SA","2","25","25","便雅憫人聚集，跟隨押尼珥站在一個山頂上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S22_26","011_2_26","2SA","2","26","26","押尼珥呼叫約押說：「刀劍豈可永遠殺人嗎？你豈不知終久必有苦楚嗎？你要等何時才叫百姓回去、不追趕弟兄呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S22_27","011_2_27","2SA","2","27","27","約押說：「我指着永生的上帝起誓：你若不說戲耍的那句話，今日早晨百姓就回去，不追趕弟兄了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S22_28","011_2_28","2SA","2","28","28","於是約押吹角，眾民就站住，不再追趕以色列人，也不再打仗了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S22_29","011_2_29","2SA","2","29","29","押尼珥和跟隨他的人整夜經過亞拉巴，過約旦河，走過畢倫，到了瑪哈念。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S22_30","011_2_30","2SA","2","30","30","約押追趕押尼珥回來，聚集眾民，見大衛的僕人中缺少了十九個人和亞撒黑。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S22_31","011_2_31","2SA","2","31","31","但大衛的僕人殺了便雅憫人和跟隨押尼珥的人，共三百六十名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S22_32","011_2_32","2SA","2","32","32","眾人將亞撒黑送到伯利恆，葬在他父親的墳墓裏。約押和跟隨他的人走了一夜，天亮的時候到了希伯崙。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S23_1","011_3_1","2SA","3","1","1","掃羅家和大衛家爭戰許久。大衛家日見強盛；掃羅家日見衰弱。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S23_2","011_3_2","2SA","3","2","2","大衛在希伯崙得了幾個兒子：長子暗嫩是耶斯列人亞希暖所生的； ");
INSERT INTO cmn_cu89t_vpl VALUES ("S23_3","011_3_3","2SA","3","3","3","次子基利押是作過迦密人拿八的妻亞比該所生的；三子押沙龍是基述王達買的女兒瑪迦所生的； ");
INSERT INTO cmn_cu89t_vpl VALUES ("S23_4","011_3_4","2SA","3","4","4","四子亞多尼雅是哈及所生的；五子示法提雅是亞比她所生的； ");
INSERT INTO cmn_cu89t_vpl VALUES ("S23_5","011_3_5","2SA","3","5","5","六子以特念是大衛的妻以格拉所生的。大衛這六個兒子都是在希伯崙生的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S23_6","011_3_6","2SA","3","6","6","掃羅家和大衛家爭戰的時候，押尼珥在掃羅家大有權勢。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S23_7","011_3_7","2SA","3","7","7","掃羅有一妃嬪，名叫利斯巴，是愛亞的女兒。一日，伊施波設對押尼珥說：「你為甚麼與我父的妃嬪同房呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S23_8","011_3_8","2SA","3","8","8","押尼珥因伊施波設的話就甚發怒，說：「我豈是猶大的狗頭呢？我恩待你父掃羅的家和他的弟兄、朋友，不將你交在大衛手裏，今日你竟為這婦人責備我嗎？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("S23_9","011_3_9","2SA","3","9","10","我若不照着耶和華起誓應許大衛的話行，廢去掃羅的位，建立大衛的位，使他治理以色列和猶大，從但直到別是巴，願上帝重重地降罰與我！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S23_11","011_3_11","2SA","3","11","11","伊施波設懼怕押尼珥，不敢回答一句。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S23_12","011_3_12","2SA","3","12","12","押尼珥打發人去見大衛，替他說：「這國歸誰呢？」又說：「你與我立約，我必幫助你，使以色列人都歸服你。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S23_13","011_3_13","2SA","3","13","13","大衛說：「好！我與你立約。但有一件，你來見我面的時候，若不將掃羅的女兒米甲帶來，必不得見我的面。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S23_14","011_3_14","2SA","3","14","14","大衛就打發人去見掃羅的兒子伊施波設，說：「你要將我的妻米甲歸還我；她是我從前用一百非利士人的陽皮所聘定的。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S23_15","011_3_15","2SA","3","15","15","伊施波設就打發人去，將米甲從拉億的兒子、她丈夫帕鐵那裏接回來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S23_16","011_3_16","2SA","3","16","16","米甲的丈夫跟着她，一面走一面哭，直跟到巴戶琳。押尼珥說：「你回去吧！」帕鐵就回去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S23_17","011_3_17","2SA","3","17","17","押尼珥對以色列長老說：「從前你們願意大衛作王治理你們， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S23_18","011_3_18","2SA","3","18","18","現在你們可以照心願而行。因為耶和華曾論到大衛說：『我必藉我僕人大衛的手，救我民以色列脫離非利士人和眾仇敵的手。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S23_19","011_3_19","2SA","3","19","19","押尼珥也用這話說給便雅憫人聽，又到希伯崙，將以色列人和便雅憫全家一切所喜悅的事說給大衛聽。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S23_20","011_3_20","2SA","3","20","20","押尼珥帶着二十個人來到希伯崙見大衛，大衛就為押尼珥和他帶來的人設擺筵席。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S23_21","011_3_21","2SA","3","21","21","押尼珥對大衛說：「我要起身去招聚以色列眾人來見我主我王，與你立約，你就可以照着心願作王。」於是大衛送押尼珥去，押尼珥就平平安安地去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S23_22","011_3_22","2SA","3","22","22","約押和大衛的僕人攻擊敵軍，帶回許多的掠物。那時押尼珥不在希伯崙大衛那裏，因大衛已經送他去，他也平平安安地去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S23_23","011_3_23","2SA","3","23","23","約押和跟隨他的全軍到了，就有人告訴約押說：「尼珥的兒子押尼珥來見王，王送他去，他也平平安安地去了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S23_24","011_3_24","2SA","3","24","24","約押去見王說：「你這是做甚麼呢？押尼珥來見你，你為何送他去，他就蹤影不見了呢？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("S23_25","011_3_25","2SA","3","25","25","你當曉得，尼珥的兒子押尼珥來是要誆哄你，要知道你的出入和你一切所行的事。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S23_26","011_3_26","2SA","3","26","26","約押從大衛那裏出來，就打發人去追趕押尼珥，在西拉井追上他，將他帶回來，大衛卻不知道。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S23_27","011_3_27","2SA","3","27","27","押尼珥回到希伯崙，約押領他到城門的甕洞，假作要與他說機密話，就在那裏刺透他的肚腹，他便死了。這是報殺他兄弟亞撒黑的仇。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S23_28","011_3_28","2SA","3","28","28","大衛聽見了，就說：「流尼珥的兒子押尼珥的血，這罪在耶和華面前必永不歸我和我的國。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S23_29","011_3_29","2SA","3","29","29","願流他血的罪歸到約押頭上和他父的全家；又願約押家不斷有患漏症的，長大痲瘋的，架柺而行的，被刀殺死的，缺乏飲食的。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S23_30","011_3_30","2SA","3","30","30","約押和他兄弟亞比篩殺了押尼珥，是因押尼珥在基遍爭戰的時候殺了他們的兄弟亞撒黑。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S23_31","011_3_31","2SA","3","31","31","大衛吩咐約押和跟隨他的眾人說：「你們當撕裂衣服，腰束麻布，在押尼珥棺前哀哭。」大衛王也跟在棺後。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S23_32","011_3_32","2SA","3","32","32","他們將押尼珥葬在希伯崙。王在押尼珥的墓旁放聲而哭，眾民也都哭了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S23_33","011_3_33","2SA","3","33","33","王為押尼珥舉哀，說： 押尼珥何竟像愚頑人死呢？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("S23_34","011_3_34","2SA","3","34","34","你手未曾捆綁，腳未曾鎖住。 你死，如人死在罪孽之輩手下一樣。 於是眾民又為押尼珥哀哭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S23_35","011_3_35","2SA","3","35","35","日頭未落的時候，眾民來勸大衛吃飯，但大衛起誓說：「我若在日頭未落以前吃飯，或吃別物，願上帝重重地降罰與我！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S23_36","011_3_36","2SA","3","36","36","眾民知道了就都喜悅。凡王所行的，眾民無不喜悅。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S23_37","011_3_37","2SA","3","37","37","那日，以色列眾民才知道殺尼珥的兒子押尼珥並非出於王意。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S23_38","011_3_38","2SA","3","38","38","王對臣僕說：「你們豈不知今日以色列人中死了一個作元帥的大丈夫嗎？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("S23_39","011_3_39","2SA","3","39","39","我雖然受膏為王，今日還是軟弱；這洗魯雅的兩個兒子比我剛強。願耶和華照着惡人所行的惡報應他。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S24_1","011_4_1","2SA","4","1","1","掃羅的兒子伊施波設聽見押尼珥死在希伯崙，手就發軟；以色列眾人也都驚惶。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S24_2","011_4_2","2SA","4","2","2","掃羅的兒子伊施波設有兩個軍長，一名巴拿，一名利甲，是便雅憫支派、比錄人臨門的兒子。比錄也屬便雅憫。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S24_3","011_4_3","2SA","4","3","3","比錄人早先逃到基他音，在那裏寄居，直到今日。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S24_4","011_4_4","2SA","4","4","4","掃羅的兒子約拿單有一個兒子名叫米非波設，是瘸腿的。掃羅和約拿單死亡的消息從耶斯列傳到的時候，他才五歲。他乳母抱着他逃跑；因為跑得太急，孩子掉在地上，腿就瘸了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S24_5","011_4_5","2SA","4","5","5","一日，比錄人臨門的兩個兒子利甲和巴拿出去，約在午熱的時候到了伊施波設的家；伊施波設正睡午覺。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S24_6","011_4_6","2SA","4","6","6","他們進了房子，假作要取麥子，就刺透伊施波設的肚腹，逃跑了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S24_7","011_4_7","2SA","4","7","7","他們進房子的時候，伊施波設正在臥房裏躺在床上，他們將他殺死，割了他的首級，拿着首級在亞拉巴走了一夜， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S24_8","011_4_8","2SA","4","8","8","將伊施波設的首級拿到希伯崙見大衛王，說：「王的仇敵掃羅曾尋索王的性命。看哪，這是他兒子伊施波設的首級；耶和華今日為我主我王在掃羅和他後裔的身上報了仇。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S24_9","011_4_9","2SA","4","9","9","大衛對比錄人臨門的兒子利甲和他兄弟巴拿說：「我指着救我性命脫離一切苦難、永生的耶和華起誓： ");
INSERT INTO cmn_cu89t_vpl VALUES ("S24_10","011_4_10","2SA","4","10","10","從前有人報告我說，掃羅死了，他自以為報好消息；我就拿住他，將他殺在洗革拉，這就作了他報消息的賞賜。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S24_11","011_4_11","2SA","4","11","11","何況惡人將義人殺在他的床上，我豈不向你們討流他血的罪、從世上除滅你們呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S24_12","011_4_12","2SA","4","12","12","於是大衛吩咐少年人將他們殺了，砍斷他們的手腳，掛在希伯崙的池旁，卻將伊施波設的首級葬在希伯崙押尼珥的墳墓裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S25_1","011_5_1","2SA","5","1","1","以色列眾支派來到希伯崙見大衛，說：「我們原是你的骨肉。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S25_2","011_5_2","2SA","5","2","2","從前掃羅作我們王的時候，率領以色列人出入的是你；耶和華也曾應許你說：『你必牧養我的民以色列，作以色列的君。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S25_3","011_5_3","2SA","5","3","3","於是以色列的長老都來到希伯崙見大衛王，大衛在希伯崙耶和華面前與他們立約，他們就膏大衛作以色列的王。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S25_4","011_5_4","2SA","5","4","4","大衛登基的時候年三十歲，在位四十年； ");
INSERT INTO cmn_cu89t_vpl VALUES ("S25_5","011_5_5","2SA","5","5","5","在希伯崙作猶大王七年零六個月，在耶路撒冷作以色列和猶大王三十三年。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S25_6","011_5_6","2SA","5","6","6","大衛和跟隨他的人到了耶路撒冷，要攻打住那地方的耶布斯人。耶布斯人對大衛說：「你若不趕出瞎子、瘸子，必不能進這地方」；心裏想大衛決不能進去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S25_7","011_5_7","2SA","5","7","7","然而大衛攻取錫安的保障，就是大衛的城。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S25_8","011_5_8","2SA","5","8","8","當日，大衛說：「誰攻打耶布斯人，當上水溝攻打我心裏所恨惡的瘸子、瞎子。」從此有俗語說：「在那裏有瞎子、瘸子，他不能進屋去。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S25_9","011_5_9","2SA","5","9","9","大衛住在保障裏，給保障起名叫大衛城。大衛又從米羅以裏，周圍築牆。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S25_10","011_5_10","2SA","5","10","10","大衛日見強盛，因為耶和華－萬軍之上帝與他同在。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S25_11","011_5_11","2SA","5","11","11","泰爾王希蘭將香柏木運到大衛那裏，又差遣使者和木匠、石匠給大衛建造宮殿。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S25_12","011_5_12","2SA","5","12","12","大衛就知道耶和華堅立他作以色列王，又為自己的民以色列使他的國興旺。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S25_13","011_5_13","2SA","5","13","13","大衛離開希伯崙之後，在耶路撒冷又立后妃，又生兒女。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S25_14","011_5_14","2SA","5","14","14","在耶路撒冷所生的兒子是沙母亞、朔罷、拿單、所羅門、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S25_15","011_5_15","2SA","5","15","15","益轄、以利書亞、尼斐、雅非亞、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S25_16","011_5_16","2SA","5","16","16","以利沙瑪、以利雅大、以利法列。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S25_17","011_5_17","2SA","5","17","17","非利士人聽見人膏大衛作以色列王，非利士眾人就上來尋索大衛；大衛聽見，就下到保障。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S25_18","011_5_18","2SA","5","18","18","非利士人來了，布散在利乏音谷。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S25_19","011_5_19","2SA","5","19","19","大衛求問耶和華說：「我可以上去攻打非利士人嗎？你將他們交在我手裏嗎？」耶和華說：「你可以上去，我必將非利士人交在你手裏。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S25_20","011_5_20","2SA","5","20","20","大衛來到巴力‧毗拉心，在那裏擊殺非利士人，說：「耶和華在我面前沖破敵人，如同水沖去一般。」因此稱那地方為巴力‧毗拉心。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S25_21","011_5_21","2SA","5","21","21","非利士人將偶像撇在那裏，大衛和跟隨他的人拿去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S25_22","011_5_22","2SA","5","22","22","非利士人又上來，布散在利乏音谷。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S25_23","011_5_23","2SA","5","23","23","大衛求問耶和華；耶和華說：「不要一直地上去，要轉到他們後頭，從桑林對面攻打他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S25_24","011_5_24","2SA","5","24","24","你聽見桑樹梢上有腳步的聲音，就要急速前去，因為那時耶和華已經在你前頭去攻打非利士人的軍隊。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S25_25","011_5_25","2SA","5","25","25","大衛就遵着耶和華所吩咐的去行，攻打非利士人，從迦巴直到基色。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S26_1","011_6_1","2SA","6","1","1","大衛又聚集以色列中所有挑選的人三萬。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S26_2","011_6_2","2SA","6","2","2","大衛起身，率領跟隨他的眾人前往，要從巴拉‧猶大將上帝的約櫃運來；這約櫃就是坐在二基路伯上萬軍之耶和華留名的約櫃。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S26_3","011_6_3","2SA","6","3","3","他們將上帝的約櫃從岡上亞比拿達的家裏抬出來，放在新車上；亞比拿達的兩個兒子烏撒和亞希約趕這新車。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S26_4","011_6_4","2SA","6","4","4","他們將上帝的約櫃從岡上亞比拿達家裏抬出來的時候，亞希約在櫃前行走。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S26_5","011_6_5","2SA","6","5","5","大衛和以色列的全家在耶和華面前，用松木製造的各樣樂器和琴、瑟、鼓、鈸、鑼，作樂跳舞。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S26_6","011_6_6","2SA","6","6","6","到了拿艮的禾場，因為牛失前蹄，烏撒就伸手扶住上帝的約櫃。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S26_7","011_6_7","2SA","6","7","7","上帝耶和華向烏撒發怒，因這錯誤擊殺他，他就死在上帝的約櫃旁。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S26_8","011_6_8","2SA","6","8","8","大衛因耶和華擊殺 烏撒，心裏愁煩，就稱那地方為毗列斯‧烏撒，直到今日。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S26_9","011_6_9","2SA","6","9","9","那日，大衛懼怕耶和華，說：「耶和華的約櫃怎可運到我這裏來？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S26_10","011_6_10","2SA","6","10","10","於是大衛不肯將耶和華的約櫃運進大衛的城，卻運到迦特人俄別‧以東的家中。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S26_11","011_6_11","2SA","6","11","11","耶和華的約櫃在迦特人俄別‧以東家中三個月；耶和華賜福給俄別‧以東和他的全家。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S26_12","011_6_12","2SA","6","12","12","有人告訴大衛王說：「耶和華因為約櫃賜福給俄別‧以東的家和一切屬他的。」大衛就去，歡歡喜喜地將上帝的約櫃從俄別‧以東家中抬到大衛的城裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S26_13","011_6_13","2SA","6","13","13","抬耶和華約櫃的人走了六步，大衛就獻牛與肥羊為祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S26_14","011_6_14","2SA","6","14","14","大衛穿着細麻布的以弗得，在耶和華面前極力跳舞。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S26_15","011_6_15","2SA","6","15","15","這樣，大衛和以色列的全家歡呼吹角，將耶和華的約櫃抬上來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S26_16","011_6_16","2SA","6","16","16","耶和華的約櫃進了大衛城的時候，掃羅的女兒米甲從窗戶裏觀看，見大衛王在耶和華面前踴躍跳舞，心裏就輕視他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S26_17","011_6_17","2SA","6","17","17","眾人將耶和華的約櫃請進去，安放在所預備的地方，就是在大衛所搭的帳幕裏。大衛在耶和華面前獻燔祭和平安祭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S26_18","011_6_18","2SA","6","18","18","大衛獻完了燔祭和平安祭，就奉萬軍之耶和華的名給民祝福， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S26_19","011_6_19","2SA","6","19","19","並且分給以色列眾人，無論男女，每人一個餅，一塊肉，一個葡萄餅；眾人就各回各家去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S26_20","011_6_20","2SA","6","20","20","大衛回家要給眷屬祝福；掃羅的女兒米甲出來迎接他，說：「以色列王今日在臣僕的婢女眼前露體，如同一個輕賤人無恥露體一樣，有好大的榮耀啊！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S26_21","011_6_21","2SA","6","21","21","大衛對米甲說：「這是在耶和華面前；耶和華已揀選我，廢了你父和你父的全家，立我作耶和華民以色列的君，所以我必在耶和華面前跳舞。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S26_22","011_6_22","2SA","6","22","22","我也必更加卑微，自己看為輕賤。你所說的那些婢女，她們倒要尊敬我。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S26_23","011_6_23","2SA","6","23","23","掃羅的女兒米甲，直到死日，沒有生養兒女。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S27_1","011_7_1","2SA","7","1","1","王住在自己宮中，耶和華使他安靖，不被四圍的仇敵擾亂。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S27_2","011_7_2","2SA","7","2","2","那時，王對先知拿單說：「看哪，我住在香柏木的宮中，上帝的約櫃反在幔子裏。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S27_3","011_7_3","2SA","7","3","3","拿單對王說：「你可以照你的心意而行，因為耶和華與你同在。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S27_4","011_7_4","2SA","7","4","4","當夜，耶和華的話臨到拿單說： ");
INSERT INTO cmn_cu89t_vpl VALUES ("S27_5","011_7_5","2SA","7","5","5","「你去告訴我僕人大衛，說耶和華如此說：『你豈可建造殿宇給我居住呢？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("S27_6","011_7_6","2SA","7","6","6","自從我領以色列人出埃及直到今日，我未曾住過殿宇，常在會幕和帳幕中行走。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S27_7","011_7_7","2SA","7","7","7","凡我同以色列人所走的地方，我何曾向以色列一支派的士師，就是我吩咐牧養我民以色列的說：你們為何不給我建造香柏木的殿宇呢？』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S27_8","011_7_8","2SA","7","8","8","「現在，你要告訴我僕人大衛，說萬軍之耶和華如此說：『我從羊圈中將你召來，叫你不再跟從羊群，立你作我民以色列的君。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S27_9","011_7_9","2SA","7","9","9","你無論往哪裏去，我常與你同在，剪除你的一切仇敵。我必使你得大名，好像世上大大有名的人一樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S27_10","011_7_10","2SA","7","10","10","我必為我民以色列選定一個地方，栽培他們，使他們住自己的地方，不再遷移；凶惡之子也不像從前擾害他們， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S27_11","011_7_11","2SA","7","11","11","並不像我命士師治理我民以色列的時候一樣。我必使你安靖，不被一切仇敵擾亂，並且我－耶和華應許你，必為你建立家室。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S27_12","011_7_12","2SA","7","12","12","你壽數滿足、與你列祖同睡的時候，我必使你的後裔接續你的位；我也必堅定他的國。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S27_13","011_7_13","2SA","7","13","13","他必為我的名建造殿宇；我必堅定他的國位，直到永遠。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S27_14","011_7_14","2SA","7","14","14","我要作他的父，他要作我的子；他若犯了罪，我必用人的杖責打他，用人的鞭責罰他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S27_15","011_7_15","2SA","7","15","15","但我的慈愛仍不離開他，像離開在你面前所廢棄的掃羅一樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S27_16","011_7_16","2SA","7","16","16","你的家和你的國必在我面前永遠堅立。你的國位也必堅定，直到永遠。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S27_17","011_7_17","2SA","7","17","17","拿單就按這一切話，照這默示，告訴大衛。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S27_18","011_7_18","2SA","7","18","18","於是大衛王進去，坐在耶和華面前，說：「主耶和華啊，我是誰？我的家算甚麼？你竟使我到這地步呢？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("S27_19","011_7_19","2SA","7","19","19","主耶和華啊，這在你眼中還看為小，又應許你僕人的家至於久遠。主耶和華啊，這豈是人所常遇的事嗎？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("S27_20","011_7_20","2SA","7","20","20","主耶和華啊，我還有何言可以對你說呢？因為你知道你的僕人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S27_21","011_7_21","2SA","7","21","21","你行這大事使僕人知道，是因你所應許的話，也是照你的心意。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S27_22","011_7_22","2SA","7","22","22","主耶和華啊，你本為大，照我們耳中聽見，沒有可比你的；除你以外再無上帝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S27_23","011_7_23","2SA","7","23","23","世上有何民能比你的民以色列呢？你從埃及救贖他們作自己的子民，又在你贖出來的民面前行大而可畏的事，驅逐列邦人和他們的神，顯出你的大名。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S27_24","011_7_24","2SA","7","24","24","你曾堅立你的民以色列作你的子民，直到永遠；你－耶和華也作了他們的上帝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S27_25","011_7_25","2SA","7","25","25","「耶和華上帝啊，你所應許僕人和僕人家的話，求你堅定，直到永遠；照你所說的而行。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S27_26","011_7_26","2SA","7","26","26","願人永遠尊你的名為大，說：『萬軍之耶和華是治理以色列的上帝。』這樣，你僕人大衛的家必在你面前堅立。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S27_27","011_7_27","2SA","7","27","27","萬軍之耶和華－以色列的上帝啊，因你啟示你的僕人說：『我必為你建立家室』，所以僕人大膽向你如此祈禱。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S27_28","011_7_28","2SA","7","28","28","「主耶和華啊，惟有你是上帝。你的話是真實的；你也應許將這福氣賜給僕人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S27_29","011_7_29","2SA","7","29","29","現在求你賜福與僕人的家，可以永存在你面前。主耶和華啊，這是你所應許的。願你永遠賜福與僕人的家！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S28_1","011_8_1","2SA","8","1","1","此後，大衛攻打非利士人，把他們治服，從他們手下奪取了京城的權柄； ");
INSERT INTO cmn_cu89t_vpl VALUES ("S28_2","011_8_2","2SA","8","2","2","又攻打摩押人，使他們躺臥在地上，用繩量一量：量二繩的殺了，量一繩的存留。摩押人就歸服大衛，給他進貢。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S28_3","011_8_3","2SA","8","3","3","瑣巴王利合的兒子哈大底謝往大河去，要奪回他的國權。大衛就攻打他， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S28_4","011_8_4","2SA","8","4","4","擒拿了他的馬兵一千七百，步兵二萬，將拉戰車的馬砍斷蹄筋，但留下一百輛車的馬。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S28_5","011_8_5","2SA","8","5","5","大馬士革的亞蘭人來幫助瑣巴王哈大底謝，大衛就殺了亞蘭人二萬二千。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S28_6","011_8_6","2SA","8","6","6","於是大衛在大馬士革的亞蘭地設立防營，亞蘭人就歸服他，給他進貢。大衛無論往哪裏去，耶和華都使他得勝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S28_7","011_8_7","2SA","8","7","7","他奪了哈大底謝臣僕所拿的金盾牌，帶到耶路撒冷。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S28_8","011_8_8","2SA","8","8","8","大衛王又從屬哈大底謝的比他和比羅他城中奪取了許多的銅。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S28_9","011_8_9","2SA","8","9","9","哈馬王陀以聽見大衛殺敗哈大底謝的全軍， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S28_10","011_8_10","2SA","8","10","10","就打發他兒子約蘭去見大衛王，問他的安，為他祝福，因為他殺敗了哈大底謝（原來陀以與哈大底謝常常爭戰）。約蘭帶了金銀銅的器皿來， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S28_11","011_8_11","2SA","8","11","11","大衛王將這些器皿和他治服各國所得來的金銀都分別為聖，獻給耶和華， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S28_12","011_8_12","2SA","8","12","12","就是從亞蘭、摩押、亞捫、非利士、亞瑪力人所得來的，以及從瑣巴王利合的兒子哈大底謝所掠之物。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S28_13","011_8_13","2SA","8","13","13","大衛在鹽谷擊殺了亞蘭一萬八千人回來，就得了大名； ");
INSERT INTO cmn_cu89t_vpl VALUES ("S28_14","011_8_14","2SA","8","14","14","又在以東全地設立防營，以東人就都歸服大衛。大衛無論往哪裏去，耶和華都使他得勝。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S28_15","011_8_15","2SA","8","15","15","大衛作以色列眾人的王，又向眾民秉公行義。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S28_16","011_8_16","2SA","8","16","16","洗魯雅的兒子約押作元帥；亞希律的兒子約沙法作史官； ");
INSERT INTO cmn_cu89t_vpl VALUES ("S28_17","011_8_17","2SA","8","17","17","亞希突的兒子撒督和亞比亞他的兒子亞希米勒作祭司長；西萊雅作書記； ");
INSERT INTO cmn_cu89t_vpl VALUES ("S28_18","011_8_18","2SA","8","18","18","耶何耶大的兒子比拿雅統轄基利提人和比利提人。大衛的眾子都作領袖。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S29_1","011_9_1","2SA","9","1","1","大衛問說：「掃羅家還有剩下的人沒有？我要因約拿單的緣故向他施恩。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S29_2","011_9_2","2SA","9","2","2","掃羅家有一個僕人，名叫洗巴，有人叫他來見大衛，王問他說：「你是洗巴嗎？」回答說：「僕人是。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S29_3","011_9_3","2SA","9","3","3","王說：「掃羅家還有人沒有？我要照上帝的慈愛恩待他。」洗巴對王說：「還有約拿單的一個兒子，是瘸腿的。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S29_4","011_9_4","2SA","9","4","4","王說：「他在哪裏？」洗巴對王說：「他在羅‧底巴，亞米利的兒子瑪吉家裏。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S29_5","011_9_5","2SA","9","5","5","於是大衛王打發人去，從羅‧底巴亞米利的兒子瑪吉家裏召了他來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S29_6","011_9_6","2SA","9","6","6","掃羅的孫子、約拿單的兒子米非波設來見大衛，伏地叩拜。大衛說：「米非波設！」米非波設說：「僕人在此。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S29_7","011_9_7","2SA","9","7","7","大衛說：「你不要懼怕，我必因你父親約拿單的緣故施恩與你，將你祖父掃羅的一切田地都歸還你；你也可以常與我同席吃飯。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S29_8","011_9_8","2SA","9","8","8","米非波設又叩拜，說：「僕人算甚麼，不過如死狗一般，竟蒙王這樣眷顧！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S29_9","011_9_9","2SA","9","9","9","王召了掃羅的僕人洗巴來，對他說：「我已將屬掃羅和他的一切家產都賜給你主人的兒子了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S29_10","011_9_10","2SA","9","10","10","你和你的眾子、僕人要為你主人的兒子米非波設耕種田地，把所產的拿來供他食用；他卻要常與我同席吃飯。」洗巴有十五個兒子，二十個僕人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S29_11","011_9_11","2SA","9","11","11","洗巴對王說：「凡我主我王吩咐僕人的，僕人都必遵行。」王又說：「米非波設必與我同席吃飯，如王的兒子一樣。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S29_12","011_9_12","2SA","9","12","12","米非波設有一個小兒子，名叫米迦。凡住在洗巴家裏的人都作了米非波設的僕人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S29_13","011_9_13","2SA","9","13","13","於是米非波設住在耶路撒冷，常與王同席吃飯。他兩腿都是瘸的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S210_1","011_10_1","2SA","10","1","1","此後，亞捫人的王死了，他兒子哈嫩接續他作王。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S210_2","011_10_2","2SA","10","2","2","大衛說：「我要照哈嫩的父親拿轄厚待我的恩典厚待哈嫩。」於是大衛差遣臣僕，為他喪父安慰他。大衛的臣僕到了亞捫人的境內。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S210_3","011_10_3","2SA","10","3","3","但亞捫人的首領對他們的主哈嫩說：「大衛差人來安慰你，你想他是尊敬你父親嗎？他差臣僕來不是詳察窺探、要傾覆這城嗎？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S210_4","011_10_4","2SA","10","4","4","哈嫩便將大衛臣僕的鬍鬚剃去一半，又割斷他們下半截的衣服，使他們露出下體，打發他們回去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S210_5","011_10_5","2SA","10","5","5","有人告訴大衛，他就差人去迎接他們，（因為他們甚覺羞恥），告訴他們說：「可以住在耶利哥，等到鬍鬚長起再回來。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S210_6","011_10_6","2SA","10","6","6","亞捫人知道大衛憎惡他們，就打發人去，招募伯‧利合的亞蘭人和瑣巴的亞蘭人，步兵二萬，與瑪迦王的人一千、陀伯人一萬二千。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S210_7","011_10_7","2SA","10","7","7","大衛聽見了，就差派約押統帶勇猛的全軍出去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S210_8","011_10_8","2SA","10","8","8","亞捫人出來，在城門前擺陣；瑣巴與利合的亞蘭人、陀伯人，並瑪迦人，另在郊野擺陣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S210_9","011_10_9","2SA","10","9","9","約押看見敵人在他前後擺陣，就從以色列軍中挑選精兵，使他們對着亞蘭人擺陣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S210_10","011_10_10","2SA","10","10","10","其餘的兵交與他兄弟亞比篩，對着亞捫人擺陣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S210_11","011_10_11","2SA","10","11","11","約押對亞比篩說：「亞蘭人若強過我，你就來幫助我；亞捫人若強過你，我就去幫助你。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S210_12","011_10_12","2SA","10","12","12","我們都當剛強，為本國的民和上帝的城邑作大丈夫。願耶和華憑他的意旨而行！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S210_13","011_10_13","2SA","10","13","13","於是，約押和跟隨他的人前進攻打亞蘭人；亞蘭人在約押面前逃跑。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S210_14","011_10_14","2SA","10","14","14","亞捫人見亞蘭人逃跑，他們也在亞比篩面前逃跑進城。約押就離開亞捫人那裏，回耶路撒冷去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S210_15","011_10_15","2SA","10","15","15","亞蘭人見自己被以色列人打敗，就又聚集。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S210_16","011_10_16","2SA","10","16","16","哈大底謝差遣人，將大河那邊的亞蘭人調來；他們到了希蘭，哈大底謝的將軍朔法率領他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S210_17","011_10_17","2SA","10","17","17","有人告訴大衛，他就聚集以色列眾人，過約旦河，來到希蘭。亞蘭人迎着大衛擺陣，與他打仗。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S210_18","011_10_18","2SA","10","18","18","亞蘭人在以色列人面前逃跑；大衛殺了亞蘭七百輛戰車的人，四萬馬兵，又殺了亞蘭的將軍朔法。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S210_19","011_10_19","2SA","10","19","19","屬哈大底謝的諸王見自己被以色列人打敗，就與以色列人和好，歸服他們。於是亞蘭人不敢再幫助亞捫人了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S211_1","011_11_1","2SA","11","1","1","過了一年，到列王出戰的時候，大衛又差派約押，率領臣僕和以色列眾人出戰。他們就打敗亞捫人，圍攻拉巴。大衛仍住在耶路撒冷。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S211_2","011_11_2","2SA","11","2","2","一日，太陽平西，大衛從床上起來，在王宮的平頂上遊行，看見一個婦人沐浴，容貌甚美， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S211_3","011_11_3","2SA","11","3","3","大衛就差人打聽那婦人是誰。有人說：「她是以連的女兒，赫人烏利亞的妻拔示巴。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S211_4","011_11_4","2SA","11","4","4","大衛差人去，將婦人接來；那時她的月經才得潔淨。她來了，大衛與她同房，她就回家去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S211_5","011_11_5","2SA","11","5","5","於是她懷了孕，打發人去告訴大衛說：「我懷了孕。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S211_6","011_11_6","2SA","11","6","6","大衛差人到約押那裏，說：「你打發赫人烏利亞到我這裏來。」約押就打發烏利亞去見大衛。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S211_7","011_11_7","2SA","11","7","7","烏利亞來了，大衛問約押好，也問兵好，又問爭戰的事怎樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S211_8","011_11_8","2SA","11","8","8","大衛對烏利亞說：「你回家去，洗洗腳吧！」烏利亞出了王宮，隨後王送他一分食物。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S211_9","011_11_9","2SA","11","9","9","烏利亞卻和他主人的僕人一同睡在宮門外，沒有回家去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S211_10","011_11_10","2SA","11","10","10","有人告訴大衛說：「烏利亞沒有回家去。」大衛就問烏利亞說：「你從遠路上來，為甚麼不回家去呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S211_11","011_11_11","2SA","11","11","11","烏利亞對大衛說：「約櫃和以色列與猶大兵都住在棚裏，我主約押和我主的僕人都在田野安營，我豈可回家吃喝、與妻子同寢呢？我敢在王面前起誓：我決不行這事！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S211_12","011_11_12","2SA","11","12","12","大衛吩咐烏利亞說：「你今日仍住在這裏，明日我打發你去。」於是烏利亞那日和次日住在耶路撒冷。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S211_13","011_11_13","2SA","11","13","13","大衛召了烏利亞來，叫他在自己面前吃喝，使他喝醉。到了晚上，烏利亞出去與他主的僕人一同住宿，還沒有回到家裏去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S211_14","011_11_14","2SA","11","14","14","次日早晨，大衛寫信與約押，交烏利亞隨手帶去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S211_15","011_11_15","2SA","11","15","15","信內寫着說：「要派烏利亞前進，到陣勢極險之處，你們便退後，使他被殺。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S211_16","011_11_16","2SA","11","16","16","約押圍城的時候，知道敵人那裏有勇士，便將烏利亞派在那裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S211_17","011_11_17","2SA","11","17","17","城裏的人出來和約押打仗；大衛的僕人中有幾個被殺的，赫人烏利亞也死了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S211_18","011_11_18","2SA","11","18","18","於是，約押差人去將爭戰的一切事告訴大衛， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S211_19","011_11_19","2SA","11","19","19","又囑咐使者說：「你把爭戰的一切事對王說完了， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S211_20","011_11_20","2SA","11","20","20","王若發怒，問你說：『你們打仗為甚麼挨近城牆呢？豈不知敵人必從城上射箭嗎？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("S211_21","011_11_21","2SA","11","21","21","從前打死耶路‧比設兒子亞比米勒的是誰呢？豈不是一個婦人從城上拋下一塊上磨石來，打在他身上，他就死在提備斯嗎？你們為甚麼挨近城牆呢？』你就說：『王的僕人－赫人烏利亞也死了。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S211_22","011_11_22","2SA","11","22","22","使者起身，來見大衛，照着約押所吩咐他的話奏告大衛。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S211_23","011_11_23","2SA","11","23","23","使者對大衛說：「敵人強過我們，出到郊野與我們打仗，我們追殺他們，直到城門口。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S211_24","011_11_24","2SA","11","24","24","射箭的從城上射王的僕人，射死幾個，赫人烏利亞也死了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S211_25","011_11_25","2SA","11","25","25","王向使者說：「你告訴約押說：『不要因這事愁悶，刀劍或吞滅這人或吞滅那人，沒有一定的；你只管竭力攻城，將城傾覆。』可以用這話勉勵約押。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S211_26","011_11_26","2SA","11","26","26","烏利亞的妻聽見丈夫烏利亞死了，就為他哀哭。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S211_27","011_11_27","2SA","11","27","27","哀哭的日子過了，大衛差人將她接到宮裏，她就作了大衛的妻，給大衛生了一個兒子。但大衛所行的這事，耶和華甚不喜悅。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S212_1","011_12_1","2SA","12","1","1","耶和華差遣拿單去見大衛。拿單到了大衛那裏，對他說：「在一座城裏有兩個人：一個是富戶，一個是窮人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S212_2","011_12_2","2SA","12","2","2","富戶有許多牛群羊群； ");
INSERT INTO cmn_cu89t_vpl VALUES ("S212_3","011_12_3","2SA","12","3","3","窮人除了所買來養活的一隻小母羊羔之外，別無所有。羊羔在他家裏和他兒女一同長大，吃他所吃的，喝他所喝的，睡在他懷中，在他看來如同女兒一樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S212_4","011_12_4","2SA","12","4","4","有一客人來到這富戶家裏；富戶捨不得從自己的牛群羊群中取一隻預備給客人吃，卻取了那窮人的羊羔，預備給客人吃。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S212_5","011_12_5","2SA","12","5","5","大衛就甚惱怒那人，對拿單說：「我指着永生的耶和華起誓，行這事的人該死！ ");
INSERT INTO cmn_cu89t_vpl VALUES ("S212_6","011_12_6","2SA","12","6","6","他必償還羊羔四倍；因為他行這事，沒有憐恤的心。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S212_7","011_12_7","2SA","12","7","7","拿單對大衛說：「你就是那人！耶和華－以色列的上帝如此說：『我膏你作以色列的王，救你脫離掃羅的手。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S212_8","011_12_8","2SA","12","8","8","我將你主人的家業賜給你，將你主人的妻交在你懷裏，又將以色列和猶大家賜給你；你若還以為不足，我早就加倍地賜給你。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S212_9","011_12_9","2SA","12","9","9","你為甚麼藐視耶和華的命令，行他眼中看為惡的事呢？你借亞捫人的刀殺害赫人烏利亞，又娶了他的妻為妻。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S212_10","011_12_10","2SA","12","10","10","你既藐視我，娶了赫人烏利亞的妻為妻，所以刀劍必永不離開你的家。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S212_11","011_12_11","2SA","12","11","11","耶和華如此說：『我必從你家中興起禍患攻擊你；我必在你眼前把你的妃嬪賜給別人，他在日光之下就與她們同寢。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S212_12","011_12_12","2SA","12","12","12","你在暗中行這事，我卻要在以色列眾人面前，日光之下，報應你。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S212_13","011_12_13","2SA","12","13","13","大衛對拿單說：「我得罪耶和華了！」拿單說：「耶和華已經除掉你的罪，你必不至於死。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S212_14","011_12_14","2SA","12","14","14","只是你行這事，叫耶和華的仇敵大得褻瀆的機會，故此，你所得的孩子必定要死。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S212_15","011_12_15","2SA","12","15","15","拿單就回家去了。 耶和華擊打烏利亞妻給大衛所生的孩子，使他得重病。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S212_16","011_12_16","2SA","12","16","16","所以大衛為這孩子懇求上帝，而且禁食，進入內室，終夜躺在地上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S212_17","011_12_17","2SA","12","17","17","他家中的老臣來到他旁邊，要把他從地上扶起來，他卻不肯起來，也不同他們吃飯。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S212_18","011_12_18","2SA","12","18","18","到第七日，孩子死了。大衛的臣僕不敢告訴他孩子死了，因他們說：「孩子還活着的時候，我們勸他，他尚且不肯聽我們的話，若告訴他孩子死了，豈不更加憂傷嗎？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S212_19","011_12_19","2SA","12","19","19","大衛見臣僕彼此低聲說話，就知道孩子死了，問臣僕說：「孩子死了嗎？」他們說：「死了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S212_20","011_12_20","2SA","12","20","20","大衛就從地上起來，沐浴，抹膏，換了衣裳，進耶和華的殿敬拜；然後回宮，吩咐人擺飯，他便吃了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S212_21","011_12_21","2SA","12","21","21","臣僕問他說：「你所行的是甚麼意思？孩子活着的時候，你禁食哭泣；孩子死了，你倒起來吃飯。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S212_22","011_12_22","2SA","12","22","22","大衛說：「孩子還活着，我禁食哭泣；因為我想，或者耶和華憐恤我，使孩子不死也未可知。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S212_23","011_12_23","2SA","12","23","23","孩子死了，我何必禁食，我豈能使他返回呢？我必往他那裏去，他卻不能回我這裏來。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S212_24","011_12_24","2SA","12","24","24","大衛安慰他的妻拔示巴，與她同寢，她就生了兒子，給他起名叫所羅門。耶和華也喜愛他， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S212_25","011_12_25","2SA","12","25","25","就藉先知拿單賜他一個名字，叫耶底底亞，因為耶和華愛他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S212_26","011_12_26","2SA","12","26","26","約押攻取亞捫人的京城拉巴。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S212_27","011_12_27","2SA","12","27","27","約押打發使者去見大衛，說：「我攻打拉巴，取其水城。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S212_28","011_12_28","2SA","12","28","28","現在你要聚集其餘的軍兵來，安營圍攻這城，恐怕我取了這城，人就以我的名叫這城。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S212_29","011_12_29","2SA","12","29","29","於是大衛聚集眾軍，往拉巴去攻城，就取了這城， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S212_30","011_12_30","2SA","12","30","30","奪了亞捫人之王所戴的金冠冕，其上的金子重一他連得，又嵌着寶石。人將這冠冕戴在大衛頭上。大衛從城裏奪了許多財物， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S212_31","011_12_31","2SA","12","31","31","將城裏的人拉出來，放在鋸下，或鐵耙下，或鐵斧下，或叫他經過磚窯；大衛待亞捫各城的居民都是如此。其後，大衛和眾軍都回耶路撒冷去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S213_1","011_13_1","2SA","13","1","1","大衛的兒子押沙龍有一個美貌的妹子，名叫她瑪。大衛的兒子暗嫩愛她。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S213_2","011_13_2","2SA","13","2","2","暗嫩為他妹子她瑪憂急成病。她瑪還是處女，暗嫩以為難向她行事。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S213_3","011_13_3","2SA","13","3","3","暗嫩有一個朋友，名叫約拿達，是大衛長兄示米亞的兒子。這約拿達為人極其狡猾； ");
INSERT INTO cmn_cu89t_vpl VALUES ("S213_4","011_13_4","2SA","13","4","4","他問暗嫩說：「王的兒子啊，為何一天比一天瘦弱呢？請你告訴我。」暗嫩回答說：「我愛我兄弟押沙龍的妹子她瑪。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S213_5","011_13_5","2SA","13","5","5","約拿達說：「你不如躺在床上裝病；你父親來看你，就對他說：『求父叫我妹子她瑪來，在我眼前預備食物，遞給我吃，使我看見，好從她手裏接過來吃。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S213_6","011_13_6","2SA","13","6","6","於是暗嫩躺臥裝病。王來看他，他對王說：「求父叫我妹子她瑪來，在我眼前為我做兩個餅，我好從她手裏接過來吃。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S213_7","011_13_7","2SA","13","7","7","大衛就打發人到宮裏，對她瑪說：「你往你哥哥暗嫩的屋裏去，為他預備食物。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S213_8","011_13_8","2SA","13","8","8","她瑪就到她哥哥暗嫩的屋裏；暗嫩正躺臥。她瑪摶麵，在他眼前做餅，且烤熟了， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S213_9","011_13_9","2SA","13","9","9","在他面前將餅從鍋裏倒出來，他卻不肯吃，便說：「眾人離開我出去吧！」眾人就都離開他，出去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S213_10","011_13_10","2SA","13","10","10","暗嫩對她瑪說：「你把食物拿進臥房，我好從你手裏接過來吃。」她瑪就把所做的餅拿進臥房，到她哥哥暗嫩那裏， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S213_11","011_13_11","2SA","13","11","11","拿着餅上前給他吃，他便拉住她瑪，說：「我妹妹，你來與我同寢。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S213_12","011_13_12","2SA","13","12","12","她瑪說：「我哥哥，不要玷辱我。以色列人中不當這樣行，你不要做這醜事； ");
INSERT INTO cmn_cu89t_vpl VALUES ("S213_13","011_13_13","2SA","13","13","13","你玷辱了我，我何以掩蓋我的羞恥呢？你在以色列中也成了愚妄人。你可以求王，他必不禁止我歸你。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S213_14","011_13_14","2SA","13","14","14","但暗嫩不肯聽她的話，因比她力大，就玷辱她，與她同寢。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S213_15","011_13_15","2SA","13","15","15","隨後，暗嫩極其恨她，那恨她的心比先前愛她的心更甚，對她說：「你起來，去吧！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S213_16","011_13_16","2SA","13","16","16","她瑪說：「不要這樣！你趕出我去的這罪比你才行的更重！」但暗嫩不肯聽她的話， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S213_17","011_13_17","2SA","13","17","17","就叫伺候自己的僕人來，說：「將這個女子趕出去！她一出去，你就關門，上閂。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S213_18","011_13_18","2SA","13","18","18","那時她瑪穿着彩衣，因為沒有出嫁的公主都是這樣穿。暗嫩的僕人就把她趕出去，關門上閂。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S213_19","011_13_19","2SA","13","19","19","她瑪把灰塵撒在頭上，撕裂所穿的彩衣，以手抱頭，一面行走，一面哭喊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S213_20","011_13_20","2SA","13","20","20","她胞兄押沙龍問她說：「莫非你哥哥暗嫩與你親近了嗎？我妹妹，暫且不要作聲，他是你的哥哥，不要將這事放在心上。」她瑪就孤孤單單地住在她胞兄押沙龍家裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S213_21","011_13_21","2SA","13","21","21","大衛王聽見這事，就甚發怒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S213_22","011_13_22","2SA","13","22","22","押沙龍並不和他哥哥暗嫩說好說歹；因為暗嫩玷辱他妹妹她瑪，所以押沙龍恨惡他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S213_23","011_13_23","2SA","13","23","23","過了二年，在靠近以法蓮的巴力‧夏瑣有人為押沙龍剪羊毛；押沙龍請王的眾子與他同去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S213_24","011_13_24","2SA","13","24","24","押沙龍來見王，說：「現在有人為僕人剪羊毛，請王和王的臣僕與僕人同去。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S213_25","011_13_25","2SA","13","25","25","王對押沙龍說：「我兒，我們不必都去，恐怕使你耗費太多。」押沙龍再三請王，王仍是不肯去，只為他祝福。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S213_26","011_13_26","2SA","13","26","26","押沙龍說：「王若不去，求王許我哥哥暗嫩同去。」王說：「何必要他去呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S213_27","011_13_27","2SA","13","27","27","押沙龍再三求王，王就許暗嫩和王的眾子與他同去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S213_28","011_13_28","2SA","13","28","28","押沙龍吩咐僕人說：「你們注意，看暗嫩飲酒暢快的時候，我對你們說殺暗嫩，你們便殺他，不要懼怕。這不是我吩咐你們的嗎？你們只管壯膽奮勇！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S213_29","011_13_29","2SA","13","29","29","押沙龍的僕人就照押沙龍所吩咐的，向暗嫩行了。王的眾子都起來，各人騎上騾子，逃跑了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S213_30","011_13_30","2SA","13","30","30","他們還在路上，有風聲傳到大衛那裏，說：「押沙龍將王的眾子都殺了，沒有留下一個。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S213_31","011_13_31","2SA","13","31","31","王就起來，撕裂衣服，躺在地上。王的臣僕也都撕裂衣服，站在旁邊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S213_32","011_13_32","2SA","13","32","32","大衛的長兄，示米亞的兒子約拿達說：「我主，不要以為王的眾子－少年人都殺了，只有暗嫩一個人死了。自從暗嫩玷辱押沙龍妹子她瑪的那日，押沙龍就定意殺暗嫩了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S213_33","011_13_33","2SA","13","33","33","現在，我主我王，不要把這事放在心上，以為王的眾子都死了，只有暗嫩一個人死了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S213_34","011_13_34","2SA","13","34","34","押沙龍逃跑了。 守望的少年人舉目觀看，見有許多人從山坡的路上來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S213_35","011_13_35","2SA","13","35","35","約拿達對王說：「看哪，王的眾子都來了，果然與你僕人所說的相合。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S213_36","011_13_36","2SA","13","36","36","話才說完，王的眾子都到了，放聲大哭；王和臣僕也都哭得甚慟。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S213_37","011_13_37","2SA","13","37","37","押沙龍逃到基述王亞米忽的兒子達買那裏去了。大衛天天為他兒子悲哀。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S213_38","011_13_38","2SA","13","38","38","押沙龍逃到基述，在那裏住了三年。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S213_39","011_13_39","2SA","13","39","39","暗嫩死了以後，大衛王得了安慰，心裏切切想念押沙龍。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S214_1","011_14_1","2SA","14","1","1","洗魯雅的兒子約押，知道王心裏想念押沙龍， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S214_2","011_14_2","2SA","14","2","2","就打發人往提哥亞去，從那裏叫了一個聰明的婦人來，對她說：「請你假裝居喪的，穿上孝衣，不要用膏抹身，要裝作為死者許久悲哀的婦人； ");
INSERT INTO cmn_cu89t_vpl VALUES ("S214_3","011_14_3","2SA","14","3","3","進去見王，對王如此如此說。」於是約押將當說的話教導了婦人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S214_4","011_14_4","2SA","14","4","4","提哥亞婦人到王面前，伏地叩拜，說：「王啊，求你拯救！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S214_5","011_14_5","2SA","14","5","5","王問她說：「你有甚麼事呢？」回答說：「婢女實在是寡婦，我丈夫死了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S214_6","011_14_6","2SA","14","6","6","我有兩個兒子，一日在田間爭鬥，沒有人解勸，這個就打死那個。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S214_7","011_14_7","2SA","14","7","7","現在全家的人都起來攻擊婢女，說：『你將那打死兄弟的交出來，我們好治死他，償他打死兄弟的命，滅絕那承受家業的。』這樣，他們要將我剩下的炭火滅盡，不與我丈夫留名留後在世上。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S214_8","011_14_8","2SA","14","8","8","王對婦人說：「你回家去吧！我必為你下令。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S214_9","011_14_9","2SA","14","9","9","提哥亞婦人又對王說：「我主我王，願這罪歸我和我父家，與王和王的位無干。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S214_10","011_14_10","2SA","14","10","10","王說：「凡難為你的，你就帶他到我這裏來，他必不再攪擾你。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S214_11","011_14_11","2SA","14","11","11","婦人說：「願王記念耶和華－你的上帝，不許報血仇的人施行滅絕，恐怕他們滅絕我的兒子。」王說：「我指着永生的耶和華起誓：你的兒子連一根頭髮也不致落在地上。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S214_12","011_14_12","2SA","14","12","12","婦人說：「求我主我王容婢女再說一句話。」王說：「你說吧！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S214_13","011_14_13","2SA","14","13","13","婦人說：「王為何也起意要害上帝的民呢？王不使那逃亡的人回來，王的這話就是自證己錯了！ ");
INSERT INTO cmn_cu89t_vpl VALUES ("S214_14","011_14_14","2SA","14","14","14","我們都是必死的，如同水潑在地上，不能收回。上帝並不奪取人的性命，乃設法使逃亡的人不致成為趕出、回不來的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S214_15","011_14_15","2SA","14","15","15","我來將這話告訴我主我王，是因百姓使我懼怕。婢女想，不如將這話告訴王，或者王成就婢女所求的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S214_16","011_14_16","2SA","14","16","16","人要將我和我兒子從上帝的地業上一同除滅，王必應允救我脫離他的手。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S214_17","011_14_17","2SA","14","17","17","婢女又想，我主我王的話必安慰我；因為我主我王能辨別是非，如同上帝的使者一樣。惟願耶和華－你的上帝與你同在！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S214_18","011_14_18","2SA","14","18","18","王對婦人說：「我要問你一句話，你一點不要瞞我。」婦人說：「願我主我王說。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S214_19","011_14_19","2SA","14","19","19","王說：「你這些話莫非是約押的主意嗎？」婦人說：「我敢在我主我王面前起誓：王的話正對，不偏左右，是王的僕人約押吩咐我的，這些話是他教導我的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S214_20","011_14_20","2SA","14","20","20","王的僕人約押如此行，為要挽回這事。我主的智慧卻如上帝使者的智慧，能知世上一切事。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S214_21","011_14_21","2SA","14","21","21","王對約押說：「我應允你這事。你可以去，把那少年人押沙龍帶回來。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S214_22","011_14_22","2SA","14","22","22","約押就面伏於地叩拜，祝謝於王，又說：「王既應允僕人所求的，僕人今日知道在我主我王眼前蒙恩了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S214_23","011_14_23","2SA","14","23","23","於是約押起身往基述去，將押沙龍帶回耶路撒冷。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S214_24","011_14_24","2SA","14","24","24","王說：「使他回自己家裏去，不要見我的面。」押沙龍就回自己家裏去，沒有見王的面。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S214_25","011_14_25","2SA","14","25","25","以色列全地之中，無人像押沙龍那樣俊美，得人的稱讚，從腳底到頭頂毫無瑕疵。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S214_26","011_14_26","2SA","14","26","26","他的頭髮甚重，每到年底剪髮一次；所剪下來的，按王的平稱一稱，重二百舍客勒。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S214_27","011_14_27","2SA","14","27","27","押沙龍生了三個兒子，一個女兒。女兒名叫她瑪，是個容貌俊美的女子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S214_28","011_14_28","2SA","14","28","28","押沙龍住在耶路撒冷足有二年，沒有見王的面。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S214_29","011_14_29","2SA","14","29","29","押沙龍打發人去叫約押來，要託他去見王，約押卻不肯來。第二次打發人去叫他，他仍不肯來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S214_30","011_14_30","2SA","14","30","30","所以押沙龍對僕人說：「你們看，約押有一塊田，與我的田相近，其中有大麥，你們去放火燒了。」押沙龍的僕人就去放火燒了那田。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S214_31","011_14_31","2SA","14","31","31","於是約押起來，到了押沙龍家裏，問他說：「你的僕人為何放火燒了我的田呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S214_32","011_14_32","2SA","14","32","32","押沙龍回答約押說：「我打發人去請你來，好託你去見王，替我說：『我為何從基述回來呢？不如仍在那裏。』現在要許我見王的面；我若有罪，任憑王殺我就是了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S214_33","011_14_33","2SA","14","33","33","於是約押去見王，將這話奏告王，王便叫押沙龍來。押沙龍來見王，在王面前俯伏於地，王就與押沙龍親嘴。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S215_1","011_15_1","2SA","15","1","1","此後，押沙龍為自己預備車馬，又派五十人在他前頭奔走。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S215_2","011_15_2","2SA","15","2","2","押沙龍常常早晨起來，站在城門的道旁，凡有爭訟要去求王判斷的，押沙龍就叫他過來，問他說：「你是哪一城的人？」回答說：「僕人是以色列某支派的人。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S215_3","011_15_3","2SA","15","3","3","押沙龍對他說：「你的事有情有理，無奈王沒有委人聽你伸訴。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S215_4","011_15_4","2SA","15","4","4","押沙龍又說：「恨不得我作國中的士師！凡有爭訟求審判的到我這裏來，我必秉公判斷。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S215_5","011_15_5","2SA","15","5","5","若有人近前來要拜押沙龍，押沙龍就伸手拉住他，與他親嘴。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S215_6","011_15_6","2SA","15","6","6","以色列人中，凡去見王求判斷的，押沙龍都是如此待他們。這樣，押沙龍暗中得了以色列人的心。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S215_7","011_15_7","2SA","15","7","7","滿了四十年，押沙龍對王說：「求你准我往希伯崙去，還我向耶和華所許的願。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S215_8","011_15_8","2SA","15","8","8","因為僕人住在亞蘭的基述，曾許願說：『耶和華若使我再回耶路撒冷，我必事奉他。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S215_9","011_15_9","2SA","15","9","9","王說：「你平平安安地去吧！」押沙龍就起身，往希伯崙去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S215_10","011_15_10","2SA","15","10","10","押沙龍打發探子走遍以色列各支派，說：「你們一聽見角聲就說：『押沙龍在希伯崙作王了！』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S215_11","011_15_11","2SA","15","11","11","押沙龍在耶路撒冷請了二百人與他同去，都是誠誠實實去的，並不知道其中的真情。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S215_12","011_15_12","2SA","15","12","12","押沙龍獻祭的時候，打發人去將大衛的謀士、基羅人亞希多弗從他本城請了來。於是叛逆的勢派甚大；因為隨從押沙龍的人民，日漸增多。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S215_13","011_15_13","2SA","15","13","13","有人報告大衛說：「以色列人的心都歸向押沙龍了！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S215_14","011_15_14","2SA","15","14","14","大衛就對耶路撒冷跟隨他的臣僕說：「我們要起來逃走，不然都不能躲避押沙龍了；要速速地去，恐怕他忽然來到，加害於我們，用刀殺盡合城的人。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S215_15","011_15_15","2SA","15","15","15","王的臣僕對王說：「我主我王所定的，僕人都願遵行。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S215_16","011_15_16","2SA","15","16","16","於是王帶着全家的人出去了，但留下十個妃嬪看守宮殿。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S215_17","011_15_17","2SA","15","17","17","王出去，眾民都跟隨他，到伯墨哈，就住下了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S215_18","011_15_18","2SA","15","18","18","王的臣僕都在他面前過去。基利提人、比利提人，就是從迦特跟隨王來的六百人，也都在他面前過去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S215_19","011_15_19","2SA","15","19","19","王對迦特人以太說：「你是外邦逃來的人，為甚麼與我們同去呢？你可以回去與新王同住，或者回你本地去吧！ ");
INSERT INTO cmn_cu89t_vpl VALUES ("S215_20","011_15_20","2SA","15","20","20","你來的日子不多，我今日怎好叫你與我們一同飄流、沒有一定的住處呢？你不如帶你的弟兄回去吧！願耶和華用慈愛誠實待你。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S215_21","011_15_21","2SA","15","21","21","以太對王說：「我指着永生的耶和華起誓，又敢在王面前起誓：無論生死，王在哪裏，僕人也必在那裏。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S215_22","011_15_22","2SA","15","22","22","大衛對以太說：「你前去過河吧！」於是迦特人以太帶着跟隨他的人和所有的婦人孩子，就都過去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S215_23","011_15_23","2SA","15","23","23","本地的人都放聲大哭。眾民盡都過去，王也過了汲淪溪；眾民往曠野去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S215_24","011_15_24","2SA","15","24","24","撒督和抬上帝約櫃的利未人也一同來了，將上帝的約櫃放下。亞比亞他上來，等着眾民從城裏出來過去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S215_25","011_15_25","2SA","15","25","25","王對撒督說：「你將上帝的約櫃抬回城去。我若在耶和華眼前蒙恩，他必使我回來，再見約櫃和他的居所。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S215_26","011_15_26","2SA","15","26","26","倘若他說：『我不喜悅你』，看哪，我在這裏，願他憑自己的意旨待我！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S215_27","011_15_27","2SA","15","27","27","王又對祭司撒督說：「你不是先見嗎？你可以安然回城；你兒子亞希瑪斯和亞比亞他的兒子約拿單都可以與你同去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S215_28","011_15_28","2SA","15","28","28","我在曠野的渡口那裏等你們報信給我。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S215_29","011_15_29","2SA","15","29","29","於是撒督和亞比亞他將上帝的約櫃抬回耶路撒冷，他們就住在那裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S215_30","011_15_30","2SA","15","30","30","大衛蒙頭赤腳上橄欖山，一面上一面哭。跟隨他的人也都蒙頭哭着上去； ");
INSERT INTO cmn_cu89t_vpl VALUES ("S215_31","011_15_31","2SA","15","31","31","有人告訴大衛說：「亞希多弗也在叛黨之中，隨從押沙龍。」大衛禱告說：「耶和華啊，求你使亞希多弗的計謀變為愚拙！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S215_32","011_15_32","2SA","15","32","32","大衛到了山頂、敬拜上帝的地方，見亞基人戶篩，衣服撕裂，頭蒙灰塵來迎接他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S215_33","011_15_33","2SA","15","33","33","大衛對他說：「你若與我同去，必累贅我； ");
INSERT INTO cmn_cu89t_vpl VALUES ("S215_34","011_15_34","2SA","15","34","34","你若回城去，對押沙龍說：『王啊，我願作你的僕人；我向來作你父親的僕人，現在我也照樣作你的僕人。』這樣，你就可以為我破壞亞希多弗的計謀。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S215_35","011_15_35","2SA","15","35","35","祭司撒督和亞比亞他豈不都在那裏嗎？你在王宮裏聽見甚麼，就要告訴祭司撒督和亞比亞他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S215_36","011_15_36","2SA","15","36","36","撒督的兒子亞希瑪斯，亞比亞他的兒子約拿單，也都在那裏。凡你們所聽見的可以託這二人來報告我。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S215_37","011_15_37","2SA","15","37","37","於是，大衛的朋友戶篩進了城；押沙龍也進了耶路撒冷。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S216_1","011_16_1","2SA","16","1","1","大衛剛過山頂，見米非波設的僕人洗巴拉着備好了的兩匹驢，驢上馱着二百麵餅，一百葡萄餅，一百個夏天的果餅，一皮袋酒來迎接他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S216_2","011_16_2","2SA","16","2","2","王問洗巴說：「你帶這些來是甚麼意思呢？」洗巴說：「驢是給王的家眷騎的；麵餅和夏天的果餅是給少年人吃的；酒是給在曠野疲乏人喝的。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S216_3","011_16_3","2SA","16","3","3","王問說：「你主人的兒子在哪裏呢？」洗巴回答王說：「他仍在耶路撒冷，因他說：『以色列人今日必將我父的國歸還我。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S216_4","011_16_4","2SA","16","4","4","王對洗巴說：「凡屬米非波設的都歸你了。」洗巴說：「我叩拜我主我王，願我在你眼前蒙恩。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S216_5","011_16_5","2SA","16","5","5","大衛王到了巴戶琳，見有一個人出來，是掃羅族基拉的兒子，名叫示每。他一面走一面咒罵， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S216_6","011_16_6","2SA","16","6","6","又拿石頭砍大衛王和王的臣僕；眾民和勇士都在王的左右。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S216_7","011_16_7","2SA","16","7","7","示每咒罵說：「你這流人血的壞人哪，去吧去吧！ ");
INSERT INTO cmn_cu89t_vpl VALUES ("S216_8","011_16_8","2SA","16","8","8","你流掃羅全家的血，接續他作王；耶和華把這罪歸在你身上，將這國交給你兒子押沙龍。現在你自取其禍，因為你是流人血的人。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S216_9","011_16_9","2SA","16","9","9","洗魯雅的兒子亞比篩對王說：「這死狗豈可咒罵我主我王呢？求你容我過去，割下他的頭來。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S216_10","011_16_10","2SA","16","10","10","王說：「洗魯雅的兒子，我與你們有何關涉呢？他咒罵是因耶和華吩咐他說：『你要咒罵大衛。』如此，誰敢說你為甚麼這樣行呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S216_11","011_16_11","2SA","16","11","11","大衛又對亞比篩和眾臣僕說：「我親生的兒子尚且尋索我的性命，何況這便雅憫人呢？由他咒罵吧！因為這是耶和華吩咐他的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S216_12","011_16_12","2SA","16","12","12","或者耶和華見我遭難，為我今日被這人咒罵，就施恩與我。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S216_13","011_16_13","2SA","16","13","13","於是大衛和跟隨他的人往前行走。示每在大衛對面山坡，一面行走一面咒罵，又拿石頭砍他，拿土揚他。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S216_14","011_16_14","2SA","16","14","14","王和跟隨他的眾人疲疲乏乏地到了一個地方，就在那裏歇息歇息。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S216_15","011_16_15","2SA","16","15","15","押沙龍和以色列眾人來到耶路撒冷；亞希多弗也與他同來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S216_16","011_16_16","2SA","16","16","16","大衛的朋友亞基人戶篩去見押沙龍，對他說：「願王萬歲！願王萬歲！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S216_17","011_16_17","2SA","16","17","17","押沙龍問戶篩說：「這是你恩待朋友嗎？為甚麼不與你的朋友同去呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S216_18","011_16_18","2SA","16","18","18","戶篩對押沙龍說：「不然，耶和華和這民，並以色列眾人所揀選的，我必歸順他，與他同住。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S216_19","011_16_19","2SA","16","19","19","再者，我當服事誰呢？豈不是前王的兒子嗎？我怎樣服事你父親，也必照樣服事你。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S216_20","011_16_20","2SA","16","20","20","押沙龍對亞希多弗說：「你們出個主意，我們怎樣行才好？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S216_21","011_16_21","2SA","16","21","21","亞希多弗對押沙龍說：「你父所留下看守宮殿的妃嬪，你可以與她們親近。以色列眾人聽見你父親憎惡你，凡歸順你人的手就更堅強。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S216_22","011_16_22","2SA","16","22","22","於是人為押沙龍在宮殿的平頂上支搭帳棚；押沙龍在以色列眾人眼前，與他父的妃嬪親近。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S216_23","011_16_23","2SA","16","23","23","那時亞希多弗所出的主意好像人問上帝的話一樣；他昔日給大衛，今日給押沙龍所出的主意，都是這樣。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S217_1","011_17_1","2SA","17","1","1","亞希多弗又對押沙龍說：「求你准我挑選一萬二千人，今夜我就起身追趕大衛， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S217_2","011_17_2","2SA","17","2","2","趁他疲乏手軟，我忽然追上他，使他驚惶；跟隨他的民必都逃跑，我就單殺王一人， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S217_3","011_17_3","2SA","17","3","3","使眾民都歸順你。你所尋找的人既然死了，眾民就如已經歸順你；這樣，也都平安無事了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S217_4","011_17_4","2SA","17","4","4","押沙龍和以色列的長老都以這話為美。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S217_5","011_17_5","2SA","17","5","5","押沙龍說：「要召亞基人戶篩來，我們也要聽他怎樣說。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S217_6","011_17_6","2SA","17","6","6","戶篩到了押沙龍面前，押沙龍向他說：「亞希多弗是如此如此說的，我們照着他的話行可以不可以？若不可，你就說吧！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S217_7","011_17_7","2SA","17","7","7","戶篩對押沙龍說：「亞希多弗這次所定的謀不善。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S217_8","011_17_8","2SA","17","8","8","戶篩又說：「你知道，你父親和跟隨他的人都是勇士，現在他們心裏惱怒，如同田野丟崽子的母熊一般，而且你父親是個戰士，必不和民一同住宿。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S217_9","011_17_9","2SA","17","9","9","他現今或藏在坑中或在別處，若有人首先被殺，凡聽見的必說：『跟隨押沙龍的民被殺了。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S217_10","011_17_10","2SA","17","10","10","雖有人膽大如獅子，他的心也必消化；因為以色列人都知道你父親是英雄，跟隨他的人也都是勇士。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S217_11","011_17_11","2SA","17","11","11","依我之計，不如將以色列眾人－從但直到別是巴，如同海邊的沙那樣多－聚集到你這裏來，你也親自率領他們出戰。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S217_12","011_17_12","2SA","17","12","12","這樣，我們在何處遇見他，就下到他那裏，如同露水下在地上一般，連他帶跟隨他的人，一個也不留下。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S217_13","011_17_13","2SA","17","13","13","他若進了哪一座城，以色列眾人必帶繩子去，將那城拉到河裏，甚至連一塊小石頭都不剩下。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S217_14","011_17_14","2SA","17","14","14","押沙龍和以色列眾人說：「亞基人戶篩的計謀比亞希多弗的計謀更好！」這是因耶和華定意破壞亞希多弗的良謀，為要降禍與押沙龍。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S217_15","011_17_15","2SA","17","15","15","戶篩對祭司撒督和亞比亞他說：「亞希多弗為押沙龍和以色列的長老所定的計謀是如此如此，我所定的計謀是如此如此。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S217_16","011_17_16","2SA","17","16","16","現在你們要急速打發人去，告訴大衛說：『今夜不可住在曠野的渡口，務要過河，免得王和跟隨他的人都被吞滅。』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S217_17","011_17_17","2SA","17","17","17","那時，約拿單和亞希瑪斯在隱‧羅結那裏等候，不敢進城，恐怕被人看見。有一個使女出來，將這話告訴他們，他們就去報信給大衛王。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S217_18","011_17_18","2SA","17","18","18","然而有一個童子看見他們，就去告訴押沙龍。他們急忙跑到巴戶琳某人的家裏；那人院中有一口井，他們就下到井裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S217_19","011_17_19","2SA","17","19","19","那家的婦人用蓋蓋上井口，又在上頭鋪上碎麥，事就沒有洩漏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S217_20","011_17_20","2SA","17","20","20","押沙龍的僕人來到那家，問婦人說：「亞希瑪斯和約拿單在哪裏？」婦人說：「他們過了河了。」 僕人找他們，找不着，就回耶路撒冷去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S217_21","011_17_21","2SA","17","21","21","他們走後，二人從井裏上來，去告訴大衛王說：「亞希多弗如此如此定計害你，你們務要起來，快快過河。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S217_22","011_17_22","2SA","17","22","22","於是大衛和跟隨他的人都起來，過約旦河。到了天亮，無一人不過約旦河的。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S217_23","011_17_23","2SA","17","23","23","亞希多弗見不依從他的計謀，就備上驢，歸回本城；到了家，留下遺言，便吊死了，葬在他父親的墳墓裏。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S217_24","011_17_24","2SA","17","24","24","大衛到了瑪哈念，押沙龍和跟隨他的以色列人也都過了約旦河。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S217_25","011_17_25","2SA","17","25","25","押沙龍立亞瑪撒作元帥，代替約押。亞瑪撒是以實瑪利人 以特拉的兒子。以特拉曾與拿轄的女兒亞比該親近；這亞比該與約押的母親洗魯雅是姊妹。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S217_26","011_17_26","2SA","17","26","26","押沙龍和以色列人都安營在基列地。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S217_27","011_17_27","2SA","17","27","27","大衛到了瑪哈念，亞捫族的拉巴人拿轄的兒子朔比，羅‧底巴人亞‧米利的兒子瑪吉，基列的羅基琳人巴西萊， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S217_28","011_17_28","2SA","17","28","28","帶着被、褥、盆、碗、瓦器、小麥、大麥、麥麵、炒穀、豆子、紅豆、炒豆、 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S217_29","011_17_29","2SA","17","29","29","蜂蜜、奶油、綿羊、奶餅，供給大衛和跟隨他的人吃；他們說：「民在曠野，必飢渴困乏了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S218_1","011_18_1","2SA","18","1","1","大衛數點跟隨他的人，立千夫長、百夫長率領他們。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S218_2","011_18_2","2SA","18","2","2","大衛打發軍兵出戰，分為三隊：一隊在約押手下，一隊在洗魯雅的兒子、約押兄弟亞比篩手下，一隊在迦特人以太手下。大衛對軍兵說：「我必與你們一同出戰。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S218_3","011_18_3","2SA","18","3","3","軍兵卻說：「你不可出戰。若是我們逃跑，敵人必不介意；我們陣亡一半，敵人也不介意。因為你一人強似我們萬人，你不如在城裏預備幫助我們。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S218_4","011_18_4","2SA","18","4","4","王向他們說：「你們以為怎樣好，我就怎樣行。」於是王站在城門旁，軍兵或百或千地挨次出去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S218_5","011_18_5","2SA","18","5","5","王囑咐約押、亞比篩、以太說：「你們要為我的緣故寬待那少年人押沙龍。」王為押沙龍囑咐眾將的話，兵都聽見了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S218_6","011_18_6","2SA","18","6","6","兵就出到田野迎着以色列人，在以法蓮樹林裏交戰。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S218_7","011_18_7","2SA","18","7","7","以色列人敗在大衛的僕人面前；那日陣亡的甚多，共有二萬人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S218_8","011_18_8","2SA","18","8","8","因為在那裏四面打仗，死於樹林的比死於刀劍的更多。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S218_9","011_18_9","2SA","18","9","9","押沙龍偶然遇見大衛的僕人。押沙龍騎着騾子，從大橡樹密枝底下經過，他的頭髮被樹枝繞住，就懸掛起來，所騎的騾子便離他去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S218_10","011_18_10","2SA","18","10","10","有個人看見，就告訴約押說：「我看見押沙龍掛在橡樹上了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S218_11","011_18_11","2SA","18","11","11","約押對報信的人說：「你既看見他，為甚麼不將他打死落在地上呢？你若打死他，我就賞你十舍客勒銀子，一條帶子。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S218_12","011_18_12","2SA","18","12","12","那人對約押說：「我就是得你一千舍客勒銀子，我也不敢伸手害王的兒子；因為我們聽見王囑咐你和亞比篩並以太說：『你們要謹慎，不可害那少年人押沙龍。』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S218_13","011_18_13","2SA","18","13","13","我若妄為害了他的性命，就是你自己也必與我為敵（原來，無論何事都瞞不過王。）」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S218_14","011_18_14","2SA","18","14","14","約押說：「我不能與你留連。」約押手拿三杆短槍，趁押沙龍在橡樹上還活着，就刺透他的心。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S218_15","011_18_15","2SA","18","15","15","給約押拿兵器的十個少年人圍繞押沙龍，將他殺死。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S218_16","011_18_16","2SA","18","16","16","約押吹角，攔阻眾人，他們就回來，不再追趕以色列人。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S218_17","011_18_17","2SA","18","17","17","他們將押沙龍丟在林中一個大坑裏，上頭堆起一大堆石頭。以色列眾人都逃跑，各回各家去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S218_18","011_18_18","2SA","18","18","18","押沙龍活着的時候，在王谷立了一根石柱，因他說：「我沒有兒子為我留名。」他就以自己的名稱那石柱叫押沙龍柱，直到今日。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S218_19","011_18_19","2SA","18","19","19","撒督的兒子亞希瑪斯說：「容我跑去，將耶和華向仇敵給王報仇的信息報與王知。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S218_20","011_18_20","2SA","18","20","20","約押對他說：「你今日不可去報信，改日可以報信；因為今日王的兒子死了，所以你不可去報信。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S218_21","011_18_21","2SA","18","21","21","約押對古示人說：「你去將你所看見的告訴王。」古示人在約押面前下拜，就跑去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S218_22","011_18_22","2SA","18","22","22","撒督的兒子亞希瑪斯又對約押說：「無論怎樣，求你容我隨着古示人跑去。」約押說：「我兒，你報這信息，既不得賞賜，何必要跑去呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S218_23","011_18_23","2SA","18","23","23","他又說：「無論怎樣，我要跑去。」約押說：「你跑去吧！」亞希瑪斯就從平原往前跑，跑過古示人去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S218_24","011_18_24","2SA","18","24","24","大衛正坐在城甕裏。守望的人上城門樓的頂上，舉目觀看，見有一個人獨自跑來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S218_25","011_18_25","2SA","18","25","25","守望的人就大聲告訴王。王說：「他若獨自來，必是報口信的。」那人跑得漸漸近了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S218_26","011_18_26","2SA","18","26","26","守望的人又見一人跑來，就對守城門的人說：「又有一人獨自跑來。」王說：「這也必是報信的。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S218_27","011_18_27","2SA","18","27","27","守望的人說：「我看前頭人的跑法，好像撒督的兒子亞希瑪斯的跑法一樣。」王說：「他是個好人，必是報好信息。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S218_28","011_18_28","2SA","18","28","28","亞希瑪斯向王呼叫說：「平安了！」就在王面前臉伏於地叩拜，說：「耶和華－你的上帝是應當稱頌的，因他已將那舉手攻擊我主我王的人交給王了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S218_29","011_18_29","2SA","18","29","29","王問說：「少年人押沙龍平安不平安？」亞希瑪斯回答說：「約押打發王的僕人，那時僕人聽見眾民大聲喧嘩，卻不知道是甚麼事。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S218_30","011_18_30","2SA","18","30","30","王說：「你退去，站在旁邊。」他就退去，站在旁邊。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S218_31","011_18_31","2SA","18","31","31","古示人也來到，說：「有信息報給我主我王！耶和華今日向一切興起攻擊你的人給你報仇了。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S218_32","011_18_32","2SA","18","32","32","王問古示人說：「少年人押沙龍平安不平安？」古示人回答說：「願我主我王的仇敵，和一切興起要殺害你的人，都與那少年人一樣。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S218_33","011_18_33","2SA","18","33","33","王就心裏傷慟，上城門樓去哀哭，一面走一面說：「我兒押沙龍啊！我兒，我兒押沙龍啊！我恨不得替你死，押沙龍啊，我兒！我兒！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S219_1","011_19_1","2SA","19","1","1","有人告訴約押說：「王為押沙龍哭泣悲哀。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S219_2","011_19_2","2SA","19","2","2","眾民聽說王為他兒子憂愁，他們得勝的歡樂卻變成悲哀。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S219_3","011_19_3","2SA","19","3","3","那日眾民暗暗地進城，就如敗陣逃跑、慚愧的民一般。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S219_4","011_19_4","2SA","19","4","4","王蒙着臉，大聲哭號說：「我兒押沙龍啊！押沙龍，我兒，我兒啊！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S219_5","011_19_5","2SA","19","5","5","約押進去見王，說：「你今日使你一切僕人臉面慚愧了！他們今日救了你的性命和你兒女妻妾的性命， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S219_6","011_19_6","2SA","19","6","6","你卻愛那恨你的人，恨那愛你的人。你今日明明地不以將帥、僕人為念。我今日看明，若押沙龍活着，我們都死亡，你就喜悅了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S219_7","011_19_7","2SA","19","7","7","現在你當出去，安慰你僕人的心。我指着耶和華起誓：你若不出去，今夜必無一人與你同在一處；這禍患就比你從幼年到如今所遭的更甚！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S219_8","011_19_8","2SA","19","8","8","於是王起來，坐在城門口。眾民聽說王坐在城門口，就都到王面前。 以色列人已經逃跑，各回各家去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S219_9","011_19_9","2SA","19","9","9","以色列眾支派的人紛紛議論說：「王曾救我們脫離仇敵的手，又救我們脫離非利士人的手，現在他躲避押沙龍逃走了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S219_10","011_19_10","2SA","19","10","10","我們膏押沙龍治理我們，他已經陣亡。現在為甚麼不出一言請王回來呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S219_11","011_19_11","2SA","19","11","11","大衛王差人去見祭司撒督和亞比亞他，說：「你們當向猶大長老說：『以色列眾人已經有話請王回宮，你們為甚麼落在他們後頭呢？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("S219_12","011_19_12","2SA","19","12","12","你們是我的弟兄，是我的骨肉，為甚麼在人後頭請王回來呢？』 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S219_13","011_19_13","2SA","19","13","13","也要對亞瑪撒說：『你不是我的骨肉嗎？我若不立你替約押常作元帥，願上帝重重地降罰與我！』」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S219_14","011_19_14","2SA","19","14","14","如此就挽回猶大眾人的心，如同一人的心。他們便打發人去見王，說：「請王和王的一切臣僕回來。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S219_15","011_19_15","2SA","19","15","15","王就回來，到了約旦河。猶大人來到吉甲，要去迎接王，請他過約旦河。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S219_16","011_19_16","2SA","19","16","16","巴戶琳的便雅憫人、基拉的兒子示每急忙與猶大人一同下去迎接大衛王。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S219_17","011_19_17","2SA","19","17","17","跟從示每的有一千便雅憫人，還有掃羅家的僕人洗巴和他十五個兒子，二十個僕人；他們都詵過約旦河迎接王。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S219_18","011_19_18","2SA","19","18","18","有擺渡船過去，渡王的家眷，任王使用。 王要過約旦河的時候，基拉的兒子示每就俯伏在王面前， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S219_19","011_19_19","2SA","19","19","19","對王說：「我主我王出耶路撒冷的時候，僕人行悖逆的事，現在求我主不要因此加罪與僕人，不要記念，也不要放在心上。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S219_20","011_19_20","2SA","19","20","20","僕人明知自己有罪，所以約瑟全家之中，今日我首先下來迎接我主我王。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S219_21","011_19_21","2SA","19","21","21","洗魯雅的兒子亞比篩說：「示每既咒罵耶和華的受膏者，不應當治死他嗎？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S219_22","011_19_22","2SA","19","22","22","大衛說：「洗魯雅的兒子，我與你們有何關涉，使你們今日與我反對呢？今日在以色列中豈可治死人呢？我豈不知今日我作以色列的王嗎？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S219_23","011_19_23","2SA","19","23","23","於是王對示每說：「你必不死。」王就向他起誓。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S219_24","011_19_24","2SA","19","24","24","掃羅的孫子米非波設也下去迎接王。他自從王去的日子，直到王平平安安地回來，沒有修腳，沒有剃鬍鬚，也沒有洗衣服。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S219_25","011_19_25","2SA","19","25","25","他來到耶路撒冷迎接王的時候，王問他說：「米非波設，你為甚麼沒有與我同去呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S219_26","011_19_26","2SA","19","26","26","他回答說：「我主我王，僕人是瘸腿的。那日我想要備驢騎上，與王同去，無奈我的僕人欺哄了我， ");
INSERT INTO cmn_cu89t_vpl VALUES ("S219_27","011_19_27","2SA","19","27","27","又在我主我王面前讒毀我。然而我主我王如同上帝的使者一般，你看怎樣好，就怎樣行吧！ ");
INSERT INTO cmn_cu89t_vpl VALUES ("S219_28","011_19_28","2SA","19","28","28","因為我祖全家的人，在我主我王面前都算為死人，王卻使僕人在王的席上同人吃飯，我現在向王還能辨理訴冤嗎？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S219_29","011_19_29","2SA","19","29","29","王對他說：「你何必再提你的事呢？我說，你與洗巴均分地土。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S219_30","011_19_30","2SA","19","30","30","米非波設對王說：「我主我王既平平安安地回宮，就任憑洗巴都取了也可以。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S219_31","011_19_31","2SA","19","31","31","基列人巴西萊從羅基琳下來，要送王過約旦河，就與王一同過了約旦河。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S219_32","011_19_32","2SA","19","32","32","巴西萊年紀老邁，已經八十歲了。王住在瑪哈念的時候，他就拿食物來供給王；他原是大富戶。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S219_33","011_19_33","2SA","19","33","33","王對巴西萊說：「你與我同去，我要在耶路撒冷那裏養你的老。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S219_34","011_19_34","2SA","19","34","34","巴西萊對王說：「我在世的年日還能有多少，使我與王同上耶路撒冷呢？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("S219_35","011_19_35","2SA","19","35","35","僕人現在八十歲了，還能嘗出飲食的滋味、辨別美惡嗎？還能聽男女歌唱的聲音嗎？僕人何必累贅我主我王呢？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("S219_36","011_19_36","2SA","19","36","36","僕人只要送王過約旦河，王何必賜我這樣的恩典呢？ ");
INSERT INTO cmn_cu89t_vpl VALUES ("S219_37","011_19_37","2SA","19","37","37","求你准我回去，好死在我本城，葬在我父母的墓旁。這裏有王的僕人金罕，讓他同我主我王過去，可以隨意待他。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S219_38","011_19_38","2SA","19","38","38","王說：「金罕可以與我同去，我必照你的心願待他。你向我求甚麼，我都必為你成就。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S219_39","011_19_39","2SA","19","39","39","於是眾民過約旦河，王也過去。王與巴西萊親嘴，為他祝福，巴西萊就回本地去了。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S219_40","011_19_40","2SA","19","40","40","王過去，到了吉甲，金罕也跟他過去。猶大眾民和以色列民的一半也都送王過去。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S219_41","011_19_41","2SA","19","41","41","以色列眾人來見王，對他說：「我們弟兄猶大人為甚麼暗暗送王和王的家眷，並跟隨王的人過約旦河？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S219_42","011_19_42","2SA","19","42","42","猶大眾人回答以色列人說：「因為王與我們是親屬，你們為何因這事發怒呢？我們吃了王的甚麼呢？王賞賜了我們甚麼呢？」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S219_43","011_19_43","2SA","19","43","43","以色列人回答猶大人說：「按支派，我們與王有十分的情分；在大衛身上，我們也比你們更有情分。你們為何藐視我們，請王回來不先與我們商量呢？」 但猶大人的話比以色列人的話更硬。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S220_1","011_20_1","2SA","20","1","1","在那裏恰巧有一個匪徒，名叫示巴，是便雅憫人比基利的兒子。他吹角，說：「我們與大衛無分，與耶西的兒子無涉。以色列人哪，你們各回各家去吧！」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S220_2","011_20_2","2SA","20","2","2","於是以色列人都離開大衛，跟隨比基利的兒子示巴。但猶大人從約旦河直到耶路撒冷，都緊緊跟隨他們的王。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S220_3","011_20_3","2SA","20","3","3","大衛王來到耶路撒冷，進了宮殿，就把從前留下看守宮殿的十個妃嬪禁閉在冷宮，養活她們，不與她們親近。她們如同寡婦被禁，直到死的日子。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S220_4","011_20_4","2SA","20","4","4","王對亞瑪撒說：「你要在三日之內將猶大人招聚了來，你也回到這裏來。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S220_5","011_20_5","2SA","20","5","5","亞瑪撒就去招聚猶大人，卻耽延過了王所限的日期。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S220_6","011_20_6","2SA","20","6","6","大衛對亞比篩說：「現在恐怕比基利的兒子示巴加害於我們比押沙龍更甚。你要帶領你主的僕人追趕他，免得他得了堅固城，躲避我們。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S220_7","011_20_7","2SA","20","7","7","約押的人和基利提人、比利提人，並所有的勇士，都跟着亞比篩，從耶路撒冷出去追趕比基利的兒子示巴。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S220_8","011_20_8","2SA","20","8","8","他們到了基遍的大磐石那裏，亞瑪撒來迎接他們。那時約押穿着戰衣，腰束佩刀的帶子，刀在鞘內；約押前行，刀從鞘內掉出來。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S220_9","011_20_9","2SA","20","9","9","約押左手拾起刀來，對亞瑪撒說：「我兄弟，你好啊！」就用右手抓住亞瑪撒的鬍子，要與他親嘴。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S220_10","011_20_10","2SA","20","10","10","亞瑪撒沒有防備約押手裏所拿的刀；約押用刀刺入他的肚腹，他的腸子流在地上，沒有再刺他，就死了。 約押和他兄弟亞比篩往前追趕比基利的兒子示巴。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S220_11","011_20_11","2SA","20","11","11","有約押的一個少年人站在亞瑪撒屍身旁邊，對眾人說：「誰喜悅約押，誰歸順大衛，就當跟隨約押去。」 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S220_12","011_20_12","2SA","20","12","12","亞瑪撒在道路上滾在自己的血裏。那人見眾民經過都站住，就把亞瑪撒的屍身從路上挪到田間，用衣服遮蓋。 ");
INSERT INTO cmn_cu89t_vpl VALUES ("S220_13","011_20_13","2SA","20","1