﻿USE sofia;
DROP TABLE IF EXISTS sofia.cmn_cu89s_vpl;
CREATE TABLE cmn_cu89s_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cmn_cu89s_vpl WRITE;
INSERT INTO cmn_cu89s_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","起初，　神创造天地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","地是空虚混沌，渊面黑暗；　神的灵运行在水面上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","神说：「要有光」，就有了光。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","神看光是好的，就把光暗分开了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","神称光为「昼」，称暗为「夜」。有晚上，有早晨，这是头一日。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","神说：「诸水之间要有空气，将水分为上下。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","神就造出空气，将空气以下的水、空气以上的水分开了。事就这样成了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","神称空气为「天」。有晚上，有早晨，是第二日。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","神说：「天下的水要聚在一处，使旱地露出来。」事就这样成了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","神称旱地为「地」，称水的聚处为「海」。　神看着是好的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","神说：「地要发生青草和结种子的菜蔬，并结果子的树木，各从其类，果子都包着核。」事就这样成了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","于是地发生了青草和结种子的菜蔬，各从其类；并结果子的树木，各从其类；果子都包着核。　神看着是好的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","有晚上，有早晨，是第三日。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","神说：「天上要有光体，可以分昼夜，作记号，定节令、日子、年岁， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","并要发光在天空，普照在地上。」事就这样成了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","于是　神造了两个大光，大的管昼，小的管夜，又造众星， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","就把这些光摆列在天空，普照在地上， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","管理昼夜，分别明暗。　神看着是好的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","有晚上，有早晨，是第四日。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","神说：「水要多多滋生有生命的物；要有雀鸟飞在地面以上，天空之中。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","神就造出大鱼和水中所滋生各样有生命的动物，各从其类；又造出各样飞鸟，各从其类。　神看着是好的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","神就赐福给这一切，说：「滋生繁多，充满海中的水；雀鸟也要多生在地上。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","有晚上，有早晨，是第五日。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","神说：「地要生出活物来，各从其类；牲畜、昆虫、野兽，各从其类。」事就这样成了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","于是　神造出野兽，各从其类；牲畜，各从其类；地上一切昆虫，各从其类。　神看着是好的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","神说：「我们要照着我们的形象、按着我们的样式造人，使他们管理海里的鱼、空中的鸟、地上的牲畜，和全地，并地上所爬的一切昆虫。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","神就照着自己的形象造人，乃是照着他的形象造男造女。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","神就赐福给他们，又对他们说：「要生养众多，遍满地面，治理这地，也要管理海里的鱼、空中的鸟，和地上各样行动的活物。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","神说：「看哪，我将遍地上一切结种子的菜蔬和一切树上所结有核的果子全赐给你们作食物。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","至于地上的走兽和空中的飞鸟，并各样爬在地上有生命的物，我将青草赐给它们作食物。」事就这样成了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","神看着一切所造的都甚好。有晚上，有早晨，是第六日。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","天地万物都造齐了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","到第七日，　神造物的工已经完毕，就在第七日歇了他一切的工，安息了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","神赐福给第七日，定为圣日；因为在这日，　神歇了他一切创造的工，就安息了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","创造天地的来历，在耶和华　神造天地的日子，乃是这样， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","野地还没有草木，田间的菜蔬还没有长起来；因为耶和华　神还没有降雨在地上，也没有人耕地， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","但有雾气从地上腾，滋润遍地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","耶和华　神用地上的尘土造人，将生气吹在他鼻孔里，他就成了有灵的活人，名叫 亚当。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","耶和华　神在东方的伊甸立了一个园子，把所造的人安置在那里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","耶和华　神使各样的树从地里长出来，可以悦人的眼目，其上的果子好作食物。园子当中又有生命树和分别善恶的树。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","有河从伊甸流出来，滋润那园子，从那里分为四道： ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","第一道名叫比逊，就是环绕哈腓拉全地的。在那里有金子， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","并且那地的金子是好的；在那里又有珍珠和红玛瑙。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","第二道河名叫基训，就是环绕古实全地的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","第三道河名叫底格里斯，流在亚述的东边。第四道河就是幼发拉底河。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","耶和华　神将那人安置在伊甸园，使他修理，看守。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","耶和华　神吩咐他说：「园中各样树上的果子，你可以随意吃， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","只是分别善恶树上的果子，你不可吃，因为你吃的日子必定死！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","耶和华　神说：「那人独居不好，我要为他造一个配偶帮助他。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","耶和华　神用土所造成的野地各样走兽和空中各样飞鸟都带到那人面前，看他叫什么。那人怎样叫各样的活物，那就是它的名字。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","那人便给一切牲畜和空中飞鸟、野地走兽都起了名；只是那人没有遇见配偶帮助他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","耶和华　神使他沉睡，他就睡了；于是取下他的一条肋骨，又把肉合起来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","耶和华　神就用那人身上所取的肋骨造成一个女人，领她到那人跟前。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","那人说： 这是我骨中的骨， 肉中的肉， 可以称她为「女人」， 因为她是从「男人」身上取出来的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","因此，人要离开父母，与妻子连合，二人成为一体。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","当时夫妻二人赤身露体，并不羞耻。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","耶和华　神所造的，惟有蛇比田野一切的活物更狡猾。蛇对女人说：「　神岂是真说不许你们吃园中所有树上的果子吗？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","女人对蛇说：「园中树上的果子，我们可以吃， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","惟有园当中那棵树上的果子，　神曾说：『你们不可吃，也不可摸，免得你们死。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","蛇对女人说：「你们不一定死； ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","因为　神知道，你们吃的日子眼睛就明亮了，你们便如　神能知道善恶。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","于是女人见那棵树的果子好作食物，也悦人的眼目，且是可喜爱的，能使人有智慧，就摘下果子来吃了，又给她丈夫，她丈夫也吃了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","他们二人的眼睛就明亮了，才知道自己是赤身露体，便拿无花果树的叶子为自己编做裙子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","天起了凉风，耶和华　神在园中行走。那人和他妻子听见　神的声音，就藏在园里的树木中，躲避耶和华　神的面。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","耶和华　神呼唤那人，对他说：「你在哪里？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","他说：「我在园中听见你的声音，我就害怕；因为我赤身露体，我便藏了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","耶和华说：「谁告诉你赤身露体呢？莫非你吃了我吩咐你不可吃的那树上的果子吗？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","那人说：「你所赐给我、与我同居的女人，她把那树上的果子给我，我就吃了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","耶和华　神对女人说：「你做的是什么事呢？」女人说：「那蛇引诱我，我就吃了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","耶和华　神对蛇说： 你既做了这事，就必受咒诅， 比一切的牲畜野兽更甚； 你必用肚子行走， 终身吃土。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","我又要叫你和女人彼此为仇； 你的后裔和女人的后裔也彼此为仇。 女人的后裔要伤你的头； 你要伤他的脚跟。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","又对女人说： 我必多多加增你怀胎的苦楚； 你生产儿女必多受苦楚。 你必恋慕你丈夫； 你丈夫必管辖你。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","又对亚当说： 你既听从妻子的话， 吃了我所吩咐你不可吃的那树上的果子， 地必为你的缘故受咒诅； 你必终身劳苦才能从地里得吃的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","地必给你长出荆棘和蒺藜来； 你也要吃田间的菜蔬。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","你必汗流满面才得糊口， 直到你归了土， 因为你是从土而出的。 你本是尘土，仍要归于尘土。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","亚当给他妻子起名叫夏娃，因为她是众生之母。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","耶和华　神为亚当和他妻子用皮子做衣服给他们穿。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","耶和华　神说：「那人已经与我们相似，能知道善恶；现在恐怕他伸手又摘生命树的果子吃，就永远活着。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","耶和华　神便打发他出伊甸园去，耕种他所自出之土。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","于是把他赶出去了；又在伊甸园的东边安设基路伯和四面转动发火焰的剑，要把守生命树的道路。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","有一日，那人和他妻子夏娃同房，夏娃就怀孕，生了该隐，便说：「耶和华使我得了一个男子。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","又生了该隐的兄弟亚伯。亚伯是牧羊的；该隐是种地的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","有一日，该隐拿地里的出产为供物献给耶和华； ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","亚伯也将他羊群中头生的和羊的脂油献上。耶和华看中了亚伯和他的供物， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","只是看不中该隐和他的供物。该隐就大大地发怒，变了脸色。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","耶和华对该隐说：「你为什么发怒呢？你为什么变了脸色呢？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","你若行得好，岂不蒙悦纳？你若行得不好，罪就伏在门前。它必恋慕你，你却要制伏它。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","该隐与他兄弟亚伯说话；二人正在田间。该隐起来打他兄弟亚伯，把他杀了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","耶和华对该隐说：「你兄弟亚伯在哪里？」他说：「我不知道！我岂是看守我兄弟的吗？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","耶和华说：「你做了什么事呢？你兄弟的血有声音从地里向我哀告。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","地开了口，从你手里接受你兄弟的血。现在你必从这地受咒诅。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","你种地，地不再给你效力；你必流离飘荡在地上。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","该隐对耶和华说：「我的刑罚太重，过于我所能当的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","你如今赶逐我离开这地，以致不见你面；我必流离飘荡在地上，凡遇见我的必杀我。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","耶和华对他说：「凡杀该隐的，必遭报七倍。」耶和华就给该隐立一个记号，免得人遇见他就杀他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","于是该隐离开耶和华的面，去住在伊甸东边挪得之地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","该隐与妻子同房，他妻子就怀孕，生了以诺。该隐建造了一座城，就按着他儿子的名将那城叫做以诺。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","以诺生以拿；以拿生米户雅利；米户雅利生玛土撒利；玛土撒利生拉麦。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","拉麦娶了两个妻：一个名叫亚大，一个名叫洗拉。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","亚大生雅八；雅八就是住帐棚、牧养牲畜之人的祖师。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","雅八的兄弟名叫犹八；他是一切弹琴吹箫之人的祖师。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","洗拉又生了土八·该隐；他是打造各样铜铁利器的。土八·该隐的妹子是拿玛。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","拉麦对他两个妻子说： 亚大、洗拉，听我的声音； 拉麦的妻子，细听我的话语： 壮年人伤我，我把他杀了； 少年人损我，我把他害了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","若杀该隐，遭报七倍， 杀拉麦，必遭报七十七倍。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","亚当又与妻子同房，她就生了一个儿子，起名叫塞特，意思说：「　神另给我立了一个儿子代替亚伯，因为该隐杀了他。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","塞特也生了一个儿子，起名叫以挪士。那时候，人才求告耶和华的名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","亚当的后代记在下面。（当　神造人的日子，是照着自己的样式造的， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","并且造男造女。在他们被造的日子，　神赐福给他们，称他们为「人」。） ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","亚当活到一百三十岁，生了一个儿子，形象样式和自己相似，就给他起名叫塞特。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","亚当生塞特之后，又在世八百年，并且生儿养女。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","亚当共活了九百三十岁就死了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","塞特活到一百零五岁，生了以挪士。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","塞特生以挪士之后，又活了八百零七年，并且生儿养女。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","塞特共活了九百一十二岁就死了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","以挪士活到九十岁，生了该南。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","以挪士生该南之后，又活了八百一十五年，并且生儿养女。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","以挪士共活了九百零五岁就死了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","该南活到七十岁，生了玛勒列。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","该南生玛勒列之后，又活了八百四十年，并且生儿养女。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","该南共活了九百一十岁就死了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","玛勒列活到六十五岁，生了雅列。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","玛勒列生雅列之后，又活了八百三十年，并且生儿养女。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","玛勒列共活了八百九十五岁就死了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","雅列活到一百六十二岁，生了以诺。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","雅列生以诺之后，又活了八百年，并且生儿养女。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","雅列共活了九百六十二岁就死了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","以诺活到六十五岁，生了玛土撒拉。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","以诺生玛土撒拉之后，与　神同行三百年，并且生儿养女。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","以诺共活了三百六十五岁。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","以诺与　神同行，　神将他取去，他就不在世了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","玛土撒拉活到一百八十七岁，生了拉麦。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","玛土撒拉生拉麦之后，又活了七百八十二年，并且生儿养女。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","玛土撒拉共活了九百六十九岁就死了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","拉麦活到一百八十二岁，生了一个儿子， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","给他起名叫挪亚，说：「这个儿子必为我们的操作和手中的劳苦安慰我们；这操作劳苦是因为耶和华咒诅地。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","拉麦生挪亚之后，又活了五百九十五年，并且生儿养女。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","拉麦共活了七百七十七岁就死了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","挪亚五百岁生了闪、含、雅弗。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","当人在世上多起来、又生女儿的时候， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","神的儿子们看见人的女子美貌，就随意挑选，娶来为妻。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","耶和华说：「人既属乎血气，我的灵就不永远住在他里面；然而他的日子还可到一百二十年。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","那时候有伟人在地上，后来　神的儿子们和人的女子们交合生子；那就是上古英武有名的人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","耶和华见人在地上罪恶很大，终日所思想的尽都是恶， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","耶和华就后悔造人在地上，心中忧伤。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","耶和华说：「我要将所造的人和走兽，并昆虫，以及空中的飞鸟，都从地上除灭，因为我造他们后悔了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","惟有挪亚在耶和华眼前蒙恩。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","挪亚的后代记在下面。挪亚是个义人，在当时的世代是个完全人。挪亚与　神同行。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","挪亚生了三个儿子，就是闪、含、雅弗。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","世界在　神面前败坏，地上满了强暴。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","神观看世界，见是败坏了；凡有血气的人在地上都败坏了行为。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","神就对挪亚说：「凡有血气的人，他的尽头已经来到我面前；因为地上满了他们的强暴，我要把他们和地一并毁灭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","你要用歌斐木造一只方舟，分一间一间地造，里外抹上松香。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","方舟的造法乃是这样：要长三百肘，宽五十肘，高三十肘。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","方舟上边要留透光处，高一肘。方舟的门要开在旁边。方舟要分上、中、下三层。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","看哪，我要使洪水泛滥在地上，毁灭天下；凡地上有血肉、有气息的活物，无一不死。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","我却要与你立约；你同你的妻，与儿子儿妇，都要进入方舟。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","凡有血肉的活物，每样两个，一公一母，你要带进方舟，好在你那里保全生命。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","飞鸟各从其类，牲畜各从其类，地上的昆虫各从其类，每样两个，要到你那里，好保全生命。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","你要拿各样食物积蓄起来，好作你和它们的食物。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","挪亚就这样行。凡　神所吩咐的，他都照样行了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","耶和华对挪亚说：「你和你的全家都要进入方舟；因为在这世代中，我见你在我面前是义人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","凡洁净的畜类，你要带七公七母；不洁净的畜类，你要带一公一母； ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","空中的飞鸟也要带七公七母，可以留种，活在全地上； ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","因为再过七天，我要降雨在地上四十昼夜，把我所造的各种活物都从地上除灭。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","挪亚就遵着耶和华所吩咐的行了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","当洪水泛滥在地上的时候，挪亚整六百岁。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","挪亚就同他的妻和儿子儿妇都进入方舟，躲避洪水。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","洁净的畜类和不洁净的畜类，飞鸟并地上一切的昆虫， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","都是一对一对地，有公有母，到挪亚那里进入方舟，正如　神所吩咐挪亚的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","过了那七天，洪水泛滥在地上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","当挪亚六百岁，二月十七日那一天，大渊的泉源都裂开了，天上的窗户也敞开了， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","四十昼夜降大雨在地上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","正当那日，挪亚和他三个儿子闪、含、雅弗，并挪亚的妻子和三个儿妇，都进入方舟。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","他们和百兽，各从其类，一切牲畜，各从其类，爬在地上的昆虫，各从其类，一切禽鸟，各从其类，都进入方舟。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","凡有血肉、有气息的活物，都一对一对地到挪亚那里，进入方舟。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","凡有血肉进入方舟的，都是有公有母，正如　神所吩咐挪亚的。耶和华就把他关在方舟里头。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","洪水泛滥在地上四十天，水往上长，把方舟从地上漂起。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","水势浩大，在地上大大地往上长，方舟在水面上漂来漂去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","水势在地上极其浩大，天下的高山都淹没了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","水势比山高过十五肘，山岭都淹没了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","凡在地上有血肉的动物，就是飞鸟、牲畜、走兽，和爬在地上的昆虫，以及所有的人，都死了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","凡在旱地上、鼻孔有气息的生灵都死了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","凡地上各类的活物，连人带牲畜、昆虫，以及空中的飞鸟，都从地上除灭了，只留下挪亚和那些与他同在方舟里的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","水势浩大，在地上共一百五十天。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","神记念挪亚和挪亚方舟里的一切走兽牲畜。　神叫风吹地，水势渐落。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","渊源和天上的窗户都闭塞了，天上的大雨也止住了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","水从地上渐退。过了一百五十天，水就渐消。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","七月十七日，方舟停在亚拉腊山上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","水又渐消，到十月初一日，山顶都现出来了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","过了四十天，挪亚开了方舟的窗户， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","放出一只乌鸦去；那乌鸦飞来飞去，直到地上的水都干了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","他又放出一只鸽子去，要看看水从地上退了没有。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","但遍地上都是水，鸽子找不着落脚之地，就回到方舟挪亚那里，挪亚伸手把鸽子接进方舟来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","他又等了七天，再把鸽子从方舟放出去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","到了晚上，鸽子回到他那里，嘴里叼着一个新拧下来的橄榄叶子，挪亚就知道地上的水退了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","他又等了七天，放出鸽子去，鸽子就不再回来了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","到挪亚六百零一岁，正月初一日，地上的水都干了。挪亚撤去方舟的盖观看，便见地面上干了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","到了二月二十七日，地就都干了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","神对挪亚说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","「你和你的妻子、儿子、儿妇都可以出方舟。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","在你那里凡有血肉的活物，就是飞鸟、牲畜，和一切爬在地上的昆虫，都要带出来，叫它在地上多多滋生，大大兴旺。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","于是挪亚和他的妻子、儿子、儿妇都出来了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","一切走兽、昆虫、飞鸟，和地上所有的动物，各从其类，也都出了方舟。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","挪亚为耶和华筑了一座坛，拿各类洁净的牲畜、飞鸟献在坛上为燔祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","耶和华闻那馨香之气，就心里说：「我不再因人的缘故咒诅地（人从小时心里怀着恶念），也不再按着我才行的灭各种的活物了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","地还存留的时候，稼穑、寒暑、冬夏、昼夜就永不停息了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","神赐福给挪亚和他的儿子，对他们说：「你们要生养众多，遍满了地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","凡地上的走兽和空中的飞鸟都必惊恐，惧怕你们，连地上一切的昆虫并海里一切的鱼都交付你们的手。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","凡活着的动物都可以作你们的食物。这一切我都赐给你们，如同菜蔬一样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","惟独肉带着血，那就是它的生命，你们不可吃。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","流你们血、害你们命的，无论是兽是人，我必讨他的罪，就是向各人的弟兄也是如此。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","凡流人血的，他的血也必被人所流，因为　神造人是照自己的形象造的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","你们要生养众多，在地上昌盛繁茂。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","神晓谕挪亚和他的儿子说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","「我与你们和你们的后裔立约， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","并与你们这里的一切活物—就是飞鸟、牲畜、走兽，凡从方舟里出来的活物—立约。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","我与你们立约，凡有血肉的，不再被洪水灭绝，也不再有洪水毁坏地了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","神说：「我与你们并你们这里的各样活物所立的永约是有记号的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","我把虹放在云彩中，这就可作我与地立约的记号了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","我使云彩盖地的时候，必有虹现在云彩中， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","我便记念我与你们和各样有血肉的活物所立的约，水就再不泛滥、毁坏一切有血肉的物了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","虹必现在云彩中，我看见，就要记念我与地上各样有血肉的活物所立的永约。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","神对挪亚说：「这就是我与地上一切有血肉之物立约的记号了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","出方舟挪亚的儿子就是闪、含、雅弗。含是迦南的父亲。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","这是挪亚的三个儿子，他们的后裔分散在全地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","挪亚作起农夫来，栽了一个葡萄园。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","他喝了园中的酒便醉了，在帐棚里赤着身子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","迦南的父亲含看见他父亲赤身，就到外边告诉他两个弟兄。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","于是闪和雅弗拿件衣服搭在肩上，倒退着进去，给他父亲盖上；他们背着脸就看不见父亲的赤身。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","挪亚醒了酒，知道小儿子向他所做的事， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","就说： 迦南当受咒诅， 必给他弟兄作奴仆的奴仆； ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","又说： 耶和华—闪的　神是应当称颂的！ 愿迦南作闪的奴仆。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","愿　神使雅弗扩张， 使他住在闪的帐棚里； 又愿迦南作他的奴仆。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","洪水以后，挪亚又活了三百五十年。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","挪亚共活了九百五十岁就死了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","挪亚的儿子闪、含、雅弗的后代记在下面。洪水以后，他们都生了儿子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","雅弗的儿子是歌篾、玛各、玛代、雅完、土巴、米设、提拉。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","歌篾的儿子是亚实基拿、利法、陀迦玛。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","雅完的儿子是以利沙、他施、基提、多单。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","这些人的后裔将各国的地土、海岛分开居住，各随各的方言、宗族立国。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","含的儿子是古实、麦西、弗、迦南。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","古实的儿子是西巴、哈腓拉、撒弗他、拉玛、撒弗提迦。拉玛的儿子是示巴、底但。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","古实又生宁录，他为世上英雄之首。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","他在耶和华面前是个英勇的猎户，所以俗语说：「像宁录在耶和华面前是个英勇的猎户。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","他国的起头是巴别、以力、亚甲、甲尼，都在示拿地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","他从那地出来往亚述去，建造尼尼微、利河伯、迦拉， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","和尼尼微、迦拉中间的利鲜，这就是那大城。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","麦西生路低人、亚拿米人、利哈比人、拿弗土希人、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","帕斯鲁细人、迦斯路希人、迦斐托人；从迦斐托出来的有非利士人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","迦南生长子西顿，又生赫 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","和耶布斯人、亚摩利人、革迦撒人、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","希未人、亚基人、西尼人、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","亚瓦底人、洗玛利人、哈马人，后来迦南的诸族分散了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","迦南的境界是从西顿向基拉耳的路上，直到迦萨，又向所多玛、蛾摩拉、押玛、洗扁的路上，直到拉沙。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","这就是含的后裔，各随他们的宗族、方言，所住的地土、邦国。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","雅弗的哥哥闪，是希伯子孙之祖，他也生了儿子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","闪的儿子是以拦、亚述、亚法撒、路德、亚兰。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","亚兰的儿子是乌斯、户勒、基帖、玛施。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","亚法撒生沙拉；沙拉生希伯。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","希伯生了两个儿子，一个名叫法勒，因为那时人就分地居住；法勒的兄弟名叫约坍。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","约坍生亚摩答、沙列、哈萨玛非、耶拉、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","哈多兰、乌萨、德拉、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","俄巴路、亚比玛利、示巴、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","阿斐、哈腓拉、约巴，这都是约坍的儿子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","他们所住的地方是从米沙直到西发东边的山。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","这就是闪的子孙，各随他们的宗族、方言，所住的地土、邦国。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","这些都是挪亚三个儿子的宗族，各随他们的支派立国。洪水以后，他们在地上分为邦国。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","那时，天下人的口音、言语都是一样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","他们往东边迁移的时候，在示拿地遇见一片平原，就住在那里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","他们彼此商量说：「来吧！我们要做砖，把砖烧透了。」他们就拿砖当石头，又拿石漆当灰泥。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","他们说：「来吧！我们要建造一座城和一座塔，塔顶通天，为要传扬我们的名，免得我们分散在全地上。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","耶和华降临，要看看世人所建造的城和塔。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","耶和华说：「看哪，他们成为一样的人民，都是一样的言语，如今既做起这事来，以后他们所要做的事就没有不成就的了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","我们下去，在那里变乱他们的口音，使他们的言语彼此不通。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","于是耶和华使他们从那里分散在全地上；他们就停工，不造那城了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","因为耶和华在那里变乱天下人的言语，使众人分散在全地上，所以那城名叫巴别。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","闪的后代记在下面。洪水以后二年，闪一百岁生了亚法撒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","闪生亚法撒之后又活了五百年，并且生儿养女。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","亚法撒活到三十五岁，生了沙拉。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","亚法撒生沙拉之后又活了四百零三年，并且生儿养女。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","沙拉活到三十岁，生了希伯。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","沙拉生希伯之后又活了四百零三年，并且生儿养女。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","希伯活到三十四岁，生了法勒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","希伯生法勒之后又活了四百三十年，并且生儿养女。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","法勒活到三十岁，生了拉吴。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","法勒生拉吴之后又活了二百零九年，并且生儿养女。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","拉吴活到三十二岁，生了西鹿。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","拉吴生西鹿之后又活了二百零七年，并且生儿养女。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","西鹿活到三十岁，生了拿鹤。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","西鹿生拿鹤之后又活了二百年，并且生儿养女。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","拿鹤活到二十九岁，生了他拉。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","拿鹤生他拉之后又活了一百一十九年，并且生儿养女。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","他拉活到七十岁，生了亚伯兰、拿鹤、哈兰。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","他拉的后代记在下面。他拉生亚伯兰、拿鹤、哈兰；哈兰生罗得。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","哈兰死在他的本地迦勒底的吾珥，在他父亲他拉之先。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","亚伯兰、拿鹤各娶了妻：亚伯兰的妻子名叫撒莱；拿鹤的妻子名叫密迦，是哈兰的女儿；哈兰是密迦和亦迦的父亲。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","撒莱不生育，没有孩子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","他拉带着他儿子亚伯兰和他孙子哈兰的儿子罗得，并他儿妇亚伯兰的妻子撒莱，出了迦勒底的吾珥，要往迦南地去；他们走到哈兰，就住在那里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","他拉共活了二百零五岁，就死在哈兰。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","耶和华对亚伯兰说：「你要离开本地、本族、父家，往我所要指示你的地去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","我必叫你成为大国。我必赐福给你，叫你的名为大；你也要叫别人得福。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","为你祝福的，我必赐福与他；那咒诅你的，我必咒诅他。地上的万族都要因你得福。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","亚伯兰就照着耶和华的吩咐去了；罗得也和他同去。亚伯兰出哈兰的时候年七十五岁。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","亚伯兰将他妻子撒莱和侄儿罗得，连他们在哈兰所积蓄的财物、所得的人口，都带往迦南地去。他们就到了迦南地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","亚伯兰经过那地，到了示剑地方、摩利橡树那里。那时迦南人住在那地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","耶和华向亚伯兰显现，说：「我要把这地赐给你的后裔。」亚伯兰就在那里为向他显现的耶和华筑了一座坛。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","从那里他又迁到伯特利东边的山，支搭帐棚；西边是伯特利，东边是艾。他在那里又为耶和华筑了一座坛，求告耶和华的名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","后来亚伯兰又渐渐迁往南地去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","那地遭遇饥荒。因饥荒甚大，亚伯兰就下埃及去，要在那里暂居。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","将近埃及，就对他妻子撒莱说：「我知道你是容貌俊美的妇人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","埃及人看见你必说：『这是他的妻子』，他们就要杀我，却叫你存活。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","求你说，你是我的妹子，使我因你得平安，我的命也因你存活。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","及至亚伯兰到了埃及，埃及人看见那妇人极其美貌。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","法老的臣宰看见了她，就在法老面前夸奖她。那妇人就被带进法老的宫去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","法老因这妇人就厚待亚伯兰，亚伯兰得了许多牛、羊、骆驼、公驴、母驴、仆婢。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","耶和华因亚伯兰妻子撒莱的缘故，降大灾与法老和他的全家。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","法老就召了亚伯兰来，说：「你这向我做的是什么事呢？为什么没有告诉我她是你的妻子？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","为什么说她是你的妹子，以致我把她取来要作我的妻子？现在你的妻子在这里，可以带她走吧。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","于是法老吩咐人将亚伯兰和他妻子，并他所有的都送走了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","亚伯兰带着他的妻子与罗得，并一切所有的，都从埃及上南地去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","亚伯兰的金、银、牲畜极多。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","他从南地渐渐往伯特利去，到了伯特利和艾的中间，就是从前支搭帐棚的地方， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","也是他起先筑坛的地方；他又在那里求告耶和华的名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","与亚伯兰同行的罗得也有牛群、羊群、帐棚。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","那地容不下他们；因为他们的财物甚多，使他们不能同居。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","当时，迦南人与比利洗人在那地居住。亚伯兰的牧人和罗得的牧人相争。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","亚伯兰就对罗得说：「你我不可相争，你的牧人和我的牧人也不可相争，因为我们是骨肉。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","遍地不都在你眼前吗？请你离开我：你向左，我就向右；你向右，我就向左。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","罗得举目看见约旦河的全平原，直到琐珥，都是滋润的，那地在耶和华未灭所多玛、蛾摩拉以先如同耶和华的园子，也像埃及地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","于是罗得选择约旦河的全平原，往东迁移；他们就彼此分离了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","亚伯兰住在迦南地，罗得住在平原的城邑，渐渐挪移帐棚，直到所多玛。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","所多玛人在耶和华面前罪大恶极。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","罗得离别亚伯兰以后，耶和华对亚伯兰说：「从你所在的地方，你举目向东西南北观看； ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","凡你所看见的一切地，我都要赐给你和你的后裔，直到永远。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","我也要使你的后裔如同地上的尘沙那样多，人若能数算地上的尘沙才能数算你的后裔。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","你起来，纵横走遍这地，因为我必把这地赐给你。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","亚伯兰就搬了帐棚，来到希伯 、幔利的橡树那里居住，在那里为耶和华筑了一座坛。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","当暗拉非作示拿王，亚略作以拉撒王，基大老玛作以拦王，提达作戈印王的时候， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","他们都攻打所多玛王比拉、蛾摩拉王比沙、押玛王示纳、洗扁王善以别，和比拉王；比拉就是琐珥。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","这五王都在西订谷会合；西订谷就是盐海。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","他们已经事奉基大老玛十二年，到十三年就背叛了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","十四年，基大老玛和同盟的王都来在亚特律·加宁，杀败了利乏音人，在哈麦杀败了苏西人，在沙微·基列亭杀败了以米人， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","在何利人的西珥山杀败了何利人，一直杀到靠近旷野的伊勒·巴兰。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","他们回到安·密巴，就是加低斯，杀败了亚玛力全地的人，以及住在哈洗逊·他玛的亚摩利人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","于是所多玛王、蛾摩拉王、押玛王、洗扁王，和比拉王（比拉就是琐珥）都出来，在西订谷摆阵，与他们交战， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","就是与以拦王基大老玛、戈印王提达、示拿王暗拉非、以拉撒王亚略交战；乃是四王与五王交战。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","西订谷有许多石漆坑。所多玛王和蛾摩拉王逃跑，有掉在坑里的，其余的人都往山上逃跑。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","四王就把所多玛和蛾摩拉所有的财物，并一切的粮食都掳掠去了； ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","又把亚伯兰的侄儿罗得和罗得的财物掳掠去了。当时罗得正住在所多玛。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","有一个逃出来的人告诉希伯来人亚伯兰；亚伯兰正住在亚摩利人幔利的橡树那里。幔利和以实各并亚乃都是弟兄，曾与亚伯兰联盟。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","亚伯兰听见他侄儿被掳去，就率领他家里生养的精练壮丁三百一十八人，直追到但， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","便在夜间，自己同仆人分队杀败敌人，又追到大马士革左边的何把， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","将被掳掠的一切财物夺回来，连他侄儿罗得和他的财物，以及妇女、人民也都夺回来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","亚伯兰杀败基大老玛和与他同盟的王回来的时候，所多玛王出来，在沙微谷迎接他；沙微谷就是王谷。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","又有撒冷王麦基洗德带着饼和酒出来迎接；他是至高　神的祭司。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","他为亚伯兰祝福，说：「愿天地的主、至高的　神赐福与亚伯兰！ ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","至高的　神把敌人交在你手里，是应当称颂的！」亚伯兰就把所得的拿出十分之一来，给麦基洗德。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","所多玛王对亚伯兰说：「你把人口给我，财物你自己拿去吧！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","亚伯兰对所多玛王说：「我已经向天地的主—至高的　神耶和华起誓： ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","凡是你的东西，就是一根线、一根鞋带，我都不拿，免得你说：『我使亚伯兰富足！』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","只有仆人所吃的，并与我同行的亚乃、以实各、幔利所应得的分，可以任凭他们拿去。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","这事以后，耶和华在异象中有话对亚伯兰说：「亚伯兰，你不要惧怕！我是你的盾牌，必大大地赏赐你。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","亚伯兰说：「主耶和华啊，我既无子，你还赐我什么呢？并且要承受我家业的是大马士革人以利以谢。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","亚伯兰又说：「你没有给我儿子；那生在我家中的人就是我的后嗣。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","耶和华又有话对他说：「这人必不成为你的后嗣；你本身所生的才成为你的后嗣。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","于是领他走到外边，说：「你向天观看，数算众星，能数得过来吗？」又对他说：「你的后裔将要如此。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","亚伯兰信耶和华，耶和华就以此为他的义。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","耶和华又对他说：「我是耶和华，曾领你出了迦勒底的吾珥，为要将这地赐你为业。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","亚伯兰说：「主耶和华啊，我怎能知道必得这地为业呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","他说：「你为我取一只三年的母牛，一只三年的母山羊，一只三年的公绵羊，一只斑鸠，一只雏鸽。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","亚伯兰就取了这些来，每样劈开，分成两半，一半对着一半地摆列，只有鸟没有劈开。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","有鸷鸟下来，落在那死畜的肉上，亚伯兰就把它吓飞了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","日头正落的时候，亚伯兰沉沉地睡了；忽然有惊人的大黑暗落在他身上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","耶和华对亚伯兰说：「你要的确知道，你的后裔必寄居别人的地，又服事那地的人；那地的人要苦待他们四百年。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","并且他们所要服事的那国，我要惩罚，后来他们必带着许多财物从那里出来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","但你要享大寿数，平平安安地归到你列祖那里，被人埋葬。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","到了第四代，他们必回到此地，因为亚摩利人的罪孽还没有满盈。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","日落天黑，不料有冒烟的炉并烧着的火把从那些肉块中经过。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","当那日，耶和华与亚伯兰立约，说：「我已赐给你的后裔，从埃及河直到幼发拉底大河之地， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","就是基尼人、基尼洗人、甲摩尼人、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","赫人、比利洗人、利乏音人、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","亚摩利人、迦南人、革迦撒人、耶布斯人之地。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","亚伯兰的妻子撒莱不给他生儿女。撒莱有一个使女，名叫夏甲，是埃及人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","撒莱对亚伯兰说：「耶和华使我不能生育。求你和我的使女同房，或者我可以因她得孩子。」亚伯兰听从了撒莱的话。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","于是亚伯兰的妻子撒莱将使女埃及人夏甲给了丈夫为妾；那时亚伯兰在迦南已经住了十年。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","亚伯兰与夏甲同房，夏甲就怀了孕；她见自己有孕，就小看她的主母。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","撒莱对亚伯兰说：「我因你受屈。我将我的使女放在你怀中，她见自己有了孕，就小看我。愿耶和华在你我中间判断。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","亚伯兰对撒莱说：「使女在你手下，你可以随意待她。」撒莱苦待她，她就从撒莱面前逃走了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","耶和华的使者在旷野书珥路上的水泉旁遇见她， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","对她说：「撒莱的使女夏甲，你从哪里来？要往哪里去？」夏甲说：「我从我的主母撒莱面前逃出来。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","耶和华的使者对她说：「你回到你主母那里，服在她手下」； ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","又说：「我必使你的后裔极其繁多，甚至不可胜数」； ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","并说：「你如今怀孕要生一个儿子，可以给他起名叫以实玛利，因为耶和华听见了你的苦情。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","他为人必像野驴。他的手要攻打人，人的手也要攻打他；他必住在众弟兄的东边。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","夏甲就称那对她说话的耶和华为「看顾人的　神」。因而说：「在这里我也看见那看顾我的吗？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","所以这井名叫庇耳·拉海·莱。这井正在加低斯和巴列中间。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","后来夏甲给亚伯兰生了一个儿子；亚伯兰给他起名叫以实玛利。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","夏甲给亚伯兰生以实玛利的时候，亚伯兰年八十六岁。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","亚伯兰年九十九岁的时候，耶和华向他显现，对他说：「我是全能的　神。你当在我面前作完全人， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","我就与你立约，使你的后裔极其繁多。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","亚伯兰俯伏在地；　神又对他说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","「我与你立约：你要作多国的父。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","从此以后，你的名不再叫亚伯兰，要叫亚伯拉罕，因为我已立你作多国的父。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","我必使你的后裔极其繁多；国度从你而立，君王从你而出。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","我要与你并你世世代代的后裔坚立我的约，作永远的约，是要作你和你后裔的　神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","我要将你现在寄居的地，就是迦南全地，赐给你和你的后裔永远为业，我也必作他们的　神。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","神又对亚伯拉罕说：「你和你的后裔必世世代代遵守我的约。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","你们所有的男子都要受割礼；这就是我与你并你的后裔所立的约，是你们所当遵守的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","你们都要受割礼；这是我与你们立约的证据。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","你们世世代代的男子，无论是家里生的，是在你后裔之外用银子从外人买的，生下来第八日，都要受割礼。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","你家里生的和你用银子买的，都必须受割礼。这样，我的约就立在你们肉体上作永远的约。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","但不受割礼的男子必从民中剪除，因他背了我的约。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","神又对亚伯拉罕说：「你的妻子撒莱不可再叫撒莱，她的名要叫撒拉。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","我必赐福给她，也要使你从她得一个儿子。我要赐福给她，她也要作多国之母；必有百姓的君王从她而出。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","亚伯拉罕就俯伏在地喜笑，心里说：「一百岁的人还能得孩子吗？撒拉已经九十岁了，还能生养吗？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","亚伯拉罕对　神说：「但愿以实玛利活在你面前。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","神说：「不然，你妻子撒拉要给你生一个儿子，你要给他起名叫以撒。我要与他坚定所立的约，作他后裔永远的约。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","至于以实玛利，我也应允你：我必赐福给他，使他昌盛，极其繁多。他必生十二个族长；我也要使他成为大国。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","到明年这时节，撒拉必给你生以撒，我要与他坚定所立的约。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","神和亚伯拉罕说完了话，就离开他上升去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","正当那日，亚伯拉罕遵着　神的命，给他的儿子以实玛利和家里的一切男子，无论是在家里生的，是用银子买的，都行了割礼。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","亚伯拉罕受割礼的时候年九十九岁。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","他儿子以实玛利受割礼的时候年十三岁。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","正当那日，亚伯拉罕和他儿子以实玛利一同受了割礼。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","家里所有的人，无论是在家里生的，是用银子从外人买的，也都一同受了割礼。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","耶和华在幔利橡树那里向亚伯拉罕显现出来。那时正热，亚伯拉罕坐在帐棚门口， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","举目观看，见有三个人在对面站着。他一见，就从帐棚门口跑去迎接他们，俯伏在地， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","说：「我主，我若在你眼前蒙恩，求你不要离开仆人往前去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","容我拿点水来，你们洗洗脚，在树下歇息歇息。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","我再拿一点饼来，你们可以加添心力，然后往前去。你们既到仆人这里来，理当如此。」他们说：「就照你说的行吧。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","亚伯拉罕急忙进帐棚见撒拉，说：「你速速拿三细亚细面调和做饼。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","亚伯拉罕又跑到牛群里，牵了一只又嫩又好的牛犊来，交给仆人，仆人急忙预备好了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","亚伯拉罕又取了奶油和奶，并预备好的牛犊来，摆在他们面前，自己在树下站在旁边，他们就吃了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","他们问亚伯拉罕说：「你妻子撒拉在哪里？」他说：「在帐棚里。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","三人中有一位说：「到明年这时候，我必要回到你这里；你的妻子撒拉必生一个儿子。」撒拉在那人后边的帐棚门口也听见了这话。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","亚伯拉罕和撒拉年纪老迈，撒拉的月经已断绝了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","撒拉心里暗笑，说：「我既已衰败，我主也老迈，岂能有这喜事呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","耶和华对亚伯拉罕说：「撒拉为什么暗笑，说：『我既已年老，果真能生养吗？』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","耶和华岂有难成的事吗？到了日期，明年这时候，我必回到你这里，撒拉必生一个儿子。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","撒拉就害怕，不承认，说：「我没有笑。」那位说：「不然，你实在笑了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","三人就从那里起行，向所多玛观看，亚伯拉罕也与他们同行，要送他们一程。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","耶和华说：「我所要做的事岂可瞒着亚伯拉罕呢？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","亚伯拉罕必要成为强大的国；地上的万国都必因他得福。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","我眷顾他，为要叫他吩咐他的众子和他的眷属遵守我的道，秉公行义，使我所应许亚伯拉罕的话都成就了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","耶和华说：「所多玛和蛾摩拉的罪恶甚重，声闻于我。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","我现在要下去，察看他们所行的，果然尽像那达到我耳中的声音一样吗？若是不然，我也必知道。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","二人转身离开那里，向所多玛去；但亚伯拉罕仍旧站在耶和华面前。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","亚伯拉罕近前来，说：「无论善恶，你都要剿灭吗？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","假若那城里有五十个义人，你还剿灭那地方吗？不为城里这五十个义人饶恕其中的人吗？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","将义人与恶人同杀，将义人与恶人一样看待，这断不是你所行的。审判全地的主岂不行公义吗？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","耶和华说：「我若在所多玛城里见有五十个义人，我就为他们的缘故饶恕那地方的众人。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","亚伯拉罕说：「我虽然是灰尘，还敢对主说话。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","假若这五十个义人短了五个，你就因为短了五个毁灭全城吗？」他说：「我在那里若见有四十五个，也不毁灭那城。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","亚伯拉罕又对他说：「假若在那里见有四十个怎么样呢？」他说：「为这四十个的缘故，我也不做这事。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","亚伯拉罕说：「求主不要动怒，容我说，假若在那里见有三十个怎么样呢？」他说：「我在那里若见有三十个，我也不做这事。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","亚伯拉罕说：「我还敢对主说话，假若在那里见有二十个怎么样呢？」他说：「为这二十个的缘故，我也不毁灭那城。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","亚伯拉罕说：「求主不要动怒，我再说这一次，假若在那里见有十个呢？」他说：「为这十个的缘故，我也不毁灭那城。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","耶和华与亚伯拉罕说完了话就走了；亚伯拉罕也回到自己的地方去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","那两个天使晚上到了所多玛；罗得正坐在所多玛城门口，看见他们，就起来迎接，脸伏于地下拜， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","说：「我主啊，请你们到仆人家里洗洗脚，住一夜，清早起来再走。」他们说：「不！我们要在街上过夜。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","罗得切切地请他们，他们这才进去，到他屋里。罗得为他们预备筵席，烤无酵饼，他们就吃了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","他们还没有躺下，所多玛城里各处的人，连老带少，都来围住那房子， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","呼叫罗得说：「今日晚上到你这里来的人在哪里呢？把他们带出来，任我们所为。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","罗得出来，把门关上，到众人那里， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","说：「众弟兄，请你们不要做这恶事。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","我有两个女儿，还是处女，容我领出来，任凭你们的心愿而行；只是这两个人既然到我舍下，不要向他们做什么。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","众人说：「退去吧！」又说：「这个人来寄居，还想要作官哪！现在我们要害你比害他们更甚。」众人就向前拥挤罗得，要攻破房门。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","只是那二人伸出手来，将罗得拉进屋去，把门关上， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","并且使门外的人，无论老少，眼都昏迷；他们摸来摸去，总寻不着房门。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","二人对罗得说：「你这里还有什么人吗？无论是女婿是儿女，和这城中一切属你的人，你都要将他们从这地方带出去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","我们要毁灭这地方；因为城内罪恶的声音在耶和华面前甚大，耶和华差我们来，要毁灭这地方。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","罗得就出去，告诉娶了他女儿的女婿们说：「你们起来离开这地方，因为耶和华要毁灭这城。」他女婿们却以为他说的是戏言。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","天明了，天使催逼罗得说：「起来！带着你的妻子和你在这里的两个女儿出去，免得你因这城里的罪恶同被剿灭。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","但罗得迟延不走。二人因为耶和华怜恤罗得，就拉着他的手和他妻子的手，并他两个女儿的手，把他们领出来，安置在城外； ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","领他们出来以后，就说：「逃命吧！不可回头看，也不可在平原站住。要往山上逃跑，免得你被剿灭。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","罗得对他们说：「我主啊，不要如此！ ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","你仆人已经在你眼前蒙恩；你又向我显出莫大的慈爱，救我的性命。我不能逃到山上去，恐怕这灾祸临到我，我便死了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","看哪，这座城又小又近，容易逃到，这不是一个小的吗？求你容我逃到那里，我的性命就得存活。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","天使对他说：「这事我也应允你；我不倾覆你所说的这城。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","你要速速地逃到那城；因为你还没有到那里，我不能做什么。」因此那城名叫琐珥。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","罗得到了琐珥，日头已经出来了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","当时，耶和华将硫磺与火从天上耶和华那里降与所多玛和蛾摩拉， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","把那些城和全平原，并城里所有的居民，连地上生长的，都毁灭了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","罗得的妻子在后边回头一看，就变成了一根盐柱。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","亚伯拉罕清早起来，到了他从前站在耶和华面前的地方， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","向所多玛和蛾摩拉与平原的全地观看，不料，那地方烟气上腾，如同烧窑一般。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","当　神毁灭平原诸城的时候，他记念亚伯拉罕，正在倾覆罗得所住之城的时候，就打发罗得从倾覆之中出来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","罗得因为怕住在琐珥，就同他两个女儿从琐珥上去，住在山里；他和两个女儿住在一个洞里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","大女儿对小女儿说：「我们的父亲老了，地上又无人按着世上的常规进到我们这里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","来！我们可以叫父亲喝酒，与他同寝。这样，我们好从他存留后裔。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","于是，那夜她们叫父亲喝酒，大女儿就进去和她父亲同寝；她几时躺下，几时起来，父亲都不知道。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","第二天，大女儿对小女儿说：「我昨夜与父亲同寝。今夜我们再叫他喝酒，你可以进去与他同寝。这样，我们好从父亲存留后裔。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","于是，那夜她们又叫父亲喝酒，小女儿起来与她父亲同寝；她几时躺下，几时起来，父亲都不知道。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","这样，罗得的两个女儿都从她父亲怀了孕。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","大女儿生了儿子，给他起名叫摩押，就是现今摩押人的始祖。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","小女儿也生了儿子，给他起名叫便·亚米，就是现今亚扪人的始祖。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","亚伯拉罕从那里向南地迁去，寄居在加低斯和书珥中间的基拉耳。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","亚伯拉罕称他的妻撒拉为妹子，基拉耳王亚比米勒差人把撒拉取了去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","但夜间，　神来，在梦中对亚比米勒说：「你是个死人哪！因为你取了那女人来；她原是别人的妻子。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","亚比米勒却还没有亲近撒拉；他说：「主啊，连有义的国，你也要毁灭吗？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","那人岂不是自己对我说『她是我的妹子』吗？就是女人也自己说：『他是我的哥哥。』我做这事是心正手洁的。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","神在梦中对他说：「我知道你做这事是心中正直；我也拦阻了你，免得你得罪我，所以我不容你沾着她。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","现在你把这人的妻子归还他；因为他是先知，他要为你祷告，使你存活。你若不归还他，你当知道，你和你所有的人都必要死。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","亚比米勒清早起来，召了众臣仆来，将这些事都说给他们听，他们都甚惧怕。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","亚比米勒召了亚伯拉罕来，对他说：「你怎么向我这样行呢？我在什么事上得罪了你，你竟使我和我国里的人陷在大罪里？你向我行不当行的事了！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","亚比米勒又对亚伯拉罕说：「你见了什么才做这事呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","亚伯拉罕说：「我以为这地方的人总不惧怕　神，必为我妻子的缘故杀我。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","况且她也实在是我的妹子；她与我是同父异母，后来作了我的妻子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","当　神叫我离开父家、飘流在外的时候，我对她说：『我们无论走到什么地方，你可以对人说：他是我的哥哥；这就是你待我的恩典了。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","亚比米勒把牛、羊、仆婢赐给亚伯拉罕，又把他的妻子撒拉归还他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","亚比米勒又说：「看哪，我的地都在你面前，你可以随意居住」； ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","又对撒拉说：「我给你哥哥一千银子，作为你在合家人面前遮羞的，你就在众人面前没有不是了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","亚伯拉罕祷告　神，　神就医好了亚比米勒和他的妻子，并他的众女仆，她们便能生育。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","因耶和华为亚伯拉罕的妻子撒拉的缘故，已经使亚比米勒家中的妇人不能生育。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","耶和华按着先前的话眷顾撒拉，便照他所说的给撒拉成就。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","当亚伯拉罕年老的时候，撒拉怀了孕；到　神所说的日期，就给亚伯拉罕生了一个儿子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","亚伯拉罕给撒拉所生的儿子起名叫以撒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","以撒生下来第八日，亚伯拉罕照着　神所吩咐的，给以撒行了割礼。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","他儿子以撒生的时候，亚伯拉罕年一百岁。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","撒拉说：「　神使我喜笑，凡听见的必与我一同喜笑」； ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","又说：「谁能预先对亚伯拉罕说『撒拉要乳养婴孩』呢？因为在他年老的时候，我给他生了一个儿子。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","孩子渐长，就断了奶。以撒断奶的日子，亚伯拉罕设摆丰盛的筵席。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","当时，撒拉看见埃及人夏甲给亚伯拉罕所生的儿子戏笑， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","就对亚伯拉罕说：「你把这使女和她儿子赶出去！因为这使女的儿子不可与我的儿子以撒一同承受产业。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","亚伯拉罕因他儿子的缘故很忧愁。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","神对亚伯拉罕说：「你不必为这童子和你的使女忧愁。凡撒拉对你说的话，你都该听从；因为从以撒生的，才要称为你的后裔。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","至于使女的儿子，我也必使他的后裔成立一国，因为他是你所生的。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","亚伯拉罕清早起来，拿饼和一皮袋水，给了夏甲，搭在她的肩上，又把孩子交给她，打发她走。夏甲就走了，在别是巴的旷野走迷了路。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","皮袋的水用尽了，夏甲就把孩子撇在小树底下， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","自己走开约有一箭之远，相对而坐，说：「我不忍见孩子死」，就相对而坐，放声大哭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","神听见童子的声音；　神的使者从天上呼叫夏甲说：「夏甲，你为何这样呢？不要害怕，　神已经听见童子的声音了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","起来！把童子抱在怀中，我必使他的后裔成为大国。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","神使夏甲的眼睛明亮，她就看见一口水井，便去将皮袋盛满了水，给童子喝。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","神保佑童子，他就渐长，住在旷野，成了弓箭手。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","他住在巴兰的旷野；他母亲从埃及地给他娶了一个妻子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","当那时候，亚比米勒同他军长非各对亚伯拉罕说：「凡你所行的事都有　神的保佑。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","我愿你如今在这里指着　神对我起誓，不要欺负我与我的儿子，并我的子孙。我怎样厚待了你，你也要照样厚待我与你所寄居这地的民。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","亚伯拉罕说：「我情愿起誓。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","从前，亚比米勒的仆人霸占了一口水井，亚伯拉罕为这事指责亚比米勒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","亚比米勒说：「谁做这事，我不知道，你也没有告诉我，今日我才听见了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","亚伯拉罕把羊和牛给了亚比米勒，二人就彼此立约。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","亚伯拉罕把七只母羊羔另放在一处。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","亚比米勒问亚伯拉罕说：「你把这七只母羊羔另放在一处，是什么意思呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","他说：「你要从我手里受这七只母羊羔，作我挖这口井的证据。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","所以他给那地方起名叫别是巴，因为他们二人在那里起了誓。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","他们在别是巴立了约，亚比米勒就同他军长非各起身回非利士地去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","亚伯拉罕在别是巴栽上一棵垂丝柳树，又在那里求告耶和华—永生　神的名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","亚伯拉罕在非利士人的地寄居了多日。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","这些事以后，　神要试验亚伯拉罕，就呼叫他说：「亚伯拉罕！」他说：「我在这里。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","神说：「你带着你的儿子，就是你独生的儿子，你所爱的以撒，往摩利亚地去，在我所要指示你的山上，把他献为燔祭。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","亚伯拉罕清早起来，备上驴，带着两个仆人和他儿子以撒，也劈好了燔祭的柴，就起身往　神所指示他的地方去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","到了第三日，亚伯拉罕举目远远地看见那地方。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","亚伯拉罕对他的仆人说：「你们和驴在此等候，我与童子往那里去拜一拜，就回到你们这里来。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","亚伯拉罕把燔祭的柴放在他儿子以撒身上，自己手里拿着火与刀；于是二人同行。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","以撒对他父亲亚伯拉罕说：「父亲哪！」亚伯拉罕说：「我儿，我在这里。」以撒说：「请看，火与柴都有了，但燔祭的羊羔在哪里呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","亚伯拉罕说：「我儿，　神必自己预备作燔祭的羊羔。」于是二人同行。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","他们到了　神所指示的地方，亚伯拉罕在那里筑坛，把柴摆好，捆绑他的儿子以撒，放在坛的柴上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","亚伯拉罕就伸手拿刀，要杀他的儿子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","耶和华的使者从天上呼叫他说：「亚伯拉罕！亚伯拉罕！」他说：「我在这里。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","天使说：「你不可在这童子身上下手。一点不可害他！现在我知道你是敬畏　神的了；因为你没有将你的儿子，就是你独生的儿子，留下不给我。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","亚伯拉罕举目观看，不料，有一只公羊，两角扣在稠密的小树中，亚伯拉罕就取了那只公羊来，献为燔祭，代替他的儿子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","亚伯拉罕给那地方起名叫「耶和华以勒」，直到今日人还说：「在耶和华的山上必有预备。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","耶和华的使者第二次从天上呼叫亚伯拉罕说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","「耶和华说：『你既行了这事，不留下你的儿子，就是你独生的儿子，我便指着自己起誓说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","论福，我必赐大福给你；论子孙，我必叫你的子孙多起来，如同天上的星，海边的沙。你子孙必得着仇敌的城门， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","并且地上万国都必因你的后裔得福，因为你听从了我的话。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","于是亚伯拉罕回到他仆人那里，他们一同起身往别是巴去，亚伯拉罕就住在别是巴。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","这事以后，有人告诉亚伯拉罕说：「密迦给你兄弟拿鹤生了几个儿子， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","长子是乌斯，他的兄弟是布斯和亚兰的父亲基母利， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","并基薛、哈琐、必达、益拉、彼土利（彼土利生利百加）。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","这八个人都是密迦给亚伯拉罕的兄弟拿鹤生的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","拿鹤的妾名叫流玛，生了提八、迦含、他辖，和玛迦。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","撒拉享寿一百二十七岁，这是撒拉一生的岁数。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","撒拉死在迦南地的基列·亚巴，就是希伯 。亚伯拉罕为她哀恸哭号。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","后来亚伯拉罕从死人面前起来，对赫人说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","「我在你们中间是外人，是寄居的。求你们在这里给我一块地，我好埋葬我的死人，使她不在我眼前。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","赫人回答亚伯拉罕说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","「我主请听。你在我们中间是一位尊大的王子，只管在我们最好的坟地里埋葬你的死人；我们没有一人不容你在他的坟地里埋葬你的死人。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","亚伯拉罕就起来，向那地的赫人下拜， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","对他们说：「你们若有意叫我埋葬我的死人，使她不在我眼前，就请听我的话，为我求琐辖的儿子以弗 ； ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","把田头上那麦比拉洞给我；他可以按着足价卖给我，作我在你们中间的坟地。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","当时以弗 正坐在赫人中间。于是，赫人以弗 在城门出入的赫人面前对亚伯拉罕说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","「不然，我主请听。我送给你这块田，连田间的洞也送给你，在我同族的人面前都给你，可以埋葬你的死人。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","亚伯拉罕就在那地的人民面前下拜， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","在他们面前对以弗 说：「你若应允，请听我的话。我要把田价给你，求你收下，我就在那里埋葬我的死人。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","以弗 回答亚伯拉罕说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","「我主请听。值四百舍客勒银子的一块田，在你我中间还算什么呢？只管埋葬你的死人吧！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","亚伯拉罕听从了以弗 ，照着他在赫人面前所说的话，把买卖通用的银子平了四百舍客勒给以弗 。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","于是，麦比拉、幔利前、以弗 的那块田和其中的洞，并田间四围的树木， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","都定准归与亚伯拉罕，乃是他在赫人面前并城门出入的人面前买妥的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","此后，亚伯拉罕把他妻子撒拉埋葬在迦南地幔利前的麦比拉田间的洞里。（幔利就是希伯 ）。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","从此，那块田和田间的洞就借着赫人定准归与亚伯拉罕作坟地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","亚伯拉罕年纪老迈，向来在一切事上耶和华都赐福给他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","亚伯拉罕对管理他全业最老的仆人说：「请你把手放在我大腿底下。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","我要叫你指着耶和华—天地的主起誓，不要为我儿子娶这迦南地中的女子为妻。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","你要往我本地本族去，为我的儿子以撒娶一个妻子。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","仆人对他说：「倘若女子不肯跟我到这地方来，我必须将你的儿子带回你原出之地吗？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","亚伯拉罕对他说：「你要谨慎，不要带我的儿子回那里去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","耶和华—天上的主曾带领我离开父家和本族的地，对我说话，向我起誓说：『我要将这地赐给你的后裔。』他必差遣使者在你面前，你就可以从那里为我儿子娶一个妻子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","倘若女子不肯跟你来，我使你起的誓就与你无干了，只是不可带我的儿子回那里去。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","仆人就把手放在他主人亚伯拉罕的大腿底下，为这事向他起誓。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","那仆人从他主人的骆驼里取了十匹骆驼，并带些他主人各样的财物，起身往美索不达米亚去，到了拿鹤的城。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","天将晚，众女子出来打水的时候，他便叫骆驼跪在城外的水井那里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","他说：「耶和华—我主人亚伯拉罕的　神啊，求你施恩给我主人亚伯拉罕，使我今日遇见好机会。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","我现今站在井旁，城内居民的女子们正出来打水。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","我向那一个女子说：『请你拿下水瓶来，给我水喝』，她若说：『请喝！我也给你的骆驼喝。』愿那女子就作你所预定给你仆人以撒的妻。这样，我便知道你施恩给我主人了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","话还没有说完，不料，利百加肩头上扛着水瓶出来。利百加是彼土利所生的；彼土利是亚伯拉罕兄弟拿鹤妻子密迦的儿子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","那女子容貌极其俊美，还是处女，也未曾有人亲近她。她下到井旁，打满了瓶，又上来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","仆人跑上前去迎着她，说：「求你将瓶里的水给我一点喝。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","女子说：「我主请喝！」就急忙拿下瓶来，托在手上给他喝。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","女子给他喝了，就说：「我再为你的骆驼打水，叫骆驼也喝足。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","她就急忙把瓶里的水倒在槽里，又跑到井旁打水，就为所有的骆驼打上水来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","那人定睛看她，一句话也不说，要晓得耶和华赐他通达的道路没有。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","骆驼喝足了，那人就拿一个金环，重半舍客勒，两个金镯，重十舍客勒，给了那女子， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","说：「请告诉我，你是谁的女儿？你父亲家里有我们住宿的地方没有？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","女子说：「我是密迦与拿鹤之子彼土利的女儿」； ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","又说：「我们家里足有粮草，也有住宿的地方。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","那人就低头向耶和华下拜， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","说：「耶和华—我主人亚伯拉罕的　神是应当称颂的，因他不断地以慈爱诚实待我主人。至于我，耶和华在路上引领我，直走到我主人的兄弟家里。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","女子跑回去，照着这些话告诉她母亲和她家里的人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","利百加有一个哥哥，名叫拉班，看见金环，又看见金镯在他妹子的手上，并听见他妹子利百加的话，说那人对我如此如此说。拉班就跑出来往井旁去，到那人跟前，见他仍站在骆驼旁边的井旁那里， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","便对他说：「你这蒙耶和华赐福的，请进来，为什么站在外边？我已经收拾了房屋，也为骆驼预备了地方。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","那人就进了拉班的家。拉班卸了骆驼，用草料喂上，拿水给那人和跟随的人洗脚； ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","把饭摆在他面前，叫他吃，他却说：「我不吃，等我说明白我的事情再吃。」拉班说：「请说。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","他说：「我是亚伯拉罕的仆人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","耶和华大大地赐福给我主人，使他昌大，又赐给他羊群、牛群、金银、仆婢、骆驼，和驴。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","我主人的妻子撒拉年老的时候给我主人生了一个儿子；我主人也将一切所有的都给了这个儿子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","我主人叫我起誓说：『你不要为我儿子娶迦南地的女子为妻。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","你要往我父家、我本族那里去，为我的儿子娶一个妻子。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","我对我主人说：『恐怕女子不肯跟我来。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","他就说：『我所事奉的耶和华必要差遣他的使者与你同去，叫你的道路通达，你就得以在我父家、我本族那里，给我的儿子娶一个妻子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","只要你到了我本族那里，我使你起的誓就与你无干。他们若不把女子交给你，我使你起的誓也与你无干。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","「我今日到了井旁，便说：『耶和华—我主人亚伯拉罕的　神啊，愿你叫我所行的道路通达。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","我如今站在井旁，对哪一个出来打水的女子说：请你把你瓶里的水给我一点喝； ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","她若说：你只管喝，我也为你的骆驼打水；愿那女子就作耶和华给我主人儿子所预定的妻。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","我心里的话还没有说完，利百加就出来，肩头上扛着水瓶，下到井旁打水。我便对她说：『请你给我水喝。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","她就急忙从肩头上拿下瓶来，说：『请喝！我也给你的骆驼喝。』我便喝了；她又给我的骆驼喝了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","我问她说：『你是谁的女儿？』她说：『我是密迦与拿鹤之子彼土利的女儿。』我就把环子戴在她鼻子上，把镯子戴在她两手上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","随后我低头向耶和华下拜，称颂耶和华—我主人亚伯拉罕的　神；因为他引导我走合式的道路，使我得着我主人兄弟的孙女，给我主人的儿子为妻。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","现在你们若愿以慈爱诚实待我主人，就告诉我；若不然，也告诉我，使我可以或向左，或向右。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","拉班和彼土利回答说：「这事乃出于耶和华，我们不能向你说好说歹。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","看哪，利百加在你面前，可以将她带去，照着耶和华所说的，给你主人的儿子为妻。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","亚伯拉罕的仆人听见他们这话，就向耶和华俯伏在地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","当下仆人拿出金器、银器，和衣服送给利百加，又将宝物送给她哥哥和她母亲。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","仆人和跟从他的人吃了喝了，住了一夜。早晨起来，仆人就说：「请打发我回我主人那里去吧。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","利百加的哥哥和她母亲说：「让女子同我们再住几天，至少十天，然后她可以去。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","仆人说：「耶和华既赐给我通达的道路，你们不要耽误我，请打发我走，回我主人那里去吧。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","他们说：「我们把女子叫来问问她」， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","就叫了利百加来，问她说：「你和这人同去吗？」利百加说：「我去。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","于是他们打发妹子利百加和她的乳母，同亚伯拉罕的仆人，并跟从仆人的，都走了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","他们就给利百加祝福说： 我们的妹子啊，愿你作千万人的母！ 愿你的后裔得着仇敌的城门！ ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","利百加和她的使女们起来，骑上骆驼，跟着那仆人，仆人就带着利百加走了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","那时，以撒住在南地，刚从庇耳·拉海·莱回来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","天将晚，以撒出来在田间默想，举目一看，见来了些骆驼。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","利百加举目看见以撒，就急忙下了骆驼， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","问那仆人说：「这田间走来迎接我们的是谁？」仆人说：「是我的主人。」利百加就拿帕子蒙上脸。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","仆人就将所办的一切事都告诉以撒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","以撒便领利百加进了他母亲撒拉的帐棚，娶了她为妻，并且爱她。以撒自从他母亲不在了，这才得了安慰。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","亚伯拉罕又娶了一妻，名叫基土拉。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","基土拉给他生了心兰、约珊、米但、米甸、伊施巴，和书亚。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","约珊生了示巴和底但。底但的子孙是亚书利族、利都是族，和利乌米族。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","米甸的儿子是以法、以弗、哈诺、亚比大，和以勒大。这都是基土拉的子孙。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","亚伯拉罕将一切所有的都给了以撒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","亚伯拉罕把财物分给他庶出的众子，趁着自己还在世的时候打发他们离开他的儿子以撒，往东方去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","亚伯拉罕一生的年日是一百七十五岁。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","亚伯拉罕寿高年迈，气绝而死，归到他列祖那里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","他两个儿子以撒、以实玛利把他埋葬在麦比拉洞里。这洞在幔利前、赫人琐辖的儿子以弗 的田中， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","就是亚伯拉罕向赫人买的那块田。亚伯拉罕和他妻子撒拉都葬在那里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","亚伯拉罕死了以后，　神赐福给他的儿子以撒。以撒靠近庇耳·拉海·莱居住。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","撒拉的使女埃及人夏甲给亚伯拉罕所生的儿子是以实玛利。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","以实玛利儿子们的名字，按着他们的家谱记在下面。以实玛利的长子是尼拜约，又有基达、亚德别、米比衫、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","米施玛、度玛、玛撒、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","哈大、提玛、伊突、拿非施、基底玛。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","这是以实玛利众子的名字，照着他们的村庄、营寨，作了十二族的族长。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","以实玛利享寿一百三十七岁，气绝而死，归到他列祖那里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","他子孙的住处在他众弟兄东边，从哈腓拉直到埃及前的书珥，正在亚述的道上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","亚伯拉罕的儿子以撒的后代记在下面。亚伯拉罕生以撒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","以撒娶利百加为妻的时候正四十岁。利百加是巴旦·亚兰地的亚兰人彼土利的女儿，是亚兰人拉班的妹子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","以撒因他妻子不生育，就为她祈求耶和华；耶和华应允他的祈求，他的妻子利百加就怀了孕。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","孩子们在她腹中彼此相争，她就说：「若是这样，我为什么活着呢？」她就去求问耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","耶和华对她说： 两国在你腹内； 两族要从你身上出来。 这族必强于那族； 将来大的要服事小的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","生产的日子到了，腹中果然是双子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","先产的身体发红，浑身有毛，如同皮衣，他们就给他起名叫以扫。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","随后又生了以扫的兄弟，手抓住以扫的脚跟，因此给他起名叫雅各。利百加生下两个儿子的时候，以撒年正六十岁。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","两个孩子渐渐长大，以扫善于打猎，常在田野；雅各为人安静，常住在帐棚里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","以撒爱以扫，因为常吃他的野味；利百加却爱雅各。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","有一天，雅各熬汤，以扫从田野回来累昏了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","以扫对雅各说：「我累昏了，求你把这红汤给我喝。」因此以扫又叫以东。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","雅各说：「你今日把长子的名分卖给我吧。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","以扫说：「我将要死，这长子的名分于我有什么益处呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","雅各说：「你今日对我起誓吧。」以扫就对他起了誓，把长子的名分卖给雅各。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","于是雅各将饼和红豆汤给了以扫，以扫吃了喝了，便起来走了。这就是以扫轻看了他长子的名分。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","在亚伯拉罕的日子，那地有一次饥荒；这时又有饥荒，以撒就往基拉耳去，到非利士人的王亚比米勒那里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","耶和华向以撒显现，说：「你不要下埃及去，要住在我所指示你的地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","你寄居在这地，我必与你同在，赐福给你，因为我要将这些地都赐给你和你的后裔。我必坚定我向你父亚伯拉罕所起的誓。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","我要加增你的后裔，像天上的星那样多，又要将这些地都赐给你的后裔。并且地上万国必因你的后裔得福— ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","都因亚伯拉罕听从我的话，遵守我的吩咐和我的命令、律例、法度。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","以撒就住在基拉耳。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","那地方的人问到他的妻子，他便说：「那是我的妹子。」原来他怕说：「是我的妻子」；他心里想：「恐怕这地方的人为利百加的缘故杀我」，因为她容貌俊美。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","他在那里住了许久。有一天，非利士人的王亚比米勒从窗户里往外观看，见以撒和他的妻子利百加戏玩。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","亚比米勒召了以撒来，对他说：「她实在是你的妻子，你怎么说她是你的妹子？」以撒说：「我心里想，恐怕我因她而死。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","亚比米勒说：「你向我们做的是什么事呢？民中险些有人和你的妻同寝，把我们陷在罪里。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","于是亚比米勒晓谕众民说：「凡沾着这个人，或是他妻子的，定要把他治死。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","以撒在那地耕种，那一年有百倍的收成。耶和华赐福给他， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","他就昌大，日增月盛，成了大富户。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","他有羊群牛群，又有许多仆人，非利士人就嫉妒他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","当他父亲亚伯拉罕在世的日子，他父亲的仆人所挖的井，非利士人全都塞住，填满了土。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","亚比米勒对以撒说：「你离开我们去吧。因为你比我们强盛得多。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","以撒就离开那里，在基拉耳谷支搭帐棚，住在那里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","当他父亲亚伯拉罕在世之日所挖的水井因非利士人在亚伯拉罕死后塞住了，以撒就重新挖出来，仍照他父亲所叫的叫那些井的名字。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","以撒的仆人在谷中挖井，便得了一口活水井。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","基拉耳的牧人与以撒的牧人争竞，说：「这水是我们的。」以撒就给那井起名叫埃色，因为他们和他相争。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","以撒的仆人又挖了一口井，他们又为这井争竞，因此以撒给这井起名叫西提拿。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","以撒离开那里，又挖了一口井，他们不为这井争竞了，他就给那井起名叫利河伯。他说：「耶和华现在给我们宽阔之地，我们必在这地昌盛。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","以撒从那里上别是巴去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","当夜耶和华向他显现，说：「我是你父亲亚伯拉罕的　神，不要惧怕！因为我与你同在，要赐福给你，并要为我仆人亚伯拉罕的缘故，使你的后裔繁多。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","以撒就在那里筑了一座坛，求告耶和华的名，并且支搭帐棚；他的仆人便在那里挖了一口井。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","亚比米勒，同他的朋友亚户撒和他的军长非各，从基拉耳来见以撒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","以撒对他们说：「你们既然恨我，打发我走了，为什么到我这里来呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","他们说：「我们明明地看见耶和华与你同在，便说，不如我们两下彼此起誓，彼此立约， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","使你不害我们，正如我们未曾害你，一味地厚待你，并且打发你平平安安地走。你是蒙耶和华赐福的了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","以撒就为他们设摆筵席，他们便吃了喝了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","他们清早起来彼此起誓。以撒打发他们走，他们就平平安安地离开他走了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","那一天，以撒的仆人来，将挖井的事告诉他说：「我们得了水了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","他就给那井起名叫示巴；因此那城叫做别是巴，直到今日。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","以扫四十岁的时候娶了赫人比利的女儿犹滴，与赫人以伦的女儿巴实抹为妻。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","她们常使以撒和利百加心里愁烦。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","以撒年老，眼睛昏花，不能看见，就叫了他大儿子以扫来，说：「我儿。」以扫说：「我在这里。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","他说：「我如今老了，不知道哪一天死。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","现在拿你的器械，就是箭囊和弓，往田野去为我打猎， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","照我所爱的做成美味，拿来给我吃，使我在未死之先给你祝福。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","以撒对他儿子以扫说话，利百加也听见了。以扫往田野去打猎，要得野味带来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","利百加就对她儿子雅各说：「我听见你父亲对你哥哥以扫说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","『你去把野兽带来，做成美味给我吃，我好在未死之先，在耶和华面前给你祝福。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","现在，我儿，你要照着我所吩咐你的，听从我的话。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","你到羊群里去，给我拿两只肥山羊羔来，我便照你父亲所爱的给他做成美味。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","你拿到你父亲那里给他吃，使他在未死之先给你祝福。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","雅各对他母亲利百加说：「我哥哥以扫浑身是有毛的，我身上是光滑的； ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","倘若我父亲摸着我，必以我为欺哄人的，我就招咒诅，不得祝福。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","他母亲对他说：「我儿，你招的咒诅归到我身上；你只管听我的话，去把羊羔给我拿来。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","他便去拿来，交给他母亲；他母亲就照他父亲所爱的做成美味。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","利百加又把家里所存大儿子以扫上好的衣服给她小儿子雅各穿上， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","又用山羊羔皮包在雅各的手上和颈项的光滑处， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","就把所做的美味和饼交在她儿子雅各的手里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","雅各到他父亲那里说：「我父亲！」他说：「我在这里。我儿，你是谁？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","雅各对他父亲说：「我是你的长子以扫；我已照你所吩咐我的行了。请起来坐着，吃我的野味，好给我祝福。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","以撒对他儿子说：「我儿，你如何找得这么快呢？」他说：「因为耶和华—你的　神使我遇见好机会得着的。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","以撒对雅各说：「我儿，你近前来，我摸摸你，知道你真是我的儿子以扫不是。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","雅各就挨近他父亲以撒。以撒摸着他，说：「声音是雅各的声音，手却是以扫的手。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","以撒就辨不出他来；因为他手上有毛，像他哥哥以扫的手一样，就给他祝福； ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","又说：「你真是我儿子以扫吗？」他说：「我是。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","以撒说：「你递给我，我好吃我儿子的野味，给你祝福。」雅各就递给他，他便吃了，又拿酒给他，他也喝了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","他父亲以撒对他说：「我儿，你上前来与我亲嘴。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","他就上前与父亲亲嘴。他父亲一闻他衣服上的香气，就给他祝福，说： 我儿的香气 如同耶和华赐福之田地的香气一样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","愿　神赐你天上的甘露， 地上的肥土， 并许多五谷新酒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","愿多民事奉你， 多国跪拜你。 愿你作你弟兄的主； 你母亲的儿子向你跪拜。 凡咒诅你的，愿他受咒诅； 为你祝福的，愿他蒙福。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","以撒为雅各祝福已毕，雅各从他父亲那里才出来，他哥哥以扫正打猎回来， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","也做了美味，拿来给他父亲，说：「请父亲起来，吃你儿子的野味，好给我祝福。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","他父亲以撒对他说：「你是谁？」他说：「我是你的长子以扫。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","以撒就大大地战兢，说：「你未来之先，是谁得了野味拿来给我呢？我已经吃了，为他祝福；他将来也必蒙福。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","以扫听了他父亲的话，就放声痛哭，说：「我父啊，求你也为我祝福！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","以撒说：「你兄弟已经用诡计来将你的福分夺去了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","以扫说：「他名雅各，岂不是正对吗？因为他欺骗了我两次：他从前夺了我长子的名分，你看，他现在又夺了我的福分。」以扫又说：「你没有留下为我可祝的福吗？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","以撒回答以扫说：「我已立他为你的主，使他的弟兄都给他作仆人，并赐他五谷新酒可以养生。我儿，现在我还能为你做什么呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","以扫对他父亲说：「父啊，你只有一样可祝的福吗？我父啊，求你也为我祝福！」以扫就放声而哭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","他父亲以撒说： 地上的肥土必为你所住； 天上的甘露必为你所得。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","你必倚靠刀剑度日， 又必事奉你的兄弟； 到你强盛的时候， 必从你颈项上挣开他的轭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","以扫因他父亲给雅各祝的福，就怨恨雅各，心里说：「为我父亲居丧的日子近了，到那时候，我要杀我的兄弟雅各。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","有人把利百加大儿子以扫的话告诉利百加，她就打发人去，叫了她小儿子雅各来，对他说：「你哥哥以扫想要杀你，报仇雪恨。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","现在，我儿，你要听我的话：起来，逃往哈兰、我哥哥拉班那里去， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","同他住些日子，直等你哥哥的怒气消了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","你哥哥向你消了怒气，忘了你向他所做的事，我便打发人去把你从那里带回来。为什么一日丧你们二人呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","利百加对以撒说：「我因这赫人的女子连性命都厌烦了；倘若雅各也娶赫人的女子为妻，像这些一样，我活着还有什么益处呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","以撒叫了雅各来，给他祝福，并嘱咐他说：「你不要娶迦南的女子为妻。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","你起身往巴旦·亚兰去，到你外祖彼土利家里，在你母舅拉班的女儿中娶一女为妻。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","愿全能的　神赐福给你，使你生养众多，成为多族， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","将应许亚伯拉罕的福赐给你和你的后裔，使你承受你所寄居的地为业，就是　神赐给亚伯拉罕的地。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","以撒打发雅各走了，他就往巴旦·亚兰去，到亚兰人彼土利的儿子拉班那里。拉班是雅各、以扫的母舅。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","以扫见以撒已经给雅各祝福，而且打发他往巴旦·亚兰去，在那里娶妻，并见祝福的时候嘱咐他说：「不要娶迦南的女子为妻」， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","又见雅各听从父母的话往巴旦·亚兰去了， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","以扫就晓得他父亲以撒看不中迦南的女子， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","便往以实玛利那里去，在他二妻之外又娶了玛哈拉为妻。她是亚伯拉罕儿子以实玛利的女儿，尼拜约的妹子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","雅各出了别是巴，向哈兰走去； ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","到了一个地方，因为太阳落了，就在那里住宿，便拾起那地方的一块石头枕在头下，在那里躺卧睡了， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","梦见一个梯子立在地上，梯子的头顶着天，有　神的使者在梯子上，上去下来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","耶和华站在梯子以上，说：「我是耶和华—你祖亚伯拉罕的　神，也是以撒的　神；我要将你现在所躺卧之地赐给你和你的后裔。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","你的后裔必像地上的尘沙那样多，必向东西南北开展；地上万族必因你和你的后裔得福。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","我也与你同在。你无论往哪里去，我必保佑你，领你归回这地，总不离弃你，直到我成全了向你所应许的。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","雅各睡醒了，说：「耶和华真在这里，我竟不知道！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","就惧怕，说：「这地方何等可畏！这不是别的，乃是　神的殿，也是天的门。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","雅各清早起来，把所枕的石头立作柱子，浇油在上面。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","他就给那地方起名叫伯特利；但那地方起先名叫路斯。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","雅各许愿说：「　神若与我同在，在我所行的路上保佑我，又给我食物吃，衣服穿， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","使我平平安安地回到我父亲的家，我就必以耶和华为我的　神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","我所立为柱子的石头也必作　神的殿；凡你所赐给我的，我必将十分之一献给你。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","雅各起行，到了东方人之地， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","看见田间有一口井，有三群羊卧在井旁；因为人饮羊群都是用那井里的水。井口上的石头是大的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","常有羊群在那里聚集，牧人把石头转离井口饮羊，随后又把石头放在井口的原处。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","雅各对牧人说：「弟兄们，你们是哪里来的？」他们说：「我们是哈兰来的。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","他问他们说：「拿鹤的孙子拉班，你们认识吗？」他们说：「我们认识。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","雅各说：「他平安吗？」他们说：「平安。看哪，他女儿拉结领着羊来了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","雅各说：「日头还高，不是羊群聚集的时候，你们不如饮羊，再去放一放。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","他们说：「我们不能，必等羊群聚齐，人把石头转离井口才可饮羊。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","雅各正和他们说话的时候，拉结领着她父亲的羊来了，因为那些羊是她牧放的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","雅各看见母舅拉班的女儿拉结和母舅拉班的羊群，就上前把石头转离井口，饮他母舅拉班的羊群。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","雅各与拉结亲嘴，就放声而哭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","雅各告诉拉结，自己是她父亲的外甥，是利百加的儿子，拉结就跑去告诉她父亲。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","拉班听见外甥雅各的信息，就跑去迎接，抱着他，与他亲嘴，领他到自己的家。雅各将一切的情由告诉拉班。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","拉班对他说：「你实在是我的骨肉。」雅各就和他同住了一个月。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","拉班对雅各说：「你虽是我的骨肉，岂可白白地服事我？请告诉我，你要什么为工价？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","拉班有两个女儿，大的名叫利亚，小的名叫拉结。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","利亚的眼睛没有神气，拉结却生得美貌俊秀。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","雅各爱拉结，就说：「我愿为你小女儿拉结服事你七年。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","拉班说：「我把她给你，胜似给别人，你与我同住吧！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","雅各就为拉结服事了七年；他因为深爱拉结，就看这七年如同几天。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","雅各对拉班说：「日期已经满了，求你把我的妻子给我，我好与她同房。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","拉班就摆设筵席，请齐了那地方的众人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","到晚上，拉班将女儿利亚送来给雅各，雅各就与她同房。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","拉班又将婢女悉帕给女儿利亚作使女。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","到了早晨，雅各一看是利亚，就对拉班说：「你向我做的是什么事呢？我服事你，不是为拉结吗？你为什么欺哄我呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","拉班说：「大女儿还没有给人，先把小女儿给人，在我们这地方没有这规矩。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","你为这个满了七日，我就把那个也给你，你再为她服事我七年。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","雅各就如此行。满了利亚的七日，拉班便将女儿拉结给雅各为妻。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","拉班又将婢女辟拉给女儿拉结作使女。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","雅各也与拉结同房，并且爱拉结胜似爱利亚，于是又服事了拉班七年。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","耶和华见利亚失宠，就使她生育，拉结却不生育。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","利亚怀孕生子，就给他起名叫吕便，因而说：「耶和华看见我的苦情，如今我的丈夫必爱我。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","她又怀孕生子，就说：「耶和华因为听见我失宠，所以又赐给我这个儿子」，于是给他起名叫西缅。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","她又怀孕生子，起名叫利未，说：「我给丈夫生了三个儿子，他必与我联合。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","她又怀孕生子，说：「这回我要赞美耶和华」，因此给他起名叫犹大。这才停了生育。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","拉结见自己不给雅各生子，就嫉妒她姊姊，对雅各说：「你给我孩子，不然我就死了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","雅各向拉结生气，说：「叫你不生育的是　神，我岂能代替他作主呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","拉结说：「有我的使女辟拉在这里，你可以与她同房，使她生子在我膝下，我便因她也得孩子。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","拉结就把她的使女辟拉给丈夫为妾；雅各便与她同房， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","辟拉就怀孕，给雅各生了一个儿子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","拉结说：「　神伸了我的冤，也听了我的声音，赐我一个儿子」，因此给他起名叫但。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","拉结的使女辟拉又怀孕，给雅各生了第二个儿子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","拉结说：「我与我姊姊大大相争，并且得胜」，于是给他起名叫拿弗他利。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","利亚见自己停了生育，就把使女悉帕给雅各为妾。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","利亚的使女悉帕给雅各生了一个儿子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","利亚说：「万幸！」于是给他起名叫迦得。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","利亚的使女悉帕又给雅各生了第二个儿子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","利亚说：「我有福啊，众女子都要称我是有福的」，于是给他起名叫亚设。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","割麦子的时候，吕便往田里去，寻见风茄，拿来给他母亲利亚。拉结对利亚说：「请你把你儿子的风茄给我些。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","利亚说：「你夺了我的丈夫还算小事吗？你又要夺我儿子的风茄吗？」拉结说：「为你儿子的风茄，今夜他可以与你同寝。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","到了晚上，雅各从田里回来，利亚出来迎接他，说：「你要与我同寝，因为我实在用我儿子的风茄把你雇下了。」那一夜，雅各就与她同寝。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","神应允了利亚，她就怀孕，给雅各生了第五个儿子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","利亚说：「　神给了我价值，因为我把使女给了我丈夫」，于是给他起名叫以萨迦。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","利亚又怀孕，给雅各生了第六个儿子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","利亚说：「　神赐我厚赏；我丈夫必与我同住，因我给他生了六个儿子」，于是给他起名西布伦。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","后来又生了一个女儿，给她起名叫底拿。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","神顾念拉结，应允了她，使她能生育。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","拉结怀孕生子，说：「　神除去了我的羞耻」， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","就给他起名叫约瑟，意思说：「愿耶和华再增添我一个儿子。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","拉结生约瑟之后，雅各对拉班说：「请打发我走，叫我回到我本乡本土去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","请你把我服事你所得的妻子和儿女给我，让我走；我怎样服事你，你都知道。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","拉班对他说：「我若在你眼前蒙恩，请你仍与我同住，因为我已算定，耶和华赐福与我是为你的缘故」； ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","又说：「请你定你的工价，我就给你。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","雅各对他说：「我怎样服事你，你的牲畜在我手里怎样，是你知道的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","我未来之先，你所有的很少，现今却发大众多，耶和华随我的脚步赐福与你。如今，我什么时候才为自己兴家立业呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","拉班说：「我当给你什么呢？」雅各说：「什么你也不必给我，只有一件事，你若应承，我便仍旧牧放你的羊群。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","今天我要走遍你的羊群，把绵羊中凡有点的、有斑的，和黑色的，并山羊中凡有斑的、有点的，都挑出来；将来这一等的就算我的工价。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","以后你来查看我的工价，凡在我手里的山羊不是有点有斑的，绵羊不是黑色的，那就算是我偷的；这样便可证出我的公义来。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","拉班说：「好啊！我情愿照着你的话行。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","当日，拉班把有纹的、有斑的公山羊，有点的、有斑的、有杂白纹的母山羊，并黑色的绵羊，都挑出来，交在他儿子们的手下， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","又使自己和雅各相离三天的路程。雅各就牧养拉班其余的羊。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","雅各拿杨树、杏树、枫树的嫩枝，将皮剥成白纹，使枝子露出白的来， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","将剥了皮的枝子，对着羊群，插在饮羊的水沟里和水槽里，羊来喝的时候，牝牡配合。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","羊对着枝子配合，就生下有纹的、有点的、有斑的来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","雅各把羊羔分出来，使拉班的羊与这有纹和黑色的羊相对，把自己的羊另放一处，不叫他和拉班的羊混杂。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","到羊群肥壮配合的时候，雅各就把枝子插在水沟里，使羊对着枝子配合。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","只是到羊瘦弱配合的时候就不插枝子。这样，瘦弱的就归拉班，肥壮的就归雅各。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","于是雅各极其发大，得了许多的羊群、仆婢、骆驼，和驴。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","雅各听见拉班的儿子们有话说：「雅各把我们父亲所有的都夺了去，并借着我们父亲的，得了这一切的荣耀。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","雅各见拉班的气色向他不如从前了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","耶和华对雅各说：「你要回你祖、你父之地，到你亲族那里去，我必与你同在。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","雅各就打发人，叫拉结和利亚到田野羊群那里来， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","对她们说：「我看你们父亲的气色向我不如从前了；但我父亲的　神向来与我同在。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","你们也知道，我尽了我的力量服事你们的父亲。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","你们的父亲欺哄我，十次改了我的工价；然而　神不容他害我。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","他若说：『有点的归你作工价』，羊群所生的都有点；他若说：『有纹的归你作工价』，羊群所生的都有纹。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","这样，　神把你们父亲的牲畜夺来赐给我了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","羊配合的时候，我梦中举目一看，见跳母羊的公羊都是有纹的、有点的、有花斑的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","神的使者在那梦中呼叫我说：『雅各。』我说：『我在这里。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","他说：『你举目观看，跳母羊的公羊都是有纹的、有点的、有花斑的；凡拉班向你所做的，我都看见了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","我是伯特利的　神；你在那里用油浇过柱子，向我许过愿。现今你起来，离开这地，回你本地去吧！』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","拉结和利亚回答雅各说：「在我们父亲的家里还有我们可得的分吗？还有我们的产业吗？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","我们不是被他当作外人吗？因为他卖了我们，吞了我们的价值。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","神从我们父亲所夺出来的一切财物，那就是我们和我们孩子们的。现今凡　神所吩咐你的，你只管去行吧！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","雅各起来，使他的儿子和妻子都骑上骆驼， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","又带着他在巴旦·亚兰所得的一切牲畜和财物，往迦南地、他父亲以撒那里去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","当时拉班剪羊毛去了，拉结偷了他父亲家中的神像。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","雅各背着亚兰人拉班偷走了，并不告诉他， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","就带着所有的逃跑。他起身过大河，面向基列山行去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","到第三日，有人告诉拉班，雅各逃跑了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","拉班带领他的众弟兄去追赶，追了七日，在基列山就追上了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","夜间，　神到亚兰人拉班那里，在梦中对他说：「你要小心，不可与雅各说好说歹。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","拉班追上雅各。雅各在山上支搭帐棚；拉班和他的众弟兄也在基列山上支搭帐棚。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","拉班对雅各说：「你做的是什么事呢？你背着我偷走了，又把我的女儿们带了去，如同用刀剑掳去的一般。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","你为什么暗暗地逃跑，偷着走，并不告诉我，叫我可以欢乐、唱歌、击鼓、弹琴地送你回去？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","又不容我与外孙和女儿亲嘴？你所行的真是愚昧！ ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","我手中原有能力害你，只是你父亲的　神昨夜对我说：『你要小心，不可与雅各说好说歹。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","现在你虽然想你父家，不得不去，为什么又偷了我的神像呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","雅各回答拉班说：「恐怕你把你的女儿从我夺去，所以我逃跑。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","至于你的神像，你在谁那里搜出来，就不容谁存活。当着我们的众弟兄，你认一认，在我这里有什么东西是你的，就拿去。」原来雅各不知道拉结偷了那些神像。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","拉班进了雅各、利亚，并两个使女的帐棚，都没有搜出来，就从利亚的帐棚出来，进了拉结的帐棚。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","拉结已经把神像藏在骆驼的驮篓里，便坐在上头。拉班摸遍了那帐棚，并没有摸着。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","拉结对她父亲说：「现在我身上不便，不能在你面前起来，求我主不要生气。」这样，拉班搜寻神像，竟没有搜出来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","雅各就发怒斥责拉班说：「我有什么过犯，有什么罪恶，你竟这样火速地追我？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","你摸遍了我一切的家具，你搜出什么来呢？可以放在你我弟兄面前，叫他们在你我中间辨别辨别。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","我在你家这二十年，你的母绵羊、母山羊没有掉过胎。你群中的公羊，我没有吃过； ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","被野兽撕裂的，我没有带来给你，是我自己赔上。无论是白日，是黑夜，被偷去的，你都向我索要。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","我白日受尽干热，黑夜受尽寒霜，不得合眼睡着，我常是这样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","我这二十年在你家里，为你的两个女儿服事你十四年，为你的羊群服事你六年，你又十次改了我的工价。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","若不是我父亲以撒所敬畏的　神，就是亚伯拉罕的　神与我同在，你如今必定打发我空手而去。　神看见我的苦情和我的劳碌，就在昨夜责备你。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","拉班回答雅各说：「这女儿是我的女儿，这些孩子是我的孩子，这些羊群也是我的羊群；凡在你眼前的都是我的。我的女儿并她们所生的孩子，我今日能向他们做什么呢？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","来吧！你我二人可以立约，作你我中间的证据。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","雅各就拿一块石头立作柱子， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","又对众弟兄说：「你们堆聚石头。」他们就拿石头来堆成一堆，大家便在旁边吃喝。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","拉班称那石堆为伊迦尔·撒哈杜他，雅各却称那石堆为迦累得。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","拉班说：「今日这石堆作你我中间的证据。」因此这地方名叫迦累得， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","又叫米斯巴，意思说：「我们彼此离别以后，愿耶和华在你我中间鉴察。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","你若苦待我的女儿，又在我的女儿以外另娶妻，虽没有人知道，却有　神在你我中间作见证。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","拉班又说：「你看我在你我中间所立的这石堆和柱子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","这石堆作证据，这柱子也作证据。我必不过这石堆去害你；你也不可过这石堆和柱子来害我。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","但愿亚伯拉罕的　神和拿鹤的　神，就是他们父亲的　神，在你我中间判断。」雅各就指着他父亲以撒所敬畏的　神起誓， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","又在山上献祭，请众弟兄来吃饭。他们吃了饭，便在山上住宿。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","拉班清早起来，与他外孙和女儿亲嘴，给他们祝福，回往自己的地方去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","雅各仍旧行路，　神的使者遇见他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","雅各看见他们就说：「这是　神的军兵」，于是给那地方起名叫玛哈念。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","雅各打发人先往西珥地去，就是以东地，见他哥哥以扫， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","吩咐他们说：「你们对我主以扫说：『你的仆人雅各这样说：我在拉班那里寄居，直到如今。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","我有牛、驴、羊群、仆婢，现在打发人来报告我主，为要在你眼前蒙恩。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","所打发的人回到雅各那里，说：「我们到了你哥哥以扫那里，他带着四百人，正迎着你来。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","雅各就甚惧怕，而且愁烦，便把那与他同在的人口和羊群、牛群、骆驼分做两队， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","说：「以扫若来击杀这一队，剩下的那一队还可以逃避。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","雅各说：「耶和华—我祖亚伯拉罕的　神，我父亲以撒的　神啊，你曾对我说：『回你本地本族去，我要厚待你。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","你向仆人所施的一切慈爱和诚实，我一点也不配得；我先前只拿着我的杖过这约旦河，如今我却成了两队了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","求你救我脱离我哥哥以扫的手；因为我怕他来杀我，连妻子带儿女一同杀了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","你曾说：『我必定厚待你，使你的后裔如同海边的沙，多得不可胜数。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","当夜，雅各在那里住宿，就从他所有的物中拿礼物要送给他哥哥以扫： ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","母山羊二百只，公山羊二十只，母绵羊二百只，公绵羊二十只， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","奶崽子的骆驼三十只—各带着崽子，母牛四十只，公牛十只，母驴二十匹，驴驹十匹； ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","每样各分一群，交在仆人手下，就对仆人说：「你们要在我前头过去，使群群相离，有空闲的地方」； ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","又吩咐尽先走的说：「我哥哥以扫遇见你的时候，问你说：『你是哪家的人？要往哪里去？你前头这些是谁的？』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","你就说：『是你仆人雅各的，是送给我主以扫的礼物；他自己也在我们后边。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","又吩咐第二、第三，和一切赶群畜的人说：「你们遇见以扫的时候也要这样对他说； ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","并且你们要说：『你仆人雅各在我们后边。』」因雅各心里说：「我借着在我前头去的礼物解他的恨，然后再见他的面，或者他容纳我。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","于是礼物先过去了；那夜，雅各在队中住宿。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","他夜间起来，带着两个妻子，两个使女，并十一个儿子，都过了雅博渡口， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","先打发他们过河，又打发所有的都过去， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","只剩下雅各一人。有一个人来和他摔跤，直到黎明。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","那人见自己胜不过他，就将他的大腿窝摸了一把，雅各的大腿窝正在摔跤的时候就扭了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","那人说：「天黎明了，容我去吧！」雅各说：「你不给我祝福，我就不容你去。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","那人说：「你名叫什么？」他说：「我名叫雅各。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","那人说：「你的名不要再叫雅各，要叫以色列；因为你与　神与人较力，都得了胜。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","雅各问他说：「请将你的名告诉我。」那人说：「何必问我的名？」于是在那里给雅各祝福。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","雅各便给那地方起名叫毗努伊勒，意思说：「我面对面见了　神，我的性命仍得保全。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","日头刚出来的时候，雅各经过毗努伊勒，他的大腿就瘸了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","故此，以色列人不吃大腿窝的筋，直到今日，因为那人摸了雅各大腿窝的筋。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","雅各举目观看，见以扫来了，后头跟着四百人，他就把孩子们分开交给利亚、拉结，和两个使女， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","并且叫两个使女和她们的孩子在前头，利亚和她的孩子在后头，拉结和约瑟在尽后头。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","他自己在他们前头过去，一连七次俯伏在地才就近他哥哥。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","以扫跑来迎接他，将他抱住，又搂着他的颈项，与他亲嘴，两个人就哭了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","以扫举目看见妇人孩子，就说：「这些和你同行的是谁呢？」雅各说：「这些孩子是　神施恩给你的仆人的。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","于是两个使女和她们的孩子前来下拜； ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","利亚和她的孩子也前来下拜；随后约瑟和拉结也前来下拜。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","以扫说：「我所遇见的这些群畜是什么意思呢？」雅各说：「是要在我主面前蒙恩的。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","以扫说：「兄弟啊，我的已经够了，你的仍归你吧！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","雅各说：「不然，我若在你眼前蒙恩，就求你从我手里收下这礼物；因为我见了你的面，如同见了　神的面，并且你容纳了我。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","求你收下我带来给你的礼物；因为　神恩待我，使我充足。」雅各再三地求他，他才收下了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","以扫说：「我们可以起身前往，我在你前头走。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","雅各对他说：「我主知道孩子们年幼娇嫩，牛羊也正在乳养的时候，若是催赶一天，群畜都必死了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","求我主在仆人前头走，我要量着在我面前群畜和孩子的力量慢慢地前行，直走到西珥我主那里。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","以扫说：「容我把跟随我的人留几个在你这里。」雅各说：「何必呢？只要在我主眼前蒙恩就是了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","于是，以扫当日起行，回往西珥去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","雅各就往疏割去，在那里为自己盖造房屋，又为牲畜搭棚；因此那地方名叫疏割。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","雅各从巴旦·亚兰回来的时候，平平安安地到了迦南地的示剑城，在城东支搭帐棚， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","就用一百块银子向示剑的父亲、哈抹的子孙买了支帐棚的那块地， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","在那里筑了一座坛，起名叫伊利·伊罗伊·以色列。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","利亚给雅各所生的女儿底拿出去，要见那地的女子们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","那地的主—希未人、哈抹的儿子示剑看见她，就拉住她，与她行淫，玷辱她。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","示剑的心系恋雅各的女儿底拿，喜爱这女子，甜言蜜语地安慰她。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","示剑对他父亲哈抹说：「求你为我聘这女子为妻。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","雅各听见示剑玷污了他的女儿底拿。那时他的儿子们正和群畜在田野，雅各就闭口不言，等他们回来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","示剑的父亲哈抹出来见雅各，要和他商议。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","雅各的儿子们听见这事，就从田野回来，人人忿恨，十分恼怒；因示剑在以色列家做了丑事，与雅各的女儿行淫，这本是不该做的事。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","哈抹和他们商议说：「我儿子示剑的心恋慕这女子，求你们将她给我的儿子为妻。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","你们与我们彼此结亲；你们可以把女儿给我们，也可以娶我们的女儿。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","你们与我们同住吧！这地都在你们面前，只管在此居住，做买卖，置产业。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","示剑对女儿的父亲和弟兄们说：「但愿我在你们眼前蒙恩，你们向我要什么，我必给你们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","任凭向我要多重的聘金和礼物，我必照你们所说的给你们；只要把女子给我为妻。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","雅各的儿子们因为示剑玷污了他们的妹子底拿，就用诡诈的话回答示剑和他父亲哈抹， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","对他们说：「我们不能把我们的妹子给没有受割礼的人为妻，因为那是我们的羞辱。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","惟有一件才可以应允：若你们所有的男丁都受割礼，和我们一样， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","我们就把女儿给你们，也娶你们的女儿；我们便与你们同住，两下成为一样的人民。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","倘若你们不听从我们受割礼，我们就带着妹子走了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","哈抹和他的儿子示剑喜欢这话。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","那少年人做这事并不迟延，因为他喜爱雅各的女儿；他在他父亲家中也是人最尊重的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","哈抹和他儿子示剑到本城的门口，对本城的人说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","「这些人与我们和睦，不如许他们在这地居住，做买卖；这地也宽阔，足可容下他们。我们可以娶他们的女儿为妻，也可以把我们的女儿嫁给他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","惟有一件事我们必须做，他们才肯应允和我们同住，成为一样的人民：就是我们中间所有的男丁都要受割礼，和他们一样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","他们的群畜、货财，和一切的牲口岂不都归我们吗？只要依从他们，他们就与我们同住。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","凡从城门出入的人就都听从哈抹和他儿子示剑的话；于是凡从城门出入的男丁都受了割礼。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","到第三天，众人正在疼痛的时候，雅各的两个儿子，就是底拿的哥哥西缅和利未，各拿刀剑，趁着众人想不到的时候来到城中，把一切男丁都杀了， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","又用刀杀了哈抹和他儿子示剑，把底拿从示剑家里带出来就走了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","雅各的儿子们因为他们的妹子受了玷污，就来到被杀的人那里，掳掠那城， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","夺了他们的羊群、牛群，和驴，并城里田间所有的； ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","又把他们一切货财、孩子、妇女，并各房中所有的，都掳掠去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","雅各对西缅和利未说：「你们连累我，使我在这地的居民中，就是在迦南人和比利洗人中，有了臭名。我的人丁既然稀少，他们必聚集来击杀我，我和全家的人都必灭绝。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","他们说：「他岂可待我们的妹子如同妓女吗？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","神对雅各说：「起来！上伯特利去，住在那里；要在那里筑一座坛给　神，就是你逃避你哥哥以扫的时候向你显现的那位。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","雅各就对他家中的人并一切与他同在的人说：「你们要除掉你们中间的外邦神，也要自洁，更换衣裳。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","我们要起来，上伯特利去，在那里我要筑一座坛给　神，就是在我遭难的日子应允我的祷告、在我行的路上保佑我的那位。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","他们就把外邦人的神像和他们耳朵上的环子交给雅各；雅各都藏在示剑那里的橡树底下。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","他们便起行前往。　神使那周围城邑的人都甚惊惧，就不追赶雅各的众子了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","于是雅各和一切与他同在的人到了迦南地的路斯，就是伯特利。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","他在那里筑了一座坛，就给那地方起名叫伊勒·伯特利；因为他逃避他哥哥的时候，　神在那里向他显现。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","利百加的奶母底波拉死了，就葬在伯特利下边橡树底下；那棵树名叫亚伦·巴古。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","雅各从巴旦·亚兰回来，　神又向他显现，赐福与他， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","且对他说：「你的名原是雅各，从今以后不要再叫雅各，要叫以色列。」这样，他就改名叫以色列。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","神又对他说：「我是全能的　神；你要生养众多，将来有一族和多国的民从你而生，又有君王从你而出。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","我所赐给亚伯拉罕和以撒的地，我要赐给你与你的后裔。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","神就从那与雅各说话的地方升上去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","雅各便在那里立了一根石柱，在柱子上奠酒，浇油。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","雅各就给那地方起名叫伯特利。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","他们从伯特利起行，离以法他还有一段路程，拉结临产甚是艰难。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","正在艰难的时候，收生婆对她说：「不要怕，你又要得一个儿子了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","她将近于死，灵魂要走的时候，就给她儿子起名叫便·俄尼；他父亲却给他起名叫便雅悯。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","拉结死了，葬在以法他的路旁；以法他就是伯利恒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","雅各在她的坟上立了一统碑，就是拉结的墓碑，到今日还在。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","以色列起行前往，在以得台那边支搭帐棚。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","以色列住在那地的时候，吕便去与他父亲的妾辟拉同寝，以色列也听见了。 雅各共有十二个儿子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","利亚所生的是雅各的长子吕便，还有西缅、利未、犹大、以萨迦、西布伦。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","拉结所生的是约瑟、便雅悯。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","拉结的使女辟拉所生的是但、拿弗他利。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","利亚的使女悉帕所生的是迦得、亚设。这是雅各在巴旦·亚兰所生的儿子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","雅各来到他父亲以撒那里，到了基列·亚巴的幔利，乃是亚伯拉罕和以撒寄居的地方；基列·亚巴就是希伯 。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","以撒共活了一百八十岁。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","以撒年纪老迈，日子满足，气绝而死，归到他列祖那里。他两个儿子以扫、雅各把他埋葬了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","以扫就是以东，他的后代记在下面。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","以扫娶迦南的女子为妻，就是赫人以伦的女儿亚大和希未人祭便的孙女、亚拿的女儿阿何利巴玛， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","又娶了以实玛利的女儿、尼拜约的妹子巴实抹。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","亚大给以扫生了以利法；巴实抹生了流珥； ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","阿何利巴玛生了耶乌施、雅兰、可拉。这都是以扫的儿子，是在迦南地生的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","以扫带着他的妻子、儿女，与家中一切的人口，并他的牛羊、牲畜，和一切货财，就是他在迦南地所得的，往别处去，离了他兄弟雅各。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","因为二人的财物群畜甚多，寄居的地方容不下他们，所以不能同居。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","于是以扫住在西珥山里；以扫就是以东。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","以扫是西珥山里以东人的始祖，他的后代记在下面。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","以扫众子的名字如下。以扫的妻子亚大生以利法；以扫的妻子巴实抹生流珥。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","以利法的儿子是提幔、阿抹、洗玻、迦坦、基纳斯。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","亭纳是以扫儿子以利法的妾；她给以利法生了亚玛力。这是以扫的妻子亚大的子孙。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","流珥的儿子是拿哈、谢拉、沙玛、米撒。这是以扫妻子巴实抹的子孙。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","以扫的妻子阿何利巴玛是祭便的孙女，亚拿的女儿；她给以扫生了耶乌施、雅兰、可拉。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","以扫子孙中作族长的记在下面。以扫的长子以利法的子孙中，有提幔族长、阿抹族长、洗玻族长、基纳斯族长、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","可拉族长、迦坦族长、亚玛力族长。这是在以东地从以利法所出的族长，都是亚大的子孙。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","以扫的儿子流珥的子孙中，有拿哈族长、谢拉族长、沙玛族长、米撒族长。这是在以东地从流珥所出的族长，都是以扫妻子巴实抹的子孙。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","以扫的妻子阿何利巴玛的子孙中，有耶乌施族长、雅兰族长、可拉族长。这是从以扫妻子，亚拿的女儿，阿何利巴玛子孙中所出的族长。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","以上的族长都是以扫的子孙；以扫就是以东。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","那地原有的居民—何利人西珥的子孙记在下面：就是罗坍、朔巴、祭便、亚拿、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","底顺、以察、底珊。这是从以东地的何利人西珥子孙中所出的族长。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","罗坍的儿子是何利、希幔；罗坍的妹子是亭纳。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","朔巴的儿子是亚勒文、玛拿辖、以巴录、示玻、阿南。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","祭便的儿子是亚雅、亚拿（当时在旷野放他父亲祭便的驴，遇着温泉的，就是这亚拿）。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","亚拿的儿子是底顺；亚拿的女儿是阿何利巴玛。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","底顺的儿子是欣但、伊是班、益兰、基兰。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","以察的儿子是辟罕、撒番、亚干。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","底珊的儿子是乌斯、亚兰。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","从何利人所出的族长记在下面：就是罗坍族长、朔巴族长、祭便族长、亚拿族长、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","底顺族长、以察族长、底珊族长。这是从何利人所出的族长，都在西珥地，按着宗族作族长。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","以色列人未有君王治理以先，在以东地作王的记在下面。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","比珥的儿子比拉在以东作王，他的京城名叫亭哈巴。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","比拉死了，波斯拉人谢拉的儿子约巴接续他作王。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","约巴死了，提幔地的人户珊接续他作王。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","户珊死了，比达的儿子哈达接续他作王；这哈达就是在摩押地杀败米甸人的，他的京城名叫亚未得。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","哈达死了，玛士利加人桑拉接续他作王。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","桑拉死了，大河边的利河伯人扫罗接续他作王。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","扫罗死了，亚革波的儿子巴勒·哈南接续他作王。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","亚革波的儿子巴勒·哈南死了，哈达接续他作王，他的京城名叫巴乌；他的妻子名叫米希她别，是米·萨合的孙女，玛特列的女儿。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","从以扫所出的族长，按着他们的宗族、住处、名字记在下面：就是亭纳族长、亚勒瓦族长、耶帖族长、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","阿何利巴玛族长、以拉族长、比嫩族长、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","基纳斯族长、提幔族长、米比萨族长、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","玛基叠族长、以兰族长。这是以东人在所得为业的地上，按着他们的住处。（所有的族长都是以东人的始祖以扫的后代。） ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","雅各住在迦南地，就是他父亲寄居的地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","雅各的记略如下。 约瑟十七岁与他哥哥们一同牧羊。他是个童子，与他父亲的妾辟拉、悉帕的儿子们常在一处。约瑟将他哥哥们的恶行报给他们的父亲。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","以色列原来爱约瑟过于爱他的众子，因为约瑟是他年老生的；他给约瑟做了一件彩衣。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","约瑟的哥哥们见父亲爱约瑟过于爱他们，就恨约瑟，不与他说和睦的话。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","约瑟做了一梦，告诉他哥哥们，他们就越发恨他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","约瑟对他们说：「请听我所做的梦： ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","我们在田里捆禾稼，我的捆起来站着，你们的捆来围着我的捆下拜。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","他的哥哥们回答说：「难道你真要作我们的王吗？难道你真要管辖我们吗？」他们就因为他的梦和他的话越发恨他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","后来他又做了一梦，也告诉他的哥哥们说：「看哪，我又做了一梦，梦见太阳、月亮，与十一个星向我下拜。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","约瑟将这梦告诉他父亲和他哥哥们，他父亲就责备他说：「你做的这是什么梦！难道我和你母亲、你弟兄果然要来俯伏在地，向你下拜吗？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","他哥哥们都嫉妒他，他父亲却把这话存在心里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","约瑟的哥哥们往示剑去放他们父亲的羊。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","以色列对约瑟说：「你哥哥们不是在示剑放羊吗？你来，我要打发你往他们那里去。」约瑟说：「我在这里。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","以色列说：「你去看看你哥哥们平安不平安，群羊平安不平安，就回来报信给我」；于是打发他出希伯 谷，他就往示剑去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","有人遇见他在田野走迷了路，就问他说：「你找什么？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","他说：「我找我的哥哥们，求你告诉我，他们在何处放羊。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","那人说：「他们已经走了，我听见他们说要往多坍去。」约瑟就去追赶他哥哥们，遇见他们在多坍。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","他们远远地看见他，趁他还没有走到跟前，大家就同谋要害死他， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","彼此说：「你看！那做梦的来了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","来吧！我们将他杀了，丢在一个坑里，就说有恶兽把他吃了。我们且看他的梦将来怎么样。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","吕便听见了，要救他脱离他们的手，说：「我们不可害他的性命」； ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","又说：「不可流他的血，可以把他丢在这野地的坑里，不可下手害他。」吕便的意思是要救他脱离他们的手，把他归还他的父亲。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","约瑟到了他哥哥们那里，他们就剥了他的外衣，就是他穿的那件彩衣， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","把他丢在坑里；那坑是空的，里头没有水。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","他们坐下吃饭，举目观看，见有一伙米甸 的以实玛利人从基列来，用骆驼驮着香料、乳香、没药，要带下埃及去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","犹大对众弟兄说：「我们杀我们的兄弟，藏了他的血有什么益处呢？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","我们不如将他卖给以实玛利人，不可下手害他；因为他是我们的兄弟，我们的骨肉。」众弟兄就听从了他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","有些米甸的商人从那里经过，哥哥们就把约瑟从坑里拉上来，讲定二十舍客勒银子，把约瑟卖给以实玛利人。他们就把约瑟带到埃及去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","吕便回到坑边，见约瑟不在坑里，就撕裂衣服， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","回到兄弟们那里，说：「童子没有了。我往哪里去才好呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","他们宰了一只公山羊，把约瑟的那件彩衣染了血， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","打发人送到他们的父亲那里，说：「我们捡了这个；请认一认是你儿子的外衣不是？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","他认得，就说：「这是我儿子的外衣。有恶兽把他吃了，约瑟被撕碎了！撕碎了！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","雅各便撕裂衣服，腰间围上麻布，为他儿子悲哀了多日。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","他的儿女都起来安慰他，他却不肯受安慰，说：「我必悲哀着下阴间，到我儿子那里。」约瑟的父亲就为他哀哭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","米甸人带约瑟到埃及，把他卖给法老的内臣—护卫长波提乏。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","那时，犹大离开他弟兄下去，到一个亚杜兰人名叫希拉的家里去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","犹大在那里看见一个迦南人名叫书亚的女儿，就娶她为妻，与她同房， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","她就怀孕生了儿子，犹大给他起名叫珥。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","她又怀孕生了儿子，母亲给他起名叫俄南。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","她复又生了儿子，给他起名叫示拉。她生示拉的时候，犹大正在基悉。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","犹大为长子珥娶妻，名叫她玛。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","犹大的长子珥在耶和华眼中看为恶，耶和华就叫他死了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","犹大对俄南说：「你当与你哥哥的妻子同房，向她尽你为弟的本分，为你哥哥生子立后。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","俄南知道生子不归自己，所以同房的时候便遗在地，免得给他哥哥留后。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","俄南所做的在耶和华眼中看为恶，耶和华也就叫他死了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","犹大心里说：「恐怕示拉也死，像他两个哥哥一样」，就对他儿妇她玛说：「你去，在你父亲家里守寡，等我儿子示拉长大。」她玛就回去，住在她父亲家里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","过了许久，犹大的妻子书亚的女儿死了。犹大得了安慰，就和他朋友亚杜兰人希拉上亭拿去，到他剪羊毛的人那里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","有人告诉她玛说：「你的公公上亭拿剪羊毛去了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","她玛见示拉已经长大，还没有娶她为妻，就脱了她作寡妇的衣裳，用帕子蒙着脸，又遮住身体，坐在亭拿路上的伊拿印城门口。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","犹大看见她，以为是妓女，因为她蒙着脸。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","犹大就转到她那里去，说：「来吧！让我与你同寝。」他原不知道是他的儿妇。她玛说：「你要与我同寝，把什么给我呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","犹大说：「我从羊群里取一只山羊羔，打发人送来给你。」她玛说：「在未送以先，你愿意给我一个当头吗？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","他说：「我给你什么当头呢？」她玛说：「你的印、你的带子，和你手里的杖。」犹大就给了她，与她同寝，她就从犹大怀了孕。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","她玛起来走了，除去帕子，仍旧穿上作寡妇的衣裳。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","犹大托他朋友亚杜兰人送一只山羊羔去，要从那女人手里取回当头来，却找不着她， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","就问那地方的人说：「伊拿印路旁的妓女在哪里？」他们说：「这里并没有妓女。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","他回去见犹大说：「我没有找着她，并且那地方的人说：『这里没有妓女。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","犹大说：「我把这山羊羔送去了，你竟找不着她。任凭她拿去吧，免得我们被羞辱。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","约过了三个月，有人告诉犹大说：「你的儿妇她玛作了妓女，且因行淫有了身孕。」犹大说：「拉出她来，把她烧了！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","她玛被拉出来的时候便打发人去见她公公，对他说：「这些东西是谁的，我就是从谁怀的孕。请你认一认，这印和带子并杖都是谁的？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","犹大承认说：「她比我更有义，因为我没有将她给我的儿子示拉。」从此犹大不再与她同寝了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","她玛将要生产，不料她腹里是一对双生。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","到生产的时候，一个孩子伸出一只手来；收生婆拿红线拴在他手上，说：「这是头生的。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","随后这孩子把手收回去，他哥哥生出来了；收生婆说：「你为什么抢着来呢？」因此给他起名叫法勒斯。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","后来，他兄弟那手上有红线的也生出来，就给他起名叫谢拉。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","约瑟被带下埃及去。有一个埃及人，是法老的内臣—护卫长波提乏，从那些带下他来的以实玛利人手下买了他去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","约瑟住在他主人埃及人的家中，耶和华与他同在，他就百事顺利。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","他主人见耶和华与他同在，又见耶和华使他手里所办的尽都顺利， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","约瑟就在主人眼前蒙恩，伺候他主人，并且主人派他管理家务，把一切所有的都交在他手里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","自从主人派约瑟管理家务和他一切所有的，耶和华就因约瑟的缘故赐福与那埃及人的家；凡家里和田间一切所有的都蒙耶和华赐福。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","波提乏将一切所有的都交在约瑟的手中，除了自己所吃的饭，别的事一概不知。 约瑟原来秀雅俊美。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","这事以后，约瑟主人的妻以目送情给约瑟，说：「你与我同寝吧！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","约瑟不从，对他主人的妻说：「看哪，一切家务，我主人都不知道；他把所有的都交在我手里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","在这家里没有比我大的；并且他没有留下一样不交给我，只留下了你，因为你是他的妻子。我怎能作这大恶，得罪　神呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","后来她天天和约瑟说，约瑟却不听从她，不与她同寝，也不和她在一处。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","有一天，约瑟进屋里去办事，家中人没有一个在那屋里， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","妇人就拉住他的衣裳，说：「你与我同寝吧！」约瑟把衣裳丢在妇人手里，跑到外边去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","妇人看见约瑟把衣裳丢在她手里跑出去了， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","就叫了家里的人来，对他们说：「你们看！他带了一个希伯来人进入我们家里，要戏弄我们。他到我这里来，要与我同寝，我就大声喊叫。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","他听见我放声喊起来，就把衣裳丢在我这里，跑到外边去了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","妇人把约瑟的衣裳放在自己那里，等着他主人回家， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","就对他如此如此说：「你所带到我们这里的那希伯来仆人进来要戏弄我， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","我放声喊起来，他就把衣裳丢在我这里，跑出去了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","约瑟的主人听见他妻子对他所说的话，说「你的仆人如此如此待我」，他就生气， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","把约瑟下在监里，就是王的囚犯被囚的地方。于是约瑟在那里坐监。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","但耶和华与约瑟同在，向他施恩，使他在司狱的眼前蒙恩。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","司狱就把监里所有的囚犯都交在约瑟的手下；他们在那里所办的事都是经他的手。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","凡在约瑟手下的事，司狱一概不察，因为耶和华与约瑟同在；耶和华使他所做的尽都顺利。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","这事以后，埃及王的酒政和膳长得罪了他们的主—埃及王， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","法老就恼怒酒政和膳长这二臣， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","把他们下在护卫长府内的监里，就是约瑟被囚的地方。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","护卫长把他们交给约瑟，约瑟便伺候他们；他们有些日子在监里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","被囚在监之埃及王的酒政和膳长二人同夜各做一梦，各梦都有讲解。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","到了早晨，约瑟进到他们那里，见他们有愁闷的样子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","他便问法老的二臣，就是与他同囚在他主人府里的，说：「你们今日为什么面带愁容呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","他们对他说：「我们各人做了一梦，没有人能解。」约瑟说：「解梦不是出于　神吗？请你们将梦告诉我。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","酒政便将他的梦告诉约瑟说：「我梦见在我面前有一棵葡萄树， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","树上有三根枝子，好像发了芽，开了花，上头的葡萄都成熟了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","法老的杯在我手中，我就拿葡萄挤在法老的杯里，将杯递在他手中。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","约瑟对他说：「你所做的梦是这样解：三根枝子就是三天； ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","三天之内，法老必提你出监，叫你官复原职，你仍要递杯在法老的手中，和先前作他的酒政一样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","但你得好处的时候，求你记念我，施恩与我，在法老面前提说我，救我出这监牢。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","我实在是从希伯来人之地被拐来的；我在这里也没有做过什么，叫他们把我下在监里。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","膳长见梦解得好，就对约瑟说：「我在梦中见我头上顶着三筐白饼； ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","极上的筐子里有为法老烤的各样食物，有飞鸟来吃我头上筐子里的食物。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","约瑟说：「你的梦是这样解：三个筐子就是三天； ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","三天之内，法老必斩断你的头，把你挂在木头上，必有飞鸟来吃你身上的肉。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","到了第三天，是法老的生日，他为众臣仆设摆筵席，把酒政和膳长提出监来， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","使酒政官复原职，他仍旧递杯在法老手中； ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","但把膳长挂起来，正如约瑟向他们所解的话。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","酒政却不记念约瑟，竟忘了他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","过了两年，法老做梦，梦见自己站在河边， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","有七只母牛从河里上来，又美好又肥壮，在芦荻中吃草。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","随后又有七只母牛从河里上来，又丑陋又干瘦，与那七只母牛一同站在河边。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","这又丑陋又干瘦的七只母牛吃尽了那又美好又肥壮的七只母牛。法老就醒了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","他又睡着，第二回做梦，梦见一棵麦子长了七个穗子，又肥大又佳美， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","随后又长了七个穗子，又细弱又被东风吹焦了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","这细弱的穗子吞了那七个又肥大又饱满的穗子。法老醒了，不料是个梦。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","到了早晨，法老心里不安，就差人召了埃及所有的术士和博士来；法老就把所做的梦告诉他们，却没有人能给法老圆解。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","那时酒政对法老说：「我今日想起我的罪来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","从前法老恼怒臣仆，把我和膳长下在护卫长府内的监里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","我们二人同夜各做一梦，各梦都有讲解。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","在那里同着我们有一个希伯来的少年人，是护卫长的仆人，我们告诉他，他就把我们的梦圆解，是按着各人的梦圆解的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","后来正如他给我们圆解的成就了：我官复原职，膳长被挂起来了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","法老遂即差人去召约瑟，他们便急忙带他出监，他就剃头，刮脸，换衣裳，进到法老面前。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","法老对约瑟说：「我做了一梦，没有人能解；我听见人说，你听了梦就能解。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","约瑟回答法老说：「这不在乎我，　神必将平安的话回答法老。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","法老对约瑟说：「我梦见我站在河边， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","有七只母牛从河里上来，又肥壮又美好，在芦荻中吃草。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","随后又有七只母牛上来，又软弱又丑陋又干瘦，在埃及遍地，我没有见过这样不好的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","这又干瘦又丑陋的母牛吃尽了那以先的七只肥母牛， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","吃了以后却看不出是吃了，那丑陋的样子仍旧和先前一样。我就醒了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","我又梦见一棵麦子，长了七个穗子，又饱满又佳美， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","随后又长了七个穗子，枯槁细弱，被东风吹焦了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","这些细弱的穗子吞了那七个佳美的穗子。我将这梦告诉了术士，却没有人能给我解说。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","约瑟对法老说：「法老的梦乃是一个。　神已将所要做的事指示法老了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","七只好母牛是七年，七个好穗子也是七年；这梦乃是一个。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","那随后上来的七只又干瘦又丑陋的母牛是七年，那七个虚空、被东风吹焦的穗子也是七年，都是七个荒年。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","这就是我对法老所说，　神已将所要做的事显明给法老了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","埃及遍地必来七个大丰年， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","随后又要来七个荒年，甚至在埃及地都忘了先前的丰收，全地必被饥荒所灭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","因那以后的饥荒甚大，便不觉得先前的丰收了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","至于法老两回做梦，是因　神命定这事，而且必速速成就。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","所以，法老当拣选一个有聪明有智慧的人，派他治理埃及地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","法老当这样行，又派官员管理这地。当七个丰年的时候，征收埃及地的五分之一， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","叫他们把将来丰年一切的粮食聚敛起来，积蓄五谷，收存在各城里做食物，归于法老的手下。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","所积蓄的粮食可以防备埃及地将来的七个荒年，免得这地被饥荒所灭。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","法老和他一切臣仆都以这事为妙。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","法老对臣仆说：「像这样的人，有　神的灵在他里头，我们岂能找得着呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","法老对约瑟说：「　神既将这事都指示你，可见没有人像你这样有聪明有智慧。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","你可以掌管我的家；我的民都必听从你的话。惟独在宝座上我比你大。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","法老又对约瑟说：「我派你治理埃及全地。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","法老就摘下手上打印的戒指，戴在约瑟的手上，给他穿上细麻衣，把金链戴在他的颈项上， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","又叫约瑟坐他的副车，喝道的在前呼叫说：「跪下。」这样，法老派他治理埃及全地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","法老对约瑟说：「我是法老，在埃及全地，若没有你的命令，不许人擅自办事。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","法老赐名给约瑟，叫撒发那忒·巴内亚，又将安城的祭司波提非拉的女儿亚西纳给他为妻。约瑟就出去巡行埃及地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","约瑟见埃及王法老的时候年三十岁。他从法老面前出去，遍行埃及全地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","七个丰年之内，地的出产极丰极盛， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","约瑟聚敛埃及地七个丰年一切的粮食，把粮食积存在各城里；各城周围田地的粮食都积存在本城里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","约瑟积蓄五谷甚多，如同海边的沙，无法计算，因为谷不可胜数。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","荒年未到以前，安城的祭司波提非拉的女儿亚西纳给约瑟生了两个儿子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","约瑟给长子起名叫玛拿西，因为他说：「　神使我忘了一切的困苦和我父的全家。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","他给次子起名叫以法莲，因为他说：「　神使我在受苦的地方昌盛。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","埃及地的七个丰年一完， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","七个荒年就来了。正如约瑟所说的，各地都有饥荒；惟独埃及全地有粮食。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","及至埃及全地有了饥荒，众民向法老哀求粮食，法老对他们说：「你们往约瑟那里去，凡他所说的，你们都要做。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","当时饥荒遍满天下，约瑟开了各处的仓，粜粮给埃及人；在埃及地饥荒甚大。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","各地的人都往埃及去，到约瑟那里籴粮，因为天下的饥荒甚大。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","雅各见埃及有粮，就对儿子们说：「你们为什么彼此观望呢？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","我听见埃及有粮，你们可以下去，从那里为我们籴些来，使我们可以存活，不至于死。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","于是，约瑟的十个哥哥都下埃及籴粮去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","但约瑟的兄弟便雅悯，雅各没有打发他和哥哥们同去，因为雅各说：「恐怕他遭害。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","来籴粮的人中有以色列的儿子们，因为迦南地也有饥荒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","当时治理埃及地的是约瑟；粜粮给那地众民的就是他。约瑟的哥哥们来了，脸伏于地，向他下拜。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","约瑟看见他哥哥们，就认得他们，却装作生人，向他们说些严厉话，问他们说：「你们从哪里来？」他们说：「我们从迦南地来籴粮。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","约瑟认得他哥哥们，他们却不认得他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","约瑟想起从前所做的那两个梦，就对他们说：「你们是奸细，来窥探这地的虚实。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","他们对他说：「我主啊，不是的。仆人们是籴粮来的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","我们都是一个人的儿子，是诚实人；仆人们并不是奸细。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","约瑟说：「不然，你们必是窥探这地的虚实来的。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","他们说：「仆人们本是弟兄十二人，是迦南地一个人的儿子，顶小的现今在我们的父亲那里，有一个没有了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","约瑟说：「我才说你们是奸细，这话实在不错。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","我指着法老的性命起誓，若是你们的小兄弟不到这里来，你们就不得出这地方，从此就可以把你们证验出来了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","须要打发你们中间一个人去，把你们的兄弟带来。至于你们，都要囚在这里，好证验你们的话真不真，若不真，我指着法老的性命起誓，你们一定是奸细。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","于是约瑟把他们都下在监里三天。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","到第三天，约瑟对他们说：「我是敬畏　神的；你们照我的话行就可以存活。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","你们如果是诚实人，可以留你们中间的一个人囚在监里，但你们可以带着粮食回去，救你们家里的饥荒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","把你们的小兄弟带到我这里来，如此，你们的话便有证据，你们也不至于死。」他们就照样而行。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","他们彼此说：「我们在兄弟身上实在有罪。他哀求我们的时候，我们见他心里的愁苦，却不肯听，所以这场苦难临到我们身上。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","吕便说：「我岂不是对你们说过，不可伤害那孩子吗？只是你们不肯听，所以流他血的罪向我们追讨。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","他们不知道约瑟听得出来，因为在他们中间用通事传话。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","约瑟转身退去，哭了一场，又回来对他们说话，就从他们中间挑出西缅来，在他们眼前把他捆绑。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","约瑟吩咐人把粮食装满他们的器具，把各人的银子归还在各人的口袋里，又给他们路上用的食物，人就照他的话办了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","他们就把粮食驮在驴上，离开那里去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","到了住宿的地方，他们中间有一个人打开口袋，要拿料喂驴，才看见自己的银子仍在口袋里， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","就对弟兄们说：「我的银子归还了，看哪，仍在我口袋里！」他们就提心吊胆，战战兢兢地彼此说：「这是　神向我们做什么呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","他们来到迦南地、他们的父亲雅各那里，将所遭遇的事都告诉他，说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","「那地的主对我们说严厉的话，把我们当作窥探那地的奸细。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","我们对他说：『我们是诚实人，并不是奸细。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","我们本是弟兄十二人，都是一个父亲的儿子，有一个没有了，顶小的如今同我们的父亲在迦南地。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","那地的主对我们说：『若要我知道你们是诚实人，可以留下你们中间的一个人在我这里，你们可以带着粮食回去，救你们家里的饥荒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","把你们的小兄弟带到我这里来，我便知道你们不是奸细，乃是诚实人。这样，我就把你们的弟兄交给你们，你们也可以在这地做买卖。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","后来他们倒口袋，不料，各人的银包都在口袋里；他们和父亲看见银包就都害怕。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","他们的父亲雅各对他们说：「你们使我丧失我的儿子：约瑟没有了，西缅也没有了，你们又要将便雅悯带去；这些事都归到我身上了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","吕便对他父亲说：「我若不带他回来交给你，你可以杀我的两个儿子。只管把他交在我手里，我必带他回来交给你。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","雅各说：「我的儿子不可与你们一同下去；他哥哥死了，只剩下他，他若在你们所行的路上遭害，那便是你们使我白发苍苍、悲悲惨惨地下阴间去了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","那地的饥荒甚大。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","他们从埃及带来的粮食吃尽了，他们的父亲就对他们说：「你们再去给我籴些粮来。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","犹大对他说：「那人谆谆地告诫我们说：『你们的兄弟若不与你们同来，你们就不得见我的面。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","你若打发我们的兄弟与我们同去，我们就下去给你籴粮； ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","你若不打发他去，我们就不下去，因为那人对我们说：『你们的兄弟若不与你们同来，你们就不得见我的面。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","以色列说：「你们为什么这样害我，告诉那人你们还有兄弟呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","他们回答说：「那人详细问到我们和我们的亲属，说：『你们的父亲还在吗？你们还有兄弟吗？』我们就按着他所问的告诉他，焉能知道他要说『必须把你们的兄弟带下来』呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","犹大又对他父亲以色列说：「你打发童子与我同去，我们就起身下去，好叫我们和你，并我们的妇人孩子，都得存活，不至于死。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","我为他作保；你可以从我手中追讨，我若不带他回来交在你面前，我情愿永远担罪。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","我们若没有耽搁，如今第二次都回来了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","他们的父亲以色列说：「若必须如此，你们就当这样行：可以将这地土产中最好的乳香、蜂蜜、香料、没药、榧子、杏仁都取一点，收在器具里，带下去送给那人作礼物， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","又要手里加倍地带银子，并将归还在你们口袋内的银子仍带在手里；那或者是错了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","也带着你们的兄弟，起身去见那人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","但愿全能的　神使你们在那人面前蒙怜悯，释放你们的那弟兄和便雅悯回来。我若丧了儿子，就丧了吧！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","于是，他们拿着那礼物，又手里加倍地带银子，并且带着便雅悯，起身下到埃及，站在约瑟面前。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","约瑟见便雅悯和他们同来，就对家宰说：「将这些人领到屋里。要宰杀牲畜，预备筵席，因为晌午这些人同我吃饭。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","家宰就遵着约瑟的命去行，领他们进约瑟的屋里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","他们因为被领到约瑟的屋里，就害怕，说：「领我们到这里来，必是因为头次归还在我们口袋里的银子，找我们的错缝，下手害我们，强取我们为奴仆，抢夺我们的驴。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","他们就挨近约瑟的家宰，在屋门口和他说话， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","说：「我主啊，我们头次下来实在是要籴粮。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","后来到了住宿的地方，我们打开口袋，不料，各人的银子，分量足数，仍在各人的口袋内，现在我们手里又带回来了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","另外又带下银子来籴粮。不知道先前谁把银子放在我们的口袋里。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","家宰说：「你们可以放心，不要害怕，是你们的　神和你们父亲的　神赐给你们财宝在你们的口袋里；你们的银子，我早已收了。」他就把西缅带出来，交给他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","家宰就领他们进约瑟的屋里，给他们水洗脚，又给他们草料喂驴。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","他们就预备那礼物，等候约瑟晌午来，因为他们听见要在那里吃饭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","约瑟来到家里，他们就把手中的礼物拿进屋去给他，又俯伏在地，向他下拜。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","约瑟问他们好，又问：「你们的父亲—就是你们所说的那老人家平安吗？他还在吗？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","他们回答说：「你仆人—我们的父亲平安；他还在。」于是他们低头下拜。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","约瑟举目看见他同母的兄弟便雅悯，就说：「你们向我所说那顶小的兄弟就是这位吗？」又说：「小儿啊，愿　神赐恩给你！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","约瑟爱弟之情发动，就急忙寻找可哭之地，进入自己的屋里，哭了一场。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","他洗了脸出来，勉强隐忍，吩咐人摆饭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","他们就为约瑟单摆了一席，为那些人又摆了一席，也为和约瑟同吃饭的埃及人另摆了一席，因为埃及人不可和希伯来人一同吃饭；那原是埃及人所厌恶的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","约瑟使众弟兄在他面前排列坐席，都按着长幼的次序，众弟兄就彼此诧异。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","约瑟把他面前的食物分出来，送给他们；但便雅悯所得的比别人多五倍。他们就饮酒，和约瑟一同宴乐。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","约瑟吩咐家宰说：「把粮食装满这些人的口袋，尽着他们的驴所能驮的，又把各人的银子放在各人的口袋里， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","并将我的银杯和那少年人籴粮的银子一同装在他的口袋里。」家宰就照约瑟所说的话行了； ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","天一亮就打发那些人带着驴走了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","他们出城走了不远，约瑟对家宰说：「起来，追那些人去，追上了就对他们说：『你们为什么以恶报善呢？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","这不是我主人饮酒的杯吗？岂不是他占卜用的吗？你们这样行是作恶了。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","家宰追上他们，将这些话对他们说了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","他们回答说：「我主为什么说这样的话呢？你仆人断不能做这样的事。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","你看，我们从前在口袋里所见的银子，尚且从迦南地带来还你，我们怎能从你主人家里偷窃金银呢？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","你仆人中无论在谁那里搜出来，就叫他死，我们也作我主的奴仆。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","家宰说：「现在就照你们的话行吧！在谁那里搜出来，谁就作我的奴仆；其余的都没有罪。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","于是他们各人急忙把口袋卸在地上，各人打开口袋。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","家宰就搜查，从年长的起到年幼的为止，那杯竟在便雅悯的口袋里搜出来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","他们就撕裂衣服，各人把驮子抬在驴上，回城去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","犹大和他弟兄们来到约瑟的屋中，约瑟还在那里，他们就在他面前俯伏于地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","约瑟对他们说：「你们做的是什么事呢？你们岂不知像我这样的人必能占卜吗？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","犹大说：「我们对我主说什么呢？还有什么话可说呢？我们怎能自己表白出来呢？　神已经查出仆人的罪孽了。我们与那在他手中搜出杯来的都是我主的奴仆。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","约瑟说：「我断不能这样行！在谁的手中搜出杯来，谁就作我的奴仆；至于你们，可以平平安安地上你们父亲那里去。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","犹大挨近他，说：「我主啊，求你容仆人说一句话给我主听，不要向仆人发烈怒，因为你如同法老一样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","我主曾问仆人们说：『你们有父亲有兄弟没有？』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","我们对我主说：『我们有父亲，已经年老，还有他老年所生的一个小孩子。他哥哥死了，他母亲只撇下他一人，他父亲疼爱他。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","你对仆人说：『把他带到我这里来，叫我亲眼看看他。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","我们对我主说：『童子不能离开他父亲，若是离开，他父亲必死。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","你对仆人说：『你们的小兄弟若不与你们一同下来，你们就不得再见我的面。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","我们上到你仆人—我们父亲那里，就把我主的话告诉了他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","我们的父亲说：『你们再去给我籴些粮来。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","我们就说：『我们不能下去。我们的小兄弟若和我们同往，我们就可以下去。因为，小兄弟若不与我们同往，我们必不得见那人的面。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","你仆人—我父亲对我们说：『你们知道我的妻子给我生了两个儿子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","一个离开我出去了；我说他必是被撕碎了，直到如今我也没有见他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","现在你们又要把这个带去离开我，倘若他遭害，那便是你们使我白发苍苍、悲悲惨惨地下阴间去了。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","我父亲的命与这童子的命相连。如今我回到你仆人—我父亲那里，若没有童子与我们同在， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","我们的父亲见没有童子，他就必死。这便是我们使你仆人—我们的父亲白发苍苍、悲悲惨惨地下阴间去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","因为仆人曾向我父亲为这童子作保，说：『我若不带他回来交给父亲，我便在父亲面前永远担罪。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","现在求你容仆人住下，替这童子作我主的奴仆，叫童子和他哥哥们一同上去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","若童子不和我同去，我怎能上去见我父亲呢？恐怕我看见灾祸临到我父亲身上。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","约瑟在左右站着的人面前情不自禁，吩咐一声说：「人都要离开我出去！」约瑟和弟兄们相认的时候并没有一人站在他面前。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","他就放声大哭；埃及人和法老家中的人都听见了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","约瑟对他弟兄们说：「我是约瑟。我的父亲还在吗？」他弟兄不能回答，因为在他面前都惊惶。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","约瑟又对他弟兄们说：「请你们近前来。」他们就近前来。他说：「我是你们的兄弟约瑟，就是你们所卖到埃及的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","现在，不要因为把我卖到这里自忧自恨。这是　神差我在你们以先来，为要保全生命。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","现在这地的饥荒已经二年了，还有五年不能耕种，不能收成。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","神差我在你们以先来，为要给你们存留余种在世上，又要大施拯救，保全你们的生命。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","这样看来，差我到这里来的不是你们，乃是　神。他又使我如法老的父，作他全家的主，并埃及全地的宰相。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","你们要赶紧上到我父亲那里，对他说：『你儿子约瑟这样说：　神使我作全埃及的主，请你下到我这里来，不要耽延。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","你和你的儿子孙子，连牛群羊群，并一切所有的，都可以住在歌珊地，与我相近。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","我要在那里奉养你；因为还有五年的饥荒，免得你和你的眷属，并一切所有的，都败落了。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","况且你们的眼和我兄弟便雅悯的眼都看见是我亲口对你们说话。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","你们也要将我在埃及一切的荣耀和你们所看见的事都告诉我父亲，又要赶紧地将我父亲搬到我这里来。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","于是约瑟伏在他兄弟便雅悯的颈项上哭，便雅悯也在他的颈项上哭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","他又与众弟兄亲嘴，抱着他们哭，随后他弟兄们就和他说话。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","这风声传到法老的宫里，说：「约瑟的弟兄们来了。」法老和他的臣仆都很喜欢。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","法老对约瑟说：「你吩咐你的弟兄们说：『你们要这样行：把驮子抬在牲口上，起身往迦南地去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","将你们的父亲和你们的眷属都搬到我这里来，我要把埃及地的美物赐给你们，你们也要吃这地肥美的出产。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","现在我吩咐你们要这样行：从埃及地带着车辆去，把你们的孩子和妻子，并你们的父亲都搬来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","你们眼中不要爱惜你们的家具，因为埃及全地的美物都是你们的。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","以色列的儿子们就如此行。约瑟照着法老的吩咐给他们车辆和路上用的食物， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","又给他们各人一套衣服，惟独给便雅悯三百银子，五套衣服； ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","送给他父亲公驴十匹，驮着埃及的美物，母驴十匹，驮着粮食与饼和菜，为他父亲路上用。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","于是约瑟打发他弟兄们回去，又对他们说：「你们不要在路上相争。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","他们从埃及上去，来到迦南地、他们的父亲雅各那里， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","告诉他说：「约瑟还在，并且作埃及全地的宰相。」雅各心里冰凉，因为不信他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","他们便将约瑟对他们说的一切话都告诉了他。他们父亲雅各又看见约瑟打发来接他的车辆，心就苏醒了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","以色列说：「罢了！罢了！我的儿子约瑟还在，趁我未死以先，我要去见他一面。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","以色列带着一切所有的，起身来到别是巴，就献祭给他父亲以撒的　神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","夜间，　神在异象中对以色列说：「雅各！雅各！」他说：「我在这里。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","神说：「我是　神，就是你父亲的　神。你下埃及去不要害怕，因为我必使你在那里成为大族。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","我要和你同下埃及去，也必定带你上来；约瑟必给你送终。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","雅各就从别是巴起行。以色列的儿子们使他们的父亲雅各和他们的妻子、儿女都坐在法老为雅各送来的车上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","他们又带着迦南地所得的牲畜、货财来到埃及。雅各和他的一切子孙都一同来了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","雅各把他的儿子、孙子、女儿、孙女，并他的子子孙孙，一同带到埃及。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","来到埃及的以色列人名字记在下面。雅各和他的儿孙：雅各的长子是吕便。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","吕便的儿子是哈诺、法路、希斯伦、迦米。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","西缅的儿子是耶母利、雅悯、阿辖、雅斤、琐辖，还有迦南女子所生的扫罗。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","利未的儿子是革顺、哥辖、米拉利。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","犹大的儿子是珥、俄南、示拉、法勒斯、谢拉；惟有珥与俄南死在迦南地。法勒斯的儿子是希斯 、哈母勒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","以萨迦的儿子是陀拉、普瓦、约伯、伸 。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","西布伦的儿子是西烈、以伦、雅利。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","这是利亚在巴旦·亚兰给雅各所生的儿子，还有女儿底拿。儿孙共有三十三人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","迦得的儿子是洗非芸、哈基、书尼、以斯本、以利、亚罗底、亚列利。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","亚设的儿子是音拿、亦施瓦、亦施韦、比利亚，还有他们的妹子西拉。比利亚的儿子是希别、玛结。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","这是拉班给他女儿利亚的婢女悉帕从雅各所生的儿孙，共有十六人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","雅各之妻拉结的儿子是约瑟和便雅悯。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","约瑟在埃及地生了玛拿西和以法莲，就是安城的祭司波提非拉的女儿亚西纳给约瑟生的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","便雅悯的儿子是比拉、比结、亚实别、基拉、乃幔、以希、罗实、母平、户平、亚勒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","这是拉结给雅各所生的儿孙，共有十四人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","但的儿子是户伸。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","拿弗他利的儿子是雅薛、沽尼、耶色、示冷。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","这是拉班给他女儿拉结的婢女辟拉从雅各所生的儿孙，共有七人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","那与雅各同到埃及的，除了他儿妇之外，凡从他所生的，共有六十六人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","还有约瑟在埃及所生的两个儿子。雅各家来到埃及的共有七十人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","雅各打发犹大先去见约瑟，请派人引路往歌珊去；于是他们来到歌珊地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","约瑟套车往歌珊去，迎接他父亲以色列，及至见了面，就伏在父亲的颈项上，哭了许久。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","以色列对约瑟说：「我既得见你的面，知道你还在，就是死我也甘心。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","约瑟对他的弟兄和他父的全家说：「我要上去告诉法老，对他说：『我的弟兄和我父的全家从前在迦南地，现今都到我这里来了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","他们本是牧羊的人，以养牲畜为业；他们把羊群牛群和一切所有的都带来了。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","等法老召你们的时候，问你们说：『你们以何事为业？』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","你们要说：『你的仆人，从幼年直到如今，都以养牲畜为业，连我们的祖宗也都以此为业。』这样，你们可以住在歌珊地，因为凡牧羊的都被埃及人所厌恶。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","约瑟进去告诉法老说：「我的父亲和我的弟兄带着羊群牛群，并一切所有的，从迦南地来了，如今在歌珊地。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","约瑟从他弟兄中挑出五个人来，引他们去见法老。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","法老问约瑟的弟兄说：「你们以何事为业？」他们对法老说：「你仆人是牧羊的，连我们的祖宗也是牧羊的。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","他们又对法老说：「迦南地的饥荒甚大，仆人的羊群没有草吃，所以我们来到这地寄居。现在求你容仆人住在歌珊地。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","法老对约瑟说：「你父亲和你弟兄到你这里来了， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","埃及地都在你面前，只管叫你父亲和你弟兄住在国中最好的地；他们可以住在歌珊地。你若知道他们中间有什么能人，就派他们看管我的牲畜。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","约瑟领他父亲雅各进到法老面前，雅各就给法老祝福。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","法老问雅各说：「你平生的年日是多少呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","雅各对法老说：「我寄居在世的年日是一百三十岁，我平生的年日又少又苦，不及我列祖在世寄居的年日。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","雅各又给法老祝福，就从法老面前出去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","约瑟遵着法老的命，把埃及国最好的地，就是兰塞境内的地，给他父亲和弟兄居住，作为产业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","约瑟用粮食奉养他父亲和他弟兄，并他父亲全家的眷属，都是照各家的人口奉养他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","饥荒甚大，全地都绝了粮，甚至埃及地和迦南地的人因那饥荒的缘故都饿昏了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","约瑟收聚了埃及地和迦南地所有的银子，就是众人籴粮的银子，约瑟就把那银子带到法老的宫里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","埃及地和迦南地的银子都花尽了，埃及众人都来见约瑟，说：「我们的银子都用尽了，求你给我们粮食，我们为什么死在你面前呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","约瑟说：「若是银子用尽了，可以把你们的牲畜给我，我就为你们的牲畜给你们粮食。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","于是他们把牲畜赶到约瑟那里，约瑟就拿粮食换了他们的牛、羊、驴、马；那一年因换他们一切的牲畜，就用粮食养活他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","那一年过去，第二年他们又来见约瑟，说：「我们不瞒我主，我们的银子都花尽了，牲畜也都归了我主。我们在我主眼前，除了我们的身体和田地之外，一无所剩。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","你何忍见我们人死地荒呢？求你用粮食买我们和我们的地，我们和我们的地就要给法老效力。又求你给我们种子，使我们得以存活，不至死亡，地土也不至荒凉。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","于是，约瑟为法老买了埃及所有的地，埃及人因被饥荒所迫，各都卖了自己的田地；那地就都归了法老。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","至于百姓，约瑟叫他们，从埃及这边直到埃及那边，都各归各城。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","惟有祭司的地，约瑟没有买，因为祭司有从法老所得的常俸。他们吃法老所给的常俸，所以他们不卖自己的地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","约瑟对百姓说：「我今日为法老买了你们和你们的地，看哪，这里有种子给你们，你们可以种地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","后来打粮食的时候，你们要把五分之一纳给法老，四分可以归你们做地里的种子，也做你们和你们家口孩童的食物。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","他们说：「你救了我们的性命。但愿我们在我主眼前蒙恩，我们就作法老的仆人。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","于是约瑟为埃及地定下常例，直到今日：法老必得五分之一，惟独祭司的地不归法老。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","以色列人住在埃及的歌珊地。他们在那里置了产业，并且生育甚多。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","雅各住在埃及地十七年，雅各平生的年日是一百四十七岁。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","以色列的死期临近了，他就叫了他儿子约瑟来，说：「我若在你眼前蒙恩，请你把手放在我大腿底下，用慈爱和诚实待我，请你不要将我葬在埃及。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","我与我祖我父同睡的时候，你要将我带出埃及，葬在他们所葬的地方。」约瑟说：「我必遵着你的命而行。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","雅各说：「你要向我起誓。」约瑟就向他起了誓，于是以色列在床头上敬拜　神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","这事以后，有人告诉约瑟说：「你的父亲病了。」他就带着两个儿子玛拿西和以法莲同去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","有人告诉雅各说：「请看，你儿子约瑟到你这里来了。」以色列就勉强在床上坐起来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","雅各对约瑟说：「全能的　神曾在迦南地的路斯向我显现，赐福与我， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","对我说：『我必使你生养众多，成为多民，又要把这地赐给你的后裔，永远为业。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","我未到埃及见你之先，你在埃及地所生的以法莲和玛拿西这两个儿子是我的，正如吕便和西缅是我的一样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","你在他们以后所生的就是你的，他们可以归于他们弟兄的名下得产业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","至于我，我从巴旦来的时候，拉结死在我眼前，在迦南地的路上，离以法他还有一段路程，我就把她葬在以法他的路上（以法他就是伯利恒）。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","以色列看见约瑟的两个儿子，就说：「这是谁？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","约瑟对他父亲说：「这是　神在这里赐给我的儿子。」以色列说：「请你领他们到我跟前，我要给他们祝福。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","以色列年纪老迈，眼睛昏花，不能看见。约瑟领他们到他跟前，他就和他们亲嘴，抱着他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","以色列对约瑟说：「我想不到得见你的面，不料，　神又使我得见你的儿子。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","约瑟把两个儿子从以色列两膝中领出来，自己就脸伏于地下拜。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","随后，约瑟又拉着他们两个，以法莲在他的右手里，对着以色列的左手，玛拿西在他的左手里，对着以色列的右手，领他们到以色列的跟前。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","以色列伸出右手来，按在以法莲的头上（以法莲乃是次子），又剪搭过左手来，按在玛拿西的头上（玛拿西原是长子）。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","他就给约瑟祝福说：「愿我祖亚伯拉罕和我父以撒所事奉的　神，就是一生牧养我直到今日的　神， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","救赎我脱离一切患难的那使者，赐福与这两个童子。愿他们归在我的名下和我祖亚伯拉罕、我父以撒的名下。又愿他们在世界中生养众多。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","约瑟见他父亲把右手按在以法莲的头上，就不喜悦，便提起他父亲的手，要从以法莲头上挪到玛拿西的头上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","约瑟对他父亲说：「我父，不是这样。这本是长子，求你把右手按在他的头上。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","他父亲不从，说：「我知道，我儿，我知道。他也必成为一族，也必昌大。只是他的兄弟将来比他还大；他兄弟的后裔要成为多族。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","当日就给他们祝福说：「以色列人要指着你们祝福说：『愿　神使你如以法莲、玛拿西一样。』」于是立以法莲在玛拿西以上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","以色列又对约瑟说：「我要死了，但　神必与你们同在，领你们回到你们列祖之地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","并且我从前用弓用刀从亚摩利人手下夺的那块地，我都赐给你，使你比众弟兄多得一分。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","雅各叫了他的儿子们来，说：「你们都来聚集，我好把你们日后必遇的事告诉你们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","雅各的儿子们，你们要聚集而听， 要听你们父亲以色列的话。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","吕便哪，你是我的长子， 是我力量强壮的时候生的， 本当大有尊荣，权力超众。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","但你放纵情欲，滚沸如水， 必不得居首位； 因为你上了你父亲的床， 污秽了我的榻。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","西缅和利未是弟兄； 他们的刀剑是残忍的器具。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","我的灵啊，不要与他们同谋； 我的心哪，不要与他们联络； 因为他们趁怒杀害人命， 任意砍断牛腿大筋。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","他们的怒气暴烈可咒； 他们的忿恨残忍可诅。 我要使他们分居在雅各家里， 散住在以色列地中。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","犹大啊，你弟兄们必赞美你； 你手必掐住仇敌的颈项； 你父亲的儿子们必向你下拜。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","犹大是个小狮子； 我儿啊，你抓了食便上去。 你屈下身去，卧如公狮， 蹲如母狮，谁敢惹你？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","圭必不离犹大， 杖必不离他两脚之间， 直等细罗来到， 万民都必归顺。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","犹大把小驴拴在葡萄树上， 把驴驹拴在美好的葡萄树上。 他在葡萄酒中洗了衣服， 在葡萄汁中洗了袍褂。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","他的眼睛必因酒红润； 他的牙齿必因奶白亮。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","西布伦必住在海口， 必成为停船的海口； 他的境界必延到西顿。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","以萨迦是个强壮的驴， 卧在羊圈之中。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","他以安静为佳，以肥地为美， 便低肩背重，成为服苦的仆人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","但必判断他的民， 作以色列支派之一。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","但必作道上的蛇，路中的虺， 咬伤马蹄，使骑马的坠落于后。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","耶和华啊，我向来等候你的救恩。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","迦得必被敌军追逼， 他却要追逼他们的脚跟。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","亚设之地必出肥美的粮食， 且出君王的美味。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","拿弗他利是被释放的母鹿； 他出嘉美的言语。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","约瑟是多结果子的树枝， 是泉旁多结果的枝子； 他的枝条探出墙外。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","弓箭手将他苦害， 向他射箭，逼迫他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","但他的弓仍旧坚硬； 他的手健壮敏捷。 这是因以色列的牧者，以色列的磐石— 就是雅各的大能者。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","你父亲的　神必帮助你； 那全能者必将天上所有的福， 地里所藏的福，以及生产乳养的福，都赐给你。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","你父亲所祝的福 胜过我祖先所祝的福， 如永世的山岭，至极的边界； 这些福必降在约瑟的头上， 临到那与弟兄迥别之人的顶上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","便雅悯是个撕掠的狼， 早晨要吃他所抓的， 晚上要分他所夺的。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","这一切是以色列的十二支派；这也是他们的父亲对他们所说的话，为他们所祝的福，都是按着各人的福分为他们祝福。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","他又嘱咐他们说：「我将要归到我列祖那里，你们要将我葬在赫人以弗 田间的洞里，与我祖我父在一处， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","就是在迦南地幔利前、麦比拉田间的洞；那洞和田是亚伯拉罕向赫人以弗 买来为业，作坟地的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","他们在那里葬了亚伯拉罕和他妻子撒拉，又在那里葬了以撒和他的妻子利百加；我也在那里葬了利亚。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","那块田和田间的洞原是向赫人买的。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","雅各嘱咐众子已毕，就把脚收在床上，气绝而死，归他列祖那里去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","约瑟伏在他父亲的面上哀哭，与他亲嘴。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","约瑟吩咐伺候他的医生用香料薰他父亲，医生就用香料薰了以色列。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","薰尸的常例是四十天；那四十天满了，埃及人为他哀哭了七十天。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","为他哀哭的日子过了，约瑟对法老家中的人说：「我若在你们眼前蒙恩，请你们报告法老说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","『我父亲要死的时候叫我起誓说：你要将我葬在迦南地，在我为自己所掘的坟墓里。』现在求你让我上去葬我父亲，以后我必回来。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","法老说：「你可以上去，照着你父亲叫你起的誓，将他葬埋。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","于是约瑟上去葬他父亲。与他一同上去的，有法老的臣仆和法老家中的长老，并埃及国的长老， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","还有约瑟的全家和他的弟兄们，并他父亲的眷属；只有他们的妇人孩子，和羊群牛群，都留在歌珊地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","又有车辆马兵，和他一同上去；那一帮人甚多。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","他们到了约旦河外、亚达的禾场，就在那里大大地号咷痛哭。约瑟为他父亲哀哭了七天。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","迦南的居民见亚达禾场上的哀哭，就说：「这是埃及人一场极大的哀哭。」因此那地方名叫亚伯·麦西，是在约旦河东。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","雅各的儿子们就遵着他父亲所吩咐的办了， ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","把他搬到迦南地，葬在幔利前、麦比拉田间的洞里；那洞和田是亚伯拉罕向赫人以弗 买来为业，作坟地的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","约瑟葬了他父亲以后，就和众弟兄，并一切同他上去葬他父亲的人，都回埃及去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","约瑟的哥哥们见父亲死了，就说：「或者约瑟怀恨我们，照着我们从前待他一切的恶足足地报复我们。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","他们就打发人去见约瑟，说：「你父亲未死以先吩咐说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","『你们要对约瑟这样说：从前你哥哥们恶待你，求你饶恕他们的过犯和罪恶。』如今求你饶恕你父亲　神之仆人的过犯。」他们对约瑟说这话，约瑟就哭了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","他的哥哥们又来俯伏在他面前，说：「我们是你的仆人。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","约瑟对他们说：「不要害怕，我岂能代替　神呢？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","从前你们的意思是要害我，但　神的意思原是好的，要保全许多人的性命，成就今日的光景。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","现在你们不要害怕，我必养活你们和你们的妇人孩子。」于是约瑟用亲爱的话安慰他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","约瑟和他父亲的眷属都住在埃及。约瑟活了一百一十岁。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","约瑟得见以法莲第三代的子孙。玛拿西的孙子、玛吉的儿子也养在约瑟的膝上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","约瑟对他弟兄们说：「我要死了，但　神必定看顾你们，领你们从这地上去，到他起誓所应许给亚伯拉罕、以撒、雅各之地。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","约瑟叫以色列的子孙起誓说：「　神必定看顾你们；你们要把我的骸骨从这里搬上去。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","约瑟死了，正一百一十岁。人用香料将他薰了，把他收殓在棺材里，停在埃及。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","以色列的众子，各带家眷，和雅各一同来到埃及。他们的名字记在下面。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","有吕便、西缅、利未、犹大、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","以萨迦、西布伦、便雅悯、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","但、拿弗他利、迦得、亚设。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","凡从雅各而生的，共有七十人。约瑟已经在埃及。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","约瑟和他的弟兄，并那一代的人，都死了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","以色列人生养众多，并且繁茂，极其强盛，满了那地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","有不认识约瑟的新王起来，治理埃及， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","对他的百姓说：「看哪，这以色列民比我们还多，又比我们强盛。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","来吧，我们不如用巧计待他们，恐怕他们多起来，日后若遇什么争战的事，就连合我们的仇敌攻击我们，离开这地去了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","于是埃及人派督工的辖制他们，加重担苦害他们。他们为法老建造两座积货城，就是比东和兰塞。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","只是越发苦害他们，他们越发多起来，越发蔓延；埃及人就因以色列人愁烦。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","埃及人严严地使以色列人做工， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","使他们因做苦工觉得命苦；无论是和泥，是做砖，是做田间各样的工，在一切的工上都严严地待他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","有希伯来的两个收生婆，一名施弗拉，一名普阿；埃及王对她们说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","「你们为希伯来妇人收生，看她们临盆的时候，若是男孩，就把他杀了；若是女孩，就留她存活。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","但是收生婆敬畏　神，不照埃及王的吩咐行，竟存留男孩的性命。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","埃及王召了收生婆来，说：「你们为什么做这事，存留男孩的性命呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","收生婆对法老说：「因为希伯来妇人与埃及妇人不同；希伯来妇人本是健壮的，收生婆还没有到，她们已经生产了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","神厚待收生婆。以色列人多起来，极其强盛。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","收生婆因为敬畏　神，　神便叫她们成立家室。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","法老吩咐他的众民说：「以色列人所生的男孩，你们都要丢在河里；一切的女孩，你们要存留她的性命。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","有一个利未家的人娶了一个利未女子为妻。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","那女人怀孕，生一个儿子，见他俊美，就藏了他三个月， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","后来不能再藏，就取了一个蒲草箱，抹上石漆和石油，将孩子放在里头，把箱子搁在河边的芦荻中。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","孩子的姊姊远远站着，要知道他究竟怎么样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","法老的女儿来到河边洗澡，她的使女们在河边行走。她看见箱子在芦荻中，就打发一个婢女拿来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","她打开箱子，看见那孩子。孩子哭了，她就可怜他，说：「这是希伯来人的一个孩子。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","孩子的姊姊对法老的女儿说：「我去在希伯来妇人中叫一个奶妈来，为你奶这孩子，可以不可以？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","法老的女儿说：「可以。」童女就去叫了孩子的母亲来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","法老的女儿对她说：「你把这孩子抱去，为我奶他，我必给你工价。」妇人就抱了孩子去奶他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","孩子渐长，妇人把他带到法老的女儿那里，就作了她的儿子。她给孩子起名叫摩西，意思说：「因我把他从水里拉出来。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","后来，摩西长大，他出去到他弟兄那里，看他们的重担，见一个埃及人打希伯来人的一个弟兄。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","他左右观看，见没有人，就把埃及人打死了，藏在沙土里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","第二天他出去，见有两个希伯来人争斗，就对那欺负人的说：「你为什么打你同族的人呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","那人说：「谁立你作我们的首领和审判官呢？难道你要杀我，像杀那埃及人吗？」摩西便惧怕，说：「这事必是被人知道了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","法老听见这事，就想杀摩西，但摩西躲避法老，逃往米甸地居住。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","一日，他在井旁坐下。米甸的祭司有七个女儿；她们来打水，打满了槽，要饮父亲的群羊。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","有牧羊的人来，把她们赶走了，摩西却起来帮助她们，又饮了她们的群羊。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","她们来到父亲流珥那里；他说：「今日你们为何来得这么快呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","她们说：「有一个埃及人救我们脱离牧羊人的手，并且为我们打水饮了群羊。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","他对女儿们说：「那个人在哪里？你们为什么撇下他呢？你们去请他来吃饭。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","摩西甘心和那人同住；那人把他的女儿西坡拉给摩西为妻。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","西坡拉生了一个儿子，摩西给他起名叫革舜，意思说：「因我在外邦作了寄居的。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","过了多年，埃及王死了。以色列人因做苦工，就叹息哀求，他们的哀声达于　神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","神听见他们的哀声，就记念他与亚伯拉罕、以撒、雅各所立的约。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","神看顾以色列人，也知道他们的苦情。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","摩西牧养他岳父米甸祭司叶忒罗的羊群；一日领羊群往野外去，到了　神的山，就是何烈山。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","耶和华的使者从荆棘里火焰中向摩西显现。摩西观看，不料，荆棘被火烧着，却没有烧毁。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","摩西说：「我要过去看这大异象，这荆棘为何没有烧坏呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","耶和华　神见他过去要看，就从荆棘里呼叫说：「摩西！摩西！」他说：「我在这里。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","神说：「不要近前来。当把你脚上的鞋脱下来，因为你所站之地是圣地」； ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","又说：「我是你父亲的　神，是亚伯拉罕的　神，以撒的　神，雅各的　神。」摩西蒙上脸，因为怕看　神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","耶和华说：「我的百姓在埃及所受的困苦，我实在看见了；他们因受督工的辖制所发的哀声，我也听见了。我原知道他们的痛苦， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","我下来是要救他们脱离埃及人的手，领他们出了那地，到美好、宽阔、流奶与蜜之地，就是到迦南人、赫人、亚摩利人、比利洗人、希未人、耶布斯人之地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","现在以色列人的哀声达到我耳中，我也看见埃及人怎样欺压他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","故此，我要打发你去见法老，使你可以将我的百姓以色列人从埃及领出来。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","摩西对　神说：「我是什么人，竟能去见法老，将以色列人从埃及领出来呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","神说：「我必与你同在。你将百姓从埃及领出来之后，你们必在这山上事奉我；这就是我打发你去的证据。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","摩西对　神说：「我到以色列人那里，对他们说：『你们祖宗的　神打发我到你们这里来。』他们若问我说：『他叫什么名字？』我要对他们说什么呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","神对摩西说：「我是自有永有的」；又说：「你要对以色列人这样说：『那自有的打发我到你们这里来。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","神又对摩西说：「你要对以色列人这样说：『耶和华—你们祖宗的　神，就是亚伯拉罕的　神，以撒的　神，雅各的　神，打发我到你们这里来。』耶和华是我的名，直到永远；这也是我的纪念，直到万代。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","你去招聚以色列的长老，对他们说：『耶和华—你们祖宗的　神，就是亚伯拉罕的　神，以撒的　神，雅各的　神，向我显现，说：我实在眷顾了你们，我也看见埃及人怎样待你们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","我也说：要将你们从埃及的困苦中领出来，往迦南人、赫人、亚摩利人、比利洗人、希未人、耶布斯人的地去，就是到流奶与蜜之地。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","他们必听你的话。你和以色列的长老要去见埃及王，对他说：『耶和华—希伯来人的　神遇见了我们，现在求你容我们往旷野去，走三天的路程，为要祭祀耶和华—我们的　神。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","我知道虽用大能的手，埃及王也不容你们去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","我必伸手在埃及中间施行我一切的奇事，攻击那地，然后他才容你们去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","我必叫你们在埃及人眼前蒙恩，你们去的时候就不至于空手而去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","但各妇女必向她的邻舍，并居住在她家里的女人，要金器银器和衣裳，好给你们的儿女穿戴。这样你们就把埃及人的财物夺去了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","摩西回答说：「他们必不信我，也不听我的话，必说：『耶和华并没有向你显现。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","耶和华对摩西说：「你手里是什么？」他说：「是杖。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","耶和华说：「丢在地上。」他一丢下去，就变作蛇；摩西便跑开。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","耶和华对摩西说：「伸出手来，拿住它的尾巴，它必在你手中仍变为杖； ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","如此好叫他们信耶和华—他们祖宗的　神，就是亚伯拉罕的　神，以撒的　神，雅各的　神，是向你显现了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","耶和华又对他说：「把手放在怀里。」他就把手放在怀里，及至抽出来，不料，手长了大麻风，有雪那样白。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","耶和华说：「再把手放在怀里。」他就再把手放在怀里，及至从怀里抽出来，不料，手已经复原，与周身的肉一样； ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","又说：「倘或他们不听你的话，也不信头一个神迹，他们必信第二个神迹。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","这两个神迹若都不信，也不听你的话，你就从河里取些水，倒在旱地上，你从河里取的水必在旱地上变作血。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","摩西对耶和华说：「主啊，我素日不是能言的人，就是从你对仆人说话以后，也是这样。我本是拙口笨舌的。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","耶和华对他说：「谁造人的口呢？谁使人口哑、耳聋、目明、眼瞎呢？岂不是我—耶和华吗？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","现在去吧，我必赐你口才，指教你所当说的话。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","摩西说：「主啊，你愿意打发谁，就打发谁去吧！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","耶和华向摩西发怒说：「不是有你的哥哥利未人亚伦吗？我知道他是能言的；现在他出来迎接你，他一见你，心里就欢喜。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","你要将当说的话传给他；我也要赐你和他口才，又要指教你们所当行的事。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","他要替你对百姓说话；你要以他当作口，他要以你当作　神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","你手里要拿这杖，好行神迹。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","于是，摩西回到他岳父叶忒罗那里，对他说：「求你容我回去见我在埃及的弟兄，看他们还在不在。」叶忒罗对摩西说：「你可以平平安安地去吧！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","耶和华在米甸对摩西说：「你要回埃及去，因为寻索你命的人都死了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","摩西就带着妻子和两个儿子，叫他们骑上驴，回埃及地去。摩西手里拿着　神的杖。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","耶和华对摩西说：「你回到埃及的时候，要留意将我指示你的一切奇事行在法老面前。但我要使他的心刚硬，他必不容百姓去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","你要对法老说：『耶和华这样说：以色列是我的儿子，我的长子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","我对你说过：容我的儿子去，好事奉我。你还是不肯容他去。看哪，我要杀你的长子。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","摩西在路上住宿的地方，耶和华遇见他，想要杀他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","西坡拉就拿一块火石，割下他儿子的阳皮，丢在摩西脚前，说：「你真是我的血郎了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","这样，耶和华才放了他。西坡拉说：「你因割礼就是血郎了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","耶和华对亚伦说：「你往旷野去迎接摩西。」他就去，在　神的山遇见摩西，和他亲嘴。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","摩西将耶和华打发他所说的言语和嘱咐他所行的神迹都告诉了亚伦。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","摩西、亚伦就去招聚以色列的众长老。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","亚伦将耶和华对摩西所说的一切话述说了一遍，又在百姓眼前行了那些神迹， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","百姓就信了。以色列人听见耶和华眷顾他们，鉴察他们的困苦，就低头下拜。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","后来摩西、亚伦去对法老说：「耶和华—以色列的　神这样说：『容我的百姓去，在旷野向我守节。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","法老说：「耶和华是谁，使我听他的话，容以色列人去呢？我不认识耶和华，也不容以色列人去！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","他们说：「希伯来人的　神遇见了我们。求你容我们往旷野去，走三天的路程，祭祀耶和华—我们的　神，免得他用瘟疫、刀兵攻击我们。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","埃及王对他们说：「摩西、亚伦！你们为什么叫百姓旷工呢？你们去担你们的担子吧！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","又说：「看哪，这地的以色列人如今众多，你们竟叫他们歇下担子！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","当天，法老吩咐督工的和官长说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","「你们不可照常把草给百姓做砖，叫他们自己去捡草。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","他们素常做砖的数目，你们仍旧向他们要，一点不可减少；因为他们是懒惰的，所以呼求说：『容我们去祭祀我们的　神。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","你们要把更重的工夫加在这些人身上，叫他们劳碌，不听虚谎的言语。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","督工的和官长出来对百姓说：「法老这样说：『我不给你们草。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","你们自己在哪里能找草，就往那里去找吧！但你们的工一点不可减少。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","于是百姓散在埃及遍地，捡碎秸当作草。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","督工的催着说：「你们一天当完一天的工，与先前有草一样。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","法老督工的，责打他所派以色列人的官长，说：「你们昨天今天为什么没有照向来的数目做砖、完你们的工作呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","以色列人的官长就来哀求法老说：「为什么这样待你的仆人？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","督工的不把草给仆人，并且对我们说：『做砖吧！』看哪，你仆人挨了打，其实是你百姓的错。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","但法老说：「你们是懒惰的！你们是懒惰的！所以说：『容我们去祭祀耶和华。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","现在你们去做工吧！草是不给你们的，砖却要如数交纳。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","以色列人的官长听说「你们每天做砖的工作一点不可减少」，就知道是遭遇祸患了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","他们离了法老出来，正遇见摩西、亚伦站在对面， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","就向他们说：「愿耶和华鉴察你们，施行判断；因你们使我们在法老和他臣仆面前有了臭名，把刀递在他们手中杀我们。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","摩西回到耶和华那里，说：「主啊，你为什么苦待这百姓呢？为什么打发我去呢？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","自从我去见法老，奉你的名说话，他就苦待这百姓，你一点也没有拯救他们。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","耶和华对摩西说：「现在你必看见我向法老所行的事，使他因我大能的手容以色列人去，且把他们赶出他的地。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","神晓谕摩西说：「我是耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","我从前向亚伯拉罕、以撒、雅各显现为全能的　神；至于我名耶和华，他们未曾知道。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","我与他们坚定所立的约，要把他们寄居的迦南地赐给他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","我也听见以色列人被埃及人苦待的哀声，我也记念我的约。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","所以你要对以色列人说：『我是耶和华；我要用伸出来的膀臂重重地刑罚埃及人，救赎你们脱离他们的重担，不做他们的苦工。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","我要以你们为我的百姓，我也要作你们的　神。你们要知道我是耶和华—你们的　神，是救你们脱离埃及人之重担的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","我起誓应许给亚伯拉罕、以撒、雅各的那地，我要把你们领进去，将那地赐给你们为业。我是耶和华。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","摩西将这话告诉以色列人，只是他们因苦工愁烦，不肯听他的话。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","耶和华晓谕摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","「你进去对埃及王法老说，要容以色列人出他的地。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","摩西在耶和华面前说：「以色列人尚且不听我的话，法老怎肯听我这拙口笨舌的人呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","耶和华吩咐摩西、亚伦往以色列人和埃及王法老那里去，把以色列人从埃及地领出来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","以色列人家长的名字记在下面。以色列长子吕便的儿子是哈诺、法路、希斯伦、迦米；这是吕便的各家。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","西缅的儿子是耶母利、雅悯、阿辖、雅斤、琐辖，和迦南女子的儿子扫罗；这是西缅的各家。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","利未众子的名字按着他们的后代记在下面：就是革顺、哥辖、米拉利。利未一生的岁数是一百三十七岁。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","革顺的儿子按着家室是立尼、示每。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","哥辖的儿子是暗兰、以斯哈、希伯伦、乌薛。哥辖一生的岁数是一百三十三岁。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","米拉利的儿子是抹利和母示；这是利未的家，都按着他们的后代。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","暗兰娶了他父亲的妹妹约基别为妻，她给他生了亚伦和摩西。暗兰一生的岁数是一百三十七岁。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","以斯哈的儿子是可拉、尼斐、细基利。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","乌薛的儿子是米沙利、以利撒反、西提利。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","亚伦娶了亚米拿达的女儿，拿顺的妹妹，以利沙巴为妻，她给他生了拿答、亚比户、以利亚撒、以他玛。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","可拉的儿子是亚惜、以利加拿、亚比亚撒；这是可拉的各家。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","亚伦的儿子以利亚撒娶了普铁的一个女儿为妻，她给他生了非尼哈。这是利未人的家长，都按着他们的家。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","耶和华说：「将以色列人按着他们的军队从埃及地领出来。」这是对那亚伦、摩西说的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","对埃及王法老说要将以色列人从埃及领出来的，就是这摩西、亚伦。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","当耶和华在埃及地对摩西说话的日子， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","他向摩西说：「我是耶和华；我对你说的一切话，你都要告诉埃及王法老。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","摩西在耶和华面前说：「看哪，我是拙口笨舌的人，法老怎肯听我呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","耶和华对摩西说：「我使你在法老面前代替　神，你的哥哥亚伦是替你说话的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","凡我所吩咐你的，你都要说。你的哥哥亚伦要对法老说，容以色列人出他的地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","我要使法老的心刚硬，也要在埃及地多行神迹奇事。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","但法老必不听你们；我要伸手重重地刑罚埃及，将我的军队以色列民从埃及地领出来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","我伸手攻击埃及，将以色列人从他们中间领出来的时候，埃及人就要知道我是耶和华。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","摩西、亚伦这样行；耶和华怎样吩咐他们，他们就照样行了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","摩西、亚伦与法老说话的时候，摩西八十岁，亚伦八十三岁。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","耶和华晓谕摩西、亚伦说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","「法老若对你们说：『你们行件奇事吧！』你就吩咐亚伦说：『把杖丢在法老面前，使杖变作蛇。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","摩西、亚伦进去见法老，就照耶和华所吩咐的行。亚伦把杖丢在法老和臣仆面前，杖就变作蛇。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","于是法老召了博士和术士来；他们是埃及行法术的，也用邪术照样而行。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","他们各人丢下自己的杖，杖就变作蛇；但亚伦的杖吞了他们的杖。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","法老心里刚硬，不肯听从摩西、亚伦，正如耶和华所说的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","耶和华对摩西说：「法老心里固执，不肯容百姓去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","明日早晨，他出来往水边去，你要往河边迎接他，手里要拿着那变过蛇的杖， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","对他说：『耶和华—希伯来人的　神打发我来见你，说：容我的百姓去，好在旷野事奉我。到如今你还是不听。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","耶和华这样说：我要用我手里的杖击打河中的水，水就变作血；因此，你必知道我是耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","河里的鱼必死，河也要腥臭，埃及人就要厌恶吃这河里的水。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","耶和华晓谕摩西说：「你对亚伦说：『把你的杖伸在埃及所有的水以上，就是在他们的江、河、池、塘以上，叫水都变作血。在埃及遍地，无论在木器中，石器中，都必有血。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","摩西、亚伦就照耶和华所吩咐的行。亚伦在法老和臣仆眼前举杖击打河里的水，河里的水都变作血了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","河里的鱼死了，河也腥臭了，埃及人就不能吃这河里的水；埃及遍地都有了血。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","埃及行法术的，也用邪术照样而行。法老心里刚硬，不肯听摩西、亚伦，正如耶和华所说的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","法老转身进宫，也不把这事放在心上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","埃及人都在河的两边挖地，要得水喝，因为他们不能喝这河里的水。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","耶和华击打河以后满了七天。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","耶和华吩咐摩西说：「你进去见法老，对他说：『耶和华这样说：容我的百姓去，好事奉我。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","你若不肯容他们去，我必使青蛙糟蹋你的四境。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","河里要滋生青蛙；这青蛙要上来进你的宫殿和你的卧房，上你的床榻，进你臣仆的房屋，上你百姓的身上，进你的炉灶和你的抟面盆， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","又要上你和你百姓并你众臣仆的身上。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","耶和华晓谕摩西说：「你对亚伦说：『把你的杖伸在江、河、池以上，使青蛙到埃及地上来。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","亚伦便伸杖在埃及的诸水以上，青蛙就上来，遮满了埃及地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","行法术的也用他们的邪术照样而行，叫青蛙上了埃及地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","法老召了摩西、亚伦来，说：「请你们求耶和华使这青蛙离开我和我的民，我就容百姓去祭祀耶和华。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","摩西对法老说：「任凭你吧，我要何时为你和你的臣仆并你的百姓祈求，除灭青蛙离开你和你的宫殿只留在河里呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","他说：「明天。」摩西说：「可以照你的话吧，好叫你知道没有像耶和华—我们　神的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","青蛙要离开你和你的宫殿，并你的臣仆与你的百姓，只留在河里。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","于是摩西、亚伦离开法老出去。摩西为扰害法老的青蛙呼求耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","耶和华就照摩西的话行。凡在房里、院中、田间的青蛙都死了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","众人把青蛙聚拢成堆，遍地就都腥臭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","但法老见灾祸松缓，就硬着心，不肯听他们，正如耶和华所说的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","耶和华吩咐摩西说：「你对亚伦说：『伸出你的杖击打地上的尘土，使尘土在埃及遍地变作虱子。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","他们就这样行。亚伦伸杖击打地上的尘土，就在人身上和牲畜身上有了虱子；埃及遍地的尘土都变成虱子了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","行法术的也用邪术要生出虱子来，却是不能。于是在人身上和牲畜身上都有了虱子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","行法术的就对法老说：「这是　神的手段。」法老心里刚硬，不肯听摩西、亚伦，正如耶和华所说的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","耶和华对摩西说：「你清早起来，法老来到水边，你站在他面前，对他说：『耶和华这样说：容我的百姓去，好事奉我。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","你若不容我的百姓去，我要叫成群的苍蝇到你和你臣仆并你百姓的身上，进你的房屋，并且埃及人的房屋和他们所住的地都要满了成群的苍蝇。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","当那日，我必分别我百姓所住的歌珊地，使那里没有成群的苍蝇，好叫你知道我是天下的耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","我要将我的百姓和你的百姓分别出来。明天必有这神迹。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","耶和华就这样行。苍蝇成了大群，进入法老的宫殿，和他臣仆的房屋；埃及遍地就因这成群的苍蝇败坏了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","法老召了摩西、亚伦来，说：「你们去，在这地祭祀你们的　神吧！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","摩西说：「这样行本不相宜，因为我们要把埃及人所厌恶的祭祀耶和华—我们的　神；若把埃及人所厌恶的在他们眼前献为祭，他们岂不拿石头打死我们吗？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","我们要往旷野去，走三天的路程，照着耶和华—我们　神所要吩咐我们的祭祀他。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","法老说：「我容你们去，在旷野祭祀耶和华—你们的　神；只是不要走得很远。求你们为我祈祷。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","摩西说：「我要出去求耶和华，使成群的苍蝇明天离开法老和法老的臣仆并法老的百姓；法老却不可再行诡诈，不容百姓去祭祀耶和华。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","于是摩西离开法老去求耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","耶和华就照摩西的话行，叫成群的苍蝇离开法老和他的臣仆并他的百姓，一个也没有留下。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","这一次法老又硬着心，不容百姓去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","耶和华吩咐摩西说：「你进去见法老，对他说：『耶和华—希伯来人的　神这样说：容我的百姓去，好事奉我。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","你若不肯容他们去，仍旧强留他们， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","耶和华的手加在你田间的牲畜上，就是在马、驴、骆驼、牛群、羊群上，必有重重的瘟疫。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","耶和华要分别以色列的牲畜和埃及的牲畜，凡属以色列人的，一样都不死。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","耶和华就定了时候，说：「明天耶和华必在此地行这事。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","第二天，耶和华就行这事。埃及的牲畜几乎都死了，只是以色列人的牲畜，一个都没有死。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","法老打发人去看，谁知以色列人的牲畜连一个都没有死。法老的心却是固执，不容百姓去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","耶和华吩咐摩西、亚伦说：「你们取几捧炉灰，摩西要在法老面前向天扬起来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","这灰要在埃及全地变作尘土，在人身上和牲畜身上成了起泡的疮。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","摩西、亚伦取了炉灰，站在法老面前。摩西向天扬起来，就在人身上和牲畜身上成了起泡的疮。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","行法术的在摩西面前站立不住，因为在他们身上和一切埃及人身上都有这疮。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","耶和华使法老的心刚硬，不听他们，正如耶和华对摩西所说的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","耶和华对摩西说：「你清早起来，站在法老面前，对他说：『耶和华—希伯来人的　神这样说：容我的百姓去，好事奉我。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","因为这一次我要叫一切的灾殃临到你和你臣仆并你百姓的身上，叫你知道在普天下没有像我的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","我若伸手用瘟疫攻击你和你的百姓，你早就从地上除灭了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","其实，我叫你存立，是特要向你显我的大能，并要使我的名传遍天下。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","你还向我的百姓自高，不容他们去吗？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","到明天约在这时候，我必叫重大的冰雹降下，自从埃及开国以来，没有这样的冰雹。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","现在你要打发人把你的牲畜和你田间一切所有的催进来；凡在田间不收回家的，无论是人是牲畜，冰雹必降在他们身上，他们就必死。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","法老的臣仆中，惧怕耶和华这话的，便叫他的奴仆和牲畜跑进家来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","但那不把耶和华这话放在心上的，就将他的奴仆和牲畜留在田里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","耶和华对摩西说：「你向天伸杖，使埃及遍地的人身上和牲畜身上，并田间各样菜蔬上，都有冰雹。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","摩西向天伸杖，耶和华就打雷下雹，有火闪到地上；耶和华下雹在埃及地上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","那时，雹与火搀杂，甚是厉害，自从埃及成国以来，遍地没有这样的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","在埃及遍地，雹击打了田间所有的人和牲畜，并一切的菜蔬，又打坏田间一切的树木。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","惟独以色列人所住的歌珊地没有冰雹。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","法老打发人召摩西、亚伦来，对他们说：「这一次我犯了罪了。耶和华是公义的；我和我的百姓是邪恶的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","这雷轰和冰雹已经够了。请你们求耶和华，我就容你们去，不再留住你们。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","摩西对他说：「我一出城，就要向耶和华举手祷告；雷必止住，也不再有冰雹，叫你知道全地都是属耶和华的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","至于你和你的臣仆，我知道你们还是不惧怕耶和华　神。」（ ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","那时，麻和大麦被雹击打；因为大麦已经吐穗，麻也开了花。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","只是小麦和粗麦没有被击打，因为还没有长成。） ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","摩西离了法老出城，向耶和华举手祷告；雷和雹就止住，雨也不再浇在地上了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","法老见雨和雹与雷止住，就越发犯罪；他和他的臣仆都硬着心。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","法老的心刚硬，不容以色列人去，正如耶和华借着摩西所说的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","耶和华对摩西说：「你进去见法老。我使他和他臣仆的心刚硬，为要在他们中间显我这些神迹， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","并要叫你将我向埃及人所做的事，和在他们中间所行的神迹，传于你儿子和你孙子的耳中，好叫你们知道我是耶和华。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","摩西、亚伦就进去见法老，对他说：「耶和华—希伯来人的　神这样说：『你在我面前不肯自卑要到几时呢？容我的百姓去，好事奉我。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","你若不肯容我的百姓去，明天我要使蝗虫进入你的境内， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","遮满地面，甚至看不见地，并且吃那冰雹所剩的和田间所长的一切树木。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","你的宫殿和你众臣仆的房屋，并一切埃及人的房屋，都要被蝗虫占满了；自从你祖宗和你祖宗的祖宗在世以来，直到今日，没有见过这样的灾。』」摩西就转身离开法老出去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","法老的臣仆对法老说：「这人为我们的网罗要到几时呢？容这些人去事奉耶和华—他们的　神吧！埃及已经败坏了，你还不知道吗？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","于是摩西、亚伦被召回来见法老；法老对他们说：「你们去事奉耶和华—你们的　神；但那要去的是谁呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","摩西说：「我们要和我们老的少的、儿子女儿同去，且把羊群牛群一同带去，因为我们务要向耶和华守节。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","法老对他们说：「我容你们和你们妇人孩子去的时候，耶和华与你们同在吧！你们要谨慎；因为有祸在你们眼前， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","不可都去！你们这壮年人去事奉耶和华吧，因为这是你们所求的。」于是把他们从法老面前撵出去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","耶和华对摩西说：「你向埃及地伸杖，使蝗虫到埃及地上来，吃地上一切的菜蔬，就是冰雹所剩的。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","摩西就向埃及地伸杖，那一昼一夜，耶和华使东风刮在埃及地上；到了早晨，东风把蝗虫刮了来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","蝗虫上来，落在埃及的四境，甚是厉害；以前没有这样的，以后也必没有。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","因为这蝗虫遮满地面，甚至地都黑暗了，又吃地上一切的菜蔬和冰雹所剩树上的果子。埃及遍地，无论是树木，是田间的菜蔬，连一点青的也没有留下。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","于是法老急忙召了摩西、亚伦来，说：「我得罪耶和华—你们的　神，又得罪了你们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","现在求你，只这一次，饶恕我的罪，求耶和华—你们的　神使我脱离这一次的死亡。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","摩西就离开法老去求耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","耶和华转了极大的西风，把蝗虫刮起，吹入红海；在埃及的四境连一个也没有留下。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","但耶和华使法老的心刚硬，不容以色列人去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","耶和华对摩西说：「你向天伸杖，使埃及地黑暗；这黑暗似乎摸得着。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","摩西向天伸杖，埃及遍地就乌黑了三天。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","三天之久，人不能相见，谁也不敢起来离开本处；惟有以色列人家中都有亮光。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","法老就召摩西来，说：「你们去事奉耶和华；只是你们的羊群牛群要留下；你们的妇人孩子可以和你们同去。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","摩西说：「你总要把祭物和燔祭牲交给我们，使我们可以祭祀耶和华—我们的　神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","我们的牲畜也要带去，连一蹄也不留下；因为我们要从其中取出来，事奉耶和华—我们的　神。我们未到那里，还不知道用什么事奉耶和华。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","但耶和华使法老的心刚硬，不肯容他们去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","法老对摩西说：「你离开我去吧，你要小心，不要再见我的面！因为你见我面的那日你就必死！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","摩西说：「你说得好！我必不再见你的面了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","耶和华对摩西说：「我再使一样的灾殃临到法老和埃及，然后他必容你们离开这地。他容你们去的时候，总要催逼你们都从这地出去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","你要传于百姓的耳中，叫他们男女各人向邻舍要金器银器。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","耶和华叫百姓在埃及人眼前蒙恩，并且摩西在埃及地、法老臣仆，和百姓的眼中看为极大。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","摩西说：「耶和华这样说：『约到半夜，我必出去巡行埃及遍地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","凡在埃及地，从坐宝座的法老直到磨子后的婢女所有的长子，以及一切头生的牲畜，都必死。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","埃及遍地必有大哀号；从前没有这样的，后来也必没有。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","至于以色列中，无论是人是牲畜，连狗也不敢向他们摇舌，好叫你们知道耶和华是将埃及人和以色列人分别出来。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","你这一切臣仆都要俯伏来见我，说：『求你和跟从你的百姓都出去』，然后我要出去。」于是，摩西气忿忿地离开法老，出去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","耶和华对摩西说：「法老必不听你 们，使我的奇事在埃及地多起来。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","摩西、亚伦在法老面前行了这一切奇事；耶和华使法老的心刚硬，不容以色列人出离他的地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","耶和华在埃及地晓谕摩西、亚伦说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","「你们要以本月为正月，为一年之首。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","你们吩咐以色列全会众说：本月初十日，各人要按着父家取羊羔，一家一只。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","若是一家的人太少，吃不了一只羊羔，本人就要和他隔壁的邻舍共取一只。你们预备羊羔，要按着人数和饭量计算。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","要无残疾、一岁的公羊羔，你们或从绵羊里取，或从山羊里取，都可以。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","要留到本月十四日，在黄昏的时候，以色列全会众把羊羔宰了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","各家要取点血，涂在吃羊羔的房屋左右的门框上和门楣上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","当夜要吃羊羔的肉；用火烤了，与无酵饼和苦菜同吃。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","不可吃生的，断不可吃水煮的，要带着头、腿、五脏，用火烤了吃。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","不可剩下一点留到早晨；若留到早晨，要用火烧了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","你们吃羊羔当腰间束带，脚上穿鞋，手中拿杖，赶紧地吃；这是耶和华的逾越节。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","因为那夜我要巡行埃及地，把埃及地一切头生的，无论是人是牲畜，都击杀了，又要败坏埃及一切的神。我是耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","这血要在你们所住的房屋上作记号；我一见这血，就越过你们去。我击杀埃及地头生的时候，灾殃必不临到你们身上灭你们。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","「你们要记念这日，守为耶和华的节，作为你们世世代代永远的定例。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","你们要吃无酵饼七日。头一日要把酵从你们各家中除去；因为从头一日起，到第七日为止，凡吃有酵之饼的，必从以色列中剪除。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","头一日你们当有圣会，第七日也当有圣会。这两日之内，除了预备各人所要吃的以外，无论何工都不可做。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","你们要守无酵节，因为我正当这日把你们的军队从埃及地领出来。所以，你们要守这日，作为世世代代永远的定例。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","从正月十四日晚上，直到二十一日晚上，你们要吃无酵饼。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","在你们各家中，七日之内不可有酵；因为凡吃有酵之物的，无论是寄居的，是本地的，必从以色列的会中剪除。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","有酵的物，你们都不可吃；在你们一切住处要吃无酵饼。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","于是，摩西召了以色列的众长老来，对他们说：「你们要按着家口取出羊羔，把这逾越节的羊羔宰了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","拿一把牛膝草，蘸盆里的血，打在门楣上和左右的门框上。你们谁也不可出自己的房门，直到早晨。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","因为耶和华要巡行击杀埃及人，他看见血在门楣上和左右的门框上，就必越过那门，不容灭命的进你们的房屋，击杀你们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","这例，你们要守着，作为你们和你们子孙永远的定例。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","日后，你们到了耶和华按着所应许赐给你们的那地，就要守这礼。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","你们的儿女问你们说：『行这礼是什么意思？』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","你们就说：『这是献给耶和华逾越节的祭。当以色列人在埃及的时候，他击杀埃及人，越过以色列人的房屋，救了我们各家。』」于是百姓低头下拜。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","耶和华怎样吩咐摩西、亚伦，以色列人就怎样行。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","到了半夜，耶和华把埃及地所有的长子，就是从坐宝座的法老，直到被掳囚在监里之人的长子，以及一切头生的牲畜，尽都杀了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","法老和一切臣仆，并埃及众人，夜间都起来了。在埃及有大哀号，无一家不死一个人的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","夜间，法老召了摩西、亚伦来，说：「起来！连你们带以色列人，从我民中出去，依你们所说的，去事奉耶和华吧！ ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","也依你们所说的，连羊群牛群带着走吧！并要为我祝福。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","埃及人催促百姓，打发他们快快出离那地，因为埃及人说：「我们都要死了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","百姓就拿着没有酵的生面，把抟面盆包在衣服中，扛在肩头上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","以色列人照着摩西的话行，向埃及人要金器、银器，和衣裳。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","耶和华叫百姓在埃及人眼前蒙恩，以致埃及人给他们所要的。他们就把埃及人的财物夺去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","以色列人从兰塞起行，往疏割去；除了妇人孩子，步行的男人约有六十万。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","又有许多闲杂人，并有羊群牛群，和他们一同上去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","他们用埃及带出来的生面烤成无酵饼。这生面原没有发起；因为他们被催逼离开埃及，不能耽延，也没有为自己预备什么食物。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","以色列人住在埃及共有四百三十年。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","正满了四百三十年的那一天，耶和华的军队都从埃及地出来了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","这夜是耶和华的夜；因耶和华领他们出了埃及地，所以当向耶和华谨守，是以色列众人世世代代该谨守的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","耶和华对摩西、亚伦说：「逾越节的例是这样：外邦人都不可吃这羊羔。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","但各人用银子买的奴仆，既受了割礼就可以吃。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","寄居的和雇工人都不可吃。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","应当在一个房子里吃；不可把一点肉从房子里带到外头去。羊羔的骨头一根也不可折断。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","以色列全会众都要守这礼。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","若有外人寄居在你们中间，愿向耶和华守逾越节，他所有的男子务要受割礼，然后才容他前来遵守，他也就像本地人一样；但未受割礼的，都不可吃这羊羔。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","本地人和寄居在你们中间的外人同归一例。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","耶和华怎样吩咐摩西、亚伦，以色列众人就怎样行了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","正当那日，耶和华将以色列人按着他们的军队，从埃及地领出来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","耶和华晓谕摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","「以色列中凡头生的，无论是人是牲畜，都是我的，要分别为圣归我。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","摩西对百姓说：「你们要记念从埃及为奴之家出来的这日，因为耶和华用大能的手将你们从这地方领出来。有酵的饼都不可吃。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","亚笔月间的这日是你们出来的日子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","将来耶和华领你进迦南人、赫人、亚摩利人、希未人、耶布斯人之地，就是他向你的祖宗起誓应许给你那流奶与蜜之地，那时你要在这月间守这礼。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","你要吃无酵饼七日，到第七日要向耶和华守节。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","这七日之久，要吃无酵饼；在你四境之内不可见有酵的饼，也不可见发酵的物。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","当那日，你要告诉你的儿子说：『这是因耶和华在我出埃及的时候为我所行的事。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","这要在你手上作记号，在你额上作纪念，使耶和华的律法常在你口中，因为耶和华曾用大能的手将你从埃及领出来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","所以你每年要按着日期守这例。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","「将来，耶和华照他向你和你祖宗所起的誓将你领进迦南人之地，把这地赐给你， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","那时你要将一切头生的，并牲畜中头生的，归给耶和华；公的都要属耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","凡头生的驴，你要用羊羔代赎；若不代赎，就要打折它的颈项。凡你儿子中头生的都要赎出来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","日后，你的儿子问你说：『这是什么意思？』你就说：『耶和华用大能的手将我们从埃及为奴之家领出来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","那时法老几乎不容我们去，耶和华就把埃及地所有头生的，无论是人是牲畜，都杀了。因此，我把一切头生的公牲畜献给耶和华为祭，但将头生的儿子都赎出来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","这要在你手上作记号，在你额上作经文，因为耶和华用大能的手将我们从埃及领出来。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","法老容百姓去的时候，非利士地的道路虽近，　神却不领他们从那里走；因为　神说：「恐怕百姓遇见打仗后悔，就回埃及去。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","所以　神领百姓绕道而行，走红海旷野的路。以色列人出埃及地，都带着兵器上去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","摩西把约瑟的骸骨一同带去；因为约瑟曾叫以色列人严严地起誓，对他们说：「　神必眷顾你们，你们要把我的骸骨从这里一同带上去。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","他们从疏割起行，在旷野边的以倘安营。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","日间，耶和华在云柱中领他们的路；夜间，在火柱中光照他们，使他们日夜都可以行走。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","日间云柱，夜间火柱，总不离开百姓的面前。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","耶和华晓谕摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","「你吩咐以色列人转回，安营在比·哈希录前，密夺和海的中间，对着巴力· 洗分，靠近海边安营。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","法老必说：『以色列人在地中绕迷了，旷野把他们困住了。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","我要使法老的心刚硬，他要追赶他们，我便在法老和他全军身上得荣耀；埃及人就知道我是耶和华。」于是以色列人这样行了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","有人告诉埃及王说：「百姓逃跑。」法老和他的臣仆就向百姓变心，说：「我们容以色列人去，不再服事我们，这做的是什么事呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","法老就预备他的车辆，带领军兵同去， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","并带着六百辆特选的车和埃及所有的车，每辆都有车兵长。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","耶和华使埃及王法老的心刚硬，他就追赶以色列人，因为以色列人是昂然无惧地出埃及。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","埃及人追赶他们，法老一切的马匹、车辆、马兵，与军兵就在海边上，靠近比·哈希录，对着巴力·洗分，在他们安营的地方追上了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","法老临近的时候，以色列人举目看见埃及人赶来，就甚惧怕，向耶和华哀求。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","他们对摩西说：「难道在埃及没有坟地，你把我们带来死在旷野吗？你为什么这样待我们，将我们从埃及领出来呢？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","我们在埃及岂没有对你说过，不要搅扰我们，容我们服事埃及人吗？因为服事埃及人比死在旷野还好。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","摩西对百姓说：「不要惧怕，只管站住！看耶和华今天向你们所要施行的救恩。因为，你们今天所看见的埃及人必永远不再看见了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","耶和华必为你们争战；你们只管静默，不要作声。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","耶和华对摩西说：「你为什么向我哀求呢？你吩咐以色列人往前走。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","你举手向海伸杖，把水分开。以色列人要下海中走干地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","我要使埃及人的心刚硬，他们就跟着下去。我要在法老和他的全军、车辆、马兵上得荣耀。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","我在法老和他的车辆、马兵上得荣耀的时候，埃及人就知道我是耶和华了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","在以色列营前行走　神的使者，转到他们后边去；云柱也从他们前边转到他们后边立住。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","在埃及营和以色列营中间有云柱，一边黑暗，一边发光，终夜两下不得相近。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","摩西向海伸杖，耶和华便用大东风，使海水一夜退去，水便分开，海就成了干地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","以色列人下海中走干地，水在他们的左右作了墙垣。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","埃及人追赶他们，法老一切的马匹、车辆，和马兵都跟着下到海中。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","到了晨更的时候，耶和华从云火柱中向埃及的军兵观看，使埃及的军兵混乱了； ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","又使他们的车轮脱落，难以行走，以致埃及人说：「我们从以色列人面前逃跑吧！因耶和华为他们攻击我们了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","耶和华对摩西说：「你向海伸杖，叫水仍合在埃及人并他们的车辆、马兵身上。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","摩西就向海伸杖，到了天一亮，海水仍旧复原。埃及人避水逃跑的时候，耶和华把他们推翻在海中， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","水就回流，淹没了车辆和马兵。那些跟着以色列人下海法老的全军，连一个也没有剩下。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","以色列人却在海中走干地；水在他们的左右作了墙垣。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","当日，耶和华这样拯救以色列人脱离埃及人的手，以色列人看见埃及人的死尸都在海边了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","以色列人看见耶和华向埃及人所行的大事，就敬畏耶和华，又信服他和他的仆人摩西。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","那时，摩西和以色列人向耶和华唱歌说： 我要向耶和华歌唱，因他大大战胜， 将马和骑马的投在海中。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","耶和华是我的力量，我的诗歌， 也成了我的拯救。 这是我的　神，我要赞美他， 是我父亲的　神，我要尊崇他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","耶和华是战士； 他的名是耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","法老的车辆、军兵，耶和华已抛在海中； 他特选的军长都沉于红海。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","深水淹没他们； 他们如同石头坠到深处。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","耶和华啊，你的右手施展能力，显出荣耀； 耶和华啊，你的右手摔碎仇敌。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","你大发威严，推翻那些起来攻击你的； 你发出烈怒如火，烧灭他们像烧碎秸一样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","你发鼻中的气，水便聚起成堆， 大水直立如垒， 海中的深水凝结。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","仇敌说：我要追赶，我要追上； 我要分掳物，我要在他们身上称我的心愿。 我要拔出刀来，亲手杀灭他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","你叫风一吹，海就把他们淹没； 他们如铅沉在大水之中。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","耶和华啊，众神之中，谁能像你？ 谁能像你—至圣至荣， 可颂可畏，施行奇事？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","你伸出右手， 地便吞灭他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","你凭慈爱领了你所赎的百姓； 你凭能力引他们到了你的圣所。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","外邦人听见就发颤； 疼痛抓住非利士的居民。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","那时，以东的族长惊惶， 摩押的英雄被战兢抓住， 迦南的居民心都消化了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","惊骇恐惧临到他们。 耶和华啊，因你膀臂的大能， 他们如石头寂然不动， 等候你的百姓过去， 等候你所赎的百姓过去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","你要将他们领进去，栽于你产业的山上— 耶和华啊，就是你为自己所造的住处； 主啊，就是你手所建立的圣所。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","耶和华必作王，直到永永远远！ ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","法老的马匹、车辆，和马兵下到海中，耶和华使海水回流，淹没他们；惟有以色列人在海中走干地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","亚伦的姊姊，女先知米利暗，手里拿着鼓；众妇女也跟她出去拿鼓跳舞。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","米利暗应声说： 你们要歌颂耶和华，因他大大战胜， 将马和骑马的投在海中。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","摩西领以色列人从红海往前行，到了书珥的旷野，在旷野走了三天，找不着水。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","到了玛拉，不能喝那里的水；因为水苦，所以那地名叫玛拉。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","百姓就向摩西发怨言，说：「我们喝什么呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","摩西呼求耶和华，耶和华指示他一棵树。他把树丢在水里，水就变甜了。 耶和华在那里为他们定了律例、典章，在那里试验他们； ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","又说：「你若留意听耶和华—你　神的话，又行我眼中看为正的事，留心听我的诫命，守我一切的律例，我就不将所加与埃及人的疾病加在你身上，因为我—耶和华是医治你的。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","他们到了以琳，在那里有十二股水泉，七十棵棕树；他们就在那里的水边安营。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","以色列全会众从以琳起行，在出埃及后第二个月十五日到了以琳和西奈中间、汛的旷野。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","以色列全会众在旷野向摩西、亚伦发怨言， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","说：「巴不得我们早死在埃及地、耶和华的手下；那时我们坐在肉锅旁边，吃得饱足。你们将我们领出来，到这旷野，是要叫这全会众都饿死啊！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","耶和华对摩西说：「我要将粮食从天降给你们。百姓可以出去，每天收每天的分，我好试验他们遵不遵我的法度。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","到第六天，他们要把所收进来的预备好了，比每天所收的多一倍。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","摩西、亚伦对以色列众人说：「到了晚上，你们要知道是耶和华将你们从埃及地领出来的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","早晨，你们要看见耶和华的荣耀，因为耶和华听见你们向他所发的怨言了。我们算什么，你们竟向我们发怨言呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","摩西又说：「耶和华晚上必给你们肉吃，早晨必给你们食物得饱；因为你们向耶和华发的怨言，他都听见了。我们算什么，你们的怨言不是向我们发的，乃是向耶和华发的。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","摩西对亚伦说：「你告诉以色列全会众说：『你们就近耶和华面前，因为他已经听见你们的怨言了。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","亚伦正对以色列全会众说话的时候，他们向旷野观看，不料，耶和华的荣光在云中显现。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","耶和华晓谕摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","「我已经听见以色列人的怨言。你告诉他们说：『到黄昏的时候，你们要吃肉，早晨必有食物得饱，你们就知道我是耶和华—你们的　神。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","到了晚上，有鹌鹑飞来，遮满了营；早晨在营四围的地上有露水。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","露水上升之后，不料，野地面上有如白霜的小圆物。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","以色列人看见，不知道是什么，就彼此对问说：「这是什么呢？」摩西对他们说：「这就是耶和华给你们吃的食物。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","耶和华所吩咐的是这样：你们要按着各人的饭量，为帐棚里的人，按着人数收起来，各拿一俄梅珥。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","以色列人就这样行；有多收的，有少收的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","及至用俄梅珥量一量，多收的也没有余，少收的也没有缺；各人按着自己的饭量收取。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","摩西对他们说：「所收的，不许什么人留到早晨。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","然而他们不听摩西的话，内中有留到早晨的，就生虫变臭了；摩西便向他们发怒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","他们每日早晨，按着各人的饭量收取，日头一发热，就消化了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","到第六天，他们收了双倍的食物，每人两俄梅珥。会众的官长来告诉摩西； ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","摩西对他们说：「耶和华这样说：『明天是圣安息日，是向耶和华守的圣安息日。你们要烤的就烤了，要煮的就煮了，所剩下的都留到早晨。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","他们就照摩西的吩咐留到早晨，也不臭，里头也没有虫子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","摩西说：「你们今天吃这个吧！因为今天是向耶和华守的安息日；你们在田野必找不着了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","六天可以收取，第七天乃是安息日，那一天必没有了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","第七天，百姓中有人出去收，什么也找不着。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","耶和华对摩西说：「你们不肯守我的诫命和律法，要到几时呢？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","你们看！耶和华既将安息日赐给你们，所以第六天他赐给你们两天的食物，第七天各人要住在自己的地方，不许什么人出去。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","于是百姓第七天安息了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","这食物，以色列家叫吗哪；样子像芫荽子，颜色是白的，滋味如同搀蜜的薄饼。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","摩西说：「耶和华所吩咐的是这样：『要将一满俄梅珥吗哪留到世世代代，使后人可以看见我当日将你们领出埃及地，在旷野所给你们吃的食物。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","摩西对亚伦说：「你拿一个罐子，盛一满俄梅珥吗哪，存在耶和华面前，要留到世世代代。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","耶和华怎么吩咐摩西，亚伦就怎么行，把吗哪放在法柜前存留。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","以色列人吃吗哪共四十年，直到进了有人居住之地，就是迦南的境界。（ ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","俄梅珥就是伊法十分之一。） ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","以色列全会众都遵耶和华的吩咐，按着站口从汛的旷野往前行，在利非订安营。百姓没有水喝， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","所以与摩西争闹，说：「给我们水喝吧！」摩西对他们说：「你们为什么与我争闹？为什么试探耶和华呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","百姓在那里甚渴，要喝水，就向摩西发怨言，说：「你为什么将我们从埃及领出来，使我们和我们的儿女并牲畜都渴死呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","摩西就呼求耶和华说：「我向这百姓怎样行呢？他们几乎要拿石头打死我。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","耶和华对摩西说：「你手里拿着你先前击打河水的杖，带领以色列的几个长老，从百姓面前走过去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","我必在何烈的磐石那里，站在你面前。你要击打磐石，从磐石里必有水流出来，使百姓可以喝。」摩西就在以色列的长老眼前这样行了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","他给那地方起名叫玛撒，又叫米利巴；因以色列人争闹，又因他们试探耶和华，说：「耶和华是在我们中间不是？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","那时，亚玛力人来在利非订，和以色列人争战。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","摩西对约书亚说：「你为我们选出人来，出去和亚玛力人争战。明天我手里要拿着　神的杖，站在山顶上。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","于是约书亚照着摩西对他所说的话行，和亚玛力人争战。摩西、亚伦，与户珥都上了山顶。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","摩西何时举手，以色列人就得胜，何时垂手，亚玛力人就得胜。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","但摩西的手发沉，他们就搬石头来，放在他以下，他就坐在上面。亚伦与户珥扶着他的手，一个在这边，一个在那边，他的手就稳住，直到日落的时候。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","约书亚用刀杀了亚玛力王和他的百姓。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","耶和华对摩西说：「我要将亚玛力的名号从天下全然涂抹了；你要将这话写在书上作纪念，又念给约书亚听。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","摩西筑了一座坛，起名叫「耶和华尼西」， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","又说：「耶和华已经起了誓，必世世代代和亚玛力人争战。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","摩西的岳父，米甸祭司叶忒罗，听见　神为摩西和　神的百姓以色列所行的一切事，就是耶和华将以色列从埃及领出来的事， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","便带着摩西的妻子西坡拉，就是摩西从前打发回去的， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","又带着西坡拉的两个儿子，一个名叫革舜，因为摩西说：「我在外邦作了寄居的」； ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","一个名叫以利以谢，因为他说：「我父亲的　神帮助了我，救我脱离法老的刀。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","摩西的岳父叶忒罗带着摩西的妻子和两个儿子来到　神的山，就是摩西在旷野安营的地方。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","他对摩西说：「我是你岳父叶忒罗，带着你的妻子和两个儿子来到你这里。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","摩西迎接他的岳父，向他下拜，与他亲嘴，彼此问安，都进了帐棚。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","摩西将耶和华为以色列的缘故向法老和埃及人所行的一切事，以及路上所遭遇的一切艰难，并耶和华怎样搭救他们，都述说与他岳父听。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","叶忒罗因耶和华待以色列的一切好处，就是拯救他们脱离埃及人的手，便甚欢喜。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","叶忒罗说：「耶和华是应当称颂的；他救了你们脱离埃及人和法老的手，将这百姓从埃及人的手下救出来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","我现今在埃及人向这百姓发狂傲的事上得知，耶和华比万神都大。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","摩西的岳父叶忒罗把燔祭和平安祭献给　神。亚伦和以色列的众长老都来了，与摩西的岳父在　神面前吃饭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","第二天，摩西坐着审判百姓，百姓从早到晚都站在摩西的左右。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","摩西的岳父看见他向百姓所做的一切事，就说：「你向百姓做的是什么事呢？你为什么独自坐着，众百姓从早到晚都站在你的左右呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","摩西对岳父说：「这是因百姓到我这里来求问　神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","他们有事的时候就到我这里来，我便在两造之间施行审判；我又叫他们知道　神的律例和法度。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","摩西的岳父说：「你这做的不好。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","你和这些百姓必都疲惫；因为这事太重，你独自一人办理不了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","现在你要听我的话。我为你出个主意，愿　神与你同在。你要替百姓到　神面前，将案件奏告　神； ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","又要将律例和法度教训他们，指示他们当行的道，当做的事； ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","并要从百姓中拣选有才能的人，就是敬畏　神、诚实无妄、恨不义之财的人，派他们作千夫长、百夫长、五十夫长、十夫长，管理百姓， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","叫他们随时审判百姓，大事都要呈到你这里，小事他们自己可以审判。这样，你就轻省些，他们也可以同当此任。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","你若这样行，　神也这样吩咐你，你就能受得住，这百姓也都平平安安归回他们的住处。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","于是，摩西听从他岳父的话，按着他所说的去行。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","摩西从以色列人中拣选了有才能的人，立他们为百姓的首领，作千夫长、百夫长、五十夫长、十夫长。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","他们随时审判百姓，有难断的案件就呈到摩西那里，但各样小事他们自己审判。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","此后，摩西让他的岳父去，他就往本地去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","以色列人出埃及地以后，满了三个月的那一天，就来到西奈的旷野。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","他们离了利非订，来到西奈的旷野，就在那里的山下安营。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","摩西到　神那里，耶和华从山上呼唤他说：「你要这样告诉雅各家，晓谕以色列人说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","『我向埃及人所行的事，你们都看见了，且看见我如鹰将你们背在翅膀上，带来归我。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","如今你们若实在听从我的话，遵守我的约，就要在万民中作属我的子民，因为全地都是我的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","你们要归我作祭司的国度，为圣洁的国民。』这些话你要告诉以色列人。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","摩西去召了民间的长老来，将耶和华所吩咐他的话都在他们面前陈明。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","百姓都同声回答说：「凡耶和华所说的，我们都要遵行。」摩西就将百姓的话回复耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","耶和华对摩西说：「我要在密云中临到你那里，叫百姓在我与你说话的时候可以听见，也可以永远信你了。」于是，摩西将百姓的话奏告耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","耶和华又对摩西说：「你往百姓那里去，叫他们今天明天自洁，又叫他们洗衣服。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","到第三天要预备好了，因为第三天耶和华要在众百姓眼前降临在西奈山上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","你要在山的四围给百姓定界限，说：『你们当谨慎，不可上山去，也不可摸山的边界；凡摸这山的，必要治死他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","不可用手摸他，必用石头打死，或用箭射透；无论是人是牲畜，都不得活。到角声拖长的时候，他们才可到山根来。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","摩西下山往百姓那里去，叫他们自洁，他们就洗衣服。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","他对百姓说：「到第三天要预备好了。不可亲近女人。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","到了第三天早晨，在山上有雷轰、闪电，和密云，并且角声甚大，营中的百姓尽都发颤。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","摩西率领百姓出营迎接　神，都站在山下。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","西奈全山冒烟，因为耶和华在火中降于山上。山的烟气上腾，如烧窑一般，遍山大大地震动。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","角声渐渐地高而又高，摩西就说话，　神有声音答应他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","耶和华降临在西奈山顶上，耶和华召摩西上山顶，摩西就上去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","耶和华对摩西说：「你下去嘱咐百姓，不可闯过来到我面前观看，恐怕他们有多人死亡； ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","又叫亲近我的祭司自洁，恐怕我忽然出来击杀他们。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","摩西对耶和华说：「百姓不能上西奈山，因为你已经嘱咐我们说：『要在山的四围定界限，叫山成圣。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","耶和华对他说：「下去吧，你要和亚伦一同上来；只是祭司和百姓不可闯过来上到我面前，恐怕我忽然出来击杀他们。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","于是摩西下到百姓那里告诉他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","神吩咐这一切的话说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","「我是耶和华—你的　神，曾将你从埃及地为奴之家领出来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","「除了我以外，你不可有别的神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","「不可为自己雕刻偶像，也不可做什么形象仿佛上天、下地，和地底下、水中的百物。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","不可跪拜那些像，也不可事奉它，因为我耶和华—你的　神是忌邪的　神。恨我的，我必追讨他的罪，自父及子，直到三四代； ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","爱我、守我诫命的，我必向他们发慈爱，直到千代。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","「不可妄称耶和华—你　神的名；因为妄称耶和华名的，耶和华必不以他为无罪。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","「当记念安息日，守为圣日。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","六日要劳碌做你一切的工， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","但第七日是向耶和华—你　神当守的安息日。这一日你和你的儿女、仆婢、牲畜，并你城里寄居的客旅，无论何工都不可做； ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","因为六日之内，耶和华造天、地、海，和其中的万物，第七日便安息，所以耶和华赐福与安息日，定为圣日。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","「当孝敬父母，使你的日子在耶和华—你　神所赐你的地上得以长久。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","「不可杀人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","「不可奸淫。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","「不可偷盗。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","「不可作假见证陷害人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","「不可贪恋人的房屋；也不可贪恋人的妻子、仆婢、牛驴，并他一切所有的。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","众百姓见雷轰、闪电、角声、山上冒烟，就都发颤，远远地站立， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","对摩西说：「求你和我们说话，我们必听；不要　神和我们说话，恐怕我们死亡。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","摩西对百姓说：「不要惧怕；因为　神降临是要试验你们，叫你们时常敬畏他，不致犯罪。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","于是百姓远远地站立；摩西就挨近　神所在的幽暗之中。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","耶和华对摩西说：「你要向以色列人这样说：『你们自己看见我从天上和你们说话了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","你们不可做什么神像与我相配，不可为自己做金银的神像。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","你要为我筑土坛，在上面以牛羊献为燔祭和平安祭。凡记下我名的地方，我必到那里赐福给你。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","你若为我筑一座石坛，不可用凿成的石头，因你在上头一动家具，就把坛污秽了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","你上我的坛，不可用台阶，免得露出你的下体来。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","「你在百姓面前所要立的典章是这样： ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","你若买希伯来人作奴仆，他必服事你六年；第七年他可以自由，白白地出去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","他若孤身来就可以孤身去；他若有妻，他的妻就可以同他出去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","他主人若给他妻子，妻子给他生了儿子或女儿，妻子和儿女要归主人，他要独自出去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","倘或奴仆明说：『我爱我的主人和我的妻子儿女，不愿意自由出去。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","他的主人就要带他到审判官那里，又要带他到门前，靠近门框，用锥子穿他的耳朵，他就永远服事主人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","「人若卖女儿作婢女，婢女不可像男仆那样出去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","主人选定她归自己，若不喜欢她，就要许她赎身；主人既然用诡诈待她，就没有权柄卖给外邦人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","主人若选定她给自己的儿子，就当待她如同女儿。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","若另娶一个，那女子的吃食、衣服，并好合的事，仍不可减少。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","若不向她行这三样，她就可以不用钱赎，白白地出去。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","「打人以致打死的，必要把他治死。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","人若不是埋伏着杀人，乃是　神交在他手中，我就设下一个地方，他可以往那里逃跑。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","人若任意用诡计杀了他的邻舍，就是逃到我的坛那里，也当捉去把他治死。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","「打父母的，必要把他治死。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","「拐带人口，或是把人卖了，或是留在他手下，必要把他治死。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","「咒骂父母的，必要把他治死。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","「人若彼此相争，这个用石头或是拳头打那个，尚且不至于死，不过躺卧在床， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","若再能起来扶杖而出，那打他的可算无罪；但要将他耽误的工夫用钱赔补，并要将他全然医好。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","「人若用棍子打奴仆或婢女，立时死在他的手下，他必要受刑。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","若过一两天才死，就可以不受刑，因为是用钱买的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","「人若彼此争斗，伤害有孕的妇人，甚至坠胎，随后却无别害，那伤害她的，总要按妇人的丈夫所要的，照审判官所断的，受罚。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","若有别害，就要以命偿命， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","以眼还眼，以牙还牙，以手还手，以脚还脚， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","以烙还烙，以伤还伤，以打还打。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","「人若打坏了他奴仆或是婢女的一只眼，就要因他的眼放他去得以自由。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","若打掉了他奴仆或是婢女的一个牙，就要因他的牙放他去得以自由。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","「牛若触死男人或是女人，总要用石头打死那牛，却不可吃它的肉；牛的主人可算无罪。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","倘若那牛素来是触人的，有人报告了牛主，他竟不把牛拴着，以致把男人或是女人触死，就要用石头打死那牛，牛主也必治死。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","若罚他赎命的价银，他必照所罚的赎他的命。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","牛无论触了人的儿子或是女儿，必照这例办理。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","牛若触了奴仆或是婢女，必将银子三十舍客勒给他们的主人，也要用石头把牛打死。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","「人若敞着井口，或挖井不遮盖，有牛或驴掉在里头， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","井主要拿钱赔还本主人，死牲畜要归自己。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","「这人的牛若伤了那人的牛，以至于死，他们要卖了活牛，平分价值，也要平分死牛。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","人若知道这牛素来是触人的，主人竟不把牛拴着，他必要以牛还牛，死牛要归自己。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","「人若偷牛或羊，无论是宰了，是卖了，他就要以五牛赔一牛，四羊赔一羊。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","人若遇见贼挖窟窿，把贼打了，以至于死，就不能为他有流血的罪。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","若太阳已经出来，就为他有流血的罪。贼若被拿，总要赔还。若他一无所有，就要被卖，顶他所偷的物。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","若他所偷的，或牛，或驴，或羊，仍在他手下存活，他就要加倍赔还。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","「人若在田间或在葡萄园里放牲畜，任凭牲畜上别人的田里去吃，就必拿自己田间上好的和葡萄园上好的赔还。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","「若点火焚烧荆棘，以致将别人堆积的禾捆，站着的禾稼，或是田园，都烧尽了，那点火的必要赔还。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","「人若将银钱或家具交付邻舍看守，这物从那人的家被偷去，若把贼找到了，贼要加倍赔还； ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","若找不到贼，那家主必就近审判官，要看看他拿了原主的物件没有。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","「两个人的案件，无论是为什么过犯，或是为牛，为驴，为羊，为衣裳，或是为什么失掉之物，有一人说：『这是我的』，两造就要将案件禀告审判官，审判官定谁有罪，谁就要加倍赔还。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","「人若将驴，或牛，或羊，或别的牲畜，交付邻舍看守，牲畜或死，或受伤，或被赶去，无人看见， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","那看守的人要凭着耶和华起誓，手里未曾拿邻舍的物，本主就要罢休，看守的人不必赔还。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","牲畜若从看守的那里被偷去，他就要赔还本主； ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","若被野兽撕碎，看守的要带来当作证据，所撕的不必赔还。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","「人若向邻舍借什么，所借的或受伤，或死，本主没有同在一处，借的人总要赔还； ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","若本主同在一处，他就不必赔还；若是雇的，也不必赔还，本是为雇价来的。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","「人若引诱没有受聘的处女，与她行淫，他总要交出聘礼，娶她为妻。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","若女子的父亲决不肯将女子给他，他就要按处女的聘礼，交出钱来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","「行邪术的女人，不可容她存活。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","「凡与兽淫合的，总要把他治死。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","「祭祀别神，不单单祭祀耶和华的，那人必要灭绝。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","「不可亏负寄居的，也不可欺压他，因为你们在埃及地也作过寄居的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","不可苦待寡妇和孤儿； ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","若是苦待他们一点，他们向我一哀求，我总要听他们的哀声， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","并要发烈怒，用刀杀你们，使你们的妻子为寡妇，儿女为孤儿。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","「我民中有贫穷人与你同住，你若借钱给他，不可如放债的向他取利。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","你即或拿邻舍的衣服作当头，必在日落以先归还他； ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","因他只有这一件当盖头，是他盖身的衣服，若是没有，他拿什么睡觉呢？他哀求我，我就应允，因为我是有恩惠的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","「不可毁谤　神；也不可毁谤你百姓的官长。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","「你要从你庄稼中的谷和酒榨中滴出来的酒拿来献上，不可迟延。 「你要将头生的儿子归给我。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","你牛羊头生的，也要这样；七天当跟着母，第八天要归给我。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","「你们要在我面前为圣洁的人。因此，田间被野兽撕裂牲畜的肉，你们不可吃，要丢给狗吃。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","「不可随伙布散谣言；不可与恶人连手妄作见证。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","不可随众行恶；不可在争讼的事上随众偏行，作见证屈枉正直； ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","也不可在争讼的事上偏护穷人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","「若遇见你仇敌的牛或驴失迷了路，总要牵回来交给他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","若看见恨你人的驴压卧在重驮之下，不可走开，务要和驴主一同抬开重驮。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","「不可在穷人争讼的事上屈枉正直。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","当远离虚假的事。不可杀无辜和有义的人，因我必不以恶人为义。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","不可受贿赂；因为贿赂能叫明眼人变瞎了，又能颠倒义人的话。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","「不可欺压寄居的；因为你们在埃及地作过寄居的，知道寄居的心。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","「六年你要耕种田地，收藏土产， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","只是第七年要叫地歇息，不耕不种，使你民中的穷人有吃的；他们所剩下的，野兽可以吃。你的葡萄园和橄榄园也要照样办理。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","「六日你要做工，第七日要安息，使牛、驴可以歇息，并使你婢女的儿子和寄居的都可以舒畅。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","「凡我对你们说的话，你们要谨守。别神的名，你不可提，也不可从你口中传说。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","「一年三次，你要向我守节。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","你要守除酵节，照我所吩咐你的，在亚笔月内所定的日期，吃无酵饼七天。谁也不可空手朝见我，因为你是这月出了埃及。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","又要守收割节，所收的是你田间所种、劳碌得来初熟之物。并在年底收藏，要守收藏节。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","一切的男丁要一年三次朝见主耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","「不可将我祭牲的血和有酵的饼一同献上；也不可将我节上祭牲的脂油留到早晨。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","「地里首先初熟之物要送到耶和华—你　神的殿。 「不可用山羊羔母的奶煮山羊羔。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","「看哪，我差遣使者在你前面，在路上保护你，领你到我所预备的地方去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","他是奉我名来的；你们要在他面前谨慎，听从他的话，不可惹他，因为他必不赦免你们的过犯。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","「你若实在听从他的话，照着我一切所说的去行，我就向你的仇敌作仇敌，向你的敌人作敌人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","「我的使者要在你前面行，领你到亚摩利人、赫人、比利洗人、迦南人、希未人、耶布斯人那里去，我必将他们剪除。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","你不可跪拜他们的神，不可事奉他，也不可效法他们的行为，却要把神像尽行拆毁，打碎他们的柱像。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","你们要事奉耶和华—你们的　神，他必赐福与你的粮与你的水，也必从你们中间除去疾病。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","你境内必没有坠胎的，不生产的。我要使你满了你年日的数目。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","凡你所到的地方，我要使那里的众民在你面前惊骇，扰乱，又要使你一切仇敌转背逃跑。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","我要打发黄蜂飞在你前面，把希未人、迦南人、赫人撵出去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","我不在一年之内将他们从你面前撵出去，恐怕地成为荒凉，野地的兽多起来害你。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","我要渐渐地将他们从你面前撵出去，等到你的人数加多，承受那地为业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","我要定你的境界，从红海直到非利士海，又从旷野直到大河。我要将那地的居民交在你手中，你要将他们从你面前撵出去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","不可和他们并他们的神立约。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","他们不可住在你的地上，恐怕他们使你得罪我。你若事奉他们的神，这必成为你的网罗。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","耶和华对摩西说：「你和亚伦、拿答、亚比户，并以色列长老中的七十人，都要上到我这里来，远远地下拜。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","惟独你可以亲近耶和华；他们却不可亲近；百姓也不可和你一同上来。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","摩西下山，将耶和华的命令典章都述说与百姓听。众百姓齐声说：「耶和华所吩咐的，我们都必遵行。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","摩西将耶和华的命令都写上。清早起来，在山下筑一座坛，按以色列十二支派立十二根柱子， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","又打发以色列人中的少年人去献燔祭，又向耶和华献牛为平安祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","摩西将血一半盛在盆中，一半洒在坛上； ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","又将约书念给百姓听。他们说：「耶和华所吩咐的，我们都必遵行。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","摩西将血洒在百姓身上，说：「你看！这是立约的血，是耶和华按这一切话与你们立约的凭据。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","摩西、亚伦、拿答、亚比户，并以色列长老中的七十人，都上了山。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","他们看见以色列的　神，他脚下仿佛有平铺的蓝宝石，如同天色明净。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","他的手不加害在以色列的尊者身上。他们观看　神；他们又吃又喝。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","耶和华对摩西说：「你上山到我这里来，住在这里，我要将石版并我所写的律法和诫命赐给你，使你可以教训百姓。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","摩西和他的帮手约书亚起来，上了　神的山。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","摩西对长老说：「你们在这里等着，等到我们再回来，有亚伦、户珥与你们同在。凡有争讼的，都可以就近他们去。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","摩西上山，有云彩把山遮盖。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","耶和华的荣耀停于西奈山；云彩遮盖山六天，第七天他从云中召摩西。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","耶和华的荣耀在山顶上，在以色列人眼前，形状如烈火。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","摩西进入云中上山，在山上四十昼夜。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","耶和华晓谕摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","「你告诉以色列人当为我送礼物来；凡甘心乐意的，你们就可以收下归我。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","所要收的礼物：就是金、银、铜， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","蓝色、紫色、朱红色线，细麻，山羊毛， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","染红的公羊皮，海狗皮，皂荚木， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","点灯的油并做膏油和香的香料， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","红玛瑙与别样的宝石，可以镶嵌在以弗得和胸牌上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","又当为我造圣所，使我可以住在他们中间。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","制造帐幕和其中的一切器具都要照我所指示你的样式。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","「要用皂荚木做一柜，长二肘半，宽一肘半，高一肘半。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","要里外包上精金，四围镶上金牙边。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","也要铸四个金环，安在柜的四脚上；这边两环，那边两环。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","要用皂荚木做两根杠，用金包裹。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","要把杠穿在柜旁的环内，以便抬柜。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","这杠要常在柜的环内，不可抽出来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","必将我所要赐给你的法版放在柜里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","要用精金做施恩座，长二肘半，宽一肘半。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","要用金子锤出两个基路伯来，安在施恩座的两头。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","这头做一个基路伯，那头做一个基路伯，二基路伯要接连一块，在施恩座的两头。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","二基路伯要高张翅膀，遮掩施恩座。基路伯要脸对脸，朝着施恩座。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","要将施恩座安在柜的上边，又将我所要赐给你的法版放在柜里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","我要在那里与你相会，又要从法柜施恩座上二基路伯中间，和你说我所要吩咐你传给以色列人的一切事。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","「要用皂荚木做一张桌子，长二肘，宽一肘，高一肘半。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","要包上精金，四围镶上金牙边。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","桌子的四围各做一掌宽的横梁，横梁上镶着金牙边。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","要做四个金环，安在桌子的四角上，就是桌子四脚上的四角。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","安环子的地方要挨近横梁，可以穿杠抬桌子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","要用皂荚木做两根杠，用金包裹，以便抬桌子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","要做桌子上的盘子、调羹，并奠酒的爵和瓶；这都要用精金制作。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","又要在桌子上，在我面前，常摆陈设饼。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","「要用精金做一个灯台。灯台的座和干与杯、球、花，都要接连一块锤出来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","灯台两旁要杈出六个枝子：这旁三个，那旁三个。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","这旁每枝上有三个杯，形状像杏花，有球，有花；那旁每枝上也有三个杯，形状像杏花，有球，有花。从灯台杈出来的六个枝子都是如此。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","灯台上有四个杯，形状像杏花，有球，有花。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","灯台每两个枝子以下有球与枝子接连一块。灯台出的六个枝子都是如此。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","球和枝子要接连一块，都是一块精金锤出来的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","要做灯台的七个灯盏。祭司要点这灯，使灯光对照。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","灯台的蜡剪和蜡花盘也是要精金的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","做灯台和这一切的器具要用精金一他连得。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","要谨慎做这些物件，都要照着在山上指示你的样式。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","「你要用十幅幔子做帐幕。这些幔子要用捻的细麻和蓝色、紫色、朱红色线制造，并用巧匠的手工绣上基路伯。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","每幅幔子要长二十八肘，宽四肘，幔子都要一样的尺寸。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","这五幅幔子要幅幅相连；那五幅幔子也要幅幅相连。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","在这相连的幔子末幅边上要做蓝色的钮扣；在那相连的幔子末幅边上也要照样做。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","要在这相连的幔子上做五十个钮扣；在那相连的幔子上也做五十个钮扣，都要两两相对。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","又要做五十个金钩，用钩使幔子相连，这才成了一个帐幕。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","「你要用山羊毛织十一幅幔子，作为帐幕以上的罩棚。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","每幅幔子要长三十肘，宽四肘；十一幅幔子都要一样的尺寸。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","要把五幅幔子连成一幅，又把六幅幔子连成一幅，这第六幅幔子要在罩棚的前面折上去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","在这相连的幔子末幅边上要做五十个钮扣；在那相连的幔子末幅边上也做五十个钮扣。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","又要做五十个铜钩，钩在钮扣中，使罩棚连成一个。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","罩棚的幔子所余那垂下来的半幅幔子，要垂在帐幕的后头。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","罩棚的幔子所余长的，这边一肘，那边一肘，要垂在帐幕的两旁，遮盖帐幕。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","又要用染红的公羊皮做罩棚的盖；再用海狗皮做一层罩棚上的顶盖。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","「你要用皂荚木做帐幕的竖板。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","每块要长十肘，宽一肘半； ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","每块必有两榫相对。帐幕一切的板都要这样做。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","帐幕的南面要做板二十块。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","在这二十块板底下要做四十个带卯的银座，两卯接这块板上的两榫，两卯接那块板上的两榫。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","帐幕第二面，就是北面，也要做板二十块 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","和带卯的银座四十个；这板底下有两卯，那板底下也有两卯。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","帐幕的后面，就是西面，要做板六块。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","帐幕后面的拐角要做板两块。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","板的下半截要双的，上半截要整的，直顶到第一个环子；两块都要这样做两个拐角。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","必有八块板和十六个带卯的银座；这板底下有两卯，那板底下也有两卯。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","「你要用皂荚木作闩：为帐幕这面的板作五闩， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","为帐幕那面的板做五闩，又为帐幕后面的板做五闩。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","板腰间的中闩要从这一头通到那一头。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","板要用金子包裹，又要做板上的金环套闩；闩也要用金子包裹。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","要照着在山上指示你的样式立起帐幕。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","「你要用蓝色、紫色、朱红色线，和捻的细麻织幔子，以巧匠的手工绣上基路伯。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","要把幔子挂在四根包金的皂荚木柱子上，柱子上当有金钩，柱子安在四个带卯的银座上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","要使幔子垂在钩子下，把法柜抬进幔子内；这幔子要将圣所和至圣所隔开。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","又要把施恩座安在至圣所内的法柜上， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","把桌子安在幔子外帐幕的北面；把灯台安在帐幕的南面，彼此相对。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","「你要拿蓝色、紫色、朱红色线，和捻的细麻，用绣花的手工织帐幕的门帘。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","要用皂荚木为帘子做五根柱子，用金子包裹。柱子上当有金钩；又要为柱子用铜铸造五个带卯的座。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","「你要用皂荚木做坛。这坛要四方的，长五肘，宽五肘，高三肘。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","要在坛的四拐角上做四个角，与坛接连一块，用铜把坛包裹。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","要做盆，收去坛上的灰，又做铲子、盘子、肉锸子、火鼎；坛上一切的器具都用铜做。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","要为坛做一个铜网，在网的四角上做四个铜环， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","把网安在坛四面的围腰板以下，使网从下达到坛的半腰。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","又要用皂荚木为坛做杠，用铜包裹。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","这杠要穿在坛两旁的环子内，用以抬坛。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","要用板做坛，坛是空的，都照着在山上指示你的样式做。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","「你要做帐幕的院子。院子的南面要用捻的细麻做帷子，长一百肘。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","帷子的柱子要二十根，带卯的铜座二十个。柱子上的钩子和杆子都要用银子做。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","北面也当有帷子，长一百肘，帷子的柱子二十根，带卯的铜座二十个。柱子上的钩子和杆子都要用银子做。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","院子的西面当有帷子，宽五十肘，帷子的柱子十根，带卯的座十个。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","院子的东面要宽五十肘。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","门这边的帷子要十五肘，帷子的柱子三根，带卯的座三个。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","门那边的帷子也要十五肘，帷子的柱子三根，带卯的座三个。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","院子的门当有帘子，长二十肘，要拿蓝色、紫色、朱红色线，和捻的细麻，用绣花的手工织成，柱子四根，带卯的座四个。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","院子四围一切的柱子都要用银杆连络，柱子上的钩子要用银做，带卯的座要用铜做。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","院子要长一百肘，宽五十肘，高五肘，帷子要用捻的细麻做，带卯的座要用铜做。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","帐幕各样用处的器具，并帐幕一切的橛子，和院子里一切的橛子，都要用铜做。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","「你要吩咐以色列人，把那为点灯捣成的清橄榄油拿来给你，使灯常常点着。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","在会幕中法柜前的幔外，亚伦和他的儿子，从晚上到早晨，要在耶和华面前经理这灯。这要作以色列人世世代代永远的定例。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","「你要从以色列人中，使你的哥哥亚伦和他的儿子拿答、亚比户、以利亚撒、以他玛一同就近你，给我供祭司的职分。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","你要给你哥哥亚伦做圣衣为荣耀，为华美。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","又要吩咐一切心中有智慧的，就是我用智慧的灵所充满的，给亚伦做衣服，使他分别为圣，可以给我供祭司的职分。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","所要做的就是胸牌、以弗得、外袍、杂色的内袍、冠冕、腰带，使你哥哥亚伦和他儿子穿这圣服，可以给我供祭司的职分。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","要用金线和蓝色、紫色、朱红色线，并细麻去做。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","「他们要拿金线和蓝色、紫色、朱红色线，并捻的细麻，用巧匠的手工做以弗得。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","以弗得当有两条肩带，接上两头，使它相连。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","其上巧工织的带子，要和以弗得一样的做法，用以束上，与以弗得接连一块，要用金线和蓝色、紫色、朱红色线，并捻的细麻做成。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","要取两块红玛瑙，在上面刻以色列儿子的名字： ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","六个名字在这块宝石上，六个名字在那块宝石上，都照他们生来的次序。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","要用刻宝石的手工，仿佛刻图书，按着以色列儿子的名字，刻这两块宝石，要镶在金槽上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","要将这两块宝石安在以弗得的两条肩带上，为以色列人做纪念石。亚伦要在两肩上担他们的名字，在耶和华面前作为纪念。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","要用金子做二槽， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","又拿精金，用拧工仿佛拧绳子，做两条链子，把这拧成的链子搭在二槽上。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","「你要用巧匠的手工做一个决断的胸牌。要和以弗得一样的做法：用金线和蓝色、紫色、朱红色线，并捻的细麻做成。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","这胸牌要四方的，叠为两层，长一虎口，宽一虎口。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","要在上面镶宝石四行：第一行是红宝石、红璧玺、红玉； ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","第二行是绿宝石、蓝宝石、金钢石； ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","第三行是紫玛瑙、白玛瑙、紫晶； ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","第四行是水苍玉、红玛瑙、碧玉。这都要镶在金槽中。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","这些宝石都要按着以色列十二个儿子的名字，仿佛刻图书，刻十二个支派的名字。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","要在胸牌上用精金拧成如绳的链子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","在胸牌上也要做两个金环，安在胸牌的两头。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","要把那两条拧成的金链子，穿过胸牌两头的环子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","又要把链子的那两头接在两槽上，安在以弗得前面肩带上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","要做两个金环，安在胸牌的两头，在以弗得里面的边上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","又要做两个金环，安在以弗得前面两条肩带的下边，挨近相接之处，在以弗得巧工织的带子以上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","要用蓝细带子把胸牌的环子与以弗得的环子系住，使胸牌贴在以弗得巧工织的带子上，不可与以弗得离缝。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","亚伦进圣所的时候，要将决断胸牌，就是刻着以色列儿子名字的，带在胸前，在耶和华面前常作纪念。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","又要将乌陵和土明放在决断的胸牌里；亚伦进到耶和华面前的时候，要带在胸前，在耶和华面前常将以色列人的决断牌带在胸前。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","「你要做以弗得的外袍，颜色全是蓝的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","袍上要为头留一领口，口的周围织出领边来，仿佛铠甲的领口，免得破裂。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","袍子周围底边上要用蓝色、紫色、朱红色线做石榴。在袍子周围的石榴中间要有金铃铛： ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","一个金铃铛一个石榴，一个金铃铛一个石榴，在袍子周围的底边上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","亚伦供职的时候要穿这袍子。他进圣所到耶和华面前，以及出来的时候，袍上的响声必被听见，使他不至于死亡。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","「你要用精金做一面牌，在上面按刻图书之法刻着『归耶和华为圣』。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","要用一条蓝细带子将牌系在冠冕的前面。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","这牌必在亚伦的额上，亚伦要担当干犯圣物条例的罪孽；这圣物是以色列人在一切的圣礼物上所分别为圣的。这牌要常在他的额上，使他们可以在耶和华面前蒙悦纳。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","要用杂色细麻线织内袍，用细麻布做冠冕，又用绣花的手工做腰带。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","「你要为亚伦的儿子做内袍、腰带、裹头巾，为荣耀，为华美。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","要把这些给你的哥哥亚伦和他的儿子穿戴，又要膏他们，将他们分别为圣，好给我供祭司的职分。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","要给他们做细麻布裤子，遮掩下体；裤子当从腰达到大腿。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","亚伦和他儿子进入会幕，或就近坛，在圣所供职的时候必穿上，免得担罪而死。这要为亚伦和他的后裔作永远的定例。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","「你使亚伦和他儿子成圣，给我供祭司的职分，要如此行：取一只公牛犊，两只无残疾的公绵羊， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","无酵饼和调油的无酵饼，与抹油的无酵薄饼；这都要用细麦面做成。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","这饼要装在一个筐子里，连筐子带来，又把公牛和两只公绵羊牵来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","要使亚伦和他儿子到会幕门口来，用水洗身。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","要给亚伦穿上内袍和以弗得的外袍，并以弗得，又带上胸牌，束上以弗得巧工织的带子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","把冠冕戴在他头上，将圣冠加在冠冕上， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","就把膏油倒在他头上膏他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","要叫他的儿子来，给他们穿上内袍。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","给亚伦和他儿子束上腰带，包上裹头巾，他们就凭永远的定例得了祭司的职任。又要将亚伦和他儿子分别为圣。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","「你要把公牛牵到会幕前，亚伦和他儿子要按手在公牛的头上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","你要在耶和华面前，在会幕门口，宰这公牛。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","要取些公牛的血，用指头抹在坛的四角上，把血都倒在坛脚那里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","要把一切盖脏的脂油与肝上的网子，并两个腰子和腰子上的脂油，都烧在坛上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","只是公牛的皮、肉、粪都要用火烧在营外。这牛是赎罪祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","「你要牵一只公绵羊来，亚伦和他儿子要按手在这羊的头上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","要宰这羊，把血洒在坛的周围。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","要把羊切成块子，洗净五脏和腿，连块子带头，都放在一处。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","要把全羊烧在坛上，是给耶和华献的燔祭，是献给耶和华为馨香的火祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","「你要将那一只公绵羊牵来，亚伦和他儿子要按手在羊的头上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","你要宰这羊，取点血抹在亚伦的右耳垂上和他儿子的右耳垂上，又抹在他们右手的大拇指上和右脚的大拇指上；并要把血洒在坛的四围。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","你要取点膏油和坛上的血，弹在亚伦和他的衣服上，并他儿子和他儿子的衣服上，他们和他们的衣服就一同成圣。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","「你要取这羊的脂油和肥尾巴，并盖脏的脂油与肝上的网子，两个腰子和腰子上的脂油并右腿（这是承接圣职所献的羊）。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","再从耶和华面前装无酵饼的筐子中取一个饼，一个调油的饼和一个薄饼， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","都放在亚伦的手上和他儿子的手上，作为摇祭，在耶和华面前摇一摇。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","要从他们手中接过来，烧在耶和华面前坛上的燔祭上，是献给耶和华为馨香的火祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","「你要取亚伦承接圣职所献公羊的胸，作为摇祭，在耶和华面前摇一摇，这就可以作你的分。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","那摇祭的胸和举祭的腿，就是承接圣职所摇的、所举的，是归亚伦和他儿子的。这些你都要成为圣， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","作亚伦和他子孙从以色列人中永远所得的分，因为是举祭。这要从以色列人的平安祭中，作为献给耶和华的举祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","「亚伦的圣衣要留给他的子孙，可以穿着受膏，又穿着承接圣职。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","他的子孙接续他当祭司的，每逢进会幕在圣所供职的时候，要穿七天。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","「你要将承接圣职所献公羊的肉煮在圣处。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","亚伦和他儿子要在会幕门口吃这羊的肉和筐内的饼。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","他们吃那些赎罪之物，好承接圣职，使他们成圣；只是外人不可吃，因为这是圣物。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","那承接圣职所献的肉或饼，若有一点留到早晨，就要用火烧了，不可吃这物，因为是圣物。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","「你要这样照我一切所吩咐的，向亚伦和他儿子行承接圣职的礼七天。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","每天要献公牛一只为赎罪祭。你洁净坛的时候，坛就洁净了；且要用膏抹坛，使坛成圣。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","要洁净坛七天，使坛成圣，坛就成为至圣。凡挨着坛的都成为圣。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","「你每天所要献在坛上的就是两只一岁的羊羔； ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","早晨要献这一只，黄昏的时候要献那一只。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","和这一只羊羔同献的，要用细面伊法十分之一与捣成的油一欣四分之一调和，又用酒一欣四分之一作为奠祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","那一只羊羔要在黄昏的时候献上，照着早晨的素祭和奠祭的礼办理，作为献给耶和华馨香的火祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","这要在耶和华面前、会幕门口，作你们世世代代常献的燔祭。我要在那里与你们相会，和你们说话。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","我要在那里与以色列人相会，会幕就要因我的荣耀成为圣。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","我要使会幕和坛成圣，也要使亚伦和他的儿子成圣，给我供祭司的职分。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","我要住在以色列人中间，作他们的　神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","他们必知道我是耶和华—他们的　神，是将他们从埃及地领出来的，为要住在他们中间。我是耶和华—他们的　神。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","「你要用皂荚木做一座烧香的坛。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","这坛要四方的，长一肘，宽一肘，高二肘；坛的四角要与坛接连一块。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","要用精金把坛的上面与坛的四围，并坛的四角，包裹；又要在坛的四围镶上金牙边。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","要做两个金环安在牙子边以下，在坛的两旁，两根横撑上，作为穿杠的用处，以便抬坛。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","要用皂荚木做杠，用金包裹。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","要把坛放在法柜前的幔子外，对着法柜上的施恩座，就是我要与你相会的地方。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","亚伦在坛上要烧馨香料做的香；每早晨他收拾灯的时候，要烧这香。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","黄昏点灯的时候，他要在耶和华面前烧这香，作为世世代代常烧的香。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","在这坛上不可奉上异样的香，不可献燔祭、素祭，也不可浇上奠祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","亚伦一年一次要在坛的角上行赎罪之礼。他一年一次要用赎罪祭牲的血在坛上行赎罪之礼，作为世世代代的定例。这坛在耶和华面前为至圣。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","耶和华晓谕摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","「你要按以色列人被数的，计算总数，你数的时候，他们各人要为自己的生命把赎价奉给耶和华，免得数的时候在他们中间有灾殃。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","凡过去归那些被数之人的，每人要按圣所的平，拿银子半舍客勒；这半舍客勒是奉给耶和华的礼物（一舍客勒是二十季拉）。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","凡过去归那些被数的人，从二十岁以外的，要将这礼物奉给耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","他们为赎生命将礼物奉给耶和华，富足的不可多出，贫穷的也不可少出，各人要出半舍客勒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","你要从以色列人收这赎罪银，作为会幕的使用，可以在耶和华面前为以色列人作纪念，赎生命。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","耶和华晓谕摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","「你要用铜做洗濯盆和盆座，以便洗濯。要将盆放在会幕和坛的中间，在盆里盛水。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","亚伦和他的儿子要在这盆里洗手洗脚。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","他们进会幕，或是就近坛前供职给耶和华献火祭的时候，必用水洗濯，免得死亡。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","他们洗手洗脚就免得死亡。这要作亚伦和他后裔世世代代永远的定例。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","耶和华晓谕摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","「你要取上品的香料，就是流质的没药五百舍客勒，香肉桂一半，就是二百五十舍客勒，菖蒲二百五十舍客勒， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","桂皮五百舍客勒，都按着圣所的平，又取橄榄油一欣， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","按做香之法调和做成圣膏油。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","要用这膏油抹会幕和法柜， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","桌子与桌子的一切器具，灯台和灯台的器具，并香坛、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","燔祭坛，和坛的一切器具，洗濯盆和盆座。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","要使这些物成为圣，好成为至圣；凡挨着的都成为圣。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","要膏亚伦和他的儿子，使他们成为圣，可以给我供祭司的职分。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","你要对以色列人说：『这油，我要世世代代以为圣膏油。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","不可倒在别人的身上，也不可按这调和之法做与此相似的。这膏油是圣的，你们也要以为圣。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","凡调和与此相似的，或将这膏膏在别人身上的，这人要从民中剪除。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","耶和华吩咐摩西说：「你要取馨香的香料，就是拿他弗、施喜列、喜利比拿；这馨香的香料和净乳香各样要一般大的分量。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","你要用这些加上盐，按做香之法做成清净圣洁的香。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","这香要取点捣得极细，放在会幕内、法柜前，我要在那里与你相会。你们要以这香为至圣。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","你们不可按这调和之法为自己做香；要以这香为圣，归耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","凡做香和这香一样，为要闻香味的，这人要从民中剪除。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","耶和华晓谕摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","「看哪，犹大支派中，户珥的孙子、乌利的儿子比撒列，我已经提他的名召他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","我也以我的灵充满了他，使他有智慧，有聪明，有知识，能做各样的工， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","能想出巧工，用金、银、铜制造各物， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","又能刻宝石，可以镶嵌，能雕刻木头，能做各样的工。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","我分派但支派中、亚希撒抹的儿子亚何利亚伯与他同工。凡心里有智慧的，我更使他们有智慧，能做我一切所吩咐的， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","就是会幕和法柜，并其上的施恩座，与会幕中一切的器具， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","桌子和桌子的器具，精金的灯台和灯台的一切器具并香坛， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","燔祭坛和坛的一切器具，并洗濯盆与盆座， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","精工做的礼服，和祭司亚伦并他儿子用以供祭司职分的圣衣， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","膏油和为圣所用馨香的香料。他们都要照我一切所吩咐的去做。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","耶和华晓谕摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","「你要吩咐以色列人说：『你们务要守我的安息日；因为这是你我之间世世代代的证据，使你们知道我—耶和华是叫你们成为圣的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","所以你们要守安息日，以为圣日。凡干犯这日的，必要把他治死；凡在这日做工的，必从民中剪除。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","六日要做工，但第七日是安息圣日，是向耶和华守为圣的。凡在安息日做工的，必要把他治死。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","故此，以色列人要世世代代守安息日为永远的约。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","这是我和以色列人永远的证据；因为六日之内耶和华造天地，第七日便安息舒畅。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","耶和华在西奈山和摩西说完了话，就把两块法版交给他，是　神用指头写的石版。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","百姓见摩西迟延不下山，就大家聚集到亚伦那里，对他说：「起来！为我们做神像，可以在我们前面引路；因为领我们出埃及地的那个摩西，我们不知道他遭了什么事。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","亚伦对他们说：「你们去摘下你们妻子、儿女耳上的金环，拿来给我。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","百姓就都摘下他们耳上的金环，拿来给亚伦。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","亚伦从他们手里接过来，铸了一只牛犊，用雕刻的器具做成。他们就说：「以色列啊，这是领你出埃及地的神。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","亚伦看见，就在牛犊面前筑坛，且宣告说：「明日要向耶和华守节。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","次日清早，百姓起来献燔祭和平安祭，就坐下吃喝，起来玩耍。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","耶和华吩咐摩西说：「下去吧，因为你的百姓，就是你从埃及地领出来的，已经败坏了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","他们快快偏离了我所吩咐的道，为自己铸了一只牛犊，向它下拜献祭，说：『以色列啊，这就是领你出埃及地的神。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","耶和华对摩西说：「我看这百姓真是硬着颈项的百姓。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","你且由着我，我要向他们发烈怒，将他们灭绝，使你的后裔成为大国。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","摩西便恳求耶和华—他的　神说：「耶和华啊，你为什么向你的百姓发烈怒呢？这百姓是你用大力和大能的手从埃及地领出来的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","为什么使埃及人议论说『他领他们出去，是要降祸与他们，把他们杀在山中，将他们从地上除灭』？求你转意，不发你的烈怒，后悔，不降祸与你的百姓。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","求你记念你的仆人亚伯拉罕、以撒、以色列。你曾指着自己起誓说：『我必使你们的后裔像天上的星那样多，并且我所应许的这全地，必给你们的后裔，他们要永远承受为业。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","于是耶和华后悔，不把所说的祸降与他的百姓。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","摩西转身下山，手里拿着两块法版。这版是两面写的，这面那面都有字， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","是　神的工作，字是　神写的，刻在版上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","约书亚一听见百姓呼喊的声音，就对摩西说：「在营里有争战的声音。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","摩西说：「这不是人打胜仗的声音，也不是人打败仗的声音；我所听见的乃是人歌唱的声音。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","摩西挨近营前就看见牛犊，又看见人跳舞，便发烈怒，把两块版扔在山下摔碎了， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","又将他们所铸的牛犊用火焚烧，磨得粉碎，撒在水面上，叫以色列人喝。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","摩西对亚伦说：「这百姓向你做了什么？你竟使他们陷在大罪里！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","亚伦说：「求我主不要发烈怒。这百姓专于作恶，是你知道的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","他们对我说：『你为我们做神像，可以在我们前面引路；因为领我们出埃及地的那个摩西，我们不知道他遭了什么事。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","我对他们说：『凡有金环的可以摘下来』，他们就给了我。我把金环扔在火中，这牛犊便出来了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","摩西见百姓放肆（亚伦纵容他们，使他们在仇敌中间被讥刺）， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","就站在营门中，说：「凡属耶和华的，都要到我这里来！」于是利未的子孙都到他那里聚集。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","他对他们说：「耶和华—以色列的　神这样说：『你们各人把刀跨在腰间，在营中往来，从这门到那门，各人杀他的弟兄与同伴并邻舍。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","利未的子孙照摩西的话行了。那一天百姓中被杀的约有三千。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","摩西说：「今天你们要自洁，归耶和华为圣，各人攻击他的儿子和弟兄，使耶和华赐福与你们。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","到了第二天，摩西对百姓说：「你们犯了大罪。我如今要上耶和华那里去，或者可以为你们赎罪。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","摩西回到耶和华那里，说：「唉！这百姓犯了大罪，为自己做了金像。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","倘或你肯赦免他们的罪......不然，求你从你所写的册上涂抹我的名。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","耶和华对摩西说：「谁得罪我，我就从我的册上涂抹谁的名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","现在你去领这百姓，往我所告诉你的地方去，我的使者必在你前面引路；只是到我追讨的日子，我必追讨他们的罪。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","耶和华杀百姓的缘故是因他们同亚伦做了牛犊。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","耶和华吩咐摩西说：「我曾起誓应许亚伯拉罕、以撒、雅各说：『要将迦南地赐给你的后裔。』现在你和你从埃及地所领出来的百姓，要从这里往那地去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","我要差遣使者在你前面，撵出迦南人、亚摩利人、赫人、比利洗人、希未人、耶布斯人， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","领你到那流奶与蜜之地。我自己不同你们上去；因为你们是硬着颈项的百姓，恐怕我在路上把你们灭绝。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","百姓听见这凶信就悲哀，也没有人佩戴妆饰。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","耶和华对摩西说：「你告诉以色列人说：『耶和华说：你们是硬着颈项的百姓，我若一霎时临到你们中间，必灭绝你们。现在你们要把身上的妆饰摘下来，使我可以知道怎样待你们。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","以色列人从住何烈山以后，就把身上的妆饰摘得干净。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","摩西素常将帐棚支搭在营外，离营却远，他称这帐棚为会幕。凡求问耶和华的，就到营外的会幕那里去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","当摩西出营到会幕去的时候，百姓就都起来，各人站在自己帐棚的门口，望着摩西，直等到他进了会幕。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","摩西进会幕的时候，云柱降下来，立在会幕的门前，耶和华便与摩西说话。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","众百姓看见云柱立在会幕门前，就都起来，各人在自己帐棚的门口下拜。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","耶和华与摩西面对面说话，好像人与朋友说话一般。摩西转到营里去，惟有他的帮手—一个少年人嫩的儿子约书亚不离开会幕。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","摩西对耶和华说：「你吩咐我说：『将这百姓领上去』，却没有叫我知道你要打发谁与我同去，只说：『我按你的名认识你，你在我眼前也蒙了恩。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","我如今若在你眼前蒙恩，求你将你的道指示我，使我可以认识你，好在你眼前蒙恩。求你想到这民是你的民。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","耶和华说：「我必亲自和你同去，使你得安息。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","摩西说：「你若不亲自和我同去，就不要把我们从这里领上去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","人在何事上得以知道我和你的百姓在你眼前蒙恩呢？岂不是因你与我们同去、使我和你的百姓与地上的万民有分别吗？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","耶和华对摩西说：「你这所求的我也要行；因为你在我眼前蒙了恩，并且我按你的名认识你。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","摩西说：「求你显出你的荣耀给我看。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","耶和华说：「我要显我一切的恩慈，在你面前经过，宣告我的名。我要恩待谁就恩待谁；要怜悯谁就怜悯谁」； ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","又说：「你不能看见我的面，因为人见我的面不能存活。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","耶和华说：「看哪，在我这里有地方，你要站在磐石上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","我的荣耀经过的时候，我必将你放在磐石穴中，用我的手遮掩你，等我过去， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","然后我要将我的手收回，你就得见我的背，却不得见我的面。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","耶和华吩咐摩西说：「你要凿出两块石版，和先前你摔碎的那版一样；其上的字我要写在这版上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","明日早晨，你要预备好了，上西奈山，在山顶上站在我面前。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","谁也不可和你一同上去，遍山都不可有人，在山根也不可叫羊群牛群吃草。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","摩西就凿出两块石版，和先前的一样。清晨起来，照耶和华所吩咐的上西奈山去，手里拿着两块石版。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","耶和华在云中降临，和摩西一同站在那里，宣告耶和华的名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","耶和华在他面前宣告说：「耶和华，耶和华，是有怜悯有恩典的　神，不轻易发怒，并有丰盛的慈爱和诚实， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","为千万人存留慈爱，赦免罪孽、过犯，和罪恶，万不以有罪的为无罪，必追讨他的罪，自父及子，直到三、四代。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","摩西急忙伏地下拜， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","说：「主啊，我若在你眼前蒙恩，求你在我们中间同行，因为这是硬着颈项的百姓。又求你赦免我们的罪孽和罪恶，以我们为你的产业。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","耶和华说：「我要立约，要在百姓面前行奇妙的事，是在遍地万国中所未曾行的。在你四围的外邦人就要看见耶和华的作为，因我向你所行的是可畏惧的事。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","「我今天所吩咐你的，你要谨守。我要从你面前撵出亚摩利人、迦南人、赫人、比利洗人、希未人、耶布斯人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","你要谨慎，不可与你所去那地的居民立约，恐怕成为你们中间的网罗； ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","却要拆毁他们的祭坛，打碎他们的柱像，砍下他们的木偶。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","不可敬拜别神；因为耶和华是忌邪的　神，名为忌邪者。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","只怕你与那地的居民立约，百姓随从他们的神，就行邪淫，祭祀他们的神，有人叫你，你便吃他的祭物， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","又为你的儿子娶他们的女儿为妻，他们的女儿随从她们的神，就行邪淫，使你的儿子也随从她们的神行邪淫。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","「不可为自己铸造神像。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","「你要守除酵节，照我所吩咐你的，在亚笔月内所定的日期吃无酵饼七天，因为你是这亚笔月内出了埃及。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","凡头生的都是我的；一切牲畜头生的，无论是牛是羊，公的都是我的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","头生的驴要用羊羔代赎，若不代赎就要打折它的颈项。凡头生的儿子都要赎出来。谁也不可空手朝见我。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","「你六日要做工，第七日要安息，虽在耕种收割的时候也要安息。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","在收割初熟麦子的时候要守七七节；又在年底要守收藏节。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","你们一切男丁要一年三次朝见主耶和华—以色列的　神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","我要从你面前赶出外邦人，扩张你的境界。你一年三次上去朝见耶和华—你　神的时候，必没有人贪慕你的地土。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","「你不可将我祭物的血和有酵的饼一同献上。逾越节的祭物也不可留到早晨。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","地里首先初熟之物要送到耶和华—你　神的殿。不可用山羊羔母的奶煮山羊羔。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","耶和华吩咐摩西说：「你要将这些话写上，因为我是按这话与你和以色列人立约。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","摩西在耶和华那里四十昼夜，也不吃饭也不喝水。耶和华将这约的话，就是十条诫，写在两块版上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","摩西手里拿着两块法版下西奈山的时候，不知道自己的面皮因耶和华和他说话就发了光。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","亚伦和以色列众人看见摩西的面皮发光就怕挨近他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","摩西叫他们来；于是亚伦和会众的官长都到他那里去，摩西就与他们说话。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","随后以色列众人都近前来，他就把耶和华在西奈山与他所说的一切话都吩咐他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","摩西与他们说完了话就用帕子蒙上脸。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","但摩西进到耶和华面前与他说话就揭去帕子，及至出来的时候便将耶和华所吩咐的告诉以色列人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","以色列人看见摩西的面皮发光。摩西又用帕子蒙上脸，等到他进去与耶和华说话就揭去帕子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","摩西招聚以色列全会众，对他们说：「这是耶和华所吩咐的话，叫你们照着行： ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","六日要做工，第七日乃为圣日，当向耶和华守为安息圣日。凡这日之内做工的，必把他治死。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","当安息日，不可在你们一切的住处生火。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","摩西对以色列全会众说：「耶和华所吩咐的是这样： ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","你们中间要拿礼物献给耶和华，凡乐意献的可以拿耶和华的礼物来，就是金、银、铜， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","蓝色、紫色、朱红色线，细麻，山羊毛， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","染红的公羊皮，海狗皮，皂荚木， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","点灯的油，并做膏油和香的香料， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","红玛瑙与别样的宝石，可以镶嵌在以弗得和胸牌上。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","「你们中间凡心里有智慧的都要来做耶和华一切所吩咐的： ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","就是帐幕和帐幕的罩棚，并帐幕的盖、钩子、板、闩、柱子、带卯的座， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","柜和柜的杠，施恩座和遮掩柜的幔子， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","桌子和桌子的杠与桌子的一切器具，并陈设饼， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","灯台和灯台的器具，灯盏并点灯的油， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","香坛和坛的杠，膏油和馨香的香料，并帐幕门口的帘子， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","燔祭坛和坛的铜网，坛的杠并坛的一切器具，洗濯盆和盆座， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","院子的帷子和帷子的柱子，带卯的座和院子的门帘， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","帐幕的橛子并院子的橛子，和这两处的绳子， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","精工做的礼服和祭司亚伦并他儿子在圣所用以供祭司职分的圣衣。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","以色列全会众从摩西面前退去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","凡心里受感和甘心乐意的都拿耶和华的礼物来，用以做会幕和其中一切的使用，又用以做圣衣。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","凡心里乐意献礼物的，连男带女，各将金器，就是胸前针、耳环、打印的戒指，和手钏带来献给耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","凡有蓝色、紫色、朱红色线，细麻，山羊毛，染红的公羊皮，海狗皮的，都拿了来； ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","凡献银子和铜给耶和华为礼物的都拿了来；凡有皂荚木可做什么使用的也拿了来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","凡心中有智慧的妇女亲手纺线，把所纺的蓝色、紫色、朱红色线，和细麻都拿了来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","凡有智慧、心里受感的妇女就纺山羊毛。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","众官长把红玛瑙和别样的宝石，可以镶嵌在以弗得与胸牌上的，都拿了来； ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","又拿香料做香，拿油点灯，做膏油。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","以色列人，无论男女，凡甘心乐意献礼物给耶和华的，都将礼物拿来，做耶和华借摩西所吩咐的一切工。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","摩西对以色列人说：「犹大支派中，户珥的孙子、乌利的儿子比撒列，耶和华已经提他的名召他， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","又以　神的灵充满了他，使他有智慧、聪明、知识，能做各样的工， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","能想出巧工，用金、银、铜制造各物， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","又能刻宝石，可以镶嵌，能雕刻木头，能做各样的巧工。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","耶和华又使他，和但支派中亚希撒抹的儿子亚何利亚伯，心里灵明，能教导人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","耶和华使他们的心满有智慧，能做各样的工，无论是雕刻的工，巧匠的工，用蓝色、紫色、朱红色线，和细麻、绣花的工，并机匠的工，他们都能做，也能想出奇巧的工。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","「比撒列和亚何利亚伯，并一切心里有智慧的，就是蒙耶和华赐智慧聪明、叫他知道做圣所各样使用之工的，都要照耶和华所吩咐的做工。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","凡耶和华赐他心里有智慧、而且受感前来做这工的，摩西把他们和比撒列并亚何利亚伯一同召来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","这些人就从摩西收了以色列人为做圣所并圣所使用之工所拿来的礼物。百姓每早晨还把甘心献的礼物拿来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","凡做圣所一切工的智慧人各都离开他所做的工， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","来对摩西说：「百姓为耶和华吩咐使用之工所拿来的，富富有余。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","摩西传命，他们就在全营中宣告说：「无论男女，不必再为圣所拿什么礼物来。」这样才拦住百姓不再拿礼物来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","因为他们所有的材料够做一切当做的物，而且有余。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","他们中间，凡心里有智慧做工的，用十幅幔子做帐幕。这幔子是比撒列用捻的细麻和蓝色、紫色、朱红色线制造的，并用巧匠的手工绣上基路伯。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","每幅幔子长二十八肘，宽四肘，都是一样的尺寸。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","他使这五幅幔子幅幅相连，又使那五幅幔子幅幅相连； ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","在这相连的幔子末幅边上做蓝色的钮扣，在那相连的幔子末幅边上也照样做； ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","在这相连的幔子上做五十个钮扣，在那相连的幔子上也做五十个钮扣，都是两两相对； ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","又做五十个金钩，使幔子相连。这才成了一个帐幕。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","他用山羊毛织十一幅幔子，作为帐幕以上的罩棚。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","每幅幔子长三十肘，宽四肘；十一幅幔子都是一样的尺寸。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","他把五幅幔子连成一幅，又把六幅幔子连成一幅； ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","在这相连的幔子末幅边上做五十个钮扣，在那相连的幔子末幅边上也做五十个钮扣； ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","又做五十个铜钩，使罩棚连成一个； ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","并用染红的公羊皮做罩棚的盖，再用海狗皮做一层罩棚上的顶盖。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","他用皂荚木做帐幕的竖板。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","每块长十肘，宽一肘半； ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","每块有两榫相对。帐幕一切的板都是这样做。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","帐幕的南面做板二十块。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","在这二十块板底下又做四十个带卯的银座：两卯接这块板上的两榫，两卯接那块板上的两榫。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","帐幕的第二面，就是北面，也做板二十块 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","和带卯的银座四十个：这板底下有两卯，那板底下也有两卯。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","帐幕的后面，就是西面，做板六块。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","帐幕后面的拐角做板两块。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","板的下半截是双的，上半截是整的，直到第一个环子；在帐幕的两个拐角上都是这样做。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","有八块板和十六个带卯的银座，每块板底下有两卯。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","他用皂荚木做闩：为帐幕这面的板做五闩， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","为帐幕那面的板做五闩，又为帐幕后面的板做五闩， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","使板腰间的中闩从这一头通到那一头。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","用金子将板包裹，又做板上的金环套闩；闩也用金子包裹。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","他用蓝色、紫色、朱红色线，和捻的细麻织幔子，以巧匠的手工绣上基路伯。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","为幔子做四根皂荚木柱子，用金包裹，柱子上有金钩，又为柱子铸了四个带卯的银座。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","拿蓝色、紫色、朱红色线，和捻的细麻，用绣花的手工织帐幕的门帘； ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","又为帘子做五根柱子和柱子上的钩子，用金子把柱顶和柱子上的杆子包裹。柱子有五个带卯的座，是铜的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","比撒列用皂荚木做柜，长二肘半，宽一肘半，高一肘半。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","里外包上精金，四围镶上金牙边， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","又铸四个金环，安在柜的四脚上：这边两环，那边两环。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","用皂荚木做两根杠，用金包裹。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","把杠穿在柜旁的环内，以便抬柜。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","用精金做施恩座，长二肘半，宽一肘半。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","用金子锤出两个基路伯来，安在施恩座的两头， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","这头做一个基路伯，那头做一个基路伯，二基路伯接连一块，在施恩座的两头。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","二基路伯高张翅膀，遮掩施恩座；基路伯是脸对脸，朝着施恩座。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","他用皂荚木做一张桌子，长二肘，宽一肘，高一肘半， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","又包上精金，四围镶上金牙边。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","桌子的四围各做一掌宽的横梁，横梁上镶着金牙边， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","又铸了四个金环，安在桌子四脚的四角上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","安环子的地方是挨近横梁，可以穿杠抬桌子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","他用皂荚木做两根杠，用金包裹，以便抬桌子； ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","又用精金做桌子上的器皿，就是盘子、调羹，并奠酒的瓶和爵。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","他用精金做一个灯台；这灯台的座和干，与杯、球、花，都是接连一块锤出来的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","灯台两旁杈出六个枝子：这旁三个，那旁三个。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","这旁每枝上有三个杯，形状像杏花，有球有花；那旁每枝上也有三个杯，形状像杏花，有球有花。从灯台杈出来的六个枝子都是如此。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","灯台上有四个杯，形状像杏花，有球有花。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","灯台每两个枝子以下有球，与枝子接连一块；灯台杈出的六个枝子都是如此。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","球和枝子是接连一块，都是一块精金锤出来的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","用精金做灯台的七个灯盏，并灯台的蜡剪和蜡花盘。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","他用精金一他连得做灯台和灯台的一切器具。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","他用皂荚木做香坛，是四方的，长一肘，宽一肘，高二肘，坛的四角与坛接连一块； ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","又用精金把坛的上面与坛的四面并坛的四角包裹，又在坛的四围镶上金牙边。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","做两个金环，安在牙子边以下，在坛的两旁、两根横撑上，作为穿杠的用处，以便抬坛。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","用皂荚木做杠，用金包裹。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","又按做香之法做圣膏油和馨香料的净香。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","他用皂荚木做燔祭坛，是四方的，长五肘，宽五肘，高三肘， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","在坛的四拐角上做四个角，与坛接连一块，用铜把坛包裹。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","他做坛上的盆、铲子、盘子、肉锸子、火鼎；这一切器具都是用铜做的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","又为坛做一个铜网，安在坛四面的围腰板以下，从下达到坛的半腰。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","为铜网的四角铸四个环子，作为穿杠的用处。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","用皂荚木做杠，用铜包裹， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","把杠穿在坛两旁的环子内，用以抬坛，并用板做坛；坛是空的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","他用铜做洗濯盆和盆座，是用会幕门前伺候的妇人之镜子做的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","他做帐幕的院子。院子的南面用捻的细麻做帷子，宽一百肘。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","帷子的柱子二十根，带卯的铜座二十个；柱子上的钩子和杆子都是用银子做的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","北面也有帷子，宽一百肘。帷子的柱子二十根，带卯的铜座二十个；柱子上的钩子和杆子都是用银子做的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","院子的西面有帷子，宽五十肘。帷子的柱子十根，带卯的座十个；柱子的钩子和杆子都是用银子做的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","院子的东面，宽五十肘。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","15","门这边的帷子十五肘，那边也是一样。帷子的柱子三根，带卯的座三个。在门的左右各有帷子十五肘，帷子的柱子三根，带卯的座三个。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","院子四面的帷子都是用捻的细麻做的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","柱子带卯的座是铜的，柱子上的钩子和杆子是银的，柱顶是用银子包的。院子一切的柱子都是用银杆连络的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","院子的门帘是以绣花的手工，用蓝色、紫色、朱红色线，和捻的细麻织的，宽二十肘，高五肘，与院子的帷子相配。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","帷子的柱子四根，带卯的铜座四个；柱子上的钩子和杆子是银的；柱顶是用银子包的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","帐幕一切的橛子和院子四围的橛子都是铜的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","这是法柜的帐幕中利未人所用物件的总数，是照摩西的吩咐，经祭司亚伦的儿子以他玛的手数点的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","凡耶和华所吩咐摩西的都是犹大支派户珥的孙子、乌利的儿子比撒列做的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","与他同工的有但支派中亚希撒抹的儿子亚何利亚伯；他是雕刻匠，又是巧匠，又能用蓝色、紫色、朱红色线，和细麻绣花。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","为圣所一切工作使用所献的金子，按圣所的平，有二十九他连得并七百三十舍客勒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","会中被数的人所出的银子，按圣所的平，有一百他连得并一千七百七十五舍客勒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","凡过去归那些被数之人的，从二十岁以外，有六十万零三千五百五十人。按圣所的平，每人出银半舍客勒，就是一比加。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","用那一百他连得银子铸造圣所带卯的座和幔子柱子带卯的座；一百他连得共一百带卯的座，每带卯的座用一他连得。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","用那一千七百七十五舍客勒银子做柱子上的钩子，包裹柱顶并柱子上的杆子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","所献的铜有七十他连得并二千四百舍客勒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","用这铜做会幕门带卯的座和铜坛，并坛上的铜网和坛的一切器具， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","并院子四围带卯的座和院门带卯的座，与帐幕一切的橛子和院子四围所有的橛子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","比撒列用蓝色、紫色、朱红色线做精致的衣服，在圣所用以供职，又为亚伦做圣衣，是照耶和华所吩咐摩西的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","他用金线和蓝色、紫色、朱红色线，并捻的细麻做以弗得； ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","把金子锤成薄片，剪出线来，与蓝色、紫色、朱红色线，用巧匠的手工一同绣上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","又为以弗得做两条相连的肩带，接连在以弗得的两头。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","其上巧工织的带子和以弗得一样的做法，用以束上，与以弗得接连一块，是用金线和蓝色、紫色、朱红色线，并捻的细麻做的，是照耶和华所吩咐摩西的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","又琢出两块红玛瑙，镶在金槽上，仿佛刻图书，按着以色列儿子的名字雕刻； ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","将这两块宝石安在以弗得的两条肩带上，为以色列人做纪念石，是照耶和华所吩咐摩西的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","他用巧匠的手工做胸牌，和以弗得一样的做法，用金线与蓝色、紫色、朱红色线，并捻的细麻做的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","胸牌是四方的，叠为两层；这两层长一虎口，宽一虎口， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","上面镶着宝石四行：第一行是红宝石、红璧玺、红玉； ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","第二行是绿宝石、蓝宝石、金钢石； ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","第三行是紫玛瑙、白玛瑙、紫晶； ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","第四行是水苍玉、红玛瑙、碧玉。这都镶在金槽中。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","这些宝石都是按着以色列十二个儿子的名字，仿佛刻图书，刻十二个支派的名字。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","在胸牌上，用精金拧成如绳子的链子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","又做两个金槽和两个金环，安在胸牌的两头。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","把那两条拧成的金链子穿过胸牌两头的环子， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","又把链子的那两头接在两槽上，安在以弗得前面肩带上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","做两个金环，安在胸牌的两头，在以弗得里面的边上， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","又做两个金环，安在以弗得前面两条肩带的下边，挨近相接之处，在以弗得巧工织的带子以上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","用一条蓝细带子把胸牌的环子和以弗得的环子系住，使胸牌贴在以弗得巧工织的带子上，不可与以弗得离缝，是照耶和华所吩咐摩西的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","他用织工做以弗得的外袍，颜色全是蓝的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","袍上留一领口，口的周围织出领边来，仿佛铠甲的领口，免得破裂。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","在袍子底边上，用蓝色、紫色、朱红色线，并捻的细麻做石榴， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","又用精金做铃铛，把铃铛钉在袍子周围底边上的石榴中间： ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","一个铃铛一个石榴，一个铃铛一个石榴，在袍子周围底边上用以供职，是照耶和华所吩咐摩西的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","他用织成的细麻布为亚伦和他的儿子做内袍， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","并用细麻布做冠冕和华美的裹头巾，用捻的细麻布做裤子， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","又用蓝色、紫色、朱红色线，并捻的细麻，以绣花的手工做腰带，是照耶和华所吩咐摩西的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","他用精金做圣冠上的牌，在上面按刻图书之法，刻着「归耶和华为圣」。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","又用一条蓝细带子将牌系在冠冕上，是照耶和华所吩咐摩西的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","帐幕，就是会幕，一切的工就这样做完了。凡耶和华所吩咐摩西的，以色列人都照样做了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","他们送到摩西那里。帐幕和帐幕的一切器具，就是钩子、板、闩、柱子、带卯的座， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","染红公羊皮的盖、海狗皮的顶盖，和遮掩柜的幔子， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","法柜和柜的杠并施恩座， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","桌子和桌子的一切器具并陈设饼， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","精金的灯台和摆列的灯盏，与灯台的一切器具，并点灯的油， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","金坛、膏油、馨香的香料、会幕的门帘， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","铜坛和坛上的铜网，坛的杠并坛的一切器具，洗濯盆和盆座， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","院子的帷子和柱子，并带卯的座，院子的门帘、绳子、橛子，并帐幕和会幕中一切使用的器具， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","精工做的礼服，和祭司亚伦并他儿子在圣所用以供祭司职分的圣衣。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","这一切工作都是以色列人照耶和华所吩咐摩西做的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","耶和华怎样吩咐的，他们就怎样做了。摩西看见一切的工都做成了，就给他们祝福。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","耶和华晓谕摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","「正月初一日，你要立起帐幕， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","把法柜安放在里面，用幔子将柜遮掩。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","把桌子搬进去，摆设上面的物。把灯台搬进去，点其上的灯。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","把烧香的金坛安在法柜前，挂上帐幕的门帘。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","把燔祭坛安在帐幕门前。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","把洗濯盆安在会幕和坛的中间，在盆里盛水。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","又在四围立院帷，把院子的门帘挂上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","用膏油把帐幕和其中所有的都抹上，使帐幕和一切器具成圣，就都成圣。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","又要抹燔祭坛和一切器具，使坛成圣，就都成为至圣。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","要抹洗濯盆和盆座，使盆成圣。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","要使亚伦和他儿子到会幕门口来，用水洗身。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","要给亚伦穿上圣衣，又膏他，使他成圣，可以给我供祭司的职分； ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","又要使他儿子来，给他们穿上内袍。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","怎样膏他们的父亲，也要照样膏他们，使他们给我供祭司的职分。他们世世代代凡受膏的，就永远当祭司的职任。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","摩西这样行，都是照耶和华所吩咐他的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","第二年正月初一日，帐幕就立起来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","摩西立起帐幕，安上带卯的座，立上板，穿上闩，立起柱子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","在帐幕以上搭罩棚，把罩棚的顶盖盖在其上，是照耶和华所吩咐他的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","又把法版放在柜里，把杠穿在柜的两旁，把施恩座安在柜上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","把柜抬进帐幕，挂上遮掩柜的幔子，把法柜遮掩了，是照耶和华所吩咐他的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","又把桌子安在会幕内，在帐幕北边，在幔子外。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","在桌子上将饼陈设在耶和华面前，是照耶和华所吩咐他的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","又把灯台安在会幕内，在帐幕南边，与桌子相对， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","在耶和华面前点灯，是照耶和华所吩咐他的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","把金坛安在会幕内的幔子前， ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","在坛上烧了馨香料做的香，是照耶和华所吩咐他的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","又挂上帐幕的门帘。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","在会幕的帐幕门前，安设燔祭坛，把燔祭和素祭献在其上，是照耶和华所吩咐他的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","把洗濯盆安在会幕和坛的中间，盆中盛水，以便洗濯。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","摩西和亚伦并亚伦的儿子在这盆里洗手洗脚。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","他们进会幕或就近坛的时候，便都洗濯，是照耶和华所吩咐他的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","在帐幕和坛的四围立了院帷，把院子的门帘挂上。这样，摩西就完了工。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","当时，云彩遮盖会幕，耶和华的荣光就充满了帐幕。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","摩西不能进会幕；因为云彩停在其上，并且耶和华的荣光充满了帐幕。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","每逢云彩从帐幕收上去，以色列人就起程前往； ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","云彩若不收上去，他们就不起程，直等到云彩收上去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","日间，耶和华的云彩是在帐幕以上；夜间，云中有火，在以色列全家的眼前。在他们所行的路上都是这样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","耶和华从会幕中呼叫摩西，对他说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","「你晓谕以色列人说：你们中间若有人献供物给耶和华，要从牛群羊群中献牲畜为供物。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","「他的供物若以牛为燔祭，就要在会幕门口献一只没有残疾的公牛，可以在耶和华面前蒙悦纳。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","他要按手在燔祭牲的头上，燔祭便蒙悦纳，为他赎罪。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","他要在耶和华面前宰公牛；亚伦子孙作祭司的，要奉上血，把血洒在会幕门口、坛的周围。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","那人要剥去燔祭牲的皮，把燔祭牲切成块子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","祭司亚伦的子孙要把火放在坛上，把柴摆在火上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","亚伦子孙作祭司的，要把肉块和头并脂油摆在坛上火的柴上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","但燔祭的脏腑与腿要用水洗。祭司就要把一切全烧在坛上，当作燔祭，献与耶和华为馨香的火祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","「人的供物若以绵羊或山羊为燔祭，就要献上没有残疾的公羊。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","要把羊宰于坛的北边，在耶和华面前；亚伦子孙作祭司的，要把羊血洒在坛的周围。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","要把燔祭牲切成块子，连头和脂油，祭司就要摆在坛上火的柴上； ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","但脏腑与腿要用水洗，祭司就要全然奉献，烧在坛上。这是燔祭，是献与耶和华为馨香的火祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","「人奉给耶和华的供物，若以鸟为燔祭，就要献斑鸠或是雏鸽为供物。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","祭司要把鸟拿到坛前，揪下头来，把鸟烧在坛上；鸟的血要流在坛的旁边； ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","又要把鸟的嗉子和脏物除掉，丢在坛的东边倒灰的地方。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","要拿着鸟的两个翅膀，把鸟撕开，只是不可撕断；祭司要在坛上、在火的柴上焚烧。这是燔祭，是献与耶和华为馨香的火祭。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","「若有人献素祭为供物给耶和华，要用细面浇上油，加上乳香， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","带到亚伦子孙作祭司的那里；祭司就要从细面中取出一把来，并取些油和所有的乳香，然后要把所取的这些作为纪念，烧在坛上，是献与耶和华为馨香的火祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","素祭所剩的要归给亚伦和他的子孙；这是献与耶和华的火祭中为至圣的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","「若用炉中烤的物为素祭，就要用调油的无酵细面饼，或是抹油的无酵薄饼。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","若用铁鏊上做的物为素祭，就要用调油的无酵细面， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","分成块子，浇上油；这是素祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","若用煎盘做的物为素祭，就要用油与细面做成。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","要把这些东西做的素祭带到耶和华面前，并奉给祭司，带到坛前。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","祭司要从素祭中取出作为纪念的，烧在坛上，是献与耶和华为馨香的火祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","素祭所剩的要归给亚伦和他的子孙。这是献与耶和华的火祭中为至圣的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","「凡献给耶和华的素祭都不可有酵；因为你们不可烧一点酵、一点蜜当作火祭献给耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","这些物要献给耶和华作为初熟的供物，只是不可在坛上献为馨香的祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","凡献为素祭的供物都要用盐调和，在素祭上不可缺了你　神立约的盐。一切的供物都要配盐而献。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","若向耶和华献初熟之物为素祭，要献上烘了的禾穗子，就是轧了的新穗子，当作初熟之物的素祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","并要抹上油，加上乳香；这是素祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","祭司要把其中作为纪念的，就是一些轧了的禾穗子和一些油，并所有的乳香，都焚烧，是向耶和华献的火祭。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","「人献供物为平安祭，若是从牛群中献，无论是公的是母的，必用没有残疾的献在耶和华面前。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","他要按手在供物的头上，宰于会幕门口。亚伦子孙作祭司的，要把血洒在坛的周围。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","从平安祭中，将火祭献给耶和华，也要把盖脏的脂油和脏上所有的脂油， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","并两个腰子和腰子上的脂油，就是靠腰两旁的脂油，与肝上的网子和腰子，一概取下。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","亚伦的子孙要把这些烧在坛的燔祭上，就是在火的柴上，是献与耶和华为馨香的火祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","「人向耶和华献供物为平安祭，若是从羊群中献，无论是公的是母的，必用没有残疾的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","若献一只羊羔为供物，必在耶和华面前献上， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","并要按手在供物的头上，宰于会幕前。亚伦的子孙要把血洒在坛的周围。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","从平安祭中，将火祭献给耶和华，其中的脂油和整肥尾巴都要在靠近脊骨处取下，并要把盖脏的脂油和脏上所有的脂油， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","两个腰子和腰子上的脂油，就是靠腰两旁的脂油，并肝上的网子和腰子，一概取下。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","祭司要在坛上焚烧，是献给耶和华为食物的火祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","「人的供物若是山羊，必在耶和华面前献上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","要按手在山羊头上，宰于会幕前。亚伦的子孙要把血洒在坛的周围， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","15","又把盖脏的脂油和脏上所有的脂油，两个腰子和腰子上的脂油，就是靠腰两旁的脂油，并肝上的网子和腰子，一概取下，献给耶和华为火祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","祭司要在坛上焚烧，作为馨香火祭的食物。脂油都是耶和华的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","在你们一切的住处，脂油和血都不可吃；这要成为你们世世代代永远的定例。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","耶和华对摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","「你晓谕以色列人说：若有人在耶和华所吩咐不可行的什么事上误犯了一件， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","或是受膏的祭司犯罪，使百姓陷在罪里，就当为他所犯的罪把没有残疾的公牛犊献给耶和华为赎罪祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","他要牵公牛到会幕门口，在耶和华面前按手在牛的头上，把牛宰于耶和华面前。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","受膏的祭司要取些公牛的血带到会幕， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","把指头蘸于血中，在耶和华面前对着圣所的幔子弹血七次， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","又要把些血抹在会幕内、耶和华面前香坛的四角上，再把公牛所有的血倒在会幕门口、燔祭坛的脚那里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","要把赎罪祭公牛所有的脂油，乃是盖脏的脂油和脏上所有的脂油， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","并两个腰子和腰子上的脂油，就是靠腰两旁的脂油，与肝上的网子和腰子，一概取下， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","与平安祭公牛上所取的一样；祭司要把这些烧在燔祭的坛上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","公牛的皮和所有的肉，并头、腿、脏、腑、粪， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","就是全公牛，要搬到营外洁净之地、倒灰之所，用火烧在柴上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","「以色列全会众若行了耶和华所吩咐不可行的什么事，误犯了罪，是隐而未现、会众看不出来的， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","会众一知道所犯的罪就要献一只公牛犊为赎罪祭，牵到会幕前。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","会中的长老就要在耶和华面前按手在牛的头上，将牛在耶和华面前宰了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","受膏的祭司要取些公牛的血带到会幕， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","把指头蘸于血中，在耶和华面前对着幔子弹血七次， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","又要把些血抹在会幕内、耶和华面前坛的四角上，再把所有的血倒在会幕门口、燔祭坛的脚那里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","把牛所有的脂油都取下，烧在坛上； ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","收拾这牛，与那赎罪祭的牛一样。祭司要为他们赎罪，他们必蒙赦免。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","他要把牛搬到营外烧了，像烧头一个牛一样；这是会众的赎罪祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","「官长若行了耶和华—他　神所吩咐不可行的什么事，误犯了罪， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","所犯的罪自己知道了，就要牵一只没有残疾的公山羊为供物， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","按手在羊的头上，宰于耶和华面前、宰燔祭牲的地方；这是赎罪祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","祭司要用指头蘸些赎罪祭牲的血，抹在燔祭坛的四角上，把血倒在燔祭坛的脚那里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","所有的脂油，祭司都要烧在坛上，正如平安祭的脂油一样。至于他的罪，祭司要为他赎了，他必蒙赦免。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","「民中若有人行了耶和华所吩咐不可行的什么事，误犯了罪， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","所犯的罪自己知道了，就要为所犯的罪牵一只没有残疾的母山羊为供物， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","按手在赎罪祭牲的头上，在那宰燔祭牲的地方宰了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","祭司要用指头蘸些羊的血，抹在燔祭坛的四角上，所有的血都要倒在坛的脚那里， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","又要把羊所有的脂油都取下，正如取平安祭牲的脂油一样。祭司要在坛上焚烧，在耶和华面前作为馨香的祭，为他赎罪，他必蒙赦免。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","「人若牵一只绵羊羔为赎罪祭的供物，必要牵一只没有残疾的母羊， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","按手在赎罪祭牲的头上，在那宰燔祭牲的地方宰了作赎罪祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","祭司要用指头蘸些赎罪祭牲的血，抹在燔祭坛的四角上，所有的血都要倒在坛的脚那里， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","又要把所有的脂油都取下，正如取平安祭羊羔的脂油一样。祭司要按献给耶和华火祭的条例，烧在坛上。至于所犯的罪，祭司要为他赎了，他必蒙赦免。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","「若有人听见发誓的声音，他本是见证，却不把所看见的、所知道的说出来，这就是罪；他要担当他的罪孽。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","或是有人摸了不洁的物，无论是不洁的死兽，是不洁的死畜，是不洁的死虫，他却不知道，因此成了不洁，就有了罪。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","或是他摸了别人的污秽，无论是染了什么污秽，他却不知道，一知道了就有了罪。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","或是有人嘴里冒失发誓，要行恶，要行善，无论人在什么事上冒失发誓，他却不知道，一知道了就要在这其中的一件上有了罪。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","他有了罪的时候，就要承认所犯的罪， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","并要因所犯的罪，把他的赎愆祭牲—就是羊群中的母羊，或是一只羊羔，或是一只山羊—牵到耶和华面前为赎罪祭。至于他的罪，祭司要为他赎了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","「他的力量若不够献一只羊羔，就要因所犯的罪，把两只斑鸠或是两只雏鸽带到耶和华面前为赎愆祭：一只作赎罪祭，一只作燔祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","把这些带到祭司那里，祭司就要先把那赎罪祭献上，从鸟的颈项上揪下头来，只是不可把鸟撕断， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","也把些赎罪祭牲的血弹在坛的旁边，剩下的血要流在坛的脚那里；这是赎罪祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","他要照例献第二只为燔祭。至于他所犯的罪，祭司要为他赎了，他必蒙赦免。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","「他的力量若不够献两只斑鸠或是两只雏鸽，就要因所犯的罪带供物来，就是细面伊法十分之一为赎罪祭；不可加上油，也不可加上乳香，因为是赎罪祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","他要把供物带到祭司那里，祭司要取出自己的一把来作为纪念，按献给耶和华火祭的条例烧在坛上；这是赎罪祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","至于他在这几件事中所犯的罪，祭司要为他赎了，他必蒙赦免。剩下的面都归与祭司，和素祭一样。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","耶和华晓谕摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","「人若在耶和华的圣物上误犯了罪，有了过犯，就要照你所估的，按圣所的舍客勒拿银子，将赎愆祭牲—就是羊群中一只没有残疾的公绵羊—牵到耶和华面前为赎愆祭； ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","并且他因在圣物上的差错要偿还，另外加五分之一，都给祭司。祭司要用赎愆祭的公绵羊为他赎罪，他必蒙赦免。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","「若有人犯罪，行了耶和华所吩咐不可行的什么事，他虽然不知道，还是有了罪，就要担当他的罪孽； ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","也要照你所估定的价，从羊群中牵一只没有残疾的公绵羊来，给祭司作赎愆祭。至于他误行的那错事，祭司要为他赎罪，他必蒙赦免。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","这是赎愆祭，因他在耶和华面前实在有了罪。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","耶和华晓谕摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","「若有人犯罪，干犯耶和华，在邻舍交付他的物上，或是在交易上行了诡诈，或是抢夺人的财物，或是欺压邻舍， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","或是在捡了遗失的物上行了诡诈，说谎起誓，在这一切的事上犯了什么罪； ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","他既犯了罪，有了过犯，就要归还他所抢夺的，或是因欺压所得的，或是人交付他的，或是人遗失他所捡的物， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","或是他因什么物起了假誓，就要如数归还，另外加上五分之一，在查出他有罪的日子要交还本主。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","也要照你所估定的价，把赎愆祭牲—就是羊群中一只没有残疾的公绵羊—牵到耶和华面前，给祭司为赎愆祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","祭司要在耶和华面前为他赎罪；他无论行了什么事，使他有了罪，都必蒙赦免。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","耶和华晓谕摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","「你要吩咐亚伦和他的子孙说，燔祭的条例乃是这样：燔祭要放在坛的柴上，从晚上到天亮，坛上的火要常常烧着。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","祭司要穿上细麻布衣服，又要把细麻布裤子穿在身上，把坛上所烧的燔祭灰收起来，倒在坛的旁边； ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","随后要脱去这衣服，穿上别的衣服，把灰拿到营外洁净之处。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","坛上的火要在其上常常烧着，不可熄灭。祭司要每日早晨在上面烧柴，并要把燔祭摆在坛上，在其上烧平安祭牲的脂油。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","在坛上必有常常烧着的火，不可熄灭。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","「素祭的条例乃是这样：亚伦的子孙要在坛前把这祭献在耶和华面前。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","祭司要从其中—就是从素祭的细面中—取出自己的一把，又要取些油和素祭上所有的乳香，烧在坛上，奉给耶和华为馨香素祭的纪念。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","所剩下的，亚伦和他子孙要吃，必在圣处不带酵而吃，要在会幕的院子里吃。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","烤的时候不可搀酵。这是从所献给我的火祭中赐给他们的分，是至圣的，和赎罪祭并赎愆祭一样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","凡献给耶和华的火祭，亚伦子孙中的男丁都要吃这一分，直到万代，作他们永得的分。摸这些祭物的，都要成为圣。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","耶和华晓谕摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","「当亚伦受膏的日子，他和他子孙所要献给耶和华的供物，就是细面伊法十分之一，为常献的素祭：早晨一半，晚上一半。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","要在铁鏊上用油调和做成，调匀了，你就拿进来；烤好了分成块子，献给耶和华为馨香的素祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","亚伦的子孙中，接续他为受膏的祭司，要把这素祭献上，要全烧给耶和华。这是永远的定例。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","祭司的素祭都要烧了，却不可吃。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","耶和华晓谕摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","「你对亚伦和他的子孙说，赎罪祭的条例乃是这样：要在耶和华面前、宰燔祭牲的地方宰赎罪祭牲；这是至圣的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","为赎罪献这祭的祭司要吃，要在圣处，就是在会幕的院子里吃。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","凡摸这祭肉的要成为圣；这祭牲的血若弹在什么衣服上，所弹的那一件要在圣处洗净。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","惟有煮祭物的瓦器要打碎；若是煮在铜器里，这铜器要擦磨，在水中涮净。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","凡祭司中的男丁都可以吃；这是至圣的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","凡赎罪祭，若将血带进会幕在圣所赎罪，那肉都不可吃，必用火焚烧。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","「赎愆祭的条例乃是如此：这祭是至圣的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","人在那里宰燔祭牲，也要在那里宰赎愆祭牲；其血，祭司要洒在坛的周围。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","又要将肥尾巴和盖脏的脂油， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","两个腰子和腰子上的脂油，就是靠腰两旁的脂油，并肝上的网子和腰子，一概取下。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","祭司要在坛上焚烧，为献给耶和华的火祭，是赎愆祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","祭司中的男丁都可以吃这祭物；要在圣处吃，是至圣的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","赎罪祭怎样，赎愆祭也是怎样，两个祭是一个条例。献赎愆祭赎罪的祭司要得这祭物。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","献燔祭的祭司，无论为谁奉献，要亲自得他所献那燔祭牲的皮。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","凡在炉中烤的素祭和煎盘中做的，并铁鏊上做的，都要归那献祭的祭司。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","凡素祭，无论是油调和的是干的，都要归亚伦的子孙，大家均分。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","「人献与耶和华平安祭的条例乃是这样： ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","他若为感谢献上，就要用调油的无酵饼和抹油的无酵薄饼，并用油调匀细面做的饼，与感谢祭一同献上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","要用有酵的饼和为感谢献的平安祭，与供物一同献上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","从各样的供物中，他要把一个饼献给耶和华为举祭，是要归给洒平安祭牲血的祭司。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","为感谢献平安祭牲的肉，要在献的日子吃，一点不可留到早晨。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","若所献的是为还愿，或是甘心献的，必在献祭的日子吃，所剩下的第二天也可以吃。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","但所剩下的祭肉，到第三天要用火焚烧； ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","第三天若吃了平安祭的肉，这祭必不蒙悦纳，人所献的也不算为祭，反为可憎嫌的，吃这祭肉的，就必担当他的罪孽。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","「挨了污秽物的肉就不可吃，要用火焚烧。至于平安祭的肉，凡洁净的人都要吃； ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","只是献与耶和华平安祭的肉，人若不洁净而吃了，这人必从民中剪除。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","有人摸了什么不洁净的物，或是人的不洁净，或是不洁净的牲畜，或是不洁可憎之物，吃了献与耶和华平安祭的肉，这人必从民中剪除。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","耶和华对摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","「你晓谕以色列人说：牛的脂油、绵羊的脂油、山羊的脂油，你们都不可吃。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","自死的和被野兽撕裂的，那脂油可以做别的使用，只是你们万不可吃。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","无论何人吃了献给耶和华当火祭牲畜的脂油，那人必从民中剪除。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","在你们一切的住处，无论是雀鸟的血是野兽的血，你们都不可吃。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","无论是谁吃血，那人必从民中剪除。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","耶和华对摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","「你晓谕以色列人说：献平安祭给耶和华的，要从平安祭中取些来奉给耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","他亲手献给耶和华的火祭，就是脂油和胸，要带来，好把胸在耶和华面前作摇祭，摇一摇。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","祭司要把脂油在坛上焚烧，但胸要归亚伦和他的子孙。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","你们要从平安祭中把右腿作举祭，奉给祭司。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","亚伦子孙中，献平安祭牲血和脂油的，要得这右腿为分； ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","因为我从以色列人的平安祭中，取了这摇的胸和举的腿给祭司亚伦和他子孙，作他们从以色列人中所永得的分。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","这是从耶和华火祭中，作亚伦受膏的分和他子孙受膏的分，正在摩西叫他们前来给耶和华供祭司职分的日子， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","就是在摩西膏他们的日子，耶和华吩咐以色列人给他们的。这是他们世世代代永得的分。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","这就是燔祭、素祭、赎罪祭、赎愆祭，和平安祭的条例，并承接圣职的礼， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","都是耶和华在西奈山所吩咐摩西的，就是他在西奈旷野吩咐以色列人献供物给耶和华之日所说的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","耶和华晓谕摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","「你将亚伦和他儿子一同带来，并将圣衣、膏油，与赎罪祭的一只公牛、两只公绵羊、一筐无酵饼都带来， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","又招聚会众到会幕门口。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","摩西就照耶和华所吩咐的行了；于是会众聚集在会幕门口。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","摩西告诉会众说：「这就是耶和华所吩咐当行的事。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","摩西带了亚伦和他儿子来，用水洗了他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","给亚伦穿上内袍，束上腰带，穿上外袍，又加上以弗得，用其上巧工织的带子把以弗得系在他身上， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","又给他戴上胸牌，把乌陵和土明放在胸牌内， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","把冠冕戴在他头上，在冠冕的前面钉上金牌，就是圣冠，都是照耶和华所吩咐摩西的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","摩西用膏油抹帐幕和其中所有的，使它成圣； ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","又用膏油在坛上弹了七次，又抹了坛和坛的一切器皿，并洗濯盆和盆座，使它成圣； ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","又把膏油倒在亚伦的头上膏他，使他成圣。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","摩西带了亚伦的儿子来，给他们穿上内袍，束上腰带，包上裹头巾，都是照耶和华所吩咐摩西的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","他牵了赎罪祭的公牛来，亚伦和他儿子按手在赎罪祭公牛的头上， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","就宰了公牛。摩西用指头蘸血，抹在坛上四角的周围，使坛洁净，把血倒在坛的脚那里，使坛成圣，坛就洁净了； ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","又取脏上所有的脂油和肝上的网子，并两个腰子与腰子上的脂油，都烧在坛上； ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","惟有公牛，连皮带肉并粪，用火烧在营外，都是照耶和华所吩咐摩西的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","他奉上燔祭的公绵羊；亚伦和他儿子按手在羊的头上， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","就宰了公羊。摩西把血洒在坛的周围， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","把羊切成块子，把头和肉块并脂油都烧了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","用水洗了脏腑和腿，就把全羊烧在坛上为馨香的燔祭，是献给耶和华的火祭，都是照耶和华所吩咐摩西的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","他又奉上第二只公绵羊，就是承接圣职之礼的羊；亚伦和他儿子按手在羊的头上， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","就宰了羊。摩西把些血抹在亚伦的右耳垂上和右手的大拇指上，并右脚的大拇指上， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","又带了亚伦的儿子来，把些血抹在他们的右耳垂上和右手的大拇指上，并右脚的大拇指上，又把血洒在坛的周围。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","取脂油和肥尾巴，并脏上一切的脂油与肝上的网子，两个腰子和腰子上的脂油，并右腿， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","再从耶和华面前、盛无酵饼的筐子里取出一个无酵饼，一个油饼，一个薄饼，都放在脂油和右腿上， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","把这一切放在亚伦的手上和他儿子的手上作摇祭，在耶和华面前摇一摇。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","摩西从他们的手上拿下来，烧在坛上的燔祭上，都是为承接圣职献给耶和华馨香的火祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","摩西拿羊的胸作为摇祭，在耶和华面前摇一摇，是承接圣职之礼，归摩西的分，都是照耶和华所吩咐摩西的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","摩西取点膏油和坛上的血，弹在亚伦和他的衣服上，并他儿子和他儿子的衣服上，使他和他们的衣服一同成圣。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","摩西对亚伦和他儿子说：「把肉煮在会幕门口，在那里吃，又吃承接圣职筐子里的饼，按我所吩咐的说：『这是亚伦和他儿子要吃的。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","剩下的肉和饼，你们要用火焚烧。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","你们七天不可出会幕的门，等到你们承接圣职的日子满了，因为主叫你们七天承接圣职。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","像今天所行的都是耶和华吩咐行的，为你们赎罪。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","七天你们要昼夜住在会幕门口，遵守耶和华的吩咐，免得你们死亡，因为所吩咐我的就是这样。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","于是亚伦和他儿子行了耶和华借着摩西所吩咐的一切事。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","到了第八天，摩西召了亚伦和他儿子，并以色列的众长老来， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","对亚伦说：「你当取牛群中的一只公牛犊作赎罪祭，一只公绵羊作燔祭，都要没有残疾的，献在耶和华面前。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","你也要对以色列人说：『你们当取一只公山羊作赎罪祭，又取一只牛犊和一只绵羊羔，都要一岁、没有残疾的，作燔祭， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","又取一只公牛，一只公绵羊作平安祭，献在耶和华面前，并取调油的素祭，因为今天耶和华要向你们显现。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","于是他们把摩西所吩咐的，带到会幕前；全会众都近前来，站在耶和华面前。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","摩西说：「这是耶和华吩咐你们所当行的；耶和华的荣光就要向你们显现。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","摩西对亚伦说：「你就近坛前，献你的赎罪祭和燔祭，为自己与百姓赎罪，又献上百姓的供物，为他们赎罪，都照耶和华所吩咐的。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","于是，亚伦就近坛前，宰了为自己作赎罪祭的牛犊。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","亚伦的儿子把血奉给他，他就把指头蘸在血中，抹在坛的四角上，又把血倒在坛脚那里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","惟有赎罪祭的脂油和腰子，并肝上取的网子，都烧在坛上，是照耶和华所吩咐摩西的； ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","又用火将肉和皮烧在营外。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","亚伦宰了燔祭牲，他儿子把血递给他，他就洒在坛的周围， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","又把燔祭一块一块地、连头递给他，他都烧在坛上； ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","又洗了脏腑和腿，烧在坛上的燔祭上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","他奉上百姓的供物，把那给百姓作赎罪祭的公山羊宰了，为罪献上，和先献的一样； ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","也奉上燔祭，照例而献。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","他又奉上素祭，从其中取一满把，烧在坛上；这是在早晨的燔祭以外。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","亚伦宰了那给百姓作平安祭的公牛和公绵羊。他儿子把血递给他，他就洒在坛的周围； ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","又把公牛和公绵羊的脂油、肥尾巴，并盖脏的脂油与腰子，和肝上的网子，都递给他； ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","把脂油放在胸上，他就把脂油烧在坛上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","胸和右腿，亚伦当作摇祭，在耶和华面前摇一摇，都是照摩西所吩咐的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","亚伦向百姓举手，为他们祝福。他献了赎罪祭、燔祭、平安祭就下来了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","摩西、亚伦进入会幕，又出来为百姓祝福，耶和华的荣光就向众民显现。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","有火从耶和华面前出来，在坛上烧尽燔祭和脂油；众民一见，就都欢呼，俯伏在地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","亚伦的儿子拿答、亚比户各拿自己的香炉，盛上火，加上香，在耶和华面前献上凡火，是耶和华没有吩咐他们的， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","就有火从耶和华面前出来，把他们烧灭，他们就死在耶和华面前。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","于是摩西对亚伦说：「这就是耶和华所说：『我在亲近我的人中要显为圣；在众民面前，我要得荣耀。』」亚伦就默默不言。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","摩西召了亚伦叔父乌薛的儿子米沙利、以利撒反来，对他们说：「上前来，把你们的亲属从圣所前抬到营外。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","于是二人上前来，把他们穿着袍子抬到营外，是照摩西所吩咐的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","摩西对亚伦和他儿子以利亚撒、以他玛说：「不可蓬头散发，也不可撕裂衣裳，免得你们死亡，又免得耶和华向会众发怒；只要你们的弟兄以色列全家为耶和华所发的火哀哭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","你们也不可出会幕的门，恐怕你们死亡，因为耶和华的膏油在你们的身上。」他们就照摩西的话行了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","耶和华晓谕亚伦说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","「你和你儿子进会幕的时候，清酒、浓酒都不可喝，免得你们死亡；这要作你们世世代代永远的定例。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","使你们可以将圣的、俗的，洁净的、不洁净的，分别出来； ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","又使你们可以将耶和华借摩西晓谕以色列人的一切律例教训他们。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","摩西对亚伦和他剩下的儿子以利亚撒、以他玛说：「你们献给耶和华火祭中所剩的素祭，要在坛旁不带酵而吃，因为是至圣的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","你们要在圣处吃；因为在献给耶和华的火祭中，这是你的分和你儿子的分；所吩咐我的本是这样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","所摇的胸，所举的腿，你们要在洁净地方吃。你和你的儿女都要同吃；因为这些是从以色列人平安祭中给你，当你的分和你儿子的分。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","所举的腿，所摇的胸，他们要与火祭的脂油一同带来当摇祭，在耶和华面前摇一摇；这要归你和你儿子，当作永得的分，都是照耶和华所吩咐的。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","当下摩西急切地寻找作赎罪祭的公山羊，谁知已经焚烧了，便向亚伦剩下的儿子以利亚撒、以他玛发怒，说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","「这赎罪祭既是至圣的，主又给了你们，为要你们担当会众的罪孽，在耶和华面前为他们赎罪，你们为何没有在圣所吃呢？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","看哪，这祭牲的血并没有拿到圣所里去，你们本当照我所吩咐的，在圣所里吃这祭肉。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","亚伦对摩西说：「今天他们在耶和华面前献上赎罪祭和燔祭，我又遇见这样的灾，若今天吃了赎罪祭，耶和华岂能看为美呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","摩西听见这话，便以为美。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","耶和华对摩西、亚伦说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","「你们晓谕以色列人说，在地上一切走兽中可吃的乃是这些： ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","凡蹄分两瓣、倒嚼的走兽，你们都可以吃。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","但那倒嚼或分蹄之中不可吃的乃是：骆驼—因为倒嚼不分蹄，就与你们不洁净； ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","沙番—因为倒嚼不分蹄，就与你们不洁净； ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","兔子—因为倒嚼不分蹄，就与你们不洁净； ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","猪—因为蹄分两瓣，却不倒嚼，就与你们不洁净。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","这些兽的肉，你们不可吃；死的，你们不可摸，都与你们不洁净。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","「水中可吃的乃是这些：凡在水里、海里、河里、有翅有鳞的，都可以吃。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","凡在海里、河里，并一切水里游动的活物，无翅无鳞的，你们都当以为可憎。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","这些无翅无鳞、以为可憎的，你们不可吃它的肉；死的也当以为可憎。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","凡水里无翅无鳞的，你们都当以为可憎。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","「雀鸟中你们当以为可憎、不可吃的乃是：雕、狗头雕、红头雕、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","鹞鹰、小鹰与其类； ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","乌鸦与其类； ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","鸵鸟、夜鹰、鱼鹰、鹰与其类； ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","鸮鸟、鸬鹚、猫头鹰、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","角鸱、鹈鹕、秃雕、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","鹳、鹭鸶与其类；戴 与蝙蝠。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","「凡有翅膀用四足爬行的物，你们都当以为可憎。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","只是有翅膀用四足爬行的物中，有足有腿，在地上蹦跳的，你们还可以吃。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","其中有蝗虫、蚂蚱、蟋蟀与其类；蚱蜢与其类；这些你们都可以吃。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","但是有翅膀有四足的爬物，你们都当以为可憎。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","「这些都能使你们不洁净。凡摸了死的，必不洁净到晚上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","凡拿了死的，必不洁净到晚上，并要洗衣服。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","凡走兽分蹄不成两瓣、也不倒嚼的，是与你们不洁净；凡摸了的就不洁净。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","凡四足的走兽，用掌行走的，是与你们不洁净；摸其尸的，必不洁净到晚上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","拿其尸的，必不洁净到晚上，并要洗衣服。这些是与你们不洁净的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","「地上爬物与你们不洁净的乃是这些：鼬鼠、鼫鼠、蜥蜴与其类； ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","壁虎、龙子、守宫、蛇医、蝘蜓。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","这些爬物都是与你们不洁净的。在它死了以后，凡摸了的，必不洁净到晚上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","其中死了的，掉在什么东西上，这东西就不洁净，无论是木器、衣服、皮子、口袋，不拘是做什么工用的器皿，须要放在水中，必不洁净到晚上，到晚上才洁净了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","若有死了掉在瓦器里的，其中不拘有什么，就不洁净，你们要把这瓦器打破了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","其中一切可吃的食物，沾水的就不洁净，并且那样器皿中一切可喝的，也必不洁净。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","其中已死的，若有一点掉在什么物件上，那物件就不洁净，不拘是炉子，是锅台，就要打碎，都不洁净，也必与你们不洁净。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","但是泉源或是聚水的池子仍是洁净；惟挨了那死的，就不洁净。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","若是死的，有一点掉在要种的子粒上，子粒仍是洁净； ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","若水已经浇在子粒上，那死的有一点掉在上头，这子粒就与你们不洁净。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","「你们可吃的走兽若是死了，有人摸它，必不洁净到晚上； ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","有人吃那死了的走兽，必不洁净到晚上，并要洗衣服；拿了死走兽的，必不洁净到晚上，并要洗衣服。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","「凡地上的爬物是可憎的，都不可吃。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","凡用肚子行走的和用四足行走的，或是有许多足的，就是一切爬在地上的，你们都不可吃，因为是可憎的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","你们不可因什么爬物使自己成为可憎的，也不可因这些使自己不洁净，以致染了污秽。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","我是耶和华—你们的　神；所以你们要成为圣洁，因为我是圣洁的。你们也不可在地上的爬物污秽自己。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","我是把你们从埃及地领出来的耶和华，要作你们的　神；所以你们要圣洁，因为我是圣洁的。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","这是走兽、飞鸟，和水中游动的活物，并地上爬物的条例。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","要把洁净的和不洁净的，可吃的与不可吃的活物，都分别出来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","耶和华对摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","「你晓谕以色列人说：若有妇人怀孕生男孩，她就不洁净七天，像在月经污秽的日子不洁净一样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","第八天，要给婴孩行割礼。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","妇人在产血不洁之中，要家居三十三天。她洁净的日子未满，不可摸圣物，也不可进入圣所。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","她若生女孩，就不洁净两个七天，像污秽的时候一样，要在产血不洁之中，家居六十六天。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","「满了洁净的日子，无论是为男孩是为女孩，她要把一岁的羊羔为燔祭，一只雏鸽或是一只斑鸠为赎罪祭，带到会幕门口交给祭司。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","祭司要献在耶和华面前，为她赎罪，她的血源就洁净了。这条例是为生育的妇人，无论是生男生女。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","她的力量若不够献一只羊羔，她就要取两只斑鸠或是两只雏鸽，一只为燔祭，一只为赎罪祭。祭司要为她赎罪，她就洁净了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","耶和华晓谕摩西、亚伦说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","「人的肉皮上若长了疖子，或长了癣，或长了火斑，在他肉皮上成了大麻风的灾病，就要将他带到祭司亚伦或亚伦作祭司的一个子孙面前。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","祭司要察看肉皮上的灾病，若灾病处的毛已经变白，灾病的现象深于肉上的皮，这便是大麻风的灾病。祭司要察看他，定他为不洁净。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","若火斑在他肉皮上是白的，现象不深于皮，其上的毛也没有变白，祭司就要将有灾病的人关锁七天。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","第七天，祭司要察看他，若看灾病止住了，没有在皮上发散，祭司还要将他关锁七天。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","第七天，祭司要再察看他，若灾病发暗，而且没有在皮上发散，祭司要定他为洁净，原来是癣；那人就要洗衣服，得为洁净。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","但他为得洁净，将身体给祭司察看以后，癣若在皮上发散开了，他要再将身体给祭司察看。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","祭司要察看，癣若在皮上发散，就要定他为不洁净，是大麻风。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","「人有了大麻风的灾病，就要将他带到祭司面前。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","祭司要察看，皮上若长了白疖，使毛变白，在长白疖之处有了红瘀肉， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","这是肉皮上的旧大麻风，祭司要定他为不洁净，不用将他关锁，因为他是不洁净了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","大麻风若在皮上四外发散，长满了患灾病人的皮，据祭司察看，从头到脚无处不有， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","祭司就要察看，全身的肉若长满了大麻风，就要定那患灾病的为洁净；全身都变为白，他乃洁净了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","但红肉几时显在他的身上就几时不洁净。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","祭司一看那红肉就定他为不洁净。红肉本是不洁净，是大麻风。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","红肉若复原，又变白了，他就要来见祭司。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","祭司要察看，灾病处若变白了，祭司就要定那患灾病的为洁净，他乃洁净了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","「人若在皮肉上长疮，却治好了， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","在长疮之处又起了白疖，或是白中带红的火斑，就要给祭司察看。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","祭司要察看，若现象洼于皮，其上的毛也变白了，就要定他为不洁净，是大麻风的灾病发在疮中。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","祭司若察看，其上没有白毛，也没有洼于皮，乃是发暗，就要将他关锁七天。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","若在皮上发散开了，祭司就要定他为不洁净，是灾病。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","火斑若在原处止住，没有发散，便是疮的痕迹，祭司就要定他为洁净。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","「人的皮肉上若起了火毒，火毒的瘀肉成了火斑，或是白中带红的，或是全白的， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","祭司就要察看，火斑中的毛若变白了，现象又深于皮，是大麻风在火毒中发出，就要定他为不洁净，是大麻风的灾病。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","但是祭司察看，在火斑中若没有白毛，也没有洼于皮，乃是发暗，就要将他关锁七天。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","到第七天，祭司要察看他，火斑若在皮上发散开了，就要定他为不洁净，是大麻风的灾病。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","火斑若在原处止住，没有在皮上发散，乃是发暗，是起的火毒，祭司要定他为洁净，不过是火毒的痕迹。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","「无论男女，若在头上有灾病，或是男人胡须上有灾病， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","祭司就要察看；这灾病现象若深于皮，其间有细黄毛，就要定他为不洁净，这是头疥，是头上或是胡须上的大麻风。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","祭司若察看头疥的灾病，现象不深于皮，其间也没有黑毛，就要将长头疥灾病的关锁七天。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","第七天，祭司要察看灾病，若头疥没有发散，其间也没有黄毛，头疥的现象不深于皮， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","那人就要剃去须发，但他不可剃头疥之处。祭司要将那长头疥的，再关锁七天。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","第七天，祭司要察看头疥，头疥若没有在皮上发散，现象也不深于皮，就要定他为洁净，他要洗衣服，便成为洁净。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","但他得洁净以后，头疥若在皮上发散开了， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","祭司就要察看他。头疥若在皮上发散，就不必找那黄毛，他是不洁净了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","祭司若看头疥已经止住，其间也长了黑毛，头疥已然痊愈，那人是洁净了，就要定他为洁净。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","「无论男女，皮肉上若起了火斑，就是白火斑， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","祭司就要察看，他们肉皮上的火斑若白中带黑，这是皮上发出的白癣，那人是洁净了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","「人头上的发若掉了，他不过是头秃，还是洁净。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","他顶前若掉了头发，他不过是顶门秃，还是洁净。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","头秃处或是顶门秃处若有白中带红的灾病，这就是大麻风发在他头秃处或是顶门秃处， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","祭司就要察看，他起的那灾病若在头秃处或是顶门秃处有白中带红的，像肉皮上大麻风的现象， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","那人就是长大麻风，不洁净的，祭司总要定他为不洁净，他的灾病是在头上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","「身上有长大麻风灾病的，他的衣服要撕裂，也要蓬头散发，蒙着上唇，喊叫说：『不洁净了！不洁净了！』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","灾病在他身上的日子，他便是不洁净；他既是不洁净，就要独居营外。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","「染了大麻风灾病的衣服，无论是羊毛衣服、是麻布衣服， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","无论是在经上、在纬上，是麻布的、是羊毛的，是在皮子上，或在皮子做的什么物件上， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","或在衣服上、皮子上，经上、纬上，或在皮子做的什么物件上，这灾病若是发绿，或是发红，是大麻风的灾病，要给祭司察看。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","祭司就要察看那灾病，把染了灾病的物件关锁七天。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","第七天，他要察看那灾病，灾病或在衣服上，经上、纬上，皮子上，若发散，这皮子无论当作何用，这灾病是蚕食的大麻风，都是不洁净了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","那染了灾病的衣服，或是经上、纬上，羊毛上，麻衣上，或是皮子做的什么物件上，他都要焚烧；因为这是蚕食的大麻风，必在火中焚烧。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","「祭司要察看，若灾病在衣服上，经上、纬上，或是皮子做的什么物件上，没有发散， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","祭司就要吩咐他们，把染了灾病的物件洗了，再关锁七天。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","洗过以后，祭司要察看，那物件若没有变色，灾病也没有消散，那物件就不洁净，是透重的灾病，无论正面反面，都要在火中焚烧。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","洗过以后，祭司要察看，若见那灾病发暗，他就要把那灾病从衣服上，皮子上，经上、纬上，都撕去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","若仍现在衣服上，或是经上、纬上、皮子做的什么物件上，这就是灾病又发了，必用火焚烧那染灾病的物件。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","所洗的衣服，或是经，或是纬，或是皮子做的什么物件，若灾病离开了，要再洗，就洁净了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","这就是大麻风灾病的条例，无论是在羊毛衣服上，麻布衣服上，经上、纬上，和皮子做的什么物件上，可以定为洁净或是不洁净。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","耶和华晓谕摩西说：「 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","长大麻风得洁净的日子，其例乃是这样：要带他去见祭司； ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","祭司要出到营外察看，若见他的大麻风痊愈了， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","就要吩咐人为那求洁净的拿两只洁净的活鸟和香柏木、朱红色线，并牛膝草来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","祭司要吩咐用瓦器盛活水，把一只鸟宰在上面。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","至于那只活鸟，祭司要把它和香柏木、朱红色线并牛膝草一同蘸于宰在活水上的鸟血中， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","用以在那长大麻风求洁净的人身上洒七次，就定他为洁净，又把活鸟放在田野里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","求洁净的人当洗衣服，剃去毛发，用水洗澡，就洁净了；然后可以进营，只是要在自己的帐棚外居住七天。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","第七天，再把头上所有的头发与胡须、眉毛，并全身的毛，都剃了；又要洗衣服，用水洗身，就洁净了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","「第八天，他要取两只没有残疾的公羊羔和一只没有残疾、一岁的母羊羔，又要把调油的细面伊法十分之三为素祭，并油一罗革，一同取来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","行洁净之礼的祭司要将那求洁净的人和这些东西安置在会幕门口、耶和华面前。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","祭司要取一只公羊羔献为赎愆祭，和那一罗革油一同作摇祭，在耶和华面前摇一摇； ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","把公羊羔宰于圣地，就是宰赎罪祭牲和燔祭牲之地。赎愆祭要归祭司，与赎罪祭一样，是至圣的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","祭司要取些赎愆祭牲的血，抹在求洁净人的右耳垂上和右手的大拇指上，并右脚的大拇指上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","祭司要从那一罗革油中取些倒在自己的左手掌里， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","把右手的一个指头蘸在左手的油里，在耶和华面前用指头弹七次。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","将手里所剩的油抹在那求洁净人的右耳垂上和右手的大拇指上，并右脚的大拇指上，就是抹在赎愆祭牲的血上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","祭司手里所剩的油要抹在那求洁净人的头上，在耶和华面前为他赎罪。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","祭司要献赎罪祭，为那本不洁净、求洁净的人赎罪；然后要宰燔祭牲， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","把燔祭和素祭献在坛上，为他赎罪，他就洁净了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","「他若贫穷不能预备够数，就要取一只公羊羔作赎愆祭，可以摇一摇，为他赎罪；也要把调油的细面伊法十分之一为素祭，和油一罗革一同取来； ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","又照他的力量取两只斑鸠或是两只雏鸽，一只作赎罪祭，一只作燔祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","第八天，要为洁净，把这些带到会幕门口、耶和华面前，交给祭司。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","祭司要把赎愆祭的羊羔和那一罗革油一同作摇祭，在耶和华面前摇一摇。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","要宰了赎愆祭的羊羔，取些赎愆祭牲的血，抹在那求洁净人的右耳垂上和右手的大拇指上，并右脚的大拇指上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","祭司要把些油倒在自己的左手掌里， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","把左手里的油，在耶和华面前，用右手的一个指头弹七次， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","又把手里的油抹些在那求洁净人的右耳垂上和右手的大拇指上，并右脚的大拇指上，就是抹赎愆祭之血的原处。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","祭司手里所剩的油要抹在那求洁净人的头上，在耶和华面前为他赎罪。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","那人又要照他的力量献上一只斑鸠或是一只雏鸽， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","就是他所能办的，一只为赎罪祭，一只为燔祭，与素祭一同献上；祭司要在耶和华面前为他赎罪。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","这是那有大麻风灾病的人、不能将关乎得洁净之物预备够数的条例。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","耶和华晓谕摩西、亚伦说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","「你们到了我赐给你们为业的迦南地，我若使你们所得为业之地的房屋中有大麻风的灾病， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","房主就要去告诉祭司说：『据我看，房屋中似乎有灾病。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","祭司还没有进去察看灾病以前，就要吩咐人把房子腾空，免得房子里所有的都成了不洁净；然后祭司要进去察看房子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","他要察看那灾病，灾病若在房子的墙上有发绿或发红的凹斑纹，现象洼于墙， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","祭司就要出到房门外，把房子封锁七天。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","第七天，祭司要再去察看，灾病若在房子的墙上发散， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","就要吩咐人把那有灾病的石头挖出来，扔在城外不洁净之处； ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","也要叫人刮房内的四围，所刮掉的灰泥要倒在城外不洁净之处； ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","又要用别的石头代替那挖出来的石头，要另用灰泥墁房子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","「他挖出石头，刮了房子，墁了以后，灾病若在房子里又发现， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","祭司就要进去察看，灾病若在房子里发散，这就是房内蚕食的大麻风，是不洁净。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","他就要拆毁房子，把石头、木头、灰泥都搬到城外不洁净之处。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","在房子封锁的时候，进去的人必不洁净到晚上； ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","在房子里躺着的必洗衣服；在房子里吃饭的也必洗衣服。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","「房子墁了以后，祭司若进去察看，见灾病在房内没有发散，就要定房子为洁净，因为灾病已经消除。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","要为洁净房子取两只鸟和香柏木、朱红色线并牛膝草， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","用瓦器盛活水，把一只鸟宰在上面， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","把香柏木、牛膝草、朱红色线，并那活鸟，都蘸在被宰的鸟血中与活水中，用以洒房子七次。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","要用鸟血、活水、活鸟、香柏木、牛膝草，并朱红色线，洁净那房子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","但要把活鸟放在城外田野里。这样洁净房子，房子就洁净了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","这是为各类大麻风的灾病和头疥， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","并衣服与房子的大麻风， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","以及疖子、癣、火斑所立的条例， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","指明何时为洁净，何时为不洁净。这是大麻风的条例。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","耶和华对摩西、亚伦说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","「你们晓谕以色列人说：人若身患漏症，他因这漏症就不洁净了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","他患漏症，无论是下流的，是止住的，都是不洁净。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","他所躺的床都为不洁净，所坐的物也为不洁净。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","凡摸那床的，必不洁净到晚上，并要洗衣服，用水洗澡。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","那坐患漏症人所坐之物的，必不洁净到晚上，并要洗衣服，用水洗澡。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","那摸患漏症人身体的，必不洁净到晚上，并要洗衣服，用水洗澡。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","若患漏症人吐在洁净的人身上，那人必不洁净到晚上，并要洗衣服，用水洗澡。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","患漏症人所骑的鞍子也为不洁净。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","凡摸了他身下之物的，必不洁净到晚上；拿了那物的，必不洁净到晚上，并要洗衣服，用水洗澡。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","患漏症的人没有用水涮手，无论摸了谁，谁必不洁净到晚上，并要洗衣服，用水洗澡。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","患漏症人所摸的瓦器就必打破；所摸的一切木器也必用水涮洗。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","「患漏症的人痊愈了，就要为洁净自己计算七天，也必洗衣服，用活水洗身，就洁净了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","第八天，要取两只斑鸠或是两只雏鸽，来到会幕门口、耶和华面前，把鸟交给祭司。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","祭司要献上一只为赎罪祭，一只为燔祭；因那人患的漏症，祭司要在耶和华面前为他赎罪。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","「人若梦遗，他必不洁净到晚上，并要用水洗全身。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","无论是衣服是皮子，被精所染，必不洁净到晚上，并要用水洗。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","若男女交合，两个人必不洁净到晚上，并要用水洗澡。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","「女人行经，必污秽七天；凡摸她的，必不洁净到晚上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","女人在污秽之中，凡她所躺的物件都为不洁净，所坐的物件也都不洁净。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","凡摸她床的，必不洁净到晚上，并要洗衣服，用水洗澡。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","凡摸她所坐什么物件的，必不洁净到晚上，并要洗衣服，用水洗澡。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","在女人的床上，或在她坐的物上，若有别的物件，人一摸了，必不洁净到晚上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","男人若与那女人同房，染了她的污秽，就要七天不洁净；所躺的床也为不洁净。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","「女人若在经期以外患多日的血漏，或是经期过长，有了漏症，她就因这漏症不洁净，与她在经期不洁净一样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","她在患漏症的日子所躺的床、所坐的物都要看为不洁净，与她月经的时候一样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","凡摸这些物件的，就为不洁净，必不洁净到晚上，并要洗衣服，用水洗澡。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","女人的漏症若好了，就要计算七天，然后才为洁净。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","第八天，要取两只斑鸠或是两只雏鸽，带到会幕门口给祭司。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","祭司要献一只为赎罪祭，一只为燔祭；因那人血漏不洁，祭司要在耶和华面前为她赎罪。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","「你们要这样使以色列人与他们的污秽隔绝，免得他们玷污我的帐幕，就因自己的污秽死亡。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","这是患漏症和梦遗而不洁净的， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","并有月经病的和患漏症的，无论男女，并人与不洁净女人同房的条例。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","亚伦的两个儿子近到耶和华面前死了。死了之后，耶和华晓谕摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","「要告诉你哥哥亚伦，不可随时进圣所的幔子内、到柜上的施恩座前，免得他死亡，因为我要从云中显现在施恩座上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","亚伦进圣所，要带一只公牛犊为赎罪祭，一只公绵羊为燔祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","要穿上细麻布圣内袍，把细麻布裤子穿在身上，腰束细麻布带子，头戴细麻布冠冕；这都是圣服。他要用水洗身，然后穿戴。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","要从以色列会众取两只公山羊为赎罪祭，一只公绵羊为燔祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","「亚伦要把赎罪祭的公牛奉上，为自己和本家赎罪； ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","也要把两只公山羊安置在会幕门口、耶和华面前， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","为那两只羊拈阄，一阄归与耶和华，一阄归与阿撒泻勒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","亚伦要把那拈阄归与耶和华的羊献为赎罪祭， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","但那拈阄归与阿撒泻勒的羊要活着安置在耶和华面前，用以赎罪，打发人送到旷野去，归与阿撒泻勒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","「亚伦要把赎罪祭的公牛牵来宰了，为自己和本家赎罪； ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","拿香炉，从耶和华面前的坛上盛满火炭，又拿一捧捣细的香料，都带入幔子内， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","在耶和华面前，把香放在火上，使香的烟云遮掩法柜上的施恩座，免得他死亡； ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","也要取些公牛的血，用指头弹在施恩座的东面，又在施恩座的前面弹血七次。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","「随后他要宰那为百姓作赎罪祭的公山羊，把羊的血带入幔子内，弹在施恩座的上面和前面，好像弹公牛的血一样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","他因以色列人诸般的污秽、过犯，就是他们一切的罪愆，当这样在圣所行赎罪之礼，并因会幕在他们污秽之中，也要照样而行。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","他进圣所赎罪的时候，会幕里不可有人，直等到他为自己和本家并以色列全会众赎了罪出来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","他出来，要到耶和华面前的坛那里，在坛上行赎罪之礼，又要取些公牛的血和公山羊的血，抹在坛上四角的周围； ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","也要用指头把血弹在坛上七次，洁净了坛，从坛上除掉以色列人诸般的污秽，使坛成圣。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","「亚伦为圣所和会幕并坛献完了赎罪祭，就要把那只活着的公山羊奉上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","两手按在羊头上，承认以色列人诸般的罪孽过犯，就是他们一切的罪愆，把这罪都归在羊的头上，借着所派之人的手，送到旷野去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","要把这羊放在旷野，这羊要担当他们一切的罪孽，带到无人之地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","「亚伦要进会幕，把他进圣所时所穿的细麻布衣服脱下，放在那里， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","又要在圣处用水洗身，穿上衣服，出来，把自己的燔祭和百姓的燔祭献上，为自己和百姓赎罪。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","赎罪祭牲的脂油要在坛上焚烧。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","那放羊归与阿撒泻勒的人要洗衣服，用水洗身，然后进营。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","作赎罪祭的公牛和公山羊的血既带入圣所赎罪，这牛羊就要搬到营外，将皮、肉、粪用火焚烧。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","焚烧的人要洗衣服，用水洗身，然后进营。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","「每逢七月初十日，你们要刻苦己心，无论是本地人，是寄居在你们中间的外人，什么工都不可做；这要作你们永远的定例。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","因在这日要为你们赎罪，使你们洁净。你们要在耶和华面前得以洁净，脱尽一切的罪愆。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","这日你们要守为圣安息日，要刻苦己心；这为永远的定例。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","那受膏、接续他父亲承接圣职的祭司要穿上细麻布的圣衣，行赎罪之礼。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","他要在至圣所和会幕与坛行赎罪之礼，并要为众祭司和会众的百姓赎罪。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","这要作你们永远的定例—就是因以色列人一切的罪，要一年一次为他们赎罪。」 于是，亚伦照耶和华所吩咐摩西的行了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","耶和华对摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","「你晓谕亚伦和他儿子并以色列众人说，耶和华所吩咐的乃是这样： ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","凡以色列家中的人宰公牛，或是绵羊羔，或是山羊，不拘宰于营内营外， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","若未曾牵到会幕门口、耶和华的帐幕前献给耶和华为供物，流血的罪必归到那人身上。他流了血，要从民中剪除。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","这是为要使以色列人把他们在田野里所献的祭带到会幕门口、耶和华面前，交给祭司，献与耶和华为平安祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","祭司要把血洒在会幕门口、耶和华的坛上，把脂油焚烧，献给耶和华为馨香的祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","他们不可再献祭给他们行邪淫所随从的鬼魔；这要作他们世世代代永远的定例。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","「你要晓谕他们说：凡以色列家中的人，或是寄居在他们中间的外人，献燔祭或是平安祭， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","若不带到会幕门口献给耶和华，那人必从民中剪除。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","「凡以色列家中的人，或是寄居在他们中间的外人，若吃什么血，我必向那吃血的人变脸，把他从民中剪除。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","因为活物的生命是在血中。我把这血赐给你们，可以在坛上为你们的生命赎罪；因血里有生命，所以能赎罪。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","因此，我对以色列人说：你们都不可吃血；寄居在你们中间的外人也不可吃血。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","凡以色列人，或是寄居在他们中间的外人，若打猎得了可吃的禽兽，必放出它的血来，用土掩盖。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","「论到一切活物的生命，就在血中。所以我对以色列人说：无论什么活物的血，你们都不可吃，因为一切活物的血就是他的生命。凡吃了血的，必被剪除。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","凡吃自死的，或是被野兽撕裂的，无论是本地人，是寄居的，必不洁净到晚上，都要洗衣服，用水洗身，到了晚上才为洁净。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","但他若不洗衣服，也不洗身，就必担当他的罪孽。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","耶和华对摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","「你晓谕以色列人说：我是耶和华—你们的　神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","你们从前住的埃及地，那里人的行为，你们不可效法，我要领你们到的迦南地，那里人的行为也不可效法，也不可照他们的恶俗行。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","你们要遵我的典章，守我的律例，按此而行。我是耶和华—你们的　神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","所以，你们要守我的律例典章；人若遵行，就必因此活着。我是耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","「你们都不可露骨肉之亲的下体，亲近他们。我是耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","不可露你母亲的下体，羞辱了你父亲。她是你的母亲，不可露她的下体。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","不可露你继母的下体；这本是你父亲的下体。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","你的姊妹，不拘是异母同父的，是异父同母的，无论是生在家生在外的，都不可露她们的下体。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","不可露你孙女或是外孙女的下体，露了她们的下体就是露了自己的下体。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","你继母从你父亲生的女儿本是你的妹妹，不可露她的下体。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","不可露你姑母的下体；她是你父亲的骨肉之亲。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","不可露你姨母的下体；她是你母亲的骨肉之亲。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","不可亲近你伯叔之妻，羞辱了你伯叔；她是你的伯叔母。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","不可露你儿妇的下体；她是你儿子的妻，不可露她的下体。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","不可露你弟兄妻子的下体；这本是你弟兄的下体。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","不可露了妇人的下体，又露她女儿的下体，也不可娶她孙女或是外孙女，露她们的下体；她们是骨肉之亲，这本是大恶。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","你妻还在的时候，不可另娶她的姊妹作对头，露她的下体。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","「女人行经不洁净的时候，不可露她的下体，与她亲近。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","不可与邻舍的妻行淫，玷污自己。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","不可使你的儿女经火归与摩洛，也不可亵渎你　神的名。我是耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","不可与男人苟合，像与女人一样；这本是可憎恶的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","不可与兽淫合，玷污自己。女人也不可站在兽前，与它淫合；这本是逆性的事。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","「在这一切的事上，你们都不可玷污自己；因为我在你们面前所逐出的列邦，在这一切的事上玷污了自己； ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","连地也玷污了，所以我追讨那地的罪孽，那地也吐出它的居民。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","故此，你们要守我的律例典章。这一切可憎恶的事，无论是本地人，是寄居在你们中间的外人，都不可行，（ ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","在你们以先居住那地的人行了这一切可憎恶的事，地就玷污了，） ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","免得你们玷污那地的时候，地就把你们吐出，像吐出在你们以先的国民一样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","无论什么人，行了其中可憎的一件事，必从民中剪除。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","所以，你们要守我所吩咐的，免得你们随从那些可憎的恶俗，就是在你们以先的人所常行的，以致玷污了自己。我是耶和华—你们的　神。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","耶和华对摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","「你晓谕以色列全会众说：你们要圣洁，因为我耶和华—你们的　神是圣洁的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","你们各人都当孝敬父母，也要守我的安息日。我是耶和华—你们的　神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","你们不可偏向虚无的神，也不可为自己铸造神像。我是耶和华—你们的　神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","你们献平安祭给耶和华的时候，要献得可蒙悦纳。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","这祭物要在献的那一天和第二天吃，若有剩到第三天的，就必用火焚烧。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","第三天若再吃，这就为可憎恶的，必不蒙悦纳。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","凡吃的人必担当他的罪孽；因为他亵渎了耶和华的圣物，那人必从民中剪除。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","「在你们的地收割庄稼，不可割尽田角，也不可拾取所遗落的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","不可摘尽葡萄园的果子，也不可拾取葡萄园所掉的果子；要留给穷人和寄居的。我是耶和华—你们的　神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","「你们不可偷盗，不可欺骗，也不可彼此说谎。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","不可指着我的名起假誓，亵渎你　神的名。我是耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","「不可欺压你的邻舍，也不可抢夺他的物。雇工人的工价，不可在你那里过夜，留到早晨。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","不可咒骂聋子，也不可将绊脚石放在瞎子面前，只要敬畏你的　神。我是耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","「你们施行审判，不可行不义；不可偏护穷人，也不可重看有势力的人，只要按着公义审判你的邻舍。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","不可在民中往来搬弄是非，也不可与邻舍为敌，置之于死。我是耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","「不可心里恨你的弟兄；总要指摘你的邻舍，免得因他担罪。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","不可报仇，也不可埋怨你本国的子民，却要爱人如己。我是耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","「你们要守我的律例。不可叫你的牲畜与异类配合；不可用两样搀杂的种种你的地，也不可用两样搀杂的料做衣服穿在身上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","「婢女许配了丈夫，还没有被赎、得释放，人若与她行淫，二人要受刑罚，却不把他们治死，因为婢女还没有得自由。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","那人要把赎愆祭，就是一只公绵羊牵到会幕门口、耶和华面前。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","祭司要用赎愆祭的羊在耶和华面前赎他所犯的罪，他的罪就必蒙赦免。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","「你们到了迦南地，栽种各样结果子的树木，就要以所结的果子如未受割礼的一样。三年之久，你们要以这些果子，如未受割礼的，是不可吃的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","但第四年所结的果子全要成为圣，用以赞美耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","第五年，你们要吃那树上的果子，好叫树给你们结果子更多。我是耶和华—你们的　神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","「你们不可吃带血的物；不可用法术，也不可观兆。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","头的周围不可剃，胡须的周围也不可损坏。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","不可为死人用刀划身，也不可在身上刺花纹。我是耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","「不可辱没你的女儿，使她为娼妓，恐怕地上的人专向淫乱，地就满了大恶。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","你们要守我的安息日，敬我的圣所。我是耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","「不可偏向那些交鬼的和行巫术的；不可求问他们，以致被他们玷污了。我是耶和华—你们的　神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","「在白发的人面前，你要站起来；也要尊敬老人，又要敬畏你的　神。我是耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","「若有外人在你们国中和你同居，就不可欺负他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","和你们同居的外人，你们要看他如本地人一样，并要爱他如己，因为你们在埃及地也作过寄居的。我是耶和华—你们的　神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","「你们施行审判，不可行不义；在尺、秤、升、斗上也是如此。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","要用公道天平、公道法码、公道升斗、公道秤。我是耶和华—你们的　神，曾把你们从埃及地领出来的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","你们要谨守遵行我一切的律例典章。我是耶和华。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","耶和华对摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","「你还要晓谕以色列人说：凡以色列人，或是在以色列中寄居的外人，把自己的儿女献给摩洛的，总要治死他；本地人要用石头把他打死。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","我也要向那人变脸，把他从民中剪除；因为他把儿女献给摩洛，玷污我的圣所，亵渎我的圣名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","那人把儿女献给摩洛，本地人若佯为不见，不把他治死， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","我就要向这人和他的家变脸，把他和一切随他与摩洛行邪淫的人都从民中剪除。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","「人偏向交鬼的和行巫术的，随他们行邪淫，我要向那人变脸，把他从民中剪除。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","所以你们要自洁成圣，因为我是耶和华—你们的　神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","你们要谨守遵行我的律例；我是叫你们成圣的耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","凡咒骂父母的，总要治死他；他咒骂了父母，他的罪要归到他身上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","「与邻舍之妻行淫的，奸夫淫妇都必治死。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","与继母行淫的，就是羞辱了他父亲，总要把他们二人治死，罪要归到他们身上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","与儿妇同房的，总要把他们二人治死；他们行了逆伦的事，罪要归到他们身上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","人若与男人苟合，像与女人一样，他们二人行了可憎的事，总要把他们治死，罪要归到他们身上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","人若娶妻，并娶其母，便是大恶，要把这三人用火焚烧，使你们中间免去大恶。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","人若与兽淫合，总要治死他，也要杀那兽。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","女人若与兽亲近，与它淫合，你要杀那女人和那兽，总要把他们治死，罪要归到他们身上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","「人若娶他的姊妹，无论是异母同父的，是异父同母的，彼此见了下体，这是可耻的事；他们必在本民的眼前被剪除。他露了姊妹的下体，必担当自己的罪孽。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","妇人有月经，若与她同房，露了她的下体，就是露了妇人的血源，妇人也露了自己的血源，二人必从民中剪除。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","不可露姨母或是姑母的下体，这是露了骨肉之亲的下体；二人必担当自己的罪孽。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","人若与伯叔之妻同房，就羞辱了他的伯叔；二人要担当自己的罪，必无子女而死。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","人若娶弟兄之妻，这本是污秽的事，羞辱了他的弟兄；二人必无子女。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","「所以，你们要谨守遵行我一切的律例典章，免得我领你们去住的那地把你们吐出。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","我在你们面前所逐出的国民，你们不可随从他们的风俗；因为他们行了这一切的事，所以我厌恶他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","但我对你们说过，你们要承受他们的地，就是我要赐给你们为业、流奶与蜜之地。我是耶和华—你们的　神，使你们与万民有分别的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","所以，你们要把洁净和不洁净的禽兽分别出来；不可因我给你们分为不洁净的禽兽，或是滋生在地上的活物，使自己成为可憎恶的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","你们要归我为圣，因为我—耶和华是圣的，并叫你们与万民有分别，使你们作我的民。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","「无论男女，是交鬼的或行巫术的，总要治死他们。人必用石头把他们打死，罪要归到他们身上。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","耶和华对摩西说：「你告诉亚伦子孙作祭司的说：祭司不可为民中的死人沾染自己， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","除非为他骨肉之亲的父母、儿女、弟兄， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","和未曾出嫁、作处女的姊妹，才可以沾染自己。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","祭司既在民中为首，就不可从俗沾染自己。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","不可使头光秃；不可剃除胡须的周围，也不可用刀划身。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","要归　神为圣，不可亵渎　神的名；因为耶和华的火祭，就是　神的食物，是他们献的，所以他们要成为圣。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","不可娶妓女或被污的女人为妻，也不可娶被休的妇人为妻，因为祭司是归　神为圣。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","所以你要使他成圣，因为他奉献你　神的食物；你要以他为圣，因为我—使你们成圣的耶和华—是圣的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","祭司的女儿若行淫辱没自己，就辱没了父亲，必用火将她焚烧。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","「在弟兄中作大祭司、头上倒了膏油、又承接圣职、穿了圣衣的，不可蓬头散发，也不可撕裂衣服。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","不可挨近死尸，也不可为父母沾染自己。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","不可出圣所，也不可亵渎　神的圣所，因为　神膏油的冠冕在他头上。我是耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","他要娶处女为妻。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","寡妇或是被休的妇人，或是被污为妓的女人，都不可娶；只可娶本民中的处女为妻。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","不可在民中辱没他的儿女，因为我是叫他成圣的耶和华。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","耶和华对摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","「你告诉亚伦说：你世世代代的后裔，凡有残疾的，都不可近前来献他　神的食物。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","因为凡有残疾的，无论是瞎眼的、瘸腿的、塌鼻子的、肢体有余的、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","折脚折手的、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","驼背的、矮矬的、眼睛有毛病的、长癣的、长疥的，或是损坏肾子的，都不可近前来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","祭司亚伦的后裔，凡有残疾的，都不可近前来，将火祭献给耶和华。他有残疾，不可近前来献　神的食物。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","神的食物，无论是圣的，至圣的，他都可以吃。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","但不可进到幔子前，也不可就近坛前；因为他有残疾，免得亵渎我的圣所。我是叫他成圣的耶和华。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","于是，摩西晓谕亚伦和亚伦的子孙，并以色列众人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","耶和华对摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","「你吩咐亚伦和他子孙说：要远离以色列人所分别为圣、归给我的圣物，免得亵渎我的圣名。我是耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","你要对他们说：你们世世代代的后裔，凡身上有污秽、亲近以色列人所分别为圣、归耶和华圣物的，那人必在我面前剪除。我是耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","亚伦的后裔，凡长大麻风的，或是有漏症的，不可吃圣物，直等他洁净了。无论谁摸那因死尸不洁净的物，或是遗精的人， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","或是摸什么使他不洁净的爬物，或是摸那使他不洁净的人（不拘那人有什么不洁净）， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","摸了这些人、物的，必不洁净到晚上；若不用水洗身，就不可吃圣物。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","日落的时候，他就洁净了，然后可以吃圣物，因为这是他的食物。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","自死的或是被野兽撕裂的，他不可吃，因此污秽自己。我是耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","所以他们要守我所吩咐的，免得轻忽了，因此担罪而死。我是叫他们成圣的耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","「凡外人不可吃圣物；寄居在祭司家的，或是雇工人，都不可吃圣物； ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","倘若祭司买人，是他的钱买的，那人就可以吃圣物；生在他家的人也可以吃。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","祭司的女儿若嫁外人，就不可吃举祭的圣物。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","但祭司的女儿若是寡妇，或是被休的，没有孩子，又归回父家，与她青年一样，就可以吃她父亲的食物；只是外人不可吃。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","若有人误吃了圣物，要照圣物的原数加上五分之一交给祭司。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","祭司不可亵渎以色列人所献给耶和华的圣物， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","免得他们在吃圣物上自取罪孽，因为我是叫他们成圣的耶和华。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","耶和华对摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","「你晓谕亚伦和他子孙，并以色列众人说：以色列家中的人，或在以色列中寄居的，凡献供物，无论是所许的愿，是甘心献的，就是献给耶和华作燔祭的， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","要将没有残疾的公牛，或是绵羊，或是山羊献上，如此方蒙悦纳。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","凡有残疾的，你们不可献上，因为这不蒙悦纳。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","凡从牛群或是羊群中，将平安祭献给耶和华，为要还特许的愿，或是作甘心献的，所献的必纯全无残疾的才蒙悦纳。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","瞎眼的、折伤的、残废的、有瘤子的、长癣的、长疥的都不可献给耶和华，也不可在坛上作为火祭献给耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","无论是公牛是绵羊羔，若肢体有余的，或是缺少的，只可作甘心祭献上；用以还愿，却不蒙悦纳。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","肾子损伤的，或是压碎的，或是破裂的，或是骟了的，不可献给耶和华，在你们的地上也不可这样行。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","这类的物，你们从外人的手，一样也不可接受作你们　神的食物献上；因为这些都有损坏，有残疾，不蒙悦纳。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","耶和华晓谕摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","「才生的公牛，或是绵羊或是山羊，七天当跟着母；从第八天以后，可以当供物蒙悦纳，作为耶和华的火祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","无论是母牛是母羊，不可同日宰母和子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","你们献感谢祭给耶和华，要献得可蒙悦纳。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","要当天吃，一点不可留到早晨。我是耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","「你们要谨守遵行我的诫命。我是耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","你们不可亵渎我的圣名；我在以色列人中，却要被尊为圣。我是叫你们成圣的耶和华， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","把你们从埃及地领出来，作你们的　神。我是耶和华。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","耶和华对摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","「你晓谕以色列人说：耶和华的节期，你们要宣告为圣会的节期。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","六日要做工，第七日是圣安息日，当有圣会；你们什么工都不可做。这是在你们一切的住处向耶和华守的安息日。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","耶和华的节期，就是你们到了日期要宣告为圣会的，乃是这些。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","「正月十四日，黄昏的时候，是耶和华的逾越节。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","这月十五日是向耶和华守的无酵节；你们要吃无酵饼七日。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","第一日当有圣会，什么劳碌的工都不可做； ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","要将火祭献给耶和华七日。第七日是圣会，什么劳碌的工都不可做。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","耶和华对摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","「你晓谕以色列人说：你们到了我赐给你们的地，收割庄稼的时候，要将初熟的庄稼一捆带给祭司。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","他要把这一捆在耶和华面前摇一摇，使你们得蒙悦纳。祭司要在安息日的次日把这捆摇一摇。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","摇这捆的日子，你们要把一岁、没有残疾的公绵羊羔献给耶和华为燔祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","同献的素祭，就是调油的细面伊法十分之二，作为馨香的火祭，献给耶和华。同献的奠祭，要酒一欣四分之一。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","无论是饼，是烘的子粒，是新穗子，你们都不可吃，直等到把你们献给　神的供物带来的那一天才可以吃。这在你们一切的住处作为世世代代永远的定例。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","「你们要从安息日的次日，献禾捆为摇祭的那日算起，要满了七个安息日。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","到第七个安息日的次日，共计五十天，又要将新素祭献给耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","要从你们的住处取出细面伊法十分之二，加酵，烤成两个摇祭的饼，当作初熟之物献给耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","又要将一岁、没有残疾的羊羔七只、公牛犊一只、公绵羊两只，和饼一同奉上。这些与同献的素祭和奠祭要作为燔祭献给耶和华，就是作馨香的火祭献给耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","你们要献一只公山羊为赎罪祭，两只一岁的公绵羊羔为平安祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","祭司要把这些和初熟麦子做的饼一同作摇祭，在耶和华面前摇一摇；这是献与耶和华为圣物归给祭司的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","当这日，你们要宣告圣会；什么劳碌的工都不可做。这在你们一切的住处作为世世代代永远的定例。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","「在你们的地收割庄稼，不可割尽田角，也不可拾取所遗落的；要留给穷人和寄居的。我是耶和华—你们的　神。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","耶和华对摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","「你晓谕以色列人说：七月初一，你们要守为圣安息日，要吹角作纪念，当有圣会。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","什么劳碌的工都不可做；要将火祭献给耶和华。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","耶和华晓谕摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","「七月初十是赎罪日；你们要守为圣会，并要刻苦己心，也要将火祭献给耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","当这日，什么工都不可做；因为是赎罪日，要在耶和华—你们的　神面前赎罪。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","当这日，凡不刻苦己心的，必从民中剪除。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","凡这日做什么工的，我必将他从民中除灭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","你们什么工都不可做。这在你们一切的住处作为世世代代永远的定例。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","你们要守这日为圣安息日，并要刻苦己心。从这月初九日晚上到次日晚上，要守为安息日。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","耶和华对摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","「你晓谕以色列人说：这七月十五日是住棚节，要在耶和华面前守这节七日。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","第一日当有圣会，什么劳碌的工都不可做。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","七日内要将火祭献给耶和华。第八日当守圣会，要将火祭献给耶和华。这是严肃会，什么劳碌的工都不可做。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","「这是耶和华的节期，就是你们要宣告为圣会的节期；要将火祭、燔祭、素祭、祭物，并奠祭，各归各日，献给耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","这是在耶和华的安息日以外，又在你们的供物和所许的愿，并甘心献给耶和华的以外。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","「你们收藏了地的出产，就从七月十五日起，要守耶和华的节七日。第一日为圣安息；第八日也为圣安息。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","第一日要拿美好树上的果子和棕树上的枝子，与茂密树的枝条并河旁的柳枝，在耶和华—你们的　神面前欢乐七日。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","每年七月间，要向耶和华守这节七日。这为你们世世代代永远的定例。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","你们要住在棚里七日；凡以色列家的人都要住在棚里， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","好叫你们世世代代知道，我领以色列人出埃及地的时候曾使他们住在棚里。我是耶和华—你们的　神。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","于是，摩西将耶和华的节期传给以色列人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","耶和华晓谕摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","「要吩咐以色列人，把那为点灯捣成的清橄榄油拿来给你，使灯常常点着。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","在会幕中法柜的幔子外，亚伦从晚上到早晨必在耶和华面前经理这灯。这要作你们世世代代永远的定例。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","他要在耶和华面前常收拾精金灯台上的灯。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","「你要取细面，烤成十二个饼，每饼用面伊法十分之二。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","要把饼摆列两行，每行六个，在耶和华面前精金的桌子上； ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","又要把净乳香放在每行饼上，作为纪念，就是作为火祭献给耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","每安息日要常摆在耶和华面前；这为以色列人作永远的约。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","这饼是要给亚伦和他子孙的；他们要在圣处吃，为永远的定例，因为在献给耶和华的火祭中是至圣的。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","有一个以色列妇人的儿子，他父亲是埃及人，一日闲游在以色列人中。这以色列妇人的儿子和一个以色列人在营里争斗。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","这以色列妇人的儿子亵渎了圣名，并且咒诅，就有人把他送到摩西那里。（他母亲名叫示罗密，是但支派底伯利的女儿。） ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","他们把那人收在监里，要得耶和华所指示的话。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","耶和华晓谕摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","「把那咒诅圣名的人带到营外。叫听见的人都放手在他头上；全会众就要用石头打死他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","你要晓谕以色列人说：凡咒诅　神的，必担当他的罪。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","那亵渎耶和华名的，必被治死；全会众总要用石头打死他。不管是寄居的是本地人，他亵渎耶和华名的时候，必被治死。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","打死人的，必被治死； ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","打死牲畜的，必赔上牲畜，以命偿命。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","人若使他邻舍的身体有残疾，他怎样行，也要照样向他行： ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","以伤还伤，以眼还眼，以牙还牙。他怎样叫人的身体有残疾，也要照样向他行。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","打死牲畜的，必赔上牲畜；打死人的，必被治死。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","不管是寄居的是本地人，同归一例。我是耶和华—你们的　神。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","于是，摩西晓谕以色列人，他们就把那咒诅圣名的人带到营外，用石头打死。以色列人就照耶和华所吩咐摩西的行了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","耶和华在西奈山对摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","「你晓谕以色列人说：你们到了我所赐你们那地的时候，地就要向耶和华守安息。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","六年要耕种田地，也要修理葡萄园，收藏地的出产。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","第七年，地要守圣安息，就是向耶和华守的安息，不可耕种田地，也不可修理葡萄园。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","遗落自长的庄稼不可收割；没有修理的葡萄树也不可摘取葡萄。这年，地要守圣安息。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","地在安息年所出的，要给你和你的仆人、婢女、雇工人，并寄居的外人当食物。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","这年的土产也要给你的牲畜和你地上的走兽当食物。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","「你要计算七个安息年，就是七七年。这便为你成了七个安息年，共是四十九年。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","当年七月初十日，你要大发角声；这日就是赎罪日，要在遍地发出角声。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","第五十年，你们要当作圣年，在遍地给一切的居民宣告自由。这年必为你们的禧年，各人要归自己的产业，各归本家。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","第五十年要作为你们的禧年。这年不可耕种；地中自长的，不可收割；没有修理的葡萄树也不可摘取葡萄。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","因为这是禧年，你们要当作圣年，吃地中自出的土产。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","「这禧年，你们各人要归自己的地业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","你若卖什么给邻舍，或是从邻舍的手中买什么，彼此不可亏负。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","你要按禧年以后的年数向邻舍买；他也要按年数的收成卖给你。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","年岁若多，要照数加添价值；年岁若少，要照数减去价值，因为他照收成的数目卖给你。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","你们彼此不可亏负，只要敬畏你们的　神，因为我是耶和华—你们的　神。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","「我的律例，你们要遵行，我的典章，你们要谨守，就可以在那地上安然居住。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","地必出土产，你们就要吃饱，在那地上安然居住。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","你们若说：『这第七年我们不耕种，也不收藏土产，吃什么呢？』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","我必在第六年将我所命的福赐给你们，地便生三年的土产。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","第八年，你们要耕种，也要吃陈粮，等到第九年出产收来的时候，你们还吃陈粮。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","「地不可永卖，因为地是我的；你们在我面前是客旅，是寄居的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","在你们所得为业的全地，也要准人将地赎回。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","你的弟兄若渐渐穷乏，卖了几分地业，他至近的亲属就要来把弟兄所卖的赎回。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","若没有能给他赎回的，他自己渐渐富足，能够赎回， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","就要算出卖地的年数，把余剩年数的价值还那买主，自己便归回自己的地业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","倘若不能为自己得回所卖的，仍要存在买主的手里直到禧年；到了禧年，地业要出买主的手，自己便归回自己的地业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","「人若卖城内的住宅，卖了以后，一年之内可以赎回；在一整年，必有赎回的权柄。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","若在一整年之内不赎回，这城内的房屋就定准永归买主，世世代代为业；在禧年也不得出买主的手。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","但房屋在无城墙的村庄里，要看如乡下的田地一样，可以赎回；到了禧年，都要出买主的手。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","然而利未人所得为业的城邑，其中的房屋，利未人可以随时赎回。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","若是一个利未人不将所卖的房屋赎回，是在所得为业的城内，到了禧年就要出买主的手，因为利未人城邑的房屋是他们在以色列人中的产业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","只是他们各城郊野之地不可卖，因为是他们永远的产业。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","「你的弟兄在你那里若渐渐贫穷，手中缺乏，你就要帮补他，使他与你同住，像外人和寄居的一样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","不可向他取利，也不可向他多要；只要敬畏你的　神，使你的弟兄与你同住。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","你借钱给他，不可向他取利；借粮给他，也不可向他多要。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","我是耶和华—你们的　神，曾领你们从埃及地出来，为要把迦南地赐给你们，要作你们的　神。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","「你的弟兄若在你那里渐渐穷乏，将自己卖给你，不可叫他像奴仆服事你。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","他要在你那里像雇工人和寄居的一样，要服事你直到禧年。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","到了禧年，他和他儿女要离开你，一同出去归回本家，到他祖宗的地业那里去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","因为他们是我的仆人，是我从埃及地领出来的，不可卖为奴仆。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","不可严严地辖管他，只要敬畏你的　神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","至于你的奴仆、婢女，可以从你四围的国中买。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","并且那寄居在你们中间的外人和他们的家属，在你们地上所生的，你们也可以从其中买人；他们要作你们的产业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","你们要将他们遗留给你们的子孙为产业，要永远从他们中间拣出奴仆；只是你们的弟兄以色列人，你们不可严严地辖管。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","「住在你那里的外人，或是寄居的，若渐渐富足，你的弟兄却渐渐穷乏，将自己卖给那外人，或是寄居的，或是外人的宗族， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","卖了以后，可以将他赎回。无论是他的弟兄， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","或伯叔、伯叔的儿子，本家的近支，都可以赎他。他自己若渐渐富足，也可以自赎。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","他要和买主计算，从卖自己的那年起，算到禧年；所卖的价值照着年数多少，好像工人每年的工价。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","若缺少的年数多，就要按着年数从买价中偿还他的赎价。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","若到禧年只缺少几年，就要按着年数和买主计算，偿还他的赎价。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","他和买主同住，要像每年雇的工人，买主不可严严地辖管他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","他若不这样被赎，到了禧年，要和他的儿女一同出去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","因为以色列人都是我的仆人，是我从埃及地领出来的。我是耶和华—你们的　神。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","「你们不可做什么虚无的神像，不可立雕刻的偶像或是柱像，也不可在你们的地上安什么錾成的石像，向它跪拜，因为我是耶和华—你们的　神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","你们要守我的安息日，敬我的圣所。我是耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","「你们若遵行我的律例，谨守我的诫命， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","我就给你们降下时雨，叫地生出土产，田野的树木结果子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","你们打粮食要打到摘葡萄的时候，摘葡萄要摘到撒种的时候；并且要吃得饱足，在你们的地上安然居住。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","我要赐平安在你们的地上；你们躺卧，无人惊吓。我要叫恶兽从你们的地上息灭；刀剑也必不经过你们的地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","你们要追赶仇敌，他们必倒在你们刀下。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","你们五个人要追赶一百人，一百人要追赶一万人；仇敌必倒在你们刀下。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","我要眷顾你们，使你们生养众多，也要与你们坚定所立的约。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","你们要吃陈粮，又因新粮挪开陈粮。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","我要在你们中间立我的帐幕；我的心也不厌恶你们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","我要在你们中间行走；我要作你们的　神，你们要作我的子民。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","我是耶和华—你们的　神，曾将你们从埃及地领出来，使你们不作埃及人的奴仆；我也折断你们所负的轭，叫你们挺身而走。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","「你们若不听从我，不遵行我的诫命， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","厌弃我的律例，厌恶我的典章，不遵行我一切的诫命，背弃我的约， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","我待你们就要这样：我必命定惊惶，叫眼目干瘪、精神消耗的痨病热病辖制你们。你们也要白白地撒种，因为仇敌要吃你们所种的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","我要向你们变脸，你们就要败在仇敌面前。恨恶你们的，必辖管你们；无人追赶，你们却要逃跑。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","你们因这些事若还不听从我，我就要为你们的罪加七倍惩罚你们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","我必断绝你们因势力而有的骄傲，又要使覆你们的天如铁，载你们的地如铜。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","你们要白白地劳力；因为你们的地不出土产，其上的树木也不结果子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","「你们行事若与我反对，不肯听从我，我就要按你们的罪加七倍降灾与你们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","我也要打发野地的走兽到你们中间，抢吃你们的儿女，吞灭你们的牲畜，使你们的人数减少，道路荒凉。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","「你们因这些事若仍不改正归我，行事与我反对， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","我就要行事与你们反对，因你们的罪击打你们七次。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","我又要使刀剑临到你们，报复你们背约的仇；聚集你们在各城内，降瘟疫在你们中间，也必将你们交在仇敌的手中。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","我要折断你们的杖，就是断绝你们的粮。那时，必有十个女人在一个炉子给你们烤饼，按分量秤给你们；你们要吃，也吃不饱。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","「你们因这一切的事若不听从我，却行事与我反对， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","我就要发烈怒，行事与你们反对，又因你们的罪惩罚你们七次。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","并且你们要吃儿子的肉，也要吃女儿的肉。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","我又要毁坏你们的邱坛，砍下你们的日像，把你们的尸首扔在你们偶像的身上；我的心也必厌恶你们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","我要使你们的城邑变为荒凉，使你们的众圣所成为荒场；我也不闻你们馨香的香气。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","我要使地成为荒场，住在其上的仇敌就因此诧异。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","我要把你们散在列邦中；我也要拔刀追赶你们。你们的地要成为荒场；你们的城邑要变为荒凉。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","「你们在仇敌之地居住的时候，你们的地荒凉，要享受众安息；正在那时候，地要歇息，享受安息。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","地多时为荒场，就要多时歇息；地这样歇息，是你们住在其上的安息年所不能得的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","至于你们剩下的人，我要使他们在仇敌之地心惊胆怯。叶子被风吹的响声，要追赶他们；他们要逃避，像人逃避刀剑，无人追赶，却要跌倒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","无人追赶，他们要彼此撞跌，像在刀剑之前。你们在仇敌面前也必站立不住。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","你们要在列邦中灭亡；仇敌之地要吞吃你们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","你们剩下的人必因自己的罪孽和祖宗的罪孽在仇敌之地消灭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","「他们要承认自己的罪和他们祖宗的罪，就是干犯我的那罪，并且承认自己行事与我反对， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","我所以行事与他们反对，把他们带到仇敌之地。那时，他们未受割礼的心若谦卑了，他们也服了罪孽的刑罚， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","我就要记念我与雅各所立的约，与以撒所立的约，与亚伯拉罕所立的约，并要记念这地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","他们离开这地，地在荒废无人的时候就要享受安息。并且他们要服罪孽的刑罚；因为他们厌弃了我的典章，心中厌恶了我的律例。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","虽是这样，他们在仇敌之地，我却不厌弃他们，也不厌恶他们，将他们尽行灭绝，也不背弃我与他们所立的约，因为我是耶和华—他们的　神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","我却要为他们的缘故记念我与他们先祖所立的约。他们的先祖是我在列邦人眼前、从埃及地领出来的，为要作他们的　神。我是耶和华。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","这些律例、典章，和法度是耶和华与以色列人在西奈山借着摩西立的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","耶和华对摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","「你晓谕以色列人说：人还特许的愿，被许的人要按你所估的价值归给耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","你估定的，从二十岁到六十岁的男人，要按圣所的平，估定价银五十舍客勒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","若是女人，你要估定三十舍客勒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","若是从五岁到二十岁，男子你要估定二十舍客勒，女子估定十舍客勒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","若是从一月到五岁，男子你要估定五舍客勒，女子估定三舍客勒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","若是从六十岁以上，男人你要估定十五舍客勒，女人估定十舍客勒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","他若贫穷，不能照你所估定的价，就要把他带到祭司面前，祭司要按许愿人的力量估定他的价。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","「所许的若是牲畜，就是人献给耶和华为供物的，凡这一类献给耶和华的，都要成为圣。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","人不可改换，也不可更换，或是好的换坏的，或是坏的换好的。若以牲畜更换牲畜，所许的与所换的都要成为圣。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","若牲畜不洁净，是不可献给耶和华为供物的，就要把牲畜安置在祭司面前。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","祭司就要估定价值；牲畜是好是坏，祭司怎样估定，就要以怎样为是。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","他若一定要赎回，就要在你所估定的价值以外加上五分之一。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","「人将房屋分别为圣，归给耶和华，祭司就要估定价值。房屋是好是坏，祭司怎样估定，就要以怎样为定。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","将房屋分别为圣的人，若要赎回房屋，就必在你所估定的价值以外加上五分之一，房屋仍旧归他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","「人若将承受为业的几分地分别为圣，归给耶和华，你要按这地撒种多少估定价值，若撒大麦一贺梅珥，要估价五十舍客勒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","他若从禧年将地分别为圣，就要以你所估定的价为定。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","倘若他在禧年以后将地分别为圣，祭司就要按着未到禧年所剩的年数推算价值，也要从你所估的减去价值。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","将地分别为圣的人若定要把地赎回，他便要在你所估的价值以外加上五分之一，地就准定归他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","他若不赎回那地，或是将地卖给别人，就再不能赎了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","但到了禧年，那地从买主手下出来的时候，就要归耶和华为圣，和永献的地一样，要归祭司为业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","他若将所买的一块地，不是承受为业的，分别为圣归给耶和华， ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","祭司就要将你所估的价值给他推算到禧年。当日，他要以你所估的价银为圣，归给耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","到了禧年，那地要归卖主，就是那承受为业的原主。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","凡你所估定的价银都要按着圣所的平：二十季拉为一舍客勒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","「惟独牲畜中头生的，无论是牛是羊，既归耶和华，谁也不可再分别为圣，因为这是耶和华的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","若是不洁净的牲畜生的，就要按你所估定的价值加上五分之一赎回；若不赎回，就要按你所估定的价值卖了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","「但一切永献的，就是人从他所有永献给耶和华的，无论是人，是牲畜，是他承受为业的地，都不可卖，也不可赎。凡永献的是归给耶和华为至圣。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","凡从人中当灭的都不可赎，必被治死。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","「地上所有的，无论是地上的种子是树上的果子，十分之一是耶和华的，是归给耶和华为圣的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","人若要赎这十分之一的什么物，就要加上五分之一。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","凡牛群羊群中，一切从杖下经过的，每第十只要归给耶和华为圣。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","不可问是好是坏，也不可更换；若定要更换，所更换的与本来的牲畜都要成为圣，不可赎回。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","这就是耶和华在西奈山为以色列人所吩咐摩西的命令。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","以色列人出埃及地后，第二年二月初一日，耶和华在西奈的旷野、会幕中晓谕摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","「你要按以色列全会众的家室、宗族、人名的数目计算所有的男丁。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","凡以色列中，从二十岁以外，能出去打仗的，你和亚伦要照他们的军队数点。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","每支派中必有一人作本支派的族长，帮助你们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","他们的名字：属吕便的，有示丢珥的儿子以利蓿； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","属西缅的，有苏利沙代的儿子示路蔑； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","属犹大的，有亚米拿达的儿子拿顺； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","属以萨迦的，有苏押的儿子拿坦业； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","属西布伦的，有希伦的儿子以利押； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","约瑟子孙、属以法莲的，有亚米忽的儿子以利沙玛；属玛拿西的，有比大蓿的儿子迦玛列； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","属便雅悯的，有基多尼的儿子亚比但； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","属但的，有亚米沙代的儿子亚希以谢； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","属亚设的，有俄兰的儿子帕结； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","属迦得的，有丢珥的儿子以利雅萨； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","属拿弗他利的，有以南的儿子亚希拉。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","这都是从会中选召的，各作本支派的首领，都是以色列军中的统领。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","于是，摩西、亚伦带着这些按名指定的人， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","当二月初一日招聚全会众。会众就照他们的家室、宗族、人名的数目，从二十岁以外的，都述说自己的家谱。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","耶和华怎样吩咐摩西，他就怎样在西奈的旷野数点他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","21","以色列的长子，吕便子孙的后代，照着家室、宗族、人名的数目，从二十岁以外，凡能出去打仗、被数的男丁，共有四万六千五百名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","23","西缅子孙的后代，照着家室、宗族、人名的数目，从二十岁以外，凡能出去打仗、被数的男丁，共有五万九千三百名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","25","迦得子孙的后代，照着家室、宗族、人名的数目，从二十岁以外，凡能出去打仗、被数的，共有四万五千六百五十名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","27","犹大子孙的后代，照着家室、宗族、人名的数目，从二十岁以外，凡能出去打仗、被数的，共有七万四千六百名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","29","以萨迦子孙的后代，照着家室、宗族、人名的数目，从二十岁以外，凡能出去打仗、被数的，共有五万四千四百名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","31","西布伦子孙的后代，照着家室、宗族、人名的数目，从二十岁以外，凡能出去打仗、被数的，共有五万七千四百名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","33","约瑟子孙属以法莲子孙的后代，照着家室、宗族、人名的数目，从二十岁以外，凡能出去打仗、被数的，共有四万零五百名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","35","玛拿西子孙的后代，照着家室、宗族、人名的数目，从二十岁以外，凡能出去打仗、被数的，共有三万二千二百名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","37","便雅悯子孙的后代，照着家室、宗族、人名的数目，从二十岁以外，凡能出去打仗、被数的，共有三万五千四百名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","39","但子孙的后代，照着家室、宗族、人名的数目，从二十岁以外，凡能出去打仗、被数的，共有六万二千七百名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","41","亚设子孙的后代，照着家室、宗族、人名的数目，从二十岁以外，凡能出去打仗、被数的，共有四万一千五百名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","43","拿弗他利子孙的后代，照着家室、宗族、人名的数目，从二十岁以外，凡能出去打仗、被数的，共有五万三千四百名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","这些就是被数点的，是摩西、亚伦，和以色列中十二个首领所数点的；这十二个人各作各宗族的代表。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","46","这样，凡以色列人中被数的，照着宗族，从二十岁以外，能出去打仗、被数的，共有六十万零三千五百五十名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","利未人却没有按着支派数在其中， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","因为耶和华晓谕摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","「惟独利未支派你不可数点，也不可在以色列人中计算他们的总数。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","只要派利未人管法柜的帐幕和其中的器具，并属乎帐幕的；他们要抬帐幕和其中的器具，并要办理帐幕的事，在帐幕的四围安营。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","帐幕将往前行的时候，利未人要拆卸；将支搭的时候，利未人要竖起。近前来的外人必被治死。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","以色列人支搭帐棚，要照他们的军队，各归本营，各归本纛。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","但利未人要在法柜帐幕的四围安营，免得忿怒临到以色列会众；利未人并要谨守法柜的帐幕。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","以色列人就这样行。凡耶和华所吩咐摩西的，他们就照样行了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","耶和华晓谕摩西、亚伦说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","「以色列人要各归自己的纛下，在本族的旗号那里，对着会幕的四围安营。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","在东边，向日出之地，照着军队安营的是犹大营的纛。有亚米拿达的儿子拿顺作犹大人的首领。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","他军队被数的，共有七万四千六百名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","挨着他安营的是以萨迦支派。有苏押的儿子拿坦业作以萨迦人的首领。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","他军队被数的，共有五万四千四百名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","又有西布伦支派。希伦的儿子以利押作西布伦人的首领。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","他军队被数的，共有五万七千四百名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","凡属犹大营、按着军队被数的，共有十八万六千四百名，要作第一队往前行。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","「在南边，按着军队是吕便营的纛。有示丢珥的儿子以利蓿作吕便人的首领。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","他军队被数的，共有四万六千五百名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","挨着他安营的是西缅支派。苏利沙代的儿子示路蔑作西缅人的首领。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","他军队被数的，共有五万九千三百名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","又有迦得支派。丢珥的儿子以利雅萨作迦得人的首领。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","他军队被数的，共有四万五千六百五十名， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","凡属吕便营、按着军队被数的，共有十五万一千四百五十名，要作第二队往前行。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","「随后，会幕要往前行，有利未营在诸营中间。他们怎样安营就怎样往前行，各按本位，各归本纛。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","「在西边，按着军队是以法莲营的纛。亚米忽的儿子以利沙玛作以法莲人的首领。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","他军队被数的，共有四万零五百名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","挨着他的是玛拿西支派。比大蓿的儿子迦玛列作玛拿西人的首领。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","他军队被数的，共有三万二千二百名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","又有便雅悯支派。基多尼的儿子亚比但作便雅悯人的首领。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","他军队被数的，共有三万五千四百名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","凡属以法莲营、按着军队被数的，共有十万零八千一百名，要作第三队往前行。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","「在北边，按着军队是但营的纛。亚米沙代的儿子亚希以谢作但人的首领。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","他军队被数的，共有六万二千七百名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","挨着他安营的是亚设支派。俄兰的儿子帕结作亚设人的首领。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","他军队被数的，共有四万一千五百名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","又有拿弗他利支派。以南的儿子亚希拉作拿弗他利人的首领。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","他军队被数的，共有五万三千四百名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","凡但营被数的，共有十五万七千六百名，要归本纛作末队往前行。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","这些以色列人，照他们的宗族，按他们的军队，在诸营中被数的，共有六十万零三千五百五十名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","惟独利未人没有数在以色列人中，是照耶和华所吩咐摩西的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","以色列人就这样行，各人照他们的家室、宗族归于本纛，安营起行，都是照耶和华所吩咐摩西的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","耶和华在西奈山晓谕摩西的日子，亚伦和摩西的后代如下： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","亚伦的儿子，长子名叫拿答，还有亚比户、以利亚撒、以他玛。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","这是亚伦儿子的名字，都是受膏的祭司，是摩西叫他们承接圣职供祭司职分的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","拿答、亚比户在西奈的旷野向耶和华献凡火的时候就死在耶和华面前了。他们也没有儿子。以利亚撒、以他玛在他们的父亲亚伦面前供祭司的职分。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","耶和华晓谕摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","「你使利未支派近前来，站在祭司亚伦面前好服事他， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","替他和会众在会幕前守所吩咐的，办理帐幕的事。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","又要看守会幕的器具，并守所吩咐以色列人的，办理帐幕的事。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","你要将利未人给亚伦和他的儿子，因为他们是从以色列人中选出来给他的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","你要嘱咐亚伦和他的儿子谨守自己祭司的职任。近前来的外人必被治死。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","耶和华晓谕摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","「我从以色列人中拣选了利未人，代替以色列人一切头生的；利未人要归我。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","因为凡头生的是我的；我在埃及地击杀一切头生的那日就把以色列中一切头生的，连人带牲畜都分别为圣归我；他们定要属我。我是耶和华。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","耶和华在西奈的旷野晓谕摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","「你要照利未人的宗族、家室数点他们。凡一个月以外的男子都要数点。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","于是摩西照耶和华所吩咐的数点他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","利未众子的名字是革顺、哥辖、米拉利。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","革顺的儿子，按着家室，是立尼、示每。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","哥辖的儿子，按着家室，是暗兰、以斯哈、希伯伦、乌薛。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","米拉利的儿子，按着家室，是抹利、母示。这些按着宗族是利未人的家室。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","属革顺的，有立尼族、示每族。这是革顺的二族。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","其中被数、从一个月以外所有的男子共有七千五百名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","这革顺的二族要在帐幕后西边安营。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","拉伊勒的儿子以利雅萨作革顺人宗族的首领。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","革顺的子孙在会幕中所要看守的，就是帐幕和罩棚，并罩棚的盖与会幕的门帘， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","院子的帷子和门帘（院子是围帐幕和坛的），并一切使用的绳子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","属哥辖的，有暗兰族、以斯哈族、希伯伦族、乌薛族。这是哥辖的诸族。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","按所有男子的数目，从一个月以外看守圣所的，共有八千六百名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","哥辖儿子的诸族要在帐幕的南边安营。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","乌薛的儿子以利撒反作哥辖宗族家室的首领。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","他们所要看守的是约柜、桌子、灯台、两座坛与圣所内使用的器皿，并帘子和一切使用之物。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","祭司亚伦的儿子以利亚撒作利未人众首领的领袖，要监察那些看守圣所的人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","属米拉利的，有抹利族、母示族。这是米拉利的二族。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","他们被数的，按所有男子的数目，从一个月以外的，共有六千二百名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","亚比亥的儿子苏列作米拉利二宗族的首领。他们要在帐幕的北边安营。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","米拉利子孙的职分是看守帐幕的板、闩、柱子、带卯的座，和帐幕一切所使用的器具， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","院子四围的柱子、带卯的座、橛子，和绳子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","在帐幕前东边，向日出之地安营的是摩西、亚伦，和亚伦的儿子。他们看守圣所，替以色列人守耶和华所吩咐的。近前来的外人必被治死。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","凡被数的利未人，就是摩西、亚伦照耶和华吩咐所数的，按着家室，从一个月以外的男子，共有二万二千名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","耶和华对摩西说：「你要从以色列人中数点一个月以外、凡头生的男子，把他们的名字记下。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","我是耶和华。你要拣选利未人归我，代替以色列人所有头生的，也取利未人的牲畜代替以色列所有头生的牲畜。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","摩西就照耶和华所吩咐的把以色列人头生的都数点了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","按人名的数目，从一个月以外、凡头生的男子，共有二万二千二百七十三名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","耶和华晓谕摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","「你拣选利未人代替以色列人所有头生的，也取利未人的牲畜代替以色列人的牲畜。利未人要归我；我是耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","以色列人中头生的男子比利未人多二百七十三个，必当将他们赎出来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","你要按人丁，照圣所的平，每人取赎银五舍客勒（一舍客勒是二十季拉）， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","把那多余之人的赎银交给亚伦和他的儿子。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","于是摩西从那被利未人所赎以外的人取了赎银。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","从以色列人头生的所取之银，按圣所的平，有一千三百六十五舍客勒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","摩西照耶和华的话把这赎银给亚伦和他的儿子，正如耶和华所吩咐的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","耶和华晓谕摩西、亚伦说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","「你从利未人中，将哥辖子孙的总数，照他们的家室、宗族， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","从三十岁直到五十岁，凡前来任职、在会幕里办事的，全都计算。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","哥辖子孙在会幕搬运至圣之物，所办的事乃是这样： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","起营的时候，亚伦和他儿子要进去摘下遮掩柜的幔子，用以蒙盖法柜， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","又用海狗皮盖在上头，再蒙上纯蓝色的毯子，把杠穿上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","又用蓝色毯子铺在陈设饼的桌子上，将盘子、调羹、奠酒的爵，和杯摆在上头。桌子上也必有常设的饼。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","在其上又要蒙朱红色的毯子，再蒙上海狗皮，把杠穿上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","要拿蓝色毯子，把灯台和灯台上所用的灯盏、剪子、蜡花盘，并一切盛油的器皿，全都遮盖。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","又要把灯台和灯台的一切器具包在海狗皮里，放在抬架上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","在金坛上要铺蓝色毯子，蒙上海狗皮，把杠穿上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","又要把圣所用的一切器具包在蓝色毯子里，用海狗皮蒙上，放在抬架上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","要收去坛上的灰，把紫色毯子铺在坛上； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","又要把所用的一切器具，就是火鼎、肉锸子、铲子、盘子，一切属坛的器具都摆在坛上，又蒙上海狗皮，把杠穿上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","将要起营的时候，亚伦和他儿子把圣所和圣所的一切器具遮盖完了，哥辖的子孙就要来抬，只是不可摸圣物，免得他们死亡。会幕里这些物件是哥辖子孙所当抬的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","「祭司亚伦的儿子以利亚撒所要看守的是点灯的油与香料，并当献的素祭和膏油，也要看守全帐幕与其中所有的，并圣所和圣所的器具。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","耶和华晓谕摩西、亚伦说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","「你们不可将哥辖人的支派从利未人中剪除。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","他们挨近至圣物的时候，亚伦和他儿子要进去派他们各人所当办的，所当抬的。这样待他们，好使他们活着，不致死亡。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","只是他们连片时不可进去观看圣所，免得他们死亡。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","耶和华晓谕摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","「你要将革顺子孙的总数，照着宗族、家室， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","从三十岁直到五十岁，凡前来任职、在会幕里办事的，全都数点。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","革顺人各族所办的事、所抬的物乃是这样： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","他们要抬帐幕的幔子和会幕，并会幕的盖与其上的海狗皮，和会幕的门帘， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","院子的帷子和门帘（院子是围帐幕和坛的）、绳子，并所用的器具，不论是做什么用的，他们都要经理。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","革顺的子孙在一切抬物办事之上都要凭亚伦和他儿子的吩咐；他们所当抬的，要派他们看守。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","这是革顺子孙的各族在会幕里所办的事；他们所看守的，必在祭司亚伦儿子以他玛的手下。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","「至于米拉利的子孙，你要照着家室、宗族把他们数点。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","从三十岁直到五十岁，凡前来任职、在会幕里办事的，你都要数点。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","他们办理会幕的事，就是抬帐幕的板、闩、柱子，和带卯的座， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","院子四围的柱子和其上带卯的座、橛子、绳子，并一切使用的器具。他们所抬的器具，你们要按名指定。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","这是米拉利子孙各族在会幕里所办的事，都在祭司亚伦儿子以他玛的手下。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","摩西、亚伦与会众的诸首领将哥辖的子孙，照着家室、宗族， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","从三十岁直到五十岁，凡前来任职、在会幕里办事的，都数点了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","被数的共有二千七百五十名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","这是哥辖各族中被数的，是在会幕里办事的，就是摩西、亚伦照耶和华借摩西所吩咐数点的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","革顺子孙被数的，照着家室、宗族， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","40","从三十岁直到五十岁，凡前来任职、在会幕里办事的，共有二千六百三十名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","这是革顺子孙各族中被数的，是在会幕里办事的，就是摩西、亚伦照耶和华借摩西所吩咐数点的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","米拉利子孙中各族被数的，照着家室、宗族， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","44","从三十岁直到五十岁，凡前来任职、在会幕里办事的，共有三千二百名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","这是米拉利子孙各族中被数的，就是摩西、亚伦照耶和华借摩西所吩咐数点的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","凡被数的利未人，就是摩西、亚伦并以色列众首领，照着家室、宗族所数点的， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","48","从三十岁直到五十岁，凡前来任职、在会幕里做抬物之工的，共有八千五百八十名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","摩西按他们所办的事、所抬的物，凭耶和华的吩咐数点他们；他们这样被摩西数点，正如耶和华所吩咐他的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","耶和华晓谕摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","「你吩咐以色列人，使一切长大麻风的，患漏症的，并因死尸不洁净的，都出营外去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","无论男女都要使他们出到营外，免得污秽他们的营；这营是我所住的。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","以色列人就这样行，使他们出到营外。耶和华怎样吩咐摩西，以色列人就怎样行了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","耶和华对摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","「你晓谕以色列人说：无论男女，若犯了人所常犯的罪，以致干犯耶和华，那人就有了罪。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","他要承认所犯的罪，将所亏负人的，如数赔还，另外加上五分之一，也归与所亏负的人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","那人若没有亲属可受所赔还的，那所赔还的就要归与服事耶和华的祭司；至于那为他赎罪的公羊是在外。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","以色列人一切的圣物中，所奉给祭司的举祭都要归与祭司。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","各人所分别为圣的物，无论是什么，都要归给祭司。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","耶和华对摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","「你晓谕以色列人说：人的妻若有邪行，得罪她丈夫， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","有人与她行淫，事情严密，瞒过她丈夫，而且她被玷污，没有作见证的人，当她行淫的时候也没有被捉住， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","她丈夫生了疑恨的心，疑恨她，她是被玷污，或是她丈夫生了疑恨的心，疑恨她，她并没有被玷污， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","这人就要将妻送到祭司那里，又为她带着大麦面伊法十分之一作供物，不可浇上油，也不可加上乳香；因为这是疑恨的素祭，是思念的素祭，使人思念罪孽。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","「祭司要使那妇人近前来，站在耶和华面前。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","祭司要把圣水盛在瓦器里，又从帐幕的地上取点尘土，放在水中。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","祭司要叫那妇人蓬头散发，站在耶和华面前，把思念的素祭，就是疑恨的素祭，放在她手中。祭司手里拿着致咒诅的苦水， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","要叫妇人起誓，对她说：『若没有人与你行淫，也未曾背着丈夫做污秽的事，你就免受这致咒诅苦水的灾。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","你若背着丈夫行了污秽的事，在你丈夫以外有人与你行淫， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","（祭司叫妇人发咒起誓，）愿耶和华叫你大腿消瘦，肚腹发胀，使你在你民中被人咒诅，成了誓语； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","并且这致咒诅的水入你的肠中，要叫你的肚腹发胀，大腿消瘦。』妇人要回答说：『阿们，阿们。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","「祭司要写这咒诅的话，将所写的字抹在苦水里， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","又叫妇人喝这致咒诅的苦水；这水要进入她里面变苦了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","祭司要从妇人的手中取那疑恨的素祭，在耶和华面前摇一摇，拿到坛前； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","又要从素祭中取出一把，作为这事的纪念，烧在坛上，然后叫妇人喝这水。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","叫她喝了以后，她若被玷污，得罪了丈夫，这致咒诅的水必进入她里面变苦了，她的肚腹就要发胀，大腿就要消瘦，那妇人便要在他民中被人咒诅。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","若妇人没有被玷污，却是清洁的，就要免受这灾，且要怀孕。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","「妻子背着丈夫行了污秽的事， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","或是人生了疑恨的心，疑恨他的妻，就有这疑恨的条例。那时他要叫妇人站在耶和华面前，祭司要在她身上照这条例而行。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","男人就为无罪，妇人必担当自己的罪孽。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","耶和华对摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","「你晓谕以色列人说：无论男女许了特别的愿，就是拿细耳人的愿，要离俗归耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","他就要远离清酒浓酒，也不可喝什么清酒浓酒做的醋；不可喝什么葡萄汁，也不可吃鲜葡萄和干葡萄。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","在一切离俗的日子，凡葡萄树上结的，自核至皮所做的物，都不可吃。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","「在他一切许愿离俗的日子，不可用剃头刀剃头，要由发绺长长了。他要圣洁，直到离俗归耶和华的日子满了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","在他离俗归耶和华的一切日子，不可挨近死尸。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","他的父母或是弟兄姊妹死了的时候，他不可因他们使自己不洁净，因为那离俗归　神的凭据是在他头上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","在他一切离俗的日子是归耶和华为圣。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","「若在他旁边忽然有人死了，以致沾染了他离俗的头，他要在第七日，得洁净的时候，剃头。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","第八日，他要把两只斑鸠或两只雏鸽带到会幕门口，交给祭司。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","祭司要献一只作赎罪祭，一只作燔祭，为他赎那因死尸而有的罪，并要当日使他的头成为圣洁。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","他要另选离俗归耶和华的日子，又要牵一只一岁的公羊羔来作赎愆祭；但先前的日子要归徒然，因为他在离俗之间被玷污了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","「拿细耳人满了离俗的日子乃有这条例：人要领他到会幕门口， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","他要将供物奉给耶和华，就是一只没有残疾、一岁的公羊羔作燔祭，一只没有残疾、一岁的母羊羔作赎罪祭，和一只没有残疾的公绵羊作平安祭， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","并一筐子无酵调油的细面饼，与抹油的无酵薄饼，并同献的素祭和奠祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","祭司要在耶和华面前献那人的赎罪祭和燔祭； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","也要把那只公羊和那筐无酵饼献给耶和华作平安祭，又要将同献的素祭和奠祭献上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","拿细耳人要在会幕门口剃离俗的头，把离俗头上的发放在平安祭下的火上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","他剃了以后，祭司就要取那已煮的公羊一条前腿，又从筐子里取一个无酵饼和一个无酵薄饼，都放在他手上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","祭司要拿这些作为摇祭，在耶和华面前摇一摇；这与所摇的胸、所举的腿同为圣物，归给祭司。然后拿细耳人可以喝酒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","「许愿的拿细耳人为离俗所献的供物，和他以外所能得的献给耶和华，就有这条例。他怎样许愿就当照离俗的条例行。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","耶和华晓谕摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","「你告诉亚伦和他儿子说：你们要这样为以色列人祝福，说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","『愿耶和华赐福给你，保护你。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","愿耶和华使他的脸光照你，赐恩给你。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","愿耶和华向你仰脸，赐你平安。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","他们要如此奉我的名为以色列人祝福；我也要赐福给他们。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","摩西立完了帐幕，就把帐幕用膏抹了，使它成圣，又把其中的器具和坛，并坛上的器具，都抹了，使它成圣。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","当天，以色列的众首领，就是各族的族长，都来奉献。他们是各支派的首领，管理那些被数的人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","他们把自己的供物送到耶和华面前，就是六辆篷子车和十二只公牛。每两个首领奉献一辆车，每首领奉献一只牛。他们把这些都奉到帐幕前。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","耶和华晓谕摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","「你要收下这些，好作会幕的使用，都要照利未人所办的事交给他们。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","于是摩西收了车和牛，交给利未人， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","把两辆车，四只牛，照革顺子孙所办的事交给他们， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","又把四辆车，八只牛，照米拉利子孙所办的事交给他们；他们都在祭司亚伦的儿子以他玛手下。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","但车与牛都没有交给哥辖子孙；因为他们办的是圣所的事，在肩头上抬圣物。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","用膏抹坛的日子，首领都来行奉献坛的礼，众首领就在坛前献供物。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","耶和华对摩西说：「众首领为行奉献坛的礼，要每天一个首领来献供物。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","头一日献供物的是犹大支派的亚米拿达的儿子拿顺。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","他的供物是：一个银盘子，重一百三十舍客勒，一个银碗，重七十舍客勒，都是按圣所的平，也都盛满了调油的细面作素祭； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","一个金盂，重十舍客勒，盛满了香； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","一只公牛犊，一只公绵羊，一只一岁的公羊羔作燔祭； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","一只公山羊作赎罪祭； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","两只公牛，五只公绵羊，五只公山羊，五只一岁的公羊羔作平安祭。这是亚米拿达儿子拿顺的供物。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","第二日来献的是以萨迦子孙的首领、苏押的儿子拿坦业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","他献为供物的是：一个银盘子，重一百三十舍客勒，一个银碗，重七十舍客勒，都是按圣所的平，也都盛满了调油的细面作素祭； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","一个金盂，重十舍客勒，盛满了香； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","一只公牛犊，一只公绵羊，一只一岁的公羊羔作燔祭； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","一只公山羊作赎罪祭； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","两只公牛，五只公绵羊，五只公山羊，五只一岁的公羊羔作平安祭。这是苏押儿子拿坦业的供物。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","第三日来献的是西布伦子孙的首领、希伦的儿子以利押。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","他的供物是：一个银盘子，重一百三十舍客勒，一个银碗，重七十舍客勒，都是按圣所的平，也都盛满了调油的细面作素祭； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","一个金盂，重十舍客勒，盛满了香； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","一只公牛犊，一只公绵羊，一只一岁的公羊羔作燔祭； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","一只公山羊作赎罪祭； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","两只公牛，五只公绵羊，五只公山羊，五只一岁的公羊羔作平安祭。这是希伦儿子以利押的供物。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","第四日来献的是吕便子孙的首领、示丢珥的儿子以利蓿。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","他的供物是：一个银盘子，重一百三十舍客勒，一个银碗，重七十舍客勒，都是按圣所的平，也都盛满了调油的细面作素祭； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","一个金盂，重十舍客勒，盛满了香； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","一只公牛犊，一只公绵羊，一只一岁的公羊羔作燔祭； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","一只公山羊作赎罪祭； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","两只公牛，五只公绵羊，五只公山羊，五只一岁的公羊羔作平安祭。这是示丢珥的儿子以利蓿的供物。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","第五日来献的是西缅子孙的首领、苏利沙代的儿子示路蔑。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","他的供物是：一个银盘子，重一百三十舍客勒，一个银碗，重七十舍客勒，都是按圣所的平，也都盛满了调油的细面作素祭； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","一个金盂，重十舍客勒，盛满了香； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","一只公牛犊，一只公绵羊，一只一岁的公羊羔作燔祭； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","一只公山羊作赎罪祭； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","两只公牛，五只公绵羊，五只公山羊，五只一岁的公羊羔作平安祭。这是苏利沙代儿子示路蔑的供物。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","第六日来献的是迦得子孙的首领、丢珥的儿子以利雅萨。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","他的供物是：一个银盘子，重一百三十舍客勒，一个银碗，重七十舍客勒，都是按圣所的平，也都盛满了调油的细面作素祭； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","一个金盂，重十舍客勒，盛满了香； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","一只公牛犊，一只公绵羊，一只一岁的公羊羔作燔祭； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","一只公山羊作赎罪祭； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","两只公牛，五只公绵羊，五只公山羊，五只一岁的公羊羔作平安祭。这是丢珥的儿子以利雅萨的供物。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","第七日来献的是以法莲子孙的首领、亚米忽的儿子以利沙玛。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","他的供物是：一个银盘子，重一百三十舍客勒，一个银碗，重七十舍客勒，都是按圣所的平，也都盛满了调油的细面作素祭； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","一个金盂，重十舍客勒，盛满了香； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","一只公牛犊，一只公绵羊，一只一岁的公羊羔作燔祭； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","一只公山羊作赎罪祭； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","两只公牛，五只公绵羊，五只公山羊，五只一岁的公羊羔作平安祭。这是亚米忽儿子以利沙玛的供物。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","第八日来献的是玛拿西子孙的首领、比大蓿的儿子迦玛列。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","他的供物是：一个银盘子，重一百三十舍客勒，一个银碗，重七十舍客勒，都是按圣所的平，也都盛满了调油的细面作素祭； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","一个金盂，重十舍客勒，盛满了香； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","一只公牛犊，一只公绵羊，一只一岁的公羊羔作燔祭； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","一只公山羊作赎罪祭； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","两只公牛，五只公绵羊，五只公山羊，五只一岁的公羊羔作平安祭。这是比大蓿儿子迦玛列的供物。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","第九日来献的是便雅悯子孙的首领、基多尼的儿子亚比但。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","他的供物是：一个银盘子，重一百三十舍客勒，一个银碗，重七十舍客勒，都是按圣所的平，也都盛满了调油的细面作素祭； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","一个金盂，重十舍客勒，盛满了香； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","一只公牛犊，一只公绵羊，一只一岁的公羊羔作燔祭； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","一只公山羊作赎罪祭； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","两只公牛，五只公绵羊，五只公山羊，五只一岁的公羊羔作平安祭。这是基多尼儿子亚比但的供物。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","第十日来献的是但子孙的首领、亚米沙代的儿子亚希以谢。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","他的供物是：一个银盘子，重一百三十舍客勒，一个银碗，重七十舍客勒，都是按圣所的平，也都盛满了调油的细面作素祭； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","一个金盂，重十舍客勒，盛满了香； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","一只公牛犊，一只公绵羊，一只一岁的公羊羔作燔祭； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","一只公山羊作赎罪祭； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","两只公牛，五只公绵羊，五只公山羊，五只一岁的公羊羔作平安祭。这是亚米沙代儿子亚希以谢的供物。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","第十一日来献的是亚设子孙的首领、俄兰的儿子帕结。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","他的供物是：一个银盘子，重一百三十舍客勒，一个银碗，重七十舍客勒，都是按圣所的平，也都盛满了调油的细面作素祭； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","一个金盂，重十舍客勒，盛满了香； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","一只公牛犊，一只公绵羊，一只一岁的公羊羔作燔祭； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","一只公山羊作赎罪祭； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","两只公牛，五只公绵羊，五只公山羊，五只一岁的公羊羔作平安祭。这是俄兰儿子帕结的供物。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","第十二日来献的是拿弗他利子孙的首领、以南儿子亚希拉。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","他的供物是：一个银盘子，重一百三十舍客勒，一个银碗，重七十舍客勒，都是按圣所的平，也都盛满了调油的细面作素祭； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","一个金盂，重十舍客勒，盛满了香； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","一只公牛犊，一只公绵羊，一只一岁的公羊羔作燔祭； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","一只公山羊作赎罪祭； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","两只公牛，五只公绵羊，五只公山羊，五只一岁的公羊羔作平安祭。这是以南儿子亚希拉的供物。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","用膏抹坛的日子，以色列的众首领为行献坛之礼所献的是：银盘子十二个，银碗十二个，金盂十二个； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","每盘子重一百三十舍客勒，每碗重七十舍客勒。一切器皿的银子，按圣所的平，共有二千四百舍客勒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","十二个金盂盛满了香，按圣所的平，每盂重十舍客勒，所有的金子共一百二十舍客勒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","作燔祭的，共有公牛十二只，公羊十二只，一岁的公羊羔十二只，并同献的素祭作赎罪祭的公山羊十二只； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","作平安祭的，共有公牛二十四只，公绵羊六十只，公山羊六十只，一岁的公羊羔六十只。这就是用膏抹坛之后，为行奉献坛之礼所献的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","摩西进会幕要与耶和华说话的时候，听见法柜的施恩座以上、二基路伯中间有与他说话的声音，就是耶和华与他说话。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","耶和华晓谕摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","「你告诉亚伦说：点灯的时候，七盏灯都要向灯台前面发光。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","亚伦便这样行。他点灯台上的灯，使灯向前发光，是照耶和华所吩咐摩西的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","这灯台的做法是用金子锤出来的，连座带花都是锤出来的。摩西制造灯台，是照耶和华所指示的样式。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","耶和华晓谕摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","「你从以色列人中选出利未人来，洁净他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","洁净他们当这样行：用除罪水弹在他们身上，又叫他们用剃头刀刮全身，洗衣服，洁净自己。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","然后叫他们取一只公牛犊，并同献的素祭，就是调油的细面；你要另取一只公牛犊作赎罪祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","将利未人奉到会幕前，招聚以色列全会众。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","将利未人奉到耶和华面前，以色列人要按手在他们头上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","亚伦也将他们奉到耶和华面前，为以色列人当作摇祭，使他们好办耶和华的事。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","利未人要按手在那两只牛的头上；你要将一只作赎罪祭，一只作燔祭，献给耶和华，为利未人赎罪。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","你也要使利未人站在亚伦和他儿子面前，将他们当作摇祭奉给耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","「这样，你从以色列人中将利未人分别出来，利未人便要归我。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","此后利未人要进去办会幕的事，你要洁净他们，将他们当作摇祭奉上； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","因为他们是从以色列人中全然给我的，我拣选他们归我，是代替以色列人中一切头生的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","以色列人中一切头生的，连人带牲畜，都是我的。我在埃及地击杀一切头生的那天，将他们分别为圣归我。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","我拣选利未人代替以色列人中一切头生的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","我从以色列人中将利未人当作赏赐给亚伦和他的儿子，在会幕中办以色列人的事，又为以色列人赎罪，免得他们挨近圣所，有灾殃临到他们中间。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","摩西、亚伦，并以色列全会众便向利未人如此行。凡耶和华指着利未人所吩咐摩西的，以色列人就向他们这样行。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","于是利未人洁净自己，除了罪，洗了衣服；亚伦将他们当作摇祭奉到耶和华面前，又为他们赎罪，洁净他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","然后利未人进去，在亚伦和他儿子面前，在会幕中办事。耶和华指着利未人怎样吩咐摩西，以色列人就怎样向他们行了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","耶和华晓谕摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","「利未人是这样：从二十五岁以外，他们要前来任职，办会幕的事。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","到了五十岁要停工退任，不再办事， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","只要在会幕里，和他们的弟兄一同伺候，谨守所吩咐的，不再办事了。至于所吩咐利未人的，你要这样向他们行。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","以色列人出埃及地以后，第二年正月，耶和华在西奈的旷野吩咐摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","「以色列人应当在所定的日期守逾越节， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","就是本月十四日黄昏的时候，你们要在所定的日期守这节，要按这节的律例典章而守。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","于是摩西吩咐以色列人守逾越节。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","他们就在西奈的旷野，正月十四日黄昏的时候，守逾越节。凡耶和华所吩咐摩西的，以色列人都照样行了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","有几个人因死尸而不洁净，不能在那日守逾越节。当日他们到摩西、亚伦面前， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","说：「我们虽因死尸而不洁净，为何被阻止、不得同以色列人在所定的日期献耶和华的供物呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","摩西对他们说：「你们暂且等候，我可以去听耶和华指着你们是怎样吩咐的。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","耶和华对摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","「你晓谕以色列人说：你们和你们后代中，若有人因死尸而不洁净，或在远方行路，还要向耶和华守逾越节。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","他们要在二月十四日黄昏的时候，守逾越节。要用无酵饼与苦菜，和逾越节的羊羔同吃。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","一点不可留到早晨；羊羔的骨头一根也不可折断。他们要照逾越节的一切律例而守。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","那洁净而不行路的人若推辞不守逾越节，那人要从民中剪除；因为他在所定的日期不献耶和华的供物，应该担当他的罪。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","若有外人寄居在你们中间，愿意向耶和华守逾越节，他要照逾越节的律例典章行，不管是寄居的是本地人，同归一例。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","立起帐幕的那日，有云彩遮盖帐幕，就是法柜的帐幕；从晚上到早晨，云彩在其上，形状如火。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","常是这样，云彩遮盖帐幕，夜间形状如火。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","云彩几时从帐幕收上去，以色列人就几时起行；云彩在哪里停住，以色列人就在那里安营。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","以色列人遵耶和华的吩咐起行，也遵耶和华的吩咐安营。云彩在帐幕上停住几时，他们就住营几时。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","云彩在帐幕上停留许多日子，以色列人就守耶和华所吩咐的不起行。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","有时云彩在帐幕上几天，他们就照耶和华的吩咐住营，也照耶和华的吩咐起行。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","有时从晚上到早晨，有这云彩在帐幕上；早晨云彩收上去，他们就起行。有时昼夜云彩停在帐幕上，收上去的时候，他们就起行。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","云彩停留在帐幕上，无论是两天，是一月，是一年，以色列人就住营不起行；但云彩收上去，他们就起行。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","他们遵耶和华的吩咐安营，也遵耶和华的吩咐起行。他们守耶和华所吩咐的，都是凭耶和华吩咐摩西的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","耶和华晓谕摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","「你要用银子做两枝号，都要锤出来的，用以招聚会众，并叫众营起行。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","吹这号的时候，全会众要到你那里，聚集在会幕门口。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","若单吹一枝，众首领，就是以色列军中的统领，要聚集到你那里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","吹出大声的时候，东边安的营都要起行。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","二次吹出大声的时候，南边安的营都要起行。他们将起行，必吹出大声。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","但招聚会众的时候，你们要吹号，却不要吹出大声。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","亚伦子孙作祭司的要吹这号；这要作你们世世代代永远的定例。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","你们在自己的地，与欺压你们的敌人打仗，就要用号吹出大声，便在耶和华—你们的　神面前得蒙纪念，也蒙拯救脱离仇敌。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","在你们快乐的日子和节期，并月朔，献燔祭和平安祭，也要吹号，这都要在你们的　神面前作为纪念。我是耶和华—你们的　神。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","第二年二月二十日，云彩从法柜的帐幕收上去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","以色列人就按站往前行，离开西奈的旷野，云彩停住在巴兰的旷野。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","这是他们照耶和华借摩西所吩咐的，初次往前行。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","按着军队首先往前行的是犹大营的纛。统领军队的是亚米拿达的儿子拿顺。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","统领以萨迦支派军队的是苏押的儿子拿坦业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","统领西布伦支派军队的是希伦的儿子以利押。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","帐幕拆卸，革顺的子孙和米拉利的子孙就抬着帐幕先往前行。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","按着军队往前行的是吕便营的纛。统领军队的是示丢珥的儿子以利蓿。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","统领西缅支派军队的是苏利沙代的儿子示路蔑。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","统领迦得支派军队的是丢珥的儿子以利雅萨。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","哥辖人抬着圣物先往前行。他们未到以前，抬帐幕的已经把帐幕支好。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","按着军队往前行的是以法莲营的纛，统领军队的是亚米忽的儿子以利沙玛。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","统领玛拿西支派军队的是比大蓿的儿子迦玛列。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","统领便雅悯支派军队的是基多尼的儿子亚比但。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","在诸营末后的是但营的纛，按着军队往前行。统领军队的是亚米沙代的儿子亚希以谢。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","统领亚设支派军队的是俄兰的儿子帕结。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","统领拿弗他利支派军队的是以南的儿子亚希拉。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","以色列人按着军队往前行，就是这样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","摩西对他岳父—米甸人流珥的儿子何巴—说：「我们要行路，往耶和华所应许之地去；他曾说：『我要将这地赐给你们。』现在求你和我们同去，我们必厚待你，因为耶和华指着以色列人已经应许给好处。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","何巴回答说：「我不去；我要回本地本族那里去。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","摩西说：「求你不要离开我们；因为你知道我们要在旷野安营，你可以当作我们的眼目。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","你若和我们同去，将来耶和华有什么好处待我们，我们也必以什么好处待你。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","以色列人离开耶和华的山，往前行了三天的路程；耶和华的约柜在前头行了三天的路程，为他们寻找安歇的地方。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","他们拔营往前行，日间有耶和华的云彩在他们以上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","约柜往前行的时候，摩西就说：「耶和华啊，求你兴起！愿你的仇敌四散！愿恨你的人从你面前逃跑！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","约柜停住的时候，他就说：「耶和华啊，求你回到以色列的千万人中！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","众百姓发怨言，他们的恶语达到耶和华的耳中。耶和华听见了就怒气发作，使火在他们中间焚烧，直烧到营的边界。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","百姓向摩西哀求，摩西祈求耶和华，火就熄了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","那地方便叫做他备拉，因为耶和华的火烧在他们中间。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","他们中间的闲杂人大起贪欲的心；以色列人又哭号说：「谁给我们肉吃呢？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","我们记得，在埃及的时候不花钱就吃鱼，也记得有黄瓜、西瓜、韭菜、葱、蒜。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","现在我们的心血枯竭了，除这吗哪以外，在我们眼前并没有别的东西。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","这吗哪仿佛芫荽子，又好像珍珠。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","百姓周围行走，把吗哪收起来，或用磨推，或用臼捣，煮在锅中，又做成饼，滋味好像新油。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","夜间露水降在营中，吗哪也随着降下。） ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","摩西听见百姓各在各家的帐棚门口哭号。耶和华的怒气便大发作，摩西就不喜悦。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","摩西对耶和华说：「你为何苦待仆人？我为何不在你眼前蒙恩，竟把这管理百姓的重任加在我身上呢？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","这百姓岂是我怀的胎，岂是我生下来的呢？你竟对我说：『把他们抱在怀里，如养育之父抱吃奶的孩子，直抱到你起誓应许给他们祖宗的地去。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","我从哪里得肉给这百姓吃呢？他们都向我哭号说：『你给我们肉吃吧！』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","管理这百姓的责任太重了，我独自担当不起。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","你这样待我，我若在你眼前蒙恩，求你立时将我杀了，不叫我见自己的苦情。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","耶和华对摩西说：「你从以色列的长老中招聚七十个人，就是你所知道作百姓的长老和官长的，到我这里来，领他们到会幕前，使他们和你一同站立。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","我要在那里降临，与你说话，也要把降于你身上的灵分赐他们，他们就和你同当这管百姓的重任，免得你独自担当。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","又要对百姓说：『你们应当自洁，预备明天吃肉，因为你们哭号说：谁给我们肉吃！我们在埃及很好。这声音达到了耶和华的耳中，所以他必给你们肉吃。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","你们不止吃一天、两天、五天、十天、二十天， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","要吃一个整月，甚至肉从你们鼻孔里喷出来，使你们厌恶了，因为你们厌弃住在你们中间的耶和华，在他面前哭号说：我们为何出了埃及呢！』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","摩西对耶和华说：「这与我同住的百姓、步行的男人有六十万，你还说：『我要把肉给他们，使他们可以吃一个整月。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","难道给他们宰了羊群牛群，或是把海中所有的鱼都聚了来，就够他们吃吗？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","耶和华对摩西说：「耶和华的膀臂岂是缩短了吗？现在要看我的话向你应验不应验。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","摩西出去，将耶和华的话告诉百姓，又招聚百姓的长老中七十个人来，使他们站在会幕的四围。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","耶和华在云中降临，对摩西说话，把降与他身上的灵分赐那七十个长老。灵停在他们身上的时候，他们就受感说话，以后却没有再说。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","但有两个人仍在营里，一个名叫伊利达，一个名叫米达。他们本是在那些被录的人中，却没有到会幕那里去。灵停在他们身上，他们就在营里说预言。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","有个少年人跑来告诉摩西说：「伊利达、米达在营里说预言。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","摩西的帮手，嫩的儿子约书亚，就是摩西所拣选的一个人，说：「请我主摩西禁止他们。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","摩西对他说：「你为我的缘故嫉妒人吗？惟愿耶和华的百姓都受感说话！愿耶和华把他的灵降在他们身上！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","于是，摩西和以色列的长老都回到营里去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","有风从耶和华那里刮起，把鹌鹑由海面刮来，飞散在营边和营的四围；这边约有一天的路程，那边约有一天的路程，离地面约有二肘。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","百姓起来，终日终夜，并次日一整天，捕取鹌鹑；至少的也取了十贺梅珥，为自己摆列在营的四围。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","肉在他们牙齿之间尚未嚼烂，耶和华的怒气就向他们发作，用最重的灾殃击杀了他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","那地方便叫做基博罗·哈他瓦，因为他们在那里葬埋那起贪欲之心的人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","百姓从基博罗·哈他瓦走到哈洗录，就住在哈洗录。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","摩西娶了古实女子为妻。米利暗和亚伦因他所娶的古实女子就毁谤他，说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","「难道耶和华单与摩西说话，不也与我们说话吗？」这话耶和华听见了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","摩西为人极其谦和，胜过世上的众人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","耶和华忽然对摩西、亚伦、米利暗说：「你们三个人都出来，到会幕这里。」他们三个人就出来了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","耶和华在云柱中降临，站在会幕门口，召亚伦和米利暗，二人就出来了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","耶和华说：「你们且听我的话：你们中间若有先知，我—耶和华必在异象中向他显现，在梦中与他说话。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","我的仆人摩西不是这样；他是在我全家尽忠的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","我要与他面对面说话，乃是明说，不用谜语，并且他必见我的形象。你们毁谤我的仆人摩西，为何不惧怕呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","耶和华就向他们二人发怒而去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","云彩从会幕上挪开了，不料，米利暗长了大麻风，有雪那样白。亚伦一看米利暗长了大麻风， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","就对摩西说：「我主啊，求你不要因我们愚昧犯罪，便将这罪加在我们身上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","求你不要使她像那出母腹、肉已半烂的死胎。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","于是摩西哀求耶和华说：「　神啊，求你医治她！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","耶和华对摩西说：「她父亲若吐唾沫在她脸上，她岂不蒙羞七天吗？现在要把她在营外关锁七天，然后才可以领她进来。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","于是米利暗关锁在营外七天。百姓没有行路，直等到把米利暗领进来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","以后百姓从哈洗录起行，在巴兰的旷野安营。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","耶和华晓谕摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","「你打发人去窥探我所赐给以色列人的迦南地，他们每支派中要打发一个人，都要作首领的。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","摩西就照耶和华的吩咐从巴兰的旷野打发他们去；他们都是以色列人的族长。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","他们的名字：属吕便支派的有撒刻的儿子沙母亚。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","属西缅支派的有何利的儿子沙法。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","属犹大支派的有耶孚尼的儿子迦勒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","属以萨迦支派的有约色的儿子以迦。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","属以法莲支派的有嫩的儿子何希阿。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","属便雅悯支派的有拉孚的儿子帕提。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","属西布伦支派的有梭底的儿子迦叠。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","约瑟的子孙，属玛拿西支派的有稣西的儿子迦底。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","属但支派的有基玛利的儿子亚米利。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","属亚设支派的有米迦勒的儿子西帖。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","属拿弗他利支派的有缚西的儿子拿比。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","属迦得支派的有玛基的儿子臼利。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","这就是摩西所打发、窥探那地之人的名字。摩西就称嫩的儿子何希阿为约书亚。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","摩西打发他们去窥探迦南地，说：「你们从南地上山地去， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","看那地如何，其中所住的民是强是弱，是多是少， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","所住之地是好是歹，所住之处是营盘是坚城。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","又看那地土是肥美是瘠薄，其中有树木没有。你们要放开胆量，把那地的果子带些来。」（那时正是葡萄初熟的时候。） ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","他们上去窥探那地，从寻的旷野到利合，直到哈马口。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","他们从南地上去，到了希伯 ；在那里有亚衲族人亚希幔、示筛、挞买。（原来希伯 城被建造比埃及的锁安城早七年。） ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","他们到了以实各谷，从那里砍了葡萄树的一枝，上头有一挂葡萄，两个人用杠抬着，又带了些石榴和无花果来。（ ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","因为以色列人从那里砍来的那挂葡萄，所以那地方叫做以实各谷。） ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","过了四十天，他们窥探那地才回来， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","到了巴兰旷野的加低斯，见摩西、亚伦，并以色列的全会众，回报摩西、亚伦，并全会众，又把那地的果子给他们看； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","又告诉摩西说：「我们到了你所打发我们去的那地，果然是流奶与蜜之地；这就是那地的果子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","然而住那地的民强壮，城邑也坚固宽大，并且我们在那里看见了亚衲族的人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","亚玛力人住在南地；赫人、耶布斯人、亚摩利人住在山地；迦南人住在海边并约旦河旁。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","迦勒在摩西面前安抚百姓，说：「我们立刻上去得那地吧！我们足能得胜。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","但那些和他同去的人说：「我们不能上去攻击那民，因为他们比我们强壮。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","探子中有人论到所窥探之地，向以色列人报恶信，说：「我们所窥探、经过之地是吞吃居民之地，我们在那里所看见的人民都身量高大。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","我们在那里看见亚衲族人，就是伟人；他们是伟人的后裔。据我们看，自己就如蚱蜢一样；据他们看，我们也是如此。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","当下，全会众大声喧嚷；那夜百姓都哭号。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","以色列众人向摩西、亚伦发怨言；全会众对他们说：「巴不得我们早死在埃及地，或是死在这旷野。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","耶和华为什么把我们领到那地，使我们倒在刀下呢？我们的妻子和孩子必被掳掠。我们回埃及去岂不好吗？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","众人彼此说：「我们不如立一个首领回埃及去吧！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","摩西、亚伦就俯伏在以色列全会众面前。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","窥探地的人中，嫩的儿子约书亚和耶孚尼的儿子迦勒撕裂衣服， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","对以色列全会众说：「我们所窥探、经过之地是极美之地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","耶和华若喜悦我们，就必将我们领进那地，把地赐给我们；那地原是流奶与蜜之地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","但你们不可背叛耶和华，也不要怕那地的居民；因为他们是我们的食物，并且荫庇他们的已经离开他们。有耶和华与我们同在，不要怕他们！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","但全会众说：「拿石头打死他们二人。」忽然，耶和华的荣光在会幕中向以色列众人显现。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","耶和华对摩西说：「这百姓藐视我要到几时呢？我在他们中间行了这一切神迹，他们还不信我要到几时呢？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","我要用瘟疫击杀他们，使他们不得承受那地，叫你的后裔成为大国，比他们强胜。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","摩西对耶和华说：「埃及人必听见这事；因为你曾施展大能，将这百姓从他们中间领上来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","埃及人要将这事传给迦南地的居民；那民已经听见你—耶和华是在这百姓中间；因为你面对面被人看见，有你的云彩停在他们以上。你日间在云柱中，夜间在火柱中，在他们前面行。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","如今你若把这百姓杀了，如杀一人，那些听见你名声的列邦必议论说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","『耶和华因为不能把这百姓领进他向他们起誓应许之地，所以在旷野把他们杀了。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","现在求主大显能力，照你所说过的话说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","『耶和华不轻易发怒，并有丰盛的慈爱，赦免罪孽和过犯；万不以有罪的为无罪，必追讨他的罪，自父及子，直到三、四代。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","求你照你的大慈爱赦免这百姓的罪孽，好像你从埃及到如今常赦免他们一样。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","耶和华说：「我照着你的话赦免了他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","然我指着我的永生起誓，遍地要被我的荣耀充满。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","这些人虽看见我的荣耀和我在埃及与旷野所行的神迹，仍然试探我这十次，不听从我的话， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","他们断不得看见我向他们的祖宗所起誓应许之地。凡藐视我的，一个也不得看见； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","惟独我的仆人迦勒，因他另有一个心志，专一跟从我，我就把他领进他所去过的那地；他的后裔也必得那地为业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","亚玛力人和迦南人住在谷中，明天你们要转回，从红海的路往旷野去。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","耶和华对摩西、亚伦说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","「这恶会众向我发怨言，我忍耐他们要到几时呢？以色列人向我所发的怨言，我都听见了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","你们告诉他们，耶和华说：『我指着我的永生起誓，我必要照你们达到我耳中的话待你们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","你们的尸首必倒在这旷野，并且你们中间凡被数点、从二十岁以外、向我发怨言的， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","必不得进我起誓应许叫你们住的那地；惟有耶孚尼的儿子迦勒和嫩的儿子约书亚才能进去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","但你们的妇人孩子，就是你们所说、要被掳掠的，我必把他们领进去，他们就得知你们所厌弃的那地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","至于你们，你们的尸首必倒在这旷野； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","你们的儿女必在旷野飘流四十年，担当你们淫行的罪，直到你们的尸首在旷野消灭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","按你们窥探那地的四十日，一年顶一日，你们要担当罪孽四十年，就知道我与你们疏远了， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","我—耶和华说过，我总要这样待这一切聚集敌我的恶会众；他们必在这旷野消灭，在这里死亡。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","摩西所打发、窥探那地的人回来，报那地的恶信，叫全会众向摩西发怨言， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","这些报恶信的人都遭瘟疫，死在耶和华面前。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","其中惟有嫩的儿子约书亚和耶孚尼的儿子迦勒仍然存活。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","摩西将这些话告诉以色列众人，他们就甚悲哀。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","清早起来，上山顶去，说：「我们在这里，我们有罪了；情愿上耶和华所应许的地方去。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","摩西说：「你们为何违背耶和华的命令呢？这事不能顺利了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","不要上去；因为耶和华不在你们中间，恐怕你们被仇敌杀败了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","亚玛力人和迦南人都在你们面前，你们必倒在刀下；因你们退回不跟从耶和华，所以他必不与你们同在。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","他们却擅敢上山顶去，然而耶和华的约柜和摩西没有出营。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","于是亚玛力人和住在那山上的迦南人都下来击打他们，把他们杀退了，直到何珥玛。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","耶和华对摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","「你晓谕以色列人说：你们到了我所赐给你们居住的地， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","若愿意从牛群羊群中取牛羊作火祭，献给耶和华，无论是燔祭是平安祭，为要还特许的愿，或是作甘心祭，或是逢你们节期献的，都要奉给耶和华为馨香之祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","那献供物的就要将细面伊法十分之一，并油一欣四分之一，调和作素祭，献给耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","无论是燔祭是平安祭，你要为每只绵羊羔，一同预备奠祭的酒一欣四分之一。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","为公绵羊预备细面伊法十分之二，并油一欣三分之一，调和作素祭， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","又用酒一欣三分之一作奠祭，献给耶和华为馨香之祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","你预备公牛作燔祭，或是作平安祭，为要还特许的愿，或是作平安祭，献给耶和华， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","就要把细面伊法十分之三，并油半欣，调和作素祭，和公牛一同献上， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","又用酒半欣作奠祭，献给耶和华为馨香的火祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","「献公牛、公绵羊、绵羊羔、山羊羔，每只都要这样办理。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","照你们所预备的数目，按着只数都要这样办理。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","凡本地人将馨香的火祭献给耶和华，都要这样办理。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","若有外人和你们同居，或有人世世代代住在你们中间，愿意将馨香的火祭献给耶和华，你们怎样办理，他也要照样办理。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","至于会众，你们和同居的外人都归一例，作为你们世世代代永远的定例，在耶和华面前，你们怎样，寄居的也要怎样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","你们并与你们同居的外人当有一样的条例，一样的典章。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","耶和华对摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","「你晓谕以色列人说：你们到了我所领你们进去的那地， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","吃那地的粮食，就要把举祭献给耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","你们要用初熟的麦子磨面，做饼当举祭奉献；你们举上，好像举禾场的举祭一样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","你们世世代代要用初熟的麦子磨面，当举祭献给耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","「你们有错误的时候，不守耶和华所晓谕摩西的这一切命令， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","就是耶和华借摩西一切所吩咐你们的，自那日以至你们的世世代代， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","若有误行，是会众所不知道的，后来全会众就要将一只公牛犊作燔祭，并照典章把素祭和奠祭一同献给耶和华为馨香之祭，又献一只公山羊作赎罪祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","祭司要为以色列全会众赎罪，他们就必蒙赦免，因为这是错误。他们又因自己的错误，把供物，就是向耶和华献的火祭和赎罪祭，一并奉到耶和华面前。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","以色列全会众和寄居在他们中间的外人就必蒙赦免，因为这罪是百姓误犯的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","「若有一个人误犯了罪，他就要献一岁的母山羊作赎罪祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","那误行的人犯罪的时候，祭司要在耶和华面前为他赎罪，他就必蒙赦免。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","以色列中的本地人和寄居在他们中间的外人，若误行了什么事，必归一样的条例。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","但那擅敢行事的，无论是本地人是寄居的，他亵渎了耶和华，必从民中剪除。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","因他藐视耶和华的言语，违背耶和华的命令，那人总要剪除；他的罪孽要归到他身上。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","以色列人在旷野的时候，遇见一个人在安息日捡柴。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","遇见他捡柴的人，就把他带到摩西、亚伦并全会众那里， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","将他收在监内；因为当怎样办他，还没有指明。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","耶和华吩咐摩西说：「总要把那人治死；全会众要在营外用石头把他打死。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","于是全会众将他带到营外，用石头打死他，是照耶和华所吩咐摩西的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","耶和华晓谕摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","「你吩咐以色列人，叫他们世世代代在衣服边上做 子，又在底边的 子上钉一根蓝细带子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","你们佩带这 子，好叫你们看见就记念遵行耶和华一切的命令，不随从自己的心意、眼目行邪淫，像你们素常一样； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","使你们记念遵行我一切的命令，成为圣洁，归与你们的　神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","「我是耶和华—你们的　神，曾把你们从埃及地领出来，要作你们的　神。我是耶和华—你们的　神。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","利未的曾孙、哥辖的孙子、以斯哈的儿子可拉，和吕便子孙中以利押的儿子大坍、亚比兰，与比勒的儿子安， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","并以色列会中的二百五十个首领，就是有名望选入会中的人，在摩西面前一同起来， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","聚集攻击摩西、亚伦，说：「你们擅自专权！全会众个个既是圣洁，耶和华也在他们中间，你们为什么自高，超过耶和华的会众呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","摩西听见这话就俯伏在地， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","对可拉和他一党的人说：「到了早晨，耶和华必指示谁是属他的，谁是圣洁的，就叫谁亲近他；他所拣选的是谁，必叫谁亲近他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","可拉啊，你们要这样行，你和你的一党要拿香炉来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","明日，在耶和华面前，把火盛在炉中，把香放在其上。耶和华拣选谁，谁就为圣洁。你们这利未的子孙擅自专权了！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","摩西又对可拉说：「利未的子孙哪，你们听我说！ ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","以色列的　神从以色列会中将你们分别出来，使你们亲近他，办耶和华帐幕的事，并站在会众面前替他们当差。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","耶和华又使你和你一切弟兄—利未的子孙—一同亲近他，这岂为小事？你们还要求祭司的职任吗？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","你和你一党的人聚集是要攻击耶和华。亚伦算什么，你们竟向他发怨言呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","摩西打发人去召以利押的儿子大坍、亚比兰。他们说：「我们不上去！ ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","你将我们从流奶与蜜之地领上来，要在旷野杀我们，这岂为小事？你还要自立为王辖管我们吗？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","并且你没有将我们领到流奶与蜜之地，也没有把田地和葡萄园给我们为业。难道你要剜这些人的眼睛吗？我们不上去！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","摩西就甚发怒，对耶和华说：「求你不要享受他们的供物。我并没有夺过他们一匹驴，也没有害过他们一个人。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","摩西对可拉说：「明天，你和你一党的人，并亚伦，都要站在耶和华面前； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","各人要拿一个香炉，共二百五十个，把香放在上面，到耶和华面前。你和亚伦也各拿自己的香炉。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","于是他们各人拿一个香炉，盛上火，加上香，同摩西、亚伦站在会幕门前。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","可拉招聚全会众到会幕门前，要攻击摩西、亚伦；耶和华的荣光就向全会众显现。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","耶和华晓谕摩西、亚伦说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","「你们离开这会众，我好在转眼之间把他们灭绝。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","摩西、亚伦就俯伏在地，说：「　神，万人之灵的　神啊，一人犯罪，你就要向全会众发怒吗？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","耶和华晓谕摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","「你吩咐会众说：『你们离开可拉、大坍、亚比兰帐棚的四围。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","摩西起来，往大坍、亚比兰那里去；以色列的长老也随着他去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","他吩咐会众说：「你们离开这恶人的帐棚吧，他们的物件，什么都不可摸，恐怕你们陷在他们的罪中，与他们一同消灭。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","于是众人离开可拉、大坍、亚比兰帐棚的四围。大坍、亚比兰带着妻子、儿女、小孩子，都出来，站在自己的帐棚门口。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","摩西说：「我行的这一切事本不是凭我自己心意行的，乃是耶和华打发我行的，必有证据使你们知道。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","这些人死若与世人无异，或是他们所遭的与世人相同，就不是耶和华打发我来的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","倘若耶和华创作一件新事，使地开口，把他们和一切属他们的都吞下去，叫他们活活地坠落阴间，你们就明白这些人是藐视耶和华了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","摩西刚说完了这一切话，他们脚下的地就开了口， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","把他们和他们的家眷，并一切属可拉的人丁、财物，都吞下去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","这样，他们和一切属他们的，都活活地坠落阴间；地口在他们上头照旧合闭，他们就从会中灭亡。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","在他们四围的以色列众人听他们呼号，就都逃跑，说：「恐怕地也把我们吞下去。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","又有火从耶和华那里出来，烧灭了那献香的二百五十个人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","耶和华晓谕摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","「你吩咐祭司亚伦的儿子以利亚撒从火中捡起那些香炉来，把火撒在别处，因为那些香炉是圣的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","把那些犯罪、自害己命之人的香炉，叫人锤成片子，用以包坛。那些香炉本是他们在耶和华面前献过的，所以是圣的，并且可以给以色列人作记号。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","于是祭司以利亚撒将被烧之人所献的铜香炉拿来，人就锤出来，用以包坛， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","给以色列人作纪念，使亚伦后裔之外的人不得近前来在耶和华面前烧香，免得他遭可拉和他一党所遭的。这乃是照耶和华借着摩西所吩咐的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","第二天，以色列全会众都向摩西、亚伦发怨言说：「你们杀了耶和华的百姓了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","会众聚集攻击摩西、亚伦的时候，向会幕观看，不料，有云彩遮盖了，耶和华的荣光显现。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","摩西、亚伦就来到会幕前。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","耶和华吩咐摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","「你们离开这会众，我好在转眼之间把他们灭绝。」他们二人就俯伏于地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","摩西对亚伦说：「拿你的香炉，把坛上的火盛在其中，又加上香，快快带到会众那里，为他们赎罪；因为有忿怒从耶和华那里出来，瘟疫已经发作了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","亚伦照着摩西所说的拿来，跑到会中，不料，瘟疫在百姓中已经发作了。他就加上香，为百姓赎罪。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","他站在活人死人中间，瘟疫就止住了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","除了因可拉事情死的以外，遭瘟疫死的，共有一万四千七百人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","亚伦回到会幕门口，到摩西那里，瘟疫已经止住了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","耶和华对摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","「你晓谕以色列人，从他们手下取杖，每支派一根；从他们所有的首领，按着支派，共取十二根。你要将各人的名字写在各人的杖上， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","并要将亚伦的名字写在利未的杖上，因为各族长必有一根杖。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","你要把这些杖存在会幕内法柜前，就是我与你们相会之处。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","后来我所拣选的那人，他的杖必发芽。这样，我必使以色列人向你们所发的怨言止息，不再达到我耳中。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","于是摩西晓谕以色列人，他们的首领就把杖交给他，按着支派，每首领一根，共有十二根；亚伦的杖也在其中。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","摩西就把杖存在法柜的帐幕内，在耶和华面前。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","第二天，摩西进法柜的帐幕去。谁知利未族亚伦的杖已经发了芽，生了花苞，开了花，结了熟杏。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","摩西就把所有的杖从耶和华面前拿出来，给以色列众人看；他们看见了，各首领就把自己的杖拿去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","耶和华吩咐摩西说：「把亚伦的杖还放在法柜前，给这些背叛之子留作记号。这样，你就使他们向我发的怨言止息，免得他们死亡。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","摩西就这样行。耶和华怎样吩咐他，他就怎样行了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","以色列人对摩西说：「我们死啦！我们灭亡啦！都灭亡啦！ ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","凡挨近耶和华帐幕的是必死的。我们都要死亡吗？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","耶和华对亚伦说：「你和你的儿子，并你本族的人，要一同担当干犯圣所的罪孽。你和你的儿子也要一同担当干犯祭司职任的罪孽。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","你要带你弟兄利未人，就是你祖宗支派的人前来，使他们与你联合，服事你，只是你和你的儿子，要一同在法柜的帐幕前供职。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","他们要守所吩咐你的，并守全帐幕，只是不可挨近圣所的器具和坛，免得他们和你们都死亡。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","他们要与你联合，也要看守会幕，办理帐幕一切的事，只是外人不可挨近你们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","你们要看守圣所和坛，免得忿怒再临到以色列人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","我已将你们的弟兄利未人从以色列人中拣选出来归耶和华，是给你们为赏赐的，为要办理会幕的事。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","你和你的儿子要为一切属坛和幔子内的事一同守祭司的职任。你们要这样供职；我将祭司的职任给你们当作赏赐事奉我。凡挨近的外人必被治死。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","耶和华晓谕亚伦说：「我已将归我的举祭，就是以色列人一切分别为圣的物，交给你经管；因你受过膏，把这些都赐给你和你的子孙，当作永得的分。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","以色列人归给我至圣的供物，就是一切的素祭、赎罪祭、赎愆祭，其中所有存留不经火的，都为至圣之物，要归给你和你的子孙。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","你要拿这些当至圣物吃；凡男丁都可以吃。你当以此物为圣。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","以色列人所献的举祭并摇祭都是你的；我已赐给你和你的儿女，当作永得的分；凡在你家中的洁净人都可以吃。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","凡油中、新酒中、五谷中至好的，就是以色列人所献给耶和华初熟之物，我都赐给你。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","凡从他们地上所带来给耶和华初熟之物也都要归与你。你家中的洁净人都可以吃。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","以色列中一切永献的都必归与你。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","他们所有奉给耶和华的，连人带牲畜，凡头生的，都要归给你；只是人头生的，总要赎出来；不洁净牲畜头生的，也要赎出来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","其中在一月之外所当赎的，要照你所估定的价，按圣所的平，用银子五舍客勒赎出来（一舍客勒是二十季拉）。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","只是头生的牛，或是头生的绵羊和山羊，必不可赎，都是圣的，要把它的血洒在坛上，把它的脂油焚烧，当作馨香的火祭献给耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","它的肉必归你，像被摇的胸、被举的右腿归你一样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","凡以色列人所献给耶和华圣物中的举祭，我都赐给你和你的儿女，当作永得的分。这是给你和你的后裔、在耶和华面前作为永远的盐约。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","耶和华对亚伦说：「你在以色列人的境内不可有产业，在他们中间也不可有分。我就是你的分，是你的产业。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","「凡以色列中出产的十分之一，我已赐给利未的子孙为业；因他们所办的是会幕的事，所以赐给他们为酬他们的劳。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","从今以后，以色列人不可挨近会幕，免得他们担罪而死。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","惟独利未人要办会幕的事，担当罪孽；这要作你们世世代代永远的定例。他们在以色列人中不可有产业； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","因为以色列人中出产的十分之一，就是献给耶和华为举祭的，我已赐给利未人为业。所以我对他们说：『在以色列人中不可有产业。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","耶和华吩咐摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","「你晓谕利未人说：你们从以色列人中所取的十分之一，就是我给你们为业的，要再从那十分之一中取十分之一作为举祭献给耶和华， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","这举祭要算为你们场上的谷，又如满酒榨的酒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","这样，你们从以色列人中所得的十分之一也要作举祭献给耶和华，从这十分之一中，将所献给耶和华的举祭归给祭司亚伦。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","奉给你们的一切礼物，要从其中将至好的，就是分别为圣的，献给耶和华为举祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","所以你要对利未人说：你们从其中将至好的举起，这就算为你们场上的粮，又如酒榨的酒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","你们和你们家属随处可以吃；这原是你们的赏赐，是酬你们在会幕里办事的劳。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","你们从其中将至好的举起，就不至因这物担罪。你们不可亵渎以色列人的圣物，免得死亡。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","耶和华晓谕摩西、亚伦说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","「耶和华命定律法中的一条律例乃是这样说：你要吩咐以色列人，把一只没有残疾、未曾负轭、纯红的母牛牵到你这里来， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","交给祭司以利亚撒；他必牵到营外，人就把牛宰在他面前。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","祭司以利亚撒要用指头蘸这牛的血，向会幕前面弹七次。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","人要在他眼前把这母牛焚烧；牛的皮、肉、血、粪都要焚烧。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","祭司要把香柏木、牛膝草、朱红色线都丢在烧牛的火中。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","祭司必不洁净到晚上，要洗衣服，用水洗身，然后可以进营。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","烧牛的人必不洁净到晚上，也要洗衣服，用水洗身。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","必有一个洁净的人收起母牛的灰，存在营外洁净的地方，为以色列会众调做除污秽的水。这本是除罪的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","收起母牛灰的人必不洁净到晚上，要洗衣服。这要给以色列人和寄居在他们中间的外人作为永远的定例。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","「摸了人死尸的，就必七天不洁净。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","那人到第三天要用这除污秽的水洁净自己，第七天就洁净了。他若在第三天不洁净自己，第七天就不洁净了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","凡摸了人死尸、不洁净自己的，就玷污了耶和华的帐幕，这人必从以色列中剪除；因为那除污秽的水没有洒在他身上，他就为不洁净，污秽还在他身上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","「人死在帐棚里的条例乃是这样：凡进那帐棚的，和一切在帐棚里的，都必七天不洁净。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","凡敞口的器皿，就是没有扎上盖的，也是不洁净。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","无论何人在田野里摸了被刀杀的，或是尸首，或是人的骨头，或是坟墓，就要七天不洁净。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","要为这不洁净的人拿些烧成的除罪灰放在器皿里，倒上活水。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","必当有一个洁净的人拿牛膝草蘸在这水中，把水洒在帐棚上，和一切器皿并帐棚内的众人身上，又洒在摸了骨头，或摸了被杀的，或摸了自死的，或摸了坟墓的那人身上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","第三天和第七天，洁净的人要洒水在不洁净的人身上，第七天就使他成为洁净。那人要洗衣服，用水洗澡，到晚上就洁净了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","「但那污秽而不洁净自己的，要将他从会中剪除，因为他玷污了耶和华的圣所。除污秽的水没有洒在他身上，他是不洁净的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","这要给你们作为永远的定例。并且那洒除污秽水的人要洗衣服。凡摸除污秽水的，必不洁净到晚上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","不洁净人所摸的一切物就不洁净；摸了这物的人必不洁净到晚上。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","正月间，以色列全会众到了寻的旷野，就住在加低斯。米利暗死在那里，就葬在那里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","会众没有水喝，就聚集攻击摩西、亚伦。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","百姓向摩西争闹说：「我们的弟兄曾死在耶和华面前，我们恨不得与他们同死。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","你们为何把耶和华的会众领到这旷野、使我们和牲畜都死在这里呢？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","你们为何逼着我们出埃及、领我们到这坏地方呢？这地方不好撒种，也没有无花果树、葡萄树、石榴树，又没有水喝。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","摩西、亚伦离开会众，到会幕门口，俯伏在地；耶和华的荣光向他们显现。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","耶和华晓谕摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","「你拿着杖去，和你的哥哥亚伦招聚会众，在他们眼前吩咐磐石发出水来，水就从磐石流出，给会众和他们的牲畜喝。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","于是摩西照耶和华所吩咐的，从耶和华面前取了杖去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","摩西、亚伦就招聚会众到磐石前。摩西说：「你们这些背叛的人听我说：我为你们使水从这磐石中流出来吗？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","摩西举手，用杖击打磐石两下，就有许多水流出来，会众和他们的牲畜都喝了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","耶和华对摩西、亚伦说：「因为你们不信我，不在以色列人眼前尊我为圣，所以你们必不得领这会众进我所赐给他们的地去。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","这水名叫米利巴水，是因以色列人向耶和华争闹，耶和华就在他们面前显为圣。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","摩西从加低斯差遣使者去见以东王，说：「你的弟兄以色列人这样说：『我们所遭遇的一切艰难， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","就是我们的列祖下到埃及，我们在埃及久住；埃及人恶待我们的列祖和我们， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","我们哀求耶和华的时候，他听了我们的声音，差遣使者把我们从埃及领出来。这事你都知道。如今，我们在你边界上的城加低斯。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","求你容我们从你的地经过。我们不走田间和葡萄园，也不喝井里的水，只走大道，不偏左右，直到过了你的境界。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","以东王说：「你不可从我的地经过，免得我带刀出去攻击你。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","以色列人说：「我们要走大道上去；我们和牲畜若喝你的水，必给你价值。不求别的，只求你容我们步行过去。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","以东王说：「你们不可经过！」就率领许多人出来，要用强硬的手攻击以色列人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","这样，以东王不肯容以色列人从他的境界过去。于是他们转去，离开他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","以色列全会众从加低斯起行，到了何珥山。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","耶和华在附近以东边界的何珥山上晓谕摩西、亚伦说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","「亚伦要归到他列祖那里。他必不得入我所赐给以色列人的地；因为在米利巴水，你们违背了我的命。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","你带亚伦和他的儿子以利亚撒上何珥山， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","把亚伦的圣衣脱下来，给他的儿子以利亚撒穿上；亚伦必死在那里，归他列祖。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","摩西就照耶和华所吩咐的行。三人当着会众的眼前上了何珥山。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","摩西把亚伦的圣衣脱下来，给他的儿子以利亚撒穿上，亚伦就死在山顶那里。于是摩西和以利亚撒下了山。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","全会众，就是以色列全家，见亚伦已经死了，便都为亚伦哀哭了三十天。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","住南地的迦南人亚拉得王，听说以色列人从亚他林路来，就和以色列人争战，掳了他们几个人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","以色列人向耶和华发愿说：「你若将这民交付我手，我就把他们的城邑尽行毁灭。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","耶和华应允了以色列人，把迦南人交付他们，他们就把迦南人和迦南人的城邑尽行毁灭。那地方的名便叫何珥玛。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","他们从何珥山起行，往红海那条路走，要绕过以东地。百姓因这路难行，心中甚是烦躁， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","就怨 　神和摩西说：「你们为什么把我们从埃及领出来、使我们死在旷野呢？这里没有粮，没有水，我们的心厌恶这淡薄的食物。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","于是耶和华使火蛇进入百姓中间，蛇就咬他们。以色列人中死了许多。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","百姓到摩西那里，说：「我们怨 耶和华和你，有罪了。求你祷告耶和华，叫这些蛇离开我们。」于是摩西为百姓祷告。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","耶和华对摩西说：「你制造一条火蛇，挂在杆子上；凡被咬的，一望这蛇，就必得活。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","摩西便制造一条铜蛇，挂在杆子上；凡被蛇咬的，一望这铜蛇就活了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","以色列人起行，安营在阿伯。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","又从阿伯起行，安营在以耶·亚巴琳，与摩押相对的旷野，向日出之地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","从那里起行，安营在撒烈谷。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","从那里起行，安营在亚嫩河那边。这亚嫩河是在旷野，从亚摩利的境界流出来的；原来亚嫩河是摩押的边界，在摩押和亚摩利人搭界的地方。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","所以耶和华的战记上说：「苏法的哇哈伯与亚嫩河的谷， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","并向亚珥城众谷的下坡，是靠近摩押的境界。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","以色列人从那里起行，到了比珥。从前耶和华吩咐摩西说：「招聚百姓，我好给他们水喝」，说的就是这井。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","当时，以色列人唱歌说： 井啊，涌上水来！ 你们要向这井歌唱。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","这井是首领和民中的尊贵人 用圭用杖所挖所掘的。 以色列人从旷野往玛他拿去， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","从玛他拿到拿哈列，从拿哈列到巴末， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","从巴末到摩押地的谷，又到那下望旷野之毗斯迦的山顶。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","以色列人差遣使者去见亚摩利人的王西宏，说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","「求你容我们从你的地经过；我们不偏入田间和葡萄园，也不喝井里的水，只走大道，直到过了你的境界。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","西宏不容以色列人从他的境界经过，就招聚他的众民出到旷野，要攻击以色列人，到了雅杂与以色列人争战。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","以色列人用刀杀了他，得了他的地，从亚嫩河到雅博河，直到亚扪人的境界，因为亚扪人的境界多有坚垒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","以色列人夺取这一切的城邑，也住亚摩利人的城邑，就是希实本与希实本的一切乡村。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","这希实本是亚摩利王西宏的京城；西宏曾与摩押的先王争战，从他手中夺取了全地，直到亚嫩河。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","所以那些作诗歌的说： 你们来到希实本； 愿西宏的城被修造，被建立。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","因为有火从希实本发出， 有火焰出于西宏的城， 烧尽摩押的亚珥和亚嫩河邱坛的祭司 。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","摩押啊，你有祸了！ 基抹的民哪，你们灭亡了！ 基抹的男子逃奔， 女子被掳，交付亚摩利的王西宏。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","我们射了他们； 希实本直到底本尽皆毁灭。 我们使地变成荒场，直到挪法； 这挪法直延到米底巴。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","这样，以色列人就住在亚摩利人之地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","摩西打发人去窥探雅谢，以色列人就占了雅谢的镇市，赶出那里的亚摩利人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","以色列人转回，向巴珊去。巴珊王噩和他的众民都出来，在以得来与他们交战。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","耶和华对摩西说：「不要怕他！因我已将他和他的众民，并他的地，都交在你手中；你要待他像从前待住希实本的亚摩利王西宏一般。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","于是他们杀了他和他的众子，并他的众民，没有留下一个，就得了他的地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","以色列人起行，在摩押平原、约旦河东，对着耶利哥安营。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","以色列人向亚摩利人所行的一切事，西拨的儿子巴勒都看见了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","摩押人因以色列民甚多，就大大惧怕，心内忧急， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","对米甸的长老说：「现在这众人要把我们四围所有的一概舔尽，就如牛舔尽田间的草一般。」那时西拨的儿子巴勒作摩押王。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","他差遣使者往大河边的毗夺去，到比珥的儿子巴兰本乡那里，召巴兰来，说：「有一宗民从埃及出来，遮满地面，与我对居。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","这民比我强盛，现在求你来为我咒诅他们，或者我能得胜，攻打他们，赶出此地。因为我知道，你为谁祝福，谁就得福；你咒诅谁，谁就受咒诅。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","摩押的长老和米甸的长老手里拿着卦金，到了巴兰那里，将巴勒的话都告诉了他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","巴兰说：「你们今夜在这里住宿，我必照耶和华所晓谕我的回报你们。」摩押的使臣就在巴兰那里住下了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","神临到巴兰那里，说：「在你这里的人都是谁？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","巴兰回答说：「是摩押王西拨的儿子巴勒打发人到我这里来，说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","『从埃及出来的民遮满地面，你来为我咒诅他们，或者我能与他们争战，把他们赶出去。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","神对巴兰说：「你不可同他们去，也不可咒诅那民，因为那民是蒙福的。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","巴兰早晨起来，对巴勒的使臣说：「你们回本地去吧，因为耶和华不容我和你们同去。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","摩押的使臣就起来，回巴勒那里去，说：「巴兰不肯和我们同来。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","巴勒又差遣使臣，比先前的又多又尊贵。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","他们到了巴兰那里，对他说：「西拨的儿子巴勒这样说：『求你不容什么事拦阻你不到我这里来， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","因为我必使你得极大的尊荣。你向我要什么，我就给你什么；只求你来为我咒诅这民。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","巴兰回答巴勒的臣仆说：「巴勒就是将他满屋的金银给我，我行大事小事也不得越过耶和华—我　神的命。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","现在我请你们今夜在这里住宿，等我得知耶和华还要对我说什么。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","当夜，　神临到巴兰那里，说：「这些人若来召你，你就起来同他们去，你只要遵行我对你所说的话。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","巴兰早晨起来，备上驴，和摩押的使臣一同去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","神因他去就发了怒；耶和华的使者站在路上敌挡他。他骑着驴，有两个仆人跟随他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","驴看见耶和华的使者站在路上，手里有拔出来的刀，就从路上跨进田间，巴兰便打驴，要叫它回转上路。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","耶和华的使者就站在葡萄园的窄路上；这边有墙，那边也有墙。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","驴看见耶和华的使者，就贴靠墙，将巴兰的脚挤伤了；巴兰又打驴。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","耶和华的使者又往前去，站在狭窄之处，左右都没有转折的地方。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","驴看见耶和华的使者，就卧在巴兰底下，巴兰发怒，用杖打驴。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","耶和华叫驴开口，对巴兰说：「我向你行了什么，你竟打我这三次呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","巴兰对驴说：「因为你戏弄我，我恨不能手中有刀，把你杀了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","驴对巴兰说：「我不是你从小时直到今日所骑的驴吗？我素常向你这样行过吗？」巴兰说：「没有。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","当时，耶和华使巴兰的眼目明亮，他就看见耶和华的使者站在路上，手里有拔出来的刀，巴兰便低头俯伏在地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","耶和华的使者对他说：「你为何这三次打你的驴呢？我出来敌挡你，因你所行的，在我面前偏僻。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","驴看见我就三次从我面前偏过去；驴若没有偏过去，我早把你杀了，留它存活。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","巴兰对耶和华的使者说：「我有罪了。我不知道你站在路上阻挡我；你若不喜欢我去，我就转回。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","耶和华的使者对巴兰说：「你同这些人去吧！你只要说我对你说的话。」于是巴兰同着巴勒的使臣去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","巴勒听见巴兰来了，就往摩押京城去迎接他；这城是在边界上，在亚嫩河旁。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","巴勒对巴兰说：「我不是急急地打发人到你那里去召你吗？你为何不到我这里来呢？我岂不能使你得尊荣吗？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","巴兰说：「我已经到你这里来了！现在我岂能擅自说什么呢？　神将什么话传给我，我就说什么。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","巴兰和巴勒同行，来到基列·胡琐。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","巴勒宰了牛羊，送给巴兰和陪伴的使臣。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","到了早晨，巴勒领巴兰到巴力的高处；巴兰从那里观看以色列营的边界。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","巴兰对巴勒说：「你在这里给我筑七座坛，为我预备七只公牛，七只公羊。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","巴勒照巴兰的话行了。巴勒和巴兰在每座坛上献一只公牛，一只公羊。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","巴兰对巴勒说：「你站在你的燔祭旁边，我且往前去，或者耶和华来迎见我。他指示我什么，我必告诉你。」于是巴兰上一净光的高处。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","神迎见巴兰；巴兰说：「我预备了七座坛，在每座坛上献了一只公牛，一只公羊。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","耶和华将话传给巴兰，又说：「你回到巴勒那里，要如此如此说。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","他就回到巴勒那里，见他同摩押的使臣都站在燔祭旁边。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","巴兰便题起诗歌说： 巴勒引我出亚兰， 摩押王引我出东山，说： 来啊，为我咒诅雅各； 来啊，怒骂以色列。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","神没有咒诅的，我焉能咒诅？ 耶和华没有怒骂的，我焉能怒骂？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","我从高峰看他，从小山望他； 这是独居的民，不列在万民中。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","谁能数点雅各的尘土？ 谁能计算以色列的四分之一？ 我愿如义人之死而死； 我愿如义人之终而终。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","巴勒对巴兰说：「你向我做的是什么事呢？我领你来咒诅我的仇敌，不料，你竟为他们祝福。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","他回答说：「耶和华传给我的话，我能不谨慎传说吗？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","巴勒说：「求你同我往别处去，在那里可以看见他们；你不能全看见，只能看见他们边界上的人。在那里要为我咒诅他们。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","于是领巴兰到了琐腓田，上了毗斯迦山顶，筑了七座坛；每座坛上献一只公牛，一只公羊。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","巴兰对巴勒说：「你站在这燔祭旁边，等我往那边去迎见耶和华。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","耶和华临到巴兰那里，将话传给他；又说：「你回到巴勒那里，要如此如此说。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","他就回到巴勒那里，见他站在燔祭旁边；摩押的使臣也和他在一处。巴勒问他说：「耶和华说了什么话呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","巴兰就题诗歌说： 巴勒，你起来听； 西拨的儿子，你听我言。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","神非人，必不致说谎， 也非人子，必不致后悔。 他说话岂不照着行呢？ 他发言岂不要成就呢？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","我奉命祝福； 　神也曾赐福，此事我不能翻转。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","他未见雅各中有罪孽， 也未见以色列中有奸恶。 耶和华—他的　神和他同在； 有欢呼王的声音在他们中间。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","神领他们出埃及； 他们似乎有野牛之力。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","断没有法术可以害雅各， 也没有占卜可以害以色列。 现在必有人论及雅各，就是论及以色列说： 　神为他行了何等的大事！ ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","这民起来，仿佛母狮， 挺身，好像公狮， 未曾吃野食， 未曾喝被伤者之血，决不躺卧。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","巴勒对巴兰说：「你一点不要咒诅他们，也不要为他们祝福。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","巴兰回答巴勒说：「我岂不是告诉你说『凡耶和华所说的，我必须遵行』吗？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","巴勒对巴兰说：「来吧，我领你往别处去，或者　神喜欢你在那里为我咒诅他们。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","巴勒就领巴兰到那下望旷野的毗珥山顶上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","巴兰对巴勒说：「你在这里为我筑七座坛，又在这里为我预备七只公牛，七只公羊。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","巴勒就照巴兰的话行，在每座坛上献一只公牛，一只公羊。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","巴兰见耶和华喜欢赐福与以色列，就不像前两次去求法术，却面向旷野。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","巴兰举目，看见以色列人照着支派居住。　神的灵就临到他身上， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","他便题起诗歌说： 比珥的儿子巴兰说， 眼目闭住的人说， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","得听　神的言语， 得见全能者的异象， 眼目睁开而仆倒的人说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","雅各啊，你的帐棚何等华美！ 以色列啊，你的帐幕何其华丽！ ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","如接连的山谷， 如河旁的园子， 如耶和华所栽的沉香树， 如水边的香柏木。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","水要从他的桶里流出； 种子要撒在多水之处。 他的王必超过亚甲； 他的国必要振兴。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","神领他出埃及； 他似乎有野牛之力。 他要吞吃敌国， 折断他们的骨头， 用箭射透他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","他蹲如公狮， 卧如母狮，谁敢惹他？ 凡给你祝福的，愿他蒙福； 凡咒诅你的，愿他受咒诅。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","巴勒向巴兰生气，就拍起手来，对巴兰说：「我召你来为我咒诅仇敌，不料，你这三次竟为他们祝福。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","如今你快回本地去吧！我想使你得大尊荣，耶和华却阻止你不得尊荣。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","巴兰对巴勒说：「我岂不是对你所差遣到我那里的使者说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","『巴勒就是将他满屋的金银给我，我也不得越过耶和华的命，凭自己的心意行好行歹。耶和华说什么，我就要说什么』？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","「现在我要回本族去。你来，我告诉你这民日后要怎样待你的民。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","他就题起诗歌说： 比珥的儿子巴兰说： 眼目闭住的人说， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","得听　神的言语， 明白至高者的意旨， 看见全能者的异象， 眼目睁开而仆倒的人说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","我看他却不在现时； 我望他却不在近日。 有星要出于雅各，有杖要兴于以色列， 必打破摩押的四角，毁坏扰乱之子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","他必得以东为基业， 又得仇敌之地西珥为产业； 以色列必行事勇敢。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","有一位出于雅各的，必掌大权； 他要除灭城中的余民。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","巴兰观看亚玛力，就题起诗歌说： 亚玛力原为诸国之首， 但他终必沉沦。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","巴兰观看基尼人，就题起诗歌说： 你的住处本是坚固； 你的窝巢做在岩穴中。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","然而基尼必至衰微， 直到亚述把你掳去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","巴兰又题起诗歌说： 哀哉！　神行这事，谁能得活？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","必有人乘船从基提界而来， 苦害亚述，苦害希伯； 他也必至沉沦。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","于是巴兰起来，回他本地去；巴勒也回去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","以色列人住在什亭，百姓与摩押女子行起淫乱。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","因为这女子叫百姓来，一同给她们的神献祭，百姓就吃她们的祭物，跪拜她们的神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","以色列人与巴力·毗珥连合，耶和华的怒气就向以色列人发作。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","耶和华吩咐摩西说：「将百姓中所有的族长在我面前对着日头悬挂，使我向以色列人所发的怒气可以消了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","于是摩西吩咐以色列的审判官说：「凡属你们的人，有与巴力·毗珥连合的，你们各人要把他们杀了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","摩西和以色列全会众正在会幕门前哭泣的时候，谁知，有以色列中的一个人，当他们眼前，带着一个米甸女人到他弟兄那里去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","祭司亚伦的孙子，以利亚撒的儿子非尼哈看见了，就从会中起来，手里拿着枪， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","跟随那以色列人进亭子里去，便将以色列人和那女人由腹中刺透。这样，在以色列人中瘟疫就止息了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","那时遭瘟疫死的，有二万四千人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","耶和华晓谕摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","「祭司亚伦的孙子，以利亚撒的儿子非尼哈，使我向以色列人所发的怒消了；因他在他们中间，以我的忌邪为心，使我不在忌邪中把他们除灭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","因此，你要说：『我将我平安的约赐给他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","这约要给他和他的后裔，作为永远当祭司职任的约；因他为　神有忌邪的心，为以色列人赎罪。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","那与米甸女人一同被杀的以色列人，名叫心利，是撒路的儿子，是西缅一个宗族的首领。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","那被杀的米甸女人，名叫哥斯比，是苏珥的女儿；这苏珥是米甸一个宗族的首领。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","耶和华晓谕摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","「你要扰害米甸人，击杀他们； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","因为他们用诡计扰害你们，在毗珥的事上和他们的姊妹、米甸首领的女儿哥斯比的事上，用这诡计诱惑了你们；这哥斯比，当瘟疫流行的日子，因毗珥的事被杀了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","瘟疫之后，耶和华晓谕摩西和祭司亚伦的儿子以利亚撒说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","「你们要将以色列全会众，按他们的宗族，凡以色列中从二十岁以外、能出去打仗的，计算总数。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","摩西和祭司以利亚撒在摩押平原与耶利哥相对的约旦河边向以色列人说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","「将你们中间从二十岁以外的计算总数」；是照耶和华吩咐出埃及地的摩西和以色列人的话。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","以色列的长子是吕便。吕便的众子：属哈诺的，有哈诺族；属法路的，有法路族； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","属希斯伦的，有希斯伦族；属迦米的，有迦米族； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","这就是吕便的各族；其中被数的，共有四万三千七百三十名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","法路的儿子是以利押。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","以利押的众子是尼母利、大坍、亚比兰。这大坍、亚比兰，就是从会中选召的，与可拉一党同向耶和华争闹的时候也向摩西、亚伦争闹； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","地便开口吞了他们，和可拉、可拉的党类一同死亡。那时火烧灭了二百五十个人；他们就作了警戒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","然而可拉的众子没有死亡。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","按着家族，西缅的众子：属尼母利的，有尼母利族；属雅悯的，有雅悯族；属雅斤的，有雅斤族； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","属谢拉的，有谢拉族；属扫罗的，有扫罗族。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","这就是西缅的各族，共有二万二千二百名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","按着家族，迦得的众子：属洗分的，有洗分族；属哈基的，有哈基族；属书尼的，有书尼族； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","属阿斯尼的，有阿斯尼族；属以利的，有以利族； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","属亚律的，有亚律族；属亚列利的，有亚列利族。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","这就是迦得子孙的各族，照他们中间被数的，共有四万零五百名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","犹大的儿子是珥和俄南。这珥和俄南死在迦南地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","按着家族，犹大其余的众子：属示拉的，有示拉族；属法勒斯的，有法勒斯族；属谢拉的有谢拉族。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","法勒斯的儿子：属希斯 的，有希斯 族；属哈母勒的，有哈母勒族。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","这就是犹大的各族，照他们中间被数的，共有七万六千五百名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","按着家族，以萨迦的众子：属陀拉的，有陀拉族；属普瓦的，有普瓦族； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","属雅述的，有雅述族；属伸 的，有伸 族。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","这就是以萨迦的各族，照他们中间被数的，共有六万四千三百名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","按着家族，西布伦的众子：属西烈的，有西烈族；属以伦的，有以伦族；属雅利的，有雅利族。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","这就是西布伦的各族，照他们中间被数的，共有六万零五百名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","按着家族，约瑟的儿子有玛拿西、以法莲。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","玛拿西的众子：属玛吉的，有玛吉族；玛吉生基列；属基列的，有基列族。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","基列的众子：属伊以谢的，有伊以谢族；属希勒的，有希勒族； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","属亚斯烈的，有亚斯烈族；属示剑的，有示剑族； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","属示米大的，有示米大族；属希弗的，有希弗族。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","希弗的儿子：西罗非哈没儿子，只有女儿。西罗非哈女儿的名字就是玛拉、挪阿、曷拉、密迦、得撒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","这就是玛拿西的各族；他们中间被数的，共有五万二千七百名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","按着家族，以法莲的众子：属书提拉的，有书提拉族；属比结的，有比结族；属他罕的，有他罕族。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","书提拉的众子：属以兰的，有以兰族。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","这就是以法莲子孙的各族，照他们中间被数的，共有三万二千五百名。按着家族，这都是约瑟的子孙。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","按着家族，便雅悯的众子：属比拉的，有比拉族；属亚实别的，有亚实别族；属亚希兰的，有亚希兰族； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","属书反的，有书反族；属户反的，有户反族。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","比拉的众子是亚勒、乃幔。属 亚勒 的，有亚勒族；属乃幔的，有乃幔族。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","按着家族，这就是便雅悯的子孙，其中被数的，共有四万五千六百名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","按着家族，但的众子：属书含的，有书含族。按着家族，这就是但的各族。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","照其中被数的，书含所有的各族，共有六万四千四百名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","按着家族，亚设的众子：属音拿的，有音拿族；属亦施韦的，有亦施韦族；属比利亚的，有比利亚族。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","比利亚的众子：属希别的，有希别族；属玛结的，有玛结族。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","亚设的女儿名叫西拉。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","这就是亚设子孙的各族，照他们中间被数的，共有五万三千四百名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","按着家族，拿弗他利的众子：属雅薛的，有雅薛族；属沽尼的，有沽尼族； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","属耶色的，有耶色族；属示冷的，有示冷族。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","按着家族，这就是拿弗他利的各族；他们中间被数的，共有四万五千四百名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","以色列人中被数的，共有六十万零一千七百三十名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","耶和华晓谕摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","「你要按着人名的数目将地分给这些人为业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","人多的，你要把产业多分给他们；人少的，你要把产业少分给他们；要照被数的人数，把产业分给各人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","虽是这样，还要拈阄分地。他们要按着祖宗各支派的名字承受为业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","要按着所拈的阄，看人数多，人数少，把产业分给他们。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","利未人，按着他们的各族被数的：属革顺的，有革顺族；属哥辖的，有哥辖族；属米拉利的，有米拉利族。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","利未的各族有立尼族、希伯伦族、玛利族、母示族、可拉族。哥辖生暗兰。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","暗兰的妻名叫约基别，是利未女子，生在埃及。她给暗兰生了亚伦、摩西，并他们的姊姊米利暗。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","亚伦生拿答、亚比户、以利亚撒、以他玛。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","拿答、亚比户在耶和华面前献凡火的时候就死了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","利未人中，凡一个月以外、被数的男丁，共有二万三千。他们本来没有数在以色列人中；因为在以色列人中，没有分给他们产业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","这些就是被摩西和祭司以利亚撒所数的；他们在摩押平原与耶利哥相对的约旦河边数点以色列人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","但被数的人中，没有一个是摩西和祭司亚伦从前在西奈的旷野所数的以色列人， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","因为耶和华论到他们说：「他们必要死在旷野。」所以，除了耶孚尼的儿子迦勒和嫩的儿子约书亚以外，连一个人也没有存留。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","属约瑟的儿子玛拿西的各族，有玛拿西的玄孙，玛吉的曾孙，基列的孙子，希弗的儿子西罗非哈的女儿，名叫玛拉、挪阿、曷拉、密迦、得撒。她们前来， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","站在会幕门口，在摩西和祭司以利亚撒，并众首领与全会众面前，说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","「我们的父亲死在旷野。他不与可拉同党聚集攻击耶和华，是在自己罪中死的；他也没有儿子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","为什么因我们的父亲没有儿子就把他的名从他族中除掉呢？求你们在我们父亲的弟兄中分给我们产业。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","于是，摩西将她们的案件呈到耶和华面前。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","耶和华晓谕摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","「西罗非哈的女儿说得有理。你定要在她们父亲的弟兄中，把地分给她们为业；要将她们父亲的产业归给她们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","你也要晓谕以色列人说：『人若死了没有儿子，就要把他的产业归给他的女儿。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","他若没有女儿，就要把他的产业给他的弟兄。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","他若没有弟兄，就要把他的产业给他父亲的弟兄。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","他父亲若没有弟兄，就要把他的产业给他族中最近的亲属，他便要得为业。』这要作以色列人的律例典章，是照耶和华吩咐摩西的。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","耶和华对摩西说：「你上这亚巴琳山，观看我所赐给以色列人的地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","看了以后，你也必归到你列祖那里，像你哥哥亚伦一样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","因为你们在寻的旷野，当会众争闹的时候，违背了我的命，没有在涌水之地、会众眼前尊我为圣。」（这水就是寻的旷野加低斯米利巴水。） ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","摩西对耶和华说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","「愿耶和华万人之灵的　神，立一个人治理会众， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","可以在他们面前出入，也可以引导他们，免得耶和华的会众如同没有牧人的羊群一般。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","耶和华对摩西说：「嫩的儿子约书亚是心中有圣灵的；你将他领来，按手在他头上， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","使他站在祭司以利亚撒和全会众面前，嘱咐他， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","又将你的尊荣给他几分，使以色列全会众都听从他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","他要站在祭司以利亚撒面前；以利亚撒要凭乌陵的判断，在耶和华面前为他求问。他和以色列全会众都要遵以利亚撒的命出入。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","于是摩西照耶和华所吩咐的将约书亚领来，使他站在祭司以利亚撒和全会众面前， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","按手在他头上，嘱咐他，是照耶和华借摩西所说的话。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","耶和华晓谕摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","「你要吩咐以色列人说：『献给我的供物，就是献给我作馨香火祭的食物，你们要按日期献给我』； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","又要对他们说：你们要献给耶和华的火祭，就是没有残疾、一岁的公羊羔，每日两只，作为常献的燔祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","早晨要献一只，黄昏的时候要献一只； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","又用细面伊法十分之一，并捣成的油一欣四分之一，调和作为素祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","这是西奈山所命定为常献的燔祭，是献给耶和华为馨香的火祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","为这一只羊羔，要同献奠祭的酒一欣四分之一。在圣所中，你要将醇酒奉给耶和华为奠祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","晚上，你要献那一只羊羔，必照早晨的素祭和同献的奠祭献上，作为馨香的火祭，献给耶和华。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","「当安息日，要献两只没有残疾、一岁的公羊羔，并用调油的细面伊法十分之二为素祭，又将同献的奠祭献上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","这是每安息日献的燔祭；那常献的燔祭和同献的奠祭在外。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","「每月朔，你们要将两只公牛犊，一只公绵羊，七只没有残疾、一岁的公羊羔，献给耶和华为燔祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","每只公牛要用调油的细面伊法十分之三作为素祭；那只公羊也用调油的细面伊法十分之二作为素祭； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","每只羊羔要用调油的细面伊法十分之一作为素祭和馨香的燔祭，是献给耶和华的火祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","一只公牛要奠酒半欣，一只公羊要奠酒一欣三分之一，一只羊羔也奠酒一欣四分之一。这是每月的燔祭，一年之中要月月如此。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","又要将一只公山羊为赎罪祭，献给耶和华；要献在常献的燔祭和同献的奠祭以外。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","「正月十四日是耶和华的逾越节。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","这月十五日是节期，要吃无酵饼七日。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","第一日当有圣会；什么劳碌的工都不可做。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","当将公牛犊两只，公绵羊一只，一岁的公羊羔七只，都要没有残疾的，用火献给耶和华为燔祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","同献的素祭用调油的细面；为一只公牛要献伊法十分之三；为一只公羊要献伊法十分之二； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","为那七只羊羔，每只要献伊法十分之一。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","并献一只公山羊作赎罪祭，为你们赎罪。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","你们献这些，要在早晨常献的燔祭以外。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","一连七日，每日要照这例把馨香火祭的食物献给耶和华，是在常献的燔祭和同献的奠祭以外。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","第七日当有圣会，什么劳碌的工都不可做。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","「七七节庄稼初熟，你们献新素祭给耶和华的日子，当有圣会；什么劳碌的工都不可做。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","只要将公牛犊两只，公绵羊一只，一岁的公羊羔七只，作为馨香的燔祭献给耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","同献的素祭用调油的细面；为每只公牛要献伊法十分之三；为一只公羊要献伊法十分之二； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","为那七只羊羔，每只要献伊法十分之一。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","并献一只公山羊为你们赎罪。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","这些，你们要献在常献的燔祭和同献的素祭并同献的奠祭以外，都要没有残疾的。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","「七月初一日，你们当有圣会；什么劳碌的工都不可做，是你们当守为吹角的日子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","你们要将公牛犊一只，公绵羊一只，没有残疾、一岁的公羊羔七只，作为馨香的燔祭献给耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","同献的素祭用调油的细面；为一只公牛要献伊法十分之三；为一只公羊要献伊法十分之二； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","为那七只羊羔，每只要献伊法十分之一。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","又献一只公山羊作赎罪祭，为你们赎罪。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","这些是在月朔的燔祭和同献的素祭，并常献的燔祭与同献的素祭，以及照例同献的奠祭以外，都作为馨香的火祭献给耶和华。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","「七月初十日，你们当有圣会；要刻苦己心，什么工都不可做。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","只要将公牛犊一只，公绵羊一只，一岁的公羊羔七只，都要没有残疾的，作为馨香的燔祭献给耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","同献的素祭用调油的细面：为一只公牛要献伊法十分之三；为一只公羊要献伊法十分之二； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","为那七只羊羔，每只要献伊法十分之一。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","又献一只公山羊为赎罪祭。这是在赎罪祭和常献的燔祭，与同献的素祭并同献的奠祭以外。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","「七月十五日，你们当有圣会；什么劳碌的工都不可做，要向耶和华守节七日。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","又要将公牛犊十三只，公绵羊两只，一岁的公羊羔十四只，都要没有残疾的，用火献给耶和华为馨香的燔祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","同献的素祭用调油的细面；为那十三只公牛，每只要献伊法十分之三；为那两只公羊，每只要献伊法十分之二； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","为那十四只羊羔，每只要献伊法十分之一。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","并献一只公山羊为赎罪祭，这是在常献的燔祭和同献的素祭并同献的奠祭以外。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","「第二日要献公牛犊十二只，公绵羊两只，没有残疾、一岁的公羊羔十四只； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","并为公牛、公羊，和羊羔，按数照例，献同献的素祭和同献的奠祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","又要献一只公山羊为赎罪祭。这是在常献的燔祭和同献的素祭并同献的奠祭以外。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","「第三日要献公牛十一只，公羊两只，没有残疾、一岁的公羊羔十四只； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","并为公牛、公羊，和羊羔，按数照例，献同献的素祭和同献的奠祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","又要献一只公山羊为赎罪祭。这是在常献的燔祭和同献的素祭并同献的奠祭以外。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","「第四日要献公牛十只，公羊两只，没有残疾、一岁的公羊羔十四只； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","并为公牛、公羊，和羊羔，按数照例，献同献的素祭和同献的奠祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","又要献一只公山羊为赎罪祭。这是在常献的燔祭和同献的素祭并同献的奠祭以外。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","「第五日要献公牛九只，公羊两只，没有残疾、一岁的公羊羔十四只； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","并为公牛、公羊，和羊羔，按数照例，献同献的素祭和同献的奠祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","又要献一只公山羊为赎罪祭。这是在常献的燔祭和同献的素祭并同献的奠祭以外。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","「第六日要献公牛八只，公羊两只，没有残疾、一岁的公羊羔十四只； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","并为公牛、公羊，和羊羔，按数照例，献同献的素祭和同献的奠祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","又要献一只公山羊为赎罪祭。这是在常献的燔祭和同献的素祭并同献的奠祭以外。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","「第七日要献公牛七只，公羊两只，没有残疾、一岁的公羊羔十四只； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","并为公牛、公羊，和羊羔，按数照例，献同献的素祭和同献的奠祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","又要献一只公山羊为赎罪祭。这是在常献的燔祭和同献的素祭并同献的奠祭以外。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","「第八日你们当有严肃会；什么劳碌的工都不可做； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","只要将公牛一只，公羊一只，没有残疾、一岁的公羊羔七只作火祭，献给耶和华为馨香的燔祭； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","并为公牛、公羊，和羊羔，按数照例，献同献的素祭和同献的奠祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","又要献一只公山羊为赎罪祭。这是在常献的燔祭和同献的素祭并同献的奠祭以外。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","「这些祭要在你们的节期献给耶和华，都在所许的愿并甘心所献的以外，作为你们的燔祭、素祭、奠祭，和平安祭。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","于是，摩西照耶和华所吩咐他的一切话告诉以色列人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","摩西晓谕以色列各支派的首领说：「耶和华所吩咐的乃是这样： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","人若向耶和华许愿或起誓，要约束自己，就不可食言，必要按口中所出的一切话行。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","女子年幼、还在父家的时候，若向耶和华许愿，要约束自己， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","她父亲也听见她所许的愿并约束自己的话，却向她默默不言，她所许的愿并约束自己的话就都要为定。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","但她父亲听见的日子若不应承她所许的愿和约束自己的话，就都不得为定；耶和华也必赦免她，因为她父亲不应承。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","她若出了嫁，有愿在身，或是口中出了约束自己的冒失话， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","她丈夫听见的日子，却向她默默不言，她所许的愿并约束自己的话就都要为定。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","但她丈夫听见的日子，若不应承，就算废了她所许的愿和她出口约束自己的冒失话；耶和华也必赦免她。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","寡妇或是被休的妇人所许的愿，就是她约束自己的话，都要为定。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","她若在丈夫家里许了愿或起了誓，约束自己， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","丈夫听见，却向她默默不言，也没有不应承，她所许的愿并约束自己的话就都要为定。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","丈夫听见的日子，若把这两样全废了，妇人口中所许的愿或是约束自己的话就都不得为定，因她丈夫已经把这两样废了；耶和华也必赦免她。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","凡她所许的愿和刻苦约束自己所起的誓，她丈夫可以坚定，也可以废去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","倘若她丈夫天天向她默默不言，就算是坚定她所许的愿和约束自己的话；因丈夫听见的日子向她默默不言，就使这两样坚定。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","但她丈夫听见以后，若使这两样全废了，就要担当妇人的罪孽。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","这是丈夫待妻子，父亲待女儿，女儿年幼、还在父家，耶和华所吩咐摩西的律例。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","耶和华吩咐摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","「你要在米甸人身上报以色列人的仇，后来要归到你列祖那里。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","摩西吩咐百姓说：「要从你们中间叫人带兵器出去攻击米甸，好在米甸人身上为耶和华报仇。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","从以色列众支派中，每支派要打发一千人去打仗。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","于是从以色列千万人中，每支派交出一千人，共一万二千人，带着兵器预备打仗。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","摩西就打发每支派的一千人去打仗，并打发祭司以利亚撒的儿子非尼哈同去；非尼哈手里拿着圣所的器皿和吹大声的号筒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","他们就照耶和华所吩咐摩西的，与米甸人打仗，杀了所有的男丁。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","在所杀的人中，杀了米甸的五王，就是以未、利金、苏珥、户珥、利巴，又用刀杀了比珥的儿子巴兰。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","以色列人掳了米甸人的妇女孩子，并将他们的牲畜、羊群，和所有的财物都夺了来，当作掳物， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","又用火焚烧他们所住的城邑和所有的营寨， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","把一切所夺的、所掳的，连人带牲畜都带了去， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","将所掳的人，所夺的牲畜、财物，都带到摩押平原，在约旦河边与耶利哥相对的营盘，交给摩西和祭司以利亚撒，并以色列的会众。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","摩西和祭司以利亚撒，并会众一切的首领，都出到营外迎接他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","摩西向打仗回来的军长，就是千夫长、百夫长，发怒， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","对他们说：「你们要存留这一切妇女的活命吗？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","这些妇女因巴兰的计谋，叫以色列人在毗珥的事上得罪耶和华，以致耶和华的会众遭遇瘟疫。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","所以，你们要把一切的男孩和所有已嫁的女子都杀了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","但女孩子中，凡没有出嫁的，你们都可以存留她的活命。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","你们要在营外驻扎七日；凡杀了人的，和一切摸了被杀的，并你们所掳来的人口，第三日，第七日，都要洁净自己， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","也要因一切的衣服、皮物、山羊毛织的物，和各样的木器，洁净自己。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","祭司以利亚撒对打仗回来的兵丁说：「耶和华所吩咐摩西律法中的条例乃是这样： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","金、银、铜、铁、锡、铅， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","凡能见火的，你们要叫它经火就为洁净，然而还要用除污秽的水洁净它；凡不能见火的，你们要叫它过水。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","第七日，你们要洗衣服，就为洁净，然后可以进营。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","耶和华晓谕摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","「你和祭司以利亚撒，并会众的各族长，要计算所掳来的人口和牲畜的总数。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","把所掳来的分作两半：一半归与出去打仗的精兵，一半归与全会众。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","又要从出去打仗所得的人口、牛、驴、羊群中，每五百取一，作为贡物奉给耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","从他们一半之中，要取出来交给祭司以利亚撒，作为耶和华的举祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","从以色列人的一半之中，就是从人口、牛、驴、羊群、各样牲畜中，每五十取一，交给看守耶和华帐幕的利未人。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","于是摩西和祭司以利亚撒照耶和华所吩咐摩西的行了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","除了兵丁所夺的财物以外，所掳来的：羊六十七万五千只； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","牛七万二千只； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","驴六万一千匹； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","女人共三万二千口，都是没有出嫁的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","出去打仗之人的分，就是他们所得的那一半，共计羊三十三万七千五百只， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","从其中归耶和华为贡物的，有六百七十五只； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","牛三万六千只，从其中归耶和华为贡物的，有七十二只； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","驴三万零五百匹，从其中归耶和华为贡物的，有六十一匹； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","人一万六千口，从其中归耶和华的，有三十二口。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","摩西把贡物，就是归与耶和华的举祭，交给祭司以利亚撒，是照耶和华所吩咐摩西的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","以色列人所得的那一半，就是摩西从打仗的人取来分给他们的。（ ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","会众的那一半有：羊三十三万七千五百只； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","牛三万六千只； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","驴三万零五百匹； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","人一万六千口。） ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","无论是人口是牲畜，摩西每五十取一，交给看守耶和华帐幕的利未人，是照耶和华所吩咐摩西的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","带领千军的各军长，就是千夫长、百夫长，都近前来见摩西， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","对他说：「仆人权下的兵已经计算总数，并不短少一人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","如今我们将各人所得的金器，就是脚链子、镯子、打印的戒指、耳环、手钏，都送来为耶和华的供物，好在耶和华面前为我们的生命赎罪。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","摩西和祭司以利亚撒就收了他们的金子，都是打成的器皿。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","千夫长、百夫长所献给耶和华为举祭的金子共有一万六千七百五十舍客勒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","各兵丁都为自己夺了财物。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","摩西和祭司以利亚撒收了千夫长、百夫长的金子，就带进会幕，在耶和华面前作为以色列人的纪念。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","吕便子孙和迦得子孙的牲畜极其众多；他们看见雅谢地和基列地是可牧放牲畜之地， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","就来见摩西和祭司以利亚撒，并会众的首领，说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","「亚大录、底本、雅谢、宁拉、希实本、以利亚利、示班、尼波、比稳， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","就是耶和华在以色列会众前面所攻取之地，是可牧放牲畜之地，你仆人也有牲畜」； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","又说：「我们若在你眼前蒙恩，求你把这地给我们为业，不要领我们过约旦河。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","摩西对迦得子孙和吕便子孙说：「难道你们的弟兄去打仗，你们竟坐在这里吗？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","你们为何使以色列人灰心丧胆、不过去进入耶和华所赐给他们的那地呢？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","我先前从加低斯·巴尼亚打发你们先祖去窥探那地，他们也是这样行。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","他们上以实各谷，去窥探那地回来的时候，使以色列人灰心丧胆，不进入耶和华所赐给他们的地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","当日，耶和华的怒气发作，就起誓说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","『凡从埃及上来、二十岁以外的人断不得看见我对亚伯拉罕、以撒、雅各起誓应许之地，因为他们没有专心跟从我。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","惟有基尼洗族耶孚尼的儿子迦勒和嫩的儿子约书亚可以看见，因为他们专心跟从我。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","耶和华的怒气向以色列人发作，使他们在旷野飘流四十年，等到在耶和华眼前行恶的那一代人都消灭了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","谁知，你们起来接续先祖，增添罪人的数目，使耶和华向以色列大发烈怒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","你们若退后不跟从他，他还要把以色列人撇在旷野，便是你们使这众民灭亡。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","两支派的人挨近摩西，说：「我们要在这里为牲畜垒圈，为妇人孩子造城。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","我们自己要带兵器行在以色列人的前头，好把他们领到他们的地方；但我们的妇人孩子，因这地居民的缘故，要住在坚固的城内。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","我们不回家，直等到以色列人各承受自己的产业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","我们不和他们在约旦河那边一带之地同受产业，因为我们的产业是坐落在约旦河东边这里。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","摩西对他们说：「你们若这样行，在耶和华面前带着兵器出去打仗， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","所有带兵器的人都要在耶和华面前过约旦河，等他赶出他的仇敌， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","那地被耶和华制伏了，然后你们可以回来，向耶和华和以色列才为无罪，这地也必在耶和华面前归你们为业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","倘若你们不这样行，就得罪耶和华，要知道你们的罪必追上你们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","如今你们口中所出的，只管去行，为你们的妇人孩子造城，为你们的羊群垒圈。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","迦得子孙和吕便子孙对摩西说：「仆人要照我主所吩咐的去行。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","我们的妻子、孩子、羊群，和所有的牲畜都要留在基列的各城。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","但你的仆人，凡带兵器的，都要照我主所说的话，在耶和华面前过去打仗。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","于是，摩西为他们嘱咐祭司以利亚撒和嫩的儿子约书亚，并以色列众支派的族长，说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","「迦得子孙和吕便子孙，凡带兵器在耶和华面前去打仗的，若与你们一同过约旦河，那地被你们制伏了，你们就要把基列地给他们为业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","倘若他们不带兵器和你们一同过去，就要在迦南地你们中间得产业。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","迦得子孙和吕便子孙回答说：「耶和华怎样吩咐仆人，仆人就怎样行。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","我们要带兵器，在耶和华面前过去，进入迦南地，只是约旦河这边、我们所得为业之地仍归我们。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","摩西将亚摩利王西宏的国和巴珊王噩的国，连那地和周围的城邑，都给了迦得子孙和吕便子孙，并约瑟的儿子玛拿西半个支派。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","迦得子孙建造底本、亚他录、亚罗珥、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","亚他录·朔反、雅谢、约比哈、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","伯·宁拉、伯·哈兰，都是坚固城。他们又垒羊圈。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","吕便子孙建造希实本、以利亚利、基列亭、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","尼波、巴力·免、西比玛（尼波、巴力·免，名字是改了的），又给他们所建造的城另起别名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","玛拿西的儿子玛吉，他的子孙往基列去，占了那地，赶出那里的亚摩利人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","摩西将基列赐给玛拿西的儿子玛吉，他子孙就住在那里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","玛拿西的子孙睚珥去占了基列的村庄，就称这些村庄为哈倭特·睚珥。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","挪巴去占了基纳和基纳的乡村，就按自己的名称基纳为挪巴。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","以色列人按着军队，在摩西、亚伦的手下出埃及地所行的路程记在下面。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","摩西遵着耶和华的吩咐记载他们所行的路程，其路程乃是这样： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","正月十五日，就是逾越节的次日，以色列人从兰塞起行，在一切埃及人眼前昂然无惧地出去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","那时，埃及人正葬埋他们的长子，就是耶和华在他们中间所击杀的；耶和华也败坏他们的神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","以色列人从兰塞起行，安营在疏割。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","从疏割起行，安营在旷野边的以倘。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","从以倘起行，转到比哈·希录，是在巴力·洗分对面，就在密夺安营。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","从比哈·希录对面起行，经过海中到了书珥旷野，又在伊坦的旷野走了三天的路程，就安营在玛拉。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","从玛拉起行，来到以琳（以琳有十二股水泉，七十棵棕树），就在那里安营。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","从以琳起行，安营在红海边。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","从红海边起行，安营在汛的旷野。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","从汛的旷野起行，安营在脱加。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","从脱加起行，安营在亚录。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","从亚录起行，安营在利非订；在那里，百姓没有水喝。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","从利非订起行，安营在西奈的旷野。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","从西奈的旷野起行，安营在基博罗·哈他瓦。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","从基博罗·哈他瓦起行，安营在哈洗录。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","从哈洗录起行，安营在利提玛。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","从利提玛起行，安营在临门·帕烈。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","从临门·帕烈起行，安营在立拿。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","从立拿起行，安营在勒撒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","从勒撒起行，安营在基希拉他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","从基希拉他起行，安营在沙斐山。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","从沙斐山起行，安营在哈拉大。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","从哈拉大起行，安营在玛吉希录。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","从玛吉希录起行，安营在他哈。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","从他哈起行，安营在他拉。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","从他拉起行，安营在密加。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","从密加起行，安营在哈摩拿。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","从哈摩拿起行，安营在摩西录。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","从摩西录起行，安营在比尼·亚干。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","从比尼·亚干起行，安营在曷·哈及甲。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","从曷·哈及甲起行，安营在约巴他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","从约巴他起行，安营在阿博拿。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","从阿博拿起行，安营在以旬·迦别。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","从以旬·迦别起行，安营在寻的旷野，就是加低斯。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","从加低斯起行，安营在何珥山，以东地的边界。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","以色列人出了埃及地后四十年，五月初一日，祭司亚伦遵着耶和华的吩咐上何珥山，就死在那里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","亚伦死在何珥山的时候年一百二十三岁。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","住在迦南南地的迦南人亚拉得王听说以色列人来了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","以色列人从何珥山起行，安营在撒摩拿。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","从撒摩拿起行，安营在普嫩。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","从普嫩起行，安营在阿伯。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","从阿伯起行，安营在以耶·亚巴琳，摩押的边界。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","从以耶·亚巴琳起行，安营在底本·迦得。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","从底本·迦得起行，安营在亚门·低比拉太音。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","从亚门·低比拉太音起行，安营在尼波对面的亚巴琳山里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","从亚巴琳山起行，安营在摩押平原—约旦河边、耶利哥对面。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","他们在摩押平原沿约旦河边安营，从伯·耶施末直到亚伯·什亭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","耶和华在摩押平原—约旦河边、耶利哥对面晓谕摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","「你吩咐以色列人说：你们过约旦河进迦南地的时候， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","就要从你们面前赶出那里所有的居民，毁灭他们一切錾成的石像和他们一切铸成的偶像，又拆毁他们一切的邱坛。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","你们要夺那地，住在其中，因我把那地赐给你们为业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","你们要按家室拈阄，承受那地；人多的，要把产业多分给他们；人少的，要把产业少分给他们。拈出何地给何人，就要归何人。你们要按宗族的支派承受。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","倘若你们不赶出那地的居民，所容留的居民就必作你们眼中的刺，肋下的荆棘，也必在你们所住的地上扰害你们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","而且我素常有意怎样待他们，也必照样待你们。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","耶和华晓谕摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","「你吩咐以色列人说：你们到了迦南地，就是归你们为业的迦南四境之地， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","南角要从寻的旷野，贴着以东的边界；南界要从盐海东头起， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","绕到亚克拉滨坡的南边，接连到寻，直通到加低斯·巴尼亚的南边，又通到哈萨·亚达，接连到押们， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","从押们转到埃及小河，直通到海为止。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","「西边要以大海为界；这就是你们的西界。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","「北界要从大海起，划到何珥山， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","从何珥山划到哈马口，通到西达达， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","又通到西斐 ，直到哈萨·以难。这要作你们的北界。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","「你们要从哈萨·以难划到示番为东界。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","这界要从示番下到亚延东边的利比拉，又要达到基尼烈湖的东边。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","这界要下到约旦河，通到盐海为止。这四围的边界以内，要作你们的地。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","摩西吩咐以色列人说：「这地就是耶和华吩咐拈阄给九个半支派承受为业的； ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","因为吕便支派和迦得支派按着宗族受了产业，玛拿西半个支派也受了产业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","这两个半支派已经在耶利哥对面、约旦河东、向日出之地受了产业。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","耶和华晓谕摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","「要给你们分地为业之人的名字是祭司以利亚撒和嫩的儿子约书亚。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","又要从每支派中选一个首领帮助他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","这些人的名字：犹大支派有耶孚尼的儿子迦勒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","西缅支派有亚米忽的儿子示母利。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","便雅悯支派有基斯伦的儿子以利达。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","但支派有一个首领，约利的儿子布基。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","约瑟的子孙玛拿西支派有一个首领，以弗的儿子汉聂。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","以法莲支派有一个首领，拾弗但的儿子基母利。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","西布伦支派有一个首领，帕纳的儿子以利撒番。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","以萨迦支派有一个首领，阿散的儿子帕铁。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","亚设支派有一个首领，示罗米的儿子亚希忽。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","拿弗他利支派有一个首领，亚米忽的儿子比大黑。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","这些人就是耶和华所吩咐、在迦南地把产业分给以色列人的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","耶和华在摩押平原—约旦河边、耶利哥对面晓谕摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","「你吩咐以色列人，要从所得为业的地中把些城给利未人居住，也要把这城四围的郊野给利未人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","这城邑要归他们居住，城邑的郊野可以牧养他们的牛羊和各样的牲畜，又可以安置他们的财物。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","你们给利未人的郊野，要从城根起，四围往外量一千肘。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","另外东量二千肘，南量二千肘，西量二千肘，北量二千肘，为边界，城在当中；这要归他们作城邑的郊野。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","你们给利未人的城邑，其中当有六座逃城，使误杀人的可以逃到那里。此外还要给他们四十二座城。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","你们要给利未人的城，共有四十八座，连城带郊野都要给他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","以色列人所得的地业从中要把些城邑给利未 人；人多的就多给，人少的就少给；各支派要按所承受为业之地把城邑给利未人。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","耶和华晓谕摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","「你吩咐以色列人说：你们过约旦河，进了迦南地， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","就要分出几座城，为你们作逃城，使误杀人的可以逃到那里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","这些城可以作逃避报仇人的城，使误杀人的不至于死，等他站在会众面前听审判。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","你们所分出来的城，要作六座逃城。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","在约旦河东要分出三座城，在迦南地也要分出三座城，都作逃城。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","这六座城要给以色列人和他们中间的外人，并寄居的，作为逃城，使误杀人的都可以逃到那里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","「倘若人用铁器打人，以致打死，他就是故杀人的；故杀人的必被治死。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","若用可以打死人的石头打死了人，他就是故杀人的；故杀人的必被治死。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","若用可以打死人的木器打死了人，他就是故杀人的；故杀人的必被治死。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","报血仇的必亲自杀那故杀人的，一遇见就杀他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","人若因怨恨把人推倒，或是埋伏往人身上扔物，以致于死， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","或是因仇恨用手打人，以致于死，那打人的必被治死。他是故杀人的；报血仇的一遇见就杀他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","「倘若人没有仇恨，忽然将人推倒，或是没有埋伏把物扔在人身上， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","或是没有看见的时候用可以打死人的石头扔在人身上，以致于死，本来与他无仇，也无意害他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","会众就要照典章，在打死人的和报血仇的中间审判。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","会众要救这误杀人的脱离报血仇人的手，也要使他归入逃城。他要住在其中，直等到受圣膏的大祭司死了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","但误杀人的，无论什么时候，若出了逃城的境外， ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","报血仇的在逃城境外遇见他，将他杀了，报血仇的就没有流血之罪。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","因为误杀人的该住在逃城里，等到大祭司死了。大祭司死了以后，误杀人的才可以回到他所得为业之地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","这在你们一切的住处，要作你们世世代代的律例典章。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","「无论谁故杀人，要凭几个见证人的口把那故杀人的杀了，只是不可凭一个见证的口叫人死。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","故杀人、犯死罪的，你们不可收赎价代替他的命；他必被治死。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","那逃到逃城的人，你们不可为他收赎价，使他在大祭司未死以先再来住在本地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","这样，你们就不污秽所住之地，因为血是污秽地的；若有在地上流人血的，非流那杀人者的血，那地就不得洁净。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","你们不可玷污所住之地，就是我住在其中之地，因为我—耶和华住在以色列人中间。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","约瑟的后裔，玛拿西的孙子，玛吉的儿子基列，他子孙中的诸族长来到摩西和作首领的以色列人族长面前，说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","「耶和华曾吩咐我主拈阄分地给以色列人为业，我主也受了耶和华的吩咐将我们兄弟西罗非哈的产业分给他的众女儿。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","她们若嫁以色列别支派的人，就必将我们祖宗所遗留的产业加在她们丈夫支派的产业中。这样，我们拈阄所得的产业就要减少了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","到了以色列人的禧年，这女儿的产业就必加在她们丈夫支派的产业上。这样，我们祖宗支派的产业就减少了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","摩西照耶和华的话吩咐以色列人说：「约瑟支派的人说得有理。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","论到西罗非哈的众女儿，耶和华这样吩咐说：她们可以随意嫁人，只是要嫁同宗支派的人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","这样，以色列人的产业就不从这支派归到那支派，因为以色列人要各守各祖宗支派的产业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","凡在以色列支派中得了产业的女子必作同宗支派人的妻，好叫以色列人各自承受他祖宗的产业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","这样，他们的产业就不从这支派归到那支派，因为以色列支派的人要各守各的产业。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","耶和华怎样吩咐摩西，西罗非哈的众女儿就怎样行。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","西罗非哈的女儿玛拉、得撒、曷拉、密迦、挪阿都嫁了他们伯叔的儿子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","她们嫁入约瑟儿子、玛拿西子孙的族中；她们的产业仍留在同宗支派中。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","这是耶和华在摩押平原—约旦河边、耶利哥对面—借着摩西所吩咐以色列人的命令典章。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","以下所记的是摩西在约旦河东的旷野、疏弗对面的亚拉巴—就是巴兰、陀弗、拉班、哈洗录、底撒哈中间—向以色列众人所说的话。（ ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","从何烈山经过西珥山到加低斯·巴尼亚有十一天的路程。） ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","出埃及第四十年十一月初一日，摩西照耶和华借着他所吩咐以色列人的话都晓谕他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","那时，他已经击杀了住希实本的亚摩利王西宏和住以得来、亚斯他录的巴珊王噩。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","摩西在约旦河东的摩押地讲律法说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","「耶和华—我们的　神在何烈山晓谕我们说：你们在这山上住的日子够了； ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","要起行转到亚摩利人的山地和靠近这山地的各处，就是亚拉巴、山地、高原、南地，沿海一带迦南人的地，并黎巴嫩山又到幼发拉底大河。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","如今我将这地摆在你们面前；你们要进去得这地，就是耶和华向你们列祖亚伯拉罕、以撒、雅各起誓应许赐给他们和他们后裔为业之地。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","「那时，我对你们说：『管理你们的重任，我独自担当不起。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","耶和华—你们的　神使你们多起来。看哪，你们今日像天上的星那样多。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","惟愿耶和华—你们列祖的　神使你们比如今更多千倍，照他所应许你们的话赐福与你们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","但你们的麻烦，和管理你们的重任，并你们的争讼，我独自一人怎能担当得起呢？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","你们要按着各支派选举有智慧、有见识、为众人所认识的，我立他们为你们的首领。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","你们回答我说：『照你所说的行了为妙。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","我便将你们各支派的首领，有智慧、为众人所认识的，照你们的支派，立他们为官长、千夫长、百夫长、五十夫长、十夫长，管理你们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","「当时，我嘱咐你们的审判官说：『你们听讼，无论是弟兄彼此争讼，是与同居的外人争讼，都要按公义判断。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","审判的时候，不可看人的外貌；听讼不可分贵贱，不可惧怕人，因为审判是属乎　神的。若有难断的案件，可以呈到我这里，我就判断。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","那时，我将你们所当行的事都吩咐你们了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","「我们照着耶和华—我们　神所吩咐的从何烈山起行，经过你们所看见那大而可怕的旷野，往亚摩利人的山地去，到了加低斯·巴尼亚。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","我对你们说：『你们已经到了耶和华—我们　神所赐给我们的亚摩利人之山地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","看哪，耶和华—你的　神已将那地摆在你面前，你要照耶和华—你列祖的　神所说的上去得那地为业；不要惧怕，也不要惊惶。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","你们都就近我来说：『我们要先打发人去，为我们窥探那地，将我们上去该走何道，必进何城，都回报我们。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","这话我以为美，就从你们中间选了十二个人，每支派一人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","于是他们起身上山地去，到以实各谷，窥探那地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","他们手里拿着那地的果子下来，到我们那里，回报说：『耶和华—我们的　神所赐给我们的是美地。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","「你们却不肯上去，竟违背了耶和华—你们　神的命令， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","在帐棚内发怨言说：『耶和华因为恨我们，所以将我们从埃及地领出来，要交在亚摩利人手中，除灭我们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","我们上哪里去呢？我们的弟兄使我们的心消化，说那地的民比我们又大又高，城邑又广大又坚固，高得顶天，并且我们在那里看见亚衲族的人。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","我就对你们说：『不要惊恐，也不要怕他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","在你们前面行的耶和华—你们的　神必为你们争战，正如他在埃及和旷野，在你们眼前所行的一样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","你们在旷野所行的路上，也曾见耶和华—你们的　神抚养你们，如同人抚养儿子一般，直等你们来到这地方。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","你们在这事上却不信耶和华—你们的　神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","他在路上，在你们前面行，为你们找安营的地方；夜间在火柱里，日间在云柱里，指示你们所当行的路。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","「耶和华听见你们这话，就发怒，起誓说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","『这恶世代的人，连一个也不得见我起誓应许赐给你们列祖的美地； ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","惟有耶孚尼的儿子迦勒必得看见，并且我要将他所踏过的地赐给他和他的子孙，因为他专心跟从我。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","耶和华为你的缘故也向我发怒，说：『你必不得进入那地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","伺候你、嫩的儿子约书亚，他必得进入那地；你要勉励他，因为他要使以色列人承受那地为业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","并且你们的妇人孩子，就是你们所说、必被掳掠的，和今日不知善恶的儿女，必进入那地。我要将那地赐给他们，他们必得为业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","至于你们，要转回，从红海的路往旷野去。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","「那时，你们回答我说：『我们得罪了耶和华，情愿照耶和华—我们　神一切所吩咐的上去争战。』于是你们各人带着兵器，争先上山地去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","耶和华吩咐我说：『你对他们说：不要上去，也不要争战；因我不在你们中间，恐怕你们被仇敌杀败了。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","我就告诉了你们，你们却不听从，竟违背耶和华的命令，擅自上山地去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","住那山地的亚摩利人就出来攻击你们，追赶你们，如蜂拥一般，在西珥杀退你们，直到何珥玛。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","你们便回来，在耶和华面前哭号；耶和华却不听你们的声音，也不向你们侧耳。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","于是你们在加低斯住了许多日子。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","「此后，我们转回，从红海的路往旷野去，是照耶和华所吩咐我的。我们在西珥山绕行了许多日子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","耶和华对我说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","『你们绕行这山的日子够了，要转向北去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","你吩咐百姓说：你们弟兄以扫的子孙住在西珥，你们要经过他们的境界。他们必惧怕你们，所以你们要分外谨慎。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","不可与他们争战；他们的地，连脚掌可踏之处，我都不给你们，因我已将西珥山赐给以扫为业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","你们要用钱向他们买粮吃，也要用钱向他们买水喝。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","因为耶和华—你的　神在你手里所办的一切事上已赐福与你。你走这大旷野，他都知道了。这四十年，耶和华—你的　神常与你同在，故此你一无所缺。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","「于是，我们离了我们弟兄以扫子孙所住的西珥，从亚拉巴的路，经过以拉他、以旬·迦别，转向摩押旷野的路去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","耶和华吩咐我说：『不可扰害摩押人，也不可与他们争战。他们的地，我不赐给你为业，因我已将亚珥赐给罗得的子孙为业。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","先前，有以米人住在那里，民数众多，身体高大，像亚衲人一样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","这以米人像亚衲人；也算为利乏音人；摩押人称他们为以米人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","先前，何利人也住在西珥，但以扫的子孙将他们除灭，得了他们的地，接着居住，就如以色列在耶和华赐给他为业之地所行的一样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","现在，起来过撒烈溪！于是我们过了撒烈溪。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","自从离开加低斯·巴尼亚，到过了撒烈溪的时候，共有三十八年，等那世代的兵丁都从营中灭尽，正如耶和华向他们所起的誓。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","耶和华的手也攻击他们，将他们从营中除灭，直到灭尽。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","「兵丁从民中都灭尽死亡以后， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","耶和华吩咐我说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","『你今天要从摩押的境界亚珥经过， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","走近亚扪人之地，不可扰害他们，也不可与他们争战。亚扪人的地，我不赐给你们为业，因我已将那地赐给罗得的子孙为业。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","那地也算为利乏音人之地，先前利乏音人住在那里，亚扪人称他们为散送冥。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","那民众多，身体高大，像亚衲人一样，但耶和华从亚扪人面前除灭他们，亚扪人就得了他们的地，接着居住。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","正如耶和华从前为住西珥的以扫子孙将何利人从他们面前除灭、他们得了何利人的地、接着居住一样，直到今日。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","从迦斐托出来的迦斐托人将先前住在乡村直到迦萨的亚卫人除灭，接着居住。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","你们起来前往，过亚嫩谷；我已将亚摩利人希实本王西宏和他的地交在你手中，你要与他争战，得他的地为业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","从今日起，我要使天下万民听见你的名声都惊恐惧怕，且因你发颤伤恸。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","「我从基底莫的旷野差遣使者去见希实本王西宏，用和睦的话说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","『求你容我从你的地经过，只走大道，不偏左右。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","你可以卖粮给我吃，也可以卖水给我喝，只要容我步行过去， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","就如住西珥的以扫子孙和住亚珥的摩押人待我一样，等我过了约旦河，好进入耶和华—我们　神所赐给我们的地。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","但希实本王西宏不容我们从他那里经过；因为耶和华—你的　神使他心中刚硬，性情顽梗，为要将他交在你手中，像今日一样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","耶和华对我说：『从此起首，我要将西宏和他的地交给你；你要得他的地为业。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","那时，西宏和他的众民出来攻击我们，在雅杂与我们交战。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","耶和华—我们的　神将他交给我们，我们就把他和他的儿子，并他的众民，都击杀了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","我们夺了他的一切城邑，将有人烟的各城，连女人带孩子，尽都毁灭，没有留下一个。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","惟有牲畜和所夺的各城，并其中的财物，都取为自己的掠物。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","从亚嫩谷边的亚罗珥和谷中的城，直到基列，耶和华—我们的　神都交给我们了，没有一座城高得使我们不能攻取的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","惟有亚扪人之地，凡靠近雅博河的地，并山地的城邑，与耶和华—我们　神所禁止我们去的地方，都没有挨近。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","「以后，我们转回，向巴珊去。巴珊王噩和他的众民都出来，在以得来与我们交战。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","耶和华对我说：『不要怕他！因我已将他和他的众民，并他的地，都交在你手中；你要待他像从前待住希实本的亚摩利王西宏一样。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","于是耶和华—我们的　神也将巴珊王噩和他的众民都交在我们手中；我们杀了他们，没有留下一个。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","那时，我们夺了他所有的城，共有六十座，没有一座城不被我们所夺。这为亚珥歌伯的全境，就是巴珊地噩王的国。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","这些城都有坚固的高墙，有门有闩。此外还有许多无城墙的乡村。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","我们将这些都毁灭了，像从前待希实本王西宏一样，把有人烟的各城，连女人带孩子，尽都毁灭； ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","惟有一切牲畜和城中的财物都取为自己的掠物。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","那时，我们从约旦河东两个亚摩利王的手将亚嫩谷直到黑门山之地夺过来（ ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","这黑门山，西顿人称为西连，亚摩利人称为示尼珥）， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","就是夺了平原的各城、基列全地、巴珊全地，直到撒迦和以得来，都是巴珊王噩国内的城邑。（ ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","利乏音人所剩下的只有巴珊王噩。他的床是铁的，长九肘，宽四肘，都是以人肘为度。现今岂不是在亚扪人的拉巴吗？）」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","「那时，我们得了这地。从亚嫩谷边的亚罗珥起，我将基列山地的一半，并其中的城邑，都给了吕便人和迦得人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","其余的基列地和巴珊全地，就是噩王的国，我给了玛拿西半支派。亚珥歌伯全地乃是巴珊全地；这叫做利乏音人之地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","玛拿西的子孙睚珥占了亚珥歌伯全境，直到基述人和玛迦人的交界，就按自己的名称这巴珊地为哈倭特·睚珥，直到今日。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","我又将基列给了玛吉。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","从基列到亚嫩谷，以谷中为界，直到亚扪人交界的雅博河，我给了吕便人和迦得人， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","又将亚拉巴和靠近约旦河之地，从基尼烈直到亚拉巴海，就是盐海，并毗斯迦山根东边之地，都给了他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","「那时，我吩咐你们说：『耶和华—你们的　神已将这地赐给你们为业；你们所有的勇士都要带着兵器，在你们的弟兄以色列人前面过去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","但你们的妻子、孩子、牲畜（我知道你们有许多的牲畜）可以住在我所赐给你们的各城里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","等到你们弟兄在约旦河那边，也得耶和华—你们　神所赐给他们的地，又使他们得享平安，与你们一样，你们才可以回到我所赐给你们为业之地。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","那时我吩咐约书亚说：『你亲眼看见了耶和华—你　神向这二王所行的；耶和华也必向你所要去的各国照样行。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","你不要怕他们，因那为你争战的是耶和华—你的　神。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","「那时，我恳求耶和华说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","『主耶和华啊，你已将你的大力大能显给仆人看。在天上，在地下，有什么神能像你行事、像你有大能的作为呢？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","求你容我过去，看约旦河那边的美地，就是那佳美的山地和黎巴嫩。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","但耶和华因你们的缘故向我发怒，不应允我，对我说：『罢了！你不要向我再提这事。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","你且上毗斯迦山顶去，向东、西、南、北举目观望，因为你必不能过这约旦河。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","你却要嘱咐约书亚，勉励他，使他胆壮；因为他必在这百姓前面过去，使他们承受你所要观看之地。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","于是我们住在伯·毗珥对面的谷中。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","「以色列人哪，现在我所教训你们的律例典章，你们要听从遵行，好叫你们存活，得以进入耶和华—你们列祖之　神所赐给你们的地，承受为业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","所吩咐你们的话，你们不可加添，也不可删减，好叫你们遵守我所吩咐的，就是耶和华—你们　神的命令。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","耶和华因巴力·毗珥的事所行的，你们亲眼看见了。凡随从巴力·毗珥的人，耶和华—你们的　神都从你们中间除灭了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","惟有你们专靠耶和华—你们　神的人，今日全都存活。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","我照着耶和华—我　神所吩咐的将律例典章教训你们，使你们在所要进去得为业的地上遵行。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","所以你们要谨守遵行；这就是你们在万民眼前的智慧、聪明。他们听见这一切律例，必说：『这大国的人真是有智慧，有聪明！』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","哪一大国的人有神与他们相近，像耶和华—我们的　神、在我们求告他的时候与我们相近呢？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","又哪一大国有这样公义的律例典章、像我今日在你们面前所陈明的这一切律法呢？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","「你只要谨慎，殷勤保守你的心灵，免得忘记你亲眼所看见的事，又免得你一生、这事离开你的心；总要传给你的子子孙孙。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","你在何烈山站在耶和华—你　神面前的那日，耶和华对我说：『你为我招聚百姓，我要叫他们听见我的话，使他们存活在世的日子，可以学习敬畏我，又可以教训儿女这样行。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","那时你们近前来，站在山下；山上有火焰冲天，并有昏黑、密云、幽暗。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","耶和华从火焰中对你们说话，你们只听见声音，却没有看见形象。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","他将所吩咐你们当守的约指示你们，就是十条诫，并将这诫写在两块石版上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","那时耶和华又吩咐我将律例典章教训你们，使你们在所要过去得为业的地上遵行。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","「所以，你们要分外谨慎；因为耶和华在何烈山、从火中对你们说话的那日，你们没有看见什么形象。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","惟恐你们败坏自己，雕刻偶像，仿佛什么男像女像， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","或地上走兽的像，或空中飞鸟的像， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","或地上爬物的像，或地底下水中鱼的像。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","又恐怕你向天举目观看，见耶和华—你的　神为天下万民所摆列的日月星，就是天上的万象，自己便被勾引敬拜事奉它。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","耶和华将你们从埃及领出来，脱离铁炉，要特作自己产业的子民，像今日一样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","耶和华又因你们的缘故向我发怒，起誓必不容我过约旦河，也不容我进入耶和华—你　神所赐你为业的那美地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","我只得死在这地，不能过约旦河；但你们必过去得那美地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","你们要谨慎，免得忘记耶和华—你们　神与你们所立的约，为自己雕刻偶像，就是耶和华—你　神所禁止你做的偶像； ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","因为耶和华—你的　神乃是烈火，是忌邪的　神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","「你们在那地住久了，生子生孙，就雕刻偶像，仿佛什么形象，败坏自己，行耶和华—你　神眼中看为恶的事，惹他发怒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","我今日呼天唤地向你们作见证，你们必在过约旦河得为业的地上速速灭尽！你们不能在那地上长久，必尽行除灭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","耶和华必使你们分散在万民中；在他所领你们到的万国里，你们剩下的人数稀少。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","在那里，你们必事奉人手所造的神，就是用木石造成、不能看、不能听、不能吃、不能闻的神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","但你们在那里必寻求耶和华—你的　神。你尽心尽性寻求他的时候，就必寻见。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","日后你遭遇一切患难的时候，你必归回耶和华—你的　神，听从他的话。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","耶和华—你　神原是有怜悯的　神；他总不撇下你，不灭绝你，也不忘记他起誓与你列祖所立的约。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","33","「你且考察在你以前的世代，自　神造人在世以来，从天这边到天那边，曾有何民听见　神在火中说话的声音，像你听见还能存活呢？这样的大事何曾有、何曾听见呢？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","神何曾从别的国中将一国的人民领出来，用试验、神迹、奇事、争战、大能的手，和伸出来的膀臂，并大可畏的事，像耶和华—你们的　神在埃及，在你们眼前为你们所行的一切事呢？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","这是显给你看，要使你知道，惟有耶和华—他是　神，除他以外，再无别神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","他从天上使你听见他的声音，为要教训你，又在地上使你看见他的烈火，并且听见他从火中所说的话。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","因他爱你的列祖，所以拣选他们的后裔，用大能亲自领你出了埃及， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","要将比你强大的国民从你面前赶出，领你进去，将他们的地赐你为业，像今日一样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","所以，今日你要知道，也要记在心上，天上地下惟有耶和华他是　神，除他以外，再无别神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","我今日将他的律例诫命晓谕你，你要遵守，使你和你的子孙可以得福，并使你的日子在耶和华—你　神所赐的地上得以长久。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","「那时，摩西在约旦河东，向日出之地，分定三座城， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","使那素无仇恨、无心杀了人的，可以逃到这三城之中的一座城，就得存活： ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","为吕便人分定旷野平原的比悉；为迦得人分定基列的拉末；为玛拿西人分定巴珊的哥兰。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","摩西在以色列人面前所陈明的律法— ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","就是摩西在以色列人出埃及后所传给他们的法度、律例、典章； ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","在约旦河东伯·毗珥对面的谷中，在住希实本、亚摩利王西宏之地；这西宏是摩西和以色列人出埃及后所击杀的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","他们得了他的地，又得了巴珊王噩的地，就是两个亚摩利王，在约旦河东向日出之地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","从亚嫩谷边的亚罗珥，直到西云山，就是黑门山。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","还有约旦河东的全亚拉巴，直到亚拉巴海，靠近毗斯迦山根。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","摩西将以色列众人召了来，对他们说：「以色列人哪，我今日晓谕你们的律例典章，你们要听，可以学习，谨守遵行。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","耶和华—我们的　神在何烈山与我们立约。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","这约不是与我们列祖立的，乃是与我们今日在这里存活之人立的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","耶和华在山上，从火中，面对面与你们说话— ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","那时我站在耶和华和你们中间，要将耶和华的话传给你们；因为你们惧怕那火，没有上山—说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","「『我是耶和华—你的　神，曾将你从埃及地为奴之家领出来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","「『除了我以外，你不可有别的神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","「『不可为自己雕刻偶像，也不可做什么形象，仿佛上天、下地和地底下、水中的百物。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","不可跪拜那些像，也不可事奉它，因为我耶和华—你的　神是忌邪的　神。恨我的，我必追讨他的罪，自父及子，直到三、四代； ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","爱我、守我诫命的，我必向他们发慈爱，直到千代。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","「『不可妄称耶和华—你　神的名；因为妄称耶和华名的，耶和华必不以他为无罪。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","「『当照耶和华—你　神所吩咐的守安息日为圣日。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","六日要劳碌做你一切的工， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","但第七日是向耶和华—你　神当守的安息日。这一日，你和你的儿女、仆婢、牛、驴、牲畜，并在你城里寄居的客旅，无论何工都不可做，使你的仆婢可以和你一样安息。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","你也要记念你在埃及地作过奴仆；耶和华—你　神用大能的手和伸出来的膀臂将你从那里领出来。因此，耶和华—你的　神吩咐你守安息日。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","「『当照耶和华—你　神所吩咐的孝敬父母，使你得福，并使你的日子在耶和华—你　神所赐你的地上得以长久。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","「『不可杀人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","「『不可奸淫。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","「『不可偷盗。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","「『不可作假见证陷害人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","「『不可贪恋人的妻子；也不可贪图人的房屋、田地、仆婢、牛、驴，并他一切所有的。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","「这些话是耶和华在山上，从火中、云中、幽暗中，大声晓谕你们全会众的；此外并没有添别的话。他就把这话写在两块石版上，交给我了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","「那时，火焰烧山，你们听见从黑暗中出来的声音；你们支派中所有的首领和长老都来就近我， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","说：『看哪，耶和华—我们　神将他的荣光和他的大能显给我们看，我们又听见他的声音从火中出来。今日我们得见　神与人说话，人还存活。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","现在这大火将要烧灭我们，我们何必冒死呢？若再听见耶和华—我们　神的声音就必死亡。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","凡属血气的，曾有何人听见永生　神的声音从火中出来，像我们听见还能存活呢？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","求你近前去，听耶和华—我们　神所要说的一切话，将他对你说的话都传给我们，我们就听从遵行。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","「你们对我说的话，耶和华都听见了。耶和华对我说：『这百姓的话，我听见了；他们所说的都是。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","惟愿他们存这样的心敬畏我，常遵守我的一切诫命，使他们和他们的子孙永远得福。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","你去对他们说：你们回帐棚去吧！ ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","至于你，可以站在我这里，我要将一切诫命、律例、典章传给你；你要教训他们，使他们在我赐他们为业的地上遵行。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","所以，你们要照耶和华—你们　神所吩咐的谨守遵行，不可偏离左右。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","耶和华—你们　神所吩咐你们行的，你们都要去行，使你们可以存活得福，并使你们的日子在所要承受的地上得以长久。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","「这是耶和华—你们　神所吩咐教训你们的诫命、律例、典章，使你们在所要过去得为业的地上遵行， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","好叫你和你子子孙孙一生敬畏耶和华—你的　神，谨守他的一切律例诫命，就是我所吩咐你的，使你的日子得以长久。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","以色列啊，你要听，要谨守遵行，使你可以在那流奶与蜜之地得以享福，人数极其增多，正如耶和华—你列祖的　神所应许你的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","「以色列啊，你要听！耶和华—我们　神是独一的主。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","你要尽心、尽性、尽力爱耶和华—你的　神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","我今日所吩咐你的话都要记在心上， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","也要殷勤教训你的儿女。无论你坐在家里，行在路上，躺下，起来，都要谈论。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","也要系在手上为记号，戴在额上为经文； ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","又要写在你房屋的门框上，并你的城门上。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","「耶和华—你的　神领你进他向你列祖亚伯拉罕、以撒、雅各起誓应许给你的地。那里有城邑，又大又美，非你所建造的； ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","有房屋，装满各样美物，非你所装满的；有凿成的水井，非你所凿成的；还有葡萄园、橄榄园，非你所栽种的；你吃了而且饱足。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","那时你要谨慎，免得你忘记将你从埃及地、为奴之家领出来的耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","你要敬畏耶和华—你的　神，事奉他，指着他的名起誓。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","不可随从别神，就是你们四围国民的神； ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","因为在你们中间的耶和华—你　神是忌邪的　神，惟恐耶和华—你　神的怒气向你发作，就把你从地上除灭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","「你们不可试探耶和华—你们的　神，像你们在玛撒那样试探他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","要留意遵守耶和华—你们　神所吩咐的诫命、法度、律例。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","耶和华眼中看为正、看为善的，你都要遵行，使你可以享福，并可以进去得耶和华向你列祖起誓应许的那美地， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","照耶和华所说的，从你面前撵出你的一切仇敌。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","「日后，你的儿子问你说：『耶和华—我们　神吩咐你们的这些法度、律例、典章是什么意思呢？』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","你就告诉你的儿子说：『我们在埃及作过法老的奴仆；耶和华用大能的手将我们从埃及领出来， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","在我们眼前，将重大可怕的神迹奇事施行在埃及地和法老并他全家的身上， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","将我们从那里领出来，要领我们进入他向我们列祖起誓应许之地，把这地赐给我们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","耶和华又吩咐我们遵行这一切律例，要敬畏耶和华—我们的　神，使我们常得好处，蒙他保全我们的生命，像今日一样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","我们若照耶和华—我们　神所吩咐的一切诫命谨守遵行，这就是我们的义了。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","「耶和华—你　神领你进入要得为业之地，从你面前赶出许多国民，就是赫人、革迦撒人、亚摩利人、迦南人、比利洗人、希未人、耶布斯人，共七国的民，都比你强大。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","耶和华—你　神将他们交给你击杀，那时你要把他们灭绝净尽，不可与他们立约，也不可怜恤他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","不可与他们结亲。不可将你的女儿嫁他们的儿子，也不可叫你的儿子娶他们的女儿； ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","因为他必使你儿子转离不跟从主，去事奉别神，以致耶和华的怒气向你们发作，就速速地将你们灭绝。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","你们却要这样待他们：拆毁他们的祭坛，打碎他们的柱像，砍下他们的木偶，用火焚烧他们雕刻的偶像。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","因为你归耶和华—你　神为圣洁的民；耶和华—你　神从地上的万民中拣选你，特作自己的子民。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","「耶和华专爱你们，拣选你们，并非因你们的人数多于别民，原来你们的人数在万民中是最少的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","只因耶和华爱你们，又因要守他向你们列祖所起的誓，就用大能的手领你们出来，从为奴之家救赎你们脱离埃及王法老的手。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","所以，你要知道耶和华—你的　神，他是　神，是信实的　神；向爱他、守他诫命的人守约，施慈爱，直到千代； ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","向恨他的人当面报应他们，将他们灭绝。凡恨他的人必报应他们，决不迟延。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","所以，你要谨守遵行我今日所吩咐你的诫命、律例、典章。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","「你们果然听从这些典章，谨守遵行，耶和华—你　神就必照他向你列祖所起的誓守约，施慈爱。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","他必爱你，赐福与你，使你人数增多，也必在他向你列祖起誓应许给你的地上赐福与你身所生的，地所产的，并你的五谷、新酒，和油，以及牛犊、羊羔。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","你必蒙福胜过万民；你们的男女没有不能生养的，牲畜也没有不能生育的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","耶和华必使一切的病症离开你；你所知道埃及各样的恶疾，他不加在你身上，只加在一切恨你的人身上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","耶和华—你　神所要交给你的一切人民，你要将他们除灭；你眼不可顾惜他们。你也不可事奉他们的神，因这必成为你的网罗。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","「你若心里说，这些国的民比我更多，我怎能赶出他们呢？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","你不要惧怕他们，要牢牢记念耶和华—你　神向法老和埃及全地所行的事， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","就是你亲眼所看见的大试验、神迹、奇事，和大能的手，并伸出来的膀臂，都是耶和华—你　神领你出来所用的。耶和华—你　神必照样待你所惧怕的一切人民。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","并且耶和华—你　神必打发黄蜂飞到他们中间，直到那剩下而藏躲的人从你面前灭亡。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","你不要因他们惊恐，因为耶和华—你　神在你们中间是大而可畏的　神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","耶和华—你　神必将这些国的民从你面前渐渐赶出；你不可把他们速速灭尽，恐怕野地的兽多起来害你。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","耶和华—你　神必将他们交给你，大大地扰乱他们，直到他们灭绝了； ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","又要将他们的君王交在你手中，你就使他们的名从天下消灭。必无一人能在你面前站立得住，直到你将他们灭绝了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","他们雕刻的神像，你们要用火焚烧；其上的金银，你不可贪图，也不可收取，免得你因此陷入网罗；这原是耶和华—你　神所憎恶的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","可憎的物，你不可带进家去；不然，你就成了当毁灭的，与那物一样。你要十分厌恶，十分憎嫌，因为这是当毁灭的物。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","「我今日所吩咐的一切诫命，你们要谨守遵行，好叫你们存活，人数增多，且进去得耶和华向你们列祖起誓应许的那地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","你也要记念耶和华—你的　神在旷野引导你这四十年，是要苦炼你，试验你，要知道你心内如何，肯守他的诫命不肯。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","他苦炼你，任你饥饿，将你和你列祖所不认识的吗哪赐给你吃，使你知道，人活着不是单靠食物，乃是靠耶和华口里所出的一切话。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","这四十年，你的衣服没有穿破，你的脚也没有肿。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","你当心里思想，耶和华—你　神管教你，好像人管教儿子一样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","你要谨守耶和华—你　神的诫命，遵行他的道，敬畏他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","因为耶和华—你　神领你进入美地，那地有河，有泉，有源，从山谷中流出水来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","那地有小麦、大麦、葡萄树、无花果树、石榴树、橄榄树，和蜜。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","你在那地不缺食物，一无所缺。那地的石头是铁，山内可以挖铜。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","你吃得饱足，就要称颂耶和华—你的　神，因他将那美地赐给你了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","「你要谨慎，免得忘记耶和华—你的　神，不守他的诫命、典章、律例，就是我今日所吩咐你的； ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","恐怕你吃得饱足，建造美好的房屋居住， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","你的牛羊加多，你的金银增添，并你所有的全都加增， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","你就心高气傲，忘记耶和华—你的　神，就是将你从埃及地为奴之家领出来的， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","引你经过那大而可怕的旷野，那里有火蛇、蝎子、干旱无水之地。他曾为你使水从坚硬的磐石中流出来， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","又在旷野将你列祖所不认识的吗哪赐给你吃，是要苦炼你，试验你，叫你终久享福； ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","恐怕你心里说：『这货财是我力量、我能力得来的。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","你要记念耶和华—你的　神，因为得货财的力量是他给你的，为要坚定他向你列祖起誓所立的约，像今日一样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","你若忘记耶和华—你的　神，随从别神，事奉敬拜，你们必定灭亡；这是我今日警戒你们的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","耶和华在你们面前怎样使列国的民灭亡，你们也必照样灭亡，因为你们不听从耶和华—你们　神的话。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","「以色列啊，你当听！你今日要过约旦河，进去赶出比你强大的国民，得着广大坚固、高得顶天的城邑。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","那民是亚衲族的人，又大又高，是你所知道的；也曾听见有人指着他们说：『谁能在亚衲族人面前站立得住呢？』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","你今日当知道，耶和华—你的　神在你前面过去，如同烈火，要灭绝他们，将他们制伏在你面前。这样，你就要照耶和华所说的赶出他们，使他们速速灭亡。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","「耶和华—你的　神将这些国民从你面前撵出以后，你心里不可说：『耶和华将我领进来得这地是因我的义。』其实，耶和华将他们从你面前赶出去是因他们的恶。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","你进去得他们的地，并不是因你的义，也不是因你心里正直，乃是因这些国民的恶，耶和华—你的　神将他们从你面前赶出去，又因耶和华要坚定他向你列祖亚伯拉罕、以撒、雅各起誓所应许的话。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","「你当知道，耶和华—你　神将这美地赐你为业，并不是因你的义；你本是硬着颈项的百姓。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","你当记念不忘，你在旷野怎样惹耶和华—你　神发怒。自从你出了埃及地的那日，直到你们来到这地方，你们时常悖逆耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","你们在何烈山又惹耶和华发怒；他恼怒你们，要灭绝你们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","我上了山，要领受两块石版，就是耶和华与你们立约的版。那时我在山上住了四十昼夜，没有吃饭，也没有喝水。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT9_10","006_9_10","DEU","9","10","10","耶和华把那两块石版交给我，是　神用指头写的。版上所写的是照耶和华在大会的日子、在山上、从火中对你们所说的一切话。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT9_11","006_9_11","DEU","9","11","11","过了四十昼夜，耶和华把那两块石版，就是约版，交给我。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","对我说：『你起来，赶快下去！因为你从埃及领出来的百姓已经败坏了自己；他们快快地偏离了我所吩咐的道，为自己铸成了偶像。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT9_13","006_9_13","DEU","9","13","13","「耶和华又对我说：『我看这百姓是硬着颈项的百姓。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT9_14","006_9_14","DEU","9","14","14","你且由着我，我要灭绝他们，将他们的名从天下涂抹，使你的后裔比他们成为更大更强的国。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","于是我转身下山，山被火烧着，两块约版在我两手之中。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","我一看见你们得罪了耶和华—你们的　神，铸成了牛犊，快快地偏离了耶和华所吩咐你们的道， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","我就把那两块版从我手中扔下去，在你们眼前摔碎了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","因你们所犯的一切罪，行了耶和华眼中看为恶的事，惹他发怒，我就像从前俯伏在耶和华面前四十昼夜，没有吃饭，也没有喝水。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","我因耶和华向你们大发烈怒，要灭绝你们，就甚害怕；但那次耶和华又应允了我。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT9_20","006_9_20","DEU","9","20","20","耶和华也向亚伦甚是发怒，要灭绝他；那时我又为亚伦祈祷。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT9_21","006_9_21","DEU","9","21","21","我把那叫你们犯罪所铸的牛犊用火焚烧，又捣碎磨得很细，以致细如灰尘，我就把这灰尘撒在从山上流下来的溪水中。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT9_22","006_9_22","DEU","9","22","22","「你们在他备拉、玛撒、基博罗·哈他瓦又惹耶和华发怒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT9_23","006_9_23","DEU","9","23","23","耶和华打发你们离开加低斯·巴尼亚，说：『你们上去得我所赐给你们的地。』那时你们违背了耶和华—你们　神的命令，不信服他，不听从他的话。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT9_24","006_9_24","DEU","9","24","24","自从我认识你们以来，你们常常悖逆耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT9_25","006_9_25","DEU","9","25","25","「我因耶和华说要灭绝你们，就在耶和华面前照旧俯伏四十昼夜。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT9_26","006_9_26","DEU","9","26","26","我祈祷耶和华说：『主耶和华啊，求你不要灭绝你的百姓。他们是你的产业，是你用大力救赎的，用大能从埃及领出来的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT9_27","006_9_27","DEU","9","27","27","求你记念你的仆人亚伯拉罕、以撒、雅各，不要想念这百姓的顽梗、邪恶、罪过， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT9_28","006_9_28","DEU","9","28","28","免得你领我们出来的那地之人说，耶和华因为不能将这百姓领进他所应许之地，又因恨他们，所以领他们出去，要在旷野杀他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT9_29","006_9_29","DEU","9","29","29","其实他们是你的百姓，你的产业，是你用大能和伸出来的膀臂领出来的。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT10_1","006_10_1","DEU","10","1","1","「那时，耶和华吩咐我说：『你要凿出两块石版，和先前的一样，上山到我这里来，又要做一木柜。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT10_2","006_10_2","DEU","10","2","2","你先前摔碎的那版，其上的字我要写在这版上；你要将这版放在柜中。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT10_3","006_10_3","DEU","10","3","3","于是我用皂荚木做了一柜，又凿出两块石版，和先前的一样，手里拿这两块版上山去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT10_4","006_10_4","DEU","10","4","4","耶和华将那大会之日、在山上从火中所传与你们的十条诫，照先前所写的，写在这版上，将版交给我了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT10_5","006_10_5","DEU","10","5","5","我转身下山，将这版放在我所做的柜中，现今还在那里，正如耶和华所吩咐我的。」 （ ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT10_6","006_10_6","DEU","10","6","6","以色列人从比罗比尼·亚干起行，到了摩西拉。亚伦死在那里，就葬在那里。他儿子以利亚撒接续他供祭司的职分。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT10_7","006_10_7","DEU","10","7","7","他们从那里起行，到了谷歌大，又从谷歌大到了有溪水之地的约巴他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT10_8","006_10_8","DEU","10","8","8","那时，耶和华将利未支派分别出来，抬耶和华的约柜，又侍立在耶和华面前事奉他，奉他的名祝福，直到今日。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT10_9","006_10_9","DEU","10","9","9","所以利未人在他弟兄中无分无业，耶和华是他的产业，正如耶和华—你　神所应许他的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT10_10","006_10_10","DEU","10","10","10","「我又像从前在山上住了四十昼夜。那次耶和华也应允我，不忍将你灭绝。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT10_11","006_10_11","DEU","10","11","11","耶和华吩咐我说：『你起来引导这百姓，使他们进去得我向他们列祖起誓应许所赐之地。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT10_12","006_10_12","DEU","10","12","12","「以色列啊，现在耶和华—你　神向你所要的是什么呢？只要你敬畏耶和华—你的　神，遵行他的道，爱他，尽心尽性事奉他， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT10_13","006_10_13","DEU","10","13","13","遵守他的诫命律例，就是我今日所吩咐你的，为要叫你得福。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT10_14","006_10_14","DEU","10","14","14","看哪，天和天上的天，地和地上所有的，都属耶和华—你的　神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT10_15","006_10_15","DEU","10","15","15","耶和华但喜悦你的列祖，爱他们，从万民中拣选他们的后裔，就是你们，像今日一样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT10_16","006_10_16","DEU","10","16","16","所以你们要将心里的污秽除掉，不可再硬着颈项。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT10_17","006_10_17","DEU","10","17","17","因为耶和华—你们的　神—他是万神之神，万主之主，至大的　神，大有能力，大而可畏，不以貌取人，也不受贿赂。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT10_18","006_10_18","DEU","10","18","18","他为孤儿寡妇伸冤，又怜爱寄居的，赐给他衣食。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT10_19","006_10_19","DEU","10","19","19","所以你们要怜爱寄居的，因为你们在埃及地也作过寄居的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT10_20","006_10_20","DEU","10","20","20","你要敬畏耶和华—你的　神，事奉他，专靠他，也要指着他的名起誓。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT10_21","006_10_21","DEU","10","21","21","他是你所赞美的，是你的　神，为你做了那大而可畏的事，是你亲眼所看见的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT10_22","006_10_22","DEU","10","22","22","你的列祖七十人下埃及；现在耶和华—你的　神使你如同天上的星那样多。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT11_1","006_11_1","DEU","11","1","1","「你要爱耶和华—你的　神，常守他的吩咐、律例、典章、诫命。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT11_2","006_11_2","DEU","11","2","2","你们今日当知道，我本不是和你们的儿女说话；因为他们不知道，也没有看见耶和华—你们　神的管教、威严、大能的手，和伸出来的膀臂， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT11_3","006_11_3","DEU","11","3","3","并他在埃及中向埃及王法老和其全地所行的神迹奇事； ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT11_4","006_11_4","DEU","11","4","4","也没有看见他怎样待埃及的军兵、车马，他们追赶你们的时候，耶和华怎样使红海的水淹没他们，将他们灭绝，直到今日， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT11_5","006_11_5","DEU","11","5","5","并他在旷野怎样待你们，以致你们来到这地方； ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT11_6","006_11_6","DEU","11","6","6","也没有看见他怎样待吕便子孙以利押的儿子大坍、亚比兰，地怎样在以色列人中间开口，吞了他们和他们的家眷，并帐棚与跟他们的一切活物。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT11_7","006_11_7","DEU","11","7","7","惟有你们亲眼看见耶和华所做的一切大事。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT11_8","006_11_8","DEU","11","8","8","「所以，你们要守我今日所吩咐的一切诫命，使你们胆壮，能以进去，得你们所要得的那地， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT11_9","006_11_9","DEU","11","9","9","并使你们的日子在耶和华向你们列祖起誓、应许给他们和他们后裔的地上得以长久；那是流奶与蜜之地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT11_10","006_11_10","DEU","11","10","10","你要进去得为业的那地，本不像你出来的埃及地。你在那里撒种，用脚浇灌，像浇灌菜园一样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT11_11","006_11_11","DEU","11","11","11","你们要过去得为业的那地乃是有山有谷、雨水滋润之地， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT11_12","006_11_12","DEU","11","12","12","是耶和华—你　神所眷顾的；从岁首到年终，耶和华—你　神的眼目时常看顾那地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT11_13","006_11_13","DEU","11","13","13","「你们若留意听从我今日所吩咐的诫命，爱耶和华—你们的　神，尽心尽性事奉他， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT11_14","006_11_14","DEU","11","14","14","他必按时降秋雨春雨在你们的地上，使你们可以收藏五谷、新酒，和油， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT11_15","006_11_15","DEU","11","15","15","也必使你吃得饱足，并使田野为你的牲畜长草。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT11_16","006_11_16","DEU","11","16","16","你们要谨慎，免得心中受迷惑，就偏离正路，去事奉敬拜别神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT11_17","006_11_17","DEU","11","17","17","耶和华的怒气向你们发作，就使天闭塞不下雨，地也不出产，使你们在耶和华所赐给你们的美地上速速灭亡。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT11_18","006_11_18","DEU","11","18","18","「你们要将我这话存在心内，留在意中，系在手上为记号，戴在额上为经文； ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT11_19","006_11_19","DEU","11","19","19","也要教训你们的儿女，无论坐在家里，行在路上，躺下，起来，都要谈论； ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT11_20","006_11_20","DEU","11","20","20","又要写在房屋的门框上，并城门上， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT11_21","006_11_21","DEU","11","21","21","使你们和你们子孙的日子在耶和华向你们列祖起誓、应许给他们的地上得以增多，如天覆地的日子那样多。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT11_22","006_11_22","DEU","11","22","22","你们若留意谨守遵行我所吩咐这一切的诫命，爱耶和华—你们的　神，行他的道，专靠他， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT11_23","006_11_23","DEU","11","23","23","他必从你们面前赶出这一切国民，就是比你们更大更强的国民，你们也要得他们的地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT11_24","006_11_24","DEU","11","24","24","凡你们脚掌所踏之地都必归你们；从旷野和黎巴嫩，并幼发拉底大河，直到西海，都要作你们的境界。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT11_25","006_11_25","DEU","11","25","25","必无一人能在你们面前站立得住；耶和华—你们的　神必照他所说的，使惧怕惊恐临到你们所踏之地的居民。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT11_26","006_11_26","DEU","11","26","26","「看哪，我今日将祝福与咒诅的话都陈明在你们面前。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT11_27","006_11_27","DEU","11","27","27","你们若听从耶和华—你们　神的诫命，就是我今日所吩咐你们的，就必蒙福。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT11_28","006_11_28","DEU","11","28","28","你们若不听从耶和华—你们　神的诫命，偏离我今日所吩咐你们的道，去事奉你们素来所不认识的别神，就必受祸。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT11_29","006_11_29","DEU","11","29","29","及至耶和华—你的　神领你进入要去得为业的那地，你就要将祝福的话陈明在基利心山上，将咒诅的话陈明在以巴路山上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT11_30","006_11_30","DEU","11","30","30","这二山岂不是在约旦河那边，日落之处，在住亚拉巴的迦南人之地与吉甲相对，靠近摩利橡树吗？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT11_31","006_11_31","DEU","11","31","31","你们要过约旦河，进去得耶和华—你们　神所赐你们为业之地，在那地居住。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT11_32","006_11_32","DEU","11","32","32","你们要谨守遵行我今日在你们面前所陈明的一切律例典章。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT12_1","006_12_1","DEU","12","1","1","「你们存活于世的日子，在耶和华—你们列祖的　神所赐你们为业的地上，要谨守遵行的律例典章乃是这些： ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT12_2","006_12_2","DEU","12","2","2","你们要将所赶出的国民事奉神的各地方，无论是在高山，在小山，在各青翠树下，都毁坏了； ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT12_3","006_12_3","DEU","12","3","3","也要拆毁他们的祭坛，打碎他们的柱像，用火焚烧他们的木偶，砍下他们雕刻的神像，并将其名从那地方除灭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT12_4","006_12_4","DEU","12","4","4","你们不可照他们那样事奉耶和华—你们的　神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT12_5","006_12_5","DEU","12","5","5","但耶和华—你们的　神从你们各支派中选择何处为立他名的居所，你们就当往那里去求问， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT12_6","006_12_6","DEU","12","6","6","将你们的燔祭、平安祭、十分取一之物，和手中的举祭，并还愿祭、甘心祭，以及牛群羊群中头生的，都奉到那里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT12_7","006_12_7","DEU","12","7","7","在那里，耶和华—你们　神的面前，你们和你们的家属都可以吃，并且因你手所办的一切事蒙耶和华—你的　神赐福，就都欢乐。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT12_8","006_12_8","DEU","12","8","8","我们今日在这里所行的是各人行自己眼中看为正的事，你们将来不可这样行； ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT12_9","006_12_9","DEU","12","9","9","因为你们还没有到耶和华—你　神所赐你的安息地，所给你的产业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT12_10","006_12_10","DEU","12","10","10","但你们过了约旦河，得以住在耶和华—你们　神使你们承受为业之地，又使你们太平，不被四围的一切仇敌扰乱，安然居住。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT12_11","006_12_11","DEU","12","11","11","那时要将我所吩咐你们的燔祭、平安祭、十分取一之物，和手中的举祭，并向耶和华许愿献的一切美祭，都奉到耶和华—你们　神所选择要立为他名的居所。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT12_12","006_12_12","DEU","12","12","12","你们和儿女、仆婢，并住在你们城里无分无业的利未人，都要在耶和华—你们的　神面前欢乐。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT12_13","006_12_13","DEU","12","13","13","你要谨慎，不可在你所看中的各处献燔祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT12_14","006_12_14","DEU","12","14","14","惟独耶和华从你那一支派中所选择的地方，你就要在那里献燔祭，行我一切所吩咐你的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT12_15","006_12_15","DEU","12","15","15","「然而，在你各城里都可以照耶和华—你　神所赐你的福分，随心所欲宰牲吃肉；无论洁净人不洁净人都可以吃，就如吃羚羊与鹿一般。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT12_16","006_12_16","DEU","12","16","16","只是不可吃血，要倒在地上，如同倒水一样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT12_17","006_12_17","DEU","12","17","17","你的五谷、新酒，和油的十分之一，或是牛群羊群中头生的，或是你许愿献的，甘心献的，或是手中的举祭，都不可在你城里吃。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT12_18","006_12_18","DEU","12","18","18","但要在耶和华—你的　神面前吃，在耶和华—你　神所要选择的地方，你和儿女、仆婢，并住在你城里的利未人，都可以吃；也要因你手所办的，在耶和华—你　神面前欢乐。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT12_19","006_12_19","DEU","12","19","19","你要谨慎，在你所住的地方永不可丢弃利未人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT12_20","006_12_20","DEU","12","20","20","「耶和华—你的　神照他所应许扩张你境界的时候，你心里想要吃肉，说：『我要吃肉』，就可以随心所欲地吃肉。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT12_21","006_12_21","DEU","12","21","21","耶和华—你　神所选择要立他名的地方若离你太远，就可以照我所吩咐的，将耶和华赐给你的牛羊取些宰了，可以随心所欲在你城里吃。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT12_22","006_12_22","DEU","12","22","22","你吃那肉，要像吃羚羊与鹿一般；无论洁净人不洁净人都可以吃。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT12_23","006_12_23","DEU","12","23","23","只是你要心意坚定，不可吃血，因为血是生命；不可将血与肉同吃。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT12_24","006_12_24","DEU","12","24","24","不可吃血，要倒在地上，如同倒水一样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT12_25","006_12_25","DEU","12","25","25","不可吃血。这样，你行耶和华眼中看为正的事，你和你的子孙就可以得福。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT12_26","006_12_26","DEU","12","26","26","只是你分别为圣的物和你的还愿祭要奉到耶和华所选择的地方去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT12_27","006_12_27","DEU","12","27","27","你的燔祭，连肉带血，都要献在耶和华—你　神的坛上。平安祭的血要倒在耶和华—你　神的坛上；平安祭的肉，你自己可以吃。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT12_28","006_12_28","DEU","12","28","28","你要谨守听从我所吩咐的一切话，行耶和华—你　神眼中看为善，看为正的事。这样，你和你的子孙就可以永远享福。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT12_29","006_12_29","DEU","12","29","29","「耶和华—你　神将你要去赶出的国民从你面前剪除，你得了他们的地居住， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT12_30","006_12_30","DEU","12","30","30","那时就要谨慎，不可在他们除灭之后随从他们的恶俗，陷入网罗，也不可访问他们的神说：『这些国民怎样事奉他们的神，我也要照样行。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT12_31","006_12_31","DEU","12","31","31","你不可向耶和华—你的　神这样行，因为他们向他们的神行了耶和华所憎嫌所恨恶的一切事，甚至将自己的儿女用火焚烧，献与他们的神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT12_32","006_12_32","DEU","12","32","32","凡我所吩咐的，你们都要谨守遵行，不可加添，也不可删减。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT13_1","006_13_1","DEU","13","1","1","「你们中间若有先知或是做梦的起来，向你显个神迹奇事， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT13_2","006_13_2","DEU","13","2","2","对你说：『我们去随从你素来所不认识的别神，事奉它吧。』他所显的神迹奇事虽有应验， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT13_3","006_13_3","DEU","13","3","3","你也不可听那先知或是那做梦之人的话；因为这是耶和华—你们的　神试验你们，要知道你们是尽心尽性爱耶和华—你们的　神不是。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT13_4","006_13_4","DEU","13","4","4","你们要顺从耶和华—你们的　神，敬畏他，谨守他的诫命，听从他的话，事奉他，专靠他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT13_5","006_13_5","DEU","13","5","5","那先知或是那做梦的既用言语叛逆那领你们出埃及地、救赎你脱离为奴之家的耶和华—你们的　神，要勾引你离开耶和华—你　神所吩咐你行的道，你便要将他治死。这样，就把那恶从你们中间除掉。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT13_6","006_13_6","DEU","13","6","6","「你的同胞弟兄，或是你的儿女，或是你怀中的妻，或是如同你性命的朋友，若暗中引诱你，说：『我们不如去事奉你和你列祖素来所不认识的别神— ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT13_7","006_13_7","DEU","13","7","7","是你四围列国的神。』无论是离你近，离你远，从地这边到地那边的神， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT13_8","006_13_8","DEU","13","8","8","你不可依从他，也不可听从他，眼不可顾惜他。你不可怜恤他，也不可遮庇他， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT13_9","006_13_9","DEU","13","9","9","总要杀他；你先下手，然后众民也下手，将他治死。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT13_10","006_13_10","DEU","13","10","10","要用石头打死他，因为他想要勾引你离开那领你出埃及地为奴之家的耶和华—你的　神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT13_11","006_13_11","DEU","13","11","11","以色列众人都要听见害怕，就不敢在你们中间再行这样的恶了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT13_12","006_13_12","DEU","13","12","13","「在耶和华—你　神所赐你居住的各城中，你若听人说，有些匪类从你们中间的一座城出来勾引本城的居民，说：『我们不如去事奉你们素来所不认识的别神』； ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT13_14","006_13_14","DEU","13","14","14","你就要探听，查究，细细地访问，果然是真，准有这可憎恶的事行在你们中间， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT13_15","006_13_15","DEU","13","15","15","你必要用刀杀那城里的居民，把城里所有的，连牲畜，都用刀杀尽。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT13_16","006_13_16","DEU","13","16","16","你从那城里所夺的财物都要堆积在街市上，用火将城和其内所夺的财物都在耶和华—你　神面前烧尽；那城就永为荒堆，不可再建造。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT13_17","006_13_17","DEU","13","17","18","那当毁灭的物连一点都不可粘你的手。你要听从耶和华—你　神的话，遵守我今日所吩咐你的一切诫命，行耶和华—你　神眼中看为正的事，耶和华就必转意，不发烈怒，恩待你，怜恤你，照他向你列祖所起的誓使你人数增多。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT14_1","006_14_1","DEU","14","1","1","「你们是耶和华—你们　神的儿女。不可为死人用刀划身，也不可将额上剃光； ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT14_2","006_14_2","DEU","14","2","2","因为你归耶和华—你　神为圣洁的民，耶和华从地上的万民中拣选你特作自己的子民。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT14_3","006_14_3","DEU","14","3","3","「凡可憎的物都不可吃。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT14_4","006_14_4","DEU","14","4","4","可吃的牲畜就是牛、绵羊、山羊、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT14_5","006_14_5","DEU","14","5","5","鹿、羚羊、狍子、野山羊、麋鹿、黄羊、青羊。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT14_6","006_14_6","DEU","14","6","6","凡分蹄成为两瓣又倒嚼的走兽，你们都可以吃。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT14_7","006_14_7","DEU","14","7","7","但那些倒嚼或是分蹄之中不可吃的乃是骆驼、兔子、沙番—因为是倒嚼不分蹄，就与你们不洁净； ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT14_8","006_14_8","DEU","14","8","8","猪—因为是分蹄却不倒嚼，就与你们不洁净。这些兽的肉，你们不可吃，死的也不可摸。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT14_9","006_14_9","DEU","14","9","9","「水中可吃的乃是这些：凡有翅有鳞的都可以吃； ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT14_10","006_14_10","DEU","14","10","10","凡无翅无鳞的都不可吃，是与你们不洁净。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT14_11","006_14_11","DEU","14","11","11","「凡洁净的鸟，你们都可以吃。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT14_12","006_14_12","DEU","14","12","12","不可吃的乃是雕、狗头雕、红头雕、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT14_13","006_14_13","DEU","14","13","13","鹯、小鹰、鹞鹰与其类， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT14_14","006_14_14","DEU","14","14","14","乌鸦与其类， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT14_15","006_14_15","DEU","14","15","15","鸵鸟、夜鹰、鱼鹰、鹰与其类， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT14_16","006_14_16","DEU","14","16","16","鸮鸟、猫头鹰、角鸱、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT14_17","006_14_17","DEU","14","17","17","鹈鹕、秃雕、鸬鹚、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT14_18","006_14_18","DEU","14","18","18","鹳、鹭鸶与其类，戴 与蝙蝠。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT14_19","006_14_19","DEU","14","19","19","凡有翅膀爬行的物是与你们不洁净，都不可吃。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT14_20","006_14_20","DEU","14","20","20","凡洁净的鸟，你们都可以吃。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT14_21","006_14_21","DEU","14","21","21","「凡自死的，你们都不可吃，可以给你城里寄居的吃，或卖与外人吃，因为你是归耶和华—你　神为圣洁的民。 「不可用山羊羔母的奶煮山羊羔。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT14_22","006_14_22","DEU","14","22","22","「你要把你撒种所产的，就是你田地每年所出的，十分取一分； ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT14_23","006_14_23","DEU","14","23","23","又要把你的五谷、新酒、和油的十分之一，并牛群羊群中头生的，吃在耶和华—你　神面前，就是他所选择要立为他名的居所。这样，你可以学习时常敬畏耶和华—你的　神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT14_24","006_14_24","DEU","14","24","24","当耶和华—你　神赐福与你的时候，耶和华—你　神所选择要立为他名的地方若离你太远，那路也太长，使你不能把这物带到那里去， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT14_25","006_14_25","DEU","14","25","25","你就可以换成银子，将银子包起来，拿在手中，往耶和华—你　神所要选择的地方去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT14_26","006_14_26","DEU","14","26","26","你用这银子，随心所欲，或买牛羊，或买清酒浓酒，凡你心所想的都可以买；你和你的家属在耶和华—你　神的面前吃喝快乐。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT14_27","006_14_27","DEU","14","27","27","「住在你城里的利未人，你不可丢弃他，因为他在你们中间无分无业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT14_28","006_14_28","DEU","14","28","28","每逢三年的末一年，你要将本年的土产十分之一都取出来，积存在你的城中。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT14_29","006_14_29","DEU","14","29","29","在你城里无分无业的利未人，和你城里寄居的，并孤儿寡妇，都可以来，吃得饱足。这样，耶和华—你的　神必在你手里所办的一切事上赐福与你。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT15_1","006_15_1","DEU","15","1","1","「每逢七年末一年，你要施行豁免。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT15_2","006_15_2","DEU","15","2","2","豁免的定例乃是这样：凡债主要把所借给邻舍的豁免了；不可向邻舍和弟兄追讨，因为耶和华的豁免年已经宣告了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT15_3","006_15_3","DEU","15","3","3","若借给外邦人，你可以向他追讨；但借给你弟兄，无论是什么，你要松手豁免了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT15_4","006_15_4","DEU","15","4","5","你若留意听从耶和华—你　神的话，谨守遵行我今日所吩咐你这一切的命令，就必在你们中间没有穷人了（在耶和华—你　神所赐你为业的地上，耶和华必大大赐福与你。） ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT15_6","006_15_6","DEU","15","6","6","因为耶和华—你的　神必照他所应许你的赐福与你。你必借给许多国民，却不致向他们借贷；你必管辖许多国民，他们却不能管辖你。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT15_7","006_15_7","DEU","15","7","7","「在耶和华—你　神所赐你的地上，无论哪一座城里，你弟兄中若有一个穷人，你不可忍着心、揝着手不帮补你穷乏的弟兄。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT15_8","006_15_8","DEU","15","8","8","总要向他松开手，照他所缺乏的借给他，补他的不足。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT15_9","006_15_9","DEU","15","9","9","你要谨慎，不可心里起恶念，说：『第七年的豁免年快到了』，你便恶眼看你穷乏的弟兄，什么都不给他，以致他因你求告耶和华，罪便归于你了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT15_10","006_15_10","DEU","15","10","10","你总要给他，给他的时候心里不可愁烦；因耶和华—你的　神必在你这一切所行的，并你手里所办的事上，赐福与你。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT15_11","006_15_11","DEU","15","11","11","原来那地上的穷人永不断绝；所以我吩咐你说：『总要向你地上困苦穷乏的弟兄松开手。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT15_12","006_15_12","DEU","15","12","12","「你弟兄中，若有一个希伯来男人或希伯来女人被卖给你，服事你六年，到第七年就要任他自由出去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT15_13","006_15_13","DEU","15","13","13","你任他自由的时候，不可使他空手而去， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT15_14","006_15_14","DEU","15","14","14","要从你羊群、禾场、酒榨之中多多地给他；耶和华—你的　神怎样赐福与你，你也要照样给他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT15_15","006_15_15","DEU","15","15","15","要记念你在埃及地作过奴仆，耶和华—你的　神将你救赎；因此，我今日吩咐你这件事。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT15_16","006_15_16","DEU","15","16","16","他若对你说：『我不愿意离开你』，是因他爱你和你的家，且因在你那里很好， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT15_17","006_15_17","DEU","15","17","17","你就要拿锥子将他的耳朵在门上刺透，他便永为你的奴仆了。你待婢女也要这样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT15_18","006_15_18","DEU","15","18","18","你任他自由的时候，不可以为难事，因他服事你六年，较比雇工的工价多加一倍了。耶和华—你的　神就必在你所做的一切事上赐福与你。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT15_19","006_15_19","DEU","15","19","19","「你牛群羊群中头生的，凡是公的，都要分别为圣，归耶和华—你的　神。牛群中头生的，不可用它耕地；羊群中头生的，不可剪毛。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT15_20","006_15_20","DEU","15","20","20","这头生的，你和你的家属，每年要在耶和华所选择的地方，在耶和华—你　神面前吃。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT15_21","006_15_21","DEU","15","21","21","这头生的若有什么残疾，就如瘸腿的、瞎眼的，无论有什么恶残疾，都不可献给耶和华—你的　神； ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT15_22","006_15_22","DEU","15","22","22","可以在你城里吃；洁净人与不洁净人都可以吃，就如吃羚羊与鹿一般。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT15_23","006_15_23","DEU","15","23","23","只是不可吃它的血；要倒在地上，如同倒水一样。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT16_1","006_16_1","DEU","16","1","1","「你要注意亚笔月，向耶和华—你的　神守逾越节，因为耶和华—你的　神在亚笔月夜间领你出埃及。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT16_2","006_16_2","DEU","16","2","2","你当在耶和华所选择要立为他名的居所，从牛群羊群中，将逾越节的祭牲献给耶和华—你的　神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT16_3","006_16_3","DEU","16","3","3","你吃这祭牲，不可吃有酵的饼；七日之内要吃无酵饼，就是困苦饼—你本是急忙出了埃及地—要叫你一生一世记念你从埃及地出来的日子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT16_4","006_16_4","DEU","16","4","4","在你四境之内，七日不可见面酵，头一日晚上所献的肉，一点不可留到早晨。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT16_5","006_16_5","DEU","16","5","5","在耶和华—你　神所赐的各城中，你不可献逾越节的祭； ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT16_6","006_16_6","DEU","16","6","6","只当在耶和华—你　神所选择要立为他名的居所，晚上日落的时候，乃是你出埃及的时候，献逾越节的祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT16_7","006_16_7","DEU","16","7","7","当在耶和华—你　神所选择的地方把肉烤了吃，次日早晨就回到你的帐棚去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT16_8","006_16_8","DEU","16","8","8","你要吃无酵饼六日，第七日要向耶和华—你的　神守严肃会，不可做工。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT16_9","006_16_9","DEU","16","9","9","「你要计算七七日：从你开镰收割禾稼时算起，共计七七日。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT16_10","006_16_10","DEU","16","10","10","你要照耶和华—你　神所赐你的福，手里拿着甘心祭，献在耶和华—你的　神面前，守七七节。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT16_11","006_16_11","DEU","16","11","11","你和你儿女、仆婢，并住在你城里的利未人，以及在你们中间寄居的与孤儿寡妇，都要在耶和华—你　神所选择立为他名的居所，在耶和华—你的　神面前欢乐。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT16_12","006_16_12","DEU","16","12","12","你也要记念你在埃及作过奴仆。你要谨守遵行这些律例。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT16_13","006_16_13","DEU","16","13","13","「你把禾场的谷、酒榨的酒收藏以后，就要守住棚节七日。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT16_14","006_16_14","DEU","16","14","14","守节的时候，你和你儿女、仆婢，并住在你城里的利未人，以及寄居的与孤儿寡妇，都要欢乐。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT16_15","006_16_15","DEU","16","15","15","在耶和华所选择的地方，你当向耶和华—你的　神守节七日；因为耶和华—你　神在你一切的土产上和你手里所办的事上要赐福与你，你就非常地欢乐。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT16_16","006_16_16","DEU","16","16","16","你一切的男丁要在除酵节、七七节、住棚节，一年三次，在耶和华—你　神所选择的地方朝见他，却不可空手朝见。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT16_17","006_16_17","DEU","16","17","17","各人要按自己的力量，照耶和华—你　神所赐的福分，奉献礼物。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT16_18","006_16_18","DEU","16","18","18","「你要在耶和华—你　神所赐的各城里，按着各支派设立审判官和官长。他们必按公义的审判判断百姓。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT16_19","006_16_19","DEU","16","19","19","不可屈枉正直；不可看人的外貌。也不可受贿赂；因为贿赂能叫智慧人的眼变瞎了，又能颠倒义人的话。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT16_20","006_16_20","DEU","16","20","20","你要追求至公至义，好叫你存活，承受耶和华—你　神所赐你的地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT16_21","006_16_21","DEU","16","21","21","「你为耶和华—你的　神筑坛，不可在坛旁栽什么树木作为木偶。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT16_22","006_16_22","DEU","16","22","22","也不可为自己设立柱像；这是耶和华—你　神所恨恶的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT17_1","006_17_1","DEU","17","1","1","「凡有残疾，或有什么恶病的牛羊，你都不可献给耶和华—你的　神，因为这是耶和华—你　神所憎恶的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT17_2","006_17_2","DEU","17","2","2","「在你们中间，在耶和华—你　神所赐你的诸城中，无论哪座城里，若有人，或男或女，行耶和华—你　神眼中看为恶的事，违背了他的约， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT17_3","006_17_3","DEU","17","3","3","去事奉敬拜别神，或拜日头，或拜月亮，或拜天象，是主不曾吩咐的； ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT17_4","006_17_4","DEU","17","4","4","有人告诉你，你也听见了，就要细细地探听，果然是真，准有这可憎恶的事行在以色列中， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT17_5","006_17_5","DEU","17","5","5","你就要将行这恶事的男人或女人拉到城门外，用石头将他打死。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT17_6","006_17_6","DEU","17","6","6","要凭两三个人的口作见证将那当死的人治死；不可凭一个人的口作见证将他治死。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT17_7","006_17_7","DEU","17","7","7","见证人要先下手，然后众民也下手将他治死。这样，就把那恶从你们中间除掉。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT17_8","006_17_8","DEU","17","8","8","「你城中若起了争讼的事，或因流血，或因争竞，或因殴打，是你难断的案件，你就当起来，往耶和华—你　神所选择的地方 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT17_9","006_17_9","DEU","17","9","9","去见祭司利未人，并当时的审判官，求问他们，他们必将判语指示你。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT17_10","006_17_10","DEU","17","10","10","他们在耶和华所选择的地方指示你的判语，你必照着他们所指教你的一切话谨守遵行。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT17_11","006_17_11","DEU","17","11","11","要按他们所指教你的律法，照他们所断定的去行；他们所指示你的判语，你不可偏离左右。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT17_12","006_17_12","DEU","17","12","12","若有人擅敢不听从那侍立在耶和华—你　神面前的祭司，或不听从审判官，那人就必治死；这样，便将那恶从以色列中除掉。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT17_13","006_17_13","DEU","17","13","13","众百姓都要听见害怕，不再擅敢行事。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT17_14","006_17_14","DEU","17","14","14","「到了耶和华—你　神所赐你的地，得了那地居住的时候，若说：『我要立王治理我，像四围的国一样。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT17_15","006_17_15","DEU","17","15","15","你总要立耶和华—你　神所拣选的人为王。必从你弟兄中立一人；不可立你弟兄以外的人为王。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT17_16","006_17_16","DEU","17","16","16","只是王不可为自己加添马匹，也不可使百姓回埃及去，为要加添他的马匹，因耶和华曾吩咐你们说：『不可再回那条路去。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT17_17","006_17_17","DEU","17","17","17","他也不可为自己多立妃嫔，恐怕他的心偏邪；也不可为自己多积金银。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT17_18","006_17_18","DEU","17","18","18","他登了国位，就要将祭司利未人面前的这律法书，为自己抄录一本， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT17_19","006_17_19","DEU","17","19","19","存在他那里，要平生诵读，好学习敬畏耶和华—他的　神，谨守遵行这律法书上的一切言语和这些律例， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT17_20","006_17_20","DEU","17","20","20","免得他向弟兄心高气傲，偏左偏右，离了这诫命。这样，他和他的子孙便可在以色列中，在国位上年长日久。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT18_1","006_18_1","DEU","18","1","1","「祭司利未人和利未全支派必在以色列中无分无业；他们所吃用的就是献给耶和华的火祭和一切所捐的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT18_2","006_18_2","DEU","18","2","2","他们在弟兄中必没有产业；耶和华是他们的产业，正如耶和华所应许他们的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT18_3","006_18_3","DEU","18","3","3","祭司从百姓所当得的分乃是这样：凡献牛或羊为祭的，要把前腿和两腮并脾胃给祭司。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT18_4","006_18_4","DEU","18","4","4","初收的五谷、新酒和油，并初剪的羊毛，也要给他； ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT18_5","006_18_5","DEU","18","5","5","因为耶和华—你的　神从你各支派中将他拣选出来，使他和他子孙永远奉耶和华的名侍立，事奉。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT18_6","006_18_6","DEU","18","6","6","「利未人无论寄居在以色列中的哪一座城，若从那里出来，一心愿意到耶和华所选择的地方， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT18_7","006_18_7","DEU","18","7","7","就要奉耶和华—他　神的名事奉，像他众弟兄利未人侍立在耶和华面前事奉一样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT18_8","006_18_8","DEU","18","8","8","除了他卖祖父产业所得的以外，还要得一分祭物与他们同吃。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT18_9","006_18_9","DEU","18","9","9","「你到了耶和华—你　神所赐之地，那些国民所行可憎恶的事，你不可学着行。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT18_10","006_18_10","DEU","18","10","10","你们中间不可有人使儿女经火，也不可有占卜的、观兆的、用法术的、行邪术的、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT18_11","006_18_11","DEU","18","11","11","用迷术的、交鬼的、行巫术的、过阴的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT18_12","006_18_12","DEU","18","12","12","凡行这些事的都为耶和华所憎恶；因那些国民行这可憎恶的事，所以耶和华—你的　神将他们从你面前赶出。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT18_13","006_18_13","DEU","18","13","13","你要在耶和华—你的　神面前作完全人。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT18_14","006_18_14","DEU","18","14","14","「因你所要赶出的那些国民都听信观兆的和占卜的，至于你，耶和华—你的　神从来不许你这样行。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT18_15","006_18_15","DEU","18","15","15","耶和华—你的　神要从你们弟兄中间给你兴起一位先知，像我，你们要听从他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT18_16","006_18_16","DEU","18","16","16","正如你在何烈山大会的日子求耶和华—你　神一切的话，说：『求你不再叫我听见耶和华—我　神的声音，也不再叫我看见这大火，免得我死亡。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT18_17","006_18_17","DEU","18","17","17","耶和华就对我说：『他们所说的是。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT18_18","006_18_18","DEU","18","18","18","我必在他们弟兄中间给他们兴起一位先知，像你。我要将当说的话传给他；他要将我一切所吩咐的都传给他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT18_19","006_18_19","DEU","18","19","19","谁不听他奉我名所说的话，我必讨谁的罪。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT18_20","006_18_20","DEU","18","20","20","若有先知擅敢托我的名说我所未曾吩咐他说的话，或是奉别神的名说话，那先知就必治死。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT18_21","006_18_21","DEU","18","21","21","你心里若说：『耶和华所未曾吩咐的话，我们怎能知道呢？』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT18_22","006_18_22","DEU","18","22","22","先知托耶和华的名说话，所说的若不成就，也无效验，这就是耶和华所未曾吩咐的，是那先知擅自说的，你不要怕他。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT19_1","006_19_1","DEU","19","1","1","「耶和华—你　神将列国之民剪除的时候，耶和华—你　神也将他们的地赐给你，你接着住他们的城邑并他们的房屋， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT19_2","006_19_2","DEU","19","2","2","就要在耶和华—你　神所赐你为业的地上分定三座城。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT19_3","006_19_3","DEU","19","3","3","要将耶和华—你　神使你承受为业的地分为三段；又要预备道路，使误杀人的，都可以逃到那里去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT19_4","006_19_4","DEU","19","4","4","「误杀人的逃到那里可以存活，定例乃是这样：凡素无仇恨，无心杀了人的， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT19_5","006_19_5","DEU","19","5","5","就如人与邻舍同入树林砍伐树木，手拿斧子一砍，本想砍下树木，不料，斧头脱了把，飞落在邻舍身上，以致于死，这人逃到那些城的一座城，就可以存活， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT19_6","006_19_6","DEU","19","6","6","免得报血仇的，心中火热追赶他，因路远就追上，将他杀死；其实他不该死，因为他与被杀的素无仇恨。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT19_7","006_19_7","DEU","19","7","7","所以我吩咐你说，要分定三座城。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT19_8","006_19_8","DEU","19","8","8","耶和华—你　神若照他向你列祖所起的誓扩张你的境界，将所应许赐你列祖的地全然给你， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT19_9","006_19_9","DEU","19","9","9","你若谨守遵行我今日所吩咐的这一切诫命，爱耶和华—你的　神，常常遵行他的道，就要在这三座城之外，再添三座城， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT19_10","006_19_10","DEU","19","10","10","免得无辜之人的血流在耶和华—你　神所赐你为业的地上，流血的罪就归于你。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT19_11","006_19_11","DEU","19","11","11","「若有人恨他的邻舍，埋伏着起来击杀他，以致于死，便逃到这些城的一座城， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT19_12","006_19_12","DEU","19","12","12","本城的长老就要打发人去，从那里带出他来，交在报血仇的手中，将他治死。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT19_13","006_19_13","DEU","19","13","13","你眼不可顾惜他，却要从以色列中除掉流无辜血的罪，使你可以得福。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT19_14","006_19_14","DEU","19","14","14","「在耶和华—你　神所赐你承受为业之地，不可挪移你邻舍的地界，那是先人所定的。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT19_15","006_19_15","DEU","19","15","15","「人无论犯什么罪，作什么恶，不可凭一个人的口作见证，总要凭两三个人的口作见证才可定案。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT19_16","006_19_16","DEU","19","16","16","若有凶恶的见证人起来，见证某人作恶， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT19_17","006_19_17","DEU","19","17","17","这两个争讼的人就要站在耶和华面前，和当时的祭司，并审判官面前， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT19_18","006_19_18","DEU","19","18","18","审判官要细细地查究，若见证人果然是作假见证的，以假见证陷害弟兄， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT19_19","006_19_19","DEU","19","19","19","你们就要待他如同他想要待的弟兄。这样，就把那恶从你们中间除掉。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT19_20","006_19_20","DEU","19","20","20","别人听见都要害怕，就不敢在你们中间再行这样的恶了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT19_21","006_19_21","DEU","19","21","21","你眼不可顾惜，要以命偿命，以眼还眼，以牙还牙，以手还手，以脚还脚。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT20_1","006_20_1","DEU","20","1","1","「你出去与仇敌争战的时候，看见马匹、车辆，并有比你多的人民，不要怕他们，因为领你出埃及地的耶和华—你　神与你同在。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT20_2","006_20_2","DEU","20","2","2","你们将要上阵的时候，祭司要到百姓面前宣告 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT20_3","006_20_3","DEU","20","3","3","说：『以色列人哪，你们当听，你们今日将要与仇敌争战，不要胆怯，不要惧怕战兢，也不要因他们惊恐； ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT20_4","006_20_4","DEU","20","4","4","因为耶和华—你们的　神与你们同去，要为你们与仇敌争战，拯救你们。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT20_5","006_20_5","DEU","20","5","5","官长也要对百姓宣告说：『谁建造房屋，尚未奉献，他可以回家去，恐怕他阵亡，别人去奉献。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT20_6","006_20_6","DEU","20","6","6","谁种葡萄园，尚未用所结的果子，他可以回家去，恐怕他阵亡，别人去用。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT20_7","006_20_7","DEU","20","7","7","谁聘定了妻，尚未迎娶，他可以回家去，恐怕他阵亡，别人去娶。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT20_8","006_20_8","DEU","20","8","8","官长又要对百姓宣告说：『谁惧怕胆怯，他可以回家去，恐怕他弟兄的心消化，和他一样。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT20_9","006_20_9","DEU","20","9","9","官长对百姓宣告完了，就当派军长率领他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT20_10","006_20_10","DEU","20","10","10","「你临近一座城、要攻打的时候，先要对城里的民宣告和睦的话。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT20_11","006_20_11","DEU","20","11","11","他们若以和睦的话回答你，给你开了城，城里所有的人都要给你效劳，服事你； ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT20_12","006_20_12","DEU","20","12","12","若不肯与你和好，反要与你打仗，你就要围困那城。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT20_13","006_20_13","DEU","20","13","13","耶和华—你的　神把城交付你手，你就要用刀杀尽这城的男丁。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT20_14","006_20_14","DEU","20","14","14","惟有妇女、孩子、牲畜，和城内一切的财物，你可以取为自己的掠物。耶和华—你　神把你仇敌的财物赐给你，你可以吃用。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT20_15","006_20_15","DEU","20","15","15","离你甚远的各城，不是这些国民的城，你都要这样待他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT20_16","006_20_16","DEU","20","16","16","但这些国民的城，耶和华—你　神既赐你为业，其中凡有气息的，一个不可存留； ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT20_17","006_20_17","DEU","20","17","17","只要照耶和华—你　神所吩咐的将这赫人、亚摩利人、迦南人、比利洗人、希未人、耶布斯人都灭绝净尽， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT20_18","006_20_18","DEU","20","18","18","免得他们教导你们学习一切可憎恶的事，就是他们向自己神所行的，以致你们得罪耶和华—你们的　神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT20_19","006_20_19","DEU","20","19","19","「你若许久围困、攻打所要取的一座城，就不可举斧子砍坏树木；因为你可以吃那树上的果子，不可砍伐。田间的树木岂是人，叫你糟蹋吗？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT20_20","006_20_20","DEU","20","20","20","惟独你所知道不是结果子的树木可以毁坏、砍伐，用以修筑营垒，攻击那与你打仗的城，直到攻塌了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT21_1","006_21_1","DEU","21","1","1","「在耶和华—你　神所赐你为业的地上，若遇见被杀的人倒在田野，不知道是谁杀的， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT21_2","006_21_2","DEU","21","2","2","长老和审判官就要出去，从被杀的人那里量起，直量到四围的城邑， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT21_3","006_21_3","DEU","21","3","3","看哪城离被杀的人最近，那城的长老就要从牛群中取一只未曾耕地、未曾负轭的母牛犊， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT21_4","006_21_4","DEU","21","4","4","把母牛犊牵到流水、未曾耕种的山谷去，在谷中打折母牛犊的颈项。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT21_5","006_21_5","DEU","21","5","5","祭司利未的子孙要近前来；因为耶和华—你的　神拣选了他们事奉他，奉耶和华的名祝福，所有争讼殴打的事都要凭他们判断。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT21_6","006_21_6","DEU","21","6","6","那城的众长老，就是离被杀的人最近的，要在那山谷中，在所打折颈项的母牛犊以上洗手， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT21_7","006_21_7","DEU","21","7","7","祷告说：『我们的手未曾流这人的血；我们的眼也未曾看见这事。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT21_8","006_21_8","DEU","21","8","8","耶和华啊，求你赦免你所救赎的以色列民，不要使流无辜血的罪归在你的百姓以色列中间。』这样，流血的罪必得赦免。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT21_9","006_21_9","DEU","21","9","9","你行耶和华眼中看为正的事，就可以从你们中间除掉流无辜血的罪。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT21_10","006_21_10","DEU","21","10","10","「你出去与仇敌争战的时候，耶和华—你的　神将他们交在你手中，你就掳了他们去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT21_11","006_21_11","DEU","21","11","11","若在被掳的人中见有美貌的女子，恋慕她，要娶她为妻， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT21_12","006_21_12","DEU","21","12","12","就可以领她到你家里去；她便要剃头发，修指甲， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT21_13","006_21_13","DEU","21","13","13","脱去被掳时所穿的衣服，住在你家里哀哭父母一个整月，然后可以与她同房。你作她的丈夫，她作你的妻子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT21_14","006_21_14","DEU","21","14","14","后来你若不喜悦她，就要由她随意出去，决不可为钱卖她，也不可当婢女待她，因为你玷污了她。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT21_15","006_21_15","DEU","21","15","15","「人若有二妻，一为所爱，一为所恶，所爱的、所恶的都给他生了儿子，但长子是所恶之妻生的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT21_16","006_21_16","DEU","21","16","16","到了把产业分给儿子承受的时候，不可将所爱之妻生的儿子立为长子，在所恶之妻生的儿子以上， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT21_17","006_21_17","DEU","21","17","17","却要认所恶之妻生的儿子为长子，将产业多加一分给他；因这儿子是他力量强壮的时候生的，长子的名分本当归他。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT21_18","006_21_18","DEU","21","18","18","「人若有顽梗悖逆的儿子，不听从父母的话，他们虽惩治他，他仍不听从， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT21_19","006_21_19","DEU","21","19","19","父母就要抓住他，将他带到本地的城门、本城的长老那里， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT21_20","006_21_20","DEU","21","20","20","对长老说：『我们这儿子顽梗悖逆，不听从我们的话，是贪食好酒的人。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT21_21","006_21_21","DEU","21","21","21","本城的众人就要用石头将他打死。这样，就把那恶从你们中间除掉，以色列众人都要听见害怕。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT21_22","006_21_22","DEU","21","22","22","「人若犯该死的罪，被治死了，你将他挂在木头上， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT21_23","006_21_23","DEU","21","23","23","他的尸首不可留在木头上过夜，必要当日将他葬埋，免得玷污了耶和华—你　神所赐你为业之地。因为被挂的人是在　神面前受咒诅的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT22_1","006_22_1","DEU","22","1","1","「你若看见弟兄的牛或羊失迷了路，不可佯为不见，总要把它牵回来交给你的弟兄。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT22_2","006_22_2","DEU","22","2","2","你弟兄若离你远，或是你不认识他，就要牵到你家去，留在你那里，等你弟兄来寻找就还给他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT22_3","006_22_3","DEU","22","3","3","你的弟兄无论失落什么，或是驴，或是衣服，你若遇见，都要这样行，不可佯为不见。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT22_4","006_22_4","DEU","22","4","4","你若看见弟兄的牛或驴跌倒在路上，不可佯为不见，总要帮助他拉起来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT22_5","006_22_5","DEU","22","5","5","「妇女不可穿戴男子所穿戴的，男子也不可穿妇女的衣服，因为这样行都是耶和华—你　神所憎恶的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT22_6","006_22_6","DEU","22","6","6","「你若路上遇见鸟窝，或在树上或在地上，里头有雏或有蛋，母鸟伏在雏上或在蛋上，你不可连母带雏一并取去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT22_7","006_22_7","DEU","22","7","7","总要放母，只可取雏；这样你就可以享福，日子得以长久。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT22_8","006_22_8","DEU","22","8","8","「你若建造房屋，要在房上的四围安栏杆，免得有人从房上掉下来，流血的罪就归于你家。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT22_9","006_22_9","DEU","22","9","9","「不可把两样种子种在你的葡萄园里，免得你撒种所结的和葡萄园的果子都要充公。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT22_10","006_22_10","DEU","22","10","10","不可并用牛、驴耕地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT22_11","006_22_11","DEU","22","11","11","不可穿羊毛、细麻两样搀杂料做的衣服。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT22_12","006_22_12","DEU","22","12","12","「你要在所披的外衣上四围做 子。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT22_13","006_22_13","DEU","22","13","13","「人若娶妻，与她同房之后恨恶她， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT22_14","006_22_14","DEU","22","14","14","信口说她，将丑名加在她身上，说：『我娶了这女子，与她同房，见她没有贞洁的凭据』； ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT22_15","006_22_15","DEU","22","15","15","女子的父母就要把女子贞洁的凭据拿出来，带到本城门长老那里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT22_16","006_22_16","DEU","22","16","16","女子的父亲要对长老说：『我将我的女儿给这人为妻，他恨恶她， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT22_17","006_22_17","DEU","22","17","17","信口说她，说：我见你的女儿没有贞洁的凭据；其实这就是我女儿贞洁的凭据。』父母就把那布铺在本城的长老面前。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT22_18","006_22_18","DEU","22","18","18","本城的长老要拿住那人，惩治他， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT22_19","006_22_19","DEU","22","19","19","并要罚他一百舍客勒银子，给女子的父亲，因为他将丑名加在以色列的一个处女身上。女子仍作他的妻，终身不可休她。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT22_20","006_22_20","DEU","22","20","20","但这事若是真的，女子没有贞洁的凭据， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT22_21","006_22_21","DEU","22","21","21","就要将女子带到她父家的门口，本城的人要用石头将她打死；因为她在父家行了淫乱，在以色列中做了丑事。这样，就把那恶从你们中间除掉。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT22_22","006_22_22","DEU","22","22","22","「若遇见人与有丈夫的妇人行淫，就要将奸夫淫妇一并治死。这样，就把那恶从以色列中除掉。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT22_23","006_22_23","DEU","22","23","23","「若有处女已经许配丈夫，有人在城里遇见她，与她行淫， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT22_24","006_22_24","DEU","22","24","24","你们就要把这二人带到本城门，用石头打死—女子是因为虽在城里却没有喊叫；男子是因为玷污别人的妻。这样，就把那恶从你们中间除掉。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT22_25","006_22_25","DEU","22","25","25","「若有男子在田野遇见已经许配人的女子，强与她行淫，只要将那男子治死。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT22_26","006_22_26","DEU","22","26","26","但不可办女子；她本没有该死的罪，这事就类乎人起来攻击邻舍，将他杀了一样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT22_27","006_22_27","DEU","22","27","27","因为男子是在田野遇见那已经许配人的女子，女子喊叫，并无人救她。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT22_28","006_22_28","DEU","22","28","28","「若有男子遇见没有许配人的处女，抓住她，与她行淫，被人看见， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT22_29","006_22_29","DEU","22","29","29","这男子就要拿五十舍客勒银子给女子的父亲；因他玷污了这女子，就要娶她为妻，终身不可休她。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT22_30","006_22_30","DEU","22","30","30","「人不可娶继母为妻；不可掀开他父亲的衣襟。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT23_1","006_23_1","DEU","23","1","1","「凡外肾受伤的，或被阉割的，不可入耶和华的会。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT23_2","006_23_2","DEU","23","2","2","「私生子不可入耶和华的会；他的子孙，直到十代，也不可入耶和华的会。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT23_3","006_23_3","DEU","23","3","3","「亚扪人或是摩押人不可入耶和华的会；他们的子孙，虽过十代，也永不可入耶和华的会。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT23_4","006_23_4","DEU","23","4","4","因为你们出埃及的时候，他们没有拿食物和水在路上迎接你们，又因他们雇了美索不达米亚的毗夺人比珥的儿子巴兰来咒诅你们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT23_5","006_23_5","DEU","23","5","5","然而耶和华—你的　神不肯听从巴兰，却使那咒诅的言语变为祝福的话，因为耶和华—你的　神爱你。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT23_6","006_23_6","DEU","23","6","6","你一生一世永不可求他们的平安和他们的利益。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT23_7","006_23_7","DEU","23","7","7","「不可憎恶以东人，因为他是你的弟兄。不可憎恶埃及人，因为你在他的地上作过寄居的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT23_8","006_23_8","DEU","23","8","8","他们第三代子孙可以入耶和华的会。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT23_9","006_23_9","DEU","23","9","9","「你出兵攻打仇敌，就要远避诸恶。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT23_10","006_23_10","DEU","23","10","10","「你们中间，若有人夜间偶然梦遗，不洁净，就要出到营外，不可入营； ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT23_11","006_23_11","DEU","23","11","11","到傍晚的时候，他要用水洗澡，及至日落了才可以入营。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT23_12","006_23_12","DEU","23","12","12","「你在营外也该定出一个地方作为便所。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT23_13","006_23_13","DEU","23","13","13","在你器械之中当预备一把锹，你出营外便溺以后，用以铲土，转身掩盖。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT23_14","006_23_14","DEU","23","14","14","因为耶和华—你的　神常在你营中行走，要救护你，将仇敌交给你，所以你的营理当圣洁，免得他见你那里有污秽，就离开你。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT23_15","006_23_15","DEU","23","15","15","「若有奴仆脱了主人的手，逃到你那里，你不可将他交付他的主人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT23_16","006_23_16","DEU","23","16","16","他必在你那里与你同住，在你的城邑中，要由他选择一个所喜悦的地方居住；你不可欺负他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT23_17","006_23_17","DEU","23","17","17","「以色列的女子中不可有妓女；以色列的男子中不可有娈童。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT23_18","006_23_18","DEU","23","18","18","娼妓所得的钱，或娈童所得的价，你不可带入耶和华—你　神的殿还愿，因为这两样都是耶和华—你　神所憎恶的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT23_19","006_23_19","DEU","23","19","19","「你借给你弟兄的，或是钱财或是粮食，无论什么可生利的物，都不可取利。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT23_20","006_23_20","DEU","23","20","20","借给外邦人可以取利，只是借给你弟兄不可取利。这样，耶和华—你　神必在你所去得为业的地上和你手里所办的一切事上赐福与你。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT23_21","006_23_21","DEU","23","21","21","「你向耶和华—你的　神许愿，偿还不可迟延；因为耶和华—你的　神必定向你追讨，你不偿还就有罪。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT23_22","006_23_22","DEU","23","22","22","你若不许愿，倒无罪。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT23_23","006_23_23","DEU","23","23","23","你嘴里所出的，就是你口中应许甘心所献的，要照你向耶和华—你　神所许的愿谨守遵行。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT23_24","006_23_24","DEU","23","24","24","「你进了邻舍的葡萄园，可以随意吃饱了葡萄，只是不可装在器皿中。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT23_25","006_23_25","DEU","23","25","25","你进了邻舍站着的禾稼，可以用手摘穗子，只是不可用镰刀割取禾稼。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT24_1","006_24_1","DEU","24","1","1","「人若娶妻以后，见她有什么不合理的事，不喜悦她，就可以写休书交在她手中，打发她离开夫家。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT24_2","006_24_2","DEU","24","2","2","妇人离开夫家以后，可以去嫁别人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT24_3","006_24_3","DEU","24","3","3","后夫若恨恶她，写休书交在她手中，打发她离开夫家，或是娶她为妻的后夫死了， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT24_4","006_24_4","DEU","24","4","4","打发她去的前夫不可在妇人玷污之后再娶她为妻，因为这是耶和华所憎恶的；不可使耶和华—你　神所赐为业之地被玷污了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT24_5","006_24_5","DEU","24","5","5","「新娶妻之人不可从军出征，也不可托他办理什么公事，可以在家清闲一年，使他所娶的妻快活。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT24_6","006_24_6","DEU","24","6","6","「不可拿人的全盘磨石或是上磨石作当头，因为这是拿人的命作当头。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT24_7","006_24_7","DEU","24","7","7","「若遇见人拐带以色列中的一个弟兄，当奴才待他，或是卖了他，那拐带人的就必治死。这样，便将那恶从你们中间除掉。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT24_8","006_24_8","DEU","24","8","8","「在大麻风的灾病上，你们要谨慎，照祭司利未人一切所指教你们的留意遵行。我怎样吩咐他们，你们要怎样遵行。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT24_9","006_24_9","DEU","24","9","9","当记念出埃及后，在路上，耶和华—你　神向米利暗所行的事。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT24_10","006_24_10","DEU","24","10","10","「你借给邻舍，不拘是什么，不可进他家拿他的当头。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT24_11","006_24_11","DEU","24","11","11","要站在外面，等那向你借贷的人把当头拿出来交给你。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT24_12","006_24_12","DEU","24","12","12","他若是穷人，你不可留他的当头过夜。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT24_13","006_24_13","DEU","24","13","13","日落的时候，总要把当头还他，使他用那件衣服盖着睡觉，他就为你祝福；这在耶和华—你　神面前就是你的义了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT24_14","006_24_14","DEU","24","14","14","「困苦穷乏的雇工，无论是你的弟兄或是在你城里寄居的，你不可欺负他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT24_15","006_24_15","DEU","24","15","15","要当日给他工价，不可等到日落—因为他穷苦，把心放在工价上—恐怕他因你求告耶和华，罪便归你了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT24_16","006_24_16","DEU","24","16","16","「不可因子杀父，也不可因父杀子；凡被杀的都为本身的罪。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT24_17","006_24_17","DEU","24","17","17","「你不可向寄居的和孤儿屈枉正直，也不可拿寡妇的衣裳作当头。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT24_18","006_24_18","DEU","24","18","18","要记念你在埃及作过奴仆。耶和华—你的　神从那里将你救赎，所以我吩咐你这样行。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT24_19","006_24_19","DEU","24","19","19","「你在田间收割庄稼，若忘下一捆，不可回去再取，要留给寄居的与孤儿寡妇。这样，耶和华—你　神必在你手里所办的一切事上赐福与你。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT24_20","006_24_20","DEU","24","20","20","你打橄榄树，枝上剩下的，不可再打；要留给寄居的与孤儿寡妇。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT24_21","006_24_21","DEU","24","21","21","你摘葡萄园的葡萄，所剩下的，不可再摘；要留给寄居的与孤儿寡妇。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT24_22","006_24_22","DEU","24","22","22","你也要记念你在埃及地作过奴仆，所以我吩咐你这样行。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT25_1","006_25_1","DEU","25","1","1","「人若有争讼，来听审判，审判官就要定义人有理，定恶人有罪。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT25_2","006_25_2","DEU","25","2","2","恶人若该受责打，审判官就要叫他当面伏在地上，按着他的罪照数责打。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT25_3","006_25_3","DEU","25","3","3","只可打他四十下，不可过数；若过数，便是轻贱你的弟兄了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT25_4","006_25_4","DEU","25","4","4","「牛在场上踹谷的时候，不可笼住它的嘴。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT25_5","006_25_5","DEU","25","5","5","「弟兄同居，若死了一个，没有儿子，死人的妻不可出嫁外人，她丈夫的兄弟当尽弟兄的本分，娶她为妻，与她同房。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT25_6","006_25_6","DEU","25","6","6","妇人生的长子必归死兄的名下，免得他的名在以色列中涂抹了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT25_7","006_25_7","DEU","25","7","7","那人若不愿意娶她哥哥的妻，他哥哥的妻就要到城门长老那里，说：『我丈夫的兄弟不肯在以色列中兴起他哥哥的名字，不给我尽弟兄的本分。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT25_8","006_25_8","DEU","25","8","8","本城的长老就要召那人来问他，他若执意说：『我不愿意娶她』， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT25_9","006_25_9","DEU","25","9","9","他哥哥的妻就要当着长老到那人的跟前，脱了他的鞋，吐唾沫在他脸上，说：『凡不为哥哥建立家室的都要这样待他。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT25_10","006_25_10","DEU","25","10","10","在以色列中，他的名必称为脱鞋之家。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT25_11","006_25_11","DEU","25","11","11","「若有二人争斗，这人的妻近前来，要救她丈夫脱离那打她丈夫之人的手，抓住那人的下体， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT25_12","006_25_12","DEU","25","12","12","就要砍断妇人的手，眼不可顾惜她。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT25_13","006_25_13","DEU","25","13","13","「你囊中不可有一大一小两样的法码。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT25_14","006_25_14","DEU","25","14","14","你家里不可有一大一小两样的升斗。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT25_15","006_25_15","DEU","25","15","15","当用对准公平的法码，公平的升斗。这样，在耶和华—你　神所赐你的地上，你的日子就可以长久。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT25_16","006_25_16","DEU","25","16","16","因为行非义之事的人都是耶和华—你　神所憎恶的。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT25_17","006_25_17","DEU","25","17","17","「你要记念你们出埃及的时候，亚玛力人在路上怎样待你。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT25_18","006_25_18","DEU","25","18","18","他们在路上遇见你，趁你疲乏困倦击杀你尽后边软弱的人，并不敬畏　神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT25_19","006_25_19","DEU","25","19","19","所以耶和华—你　神使你不被四围一切的仇敌扰乱，在耶和华—你　神赐你为业的地上得享平安。那时，你要将亚玛力的名号从天下涂抹了，不可忘记。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT26_1","006_26_1","DEU","26","1","1","「你进去得了耶和华—你　神所赐你为业之地居住， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT26_2","006_26_2","DEU","26","2","2","就要从耶和华—你　神赐你的地上将所收的各种初熟的土产取些来，盛在筐子里，往耶和华—你　神所选择要立为他名的居所去， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT26_3","006_26_3","DEU","26","3","3","见当时作祭司的，对他说：『我今日向耶和华—你　神明认，我已来到耶和华向我们列祖起誓应许赐给我们的地。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT26_4","006_26_4","DEU","26","4","4","祭司就从你手里取过筐子来，放在耶和华—你　神的坛前。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT26_5","006_26_5","DEU","26","5","5","你要在耶和华—你　神面前说：『我祖原是一个将亡的亚兰人，下到埃及寄居。他人口稀少，在那里却成了又大又强、人数很多的国民。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT26_6","006_26_6","DEU","26","6","6","埃及人恶待我们，苦害我们，将苦工加在我们身上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT26_7","006_26_7","DEU","26","7","7","于是我们哀求耶和华—我们列祖的　神，耶和华听见我们的声音，看见我们所受的困苦、劳碌、欺压， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT26_8","006_26_8","DEU","26","8","8","他就用大能的手和伸出来的膀臂，并大可畏的事与神迹奇事，领我们出了埃及， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT26_9","006_26_9","DEU","26","9","9","将我们领进这地方，把这流奶与蜜之地赐给我们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT26_10","006_26_10","DEU","26","10","10","耶和华啊，现在我把你所赐给我地上初熟的土产奉了来。』随后你要把筐子放在耶和华—你　神面前，向耶和华—你的　神下拜。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT26_11","006_26_11","DEU","26","11","11","你和利未人，并在你们中间寄居的，要因耶和华—你　神所赐你和你家的一切福分欢乐。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT26_12","006_26_12","DEU","26","12","12","「每逢三年，就是十分取一之年，你取完了一切土产的十分之一，要分给利未人和寄居的，与孤儿寡妇，使他们在你城中可以吃得饱足。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT26_13","006_26_13","DEU","26","13","13","你又要在耶和华—你　神面前说：『我已将圣物从我家里拿出来，给了利未人和寄居的，与孤儿寡妇，是照你所吩咐我的一切命令。你的命令我都没有违背，也没有忘记。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT26_14","006_26_14","DEU","26","14","14","我守丧的时候，没有吃这圣物；不洁净的时候，也没有拿出来，又没有为死人送去。我听从了耶和华—我　神的话，都照你所吩咐的行了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT26_15","006_26_15","DEU","26","15","15","求你从天上、你的圣所垂看，赐福给你的百姓以色列与你所赐给我们的地，就是你向我们列祖起誓赐我们流奶与蜜之地。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT26_16","006_26_16","DEU","26","16","16","「耶和华—你的　神今日吩咐你行这些律例典章，所以你要尽心尽性谨守遵行。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT26_17","006_26_17","DEU","26","17","17","你今日认耶和华为你的　神，应许遵行他的道，谨守他的律例、诫命、典章，听从他的话。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT26_18","006_26_18","DEU","26","18","18","耶和华今日照他所应许你的，也认你为他的子民，使你谨守他的一切诫命， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT26_19","006_26_19","DEU","26","19","19","又使你得称赞、美名、尊荣，超乎他所造的万民之上，并照他所应许的使你归耶和华—你　神为圣洁的民。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT27_1","006_27_1","DEU","27","1","1","摩西和以色列的众长老吩咐百姓说：「你们要遵守我今日所吩咐的一切诫命。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT27_2","006_27_2","DEU","27","2","2","你们过约旦河，到了耶和华—你　神所赐给你的地，当天要立起几块大石头，墁上石灰， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT27_3","006_27_3","DEU","27","3","3","把这律法的一切话写在石头上。你过了河，可以进入耶和华—你　神所赐你流奶与蜜之地，正如耶和华—你列祖之　神所应许你的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT27_4","006_27_4","DEU","27","4","4","你们过了约旦河，就要在以巴路山上照我今日所吩咐的，将这些石头立起来，墁上石灰。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT27_5","006_27_5","DEU","27","5","5","在那里要为耶和华—你的　神筑一座石坛；在石头上不可动铁器。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT27_6","006_27_6","DEU","27","6","6","要用没有凿过的石头筑耶和华—你　神的坛，在坛上要将燔祭献给耶和华—你的　神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT27_7","006_27_7","DEU","27","7","7","又要献平安祭，且在那里吃，在耶和华—你的　神面前欢乐。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT27_8","006_27_8","DEU","27","8","8","你要将这律法的一切话明明地写在石头上。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT27_9","006_27_9","DEU","27","9","9","摩西和祭司利未人晓谕以色列众人说：「以色列啊，要默默静听。你今日成为耶和华—你　神的百姓了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT27_10","006_27_10","DEU","27","10","10","所以要听从耶和华—你　神的话，遵行他的诫命律例，就是我今日所吩咐你的。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT27_11","006_27_11","DEU","27","11","11","当日，摩西嘱咐百姓说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT27_12","006_27_12","DEU","27","12","12","「你们过了约旦河，西缅、利未、犹大、以萨迦、约瑟、便雅悯六个支派的人都要站在基利心山上为百姓祝福。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT27_13","006_27_13","DEU","27","13","13","吕便、迦得、亚设、西布伦、但、拿弗他利六个支派的人都要站在以巴路山上宣布咒诅。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT27_14","006_27_14","DEU","27","14","14","利未人要向以色列众人高声说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT27_15","006_27_15","DEU","27","15","15","「『有人制造耶和华所憎恶的偶像，或雕刻，或铸造，就是工匠手所做的，在暗中设立，那人必受咒诅！』百姓都要答应说：『阿们！』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT27_16","006_27_16","DEU","27","16","16","「『轻慢父母的，必受咒诅！』百姓都要说：『阿们！』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT27_17","006_27_17","DEU","27","17","17","「『挪移邻舍地界的，必受咒诅！』百姓都要说：『阿们！』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT27_18","006_27_18","DEU","27","18","18","「『使瞎子走差路的，必受咒诅！』百姓都要说：『阿们！』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT27_19","006_27_19","DEU","27","19","19","「『向寄居的和孤儿寡妇屈枉正直的，必受咒诅！』百姓都要说：『阿们！』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT27_20","006_27_20","DEU","27","20","20","「『与继母行淫的，必受咒诅！因为掀开他父亲的衣襟。』百姓都要说：『阿们！』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT27_21","006_27_21","DEU","27","21","21","「『与兽淫合的，必受咒诅！』百姓都要说：『阿们！』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT27_22","006_27_22","DEU","27","22","22","「『与异母同父，或异父同母的姊妹行淫的，必受咒诅！』百姓都要说：『阿们！』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT27_23","006_27_23","DEU","27","23","23","「『与岳母行淫的，必受咒诅！』百姓都要说：『阿们！』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT27_24","006_27_24","DEU","27","24","24","「『暗中杀人的，必受咒诅！』百姓都要说：『阿们！』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT27_25","006_27_25","DEU","27","25","25","「『受贿赂害死无辜之人的，必受咒诅！』百姓都要说：『阿们！』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT27_26","006_27_26","DEU","27","26","26","「『不坚守遵行这律法言语的，必受咒诅！』百姓都要说：『阿们！』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_1","006_28_1","DEU","28","1","1","「你若留意听从耶和华—你　神的话，谨守遵行他的一切诫命，就是我今日所吩咐你的，他必使你超乎天下万民之上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_2","006_28_2","DEU","28","2","2","你若听从耶和华—你　神的话，这以下的福必追随你，临到你身上： ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_3","006_28_3","DEU","28","3","3","你在城里必蒙福，在田间也必蒙福。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_4","006_28_4","DEU","28","4","4","你身所生的，地所产的，牲畜所下的，以及牛犊、羊羔，都必蒙福。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_5","006_28_5","DEU","28","5","5","你的筐子和你的抟面盆都必蒙福。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_6","006_28_6","DEU","28","6","6","你出也蒙福，入也蒙福。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_7","006_28_7","DEU","28","7","7","「仇敌起来攻击你，耶和华必使他们在你面前被你杀败；他们从一条路来攻击你，必从七条路逃跑。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_8","006_28_8","DEU","28","8","8","在你仓房里，并你手所办的一切事上，耶和华所命的福必临到你。耶和华—你　神也要在所给你的地上赐福与你。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_9","006_28_9","DEU","28","9","9","你若谨守耶和华—你　神的诫命，遵行他的道，他必照着向你所起的誓立你作为自己的圣民。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_10","006_28_10","DEU","28","10","10","天下万民见你归在耶和华的名下，就要惧怕你。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_11","006_28_11","DEU","28","11","11","你在耶和华向你列祖起誓应许赐你的地上，他必使你身所生的，牲畜所下的，地所产的，都绰绰有余。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_12","006_28_12","DEU","28","12","12","耶和华必为你开天上的府库，按时降雨在你的地上。在你手里所办的一切事上赐福与你。你必借给许多国民，却不致向他们借贷。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_13","006_28_13","DEU","28","13","14","你若听从耶和华—你　神的诫命，就是我今日所吩咐你的，谨守遵行，不偏左右，也不随从事奉别神，耶和华就必使你作首不作尾，但居上不居下。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_15","006_28_15","DEU","28","15","15","「你若不听从耶和华—你　神的话，不谨守遵行他的一切诫命律例，就是我今日所吩咐你的，这以下的咒诅都必追随你，临到你身上： ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_16","006_28_16","DEU","28","16","16","你在城里必受咒诅，在田间也必受咒诅。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_17","006_28_17","DEU","28","17","17","你的筐子和你的抟面盆都必受咒诅。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_18","006_28_18","DEU","28","18","18","你身所生的，地所产的，以及牛犊、羊羔，都必受咒诅。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_19","006_28_19","DEU","28","19","19","你出也受咒诅，入也受咒诅。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_20","006_28_20","DEU","28","20","20","耶和华因你行恶离弃他，必在你手里所办的一切事上，使咒诅、扰乱、责罚临到你，直到你被毁灭，速速地灭亡。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_21","006_28_21","DEU","28","21","21","耶和华必使瘟疫贴在你身上，直到他将你从所进去得为业的地上灭绝。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_22","006_28_22","DEU","28","22","22","耶和华要用痨病、热病、火症、疟疾、刀剑、旱风、霉烂攻击你。这都要追赶你，直到你灭亡。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_23","006_28_23","DEU","28","23","23","你头上的天要变为铜，脚下的地要变为铁。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_24","006_28_24","DEU","28","24","24","耶和华要使那降在你地上的雨变为尘沙，从天临在你身上，直到你灭亡。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_25","006_28_25","DEU","28","25","25","「耶和华必使你败在仇敌面前，你从一条路去攻击他们，必从七条路逃跑。你必在天下万国中抛来抛去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_26","006_28_26","DEU","28","26","26","你的尸首必给空中的飞鸟和地上的走兽作食物，并无人哄赶。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_27","006_28_27","DEU","28","27","27","耶和华必用埃及人的疮并痔疮、牛皮癣与疥攻击你，使你不能医治。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_28","006_28_28","DEU","28","28","28","耶和华必用癫狂、眼瞎、心惊攻击你。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_29","006_28_29","DEU","28","29","29","你必在午间摸索，好像瞎子在暗中摸索一样。你所行的必不亨通，时常遭遇欺压、抢夺，无人搭救。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_30","006_28_30","DEU","28","30","30","你聘定了妻，别人必与她同房；你建造房屋，不得住在其内；你栽种葡萄园，也不得用其中的果子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_31","006_28_31","DEU","28","31","31","你的牛在你眼前宰了，你必不得吃它的肉；你的驴在你眼前被抢夺，不得归还；你的羊归了仇敌，无人搭救。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_32","006_28_32","DEU","28","32","32","你的儿女必归与别国的民；你的眼目终日切望，甚至失明，你手中无力拯救。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_33","006_28_33","DEU","28","33","33","你的土产和你劳碌得来的，必被你所不认识的国民吃尽。你时常被欺负，受压制， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_34","006_28_34","DEU","28","34","34","甚至你因眼中所看见的，必致疯狂。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_35","006_28_35","DEU","28","35","35","耶和华必攻击你，使你膝上腿上，从脚掌到头顶，长毒疮无法医治。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_36","006_28_36","DEU","28","36","36","「耶和华必将你和你所立的王领到你和你列祖素不认识的国去；在那里你必事奉木头石头的神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_37","006_28_37","DEU","28","37","37","你在耶和华领你到的各国中，要令人惊骇、笑谈、讥诮。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_38","006_28_38","DEU","28","38","38","你带到田间的种子虽多，收进来的却少，因为被蝗虫吃了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_39","006_28_39","DEU","28","39","39","你栽种、修理葡萄园，却不得收葡萄，也不得喝葡萄酒，因为被虫子吃了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_40","006_28_40","DEU","28","40","40","你全境有橄榄树，却不得其油抹身，因为树上的橄榄不熟自落了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_41","006_28_41","DEU","28","41","41","你生儿养女，却不算是你的，因为必被掳去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_42","006_28_42","DEU","28","42","42","你所有的树木和你地里的出产必被蝗虫所吃。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_43","006_28_43","DEU","28","43","43","在你中间寄居的，必渐渐上升，比你高而又高；你必渐渐下降，低而又低。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_44","006_28_44","DEU","28","44","44","他必借给你，你却不能借给他；他必作首，你必作尾。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_45","006_28_45","DEU","28","45","45","这一切咒诅必追随你，赶上你，直到你灭亡；因为你不听从耶和华—你　神的话，不遵守他所吩咐的诫命律例。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_46","006_28_46","DEU","28","46","46","这些咒诅必在你和你后裔的身上成为异迹奇事，直到永远！ ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_47","006_28_47","DEU","28","47","47","「因为你富有的时候，不欢心乐意地事奉耶和华—你的　神， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_48","006_28_48","DEU","28","48","48","所以你必在饥饿、干渴、赤露、缺乏之中事奉耶和华所打发来攻击你的仇敌。他必把铁轭加在你的颈项上，直到将你灭绝。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_49","006_28_49","DEU","28","49","49","「耶和华要从远方、地极带一国的民，如鹰飞来攻击你。这民的言语，你不懂得。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_50","006_28_50","DEU","28","50","50","这民的面貌凶恶，不顾恤年老的，也不恩待年少的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_51","006_28_51","DEU","28","51","51","他们必吃你牲畜所下的和你地土所产的，直到你灭亡。你的五谷、新酒，和油，以及牛犊、羊羔，都不给你留下，直到将你灭绝。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_52","006_28_52","DEU","28","52","52","他们必将你困在你各城里，直到你所倚靠、高大坚固的城墙都被攻塌。他们必将你困在耶和华—你　神所赐你遍地的各城里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_53","006_28_53","DEU","28","53","53","你在仇敌围困窘迫之中，必吃你本身所生的，就是耶和华—你　神所赐给你的儿女之肉。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_54","006_28_54","DEU","28","54","54","你们中间，柔弱娇嫩的人必恶眼看他弟兄和他怀中的妻，并他余剩的儿女； ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_55","006_28_55","DEU","28","55","55","甚至在你受仇敌围困窘迫的城中，他要吃儿女的肉，不肯分一点给他的亲人，因为他一无所剩。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_56","006_28_56","DEU","28","56","56","你们中间，柔弱娇嫩的妇人，是因娇嫩柔弱不肯把脚踏地的，必恶眼看她怀中的丈夫和她的儿女。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_57","006_28_57","DEU","28","57","57","她两腿中间出来的婴孩与她所要生的儿女，她因缺乏一切就要在你受仇敌围困窘迫的城中将他们暗暗地吃了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_58","006_28_58","DEU","28","58","59","「这书上所写律法的一切话是叫你敬畏耶和华—你　神可荣可畏的名。你若不谨守遵行，耶和华就必将奇灾，就是至大至长的灾，至重至久的病，加在你和你后裔的身上， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_60","006_28_60","DEU","28","60","60","也必使你所惧怕、埃及人的病都临到你，贴在你身上， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_61","006_28_61","DEU","28","61","61","又必将没有写在这律法书上的各样疾病、灾殃降在你身上，直到你灭亡。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_62","006_28_62","DEU","28","62","62","你们先前虽然像天上的星那样多，却因不听从耶和华—你　神的话，所剩的人数就稀少了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_63","006_28_63","DEU","28","63","63","先前耶和华怎样喜悦善待你们，使你们众多，也要照样喜悦毁灭你们，使你们灭亡；并且你们从所要进去得的地上必被拔除。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_64","006_28_64","DEU","28","64","64","耶和华必使你们分散在万民中，从地这边到地那边，你必在那里事奉你和你列祖素不认识、木头石头的神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_65","006_28_65","DEU","28","65","65","在那些国中，你必不得安逸，也不得落脚之地；耶和华却使你在那里心中跳动，眼目失明，精神消耗。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_66","006_28_66","DEU","28","66","66","你的性命必悬悬无定；你昼夜恐惧，自料性命难保。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_67","006_28_67","DEU","28","67","67","你因心里所恐惧的，眼中所看见的，早晨必说，巴不得到晚上才好；晚上必说，巴不得到早晨才好。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT28_68","006_28_68","DEU","28","68","68","耶和华必使你坐船回埃及去，走我曾告诉你不得再见的路；在那里你必卖己身与仇敌作奴婢，却无人买。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT29_1","006_29_1","DEU","29","1","1","这是耶和华在摩押地吩咐摩西与以色列人立约的话，是在他和他们于何烈山所立的约之外。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT29_2","006_29_2","DEU","29","2","2","摩西召了以色列众人来，对他们说：「耶和华在埃及地，在你们眼前向法老和他众臣仆，并他全地所行的一切事，你们都看见了， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT29_3","006_29_3","DEU","29","3","3","就是你亲眼看见的大试验和神迹，并那些大奇事。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT29_4","006_29_4","DEU","29","4","4","但耶和华到今日没有使你们心能明白，眼能看见，耳能听见。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT29_5","006_29_5","DEU","29","5","5","我领你们在旷野四十年，你们身上的衣服并没有穿破，脚上的鞋也没有穿坏。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT29_6","006_29_6","DEU","29","6","6","你们没有吃饼，也没有喝清酒浓酒。这要使你们知道，耶和华是你们的　神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT29_7","006_29_7","DEU","29","7","7","你们来到这地方，希实本王西宏、巴珊王噩都出来与我们交战，我们就击杀了他们， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT29_8","006_29_8","DEU","29","8","8","取了他们的地给吕便支派、迦得支派，和玛拿西半支派为业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT29_9","006_29_9","DEU","29","9","9","所以你们要谨守遵行这约的话，好叫你们在一切所行的事上亨通。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT29_10","006_29_10","DEU","29","10","11","「今日，你们的首领、族长、长老、官长、以色列的男丁，你们的妻子儿女，和营中寄居的，以及为你们劈柴挑水的人，都站在耶和华—你们的　神面前， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT29_12","006_29_12","DEU","29","12","12","为要你顺从耶和华—你　神今日与你所立的约，向你所起的誓。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT29_13","006_29_13","DEU","29","13","13","这样，他要照他向你所应许的话，又向你列祖亚伯拉罕、以撒、雅各所起的誓，今日立你作他的子民，他作你的　神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT29_14","006_29_14","DEU","29","14","14","我不但与你们立这约，起这誓， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT29_15","006_29_15","DEU","29","15","15","凡与我们一同站在耶和华—我们　神面前的，并今日不在我们这里的人，我也与他们立这约，起这誓。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT29_16","006_29_16","DEU","29","16","16","「我们曾住过埃及地，也从列国经过；这是你们知道的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT29_17","006_29_17","DEU","29","17","17","你们也看见他们中间可憎之物，并他们木、石、金、银的偶像。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT29_18","006_29_18","DEU","29","18","18","惟恐你们中间，或男或女，或族长或支派长，今日心里偏离耶和华—我们的　神，去事奉那些国的神；又怕你们中间有恶根生出苦菜和茵 来， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT29_19","006_29_19","DEU","29","19","19","听见这咒诅的话，心里仍是自夸说：『我虽然行事心里顽梗，连累众人，却还是平安。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT29_20","006_29_20","DEU","29","20","20","耶和华必不饶恕他；耶和华的怒气与愤恨要向他发作，如烟冒出，将这书上所写的一切咒诅都加在他身上。耶和华又要从天下涂抹他的名， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT29_21","006_29_21","DEU","29","21","21","也必照着写在律法书上、约中的一切咒诅将他从以色列众支派中分别出来，使他受祸。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT29_22","006_29_22","DEU","29","22","22","你们的后代，就是以后兴起来的子孙，和远方来的外人，看见这地的灾殃，并耶和华所降与这地的疾病， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT29_23","006_29_23","DEU","29","23","23","又看见遍地有硫磺，有盐卤，有火迹，没有耕种，没有出产，连草都不生长—好像耶和华在忿怒中所倾覆的所多玛、蛾摩拉、押玛、洗扁一样— ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT29_24","006_29_24","DEU","29","24","24","所看见的人，连万国人，都必问说：『耶和华为何向此地这样行呢？这样大发烈怒是什么意思呢？』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT29_25","006_29_25","DEU","29","25","25","人必回答说：『是因这地的人离弃了耶和华—他们列祖的　神，领他们出埃及地的时候与他们所立的约， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT29_26","006_29_26","DEU","29","26","26","去事奉敬拜素不认识的别神，是耶和华所未曾给他们安排的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT29_27","006_29_27","DEU","29","27","27","所以耶和华的怒气向这地发作，将这书上所写的一切咒诅都降在这地上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT29_28","006_29_28","DEU","29","28","28","耶和华在怒气、忿怒、大恼恨中将他们从本地拔出来，扔在别的地上，像今日一样。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT29_29","006_29_29","DEU","29","29","29","「隐秘的事是属耶和华—我们　神的；惟有明显的事是永远属我们和我们子孙的，好叫我们遵行这律法上的一切话。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT30_1","006_30_1","DEU","30","1","1","「我所陈明在你面前的这一切咒诅都临到你身上；你在耶和华—你　神追赶你到的万国中必心里追念祝福的话； ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT30_2","006_30_2","DEU","30","2","2","你和你的子孙若尽心尽性归向耶和华—你的　神，照着我今日一切所吩咐的听从他的话； ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT30_3","006_30_3","DEU","30","3","3","那时，耶和华—你的　神必怜恤你，救回你这被掳的子民；耶和华—你的　神要回转过来，从分散你到的万民中将你招聚回来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT30_4","006_30_4","DEU","30","4","4","你被赶散的人，就是在天涯的，耶和华—你的　神也必从那里将你招聚回来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT30_5","006_30_5","DEU","30","5","5","耶和华—你的　神必领你进入你列祖所得的地，使你可以得着；又必善待你，使你的人数比你列祖众多。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT30_6","006_30_6","DEU","30","6","6","耶和华—你　神必将你心里和你后裔心里的污秽除掉，好叫你尽心尽性爱耶和华—你的　神，使你可以存活。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT30_7","006_30_7","DEU","30","7","7","耶和华—你的　神必将这一切咒诅加在你仇敌和恨恶你、逼迫你的人身上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT30_8","006_30_8","DEU","30","8","8","你必归回，听从耶和华的话，遵行他的一切诫命，就是我今日所吩咐你的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT30_9","006_30_9","DEU","30","9","10","你若听从耶和华—你　神的话，谨守这律法书上所写的诫命律例，又尽心尽性归向耶和华—你的　神，他必使你手里所办的一切事，并你身所生的，牲畜所下的，地土所产的，都绰绰有余；因为耶和华必再喜悦你，降福与你，像从前喜悦你列祖一样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT30_11","006_30_11","DEU","30","11","11","「我今日所吩咐你的诫命不是你难行的，也不是离你远的； ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT30_12","006_30_12","DEU","30","12","12","不是在天上，使你说：『谁替我们上天取下来，使我们听见可以遵行呢？』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT30_13","006_30_13","DEU","30","13","13","也不是在海外，使你说：『谁替我们过海取了来，使我们听见可以遵行呢？』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT30_14","006_30_14","DEU","30","14","14","这话却离你甚近，就在你口中，在你心里，使你可以遵行。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT30_15","006_30_15","DEU","30","15","15","「看哪，我今日将生与福，死与祸，陈明在你面前。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT30_16","006_30_16","DEU","30","16","16","吩咐你爱耶和华—你的　神，遵行他的道，谨守他的诫命、律例、典章，使你可以存活，人数增多，耶和华—你　神就必在你所要进去得为业的地上赐福与你。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT30_17","006_30_17","DEU","30","17","17","倘若你心里偏离，不肯听从，却被勾引去敬拜事奉别神， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT30_18","006_30_18","DEU","30","18","18","我今日明明告诉你们，你们必要灭亡；在你过约旦河、进去得为业的地上，你的日子必不长久。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT30_19","006_30_19","DEU","30","19","19","我今日呼天唤地向你作见证；我将生死祸福陈明在你面前，所以你要拣选生命，使你和你的后裔都得存活； ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT30_20","006_30_20","DEU","30","20","20","且爱耶和华—你的　神，听从他的话，专靠他；因为他是你的生命，你的日子长久也在乎他。这样，你就可以在耶和华向你列祖亚伯拉罕、以撒、雅各起誓应许所赐的地上居住。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT31_1","006_31_1","DEU","31","1","1","摩西去告诉以色列众人 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT31_2","006_31_2","DEU","31","2","2","说：「我现在一百二十岁了，不能照常出入；耶和华也曾对我说：『你必不得过这约旦河。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT31_3","006_31_3","DEU","31","3","3","耶和华—你们的　神必引导你们过去，将这些国民在你们面前灭绝，你们就得他们的地。约书亚必引导你们过去，正如耶和华所说的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT31_4","006_31_4","DEU","31","4","4","耶和华必待他们，如同从前待他所灭绝的亚摩利二王西宏与噩以及他们的国一样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT31_5","006_31_5","DEU","31","5","5","耶和华必将他们交给你们；你们要照我所吩咐的一切命令待他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT31_6","006_31_6","DEU","31","6","6","你们当刚强壮胆，不要害怕，也不要畏惧他们，因为耶和华—你的　神和你同去。他必不撇下你，也不丢弃你。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT31_7","006_31_7","DEU","31","7","7","摩西召了约书亚来，在以色列众人眼前对他说：「你当刚强壮胆！因为，你要和这百姓一同进入耶和华向他们列祖起誓应许所赐之地；你也要使他们承受那地为业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT31_8","006_31_8","DEU","31","8","8","耶和华必在你前面行；他必与你同在，必不撇下你，也不丢弃你。不要惧怕，也不要惊惶。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT31_9","006_31_9","DEU","31","9","9","摩西将这律法写出来，交给抬耶和华约柜的祭司利未子孙和以色列的众长老。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT31_10","006_31_10","DEU","31","10","10","摩西吩咐他们说：「每逢七年的末一年，就在豁免年的定期住棚节的时候， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT31_11","006_31_11","DEU","31","11","11","以色列众人来到耶和华—你　神所选择的地方朝见他。那时，你要在以色列众人面前将这律法念给他们听。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT31_12","006_31_12","DEU","31","12","12","要招聚他们男、女、孩子，并城里寄居的，使他们听，使他们学习，好敬畏耶和华—你们的　神，谨守、遵行这律法的一切话， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT31_13","006_31_13","DEU","31","13","13","也使他们未曾晓得这律法的儿女得以听见，学习敬畏耶和华—你们的　神，在你们过约旦河要得为业之地，存活的日子，常常这样行。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT31_14","006_31_14","DEU","31","14","14","耶和华对摩西说：「你的死期临近了；要召约书亚来，你们二人站在会幕里，我好嘱咐他。」于是摩西和约书亚去站在会幕里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT31_15","006_31_15","DEU","31","15","15","耶和华在会幕里云柱中显现，云柱停在会幕门以上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT31_16","006_31_16","DEU","31","16","16","耶和华又对摩西说：「你必和你列祖同睡。这百姓要起来，在他们所要去的地上，在那地的人中，随从外邦神行邪淫，离弃我，违背我与他们所立的约。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT31_17","006_31_17","DEU","31","17","17","那时，我的怒气必向他们发作；我也必离弃他们，掩面不顾他们，以致他们被吞灭，并有许多的祸患灾难临到他们。那日他们必说：『这些祸患临到我们，岂不是因我们的　神不在我们中间吗？』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT31_18","006_31_18","DEU","31","18","18","那时，因他们偏向别神所行的一切恶，我必定掩面不顾他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT31_19","006_31_19","DEU","31","19","19","现在你要写一篇歌，教导以色列人，传给他们，使这歌见证他们的不是； ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT31_20","006_31_20","DEU","31","20","20","因为我将他们领进我向他们列祖起誓应许那流奶与蜜之地，他们在那里吃得饱足，身体肥胖，就必偏向别神，事奉他们，藐视我，背弃我的约。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT31_21","006_31_21","DEU","31","21","21","那时，有许多祸患灾难临到他们，这歌必在他们面前作见证，他们后裔的口中必念诵不忘。我未领他们到我所起誓应许之地以先，他们所怀的意念我都知道了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT31_22","006_31_22","DEU","31","22","22","当日摩西就写了一篇歌，教导以色列人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT31_23","006_31_23","DEU","31","23","23","耶和华嘱咐嫩的儿子约书亚说：「你当刚强壮胆，因为你必领以色列人进我所起誓应许他们的地；我必与你同在。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT31_24","006_31_24","DEU","31","24","24","摩西将这律法的话写在书上，及至写完了， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT31_25","006_31_25","DEU","31","25","25","就吩咐抬耶和华约柜的利未人说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT31_26","006_31_26","DEU","31","26","26","「将这律法书放在耶和华—你们　神的约柜旁，可以在那里见证以色列人的不是； ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT31_27","006_31_27","DEU","31","27","27","因为我知道你们是悖逆的，是硬着颈项的。我今日还活着与你们同在，你们尚且悖逆耶和华，何况我死后呢？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT31_28","006_31_28","DEU","31","28","28","你们要将你们支派的众长老和官长都招聚了来，我好将这些话说与他们听，并呼天唤地见证他们的不是。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT31_29","006_31_29","DEU","31","29","29","我知道我死后，你们必全然败坏，偏离我所吩咐你们的道，行耶和华眼中看为恶的事，以手所做的惹他发怒；日后必有祸患临到你们。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT31_30","006_31_30","DEU","31","30","30","摩西将这一篇歌的话都说与以色列全会众听。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT32_1","006_32_1","DEU","32","1","1","诸天哪，侧耳，我要说话； 愿地也听我口中的言语。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT32_2","006_32_2","DEU","32","2","2","我的教训要淋漓如雨； 我的言语要滴落如露， 如细雨降在嫩草上， 如甘霖降在菜蔬中。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT32_3","006_32_3","DEU","32","3","3","我要宣告耶和华的名； 你们要将大德归与我们的　神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT32_4","006_32_4","DEU","32","4","4","他是磐石，他的作为完全； 他所行的无不公平， 是诚实无伪的　神， 又公义，又正直。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT32_5","006_32_5","DEU","32","5","5","这乖僻弯曲的世代向他行事邪僻； 有这弊病就不是他的儿女。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT32_6","006_32_6","DEU","32","6","6","愚昧无知的民哪，你们这样报答耶和华吗？ 他岂不是你的父、将你买来的吗？ 他是制造你、建立你的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT32_7","006_32_7","DEU","32","7","7","你当追想上古之日， 思念历代之年； 问你的父亲，他必指示你； 问你的长者，他必告诉你。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT32_8","006_32_8","DEU","32","8","8","至高者将地业赐给列邦，将世人分开， 就照以色列人的数目立定万民的疆界。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT32_9","006_32_9","DEU","32","9","9","耶和华的分本是他的百姓； 他的产业本是雅各。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT32_10","006_32_10","DEU","32","10","10","耶和华遇见他在旷野— 荒凉野兽吼叫之地， 就环绕他，看顾他， 保护他，如同保护眼中的瞳人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT32_11","006_32_11","DEU","32","11","11","又如鹰搅动巢窝， 在雏鹰以上两翅搧展， 接取雏鹰，背在两翼之上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT32_12","006_32_12","DEU","32","12","12","这样，耶和华独自引导他， 并无外邦神与他同在。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT32_13","006_32_13","DEU","32","13","13","耶和华使他乘驾地的高处， 得吃田间的土产； 又使他从磐石中咂蜜， 从坚石中吸油； ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT32_14","006_32_14","DEU","32","14","14","也吃牛的奶油， 羊的奶，羊羔的脂油， 巴珊所出的公绵羊和山羊， 与上好的麦子， 也喝葡萄汁酿的酒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT32_15","006_32_15","DEU","32","15","15","但耶书 渐渐肥胖，粗壮， 光润，踢跳，奔跑， 便离弃造他的　神， 轻看救他的磐石； ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT32_16","006_32_16","DEU","32","16","16","敬拜别神，触动　神的愤恨， 行可憎恶的事，惹了他的怒气。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT32_17","006_32_17","DEU","32","17","17","所祭祀的鬼魔并非真神， 乃是素不认识的神， 是近来新兴的， 是你列祖所不畏惧的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT32_18","006_32_18","DEU","32","18","18","你轻忽生你的磐石， 忘记产你的　神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT32_19","006_32_19","DEU","32","19","19","耶和华看见他的儿女惹动他， 就厌恶他们，说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT32_20","006_32_20","DEU","32","20","20","我要向他们掩面， 看他们的结局如何。 他们本是极乖僻的族类， 心中无诚实的儿女。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT32_21","006_32_21","DEU","32","21","21","他们以那「不算为神」的触动我的愤恨， 以虚无的神惹了我的怒气。 我也要以那「不成子民」的触动他们的愤恨， 以愚昧的国民惹了他们的怒气。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT32_22","006_32_22","DEU","32","22","22","因为在我怒中有火烧起， 直烧到极深的阴间， 把地和地的出产尽都焚烧， 山的根基也烧着了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT32_23","006_32_23","DEU","32","23","23","我要将祸患堆在他们身上， 把我的箭向他们射尽。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT32_24","006_32_24","DEU","32","24","24","他们必因饥饿消瘦， 被炎热苦毒吞灭。 我要打发野兽用牙齿咬他们， 并土中腹行的，用毒气害他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT32_25","006_32_25","DEU","32","25","25","外头有刀剑，内室有惊恐， 使人丧亡，使少男、童女、 吃奶的、白发的，尽都灭绝。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT32_26","006_32_26","DEU","32","26","26","我说，我必将他们分散远方， 使他们的名号从人间除灭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT32_27","006_32_27","DEU","32","27","27","惟恐仇敌惹动我， 只怕敌人错看，说：是我们手的能力， 并非耶和华所行的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT32_28","006_32_28","DEU","32","28","28","因为以色列民毫无计谋， 心中没有聪明。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT32_29","006_32_29","DEU","32","29","29","惟愿他们有智慧， 能明白这事，肯思念他们的结局。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT32_30","006_32_30","DEU","32","30","30","若不是他们的磐石卖了他们， 若不是耶和华交出他们， 一人焉能追赶他们千人？ 二人焉能使万人逃跑呢？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT32_31","006_32_31","DEU","32","31","31","据我们的仇敌自己断定， 他们的磐石不如我们的磐石。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT32_32","006_32_32","DEU","32","32","32","他们的葡萄树是所多玛的葡萄树， 蛾摩拉田园所生的； 他们的葡萄是毒葡萄， 全挂都是苦的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT32_33","006_32_33","DEU","32","33","33","他们的酒是大蛇的毒气， 是虺蛇残害的恶毒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT32_34","006_32_34","DEU","32","34","34","这不都是积蓄在我这里， 封锁在我府库中吗？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT32_35","006_32_35","DEU","32","35","35","他们失脚的时候，伸冤报应在我； 因他们遭灾的日子近了； 那要临在他们身上的必速速来到。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT32_36","006_32_36","DEU","32","36","36","耶和华见他百姓毫无能力， 无论困住的、自由的都没有剩下， 就必为他们伸冤， 为他的仆人后悔。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT32_37","006_32_37","DEU","32","37","37","他必说：他们的神， 他们所投靠的磐石， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT32_38","006_32_38","DEU","32","38","38","就是向来吃他们祭牲的脂油， 喝他们奠祭之酒的，在哪里呢？ 他可以兴起帮助你们， 护卫你们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT32_39","006_32_39","DEU","32","39","39","你们如今要知道： 我，惟有我是　神； 在我以外并无别神。 我使人死，我使人活； 我损伤，我也医治， 并无人能从我手中救出来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT32_40","006_32_40","DEU","32","40","40","我向天举手说： 我凭我的永生起誓： ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT32_41","006_32_41","DEU","32","41","41","我若磨我闪亮的刀， 手掌审判之权， 就必报复我的敌人， 报应恨我的人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT32_42","006_32_42","DEU","32","42","42","我要使我的箭饮血饮醉， 就是被杀被掳之人的血。 我的刀要吃肉， 乃是仇敌中首领之头的肉。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT32_43","006_32_43","DEU","32","43","43","你们外邦人当与主的百姓一同欢呼； 因他要伸他仆人流血的冤， 报应他的敌人， 洁净他的地，救赎他的百姓。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT32_44","006_32_44","DEU","32","44","44","摩西和嫩的儿子约书亚去将这歌的一切话说给百姓听。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT32_45","006_32_45","DEU","32","45","45","摩西向以色列众人说完了这一切的话， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT32_46","006_32_46","DEU","32","46","46","又说：「我今日所警教你们的，你们都要放在心上；要吩咐你们的子孙谨守遵行这律法上的话。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT32_47","006_32_47","DEU","32","47","47","因为这不是虚空、与你们无关的事，乃是你们的生命；在你们过约旦河要得为业的地上必因这事日子得以长久。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT32_48","006_32_48","DEU","32","48","48","当日，耶和华吩咐摩西说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT32_49","006_32_49","DEU","32","49","49","「你上这亚巴琳山中的尼波山去，在摩押地与耶利哥相对，观看我所要赐给以色列人为业的迦南地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT32_50","006_32_50","DEU","32","50","50","你必死在你所登的山上，归你列祖去，像你哥哥亚伦死在何珥山上，归他的列祖一样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT32_51","006_32_51","DEU","32","51","51","因为你们在寻的旷野，加低斯的米利巴水，在以色列人中没有尊我为圣，得罪了我。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT32_52","006_32_52","DEU","32","52","52","我所赐给以色列人的地，你可以远远地观看，却不得进去。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT33_1","006_33_1","DEU","33","1","1","以下是神人摩西在未死之先为以色列人所祝的福： ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT33_2","006_33_2","DEU","33","2","2","他说：耶和华从西奈而来， 从西珥向他们显现， 从巴兰山发出光辉， 从万万圣者中来临， 从他右手为百姓传出烈火的律法。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT33_3","006_33_3","DEU","33","3","3","他疼爱百姓； 众圣徒都在他手中。 他们坐在他的脚下， 领受他的言语。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT33_4","006_33_4","DEU","33","4","4","摩西将律法传给我们， 作为雅各会众的产业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT33_5","006_33_5","DEU","33","5","5","百姓的众首领， 以色列的各支派， 一同聚会的时候， 耶和华在耶书 中为王。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT33_6","006_33_6","DEU","33","6","6","愿吕便存活，不致死亡； 愿他人数不致稀少。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT33_7","006_33_7","DEU","33","7","7","为犹大祝福说： 求耶和华俯听犹大的声音， 引导他归于本族； 他曾用手为自己争战， 你必帮助他攻击敌人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT33_8","006_33_8","DEU","33","8","8","论利未说： 耶和华啊，你的土明和乌陵 都在你的虔诚人那里。 你在玛撒曾试验他， 在米利巴水与他争论。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT33_9","006_33_9","DEU","33","9","9","他论自己的父母说： 我未曾看见； 他也不承认弟兄， 也不认识自己的儿女。 这是因利未人遵行你的话， 谨守你的约。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT33_10","006_33_10","DEU","33","10","10","他们要将你的典章教训雅各， 将你的律法教训以色列。 他们要把香焚在你面前， 把全牲的燔祭献在你的坛上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT33_11","006_33_11","DEU","33","11","11","求耶和华降福在他的财物上， 悦纳他手里所办的事。 那些起来攻击他和恨恶他的人， 愿你刺透他们的腰， 使他们不得再起来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT33_12","006_33_12","DEU","33","12","12","论便雅悯说： 耶和华所亲爱的必同耶和华安然居住； 耶和华终日遮蔽他，也住在他两肩之中。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT33_13","006_33_13","DEU","33","13","13","论约瑟说： 愿他的地蒙耶和华赐福， 得天上的宝物、甘露， 以及地里所藏的泉水； ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT33_14","006_33_14","DEU","33","14","14","得太阳所晒熟的美果， 月亮所养成的宝物； ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT33_15","006_33_15","DEU","33","15","15","得上古之山的至宝， 永世之岭的宝物； ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT33_16","006_33_16","DEU","33","16","16","得地和其中所充满的宝物， 并住荆棘中上主的喜悦。 愿这些福都归于约瑟的头上， 归于那与弟兄迥别之人的顶上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT33_17","006_33_17","DEU","33","17","17","他为牛群中头生的，有威严； 他的角是野牛的角， 用以抵触万邦，直到地极。 这角是以法莲的万万， 玛拿西的千千。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT33_18","006_33_18","DEU","33","18","18","论西布伦说： 西布伦哪，你出外可以欢喜。 以萨迦啊，在你帐棚里可以快乐。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT33_19","006_33_19","DEU","33","19","19","他们要将列邦召到山上， 在那里献公义的祭； 因为他们要吸取海里的丰富， 并沙中所藏的珍宝。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT33_20","006_33_20","DEU","33","20","20","论迦得说： 使迦得扩张的应当称颂！ 迦得住如母狮； 他撕裂膀臂，连头顶也撕裂。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT33_21","006_33_21","DEU","33","21","21","他为自己选择头一段地， 因在那里有设立律法者的分存留。 他与百姓的首领同来； 他施行耶和华的公义 和耶和华与以色列所立的典章。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT33_22","006_33_22","DEU","33","22","22","论但说： 但为小狮子， 从巴珊跳出来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT33_23","006_33_23","DEU","33","23","23","论拿弗他利说： 拿弗他利啊，你足沾恩惠， 满得耶和华的福， 可以得西方和南方为业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT33_24","006_33_24","DEU","33","24","24","论亚设说： 愿亚设享受多子的福乐， 得他弟兄的喜悦， 可以把脚蘸在油中。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT33_25","006_33_25","DEU","33","25","25","你的门闩是铜的，铁的。 你的日子如何，你的力量也必如何。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT33_26","006_33_26","DEU","33","26","26","耶书 哪，没有能比　神的。 他为帮助你，乘在天空， 显其威荣，驾行穹苍。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT33_27","006_33_27","DEU","33","27","27","永生的　神是你的居所； 他永久的膀臂在你以下。 他在你前面撵出仇敌， 说：毁灭吧。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT33_28","006_33_28","DEU","33","28","28","以色列安然居住； 雅各的本源独居五谷新酒之地。 他的天也滴甘露。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT33_29","006_33_29","DEU","33","29","29","以色列啊，你是有福的！ 谁像你这蒙耶和华所拯救的百姓呢？ 他是你的盾牌，帮助你， 是你威荣的刀剑。 你的仇敌必投降你； 你必踏在他们的高处。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT34_1","006_34_1","DEU","34","1","1","摩西从摩押平原登尼波山，上了那与耶利哥相对的毗斯迦山顶。耶和华把基列全地直到但， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT34_2","006_34_2","DEU","34","2","2","拿弗他利全地，以法莲、玛拿西的地，犹大全地直到西海， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT34_3","006_34_3","DEU","34","3","3","南地和棕树城耶利哥的平原，直到琐珥，都指给他看。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT34_4","006_34_4","DEU","34","4","4","耶和华对他说：「这就是我向亚伯拉罕、以撒、雅各起誓应许之地，说：『我必将这地赐给你的后裔。』现在我使你眼睛看见了，你却不得过到那里去。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT34_5","006_34_5","DEU","34","5","5","于是，耶和华的仆人摩西死在摩押地，正如耶和华所说的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT34_6","006_34_6","DEU","34","6","6","耶和华将他埋葬在摩押地、伯·毗珥对面的谷中，只是到今日没有人知道他的坟墓。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT34_7","006_34_7","DEU","34","7","7","摩西死的时候年一百二十岁；眼目没有昏花，精神没有衰败。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT34_8","006_34_8","DEU","34","8","8","以色列人在摩押平原为摩西哀哭了三十日，为摩西居丧哀哭的日子就满了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT34_9","006_34_9","DEU","34","9","9","嫩的儿子约书亚；因为摩西曾按手在他头上，就被智慧的灵充满，以色列人便听从他，照着耶和华吩咐摩西的行了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT34_10","006_34_10","DEU","34","10","10","以后以色列中再没有兴起先知像摩西的。他是耶和华面对面所认识的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT34_11","006_34_11","DEU","34","11","11","耶和华打发他在埃及地向法老和他的一切臣仆，并他的全地，行各样神迹奇事， ");
INSERT INTO cmn_cu89s_vpl VALUES ("DT34_12","006_34_12","DEU","34","12","12","又在以色列众人眼前显大能的手，行一切大而可畏的事。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","1","耶和华的仆人摩西死了以后，耶和华晓谕摩西的帮手，嫩的儿子约书亚，说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS1_2","007_1_2","JOS","1","2","2","「我的仆人摩西死了。现在你要起来，和众百姓过这约旦河，往我所要赐给以色列人的地去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS1_3","007_1_3","JOS","1","3","3","凡你们脚掌所踏之地，我都照着我所应许摩西的话赐给你们了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS1_4","007_1_4","JOS","1","4","4","从旷野和这黎巴嫩，直到幼发拉底大河，赫人的全地，又到大海日落之处，都要作你们的境界。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS1_5","007_1_5","JOS","1","5","5","你平生的日子，必无一人能在你面前站立得住。我怎样与摩西同在，也必照样与你同在；我必不撇下你，也不丢弃你。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS1_6","007_1_6","JOS","1","6","6","你当刚强壮胆！因为你必使这百姓承受那地为业，就是我向他们列祖起誓应许赐给他们的地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS1_7","007_1_7","JOS","1","7","7","只要刚强，大大壮胆，谨守遵行我仆人摩西所吩咐你的一切律法，不可偏离左右，使你无论往哪里去，都可以顺利。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS1_8","007_1_8","JOS","1","8","8","这律法书不可离开你的口，总要昼夜思想，好使你谨守遵行这书上所写的一切话。如此，你的道路就可以亨通，凡事顺利。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS1_9","007_1_9","JOS","1","9","9","我岂没有吩咐你吗？你当刚强壮胆！不要惧怕，也不要惊惶；因为你无论往哪里去，耶和华—你的　神必与你同在。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS1_10","007_1_10","JOS","1","10","10","于是，约书亚吩咐百姓的官长说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS1_11","007_1_11","JOS","1","11","11","「你们要走遍营中，吩咐百姓说：『当预备食物；因为三日之内你们要过这约旦河，进去得耶和华—你们　神赐你们为业之地。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS1_12","007_1_12","JOS","1","12","12","约书亚对吕便人、迦得人，和玛拿西半支派的人说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS1_13","007_1_13","JOS","1","13","13","「你们要追念耶和华的仆人摩西所吩咐你们的话说：『耶和华—你们的　神使你们得享平安，也必将这地赐给你们。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS1_14","007_1_14","JOS","1","14","14","你们的妻子、孩子，和牲畜都可以留在约旦河东、摩西所给你们的地；但你们中间一切大能的勇士都要带着兵器在你们的弟兄前面过去，帮助他们， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS1_15","007_1_15","JOS","1","15","15","等到耶和华使你们的弟兄像你们一样得享平安，并且得着耶和华—你们　神所赐他们为业之地，那时才可以回你们所得之地，承受为业，就是耶和华的仆人摩西在约旦河东、向日出之地所给你们的。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS1_16","007_1_16","JOS","1","16","16","他们回答约书亚说：「你所吩咐我们行的，我们都必行；你所差遣我们去的，我们都必去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS1_17","007_1_17","JOS","1","17","17","我们从前在一切事上怎样听从摩西，现在也必照样听从你；惟愿耶和华—你的　神与你同在，像与摩西同在一样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS1_18","007_1_18","JOS","1","18","18","无论什么人违背你的命令，不听从你所吩咐他的一切话，就必治死他。你只要刚强壮胆！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS2_1","007_2_1","JOS","2","1","1","当下，嫩的儿子约书亚从什亭暗暗打发两个人作探子，吩咐说：「你们去窥探那地和耶利哥。」于是二人去了，来到一个妓女名叫喇合的家里，就在那里躺卧。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS2_2","007_2_2","JOS","2","2","2","有人告诉耶利哥王说：「今夜有以色列人来到这里窥探此地。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS2_3","007_2_3","JOS","2","3","3","耶利哥王打发人去见喇合说：「那来到你这里、进了你家的人要交出来，因为他们来窥探全地。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS2_4","007_2_4","JOS","2","4","4","女人将二人隐藏，就回答说：「那人果然到我这里来；他们是哪里来的我却不知道。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS2_5","007_2_5","JOS","2","5","5","天黑、要关城门的时候，他们出去了，往哪里去我却不知道。你们快快地去追赶，就必追上。」（ ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS2_6","007_2_6","JOS","2","6","6","先是女人领二人上了房顶，将他们藏在那里所摆的麻秸中。） ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS2_7","007_2_7","JOS","2","7","7","那些人就往约旦河的渡口追赶他们去了。追赶他们的人一出去，城门就关了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS2_8","007_2_8","JOS","2","8","8","二人还没有躺卧，女人就上房顶，到他们那里， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS2_9","007_2_9","JOS","2","9","9","对他们说：「我知道耶和华已经把这地赐给你们，并且因你们的缘故我们都惊慌了。这地的一切居民在你们面前心都消化了； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS2_10","007_2_10","JOS","2","10","10","因为我们听见你们出埃及的时候，耶和华怎样在你们前面使红海的水干了，并且你们怎样待约旦河东的两个亚摩利王西宏和噩，将他们尽行毁灭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS2_11","007_2_11","JOS","2","11","11","我们一听见这些事，心就消化了。因你们的缘故，并无一人有胆气。耶和华—你们的　神本是上天下地的　神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS2_12","007_2_12","JOS","2","12","12","现在我既是恩待你们，求你们指着耶和华向我起誓，也要恩待我父家，并给我一个实在的证据， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS2_13","007_2_13","JOS","2","13","13","要救活我的父母、弟兄、姊妹，和一切属他们的，拯救我们性命不死。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS2_14","007_2_14","JOS","2","14","14","二人对她说：「你若不泄漏我们这件事，我们情愿替你们死。耶和华将这地赐给我们的时候，我们必以慈爱诚实待你。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS2_15","007_2_15","JOS","2","15","15","于是女人用绳子将二人从窗户里缒下去；因她的房子是在城墙边上，她也住在城墙上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS2_16","007_2_16","JOS","2","16","16","她对他们说：「你们且往山上去，恐怕追赶的人碰见你们；要在那里隐藏三天，等追赶的人回来，然后才可以走你们的路。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS2_17","007_2_17","JOS","2","17","17","二人对她说：「你要这样行。不然，你叫我们所起的誓就与我们无干了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS2_18","007_2_18","JOS","2","18","18","我们来到这地的时候，你要把这条朱红线绳系在缒我们下去的窗户上，并要使你的父母、弟兄，和你父的全家都聚集在你家中。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS2_19","007_2_19","JOS","2","19","19","凡出了你家门往街上去的，他的罪必归到自己的头上，与我们无干了。凡在你家里的，若有人下手害他，流他血的罪就归到我们的头上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS2_20","007_2_20","JOS","2","20","20","你若泄漏我们这件事，你叫我们所起的誓就与我们无干了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS2_21","007_2_21","JOS","2","21","21","女人说：「照你们的话行吧！」于是打发他们去了，又把朱红线绳系在窗户上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS2_22","007_2_22","JOS","2","22","22","二人到山上，在那里住了三天，等着追赶的人回去了。追赶的人一路找他们，却找不着。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS2_23","007_2_23","JOS","2","23","23","二人就下山回来，过了河，到嫩的儿子约书亚那里，向他述说所遭遇的一切事； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS2_24","007_2_24","JOS","2","24","24","又对约书亚说：「耶和华果然将那全地交在我们手中；那地的一切居民在我们面前心都消化了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS3_1","007_3_1","JOS","3","1","1","约书亚清早起来，和以色列众人都离开什亭，来到约旦河，就住在那里，等候过河。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS3_2","007_3_2","JOS","3","2","2","过了三天，官长走遍营中， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS3_3","007_3_3","JOS","3","3","3","吩咐百姓说：「你们看见耶和华—你们　神的约柜，又见祭司利未人抬着，就要离开所住的地方，跟着约柜去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS3_4","007_3_4","JOS","3","4","4","只是你们和约柜相离要量二千肘，不可与约柜相近，使你们知道所当走的路，因为这条路你们向来没有走过。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS3_5","007_3_5","JOS","3","5","5","约书亚吩咐百姓说：「你们要自洁，因为明天耶和华必在你们中间行奇事。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS3_6","007_3_6","JOS","3","6","6","约书亚又吩咐祭司说：「你们抬起约柜，在百姓前头过去。」于是他们抬起约柜，在百姓前头走。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS3_7","007_3_7","JOS","3","7","7","耶和华对约书亚说：「从今日起，我必使你在以色列众人眼前尊大，使他们知道我怎样与摩西同在，也必照样与你同在。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS3_8","007_3_8","JOS","3","8","8","你要吩咐抬约柜的祭司说：『你们到了约旦河的水边上，就要在约旦河水里站住。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS3_9","007_3_9","JOS","3","9","9","约书亚对以色列人说：「你们近前来，听耶和华—你们　神的话。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS3_10","007_3_10","JOS","3","10","11","约书亚说：「看哪，普天下主的约柜必在你们前头过去，到约旦河里，因此你们就知道在你们中间有永生　神；并且他必在你们面前赶出迦南人、赫人、希未人、比利洗人、革迦撒人、亚摩利人、耶布斯人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS3_12","007_3_12","JOS","3","12","12","你们现在要从以色列支派中拣选十二个人，每支派一人， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS3_13","007_3_13","JOS","3","13","13","等到抬普天下主耶和华约柜的祭司把脚站在约旦河水里，约旦河的水，就是从上往下流的水，必然断绝，立起成垒。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS3_14","007_3_14","JOS","3","14","14","百姓离开帐棚要过约旦河的时候，抬约柜的祭司乃在百姓的前头。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS3_15","007_3_15","JOS","3","15","15","他们到了约旦河，脚一入水（原来约旦河水在收割的日子涨过两岸）， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS3_16","007_3_16","JOS","3","16","16","那从上往下流的水便在极远之地、撒拉但旁的亚当城那里停住，立起成垒；那往亚拉巴的海，就是盐海，下流的水全然断绝。于是百姓在耶利哥的对面过去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS3_17","007_3_17","JOS","3","17","17","抬耶和华约柜的祭司在约旦河中的干地上站定，以色列众人都从干地上过去，直到国民尽都过了约旦河。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS4_1","007_4_1","JOS","4","1","1","国民尽都过了约旦河，耶和华就对约书亚说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS4_2","007_4_2","JOS","4","2","2","「你从民中要拣选十二个人，每支派一人， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS4_3","007_4_3","JOS","4","3","3","吩咐他们说：『你们从这里，从约旦河中、祭司脚站定的地方，取十二块石头带过去，放在你们今夜要住宿的地方。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS4_4","007_4_4","JOS","4","4","4","于是，约书亚将他从以色列人中所预备的那十二个人，每支派一人，都召了来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS4_5","007_4_5","JOS","4","5","5","对他们说：「你们下约旦河中，过到耶和华—你们　神的约柜前头，按着以色列人十二支派的数目，每人取一块石头扛在肩上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS4_6","007_4_6","JOS","4","6","6","这些石头在你们中间可以作为证据。日后，你们的子孙问你们说：『这些石头是什么意思？』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS4_7","007_4_7","JOS","4","7","7","你们就对他们说：『这是因为约旦河的水在耶和华的约柜前断绝；约柜过约旦河的时候，约旦河的水就断绝了。这些石头要作以色列人永远的纪念。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS4_8","007_4_8","JOS","4","8","8","以色列人就照约书亚所吩咐的，按着以色列人支派的数目，从约旦河中取了十二块石头，都遵耶和华所吩咐约书亚的行了。他们把石头带过去，到他们所住宿的地方，就放在那里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS4_9","007_4_9","JOS","4","9","9","约书亚另把十二块石头立在约旦河中，在抬约柜的祭司脚站立的地方；直到今日，那石头还在那里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS4_10","007_4_10","JOS","4","10","10","抬约柜的祭司站在约旦河中，等到耶和华晓谕约书亚吩咐百姓的事办完了，是照摩西所吩咐约书亚的一切话。于是百姓急速过去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS4_11","007_4_11","JOS","4","11","11","众百姓尽都过了河，耶和华的约柜和祭司就在百姓面前过去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS4_12","007_4_12","JOS","4","12","12","吕便人、迦得人、玛拿西半支派的人都照摩西所吩咐他们的，带着兵器在以色列人前头过去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS4_13","007_4_13","JOS","4","13","13","约有四万人都准备打仗，在耶和华面前过去，到耶利哥的平原，等候上阵。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS4_14","007_4_14","JOS","4","14","14","当那日，耶和华使约书亚在以色列众人眼前尊大。在他平生的日子，百姓敬畏他，像从前敬畏摩西一样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS4_15","007_4_15","JOS","4","15","15","耶和华晓谕约书亚说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS4_16","007_4_16","JOS","4","16","16","「你吩咐抬法柜的祭司从约旦河里上来。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS4_17","007_4_17","JOS","4","17","17","约书亚就吩咐祭司说：「你们从约旦河里上来。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS4_18","007_4_18","JOS","4","18","18","抬耶和华约柜的祭司从约旦河里上来，脚掌刚落旱地，约旦河的水就流到原处，仍旧涨过两岸。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS4_19","007_4_19","JOS","4","19","19","正月初十日，百姓从约旦河里上来，就在吉甲，在耶利哥的东边安营。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS4_20","007_4_20","JOS","4","20","20","他们从约旦河中取来的那十二块石头，约书亚就立在吉甲， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS4_21","007_4_21","JOS","4","21","21","对以色列人说：「日后你们的子孙问他们的父亲说：『这些石头是什么意思？』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS4_22","007_4_22","JOS","4","22","22","你们就告诉他们说：『以色列人曾走干地过这约旦河； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS4_23","007_4_23","JOS","4","23","23","因为耶和华—你们的　神在你们前面使约旦河的水干了，等着你们过来，就如耶和华—你们的　神从前在我们前面使红海干了，等着我们过来一样， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS4_24","007_4_24","JOS","4","24","24","要使地上万民都知道，耶和华的手大有能力，也要使你们永远敬畏耶和华—你们的　神。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS5_1","007_5_1","JOS","5","1","1","约旦河西亚摩利人的诸王和靠海迦南人的诸王，听见耶和华在以色列人前面使约旦河的水干了，等到我们过去，他们的心因以色列人的缘故就消化了，不再有胆气。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS5_2","007_5_2","JOS","5","2","2","那时，耶和华吩咐约书亚说：「你制造火石刀，第二次给以色列人行割礼。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS5_3","007_5_3","JOS","5","3","3","约书亚就制造了火石刀，在「除皮山」那里给以色列人行割礼。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS5_4","007_5_4","JOS","5","4","4","约书亚行割礼的缘故，是因为从埃及出来的众民，就是一切能打仗的男丁，出了埃及以后，都死在旷野的路上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS5_5","007_5_5","JOS","5","5","5","因为出来的众民都受过割礼；惟独出埃及以后、在旷野的路上所生的众民都没有受过割礼。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS5_6","007_5_6","JOS","5","6","6","以色列人在旷野走了四十年，等到国民，就是出埃及的兵丁，都消灭了，因为他们没有听从耶和华的话。耶和华曾向他们起誓，必不容他们看见耶和华向他们列祖起誓、应许赐给我们的地，就是流奶与蜜之地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS5_7","007_5_7","JOS","5","7","7","他们的子孙，就是耶和华所兴起来接续他们的，都没有受过割礼；因为在路上没有给他们行割礼，约书亚这才给他们行了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS5_8","007_5_8","JOS","5","8","8","国民都受完了割礼，就住在营中自己的地方，等到痊愈了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS5_9","007_5_9","JOS","5","9","9","耶和华对约书亚说：「我今日将埃及的羞辱从你们身上滚去了。」因此，那地方名叫吉甲，直到今日。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS5_10","007_5_10","JOS","5","10","10","以色列人在吉甲安营。正月十四日晚上，在耶利哥的平原守逾越节。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS5_11","007_5_11","JOS","5","11","11","逾越节的次日，他们就吃了那地的出产；正当那日吃无酵饼和烘的谷。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS5_12","007_5_12","JOS","5","12","12","他们吃了那地的出产，第二日吗哪就止住了，以色列人也不再有吗哪了。那一年，他们却吃迦南地的出产。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS5_13","007_5_13","JOS","5","13","13","约书亚靠近耶利哥的时候，举目观看，不料，有一个人手里有拔出来的刀，对面站立。约书亚到他那里，问他说：「你是帮助我们呢，是帮助我们敌人呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS5_14","007_5_14","JOS","5","14","14","他回答说：「不是的，我来是要作耶和华军队的元帅。」约书亚就俯伏在地下拜，说：「我主有什么话吩咐仆人。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS5_15","007_5_15","JOS","5","15","15","耶和华军队的元帅对约书亚说：「把你脚上的鞋脱下来，因为你所站的地方是圣的。」约书亚就照着行了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS6_1","007_6_1","JOS","6","1","1","耶利哥的城门因以色列人就关得严紧，无人出入。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS6_2","007_6_2","JOS","6","2","2","耶和华晓谕约书亚说：「看哪，我已经把耶利哥和耶利哥的王，并大能的勇士，都交在你手中。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS6_3","007_6_3","JOS","6","3","3","你们的一切兵丁要围绕这城，一日围绕一次，六日都要这样行。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS6_4","007_6_4","JOS","6","4","4","七个祭司要拿七个羊角走在约柜前。到第七日，你们要绕城七次，祭司也要吹角。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS6_5","007_6_5","JOS","6","5","5","他们吹的角声拖长，你们听见角声，众百姓要大声呼喊，城墙就必塌陷，各人都要往前直上。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS6_6","007_6_6","JOS","6","6","6","嫩的儿子约书亚召了祭司来，吩咐他们说：「你们抬起约柜来，要有七个祭司拿七个羊角走在耶和华的约柜前」； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS6_7","007_6_7","JOS","6","7","7","又对百姓说：「你们前去绕城，带兵器的要走在耶和华的约柜前。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS6_8","007_6_8","JOS","6","8","8","约书亚对百姓说完了话，七个祭司拿七个羊角走在耶和华面前吹角；耶和华的约柜在他们后面跟随。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS6_9","007_6_9","JOS","6","9","9","带兵器的走在吹角的祭司前面，后队随着约柜行。祭司一面走一面吹。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS6_10","007_6_10","JOS","6","10","10","约书亚吩咐百姓说：「你们不可呼喊，不可出声，连一句话也不可出你们的口，等到我吩咐你们呼喊的日子，那时才可以呼喊。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS6_11","007_6_11","JOS","6","11","11","这样，他使耶和华的约柜绕城，把城绕了一次；众人回到营里，就在营里住宿。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS6_12","007_6_12","JOS","6","12","12","约书亚清早起来，祭司又抬起耶和华的约柜。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS6_13","007_6_13","JOS","6","13","13","七个祭司拿七个羊角在耶和华的约柜前，时常行走吹角；带兵器的在他们前面走，后队随着耶和华的约柜行。祭司一面走一面吹。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS6_14","007_6_14","JOS","6","14","14","第二日，众人把城绕了一次，就回营里去。六日都是这样行。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS6_15","007_6_15","JOS","6","15","15","第七日清早，黎明的时候，他们起来，照样绕城七次；惟独这日把城绕了七次。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS6_16","007_6_16","JOS","6","16","16","到了第七次，祭司吹角的时候，约书亚吩咐百姓说：「呼喊吧，因为耶和华已经把城交给你们了！ ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS6_17","007_6_17","JOS","6","17","17","这城和其中所有的都要在耶和华面前毁灭；只有妓女喇合与她家中所有的可以存活，因为她隐藏了我们所打发的使者。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS6_18","007_6_18","JOS","6","18","18","至于你们，务要谨慎，不可取那当灭的物，恐怕你们取了那当灭的物就连累以色列的全营，使全营受咒诅。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS6_19","007_6_19","JOS","6","19","19","惟有金子、银子，和铜铁的器皿都要归耶和华为圣，必入耶和华的库中。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS6_20","007_6_20","JOS","6","20","20","于是百姓呼喊，祭司也吹角。百姓听见角声，便大声呼喊，城墙就塌陷，百姓便上去进城，各人往前直上，将城夺取； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS6_21","007_6_21","JOS","6","21","21","又将城中所有的，不拘男女老少，牛羊和驴，都用刀杀尽。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS6_22","007_6_22","JOS","6","22","22","约书亚吩咐窥探地的两个人说：「你们进那妓女的家，照着你们向她所起的誓，将那女人和她所有的都从那里带出来。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS6_23","007_6_23","JOS","6","23","23","当探子的两个少年人就进去，将喇合与她的父母、弟兄，和她所有的，并她一切的亲眷，都带出来，安置在以色列的营外。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS6_24","007_6_24","JOS","6","24","24","众人就用火将城和其中所有的焚烧了；惟有金子、银子，和铜铁的器皿都放在耶和华殿的库中。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS6_25","007_6_25","JOS","6","25","25","约书亚却把妓女喇合与她父家，并她所有的，都救活了；因为她隐藏了约书亚所打发窥探耶利哥的使者，她就住在以色列中，直到今日。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS6_26","007_6_26","JOS","6","26","26","当时，约书亚叫众人起誓说：「有兴起重修这耶利哥城的人，当在耶和华面前受咒诅。 他立根基的时候，必丧长子， 安门的时候，必丧幼子。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS6_27","007_6_27","JOS","6","27","27","耶和华与约书亚同在，约书亚的声名传扬遍地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS7_1","007_7_1","JOS","7","1","1","以色列人在当灭的物上犯了罪；因为犹大支派中，谢拉的曾孙，撒底的孙子，迦米的儿子亚干取了当灭的物；耶和华的怒气就向以色列人发作。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS7_2","007_7_2","JOS","7","2","2","当下，约书亚从耶利哥打发人往伯特利东边、靠近伯·亚文的艾城去，吩咐他们说：「你们上去窥探那地。」他们就上去窥探艾城。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS7_3","007_7_3","JOS","7","3","3","他们回到约书亚那里，对他说：「众民不必都上去，只要二三千人上去就能攻取艾城；不必劳累众民都去，因为那里的人少。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS7_4","007_7_4","JOS","7","4","4","于是民中约有三千人上那里去，竟在艾城人面前逃跑了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS7_5","007_7_5","JOS","7","5","5","艾城的人击杀了他们三十六人，从城门前追赶他们，直到示巴琳，在下坡杀败他们；众民的心就消化如水。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS7_6","007_7_6","JOS","7","6","6","约书亚便撕裂衣服；他和以色列的长老把灰撒在头上，在耶和华的约柜前俯伏在地，直到晚上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS7_7","007_7_7","JOS","7","7","7","约书亚说：「哀哉！主耶和华啊，你为什么竟领这百姓过约旦河，将我们交在亚摩利人的手中，使我们灭亡呢？我们不如住在约旦河那边倒好。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS7_8","007_7_8","JOS","7","8","8","主啊，以色列人既在仇敌面前转背逃跑，我还有什么可说的呢？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS7_9","007_7_9","JOS","7","9","9","迦南人和这地一切的居民听见了就必围困我们，将我们的名从地上除灭。那时你为你的大名要怎样行呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS7_10","007_7_10","JOS","7","10","10","耶和华吩咐约书亚说：「起来！你为何这样俯伏在地呢？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS7_11","007_7_11","JOS","7","11","11","以色列人犯了罪，违背了我所吩咐他们的约，取了当灭的物；又偷窃，又行诡诈，又把那当灭的放在他们的家具里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS7_12","007_7_12","JOS","7","12","12","因此，以色列人在仇敌面前站立不住。他们在仇敌面前转背逃跑，是因成了被咒诅的；你们若不把当灭的物从你们中间除掉，我就不再与你们同在了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS7_13","007_7_13","JOS","7","13","13","你起来，叫百姓自洁，对他们说：『你们要自洁，预备明天，因为耶和华—以色列的　神这样说：以色列啊，你们中间有当灭的物，你们若不除掉，在仇敌面前必站立不住！』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS7_14","007_7_14","JOS","7","14","14","到了早晨，你们要按着支派近前来；耶和华所取的支派，要按着宗族近前来；耶和华所取的宗族，要按着家室近前来；耶和华所取的家室，要按着人丁，一个一个地近前来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS7_15","007_7_15","JOS","7","15","15","被取的人有当灭的物在他那里，他和他所有的必被火焚烧；因他违背了耶和华的约，又因他在以色列中行了愚妄的事。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS7_16","007_7_16","JOS","7","16","16","于是，约书亚清早起来，使以色列人按着支派近前来，取出来的是犹大支派； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS7_17","007_7_17","JOS","7","17","17","使犹大支派近前来，就取了谢拉的宗族；使谢拉的宗族，按着家室人丁，一个一个地近前来，取出来的是撒底； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS7_18","007_7_18","JOS","7","18","18","使撒底的家室，按着人丁，一个一个地近前来，就取出犹大支派的人谢拉的曾孙，撒底的孙子，迦米的儿子亚干。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS7_19","007_7_19","JOS","7","19","19","约书亚对亚干说：「我儿，我劝你将荣耀归给耶和华—以色列的　神，在他面前认罪，将你所做的事告诉我，不要向我隐瞒。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS7_20","007_7_20","JOS","7","20","20","亚干回答约书亚说：「我实在得罪了耶和华—以色列的　神。我所做的事如此如此： ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS7_21","007_7_21","JOS","7","21","21","我在所夺的财物中看见一件美好的示拿衣服，二百舍客勒银子，一条金子重五十舍客勒，我就贪爱这些物件，便拿去了。现今藏在我帐棚内的地里，银子在衣服底下。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS7_22","007_7_22","JOS","7","22","22","约书亚就打发人跑到亚干的帐棚里。那件衣服果然藏在他帐棚内，银子在底下。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS7_23","007_7_23","JOS","7","23","23","他们就从帐棚里取出来，拿到约书亚和以色列众人那里，放在耶和华面前。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS7_24","007_7_24","JOS","7","24","24","约书亚和以色列众人把谢拉的曾孙亚干和那银子、那件衣服、那条金子，并亚干的儿女、牛、驴、羊、帐棚，以及他所有的，都带到亚割谷去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS7_25","007_7_25","JOS","7","25","25","约书亚说：「你为什么连累我们呢？今日耶和华必叫你受连累。」于是以色列众人用石头打死他，将石头扔在其上，又用火焚烧他所有的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS7_26","007_7_26","JOS","7","26","26","众人在亚干身上堆成一大堆石头，直存到今日。于是耶和华转意，不发他的烈怒。因此那地方名叫亚割谷，直到今日。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS8_1","007_8_1","JOS","8","1","1","耶和华对约书亚说：「不要惧怕，也不要惊惶。你起来，率领一切兵丁上艾城去，我已经把艾城的王和他的民、他的城，并他的地，都交在你手里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS8_2","007_8_2","JOS","8","2","2","你怎样待耶利哥和耶利哥的王，也当照样待艾城和艾城的王。只是城内所夺的财物和牲畜，你们可以取为自己的掠物。你要在城后设下伏兵。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS8_3","007_8_3","JOS","8","3","3","于是，约书亚和一切兵丁都起来，要上艾城去。约书亚选了三万大能的勇士，夜间打发他们前往， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS8_4","007_8_4","JOS","8","4","4","吩咐他们说：「你们要在城后埋伏，不可离城太远，都要各自准备。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS8_5","007_8_5","JOS","8","5","5","我与我所带领的众民要向城前往。城里的人像初次出来攻击我们的时候，我们就在他们面前逃跑， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS8_6","007_8_6","JOS","8","6","6","他们必出来追赶我们，直到我们引诱他们离开城；因为他们必说：『这些人像初次在我们面前逃跑。』所以我们要在他们面前逃跑， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS8_7","007_8_7","JOS","8","7","7","你们就从埋伏的地方起来，夺取那城，因为耶和华—你们的　神必把城交在你们手里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS8_8","007_8_8","JOS","8","8","8","你们夺了城以后，就放火烧城，要照耶和华的话行。这是我吩咐你们的。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS8_9","007_8_9","JOS","8","9","9","约书亚打发他们前往，他们就上埋伏的地方去，住在伯特利和艾城的中间，就是在艾城的西边。这夜约书亚却在民中住宿。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS8_10","007_8_10","JOS","8","10","10","约书亚清早起来，点齐百姓，他和以色列的长老在百姓前面上艾城去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS8_11","007_8_11","JOS","8","11","11","众民，就是他所带领的兵丁，都上去，向前直往，来到城前，在艾城北边安营。在约书亚和艾城中间有一山谷。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS8_12","007_8_12","JOS","8","12","12","他挑了约有五千人，使他们埋伏在伯特利和艾城的中间，就是在艾城的西边， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS8_13","007_8_13","JOS","8","13","13","于是安置了百姓，就是城北的全军和城西的伏兵。这夜约书亚进入山谷之中。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS8_14","007_8_14","JOS","8","14","14","艾城的王看见这景况，就和全城的人，清早急忙起来，按所定的时候，出到亚拉巴前，要与以色列人交战；王却不知道在城后有伏兵。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS8_15","007_8_15","JOS","8","15","15","约书亚和以色列众人在他们面前装败，往那通旷野的路逃跑。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS8_16","007_8_16","JOS","8","16","16","城内的众民都被招聚，追赶他们；艾城人追赶的时候，就被引诱离开城。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS8_17","007_8_17","JOS","8","17","17","艾城和伯特利城没有一人不出来追赶以色列人的，撇了敞开的城门，去追赶以色列人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS8_18","007_8_18","JOS","8","18","18","耶和华吩咐约书亚说：「你向艾城伸出手里的短枪，因为我要将城交在你手里。」约书亚就向城伸出手里的短枪。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS8_19","007_8_19","JOS","8","19","19","他一伸手，伏兵就从埋伏的地方急忙起来，夺了城，跑进城去，放火焚烧。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS8_20","007_8_20","JOS","8","20","20","艾城的人回头一看，不料，城中烟气冲天，他们就无力向左向右逃跑。那往旷野逃跑的百姓便转身攻击追赶他们的人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS8_21","007_8_21","JOS","8","21","21","约书亚和以色列众人见伏兵已经夺了城，城中烟气飞腾，就转身回去，击杀艾城的人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS8_22","007_8_22","JOS","8","22","22","伏兵也出城迎击艾城人，艾城人就困在以色列人中间，前后都是以色列人。于是以色列人击杀他们，没有留下一个，也没有一个逃脱的， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS8_23","007_8_23","JOS","8","23","23","生擒了艾城的王，将他解到约书亚那里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS8_24","007_8_24","JOS","8","24","24","以色列人在田间和旷野杀尽所追赶一切艾城的居民。艾城人倒在刀下，直到灭尽；以色列众人就回到艾城，用刀杀了城中的人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS8_25","007_8_25","JOS","8","25","25","当日杀毙的人，连男带女共有一万二千，就是艾城所有的人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS8_26","007_8_26","JOS","8","26","26","约书亚没有收回手里所伸出来的短枪，直到把艾城的一切居民尽行杀灭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS8_27","007_8_27","JOS","8","27","27","惟独城中的牲畜和财物，以色列人都取为自己的掠物，是照耶和华所吩咐约书亚的话。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS8_28","007_8_28","JOS","8","28","28","约书亚将艾城焚烧，使城永为高堆、荒场，直到今日； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS8_29","007_8_29","JOS","8","29","29","又将艾城王挂在树上，直到晚上。日落的时候，约书亚吩咐人把尸首从树上取下来，丢在城门口，在尸首上堆成一大堆石头，直存到今日。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS8_30","007_8_30","JOS","8","30","30","那时，约书亚在以巴路山上为耶和华—以色列的　神筑一座坛， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS8_31","007_8_31","JOS","8","31","31","是用没有动过铁器的整石头筑的，照着耶和华仆人摩西所吩咐以色列人的话，正如摩西律法书上所写的。众人在这坛上给耶和华奉献燔祭和平安祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS8_32","007_8_32","JOS","8","32","32","约书亚在那里，当着以色列人面前，将摩西所写的律法抄写在石头上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS8_33","007_8_33","JOS","8","33","33","以色列众人，无论是本地人、是寄居的，和长老、官长，并审判官，都站在约柜两旁，在抬耶和华约柜的祭司利未人面前，一半对着基利心山，一半对着以巴路山，为以色列民祝福，正如耶和华仆人摩西先前所吩咐的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS8_34","007_8_34","JOS","8","34","34","随后，约书亚将律法上祝福、咒诅的话，照着律法书上一切所写的，都宣读了一遍。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS8_35","007_8_35","JOS","8","35","35","摩西所吩咐的一切话，约书亚在以色列全会众和妇女、孩子，并他们中间寄居的外人面前，没有一句不宣读的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS9_1","007_9_1","JOS","9","1","1","约旦河西，住山地、高原，并对着黎巴嫩山沿大海一带的诸王，就是赫人、亚摩利人、迦南人、比利洗人、希未人、耶布斯人的诸王，听见这事， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS9_2","007_9_2","JOS","9","2","2","就都聚集，同心合意地要与约书亚和以色列人争战。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS9_3","007_9_3","JOS","9","3","3","基遍的居民听见约书亚向耶利哥和艾城所行的事， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS9_4","007_9_4","JOS","9","4","4","就设诡计，假充使者，拿旧口袋和破裂缝补的旧皮酒袋驮在驴上， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS9_5","007_9_5","JOS","9","5","5","将补过的旧鞋穿在脚上，把旧衣服穿在身上；他们所带的饼都是干的，长了霉了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS9_6","007_9_6","JOS","9","6","6","他们到吉甲营中见约书亚，对他和以色列人说：「我们是从远方来的，现在求你与我们立约。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS9_7","007_9_7","JOS","9","7","7","以色列人对这些希未人说：「只怕你们是住在我们中间的；若是这样，怎能和你们立约呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS9_8","007_9_8","JOS","9","8","8","他们对约书亚说：「我们是你的仆人。」约书亚问他们说：「你们是什么人？是从哪里来的？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS9_9","007_9_9","JOS","9","9","9","他们回答说：「仆人从极远之地而来，是因听见耶和华—你　神的名声和他在埃及所行的一切事， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS9_10","007_9_10","JOS","9","10","10","并他向约旦河东的两个亚摩利王，就是希实本王西宏和在亚斯他录的巴珊王噩一切所行的事。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS9_11","007_9_11","JOS","9","11","11","我们的长老和我们那地的一切居民对我们说：『你们手里要带着路上用的食物去迎接以色列人，对他们说：我们是你们的仆人；现在求你们与我们立约。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS9_12","007_9_12","JOS","9","12","12","我们出来要往你们这里来的日子，从家里带出来的这饼还是热的；看哪，现在都干了，长了霉了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS9_13","007_9_13","JOS","9","13","13","这皮酒袋，我们盛酒的时候还是新的；看哪，现在已经破裂。我们这衣服和鞋，因为道路甚远，也都穿旧了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS9_14","007_9_14","JOS","9","14","14","以色列人受了他们些食物，并没有求问耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS9_15","007_9_15","JOS","9","15","15","于是约书亚与他们讲和，与他们立约，容他们活着；会众的首领也向他们起誓。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS9_16","007_9_16","JOS","9","16","16","以色列人与他们立约之后，过了三天才听见他们是近邻，住在以色列人中间的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS9_17","007_9_17","JOS","9","17","17","以色列人起行，第三天到了他们的城邑，就是基遍、基非拉、比录、基列·耶琳。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS9_18","007_9_18","JOS","9","18","18","因为会众的首领已经指着耶和华—以色列的　神向他们起誓，所以以色列人不击杀他们；全会众就向首领发怨言。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS9_19","007_9_19","JOS","9","19","19","众首领对全会众说：「我们已经指着耶和华—以色列的　神向他们起誓，现在我们不能害他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS9_20","007_9_20","JOS","9","20","20","我们要如此待他们，容他们活着，免得有忿怒因我们所起的誓临到我们身上。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS9_21","007_9_21","JOS","9","21","21","首领又对会众说：「要容他们活着。」于是他们为全会众作了劈柴挑水的人，正如首领对他们所说的话。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS9_22","007_9_22","JOS","9","22","22","约书亚召了他们来，对他们说：「为什么欺哄我们说『我们离你们甚远』呢？其实你们是住在我们中间。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS9_23","007_9_23","JOS","9","23","23","现在你们是被咒诅的！你们中间的人必断不了作奴仆，为我　神的殿作劈柴挑水的人。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS9_24","007_9_24","JOS","9","24","24","他们回答约书亚说：「因为有人实在告诉你的仆人，耶和华—你的　神曾吩咐他的仆人摩西，把这全地赐给你们，并在你们面前灭绝这地的一切居民，所以我们为你们的缘故甚怕丧命，就行了这事。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS9_25","007_9_25","JOS","9","25","25","现在我们在你手中，你以怎样待我们为善为正，就怎样做吧！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS9_26","007_9_26","JOS","9","26","26","于是约书亚这样待他们，救他们脱离以色列人的手，以色列人就没有杀他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS9_27","007_9_27","JOS","9","27","27","当日约书亚使他们在耶和华所要选择的地方，为会众和耶和华的坛作劈柴挑水的人，直到今日。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS10_1","007_10_1","JOS","10","1","1","耶路撒冷王亚多尼·洗德听见约书亚夺了艾城，尽行毁灭，怎样待耶利哥和耶利哥的王，也照样待艾城和艾城的王，又听见基遍的居民与以色列人立了和约，住在他们中间， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS10_2","007_10_2","JOS","10","2","2","就甚惧怕；因为基遍是一座大城，如都城一般，比艾城更大，并且城内的人都是勇士。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS10_3","007_10_3","JOS","10","3","3","所以耶路撒冷王亚多尼·洗德打发人去见希伯 王何咸、耶末王毗兰、拉吉王雅非亚，和伊矶伦王底璧，说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS10_4","007_10_4","JOS","10","4","4","「求你们上来帮助我，我们好攻打基遍，因为他们与约书亚和以色列人立了和约。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS10_5","007_10_5","JOS","10","5","5","于是五个亚摩利王，就是耶路撒冷王、希伯 王、耶末王、拉吉王、伊矶伦王，大家聚集，率领他们的众军上去，对着基遍安营，攻打基遍。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS10_6","007_10_6","JOS","10","6","6","基遍人就打发人往吉甲的营中去见约书亚，说：「你不要袖手不顾你的仆人，求你速速上来拯救我们，帮助我们，因为住山地亚摩利人的诸王都聚集攻击我们。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS10_7","007_10_7","JOS","10","7","7","于是约书亚和他一切兵丁，并大能的勇士，都从吉甲上去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS10_8","007_10_8","JOS","10","8","8","耶和华对约书亚说：「不要怕他们；因为我已将他们交在你手里，他们无一人能在你面前站立得住。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS10_9","007_10_9","JOS","10","9","9","约书亚就终夜从吉甲上去，猛然临到他们那里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS10_10","007_10_10","JOS","10","10","10","耶和华使他们在以色列人面前溃乱。约书亚在基遍大大地杀败他们，追赶他们，在伯·和 的上坡路击杀他们，直到亚西加和玛基大。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS10_11","007_10_11","JOS","10","11","11","他们在以色列人面前逃跑，正在伯·和 下坡的时候，耶和华从天上降大冰雹在他们身上，直降到亚西加，打死他们。被冰雹打死的，比以色列人用刀杀死的还多。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS10_12","007_10_12","JOS","10","12","12","当耶和华将亚摩利人交付以色列人的日子，约书亚就祷告耶和华，在以色列人眼前说： 日头啊，你要停在基遍； 月亮啊，你要止在亚雅 谷。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS10_13","007_10_13","JOS","10","13","13","于是日头停留，月亮止住， 直等国民向敌人报仇。 这事岂不是写在雅煞珥书上吗？日头在天当中停住，不急速下落，约有一日之久。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS10_14","007_10_14","JOS","10","14","14","在这日以前，这日以后，耶和华听人的祷告，没有像这日的，是因耶和华为以色列争战。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS10_15","007_10_15","JOS","10","15","15","约书亚和以色列众人回到吉甲的营中。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS10_16","007_10_16","JOS","10","16","16","那五王逃跑，藏在玛基大洞里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS10_17","007_10_17","JOS","10","17","17","有人告诉约书亚说：「那五王已经找到了，都藏在玛基大洞里。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS10_18","007_10_18","JOS","10","18","18","约书亚说：「你们把几块大石头滚到洞口，派人看守， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS10_19","007_10_19","JOS","10","19","19","你们却不可耽延，要追赶你们的仇敌，击杀他们尽后边的人，不容他们进自己的城邑，因为耶和华—你们的　神已经把他们交在你们手里。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS10_20","007_10_20","JOS","10","20","20","约书亚和以色列人大大杀败他们，直到将他们灭尽；其中剩下的人都进了坚固的城。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS10_21","007_10_21","JOS","10","21","21","众百姓就安然回玛基大营中，到约书亚那里。没有一人敢向以色列人饶舌。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS10_22","007_10_22","JOS","10","22","22","约书亚说：「打开洞口，将那五王从洞里带出来，领到我面前。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS10_23","007_10_23","JOS","10","23","23","众人就这样行，将那五王，就是耶路撒冷王、希伯 王、耶末王、拉吉王、伊矶伦王，从洞里带出来，领到约书亚面前。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS10_24","007_10_24","JOS","10","24","24","带出那五王到约书亚面前的时候，约书亚就召了以色列众人来，对那些和他同去的军长说：「你们近前来，把脚踏在这些王的颈项上。」他们就近前来，把脚踏在这些王的颈项上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS10_25","007_10_25","JOS","10","25","25","约书亚对他们说：「你们不要惧怕，也不要惊惶。应当刚强壮胆，因为耶和华必这样待你们所要攻打的一切仇敌。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS10_26","007_10_26","JOS","10","26","26","随后约书亚将这五王杀死，挂在五棵树上。他们就在树上直挂到晚上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS10_27","007_10_27","JOS","10","27","27","日头要落的时候，约书亚一吩咐，人就把尸首从树上取下来，丢在他们藏过的洞里，把几块大石头放在洞口，直存到今日。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS10_28","007_10_28","JOS","10","28","28","当日，约书亚夺了玛基大，用刀击杀城中的人和王；将其中一切人口尽行杀灭，没有留下一个。他待玛基大王，像从前待耶利哥王一样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS10_29","007_10_29","JOS","10","29","29","约书亚和以色列众人从玛基大往立拿去，攻打立拿。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS10_30","007_10_30","JOS","10","30","30","耶和华将立拿和立拿的王也交在以色列人手里。约书亚攻打这城，用刀击杀了城中的一切人口，没有留下一个。他待立拿王，像从前待耶利哥王一样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS10_31","007_10_31","JOS","10","31","31","约书亚和以色列众人从立拿往拉吉去，对着拉吉安营，攻打这城。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS10_32","007_10_32","JOS","10","32","32","耶和华将拉吉交在以色列人的手里。第二天约书亚就夺了拉吉，用刀击杀了城中的一切人口，是照他向立拿一切所行的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS10_33","007_10_33","JOS","10","33","33","那时基色王荷兰上来帮助拉吉，约书亚就把他和他的民都击杀了，没有留下一个。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS10_34","007_10_34","JOS","10","34","34","约书亚和以色列众人从拉吉往伊矶伦去，对着伊矶伦安营，攻打这城。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS10_35","007_10_35","JOS","10","35","35","当日就夺了城，用刀击杀了城中的人。那日，约书亚将城中的一切人口尽行杀灭，是照他向拉吉一切所行的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS10_36","007_10_36","JOS","10","36","36","约书亚和以色列众人从伊矶伦上希伯 去，攻打这城， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS10_37","007_10_37","JOS","10","37","37","就夺了希伯 和属希伯 的诸城邑，用刀将城中的人与王，并那些城邑中的人口，都击杀了，没有留下一个，是照他向伊矶伦所行的，把城中的一切人口尽行杀灭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS10_38","007_10_38","JOS","10","38","38","约书亚和以色列众人回到底璧，攻打这城， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS10_39","007_10_39","JOS","10","39","39","就夺了底璧和属底璧的城邑，又擒获底璧的王，用刀将这些城中的人口尽行杀灭，没有留下一个。他待底璧和底璧王，像从前待希伯 和立拿与立拿王一样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS10_40","007_10_40","JOS","10","40","40","这样，约书亚击杀全地的人，就是山地、南地、高原、山坡的人，和那些地的诸王，没有留下一个。将凡有气息的尽行杀灭，正如耶和华—以色列的　神所吩咐的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS10_41","007_10_41","JOS","10","41","41","约书亚从加低斯·巴尼亚攻击到迦萨，又攻击歌珊全地，直到基遍。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS10_42","007_10_42","JOS","10","42","42","约书亚一时杀败了这些王，并夺了他们的地，因为耶和华—以色列的　神为以色列争战。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS10_43","007_10_43","JOS","10","43","43","于是约书亚和以色列众人回到吉甲的营中。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS11_1","007_11_1","JOS","11","1","1","夏琐王耶宾听见这事，就打发人去见玛顿王约巴、伸 王、押煞王， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS11_2","007_11_2","JOS","11","2","2","与北方山地、基尼烈南边的亚拉巴高原，并西边多珥山冈的诸王； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS11_3","007_11_3","JOS","11","3","3","又去见东方和西方的迦南人，与山地的亚摩利人、赫人、比利洗人、耶布斯人，并黑门山根米斯巴地的希未人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS11_4","007_11_4","JOS","11","4","4","这些王和他们的众军都出来，人数多如海边的沙，并有许多马匹车辆。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS11_5","007_11_5","JOS","11","5","5","这诸王会合，来到米伦水边，一同安营，要与以色列人争战。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS11_6","007_11_6","JOS","11","6","6","耶和华对约书亚说：「你不要因他们惧怕。明日这时，我必将他们交付以色列人全然杀了。你要砍断他们马的蹄筋，用火焚烧他们的车辆。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS11_7","007_11_7","JOS","11","7","7","于是约书亚率领一切兵丁，在米伦水边突然向前攻打他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS11_8","007_11_8","JOS","11","8","8","耶和华将他们交在以色列人手里，以色列人就击杀他们，追赶他们到西顿大城，到米斯利弗·玛音，直到东边米斯巴的平原，将他们击杀，没有留下一个。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS11_9","007_11_9","JOS","11","9","9","约书亚就照耶和华所吩咐他的去行，砍断他们马的蹄筋，用火焚烧他们的车辆。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS11_10","007_11_10","JOS","11","10","10","当时，约书亚转回夺了夏琐，用刀击杀夏琐王。（素来夏琐在这诸国中是为首的。） ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS11_11","007_11_11","JOS","11","11","11","以色列人用刀击杀城中的人口，将他们尽行杀灭；凡有气息的没有留下一个。约书亚又用火焚烧夏琐。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS11_12","007_11_12","JOS","11","12","12","约书亚夺了这些王的一切城邑，擒获其中的诸王，用刀击杀他们，将他们尽行杀灭，正如耶和华仆人摩西所吩咐的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS11_13","007_11_13","JOS","11","13","13","至于造在山冈上的城，除了夏琐以外，以色列人都没有焚烧。约书亚只将夏琐焚烧了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS11_14","007_11_14","JOS","11","14","14","那些城邑所有的财物和牲畜，以色列人都取为自己的掠物；惟有一切人口都用刀击杀，直到杀尽；凡有气息的没有留下一个。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS11_15","007_11_15","JOS","11","15","15","耶和华怎样吩咐他仆人摩西，摩西就照样吩咐约书亚，约书亚也照样行。凡耶和华所吩咐摩西的，约书亚没有一件懈怠不行的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS11_16","007_11_16","JOS","11","16","16","约书亚夺了那全地，就是山地、一带南地、歌珊全地、高原、亚拉巴、以色列的山地，和山下的高原。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS11_17","007_11_17","JOS","11","17","17","从上西珥的哈拉山，直到黑门山下黎巴嫩平原的巴力·迦得，并且擒获那些地的诸王，将他们杀死。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS11_18","007_11_18","JOS","11","18","18","约书亚和这诸王争战了许多年日。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS11_19","007_11_19","JOS","11","19","19","除了基遍的希未人之外，没有一城与以色列人讲和的，都是以色列人争战夺来的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS11_20","007_11_20","JOS","11","20","20","因为耶和华的意思是要使他们心里刚硬，来与以色列人争战，好叫他们尽被杀灭，不蒙怜悯，正如耶和华所吩咐摩西的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS11_21","007_11_21","JOS","11","21","21","当时约书亚来到，将住山地、希伯 、底璧、亚拿伯、犹大山地、以色列山地所有的亚衲族人剪除了。约书亚将他们和他们的城邑尽都毁灭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS11_22","007_11_22","JOS","11","22","22","在以色列人的地没有留下一个亚衲族人，只在迦萨、迦特，和亚实突有留下的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS11_23","007_11_23","JOS","11","23","23","这样，约书亚照着耶和华所吩咐摩西的一切话夺了那全地，就按着以色列支派的宗族将地分给他们为业。于是国中太平，没有争战了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS12_1","007_12_1","JOS","12","1","1","以色列人在约旦河外向日出之地击杀二王，得他们的地，就是从亚嫩谷直到黑门山，并东边的全亚拉巴之地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS12_2","007_12_2","JOS","12","2","2","这二王，有住希实本、亚摩利人的王西宏。他所管之地是从亚嫩谷边的亚罗珥和谷中的城，并基列一半，直到亚扪人的境界，雅博河 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS12_3","007_12_3","JOS","12","3","3","与约旦河东边的亚拉巴，直到基尼烈海，又到亚拉巴的海，就是盐海，通伯·耶西末的路，以及南方，直到毗斯迦的山根。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS12_4","007_12_4","JOS","12","4","4","又有巴珊王噩。他是利乏音人所剩下的，住在亚斯他录和以得来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS12_5","007_12_5","JOS","12","5","5","他所管之地是黑门山、撒迦、巴珊全地，直到基述人和玛迦人的境界，并基列一半，直到希实本王西宏的境界。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS12_6","007_12_6","JOS","12","6","6","这二王是耶和华仆人摩西和以色列人所击杀的；耶和华仆人摩西将他们的地赐给吕便人、迦得人，和玛拿西半支派的人为业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS12_7","007_12_7","JOS","12","7","7","约书亚和以色列人在约旦河西击杀了诸王。他们的地是从黎巴嫩平原的巴力·迦得，直到上西珥的哈拉山。约书亚就将那地按着以色列支派的宗族分给他们为业， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS12_8","007_12_8","JOS","12","8","8","就是赫人、亚摩利人，迦南人、比利洗人、希未人、耶布斯人的山地、高原亚拉巴、山坡、旷野，和南地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS12_9","007_12_9","JOS","12","9","9","他们的王：一个是耶利哥王，一个是靠近伯特利的艾城王， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS12_10","007_12_10","JOS","12","10","10","一个是耶路撒冷王，一个是希伯 王， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS12_11","007_12_11","JOS","12","11","11","一个是耶末王，一个是拉吉王， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS12_12","007_12_12","JOS","12","12","12","一个是伊矶伦王，一个是基色王， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS12_13","007_12_13","JOS","12","13","13","一个是底璧王，一个是基德王， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS12_14","007_12_14","JOS","12","14","14","一个是何珥玛王，一个是亚拉得王， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS12_15","007_12_15","JOS","12","15","15","一个是立拿王，一个是亚杜兰王， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS12_16","007_12_16","JOS","12","16","16","一个是玛基大王，一个是伯特利王， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS12_17","007_12_17","JOS","12","17","17","一个是他普亚王，一个是希弗王， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS12_18","007_12_18","JOS","12","18","18","一个是亚弗王，一个是拉沙 王， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS12_19","007_12_19","JOS","12","19","19","一个是玛顿王，一个是夏琐王， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS12_20","007_12_20","JOS","12","20","20","一个是伸 ·米 王，一个是押煞王， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS12_21","007_12_21","JOS","12","21","21","一个是他纳王，一个是米吉多王， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS12_22","007_12_22","JOS","12","22","22","一个是基低斯王，一个是靠近迦密的约念王， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS12_23","007_12_23","JOS","12","23","23","一个是多珥山冈的多珥王，一个是吉甲的戈印王， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS12_24","007_12_24","JOS","12","24","24","一个是得撒王；共计三十一个王。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS13_1","007_13_1","JOS","13","1","1","约书亚年纪老迈，耶和华对他说：「你年纪老迈了，还有许多未得之地， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS13_2","007_13_2","JOS","13","2","2","就是非利士人的全境和基述人的全地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS13_3","007_13_3","JOS","13","3","3","从埃及前的西曷河往北，直到以革伦的境界，就算属迦南人之地。有非利士人五个首领所管的迦萨人、亚实突人、亚实基伦人、迦特人、以革伦人之地，并有南方亚卫人之地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS13_4","007_13_4","JOS","13","4","4","又有迦南人的全地，并属西顿人的米亚拉到亚弗，直到亚摩利人的境界。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS13_5","007_13_5","JOS","13","5","5","还有迦巴勒人之地，并向日出的全黎巴嫩，就是从黑门山根的巴力·迦得，直到哈马口。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS13_6","007_13_6","JOS","13","6","6","山地的一切居民，从黎巴嫩直到米斯利弗·玛音，就是所有的西顿人，我必在以色列人面前赶出他们去。你只管照我所吩咐的，将这地拈阄分给以色列人为业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS13_7","007_13_7","JOS","13","7","7","现在你要把这地分给九个支派和玛拿西半个支派为业。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS13_8","007_13_8","JOS","13","8","8","玛拿西那半支派和吕便、迦得二支派已经受了产业，就是耶和华的仆人摩西在约旦河东所赐给他们的： ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS13_9","007_13_9","JOS","13","9","9","是从亚嫩谷边的亚罗珥和谷中的城，并米底巴的全平原，直到底本， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS13_10","007_13_10","JOS","13","10","10","和在希实本作王亚摩利王西宏的诸城，直到亚扪人的境界； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS13_11","007_13_11","JOS","13","11","11","又有基列地、基述人、玛迦人的地界，并黑门全山、巴珊全地，直到撒迦； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS13_12","007_13_12","JOS","13","12","12","又有巴珊王噩的全国—他在亚斯他录和以得来作王（利乏音人所存留的只剩下他）。这些地的人都是摩西所击杀、所赶逐的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS13_13","007_13_13","JOS","13","13","13","以色列人却没有赶逐基述人、玛迦人；这些人仍住在以色列中，直到今日。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS13_14","007_13_14","JOS","13","14","14","只是利未支派，摩西没有把产业分给他们。他们的产业乃是献与耶和华—以色列　神的火祭，正如耶和华所应许他们的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS13_15","007_13_15","JOS","13","15","15","摩西按着吕便支派的宗族分给他们产业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS13_16","007_13_16","JOS","13","16","16","他们的境界是亚嫩谷边的亚罗珥和谷中的城，靠近米底巴的全平原； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS13_17","007_13_17","JOS","13","17","17","希实本并属希实本平原的各城，底本、巴末·巴力、伯·巴力·勉、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS13_18","007_13_18","JOS","13","18","18","雅杂、基底莫、米法押、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS13_19","007_13_19","JOS","13","19","19","基列亭、西比玛、谷中山的细列·哈沙辖、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS13_20","007_13_20","JOS","13","20","20","伯·毗珥、毗斯迦山坡、伯·耶西末； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS13_21","007_13_21","JOS","13","21","21","平原的各城，并亚摩利王西宏的全国。这西宏曾在希实本作王，摩西把他和米甸的族长以未、利金、苏珥、户珥、利巴击杀了；这都是住那地属西宏为首领的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS13_22","007_13_22","JOS","13","22","22","那时以色列人在所杀的人中，也用刀杀了比珥的儿子术士巴兰。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS13_23","007_13_23","JOS","13","23","23","吕便人的境界就是约旦河与靠近约旦河的地。以上是吕便人按着宗族所得为业的诸城，并属城的村庄。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS13_24","007_13_24","JOS","13","24","24","摩西按着迦得支派的宗族分给他们产业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS13_25","007_13_25","JOS","13","25","25","他们的境界是雅谢和基列的各城，并亚扪人的一半地，直到拉巴前的亚罗珥； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS13_26","007_13_26","JOS","13","26","26","从希实本到拉抹·米斯巴和比多宁，又从玛哈念到底璧的境界， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS13_27","007_13_27","JOS","13","27","27","并谷中的伯·亚兰、伯·宁拉、疏割、撒分，就是希实本王西宏国中的余地，以及约旦河与靠近约旦河的地，直到基尼烈海的极边，都在约旦河东。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS13_28","007_13_28","JOS","13","28","28","以上是迦得人按着宗族所得为业的诸城，并属城的村庄。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS13_29","007_13_29","JOS","13","29","29","摩西把产业分给玛拿西半支派，是按着玛拿西半支派的宗族所分的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS13_30","007_13_30","JOS","13","30","30","他们的境界是从玛哈念起，包括巴珊全地，就是巴珊王噩的全国，并在巴珊、睚珥的一切城邑，共六十个。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS13_31","007_13_31","JOS","13","31","31","基列的一半，并亚斯他录、以得来，就是属巴珊王噩国的二城，是按着宗族给玛拿西的儿子玛吉的一半子孙。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS13_32","007_13_32","JOS","13","32","32","以上是摩西在约旦河东对着耶利哥的摩押平原所分给他们的产业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS13_33","007_13_33","JOS","13","33","33","只是利未支派，摩西没有把产业分给他们。耶和华—以色列的　神是他们的产业，正如耶和华所应许他们的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS14_1","007_14_1","JOS","14","1","1","以色列人在迦南地所得的产业，就是祭司以利亚撒和嫩的儿子约书亚，并以色列各支派的族长所分给他们的，都记在下面， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS14_2","007_14_2","JOS","14","2","2","是照耶和华借摩西所吩咐的，把产业拈阄分给九个半支派。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS14_3","007_14_3","JOS","14","3","3","原来，摩西在约旦河东已经把产业分给那两个半支派，只是在他们中间没有把产业分给利未人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS14_4","007_14_4","JOS","14","4","4","因为约瑟的子孙是两个支派，就是玛拿西和以法莲，所以没有把地分给利未人，但给他们城邑居住，并城邑的郊野，可以牧养他们的牲畜，安置他们的财物。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS14_5","007_14_5","JOS","14","5","5","耶和华怎样吩咐摩西，以色列人就照样行，把地分了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS14_6","007_14_6","JOS","14","6","6","那时，犹大人来到吉甲见约书亚，有基尼洗族耶孚尼的儿子迦勒对约书亚说：「耶和华在加低斯·巴尼亚指着我与你对神人摩西所说的话，你都知道了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS14_7","007_14_7","JOS","14","7","7","耶和华的仆人摩西从加低斯·巴尼亚打发我窥探这地，那时我正四十岁；我按着心意回报他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS14_8","007_14_8","JOS","14","8","8","然而，同我上去的众弟兄使百姓的心消化；但我专心跟从耶和华—我的　神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS14_9","007_14_9","JOS","14","9","9","当日摩西起誓说：『你脚所踏之地定要归你和你的子孙永远为业，因为你专心跟从耶和华—我的　神。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS14_10","007_14_10","JOS","14","10","10","自从耶和华对摩西说这话的时候，耶和华照他所应许的使我存活这四十五年；其间以色列人在旷野行走。看哪，现今我八十五岁了， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS14_11","007_14_11","JOS","14","11","11","我还是强壮，像摩西打发我去的那天一样；无论是争战，是出入，我的力量那时如何，现在还是如何。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS14_12","007_14_12","JOS","14","12","12","求你将耶和华那日应许我的这山地给我；那里有亚衲族人，并宽大坚固的城，你也曾听见了。或者耶和华照他所应许的与我同在，我就把他们赶出去。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS14_13","007_14_13","JOS","14","13","13","于是约书亚为耶孚尼的儿子迦勒祝福，将希伯 给他为业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS14_14","007_14_14","JOS","14","14","14","所以希伯 作了基尼洗族耶孚尼的儿子迦勒的产业，直到今日，因为他专心跟从耶和华—以色列的　神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS14_15","007_14_15","JOS","14","15","15","希伯 从前名叫基列·亚巴；亚巴是亚衲族中最尊大的人。于是国中太平，没有争战了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_1","007_15_1","JOS","15","1","1","犹大支派按着宗族拈阄所得之地是在尽南边，到以东的交界，向南直到寻的旷野。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_2","007_15_2","JOS","15","2","2","他们的南界是从盐海的尽边，就是从朝南的海汊起， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_3","007_15_3","JOS","15","3","3","通到亚克拉滨坡的南边，接连到寻，上到加低斯·巴尼亚的南边，又过希斯 ，上到亚达珥，绕到甲加， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_4","007_15_4","JOS","15","4","4","接连到押们，通到埃及小河，直通到海为止。这就是他们的南界。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_5","007_15_5","JOS","15","5","5","东界是从盐海南边到约旦河口。北界是从约旦河口的海汊起， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_6","007_15_6","JOS","15","6","6","上到伯·曷拉，过伯·亚拉巴的北边，上到吕便之子波罕的磐石； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_7","007_15_7","JOS","15","7","7","从亚割谷往北，上到底璧，直向河南亚都冥坡对面的吉甲；又接连到隐·示麦泉，直通到隐·罗结， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_8","007_15_8","JOS","15","8","8","上到欣嫩子谷，贴近耶布斯的南界（耶布斯就是耶路撒冷）；又上到欣嫩谷西边的山顶，就是在利乏音谷极北的边界； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_9","007_15_9","JOS","15","9","9","又从山顶延到尼弗多亚的水源，通到以弗 山的城邑，又延到巴拉（巴拉就是基列·耶琳）； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_10","007_15_10","JOS","15","10","10","又从巴拉往西绕到西珥山，接连到耶琳山的北边（耶琳就是基撒 ）；又下到伯·示麦过亭纳， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_11","007_15_11","JOS","15","11","11","通到以革伦北边，延到施基 ，接连到巴拉山；又通到雅比聂，直通到海为止。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_12","007_15_12","JOS","15","12","12","西界就是大海和靠近大海之地。这是犹大人按着宗族所得之地四围的交界。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_13","007_15_13","JOS","15","13","13","约书亚照耶和华所吩咐的，将犹大人中的一段地，就是基列·亚巴，分给耶孚尼的儿子迦勒。亚巴是亚衲族的始祖（基列·亚巴就是希伯 ）。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_14","007_15_14","JOS","15","14","14","迦勒就从那里赶出亚衲族的三个族长，就是示筛、亚希幔、挞买； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_15","007_15_15","JOS","15","15","15","又从那里上去，攻击底璧的居民。（这底璧从前名叫基列·西弗。） ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_16","007_15_16","JOS","15","16","16","迦勒说：「谁能攻打基列·西弗将城夺取，我就把我女儿押撒给他为妻。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_17","007_15_17","JOS","15","17","17","迦勒兄弟基纳斯的儿子俄陀聂夺取了那城，迦勒就把女儿押撒给他为妻。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_18","007_15_18","JOS","15","18","18","押撒过门的时候，劝丈夫向她父亲求一块田，押撒一下驴，迦勒问她说：「你要什么？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_19","007_15_19","JOS","15","19","19","她说：「求你赐福给我，你既将我安置在南地，求你也给我水泉。」她父亲就把上泉下泉赐给她。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_20","007_15_20","JOS","15","20","20","以下是犹大支派按着宗族所得的产业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_21","007_15_21","JOS","15","21","21","犹大支派尽南边的城邑，与以东交界相近的，就是甲薛、以得、雅姑珥、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_22","007_15_22","JOS","15","22","22","基拿、底摩拿、亚大达、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_23","007_15_23","JOS","15","23","23","基低斯、夏琐、以提楠、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_24","007_15_24","JOS","15","24","24","西弗、提链、比亚绿、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_25","007_15_25","JOS","15","25","25","夏琐·哈大他、加略·希斯 （加略·希斯 就是夏琐）、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_26","007_15_26","JOS","15","26","26","亚曼、示玛、摩拉大、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_27","007_15_27","JOS","15","27","27","哈萨·迦大、黑实门、伯·帕列、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_28","007_15_28","JOS","15","28","28","哈萨·书亚、别是巴、比斯约他、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_29","007_15_29","JOS","15","29","29","巴拉、以因、以森、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_30","007_15_30","JOS","15","30","30","伊勒多腊、基失、何珥玛、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_31","007_15_31","JOS","15","31","31","洗革拉、麦玛拿、三撒拿、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_32","007_15_32","JOS","15","32","32","利巴勿、实忻、亚因、临门，共二十九座城，还有属城的村庄。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_33","007_15_33","JOS","15","33","33","在高原有以实陶、琐拉、亚实拿、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_34","007_15_34","JOS","15","34","34","撒挪亚、隐·干宁、他普亚、以楠、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_35","007_15_35","JOS","15","35","35","耶末、亚杜兰、梭哥、亚西加、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_36","007_15_36","JOS","15","36","36","沙拉音、亚底他音、基底拉、基底罗他音，共十四座城，还有属城的村庄。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_37","007_15_37","JOS","15","37","37","又有洗楠、哈大沙、麦大·迦得、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_38","007_15_38","JOS","15","38","38","底连、米斯巴、约帖、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_39","007_15_39","JOS","15","39","39","拉吉、波斯加、伊矶伦、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_40","007_15_40","JOS","15","40","40","迦本、拉幔、基提利、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_41","007_15_41","JOS","15","41","41","基低罗、伯·大衮、拿玛、玛基大，共十六座城，还有属城的村庄。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_42","007_15_42","JOS","15","42","42","又有立拿、以帖、亚珊、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_43","007_15_43","JOS","15","43","43","益弗他、亚实拿、尼悉、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_44","007_15_44","JOS","15","44","44","基伊拉、亚革悉、玛利沙，共九座城，还有属城的村庄。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_45","007_15_45","JOS","15","45","45","又有以革伦和属以革伦的镇市村庄； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_46","007_15_46","JOS","15","46","46","从以革伦直到海，一切靠近亚实突之地，并属其地的村庄。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_47","007_15_47","JOS","15","47","47","亚实突和属亚实突的镇市村庄；迦萨和属迦萨的镇市村庄；直到埃及小河，并大海和靠近大海之地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_48","007_15_48","JOS","15","48","48","在山地有沙密、雅提珥、梭哥、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_49","007_15_49","JOS","15","49","49","大拿、基列·萨拿（基列·萨拿就是底璧）、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_50","007_15_50","JOS","15","50","50","亚拿伯、以实提莫、亚念、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_51","007_15_51","JOS","15","51","51","歌珊、何伦、基罗，共十一座城，还有属城的村庄。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_52","007_15_52","JOS","15","52","52","又有亚拉、度玛、以珊、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_53","007_15_53","JOS","15","53","53","雅农、伯·他普亚、亚非加、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_54","007_15_54","JOS","15","54","54","宏他、基列·亚巴（基列·亚巴就是希伯 ）、洗珥，共九座城，还有属城的村庄。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_55","007_15_55","JOS","15","55","55","又有玛云、迦密、西弗、淤他、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_56","007_15_56","JOS","15","56","56","耶斯列、约甸、撒挪亚、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_57","007_15_57","JOS","15","57","57","该隐、基比亚、亭纳，共十座城，还有属城的村庄。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_58","007_15_58","JOS","15","58","58","又有哈忽、伯·夙、基突、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_59","007_15_59","JOS","15","59","59","玛腊、伯·亚诺、伊勒提君，共六座城，还有属城的村庄。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_60","007_15_60","JOS","15","60","60","又有基列·巴力（基列·巴力就是基列·耶琳）、拉巴，共两座城，还有属城的村庄。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_61","007_15_61","JOS","15","61","61","在旷野有伯·亚拉巴、密丁、西迦迦、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_62","007_15_62","JOS","15","62","62","匿珊、盐城、隐·基底，共六座城，还有属城的村庄。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS15_63","007_15_63","JOS","15","63","63","至于住耶路撒冷的耶布斯人，犹大人不能把他们赶出去，耶布斯人却在耶路撒冷与犹大人同住，直到今日。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS16_1","007_16_1","JOS","16","1","1","约瑟的子孙拈阄所得之地是从靠近耶利哥的约旦河起，以耶利哥东边的水为界：从耶利哥上去，通过山地的旷野，到伯特利； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS16_2","007_16_2","JOS","16","2","2","又从伯特利到路斯，接连到亚基人的境界，至亚他绿； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS16_3","007_16_3","JOS","16","3","3","又往西下到押利提人的境界，到下伯·和 的境界，直到基色，通到海为止。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS16_4","007_16_4","JOS","16","4","4","约瑟的儿子玛拿西、以法莲就得了他们的地业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS16_5","007_16_5","JOS","16","5","5","以法莲子孙的境界，按着宗族所得的，记在下面：他们地业的东界是亚他绿·亚达到上伯·和 ； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS16_6","007_16_6","JOS","16","6","6","往西通到北边的密米他，又向东绕到他纳·示罗，又接连到雅挪哈的东边； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS16_7","007_16_7","JOS","16","7","7","从雅挪哈下到亚他绿，又到拿拉，达到耶利哥，通到约旦河为止； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS16_8","007_16_8","JOS","16","8","8","从他普亚往西，到加拿河，直通到海为止。这就是以法莲支派按着宗族所得的地业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS16_9","007_16_9","JOS","16","9","9","另外在玛拿西人地业中得了些城邑和属城的村庄。这都是分给以法莲子孙的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS16_10","007_16_10","JOS","16","10","10","他们没有赶出住基色的迦南人；迦南人却住在以法莲人中间，成为做苦工的仆人，直到今日。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS17_1","007_17_1","JOS","17","1","1","玛拿西是约瑟的长子，他的支派拈阄所得之地记在下面。至于玛拿西的长子基列之父玛吉，因为是勇士就得了基列和巴珊。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS17_2","007_17_2","JOS","17","2","2","玛拿西其余的子孙，按着宗族拈阄分地，就是亚比以谢子孙，希勒子孙，亚斯列子孙，示剑子孙，希弗子孙，示米大子孙；这些按着宗族，都是约瑟儿子玛拿西子孙的男丁。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS17_3","007_17_3","JOS","17","3","3","玛拿西的玄孙，玛吉的曾孙，基列的孙子，希弗的儿子西罗非哈没有儿子，只有女儿。他的女儿名叫玛拉、挪阿、曷拉、密迦、得撒； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS17_4","007_17_4","JOS","17","4","4","她们来到祭司以利亚撒和嫩的儿子约书亚并众首领面前，说：「耶和华曾吩咐摩西在我们弟兄中分给我们产业。」于是约书亚照耶和华所吩咐的，在她们伯叔中，把产业分给她们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS17_5","007_17_5","JOS","17","5","5","除了约旦河东的基列和巴珊地之外，还有十分地归玛拿西， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS17_6","007_17_6","JOS","17","6","6","因为玛拿西的孙女们在玛拿西的孙子中得了产业。基列地是属玛拿西其余的子孙。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS17_7","007_17_7","JOS","17","7","7","玛拿西的境界：从亚设起，到示剑前的密米他，往北到隐·他普亚居民之地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS17_8","007_17_8","JOS","17","8","8","他普亚地归玛拿西，只是玛拿西境界上的他普亚城归以法莲子孙。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS17_9","007_17_9","JOS","17","9","9","其界下到加拿河的南边。在玛拿西城邑中的这些城邑都归以法莲。玛拿西的地界是在河北直通到海为止； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS17_10","007_17_10","JOS","17","10","10","南归以法莲，北归玛拿西，以海为界；北边到亚设，东边到以萨迦。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS17_11","007_17_11","JOS","17","11","11","玛拿西在以萨迦和亚设境内，有伯·善和属伯·善的镇市，以伯莲和属以伯莲的镇市，多珥的居民和属多珥的镇市；又有三处山冈，就是隐·多珥和属隐·多珥的镇市；他纳的居民和属他纳的镇市，米吉多的居民和属米吉多的镇市。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS17_12","007_17_12","JOS","17","12","12","只是玛拿西子孙不能赶出这些城的居民，迦南人偏要住在那地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS17_13","007_17_13","JOS","17","13","13","及至以色列人强盛了，就使迦南人做苦工，没有把他们全然赶出。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS17_14","007_17_14","JOS","17","14","14","约瑟的子孙对约书亚说：「耶和华到如今既然赐福与我们，我们也族大人多，你为什么仅将一阄一段之地分给我们为业呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS17_15","007_17_15","JOS","17","15","15","约书亚说：「你们如果族大人多，嫌以法莲山地窄小，就可以上比利洗人、利乏音人之地，在树林中砍伐树木。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS17_16","007_17_16","JOS","17","16","16","约瑟的子孙说：「那山地容不下我们，并且住平原的迦南人，就是住伯·善和属伯·善的镇市，并住耶斯列平原的人，都有铁车。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS17_17","007_17_17","JOS","17","17","17","约书亚对约瑟家，就是以法莲和玛拿西人，说：「你是族大人多，并且强盛，不可仅有一阄之地， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS17_18","007_17_18","JOS","17","18","18","山地也要归你，虽是树林，你也可以砍伐；靠近之地必归你。迦南人虽有铁车，虽是强盛，你也能把他们赶出去。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS18_1","007_18_1","JOS","18","1","1","以色列的全会众都聚集在示罗，把会幕设立在那里，那地已经被他们制伏了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS18_2","007_18_2","JOS","18","2","2","以色列人中其余的七个支派还没有分给他们地业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS18_3","007_18_3","JOS","18","3","3","约书亚对以色列人说：「耶和华—你们列祖的　神所赐给你们的地，你们耽延不去得，要到几时呢？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS18_4","007_18_4","JOS","18","4","4","你们每支派当选举三个人，我要打发他们去，他们就要起身走遍那地，按着各支派应得的地业写明，就回到我这里来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS18_5","007_18_5","JOS","18","5","5","他们要将地分做七分；犹大仍在南方，住在他的境内。约瑟家仍在北方，住在他的境内。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS18_6","007_18_6","JOS","18","6","6","你们要将地分做七分，写明了拿到我这里来。我要在耶和华—我们　神面前，为你们拈阄。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS18_7","007_18_7","JOS","18","7","7","利未人在你们中间没有分，因为供耶和华祭司的职任就是他们的产业。迦得支派、吕便支派，和玛拿西半支派已经在约旦河东得了地业，就是耶和华仆人摩西所给他们的。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS18_8","007_18_8","JOS","18","8","8","划地势的人起身去的时候，约书亚嘱咐他们说：「你们去走遍那地，划明地势，就回到我这里来。我要在示罗这里，耶和华面前，为你们拈阄。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS18_9","007_18_9","JOS","18","9","9","他们就去了，走遍那地，按着城邑分做七分，写在册子上，回到示罗营中见约书亚。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS18_10","007_18_10","JOS","18","10","10","约书亚就在示罗，耶和华面前，为他们拈阄。约书亚在那里，按着以色列人的支派，将地分给他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS18_11","007_18_11","JOS","18","11","11","便雅悯支派，按着宗族拈阄所得之地，是在犹大、约瑟子孙中间。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS18_12","007_18_12","JOS","18","12","12","他们的北界是从约旦河起，往上贴近耶利哥的北边；又往西通过山地，直到伯·亚文的旷野； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS18_13","007_18_13","JOS","18","13","13","从那里往南接连到路斯，贴近路斯（路斯就是伯特利），又下到亚他绿·亚达，靠近下伯·和 南边的山； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS18_14","007_18_14","JOS","18","14","14","从那里往西，又转向南，从伯·和 南对面的山，直达到犹大人的城基列·巴力（基列·巴力就是基列·耶琳）；这是西界。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS18_15","007_18_15","JOS","18","15","15","南界是从基列·耶琳的尽边起，往西达到尼弗多亚的水源； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS18_16","007_18_16","JOS","18","16","16","又下到欣嫩子谷对面山的尽边，就是利乏音谷北边的山；又下到欣嫩谷，贴近耶布斯的南边；又下到隐·罗结； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS18_17","007_18_17","JOS","18","17","17","又往北通到隐·示麦，达到亚都冥坡对面的基利绿；又下到吕便之子波罕的磐石； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS18_18","007_18_18","JOS","18","18","18","又接连到亚拉巴对面，往北下到亚拉巴； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS18_19","007_18_19","JOS","18","19","19","又接连到伯·曷拉的北边，直通到盐海的北汊，就是约旦河的南头；这是南界。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS18_20","007_18_20","JOS","18","20","20","东界是约旦河。这是便雅悯人按着宗族，照他们四围的交界所得的地业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS18_21","007_18_21","JOS","18","21","21","便雅悯支派按着宗族所得的城邑就是：耶利哥、伯·曷拉、伊麦·基悉、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS18_22","007_18_22","JOS","18","22","22","伯·亚拉巴、洗玛脸、伯特利、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS18_23","007_18_23","JOS","18","23","23","亚文、巴拉、俄弗拉、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS18_24","007_18_24","JOS","18","24","24","基法·阿摩尼、俄弗尼、迦巴，共十二座城，还有属城的村庄； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS18_25","007_18_25","JOS","18","25","25","又有基遍、拉玛、比录、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS18_26","007_18_26","JOS","18","26","26","米斯巴、基非拉、摩撒、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS18_27","007_18_27","JOS","18","27","27","利坚、伊利毗勒、他拉拉、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS18_28","007_18_28","JOS","18","28","28","洗拉、以利弗、耶布斯（耶布斯就是耶路撒冷）、基比亚、基列，共十四座城，还有属城的村庄。这是便雅悯人按着宗族所得的地业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS19_1","007_19_1","JOS","19","1","1","为西缅支派的人，按着宗族，拈出第二阄。他们所得的地业是在犹大人地业中间。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS19_2","007_19_2","JOS","19","2","2","他们所得为业之地就是：别是巴（或名示巴）、摩拉大、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS19_3","007_19_3","JOS","19","3","3","哈萨·书亚、巴拉、以森、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS19_4","007_19_4","JOS","19","4","4","伊利多拉、比土力、何珥玛、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS19_5","007_19_5","JOS","19","5","5","洗革拉、伯·玛加博、哈萨·苏撒、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS19_6","007_19_6","JOS","19","6","6","伯·利巴勿、沙鲁险，共十三座城，还有属城的村庄； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS19_7","007_19_7","JOS","19","7","7","又有亚因、利门、以帖、亚珊，共四座城，还有属城的村庄； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS19_8","007_19_8","JOS","19","8","8","并有这些城邑四围一切的村庄，直到巴拉·比珥，就是南地的拉玛。这是西缅支派按着宗族所得的地业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS19_9","007_19_9","JOS","19","9","9","西缅人的地业是从犹大人地业中得来的；因为犹大人的分过多，所以西缅人在他们的地业中得了地业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS19_10","007_19_10","JOS","19","10","10","为西布伦人，按着宗族，拈出第三阄。他们地业的境界是到撒立； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS19_11","007_19_11","JOS","19","11","11","往西上到玛拉拉，达到大巴设，又达到约念前的河； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS19_12","007_19_12","JOS","19","12","12","又从撒立往东转向日出之地，到吉斯绿·他泊的境界，又通到大比拉，上到雅非亚； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS19_13","007_19_13","JOS","19","13","13","从那里往东，接连到迦特·希弗，至以特·加汛，通到临门，临门延到尼亚； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS19_14","007_19_14","JOS","19","14","14","又绕过尼亚的北边，转到哈拿顿，通到伊弗他·伊勒谷。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS19_15","007_19_15","JOS","19","15","15","还有加他、拿哈拉、伸 、以大拉、伯利恒，共十二座城，还有属城的村庄。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS19_16","007_19_16","JOS","19","16","16","这些城并属城的村庄就是西布伦人按着宗族所得的地业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS19_17","007_19_17","JOS","19","17","17","为以萨迦人，按着宗族，拈出第四阄。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS19_18","007_19_18","JOS","19","18","18","他们的境界是到耶斯列、基苏律、书念、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS19_19","007_19_19","JOS","19","19","19","哈弗连、示按、亚拿哈拉、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS19_20","007_19_20","JOS","19","20","20","拉璧、基善、亚别、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS19_21","007_19_21","JOS","19","21","21","利篾、隐·干宁、隐·哈大、伯·帕薛； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS19_22","007_19_22","JOS","19","22","22","又达到他泊、沙哈洗玛、伯·示麦，直通到约旦河为止，共十六座城，还有属城的村庄。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS19_23","007_19_23","JOS","19","23","23","这些城并属城的村庄就是以萨迦支派按着宗族所得的地业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS19_24","007_19_24","JOS","19","24","24","为亚设支派，按着宗族，拈出第五阄。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS19_25","007_19_25","JOS","19","25","25","他们的境界是黑甲、哈利、比田、押煞、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS19_26","007_19_26","JOS","19","26","26","亚拉米勒、亚末、米沙勒；往西达到迦密，又到希曷·立纳， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS19_27","007_19_27","JOS","19","27","27","转向日出之地，到伯·大衮，达到细步纶；往北到伊弗他·伊勒谷，到伯·以墨和尼业，也通到迦步勒的左边； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS19_28","007_19_28","JOS","19","28","28","又到义伯 、利合、哈们、加拿，直到西顿大城； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS19_29","007_19_29","JOS","19","29","29","转到拉玛和坚固城泰尔；又转到何萨，靠近亚革悉一带地方，直通到海； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS19_30","007_19_30","JOS","19","30","30","又有乌玛、亚弗、利合，共二十二座城，还有属城的村庄。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS19_31","007_19_31","JOS","19","31","31","这些城并属城的村庄就是亚设支派按着宗族所得的地业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS19_32","007_19_32","JOS","19","32","32","为拿弗他利人，按着宗族，拈出第六阄。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS19_33","007_19_33","JOS","19","33","33","他们的境界是从希利弗从撒拿音的橡树，从亚大米·尼吉和雅比聂，直到拉共，通到约旦河； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS19_34","007_19_34","JOS","19","34","34","又转向西到亚斯纳·他泊，从那里通到户割，南边到西布伦，西边到亚设，又向日出之地，达到约旦河那里的犹大。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS19_35","007_19_35","JOS","19","35","35","坚固的城就是：西丁、侧耳、哈末、拉甲、基尼烈、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS19_36","007_19_36","JOS","19","36","36","亚大玛、拉玛、夏琐、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS19_37","007_19_37","JOS","19","37","37","基低斯、以得来、隐·夏琐、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS19_38","007_19_38","JOS","19","38","38","以利稳、密大·伊勒、和琏、伯·亚纳、伯·示麦，共十九座城，还有属城的村庄。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS19_39","007_19_39","JOS","19","39","39","这些城并属城的村庄就是拿弗他利支派按着宗族所得的地业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS19_40","007_19_40","JOS","19","40","40","为但支派，按着宗族，拈出第七阄。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS19_41","007_19_41","JOS","19","41","41","他们地业的境界是琐拉、以实陶、伊珥·示麦、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS19_42","007_19_42","JOS","19","42","42","沙拉宾、亚雅 、伊提拉、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS19_43","007_19_43","JOS","19","43","43","以伦、亭拿他、以革伦、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS19_44","007_19_44","JOS","19","44","44","伊利提基、基比顿、巴拉、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS19_45","007_19_45","JOS","19","45","45","伊胡得、比尼·比拉、迦特·临门、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS19_46","007_19_46","JOS","19","46","46","美·耶昆、拉昆，并约帕对面的地界。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS19_47","007_19_47","JOS","19","47","47","但人的地界越过原得的地界；因为但人上去攻取利善，用刀击杀城中的人，得了那城，住在其中，以他们先祖但的名将利善改名为但。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS19_48","007_19_48","JOS","19","48","48","这些城并属城的村庄就是但支派按着宗族所得的地业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS19_49","007_19_49","JOS","19","49","49","以色列人按着境界分完了地业，就在他们中间将地给嫩的儿子约书亚为业， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS19_50","007_19_50","JOS","19","50","50","是照耶和华的吩咐，将约书亚所求的城，就是以法莲山地的亭拿·西拉城，给了他。他就修那城，住在其中。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS19_51","007_19_51","JOS","19","51","51","这就是祭司以利亚撒和嫩的儿子约书亚，并以色列各支派的族长，在示罗会幕门口，耶和华面前，拈阄所分的地业。这样，他们把地分完了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS20_1","007_20_1","JOS","20","1","1","耶和华晓谕约书亚说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS20_2","007_20_2","JOS","20","2","2","「你吩咐以色列人说：你们要照着我借摩西所晓谕你们的，为自己设立逃城， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS20_3","007_20_3","JOS","20","3","3","使那无心而误杀人的，可以逃到那里。这些城可以作你们逃避报血仇人的地方。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS20_4","007_20_4","JOS","20","4","4","那杀人的要逃到这些城中的一座城，站在城门口，将他的事情说给城内的长老们听。他们就把他收进城里，给他地方，使他住在他们中间。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS20_5","007_20_5","JOS","20","5","5","若是报血仇的追了他来，长老不可将他交在报血仇的手里；因为他是素无仇恨，无心杀了人的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS20_6","007_20_6","JOS","20","6","6","他要住在那城里，站在会众面前听审判，等到那时的大祭司死了，杀人的才可以回到本城本家，就是他所逃出来的那城。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS20_7","007_20_7","JOS","20","7","7","于是，以色列人在拿弗他利山地分定加利利的基低斯；在以法莲山地分定示剑；在犹大山地分定基列·亚巴（基列·亚巴就是希伯 ）； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS20_8","007_20_8","JOS","20","8","8","又在约旦河外耶利哥东，从吕便支派中，在旷野的平原，设立比悉；从迦得支派中设立基列的拉末；从玛拿西支派中设立巴珊的哥兰。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS20_9","007_20_9","JOS","20","9","9","这都是为以色列众人和在他们中间寄居的外人所分定的城邑，使误杀人的都可以逃到那里，不死在报血仇人的手中，等他站在会众面前听审判。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS21_1","007_21_1","JOS","21","1","1","那时，利未人的众族长来到祭司以利亚撒和嫩的儿子约书亚，并以色列各支派的族长面前， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS21_2","007_21_2","JOS","21","2","2","在迦南地的示罗对他们说：「从前耶和华借着摩西吩咐给我们城邑居住，并城邑的郊野可以牧养我们的牲畜。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS21_3","007_21_3","JOS","21","3","3","于是以色列人照耶和华所吩咐的，从自己的地业中，将以下所记的城邑和城邑的郊野给了利未人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS21_4","007_21_4","JOS","21","4","4","为哥辖族拈阄：利未人的祭司、亚伦的子孙，从犹大支派、西缅支派、便雅悯支派的地业中，按阄得了十三座城。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS21_5","007_21_5","JOS","21","5","5","哥辖其余的子孙，从以法莲支派、但支派、玛拿西半支派的地业中，按阄得了十座城。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS21_6","007_21_6","JOS","21","6","6","革顺的子孙，从以萨迦支派、亚设支派、拿弗他利支派、住巴珊的玛拿西半支派的地业中，按阄得了十三座城。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS21_7","007_21_7","JOS","21","7","7","米拉利的子孙，按着宗族，从吕便支派、迦得支派、西布伦支派的地业中，按阄得了十二座城。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS21_8","007_21_8","JOS","21","8","8","以色列人照着耶和华借摩西所吩咐的，将这些城邑和城邑的郊野，按阄分给利未人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS21_9","007_21_9","JOS","21","9","10","从犹大支派、西缅支派的地业中，将以下所记的城给了利未支派哥辖宗族亚伦的子孙；因为给他们拈出头一阄， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS21_11","007_21_11","JOS","21","11","11","将犹大山地的基列·亚巴和四围的郊野给了他们。亚巴是亚衲族的始祖。（基列·亚巴就是希伯 ）。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS21_12","007_21_12","JOS","21","12","12","惟将属城的田地和村庄给了耶孚尼的儿子迦勒为业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS21_13","007_21_13","JOS","21","13","13","以色列人将希伯 ，就是误杀人的逃城和属城的郊野，给了祭司亚伦的子孙；又给他们立拿和属城的郊野， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS21_14","007_21_14","JOS","21","14","14","雅提珥和属城的郊野，以实提莫和属城的郊野， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS21_15","007_21_15","JOS","21","15","15","何 和属城的郊野，底璧和属城的郊野， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS21_16","007_21_16","JOS","21","16","16","亚因和属城的郊野，淤他和属城的郊野，伯·示麦和属城的郊野，共九座城，都是从这二支派中分出来的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS21_17","007_21_17","JOS","21","17","17","又从便雅悯支派的地业中给了他们基遍和属城的郊野，迦巴和属城的郊野， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS21_18","007_21_18","JOS","21","18","18","亚拿突和属城的郊野，亚勒们和属城的郊野，共四座城。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS21_19","007_21_19","JOS","21","19","19","亚伦子孙作祭司的共有十三座城，还有属城的郊野。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS21_20","007_21_20","JOS","21","20","20","利未支派中哥辖的宗族，就是哥辖其余的子孙，拈阄所得的城有从以法莲支派中分出来的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS21_21","007_21_21","JOS","21","21","21","以色列人将以法莲山地的示剑，就是误杀人的逃城和属城的郊野，给了他们；又给他们基色和属城的郊野， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS21_22","007_21_22","JOS","21","22","22","基伯先和属城的郊野，伯·和 和属城的郊野，共四座城； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS21_23","007_21_23","JOS","21","23","23","又从但支派的地业中给了他们伊利提基和属城的郊野，基比顿和属城的郊野， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS21_24","007_21_24","JOS","21","24","24","亚雅 和属城的郊野，迦特·临门和属城的郊野，共四座城； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS21_25","007_21_25","JOS","21","25","25","又从玛拿西半支派的地业中给了他们他纳和属城的郊野，迦特·临门和属城的郊野，共两座城。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS21_26","007_21_26","JOS","21","26","26","哥辖其余的子孙共有十座城，还有属城的郊野。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS21_27","007_21_27","JOS","21","27","27","以色列人又从玛拿西半支派的地业中将巴珊的哥兰，就是误杀人的逃城和属城的郊野，给了利未支派革顺的子孙；又给他们比·施提拉和属城的郊野，共两座城； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS21_28","007_21_28","JOS","21","28","28","又从以萨迦支派的地业中给了他们基善和属城的郊野，大比拉和属城的郊野， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS21_29","007_21_29","JOS","21","29","29","耶末和属城的郊野，隐·干宁和属城的郊野，共四座城； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS21_30","007_21_30","JOS","21","30","30","又从亚设支派的地业中给了他们米沙勒和属城的郊野，押顿和属城的郊野， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS21_31","007_21_31","JOS","21","31","31","黑甲和属城的郊野，利合和属城的郊野，共四座城； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS21_32","007_21_32","JOS","21","32","32","又从拿弗他利支派的地业中将加利利的基低斯，就是误杀人的逃城和属城的郊野，给了他们；又给他们哈末·多珥和属城的郊野，加珥坦和属城的郊野，共三座城。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS21_33","007_21_33","JOS","21","33","33","革顺人按着宗族所得的城，共十三座，还有属城的郊野。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS21_34","007_21_34","JOS","21","34","34","其余利未支派米拉利子孙，从西布伦支派的地业中所得的，就是约念和属城的郊野，加珥他和属城的郊野， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS21_35","007_21_35","JOS","21","35","35","丁拿和属城的郊野，拿哈拉和属城的郊野，共四座城； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS21_36","007_21_36","JOS","21","36","36","又从吕便支派的地业中给了他们比悉和属城的郊野，雅杂和属城的郊野， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS21_37","007_21_37","JOS","21","37","37","基底莫和属城的郊野，米法押和属城的郊野，共四座城； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS21_38","007_21_38","JOS","21","38","38","又从迦得支派的地业中，将基列的拉末，就是误杀人的逃城和属城的郊野，给了他们；又给他们玛哈念和属城的郊野， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS21_39","007_21_39","JOS","21","39","39","希实本和属城的郊野，雅谢和属城的郊野，共四座城。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS21_40","007_21_40","JOS","21","40","40","其余利未支派的人，就是米拉利的子孙，按着宗族拈阄所得的，共十二座城。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS21_41","007_21_41","JOS","21","41","41","利未人在以色列人的地业中所得的城，共四十八座，并有属城的郊野。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS21_42","007_21_42","JOS","21","42","42","这些城四围都有属城的郊野，城城都是如此。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS21_43","007_21_43","JOS","21","43","43","这样，耶和华将从前向他们列祖起誓所应许的全地赐给以色列人，他们就得了为业，住在其中。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS21_44","007_21_44","JOS","21","44","44","耶和华照着向他们列祖起誓所应许的一切话，使他们四境平安；他们一切仇敌中，没有一人在他们面前站立得住。耶和华把一切仇敌都交在他们手中。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS21_45","007_21_45","JOS","21","45","45","耶和华应许赐福给以色列家的话一句也没有落空，都应验了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS22_1","007_22_1","JOS","22","1","1","当时，约书亚召了吕便人、迦得人，和玛拿西半支派的人来， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS22_2","007_22_2","JOS","22","2","2","对他们说：「耶和华仆人摩西所吩咐你们的，你们都遵守了；我所吩咐你们的，你们也都听从了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS22_3","007_22_3","JOS","22","3","3","你们这许多日子，总没有撇离你们的弟兄，直到今日，并守了耶和华—你们　神所吩咐你们当守的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS22_4","007_22_4","JOS","22","4","4","如今耶和华—你们　神照着他所应许的，使你们弟兄得享平安，现在可以转回你们的帐棚，到耶和华的仆人摩西在约旦河东所赐你们为业之地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS22_5","007_22_5","JOS","22","5","5","只要切切地谨慎遵行耶和华仆人摩西所吩咐你们的诫命律法，爱耶和华—你们的　神，行他一切的道，守他的诫命，专靠他，尽心尽性事奉他。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS22_6","007_22_6","JOS","22","6","6","于是约书亚为他们祝福，打发他们去，他们就回自己的帐棚去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS22_7","007_22_7","JOS","22","7","7","玛拿西那半支派，摩西早已在巴珊分给他们地业。这半支派，约书亚在约旦河西，在他们弟兄中，分给他们地业。约书亚打发他们回帐棚的时候为他们祝福， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS22_8","007_22_8","JOS","22","8","8","对他们说：「你们带许多财物，许多牲畜和金、银、铜、铁，并许多衣服，回你们的帐棚去，要将你们从仇敌夺来的物，与你们众弟兄同分。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS22_9","007_22_9","JOS","22","9","9","于是吕便人、迦得人、玛拿西半支派的人从迦南地的示罗起行，离开以色列人，回往他们得为业的基列地，就是照耶和华借摩西所吩咐的得了为业之地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS22_10","007_22_10","JOS","22","10","10","吕便人、迦得人，和玛拿西半支派的人到了靠近约旦河的一带迦南地，就在约旦河那里筑了一座坛；那坛看着高大。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS22_11","007_22_11","JOS","22","11","11","以色列人听说吕便人、迦得人、玛拿西半支派的人靠近约旦河边，在迦南地属以色列人的那边筑了一座坛。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS22_12","007_22_12","JOS","22","12","12","全会众一听见，就聚集在示罗，要上去攻打他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS22_13","007_22_13","JOS","22","13","13","以色列人打发祭司以利亚撒的儿子非尼哈，往基列地去见吕便人、迦得人、玛拿西半支派的人； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS22_14","007_22_14","JOS","22","14","14","又打发十个首领与非尼哈同去，就是以色列每支派的一个首领，都是以色列军中的统领。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS22_15","007_22_15","JOS","22","15","15","他们到了基列地，见吕便人、迦得人，和玛拿西半支派的人，对他们说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS22_16","007_22_16","JOS","22","16","16","「耶和华全会众这样说，你们今日转去不跟从耶和华，干犯以色列的　神，为自己筑一座坛，悖逆了耶和华，这犯的是什么罪呢？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS22_17","007_22_17","JOS","22","17","17","从前拜毗珥的罪孽还算小吗？虽然瘟疫临到耶和华的会众，到今日我们还没有洗净这罪。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS22_18","007_22_18","JOS","22","18","18","你们今日竟转去不跟从耶和华吗？你们今日既悖逆耶和华，明日他必向以色列全会众发怒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS22_19","007_22_19","JOS","22","19","19","你们所得为业之地，若嫌不洁净，就可以过到耶和华之地，就是耶和华的帐幕所住之地，在我们中间得地业。只是不可悖逆耶和华，也不可得罪我们，在耶和华—我们　神的坛以外为自己筑坛。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS22_20","007_22_20","JOS","22","20","20","从前谢拉的曾孙亚干岂不是在那当灭的物上犯了罪，就有忿怒临到以色列全会众吗？那人在所犯的罪中不独一人死亡。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS22_21","007_22_21","JOS","22","21","21","于是吕便人、迦得人、玛拿西半支派的人回答以色列军中的统领说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS22_22","007_22_22","JOS","22","22","22","「大能者　神耶和华！大能者　神耶和华！他是知道的！以色列人也必知道！我们若有悖逆的意思，或是干犯耶和华（愿你今日不保佑我们）， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS22_23","007_22_23","JOS","22","23","23","为自己筑坛，要转去不跟从耶和华，或是要将燔祭、素祭、平安祭献在坛上，愿耶和华亲自讨我们的罪。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS22_24","007_22_24","JOS","22","24","24","我们行这事并非无故，是特意做的，说：恐怕日后你们的子孙对我们的子孙说：『你们与耶和华—以色列的　神有何关涉呢？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS22_25","007_22_25","JOS","22","25","25","因为耶和华把约旦河定为我们和你们这吕便人、迦得人的交界，你们与耶和华无分了。』这样，你们的子孙就使我们的子孙不再敬畏耶和华了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS22_26","007_22_26","JOS","22","26","26","因此我们说：『不如为自己筑一座坛，不是为献燔祭，也不是为献别的祭， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS22_27","007_22_27","JOS","22","27","27","乃是为你我中间和你我后人中间作证据，好叫我们也在耶和华面前献燔祭、平安祭，和别的祭事奉他，免得你们的子孙日后对我们的子孙说，你们与耶和华无分了。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS22_28","007_22_28","JOS","22","28","28","所以我们说：『日后你们对我们，或对我们的后人这样说，我们就可以回答说，你们看我们列祖所筑的坛是耶和华坛的样式；这并不是为献燔祭，也不是为献别的祭，乃是为作你我中间的证据。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS22_29","007_22_29","JOS","22","29","29","我们在耶和华—我们　神帐幕前的坛以外，另筑一座坛，为献燔祭、素祭，和别的祭，悖逆耶和华，今日转去不跟从他，我们断没有这个意思。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS22_30","007_22_30","JOS","22","30","30","祭司非尼哈与会中的首领，就是与他同来以色列军中的统领，听见吕便人、迦得人、玛拿西人所说的话，就都以为美。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS22_31","007_22_31","JOS","22","31","31","祭司以利亚撒的儿子非尼哈对吕便人、迦得人、玛拿西人说：「今日我们知道耶和华在我们中间，因为你们没有向他犯了这罪。现在你们救以色列人脱离耶和华的手了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS22_32","007_22_32","JOS","22","32","32","祭司以利亚撒的儿子非尼哈与众首领离了吕便人、迦得人，从基列地回往迦南地，到了以色列人那里，便将这事回报他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS22_33","007_22_33","JOS","22","33","33","以色列人以这事为美，就称颂　神，不再提上去攻打吕便人、迦得人、毁坏他们所住的地了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS22_34","007_22_34","JOS","22","34","34","吕便人、迦得人给坛起名叫证坛，意思说：这坛在我们中间证明耶和华是　神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS23_1","007_23_1","JOS","23","1","1","耶和华使以色列人安静，不与四围的一切仇敌争战，已经多日。约书亚年纪老迈， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS23_2","007_23_2","JOS","23","2","2","就把以色列众人的长老、族长、审判官，并官长都召了来，对他们说：「我年纪已经老迈。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS23_3","007_23_3","JOS","23","3","3","耶和华—你们的　神因你们的缘故向那些国所行的一切事，你们亲眼看见了，因那为你们争战的是耶和华—你们的　神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS23_4","007_23_4","JOS","23","4","4","我所剪除和所剩下的各国，从约旦河起到日落之处的大海，我已经拈阄分给你们各支派为业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS23_5","007_23_5","JOS","23","5","5","耶和华—你们的　神必将他们从你们面前赶出去，使他们离开你们，你们就必得他们的地为业，正如耶和华—你们的　神所应许的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS23_6","007_23_6","JOS","23","6","6","所以，你们要大大壮胆，谨守遵行写在摩西律法书上的一切话，不可偏离左右。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS23_7","007_23_7","JOS","23","7","7","不可与你们中间所剩下的这些国民搀杂。他们的神，你们不可提他的名，不可指着他起誓，也不可事奉、叩拜； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS23_8","007_23_8","JOS","23","8","8","只要照着你们到今日所行的，专靠耶和华—你们的　神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS23_9","007_23_9","JOS","23","9","9","因为耶和华已经把又大又强的国民从你们面前赶出；直到今日，没有一人在你们面前站立得住。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS23_10","007_23_10","JOS","23","10","10","你们一人必追赶千人，因耶和华—你们的　神照他所应许的，为你们争战。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS23_11","007_23_11","JOS","23","11","11","你们要分外谨慎，爱耶和华—你们的　神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS23_12","007_23_12","JOS","23","12","12","你们若稍微转去，与你们中间所剩下的这些国民联络，彼此结亲，互相往来， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS23_13","007_23_13","JOS","23","13","13","你们要确实知道，耶和华—你们的　神必不再将他们从你们眼前赶出；他们却要成为你们的网罗、机槛、肋上的鞭、眼中的刺，直到你们在耶和华—你们　神所赐的这美地上灭亡。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS23_14","007_23_14","JOS","23","14","14","「我现在要走世人必走的路。你们是一心一意地知道，耶和华—你们　神所应许赐福与你们的话没有一句落空，都应验在你们身上了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS23_15","007_23_15","JOS","23","15","15","耶和华—你们　神所应许的一切福气怎样临到你们身上，耶和华也必照样使各样祸患临到你们身上，直到把你们从耶和华—你们　神所赐的这美地上除灭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS23_16","007_23_16","JOS","23","16","16","你们若违背耶和华—你们　神吩咐你们所守的约，去事奉别神，叩拜他，耶和华的怒气必向你们发作，使你们在他所赐的美地上速速灭亡。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS24_1","007_24_1","JOS","24","1","1","约书亚将以色列的众支派聚集在示剑，召了以色列的长老、族长、审判官，并官长来，他们就站在　神面前。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS24_2","007_24_2","JOS","24","2","2","约书亚对众民说：「耶和华—以色列的　神如此说：『古时你们的列祖，就是亚伯拉罕和拿鹤的父亲他拉，住在大河那边事奉别神， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS24_3","007_24_3","JOS","24","3","3","我将你们的祖宗亚伯拉罕从大河那边带来，领他走遍迦南全地，又使他的子孙众多，把以撒赐给他； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS24_4","007_24_4","JOS","24","4","4","又把雅各和以扫赐给以撒，将西珥山赐给以扫为业；后来雅各和他的子孙下到埃及去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS24_5","007_24_5","JOS","24","5","5","我差遣摩西、亚伦，并照我在埃及中所行的降灾与埃及，然后把你们领出来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS24_6","007_24_6","JOS","24","6","6","我领你们列祖出埃及，他们就到了红海；埃及人带领车辆马兵追赶你们列祖到红海。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS24_7","007_24_7","JOS","24","7","7","你们列祖哀求耶和华，他就使你们和埃及人中间黑暗了，又使海水淹没埃及人。我在埃及所行的事，你们亲眼见过。你们在旷野也住了许多年日。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS24_8","007_24_8","JOS","24","8","8","我领你们到约旦河东亚摩利人所住之地。他们与你们争战，我将他们交在你们手中，你们便得了他们的地为业；我也在你们面前将他们灭绝。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS24_9","007_24_9","JOS","24","9","9","那时，摩押王西拨的儿子巴勒起来攻击以色列人，打发人召了比珥的儿子巴兰来咒诅你们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS24_10","007_24_10","JOS","24","10","10","我不肯听巴兰的话，所以他倒为你们连连祝福。这样，我便救你们脱离巴勒的手。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS24_11","007_24_11","JOS","24","11","11","你们过了约旦河，到了耶利哥；耶利哥人、亚摩利人、比利洗人、迦南人、赫人、革迦撒人、希未人、耶布斯人都与你们争战；我把他们交在你们手里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS24_12","007_24_12","JOS","24","12","12","我打发黄蜂飞在你们前面，将亚摩利人的二王从你们面前撵出，并不是用你的刀，也不是用你的弓。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS24_13","007_24_13","JOS","24","13","13","我赐给你们地土，非你们所修治的；我赐给你们城邑，非你们所建造的。你们就住在其中，又得吃非你们所栽种的葡萄园、橄榄园的果子。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS24_14","007_24_14","JOS","24","14","14","「现在你们要敬畏耶和华，诚心实意地事奉他，将你们列祖在大河那边和在埃及所事奉的神除掉，去事奉耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS24_15","007_24_15","JOS","24","15","15","若是你们以事奉耶和华为不好，今日就可以选择所要事奉的：是你们列祖在大河那边所事奉的神呢？是你们所住这地的亚摩利人的神呢？至于我和我家，我们必定事奉耶和华。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS24_16","007_24_16","JOS","24","16","16","百姓回答说：「我们断不敢离弃耶和华去事奉别神； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS24_17","007_24_17","JOS","24","17","17","因耶和华—我们的　神曾将我们和我们列祖从埃及地的为奴之家领出来，在我们眼前行了那些大神迹，在我们所行的道上，所经过的诸国，都保护了我们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS24_18","007_24_18","JOS","24","18","18","耶和华又把住此地的亚摩利人都从我们面前赶出去。所以，我们必事奉耶和华，因为他是我们的　神。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS24_19","007_24_19","JOS","24","19","19","约书亚对百姓说：「你们不能事奉耶和华；因为他是圣洁的　神，是忌邪的　神，必不赦免你们的过犯罪恶。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS24_20","007_24_20","JOS","24","20","20","你们若离弃耶和华去事奉外邦神，耶和华在降福之后，必转而降祸与你们，把你们灭绝。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS24_21","007_24_21","JOS","24","21","21","百姓回答约书亚说：「不然，我们定要事奉耶和华。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS24_22","007_24_22","JOS","24","22","22","约书亚对百姓说：「你们选定耶和华，要事奉他，你们自己作见证吧！」他们说：「我们愿意作见证。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS24_23","007_24_23","JOS","24","23","23","约书亚说：「你们现在要除掉你们中间的外邦神，专心归向耶和华—以色列的　神。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS24_24","007_24_24","JOS","24","24","24","百姓回答约书亚说：「我们必事奉耶和华—我们的　神，听从他的话。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS24_25","007_24_25","JOS","24","25","25","当日，约书亚就与百姓立约，在示剑为他们立定律例典章。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS24_26","007_24_26","JOS","24","26","26","约书亚将这些话都写在　神的律法书上，又将一块大石头立在橡树下耶和华的圣所旁边。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS24_27","007_24_27","JOS","24","27","27","约书亚对百姓说：「看哪，这石头可以向我们作见证；因为是听见了耶和华所吩咐我们的一切话，倘或你们背弃你们的　神，这石头就可以向你们作见证。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS24_28","007_24_28","JOS","24","28","28","于是约书亚打发百姓各归自己的地业去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS24_29","007_24_29","JOS","24","29","29","这些事以后，耶和华的仆人嫩的儿子约书亚，正一百一十岁，就死了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS24_30","007_24_30","JOS","24","30","30","以色列人将他葬在他地业的境内，就是在以法莲山地的亭拿·西拉，在迦实山的北边。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS24_31","007_24_31","JOS","24","31","31","约书亚在世和约书亚死后，那些知道耶和华为以色列人所行诸事的长老还在的时候，以色列人事奉耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS24_32","007_24_32","JOS","24","32","32","以色列人从埃及所带来约瑟的骸骨，葬埋在示剑，就是在雅各从前用一百块银子向示剑的父亲、哈抹的子孙所买的那块地里；这就作了约瑟子孙的产业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JS24_33","007_24_33","JOS","24","33","33","亚伦的儿子以利亚撒也死了，就把他葬在他儿子非尼哈所得以法莲山地的小山上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG1_1","008_1_1","JDG","1","1","1","约书亚死后，以色列人求问耶和华说：「我们中间谁当首先上去攻击迦南人，与他们争战？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG1_2","008_1_2","JDG","1","2","2","耶和华说：「犹大当先上去，我已将那地交在他手中。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG1_3","008_1_3","JDG","1","3","3","犹大对他哥哥西缅说：「请你同我到拈阄所得之地去，好与迦南人争战；以后我也同你到你拈阄所得之地去。」于是西缅与他同去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG1_4","008_1_4","JDG","1","4","4","犹大就上去；耶和华将迦南人和比利洗人交在他们手中。他们在比色击杀了一万人， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG1_5","008_1_5","JDG","1","5","5","又在那里遇见亚多尼·比色，与他争战，杀败迦南人和比利洗人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG1_6","008_1_6","JDG","1","6","6","亚多尼·比色逃跑；他们追赶，拿住他，砍断他手脚的大拇指。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG1_7","008_1_7","JDG","1","7","7","亚多尼·比色说：「从前有七十个王，手脚的大拇指都被我砍断，在我桌子底下拾取零碎食物。现在　神按着我所行的报应我了。」于是他们将亚多尼·比色带到耶路撒冷，他就死在那里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG1_8","008_1_8","JDG","1","8","8","犹大人攻打耶路撒冷，将城攻取，用刀杀了城内的人，并且放火烧城。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG1_9","008_1_9","JDG","1","9","9","后来犹大人下去，与住山地、南地，和高原的迦南人争战。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG1_10","008_1_10","JDG","1","10","10","犹大人去攻击住希伯 的迦南人，杀了示筛、亚希幔、挞买。希伯 从前名叫基列·亚巴。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG1_11","008_1_11","JDG","1","11","11","他们从那里去攻击底壁的居民；底壁从前名叫基列·西弗。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG1_12","008_1_12","JDG","1","12","12","迦勒说：「谁能攻打基列·西弗，将城夺取，我就把我女儿押撒给他为妻。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG1_13","008_1_13","JDG","1","13","13","迦勒兄弟基纳斯的儿子俄陀聂夺取了那城，迦勒就把女儿押撒给他为妻。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG1_14","008_1_14","JDG","1","14","14","押撒过门的时候，劝丈夫向她父亲求一块田。押撒一下驴，迦勒问她说：「你要什么？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG1_15","008_1_15","JDG","1","15","15","她说：「求你赐福给我，你既将我安置在南地，求你也给我水泉。」迦勒就把上泉下泉赐给她。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG1_16","008_1_16","JDG","1","16","16","摩西的内兄是基尼人，他的子孙与犹大人一同离了棕树城，往亚拉得以南的犹大旷野去，就住在民中。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG1_17","008_1_17","JDG","1","17","17","犹大和他哥哥西缅同去，击杀了住洗法的迦南人，将城尽行毁灭，那城的名便叫何珥玛。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG1_18","008_1_18","JDG","1","18","18","犹大又取了迦萨和迦萨的四境，亚实基伦和亚实基伦的四境，以革伦和以革伦的四境。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG1_19","008_1_19","JDG","1","19","19","耶和华与犹大同在，犹大就赶出山地的居民，只是不能赶出平原的居民，因为他们有铁车。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG1_20","008_1_20","JDG","1","20","20","以色列人照摩西所说的，将希伯 给了迦勒；迦勒就从那里赶出亚衲族的三个族长。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG1_21","008_1_21","JDG","1","21","21","便雅悯人没有赶出住耶路撒冷的耶布斯人。耶布斯人仍在耶路撒冷与便雅悯人同住，直到今日。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG1_22","008_1_22","JDG","1","22","22","约瑟家也上去攻打伯特利；耶和华与他们同在。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG1_23","008_1_23","JDG","1","23","23","约瑟家打发人去窥探伯特利（那城起先名叫路斯）。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG1_24","008_1_24","JDG","1","24","24","窥探的人看见一个人从城里出来，就对他说：「求你将进城的路指示我们，我们必恩待你。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG1_25","008_1_25","JDG","1","25","25","那人将进城的路指示他们，他们就用刀击杀了城中的居民，但将那人和他全家放去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG1_26","008_1_26","JDG","1","26","26","那人往赫人之地去，筑了一座城，起名叫路斯。那城到如今还叫这名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG1_27","008_1_27","JDG","1","27","27","玛拿西没有赶出伯·善和属伯·善乡村的居民，他纳和属他纳乡村的居民，多珥和属多珥乡村的居民，以伯莲和属以伯莲乡村的居民，米吉多和属米吉多乡村的居民；迦南人却执意住在那些地方。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG1_28","008_1_28","JDG","1","28","28","及至以色列强盛了，就使迦南人做苦工，没有把他们全然赶出。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG1_29","008_1_29","JDG","1","29","29","以法莲没有赶出住基色的迦南人。于是迦南人仍住在基色，在以法莲中间。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG1_30","008_1_30","JDG","1","30","30","西布伦没有赶出基伦的居民和拿哈拉的居民。于是迦南人仍住在西布伦中间，成了服苦的人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG1_31","008_1_31","JDG","1","31","31","亚设没有赶出亚柯和西顿的居民，亚黑拉和亚革悉的居民，黑巴、亚弗革与利合的居民。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG1_32","008_1_32","JDG","1","32","32","于是，亚设因为没有赶出那地的迦南人，就住在他们中间。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG1_33","008_1_33","JDG","1","33","33","拿弗他利没有赶出伯·示麦和伯·亚纳的居民，于是拿弗他利就住在那地的迦南人中间；然而伯·示麦和伯·亚纳的居民成了服苦的人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG1_34","008_1_34","JDG","1","34","34","亚摩利人强逼但人住在山地，不容他们下到平原； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG1_35","008_1_35","JDG","1","35","35","亚摩利人却执意住在希烈山和亚雅 并沙宾。然而约瑟家胜了他们，使他们成了服苦的人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG1_36","008_1_36","JDG","1","36","36","亚摩利人的境界，是从亚克拉滨坡，从西拉而上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG2_1","008_2_1","JDG","2","1","1","耶和华的使者从吉甲上到波金，对以色列人说：「我使你们从埃及上来，领你们到我向你们列祖起誓应许之地。我又说：『我永不废弃与你们所立的约。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG2_2","008_2_2","JDG","2","2","2","你们也不可与这地的居民立约，要拆毁他们的祭坛。你们竟没有听从我的话！为何这样行呢？』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG2_3","008_2_3","JDG","2","3","3","因此我又说：『我必不将他们从你们面前赶出；他们必作你们肋下的荆棘。他们的神必作你们的网罗。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG2_4","008_2_4","JDG","2","4","4","耶和华的使者向以色列众人说这话的时候，百姓就放声而哭； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG2_5","008_2_5","JDG","2","5","5","于是给那地方起名叫波金。众人在那里向耶和华献祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG2_6","008_2_6","JDG","2","6","6","从前约书亚打发以色列百姓去的时候，他们各归自己的地业，占据地土。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG2_7","008_2_7","JDG","2","7","7","约书亚在世和约书亚死后，那些见耶和华为以色列人所行大事的长老还在的时候，百姓都事奉耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG2_8","008_2_8","JDG","2","8","8","耶和华的仆人、嫩的儿子约书亚，正一百一十岁就死了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG2_9","008_2_9","JDG","2","9","9","以色列人将他葬在他地业的境内，就是在以法莲山地的亭拿·希烈，在迦实山的北边。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG2_10","008_2_10","JDG","2","10","10","那世代的人也都归了自己的列祖。后来有别的世代兴起，不知道耶和华，也不知道耶和华为以色列人所行的事。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG2_11","008_2_11","JDG","2","11","11","以色列人行耶和华眼中看为恶的事，去事奉诸巴力， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG2_12","008_2_12","JDG","2","12","12","离弃了领他们出埃及地的耶和华—他们列祖的　神，去叩拜别神，就是四围列国的神，惹耶和华发怒； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG2_13","008_2_13","JDG","2","13","13","并离弃耶和华，去事奉巴力和亚斯她录。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG2_14","008_2_14","JDG","2","14","14","耶和华的怒气向以色列人发作，就把他们交在抢夺他们的人手中，又将他们付与四围仇敌的手中，甚至他们在仇敌面前再不能站立得住。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG2_15","008_2_15","JDG","2","15","15","他们无论往何处去，耶和华都以灾祸攻击他们，正如耶和华所说的话，又如耶和华向他们所起的誓；他们便极其困苦。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG2_16","008_2_16","JDG","2","16","16","耶和华兴起士师，士师就拯救他们脱离抢夺他们人的手。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG2_17","008_2_17","JDG","2","17","17","他们却不听从士师，竟随从叩拜别神，行了邪淫，速速地偏离他们列祖所行的道，不如他们列祖顺从耶和华的命令。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG2_18","008_2_18","JDG","2","18","18","耶和华为他们兴起士师，就与那士师同在。士师在世的一切日子，耶和华拯救他们脱离仇敌的手。他们因受欺压扰害，就哀声叹气，所以耶和华后悔了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG2_19","008_2_19","JDG","2","19","19","及至士师死后，他们就转去行恶，比他们列祖更甚，去事奉叩拜别神，总不断绝顽梗的恶行。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG2_20","008_2_20","JDG","2","20","20","于是耶和华的怒气向以色列人发作。他说：「因这民违背我吩咐他们列祖所守的约，不听从我的话， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG2_21","008_2_21","JDG","2","21","21","所以约书亚死的时候所剩下的各族，我必不再从他们面前赶出， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG2_22","008_2_22","JDG","2","22","22","为要借此试验以色列人，看他们肯照他们列祖谨守遵行我的道不肯。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG2_23","008_2_23","JDG","2","23","23","这样耶和华留下各族，不将他们速速赶出，也没有交付约书亚的手。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG3_1","008_3_1","JDG","3","1","1","耶和华留下这几族，为要试验那不曾知道与迦南争战之事的以色列人， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG3_2","008_3_2","JDG","3","2","2","好叫以色列的后代又知道又学习未曾晓得的战事。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG3_3","008_3_3","JDG","3","3","3","所留下的就是非利士的五个首领和一切迦南人、西顿人，并住黎巴嫩山的希未人，从巴力·黑们山直到哈马口。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG3_4","008_3_4","JDG","3","4","4","留下这几族，为要试验以色列人，知道他们肯听从耶和华借摩西吩咐他们列祖的诫命不肯。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG3_5","008_3_5","JDG","3","5","5","以色列人竟住在迦南人、赫人、亚摩利人、比利洗人、希未人、耶布斯人中间， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG3_6","008_3_6","JDG","3","6","6","娶他们的女儿为妻，将自己的女儿嫁给他们的儿子，并事奉他们的神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG3_7","008_3_7","JDG","3","7","7","以色列人行耶和华眼中看为恶的事，忘记耶和华—他们的　神，去事奉诸巴力和亚舍拉， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG3_8","008_3_8","JDG","3","8","8","所以耶和华的怒气向以色列人发作，就把他们交在美索不达米亚王古珊·利萨田的手中。以色列人服事古珊·利萨田八年。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG3_9","008_3_9","JDG","3","9","9","以色列人呼求耶和华的时候，耶和华就为他们兴起一位拯救者救他们，就是迦勒兄弟基纳斯的儿子俄陀聂。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG3_10","008_3_10","JDG","3","10","10","耶和华的灵降在他身上，他就作了以色列的士师，出去争战。耶和华将美索不达米亚王古珊·利萨田交在他手中，他便胜了古珊·利萨田。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG3_11","008_3_11","JDG","3","11","11","于是国中太平四十年。基纳斯的儿子俄陀聂死了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG3_12","008_3_12","JDG","3","12","12","以色列人又行耶和华眼中看为恶的事，耶和华就使摩押王伊矶伦强盛，攻击以色列人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG3_13","008_3_13","JDG","3","13","13","伊矶伦招聚亚扪人和亚玛力人，去攻打以色列人，占据棕树城。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG3_14","008_3_14","JDG","3","14","14","于是以色列人服事摩押王伊矶伦十八年。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG3_15","008_3_15","JDG","3","15","15","以色列人呼求耶和华的时候，耶和华就为他们兴起一位拯救者，就是便雅悯人基拉的儿子以笏；他是左手便利的。以色列人托他送礼物给摩押王伊矶伦。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG3_16","008_3_16","JDG","3","16","16","以笏打了一把两刃的剑，长一肘，带在右腿上衣服里面。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG3_17","008_3_17","JDG","3","17","17","他将礼物献给摩押王伊矶伦（原来伊矶伦极其肥胖）； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG3_18","008_3_18","JDG","3","18","18","以笏献完礼物，便将抬礼物的人打发走了， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG3_19","008_3_19","JDG","3","19","19","自己却从靠近吉甲凿石之地回来，说：「王啊，我有一件机密事奏告你。」王说：「回避吧！」于是左右侍立的人都退去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG3_20","008_3_20","JDG","3","20","20","以笏来到王面前；王独自一人坐在凉楼上。以笏说：「我奉　神的命报告你一件事。」王就从座位上站起来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG3_21","008_3_21","JDG","3","21","21","以笏便伸左手，从右腿上拔出剑来，刺入王的肚腹， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG3_22","008_3_22","JDG","3","22","22","连剑把都刺进去了。剑被肥肉夹住，他没有从王的肚腹拔出来，且穿通了后身。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG3_23","008_3_23","JDG","3","23","23","以笏就出到游廊，将楼门尽都关锁。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG3_24","008_3_24","JDG","3","24","24","以笏出来之后，王的仆人到了，看见楼门关锁，就说：「他必是在楼上大解。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG3_25","008_3_25","JDG","3","25","25","他们等烦了，见仍不开楼门，就拿钥匙开了，不料，他们的主人已死，倒在地上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG3_26","008_3_26","JDG","3","26","26","他们耽延的时候，以笏就逃跑了，经过凿石之地，逃到西伊拉； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG3_27","008_3_27","JDG","3","27","27","到了，就在以法莲山地吹角。以色列人随着他下了山地，他在前头引路， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG3_28","008_3_28","JDG","3","28","28","对他们说：「你们随我来，因为耶和华已经把你们的仇敌摩押人交在你们手中。」于是他们跟着他下去，把守约旦河的渡口，不容摩押一人过去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG3_29","008_3_29","JDG","3","29","29","那时击杀了摩押人约有一万，都是强壮的勇士，没有一人逃脱。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG3_30","008_3_30","JDG","3","30","30","这样，摩押就被以色列人制伏了。国中太平八十年。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG3_31","008_3_31","JDG","3","31","31","以笏之后，有亚拿的儿子珊迦，他用赶牛的棍子打死六百非利士人。他也救了以色列人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG4_1","008_4_1","JDG","4","1","1","以笏死后，以色列人又行耶和华眼中看为恶的事， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG4_2","008_4_2","JDG","4","2","2","耶和华就把他们付与在夏琐作王的迦南王耶宾手中；他的将军是西西拉，住在外邦人的夏罗设。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG4_3","008_4_3","JDG","4","3","3","耶宾王有铁车九百辆。他大大欺压以色列人二十年，以色列人就呼求耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG4_4","008_4_4","JDG","4","4","4","有一位女先知名叫底波拉，是拉比多的妻，当时作以色列的士师。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG4_5","008_4_5","JDG","4","5","5","她住在以法莲山地拉玛和伯特利中间，在底波拉的棕树下。以色列人都上她那里去听判断。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG4_6","008_4_6","JDG","4","6","6","她打发人从拿弗他利的基低斯将亚比挪庵的儿子巴拉召了来，对他说：「耶和华—以色列的　神吩咐你说：『你率领一万拿弗他利和西布伦人上他泊山去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG4_7","008_4_7","JDG","4","7","7","我必使耶宾的将军西西拉率领他的车辆和全军往基顺河，到你那里去；我必将他交在你手中。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG4_8","008_4_8","JDG","4","8","8","巴拉说：「你若同我去，我就去；你若不同我去，我就不去。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG4_9","008_4_9","JDG","4","9","9","底波拉说：「我必与你同去，只是你在所行的路上得不着荣耀，因为耶和华要将西西拉交在一个妇人手里。」于是底波拉起来，与巴拉一同往基低斯去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG4_10","008_4_10","JDG","4","10","10","巴拉就招聚西布伦人和拿弗他利人到基低斯，跟他上去的有一万人。底波拉也同他上去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG4_11","008_4_11","JDG","4","11","11","摩西岳父何巴的后裔，基尼人希百曾离开基尼族，到靠近基低斯、撒拿音的橡树旁支搭帐棚。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG4_12","008_4_12","JDG","4","12","12","有人告诉西西拉说：「亚比挪庵的儿子巴拉已经上他泊山了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG4_13","008_4_13","JDG","4","13","13","西西拉就聚集所有的铁车九百辆和跟随他的全军，从外邦人的夏罗设出来，到了基顺河。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG4_14","008_4_14","JDG","4","14","14","底波拉对巴拉说：「你起来，今日就是耶和华将西西拉交在你手的日子。耶和华岂不在你前头行吗？」于是巴拉下了他泊山，跟随他有一万人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG4_15","008_4_15","JDG","4","15","15","耶和华使西西拉和他一切车辆全军溃乱，在巴拉面前被刀杀败；西西拉下车步行逃跑。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG4_16","008_4_16","JDG","4","16","16","巴拉追赶车辆、军队，直到外邦人的夏罗设。西西拉的全军都倒在刀下，没有留下一人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG4_17","008_4_17","JDG","4","17","17","只有西西拉步行逃跑，到了基尼人希百之妻雅亿的帐棚，因为夏琐王耶宾与基尼人希百家和好。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG4_18","008_4_18","JDG","4","18","18","雅亿出来迎接西西拉，对他说：「请我主进来，不要惧怕」；西西拉就进了她的帐棚。雅亿用被将他遮盖。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG4_19","008_4_19","JDG","4","19","19","西西拉对雅亿说：「我渴了，求你给我一点水喝。」雅亿就打开皮袋，给他奶子喝，仍旧把他遮盖。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG4_20","008_4_20","JDG","4","20","20","西西拉又对雅亿说：「请你站在帐棚门口，若有人来问你说：『有人在这里没有？』你就说：『没有。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG4_21","008_4_21","JDG","4","21","21","西西拉疲乏沉睡。希百的妻雅亿取了帐棚的橛子，手里拿着锤子，轻悄悄地到他旁边，将橛子从他鬓边钉进去，钉入地里。西西拉就死了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG4_22","008_4_22","JDG","4","22","22","巴拉追赶西西拉的时候，雅亿出来迎接他说：「来吧，我将你所寻找的人给你看。」他就进入帐棚，看见西西拉已经死了，倒在地上，橛子还在他鬓中。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG4_23","008_4_23","JDG","4","23","23","这样，　神使迦南王耶宾被以色列人制伏了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG4_24","008_4_24","JDG","4","24","24","从此以色列人的手越发有力，胜了迦南王耶宾，直到将他灭绝了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG5_1","008_5_1","JDG","5","1","1","那时，底波拉和亚比挪庵的儿子巴拉作歌，说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG5_2","008_5_2","JDG","5","2","2","因为以色列中有军长率领， 百姓也甘心牺牲自己， 你们应当颂赞耶和华！ ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG5_3","008_5_3","JDG","5","3","3","君王啊，要听！ 王子啊，要侧耳而听！ 我要向耶和华歌唱； 我要歌颂耶和华—以色列的　神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG5_4","008_5_4","JDG","5","4","4","耶和华啊，你从西珥出来， 由以东地行走。 那时地震天漏， 云也落雨。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG5_5","008_5_5","JDG","5","5","5","山见耶和华的面就震动， 西奈山见耶和华—以色列　神的面也是如此。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG5_6","008_5_6","JDG","5","6","6","在亚拿之子珊迦的时候， 又在雅亿的日子， 大道无人行走， 都是绕道而行。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG5_7","008_5_7","JDG","5","7","7","以色列中的官长停职， 直到我底波拉兴起， 等我兴起作以色列的母。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG5_8","008_5_8","JDG","5","8","8","以色列人选择新神， 争战的事就临到城门。 那时，以色列四万人中 岂能见盾牌枪矛呢？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG5_9","008_5_9","JDG","5","9","9","我心倾向以色列的首领， 他们在民中甘心牺牲自己。 你们应当颂赞耶和华！ ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG5_10","008_5_10","JDG","5","10","10","骑白驴的、坐绣花毯子的、行路的， 你们都当传扬！ ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG5_11","008_5_11","JDG","5","11","11","在远离弓箭响声打水之处， 人必述说耶和华公义的作为， 就是他治理以色列公义的作为。 那时耶和华的民下到城门。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG5_12","008_5_12","JDG","5","12","12","底波拉啊，兴起！兴起！ 你当兴起，兴起，唱歌。 亚比挪庵的儿子巴拉啊，你当奋兴， 掳掠你的敌人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG5_13","008_5_13","JDG","5","13","13","那时有余剩的贵胄和百姓一同下来； 耶和华降临，为我攻击勇士。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG5_14","008_5_14","JDG","5","14","14","有根本在亚玛力人的地， 从以法莲下来的； 便雅悯在民中跟随你。 有掌权的从玛吉下来； 有持杖检点民数的从西布伦下来； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG5_15","008_5_15","JDG","5","15","15","以萨迦的首领与底波拉同来； 以萨迦怎样，巴拉也怎样。 众人都跟随巴拉冲下平原； 在吕便的溪水旁有心中定大志的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG5_16","008_5_16","JDG","5","16","16","你为何坐在羊圈内 听群中吹笛的声音呢？ 在吕便的溪水旁有心中设大谋的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG5_17","008_5_17","JDG","5","17","17","基列人安居在约旦河外。 但人为何等在船上？ 亚设人在海口静坐， 在港口安居。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG5_18","008_5_18","JDG","5","18","18","西布伦人是拚命敢死的； 拿弗他利人在田野的高处也是如此。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG5_19","008_5_19","JDG","5","19","19","君王都来争战。 那时迦南诸王在米吉多水旁的他纳争战， 却未得掳掠银钱。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG5_20","008_5_20","JDG","5","20","20","星宿从天上争战， 从其轨道攻击西西拉。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG5_21","008_5_21","JDG","5","21","21","基顺古河把敌人冲没； 我的灵啊，应当努力前行。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG5_22","008_5_22","JDG","5","22","22","那时壮马驰驱， 踢跳，奔腾。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG5_23","008_5_23","JDG","5","23","23","耶和华的使者说： 应当咒诅米罗斯， 大大咒诅其中的居民； 因为他们不来帮助耶和华， 不来帮助耶和华攻击勇士。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG5_24","008_5_24","JDG","5","24","24","愿基尼人希百的妻雅亿比众妇人多得福气， 比住帐棚的妇人更蒙福祉。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG5_25","008_5_25","JDG","5","25","25","西西拉求水， 雅亿给他奶子， 用宝贵的盘子给他奶油。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG5_26","008_5_26","JDG","5","26","26","雅亿左手拿着帐棚的橛子， 右手拿着匠人的锤子， 击打西西拉， 打伤他的头， 把他的鬓角打破穿通。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG5_27","008_5_27","JDG","5","27","27","西西拉在她脚前曲身仆倒， 在她脚前曲身倒卧； 在那里曲身，就在那里死亡。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG5_28","008_5_28","JDG","5","28","28","西西拉的母亲从窗户里往外观看， 从窗棂中呼叫说： 他的战车为何耽延不来呢？ 他的车轮为何行得慢呢？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG5_29","008_5_29","JDG","5","29","29","聪明的宫女安慰她， 她也自言自语地说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG5_30","008_5_30","JDG","5","30","30","他们莫非得财而分？ 每人得了一两个女子？ 西西拉得了彩衣为掳物， 得绣花的彩衣为掠物。 这彩衣两面绣花， 乃是披在被掳之人颈项上的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG5_31","008_5_31","JDG","5","31","31","耶和华啊， 愿你的仇敌都这样灭亡！ 愿爱你的人如日头出现，光辉烈烈！ 这样，国中太平四十年。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG6_1","008_6_1","JDG","6","1","1","以色列人又行耶和华眼中看为恶的事，耶和华就把他们交在米甸人手里七年。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG6_2","008_6_2","JDG","6","2","2","米甸人压制以色列人；以色列人因为米甸人，就在山中挖穴、挖洞、建造营寨。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG6_3","008_6_3","JDG","6","3","3","以色列人每逢撒种之后，米甸人、亚玛力人，和东方人都上来攻打他们， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG6_4","008_6_4","JDG","6","4","4","对着他们安营，毁坏土产，直到迦萨，没有给以色列人留下食物，牛、羊、驴也没有留下； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG6_5","008_6_5","JDG","6","5","5","因为那些人带着牲畜帐棚来，像蝗虫那样多，人和骆驼无数，都进入国内，毁坏全地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG6_6","008_6_6","JDG","6","6","6","以色列人因米甸人的缘故，极其穷乏，就呼求耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG6_7","008_6_7","JDG","6","7","7","以色列人因米甸人的缘故，呼求耶和华， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG6_8","008_6_8","JDG","6","8","8","耶和华就差遣先知到以色列人那里，对他们说：「耶和华—以色列的　神如此说：『我曾领你们从埃及上来，出了为奴之家， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG6_9","008_6_9","JDG","6","9","9","救你们脱离埃及人的手，并脱离一切欺压你们之人的手，把他们从你们面前赶出，将他们的地赐给你们』； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG6_10","008_6_10","JDG","6","10","10","又对你们说：『我是耶和华—你们的　神。你们住在亚摩利人的地，不可敬畏他们的神。你们竟不听从我的话。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG6_11","008_6_11","JDG","6","11","11","耶和华的使者到了俄弗拉，坐在亚比以谢族人约阿施的橡树下。约阿施的儿子基甸正在酒榨那里打麦子，为要防备米甸人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG6_12","008_6_12","JDG","6","12","12","耶和华的使者向基甸显现，对他说：「大能的勇士啊，耶和华与你同在！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG6_13","008_6_13","JDG","6","13","13","基甸说：「主啊，耶和华若与我们同在，我们何至遭遇这一切事呢？我们的列祖不是向我们说『耶和华领我们从埃及上来』吗？他那样奇妙的作为在哪里呢？现在他却丢弃我们，将我们交在米甸人手里。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG6_14","008_6_14","JDG","6","14","14","耶和华观看基甸，说：「你靠着你这能力去从米甸人手里拯救以色列人，不是我差遣你去的吗？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG6_15","008_6_15","JDG","6","15","15","基甸说：「主啊，我有何能拯救以色列人呢？我家在玛拿西支派中是至贫穷的。我在我父家是至微小的。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG6_16","008_6_16","JDG","6","16","16","耶和华对他说：「我与你同在，你就必击打米甸人，如击打一人一样。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG6_17","008_6_17","JDG","6","17","17","基甸说：「我若在你眼前蒙恩，求你给我一个证据，使我知道与我说话的就是主。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG6_18","008_6_18","JDG","6","18","18","求你不要离开这里，等我归回将礼物带来供在你面前。」主说：「我必等你回来。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG6_19","008_6_19","JDG","6","19","19","基甸去预备了一只山羊羔，用一伊法细面做了无酵饼，将肉放在筐内，把汤盛在壶中，带到橡树下，献在使者面前。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG6_20","008_6_20","JDG","6","20","20","神的使者吩咐基甸说：「将肉和无酵饼放在这磐石上，把汤倒出来。」他就这样行了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG6_21","008_6_21","JDG","6","21","21","耶和华的使者伸出手内的杖，杖头挨了肉和无酵饼，就有火从磐石中出来，烧尽了肉和无酵饼。耶和华的使者也就不见了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG6_22","008_6_22","JDG","6","22","22","基甸见他是耶和华的使者，就说：「哀哉！主耶和华啊，我不好了，因为我觌面看见耶和华的使者。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG6_23","008_6_23","JDG","6","23","23","耶和华对他说：「你放心，不要惧怕，你必不至死。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG6_24","008_6_24","JDG","6","24","24","于是基甸在那里为耶和华筑了一座坛，起名叫「耶和华沙龙」。（这坛在亚比以谢族的俄弗拉直到如今。） ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG6_25","008_6_25","JDG","6","25","25","当那夜，耶和华吩咐基甸说：「你取你父亲的牛来，就是那七岁的第二只牛，并拆毁你父亲为巴力所筑的坛，砍下坛旁的木偶， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG6_26","008_6_26","JDG","6","26","26","在这磐石上整整齐齐地为耶和华—你的　神筑一座坛，将第二只牛献为燔祭，用你所砍下的木偶作柴。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG6_27","008_6_27","JDG","6","27","27","基甸就从他仆人中挑了十个人，照着耶和华吩咐他的行了。他因怕父家和本城的人，不敢在白昼行这事，就在夜间行了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG6_28","008_6_28","JDG","6","28","28","城里的人清早起来，见巴力的坛拆毁，坛旁的木偶砍下，第二只牛献在新筑的坛上， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG6_29","008_6_29","JDG","6","29","29","就彼此说：「这事是谁做的呢？」他们访查之后，就说：「这是约阿施的儿子基甸做的。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG6_30","008_6_30","JDG","6","30","30","城里的人对约阿施说：「将你儿子交出来，好治死他；因为他拆毁了巴力的坛，砍下坛旁的木偶。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG6_31","008_6_31","JDG","6","31","31","约阿施回答站着攻击他的众人说：「你们是为巴力争论吗？你们要救他吗？谁为他争论，趁早将谁治死！巴力若果是神，有人拆毁他的坛，让他为自己争论吧！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG6_32","008_6_32","JDG","6","32","32","所以当日人称基甸为耶路·巴力，意思说：「他拆毁巴力的坛，让巴力与他争论。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG6_33","008_6_33","JDG","6","33","33","那时，米甸人、亚玛力人，和东方人都聚集过河，在耶斯列平原安营。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG6_34","008_6_34","JDG","6","34","34","耶和华的灵降在基甸身上，他就吹角；亚比以谢族都聚集跟随他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG6_35","008_6_35","JDG","6","35","35","他打发人走遍玛拿西地，玛拿西人也聚集跟随他；又打发人去见亚设人、西布伦人、拿弗他利人，他们也都出来与他们会合。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG6_36","008_6_36","JDG","6","36","36","基甸对　神说：「你若果照着所说的话，借我手拯救以色列人， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG6_37","008_6_37","JDG","6","37","37","我就把一团羊毛放在禾场上：若单是羊毛上有露水，别的地方都是干的，我就知道你必照着所说的话，借我手拯救以色列人。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG6_38","008_6_38","JDG","6","38","38","次日早晨基甸起来，见果然是这样；将羊毛挤一挤，从羊毛中拧出满盆的露水来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG6_39","008_6_39","JDG","6","39","39","基甸又对　神说：「求你不要向我发怒，我再说这一次：让我将羊毛再试一次。但愿羊毛是干的，别的地方都有露水。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG6_40","008_6_40","JDG","6","40","40","这夜　神也如此行：独羊毛上是干的，别的地方都有露水。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG7_1","008_7_1","JDG","7","1","1","耶路·巴力就是基甸，他和一切跟随的人早晨起来，在哈律泉旁安营。米甸营在他们北边的平原，靠近摩利冈。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG7_2","008_7_2","JDG","7","2","2","耶和华对基甸说：「跟随你的人过多，我不能将米甸人交在他们手中，免得以色列人向我夸大，说：『是我们自己的手救了我们。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG7_3","008_7_3","JDG","7","3","3","现在你要向这些人宣告说：『凡惧怕胆怯的，可以离开基列山回去。』」于是有二万二千人回去，只剩下一万。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG7_4","008_7_4","JDG","7","4","4","耶和华对基甸说：「人还是过多；你要带他们下到水旁，我好在那里为你试试他们。我指点谁说：『这人可以同你去』，他就可以同你去；我指点谁说：『这人不可同你去』，他就不可同你去。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG7_5","008_7_5","JDG","7","5","5","基甸就带他们下到水旁。耶和华对基甸说：「凡用舌头舔水，像狗舔的，要使他单站在一处；凡跪下喝水的，也要使他单站在一处。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG7_6","008_7_6","JDG","7","6","6","于是用手捧着舔水的有三百人，其余的都跪下喝水。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG7_7","008_7_7","JDG","7","7","7","耶和华对基甸说：「我要用这舔水的三百人拯救你们，将米甸人交在你手中；其余的人都可以各归各处去。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG7_8","008_7_8","JDG","7","8","8","这三百人就带着食物和角；其余的以色列人，基甸都打发他们各归各的帐棚，只留下这三百人。米甸营在他下边的平原里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG7_9","008_7_9","JDG","7","9","9","当那夜，耶和华吩咐基甸说：「起来，下到米甸营里去，因我已将他们交在你手中。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG7_10","008_7_10","JDG","7","10","10","倘若你怕下去，就带你的仆人普拉下到那营里去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG7_11","008_7_11","JDG","7","11","11","你必听见他们所说的，然后你就有胆量下去攻营。」于是基甸带着仆人普拉下到营旁。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG7_12","008_7_12","JDG","7","12","12","米甸人、亚玛力人，和一切东方人都布散在平原，如同蝗虫那样多。他们的骆驼无数，多如海边的沙。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG7_13","008_7_13","JDG","7","13","13","基甸到了，就听见一人将梦告诉同伴说：「我做了一梦，梦见一个大麦饼滚入米甸营中，到了帐幕，将帐幕撞倒，帐幕就翻转倾覆了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG7_14","008_7_14","JDG","7","14","14","那同伴说：「这不是别的，乃是以色列人约阿施的儿子基甸的刀；　神已将米甸和全军都交在他的手中。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG7_15","008_7_15","JDG","7","15","15","基甸听见这梦和梦的讲解，就敬拜　神，回到以色列营中，说：「起来吧！耶和华已将米甸的军队交在你们手中了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG7_16","008_7_16","JDG","7","16","16","于是基甸将三百人分作三队，把角和空瓶交在各人手里（瓶内都藏着火把）， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG7_17","008_7_17","JDG","7","17","17","吩咐他们说：「你们要看我行事：我到了营的旁边怎样行，你们也要怎样行。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG7_18","008_7_18","JDG","7","18","18","我和一切跟随我的人吹角的时候，你们也要在营的四围吹角，喊叫说：『耶和华和基甸的刀！』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG7_19","008_7_19","JDG","7","19","19","基甸和跟随他的一百人，在三更之初才换更的时候，来到营旁，就吹角，打破手中的瓶。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG7_20","008_7_20","JDG","7","20","20","三队的人就都吹角，打破瓶子，左手拿着火把，右手拿着角，喊叫说：「耶和华和基甸的刀！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG7_21","008_7_21","JDG","7","21","21","他们在营的四围各站各的地方；全营的人都乱窜。三百人呐喊，使他们逃跑。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG7_22","008_7_22","JDG","7","22","22","三百人就吹角，耶和华使全营的人用刀互相击杀，逃到西利拉的伯·哈示他，直逃到靠近他巴的亚伯·米何拉。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG7_23","008_7_23","JDG","7","23","23","以色列人就从拿弗他利、亚设，和玛拿西全地聚集来追赶米甸人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG7_24","008_7_24","JDG","7","24","24","基甸打发人走遍以法莲山地，说：「你们下来攻击米甸人，争先把守约旦河的渡口，直到伯·巴拉。」于是以法莲的众人聚集，把守约旦河的渡口，直到伯·巴拉， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG7_25","008_7_25","JDG","7","25","25","捉住了米甸人的两个首领：一名俄立，一名西伊伯；将俄立杀在俄立磐石上，将西伊伯杀在西伊伯酒榨那里；又追赶米甸人，将俄立和西伊伯的首级带过约旦河，到基甸那里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG8_1","008_8_1","JDG","8","1","1","以法莲人对基甸说：「你去与米甸人争战，没有招我们同去，为什么这样待我们呢？」他们就与基甸大大地争吵。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG8_2","008_8_2","JDG","8","2","2","基甸对他们说：「我所行的岂能比你们所行的呢？以法莲拾取剩下的葡萄不强过亚比以谢所摘的葡萄吗？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG8_3","008_8_3","JDG","8","3","3","神已将米甸人的两个首领俄立和西伊伯交在你们手中；我所行的岂能比你们所行的呢？」基甸说了这话，以法莲人的怒气就消了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG8_4","008_8_4","JDG","8","4","4","基甸和跟随他的三百人到约旦河过渡，虽然疲乏，还是追赶。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG8_5","008_8_5","JDG","8","5","5","基甸对疏割人说：「求你们拿饼来给跟随我的人吃，因为他们疲乏了；我们追赶米甸人的两个王西巴和撒慕拿。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG8_6","008_8_6","JDG","8","6","6","疏割人的首领回答说：「西巴和撒慕拿已经在你手里，你使我们将饼给你的军兵吗？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG8_7","008_8_7","JDG","8","7","7","基甸说：「耶和华将西巴和撒慕拿交在我手之后，我就用野地的荆条和枳棘打伤你们。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG8_8","008_8_8","JDG","8","8","8","基甸从那里上到毗努伊勒，对那里的人也是这样说；毗努伊勒人也与疏割人回答他的话一样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG8_9","008_8_9","JDG","8","9","9","他向毗努伊勒人说：「我平平安安回来的时候，我必拆毁这楼。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG8_10","008_8_10","JDG","8","10","10","那时西巴和撒慕拿，并跟随他们的军队都在加各，约有一万五千人，就是东方人全军所剩下的；已经被杀约有十二万拿刀的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG8_11","008_8_11","JDG","8","11","11","基甸就由挪巴和约比哈东边，从住帐棚人的路上去，杀败了米甸人的军兵，因为他们坦然无惧。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG8_12","008_8_12","JDG","8","12","12","西巴和撒慕拿逃跑；基甸追赶他们，捉住米甸的二王西巴和撒慕拿，惊散全军。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG8_13","008_8_13","JDG","8","13","13","约阿施的儿子基甸由希列斯坡从阵上回来， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG8_14","008_8_14","JDG","8","14","14","捉住疏割的一个少年人，问他：「疏割的首领长老是谁？」他就将首领长老七十七个人的名字写出来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG8_15","008_8_15","JDG","8","15","15","基甸到了疏割，对那里的人说：「你们从前讥诮我说：『西巴和撒慕拿已经在你手里，你使我们将饼给跟随你的疲乏人吗？』现在西巴和撒慕拿在这里。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG8_16","008_8_16","JDG","8","16","16","于是捉住那城内的长老，用野地的荆条和枳棘责打疏割人； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG8_17","008_8_17","JDG","8","17","17","又拆了毗努伊勒的楼，杀了那城里的人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG8_18","008_8_18","JDG","8","18","18","基甸问西巴和撒慕拿说：「你们在他泊山所杀的人是什么样式？」回答说：「他们好像你，各人都有王子的样式。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG8_19","008_8_19","JDG","8","19","19","基甸说：「他们是我同母的弟兄，我指着永生的耶和华起誓，你们从前若存留他们的性命，我如今就不杀你们了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG8_20","008_8_20","JDG","8","20","20","于是对他的长子益帖说：「你起来杀他们。」但益帖因为是童子，害怕，不敢拔刀。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG8_21","008_8_21","JDG","8","21","21","西巴和撒慕拿说：「你自己起来杀我们吧！因为人如何，力量也是如何。」基甸就起来，杀了西巴和撒慕拿，夺获他们骆驼项上戴的月牙圈。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG8_22","008_8_22","JDG","8","22","22","以色列人对基甸说：「你既救我们脱离米甸人的手，愿你和你的儿孙管理我们。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG8_23","008_8_23","JDG","8","23","23","基甸说：「我不管理你们，我的儿子也不管理你们，惟有耶和华管理你们。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG8_24","008_8_24","JDG","8","24","24","基甸又对他们说：「我有一件事求你们：请你们各人将所夺的耳环给我。」（原来仇敌是以实玛利人，都是戴金耳环的。） ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG8_25","008_8_25","JDG","8","25","25","他们说：「我们情愿给你」，就铺开一件外衣，各人将所夺的耳环丢在其上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG8_26","008_8_26","JDG","8","26","26","基甸所要出来的金耳环重一千七百舍客勒金子。此外还有米甸王所戴的月环、耳坠，和所穿的紫色衣服，并骆驼项上的金链子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG8_27","008_8_27","JDG","8","27","27","基甸以此制造了一个以弗得，设立在本城俄弗拉。后来以色列人拜那以弗得行了邪淫；这就作了基甸和他全家的网罗。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG8_28","008_8_28","JDG","8","28","28","这样，米甸人被以色列人制伏了，不敢再抬头。基甸还在的日子，国中太平四十年。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG8_29","008_8_29","JDG","8","29","29","约阿施的儿子耶路·巴力回去，住在自己家里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG8_30","008_8_30","JDG","8","30","30","基甸有七十个亲生的儿子，因为他有许多的妻。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG8_31","008_8_31","JDG","8","31","31","他的妾住在示剑，也给他生了一个儿子。基甸与他起名叫亚比米勒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG8_32","008_8_32","JDG","8","32","32","约阿施的儿子基甸，年纪老迈而死，葬在亚比以谢族的俄弗拉，在他父亲约阿施的坟墓里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG8_33","008_8_33","JDG","8","33","33","基甸死后，以色列人又去随从诸巴力行邪淫，以巴力·比利土为他们的神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG8_34","008_8_34","JDG","8","34","34","以色列人不记念耶和华—他们的　神，就是拯救他们脱离四围仇敌之手的， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG8_35","008_8_35","JDG","8","35","35","也不照着耶路·巴力，就是基甸向他们所施的恩惠厚待他的家。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_1","008_9_1","JDG","9","1","1","耶路·巴力的儿子亚比米勒到了示剑见他的众母舅，对他们和他外祖全家的人说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_2","008_9_2","JDG","9","2","2","「请你们问示剑的众人说，是耶路·巴力的众子七十人都管理你们好呢？还是一人管理你们好呢？你们又要记念我是你们的骨肉。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_3","008_9_3","JDG","9","3","3","他的众母舅便将这一切话为他说给示剑人听，示剑人的心就归向亚比米勒。他们说：「他原是我们的弟兄」； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_4","008_9_4","JDG","9","4","4","就从巴力·比利土的庙中取了七十舍客勒银子给亚比米勒；亚比米勒用以雇了些匪徒跟随他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_5","008_9_5","JDG","9","5","5","他往俄弗拉到他父亲的家，将他弟兄、耶路·巴力的众子七十人都杀在一块磐石上；只剩下耶路·巴力的小儿子约坦，因为他躲藏了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_6","008_9_6","JDG","9","6","6","示剑人和米罗人都一同聚集，往示剑橡树旁的柱子那里，立亚比米勒为王。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_7","008_9_7","JDG","9","7","7","有人将这事告诉约坦，他就去站在基利心山顶上，向众人大声喊叫说：「示剑人哪，你们要听我的话，　神也就听你们的话。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_8","008_9_8","JDG","9","8","8","有一时，树木要膏一树为王，管理他们，就去对橄榄树说：『请你作我们的王。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_9","008_9_9","JDG","9","9","9","橄榄树回答说：『我岂肯止住供奉神和尊重人的油，飘摇在众树之上呢？』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_10","008_9_10","JDG","9","10","10","树木对无花果树说：『请你来作我们的王。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_11","008_9_11","JDG","9","11","11","无花果树回答说：『我岂肯止住所结甜美的果子，飘摇在众树之上呢？』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_12","008_9_12","JDG","9","12","12","树木对葡萄树说：『请你来作我们的王。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_13","008_9_13","JDG","9","13","13","葡萄树回答说：『我岂肯止住使神和人喜乐的新酒，飘摇在众树之上呢？』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_14","008_9_14","JDG","9","14","14","众树对荆棘说：『请你来作我们的王。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_15","008_9_15","JDG","9","15","15","荆棘回答说：『你们若诚诚实实地膏我为王，就要投在我的荫下；不然，愿火从荆棘里出来，烧灭黎巴嫩的香柏树。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_16","008_9_16","JDG","9","16","16","「现在你们立亚比米勒为王，若按诚实正直善待耶路·巴力和他的全家，这就是酬他的劳。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_17","008_9_17","JDG","9","17","17","从前我父冒死为你们争战，救了你们脱离米甸人的手。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_18","008_9_18","JDG","9","18","18","你们如今起来攻击我的父家，将他众子七十人杀在一块磐石上，又立他婢女所生的儿子亚比米勒为示剑人的王；他原是你们的弟兄。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_19","008_9_19","JDG","9","19","19","你们如今若按诚实正直待耶路·巴力和他的家，就可因亚比米勒得欢乐，他也可因你们得欢乐； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_20","008_9_20","JDG","9","20","20","不然，愿火从亚比米勒发出，烧灭示剑人和米罗众人，又愿火从示剑人和米罗人中出来，烧灭亚比米勒。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_21","008_9_21","JDG","9","21","21","约坦因怕他弟兄亚比米勒，就逃跑，来到比珥，住在那里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_22","008_9_22","JDG","9","22","22","亚比米勒管理以色列人三年。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_23","008_9_23","JDG","9","23","23","神使恶魔降在亚比米勒和示剑人中间，示剑人就以诡诈待亚比米勒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_24","008_9_24","JDG","9","24","24","这是要叫耶路·巴力七十个儿子所受的残害归与他们的哥哥亚比米勒，又叫那流他们血的罪归与帮助他杀弟兄的示剑人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_25","008_9_25","JDG","9","25","25","示剑人在山顶上设埋伏，等候亚比米勒。凡从他们那里经过的人，他们就抢夺。有人将这事告诉亚比米勒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_26","008_9_26","JDG","9","26","26","以别的儿子迦勒和他的弟兄来到示剑，示剑人都信靠他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_27","008_9_27","JDG","9","27","27","示剑人出城到田间去，摘下葡萄，踹酒，设摆筵宴，进他们神的庙中吃喝，咒诅亚比米勒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_28","008_9_28","JDG","9","28","28","以别的儿子迦勒说：「亚比米勒是谁？示剑是谁？使我们服事他呢？他不是耶路·巴力的儿子吗？他的帮手不是西布勒吗？你们可以服事示剑的父亲哈抹的后裔。我们为何服事亚比米勒呢？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_29","008_9_29","JDG","9","29","29","惟愿这民归我的手下，我就除掉亚比米勒。」迦勒又对亚比米勒说：「增添你的军兵出来吧。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_30","008_9_30","JDG","9","30","30","邑宰西布勒听见以别的儿子迦勒的话，就发怒， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_31","008_9_31","JDG","9","31","31","悄悄地打发人去见亚比米勒，说：「以别的儿子迦勒和他的弟兄到了示剑，煽惑城中的民攻击你。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_32","008_9_32","JDG","9","32","32","现在你和跟随你的人今夜起来，在田间埋伏。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_33","008_9_33","JDG","9","33","33","到早晨太阳一出，你就起来闯城。迦勒和跟随他的人出来攻击你的时候，你便向他们见机而做。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_34","008_9_34","JDG","9","34","34","于是，亚比米勒和跟随他的众人夜间起来，分作四队，埋伏等候示剑人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_35","008_9_35","JDG","9","35","35","以别的儿子迦勒出去，站在城门口。亚比米勒和跟随他的人从埋伏之处起来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_36","008_9_36","JDG","9","36","36","迦勒看见那些人，就对西布勒说：「看哪，有人从山顶上下来了。」西布勒说：「你看见山的影子，以为是人。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_37","008_9_37","JDG","9","37","37","迦勒又说：「看哪，有人从高处下来，又有一队从米恶尼尼橡树的路上而来。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_38","008_9_38","JDG","9","38","38","西布勒对他说：「你曾说，亚比米勒是谁，叫我们服事他？你所夸的口在哪里呢？这不是你所藐视的民吗？你现在出去，与他们交战吧！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_39","008_9_39","JDG","9","39","39","于是迦勒率领示剑人出去，与亚比米勒交战。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_40","008_9_40","JDG","9","40","40","亚比米勒追赶迦勒；迦勒在他面前逃跑，有许多受伤仆倒的，直到城门。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_41","008_9_41","JDG","9","41","41","亚比米勒住在亚鲁玛。西布勒赶出迦勒和他弟兄，不准他们住在示剑。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_42","008_9_42","JDG","9","42","42","次日，民出到田间，有人告诉亚比米勒； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_43","008_9_43","JDG","9","43","43","他就把他的人分作三队，埋伏在田间，看见示剑人从城里出来，就起来击杀他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_44","008_9_44","JDG","9","44","44","亚比米勒和跟随他的一队向前闯去，站在城门口；那两队直闯到田间，击杀了众人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_45","008_9_45","JDG","9","45","45","亚比米勒整天攻打城，将城夺取，杀了其中的居民，将城拆毁，撒上了盐。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_46","008_9_46","JDG","9","46","46","示剑楼的人听见了，就躲入巴力·比利土庙的卫所。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_47","008_9_47","JDG","9","47","47","有人告诉亚比米勒说：「示剑楼的人都聚在一处。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_48","008_9_48","JDG","9","48","48","亚比米勒和跟随他的人就都上撒们山。亚比米勒手拿斧子，砍下一根树枝，扛在肩上，对跟随他的人说：「你们看我所行的，也当赶紧照样行。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_49","008_9_49","JDG","9","49","49","众人就各砍一枝，跟随亚比米勒，把树枝堆在卫所的四围，放火烧了卫所，以致示剑楼的人都死了，男女约有一千。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_50","008_9_50","JDG","9","50","50","亚比米勒到提备斯，向提备斯安营，就攻取了那城。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_51","008_9_51","JDG","9","51","51","城中有一座坚固的楼；城里的众人，无论男女，都逃进楼去，关上门，上了楼顶。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_52","008_9_52","JDG","9","52","52","亚比米勒到了楼前攻打，挨近楼门，要用火焚烧。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_53","008_9_53","JDG","9","53","53","有一个妇人把一块上磨石抛在亚比米勒的头上，打破了他的脑骨。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_54","008_9_54","JDG","9","54","54","他就急忙喊叫拿他兵器的少年人，对他说：「拔出你的刀来，杀了我吧！免得人议论我说，他为一个妇人所杀。」于是少年人把他刺透，他就死了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_55","008_9_55","JDG","9","55","55","以色列人见亚比米勒死了，便各回自己的地方去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_56","008_9_56","JDG","9","56","56","这样，　神报应亚比米勒向他父亲所行的恶，就是杀了弟兄七十个人的恶。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG9_57","008_9_57","JDG","9","57","57","示剑人的一切恶，　神也都报应在他们头上；耶路·巴力的儿子约坦的咒诅归到他们身上了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG10_1","008_10_1","JDG","10","1","1","亚比米勒以后，有以萨迦人朵多的孙子、普瓦的儿子陀拉兴起，拯救以色列人。他住在以法莲山地的沙密。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG10_2","008_10_2","JDG","10","2","2","陀拉作以色列的士师二十三年，就死了，葬在沙密。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG10_3","008_10_3","JDG","10","3","3","在他以后有基列人睚珥兴起，作以色列的士师二十二年。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG10_4","008_10_4","JDG","10","4","4","他有三十个儿子，骑着三十匹驴驹。他们有三十座城邑，叫作哈倭特·睚珥，直到如今，都是在基列地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG10_5","008_10_5","JDG","10","5","5","睚珥死了，就葬在加们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG10_6","008_10_6","JDG","10","6","6","以色列人又行耶和华眼中看为恶的事，去事奉诸巴力和亚斯她录，并亚兰的神、西顿的神、摩押的神、亚扪人的神、非利士人的神，离弃耶和华，不事奉他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG10_7","008_10_7","JDG","10","7","7","耶和华的怒气向以色列人发作，就把他们交在非利士人和亚扪人的手中。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG10_8","008_10_8","JDG","10","8","8","从那年起，他们扰害欺压约旦河那边、住亚摩利人之基列地的以色列人，共有十八年。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG10_9","008_10_9","JDG","10","9","9","亚扪人又渡过约旦河去攻打犹大和便雅悯，并以法莲族。以色列人就甚觉窘迫。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG10_10","008_10_10","JDG","10","10","10","以色列人哀求耶和华说：「我们得罪了你；因为离弃了我们　神，去事奉诸巴力。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG10_11","008_10_11","JDG","10","11","11","耶和华对以色列人说：「我岂没有救过你们脱离埃及人、亚摩利人、亚扪人，和非利士人吗？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG10_12","008_10_12","JDG","10","12","12","西顿人、亚玛力人、马云人也都欺压你们；你们哀求我，我也拯救你们脱离他们的手。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG10_13","008_10_13","JDG","10","13","13","你们竟离弃我，事奉别神！所以我不再救你们了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG10_14","008_10_14","JDG","10","14","14","你们去哀求所选择的神；你们遭遇急难的时候，让他救你们吧！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG10_15","008_10_15","JDG","10","15","15","以色列人对耶和华说：「我们犯罪了，任凭你随意待我们吧！只求你今日拯救我们。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG10_16","008_10_16","JDG","10","16","16","以色列人就除掉他们中间的外邦神，事奉耶和华。耶和华因以色列人受的苦难，就心中担忧。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG10_17","008_10_17","JDG","10","17","17","当时亚扪人聚集，安营在基列。以色列人也聚集，安营在米斯巴。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG10_18","008_10_18","JDG","10","18","18","基列的民和众首领彼此商议说：「谁能先去攻打亚扪人，谁必作基列一切居民的领袖。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG11_1","008_11_1","JDG","11","1","1","基列人耶弗他是个大能的勇士，是妓女的儿子。耶弗他是基列所生的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG11_2","008_11_2","JDG","11","2","2","基列的妻也生了几个儿子：他妻所生的儿子长大了，就赶逐耶弗他，说：「你不可在我们父家承受产业，因为你是妓女的儿子。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG11_3","008_11_3","JDG","11","3","3","耶弗他就逃避他的弟兄，去住在陀伯地，有些匪徒到他那里聚集，与他一同出入。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG11_4","008_11_4","JDG","11","4","4","过了些日子，亚扪人攻打以色列。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG11_5","008_11_5","JDG","11","5","5","亚扪人攻打以色列的时候，基列的长老到陀伯地去，要叫耶弗他回来； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG11_6","008_11_6","JDG","11","6","6","对耶弗他说：「请你来作我们的元帅，我们好与亚扪人争战。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG11_7","008_11_7","JDG","11","7","7","耶弗他回答基列的长老说：「从前你们不是恨我、赶逐我出离父家吗？现在你们遭遇急难为何到我这里来呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG11_8","008_11_8","JDG","11","8","8","基列的长老回答耶弗他说：「现在我们到你这里来，是要你同我们去，与亚扪人争战；你可以作基列一切居民的领袖。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG11_9","008_11_9","JDG","11","9","9","耶弗他对基列的长老说：「你们叫我回去，与亚扪人争战，耶和华把他交给我，我可以作你们的领袖吗？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG11_10","008_11_10","JDG","11","10","10","基列的长老回答耶弗他说：「有耶和华在你我中间作见证，我们必定照你的话行。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG11_11","008_11_11","JDG","11","11","11","于是耶弗他同基列的长老回去，百姓就立耶弗他作领袖、作元帅。耶弗他在米斯巴将自己的一切话陈明在耶和华面前。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG11_12","008_11_12","JDG","11","12","12","耶弗他打发使者去见亚扪人的王，说：「你与我有什么相干，竟来到我国中攻打我呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG11_13","008_11_13","JDG","11","13","13","亚扪人的王回答耶弗他的使者说：「因为以色列人从埃及上来的时候占据我的地，从亚嫩河到雅博河，直到约旦河。现在你要好好地将这地归还吧！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG11_14","008_11_14","JDG","11","14","14","耶弗他又打发使者去见亚扪人的王， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG11_15","008_11_15","JDG","11","15","15","对他说：「耶弗他如此说，以色列人并没有占据摩押地和亚扪人的地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG11_16","008_11_16","JDG","11","16","16","以色列人从埃及上来乃是经过旷野到红海，来到加低斯， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG11_17","008_11_17","JDG","11","17","17","就打发使者去见以东王，说：『求你容我从你的地经过。』以东王却不应允。又照样打发使者去见摩押王，他也不允准。以色列人就住在加低斯。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG11_18","008_11_18","JDG","11","18","18","他们又经过旷野，绕着以东和摩押地，从摩押地的东边过来，在亚嫩河边安营，并没有入摩押的境内，因为亚嫩河是摩押的边界。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG11_19","008_11_19","JDG","11","19","19","以色列人打发使者去见亚摩利王西宏，就是希实本的王，对他说：『求你容我们从你的地经过，往我们自己的地方去。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG11_20","008_11_20","JDG","11","20","20","西宏却不信服以色列人，不容他们经过他的境界，乃招聚他的众民在雅杂安营，与以色列人争战。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG11_21","008_11_21","JDG","11","21","21","耶和华—以色列的　神将西宏和他的众民都交在以色列人手中，以色列人就击杀他们，得了亚摩利人的全地： ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG11_22","008_11_22","JDG","11","22","22","从亚嫩河到雅博河，从旷野直到约旦河。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG11_23","008_11_23","JDG","11","23","23","耶和华—以色列的　神在他百姓以色列面前赶出亚摩利人，你竟要得他们的地吗？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG11_24","008_11_24","JDG","11","24","24","你的神基抹所赐你的地你不是得为业吗？耶和华—我们的　神在我们面前所赶出的人，我们就得他的地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG11_25","008_11_25","JDG","11","25","25","难道你比摩押王西拨的儿子巴勒还强吗？他曾与以色列人争竞，或是与他们争战吗？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG11_26","008_11_26","JDG","11","26","26","以色列人住希实本和属希实本的乡村，亚罗珥和属亚罗珥的乡村，并沿亚嫩河的一切城邑，已经有三百年了；在这三百年之内，你们为什么没有取回这些地方呢？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG11_27","008_11_27","JDG","11","27","27","原来我没有得罪你，你却攻打我，恶待我。愿审判人的耶和华今日在以色列人和亚扪人中间判断是非。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG11_28","008_11_28","JDG","11","28","28","但亚扪人的王不肯听耶弗他打发人说的话。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG11_29","008_11_29","JDG","11","29","29","耶和华的灵降在耶弗他身上，他就经过基列和玛拿西，来到基列的米斯巴，又从米斯巴来到亚扪人那里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG11_30","008_11_30","JDG","11","30","30","耶弗他就向耶和华许愿，说：「你若将亚扪人交在我手中， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG11_31","008_11_31","JDG","11","31","31","我从亚扪人那里平平安安回来的时候，无论什么人，先从我家门出来迎接我，就必归你，我也必将他献上为燔祭。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG11_32","008_11_32","JDG","11","32","32","于是耶弗他往亚扪人那里去，与他们争战；耶和华将他们交在他手中， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG11_33","008_11_33","JDG","11","33","33","他就大大杀败他们，从亚罗珥到米匿，直到亚备勒·基拉明，攻取了二十座城。这样亚扪人就被以色列人制伏了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG11_34","008_11_34","JDG","11","34","34","耶弗他回米斯巴到了自己的家，不料，他女儿拿着鼓跳舞出来迎接他，是他独生的，此外无儿无女。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG11_35","008_11_35","JDG","11","35","35","耶弗他看见她，就撕裂衣服，说：「哀哉！我的女儿啊，你使我甚是愁苦，叫我作难了；因为我已经向耶和华开口许愿，不能挽回。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG11_36","008_11_36","JDG","11","36","36","他女儿回答说：「父啊，你既向耶和华开口，就当照你口中所说的向我行，因耶和华已经在仇敌亚扪人身上为你报仇」； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG11_37","008_11_37","JDG","11","37","37","又对父亲说：「有一件事求你允准：容我去两个月，与同伴在山上，好哀哭我终为处女。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG11_38","008_11_38","JDG","11","38","38","耶弗他说：「你去吧！」就容她去两个月。她便和同伴去了，在山上为她终为处女哀哭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG11_39","008_11_39","JDG","11","39","39","两月已满，她回到父亲那里，父亲就照所许的愿向她行了。女儿终身没有亲近男子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG11_40","008_11_40","JDG","11","40","40","此后以色列中有个规矩，每年以色列的女子去为基列人耶弗他的女儿哀哭四天。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG12_1","008_12_1","JDG","12","1","1","以法莲人聚集，到了北方，对耶弗他说：「你去与亚扪人争战，为什么没有招我们同去呢？我们必用火烧你和你的房屋。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG12_2","008_12_2","JDG","12","2","2","耶弗他对他们说：「我和我的民与亚扪人大大争战；我招你们来，你们竟没有来救我脱离他们的手。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG12_3","008_12_3","JDG","12","3","3","我见你们不来救我，我就拚命前去攻击亚扪人，耶和华将他们交在我手中。你们今日为什么上我这里来攻打我呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG12_4","008_12_4","JDG","12","4","4","于是耶弗他招聚基列人，与以法莲人争战。基列人击杀以法莲人，是因他们说：「你们基列人在以法莲、玛拿西中间，不过是以法莲逃亡的人。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG12_5","008_12_5","JDG","12","5","5","基列人把守约旦河的渡口，不容以法莲人过去。以法莲逃走的人若说：「容我过去。」基列人就问他说：「你是以法莲人不是？」他若说：「不是」， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG12_6","008_12_6","JDG","12","6","6","就对他说：「你说『示播列』。」以法莲人因为咬不真字音，便说「西播列」。基列人就将他拿住，杀在约旦河的渡口。那时以法莲人被杀的有四万二千人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG12_7","008_12_7","JDG","12","7","7","耶弗他作以色列的士师六年。基列人耶弗他死了，葬在基列的一座城里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG12_8","008_12_8","JDG","12","8","8","耶弗他以后，有伯利恒人以比赞作以色列的士师。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG12_9","008_12_9","JDG","12","9","9","他有三十个儿子，三十个女儿；女儿都嫁出去了。他给众子从外乡娶了三十个媳妇。他作以色列的士师七年。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG12_10","008_12_10","JDG","12","10","10","以比赞死了，葬在伯利恒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG12_11","008_12_11","JDG","12","11","11","以比赞之后，有西布伦人以伦，作以色列的士师十年。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG12_12","008_12_12","JDG","12","12","12","西布伦人以伦死了，葬在西布伦地的亚雅 。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG12_13","008_12_13","JDG","12","13","13","以伦之后，有比拉顿人希列的儿子押顿作以色列的士师。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG12_14","008_12_14","JDG","12","14","14","他有四十个儿子，三十个孙子，骑着七十匹驴驹。押顿作以色列的士师八年。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG12_15","008_12_15","JDG","12","15","15","比拉顿人希列的儿子押顿死了，葬在以法莲地的比拉顿，在亚玛力人的山地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG13_1","008_13_1","JDG","13","1","1","以色列人又行耶和华眼中看为恶的事，耶和华将他们交在非利士人手中四十年。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG13_2","008_13_2","JDG","13","2","2","那时，有一个琐拉人，是属但族的，名叫玛挪亚。他的妻不怀孕，不生育。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG13_3","008_13_3","JDG","13","3","3","耶和华的使者向那妇人显现，对她说：「向来你不怀孕，不生育，如今你必怀孕生一个儿子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG13_4","008_13_4","JDG","13","4","4","所以你当谨慎，清酒浓酒都不可喝，一切不洁之物也不可吃。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG13_5","008_13_5","JDG","13","5","5","你必怀孕生一个儿子，不可用剃头刀剃他的头，因为这孩子一出胎就归　神作拿细耳人。他必起首拯救以色列人脱离非利士人的手。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG13_6","008_13_6","JDG","13","6","6","妇人就回去对丈夫说：「有一个神人到我面前来，他的相貌如　神使者的相貌，甚是可畏。我没有问他从哪里来，他也没有将他的名告诉我， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG13_7","008_13_7","JDG","13","7","7","却对我说：『你要怀孕生一个儿子，所以清酒浓酒都不可喝，一切不洁之物也不可吃；因为这孩子从出胎一直到死，必归　神作拿细耳人。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG13_8","008_13_8","JDG","13","8","8","玛挪亚就祈求耶和华说：「主啊，求你再差遣那神人到我们这里来，好指教我们怎样待这将要生的孩子。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG13_9","008_13_9","JDG","13","9","9","神应允玛挪亚的话；妇人正坐在田间的时候，　神的使者又到她那里，她丈夫玛挪亚却没有同她在一处。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG13_10","008_13_10","JDG","13","10","10","妇人急忙跑去告诉丈夫说：「那日到我面前来的人，又向我显现。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG13_11","008_13_11","JDG","13","11","11","玛挪亚起来跟随他的妻来到那人面前，对他说：「与这妇人说话的就是你吗？」他说：「是我。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG13_12","008_13_12","JDG","13","12","12","玛挪亚说：「愿你的话应验！我们当怎样待这孩子，他后来当怎样呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG13_13","008_13_13","JDG","13","13","13","耶和华的使者对玛挪亚说：「我告诉妇人的一切事，她都当谨慎。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG13_14","008_13_14","JDG","13","14","14","葡萄树所结的都不可吃，清酒浓酒都不可喝，一切不洁之物也不可吃。凡我所吩咐的，她都当遵守。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG13_15","008_13_15","JDG","13","15","15","玛挪亚对耶和华的使者说：「求你容我们款留你，好为你预备一只山羊羔。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG13_16","008_13_16","JDG","13","16","16","耶和华的使者对玛挪亚说：「你虽然款留我，我却不吃你的食物，你若预备燔祭就当献与耶和华。」原来玛挪亚不知道他是耶和华的使者。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG13_17","008_13_17","JDG","13","17","17","玛挪亚对耶和华的使者说：「请将你的名告诉我，到你话应验的时候，我们好尊敬你。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG13_18","008_13_18","JDG","13","18","18","耶和华的使者对他说：「你何必问我的名，我名是奇妙的。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG13_19","008_13_19","JDG","13","19","19","玛挪亚将一只山羊羔和素祭在磐石上献与耶和华，使者行奇妙的事；玛挪亚和他的妻观看， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG13_20","008_13_20","JDG","13","20","20","见火焰从坛上往上升，耶和华的使者在坛上的火焰中也升上去了。玛挪亚和他的妻看见，就俯伏于地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG13_21","008_13_21","JDG","13","21","21","耶和华的使者不再向玛挪亚和他的妻显现，玛挪亚才知道他是耶和华的使者。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG13_22","008_13_22","JDG","13","22","22","玛挪亚对他的妻说：「我们必要死，因为看见了　神。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG13_23","008_13_23","JDG","13","23","23","他的妻却对他说：「耶和华若要杀我们，必不从我们手里收纳燔祭和素祭，并不将这一切事指示我们，今日也不将这些话告诉我们。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG13_24","008_13_24","JDG","13","24","24","后来妇人生了一个儿子，给他起名叫参孙。孩子长大，耶和华赐福与他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG13_25","008_13_25","JDG","13","25","25","在玛哈尼·但，就是琐拉和以实陶中间，耶和华的灵才感动他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG14_1","008_14_1","JDG","14","1","1","参孙下到亭拿，在那里看见一个女子，是非利士人的女儿。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG14_2","008_14_2","JDG","14","2","2","参孙上来禀告他父母说：「我在亭拿看见一个女子，是非利士人的女儿，愿你们给我娶来为妻。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG14_3","008_14_3","JDG","14","3","3","他父母说：「在你弟兄的女儿中，或在本国的民中，岂没有一个女子，何至你去在未受割礼的非利士人中娶妻呢？」参孙对他父亲说：「愿你给我娶那女子，因我喜悦她。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG14_4","008_14_4","JDG","14","4","4","他的父母却不知道这事是出于耶和华，因为他找机会攻击非利士人。那时，非利士人辖制以色列人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG14_5","008_14_5","JDG","14","5","5","参孙跟他父母下亭拿去，到了亭拿的葡萄园，见有一只少壮狮子向他吼叫。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG14_6","008_14_6","JDG","14","6","6","耶和华的灵大大感动参孙，他虽然手无器械，却将狮子撕裂，如同撕裂山羊羔一样。他行这事并没有告诉父母。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG14_7","008_14_7","JDG","14","7","7","参孙下去与女子说话，就喜悦她； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG14_8","008_14_8","JDG","14","8","8","过了些日子，再下去要娶那女子，转向道旁要看死狮，见有一群蜂子和蜜在死狮之内， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG14_9","008_14_9","JDG","14","9","9","就用手取蜜，且吃且走；到了父母那里，给他父母，他们也吃了；只是没有告诉这蜜是从死狮之内取来的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG14_10","008_14_10","JDG","14","10","10","他父亲下去见女子。参孙在那里设摆筵宴，因为向来少年人都有这个规矩。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG14_11","008_14_11","JDG","14","11","11","众人看见参孙，就请了三十个人陪伴他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG14_12","008_14_12","JDG","14","12","12","参孙对他们说：「我给你们出一个谜语，你们在七日筵宴之内，若能猜出意思告诉我，我就给你们三十件里衣，三十套衣裳； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG14_13","008_14_13","JDG","14","13","13","你们若不能猜出意思告诉我，你们就给我三十件里衣，三十套衣裳。」他们说：「请将谜语说给我们听。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG14_14","008_14_14","JDG","14","14","14","参孙对他们说： 吃的从吃者出来； 甜的从强者出来。 他们三日不能猜出谜语的意思。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG14_15","008_14_15","JDG","14","15","15","到第七天，他们对参孙的妻说：「你诓哄你丈夫，探出谜语的意思告诉我们，免得我们用火烧你和你父家。你们请了我们来，是要夺我们所有的吗？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG14_16","008_14_16","JDG","14","16","16","参孙的妻在丈夫面前啼哭说：「你是恨我，不是爱我，你给我本国的人出谜语，却没有将意思告诉我。」参孙回答说：「连我父母我都没有告诉，岂可告诉你呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG14_17","008_14_17","JDG","14","17","17","七日筵宴之内，她在丈夫面前啼哭，到第七天逼着他，他才将谜语的意思告诉他妻，他妻就告诉本国的人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG14_18","008_14_18","JDG","14","18","18","到第七天，日头未落以前，那城里的人对参孙说： 有什么比蜜还甜呢？ 有什么比狮子还强呢？ 参孙对他们说： 你们若非用我的母牛犊耕地， 就猜不出我谜语的意思来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG14_19","008_14_19","JDG","14","19","19","耶和华的灵大大感动参孙，他就下到亚实基伦，击杀了三十个人，夺了他们的衣裳，将衣裳给了猜出谜语的人。参孙发怒，就上父家去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG14_20","008_14_20","JDG","14","20","20","参孙的妻便归了参孙的陪伴，就是作过他朋友的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG15_1","008_15_1","JDG","15","1","1","过了些日子，到割麦子的时候，参孙带着一只山羊羔去看他的妻，说：「我要进内室见我的妻。」他岳父不容他进去， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG15_2","008_15_2","JDG","15","2","2","说：「我估定你是极其恨她，因此我将她给了你的陪伴。她的妹子不是比她还美丽吗？你可以娶来代替她吧！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG15_3","008_15_3","JDG","15","3","3","参孙说：「这回我加害于非利士人不算有罪。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG15_4","008_15_4","JDG","15","4","4","于是参孙去捉了三百只狐狸，将狐狸尾巴一对一对地捆上，将火把捆在两条尾巴中间， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG15_5","008_15_5","JDG","15","5","5","点着火把，就放狐狸进入非利士人站着的禾稼，将堆集的禾捆和未割的禾稼，并橄榄园尽都烧了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG15_6","008_15_6","JDG","15","6","6","非利士人说：「这事是谁做的呢？」有人说：「是亭拿人的女婿参孙，因为他岳父将他的妻给了他的陪伴。」于是非利士人上去，用火烧了妇人和她的父亲。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG15_7","008_15_7","JDG","15","7","7","参孙对非利士人说：「你们既然这样行，我必向你们报仇才肯罢休。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG15_8","008_15_8","JDG","15","8","8","参孙就大大击杀他们，连腿带腰都砍断了。他便下去，住在以坦磐的穴内。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG15_9","008_15_9","JDG","15","9","9","非利士人上去安营在犹大，布散在利希。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG15_10","008_15_10","JDG","15","10","10","犹大人说：「你们为何上来攻击我们呢？」他们说：「我们上来是要捆绑参孙；他向我们怎样行，我们也要向他怎样行。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG15_11","008_15_11","JDG","15","11","11","于是有三千犹大人下到以坦磐的穴内，对参孙说：「非利士人辖制我们，你不知道吗？你向我们行的是什么事呢？」他回答说：「他们向我怎样行，我也要向他们怎样行。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG15_12","008_15_12","JDG","15","12","12","犹大人对他说：「我们下来是要捆绑你，将你交在非利士人手中。」参孙说：「你们要向我起誓，应承你们自己不害死我。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG15_13","008_15_13","JDG","15","13","13","他们说：「我们断不杀你，只要将你捆绑交在非利士人手中。」于是用两条新绳捆绑参孙，将他从以坦磐带上去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG15_14","008_15_14","JDG","15","14","14","参孙到了利希，非利士人都迎着喧嚷。耶和华的灵大大感动参孙，他臂上的绳就像火烧的麻一样，他的绑绳都从他手上脱落下来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG15_15","008_15_15","JDG","15","15","15","他见一块未干的驴腮骨，就伸手拾起来，用以击杀一千人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG15_16","008_15_16","JDG","15","16","16","参孙说： 我用驴腮骨杀人成堆， 用驴腮骨杀了一千人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG15_17","008_15_17","JDG","15","17","17","说完这话，就把那腮骨从手里抛出去了。那地便叫拉末·利希。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG15_18","008_15_18","JDG","15","18","18","参孙甚觉口渴，就求告耶和华说：「你既借仆人的手施行这么大的拯救，岂可任我渴死、落在未受割礼的人手中呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG15_19","008_15_19","JDG","15","19","19","神就使利希的洼处裂开，有水从其中涌出来。参孙喝了，精神复原；因此那泉名叫隐·哈歌利，那泉直到今日还在利希。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG15_20","008_15_20","JDG","15","20","20","当非利士人辖制以色列人的时候，参孙作以色列的士师二十年。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG16_1","008_16_1","JDG","16","1","1","参孙到了迦萨，在那里看见一个妓女，就与她亲近。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG16_2","008_16_2","JDG","16","2","2","有人告诉迦萨人说：「参孙到这里来了！」他们就把他团团围住，终夜在城门悄悄埋伏，说：「等到天亮我们便杀他。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG16_3","008_16_3","JDG","16","3","3","参孙睡到半夜，起来，将城门的门扇、门框、门闩，一齐拆下来，扛在肩上，扛到希伯 前的山顶上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG16_4","008_16_4","JDG","16","4","4","后来，参孙在梭烈谷喜爱一个妇人，名叫大利拉。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG16_5","008_16_5","JDG","16","5","5","非利士人的首领上去见那妇人，对她说：「求你诓哄参孙，探探他因何有这么大的力气，我们用何法能胜他，捆绑克制他。我们就每人给你一千一百舍客勒银子。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG16_6","008_16_6","JDG","16","6","6","大利拉对参孙说：「求你告诉我，你因何有这么大的力气，当用何法捆绑克制你。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG16_7","008_16_7","JDG","16","7","7","参孙回答说：「人若用七条未干的青绳子捆绑我，我就软弱像别人一样。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG16_8","008_16_8","JDG","16","8","8","于是非利士人的首领拿了七条未干的青绳子来，交给妇人，她就用绳子捆绑参孙。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG16_9","008_16_9","JDG","16","9","9","有人预先埋伏在妇人的内室里。妇人说：「参孙哪，非利士人拿你来了！」参孙就挣断绳子，如挣断经火的麻线一般。这样，他力气的根由人还是不知道。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG16_10","008_16_10","JDG","16","10","10","大利拉对参孙说：「你欺哄我，向我说谎言。现在求你告诉我当用何法捆绑你。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG16_11","008_16_11","JDG","16","11","11","参孙回答说：「人若用没有使过的新绳捆绑我，我就软弱像别人一样。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG16_12","008_16_12","JDG","16","12","12","大利拉就用新绳捆绑他，对他说：「参孙哪，非利士人拿你来了！」有人预先埋伏在内室里。参孙将臂上的绳挣断了，如挣断一条线一样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG16_13","008_16_13","JDG","16","13","13","大利拉对参孙说：「你到如今还是欺哄我，向我说谎言。求你告诉我，当用何法捆绑你。」参孙回答说：「你若将我头上的七条发绺，与纬线同织就可以了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG16_14","008_16_14","JDG","16","14","14","于是大利拉将他的发绺与纬线同织，用橛子钉住，对他说：「参孙哪，非利士人拿你来了！」参孙从睡中醒来，将机上的橛子和纬线一齐都拔出来了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG16_15","008_16_15","JDG","16","15","15","大利拉对参孙说：「你既不与我同心，怎么说你爱我呢？你这三次欺哄我，没有告诉我，你因何有这么大的力气。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG16_16","008_16_16","JDG","16","16","16","大利拉天天用话催逼他，甚至他心里烦闷要死。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG16_17","008_16_17","JDG","16","17","17","参孙就把心中所藏的都告诉了她，对她说：「向来人没有用剃头刀剃我的头，因为我自出母胎就归　神作拿细耳人；若剃了我的头发，我的力气就离开我，我便软弱像别人一样。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG16_18","008_16_18","JDG","16","18","18","大利拉见他把心中所藏的都告诉了她，就打发人到非利士人的首领那里，对他们说：「他已经把心中所藏的都告诉了我，请你们再上来一次。」于是非利士人的首领手里拿着银子，上到妇人那里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG16_19","008_16_19","JDG","16","19","19","大利拉使参孙枕着她的膝睡觉，叫了一个人来剃除他头上的七条发绺。于是大利拉克制他，他的力气就离开他了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG16_20","008_16_20","JDG","16","20","20","大利拉说：「参孙哪，非利士人拿你来了！」参孙从睡中醒来，心里说：「我要像前几次出去活动身体」；他却不知道耶和华已经离开他了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG16_21","008_16_21","JDG","16","21","21","非利士人将他拿住，剜了他的眼睛，带他下到迦萨，用铜链拘索他；他就在监里推磨。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG16_22","008_16_22","JDG","16","22","22","然而他的头发被剃之后，又渐渐长起来了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG16_23","008_16_23","JDG","16","23","23","非利士人的首领聚集，要给他们的神大衮献大祭，并且欢乐，因为他们说：「我们的神将我们的仇敌参孙交在我们手中了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG16_24","008_16_24","JDG","16","24","24","众人看见参孙，就赞美他们的神说：「我们的神将毁坏我们地、杀害我们许多人的仇敌交在我们手中了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG16_25","008_16_25","JDG","16","25","25","他们正宴乐的时候，就说：「叫参孙来，在我们面前戏耍戏耍。」于是将参孙从监里提出来，他就在众人面前戏耍。他们使他站在两柱中间。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG16_26","008_16_26","JDG","16","26","26","参孙向拉他手的童子说：「求你让我摸着托房的柱子，我要靠一靠。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG16_27","008_16_27","JDG","16","27","27","那时房内充满男女，非利士人的众首领也都在那里。房的平顶上约有三千男女观看参孙戏耍。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG16_28","008_16_28","JDG","16","28","28","参孙求告耶和华说：「主耶和华啊，求你眷念我。　神啊，求你赐我这一次的力量，使我在非利士人身上报那剜我双眼的仇。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG16_29","008_16_29","JDG","16","29","29","参孙就抱住托房的那两根柱子：左手抱一根，右手抱一根， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG16_30","008_16_30","JDG","16","30","30","说：「我情愿与非利士人同死！」就尽力屈身，房子倒塌，压住首领和房内的众人。这样，参孙死时所杀的人比活着所杀的还多。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG16_31","008_16_31","JDG","16","31","31","参孙的弟兄和他父的全家都下去取他的尸首，抬上来葬在琐拉和以实陶中间，在他父玛挪亚的坟墓里。参孙作以色列的士师二十年。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG17_1","008_17_1","JDG","17","1","1","以法莲山地有一个人名叫米迦。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG17_2","008_17_2","JDG","17","2","2","他对母亲说：「你那一千一百舍客勒银子被人拿去，你因此咒诅，并且告诉了我。看哪，这银子在我这里，是我拿去了。」他母亲说：「我儿啊，愿耶和华赐福与你！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG17_3","008_17_3","JDG","17","3","3","米迦就把这一千一百舍客勒银子还他母亲。他母亲说：「我分出这银子来为你献给耶和华，好雕刻一个像，铸成一个像。现在我还是交给你。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG17_4","008_17_4","JDG","17","4","4","米迦将银子还他母亲，他母亲将二百舍客勒银子交给银匠，雕刻一个像，铸成一个像，安置在米迦的屋内。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG17_5","008_17_5","JDG","17","5","5","这米迦有了神堂，又制造以弗得和家中的神像，分派他一个儿子作祭司。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG17_6","008_17_6","JDG","17","6","6","那时以色列中没有王，各人任意而行。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG17_7","008_17_7","JDG","17","7","7","犹大的伯利恒有一个少年人，是犹大族的利未人，他在那里寄居。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG17_8","008_17_8","JDG","17","8","8","这人离开犹大的伯利恒城，要找一个可住的地方。行路的时候，到了以法莲山地，走到米迦的家。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG17_9","008_17_9","JDG","17","9","9","米迦问他说：「你从哪里来？」他回答说：「从犹大的伯利恒来。我是利未人，要找一个可住的地方。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG17_10","008_17_10","JDG","17","10","10","米迦说：「你可以住在我这里，我以你为父、为祭司。我每年给你十舍客勒银子，一套衣服和度日的食物。」利未人就进了他的家。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG17_11","008_17_11","JDG","17","11","11","利未人情愿与那人同住；那人看这少年人如自己的儿子一样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG17_12","008_17_12","JDG","17","12","12","米迦分派这少年的利未人作祭司，他就住在米迦的家里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG17_13","008_17_13","JDG","17","13","13","米迦说：「现在我知道耶和华必赐福与我，因我有一个利未人作祭司。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG18_1","008_18_1","JDG","18","1","1","那时，以色列中没有王。但支派的人仍是寻地居住；因为到那日子，他们还没有在以色列支派中得地为业。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG18_2","008_18_2","JDG","18","2","2","但人从琐拉和以实陶打发本族中的五个勇士，去仔细窥探那地，吩咐他们说：「你们去窥探那地。」他们来到以法莲山地，进了米迦的住宅，就在那里住宿。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG18_3","008_18_3","JDG","18","3","3","他们临近米迦的住宅，听出那少年利未人的口音来，就进去问他说：「谁领你到这里来？你在这里做什么？你在这里得什么？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG18_4","008_18_4","JDG","18","4","4","他回答说：「米迦待我如此如此，请我作祭司。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG18_5","008_18_5","JDG","18","5","5","他们对他说：「请你求问　神，使我们知道所行的道路通达不通达。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG18_6","008_18_6","JDG","18","6","6","祭司对他们说：「你们可以平平安安地去，你们所行的道路是在耶和华面前的。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG18_7","008_18_7","JDG","18","7","7","五人就走了，来到拉亿，见那里的民安居无虑，如同西顿人安居一样。在那地没有人掌权扰乱他们；他们离西顿人也远，与别人没有来往。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG18_8","008_18_8","JDG","18","8","8","五人回到琐拉和以实陶，见他们的弟兄；弟兄问他们说：「你们有什么话？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG18_9","008_18_9","JDG","18","9","9","他们回答说：「起来，我们上去攻击他们吧！我们已经窥探那地，见那地甚好。你们为何静坐不动呢？要急速前往得那地为业，不可迟延。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG18_10","008_18_10","JDG","18","10","10","你们到了那里，必看见安居无虑的民，地也宽阔。　神已将那地交在你们手中；那地百物俱全，一无所缺。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG18_11","008_18_11","JDG","18","11","11","于是但族中的六百人，各带兵器，从琐拉和以实陶前往， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG18_12","008_18_12","JDG","18","12","12","上到犹大的基列·耶琳，在基列·耶琳后边安营。因此那地方名叫玛哈尼·但，直到今日。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG18_13","008_18_13","JDG","18","13","13","他们从那里往以法莲山地去，来到米迦的住宅。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG18_14","008_18_14","JDG","18","14","14","从前窥探拉亿地的五个人对他们的弟兄说：「这宅子里有以弗得和家中的神像，并雕刻的像与铸成的像，你们知道吗？现在你们要想一想当怎样行。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG18_15","008_18_15","JDG","18","15","15","五人就进入米迦的住宅，到了那少年利未人的房内问他好。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG18_16","008_18_16","JDG","18","16","16","那六百但人各带兵器，站在门口。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG18_17","008_18_17","JDG","18","17","17","窥探地的五个人走进去，将雕刻的像、以弗得、家中的神像，并铸成的像，都拿了去。祭司和带兵器的六百人，一同站在门口。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG18_18","008_18_18","JDG","18","18","18","那五个人进入米迦的住宅，拿出雕刻的像、以弗得、家中的神像，并铸成的像，祭司就问他们说：「你们做什么呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG18_19","008_18_19","JDG","18","19","19","他们回答说：「不要作声，用手捂口，跟我们去吧！我们必以你为父、为祭司。你作一家的祭司好呢？还是作以色列一族一支派的祭司好呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG18_20","008_18_20","JDG","18","20","20","祭司心里喜悦，便拿着以弗得和家中的神像，并雕刻的像，进入他们中间。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG18_21","008_18_21","JDG","18","21","21","他们就转身离开那里，妻子、儿女、牲畜、财物都在前头。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG18_22","008_18_22","JDG","18","22","22","离米迦的住宅已远，米迦的近邻都聚集来，追赶但人， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG18_23","008_18_23","JDG","18","23","23","呼叫但人。但人回头问米迦说：「你聚集这许多人来做什么呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG18_24","008_18_24","JDG","18","24","24","米迦说：「你们将我所做的神像和祭司都带了去，我还有所剩的吗？怎么还问我说『做什么』呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG18_25","008_18_25","JDG","18","25","25","但人对米迦说：「你不要使我们听见你的声音，恐怕有性暴的人攻击你，以致你和你的全家尽都丧命。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG18_26","008_18_26","JDG","18","26","26","但人还是走他们的路。米迦见他们的势力比自己强盛，就转身回家去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG18_27","008_18_27","JDG","18","27","27","但人将米迦所做的神像和他的祭司都带到拉亿，见安居无虑的民，就用刀杀了那民，又放火烧了那城， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG18_28","008_18_28","JDG","18","28","28","并无人搭救；因为离西顿远，他们又与别人没有来往。城在平原，那平原靠近伯·利合。但人又在那里修城居住， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG18_29","008_18_29","JDG","18","29","29","照着他们始祖以色列之子但的名字，给那城起名叫但；原先那城名叫拉亿。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG18_30","008_18_30","JDG","18","30","30","但人就为自己设立那雕刻的像。摩西的孙子、革舜的儿子约拿单，和他的子孙作但支派的祭司，直到那地遭掳掠的日子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG18_31","008_18_31","JDG","18","31","31","神的殿在示罗多少日子，但人为自己设立米迦所雕刻的像也在但多少日子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG19_1","008_19_1","JDG","19","1","1","当以色列中没有王的时候，有住以法莲山地那边的一个利未人，娶了一个犹大伯利恒的女子为妾。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG19_2","008_19_2","JDG","19","2","2","妾行淫离开丈夫，回犹大的伯利恒，到了父家，在那里住了四个月。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG19_3","008_19_3","JDG","19","3","3","她丈夫起来，带着一个仆人、两匹驴去见她，用好话劝她回来。女子就引丈夫进入父家。她父见了那人，便欢欢喜喜地迎接。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG19_4","008_19_4","JDG","19","4","4","那人的岳父，就是女子的父亲，将那人留下住了三天。于是二人一同吃喝、住宿。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG19_5","008_19_5","JDG","19","5","5","到第四天，利未人清早起来要走，女子的父亲对女婿说：「请你吃点饭，加添心力，然后可以行路。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG19_6","008_19_6","JDG","19","6","6","于是二人坐下一同吃喝。女子的父亲对那人说：「请你再住一夜，畅快你的心。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG19_7","008_19_7","JDG","19","7","7","那人起来要走，他岳父强留他，他又住了一宿。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG19_8","008_19_8","JDG","19","8","8","到第五天，他清早起来要走，女子的父亲说：「请你吃点饭，加添心力，等到日头偏西再走。」于是二人一同吃饭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG19_9","008_19_9","JDG","19","9","9","那人同他的妾和仆人起来要走，他岳父，就是女子的父亲，对他说：「看哪，日头偏西了，请你再住一夜；天快晚了，可以在这里住宿，畅快你的心。明天早早起行回家去。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG19_10","008_19_10","JDG","19","10","10","那人不愿再住一夜，就备上那两匹驴，带着妾起身走了，来到耶布斯的对面（耶布斯就是耶路撒冷。） ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG19_11","008_19_11","JDG","19","11","11","临近耶布斯的时候，日头快要落了，仆人对主人说：「我们不如进这耶布斯人的城里住宿。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG19_12","008_19_12","JDG","19","12","12","主人回答说：「我们不可进不是以色列人住的外邦城，不如过到基比亚去」； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG19_13","008_19_13","JDG","19","13","13","又对仆人说：「我们可以到一个地方，或住在基比亚，或住在拉玛。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG19_14","008_19_14","JDG","19","14","14","他们就往前走。将到便雅悯的基比亚，日头已经落了； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG19_15","008_19_15","JDG","19","15","15","他们进入基比亚要在那里住宿，就坐在城里的街上，因为无人接他们进家住宿。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG19_16","008_19_16","JDG","19","16","16","晚上，有一个老年人从田间做工回来。他原是以法莲山地的人，住在基比亚；那地方的人却是便雅悯人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG19_17","008_19_17","JDG","19","17","17","老年人举目看见客人坐在城里的街上，就问他说：「你从哪里来？要往哪里去？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG19_18","008_19_18","JDG","19","18","18","他回答说：「我们从犹大的伯利恒来，要往以法莲山地那边去。我原是那里的人，到过犹大的伯利恒，现在我往耶和华的殿去，在这里无人接我进他的家。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG19_19","008_19_19","JDG","19","19","19","其实我有粮草可以喂驴，我与我的妾，并我的仆人，有饼有酒，并不缺少什么。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG19_20","008_19_20","JDG","19","20","20","老年人说：「愿你平安！你所需用的我都给你，只是不可在街上过夜。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG19_21","008_19_21","JDG","19","21","21","于是领他们到家里，喂上驴，他们就洗脚吃喝。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG19_22","008_19_22","JDG","19","22","22","他们心里正欢畅的时候，城中的匪徒围住房子，连连叩门，对房主老人说：「你把那进你家的人带出来，我们要与他交合。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG19_23","008_19_23","JDG","19","23","23","那房主出来对他们说：「弟兄们哪，不要这样作恶；这人既然进了我的家，你们就不要行这丑事。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG19_24","008_19_24","JDG","19","24","24","我有个女儿，还是处女，并有这人的妾，我将她们领出来任凭你们玷辱她们，只是向这人不可行这样的丑事。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG19_25","008_19_25","JDG","19","25","25","那些人却不听从他的话。那人就把他的妾拉出去交给他们，他们便与她交合，终夜凌辱她，直到天色快亮才放她去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG19_26","008_19_26","JDG","19","26","26","天快亮的时候，妇人回到她主人住宿的房门前，就仆倒在地，直到天亮。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG19_27","008_19_27","JDG","19","27","27","早晨，她的主人起来开了房门，出去要行路，不料那妇人仆倒在房门前，两手搭在门槛上； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG19_28","008_19_28","JDG","19","28","28","就对妇人说：「起来，我们走吧！」妇人却不回答。那人便将她驮在驴上，起身回本处去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG19_29","008_19_29","JDG","19","29","29","到了家里，用刀将妾的尸身切成十二块，使人拿着传送以色列的四境。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG19_30","008_19_30","JDG","19","30","30","凡看见的人都说：「从以色列人出埃及地，直到今日，这样的事没有行过，也没有见过。现在应当思想，大家商议当怎样办理。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG20_1","008_20_1","JDG","20","1","1","于是以色列从但到别是巴，以及住基列地的众人都出来，如同一人，聚集在米斯巴耶和华面前。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG20_2","008_20_2","JDG","20","2","2","以色列民的首领，就是各支派的军长，都站在　神百姓的会中；拿刀的步兵共有四十万。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG20_3","008_20_3","JDG","20","3","3","以色列人上到米斯巴，便雅悯人都听见了。以色列人说：「请你将这件恶事的情由对我们说明。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG20_4","008_20_4","JDG","20","4","4","那利未人，就是被害之妇人的丈夫，回答说：「我和我的妾到了便雅悯的基比亚住宿。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG20_5","008_20_5","JDG","20","5","5","基比亚人夜间起来，围了我住的房子，想要杀我，又将我的妾强奸致死。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG20_6","008_20_6","JDG","20","6","6","我就把我妾的尸身切成块子，使人拿着传送以色列得为业的全地，因为基比亚人在以色列中行了凶淫丑恶的事。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG20_7","008_20_7","JDG","20","7","7","你们以色列人都当筹划商议。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG20_8","008_20_8","JDG","20","8","8","众民都起来如同一人，说：「我们连一人都不回自己帐棚、自己房屋去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG20_9","008_20_9","JDG","20","9","9","我们向基比亚人必这样行，照所掣的签去攻击他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG20_10","008_20_10","JDG","20","10","10","我们要在以色列各支派中，一百人挑取十人，一千人挑取百人，一万人挑取千人，为民运粮，等大众到了便雅悯的基比亚，就照基比亚人在以色列中所行的丑事征伐他们。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG20_11","008_20_11","JDG","20","11","11","于是以色列众人彼此连合如同一人，聚集攻击那城。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG20_12","008_20_12","JDG","20","12","12","以色列众支派打发人去，问便雅悯支派的各家说：「你们中间怎么做了这样的恶事呢？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG20_13","008_20_13","JDG","20","13","13","现在你们要将基比亚的那些匪徒交出来，我们好治死他们，从以色列中除掉这恶。」便雅悯人却不肯听从他们弟兄以色列人的话。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG20_14","008_20_14","JDG","20","14","14","便雅悯人从他们的各城里出来，聚集到了基比亚，要与以色列人打仗。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG20_15","008_20_15","JDG","20","15","15","那时便雅悯人从各城里点出拿刀的，共有二万六千；另外还有基比亚人点出七百精兵。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG20_16","008_20_16","JDG","20","16","16","在众军之中有拣选的七百精兵，都是左手便利的，能用机弦甩石打人，毫发不差。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG20_17","008_20_17","JDG","20","17","17","便雅悯人之外，点出以色列人拿刀的，共有四十万，都是战士。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG20_18","008_20_18","JDG","20","18","18","以色列人就起来，到伯特利去求问　神说：「我们中间谁当首先上去与便雅悯人争战呢？」耶和华说：「犹大当先上去。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG20_19","008_20_19","JDG","20","19","19","以色列人早晨起来，对着基比亚安营。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG20_20","008_20_20","JDG","20","20","20","以色列人出来，要与便雅悯人打仗，就在基比亚前摆阵。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG20_21","008_20_21","JDG","20","21","21","便雅悯人就从基比亚出来，当日杀死以色列人二万二千。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG20_22","008_20_22","JDG","20","22","22","以色列人彼此奋勇，仍在头一日摆阵的地方又摆阵。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG20_23","008_20_23","JDG","20","23","23","未摆阵之先，以色列人上去，在耶和华面前哭号，直到晚上，求问耶和华说：「我们再去与我们弟兄便雅悯人打仗可以不可以？」耶和华说：「可以上去攻击他们。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG20_24","008_20_24","JDG","20","24","24","第二日，以色列人就上前攻击便雅悯人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG20_25","008_20_25","JDG","20","25","25","便雅悯人也在这日从基比亚出来，与以色列人接战，又杀死他们一万八千，都是拿刀的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG20_26","008_20_26","JDG","20","26","26","以色列众人就上到伯特利，坐在耶和华面前哭号，当日禁食直到晚上；又在耶和华面前献燔祭和平安祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG20_27","008_20_27","JDG","20","27","28","那时，　神的约柜在那里；亚伦的孙子、以利亚撒的儿子非尼哈侍立在约柜前。以色列人问耶和华说：「我们当再出去与我们弟兄便雅悯人打仗呢？还是罢兵呢？」耶和华说：「你们当上去，因为明日我必将他们交在你们手中。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG20_29","008_20_29","JDG","20","29","29","以色列人在基比亚的四围设下伏兵。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG20_30","008_20_30","JDG","20","30","30","第三日，以色列人又上去攻击便雅悯人，在基比亚前摆阵，与前两次一样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG20_31","008_20_31","JDG","20","31","31","便雅悯人也出来迎敌，就被引诱离城；在田间两条路上，一通伯特利，一通基比亚，像前两次，动手杀死以色列人约有三十个。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG20_32","008_20_32","JDG","20","32","32","便雅悯人说：「他们仍旧败在我们面前。」但以色列人说：「我们不如逃跑，引诱他们离开城到路上来。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG20_33","008_20_33","JDG","20","33","33","以色列众人都起来，在巴力·他玛摆阵，以色列的伏兵从马利·迦巴埋伏的地方冲上前去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG20_34","008_20_34","JDG","20","34","34","有以色列人中的一万精兵，来到基比亚前接战，势派甚是凶猛；便雅悯人却不知道灾祸临近了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG20_35","008_20_35","JDG","20","35","35","耶和华使以色列人杀败便雅悯人。那日，以色列人杀死便雅悯人二万五千一百，都是拿刀的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG20_36","008_20_36","JDG","20","36","36","于是便雅悯人知道自己败了。先是以色列人；因为靠着在基比亚前所设的伏兵，就在便雅悯人面前诈败。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG20_37","008_20_37","JDG","20","37","37","伏兵急忙闯进基比亚，用刀杀死全城的人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG20_38","008_20_38","JDG","20","38","38","以色列人预先同伏兵约定在城内放火，以烟气上腾为号。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG20_39","008_20_39","JDG","20","39","39","以色列人临退阵的时候，便雅悯人动手杀死以色列人，约有三十个，就说：「他们仍像前次被我们杀败了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG20_40","008_20_40","JDG","20","40","40","当烟气如柱从城中上腾的时候，便雅悯人回头观看，见全城的烟气冲天。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG20_41","008_20_41","JDG","20","41","41","以色列人又转身回来，便雅悯人就甚惊惶，因为看见灾祸临到自己了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG20_42","008_20_42","JDG","20","42","42","他们在以色列人面前转身往旷野逃跑；以色列人在后面追杀。那从各城里出来的，也都夹攻杀灭他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG20_43","008_20_43","JDG","20","43","43","以色列人围绕便雅悯人，追赶他们，在他们歇脚之处、对着日出之地的基比亚践踏他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG20_44","008_20_44","JDG","20","44","44","便雅悯人死了的有一万八千，都是勇士。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG20_45","008_20_45","JDG","20","45","45","其余的人转身向旷野逃跑，往临门磐去。以色列人在道路上杀了他们五千人，如拾取遗穗一样，追到基顿又杀了他们二千人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG20_46","008_20_46","JDG","20","46","46","那日便雅悯死了的共有二万五千人，都是拿刀的勇士。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG20_47","008_20_47","JDG","20","47","47","只剩下六百人，转身向旷野逃跑，到了临门磐，就在那里住了四个月。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG20_48","008_20_48","JDG","20","48","48","以色列人又转到便雅悯地，将各城的人和牲畜，并一切所遇见的，都用刀杀尽，又放火烧了一切城邑。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG21_1","008_21_1","JDG","21","1","1","以色列人在米斯巴曾起誓说：「我们都不将女儿给便雅悯人为妻。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG21_2","008_21_2","JDG","21","2","2","以色列人来到伯特利，坐在　神面前直到晚上，放声痛哭， ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG21_3","008_21_3","JDG","21","3","3","说：「耶和华—以色列的　神啊，为何以色列中有这样缺了一支派的事呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG21_4","008_21_4","JDG","21","4","4","次日清早，百姓起来，在那里筑了一座坛，献燔祭和平安祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG21_5","008_21_5","JDG","21","5","5","以色列人彼此问说：「以色列各支派中，谁没有同会众上到耶和华面前来呢？」先是以色列人起过大誓说，凡不上米斯巴到耶和华面前来的，必将他治死。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG21_6","008_21_6","JDG","21","6","6","以色列人为他们的弟兄便雅悯后悔，说：「如今以色列中绝了一个支派了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG21_7","008_21_7","JDG","21","7","7","我们既在耶和华面前起誓说，必不将我们的女儿给便雅悯人为妻，现在我们当怎样办理、使他们剩下的人有妻呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG21_8","008_21_8","JDG","21","8","8","又彼此问说：「以色列支派中谁没有上米斯巴到耶和华面前来呢？」他们就查出基列·雅比没有一人进营到会众那里； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG21_9","008_21_9","JDG","21","9","9","因为百姓被数的时候，没有一个基列·雅比人在那里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG21_10","008_21_10","JDG","21","10","10","会众就打发一万二千大勇士，吩咐他们说：「你们去用刀将基列·雅比人连妇女带孩子都击杀了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG21_11","008_21_11","JDG","21","11","11","所当行的就是这样：要将一切男子和已嫁的女子尽行杀戮。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG21_12","008_21_12","JDG","21","12","12","他们在基列·雅比人中，遇见了四百个未嫁的处女，就带到迦南地的示罗营里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG21_13","008_21_13","JDG","21","13","13","全会众打发人到临门磐的便雅悯人那里，向他们说和睦的话。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG21_14","008_21_14","JDG","21","14","14","当时便雅悯人回来了，以色列人就把所存活基列·雅比的女子给他们为妻，还是不够。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG21_15","008_21_15","JDG","21","15","15","百姓为便雅悯人后悔，因为耶和华使以色列人缺了一个支派 。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG21_16","008_21_16","JDG","21","16","16","会中的长老说：「便雅悯中的女子既然除灭了，我们当怎样办理、使那余剩的人有妻呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG21_17","008_21_17","JDG","21","17","17","又说：「便雅悯逃脱的人当有地业，免得以色列中涂抹了一个支派。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG21_18","008_21_18","JDG","21","18","18","只是我们不能将自己的女儿给他们为妻；因为以色列人曾起誓说，有将女儿给便雅悯人为妻的，必受咒诅。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG21_19","008_21_19","JDG","21","19","19","他们又说：「在利波拿以南，伯特利以北，在示剑大路以东的示罗，年年有耶和华的节期」； ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG21_20","008_21_20","JDG","21","20","20","就吩咐便雅悯人说：「你们去，在葡萄园中埋伏。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG21_21","008_21_21","JDG","21","21","21","若看见示罗的女子出来跳舞，就从葡萄园出来，在示罗的女子中各抢一个为妻，回便雅悯地去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG21_22","008_21_22","JDG","21","22","22","他们的父亲或是弟兄若来与我们争竞，我们就说：『求你们看我们的情面，施恩给这些人，因我们在争战的时候没有给他们留下女子为妻。这也不是你们将女子给他们的；若是你们给的，就算有罪。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG21_23","008_21_23","JDG","21","23","23","于是便雅悯人照样而行，按着他们的数目从跳舞的女子中抢去为妻，就回自己的地业去，又重修城邑居住。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG21_24","008_21_24","JDG","21","24","24","当时以色列人离开那里，各归本支派、本宗族、本地业去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("JG21_25","008_21_25","JDG","21","25","25","那时，以色列中没有王，各人任意而行。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","当士师秉政的时候，国中遭遇饥荒。在犹大的伯利恒，有一个人带着妻子和两个儿子往摩押地去寄居。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","这人名叫以利米勒，他的妻名叫拿俄米；他两个儿子，一个名叫玛伦，一个名叫基连，都是犹大伯利恒的以法他人。他们到了摩押地，就住在那里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","后来拿俄米的丈夫以利米勒死了，剩下妇人和她两个儿子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","这两个儿子娶了摩押女子为妻，一个名叫俄珥巴，一个名叫路得，在那里住了约有十年。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","玛伦和基连二人也死了，剩下拿俄米，没有丈夫，也没有儿子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","她就与两个儿妇起身，要从摩押地归回；因为她在摩押地听见耶和华眷顾自己的百姓，赐粮食与他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","于是她和两个儿妇起行离开所住的地方，要回犹大地去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","拿俄米对两个儿妇说：「你们各人回娘家去吧。愿耶和华恩待你们，像你们恩待已死的人与我一样！ ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","愿耶和华使你们各在新夫家中得平安！」于是拿俄米与她们亲嘴。她们就放声而哭， ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","说：「不然，我们必与你一同回你本国去。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","拿俄米说：「我女儿们哪，回去吧！为何要跟我去呢？我还能生子作你们的丈夫吗？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","我女儿们哪，回去吧！我年纪老迈，不能再有丈夫；即或说，我还有指望，今夜有丈夫可以生子， ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","你们岂能等着他们长大呢？你们岂能等着他们不嫁别人呢？我女儿们哪，不要这样。我为你们的缘故甚是愁苦，因为耶和华伸手攻击我。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","两个儿妇又放声而哭，俄珥巴与婆婆亲嘴而别，只是路得舍不得拿俄米。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","拿俄米说：「看哪，你嫂子已经回她本国和她所拜的神那里去了，你也跟着你嫂子回去吧！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","路得说：「不要催我回去不跟随你。你往哪里去，我也往那里去；你在哪里住宿，我也在那里住宿；你的国就是我的国，你的　神就是我的　神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","你在哪里死，我也在那里死，也葬在那里。除非死能使你我相离！不然，愿耶和华重重地降罚与我。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","拿俄米见路得定意要跟随自己去，就不再劝她了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","于是二人同行，来到伯利恒。她们到了伯利恒，合城的人就都惊讶。妇女们说：「这是拿俄米吗？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","拿俄米对她们说：「不要叫我拿俄米，要叫我玛拉，因为全能者使我受了大苦。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","我满满地出去，耶和华使我空空地回来。耶和华降祸与我；全能者使我受苦。既是这样，你们为何还叫我拿俄米呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","拿俄米和她儿妇摩押女子路得，从摩押地回来到伯利恒，正是动手割大麦的时候。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","拿俄米的丈夫以利米勒的亲族中，有一个人名叫波阿斯，是个大财主。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","摩押女子路得对拿俄米说：「容我往田间去，我蒙谁的恩，就在谁的身后拾取麦穗。」拿俄米说：「女儿啊，你只管去。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","路得就去了，来到田间，在收割的人身后拾取麦穗。她恰巧到了以利米勒本族的人波阿斯那块田里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","波阿斯正从伯利恒来，对收割的人说：「愿耶和华与你们同在！」他们回答说：「愿耶和华赐福与你！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","波阿斯问监管收割的仆人说：「那是谁家的女子？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","监管收割的仆人回答说：「是那摩押女子，跟随拿俄米从摩押地回来的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","她说：『请你容我跟着收割的人拾取打捆剩下的麦穗。』她从早晨直到如今，除了在屋子里坐一会儿，常在这里。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","波阿斯对路得说：「女儿啊，听我说，不要往别人田里拾取麦穗，也不要离开这里，要常与我使女们在一处。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","我的仆人在那块田收割，你就跟着他们去。我已经吩咐仆人不可欺负你；你若渴了，就可以到器皿那里喝仆人打来的水。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","路得就俯伏在地叩拜，对他说：「我既是外邦人，怎么蒙你的恩，这样顾恤我呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","波阿斯回答说：「自从你丈夫死后，凡你向婆婆所行的，并你离开父母和本地，到素不认识的民中，这些事人全都告诉我了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","愿耶和华照你所行的赏赐你。你来投靠耶和华—以色列　神的翅膀下，愿你满得他的赏赐。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","路得说：「我主啊，愿在你眼前蒙恩。我虽然不及你的一个使女，你还用慈爱的话安慰我的心。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","到了吃饭的时候，波阿斯对路得说：「你到这里来吃饼，将饼蘸在醋里。」路得就在收割的人旁边坐下；他们把烘了的穗子递给她。她吃饱了，还有余剩的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","她起来又拾取麦穗，波阿斯吩咐仆人说：「她就是在捆中拾取麦穗，也可以容她，不可羞辱她； ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","并要从捆里抽出些来，留在地下任她拾取，不可叱吓她。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","这样，路得在田间拾取麦穗，直到晚上，将所拾取的打了，约有一伊法大麦。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","她就把所拾取的带进城去给婆婆看，又把她吃饱了所剩的给了婆婆。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","婆婆问她说：「你今日在哪里拾取麦穗，在哪里做工呢？愿那顾恤你的得福。」路得就告诉婆婆说：「我今日在一个名叫波阿斯的人那里做工。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","拿俄米对儿妇说：「愿那人蒙耶和华赐福，因为他不断地恩待活人死人。」拿俄米又说：「那是我们本族的人，是一个至近的亲属。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","摩押女子路得说：「他对我说：『你要紧随我的仆人拾取麦穗，直等他们收完了我的庄稼。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","拿俄米对儿妇路得说：「女儿啊，你跟着他的使女出去，不叫人遇见你在别人田间，这才为好。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","于是路得与波阿斯的使女常在一处拾取麦穗，直到收完了大麦和小麦。路得仍与婆婆同住。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","路得的婆婆拿俄米对她说：「女儿啊，我不当为你找个安身之处，使你享福吗？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","你与波阿斯的使女常在一处，波阿斯不是我们的亲族吗？他今夜在场上簸大麦； ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","你要沐浴抹膏，换上衣服，下到场上，却不要使那人认出你来。你等他吃喝完了， ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","到他睡的时候，你看准他睡的地方，就进去掀开他脚上的被，躺卧在那里，他必告诉你所当做的事。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","路得说：「凡你所吩咐的，我必遵行。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","路得就下到场上，照她婆婆所吩咐她的而行。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","波阿斯吃喝完了，心里欢畅，就去睡在麦堆旁边。路得便悄悄地来掀开他脚上的被，躺卧在那里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","到了夜半，那人忽然惊醒，翻过身来，不料有女子躺在他的脚下。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","他就说：「你是谁？」回答说：「我是你的婢女路得。求你用你的衣襟遮盖我，因为你是我一个至近的亲属。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","波阿斯说：「女儿啊，愿你蒙耶和华赐福。你末后的恩比先前更大；因为少年人无论贫富，你都没有跟从。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","女儿啊，现在不要惧怕，凡你所说的，我必照着行；我本城的人都知道你是个贤德的女子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","我实在是你一个至近的亲属，只是还有一个人比我更近。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","你今夜在这里住宿，明早他若肯为你尽亲属的本分，就由他吧！倘若不肯，我指着永生的耶和华起誓，我必为你尽了本分，你只管躺到天亮。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","路得便在他脚下躺到天快亮，人彼此不能辨认的时候就起来了。波阿斯说：「不可使人知道有女子到场上来」； ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","又对路得说：「打开你所披的外衣。」她打开了，波阿斯就撮了六簸箕大麦，帮她扛在肩上，她便进城去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","路得回到婆婆那里，婆婆说：「女儿啊，怎么样了？」路得就将那人向她所行的述说了一遍， ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","又说：「那人给了我六簸箕大麦，对我说：『你不可空手回去见你的婆婆。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","婆婆说：「女儿啊，你只管安坐等候，看这事怎样成就，因为那人今日不办成这事必不休息。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","波阿斯到了城门，坐在那里，恰巧波阿斯所说的那至近的亲属经过。波阿斯说：「某人哪，你来坐在这里。」他就来坐下。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","波阿斯又从本城的长老中拣选了十人，对他们说：「请你们坐在这里。」他们就都坐下。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","波阿斯对那至近的亲属说：「从摩押地回来的拿俄米，现在要卖我们族兄以利米勒的那块地； ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","我想当赎那块地的是你，其次是我，以外再没有别人了。你可以在这里的人面前和我本国的长老面前说明，你若肯赎就赎，若不肯赎就告诉我。」那人回答说：「我肯赎。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","波阿斯说：「你从拿俄米手中买这地的时候，也当娶死人的妻摩押女子路得，使死人在产业上存留他的名。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","那人说：「这样我就不能赎了，恐怕于我的产业有碍。你可以赎我所当赎的，我不能赎了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","从前，在以色列中要定夺什么事，或赎回，或交易，这人就脱鞋给那人。以色列人都以此为证据。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","那人对波阿斯说：「你自己买吧！」于是将鞋脱下来了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","波阿斯对长老和众民说：「你们今日作见证，凡属以利米勒和基连、玛伦的，我都从拿俄米手中置买了； ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","又娶了玛伦的妻摩押女子路得为妻，好在死人的产业上存留他的名，免得他的名在本族本乡灭没。你们今日可以作见证。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","在城门坐着的众民和长老都说：「我们作见证。愿耶和华使进你家的这女子，像建立以色列家的拉结、利亚二人一样。又愿你在以法他得亨通，在伯利恒得名声。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","愿耶和华从这少年女子赐你后裔，使你的家像她玛从犹大所生法勒斯的家一般。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","于是，波阿斯娶了路得为妻，与她同房。耶和华使她怀孕生了一个儿子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","妇人们对拿俄米说：「耶和华是应当称颂的！因为今日没有撇下你，使你无至近的亲属。愿这孩子在以色列中得名声。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","他必提起你的精神，奉养你的老，因为是爱慕你的那儿妇所生的。有这儿妇比有七个儿子还好！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","拿俄米就把孩子抱在怀中，作他的养母。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","邻舍的妇人说：「拿俄米得孩子了！」就给孩子起名叫俄备得。这俄备得是耶西的父，耶西是大卫的父。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","法勒斯的后代记在下面：法勒斯生希斯 ； ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","希斯 生兰；兰生亚米拿达； ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","亚米拿达生拿顺；拿顺生撒门； ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","撒门生波阿斯；波阿斯生俄备得； ");
INSERT INTO cmn_cu89s_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","俄备得生耶西；耶西生大卫。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S11_1","010_1_1","1SA","1","1","1","以法莲山地的拉玛·琐非有一个以法莲人，名叫以利加拿，是苏弗的玄孙，托户的曾孙，以利户的孙子，耶罗罕的儿子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S11_2","010_1_2","1SA","1","2","2","他有两个妻：一名哈拿，一名毗尼拿。毗尼拿有儿女，哈拿没有儿女。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S11_3","010_1_3","1SA","1","3","3","这人每年从本城上到示罗，敬拜祭祀万军之耶和华；在那里有以利的两个儿子何弗尼、非尼哈当耶和华的祭司。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S11_4","010_1_4","1SA","1","4","4","以利加拿每逢献祭的日子，将祭肉分给他的妻毗尼拿和毗尼拿所生的儿女； ");
INSERT INTO cmn_cu89s_vpl VALUES ("S11_5","010_1_5","1SA","1","5","5","给哈拿的却是双分，因为他爱哈拿。无奈耶和华不使哈拿生育。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S11_6","010_1_6","1SA","1","6","6","毗尼拿见耶和华不使哈拿生育，就作她的对头，大大激动她，要使她生气。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S11_7","010_1_7","1SA","1","7","7","每年上到耶和华殿的时候，以利加拿都以双分给哈拿；毗尼拿仍是激动她，以致她哭泣不吃饭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S11_8","010_1_8","1SA","1","8","8","她丈夫以利加拿对她说：「哈拿啊，你为何哭泣，不吃饭，心里愁闷呢？有我不比十个儿子还好吗？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S11_9","010_1_9","1SA","1","9","9","他们在示罗吃喝完了，哈拿就站起来。祭司以利在耶和华殿的门框旁边，坐在自己的位上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S11_10","010_1_10","1SA","1","10","10","哈拿心里愁苦，就痛痛哭泣，祈祷耶和华， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S11_11","010_1_11","1SA","1","11","11","许愿说：「万军之耶和华啊，你若垂顾婢女的苦情，眷念不忘婢女，赐我一个儿子，我必使他终身归与耶和华，不用剃头刀剃他的头。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S11_12","010_1_12","1SA","1","12","12","哈拿在耶和华面前不住地祈祷，以利定睛看她的嘴。（ ");
INSERT INTO cmn_cu89s_vpl VALUES ("S11_13","010_1_13","1SA","1","13","13","原来哈拿心中默祷，只动嘴唇，不出声音，因此以利以为她喝醉了。） ");
INSERT INTO cmn_cu89s_vpl VALUES ("S11_14","010_1_14","1SA","1","14","14","以利对她说：「你要醉到几时呢？你不应该喝酒。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S11_15","010_1_15","1SA","1","15","15","哈拿回答说：「主啊，不是这样。我是心里愁苦的妇人，清酒浓酒都没有喝，但在耶和华面前倾心吐意。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S11_16","010_1_16","1SA","1","16","16","不要将婢女看作不正经的女子。我因被人激动，愁苦太多，所以祈求到如今。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S11_17","010_1_17","1SA","1","17","17","以利说：「你可以平平安安地回去。愿以色列的　神允准你向他所求的！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S11_18","010_1_18","1SA","1","18","18","哈拿说：「愿婢女在你眼前蒙恩。」于是妇人走去吃饭，面上再不带愁容了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S11_19","010_1_19","1SA","1","19","19","次日清早，他们起来，在耶和华面前敬拜，就回拉玛。到了家里，以利加拿和妻哈拿同房，耶和华顾念哈拿， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S11_20","010_1_20","1SA","1","20","20","哈拿就怀孕。日期满足，生了一个儿子，给他起名叫撒母耳，说：「这是我从耶和华那里求来的。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S11_21","010_1_21","1SA","1","21","21","以利加拿和他全家都上示罗去，要向耶和华献年祭，并还所许的愿。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S11_22","010_1_22","1SA","1","22","22","哈拿却没有上去，对丈夫说：「等孩子断了奶，我便带他上去朝见耶和华，使他永远住在那里。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S11_23","010_1_23","1SA","1","23","23","她丈夫以利加拿说：「就随你的意行吧！可以等儿子断了奶。但愿耶和华应验他的话。」于是妇人在家里乳养儿子，直到断了奶； ");
INSERT INTO cmn_cu89s_vpl VALUES ("S11_24","010_1_24","1SA","1","24","24","既断了奶，就把孩子带上示罗，到了耶和华的殿；又带了三只公牛，一伊法细面，一皮袋酒。（那时，孩子还小。） ");
INSERT INTO cmn_cu89s_vpl VALUES ("S11_25","010_1_25","1SA","1","25","25","宰了一只公牛，就领孩子到以利面前。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S11_26","010_1_26","1SA","1","26","26","妇人说：「主啊，我敢在你面前起誓，从前在你这里站着祈求耶和华的那妇人，就是我。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S11_27","010_1_27","1SA","1","27","27","我祈求为要得这孩子；耶和华已将我所求的赐给我了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S11_28","010_1_28","1SA","1","28","28","所以，我将这孩子归与耶和华，使他终身归与耶和华。」 于是在那里敬拜耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S12_1","010_2_1","1SA","2","1","1","哈拿祷告说： 我的心因耶和华快乐； 我的角因耶和华高举。 我的口向仇敌张开； 我因耶和华的救恩欢欣。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S12_2","010_2_2","1SA","2","2","2","只有耶和华为圣； 除他以外没有可比的， 也没有磐石像我们的　神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S12_3","010_2_3","1SA","2","3","3","人不要夸口说骄傲的话， 也不要出狂妄的言语； 因耶和华是大有智识的　神， 人的行为被他衡量。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S12_4","010_2_4","1SA","2","4","4","勇士的弓都已折断； 跌倒的人以力量束腰。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S12_5","010_2_5","1SA","2","5","5","素来饱足的，反作用人求食； 饥饿的，再不饥饿。 不生育的，生了七个儿子； 多有儿女的，反倒衰微。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S12_6","010_2_6","1SA","2","6","6","耶和华使人死，也使人活， 使人下阴间，也使人往上升。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S12_7","010_2_7","1SA","2","7","7","他使人贫穷，也使人富足， 使人卑微，也使人高贵。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S12_8","010_2_8","1SA","2","8","8","他从灰尘里抬举贫寒人， 从粪堆中提拔穷乏人， 使他们与王子同坐， 得着荣耀的座位。 地的柱子属于耶和华； 他将世界立在其上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S12_9","010_2_9","1SA","2","9","9","他必保护圣民的脚步， 使恶人在黑暗中寂然不动； 人都不能靠力量得胜。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S12_10","010_2_10","1SA","2","10","10","与耶和华争竞的，必被打碎； 耶和华必从天上以雷攻击他， 必审判地极的人， 将力量赐与所立的王， 高举受膏者的角。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S12_11","010_2_11","1SA","2","11","11","以利加拿往拉玛回家去了。那孩子在祭司以利面前事奉耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S12_12","010_2_12","1SA","2","12","12","以利的两个儿子是恶人，不认识耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S12_13","010_2_13","1SA","2","13","13","这二祭司待百姓是这样的规矩：凡有人献祭，正煮肉的时候，祭司的仆人就来，手拿三齿的叉子， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S12_14","010_2_14","1SA","2","14","14","将叉子往罐里，或鼎里，或釜里，或锅里一插，插上来的肉，祭司都取了去。凡上到示罗的以色列人，他们都是这样看待。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S12_15","010_2_15","1SA","2","15","15","又在未烧脂油以前，祭司的仆人就来对献祭的人说：「将肉给祭司，叫他烤吧。他不要煮过的，要生的。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S12_16","010_2_16","1SA","2","16","16","献祭的人若说：「必须先烧脂油，然后你可以随意取肉。」仆人就说：「你立时给我，不然我便抢去。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S12_17","010_2_17","1SA","2","17","17","如此，这二少年人的罪在耶和华面前甚重了，因为他们藐视耶和华的祭物。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S12_18","010_2_18","1SA","2","18","18","那时，撒母耳还是孩子，穿着细麻布的以弗得，侍立在耶和华面前。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S12_19","010_2_19","1SA","2","19","19","他母亲每年为他做一件小外袍，同着丈夫上来献年祭的时候带来给他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S12_20","010_2_20","1SA","2","20","20","以利为以利加拿和他的妻祝福，说：「愿耶和华由这妇人再赐你后裔，代替你从耶和华求来的孩子。」他们就回本乡去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S12_21","010_2_21","1SA","2","21","21","耶和华眷顾哈拿，她就怀孕生了三个儿子，两个女儿。那孩子撒母耳在耶和华面前渐渐长大。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S12_22","010_2_22","1SA","2","22","22","以利年甚老迈，听见他两个儿子待以色列众人的事，又听见他们与会幕门前伺候的妇人苟合， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S12_23","010_2_23","1SA","2","23","23","他就对他们说：「你们为何行这样的事呢？我从这众百姓听见你们的恶行。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S12_24","010_2_24","1SA","2","24","24","我儿啊，不可这样！我听见你们的风声不好，你们使耶和华的百姓犯了罪。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S12_25","010_2_25","1SA","2","25","25","人若得罪人，有士师审判他；人若得罪耶和华，谁能为他祈求呢？」然而他们还是不听父亲的话，因为耶和华想要杀他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S12_26","010_2_26","1SA","2","26","26","孩子撒母耳渐渐长大，耶和华与人越发喜爱他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S12_27","010_2_27","1SA","2","27","27","有神人来见以利，对他说：「耶和华如此说：『你祖父在埃及法老家作奴仆的时候，我不是向他们显现吗？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("S12_28","010_2_28","1SA","2","28","28","在以色列众支派中，我不是拣选人作我的祭司，使他烧香，在我坛上献祭，在我面前穿以弗得，又将以色列人所献的火祭都赐给你父家吗？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("S12_29","010_2_29","1SA","2","29","29","我所吩咐献在我居所的祭物，你们为何践踏？尊重你的儿子过于尊重我，将我民以色列所献美好的祭物肥己呢？』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S12_30","010_2_30","1SA","2","30","30","因此，耶和华—以色列的　神说：『我曾说，你和你父家必永远行在我面前；现在我却说，决不容你们这样行。因为尊重我的，我必重看他；藐视我的，他必被轻视。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S12_31","010_2_31","1SA","2","31","31","日子必到，我要折断你的膀臂和你父家的膀臂，使你家中没有一个老年人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S12_32","010_2_32","1SA","2","32","32","在　神使以色列人享福的时候，你必看见我居所的败落。在你家中必永远没有一个老年人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S12_33","010_2_33","1SA","2","33","33","我必不从我坛前灭尽你家中的人；那未灭的必使你眼目干瘪、心中忧伤。你家中所生的人都必死在中年。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S12_34","010_2_34","1SA","2","34","34","你的两个儿子何弗尼、非尼哈所遭遇的事可作你的证据：他们二人必一日同死。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S12_35","010_2_35","1SA","2","35","35","我要为自己立一个忠心的祭司；他必照我的心意而行。我要为他建立坚固的家；他必永远行在我的受膏者面前。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S12_36","010_2_36","1SA","2","36","36","你家所剩下的人都必来叩拜他，求块银子，求个饼，说：求你赐我祭司的职分，好叫我得点饼吃。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S13_1","010_3_1","1SA","3","1","1","童子撒母耳在以利面前事奉耶和华。当那些日子，耶和华的言语稀少，不常有默示。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S13_2","010_3_2","1SA","3","2","2","一日，以利睡卧在自己的地方；他眼目昏花，看不分明。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S13_3","010_3_3","1SA","3","3","3","神的灯在　神耶和华殿内约柜那里，还没有熄灭，撒母耳已经睡了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S13_4","010_3_4","1SA","3","4","4","耶和华呼唤撒母耳。撒母耳说：「我在这里！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S13_5","010_3_5","1SA","3","5","5","就跑到以利那里，说：「你呼唤我？我在这里。」以利回答说：「我没有呼唤你，你去睡吧。」他就去睡了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S13_6","010_3_6","1SA","3","6","6","耶和华又呼唤撒母耳。撒母耳起来，到以利那里，说：「你呼唤我？我在这里。」以利回答说：「我的儿，我没有呼唤你，你去睡吧。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S13_7","010_3_7","1SA","3","7","7","那时撒母耳还未认识耶和华，也未得耶和华的默示。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S13_8","010_3_8","1SA","3","8","8","耶和华第三次呼唤撒母耳。撒母耳起来，到以利那里，说：「你又呼唤我？我在这里。」以利才明白是耶和华呼唤童子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S13_9","010_3_9","1SA","3","9","9","因此以利对撒母耳说：「你仍去睡吧；若再呼唤你，你就说：『耶和华啊，请说，仆人敬听！』」撒母耳就去，仍睡在原处。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S13_10","010_3_10","1SA","3","10","10","耶和华又来站着，像前三次呼唤说：「撒母耳啊！撒母耳啊！」撒母耳回答说：「请说，仆人敬听！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S13_11","010_3_11","1SA","3","11","11","耶和华对撒母耳说：「我在以色列中必行一件事，叫听见的人都必耳鸣。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S13_12","010_3_12","1SA","3","12","12","我指着以利家所说的话，到了时候，我必始终应验在以利身上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S13_13","010_3_13","1SA","3","13","13","我曾告诉他必永远降罚与他的家，因他知道儿子作孽，自招咒诅，却不禁止他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S13_14","010_3_14","1SA","3","14","14","所以我向以利家起誓说：『以利家的罪孽，虽献祭奉礼物，永不能得赎去。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S13_15","010_3_15","1SA","3","15","15","撒母耳睡到天亮，就开了耶和华的殿门，不敢将默示告诉以利。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S13_16","010_3_16","1SA","3","16","16","以利呼唤撒母耳说：「我儿撒母耳啊！」撒母耳回答说：「我在这里！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S13_17","010_3_17","1SA","3","17","17","以利说：「耶和华对你说什么，你不要向我隐瞒；你若将　神对你所说的隐瞒一句，愿他重重地降罚与你。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S13_18","010_3_18","1SA","3","18","18","撒母耳就把一切话都告诉了以利，并没有隐瞒。以利说：「这是出于耶和华，愿他凭自己的意旨而行。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S13_19","010_3_19","1SA","3","19","19","撒母耳长大了，耶和华与他同在，使他所说的话一句都不落空。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S13_20","010_3_20","1SA","3","20","20","从但到别是巴所有的以色列人都知道耶和华立撒母耳为先知。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S13_21","010_3_21","1SA","3","21","21","耶和华又在示罗显现；因为耶和华将自己的话默示撒母耳，撒母耳就把这话传遍以色列地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S14_1","010_4_1","1SA","4","1","1","以色列人出去与非利士人打仗，安营在以便以谢；非利士人安营在亚弗。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S14_2","010_4_2","1SA","4","2","2","非利士人向以色列人摆阵。两军交战的时候，以色列人败在非利士人面前；非利士人在战场上杀了他们的军兵约有四千人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S14_3","010_4_3","1SA","4","3","3","百姓回到营里，以色列的长老说：「耶和华今日为何使我们败在非利士人面前呢？我们不如将耶和华的约柜从示罗抬到我们这里来，好在我们中间救我们脱离敌人的手。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S14_4","010_4_4","1SA","4","4","4","于是百姓打发人到示罗，从那里将坐在二基路伯上万军之耶和华的约柜抬来。以利的两个儿子何弗尼、非尼哈与　神的约柜同来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S14_5","010_4_5","1SA","4","5","5","耶和华的约柜到了营中，以色列众人就大声欢呼，地便震动。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S14_6","010_4_6","1SA","4","6","6","非利士人听见欢呼的声音，就说：「在希伯来人营里大声欢呼，是什么缘故呢？」随后就知道耶和华的约柜到了营中。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S14_7","010_4_7","1SA","4","7","7","非利士人就惧怕起来，说：「有神到了他们营中」；又说：「我们有祸了！向来不曾有这样的事。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S14_8","010_4_8","1SA","4","8","8","我们有祸了！谁能救我们脱离这些大能之神的手呢？从前在旷野用各样灾殃击打埃及人的，就是这些神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S14_9","010_4_9","1SA","4","9","9","非利士人哪，你们要刚强，要作大丈夫，免得作希伯来人的奴仆，如同他们作你们的奴仆一样。你们要作大丈夫，与他们争战。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S14_10","010_4_10","1SA","4","10","10","非利士人和以色列人打仗，以色列人败了，各向各家奔逃，被杀的人甚多，以色列的步兵仆倒了三万。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S14_11","010_4_11","1SA","4","11","11","神的约柜被掳去，以利的两个儿子何弗尼、非尼哈也都被杀了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S14_12","010_4_12","1SA","4","12","12","当日，有一个便雅悯人从阵上逃跑，衣服撕裂，头蒙灰尘，来到示罗。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S14_13","010_4_13","1SA","4","13","13","到了的时候，以利正在道旁坐在自己的位上观望，为　神的约柜心里担忧。那人进城报信，合城的人就都呼喊起来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S14_14","010_4_14","1SA","4","14","14","以利听见呼喊的声音就问说：「这喧嚷是什么缘故呢？」那人急忙来报信给以利。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S14_15","010_4_15","1SA","4","15","15","那时以利九十八岁了，眼目发直，不能看见。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S14_16","010_4_16","1SA","4","16","16","那人对以利说：「我是从阵上来的，今日我从阵上逃回。」以利说：「我儿，事情怎样？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S14_17","010_4_17","1SA","4","17","17","报信的回答说：「以色列人在非利士人面前逃跑，民中被杀的甚多！你的两个儿子何弗尼、非尼哈也都死了，并且　神的约柜被掳去。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S14_18","010_4_18","1SA","4","18","18","他一提　神的约柜，以利就从他的位上往后跌倒，在门旁折断颈项而死；因为他年纪老迈，身体沉重。以利作以色列的士师四十年。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S14_19","010_4_19","1SA","4","19","19","以利的儿妇、非尼哈的妻怀孕将到产期，她听见　神的约柜被掳去，公公和丈夫都死了，就猛然疼痛，曲身生产； ");
INSERT INTO cmn_cu89s_vpl VALUES ("S14_20","010_4_20","1SA","4","20","20","将要死的时候，旁边站着的妇人们对她说：「不要怕！你生了男孩子了。」她却不回答，也不放在心上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S14_21","010_4_21","1SA","4","21","21","她给孩子起名叫以迦博，说：「荣耀离开以色列了！」这是因　神的约柜被掳去，又因她公公和丈夫都死了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S14_22","010_4_22","1SA","4","22","22","她又说：「荣耀离开以色列，因为　神的约柜被掳去了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S15_1","010_5_1","1SA","5","1","1","非利士人将　神的约柜从以便以谢抬到亚实突。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S15_2","010_5_2","1SA","5","2","2","非利士人将　神的约柜抬进大衮庙，放在大衮的旁边。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S15_3","010_5_3","1SA","5","3","3","次日清早，亚实突人起来，见大衮仆倒在耶和华的约柜前，脸伏于地，就把大衮仍立在原处。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S15_4","010_5_4","1SA","5","4","4","又次日清早起来，见大衮仆倒在耶和华的约柜前，脸伏于地，并且大衮的头和两手都在门槛上折断，只剩下大衮的残体。（ ");
INSERT INTO cmn_cu89s_vpl VALUES ("S15_5","010_5_5","1SA","5","5","5","因此，大衮的祭司和一切进亚实突、大衮庙的人都不踏大衮庙的门槛，直到今日。） ");
INSERT INTO cmn_cu89s_vpl VALUES ("S15_6","010_5_6","1SA","5","6","6","耶和华的手重重加在亚实突人身上，败坏他们，使他们生痔疮。亚实突和亚实突的四境都是如此。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S15_7","010_5_7","1SA","5","7","7","亚实突人见这光景，就说：「以色列　神的约柜不可留在我们这里，因为他的手重重加在我们和我们神大衮的身上」； ");
INSERT INTO cmn_cu89s_vpl VALUES ("S15_8","010_5_8","1SA","5","8","8","就打发人去请非利士的众首领来聚集，问他们说：「我们向以色列　神的约柜应当怎样行呢？」他们回答说：「可以将以色列　神的约柜运到迦特去。」于是将以色列　神的约柜运到那里去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S15_9","010_5_9","1SA","5","9","9","运到之后，耶和华的手攻击那城，使那城的人大大惊慌，无论大小都生痔疮。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S15_10","010_5_10","1SA","5","10","10","他们就把　神的约柜送到以革伦。　神的约柜到了，以革伦人就喊嚷起来说：「他们将以色列　神的约柜运到我们这里，要害我们和我们的众民！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S15_11","010_5_11","1SA","5","11","11","于是打发人去请非利士的众首领来，说：「愿你们将以色列　神的约柜送回原处，免得害了我们和我们的众民！」原来　神的手重重攻击那城，城中的人有因惊慌而死的； ");
INSERT INTO cmn_cu89s_vpl VALUES ("S15_12","010_5_12","1SA","5","12","12","未曾死的人都生了痔疮。合城呼号，声音上达于天。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S16_1","010_6_1","1SA","6","1","1","耶和华的约柜在非利士人之地七个月。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S16_2","010_6_2","1SA","6","2","2","非利士人将祭司和占卜的聚了来，问他们说：「我们向耶和华的约柜应当怎样行？请指示我们用何法将约柜送回原处。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S16_3","010_6_3","1SA","6","3","3","他们说：「若要将以色列　神的约柜送回去，不可空空地送去，必要给他献赔罪的礼物，然后你们可得痊愈，并知道他的手为何不离开你们。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S16_4","010_6_4","1SA","6","4","4","非利士人说：「应当用什么献为赔罪的礼物呢？」他们回答说：「当照非利士首领的数目，用五个金痔疮，五个金老鼠，因为在你们众人和你们首领的身上都是一样的灾。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S16_5","010_6_5","1SA","6","5","5","所以当制造你们痔疮的像和毁坏你们田地老鼠的像，并要归荣耀给以色列的　神，或者他向你们和你们的神，并你们的田地，把手放轻些。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S16_6","010_6_6","1SA","6","6","6","你们为何硬着心像埃及人和法老一样呢？　神在埃及人中间行奇事，埃及人岂不释放以色列人，他们就去了吗？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("S16_7","010_6_7","1SA","6","7","7","现在你们应当造一辆新车，将两只未曾负轭有乳的母牛套在车上，使牛犊回家去，离开母牛。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S16_8","010_6_8","1SA","6","8","8","把耶和华的约柜放在车上，将所献赔罪的金物装在匣子里，放在柜旁，将柜送去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S16_9","010_6_9","1SA","6","9","9","你们要看看：车若直行以色列的境界到伯·示麦去，这大灾就是耶和华降在我们身上的；若不然，便可以知道不是他的手击打我们，是我们偶然遇见的。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S16_10","010_6_10","1SA","6","10","10","非利士人就这样行：将两只有乳的母牛套在车上，将牛犊关在家里， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S16_11","010_6_11","1SA","6","11","11","把耶和华的约柜和装金老鼠并金痔疮像的匣子都放在车上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S16_12","010_6_12","1SA","6","12","12","牛直行大道，往伯·示麦去，一面走一面叫，不偏左右。非利士的首领跟在后面，直到伯·示麦的境界。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S16_13","010_6_13","1SA","6","13","13","伯·示麦人正在平原收割麦子，举目看见约柜，就欢喜了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S16_14","010_6_14","1SA","6","14","14","车到了伯·示麦人约书亚的田间，就站住了。在那里有一块大磐石，他们把车劈了，将两只母牛献给耶和华为燔祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S16_15","010_6_15","1SA","6","15","15","利未人将耶和华的约柜和装金物的匣子拿下来，放在大磐石上。当日伯·示麦人将燔祭和平安祭献给耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S16_16","010_6_16","1SA","6","16","16","非利士人的五个首领看见，当日就回以革伦去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S16_17","010_6_17","1SA","6","17","17","非利士人献给耶和华作赔罪的金痔疮像，就是这些：一个是为亚实突，一个是为迦萨，一个是为亚实基伦，一个是为迦特，一个是为以革伦。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S16_18","010_6_18","1SA","6","18","18","金老鼠的数目是照非利士五个首领的城邑，就是坚固的城邑和乡村，以及大磐石。这磐石是放耶和华约柜的，到今日还在伯·示麦人约书亚的田间。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S16_19","010_6_19","1SA","6","19","19","耶和华因伯·示麦人擅观他的约柜，就击杀了他们七十人；那时有五万人在那里。百姓因耶和华大大击杀他们，就哀哭了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S16_20","010_6_20","1SA","6","20","20","伯·示麦人说：「谁能在耶和华这圣洁的　神面前侍立呢？这约柜可以从我们这里送到谁那里去呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S16_21","010_6_21","1SA","6","21","21","于是打发人去见基列·耶琳的居民，说：「非利士人将耶和华的约柜送回来了，你们下来将约柜接到你们那里去吧！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S17_1","010_7_1","1SA","7","1","1","基列·耶琳人就下来，将耶和华的约柜接上去，放在山上亚比拿达的家中，分派他儿子以利亚撒看守耶和华的约柜。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S17_2","010_7_2","1SA","7","2","2","约柜在基列·耶琳许久。过了二十年，以色列全家都倾向耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S17_3","010_7_3","1SA","7","3","3","撒母耳对以色列全家说：「你们若一心归顺耶和华，就要把外邦的神和亚斯她录从你们中间除掉，专心归向耶和华，单单地事奉他。他必救你们脱离非利士人的手。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S17_4","010_7_4","1SA","7","4","4","以色列人就除掉诸巴力和亚斯她录，单单地事奉耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S17_5","010_7_5","1SA","7","5","5","撒母耳说：「要使以色列众人聚集在米斯巴，我好为你们祷告耶和华。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S17_6","010_7_6","1SA","7","6","6","他们就聚集在米斯巴，打水浇在耶和华面前，当日禁食，说：「我们得罪了耶和华。」于是撒母耳在米斯巴审判以色列人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S17_7","010_7_7","1SA","7","7","7","非利士人听见以色列人聚集在米斯巴，非利士的首领就上来要攻击以色列人。以色列人听见，就惧怕非利士人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S17_8","010_7_8","1SA","7","8","8","以色列人对撒母耳说：「愿你不住地为我们呼求耶和华—我们的　神，救我们脱离非利士人的手。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S17_9","010_7_9","1SA","7","9","9","撒母耳就把一只吃奶的羊羔献与耶和华作全牲的燔祭，为以色列人呼求耶和华；耶和华就应允他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S17_10","010_7_10","1SA","7","10","10","撒母耳正献燔祭的时候，非利士人前来要与以色列人争战。当日，耶和华大发雷声，惊乱非利士人，他们就败在以色列人面前。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S17_11","010_7_11","1SA","7","11","11","以色列人从米斯巴出来，追赶非利士人，击杀他们，直到伯·甲的下边。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S17_12","010_7_12","1SA","7","12","12","撒母耳将一块石头立在米斯巴和善的中间，给石头起名叫以便以谢，说：「到如今耶和华都帮助我们。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S17_13","010_7_13","1SA","7","13","13","从此，非利士人就被制伏，不敢再入以色列人的境内。撒母耳作士师的时候，耶和华的手攻击非利士人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S17_14","010_7_14","1SA","7","14","14","非利士人所取以色列人的城邑，从以革伦直到迦特，都归以色列人了。属这些城的四境，以色列人也从非利士人手下收回。那时以色列人与亚摩利人和好。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S17_15","010_7_15","1SA","7","15","15","撒母耳平生作以色列的士师。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S17_16","010_7_16","1SA","7","16","16","他每年巡行到伯特利、吉甲、米斯巴，在这几处审判以色列人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S17_17","010_7_17","1SA","7","17","17","随后回到拉玛，因为他的家在那里；也在那里审判以色列人，且为耶和华筑了一座坛。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S18_1","010_8_1","1SA","8","1","1","撒母耳年纪老迈，就立他儿子作以色列的士师。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S18_2","010_8_2","1SA","8","2","2","长子名叫约珥，次子名叫亚比亚；他们在别是巴作士师。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S18_3","010_8_3","1SA","8","3","3","他儿子不行他的道，贪图财利，收受贿赂，屈枉正直。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S18_4","010_8_4","1SA","8","4","4","以色列的长老都聚集，来到拉玛见撒母耳， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S18_5","010_8_5","1SA","8","5","5","对他说：「你年纪老迈了，你儿子不行你的道。现在求你为我们立一个王治理我们，像列国一样。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S18_6","010_8_6","1SA","8","6","6","撒母耳不喜悦他们说「立一个王治理我们」，他就祷告耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S18_7","010_8_7","1SA","8","7","7","耶和华对撒母耳说：「百姓向你说的一切话，你只管依从；因为他们不是厌弃你，乃是厌弃我，不要我作他们的王。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S18_8","010_8_8","1SA","8","8","8","自从我领他们出埃及到如今，他们常常离弃我，事奉别神。现在他们向你所行的，是照他们素来所行的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S18_9","010_8_9","1SA","8","9","9","故此你要依从他们的话，只是当警戒他们，告诉他们将来那王怎样管辖他们。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S18_10","010_8_10","1SA","8","10","10","撒母耳将耶和华的话都传给求他立王的百姓，说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("S18_11","010_8_11","1SA","8","11","11","「管辖你们的王必这样行：他必派你们的儿子为他赶车、跟马，奔走在车前； ");
INSERT INTO cmn_cu89s_vpl VALUES ("S18_12","010_8_12","1SA","8","12","12","又派他们作千夫长、五十夫长，为他耕种田地，收割庄稼，打造军器和车上的器械； ");
INSERT INTO cmn_cu89s_vpl VALUES ("S18_13","010_8_13","1SA","8","13","13","必取你们的女儿为他制造香膏，做饭烤饼； ");
INSERT INTO cmn_cu89s_vpl VALUES ("S18_14","010_8_14","1SA","8","14","14","也必取你们最好的田地、葡萄园、橄榄园赐给他的臣仆。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S18_15","010_8_15","1SA","8","15","15","你们的粮食和葡萄园所出的，他必取十分之一给他的太监和臣仆； ");
INSERT INTO cmn_cu89s_vpl VALUES ("S18_16","010_8_16","1SA","8","16","16","又必取你们的仆人婢女，健壮的少年人和你们的驴，供他的差役。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S18_17","010_8_17","1SA","8","17","17","你们的羊群他必取十分之一，你们也必作他的仆人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S18_18","010_8_18","1SA","8","18","18","那时你们必因所选的王哀求耶和华，耶和华却不应允你们。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S18_19","010_8_19","1SA","8","19","19","百姓竟不肯听撒母耳的话，说：「不然！我们定要一个王治理我们， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S18_20","010_8_20","1SA","8","20","20","使我们像列国一样，有王治理我们，统领我们，为我们争战。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S18_21","010_8_21","1SA","8","21","21","撒母耳听见百姓这一切话，就将这话陈明在耶和华面前。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S18_22","010_8_22","1SA","8","22","22","耶和华对撒母耳说：「你只管依从他们的话，为他们立王。」撒母耳对以色列人说：「你们各归各城去吧！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S19_1","010_9_1","1SA","9","1","1","有一个便雅悯人，名叫基士，是便雅悯人亚斐亚的玄孙，比歌拉的曾孙，洗罗的孙子，亚别的儿子，是个大能的勇士。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S19_2","010_9_2","1SA","9","2","2","他有一个儿子，名叫扫罗，又健壮、又俊美，在以色列人中没有一个能比他的；身体比众民高过一头。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S19_3","010_9_3","1SA","9","3","3","扫罗的父亲基士丢了几头驴，他就吩咐儿子扫罗说：「你带一个仆人去寻找驴。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S19_4","010_9_4","1SA","9","4","4","扫罗就走过以法莲山地，又过沙利沙地，都没有找着；又过沙琳地，驴也不在那里；又过便雅悯地，还没有找着。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S19_5","010_9_5","1SA","9","5","5","到了苏弗地，扫罗对跟随他的仆人说：「我们不如回去，恐怕我父亲不为驴挂心，反为我们担忧。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S19_6","010_9_6","1SA","9","6","6","仆人说：「这城里有一位神人，是众人所尊重的，凡他所说的全都应验。我们不如往他那里去，或者他能将我们当走的路指示我们。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S19_7","010_9_7","1SA","9","7","7","扫罗对仆人说：「我们若去，有什么可以送那人呢？我们囊中的食物都吃尽了，也没有礼物可以送那神人，我们还有什么没有？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S19_8","010_9_8","1SA","9","8","8","仆人回答扫罗说：「我手里有银子一舍客勒的四分之一，可以送那神人，请他指示我们当走的路。」（ ");
INSERT INTO cmn_cu89s_vpl VALUES ("S19_9","010_9_9","1SA","9","9","9","从前以色列中，若有人去问　神，就说：「我们问先见去吧！」现在称为「先知」的，从前称为「先见」。） ");
INSERT INTO cmn_cu89s_vpl VALUES ("S19_10","010_9_10","1SA","9","10","10","扫罗对仆人说：「你说的是，我们可以去。」于是他们往神人所住的城里去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S19_11","010_9_11","1SA","9","11","11","他们上坡要进城，就遇见几个少年女子出来打水，问她们说：「先见在这里没有？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S19_12","010_9_12","1SA","9","12","12","女子回答说：「在这里，他在你们前面。快去吧！他今日正到城里，因为今日百姓要在邱坛献祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S19_13","010_9_13","1SA","9","13","13","在他还没有上邱坛吃祭物之先，你们一进城必遇见他；因他未到，百姓不能吃，必等他先祝祭，然后请的客才吃。现在你们上去，这时候必遇见他。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S19_14","010_9_14","1SA","9","14","14","二人就上去；将进城的时候，撒母耳正迎着他们来，要上邱坛去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S19_15","010_9_15","1SA","9","15","15","扫罗未到的前一日，耶和华已经指示撒母耳说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("S19_16","010_9_16","1SA","9","16","16","「明日这时候，我必使一个人从便雅悯地到你这里来，你要膏他作我民以色列的君。他必救我民脱离非利士人的手；因我民的哀声上达于我，我就眷顾他们。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S19_17","010_9_17","1SA","9","17","17","撒母耳看见扫罗的时候，耶和华对他说：「看哪，这人就是我对你所说的，他必治理我的民。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S19_18","010_9_18","1SA","9","18","18","扫罗在城门里走到撒母耳跟前，说：「请告诉我，先见的寓所在哪里？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S19_19","010_9_19","1SA","9","19","19","撒母耳回答说：「我就是先见。你在我前面上邱坛去，因为你们今日必与我同席；明日早晨我送你去，将你心里的事都告诉你。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S19_20","010_9_20","1SA","9","20","20","至于你前三日所丢的那几头驴，你心里不必挂念，已经找着了。以色列众人所仰慕的是谁呢？不是仰慕你和你父的全家吗？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S19_21","010_9_21","1SA","9","21","21","扫罗说：「我不是以色列支派中至小的便雅悯人吗？我家不是便雅悯支派中至小的家吗？你为何对我说这样的话呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S19_22","010_9_22","1SA","9","22","22","撒母耳领扫罗和他仆人进了客堂，使他们在请来的客中坐首位；客约有三十个人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S19_23","010_9_23","1SA","9","23","23","撒母耳对厨役说：「我交给你收存的那一分祭肉现在可以拿来。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S19_24","010_9_24","1SA","9","24","24","厨役就把收存的腿拿来，摆在扫罗面前，撒母耳说：「这是所留下的，放在你面前。吃吧！因我请百姓的时候，特意为你存留这肉到此时。」 当日，扫罗就与撒母耳同席。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S19_25","010_9_25","1SA","9","25","25","众人从邱坛下来进城，撒母耳和扫罗在房顶上说话。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S19_26","010_9_26","1SA","9","26","26","次日清早起来，黎明的时候，扫罗在房顶上。撒母耳呼叫他说：「起来吧，我好送你回去。」扫罗就起来，和撒母耳一同出去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S19_27","010_9_27","1SA","9","27","27","二人下到城角，撒母耳对扫罗说：「要吩咐仆人先走（仆人就先走了）；你且站在这里，等我将　神的话传与你听。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S110_1","010_10_1","1SA","10","1","1","撒母耳拿瓶膏油倒在扫罗的头上，与他亲嘴，说：「这不是耶和华膏你作他产业的君吗？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("S110_2","010_10_2","1SA","10","2","2","你今日与我离别之后，在便雅悯境内的泄撒，靠近拉结的坟墓，要遇见两个人。他们必对你说：『你去找的那几头驴已经找着了。现在你父亲不为驴挂心，反为你担忧，说：我为儿子怎么才好呢？』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S110_3","010_10_3","1SA","10","3","3","你从那里往前行，到了他泊的橡树那里，必遇见三个往伯特利去拜　神的人：一个带着三只山羊羔，一个带着三个饼，一个带着一皮袋酒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S110_4","010_10_4","1SA","10","4","4","他们必问你安，给你两个饼，你就从他们手中接过来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S110_5","010_10_5","1SA","10","5","5","此后你到　神的山，在那里有非利士人的防兵。你到了城的时候，必遇见一班先知从邱坛下来，前面有鼓瑟的、击鼓的、吹笛的、弹琴的，他们都受感说话。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S110_6","010_10_6","1SA","10","6","6","耶和华的灵必大大感动你，你就与他们一同受感说话；你要变为新人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S110_7","010_10_7","1SA","10","7","7","这兆头临到你，你就可以趁时而做，因为　神与你同在。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S110_8","010_10_8","1SA","10","8","8","你当在我以先下到吉甲，我也必下到那里献燔祭和平安祭。你要等候七日，等我到了那里，指示你当行的事。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S110_9","010_10_9","1SA","10","9","9","扫罗转身离别撒母耳，　神就赐他一个新心。当日这一切兆头都应验了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S110_10","010_10_10","1SA","10","10","10","扫罗到了那山，有一班先知遇见他，　神的灵大大感动他，他就在先知中受感说话。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S110_11","010_10_11","1SA","10","11","11","素来认识扫罗的，看见他和先知一同受感说话，就彼此说：「基士的儿子遇见什么了？扫罗也列在先知中吗？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S110_12","010_10_12","1SA","10","12","12","那地方有一个人说：「这些人的父亲是谁呢？」此后有句俗语说：「扫罗也列在先知中吗？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S110_13","010_10_13","1SA","10","13","13","扫罗受感说话已毕，就上邱坛去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S110_14","010_10_14","1SA","10","14","14","扫罗的叔叔问扫罗和他仆人说：「你们往哪里去了？」回答说：「找驴去了。我们见没有驴，就到了撒母耳那里。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S110_15","010_10_15","1SA","10","15","15","扫罗的叔叔说：「请将撒母耳向你们所说的话告诉我。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S110_16","010_10_16","1SA","10","16","16","扫罗对他叔叔说：「他明明地告诉我们驴已经找着了。」至于撒母耳所说的国事，扫罗却没有告诉叔叔。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S110_17","010_10_17","1SA","10","17","17","撒母耳将百姓招聚到米斯巴耶和华那里， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S110_18","010_10_18","1SA","10","18","18","对他们说：「耶和华—以色列的　神如此说：『我领你们以色列人出埃及，救你们脱离埃及人的手，又救你们脱离欺压你们各国之人的手。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S110_19","010_10_19","1SA","10","19","19","你们今日却厌弃了救你们脱离一切灾难的　神，说：『求你立一个王治理我们。』现在你们应当按着支派、宗族都站在耶和华面前。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S110_20","010_10_20","1SA","10","20","20","于是，撒母耳使以色列众支派近前来掣签，就掣出便雅悯支派来； ");
INSERT INTO cmn_cu89s_vpl VALUES ("S110_21","010_10_21","1SA","10","21","21","又使便雅悯支派按着宗族近前来，就掣出玛特利族，从其中又掣出基士的儿子扫罗。众人寻找他却寻不着， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S110_22","010_10_22","1SA","10","22","22","就问耶和华说：「那人到这里来了没有？」耶和华说：「他藏在器具中了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S110_23","010_10_23","1SA","10","23","23","众人就跑去从那里领出他来。他站在百姓中间，身体比众民高过一头。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S110_24","010_10_24","1SA","10","24","24","撒母耳对众民说：「你们看耶和华所拣选的人，众民中有可比他的吗？」众民就大声欢呼说：「愿王万岁！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S110_25","010_10_25","1SA","10","25","25","撒母耳将国法对百姓说明，又记在书上，放在耶和华面前，然后遣散众民，各回各家去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S110_26","010_10_26","1SA","10","26","26","扫罗往基比亚回家去，有　神感动的一群人跟随他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S110_27","010_10_27","1SA","10","27","27","但有些匪徒说：「这人怎能救我们呢？」就藐视他，没有送他礼物；扫罗却不理会。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S111_1","010_11_1","1SA","11","1","1","亚扪人的王拿辖上来，对着基列·雅比安营。雅比众人对拿辖说：「你与我们立约，我们就服事你。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S111_2","010_11_2","1SA","11","2","2","亚扪人拿辖说：「你们若由我剜出你们各人的右眼，以此凌辱以色列众人，我就与你们立约。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S111_3","010_11_3","1SA","11","3","3","雅比的长老对他说：「求你宽容我们七日，等我们打发人往以色列的全境去；若没有人救我们，我们就出来归顺你。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S111_4","010_11_4","1SA","11","4","4","使者到了扫罗住的基比亚，将这话说给百姓听，百姓就都放声而哭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S111_5","010_11_5","1SA","11","5","5","扫罗正从田间赶牛回来，问说：「百姓为什么哭呢？」众人将雅比人的话告诉他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S111_6","010_11_6","1SA","11","6","6","扫罗听见这话，就被　神的灵大大感动，甚是发怒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S111_7","010_11_7","1SA","11","7","7","他将一对牛切成块子，托付使者传送以色列的全境，说：「凡不出来跟随扫罗和撒母耳的，也必这样切开他的牛。」于是耶和华使百姓惧怕，他们就都出来，如同一人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S111_8","010_11_8","1SA","11","8","8","扫罗在比色数点他们：以色列人有三十万，犹大人有三万。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S111_9","010_11_9","1SA","11","9","9","众人对那使者说：「你们要回复基列·雅比人说，明日太阳近午的时候，你们必得解救。」使者回去告诉雅比人，他们就欢喜了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S111_10","010_11_10","1SA","11","10","10","于是雅比人对亚扪人说：「明日我们出来归顺你们，你们可以随意待我们。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S111_11","010_11_11","1SA","11","11","11","第二日，扫罗将百姓分为三队，在晨更的时候入了亚扪人的营，击杀他们直到太阳近午，剩下的人都逃散，没有二人同在一处的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S111_12","010_11_12","1SA","11","12","12","百姓对撒母耳说：「那说『扫罗岂能管理我们』的是谁呢？可以将他交出来，我们好杀死他。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S111_13","010_11_13","1SA","11","13","13","扫罗说：「今日耶和华在以色列中施行拯救，所以不可杀人。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S111_14","010_11_14","1SA","11","14","14","撒母耳对百姓说：「我们要往吉甲去，在那里立国。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S111_15","010_11_15","1SA","11","15","15","众百姓就到了吉甲那里，在耶和华面前立扫罗为王，又在耶和华面前献平安祭。扫罗和以色列众人大大欢喜。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S112_1","010_12_1","1SA","12","1","1","撒母耳对以色列众人说：「你们向我所求的，我已应允了，为你们立了一个王； ");
INSERT INTO cmn_cu89s_vpl VALUES ("S112_2","010_12_2","1SA","12","2","2","现在有这王在你们前面行。我已年老发白，我的儿子都在你们这里。我从幼年直到今日都在你们前面行。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S112_3","010_12_3","1SA","12","3","3","我在这里，你们要在耶和华和他的受膏者面前给我作见证。我夺过谁的牛，抢过谁的驴，欺负过谁，虐待过谁，从谁手里受过贿赂因而眼瞎呢？若有，我必偿还。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S112_4","010_12_4","1SA","12","4","4","众人说：「你未曾欺负我们，虐待我们，也未曾从谁手里受过什么。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S112_5","010_12_5","1SA","12","5","5","撒母耳对他们说：「你们在我手里没有找着什么，有耶和华和他的受膏者今日为证。」他们说：「愿他为证。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S112_6","010_12_6","1SA","12","6","6","撒母耳对百姓说：「从前立摩西、亚伦，又领你们列祖出埃及地的是耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S112_7","010_12_7","1SA","12","7","7","现在你们要站住，等我在耶和华面前对你们讲论耶和华向你们和你们列祖所行一切公义的事。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S112_8","010_12_8","1SA","12","8","8","从前雅各到了埃及，后来你们列祖呼求耶和华，耶和华就差遣摩西、亚伦领你们列祖出埃及，使他们在这地方居住。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S112_9","010_12_9","1SA","12","9","9","他们却忘记耶和华—他们的　神，他就把他们付与夏琐将军西西拉的手里，和非利士人并摩押王的手里。于是这些人常来攻击他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S112_10","010_12_10","1SA","12","10","10","他们就呼求耶和华说：『我们离弃耶和华，事奉巴力和亚斯她录，是有罪了。现在求你救我们脱离仇敌的手，我们必事奉你。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S112_11","010_12_11","1SA","12","11","11","耶和华就差遣耶路·巴力、比但、耶弗他、撒母耳救你们脱离四围仇敌的手，你们才安然居住。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S112_12","010_12_12","1SA","12","12","12","你们见亚扪人的王拿辖来攻击你们，就对我说：『我们定要一个王治理我们。』其实耶和华—你们的　神是你们的王。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S112_13","010_12_13","1SA","12","13","13","现在，你们所求所选的王在这里。看哪，耶和华已经为你们立王了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S112_14","010_12_14","1SA","12","14","14","你们若敬畏耶和华，事奉他，听从他的话，不违背他的命令，你们和治理你们的王也都顺从耶和华—你们的　神就好了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S112_15","010_12_15","1SA","12","15","15","倘若不听从耶和华的话，违背他的命令，耶和华的手必攻击你们，像从前攻击你们列祖一样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S112_16","010_12_16","1SA","12","16","16","现在你们要站住，看耶和华在你们眼前要行一件大事。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S112_17","010_12_17","1SA","12","17","17","这不是割麦子的时候吗？我求告耶和华，他必打雷降雨，使你们又知道又看出，你们求立王的事是在耶和华面前犯大罪了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S112_18","010_12_18","1SA","12","18","18","于是撒母耳求告耶和华，耶和华就在这日打雷降雨，众民便甚惧怕耶和华和撒母耳。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S112_19","010_12_19","1SA","12","19","19","众民对撒母耳说：「求你为仆人们祷告耶和华—你的　神，免得我们死亡，因为我们求立王的事正是罪上加罪了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S112_20","010_12_20","1SA","12","20","20","撒母耳对百姓说：「不要惧怕！你们虽然行了这恶，却不要偏离耶和华，只要尽心事奉他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S112_21","010_12_21","1SA","12","21","21","若偏离耶和华去顺从那不能救人的虚神是无益的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S112_22","010_12_22","1SA","12","22","22","耶和华既喜悦选你们作他的子民，就必因他的大名不撇弃你们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S112_23","010_12_23","1SA","12","23","23","至于我，断不停止为你们祷告，以致得罪耶和华。我必以善道正路指教你们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S112_24","010_12_24","1SA","12","24","24","只要你们敬畏耶和华，诚诚实实地尽心事奉他，想念他向你们所行的事何等大。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S112_25","010_12_25","1SA","12","25","25","你们若仍然作恶，你们和你们的王必一同灭亡。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S113_1","010_13_1","1SA","13","1","1","扫罗登基年四十岁；作以色列王二年的时候， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S113_2","010_13_2","1SA","13","2","2","就从以色列中拣选了三千人：二千跟随扫罗在密抹和伯特利山，一千跟随约拿单在便雅悯的基比亚；其余的人扫罗都打发各回各家去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S113_3","010_13_3","1SA","13","3","3","约拿单攻击在迦巴的非利士人的防营，非利士人听见了。扫罗就在遍地吹角，意思说，要使希伯来人听见。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S113_4","010_13_4","1SA","13","4","4","以色列众人听见扫罗攻击非利士人的防营，又听见以色列人为非利士人所憎恶，就跟随扫罗聚集在吉甲。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S113_5","010_13_5","1SA","13","5","5","非利士人聚集，要与以色列人争战，有车三万辆，马兵六千，步兵像海边的沙那样多，就上来在伯·亚文东边的密抹安营。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S113_6","010_13_6","1SA","13","6","6","以色列百姓见自己危急窘迫，就藏在山洞、丛林、石穴、隐密处，和坑中。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S113_7","010_13_7","1SA","13","7","7","有些希伯来人过了约旦河，逃到迦得和基列地。扫罗还是在吉甲，百姓都战战兢兢地跟随他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S113_8","010_13_8","1SA","13","8","8","扫罗照着撒母耳所定的日期等了七日。撒母耳还没有来到吉甲，百姓也离开扫罗散去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S113_9","010_13_9","1SA","13","9","9","扫罗说：「把燔祭和平安祭带到我这里来。」扫罗就献上燔祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S113_10","010_13_10","1SA","13","10","10","刚献完燔祭，撒母耳就到了。扫罗出去迎接他，要问他好。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S113_11","010_13_11","1SA","13","11","11","撒母耳说：「你做的是什么事呢？」扫罗说：「因为我见百姓离开我散去，你也不照所定的日期来到，而且非利士人聚集在密抹。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S113_12","010_13_12","1SA","13","12","12","所以我心里说：恐怕我没有祷告耶和华。非利士人下到吉甲攻击我，我就勉强献上燔祭。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S113_13","010_13_13","1SA","13","13","13","撒母耳对扫罗说：「你做了糊涂事了，没有遵守耶和华—你　神所吩咐你的命令。若遵守，耶和华必在以色列中坚立你的王位，直到永远。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S113_14","010_13_14","1SA","13","14","14","现在你的王位必不长久。耶和华已经寻着一个合他心意的人，立他作百姓的君，因为你没有遵守耶和华所吩咐你的。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S113_15","010_13_15","1SA","13","15","15","撒母耳就起来，从吉甲上到便雅悯的基比亚。 扫罗数点跟随他的，约有六百人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S113_16","010_13_16","1SA","13","16","16","扫罗和他儿子约拿单，并跟随他们的人，都住在便雅悯的迦巴；但非利士人安营在密抹。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S113_17","010_13_17","1SA","13","17","17","有掠兵从非利士营中出来，分为三队：一队往俄弗拉向书亚地去， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S113_18","010_13_18","1SA","13","18","18","一队往伯·和 去，一队往洗波音谷对面的地境向旷野去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S113_19","010_13_19","1SA","13","19","19","那时，以色列全地没有一个铁匠；因为非利士人说，恐怕希伯来人制造刀枪。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S113_20","010_13_20","1SA","13","20","20","以色列人要磨锄、犁、斧、铲，就下到非利士人那里去磨。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S113_21","010_13_21","1SA","13","21","21","但有锉可以锉铲、犁、三齿叉、斧子，并赶牛锥。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S113_22","010_13_22","1SA","13","22","22","所以到了争战的日子，跟随扫罗和约拿单的人没有一个手里有刀有枪的，惟独扫罗和他儿子约拿单有。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S113_23","010_13_23","1SA","13","23","23","非利士人的一队防兵到了密抹的隘口。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S114_1","010_14_1","1SA","14","1","1","有一日，扫罗的儿子约拿单对拿他兵器的少年人说：「我们不如过到那边，到非利士人的防营那里去。」但他没有告诉父亲。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S114_2","010_14_2","1SA","14","2","2","扫罗在基比亚的尽边，坐在米矶 的石榴树下，跟随他的约有六百人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S114_3","010_14_3","1SA","14","3","3","在那里有亚希突的儿子亚希亚，穿着以弗得。（亚希突是以迦博的哥哥，非尼哈的儿子，以利的孙子。以利从前在示罗作耶和华的祭司。）约拿单去了，百姓却不知道。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S114_4","010_14_4","1SA","14","4","4","约拿单要从隘口过到非利士防营那里去。这隘口两边各有一个山峰：一名播薛，一名西尼； ");
INSERT INTO cmn_cu89s_vpl VALUES ("S114_5","010_14_5","1SA","14","5","5","一峰向北，与密抹相对，一峰向南，与迦巴相对。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S114_6","010_14_6","1SA","14","6","6","约拿单对拿兵器的少年人说：「我们不如过到未受割礼人的防营那里去，或者耶和华为我们施展能力；因为耶和华使人得胜，不在乎人多人少。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S114_7","010_14_7","1SA","14","7","7","拿兵器的对他说：「随你的心意行吧。你可以上去，我必跟随你，与你同心。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S114_8","010_14_8","1SA","14","8","8","约拿单说：「我们要过到那些人那里去，使他们看见我们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S114_9","010_14_9","1SA","14","9","9","他们若对我们说：『你们站住，等我们到你们那里去』，我们就站住，不上他们那里去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S114_10","010_14_10","1SA","14","10","10","他们若说：『你们上到我们这里来』，这话就是我们的证据；我们便上去，因为耶和华将他们交在我们手里了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S114_11","010_14_11","1SA","14","11","11","二人就使非利士的防兵看见。非利士人说：「希伯来人从所藏的洞穴里出来了！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S114_12","010_14_12","1SA","14","12","12","防兵对约拿单和拿兵器的人说：「你们上到这里来，我们有一件事指示你们。」约拿单就对拿兵器的人说：「你跟随我上去，因为耶和华将他们交在以色列人手里了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S114_13","010_14_13","1SA","14","13","13","约拿单就爬上去，拿兵器的人跟随他。约拿单杀倒非利士人，拿兵器的人也随着杀他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S114_14","010_14_14","1SA","14","14","14","约拿单和拿兵器的人起头所杀的约有二十人，都在一亩地的半犁沟之内。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S114_15","010_14_15","1SA","14","15","15","于是在营中、在田野、在众民内都有战兢，防兵和掠兵也都战兢，地也震动，战兢之势甚大。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S114_16","010_14_16","1SA","14","16","16","在便雅悯的基比亚，扫罗的守望兵看见非利士的军众溃散，四围乱窜。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S114_17","010_14_17","1SA","14","17","17","扫罗就对跟随他的民说：「你们查点查点，看从我们这里出去的是谁？」他们一查点，就知道约拿单和拿兵器的人没有在这里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S114_18","010_14_18","1SA","14","18","18","那时　神的约柜在以色列人那里。扫罗对亚希亚说：「你将　神的约柜运了来。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S114_19","010_14_19","1SA","14","19","19","扫罗正与祭司说话的时候，非利士营中的喧嚷越发大了；扫罗就对祭司说：「停手吧！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S114_20","010_14_20","1SA","14","20","20","扫罗和跟随他的人都聚集，来到战场，看见非利士人用刀互相击杀，大大惶乱。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S114_21","010_14_21","1SA","14","21","21","从前由四方来跟随非利士军的希伯来人现在也转过来，帮助跟随扫罗和约拿单的以色列人了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S114_22","010_14_22","1SA","14","22","22","那藏在以法莲山地的以色列人听说非利士人逃跑，就出来紧紧地追杀他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S114_23","010_14_23","1SA","14","23","23","那日，耶和华使以色列人得胜，一直战到伯·亚文。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S114_24","010_14_24","1SA","14","24","24","扫罗叫百姓起誓说，凡不等到晚上向敌人报完了仇吃什么的，必受咒诅。因此这日百姓没有吃什么，就极其困惫。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S114_25","010_14_25","1SA","14","25","25","众民进入树林，见有蜜在地上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S114_26","010_14_26","1SA","14","26","26","他们进了树林，见有蜜流下来，却没有人敢用手取蜜入口，因为他们怕那誓言。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S114_27","010_14_27","1SA","14","27","27","约拿单没有听见他父亲叫百姓起誓，所以伸手中的杖，用杖头蘸在蜂房里，转手送入口内，眼睛就明亮了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S114_28","010_14_28","1SA","14","28","28","百姓中有一人对他说：「你父亲曾叫百姓严严地起誓说，今日吃什么的，必受咒诅；因此百姓就疲乏了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S114_29","010_14_29","1SA","14","29","29","约拿单说：「我父亲连累你们了。你看，我尝了这一点蜜，眼睛就明亮了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S114_30","010_14_30","1SA","14","30","30","今日百姓若任意吃了从仇敌所夺的物，击杀的非利士人岂不更多吗？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S114_31","010_14_31","1SA","14","31","31","这日，以色列人击杀非利士人，从密抹直到亚雅 。百姓甚是疲乏， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S114_32","010_14_32","1SA","14","32","32","就急忙将所夺的牛羊和牛犊宰于地上，肉还带血就吃了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S114_33","010_14_33","1SA","14","33","33","有人告诉扫罗说：「百姓吃带血的肉，得罪耶和华了。」扫罗说：「你们有罪了，今日要将大石头滚到我这里来。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S114_34","010_14_34","1SA","14","34","34","扫罗又说：「你们散在百姓中，对他们说，你们各人将牛羊牵到我这里来宰了吃，不可吃带血的肉得罪耶和华。」这夜，百姓就把牛羊牵到那里宰了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S114_35","010_14_35","1SA","14","35","35","扫罗为耶和华筑了一座坛，这是他初次为耶和华筑的坛。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S114_36","010_14_36","1SA","14","36","36","扫罗说：「我们不如夜里下去追赶非利士人，抢掠他们，直到天亮，不留他们一人。」众民说：「你看怎样好就去行吧！」祭司说：「我们先当亲近　神。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S114_37","010_14_37","1SA","14","37","37","扫罗求问　神说：「我下去追赶非利士人可以不可以？你将他们交在以色列人手里不交？」这日　神没有回答他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S114_38","010_14_38","1SA","14","38","38","扫罗说：「你们百姓中的长老都上这里来，查明今日是谁犯了罪。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S114_39","010_14_39","1SA","14","39","39","我指着救以色列—永生的耶和华起誓，就是我儿子约拿单犯了罪，他也必死。」但百姓中无一人回答他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S114_40","010_14_40","1SA","14","40","40","扫罗就对以色列众人说：「你们站在一边，我与我儿子约拿单也站在一边。」百姓对扫罗说：「你看怎样好就去行吧！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S114_41","010_14_41","1SA","14","41","41","扫罗祷告耶和华—以色列的　神说：「求你指示实情。」于是掣签掣出扫罗和约拿单来；百姓尽都无事。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S114_42","010_14_42","1SA","14","42","42","扫罗说：「你们再掣签，看是我，是我儿子约拿单」，就掣出约拿单来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S114_43","010_14_43","1SA","14","43","43","扫罗对约拿单说：「你告诉我，你做了什么事？」约拿单说：「我实在以手里的杖，用杖头蘸了一点蜜尝了一尝。这样我就死吗？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S114_44","010_14_44","1SA","14","44","44","扫罗说：「约拿单哪，你定要死！若不然，愿　神重重地降罚与我。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S114_45","010_14_45","1SA","14","45","45","百姓对扫罗说：「约拿单在以色列人中这样大行拯救，岂可使他死呢？断乎不可！我们指着永生的耶和华起誓，连他的一根头发也不可落地，因为他今日与　神一同做事。」于是百姓救约拿单免了死亡。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S114_46","010_14_46","1SA","14","46","46","扫罗回去，不追赶非利士人；非利士人也回本地去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S114_47","010_14_47","1SA","14","47","47","扫罗执掌以色列的国权，常常攻击他四围的一切仇敌，就是摩押人、亚扪人、以东人，和琐巴诸王，并非利士人。他无论往何处去，都打败仇敌。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S114_48","010_14_48","1SA","14","48","48","扫罗奋勇攻击亚玛力人，救了以色列人脱离抢掠他们之人的手。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S114_49","010_14_49","1SA","14","49","49","扫罗的儿子是约拿单、亦施韦、麦基舒亚。他的两个女儿：长女名米拉，次女名米甲。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S114_50","010_14_50","1SA","14","50","50","扫罗的妻名叫亚希暖，是亚希玛斯的女儿。扫罗的元帅名叫押尼珥，是尼珥的儿子；尼珥是扫罗的叔叔。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S114_51","010_14_51","1SA","14","51","51","扫罗的父亲基士，押尼珥的父亲尼珥，都是亚别的儿子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S114_52","010_14_52","1SA","14","52","52","扫罗平生常与非利士人大大争战。扫罗遇见有能力的人或勇士，都招募了来跟随他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S115_1","010_15_1","1SA","15","1","1","撒母耳对扫罗说：「耶和华差遣我膏你为王，治理他的百姓以色列；所以你当听从耶和华的话。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S115_2","010_15_2","1SA","15","2","2","万军之耶和华如此说：『以色列人出埃及的时候，在路上亚玛力人怎样待他们，怎样抵挡他们，我都没忘。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S115_3","010_15_3","1SA","15","3","3","现在你要去击打亚玛力人，灭尽他们所有的，不可怜惜他们，将男女、孩童、吃奶的，并牛、羊、骆驼，和驴尽行杀死。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S115_4","010_15_4","1SA","15","4","4","于是扫罗招聚百姓在提拉因，数点他们，共有步兵二十万，另有犹大人一万。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S115_5","010_15_5","1SA","15","5","5","扫罗到了亚玛力的京城，在谷中设下埋伏。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S115_6","010_15_6","1SA","15","6","6","扫罗对基尼人说：「你们离开亚玛力人下去吧，恐怕我将你们和亚玛力人一同杀灭；因为以色列人出埃及的时候，你们曾恩待他们。」于是基尼人离开亚玛力人去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S115_7","010_15_7","1SA","15","7","7","扫罗击打亚玛力人，从哈腓拉直到埃及前的书珥， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S115_8","010_15_8","1SA","15","8","8","生擒了亚玛力王亚甲，用刀杀尽亚玛力的众民。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S115_9","010_15_9","1SA","15","9","9","扫罗和百姓却怜惜亚甲，也爱惜上好的牛、羊、牛犊、羊羔，并一切美物，不肯灭绝。凡下贱瘦弱的，尽都杀了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S115_10","010_15_10","1SA","15","10","10","耶和华的话临到撒母耳说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("S115_11","010_15_11","1SA","15","11","11","「我立扫罗为王，我后悔了；因为他转去不跟从我，不遵守我的命令。」撒母耳便甚忧愁，终夜哀求耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S115_12","010_15_12","1SA","15","12","12","撒母耳清早起来，迎接扫罗。有人告诉撒母耳说：「扫罗到了迦密，在那里立了纪念碑，又转身下到吉甲。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S115_13","010_15_13","1SA","15","13","13","撒母耳到了扫罗那里，扫罗对他说：「愿耶和华赐福与你，耶和华的命令我已遵守了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S115_14","010_15_14","1SA","15","14","14","撒母耳说：「我耳中听见有羊叫、牛鸣，是从哪里来的呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S115_15","010_15_15","1SA","15","15","15","扫罗说：「这是百姓从亚玛力人那里带来的；因为他们爱惜上好的牛羊，要献与耶和华—你的　神；其余的，我们都灭尽了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S115_16","010_15_16","1SA","15","16","16","撒母耳对扫罗说：「你住口吧！等我将耶和华昨夜向我所说的话告诉你。」扫罗说：「请讲。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S115_17","010_15_17","1SA","15","17","17","撒母耳对扫罗说：「从前你虽然以自己为小，岂不是被立为以色列支派的元首吗？耶和华膏你作以色列的王。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S115_18","010_15_18","1SA","15","18","18","耶和华差遣你，吩咐你说，你去击打那些犯罪的亚玛力人，将他们灭绝净尽。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S115_19","010_15_19","1SA","15","19","19","你为何没有听从耶和华的命令，急忙掳掠财物，行耶和华眼中看为恶的事呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S115_20","010_15_20","1SA","15","20","20","扫罗对撒母耳说：「我实在听从了耶和华的命令，行了耶和华所差遣我行的路，擒了亚玛力王亚甲来，灭尽了亚玛力人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S115_21","010_15_21","1SA","15","21","21","百姓却在所当灭的物中，取了最好的牛羊，要在吉甲献与耶和华—你的　神。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S115_22","010_15_22","1SA","15","22","22","撒母耳说： 耶和华喜悦燔祭和平安祭， 岂如喜悦人听从他的话呢？ 听命胜于献祭； 顺从胜于公羊的脂油。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S115_23","010_15_23","1SA","15","23","23","悖逆的罪与行邪术的罪相等； 顽梗的罪与拜虚神和偶像的罪相同。 你既厌弃耶和华的命令， 耶和华也厌弃你作王。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S115_24","010_15_24","1SA","15","24","24","扫罗对撒母耳说：「我有罪了，我因惧怕百姓，听从他们的话，就违背了耶和华的命令和你的言语。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S115_25","010_15_25","1SA","15","25","25","现在求你赦免我的罪，同我回去，我好敬拜耶和华。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S115_26","010_15_26","1SA","15","26","26","撒母耳对扫罗说：「我不同你回去；因为你厌弃耶和华的命令，耶和华也厌弃你作以色列的王。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S115_27","010_15_27","1SA","15","27","27","撒母耳转身要走，扫罗就扯住他外袍的衣襟，衣襟就撕断了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S115_28","010_15_28","1SA","15","28","28","撒母耳对他说：「如此，今日耶和华使以色列国与你断绝，将这国赐与比你更好的人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S115_29","010_15_29","1SA","15","29","29","以色列的大能者必不致说谎，也不致后悔；因为他迥非世人，决不后悔。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S115_30","010_15_30","1SA","15","30","30","扫罗说：「我有罪了，虽然如此，求你在我百姓的长老和以色列人面前抬举我，同我回去，我好敬拜耶和华—你的　神。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S115_31","010_15_31","1SA","15","31","31","于是撒母耳转身跟随扫罗回去，扫罗就敬拜耶和华。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S115_32","010_15_32","1SA","15","32","32","撒母耳说：「要把亚玛力王亚甲带到我这里来。」亚甲就欢欢喜喜地来到他面前，心里说，死亡的苦难必定过去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S115_33","010_15_33","1SA","15","33","33","撒母耳说：「你既用刀使妇人丧子，这样，你母亲在妇人中也必丧子。」于是，撒母耳在吉甲耶和华面前将亚甲杀死。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S115_34","010_15_34","1SA","15","34","34","撒母耳回了拉玛。扫罗上他所住的基比亚，回自己的家去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S115_35","010_15_35","1SA","15","35","35","撒母耳直到死的日子，再没有见扫罗；但撒母耳为扫罗悲伤，是因耶和华后悔立他为以色列的王。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S116_1","010_16_1","1SA","16","1","1","耶和华对撒母耳说：「我既厌弃扫罗作以色列的王，你为他悲伤要到几时呢？你将膏油盛满了角，我差遣你往伯利恒人耶西那里去；因为我在他众子之内，预定一个作王的。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S116_2","010_16_2","1SA","16","2","2","撒母耳说：「我怎能去呢？扫罗若听见，必要杀我。」耶和华说：「你可以带一只牛犊去，就说：『我来是要向耶和华献祭。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S116_3","010_16_3","1SA","16","3","3","你要请耶西来吃祭肉，我就指示你所当行的事。我所指给你的人，你要膏他。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S116_4","010_16_4","1SA","16","4","4","撒母耳就照耶和华的话去行。到了伯利恒，那城里的长老都战战兢兢地出来迎接他，问他说：「你是为平安来的吗？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S116_5","010_16_5","1SA","16","5","5","他说：「为平安来的，我是给耶和华献祭。你们当自洁，来与我同吃祭肉。」撒母耳就使耶西和他众子自洁，请他们来吃祭肉。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S116_6","010_16_6","1SA","16","6","6","他们来的时候，撒母耳看见以 利押，就心里说，耶和华的受膏者必定在他面前。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S116_7","010_16_7","1SA","16","7","7","耶和华却对撒母耳说：「不要看他的外貌和他身材高大，我不拣选他。因为，耶和华不像人看人：人是看外貌；耶和华是看内心。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S116_8","010_16_8","1SA","16","8","8","耶西叫亚比拿达从撒母耳面前经过，撒母耳说：「耶和华也不拣选他。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S116_9","010_16_9","1SA","16","9","9","耶西又叫沙玛从撒母耳面前经过，撒母耳说：「耶和华也不拣选他。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S116_10","010_16_10","1SA","16","10","10","耶西叫他七个儿子都从撒母耳面前经过，撒母耳说：「这都不是耶和华所拣选的。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S116_11","010_16_11","1SA","16","11","11","撒母耳对耶西说：「你的儿子都在这里吗？」他回答说：「还有个小的，现在放羊。」撒母耳对耶西说：「你打发人去叫他来；他若不来，我们必不坐席。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S116_12","010_16_12","1SA","16","12","12","耶西就打发人去叫了他来。他面色光红，双目清秀，容貌俊美。耶和华说：「这就是他，你起来膏他。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S116_13","010_16_13","1SA","16","13","13","撒母耳就用角里的膏油，在他诸兄中膏了他。从这日起，耶和华的灵就大大感动大卫。撒母耳起身回拉玛去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S116_14","010_16_14","1SA","16","14","14","耶和华的灵离开扫罗，有恶魔从耶和华那里来扰乱他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S116_15","010_16_15","1SA","16","15","15","扫罗的臣仆对他说：「现在有恶魔从　神那里来扰乱你。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S116_16","010_16_16","1SA","16","16","16","我们的主可以吩咐面前的臣仆，找一个善于弹琴的来，等　神那里来的恶魔临到你身上的时候，使他用手弹琴，你就好了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S116_17","010_16_17","1SA","16","17","17","扫罗对臣仆说：「你们可以为我找一个善于弹琴的，带到我这里来。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S116_18","010_16_18","1SA","16","18","18","其中有一个少年人说：「我曾见伯利恒人耶西的一个儿子善于弹琴，是大有勇敢的战士，说话合宜，容貌俊美，耶和华也与他同在。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S116_19","010_16_19","1SA","16","19","19","于是扫罗差遣使者去见耶西，说：「请你打发你放羊的儿子大卫到我这里来。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S116_20","010_16_20","1SA","16","20","20","耶西就把几个饼和一皮袋酒，并一只山羊羔，都驮在驴上，交给他儿子大卫，送与扫罗。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S116_21","010_16_21","1SA","16","21","21","大卫到了扫罗那里，就侍立在扫罗面前。扫罗甚喜爱他，他就作了扫罗拿兵器的人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S116_22","010_16_22","1SA","16","22","22","扫罗差遣人去见耶西，说：「求你容大卫侍立在我面前，因为他在我眼前蒙了恩。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S116_23","010_16_23","1SA","16","23","23","从　神那里来的恶魔临到扫罗身上的时候，大卫就拿琴，用手而弹，扫罗便舒畅爽快，恶魔离了他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_1","010_17_1","1SA","17","1","1","非利士人招聚他们的军旅，要来争战；聚集在属犹大的梭哥，安营在梭哥和亚西加中间的以弗·大悯。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_2","010_17_2","1SA","17","2","2","扫罗和以色列人也聚集，在以拉谷安营，摆列队伍，要与非利士人打仗。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_3","010_17_3","1SA","17","3","3","非利士人站在这边山上，以色列人站在那边山上，当中有谷。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_4","010_17_4","1SA","17","4","4","从非利士营中出来一个讨战的人，名叫歌利亚，是迦特人，身高六肘零一虎口； ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_5","010_17_5","1SA","17","5","5","头戴铜盔，身穿铠甲，甲重五千舍客勒； ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_6","010_17_6","1SA","17","6","6","腿上有铜护膝，两肩之中背负铜戟； ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_7","010_17_7","1SA","17","7","7","枪杆粗如织布的机轴，铁枪头重六百舍客勒。有一个拿盾牌的人在他前面走。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_8","010_17_8","1SA","17","8","8","歌利亚对着以色列的军队站立，呼叫说：「你们出来摆列队伍做什么呢？我不是非利士人吗？你们不是扫罗的仆人吗？可以从你们中间拣选一人，使他下到我这里来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_9","010_17_9","1SA","17","9","9","他若能与我战斗，将我杀死，我们就作你们的仆人；我若胜了他，将他杀死，你们就作我们的仆人，服事我们。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_10","010_17_10","1SA","17","10","10","那非利士人又说：「我今日向以色列人的军队骂阵。你们叫一个人出来，与我战斗。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_11","010_17_11","1SA","17","11","11","扫罗和以色列众人听见非利士人的这些话，就惊惶，极其害怕。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_12","010_17_12","1SA","17","12","12","大卫是犹大伯利恒的以法他人耶西的儿子。耶西有八个儿子。当扫罗的时候，耶西已经老迈。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_13","010_17_13","1SA","17","13","13","耶西的三个大儿子跟随扫罗出征。这出征的三个儿子：长子名叫以利押，次子名叫亚比拿达，三子名叫沙玛。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_14","010_17_14","1SA","17","14","14","大卫是最小的；那三个大儿子跟随扫罗。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_15","010_17_15","1SA","17","15","15","大卫有时离开扫罗，回伯利恒放他父亲的羊。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_16","010_17_16","1SA","17","16","16","那非利士人早晚都出来站着，如此四十日。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_17","010_17_17","1SA","17","17","17","一日，耶西对他儿子大卫说：「你拿一伊法烘了的穗子和十个饼，速速地送到营里去，交给你哥哥们； ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_18","010_17_18","1SA","17","18","18","再拿这十块奶饼，送给他们的千夫长，且问你哥哥们好，向他们要一封信来。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_19","010_17_19","1SA","17","19","19","扫罗与大卫的三个哥哥和以色列众人，在以拉谷与非利士人打仗。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_20","010_17_20","1SA","17","20","20","大卫早晨起来，将羊交托一个看守的人，照着他父亲所吩咐的话，带着食物去了。到了辎重营，军兵刚出到战场，呐喊要战。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_21","010_17_21","1SA","17","21","21","以色列人和非利士人都摆列队伍，彼此相对。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_22","010_17_22","1SA","17","22","22","大卫把他带来的食物留在看守物件人的手下，跑到战场，问他哥哥们安。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_23","010_17_23","1SA","17","23","23","与他们说话的时候，那讨战的，就是属迦特的非利士人歌利亚，从非利士队中出来，说从前所说的话；大卫都听见了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_24","010_17_24","1SA","17","24","24","以色列众人看见那人，就逃跑，极其害怕。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_25","010_17_25","1SA","17","25","25","以色列人彼此说：「这上来的人你看见了吗？他上来是要向以色列人骂阵。若有能杀他的，王必赏赐他大财，将自己的女儿给他为妻，并在以色列人中免他父家纳粮当差。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_26","010_17_26","1SA","17","26","26","大卫问站在旁边的人说：「有人杀这非利士人，除掉以色列人的耻辱，怎样待他呢？这未受割礼的非利士人是谁呢？竟敢向永生　神的军队骂阵吗？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_27","010_17_27","1SA","17","27","27","百姓照先前的话回答他说：「有人能杀这非利士人，必如此如此待他。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_28","010_17_28","1SA","17","28","28","大卫的长兄以利押听见大卫与他们所说的话，就向他发怒，说：「你下来做什么呢？在旷野的那几只羊，你交托了谁呢？我知道你的骄傲和你心里的恶意，你下来特为要看争战！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_29","010_17_29","1SA","17","29","29","大卫说：「我做了什么呢？我来岂没有缘故吗？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_30","010_17_30","1SA","17","30","30","大卫就离开他转向别人，照先前的话而问；百姓仍照先前的话回答他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_31","010_17_31","1SA","17","31","31","有人听见大卫所说的话，就告诉了扫罗；扫罗便打发人叫他来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_32","010_17_32","1SA","17","32","32","大卫对扫罗说：「人都不必因那非利士人胆怯。你的仆人要去与那非利士人战斗。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_33","010_17_33","1SA","17","33","33","扫罗对大卫说：「你不能去与那非利士人战斗；因为你年纪太轻，他自幼就作战士。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_34","010_17_34","1SA","17","34","34","大卫对扫罗说：「你仆人为父亲放羊，有时来了狮子，有时来了熊，从群中衔一只羊羔去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_35","010_17_35","1SA","17","35","35","我就追赶它，击打它，将羊羔从它口中救出来。它起来要害我，我就揪着它的胡子，将它打死。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_36","010_17_36","1SA","17","36","36","你仆人曾打死狮子和熊，这未受割礼的非利士人向永生　神的军队骂阵，也必像狮子和熊一般。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_37","010_17_37","1SA","17","37","37","大卫又说：「耶和华救我脱离狮子和熊的爪，也必救我脱离这非利士人的手。」扫罗对大卫说：「你可以去吧！耶和华必与你同在。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_38","010_17_38","1SA","17","38","38","扫罗就把自己的战衣给大卫穿上，将铜盔给他戴上，又给他穿上铠甲。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_39","010_17_39","1SA","17","39","39","大卫把刀跨在战衣外，试试能走不能走；因为素来没有穿惯，就对扫罗说：「我穿戴这些不能走，因为素来没有穿惯。」于是摘脱了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_40","010_17_40","1SA","17","40","40","他手中拿杖，又在溪中挑选了五块光滑石子，放在袋里，就是牧人带的囊里；手中拿着甩石的机弦，就去迎那非利士人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_41","010_17_41","1SA","17","41","41","非利士人也渐渐地迎着大卫来，拿盾牌的走在前头。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_42","010_17_42","1SA","17","42","42","非利士人观看，见了大卫，就藐视他；因为他年轻，面色光红，容貌俊美。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_43","010_17_43","1SA","17","43","43","非利士人对大卫说：「你拿杖到我这里来，我岂是狗呢？」非利士人就指着自己的神咒诅大卫。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_44","010_17_44","1SA","17","44","44","非利士人又对大卫说：「来吧！我将你的肉给空中的飞鸟、田野的走兽吃。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_45","010_17_45","1SA","17","45","45","大卫对非利士人说：「你来攻击我，是靠着刀枪和铜戟；我来攻击你，是靠着万军之耶和华的名，就是你所怒骂带领以色列军队的　神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_46","010_17_46","1SA","17","46","46","今日耶和华必将你交在我手里。我必杀你，斩你的头，又将非利士军兵的尸首给空中的飞鸟、地上的野兽吃，使普天下的人都知道以色列中有　神； ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_47","010_17_47","1SA","17","47","47","又使这众人知道耶和华使人得胜，不是用刀用枪，因为争战的胜败全在乎耶和华。他必将你们交在我们手里。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_48","010_17_48","1SA","17","48","48","非利士人起身，迎着大卫前来。大卫急忙迎着非利士人，往战场跑去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_49","010_17_49","1SA","17","49","49","大卫用手从囊中掏出一块石子来，用机弦甩去，打中非利士人的额，石子进入额内，他就仆倒，面伏于地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_50","010_17_50","1SA","17","50","50","这样，大卫用机弦甩石，胜了那非利士人，打死他；大卫手中却没有刀。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_51","010_17_51","1SA","17","51","51","大卫跑去，站在非利士人身旁，将他的刀从鞘中拔出来，杀死他，割了他的头。非利士众人看见他们讨战的勇士死了，就都逃跑。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_52","010_17_52","1SA","17","52","52","以色列人和犹大人便起身呐喊，追赶非利士人，直到迦特和以革伦的城门。被杀的非利士人倒在沙拉音的路上，直到迦特和以革伦。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_53","010_17_53","1SA","17","53","53","以色列人追赶非利士人回来，就夺了他们的营盘。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_54","010_17_54","1SA","17","54","54","大卫将那非利士人的头拿到耶路撒冷，却将他军装放在自己的帐棚里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_55","010_17_55","1SA","17","55","55","扫罗看见大卫去攻击非利士人，就问元帅押尼珥说：「押尼珥啊，那少年人是谁的儿子？」押尼珥说：「我敢在王面前起誓，我不知道。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_56","010_17_56","1SA","17","56","56","王说：「你可以问问那幼年人是谁的儿子。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_57","010_17_57","1SA","17","57","57","大卫打死非利士人回来，押尼珥领他到扫罗面前，他手中拿着非利士人的头。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S117_58","010_17_58","1SA","17","58","58","扫罗问他说：「少年人哪，你是谁的儿子？」大卫说：「我是你仆人伯利恒人耶西的儿子。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S118_1","010_18_1","1SA","18","1","1","大卫对扫罗说完了话，约拿单的心与大卫的心深相契合。约拿单爱大卫，如同爱自己的性命。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S118_2","010_18_2","1SA","18","2","2","那日扫罗留住大卫，不容他再回父家。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S118_3","010_18_3","1SA","18","3","3","约拿单爱大卫如同爱自己的性命，就与他结盟。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S118_4","010_18_4","1SA","18","4","4","约拿单从身上脱下外袍，给了大卫，又将战衣、刀、弓、腰带都给了他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S118_5","010_18_5","1SA","18","5","5","扫罗无论差遣大卫往何处去，他都做事精明。扫罗就立他作战士长，众百姓和扫罗的臣仆无不喜悦。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S118_6","010_18_6","1SA","18","6","6","大卫打死了那非利士人，同众人回来的时候，妇女们从以色列各城里出来，欢欢喜喜，打鼓击磬，歌唱跳舞，迎接扫罗王。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S118_7","010_18_7","1SA","18","7","7","众妇女舞蹈唱和，说：「扫罗杀死千千，大卫杀死万万。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S118_8","010_18_8","1SA","18","8","8","扫罗甚发怒，不喜悦这话，就说：「将万万归大卫，千千归我，只剩下王位没有给他了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S118_9","010_18_9","1SA","18","9","9","从这日起，扫罗就怒视大卫。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S118_10","010_18_10","1SA","18","10","10","次日，从　神那里来的恶魔大大降在扫罗身上，他就在家中胡言乱语。大卫照常弹琴，扫罗手里拿着枪。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S118_11","010_18_11","1SA","18","11","11","扫罗把枪一抡，心里说，我要将大卫刺透，钉在墙上。大卫躲避他两次。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S118_12","010_18_12","1SA","18","12","12","扫罗惧怕大卫；因为耶和华离开自己，与大卫同在。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S118_13","010_18_13","1SA","18","13","13","所以扫罗使大卫离开自己，立他为千夫长，他就领兵出入。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S118_14","010_18_14","1SA","18","14","14","大卫做事无不精明，耶和华也与他同在。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S118_15","010_18_15","1SA","18","15","15","扫罗见大卫做事精明，就甚怕他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S118_16","010_18_16","1SA","18","16","16","但以色列和犹大众人都爱大卫，因为他领他们出入。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S118_17","010_18_17","1SA","18","17","17","扫罗对大卫说：「我将大女儿米拉给你为妻，只要你为我奋勇，为耶和华争战。」扫罗心里说：「我不好亲手害他，要借非利士人的手害他。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S118_18","010_18_18","1SA","18","18","18","大卫对扫罗说：「我是谁，我是什么出身，我父家在以色列中是何等的家，岂敢作王的女婿呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S118_19","010_18_19","1SA","18","19","19","扫罗的女儿米拉到了当给大卫的时候，扫罗却给了米何拉人亚得列为妻。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S118_20","010_18_20","1SA","18","20","20","扫罗的次女米甲爱大卫。有人告诉扫罗，扫罗就喜悦。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S118_21","010_18_21","1SA","18","21","21","扫罗心里说：「我将这女儿给大卫，作他的网罗，好借非利士人的手害他。」所以扫罗对大卫说：「你今日可以第二次作我的女婿。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S118_22","010_18_22","1SA","18","22","22","扫罗吩咐臣仆说：「你们暗中对大卫说：『王喜悦你，王的臣仆也都喜爱你，所以你当作王的女婿。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S118_23","010_18_23","1SA","18","23","23","扫罗的臣仆就照这话说给大卫听。大卫说：「你们以为作王的女婿是一件小事吗？我是贫穷卑微的人。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S118_24","010_18_24","1SA","18","24","24","扫罗的臣仆回奏说，大卫所说的如此如此。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S118_25","010_18_25","1SA","18","25","25","扫罗说：「你们要对大卫这样说：『王不要什么聘礼，只要一百非利士人的阳皮，好在王的仇敌身上报仇。』」扫罗的意思要使大卫丧在非利士人的手里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S118_26","010_18_26","1SA","18","26","26","扫罗的臣仆将这话告诉大卫，大卫就欢喜作王的女婿。日期还没有到， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S118_27","010_18_27","1SA","18","27","27","大卫和跟随他的人起身前往，杀了二百非利士人，将阳皮满数交给王，为要作王的女婿。于是扫罗将女儿米甲给大卫为妻。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S118_28","010_18_28","1SA","18","28","28","扫罗见耶和华与大卫同在，又知道女儿米甲爱大卫， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S118_29","010_18_29","1SA","18","29","29","就更怕大卫，常作大卫的仇敌。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S118_30","010_18_30","1SA","18","30","30","每逢非利士军长出来打仗，大卫比扫罗的臣仆做事精明，因此他的名被人尊重。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S119_1","010_19_1","1SA","19","1","1","扫罗对他儿子约拿单和众臣仆说，要杀大卫；扫罗的儿子约拿单却甚喜爱大卫。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S119_2","010_19_2","1SA","19","2","2","约拿单告诉大卫说：「我父扫罗想要杀你，所以明日早晨你要小心，到一个僻静地方藏身。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S119_3","010_19_3","1SA","19","3","3","我就出到你所藏的田里，站在我父亲旁边与他谈论。我看他情形怎样，我必告诉你。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S119_4","010_19_4","1SA","19","4","4","约拿单向他父亲扫罗替大卫说好话，说：「王不可得罪王的仆人大卫；因为他未曾得罪你，他所行的都与你大有益处。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S119_5","010_19_5","1SA","19","5","5","他拚命杀那非利士人，耶和华为以色列众人大行拯救；那时你看见，甚是欢喜，现在为何无故要杀大卫，流无辜人的血，自己取罪呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S119_6","010_19_6","1SA","19","6","6","扫罗听了约拿单的话，就指着永生的耶和华起誓说：「我必不杀他。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S119_7","010_19_7","1SA","19","7","7","约拿单叫大卫来，把这一切事告诉他，带他去见扫罗。他就仍然侍立在扫罗面前。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S119_8","010_19_8","1SA","19","8","8","此后又有争战的事。大卫出去与非利士人打仗，大大杀败他们，他们就在他面前逃跑。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S119_9","010_19_9","1SA","19","9","9","从耶和华那里来的恶魔又降在扫罗身上（扫罗手里拿枪坐在屋里），大卫就用手弹琴。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S119_10","010_19_10","1SA","19","10","10","扫罗用枪想要刺透大卫，钉在墙上，他却躲开，扫罗的枪刺入墙内。当夜大卫逃走，躲避了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S119_11","010_19_11","1SA","19","11","11","扫罗打发人到大卫的房屋那里窥探他，要等到天亮杀他。大卫的妻米甲对他说：「你今夜若不逃命，明日你要被杀。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S119_12","010_19_12","1SA","19","12","12","于是米甲将大卫从窗户里缒下去，大卫就逃走，躲避了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S119_13","010_19_13","1SA","19","13","13","米甲把家中的神像放在床上，头枕在山羊毛装的枕头上，用被遮盖。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S119_14","010_19_14","1SA","19","14","14","扫罗打发人去捉拿大卫，米甲说：「他病了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S119_15","010_19_15","1SA","19","15","15","扫罗又打发人去看大卫，说：「当连床将他抬来，我好杀他。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S119_16","010_19_16","1SA","19","16","16","使者进去，看见床上有神像，头枕在山羊毛装的枕头上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S119_17","010_19_17","1SA","19","17","17","扫罗对米甲说：「你为什么这样欺哄我，放我仇敌逃走呢？」米甲回答说：「他对我说：『你放我走，不然我要杀你。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S119_18","010_19_18","1SA","19","18","18","大卫逃避，来到拉玛见撒母耳，将扫罗向他所行的事述说了一遍。他和撒母耳就往拿约去居住。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S119_19","010_19_19","1SA","19","19","19","有人告诉扫罗，说大卫在拉玛的拿约。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S119_20","010_19_20","1SA","19","20","20","扫罗打发人去捉拿大卫。去的人见有一班先知都受感说话，撒母耳站在其中监管他们；打发去的人也受　神的灵感动说话。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S119_21","010_19_21","1SA","19","21","21","有人将这事告诉扫罗，他又打发人去，他们也受感说话。扫罗第三次打发人去，他们也受感说话。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S119_22","010_19_22","1SA","19","22","22","然后扫罗自己往拉玛去，到了西沽的大井，问人说：「撒母耳和大卫在哪里呢？」有人说：「在拉玛的拿约。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S119_23","010_19_23","1SA","19","23","23","他就往拉玛的拿约去。　神的灵也感动他，一面走一面说话，直到拉玛的拿约。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S119_24","010_19_24","1SA","19","24","24","他就脱了衣服，在撒母耳面前受感说话，一昼一夜露体躺卧。因此有句俗语说：「扫罗也列在先知中吗？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S120_1","010_20_1","1SA","20","1","1","大卫从拉玛的拿约逃跑，来到约拿单那里，对他说：「我做了什么？有什么罪孽呢？在你父亲面前犯了什么罪，他竟寻索我的性命呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S120_2","010_20_2","1SA","20","2","2","约拿单回答说：「断然不是！你必不致死。我父做事，无论大小，没有不叫我知道的。怎么独有这事隐瞒我呢？决不如此。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S120_3","010_20_3","1SA","20","3","3","大卫又起誓说：「你父亲准知我在你眼前蒙恩。他心里说，不如不叫约拿单知道，恐怕他愁烦。我指着永生的耶和华，又敢在你面前起誓，我离死不过一步。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S120_4","010_20_4","1SA","20","4","4","约拿单对大卫说：「你心里所求的，我必为你成就。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S120_5","010_20_5","1SA","20","5","5","大卫对约拿单说：「明日是初一，我当与王同席，求你容我去藏在田野，直到第三日晚上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S120_6","010_20_6","1SA","20","6","6","你父亲若见我不在席上，你就说：『大卫切求我许他回本城伯利恒去，因为他全家在那里献年祭。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S120_7","010_20_7","1SA","20","7","7","你父亲若说好，仆人就平安了；他若发怒，你就知道他决意要害我。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S120_8","010_20_8","1SA","20","8","8","求你施恩与仆人，因你在耶和华面前曾与仆人结盟。我若有罪，不如你自己杀我，何必将我交给你父亲呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S120_9","010_20_9","1SA","20","9","9","约拿单说：「断无此事！我若知道我父亲决意害你，我岂不告诉你呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S120_10","010_20_10","1SA","20","10","10","大卫对约拿单说：「你父亲若用厉言回答你，谁来告诉我呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S120_11","010_20_11","1SA","20","11","11","约拿单对大卫说：「你我且往田野去。」二人就往田野去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S120_12","010_20_12","1SA","20","12","12","约拿单对大卫说：「愿耶和华—以色列的　神为证。明日约在这时候，或第三日，我探我父亲的意思，若向你有好意，我岂不打发人告诉你吗？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("S120_13","010_20_13","1SA","20","13","13","我父亲若有意害你，我不告诉你使你平平安安地走，愿耶和华重重地降罚与我。愿耶和华与你同在，如同从前与我父亲同在一样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S120_14","010_20_14","1SA","20","14","14","你要照耶和华的慈爱恩待我，不但我活着的时候免我死亡， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S120_15","010_20_15","1SA","20","15","15","就是我死后，耶和华从地上剪除你仇敌的时候，你也永不可向我家绝了恩惠。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S120_16","010_20_16","1SA","20","16","16","于是约拿单与大卫家结盟，说：「愿耶和华借大卫的仇敌追讨背约的罪。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S120_17","010_20_17","1SA","20","17","17","约拿单因爱大卫如同爱自己的性命，就使他再起誓。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S120_18","010_20_18","1SA","20","18","18","约拿单对他说：「明日是初一，你的座位空设，人必理会你不在那里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S120_19","010_20_19","1SA","20","19","19","你等三日，就要速速下去，到你从前遇事所藏的地方，在以色磐石那里等候。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S120_20","010_20_20","1SA","20","20","20","我要向磐石旁边射三箭，如同射箭靶一样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S120_21","010_20_21","1SA","20","21","21","我要打发童子，说：『去把箭找来。』我若对童子说：『箭在后头，把箭拿来』，你就可以回来；我指着永生的耶和华起誓，你必平安无事。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S120_22","010_20_22","1SA","20","22","22","我若对童子说：『箭在前头』，你就要去，因为是耶和华打发你去的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S120_23","010_20_23","1SA","20","23","23","至于你我今日所说的话，有耶和华在你我中间为证，直到永远。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S120_24","010_20_24","1SA","20","24","24","大卫就去藏在田野。到了初一日，王坐席要吃饭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S120_25","010_20_25","1SA","20","25","25","王照常坐在靠墙的位上，约拿单侍立，押尼珥坐在扫罗旁边，大卫的座位空设。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S120_26","010_20_26","1SA","20","26","26","然而这日扫罗没有说什么，他想大卫遇事，偶染不洁，他必定是不洁。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S120_27","010_20_27","1SA","20","27","27","初二日大卫的座位还空设。扫罗问他儿子约拿单说：「耶西的儿子为何昨日、今日没有来吃饭呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S120_28","010_20_28","1SA","20","28","28","约拿单回答扫罗说：「大卫切求我容他往伯利恒去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S120_29","010_20_29","1SA","20","29","29","他说：『求你容我去，因为我家在城里有献祭的事；我长兄吩咐我去。如今我若在你眼前蒙恩，求你容我去见我的弟兄』；所以大卫没有赴王的席。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S120_30","010_20_30","1SA","20","30","30","扫罗向约拿单发怒，对他说：「你这顽梗背逆之妇人所生的，我岂不知道你喜悦耶西的儿子，自取羞辱，以致你母亲露体蒙羞吗？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("S120_31","010_20_31","1SA","20","31","31","耶西的儿子若在世间活着，你和你的国位必站立不住。现在你要打发人去，将他捉拿交给我；他是该死的。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S120_32","010_20_32","1SA","20","32","32","约拿单对父亲扫罗说：「他为什么该死呢？他做了什么呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S120_33","010_20_33","1SA","20","33","33","扫罗向约拿单抡枪要刺他，约拿单就知道他父亲决意要杀大卫。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S120_34","010_20_34","1SA","20","34","34","于是约拿单气忿忿地从席上起来，在这初二日没有吃饭。他因见父亲羞辱大卫，就为大卫愁烦。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S120_35","010_20_35","1SA","20","35","35","次日早晨，约拿单按着与大卫约会的时候出到田野，有一个童子跟随。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S120_36","010_20_36","1SA","20","36","36","约拿单对童子说：「你跑去，把我所射的箭找来。」童子跑去，约拿单就把箭射在童子前头。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S120_37","010_20_37","1SA","20","37","37","童子到了约拿单落箭之地，约拿单呼叫童子说：「箭不是在你前头吗？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S120_38","010_20_38","1SA","20","38","38","约拿单又呼叫童子说：「速速地去，不要迟延！」童子就拾起箭来，回到主人那里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S120_39","010_20_39","1SA","20","39","39","童子却不知道这是什么意思，只有约拿单和大卫知道。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S120_40","010_20_40","1SA","20","40","40","约拿单将弓箭交给童子，吩咐说：「你拿到城里去。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S120_41","010_20_41","1SA","20","41","41","童子一去，大卫就从磐石的南边出来，俯伏在地，拜了三拜；二人亲嘴，彼此哭泣，大卫哭得更恸。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S120_42","010_20_42","1SA","20","42","42","约拿单对大卫说：「我们二人曾指着耶和华的名起誓说：『愿耶和华在你我中间，并你我后裔中间为证，直到永远。』如今你平平安安地去吧！」大卫就起身走了；约拿单也回城里去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S121_1","010_21_1","1SA","21","1","1","大卫到了挪伯祭司亚希米勒那里，亚希米勒战战兢兢地出来迎接他，问他说：「你为什么独自来，没有人跟随呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S121_2","010_21_2","1SA","21","2","2","大卫回答祭司亚希米勒说：「王吩咐我一件事说：『我差遣你委托你的这件事，不要使人知道。』故此我已派定少年人在某处等候我。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S121_3","010_21_3","1SA","21","3","3","现在你手下有什么？求你给我五个饼或是别样的食物。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S121_4","010_21_4","1SA","21","4","4","祭司对大卫说：「我手下没有寻常的饼，只有圣饼；若少年人没有亲近妇人才可以给。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S121_5","010_21_5","1SA","21","5","5","大卫对祭司说：「实在约有三日我们没有亲近妇人；我出来的时候，虽是寻常行路，少年人的器皿还是洁净的；何况今日不更是洁净吗？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S121_6","010_21_6","1SA","21","6","6","祭司就拿圣饼给他；因为在那里没有别样饼，只有更换新饼，从耶和华面前撤下来的陈设饼。 （ ");
INSERT INTO cmn_cu89s_vpl VALUES ("S121_7","010_21_7","1SA","21","7","7","当日有扫罗的一个臣子留在耶和华面前。他名叫多益，是以东人，作扫罗的司牧长。） ");
INSERT INTO cmn_cu89s_vpl VALUES ("S121_8","010_21_8","1SA","21","8","8","大卫问亚希米勒说：「你手下有枪有刀没有？因为王的事甚急，连刀剑器械我都没有带。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S121_9","010_21_9","1SA","21","9","9","祭司说：「你在以拉谷杀非利士人歌利亚的那刀在这里，裹在布中，放在以弗得后边，你要就可以拿去；除此以外，再没有别的。」大卫说：「这刀没有可比的！求你给我。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S121_10","010_21_10","1SA","21","10","10","那日大卫起来，躲避扫罗，逃到迦特王亚吉那里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S121_11","010_21_11","1SA","21","11","11","亚吉的臣仆对亚吉说：「这不是以色列国王大卫吗？那里的妇女跳舞唱和，不是指着他说『扫罗杀死千千，大卫杀死万万』吗？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S121_12","010_21_12","1SA","21","12","12","大卫将这话放在心里，甚惧怕迦特王亚吉， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S121_13","010_21_13","1SA","21","13","13","就在众人面前改变了寻常的举动，在他们手下假装疯癫，在城门的门扇上胡写乱画，使唾沫流在胡子上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S121_14","010_21_14","1SA","21","14","14","亚吉对臣仆说：「你们看，这人是疯子。为什么带他到我这里来呢？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("S121_15","010_21_15","1SA","21","15","15","我岂缺少疯子，你们带这人来在我面前疯癫吗？这人岂可进我的家呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S122_1","010_22_1","1SA","22","1","1","大卫就离开那里，逃到亚杜兰洞。他的弟兄和他父亲的全家听见了，就都下到他那里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S122_2","010_22_2","1SA","22","2","2","凡受窘迫的、欠债的、心里苦恼的都聚集到大卫那里；大卫就作他们的头目，跟随他的约有四百人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S122_3","010_22_3","1SA","22","3","3","大卫从那里往摩押的米斯巴去，对摩押王说：「求你容我父母搬来，住在你们这里，等我知道　神要为我怎样行。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S122_4","010_22_4","1SA","22","4","4","大卫领他父母到摩押王面前。大卫住山寨多少日子，他父母也住摩押王那里多少日子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S122_5","010_22_5","1SA","22","5","5","先知迦得对大卫说：「你不要住在山寨，要往犹大地去。」大卫就离开那里，进入哈列的树林。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S122_6","010_22_6","1SA","22","6","6","扫罗在基比亚的拉玛，坐在垂丝柳树下，手里拿着枪，众臣仆侍立在左右。扫罗听见大卫和跟随他的人在何处， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S122_7","010_22_7","1SA","22","7","7","就对左右侍立的臣仆说：「便雅悯人哪，你们要听我的话！耶西的儿子能将田地和葡萄园赐给你们各人吗？能立你们各人作千夫长百夫长吗？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("S122_8","010_22_8","1SA","22","8","8","你们竟都结党害我！我的儿子与耶西的儿子结盟的时候，无人告诉我；我的儿子挑唆我的臣子谋害我，就如今日的光景，也无人告诉我，为我忧虑。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S122_9","010_22_9","1SA","22","9","9","那时以东人多益站在扫罗的臣仆中，对他说：「我曾看见耶西的儿子到了挪伯，亚希突的儿子亚希米勒那里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S122_10","010_22_10","1SA","22","10","10","亚希米勒为他求问耶和华，又给他食物，并给他杀非利士人歌利亚的刀。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S122_11","010_22_11","1SA","22","11","11","王就打发人将祭司亚希突的儿子亚希米勒和他父亲的全家，就是住挪伯的祭司都召了来；他们就来见王。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S122_12","010_22_12","1SA","22","12","12","扫罗说：「亚希突的儿子，要听我的话！」他回答说：「主啊，我在这里。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S122_13","010_22_13","1SA","22","13","13","扫罗对他说：「你为什么与耶西的儿子结党害我，将食物和刀给他，又为他求问　神，使他起来谋害我，就如今日的光景？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S122_14","010_22_14","1SA","22","14","14","亚希米勒回答王说：「王的臣仆中有谁比大卫忠心呢？他是王的女婿，又是王的参谋，并且在王家中是尊贵的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S122_15","010_22_15","1SA","22","15","15","我岂是从今日才为他求问　神呢？断不是这样！王不要将罪归我和我父的全家；因为这事，无论大小，仆人都不知道。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S122_16","010_22_16","1SA","22","16","16","王说：「亚希米勒啊，你和你父的全家都是该死的！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S122_17","010_22_17","1SA","22","17","17","王就吩咐左右的侍卫说：「你们去杀耶和华的祭司；因为他们帮助大卫，又知道大卫逃跑，竟没有告诉我。」扫罗的臣子却不肯伸手杀耶和华的祭司。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S122_18","010_22_18","1SA","22","18","18","王吩咐多益说：「你去杀祭司吧！」以东人多益就去杀祭司，那日杀了穿细麻布以弗得的八十五人； ");
INSERT INTO cmn_cu89s_vpl VALUES ("S122_19","010_22_19","1SA","22","19","19","又用刀将祭司城挪伯中的男女、孩童、吃奶的，和牛、羊、驴尽都杀灭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S122_20","010_22_20","1SA","22","20","20","亚希突的儿子亚希米勒有一个儿子，名叫亚比亚他，逃到大卫那里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S122_21","010_22_21","1SA","22","21","21","亚比亚他将扫罗杀耶和华祭司的事告诉大卫。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S122_22","010_22_22","1SA","22","22","22","大卫对亚比亚他说：「那日我见以东人多益在那里，就知道他必告诉扫罗。你父的全家丧命，都是因我的缘故。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S122_23","010_22_23","1SA","22","23","23","你可以住在我这里，不要惧怕。因为寻索你命的就是寻索我的命；你在我这里可得保全。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S123_1","010_23_1","1SA","23","1","1","有人告诉大卫说：「非利士人攻击基伊拉，抢夺禾场。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S123_2","010_23_2","1SA","23","2","2","所以大卫求问耶和华说：「我去攻打那些非利士人可以不可以？」耶和华对大卫说：「你可以去攻打非利士人，拯救基伊拉。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S123_3","010_23_3","1SA","23","3","3","跟随大卫的人对他说：「我们在犹大地这里尚且惧怕，何况往基伊拉去攻打非利士人的军旅呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S123_4","010_23_4","1SA","23","4","4","大卫又求问耶和华。耶和华回答说：「你起身下基伊拉去，我必将非利士人交在你手里。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S123_5","010_23_5","1SA","23","5","5","大卫和跟随他的人往基伊拉去，与非利士人打仗，大大杀败他们，又夺获他们的牲畜。这样，大卫救了基伊拉的居民。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S123_6","010_23_6","1SA","23","6","6","亚希米勒的儿子亚比亚他逃到基伊拉见大卫的时候，手里拿着以弗得。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S123_7","010_23_7","1SA","23","7","7","有人告诉扫罗说：「大卫到了基伊拉。」扫罗说：「他进了有门有闩的城，困闭在里头；这是　神将他交在我手里了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S123_8","010_23_8","1SA","23","8","8","于是扫罗招聚众民，要下去攻打基伊拉城，围困大卫和跟随他的人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S123_9","010_23_9","1SA","23","9","9","大卫知道扫罗设计谋害他，就对祭司亚比亚他说：「将以弗得拿过来。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S123_10","010_23_10","1SA","23","10","10","大卫祷告说：「耶和华—以色列的　神啊，你仆人听真了扫罗要往基伊拉来，为我的缘故灭城。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S123_11","010_23_11","1SA","23","11","11","基伊拉人将我交在扫罗手里不交？扫罗照着你仆人所听的话下来不下来？耶和华—以色列的　神啊，求你指示仆人！」耶和华说：「扫罗必下来。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S123_12","010_23_12","1SA","23","12","12","大卫又说：「基伊拉人将我和跟随我的人交在扫罗手里不交？」耶和华说：「必交出来。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S123_13","010_23_13","1SA","23","13","13","大卫和跟随他的约有六百人，就起身出了基伊拉，往他们所能往的地方去。有人告诉扫罗，大卫离开基伊拉逃走；于是扫罗不出来了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S123_14","010_23_14","1SA","23","14","14","大卫住在旷野的山寨里，常在西弗旷野的山地。扫罗天天寻索大卫，　神却不将大卫交在他手里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S123_15","010_23_15","1SA","23","15","15","大卫知道扫罗出来寻索他的命。那时，他住在西弗旷野的树林里； ");
INSERT INTO cmn_cu89s_vpl VALUES ("S123_16","010_23_16","1SA","23","16","16","扫罗的儿子约拿单起身，往那树林里去见大卫，使他倚靠　神得以坚固， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S123_17","010_23_17","1SA","23","17","17","对他说：「不要惧怕！我父扫罗的手必不加害于你；你必作以色列的王，我也作你的宰相。这事我父扫罗知道了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S123_18","010_23_18","1SA","23","18","18","于是二人在耶和华面前立约。大卫仍住在树林里，约拿单回家去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S123_19","010_23_19","1SA","23","19","19","西弗人上到基比亚见扫罗，说：「大卫不是在我们那里的树林里山寨中、旷野南边的哈基拉山藏着吗？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("S123_20","010_23_20","1SA","23","20","20","王啊，请你随你的心愿下来，我们必亲自将他交在王的手里。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S123_21","010_23_21","1SA","23","21","21","扫罗说：「愿耶和华赐福与你们，因你们顾恤我。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S123_22","010_23_22","1SA","23","22","22","请你们回去，再确实查明他的住处和行踪，是谁看见他在那里，因为我听见人说他甚狡猾。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S123_23","010_23_23","1SA","23","23","23","所以要看准他藏匿的地方，回来据实地告诉我，我就与你们同去。他若在犹大的境内，我必从千门万户中搜出他来。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S123_24","010_23_24","1SA","23","24","24","西弗人就起身，在扫罗以先往西弗去。 大卫和跟随他的人却在玛云旷野南边的亚拉巴。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S123_25","010_23_25","1SA","23","25","25","扫罗和跟随他的人去寻找大卫；有人告诉大卫，他就下到磐石，住在玛云的旷野。扫罗听见，便在玛云的旷野追赶大卫。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S123_26","010_23_26","1SA","23","26","26","扫罗在山这边走，大卫和跟随他的人在山那边走。大卫急忙躲避扫罗；因为扫罗和跟随他的人，四面围住大卫和跟随他的人，要拿获他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S123_27","010_23_27","1SA","23","27","27","忽有使者来报告扫罗说：「非利士人犯境抢掠，请王快快回去！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S123_28","010_23_28","1SA","23","28","28","于是扫罗不追赶大卫，回去攻打非利士人。因此那地方名叫西拉·哈玛希罗结。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S123_29","010_23_29","1SA","23","29","29","大卫从那里上去，住在隐·基底的山寨里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S124_1","010_24_1","1SA","24","1","1","扫罗追赶非利士人回来，有人告诉他说：「大卫在隐·基底的旷野。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S124_2","010_24_2","1SA","24","2","2","扫罗就从以色列人中挑选三千精兵，率领他们往野羊的磐石去，寻索大卫和跟随他的人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S124_3","010_24_3","1SA","24","3","3","到了路旁的羊圈，在那里有洞，扫罗进去大解。大卫和跟随他的人正藏在洞里的深处。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S124_4","010_24_4","1SA","24","4","4","跟随的人对大卫说：「耶和华曾应许你说：『我要将你的仇敌交在你手里，你可以任意待他。』如今时候到了！」大卫就起来，悄悄地割下扫罗外袍的衣襟。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S124_5","010_24_5","1SA","24","5","5","随后大卫心中自责，因为割下扫罗的衣襟； ");
INSERT INTO cmn_cu89s_vpl VALUES ("S124_6","010_24_6","1SA","24","6","6","对跟随他的人说：「我的主乃是耶和华的受膏者，我在耶和华面前万不敢伸手害他，因他是耶和华的受膏者。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S124_7","010_24_7","1SA","24","7","7","大卫用这话拦住跟随他的人，不容他们起来害扫罗。扫罗起来，从洞里出去行路。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S124_8","010_24_8","1SA","24","8","8","随后大卫也起来，从洞里出去，呼叫扫罗说：「我主，我王！」扫罗回头观看，大卫就屈身、脸伏于地下拜。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S124_9","010_24_9","1SA","24","9","9","大卫对扫罗说：「你为何听信人的谗言，说大卫想要害你呢？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("S124_10","010_24_10","1SA","24","10","10","今日你亲眼看见在洞中，耶和华将你交在我手里；有人叫我杀你，我却爱惜你，说：『我不敢伸手害我的主，因为他是耶和华的受膏者。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S124_11","010_24_11","1SA","24","11","11","我父啊，看看你外袍的衣襟在我手中。我割下你的衣襟，没有杀你；你由此可以知道我没有恶意叛逆你。你虽然猎取我的命，我却没有得罪你。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S124_12","010_24_12","1SA","24","12","12","愿耶和华在你我中间判断是非，在你身上为我伸冤，我却不亲手加害于你。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S124_13","010_24_13","1SA","24","13","13","古人有句俗语说：『恶事出于恶人。』我却不亲手加害于你。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S124_14","010_24_14","1SA","24","14","14","以色列王出来要寻找谁呢？追赶谁呢？不过追赶一条死狗，一个虼蚤就是了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S124_15","010_24_15","1SA","24","15","15","愿耶和华在你我中间施行审判，断定是非，并且鉴察，为我伸冤，救我脱离你的手。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S124_16","010_24_16","1SA","24","16","16","大卫向扫罗说完这话，扫罗说：「我儿大卫，这是你的声音吗？」就放声大哭， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S124_17","010_24_17","1SA","24","17","17","对大卫说：「你比我公义；因为你以善待我，我却以恶待你。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S124_18","010_24_18","1SA","24","18","18","你今日显明是以善待我；因为耶和华将我交在你手里，你却没有杀我。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S124_19","010_24_19","1SA","24","19","19","人若遇见仇敌，岂肯放他平安无事地去呢？愿耶和华因你今日向我所行的，以善报你。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S124_20","010_24_20","1SA","24","20","20","我也知道你必要作王，以色列的国必坚立在你手里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S124_21","010_24_21","1SA","24","21","21","现在你要指着耶和华向我起誓，不剪除我的后裔，在我父家不灭没我的名。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S124_22","010_24_22","1SA","24","22","22","于是大卫向扫罗起誓，扫罗就回家去；大卫和跟随他的人上山寨去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S125_1","010_25_1","1SA","25","1","1","撒母耳死了，以色列众人聚集，为他哀哭，将他葬在拉玛—他自己的坟墓里。 大卫起身，下到巴兰的旷野。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S125_2","010_25_2","1SA","25","2","2","在玛云有一个人，他的产业在迦密，是一个大富户，有三千绵羊，一千山羊；他正在迦密剪羊毛。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S125_3","010_25_3","1SA","25","3","3","那人名叫拿八，是迦勒族的人；他的妻名叫亚比该，是聪明俊美的妇人。拿八为人刚愎凶恶。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S125_4","010_25_4","1SA","25","4","4","大卫在旷野听见说拿八剪羊毛， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S125_5","010_25_5","1SA","25","5","5","大卫就打发十个仆人，吩咐他们说：「你们上迦密去见拿八，提我的名问他安。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S125_6","010_25_6","1SA","25","6","6","要对那富户如此说：『愿你平安，愿你家平安，愿你一切所有的都平安。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S125_7","010_25_7","1SA","25","7","7","现在我听说有人为你剪羊毛，你的牧人在迦密的时候和我们在一处，我们没有欺负他们，他们也未曾失落什么。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S125_8","010_25_8","1SA","25","8","8","可以问你的仆人，他们必告诉你。所以愿我的仆人在你眼前蒙恩，因为是在好日子来的。求你随手取点赐与仆人和你儿子大卫。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S125_9","010_25_9","1SA","25","9","9","大卫的仆人到了，将这话提大卫的名都告诉了拿八，就住了口。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S125_10","010_25_10","1SA","25","10","10","拿八回答大卫的仆人说：「大卫是谁？耶西的儿子是谁？近来悖逆主人奔逃的仆人甚多， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S125_11","010_25_11","1SA","25","11","11","我岂可将饮食和为我剪羊毛人所宰的肉给我不知道从哪里来的人呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S125_12","010_25_12","1SA","25","12","12","大卫的仆人就转身从原路回去，照这话告诉大卫。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S125_13","010_25_13","1SA","25","13","13","大卫向跟随他的人说：「你们各人都要带上刀！」众人就都带上刀，大卫也带上刀。跟随大卫上去的约有四百人，留下二百人看守器具。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S125_14","010_25_14","1SA","25","14","14","有拿八的一个仆人告诉拿八的妻亚比该说：「大卫从旷野打发使者来问我主人的安，主人却辱骂他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S125_15","010_25_15","1SA","25","15","15","但是那些人待我们甚好；我们在田野与他们来往的时候，没有受他们的欺负，也未曾失落什么。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S125_16","010_25_16","1SA","25","16","16","我们在他们那里牧羊的时候，他们昼夜作我们的保障。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S125_17","010_25_17","1SA","25","17","17","所以你当筹划，看怎样行才好；不然，祸患定要临到我主人和他全家。他性情凶暴，无人敢与他说话。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S125_18","010_25_18","1SA","25","18","18","亚比该急忙将二百饼，两皮袋酒，五只收拾好了的羊，五细亚烘好了的穗子，一百葡萄饼，二百无花果饼，都驮在驴上， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S125_19","010_25_19","1SA","25","19","19","对仆人说：「你们前头走，我随着你们去。」这事她却没有告诉丈夫拿八。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S125_20","010_25_20","1SA","25","20","20","亚比该骑着驴，正下山坡，见大卫和跟随他的人从对面下来，亚比该就迎接他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S125_21","010_25_21","1SA","25","21","21","大卫曾说：「我在旷野为那人看守所有的，以致他一样不失落，实在是徒然了！他向我以恶报善。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S125_22","010_25_22","1SA","25","22","22","凡属拿八的男丁，我若留一个到明日早晨，愿　神重重降罚与我！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S125_23","010_25_23","1SA","25","23","23","亚比该见大卫，便急忙下驴，在大卫面前脸伏于地叩拜， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S125_24","010_25_24","1SA","25","24","24","俯伏在大卫的脚前，说：「我主啊，愿这罪归我！求你容婢女向你进言，更求你听婢女的话。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S125_25","010_25_25","1SA","25","25","25","我主不要理这坏人拿八，他的性情与他的名相称；他名叫拿八，他为人果然愚顽。但我主所打发的仆人，婢女并没有看见。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S125_26","010_25_26","1SA","25","26","26","我主啊，耶和华既然阻止你亲手报仇，取流血的罪，所以我指着永生的耶和华、又敢在你面前起誓说：『愿你的仇敌和谋害你的人都像拿八一样。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S125_27","010_25_27","1SA","25","27","27","如今求你将婢女送来的礼物给跟随你的仆人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S125_28","010_25_28","1SA","25","28","28","求你饶恕婢女的罪过。耶和华必为我主建立坚固的家，因我主为耶和华争战；并且在你平生的日子查不出有什么过来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S125_29","010_25_29","1SA","25","29","29","虽有人起来追逼你，寻索你的性命，你的性命却在耶和华—你的　神那里蒙保护，如包裹宝器一样；你仇敌的性命，耶和华必抛去，如用机弦甩石一样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S125_30","010_25_30","1SA","25","30","31","我主现在若不亲手报仇流无辜人的血，到了耶和华照所应许你的话赐福与你，立你作以色列的王，那时我主必不至心里不安，觉得良心有亏。耶和华赐福与我主的时候，求你记念婢女。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S125_32","010_25_32","1SA","25","32","32","大卫对亚比该说：「耶和华—以色列的　神是应当称颂的，因为他今日使你来迎接我。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S125_33","010_25_33","1SA","25","33","33","你和你的见识也当称赞；因为你今日拦阻我亲手报仇、流人的血。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S125_34","010_25_34","1SA","25","34","34","我指着阻止我加害于你的耶和华—以色列永生的　神起誓，你若不速速地来迎接我，到明日早晨，凡属拿八的男丁必定不留一个。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S125_35","010_25_35","1SA","25","35","35","大卫受了亚比该送来的礼物，就对她说：「我听了你的话，准了你的情面，你可以平平安安地回家吧！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S125_36","010_25_36","1SA","25","36","36","亚比该到拿八那里，见他在家里设摆筵席，如同王的筵席；拿八快乐大醉。亚比该无论大小事都没有告诉他，就等到次日早晨。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S125_37","010_25_37","1SA","25","37","37","到了早晨，拿八醒了酒，他的妻将这些事都告诉他，他就魂不附体，身僵如石头一般。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S125_38","010_25_38","1SA","25","38","38","过了十天，耶和华击打拿八，他就死了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S125_39","010_25_39","1SA","25","39","39","大卫听见拿八死了，就说：「应当称颂耶和华，因他伸了拿八羞辱我的冤，又阻止仆人行恶；也使拿八的恶归到拿八的头上。」于是大卫打发人去，与亚比该说，要娶她为妻。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S125_40","010_25_40","1SA","25","40","40","大卫的仆人到了迦密见亚比该，对她说：「大卫打发我们来见你，想要娶你为妻。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S125_41","010_25_41","1SA","25","41","41","亚比该就起来，俯伏在地，说：「我情愿作婢女，洗我主仆人的脚。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S125_42","010_25_42","1SA","25","42","42","亚比该立刻起身，骑上驴，带着五个使女，跟从大卫的使者去了，就作了大卫的妻。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S125_43","010_25_43","1SA","25","43","43","大卫先娶了耶斯列人亚希暖，她们二人都作了他的妻。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S125_44","010_25_44","1SA","25","44","44","扫罗已将他的女儿米甲，就是大卫的妻，给了迦琳人拉亿的儿子帕提为妻。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S126_1","010_26_1","1SA","26","1","1","西弗人到基比亚见扫罗，说：「大卫不是在旷野前的哈基拉山藏着吗？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S126_2","010_26_2","1SA","26","2","2","扫罗就起身，带领以色列人中挑选的三千精兵下到西弗的旷野，要在那里寻索大卫。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S126_3","010_26_3","1SA","26","3","3","扫罗在旷野前的哈基拉山，在道路上安营。大卫住在旷野，听说扫罗到旷野来追寻他， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S126_4","010_26_4","1SA","26","4","4","就打发人去探听，便知道扫罗果然来到。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S126_5","010_26_5","1SA","26","5","5","大卫起来，到扫罗安营的地方，看见扫罗和他的元帅尼珥的儿子押尼珥睡卧之处；扫罗睡在辎重营里，百姓安营在他周围。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S126_6","010_26_6","1SA","26","6","6","大卫对赫人亚希米勒和洗鲁雅的儿子约押的兄弟亚比筛说：「谁同我下到扫罗营里去？」亚比筛说：「我同你下去。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S126_7","010_26_7","1SA","26","7","7","于是大卫和亚比筛夜间到了百姓那里，见扫罗睡在辎重营里；他的枪在头旁，插在地上。押尼珥和百姓睡在他周围。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S126_8","010_26_8","1SA","26","8","8","亚比筛对大卫说：「现在　神将你的仇敌交在你手里，求你容我拿枪将他刺透在地，一刺就成，不用再刺。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S126_9","010_26_9","1SA","26","9","9","大卫对亚比筛说：「不可害死他。有谁伸手害耶和华的受膏者而无罪呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S126_10","010_26_10","1SA","26","10","10","大卫又说：「我指着永生的耶和华起誓，他或被耶和华击打，或是死期到了，或是出战阵亡； ");
INSERT INTO cmn_cu89s_vpl VALUES ("S126_11","010_26_11","1SA","26","11","11","我在耶和华面前，万不敢伸手害耶和华的受膏者。现在你可以将他头旁的枪和水瓶拿来，我们就走。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S126_12","010_26_12","1SA","26","12","12","大卫从扫罗的头旁拿了枪和水瓶，二人就走了，没有人看见，没有人知道，也没有人醒起，都睡着了，因为耶和华使他们沉沉地睡了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S126_13","010_26_13","1SA","26","13","13","大卫过到那边去，远远地站在山顶上，与他们相离甚远。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S126_14","010_26_14","1SA","26","14","14","大卫呼叫百姓和尼珥的儿子押尼珥说：「押尼珥啊，你为何不答应呢？」押尼珥说：「你是谁？竟敢呼叫王呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S126_15","010_26_15","1SA","26","15","15","大卫对押尼珥说：「你不是个勇士吗？以色列中谁能比你呢？民中有人进来要害死王—你的主，你为何没有保护王—你的主呢？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("S126_16","010_26_16","1SA","26","16","16","你这样是不好的！我指着永生的耶和华起誓，你们都是该死的；因为没有保护你们的主，就是耶和华的受膏者。现在你看看王头旁的枪和水瓶在哪里。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S126_17","010_26_17","1SA","26","17","17","扫罗听出是大卫的声音，就说：「我儿大卫，这是你的声音吗？」大卫说：「主—我的王啊，是我的声音」； ");
INSERT INTO cmn_cu89s_vpl VALUES ("S126_18","010_26_18","1SA","26","18","18","又说：「我做了什么？我手里有什么恶事？我主竟追赶仆人呢？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("S126_19","010_26_19","1SA","26","19","19","求我主我王听仆人的话：若是耶和华激发你攻击我，愿耶和华收纳祭物；若是人激发你，愿他在耶和华面前受咒诅；因为他现今赶逐我，不容我在耶和华的产业上有分，说：『你去事奉别神吧！』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S126_20","010_26_20","1SA","26","20","20","现在求王不要使我的血流在离耶和华远的地方。以色列王出来是寻找一个虼蚤，如同人在山上猎取一个鹧鸪一般。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S126_21","010_26_21","1SA","26","21","21","扫罗说：「我有罪了！我儿大卫，你可以回来，因你今日看我的性命为宝贵；我必不再加害于你。我是糊涂人，大大错了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S126_22","010_26_22","1SA","26","22","22","大卫说：「王的枪在这里，可以吩咐一个仆人过来拿去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S126_23","010_26_23","1SA","26","23","23","今日耶和华将王交在我手里，我却不肯伸手害耶和华的受膏者。耶和华必照各人的公义诚实报应他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S126_24","010_26_24","1SA","26","24","24","我今日重看你的性命，愿耶和华也重看我的性命，并且拯救我脱离一切患难。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S126_25","010_26_25","1SA","26","25","25","扫罗对大卫说：「我儿大卫，愿你得福！你必做大事，也必得胜。」于是大卫起行，扫罗回他的本处去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S127_1","010_27_1","1SA","27","1","1","大卫心里说：「必有一日我死在扫罗手里，不如逃奔非利士地去。扫罗见我不在以色列的境内，就必绝望，不再寻索我；这样我可以脱离他的手。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S127_2","010_27_2","1SA","27","2","2","于是大卫起身，和跟随他的六百人投奔迦特王—玛俄的儿子亚吉去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S127_3","010_27_3","1SA","27","3","3","大卫和他的两个妻，就是耶斯列人亚希暖和作过拿八妻的迦密人亚比该，并跟随他的人，连各人的眷属，都住在迦特的亚吉那里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S127_4","010_27_4","1SA","27","4","4","有人告诉扫罗说：「大卫逃到迦特。」扫罗就不再寻索他了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S127_5","010_27_5","1SA","27","5","5","大卫对亚吉说：「我若在你眼前蒙恩，求你在京外的城邑中赐我一个地方居住。仆人何必与王同住京都呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S127_6","010_27_6","1SA","27","6","6","当日亚吉将洗革拉赐给他，因此洗革拉属犹大王，直到今日。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S127_7","010_27_7","1SA","27","7","7","大卫在非利士地住了一年零四个月。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S127_8","010_27_8","1SA","27","8","8","大卫和跟随他的人上去，侵夺基述人、基色人、亚玛力人之地。这几族历来住在那地，从书珥直到埃及。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S127_9","010_27_9","1SA","27","9","9","大卫击杀那地的人，无论男女都没有留下一个，又夺获牛、羊、骆驼、驴，并衣服，回来见亚吉。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S127_10","010_27_10","1SA","27","10","10","亚吉说：「你们今日侵夺了什么地方呢？」大卫说：「侵夺了犹大的南方、耶拉篾的南方、基尼的南方。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S127_11","010_27_11","1SA","27","11","11","无论男女，大卫没有留下一个带到迦特来。他说：「恐怕他们将我们的事告诉人，说大卫住在非利士地的时候常常这样行。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S127_12","010_27_12","1SA","27","12","12","亚吉信了大卫，心里说：「大卫使本族以色列人憎恶他，所以他必永远作我的仆人了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S128_1","010_28_1","1SA","28","1","1","那时，非利士人聚集军旅，要与以色列人打仗。亚吉对大卫说：「你当知道，你和跟随你的人都要随我出战。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S128_2","010_28_2","1SA","28","2","2","大卫对亚吉说：「仆人所能做的事，王必知道。」亚吉对大卫说：「这样，我立你永远作我的护卫长。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S128_3","010_28_3","1SA","28","3","3","那时撒母耳已经死了，以色列众人为他哀哭，葬他在拉玛，就是在他本城里。扫罗曾在国内不容有交鬼的和行巫术的人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S128_4","010_28_4","1SA","28","4","4","非利士人聚集，来到书念安营；扫罗聚集以色列众人在基利波安营。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S128_5","010_28_5","1SA","28","5","5","扫罗看见非利士的军旅就惧怕，心中发颤。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S128_6","010_28_6","1SA","28","6","6","扫罗求问耶和华，耶和华却不借梦，或乌陵，或先知回答他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S128_7","010_28_7","1SA","28","7","7","扫罗吩咐臣仆说：「当为我找一个交鬼的妇人，我好去问她。」臣仆说：「在隐·多珥有一个交鬼的妇人。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S128_8","010_28_8","1SA","28","8","8","于是扫罗改了装，穿上别的衣服，带着两个人，夜里去见那妇人。扫罗说：「求你用交鬼的法术，将我所告诉你的死人，为我招上来。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S128_9","010_28_9","1SA","28","9","9","妇人对他说：「你知道扫罗从国中剪除交鬼的和行巫术的。你为何陷害我的性命，使我死呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S128_10","010_28_10","1SA","28","10","10","扫罗向妇人指着耶和华起誓说：「我指着永生的耶和华起誓，你必不因这事受刑。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S128_11","010_28_11","1SA","28","11","11","妇人说：「我为你招谁上来呢？」回答说：「为我招撒母耳上来。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S128_12","010_28_12","1SA","28","12","12","妇人看见撒母耳，就大声呼叫，对扫罗说：「你是扫罗，为什么欺哄我呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S128_13","010_28_13","1SA","28","13","13","王对妇人说：「不要惧怕，你看见了什么呢？」妇人对扫罗说：「我看见有神从地里上来。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S128_14","010_28_14","1SA","28","14","14","扫罗说：「他是怎样的形状？」妇人说：「有一个老人上来，身穿长衣。」扫罗知道是撒母耳，就屈身，脸伏于地下拜。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S128_15","010_28_15","1SA","28","15","15","撒母耳对扫罗说：「你为什么搅扰我，招我上来呢？」扫罗回答说：「我甚窘急；因为非利士人攻击我，　神也离开我，不再借先知或梦回答我。因此请你上来，好指示我应当怎样行。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S128_16","010_28_16","1SA","28","16","16","撒母耳说：「耶和华已经离开你，且与你为敌，你何必问我呢？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("S128_17","010_28_17","1SA","28","17","17","耶和华照他借我说的话，已经从你手里夺去国权，赐与别人，就是大卫。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S128_18","010_28_18","1SA","28","18","18","因你没有听从耶和华的命令；他恼怒亚玛力人，你没有灭绝他们，所以今日耶和华向你这样行， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S128_19","010_28_19","1SA","28","19","19","并且耶和华必将你和以色列人交在非利士人的手里。明日你和你众子必与我在一处了；耶和华必将以色列的军兵交在非利士人手里。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S128_20","010_28_20","1SA","28","20","20","扫罗猛然仆倒，挺身在地，因撒母耳的话甚是惧怕；那一昼一夜，没有吃什么，就毫无气力。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S128_21","010_28_21","1SA","28","21","21","妇人到扫罗面前，见他极其惊恐，对他说：「婢女听从你的话，不顾惜自己的性命，遵从你所吩咐的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S128_22","010_28_22","1SA","28","22","22","现在求你听婢女的话，容我在你面前摆上一点食物，你吃了，可以有气力行路。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S128_23","010_28_23","1SA","28","23","23","扫罗不肯，说：「我不吃。」但他的仆人和妇人再三劝他，他才听了他们的话，从地上起来，坐在床上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S128_24","010_28_24","1SA","28","24","24","妇人急忙将家里的一只肥牛犊宰了，又拿面抟成无酵饼烤了， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S128_25","010_28_25","1SA","28","25","25","摆在扫罗和他仆人面前。他们吃完，当夜就起身走了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S129_1","010_29_1","1SA","29","1","1","非利士人将他们的军旅聚到亚弗；以色列人在耶斯列的泉旁安营。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S129_2","010_29_2","1SA","29","2","2","非利士人的首领各率军队，或百或千，挨次前进；大卫和跟随他的人同着亚吉跟在后边。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S129_3","010_29_3","1SA","29","3","3","非利士人的首领说：「这些希伯来人在这里做什么呢？」亚吉对他们说：「这不是以色列王扫罗的臣子大卫吗？他在我这里有些年日了。自从他投降我直到今日，我未曾见他有过错。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S129_4","010_29_4","1SA","29","4","4","非利士人的首领向亚吉发怒，对他说：「你要叫这人回你所安置他的地方，不可叫他同我们出战，恐怕他在阵上反为我们的敌人。他用什么与他主人复和呢？岂不是用我们这些人的首级吗？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("S129_5","010_29_5","1SA","29","5","5","从前以色列的妇女跳舞唱和说：『扫罗杀死千千，大卫杀死万万』，所说的不是这个大卫吗？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S129_6","010_29_6","1SA","29","6","6","亚吉叫大卫来，对他说：「我指着永生的耶和华起誓，你是正直人。你随我在军中出入，我看你甚好。自从你投奔我到如今，我未曾见你有什么过失；只是众首领不喜悦你。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S129_7","010_29_7","1SA","29","7","7","现在你可以平平安安地回去，免得非利士人的首领不欢喜你。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S129_8","010_29_8","1SA","29","8","8","大卫对亚吉说：「我做了什么呢？自从仆人到你面前，直到今日，你查出我有什么过错，使我不去攻击主—我王的仇敌呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S129_9","010_29_9","1SA","29","9","9","亚吉说：「我知道你在我眼前是好人，如同　神的使者一般；只是非利士人的首领说：『这人不可同我们出战。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S129_10","010_29_10","1SA","29","10","10","故此你和跟随你的人，就是你本主的仆人，要明日早晨起来，等到天亮回去吧！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S129_11","010_29_11","1SA","29","11","11","于是大卫和跟随他的人早晨起来，回往非利士地去。非利士人也上耶斯列去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S130_1","010_30_1","1SA","30","1","1","第三日，大卫和跟随他的人到了洗革拉。亚玛力人已经侵夺南地，攻破洗革拉，用火焚烧， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S130_2","010_30_2","1SA","30","2","2","掳了城内的妇女和其中的大小人口，却没有杀一个，都带着走了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S130_3","010_30_3","1SA","30","3","3","大卫和跟随他的人到了那城，不料，城已烧毁，他们的妻子儿女都被掳去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S130_4","010_30_4","1SA","30","4","4","大卫和跟随他的人就放声大哭，直哭得没有气力。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S130_5","010_30_5","1SA","30","5","5","大卫的两个妻—耶斯列人亚希暖和作过拿八妻的迦密人亚比该，也被掳去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S130_6","010_30_6","1SA","30","6","6","大卫甚是焦急，因众人为自己的儿女苦恼，说：「要用石头打死他。」大卫却倚靠耶和华—他的　神，心里坚固。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S130_7","010_30_7","1SA","30","7","7","大卫对亚希米勒的儿子祭司亚比亚他说：「请你将以弗得拿过来。」亚比亚他就将以弗得拿到大卫面前。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S130_8","010_30_8","1SA","30","8","8","大卫求问耶和华说：「我追赶敌军，追得上追不上呢？」耶和华说：「你可以追，必追得上，都救得回来。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S130_9","010_30_9","1SA","30","9","9","于是，大卫和跟随他的六百人来到比梭溪；有不能前去的就留在那里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S130_10","010_30_10","1SA","30","10","10","大卫却带着四百人往前追赶，有二百人疲乏，不能过比梭溪，所以留在那里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S130_11","010_30_11","1SA","30","11","11","这四百人在田野遇见一个埃及人，就带他到大卫面前，给他饼吃，给他水喝， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S130_12","010_30_12","1SA","30","12","12","又给他一块无花果饼，两个葡萄饼。他吃了，就精神复原；因为他三日三夜没有吃饼，没有喝水。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S130_13","010_30_13","1SA","30","13","13","大卫问他说：「你是属谁的？你是哪里的人？」他回答说：「我是埃及的少年人，是亚玛力人的奴仆；因我三日前患病，我主人就把我撇弃了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S130_14","010_30_14","1SA","30","14","14","我们侵夺了基利提的南方和属犹大的地，并迦勒地的南方，又用火烧了洗革拉。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S130_15","010_30_15","1SA","30","15","15","大卫问他说：「你肯领我们到敌军那里不肯？」他回答说：「你要向我指着　神起誓，不杀我，也不将我交在我主人手里，我就领你下到敌军那里。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S130_16","010_30_16","1SA","30","16","16","那人领大卫下去，见他们散在地上，吃喝跳舞，因为从非利士地和犹大地所掳来的财物甚多。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S130_17","010_30_17","1SA","30","17","17","大卫从黎明直到次日晚上，击杀他们，除了四百骑骆驼的少年人之外，没有一个逃脱的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S130_18","010_30_18","1SA","30","18","18","亚玛力人所掳去的财物，大卫全都夺回，并救回他的两个妻来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S130_19","010_30_19","1SA","30","19","19","凡亚玛力人所掳去的，无论大小、儿女、财物，大卫都夺回来，没有失落一个。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S130_20","010_30_20","1SA","30","20","20","大卫所夺来的牛群羊群，跟随他的人赶在原有的群畜前边，说：「这是大卫的掠物。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S130_21","010_30_21","1SA","30","21","21","大卫到了那疲乏不能跟随、留在比梭溪的二百人那里。他们出来迎接大卫并跟随的人。大卫前来问他们安。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S130_22","010_30_22","1SA","30","22","22","跟随大卫人中的恶人和匪类说：「这些人既然没有和我们同去，我们所夺的财物就不分给他们，只将他们各人的妻子儿女给他们，使他们带去就是了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S130_23","010_30_23","1SA","30","23","23","大卫说：「弟兄们，耶和华所赐给我们的，不可不分给他们；因为他保佑我们，将那攻击我们的敌军交在我们手里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S130_24","010_30_24","1SA","30","24","24","这事谁肯依从你们呢？上阵的得多少，看守器具的也得多少；应当大家平分。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S130_25","010_30_25","1SA","30","25","25","大卫定此为以色列的律例典章，从那日直到今日。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S130_26","010_30_26","1SA","30","26","26","大卫到了洗革拉，从掠物中取些送给他朋友犹大的长老，说：「这是从耶和华仇敌那里夺来的，送你们为礼物。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S130_27","010_30_27","1SA","30","27","27","他送礼物给住伯特利的，南地拉末的，雅提珥的； ");
INSERT INTO cmn_cu89s_vpl VALUES ("S130_28","010_30_28","1SA","30","28","28","住亚罗珥的，息末的，以实提莫的； ");
INSERT INTO cmn_cu89s_vpl VALUES ("S130_29","010_30_29","1SA","30","29","29","住拉哈勒的，耶拉篾各城的，基尼各城的； ");
INSERT INTO cmn_cu89s_vpl VALUES ("S130_30","010_30_30","1SA","30","30","30","住何珥玛的，歌拉珊的，亚挞的； ");
INSERT INTO cmn_cu89s_vpl VALUES ("S130_31","010_30_31","1SA","30","31","31","住希伯 的，并大卫和跟随他的人素来所到之处的人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S131_1","010_31_1","1SA","31","1","1","非利士人与以色列人争战。以色列人在非利士人面前逃跑，在基利波有被杀仆倒的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S131_2","010_31_2","1SA","31","2","2","非利士人紧追扫罗和他儿子们，就杀了扫罗的儿子约拿单、亚比拿达、麦基舒亚。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S131_3","010_31_3","1SA","31","3","3","势派甚大，扫罗被弓箭手追上，射伤甚重， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S131_4","010_31_4","1SA","31","4","4","就吩咐拿他兵器的人说：「你拔出刀来，将我刺死，免得那些未受割礼的人来刺我，凌辱我。」但拿兵器的人甚惧怕，不肯刺他；扫罗就自己伏在刀上死了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S131_5","010_31_5","1SA","31","5","5","拿兵器的人见扫罗已死，也伏在刀上死了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S131_6","010_31_6","1SA","31","6","6","这样，扫罗和他三个儿子，与拿他兵器的人，以及跟随他的人，都一同死亡。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S131_7","010_31_7","1SA","31","7","7","住平原那边并约旦河西的以色列人，见以色列军兵逃跑，扫罗和他儿子都死了，也就弃城逃跑。非利士人便来住在其中。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S131_8","010_31_8","1SA","31","8","8","次日，非利士人来剥那被杀之人的衣服，看见扫罗和他三个儿子仆倒在基利波山， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S131_9","010_31_9","1SA","31","9","9","就割下他的首级，剥了他的军装，打发人到非利士地的四境，报信与他们庙里的偶像和众民； ");
INSERT INTO cmn_cu89s_vpl VALUES ("S131_10","010_31_10","1SA","31","10","10","又将扫罗的军装放在亚斯她录庙里，将他的尸身钉在伯·珊的城墙上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S131_11","010_31_11","1SA","31","11","11","基列·雅比的居民听见非利士人向扫罗所行的事， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S131_12","010_31_12","1SA","31","12","12","他们中间所有的勇士就起身，走了一夜，将扫罗和他儿子的尸身从伯·珊城墙上取下来，送到雅比那里，用火烧了； ");
INSERT INTO cmn_cu89s_vpl VALUES ("S131_13","010_31_13","1SA","31","13","13","将他们骸骨葬在雅比的垂丝柳树下，就禁食七日。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S21_1","011_1_1","2SA","1","1","1","扫罗死后，大卫击杀亚玛力人回来，在洗革拉住了两天。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S21_2","011_1_2","2SA","1","2","2","第三天，有一人从扫罗的营里出来，衣服撕裂，头蒙灰尘，到大卫面前伏地叩拜。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S21_3","011_1_3","2SA","1","3","3","大卫问他说：「你从哪里来？」他说：「我从以色列的营里逃来。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S21_4","011_1_4","2SA","1","4","4","大卫又问他说：「事情怎样？请你告诉我。」他回答说：「百姓从阵上逃跑，也有许多人仆倒死亡；扫罗和他儿子约拿单也死了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S21_5","011_1_5","2SA","1","5","5","大卫问报信的少年人说：「你怎么知道扫罗和他儿子约拿单死了呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S21_6","011_1_6","2SA","1","6","6","报信的少年人说：「我偶然到基利波山，看见扫罗伏在自己枪上，有战车、马兵紧紧地追他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S21_7","011_1_7","2SA","1","7","7","他回头看见我，就呼叫我。我说：『我在这里。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S21_8","011_1_8","2SA","1","8","8","他问我说：『你是什么人？』我说：『我是亚玛力人。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S21_9","011_1_9","2SA","1","9","9","他说：『请你来，将我杀死；因为痛苦抓住我，我的生命尚存。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S21_10","011_1_10","2SA","1","10","10","我准知他仆倒必不能活，就去将他杀死，把他头上的冠冕、臂上的镯子拿到我主这里。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S21_11","011_1_11","2SA","1","11","11","大卫就撕裂衣服，跟随他的人也是如此， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S21_12","011_1_12","2SA","1","12","12","而且悲哀哭号，禁食到晚上，是因扫罗和他儿子约拿单，并耶和华的民以色列家的人，倒在刀下。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S21_13","011_1_13","2SA","1","13","13","大卫问报信的少年人说：「你是哪里的人？」他说：「我是亚玛力客人的儿子。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S21_14","011_1_14","2SA","1","14","14","大卫说：「你伸手杀害耶和华的受膏者，怎么不畏惧呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S21_15","011_1_15","2SA","1","15","15","大卫叫了一个少年人来，说：「你去杀他吧！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S21_16","011_1_16","2SA","1","16","16","大卫对他说：「你流人血的罪归到自己的头上，因为你亲口作见证说：『我杀了耶和华的受膏者。』」少年人就把他杀了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S21_17","011_1_17","2SA","1","17","17","大卫作哀歌，吊扫罗和他儿子约拿单， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S21_18","011_1_18","2SA","1","18","18","且吩咐将这歌教导犹大人。这歌名叫「弓歌」，写在雅煞珥书上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S21_19","011_1_19","2SA","1","19","19","歌中说：以色列啊， 你尊荣者在山上被杀！ 大英雄何竟死亡！ ");
INSERT INTO cmn_cu89s_vpl VALUES ("S21_20","011_1_20","2SA","1","20","20","不要在迦特报告； 不要在亚实基伦街上传扬； 免得非利士的女子欢乐； 免得未受割礼之人的女子矜夸。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S21_21","011_1_21","2SA","1","21","21","基利波山哪，愿你那里没有雨露！ 愿你田地无土产可作供物！ 因为英雄的盾牌在那里被污丢弃； 扫罗的盾牌仿佛未曾抹油。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S21_22","011_1_22","2SA","1","22","22","约拿单的弓箭非流敌人的血不退缩； 扫罗的刀剑非剖勇士的油不收回。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S21_23","011_1_23","2SA","1","23","23","扫罗和约拿单— 活时相悦相爱，死时也不分离 —他们比鹰更快，比狮子还强。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S21_24","011_1_24","2SA","1","24","24","以色列的女子啊，当为扫罗哭号！ 他曾使你们穿朱红色的美衣， 使你们衣服有黄金的妆饰。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S21_25","011_1_25","2SA","1","25","25","英雄何竟在阵上仆倒！ 约拿单何竟在山上被杀！ ");
INSERT INTO cmn_cu89s_vpl VALUES ("S21_26","011_1_26","2SA","1","26","26","我兄约拿单哪，我为你悲伤！ 我甚喜悦你！ 你向我发的爱情奇妙非常， 过于妇女的爱情。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S21_27","011_1_27","2SA","1","27","27","英雄何竟仆倒！ 战具何竟灭没！ ");
INSERT INTO cmn_cu89s_vpl VALUES ("S22_1","011_2_1","2SA","2","1","1","此后，大卫问耶和华说：「我上犹大的一个城去可以吗？」耶和华说：「可以。」大卫说：「我上哪一个城去呢？」耶和华说：「上希伯 去。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S22_2","011_2_2","2SA","2","2","2","于是大卫和他的两个妻—一个是耶斯列人亚希暖，一个是作过迦密人拿八妻的亚比该—都上那里去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S22_3","011_2_3","2SA","2","3","3","大卫也将跟随他的人和他们各人的眷属一同带上去，住在希伯 的城邑中。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S22_4","011_2_4","2SA","2","4","4","犹大人来到希伯 ，在那里膏大卫作犹大家的王。 有人告诉大卫说：「葬埋扫罗的是基列·雅比人。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S22_5","011_2_5","2SA","2","5","5","大卫就差人去见基列·雅比人，对他们说：「你们厚待你们的主—扫罗，将他葬埋。愿耶和华赐福与你们！ ");
INSERT INTO cmn_cu89s_vpl VALUES ("S22_6","011_2_6","2SA","2","6","6","你们既行了这事，愿耶和华以慈爱诚实待你们，我也要为此厚待你们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S22_7","011_2_7","2SA","2","7","7","现在你们的主—扫罗死了，犹大家已经膏我作他们的王，所以你们要刚强奋勇。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S22_8","011_2_8","2SA","2","8","8","扫罗的元帅尼珥的儿子押尼珥，曾将扫罗的儿子伊施波设带过河，到玛哈念， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S22_9","011_2_9","2SA","2","9","9","立他作王，治理基列、亚书利、耶斯列、以法莲、便雅悯，和以色列众人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S22_10","011_2_10","2SA","2","10","10","扫罗的儿子伊施波设登基的时候年四十岁，作以色列王二年；惟独犹大家归从大卫。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S22_11","011_2_11","2SA","2","11","11","大卫在希伯 作犹大家的王，共七年零六个月。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S22_12","011_2_12","2SA","2","12","12","尼珥的儿子押尼珥和扫罗的儿子伊施波设的仆人从玛哈念出来，往基遍去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S22_13","011_2_13","2SA","2","13","13","洗鲁雅的儿子约押和大卫的仆人也出来，在基遍池旁与他们相遇；一班坐在池这边，一班坐在池那边。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S22_14","011_2_14","2SA","2","14","14","押尼珥对约押说：「让少年人起来，在我们面前戏耍吧！」约押说：「可以。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S22_15","011_2_15","2SA","2","15","15","就按着定数起来：属扫罗儿子伊施波设的便雅悯人过去十二名，大卫的仆人也过去十二名， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S22_16","011_2_16","2SA","2","16","16","彼此揪头，用刀刺肋，一同仆倒。所以，那地叫做希利甲·哈素林，就在基遍。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S22_17","011_2_17","2SA","2","17","17","那日的战事凶猛，押尼珥和以色列人败在大卫的仆人面前。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S22_18","011_2_18","2SA","2","18","18","在那里有洗鲁雅的三个儿子：约押、亚比筛、亚撒黑。亚撒黑脚快如野鹿一般； ");
INSERT INTO cmn_cu89s_vpl VALUES ("S22_19","011_2_19","2SA","2","19","19","亚撒黑追赶押尼珥，直追赶他不偏左右。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S22_20","011_2_20","2SA","2","20","20","押尼珥回头说：「你是亚撒黑吗？」回答说：「是。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S22_21","011_2_21","2SA","2","21","21","押尼珥对他说：「你或转向左转向右，拿住一个少年人，剥去他的战衣。」亚撒黑却不肯转开不追赶他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S22_22","011_2_22","2SA","2","22","22","押尼珥又对亚撒黑说：「你转开不追赶我吧！我何必杀你呢？若杀你，有什么脸见你哥哥约押呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S22_23","011_2_23","2SA","2","23","23","亚撒黑仍不肯转开。故此，押尼珥就用枪 刺入他的肚腹，甚至枪从背后透出，亚撒黑就在那里仆倒而死。众人赶到亚撒黑仆倒而死的地方，就都站住。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S22_24","011_2_24","2SA","2","24","24","约押和亚比筛追赶押尼珥，日落的时候，到了通基遍旷野的路旁，基亚对面的亚玛山。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S22_25","011_2_25","2SA","2","25","25","便雅悯人聚集，跟随押尼珥站在一个山顶上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S22_26","011_2_26","2SA","2","26","26","押尼珥呼叫约押说：「刀剑岂可永远杀人吗？你岂不知终久必有苦楚吗？你要等何时才叫百姓回去、不追赶弟兄呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S22_27","011_2_27","2SA","2","27","27","约押说：「我指着永生的　神起誓：你若不说戏耍的那句话，今日早晨百姓就回去，不追赶弟兄了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S22_28","011_2_28","2SA","2","28","28","于是约押吹角，众民就站住，不再追赶以色列人，也不再打仗了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S22_29","011_2_29","2SA","2","29","29","押尼珥和跟随他的人整夜经过亚拉巴，过约旦河，走过毕伦，到了玛哈念。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S22_30","011_2_30","2SA","2","30","30","约押追赶押尼珥回来，聚集众民，见大卫的仆人中缺少了十九个人和亚撒黑。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S22_31","011_2_31","2SA","2","31","31","但大卫的仆人杀了便雅悯人和跟随押尼珥的人，共三百六十名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S22_32","011_2_32","2SA","2","32","32","众人将亚撒黑送到伯利恒，葬在他父亲的坟墓里。约押和跟随他的人走了一夜，天亮的时候到了希伯 。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S23_1","011_3_1","2SA","3","1","1","扫罗家和大卫家争战许久。大卫家日见强盛；扫罗家日见衰弱。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S23_2","011_3_2","2SA","3","2","2","大卫在希伯 得了几个儿子：长子暗嫩是耶斯列人亚希暖所生的； ");
INSERT INTO cmn_cu89s_vpl VALUES ("S23_3","011_3_3","2SA","3","3","3","次子基利押是作过迦密人拿八的妻亚比该所生的；三子押沙龙是基述王达买的女儿玛迦所生的； ");
INSERT INTO cmn_cu89s_vpl VALUES ("S23_4","011_3_4","2SA","3","4","4","四子亚多尼雅是哈及所生的；五子示法提雅是亚比她所生的； ");
INSERT INTO cmn_cu89s_vpl VALUES ("S23_5","011_3_5","2SA","3","5","5","六子以特念是大卫的妻以格拉所生的。大卫这六个儿子都是在希伯 生的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S23_6","011_3_6","2SA","3","6","6","扫罗家和大卫家争战的时候，押尼珥在扫罗家大有权势。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S23_7","011_3_7","2SA","3","7","7","扫罗有一妃嫔，名叫利斯巴，是爱亚的女儿。一日，伊施波设对押尼珥说：「你为什么与我父的妃嫔同房呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S23_8","011_3_8","2SA","3","8","8","押尼珥因伊施波设的话就甚发怒，说：「我岂是犹大的狗头呢？我恩待你父扫罗的家和他的弟兄、朋友，不将你交在大卫手里，今日你竟为这妇人责备我吗？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("S23_9","011_3_9","2SA","3","9","10","我若不照着耶和华起誓应许大卫的话行，废去扫罗的位，建立大卫的位，使他治理以色列和犹大，从但直到别是巴，愿　神重重地降罚与我！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S23_11","011_3_11","2SA","3","11","11","伊施波设惧怕押尼珥，不敢回答一句。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S23_12","011_3_12","2SA","3","12","12","押尼珥打发人去见大卫，替他说：「这国归谁呢？」又说：「你与我立约，我必帮助你，使以色列人都归服你。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S23_13","011_3_13","2SA","3","13","13","大卫说：「好！我与你立约。但有一件，你来见我面的时候，若不将扫罗的女儿米甲带来，必不得见我的面。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S23_14","011_3_14","2SA","3","14","14","大卫就打发人去见扫罗的儿子伊施波设，说：「你要将我的妻米甲归还我；她是我从前用一百非利士人的阳皮所聘定的。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S23_15","011_3_15","2SA","3","15","15","伊施波设就打发人去，将米甲从拉亿的儿子、她丈夫帕铁那里接回来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S23_16","011_3_16","2SA","3","16","16","米甲的丈夫跟着她，一面走一面哭，直跟到巴户琳。押尼珥说：「你回去吧！」帕铁就回去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S23_17","011_3_17","2SA","3","17","17","押尼珥对以色列长老说：「从前你们愿意大卫作王治理你们， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S23_18","011_3_18","2SA","3","18","18","现在你们可以照心愿而行。因为耶和华曾论到大卫说：『我必借我仆人大卫的手，救我民以色列脱离非利士人和众仇敌的手。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S23_19","011_3_19","2SA","3","19","19","押尼珥也用这话说给便雅悯人听，又到希伯 ，将以色列人和便雅悯全家一切所喜悦的事说给大卫听。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S23_20","011_3_20","2SA","3","20","20","押尼珥带着二十个人来到希伯 见大卫，大卫就为押尼珥和他带来的人设摆筵席。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S23_21","011_3_21","2SA","3","21","21","押尼珥对大卫说：「我要起身去招聚以色列众人来见我主我王，与你立约，你就可以照着心愿作王。」于是大卫送押尼珥去，押尼珥就平平安安地去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S23_22","011_3_22","2SA","3","22","22","约押和大卫的仆人攻击敌军，带回许多的掠物。那时押尼珥不在希伯 大卫那里，因大卫已经送他去，他也平平安安地去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S23_23","011_3_23","2SA","3","23","23","约押和跟随他的全军到了，就有人告诉约押说：「尼珥的儿子押尼珥来见王，王送他去，他也平平安安地去了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S23_24","011_3_24","2SA","3","24","24","约押去见王说：「你这是做什么呢？押尼珥来见你，你为何送他去，他就踪影不见了呢？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("S23_25","011_3_25","2SA","3","25","25","你当晓得，尼珥的儿子押尼珥来是要诓哄你，要知道你的出入和你一切所行的事。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S23_26","011_3_26","2SA","3","26","26","约押从大卫那里出来，就打发人去追赶押尼珥，在西拉井追上他，将他带回来，大卫却不知道。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S23_27","011_3_27","2SA","3","27","27","押尼珥回到希伯 ，约押领他到城门的瓮洞，假作要与他说机密话，就在那里刺透他的肚腹，他便死了。这是报杀他兄弟亚撒黑的仇。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S23_28","011_3_28","2SA","3","28","28","大卫听见了，就说：「流尼珥的儿子押尼珥的血，这罪在耶和华面前必永不归我和我的国。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S23_29","011_3_29","2SA","3","29","29","愿流他血的罪归到约押头上和他父的全家；又愿约押家不断有患漏症的，长大麻风的，架拐而行的，被刀杀死的，缺乏饮食的。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S23_30","011_3_30","2SA","3","30","30","约押和他兄弟亚比筛杀了押尼珥，是因押尼珥在基遍争战的时候杀了他们的兄弟亚撒黑。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S23_31","011_3_31","2SA","3","31","31","大卫吩咐约押和跟随他的众人说：「你们当撕裂衣服，腰束麻布，在押尼珥棺前哀哭。」大卫王也跟在棺后。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S23_32","011_3_32","2SA","3","32","32","他们将押尼珥葬在希伯 。王在押尼珥的墓旁放声而哭，众民也都哭了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S23_33","011_3_33","2SA","3","33","33","王为押尼珥举哀，说： 押尼珥何竟像愚顽人死呢？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("S23_34","011_3_34","2SA","3","34","34","你手未曾捆绑，脚未曾锁住。 你死，如人死在罪孽之辈手下一样。 于是众民又为押尼珥哀哭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S23_35","011_3_35","2SA","3","35","35","日头未落的时候，众民来劝大卫吃饭，但大卫起誓说：「我若在日头未落以前吃饭，或吃别物，愿　神重重地降罚与我！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S23_36","011_3_36","2SA","3","36","36","众民知道了就都喜悦。凡王所行的，众民无不喜悦。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S23_37","011_3_37","2SA","3","37","37","那日，以色列众民才知道杀尼珥的儿子押尼珥并非出于王意。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S23_38","011_3_38","2SA","3","38","38","王对臣仆说：「你们岂不知今日以色列人中死了一个作元帅的大丈夫吗？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("S23_39","011_3_39","2SA","3","39","39","我虽然受膏为王，今日还是软弱；这洗鲁雅的两个儿子比我刚强。愿耶和华照着恶人所行的恶报应他。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S24_1","011_4_1","2SA","4","1","1","扫罗的儿子伊施波设听见押尼珥死在希伯 ，手就发软；以色列众人也都惊惶。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S24_2","011_4_2","2SA","4","2","2","扫罗的儿子伊施波设有两个军长，一名巴拿，一名利甲，是便雅悯支派、比录人临门的儿子。比录也属便雅悯。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S24_3","011_4_3","2SA","4","3","3","比录人早先逃到基他音，在那里寄居，直到今日。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S24_4","011_4_4","2SA","4","4","4","扫罗的儿子约拿单有一个儿子名叫米非波设，是瘸腿的。扫罗和约拿单死亡的消息从耶斯列传到的时候，他才五岁。他乳母抱着他逃跑；因为跑得太急，孩子掉在地上，腿就瘸了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S24_5","011_4_5","2SA","4","5","5","一日，比录人临门的两个儿子利甲和巴拿出去，约在午热的时候到了伊施波设的家；伊施波设正睡午觉。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S24_6","011_4_6","2SA","4","6","6","他们进了房子，假作要取麦子，就刺透伊施波设的肚腹，逃跑了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S24_7","011_4_7","2SA","4","7","7","他们进房子的时候，伊施波设正在卧房里躺在床上，他们将他杀死，割了他的首级，拿着首级在亚拉巴走了一夜， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S24_8","011_4_8","2SA","4","8","8","将伊施波设的首级拿到希伯 见大卫王，说：「王的仇敌扫罗曾寻索王的性命。看哪，这是他儿子伊施波设的首级；耶和华今日为我主我王在扫罗和他后裔的身上报了仇。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S24_9","011_4_9","2SA","4","9","9","大卫对比录人临门的儿子利甲和他兄弟巴拿说：「我指着救我性命脱离一切苦难、永生的耶和华起誓： ");
INSERT INTO cmn_cu89s_vpl VALUES ("S24_10","011_4_10","2SA","4","10","10","从前有人报告我说，扫罗死了，他自以为报好消息；我就拿住他，将他杀在洗革拉，这就作了他报消息的赏赐。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S24_11","011_4_11","2SA","4","11","11","何况恶人将义人杀在他的床上，我岂不向你们讨流他血的罪、从世上除灭你们呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S24_12","011_4_12","2SA","4","12","12","于是大卫吩咐少年人将他们杀了，砍断他们的手脚，挂在希伯 的池旁，却将伊施波设的首级葬在希伯 、押尼珥的坟墓里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S25_1","011_5_1","2SA","5","1","1","以色列众支派来到希伯 见大卫，说：「我们原是你的骨肉。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S25_2","011_5_2","2SA","5","2","2","从前扫罗作我们王的时候，率领以色列人出入的是你；耶和华也曾应许你说：『你必牧养我的民以色列，作以色列的君。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S25_3","011_5_3","2SA","5","3","3","于是以色列的长老都来到希伯 见大卫王，大卫在希伯 耶和华面前与他们立约，他们就膏大卫作以色列的王。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S25_4","011_5_4","2SA","5","4","4","大卫登基的时候年三十岁，在位四十年； ");
INSERT INTO cmn_cu89s_vpl VALUES ("S25_5","011_5_5","2SA","5","5","5","在希伯 作犹大王七年零六个月，在耶路撒冷作以色列和犹大王三十三年。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S25_6","011_5_6","2SA","5","6","6","大卫和跟随他的人到了耶路撒冷，要攻打住那地方的耶布斯人。耶布斯人对大卫说：「你若不赶出瞎子、瘸子，必不能进这地方」；心里想大卫决不能进去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S25_7","011_5_7","2SA","5","7","7","然而大卫攻取锡安的保障，就是大卫的城。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S25_8","011_5_8","2SA","5","8","8","当日，大卫说：「谁攻打耶布斯人，当上水沟攻打我心里所恨恶的瘸子、瞎子。」从此有俗语说：「在那里有瞎子、瘸子，他不能进屋去。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S25_9","011_5_9","2SA","5","9","9","大卫住在保障里，给保障起名叫大卫城。大卫又从米罗以里，周围筑墙。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S25_10","011_5_10","2SA","5","10","10","大卫日见强盛，因为耶和华—万军之　神与他同在。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S25_11","011_5_11","2SA","5","11","11","泰尔王希兰将香柏木运到大卫那里，又差遣使者和木匠、石匠给大卫建造宫殿。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S25_12","011_5_12","2SA","5","12","12","大卫就知道耶和华坚立他作以色列王，又为自己的民以色列使他的国兴旺。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S25_13","011_5_13","2SA","5","13","13","大卫离开希伯 之后，在耶路撒冷又立后妃，又生儿女。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S25_14","011_5_14","2SA","5","14","14","在耶路撒冷所生的儿子是沙母亚、朔罢、拿单、所罗门、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S25_15","011_5_15","2SA","5","15","15","益辖、以利书亚、尼斐、雅非亚、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S25_16","011_5_16","2SA","5","16","16","以利沙玛、以利雅大、以利法列。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S25_17","011_5_17","2SA","5","17","17","非利士人听见人膏大卫作以色列王，非利士众人就上来寻索大卫；大卫听见，就下到保障。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S25_18","011_5_18","2SA","5","18","18","非利士人来了，布散在利乏音谷。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S25_19","011_5_19","2SA","5","19","19","大卫求问耶和华说：「我可以上去攻打非利士人吗？你将他们交在我手里吗？」耶和华说：「你可以上去，我必将非利士人交在你手里。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S25_20","011_5_20","2SA","5","20","20","大卫来到巴力·毗拉心，在那里击杀非利士人，说：「耶和华在我面前冲破敌人，如同水冲去一般。」因此称那地方为巴力·毗拉心。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S25_21","011_5_21","2SA","5","21","21","非利士人将偶像撇在那里，大卫和跟随他的人拿去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S25_22","011_5_22","2SA","5","22","22","非利士人又上来，布散在利乏音谷。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S25_23","011_5_23","2SA","5","23","23","大卫求问耶和华；耶和华说：「不要一直地上去，要转到他们后头，从桑林对面攻打他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S25_24","011_5_24","2SA","5","24","24","你听见桑树梢上有脚步的声音，就要急速前去，因为那时耶和华已经在你前头去攻打非利士人的军队。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S25_25","011_5_25","2SA","5","25","25","大卫就遵着耶和华所吩咐的去行，攻打非利士人，从迦巴直到基色。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S26_1","011_6_1","2SA","6","1","1","大卫又聚集以色列中所有挑选的人三万。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S26_2","011_6_2","2SA","6","2","2","大卫起身，率领跟随他的众人前往，要从巴拉·犹大将　神的约柜运来；这约柜就是坐在二基路伯上万军之耶和华留名的约柜。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S26_3","011_6_3","2SA","6","3","3","他们将　神的约柜从冈上亚比拿达的家里抬出来，放在新车上；亚比拿达的两个儿子乌撒和亚希约赶这新车。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S26_4","011_6_4","2SA","6","4","4","他们将　神的约柜从冈上亚比拿达家里抬出来的时候，亚希约在柜前行走。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S26_5","011_6_5","2SA","6","5","5","大卫和以色列的全家在耶和华面前，用松木制造的各样乐器和琴、瑟、鼓、钹、锣，作乐跳舞。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S26_6","011_6_6","2SA","6","6","6","到了拿艮的禾场，因为牛失前蹄，乌撒就伸手扶住　神的约柜。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S26_7","011_6_7","2SA","6","7","7","神耶和华向乌撒发怒，因这错误击杀他，他就死在　神的约柜旁。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S26_8","011_6_8","2SA","6","8","8","大卫因耶和华击杀乌撒，心里愁烦，就称那地方为毗列斯·乌撒，直到今日。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S26_9","011_6_9","2SA","6","9","9","那日，大卫惧怕耶和华，说：「耶和华的约柜怎可运到我这里来？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S26_10","011_6_10","2SA","6","10","10","于是大卫不肯将耶和华的约柜运进大卫的城，却运到迦特人俄别·以东的家中。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S26_11","011_6_11","2SA","6","11","11","耶和华的约柜在迦特人俄别·以东家中三个月；耶和华赐福给俄别·以东和他的全家。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S26_12","011_6_12","2SA","6","12","12","有人告诉大卫王说：「耶和华因为约柜赐福给俄别·以东的家和一切属他的。」大卫就去，欢欢喜喜地将　神的约柜从俄别·以东家中抬到大卫的城里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S26_13","011_6_13","2SA","6","13","13","抬耶和华约柜的人走了六步，大卫就献牛与肥羊为祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S26_14","011_6_14","2SA","6","14","14","大卫穿着细麻布的以弗得，在耶和华面前极力跳舞。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S26_15","011_6_15","2SA","6","15","15","这样，大卫和以色列的全家欢呼吹角，将耶和华的约柜抬上来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S26_16","011_6_16","2SA","6","16","16","耶和华的约柜进了大卫城的时候，扫罗的女儿米甲从窗户里观看，见大卫王在耶和华面前踊跃跳舞，心里就轻视他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S26_17","011_6_17","2SA","6","17","17","众人将耶和华的约柜请进去，安放在所预备的地方，就是在大卫所搭的帐幕里。大卫在耶和华面前献燔祭和平安祭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S26_18","011_6_18","2SA","6","18","18","大卫献完了燔祭和平安祭，就奉万军之耶和华的名给民祝福， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S26_19","011_6_19","2SA","6","19","19","并且分给以色列众人，无论男女，每人一个饼，一块肉，一个葡萄饼；众人就各回各家去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S26_20","011_6_20","2SA","6","20","20","大卫回家要给眷属祝福；扫罗的女儿米甲出来迎接他，说：「以色列王今日在臣仆的婢女眼前露体，如同一个轻贱人无耻露体一样，有好大的荣耀啊！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S26_21","011_6_21","2SA","6","21","21","大卫对米甲说：「这是在耶和华面前；耶和华已拣选我，废了你父和你父的全家，立我作耶和华民以色列的君，所以我必在耶和华面前跳舞。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S26_22","011_6_22","2SA","6","22","22","我也必更加卑微，自己看为轻贱。你所说的那些婢女，她们倒要尊敬我。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S26_23","011_6_23","2SA","6","23","23","扫罗的女儿米甲，直到死日，没有生养儿女。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S27_1","011_7_1","2SA","7","1","1","王住在自己宫中，耶和华使他安靖，不被四围的仇敌扰乱。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S27_2","011_7_2","2SA","7","2","2","那时，王对先知拿单说：「看哪，我住在香柏木的宫中，　神的约柜反在幔子里。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S27_3","011_7_3","2SA","7","3","3","拿单对王说：「你可以照你的心意而行，因为耶和华与你同在。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S27_4","011_7_4","2SA","7","4","4","当夜，耶和华的话临到拿单说： ");
INSERT INTO cmn_cu89s_vpl VALUES ("S27_5","011_7_5","2SA","7","5","5","「你去告诉我仆人大卫，说耶和华如此说：『你岂可建造殿宇给我居住呢？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("S27_6","011_7_6","2SA","7","6","6","自从我领以色列人出埃及直到今日，我未曾住过殿宇，常在会幕和帐幕中行走。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S27_7","011_7_7","2SA","7","7","7","凡我同以色列人所走的地方，我何曾向以色列一支派的士师，就是我吩咐牧养我民以色列的说：你们为何不给我建造香柏木的殿宇呢？』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S27_8","011_7_8","2SA","7","8","8","「现在，你要告诉我仆人大卫，说万军之耶和华如此说：『我从羊圈中将你召来，叫你不再跟从羊群，立你作我民以色列的君。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S27_9","011_7_9","2SA","7","9","9","你无论往哪里去，我常与你同在，剪除你的一切仇敌。我必使你得大名，好像世上大大有名的人一样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S27_10","011_7_10","2SA","7","10","10","我必为我民以色列选定一个地方，栽培他们，使他们住自己的地方，不再迁移；凶恶之子也不像从前扰害他们， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S27_11","011_7_11","2SA","7","11","11","并不像我命士师治理我民以色列的时候一样。我必使你安靖，不被一切仇敌扰乱，并且我—耶和华应许你，必为你建立家室。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S27_12","011_7_12","2SA","7","12","12","你寿数满足、与你列祖同睡的时候，我必使你的后裔接续你的位；我也必坚定他的国。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S27_13","011_7_13","2SA","7","13","13","他必为我的名建造殿宇；我必坚定他的国位，直到永远。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S27_14","011_7_14","2SA","7","14","14","我要作他的父，他要作我的子；他若犯了罪，我必用人的杖责打他，用人的鞭责罚他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S27_15","011_7_15","2SA","7","15","15","但我的慈爱仍不离开他，像离开在你面前所废弃的扫罗一样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S27_16","011_7_16","2SA","7","16","16","你的家和你的国必在我面前永远坚立。你的国位也必坚定，直到永远。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S27_17","011_7_17","2SA","7","17","17","拿单就按这一切话，照这默示，告诉大卫。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S27_18","011_7_18","2SA","7","18","18","于是大卫王进去，坐在耶和华面前，说：「主耶和华啊，我是谁？我的家算什么？你竟使我到这地步呢？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("S27_19","011_7_19","2SA","7","19","19","主耶和华啊，这在你眼中还看为小，又应许你仆人的家至于久远。主耶和华啊，这岂是人所常遇的事吗？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("S27_20","011_7_20","2SA","7","20","20","主耶和华啊，我还有何言可以对你说呢？因为你知道你的仆人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S27_21","011_7_21","2SA","7","21","21","你行这大事使仆人知道，是因你所应许的话，也是照你的心意。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S27_22","011_7_22","2SA","7","22","22","主耶和华啊，你本为大，照我们耳中听见，没有可比你的；除你以外再无　神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S27_23","011_7_23","2SA","7","23","23","世上有何民能比你的民以色列呢？你从埃及救赎他们作自己的子民，又在你赎出来的民面前行大而可畏的事，驱逐列邦人和他们的神，显出你的大名。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S27_24","011_7_24","2SA","7","24","24","你曾坚立你的民以色列作你的子民，直到永远；你—耶和华也作了他们的　神。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S27_25","011_7_25","2SA","7","25","25","「耶和华　神啊，你所应许仆人和仆人家的话，求你坚定，直到永远；照你所说的而行。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S27_26","011_7_26","2SA","7","26","26","愿人永远尊你的名为大，说：『万军之耶和华是治理以色列的　神。』这样，你仆人大卫的家必在你面前坚立。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S27_27","011_7_27","2SA","7","27","27","万军之耶和华—以色列的　神啊，因你启示你的仆人说：『我必为你建立家室』，所以仆人大胆向你如此祈祷。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S27_28","011_7_28","2SA","7","28","28","「主耶和华啊，惟有你是　神。你的话是真实的；你也应许将这福气赐给仆人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S27_29","011_7_29","2SA","7","29","29","现在求你赐福与仆人的家，可以永存在你面前。主耶和华啊，这是你所应许的。愿你永远赐福与仆人的家！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S28_1","011_8_1","2SA","8","1","1","此后，大卫攻打非利士人，把他们治服，从他们手下夺取了京城的权柄； ");
INSERT INTO cmn_cu89s_vpl VALUES ("S28_2","011_8_2","2SA","8","2","2","又攻打摩押人，使他们躺卧在地上，用绳量一量：量二绳的杀了，量一绳的存留。摩押人就归服大卫，给他进贡。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S28_3","011_8_3","2SA","8","3","3","琐巴王利合的儿子哈大底谢往大河去，要夺回他的国权。大卫就攻打他， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S28_4","011_8_4","2SA","8","4","4","擒拿了他的马兵一千七百，步兵二万，将拉战车的马砍断蹄筋，但留下一百辆车的马。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S28_5","011_8_5","2SA","8","5","5","大马士革的亚兰人来帮助琐巴王哈大底谢，大卫就杀了亚兰人二万二千。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S28_6","011_8_6","2SA","8","6","6","于是大卫在大马士革的亚兰地设立防营，亚兰人就归服他，给他进贡。大卫无论往哪里去，耶和华都使他得胜。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S28_7","011_8_7","2SA","8","7","7","他夺了哈大底谢臣仆所拿的金盾牌，带到耶路撒冷。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S28_8","011_8_8","2SA","8","8","8","大卫王又从属哈大底谢的比他和比罗他城中夺取了许多的铜。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S28_9","011_8_9","2SA","8","9","9","哈马王陀以听见大卫杀败哈大底谢的全军， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S28_10","011_8_10","2SA","8","10","10","就打发他儿子约兰去见大卫王，问他的安，为他祝福，因为他杀败了哈大底谢（原来陀以与哈大底谢常常争战）。约兰带了金银铜的器皿来， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S28_11","011_8_11","2SA","8","11","11","大卫王将这些器皿和他治服各国所得来的金银都分别为圣，献给耶和华， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S28_12","011_8_12","2SA","8","12","12","就是从亚兰、摩押、亚扪、非利士、亚玛力人所得来的，以及从琐巴王利合的儿子哈大底谢所掠之物。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S28_13","011_8_13","2SA","8","13","13","大卫在盐谷击杀了亚兰一万八千人回来，就得了大名； ");
INSERT INTO cmn_cu89s_vpl VALUES ("S28_14","011_8_14","2SA","8","14","14","又在以东全地设立防营，以东人就都归服大卫。大卫无论往哪里去，耶和华都使他得胜。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S28_15","011_8_15","2SA","8","15","15","大卫作以色列众人的王，又向众民秉公行义。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S28_16","011_8_16","2SA","8","16","16","洗鲁雅的儿子约押作元帅；亚希律的儿子约沙法作史官； ");
INSERT INTO cmn_cu89s_vpl VALUES ("S28_17","011_8_17","2SA","8","17","17","亚希突的儿子撒督和亚比亚他的儿子亚希米勒作祭司长；西莱雅作书记； ");
INSERT INTO cmn_cu89s_vpl VALUES ("S28_18","011_8_18","2SA","8","18","18","耶何耶大的儿子比拿雅统辖基利提人和比利提人。大卫的众子都作领袖。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S29_1","011_9_1","2SA","9","1","1","大卫问说：「扫罗家还有剩下的人没有？我要因约拿单的缘故向他施恩。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S29_2","011_9_2","2SA","9","2","2","扫罗家有一个仆人，名叫洗巴，有人叫他来见大卫，王问他说：「你是洗巴吗？」回答说：「仆人是。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S29_3","011_9_3","2SA","9","3","3","王说：「扫罗家还有人没有？我要照　神的慈爱恩待他。」洗巴对王说：「还有约拿单的一个儿子，是瘸腿的。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S29_4","011_9_4","2SA","9","4","4","王说：「他在哪里？」洗巴对王说：「他在罗·底巴，亚米利的儿子玛吉家里。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S29_5","011_9_5","2SA","9","5","5","于是大卫王打发人去，从罗·底巴、亚米利的儿子玛吉家里召了他来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S29_6","011_9_6","2SA","9","6","6","扫罗的孙子、约拿单的儿子米非波设来见大卫，伏地叩拜。大卫说：「米非波设！」米非波设说：「仆人在此。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S29_7","011_9_7","2SA","9","7","7","大卫说：「你不要惧怕，我必因你父亲约拿单的缘故施恩与你，将你祖父扫罗的一切田地都归还你；你也可以常与我同席吃饭。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S29_8","011_9_8","2SA","9","8","8","米非波设又叩拜，说：「仆人算什么，不过如死狗一般，竟蒙王这样眷顾！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S29_9","011_9_9","2SA","9","9","9","王召了扫罗的仆人洗巴来，对他说：「我已将属扫罗和他的一切家产都赐给你主人的儿子了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S29_10","011_9_10","2SA","9","10","10","你和你的众子、仆人要为你主人的儿子米非波设耕种田地，把所产的拿来供他食用；他却要常与我同席吃饭。」洗巴有十五个儿子，二十个仆人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S29_11","011_9_11","2SA","9","11","11","洗巴对王说：「凡我主我王吩咐仆人的，仆人都必遵行。」王又说：「米非波设必与我同席吃饭，如王的儿子一样。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S29_12","011_9_12","2SA","9","12","12","米非波设有一个小儿子，名叫米迦。凡住在洗巴家里的人都作了米非波设的仆人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S29_13","011_9_13","2SA","9","13","13","于是米非波设住在耶路撒冷，常与王同席吃饭。他两腿都是瘸的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S210_1","011_10_1","2SA","10","1","1","此后，亚扪人的王死了，他儿子哈嫩接续他作王。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S210_2","011_10_2","2SA","10","2","2","大卫说：「我要照哈嫩的父亲拿辖厚待我的恩典厚待哈嫩。」于是大卫差遣臣仆，为他丧父安慰他。大卫的臣仆到了亚扪人的境内。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S210_3","011_10_3","2SA","10","3","3","但亚扪人的首领对他们的主哈嫩说：「大卫差人来安慰你，你想他是尊敬你父亲吗？他差臣仆来不是详察窥探、要倾覆这城吗？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S210_4","011_10_4","2SA","10","4","4","哈嫩便将大卫臣仆的胡须剃去一半，又割断他们下半截的衣服，使他们露出下体，打发他们回去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S210_5","011_10_5","2SA","10","5","5","有人告诉大卫，他就差人去迎接他们，（因为他们甚觉羞耻），告诉他们说：「可以住在耶利哥，等到胡须长起再回来。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S210_6","011_10_6","2SA","10","6","6","亚扪人知道大卫憎恶他们，就打发人去，招募伯·利合的亚兰人和琐巴的亚兰人，步兵二万，与玛迦王的人一千、陀伯人一万二千。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S210_7","011_10_7","2SA","10","7","7","大卫听见了，就差派约押统带勇猛的全军出去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S210_8","011_10_8","2SA","10","8","8","亚扪人出来，在城门前摆阵；琐巴与利合的亚兰人、陀伯人，并玛迦人，另在郊野摆阵。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S210_9","011_10_9","2SA","10","9","9","约押看见敌人在他前后摆阵，就从以色列军中挑选精兵，使他们对着亚兰人摆阵。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S210_10","011_10_10","2SA","10","10","10","其余的兵交与他兄弟亚比筛，对着亚扪人摆阵。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S210_11","011_10_11","2SA","10","11","11","约押对亚比筛说：「亚兰人若强过我，你就来帮助我；亚扪人若强过你，我就去帮助你。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S210_12","011_10_12","2SA","10","12","12","我们都当刚强，为本国的民和　神的城邑作大丈夫。愿耶和华凭他的意旨而行！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S210_13","011_10_13","2SA","10","13","13","于是，约押和跟随他的人前进攻打亚兰人；亚兰人在约押面前逃跑。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S210_14","011_10_14","2SA","10","14","14","亚扪人见亚兰人逃跑，他们也在亚比筛面前逃跑进城。约押就离开亚扪人那里，回耶路撒冷去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S210_15","011_10_15","2SA","10","15","15","亚兰人见自己被以色列人打败，就又聚集。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S210_16","011_10_16","2SA","10","16","16","哈大底谢差遣人，将大河那边的亚兰人调来；他们到了希兰，哈大底谢的将军朔法率领他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S210_17","011_10_17","2SA","10","17","17","有人告诉大卫，他就聚集以色列众人，过约旦河，来到希兰。亚兰人迎着大卫摆阵，与他打仗。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S210_18","011_10_18","2SA","10","18","18","亚兰人在以色列人面前逃跑；大卫杀了亚兰七百辆战车的人，四万马兵，又杀了亚兰的将军朔法。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S210_19","011_10_19","2SA","10","19","19","属哈大底谢的诸王见自己被以色列人打败，就与以色列人和好，归服他们。于是亚兰人不敢再帮助亚扪人了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S211_1","011_11_1","2SA","11","1","1","过了一年，到列王出战的时候，大卫又差派约押，率领臣仆和以色列众人出战。他们就打败亚扪人，围攻拉巴。大卫仍住在耶路撒冷。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S211_2","011_11_2","2SA","11","2","2","一日，太阳平西，大卫从床上起来，在王宫的平顶上游行，看见一个妇人沐浴，容貌甚美， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S211_3","011_11_3","2SA","11","3","3","大卫就差人打听那妇人是谁。有人说：「她是以连的女儿，赫人乌利亚的妻拔示巴。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S211_4","011_11_4","2SA","11","4","4","大卫差人去，将妇人接来；那时她的月经才得洁净。她来了，大卫与她同房，她就回家去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S211_5","011_11_5","2SA","11","5","5","于是她怀了孕，打发人去告诉大卫说：「我怀了孕。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S211_6","011_11_6","2SA","11","6","6","大卫差人到约押那里，说：「你打发赫人乌利亚到我这里来。」约押就打发乌利亚去见大卫。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S211_7","011_11_7","2SA","11","7","7","乌利亚来了，大卫问约押好，也问兵好，又问争战的事怎样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S211_8","011_11_8","2SA","11","8","8","大卫对乌利亚说：「你回家去，洗洗脚吧！」乌利亚出了王宫，随后王送他一分食物。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S211_9","011_11_9","2SA","11","9","9","乌利亚却和他主人的仆人一同睡在宫门外，没有回家去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S211_10","011_11_10","2SA","11","10","10","有人告诉大卫说：「乌利亚没有回家去。」大卫就问乌利亚说：「你从远路上来，为什么不回家去呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S211_11","011_11_11","2SA","11","11","11","乌利亚对大卫说：「约柜和以色列与犹大兵都住在棚里，我主约押和我主的仆人都在田野安营，我岂可回家吃喝、与妻子同寝呢？我敢在王面前起誓：我决不行这事！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S211_12","011_11_12","2SA","11","12","12","大卫吩咐乌利亚说：「你今日仍住在这里，明日我打发你去。」于是乌利亚那日和次日住在耶路撒冷。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S211_13","011_11_13","2SA","11","13","13","大卫召了乌利亚来，叫他在自己面前吃喝，使他喝醉。到了晚上，乌利亚出去与他主的仆人一同住宿，还没有回到家里去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S211_14","011_11_14","2SA","11","14","14","次日早晨，大卫写信与约押，交乌利亚随手带去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S211_15","011_11_15","2SA","11","15","15","信内写着说：「要派乌利亚前进，到阵势极险之处，你们便退后，使他被杀。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S211_16","011_11_16","2SA","11","16","16","约押围城的时候，知道敌人那里有勇士，便将乌利亚派在那里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S211_17","011_11_17","2SA","11","17","17","城里的人出来和约押打仗；大卫的仆人中有几个被杀的，赫人乌利亚也死了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S211_18","011_11_18","2SA","11","18","18","于是，约押差人去将争战的一切事告诉大卫， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S211_19","011_11_19","2SA","11","19","19","又嘱咐使者说：「你把争战的一切事对王说完了， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S211_20","011_11_20","2SA","11","20","20","王若发怒，问你说：『你们打仗为什么挨近城墙呢？岂不知敌人必从城上射箭吗？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("S211_21","011_11_21","2SA","11","21","21","从前打死耶路·比设儿子亚比米勒的是谁呢？岂不是一个妇人从城上抛下一块上磨石来，打在他身上，他就死在提备斯吗？你们为什么挨近城墙呢？』你就说：『王的仆人—赫人乌利亚也死了。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S211_22","011_11_22","2SA","11","22","22","使者起身，来见大卫，照着约押所吩咐他的话奏告大卫。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S211_23","011_11_23","2SA","11","23","23","使者对大卫说：「敌人强过我们，出到郊野与我们打仗，我们追杀他们，直到城门口。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S211_24","011_11_24","2SA","11","24","24","射箭的从城上射王的仆人，射死几个，赫人乌利亚也死了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S211_25","011_11_25","2SA","11","25","25","王向使者说：「你告诉约押说：『不要因这事愁闷，刀剑或吞灭这人或吞灭那人，没有一定的；你只管竭力攻城，将城倾覆。』可以用这话勉励约押。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S211_26","011_11_26","2SA","11","26","26","乌利亚的妻听见丈夫乌利亚死了，就为他哀哭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S211_27","011_11_27","2SA","11","27","27","哀哭的日子过了，大卫差人将她接到宫里，她就作了大卫的妻，给大卫生了一个儿子。但大卫所行的这事，耶和华甚不喜悦。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S212_1","011_12_1","2SA","12","1","1","耶和华差遣拿单去见大卫。拿单到了大卫那里，对他说：「在一座城里有两个人：一个是富户，一个是穷人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S212_2","011_12_2","2SA","12","2","2","富户有许多牛群羊群； ");
INSERT INTO cmn_cu89s_vpl VALUES ("S212_3","011_12_3","2SA","12","3","3","穷人除了所买来养活的一只小母羊羔之外，别无所有。羊羔在他家里和他儿女一同长大，吃他所吃的，喝他所喝的，睡在他怀中，在他看来如同女儿一样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S212_4","011_12_4","2SA","12","4","4","有一客人来到这富户家里；富户舍不得从自己的牛群羊群中取一只预备给客人吃，却取了那穷人的羊羔，预备给客人吃。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S212_5","011_12_5","2SA","12","5","5","大卫就甚恼怒那人，对拿单说：「我指着永生的耶和华起誓，行这事的人该死！ ");
INSERT INTO cmn_cu89s_vpl VALUES ("S212_6","011_12_6","2SA","12","6","6","他必偿还羊羔四倍；因为他行这事，没有怜恤的心。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S212_7","011_12_7","2SA","12","7","7","拿单对大卫说：「你就是那人！耶和华—以色列的　神如此说：『我膏你作以色列的王，救你脱离扫罗的手。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S212_8","011_12_8","2SA","12","8","8","我将你主人的家业赐给你，将你主人的妻交在你怀里，又将以色列和犹大家赐给你；你若还以为不足，我早就加倍地赐给你。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S212_9","011_12_9","2SA","12","9","9","你为什么藐视耶和华的命令，行他眼中看为恶的事呢？你借亚扪人的刀杀害赫人乌利亚，又娶了他的妻为妻。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S212_10","011_12_10","2SA","12","10","10","你既藐视我，娶了赫人乌利亚的妻为妻，所以刀剑必永不离开你的家。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S212_11","011_12_11","2SA","12","11","11","耶和华如此说：『我必从你家中兴起祸患攻击你；我必在你眼前把你的妃嫔赐给别人，他在日光之下就与她们同寝。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S212_12","011_12_12","2SA","12","12","12","你在暗中行这事，我却要在以色列众人面前，日光之下，报应你。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S212_13","011_12_13","2SA","12","13","13","大卫对拿单说：「我得罪耶和华了！」拿单说：「耶和华已经除掉你的罪，你必不至于死。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S212_14","011_12_14","2SA","12","14","14","只是你行这事，叫耶和华的仇敌大得亵渎的机会，故此，你所得的孩子必定要死。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S212_15","011_12_15","2SA","12","15","15","拿单就回家去了。 耶和华击打乌利亚妻给大卫所生的孩子，使他得重病。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S212_16","011_12_16","2SA","12","16","16","所以大卫为这孩子恳求　神，而且禁食，进入内室，终夜躺在地上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S212_17","011_12_17","2SA","12","17","17","他家中的老臣来到他旁边，要把他从地上扶起来，他却不肯起来，也不同他们吃饭。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S212_18","011_12_18","2SA","12","18","18","到第七日，孩子死了。大卫的臣仆不敢告诉他孩子死了，因他们说：「孩子还活着的时候，我们劝他，他尚且不肯听我们的话，若告诉他孩子死了，岂不更加忧伤吗？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S212_19","011_12_19","2SA","12","19","19","大卫见臣仆彼此低声说话，就知道孩子死了，问臣仆说：「孩子死了吗？」他们说：「死了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S212_20","011_12_20","2SA","12","20","20","大卫就从地上起来，沐浴，抹膏，换了衣裳，进耶和华的殿敬拜；然后回宫，吩咐人摆饭，他便吃了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S212_21","011_12_21","2SA","12","21","21","臣仆问他说：「你所行的是什么意思？孩子活着的时候，你禁食哭泣；孩子死了，你倒起来吃饭。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S212_22","011_12_22","2SA","12","22","22","大卫说：「孩子还活着，我禁食哭泣；因为我想，或者耶和华怜恤我，使孩子不死也未可知。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S212_23","011_12_23","2SA","12","23","23","孩子死了，我何必禁食，我岂能使他返回呢？我必往他那里去，他却不能回我这里来。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S212_24","011_12_24","2SA","12","24","24","大卫安慰他的妻拔示巴，与她同寝，她就生了儿子，给他起名叫所罗门。耶和华也喜爱他， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S212_25","011_12_25","2SA","12","25","25","就借先知拿单赐他一个名字，叫耶底底亚，因为耶和华爱他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S212_26","011_12_26","2SA","12","26","26","约押攻取亚扪人的京城拉巴。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S212_27","011_12_27","2SA","12","27","27","约押打发使者去见大卫，说：「我攻打拉巴，取其水城。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S212_28","011_12_28","2SA","12","28","28","现在你要聚集其余的军兵来，安营围攻这城，恐怕我取了这城，人就以我的名叫这城。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S212_29","011_12_29","2SA","12","29","29","于是大卫聚集众军，往拉巴去攻城，就取了这城， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S212_30","011_12_30","2SA","12","30","30","夺了亚扪人之王所戴的金冠冕，其上的金子重一他连得，又嵌着宝石。人将这冠冕戴在大卫头上。大卫从城里夺了许多财物， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S212_31","011_12_31","2SA","12","31","31","将城里的人拉出来，放在锯下，或铁耙下，或铁斧下，或叫他经过砖窑；大卫待亚扪各城的居民都是如此。其后，大卫和众军都回耶路撒冷去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S213_1","011_13_1","2SA","13","1","1","大卫的儿子押沙龙有一个美貌的妹子，名叫她玛。大卫的儿子暗嫩爱她。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S213_2","011_13_2","2SA","13","2","2","暗嫩为他妹子她玛忧急成病。她玛还是处女，暗嫩以为难向她行事。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S213_3","011_13_3","2SA","13","3","3","暗嫩有一个朋友，名叫约拿达，是大卫长兄示米亚的儿子。这约拿达为人极其狡猾； ");
INSERT INTO cmn_cu89s_vpl VALUES ("S213_4","011_13_4","2SA","13","4","4","他问暗嫩说：「王的儿子啊，为何一天比一天瘦弱呢？请你告诉我。」暗嫩回答说：「我爱我兄弟押沙龙的妹子她玛。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S213_5","011_13_5","2SA","13","5","5","约拿达说：「你不如躺在床上装病；你父亲来看你，就对他说：『求父叫我妹子她玛来，在我眼前预备食物，递给我吃，使我看见，好从她手里接过来吃。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S213_6","011_13_6","2SA","13","6","6","于是暗嫩躺卧装病。王来看他，他对王说：「求父叫我妹子她玛来，在我眼前为我做两个饼，我好从她手里接过来吃。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S213_7","011_13_7","2SA","13","7","7","大卫就打发人到宫里，对她玛说：「你往你哥哥暗嫩的屋里去，为他预备食物。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S213_8","011_13_8","2SA","13","8","8","她玛就到她哥哥暗嫩的屋里；暗嫩正躺卧。她玛抟面，在他眼前做饼，且烤熟了， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S213_9","011_13_9","2SA","13","9","9","在他面前将饼从锅里倒出来，他却不肯吃，便说：「众人离开我出去吧！」众人就都离开他，出去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S213_10","011_13_10","2SA","13","10","10","暗嫩对她玛说：「你把食物拿进卧房，我好从你手里接过来吃。」她玛就把所做的饼拿进卧房，到她哥哥暗嫩那里， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S213_11","011_13_11","2SA","13","11","11","拿着饼上前给他吃，他便拉住她玛，说：「我妹妹，你来与我同寝。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S213_12","011_13_12","2SA","13","12","12","她玛说：「我哥哥，不要玷辱我。以色列人中不当这样行，你不要做这丑事； ");
INSERT INTO cmn_cu89s_vpl VALUES ("S213_13","011_13_13","2SA","13","13","13","你玷辱了我，我何以掩盖我的羞耻呢？你在以色列中也成了愚妄人。你可以求王，他必不禁止我归你。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S213_14","011_13_14","2SA","13","14","14","但暗嫩不肯听她的话，因比她力大，就玷辱她，与她同寝。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S213_15","011_13_15","2SA","13","15","15","随后，暗嫩极其恨她，那恨她的心比先前爱她的心更甚，对她说：「你起来，去吧！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S213_16","011_13_16","2SA","13","16","16","她玛说：「不要这样！你赶出我去的这罪比你才行的更重！」但暗嫩不肯听她的话， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S213_17","011_13_17","2SA","13","17","17","就叫伺候自己的仆人来，说：「将这个女子赶出去！她一出去，你就关门，上闩。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S213_18","011_13_18","2SA","13","18","18","那时她玛穿着彩衣，因为没有出嫁的公主都是这样穿。暗嫩的仆人就把她赶出去，关门上闩。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S213_19","011_13_19","2SA","13","19","19","她玛把灰尘撒在头上，撕裂所穿的彩衣，以手抱头，一面行走，一面哭喊。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S213_20","011_13_20","2SA","13","20","20","她胞兄押沙龙问她说：「莫非你哥哥暗嫩与你亲近了吗？我妹妹，暂且不要作声，他是你的哥哥，不要将这事放在心上。」她玛就孤孤单单地住在她胞兄押沙龙家里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S213_21","011_13_21","2SA","13","21","21","大卫王听见这事，就甚发怒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S213_22","011_13_22","2SA","13","22","22","押沙龙并不和他哥哥暗嫩说好说歹；因为暗嫩玷辱他妹妹她玛，所以押沙龙恨恶他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S213_23","011_13_23","2SA","13","23","23","过了二年，在靠近以法莲的巴力·夏琐有人为押沙龙剪羊毛；押沙龙请王的众子与他同去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S213_24","011_13_24","2SA","13","24","24","押沙龙来见王，说：「现在有人为仆人剪羊毛，请王和王的臣仆与仆人同去。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S213_25","011_13_25","2SA","13","25","25","王对押沙龙说：「我儿，我们不必都去，恐怕使你耗费太多。」押沙龙再三请王，王仍是不肯去，只为他祝福。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S213_26","011_13_26","2SA","13","26","26","押沙龙说：「王若不去，求王许我哥哥暗嫩同去。」王说：「何必要他去呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S213_27","011_13_27","2SA","13","27","27","押沙龙再三求王，王就许暗嫩和王的众子与他同去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S213_28","011_13_28","2SA","13","28","28","押沙龙吩咐仆人说：「你们注意，看暗嫩饮酒畅快的时候，我对你们说杀暗嫩，你们便杀他，不要惧怕。这不是我吩咐你们的吗？你们只管壮胆奋勇！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S213_29","011_13_29","2SA","13","29","29","押沙龙的仆人就照押沙龙所吩咐的，向暗嫩行了。王的众子都起来，各人骑上骡子，逃跑了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S213_30","011_13_30","2SA","13","30","30","他们还在路上，有风声传到大卫那里，说：「押沙龙将王的众子都杀了，没有留下一个。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S213_31","011_13_31","2SA","13","31","31","王就起来，撕裂衣服，躺在地上。王的臣仆也都撕裂衣服，站在旁边。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S213_32","011_13_32","2SA","13","32","32","大卫的长兄，示米亚的儿子约拿达说：「我主，不要以为王的众子—少年人都杀了，只有暗嫩一个人死了。自从暗嫩玷辱押沙龙妹子她玛的那日，押沙龙就定意杀暗嫩了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S213_33","011_13_33","2SA","13","33","33","现在，我主我王，不要把这事放在心上，以为王的众子都死了，只有暗嫩一个人死了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S213_34","011_13_34","2SA","13","34","34","押沙龙逃跑了。 守望的少年人举目观看，见有许多人从山坡的路上来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S213_35","011_13_35","2SA","13","35","35","约拿达对王说：「看哪，王的众子都来了，果然与你仆人所说的相合。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S213_36","011_13_36","2SA","13","36","36","话才说完，王的众子都到了，放声大哭；王和臣仆也都哭得甚恸。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S213_37","011_13_37","2SA","13","37","37","押沙龙逃到基述王亚米忽的儿子达买那里去了。大卫天天为他儿子悲哀。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S213_38","011_13_38","2SA","13","38","38","押沙龙逃到基述，在那里住了三年。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S213_39","011_13_39","2SA","13","39","39","暗嫩死了以后，大卫王得了安慰，心里切切想念押沙龙。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S214_1","011_14_1","2SA","14","1","1","洗鲁雅的儿子约押，知道王心里想念押沙龙， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S214_2","011_14_2","2SA","14","2","2","就打发人往提哥亚去，从那里叫了一个聪明的妇人来，对她说：「请你假装居丧的，穿上孝衣，不要用膏抹身，要装作为死者许久悲哀的妇人； ");
INSERT INTO cmn_cu89s_vpl VALUES ("S214_3","011_14_3","2SA","14","3","3","进去见王，对王如此如此说。」于是约押将当说的话教导了妇人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S214_4","011_14_4","2SA","14","4","4","提哥亚妇人到王面前，伏地叩拜，说：「王啊，求你拯救！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S214_5","011_14_5","2SA","14","5","5","王问她说：「你有什么事呢？」回答说：「婢女实在是寡妇，我丈夫死了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S214_6","011_14_6","2SA","14","6","6","我有两个儿子，一日在田间争斗，没有人解劝，这个就打死那个。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S214_7","011_14_7","2SA","14","7","7","现在全家的人都起来攻击婢女，说：『你将那打死兄弟的交出来，我们好治死他，偿他打死兄弟的命，灭绝那承受家业的。』这样，他们要将我剩下的炭火灭尽，不与我丈夫留名留后在世上。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S214_8","011_14_8","2SA","14","8","8","王对妇人说：「你回家去吧！我必为你下令。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S214_9","011_14_9","2SA","14","9","9","提哥亚妇人又对王说：「我主我王，愿这罪归我和我父家，与王和王的位无干。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S214_10","011_14_10","2SA","14","10","10","王说：「凡难为你的，你就带他到我这里来，他必不再搅扰你。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S214_11","011_14_11","2SA","14","11","11","妇人说：「愿王记念耶和华—你的　神，不许报血仇的人施行灭绝，恐怕他们灭绝我的儿子。」王说：「我指着永生的耶和华起誓：你的儿子连一根头发也不致落在地上。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S214_12","011_14_12","2SA","14","12","12","妇人说：「求我主我王容婢女再说一句话。」王说：「你说吧！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S214_13","011_14_13","2SA","14","13","13","妇人说：「王为何也起意要害　神的民呢？王不使那逃亡的人回来，王的这话就是自证己错了！ ");
INSERT INTO cmn_cu89s_vpl VALUES ("S214_14","011_14_14","2SA","14","14","14","我们都是必死的，如同水泼在地上，不能收回。　神并不夺取人的性命，乃设法使逃亡的人不致成为赶出、回不来的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S214_15","011_14_15","2SA","14","15","15","我来将这话告诉我主我王，是因百姓使我惧怕。婢女想，不如将这话告诉王，或者王成就婢女所求的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S214_16","011_14_16","2SA","14","16","16","人要将我和我儿子从　神的地业上一同除灭，王必应允救我脱离他的手。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S214_17","011_14_17","2SA","14","17","17","婢女又想，我主我王的话必安慰我；因为我主我王能辨别是非，如同　神的使者一样。惟愿耶和华—你的　神与你同在！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S214_18","011_14_18","2SA","14","18","18","王对妇人说：「我要问你一句话，你一点不要瞒我。」妇人说：「愿我主我王说。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S214_19","011_14_19","2SA","14","19","19","王说：「你这些话莫非是约押的主意吗？」妇人说：「我敢在我主我王面前起誓：王的话正对，不偏左右，是王的仆人约押吩咐我的，这些话是他教导我的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S214_20","011_14_20","2SA","14","20","20","王的仆人约押如此行，为要挽回这事。我主的智慧却如　神使者的智慧，能知世上一切事。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S214_21","011_14_21","2SA","14","21","21","王对约押说：「我应允你这事。你可以去，把那少年人押沙龙带回来。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S214_22","011_14_22","2SA","14","22","22","约押就面伏于地叩拜，祝谢于王，又说：「王既应允仆人所求的，仆人今日知道在我主我王眼前蒙恩了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S214_23","011_14_23","2SA","14","23","23","于是约押起身往基述去，将押沙龙带回耶路撒冷。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S214_24","011_14_24","2SA","14","24","24","王说：「使他回自己家里去，不要见我的面。」押沙龙就回自己家里去，没有见王的面。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S214_25","011_14_25","2SA","14","25","25","以色列全地之中，无人像押沙龙那样俊美，得人的称赞，从脚底到头顶毫无瑕疵。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S214_26","011_14_26","2SA","14","26","26","他的头发甚重，每到年底剪发一次；所剪下来的，按王的平称一称，重二百舍客勒。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S214_27","011_14_27","2SA","14","27","27","押沙龙生了三个儿子，一个女儿。女儿名叫她玛，是个容貌俊美的女子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S214_28","011_14_28","2SA","14","28","28","押沙龙住在耶路撒冷足有二年，没有见王的面。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S214_29","011_14_29","2SA","14","29","29","押沙龙打发人去叫约押来，要托他去见王，约押却不肯来。第二次打发人去叫他，他仍不肯来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S214_30","011_14_30","2SA","14","30","30","所以押沙龙对仆人说：「你们看，约押有一块田，与我的田相近，其中有大麦，你们去放火烧了。」押沙龙的仆人就去放火烧了那田。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S214_31","011_14_31","2SA","14","31","31","于是约押起来，到了押沙龙家里，问他说：「你的仆人为何放火烧了我的田呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S214_32","011_14_32","2SA","14","32","32","押沙龙回答约押说：「我打发人去请你来，好托你去见王，替我说：『我为何从基述回来呢？不如仍在那里。』现在要许我见王的面；我若有罪，任凭王杀我就是了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S214_33","011_14_33","2SA","14","33","33","于是约押去见王，将这话奏告王，王便叫押沙龙来。押沙龙来见王，在王面前俯伏于地，王就与押沙龙亲嘴。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S215_1","011_15_1","2SA","15","1","1","此后，押沙龙为自己预备车马，又派五十人在他前头奔走。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S215_2","011_15_2","2SA","15","2","2","押沙龙常常早晨起来，站在城门的道旁，凡有争讼要去求王判断的，押沙龙就叫他过来，问他说：「你是哪一城的人？」回答说：「仆人是以色列某支派的人。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S215_3","011_15_3","2SA","15","3","3","押沙龙对他说：「你的事有情有理，无奈王没有委人听你伸诉。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S215_4","011_15_4","2SA","15","4","4","押沙龙又说：「恨不得我作国中的士师！凡有争讼求审判的到我这里来，我必秉公判断。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S215_5","011_15_5","2SA","15","5","5","若有人近前来要拜押沙龙，押沙龙就伸手拉住他，与他亲嘴。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S215_6","011_15_6","2SA","15","6","6","以色列人中，凡去见王求判断的，押沙龙都是如此待他们。这样，押沙龙暗中得了以色列人的心。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S215_7","011_15_7","2SA","15","7","7","满了四十年，押沙龙对王说：「求你准我往希伯 去，还我向耶和华所许的愿。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S215_8","011_15_8","2SA","15","8","8","因为仆人住在亚兰的基述，曾许愿说：『耶和华若使我再回耶路撒冷，我必事奉他。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S215_9","011_15_9","2SA","15","9","9","王说：「你平平安安地去吧！」押沙龙就起身，往希伯 去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S215_10","011_15_10","2SA","15","10","10","押沙龙打发探子走遍以色列各支派，说：「你们一听见角声就说：『押沙龙在希伯 作王了！』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S215_11","011_15_11","2SA","15","11","11","押沙龙在耶路撒冷请了二百人与他同去，都是诚诚实实去的，并不知道其中的真情。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S215_12","011_15_12","2SA","15","12","12","押沙龙献祭的时候，打发人去将大卫的谋士、基罗人亚希多弗从他本城请了来。于是叛逆的势派甚大；因为随从押沙龙的人民，日渐增多。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S215_13","011_15_13","2SA","15","13","13","有人报告大卫说：「以色列人的心都归向押沙龙了！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S215_14","011_15_14","2SA","15","14","14","大卫就对耶路撒冷跟随他的臣仆说：「我们要起来逃走，不然都不能躲避押沙龙了；要速速地去，恐怕他忽然来到，加害于我们，用刀杀尽合城的人。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S215_15","011_15_15","2SA","15","15","15","王的臣仆对王说：「我主我王所定的，仆人都愿遵行。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S215_16","011_15_16","2SA","15","16","16","于是王带着全家的人出去了，但留下十个妃嫔看守宫殿。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S215_17","011_15_17","2SA","15","17","17","王出去，众民都跟随他，到伯·墨哈，就住下了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S215_18","011_15_18","2SA","15","18","18","王的臣仆都在他面前过去。基利提人、比利提人，就是从迦特跟随王来的六百人，也都在他面前过去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S215_19","011_15_19","2SA","15","19","19","王对迦特人以太说：「你是外邦逃来的人，为什么与我们同去呢？你可以回去与新王同住，或者回你本地去吧！ ");
INSERT INTO cmn_cu89s_vpl VALUES ("S215_20","011_15_20","2SA","15","20","20","你来的日子不多，我今日怎好叫你与我们一同飘流、没有一定的住处呢？你不如带你的弟兄回去吧！愿耶和华用慈爱诚实待你。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S215_21","011_15_21","2SA","15","21","21","以太对王说：「我指着永生的耶和华起誓，又敢在王面前起誓：无论生死，王在哪里，仆人也必在那里。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S215_22","011_15_22","2SA","15","22","22","大卫对以太说：「你前去过河吧！」于是迦特人以太带着跟随他的人和所有的妇人孩子，就都过去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S215_23","011_15_23","2SA","15","23","23","本地的人都放声大哭。众民尽都过去，王也过了汲沦溪；众民往旷野去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S215_24","011_15_24","2SA","15","24","24","撒督和抬　神约柜的利未人也一同来了，将　神的约柜放下。亚比亚他上来，等着众民从城里出来过去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S215_25","011_15_25","2SA","15","25","25","王对撒督说：「你将　神的约柜抬回城去。我若在耶和华眼前蒙恩，他必使我回来，再见约柜和他的居所。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S215_26","011_15_26","2SA","15","26","26","倘若他说：『我不喜悦你』，看哪，我在这里，愿他凭自己的意旨待我！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S215_27","011_15_27","2SA","15","27","27","王又对祭司撒督说：「你不是先见吗？你可以安然回城；你儿子亚希玛斯和亚比亚他的儿子约拿单都可以与你同去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S215_28","011_15_28","2SA","15","28","28","我在旷野的渡口那里等你们报信给我。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S215_29","011_15_29","2SA","15","29","29","于是撒督和亚比亚他将　神的约柜抬回耶路撒冷，他们就住在那里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S215_30","011_15_30","2SA","15","30","30","大卫蒙头赤脚上橄榄山，一面上一面哭。跟随他的人也都蒙头哭着上去； ");
INSERT INTO cmn_cu89s_vpl VALUES ("S215_31","011_15_31","2SA","15","31","31","有人告诉大卫说：「亚希多弗也在叛党之中，随从押沙龙。」大卫祷告说：「耶和华啊，求你使亚希多弗的计谋变为愚拙！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S215_32","011_15_32","2SA","15","32","32","大卫到了山顶、敬拜　神的地方，见亚基人户筛，衣服撕裂，头蒙灰尘来迎接他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S215_33","011_15_33","2SA","15","33","33","大卫对他说：「你若与我同去，必累赘我； ");
INSERT INTO cmn_cu89s_vpl VALUES ("S215_34","011_15_34","2SA","15","34","34","你若回城去，对押沙龙说：『王啊，我愿作你的仆人；我向来作你父亲的仆人，现在我也照样作你的仆人。』这样，你就可以为我破坏亚希多弗的计谋。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S215_35","011_15_35","2SA","15","35","35","祭司撒督和亚比亚他岂不都在那里吗？你在王宫里听见什么，就要告诉祭司撒督和亚比亚他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S215_36","011_15_36","2SA","15","36","36","撒督的儿子亚希玛斯，亚比亚他的儿子约拿单，也都在那里。凡你们所听见的可以托这二人来报告我。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S215_37","011_15_37","2SA","15","37","37","于是，大卫的朋友户筛进了城；押沙龙也进了耶路撒冷。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S216_1","011_16_1","2SA","16","1","1","大卫刚过山顶，见米非波设的仆人洗巴拉着备好了的两匹驴，驴上驮着二百面饼，一百葡萄饼，一百个夏天的果饼，一皮袋酒来迎接他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S216_2","011_16_2","2SA","16","2","2","王问洗巴说：「你带这些来是什么意思呢？」洗巴说：「驴是给王的家眷骑的；面饼和夏天的果饼是给少年人吃的；酒是给在旷野疲乏人喝的。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S216_3","011_16_3","2SA","16","3","3","王问说：「你主人的儿子在哪里呢？」洗巴回答王说：「他仍在耶路撒冷，因他说：『以色列人今日必将我父的国归还我。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S216_4","011_16_4","2SA","16","4","4","王对洗巴说：「凡属米非波设的都归你了。」洗巴说：「我叩拜我主我王，愿我在你眼前蒙恩。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S216_5","011_16_5","2SA","16","5","5","大卫王到了巴户琳，见有一个人出来，是扫罗族基拉的儿子，名叫示每。他一面走一面咒骂， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S216_6","011_16_6","2SA","16","6","6","又拿石头砍大卫王和王的臣仆；众民和勇士都在王的左右。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S216_7","011_16_7","2SA","16","7","7","示每咒骂说：「你这流人血的坏人哪，去吧去吧！ ");
INSERT INTO cmn_cu89s_vpl VALUES ("S216_8","011_16_8","2SA","16","8","8","你流扫罗全家的血，接续他作王；耶和华把这罪归在你身上，将这国交给你儿子押沙龙。现在你自取其祸，因为你是流人血的人。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S216_9","011_16_9","2SA","16","9","9","洗鲁雅的儿子亚比筛对王说：「这死狗岂可咒骂我主我王呢？求你容我过去，割下他的头来。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S216_10","011_16_10","2SA","16","10","10","王说：「洗鲁雅的儿子，我与你们有何关涉呢？他咒骂是因耶和华吩咐他说：『你要咒骂大卫。』如此，谁敢说你为什么这样行呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S216_11","011_16_11","2SA","16","11","11","大卫又对亚比筛和众臣仆说：「我亲生的儿子尚且寻索我的性命，何况这便雅悯人呢？由他咒骂吧！因为这是耶和华吩咐他的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S216_12","011_16_12","2SA","16","12","12","或者耶和华见我遭难，为我今日被这人咒骂，就施恩与我。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S216_13","011_16_13","2SA","16","13","13","于是大卫和跟随他的人往前行走。示每在大卫对面山坡，一面行走一面咒骂，又拿石头砍他，拿土扬他。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S216_14","011_16_14","2SA","16","14","14","王和跟随他的众人疲疲乏乏地到了一个地方，就在那里歇息歇息。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S216_15","011_16_15","2SA","16","15","15","押沙龙和以色列众人来到耶路撒冷；亚希多弗也与他同来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S216_16","011_16_16","2SA","16","16","16","大卫的朋友亚基人户筛去见押沙龙，对他说：「愿王万岁！愿王万岁！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S216_17","011_16_17","2SA","16","17","17","押沙龙问户筛说：「这是你恩待朋友吗？为什么不与你的朋友同去呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S216_18","011_16_18","2SA","16","18","18","户筛对押沙龙说：「不然，耶和华和这民，并以色列众人所拣选的，我必归顺他，与他同住。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S216_19","011_16_19","2SA","16","19","19","再者，我当服事谁呢？岂不是前王的儿子吗？我怎样服事你父亲，也必照样服事你。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S216_20","011_16_20","2SA","16","20","20","押沙龙对亚希多弗说：「你们出个主意，我们怎样行才好？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S216_21","011_16_21","2SA","16","21","21","亚希多弗对押沙龙说：「你父所留下看守宫殿的妃嫔，你可以与她们亲近。以色列众人听见你父亲憎恶你，凡归顺你人的手就更坚强。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S216_22","011_16_22","2SA","16","22","22","于是人为押沙龙在宫殿的平顶上支搭帐棚；押沙龙在以色列众人眼前，与他父的妃嫔亲近。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S216_23","011_16_23","2SA","16","23","23","那时亚希多弗所出的主意好像人问　神的话一样；他昔日给大卫，今日给押沙龙所出的主意，都是这样。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S217_1","011_17_1","2SA","17","1","1","亚希多弗又对押沙龙说：「求你准我挑选一万二千人，今夜我就起身追赶大卫， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S217_2","011_17_2","2SA","17","2","2","趁他疲乏手软，我忽然追上他，使他惊惶；跟随他的民必都逃跑，我就单杀王一人， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S217_3","011_17_3","2SA","17","3","3","使众民都归顺你。你所寻找的人既然死了，众民就如已经归顺你；这样，也都平安无事了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S217_4","011_17_4","2SA","17","4","4","押沙龙和以色列的长老都以这话为美。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S217_5","011_17_5","2SA","17","5","5","押沙龙说：「要召亚基人户筛来，我们也要听他怎样说。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S217_6","011_17_6","2SA","17","6","6","户筛到了押沙龙面前，押沙龙向他说：「亚希多弗是如此如此说的，我们照着他的话行可以不可以？若不可，你就说吧！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S217_7","011_17_7","2SA","17","7","7","户筛对押沙龙说：「亚希多弗这次所定的谋不善。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S217_8","011_17_8","2SA","17","8","8","户筛又说：「你知道，你父亲和跟随他的人都是勇士，现在他们心里恼怒，如同田野丢崽子的母熊一般，而且你父亲是个战士，必不和民一同住宿。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S217_9","011_17_9","2SA","17","9","9","他现今或藏在坑中或在别处，若有人首先被杀，凡听见的必说：『跟随押沙龙的民被杀了。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S217_10","011_17_10","2SA","17","10","10","虽有人胆大如狮子，他的心也必消化；因为以色列人都知道你父亲是英雄，跟随他的人也都是勇士。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S217_11","011_17_11","2SA","17","11","11","依我之计，不如将以色列众人—从但直到别是巴，如同海边的沙那样多—聚集到你这里来，你也亲自率领他们出战。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S217_12","011_17_12","2SA","17","12","12","这样，我们在何处遇见他，就下到他那里，如同露水下在地上一般，连他带跟随他的人，一个也不留下。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S217_13","011_17_13","2SA","17","13","13","他若进了哪一座城，以色列众人必带绳子去，将那城拉到河里，甚至连一块小石头都不剩下。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S217_14","011_17_14","2SA","17","14","14","押沙龙和以色列众人说：「亚基人户筛的计谋比亚希多弗的计谋更好！」这是因耶和华定意破坏亚希多弗的良谋，为要降祸与押沙龙。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S217_15","011_17_15","2SA","17","15","15","户筛对祭司撒督和亚比亚他说： 「亚希多弗为押沙龙和以色列的长老所定的计谋是如此如此，我所定的计谋是如此如此。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S217_16","011_17_16","2SA","17","16","16","现在你们要急速打发人去，告诉大卫说：『今夜不可住在旷野的渡口，务要过河，免得王和跟随他的人都被吞灭。』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S217_17","011_17_17","2SA","17","17","17","那时，约拿单和亚希玛斯在隐·罗结那里等候，不敢进城，恐怕被人看见。有一个使女出来，将这话告诉他们，他们就去报信给大卫王。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S217_18","011_17_18","2SA","17","18","18","然而有一个童子看见他们，就去告诉押沙龙。他们急忙跑到巴户琳某人的家里；那人院中有一口井，他们就下到井里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S217_19","011_17_19","2SA","17","19","19","那家的妇人用盖盖上井口，又在上头铺上碎麦，事就没有泄漏。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S217_20","011_17_20","2SA","17","20","20","押沙龙的仆人来到那家，问妇人说：「亚希玛斯和约拿单在哪里？」妇人说：「他们过了河了。」仆人找他们，找不着，就回耶路撒冷去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S217_21","011_17_21","2SA","17","21","21","他们走后，二人从井里上来，去告诉大卫王说：「亚希多弗如此如此定计害你，你们务要起来，快快过河。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S217_22","011_17_22","2SA","17","22","22","于是大卫和跟随他的人都起来，过约旦河。到了天亮，无一人不过约旦河的。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S217_23","011_17_23","2SA","17","23","23","亚希多弗见不依从他的计谋，就备上驴，归回本城；到了家，留下遗言，便吊死了，葬在他父亲的坟墓里。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S217_24","011_17_24","2SA","17","24","24","大卫到了玛哈念，押沙龙和跟随他的以色列人也都过了约旦河。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S217_25","011_17_25","2SA","17","25","25","押沙龙立亚玛撒作元帅，代替约押。亚玛撒是以实玛利人以特拉的儿子。以特拉曾与拿辖的女儿亚比该亲近；这亚比该与约押的母亲洗鲁雅是姊妹。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S217_26","011_17_26","2SA","17","26","26","押沙龙和以色列人都安营在基列地。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S217_27","011_17_27","2SA","17","27","27","大卫到了玛哈念，亚扪族的拉巴人拿辖的儿子朔比，罗·底巴人亚米利的儿子玛吉，基列的罗基琳人巴西莱， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S217_28","011_17_28","2SA","17","28","28","带着被、褥、盆、碗、瓦器、小麦、大麦、麦面、炒谷、豆子、红豆、炒豆、 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S217_29","011_17_29","2SA","17","29","29","蜂蜜、奶油、绵羊、奶饼，供给大卫和跟随他的人吃；他们说：「民在旷野，必饥渴困乏了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S218_1","011_18_1","2SA","18","1","1","大卫数点跟随他的人，立千夫长、百夫长率领他们。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S218_2","011_18_2","2SA","18","2","2","大卫打发军兵出战，分为三队：一队在约押手下，一队在洗鲁雅的儿子、约押兄弟亚比筛手下，一队在迦特人以太手下。大卫对军兵说：「我必与你们一同出战。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S218_3","011_18_3","2SA","18","3","3","军兵却说：「你不可出战。若是我们逃跑，敌人必不介意；我们阵亡一半，敌人也不介意。因为你一人强似我们万人，你不如在城里预备帮助我们。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S218_4","011_18_4","2SA","18","4","4","王向他们说：「你们以为怎样好，我就怎样行。」于是王站在城门旁，军兵或百或千地挨次出去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S218_5","011_18_5","2SA","18","5","5","王嘱咐约押、亚比筛、以太说：「你们要为我的缘故宽待那少年人押沙龙。」王为押沙龙嘱咐众将的话，兵都听见了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S218_6","011_18_6","2SA","18","6","6","兵就出到田野迎着以色列人，在以法莲树林里交战。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S218_7","011_18_7","2SA","18","7","7","以色列人败在大卫的仆人面前；那日阵亡的甚多，共有二万人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S218_8","011_18_8","2SA","18","8","8","因为在那里四面打仗，死于树林的比死于刀剑的更多。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S218_9","011_18_9","2SA","18","9","9","押沙龙偶然遇见大卫的仆人。押沙龙骑着骡子，从大橡树密枝底下经过，他的头发被树枝绕住，就悬挂起来，所骑的骡子便离他去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S218_10","011_18_10","2SA","18","10","10","有个人看见，就告诉约押说：「我看见押沙龙挂在橡树上了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S218_11","011_18_11","2SA","18","11","11","约押对报信的人说：「你既看见他，为什么不将他打死落在地上呢？你若打死他，我就赏你十舍客勒银子，一条带子。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S218_12","011_18_12","2SA","18","12","12","那人对约押说：「我就是得你一千舍客勒银子，我也不敢伸手害王的儿子；因为我们听见王嘱咐你和亚比筛并以太说：『你们要谨慎，不可害那少年人押沙龙。』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S218_13","011_18_13","2SA","18","13","13","我若妄为害了他的性命，就是你自己也必与我为敌（原来，无论何事都瞒不过王。）」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S218_14","011_18_14","2SA","18","14","14","约押说：「我不能与你留连。」约押手拿三杆短枪，趁押沙龙在橡树上还活着，就刺透他的心。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S218_15","011_18_15","2SA","18","15","15","给约押拿兵器的十个少年人围绕押沙龙，将他杀死。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S218_16","011_18_16","2SA","18","16","16","约押吹角，拦阻众人，他们就回来，不再追赶以色列人。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S218_17","011_18_17","2SA","18","17","17","他们将押沙龙丢在林中一个大坑里，上头堆起一大堆石头。以色列众人都逃跑，各回各家去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S218_18","011_18_18","2SA","18","18","18","押沙龙活着的时候，在王谷立了一根石柱，因他说：「我没有儿子为我留名。」他就以自己的名称那石柱叫押沙龙柱，直到今日。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S218_19","011_18_19","2SA","18","19","19","撒督的儿子亚希玛斯说：「容我跑去，将耶和华向仇敌给王报仇的信息报与王知。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S218_20","011_18_20","2SA","18","20","20","约押对他说：「你今日不可去报信，改日可以报信；因为今日王的儿子死了，所以你不可去报信。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S218_21","011_18_21","2SA","18","21","21","约押对古示人说：「你去将你所看见的告诉王。」古示人在约押面前下拜，就跑去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S218_22","011_18_22","2SA","18","22","22","撒督的儿子亚希玛斯又对约押说：「无论怎样，求你容我随着古示人跑去。」约押说：「我儿，你报这信息，既不得赏赐，何必要跑去呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S218_23","011_18_23","2SA","18","23","23","他又说：「无论怎样，我要跑去。」约押说：「你跑去吧！」亚希玛斯就从平原往前跑，跑过古示人去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S218_24","011_18_24","2SA","18","24","24","大卫正坐在城瓮里。守望的人上城门楼的顶上，举目观看，见有一个人独自跑来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S218_25","011_18_25","2SA","18","25","25","守望的人就大声告诉王。王说：「他若独自来，必是报口信的。」那人跑得渐渐近了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S218_26","011_18_26","2SA","18","26","26","守望的人又见一人跑来，就对守城门的人说：「又有一人独自跑来。」王说：「这也必是报信的。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S218_27","011_18_27","2SA","18","27","27","守望的人说：「我看前头人的跑法，好像撒督的儿子亚希玛斯的跑法一样。」王说：「他是个好人，必是报好信息。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S218_28","011_18_28","2SA","18","28","28","亚希玛斯向王呼叫说：「平安了！」就在王面前脸伏于地叩拜，说：「耶和华—你的　神是应当称颂的，因他已将那举手攻击我主我王的人交给王了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S218_29","011_18_29","2SA","18","29","29","王问说：「少年人押沙龙平安不平安？」亚希玛斯回答说：「约押打发王的仆人，那时仆人听见众民大声喧哗，却不知道是什么事。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S218_30","011_18_30","2SA","18","30","30","王说：「你退去，站在旁边。」他就退去，站在旁边。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S218_31","011_18_31","2SA","18","31","31","古示人也来到，说：「有信息报给我主我王！耶和华今日向一切兴起攻击你的人给你报仇了。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S218_32","011_18_32","2SA","18","32","32","王问古示人说：「少年人押沙龙平安不平安？」古示人回答说：「愿我主我王的仇敌，和一切兴起要杀害你的人，都与那少年人一样。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S218_33","011_18_33","2SA","18","33","33","王就心里伤恸，上城门楼去哀哭，一面走一面说：「我儿押沙龙啊！我儿，我儿押沙龙啊！我恨不得替你死，押沙龙啊，我儿！我儿！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S219_1","011_19_1","2SA","19","1","1","有人告诉约押说：「王为押沙龙哭泣悲哀。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S219_2","011_19_2","2SA","19","2","2","众民听说王为他儿子忧愁，他们得胜的欢乐却变成悲哀。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S219_3","011_19_3","2SA","19","3","3","那日众民暗暗地进城，就如败阵逃跑、惭愧的民一般。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S219_4","011_19_4","2SA","19","4","4","王蒙着脸，大声哭号说：「我儿押沙龙啊！押沙龙，我儿，我儿啊！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S219_5","011_19_5","2SA","19","5","5","约押进去见王，说：「你今日使你一切仆人脸面惭愧了！他们今日救了你的性命和你儿女妻妾的性命， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S219_6","011_19_6","2SA","19","6","6","你却爱那恨你的人，恨那爱你的人。你今日明明地不以将帅、仆人为念。我今日看明，若押沙龙活着，我们都死亡，你就喜悦了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S219_7","011_19_7","2SA","19","7","7","现在你当出去，安慰你仆人的心。我指着耶和华起誓：你若不出去，今夜必无一人与你同在一处；这祸患就比你从幼年到如今所遭的更甚！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S219_8","011_19_8","2SA","19","8","8","于是王起来，坐在城门口。众民听说王坐在城门口，就都到王面前。 以色列人已经逃跑，各回各家去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S219_9","011_19_9","2SA","19","9","9","以色列众支派的人纷纷议论说：「王曾救我们脱离仇敌的手，又救我们脱离非利士人的手，现在他躲避押沙龙逃走了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S219_10","011_19_10","2SA","19","10","10","我们膏押沙龙治理我们，他已经阵亡。现在为什么不出一言请王回来呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S219_11","011_19_11","2SA","19","11","11","大卫王差人去见祭司撒督和亚比亚他，说：「你们当向犹大长老说：『以色列众人已经有话请王回宫，你们为什么落在他们后头呢？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("S219_12","011_19_12","2SA","19","12","12","你们是我的弟兄，是我的骨肉，为什么在人后头请王回来呢？』 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S219_13","011_19_13","2SA","19","13","13","也要对亚玛撒说：『你不是我的骨肉吗？我若不立你替约押常作元帅，愿　神重重地降罚与我！』」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S219_14","011_19_14","2SA","19","14","14","如此就挽回犹大众人的心，如同一人的心。他们便打发人去见王，说：「请王和王的一切臣仆回来。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S219_15","011_19_15","2SA","19","15","15","王就回来，到了约旦河。犹大人来到吉甲，要去迎接王，请他过约旦河。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S219_16","011_19_16","2SA","19","16","16","巴户琳的便雅悯人、基拉的儿子示每急忙与犹大人一同下去迎接大卫王。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S219_17","011_19_17","2SA","19","17","17","跟从示每的有一千便雅悯人，还有扫罗家的仆人洗巴和他十五个儿子，二十个仆人；他们都趟过约旦河迎接王。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S219_18","011_19_18","2SA","19","18","18","有摆渡船过去，渡王的家眷，任王使用。 王要过约旦河的时候，基拉的儿子示每就俯伏在王面前， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S219_19","011_19_19","2SA","19","19","19","对王说：「我主我王出耶路撒冷的时候，仆人行悖逆的事，现在求我主不要因此加罪与仆人，不要记念，也不要放在心上。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S219_20","011_19_20","2SA","19","20","20","仆人明知自己有罪，所以约瑟全家之中，今日我首先下来迎接我主我王。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S219_21","011_19_21","2SA","19","21","21","洗鲁雅的儿子亚比筛说：「示每既咒骂耶和华的受膏者，不应当治死他吗？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S219_22","011_19_22","2SA","19","22","22","大卫说：「洗鲁雅的儿子，我与你们有何关涉，使你们今日与我反对呢？今日在以色列中岂可治死人呢？我岂不知今日我作以色列的王吗？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S219_23","011_19_23","2SA","19","23","23","于是王对示每说：「你必不死。」王就向他起誓。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S219_24","011_19_24","2SA","19","24","24","扫罗的孙子米非波设也下去迎接王。他自从王去的日子，直到王平平安安地回来，没有修脚，没有剃胡须，也没有洗衣服。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S219_25","011_19_25","2SA","19","25","25","他来到耶路撒冷迎接王的时候，王问他说：「米非波设，你为什么没有与我同去呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S219_26","011_19_26","2SA","19","26","26","他回答说：「我主我王，仆人是瘸腿的。那日我想要备驴骑上，与王同去，无奈我的仆人欺哄了我， ");
INSERT INTO cmn_cu89s_vpl VALUES ("S219_27","011_19_27","2SA","19","27","27","又在我主我王面前谗毁我。然而我主我王如同　神的使者一般，你看怎样好，就怎样行吧！ ");
INSERT INTO cmn_cu89s_vpl VALUES ("S219_28","011_19_28","2SA","19","28","28","因为我祖全家的人，在我主我王面前都算为死人，王却使仆人在王的席上同人吃饭，我现在向王还能辨理诉冤吗？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S219_29","011_19_29","2SA","19","29","29","王对他说：「你何必再提你的事呢？我说，你与洗巴均分地土。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S219_30","011_19_30","2SA","19","30","30","米非波设对王说：「我主我王既平平安安地回宫，就任凭洗巴都取了也可以。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S219_31","011_19_31","2SA","19","31","31","基列人巴西莱从罗基琳下来，要送王过约旦河，就与王一同过了约旦河。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S219_32","011_19_32","2SA","19","32","32","巴西莱年纪老迈，已经八十岁了。王住在玛哈念的时候，他就拿食物来供给王；他原是大富户。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S219_33","011_19_33","2SA","19","33","33","王对巴西莱说：「你与我同去，我要在耶路撒冷那里养你的老。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S219_34","011_19_34","2SA","19","34","34","巴西莱对王说：「我在世的年日还能有多少，使我与王同上耶路撒冷呢？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("S219_35","011_19_35","2SA","19","35","35","仆人现在八十岁了，还能尝出饮食的滋味、辨别美恶吗？还能听男女歌唱的声音吗？仆人何必累赘我主我王呢？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("S219_36","011_19_36","2SA","19","36","36","仆人只要送王过约旦河，王何必赐我这样的恩典呢？ ");
INSERT INTO cmn_cu89s_vpl VALUES ("S219_37","011_19_37","2SA","19","37","37","求你准我回去，好死在我本城，葬在我父母的墓旁。这里有王的仆人金罕，让他同我主我王过去，可以随意待他。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S219_38","011_19_38","2SA","19","38","38","王说：「金罕可以与我同去，我必照你的心愿待他。你向我求什么，我都必为你成就。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S219_39","011_19_39","2SA","19","39","39","于是众民过约旦河，王也过去。王与巴西莱亲嘴，为他祝福，巴西莱就回本地去了。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S219_40","011_19_40","2SA","19","40","40","王过去，到了吉甲，金罕也跟他过去。犹大众民和以色列民的一半也都送王过去。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S219_41","011_19_41","2SA","19","41","41","以色列众人来见王，对他说：「我们弟兄犹大人为什么暗暗送王和王的家眷，并跟随王的人过约旦河？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S219_42","011_19_42","2SA","19","42","42","犹大众人回答以色列人说：「因为王与我们是亲属，你们为何因这事发怒呢？我们吃了王的什么呢？王赏赐了我们什么呢？」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S219_43","011_19_43","2SA","19","43","43","以色列人回答犹大人说：「按支派，我们与王有十分的情分；在大卫身上，我们也比你们更有情分。你们为何藐视我们，请王回来不先与我们商量呢？」 但犹大人的话比以色列人的话更硬。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S220_1","011_20_1","2SA","20","1","1","在那里恰巧有一个匪徒，名叫示巴，是便雅悯人比基利的儿子。他吹角，说：「我们与大卫无分，与耶西的儿子无涉。以色列人哪，你们各回各家去吧！」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S220_2","011_20_2","2SA","20","2","2","于是以色列人都离开大卫，跟随比基利的儿子示巴。但犹大人从约旦河直到耶路撒冷，都紧紧跟随他们的王。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S220_3","011_20_3","2SA","20","3","3","大卫王来到耶路撒冷，进了宫殿，就把从前留下看守宫殿的十个妃嫔禁闭在冷宫，养活她们，不与她们亲近。她们如同寡妇被禁，直到死的日子。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S220_4","011_20_4","2SA","20","4","4","王对亚玛撒说：「你要在三日之内将犹大人招聚了来，你也回到这里来。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S220_5","011_20_5","2SA","20","5","5","亚玛撒就去招聚犹大人，却耽延过了王所限的日期。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S220_6","011_20_6","2SA","20","6","6","大卫对亚比筛说：「现在恐怕比基利的儿子示巴加害于我们比押沙龙更甚。你要带领你主的仆人追赶他，免得他得了坚固城，躲避我们。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S220_7","011_20_7","2SA","20","7","7","约押的人和基利提人、比利提人，并所有的勇士，都跟着亚比筛，从耶路撒冷出去追赶比基利的儿子示巴。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S220_8","011_20_8","2SA","20","8","8","他们到了基遍的大磐石那里，亚玛撒来迎接他们。那时约押穿着战衣，腰束佩刀的带子，刀在鞘内；约押前行，刀从鞘内掉出来。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S220_9","011_20_9","2SA","20","9","9","约押左手拾起刀来，对亚玛撒说：「我兄弟，你好啊！」就用右手抓住亚玛撒的胡子，要与他亲嘴。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S220_10","011_20_10","2SA","20","10","10","亚玛撒没有防备约押手里所拿的刀；约押用刀刺入他的肚腹，他的肠子流在地上，没有再刺他，就死了。 约押和他兄弟亚比筛往前追赶比基利的儿子示巴。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S220_11","011_20_11","2SA","20","11","11","有约押的一个少年人站在亚玛撒尸身旁边，对众人说：「谁喜悦约押，谁归顺大卫，就当跟随约押去。」 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S220_12","011_20_12","2SA","20","12","12","亚玛撒在道路上滚在自己的血里。那人见众民经过都站住，就把亚玛撒的尸身从路上挪到田间，用衣服遮盖。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S220_13","011_20_13","2SA","20","13","13","尸身从路上挪移之后，众民就都跟随约押去追赶比基利的儿子示巴。 ");
INSERT INTO cmn_cu89s_vpl VALUES ("S220_14","01