﻿USE sofia;
DROP TABLE IF EXISTS sofia.cmeNT_vpl;
CREATE TABLE cmeNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cmeNT_vpl WRITE;
INSERT INTO cmeNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yesu-Kirsa bĩncuɔmbaŋ cuu ba-naa dumaa ku yaa daaku: Yesu-Kirsa hilaa *Davidi hãayɛ̃lmba-na. Davidi fuɔ u hel *Abiramu hãayɛ̃lmba-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abiramu siire da *Isaki. Isaki sire da *Yakɔbu. Yakɔbu sire da *Yuda a naara bisãlmba namba. ");
INSERT INTO cmeNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda sire da Perɛsi baa Sera. Bisãlŋ daaba nyu‑i ba taa ba bĩ-yo Tamar. Perɛsi sire da Esirɔmu. Esirɔmu sire da Aramu. ");
INSERT INTO cmeNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aramu sire da Aminadabu. Aminadabu sire da Naacũɔŋo. Naacũɔ sire da Salmɔ. ");
INSERT INTO cmeNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmɔ sire da Bosi. Bosi nyu‑i ba taa ba bĩ-yo Araabu. Bosi sire da Obɛdi. Obɛdi nyu‑i ba taa ba bĩ-yo Uruti. Obɛdi sire da Yese. ");
INSERT INTO cmeNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yese sire da Davidi. Davidi faŋo yaa juɔ ce nellentieŋo‑i. Fuɔ sire da *Salomɔ. Salomɔ nyu‑i, Uri ciɛŋo'i waa. ");
INSERT INTO cmeNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomɔ sire da Orobamu. Orobamu sire da Abiya. Abiya sire da Asa. ");
INSERT INTO cmeNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa sire da Yosafa. Yosafa sire da Yoramu. Yoramu sire da Osiyasi. ");
INSERT INTO cmeNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Osiyasi sire da Yotamu. Yotamu sire da Akasi. Akasi sire da Esekiyasi. ");
INSERT INTO cmeNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esekiyasi sire da Manase. Manase sire da Amɔ. Amɔ sire da Yosiyasi. ");
INSERT INTO cmeNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosiyasi sire da Yekoniya a naara bisãlmba namba. Huɔŋgu faŋgu'i nuɔ‑i baŋ bilaa *Isirahɛl-baamba‑i kã baa-ba *Babilɔni‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Baŋ kãa Babilɔni‑i-na, Yekoniya wuɔ ka da Salatiɛl. Salatiɛl sire da Sorobabɛl. ");
INSERT INTO cmeNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Sorobabɛl sire da Abiyudi. Abiyudi sire da Elakimu. Elakimu sire da Asɔr. ");
INSERT INTO cmeNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asɔr sire da Sadɔki. Sadɔki sire da Akimu. Akimu sire da Eludi. ");
INSERT INTO cmeNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eludi sire da Elasar. Elasar sire da Matã. Matã sire da Yakɔbu. ");
INSERT INTO cmeNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakɔbu sire da Yosɛfu. Yosɛfu sire biɛ ciɛŋo. U ciɛŋo‑i ba taa ba bĩ-yo Maari. Maari faŋo yaa huɔŋ Yesu maŋ baŋ bĩŋ-yoŋ *Kirsa‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Kuu dii ŋaa a doŋ Abiramu‑i-na a ji hi Davidi‑i, tonaamba cĩncieluo ba naa‑i dii. Aa a doŋ Davidi‑i-na a ji hi baŋ bilaa *Isirahɛl-baamba‑i huɔŋgu maŋ nuɔ‑i, tonaamba cĩncieluo ba bi naa‑i dii. A doŋ huɔŋgu faŋgu-na, ji hi Kirsa homma‑i, tonaamba cĩncieluo ba bi naa‑i tiraa ba ye dii hɔlma-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesu-Kirsaŋ huɔŋ homma maŋ, ma yaa daama: U nyu‑i, Maari‑i, Yosɛfu yaa naa bel-o u dɔrŋo. Huɔŋgu naŋgu juɔ hi, *Diiloŋ-Yal diɛ ce kusũŋgu yiɛra Maari‑i-na. A ne da Yosɛfu saa naa hi suɔ-yo ciɛŋo yogo. ");
INSERT INTO cmeNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yosɛfu waa nelfɛfɛiŋo. Uŋ daa kusũŋguŋ yiɛraaya u dɔrŋo-na dumaaŋo-na, u sa taara u dii senserre yuɔ; wuɔ tuɔ taara u hiel u gboluoŋgu‑i u maama-na molo baa suɔ. ");
INSERT INTO cmeNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Uŋ diyaa mafamma‑i u huɔŋga-na, Itieŋo *dɔrpɔpuɔrbiloŋo naŋ wuɔ carra-yuɔ dãnsãaŋ-nu a waŋ baa-yo wuɔ: «Yosɛfu, *Davidi hãayɛ̃lŋ nuɔ, *Diiloŋ-Yalle yaa ciɛ kusũŋ daaku yiɛra Maari‑i-na; baa kãalã, biɛ-yo. ");
INSERT INTO cmeNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","U ka hoŋ naacombiloŋo. Duɔ hoŋ-yo, ŋ haa u yerre‑i Yesu; ku yuŋgu yaa wuɔ koŋkortieŋo. U yaa ka kor u nelleŋ-tobimba‑i ba ãmbabalma-na.» ");
INSERT INTO cmeNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Itieŋ uŋ ciɛ u *pɔpuɔrbiloŋo waŋ mamaŋ, ma'i sa ciɛŋ daama‑i wɛi? Pɔpuɔrbiloŋo waaŋ-ma wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«Bilonyɔnyuro ka ce kusũŋgu a hoŋ naacombiloŋo. Ba ka ta ba bĩ-yo Emaniɛl.» Ku yuŋgu yaa wuɔ Diiloŋo dii baa-ye. ");
INSERT INTO cmeNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yosɛfuŋ juɔ sire duɔfũmmu-na, wuɔ ce Itieŋo dɔrpɔpuɔrbiloŋ uŋ waaŋ mamaŋ baa-yo aa u dɔrŋo kãal jo ji tĩɛna baa-yo. ");
INSERT INTO cmeNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Maariŋ kãalãa jo, u juɔ bɔrɔ dumaa Yosɛfu saa suɔ-yo ciɛŋo. Uŋ buɔra, Yosɛfu wuɔ haa biloŋo yerre‑i Yesu. ");
INSERT INTO cmeNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesu huɔŋ Betelɛmu, dii *Yude mara nuɔ. Huɔŋgu faŋgu-na, *Erɔdi yaa waa *Yude yuŋgu-na. Uŋ huɔŋ, hiriemba namba waa bãpagũŋgu-na; baa sire a jo *Yerusalɛmu‑i-na ");
INSERT INTO cmeNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","a ji ta ba yuure u kũŋgu‑i wuɔ: «*Yuifu ba nellentieŋo maŋ huɔŋ fɛlɛmma‑i uu dii hie? I daa u mɔɛle‑i bãpagũŋgu-na ku'i ciɛ i sire tiɛ jo diɛ ji jaal-o.» ");
INSERT INTO cmeNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Erɔdiŋ nuɔ nel daama‑i, u huɔŋ kaa pãŋ cu ka hel baa Yerusalɛmutaamba‑i hiere. ");
INSERT INTO cmeNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Wuɔ bĩ *Diilojigãntaamba yuntaamba maŋ waa nelle-na hiere baa *ãnjĩnamma pigãataamba‑i a ji yuu-ba wuɔ: «Diiloŋ uŋ pãa nuŋgu‑i wuɔ u ka saaŋ *Koŋkortieŋo maŋ, u saaya u hoŋ terieŋ haku‑i nuɔ‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Baa cira: «U saaya u hoŋ Betelɛmu dii Yude mara nuɔ. *Diilopɔpuɔrbiloŋo nyɛgãaŋ ma yaa‑i wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‹Betelɛmutaaŋ namaa, baa na ta na ne wuɔ sĩ Yude nilɛiŋa-na hiere namaa nelle yaa huoŋ-nu dɛ! Umaŋ ka waa *Isirahɛl-baamba yuŋ-nu, umaŋ ka ta mi baamba yaaŋ-na tuɔ ne-ba, u ka hoŋ namaa nelle yaa nuɔ‑i.›» ");
INSERT INTO cmeNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Erɔdiŋ juɔ suɔ *Kirsa muŋhommuŋ-terieŋgu‑i, wuɔ cuo bĩ hirieŋ daaba‑i a ji yuu-ba suɔ mɔɛl daadeŋ duɔŋ ta di hel huɔŋgu maŋ nuɔ‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Uŋ juɔ yuu ba piiye tũnu-yuɔ, wuɔ cira: «Kãaŋ Betelɛmu‑i-na na ka yuure u kũŋgu‑i jeje na ne; da na ka da-yo, na jo na ji tũnu muɔŋo‑i mi bi kã ka jaal-o.» ");
INSERT INTO cmeNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Erɔdiŋ piiye baa-ba tĩ, baa sire ta ta ba kã Betelɛmu‑i-na. Ba'a ba ne, tiraa da mɔɛl daade‑i ba yaaŋga-na di wuɔ di kã. Baa ta ba nyaanu-diɛ. Diŋ kaa hi biloŋ uŋ waa terieŋgu maŋ nuɔ‑i, diɛ yiɛra ku yudɔrɔ‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ba hɔŋ muɔ gbuu pãŋ fɛ̃. ");
INSERT INTO cmeNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Baa har suur ka da biloŋo‑i baa u nyu‑i. Baa dũuna jaal-o aa naa fir ba coŋgorni‑i hiel sɛ̃nɛ hã-yo baa wusũnaŋo a naara *miir-namma. ");
INSERT INTO cmeNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Baŋ juɔ'a ba bir, Diiloŋ wuɔ piiye baa-ba dãnsãaŋ-nu wuɔ ba baa kã Erɔdi terieŋgu-na ka tũnu-yuɔ. Baa pãŋ biɛ ba deŋ hũmelle. ");
INSERT INTO cmeNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Hirieŋ baŋ taa, Itieŋo *dɔrpɔpuɔrbiloŋ wuɔ carra Yosɛfu‑i dãnsãaŋ-nu a waŋ baa-yo wuɔ: «Yosɛfu, *Erɔdi ka sire wuɔ u taara naacombiloŋo‑i ko-yo. Sire ŋ gbar baa-yo baa nyuŋo‑i hiere na ka tĩɛna Esipi. Da mi saa ji cira na jo, molo baa jo.» ");
INSERT INTO cmeNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Yosɛfu wuɔ bi sire isuɔŋgu faŋgu-na a biɛ naacombiloŋo‑i baa u nyu‑i hũu ŋ hã-mi! Esipi. ");
INSERT INTO cmeNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","U kãa ka tĩɛna kusuɔŋ-nu'i Erɔdi ji tuɔ ku. Itieŋ uŋ ciɛ u *pɔpuɔrbiloŋo waŋ nelma maŋ, ma'i sa juɔŋ daama‑i wɛi? Pɔpuɔrbiloŋo waaŋ-ma wuɔ: «Mi ciɛ mi biɛŋo hel Esipi‑i-na.» ");
INSERT INTO cmeNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","*Erɔdiŋ juɔ niya naa, wuɔ suɔ wuɔ hirieŋ daaba tãalãa-yo aa cor ba deŋ. U huɔŋ kaa gbuu pãŋ du. Wuɔ cira ba wuɔra ko naacombiemba maŋ saa cor bieŋa hãi yogo Betelɛmu‑i-na hiere baa nilɛiŋa maŋ u kɔtɔnni-na. Hiriemba naa pigãaŋ-yo huɔŋgu faŋgu yaa‑i wuɔ mɔɛle duɔŋ ta di hel. ");
INSERT INTO cmeNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","*Diiloŋ uŋ puɔraa *Seremi waŋ mamaŋ, ma'i saa ce daama‑i wɛi? Seremi waaŋ-ma wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«I nu molo kaal Arama‑i-na; kutieŋo kaal kuliiŋ-kaaluŋgu. Arasɛl yaa kaalaaŋ wuɔ ba kuɔ u bisãlmba. U sa nu gbɛ̃nyɛmma. U bisãlmba taa aa yaŋ-yo.» ");
INSERT INTO cmeNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","*Erɔdiŋ juɔ ku, Itieŋo *dɔrpɔpuɔrbiloŋo naŋ wuɔ carra Yosɛfu‑i dãnsãaŋ-nu dii Esipi‑i-na ");
INSERT INTO cmeNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","a waŋ baa-yo wuɔ: «Bamaŋ taa ba taara ba ko naacombiloŋo‑i ba kuu. Sire ŋ biɛ-yo baa nyuŋo‑i na bir na kã *Isirahɛl-na.» ");
INSERT INTO cmeNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yosɛfu wuɔ bi sire a biɛ naacombiloŋo‑i baa u nyu‑i ba bir kã Isirahɛl-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Erɔdi biɛŋo naŋo waa, ba taa ba bĩ-yo Arkelɔsi. Yosɛfuŋ kãa, wuɔ nu-ma wuɔ tuoŋ uŋ kuu, u yaa ciɛ nellentieŋo‑i *Yude‑i-na. Kor maa ta ma da Yosɛfu‑i u saa siɛ duɔ kã ka tĩɛna terieŋgu-na. Diiloŋ wuɔ piiye baa-yo dãnsãaŋ-nu wuɔ u kã u ka tĩɛna *Galile mara nuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Wuɔ kã ka tĩɛna Galile nelle nande-na ba bĩ-de Nasarɛti. *Diilopɔpuɔrbiemba waaŋ-ma wuɔ: «Ba ka ta ba bĩ *Koŋkortieŋo‑i Nasarɛtiyiɛŋo», ma bi ciɛ. ");
INSERT INTO cmeNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ku huoŋgu-na, *Nsãa-Batisi wuɔ ji sire tuɔ waŋ Diiloŋ-nelma‑i baa nuɔmba‑i dii *Yude *hĩɛkuraaŋgu-na. U taa u piiye wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","«Naanaŋ na cilɔbabalaŋo‑i, *Diiloŋ-bãaŋgu piyaa tĩ!» ");
INSERT INTO cmeNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Diiloŋo puɔraa *Isayi waŋ Nsãa fuɔ maama yaa wuɔ: «Molo dii tuɔ hohuola hĩɛkuraaŋgu-na wuɔ: ‹Migãaŋ Itieŋo hũmieŋa‑i Cãaŋ-yaŋ na viinu-yɛi.›» ");
INSERT INTO cmeNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Joŋgoruo maŋ waa Nsãa nuoŋgu-na, baa sũɔ-yo baa nyɔgɔ̃mɛkuɔsĩnni aa u taa u pɛ̃yɛ̃ u nɛgɛlle‑i baa cãanuŋ-kpãŋkpaaŋgu. U taa u wuo dũŋgbɛrmba baa sɔllu. ");
INSERT INTO cmeNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Yerusalɛmutaamba‑i baa Yudetaamba‑i hiere ka hel baa bamaŋ waa *Yurdɛ̃ nuoraaŋgu kɔtɔnni-na hiere ba taa ba kã u wulaa ");
INSERT INTO cmeNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ba kã ba waŋ ba cãlmuɔ‑i baa-yo aa u tuɔ *batiseŋ-ba Yurdɛ̃ nuoraaŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Nsãaŋ juɔ da *Farisĩɛbaa-ba‑i baa *Sadusĩɛbaa-ba kũɔl ba-naa ba jo u wulaa wuɔ u batiseŋ-ba, wuɔ gbɛ̃-ba wuɔ: «Nelbabalaaŋ namaa temma‑i daana‑i! Hai juɔ tũnu-nɛi wuɔ da na batiseŋ Diiloŋo siɛ ka gãŋ baa-na? ");
INSERT INTO cmeNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Yaaŋ aa na ta na ce kumaŋ faa, ku yaa ka pigãaŋ wuɔ na naana na cilɔbabalaŋo‑i kelkel. ");
INSERT INTO cmeNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Baa na da niɛ sĩ *Abiramuŋ yeŋ na bĩncɔiŋo Diiloŋo siɛ ka gãŋ baa-na. Mi tũnu-nɛi: Naŋ fiɛ da tãmpĩɛŋa maŋ daaya‑i, Diiloŋo gbãa bir-a ce-ya Abiramu hãayɛ̃lmba namaa fuoŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Maale nuŋgu saaraa jĩna. Tibiiŋgu maŋ da ku saa maŋ biefɛfɛiŋa, ku jũŋ aa sɛnu. ");
INSERT INTO cmeNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Muɔmi batiseŋ-na baa hũmma yoŋ da mi pigãaŋ wuɔ na naana na cilɔbabalaŋo‑i; ŋga molo ka jo mi huoŋgu-na. Kutieŋo fɔ̃ŋgũɔ jĩɛnya mɛi wuoŋo‑i. Mɛi saa piɛra u natãaŋgu‑i. Fuɔ ka batiseŋ-na baa *Diiloŋ-Yalle baa dãamu. ");
INSERT INTO cmeNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Kɔkɔruɔŋgu dii u naŋga-na. U ka pe u dĩmma‑i. Duɔ ji pe-ma tĩ hiere torre-na, u ka kũɔl belle‑i dii-de inɔŋgɔ̃-na aa sɛnu fuoru‑i baa dãamu. Dãamu fammu sa dĩŋ dede.» ");
INSERT INTO cmeNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Nsãa uŋ taa u *batiseŋ nuɔmba‑i huɔŋgu-na, Yesu wuɔ sire *Galile‑i-na a kã *Yurdɛ̃‑i-na u duɔ ka batiseŋ-yo. ");
INSERT INTO cmeNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Nsãa wuɔ ka muo jãŋ wuɔ fuɔ siɛ ce-ma. Aa naa tuɔ piiye baa-yo wuɔ: «Nuɔnɛi saaya ŋ batiseŋ muɔ, nuɔ da ŋ bir yaŋ aa jo wuɔ mɛi ji batiseŋ-ni, mi batiseŋ-ni niɛ?» ");
INSERT INTO cmeNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yesu wuɔ cira: «Diiloŋ uŋ'a ma ce dumaa, yaŋ i ce-ma dumɛi. Yaŋ aa ŋ ce-ma ŋaa miŋ waaŋ-ma dumaa.» Nsãa wuɔ naa wuɔ hũu-ma. ");
INSERT INTO cmeNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Baŋ juɔ batiseŋ Yesu‑i tĩ aa u hel hũmma-na, dɔrɔ wuɔ puur. Wuɔ u ne da *Diiloŋ-Yalle hilaa koŋhuruŋ temma jo ji diire-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Baa nu molo piiye dɔrɔ‑i-na wuɔ: «Mi Biɛŋo yaa daayo‑i; u maama sa suɔ aa dɔlnu-miɛ. U yaa fĩɛŋ mi huɔŋga‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ku huoŋgu-na, *Diiloŋ-Yalle kã baa Yesu‑i *hĩɛkuraaŋgu-na *Sitãni duɔ ka guɔl u gbeini‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Uŋ kãa, wuɔ ce bãaŋ-yinni komuɔŋa hãi baa isuɔyinni komuɔŋa hãi u saa dii kuuwuoŋgu u nuŋgu-na. Yiŋ daaniŋ juɔ cor, nyulmu sire cuɔl-o. ");
INSERT INTO cmeNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Sitãni wuɔ jo ji waŋ baa-yo wuɔ: «Da kuɔ Diiloŋ-Biɛŋo yaa nuɔŋo‑i kelkel, ce tãmpĩɛŋ daaya bir niiwuoni i ne!» ");
INSERT INTO cmeNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yesu wuɔ cira: «Ma nyɛgãaŋ Diiloŋ-nelma-na wuɔ: ‹Niiwuoni‑i yoŋ, ni siɛ gbãa ce nɛliɛŋ nuɔ ŋ ba. Ŋ saaya ŋ bi ta ŋ nu Diiloŋo nuŋ-ãndaaŋgu‑i hiere naara.›» ");
INSERT INTO cmeNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Uŋ piiye dumaaŋo-na, Sitãni wuɔ kã baa-yo *Yerusalɛmu‑i-na, ka haa-yo *Diilodubuɔ dɔrɔ‑i-na ");
INSERT INTO cmeNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","aa naa cira: «Da kuɔ Diiloŋ-Biɛŋo yaa nuɔŋo‑i kelkel, tie ŋ diire i ne! Ma sĩ ma nyɛgãaŋ Diiloŋ-nelma-na wuɔ: ‹Diiloŋo ka ce *dɔrpɔpuɔrbiemba tũu-ni ba nammu-na ŋ baa ji tisĩŋ ŋ fɛrɛ› kɛ?» ");
INSERT INTO cmeNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu wuɔ cira: «Ma bi nyɛgãaŋ Diiloŋ-nelma-na wuɔ: ‹Baa dãŋ Itieŋo‑i Diiloŋo‑i ŋ ne.›» ");
INSERT INTO cmeNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Sitãni wuɔ tiraa kã baa-yo tãnuŋgu naŋgu dɔrɔ‑i-na, ku maama saa fa baa jajaatamma‑i, ka pigãaŋ-yo nilɛiŋa‑i hiere baa a huɔya-niini‑i ");
INSERT INTO cmeNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","aa naa cira: «Da ŋ dũuna jaal-mi, niŋ daa nilɛiŋa maŋ daaya‑i hiere mi ka hã-ni baa-ya.» ");
INSERT INTO cmeNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Uŋ waaŋ mafamma‑i, Yesu wuɔ cira: «Sitãni, kã ŋ filiɛŋ ŋ halaŋ! Ma nyɛgãaŋ Diiloŋ-nelma-na wuɔ: ‹Ŋ saaya ŋ ta ŋ dũuna ŋ jaal Itieŋo‑i Diiloŋo yaa‑i, aa ta ŋ cãa u yaa u diei yoŋ.›» ");
INSERT INTO cmeNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Sitãni wuɔ naa u ta aa yaŋ-yo. Uŋ taa, dɔrpɔpuɔrbiemba namba jo ji ta ba kãyã-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Huɔŋgu naŋgu juɔ hi, baa bel Nsãa‑i dii-yo kaso. Yesu wuɔ nu-ma aa bir kã *Galile‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Uŋ kãa, u saa ka tĩɛna Nasarɛti‑i-na, wuɔ kã ka tĩɛna Kafarnamu, dii dalaŋga caaŋgu-na. Terieŋgu faŋgu‑i, Sabulɔ̃ hĩɛma, fuɔ baa Nefutali. ");
INSERT INTO cmeNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Diiloŋ uŋ puɔraa *Isayi waŋ mamaŋ, ma'i sĩ daama‑i wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Isayi waaŋ-ma wuɔ: «Sabulɔ̃ hĩɛma-na, Nefutali nelle-na, dii dalaŋga caaŋgu-na, kã ka hel dii *Yurdɛ̃ nuoraaŋgu bomborma-na, a biɛ Galile‑i hiere, *niɛraamba nelle‑i, bamaŋ waa hiere kukulma-na, cecerma hilaa-bɛi. ");
INSERT INTO cmeNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Bamaŋ waa kukulmaŋ-nelle-na kuliiŋgu nammu-na, bãaŋgu paa-bɛi.» ");
INSERT INTO cmeNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Yesuŋ kãa dumaaŋo-na, wuɔ doŋ tuɔ waŋ Diiloŋ-nelma‑i baa nuɔmba‑i wuɔ: «Naanaŋ na cilɔbabalaŋo‑i, *Diiloŋ-bãaŋgu piyaa tĩ!» ");
INSERT INTO cmeNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yiiŋgu naŋgu-na, Yesu wuɔ ji tuɔ cor a da gbosobaa-ba namba naŋ juɔŋo *Galile dalaŋga-na. Ba waa ba hãi; nɛliɛŋo baa u hãaŋo. Ba bĩ mɔlŋo‑i Simɔ, u yerre nande yaa Piɛr, aa bĩ hãaŋo‑i Ãndere. ");
INSERT INTO cmeNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesu wuɔ gbɛ̃-ba wuɔ: «Juɔŋ i ta, mi ka ce-na nelbilieŋ-gbosobaa namaa.» ");
INSERT INTO cmeNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Baa bi pãŋ nanna ba jɔnaamba‑i aa cu Yesu huoŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ba'a ba kã yaaŋga-na, a tiraa da naacolŋo naŋo baa u hãaŋo a naara ba to. Ba bĩ tuoŋo‑i Sebede aa bĩ bɛpomɔlŋo‑i Sake aa hãaŋo‑i Nsãa. Ba waa beŋ-na ta ba migãaŋ ba jɔnaamba. Yesu wuɔ bĩ bɛpuɔmba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Bafaŋ baa tiraa nanna ba beŋo‑i baa ba to‑i aa cu u huoŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu taa u wuɔra *Galile‑i-na hiere u waŋ Diiloŋ-nelma‑i *Diilonelhãalãdũnni-na, aa tuɔ waŋ *Diiloŋ-bãaŋgu *Neldɔdɔlma‑i, aa bi tuɔ sire jaamba‑i ba sĩnni-na hiere u kã. ");
INSERT INTO cmeNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Siiritaamba‑i hiere baa nu u maama‑i ka saa. Baa ta ba jo baa jaamba‑i ba sĩnni-na hiere ba jo ba hã u tuɔ sire-bɛi. *Jĩnabaa-baŋ waa bamaŋ nuɔ‑i ba waa, kurmɔrɔ̃ntaamba waa, ka hel baa murgubaa-ba‑i hiere. Yesu wuɔ sire-bɛi kpɛ̃mmu! ");
INSERT INTO cmeNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Nuɔŋ baa sire kũɔl ba-naa ta ba nyaanu-yuɔ; Galiletaamba waa, a naara banamba naa hel Dekapol jo, banamba *Yerusalɛmu, banamba *Yude, banamba hel *Yurdɛ̃ bãpagũŋgu-na jo. ");
INSERT INTO cmeNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesuŋ daa nuɔmbaŋ kũɔlãa ba-naa ta ba nyaanu-yuɔ dumaaŋo-na, wuɔ kã ka nyugũŋ tãnuŋgu naŋgu-na tĩɛna. U *hãalãbieŋ baa jo ji cĩilã-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Wuɔ doŋ tuɔ piiye baa-ba wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Bamaŋ kaalaaŋ baa Diiloŋo‑i, ba yunni dɔlaa; *Diiloŋ-nelle‑i bafamba diele‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Bamaŋ dii kaaluŋgu-na, ba yunni dɔlaa; Diiloŋo ka hur ba nyinyɔlma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Hɔhĩnantaamba yunni dɔlaa; hĩɛma ka ce ba maama. ");
INSERT INTO cmeNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Bamaŋ kuuyeŋ kuuviiŋgu cemma‑i, ba yunni dɔlaa; ma ka dɔl-ba. ");
INSERT INTO cmeNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Hujarreŋ yeŋ bamaŋ nuɔ‑i, ba yunni dɔlaa; Diiloŋo ka bi ce hujarre bɛi. ");
INSERT INTO cmeNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Bamaŋ hɔmmu‑i kuɔŋ, ba yunni dɔlaa; ba ka da Diiloŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Bamaŋ fĩɛŋ ba muntĩɛnammu‑i, ba yunni dɔlaa; Diiloŋo ka tuɔ bĩ ba yaa u bisãlmba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Baŋ ceŋ bamaŋ kpãncɔ̃lgũɔ ba viisĩnni maama-na, ba yunni dɔlaa; Diiloŋ-nelle‑i bafamba diele‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","«Da ba ta ba tuora-nɛi, aa ta ba ce-na sũlma, aa haa balaaŋgu sĩnni‑i hiere nɛi mɛi maama-na, na yunni dɔlaa. ");
INSERT INTO cmeNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Taa na gbu na nyɛ aa na fɛ̃ na hɔmmu‑i; Diiloŋo ka pã-na bɔi dɔrɔ‑i-na. Na saa da, *Diilopɔpuɔrbiemba maŋ siire namaa yaaŋga-na, ba ciɛ-ba sũlma dumɛi.» ");
INSERT INTO cmeNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","«Namɛi dii dãmma‑i hĩɛma-na. Ŋga dãŋ da ma ji saara, ma gbãa tiraa ce niɛ ce kpɛ̃nnɛ? Ma siɛ gbãa fa wɛima; ba biɛ ka kũnna fuoreŋ. ");
INSERT INTO cmeNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","«Namɛi fitĩmbaa namaa hĩɛma-na. Na saa da, nelle maŋ da di waa tãnuŋ dɔrɔ, di sa fuo. ");
INSERT INTO cmeNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Na suyaa wuɔ ba sa celieŋ fitĩnuɔ‑i aa biɛ bĩŋkũŋgu cure-yuɔ. Ba haa-yo dɔrɔ terieŋgu ce hiere da gbaa. ");
INSERT INTO cmeNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Fitĩnuɔŋ ceŋ gbagbaama‑i dumaa, namaa na saaya na ta na ce gbagbaama‑i dumɛi nuɔmba hɔlma-na; ku yaa ba ka da na maacenfafamma‑i aa ta ba kaal na To‑i dɔrɔ‑i-na.» ");
INSERT INTO cmeNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Ku huoŋgu-na, Yesu wuɔ cira: «Baa na da niɛ sĩ *Moisi‑i baa *Diilopɔpuɔrbiembaŋ nyɛgãaŋ mamaŋ hã-na wuɔ na ta na ce, mi juɔ da mi ji gbuonu ma yaa‑i, ma'i sĩ. Mi juɔ da mi ji pigãaŋ-na nelma famma belle yaa‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Yaaŋ mi waŋ ninsoŋo‑i baa-na: Dɔrɔ‑i baa hĩɛma‑i da ni gbãŋ waa tĩ, nelma diei siɛ gbãa gbuo nel daama-na. Halle cɛkũɔ, ma siɛ gbãa gbuo, fuɔ miwaaŋo tĩmma. ");
INSERT INTO cmeNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Terieŋgu faŋgu-na, halle nelma maŋ yuraanu yaŋ nel daama-na, umaŋ duɔ saa wuɔ ma hũmelle‑i, aa tiraa ce banamba ce fuɔ temma‑i, u yaa ka waa huoŋgu-na *Diiloŋ-nelle-na. Ŋga umaŋ duɔ wuɔ ma hũmelle‑i, aa ce banamba ce fuɔ temma‑i, kutieŋo ka ce nelbuɔ Diiloŋ-nelle-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Mi tũnu-nɛi: Da na saa vii yaŋ *ãnjĩnamma pigãataamba‑i baa *Farisĩɛbaa-ba‑i, na cɛraa na suur Diiloŋ-nelle-na.» ");
INSERT INTO cmeNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«Naŋ siire, na nuɔ wuɔ ma waaŋ baa i bĩncuɔmba‑i wuɔ molo saa saaya u ko u nanolŋo. Da ŋ ko ŋ nanolŋo‑i ba saaya ba bĩ-ni fãamaaŋ ba terieŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ŋga ma miŋ ka waŋ mamaŋ baa-na ma yaa daama: Nuɔni maŋ da ŋ nyɔ ŋ nuoŋgu baa ŋ nanolŋo‑i, ba saaya ba bĩ-ni fãamaaŋ ba terieŋ-nu. Umaŋ duɔ tuora u nanolŋo‑i wuɔ mimilãŋo, ba ka bĩ kutieŋo‑i fãamaaŋ ba terieŋ-nu. Umaŋ duɔ bi gbɛ̃ u nanolŋo‑i wuɔ nelsɔsɔiŋo, ba ka caa kutieŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","A ce dumaaŋo-na, da ŋ fiɛ kã baa bĩŋkũŋgu da ŋ ka pã-ku hã Diiloŋo‑i, aa ka ne da wɛima dii nuɔ baa moloŋ hɔlma-na, ");
INSERT INTO cmeNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","yaŋ ku bĩŋkũŋgu‑i dii mumbuolmuŋ-terieŋgu caaŋgu-na aa ŋ jo na ji nunu na-naa baa kutieŋo‑i igɛ̃na aa ŋ suɔ ŋ kã ŋ ka pã-ku ŋ hã Diiloŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","«Moloŋ cɛ̃mɛl da di waa-niɛ aa wuɔ u ka bĩ-ni, gbãŋ baa-yo; baa yaŋ ãndaaŋgu hi fãamaambaa-ba‑i. Da ku hi-ba, ba ka hã fɔ̃ŋgɔ̃taamba‑i baa-ni, fɔ̃ŋgɔ̃taamba bel-ni ka dii-ni kaso. ");
INSERT INTO cmeNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Mi waŋ ninsoŋo‑i baa-ni: Da ba dii-ni kaso‑i-na, da ŋ saa ji pã ŋ cɛ̃mɛlle tĩ hiere, ŋ cɛraa ŋ da muŋhelmu.» ");
INSERT INTO cmeNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«Naŋ siire, na nuɔ ba ciɛra wuɔ ŋ saa saaya ŋ ce *fuocesĩnni. ");
INSERT INTO cmeNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ŋga ma miŋ ka waŋ mamaŋ baa-na ma yaa daama: Nuɔni maŋ da ŋ ne moloŋ ciɛŋo‑i baa yufelle nande, kuu dii ŋaa ŋ gaala baa-yo tĩ ŋ huɔŋga-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Terieŋgu faŋgu-na, da ŋ da ŋ nadieyufelle dii-ni kuubabalaaŋgu cemma-na, hiel-de ŋ fara ŋ nanna dii daalɛi. Da ŋ suur yufeduɔla nuɔ Diiloŋ-nelle-na, ku bɔyaa ba da ba ka caa-ni baa ŋ yufieŋa‑i a hãi‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Da ŋ da ŋ nadienaŋga dii-ni kuubabalaaŋgu cemma-na, kar-ka ŋ fara ŋ nanna dii daalɛi. Da ŋ suur nagãduɔla nuɔ Diiloŋ-nelle-na, ku bɔyaa ba da ba ka caa-ni baa ŋ nammu‑i mu hãi‑i-na.» ");
INSERT INTO cmeNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«Naŋ siire, na nuɔ ba ciɛra wuɔ: ‹Umaŋ duɔ nanna u ciɛŋo‑i, u saaya u nyɛgɛ̃ŋ sɛbɛ hã-yo. Sɛbɛ maŋ pigãaŋ wuɔ ba ãnsorre buɔra.› ");
INSERT INTO cmeNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ŋga ma miŋ ka waŋ mamaŋ baa-na ma yaa daama: Ciɛŋo maŋ duɔ u sa wuɔra u ce bɛmba, aa u bɔlɔ nanna-yuɔ, kuu dii ŋaa u diyaa-yo *fuocesĩnni-na. Aa da ba bi nanna ciɛŋo maŋ aa ŋ biɛ-yo, ŋ saa wuɔ Diiloŋ-hũmelle; ŋ ciɛ fuocesĩnni‑i dumaaŋo-na.» ");
INSERT INTO cmeNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«Naŋ siire, na nuɔ wuɔ ma waaŋ baa na bĩncuɔmba‑i wuɔ: ‹Da ŋ pã nuŋgu aa bĩ Diiloŋo yerre‑i wuɔ ŋ ka ce mamaŋ, ce-ma; baa yaŋ-ma.› ");
INSERT INTO cmeNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ŋga ma miŋ ka waŋ mamaŋ baa-na ma yaa daama: Molo baa tiraa u ce wɛima aa u bĩ Diiloŋo yerre‑i u nuŋgu-na gbula. Molo baa hiel u niele dɔrɔ‑i-na; Diiloŋ-muntĩɛnammu. ");
INSERT INTO cmeNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Molo baa bi hiel u niele hĩɛma-na; Diiloŋ gbeiniŋ-munjĩnammu. Molo baa bi cira fuɔ baa *Yerusalɛmu; Itieŋo nelle yaa difande‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Molo siɛ gbãa ce halle kuɔsĩŋgu diei pusũŋ u yuŋgu-na, u siɛ bi gbãa ce ku biil; terieŋgu faŋgu-na, molo baa bi cira fuɔ baa u yuŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Da ba yuu-na mamaŋ, da kuɔ ma yaa‑i, na cira: ‹Ũu, ma yaa‑i.› Da kuɔ ma'i sĩ, na cira: ‹E'e, ma'i sĩ.› Baa na cira: ‹Muɔ baa Diiloŋo mi saa ce daama‑i!› *Sitãni-nelma‑i mafamma‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","«Naŋ siire, na nuɔ ba ciɛra umaŋ duɔ muonu u nanolŋ yufelle, ba bi muonu kutieŋo diele‑i ku sɔlaaŋgu. Umaŋ duɔ ka u nanolŋ nyilãaŋgu, ba bi ka u kũŋgu‑i ku sɔlaaŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ŋga ma miŋ ka waŋ mamaŋ baa-na, ma yaa daama: Unaŋ nuɔ ŋ baa ji ce ŋ nanolŋo‑i kuubabalaaŋgu wuɔ ŋ suu sɔlaaŋgu. Umaŋ duɔ caa ŋ nadietũŋgu‑i, bir daaku‑i ŋ hã-yo. ");
INSERT INTO cmeNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Umaŋ duɔ u ka bĩ-ni fɔ̃ŋgɔ̃taaŋ-terieŋ-nu a hũu ŋ joŋgoryelle‑i, hã-yo baa-yo baa ŋ joŋgorbuɔ‑i hiere. ");
INSERT INTO cmeNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Fɔ̃ŋgɔ̃tieŋo maŋ duɔ haa coŋgoruoŋgu hã-ni wuɔ ŋ tũu saaŋ-yo cɛllɛ, saaŋ-yo ŋ maa baa-yo. ");
INSERT INTO cmeNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Umaŋ duɔ cãrã ŋ wulaa, hã-yo. Umaŋ duɔ jo wuɔ ŋ hor-o, baa balaŋ-yo.» ");
INSERT INTO cmeNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","«Naŋ siire, na nuɔ ba ciɛra wuɔ: ‹Ŋ saaya ŋ ta ŋ dɔl baa ŋ nanuɔmba‑i aa bigãaŋ ŋ bigãarãamba‑i.› ");
INSERT INTO cmeNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ŋga ma miŋ ka waŋ mamaŋ baa-na, ma yaa daama: Taa na dɔl baa na bigãarãamba‑i, taa na cãrã Diiloŋo‑i na hã bamaŋ ciɛŋ-naŋ kpãncɔ̃lgũɔ‑i, ");
INSERT INTO cmeNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ku yaa na ka waa na To‑i dɔrɔ‑i-na u bɛŋ namaa kelkel. U yaa hielaaŋ bãaŋgu‑i u hã nelbabalaamba‑i baa nelfafaamba‑i hiere aa bi tuɔ dãa u hã nelfafaamba‑i baa nelbabalaamba‑i hiere. ");
INSERT INTO cmeNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Da na ta na dɔl na dɔdɔltaamba yoŋ, yuŋ haku‑i dii-kuɔ? Halle nelbabalaamba gbã ba dɔl ba dɔdɔltaamba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Da na ta na fiɛlnu na jaal na sɔsuɔtaamba yoŋ, hai moloŋo‑i siɛ gbãa ce kufaŋgu‑i? Bamaŋ sa suyaaŋ Diiloŋo‑i ba sa ce-ku dii wɛi, aa ji da baa namaa? ");
INSERT INTO cmeNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Yaaŋ aa na ta na ce kumaŋ faa, ŋaa na To maŋ dɔrɔ‑i-na uŋ ceŋ dumaa.» ");
INSERT INTO cmeNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ku huoŋgu-na Yesu wuɔ cira: «Baa na ta na wuɔ na Diiloŋ-hũmelle‑i wuɔ nuɔmba da-na; da na ce mafamma‑i, na To‑i dɔrɔ‑i-na u siɛ ka pã-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Da ŋ da bĩŋkũŋgu da ŋ hã sũntieŋo‑i, baa ce ŋaa yetaarataambaŋ ceŋ dumaa *Diilonelhãalãdũnni-na baa nelleŋ-huɔŋga-na; ba taara nuɔmba da-ba aa cira bafamba faa. Mi waŋ ninsoŋo‑i baa-na: Bamaŋ ciɛŋ kufaŋgu‑i, ba daa ba maacemma sullu‑i tĩ. ");
INSERT INTO cmeNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ŋga da ŋ'a ŋ hã moloŋo‑i bĩŋkũŋgu‑i, hã-yo aa ŋ baa yaŋ halle ŋ jĩɛkpekpelŋo suɔ, ");
INSERT INTO cmeNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ku yaa ma siɛ hel bomborma-na. Niŋ ciɛ kumaŋ, ŋ To‑i Diilo fuɔ daa-ku, u ka pã-ni ku sɔlaaŋgu.» ");
INSERT INTO cmeNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«Da na'a na cãrã Diiloŋo‑i baa na ta na ce ŋaa yetaarataambaŋ ceŋ dumaa. Yetaarataaŋ da ba'a ba cãrã Diiloŋo‑i *Diilonelhãalãdũnni-na, halle baa nelleŋ-huɔŋga-na, ba sire yiɛra ba gbeiniŋ nuɔmba da ba da-ba. Mi waŋ ninsoŋo‑i baa-na: Bamaŋ ciɛŋ kufaŋgu‑i, ba daa ba maacemma sullu‑i tĩ. ");
INSERT INTO cmeNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Da ŋ'a ŋ cãrã Diiloŋo‑i, suur dũŋ-nu aa ŋ bĩŋ-ku ŋ fɛrɛŋ nuɔ, ŋ To dii terieŋgu faŋgu-na, cãrã-yuɔ. Niŋ fuyaa ta ŋ ce kumaŋ u daa-ni, u ka pã-ni. ");
INSERT INTO cmeNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","«Da na ta na cãrã Diiloŋo‑i, baa na ta na piiye pirri ŋaa bamaŋ sa suyaaŋ Diiloŋo‑i baŋ ceŋ dumaa. Bafamba daa niɛ sĩ da ba piiye agaga ku yaa Diiloŋo ka nu ba nuŋgu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Baa na suur ba nallu-na. Na saa da, namaaŋo‑i, aa na suɔ da na puur na nunni‑i da na cãrã, na To suyaa kumaŋ maama‑i dii-nɛi tĩ.» ");
INSERT INTO cmeNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","«Taa na cãrã Diiloŋo‑i dumandɛ: ‹I To nuɔni maŋ dii dɔrɔ‑i-na, yaŋ nuɔmba‑i hiere ba suɔ wuɔ nuɔnɛi Diiloŋ nuɔŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Pa ŋ bãaŋgu‑i yiɛ. Ŋ huɔŋgaŋ ceŋ dumaa dɔrɔ‑i-na, yaŋ ka ta ka ce dumɛi hĩɛma-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Hã-ye nyuŋgo ku niiwuoni‑i i wuo. ");
INSERT INTO cmeNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ce jande yiɛ ŋaa miɛ iŋ ceŋ jande‑i dumaa bamaŋ cãlãaŋ-yeŋ. ");
INSERT INTO cmeNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Baa yaŋ wɛima gbãa tãal-e dii-ye kuubabalaaŋgu cemma-na. Hũu-ye *Bigãarãŋo nyisɛ̃nni-na. Fɔ̃ŋgũɔ dii baa nuɔnɛi hɔnni-na hiere baa himma‑i aa ŋ tiraa waa bɔi.› ");
INSERT INTO cmeNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","«Na saa da, moloŋ duɔ cãl-ni aa ŋ yaŋ ma tĩ, nuɔ da ŋ bi cãl ŋ To‑i dɔrɔ‑i-na, u ka bi yaŋ ma tĩ. ");
INSERT INTO cmeNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ŋga namaa da na'a na siɛ yaŋ banamba maama tĩ, na To ce niɛ aa yaŋ namaa maama tĩ u huɔŋga-na?» ");
INSERT INTO cmeNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«Da na dii sũŋgu‑i, baa na vãa na yammu‑i ŋaa yetaarataambaŋ ceŋ dumaa. Yetaarataaŋ da ba dii sũŋgu‑i, ba vãa ba yammu‑i nuɔmba da ba suɔ wuɔ bafamba diyaa sũŋgu. Mi waŋ ninsoŋo‑i baa-na: Bamaŋ ciɛŋ kufaŋgu‑i, ba daa ba maacemma sullu‑i tĩ. ");
INSERT INTO cmeNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ŋga da ŋ dii sũŋgu‑i, saar ŋ yaaŋga‑i da welewele aa ŋ migãaŋ ŋ yukuɔsĩnni‑i fafamma, ");
INSERT INTO cmeNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ku yaa molo siɛ suɔ wuɔ ŋ diyaa sũŋgu. Ŋga ŋ To maŋ fuyaa, u yaa ka suɔ u diei yoŋ. U da mamaŋ fuyaa hiere. U ka pã-ni.» ");
INSERT INTO cmeNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«Baa na ta na gbagbarra miwaaŋ daayo wɛisĩnni huoŋ-nu. Na saa da, nyɛiŋo dii, gbɛ̃llũɔ bi dii a naara cuobaa-ba bi dii ta ba kanu dũnni‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Yaaŋ aa na ta na taara dɔr-niini yaa‑i. Nyɛiŋo si dii terieŋgu-na duɔ ji wuo-ni, gbɛ̃llũɔ si dii, cuobaa-ba bi si dii. ");
INSERT INTO cmeNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Na saa da, nɛliɛŋ nuɔ da ŋ tiera kusuɔŋ-nu, ŋ huɔŋga dii kusuɔŋ-nu'i.» ");
INSERT INTO cmeNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«Nɛliɛŋ nuɔ ŋ yufieŋa yaa ŋ fɛrɛŋ kerre fitĩnuɔ‑i. Ŋ yufieŋ da a fa, ŋ waa cecerma-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ŋga ŋ yufieŋ da a saa fa, ŋ waa kukulma-na. Kumaŋ ciɛŋ cecerma‑i ku hã nuɔ, da ku dĩŋ aa yaŋ-ni, ŋ ce niɛ ŋ siɛ waa kukulberre-na?» ");
INSERT INTO cmeNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Ku huoŋgu-na, Yesu wuɔ cira: «Nɛliɛ siɛ gbãa tuɔ cãa nuɔmba hãi. Ŋ ka da u bigãaŋ u diei aa dɔl u diei; u ka waa baa u diei aa cĩina u diei. Ku yaa ŋaa namaa kũŋgu‑i, na siɛ gbãa ta na kuye Diiloŋo‑i aa bi ta na kuye gbeiŋa‑i terduɔŋgu faŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","«Baa na ta na tie holle baa na niiwuoniŋ-kũŋgu‑i baa na niidiiniŋ-kũŋgu‑i. Nɛliɛŋ nuɔ ŋ yuŋgu saa buɔ niiwuoni-na wɛi? Aa ŋ kũɔma saa buɔ niidiini-na wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Niɛŋ huriimba‑i dɔrɔ‑i-na, ba sa guona, aa inɔŋgɔ̃baa-ba sĩ baa-ba, ŋga na To‑i dɔrɔ‑i-na u hã ba ta ba wuo. Namaa saa buɔ huriimba-na titirre wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Namaaŋo-na, hai moloŋo‑i baa u hɔculle‑i u gbãa naara kunaŋgu u yinni-na? ");
INSERT INTO cmeNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Mafammaŋ yaraa-na, bige‑i ciɛ na hɔmmu ta mu cu baa na niidiiniŋ-kũŋgu‑i? Na sa ne hĩɛŋguŋ puŋ fafamma dumaa wɛi? Ku sa bi ce maacemma, ku sa bi sũ joŋgorbaa. ");
INSERT INTO cmeNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Mi tũnu-nɛi: *Salomɔ‑i baa u wɛisĩnni‑i hiere u saa ji dii kompaŋga maŋ faa yii baa pũlma‑i dede. ");
INSERT INTO cmeNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Hĩɛŋgu maŋ hĩɛŋgu, Diiloŋ duɔ diiya-kuɔ fafamma nyuŋgo‑i-na diiyaŋ daama temma‑i, aa bisĩnuɔ dãamu waa da mu caa-ku, namaa namaŋ nelbilieŋ namaa, u ka diiya-nɛi ka hi hie? Na saa haa na naŋga‑i Diiloŋo-na ku haama. ");
INSERT INTO cmeNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Baa na ta na cira: ‹I ka wuo bige‑i? I ka nyɔŋ bige‑i? I ka dii bige‑i?› ");
INSERT INTO cmeNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Bamaŋ sa suyaaŋ Diiloŋo‑i, ba yaa gbagbaraayaŋ nifanni huoŋ-nu. Ŋga namaa To‑i dɔrɔ‑i-na, u suyaa wuɔ ni maama dii-nɛi. ");
INSERT INTO cmeNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Yaaŋ *Diiloŋ-nelle maama yaa yu na hɔmmu‑i igɛ̃na aa na ta na ce u huɔŋga‑i, na ka da u hãa-na baa daani‑i hiere naara. ");
INSERT INTO cmeNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Yaaŋ bisĩŋ ku maama‑i na hã bisĩŋ ku yiiŋgu baa-ma. Yiiŋgu yiiŋgu, baa ku yuŋ-maama.» ");
INSERT INTO cmeNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","«Baa na ta na cãl banamba‑i ku yaa Diiloŋo siɛ ka cãl-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Naŋ cãl nuɔmba‑i dumaa, Diiloŋo bi ka cãl-na dumɛi. Aa naŋ fiŋ baa kekerieŋgu maŋ na hã nuɔmba‑i ba ka bi fi baa ku yaa‑i hã namaaŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Naŋ ciɛ niɛ da hũyãŋo‑i unaŋ yufelle-na, aa daabolma maŋ naŋ yufelle-na ŋ saa da-ma? ");
INSERT INTO cmeNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Daabolma‑i naŋ yufelle-na jũnnu dumandɛ‑i, ŋ bir gbɛ̃ ŋ nabentieŋo‑i wuɔ: ‹Yaŋ mi hiel hũyãŋo‑i ŋ yufelle-na hã-ni!› ");
INSERT INTO cmeNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ãŋgbãŋgbãama! Hiel daabolma‑i ŋ yufelle-na igɛ̃na ku yaa ŋ ka ta ŋ da dɛi a gbãa hiel hũyãŋo‑i ŋ nabentieŋo yufelle-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","«Baa na ta na hã juoraamba‑i Diiloŋ-bĩmbĩnni‑i. Da na hã-ba baa-ni, ba gbãa sire pu baa-na. Baa na ta na nanna na niibilenni‑i pɛrmba hɔlma-na, ba ka fĩɛna-niɛ muonu-niɛ hã-na.» ");
INSERT INTO cmeNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«Cãarãŋ! Ba ka hã-na. Taaraayaŋ! Na ka da. Bĩɛŋ! Ba ka siɛ-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Umaŋ duɔ tuɔ cãrã, ba hã u yaa‑i, umaŋ duɔ tuɔ taara, u yaa daaŋ, aa umaŋ duɔ tuɔ bĩ, ba siɛ kufaŋgu tieŋo yaa‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Namaaŋo-na, hai moloŋ biɛŋo‑i duɔ cãrã *buruo u wulaa, u yaŋ-yo aa biɛ tãmpɛ̃lle hã-yo? ");
INSERT INTO cmeNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ni ma'i sĩ, duɔ cãrã teterieŋo, u yaŋ-yo aa bel jĩɛŋo hã-yo? ");
INSERT INTO cmeNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Namaa namaŋ balaaŋ, da na ta na suɔ-ma na hã na bisãlmba‑i bĩmbĩfafanni, ku ce niɛ aa na To‑i dɔrɔ‑i-na, bamaŋ cãarãŋ bĩmbĩfafanni‑i u wulaa, u siɛ hã-ba baa-ni? ");
INSERT INTO cmeNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","«Da na ta na taara ba ta ba ce kumaŋ ba hã-na, taa na ce ku temma na hã banamba‑i. *Moisi‑i baa *Diilopɔpuɔrbiemba‑i ba'a i tiɛ ce ku yaa‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«Suuriiŋ baa dumɛlle maŋ wullu-diele yaa‑i, baa na suur baa dimaŋ gbaa-diele‑i, difande kã dãamu-na. Hũmelle maŋ bi kãaŋ dãamu-na dii bi dii gbaa dumɛi. Nuɔmba bɔi cor baa di yaa‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ŋga hũmelle maŋ kãaŋ Diiloŋ-nelle-na, di wuɔsaaŋgu jaŋ, aa di dumɛlle tiraa waa wullu. Nuɔmba bɔi sa biɛ difande‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«Coikartaamba maŋ wuɔ bafamba *Diilopɔpuɔrbiemba, bilaaŋ na fɛrɛ bɛi. Da ŋ da-ba, ŋ cira nelfafaamba, ŋga ba hɔmmu sa suɔ aa doŋ ŋaa maamunaamba. ");
INSERT INTO cmeNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Da na da ba ciluɔ‑i, na ka pãŋ suɔ-ba. Namaa daa ba yagal musĩɛŋa kaapugammu-na wɛi? Aa ba sa bi biɛra hãlɛ̃iŋa caaterreŋ-yuŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Tibifafaaŋgu maŋ biefɛfɛiŋa, aa tibibabalaaŋgu maŋ biebabalɛiŋa. ");
INSERT INTO cmeNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Tibifafaaŋgu siɛ gbãa maŋ biebabalɛiŋa, aa tibibabalaaŋgu siɛ bi gbãa maŋ biefɛfɛiŋa. ");
INSERT INTO cmeNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Tibiiŋgu maŋ da ku saa maŋ biefɛfɛiŋa ba ka jũŋ-ku aa sɛnu-kuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Terieŋgu faŋgu-na, coikartaamba maŋ wuɔ bafamba Diilopɔpuɔrbiemba, na ka bi suɔ-ba ba ciluɔ yaa nuɔ‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«Baa na da niɛ sĩ bamaŋ hilaaŋ ba bĩ-mi yinni maŋ joŋ ‹Itie, Itie›, ba'i ka suur *Diiloŋ-nelle-na dɛ! Ba'i sĩ. Bamaŋ ciɛŋ mi To maŋ dɔrɔ‑i-na u huɔŋga‑i, ba'i ka suur. ");
INSERT INTO cmeNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Gɛ̃ŋgɛryiiŋ da ku ji hi, nuɔmba bɔi ka cira: ‹Itie, i saa tiɛ ce Diilopɔpuɔruŋgu‑i naŋ yerre yaa nuɔ‑i wɛi? I taa i gbuuse nuɔnɛi aa tiɛ donya *jĩnabaa-ba‑i. I ciɛ gbɛrɛ-wɛima‑i baa naŋ yerre yaa‑i.› ");
INSERT INTO cmeNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Da ba waŋ mafamma‑i, mi ka gbɛ̃-ba miɛ: ‹Kãaŋ na halaŋ mi caaŋ-nu; mi sa suɔ-na! Na hieroŋo‑i ãmbabalmanciraaŋ namaa.›» ");
INSERT INTO cmeNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Yesuŋ waaŋ mafamma‑i, wuɔ cira: «Umaŋ duɔ nu mi nelma‑i aa ce-ma, kutieŋo‑i mi gbãa saa-yo baa cɛ̃cɛ̃muntieŋo maŋ maa u dũŋgu‑i tãmpɛ̃lleŋ. ");
INSERT INTO cmeNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Diiloŋ uŋ juɔ tã, kanni gbar, fafalmu sire mu siremma‑i dũŋ daaku saa sagalla. ");
INSERT INTO cmeNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ŋga umaŋ duɔ nu mi nelma‑i aa u saa ce-ma, kutieŋo saa baa mimilãŋo maŋ maa u dũŋgu‑i hĩɛmugãaŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Diiloŋ uŋ juɔ tã, kanni gbar, fafalmu sire, ku pãŋ cii hiere bĩŋkũŋgu saa tĩɛ!» ");
INSERT INTO cmeNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesuŋ juɔ piiye tĩ, u nel maa cu nuɔmba hɔmmu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","U taa u piiye baa bibɛsĩnni u yaŋ *ãnjĩnamma pigãataamba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesuŋ juɔ piiye tĩ, wuɔ hiire tãnuŋgu-na tuɔ kã. Nuɔŋ baa sire cu u huoŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","*Wontorŋo naŋ wuɔ jo ji dũuna u yaaŋga-na aa naa cira: «Itie, da ŋ ta ŋ taara mi jarma ta-miɛ, ku siɛ yar-ni.» ");
INSERT INTO cmeNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesu wuɔ haa u naŋga‑i yuɔ aa naa cira: «Mi taara ma ta!» Naacolŋo jarma pãŋ ta-yuɔ terduɔŋgu faŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yesu wuɔ cira: «Baa tũnu nɛliɛŋo baa-ma dɛ! Mamaŋ dii, kã *Diilojigãntieŋo wulaa u ka ne-ni aa ŋ pã niikonni maŋ dii pãmma ŋ hã-yo ŋaa *Moisiŋ nyɛgãaŋ-ma dumaa ku yaa nuɔmba ka suɔ wuɔ ŋ jarma taa-niɛ.» ");
INSERT INTO cmeNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ku huoŋgu-na, Yesu wuɔ ta tuɔ kã Kafarnamu. Uŋ kaa tuɔ suur nelle-na, *Oromɛ ba sorosi ba yuntieŋo naŋ wuɔ kã u wulaa ");
INSERT INTO cmeNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ka cira: «Itie, mi maacembiloŋo naŋo gaala dii cĩiŋgu-na u sa gbãa sire, kuu dii-yuɔ kpelle! Jande, kãyã-miɛ!» ");
INSERT INTO cmeNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesu wuɔ cira: «Mi ka kã ka sire-yuɔ.» ");
INSERT INTO cmeNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Sorosi ba yuntieŋo cira: «Itie, nuɔ ŋ saa saaya ŋ suur mɛi temmaŋ-temma dumɛlle-na. Ŋga yaŋ aa ŋ waŋ nelma diei yoŋ, mi maacembiloŋo ka sire. ");
INSERT INTO cmeNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ŋ saa da, ma miŋ yeŋ terieŋgu maŋ nuɔ‑i, nuɔmba dii mi yuŋ-nu; aa mɛi bi dii banaŋ yuŋ-nu. Da mi gbɛ̃ umaŋ miɛ: ‹Kã!› ŋ da u kãa. Da mi bi cira: ‹Jo!› ŋ da u juɔ. Da mi bi gbɛ̃ mi maacembiloŋo‑i miɛ: ‹Ce daama!› ŋ da u ciɛ-ma.» ");
INSERT INTO cmeNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesu wuɔ kar da hãmmu! Naacolŋ uŋ juɔ piiye tĩ, Yesu wuɔ waŋ baa nuɔmba‑i wuɔ: «Yaaŋ mi waŋ ninsoŋo‑i baa-na: *Isirahɛl-baamba-na, mi saa da umaŋ haa u naŋga‑i miɛ *niɛryiɛŋ daayo temma‑i! ");
INSERT INTO cmeNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Mi tũnu-nɛi: Niɛraamba bɔi ka hel bãpagũŋgu-na baa bãsuuruŋgu-na a ka tĩɛna baa *Abiramubaa-ba‑i dii *Diiloŋ-nelle-na ta ba gbu ba ce ba bãaŋgu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Aa bamaŋ naa saaya ba suur, ba nyaa bafamba‑i hiel-ba fuoreŋ dii kukulma-na. Kaaluŋgu siɛ waa dɛi terieŋgu-na!» ");
INSERT INTO cmeNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Uŋ piiye dumaaŋo-na, wuɔ bir waŋ baa sorosi ba yuntieŋo‑i wuɔ: «Bir ŋ kũŋ, niŋ haa ŋ naŋga‑i miɛ ma ka dɔl-ni.» Uŋ taa u waŋ mafamma‑i huɔŋgu maŋ nuɔ‑i, maacembiloŋ wuɔ sire dii cĩiŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ku huoŋgu-na, Yesu wuɔ ta kã Piɛr dumɛlle-na kã ka da Piɛr cura si dii hĩnni. U kũɔma gbuu huol da pãmpãmpãŋ, u galla. ");
INSERT INTO cmeNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yesu wuɔ bel u naŋga‑i, fafal muɔ pãŋ da-yuɔ terduɔŋgu faŋgu-na. Wuɔ sire a tuɔ ce u nersĩnni‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Bãaŋguŋ juɔ suur huɔŋgu maŋ nuɔ‑i, baa fũnuŋ jo baa *jĩna ba nuɔmba‑i ji hã Yesu‑i. Wuɔ donya jĩnabaa daaba‑i baa u nuŋ-ãndaaŋgu aa naa bi sire jaamba maŋ waa hiere. ");
INSERT INTO cmeNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Diiloŋ uŋ puɔraa *Isayi waŋ mamaŋ, ma'i sĩ daama‑i wɛi? Isayi waaŋ-ma wuɔ: «U hũyãa i mulĩɛma‑i ce-ma u maama. U siire-yiɛ i jarma-na.» ");
INSERT INTO cmeNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesuŋ daa nuɔmbaŋ yuu-yuɔ dumaaŋo-na, wuɔ waŋ baa u *hãalãbiemba‑i wuɔ ba jãal kã dalaŋga bomborma namma-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","*Ãnjĩnamma pigãatieŋo naŋ wuɔ piɛ a waŋ baa-yo wuɔ: «Hãalãtie, mi ka ta mi nyaanu-niɛ niŋ kãŋ terni maŋ nuɔ‑i hiere.» ");
INSERT INTO cmeNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesu wuɔ cira: «Mi jĩɛ, ne! Muncɔmmu dii baa bũɔrãamba‑i aa kamma dii baa huriimba‑i. Ŋga terieŋgu sĩ baa *Moloŋ-Biɛŋo‑i u duɔ tuɔ cĩnnu u yuŋgu‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","U hãalãbiloŋo naŋ wuɔ gbɛ̃-yo wuɔ: «Itie, yaŋ mi to duɔ ku mi fuure-yuɔ tĩ, mi ka suɔ jo i ji tiɛ wuɔra.» ");
INSERT INTO cmeNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yesu wuɔ gbɛ̃-yo wuɔ: «Jo i ta aa ŋ yaŋ, kuomba ka fuure ba nakuomba‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesuŋ piiye dumaaŋo-na, wuɔ kã ka suur beŋo-na baa u *hãalãbiemba‑i ta ba karnu dalaŋga‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ba'a ba hi yaaŋga‑i Yesu wuɔ duɔfũŋ. Fafalmu naŋ temma sire suuye-bɛi dii dalaŋga-na, ta mu pe hũmma‑i mu dii beŋo-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Hãalãbieŋ baa cira «Itie, sire ŋ kor-e! I yii diɛ ku!» ");
INSERT INTO cmeNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesu wuɔ sire aa naa cira: «Korŋ hama‑i temma‑i dumaaŋo-na? Na saa haa na naŋga‑i Diiloŋo-na ku haama.» Aa naa nuola fafalmu‑i baa hũmma‑i niɛ kã ka ciire. ");
INSERT INTO cmeNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Kuɔ cu hãalãbiemba hɔmmu‑i. Baa ta ba piiye wuɔ: «Nɛliɛŋ hayo‑i temma‑i dumandɛ‑i? Fuɔ dii niɛ aa duɔ nuola fafalmu‑i baa hũmma‑i ni kã ka ciire ni temma‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesubaa-baŋ karaanu kã bomborre maŋ nuɔ‑i, ba bĩ nelle fande‑i Gadara. Pepetaamba namba waa Gadara‑i-na, ba waa ba hãi. Ba taa ba cɔ cĩncuɔŋ-na. Baa naa silaa balaŋ cor, a ce molo saa tuɔ siɛ u cor baa hũmelle fande‑i. *Jĩnabaa-ba'i naa ciɛ-ba dumaaŋo-na. Baŋ juɔ da Yesu‑i, baa sire ta ba jãrã-yuɔ ");
INSERT INTO cmeNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","aa ta ba kaasĩŋ wuɔ: «Diiloŋ-Biɛ, i ciɛ-ni niɛ? Ŋ juɔ da ŋ ji haa kakãlle‑i yiɛ a ne da ku yiiŋgu saa hi yogo.» ");
INSERT INTO cmeNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Pɛrsãlle nande waa ba yaaŋga-na ta di wuora. ");
INSERT INTO cmeNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Jĩnabaa baa ta ba cãrã Yesu‑i wuɔ: «Da ŋ'a ŋ ka nyaa-ye, jande yaŋ i hel ka suur pɛrŋ daaba-na.» ");
INSERT INTO cmeNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesu wuɔ cira: «Hilaaŋ na kã!» Baa hel ka suur pɛrmba-na. Pɛrŋ baa pãŋ ta ba gbar ba hiire ba kã ba tie ba suur dalaŋga-na ba kunu. ");
INSERT INTO cmeNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Nuɔmba waa ta ba ceŋ pɛrŋ daaba‑i. Baŋ gbaraa ka kunu hiere dumaaŋo-na, kutaaŋ baa gbar ka waŋ-ma cĩiŋgu-na. Pepetaaŋ daaba maama yaa waa ba nunni-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Nuɔŋ baa hel hiere da ba ji ne Yesu‑i. Baŋ juɔ ji da-yo, baa cãrã-yuɔ wuɔ u ce jande aa u ta u halaŋ ba terieŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Baŋ birii Yesu‑i dumaaŋo-na, wuɔ biɛ beŋo‑i a karnu kã ba nelle-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Baa jo baa murgu naŋo‑i kuugallaŋ-nu ji hã-yo wuɔ u sire-yuɔ. Wuɔ ne da ba haa ba naŋga‑i yuɔ cor, wuɔ gbɛ̃ ba jɛiŋo‑i wuɔ: «Mi jĩɛ, baa tie holle. Ŋ ãmbabalma hurii hiere.» ");
INSERT INTO cmeNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Uŋ piiye dumaaŋo-na, *ãnjĩnamma pigãataamba namba ta ba piiye ba huɔŋ-na wuɔ: «Naacolŋ daa u tuora Diiloŋo‑i dɛ!» ");
INSERT INTO cmeNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesu wuɔ suɔ baa-ba. Wuɔ cira: «Bige‑i ciɛ na ta na jɔguɔŋ nelbabalaŋ daama temma‑i na hɔmmu-na? ");
INSERT INTO cmeNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Namaa wulaa, a hur u ãmbabalma‑i, baa a ce u sire tuɔ wuɔ‑i, ma hãi‑i-na hama‑i ce fɛ̃u yaŋ? ");
INSERT INTO cmeNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Mi ka sire naacolŋ daayo‑i ku yaa na ka suɔ wuɔ Diiloŋo hãa *Moloŋ-Biɛŋo‑i ku fɔ̃ŋgũɔ‑i u tuɔ hur nelbiliemba ãmbabalma‑i.» Aa naa gbɛ̃ murgu‑i wuɔ: «Sire ŋ biɛ ŋ kuugallaŋgu‑i ŋ kũŋ.» ");
INSERT INTO cmeNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Naacolŋ wuɔ bi sire ba yufelle-na a biɛ u kuugallaŋgu‑i tuɔ wuɔ u kũŋ. ");
INSERT INTO cmeNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Korma bir yaŋ aa bel nuɔmba‑i, baa ta ba piiye wuɔ: «Diiloŋo‑i bibiɛŋo! Hiŋ daama temma‑i u hãa nelbiliemba baa-ma.» ");
INSERT INTO cmeNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesuŋ hilaa terieŋgu-na, wuɔ u cor da *nampohũutieŋo naŋo tĩɛnaana u maacemmaŋ-dũŋgu-na. Ba taa ba bĩ-yo Matie. Yesu wuɔ cira: «Matie, sire i ta.» Matie wuɔ bi sire cu u huoŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yiiŋgu naŋgu-na, Yesu wuɔ ji waa baa u *hãalãbiemba‑i Matie dumɛlle-na ba ta ba wuo niiwuoni. Nampohũutaamba bɔi waa a naara ãmbabalmanciraamba namba. ");
INSERT INTO cmeNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","*Farisĩɛbaa-ba daa mafamma‑i ce niɛ? Baa ta ba piiye baa Yesu hãalãbiemba‑i wuɔ: «Bige‑i ciɛ na hãalãtieŋo tuɔ wuo niiwuoni‑i baa nelbabalaaŋ daaba temma‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu wuɔ nu baŋ piiyeŋ; wuɔ waŋ baa-ba wuɔ: «Da ŋ waa hĩnni, ŋ ka ce bige‑i pɛrruntieŋ terieŋ-nu? ");
INSERT INTO cmeNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Diiloŋo ciɛra: ‹Taa na ce hujarre na-naa nuɔ, ku yaa dɔlaa-miŋ ku yaŋ na niikonni‑i.› Kãaŋ na ka taara nelma famma yuŋgu‑i. Na saa da, muɔmi saa jo nelfafaaŋ maa-na, mi juɔ nelbabalaaŋ maa-na.» ");
INSERT INTO cmeNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ku huoŋgu-na, *Nsãa-Batisi *hãalãbieŋ baa jo Yesu wulaa ji cira: «Hãalãtie, miɛŋo‑i baa *Farisĩɛbaa-ba‑i i hinu i dii sũŋgu, bige‑i ciɛ naŋ hãalãbiemba sa dii?» ");
INSERT INTO cmeNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesu wuɔ cira: «Ŋ jĩɛŋ duɔ tuɔ jã ciɛŋo, ŋ gbãa kã ka vãa ŋ yaaŋga‑i tĩɛna wɛi? Ku yaa ŋaa bafamba kũŋgu‑i: Da mi saa ji waa ba hɔlma-na yiiŋgu maŋ nuɔ‑i, ba ka suɔ dii sũŋgu‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Aa naa cira: «Ba sa taalnu kompafɛlɛŋga a nar joŋgorcɔlɔŋo. Da ŋ ce-ma, joŋgorcɔlɔŋo migãaŋ tuɔ taalnu u kã. ");
INSERT INTO cmeNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Aa ba sa bi dii duvɛ̃nfɛlɛŋo cirkpɔcɔlɔŋ-na. Umaŋ duɔ ce-ma, cirkpuɔ ka muonu aa duvɛ̃ŋo tiraa kũnna. Ŋga da ŋ'a ŋ dii duvɛ̃nfɛlɛŋo‑i, ŋ saaya ŋ dii-yo cirkpɔfɛlɛŋ-na, ni yaa gbĩɛ baa ni-naa.» ");
INSERT INTO cmeNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Nelma saa ji tĩ Yesu nuŋgu-na, ba'a ba ne da *Yuifu ba yuntieŋo naŋo juɔ ji dũuna u yaaŋga-na aa naa cira: «Mi biloŋo jarma yaraa-yo, ŋga jo i ta ŋ ka haa ŋ naŋga‑i yuɔ u ka sire.» ");
INSERT INTO cmeNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yesu wuɔ sire baa u *hãalãbiemba‑i ba ta ta ba kã baa naacolŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","A ne da ciɛŋo naŋo waa ba hɔlma-na, u tãmma taa ma kũnna ku bieŋ cĩncieluo baa a hãi waa belle fande-na. Wuɔ piɛ Yesu huoŋ-yaŋga a yiɛya u joŋgoruo tũŋgu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","U taa u piiye u huɔŋ-na wuɔ: «Da mi gbãŋ hi yiɛya u joŋgoruo‑i yoŋ, mi kuraa.» ");
INSERT INTO cmeNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Uŋ yiɛyaaya-yuɔ dumaaŋo-na, Yesu wuɔ miɛl da-yo, wuɔ cira: «Mi bilo, baa tie holle, niŋ haa ŋ naŋga‑i miɛ, ŋ kuraa.» Terduɔŋgu faŋgu-na, ciɛŋo tãŋ maa pãŋ yiɛra. ");
INSERT INTO cmeNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Baŋ kaa hi Yuifu ba yuntieŋo cĩiŋgu‑i, baa da niimarnintaamba, aa da nuɔmba haa ba nammu‑i ba yunniŋ ta ba kaal terni-na hiere. ");
INSERT INTO cmeNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Yesu wuɔ waŋ baa-ba wuɔ: «Biriiŋ na kũŋ, biloŋo saa ku, u duɔfũŋ.» Baa bir yaŋ aa ta ba cɔ̃muɔŋ-yo. ");
INSERT INTO cmeNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Baa hiel nuɔmba‑i kuloŋ uŋ waa dũŋgu maŋ nuɔ‑i aa Yesu wuɔ suur. Uŋ suurii, wuɔ bel biloŋo naŋ-na, wuɔ bi sire. ");
INSERT INTO cmeNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Nelma faŋ maa pãŋ gbuo terieŋgu faŋgu‑i hiere. ");
INSERT INTO cmeNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesuŋ juɔ hel tuɔ kũŋ, yiriemba namba cu u huoŋ-nu. Ba waa ba hãi; ta ba fara ba piiye baa-yo wuɔ: «*Davidi hãayɛ̃lŋ nuɔ, jande ce hujarre-yiɛ aa ŋ puur i yufieŋa‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Uŋ kaa hi cĩiŋgu‑i, baa jo ji yiɛra u caaŋgu-na. Wuɔ yuu-ba wuɔ: «Na hũyãa-ma wuɔ mi gbãa puur na yufieŋa‑i wɛi?» Baa cira: «Itie, i hũyãa-ma.» ");
INSERT INTO cmeNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Yesu wuɔ yiɛya ba yufieŋa‑i aa naa cira: «Ma ce ŋaa naŋ hũyãa-ma dumaa!» ");
INSERT INTO cmeNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ba yufieŋ aa bi pãŋ puur. Yesu wuɔ waŋ-ma kuola-mɛi baa-ba wuɔ ba baa yaŋ ma hel. ");
INSERT INTO cmeNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Baŋ taa, ba saa gbãa fĩinaŋ-mɛi, baa wuɔra gbuo nelle‑i hiere baa-ma. ");
INSERT INTO cmeNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Yirieŋ daabaŋ birii ta ba hel, baa jo baa bobo naŋo Yesu wulaa. *Jĩna'i naa ciɛ-yo dumaaŋo-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yesu wuɔ donya jĩna daayo‑i naacolŋo-na. Naacolŋ wuɔ pãŋ doŋ tuɔ piiye. Kuɔ ce nuɔmba‑i gbɛrɛ. Baa ta ba piiye wuɔ: «Iŋ siire, i saa da daama temma‑i dede *Isirahɛl-na!» ");
INSERT INTO cmeNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","*Farisĩɛbaa-baŋ'a ba ka waŋ mamaŋ, baa bir yaŋ aa ta ba piiye wuɔ: «Jĩna ba yuntieŋo yaa hãa-yo himma famma‑i u tuɔ donya jĩnabaa-ba‑i nuɔmba-na.» ");
INSERT INTO cmeNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu taa u wuɔra nilɛiŋa-na hiere u waŋ Diiloŋ-nelma‑i *Diilonelhãalãdũnni-na aa tuɔ waŋ *Diiloŋ-bãaŋgu *Neldɔdɔlma‑i aa bi tuɔ sire jaamba‑i ba sĩnni-na hiere u kã. ");
INSERT INTO cmeNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Nuɔmba naa mulĩɛŋ aa ba kũɔma naa tiraa kara ŋaa tũlmba maŋ tieŋo sĩ-bɛi. Yesuŋ daa-ba dumaaŋo-na, ba hujarre gbuu bel-o. ");
INSERT INTO cmeNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Wuɔ waŋ baa u *hãalãbiemba‑i wuɔ: «Dĩmma dii bɔi a ne da ma kartaamba saa ciinu. ");
INSERT INTO cmeNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Cãarãŋ suontieŋo‑i u puɔr nuɔmba namba naara.» ");
INSERT INTO cmeNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Uŋ waaŋ mafamma‑i, wuɔ bĩ u *hãalãbieŋ cĩncieluo ba hãi baamba‑i a hã-ba himma ba da ba gbãa ta ba donya *jĩnabaa-ba‑i aa ta ba sire jaamba‑i ba sĩnni-na hiere. ");
INSERT INTO cmeNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","U hãalãbiemba famba yaa u *pɔpuɔrbiemba‑i. Ba yirɛiŋa yaa daaya: Dĩɛlã-wuoŋo yaa Simɔ, baa u hãaŋo‑i Ãndere. Simɔ yerre nande yaa Piɛr. A naara Sebede bɛmba‑i ba hãi‑i-na: Sake baa Nsãa‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","A naara Filipu baa Batelemi. Toma baa Matie. Matie waa *nampohũutieŋo. A naara Sake maŋ Alfe biɛŋo‑i, baa Tade. ");
INSERT INTO cmeNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","A naara Simɔ maŋ taa u kuye u nelle maama‑i, baa *Yuda‑Isikaro. U yaa juɔ hel Yesu huoŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesuŋ hãa u *pɔpuɔrbiemba‑i himma‑i, wuɔ puɔr-ba aa naa waŋ baa-ba wuɔ: «Mi saa cira na kã *niɛraaŋ wulaa, mi saa bi cira na kã *Samari. ");
INSERT INTO cmeNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Kãaŋ *Isirahɛl-baamba yaa wulaa‑i. Ba baala ŋaa tũlmba. ");
INSERT INTO cmeNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Da na hi terieŋgu terieŋgu, na waŋ baa nuɔmba‑i wuɔ *Diiloŋ-bãaŋgu piyaa tĩ. ");
INSERT INTO cmeNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Taa na sire jaamba‑i baa bikuomba‑i baa *wontuɔrmba‑i. Taa na donya *jĩnabaa-ba‑i nuɔmba-na. Na daa ku fɔ̃ŋgũɔ‑i gbãŋgbãŋ, taa na bi ce na hã nuɔmba‑i gbãŋgbãŋ. ");
INSERT INTO cmeNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Da na'a na ta, molo baa biɛ gbeiŋa, ");
INSERT INTO cmeNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","molo baa biɛ buɔra, molo baa biɛ joŋgoruo naŋo a naara uŋ diyaa umaŋ, molo baa biɛ naatɛnni, molo baa bi biɛ bũɔle. Maacembiloŋo saaya baa u yerreŋ kalaaŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","«Da na suur nelle maŋ nuɔ‑i, na taara hartiefɛfɛiŋo baa na fɛrɛ igɛ̃na. Da na da hartieŋo, na tĩɛna baa u yaa‑i a ji hi na tamma‑i nelle fande-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Da na suur dumɛlle maŋ nuɔ‑i, na cira: ‹Tĩyãaŋ dɛi!› ");
INSERT INTO cmeNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Da ba siɛ na har dumɛlle fande-na, Diilo yaŋ na jaaluŋgu kãyã di taamba‑i; ŋga da ba saa siɛ na har-bɛi, Diilo yaŋ ba tĩɛ ba temma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Da na kã terieŋgu maŋ nuɔ‑i aa ba'a ba sa taara ba da na yufelle, na pir na nallu‑i na ta aa naa yaŋ-ba. ");
INSERT INTO cmeNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Mi waŋ ninsoŋo‑i baa-na: Bamaŋ da ba ce mafamma‑i, Diiloŋ duɔ ji tuɔ yuu nuɔmba‑i yiiŋgu maŋ nuɔ‑i, uŋ ka haa kumaŋ kutaamba-na, ku ka balaŋ yaŋ Sodɔmutaamba kũŋgu‑i baa Gomɔrtaamba kũŋgu‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«Na saa da, miŋ puɔraa-na dumandɛ‑i, kuu dii ŋaa mi ciɛŋ tũlmba ka dii-ba maamunaamba-na. Terieŋgu faŋgu-na, taa na suɔ na fɛrɛŋ belma, aa na baa yaŋ ba da cãlmuɔ haa-nɛi. ");
INSERT INTO cmeNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Yaaŋ mi gboya-nɛi jĩna: Ba ka bĩ-na fãamaambaa-ba wulaa ka gɛr-na. Ba ka muo-na *Diilonelhãalãdũnni-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ba ka kã baa-na fɔ̃ŋgɔ̃taamba wulaa, baa nellentaamba wulaa mɛi maama-na. Na ka hi-ba kusuɔŋ-nu'i baa *niɛraamba‑i hiere a piiye naŋ suɔnuŋ kumaŋ mɛi kũŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Da ba ji bel-na da ba ka yuu-na, baa na tie holle wuɔ na siɛ ka suɔ naŋ ka waŋ mamaŋ; yaaŋ mafamma‑i na hã Diiloŋo, u kaa pigãaŋ-na baa-ma terduɔŋgu faŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ku saa ce ŋaa nelma famma‑i namaa kusũnniŋ-maama'i kaa waa dɛ! Na To yaa kaa ce u *Yalle dii-ma na hɔmmu-na na waŋ-ma. ");
INSERT INTO cmeNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","«Banamba ka bel ba fɛrɛŋ hãmba hã-ba wuɔ ba ko-ba, banamba ba fɛrɛŋ mɔlbaa, banamba ba bisãlmba, banamba bi sire pu baa ba bĩncuɔmba‑i aa ce ba bel-ba ko-ba. ");
INSERT INTO cmeNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nuɔmba‑i hiere ba ka bigãaŋ-na mɛi maama-na. Ŋga umaŋ duɔ nyaar ka hi ku bãlma‑i, kutieŋo ka kor. ");
INSERT INTO cmeNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Da ba donya-nɛi nel daade-na, na gbar na kã daade-na. Mi waŋ ninsoŋo‑i baa-na: *Moloŋ-Biɛŋo ka bir jo ji da na saa hi *Isirahɛl nilɛiŋa‑i hiere. ");
INSERT INTO cmeNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","«Na saa da, *hãalãbiloŋo sa maar u hãalãtieŋo‑i, aa maacembiloŋo sa bi maar u yuntieŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Hãalãbiloŋo jɔguɔŋ u ce u hãalãtieŋo temma aa maacembiloŋo jɔguɔŋ u ce u yuntieŋo temma. Da ba gbɛ̃ dumɛllentieŋo‑i wuɔ *Bɛlsebul ba ka tuora u dumɛlleŋ-baamba‑i ka hi hie?» ");
INSERT INTO cmeNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Yesuŋ waaŋ mafamma‑i wuɔ cira: «Terieŋgu faŋgu-na, baa na ta na kãalã nuɔmba‑i. Mamaŋ fuyaa hiere, ma ka hel. ");
INSERT INTO cmeNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Da mi fuo waŋ mamaŋ baa-na, hilaaŋ na muonu-mɛi na gbuo terni‑i hiere. ");
INSERT INTO cmeNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Baa na ta na kãalã bamaŋ gbãa ko-na aa ba siɛ gbãa ce bĩŋkũŋgu na yalɛiŋa-na. Umaŋ dii kãalãmma, u yaa ŋaa Diiloŋo‑i; u yaa gbãa caa-na baa na yalɛiŋa‑i hiere. ");
INSERT INTO cmeNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Tigãlãamba hãi sullu saa cor warbelle diei; a ne da na To duɔ saa hũu-ma, u diei siɛ gbãa par diire. ");
INSERT INTO cmeNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Halle na yukuɔsĩnni maŋ daani‑i, Diiloŋo kãaŋ-ni hiere. ");
INSERT INTO cmeNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Terieŋgu faŋgu-na, baa na ta na tie holle; na bɔyaa tigãlãamba-na titirre. ");
INSERT INTO cmeNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","«Umaŋ duɔ yiɛra-mɛi nuɔmba yaaŋga-na wuɔ mɛi wuoŋo, muɔmi ka bi yiɛra-mɛi mi To maŋ dɔrɔ‑i-na u yaaŋga-na wuɔ kutieŋo‑i mɛi bi wuoŋo. ");
INSERT INTO cmeNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ŋga umaŋ duɔ cĩina-miɛ nuɔmba yaaŋga-na, muɔmi ka bi cĩina kutieŋo‑i mi To maŋ dɔrɔ‑i-na u yaaŋga-na.» ");
INSERT INTO cmeNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«Baa na ta na ne wuɔ sĩ mi juɔ baa yaafɛ̃lle hĩɛma-na; mi saa jo baa yaafɛ̃lle, mi juɔ baa bɛrru. ");
INSERT INTO cmeNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Mi juɔ da mi ji gbo bɛpuɔmba‑i baa ba tobaa-ba‑i, aa gbo biemba‑i baa ba nyubaa-ba‑i, aa bi gbo caamba‑i baa ba hũɔbaa-ba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Naŋ fɛrɛŋ dũŋ-baamba ka bigãaŋ-ni. ");
INSERT INTO cmeNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","«Umaŋ duɔ dɔl u bĩncuɔmba‑i yaŋ muɔŋo‑i, kutieŋo siɛ gbãa cu mi huoŋ-nu. Umaŋ duɔ bi dɔl u bisãlmba‑i yaŋ muɔŋo‑i, kutieŋo siɛ gbãa cu mi huoŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Aa umaŋ duɔ u sa siɛ mulĩɛma‑i baa kuliiŋgu‑i, u siɛ gbãa cu mi huoŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Umaŋ duɔ tuɔ kaal baa u yuŋgu yoŋ, kutieŋo ka kɔsuɔŋ u fɛrɛ. Ŋga umaŋ duɔ tuɔ kɔsuɔŋ u fɛrɛ mɛi maama-na, u ka da cicɛ̃lma maŋ sa tĩɛŋ dede‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«Umaŋ duɔ suɔ na belma, kutieŋo suyaa mɛi belma yaa‑i. A ne da umaŋ duɔ suɔ muɔmi belma, u suyaa mi pɔpuɔrtieŋo belma yaa‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Umaŋ duɔ ne *Diilopɔpuɔrbiloŋo maacemma‑i aa bel-o fafamma, Diiloŋ uŋ ka pã u pɔpuɔrbiloŋo‑i dumaa, u ka bi pã kutieŋo‑i dumɛi. Umaŋ duɔ bel nelviiŋo‑i fafamma wuɔ nelviiŋo, Diiloŋo ka pã kutieŋo‑i a saa baa nelviiŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Umaŋ duɔ ne mi *hãalãbiloŋo‑i baa u yornumma‑i aa hã-yo hũŋkolŋo‑i yoŋ u nyɔŋ, mi waŋ ninsoŋo‑i baa-na, u siɛ naa u daluɔ‑i Diiloŋo wulaa.» ");
INSERT INTO cmeNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesuŋ juɔ piiye tĩ baa u *hãalãbieŋ cĩncieluo ba hãi baamba‑i, wuɔ sire suur nilɛiŋa-na tuɔ wuɔra u waŋ Diiloŋ-nelma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Nsãa wuɔ tĩɛ dii kaso‑i-na aa naa nu *Kirsaŋ ceŋ mamaŋ hiere. Wuɔ puɔr u hãalãbiemba‑i wuɔ ba ka yuu-yo ");
INSERT INTO cmeNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","kɛrɛ *Koŋkortieŋo maŋ saaya u jo, u yaa ufaŋo‑i wɛi sisɔ uu dii huoŋ-nu? Baa kã ka hi Yesu‑i baa-ma. ");
INSERT INTO cmeNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesu wuɔ gbɛ̃-ba wuɔ: «Kãaŋ na ka tũnu Nsãa‑i baa naŋ nuŋ mamaŋ baa naŋ daŋ mamaŋ: ");
INSERT INTO cmeNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Yiriemba yufieŋa puurii, murgubaa-ba wuɔ, *wontuɔrmba jarma taa-bɛi, tugbentaamba tũnni puurii, bikuomba siire aa sũntaamba nuɔ *Neldɔdɔlma. ");
INSERT INTO cmeNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Umaŋ gbeini‑i da ni saa ji guɔl mi huoŋgu-na, kutieŋo yuŋgu dɔlaa.» ");
INSERT INTO cmeNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Nsãa pɔpuɔrbiembaŋ taa, Yesu wuɔ tuɔ taara u pigãaŋ nuɔmba‑i Nsãa sĩnni‑i. Wuɔ yuu-ba wuɔ: «Na kãa ka ne bige‑i hĩɛŋgu-na? Fafalmuŋ sagallaŋ hĩɛŋgu‑i dumaa, na kãa ka ne ku yaa wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Namaa kãa ka ne bige‑i? Na kãa ka ne umaŋ diyaa bĩmbĩfafanni wɛi? Ma sĩ bamaŋ diyaaŋ bĩmbĩfafanni‑i baa dii tĩɛna fɔ̃ŋgɔ̃taamba dũnniŋ kɛ? ");
INSERT INTO cmeNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ŋga namaa kãa ka ne bige‑i? Ma sĩ na kãa ka ne *Diilopɔpuɔrbiloŋo'i kɛ? Aa naacolŋo faŋo‑i, mi tũnu-nɛi: U maaraa Diilopɔpuɔrbiloŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ma nyɛgãaŋ Diiloŋ-nelma-na wuɔ: ‹Mi ka puɔr mi pɔpuɔrbiloŋo wuɔya ta ŋ yaaŋ-na ka cãa ŋ hũmelle‑i›, ba gbɛ̃ Nsãa yaa‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Mi waŋ ninsoŋo‑i baa-na: *Nsãa-Batisi temma saa hi hoŋ yogo caaŋ-biemba-na. A ne da umaŋ si dii baa yuŋgu *Diiloŋ-nelle-na, u maaraa Nsãa‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","A doŋ dii Nsãa-Batisi bãaŋ-nu, ji hi baa nyuŋgo, nelbabalaamba cĩinaana *Diiloŋ-nellentesĩnni‑i aa ta ba taara ba hũu u nelle‑i ce-de ba diele. ");
INSERT INTO cmeNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Diilopɔpuɔrbiemba‑i hiere ka hel baa *Moisi‑i ba siire piiye Diiloŋ-nellentesĩnni maama a ji hi Nsãa-Batisi bãaŋgu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Na saaya na suɔ wuɔ baŋ waaŋ *Eli maŋ maama‑i wuɔ u ka jo, u yaa juɔ Nsãa‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Umaŋ duɔ u ka nu, u nu!» ");
INSERT INTO cmeNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Aa naa cira: «Mi gbãa saa fiɛfiɛ ku nuɔmba‑i baa haba‑i? Mi gbãa saa-ba baa bisãlmba maŋ tĩɛnaana ponsanatigerreŋ. Banamba ta ba waŋ baa banamba‑i wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‹I hulii tulammu hã-na, na saa nyɛŋ. I hãl kuliiŋ-nɛini hã-na, na saa kaal.› ");
INSERT INTO cmeNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Nsãa juɔ, u sa dii dĩbelle u nuŋgu-na, u sa nyɔŋ kolma, na cira wuɔ *jĩna dii u yuŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","*Moloŋ-Biɛŋ uŋ wuo aa tuɔ nyɔŋ, na sire ta na piiye wuɔ: ‹Naacolŋ daa fuɔ bi yii baa niiwuoni yaa‑i yoŋ baa konyɔlle! Aa tiraa sire bel jĩɛru baa *nampohũutaamba baa nelbabalaamba.› Ŋga Diiloŋ-nelma fafaaŋgu da u maacemma'i nuɔ‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yesuŋ ciɛ gbɛrɛ-wɛima bɔi nilɛiŋa maŋ nuɔ‑i, a taaŋ baa sa hũu-ma nanna ba cilɔbabalaŋo‑i. Yesu wuɔ doŋ tuɔ waŋ baa-ba wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«Korasitaaŋ namaaŋo‑i, sũlma haraa-nɛi! Betisadataaŋ namaaŋo‑i, sũlma haraa-nɛi! Gbɛrɛ maŋ ciɛ namaa hɔlma-na, kuɔ uu naa ce Tiir nelle yaa nuɔ‑i baa Sidɔ̃ nelle-na, dii yiinaa baa naa kũnna cuoŋgu ba fɛrɛŋ nuɔ aa dii buɔr ba joŋgorbaa a pigãaŋ wuɔ ba naana ba cilɔbabalaŋo‑i! ");
INSERT INTO cmeNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Terieŋgu faŋgu-na, mi tũnu-nɛi: Diiloŋ duɔ ji tuɔ yuu nuɔmba‑i, uŋ ka haa kumaŋ nɛi, ku ka balaŋ yaŋ Tiirtaamba kũŋgu‑i baa Sidɔ̃taamba kũŋgu‑i hiere. ");
INSERT INTO cmeNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Kafarnamutaaŋ namaaŋo‑i, na daa niɛ sĩ na kaa da Diiloŋo‑i wɛi? Na tãal na fɛrɛ, na ta na kã dãamu-na. Gbɛrɛ maŋ ciɛ namaa nelle-na, kuɔ uu naa ce Sodɔmu yaa nuɔ‑i, nyuŋgo daayo-na, nelle fande naa waa yogo. ");
INSERT INTO cmeNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Terieŋgu faŋgu-na, mi tũnu-nɛi, kumaŋ ka haa-nɛi gɛ̃ŋgɛryiiŋgu-na, Sodɔmu kũŋgu ka waa hãaŋo.» ");
INSERT INTO cmeNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ku huoŋgu-na, Yesu wuɔ cira: «Baba, nuɔnɛi Yuntieŋ nuɔ dɔrɔ‑i-na baa hĩɛma-na hiere. Niŋ fuyaa ŋ huɔŋga‑i cɛ̃cɛ̃muntaamba-na baa sɛbɛsuɔtaamba-na aa cɛr pigãaŋ bisãmbiemba‑i baa-ka, ŋ jaaluŋgu bɔi. ");
INSERT INTO cmeNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ninsoŋo, ŋ ciɛ ŋ huɔŋga yaa dumaaŋo-na, Baba.» ");
INSERT INTO cmeNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Aa naa waŋ baa nuɔmba‑i wuɔ: «Mi To birii wɛima‑i hiere hã-mi. Da ma hel Tuoŋo-na, molo sa suɔ Bɛpolŋo‑i, aa da ma bi hel Bɛpolŋo-na baa uŋ taaraŋ u pigãaŋ bamaŋ baa-yo, molo sa suɔ Tuoŋo‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Yesuŋ waaŋ mafamma‑i, wuɔ cira: «Namaa namaŋ tũyãa coŋgorni ta ni ko-na, juɔŋ mi ji har-na na fiisa. ");
INSERT INTO cmeNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Mi huɔŋga sa doŋ, aa mi sa tɛtɛŋ mi fɛrɛ. Juɔŋ mi ji haa mi coŋgoruoŋgu‑i hã-na na cu mi huoŋ-nu ku yaa na ka da fiisaaŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Mi coŋgoruoŋgu si dii yonduo, mi tusãlle dii fiɛfiɛfiɛ.» ");
INSERT INTO cmeNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Yibieŋa faŋa-na, *yitĩɛnaŋgu naŋgu-na, Yesubaa-ba taa ba karnu sonni nanni‑i ba cor. A ne da nyulmu waa u *hãalãbiemba-na. Baa doŋ ta ba kar bile‑i ba wuo. ");
INSERT INTO cmeNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","*Farisĩɛbaa-ba daa mafamma‑i ce niɛ? Baa sire ta ba piiye baa Yesu‑i wuɔ: «Ne ŋ hãalãbiemba‑i, kumaŋ saa saaya ku ce yitĩɛnaŋgu-na ba ce ku yaa‑i!» ");
INSERT INTO cmeNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesu wuɔ cira: «Nyulmu naŋ bilaa *Davidi‑i baa u nuɔmba‑i wuɔ ce kumaŋ, ma sĩ na kalaaŋ-ku kɛ? ");
INSERT INTO cmeNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Davidi suurii Diiloŋ-dũŋgu-na a biɛ Diiloŋ-buruo‑i ba wuo baa u nuɔmba‑i. A ne da a saa baa miɛ Diiloŋ-hũmelle‑i, da kuɔ *Diilojigãntieŋ nuɔ sĩ, ŋ siɛ gbãa wuo buruo faŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ma sĩ na bi kalaaŋ *ãnjĩnamma‑i kɛ? Wuɔ nɛliɛ saa saaya u ce maacemma yitĩɛnaŋgu-na, ŋga Diilojigãntaamba ce maacemma‑i *Diilodubuɔ‑i-na aa molo sa kãŋ-ku wuɔ cãlmuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","A ne da bande‑i-na, kunaŋgu dii kumaŋ maaraa Diilodubuɔ‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Diiloŋo ciɛra wuɔ: ‹Taa na ce hujarre na-naa nuɔ ku yaa dɔlaaŋ-miŋ ku yaŋ na niikonni‑i.› Kuɔ na taa na suɔ nel daama yuŋgu‑i, naa naa saa ta na cãl nuɔmba‑i na yuŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","A tiraa naara kufaŋgu‑i: *Moloŋ-Biɛŋo yaa yitĩɛnaŋgu tieŋo‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesuŋ juɔ piiye baa *Farisĩɛbaa-ba‑i tĩ, wuɔ ta kã *Diilonelhãalãdũŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Naacolŋo naŋo waa ba hɔlma-na, u naŋga diei naa minaŋ. Farisĩɛbaa baa ta ba taara ãntãalãmma da ba haa Yesu‑i-na, a ce dumaaŋo-na baa yuu-yo wuɔ: «A saa baa miɛ Diiloŋ-hũmelle‑i, ŋ gbãa sire jɛiŋo *yitĩɛnaŋgu-na wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesu wuɔ cira: «Namaaŋo-na, umaŋ duɔ waa baa tũmaaŋo diei yoŋ u kũndũŋgu-na aa tũmaaŋ daayo par suur fuoŋ-nu yitĩɛnaŋgu-na, kutieŋo ka yaŋ-yo dii fuoŋgu-na wuɔ yitĩɛnaŋgu wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Nelbiloŋo‑i baa tũmaaŋo‑i, hai bɔyaa? Terieŋgu faŋgu-na, ãnfafamma gbãa ce yitĩɛnaŋgu-na, wɛima si dii.» ");
INSERT INTO cmeNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Aa naa waŋ baa naacolŋ daayo‑i wuɔ: «Fara ŋ naŋga‑i.» Naacolŋ wuɔ bi fara u naŋga‑i, kaa firnu kanaŋga temma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Farisĩɛbaa baa pãŋ hel ka ta ba da ba-naa Yesu kommaŋ-kũŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesuŋ juɔ suɔ wuɔ ba taara ba ko-yo, wuɔ ta halaŋ terieŋgu-na. Nuɔŋ baa kũɔl ba-naa ta ba nyaanu-yuɔ. Jaamba waa ba hɔlma-na. Wuɔ sire-bɛi hiere ");
INSERT INTO cmeNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","aa naa waŋ-ma kuola-mɛi baa-ba wuɔ ba baa yaŋ molo suɔ wuɔ u yaa siire-bɛi. ");
INSERT INTO cmeNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Diiloŋ uŋ puɔraa *Isayi waŋ mamaŋ, ma'i sĩ daama‑i wɛi? Isayi waaŋ-ma wuɔ: «Diiloŋo ciɛra wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","‹Mi hielaa mi cãarãŋo yaa daayo. U maama sa suɔ aa dɔlnu-miɛ. U yaa fĩɛŋ mi huɔŋga‑i. Mi ka hã-yo mi *Yalle‑i. U yaa ka pigãaŋ nuɔmba‑i nilɛiŋa-na hiere baa hũmeviile‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","U siɛ gãŋ baa moloŋo. U sa jo duɔ ji hohuola baa moloŋo. Molo siɛ nu u piiye hũŋgbɛsɛnniŋ. ");
INSERT INTO cmeNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","U siɛ perieŋ terre maŋ kaanu tĩ, aa u siɛ dĩŋ dãamu maŋ kusiriiye tĩ. U ka waa ma yaa nuɔ‑i fuɔ nuɔmba‑i nilɛiŋa-na hiere ba ji hũu viisĩnni maama‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Nuɔmba‑i hiere ba ka haa ba naŋga‑i yuɔ.›» ");
INSERT INTO cmeNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ku huoŋgu-na, baa ji jo baa bobo-yiroŋo naŋo‑i Yesu wulaa. *Jĩnabaa-ba'i naa ciɛ-yo dumaaŋo-na. Yesu wuɔ puur u yufieŋa‑i aa naa ce u tuɔ gbã u piiye. ");
INSERT INTO cmeNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Kuɔ cu nuɔmba hɔmmu‑i; baa ta ba yuu ba-naa wuɔ: «Ku biyaa ŋaa *Davidi hãayɛ̃lŋo yaa‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","*Farisĩɛbaa-baŋ juɔ nu-ma, baa gbɛ̃-ku dumaa wuɔ: «Jĩna ba yuntieŋo‑i *Bɛlsebul yaa hãa naacolŋ daayo‑i himma‑i u tuɔ donya jĩnabaa-ba‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesu wuɔ suɔ baa-ba. Wuɔ gbɛ̃-ba wuɔ: «Da ŋ da neduɔleŋ-baaŋ namaaŋo‑i na sa gbo, yiiŋgu dii baa yiiŋgu na nelle ka muonu. Da na bi waa cĩiŋgu-na sisɔ dumɛlle-na aa na sa taara na da na-naa, na dumɛlle ka muonu. ");
INSERT INTO cmeNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","*Sitãni duɔ tuɔ donya fuɔ fɛrɛŋ baamba‑i, ma sĩ kuu dii ŋaa u gãŋ baa u fɛrɛ kɛ? Dumaaŋo-na, u fɔ̃ŋgũɔ ce niɛ aa cɔ u wulaa? ");
INSERT INTO cmeNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Na gbĩɛ-ku dumaa wuɔ Bɛlsebul yaa hãa muɔ himma‑i mi ta mi donya jĩnabaa-ba‑i, namaa nuɔmba fuɔ, hai moloŋo‑i hãa bafamba‑i himma‑i ba ta ba donya-bɛi? Na saa da, namaa fɛrɛŋ baamba yaa ka karnu ciiruo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Muɔ fuɔ, *Diiloŋ-Yalle yaa hãa-mi himma‑i mi ta mi donya jĩnabaa-ba‑i. Ku yaa pigãaŋ wuɔ *Diiloŋ-bãaŋgu paa-nɛi tĩ. ");
INSERT INTO cmeNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","«Hai moloŋo‑i gbãa suur u nabiɛŋ dũŋgu-na a biɛra u bĩmbĩnni‑i hel baa-ni aa u nabiɛŋo yaŋ-yo dumaa? Ŋga kutieŋ duɔ bel u nabiɛŋo‑i vaa-yo igɛ̃na, u gbãa suur biɛra u bĩmbĩnni‑i hiere ta baa-ni. ");
INSERT INTO cmeNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","«Umaŋ duɔ uu si dii baa-mi, kuu dii ŋaa kutieŋo bigãaŋ-mi; aa umaŋ duɔ u sa tigiiŋ baa-mi, kuu dii ŋaa u pisãllã. ");
INSERT INTO cmeNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","«Mi tũnu-nɛi: Nelbiliembaŋ cãl Diiloŋo‑i aa ta ba haa tuosĩnni maŋ yuɔ hiere, u gbãa ce jande bɛi aa yaŋ ma tĩ. Ŋga umaŋ duɔ tuora u *Yalle‑i, jande cɛraa u ce-yuɔ hĩɛma-na, jande cɛraa u ce-yuɔ dɔrɔ‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Umaŋ duɔ waŋ ãndababalaaŋgu hã *Moloŋ-Biɛŋo‑i, ma gbãa tĩ. Ŋga umaŋ duɔ piiye ãndaparaaŋgu hã Diiloŋ-Yalle‑i, ma siɛ tĩ nyuŋgo, ma siɛ tĩ bisĩnuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","«Tibifafaaŋgu yaa maaŋ biefɛfɛiŋa‑i. Tibibabalaaŋgu maŋ biebabalɛiŋa. Ba suɔ tibiiŋgu‑i ku bieŋa yaa nuɔ‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Nelbabalaaŋ namaa temma‑i daana‑i! Naŋ balaaŋ, nelfafamma ce niɛ aa hel na nunni-na? Nɛliɛŋ nuɔ ŋ huɔŋgaŋ yuu baa mamaŋ, ma yaa hilaaŋ ŋ nuŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Nelfɛfɛiŋ u ãnfafamma hel u hɔfafaŋga'i nuɔ‑i. Aa nelbabalaŋ u maacembabalamma hel u hɔbabalaŋga'i nuɔ‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Mi tũnu-nɛi: Gɛ̃ŋgɛryiiŋgu-na, bamaŋ waaŋ ãndasɔsɔnni‑i hiere, Diiloŋo ka gãŋ baa-ba. ");
INSERT INTO cmeNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Diiloŋo ka ne naŋ fɛrɛŋ nuŋ-ãndaaŋgu yaa‑i aa cira ŋ cãlãa sisɔ ŋ saa cãl.» ");
INSERT INTO cmeNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Yesuŋ juɔ piiye tĩ, *ãnjĩnamma pigãataamba namba‑i baa *Farisĩɛbaa-ba namba cira: «Hãalãtie, i taara ŋ ce himma i ne.» ");
INSERT INTO cmeNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yesu wuɔ gbɛ̃-ba wuɔ: «Fiɛfiɛ ku nuɔmba saa fa, ba jɛ̃naamba sa ku! Ba gbĩɛ-ku dumaa wuɔ mi ce himma ba ne. Bĩŋkũŋgu sa ce dii hã-na. *Yonasiŋ ciɛ mamaŋ, ma ka saanu baa-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yonasiŋ ciɛ yinni siɛi‑i dumaa teterieŋo kusũŋgu-na, *Moloŋ-Biɛŋo ka bi ce yinni siɛi‑i dumɛi hĩɛma-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ninivetaamba nuɔ Yonasi nuŋgu‑i aa nanna ba cilɔbabalaŋo‑i, a ne da namaa hɔlma-na bande‑i-na, moloŋo dii umaŋ maaraa Yonasi‑i aa na yagar wuɔ na siɛ nu u nuŋgu‑i! Diiloŋ duɔ ji tuɔ yuu nuɔmba‑i, Ninivetaamba ka cira na cãlãa cemma. ");
INSERT INTO cmeNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Gɛ̃ŋgɛryiiŋgu-na, Seba nellentieŋo ka da nuŋgu fiɛfiɛ ku nuɔŋ namaaŋo-na. Fuɔ siire termaaŋ daaku-na a karnu nilɛiŋa‑i hiere ji nu *Salomɔ nelma‑i, a ne da namaa hɔlma-na bande‑i-na, moloŋo dii umaŋ maaraa Salomɔ‑i aa na yagar na sa nu u nuŋgu‑i!» ");
INSERT INTO cmeNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Ku huoŋgu-na, Yesu wuɔ cira: «*Jĩna duɔ waa moloŋo-na aa ji hel, u kã ka tuɔ wuɔra u bĩŋ hĩɛŋ-nu duɔ taara muntĩɛnammu. ");
INSERT INTO cmeNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Duɔ saa ka da, u cira: ‹Mi ka bir kã mi muntercɔlɔmmu-na.› Aa bi bir. Duɔ kã ka da bĩŋkũŋgu si dii kutieŋo huɔŋga-na, aa u gbuu migãaŋ-ka da welewele aa tigiiŋ-ka, ");
INSERT INTO cmeNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","u bir ka bĩ u najĩnabaa niehãi, bamaŋ balaaŋ yaŋ ufaŋo‑i ba jo ji suur tĩɛna-kɛi. Da ba suur tĩɛna dumaaŋo-na, ku migãaŋ balaŋ kutieŋo-na a yaŋ dĩɛlã-kũŋgu‑i. Mafamma temma yaa ka da fiɛfiɛ ku nuɔmba‑i; ba saa fa.» ");
INSERT INTO cmeNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesuŋ waa tuɔ piiye baa nuɔmba‑i, u nyu wuɔ jo baa u hãmba‑i da ba ji ne-yo. Baŋ juɔ ji da u piiye, baa yiɛra gɔ̃ŋgũɔŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Naacolŋo naŋ wuɔ da-ba aa naa piɛ waŋ baa Yesu‑i wuɔ: «Ŋ nyu‑i baa ŋ hãmba juɔ da ba ji ne-ni, baa dii yiɛra gɔ̃ŋgũɔŋgu-na ta ba cie-ni.» ");
INSERT INTO cmeNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesu wuɔ gbɛ̃ naacolŋo‑i wuɔ: «Na suɔ mi nyu‑i baa mi hãmba‑i wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Aa naa wuɔra pigãaŋ u *hãalãbiemba‑i baa u naŋga aa cira: «Mi nyu‑i baa mi hãmba yaa daaba. ");
INSERT INTO cmeNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Bamaŋ ciɛŋ mi To maŋ dɔrɔ‑i-na u huɔŋga‑i, ba yaa mi hãmba‑i, ba yaa mi tũɔbaa-ba‑i, ba yaa mi nyubaa-ba‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Yinduɔŋgu faŋgu-na, Yesu wuɔ sire hel kã ka tĩɛna dalaŋga nuŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Nuɔmba jo ji yu-yuɔ. Wuɔ bel nyugũŋ beŋo naŋo-na tĩɛna aa nuɔmba waa bomborma-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Uŋ tĩɛnaana, wuɔ biɛ gbãnɛini tuɔ naŋ baa-ba wuɔ: «Naacolŋo naŋo kãa ka naŋ fũma u suoŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Fũma naŋo kã ka diire hũmelleŋ-huɔŋ-na, huriimba jo ji wuo ufaŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Unaŋo kã ka diire tãmpɛ̃lleŋ-terieŋ-nu. Hĩɛma saa waa bɔi terieŋgu-na; a ce u pa yaŋ unaŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Uŋ paa, u kaasĩnni saa gbãa suur kã yaaŋ-na. Bãaŋguŋ juɔ doŋ ta ku jo, wuɔ kuol hiere kpɛ̃mmu! ");
INSERT INTO cmeNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Unaŋo kã ka diire hĩɛŋ-nu. Hĩɛŋgu tu suuye-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Umaŋ diiriiye suoŋ-huɔŋga-na munterfafammu-na, u sire gbuu kpatalla: unaŋo bieŋa komuɔŋa da-a-ndii, unaŋo bieŋa komuɔŋa sa-a-siɛi, unaŋo komuɔŋa baa cĩncielbaa.» ");
INSERT INTO cmeNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yesuŋ waaŋ mafamma‑i wuɔ cira: «Umaŋ duɔ u ka nu, u nu!» ");
INSERT INTO cmeNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Yesuŋ juɔ naŋ tĩ, u *hãalãbiemba piɛ u caaŋ-nu ka cira: «Itie, bige‑i ciɛ ŋ ta ŋ naŋ gbãnɛini baa nuɔmba‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesu wuɔ cira: «Diiloŋo ciɛ baa namaaŋo‑i. U *nellentesĩnni maama maŋ fuyaa, u pigãaŋ namaaŋo‑i baa-ma, a ne da banamba sa suɔ kunaŋgu mɛi. ");
INSERT INTO cmeNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Umaŋ duɔ tuɔ suɔ yiɛŋgu, kunaŋgu ka ta ku naara u sɔsuɔmuŋgu‑i; ŋga umaŋ duɔ u sa suɔ bĩŋkũŋgu, cɛllɛ-kũŋgu maŋ uŋ suɔ-kuŋ, ku ka kor-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Na saa da, kumaŋ ciɛ mi ta mi naŋ gbãnɛini‑i baa-ba, yufieŋa dii baa-ba, ŋga ba sa da baa-ya. Tũnni dii baa-ba, ŋga ba sa nu baa-ni. Ba sa suɔ nelmaŋ kãŋ yaŋga maŋ nuɔ‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Diiloŋ uŋ puɔraa *Isayi waŋ mamaŋ, ma'i sĩ daama‑i wɛi? Isayi waaŋ-ma wuɔ: ‹Diiloŋo ciɛra wuɔ: «Na ka ta na nu nelma‑i, ŋga na siɛ ta na suɔ ma yaaŋga‑i. Na ka ta na ne colcol, ŋga na siɛ ta na da bĩŋkũŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Hama‑i nuɔ‑i? Bande ku nuɔmba nyaayã ba fɛrɛ cor; ba suunu ba tũnni‑i aa suuye ba yufieŋa‑i. Ba sa taara ba da bĩŋkũŋgu. Ba sa taara ba nu wɛima. Ba sa bi taara ba suɔnu kunaŋgu aa jo mi wulaa mi ji kor-ba.»›» ");
INSERT INTO cmeNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Yesu wuɔ cira: «Namaa fuɔ, na yunni dɔlaa; na da baa na yufieŋa‑i aa ta na nu baa na tũnni‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Mi waŋ ninsoŋo‑i baa-na: *Diilopɔpuɔrbiemba bɔi baa nelviimba bɔi taa ba taara ba da naŋ daŋ kumaŋ, aa nu naŋ nuŋ mamaŋ, ŋga ba saa da ma diei, ba saa bi nu ma diei.» ");
INSERT INTO cmeNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Yesuŋ waaŋ mafamma‑i, wuɔ cira: «Karaaŋ na tũnni‑i na nu fũmanarãŋo gbãnalãaŋgu yuŋgu‑i: ");
INSERT INTO cmeNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Nuɔmba naŋ hɔmmu dii ŋaa hũmelleŋ-huɔŋga; da ba nu *Diiloŋ-bãaŋgu maama‑i ba sa bel-ma nammu hãi, ba yaŋ *Bigãarãŋo jo ji hiel-ma aa yaŋ-ba. ");
INSERT INTO cmeNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Banaŋ hɔmmu dii ŋaa tãmpɛ̃lleŋ-terieŋgu; da ba nu Diiloŋ-nelma‑i ma pãŋ dɔlnu-bɛi ba hũu-ma. ");
INSERT INTO cmeNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ŋga ma siɛ gbãa naŋ kaasĩnni. A ce dumaaŋo-na wɛiŋ da ma da kutaamba‑i, sisɔ da ba ta ba huol ba yammu‑i ma maama-na, ba har jĩna. ");
INSERT INTO cmeNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Banaŋ hɔmmu dii ŋaa hĩɛŋ-terieŋgu; da ba nu Diiloŋ-nelma‑i ba yaŋ ãnjɔguɔma‑i baa gbeiŋ-maama jo ji suuye-mɛi; a ce ma sa da belle ba wulaa. ");
INSERT INTO cmeNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","A ne da banaŋ hɔmmu dii ŋaa hĩɛfafamma; da ba nu Diiloŋ-nelma‑i ba suɔ ma yuŋgu‑i aa wuɔ ma hũmelle‑i diŋ saaya di wuɔ dumaa. Kufaŋgu taamba yaa dii ŋaa fũma maŋ gbuu sire kpatalla; unaŋo bieŋa komuɔŋa da-a-ndii, unaŋo bieŋa komuɔŋa sa-a-siɛi, unaŋo komuɔŋa baa cĩncielbaa.» ");
INSERT INTO cmeNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu wuɔ tiraa naŋ gbãnalãaŋgu naŋgu baa-ba wuɔ: «*Diiloŋ-nellentesĩnni dii ŋaa moloŋo maŋ siire ka duu dĩmma u suoŋgu-na aa jo ji tĩɛna. ");
INSERT INTO cmeNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Isuɔŋgu naŋgu-na, u bigãarãŋo naŋo yaŋ nuɔmba duɔfũŋ aa sire ka naŋ hɛ̃bieŋa dĩmma hɔlma-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Dĩmmaŋ juɔ ta ma hoŋ huɔŋgu-na, suontieŋo maacembiemba da hĩɛŋ daaku‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ba jo ji ta ba yuu suontieŋo‑i wuɔ: ‹Yuntie, ma sĩ ŋ duu dĩmma'i ma kula suoŋgu-na kɛ, hĩɛŋgu maama niɛ?› ");
INSERT INTO cmeNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","«Suontieŋo gbɛ̃-ba wuɔ: ‹Unaŋo sĩ, mi bigãarãŋo naŋo'i ciɛ mafamma‑i.› «Maacembiemba cira: ‹I kã ka for-ku nanna wɛi?› ");
INSERT INTO cmeNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","«Suontieŋo gbɛ̃-ba wuɔ: ‹Yaaŋ-kuŋ, baa na for-ku; da na'a na for-ku, na ka for baa dĩmma namma. ");
INSERT INTO cmeNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Yaaŋ ni vãa hiere. Dĩŋ da ma ji hi karma, mi ka ce ba for ku yaa igɛ̃na a tigiiŋ-ku caa-ku aa suɔ kar mi dĩmma‑i dii-ma inɔŋgɔ̃-na hã-mi.›» ");
INSERT INTO cmeNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ku huoŋgu-na, Yesu wuɔ tiraa naŋ gbãnalãaŋgu naŋgu baa-ba wuɔ: «*Diiloŋ-nellentesĩnni dii ŋaa mutardi-belle maŋ baŋ duu-de. ");
INSERT INTO cmeNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mutardi-belle yaa yuraanu yaŋ hiere, ŋga da di pa, di sire maar niifiɛlu‑i hiere a ce tibiiŋgu huriimba ta ba jo ba sɛ kamma kuɔ.» ");
INSERT INTO cmeNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Aa naa tiraa cira: «*Diiloŋ-nellentesĩnni dii ŋaa konsiini. Da ba par-ni ba nakoluoŋ-nu a du burjũmmu‑i kolloyufieŋa siɛi baa-ni, ni sire-muɔ hiere.» ");
INSERT INTO cmeNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu waaŋ nel daama‑i hiere baa nuɔmba‑i gbãnɛiniŋ; duɔ puur duɔ piiye gbãnalãaŋgu, a puur duɔ piiye gbãnalãaŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","*Diilopɔpuɔrbiloŋ uŋ waaŋ mamaŋ ma'i sĩ daama‑i wɛi? Diilopɔpuɔrbiloŋo waaŋ-ma wuɔ: «Diiloŋo ciɛra wuɔ: ‹Mi ji ta mi piiye baa-ba gbãnɛiniŋ. Mamaŋ naa fuo dii miwaaŋo domma-na, mi ka waŋ-ma baa-ba.›» ");
INSERT INTO cmeNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesuŋ juɔ piiye tĩ, wuɔ yaŋ nuɔmba‑i aa naa ta kũŋ. U *hãalãbiemba kã u wulaa ka cira: «Niŋ naaŋ gbãnalãaŋgu maŋ wuɔ suontieŋo naŋo duu dĩmma aa u bigãarãŋo kã ka naŋ hɛ̃bieŋa dĩmma hɔlma-na, ŋ sa firnu-kuɔ baa-ye i suɔ ku yuŋgu‑i wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesu wuɔ cira: «*Moloŋ-Biɛŋo yaa suontieŋo‑i; u yaa duu dĩmma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","U suoŋgu yaa miwaaŋo‑i. Dĩmma yaa bamaŋ cuu Diiloŋo huoŋ-nu aa hɛ̃bieŋa yaa bamaŋ cuu *Bigãarãŋo huoŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Suontieŋo bigãarãŋo yaa *Sitãni‑i. U yaa kãa ka naŋ hɛ̃bieŋa‑i dĩmma hɔlma-na. Dĩkara-huɔŋgu yaa miwaaŋo tĩmmaŋ-huɔŋgu‑i aa dĩkartaamba yaa *dɔrpɔpuɔrbiemba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Baŋ kaal hĩɛŋgu‑i ba caa-ku dumaa, miwaaŋo tĩmma-na, ku ka waa dumɛi. ");
INSERT INTO cmeNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Yiiŋgu faŋgu-na, Moloŋ-Biɛŋo ka ce u dɔrpɔpuɔrbiemba jo ji bel bamaŋ guɔlaaŋ nuɔmba gbeini‑i baa bamaŋ ciɛŋ ãmbabalma‑i hiere a hiel-ba u nelle-na ");
INSERT INTO cmeNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ka caa-ba dãŋgbɔguɔŋgu-na. Kaaluŋgu siɛ ji waa dɛi. ");
INSERT INTO cmeNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ŋga bamaŋ wuɔyaaŋ Diiloŋ-hũmelle‑i, ba ka waa huɔŋgu faŋgu-na ba To nelle-na ta ba gbu ba caa ŋaa bãansɛ̃niɛŋgu. Umaŋ duɔ u ka nu, u nu!» ");
INSERT INTO cmeNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","«*Diiloŋ-nellentesĩnni dii ŋaa sɛ̃nɛ maŋ fuyaa suoŋgu naŋgu-na, naacolŋo naŋo kã ka paya-yuɔ. U huɔŋga gbuu fɛ̃, u migãaŋ fuo-yo aa kã ka suor u nagãŋ-niini‑i hiere a jo ji sãa suoŋgu faŋgu‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","«*Diiloŋ-nellentesĩnni tiraa ni ye ŋaa torgoceroŋo maŋ taaraayaŋ niibilefafanni duɔ sãa. ");
INSERT INTO cmeNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","U juɔ da sukpekpelluŋ-kũŋgu naŋgu‑i, u kã ka suor u nagãŋ-niini‑i hiere a sãa-ku.» ");
INSERT INTO cmeNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","«*Diiloŋ-nellentesĩnni tiraa ni ye ŋaa tetebeljuɔŋo. Da ba naŋ juɔŋo‑i, duɔ hi teterieŋo teterieŋo, u bel. ");
INSERT INTO cmeNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Da ba fa-ba hel baa-ba hũmma-na, ba kã ka tĩɛna fiɛl baafafaamba‑i aa nanna baababalaamba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Miwaaŋo tĩmma ka waa dumɛi: *Dɔrpɔpuɔrbiemba ka jo ji fiɛl nelbabalaamba‑i hiel-ba nelfafaamba-na ");
INSERT INTO cmeNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ka dii-ba dãŋgbɔguɔŋgu-na. Kaaluŋgu siɛ ji waa dɛi.» ");
INSERT INTO cmeNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesuŋ waaŋ mafamma‑i, wuɔ yuu u *hãalãbiemba‑i wuɔ: «Miŋ waaŋ mamaŋ, na nuɔ-ma hiere wɛi?» Baa cira: «Ũu, i nuɔ-ma.» ");
INSERT INTO cmeNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Yesu wuɔ cira: «*Ãnjĩnamma pigãatieŋo maŋ duɔ hũu-ma hãalã Diiloŋ-nellentesĩnni kũŋgu‑i, uu dii ŋaa dumɛllentieŋo maŋ hielaaŋ bĩmbĩfɛlɛnni‑i baa niicɔlɔnni‑i u muntierammu-na u hã nuɔmba‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesuŋ juɔ naŋ gbãnɛini‑i tĩ, wuɔ ta terieŋgu faŋgu-na ");
INSERT INTO cmeNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","a kã ba nelle-na. Uŋ kãa, wuɔ kã ba *Diilonelhãalãdũŋgu-na ka tuɔ waŋ Diiloŋ-nelma‑i baa-ba. Kuɔ cu ba hɔmmu‑i. Baa ta ba piiye wuɔ: «Fuɔ kaa hel baa nelnul daade‑i hie? U ciɛ niɛ tuɔ gbã u ce hiŋ daama temma‑i? ");
INSERT INTO cmeNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ma sĩ fãnaŋo biɛŋo yaa kɛ? Maari biɛŋo'i sĩ wɛi? Fuɔ hãaŋo naŋo yaa baŋ bĩŋ-yoŋ Sake‑i, unaŋo‑i Yosɛfu, unaŋo‑i Simɔ aa unaŋo‑i *Yuda. ");
INSERT INTO cmeNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","U tũɔbaa-ba dii baa-ye tĩɛnamma-na. Fuɔ kaa hel baa hiŋ daama‑i hie?» ");
INSERT INTO cmeNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Kuŋ ciɛ dumaaŋo-na, ba saa gbãa hũu Yesu nelma‑i. Yesu wuɔ gbɛ̃-ba wuɔ: «Ba kãŋ *Diilopɔpuɔrbiloŋo‑i terni-na hiere; ŋga u nelleŋ-baamba‑i baa u dũŋ-baamba sa kãŋ-yo.» ");
INSERT INTO cmeNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Baŋ'a ba saa hũu u nelma‑i dumaaŋo-na, u saa ce gbɛrɛ-wɛima bɔi terieŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Yibieŋa faŋa-na, fãamaaŋo maŋ waa *Galile yuŋgu-na, wuɔ nu ba piiye Yesu maama‑i. Ba taa ba bĩ-yo *Erɔdi-Ãntipasi. ");
INSERT INTO cmeNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Wuɔ gbɛ̃ u maacembiemba‑i wuɔ: «Naacolŋ daayo‑i mi suyaa miɛ *Nsãa-Batisi yaa birii jo. U hilaa kuoŋ-nelle-na jo, ku'i ciɛ u hi hiŋ daama temma‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","A ne da Erɔdi fuɔ fɛrɛ yaa naa ciɛ ba bel Nsãa‑i vaa-yo aa dii-yo kaso Erodiyadi maa-na. Erodiyadi faŋo waa u mɔlɔ̃ ciɛŋo aa u hũu-yo mɔlŋo wulaa. Ba taa ba bĩ mɔlŋo‑i Filipu. ");
INSERT INTO cmeNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Uŋ hũyãa-yo dumaaŋo-na, Nsãa wuɔ waŋ-ma baa-yo wuɔ fuɔ uudiiŋo sĩ. ");
INSERT INTO cmeNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Erɔdi wuɔ tuɔ taara u ko-yo. Ŋga nuɔmba‑i hiere baa naa suɔ wuɔ Nsãa waa *Diilopɔpuɔrbiloŋo. Erɔdi duɔ ne terieŋgu faŋgu‑i, korma da-yo baa nuɔmba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Yiiŋgu naŋgu-na, Erɔdi wuɔ ji tuɔ ce u hommaŋ-yiiŋgu ponsaaŋgu‑i aa naa bĩ u jɛ̃naamba‑i. Erodiyadi biloŋ wuɔ nyɛŋ Erɔdi jɛ̃naamba yaaŋga-na ponsaaŋ daaku-na; kuɔ fũnuŋ dɔlnu Erɔdi. ");
INSERT INTO cmeNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Wuɔ pã nuŋgu baa biloŋo‑i wuɔ fuɔ baa Diiloŋo, kɛrɛ uŋ taaraŋ kumaŋ, u waŋ-ma, u ka hã-yo baa-ku. ");
INSERT INTO cmeNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Biloŋo nyu wuɔ gbo-yo wuɔ u cira u taara Nsãa-Batisi yuŋgu. Biloŋ wuɔ bi cira: «Mi taara ŋ kar Nsãa-Batisi yuŋgu‑i a dii-ku tasaaŋ-na jo baa-ku ji hã-mi bande.» ");
INSERT INTO cmeNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Fãamaaŋo yaaŋ kaa pãŋ bir ka deŋ birma; ŋga u ka ce-ma niɛ? U yaa pãa nuŋgu‑i baa-yo nuɔmba-na. Wuɔ naa wuɔ cira: «Wɛima sĩ.» ");
INSERT INTO cmeNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Aa naa puɔr ba kã ka kar Nsãa-Batisi yuŋgu‑i dii kaso‑i-na ");
INSERT INTO cmeNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","a dii-ku tasaaŋo-na ji hã biloŋo‑i baa-ku. Biloŋ wuɔ hũu-ku hã nyuŋo‑i baa-ku. ");
INSERT INTO cmeNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Nsãa *hãalãbieŋ baa kã ka biɛ u bomborre‑i ka fuure-diɛ aa naa kã ka tũnu Yesu‑i baa-ma. ");
INSERT INTO cmeNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesuŋ nuɔ nel daama‑i, wuɔ biɛ beŋo ta tuɔ kã u deŋ. Nuɔŋ baa yagar nu-ma aa naa hel nilɛiŋa-na a bella nuoraaŋgu nuŋgu‑i ta ba nyaanu-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Uŋ kaa hi, wuɔ huɔl, wuɔ u ne da nelpũŋgu naŋ temma u yaaŋga-na. Ba hujarre gbuu bel-o. Wuɔ doŋ tuɔ sire jaamba maŋ waa baa-ba. ");
INSERT INTO cmeNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Bãaŋguŋ juɔ hir huɔŋgu-na, u *hãalãbiemba piɛ kã u wulaa ka cira: «Bãaŋgu tĩɛ tĩ, aa ii dii hĩɛŋ-nu, ŋ sa ce nuɔmba bɔrɔ kã nilɛiŋa maŋ kɔtɔnni-na ka taara niiwuoni sãa wuo wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesu wuɔ cira: «Yuŋgu si dii ba da ba kã; namɛi saaya na hã-ba niiwuoni‑i ba wuo.» ");
INSERT INTO cmeNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","U hãalãbieŋ baa cira: «*Buruo u ndii dii baa-ye bande‑i-na yoŋ baa titiraamba hãi.» ");
INSERT INTO cmeNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesu wuɔ cira: «Juɔŋ baa-ni na ji hã-mi.» ");
INSERT INTO cmeNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Baa jo baa-ni, wuɔ ce nuɔmba tĩɛna hĩɛŋgu-na, aa naa biɛ buruo u ndii daayo‑i baa titiraamba hãi baaŋ daaba‑i a ciir u yuŋgu‑i dɔrɔ‑i-na a jaal Diiloŋo‑i aa naa bũlnu buruo‑i a hã u hãalãbiemba calnu-yuɔ hã nuɔmba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Nuɔŋ baa wuo niɛ yar-ba. Baa gbura ni boini‑i a dii segeyufieŋ cĩncieluo a hãi. ");
INSERT INTO cmeNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Bamaŋ naa waa, ba gbãa yu nuɔmba neifieŋa hãi nuɔsiba ndii temma. Caamba nuŋgu sĩ baa bisãlmba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Baŋ bi wuyaa niiwuoni‑i, Yesu wuɔ guor u *hãalãbiemba biɛ beŋo‑i ta u yaaŋ-na ta ba karnu ba kã bomborre nande-na aa fuɔ wuɔ tĩɛna duɔ ce nuɔmba bɔrɔ kũŋ ba cĩnniŋ. ");
INSERT INTO cmeNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Nuɔmbaŋ juɔ bɔrɔ hiere, wuɔ kã ka nyugũŋ tãnuŋgu-na tuɔ cãrã Diiloŋo‑i. Bãaŋguŋ fiɛ ji tĩ, wuɔ tĩɛna dii u da-u-diei tuɔ cãrã Diiloŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","A ne da huɔŋgu faŋgu-na, u hãalãbiemba naa maa baa beŋo‑i. Fafalmu naŋ temma sire ta mu jãrã-bɛi. Hũŋ maa ta ma sagalla beŋo‑i baa-ba. ");
INSERT INTO cmeNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Cicãnjãale-na, Yesu wuɔ sire a tuɔ wuɔ hũmma dɔrɔ‑i-na u kã ba wulaa. ");
INSERT INTO cmeNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Baŋ juɔ'a ba ne da u wuɔ u jo hũmma dɔrɔ‑i-na, ba hulɛiŋa gbuu pãŋ caar wuɔ sĩ isuɔtieŋo. Baa doŋ ta ba kaasĩŋ. ");
INSERT INTO cmeNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yesu wuɔ cira: «Baa na tie holle, muɔmɛi!» ");
INSERT INTO cmeNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Piɛr wuɔ cira: «Itie, da kuɔ nuɔnɛi kelkel, ce mi wuɔ hũmma dɔrɔ‑i-na kã ŋ wulaa.» ");
INSERT INTO cmeNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesu wuɔ cira: «Jo!» Piɛr wuɔ hel beŋo-na tuɔ wuɔ hũmma dɔrɔ‑i-na u jãrã-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Uŋ juɔ jɔguɔŋ fafalmu maama‑i, u holle pãŋ caar, wuɔ doŋ tuɔ nyiɛrã hũmma-na. Uŋ nyiɛrãŋ dumaaŋo-na, wuɔ tuɔ kaasĩŋ wuɔ: «Itie, kor-mi o! Kor-mi!» ");
INSERT INTO cmeNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yesu wuɔ fara u naŋga‑i a bel-o aa naa cira: «Ŋ saa haa ŋ naŋga‑i miɛ ku haama ku'i ciɛ. Bige‑i ciɛ ŋ ce ŋ hɔmmu‑i mu hãi?» ");
INSERT INTO cmeNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Uŋ bilaa u naŋga‑i dumaaŋo-na, baa kã ka suur beŋo-na, fafal muɔ bi pãŋ yiɛra. ");
INSERT INTO cmeNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Bamaŋ waa beŋo-na, baa jo ji dũuna Yesu yaaŋga-na aa naa cira: «Coima saa fa, nuɔnɛi Diiloŋ-Biɛŋ nuɔŋo‑i kelkel!» ");
INSERT INTO cmeNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Fafalmuŋ yiɛraaya, Yesubaa baa perieŋ karnu kã Genesarɛti. ");
INSERT INTO cmeNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Genesarɛtitaambaŋ daa Yesu‑i, baa suɔ-yo aa naa wuɔra tũnu ba-naa ka hel baa kɔtɔnniŋ-nilɛiŋa‑i hiere. Nuɔŋ baa hel jo baa ba jaamba‑i hiere ");
INSERT INTO cmeNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ji ta ba cãrã-yuɔ wuɔ u ce jande aa u yaŋ ba yiɛya u joŋgoruo tũŋgu yaa yoŋ. Ku waa umaŋ duɔ yiɛya u joŋgoruo tũŋgu‑i, kutieŋo pãŋ sire da yeryer. ");
INSERT INTO cmeNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ku huoŋgu-na, *Farisĩɛbaa-ba namba‑i baa *ãnjĩnamma pigãataamba namba sire *Yerusalɛmu‑i-na a kã Yesu wulaa ");
INSERT INTO cmeNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","ka yuu-yo wuɔ: «Bige‑i ciɛ ŋ *hãalãbiemba sa wuɔ bĩncuɔŋ-hũmelle‑i? Da ba'a ba wuo niiwuoni‑i ba sa saara ba nammu‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesu wuɔ cira: «Bige‑i bi ciɛ namaa na yaŋ Diiloŋo uŋ waaŋ mamaŋ aa ta na ce na bĩncuɔŋ-maama? ");
INSERT INTO cmeNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Diiloŋo ciɛra: ‹Ta ŋ dii ŋ bĩncuɔmba nuŋgu‑i.› Aa tiraa cira: ‹Umaŋ duɔ waŋ ãndaparaaŋgu hã u to‑i sisɔ u nyu‑i, kutieŋo saaya komma.› ");
INSERT INTO cmeNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ŋga namaa birii cira wuɔ umaŋ duɔ waŋ baa u bĩncɔiŋo‑i wuɔ: ‹Miŋ ŋa naa da kumaŋ da mi kãyã-niɛ, mi pãa-ku hã Diiloŋo.› Kɛrɛ umaŋ duɔ ce mafamma‑i aa u saa ji feŋ da bĩŋkũŋgu hã u bĩncɔiŋo‑i wɛima sĩ. ");
INSERT INTO cmeNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Terieŋgu faŋgu-na, na huraa Diiloŋ-nelma‑i baa na bĩncuɔŋ-maama. ");
INSERT INTO cmeNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Huhurmantaaŋ namaa temma‑i daana‑i; *Isayiŋ fii-na baa kumaŋ, na yuu-ku. Isayi waaŋ-ma wuɔ: ‹Diiloŋo ciɛra wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","«Nel daade taamba kãŋ-mi ba nuŋ-nu yoŋ. Mi maama si dii ba hɔmmu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Baŋ pigãaŋ nuɔmba‑i hũmelle maŋ, bafamba diele. A ce dumaaŋo-na, yuŋgu si dii ba Diilojaale-na.»›» ");
INSERT INTO cmeNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesuŋ piiye mafamma‑i, wuɔ bĩ nuɔmba‑i a ji cira: «Karaaŋ na tũnni‑i fafamma na nu mi nelma‑i: ");
INSERT INTO cmeNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Kumaŋ suuriiŋ nɛliɛŋ nuɔ ŋ nuŋgu-na, ku siɛ gbãa guɔla-niɛ Diiloŋ-hũmelle-na. Kumaŋ hilaaŋ, ku yaa gbãa guɔla-niɛ.» ");
INSERT INTO cmeNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","U *hãalãbiemba piɛ u caaŋ-nu ka cira: «Ŋ saa suɔ wuɔ ŋ nelma jaaŋ *Farisĩɛbaa-ba‑i wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yesu wuɔ cira: «Mi To maŋ dɔrɔ‑i-na, uŋ'a u saa sũ tibinni maŋ hiere, ni ka fuur halaŋ. ");
INSERT INTO cmeNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Yaaŋ-baŋ, baa dii ŋaa yiriemba maŋ bilaa ba nayirieŋ nammu. Na suyaa kerre yiroŋ duɔ bel u nayiroŋ naŋga, ba ka par suur fuoŋ-nu ba hãi‑i-na hiere.» ");
INSERT INTO cmeNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Piɛr wuɔ cira: «Niŋ waŋ nelma maŋ daama‑i i saa suɔ ma yaaŋga‑i; firnu-mɛi baa-ye.» ");
INSERT INTO cmeNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesu wuɔ cira: «Bisãlmba'i namaaŋo‑i yogo wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Namaa saa suɔ wuɔ kumaŋ suuriiŋ nɛliɛŋ nuɔ ŋ nuŋgu-na ku kã ŋ kusũŋ-nu aa cor ka ce biniɛŋa wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","A ne da nɛliɛŋ nuɔ niŋ waŋ mamaŋ ŋ nuŋgu-na, ma hel ŋ huɔŋga'i nuɔ‑i; ma yaa gbãa guɔla-niɛ Diiloŋ-hũmelle-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ãnjɔgɔbabalamma hel nɛliɛŋ nuɔ ŋ huɔŋga'i nuɔ‑i: Ŋ huɔŋga'i diyaaŋ-niŋ nelkolle-na, *fuocesĩnni-na, bĩŋwosĩnni-na, cuosĩnni-na, coikarre-na, baa yebĩɛnande-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Daama temma yaa guɔlaayaŋ nɛliɛŋ nuɔŋo‑i. Ŋga a wuo niiwuoni‑i ŋ saa saara nammu‑i, kufaŋgu siɛ gbãa guɔla-niɛ.» ");
INSERT INTO cmeNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ku huoŋgu-na, Yesu wuɔ ta terieŋgu faŋgu-na a kã Fenisi mara nuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","A ne da nerciɛŋo naŋo waa terieŋgu faŋgu-na. Yesuŋ kãa, ciɛŋ daa wuɔ cu u huoŋ-nu tuɔ fara u piiye baa-yo wuɔ: «Itie, *Davidi hãayɛ̃lŋ nuɔ, jande ce hujarre-miɛ! *Jĩna naŋo dii mi biloŋo yuŋgu-na, kuu si dii-yuɔ dɛi.» ");
INSERT INTO cmeNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Yesu saa seŋ sũnuŋgu yuɔ. U *hãalãbiemba piɛ u caaŋ-nu ka cira: «Itie, ŋ sa bir ciɛŋ daayo‑i i huoŋgu-na wɛi? Ŋ saa da uŋ ceŋ ijieni‑i u nyaanu-yiɛ wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesu wuɔ cira: «Diiloŋo puɔraa-mi *Isirahɛl-baamba yaa wulaa‑i yoŋ, baa dii ŋaa tũlmba maŋ baala.» ");
INSERT INTO cmeNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ciɛŋ daa wuɔ jo ji dũuna u yaaŋga-na aa naa cira: «Itie, jande suuye-miɛ!» ");
INSERT INTO cmeNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yesu wuɔ cira: «Da ŋ biɛ bisãlmba niiwuoni‑i hã juoraamba baa-ni ku saa fa.» ");
INSERT INTO cmeNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ciɛŋ wuɔ cira: «Itie, ŋ waaŋ ninsoŋo, ŋga ma sĩ juoroŋo tieŋ duɔ wuo niiwuoni‑i aa nimaŋ diire, juoroŋo wuo-ni kɛ?» ");
INSERT INTO cmeNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Uŋ waaŋ mafamma‑i Yesu wuɔ cira: «Ciɛŋ nuɔ, ŋ haa ŋ naŋga‑i miɛ kelkel! Niŋ taaraŋ kumaŋ, Diilo ka hã-ni baa-ku.» Terduɔŋgu faŋgu-na, biloŋ wuɔ bi pãŋ da u fɛrɛ. ");
INSERT INTO cmeNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu wuɔ ta terieŋgu faŋgu-na a kã *Galile dalaŋga-na ka nyugũŋ tãnuŋgu naŋgu-na tĩɛna. ");
INSERT INTO cmeNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Nuɔŋ baa kũɔl ba-naa ta ba kã u wulaa baa ba jaamba‑i: Cisɛduɔlbaa-ba waa, yiriemba waa, murgubaa-ba waa, bobobaa-ba waa a naara jaamba namba. Ba saa waa dɛi. Umaŋ duɔ jo baa u wuoŋo, u jo ji jĩna-yuɔ Yesu caaŋgu-na. Yesu wuɔ sire-bɛi hiere kpɛ̃mmu! ");
INSERT INTO cmeNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Bobobaa-ba piiye, murgubaa-ba siire ta ba wuɔ, cisɛduɔlbaa-ba wuɔ fafamma, yiriemba yufieŋa puurii. Kuɔ ce nuɔmba‑i gbɛrɛ. Baa ta ba gbɛliɛŋ *Isirahɛl-baamba Diiloŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesuŋ waa dalaŋga-na, yiiŋgu naŋgu-na, wuɔ bĩ u *hãalãbiemba‑i a tuɔ piiye baa-ba wuɔ: «Nuɔŋ daaba hujarre ko-mi; ba yinni siɛi yaa dɛ‑i baa-mi ba saa da bĩŋkũŋgu wuo. Da mi ce ba ta baa nyulmu‑i, ku kaa nuɔl-ba hũmelle-na.» ");
INSERT INTO cmeNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","U hãalãbiemba yuu-yo wuɔ: «I ka da niiwuoni‑i hie hĩɛŋ daaku-na diɛ hã nelpũŋ daaku da ku wuo ye?» ");
INSERT INTO cmeNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu wuɔ yuu-ba wuɔ: «*Buruo u niɛ dii baa-na?» Baa cira: «Buruo niehãi baa tetebiemba namba.» ");
INSERT INTO cmeNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Yesu wuɔ gbɛ̃ nuɔmba‑i wuɔ ba tĩɛna hĩɛma-na ");
INSERT INTO cmeNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","aa naa biɛ buruo niehãi daayo‑i baa tetebieŋ daaba‑i a jaal Diiloŋo‑i aa naa bũlnu-niɛ hã u hãalãbiemba calnu-niɛ hã nuɔmba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nuɔmba‑i hiere baa wuo niɛ yar-ba. Baa gbura ni boini‑i a dii segeyufieŋ niehãi. ");
INSERT INTO cmeNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Bamaŋ naa waa, ba gbãa yu nuɔmba neifieŋa hãi temma. Caamba nuŋgu sĩ baa bisãlmba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Baŋ juɔ wuo tĩ, Yesu wuɔ ce ba bɔrɔ kũŋ ba cĩnniŋ aa fuɔ wuɔ kã ka biɛ beŋo tuɔ kã Magadã. ");
INSERT INTO cmeNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ku huoŋgu-na, *Farisĩɛbaa-ba namba‑i baa *Sadusĩɛbaa-ba namba siire kã Yesu wulaa wuɔ ba ka piiye cure-yuɔ. Baŋ kãa, baa cira: «Hãalãtie, ce himma namma i ne, mamaŋ pigãaŋ wuɔ ŋ juɔ Diiloŋ-jomma.» ");
INSERT INTO cmeNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yesu wuɔ cira: «Bãaŋ da ku ta ku suur huɔŋgu maŋ nuɔ‑i, da na ne diiloŋo yaaŋga‑i da-ka dãa, na cira: ‹Diiloŋo siɛ dãa, terieŋgu ka fa.› ");
INSERT INTO cmeNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Aa da na sire cucuuyuŋgu-na a da diiloŋo yaaŋga saa fa, na cira: ‹Diiloŋo ka dãa nyuŋgo‑i-na.› Na ciɛ niɛ ta na suɔ diiloŋo yammu‑i na bɔrɔ-muɔ aa na sa suɔ mamaŋ ciɛŋ fiɛfiɛ‑i-na ma yuŋgu‑i? ");
INSERT INTO cmeNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Fiɛfiɛ ku nuɔmba saa fa, ba jɛ̃naamba sa ku. Ba gbĩɛ-ku dumaa wuɔ mi ce himma ba ne. Bĩŋkũŋgu sa ce dii hã-na. *Yonasi maama ka saanu baa-na.» Uŋ waaŋ mafamma‑i, wuɔ ta aa naa yaŋ-ba. ");
INSERT INTO cmeNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yesubaa-baŋ taa terieŋgu-na, baa kã ka biɛ beŋo ta ba karnu ba kã dalaŋga yiɛŋgu naŋgu-na. A ne da baŋ'a ba ta, ma saa tĩɛnu u *hãalãbiemba biɛ *buruo. ");
INSERT INTO cmeNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesu wuɔ gbɛ̃-ba wuɔ: «Jande, bilaaŋ na fɛrɛ *Farisĩɛ ba siini-na baa *Sadusĩɛ ba bi niini-na.» ");
INSERT INTO cmeNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","U hãalãbieŋ baa doŋ ta ba piiye ba-naa nuɔ wuɔ: «Iŋ'a i saa biɛ buruo ku'i ciɛ u tuɔ piiye dɛ‑i-na.» ");
INSERT INTO cmeNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesu wuɔ suɔ baŋ waŋ mamaŋ. Wuɔ cira: «Na saa haa na naŋga‑i miɛ ku haama. Na bilaa-ma niɛ aa cira naŋ'a na saa biɛ buruo ku'i ciɛ mi ta mi piiye dɛ‑i-na? ");
INSERT INTO cmeNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Na saa suɔ ku yaaŋga‑i yogo wɛi? Naŋ calaanu buruo u ndii maŋ hã nuɔmba neifieŋa hãi nuɔsiba ndii ba wuo u yar-ba, u maama karaanu-nɛi wɛi? Aa naŋ biyaa segeyufieŋa maŋ ta ku yiiŋgu-na, a maama karaanu-nɛi wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","A naara buruo niehãi maŋ naŋ calaanu-yuɔ hã nuɔmba neifieŋa hãi ba wuo u yar-ba, mafamma karaanu-nɛi wɛi? A tiraa naara segeyufieŋa maŋ naŋ biyaa-ya ta kufaŋgu yiiŋgu-na a maama karaanu-nɛi wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Naa naa gbɛ̃ na suɔ wuɔ miŋ ciɛra na bel na fɛrɛ Farisĩɛ ba siini-na baa Sadusĩɛ ba niini-na, mi sa waŋ bur-maama!» ");
INSERT INTO cmeNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Terieŋgu faŋgu-na, u hãalãbiemba suɔ suɔ wuɔ u saa cira ba bel ba fɛrɛ siiniŋ-kerreŋ, ŋga wuɔ ba bel ba fɛrɛ Farisĩɛ ba nelma'i nuɔ‑i baa Sadusĩɛ ba maama-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesubaa baa kãa kunaŋgu‑i Sesare maŋ Filipu wuoŋo-na. Yesu wuɔ ka yuu u *hãalãbiemba‑i wuɔ: «Nuɔŋ ba'a hai moloŋo‑i *Moloŋ-Biɛŋo‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","U hãalãbieŋ baa cira: «Banamba ciɛra nuɔnɛi *Nsãa-Batisi‑i; banaŋ ba'a nuɔnɛi *Eli‑i; banaŋ ba'a *Seremi; banaŋ ba'a *Diilopɔpuɔrbiloŋo naŋ nuɔ.» ");
INSERT INTO cmeNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yesu wuɔ cira: «Aa namaa fuɔ, na'a hai moloŋ muɔmɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simɔ-Piɛr wuɔ cira: «Diiloŋ uŋ pãa nuŋgu‑i aa saaŋ *Koŋkortieŋo maŋ, u yaa nuɔŋo‑i. Cicɛ̃lmantieŋo Biɛŋo yaa nuɔŋo‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesu wuɔ cira: «Piɛr, Nsãa biɛŋ nuɔ, naŋ yuŋgu dɔlaa, niŋ waaŋ mamaŋ daama‑i naŋ kusũŋ-maama sĩ, mi To maŋ dɔrɔ‑i-na, u yaa diyaa-ma ŋ nuŋgu-na.» ");
INSERT INTO cmeNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Aa naa cira: «Piɛr, ŋ yerre yuŋgu yaa wuɔ tãmpɛ̃lle. Mi tũnu-niɛ: Mi ka fu mi dũŋgu‑i tãmpɛ̃lle fande yaa nuɔ‑i. *Sitãni yufelle kuɔ, u siɛ gbãa ce-ku bĩŋkũŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Mi ka hã-ni *Diiloŋ-nelle dieŋa‑i: Da ŋ cĩina kumaŋ hĩɛma-na bande‑i-na, ba ka cĩina ku bĩŋkũŋgu‑i dɔrɔ‑i-na; da ŋ bi siɛ kumaŋ hĩɛma-na bande‑i-na, ba ka bi siɛ ku bĩŋkũŋgu‑i dɔrɔ‑i-na.» ");
INSERT INTO cmeNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Aa naa waŋ-ma kuola-mɛi baa-ba wuɔ ba baa yaŋ ma hel wuɔ Diiloŋ uŋ saaŋ *Koŋkortieŋo maŋ u yaa ufaŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","A doŋ huɔŋgu faŋgu-na, Yesu wuɔ doŋ tuɔ piiye u pigãaŋ u *hãalãbiemba‑i wuɔ: «Da ku fiɛ ce niɛ niɛ, fuɔ mi kã *Yerusalɛmu‑i-na. Da mi kã, nelle bĩncuɔmba‑i baa *Diilojigãntaamba yuntaamba‑i a naara *ãnjĩnamma pigãataamba ka ce-mi sũlma aa ko-mi. Ŋga da ba ko-mi, mi ka ce yinni hãi yoŋ hĩɛma-na, siɛliŋ-yiiŋgu‑i, mi ka sire hel jo.» ");
INSERT INTO cmeNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Uŋ waaŋ mafamma‑i, Piɛr wuɔ bĩ-yo ba kã ba deŋ ka tuɔ waŋ baa-yo wuɔ: «Itie, baa ta ŋ piiye dumaa, ku saa fa. Diilo baa jo baa-ma, Diilo siɛ hũu-ma ma ce.» ");
INSERT INTO cmeNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yesu wuɔ ne-yo da fĩɛ aa naa cira: «*Sitãni, kã ŋ halaŋ mi caaŋ-nu! Ŋ taara ŋ guɔl mi gbeini‑i wuɔ niɛ? Ŋ kusũŋ-maama‑i Diiloŋ-maama sĩ, nelbilieŋ-maama.» ");
INSERT INTO cmeNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ku huoŋgu-na, Yesu wuɔ gbɛ̃ u hãalãbiemba‑i wuɔ: «Umaŋ duɔ tuɔ taara u cu mi huoŋ-nu, kutieŋo saaya u cĩina u fɛrɛ, aa u bi saaya u siɛ mulĩɛma‑i baa kuliiŋgu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Umaŋ duɔ tuɔ kaal baa u yuŋgu yoŋ, kutieŋo ka kɔsuɔŋ u fɛrɛ; ŋga umaŋ duɔ tuɔ kɔsuɔŋ u fɛrɛ mɛi maama-na, kutieŋo ka da cicɛ̃lma maŋ sa tĩɛŋ dede‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Nɛliɛŋ nuɔ da ŋ da ŋ yufieŋ-niini‑i hiere miwaaŋo-na aa ka caa, yuŋ haku‑i dii-kuɔ? Nɛliɛŋ nuɔ ŋ gbãa sãa ŋ yuŋgu‑i baa bige‑i Diiloŋo wulaa? ");
INSERT INTO cmeNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","*Moloŋ-Biɛŋo ka jo baa u To fɔ̃ŋgũɔ‑i baa u *dɔrpɔpuɔrbiemba‑i. Duɔ jo, u ka pã nuɔmba‑i ba maacemma sullu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Yaaŋ mi waŋ ninsoŋo‑i baa-na: Banamba dii na hɔlma-na bande‑i-na, ba siɛ hi ku, ba ka da Moloŋ-Biɛŋo juɔ u fɔ̃ŋgɔ̃tesĩnniŋ-jomma‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Yesuŋ waaŋ mafamma‑i, yinni niediei ku huoŋgu-na, wuɔ ce fuɔ baa Piɛr baa Sake a naara Sake hãaŋo‑i Nsãa, ba kã ba deŋ ka nyugũŋ tãnujaataama naŋo-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ba'a ba ne da Yesu birii u deŋ birma: U yaaŋga caa dumaa ka fɛrɛŋ nuɔ ŋaa bãaŋgu, u joŋgorbaa-ba bir baapiɛlmba ta ba caa da muimui. ");
INSERT INTO cmeNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ba'a ba tiraa ne da *Moisi‑i baa *Eli‑i ba caraaya-bɛi ta ba piiye baa Yesu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Piɛr wuɔ gbɛ̃ Yesu‑i wuɔ: «Itie, i jomma faa bande‑i-na dɛ! Da ŋ siɛ, ŋ yaŋ mi ce gbuganni siɛi: ku diei naŋ kũŋgu, ku diei Moisi kũŋgu, aa ku diei kũŋgu naŋgu‑i Eli kũŋgu.» ");
INSERT INTO cmeNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Nelma saa ji tĩ u nuŋgu-na, nyaasĩnni nanni jo ji cĩnnu-bɛi. Ba'a ba ne da, molo piiye ni huɔŋga-na wuɔ: «Mi Biɛŋo yaa daayo‑i, u maama sa suɔ aa dɔlnu-miɛ. U yaa fĩɛŋ mi huɔŋga‑i. Taa na nu u nuŋgu‑i!» ");
INSERT INTO cmeNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Moloŋ daa uŋ piiye, *hãalãbiemba kũɔma pãŋ ta ma nyɛŋ; baa dũuna hiere nisĩŋ ba yunni‑i hĩɛma-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yesu wuɔ piɛ a wuɔra haa u naŋga‑i bɛi aa naa cira: «Baa na kãalã; siireŋ!» ");
INSERT INTO cmeNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ba ciirii ba yunni‑i ku yaa nuɔ‑i, a da Yesu yaa u diei yoŋ. ");
INSERT INTO cmeNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Baŋ juɔ ta ba hiire tãnuŋgu-na, Yesu wuɔ waŋ-ma kuola-mɛi baa-ba wuɔ *Moloŋ-Biɛŋ duɔ saa sire hel kuomba hɔlma-na, ba baa waŋ nel daama‑i baa moloŋo. ");
INSERT INTO cmeNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","U hãalãbieŋ baa cira: «Ma sĩ *ãnjĩnamma pigãataamba ciɛra wuɔ Eli yaa saaya u bir jo igɛ̃na aa Diiloŋ uŋ pãa nuŋgu‑i wuɔ u ka saaŋ *Koŋkortieŋo maŋ, u suɔ jo kɛ?» ");
INSERT INTO cmeNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesu wuɔ cira: «Ba saa kar coima, Eli naa saaya u jo ji migãaŋ wɛima‑i hiere, ");
INSERT INTO cmeNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","ŋga mi tũnu-nɛi: Eli juɔ tĩ. Uŋ juɔ, ba saa suɔ wuɔ u yaa‑i, ba ce ba bãaŋgu‑i yuɔ. Ba ka bi ce ba bãaŋgu‑i Moloŋ-Biɛŋo-na dumɛi.» ");
INSERT INTO cmeNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Terieŋgu faŋgu-na, u hãalãbiemba suɔ suɔ wuɔ u gbɛ̃ *Nsãa-Batisi yaa dumaaŋo-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Baŋ hiiriiye tãnuŋgu-na ka hi nuɔmba terieŋgu‑i, naacolŋo naŋ wuɔ piɛ ka dũuna Yesu yaaŋga-na aa naa cira: ");
INSERT INTO cmeNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","«Itie, jande ce hujarre mi biɛŋo-na aa ŋ sire-yuɔ; kurmɔrɔ̃ŋo dii-yuɔ, ku si dii-yuɔ dɛi. Da ku sire-yuɔ dɛ‑i-na, kuniɛ u cii suur dãamu-na, kuniɛ u cii suur hũmma-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mi juɔ baa-yo ŋ *hãalãbiemba wulaa, ŋga u maama yaraa-ba.» ");
INSERT INTO cmeNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesu wuɔ cira: «Fiɛfiɛ ku nuɔŋ namaaŋo‑i na sa hũu nɛliɛŋ maama, na saa fa! Na daa niɛ sĩ mi ka tĩɛna baa-na gbula wɛi? Namaa ji hũu mɛi maama‑i yaku‑i?» Aa naa cira: «Juɔŋ baa naacombiloŋo‑i bande.» ");
INSERT INTO cmeNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Baa jo baa naacombiloŋo‑i. *Jĩna'i naa ciɛ-yo dumaaŋo-na. Yesu wuɔ nuola jĩna‑i wuɔ u cor u hel naacombiloŋo-na. Jĩna wuɔ bi hel. Naacombiloŋ wuɔ da u fɛrɛ. ");
INSERT INTO cmeNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Jĩnaŋ hilaa, hãalãbiemba piɛ ba kula a yuu Yesu‑i wuɔ: «Bige‑i ciɛ miɛ i saa gbãa donya-yuɔ?» ");
INSERT INTO cmeNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesu wuɔ cira: «Na saa haa na naŋga‑i miɛ ku haama ku'i ciɛ. Yaaŋ mi waŋ ninsoŋo‑i baa-na: Halle da na fiɛ haa na niele‑i miɛ yoŋ, wɛima siɛ gbãa yar-na cemma: Na gbãa gbɛ̃ tãnuŋ daaku‑i wuɔ ku sire kã dii daalɛi, aa ma bi ce.»  ");
INSERT INTO cmeNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Aa naa cira: «Jĩna daayo temma‑i, da na saa dii sũŋgu aa cãrã Diiloŋo‑i na siɛ gbãa donya-yuɔ.» ");
INSERT INTO cmeNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Yiiŋgu naŋgu-na, Yesu‑i baa u *hãalãbiemba waa ta ba wuɔra *Galile huɔŋga-na, Yesu wuɔ tuɔ piiye baa-ba wuɔ: «Yiiŋgu dii baa yiiŋgu, ba ka bel *Moloŋ-Biɛŋo‑i hã nuɔmba‑i baa-yo ");
INSERT INTO cmeNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ba ko-yo. Ŋga da ba ko-yo, u ka ce yinni hãi yoŋ hĩɛma-na, siɛliŋ-yiiŋgu‑i u ka sire hel jo.» U hãalãbiemba nuɔ mafamma‑i ce niɛ? Baa gbuu pãŋ vãa ba yammu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Baŋ kaa hi Kafarnamu‑i, bamaŋ hũyãaŋ *Diilodubuɔ nampo‑i, baa piɛ yuu Piɛr wuɔ: «Na hãalãtieŋo pã Diilodubuɔ nampo‑i wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Piɛr wuɔ cira: «U sa pã-yo wuɔ bige‑i ciɛ?» Piɛrŋ juɔ jo ji tuɔ suur, Yesu wuɔ sĩɛŋ-yo cira: «Piɛr, naŋ wulaa haba‑i pãaŋ nampo‑i ba hã fɔ̃ŋgɔ̃taamba‑i hĩɛma-na bande‑i-na? Ba bisãlmba'i pãaŋ-yoŋ waa niɛraamba'i pãaŋ-yoŋ?» ");
INSERT INTO cmeNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Piɛr wuɔ cira: «Niɛraamba'i pãaŋ-yoŋ.» Yesu wuɔ cira: «Kuu dii ŋaa ba bisãlmba nuŋgu si dii nampo pãmma-na; dumɛi sĩ wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ŋga, mi sa taara i guɔla Diilodubuɔ yaataamba hɔmmu‑i. Kã nuoraaŋgu-na ŋ ka dii halle. Da ŋ ka bel teterieŋo maŋ dĩɛlã-wuoŋo‑i, ŋ gbaar u nuŋgu‑i, ŋ ka da warbelle nande, ŋ hiel-de ŋ ka pã mɛi nampo‑i baa naŋ bi wuoŋo‑i hiere; di ka gbɛ̃.» ");
INSERT INTO cmeNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Huɔŋgu faŋgu-na, Yesu *hãalãbieŋ baa piɛ u caaŋ-nu ka cira: «Itie, hai nelbuɔ‑i *Diiloŋ-nelle-na?» ");
INSERT INTO cmeNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesu wuɔ bĩ bisãmbiloŋo naŋo a ji yiɛra-yuɔ ba hɔlma-na ");
INSERT INTO cmeNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","aa naa cira: «Yaaŋ mi waŋ ninsoŋo‑i baa-na: Da ŋ da na saa bir ce bisãmbieŋ temma, na cɛraa na suur Diiloŋ-nelle-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Umaŋ duɔ hiire u fɛrɛ a ce u fɛrɛ cɛkũɔ bisãmbiloŋ daayo temma‑i, kufaŋgu tieŋo yaa nelbuɔ‑i Diiloŋ-nelle-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Na saa da, umaŋ duɔ ne muɔŋo‑i aa bel bisãmbiloŋ daayo temma‑i fafamma, kuu dii ŋaa u bilaa mɛi fɛrɛ yaa‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","«Bisãmbiemba maŋ haa ba naŋga miɛ daaba‑i hiere, umaŋ duɔ guɔl unaŋ gbeini bɛi Diiloŋ-hũmelle-na, sũlma haraa kutieŋo-na! Kuɔ baa na to namɛlle u nuoŋgu-na aa sɛ-yo dii-yo nuoraaŋ-nu u ciire, kuu naa buɔ-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","«Sũlma haraa nelbiliemba-na; ba siɛ gbãa naa kuubabalaaŋgu muncemmu‑i, ŋga umaŋ duɔ dii u nanolŋo‑i ku cemma-na, sũlma haraa kutieŋo-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","«Da ŋ da ŋ naŋga dii-ni kuubabalaaŋgu cemma-na, sisɔ ŋ gboluoŋgu, kar-ku ŋ nanna dii daalɛi. Da ŋ suur Diiloŋ-nelle-na ba naŋga diei, sisɔ baa gboluoŋgu diei, ku bɔyaa ba ka caa-ni baa ŋ nammu‑i mu hãi‑i-na, sisɔ baa ŋ gbeini‑i ni hãi‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","«Da ŋ da ŋ yufelle dii-ni kuubabalaaŋgu cemma-na, hiel-de ŋ fara ŋ nanna dii daalɛi! Da ŋ suur Diiloŋ-nelle-na baa yufelle diei, ku bɔyaa ba ka caa-ni baa ŋ yufieŋa‑i a hãi‑i-na.» ");
INSERT INTO cmeNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ku huoŋgu-na, Yesu wuɔ cira: «Niɛŋ, taa na kãŋ bisãlŋ daaba‑i hiere, baa na yaŋ u diei. Mi tũnu-nɛi: *Dɔrpɔpuɔrbiemba maŋ niɛyaŋ-bɛi, baa dii baa mi To‑i dɔrɔ‑i-na bãaŋgu‑i baa isuɔŋgu‑i.  ");
INSERT INTO cmeNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","*Moloŋ-Biɛŋo juɔ duɔ ji taara bamaŋ baala a kor-ba.» ");
INSERT INTO cmeNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Aa naa cira: «Namaa wulaa, tũlmba komuɔŋa ndii da ba waa baa umaŋ, aa u diei balla-bɛi, kutieŋo siɛ yaŋ komuɔŋa naa baa cĩncieluo nennaa maŋ tĩyãa ba ta ba wuora aa kã ka taara u diei-wuoŋ daayo‑i wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Mi waŋ ninsoŋo‑i baa-na: Duɔ ka da-yo, u huɔŋga ka gbuu fɛ̃. A ne da komuɔŋa naa baa cĩncieluo nennaa maŋ tĩyãa ba saa balla, bafamba kũŋgu saa gbãa fɛ̃ u huɔŋga‑i fɛ̃ŋ daama temma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ku yaa ŋaa na To maŋ dɔrɔ‑i-na u kũŋgu‑i; u sa taara u diei balla bisãmbieŋ daaba-na.» ");
INSERT INTO cmeNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ku huoŋgu-na, Yesu wuɔ cira: «Ŋ natobiŋ duɔ cãl, kã u wulaa ŋ ka pigãaŋ-yo uŋ cãlãa kusuɔŋ-nu; na hã-na-hãi. Duɔ hũu-ma wuɔ u cãlãa, na cor baa na horre‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Duɔ saa hũu-ma, ŋ yaŋ-yo aa ŋ taara nelduɔŋo ŋ naara ŋ fɛrɛ, sisɔ nuɔmba hãi na kã u wulaa na ka fiɛlnu-mɛi ŋaa Diiloŋ-nelmaŋ waaŋ-ma dumaa wuɔ: ‹Siɛrtaamba hãi sisɔ ba siɛi da ba da nelma maŋ nuɔ‑i, ma ka fiɛlnu.› ");
INSERT INTO cmeNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Duɔ saa ka hũu bafamba maama‑i, kã ŋ ka hi Diiloŋ-dũŋ-baamba‑i baa-ma. Duɔ saa nu Diiloŋ-dũŋ-baamba nuŋgu‑i, baa tiraa ŋ ta ŋ kãŋ-yo na horre-na; ta ŋ kãŋ-yo baa *niɛraamba sisɔ ŋ ta ŋ kãŋ-yo baa nelbabalaamba. ");
INSERT INTO cmeNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","«Mi waŋ ninsoŋo‑i baa-na: Da na cĩina bĩŋkũŋgu bĩŋkũŋgu hĩɛma-na bande‑i-na, ba ka cĩina-kuɔ dɔrɔ‑i-na. Da na bi siɛ bĩŋkũŋgu bĩŋkũŋgu hĩɛma-na bande‑i-na, ba ka siɛ-ku dɔrɔ‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Aa mi tũnu-nɛi: Na hɔlma-na, bamaŋ da ba nunu ba-naa hĩɛma-na bande‑i-na aa cãrã bĩŋkũŋgu mi To‑i dɔrɔ‑i-na u wulaa, u ka hã-ba baa ku bĩŋkũŋgu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Na saa da, nuɔmba hãi sisɔ nuɔmba siɛi da ba tigiiŋ ba-naa mɛi yerre-na, mi dii ba hɔlma-na.» ");
INSERT INTO cmeNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Yesuŋ waaŋ mafamma‑i, Piɛr wuɔ piɛ yuu-yo wuɔ: «Itie, moloŋ duɔ tuɔ cãl-mi aa mi ta mi yaŋ ma ta ma tĩ, da ku ji hi niel hade‑i mi saaya mi pɛ̃? Da ku ji hi niehãi wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesu wuɔ cira: «Mi siɛ cira niehãi yoŋ dɛ! Ŋga mi ka cira da ku hi komuɔŋa siɛi baa cĩncieluo a tir sɔmma niehãi.» ");
INSERT INTO cmeNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Aa naa cira: «Na saa da, *Diiloŋ-nellentesĩnni dii ŋaa nellentieŋo maŋ taaraayaŋ duɔ yuu u cɛ̃miɛŋa‑i u maacembiemba wulaa. ");
INSERT INTO cmeNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","U ce ba ta ba bĩ-ba ba hã-yo u tuɔ yuu-ba. Ku juɔ hi unaŋo‑i u cɛ̃mɛlle waa gbɛgɛ-diele. ");
INSERT INTO cmeNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","U saa naa waa duɔ gbãa pã-de. Nellentieŋo cira: ‹Da ma waa dumaaŋo-na, suoraaŋ-yoŋ baa u ciɛŋo‑i baa u bisãlmba‑i a naara u nagãŋ-niini‑i hiere na suu u cɛ̃mɛlle‑i.› ");
INSERT INTO cmeNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","«Naacolŋo kã ka dũuna nellentieŋo yaaŋga-na aa cira: ‹Jande, ne Diiloŋo‑i aa ŋ fɛ̃ ŋ huɔŋga‑i, mi ka gbãŋ kpelle suu-de.› ");
INSERT INTO cmeNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Uŋ piiye dumaaŋo-na, u hujarre ko nellentieŋo‑i, u cira u yaŋ u baa tiraa u pã bĩŋkũŋgu aa u sire u kã. ");
INSERT INTO cmeNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","«Maacembiloŋ daa u bi hilaa ku yaa nuɔ‑i a suu baa u nabentieŋo naŋo. Ba ce maacemma‑i baa ba-naa. U cɛ̃mɛlle waa u nabentieŋo faŋo-na. Di saa bi waa bɔi. U pãŋ nyɔŋ u nuhɔɛŋ-na aa cira: ‹Jo baa mi gbeiŋa‑i!› ");
INSERT INTO cmeNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","U nabentieŋo dũuna u yaaŋga-na aa cira: ‹Jande, ne Diiloŋo‑i aa ŋ fɛ̃ ŋ huɔŋga‑i mi ka gbãŋ kpelle suu-de.› ");
INSERT INTO cmeNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Naacolŋ wuɔ ma sa tĩ. Aa ce ba bel-o dii-yo kaso wuɔ duɔ saa suu cɛ̃mɛl daade‑i u sa da hel. ");
INSERT INTO cmeNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ku saa dɔlnu u nabaamba‑i. Baa kã ka tũnu nellentieŋo‑i baa-ma. ");
INSERT INTO cmeNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Nellentieŋ wuɔ ce ba bĩ u jo. Uŋ juɔ, nellentieŋ wuɔ cira: ‹Nelbabalaŋ nuɔ naŋ temma‑i daani‑i, ma sĩ naŋ cãarã-muɔ mɛi ce naŋ yaŋ mɛi gbeiŋa‑i kɛ? ");
INSERT INTO cmeNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ma miŋ ciɛ hujarre‑i nuɔ-na dumaa, naŋ saa waa ŋ ce hujarre‑i ŋ nabentieŋo-na dumɛi wɛi?› ");
INSERT INTO cmeNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","U huɔŋgaŋ guɔlaaya baa-yo cor dumaaŋo-na, wuɔ pãŋ saaŋ-yo u ka tuɔ ce pɔrtɔmma duɔ suu u cɛ̃mɛlle‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yesuŋ waaŋ mafamma‑i, wuɔ cira: «Namaa da na saa bi ta na ce hujarre na-naa nuɔ, mi To maŋ dɔrɔ‑i-na u bi ka ce-na dumɛi.» ");
INSERT INTO cmeNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesuŋ juɔ waŋ nel daama‑i tĩ baa nuɔmba‑i *Galile‑i-na, wuɔ ta kã *Yude ka waa dii *Yurdɛ̃ bomborma namma-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Nuɔŋ baa sire kũɔl ba-naa kã u wulaa baa ba jaamba‑i. Wuɔ sire-bɛi hã-ba. ");
INSERT INTO cmeNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","*Farisĩɛbaa-ba naŋ baa ta ba ne wuɔ sĩ ba ka gbãa piiye cure-yuɔ. Baa piɛ u caaŋ-nu a yuu-yo wuɔ: «A saa baa miɛ Diiloŋ-hũmelle‑i, da ku dɔl-niŋ ŋ gbãa nanna ŋ ciɛŋo‑i wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesu wuɔ cira: «Namaa saa kalaŋ mamaŋ nyɛgãaŋ Diiloŋ-nelma-na wɛi? Ma sĩ ma waaŋ Diiloŋ-nelma-na wuɔ Diiloŋ uŋ'a u jĩna miwaaŋo‑i ‹u maa biɛŋo baa ciɛŋo› ");
INSERT INTO cmeNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","aa cira: ‹A ce dumaaŋo-na bibiɛŋo ka yaŋ u bĩncuɔmba‑i aa waa baa u ciɛŋo ba gbonu ce kuuduɔŋgu.› ");
INSERT INTO cmeNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Da ba waa dumaaŋo-na, ba sa tiraa kãŋ-ba nuɔmba hãi, ba kãŋ-ba ŋaa nelduɔŋo. Terieŋgu faŋgu-na, Diiloŋ duɔ gbonu kumaŋ, nelbilo saa saaya u bɔrɔ-kuɔ.» ");
INSERT INTO cmeNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Farisĩɛbaa baa yuu-yo wuɔ: «Maŋ yeŋ dumaaŋo-na, bige‑i ciɛ *Moisi wuɔ umaŋ duɔ nanna u ciɛŋo‑i u nyɛgɛ̃ŋ sɛbɛ hã-yo a pigãaŋ wuɔ ba ãnsorre buɔra?» ");
INSERT INTO cmeNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesu wuɔ cira: «Diiloŋ uŋ taa u ma miwaaŋo‑i u saa naa dii mafamma‑i u huɔŋga-na, ŋga Moisi daa na tũnni sa nu, ku'i ciɛ u hã-na hũmelle‑i wuɔ na ta na nanna na caamba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ŋga mi tũnu-nɛi: Umaŋ ciɛŋo‑i duɔ u sa ce bɛmba fuɔ aa u nanna-yuɔ aa jã unaŋo, kutieŋo saa wuɔ Diiloŋ-hũmelle; u ciɛ *fuocesĩnni'i dumaaŋo-na.» ");
INSERT INTO cmeNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Uŋ waaŋ mafamma‑i, u *hãalãbiemba cira: «Da kuɔ maa dii dumɛi, ba'a ŋ biɛ ciɛŋo‑i tĩiŋgu wɛi? Ŋ sa yaŋ aa tĩɛ serŋ nuɔ bɔlbɔl wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesu wuɔ cira: «Diiloŋ duɔ hã bamaŋ ku fɔ̃ŋgũɔ‑i ba'i gbãa hũu nel daama‑i, da ma'i sĩ nuɔmba‑i hiere ba maahũuma sĩ. ");
INSERT INTO cmeNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Na saa da, banamba huɔŋ baa ba sersĩnni‑i, banamba nelbiliemba'i diyaa-ba niɛ, banamba Diiloŋ-maama'i diyaa-ba niɛ. Umaŋ duɔ u ka gbãa hũu-ma u hũu-ma.» ");
INSERT INTO cmeNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ku huoŋgu-na, baa jo baa bisãmbiemba namba‑i Yesu wulaa wuɔ ji haa u nammu‑i bɛi aa cãrã Diiloŋo‑i hã-ba. *Hãalãbieŋ baa sire ta ba nuola bamaŋ juɔ baa-ba. ");
INSERT INTO cmeNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yesu wuɔ cira: «Yaaŋ bisãlmba ta ba jo mi wulaa, baa na ta na cie-ba. Na saa da, bamaŋ dii bafamba temma‑i, *Diiloŋ-nelle dii bafamba diele.» ");
INSERT INTO cmeNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Aa naa haa u nammu‑i bɛi aa cãrã Diiloŋo‑i hã-ba. Uŋ ciɛ mafamma‑i, wuɔ ta halaŋ terieŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Baŋ taa dumaaŋo-na, naacolŋo naŋ wuɔ piɛ tuɔ yuu Yesu‑i wuɔ: «Hãalãtie, mi saaya mi ce ãnfafaŋ hama‑i da mi gbãa da cicɛ̃lma maŋ sa tĩɛŋ dede‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesu wuɔ cira: «Bige‑i ciɛ ŋ ta ŋ yuu-mi baa ãnfafammaŋ-maama? Nelduɔŋo diei dii umaŋ faa; u yaa Diiloŋo‑i. Da ŋ ta ŋ taara ŋ da cicɛ̃lma maŋ sa tĩɛŋ dede‑i, ŋ saaya ŋ ta ŋ wuɔ uŋ'a i tiɛ wuɔ hũmieŋa maŋ.» ");
INSERT INTO cmeNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Naacolŋ wuɔ cira: «A yaa haya‑i?» Yesu wuɔ cira: «‹Baa ko nɛliɛŋo, baa ce *fuocesĩnni, baa cuo, baa kar coima ŋ haa molo-na, ");
INSERT INTO cmeNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ta ŋ dii ŋ to‑i baa ŋ nyu‑i ba nuŋgu‑i, ta ŋ dɔl ŋ nanolŋo‑i ŋaa niŋ dɔl ŋ fɛrɛ dumaa.›» ");
INSERT INTO cmeNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Naacolŋ wuɔ cira: «Mafamma‑i daama‑i hiere mi ciɛ-ma. Mi saaya mi tiraa ce hama‑i naara?» ");
INSERT INTO cmeNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesu wuɔ cira: «Da ŋ ta ŋ taara ŋ gbuo-ma ma tuole-na hiere, kã ŋ ka suor ŋ nagãŋ-niini‑i hiere aa ŋ cal gbeiŋa faŋa‑i ŋ hã sũntaamba baa-ya, ku yaa ŋ ka ce wɛiŋ nuɔ dɔrɔ‑i-na; aa ŋ jo ŋ ji ta ŋ nyaanu-miɛ.» ");
INSERT INTO cmeNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Naacolŋ daayo naa silaa waa wɛiŋo cor. Yesuŋ juɔ waŋ mafamma‑i, wuɔ pãŋ vãa u yaaŋga‑i aa naa ta. ");
INSERT INTO cmeNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yesu wuɔ tuɔ piiye baa u *hãalãbiemba‑i wuɔ: «Yaaŋ mi waŋ ninsoŋo‑i baa-na: Kumaŋ ka ce wɛiŋo duɔ gbãa suur *Diiloŋ-nelle-na kuu dii kpelle. ");
INSERT INTO cmeNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Na suyaa wuɔ kumaŋ ka ce nyɔgɔ̃mɛ duɔ gbãa cor misɛ̃nɛ-fuoŋgu-na kuu dii kpelle dɛ! Ŋga mi tũnu-nɛi: Kumaŋ ka ce wɛiŋo duɔ gbãa suur Diiloŋ-nelle-na, kufaŋgu dii kpelle yaŋ.» ");
INSERT INTO cmeNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Uŋ waaŋ mafamma‑i, u hãalãbiemba hɔŋ muɔ gbuu cu da kullu! Baa ta ba piiye wuɔ: «Dumaaŋo-na, hai moloŋo‑i ka gbãa suur Diiloŋ-nelle‑na?» ");
INSERT INTO cmeNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesu wuɔ ne-ba aa naa cira: «Nelbiliemba wulaa ma siɛ gbãa ce, ŋga wɛima sa yar Diiloŋo‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Terieŋgu faŋgu-na, Piɛr wuɔ cira: «Itie, ne, miɛ maŋ yaaŋ i wɛima‑i hiere aa tiɛ nyaanu-niɛ i ka da bige‑i kuɔ?» ");
INSERT INTO cmeNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu wuɔ cira: «Yaaŋ mi waŋ ninsoŋo‑i baa-na: Bĩmbĩŋ da ni ji bir hiere niifɛlɛnni, *Moloŋ-Biɛŋo ka tĩɛna u fɔ̃ŋgɔ̃tesĩnni-na aa namaa namaŋ nyaanuŋ-miɛ cĩncieluo baa na hãi, na ka bi tĩɛna fɔ̃ŋgɔ̃tesĩnni-na ta na fiɛlnu *Isirahɛl dũnni cĩncieluo ni hãi niini yuŋ-maama‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Aa umaŋ duɔ ta aa yaŋ u dumɛlle‑i, u hãmba‑i, u mɔlbaa-ba‑i, u tũɔbaa-ba‑i, u to‑i, u nyu‑i, u bisãlmba‑i, u sonni‑i mɛi maama-na, uŋ taa aa yaŋ nimaŋ, u ka da ni temma sɔmma komuɔŋa ndii. Aa u ka tiraa da cicɛ̃lma maŋ sa tĩɛŋ dede‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Na saa da, bamaŋ taa yaaŋga fiɛfiɛ‑i-na, ba bɔi ka bir waa huoŋ-nu, aa bamaŋ dii huoŋgu-na fiɛfiɛ‑i-na, ba bɔi ka ta yaaŋga.» ");
INSERT INTO cmeNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ku huoŋgu-na, Yesu wuɔ cira: «*Diiloŋ-bãaŋgu dii ŋaa suontieŋo maŋ siire naar taara maacenciraamba ba da ba ka guona u suoŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Uŋ daa maacenciraamba‑i ba waŋ ma saa wuɔ u pã-ba *deniebaa-ba da-ba-diei bãduɔŋgu-na aa ce ba kã suoŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","«Bãaŋguŋ juɔ boŋ, u kã nelleŋ-huɔŋga-na ka tiraa da banamba wuɔra ba bĩŋ ba sa ce bĩŋkũŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","U gbɛ̃-ba wuɔ: ‹Kãaŋ mi suoŋgu-na, mi ka pã-na, mi siɛ du-na.› ");
INSERT INTO cmeNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Bafaŋ baa bi ta kã. «Bãaŋguŋ juɔ huol, u tiraa hel da banamba‑i, u tiraa ce bafamba kã. Bãtaruŋgu-na, maaduɔma. ");
INSERT INTO cmeNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","U juɔ tiraa hel bãaŋ-yufelleŋ kãŋ suurma huɔŋgu-na, a tiraa da banamba‑i, u yuu-ba wuɔ: ‹Bige‑i ciɛ na tĩɛna naŋ bãaŋgu‑i na saa ce bĩŋkũŋgu?› ");
INSERT INTO cmeNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","«Baa cira: ‹I saa da maacemma ku'i ciɛ.› «Suontieŋ wuɔ gbɛ̃-ba wuɔ: ‹Da ma waa dumaaŋo-na, kãaŋ mɛi suoŋgu-na.› ");
INSERT INTO cmeNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","«Bãaŋguŋ juɔ tĩ huɔŋgu-na, suontieŋ wuɔ waŋ baa u suoŋ-tayaana‑i wuɔ: ‹Bĩ maacenciraamba‑i ŋ pã-ba. Ŋ doŋ baa bamaŋ juɔ huoŋgu'i nuɔ‑i ŋ ka bãl baa dĩɛlã-baamba‑i.› ");
INSERT INTO cmeNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Bamaŋ juɔ bãaŋguŋ kãŋ suurma‑i huɔŋgu-na, ba bĩ bafamba jo, ji hã-ba deniebaa-ba da-ba-diei ba yunniŋ. ");
INSERT INTO cmeNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Kuŋ juɔ hi dĩɛlã-baamba‑i, bafamba da niɛ sĩ ba ka da maar bamaŋ juɔ huoŋgu-na; ba hã-ba kuuduɔŋgu yaa baa-ba; deniebaa-ba da-ba-diei. ");
INSERT INTO cmeNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Baa sire ta ba waana baa suontieŋo‑i ");
INSERT INTO cmeNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","wuɔ: ‹Bamaŋ juɔ huoŋgu-na ba saa da ce bĩŋkũŋgu aa bãaŋgu tĩ aa ŋ bel diiloŋo‑i pã-ba kuuduɔŋgu baa miɛ maŋ juɔ dii cucuuyuŋ-nu, bãaŋgu ye-ye naŋ bãaŋgu!› ");
INSERT INTO cmeNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","«Suontieŋ wuɔ gbɛ̃ unaŋo‑i wuɔ: ‹Mi jĩɛ, mi saa du-ni. Ma sĩ i naa saa-ma wuɔ dãnambãaŋgu-na mi pã-ni denie u diei kɛ? ");
INSERT INTO cmeNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ŋ gbeiŋa'i si a nuŋgu-na wɛi? Biɛ-ya ŋ kã. Muɔmɛi ciɛra mi ka hã umaŋ juɔ huoŋgu-na kuuduɔŋgu baa umaŋ juɔ yaaŋga‑i, naŋ nuŋgu dii-kuɔ wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Mɛi gbeiŋa‑i, mi baa ce kumaŋ dɔlaanu-miɛ baa-ya wɛi? Sisɔ miŋ ciɛ ãnfafamma‑i ma'i jaa-ni?›» ");
INSERT INTO cmeNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yesuŋ waaŋ mafamma‑i wuɔ cira: «Na saa da, bamaŋ dii huoŋgu-na, ba ka ta yaaŋga, aa bamaŋ dii yaaŋga-na, ba bir tĩɛ huoŋ-nu.» ");
INSERT INTO cmeNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesuŋ juɔ biɛ hũmelle‑i tuɔ kã *Yerusalɛmu‑i-na, wuɔ bĩ u *hãalãbieŋ cĩncieluo ba hãi baamba‑i ba deŋ a waŋ baa-ba wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Na daa iŋ kãŋ Yerusalɛmu‑i-na kɛ. Diɛ kã, ba ka bel *Moloŋ-Biɛŋo‑i a hã *Diilojigãntaamba yuntaamba‑i baa *ãnjĩnamma pigãataamba‑i baa-yo. Da ba hã-ba baa-yo, bafamba ka cira u saaya komma ");
INSERT INTO cmeNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","aa bel-o hã *niɛraamba‑i baa-yo ba nyɛ-yo sũlma aa muo-yo aa gbu-yo *daaŋ-nu ko-yo. Ŋga da ba ko-yo, u ka ce yinni hãi yoŋ hĩɛma-na aa siɛliŋ-yiiŋgu‑i u ka sire hel jo.» ");
INSERT INTO cmeNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ku huoŋgu-na, Sebede ciɛŋ wuɔ piɛ Yesu caaŋ-nu baa u bɛpuɔmba‑i ba hãi‑i-na ka dũuna duɔ cãrã. ");
INSERT INTO cmeNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesu wuɔ yuu-yo wuɔ: «Ŋ taara bige‑i?» Wuɔ cira: «Mi taara da ŋ ji da ŋ nellentesĩnni‑i, ŋ yaŋ mi bɛpuɔŋ daaba‑i ba hãi‑i-na unaŋo tĩɛna ŋ nadieŋga-na unaŋo‑i ŋ nanyuɔŋgu-na.» ");
INSERT INTO cmeNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesu wuɔ cira: «Na saa suɔ naŋ cãrãŋ kumaŋ dɛ! Yaahuolo maŋ ka haa-miɛ, namaa ka siɛ u temma haa-nɛi wɛi?» Bisãlŋ daa baa cira: «Ũu, i ka siɛ u haa-yiɛ.» ");
INSERT INTO cmeNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesu wuɔ cira: «Yaahuolo maŋ ka haa-miɛ, u ka haa-nɛi ninsoŋo, ŋga mɛi siɛ gbãa pã nuŋgu wuɔ mɛlŋo'i ka tĩɛna mi nadieŋga-na aa mɛlŋo'i ka tĩɛna mi nanyuɔŋgu-na. Mi To uŋ tigiiŋ muntĩɛnammu fammu‑i tuɔ cie bamaŋ, ba yaa ka da-mu.» ");
INSERT INTO cmeNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","U *hãalãbieŋ cĩnciel-baamba nambaŋ juɔ nu nel daama‑i, ba hɔŋ muɔ pãŋ guɔla baa ba hãi-baaŋ daaba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yesu wuɔ bĩ-ba hiere a ji tuɔ piiye baa-ba wuɔ: «Na suyaa wuɔ fãamaambaa-ba ce hãlmaaŋgu baa ba fãamaansĩnni‑i aa nelbɔ̃mbɔ̃mbaa-ba ta ba haa fɔ̃ŋgũɔ‑i nuɔmba-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ŋga ku saa saaya ku waa dumaaŋo-na namaa na wulaa. Umaŋ duɔ tuɔ taara u ce nelbuɔ‑i na hɔlma-na, kutieŋo saaya u ce u fɛrɛ na maacembiloŋo, ");
INSERT INTO cmeNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","aa umaŋ duɔ tuɔ taara yaaŋga‑i, u saaya u ce u fɛrɛ na kɔriɛŋo. ");
INSERT INTO cmeNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Na saa da, *Moloŋ-Biɛŋo juɔ jomma famma yaa‑i hĩɛma-na duɔ ji cãa nuɔmba‑i, aa pã u fɛrɛ duɔ sãa nuɔmba bɔi yunni, u saa jo ba da ba ji cãa-yo.» ");
INSERT INTO cmeNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Baŋ siire Yeriko‑i-na, nelpũŋgu naŋ temma cu Yesu huoŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Yiriemba namba waa tĩɛna hũmelle tũŋgu-na, baa tũnu-bɛi wuɔ Yesu yaa curaaŋ. Ba waa ba hãi. Baa pãŋ doŋ ta ba piiye da gbagaga wuɔ: «Itie, *Davidi hãayɛ̃lŋ nuɔ, jande ce hujarre yiɛ!» ");
INSERT INTO cmeNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Nuɔŋ baa ta ba nuola-bɛi wuɔ ba budii. Baa migãaŋ ta ba kaasĩŋ ba naara wuɔ: «Itie, Davidi hãayɛ̃lŋ nuɔ, jande ce hujarre yiɛ!» ");
INSERT INTO cmeNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesu wuɔ yiɛra aa naa yuu-ba wuɔ: «Na taara mi ce bige‑i hã-na?» ");
INSERT INTO cmeNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Baa cira: «Itie, i taara ŋ puur i yufieŋa‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Baŋ piiye dumaaŋo-na, ba hujarre ko Yesu‑i, wuɔ wuɔra yiɛya ba yufieŋa‑i. Terduɔŋgu faŋgu-na, aa pãŋ puur. Aŋ puurii dumaaŋo-na, baa cu u huoŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesubaa-baŋ kaa piɛ *Yerusalɛmu‑i, a saanu baa Betifage‑i, dii *Olivi-tibinni-tãnuŋgu hɔlma-na, Yesu wuɔ waŋ baa u *hãalãbiemba hãi wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","«Kãaŋ nelle maŋ i yaaŋga-na daade‑i, na ka da ba vaa kakũnciɛŋo naŋo baa u biloŋo. Na fir-ba na jo baa-ba. ");
INSERT INTO cmeNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Umaŋ duɔ yuu-na, na cira: ‹Itieŋo'i puɔraa-ye.› Da na waŋ mafamma‑i, ba ka yaŋ na ta baa-ba.» ");
INSERT INTO cmeNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","*Diilopɔpuɔrbiloŋ uŋ waaŋ mamaŋ ma'i sa ciɛŋ daama‑i wɛi? Diilopɔpuɔrbiloŋo waaŋ-ma wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«Waaŋ baa *Sinyɔtaamba‑i wuɔ: Niɛŋ, na nellentieŋo'i juɔŋ daayo na wulaa, uu dii hɔhĩnantieŋo. U nyugãaŋ tĩɛna kakũnyuŋ-na, baa kakũmbiloŋ-na.» ");
INSERT INTO cmeNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Hãalãbieŋ baa kã ku yaa nuɔ‑i, ka bi da-ma ŋaa Yesuŋ waaŋ-ma dumaa. ");
INSERT INTO cmeNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Baa jo baa kakũmuɔ‑i baa u biloŋo‑i. Baŋ juɔ baa-ba, baa hiel ba joŋgorbaa-ba‑i haa ba honni-na aa Yesu wuɔ nyugũŋ tĩɛna. ");
INSERT INTO cmeNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Nuɔmba maŋ waa hiere, baa bi hiel ba baamba‑i ta ba fara-bɛi hũmelle-na Yesu tuɔ wuɔ ba dɔrɔ. Banaŋ baa kar fiɛlu ta ba jĩna. ");
INSERT INTO cmeNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Bamaŋ naa waa u yaaŋga-na baa u huoŋgu-na hiere, baa ta ba piiye da gbagaga wuɔ: «*Davidi hãayɛ̃lŋo temma si dii! Itieŋ uŋ saaŋ umaŋ u jo, Diilo baa-yo! Dɔrwuoŋo temma si dii!» ");
INSERT INTO cmeNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesuŋ kãa ka suur Yerusalɛmu‑i-na, nelle‑i hiere diɛ sire yiɛra di gbeiniŋ. Da ba cor kusuɔŋ-nu, nuɔmba ta ba yuu wuɔ: «Hai moloŋo‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Baa ta ba siɛ-ba wuɔ: «Yesu maŋ Diilopɔpuɔrbiloŋo yaa‑i. U hilaa Nasarɛti, dii *Galile.» ");
INSERT INTO cmeNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesuŋ kãa *Yerusalɛmu‑i-na, wuɔ kã ka suur *Diilodubuɔ‑i-na a donya niisuornintaamba‑i baa niisãanintaamba‑i hiere hiel-ba. Aa naa kã ka tisĩŋ gbeihortaamba taabalebaa-ba‑i nanna, aa sɛ bamaŋ suoraaŋ nɔnsɔr ba huriimba‑i ba titiɛŋa‑i nanna. ");
INSERT INTO cmeNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Uŋ ciɛ mafamma‑i, wuɔ cira: «Ma nyɛgãaŋ Diiloŋ-nelma-na wuɔ: ‹Ba ka ta ba bĩ mi dũŋgu‑i Diilojaaldũŋgu›, ma sĩnni niɛ namaa ce-ku cuo ba terieŋgu?» ");
INSERT INTO cmeNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Yesuŋ suurii Diilodubuɔ‑i-na, yiriemba namba‑i baa cisɛduɔlbaa-ba namba kã u wulaa u ka sire-bɛi. ");
INSERT INTO cmeNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","*Diilojigãntaamba yuntaamba‑i baa *ãnjĩnamma pigãataambaŋ daa uŋ ceŋ gbɛrɛ-wɛima‑i, aa bisãlmba maŋ waa baa-yo ba ta ba piiye gbagaga Diilodubuɔ‑i-na, ku saa dɔlnu-bɛi. Bisãlŋ daaba taa ba piiye wuɔ: «*Davidi hãayɛ̃lŋo temma si dii.» ");
INSERT INTO cmeNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Diilojigãntaamba yuntaamba‑i baa ãnjĩnamma pigãataaŋ baa ta ba piiye baa Yesu‑i wuɔ: «Ŋ nuɔ bisãlmbaŋ waŋ mamaŋ wɛi?» Yesu wuɔ cira: «Mi nuɔ.» Aa naa cira: «Diiloŋ-nelmaŋ piiye terieŋgu maŋ nuɔ‑i wuɔ: ‹Ŋ ciɛ halle bisãlmba‑i baa tontobaa-ba tuɔlnu nuɔnɛi› namaa saa kalaŋ terieŋgu faŋgu‑i dede wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Uŋ waaŋ mafamma‑i, wuɔ ta kã Betani aa naa yaŋ-ba. U kaa cɔ kusuɔŋ-nu'i. ");
INSERT INTO cmeNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ku cuo kaala‑i-na, Yesu wuɔ sire cucuuyuŋgu-na tuɔ jo nelleŋ-huɔŋga-na, a ne da nyulmu waa-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","U juɔ hi hɔlma namma‑i a da *yensãaŋgu naŋgu‑i hũmelle tũŋgu-na. Wuɔ piɛ kã ka da fiɛgbãŋgbãŋlãndu. Wuɔ gbɛ̃ yensãaŋgu‑i wuɔ: «Ma bãlãa nyuŋgo, naŋ cɛraa ŋ ji maŋ bieŋa!» Terduɔŋgu faŋgu-na, yensãaŋgu pãŋ kuol. ");
INSERT INTO cmeNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Kuɔ cu u *hãalãbiemba hɔmmu‑i. Baa ta ba yuu-yo wuɔ: «Itie, ku ciɛ ceŋ hama‑i aa yensãaŋ daaku kuol hɔdɔmma dumandɛ‑i-na?» ");
INSERT INTO cmeNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesu wuɔ cira: «Yaaŋ mi waŋ ninsoŋo‑i baa-na: Da na saa ce na hɔmmu‑i mu hãi, aa haa na naŋga‑i miɛ, miŋ ciɛ kumaŋ daaku‑i na gbãa ce ku temma. Halle na gbãa gbɛ̃ tãnuŋ daaku‑i wuɔ: ‹Juur ŋ halaŋ bande‑i-na ŋ ka suur nuoraaŋgu-na›, ŋ da ma bi ciɛ. ");
INSERT INTO cmeNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Da na cãrã bĩŋkũŋgu bĩŋkũŋgu Diiloŋo wulaa, aa haa na naŋga‑i yuɔ, na ka da ku bĩŋkũŋgu‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesuŋ juɔ ji hi, wuɔ suur *Diilodubuɔ‑i-na doŋ tuɔ waŋ Diiloŋ-nelma‑i baa nuɔmba‑i. *Diilojigãntaamba yuntaamba‑i baa nelle bĩncuɔŋ baa piɛ yuu-yo wuɔ: «Niŋ ceŋ kumaŋ daaku‑i, hai moloŋo‑i hãa-ni hũmelle‑i ŋ ta ŋ ce-ku?» ");
INSERT INTO cmeNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesu wuɔ cira: «Muɔmi ka bi yuu-na baa nelma diei. Da na siɛ-mi, mi ka pigãaŋ-na umaŋ hãa-mi hũmelle‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Hai moloŋo‑i puɔraa Nsãa jo ji tuɔ *batiseŋ nuɔmba‑i? Diiloŋo'i puɔraa-yo waa nelbiliemba'i puɔraa-yo?» Baa doŋ ta ba piiye ba-naa nuɔ wuɔ: «Diɛ cira Diiloŋo'i puɔraa-yo, u ka cira: ‹Naŋ suyaa-ma dumaaŋo-na bige‑i ciɛ na saa hũu u nelma‑i?› ");
INSERT INTO cmeNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Diɛ bi hɔr-ma cira: ‹Nelbiliemba'i puɔraa-yo›, bamaŋ dii bande‑i-na hiere ba suyaa wuɔ Nsãa waa *Diilopɔpuɔrbiloŋo, ba siɛ yaŋ-ye.» ");
INSERT INTO cmeNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Baa naa baa cira: «I saa suɔ umaŋ puɔraa-yo.» Yesu wuɔ cira: «Muɔmi siɛ bi pigãaŋ-na umaŋ hãa-mi hũmelle‑i mi ta mi ce kumaŋ daaku‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ku huoŋgu-na Yesu wuɔ cira: «Niɛŋ, naacolŋo naŋo waa baa bɛpuɔmba hãi. Yiiŋgu naŋgu-na, wuɔ ji gbɛ̃ mɔlŋo‑i wuɔ: ‹Sire ŋ kã suoŋgu-na.› ");
INSERT INTO cmeNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","«Naacombiloŋ wuɔ: ‹Mi siɛ kã.› Aa ji jɔguɔŋ aa ta kã. ");
INSERT INTO cmeNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","«Tuoŋ wuɔ kã ka ce maaduɔma baa hãaŋo‑i. Hãaŋ wuɔ: ‹Baba, wɛima sĩ, mi ka kã›. Aa u saa ji kã.» ");
INSERT INTO cmeNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Yesu wuɔ yuu-ba wuɔ: «Ba hãi‑i-na, hai moloŋo‑i nuɔ tuoŋo nuŋgu‑i?» Baa cira: «Dĩɛlã-wuoŋo yaa‑i.» Yesu wuɔ cira: «Mi waŋ ninsoŋo‑i baa-na: *Nampohũutaamba‑i baa saasorbaa-ba ka suur yaaŋga nɛi *Diiloŋ-nelle-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Na saa da, Nsãa juɔ ji pigãaŋ-na hũmeviile‑i na yagar na saa hũu u nelma‑i, ŋga nampohũutaamba‑i baa saasorbaa-ba hũyãa-ma. Mafammaŋ fiɛ ce na da-ma, ku saa jaŋ-na na nanna na cilɔbabalaŋo‑i aa hũu Nsãa nelma‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ku huoŋgu-na, Yesu wuɔ cira: «Yaaŋ mi tiraa naŋ gbãnalãaŋgu naŋgu baa-na: Naacolŋo naŋo diyaa *ɛrɛsɛ̃-suoŋgu aa kalla-kuɔ. Uŋ kalaaya-kuɔ, u hĩŋ fuoŋgu ba da ba ta ba kãmal ɛrɛsɛ̃‑i aa ce felge ba ta ba nyugũŋ ba niya suoŋgu‑i. Uŋ ciɛ mafamma‑i, u biɛ maacenciraamba jĩna-kuɔ aa ta kã nelle. ");
INSERT INTO cmeNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","«Ɛrɛsɛ̃ŋ juɔ hi karma, u puɔr u maacembiemba siɛi maacenciraamba wulaa wuɔ ba ji hũu fuɔ yufelle‑i ka hã-yo. ");
INSERT INTO cmeNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Maacembiembaŋ juɔ, maacenciraamba bel diiloŋo‑i a muo unaŋo‑i aa ko ba hãi-baamba‑i. Ba naaŋ unaŋo‑i baa tãmpɛ̃lɛ̃iŋa'i ko-yo. ");
INSERT INTO cmeNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Suontieŋo tiraa puɔr maacembiemba namba. Bafamba maaraa dĩɛlã-baamba‑i. Baŋ juɔ, maacenciraamba tiraa ce-ba ŋaa baŋ ciɛ dĩɛlã-baamba‑i dumaa. ");
INSERT INTO cmeNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Suontieŋo naa u puɔr u biɛŋo yaa wuɔ u jo u fɛrɛ ba wulaa. U taa u ne wuɔ sĩ bɛpolŋ duɔ jo, ba ka kãŋ-yo. ");
INSERT INTO cmeNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","«Baŋ juɔ'a ba ne da bɛpolŋo‑i, ba piiye baa ba-naa wuɔ: ‹Ciiluwuotieŋo yaa juɔŋ daayo! Yaaŋ i ko-yo aa ciiluŋgu ce miɛ kũŋgu!› ");
INSERT INTO cmeNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ba siire ku yaa nuɔ‑i a bel naacombiloŋo‑i hel baa-yo suoŋgu-na ka ko-yo.» ");
INSERT INTO cmeNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yesu wuɔ cira: «Namaa wulaa, suontieŋ duɔ jo, u ka ce maacenciraaŋ daaba‑i niɛ?» ");
INSERT INTO cmeNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Baa cira: «Kartaaŋ daaba‑i! Duɔ jo, u ka ko-ba hiere aa hã banamba baa suoŋgu‑i. Bafamba ka ta ba hã-yo u yufelle‑i ku huɔŋ-nu.» ");
INSERT INTO cmeNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesu wuɔ cira: «Na saa kalaŋ nel daama‑i Diiloŋ-nelma-na wɛi? Ma nyɛgãaŋ wuɔ: ‹Dũmarãambaŋ cĩinaana kpãŋkpara maŋ, u yaa juɔ bella dũŋgu‑i. Itieŋo yaa wuɔ ma ce dumaaŋo-na. Miɛ fuɔ ku ciɛ nerma i wulaa.› ");
INSERT INTO cmeNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","«Ku'i ciɛ mi ta mi tũnu-nɛi miɛ: Ba ka hũu *Diiloŋ-nelle‑i na wulaa a hã *niɛraamba maŋ nuɔŋ Diiloŋo nuŋgu‑i baa-de.  ");
INSERT INTO cmeNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ŋga miŋ waaŋ kpãŋkpara maŋ maama‑i, umaŋ duɔ par diire naŋ u fɛrɛ yuɔ, u ka kara u fɛrɛ; duɔ bi par naŋ umaŋ, u ka putĩɛnu kutieŋo‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Yesuŋ naaŋ gbãnɛini maŋ daani‑i, *Diilojigãntaamba yuntaamba‑i baa *Farisĩɛbaa baa pãŋ suɔ wuɔ u gbɛ̃ ba yaa‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Baa ta ba taara ba bel-o. Ŋga nuɔmba naa suɔ wuɔ *Diilopɔpuɔrbiloŋo, a ce dumaaŋo-na Diilojigãntaamba yuntaamba‑i baa Farisĩɛbaa-ba taa ba kãalã-bɛi. ");
INSERT INTO cmeNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu wuɔ cor baa u gbãnɛini‑i wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«*Diiloŋ-nellentesĩnni dii ŋaa nellentieŋo maŋ jãaŋ ciɛŋo duɔ hã u biɛŋo aa bĩ nuɔmba bɔi. ");
INSERT INTO cmeNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Niiwuoniŋ-huɔŋguŋ juɔ hi, u puɔr u maacembiemba‑i wuɔ ba ka waŋ baa nuɔmba jo. Maacembiemba kã, nuɔmba ka yagar wuɔ ba siɛ jo. ");
INSERT INTO cmeNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Nellentieŋo tiraa puɔr u maacembiemba namba ba wulaa wuɔ: ‹Kãaŋ na ka waŋ baa-ba wuɔ mɛi ciɛra mi hĩyãa bɔi aa ko mi balyunni‑i baa fombayaamba‑i, kɛrɛ ba jo, niiwuoni biɛ tĩ.› ");
INSERT INTO cmeNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Pɔpuɔrbiembaŋ kãa, nuɔmba saa gbuu suɔ dii wuɔ ba waŋ wɛima, ba bɔrɔ hiere kã ba muŋkãmmu: Banamba kã sonniŋ, banamba kã torguoŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Banamba bir yaŋ aa bel nellentieŋo maacembiemba‑i muo-ba da dɛi aa ko-ba. ");
INSERT INTO cmeNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Nellentieŋo huɔŋ kaa pãŋ guɔla. Wuɔ ce u sorosibaa-ba kã ka ko kutaamba‑i aa caa ba nelle‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","«Uŋ ciɛ mafamma‑i, wuɔ waŋ baa u maacembiemba‑i wuɔ: ‹Niiwuoni biɛ tĩ, ŋga miŋ ŋa naa bĩ bamaŋ, ni saa naa waa bafamba niini. ");
INSERT INTO cmeNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Kãaŋ hũŋgbɛsɛnni-na, da na ka da nɛliɛŋo nɛliɛŋo, na ce u jo.› ");
INSERT INTO cmeNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Maacembiemba taa ku yaa nuɔ‑i kã hũŋgbɛsɛnni-na ka bĩ nelbabalaamba‑i baa nelfafaamba‑i hiere ji dii nellentieŋo dũŋgu yu. ");
INSERT INTO cmeNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Nellentieŋo suur wuɔ u ka ne-ba, kã ka da naacolŋo naŋo diyaa joŋgorgbãŋgbãlãŋo tĩɛna, a ne da ba hãa-ba joŋgorbaa ma yerreŋ. ");
INSERT INTO cmeNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Wuɔ yuu-yo wuɔ: ‹Mi jĩɛ, naŋ ciɛ niɛ suur bande‑i baa joŋgorgbãŋgbãlãŋo‑i?› Naacolŋo saa da wɛima waŋ. ");
INSERT INTO cmeNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Nellentieŋ wuɔ waŋ baa u maacembiemba‑i wuɔ: ‹Bilaaŋ naacolŋ daayo‑i na vaa u nammu‑i baa u gbeini‑i aa na tɛtɛŋ-yo na nanna-yuɔ fuoreŋ dii kukulma-na. Duɔ tĩɛ dii terieŋgu-na, kaaluŋgu siɛ gbuu waa dɛi.›» ");
INSERT INTO cmeNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yesu wuɔ cira: «Na saa da, ba bĩɛ nuɔmba bɔi, ŋga baŋ fiɛlaa bamaŋ ba saa ciinu.» ");
INSERT INTO cmeNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Yesuŋ piiye dumaaŋo-na, *Farisĩɛbaa baa kã ka da ba-naa baŋ ka ce dumaa cure-yuɔ bel-o fuɔ fɛrɛŋ nuŋ-ãndaaŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Baŋ juɔ nunu ba-naa tĩ, baa puɔr ba *hãalãbiemba‑i u wulaa baa *Erɔdi baamba namba. Baa kã ka gbɛ̃-yo wuɔ: «Hãalãtie, i suyaa wuɔ ŋ waŋ ninsoŋo yaa‑i; ŋ gbu ŋ pigãaŋ nuɔmba‑i baa Diiloŋ-hũmelle yaa kelkel, ŋ sa kãalã nɛliɛŋo baa ŋ ninsoŋo‑i, ŋ sa bi ce ciɛluɔ.» ");
INSERT INTO cmeNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Aa naa yuu-yo wuɔ: «A saa baa miɛ hũmelle‑i, ku saaya i tiɛ pã nampo‑i i hã *Oromɛ ba *jãmatigi‑i wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yesu wuɔ suɔ ba kusũŋ-maama‑i; wuɔ cira: «Huhurmantaaŋ namaa temma‑i daana‑i, na taara na cure muɔmɛi wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Naŋ pãŋ nampo‑i baa warbieŋa maŋ, hãa-miŋ di diei mi ne.» Baa hã-yo warbelle nande. ");
INSERT INTO cmeNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","21","Wuɔ hũu-de ne aa naa yuu-ba wuɔ: «Ba ciɛ hai yuŋgu‑i warbel daade-na?» Baa cira: «Ba ciɛ Oromɛ ba jãmatigi yuŋgu.» Wuɔ yuu-ba wuɔ: «Ba nyɛgãaŋ hai yerre‑i diɛ?» Baa cira: «Ba nyɛgãaŋ Oromɛ ba jãmatigi yerre.» Yesu wuɔ gbɛ̃-ba wuɔ: «Kumaŋ da ku waa jãmatigi kũŋgu‑i, pãaŋ-kuŋ na hã jãmatigi‑i baa-ku, aa kumaŋ da ku bi waa Diiloŋ-kũŋgu‑i na bi pã-ku na hã Diiloŋo‑i baa-ku.» ");
INSERT INTO cmeNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Nel daama cu ba hɔmmu‑i, baa naa baa ta aa naa yaŋ-yo. ");
INSERT INTO cmeNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","*Sadusĩɛbaa-ba wulaa kuomba siɛ sire. Yinduɔŋgu faŋgu-na, banamba piɛ Yesu‑i a yuu-yo wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«Hãalãtie, *Moisi ciɛra wuɔ umaŋ duɔ saa da biloŋo baa u ciɛŋo‑i aa ku, u hãaŋo saaya u biɛ ciɛŋo‑i a hoŋ biloŋo hã kuloŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","A ne da i hɔlma-na, naacombiemba namba waa niehãi ba nyu wulaa. Mɔlŋo sire jã ciɛŋo, u saa da biloŋo baa-yo aa ku. Umaŋ cuu-yo u biɛ ciɛŋo‑i ");
INSERT INTO cmeNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","u saa da biloŋo baa-yo. Siɛliŋ-wuoŋo‑i maaduɔma. Ba ciɛ dumɛi ka ku gbuo hiere niehãi‑i-na molo saa ji da biloŋo baa ciɛŋ daayo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ku huoŋgu-na, ciɛ fuɔ fɛrɛ u suɔ tuɔ nyaanu-bɛi. ");
INSERT INTO cmeNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ba hieroŋo-na, baŋ diyaa-yo ba ciɛŋo cor, kuoŋ da ba ji sire yiiŋgu maŋ nuɔ‑i, u ka ce hai wuoŋo‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesu wuɔ cira: «Na piɛra! Na saa suɔ Diiloŋ-nelma‑i, aa na saa bi suɔ u himma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Na saa da, kuoŋ da ba ji sire, cadiile siɛ ji waa, ba ka waa ŋaa *dɔrpɔpuɔrbiemba.» ");
INSERT INTO cmeNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Aa naa cira: «Kumaŋ ŋaa kuomba siremmaŋ-kũŋgu‑i, na saa kalaŋ Diiloŋ-nelma‑i wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","U ciɛra wuɔ: ‹*Abiramu Diiloŋo yaa muɔŋo‑i, *Isaki Diiloŋo yaa muɔŋo‑i, *Yakɔbu Diiloŋo yaa muɔŋo‑i.› Ku pigãaŋ wuɔ Diiloŋo‑i cicɛ̃lmantaaŋ-wuoŋo; bikuoŋ-wuoŋo sĩ.» ");
INSERT INTO cmeNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Bamaŋ waa terieŋgu-na nu nel daama‑i maa gbuu suurnu-bɛi. ");
INSERT INTO cmeNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","*Farisĩɛbaa-baŋ juɔ nu-ma wuɔ Yesu piiye yar *Sadusĩɛbaa-ba‑i, baa ne ba-naa kã u wulaa ");
INSERT INTO cmeNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","da ba ka piiye cure-yuɔ. *Ãnjĩnamma pigãatieŋo naŋo waa ba hɔlma-na, wuɔ biɛ ãndaaŋgu‑i wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Hãalãtie, Diiloŋ uŋ'a i tiɛ wuɔ hũmieŋa maŋ, hade‑i yuŋgu?» ");
INSERT INTO cmeNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesu wuɔ cira: «‹Ŋ saaya ŋ dɔl Itieŋo‑i Diiloŋo‑i baa ŋ huɔŋga‑i hiere, baa ŋ kusũŋgu‑i hiere, baa ŋ ãnjɔguɔma‑i hiere.› ");
INSERT INTO cmeNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Hũmelle fande yaa yuŋgu aa tiraa maar anaŋa‑i hiere. ");
INSERT INTO cmeNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Hãalĩŋ-diele maŋ nyaanu di-naa baa difande‑i di yaa daade: ‹Ŋ saaya ŋ dɔl ŋ nanolŋo‑i ŋaa niŋ dɔl ŋ fɛrɛ dumaa.› ");
INSERT INTO cmeNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","*Moisi hũmieŋa‑i hiere a yuŋgu dii hũmieŋ daaya'i nuɔ‑i a hãi‑i-na baa *Diilopɔpuɔrbiemba nelma‑i hiere.» ");
INSERT INTO cmeNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","*Farisĩɛbaa-baŋ tigiiŋ ba-naa dumaaŋo-na, Yesu wuɔ yuu-ba wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«Namaa na'a Diiloŋ uŋ pãa nuŋgu‑i wuɔ u ka saaŋ *Koŋkortieŋo maŋ, u ka hoŋ dũŋ haku‑i nuɔ‑i?» Baa cira: «*Davidi dũŋ-nu, u ka waa *Davidi hãayɛ̃lŋo.» ");
INSERT INTO cmeNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesu wuɔ cira: «A ma ce niɛ *Diiloŋ-Yalle ce Davidi bĩ-yo u Tieŋo? Ma sĩ Davidi fuɔ fɛrɛ ciɛra wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‹Itieŋo gbĩɛ mi Tieŋo‑i wuɔ: «Jo ŋ ji tĩɛna mi caaŋ-nu aa ŋ yaŋ mi mal ŋ bigãarãamba‑i hã ŋ ce ŋ bãaŋgu‑i bɛi.»› ");
INSERT INTO cmeNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Diiloŋ uŋ pãa nuŋgu‑i aa saaŋ Koŋkortieŋo maŋ, Davidi fuɔ fɛrɛ duɔ tuɔ bĩ-yo u Tieŋo, u ce niɛ aa ce u hãayɛ̃lŋo yoŋ?» ");
INSERT INTO cmeNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Uŋ piiye dumaaŋo-na, molo saa da nelma duɔ siɛ-yo. A bãl dii yiiŋgu faŋgu-na, ba saa ji tiraa da holle yuu-yo baa nelma. ");
INSERT INTO cmeNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ku huoŋgu-na, Yesu wuɔ waŋ baa nuɔmba‑i baa u *hãalãbiemba‑i wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«*Moisiŋ'a i tiɛ wuɔ hũmieŋa maŋ, *ãnjĩnamma pigãataamba‑i baa *Farisĩɛbaa-ba yaa saaya ba ta ba pigãaŋ nuɔmba‑i a wuɔsaaŋgu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","A ce dumaaŋo-na, da ba waŋ mamaŋ baa-na, na ce-ma; ŋga baa na suur bafamba kuuceŋgu-na. Baŋ waŋ mamaŋ ba sa ce-ma. ");
INSERT INTO cmeNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Da ba ce ba haa coŋgorni‑i hã nuɔmba ta ba kpɛkpɛllɛ aa yagar wuɔ ba siɛ kãyã-bɛi ba migãaŋ tũu. ");
INSERT INTO cmeNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ba ce ba wɛima‑i hiere ba taara yerre baa-ma. Na saa da, bafamba kuɔlbaa-ba maar banamba baamba‑i. Aa baŋ naŋ kompammu maŋ, bafamba muumu comieŋa dii pɔ̃mpɔr banamba waaŋa-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Da ba kã kãlle maŋ nuɔ‑i, sisɔ *Diilonelhãalãdũŋgu maŋ nuɔ‑i, ba taara ba tĩɛna yaaŋ-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Aa da ba waa nuɔmba-na, ba taara ba ta ba piɛ ba jaal-ba aa ta ba bĩ-ba hãalãtaamba. ");
INSERT INTO cmeNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Jande, namaaŋo‑i, baa na yaŋ ba ta ba bĩ-na hãalãtaaŋ namaa. Namɛi baaduɔŋ namaa aa na hãalãtieŋo dii u diei yoŋ. ");
INSERT INTO cmeNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Mi baa da na bĩɛ moloŋo hĩɛma-na wuɔ na to. Na To dii u diei yoŋ, u yaa dɔrɔ‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Na baa bi ce ba ta ba bĩ-na yuntaaŋ namaa. Na yuntieŋo dii u diei yoŋ, u yaa *Kirsa‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Umaŋ na yuŋgu-na, u saaya u ce u fɛrɛ na maacembiloŋo. ");
INSERT INTO cmeNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Na saa da, umaŋ duɔ tuɔ tɛtɛŋ u fɛrɛ, ba ka hiire-yuɔ, ŋga umaŋ duɔ tuɔ hiire u fɛrɛ, ba ka tɛtɛŋ-yo.» ");
INSERT INTO cmeNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Yesuŋ waaŋ mafamma‑i wuɔ cira: «*Ãnjĩnamma pigãataaŋ namaaŋo‑i baa *Farisĩɛbaa namaaŋo‑i, huhurmantaaŋ namaa; sũlma haraa-nɛi! Na suu *Diiloŋ-nelle hũmelle‑i, namaa fɛrɛ‑i na siɛ suur, bamaŋ taaraayaŋ da ba suur na suu-de bɛi.  ");
INSERT INTO cmeNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","«Ãnjĩnamma pigãataaŋ namaaŋo‑i baa Farisĩɛbaa namaaŋo‑i, huhurmantaaŋ namaa; sũlma haraa-nɛi! Da na ce na bel diiloŋo‑i a hũu bikulcaamba nagãŋ-niini‑i a wuo-ni, aa da na'a na cãrã Diiloŋo‑i, na cãrã-yuɔ da agaga wuɔ ba cira namaa faa. Kumaŋ ka haa-nɛi, ku ka balaŋ cor. ");
INSERT INTO cmeNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","«Ãnjĩnamma pigãataaŋ namaaŋo‑i baa Farisĩɛbaa namaaŋo‑i, huhurmantaaŋ namaa; sũlma haraa-nɛi! Da na ce na wuɔra gbuo terni‑i hiere a taara nuɔmba‑i dii-ba na hũmelle-na. Ŋga umaŋ duɔ gbãŋ suur tĩ, na bir-o na birma a ce u bir balaŋ yaŋ namaa fɛrɛ‑i titirre. ");
INSERT INTO cmeNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","«Namaa yirii aa bi cira na pigãaŋ banamba hũmelle. Sũlma haraa-nɛi! Na gbĩɛ-ku dumaa wuɔ moloŋ duɔ pã nuŋgu aa bĩ *Diilodubuɔ yerre‑i, duɔ fiɛ'a u saa ji gbãa ce-ma, wɛima sĩ. Ŋga umaŋ duɔ cira: ‹Muɔ baa sɛ̃nɛ maŋ Diilodubuɔ‑i-na mi ka ce daama‑i.› Da ku fiɛ balaŋ niɛ niɛ, u saaya u ce-ma. ");
INSERT INTO cmeNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mimiɛl namaa temma‑i daana‑i! Na yunni kuu aa yaŋ-na. Diilodubuɔ‑i baa sɛ̃nɛ‑i haku‑i bɔyaa haku‑i nuɔ‑i? Sɛ̃nɛ uŋ yeŋ Diilodubuɔ‑i-na ku'i saa ce-yo Diiloŋ-wuoŋo wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","«Da na bi ce na ta na piiye wuɔ moloŋ duɔ pã nuŋgu aa bĩ mumbuolmuŋ-terieŋgu yerre‑i, duɔ fiɛ'a u saa ji gbãa ce-ma, wɛima sĩ, ŋga umaŋ duɔ cira: ‹Muɔ baa tãmmaŋ-kũŋgu maŋ mumbuolmuŋ-terieŋgu dɔrɔ‑i-na mi ka ce daama‑i›, da ku fiɛ gbãŋ niɛ niɛ, u saaya u ce-ma. ");
INSERT INTO cmeNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Mimiɛl namaa temma‑i daana‑i! Na yunni kuu aa yaŋ-na. Mumbuolmuŋ-terieŋgu‑i baa tãmmaŋ-kũŋgu‑i haku‑i bɔyaa haku‑i nuɔ‑i? Tãmmaŋ-kũŋguŋ yeŋ mumbuolmuŋ-terieŋgu dɔrɔ‑i-na, ku'i saa ce-ku Diiloŋ-kũŋgu wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","«Umaŋ duɔ pã nuŋgu aa bĩ mumbuolmuŋ-terieŋgu yerre‑i, kuu dii ŋaa u bĩɛ baa nimaŋ dii ku dɔrɔ‑i-na hiere. ");
INSERT INTO cmeNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Umaŋ duɔ pã nuŋgu aa bĩ Diilodubuɔ yerre‑i, kuu dii ŋaa u bĩɛ baa ku tieŋo‑i hiere. ");
INSERT INTO cmeNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Umaŋ duɔ pã nuŋgu aa hiel u niele dɔrɔ‑i-na, kuu dii ŋaa kutieŋo bĩɛ Diiloŋo yerre‑i baa u muntĩɛnammu‑i hiere. ");
INSERT INTO cmeNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","«Ãnjĩnamma pigãataaŋ namaaŋo‑i baa Farisĩɛbaa namaaŋo‑i, huhurmantaaŋ namaa; sũlma haraa-nɛi! Da na ce na dii Diiloŋo *yufelle‑i ka cor baa niifiɛlu‑i du sĩnni-na hiere, a ne da kumaŋ yuŋgu *ãnjĩnamma-na na sa ce-ku: Na sa ce kumaŋ vii, na siɛ bi tiraa ce kumaŋ faa, na sa wuɔ Diiloŋ-hũmelle‑i. Naa naa saaya na yu nyɔlma baa ma yaa igɛ̃na aa suɔ haa manamma‑i ma dɔrɔ. ");
INSERT INTO cmeNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Namaa yirii aa bi cira na pigãaŋ banamba hũmelle. Da na ce na seŋ hũmma‑i wuɔ na sa taara na nyɔŋ baa kilekilebaa, a ne da naŋ nyɔŋ baa nimaŋ ni saa baa nyɔgɔ̃mɛbaa-ba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","«Ãnjĩnamma pigãataaŋ namaaŋo‑i baa Farisĩɛbaa namaaŋo‑i, huhurmantaaŋ namaa; sũlma haraa-nɛi! Naa dii ŋaa nɛliɛŋo maŋ saaraa kalni honni‑i aa yaŋ ni hɔmmu yu baa duganni. Da na ce na migãaŋ na kũɔma yaa da welewele aa yaŋ na hɔmmu yu baa cuosĩnni baa nenemuŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Mimiɛl namaa temma‑i daana‑i! Na yunni kuu aa yaŋ-na. Saaraaŋ kalni hɔmmu yaa igɛ̃na, na ka da ni honni bi kuɔŋ. ");
INSERT INTO cmeNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","«Ãnjĩnamma pigãataaŋ namaaŋo‑i baa Farisĩɛbaa namaaŋo‑i, huhurmantaaŋ namaa; sũlma haraa-nɛi! Naa dii ŋaa cĩncuɔŋa maŋ baŋ puu-ya baa pilammu a ta a ne da fafamma, a ne da a hɔmmu yuu baa kokonni baa hũlãbabalaaŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ku yaa ŋaa namaa kũŋgu‑i. Nuɔŋ da ba da-na, ba cira: ‹Bamaŋ wuɔyaaŋ Diiloŋ-hũmelle‑i fafamma ba yaa daaba‑i.› A ne da na hɔmmu yuu baa huhurma baa balaaŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","«Ãnjĩnamma pigãataaŋ namaaŋo‑i baa Farisĩɛbaa namaaŋo‑i, huhurmantaaŋ namaa; sũlma haraa-nɛi! Na siire ta na ma *Diilopɔpuɔrbiemba cĩncuɔŋa‑i aa ta na tuɔlnu bamaŋ siire wuɔ Diiloŋ-hũmelle‑i fafamma aa ku ba waaŋa‑i ");
INSERT INTO cmeNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","aa ta na piiye wuɔ: ‹Kuɔ ii naa waa i bĩncuɔmba bãaŋgu-na, ii naa saa cu ba huoŋ-nu Diilopɔpuɔrbiemba komma-na.› ");
INSERT INTO cmeNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Terieŋgu faŋgu-na, na pigãaŋ wuɔ bamaŋ kuɔ Diilopɔpuɔrbiemba‑i namaa bĩncuɔmba. ");
INSERT INTO cmeNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ku faa! Gbãaŋ na cor baa na bĩncuɔmba maacemma‑i na ka bãl-ma. ");
INSERT INTO cmeNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Nelbabalaaŋ namaa temma‑i daana‑i! Diiloŋo ce niɛ aa u siɛ ka caa namaa? ");
INSERT INTO cmeNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Niɛŋ, mi ka saaŋ Diilopɔpuɔrbiemba hã-na, baa nelnurãamba a naara ãnjĩnamma pigãataamba namba. Da ba kã, na ka ko banamba bɛi, aa gbu banamba dɛnniŋ aa muo banamba na *Diilonelhãalãdũnni-na. Na ka nyaa ba huoŋ-nu nilɛiŋa-na hiere ce-ba kpãncɔ̃lgũɔ. ");
INSERT INTO cmeNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Terieŋgu faŋgu-na, baŋ fiɛŋ bamaŋ ko-ba hiere a doŋ Abɛl-na a ji hi Barasi biɛŋo‑i Sakari‑i, naŋ kuɔ umaŋ mumbuolmuŋ-terieŋgu hɔlma-na baa Diilodubuɔ‑i, Diiloŋo ka haa-ma hã namɛi baa-ma hiere. ");
INSERT INTO cmeNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Yaaŋ mi waŋ ninsoŋo‑i baa-na: Diiloŋo ka haa nuɔŋ daaba kuliiŋgu maama‑i hiere hã fiɛfiɛ ku nuɔŋ namɛi baa-ma.» ");
INSERT INTO cmeNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ku huoŋgu-na, Yesu wuɔ cira: «E Yerusalɛmutaaŋ namaa! Namɛi kuɔŋ *Diilopɔpuɔrbiemba‑i. Diiloŋ duɔ saaŋ umaŋ hã-na, na bel diiloŋo‑i naŋ kutieŋo‑i baa tãmpɛ̃lɛ̃iŋa ko-yo. Mɛi ciɛ ji gbɛ̃; mi na'a mi tigiiŋ-na ŋaa kũɔnaŋ uŋ tigiiŋ u biemba‑i dumaa aa pũl-bɛi. Ŋga na saa hũu-ma. ");
INSERT INTO cmeNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Kuŋ hii terieŋgu maŋ fiɛfiɛ‑i-na, Diiloŋo ka yaŋ na nelle‑i hã-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Aa mi tũnu-nɛi, da na saa ji ta na cira: ‹Itieŋ uŋ saaŋ umaŋ u jo, Diilo baa-yo› na siɛ tiraa da mi yufelle.» ");
INSERT INTO cmeNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesuŋ juɔ hel *Diilodubuɔ‑i-na tuɔ ta, u *hãalãbiemba kã u wulaa ka ta ba piiye baa-yo wuɔ u ne Diilodubuɔ‑i kɛrɛ u mamma faa. ");
INSERT INTO cmeNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yesu wuɔ cira: «Yaaŋ mi waŋ ninsoŋo‑i baa-na: Naŋ daa dũŋgu maŋ daaku‑i, yiiŋgu dii baa yiiŋgu ku ka fara hiere hĩɛma-na!» ");
INSERT INTO cmeNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Uŋ kaa hi *Olivi-tibinni tãnuŋgu‑i, wuɔ tĩɛna. U hãalãbiemba piɛ kã u wulaa ba kula, a ka yuu-yo wuɔ: «Itie, niŋ waaŋ nelma maŋ daama‑i, ma ka ce yaku‑i? Aa i ka ce niɛ suɔ ŋ jommaŋ-huɔŋgu‑i baa miwaaŋo tĩmmaŋ-huɔŋgu‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesu wuɔ cira: «Baa na yaŋ moloŋo ji pira-nɛi. ");
INSERT INTO cmeNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Nuɔmba bɔi ka jo ji biɛ mi yerre‑i ce-de ba diele. Umaŋ duɔ jo, u ka cira Diiloŋ uŋ saaŋ *Koŋkortieŋo maŋ, u yaa ufaŋo‑i. Ba ka pira nuɔmba bɔi. ");
INSERT INTO cmeNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Na ka da bɛrru ce terni-na hiere. Ŋga da na ji ta na da-ma, baa na tie holle, mafamma saaya ma ce, ŋga miwaaŋo tĩmma'i siɛ pãŋ waa huɔŋgu faŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Nuɔmba kaa ta ba gãŋ siyaabaa siyaabaa, baa nilɛiŋa nilɛiŋa. Nyulmu kaa ta mu suur aa hĩɛma kaa ta ma sagalla terni nanni-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Nifanni‑i daani‑i hiere hãaŋo. Ku domma'i dumaaŋo-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","«Ba kaa bel-na ce-na sũlma aa ko-na. Ba ka bigãaŋ-na nilɛiŋa-na hiere mɛi maama-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Huɔŋgu faŋgu-na, nuɔmba bɔi kaa nanna Diiloŋ-hũmelle‑i. Ba kaa hel ba-naa honniŋ aa bigãaŋ ba-naa. ");
INSERT INTO cmeNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Nuɔmba bɔi ka jo ji ta ba tãal nuɔmba‑i wuɔ bafamba *Diilopɔpuɔrbiemba. Ba ka pira nuɔmba bɔi. ");
INSERT INTO cmeNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ãmbabalma kaa ta yaaŋga nuɔmba-na a ce ba bɔi siɛ tiraa ta ba ce nelnyulmu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ŋga umaŋ duɔ nyaar ka hi ku bãlma‑i, kutieŋo ka kor. ");
INSERT INTO cmeNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","*Diiloŋ-bãaŋgu *Neldɔdɔlma ka wuɔra waŋ terni-na hiere nuɔmba‑i nilɛiŋa-na hiere ba suɔ-ma aa fiɛfiɛ‑i-na miwaaŋo tĩmma suɔ da ma hi.» ");
INSERT INTO cmeNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«Nuɔni maŋ da ŋ kalaŋ terieŋ daaku‑i, ŋ gbãŋ kpelle ŋ suɔ ku yuŋgu‑i. Diiloŋ uŋ puɔraa Daniɛl waŋ Terbĩɛnatieŋo maŋ maama‑i, da na ji da u juɔ ji tĩɛna *Diilodubuɔ‑i-na, ");
INSERT INTO cmeNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","bamaŋ da ba waa *Yude‑i-na, ba ta ba gbar ba kã tãnniŋ. ");
INSERT INTO cmeNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Umaŋ duɔ ji waa u dũŋgu dɔrɔ‑i-na, u hiire u tuɔ gbar, u baa cira u suur biɛ bĩŋkũŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Umaŋ duɔ ji waa suoŋ-nu, u baa cira u jo cĩiŋ-nu ji biɛ waaŋ-joŋgoruo. ");
INSERT INTO cmeNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","«Kusũntaamba‑i baa bientaamba‑i sũlma haraa-bɛi yinni fanni-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Taa na cãrã Diiloŋo‑i ku baa ji ce waaŋ-huɔŋgu aa ku baa ji waa *yitĩɛnaŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Diiloŋ uŋ jĩɛna miwaaŋo‑i ji hi baa nyuŋgo, yaahuolo maŋ temma‑i saa da nelbiliemba‑i, u'i ka da-ba yinni fanni-na. Aa yaahuolo daayo temma sa ji tiraa da-ba dede. ");
INSERT INTO cmeNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Kuɔ Diiloŋo saa naa hiel kunaŋgu yiŋ daani-na, molo naa saa kor. Ŋga u yufelleŋ hilaa bamaŋ nuɔ‑i, u ka ne ba yaa‑i aa parra yiŋ daani‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","24","«Coikartaamba ka ta ba jo. Umaŋ duɔ jo, u ka cira Diiloŋ uŋ saaŋ *Koŋkortieŋo maŋ, u yaa ufaŋo‑i. Banaŋ ba'a bafamba *Diilopɔpuɔrbiemba. Ba ka ce nelma bɔi baa himma bɔi da ba gbãŋ pira halle Diiloŋo yufelleŋ hilaa bamaŋ nuɔ‑i. A ce dumaaŋo-na, umaŋ duɔ ji gbɛ̃-na wuɔ Diiloŋ uŋ saaŋ Koŋkortieŋo maŋ, uu dii bande, sisɔ uu dii daalɛi, baa na hũu-ma; u tãal-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Muɔ fuɔ, mɛi gbuɔya-nɛi jĩna. ");
INSERT INTO cmeNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","«Terieŋgu faŋgu-na, moloŋ duɔ ji gbɛ̃-na wuɔ: ‹*Kirsa juɔ; uu dii hĩɛŋgu-na›, baa na kã; u tãal-na. Da ba bi gbɛ̃-na wuɔ: ‹Niɛŋ, uu dii fuo bande›, ba tãal-na; baa na hũu-ma. ");
INSERT INTO cmeNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Diiloŋ uŋ nyiɛsĩŋ dumaa nuɔmba da-yo a doŋ bãpagũŋgu-na ka jũŋ bãsuuruŋgu-na, *Moloŋ-Biɛŋ duɔ jo, ba ka da-yo dumɛi. ");
INSERT INTO cmeNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Bĩŋkũkuliiŋ da ku waa kusuɔŋ-nu, kpaalbaa-ba tigiiŋ kusuɔŋ-nu'i.» ");
INSERT INTO cmeNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«Yaahuolo daa duɔ tuɔ bãl, bãaŋgu ka bir cure, cɛiŋo ka ce da bĩntũu. Mɔɛŋa ka par diire, aa bĩmbĩnni maŋ dii dɔrɔ‑i-na hiere ni ka hel ni fonni-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Huɔŋgu faŋgu'i nuɔ‑i *Moloŋ-Biɛŋo dãnyuɔ ka carra dɔrɔ‑i-na. Duɔ carra, nuɔmba‑i hiere hĩɛma-na ba ka haa ba nammu‑i ba yunniŋ ta ba gbu ba kaal. Da ba'a ba ne, ba ka da u hiire u jo baa duherru. Ba ka da u yuntesĩnni‑i baa u bɔbɔima‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Huɔŋgu faŋgu-na, na ka da ba buu yɛrre maŋ bãmbãale diele‑i. Da ba bu-de terieŋgu maŋ nuɔ‑i, u ka ce u *dɔrpɔpuɔrbiemba wuɔra terni-na hiere a tigiiŋ u yufelleŋ hilaa bamaŋ nuɔ‑i ba waa terduɔŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","«Na saa da *yensãaŋgu‑i wɛi? Da na ji da ku caa fiɛlu‑i huɔŋgu maŋ nuɔ‑i, na bi suɔ kerre ifɛlle hii tĩ. ");
INSERT INTO cmeNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Kuuduɔŋgu yaa‑i, da na bi ji da mamaŋ daama duɔŋ ta ma ce huɔŋgu maŋ nuɔ‑i, na saaya na suɔ wuɔ Moloŋ-Biɛŋo jomma piyaa. ");
INSERT INTO cmeNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Yaaŋ mi waŋ ninsoŋo‑i baa-na: Nel daama ka ce hi fiɛfiɛ ku nuɔmba namba aa ba suɔ ku. ");
INSERT INTO cmeNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Dɔrɔ‑i baa hĩɛma‑i ni ka gbuo, ŋga mɛi nelma sa ji gbuo dede.» ");
INSERT INTO cmeNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","«Ŋga kumaŋ ŋaa yiiŋgu faŋgu fɛrɛ‑i, baa huɔŋgu‑i, molo sa suɔ-ku. Halle *dɔrpɔpuɔrbiemba famba fɛrɛ‑i dɔrɔ‑i-na baa Bɛpolŋ fuɔ fɛrɛ‑i ba sa suɔ-ku. U To yaa suyaaŋ-kuŋ u diei yoŋ. ");
INSERT INTO cmeNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Kumaŋ ciɛ *Nowe bãaŋgu-na, *Moloŋ-Biɛŋ duɔ u bir jo, ku temma ka ce. ");
INSERT INTO cmeNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Nowe bãaŋgu-na, aa diilobuɔ suɔ duɔ dãa, nuɔmba naa gonya niiwuoni baa kolma baa cɛjãlle a ji hi yiiŋgu maŋ Noweŋ suurii begubuɔ‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ba saa suɔ wuɔ wɛima jo dii. Ba juɔ'a ba ne da diilopepetieŋo naŋo‑i duɔŋ tuɔ dãa. Hũmma wuo-ba hiere kpɛ̃mmu! Moloŋ-Biɛŋ duɔ ji'a u jo, ku ka tugol nuɔmba‑i dumɛi. ");
INSERT INTO cmeNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Nuɔmba hãi gbãa waa ta ba guona, ba biɛ u diei ta, aa yaŋ unaŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Caamba hãi gbãa waa ta ba sɔrɔŋ, ba biɛ u diei ta, aa yaŋ unaŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Terieŋgu faŋgu-na, baa na gonya duɔfũmmu, na saa suɔ na Tieŋo jommaŋ-yiiŋgu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Na saa da, da ŋ suɔ cuoyuo uŋ ka suur-niɛ huɔŋgu maŋ nuɔ‑i isuɔŋgu-na, ŋ ka tĩɛna cie-yo, ŋ siɛ yaŋ u ji kanu ŋ dũŋgu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Terieŋgu faŋgu-na, na saaya na tigiiŋ na fɛrɛ. Naŋ'a na saa tĩɛna baa-ma wuɔ Moloŋ-Biɛŋo ka jo huɔŋgu maŋ nuɔ‑i, u bi jo huɔŋgu faŋgu'i nuɔ‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","«Da ŋ nu wuɔ maacembiloŋo maŋ vii aa tuɔ cɛ̃, u yaa umaŋ u yuntieŋo kãa nelle aa haa-yo u namaacembiemba namba yuŋ-nu u tuɔ hã-ba niiwuoni‑i fafamma. ");
INSERT INTO cmeNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","U yuntieŋ duɔ ka bir jo ji da u ciɛ u maacemma‑i fafamma, fuɔ yuŋgu dɔlaa. ");
INSERT INTO cmeNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Mi waŋ ninsoŋo‑i baa-na: Yuntieŋo ka haa-yo u nagãŋ-niini yuŋ-nu hiere. ");
INSERT INTO cmeNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ŋga da ku waa maacembilobabalaŋo, u ka tuɔ jɔguɔŋ wuɔ u yuntieŋo siɛ jo fiɛfiɛ, ");
INSERT INTO cmeNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","aa doŋ tuɔ muo u nabaamba‑i, aa tĩɛ tuɔ wuo aa tuɔ wuɔra u nyɔŋ kolma baa konyɔrãamba. ");
INSERT INTO cmeNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Uŋ'a u saa tĩɛna baa yiiŋgu maŋ maama‑i, baa huɔŋgu maŋ maama‑i, u yuntieŋo jo huɔŋgu faŋgu'i nuɔ‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Duɔ jo ji da-yo dumaaŋo-na, baŋ ka haa kumaŋ huhurmantaamba-na, u ka haa ku yaa yuɔ. Kaaluŋgu siɛ gbuu waa dɛi.» ");
INSERT INTO cmeNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ku huoŋgu-na, Yesu wuɔ naŋ gbãnalãaŋ daaku‑i baa-ba wuɔ: «*Diiloŋ-nelle suurmaŋ-kũŋgu ka waa ŋaa biemba cĩncieluo naŋ kũŋgu: Ba siire isuɔŋgu naŋgu-na a biɛ ba fitĩmbaa-ba‑i wuɔ ba ka jãrã dɔrbiɛŋo. ");
INSERT INTO cmeNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ba hɔlma-na, ba ndii cɛ̃ aa ba ndii baamba namba sa cɛ̃. ");
INSERT INTO cmeNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Bamaŋ sa cãaŋ ba biyaa ba fitĩmbaa-ba‑i aa ba saa biɛ namma bel ba naŋ-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Bamaŋ cãaŋ, bafamba biɛ ba baamba‑i aa biɛ namma bel ba naŋ-na wuɔ ba sa suɔ wɛimaŋ maa-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Baŋ kãa, dɔrbiɛŋo jomma ka ce pãnna, ba kor duɔfũŋ hiere. ");
INSERT INTO cmeNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","«Isuɔholleŋ juɔ hi, ba nu molo piiye da gbagaga wuɔ: ‹Dɔrbiɛŋo'i juɔŋ daayo! Hilaaŋ na jãrã-yuɔ!› ");
INSERT INTO cmeNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ba sire ku yaa nuɔ‑i ba hieroŋo‑i, ta ba migãaŋ ba fitĩmbaa-ba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Bamaŋ saa biɛ namma‑i, ba ta ba piiye baa bamaŋ biyaa wuɔ: ‹I namma tĩɛ, i fitĩmbaa-ba ce da ba dĩŋ; na sa hã-ye manamma wɛi?› ");
INSERT INTO cmeNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Bamaŋ biyaa namma‑i ba cira: ‹Miɛ iŋ biyaa mamaŋ, ma siɛ gbɛ̃ i calnu-mɛi. Kumaŋ bɔyaa, kãaŋ na ka sãa manamma na jo.› ");
INSERT INTO cmeNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ba sire ku yaa nuɔ‑i da ba ka sãa. Baŋ taa, dɔrbiɛŋo jo. Ba ndii baamba suur baa-yo kãlleŋ-dũŋgu-na aa ba gbonu-kuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Daabaŋ kaa jo, ba jo ji ta ba muo dũŋgu‑i wuɔ ba hĩl-ku ba suur. ");
INSERT INTO cmeNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Dɔrbiɛŋo gbɛ̃-ba wuɔ: ‹Mi sa suɔ namaaŋo‑i, mi siɛ fuo-ma nɛi!›» ");
INSERT INTO cmeNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yesu wuɔ miɛl gbɛ̃ u *hãalãbiemba‑i wuɔ: «Terieŋgu faŋgu-na, baa na gonya duɔfũmmu. Na sa suɔ *Moloŋ-Biɛŋo jommaŋ-yiiŋgu ka feŋ bĩ u jommaŋ-huɔŋgu.» ");
INSERT INTO cmeNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","«*Diiloŋ-nelle kũŋgu ka waa ŋaa naacolŋo maŋ wuɔ u kã nelle aa bĩ u maacembiemba‑i a ji hã-ba u gbeiŋa‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","U hãa unaŋo‑i tãmabaa-ba ndii, aa hã unaŋo‑i ba hãi, aa hã siɛliŋ-wuoŋo‑i u diei. U niɛ ba fɔ̃ŋgɔ̃baa-baŋ hii ba ce mamaŋ aa hã-ba saanu baa ku yaa‑i, aa ta. ");
INSERT INTO cmeNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Umaŋ daa tãmabaa-ba ndii‑i, u pãŋ kã ka doŋ tuɔ bibirre u naŋga baa u waaŋa‑i ji da u gbeinyuŋo temma. ");
INSERT INTO cmeNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Umaŋ daa tãmabaa-ba hãi maaduɔma; fuɔ‑i a bi ji da u gbeinyuŋo temma. ");
INSERT INTO cmeNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Umaŋ daa u diei u bir yaŋ aa kã ka hĩŋ fuoŋgu fuo u wuoŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","«Ba yuntieŋ uŋ taa dumaaŋo-na, u kaa vaaya. Uŋ juɔ jo, u bĩ-ba ji tuɔ yuu-ba. ");
INSERT INTO cmeNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Uŋ ŋa naa hã umaŋ tãmabaa-ba ndii‑i, u piɛ pigãaŋ-yo tãmabaa-ba ndii daayo‑i aa cira: ‹Yuntie, niŋ ŋa naa hã-mi tãmabaa-ba ndii maŋ, mi tiraa da ba temma naara-bɛi; ba yaa daaba.› ");
INSERT INTO cmeNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","«U yuntieŋo gbɛ̃-yo wuɔ: ‹Ku faa, maacembiloviiyoŋ nuɔ. Niŋ suyaa cɛkũɔ kũŋgu belma, mi ka hã-ni bãmbãale kũŋgu. Jo ŋ ji ta ŋ ce ŋ bãaŋgu‑i baa-mi.› ");
INSERT INTO cmeNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","«Uŋ ŋa naa hã umaŋ tãmabaa-ba hãi, u piɛ aa cira: ‹Yuntie, niŋ ŋa naa hã-mi tãmabaa-ba hãi maŋ, mi daa ba hãi naŋo naara-bɛi, ba yaa daaba.› ");
INSERT INTO cmeNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","«U yuntieŋo gbɛ̃-yo wuɔ: ‹Ku faa, maacembiloviiyoŋ nuɔ. Niŋ suyaa cɛkũɔ kũŋgu belma, mi ka hã-ni bãmbãale kũŋgu. Jo ŋ ji ta ŋ ce ŋ bãaŋgu‑i baa-mi.› ");
INSERT INTO cmeNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","«Uŋ ŋa naa hã umaŋ u diei, u piɛ aa cira: ‹Yuntie, mi suyaa miɛ naŋ kũŋgu dii kpelle, nuɔ da ŋ saa kũ suoŋgu maŋ, ŋ kar kufaŋgu dĩmma yaa‑i; da ŋ saa duu dĩmma maŋ, ŋ kar ma yaa‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Mɛi kãalãayã aa kã ka hĩŋ fuoŋgu fuo ŋ gbeiŋa‑i, a yaa daaya.› ");
INSERT INTO cmeNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","«U yuntieŋo gbɛ̃-yo wuɔ: ‹Maacembilobabalaŋ nuɔ naŋ temma‑i daani‑i, yentieŋ nuɔni maŋ daani‑i, nii naa suɔ wuɔ da mi saa kũ suoŋgu maŋ, mi kar kufaŋgu dĩmma yaa‑i; aa da mi saa duu dĩmma maŋ, mi kar ma yaa‑i, ");
INSERT INTO cmeNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","bige‑i ciɛ ŋ saa kã ka jĩna mi gbeiŋa‑i gbeindũŋ-nu? Miŋ juɔ dɛ‑i-na mii naa saa jo ji da a huonaana mi hũu-ya wɛi?› ");
INSERT INTO cmeNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Aa naa cira: ‹Hũyãaŋ tãma maŋ u wulaa na hã umaŋ daa tãmabaa cĩncieluo‑i baa-yo! ");
INSERT INTO cmeNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Umaŋ duɔ da, kunaŋgu ka naara u kũŋgu‑i a ce ku yure baa-yo, ŋga umaŋ duɔ saa da, cɛllɛ kũŋgu maŋ dii baa-yo, ku hũu. ");
INSERT INTO cmeNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Aa maacembiloŋo faŋo‑i daayo‑i, u siɛ bi gbãa cii muonu caŋga, hielaaŋ-yoŋ fuoreŋ dii kukulma-na. Duɔ tĩɛ dii terieŋgu-na, kaaluŋgu siɛ gbuu waa dɛi.›» ");
INSERT INTO cmeNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Yesuŋ waaŋ mafamma‑i, wuɔ cira: «*Moloŋ-Biɛŋ duɔ ji jo u fɔ̃ŋgɔ̃tesĩnniŋ-jomma‑i baa *dɔrpɔpuɔrbiemba‑i u ka tĩɛna u fɔ̃ŋgɔ̃tesĩnni-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Nuɔmba‑i nilɛiŋa-na hiere ba ka tigiiŋ u yaaŋga-na u fiɛl nelfafaamba‑i hiel-ba nelbabalaamba-na ŋaa ãncĩinaŋ uŋ fiɛl tũlmba‑i dumaa hiel-ba yɛrmba-na ");
INSERT INTO cmeNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","a jĩna tũlmba‑i u nadieŋ-na aa yɛrmba‑i u nanyuɔŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","«Bamaŋ da ba ji waa u nadieŋga-na ba yaa nelfafaamba‑i; u ka gbɛ̃-ba wuɔ: ‹Juɔŋ, mi To ciɛ baa namaaŋo‑i. *Diiloŋ-nelle migãaŋ dii miwaaŋo jĩnammaŋ-huɔŋgu ta di cie-na, juɔŋ na ji ta na ce na bãaŋgu‑i diɛ. ");
INSERT INTO cmeNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Na saa da, nyulmu taa mu ko muɔ, na hã-mi niiwuoni mi wuo. Hũŋkuɔsĩnni waa-miɛ, na hã-mi hũmma mi nyɔŋ. Mi kãa na wulaa, na hũu-ma mi har-nɛi. ");
INSERT INTO cmeNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Mi waa bebelle, na hã-mi nyarkpãtãnni mi cĩnnu mi kũɔma‑i. Mi taa mi jaŋ, na kã ka ne-mi. Mi waa kaso‑i-na, na kã ka jaal-mi.› ");
INSERT INTO cmeNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","«Duɔ waŋ mafamma‑i, nelfafaamba ka bir yuu-yo wuɔ: ‹Itie, i daa-ni nyulmu-na yaku‑i aa i hã ŋ wuo? Yiiŋ haku‑i nuɔ‑i hũŋkuɔsĩnni waa-niɛ aa i hã-ni hũmma‑i ŋ nyɔŋ? ");
INSERT INTO cmeNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Yiiŋ haku‑i ŋ juɔ i wulaa i hũu-ma ŋ har-yiɛ? Aa yiiŋ haku‑i i daa-ni bebelle i hã-ni nyarkpãtãnni‑i ŋ cĩnnu ŋ kũɔma‑i? ");
INSERT INTO cmeNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ŋ taa ŋ jaŋ yaku‑i aa ŋ waa kaso‑i-na yaku‑i i kã ka ne-ni?› ");
INSERT INTO cmeNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","«U ka gbɛ̃-ba wuɔ: ‹Yaaŋ mi waŋ ninsoŋo‑i baa-na: Naŋ taa na ce-ma na hã mi baamba‑i baa ba hãasĩmma‑i, kuu dii ŋaa na taa na ce-ma na hã muɔmɛi.› ");
INSERT INTO cmeNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","«Ku huoŋgu-na, u ka bir waŋ baa bamaŋ dii u nanyuɔŋgu-na wuɔ: ‹Halaaŋ mi caaŋ-nu, Diiloŋo gãaŋ baa namaa fuɔ! Dãŋgbɔguɔŋgu maŋ diyaa ta ku cie *Sitãni‑i baa u pɔpuɔrbiemba‑i, taa na kã ku yaa nuɔ‑i! ");
INSERT INTO cmeNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Na saa da, nyulmu taa mu ko-muɔ, na saa hã-mi niiwuoni mi wuo. Hũŋkuɔsĩnni waa-miɛ, na saa hã-mi hũmma mi nyɔŋ. ");
INSERT INTO cmeNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Mi kãa na wulaa, na saa hũu-ma mi har-nɛi. Mi waa bebelle, na saa hã-mi nyarkpãtãnni mi cĩnnu mi kũɔma‑i. Mi taa mi jaŋ, na saa kã ka ne-mi. Mi waa kaso‑i-na, na saa kã ka jaal-mi.› ");
INSERT INTO cmeNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","«Duɔ waŋ mafamma‑i, ba ka cira: ‹Itie, i daa nyulmu taa mu ko-ni yaku‑i aa i yagar wuɔ i siɛ hã ŋ wuo? Yiiŋ haku‑i nuɔ‑i hũŋkuɔsĩnni‑i waa-niɛ aa i balaŋ-ni hũmma‑i? Yiiŋ haku‑i nuɔ‑i ŋ juɔ i wulaa aa i saa hũu-ma ŋ har-yiɛ? Aa yiiŋ haku‑i nuɔ‑i i daa-ni bebelle i saa hã-ni nyarkpãtãnni‑i ŋ cĩnnu ŋ kũɔma‑i? Ŋ taa ŋ jaŋ yaku‑i aa ŋ waa kaso‑i-na yaku‑i aa i saa kã ka ne-ni?› ");
INSERT INTO cmeNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","«U ka gbɛ̃-ba wuɔ: ‹Yaaŋ mi waŋ ninsoŋo‑i baa-na: Naŋ ŋa naa ta na yagar ma cemma da na hã mi baamba‑i baa ba hãasĩmma‑i, kuu dii ŋaa na taa na yagar da na ce-ma hã muɔmɛi.› ");
INSERT INTO cmeNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Terieŋgu faŋgu-na, bafamba ka ta ba kã dãamuŋ-nelleŋ aa nelfafaamba ta ba kã Diiloŋ-nelleŋ.» ");
INSERT INTO cmeNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesuŋ juɔ waŋ nel daama‑i hiere tĩ, wuɔ waŋ baa u *hãalãbiemba‑i wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Ma sĩ na suyaa wuɔ yinni hãi tĩyãa aa *kɔrsĩnni tĩmmaŋ-ponsaaŋgu da ku hi kɛ? Da ku hi, ba ka bel *Moloŋ-Biɛŋo‑i a hã ba gbu-yo *daaŋ-nu ko-yo.» ");
INSERT INTO cmeNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Yibieŋa faŋa-na, *Diilojigãntaamba yuntaamba‑i baa nelle bĩncuɔŋ baa tigiiŋ ba-naa *Diilojigãntaamba yuntieŋo dumɛlle-na, ba taa ba bĩ-yo Kayifu, ");
INSERT INTO cmeNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","a saa-ma baŋ ka ce dumaa bel Yesu‑i ko-yo. ");
INSERT INTO cmeNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ba taa ba piiye wuɔ: «I saa saaya i bel-o ponsaaŋgu yinni-na ni ma'i sĩ ku ka du.» ");
INSERT INTO cmeNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Huɔŋgu faŋgu-na, Yesu waa Betani, *jardãamaŋ waa Simɔ maŋ nuɔ‑i u dumɛlle-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ciɛŋo naŋ wuɔ kã u wulaa baa sukpekpelluŋ-natikolo naŋo *alabati-kamoeleŋ. Yesubaa-ba waa ta ba wuo niiwuoni. Wuɔ kã ka kũnna-yuɔ Yesu yuŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","*Hãalãbiembaŋ daa kufaŋgu‑i, ba hɔmmu gbuu pãŋ guɔla. Baa ta ba piiye wuɔ: «Bige‑i ciɛ u bĩɛna natikolofɛfɛiŋ daayo‑i? ");
INSERT INTO cmeNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Uu naa gbãa suor-o a da gbeibuɔ a calnu hã sũntaamba‑i do!» ");
INSERT INTO cmeNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesu wuɔ suɔ baa-ba; wuɔ cira: «Bige‑i ciɛ na ta na piiye na guɔla ciɛŋo huɔŋga‑i? Uŋ ciɛ kumaŋ miɛ daaku‑i, ku faa. ");
INSERT INTO cmeNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Na saa da, sũntaamba dii baa-na bãaŋgu‑i baa isuɔŋgu‑i, ŋga muɔmi siɛ tĩɛna baa-na gbula. ");
INSERT INTO cmeNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","U kũɔna natikolo daayo‑i miɛ tuɔ cie mi kuliiŋ-yiiŋgu yaa‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Mi waŋ ninsoŋo‑i baa-na: *Neldɔdɔl daama da ma waŋ terieŋgu terieŋgu hĩɛma-na bande‑i-na, ciɛŋ daa uŋ ciɛ mamaŋ daama‑i, ma ka bi waŋ nuɔmba suɔ-ma.» ");
INSERT INTO cmeNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ku huoŋgu-na, Yesu *hãalãbieŋ cĩncieluo ba hãi baamba-na, baŋ bĩŋ umaŋ *Yuda‑Isikaro‑i, fuɔ wuɔ sire kã *Diilojigãntaamba yuntaamba wulaa ");
INSERT INTO cmeNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ka yuu-ba wuɔ: «Da mi kãyã-nɛi na bel Yesu‑i, na ka hã-mi bige‑i?» Baa kãŋ bafamba warbieŋ komorre baa cĩncieluo a hã-yo. ");
INSERT INTO cmeNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","A doŋ huɔŋgu faŋgu-na, Yuda wuɔ doŋ tuɔ ne uŋ ka ce dumaa ba bel Yesu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","*Baŋ'a ba sa dii siini‑i *buruo maŋ nuɔ‑i u ponsaaŋgu yidĩɛlãŋgu-na, Yesu *hãalãbiemba yuu-yo wuɔ: «Itie, ŋ taara i ce *kɔrsĩnni tĩmmaŋ-ponsaaŋgu niiwuoni‑i hie a hã-ni?» ");
INSERT INTO cmeNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yesu wuɔ cira: «Kãaŋ nelleŋ-huɔŋga-na mɛlŋ daayo wulaa, na ka waŋ baa-yo wuɔ: ‹Hãalãtieŋ wuɔ ku hii u wulaa tĩ, u ka ce kɔrsĩnni tĩmmaŋ-ponsaaŋgu‑i naŋ terieŋ-nu'i baa u hãalãbiemba‑i.›» ");
INSERT INTO cmeNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Hãalãbiemba ta kã nelleŋ-huɔŋga-na ŋaa Yesuŋ bi waaŋ-ma dumaa ka ce kɔrsĩnni tĩmmaŋ-ponsaaŋgu niiwuoni‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Bãaŋguŋ juɔ suur huɔŋgu maŋ nuɔ‑i, Yesu‑i baa u *hãalãbieŋ cĩncieluo ba hãi baamba kã ka tĩɛna ta ba wuo niiwuoni‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Yesu wuɔ waŋ baa-ba wuɔ: «Yaaŋ mi waŋ ninsoŋo‑i baa-na: Na hɔlma-na unaa ka hel mi huoŋ-nu.» ");
INSERT INTO cmeNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ba yammu pãŋ vãa hiere; baa doŋ ta ba yuu-yo, wulawula wuɔ: «Itie, muɔmɛi wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesu wuɔ cira: «Umaŋ wuyaaŋ baa-mi kaladuɔŋgu-na u yaa ka hel mi huoŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","*Moloŋ-Biɛŋo ka ku ŋaa maŋ nyɛgãaŋ Diiloŋ-nelma-na dumaa; ŋga umaŋ ka hã-ba baa-yo ba ko-yo, sũlma haraa-yuɔ! Bɔlbɔl uu naa baa hoŋ.» ");
INSERT INTO cmeNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","*Yuda wuɔ suuye u yufieŋa‑i aa naa cira: «Hãalãtie, muɔmɛi wɛi?» Yesu wuɔ cira: «Ŋ suɔ-ma ŋ yaŋ muɔ.» ");
INSERT INTO cmeNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Baŋ waa ta ba wuo niiwuoni‑i, wuɔ biɛ *buruo aa jaal Diiloŋo‑i aa bũlnu-yuɔ hã u hãalãbiemba‑i aa cira: «Hũyãaŋ mi kũɔma yaa‑i daama na wuo.» ");
INSERT INTO cmeNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ku huoŋgu-na, wuɔ biɛ duvɛ̃ŋo ciiŋ-na, aa jaal Diiloŋo‑i aa hã-ba baa-yo aa cira: «Nyuɔŋ hiere, ");
INSERT INTO cmeNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","mi tãmma yaa‑i, *tobisĩnniŋ-tãmma yaa‑i. Ma ka kũnna pir nuɔmba bɔi ãmbabalma. ");
INSERT INTO cmeNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Mi tũnu-nɛi: Da ma hel fiɛfiɛ‑i-na, ni mi To nelleŋ sĩ, mi siɛ tiraa nyɔŋ duvɛ̃ŋo baa-na.» ");
INSERT INTO cmeNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ku huoŋgu-na, baa hãl nɛini gbɛliɛŋ Diiloŋo‑i aa sire ta ba kã *Olivi-tibinni-tãnuŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Baŋ kãŋ hũmelle-na, Yesu wuɔ gbɛ̃ u *hãalãbiemba‑i wuɔ: «Mamaŋ nyɛgãaŋ Diiloŋ-nelma-na wuɔ: ‹Mi ka ko ãncĩinaŋo‑i aa yaŋ tũlmba pisãllã hiere› ma yaa ka da-mi isuɔŋ daaku-na. Na ka nanna-miɛ na hieroŋo‑i hiere. ");
INSERT INTO cmeNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ŋga da mi sire, mi ka kã ka cie-na *Galile‑i-na.» ");
INSERT INTO cmeNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Piɛr wuɔ cira: «Banaŋ da ba fiɛ nanna-niɛ hiere, muɔ fuɔ, mi cɛraa mi nanna-niɛ gbula.» ");
INSERT INTO cmeNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesu wuɔ cira: «Piɛr, mi waŋ ninsoŋo‑i baa-ni: Isuɔŋ daaku-na, kɔhɔldĩɛlãŋo siɛ hi bu, ŋ ka cĩina-miɛ da i siɛi wuɔ naŋ sa suɔ-mi.» ");
INSERT INTO cmeNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Piɛr wuɔ dii u naŋga‑i dãamu-na wuɔ da ba fiɛ'a ba ka ko-ba ba hãi‑i-na, fuɔ cɛraa u cira u sa suɔ-yo. Hãalãbiemba namba‑i hiere baa bi waŋ maaduɔma. ");
INSERT INTO cmeNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yesubaa-ba kaa hi terieŋgu naŋgu‑i ba bĩ-ku Getisemane. Yesu wuɔ gbɛ̃ u *hãalãbiemba‑i wuɔ: «Tĩɛnaanaŋ bande aa mi kã dii daalɛi ka cãrã Diiloŋo‑i aa bir jo.» ");
INSERT INTO cmeNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Aa naa kã baa Piɛr baa Sebede bɛpuɔmba‑i ba hãi‑i-na. Uŋ kãa terieŋgu-na, u huɔŋga doŋ ta ka guɔla aa korma tiraa ta ma da-yo. ");
INSERT INTO cmeNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Wuɔ gbɛ̃-ba wuɔ: «Mi huɔŋga si dii huɔŋga, tĩɛnaanaŋ bande‑i-na na cie-mi; baa na duɔfũŋ.» ");
INSERT INTO cmeNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Aa kã yaaŋ-na cɛllɛ ka dũuna nisĩŋ u yuŋgu‑i hĩɛma-na aa cira: «Baba, da ŋ'a ŋ ka gbãa, hiel-muɔ yaahuolo daayo‑na. Ŋga baa cira ŋ fer-muɔ, ce-ma niŋ taaraŋ ma ce dumaa.» ");
INSERT INTO cmeNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ku huoŋgu-na, wuɔ bir jo u hãalãbiemba siɛi baaŋ daaba wulaa, a jo ji da ba kuraa duɔfũŋ. Wuɔ pĩŋ-ba aa naa tuɔ piiye baa Piɛr wuɔ: «Halle na saa gbãa tĩɛna da huɔŋgu cɛllɛ baa-mi! ");
INSERT INTO cmeNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Baa na duɔfũŋ, taa na cãrã Diiloŋo‑i wɛima baa gbãa tãal-na dii-na kuubabalaaŋgu cemma-na. Ãnfafamma cemmaŋ-maama dii nelbiloŋo huɔŋga-na, ŋga ku fɔ̃ŋgũɔ yaa si dii-yuɔ.» ");
INSERT INTO cmeNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Uŋ waaŋ mafamma‑i, wuɔ bir ta ka cãrã Diiloŋo‑i. Uŋ waaŋ mamaŋ gboluoŋgu faŋgu-na, u ciɛra: «Baba, da kuɔ yaahuolo daayo saaya u da-mi, wɛima sĩ, ma ce niŋ taaraŋ ma ce dumaa.» ");
INSERT INTO cmeNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Aa naa bir jo u hãalãbiemba wulaa jo ji da duɔfũmmu kuure-bɛi. ");
INSERT INTO cmeNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Wuɔ bir ta ka tiraa cãrã Diiloŋo‑i baa ãndaduɔŋ daaku yaa‑i. Ku ce i siɛi. ");
INSERT INTO cmeNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Uŋ juɔ kufaŋgu‑i, wuɔ jo ji gbɛ̃ u hãalãbiemba‑i wuɔ: «Na saa ye dumaa duɔfũmmu-na wɛi? Ku piyaa. Ba ka hã ãmbabalmanciraamba‑i baa *Moloŋ-Biɛŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Siireŋ i ta! Umaŋ ka hã-ba baa-mi u'i juɔŋ daayo, u saa maa!» ");
INSERT INTO cmeNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Nelma saa tĩ Yesu nuŋgu-na; ba'a ba ne da baŋ bĩŋ umaŋ *Yuda‑i u *hãalãbieŋ cĩncieluo ba hãi baamba-na, u juɔ ji tuɔ yiɛra baa nelpũŋgu naŋgu u huoŋgu-na. Banamba waa baa jigãmmu, banamba bɔ̃ɛŋa. *Diilojigãntaamba yuntaamba‑i baa nelle bĩncuɔmba yaa puɔraa-ba. ");
INSERT INTO cmeNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","A ne da baŋ'a ba jo, Yuda naa gboya-bɛi wuɔ: «Da mi ka pũrã umaŋ da mi jaal-o, u yaa‑i; na bel-o.» ");
INSERT INTO cmeNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Baŋ kãa ka hi, Yuda wuɔ pãŋ piɛ Yesu caaŋ-nu aa cira: «Hãalãtie, jaaluŋgu yaa‑i!» Aa kã ka pũrã-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesu wuɔ cira: «Mi jĩɛ, niŋ juɔ mamaŋ nuɔ‑i ce-ma.» Bamaŋ juɔ baa Yuda‑i baa pãŋ piɛ bel Yesu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Bamaŋ waa baa Yesu‑i, unaŋ wuɔ fa u jigãŋga‑i hiel-ka a jafũŋ *Diilojigãntaamba yuntieŋo maacembiloŋo tũŋgu‑i a kar-ku. ");
INSERT INTO cmeNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yesu wuɔ cira: «Dii ŋ jigãŋga‑i ka foguoŋgu-na. Ŋ saa da, umaŋ duɔ tuɔ ce bɛrru‑i baa jigãŋga, jigãŋga'i ji wuyaaŋ-yoŋ. ");
INSERT INTO cmeNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ŋ daa niɛ sĩ mi siɛ gbãa muo mi natiɛŋa mi To‑i-na wɛi? Aa da ŋ bi da mi muyaa mi natiɛŋa yuɔ, hoi huɔŋgu‑i baa huɔŋgu‑i, uŋ ka saaŋ *dɔrpɔpuɔrbiemba maŋ ba ji kãyã-miɛ, ba ka cor pũnni cĩncieluo baa ni hãi. ");
INSERT INTO cmeNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ŋga da ba jo, mamaŋ nyɛgãaŋ Diiloŋ-nelma-na ma ka ce niɛ aa gbãa ce? Diiloŋ wuɔ ma ce dɛ'i nuɔ‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Aa naa waŋ baa nuɔmba‑i wuɔ: «Na hilaa baa jigãmmu baa bɔ̃ɛŋa da na ji bel-mi ŋaa cuoyuo muɔ. Yinni maŋ joŋ mi waŋ Diiloŋ-nelma‑i baa nuɔmba‑i *Diilodubuɔ‑i-na, bige‑i ciɛ na saa bel-mi terieŋgu-na? ");
INSERT INTO cmeNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ŋga *Diilopɔpuɔrbiembaŋ waaŋ mamaŋ Diiloŋ-nelma-na, ma saaya ma ce, ku'i ciɛ.» Hãalãbiemba gbar hiere aa nanna-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Baŋ bilaa Yesu‑i, baa kã baa-yo Kayifu terieŋ-nu. U yaa waa *Diilojigãntaamba yuntieŋo‑i. *Ãnjĩnamma pigãataamba‑i baa nelle bĩncuɔmba waa tigiiŋ kusuɔŋ-nu'i. ");
INSERT INTO cmeNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Baŋ kãŋ baa Yesu‑i, Piɛr wuɔ yaŋ ba maa aa suɔ cu ba huoŋ-nu. Baŋ kaa hi Diilojigãntaamba yuntieŋo cĩiŋgu‑i, wuɔ suur tĩɛna baa maacembiemba‑i duɔ ne kuŋ ka cor dumaa. ");
INSERT INTO cmeNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Diilojigãntaamba yuntaamba‑i a naara *nellentaamba‑i, baa ta ba taara ãntãalãmma da ba haa Yesu‑i-na da ba gbãa ko-yo, ");
INSERT INTO cmeNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","ŋga ma saa dɔl-ba. Nuɔmba bɔi juɔ ji kar coima haa-yuɔ. Ku huoŋgu-na, banamba sire ba hãi ");
INSERT INTO cmeNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ta ba piiye wuɔ: «U ciɛra wuɔ fuɔ gbãa muonu *Diilodubuɔ‑i aa ma-yo yinni siɛi.» ");
INSERT INTO cmeNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Diilojigãntaamba yuntieŋ wuɔ sire yiɛra aa naa cira: «Naacolŋ nuɔ, baŋ cãl-niŋ naŋ'a niɛ?» ");
INSERT INTO cmeNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Yesu saa seŋ sũnuŋgu yuɔ. Diilojigãntaamba yuntieŋ wuɔ cira: «Diiloŋ uŋ pãa nuŋgu‑i wuɔ u ka saaŋ *Koŋkortieŋo maŋ, u yaa nuɔŋo‑i wɛi? Nuɔnɛi Diiloŋ-Biɛŋ nuɔŋo‑i wɛi? Da kuɔ nuɔnɛi, hiel ŋ niele‑i Cicɛ̃lmantieŋo-na aa ŋ siɛ-ma i ne.» ");
INSERT INTO cmeNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesu wuɔ cira: «Muɔmɛi. Aa mi gbar-ma baa-na: A doŋ fiɛfiɛ daayo-na, na ka da *Moloŋ-Biɛŋo tĩɛnaana Itieŋo caaŋgu-na, na ka da u hilaa dɔrɔ‑i-na tuɔ jo baa duherru.» ");
INSERT INTO cmeNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Terieŋgu faŋgu-na, Diilojigãntaamba yuntieŋo huɔŋ kaa pãŋ guɔla. Wuɔ pãŋ fa fuɔ fɛrɛŋ joŋgorbaa-ba‑i taalnu-bɛi aa naa cira: «U tuoraaya Diiloŋo‑i! Ii si dii diɛ ka tiraa yuu moloŋo; ma ciɛ miɛ fɛrɛ‑i i yufelleŋ!» ");
INSERT INTO cmeNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Aa naa yuu nuɔmba‑i wuɔ: «Uŋ tuoraaya Diiloŋo‑i, namaa na'a niɛ?» Nuɔŋ baa cira: «U cãlãa, u saaya komma.» ");
INSERT INTO cmeNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Aa naa ta ba tu taalni u yaaŋga-na aa ta ba dudul-o. Banamba ta ba caa u tũnni‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Da ba muo-yo, ba cira: «Da kuɔ Diiloŋ uŋ saaŋ *Koŋkortieŋo maŋ u yaa nuɔŋo‑i, suɔ umaŋ muyaa-ni i ne!» ");
INSERT INTO cmeNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Baŋ taa ba muo Yesu‑i huɔŋgu-na, Piɛr waa tĩɛna dumɛlleŋ-huɔŋga-na. Maacembiloŋo naŋo piɛ kã u wulaa ka cira: «Ma sĩ nuɔ ŋ bi waa baa Galiletaaŋ Yesu daayo‑i kɛ?» ");
INSERT INTO cmeNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Piɛr wuɔ hel-kuɔ nuɔmba yaaŋga-na hiere. U birii yuu ciɛŋo‑i wuɔ: «Ŋ taara ŋ waŋ wuɔ niɛ?» ");
INSERT INTO cmeNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Aa naa sire ta tuɔ kã fondumɛlle-na. Ciɛŋo naŋo tiraa da-yo aa tuɔ piiye baa bamaŋ terieŋgu-na wuɔ: «Naacolŋ daa u waa baa Nasarɛtitaaŋ Yesu‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Piɛr wuɔ cira: «Muɔ baa Diiloŋo, mi sa suɔ naacolŋ daayo‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Kuɔ ku ce cɛllɛ, bamaŋ waa, baa piɛ Piɛr caaŋ-nu ka cira: «Coima saa fa, unaŋo'i nuɔŋo‑i. Da ŋ ta ŋ piiye, ba pãŋ suɔ niŋ hilaa kusuɔŋ-nu.» ");
INSERT INTO cmeNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Piɛr wuɔ pãŋ cira: «Muɔ baa Diiloŋo, mi sa suɔ naacolŋ daayo‑i! Aa da kuɔ mi kar coima, Diilo baa yaŋ-mi!» Uŋ taa u waŋ mafamma‑i huɔŋgu maŋ nuɔ‑i, kɔhɔldĩɛlãŋo doŋ tuɔ bu. ");
INSERT INTO cmeNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Yesuŋ ŋa naa waŋ mamaŋ baa-yo wuɔ: «Kɔhɔldĩɛlãŋo siɛ hi bu, ŋ ka cĩina-miɛ da i siɛi wuɔ naŋ sa suɔ-mi», maa pãŋ tĩɛnu-yuɔ. Wuɔ hel gbuu pãŋ tuɔ kaal. ");
INSERT INTO cmeNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ku cuo kaala‑i-na kãŋkãŋkãŋ, *Diilojigãntaamba yuntaamba‑i hiere baa nelle bĩncuɔmba waŋ-ma aa yiɛra-mɛi wuɔ ba ko Yesu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Aa bel-o vaa-yo kã baa-yo ka hã *Pilati‑i baa-yo, u yaa waa *Yude yuŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","*Yudaŋ juɔ da ba'a ba ko Yesu‑i, a ne da u yaa suoraa-yo baa-ba, kuɔ ce-yo bĩŋkũŋgu. Baŋ hãa-yo komorre baa cĩncieluo maŋ, wuɔ biɛ-ya bir kã baa-ya ba wulaa ");
INSERT INTO cmeNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ka cira: «Mi saa ce maacenfafamma; mi bilaa diiloŋo‑i hã-na nɛliɛŋo maŋ saa ce bĩŋkũŋgu na da na ko-yo.» Baa bir gbɛ̃-yo wuɔ: «Maasũmpĩɛ! Ma sũlma dii ŋaa nuɔnɛi.» ");
INSERT INTO cmeNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yuda wuɔ nanna gbeiŋa‑i *Diilodubuɔ‑i-na aa ta ka nuŋ u fɛrɛ. ");
INSERT INTO cmeNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","*Diilojigãntaamba yuntaamba biɛra gbeiŋa‑i aa naa cira: «Gbeiŋ daaya‑i tãmmaŋ-gbeiŋa, a saa baa miɛ hũmelle‑i, i siɛ gbãa dii-ya Diiloŋ-waaŋa-na.» ");
INSERT INTO cmeNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Baa saa-ma, aa kã ka sãa bitomarãŋo suoŋgu‑i baa-ya, wuɔ ba ce terieŋgu‑i ta ba fuure niraamba kuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ku'i ciɛ na da a ji hi baa nyuŋgo, ba bĩ suoŋgu faŋgu‑i «tãmmaŋ-suoŋgu.» ");
INSERT INTO cmeNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","*Diiloŋ uŋ puɔraa *Seremi waŋ mamaŋ, ma'i saa ce daama‑i wɛi? Seremi waaŋ-ma wuɔ: «Ba biyaa komorre baa cĩncieluo daayo‑i. *Isirahɛl-baamba naa kar u sullu‑i dumɛi. ");
INSERT INTO cmeNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ba biyaa-ya a dii-ya bitomarãŋo suoŋgu-na ŋaa Itieŋ uŋ ŋa na'a mi ce-ma dumaa.» ");
INSERT INTO cmeNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Baŋ kãa baa Yesu‑i *Pilati wulaa, wuɔ yuu-yo wuɔ: «*Yuifu ba nellentieŋo yaa nuɔŋo‑i wɛi?» Yesu wuɔ cira: «Muɔmɛi.» ");
INSERT INTO cmeNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","*Diilojigãntaamba yuntaamba‑i baa nelle bĩncuɔmba doŋ ta ba cãl-o. Wuɔ fĩinaŋ u sa waŋ wɛima. ");
INSERT INTO cmeNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pilati wuɔ cira: «Baŋ cãl-niŋ ŋ sa nu wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Yesu saa ji seŋ sũnuŋgu yuɔ. Kuɔ bir yaŋ aa cu u huɔŋga‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Belle belle, Yuifu ba *kɔrsĩnni tĩmmaŋ-ponsaaŋ da kuɔ hi, Pilati ce ba pigãaŋ kasobiloŋo diei u nanna-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","A ne da naacolŋo naŋo waa huɔŋgu faŋgu-na kaso‑i-na, u yerre naa silaa du cor. Ba taa ba bĩ-yo Yesu-Barabasi. ");
INSERT INTO cmeNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Pilati wuɔ yuu nuɔmba‑i wuɔ: «Yesu-Barabasi‑i, baa Yesu maŋ baŋ bĩŋ-yo *Kirsa‑i, na taara mi nanna hai?» ");
INSERT INTO cmeNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilati wuɔ suyaa wuɔ nenemuŋgu'i ciɛ ba bel Yesu‑i ka hã-yo baa-yo. ");
INSERT INTO cmeNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Uŋ waa tuɔ gɛr ãndaaŋ daaku‑i, u ciɛŋo puɔr ba ka tũnu-yuɔ wuɔ u baa dii u nuŋgu Yesu ãndaaŋgu-na, u saa ce bĩŋkũŋgu, kɛrɛ isuɔŋgu maŋ curaa u mulãaŋ fuɔ dãnsãaŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Diilojigãntaamba yuntaamba‑i baa nelle bĩncuɔŋ baa gbo nuɔmba ta ba piiye wuɔ ba taara ba nanna Barabasi yaa‑i aa ko Yesu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pilati wuɔ tiraa yuu-ba wuɔ: «Na taara mi nanna hai ba hãi‑i-na?» Baa cira: «I taara ŋ nanna Barabasi yaa‑i!» ");
INSERT INTO cmeNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilati wuɔ cira: «Aa Yesu maŋ baŋ bĩŋ-yoŋ *Kirsa‑i mi ce ufaŋo‑i niɛ?» Baa cira: «U saaya u gbu *daaŋ-nu!» ");
INSERT INTO cmeNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilati wuɔ cira: «U guɔlaaya bige‑i aa na'a mi gbu-yo?» Baa migãaŋ dii kunaŋgu naara wuɔ: «U saaya u gbu daaŋ-nu! U saaya u gbu daaŋ-nu!» ");
INSERT INTO cmeNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilatiŋ juɔ da ijieni maara ni kã, wuɔ ne da fuɔ jãŋ vakuloŋ-juuru. Wuɔ biɛ hũmma a saar u nammu‑i nuɔmba yaaŋga-na aa naa cira: «Da na ko naacolŋ daayo‑i, na da-na-diei, mi nuŋgu sĩ.» ");
INSERT INTO cmeNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Baa siɛ hiere wuɔ: «I hũyãa-ma! Diɛ ko-yo, miɛ yuŋ-maama‑i baa i bisãlmba!» ");
INSERT INTO cmeNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pilati wuɔ nanna Barabasi‑i aa naa ce ba muo Yesu‑i da dɛi aa hã-ba baa-yo wuɔ ba ka gbu-yo daaŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","*Pilatiŋ hãa-ba Yesu‑i, u sorosibaa-ba hũu-yo suur baa-yo cĩiŋ-huɔŋga-na aa bĩ ba nabaamba‑i hiere ba jo. ");
INSERT INTO cmeNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Baŋ ciɛ mafamma‑i, baa hiel u joŋgorbaa-ba‑i aa dii joŋgorbuɔ naŋo hã-yo. Joŋgorbuɔ faŋo waa dãa-wuoŋo. ");
INSERT INTO cmeNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Aa ce huɔni sũ nyantuoluo a dii u yuŋgu-na aa hã-yo gboruoŋgu u nadieŋga-na u bella. Baŋ ciɛ mafamma‑i, baa ta ba dũuna u yaaŋga-na ba jaal-o. Ba taa ba nyɛ-yo'i dumaaŋo-na. Umaŋ duɔ dũuna wuɔ: «*Yuifu ba nellentie, mi jaalaa-ni!» ");
INSERT INTO cmeNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ba taa ba tu taalni yuɔ aa hũu gboruoŋgu‑i u naŋga-na ta ba muo-yo baa-ku u yuŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Baŋ gbuu ji nyɛ-yo ye huɔŋgu-na, baa hiel joŋgorbuɔ‑i aa bir dii fuɔ fɛrɛŋ bĩmbĩnni yaa hã-yo aa kã baa-yo da ba ka gbu-yo *daaŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Baŋ ŋ'a ba hel nelleŋ-huɔŋga-na, baa suu baa Sirɛniyiɛŋo naŋo, ba bĩ-yo Simɔ. Baa guor u tũu daaŋgu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ba kaa hi terieŋgu maŋ baŋ bĩŋ-kuŋ «Gɔlgota‑i» ku yuŋgu yaa wuɔ yukoluoŋ-terieŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Baa guɔl gbegege kũŋgu naŋgu baa duvɛ̃ŋo a hã Yesu‑i wuɔ u nyɔŋ. Yesu wuɔ dãa ne aa naa cira u siɛ nyɔŋ. ");
INSERT INTO cmeNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Baŋ juɔ gbu Yesu‑i daaŋgu-na tĩ, baa ful tieŋa a cal u joŋgorbaa-ba‑i ");
INSERT INTO cmeNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","aa naa tĩɛna ta ba niya-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Baŋ gbuu-yo yuŋgu maŋ nuɔ‑i, baa nyɛgɛ̃ŋ-ku jĩna u yudɔrɔ‑i-na wuɔ: «Umaŋ daayo‑i Yesu, Yuifu ba nellentieŋo yaa‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Baa bi gbuu cuobaa-ba hãi baa-yo; unaŋo‑i u nadieŋga-na unaŋo‑i u nanyuɔŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Hũncortaamba ta ba misĩrrã ba yunni‑i aa ta ba tuora-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Ba taa ba piiye wuɔ: «Nuɔni maŋ ciɛra naŋ gbãa muonu *Diilodubuɔ‑i aa ma-yo yinni siɛi hɔlma-na, kor ŋ fɛrɛ i ne! Da kuɔ Diiloŋ-Biɛŋo yaa nuɔŋo‑i, hiire daaŋgu-na i ne!» ");
INSERT INTO cmeNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Halle *Diilojigãntaamba yuntaamba‑i baa *ãnjĩnamma pigãataamba‑i a naara nelle bĩncuɔmba taa ba bi nyɛ-yo aa ta ba piiye wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«U kuraa banamba‑i, ŋga u yaa daayo u siɛ gbãa kor u fɛrɛ! Da kuɔ u yaa‑i *Isirahɛl-baamba nellentieŋo‑i u hiire fiɛfiɛ daaŋgu-na i ne ku yaa i ka hũu-ma. ");
INSERT INTO cmeNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ma sĩ u haa u naŋga‑i Diiloŋo'i nuɔ‑i aa cira fuɔ Diiloŋ-Biɛŋo kɛ? Da kuɔ Diiloŋo dɔl‑o, u kor-o i ne!» ");
INSERT INTO cmeNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Baŋ ŋa naŋ gbuu cuobaa-ba maŋ baa-yo, baa bi kã ba ta ba tuora-yuɔ hiere. ");
INSERT INTO cmeNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Bãaŋguŋ juɔ hi yuhuɔŋga‑i huɔŋgu maŋ nuɔ‑i, ba'a ba ne da terieŋgu cuure hiere. Ku tĩyãa dumɛi fuɔ bãaŋgu ji tɛrɛŋ. ");
INSERT INTO cmeNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Bãaŋguŋ juɔ tɛrɛŋ, Yesu wuɔ kaasĩŋ da gbagaga wuɔ: «Eli, Eli, lama sabatani?» Ku yuŋgu yaa wuɔ: Diilo, Diilo, bige‑i ciɛ ŋ nanna-miɛ? ");
INSERT INTO cmeNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Bamaŋ waa, banamba ta ba piiye wuɔ: «U bĩ *Eli!» ");
INSERT INTO cmeNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Unaŋo pãŋ gbar ka biɛ kãnsaarma namma a nyiɛ-ma niisaarniŋ aa ful-ma gboruoŋ-nu a kã baa-ma Yesu nuŋgu-na wuɔ u mɔsũnya. ");
INSERT INTO cmeNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Banamba bir yaŋ aa gbɛ̃-yo wuɔ: «Yaŋ i ne sĩ Eli ka jo ji kor-o!» ");
INSERT INTO cmeNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesu wuɔ tiraa kaasĩŋ da gbagaga aa bi pãŋ hũu u fɛrɛ. ");
INSERT INTO cmeNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Hɔduɔŋgu faŋgu-na, kompaŋga maŋ naa karnu *Diilodubuɔ‑i kaa pãŋ taalnu sɔmma hãi; a doŋ dɔrɔ‑i-na ji hel cicaara‑i-na. Hĩɛŋ maa sagalla; tãŋ niɛ wuɔra muo hiere, ");
INSERT INTO cmeNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","cĩncuɔŋ aa puur. Bamaŋ waa Diiloŋ-baamba‑i aa ku, ba fɔ̃ŋgũɔ baa sire. ");
INSERT INTO cmeNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Yesuŋ juɔ sire, baa hel ba cĩncuɔŋa-na a suur *Yerusalɛmu‑i-na. Baŋ suurii, nuɔmba bɔi daa-ba. ");
INSERT INTO cmeNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Sorosibaa-ba maŋ taa ba niya Yesu‑i baa ba yuntieŋo‑i, baŋ juɔ da hĩɛma sagalaaya a naara mamaŋ taa ma ce hiere, korma gbuu bel-ba. Baa ta ba piiye wuɔ: «Naacolŋ daayo waa Diiloŋ-Biɛŋo kelkel!» ");
INSERT INTO cmeNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Caamba bɔi waa yiɛra da yargaa ta ba fara ba ne. Ba yaa naa nyaanu Yesu‑i a hel *Galile‑i-na ji ta ba kãyã-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Maari maŋ taa u hel Magidala‑i-na u waa baa-ba, baa u duoŋo‑i Sake ba nyu‑i a naara Sebede ciɛŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Bãaŋguŋ juɔ hir huɔŋgu maŋ nuɔ‑i, wɛiŋo naŋo jo. Ba taa ba bĩ-yo Yosɛfu; u taa u hel Arimate. Fuɔ bi waa Yesu huoŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Uŋ juɔ, wuɔ kã *Pilati wulaa ka cãrã kuloŋo‑i. Pilati wuɔ hã-yo baa-yo. ");
INSERT INTO cmeNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yosɛfu wuɔ kã ka har-o a fĩnya-yuɔ baa kompafɛlɛŋga ");
INSERT INTO cmeNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","aa kã ka fuure-yuɔ fuɔ fɛrɛŋ cĩncorreŋ. Wuɔ ciɛ ba hĩŋ-de fɛlɛmma; di waa tãmpɛ̃lleŋ. Uŋ fuuriiye-yuɔ, wuɔ bũmal tãmpɛ̃kãŋkarre nande‑i a suuye di nuŋgu‑i aa ta. ");
INSERT INTO cmeNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maari maŋ ta u hel Magidala‑i-na wuɔ tĩɛna cĩncorre yaaŋga-na baa u duoŋo‑i hiere. ");
INSERT INTO cmeNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Yesuŋ kuu yiiŋgu maŋ nuɔ‑i, *Yuifubaa-ba taa ba tigiiŋ ba *yitĩɛnaŋgu‑i yiiŋgu faŋgu'i nuɔ‑i. Ku cuo kaala‑i-na, *Diilojigãntaamba yuntaamba kũɔl ba-naa kã Pilati wulaa baa *Farisĩɛbaa-ba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Baŋ kãa ka hi, baa cira: «Yuntie, coikartieŋ daayo naa cira wuɔ da ba ko-yo, u ka ce yinni hãi yoŋ hĩɛma-na aa siɛliŋ-yiiŋgu‑i u sire hel jo. ");
INSERT INTO cmeNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ku'i ciɛ i tiɛ jo ŋ wulaa yiɛ ŋ hã-ye nuɔmba ba ka ta ba niya u cĩncorre‑i yiŋ daani‑i ni siɛi‑i-na, ni ma'i sĩ u *hãalãbiemba gbãa kã ka hiel-o ka fuo-yo aa tãal nuɔmba‑i wuɔ u siire. Da ba ce mafamma‑i ma ka balaŋ yaŋ kuloŋ uŋ ciɛ mamaŋ.» ");
INSERT INTO cmeNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilati wuɔ cira: «Sorosibaa-ba yaa‑i. Naŋ taaraŋ ba ka niya-diɛ dumaa, kãaŋ baa-ba ba ka niya-diɛ.» ");
INSERT INTO cmeNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Baa ta ku yaa nuɔ‑i baa sorosibaa-ba‑i kã cĩncorre terieŋgu-na. Baŋ kãa ka hi, baŋ ŋa naa bũmal tãmpɛ̃lle maŋ suuye cĩncorre nuŋgu‑i, baa tiɛla-diɛ aa ce sorosibaa-ba tĩɛna ta ba niya-diɛ. ");
INSERT INTO cmeNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","*Yitĩɛnaŋguŋ juɔ cor, ku cuo kaala waa jumaansi. Maari maŋ taa u hel Magidala‑i-na, baa u duoŋo‑i, baa naar sire ta ba kã da ba ka ne cĩncorre‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ba'a ba ne da hĩɛma sagalaaya hɔduɔŋgu baa fɔ̃ŋgũɔ! Itieŋo *dɔrpɔpuɔrbiloŋo naŋo hiire jo ji bũmal tãmpɛ̃lle‑i halaŋ-de aa bel nyugũŋ tĩɛna di dɔrɔ. ");
INSERT INTO cmeNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","U taa u caa ŋaa diiloŋ duɔ nyiɛsĩŋ uŋ caa dumaa, aa u joŋgorbaa-ba pusũŋ ŋaa cɛikoiŋo. ");
INSERT INTO cmeNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Korma gbuu da sorosibaa-ba maŋ taa ba niya cĩncorre‑i fuɔ ba kũɔma ta ma nyɛŋ; baa galla ŋaa bikuomba. ");
INSERT INTO cmeNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Dɔrpɔpuɔrbiloŋ wuɔ tuɔ piiye baa caaŋ daaba‑i wuɔ: «Baa na yaŋ korma da-na. Mi suyaa miɛ baŋ gbuu Yesu maŋ *daaŋgu-na ko-yo, na taara u yaa‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Uu si dii bande‑i-na, u siire hel ŋaa uŋ ŋa naa waŋ-ma baa-na dumaa. Juɔŋ na ji da, ba ŋa naa galla-yuɔ terieŋgu maŋ nuɔ‑i ku yaa daaku. ");
INSERT INTO cmeNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Biriiŋ na kũŋ donduo na ka tũnu u *hãalãbiemba‑i wuɔ u siire hel kuomba hɔlma-na. U taa duɔ ka cie-na dii *Galile, na ka da-yo kusuɔŋ-nu'i. Ma yaa waa mi da mi waŋ-ma baa-na.» ");
INSERT INTO cmeNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Caaŋ daaba saa tiraa yiɛra, baa pãŋ gũunu ta ba gbar ba kũŋ da ba ka waŋ baŋ kaa da mamaŋ baa hãalãbiemba‑i. Korma'i daama, hɔfɛ̃lle‑i daade. ");
INSERT INTO cmeNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ba'a ba ne da hai moloŋo‑i juɔŋ daayo‑i ba yaaŋga-na? Yesu fuɔ fɛrɛ yaa‑i. Wuɔ cira: «Mi jaalaa-na!» Baa piɛ kã ka dũuna u yaaŋga-na aa pũrã u gbeini‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Wuɔ gbɛ̃-ba wuɔ: «Baa na yaŋ korma da-na. Kãaŋ na ka waŋ baa mi baamba‑i wuɔ ba ka da-mi Galile‑i-na.» ");
INSERT INTO cmeNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Caaŋ daabaŋ curaa ta ba kũŋ, sorosibaa-ba maŋ taa ba niya cĩncorre‑i, banamba sire kã nelleŋ-huɔŋga-na ka tũnu *Diilojigãntaamba yuntaamba‑i baa mamaŋ curaa hiere. ");
INSERT INTO cmeNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Diilojigãntaamba yuntaamba tigiiŋ ba-naa baa nelle bĩncuɔmba‑i a waŋ ma saa, aa naa hã sorosibaa-ba‑i gbeibuɔ ");
INSERT INTO cmeNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","aa gbɛ̃-ba wuɔ: «Wuɔraayaŋ na waŋ baa nuɔmba‑i, wuɔ namaa gaala ta na duɔfũŋ isuɔŋgu-na, u hãalãbiemba jo ji hiel-o ta baa-yo na saa suɔ ku huɔŋgu.» ");
INSERT INTO cmeNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Aa naa cira: «*Pilati duɔ fiɛ nu-ma, i ka suɔ iŋ ka waŋ mamaŋ baa-yo u baa gãŋ baa-na.» ");
INSERT INTO cmeNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Sorosibaa-ba hũu gbeiŋa‑i dii ba jufanniŋ aa bi wuɔra ce baŋ'a ba ce kumaŋ. A ji hi baa nyuŋgo, da ŋ cor terieŋgu terieŋgu, nelma famma yaa dii *Yuifubaa-ba nunni-na ba ta ba waŋ-ma. ");
INSERT INTO cmeNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Yibieŋa faŋa-na, *hãalãbieŋ cĩncieluo u diei maŋ tĩyãa, baa sire kã Yesuŋ ŋa na'a ba ta ba jã ba-naa tãnuŋgu maŋ nuɔ‑i dii *Galile‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Baŋ ka'a ba ne da-yo, baa dũuna hiere. Banaŋ hɔmmu saa hũu-ma. ");
INSERT INTO cmeNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesu wuɔ piɛ ba caaŋ-nu aa naa cira: «Diiloŋo hãa-mi dɔrfɔ̃ŋgũɔ‑i baa hĩɛmaŋ-wuoŋo‑i hiere. ");
INSERT INTO cmeNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Terieŋgu faŋgu-na, kãaŋ nilɛiŋa-na hiere na ka gbãŋ baa nuɔmba cu mi huoŋ-nu. Umaŋ duɔ hũu-ma, na *batiseŋ-yo Tuoŋo‑i baa u Biɛŋo‑i a naara u *Yalle yerre-na. ");
INSERT INTO cmeNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Miŋ ciɛra na ta na ce mamaŋ hiere, na bi hãalã-bɛi ma cemma‑i ba ta ba ce-ma. Niɛŋ, mi ka waa baa-na yinni maŋ joŋ a ji hi miwaaŋo tĩmma.»");
INSERT INTO cmeNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Yesu *Kirsa *Neldɔdɔlma duɔŋ bande yaa nuɔ‑i. U yaa Diiloŋ-Biɛŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ma duɔŋ ŋaa maŋ bi nyɛgãaŋ dumaa *Isayi sɛbɛ‑i-na wuɔ: «Diiloŋo ciɛra: ‹Mi ka puɔr mi pɔpuɔrbiloŋo ta ŋ yaaŋ-na ka cãa ŋ hũmelle‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","U ka kã ka tuɔ hohuola baa nuɔmba‑i *hĩɛkuraaŋgu-na wuɔ: «Migãaŋ Itieŋo hũmieŋa‑i. Cãaŋ-yaŋ na viinu-yɛi.»›» ");
INSERT INTO cmeNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Pɔpuɔrbiloŋo faŋo yaa juɔ jo Nsãa‑i, a ji kã ka waa hĩɛkuraaŋgu-na tuɔ piiye baa nuɔmba‑i wuɔ: «Naanaŋ na cilɔbabalaŋo‑i aa na jo na ji *batiseŋ, ku yaa Diiloŋo ka hur na ãmbabalma‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Yudetaamba‑i hiere ka hel baa Yerusalɛmutaamba‑i ba taa ba kã u wulaa ba kã ba waŋ ba cãlmuɔ‑i baa-yo aa u tuɔ batiseŋ-ba *Yurdɛ̃ nuoraaŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Nsãaŋ taa u dii joŋgoruo maŋ, baa sũɔ-yo baa nyɔgɔ̃mɛkuɔsĩnni, aa tuɔ pɛ̃yɛ̃ u nɛgɛlle‑i baa cãanuŋ-kpãŋkpaaŋgu. U taa u wuo dũŋgbɛrmba, baa sɔllu. ");
INSERT INTO cmeNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","U taa u piiye baa nuɔmba‑i wuɔ: «Molo ka jo mi huoŋgu-na. Kutieŋo fɔ̃ŋgũɔ jĩɛnya mɛi wuoŋo‑i, mɛi saa piɛra u natãaŋgu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Muɔmi batiseŋ-na baa hũmma yoŋ, ŋga fuɔ duɔ jo, u ka batiseŋ-na baa *Diiloŋ-Yalle.» ");
INSERT INTO cmeNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Nsãa uŋ waa *Yurdɛ̃‑i-na tuɔ *batiseŋ nuɔmba‑i, Yesu wuɔ hel Nasarɛti‑i-na, dii *Galile mara‑i-na a kã u wulaa u ka batiseŋ-yo. ");
INSERT INTO cmeNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Uŋ baatiseŋ aa u tuɔ hel hũmma-na, wuɔ u ne da dɔrɔ puurii aa *Diiloŋ-Yalle hel koŋhuruŋ temma jo ji diire-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Baa nu molo piiye dɔrɔ‑i-na wuɔ: «Mi Biɛŋo yaa nuɔŋo‑i, ŋ maama sa suɔ aa dɔlnu-miɛ; nuɔnɛi fĩɛŋ mi huɔŋga‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Diiloŋ-Yalle pãŋ ce Yesu ta kã *hĩɛkuraaŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Uŋ kãa, *Sitãni wuɔ ka tuɔ tãal-o duɔ guɔl u gbeini‑i. U ciɛ yinni komuɔŋa hãi bĩmbaamba hɔlma-na. *Dɔrpɔpuɔrbiemba taa ba kãyã-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Huɔŋgu naŋgu juɔ hi, baa bel Nsãa‑i dii-yo kaso. Yesu wuɔ sire kã *Galile‑i-na ka tuɔ waŋ *Neldɔdɔlma‑i baa nuɔmba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","U taa u piiye wuɔ: «Ku hii, *Diiloŋ-bãaŋgu piyaa. Naanaŋ na cilɔbabalaŋo‑i aa na siɛ Neldɔdɔlma‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yiiŋgu naŋgu-na, wuɔ ji bella Galile dalaŋga nuŋgu‑i tuɔ wuɔ u kã, a ka da gbosobaa-ba namba naŋ juɔŋo; nɛliɛŋo baa u hãaŋo. Ba bĩ mɔlŋo‑i Simɔ aa bĩ hãaŋo‑i Ãndere. ");
INSERT INTO cmeNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesu wuɔ gbɛ̃-ba wuɔ: «Juɔŋ i ta, mi ka ce-na nelbilieŋ-gbosobaa namaa.» ");
INSERT INTO cmeNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Baa bi pãŋ nanna ba jɔnaamba‑i aa cu u huoŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ba'a ba kã yaaŋga-na, a da naacolŋo naŋo‑i ba bĩ-yo Sebede, u tĩɛnaana baa u bɛpuɔmba hãi beŋo naŋo-na ta ba migãaŋ ba jɔnaamba. Ba bĩ bɛpolŋo‑i Sake, aa bĩ hãaŋo‑i Nsãa. ");
INSERT INTO cmeNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yesu wuɔ bĩ-ba. Baa yaŋ tuoŋo‑i beŋo-na baa maacembiemba waa, aa sire cu u huoŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ku huoŋgu-na, Yesubaa-ba ji kã Kafarnamu. *Yitĩɛnaŋguŋ juɔ hi, Yesu wuɔ kã *Diilonelhãalãdũŋgu-na ka tuɔ waŋ Diiloŋ-nelma‑i u pigãaŋ nuɔmba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","U taa u piiye baa bibɛsĩnni u yaŋ *ãnjĩnamma pigãataamba‑i; a ce dumaaŋo-na, u nelma taa ma suurnu nuɔmba‑i ma cor. ");
INSERT INTO cmeNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Naacolŋo naŋo waa ba hɔlma-na, *jĩna waa u yuŋgu-na. Wuɔ kaasĩŋ wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","«Nasarɛtitaaŋ Yesu, i ciɛ-ni niɛ? Ŋ juɔ da ŋ ji kɔsuɔŋ-ye wuɔ bige‑i ciɛ? Mi suɔ-ni; Diiloŋ-nolŋo yaa nuɔŋo‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesu wuɔ nuola-yuɔ wuɔ: «Suuye ŋ nuŋgu‑i aa ŋ cor hel naacolŋo-na.» ");
INSERT INTO cmeNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Jĩna wuɔ gbuu sagalla naacolŋo‑i aa naa kaasĩŋ da gbagaga aa suɔ hel-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Kuɔ ce nuɔmba‑i hiere gbɛrɛ, baa ta ba yuu ba-naa wuɔ: «Bige‑i dumandɛ‑i? Naacolŋ daayo hii dɛ! Ãnfɛlɛŋo‑i daayo‑i. Halle baa jĩnabaa-ba‑i hiere ba nu u nuŋgu‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Kuŋ ciɛ dumaaŋo-na, Yesu yer diɛ pãŋ gbuo *Galile‑i hiere. ");
INSERT INTO cmeNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ku huoŋgu-na, Yesu wuɔ hel *Diilonelhãalãdũŋgu-na, fuɔ baa Sake baa Nsãa, a kã Simɔ ba dumɛlleŋ. ");
INSERT INTO cmeNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simɔ cura saa waa hĩnni; u kũɔma naa gbuu huol da pãmpãmpãŋ, u galla. Ba himma‑i, baa tũnu Yesu‑i wuɔ ciɛŋ daayo si dii hĩnni. ");
INSERT INTO cmeNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yesu wuɔ kã ka bel u naŋ-na u sire; terduɔŋgu faŋgu-na, fafal muɔ pãŋ da-yuɔ. Wuɔ sire tuɔ ce ba nersĩnni‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Bãaŋguŋ juɔ suur huɔŋgu maŋ nuɔ‑i, nuɔmba kã baa jaamba‑i baa jĩna ba nuɔmba‑i hiere Yesu wulaa. ");
INSERT INTO cmeNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Nuɔmba‑i hiere nelle-na baa hel kã ka yu dumɛlle yaaŋga‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesu wuɔ sire jaamba bɔi ba jarma-na, aa bi donya *jĩnabaa bɔi hiel-ba nuɔmba-na. Jĩnabaa-ba taa ba suɔ Yesu‑i, a ce dumaaŋo-na u saa tuɔ yaŋ ba ta ba da ba piiye. ");
INSERT INTO cmeNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ku cuo kaala‑i-na, Yesu wuɔ naar sire cicãnjãale-na kã hĩɛŋ-nu ka tuɔ cãrã Diiloŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simɔ‑i baa u nabentaambaŋ juɔ sire naa-yo, baa hel ta ba taara-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Baŋ kaa da-yo, baa cira: «Itie, nuɔmba‑i hiere ba taara-niɛ.» ");
INSERT INTO cmeNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yesu gbɛ̃-ba wuɔ: «Yaaŋ i ta i halaŋ bande‑i-na mi bi ka waŋ Diiloŋ-nelma‑i nilɛiŋa maŋ dii kɔtɔnni-na; mi jommaŋ-yuŋgu yaa kufaŋgu‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ba taa ku'i nuɔ‑i a wuɔra gbuo *Galile *Diilonelhãalãdũnni‑i hiere u tuɔ waŋ Diiloŋ-nelma‑i aa tuɔ donya *jĩnabaa-ba‑i nuɔmba-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Yiiŋgu naŋgu-na, *wontorŋo naŋo kãa ka dũuna Yesu caaŋgu-na aa cira: «Itie, da ŋ ta ŋ taara mi jarma ta-miɛ, ku siɛ yar-ni.» ");
INSERT INTO cmeNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","U hujarre gbuu bel Yesu‑i. Wuɔ haa u naŋga‑i yuɔ aa naa cira: «Mi taara ŋ jarma ta-niɛ.» ");
INSERT INTO cmeNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Naacolŋo jarma pãŋ ta-yuɔ terduɔŋgu faŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yesu wuɔ hã-yo hũmelle‑i aa naa waŋ-ma kuola-mɛi baa-yo wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","«Baa tũnu nɛliɛŋo baa-ma dɛ! Yaŋ aa ŋ kã *Diilojigãntieŋo wulaa u ka ne-ni, aa ŋ pã niikonni maŋ dii pãmma ŋ hã-yo u migãaŋ ŋ yuŋ-maama‑i ŋaa *Moisiŋ nyɛgãaŋ-ma dumaa, ku yaa nuɔmba ka suɔ wuɔ ŋ jarma taa-niɛ.» ");
INSERT INTO cmeNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Naacolŋo taa ku yaa nuɔ‑i, u saa ka gbãa fĩinaŋ, wuɔ wuɔra waŋ-ma baa nuɔmba‑i hiere. A ce dumaaŋo-na, Yesu wuɔ kã ka tĩɛna u deŋ dii hĩɛŋ-nu u sa siɛ suur nilɛiŋa-na. Uŋ fiɛ ce mafamma‑i, nuɔmba ta ba hel terni-na hiere ba kã u wulaa. ");
INSERT INTO cmeNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Yesuŋ siire *wontorŋ daayo‑i, ku saa da yinni wuɔ bir kã Kafarnamu‑i-na. Nuɔmbaŋ juɔ nu-ma wuɔ u juɔ, ");
INSERT INTO cmeNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","baa kã ka suur yu uŋ waa dũŋgu maŋ nuɔ‑i ka hel baa gɔ̃ŋgũɔŋgu‑i hiere, halle gboluoŋ-munjĩnammu saa waa. Yesu wuɔ doŋ tuɔ waŋ Diiloŋ-nelma‑i baa-ba. ");
INSERT INTO cmeNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ba juɔ'a ba ne da nuɔmba naa tũyãa murgu naŋo‑i ta ba jo baa-yo Yesu wulaa. ");
INSERT INTO cmeNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Baŋ juɔ ji da nuɔmba yuu dũŋgu‑i dumaaŋo-na, ba saa da munsuurmu. Baa nyugũŋ dũŋgu dɔrɔ‑i-na, a ne Yesuŋ waa hɔlma maŋ nuɔ‑i aa kaasĩŋ dũŋgu‑i a dii jɛiŋo‑i baa u kuugallaŋgu‑i hiere. ");
INSERT INTO cmeNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesu wuɔ ne da ba haa ba naŋga‑i yuɔ cor. Wuɔ gbɛ̃ ba jɛiŋo‑i wuɔ: «Mi jĩɛ, ŋ ãmbabalma hurii hiere.» ");
INSERT INTO cmeNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","*Ãnjĩnamma pigãataamba namba waa tĩɛna terieŋgu-na. Ba nuɔ mafamma‑i ce niɛ? Baa doŋ ta ba jɔguɔŋ wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Bige‑i ciɛ naacolŋ daayo tuɔ tuora Diiloŋo‑i tuoraŋ daama temma‑i? Da ma hel Diiloŋo-na, hai gbãa hur u nanolŋ ãmbabalma?» ");
INSERT INTO cmeNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yesu wuɔ pãŋ suɔ ba huɔya-maama‑i, wuɔ cira: «Bige‑i ciɛ na ta na jɔguɔŋ nel daama temma‑i na hɔmmu-na? ");
INSERT INTO cmeNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","A hur u ãmbabalma‑i, baa a ce u sire biɛ u kuugallaŋgu‑i tuɔ wuɔ‑i, ma hãi‑i-na, namaa daa hama‑i ce fɛ̃u yaŋ? ");
INSERT INTO cmeNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ŋga mi ka sire naacolŋ daayo‑i ku yaa na ka suɔ wuɔ Diiloŋo hãa *Moloŋ-Biɛŋo‑i ku fɔ̃ŋgũɔ‑i u tuɔ hur nelbiliemba ãmbabalma‑i.» Aa naa gbɛ̃ murgu daayo‑i wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«Sire ŋ biɛ ŋ kuugallaŋgu‑i ŋ kũŋ, muɔmɛi waaŋ-ma dumaa.» ");
INSERT INTO cmeNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Naacolŋ wuɔ bi pãŋ sire nuɔmba yufelle-na a biɛ u kuugallaŋgu‑i ta tuɔ kũŋ. Kuɔ ce nuɔmba‑i hiere gbɛrɛ, baa ta ba gbɛliɛŋ Diiloŋo‑i aa ta ba piiye wuɔ: «Iŋ huɔŋ, i saa da nel daama temma dede.» ");
INSERT INTO cmeNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ku huoŋgu-na, Yesu wuɔ ji bir kã *Galile dalaŋga-na. Nuɔmba kũɔl ba-naa kã u wulaa. Wuɔ tuɔ waŋ Diiloŋ-nelma‑i u pigãaŋ-ba. ");
INSERT INTO cmeNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Wuɔ u cor a da Alfe biɛŋo maŋ *nampohũutieŋo‑i, u tĩɛnaana u maacemmaŋ-dũŋgu-na. Ba taa ba bĩ-yo Levi. Yesu wuɔ cira: «Levi, sire i ta!» Levi wuɔ bi sire cu u huoŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Nuɔmba bɔi taa ba nyaanu Yesu‑i. Yiiŋgu naŋgu-na, wuɔ ji kã Levi wulaa ba ka ta ba wuo niiwuoni baa u *hãalãbiemba‑i. Nampohũutaamba waa bɔi a naara ãmbabalmanciraamba namba. ");
INSERT INTO cmeNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","*Ãnjĩnamma pigãataamba maŋ waa *Farisĩɛbaa-ba‑i, ba daa mafamma‑i ce niɛ? Baa ta ba piiye baa u *hãalãbiemba‑i wuɔ: «Bige‑i ciɛ na hãalãtieŋo tuɔ wuo niiwuoni‑i baa nelbabalaaŋ daaba temma‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu wuɔ nu baŋ piiyeŋ; wuɔ waŋ baa-ba wuɔ: «Da ŋ waa hĩnni, ŋ ka ce bige‑i pɛrruntieŋ terieŋ-nu? Mi saa jo nelfafaaŋ maa-na, ŋga mi juɔ nelbabalaaŋ maa-na.» ");
INSERT INTO cmeNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Yiiŋgu naŋgu-na, *Nsãa-Batisi *hãalãbiemba‑i baa *Farisĩɛbaa-ba naa dii sũŋgu. Baa jo ji yuu Yesu‑i wuɔ: «Bige‑i ciɛ Nsãa hãalãbiemba‑i baa Farisĩɛbaa-ba ta ba dii sũŋgu aa naŋ hãalãbiemba sa dii?» ");
INSERT INTO cmeNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu wuɔ cira: «Namaa daa dɔrbiɛŋo jɛ̃naamba gbãa dii sũŋgu a ne da dɔrbiɛŋo dii ba hɔlma-na wɛi? Na suyaa wuɔ ma siɛ gbãa ce! ");
INSERT INTO cmeNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ŋga yiiŋgu dii baa yiiŋgu, ba ka bel dɔrbiɛŋo‑i ta baa-yo. Kufaŋgu yiiŋgu'i nuɔ‑i baŋ ka dii sũŋgu‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Aa naa cira: «Ba sa taalnu kompafɛlɛŋga a nar joŋgorcɔlɔŋo. Da ŋ ce-ma, kompafɛlɛŋga ka taalnu joŋgorcɔlɔŋo‑i naara. ");
INSERT INTO cmeNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Aa ba sa bi dii duvɛ̃nfɛlɛŋo‑i cirkpɔcɔlɔŋ-na. Umaŋ duɔ ce-ma, cirkpuɔ ka muonu aa duvɛ̃ŋo tiraa kũnna. Duvɛ̃nfɛlɛŋo gbĩɛ baa cirkpɔfɛlaamba.» ");
INSERT INTO cmeNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","*Yitĩɛnaŋgu naŋgu-na, Yesubaa-ba taa ba karnu sonni nanni‑i ba cor. U *hãalãbiemba ta ba kar bile‑i ba wuo ba kã. ");
INSERT INTO cmeNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","*Farisĩɛbaa-ba ta ba piiye baa Yesu‑i wuɔ: «Bige‑i ciɛ ŋ hãalãbiemba ta ba ce kumaŋ saa saaya cemma yitĩɛnaŋgu-na?» ");
INSERT INTO cmeNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesu wuɔ gbɛ̃-ba wuɔ: «Nyulmu naŋ bilaa *Davidi‑i baa u nuɔmba‑i wuɔ ce kumaŋ, ma sĩ na kalaaŋ-ku Diiloŋ-nelma-na kɛ? ");
INSERT INTO cmeNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","U suurii Diiloŋ-dũŋgu-na Abiyataarŋ waa *Diilojigãntaamba yuntieŋo‑i huɔŋgu maŋ nuɔ‑i, a biɛ Diiloŋ-buruo‑i wuo-yo. A ne da a saa baa miɛ Diiloŋ-hũmelle‑i, bamaŋ si dii *Diilojigãntaamba, ba saa saaya ba wuo buruo faŋo‑i. Ŋga Davidi suurii biɛ-yo wuo, aa bi hã u nuɔmba wuo.» ");
INSERT INTO cmeNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Uŋ waaŋ mafamma‑i, wuɔ cira: «Ku saa ce ŋaa Diiloŋo hielaa nelbiloŋo‑i a hã yitĩɛnaŋgu dɛ! Ŋga u hielaa yitĩɛnaŋgu yaa hã nelbiloŋo. ");
INSERT INTO cmeNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","A ce dumaaŋo-na, *Moloŋ-Biɛŋo yaa yitĩɛnaŋgu tieŋo‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ku huoŋgu-na, Yesu wuɔ ji bir kã *Diilonelhãalãdũŋgu-na. Naacolŋo naŋo waa ba hɔlma-na u naŋga naa minaŋ. ");
INSERT INTO cmeNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","*Farisĩɛbaa-ba tĩɛna ta ba ne Yesu‑i wuɔ duɔ sire naacolŋ daayo‑i *yitĩɛnaŋgu-na ba ka da ãntãalãmma haa-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesu wuɔ gbɛ̃ naacolŋo‑i wuɔ: «Sire ŋ ji yiɛra nuɔmba yaaŋga-na.» Naacolŋ wuɔ sire kã ka yiɛra. ");
INSERT INTO cmeNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Yesu wuɔ yuu-ba wuɔ: «A saa baa miɛ Diiloŋ-hũmelle‑i, bige‑i faa cemma yitĩɛnaŋgu-na? Ãnfafamma'i faa cemma waa ãmbabalma? Da ŋ da molo yii duɔ ku, ku saaya ŋ kor kutieŋo‑i waa ku saaya ŋ yaŋ u ku?» Ba saa seŋ sũnuŋgu yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ba hɔdor diɛ du Yesu huɔŋga‑i, wuɔ wuɔra ne ba yammu‑i aa naa gbɛ̃ naacolŋo‑i wuɔ: «Fara ŋ naŋga‑i.» Naacolŋ wuɔ bi fara u naŋga‑i, kaa bir ka temma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Farisĩɛbaa-ba pãŋ hel ka ta ba da ba-naa baa *Erɔdi baamba‑i Yesu kommaŋ-kũŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ku huoŋgu-na, Yesu wuɔ ji ta baa u *hãalãbiemba‑i a kã Galile dalaŋga-na. Nuɔmba kũɔl ba-naa cu ba huoŋ-nu. Banamba taa ba hel *Galile, banamba *Yude, ");
INSERT INTO cmeNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","banamba *Yerusalɛmu, banamba Idume, banamba karnu *Yurdɛ̃‑i jo, banamba hel nilɛiŋa maŋ Tiir baa Sidɔ̃‑i a kɔtɔnni-na. Baa nuɔ Yesu maama‑i ku'i ciɛ ba kũɔl ba-naa ta ba jo u wulaa dumaaŋo-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Baŋ juɔ ji yu-yuɔ dumaaŋo-na, wuɔ waŋ baa u hãalãbiemba‑i wuɔ ba ne beŋo naŋo hã-yo, jaamba baa ji tisĩŋ-yo nanna. ");
INSERT INTO cmeNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","U taa u sire-bɛi bɔ̃mbɔ̃ŋ a ce ba ta ba nii-yuɔ hiere da ba yiɛya-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","*Jĩnabaa-baŋ waa bamaŋ nuɔ‑i, da ba da Yesu‑i ba kã ka dũuna u yaaŋga-na aa piiye da gbagaga wuɔ: «Diiloŋ-Biɛŋo yaa nuɔŋo‑i kelkel!» ");
INSERT INTO cmeNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Da ba waŋ mafamma‑i, Yesu sĩɛl u yufieŋa‑i a waŋ baa-ba wuɔ ba baa waŋ u sĩnni‑i baa molo. ");
INSERT INTO cmeNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ku huoŋgu-na, Yesu wuɔ kã ka nyugũŋ tãnuŋgu naŋgu-na aa naa bĩ u yufelleŋ-nuɔmba kã u wulaa. ");
INSERT INTO cmeNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Baŋ kãa, wuɔ hiel nuɔmba cĩncieluo ba hãi bɛi a ce-ba u *pɔpuɔrbiemba. U hielaa-ba ba da ba waa u caaŋ-nu u tuɔ puɔr-ba baa *Neldɔdɔlma‑i ");
INSERT INTO cmeNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","aa duɔ hã-ba himma ba ta ba donya *jĩnabaa-ba‑i nuɔmba-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Uŋ hielaa nuɔmba cĩncieluo ba hãi maŋ, ba yirɛiŋa yaa daaya: Simɔ, Yesu taa u bĩ Simɔ faŋo‑i Piɛr, ");
INSERT INTO cmeNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","baa Sebede bɛmba‑i ba hãi‑i-na Sake‑i a naara Nsãa‑i, Yesu taa u bĩ-ba wuɔ «Buwanɛrjɛsi», ku yuŋgu yaa diiloŋ-naarmaŋ-bɛmba, ");
INSERT INTO cmeNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","baa Ãndere, baa Filipu, baa Batelemi, baa Matie, baa Toma, baa Alfe biɛŋo‑i Sake, baa Tade, baa Simɔ maŋ taa u kuye u nelle maama‑i ");
INSERT INTO cmeNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","a naara *Yuda‑Isikaro maŋ juɔ hel Yesu huoŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ku huoŋgu-na, Yesu wuɔ ta kũŋ baa u *hãalãbiemba‑i. Baŋ kaa hi, nuɔmba tiraa kã ka yu-bɛi a ce halle ba sa da ba fɛrɛ wuo niiwuoni‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","U nyu‑i baa u hãmbaŋ nuɔ mafamma‑i, baa ta ba piiye wuɔ u yuŋgu si dii; aa sire wuɔ ba ka bel-o kũŋ baa-yo. ");
INSERT INTO cmeNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","A ne da *ãnjĩnamma pigãataamba namba naa hel *Yerusalɛmu‑i-na jo. Bafaŋ baa ta ba piiye wuɔ: «*Jĩna ba yuntieŋo‑i *Bɛlsebul yaa dii u yuŋgu-na. U yaa hãa-yo himma‑i u tuɔ gbã u donya jĩnabaa-ba‑i nuɔmba-na.» ");
INSERT INTO cmeNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Baŋ piiyeŋ dumaaŋo-na, Yesu wuɔ bĩ ba jo ji tuɔ piiye baa-ba wuɔ: «Namaa daa *Sitãni siɛ tuɔ donya fuɔ fɛrɛŋ-baamba‑i wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Nelle maŋ di nuɔmba bigãaŋ ba-naa, yiiŋgu dii baa yiiŋgu, nelle fande ka muonu. ");
INSERT INTO cmeNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Aa da na bi da dumɛlle maŋ di nuɔmba sa dɔl ba-naa, yiiŋgu dii baa yiiŋgu dumɛlle fande ka muonu. ");
INSERT INTO cmeNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Sitãni duɔ bir tuɔ gãŋ baa fuɔ fɛrɛŋ-baamba‑i, da ba gãŋ bɔrɔ hiere, u fɔ̃ŋgũɔ ce niɛ aa cɔ u wulaa? ");
INSERT INTO cmeNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Hai moloŋo‑i gbãa suur u nabiɛŋ dũŋgu-na a biɛra u bĩmbĩnni‑i hel baa-ni aa u nabiɛŋo yaŋ-yo dumaa? Ŋga kutieŋ duɔ bel u nabiɛŋo‑i vaa-yo igɛ̃na, u gbãa suur biɛra u bĩmbĩnni‑i hiere ta baa-ni.» ");
INSERT INTO cmeNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Yesuŋ waaŋ mafamma‑i, wuɔ gbɛ̃-ba wuɔ: «Yaaŋ mi waŋ ninsoŋo‑i baa-na: Nelbiliembaŋ ciɛ ãmbabalma maŋ cor hiere, halle baa baŋ waŋ ãndaparni maŋ ba hã Diiloŋo‑i, Diiloŋo gbãa ce jande bɛi aa yaŋ ma tĩ. ");
INSERT INTO cmeNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ŋga umaŋ duɔ tuora *Diiloŋ-Yalle‑i, kutieŋo cãlãa bɔi cor; jande siɛ gbãa ce-yuɔ.» ");
INSERT INTO cmeNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Baŋ taa ba piiye wuɔ jĩna dii Yesu yuŋgu-na, ku'i ciɛ u tuɔ waŋ mafamma‑i baa-ba. ");
INSERT INTO cmeNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ku huoŋgu-na, Yesu nyu‑i baa u hãmba jo u wulaa dii uŋ waa kusuɔŋ-nu a ji yiɛra fuoreŋ aa puɔr wuɔ ba bĩ-yo hã-ba. ");
INSERT INTO cmeNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Nuɔmba waa bɔi tĩɛna cĩilã Yesu‑i. Ba jo ji gbɛ̃-yo wuɔ: «Itie, ŋ nyu‑i baa ŋ hãmba‑i a naara ŋ tũɔbaa-ba dii yiɛra fuore-na ta ba cie-ni.» ");
INSERT INTO cmeNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesu wuɔ cira: «Na suɔ mi nyu‑i baa mi hãmba‑i wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Aa wuɔra ne nuɔmba yammu‑i aa cira: «Mi nyu‑i baa mi hãmba yaa mi yaaŋga-na daaba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Na saa da, bamaŋ ciɛŋ Diiloŋo huɔŋga‑i, ba yaa mi hãmba‑i, ba yaa mi tũɔbaa-ba‑i, ba yaa mi nyubaa-ba‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ku huoŋgu-na, Yesu wuɔ ji bir kã Galile dalaŋga-na ka tuɔ waŋ Diiloŋ-nelma‑i. Nuɔmba kũɔl ba-naa kã u wulaa. Wuɔ bel nyugũŋ tĩɛna beŋo naŋo-na dii hũmma-na aa nuɔmba waa yiɛra nuŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","U piiye nelma bɔi baa-ba gbãnɛiniŋ. Uŋ'a u doŋ, u gbĩɛ nuɔmba‑i wuɔ: «Karaaŋ na tũnni‑i dɛi na nu: ");
INSERT INTO cmeNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Naacolŋo naŋo kãa ka naŋ fũma u suoŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Fũma naŋo kã ka diire hũmelleŋ-huɔŋ-na. Huriimba jo ji wuo-yo. ");
INSERT INTO cmeNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Unaŋo kã ka diire tãmpɛ̃lleŋ-terieŋ-nu. Hĩɛma si dii bɔi terieŋgu-na, a ce u pa yaŋ unaŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Uŋ paa dumaaŋo-na, u kaasĩnni saa gbãa suur kã yaaŋ-na. Bãaŋguŋ juɔ ta ku jo huɔŋgu-na, u kuol hiere kpɛ̃mmu! ");
INSERT INTO cmeNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Unaŋo kã ka diire hĩɛŋ-nu. Hĩɛŋgu tu suuye-yuɔ a ce u saa gbãa dii belle. ");
INSERT INTO cmeNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Umaŋ diiriiye suoŋ-huɔŋga-na, munterfafammu-na, u sire gbuu kpatalla: unaŋo bieŋ komuɔŋa baa cĩncielbaa, unaŋo bieŋ komuɔŋa sa-a-siɛi, unaŋo bieŋ komuɔŋa da-a-ndii.» ");
INSERT INTO cmeNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Uŋ waaŋ mafamma‑i, u cira: «Umaŋ duɔ u ka nu, u nu!» ");
INSERT INTO cmeNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Bamaŋ taa ba nyaanu-yuɔ koko baa u *hãalãbieŋ cĩncieluo ba hãi baamba‑i, baŋ juɔ waa ba kula‑i baa-yo, baa ta ba piiye wuɔ ba saa suɔ u gbãnɛini yaaŋga‑i baa ni huoŋgu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yesu wuɔ cira: «Diiloŋo ciɛ baa namaaŋo‑i. U *nellentesĩnni maama maŋ fuyaa, u pigãaŋ namaaŋo‑i baa-ma, ŋga ma piiye baa banamba‑i gbãnɛiniŋ, ");
INSERT INTO cmeNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","a ce da ba ne-ma, ba siɛ da ma terieŋgu‑i, da ba nu-ma, ba siɛ suɔ ma yuŋgu‑i. Kuɔ maa naa kaala ba wulaa, baa naa cu Diiloŋo huoŋ-nu aa baŋ cãlãa-yo baa mamaŋ hiere, uu naa hiel-ma u huɔŋga-na.» ");
INSERT INTO cmeNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Uŋ waaŋ mafamma‑i, wuɔ bir yuu-ba wuɔ: «Naŋ'a na saa suɔ gbãnalãaŋ daaku yuŋgu‑i, na ka ce niɛ gbãa suɔ ninanni yunni‑i? ");
INSERT INTO cmeNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Fũma yaa Diiloŋ-nelma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Banaŋ hɔmmu dii ŋaa hũmelleŋ-huɔŋga, da ba nu Diiloŋ-nelma‑i ma sa cɔ; ba yaŋ *Sitãni jo ji hiel-ma aa yaŋ-ba. ");
INSERT INTO cmeNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Banaŋ hɔmmu dii ŋaa tãmpɛ̃lleŋ-terieŋgu, da ba nu Diiloŋ-nelma‑i, ma pãŋ dɔlnu-bɛi ba hũu-ma. ");
INSERT INTO cmeNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ŋga ma siɛ gbãa naŋ kaasĩnni. Wɛiŋ da ma da kutaamba‑i, sisɔ da ba ji ta ba huol ba yammu‑i ma maama-na, ba har jĩna. ");
INSERT INTO cmeNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Banaŋ hɔmmu dii ŋaa hĩɛŋ-terieŋgu; ");
INSERT INTO cmeNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","da ba nu Diiloŋ-nelma‑i, ba yaŋ ãnjɔguɔma‑i baa gbeiŋ-maama‑i a naara ba kusũŋ-maama jo ji suuye-mɛi a ce dumaaŋo-na ma siɛ gbãa dii belle. ");
INSERT INTO cmeNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","A ne da banaŋ hɔmmu dii ŋaa munterfafammu; da ba nu Diiloŋ-nelma‑i, ba jãrã-mɛi hũu-ma nammu hãi a wuɔ ma hũmelle‑i diŋ saaya di wuɔ dumaa. Kufaŋgu taamba yaa dii ŋaa fũma maŋ diyaa bieŋ komuɔŋa baa cĩncielbaa-ba‑i, komuɔŋa sa-a-siɛi‑i a naara komuɔŋa da-a-ndii‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu wuɔ tiraa yuu-ba wuɔ: «Namaaŋo-na, hai moloŋo‑i duɔ celieŋ fitĩnuɔ‑i u ce bĩŋkũŋgu cure-yuɔ? Sisɔ u dii-yo muŋgallammuŋ-tuoleŋ? Ma sĩ da na celieŋ-yo, na haa-yo dɔrɔ kɛ? ");
INSERT INTO cmeNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Na saa da, ku wɛima si dii mamaŋ siɛ ji hel, aa ku nelma si dii mamaŋ siɛ ji nu. ");
INSERT INTO cmeNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Umaŋ duɔ u ka nu, u nu!» ");
INSERT INTO cmeNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yesuŋ waaŋ mafamma‑i, wuɔ cira: «Naŋ nuŋ nelma maŋ, taa na ne-ma torro. Niŋ fiŋ baa kekerieŋgu maŋ ŋ hã banamba‑i, ba ka fi baa ku yaa a bi hã nuɔŋo‑i aa naara kunaŋgu kuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Kuŋ yeŋ baa umaŋ, ba ka hã-yo naara, aa umaŋ kuu sĩ baa-yo, cɛllɛ kũŋgu maŋ dii baa-yo, ba ka hũu-ku aa yaŋ-yo.» ");
INSERT INTO cmeNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu wuɔ tiraa cira: «*Diiloŋ-nellentesĩnni dii ŋaa nɛliɛŋo baa u dĩmma. U duu-ma, ");
INSERT INTO cmeNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","aa kã ka tuɔ ce u deŋ-maama. Dĩmmaŋ paŋ dumaa baa maŋ vãa dumaa, u sa suɔ kunaŋgu kuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Hĩɛma yaa ciɛŋ dĩmma pa ma fɛrɛ, aa ce ma vãa a ji dii bieŋa. ");
INSERT INTO cmeNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Da ma ji vãa hi karma‑i, u jo ji kar-ma.» ");
INSERT INTO cmeNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Aa tiraa cira: «I ka naŋ gbãnalãaŋ haku‑i a pigãaŋ Diiloŋ-nellentesĩnniŋ yeŋ dumaa? I gbãa saa-ni baa bige‑i? ");
INSERT INTO cmeNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","I gbãa saa-ni baa mutardi-belle, di yaa yuraanu yaŋ. ");
INSERT INTO cmeNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ŋga da ŋ duu-de, di sire pa a hiel negemmu a maar niifiɛlu‑i hiere, huriimba gbãa jo ji sɛ kamma muɔ.» ");
INSERT INTO cmeNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu naaŋ gbãnɛiŋ daani temma bɔi a pigãaŋ nuɔmba‑i Diiloŋ-nelma‑i a saa baa ba nelnulle‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Yesu saa tuɔ waŋ Diiloŋ-nelma‑i aa u saa dii gbãnalãaŋgu hɔlma-na. Duɔ puur duɔ piiye, gbãnalãaŋgu, a puur duɔ piiye, gbãnalãaŋgu. Ŋga da ba ji waa ba kula‑i baa u *hãalãbiemba‑i u suɔ firnu-niɛ hiere baa-ba. ");
INSERT INTO cmeNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Bãaŋguŋ juɔ hir huɔŋgu maŋ nuɔ‑i, Yesu wuɔ tĩɛ dii beŋo-na aa gbɛ̃ u *hãalãbiemba‑i wuɔ: «Yaaŋ i karnu i kã bombor damaalɛi!» ");
INSERT INTO cmeNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","U hãalãbieŋ baa yaŋ nuɔmba‑i terieŋgu faŋgu-na aa naa suur baa Yesu‑i uŋ waa beŋo maŋ nuɔ‑i a ta ba karnu ba kã. Benni nanni bi waa terieŋgu-na, nuɔmba naŋ baa biɛ nifanni‑i a cu ba huoŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ba'a ba ne da fafalmu naŋ temma siire ta mu pe hũmma‑i mu dii beŋo-na. Hoi huɔŋgu‑i baa huɔŋgu‑i beŋ wuɔ tuɔ yii duɔ yu. ");
INSERT INTO cmeNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesu waa galla beŋo huoŋ-yaŋga-na a kuo u yuŋgu‑i yukuodaaŋ-nu tuɔ duɔfũŋ. U hãalãbiemba pĩŋ-yo aa cira: «Hãalãtie, i tiɛ yii diɛ ku, aa naŋ waa galla ta ŋ duɔfũŋ ŋaa wɛima si dii.» ");
INSERT INTO cmeNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yesu wuɔ yiiye sire nuola fafalmu‑i aa waŋ baa hũmma‑i wuɔ ma ciire. Terduɔŋgu faŋgu-na, niɛ kã ka ciire. ");
INSERT INTO cmeNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Wuɔ gbɛ̃ u hãalãbiemba‑i wuɔ: «Bige‑i korda-kũŋgu fuɔ? Ku ce ŋaa na saa haa na naŋga‑i Diiloŋo-na wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ba kũɔ maa pãŋ ta ma nyɛŋ, baa ta ba yuu ba-naa wuɔ: «Nɛliɛŋ hayo‑i temma‑i dumandɛ‑i? Fuɔ dii niɛ aa duɔ nuola fafalmu‑i baa hũmma‑i ni kã ka ciire ni temma‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesubaa-baŋ taa ba karnu dalaŋga‑i ba kã bomborre maŋ nuɔ‑i, ba bĩ nelle fande‑i Geresa. ");
INSERT INTO cmeNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Baŋ kaa hi huɔl, Yesu wuɔ u ne da naacolŋo naŋo hilaa cĩncuɔŋa-na tuɔ jãrã-yuɔ. Naacolŋo faŋo‑i *jĩna waa u yuŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","U taa u cɔ cĩncuɔŋa yaa nuɔ‑i. Ku bibiɛ saa waa umaŋ gbãa bella-yuɔ u tĩɛna terduɔŋgu-na. Da ba fiɛ vaa-yo baa jɔlgɔbaa u kar-ba. ");
INSERT INTO cmeNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Nuɔmba ciɛ u maama yar-ba. U waa da ba ce ba bel-o dii kɔllu u gbeini-na aa vaa u nammu‑i baa jɔlgɔbaa wuɔ u baa kã terieŋgu. Da ba vaa-yo, u kar jɔlgɔbaa-ba‑i aa kara kɔllu‑i hiel-du u gbeini-na aa sire ta. ");
INSERT INTO cmeNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","U waa da ŋ saa da-yo cĩncuɔŋa-na, ŋ ka da-yo tãnni-na. Bãaŋgu‑i baa isuɔŋgu‑i uu dii tuɔ wuɔra u bĩŋ yaa‑i u kaasĩŋ aa tuɔ ce tãmpĩɛŋa‑i u posol u fɛrɛ. ");
INSERT INTO cmeNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Uŋ juɔ fara da Yesu‑i, wuɔ gbar jo ji dũuna u yaaŋga-na ");
INSERT INTO cmeNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","aa naa piiye da gbagaga wuɔ: «Yesu, Dɔrwuoŋo Biɛŋ nuɔ, mi ciɛ-ni niɛ? Jande, baa ce hɔdorre baa-mi; ne Diiloŋo‑i aa ŋ yaŋ-mi.» ");
INSERT INTO cmeNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Yesu wuɔ nuolaaya jĩna‑i wuɔ u cor hel-yuɔ ku'i ciɛ wuɔ tuɔ piiye dumaaŋo-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yesu wuɔ yuu-yo wuɔ: «Ba bĩ-ni niɛ?» Wuɔ cira: «I ciinu, ba bĩ-mi Sãlle.» ");
INSERT INTO cmeNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Aa gbuu tuɔ cãrã Yesu‑i wuɔ u ce jande aa u baa donya-bɛi hiel-ba nelle-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","A ne da pɛrsãlle nande waa ta di wuora tãnuŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Jĩnabaa baa gbɛ̃ Yesu‑i wuɔ: «Jande, ŋ sa yaŋ i hel ka suur pɛrŋ daaba-na wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesu wuɔ hã-ba hũmelle‑i. Baa hel naacolŋo-na ka suur pɛrmba-na. Pɛrŋ daaba naa yu pɛrmba neifelle‑i. Baa pãŋ ta ba gbar ba hiire ba kã ba suur dalaŋga-na ba kunu. ");
INSERT INTO cmeNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Nuɔmba waa ta ba ceŋ-ba. Baŋ juɔ da ba gbaraa ka kunu hiere dumaaŋo-na, baa pisãllã baa gbaruŋgu; banamba kã nelleŋ-huɔŋga-na, banamba kã sonni-na ka tũnu nuɔmba‑i. Nuɔmba hel da ba ji ne. ");
INSERT INTO cmeNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Baŋ juɔ ji hi da naacolŋ daayo diyaa bĩmbĩnni tĩɛna da welewele Yesu caaŋgu-na, korma pãŋ ta ma da-ba. ");
INSERT INTO cmeNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Bamaŋ waa da maŋ ciɛ dumaa hiere, baa suur ma yaaŋga-na waŋ-ma. ");
INSERT INTO cmeNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Nuɔŋ baa cãrã Yesu‑i wuɔ u ce jande aa u ta u halaŋ ba terieŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesu wuɔ kã ka tuɔ nyugũŋ beŋo-na duɔ bir. Uŋ duɔnya jĩnabaa-ba‑i naacolŋo maŋ nuɔ‑i, wuɔ cãrã-yuɔ wuɔ u yaŋ u kã baa-yo. ");
INSERT INTO cmeNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yesu wuɔ waŋ baa-yo wuɔ: «Yaŋ aa ŋ kũŋ ŋ ka tũnu ŋ baamba‑i Itieŋ uŋ ciɛ hujarre niɛ aa ce baa-ni dumaa.» ");
INSERT INTO cmeNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Naacolŋ wuɔ ta ka tuɔ wuɔra Dekapol-na u waŋ Yesuŋ ciɛ kumaŋ yuɔ hiere. Umaŋ duɔ nu nel daama‑i, ma ce-yo gbɛrɛ. ");
INSERT INTO cmeNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesubaa-baŋ birii karnu dalaŋga‑i kã bomborre nande-na, nuɔmba kũɔl ba-naa kã u wulaa dii hũmma nuŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","*Diilonelhãalãdũŋgu yuntieŋo naŋo‑i ba taa ba bĩ-yo Yarusi; wuɔ kã ka dũuna Yesu caaŋgu-na ");
INSERT INTO cmeNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","aa naa cira: «Itie, mi biloŋo ka ku mi wulaa, jande kã ŋ ka haa ŋ nammu‑i yuɔ ŋ kor-o ŋ hã-mi.» ");
INSERT INTO cmeNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yesu wuɔ kã ba ta. Nuɔŋ baa sire hiere ta ba kã baa-ba. Ba nogol Yesu‑i terni-na hiere dumaa. ");
INSERT INTO cmeNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ciɛŋo naŋo waa ba hɔlma-na, u tãmma taa ma kũnna ku bieŋ cĩncieluo baa a hãi waa belle fande-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","U ciɛ pɛrrumbaa-ba‑i ji gbɛ̃. U gbeiŋa ji tĩ hiere aa ku migãaŋ ta ku hor-yuɔ ku kã. Pɛrru bɔi mulãaŋ-yo. ");
INSERT INTO cmeNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Uŋ juɔ nu Yesu maama‑i, wuɔ suur nuɔmba hɔlma-na a cor u huoŋ-yaŋga ka yiɛya u joŋgoruo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","U taa u piiye u huɔŋ-na wuɔ: «Da mi gbãŋ hi u joŋgoruo‑i yiɛya-yuɔ yoŋ, mi kuraa.» ");
INSERT INTO cmeNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","U tãŋ maa pãŋ yiɛra. Terduɔŋgu faŋgu-na, wuɔ pãŋ suɔ wuɔ fafalmu daa-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Hɔduɔŋgu faŋgu-na, Yesu wuɔ suɔ wuɔ fɔ̃ŋgũɔ naŋo hilaa fuɔ‑i-na. Wuɔ miɛl yuu nuɔmba‑i wuɔ: «Hai moloŋo‑i yiɛyaaya-miɛ?» ");
INSERT INTO cmeNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","U *hãalãbieŋ baa cira: «Itie, nuɔmba yuu ta ba nogol-ni terni-na hiere ŋ bir ta ŋ yuu wuɔ: ‹Hai moloŋo‑i yiɛyaaya-miɛ?›» ");
INSERT INTO cmeNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Yesu wuɔ yaŋ-ba aa tuɔ wuɔra u nira nuɔmba-na umaŋ yiɛyaaya-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ciɛŋ daa uŋ suyaa wuɔ fafalmu daa-yuɔ, kuɔ ce-yo kũɔnyɛlle. Wuɔ piɛ dũuna Yesu caaŋgu-na aa naa waŋ ma yaaŋga‑i hiere baa-yo; u saa fuo ma diei. ");
INSERT INTO cmeNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesu wuɔ cira: «Mi bilo, niŋ haa ŋ naŋga‑i miɛ, ŋ kuraa. Kã ŋ kã fiɛi; ŋ cɛraa ŋ ji nunu jarŋ daama‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesuŋ taa u waŋ mafamma‑i huɔŋgu maŋ nuɔ‑i, nuɔŋ baa hel Diilonelhãalãdũŋgu yuntieŋo cĩiŋgu-na ji ta ba piiye baa-yo wuɔ: «Baa yaŋ hãalãtieŋo mulĩɛŋ u fɛrɛ, ŋ biloŋo jarma yaraa-yo.» ");
INSERT INTO cmeNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yesu wuɔ nu-ma. Wuɔ waŋ baa Yarusi‑i wuɔ: «Baa tie holle. Haa ŋ naŋga‑i miɛ yoŋ.» ");
INSERT INTO cmeNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Aa naa bir nuɔmba‑i hiere aa yaŋ Piɛr, baa Sake a naara Sake hãaŋo‑i Nsãa ba yaa cu u huoŋ-nu yoŋ. ");
INSERT INTO cmeNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Baŋ kaa hi cĩiŋgu‑i, baa da nuɔmba haa ba nammu‑i ba yunniŋ ta ba kaal hiere. ");
INSERT INTO cmeNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yesu wuɔ suur aa naa gbɛ̃-ba wuɔ: «Bige‑i maacemma‑i na wulaa dumaaŋo‑i? Biloŋo saa ku, u duɔfũŋ.» ");
INSERT INTO cmeNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Baa bir yaŋ aa ta ba cɔ̃muɔŋ-yo. Wuɔ ce ba hel hiere aa naa ce fuɔ baa biloŋo bĩncuɔmba‑i a naara u hãalãbiemba'i suur biloŋoŋ waa dũŋgu maŋ nuɔ‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Baŋ suurii, wuɔ bel biloŋo naŋ-na aa naa cira: «Talita kumi.» Ku yuŋgu yaa wuɔ: Bilo, sire, muɔmɛi waaŋ-ma dumaa! ");
INSERT INTO cmeNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Terduɔŋgu faŋgu-na, biloŋ wuɔ pãŋ sire tuɔ wuɔ. Kuɔ ce-ba gbɛrɛ. Biloŋ daa u waa baa bieŋ cĩncieluo a hãi. ");
INSERT INTO cmeNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yesu wuɔ waŋ-ma kuola-mɛi baa-ba wuɔ ba baa waŋ nel daama‑i baa moloŋo. Aa naa cira ba hã biloŋo‑i bĩŋkũŋgu u wuo. ");
INSERT INTO cmeNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ku huoŋgu-na, Yesu wuɔ sire terieŋ daaku-na baa u *hãalãbiemba‑i a kã ba nelle-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","*Yitĩɛnaŋguŋ juɔ hi, wuɔ kã *Diilonelhãalãdũŋgu-na ka tuɔ waŋ Diiloŋ-nelma‑i. U nelma taa ma ce nuɔmba‑i gbɛrɛ, a ne da ba saa waa dɛi baa yuliiŋgu‑i. Baa ta ba piiye wuɔ: «Fuɔ hilaa baa nel daama‑i hie? Fuɔ kaa da nelnul daade‑i hie baa hiŋ daama‑i? ");
INSERT INTO cmeNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ma sĩ Maari biɛŋo maŋ fãnaŋo‑i, u yaa kɛ? Fuɔ hãaŋo naŋo yaa Sake‑i, baa Yose‑i, baa *Yuda‑i a naara Simɔ‑i. Halle u tũɔbaa-ba dii baa-ye tĩɛnamma-na.» Kuŋ ciɛ dumaaŋo-na ba saa gbãa hũu Yesu nelma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesu wuɔ gbɛ̃-ba wuɔ: «Ba kãŋ *Diilopɔpuɔrbiloŋo‑i terni-na hiere; ŋga u nelleŋ-baamba‑i baa u dũŋ-baamba sa kãŋ-yo.» ");
INSERT INTO cmeNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Kuŋ ciɛ dumaaŋo-na, Yesu saa gbãa ce gbɛrɛ-wɛima terieŋgu-na. Uŋ ciɛ kumaŋ, ku yaa ŋaa a haa u nammu‑i jaamba namba-na a sire-bɛi ba jarma-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","U nelleŋ-baambaŋ'a ba saa hũu u nelma‑i kuɔ ce-yo gbɛrɛ. Ku huoŋgu-na, Yesu wuɔ ji ta baa u *hãalãbiemba‑i tuɔ wuɔra nilɛiŋa maŋ Nasarɛti kɔtɔnni-na u waŋ Diiloŋ-nelma‑i baa nuɔmba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yiiŋgu naŋgu-na, wuɔ ji bĩ u hãalãbieŋ cĩncieluo ba hãi baamba‑i a puɔr-ba ba hã-ba-hãi aa hã-ba himma ba ta ba gbã ba donya *jĩnabaa-ba‑i, ");
INSERT INTO cmeNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","aa naa gboya-bɛi wuɔ ba tamma-na, molo baa biɛ bĩŋkũŋgu: Molo baa biɛ niiwuoni, molo baa biɛ buɔra, molo baa biɛ gbeiŋa; kɛrɛ ba biɛ gborni yoŋ. ");
INSERT INTO cmeNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Wuɔ ba dii naatɛnni aa molo baa biɛ joŋgorbaa-ba hãi. ");
INSERT INTO cmeNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","U taa u bi piiye wuɔ: «Da na har dumɛlle maŋ nuɔ‑i, na tĩɛna dumɛlle fande-na fuɔ na tamma. ");
INSERT INTO cmeNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Da ba ka cira ba sa taara ba da na yufelle terieŋgu maŋ nuɔ‑i, na pir na nallu‑i na ta, ku yaa ba ka suɔ wuɔ ba maacemma saa fa.» ");
INSERT INTO cmeNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Hãalãbiemba taa ku yaa nuɔ‑i ka ta ba waŋ Diiloŋ-nelma‑i baa nuɔmba‑i wuɔ ba nanna ba cilɔbabalaŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ba bi hii donya jĩnabaa bɔi nuɔmba-na aa hure namma jaamba bɔi-na sire-bɛi ba jarma-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","15","Huɔŋgu faŋgu-na, Yesu yer diɛ wuɔra gbuo terni‑i hiere. Banaŋ ba'a *Nsãa-Batisi'i siire hel kuomba hɔlma-na jo, ku'i ciɛ u hi hiŋ daama temma‑i. Banaŋ ba'a *Eli yaa siire jo. Banaŋ ba'a yiinataaŋ *Diilopɔpuɔrbiloŋo naŋo‑i juɔ. *Erɔdi wuɔ nu-ma. U yaa waa *Galile yuŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Wuɔ cira: «Nsãa yaa‑i! Ŋ siɛ suɔ wuɔ mi ciɛ ba kar u yuŋgu‑i, ŋga u'i siire jo daayo.» ");
INSERT INTO cmeNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ninsie ninsie, fuɔ fɛrɛ yaa naa ciɛ ba bel Nsãa‑i dii-yo kaso Erodiyadi maa-na. Erodiyadi faŋo‑i u mɔlɔ̃ ciɛŋo'i waa aa wuɔ hũu-yo mɔlŋo wulaa dii-yo. Ba taa ba bĩ mɔlŋo‑i Filipu. ");
INSERT INTO cmeNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Uŋ hũyãa u mɔlɔ̃ ciɛŋo‑i, Nsãa wuɔ waŋ-ma baa-yo wuɔ fuɔ uudiiŋo sĩ. ");
INSERT INTO cmeNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ciɛŋ wuɔ pãŋ cɔ̃ Nsãa‑i aa naa tuɔ taara-yuɔ baa komma. Ŋga ma saa naa waa ma gbãa ce. ");
INSERT INTO cmeNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","A haa hama‑i nuɔ‑i? Erɔdi taa u kãalã Nsãa‑i. Uu naa suɔ wuɔ nelviiŋo aa tiraa suɔ wuɔ Diiloŋ-nolŋo, a ce dumaaŋo-na u saa tuɔ siɛya-yuɔ. Nsãa nelma taa ma surnu-yuɔ ma cor. Ŋga u waa duɔ tuɔ piiye, Erɔdi holle pãŋ caar. ");
INSERT INTO cmeNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Erodiyadi maamaŋ'a ma ka fa dumaaŋo-na, Erɔdi ji tuɔ ce u hommaŋ-yiiŋgu ponsaaŋgu aa bĩ u kuoyataamba‑i, baa sorosi ba yuntaamba‑i, baa Galile yuntaamba‑i hiere. ");
INSERT INTO cmeNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Erodiyadi biloŋ wuɔ nyɛŋ nyɛmuŋgu naŋ temma, kuɔ gbuu dɔlnu Erɔdi‑i baa bamaŋ waa hiere. Erɔdi wuɔ yuu-yo wuɔ: «Ŋ taara bige‑i mi hã-ni baa-ku?» ");
INSERT INTO cmeNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Aa naa cira: «Muɔ baa Diiloŋo, niŋ taaraŋ kumaŋ mi ka hã-ni baa-ku. Halle da ŋ fiɛ cira mi cal mi nelle‑i sɔmma hãi, a hã-ni sɔmma diei, mi ka ce-ma.» ");
INSERT INTO cmeNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Biloŋ wuɔ hel nuɔmba-na ka yuu nyuŋo‑i. Nyuŋ wuɔ cira: «Kã ŋ ka cira ŋ taara Nsãa-Batisi yuŋgu.» ");
INSERT INTO cmeNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Biloŋo gũunu baa gbaruŋgu kã nellentieŋo wulaa ka cira: «Mi taara ŋ kar Nsãa-Batisi yuŋgu‑i dii-ku tasaaŋ-na hã-mi fiɛfiɛ!» ");
INSERT INTO cmeNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Nellentieŋo yaaŋ kaa pãŋ bir ka deŋ birma. Ŋga u ka ce-ma niɛ, u yaa pãa nuŋgu‑i baa-yo nuɔmba-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Wuɔ naa wuɔ bi pãŋ puɔr sorosiyiɛŋo naŋo‑i wuɔ u kã ka kar Nsãa-Batisi yuŋgu‑i ji hã-yo baa-ku. Sorosiyiɛŋ wuɔ bi ta kã kasodũŋgu-na ka kar Nsãa yuŋgu‑i ");
INSERT INTO cmeNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","a dii-ku tasaaŋ-na jo baa-ku ji hã biloŋo‑i baa-ku. Biloŋ wuɔ hũu-ku ka hã nyuŋo‑i baa-ku. ");
INSERT INTO cmeNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Nsãa *hãalãbiembaŋ juɔ nu-ma wuɔ ba karaa ba yuntieŋo yuŋgu‑i, baa kã ka biɛ u bomborre‑i ka fuure-diɛ. ");
INSERT INTO cmeNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yesu *pɔpuɔrbiembaŋ kaa bir jo, baa jo ji tũnu Yesu‑i baa baŋ kaa ce mamaŋ hiere. ");
INSERT INTO cmeNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","A ne da nuɔmba bɔi taa ba jo u wulaa, a ce halle fuɔ baa u *hãalãbiemba‑i ba sa da ba fɛrɛ ba wuo niiwuoni‑i yɛrɛ. Yesu wuɔ gbɛ̃ u hãalãbiemba‑i wuɔ: «Yaaŋ i kã hĩɛŋ-nu na ka fiisa cɛllɛ.» ");
INSERT INTO cmeNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Baa sire ku yaa nuɔ‑i a biɛ beŋo‑i ta ta ba kã. ");
INSERT INTO cmeNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Baŋ taa dumaaŋo-na, nuɔmba bɔi daa-ba aa suɔ baŋ kãŋ kusuɔŋ-nu. Baa hel terni-na hiere a gbar ta yaaŋga bɛi. ");
INSERT INTO cmeNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesuŋ huɔlaa hũmma-na, wuɔ u ne da nelpũŋgu naŋ temma u yaaŋga-na; ba ne ŋaa tũlmba maŋ tieŋo sĩ bɛi. Ba hujarre gbuu bel-o. Wuɔ pãŋ doŋ tuɔ waŋ Diiloŋ-nelma‑i baa-ba. U piiye baa-ba vaaya. ");
INSERT INTO cmeNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Bãaŋguŋ juɔ ta ku hir huɔŋgu maŋ nuɔ‑i, u hãalãbiemba piɛ u caaŋ-nu a waŋ baa-yo wuɔ: «Itie, ŋ suyaa wuɔ ii dii hĩɛŋ-nu dɛ? Bãaŋguŋ hir ku kã ");
INSERT INTO cmeNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ŋ sa yaŋ nuɔmba kã nilɛiŋa maŋ kɔtɔnni-na ka taara niiwuoni sãa wuo wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yesu wuɔ cira: «Namɛi saaya na hã-ba niiwuoni‑i ba wuo.» Baa cira: «Itie, diɛ fiɛ sãa niiwuoni‑i *deniebaa nuɔsũɔ, ni siɛ gbɛ̃!» ");
INSERT INTO cmeNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yesu wuɔ cira: «Kãaŋ na ka ne, *buruo u niɛ dii baa-na?» Baa kã ka ne aa jo ji cira: «Buruo u ndii a naara titiraamba hãi.» ");
INSERT INTO cmeNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Yesu wuɔ cira ba ce nuɔmba calnu tĩɛna hĩɛbĩnaaŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Nuɔŋ baa tĩɛna. Banamba komuɔŋa da-a-ndii, banamba komuɔŋa hã-a-hãi baa cĩncielbaa. ");
INSERT INTO cmeNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yesu wuɔ biɛ buruo u ndii daayo‑i baa titiraamba hãi baaŋ daaba‑i a ciir u yuŋgu‑i dɔrɔ‑i-na aa jaal Diiloŋo‑i aa bũlnu-yuɔ hã u hãalãbiemba calnu-yuɔ a hã nuɔmba‑i. Aa bi calnu titiraamba‑i hã-ba hiere. ");
INSERT INTO cmeNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Nuɔŋ baa wuo ye hiere. ");
INSERT INTO cmeNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Baa gbura ni boini‑i a dii-ni segeyufieŋ cĩncieluo baa a hãi. ");
INSERT INTO cmeNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Nuɔmba maŋ waa, bibɛmba‑i yoŋ, ba kã nuɔmba neifieŋa hãi nuɔsiba ndii temma nuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Baŋ bi wuyaa niiwuoni‑i, Yesu wuɔ guor u *hãalãbiemba biɛ beŋo‑i ta u yaaŋ-na ta ba kã Betisada yaŋga aa fuɔ wuɔ tĩɛna duɔ ce nuɔmba bɔrɔ kũŋ ba cĩnniŋ. ");
INSERT INTO cmeNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Nuɔmbaŋ juɔ bɔrɔ hiere, wuɔ kã ka nyugũŋ tãnuŋgu-na tuɔ cãrã Diiloŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","48","Bãaŋguŋ juɔ suur, Yesu yaa waa yoŋ bomborma-na. A ne da fafalmu taa mu jãrã u hãalãbiemba‑i. Wuɔ fara da ba ce sũlma‑i dii hũmma holle-na baa beŋo‑i. Cuo kaalmaŋ-caaŋgu-na, wuɔ sire tuɔ wuɔ hũmma dɔrɔ‑i-na u kã ba wulaa. Uŋ kaa hi, wuɔ ce ŋaa u ciɛl-ba duɔ cor. ");
INSERT INTO cmeNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Hãalãbieŋ ba'a ba ne da hai moloŋo‑i wuɔyaaŋ hũmma dɔrɔ‑i-na daayo‑i! Baa doŋ ta ba kaasĩŋ wuɔ sĩ isuɔtieŋo. ");
INSERT INTO cmeNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Baŋ daa-yo, ba hulɛiŋa caaraa. Yesu wuɔ cira: «Baa na tie holle, muɔmɛi!» ");
INSERT INTO cmeNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Aa kã ka bel beŋo‑i suur. Fafal muɔ bi pãŋ yiɛra. Hãalãbieŋ baa kar da hãmmu! ");
INSERT INTO cmeNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Niiwuoniŋ-kũŋgu maŋ fiɛ ce cor, ba saa suɔ ku yaaŋga‑i. Nelma famma yaraa-ba suɔma. ");
INSERT INTO cmeNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Fafalmuŋ yiɛraaya, Yesubaa-ba perieŋ karnu kã Genesarɛti. ");
INSERT INTO cmeNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Baŋ hii bi huɔl, nuɔmba pãŋ suɔ Yesu‑i ");
INSERT INTO cmeNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","aa gbagbarra tũnu ba-naa terni-na hiere. Da ba nu wuɔ u dii kusuɔŋ-nu, ba biɛ ba jaamba‑i ba niigallanni-na gbar kã u wulaa. ");
INSERT INTO cmeNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Yesu waa duɔ cor terieŋgu terieŋgu, nuɔmba biɛ ba jaamba‑i ka jĩna ponsanatigerre-na aa cãrã-yuɔ wuɔ u yaŋ ba yiɛya-yuɔ; da ku fiɛ'a u joŋgoruo tũŋgu, ku ka saanu. Ninsie ninsie, ku waa jɛiŋo maŋ duɔ yiɛya-yuɔ fafalmu pãŋ da-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Yiiŋgu naŋgu-na, *Farisĩɛbaa-ba‑i baa *ãnjĩnamma pigãataamba maŋ naa hilaa *Yerusalɛmu‑i-na jo, baa kũɔlãa ba-naa kã Yesu wulaa. ");
INSERT INTO cmeNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ba'a ba ne da Yesu *hãalãbiemba namba wuo niiwuoni‑i a ne da ba saa saara ba nammu‑i a saanu baa *Yuifu ba bĩncuɔŋ-hũmelle‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","A ne da Farisĩɛbaa-ba‑i baa Yuifubaa-ba‑i hiere ba sa puona baa ba bĩncuɔŋ-maama‑i: Ba sa siɛ wuo niiwuoni‑i ni ba saa saara ba nammu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Aa da ba hel saŋga-na kũŋ, ba cɛ hũmma'i igɛ̃na aa suɔ wuo niiwuoni‑i. Ba bĩncuɔŋ-maama'i saa waa mafamma‑i yoŋ: Hũŋkaacimmuŋ-saarma waa ma deŋ, bũnammuŋ-saarma waa, bitonniŋ-saarma bi waa. ");
INSERT INTO cmeNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Baŋ daa ba wuo niiwuoni‑i dumaaŋo-na, baa yuu Yesu‑i wuɔ: «Bige‑i ciɛ ŋ hãalãbiemba sa wuɔ bĩncuɔŋ-hũmelle‑i? Ku ciɛ niɛ ba saa saara ba nammu‑i aa ta ba wuo niiwuoni‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesu wuɔ cira: «Huhurmantaaŋ namaa temma‑i daana‑i, *Isayiŋ fii-na baa kumaŋ, na yuu-ku. Isayi waaŋ-ma wuɔ: ‹Diiloŋo ciɛra wuɔ: «Nel daade taamba kãŋ-mi ba nuŋ-nu yoŋ. Mi maama si dii ba hɔmmu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Baŋ pigãaŋ nuɔmba‑i hũmelle maŋ, bafamba diele. A ce dumaaŋo-na yuŋgu si dii ba Diilojaale-na.»›» ");
INSERT INTO cmeNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Yesu wuɔ cira: «Na birii yaŋ Diiloŋ uŋ waaŋ mamaŋ aa vaa na fɛrɛ baa na bĩncuɔŋ-maama ta na ce. ");
INSERT INTO cmeNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Maa namaa cã! Na yagaraa Diiloŋo nuŋgu‑i aa bir bel na bĩncuɔŋ-maama yaa nammu hãi. ");
INSERT INTO cmeNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ma sĩ *Moisi waaŋ-ma wuɔ na ta na dii na bĩncuɔmba nunni‑i kɛ? Aa tiraa cira umaŋ duɔ waŋ ãndaparaaŋgu hã u to, sisɔ u nyu, kutieŋo saaya baa komma. ");
INSERT INTO cmeNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ŋga namaa birii cira wuɔ umaŋ duɔ waŋ baa u bĩncɔiŋo‑i wuɔ: ‹Miŋ ŋa naa da kumaŋ da mi kãyã-niɛ ku ciɛ «kɔrbã»; ku yuŋgu yaa wuɔ mi pãa-ku hã Diiloŋo.› Wuɔ kɛrɛ umaŋ duɔ ce mafamma‑i aa u saa ji fiɛ da bĩŋkũŋgu hã u bĩncɔiŋo‑i wɛima sĩ. ");
INSERT INTO cmeNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Terieŋgu faŋgu-na, na ce nuɔmba ta ba yaŋ ba bĩncuɔmba‑i ba sa kãyã-bɛi. ");
INSERT INTO cmeNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Na birii biɛ na bĩncuɔŋ-maama yaa‑i a dii-ma Diiloŋ-nelma fuoŋgu-na ta na hãalã na-naa baa-ma. Na ciɛ ma temma bɔi cor tĩ a ne da ma saa fa.» ");
INSERT INTO cmeNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ku huoŋgu-na, Yesu wuɔ tiraa bĩ nuɔmba‑i ji tuɔ piiye baa-ba wuɔ: «Karaaŋ na tũnni‑i fafamma na nu mi nelma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kumaŋ suuriiŋ nɛliɛŋ nuɔ ŋ nuŋgu-na, ku siɛ gbãa guɔla-niɛ Diiloŋ-hũmelle-na; kumaŋ hilaaŋ, ku yaa gbãa guɔla-niɛ.  ");
INSERT INTO cmeNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Umaŋ duɔ u ka nu, u nu!» ");
INSERT INTO cmeNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Uŋ juɔ hel nuɔmba hɔlma-na kũŋ cĩiŋgu-na, u *hãalãbiemba cira u firnu nel daama‑i pigãaŋ-ba. ");
INSERT INTO cmeNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Wuɔ cira: «Bisãlmba'i namaaŋo‑i wɛi? Namaa saa suɔ wuɔ kumaŋ suuriiŋ nɛliɛŋ nuɔ ŋ nuŋgu-na ku siɛ gbãa guɔla-niɛ wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Kumaŋ suuriiŋ ŋ nuŋgu-na ku sa kã ŋ huɔŋ-na, ku kã ŋ kusũŋ-nu ka ce biniɛŋa a hel.» Terieŋgu faŋgu-na, Yesu taara duɔ pigãaŋ wuɔ niiwuoni‑i hiere ni gbãa wuo. ");
INSERT INTO cmeNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Aa naa tiraa cira: «Mamaŋ dii nɛliɛŋ nuɔ ŋ huɔŋga-na, ma yaa gbãa guɔla-niɛ Diiloŋ-hũmelle-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ãnjɔgɔbabalamma hel nɛliɛŋ nuɔ ŋ huɔŋga'i nuɔ‑i: Ŋ huɔŋga'i diyaaŋ-niŋ bĩŋwosĩnni-na, cuosĩnni-na, nelkolle-na, ");
INSERT INTO cmeNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","*fuocesĩnni-na, cãncaaya‑i-na, hɔdorre-na, nuɔŋ-tãalma-na, kakarkuoŋo-na, nenemuŋgu-na, yebĩɛnande-na, bombolma-na, ãnyagarma-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Nelbabalaŋ daama‑i hiere ma hel nɛliɛŋ nuɔ ŋ huɔŋga'i nuɔ‑i. Ma yaa guɔlaayaŋ-niɛ Diiloŋ-hũmelle-na.» ");
INSERT INTO cmeNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ku huoŋgu-na, Yesu wuɔ ji ta halaŋ terieŋgu-na a kã Tiir. Uŋ kãa, wuɔ suur dũŋgu naŋgu-na duɔ fuo nuɔmba baa da-yo. Ŋga u saa gbãa. ");
INSERT INTO cmeNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ciɛŋo naŋ wuɔ nuɔ u maama nelle fande-na, a ne da *jĩna waa u biloŋo-na. Yesu bi himma‑i, ciɛŋ daa wuɔ jo ji dũuna u yaaŋga-na ");
INSERT INTO cmeNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","a cãrã-yuɔ wuɔ u donya jĩna daayo‑i u biloŋo-na. Ciɛŋ daa u waa *niɛryiɛŋo. U taa u hel Fenisi maŋ dii Siiri mara‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yesu wuɔ cira: «Da ŋ biɛ bisãlmba niiwuoni‑i hã juoraamba baa-ni ku saa fa. Yaŋ da ba wuo ye, ŋ suɔ ŋ biɛ boini‑i ŋ hã juoraamba‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ciɛŋ wuɔ cira: «Itie, ma sĩ bisãlmbaŋ wuo aa jubieŋa maŋ ta a diire hĩɛma-na, juoraamba biɛra-yɛi ba wuo kɛ?» ");
INSERT INTO cmeNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Uŋ waaŋ mafamma‑i, Yesu wuɔ cira: «Niŋ suyaa mafamma‑i waŋ-ma, bir ŋ kũŋ, jĩna taa halaŋ ŋ biloŋo-na.» ");
INSERT INTO cmeNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ciɛŋo birii ku yaa nuɔ‑i kũŋ, kã ka da biloŋo gaala u muŋgallammu-na: Jĩna taa. ");
INSERT INTO cmeNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ku huoŋgu-na, Yesu wuɔ sire Tiir-na a hel Sidɔ̃ aa bir hiire kã ka karnu Dekapol nilɛiŋa‑i kã ka hel Galile dalaŋga-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Baa jo baa bobo naŋo‑i a ji cãrã-yuɔ wuɔ u haa u naŋga‑i yuɔ a firnu u jumɛlle‑i aa puur u tũnni‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesu wuɔ bel-o hel baa-yo nuɔmba-na. Baŋ hilaa, wuɔ dii u nieŋa‑i naacolŋo tũnni-na aa ce u taaluŋgu‑i hure u jumɛlle-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Uŋ ciɛ mafamma‑i, wuɔ ciir u yuŋgu‑i aa fiisa da fũɔ aa cira: «Efata!» Ku yuŋgu yaa wuɔ: Puur! ");
INSERT INTO cmeNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Terduɔŋgu faŋgu-na, naacolŋo tũŋ niɛ pãŋ puur aa u jumɛl diɛ bi pãŋ firnu u tuɔ piiye da welewele ŋaa u'i sĩ. ");
INSERT INTO cmeNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","37","Kuɔ fũnuŋ cu nuɔmba hɔmmu‑i. Baa ta ba piiye wuɔ: «Naacolŋ daa u maacemma faa cor! U puur tugbentaamba tũnni‑i aa tuɔ ce bobobaa-ba ta ba gbã ba piiye.» Yesu wuɔ tuɔ piiye baa-ba wuɔ ba baa yaŋ ma hel. Duɔ waŋ mafamma‑i, ku ce ŋaa u kaa namma dii dãamu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Yibieŋa faŋa-na, nuɔmba tiraa kũɔl ba-naa ka tigiiŋ Yesu caaŋgu-na. A ne da niiwuoni saa waa baa-ba. Yesu wuɔ bĩ u *hãalãbiemba‑i ji tuɔ piiye baa-ba wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Nuɔŋ daaba hujarre gbu di ko-mi; ba yinni siɛi yaa dɛ‑i baa-mi ba saa da bĩŋkũŋgu wuo. ");
INSERT INTO cmeNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Banamba hilaa termaaŋ-nu jo, da mi yaŋ ba bir baa nyulmu‑i ku kaa nuɔl-ba hũmelle-na.» ");
INSERT INTO cmeNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","U hãalãbiemba cira: «Itie, i ka da niiwuoni‑i hie hĩɛŋ daaku-na diɛ ji hã nelpũŋ daaku temma da ku wuo ye?» ");
INSERT INTO cmeNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesu wuɔ yuu-ba wuɔ: «*Buruo u niɛ dii baa-na?» Baa cira: «Buruo niehãi.» ");
INSERT INTO cmeNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yesu wuɔ ce nuɔmba tĩɛna hĩɛma-na aa naa biɛ buruo niehãi daayo‑i a jaal Diiloŋo‑i aa bũlnu-yuɔ hã u hãalãbiemba‑i wuɔ ba calnu-yuɔ hã-ba. U hãalãbiemba hũu-yo bi calnu-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Tetebiemba namba bi waa, wuɔ tiraa biɛ bafamba‑i a jaal Diiloŋo‑i aa hã u hãalãbiemba‑i baa-ba wuɔ ba calnu-bɛi hã nuɔmba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Nuɔmba maŋ waa hiere, baa wuo ye. Baa gbura ni boini‑i dii-ni segeyufieŋ niehãi. ");
INSERT INTO cmeNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","A ne da nuɔmba maŋ waa, ba gbãa yu nuɔmba neifieŋa hãi temma. Baŋ juɔ wuo tĩ, Yesu wuɔ hã-ba hũmelle‑i wuɔ ba kũŋ ba cĩnniŋ ");
INSERT INTO cmeNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","aa fuɔ baa u hãalãbiemba‑i baa biɛ beŋo‑i ta ba kã Dalmanuta. ");
INSERT INTO cmeNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Yesubaa-baŋ kãa Dalmanuta‑i-na, *Farisĩɛbaa-ba namba jo ji ta ba fanu ba-naa baa-yo. Baa ji cira wuɔ da kuɔ Diiloŋo'i puɔraa-yo, u ce himma ba ne. Ba taa ba waŋ mafamma‑i wuɔ sĩ ba ka gbãa cure-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesu wuɔ fiisa da fũɔ aa naa cira: «Bige‑i ciɛ fiɛfiɛ ku nuɔŋ namaaŋo‑i na'a mi ce himma pigãaŋ-na ku yaa na ka suɔ wuɔ Diiloŋo'i puɔraa-mi? Mi waŋ ninsoŋo‑i baa-na, bĩŋkũŋgu sa ce dii pigãaŋ-na!» ");
INSERT INTO cmeNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Aa naa pãŋ ta baa u *hãalãbiemba‑i ka suur beŋo-na ta ba karnu ba kã dalaŋga yiɛŋgu naŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","A ne da ma saa naa tĩɛnu u hãalãbiemba biɛ *buruo. Buruo diei waa baa-ba yoŋ beŋo huɔŋga-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesu wuɔ tuɔ piiye baa-ba wuɔ: «Jande, bilaaŋ na fɛrɛ Farisĩɛ ba siini-na baa *Erɔdi bi niini-na.» ");
INSERT INTO cmeNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Hãalãbiemba doŋ ta ba piiye ba-naa nuɔ wuɔ: «Na saa da, iŋ'a i saa biɛ niiwuoni ku'i ciɛ u tuɔ piiye dɛ‑i-na.» ");
INSERT INTO cmeNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu wuɔ suɔ baa-ba. Wuɔ yuu-ba wuɔ: «Bige‑i ciɛ na ta na piiye wuɔ mi daa na saa biɛ niiwuoni ku'i ciɛ mi ta mi piiye dɛ‑i-na? Ku ce ŋaa a ji hi baa nyuŋgo, miŋ waŋ nelma maŋ na saa hi ta na da ma terieŋgu‑i wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Na sa da baa na yufieŋa‑i wɛi? Aa na sa nu baa na tũnni‑i wɛi? Ma karaanu-nɛi wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Miŋ bũlãanu buruo u ndii‑i a hã nuɔmba neifieŋa hãi nuɔsiba ndii‑i, na biɛraaya boini‑i segeyufieŋa niɛ ta?» Baa cira: «Segeyufieŋ cĩncieluo a hãi.» ");
INSERT INTO cmeNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Wuɔ cira: «Aa miŋ bũlãanu buruo niehãi a hã nuɔmba neifieŋa hãi ba wuo, segeyufieŋa niɛ juɔ tĩɛ?» Baa cira: «Segeyufieŋ niehãi juɔ tĩɛ.» ");
INSERT INTO cmeNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Yesu wuɔ cira: «Ji hi baa nyuŋgo na saa hi suɔ ku yaaŋga‑i yogo wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesubaa-baŋ kaa hi Betisada‑i, baa jo baa yiroŋo naŋo ji hã-yo wuɔ u ce jande aa u haa u naŋga‑i yuɔ a puur u yufieŋa‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesu wuɔ bel yiroŋ daa u naŋ-na ba hel nelleŋ-huɔŋga-na a kã ba deŋ. Baŋ kaa hi, wuɔ ce taaluŋgu a hure naacolŋo yufieŋa-na aa ce u nammu‑i cuye-yɛi ku ce cɛllɛ aa suɔ halaŋ-mu. Uŋ halaaŋ-mu, wuɔ yuu-yo wuɔ: «Ŋ da wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Naacolŋ wuɔ ne aa naa cira: «Mi da nuɔmba‑i ŋga mi sa da-ba dɛi; mi da-ba ŋaa tibinni aa ta ni wuɔ.» ");
INSERT INTO cmeNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yesu wuɔ tiraa bir cu u nammu‑i naacolŋo yufieŋa-na. Uŋ juɔ halaŋ-mu kufaŋgu‑i, naacolŋ wuɔ pãŋ tuɔ da fafamma. ");
INSERT INTO cmeNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","U yufieŋ aŋ puurii, Yesu wuɔ waŋ baa-yo wuɔ: «Ta ŋ kũŋ cĩiŋ-nu, baa tiraa ŋ suur nelleŋ-huɔŋga-na.» ");
INSERT INTO cmeNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ku huoŋgu-na, Yesu‑i baa u *hãalãbiemba ji ta ba kã nilɛiŋa maŋ dii Sesare maŋ Filipu wuoŋo‑i u kɔtɔnni-na. Baŋ kãŋ hũmelle-na, Yesu wuɔ yuu-ba wuɔ: «Nuɔmba ciɛra hai moloŋo‑i muɔŋo‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","U hãalãbiemba cira: «Banamba ciɛra wuɔ nuɔnɛi *Nsãa-Batisi‑i, banaŋ ba'a nuɔnɛi *Eli‑i, banaŋ ba'a *Diilopɔpuɔrbiloŋo naŋo‑i nuɔŋo‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Yesu wuɔ bir yuu-ba wuɔ: «Aa namaa fuɔ, na'a hai moloŋo‑i muɔŋo‑i?» Piɛr wuɔ cira: «Diiloŋ uŋ pãa nuŋgu‑i aa saaŋ *Koŋkortieŋo maŋ, u yaa nuɔŋo‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yesu wuɔ waŋ-ma kuola-mɛi baa-ba wuɔ ba baa yaŋ ma hel molo nu-ma. ");
INSERT INTO cmeNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","A doŋ huɔŋgu faŋgu-na, Yesu wuɔ doŋ tuɔ piiye u pigãaŋ u *hãalãbiemba‑i wuɔ *Moloŋ-Biɛŋo ka mulĩɛŋ da dɛi! Nelle bĩncuɔmba‑i, baa *Diilojigãntaamba yuntaamba‑i, a naara *ãnjĩnamma pigãataamba ka cĩina-yuɔ aa ko-yo. Ŋga da ba ko-yo, u ka ce yinni hãi hĩɛma-na, siɛliŋ-yiiŋgu‑i u ka sire hel jo. ");
INSERT INTO cmeNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesu wuɔ waaŋ nel daama‑i kaala-mɛi baa-ba. Piɛr wuɔ bĩ-yo ba kã ba deŋ ka tuɔ waŋ baa-yo wuɔ: «Itie, baa ta ŋ piiye dumaa, ku saa fa.» ");
INSERT INTO cmeNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Yesu wuɔ miɛl ne u hãalãbiemba‑i aa naa gbɛ̃ Piɛr wuɔ: «*Sitãni, kã ŋ halaŋ mi caaŋ-nu! Ŋ kusũŋ-maama‑i Diiloŋ-maama sĩ, nelbilieŋ-maama.» ");
INSERT INTO cmeNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ku huoŋgu-na, wuɔ bĩ nuɔmba‑i baa u hãalãbiemba‑i ji tuɔ piiye baa-ba wuɔ: «Nuɔni maŋ da ŋ ta ŋ taara ŋ nyaanu-miɛ, ŋ saaya ŋ cĩina ŋ fɛrɛ, aa ŋ saaya ŋ siɛ mulĩɛma‑i baa kuliiŋgu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Umaŋ duɔ tuɔ kaal baa u yuŋgu yoŋ, u ka kɔsuɔŋ u fɛrɛ, ŋga umaŋ duɔ tuɔ kɔsuɔŋ u fɛrɛ mɛi maama-na baa *Neldɔdɔlma maama-na, kutieŋo ka da cicɛ̃lma maŋ siɛ ji tĩ dede. ");
INSERT INTO cmeNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Nɛliɛŋ nuɔ, da ŋ da ŋ yufieŋ-niini‑i hiere miwaaŋo-na aa ka caa, yuŋ haku‑i dii-kuɔ? ");
INSERT INTO cmeNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Nɛliɛŋ nuɔ, ŋ gbãa sãa ŋ yuŋgu‑i baa bige‑i Diiloŋo wulaa? ");
INSERT INTO cmeNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Na saa da, fiɛfiɛ ku nuɔmba saa fa, ba jɛ̃naamba sa ku. Umaŋ duɔ tuɔ ce senserre bɛi u sa taara ba suɔ wuɔ mɛi wuoŋo, u sa bi taara u waŋ mi maama‑i baa-ba, Moloŋ-Biɛŋo duɔ ji jo baa u To fɔ̃ŋgũɔ‑i baa *dɔrpɔpuɔrbiemba‑i, u ka bi ce senserre baa kutieŋo maama‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Aa naa cira: «Yaaŋ mi waŋ ninsoŋo‑i baa-na: Banamba dii na hɔlma-na bande‑i-na, ba ka da *Diiloŋ-bãaŋgu‑i aa suɔ da ba ku. Diiloŋo ka ce u bãaŋgu‑i baa fɔ̃ŋgũɔ.» ");
INSERT INTO cmeNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Yesuŋ waaŋ mafamma‑i, yinni niediei temma cor, wuɔ ce fuɔ baa Piɛr, baa Sake a naara Nsãa ba kã ba deŋ ka nyugũŋ tãnujaataama naŋo-na. Ba'a ba ne da Yesu birii u deŋ birma. ");
INSERT INTO cmeNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","U joŋgorbaa-ba birii baapiɛlmba ta ba caa da kpoikpoi; halle molo siɛ gbãa ce bĩŋkũŋgu pusũŋ dumaaŋo-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","*Hãalãbieŋ ba'a ba tiraa ne, a da *Eli baa *Moisi ba caraaya-bɛi ta ba piiye baa Yesu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Piɛr wuɔ gbɛ̃ Yesu‑i wuɔ: «Hãalãtie, i jomma faa bande‑i-na dɛ! Ŋ sa yaŋ i ce gbuganni siɛi wɛi? Ku diei naŋ kũŋgu, ku diei Moisi kũŋgu, aa ku diei kũŋgu naŋgu‑i Eli kũŋgu.» ");
INSERT INTO cmeNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Korma'i naa bilaa Piɛrbaa-ba‑i a ce u tuɔ piiye dumaa u yuŋ-nu u sa suɔ uŋ waŋ mamaŋ. ");
INSERT INTO cmeNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Duherru nandu jo ji cĩnnu-bɛi. Baa nu molo piiye du huɔŋga-na wuɔ: «Mi Biɛŋo yaa daayo‑i; u maama sa suɔ aa dɔlnu-miɛ, taa na nu u nuŋgu‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Hãalãbiemba wuɔra ne terni-na hiere ba saa da moloŋo baa Yesu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Baŋ juɔ ta ba hiire tãnuŋgu-na, Yesu wuɔ waŋ-ma kuola-mɛi baa-ba wuɔ *Moloŋ-Biɛŋ duɔ saa sire hel kuomba hɔlma-na, ba baa waŋ nel daama‑i baa moloŋo! ");
INSERT INTO cmeNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Hãalãbiemba siɛ aa ta ba yuu ba-naa wuɔ: «A sire hel kuomba hɔlma-na, ku yuŋgu yaa wuɔ niɛ?» ");
INSERT INTO cmeNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Baŋ kaa hi yaaŋga‑i, baa yuu Yesu‑i wuɔ: «Ma sĩ *ãnjĩnamma pigãataamba ciɛra wuɔ Eli saaya u bir jo igɛ̃na aa Diiloŋ uŋ pãa nuŋgu‑i wuɔ u ka saaŋ *Koŋkortieŋo maŋ u suɔ jo kɛ?» ");
INSERT INTO cmeNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesu wuɔ cira: «Ba saa kar coima; Eli saaya u jo igɛ̃na ji migãaŋ wɛima‑i hiere. Ŋga bige‑i ciɛ Diiloŋ-nelma cira wuɔ: ‹Moloŋ-Biɛŋo ka mulĩɛŋ da dɛi aa ba siɛ ta ba kãŋ-yo?› ");
INSERT INTO cmeNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Mi tũnu-nɛi: Eli juɔ tĩ. Uŋ juɔ, nuɔmba ciɛ ba bãaŋgu‑i yuɔ. Diiloŋ-nelmaŋ waaŋ-ma dumaa, ba bi ciɛ-ma dumɛi.» ");
INSERT INTO cmeNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yesubaa-baŋ hiiriiye ka hi u *hãalãbiemba namba terieŋgu‑i, baa da nuɔmba juɔ ji yu ba caaŋgu-na, aa da *ãnjĩnamma pigãataamba namba juɔ ba ji ta ba fanu ba-naa baa-ba. ");
INSERT INTO cmeNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Nuɔmba juɔ'a ba ne da Yesu jo, kuɔ ce-ba gbɛrɛ, baa gbar jãrã-yuɔ ka ta ba jaal-o. ");
INSERT INTO cmeNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesuŋ juɔ ji hi, wuɔ yuu u hãalãbiemba‑i wuɔ: «Na fanu na-naa baa-ba nel hama‑i nuɔ‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Naacolŋo naŋo tĩɛ dii nuɔmba-na aa cira: «Hãalãtie, *jĩna naŋo dii mi biɛŋo yuŋgu-na a ce-yo bobo. Mi juɔ baa u yaa‑i ŋ wulaa. ");
INSERT INTO cmeNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Duɔ sire-yuɔ terieŋgu terieŋgu, u mal-o. Duɔ mal-o, sãmpugaaru ta du hel u nuŋgu-na, aa ŋ da u wuo u nyiɛni‑i aa kuola da girri. Mi waaŋ baa ŋ hãalãbiemba‑i miɛ ba donya-yuɔ, ba saa gbãa.» ");
INSERT INTO cmeNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesu wuɔ gbɛ̃-ba wuɔ: «Fiɛfiɛ ku nuɔŋ namaaŋo‑i, na sa hũu nɛliɛŋ maama. Na daa niɛ sĩ mi ka tĩɛna baa-na gbula wɛi? Namaa ji hũu mɛi maama‑i yaku‑i?» Aa naa cira: «Juɔŋ baa naacombiloŋo‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Baa ta ta ba kã baa-yo da ba ka hã-yo. Jĩnaŋ kaa cira u ne da Yesu‑i, wuɔ pãŋ bel naacombiloŋo‑i gbuu sagalla-yuɔ. Naacombiloŋ wuɔ hel cii tuɔ bũmallã aa sãmpugaaru ta du hel u nuŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesu wuɔ yuu tuoŋo‑i wuɔ: «Jĩna daayo dii-yuɔ ku bãaŋgu cuɔ wɛi?» Tuoŋ wuɔ cira: «Uu dii-yuɔ dii u bisãnsĩnniŋ. ");
INSERT INTO cmeNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Duɔ ce u ce u suur dãamu-na sisɔ hũmma-na duɔ ko-yo hã-mi. Da ŋ'a ŋ ka gbãa, jande ne Diiloŋo‑i aa ŋ kãyã-yiɛ.» ");
INSERT INTO cmeNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu wuɔ cira: «Bige‑i ciɛ ŋ'a da miɛ mi ka gbãa? Umaŋ duɔ haa u naŋga‑i Diiloŋo-na, wɛima‑i hiere ma gbãa ce hã kutieŋo‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Yesuŋ waaŋ mafamma‑i, naacombiloŋo to wuɔ pãŋ cira: «Mi haa mi naŋga‑i Diiloŋo-na ŋga kãyã-miɛ ni mɛi sĩ kuu dii kpelle.» ");
INSERT INTO cmeNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Baŋ tĩyãa kufaŋgu-na, nuɔŋ baa ta ba jo ba naara. Yesuŋ daa ba kũɔlãa ba-naa ta ba jo dumaaŋo-na, wuɔ cira: «Jĩna nuɔ, ma'a ŋ'a ŋ gbãŋ ce nuɔmba‑i bobobaa baa tugbentaamba? Cor ŋ hel naacombiloŋo-na, mi sa taara mi tiraa da-ni yuɔ gbula.» ");
INSERT INTO cmeNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Jĩna wuɔ kaasĩŋ da gbagaga aa naa gbuu sagalla naacombiloŋo‑i aa suɔ hel-yuɔ. Naacombiloŋ wuɔ galla ŋaa u kuu. Nuɔmba maŋ waa hiere baa da niɛ sĩ u kuu. ");
INSERT INTO cmeNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Yesu wuɔ bel u naŋ-na sire-yuɔ u yiɛra u gbeiniŋ. ");
INSERT INTO cmeNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yesuŋ juɔ kũŋ baa u hãalãbiemba‑i ba ka waa ba kula‑i, baa yuu-yo wuɔ: «Hãalãtie, bige‑i ciɛ miɛ i saa gbãa donya jĩna daayo‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesu wuɔ cira: «Jĩna daayo temma‑i Diilocãrãlle'i gbãa donya-yuɔ yoŋ.» ");
INSERT INTO cmeNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Ku huoŋgu-na, Yesu‑i baa u *hãalãbiemba sire terieŋgu-na a suur *Galile huɔŋga-na ta ba karnu ba kã. Yesu taa u piiye Diiloŋ-nelma‑i u pigãaŋ u hãalãbiemba‑i a ce dumaaŋo-na u saa tuɔ taara molo suɔ ba saaŋgu. U taa u piiye baa-ba wuɔ: «Ba ka bel *Moloŋ-Biɛŋo‑i hã nelbiliemba‑i baa-yo ba ko-yo. Da ba ko-yo, u ka ce yinni hãi yoŋ hĩɛma-na, siɛliŋ-yiiŋgu‑i u ka sire hel jo.» ");
INSERT INTO cmeNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Hãalãbiemba saa suɔ u nelma yaaŋga‑i; ŋga ba siɛ bi siɛ yuu-yo. ");
INSERT INTO cmeNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Yesubaa-baŋ kaa hi Kafarnamu‑i a suur ba dũŋgu-na, Yesu wuɔ yuu u *hãalãbiemba‑i wuɔ: «Iŋ joŋ hũmelle-na, na taa na fanu na-naa nel hama‑i nuɔ‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","A ne da hũmelle-na, ba taa ba fanu ba-naa da ba suɔ umaŋ nelbuɔ‑i ba hɔlma-na. Yesuŋ yuu-ba dumaaŋo-na, ba fĩinaŋ ba saa waŋ wɛima. ");
INSERT INTO cmeNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesu wuɔ bir tĩɛna aa bĩ-ba cĩncieluo ba hãi‑i-na hiere a tuɔ piiye baa-ba wuɔ: «Na hɔlma-na umaŋ duɔ tuɔ taara u waa na yaaŋga-na, kutieŋo saaya u jĩna u fɛrɛ na hieroŋo huoŋ-nu aa tiraa ce u fɛrɛ na maacembiloŋo.» ");
INSERT INTO cmeNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Uŋ waaŋ mafamma‑i, wuɔ bel bisãmbiloŋo naŋo‑i jo baa-yo ba hɔlma-na. Uŋ juɔ baa-yo, wuɔ tũu-yo aa cira: ");
INSERT INTO cmeNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Umaŋ duɔ bel bisãmbiloŋ daayo temma‑i fafamma mɛi maama-na, kuu dii ŋaa u bilaa mɛi fɛrɛ yaa‑i, aa umaŋ duɔ bel muɔŋo‑i fafamma, kuu dii ŋaa kutieŋo bilaa umaŋ puɔraa-mi.» ");
INSERT INTO cmeNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ku huoŋgu-na, Nsãa wuɔ cira: «Hãalãtie, i daa naacolŋo naŋo gbuuse-niɛ aa tuɔ donya *jĩnabaa-ba‑i, miɛ ne da u sa nyaanu-niɛ baa miɛŋo‑i i ce u yaŋ.» ");
INSERT INTO cmeNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yesu wuɔ cira: «Baa na cie-yo. Na saa da, molo siɛ gbãa gbuuse-miɛ a ce gbɛrɛ-wɛima aa tiraa bir bĩ mi yebabalande‑i terduɔŋgu faŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Umaŋ duɔ saa bigãaŋ-ye, uu dii baa-ye. ");
INSERT INTO cmeNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Aa umaŋ duɔ ne muɔŋo‑i aa hã-na hũmma‑i na nyɔŋ wuɔ *Kirsa baaŋ namaa, da ku fiɛ waa ciyufelle yoŋ, coima saa fa, kutieŋo siɛ naa u daluɔ‑i Diiloŋo wulaa.» ");
INSERT INTO cmeNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","«Bisãlmba maŋ hũyãa mɛi maama‑i, umaŋ duɔ guɔl unaŋ gbeini bɛi Diiloŋ-hũmelle-na, sũlma haraa kutieŋo-na. Kumaŋ ka haa-yuɔ, kuɔ baa naa to namɛlle u nuoŋgu-na aa sɛ-yo dii-yo nuoraaŋ-nu, kuu naa ce bɔlbɔl yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Da ŋ da ŋ naŋga dii-ni kuubabalaaŋgu cemma-na, kar-ka ŋ nanna. Da ŋ suur Diiloŋ-nelle-na baa naŋga diei, ku bɔyaa ba da ba ka caa-ni baa ŋ nammu‑i mu hãi‑i-na.  ");
INSERT INTO cmeNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Jĩamba maŋ wuyaaŋ nuɔmba‑i terieŋgu-na ba sa ku, aa ku dãamu sa dĩŋ. ");
INSERT INTO cmeNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Da ŋ da ŋ gboluoŋgu dii-ni kuubabalaaŋgu cemma-na, kar-ku ŋ nanna. Da ŋ suur Diiloŋ-nelle-na baa gboluoŋgu diei, ku bɔyaa ba da ba ka caa-ni baa ŋ gbeini‑i ni hãi‑i-na.  ");
INSERT INTO cmeNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Jĩamba maŋ wuyaaŋ nuɔmba‑i terieŋgu-na ba sa ku, aa ku dãamu sa dĩŋ. ");
INSERT INTO cmeNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Da ŋ da ŋ yufelle dii-ni kuubabalaaŋgu cemma-na, hiel-de ŋ nanna. Da ŋ suur *Diiloŋ-nelle-na baa yufelle diei, ku bɔyaa ba da ba ka caa-ni baa ŋ yufieŋa‑i a hãi‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Jĩamba maŋ wuyaaŋ nuɔmba‑i terieŋgu-na ba sa ku, aa ku dãamu sa dĩŋ. ");
INSERT INTO cmeNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","«Na saa da, dãamu ka dii dãmma yiɛ hiere. ");
INSERT INTO cmeNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","«Dãmma‑i bĩŋkũfafaaŋgu; ŋga da ma ji saara, namaa gbãa ce-ma niɛ ma tiraa ce kpɛ̃nnɛ? Diyaaŋ dãmma na fɛrɛŋ nuɔ aa na bel na-naa fafamma.» ");
INSERT INTO cmeNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ku huoŋgu-na, Yesubaa-ba sire terieŋgu-na a kã *Yude, kã ka waa dii *Yurdɛ̃ bomborma namma-na. Nuɔmba tiraa kũɔl ba-naa kã u wulaa. Wuɔ doŋ tuɔ piiye Diiloŋ-nelma‑i u pigãaŋ-ba ŋaa uŋ cemmaŋ dumaa koko. ");
INSERT INTO cmeNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","*Farisĩɛbaa-ba namba ta ba taara ba cure-yuɔ baa nelma‑i, baa piɛ a yuu-yo wuɔ: «A saa baa miɛ Diiloŋ-hũmelle‑i, nɛliɛŋ nuɔ ŋ gbãa nanna ŋ ciɛŋo‑i wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesu wuɔ bir yuu-ba wuɔ: «*Moisi hãa-na hama‑i wuɔ na ta na ce?» ");
INSERT INTO cmeNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Baa cira: «Moisi hãa-ye hũmelle‑i wuɔ i gbãa tiɛ nanna i caamba‑i; ŋga da ŋ'a ŋ nanna-yuɔ ŋ nyɛgɛ̃ŋ sɛbɛ ŋ hã-yo igɛ̃na umaŋ pigãaŋ wuɔ na ãnsorre buɔra.» ");
INSERT INTO cmeNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesu wuɔ cira: «Moisi daa na tũnni sa nu ku'i ciɛ u nyɛgɛ̃ŋ mafamma‑i hã-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Da ma'i sĩ Diiloŋ uŋ'a u jĩna miwaaŋo‑i u maa biɛŋo baa ciɛŋo. ");
INSERT INTO cmeNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","A ce dumaaŋo-na, bibiɛŋo ka yaŋ u bĩncuɔmba‑i aa waa baa u ciɛŋo ");
INSERT INTO cmeNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ba gbonu ce kuuduɔŋgu. Da ba waa dumaaŋo-na, ba sa tiraa kãŋ-ba nuɔmba hãi, ba kãŋ-ba ŋaa nelduɔŋo. ");
INSERT INTO cmeNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Terieŋgu faŋgu-na, Diiloŋ duɔ gbonu kumaŋ, nelbilo saa saaya u bɔrɔ-kuɔ.» ");
INSERT INTO cmeNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Baŋ juɔ kũŋ cĩiŋgu-na, u *hãalãbiemba tiraa sire nel daama‑i ta ba yuu-yo. ");
INSERT INTO cmeNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yesu wuɔ cira: «Umaŋ duɔ nanna u ciɛŋo‑i aa jã unaŋo, kutieŋo ciɛ *fuocesĩnni, u cãlãa cɛdĩɛlãŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ciɛŋo maŋ duɔ bi hel u bɔlɔ wulaa aa kã ka soŋ yaŋga naŋga, ciɛŋo faŋo ciɛ fuocesĩnni'i dumaaŋo-na.» ");
INSERT INTO cmeNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ku huoŋgu-na, baa jo baa bisãmbiemba namba‑i Yesu wulaa wuɔ u ji haa u nammu‑i bɛi a cãrã Diiloŋo‑i hã-ba. U *hãalãbiemba sire ta ba nuola bamaŋ juɔ baa-ba. ");
INSERT INTO cmeNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ku saa dɔlnu Yesu‑i, wuɔ tuɔ piiye baa-ba wuɔ: «Yaaŋ bisãlmba ta ba jo mi wulaa, baa na cie-ba. Bamaŋ dii bafamba temma‑i, *Diiloŋ-nelle dii bafamba diele‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Yaaŋ mi waŋ ninsoŋo‑i baa-na: Umaŋ duɔ u saa siɛ *Diiloŋ-nellentesĩnni‑i ŋaa bisãlãaŋo, kutieŋo siɛ gbãa suur *Diiloŋ-nelle-na.» ");
INSERT INTO cmeNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ku huoŋgu-na, wuɔ tũu bisãlŋ daaba‑i aa haa u nammu‑i bɛi aa cãrã Diiloŋo‑i hã-ba. ");
INSERT INTO cmeNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ku huoŋgu-na, Yesu‑i baa u *hãalãbiemba sire biɛ hũmelle‑i ta ba kã. Naacolŋo naŋo gbar jo ji dũuna Yesu yaaŋga-na aa cira: «Hãalãtiefɛfɛi, mi saaya mi ce bige‑i da mi gbãa da cicɛ̃lma maŋ sa tĩɛŋ dede‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu wuɔ cira: «Bige‑i ciɛ ŋ ta ŋ bĩ-mi nelfɛfɛiŋ muɔ? Da ma hel Diiloŋo-na, nelfɛfɛiŋo dii wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Diiloŋ uŋ'a i tiɛ wuɔ hũmieŋa maŋ, ma sĩ ŋ suɔ-ya kɛ? ‹Baa ko nɛliɛŋo, baa ce *fuocesĩnni‑i, baa cuo, baa kar coima ŋ haa moloŋ-na, baa du moloŋo, ta ŋ dii ŋ to‑i baa ŋ nyu‑i ba nuŋgu‑i.›» ");
INSERT INTO cmeNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Naacolŋ wuɔ cira: «Hãalãtie, mi duɔŋ dii mi bisãnsĩnniŋ ta mi ce mafamma‑i hiere.» ");
INSERT INTO cmeNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Uŋ piiye dumaaŋo-na, u maama gbuu pãŋ dɔlnu Yesu‑i; wuɔ ne-yo aa naa cira: «Ma tĩyãa ma diei: Kã ŋ ka suor ŋ nagãŋ-niini‑i hiere aa ŋ cal gbeiŋa faŋa‑i ŋ hã sũntaamba baa-ya, ku yaa ŋ ka ce wɛiŋ nuɔ dɔrɔ‑i-na. Da ŋ ce mafamma‑i, ŋ jo ŋ ji ta ŋ nyaanu-miɛ.» ");
INSERT INTO cmeNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Naacolŋ daayo naa silaa waa wɛiŋo cor. Yesuŋ juɔ waŋ mafamma‑i, wuɔ pãŋ vãa u yaaŋga‑i aa ta. ");
INSERT INTO cmeNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Uŋ taa, Yesu wuɔ wuɔra ne u hãalãbiemba‑i aa cira: «Kumaŋ ka ce wɛiŋo duɔ gbãa suur *Diiloŋ-nelle-na kuu dii kpelle.» ");
INSERT INTO cmeNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Nel daama cu u hãalãbiemba hɔmmu‑i. Yesu wuɔ tiraa tir-ma wuɔ: «Mi jɛ̃naaŋ namaa, Diiloŋ-nelle suurma dii kpelle dɛ! ");
INSERT INTO cmeNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Na suyaa wuɔ nyɔgɔ̃mɛ duɔ gbãa cor misɛ̃nɛ-fuoŋgu-na kuu dii kpelle dɛ! Ŋga wɛiŋo duɔ gbãa suur Diiloŋ-nelle-na kufaŋgu dii kpelle yaŋ.» ");
INSERT INTO cmeNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Nel daama migãaŋ cu u hãalãbiemba hɔmmu‑i. Baa ta ba yuu ba-naa wuɔ: «Dumaaŋo-na, hai moloŋo‑i ka gbãa kor?» ");
INSERT INTO cmeNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu wuɔ ne-ba aa cira: «Nelbiliemba wulaa ma siɛ gbãa ce, ŋga wɛima sa yar Diiloŋo‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Piɛr wuɔ cira: «Hãalãtie, aa miɛ maŋ naana i wɛima‑i hiere aa tiɛ nyaanu-niɛ fuɔ?» ");
INSERT INTO cmeNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu wuɔ cira: «Mi waŋ ninsoŋo‑i baa-na: Umaŋ duɔ ta aa yaŋ u dumɛlle‑i, u hãmba‑i, u mɔlbaa-ba‑i, u tũɔbaa-ba‑i, u nyu‑i, u to‑i, u bisãlmba‑i, sisɔ u sonni‑i mɛi maama-na baa *Neldɔdɔlma maama-na, ");
INSERT INTO cmeNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","kutieŋ uŋ ka da nimaŋ hĩɛma-na bande‑i-na, ni ka maar uŋ taa aa yaŋ nimaŋ sɔmma komuɔŋa ndii. U ka da dumiɛŋa‑i, hãmba‑i, mɔlãamba‑i, nyunaamba‑i, bisãlmba‑i, sonni‑i, aa bi da mulĩɛma‑i naara. Aa bisĩnuɔ‑i-na, u ka da cicɛ̃lma maŋ sa tĩɛŋ dede‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Na saa da, bamaŋ taa yaaŋga fiɛfiɛ‑i-na, ba bɔi ka bir waa huoŋ-nu, aa bamaŋ dii huoŋgu-na fiɛfiɛ‑i-na, ba bɔi ka ta yaaŋga.» ");
INSERT INTO cmeNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ku huoŋgu-na, Yesubaa-ba ji sire ta ba kã *Yerusalɛmu. Yesu wuɔ ta nuɔmba yaaŋ-na hiere. Baŋ kãŋ dumaaŋo-na, korma doŋ ta ma da u *hãalãbiemba‑i baa bamaŋ naa cuu ba huoŋ-nu hiere. Yesu wuɔ bĩ u hãalãbieŋ cĩncieluo ba hãi baamba‑i ba deŋ ka tuɔ piiye baa-ba wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","«Na daa iŋ kãŋ Yerusalɛmu-na kɛ? Diɛ kã, ba ka bel *Moloŋ-Biɛŋo‑i hã *Diilojigãntaamba yuntaamba‑i baa *ãnjĩnamma pigãataamba‑i baa-yo. Da ba hã-ba baa-yo, ba ka cira wuɔ u saaya komma aa bir-o hã *niɛraamba‑i baa-yo ");
INSERT INTO cmeNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ba nyɛ-yo sũlma aa tu taalni yuɔ aa muo-yo aa suɔ ko-yo. Da ba ko-yo, u ka ce yinni hãi hĩɛma-na, siɛliŋ-yiiŋgu‑i u ka sire hel jo.» ");
INSERT INTO cmeNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ku huoŋgu-na, Sebede bɛmba maŋ waa baa Yesu‑i, ba taa ba bĩ unaŋo‑i Sake aa bĩ unaŋo‑i Nsãa, baa piɛ Yesu caaŋ-nu ka cira: «Hãalãtie, i juɔ diɛ ji cãrã bĩŋkũŋgu naŋgu ŋ wulaa, jande baa yagar.» ");
INSERT INTO cmeNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesu wuɔ yuu-ba wuɔ: «Na'a mi ce bige‑i hã-na?» ");
INSERT INTO cmeNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Baa cira: «I taara da ŋ ji waa ŋ fɔ̃ŋgũɔ‑i-na, ŋ yaŋ miɛŋo‑i, u diei tĩɛna ŋ nadieyaŋga-na aa u diei bi tĩɛna ŋ nanyuɔyaŋga-na.» ");
INSERT INTO cmeNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesu wuɔ cira: «Na saa suɔ naŋ cãrãŋ kumaŋ dɛ! Yaahuolo maŋ ka haa-miɛ na ka siɛ u temma haa-nɛi wɛi? Na ka siɛ mulĩɛŋ mɛi temma‑i wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Baa cira: «Ũu, i ka siɛ.» Yesu wuɔ cira: «Yaahuolo maŋ ka haa-miɛ, baa mulĩɛma maŋ ka bi haa-miɛ, ni ka bi haa-nɛi ninsoŋo. ");
INSERT INTO cmeNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ŋga mɛi siɛ gbãa pã nuŋgu wuɔ mɛlŋo'i ka tĩɛna mi nadieŋga-na aa mɛlŋo'i ka tĩɛna mi nanyuɔŋgu-na. Muntĩɛnammu fammuŋ tigiiŋ ta mu cie bamaŋ, ba yaa ka da-mu.» ");
INSERT INTO cmeNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ba nahãalãbieŋ cĩncieluo baambaŋ juɔ nu nel daama‑i, ba hɔmmu pãŋ du baa-ba. ");
INSERT INTO cmeNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesu wuɔ bĩ-ba hiere a ji tuɔ piiye baa-ba wuɔ: «Na suyaa wuɔ fãamaambaa-ba ce hãlmaaŋgu baa ba fãamaansĩnni‑i aa nelbɔ̃mbɔ̃mbaa-ba ta ba haa fɔ̃ŋgũɔ‑i nuɔmba-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ŋga ku saa saaya ku waa dumaa namaa na wulaa. Umaŋ duɔ tuɔ taara u waa nelbuɔ‑i na hɔlma-na, kutieŋo saaya u ce u fɛrɛ na maacembiloŋo; ");
INSERT INTO cmeNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","aa umaŋ duɔ tuɔ taara yaaŋga‑i, kutieŋo saaya u ce u fɛrɛ na kɔriɛŋo. ");
INSERT INTO cmeNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Na saa da, *Moloŋ-Biɛŋo juɔ kufaŋgu jomma yaa‑i hĩɛma-na duɔ ji cãa nuɔmba‑i aa pã u fɛrɛ duɔ sãa ba bɔi yunni; u saa jo ba da ba ji cãa-yo.» ");
INSERT INTO cmeNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ku huoŋgu-na, Yesu wuɔ kã ka hi Yeriko. A ne da nelpũŋgu naŋ temma taa ku nyaanu-yuɔ a naara u *hãalãbiemba‑i. Baŋ juɔ ta ba hel Yeriko‑i-na da ba ta, yiroŋo naŋo waa tĩɛna hũmelle tũŋgu-na tuɔ cãrã. Ba taa ba bĩ-yo Bartime aa bĩ u to‑i Time. ");
INSERT INTO cmeNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Yiroŋ daa uŋ nuɔ nuɔmba piiye ba cor, wuɔ yuu. Baa cira wuɔ Nasarɛtitaaŋ Yesu yaa curaaŋ. Wuɔ pãŋ sire tuɔ fara u bĩ da gbagaga wuɔ: «Yesu, *Davidi hãayɛ̃lŋ nuɔ, jande ce hujarre miɛ!» ");
INSERT INTO cmeNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Uŋ faraŋ u bĩ dumaaŋo-na, nuɔmba bɔi baa yaŋ aa ta ba nuola-yuɔ wuɔ u budii. Wuɔ migãaŋ dii kunaŋgu naara wuɔ: «Davidi hãayɛ̃lŋ nuɔ, jande ce hujarre miɛ!» ");
INSERT INTO cmeNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesu wuɔ yiɛra aa naa cira: «Bĩɛŋ u jo.» Baa cira: «U bĩ-ni, fɛ̃ ŋ huɔŋga‑i aa ŋ sire ŋ kã.» ");
INSERT INTO cmeNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Yiroŋ wuɔ pãŋ nanna u joŋgoruo‑i aa tie sire ta tuɔ kã. ");
INSERT INTO cmeNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Uŋ kaa hi, Yesu wuɔ yuu-yo wuɔ: «Ŋ taara mi ce bige‑i hã-ni?» Wuɔ cira: «Hãalãtie, mi taara ŋ puur mi yufieŋa‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesu wuɔ cira: «Kã! Niŋ haa ŋ naŋga‑i miɛ, ŋ kuraa.» Terduɔŋgu faŋgu-na, naacolŋo yufieŋa pãŋ puur. Wuɔ cu Yesu huoŋ-nu ba ta ba kã. ");
INSERT INTO cmeNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yesubaa-baŋ kaa ta ba piɛ *Yerusalɛmu‑i, a saanu baa nilɛiŋa naŋa hɔlma‑i, dii *Olivi-tibinni-tãnuŋgu-na, ba bĩ dinande‑i Betifage aa bĩ dinande‑i Betani. Yesu wuɔ waŋ baa u *hãalãbiemba hãi wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","«Kãaŋ nelle maŋ i yaaŋga-na daade‑i, na suurma‑i, na ka da ba vaa kakũmbiloŋo naŋo, molo saa nyugũŋ-yuɔ dede. Na fir-o na jo baa-yo. ");
INSERT INTO cmeNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Umaŋ duɔ yuu-na, na cira: ‹Itieŋo yaa wuɔ i ji fir-o ka hã-yo; wuɔ u ka bir jo baa-yo fiɛfiɛ.›» ");
INSERT INTO cmeNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Baa kã ka bi da ba vaa kakũmbiloŋo naŋo‑i dumɛlle nande yaaŋga-na; hũmelle tũŋgu-na. Baa ture ta ba fir-o. ");
INSERT INTO cmeNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Nuɔmba waa, banamba ta ba piiye baa-ba wuɔ: «Haba‑i daaba‑i! Na ce bige‑i dumaaŋo-na?» ");
INSERT INTO cmeNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Yesuŋ waaŋ mamaŋ baa-ba, baa bi waŋ ma yaa‑i baa-ba. Baŋ piiye dumaaŋo-na, baa yaŋ ba ta baa-yo. ");
INSERT INTO cmeNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Baŋ kãa baa-yo, baa hiel ba joŋgorbaa-ba‑i haa u huoŋgu-na aa Yesu wuɔ nyugũŋ tĩɛna-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Nuɔmba fɔ̃ŋgũɔ baa hiel ba joŋgorbaa-ba‑i fara-bɛi hũmelle-na Yesu tuɔ wuɔ ba dɔrɔ u kã. Banamba kar fiɛlu ta ba jĩna. ");
INSERT INTO cmeNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Bamaŋ waa u yaaŋga-na baa u huoŋgu-na hiere baa ta ba piiye da gbagaga wuɔ: «Diiloŋo temma si dii. Itieŋ uŋ saaŋ umaŋ jo, Diilo baa-yo! ");
INSERT INTO cmeNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","I bĩncɔiŋo‑i *Davidi fɔ̃ŋgũɔ temma yaa juɔŋ! Diilo migãaŋ-yo hã-ye. Dɔrwuoŋo temma si dii!» ");
INSERT INTO cmeNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesuŋ kaa suur Yerusalɛmu‑i-na, wuɔ kã *Diilodubuɔ‑i-na ka wuɔra ne kumaŋ ciɛŋ hiere. Bãaŋgu naa tĩ tĩ, wuɔ ta baa u hãalãbieŋ cĩncieluo ba hãi baamba‑i a kã Betani. ");
INSERT INTO cmeNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ku cuo kaala‑i-na, Yesubaa-ba sire Betani‑i-na ta ba kã *Yerusalɛmu‑i-na, a ne da nyulmu waa Yesu‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ba kaa hi hɔlma namma‑i, wuɔ da *yensãaŋgu naŋgu fiɛlu gbu caa da fafamma ŋaa ku maaŋ, a ne da ku mammaŋ-huɔŋgu'i saa waa huɔŋgu faŋgu-na. Yesu wuɔ haar duɔ ka ne sĩ u ka da bieŋa kuɔ. Uŋ kaa piɛ, wuɔ da fiɛgbãŋgbãŋlãndu yoŋ du kula. ");
INSERT INTO cmeNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Wuɔ gbɛ̃ yensãaŋgu‑i u *hãalãbiemba yufelle-na wuɔ: «Ma bãlãa nyuŋgo; naŋ cɛraa ŋ ji maŋ bieŋa hã molo wuo.» ");
INSERT INTO cmeNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yesubaa-baŋ kaa hi *Yerusalɛmu‑i, wuɔ kã *Diilodubuɔ‑i-na ka donya niisuornintaamba‑i baa niisãanintaamba‑i hiere hiel-ba. Aa kã ka tisĩŋ gbeihortaamba taabalebaa-ba‑i nanna, aa sɛ bamaŋ suoraaŋ nɔnsɔr ba huriimba‑i ba titiɛŋa‑i nanna, ");
INSERT INTO cmeNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","aa cie-ba wuɔ molo baa suur baa kuusuorŋgu Diilodubuɔ dumɛlle-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Uŋ ciɛ mafamma‑i, wuɔ biɛ Diiloŋ-nelma‑i tuɔ piiye u pigãaŋ-ba wuɔ: «Ma nyɛgãaŋ Diiloŋ-nelma-na wuɔ: ‹Ba ka ta ba bĩ mi dũŋgu‑i nilɛiŋa‑i hiere a Diilojaaldũŋgu.› Ma sĩnni niɛ namaa ce-ku cuo ba terieŋgu?» ");
INSERT INTO cmeNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Nel daama kã ka hi *Diilojigãntaamba yuntaamba‑i baa *ãnjĩnamma pigãataamba‑i. Baa pãŋ ta ba taara-yuɔ baa komma. A ne da u nelma taa ma suurnu nuɔmba‑i ma cor, a ce dumaaŋo-na ba taa ba kãalã-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Bãaŋguŋ juɔ suur huɔŋgu maŋ nuɔ‑i, Yesu‑i baa u *hãalãbieŋ baa hel nelleŋ-huɔŋga-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ku cuo kaala‑i-na, Yesu‑i baa u *hãalãbiemba naar sire biɛ hũmelle‑i. Baŋ kaa hi *yensãaŋgu terieŋgu‑i, ba'a ba ne da ku kuolaa baa ku yuŋgu‑i hiere. ");
INSERT INTO cmeNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Mamaŋ ciɛ cor hiere ba kãmma-na *Yerusalɛmu‑i-na, maa tĩɛnu Piɛr. Wuɔ tuɔ piiye baa Yesu‑i wuɔ: «Hãalãtie, ne, niŋ waasaaŋ yensãaŋgu maŋ, ku kuolaa hiere.» ");
INSERT INTO cmeNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesu wuɔ gbɛ̃-ba wuɔ: «Haaŋ na naŋga‑i Diiloŋo-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Yaaŋ mi waŋ ninsoŋo‑i baa-na: Da na haa na naŋga‑i Diiloŋo-na, na gbãa gbɛ̃ tãnuŋ daaku‑i wuɔ: ‹Juur ŋ halaŋ bande‑i-na ŋ ka suur nuoraaŋgu-na›, aa ma bi ce. Ŋga naŋ waaŋ mamaŋ, da na saa hũu-ma wuɔ ma gbãa ce, ma siɛ bi ce. ");
INSERT INTO cmeNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ku'i ciɛ mi ta mi piiye baa-na miɛ: Da na ta na cãrã kumaŋ Diiloŋo wulaa, na saaya na hũu-ma wuɔ na daa ku bĩŋkũŋgu‑i tĩ. Da na hũu-ma, ku yaa Diiloŋo ka hã-na baa-ku. ");
INSERT INTO cmeNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Aa da ŋ'a ŋ cãrã Diiloŋo‑i, a ji ne da molo cãlãa-ni, ce kutieŋo‑i jande aa ŋ hiel-ma ŋ huɔŋga-na, ku yaa nuɔ niŋ ciɛ mamaŋ, na To maŋ dɔrɔ‑i-na u ka bi ce-ni jande aa hiel-ma u huɔŋga-na.  ");
INSERT INTO cmeNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ŋga da na'a na sa hiel nuɔŋ-maama‑i na hɔmmu-na, na To maŋ dɔrɔ‑i-na, u siɛ bi hiel namaa maama‑i u huɔŋga-na.» ");
INSERT INTO cmeNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yesubaa-baŋ kaa hi *Yerusalɛmu‑i, baa kã *Diilodubuɔ‑i-na. Yesu wuɔ tuɔ wuɔra u bĩŋ dumɛlleŋ-huɔŋga-na. *Diilojigãntaamba yuntaamba‑i, baa *ãnjĩnamma pigãataamba‑i a naara nelle bĩncuɔmba sire jo u wulaa ");
INSERT INTO cmeNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ji yuu-yo wuɔ: «Niŋ ceŋ mamaŋ daama‑i, hai moloŋo‑i hãa-ni hũmelle‑i ŋ ta ŋ ce-ma?» ");
INSERT INTO cmeNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesu wuɔ cira: «Mi ka bi yuu-na baa nelma diei, da na siɛ-mi, mi ka pigãaŋ-na umaŋ hãa-mi hũmelle‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Aa naa yuu-ba wuɔ: «Hai moloŋo‑i naa puɔr Nsãa jo ji tuɔ *batiseŋ nuɔmba‑i? Diiloŋo'i naa puɔr-o waa nelbiliemba'i naa puɔr-o?» ");
INSERT INTO cmeNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Baa doŋ ta ba piiye baa ba-naa wuɔ: «Diɛ cira Diiloŋo'i puɔraa-yo, u ka cira: ‹Naŋ suyaa-ma dumaaŋo-na bige‑i ciɛ na saa hũu u nelma‑i?› ");
INSERT INTO cmeNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","I siɛ bi siɛ cira nelbiliemba'i puɔraa-yo.» Nuɔmba‑i hiere baa suyaa wuɔ Nsãa waa *Diilopɔpuɔrbiloŋo, da ŋ da ba ciɛra nelbiliemba'i puɔraa-yo, maacemma haraa-bɛi. ");
INSERT INTO cmeNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Baa naa ba cira: «I saa suɔ moloŋo maŋ naa puɔr-o.» Yesu wuɔ bi cira: «Muɔ mi siɛ bi pigãaŋ-na umaŋ hãa-mi hũmelle‑i mi ta mi ce miŋ ceŋ mamaŋ daama‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ku huoŋgu-na, Yesu wuɔ biɛ gbãnɛini tuɔ naŋ baa-ba wuɔ: «Naacolŋo naŋo diyaa *ɛrɛsɛ̃-suoŋgu aa kalla-kuɔ. Uŋ kalaaya-kuɔ, u hĩŋ fuoŋgu ba da ba ta ba kãmal ɛrɛsɛ̃‑i, aa ce felge ba ta ba nyugũŋ ba niya suoŋgu‑i. Uŋ ciɛ mafamma‑i, u biɛ maacenciraamba jĩna-kuɔ aa ta kã nelle. ");
INSERT INTO cmeNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","«Tibibieŋa karmaŋ juɔ hi, wuɔ puɔr u maacembiloŋo naŋo‑i maacenciraamba wulaa, wuɔ u ji hũu fuɔ yufelle‑i ka hã-yo. ");
INSERT INTO cmeNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Maacembiloŋ uŋ juɔ, maacenciraamba bel-o muo-yo aa bir-o ba saa hã-yo bĩŋkũŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","U tiraa puɔr maacembiloŋo naŋo ba wulaa. Baa muo ufaŋo‑i kaasĩnya-yuɔ aa naa tuora-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","U tiraa puɔr maacembiloŋo naŋo ba wulaa. Baa ko ufaŋo‑i. Ba muyaa ba fɔ̃ŋgũɔ aa ko ba fɔ̃ŋgũɔ. ");
INSERT INTO cmeNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Maacembiemba ji tĩ suontieŋo wulaa aa ku tĩɛ u bɛduɔla yaa‑i. U cira: ‹Fiɛfiɛ fuɔ, mi ka puɔr mi bɛduɔla yaa ba wulaa. Fuɔ duɔ kã, ba ka kãŋ-yo.› Aa ce bɛpolŋo sire ta. ");
INSERT INTO cmeNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Maacenciraambaŋ juɔ'a ba ne da bɛpolŋo jo, baa ta ba piiye baa ba-naa wuɔ: ‹Ciiluwuotieŋo yaa juɔŋ daayo, yaaŋ duɔ jo i ko-yo aa ciiluŋgu ce miɛ kũŋgu.› ");
INSERT INTO cmeNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ba siire ku yaa nuɔ‑i, naacombiloŋ uŋ hii, a bel-o ko-yo, aa hel baa-yo suoŋgu-na ka nanna.» ");
INSERT INTO cmeNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yesu wuɔ cira: «Namaa wulaa, suontieŋ daa u ka ce bige‑i fiɛfiɛ‑i-na? U ka jo ji ko maacenciraaŋ daaba‑i aa hã banamba baa suoŋgu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Na saa kalaŋ nel daama‑i Diiloŋ-nelma-na wɛi wuɔ: ‹Dũmarãambaŋ cĩinaana kpãŋkpara maŋ, u yaa juɔ bella dũŋgu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ku ciɛ nerma miɛ i wulaa. Itieŋo yaa wuɔ ma ce dumaaŋo-na.›» ");
INSERT INTO cmeNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","*Yuifu ba yuntaamba pãŋ suɔ wuɔ Yesu naaŋ gbãnalãaŋ daaku‑i hã ba yaa‑i. Baa ta ba taara ba bel-o. A ne da ba taa ba kãalã nuɔmba‑i, baa naa ba yaŋ-yo aa ta. ");
INSERT INTO cmeNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ku huoŋgu-na, baa ji puɔr *Farisĩɛbaa-ba namba‑i baa *Erɔdi baamba namba‑i Yesu wulaa, wuɔ ba ka gbãŋ baa-yo bel-o fuɔ fɛrɛŋ nuŋ-ãndaaŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Baŋ kãa, baa cira: «Hãalãtie, i suyaa wuɔ ŋ waŋ ninsoŋo yaa‑i, ŋ sa kãalã nɛliɛŋo baa ŋ ninsoŋo‑i, ŋ sa bi ce ciɛluɔ. Ŋ gbu ŋ pigãaŋ nuɔmba‑i Diiloŋ-hũmelle yaa kelkel.» Aa naa yuu-yo wuɔ: «A saanu baa miɛ hũmelle‑i, ku saaya i tiɛ pã nampo‑i i hã *Oromɛ ba *jãmatigi‑i wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Yesu wuɔ suɔ baa-ba. Wuɔ gbɛ̃-ba wuɔ: «Na taara na cure muɔmɛi wɛi? Hãa-miŋ warbelle mi ne.» ");
INSERT INTO cmeNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Baa hã-yo warbelle‑i. Wuɔ yuu-ba wuɔ: «Ba ciɛ hai yuŋgu‑i diɛ?» Baa cira: «Ba ciɛ Oromɛ ba jãmatigi yuŋgu.» Wuɔ tiraa yuu-ba wuɔ: «Ba nyɛgãaŋ hai yerre‑i diɛ?» Baa cira: «Ba nyɛgãaŋ Oromɛ ba jãmatigi yerre'i diɛ.» ");
INSERT INTO cmeNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yesu wuɔ cira: «Kumaŋ da ku waa jãmatigi kũŋgu‑i, pãaŋ-kuŋ na hã jãmatigi‑i baa-ku, aa kumaŋ da ku bi waa Diiloŋ-kũŋgu‑i, na bi pã-ku na hã Diiloŋo‑i baa-ku.» U kũŋ kuɔ cu ba hɔmmu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","*Sadusĩɛbaa-ba wulaa kuomba siɛ sire. Banaŋ baa kã ka gbɛ̃ Yesu‑i wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«Hãalãtie, *Moisi nyɛgãaŋ nelma namma hã-ye wuɔ: ‹Umaŋ duɔ saa da biloŋo baa u ciɛŋo‑i aa ku aa yaŋ-yo, u hãaŋo saaya u biɛ-yo a hoŋ biloŋo hã kuloŋo‑i.› ");
INSERT INTO cmeNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","A ne da naacombiemba namba waa niehãi ba nyu wulaa. Mɔlŋo sire jã ciɛŋo, u saa da biloŋo baa-yo aa ku. ");
INSERT INTO cmeNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Umaŋ cuu-yo, u biɛ ciɛŋo‑i u saa da bisãlmba baa-yo, fuɔ u ku aa yaŋ-yo. Siɛliŋ-wuoŋo‑i maaduɔma. ");
INSERT INTO cmeNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ba kuu dumɛi ka gbuo hiere unaa saa ji da biloŋo baa ciɛŋ daayo‑i. Ku huoŋgu-na, ciɛ fuɔ fɛrɛ suɔ tuɔ nyaanu-bɛi. ");
INSERT INTO cmeNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ba hieroŋo-na baŋ diyaa-yo ba ciɛŋo cor, kuoŋ da ba ji sire, u ka ce hai wuoŋo‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu wuɔ cira: «Na piɛra. Aa na suyaa kumaŋ ciɛ na pira wɛi? Na saa suɔ Diiloŋ-nelma‑i, aa na saa bi suɔ u himma‑i ku'i ciɛ. ");
INSERT INTO cmeNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Na saa da, kuoŋ da ba ji sire, cadiile siɛ waa. Ba ka waa ŋaa *dɔrpɔpuɔrbiemba. ");
INSERT INTO cmeNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Kumaŋ ŋaa kuomba siremmaŋ-kũŋgu‑i, Moisiŋ piiye dãamu naŋ bilaa pɛrfiɛlu maŋ du maama‑i Diiloŋ-nelma-na terieŋgu maŋ nuɔ‑i, na saa kalaŋ ku terieŋgu‑i wɛi? Ma nyɛgãaŋ terieŋgu-na wuɔ: Diiloŋo gbĩɛ Moisi‑i wuɔ: ‹*Abiramu Diiloŋo yaa muɔŋo‑i, *Isaki Diiloŋo yaa muɔŋo‑i, *Yakɔbu Diiloŋo yaa muɔŋo‑i.› ");
INSERT INTO cmeNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ku pigãaŋ wuɔ Diiloŋo‑i cicɛ̃lmantaaŋ-wuoŋo, bikuoŋ-wuoŋo sĩ. Na piɛra bɔi.» ");
INSERT INTO cmeNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","*Ãnjĩnamma pigãatieŋo naŋ uŋ daa Yesu suyaa *Sadusĩɛbaa-ba siɛma, wuɔ piɛ u caaŋ-nu a yuu-yo wuɔ: «Diiloŋ uŋ ciɛra i tiɛ wuɔ hũmieŋa maŋ hiere, hade‑i yuŋgu?» ");
INSERT INTO cmeNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu wuɔ cira: «Hũmelle maŋ yuŋgu, di yaa daade: ‹*Isirahɛl-baaŋ namaa, karaaŋ na tũnni‑i! Diiloŋo yaa Itieŋo‑i u diei yoŋ. ");
INSERT INTO cmeNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ŋ saaya ŋ dɔl Itieŋo‑i Diiloŋo‑i baa ŋ huɔŋga‑i hiere, baa ŋ kusũŋgu‑i hiere, baa ŋ ãnjɔguɔma‑i hiere, baa ŋ fɔ̃ŋgũɔ‑i hiere.› ");
INSERT INTO cmeNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Mamaŋ cuu mafamma‑i ma yaa daama: ‹Ŋ saaya ŋ dɔl ŋ nanolŋo‑i ŋaa niŋ dɔl ŋ fɛrɛ dumaa.› Diiloŋ uŋ'a i tiɛ wuɔ hũmieŋa maŋ hiere, a hãi-waaŋ daaya yaa yuŋgu.» ");
INSERT INTO cmeNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ãnjĩnamma pigãatieŋ wuɔ cira: «Hãalãtie, ŋ waaŋ ninsoŋo, Diiloŋo dii u diei yoŋ, unaŋo si dii yaŋga naŋga. ");
INSERT INTO cmeNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Terieŋgu faŋgu-na, ku saaya nɛliɛŋo nɛliɛŋo, u dɔl-o baa u huɔŋga‑i hiere, baa u ãnjɔguɔma‑i hiere, baa u fɔ̃ŋgũɔ‑i hiere; aa u saaya u dɔl u nanolŋo‑i ŋaa uŋ dɔl u fɛrɛ dumaa. Kufaŋgu bɔyaa tãmmaŋ-niini pãmma-na.» ");
INSERT INTO cmeNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesu wuɔ ne da u siyaa-yo baa cɛ̃cɛ̃muŋgu. Wuɔ cira: «Ŋ saa maa baa *Diiloŋ-nelle‑i.» A hel mafamma-na, molo saa tiraa siɛ yuu-yo baa wɛima. ");
INSERT INTO cmeNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ku huoŋgu-na, Yesu wuɔ biɛ Diiloŋ-nelma‑i tuɔ piiye u pigãaŋ nuɔmba‑i *Diilodubuɔ‑i-na aa ji yuu-ba wuɔ: «Bige‑i ciɛ Diiloŋ uŋ pãa nuŋgu‑i aa saaŋ *Koŋkortieŋo maŋ, *ãnjĩnamma pigãataamba ta ba piiye wuɔ u ka waa *Davidi hãayɛ̃lŋo? Ba taara ba waŋ wuɔ niɛ dumaaŋo-na? ");
INSERT INTO cmeNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ma sĩ Davidi fuɔ fɛrɛ‑i, *Diiloŋ-Yalle ciɛ u nyɛgɛ̃ŋ-ma wuɔ: ‹Itieŋo gbĩɛ mi Tieŋo‑i wuɔ: «Jo ŋ ji tĩɛna mi caaŋ-nu aa ŋ yaŋ mi mal ŋ bigãarãamba‑i hã ŋ ce ŋ bãaŋgu‑i bɛi.»› ");
INSERT INTO cmeNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","«Diiloŋ uŋ pãa nuŋgu‑i aa saaŋ Koŋkortieŋo maŋ, Davidi fuɔ fɛrɛ bĩ-yo u Tieŋo, u ce niɛ aa ce u hãayɛ̃lŋo yoŋ?» Nuɔmba bɔi waa ta ba nu Yesu tuɔ piiye. U nelma taa ma dɔlnu-bɛi ma cor. ");
INSERT INTO cmeNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Wuɔ tuɔ piiye baa-ba wuɔ: «Bilaaŋ na fɛrɛ, baa na ta na ce *ãnjĩnamma pigãataamba temma‑i, ba maacemma saa fa: Ba hinu ba dii joŋgorbɔ̃mbɔ̃mbaa, aa da ba waa nuɔmba-na, ba taara ba ta ba piɛ ba jaal-ba. ");
INSERT INTO cmeNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Da ba suur *Diilonelhãalãdũŋgu-na, sisɔ da ba kã kãlle maŋ nuɔ‑i, ba taara ba tĩɛna yaaŋ-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Da ba ce ba bel diiloŋo‑i a hũu bikulcaamba nagãŋ-niini‑i wuo-ni, a ne da da ba'a ba cãrã Diiloŋo‑i ba cãrã-yuɔ da agaga wuɔ nuɔmba cira bafamba faa. Kumaŋ ka haa-bɛi, ku ka balaŋ cor.» ");
INSERT INTO cmeNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ku huoŋgu-na, Yesu wuɔ kã ka tĩɛna kekerieŋgu caaŋgu-na *Diilodubuɔ‑i-na tuɔ ne nuɔmba ta ba dii ba gbeiŋa‑i ba hã Diiloŋo‑i. Waamba bɔi taa ba kã ba dii gbeibɔ̃mbɔ̃mbaa. ");
INSERT INTO cmeNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Bikulcɛsũntieŋo naŋo jo ji dii tãmabieŋa hãi. ");
INSERT INTO cmeNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yesu wuɔ bĩ u *hãalãbiemba‑i a tuɔ piiye baa-ba wuɔ: «Yaaŋ mi waŋ ninsoŋo‑i baa-na: Ciɛŋ daa uŋ diyaa kumaŋ, ku maaraa banambaŋ diyaa kumaŋ hiere. ");
INSERT INTO cmeNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Bafamba paraa dii aa yaŋ boluoŋgu; ŋga ciɛŋ daa uŋ diyaa kumaŋ, ku yaa waa u yuŋgu-na yoŋ; kunaŋgu si dii yaŋga naŋga.» ");
INSERT INTO cmeNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesuŋ juɔ tuɔ hel *Diilodubuɔ‑i-na, u *hãalãbiloŋo naŋo tuɔ piiye baa-yo wuɔ: «Hãalãtie, ne dubuɔ daayo temma‑i! Ne baŋ maa-yo baa tãmpĩɛŋa maŋ! A faa cor!» ");
INSERT INTO cmeNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesu wuɔ cira: «Ŋ daa dũŋgu maŋ daaku‑i kɛ? Yiiŋgu dii baa yiiŋgu ku ka fara hiere hĩɛma-na!» ");
INSERT INTO cmeNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Baŋ kaa hi *Olivi-tibinni-tãnuŋgu‑i, Yesu wuɔ tĩɛna bir u yaaŋga‑i *Diilodubuɔ‑i-na. A ne da huɔŋgu faŋgu-na, Piɛr baa Sake baa Nsãa, a naara Ãndere, ba yaa waa baa-yo yoŋ. Baa yuu-yo wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«Hãalãtie, niŋ waaŋ nelma maŋ daama‑i, ma ka ce yaku‑i? Aa i ka ce niɛ suɔ ma cemmaŋ-huɔŋgu‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesu wuɔ cira: «Gbãaŋ molo baa ji pira-nɛi. ");
INSERT INTO cmeNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Nuɔmba bɔi ka jo ji biɛ mi yerre‑i ce-de bafamba diele. Umaŋ duɔ jo, u ka cira wuɔ Diiloŋ uŋ pãa nuŋgu‑i wuɔ u ka saaŋ *Koŋkortieŋo maŋ, u yaa ufaŋo‑i. Ba ka pira nuɔmba bɔi. ");
INSERT INTO cmeNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Da na ji da bɛrru ce terni-na hiere, baa na tie holle. Mafamma saaya ma ce, ŋga miwaaŋo tĩmma'i siɛ pãŋ waa huɔŋgu faŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Nuɔmba kaa ta ba gãŋ siyaabaa siyaabaa, baa nilɛiŋa nilɛiŋa. Hĩɛma kaa ta ma wuɔra ma sagalla. Nyulmu kaa bi waa. Nifanni‑i daani‑i hiere hãaŋo. Ku domma'i dumaaŋo-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","«Namaaŋo‑i, mi ka gbuya-nɛi jĩna. Ba ka bĩ-na fãamaambaa-ba wulaa. Ba ka muo-na *Diilonelhãalãdũnni-na. Ba ka kã baa-na fɔ̃ŋgɔ̃taamba wulaa, baa nellentaamba wulaa mɛi maama-na. Huɔŋgu faŋgu'i nuɔ‑i na ka da na fɛrɛ piiye mi maama‑i baa-ba. ");
INSERT INTO cmeNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Aa miwaaŋo suɔ duɔ tĩ, nuɔmba‑i nilɛiŋa-na hiere ba saaya ba nu *Neldɔdɔlma‑i ka saa. ");
INSERT INTO cmeNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Da ba ji bel-na ta ba kã baa-na fãamaambaa-ba wulaa, baa na tie holle wuɔ na siɛ ka suɔ naŋ ka waŋ mamaŋ. Da na ka hi, mamaŋ da ma ka par hã-na, na waŋ ma yaa‑i. Ma siɛ ji hel namaa hɔmmu-na, ma kaa hel *Diiloŋ-Yalle huɔŋ-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","«Banamba kaa bel ba fɛrɛŋ hãmba‑i a hã ba ko-ba, banamba ba fɛrɛŋ mɔlbaa, banamba ba bisãlmba, banamba bi sire pu baa ba bĩncuɔmba‑i aa ce ba bel-ba ko-ba. ");
INSERT INTO cmeNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nuɔmba‑i hiere ba kaa bigãaŋ-na mɛi maama-na. Ŋga umaŋ duɔ nyaar ji hi ku bãlma‑i, kutieŋo ka kor.» ");
INSERT INTO cmeNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","«Nuɔni maŋ da ŋ kalaŋ terieŋ daaku‑i, ŋ gbãŋ kpelle ŋ suɔ ku yuŋgu‑i. Da na ji da Terbĩɛnatieŋo juɔ ji tĩɛna terieŋgu maŋ u saa saaya u tĩɛna-kuɔ, namaa namaŋ da na ji waa *Yude‑i-na, na ta na gbar na kã tãnniŋ. ");
INSERT INTO cmeNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Umaŋ duɔ ji waa u dũŋgu dɔrɔ‑i-na, u hiire u tuɔ gbar; u baa cira u suur biɛ bĩŋkũŋgu dũŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Umaŋ duɔ ji waa suoŋ-nu, u baa cira u jo cĩiŋ-nu ji biɛ waaŋ-joŋgoruo. ");
INSERT INTO cmeNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Kusũntaamba‑i baa bientaamba‑i, sũlma haraa-bɛi yinni fanni-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Taa na cãrã Diiloŋo‑i ku baa ji ce waaŋ-huɔŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Diiloŋ uŋ jĩɛna miwaaŋo‑i ji hi baa nyuŋgo, yaahuolo maŋ temma‑i saa da nelbiliemba‑i, u'i ka da-ba yinni fanni-na. Aa da ma hel ufaŋo-na, u temma sa ji da-ba. ");
INSERT INTO cmeNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kuɔ Itieŋo saa naa hiel kunaŋgu yiŋ daani-na, molo naa saa kor. Ŋga u yufelleŋ hilaa bamaŋ nuɔ‑i, u niɛ ba yaa‑i aa hiel kunaŋgu niɛ. ");
INSERT INTO cmeNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","22","«Na saa da, coikartaamba ka ta ba jo; umaŋ duɔ jo, wuɔ Diiloŋ uŋ pãa nuŋgu‑i wuɔ u ka saaŋ *Koŋkortieŋo maŋ, u yaa ufaŋo‑i, banamba ka cira bafamba *Diilopɔpuɔrbiemba. Ba ka ce nelma bɔi baa gbɛrɛ-wɛima bɔi da ba pira halle Diiloŋo yufelleŋ hilaa bamaŋ nuɔ‑i. A ce dumaaŋo-na, umaŋ duɔ ji gbɛ̃-na wuɔ Diiloŋ uŋ pãa nuŋgu‑i wuɔ u ka saaŋ Koŋkortieŋo maŋ uu dii bande, sisɔ uu dii daalɛi, baa na hũu-ma, u tãal-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Terieŋgu faŋgu-na, bilaaŋ na fɛrɛ, mi gbuɔya-nɛi jĩna.» ");
INSERT INTO cmeNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","«Yaahuolo daa duɔ tuɔ bãl, bãaŋgu ka bir cure, cɛiŋo ka ce da bĩntũu. ");
INSERT INTO cmeNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Mɔɛŋa ka par diire, bĩmbĩnni maŋ dɔrɔ‑i-na hiere ni ka halaŋ ni fonni-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","«Huɔŋgu faŋgu'i nuɔ‑i ba ka da *Moloŋ-Biɛŋo jo duherru‑na. Ba ka da u yuntesĩnni‑i baa u bɔbɔima‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Duɔ jo, u yufelleŋ hilaa bamaŋ nuɔ‑i, u ka ce *dɔrpɔpuɔrbiemba wuɔra terni-na hiere baa hĩɛma-na hiere a tigiiŋ-ba terduɔŋ-nu.» ");
INSERT INTO cmeNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","«Na saa da *yensãaŋgu‑i, da na ji da ku caa fiɛlu‑i, na bi suɔ kerre ifɛlle hii. ");
INSERT INTO cmeNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Kuuduɔŋgu yaa‑i, da na bi ji da mamaŋ daama ce, na saaya na suɔ wuɔ *Moloŋ-Biɛŋo jomma piyaa. ");
INSERT INTO cmeNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Mi waŋ ninsoŋo‑i baa-na, nel daama ka ce hi fiɛfiɛ ku nuɔmba namba aa ba suɔ ku. ");
INSERT INTO cmeNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Dɔrɔ‑i baa hĩɛma‑i ni ka gbuo, ŋga mɛi nelma sa ji gbuo dede.» ");
INSERT INTO cmeNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","«Ŋga kumaŋ ŋaa yiiŋgu faŋgu fɛrɛ‑i, sisɔ huɔŋgu faŋgu fɛrɛ‑i, molo sa suɔ-ku. Halle *dɔrpɔpuɔrbiemba famba fɛrɛ‑i dɔrɔ‑i-na baa Bɛpolŋ fuɔ fɛrɛ‑i, ba sa suɔ-ku. Tuoŋo yaa suyaaŋ-kuŋ u diei yoŋ. ");
INSERT INTO cmeNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Naŋ'a na sa suɔ yiiŋgu‑i, baa na duɔfũŋ. ");
INSERT INTO cmeNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Mi gbãa saa-ku baa naacolŋo naŋ maama. U taa u kã nelle. Uŋ'a u ta, u dii u dumɛlle wɛima‑i hiere u maacembiemba naŋ-na; nɛliɛŋo nɛliɛŋo baa u maacemma. Uŋ ciɛ mafamma‑i, u waŋ baa umaŋ taa u niya fondumɛlle‑i wuɔ: ‹Baa duɔfũŋ!› ");
INSERT INTO cmeNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Terieŋgu faŋgu-na, baa na bi duɔfũŋ, na sa suɔ dumɛllentieŋ uŋ ka jo huɔŋgu maŋ nuɔ‑i: U ka jo dãnambãaŋ-nu wa, isuɔholleŋ wa, kɔhɔlaamba-na wa, cucuuyuŋ-nu wa, na sa suɔ. ");
INSERT INTO cmeNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Duɔ fiɛ jo huɔŋgu huɔŋgu, na baa yaŋ u jo ji da na duɔfũŋ. ");
INSERT INTO cmeNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Miŋ waaŋ mamaŋ daama‑i baa-na, mi bi waŋ maaduɔma famma yaa‑i baa nuɔmba‑i hiere wuɔ ba baa duɔfũŋ.» ");
INSERT INTO cmeNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","*Diilojigãntaamba yuntaamba‑i, baa *ãnjĩnamma pigãataamba taa ba taara nelma da ba cure Yesu‑i gbãa bel-o ko-yo. *Kɔrsĩnni tĩmmaŋ-ponsaaŋgu‑i, baa *baŋ'a ba sa dii siini‑i *buruo maŋ nuɔ‑i u kũŋguŋ juɔ tĩɛ yinni hãi aa da ni hi, ");
INSERT INTO cmeNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","baa ta ba piiye wuɔ: «I saa saaya i bel-o ponsaaŋgu hɔlma-na ni ma'i sĩ ku ka du.» ");
INSERT INTO cmeNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yibieŋa faŋa-na Yesu waa Betani baa u *hãalãbiemba‑i tuɔ wuo niiwuoni *jardãamaŋ waa Simɔ maŋ nuɔ‑i u dumɛlle-na. Ciɛŋo naŋo jo baa natikolo naŋo *alabati-kamoeleŋ. Natikolo faŋo ciɛ baa *naar-yɔmma ma kula. U sullu waa kpelle. Uŋ juɔ, wuɔ kaya kamoele nuŋgu‑i aa kũnna natikolo‑i Yesu yuŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Nuɔmba maŋ waa, banamba hɔmmu pãŋ du baa ciɛŋ daayo‑i. Baa ta ba piiye wuɔ: «Bige‑i ciɛ u bĩɛna natikolofɛfɛiŋ daayo‑i temma‑i? ");
INSERT INTO cmeNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Uu naa gbãa suor-o *deniebaa nuɔsũɔ komuɔŋa ndii a kãyã sũntaamba‑i.» Aa ta ba waana. ");
INSERT INTO cmeNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Yesu wuɔ gbɛ̃-ba wuɔ: «Yaaŋ ciɛŋo fiisa! Bige‑i ciɛ na ta na guɔla u huɔŋga‑i? Uŋ ciɛ kumaŋ miɛ daaku‑i, ku faa. ");
INSERT INTO cmeNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Sũntaamba‑i dii baa-na bãaŋgu‑i baa isuɔŋgu‑i; na gbãa kãyã-bɛi huɔŋgu maŋ dɔlaanu-nɛi. Ŋga muɔmi si dii baa-na gbula. ");
INSERT INTO cmeNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ciɛŋ daayo ciɛ u kuusaanuŋgu yaa‑i: U kũɔna natikolo‑i miɛ tuɔ cie mi kuliiŋ-yiiŋgu yaa‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Yaaŋ mi waŋ ninsoŋo‑i baa-na: *Neldɔdɔlma da ma waŋ terieŋgu terieŋgu hĩɛma-na bande‑i-na, ciɛŋ daa uŋ ciɛ mamaŋ daama‑i, ba ka bi ta ba waŋ-ma nuɔmba ta ba suɔ-ma.» ");
INSERT INTO cmeNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Yesu *hãalãbieŋ cĩncieluo ba hãi baamba-na, ba naŋ bĩŋ umaŋ *Yuda-Isikaro‑i, wuɔ ta ka waŋ baa *Diilojigãntaamba yuntaamba‑i wuɔ fuɔ gbãa kãyã-bɛi ba bel Yesu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Kuɔ gbuu silaa dɔlnu-bɛi. Baa pã nuŋgu baa-yo wuɔ duɔ gbãa ce-ma, ba ka hã-yo gbeiŋa. Yuda wuɔ doŋ tuɔ taara uŋ ka ce dumaa ba bel Yesu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","*Baŋ'a ba sa dii siini‑i *buruo maŋ nuɔ‑i u ponsaaŋgu yidĩɛlãŋgu-na, baŋ koŋ *kɔrsĩnni tĩmmaŋ-ponsaaŋgu niikonni‑i yiiŋgu maŋ nuɔ‑i, Yesu *hãalãbiemba yuu-yo wuɔ: «Hãalãtie, ŋ taara i ka ce kɔrsĩnni tĩmmaŋ-ponsaaŋgu niiwuoni‑i terieŋ haku‑i nuɔ‑i a hã-ni?» ");
INSERT INTO cmeNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Yesu wuɔ waŋ baa ba hãi wuɔ: «Kãaŋ nelleŋ-huɔŋga-na na ka da naacolŋo naŋo tũyãa hũmmaŋ-bũnaŋga, na cu u huoŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Duɔ ka suur dumɛlle maŋ nuɔ‑i, na suur baa-yo. Da na suur, na waŋ baa dumɛllentieŋo‑i wuɔ hãalãtieŋ wuɔ u pigãaŋ-na dũŋgu maŋ uŋ ka hã-yo baa-ku u wuo kɔrsĩnni tĩmmaŋ-ponsaaŋgu niiwuoni‑i baa u hãalãbiemba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","U ka pigãaŋ-na dubuɔ naŋo dɔrɔ‑i-na. U tigiiŋ tĩ; bĩmbĩnni‑i dii-yuɔ. Na ce niiwuoni‑i kusuɔŋ-nu'i i ka wuo.» ");
INSERT INTO cmeNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Hãalãbiemba ta. Baŋ kãa ka hi, ba bi da-ma ŋaa Yesuŋ waaŋ-ma dumaa. Baa ce niiwuoni‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Bãaŋguŋ juɔ suur, Yesu wuɔ jo baa u hãalãbieŋ cĩncieluo ba hãi baamba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Baŋ juɔ tĩɛna ta ba wuo niiwuoni‑i, Yesu wuɔ cira: «Yaaŋ mi waŋ ninsoŋo‑i baa-na: Na hɔlma-na, unaa ka hel mi huoŋ-nu; kutieŋo‑i dii tuɔ wuo baa-mi bande‑i-na.» ");
INSERT INTO cmeNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ba yammu pãŋ vãa. Baa ta ba yuu-yo ba da-ba-diei. Umaŋ duɔ puur wuɔ: «Hãalãtie, muɔmɛi wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesu wuɔ cira: «Kutieŋo dii hãalãbieŋ cĩncieluo ba hãi baaŋ namaa hɔlma yaa nuɔ‑i; kutieŋo wuo baa-mi kaladuɔŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","*Moloŋ-Biɛŋo ka ku ŋaa Diiloŋ-nelmaŋ waaŋ-ma dumaa, nuharuŋgu si dii-mɛi. Ŋga umaŋ ka hã-ba baa-yo ba ko-yo, sũlma haraa kutieŋo-na; bɔlbɔl uu naa baa hoŋ.» ");
INSERT INTO cmeNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Baŋ waa ta ba wuo niiwuoni‑i, Yesu wuɔ ji biɛ *buruo, aa jaal Diiloŋo‑i aa bũlnu-yuɔ hã-ba aa cira: «Hũyãaŋ, mi kũɔma yaa daama.» ");
INSERT INTO cmeNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ku huoŋgu-na, u biɛ duvɛ̃ŋo ciiŋ-na aa jaal Diiloŋo‑i aa hã-ba baa-yo ba nyɔŋ hiere. ");
INSERT INTO cmeNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Baŋ juɔ nyɔŋ tĩ, wuɔ cira: «Mi tãmma yaa‑i; tobisĩfɛlɛnniŋ-tãmma yaa‑i. Ma ka kũnna nuɔmba bɔi maa-na.» ");
INSERT INTO cmeNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Aa cira: «Yaaŋ mi waŋ ninsoŋo‑i baa-na: Ni *Diiloŋ-nelleŋ sĩ, mi siɛ tiraa nyɔŋ duvɛ̃ŋo.» ");
INSERT INTO cmeNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ku huoŋgu-na, baa hãl nɛini gbɛliɛŋ Diiloŋo‑i aa sire ta kã *Olivi-tibinni-tãnuŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesubaa-baŋ kãa *Olivi-tibinni-tãnuŋgu-na, Yesu wuɔ tuɔ piiye baa u *hãalãbiemba‑i wuɔ: «Ma nyɛgãaŋ Diiloŋ-nelma-na wuɔ: ‹Mi ka ko ãncĩinaŋo‑i aa yaŋ tũlmba pisãllã.›» Yesu wuɔ cira: «Terieŋgu faŋgu-na, namaa na ka nanna-miɛ hiere. ");
INSERT INTO cmeNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ŋga da mi ji sire, mi ka kã ka cie-na *Galile‑i-na.» ");
INSERT INTO cmeNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Piɛr wuɔ cira: «Banamba da ba fiɛ nanna-niɛ, muɔ fuɔ mi cɛraa mi nanna-niɛ.» ");
INSERT INTO cmeNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesu wuɔ cira: «Piɛr, mi waŋ ninsoŋo‑i baa-ni, nyuŋgo daayo-na, isuɔduɔŋ daaku-na, kɔhɔldĩɛlãŋo siɛ hi tir bu, ŋ ka cĩina-miɛ da i siɛi wuɔ naŋ sa suɔ-mi.» ");
INSERT INTO cmeNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Piɛr wuɔ dii u naŋga‑i dãamu-na wuɔ da ba fiɛ'a ba ka ko-ba ba hãi‑i-na, fuɔ cɛraa u cira u sa suɔ-yo. Banamba bi waŋ maaduɔma. ");
INSERT INTO cmeNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ku huoŋgu-na, Yesubaa-ba sire kã terieŋgu naŋgu-na ba bĩ-ku Getisemane. Baŋ kãa, Yesu wuɔ waŋ baa u *hãalãbiemba‑i wuɔ: «Tĩɛnaanaŋ bande mi ka cãrã Diiloŋo‑i aa jo.» ");
INSERT INTO cmeNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Uŋ'a u ta, wuɔ ta baa Piɛr, baa Sake a naara Nsãa. Baŋ kãŋ hũmelle-na, u holle doŋ ta di tie, korma ta ma da-yo. ");
INSERT INTO cmeNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Wuɔ waŋ baa-ba wuɔ: «Mi huɔŋga si dii huɔŋga; tĩɛnaanaŋ bande na cie-mi. Baa na duɔfũŋ!» ");
INSERT INTO cmeNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Aa kã yaaŋ-na cɛllɛ ka dũuna tuɔ cãrã Diiloŋo‑i wuɔ duɔ siɛ u baa yaŋ yaahuolo daayo haa-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Uŋ waaŋ mamaŋ ma yaa daama, u ciɛra: «Baba, wɛima si dii mamaŋ gbãa yar-ni cemma, jande maaya yaahuolo daayo‑i muɔ-na; ŋga baa fer-muɔ, ce-ma niŋ taaraŋ ma ce dumaa.» ");
INSERT INTO cmeNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ku huoŋgu-na, wuɔ sire duɔ ji ne Piɛrbaa-ba‑i; a jo ji da ba kuraa duɔfũŋ. Wuɔ cira: «Simɔ, ŋ duɔfũŋ wɛi? Halle ŋ saa gbãa tĩɛna da huɔŋgu cɛllɛ, ŋ yaŋ duɔfũmmu nuɔl-ni. ");
INSERT INTO cmeNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Baa na duɔfũŋ, taa na cãrã Diiloŋo‑i wɛima baa gbãa tãal-na dii-na kuubabalaaŋgu cemma-na. Ãnfafamma cemmaŋ-maama dii nelbiloŋo huɔŋga-na, ŋga ku fɔ̃ŋgũɔ yaa si dii-yuɔ.» ");
INSERT INTO cmeNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Uŋ waaŋ mafamma‑i, wuɔ tiraa bir ta ka cãrã Diiloŋo‑i baa nelduɔŋ daama yaa‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Uŋ kaa cãrã tĩ aa bir jo hãalãbiemba wulaa, wuɔ jo ji da duɔfũmmu yirii-ba. Ba saa suɔ baŋ ka waŋ mamaŋ baa-yo. ");
INSERT INTO cmeNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Wuɔ tiraa bir ta. Uŋ kaa bir tuɔ jo siɛliŋ-jomma‑i, wuɔ jo ji gbɛ̃-ba wuɔ: «Na saa duɔfũŋ ye dumaa wɛi? Ku hii. Ba ka hã ãmbabalmanciraamba baa *Moloŋ-Biɛŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Siireŋ i ta, umaŋ ka hã-ba baa-mi u'i juɔŋ daayo.» ");
INSERT INTO cmeNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Nelma saa ji tĩ Yesu nuŋgu-na, ba'a ba ne da *Yuda juɔ ji tuɔ yiɛra baa nelpũŋgu naŋgu u huoŋgu-na. Yuda nuŋgu waa baa u *hãalãbieŋ cĩncieluo ba hãi baamba‑i. Bamaŋ waa baa-yo, banamba waa baa jigãmmu, banamba bɔ̃ɛŋa. *Diilojigãntaamba yuntaamba‑i, baa *ãnjĩnamma pigãataamba‑i, a naara nelle bĩncuɔmba yaa naa puɔraa-ba. ");
INSERT INTO cmeNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","A ne da baŋ'a ba jo, Yuda gbuɔya-bɛi wuɔ: «Da mi ka pũrã umaŋ jaal-o, u yaa‑i, na bel-o fafamma na kã baa-yo.» ");
INSERT INTO cmeNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Baŋ juɔ ji hi, wuɔ piɛ Yesu caaŋ-nu aa naa cira: «Hãalãtie» aa pũrã-yuɔ jaal-o. ");
INSERT INTO cmeNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Bamaŋ waa u huoŋgu-na baa bi pãŋ piɛ bel Yesu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Hãalãbiloŋo naŋ wuɔ pãŋ fa u jigãŋga‑i hiel-ka a jafũŋ *Diilojigãntaamba yuntieŋo maacembiloŋo tũŋgu‑i a yer-ku. ");
INSERT INTO cmeNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesu wuɔ cira: «Na hilaa baa jigãmmu baa bɔ̃ɛŋa da na ji bel-mi ŋaa cuoyuo muɔ. ");
INSERT INTO cmeNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ma sĩ i da i-naa yinni maŋ joŋ *Diilodubuɔ‑i-na kɛ? Mi kã mi waŋ Diiloŋ-nelma‑i mi pigãaŋ nuɔmba‑i kusuɔŋ-nu'i. Bige‑i ciɛ na saa siɛ bel-mi? Ŋga mamaŋ nyɛgãaŋ Diiloŋ-nelma-na, ma saaya ma ce ku'i ciɛ.» ");
INSERT INTO cmeNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Hãalãbiemba gbar hiere aa yaŋ-yo. ");
INSERT INTO cmeNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Baŋ bilaa Yesu‑i ta ba kã baa-yo, naacombiloŋo naŋo cu ba huoŋ-nu. Naacombiloŋo faŋ wuɔ naaŋ kompaŋga yoŋ u kũɔma-na. Bamaŋ bilaa Yesu‑i, baa kã nii-yuɔ da ba bel-o. ");
INSERT INTO cmeNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Wuɔ nanna kompaŋga‑i hã-ba aa gbar tãmporuoŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Baŋ bilaa Yesu‑i, baa kã baa-yo *Diilojigãntaamba yuntieŋo cĩiŋgu-na. *Diilojigãntaamba yuntaamba‑i, baa nelle bĩncuɔmba‑i, a naara *ãnjĩnamma pigãataamba‑i, baa jãnu ba-naa terieŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","A ne da baŋ taa ba kã baa Yesu‑i, Piɛr wuɔ yaŋ ba maa aa suɔ cu ba huoŋ-nu kã ka suur baa-ba Diilojigãntaamba yuntieŋo cĩiŋgu-na. Uŋ suurii, wuɔ kã ka tuɔ yiraaŋ dãamu baa bamaŋ niɛyaŋ dumɛlle‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Diilojigãntaamba yuntaamba‑i a naara *nellentaamba‑i, baa ta ba taara ãntãalãmma da ba haa Yesu‑i-na da ba gbãa ko-yo, ŋga ma saa dɔl-ba. ");
INSERT INTO cmeNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Nuɔmba bɔi taa ba kar coima‑i ba haa-yuɔ, ŋga ba nelma taa ma hel ma-naa honniŋ. ");
INSERT INTO cmeNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Banaŋ baa sire baa coiŋ daama‑i ta ba piiye wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«I nuɔ u ciɛra wuɔ: ‹Nelbiliembaŋ maa *Diilodubuɔ maŋ daayo‑i, mi ka muonu-yuɔ aa ma uufɛlɛŋo yinni siɛi hɔlma-na; ufaŋo siɛ waa nelbilieŋ uumaŋo.›» ");
INSERT INTO cmeNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Halle baŋ fiɛ waŋ mafamma‑i, ma saa ce kuuduɔŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Diilojigãntaamba yuntieŋ wuɔ sire yiɛra nuɔmba-na aa naa cira: «Naacolŋ nuɔ, baŋ cãl-niŋ naŋ'a niɛ?» ");
INSERT INTO cmeNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Yesu saa seŋ sũnuŋgu yuɔ. Wuɔ cira: «Diiloŋ uŋ pãa nuŋgu‑i wuɔ u ka saaŋ *Koŋkortieŋo maŋ, u yaa nuɔŋo‑i wɛi? Iŋ tuɔlnuŋ Diiloŋo maŋ, fuɔ biɛŋo'i nuɔŋo‑i wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu wuɔ cira: «Muɔmɛi.» Aa naa cira: «Yiiŋgu dii baa yiiŋgu na ka da *Moloŋ-Biɛŋo tĩɛnaana Itieŋo caaŋgu-na. Na ka da u hilaa dɔrɔ‑i-na duherru suuye-yuɔ u tuɔ jo.» ");
INSERT INTO cmeNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Uŋ waaŋ mafamma‑i, Diilojigãntaamba yuntieŋo huɔŋ kaa pãŋ du; wuɔ fa fuɔ fɛrɛŋ joŋgorbaa-ba‑i taalnu-bɛi aa naa cira: «Ii si dii diɛ ka tiraa yuu moloŋo! ");
INSERT INTO cmeNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Uŋ tuoraaya Diiloŋo‑i namaa na'a niɛ?» Baa sire hiere wuɔ u cãlãa, kɛrɛ u saa baa kuliiŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Banamba pãŋ ta ba tu taalni yuɔ, aa naa vaa u yufieŋa‑i aa ta ba dudul-o. Da ba dudul-o, ba yuu-yo wuɔ: «Ŋ suyaa umaŋ muyaa-ni wɛi? Bĩ kutieŋo yerre‑i i ne!» Bamaŋ naa niɛyaŋ dumɛlle‑i, baa bel-o ta ba caa u tũnni‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Baŋ taa ba ce Yesu‑i kpãncɔ̃lgũɔ faŋo‑i, Piɛr waa yogo hĩɛma-na dumɛlleŋ-huɔŋga-na. *Diilojigãntaamba yuntieŋo maacembiloŋo naŋo jo ");
INSERT INTO cmeNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ji da u yiraaŋ dãamu‑i. Wuɔ ne-yo da kelkelkel aa cira: «Ma sĩ nuɔ ŋ waa baa Nasarɛtitaaŋ Yesu‑i kɛ?» ");
INSERT INTO cmeNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Piɛr wuɔ cira: «Ciɛŋ nuɔ, mɛi saa suɔ ŋ nelma yaaŋga‑i; ŋ taara ŋ waŋ wuɔ niɛ?» Uŋ waaŋ mafamma‑i, wuɔ pãŋ hel ka yiɛra fondumɛlle-na. Kɔhɔldĩɛlãŋ wuɔ doŋ tuɔ bu. ");
INSERT INTO cmeNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Uŋ kãa ka yiɛra fondumɛlle-na, maacembiloŋ daayo daa-yo. Wuɔ tuɔ piiye baa bamaŋ waa dumɛlle-na wuɔ: «Unaŋo yaa yiɛraaya daayo‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Piɛr wuɔ tiraa ju-ma wuɔ coima. Cɛllɛ, bamaŋ waa, baa gbɛ̃-yo wuɔ: «Ma sĩ Galileyiɛŋ nuɔ kɛ? Ŋ ju-ma gbãŋgbãŋ, unaŋo'i nuɔŋo‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Piɛr wuɔ cira: «Muɔ baa Diiloŋo mi sa suɔ naacolŋ daayo‑i! Aa da kuɔ mi karaa coima, Diiloŋo baa yaŋ-mi!» ");
INSERT INTO cmeNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Uŋ taa u waŋ mafamma‑i huɔŋgu maŋ nuɔ‑i, kɔhɔldĩɛlãŋ wuɔ doŋ tuɔ bu hãalĩŋ-bumma‑i. Yesuŋ ŋa naa waŋ mamaŋ baa-yo wuɔ: «Kɔhɔldĩɛlãŋo siɛ hi tir bu, ŋ ka cĩina-miɛ da i siɛi wuɔ naŋ sa suɔ-mi» nelma famma pãŋ tĩɛnu-yuɔ. Wuɔ pãŋ naŋ yuŋgu tuɔ kaal. ");
INSERT INTO cmeNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ku cuo kaala‑i-na, *Diilojigãntaamba yuntaamba naar tigiiŋ ba-naa, baa nelle bĩncuɔmba‑i, a naara *ãnjĩnamma pigãataamba‑i. Kuu dii ŋaa *Yuifu ba *nellentaamba yaa naa naaraa tigiiŋ ba-naa, a da ba-naa, aa bel Yesu‑i vaa-yo kã baa-yo ka hã *Pilati‑i baa-yo. ");
INSERT INTO cmeNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilati wuɔ yuu-yo wuɔ: «Yuifu ba nellentieŋo yaa nuɔŋo‑i wɛi?» Yesu wuɔ cira: «Muɔmɛi.» ");
INSERT INTO cmeNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Diilojigãntaamba yuntaamba doŋ ta ba cãl-o baa nelma bɔi. ");
INSERT INTO cmeNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilati wuɔ yuu-yo wuɔ: «Baŋ cãl-niŋ balbalbal naŋ'a niɛ?» ");
INSERT INTO cmeNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Yesu saa ji seŋ sũnuŋgu yuɔ. Kuɔ bir yaŋ aa cu Pilati huɔŋga‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Belle belle, *kɔrsĩnni tĩmmaŋ-ponsaaŋ da kuɔ hi, *Pilati nanna kasobiloŋo diei. Nuɔmba yaa pigãaŋ ba yufelleŋ-nolŋo u nanna-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Naacolŋo naŋo waa kaso‑i-na, ba taa ba bĩ-yo Barabasi. U waa baa bubɔlaamba namba. Ijieni naŋ niɛ ciɛ nelle-na bafamba hi ko nɛliɛŋo, baa bel-ba ka suuye-bɛi. ");
INSERT INTO cmeNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Nuɔmba sire kã Pilati wulaa dii u cĩiŋgu-na ka ta ba cãrã-yuɔ wuɔ u hã-ba kasobiloŋo‑i ŋaa uŋ jo u hã-ba dumaa koko. ");
INSERT INTO cmeNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilati wuɔ yuu-ba wuɔ: «Na taara mi nanna *Yuifu ba nellentieŋo yaa wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Fuɔ fɛrɛ wuɔ suyaa wuɔ nenemuŋgu'i ciɛ *Diilojigãntaamba yuntaamba bel Yesu‑i ka hã-yo. ");
INSERT INTO cmeNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pilatiŋ yuu dumaaŋo-na, Diilojigãntaamba yuntaamba gbo nuɔmba‑i wuɔ ba cira u nanna Barabasi. ");
INSERT INTO cmeNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilati wuɔ tiraa yuu nuɔmba‑i wuɔ: «Na'a mi ce naŋ bĩŋ umaŋ Yuifu ba nellentieŋo‑i niɛ?» ");
INSERT INTO cmeNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Baa kaasĩŋ hiere wuɔ: «Gbu-yo *daaŋ-nu!» ");
INSERT INTO cmeNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilati wuɔ yuu-ba wuɔ: «U guɔlaaya bige‑i?» Baa migãaŋ ta ba kaasĩŋ bɔ̃mbɔ̃ŋ wuɔ: «Gbu-yo *daaŋ-nu! Gbu-yo daaŋ-nu!» ");
INSERT INTO cmeNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilati wuɔ hiel Barabasi‑i kaso‑i-na duɔ fɛ̃ ba hɔmmu‑i aa naa ce ba muo Yesu‑i da dɛi aa suɔ hã-ba baa-yo wuɔ ba ka gbu-yo daaŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","*Pilatiŋ hãa-ba Yesu‑i, sorosibaa baa hũu-yo suur baa-yo cĩiŋ-huɔŋga-na aa naa bĩ ba nabaamba jo hiere. ");
INSERT INTO cmeNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Baŋ juɔ, baa biɛ joŋgorbuɔ naŋo dii hã-yo. Joŋgoruo faŋo waa dãa-wuoŋo, aa naa ce huɔni sũ nyantuoluo dii u yuŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Baŋ ciɛ mafamma‑i, baa ta ba nyɛ-yo aa cira ba jaal-o. Umaŋ duɔ puur wuɔ: «*Yuifu ba nellentie, mi jaalaa-ni!» ");
INSERT INTO cmeNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Aa ta ba muo u yuŋgu‑i baa gboruoŋgu aa ta ba tu taalni yuɔ, aa naa ta ba cor ba dũuna u yaaŋga-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Baŋ juɔ nyɛ-yo ye huɔŋgu maŋ nuɔ‑i, baa hiel ba joŋgorbuɔ‑i u nuoŋgu-na aa bir dii fuɔ fɛrɛŋ bĩmbĩnni‑i hã-yo aa hel baa-yo da ba ka gbu-yo *daaŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Sorosibaa-baŋ hilaa baa Yesu‑i ta ba kã da ba ka gbu-yo, baa suu baa Sirɛniyiɛŋo naŋo hilaa suoŋ-nu tuɔ jo. Ba taa ba bĩ-yo Simɔ. U bɛmba waa ba hãi; ba taa ba bĩ unaŋo‑i Alɛsãndire aa bĩ unaŋo‑i Urufusi. Baŋ taa ba kã baa *daaŋgu maŋ da ba ka gbu Yesu‑i, baa bel u yaa‑i a haa-ku hã-yo. ");
INSERT INTO cmeNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Baŋ kãa baa Yesu‑i terieŋgu maŋ nuɔ‑i, ba bĩ-ku Gɔlgota, ku yuŋgu yaa wuɔ yukoluoŋ-terieŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Baŋ hii, baa guɔl *miir baa duvɛ̃ŋo a hã-yo wuɔ u nyɔŋ. Wuɔ yagar wuɔ u siɛ nyɔŋ. ");
INSERT INTO cmeNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Baa gbu-yo daaŋgu-na aa naa ful tieŋa a cal u joŋgorbaa-ba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Baŋ gbuu Yesu‑i huɔŋgu maŋ nuɔ‑i, bãaŋgu naa boŋ tĩ. ");
INSERT INTO cmeNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Baŋ gbuu-yo yuŋgu maŋ nuɔ‑i, baa nyɛgɛ̃ŋ-ku jĩna u yudɔrɔ‑i-na wuɔ: «*Yuifu ba nellentieŋo.» ");
INSERT INTO cmeNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Baa bi gbuu cuobaa-ba hãi baa-yo. Unaŋo‑i u nadieŋga-na, unaŋo‑i u nanyuɔŋgu-na.  ");
INSERT INTO cmeNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Mamaŋ nyɛgãaŋ Diiloŋ-nelma-na wuɔ: «Ba diyaa-yo baa nelbabalaamba», ma'i saa ce daama‑i wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Hũncortaamba ta ba misĩrrã ba yunni‑i aa ta ba tuora-yuɔ. Ba taa ba piiye wuɔ: «Hai daayo‑i! Naŋ saa cira wuɔ naŋ ka muonu *Diilodubuɔ‑i aa ma-yo yinni siɛi wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Kor ŋ fɛrɛ i ne! Hiire daaŋgu-na i ne!» ");
INSERT INTO cmeNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","*Diilojigãntaamba yuntaamba‑i, baa *ãnjĩnamma pigãataamba taa ba bi nyɛ-yo aa ta ba piiye baa ba-naa wuɔ: «U kuraa banamba‑i, ŋga u yaa daayo u siɛ gbãa kor u fɛrɛ. ");
INSERT INTO cmeNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Da kuɔ u yaa‑i *Koŋkortieŋo‑i Diiloŋ uŋ saaŋ-yo, da kuɔ u yaa‑i *Isirahɛl-baamba nellentieŋo‑i, u hiire fiɛfiɛ daaŋgu-na i ne, ku yaa i ka hũu u maama‑i.» Baŋ ŋa naŋ gbuu bamaŋ baa-yo, baa kã ba ta ba tuora-yuɔ hiere. ");
INSERT INTO cmeNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Bãaŋguŋ juɔ hi yuhuɔŋga‑i, ba'a ba ne da terieŋgu cuure hiere. Ku tĩyãa dumɛi fuɔ bãaŋgu ji tɛrɛŋ. ");
INSERT INTO cmeNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Kuŋ juɔ tɛrɛŋ, Yesu wuɔ kaasĩŋ da gbagaga wuɔ: «Eloyi, Eloyi, lama sabatani?» Ku yuŋgu yaa wuɔ: Diilo, Diilo, bige‑i ciɛ ŋ nanna-miɛ? ");
INSERT INTO cmeNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Bamaŋ waa, banaŋ baa ta ba piiye wuɔ: «Niɛŋ, u bĩ *Eli.» ");
INSERT INTO cmeNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Unaŋ wuɔ gbar kã ka nyiɛ kãnsaarma namma‑i niisaarniŋ aa to-ma gboruoŋ-nu a hã-yo wuɔ u mɔsũnya hĩŋ, aa naa cira: «Yaaŋ mi hã u mɔsũnya, aa i ne si Eli ka jo ji har-o *daaŋgu-na.» ");
INSERT INTO cmeNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yesu wuɔ tiraa kaasĩŋ da gbagaga, aa bi pãŋ hũu u fɛrɛ. ");
INSERT INTO cmeNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Kompaŋga maŋ naa karaanu *Diilodubuɔ‑i, kaa pãŋ taalnu sɔmma hãi; a doŋ dɔrɔ‑i-na ji hel cicaara‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Sorosi ba yuntieŋo naŋo waa yiɛra Yesu caaŋgu-na. Uŋ juɔ da u kuu kuliiŋ daaku‑i, wuɔ cira: «Naacolŋ daayo waa Diiloŋ-Biɛŋo kelkel.» ");
INSERT INTO cmeNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Caamba namba bi waa yiɛra yargaa ta ba fara ba ne. Maari maŋ taa u hel Magidala‑i-na u waa baa-ba baa u duoŋo‑i Sake bisãlãaŋo‑i ba nyu‑i. A naara Salome bi waa. ");
INSERT INTO cmeNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ba yaa naa cuu Yesu huoŋ-nu ta ba kãyã-yuɔ uŋ waa *Galile‑i-na. Caamba namba naa bi nyaa u huoŋ-nu jo *Yerusalɛmu‑i-na. Caamba faŋ baa ciinu. ");
INSERT INTO cmeNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Yesuŋ hũyãa u fɛrɛ huɔŋgu maŋ nuɔ‑i, bãaŋgu naa ta ku kã suurma-na. Aa ba *yitĩɛnaŋgu waa ŋaa bisĩŋ ku temma, a ce dumaaŋo-na ba waa gbagbarramma-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Naacolŋo naŋ wuɔ doŋ holle kã *Pilati wulaa ka cãrã kuloŋo‑i. Ba taa ba bĩ-yo Yosɛfu, u taa u hel Arimate. U waa nelbuɔ *Yuifu ba *nellentaamba hɔlma-na. U taa u niya *Diiloŋ-bãaŋgu domma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilatiŋ nuɔ wuɔ Yesu kuu, kuɔ ce-yo gbɛrɛ. Fuɔ wulaa u kuu donduo. Wuɔ ce ba bĩ sorosi ba yuntieŋo‑i a ji yuu-yo da kuɔ u kuu yiinaa. ");
INSERT INTO cmeNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Sorosi ba yuntieŋ wuɔ suur ma yaaŋga-na a waŋ-ma baa-yo. Wuɔ suɔ hã Yosɛfu‑i hũmelle‑i wuɔ u ka har-o. ");
INSERT INTO cmeNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yosɛfu wuɔ kã ka sãa kompaŋga‑i aa kã ka har-o *daaŋgu-na a fĩnya-yuɔ aa kã baa-yo ka fuure-yuɔ cĩncorre nande-na baa naa hĩŋ-de tãmpɛ̃lleŋ. Baŋ kaa nanna tĩ, wuɔ bũmal tãmpɛ̃lle nande‑i a suuye cĩncorre nuŋgu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maari maŋ taa u hel Magidala‑i-na baa u duoŋo‑i Yose ba nyu‑i, baa yiɛra ne baŋ gaala Yesu‑i kusuɔŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","*Yitĩɛnaŋguŋ juɔ cor, Maari maŋ taa u hel Magidala‑i-na, baa u duoŋo‑i Sake ba nyu‑i, a naara Salome‑i, baa sãa natikolo wuɔ ba ka kũnna Yesu‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ku cuo kaala‑i-na, baa naar biɛ hũmelle‑i ta ba kã cĩncorre-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Baŋ kãŋ, baa ta ba piiye wuɔ: «I kaa da hai u bũmal tãmpɛ̃lle‑i halaŋ-de cĩncorre nuŋgu-na hã-ye?» ");
INSERT INTO cmeNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Baŋ kaa piɛ, baa fara da tãmpɛ̃lle bũmalãa halaŋ. A ne da di maama saa naa fa baa bɔbɔima‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Baa kã ka suur cĩncorre-na. Ba'a ba ne da naacoloŋo naŋo tĩɛnaana ba nadieyaŋga-na baa joŋgorpilaŋo. Korma pãŋ ta ma da-ba. ");
INSERT INTO cmeNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Naacoloŋ daa wuɔ tuɔ piiye baa-ba wuɔ: «Baa na yaŋ korma da-na, mi suyaa miɛ baŋ gbuu Nasarɛtitaaŋ Yesu maŋ *daaŋgu-na ko-yo, na taara u yaa‑i. Uu si dii bande‑i-na, u siire hel kuomba hɔlma-na. Niɛŋ, baa naa galla-yuɔ bande yaa nuɔ‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Kãaŋ na ka tũnu u *hãalãbiemba‑i baa Piɛr, wuɔ u taa duɔ ka cie-na *Galile; na ka da-yo kusuɔŋ-nu'i ŋaa uŋ ŋa naa waŋ-ma baa-na dumaa.» ");
INSERT INTO cmeNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Caaŋ daaba kũɔma gbuu ta ma nyɛŋ; baa hel baa gbaruŋgu ta. Baŋ taa dumaaŋo-na, ba saa ka gbãa waŋ wɛima baa moloŋo korma nammu-na.  ");
INSERT INTO cmeNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesuŋ naaraa sire jumaansi cucuuyuŋgu-na, u caraaya Magidalataaŋ Maari yaa igɛ̃na. Wuɔ duɔnya *jĩnabaa niehãi fuɔ‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","U yaa kãa ka tũnu Yesu wuɔrataamba‑i. U kãa ka da-ba kuliiŋ-kaaluŋgu-na yogo. ");
INSERT INTO cmeNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Wuɔ cira: «Yesu siire, mi daa-yo nuɔ baa mi yufelle!» U wuɔrataamba saa hũu-ma wuɔ ninsoŋo. ");
INSERT INTO cmeNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ku huoŋgu-na, Yesu *hãalãbiemba hãi baamba namba ji ta ba kã neyelle nande-na; Yesu wuɔ bir u deŋ birma carra-bɛi. ");
INSERT INTO cmeNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Hãalãbieŋ daaba bir ka waŋ-ma baa ba nabaamba‑i. Ba saa tiraa hũu bafamba maama‑i. ");
INSERT INTO cmeNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Kufaŋguŋ curaa, Yesu fuɔ fɛrɛ wuɔ yaŋ u hãalãbiemba maŋ tĩyãa cĩncieluo baa u diei wuoŋo‑i ba tĩɛna ta ba wuo niiwuoni aa u carra-bɛi tuɔ waŋ baa-ba wuɔ: «Bige‑i ciɛ miŋ siire ba da-mi aa jo ji waŋ-ma baa-na na saa hũu-ma?» ");
INSERT INTO cmeNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Aa naa cira: «Kãaŋ nilɛiŋa-na hiere na ka waŋ *Neldɔdɔlma‑i baa nuɔmba‑i hiere. ");
INSERT INTO cmeNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Umaŋ duɔ hũu-ma aa *batiseŋ, u kuraa. Ŋga umaŋ duɔ saa hũu-ma, kutieŋo ka caa. ");
INSERT INTO cmeNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Bamaŋ da ba hũu-ma, baŋ ka ta ba suɔ-ba dumaa ku yaa daaku: Ba ka ta ba gbuuse-miɛ aa ta ba donya *jĩnabaa-ba‑i, ba ka ta ba piiye nelfɛlɛmma-na; ");
INSERT INTO cmeNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","da ba fiɛ bel jĩɛŋo‑i, u siɛ gbãa ce-ba bĩŋkũŋgu, aa da ba fiɛ nyɔŋ puɔsɔ̃nɔ‑i, u siɛ gbãa ce-ba wɛima. Ba ka ta ba haa ba nammu‑i jaamba-na aa ta ba cãrã Diiloŋo‑i ba sire-bɛi.» ");
INSERT INTO cmeNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Itieŋo‑i Yesuŋ juɔ piiye baa-ba tĩ, wuɔ nyugũŋ ka tĩɛna Diiloŋo caaŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Uŋ taa dumaaŋo-na, u *hãalãbiemba ta ka ta ba wuɔra terni-na hiere ba waŋ *Neldɔdɔlma‑i. Itieŋ wuɔ tuɔ kãyã-bɛi ba maacemma-na aa bi tuɔ kãyã-bɛi ba ta ba ce gbɛrɛ-wɛima ba pigãaŋ nuɔmba‑i ba da ba suɔ wuɔ baŋ waŋ mamaŋ ninsoŋo.");
INSERT INTO cmeNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Tofil, mi ninsontieŋ nuɔ, Yesuŋ siire ce nelma maŋ i hɔlma-na, nuɔmba bɔi duɔŋ ta ba nyɛgɛ̃ŋ-ma. ");
INSERT INTO cmeNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Bamaŋ waa da-ma baa ba yufelle dii ma domma-na, aa ce ma wataamba, baŋ waaŋ-ma baa-ye dumaa, nuɔmba bi nyɛgãaŋ-ma dumɛi. ");
INSERT INTO cmeNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ku'i ciɛ, mɛi fɛrɛ‑i, mi bi sire wuɔra yuure-mɛi fafamma a ne maŋ ciɛ dumaa. Miŋ juɔ suɔ ma yaaŋga‑i, mi da ku saaya mi gbura-mɛi nyɛgɛ̃ŋ-ma hã-ni ");
INSERT INTO cmeNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ŋ da ŋ suɔ wuɔ baŋ waaŋ mamaŋ baa-ni u maama-na coima sĩ. ");
INSERT INTO cmeNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","*Erɔdiŋ waa nellentesĩnni‑na huɔŋgu maŋ nuɔ‑i *Yude‑i-na, *Diilojigãntieŋo naŋo waa Abiya baamba-na, ba taa ba bĩ-yo Sakari. U ciɛŋo waa *Aarɔ̃ hãayɛ̃lŋo; ba taa ba bĩ-yo Elisabɛti. ");
INSERT INTO cmeNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Sakari‑i baa u ciɛŋo‑i baa naa vii baa Diiloŋo‑i. Ba taa ba nu u nuŋgu‑i aa ta ba wuɔ u hũmelle‑i fafamma. ");
INSERT INTO cmeNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ŋga Elisabɛti waa cɛnyɛiŋo, a ce ba ji vãa ba hãi‑i-na hiere ba saa da biloŋo baa ba-naa. ");
INSERT INTO cmeNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Yiiŋgu naŋgu-na, Sakari wuɔ suur *Diilodubuɔ‑i-na tuɔ ce u maacemma‑i, bafamba yiiŋgu'i waa. ");
INSERT INTO cmeNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ku waa da ku bibirre hi bamaŋ, ba hiel nelduɔ suur ka ce mamaŋ dii cemma. Yiiŋ daaku-na, baa hiel Sakari yaa suur ka dii wusũnaŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Nuɔŋ baa yiɛra gɔ̃ŋgũɔŋgu-na ta ba cãrã Diiloŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Sakari juɔ'a u ne da Itieŋo *dɔrpɔpuɔrbiloŋo naŋo‑i u caaŋ-nu. Dɔrpɔpuɔrbiloŋo waa yiɛra wusũnaŋ‑igãŋga nadieŋ-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sakari holle gbuu pãŋ caar, u kũɔma ta ma nyɛŋ. ");
INSERT INTO cmeNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Dɔrpɔpuɔrbiloŋo cira: «Sakari, baa yaŋ korma da-ni. Niŋ cãrãŋ kumaŋ Diiloŋo wulaa, u ka hã-ni baa-ku. Ŋ ciɛŋo ka ce kusũŋgu, a hoŋ naacombiloŋo. Duɔ hoŋ-yo, ŋ haa u yerre‑i Nsãa. ");
INSERT INTO cmeNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","U homma ka dɔlnu-niɛ aa fɛ̃ ŋ huɔŋga‑i ŋaa bige‑i! Ku ka bi dɔlnu nuɔmba bɔi. ");
INSERT INTO cmeNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","U ka waa nelbuɔ Diiloŋo wulaa. U siɛ ji tuɔ nyɔŋ kolma maŋ gbãa bel nɛliɛŋo. *Diiloŋ-Yalle ka yu u huɔŋga‑i aa u suɔ duɔ hoŋ. ");
INSERT INTO cmeNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","U ka ce *Isirahɛl-baamba bɔi bir jo ba Tieŋo‑i Diiloŋo wulaa. ");
INSERT INTO cmeNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","U ka ce Diiloŋo maacemma‑i baa *Eli huɔŋga temma, baa u himma bi temma a dii bisãlmba‑i baa ba bĩncuɔmba‑i ba-naa nuɔ. Bamaŋ sa nuɔŋ Diiloŋo nuŋgu‑i, u ka ce ba ta ba nu-ku. U ka tigiiŋ nuɔmba hɔmmu‑i a ce ba ta ba niya Itieŋo jomma‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sakari wuɔ cira: «Muɔ baa mi ciɛŋo‑i i vãa tĩ, dɛ‑i-na mi ce niɛ suɔ wuɔ ŋ waŋ ninsoŋo?» ");
INSERT INTO cmeNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Dɔrpɔpuɔrbiloŋ wuɔ cira: «Ba bĩ-mi Gabiryɛl. Mii dii baa Diiloŋo‑i u tuɔ puɔr-mi. U yaa puɔraa-mi wuɔ mi ji tũnu-niɛ baa neldɔdɔl daama‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ŋga niŋ'a ŋ saa hũu mi nelma‑i, ŋ ka ce bobo nuɔ, ŋ siɛ gbãa ta ŋ piiye a ji hi maŋ ka ce yiiŋgu maŋ nuɔ‑i. Miŋ waaŋ-ma baa-ni dumaa, ma yiiŋ da kuɔ hi, ma ka bi ce.» ");
INSERT INTO cmeNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Kuŋ ciɛ dumaaŋo-na, Sakari wuɔ vaaya dii huɔŋga-na. A ne da nuɔmba taa ba cie u helma‑i gɔ̃ŋgũɔŋgu-na. Uŋ vaaya dumaaŋo-na, kuɔ cu ba hɔmmu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Uŋ juɔ hel, u saa gbãa duɔ puur u nuŋgu‑i piiye baa-ba; wuɔ naa u tuɔ piiye baa u nammu. Baa pãŋ suɔ wuɔ bĩŋkũŋgu ciɛ-yo dii dũŋ-huɔŋga-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Uŋ juɔ bãl u maacemma‑i, wuɔ kũŋ. ");
INSERT INTO cmeNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Yinni saa da, kusũŋgu yiɛra u ciɛŋo-na. Wuɔ ce caamba ndii u sa hel, aa naa tuɔ piiye u huɔŋ-na wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«Diiloŋo niɛ mi yaaŋ-na; senserre maŋ taa di da-mi baa nuɔmba‑i, u hurii-de.» ");
INSERT INTO cmeNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Caamba niediei ku huoŋgu-na, Diiloŋ wuɔ puɔr *dɔrpɔpuɔrbiloŋo‑i *Galile nelle nande-na ba bĩ-de Nasarɛti, ");
INSERT INTO cmeNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","bilonyɔnyuroŋo naŋo wulaa ba bĩ-yo Maari. Baa naa bel-o dɔrruŋ tĩ. U dɔrŋo‑i ba taa ba bĩ-yo Yosɛfu. U waa jãmatigi *Davidi hãayɛ̃lŋo. ");
INSERT INTO cmeNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Dɔrpɔpuɔrbiloŋo kã ka suur Maari wulaa aa naa cira: «Maari, gbuŋ fɛ̃ ŋ huɔŋga‑i; Itieŋo ciɛ baa-ni. U kuɔnu u huɔŋga‑i baa-ni cor.» ");
INSERT INTO cmeNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Nel daama cu Maari huɔŋga‑i, u tuɔ piiye u huɔŋ-na wuɔ: «Nel hama‑i temma‑i dumandɛ‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Dɔrpɔpuɔrbiloŋo gbɛ̃-yo wuɔ: «Diiloŋo ciɛ baa-ni, baa yaŋ korma da-ni. ");
INSERT INTO cmeNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ŋ ka ce kusũŋgu a hoŋ naacombiloŋo. Da ŋ hoŋ-yo, ŋ haa u yerre‑i Yesu. ");
INSERT INTO cmeNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","U ka waa nelbuɔ, ba ka ta ba bĩ-yo Dɔrwuoŋo Biɛŋo. Diiloŋo ka ce-yo fɔ̃ŋgɔ̃tieŋo u haayiɛŋo‑i Davidi temma. ");
INSERT INTO cmeNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","U ka tĩɛna *Isirahɛl-baamba yuŋ-nu gbula, aa u fɔ̃ŋgũɔ sa ji tĩ dede.» ");
INSERT INTO cmeNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maari wuɔ cira: «Muɔmi sa bi suɔ bibiɛŋo yogo, ma ka ce niɛ gbãa ce?» ");
INSERT INTO cmeNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Dɔrpɔpuɔrbiloŋo gbɛ̃-yo wuɔ: «*Diiloŋ-Yalle ka jo ŋ wulaa, Dɔrwuoŋo ka hã-ni ku fɔ̃ŋgũɔ‑i. Ku'i ciɛ miɛ niŋ ka hoŋ naacombiloŋo maŋ, ba ka ta ba bĩ-yo Diiloŋ-Biɛŋo. ");
INSERT INTO cmeNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ŋ daa na horoŋo‑i Elisabɛti‑i kɛ! Naacombiloŋ-kusũŋgu yiɛraaya-yuɔ; ŋ siɛ suɔ wuɔ u yaaŋga cãa. Baŋ taa ba gbɛ̃ umaŋ wuɔ cɛnyɛiŋo, u caamba niediei yaa dɛi kuŋ yaraa-yo. ");
INSERT INTO cmeNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Wɛima sa yar Diiloŋo‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maari wuɔ cira: «Mii dii Itieŋo naŋ-na, u yaŋ ma ce ŋaa niŋ waaŋ-ma dumaa.» Uŋ waaŋ mafamma‑i, dɔrpɔpuɔrbiloŋo bir ta. ");
INSERT INTO cmeNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Yibieŋa faŋa-na, Maari wuɔ sire gbãana kã *Yude nelle nande-na duɔ ka ne Elisabɛti‑i. Nelle fande waa tãnniŋ. ");
INSERT INTO cmeNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Uŋ kaa hi dii u gboluoŋgu‑i Sakari dumɛlle-na a jaal Elisabɛti‑i, ");
INSERT INTO cmeNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","biloŋo pãŋ sagalla Elisabɛti kusũŋgu-na. *Diiloŋ-Yalle pãŋ yu Elisabɛti huɔŋga‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","U tuɔ piiye baa Maari‑i da gbagaga wuɔ: «Diiloŋo ciɛ baa-ni a yaŋ caamba‑i hiere, aa bi ce baa biloŋo maŋ ŋ kusũŋgu-na.» ");
INSERT INTO cmeNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Aa cira: «Mi Tieŋo nyu waa hie ji har mɛi temma‑i mi wulaa? ");
INSERT INTO cmeNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Miŋ nuɔ ŋ jaaluŋgu‑i, ku gbuu dɔlnu biloŋo‑i mi kusũŋgu-na; u sagalla. ");
INSERT INTO cmeNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Itieŋ uŋ puɔraa ba ji waŋ mamaŋ baa-ni, niŋ hũyãa-ma wuɔ ma ka ce, naŋ yuŋgu dɔlaa.» ");
INSERT INTO cmeNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maari wuɔ bi pãŋ doŋ tuɔ hãl wuɔ: «Mɛi gbu mi jaal Itieŋo yaa mi huɔŋga-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Diiloŋo maŋ kuraaŋ-miŋ, mi huɔŋga gbuu fɛ̃ baa-yo da hĩninni! ");
INSERT INTO cmeNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","U niɛ u maacembiloŋo yaaŋ-na. Coima saa fa, a doŋ fiɛfiɛ‑i-na, nuɔmbaŋ sireŋ ba jo dumaa, ba ka cira mi yuŋgu dɔlaa. ");
INSERT INTO cmeNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Itieŋo ciɛ baa-mi cor. U fafaaŋgu temma si dii. ");
INSERT INTO cmeNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Bamaŋ kãalãayãŋ-yuɔ, u ka tuɔ ce baa-ba baŋ sireŋ ba cu ba-naa dumaa. ");
INSERT INTO cmeNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","U ciɛ bɛmma; u duɔnya bombolmantaamba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","U hũyãa fɔ̃ŋgũɔ‑i fɔ̃ŋgɔ̃taamba wulaa aa ce nawalaamba da yuŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Nyulmuŋ waa bamaŋ nuɔ‑i, u hãa ba wuo ye, aa bir waamba‑i u saa hã-ba bĩŋkũŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","U juɔ ji kãyã *Isirahɛl-baamba‑i. U juɔ ji kor u cãarãamba‑i. U saa yaŋ u ãnfafamma cemma‑i ");
INSERT INTO cmeNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","*Abiramu‑i-na baa u huoŋ-baamba-na. Uu naa pã nuŋgu faŋgu yaa baa i bĩncuɔmba‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maariŋ kãa Elisabɛti terieŋgu-na, u ciɛ caamba siɛi temma aa suɔ bir kũŋ. ");
INSERT INTO cmeNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabɛti kusũŋguŋ juɔ vãa, wuɔ bɔrɔ naacombiloŋo. ");
INSERT INTO cmeNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","U caantaamba‑i baa u huraamba nu-ma wuɔ u buɔra. Kuɔ gbuu dɔlnu-bɛi wuɔ Diiloŋo firiinu u huɔŋga‑i baa-yo. ");
INSERT INTO cmeNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Yinni niehãi cor, niisiɛi-yiiŋgu-na, ba *jã biloŋo‑i aa haa tuoŋo yerre yaa yuɔ wuɔ Sakari. ");
INSERT INTO cmeNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Nyuŋo yagar aa cira: «I ka tiɛ bĩ-yo Nsãa.» ");
INSERT INTO cmeNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Baa cira: «Ba bĩ naŋ dũŋ-wuoŋ hayo‑i dumaaŋo-na?» ");
INSERT INTO cmeNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Aa yuu tuoŋo‑i bobomma-na uŋ taaraŋ u haa yerre maŋ u biɛŋo-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Tuoŋ wuɔ ce ba hã-yo yilaaŋgu. Uŋ hũyãa yilaaŋgu‑i wuɔ nyɛgɛ̃ŋ wuɔ: «U yerre yaa Nsãa.» Kuɔ cu ba hɔmmu‑i hiere. ");
INSERT INTO cmeNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Terduɔŋgu faŋgu-na, u jumɛlle pãŋ firnu, wuɔ doŋ tuɔ piiye aa tuɔ gbɛliɛŋ Diiloŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Korma pãŋ bel ba nelleŋ-baamba‑i baa-yo. Yibieŋa faŋa-na, nelma famma yaa waa *Yude nilɛiŋa faŋa‑na hiere. ");
INSERT INTO cmeNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Diiloŋo naa silaa ce baa naacombiloŋ daayo‑i cor, a ce umaŋ duɔ nu nel daama‑i, kutieŋo tuɔ yuu u fɛrɛ wuɔ: «Aa naacombiloŋ daayo duɔ ji waa niɛ?» ");
INSERT INTO cmeNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Terduɔŋgu faŋgu-na, *Diiloŋ-Yalle pãŋ yu Sakari huɔŋga‑i. Diiloŋ wuɔ dii nel daama‑i u nuŋgu-na u tuɔ hãl-ma nalãaŋgu wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Itieŋo gbĩɛ baa jaaluŋgu. *Isirahɛl-baamba Diiloŋo temma si dii. U juɔ ji kor u baamba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","U hãa-ye ninsoŋ-koŋkortieŋo. U hielaa-yo *Davidi hãayɛ̃lmba-na. U hielaa-yo u cãarãŋo dũŋ-nu hã-ye. ");
INSERT INTO cmeNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Wuɔ ciɛ u *pɔpuɔrbiemba waŋ ma yaa dii ku huɔŋgu-na ");
INSERT INTO cmeNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","wuɔ u ka hũu-ye i bigãarãamba nammu-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Diiloŋo firiinu u huɔŋga‑i baa i bĩncuɔmba‑i. Uŋ pãa nuŋgu maŋ u *tobisĩnni-na, ku maama saa karaanu-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","U pãa nuŋgu faŋgu yaa baa i bĩncɔiŋo‑i *Abiramu‑i ");
INSERT INTO cmeNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","wuɔ u ka hũu-ye i bigãarãamba nyisɛ̃nni-na aa ce i tiɛ cãa u yaa‑i aa korma baa ta ma da-ye. ");
INSERT INTO cmeNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","I ka waa nelfafaaŋ miɛ baa nelviiŋ miɛ yinni maŋ joŋ a ji hi i kuliiŋgu.» ");
INSERT INTO cmeNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Aa gbɛ̃ bɛpolŋo‑i wuɔ: «Mi biɛ, nuɔ fuɔ, ŋ ka ta yaaŋga Itieŋo-na ka cãa u hũmelle‑i, a ce dumaaŋo-na ba ka ta ba bĩ-ni Dɔrwuoŋo pɔpuɔrbiloŋ nuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ŋ ka ce u baamba suɔ wuɔ Diiloŋo ka hur ba ãmbabalma‑i a kor-ba. ");
INSERT INTO cmeNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Miɛ Diiloŋo faa aa u tiraa waa hujantieŋo. U ka pa bãfɛliɛŋgu yiɛ. Ku ka waa ŋaa bãansɛ̃niɛŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","U ka pa-ku hã bamaŋ dii kukulma-na. U ka pa-ku hã bamaŋ dii kuliiŋ-hũmelle-na. Bãfɛliɛŋgu faŋgu ka dii-ye yaafɛ̃lleŋ-hũmelle-na.» ");
INSERT INTO cmeNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Naacombiloŋ wuɔ tuɔ vãa u jo, kunaŋ kuɔ bi ta ku naara u nelnulle‑i. U waa tĩɛna hĩɛŋ-nu. Huɔŋgu naŋgu juɔ hi, u doŋ tuɔ waŋ Diiloŋ-nelma‑i baa Isirahɛl-baamba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Maari kusũŋguŋ juɔ vãa, kuɔ saanu baa *Oromɛ ba *jãmatigi wuɔ ba kãŋ nuɔmba‑i hiere nelle-na. Ba taa ba bĩ-yo Ogisi. ");
INSERT INTO cmeNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Nuɔkãl daade temma saa ce dede. Huɔŋgu faŋgu-na, Kirinisi yaa waa Siiri yuŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Nɛliɛŋo nɛliɛŋo, u saaya u kã u neholleŋ ka nyɛgɛ̃ŋ u yerre‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Yosɛfu waa *Davidi hãayɛ̃lŋo. U waa tĩɛna Nasarɛti, dii *Galile huɔŋ-na. Fuɔ wuɔ sire terieŋgu-na tuɔ kã u tonelle-na duɔ ka nyɛgɛ̃ŋ u yerre‑i baa u dɔrŋo‑i Maari‑i. Ba bĩ ba nelle‑i Betelɛmu; Davidi ba nelle yaa‑i difande‑i. Dii dii *Yude huɔŋ-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Baŋ kãa, Maari kusũŋgu ka bel-o dii terieŋgu-na ");
INSERT INTO cmeNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","u hoŋ u bilodĩɛlãŋo‑i naacombiloŋo. Ba saa naa da muncɔmmu niraaŋ-dũŋgu-na. Wuɔ ce nyarkpãtãnni fĩnya biloŋo‑i aa galla-yuɔ kũnaŋ-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Nelle kɔtuɔŋgu-na, ãncĩinaamba namba waa ta ba cɔ ba tũlmba caaŋ-nu ba niya-bɛi. ");
INSERT INTO cmeNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ba juɔ'a ba ne da Itieŋo *dɔrpɔpuɔrbiloŋo naŋo‑i ba yaaŋga-na; u caraaya-bɛi baa cecerma naŋ temma; ba hulɛiŋa pãŋ caar. ");
INSERT INTO cmeNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Dɔrpɔpuɔrbiloŋo gbɛ̃-ba wuɔ: «Baa na yaŋ korma da-na, mi juɔ baa neldɔdɔlma da mi ji tũnu-nɛi. Ma ka fɛ̃ nuɔmba hɔmmu‑i hiere: ");
INSERT INTO cmeNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Isuɔŋ daaku-na, na koŋkortieŋo huɔŋ Davidi ba nelle-na. Diiloŋ uŋ pãa nuŋgu‑i wuɔ u ka saaŋ *Koŋkortieŋo maŋ u yaa‑i, aa u yaa Itieŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Naŋ ka suɔ-yo dumaa ku yaa daaku: Da na ka hi, na ka da ba fĩɛnya bilosĩɛlãŋo naŋo baa nyarkpãtãnni aa galla-yuɔ kũnaŋ-na; u yaa‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ba'a ba ne, a da dɔrpɔpuɔrbiemba namba juɔ ji naara daayo‑i, ba ta ba hãl ba tuɔlnu Diiloŋo‑i. Ba maama saa waa dɛi baa yuliiŋgu‑i. Ba taa ba hãl wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Diiloŋo gbĩɛ baa tuɔlnumma dii dɔrɔ‑i-na, aa uŋ dɔlaa nelbiliemba‑i, yaafɛ̃lle waa hĩɛma-na.» ");
INSERT INTO cmeNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Dɔrpɔpuɔrbiembaŋ juɔ hãl tĩ, ba ta nyugũŋ dɔrɔ. Baŋ taa, ãncĩinaamba cira: «Yaaŋ i kã nelleŋ-huɔŋga-na i ka ne Diiloŋ uŋ puɔraa ba ji waŋ mamaŋ baa-ye maŋ ciɛ dumaa.» ");
INSERT INTO cmeNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Baa sire gbãana kã ka da Maari‑i baa Yosɛfu‑i baa bilosĩɛlãŋo‑i kũnaŋo-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Baŋ daa biloŋo‑i, baa doŋ ta ba piiye dɔrpɔpuɔrbiloŋ uŋ waaŋ mamaŋ u kũŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Umaŋ duɔ nu-ma, ku ce-yo gbɛrɛ. ");
INSERT INTO cmeNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maari wuɔ bella nel daama‑i hiere u huɔŋ-na tuɔ jɔguɔŋ-ma; u saa yaŋ ma diei karaanu-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ku huoŋgu-na, ãncĩinaamba bir gũunu. Dɔrpɔpuɔrbiloŋ uŋ waaŋ-ma baa-ba dumaa, ba bi kaa da-ma dumɛi. Baa ta ba hãl nɛini ba gbɛliɛŋ Diiloŋo‑i ba kũŋ. ");
INSERT INTO cmeNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Biloŋ uŋ juɔ da yinni niisiɛi‑i, baa *jã-yo aa haa u yerre‑i Yesu. *Dɔrpɔpuɔrbiloŋo naa pigãaŋ Maari‑i yerre fande yaa‑i aa u kusũŋgu suɔ da ku yiɛra-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Naacombiloŋ u bĩncuɔmba yuŋ-maama migãamaŋ-yiiŋguŋ juɔ hi ŋaa maŋ waaŋ dumaa *Moisi *ãnjĩnamma-na, baa bi kã baa naacombiloŋo‑i *Diilodubuɔ‑i-na dii *Yerusalɛmu‑i-na da ba ka pã-yo hã Diiloŋo‑i ");
INSERT INTO cmeNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ŋaa maŋ bi nyɛgãaŋ dumaa Diiloŋ-nelma-na wuɔ: «Naacombilodĩɛlãŋo saaya u pã hã Diiloŋo.» ");
INSERT INTO cmeNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Baa naa bi saaya ba pã niikonni a saa baa ãnjĩnaduɔŋ daama‑i: koŋhuriimba hãi sisɔ nɔnsɔr ba huriimba hãi. ");
INSERT INTO cmeNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","A ne da bĩncɔiŋo naŋo waa Yerusalɛmu‑i-na, ba taa ba bĩ-yo Siminyɔ. U taa u nu Diiloŋo nuŋgu‑i aa tiraa vii baa-yo. Umaŋ naa saaya u jo ji kor *Isirahɛl-baamba‑i u taa u niya u jomma‑i. *Diiloŋ-Yalle waa-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Dii naa tũnu-yuɔ wuɔ Itieŋ uŋ ka saaŋ *Koŋkortieŋo maŋ, u ka da-yo baa u yufelle aa suɔ ku. ");
INSERT INTO cmeNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Diiloŋ-Yalleŋ waa-yuɔ dumaaŋo-na, wuɔ kã Diilodubuɔ‑i-na. Baŋ kãa baa Yesu‑i da ba ka pã-yo hã Diiloŋo‑i ŋaa maŋ nyɛgãaŋ dumaa ãnjĩnamma-na, ");
INSERT INTO cmeNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Siminyɔ wuɔ hũu-yo tũu-yo aa naa cira: ");
INSERT INTO cmeNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Itie, fiɛfiɛ fuɔ, niŋ waaŋ mamaŋ ma ciɛ. Ŋ cãarãŋo huɔŋga fĩɛ; ŋ gbãa hũu-yo dumaa. ");
INSERT INTO cmeNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Mi daa Koŋkortieŋo‑i baa mi yufelle. ");
INSERT INTO cmeNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Niŋ saaŋ umaŋ hã nelbiliemba‑i hiere, mi daa-yo. ");
INSERT INTO cmeNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","U yaa *niɛraamba fitĩnuɔ‑i. U yaa ka ce ba suɔ ŋ saaŋgu. Aa ce ŋ baamba‑i Isirahɛl-baamba da yerre.» ");
INSERT INTO cmeNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Kuɔ cu naacombiloŋo bĩncuɔmba hɔmmu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Siminyɔ wuɔ cãrã Diiloŋo‑i hã-ba aa naa gbɛ̃ nyuŋo‑i wuɔ: «Ŋ biɛŋo jomma ka kɔsuɔŋ nuɔmba bɔi *Isirahɛl-na aa bi kor nuɔmba bɔi. U ka pigãaŋ Diiloŋo sĩnni‑i, ŋga nuɔmba ka bigãaŋ-yo. ");
INSERT INTO cmeNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","A ce dumaaŋo-na, u ka puure nuɔmba bɔi kusũŋ-maama. Aa nuɔ fuɔ, ciɛŋ nuɔ, ãnjɔguɔma ka gbuu ko-ni.» ");
INSERT INTO cmeNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","*Diilopɔpuɔrbiloŋo naŋo bi waa ba taa ba bĩ-yo Ani. Asɛr dũŋ-wuoŋo'i waa. Ba taa ba bĩ u to‑i Faniɛl. Uu naa gbuu vãa ce cicɔrŋo. Uŋ siire u bilosĩnni-na aa naacolŋo maŋ jã-yo, naacolŋo ciɛ bieŋ niehãi baa-yo aa ku aa yaŋ-yo. ");
INSERT INTO cmeNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","U saa tuɔ naa Diilodubuɔ‑i-na. U taa u dii sũŋgu‑i aa tuɔ cãrã Diiloŋo‑i bãaŋgu‑i baa isuɔŋgu‑i. A ne da u bieŋ komuɔŋa naa baa a naa'i waa belle fande-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Fuɔ wuɔ bi jo huɔŋgu faŋgu-na ji da naacombiloŋo‑i. Wuɔ jaal Diiloŋo‑i aa naa tuɔ piiye u maama baa bamaŋ taa ba niya Yerusalɛmu kormaŋ-yiiŋgu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Mamaŋ nyɛgãaŋ ãnjĩnamma-na, Yesu bĩncuɔmbaŋ kaa ce-ma tĩ, baa bir kã Nasarɛti‑i-na; ba nelle yaa‑i difande‑i dii *Galile‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Naacombiloŋ wuɔ tuɔ vãa u jo; u taa u nu nelma‑i ŋaa bige‑i! Diiloŋo naa firnu u huɔŋga‑i baa-yo. ");
INSERT INTO cmeNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Belle belle, Yesu bĩncuɔmba taa ba kã ba ce *kɔrsĩnni tĩmmaŋ-ponsaaŋgu‑i *Yerusalɛmu‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yesuŋ juɔ da bieŋ cĩncieluo a hãi, baa kã baa-yo. ");
INSERT INTO cmeNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ponsaaŋguŋ kaa bãl, baa gũunu. Yesu wuɔ yaŋ-ba aa tĩɛna dii Yerusalɛmu‑i-na ba saa suɔ. ");
INSERT INTO cmeNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Nuɔmba naa maara cor hũmelle-na. Baŋ naa-yo, ba da niɛ sĩ uu dii nuɔmba hɔlma-na. Ba wuɔ yififiiŋgu, moloŋ yufelle saa haa-yuɔ. Ba doŋ ta ba taara-yuɔ nuɔmba-na ");
INSERT INTO cmeNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ba sa da-yo. Ba naa ba bir ta ba taara ba kã Yerusalɛmu‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Yinni hãi cor, siɛliŋ-yiiŋgu‑i, ba kã ka da-yo *Diilodubuɔ‑i-na; u tĩɛnaana *ãnjĩnamma pigãataamba hɔlma-na tuɔ yuu-ba ba ta ba piiye u tuɔ nu. ");
INSERT INTO cmeNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Bamaŋ waa hiere, u maama cu ba hɔmmu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","U bĩncuɔmbaŋ kaa da-yo dumaaŋo-na, kuɔ ce-ba gbɛrɛ. Nyuŋ wuɔ cira: «Naacombilo, ŋ ciɛ bige‑i yiɛ dumandɛ‑i-na? Ŋ ciɛ i hulɛiŋa fũnuŋ caar i sire tiɛ taara-niɛ.» ");
INSERT INTO cmeNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yesu wuɔ cira: «Bige‑i ciɛ na ta na taara-miɛ? Na saa suɔ wuɔ mi saaya mi waa mi To dũŋgu-na wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ba saa suɔ u nelma yuŋgu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Wuɔ naa wuɔ sire ba ta Nasarɛti‑i-na. U taa u nu u bĩncuɔmba nuŋgu‑i. Mamaŋ ciɛ cor hiere, nyuŋo saa yaŋ ma diei karaanu-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesu wuɔ tuɔ vãa u jo aa kunaŋgu bi ta ku naara u nelnulle‑i. U maama taa ma dɔlnu Diiloŋo‑i aa bi ta ma dɔlnu nuɔmba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","*Oromɛ ba *jãmatigi maŋ ba naŋ bĩŋ-yoŋ Tibɛr, uŋ daa bieŋ cĩncieluo baa a ndii‑i belle maŋ nuɔ‑i fɔ̃ŋgũɔ‑i-na, belle fande-na *Pɔ̃se-Pilati yaa waa *Yude yuŋgu-na aa *Erɔdi waa *Galile yuŋ-nu, u mɔlɔ̃‑i Filipu fuɔ waa Iture yuŋ-nu baa Tirakoniti bi yuŋ-nu, Lisaniyasi fuɔ waa Abilɛni yuŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ani‑i baa Kayifu‑i ba yaa waa *Diilojigãntaamba yuntaamba‑i. Belle fande'i nuɔ‑i Diiloŋ uŋ caraaya Sakari biɛŋo‑i Nsãa‑i *hĩɛkuraaŋgu-na a piiye baa-yo. ");
INSERT INTO cmeNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Uŋ piiye baa-yo dumaaŋo-na, wuɔ tuɔ wuɔra nilɛiŋa maŋ *Yurdɛ̃ kɔtɔnni-na u waŋ baa nuɔmba‑i wuɔ ba nanna ba cilɔbabalaŋo‑i aa ba *batiseŋ ku yaa Diiloŋo ka hur ba ãmbabalma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Diiloŋ uŋ puɔraa *Isayi waŋ mamaŋ, ma'i sĩ daama‑i wɛi? Isayi waaŋ-ma wuɔ: «Molo dii tuɔ hohuola hĩɛkuraaŋgu-na wuɔ: ‹Migãaŋ Itieŋo hũmieŋa‑i. Cãaŋ-yaŋ na viinu-yɛi. ");
INSERT INTO cmeNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Diiyaanuŋ fonni‑i! Tãnniŋ yeŋ terni maŋ nuɔ‑i baa tãntũnni‑i, na herra-niɛ na saanu-niɛ. Hũmieŋaŋ miɛlãa terni maŋ nuɔ‑i, na viinu-yɛi, aa amaŋ cuolaanu, na diinu-yɛi. ");
INSERT INTO cmeNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Nuɔmba‑i hiere ba ka da Diiloŋ uŋ ka kor-ba dumaa.›» ");
INSERT INTO cmeNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Nuɔmba bɔi taa ba jo Nsãa tuɔ batiseŋ-ba. Wuɔ tuɔ waŋ baa-ba wuɔ: «Nelbabalaaŋ namaa temma‑i daana‑i, hai juɔ tũnu-nɛi wuɔ da na batiseŋ Diiloŋo siɛ ka gãŋ baa-na? ");
INSERT INTO cmeNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Taa na ce kumaŋ faa, ku yaa ka pigãaŋ wuɔ na naana na cilɔbabalaŋo‑i kelkel. Baa na ta na ne wuɔ sĩ *Abiramuŋ yeŋ na bĩncɔiŋo Diiloŋo siɛ ka gãŋ baa-na! Mi tũnu-nɛi, naŋ fiɛ da tãmpĩɛŋa maŋ daaya‑i, Diiloŋo gbãa bir-a ce-ya Abiramu hãayɛ̃lmba namaa fuoŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Maale nuŋgu saaraa jĩna. Tibiiŋgu maŋ da ku saa maŋ biefɛfɛiŋa, ku jũŋ aa sɛnu.» ");
INSERT INTO cmeNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Nuɔŋ baa ta ba yuu-yo wuɔ: «Kufaŋgu terieŋgu-na, i saaya i ce bige‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Wuɔ gbɛ̃-ba wuɔ: «Joŋgorbaa-ba hãi da ba waa baa nuɔni maŋ, umaŋ saa da bĩŋkũŋgu ŋ hã-yo u diei, aa niiwuoŋ da ni bi waa baa nuɔni maŋ, umaŋ saa da duɔ wuo ŋ hã-yo.» ");
INSERT INTO cmeNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","*Nampohũutaamba namba naa bi jo u duɔ ji batiseŋ-ba, bafaŋ baa yuu-yo wuɔ: «Hãalãtie, miɛ i saaya i ce bige‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Wuɔ gbɛ̃ bafamba‑i wuɔ: «Nuɔmbaŋ saaya ba ta ba pã kumaŋ ba hã-na, baa na ta na hũu na cor kufaŋgu‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Sorosibaa-ba namba yuu-yo wuɔ: «Aa miɛ fuɔ, i saaya i ce bige‑i?» Wuɔ gbɛ̃ bafamba‑i wuɔ: «Baa na ta na du nuɔmba‑i na hũu ba gbeiŋa‑i. Taa na yii baa na cufaluŋgu yaa yoŋ.» ");
INSERT INTO cmeNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Diiloŋ uŋ pãa nuŋgu‑i wuɔ u ka saaŋ *Koŋkortieŋo maŋ, nuɔmba taa ba niya u jomma‑i. Baŋ juɔ da Nsãa‑i ba da niɛ sĩ u yaa‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Nsãa wuɔ gbɛ̃-ba wuɔ: «Muɔmi batiseŋ-na baa hũmma yoŋ, ŋga unaa jo dii, u fɔ̃ŋgũɔ jĩɛnya mɛi wuoŋo‑i, mɛi saa piɛra u natãaŋgu‑i. Fuɔ ka batiseŋ-na baa *Diiloŋ-Yalle baa dãamu. ");
INSERT INTO cmeNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Kɔkɔruɔŋgu dii u naŋga-na. U ka pe u dĩmma‑i. Duɔ ji pe-ma tĩ hiere torre-na, u ka kũɔl belle‑i dii-de inɔŋgɔ̃-na aa sɛnu fuoru‑i baa dãamu. Dãamu fammu sa dĩŋ dede.» ");
INSERT INTO cmeNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Nsãa taa u dii nelma bɔi nuɔmba tũnni-na, a ce dumaaŋo-na u taa u waŋ *Neldɔdɔlma‑i baa-ba. ");
INSERT INTO cmeNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Erɔdi wuɔ hũyãa u mɔlɔ̃ ciɛŋo a dii-yo. Ba taa ba bĩ ciɛŋo‑i Erodiyadi. Aa naa tiraa ce wɛima bɔi ma saa fa. U yaa waa nellentieŋo‑i Galile‑i-na. Nsãa wuɔ fulnu-yuɔ wuɔ u maacemma saa fa. ");
INSERT INTO cmeNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Wuɔ ce baa bel Nsãa‑i dii-yo kaso, a migãaŋ tuɔ naara kunaŋgu u cãlmuɔ‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Nuɔmba‑i hiere ba kãa ka *batiseŋ. Baŋ taa ba batiseŋ huɔŋgu-na, Yesu wuɔ bi kã ba ka batiseŋ-yo. Baŋ baatiseŋ-yo tĩ, wuɔ tuɔ cãrã Diiloŋo‑i. Dɔrɔ wuɔ puur. ");
INSERT INTO cmeNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","*Diiloŋ-Yalle hel koŋhuruŋ temma jo ji diire-yuɔ. Baa nu molo piiye dɔrɔ‑i-na wuɔ: «Mi Biɛŋo yaa nuɔŋo‑i, ŋ maama sa suɔ aa dɔlnu-miɛ; nuɔnɛi fĩɛŋ mi huɔŋga‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesuŋ duɔŋ u maacemma‑i huɔŋgu maŋ nuɔ‑i, u waa baa bieŋ komorre baa cĩnciel temma. Nuɔmba taa ba jɔguɔŋ wuɔ Yosɛfu biɛŋo. Yosɛfu to‑i ba taa ba bĩ-yo Eli. ");
INSERT INTO cmeNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli to‑i ba taa ba bĩ-yo Mata. Mata to‑i ba taa ba bĩ-yo Levi. Levi to‑i ba taa ba bĩ-yo Mɛlki. Mɛlki to‑i ba taa ba bĩ-yo Yanai. Yanai to‑i ba taa ba bi bĩ-yo Yosɛfu. ");
INSERT INTO cmeNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yosɛfu faŋo to‑i ba taa ba bĩ-yo Matatiyasi. Matatiyasi to‑i ba taa ba bĩ-yo Amɔsi. Amɔsi to‑i ba taa ba bĩ-yo Nahɔmu. Nahɔmu to‑i ba taa ba bĩ-yo Ɛsili. Ɛsili to‑i ba taa ba bĩ-yo Nagai. ");
INSERT INTO cmeNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai to‑i ba taa ba bĩ-yo Maatĩŋo. Maatĩŋ to‑i ba taa ba bi bĩ-yo Matatiyasi. Matatiyasi faŋo to‑i ba taa ba bĩ-yo Semiɛ. Semiɛ to‑i ba taa ba bĩ-yo Yosɛki. Yosɛki to‑i ba taa ba bĩ-yo Yoda. ");
INSERT INTO cmeNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda to‑i ba taa ba bĩ-yo Yohana. Yohana to‑i ba taa ba bĩ-yo Eresa. Eresa to‑i ba taa ba bĩ-yo Sorobabɛl. Sorobabɛl to‑i ba taa ba bĩ-yo Salatiɛl. Salatiɛl to‑i ba taa ba bĩ-yo Neri. ");
INSERT INTO cmeNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri to‑i ba taa ba bi bĩ-yo Mɛlki. Mɛlki faŋo to‑i ba taa ba bĩ-yo Adi. Adi to‑i ba taa ba bĩ-yo Kosamu. Kosamu to‑i ba taa ba bĩ-yo Ɛlmadamu. Ɛlmadamu to‑i ba taa ba bĩ-yo Ɛr. ");
INSERT INTO cmeNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ɛr to‑i ba taa ba bi bĩ-yo Yesu. Yesu faŋo to‑i ba taa ba bĩ-yo Eliesɛr. Eliesɛr to‑i ba taa ba bĩ-yo Yorimu. Yorimu to‑i ba taa ba bi bĩ-yo Mata. Mata faŋo to‑i ba taa ba bi bĩ-yo Levi. ");
INSERT INTO cmeNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi faŋo to‑i ba taa ba bĩ-yo Siminyɔ. Siminyɔ to‑i ba taa ba bĩ-yo Yuda. Yuda to‑i ba taa ba bi bĩ-yo Yosɛfu. Yosɛfu faŋo to‑i ba taa ba bĩ-yo Yonamu. Yonamu to‑i ba taa ba bĩ-yo Eliyakimu. ");
INSERT INTO cmeNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyakimu to‑i ba taa ba bĩ-yo Meleya. Meleya to‑i ba taa ba bĩ-yo Mena. Mena to‑i ba taa ba bĩ-yo Matata. Matata to‑i ba taa ba bĩ-yo Natamu. Natamu to yaa *Davidi. ");
INSERT INTO cmeNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Davidi to yaa Yese. Yese to yaa Yobɛdi. Yobɛdi to yaa Bosi. Bosi to yaa Sala. Sala to yaa Nasɔ̃. ");
INSERT INTO cmeNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasɔ̃ to yaa Aminadabu. Aminadabu to yaa Adimɛ. Adimɛ to yaa Arni. Arni to yaa Esirɔmu. Esirɔmu to yaa Perɛsi. Perɛsi to yaa *Yuda. ");
INSERT INTO cmeNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yuda faŋo to yaa *Yakɔbu. Yakɔbu to yaa *Isaki. Isaki to yaa *Abiramu. Abiramu to yaa Tera. Tera to yaa Nahɔr. ");
INSERT INTO cmeNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahɔr to yaa Seruge. Seruge to yaa Erehu. Erehu to yaa Pelɛgi. Pelɛgi to yaa Ebɛr. Ebɛr to yaa Sala. ");
INSERT INTO cmeNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala faŋo to yaa Kanamu. Kanamu to yaa Arpasadi. Arpasadi to yaa Sɛmu. Sɛmu to yaa *Nowe. Nowe to yaa Lemɛki. ");
INSERT INTO cmeNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lemɛki to yaa Matusalɛmu. Matusalɛmu to yaa Enɔki. Enɔki to yaa Yerɛdi. Yerɛdi to yaa Maleleyɛl. Maleleyɛl to yaa Kenamu. ");
INSERT INTO cmeNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenamu to yaa Enɔsi. Enɔsi to yaa Sɛti. Sɛti to yaa Adãma. Diiloŋ uŋ hielaa miwaaŋo‑i u maa Adãma faŋo yaa jĩna. ");
INSERT INTO cmeNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","*Diiloŋ-Yalle naa yu Yesu huɔŋga‑i. Uŋ hilaa *Yurdɛ̃‑i-na, diɛ kã baa-yo *hĩɛkuraaŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Uŋ kãa terieŋgu-na, *Sitãni wuɔ nyaanu-yuɔ duɔ ka guɔl u gbeini‑i. U ciɛ yinni komuɔŋa hãi baa-yo tãalma-na. Yinni fanni-na, Yesu saa dii kuuwuoŋgu u nuŋgu-na. Ku huoŋgu-na, nyulmu sire cuɔl-o. ");
INSERT INTO cmeNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Sitãni wuɔ gbɛ̃-yo wuɔ: «Da kuɔ Diiloŋ-Biɛŋo yaa nuɔŋo‑i kelkel, ce tãmpɛ̃l daade bir kuuwuoŋgu i ne!» ");
INSERT INTO cmeNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesu wuɔ cira: «Ma nyɛgãaŋ Diiloŋ-nelma-na wuɔ: ‹Niiwuoni‑i yoŋ, ni siɛ gbãa ce nɛliɛŋ nuɔ ŋ ba.›» ");
INSERT INTO cmeNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Uŋ waaŋ mafamma‑i, Sitãni nyugũŋ baa-yo dɔrɔ a ka pigãaŋ-yo nilɛiŋa‑i hiere hĩɛma-na da hɔlhɔlhɔl ");
INSERT INTO cmeNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","aa cira: «Niŋ daa nilɛiŋa maŋ daaya‑i hiere baa a huɔya-niini‑i, mɛi waaŋa; da miɛ mi ka ce kumaŋ baa-ya mi ce. ");
INSERT INTO cmeNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Da ŋ dũuna jaal-mi, mi ka hã-ni baa-ya.» ");
INSERT INTO cmeNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesu wuɔ cira: «Ma nyɛgãaŋ Diiloŋ-nelma-na wuɔ: ‹Ŋ saaya ŋ ta ŋ dũuna ŋ jaal Itieŋo‑i Diiloŋo yaa‑i; aa ŋ ta ŋ cãa u yaa u diei yoŋ.›» ");
INSERT INTO cmeNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Sitãni wuɔ hiire baa-yo a kã baa-yo *Yerusalɛmu‑i-na, ka haa-yo *Diilodubuɔ dɔrɔ‑i-na aa cira: «Da kuɔ Diiloŋ-Biɛŋo yaa nuɔŋo‑i kelkel, tie ŋ diire hĩɛma-na i ne. Ma sĩ ma nyɛgãaŋ Diiloŋ-nelma-na wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","‹Diiloŋo ka ce u *dɔrpɔpuɔrbiemba ta ba niya-niɛ.› ");
INSERT INTO cmeNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Aa tiraa cira: ‹Ba ka tũu-ni ba nammu-na ŋ baa ka tisĩŋ ŋ fɛrɛ terieŋgu.›» ");
INSERT INTO cmeNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesu wuɔ cira: «Ma bi nyɛgãaŋ Diiloŋ-nelma-na wuɔ: ‹Baa dãŋ Itieŋo‑i Diiloŋo‑i ŋ ne.›» ");
INSERT INTO cmeNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Sitãni wuɔ ce ji gbɛ̃; u saa ji gbãa guɔl Yesu gbeini‑i. Wuɔ naa u ta aa yaŋ-yo tuɔ cie huɔŋgu naŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","*Sitãniŋ juɔ ta aa yaŋ Yesu‑i, wuɔ bir kã *Galile‑i-na baa *Diiloŋ-Yalle fɔ̃ŋgũɔ‑i. Uŋ kãa, baa fũnuŋ ta ba gbɛliɛŋ-yo terni-na hiere. ");
INSERT INTO cmeNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","U taa u waŋ Diiloŋ-nelma‑i *Diilonelhãalãdũnni-na. Nuɔmba‑i hiere ba taa ba kaal-o. ");
INSERT INTO cmeNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yiiŋgu naŋgu-na, wuɔ ji kã Nasarɛti‑i-na. U vãa kusuɔŋ-nu'i. *Yitĩɛnaŋguŋ juɔ hi, wuɔ kã *Diilonelhãalãdũŋgu-na. U taa u kã koko. Diiloŋ-nelmaŋ juɔ hi kalamma, wuɔ sire duɔ kalaŋ. ");
INSERT INTO cmeNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Baa hã-yo *Diilopɔpuɔrbiloŋo‑i *Isayi sɛbɛ yaa wuɔ u kalaŋ. Wuɔ puur terieŋgu maŋ uŋ nyɛgãaŋ wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Itieŋo *Yalle dii mi yuŋgu-na. Na saa da, u hielaa-mi mi da mi waŋ *Neldɔdɔlma‑i baa sũntaamba‑i. U puɔraa-mi mi da mi waŋ baa kɔraamba‑i wuɔ kɔrsĩnni tĩɛ, aa waŋ baa yiriemba‑i wuɔ ba yufieŋa ka puur, aa bamaŋ dii pɔrtɔmma-na wuɔ pɔrtɔmma tĩɛ, ");
INSERT INTO cmeNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","aa waŋ baa-ba wuɔ Diiloŋo ka firnu u huɔŋga‑i baa nuɔmba‑i fiɛfiɛ‑i-na.» ");
INSERT INTO cmeNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Uŋ kalaaŋ tĩ, wuɔ suuye sɛbɛ‑i aa hã Diilonelhãalãdũŋgu maacenceroŋo‑i baa-yo aa tĩɛna. Nuɔmba‑i hiere baa dĩŋ-yuɔ ta ba ne-yo. ");
INSERT INTO cmeNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Wuɔ cira: «Miŋ kalaaŋ nelma maŋ daama‑i, ma ciɛ nyuŋgo daayo'i nuɔ‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Nuɔmba kar da hãmmu! Wuɔ cor tuɔ piiye. U nelma taa ma suurnu nuɔmba‑i ma cor. Ba hɔmmu cu; ba ta ba yuu ba-naa wuɔ: «Yosɛfu biɛŋo'i sĩ wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yesu wuɔ gbɛ̃-ba wuɔ: «Yiiŋgu dii baa yiiŋgu, na ka naŋ gbãnalãaŋ daaku‑i baa-mi wuɔ: ‹Pɛrruntie, sire ŋ fɛrɛ i ne!› Aa na ka cira: ‹I nuɔ niŋ ciɛ mamaŋ hiere Kafarnamu‑i-na, ce ma temma naŋ fɛrɛŋ nelle-na i ne.›» ");
INSERT INTO cmeNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Aa tiraa gbɛ̃-ba wuɔ: «Yaaŋ mi waŋ ninsoŋo‑i baa-na: Diilopɔpuɔrbiloŋo‑i, u nelleŋ-baamba sa kãŋ-yo. ");
INSERT INTO cmeNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Yaaŋ mi tũnu-nɛi, *Eli bãaŋgu-na, bikulcaamba bɔi waa *Isirahɛl-na, Diiloŋ wuɔ ce bieŋa siɛi baa caamba niediei u saa dãa. Nyul muɔ suur nelle-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ŋga Diiloŋ wuɔ yaŋ bafamba‑i aa puɔr Eli‑i bikulciɛŋo naŋ wulaa Sarɛputa, dii Sidɔ̃. ");
INSERT INTO cmeNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Aa Diilopɔpuɔrbiloŋo‑i Elise bãaŋgu-na, *wontuɔrmba bɔi waa Isirahɛl-na, ŋga Elise saa ji sire u diei *Isirahɛl-baamba-na; u yaaŋ bafamba‑i aa sire umaŋ naa hilaa Siiri mara‑i-na jo, ba taa ba bĩ-yo Naama.» ");
INSERT INTO cmeNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Baŋ juɔ nu mafamma‑i, ba hɔmmu pãŋ guɔla hiere. ");
INSERT INTO cmeNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ba nelle waa tãnuŋ-nu. Baa sire tisĩŋ-yo hiel-o Diilonelhãalãdũŋgu-na, a hel baa-yo nelleŋ-huɔŋga-na, a nyugũŋ baa-yo tãnuŋgu dɔrɔ‑i-na wuɔ ba ka sɛ-yo nanna. ");
INSERT INTO cmeNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Yesu wuɔ yaŋ-ba aa yɛgɛl hel ba hɔlma-na ta. ");
INSERT INTO cmeNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yesuŋ hilaa Nasarɛti‑i-na, wuɔ ta kã Kafarnamu. *Galile nelle nande‑i difande‑i. Uŋ kãa, wuɔ kã *Diilonelhãalãdũŋgu-na *yitĩɛnaŋgu-na ka tuɔ waŋ Diiloŋ-nelma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","U taa u piiye baa bibɛsĩnni u yaŋ *ãnjĩnamma pigãataamba‑i; a ce dumaaŋo-na, u nelma taa ma suurnu nuɔmba‑i ma cor. ");
INSERT INTO cmeNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Naacolŋo naŋo waa ba hɔlma-na, *jĩna waa u yuŋgu-na. Wuɔ kaasĩŋ da gbagaga wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Nasarɛtitaaŋ Yesu! I ciɛ-ni niɛ? Ŋ juɔ da ŋ ji kɔsuɔŋ-ye wuɔ bige‑i ciɛ? Mi suɔ-ni, Diiloŋ-nolŋo yaa nuɔŋo‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesu wuɔ cira: «Suuye ŋ nuŋgu‑i aa ŋ cor ŋ hel naacolŋo-na.» Jĩna wuɔ mal naacolŋo‑i nuɔmba-na aa naa hel u saa ce kuubabalaaŋgu yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Kuɔ ce nuɔmba‑i gbɛrɛ, baa ta ba piiye baa ba-naa wuɔ: «Naacolŋ daayo hii dɛ! Baa jĩnabaa-ba‑i hiere u donya-bɛi baa u nuŋ-ãndaaŋgu.» ");
INSERT INTO cmeNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Kuŋ ciɛ dumaaŋo-na, u yerre gbuo terni‑i hiere. ");
INSERT INTO cmeNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Uŋ hilaa *Diilonelhãalãdũŋgu-na, wuɔ kã Simɔ cĩiŋ-nu. Simɔ cura sa waa hĩnni; u kũɔma naa gbuu huol da pãmpãmpãŋ, u galla. Ba cãrã Yesu‑i wuɔ u sire-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","U kã ka ture ciɛŋo yudɔrɔ‑i-na, a nuola jarma‑i. Ciɛŋo pãŋ da u fɛrɛ terduɔŋgu faŋgu-na. Wuɔ sire tuɔ ce ba nersĩnni‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Bãaŋguŋ juɔ ta ku suur huɔŋgu maŋ nuɔ‑i, jaambaŋ waa baa bamaŋ hiere nelle-na, baa jo baa-ba. Yesu wuɔ tuɔ haa u nammu‑i bɛi u sire-bɛi. ");
INSERT INTO cmeNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Jaaŋ daaba hɔlma-na, *jĩnabaa-ba waa nuɔmba bɔi-na. Duɔ donya umaŋ baamba‑i, ba ta ba kaasĩŋ wuɔ: «Diiloŋ-Biɛŋo yaa nuɔŋo‑i kelkel!» Jĩnabaa-ba naa suɔ wuɔ Diiloŋ uŋ pãa nuŋgu‑i aa saaŋ *Koŋkortieŋo maŋ, u yaa Yesu‑i; a ce dumaaŋo-na Yesu tuɔ nuola-bɛi, u sa yaŋ ba da piiye. ");
INSERT INTO cmeNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Cuoŋ juɔ kaal, u sire kã hĩɛŋ-nu. Nuɔmba taara-yuɔ ka da-yo aa ta ba taara ba bella-yuɔ u baa da ta aa yaŋ-ba. ");
INSERT INTO cmeNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Wuɔ waŋ baa-ba wuɔ: «Mi saaya mi wuɔra waŋ *Diiloŋ-bãaŋgu *Neldɔdɔlma‑i nilɛiŋa naŋa-na hiere; Diiloŋo puɔraa-mi baa ma yaa.» ");
INSERT INTO cmeNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Aa naa ta tuɔ wuɔra *Yude *Diilonelhãalãdũnni-na u waŋ Diiloŋ-nelma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Yiiŋgu naŋgu-na, Yesu kãa Genesarɛti dalaŋga-na. Nuɔmba kũɔl ba-naa kã u wulaa da ba ka nu Diiloŋ-nelma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Wuɔ da benni nanni‑i ni hãi hũmma nuŋgu-na, ni taamba naa hel ta ba saara ba jɔnaamba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Wuɔ kã ka suur kunaŋgu-na, Simɔ kũŋgu'i waa aa ce u forra-kuɔ cɛllɛ koŋkondaaŋgu-na. Uŋ furaaya-kuɔ, Yesu wuɔ tĩɛna a doŋ tuɔ waŋ Diiloŋ-nelma‑i u pigãaŋ nuɔmba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Uŋ juɔ piiye tĩ, wuɔ gbɛ̃ Simɔ‑i wuɔ: «Kã pututu terieŋgu-na, na ka naŋ na jɔnaamba‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simɔ wuɔ cira: «Hãalãtie, i naaŋ juɔŋo‑i cɔ i saa da bĩŋkũŋgu bel, ŋga niŋ waaŋ-ma dɛi, mi siɛ yagar ŋ nuŋgu‑i.» Aa naa ta. ");
INSERT INTO cmeNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Baŋ kãa ka naŋ ba jɔnaamba‑i, baa bel titiraamba‑i jɔnaamba yu ta ba yii da ba kar. ");
INSERT INTO cmeNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ba nabentaamba namba waa, baa fara bĩ ba jo baa ba beŋo‑i a ji kãyã-bɛi ba jul titiraamba‑i. Baŋ julii-ba, benni‑i ni hãi‑i-na niɛ yu ta ni yii da ni nyiɛrã hũmma-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simɔ-Piɛrŋ daa mafamma‑i, wuɔ kã ka dũuna Yesu caaŋgu-na aa naa cira: «Itie, muɔŋo‑i ãmbabalmanceroŋ muɔ, baa piɛ-mi.» ");
INSERT INTO cmeNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Titiraaŋ daaba ciinumma diyaa korma yuɔ baa bamaŋ waa baa-yo hiere beŋo-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Halle u nagbosobaa-ba‑i Sebede bɛpuɔmba‑i korma bi bilaa-ba. Ba taa ba bĩ unaŋo‑i Sake aa bĩ unaŋo‑i Nsãa. Yesu wuɔ waŋ baa Simɔ‑i wuɔ: «Baa yaŋ korma da-ni, a doŋ nyuŋgo, ŋ ka yaŋ tetebelle‑i aa ta ŋ dii nuɔmba‑i Diiloŋ-hũnuŋ-nu.» ");
INSERT INTO cmeNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Yesuŋ waaŋ mafamma‑i, baa hel baa ba benni‑i bomborma-na ka yaŋ-ni aa cu u huoŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yiiŋgu naŋgu-na, Yesu kãa nelle nande-na. *Wontorŋo naŋo da-yo aa piɛ ka dũuna u caaŋ-nu aa cira: «Itie, da ŋ ta ŋ taara mi jarma ta-miɛ, mi suyaa miɛ ku siɛ yar-ni.» ");
INSERT INTO cmeNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesu wuɔ haa u naŋga‑i yuɔ aa naa cira: «Mi taara ŋ jarma ta.» Naacolŋo jarma pãŋ ta yuɔ terduɔŋgu faŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yesu wuɔ waŋ-ma kuola-mɛi baa-yo wuɔ u baa yaŋ ma hel; aa u kã *Diilojigãntieŋo wulaa u ka ne-yo, aa u pã niikonni maŋ dii pãmma u hã-yo u migãaŋ u yuŋ-maama‑i ŋaa *Moisiŋ nyɛgãaŋ-ma dumaa. Ku yaa nuɔmba ka suɔ wuɔ u jarma taa-yuɔ kelkel. ");
INSERT INTO cmeNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Kufaŋguŋ ciɛ, Yesu yerre migãaŋ ta di du di kã. Nuɔmba bɔi taa ba jãnu ba-naa ba nu u nelma‑i. Jaamba taa ba cãrã-yuɔ u tuɔ sire-bɛi ba jarma-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ŋga huɔŋgu naŋ-nu duɔ ce, u yaŋ-ba aa ta kã u deŋ ka cãrã Diiloŋo‑i aa bir jo. ");
INSERT INTO cmeNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Yiiŋgu naŋgu-na, Yesu taa u waŋ Diiloŋ-nelma‑i u pigãaŋ nuɔmba‑i. A ne da *Farisĩɛbaa-ba namba waa tĩɛna ba hɔlma-na, baa *ãnjĩnamma pigãataamba namba. Banamba taa ba hel *Galile, banamba *Yude, halle banamba naa hel *Yerusalɛmu‑i-na jo. Itieŋo fɔ̃ŋgũɔ waa baa-yo u tuɔ sire jaamba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Balamba namba tũu murgu naŋo‑i kuugallaŋ-nu jo baa-yo, wuɔ ba ji suur jĩna-yuɔ Yesu caaŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","A ne da nuɔmba naa yu dũŋgu‑i, ba saa suɔ baŋ ka suur baa-yo dumaa. Ba naa ba nyugũŋ dũŋgu dɔrɔ‑i-na, aa kaasĩŋ-ku dii-yo baa u kuugallaŋgu‑i nuɔmba hɔlma-na jĩna-yuɔ Yesu caaŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesu wuɔ ne da ba haa ba naŋga‑i yuɔ cor, wuɔ gbɛ̃ ba jɛiŋo‑i wuɔ: «Mi jĩɛ, ŋ ãmbabalma hurii hiere.» ");
INSERT INTO cmeNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ãnjĩnamma pigãataamba‑i baa Farisĩɛbaa-ba doŋ ta ba piiye wuɔ: «Hai moloŋo‑i daayo‑i aa u tuɔ tuora Diiloŋo‑i? Da ma hel Diiloŋo-na, hai moloŋo‑i gbãa hur u nanolŋo ãmbabalma‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesu wuɔ suɔ baa-ba, wuɔ gbɛ̃-ba wuɔ: «Bige‑i ciɛ na ta na jɔguɔŋ nel daama temma‑i na hɔmmu-na? ");
INSERT INTO cmeNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","A hur u ãmbabalma‑i, baa a ce u sire a tuɔ wuɔ‑i, ma hãi‑i-na, namaa daa hama‑i ce fɛ̃u yaŋ? ");
INSERT INTO cmeNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ŋga mi ka sire naacolŋ daayo‑i ku yaa na ka suɔ wuɔ Diiloŋo hãa *Moloŋ-Biɛŋo‑i ku fɔ̃ŋgũɔ‑i hĩɛma-na u tuɔ hur nelbiliemba ãmbabalma‑i.» Uŋ waaŋ mafamma‑i, wuɔ gbɛ̃ murgu‑i wuɔ: «Sire ŋ biɛ ŋ kuugallaŋgu‑i ŋ kũŋ, muɔmɛi waaŋ-ma dumaa.» ");
INSERT INTO cmeNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Naacolŋo bi sire ba yufelle-na a biɛ u kuugallaŋgu‑i tuɔ gbɛliɛŋ Diiloŋo‑i u kũŋ. ");
INSERT INTO cmeNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Maa ce-ba hiere gbɛrɛ; baa ta ba piiye wuɔ: «Diiloŋo‑i bibiɛŋo!» Korma taa ma da-ba a ce ba ta ba piiye wuɔ: «I daa gbɛrɛ-wɛima nyuŋgo‑i-na.» ");
INSERT INTO cmeNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Yesuŋ hilaa terieŋgu-na, wuɔ da *nampohũutieŋo naŋo tĩɛnaana u maacemmaŋ-dũŋgu-na, ba taa ba bĩ-yo Levi. Wuɔ waŋ baa-yo wuɔ: «Levi, sire i ta.» ");
INSERT INTO cmeNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Levi bi pãŋ nanna u maacemma‑i aa sire cu u huoŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ku huoŋgu-na, Levi wuɔ ce kãlle u dumɛlle-na Yesu yerreŋ aa bĩ u jo ba ji ta ba wuo niiwuoni‑i. Nuɔmba bɔi waa baa-ba. Nampohũutaamba waa ba hɔlma-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","*Farisĩɛbaa-ba daa mafamma‑i ce bige‑i baa *ãnjĩnamma pigãataamba‑i? Kuɔ gbuu jaŋ-ba; baa ta ba waana aa naa ta ba piiye baa Yesu *hãalãbiemba‑i wuɔ: «Bige‑i ciɛ na ta na wuo aa ta na nyɔŋ baa nelbabalaaŋ daaba temma‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesu wuɔ gbɛ̃-ba wuɔ: «Da ŋ waa hĩnni, ŋ ka ce bige‑i pɛrruntieŋ terieŋ-nu? ");
INSERT INTO cmeNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Mi saa jo nelfafaaŋ maa-na, ŋga mi juɔ nelbabalaaŋ maa-na ba da ba nanna ba cilɔbabalaŋo‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Baŋ waa mafamma-na, *Farisĩɛbaa-ba namba yuu-yo wuɔ: «*Nsãa-Batisi *hãalãbiemba dii sũŋgu‑i aa ta ba cãrã Diiloŋo‑i, miɛ baamba bi dii aa ta ba cãrã, bige‑i ciɛ naŋ baamba sa dii?» ");
INSERT INTO cmeNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesu wuɔ siɛ-ba baa gbãnalãaŋgu wuɔ: «Nɛliɛ gbãa tuɔ jã ciɛŋo aa na ce u jɛ̃naamba dii sũŋgu ku yiiŋgu-na dɔrbiɛŋo yufelle-na wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ŋga yiiŋgu dii baa yiiŋgu, ba ka bel dɔrbiɛŋo‑i ta baa-yo. Kufaŋgu yinni'i nuɔ‑i baŋ ka dii sũŋgu‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Aa naa tiraa naŋ gbãnalãaŋgu naŋgu baa-ba wuɔ: «Ba sa taal joŋgorfɛlɛŋo‑i a nar uucɔlɔŋo. Da ŋ ce-ma, joŋgorfɛlɛŋo kompaŋga siɛ biɛ baa uucɔlɔŋo kaaŋga‑i, u yaa daayo u taalaa tĩ. ");
INSERT INTO cmeNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ba sa bi dii duvɛ̃nfɛlɛŋo‑i cirkpɔcɔlɔŋ-na. Umaŋ duɔ ce-ma, cirkpuɔ ka muonu aa duvɛ̃ŋo ka kũnna. ");
INSERT INTO cmeNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ŋga da ŋ'a ŋ dii duvɛ̃nfɛlɛŋo‑i, ŋ saaya ŋ dii-yo cirkpɔfɛlɛŋ-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Na saa da, umaŋ duɔ tuɔ nyɔŋ duvɛ̃ncɔlɔŋo‑i uufɛlɛŋo sa dɔlnu-yuɔ a ce dumaaŋo-na u sa taara-yuɔ.» ");
INSERT INTO cmeNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","*Yitĩɛnaŋgu naŋgu-na, Yesubaa-ba taa ba karnu sonni nanni ba cor. U *hãalãbiemba ta ba kar bile‑i ba hu-yo ba natiɛŋa-na ba wuo. ");
INSERT INTO cmeNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","*Farisĩɛbaa-ba namba ta ba waŋ baa-ba wuɔ: «Bige‑i ciɛ na ta na ce kumaŋ saa saaya cemma yitĩɛnaŋgu-na?» ");
INSERT INTO cmeNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesu wuɔ gbɛ̃-ba wuɔ: «Nyulmu naŋ bilaa *Davidi‑i wuɔ ce kumaŋ baa u nuɔmba‑i, ma sĩ na kalaaŋ-ku kɛ? ");
INSERT INTO cmeNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","U naŋ suurii Diiloŋ-dũŋgu-na dumaa a biɛ Diiloŋ-buruo‑i ba wuo. A ne da a saa baa miɛ Diiloŋ-hũmelle‑i, bamaŋ si dii *Diilojigãntaamba, ba saa saaya ba wuo buruo faŋo‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Uŋ waaŋ mafamma‑i, wuɔ cira: «*Moloŋ-Biɛŋo yaa yitĩɛnaŋgu tieŋo‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","*Yitĩɛnaŋgu bi naŋgu-na, Yesu wuɔ suurii *Diilonelhãalãdũŋgu-na tuɔ waŋ Diiloŋ-nelma‑i. A ne da naacolŋo naŋo waa ba hɔlma-na, u nadienaŋga naa minaŋ. ");
INSERT INTO cmeNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","*Ãnjĩnamma pigãataamba‑i baa *Farisĩɛbaa-ba kã ka tĩɛna ta ba ne Yesu‑i wuɔ duɔ sire jɛiŋo yitĩɛnaŋgu-na ba da ãntãalãmma haa-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Yesu wuɔ suɔ baa-ba. Wuɔ gbɛ̃ naacolŋo‑i wuɔ: «Sire ŋ jo ŋ ji yiɛra nuɔmba yaaŋga-na.» Naacolŋ wuɔ sire jo ji yiɛra. ");
INSERT INTO cmeNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yesu wuɔ cira: «Yaaŋ mi yuu-na nelma diei: A saa baa miɛ Diiloŋ-hũmelle‑i, bige‑i faa cemma yitĩɛnaŋgu-na? Ãnfafamma'i faa cemma waa ãmbabalma? Da ŋ da molo yii duɔ ku, ku saaya ŋ kor-o waa ku saaya ŋ yaŋ u ku?» ");
INSERT INTO cmeNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Aa naa wuɔra ne ba yammu‑i hiere aa waŋ baa naacolŋo‑i wuɔ: «Fara ŋ naŋga‑i.» Naacolŋ wuɔ bi fara u naŋga‑i, kaa bir ka temma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ba hɔmmu gbuu pãŋ du hiere; baa ta ba yuu ba-naa wuɔ: «I ka ce Yesu daayo‑i niɛ?» ");
INSERT INTO cmeNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Yibieŋa faŋga-na, Yesu wuɔ kã tãnuŋgu naŋgu-na ka cãrã Diiloŋo‑i cɔ u yufieŋ-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Cuoŋ juɔ kaal, wuɔ bĩ u *hãalãbiemba‑i a fiɛl cĩncieluo ba hãi bɛi, a tuɔ bĩ-ba *pɔpuɔrbiemba. ");
INSERT INTO cmeNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Uŋ fiɛlaa bamaŋ ba yirɛiŋa yaa daaya: Simɔ, (Yesu wuɔ bĩ Simɔ faŋo yaa Piɛr‑i,) baa u hãaŋo‑i Ãndere, baa Sake, baa Nsãa, baa Filipu, baa Batelemi, ");
INSERT INTO cmeNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","a naara Matie, baa Toma, baa Alfe biɛŋo‑i Sake, baa Simɔ maŋ taa u kuye u nelle maama‑i, ");
INSERT INTO cmeNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","a naara Sake biɛŋo‑i *Yuda, baa *Yuda‑Isikaro maŋ juɔ hel Yesu huoŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesuŋ juɔ fiɛl u *pɔpuɔrbiemba‑i tĩ, wuɔ hiire baa-ba tãnuŋgu-na ka yiɛra baa-ba kpaŋkpataaŋgu naŋgu-na. U *hãalãbiemba namba waa terieŋgu faŋgu-na, baa sa waa dɛi baa yuliiŋgu‑i a naara nelpũŋgu naŋgu. Banamba taa ba hel *Yude, banamba *Yerusalɛmu, banamba Tiir, banamba Sidɔ̃ dii dãmmaŋ-nuoraaŋgu caaŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Baa juɔ da ba ji nu Yesu nelma yaa‑i aa u duɔ sire jaamba‑i ba jarma-na. Wuɔ bi donya *jĩnabaa-ba‑i u hiel-ba nuɔmba yunni-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Fɔ̃ŋgũɔ naŋo taa u hel Yesu‑i-na u sire-bɛi ba jarma-na, a ce dumaaŋo-na, baa ta ba taara ba yiɛya-yuɔ hiere. ");
INSERT INTO cmeNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Nuɔmbaŋ nii Yesu‑i-na da ba yiɛya-yuɔ, wuɔ wuɔra ne u *hãalãbiemba‑i aa naa cira: «Sũntaaŋ namaaŋo‑i, na yunni dɔlaa; *Diiloŋ-nelle‑i namaa diele‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Nyulmuŋ yeŋ namaa namaŋ nuɔ‑i fiɛfiɛ‑i-na, na yunni dɔlaa; niiwuoni kaa haaya baa-na. Namaa namaŋ kaalaaŋ fiɛfiɛ‑i-na, na yunni dɔlaa; na kaa waa nyɛmbĩnniŋ. ");
INSERT INTO cmeNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Nuɔŋ da ba bigãaŋ-na, da ba nanna-nɛi, da ba ta ba tuora-nɛi, sisɔ da ba ta ba bĩɛna na yirɛiŋa‑i *Moloŋ-Biɛŋo maama-na, na yunni dɔlaa. ");
INSERT INTO cmeNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Taa na gbu na nyɛ yiiŋgu faŋgu-na, aa na ta na muora na gbugbanni‑i; Diiloŋo kaa pã-na bɔi dɔrɔ‑i-na. Na saa da, ba bĩncuɔmba ciɛ karaaŋgu faŋgu temma yaa‑i baa *Diilopɔpuɔrbiemba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ŋga waaŋ namaaŋo‑i, sũlma haraa-nɛi; na ciɛ na bãaŋgu‑i tĩ. ");
INSERT INTO cmeNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Niiwuoniŋ haaya baa namaa namaŋ fiɛfiɛ‑i-na, sũlma haraa-nɛi; na kaa waa nyulmu-na. Namaa namaŋ dii nyɛmbĩnni-na fiɛfiɛ‑i-na, sũlma haraa-nɛi; na kaa waa kuliiŋ-kaaluŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Nuɔmba‑i hiere da ba ta ba bĩ na yefafalle, ŋaa ba bĩncuɔmba naŋ bĩŋ coikartaamba maŋ naa ciɛ ba fɛrɛ Diilopɔpuɔrbiemba ba yefafalle‑i dumaa, sũlma haraa-nɛi.» ");
INSERT INTO cmeNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","«Namaa namaŋ karaa na tũnni‑i ta na nu mi nelma‑i, yaaŋ mi tũnu-nɛi: Taa na dɔl na bigãarãamba‑i, taa na ce ãnfafamma bamaŋ diyaaŋ luŋgu nɛi. ");
INSERT INTO cmeNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Umaŋ duɔ haa u nubabalaaŋgu nuɔni maŋ nuɔ‑i, baa waasa kutieŋo-na, yaŋ aa ŋ ta ŋ jɔguɔŋ kuufafaaŋgu baa-yo. Taa na cãrã Diiloŋo‑i na hã bamaŋ ciɛŋ-naŋ kuujaŋgu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Umaŋ duɔ caa ŋ tũŋ daaku‑i, bir daaku‑i ŋ hã-yo. Umaŋ duɔ biɛ ŋ joŋgorbuɔ‑i, baa cie-yo ŋ joŋgoryelle-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Umaŋ duɔ cãrã ŋ wulaa, hã-yo. Aa umaŋ duɔ biɛ bĩŋkũŋgu ŋ wulaa, baa yuu-yo ku maama. ");
INSERT INTO cmeNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Naŋ taaraŋ nuɔmba ta ba ce kumaŋ ba hã-na, taa na ce ku temma na bi hã-ba. ");
INSERT INTO cmeNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Da na ta na dɔl na dɔdɔltaamba yoŋ, na jaaluŋgu sĩ Diiloŋo wulaa. Na saa da, halle bamaŋ sa wuɔyaaŋ Diiloŋ-hũmelle‑i ba dɔl ba dɔdɔltaamba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Da na ta na bi ce ãnfafamma‑i bamaŋ ciɛŋ ãnfafamma‑i nɛi yoŋ, na jaaluŋgu sĩ Diiloŋo wulaa. Halle bamaŋ sa wuɔyaaŋ Diiloŋ-hũmelle‑i ba ce kufaŋgu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Aa da na ta na dii cɛ̃miɛŋa‑i naŋ suyaa wuɔ bamaŋ ka gbãa suu-ya, na jaaluŋgu sĩ Diiloŋo wulaa. Halle bamaŋ sa wuɔyaaŋ Diiloŋ-hũmelle‑i, da ba suɔ wuɔ umaŋ ka gbãa suu cɛ̃mɛlle‑i ba dii-de u'i nuɔ‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ŋga, taa na dɔl na bigãarãamba‑i, taa na ce ãnfafamma bɛi, taa na hã aa na baa ta na cie ku sɔlaaŋgu huoŋgu-na. Ku yaa Diiloŋo ka pã-na bɔi. Aa na ka waa Dɔrwuoŋo bɛŋ namaa. U yaa faa. U faa baa nuɔmba‑i hiere ka hel baa bamaŋ sa suyaaŋ ãnfafamma‑i baa nelbabalaamba‑i hiere. ");
INSERT INTO cmeNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Na saaya na waa hujantaaŋ namaa, ŋaa na Toŋ yeŋ hujantieŋo dumaa.» ");
INSERT INTO cmeNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«Baa na ta na cãl na-naa, ku yaa Diiloŋo siɛ ka cãl-na. Baa na ta na haa cãlmuɔ-cãŋkuɔle na-naa nuɔ, ku yaa Diiloŋo siɛ ka haa cãlmuɔ-cãŋkuɔle nɛi. Umaŋ duɔ cãl nuɔni maŋ, ce jande aa ŋ yaŋ-yo, ku yaa nuɔ da ŋ bi cãl Diiloŋo‑i u ka ce jande aa yaŋ-ni. ");
INSERT INTO cmeNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Niŋ fiŋ baa kekerieŋgu maŋ ŋ hã nuɔmba‑i, ba ka fi baa ku yaa hã-ni, terieŋgu faŋgu-na, yaŋ ŋ naŋga ta ka fara, ku yaa ba ka fi naŋ kũŋgu‑i aa fɛ̃l-ku ku yu kũnna hã-ni.» ");
INSERT INTO cmeNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesu wuɔ naŋ gbãnalãaŋgu baa-ba wuɔ: «Namaa daa yiro gbãa bel u nayiroŋ nagãŋ-na ba kã terieŋgu aa ba siɛ ka par suur fuoŋ-nu wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","*Hãalãbiloŋo sa suɔ u yaŋ u hãalãtieŋo‑i, ŋga hãalãbiloŋo maŋ duɔ hãalã ka hi u fuoŋgu‑i, u ka tuɔ suɔ ŋaa u hãalãtieŋ uŋ suɔ dumaa. ");
INSERT INTO cmeNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","«Naŋ ciɛ niɛ da hũyãŋo‑i unaŋ yufelleŋ aa daabolma‑i naŋ yufelle-na ŋ saa da-ma? ");
INSERT INTO cmeNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Daabolma‑i naŋ fɛrɛŋ yufelle-na jũnnu dumandɛ‑i ŋ bir ŋ gbɛ̃ ŋ nabentieŋo‑i wuɔ: ‹Yaŋ mi hiel hũyãŋo‑i ŋ yufelle-na hã-ni.› Ãŋgbãŋgbãama! Hiel daabolma‑i ŋ yufelle-na igɛ̃na, ku yaa ŋ ka ta ŋ da dɛi a gbãa hiel hũyãŋo maŋ ŋ nabentieŋo yufelle-na.» ");
INSERT INTO cmeNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«Tibifafaaŋgu sa maŋ biebabalɛiŋa, tibibabalaaŋgu sa bi maŋ biefɛfɛiŋa. ");
INSERT INTO cmeNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ba suɔ tibinni‑i ni bieŋa'i nuɔ‑i. Ba sa yagal musĩɛŋa kaapugammu-na, aa ba sa bi biɛra hãlɛ̃iŋa caaterreŋ-yuŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Nɛliɛŋ nuɔ ŋ huɔŋgaŋ yuu baa mamaŋ, ma yaa hilaaŋ ŋ nuŋgu-na. Nelfɛfɛiŋo‑i u ãnfafamma hel u hɔfafaŋga'i nuɔ‑i aa nelbabalaŋo‑i u maacembabalamma hel u hɔbabalaŋga'i nuɔ‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«Bige‑i ciɛ na ta na bĩ-mi ‹Itie, Itie›, aa da mi waŋ mamaŋ baa-na, na siɛ ce-ma? ");
INSERT INTO cmeNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Umaŋ duɔ jo ji nu mi nelma‑i aa ce-ma, mi ka pigãaŋ-na kutieŋ uŋ saa baa umaŋ: ");
INSERT INTO cmeNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","U saa baa nɛliɛŋo maŋ wuɔ u ma dũŋgu, aa hĩŋ ka hi tãmpɛ̃lle‑i jĩna ku tuole‑i. Ku tuoleŋ jĩɛna fafamma aa u ma-ku, diiloŋoŋ juɔ tã, kanni gbar, hũmma bũŋ ka naŋ-ku, ma saa gbãa naara-kuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ŋga umaŋ juɔŋ u nu mi nelma‑i aa u sa ce-ma, u saa baa umaŋ wuɔ u ma dũŋgu aa u saa hĩŋ jĩna ku tuole‑i aa ma-ku. Diiloŋoŋ juɔ tã, hũmma bũŋ ka naŋ-ku, ku pãŋ cii hiere, bĩŋkũŋgu saa tĩɛ.» ");
INSERT INTO cmeNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesuŋ juɔ piiye u nelma‑i tĩ baa nuɔmba‑i, wuɔ ta kã Kafarnamu. ");
INSERT INTO cmeNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","*Oromɛ ba sorosi ba yuntieŋo naŋo waa nelle fande-na, u maacembiloŋo naŋo maama waa kpelle yuɔ. Maacembiloŋ daayo tuɔ jaŋ. U jarma waa kpelle. ");
INSERT INTO cmeNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Yesuŋ juɔ, sorosi ba yuntieŋ daayo nu-ma. Wuɔ puɔr *Yuifu ba bĩncuɔmba namba‑i u wulaa, wuɔ ba ka cãrã-yuɔ u ji sire u maacembiloŋo‑i hã-yo. ");
INSERT INTO cmeNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Bĩncuɔŋ daaba kã ka ta ba cãrã Yesu‑i aa ta ba piiye wuɔ: «Naacolŋ daayo saaya kãyãmma. ");
INSERT INTO cmeNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Yuifubaa miɛ i maama dɔlnu-yuɔ; ŋ saa da, u'i maa i *Diilonelhãalãdũŋgu‑i hã-ye.» ");
INSERT INTO cmeNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yesu wuɔ ta tuɔ kã baa-ba sorosi ba yuntieŋo cĩiŋgu-na. Baŋ kaa piɛ cĩiŋgu‑i, ba suu baa sorosi ba yuntieŋo tiraa puɔr u jɛ̃naamba namba Yesu wulaa. Baa waŋ baa Yesu‑i wuɔ: «Itie, i jĩɛŋ wuɔ i ji waŋ baa-ni, wuɔ ŋ baa mulĩɛŋ ŋ fɛrɛ; kɛrɛ nuɔ ŋ saa saaya ŋ suur fuɔ temma dumɛlle-na ");
INSERT INTO cmeNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ku'i ciɛ ŋ da u saa siɛ jo u fɛrɛ ŋ wulaa. Ŋga da ŋ siɛ, ŋ waŋ nelma diei, u maacembiloŋo ka sire. ");
INSERT INTO cmeNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Wuɔ fuɔ fɛrɛ‑i nuɔmba dii u yuŋ-nu, aa fuɔ bi waa banaŋ yuŋ-nu. Duɔ gbɛ̃ umaŋ wuɔ: ‹Kã ŋ ka ce daaku!› Ŋ da kutieŋo kãa. Duɔ bi gbɛ̃ umaŋ wuɔ: ‹Jo bande!› Ŋ da kutieŋo bi juɔ. Duɔ bi tiraa gbɛ̃ u maacembiloŋo‑i wuɔ: ‹Ce daama!› Ŋ da u ciɛ-ma.» ");
INSERT INTO cmeNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesu wuɔ kar da hãmmu! Naacolŋ uŋ juɔ piiye tĩ, Yesu wuɔ bir u yaaŋga‑i nuɔmba-na aa naa cira: «Yaaŋ mi tũnu-nɛi; *Isirahɛl-na hiere, mi saa da umaŋ haa u naŋga‑i miɛ naacolŋ daayo temma‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Sorosi ba yuntieŋo pɔpuɔrbieŋ baa bir ta ba kũŋ. Baŋ kaa hi cĩiŋgu‑i, baa da maacembiloŋ daayo siire da yeryer u temma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ku huoŋgu-na, Yesu wuɔ ta tuɔ kã nelle nande-na, ba bĩ-de Nayine. U *hãalãbiemba waa baa-yo a naara nelpũŋgu naŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Baŋ kaa ta ba suur nelle-na, baa suu baa ba tũyãa bikuloŋo naŋo ta ba kã da ba ka fuure. U waa naacombiloŋo, aa u yaa waa u diei u nyu wulaa, a ne da u to naa ku aa yaŋ-ba. Nuɔmba bɔi taa ba kã u fuuremma-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Yesuŋ daa nyuŋo‑i, u hujarre gbuu ko-yo, wuɔ waŋ baa-yo wuɔ: «Ciɛŋ nuɔ, budii; baa kaal.» ");
INSERT INTO cmeNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Aa naa piɛ ka haa u naŋga‑i kuloŋo-na. Bamaŋ naa tũyãa-yo baa yiɛra. Wuɔ waŋ baa-yo wuɔ: «Naacombilo, sire!» ");
INSERT INTO cmeNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Wuɔ bi yiiye sire tĩɛna, aa doŋ tuɔ piiye. Yesu wuɔ gbɛ̃ nyuŋo‑i wuɔ: «Biɛ ŋ biɛŋo yaa‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Korma pãŋ bel-ba hiere terieŋgu faŋgu-na. Baa ta ba gbɛliɛŋ Diiloŋo‑i aa ta ba piiye wuɔ: «*Diilopɔpuɔrbilobuɔ hilaa-yiɛ. Diiloŋo juɔ ji kãyã u nuɔmba‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Nelma famma gbuo *Yude‑i hiere baa nilɛiŋa maŋ u kɔtɔnni-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yesuŋ ciɛ mamaŋ hiere, Nsãa *hãalãbiemba kã ka tũnu-yuɔ baa-ma. ");
INSERT INTO cmeNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Wuɔ bir puɔr ba hãi Yesu wulaa wuɔ ba ka yuu-yo kɛrɛ *Koŋkortieŋo maŋ saaya u jo, u yaa ufaŋo‑i wɛi sisɔ uu dii huoŋ-nu? ");
INSERT INTO cmeNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Baa kã ka da Yesu‑i, baa cira: «*Nsãa-Batisi puɔraa-ye ŋ wulaa, wuɔ i ji yuu-ni kɛrɛ Koŋkortieŋo maŋ saaya u jo, u yaa nuɔŋo‑i wɛi sisɔ uu dii huoŋ-nu?» ");
INSERT INTO cmeNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","A ne da huɔŋgu faŋgu-na, Yesu waa tuɔ sire jaamba bɔi ba jarma-na aa tuɔ donya *jĩnabaa-ba‑i nuɔmba yunni-na aa bi tuɔ puur yiriemba yufieŋa‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Wuɔ waŋ baa-ba wuɔ: «Kãaŋ na ka tũnu Nsãa‑i baa naŋ daa kumaŋ, baa naŋ nuɔ mamaŋ: Yiriemba yufieŋa puurii, murgubaa-ba siire ta ba wuɔ, *wontuɔrmba jarma taa bɛi, tugbentaamba tũnni puurii, bikuomba siire aa sũntaamba nuɔ *Neldɔdɔlma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Umaŋ gbeini‑i da ni saa ji guɔl mi huoŋgu-na kutieŋo yuŋgu dɔlaa.» ");
INSERT INTO cmeNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Nsãa pɔpuɔrbieŋ baŋ taa, Yesu wuɔ tuɔ taara u pigãaŋ nuɔmba‑i baa Nsãa sĩnni‑i, wuɔ yuu-ba wuɔ: «Na kãa ka ne bige‑i *hĩɛkuraaŋgu-na? Fafalmuŋ sagallaŋ hĩɛŋgu‑i dumaa na kãa ka ne ku yaa wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Namaa kãa ka ne bige‑i? Na kãa ka ne umaŋ diyaa bĩmbĩfafanni wɛi? Ma sĩ bamaŋ diyaaŋ bĩmbĩfafanni‑i aa ta ba ce ba bãaŋgu‑i baa dii jãmatigi ba dũnniŋ kɛ? ");
INSERT INTO cmeNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ŋga namaa kãa ka ne bige‑i? Ma sĩ na kãa ka ne *Diilopɔpuɔrbiloŋo'i kɛ? Aa naacolŋo faŋo‑i, mi tũnu-nɛi, u maaraa Diilopɔpuɔrbiemba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Mamaŋ nyɛgãaŋ Diiloŋ-nelma-na wuɔ: ‹Mi ka puɔr mi pɔpuɔrbiloŋo wuɔya ta ŋ yaaŋ-na ka cãa ŋ hũmelle‑i›, ba gbɛ̃ Nsãa yaa‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yaaŋ mi tũnu-nɛi, Nsãa temma saa hi hoŋ caaŋ-biemba-na yogo, a ne da umaŋ si dii baa yuŋgu *Diiloŋ-nelle-na u maaraa Nsãa‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Nuɔmba‑i hiere ka hel baa *nampohũutaamba‑i ba nuɔ Nsãa nelma‑i aa suɔ wuɔ Diiloŋo maacemma vii, ba ce Nsãa *batiseŋ-ba. ");
INSERT INTO cmeNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ŋga *Farisĩɛbaa-ba‑i baa *ãnjĩnamma pigãataamba yagaraa wuɔ Nsãa baa batiseŋ-ba. A ce dumaaŋo-na, Diiloŋ uŋ taa u taara u ce kumaŋ hã-ba, ba cĩinaana-kuɔ.» ");
INSERT INTO cmeNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesu wuɔ tiraa cira: «Mi gbãa saa fiɛfiɛ ku nuɔmba‑i baa haba‑i? ");
INSERT INTO cmeNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Mi gbãa saa-ba baa bisãlmba maŋ tĩɛnaana ponsanatigerreŋ. Banamba ta ba waŋ baa banamba‑i wuɔ: ‹I hulii tulammu hã-na, na saa nyɛŋ, i hãl kuliiŋ-nɛini hã-na, na saa kaal.› ");
INSERT INTO cmeNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","*Nsãa-Batisiŋ juɔ aa u sa dii dĩbelle u nuŋgu-na, u sa nyɔŋ kolma, na cira wuɔ *jĩna dii u yuŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","*Moloŋ-Biɛŋ uŋ wuo aa tuɔ nyɔŋ, na tiraa sire ta na piiye wuɔ: ‹Naacolŋ daa fuɔ bi yii baa niiwuoni yaa yoŋ baa konyɔlle, aa tiraa sire bel jĩɛru baa nampohũutaamba baa nelbabalaamba.› ");
INSERT INTO cmeNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ŋga bamaŋ siyaa Diiloŋo nelma‑i ba suyaa wuɔ ma faa.» ");
INSERT INTO cmeNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","*Farisĩɛyiɛŋo naŋo waa, ba taa ba bĩ-yo Simɔ. Yiiŋgu naŋgu-na, wuɔ ji bĩ Yesu‑i wuɔ ba ka wuo niiwuoni u terieŋgu-na. Yesu wuɔ kã ba ka ta ba wuo. ");
INSERT INTO cmeNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","A ne da saasorciɛŋo naŋo waa nelle fande-na. Wuɔ nu-ma wuɔ Yesu dii Simɔ terieŋgu-na ba ta ba wuo niiwuoni. Wuɔ kã baa natikolo-hũmma *alabati-kamoeleŋ ");
INSERT INTO cmeNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ka yiɛra saanu baa Yesu gbeini‑i tuɔ kaal. Uŋ kaal dumaaŋo-na, nyinyɔlma ta ma kũnna Yesu gbeini-na. Wuɔ ce u yukuɔsĩnni‑i a hurre-niɛ aa pũrã-niɛ nammu hãi aa ce natikolo-hũŋ daama‑i a kũnna-niɛ. ");
INSERT INTO cmeNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Simɔ daa mafamma‑i ce bige‑i, u pãŋ tuɔ piiye u huɔŋ-na wuɔ: «Kuɔ naacolŋ daayo waa *Diilopɔpuɔrbiloŋo ninsoŋo, ciɛŋo maŋ yiɛyaayaŋ-yuɔ daayo‑i uu naa suɔ wuɔ cɛfɛfɛiŋo sĩ.» ");
INSERT INTO cmeNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesu wuɔ cira: «Simɔ, nelma dii mi da mi waŋ-ma baa-ni.» Simɔ wuɔ: «Hãalãtie, waŋ-ma.» ");
INSERT INTO cmeNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesu wuɔ cira: «Naacolŋo naŋo cɛ̃mɛlle waa nuɔmba hãi nuɔ; dĩɛlã-wuoŋo‑i neifieŋ-komuɔŋa hãi baa cĩncieluo, hãalĩŋ-wuoŋo‑i neifieŋa ndii. ");
INSERT INTO cmeNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ba saa gbãa da ba pã-ya, u ce hujarre bɛi aa ce ba yaŋ-ya. Ba hãi‑i-na, cɛ̃mɛllentieŋo maama ka dɔlnu hai yaŋ?» ");
INSERT INTO cmeNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simɔ wuɔ cira: «Mɛi huɔŋ-na, umaŋ gbeiŋa‑i waa bɔi u maama ka dɔlnu u yaa yaŋ.» Yesu wuɔ cira: «Ŋ waaŋ ninsoŋo.» ");
INSERT INTO cmeNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Aa naa bir u yaaŋga‑i ciɛŋo-na, aa gbɛ̃ Simɔ‑i wuɔ: «Ŋ daa ciɛŋ daayo‑i kɛ? Miŋ diyaa mi gboluoŋgu‑i ŋ dumɛlle-na, ŋ saa hã-mi hũmma mi saara mi gbeini‑i. Ŋga fuɔ kaalaa kũnna u nyinyɔlma‑i mi gbeini-na a saara-niɛ hã-mi, aa hurre-niɛ baa u yukuɔsĩnni‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ŋ saa jãrã-miɛ pũrã-miɛ, ŋga fuɔ‑i, dii uŋ suurii ŋ dumɛlle-na ji hi baa fiɛfiɛ, u saa yaŋ mi gbeini pũrãmma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ŋ saa hure namma mi yuŋgu-na, ŋga ciɛŋ daayo kũɔna natikolo-hũmma mi gbeini-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ku'i ciɛ mi ta mi tũ-niŋ miɛ: Mi maamaŋ dɔlaanu-yuɔ dɔlnumma maŋ daama‑i, ku pigãaŋ wuɔ u ãmbabalma‑i baa ma ciinumma‑i hiere, ma hurii. Ŋga umaŋ ãmbabalma‑i da ma saa hur bɔi, mi maama sa dɔlnu kutieŋo‑i bɔi.» ");
INSERT INTO cmeNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Aa naa waŋ baa ciɛŋo‑i wuɔ: «Ŋ ãmbabalma hurii.» ");
INSERT INTO cmeNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Bamaŋ waa juwuoterieŋgu-na baa doŋ ta ba jɔguɔŋ wuɔ: «Naacolŋ daa fuɔ hilaa hie aa tuɔ gbã u hur ãmbabalma‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yesu wuɔ waŋ baa ciɛŋo‑i wuɔ: «Niŋ haa ŋ naŋga‑i miɛ ŋ kuraa, kã fiɛi.» ");
INSERT INTO cmeNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ku huoŋgu-na, Yesu wuɔ ji sire tuɔ wuɔra nilɛiŋa-na hiere u waŋ *Diiloŋ-bãaŋgu *Neldɔdɔlma‑i u kã. U *hãalãbieŋ cĩncieluo ba hãi baamba waa baa-yo ");
INSERT INTO cmeNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","a naara caamba namba. Wuɔ duɔnya *jĩnabaa halaŋ-ba caamba famba yunni-na, aa naa bi sire banamba jarma namma-na. Ba taa ba bĩ unaŋo‑i Maari. Fuɔ taa u hel Magidala. Jĩnabaa niehãi naa hilaa fuɔ‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Aa bĩ unaŋo‑i Sani. Fuɔ bɔlɔ waa *Erɔdi dumɛlle maacembiemba yuntieŋo naŋo, ba taa ba bĩ-yo Kusa. Aa ta ba bĩ unaŋo‑i Susani a naara capũŋgu naŋgu. Ba taa ba ce ba nagãŋ-niini‑i ba kãyã Yesu‑i baa u hãalãbiemba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Nuɔmba taa ba hel nilɛiŋa-na hiere ba jo ba nu Yesu nelma‑i. Yiiŋgu naŋgu-na, wuɔ naŋ gbãnalãaŋ daaku‑i baa-ba wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Naacolŋo naŋo kãa ka naŋ fũma u suoŋgu-na. Unaŋo kã ka diire hũmelleŋ-huɔŋ-na. Nuɔmba ta ba cor ba fĩɛna-yuɔ; huriimba jo ji wuo-yo hiere. ");
INSERT INTO cmeNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Unaŋo kã ka diire tãmpɛ̃lleŋ-terieŋ-nu a pa, kpekpelma ce u ku. ");
INSERT INTO cmeNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Unaŋo kã ka diire hĩɛŋ-nu; hĩɛŋgu tu suuye-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Umaŋ diiriiye suoŋ-huɔŋga-na, munterfafammu-na, u sire gbuu kpatalla.» Yesuŋ waaŋ mafamma‑i, u piiye da gbagaga wuɔ: «Umaŋ duɔ u ka nu, u nu!» ");
INSERT INTO cmeNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","U *hãalãbiemba yuu-yo wuɔ: «Gbãnalãaŋ daaku yuŋgu yaa wuɔ niɛ?» ");
INSERT INTO cmeNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","U cira: «Diiloŋo ciɛ baa namaaŋo‑i. U *nellentesĩnni maama maŋ fuyaa, u pigãaŋ namaaŋo‑i baa-ma. Ŋga ma piiye baa banamba‑i gbãnɛiniŋ; a ce dumaaŋo-na, da ba ne-ma, ba siɛ da ma terieŋgu‑i, aa da ba nu-ma, ba siɛ suɔ ma yuŋgu‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Aa naa cira: «Mi gbãnalãaŋgu yuŋgu yaa daaku: Diiloŋ-nelma yaa fũma‑i, aa nuɔmba hɔmmu yaa u mundiiremmu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Nuɔmba naŋ hɔmmu dii ŋaa hũmelleŋ-huɔŋga, da ba nu Diiloŋ-nelma‑i, ba yaŋ *Sitãni jo ji hiel-ma ba hɔmmu-na, a ce dumaaŋo-na ba siɛ da hũu-ma aa kor. ");
INSERT INTO cmeNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Banaŋ hɔmmu dii ŋaa tãmpɛ̃lleŋ-terieŋgu, da ba nu Diiloŋ-nelma‑i, ma gbuu dɔlnu-bɛi; ba hũu-ma. Ŋga ma siɛ gbãa naŋ kaasĩnni. Da ku ji huol, ba har jĩna. ");
INSERT INTO cmeNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Banaŋ hɔmmu dii ŋaa hĩɛŋ-terieŋgu, da ba nu Diiloŋ-nelma‑i, ba yaŋ ãnjɔguɔma‑i baa gbeiŋ-maama‑i a naara ba kusũŋ-maama jo ji suuye-mɛi. A ce dumaaŋo-na ma siɛ gbãa dii belle ba wulaa. ");
INSERT INTO cmeNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Banaŋ hɔmmu dii ŋaa hĩɛfafamma, da ba nu Diiloŋ-nelma‑i, ba hũu-ma aa bel-ma baa hɔfafaŋga aa nyaar ta ba wuɔ ma hũmelle‑i diŋ saaya di wuɔ dumaa.» ");
INSERT INTO cmeNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Yesu wuɔ tiraa naŋ gbãnalãaŋ daaku‑i baa-ba wuɔ: «Ba sa celieŋ fitĩnuɔ‑i aa ce bĩŋkũŋgu cure-yuɔ. Da ba celieŋ-yo, ba haa-yo dɔrɔ ku yaa ŋ da dũŋ-huɔŋga ciɛ gbaa hiere. ");
INSERT INTO cmeNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ku wɛima si dii mamaŋ siɛ ji hel bomborma-na, aa ku nelma si dii mamaŋ siɛ ji nu. ");
INSERT INTO cmeNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Kuŋ yeŋ baa umaŋ, ba ka hã-yo naara, aa umaŋ kuu sĩ baa-yo, cɛllɛ kũŋgu maŋ uŋ haa u naŋga‑i kuɔ, ba ka hũu-ku aa yaŋ-yo. Terieŋgu faŋgu-na, na saaya na ta na suɔ nelma numma.» ");
INSERT INTO cmeNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yesuŋ waa tuɔ waŋ Diiloŋ-nelma‑i, u nyu‑i baa u hãmba jo da ba ji ne-yo; jo ji da nuɔmba yuu, ba saa gbãa da ba piɛ u caaŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Baa waŋ ba Yesu‑i wuɔ: «Ŋ nyu‑i baa ŋ hãmba juɔ da ba ji ne-ni, baa dii gɔ̃ŋgũɔŋgu-na.» ");
INSERT INTO cmeNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yesu wuɔ cira: «Bamaŋ nuɔŋ Diiloŋ-nelma‑i aa ce-ma, ba yaa mɛi nyubaa-ba‑i, ba yaa mɛi hãmba‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Yiiŋgu naŋgu-na, Yesu wuɔ ji bel nyugũŋ beŋo naŋo-na baa u *hãalãbiemba‑i aa naa cira: «Yaaŋ i karnu dalaŋga‑i i kã bombor damaalɛi‑i.» Baa bi ta ta ba karnu ba kã. ");
INSERT INTO cmeNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ba'a ba kã yaaŋga-na, Yesu wuɔ duɔfũŋ. Ba kaa hi hɔlma namma‑i, fafalmu naŋ temma sire suuye-bɛi. Hũmma doŋ ta ma suur beŋo-na. Baa ta ba yii da ba kunu. ");
INSERT INTO cmeNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Hãalãbiemba ta ba kaasĩŋ wuɔ: «Hãalãtie, sire, i yii diɛ ku!» Yesu wuɔ sire nuola fafalmu‑i baa hũmma‑i niɛ kã ka ciire. ");
INSERT INTO cmeNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Kuɔ cu ba hɔmmu‑i, ba kũɔŋ maa ta ma nyɛŋ. Wuɔ waŋ baa-ba wuɔ: «Namaa na'a na haa na naŋga‑i miɛ hie?» Baa ta ba piiye ba-naa nuɔ wuɔ: «Nɛliɛŋ hayo‑i temma‑i dumandɛ‑i? Fuɔ dii niɛ aa duɔ nuola fafalmu‑i baa hũmma‑i ni kã ka ciire ni temma‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yesubaa-baŋ karaanu ka hi Geresa‑i dii Galile dalaŋga bomborma namma-na, baa huɔl. ");
INSERT INTO cmeNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","*Jĩna ba nolŋo naŋo waa nelle fande-na, u bãaŋgu cuɔ. U waa tuɔ wuɔra u bĩŋ tãmporuoŋgu aa tuɔ kã u cɔ cĩncuɔŋ-na. Yesubaa-baŋ huɔlaa u da-ba, u ta tuɔ jãrã-bɛi. ");
INSERT INTO cmeNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Uŋ juɔ hi, u kaasĩŋ aa dũuna Yesu caaŋgu-na aa piiye da gbagaga wuɔ: «Dɔrwuoŋo Biɛŋ nuɔ, mi ciɛ-ni niɛ? Jande, baa ce hɔdorre baa-mi.» ");
INSERT INTO cmeNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Yesu wuɔ nuolaaya jĩnabaa-ba‑i wuɔ ba hel-yuɔ ku'i ciɛ wuɔ tuɔ piiye dumaaŋo-na. Ku waa da ku sire-yuɔ yiiŋgu maŋ nuɔ‑i, ba bel-o vaa-yo baa jɔlgɔbaa jĩna. Ŋga da ba fiɛ vaa-yo, u kar jɔlgɔbaa-ba‑i aa suur hĩɛŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jĩnabaa daaba naa ciinu cor u yuŋgu-na. Yesu wuɔ yuu-yo wuɔ: «Ba bĩ-ni niɛ?» Wuɔ cira: «Ba bĩ-mi Sãlle.» ");
INSERT INTO cmeNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Jĩnabaa-ba bir yaŋ aa ta ba cãrã Yesu‑i wuɔ u baa donya-bɛi ba kã yaahuol-terieŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","A ne da pɛrsãlle nande waa ta di wuora tãnuŋgu-na. Jĩnabaa-ba cãrã Yesu‑i wuɔ u yaŋ ba ka suur pɛrmba famba yaa nuɔ‑i. Yesu wuɔ hã-ba hũmelle‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Baa hel naacolŋo‑na a kã ka suur pɛrmba-na. Pɛrmba pãŋ ta ba gbar ba hiire, ba kã ba kunu dalaŋga-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Nuɔmba waa ta ba ceŋ-ba. Baŋ juɔ da ba gbaraa ka kunu hiere dumaaŋo-na, baa pisãllã baa gbaruŋgu; banamba kã nelleŋ-huɔŋga-na, banamba kã sonni-na ka waŋ-ma. ");
INSERT INTO cmeNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Nuɔmba hel da ba ji ne. Baŋ juɔ ji hi, baa da naacolŋ daayo diyaa bĩmbĩnni tĩɛna da welewele Yesu caaŋgu-na. Korma pãŋ ta ma da-ba. ");
INSERT INTO cmeNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Bamaŋ waa da baŋ duɔnya jĩnabaa daaba‑i dumaa naacolŋo-na, baa ta ba piiye ba tũnu banamba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Kor maa gbuu ta ma da Geresataamba‑i. Baa cãrã Yesu‑i wuɔ u ce jande aa u ta u halaŋ ba terieŋgu-na. Wuɔ kã ka nyugũŋ beŋo-na duɔ bir. ");
INSERT INTO cmeNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Uŋ duɔnya jĩnabaa-ba‑i naacolŋo maŋ nuɔ‑i, wuɔ cãrã-yuɔ wuɔ u yaŋ u kã baa-yo. Yesu wuɔ cira: ");
INSERT INTO cmeNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«Yaŋ aa ŋ kũŋ ŋ ka tũnu nuɔmba‑i Diiloŋ uŋ ciɛ kumaŋ niɛ.» Naacolŋ wuɔ ta ka tuɔ wuɔra u waŋ Yesuŋ ciɛ kumaŋ yuɔ hiere. ");
INSERT INTO cmeNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesuŋ hilaa Geresa‑i-na jo, nuɔmba kũɔl ba-naa kã ka yu-yuɔ. Ba taa ba niya u jomma‑i hiere. ");
INSERT INTO cmeNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Naacolŋo naŋo waa, ba taa ba bĩ-yo Yarusi. U waa *Diilonelhãalãdũŋgu yuntieŋo. Wuɔ jo ji dũuna Yesu caaŋgu-na a tuɔ cãrã-yuɔ wuɔ u kã u dumɛlle-na ");
INSERT INTO cmeNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","kɛrɛ u biloduɔla yii baa u yuŋgu. Biloŋo bieŋ cĩncieluo baa a hãi waa belle fande-na. Yesu wuɔ ta ba ta ba kã. Nuɔmba fũnuŋ yu-yuɔ ta ba nogol-o terni-na hiere. ");
INSERT INTO cmeNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ciɛŋo naŋo bi waa ba hɔlma-na, u tãmma taa ma kũnna. Ku bieŋ cĩncieluo baa a hãi waa belle fande-na. U ciɛ pɛrru‑i ji gbɛ̃. U gbeiŋa tiraa tĩ aa tãmma saa yiɛra. ");
INSERT INTO cmeNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ciɛŋ daayo piɛ Yesu huoŋ-yaŋga a yiɛya u joŋgoruo tũŋgu‑i. Uŋ yiɛyaaya joŋgoruo‑i terieŋgu maŋ nuɔ‑i, tãmma pãŋ yiɛra. ");
INSERT INTO cmeNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesu wuɔ suɔ wuɔ molo yiɛyaaya-yuɔ. Wuɔ yuu wuɔ: «Hai moloŋo‑i yiɛyaaya-miɛ?» Wulawula wuɔ fuɔ sĩ, wulawula wuɔ fuɔ sĩ. Piɛr wuɔ cira: «Hãalãtie, molo saa yiɛya-niɛ, nuɔmba yaa yuu ta ba tisĩŋ-ni.» ");
INSERT INTO cmeNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Yesu wuɔ cira: «Molo yiɛyaaya-miɛ. Mi daa kunaŋgu paraaya-miɛ ku'i ciɛ mi suɔ.» ");
INSERT INTO cmeNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ciɛŋ daa uŋ daa Yesu suyaa dumaaŋo-na, u kũɔma doŋ ta ma nyɛŋ. Wuɔ piɛ dũuna u yaaŋga-na, aa naa piiye nuɔmba‑i hiere ba yufelle-na kumaŋ ciɛ u yiɛya-yuɔ. Aa fafalmuŋ daa-yuɔ terduɔŋgu faŋgu-na dumaa, wuɔ tiraa waŋ mafamma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesu wuɔ gbɛ̃-yo wuɔ: «Mi bilo, niŋ haa ŋ naŋga‑i miɛ, ŋ kuraa. Kã ŋ kã fiɛi.» ");
INSERT INTO cmeNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesuŋ taa u waŋ mafamma‑i huɔŋgu maŋ nuɔ‑i, moloŋ wuɔ hel Diilonelhãalãdũŋgu yuntieŋo cĩiŋgu-na ji waŋ baa-yo wuɔ: «Baa yaŋ hãalãtieŋo mulĩɛŋ u fɛrɛ, ŋ biloŋo jarma yaraa-yo.» ");
INSERT INTO cmeNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesu wuɔ nu-ma. Wuɔ waŋ baa Yarusi‑i wuɔ: «Baa tie holle. Da ŋ haa ŋ naŋga‑i miɛ, ŋ biloŋo ka sire.» Uŋ waaŋ mafamma‑i, baa cor ta ba kã. ");
INSERT INTO cmeNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Baŋ kaa hi cĩiŋgu‑i, u saa siɛ molo suur baa-yo dũŋgu-na. U ciɛ fuɔ baa Piɛr baa Nsãa baa Sake a naara biloŋo to‑i baa u nyu‑i ba'i suur baa-yo yoŋ. ");
INSERT INTO cmeNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Nuɔmba‑i hiere ba waa kaaluŋ-nu. Yesu wuɔ gbɛ̃-ba wuɔ: «Baa na kaal, u saa ku, u duɔfũŋ.» ");
INSERT INTO cmeNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Baa bir yaŋ aa ta ba cɔ̃muɔŋ-yo. Bafamba wulaa ma tĩɛ. ");
INSERT INTO cmeNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Yesu wuɔ bel biloŋo naŋga‑i, aa naa piiye da gbagaga wuɔ: «Bilo, sire!» ");
INSERT INTO cmeNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Biloŋ wuɔ puur u yufieŋa‑i aa pãŋ yiiye sire. Yesu wuɔ cira ba hã-yo bĩŋkũŋgu u wuo. ");
INSERT INTO cmeNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Kuɔ ce u bĩncuɔmba‑i gbɛrɛ. Yesu wuɔ waŋ baa-ba wuɔ ba baa yaŋ ma hel. ");
INSERT INTO cmeNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ku huoŋgu-na, Yesu wuɔ tigiiŋ u *hãalãbieŋ cĩncieluo ba hãi baamba‑i a hã-ba himma baa fɔ̃ŋgũɔ ba da ba gbãa ta ba donya *jĩnabaa-ba‑i hiere aa ta ba sire jaamba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Uŋ ciɛ mafamma‑i, wuɔ puɔr-ba wuɔ ba wuɔra waŋ *Diiloŋ-bãaŋgu maama‑i aa sire jaamba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Aa naa waŋ baa-ba wuɔ: «Da na'a na ta, molo baa biɛ bũɔle, molo baa biɛ buɔra, molo baa biɛ niiwuoni, molo baa biɛ gbeiŋa, molo baa bi biɛ joŋgorbaa-ba hãi. ");
INSERT INTO cmeNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Da na kã terieŋgu terieŋgu, aa ba ka hã-na dũŋgu wuɔ na ta na cɔ, na tĩɛ dũŋgu faŋgu-na fuɔ na tamma. ");
INSERT INTO cmeNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ŋga da na kã da na ka har bamaŋ nuɔ‑i aa ba yagar, na pir na nallu‑i na ta. Ku yaa ba ka suɔ wuɔ ba maacemma saa fa.» ");
INSERT INTO cmeNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","U hãalãbiemba ta ta ba wuɔra nilɛiŋa-na hiere ba waŋ *Neldɔdɔlma‑i aa ta ba sire jaamba‑i ba kã. ");
INSERT INTO cmeNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Mamaŋ ciɛŋ hiere, *Erɔdi maŋ waa *Galile yuŋgu-na wuɔ nu-ma. Uŋ nuɔ-ma, u huɔŋ kaa cu. Banamba taa ba piiye wuɔ *Nsãa-Batisi yaa siire kuoŋ-nelle-na a jo. ");
INSERT INTO cmeNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Banaŋ ba'a *Eli yaa caraaya-bɛi. Banaŋ ba'a yiinataaŋ *Diilopɔpuɔrbiloŋo naŋo'i siire kuoŋ-nelle-na jo. ");
INSERT INTO cmeNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Erɔdi wuɔ cira: «Mi ciɛ ba kar Nsãa yuŋgu‑i, hai moloŋo‑i daayo fuɔ?» Aa naa tuɔ taara u da Yesu yufelle. ");
INSERT INTO cmeNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Yesu *pɔpuɔrbiembaŋ kaa bir jo, baa jo ji tũnu-yuɔ baa baŋ kaa ce mamaŋ hiere. Yesu wuɔ ce ba hel nelleŋ-huɔŋga-na kã ba deŋ, dii nelle nande caaŋgu-na ba bĩ-de Betisada. ");
INSERT INTO cmeNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Baŋ fiɛ ta, nuɔmba yagar nu-ma, aa sire nyaa u huoŋ-nu. Baŋ kaa hi, Yesu wuɔ hã-ba muntĩɛnammu aa biɛ *Diiloŋ-nellentesĩnni maama‑i waŋ baa-ba aa bi sire jaamba maŋ waa ba hɔlma-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Bãaŋguŋ juɔ doŋ ta ku hir huɔŋgu maŋ nuɔ‑i, u *hãalãbieŋ cĩncieluo ba hãi baamba kã u wulaa ka cira: «Itie, iŋ yeŋ hĩɛŋgu-na dumandɛ‑i aa bãaŋgu ta ku suur, ŋ sa ce nuɔmba bɔrɔ kã nilɛiŋa maŋ kɔtɔnni-na ka taara niiwuoni wuo, baa muncɔmmu wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Yesu wuɔ cira: «Namɛi saaya na hã-ba niiwuoni‑i ba wuo.» Baa cira: «*Buruo u ndii dii baa-ye yoŋ baa titiraamba hãi. Da ŋ bi'a miɛmɛi ka sãa ji hã nelpũŋ daaku‑i hiere ŋ waŋ-ma.» ");
INSERT INTO cmeNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","A ne da bɛmba maŋ waa, ba yuu nuɔmba neifieŋa hãi nuɔsiba ndii temma. Yesu wuɔ cira: «Ciɛŋ ba tĩɛna nuɔmba komuɔŋa hã-a-hãi baa cĩncielbaa.» ");
INSERT INTO cmeNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","U hãalãbiemba ce nuɔmba tĩɛna. ");
INSERT INTO cmeNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yesu wuɔ biɛ buruo u ndii daayo‑i baa titiraamba hãi baaŋ daaba‑i a ciir u yuŋgu‑i dɔrɔ‑i-na aa jaal Diiloŋo‑i. Uŋ jaalaa Diiloŋo‑i, wuɔ bũlnu-niɛ hã u hãalãbiemba calnu-niɛ hã nuɔmba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Nuɔmba wuo hiere niɛ yar-ba. Hãalãbiemba gbura ni boini‑i a dii-ni segeyufieŋ cĩncieluo baa a hãi a ta baa-ni. ");
INSERT INTO cmeNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Yiiŋgu naŋgu-na, Yesu kãa u deŋ ka tuɔ cãrã Diiloŋo‑i. U *hãalãbiemba waa baa-yo. Wuɔ yuu-ba wuɔ: «Nuɔmba waŋ wuɔ niɛ mɛi kũŋgu-na?» ");
INSERT INTO cmeNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Baa cira: «Banamba ciɛra wuɔ nuɔnɛi *Nsãa-Batisi‑i, banaŋ ba'a nuɔnɛi *Eli‑i, banaŋ ba'a yiinataaŋ *Diilopɔpuɔrbiloŋo naŋo'i birii jo nuɔŋo‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Yesu wuɔ yuu-ba wuɔ: «Namaa fuɔ, na'a hai moloŋ muɔmɛi?» Piɛr wuɔ cira: «Diiloŋ uŋ pãa nuŋgu‑i wuɔ u ka saaŋ *Koŋkortieŋo maŋ, u yaa nuɔŋo‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yesu wuɔ waŋ-ma kuola-mɛi baa-ba wuɔ ba baa yaŋ molo nu-ma. ");
INSERT INTO cmeNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Aa naa cira: «*Moloŋ-Biɛŋo saaya u gbuu mulĩɛŋ. Nelle bĩncuɔmba‑i baa *Diilojigãntaamba yuntaamba‑i a naara *ãnjĩnamma pigãataamba ka cĩina-yuɔ aa bel-o ko-yo. Ŋga da ba ko-yo, u ka ce yinni hãi yoŋ hĩɛma-na, siɛliŋ-yiiŋgu-na u ka sire hel jo.» ");
INSERT INTO cmeNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Aa naa waŋ baa-ba wuɔ: «Nuɔni maŋ da ŋ ta ŋ taara ŋ nyaanu-miɛ, ŋ saaya ŋ cĩina ŋ fɛrɛ aa ŋ jo i ta. Aa ŋ saaya ŋ ta ŋ siɛ mulĩɛma‑i baa kuliiŋgu‑i yinni maŋ joŋ. ");
INSERT INTO cmeNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Umaŋ duɔ tuɔ kaal baa u yuŋgu yoŋ, kutieŋo ka kɔsuɔŋ u fɛrɛ; ŋga umaŋ duɔ tuɔ kɔsuɔŋ u fɛrɛ mɛi maama-na, kutieŋo ka da cicɛ̃lma maŋ siɛ ji tĩ dede. ");
INSERT INTO cmeNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Da ŋ da ŋ yufieŋ-niini‑i hiere hĩɛma-na aa ka caa, yuŋ haku‑i dii-kuɔ? ");
INSERT INTO cmeNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Umaŋ duɔ tuɔ ce senserre u sa taara ba suɔ wuɔ u cuu mi huoŋ-nu, aa bi tuɔ ce senserre baa mi nelma wamma‑i, Moloŋ-Biɛŋ duɔ ka bir jo baa u fɔ̃ŋgũɔ‑i, baa u To wuoŋo‑i a naara u To u dɔrpɔpuɔrbiemba wuoŋo‑i, u ka bi ce senserre baa kutieŋo maama‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Yaaŋ mi waŋ ninsoŋo‑i baa-na: Banamba dii na hɔlma-na bande‑i-na, ba ka da *Diiloŋ-bãaŋgu‑i baa ba yufelle aa suɔ ku.» ");
INSERT INTO cmeNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesuŋ waaŋ mafamma‑i, yinni niisiɛi temma cor, wuɔ ce fuɔ baa Piɛr, baa Nsãa a naara Sake ba kã tãnuŋgu naŋgu-na da ba ka cãrã Diiloŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Uŋ kaa tuɔ cãrã Diiloŋo‑i u yaaŋga fũnuŋ bir ka deŋ birma aa u joŋgorbaa-ba bir baapiɛlmba ta ba gbu ba caa da muimui. ");
INSERT INTO cmeNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Wuɔ u ne da nuɔmba hãi juɔ ji ta ba piiye baa-yo: *Moisi baa *Eli. ");
INSERT INTO cmeNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Dɔrcecerma namma'i naa dii-ba huɔŋga ba ta ba piiye baa Yesu‑i uŋ ka ku kuliiŋgu maŋ *Yerusalɛmu‑i-na a perieŋ u maacemma‑i bãl-ma. ");
INSERT INTO cmeNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ŋ siɛ suɔ wuɔ Piɛrbaa-ba naa kor duɔfũŋ bir ba nammu‑i ba honniŋ, ŋga ba yagar sire da cecer daama diyaa Yesu‑i huɔŋga baa muɔŋ daaba‑i ba hãi‑i-na u caaŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Nuɔŋ daabaŋ juɔ ta ba ta, Piɛr wuɔ waŋ baa Yesu‑i wuɔ: «Hãalãtie, i jomma faa bande‑i-na dɛ! Ŋ sa yaŋ i ce gbuganni siɛi wɛi? Ku diei naŋ kũŋgu, ku diei Moisi kũŋgu, aa ku diei kũŋgu naŋgu‑i Eli kũŋgu.» U taa u piiye dumaa u yuŋ-nu, u sa suɔ uŋ waŋ mamaŋ. ");
INSERT INTO cmeNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Uŋ taa u waŋ mafamma‑i huɔŋgu maŋ nuɔ‑i, duherru nandu jo ji cĩnnu-bɛi. Korma ta ma da-ba. ");
INSERT INTO cmeNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ba'a ba ne, da molo piiye duherru-na wuɔ: «Mi Biɛŋo yaa daayo‑i, mi hielaa u yaa‑i. Taa na nu u nuŋgu‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Moloŋ daa uŋ juɔ piiye tĩ, *hãalãbiemba da Yesu yaa u diei yoŋ; ba saa da moloŋo baa-yo. Kuŋ ciɛ dumaaŋo-na, ba fĩinaŋ nel daama-na, ba saa waŋ-ma baa moloŋo huɔŋgu faŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ku cuo kaala‑i-na, Yesu wuɔ hiire tãnuŋgu-na baa u *hãalãbiemba‑i. Nelpũŋgu naŋgu jo u wulaa. ");
INSERT INTO cmeNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Naacolŋo naŋo waa ba hɔlma-na. Wuɔ piiye da gbagaga wuɔ: «Hãalãtie, jande, ne mi biɛŋo‑i, u yaa u diei yoŋ mi wulaa. ");
INSERT INTO cmeNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","*Jĩna dii u yuŋgu-na. Duɔ sire-yuɔ dumandɛ‑i, u tugol kaasĩŋ. Duɔ kaasĩŋ, jĩna mal-o u tuɔ tãrã aa sãmpugaaru ta du hel u nuŋgu-na. Duɔ sire-yuɔ, u mulĩɛŋ-yo da suu aa suɔ ji ciire-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mi cãarã ŋ hãalãbiemba‑i miɛ ba donya-yuɔ, ba saa gbãa.» ");
INSERT INTO cmeNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesu wuɔ cira: «Fiɛfiɛ ku nuɔŋ namaaŋo‑i na sa hũu nɛliɛŋ maama; na saa fa. Na daa niɛ sĩ mi ka tĩɛna baa-na gbula a tiera na nonni‑i wɛi?» Aa naa gbɛ̃ naacolŋo‑i wuɔ: «Jo baa ŋ biɛŋo‑i bande.» ");
INSERT INTO cmeNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Naacombiloŋ uŋ kaa tuɔ piɛ Yesu‑i, jĩna wuɔ sire-yuɔ. Wuɔ cii pãŋ tuɔ tãrã. Yesu wuɔ nuola jĩna‑i wuɔ u cor hel naacombiloŋo-na. U bi siremma yaa dumaaŋo-na u jarma-na. Wuɔ hã u to‑i baa-yo. ");
INSERT INTO cmeNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Nuɔmba maŋ waa hiere kuɔ ce-ba gbɛrɛ. Wulawula wuɔ Diiloŋo hii, wulawula wuɔ Diiloŋo hii. Yesu ãncemmaŋ taa ma ce nuɔmba‑i hiere gbɛrɛ dumaaŋo-na, wuɔ waŋ baa u *hãalãbiemba‑i wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Karaaŋ na tũnni‑i na nu nel daama‑i fafamma: Ba ka bel *Moloŋ-Biɛŋo‑i hã nelbiliemba‑i baa-yo ba ko-yo.» ");
INSERT INTO cmeNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","U hãalãbiemba saa suɔ u nelma yaaŋga‑i; ma yuŋgu naa fuo-bɛi, ba saa gbãa da ba suɔ-ma. Ba siɛ bi siɛ da ba yuu-yo. ");
INSERT INTO cmeNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ku huoŋgu-na, Yesu *hãalãbiemba ji ta ba fanu ba-naa da ba suɔ umaŋ nelbuɔ‑i ba hɔlma-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesu wuɔ suɔ baa-ba, wuɔ biɛ bisãmbiloŋo naŋo jĩna u caaŋgu-na aa naa waŋ baa-ba wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","«Umaŋ duɔ ne muɔŋo‑i aa bel bisãmbiloŋ daayo‑i fafamma, kuu dii ŋaa kutieŋo bilaa mɛi fɛrɛ yaa‑i; aa umaŋ duɔ bel muɔŋo‑i fafamma, kuu dii ŋaa u bilaa umaŋ puɔraa-mi. Na saa da, umaŋ duɔ ce u fɛrɛ cɛkũɔ na hɔlma-na hiere, u yaa‑i nelbuɔ‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Nsãa wuɔ waŋ baa-yo wuɔ: «Hãalãtie, i daa naacolŋo naŋo taa u bĩ ŋ yerre‑i aa tuɔ donya *jĩnabaa-ba‑i. Miɛ ne da u sa nyaanu-niɛ baa miɛŋo‑i, i ce u yaŋ.» ");
INSERT INTO cmeNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yesu wuɔ cira: «Baa na cie-yo, umaŋ duɔ saa bigãaŋ-na, kutieŋo dii baa-na.» ");
INSERT INTO cmeNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Diiloŋ uŋ ŋa naa saaya u hũu Yesu‑i yinni maŋ nuɔ‑i, niŋ juɔ ta ni piɛ, wuɔ sire wuɔ fuɔ fuɔ kã *Yerusalɛmu‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Aa naa puɔr nuɔmba ta u yaaŋ-na. Kutaambaŋ kaa hi *Samari nelle nande‑i, baa yiɛra wuɔ ba tigiiŋ cie-yo. ");
INSERT INTO cmeNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ŋga baŋ waa da ba cor kã Yerusalɛmu‑i-na, nelle fande taamba saa hũu-ma u duɔ har ba nelle-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Baŋ juɔ hi da-ma dumaaŋo-na, Sake‑i baa Nsãa‑i baa cira: «Itie, ŋ sa yaŋ i ce Diiloŋo naar ko-ba wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yesu wuɔ bir nuola-bɛi. ");
INSERT INTO cmeNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Aa ba cor ta ba kã nelle nande. ");
INSERT INTO cmeNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Baŋ kãŋ hũmelle-na, naacolŋo naŋo gbɛ̃ Yesu‑i wuɔ: «Itie, mi ka ta mi nyaanu-niɛ niŋ kãŋ terni maŋ nuɔ‑i hiere.» ");
INSERT INTO cmeNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesu gbɛ̃-yo wuɔ: «Muncɔmmu dii baa bũɔrãamba‑i, aa kamma dii baa huriimba‑i; ŋga terieŋgu si dii baa *Moloŋ-Biɛŋo‑i u duɔ tuɔ cĩnnu u yuŋgu‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Aa naa miɛl waŋ baa unaŋo‑i wuɔ: «Jo i ta». Naacolŋo gbɛ̃-yo wuɔ: «Yaŋ mi to duɔ ku mi fuure-yuɔ tĩ, mi ka suɔ jo i ji tiɛ wuɔra.» ");
INSERT INTO cmeNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesu wuɔ gbɛ̃-yo wuɔ: «Yaŋ kuomba fuure ba nakuomba‑i, aa nuɔŋo‑i ŋ kã ŋ ka ta ŋ wuɔra ŋ waŋ *Diiloŋ-bãaŋgu maama‑i baa nuɔmba‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Unaŋ wuɔ tuɔ piiye baa Yesu‑i wuɔ: «Itie, mɛi ka ta mi nyaanu-niɛ, ŋga yaŋ mi ka cãrã hũmelle‑i cĩiŋgu-na igɛ̃na.» ");
INSERT INTO cmeNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesu wuɔ cira: «Ŋ saa da, umaŋ duɔ tuɔ kũ baa niimba‑i aa tuɔ miɛl u ne u huoŋgu-na, kutieŋo siɛ gbãa guona Diiloŋ-suoŋgu-na.» ");
INSERT INTO cmeNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ku huoŋgu-na, Yesu wuɔ tiraa hiel nuɔmba komuɔŋa siɛi baa cĩncieluo ba hãi a puɔr-ba ba hã-ba-hãi nilɛiŋa-na hiere baa terni maŋ uŋ ŋa naa saaya u kã-niɛ, ba da ba ta u yaaŋ-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Aa naa waŋ baa-ba wuɔ: «Dĩmma dii bɔi ŋga ma kartaamba saa ciinu. Cãarãŋ suontieŋo‑i u puɔr nuɔmba namba naara.» ");
INSERT INTO cmeNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Aa naa cira: «Miŋ puɔraa-na dumandɛ‑i, kuu dii ŋaa mi ciɛŋ tũlmba ka dii-ba maamunaamba-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Da na'a na ta, molo baa biɛ gbeiŋa, molo baa biɛ buɔra, molo baa bi biɛ naatɛnni. Aa da na ta na kã, molo baa ka yiɛra hũmelle-na wuɔ u jaal moloŋo. ");
INSERT INTO cmeNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Da na ka suur cĩiŋgu maŋ nuɔ‑i, mamaŋ dii cemma igɛ̃na ma yaa daama, na cira: ‹Tĩyãaŋ dɛi.› ");
INSERT INTO cmeNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Da kuɔ yaafɛ̃llentieŋo dii cĩiŋgu faŋgu-na, na jaaluŋgu ka hi-yo, da ma'i sĩ ku ka bir jo na wulaa. ");
INSERT INTO cmeNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Da ba jãrã-nɛi fafamma terieŋgu maŋ nuɔ‑i, na har na tĩɛna kusuɔŋ-nu'i. Da ba hã-na kumaŋ, na hũu na wuo. Da ba bi hã-na kuunyɔŋgu maŋ, na hũu na nyɔŋ. Maacembiloŋo saaya baa u maacemma sullu. Baa na ta na horuonu na muŋharmunterni‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Da na suur nelle maŋ nuɔ‑i, da ba bel-na fafamma aa hã-na kumaŋ, na hũu na wuo fiɛi. ");
INSERT INTO cmeNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Aa jaamba maŋ dii nelle fande-na, na sire-bɛi aa na waŋ baa nuɔmba‑i wuɔ *Diiloŋ-bãaŋgu piyaa-ba tĩ. ");
INSERT INTO cmeNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ŋga da na suur nelle maŋ nuɔ‑i, aa ba yagar ba saa hã-na muntĩɛnammu, na kã nelleŋ-huɔŋga-na na ka cira: ");
INSERT INTO cmeNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‹I pirii i nallu‑i na nelle-na, ŋga mamaŋ dii, na saaya na suɔ wuɔ Diiloŋ-bãaŋgu piyaa tĩ.› ");
INSERT INTO cmeNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Mi tũnu-nɛi, bamaŋ da ba saa ka hã-na muntĩɛnammu, Diiloŋ duɔ ji tuɔ yuu nuɔmba‑i yiiŋgu maŋ nuɔ‑i, uŋ ka haa kumaŋ kutaamba-na, ku ka balaŋ yaŋ Sodɔmutaamba kũŋgu‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Aa naa cira: «Korasitaaŋ namaaŋo‑i, sũlma haraa-nɛi! Betisadataaŋ namaaŋo‑i, sũlma haraa-nɛi! Gbɛrɛ-wɛima maŋ ciɛ namaa hɔlma-na, kuɔ maa naa ce Tiir nelle yaa nuɔ‑i baa Sidɔ̃ nelle-na, dii yiinaa nilɛiŋa faŋa taamba naa kũnna cuoŋgu ba fɛrɛŋ nuɔ aa dii buɔrbaa joŋgor ba temma a pigãaŋ wuɔ ba naana ba cilɔbabalaŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Terieŋgu faŋgu-na, Diiloŋ duɔ ji tuɔ yuu nuɔmba‑i yiiŋgu maŋ nuɔ‑i, uŋ ka haa kumaŋ nɛi, ku ka balaŋ yaŋ Tiirtaamba kũŋgu‑i baa Sidɔ̃taamba kũŋgu‑i hiere. ");
INSERT INTO cmeNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Kafarnamutaaŋ namaaŋo‑i, na daa niɛ sĩ namɛi ka maar nuɔmba‑i hiere wɛi? Na tãal na fɛrɛ; namɛi ka waa ba hieroŋo‑i hiere ba huoŋ-nu.» ");
INSERT INTO cmeNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Aa naa waŋ baa uŋ hielaa bamaŋ duɔ puɔr-ba wuɔ: «Da na kã, umaŋ duɔ ka nu na nunni‑i, kutieŋo nuɔ mɛi nuŋgu yaa‑i; umaŋ duɔ ka cĩina-nɛi, u cĩinaana muɔmɛi. A ne da umaŋ duɔ cĩina muɔŋo‑i, u cĩinaana umaŋ puɔraa-mi.» ");
INSERT INTO cmeNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","*Pɔpuɔrbiembaŋ kãa aa jo, ba jo ji ta ba nyɛ da musɛ̃musɛ̃ aa ta ba piiye baa Yesu‑i wuɔ: «Itie, halle baa *jĩnabaa-ba‑i hiere, diɛ piiye baa-ba aa bĩ ŋ yerre‑i ba nu i nunni‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesu wuɔ cira: «Mi daa *Sitãni hilaa dɔrɔ‑i-na jo ji diire ŋaa diiloŋ-nyiɛsĩmma. ");
INSERT INTO cmeNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Niɛŋ, mi hãa-na himma‑i ninsoŋo na ta na gbã na fĩɛna jɛ̃naamba‑i baa namɛlmba‑i, aa ta na gbã na yar bigãarãŋo‑i; a ce dumaaŋo-na bĩŋkũŋgu siɛ gbãa ce kuubabalaaŋgu nɛi. ");
INSERT INTO cmeNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Na saa da! Kumaŋ saaya ku fɛ̃ na hɔmmu‑i ku'i sĩ wuɔ *jĩnabaa-ba nuɔ na nunni‑i, ŋga ku yaa daaku: Na saaya na suɔ wuɔ na yirɛiŋa nyɛgãaŋ dii dɔrɔ‑i-na.» ");
INSERT INTO cmeNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Terduɔŋgu faŋgu-na, *Diiloŋ-Yalle pãŋ ce Yesu huɔŋga fɛ̃. Wuɔ cira: «Baba, nuɔnɛi Yuntieŋ nuɔ dɔrɔ‑i-na baa hĩɛma-na hiere. Niŋ fuyaa ŋ huɔŋga‑i cɛ̃cɛ̃muntaamba-na baa sɛbɛsuɔtaamba-na, aa cɛr pigãaŋ bisãmbiemba‑i baa-ka, ŋ jaaluŋgu bɔi. Ninsoŋo, ŋ ciɛ ŋ huɔŋga yaa dumaaŋo-na Baba.» ");
INSERT INTO cmeNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Aa naa cira: «Mi To birii wɛima‑i hiere hã-mi. Da ma hel Tuoŋo-na, molo sa suɔ Bɛpolŋo‑i, aa da ma bi hel Bɛpolŋo-na baa uŋ taaraŋ u pigãaŋ bamaŋ baa-yo, molo sa suɔ Tuoŋo‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Aa naa bir fulnu u *hãalãbiemba‑i ba kula wuɔ: «Naŋ daŋ kumaŋ daaku‑i, bamaŋ daaŋ-kuŋ ba yunni dɔlaa. ");
INSERT INTO cmeNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Yaaŋ mi tũnu-nɛi, *Diilopɔpuɔrbiemba bɔi baa fɔ̃ŋgɔ̃taamba bɔi taa ba taara ba da naŋ daŋ kumaŋ, aa nu naŋ nuŋ mamaŋ, ŋga ba saa ji gbãa.» ");
INSERT INTO cmeNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","*Ãnjĩnamma pigãatieŋo naŋo sire yiɛra aa yuu Yesu‑i baa nel daama‑i duɔ cure-yuɔ wuɔ: «Hãalãtie, da mi ta mi taara mi ka da cicɛ̃lma maŋ sa tĩɛŋ dede‑i, mi saaya mi ta mi ce bige‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesu wuɔ yuu-yo wuɔ: «Ba nyɛgãaŋ wuɔ niɛ *ãnjĩnamma-na?» ");
INSERT INTO cmeNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Naacolŋ wuɔ cira: «Ba ciɛra wuɔ: ‹Ŋ saaya ŋ dɔl Itieŋo‑i Diiloŋo‑i baa ŋ huɔŋga‑i hiere, baa ŋ kusũŋgu‑i hiere, baa ŋ fɔ̃ŋgũɔ‑i hiere, baa ŋ ãnjɔguɔma‑i hiere, aa ŋ bi dɔl ŋ nanolŋo‑i ŋaa niŋ dɔl ŋ fɛrɛ dumaa.›» ");
INSERT INTO cmeNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesu wuɔ cira: «Ma yaaŋga yaa‑i. Da ŋ ta ŋ ce mafamma‑i, ŋ ka da cicɛ̃lma maŋ sa tĩɛŋ dede‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ŋga ãnjĩnamma pigãatieŋo tuɔ taara u pigãaŋ Yesu‑i wuɔ u nelma saa kã hĩɛŋ-nu. U bir yuu-yo wuɔ: «Mi nanolŋo yaa hai?» ");
INSERT INTO cmeNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesu wuɔ siɛ-yo baa nel daama‑i wuɔ: «Naacolŋo naŋo hilaa *Yerusalɛmu‑i-na a tuɔ hiire u kã Yeriko. Uŋ kãŋ hũmelle-na, cuobaa-ba ka cie-yo hũu u bĩmbĩnni‑i, aa gbuu muo-yo ta ba yii da ba ko-yo. Baŋ muyaa-yo dumaaŋo-na, ba nanna-yuɔ aa ta. ");
INSERT INTO cmeNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","*Diilojigãntieŋo naŋo tuɔ jo ji da-yo, u ciɛl cor aa yaŋ-yo. ");
INSERT INTO cmeNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","*Levitiyiɛŋo naŋo jo ji ce maaduɔma. ");
INSERT INTO cmeNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","*Samariyiɛŋo naŋo jo ji hi da-yo, u hujarre gbuu ko-yo. ");
INSERT INTO cmeNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","U yiɛra. Duvɛ̃ waa baa-yo, u ce duvɛ̃ŋ daayo‑i a saar u pãnni‑i aa hure namma niɛ aa vaaya-niɛ. Uŋ ciɛ mafamma‑i, kakũmuɔ waa baa-yo; u tɛtɛŋ-yo haa-yo u kakũmuɔ‑i-na a kã baa-yo niraaŋ-muŋharmu nammu-na ka migãaŋ bel-o fafamma. ");
INSERT INTO cmeNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ku cuo kaala‑i-na, u hiel warbieŋa hã terientieŋo‑i, wuɔ u hũu u tuɔ bel jɛiŋo‑i, kɛrɛ fuɔ cor yaaŋ-na. Da a ji yor a da u saa jo, u ce fuɔ waaŋa u tuɔ bel-o, duɔ ji jo, u ka pã-ya hã-yo.» ");
INSERT INTO cmeNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yesu wuɔ yuu ãnjĩnamma pigãatieŋo‑i wuɔ: «Naŋ huɔŋga-na, balaŋ daaba‑i ba siɛi‑i-na, hayo‑i niɛ jɛiŋ daayo‑i wuɔ u nanolŋo?» ");
INSERT INTO cmeNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ãnjĩnamma pigãatieŋ wuɔ cira: «Umaŋ ciɛ hujarre‑i yuɔ, u yaa‑i.» Yesu wuɔ cira: «Kã ŋ ka ta ŋ ce dumɛi!» ");
INSERT INTO cmeNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesuŋ taa u kã *Yerusalɛmu‑i-na baa u *hãalãbiemba‑i, ba kã ka hi nelle nande‑i. Ciɛŋo naŋo waa nelle fande-na, ba taa ba bĩ-yo Marti. Marti wuɔ ce ba har u wulaa. ");
INSERT INTO cmeNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","U hãaŋo waa, ba taa ba bĩ-yo Maari. Maari wuɔ kã ka tĩɛna Yesu caaŋgu-na tuɔ nu u tuɔ piiye. ");
INSERT INTO cmeNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","A ne da huɔŋgu faŋgu-na, Marti yaaŋga naa gbuu huol baa gonyamma‑i. Wuɔ jo ji tuɔ piiye baa Yesu‑i wuɔ: «Itie, mi hãaŋoŋ yaaŋ mi ta mi gonya mi da-mi-diei naŋ daa ku biyaa wɛi? Ŋ sa waŋ baa-yo u jo ji kãyã-miɛ wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Yesu wuɔ cira: «Marti, ne hãa, ŋ huɔŋga yuu baa nelma bɔi, ku'i ciɛ ŋ yaaŋga huol huolŋ daama temma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Nɛliɛŋ nuɔ ŋ saaya ŋ ne wɛima diei par. Daŋ'a ŋ par, ŋ ne mamaŋ faa. Maariŋ paraa mamaŋ, ma yaa faa; molo si dii duɔ ji hũu-ma u wulaa.» ");
INSERT INTO cmeNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Yiiŋgu naŋgu-na, Yesu waa terieŋgu naŋgu-na tuɔ cãrã Diiloŋo‑i. Uŋ juɔ cãrã tĩ, u *hãalãbiloŋo naŋo waŋ baa-yo wuɔ: «Itie, hãalã-yiɛ i tiɛ cãrã Diiloŋo‑i ŋaa Nsãa uŋ hãalãayã u hãalãbiemba‑i dumaa.» ");
INSERT INTO cmeNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesu wuɔ cira: «Da na'a na cãrã Diiloŋo‑i, ciɛraŋ: ‹I To nuɔ, yaŋ nuɔmba‑i hiere ba suɔ wuɔ nuɔnɛi Diiloŋ nuɔŋo‑i. Pa ŋ bãaŋgu‑i yiɛ. ");
INSERT INTO cmeNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ta ŋ hã-ye niiwuoni‑i yinni maŋ joŋ. ");
INSERT INTO cmeNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Umaŋ duɔ cãl miɛŋo‑i i ce-yo jande. Diɛ bi cãl-ni ŋ ce-ye jande; ŋ baa gãŋ baa-ye. Baa yaŋ wɛima gbãa tãal-e dii-ye kuubabalaaŋgu cemma-na.›» ");
INSERT INTO cmeNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Uŋ waaŋ mafamma‑i, u tiraa cira: «Namaaŋo-na, umaŋ duɔ sire kã u jĩɛŋo naŋ wulaa isuɔholleŋ ka tuɔ muo dũŋgu‑i yuɔ, wuɔ u sire hã-yo niiwuoni, ");
INSERT INTO cmeNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","kɛrɛ u jĩɛŋo naŋo haraa-yuɔ, u saa da kuuwuoŋgu duɔ hã-yo. ");
INSERT INTO cmeNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","U jĩɛŋo tĩɛ dii dũŋgu-na aa cira: ‹Baa mulĩɛŋ-muɔ; mi gaala tĩ baa mi bisãlmba‑i aa dũŋgu tiraa gbonu, mi siɛ gbãa sire da mi biɛ niiwuoni hã-ni.› ");
INSERT INTO cmeNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Yaaŋ mi tũnu-nɛi, naacolŋ duɔ cor tuɔ muo dũŋgu‑i, u jĩɛŋ duɔ fiɛ'a u saa ne ba jĩɛsĩnni‑i aa sire, uŋ muo u huol u yaaŋ-na u ka sire hã-yo uŋ taaraŋ nimaŋ hiere. ");
INSERT INTO cmeNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","«Yaaŋ mi tũnu-nɛi: Cãarãŋ! Ba ka hã-na. Taaraayaŋ! Na ka da. Bĩɛŋ! Ba ka siɛ-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Umaŋ cãarãŋ ba hã u yaa‑i, umaŋ taaraayaŋ u yaa daaŋ, aa umaŋ bĩɛŋ ba siɛ u yaa‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","«Namaaŋo-na, hai moloŋ biɛŋo‑i duɔ cãrã teterieŋo u wulaa, u yaŋ-yo aa bel jĩɛŋo hã-yo? ");
INSERT INTO cmeNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Sisɔ duɔ cãrã cumɛlle, u yaŋ-yo aa bel namiɛŋo hã-yo? ");
INSERT INTO cmeNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Namaa namaŋ balaaŋ, da na ta na suɔ-ma na hã na bisãlmba‑i bĩmbĩfafanni, ku ce niɛ aa na To‑i dɔrɔ‑i-na, bamaŋ cãarãŋ u *Yalle‑i u siɛ hã-ba baa-de?» ");
INSERT INTO cmeNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yiiŋgu naŋgu-na, Yesu waa tuɔ donya *jĩna naŋo‑i naacolŋo naŋo-na. Jĩna wuɔ ciɛ naacolŋo‑i bobo. Uŋ juɔ hel, naacolŋo doŋ tuɔ piiye, kuɔ cu nuɔmba hɔmmu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Banamba ta ba piiye wuɔ: «Jĩna ba yuntieŋo‑i *Bɛlsebul yaa hãa-yo himma‑i u tuɔ donya jĩnabaa-ba‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Banamba ta ba taara ba cure-yuɔ, baa cira wuɔ da kuɔ Diiloŋo puɔraa u yaa‑i, u ce bĩŋkũŋgu pigãaŋ-ba ba ne. ");
INSERT INTO cmeNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Yesu wuɔ suɔ ba huɔya-maama‑i, wuɔ gbɛ̃-ba wuɔ: «Da ŋ da neduɔleŋ-baaŋ namaaŋo‑i na sa gbo, yiiŋgu dii baa yiiŋgu, na nelle ka muonu. ");
INSERT INTO cmeNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Namaa naŋ ciɛra wuɔ Bɛlsebul hãa-mi himma‑i mi ta mi donya jĩnabaa-ba‑i hãa, *Sitãni duɔ tuɔ gãŋ baa fuɔ fɛrɛŋ baamba‑i, u fɔ̃ŋgũɔ ce niɛ aa cɔ u wulaa? ");
INSERT INTO cmeNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Sitãni duɔ hã-muɔ himma‑i mi ta mi donya jĩnabaa-ba‑i, namaa baamba fuɔ, hai moloŋo‑i hãa bafamba‑i ba ta ba donya-bɛi? Na saa da, namaa fɛrɛŋ baamba yaa ka karnu ciiruo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Muɔ fuɔ, Wɛimantieŋo yaa hãa-mi himma‑i mi ta mi donya jĩnabaa-ba‑i. Ku yaa pigãaŋ wuɔ *Diiloŋ-bãaŋgu paa-nɛi tĩ. ");
INSERT INTO cmeNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","«Fɔ̃ŋgɔ̃tieŋo maŋ jĩɛna kuumuoŋgu u caaŋ-nu tuɔ niya u dumɛlle‑i, cuoyuo sa siɛ suur-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ŋga umaŋ fɔ̃ŋgũɔ‑i jĩɛnya fuɔ wuoŋo‑i duɔ jo, uŋ haa u naŋga u kuumuoŋgu maŋ nuɔ‑i, u hũu-ku aa biɛra u bĩmbĩnni‑i hiere calnu-niɛ hã nuɔmba. ");
INSERT INTO cmeNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","«Umaŋ duɔ uu si dii baa-mi, kutieŋo bigãaŋ-mi, aa umaŋ duɔ u sa tigiiŋ baa-mi, u pisãllã.» ");
INSERT INTO cmeNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","«*Jĩna duɔ hel moloŋo-na, u kã ka tuɔ wuɔra u bĩŋ hĩɛŋ-nu duɔ taara muntĩɛnammu. Duɔ saa ka da, u cira: ‹Mi ka bir kã mi muntercɔlɔmmu-na.› ");
INSERT INTO cmeNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Aa bi bir. Duɔ kã ka da kutieŋo gbuu migãaŋ u huɔŋga‑i da welewele aa tigiiŋ-ka, ");
INSERT INTO cmeNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","u bir ka bĩ u najĩnabaa niehãi, bamaŋ balaaŋ yaŋ ufaŋo‑i, ba jo ji suur tĩɛna-kɛi. Da ba jo ji waa dumaaŋo-na, ku migãaŋ balaŋ kutieŋo-na a yaŋ dĩɛlã-kũŋgu‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesuŋ taa u waŋ mafamma‑i, ciɛŋo naŋo piiye da gbagaga nuɔmba-na wuɔ: «Ciɛŋo maŋ huɔŋ-ni aa fiɛ-ni u yuŋgu dɔlaa!» ");
INSERT INTO cmeNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yesu wuɔ yaŋ aa gbɛ̃-yo wuɔ: «Cira, bamaŋ nuɔŋ Diiloŋ-nelma‑i aa wuɔ ma hũmelle‑i ba yunni dɔlaa.» ");
INSERT INTO cmeNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Nuɔmbaŋ gbuu ji ta ba ciinu huɔŋgu maŋ nuɔ‑i Yesu caaŋgu-na, wuɔ cira: «Fiɛfiɛ ku nuɔŋ namaaŋo‑i na saa fa; na ciɛra mi ce bĩŋkũŋgu hã na ne. Ŋga bĩŋkũŋgu sa ce dii hã-na, mamaŋ daa *Yonasi‑i ma ka saanu baa-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Yonasiŋ waa kumaŋ Ninivetaamba wulaa, *Moloŋ-Biɛŋo ka waa kufaŋgu temma yaa‑i namaa na wulaa. ");
INSERT INTO cmeNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Gɛ̃ŋgɛryiiŋgu-na, Seba nellentieŋo ka da nuŋgu fiɛfiɛ ku nuɔŋ namaaŋo-na. Fuɔ siire termaaŋ daaku-na a karnu nilɛiŋa‑i hiere duɔ ji nu *Salomɔ nelma‑i, a ne da namaa hɔlma-na bande‑i-na, moloŋo dii umaŋ maaraa Salomɔ‑i aa na yagar na sa nu u nuŋgu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ninivetaamba nuɔ Yonasi nuŋgu‑i aa nanna ba cilɔbabalaŋo‑i, a ne da namaa hɔlma-na bande‑i-na, moloŋo dii umaŋ maaraa Yonasi‑i, aa na yagar wuɔ na siɛ nu u nuŋgu‑i. Terieŋgu faŋgu-na, Diiloŋ duɔ ji tuɔ yuu nuɔmba‑i, Ninivetaamba ka cira na cãlãa cemma.» ");
INSERT INTO cmeNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","«Molo sa celieŋ fitĩnuɔ‑i aa fuo-yo, sisɔ aa ce bĩŋkũŋgu cure-yuɔ. Da ŋ celieŋ-yo, ŋ haa-yo dɔrɔ dũŋ-huɔŋga ce cerre hiere. ");
INSERT INTO cmeNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Nɛliɛŋ nuɔ ŋ yufieŋa yaa naŋ fɛrɛŋ kerre fitĩnuɔ‑i. Ŋ yufieŋ da a fa, ŋ waa cecerma-na; ŋga ŋ yufieŋ da a saa fa, ŋ waa kukulma-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Terieŋgu faŋgu-na, gbãŋ fitĩnuɔ maŋ dii baa-ni u baa ji dĩŋ aa yaŋ-ni. ");
INSERT INTO cmeNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Da ŋ waa hiere cecerma-na, ŋ bĩŋkũŋgu diei si dii kukulma-na, ŋ ka waa ŋaa ŋ suurii fitĩŋ-dũŋ-nu.» ");
INSERT INTO cmeNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesuŋ juɔ piiye tĩ, *Farisĩɛyiɛŋo naŋo bĩ-yo wuɔ ba ka wuo niiwuoni u cĩiŋgu-na. Yesu wuɔ kã ba ka ta ba wuo. ");
INSERT INTO cmeNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Uŋ ŋa u saa saara u nammu‑i aa suɔ duɔ wuo niiwuoni‑i, kuɔ ce Farisĩɛyiɛŋ daayo‑i gbɛrɛ. ");
INSERT INTO cmeNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Yesu wuɔ gbɛ̃-yo wuɔ: «Farisĩɛbaa namaaŋo‑i, naa dii ŋaa nɛliɛŋo maŋ saaraa kalni honni‑i aa yaŋ ni hɔmmu yu baa duganni. Da na ce na migãaŋ na kũɔma yaa da welewele aa na hɔmmu yu baa cuosĩnni baa balaaŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Mimiɛl namaa temma‑i daana‑i, umaŋ ciɛ huoŋgu‑i u'i saa ce huɔŋga‑i wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Firiinuŋ na hɔmmu‑i baa sũntaamba‑i ŋ ka da na birii nuɔfafaaŋ namaa. ");
INSERT INTO cmeNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","«Farisĩɛbaa namaaŋo‑i, sũlma haraa-nɛi; da na ce na dii Diiloŋo *yufelle‑i ka cor baa niifiɛlu‑i du sĩnni-na hiere aa na siɛ bi ce kumaŋ vii, na siɛ bi tiraa dɔl Diiloŋo‑i. A ne da, naa naa saaya na ta na ce ma yaa‑i igɛ̃na aa suɔ haa manamma‑i ma dɔrɔ. ");
INSERT INTO cmeNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","«Farisĩɛbaa namaaŋo‑i, sũlma haraa-nɛi; da na suur *Diilonelhãalãdũŋgu-na, na taara na tĩɛna yaaŋ-na. Na taara da na waa nuɔmba-na, ba ta ba piɛ ba jaal-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Sũlma haraa-nɛi; naa dii ŋaa cĩncuɔŋa maŋ gbuyaanu, nuɔmba saa suɔ wuɔ munterbabalammu, ba ta ba wuɔ ba cor a dɔrɔ.» ");
INSERT INTO cmeNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","*Ãnjĩnamma pigãatieŋo naŋo gbɛ̃-yo wuɔ: «Hãalãtie, da ŋ ta ŋ piiye dɛ‑i-na, ma sĩ ŋ bi tuora miɛ fɛrɛ‑i kɛ?» ");
INSERT INTO cmeNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesu wuɔ cira: «Ãnjĩnamma pigãataaŋ namaaŋo‑i, sũlma bi haraa-nɛi; da na ce na biɛ coŋgorni maŋ nɛliɛ siɛ gbãa tũu-ni a hã nuɔmba‑i wuɔ ba tũu, aa na siɛ bi bel ba tũu. ");
INSERT INTO cmeNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Sũlma haraa-nɛi; na bĩncuɔmbaŋ kuɔ *Diilopɔpuɔrbiemba maŋ, na siire ta na ma ba cĩncuɔŋa‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Naŋ ciɛ mafamma‑i, kuu dii ŋaa na pigãaŋ wuɔ na bĩncuɔmbaŋ ciɛ kumaŋ ku faa. Bafamba kuɔ Diilopɔpuɔrbiemba‑i aa namaa ta na ma ba cĩncuɔŋa‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ku'i ciɛ Diiloŋ uŋ suɔ wɛima‑i hiere, u waŋ-ma gbar-ma wuɔ: ‹Mi ka saaŋ mi pɔpuɔrbiemba namba hã-ba. Ba ka ko banamba bɛi, aa ce banamba kpãncɔ̃lgũɔ.› ");
INSERT INTO cmeNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Diilopɔpuɔrbiemba maŋ baŋ kuɔ-ba a doŋ dii miwaaŋo domma-na, Diiloŋo kaa yuu fiɛfiɛ ku nuɔŋ namaaŋo‑i kumaŋ ciɛ na ko-ba. ");
INSERT INTO cmeNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Yaaŋ mi tũnu-nɛi, baŋ kuɔ Abɛl aa ko bamaŋ cu-yo hiere a ji hi Sakari maŋ baŋ kuɔ-yo mumbuolmuŋ-terieŋgu hɔlma-na baa *Diilodubuɔ‑i, ba kaa yuu-na kumaŋ ciɛ na ko-ba. ");
INSERT INTO cmeNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","«Ãnjĩnamma pigãataaŋ namaaŋo‑i, sũlma haraa-nɛi! Naŋ fuyaa mamaŋ gbãa ce nuɔmba suɔ Diiloŋo‑i; naa dii ŋaa nɛliɛŋo maŋ gbuɔnu dũŋgu aa fuo diele‑i. Fuɔ siɛ suur aa bamaŋ taaraayaŋ ba suur u siɛ bi yaŋ ba da suur.» ");
INSERT INTO cmeNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yesuŋ juɔ hel juwuoterieŋgu-na, ãnjĩnamma pigãataamba‑i baa Farisĩɛbaa-ba jo ji yu-yuɔ ta ba waana baa-yo aa ta ba yuu-yo baa nelma bɔi ");
INSERT INTO cmeNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","wuɔ sĩ u ka piiye cãl ba da ãntãalãmma haa-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Yesuŋ taa u piiye baa *Farisĩɛbaa-ba‑i, nuɔŋ baa kũɔl ba-naa jo ji yu-yuɔ. Wuɔ waŋ baa u *hãalãbiemba‑i wuɔ: «Bilaaŋ na fɛrɛ Farisĩɛ ba dawɔruɔ‑i-na; uu dii ŋaa konsiini. Baa na yaŋ ba ji celieŋ-na baa-yo. ");
INSERT INTO cmeNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Nelma maŋ fuyaa hiere, ma ka hel. ");
INSERT INTO cmeNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Da na fiɛ fuo waŋ mamaŋ, ma ka nu. ");
INSERT INTO cmeNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","«Mi jɛ̃naaŋ namaa, yaaŋ mi tũnu-nɛi, baa na ta na kãalã umaŋ gbãa ko-na yoŋ aa u siɛ gbãa ce kunaŋgu nɛi. ");
INSERT INTO cmeNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Mi ka pigãaŋ-na naŋ saaya na ta na kãalã umaŋ. Na saaya na ta na kãalã Diiloŋo yaa‑i. Da ŋ ku, u yaa gbãa dii-ni dãamu-na. Coima saa fa, na saaya na ta na kãalã u yaa‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Na saa da, ba sa suor tigãlãamba ndii warbieŋa hãi yoŋ wɛi? A ne da u diei maama sa karaanu Diiloŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Halle na yukuɔsĩnni maŋ daani‑i, Diiloŋo kãaŋ-ni hiere. Terieŋgu faŋgu-na, baa na ta na tie holle; na bɔyaa tigãlãamba-na titirre. ");
INSERT INTO cmeNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","«Mi tũnu-nɛi: Umaŋ duɔ yiɛra-mɛi nuɔmba yaaŋga-na wuɔ mɛi wuoŋo, *Moloŋ-Biɛŋo kaa yiɛra-mɛi *dɔrpɔpuɔrbiemba yaaŋga-na wuɔ kutieŋo‑i fuɔ bi wuoŋo. ");
INSERT INTO cmeNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ŋga umaŋ duɔ cĩina-miɛ nuɔmba yaaŋga-na, Moloŋ-Biɛŋo kaa bi cĩina kutieŋo‑i dɔrpɔpuɔrbiemba yaaŋga-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Umaŋ duɔ waŋ noparaaŋ-ãndaaŋgu baa Moloŋ-Biɛŋo‑i, jande gbãa ce kutieŋo-na, ŋga umaŋ duɔ waŋ noparaaŋ-ãndaaŋgu baa *Diiloŋ-Yalle‑i, jande cɛraa u ce kutieŋo-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Da ba bĩ-na yiiŋgu yiiŋgu *Diilonelhãalãdũnni-na, sisɔ yaataamba wulaa, sisɔ fãamaaŋ ba terieŋ-nu; baa na yaŋ na hɔmmu cu wuɔ na siɛ ka suɔ naŋ ka waŋ mamaŋ a kor. ");
INSERT INTO cmeNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Da na ka hi, Diiloŋ-Yalle ka pigãaŋ-na naŋ saaya na waŋ mamaŋ.» ");
INSERT INTO cmeNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Yesuŋ taa u piiye, naacolŋo naŋo tĩɛ dii nuɔmba-na aa gbɛ̃-yo wuɔ: «Hãalãtie, waŋ baa mi mɔlɔ̃‑i u yaŋ i calnu i to ciiluŋgu‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesu wuɔ cira: «Mi jĩɛ, hai juɔ haa-mi gɛŋgɛrtie muɔ na yuŋgu-na, sisɔ caltie muɔ, mi da mi cal namaa ciiluŋgu?» ");
INSERT INTO cmeNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Aa naa waŋ baa nuɔmba‑i hiere wuɔ: «Bilaaŋ na fɛrɛ, baa na yaŋ gbeiŋ-maama yu na hɔmmu‑i ji cor. Na suyaa wuɔ nɛliɛŋ nuɔ da ŋ fiɛ waa wɛiŋ nuɔ niɛ niɛ, ŋ wɛisĩnni siɛ gbãa haa kunaŋgu ŋ yinni-na.» ");
INSERT INTO cmeNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Aa naa naŋ gbãnalãaŋ daaku‑i baa-ba wuɔ: «Belle nande-na, wɛiŋo naŋo dĩmma naa gbuu ce. ");
INSERT INTO cmeNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","U tuɔ piiye u huɔŋ-na wuɔ: ‹Mundiimu sĩ baa-mi, mi ka ce dĩŋ daama‑i niɛ?› ");
INSERT INTO cmeNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Aa ji cira: ‹Mi suyaa miŋ ka ce kumaŋ. Mi ka muonu mi inɔŋgɔ̃baa-ba‑i aa ma bɔ̃mbɔ̃ŋ-baamba a dii-ma baa mi nagãŋ-niini‑i hiere. ");
INSERT INTO cmeNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Da mi gbãa ce mafamma‑i, mi dĩmmaŋ ciinu, mi ka tĩɛna ta mi wuo yoŋ aa ta mi nyɔŋ, aa bi ta mi ce mi bãaŋgu‑i. Mi ka ce bieŋa bɔi, mi siɛ guona.› ");
INSERT INTO cmeNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Diiloŋo gbɛ̃-yo wuɔ: ‹Ŋ milãaŋ ŋ sa cɛ̃, isuɔŋ daaku-na ŋ ka ku. Da ŋ ku, niŋ daa dĩmma maŋ daama‑i ma ka ce hai maama‑i?›» ");
INSERT INTO cmeNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yesu wuɔ cira: «Kuuduɔŋgu yaa baa bamaŋ gbaraaŋ ba nyaanu miwaaŋ daayo wɛisĩnni‑i aa yaŋ Diiloŋ-niini‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ku huoŋgu-na, Yesu wuɔ gbɛ̃ u *hãalãbiemba‑i wuɔ: «Da mi ta mi piiye baa-na wuɔ na baa tie holle baa na niiwuoniŋ-kũŋgu‑i, baa na niidiiniŋ-kũŋgu‑i; ");
INSERT INTO cmeNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","kuu dii ŋaa nɛliɛŋ nuɔ ŋ yuŋgu bɔyaa niiwuoni-na aa ŋ kũɔma bɔyaa niidiini-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Niɛŋ huriimba‑i! Ba sa guona, aa inɔŋgɔ̃baa-ba bi sĩ baa-ba, ŋga Diiloŋo hã ba ta ba wuo. Na saa buɔ huriimba-na titirre wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Namaaŋo-na, hai moloŋo‑i baa u hɔculle‑i hiere u gbãa naara kunaŋgu u yinni-na? ");
INSERT INTO cmeNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ku fɔ̃ŋgũɔ ŋ'a uu si dii-nɛi na da na ce maayilemma famma‑i, bige‑i ciɛ na hɔmmu ta mu cu baa na niiwuoniŋ-kũŋgu‑i baa na niidiiniŋ-kũŋgu‑i? ");
INSERT INTO cmeNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Niɛŋ pũlmaŋ puŋ ma fa dumaa, a ne da ma sa ce maacemma, ma sa bi sũ joŋgorbaa. Mi tũnu-nɛi, halle *Salomɔ‑i baa u wɛisĩnni‑i hiere, u saa ji dii kompaŋga maŋ faa yaŋ pũlma‑i dede. ");
INSERT INTO cmeNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Hĩɛŋgu maŋ hĩɛŋgu, Diiloŋ duɔ diyaa-kuɔ fafamma nyuŋgo‑i-na diyaaŋ daama temma‑i, aa bisĩnuɔ dãamu waa da mu caa-ku; namaa namaŋ nelbilieŋ namaa, u ka diiya-nɛi ka hi hie? Na saa haa na naŋga‑i Diiloŋo-na ku haama. ");
INSERT INTO cmeNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Baa na yaŋ na hɔmmu ta mu cu baa na niiwuoniŋ-kũŋgu‑i. Baa na ta na hel na jɔguɔŋ-ma. ");
INSERT INTO cmeNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Bamaŋ sa suyaaŋ Diiloŋo‑i, ba yaa gbagbaraayaŋ nifanni huoŋ-nu. Namaa To suyaa wuɔ ni maama dii-nɛi. ");
INSERT INTO cmeNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Yaaŋ u maama yaa yu na hɔmmu‑i igɛ̃na, na ka da u hãa-na baa daani‑i naara. ");
INSERT INTO cmeNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","«Cɛllɛ-baaŋ namaa namaŋ nuɔ mi babĩmuɔ‑i, baa na yaŋ korma da-na. Ku dɔlaanu na To‑i u hã-na u nelle‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Suoraaŋ na nagãŋ-niini‑i aa na hã sũntaamba baa gbeiŋa faŋa‑i. Da na ce mafamma‑i, kuu dii ŋaa na tieraaya gbeibuɔ jĩna *Diiloŋ-nelle-na. Gbeiŋa faŋa sa ji tĩ dede, a sa bi ji kã terieŋgu. Molo si dii duɔ ji biɛ-ya na wulaa terieŋgu-na, nyɛi bi si dii duɔ ji wuo-ya. ");
INSERT INTO cmeNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Nɛliɛŋ nuɔ niŋ tieraaya kusuɔŋ-nu ŋ huɔŋga dii kusuɔŋ-nu'i.» ");
INSERT INTO cmeNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","«Tigiiŋ na fɛrɛ, baa na yaŋ na fitĩmbaa-ba dĩŋ. ");
INSERT INTO cmeNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Na saaya na waa ŋaa maacembiemba maŋ ba yuntieŋo kãa bilohĩyãlle aa ba tĩɛna ta ba cie u jomma‑i wuɔ duɔ jo ba hĩl dumɛlle‑i hã-yo. ");
INSERT INTO cmeNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ba yuntieŋ duɔ jo ji da ba saa kor duɔfũŋ, ba yunni dɔlaa. Mi tũnu-nɛi, ŋ da ba yuntieŋo biyaa maacemmaŋ-joŋgoruo dii, aa ce ba tĩɛna u hã-ba niiwuoni ba wuo. ");
INSERT INTO cmeNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Duɔ fiɛ jo isuɔholleŋ, sisɔ cuo kaalmaŋ-caaŋ-nu, a jo ji da ba saa duɔfũŋ, ba yunni ka dɔl. ");
INSERT INTO cmeNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Na saa da, da ŋ suɔ cuoyuo uŋ ka suur-niɛ huɔŋgu maŋ nuɔ‑i, ŋ siɛ yaŋ u ji kanu ŋ dũŋgu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Namaa fɛrɛ‑i naŋ'a na saa tĩɛna baa-ma wuɔ *Moloŋ-Biɛŋo ka jo huɔŋgu maŋ nuɔ‑i, u jo huɔŋgu faŋgu'i nuɔ‑i. Terieŋgu faŋgu-na, na saaya na tigiiŋ na fɛrɛ.» ");
INSERT INTO cmeNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Piɛr yuu-yo wuɔ: «Itie, gbãnalãaŋ daaku vii *hãalãbieŋ miɛ yoŋ wɛi, sisɔ ku vii nuɔmba‑i hiere?» ");
INSERT INTO cmeNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Yesu wuɔ cira: «Da ŋ nu wuɔ maacembiloŋo maŋ vii, aa tuɔ cɛ̃, u yaa umaŋ u yuntieŋo kãa nelle aa ce u tuɔ ne u dumɛlle‑i aa tuɔ hã u namaacembiemba namba‑i niiwuoni‑i fafamma. ");
INSERT INTO cmeNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","U yuntieŋ duɔ ka bir jo ji da u ciɛ u maacemma‑i maŋ saaya ma ce dumaa, fuɔ yuŋgu dɔlaa. ");
INSERT INTO cmeNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Mi tũnu-nɛi, u yuntieŋo ka haa-yo u nagãŋ-niini yuŋ-nu hiere. ");
INSERT INTO cmeNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ŋga duɔ da niɛ sĩ u yuntieŋo siɛ bir jo fiɛfiɛ, aa doŋ tuɔ muo u namaacembiemba‑i, ku bɛmba‑i baa ku caamba‑i hiere, tuɔ wuo aa tuɔ nyɔŋ u ye; ");
INSERT INTO cmeNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","uŋ ŋ'a u saa tĩɛna baa yiiŋgu maŋ maama‑i, baa huɔŋgu maŋ maama‑i, u yuntieŋo jo huɔŋgu faŋgu'i nuɔ‑i. Duɔ jo ji da-yo dumaaŋo-na, uŋ ka haa kumaŋ yuɔ, u'i ka suɔ-ku. U ka ce-yo ŋaa bamaŋ sa nuɔŋ Diiloŋ-nuŋgu‑i baŋ ceŋ-baŋ dumaa. ");
INSERT INTO cmeNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","«Maacembiloŋo maŋ suyaa u yuntieŋoŋ taaraŋ kumaŋ, aa u saa taara u ce-ku, fuɔ temma‑i ba sa muo-yo ce hujarre-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ŋga maacembiloŋo maŋ sa suyaaŋ u yuntieŋoŋ taaraŋ kumaŋ, duɔ ce mamaŋ saaya ba muo-yo, ba sa muo fuɔ temma‑i bɔi. Da ba hã nuɔni maŋ bɔi, ba ka yuu-ni bɔi, da ba hã nuɔni maŋ bɔi ŋ tiera, ba ka yuu-ni cor nuŋgu faŋgu‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","«Muɔmi juɔ baa dãamu'i hĩɛma-na. Mi taara dãaŋ daamu ta mu caa. ");
INSERT INTO cmeNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Wɛima dii da ma da-mi, da ma saa da-mi cor, mi huɔŋga siɛ gbãa tĩɛna terduɔŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","«Na daa niɛ sĩ mi juɔ baa yaafɛ̃lle'i hĩɛma-na wɛi? Coima, mi juɔ baa bɔrɔmma. ");
INSERT INTO cmeNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Nuɔmba ka doŋ ta ba gãŋ dũnni dũnni. Bamaŋ da ba waa ba ndii ba dũŋgu-na, ba siɛi ka ta ba gãŋ baa ba hãi aa ba hãi bi ta ba gãŋ baa ba siɛi. ");
INSERT INTO cmeNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Tonaamba ka ta ba gãŋ baa bɛpuɔmba‑i; bɛpuɔmba bi ta ba gãŋ baa tonaamba‑i. Nyunaamba ka ta ba gãŋ baa ba biemba‑i; biemba bi ta ba gãŋ baa nyunaamba‑i. Hũɔyãamba ka ta ba gãŋ baa ba caamba‑i; caamba bi ta ba gãŋ baa hũɔyãamba‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu wuɔ tiraa waŋ baa nuɔmba‑i wuɔ: «Da na da diiloŋo biilii, na cira: ‹U ka dãa›, aa ma bi ce. ");
INSERT INTO cmeNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Aa da na da fafalmu kã bãpagũŋgu-na, na cira: ‹Babãaŋgu ka waa›, aa ma bi ce. ");
INSERT INTO cmeNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Huhurmantaaŋ namaa temma‑i daana‑i, na ciɛ niɛ ta na suɔ diiloŋo yammu‑i na bɔrɔ-muɔ aa na sa suɔ mamaŋ ciɛŋ fiɛfiɛ‑i ma yuŋgu‑i? ");
INSERT INTO cmeNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Bige‑i ciɛ na sa suɔ-ma ce kumaŋ faa cemma? ");
INSERT INTO cmeNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Moloŋ cɛ̃mɛl da di waa-niɛ, aa kutieŋo bĩ-ni, da na ta na kã hũmelle-na, gbãŋ baa-yo ŋ cãrã-yuɔ. Ni ma'i sĩ, duɔ kã baa-ni fãamaambaa-ba wulaa, ba ka hã kpãŋkpannintaamba baa-ni ba dii-ni kaso. ");
INSERT INTO cmeNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Mi tũnu-nɛi, da ba dii-ni kaso‑i-na, da ŋ saa ji pã ŋ cɛ̃mɛlle tĩ hiere, ŋ cɛraa ŋ da muŋhelmu.» ");
INSERT INTO cmeNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","*Pilati wuɔ puɔraa ba ka ko Galiletaamba namba *Diilodubuɔ‑i-na. Ba waa ta ba buol. Yesuŋ waa tuɔ waŋ nel daama‑i, nuɔmba namba jo ji ta ba piiye mafamma‑i baa-yo. ");
INSERT INTO cmeNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesu wuɔ cira: «Na daa niɛ sĩ Galiletaaŋ daabaŋ kuu kuliiŋgu maŋ, ku pigãaŋ wuɔ ba yaa balaaŋ yaŋ Galiletaamba‑i hiere wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Na karaa coima! Da na saa nanna na cilɔbabalaŋo‑i, na ka ku kulduɔŋgu baa-ba.» ");
INSERT INTO cmeNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Aa naa cira: «Nuɔmba cĩncieluo niisiɛi maŋ Siloe dujaataama naŋ cii haa-bɛi ko-ba, na daa niɛ sĩ ba yaa balaaŋ yaŋ Yerusalɛmutaamba‑i hiere wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Na karaa coima! Da na saa nanna na cilɔbabalaŋo‑i, na ka ku kulduɔŋgu baa-ba.» ");
INSERT INTO cmeNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yesu wuɔ naŋ gbãnalãaŋ daaku‑i baa-ba wuɔ: «Naacolŋo naŋo diyaa *ɛrɛsɛ̃-suoŋgu, aa sũ *yensãaŋgu kuɔ. Yiiŋgu naŋgu-na, u jo ji taara u saa da belle kuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","U waŋ baa u maacembiloŋo‑i wuɔ: ‹Bieŋa siɛi yaa dɛ‑i tibiiŋ daaku sa maŋ. Jã-ku ŋ nanna! Ku tĩyãa ta ku bɔ̃nɔŋ hĩɛma‑i gbãŋgbãŋ.› ");
INSERT INTO cmeNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Maacembiloŋo gbɛ̃-yo wuɔ: ‹Yaŋ ku cɔnu bende‑i-na; mi ka hĩŋ ku yuŋgu‑i aa dii hũɔŋgu ne ");
INSERT INTO cmeNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","sĩ ku ka maŋ belle maŋ juɔŋ. Da ku saa maŋ, i ka suɔ jã-ku nanna.›» ");
INSERT INTO cmeNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","*Yitĩɛnaŋgu naŋgu-na, Yesu kãa *Diilonelhãalãdũŋgu naŋgu-na ka tuɔ waŋ Diiloŋ-nelma‑i u pigãaŋ nuɔmba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","A ne da ciɛŋo naŋo waa baa-ba dũŋgu-na, *jĩna waa u yuŋgu-na a ce-yo jɛiŋo. Uŋ gaala jarma-na, ku bieŋ cĩncieluo baa niisiɛi waa belle fande-na. U saa gbãa tuɔ ciir u wuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesuŋ daa-yo, wuɔ bĩ u jo. Uŋ juɔ, wuɔ cira: «Ciɛŋ nuɔ, ŋ jarma taa-niɛ.» ");
INSERT INTO cmeNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Aa naa bi haa u nammu‑i yuɔ. Ciɛŋ wuɔ bi pãŋ ciir yiɛra derre! Uŋ ciirii yiɛra dumaaŋo-na, wuɔ tuɔ gbɛliɛŋ Diiloŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Yesuŋ siire jɛiŋo‑i yitĩɛnaŋgu-na, ku saa dɔlnu Diilonelhãalãdũŋgu yuntieŋo‑i, wuɔ tuɔ waŋ baa nuɔmba‑i wuɔ: «Maacemmaŋ-yinni dii yinni niediei saahɔlma-na; na saaya na ta na jo yinni fanni'i nuɔ‑i ba ta ba sire-nɛi na jarma-na; bige‑i ciɛ na sire jo yitĩɛnaŋgu-na?» ");
INSERT INTO cmeNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Yesu wuɔ cira: «Huhurmantaaŋ namaa temma‑i daana‑i! Namaaŋo-na, niintaamba‑i baa kakũntaamba‑i, da ku waa yitĩɛnaŋgu‑i ba sa kã baa-ba ba ka nyɔŋ hũmma wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Aa ciɛŋo maŋ daayo‑i, ma sĩ *Abiramu hãayɛ̃lŋo naŋo‑i kɛ? *Sitãniŋ ciɛ-yo jɛiŋo ku bieŋ cĩncieluo baa niisiɛi yaa dɛ‑i. Miŋ daa-yo, mii naa yaŋ-yo baa u jarma‑i wuɔ yitĩɛnaŋgu wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yesu bigãarãamba waa nuɔmba hɔlma-na. Uŋ piiye dumaaŋo-na, senserre gbuu da-ba. A ne da uŋ taa u ce himma maŋ, ma taa ma dɔlnu nuɔmba‑i hiere. ");
INSERT INTO cmeNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ku huoŋgu-na, Yesu wuɔ cira: «Mi gbãa saa *Diiloŋ-nellentesĩnni‑i baa bige‑i? ");
INSERT INTO cmeNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Mi gbãa saa-ni baa mutardi-belle. Da ŋ duu-de, di sire pa ce tibiiŋgu, huriimba ta ba jo ba sɛ kamma ku negemmu-na.» ");
INSERT INTO cmeNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Aa tiraa cira: «Mi gbãa saa Diiloŋ-nellentesĩnni‑i baa bige‑i? ");
INSERT INTO cmeNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Mi gbãa saa-ni baa konsiini. Da ba par-ni ba nakoluoŋ-nu a du farniŋ-jũmmu‑i kolloyufieŋa siɛi baa-ni; ni sire ce jũmmu nyurã.» ");
INSERT INTO cmeNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu wuɔ cor tuɔ suur nilɛiŋa-na hiere u waŋ Diiloŋ-nelma‑i u kã *Yerusalɛmu‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Naacolŋo naŋ wuɔ yuu-yo wuɔ: «Itie, ku ce ŋaa nuɔmba maŋ ka suur Diiloŋ-nelle-na ba siɛ ciinu wɛi?» Yesu wuɔ cira: ");
INSERT INTO cmeNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Gbãaŋ kpelle na suur baa dumɛlle maŋ wullu diele yaa‑i. Mi tũnu-nɛi, nuɔmba bɔi ka cira ba suur baa-de, ŋga ba siɛ gbãa. ");
INSERT INTO cmeNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Dumɛllentieŋ duɔ ji sire a gbonu dũŋgu‑i aa yaŋ namaa namaŋ gɔ̃ŋgũɔŋgu-na, na ka doŋ ta na muo dũŋgu‑i aa ta na piiye baa-yo wuɔ: ‹Itie, jande hĩl dũŋgu‑i i suur!› U ka cira u sa suɔ-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","«Kufaŋgu huɔŋgu-na, na ka doŋ ta na piiye baa-yo wuɔ: ‹I saa tiɛ wuo aa tiɛ nyɔŋ baa nuɔnɛi wɛi? Nuɔnɛi saa ta ŋ wuɔra ŋ waŋ Diiloŋ-nelma‑i ŋ pigãaŋ-ye nilɛiŋa-na wɛi?› ");
INSERT INTO cmeNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","«U ka bir waŋ baa-na wuɔ: ‹Kãaŋ na halaŋ mi caaŋ-nu, mi sa suɔ-na, na hieroŋo‑i hiere ãmbabalmanciraaŋ namaa.› ");
INSERT INTO cmeNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Da na ka da *Abiramu‑i baa *Isaki‑i baa *Yakɔbu‑i a naara *Diilopɔpuɔrbiemba‑i hiere *Diiloŋ-nelle-na, aa ba cie namaaŋo‑i wuɔ na siɛ da suur, na hɔmmu ka gbuu guɔla na ta na kaal. ");
INSERT INTO cmeNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Nuɔmba ka hel terni-na hiere a jo u kãlle-na ji ta ba wuo aa ta ba nyɔŋ. ");
INSERT INTO cmeNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Huɔŋgu faŋgu-na, bamaŋ dii huoŋgu-na fiɛfiɛ‑i-na, banamba ka ta yaaŋ-na, aa bamaŋ dii yaaŋga-na, banamba ka bir tĩɛ huoŋ-nu.» ");
INSERT INTO cmeNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Yesuŋ taa u waŋ mafamma‑i huɔŋgu maŋ nuɔ‑i, *Farisĩɛbaa-ba namba piɛ u caaŋ-nu a waŋ baa-yo wuɔ: «*Erɔdi taara duɔ ko-ni, ta bande‑i-na ŋ kã yaŋga naŋga!» ");
INSERT INTO cmeNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesu wuɔ cira: «Kãaŋ na ka waŋ baa jumɛlĩɛŋo faŋo‑i wuɔ nyuŋgo‑i baa bisĩnuɔ‑i mi donya *jĩnabaa aa sire jaamba; daakũŋgu‑i, mi bãl mi maacemma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ŋga nyuŋgo‑i baa bisĩnuɔ‑i baa daakũŋgu‑i, mi saaya mi cor baa mi hũmelle‑i ta mi kã *Yerusalɛmu‑i-na. *Diilopɔpuɔrbiloŋo saa saaya u ku yaŋga naŋga.» ");
INSERT INTO cmeNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Aa naa cira: «E Yerusalɛmutaaŋ namaa! Namɛi kuɔŋ Diilopɔpuɔrbiemba‑i. Diiloŋ duɔ saaŋ umaŋ hã-na, na naŋ kutieŋo‑i baa tãmpɛ̃lɛ̃iŋa ko-yo. Mɛi ciɛ ji gbɛ̃. Mi na'a mi tigiiŋ-na ŋaa kũɔnaŋoŋ tigiiŋ u biemba‑i dumaa aa pũl-bɛi, ŋga na saa hũu-ma. ");
INSERT INTO cmeNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Diiloŋo ka yaŋ na nelle‑i hã-na. Aa mi tũnu-nɛi, da na saa ji ta na cira: ‹Itieŋ uŋ saaŋ umaŋ u jo, Diilo baa-yo› na siɛ tiraa da mi yufelle.» ");
INSERT INTO cmeNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","*Yitĩɛnaŋgu naŋgu-na, Yesu kãa *Farisĩɛ ba yuntieŋo naŋo dumɛlle-na ba da ba ka wuo niiwuoni. Nuɔmba bir ka yaŋ aa ta ba ne Yesu‑i wuɔ sĩ u ka ce cãl. ");
INSERT INTO cmeNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","A ne da naacolŋo naŋo waa u yaaŋga-na, kũɔnyurãmmaŋ-jarma waa-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Wuɔ yuu *ãnjĩnamma pigãataamba‑i baa Farisĩɛbaa-ba‑i wuɔ: «A saa baa miɛ Diiloŋ-hũmelle‑i, da ŋ sire jɛiŋo yitĩɛnaŋgu-na ku faa waa ku saa fa?» ");
INSERT INTO cmeNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ba saa seŋ sũnuŋgu yuɔ. Wuɔ bel naacolŋo‑i a sire-yuɔ u jarma-na, aa naa ce u kũŋ. ");
INSERT INTO cmeNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Naacolŋ uŋ taa, wuɔ tiraa yuu-ba wuɔ: «Namaaŋo-na, umaŋ biɛŋo‑i duɔ par suur hũnfuoŋ-nu yitĩɛnaŋgu-na, kutieŋo yaŋ-yo dii wuɔ yitĩɛnaŋgu wɛi? Da ku fiɛ waa u niiŋo, u yaŋ-yo dii hũnfuoŋgu-na wuɔ yitĩɛnaŋgu-na wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ba saa da mumpiiyemmu. ");
INSERT INTO cmeNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Baŋ bĩɛ bamaŋ kãlle-na, Yesu wuɔ ne da umaŋ duɔ jo, u tuɔ taara u tĩɛna yaaŋ-na. Wuɔ waŋ baa-ba wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Moloŋ duɔ bĩ-ni u kãlle-na, da ŋ kã, baa wuɔya ŋ ka tĩɛna yaaŋga-na. Uŋ bĩɛ bamaŋ, kuniɛ sĩ unaa maaraa nuɔŋo‑i ŋ sa suɔ. ");
INSERT INTO cmeNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Da ŋ kã ka tĩɛna yaaŋga-na, kãllentieŋo duɔ ka jo ji cira ŋ sire ka tĩɛna huoŋ-nu aa hã unaŋo teterre fande‑i, ŋ yaaŋga ka ce wullu. ");
INSERT INTO cmeNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Da ba bĩ-ni, da ŋ kã, tĩɛna huoŋ-nu. Ku yaa umaŋ bĩɛ-na duɔ ka jo ji da-ni huoŋgu-na, u ka cira: ‹Mi jĩɛ, sire ŋ ji tĩɛna yaaŋ-na.› Kufaŋgu huɔŋgu-na, u ka ce-ni bɔi nuɔmba-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Umaŋ duɔ tuɔ tɛtɛŋ u fɛrɛ, ba ka hiire-yuɔ, ŋga umaŋ duɔ tuɔ hiire u fɛrɛ, ba ka tɛtɛŋ-yo.» ");
INSERT INTO cmeNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Mafammaŋ curaa, wuɔ waŋ baa umaŋ taa u ce kãlle‑i wuɔ: «Da ŋ ta ŋ ce kãlle‑i, ku saa saaya ŋ bĩ ŋ jɛ̃naamba yoŋ, baa ŋ hãmba, baa ŋ huraamba, baa ŋ caantaamba maŋ waamba‑i. Da ŋ bĩ ba yaa yoŋ, yiiŋgu dii baa yiiŋgu, bafamba ka bi ce aa bĩ-ni. Niŋ ciɛ ãnfafamma maŋ bɛi, ma sɔlaaŋgu ka suu yiiŋgu faŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Da ŋ'a ŋ ce kãlle‑i, ŋ saaya ŋ bĩ baa sũntaamba‑i, baa jaamba‑i, baa murgubaa-ba‑i, baa yiriemba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Bafamba siɛ gbãa pã ŋ babĩmuɔ sullu‑i hã-ni. Diiloŋo'i kaa pã-ni uŋ ka sire nelviimba‑i yiiŋgu maŋ nuɔ‑i. A ce dumaaŋo-na ŋ yuŋgu ka dɔl.» ");
INSERT INTO cmeNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Naacolŋo naŋo waa tuɔ wuo baa-ba, uŋ juɔ nu nel daama‑i, wuɔ gbɛ̃ Yesu‑i wuɔ: «Jaa bamaŋ ka da wuo niiwuoni‑i *Diiloŋ-nelle-na ba yunni ka dɔl dumɛi!» ");
INSERT INTO cmeNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesu wuɔ naŋ gbãnalãaŋ daaku‑i baa-yo wuɔ: «Naacolŋo naŋo taa u ce kãlle aa tũnu nuɔmba bɔi. ");
INSERT INTO cmeNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Niiwuoniŋ-huɔŋguŋ juɔ hi, u puɔr u maacembiloŋo‑i wuɔ u ka bĩ-ba. ");
INSERT INTO cmeNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Maacembiloŋ duɔ kã ka bĩ umaŋ, kutieŋo gbɛ̃-yo wuɔ u siɛ gbãa kã. Dĩɛlã-wuoŋo gbĩɛ-yo wuɔ: ‹Mi sãa suoŋgu, mi saaya mi kã ka ne-ku. Kã ŋ ka waŋ baa ŋ yuntieŋo‑i wuɔ u ce jande mi siɛ gbãa hi baa-na.› ");
INSERT INTO cmeNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","U cor kã unaŋo wulaa, fuɔ ka gbɛ̃-yo wuɔ: ‹Mi sãa niikũrãamba duɔŋa ndii, mi saaya mi kã ka kũ baa-ba ne. Kã ŋ ka waŋ baa ŋ yuntieŋo‑i wuɔ u ce jande kɛrɛ mi siɛ gbãa hi baa-na.› ");
INSERT INTO cmeNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","U cor kã unaŋo wulaa, fuɔ ka tiraa gbɛ̃-yo wuɔ: ‹Mi jãa ciɛŋo fɛlɛmma mi siɛ gbãa hi baa-na.› ");
INSERT INTO cmeNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","«Maacembiloŋo bir kã ka tũnu u yuntieŋo‑i baa-ma. U yuntieŋo huɔŋga pãŋ guɔla, u waŋ baa-yo wuɔ: ‹Baa tĩɛna; bir ŋ kã nelleŋ-huɔŋga-na ŋ ka bĩ sũntaamba‑i baa nagãduɔlbaa-ba‑i baa yiriemba‑i baa murgubaa-ba‑i ba jo.› ");
INSERT INTO cmeNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Maacembiloŋo bir ta. Uŋ kãa aa bir jo kufaŋgu‑i, u jo ji waŋ baa u yuntieŋo‑i wuɔ: ‹Mi bĩɛ nuɔmba jo, ŋga muntĩɛnammu tĩyãa yogo.› ");
INSERT INTO cmeNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","U yuntieŋo tiraa waŋ baa-yo wuɔ: ‹Bir ŋ kã sonniŋ-hũmieŋa-na ŋ ka gbãŋ baa nuɔmba‑i ba jo ji yu mi dũŋgu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Yaaŋ mi tũnu-nɛi, miŋ bĩɛ bamaŋ dĩɛlũɔ‑i-na, ba siɛ da wuo mi niiwuoni‑i.›» ");
INSERT INTO cmeNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Nuɔmba bɔi baa cuu Yesu huoŋ-nu ta ba kã *Yerusalɛmu‑i-na. Yesu wuɔ waŋ baa-ba wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Nuɔni maŋ da ŋ ta ŋ nyaanu-miɛ, ŋ saaya ŋ ce-mi bɔlbɔl ŋ to‑i-na, baa ŋ nyu‑i-na, baa ŋ ciɛŋo-na, baa ŋ bisãlmba-na, baa ŋ hãmba-na, baa ŋ mɔlbaa-ba-na, baa ŋ tũɔbaa-ba-na, halle baa naŋ fɛrɛ‑i-na. Ni ma'i sĩ, ŋ siɛ gbãa cu mi huoŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Aa nuɔni maŋ da ŋ'a ŋ sa siɛ mulĩɛma‑i baa kuliiŋgu‑i, ŋ siɛ gbãa cu mi huoŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Na hɔlma-na, umaŋ duɔ cira u ma dubuɔ, ma sĩ u tĩɛna igɛ̃na a ne dũŋguŋ ka yu dumaa, aa ne da kuɔ gbeiŋa maŋ dii baa-yo a ka gbãa baal-ku. ");
INSERT INTO cmeNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ni ma'i sĩ, duɔ jĩna ku tuole‑i, aa u saa ji gbãa baal-ku, nuɔmba ka ta ba nyɛ-yo ");
INSERT INTO cmeNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","aa ta ba piiye wuɔ: ‹Bombolma sa suɔ aa dɔlnu naacolŋ daayo‑i; u siire wuɔ fuɔ ma dubuɔ, u yaa daayo ku juɔ yar-o baalma.› ");
INSERT INTO cmeNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Kuuduɔŋgu yaa‑i baa nellentieŋo maŋ dii baa sorosibaa neifieŋa ndii. Duɔ da bɛrru baa u nanellentieŋo maŋ dii baa sorosibaa neifieŋ-cĩncieluo, u saaya u tĩɛna igɛ̃na a ne da kuɔ fuɔ sorosibaa neifieŋa ndii ka gbãa ce bɛrru‑i baa sorosibaa neifieŋ-cĩncieluo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Duɔ da u siɛ gbãa, ŋ da u diyaa nuɔmba ka cãrã-yuɔ; u siɛ yaŋ u ji jo ji diire-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Mamaŋ dii, umaŋ duɔ saa ne u nagãŋ-niini‑i aa yaŋ-ni, kutieŋo siɛ gbãa cu mi huoŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","«Dãmma‑i bĩŋkũfafaaŋgu, ŋga da ma ji saara, ma gbãa tiraa ce niɛ ce kpɛ̃nnɛ? ");
INSERT INTO cmeNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ma siɛ bi gbãa ce hũɔŋgu, ma siɛ bi tiraa gbãa fa manamma ba biɛ ka kũnna fuoreŋ. Umaŋ duɔ u ka nu, u nu!» ");
INSERT INTO cmeNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","*Nampohũutaamba‑i baa ãmbabalmanciraamba taa ba kã Yesu wulaa ba kã ba nu u nelma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","*Farisĩɛbaa-ba‑i baa *ãnjĩnamma pigãataamba ta ba waana wuɔ u ciɛ niɛ yaŋ nelbabalaamba ta ba piɛ-yo aa tiraa tuɔ siɛ u wuo niiwuoni‑i baa-ba? ");
INSERT INTO cmeNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yesu wuɔ naŋ gbãnalãaŋ daaku‑i baa-ba wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«Namaaŋo-na, tũlmba komuɔŋa ndii da ba waa baa umaŋ, aa u diei balla-bɛi, kutieŋo siɛ yaŋ komuɔŋa naa baa cĩncieluo nennaa baamba ta ba wuora aa kã ka taara umaŋ baala wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Duɔ ka da-yo, u huɔŋga ka gbuu fɛ̃ u tũu-yo kũŋ baa-yo ");
INSERT INTO cmeNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ka bĩ u jɛ̃naamba‑i baa u caantaamba‑i a waŋ baa-ba wuɔ: ‹Mi daa mi tũmaaŋo‑i, yaaŋ na hɔmmu fɛ̃ mɛi kaaŋga temma‑i.›» ");
INSERT INTO cmeNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Yesuŋ waaŋ mafamma‑i, wuɔ cira: «Yaaŋ mi tũnu-nɛi, ãmbabalmanceroŋo diei duɔ nanna u cilɔbabalaŋo‑i, kuŋ fɛ̃ŋ Diiloŋo huɔŋga‑i dumaa dɔrɔ‑i-na, nuɔmba komuɔŋa naa baa cĩncieluo nennaa maŋ saa nanna ba cilɔbabalaŋo‑i wuɔ sĩ bafamba vii, ba siɛ gbãa fɛ̃-ka dumaaŋo-na.» ");
INSERT INTO cmeNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Aa naa tiraa cira: «Neifieŋ-cĩncieluo duɔ waa baa ciɛŋo maŋ, aa neifelle balla dũŋ-huɔŋga-na u wulaa, u siɛ celieŋ fitĩnuɔ aa pir dũŋgu‑i hiere a taara-diɛ wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Duɔ da-de, u huɔŋga ka gbuu fɛ̃ u bĩ u jɛ̃naamba‑i baa u caantaamba‑i a waŋ baa-ba wuɔ: ‹Mi daa mi warbelle‑i, yaaŋ na hɔmmu fɛ̃ mɛi kaaŋga temma‑i.› ");
INSERT INTO cmeNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Yaaŋ mi tũnu-nɛi, ãmbabalmanceroŋo diei duɔ nanna u cilɔbabalaŋo‑i, *dɔrpɔpuɔrbiemba waa hɔfɛ̃lle fande temma yaa nuɔ‑i dɔrɔ‑i-na.» ");
INSERT INTO cmeNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu wuɔ tiraa cira: «Naacolŋo naŋo waa baa bɛpuɔmba hãi. ");
INSERT INTO cmeNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Yiiŋgu naŋgu-na, bisãlãaŋo gbɛ̃ tuoŋo‑i wuɔ: ‹Baba, miɛ iŋ saaya i da kumaŋ ŋ nagãŋ-niini-na, hã muɔ baa mi kũŋgu‑i fiɛfiɛ.› Tuoŋo cal u nagãŋ-niini‑i hã-ba. ");
INSERT INTO cmeNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Yinni saa da, hãaŋo suor fuɔ niini‑i aa biɛ gbeiŋa faŋa‑i kã hĩɛŋ-nu baa-ya, kã ka bĩɛna-yɛi hiere kakarkuoŋ-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","U gbeiŋaŋ kaa tĩ huɔŋgu maŋ nuɔ‑i, nyulmu naŋ temma suur nelle fande-na a ce u sa da niiwuoni u wuo. ");
INSERT INTO cmeNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","A ne da naacolŋo naŋo waa nelle fande-na tuɔ heŋ pɛrmba, naacombiloŋo kã u wulaa wuɔ u ka taara maacemma. Naacolŋo biɛ-yo u tuɔ ceŋ u pɛrmba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Nyulmuŋ gbu mu ko-yo dumaaŋo-na, u tuɔ nenu pɛrmba niiwuoni‑i. Ŋga hai ka hã fuɔ baa-ni? ");
INSERT INTO cmeNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","U gbuu ji tĩɛna jɔguɔŋ da suu, aa cira: ‹Maacembiemba maŋ dii baa mi to‑i hiere, niiwuoni sa tĩ-bɛi, aa muɔmɛi daami ta mi ku nyulmu-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mi ka sire bir kã mi to wulaa ka waŋ baa-yo wuɔ mi cãlãa Diiloŋo‑i aa tiraa cãl fuɔ fɛrɛ‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","U baa tiraa u tuɔ kãŋ-mi u biɛŋ muɔ, u yaŋ aa u bel-mi ŋaa u maacembiloŋ muɔ.› ");
INSERT INTO cmeNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Aa sire ta. «Uŋ kaa tuɔ piɛ cĩiŋgu‑i, tuoŋo fara da-yo, u hujarre gbuu bel-o, u gbar jãrã-yuɔ kã ka gbuu pũrã-yuɔ u fɛrɛŋ nuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Bɛpolŋo gbɛ̃-yo wuɔ: ‹Baba, mi cãlãa Diiloŋo‑i aa tiraa cãl naŋ fɛrɛ‑i, baa tiraa ŋ ta ŋ bĩ-mi ŋ biɛŋ muɔ.› ");
INSERT INTO cmeNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Tuoŋo fara bĩ u maacembiemba‑i a waŋ baa-ba wuɔ: ‹Gbaraaŋ na ka biɛ joŋgoruo maŋ faa yaŋ dũŋgu-na, baa naafontarre, baa naatɛnni na ji dii na hã-yo. ");
INSERT INTO cmeNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Aa iŋ muyaa balyuŋgu maŋ, na kã na ka bel-ku na ji ko-ku i ce ponsaaŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Mi taa mi kãŋ mi biɛŋ daayo‑i baa bikuomba, ŋga mi daa-yo nyuŋgo‑i cicɛ̃lma; uu naa balla, mi daa-yo.› Ponsaaŋgu yaa bi duɔŋ dumaaŋo-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","«A ne da huɔŋgu faŋgu-na, bɛpomɔlŋo waa dii suoŋ-nu. Uŋ juɔ tuɔ jo ji piɛ cĩiŋgu‑i, u nu niimarni du, baa kaasĩŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","U bĩ maacembiloŋo diei a yuu-yo wuɔ: ‹Bige‑i ciɛ cĩiŋgu-na?› ");
INSERT INTO cmeNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","«Maacembiloŋo cira: ‹Ŋ hãaŋo yaa birii jo. Uŋ juɔ hĩnni ŋ to ji da-yo, u huɔŋga gbuu fɛ̃. U ce i bel balyuŋgu maŋ iŋ muyaa-ku ko-ku hã-yo.› ");
INSERT INTO cmeNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Mɔlŋo huɔŋga pãŋ du. U cĩina wuɔ u siɛ suur cĩiŋgu-na. «Ba kã ka tũnu tuoŋo‑i. U hel jo ji tuɔ cãrã-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Naacombiloŋo gbɛ̃-yo wuɔ: ‹Baba, mɛi dii ŋ caaŋgu-na ta mi cãa-ni ku daa bieŋa bɔi. Mi saa yagar ŋ nuŋ-ãndaaŋgu‑i dede. Ŋga yinduɔŋgu ŋ saa ji bel-ku a cira yoloŋo wuɔ: «Hũu ŋ ka ko ŋ wuo baa ŋ jɛ̃naamba‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Aa ŋ biɛŋo maŋ daayo‑i, fuɔ maŋ kãa ka bĩɛna ŋ nagãŋ-niini‑i baa saasorbaa aa bir jo, ŋ ce ba bel balyuŋgu ko hã-yo.› ");
INSERT INTO cmeNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","«Tuoŋo gbɛ̃-yo wuɔ: ‹Nuɔ ŋ dii baa muɔŋo‑i bãaŋgu‑i baa isuɔŋgu‑i, mɛi nagãŋ-niini‑i hai niini‑i? Naŋ niini sĩ wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ŋ hãaŋo‑i, mi taa mi kãŋ-yo baa bikuomba, ŋga mi daa-yo nyuŋgo‑i cicɛ̃lma; uu naa balla, mi daa-yo. Yaŋ aa ŋ kũnna ŋ huɔŋga‑i aa i ce ponsaaŋgu‑i.›» ");
INSERT INTO cmeNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ku huoŋgu-na, Yesu waŋ baa u *hãalãbiemba‑i wuɔ: «Wɛiŋo naŋo waa, kombiyiɛ waa baa-yo. Baa ji tũnu-yuɔ wuɔ kombiyiɛŋ daayo bĩɛna u nagãŋ-niini‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Wuɔ bĩ-yo ji waŋ baa-yo wuɔ: ‹Niŋ ceŋ mamaŋ hiere mi nuɔ-ma. A bãl nyuŋgo, ŋ siɛ tiraa gbãa waa mi kombiyiɛŋ nuɔ. Ce aa ŋ tagaaya niŋ daa kumaŋ ŋ pigãaŋ-mi.› ");
INSERT INTO cmeNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Kombiyiɛŋo tĩɛna tuɔ jɔguɔŋ wuɔ: ‹Mi yuntieŋo wuɔ u nanna-miɛ maacemma-na. Duɔ nanna-miɛ, mi ka ce niɛ? Mi siɛ bi gbãa kũ, aa da miɛ mi ta mi wuɔra mi cãrã, senserre ka ta di da-mi.› ");
INSERT INTO cmeNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Aa ji cira: ‹Ãhãa! Mi suyaa miŋ ka ce kumaŋ da ba nanna-miɛ nuɔmba baa bi nanna-miɛ.› ");
INSERT INTO cmeNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","U yuntieŋo cɛ̃miɛŋaŋ waa bamaŋ nuɔ‑i hiere, u tuɔ bĩ-ba ba da-ba-diei ba ta ba jo. Dĩɛlã-wuoŋo juɔ, u yuu-yo wuɔ: ‹Ŋ saaya ŋ pã niɛ hã mi yuntieŋo‑i?› ");
INSERT INTO cmeNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","«U cira: ‹Mi saaya mi pã namma gboŋgboyufieŋ komuɔŋa ndii.› «Kombiyiɛŋo waŋ baa-yo wuɔ: ‹Ŋ cɛ̃mɛlleŋ nyɛgãaŋ sɛbɛ maŋ nuɔ‑i, u yaa daayo. Tĩɛna donduo ŋ nyɛgɛ̃ŋ gboŋgboyufieŋ komuɔŋa hãi baa cĩncieluo.› ");
INSERT INTO cmeNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Aa bĩ unaŋo jo. Uŋ juɔ, u yuu ufaŋo‑i wuɔ: ‹Nuɔ ŋ saaya ŋ pã niɛ?› «U cira: ‹Mi saaya mi pã dĩmma buɔrbaa komuɔŋa ndii.› «Kombiyiɛŋo waŋ baa-yo wuɔ: ‹Ŋ cɛ̃mɛlleŋ nyɛgãaŋ sɛbɛ maŋ nuɔ‑i, u yaa daayo. Nyɛgɛ̃ŋ buɔrbaa komuɔŋa naa.› ");
INSERT INTO cmeNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Uŋ ciɛ baa u yuntieŋo cɛ̃miɛntaamba‑i cemma maŋ daama‑i, u yuntieŋ uŋ juɔ nu-ma, u gbɛliɛŋ-yo wuɔ u cɛ̃ u cor.» Yesu wuɔ cira: «Na saa da, bamaŋ sa wuɔyaaŋ Diiloŋ-hũmelle‑i ba suɔ ba suuye ba-naa ba yaŋ bamaŋ wuɔyaaŋ-deŋ. ");
INSERT INTO cmeNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Mi tũnu-nɛi, nɛliɛ sa ji ku aa ba dii-yo baa u gbeiŋa‑i. Terieŋgu faŋgu-na, gbeiŋa maŋ dii baa-na hĩɛma-na bande‑i-na, ciɛŋ-yaŋ na bel jɛ̃naamba baa-ya, ku yaa da na saa ji waa yiiŋgu maŋ nuɔ‑i, ba hã-na muntĩɛnammu Diiloŋo caaŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Umaŋ duɔ suɔ bĩŋkũcɛkũɔma belma, kutieŋo ka suɔ bĩŋkũbuɔ belma. Umaŋ duɔ cãl bĩŋkũcɛkũɔma belma, kutieŋo ka cãl bĩŋkũbuɔ belma. ");
INSERT INTO cmeNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Da na cãl miwaaŋ daayo gbeiŋa belma, hai ka siɛ hã namaa ninsoŋ-bĩŋkũŋgu na tiera? ");
INSERT INTO cmeNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Da ŋ cãl moloŋ bĩŋkũŋgu belma, Diiloŋ uŋ ŋa na'a u hã nuɔ kumaŋ, u ka ce niɛ aa hã-ni baa-ku? ");
INSERT INTO cmeNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Na suyaa wuɔ maacembiloŋo diei siɛ gbãa cãa nuɔmba hãi. Ŋ ka da u bigãaŋ u diei aa dɔl u diei, u ka waa baa u diei aa cĩina u diei. Ku yaa ŋaa namaa kũŋgu‑i, na siɛ gbãa ta na kuye Diiloŋo‑i aa bi ta na kuye gbeiŋa‑i terduɔŋgu faŋgu-na.» ");
INSERT INTO cmeNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Gbeiŋa taa a dɔlnu *Farisĩɛbaa-ba‑i a cor. Yesuŋ waaŋ nel daama‑i, baa bir yaŋ aa ta ba nyɛ-yo. ");
INSERT INTO cmeNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Wuɔ waŋ baa-ba wuɔ: «Namaaŋo‑i, da na da nuɔmba‑i na ce na fɛrɛ nelviiŋ namaa, ŋga Diiloŋo suɔ na hɔmmu‑i. Nelbiliembaŋ kaal kumaŋ, Diilo sa hiel u yufelle kuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Yiinaa‑i-na, nuɔmba taa ba nu *Moisi ãnjĩnamma yaa‑i baa *Diilopɔpuɔrbiemba nelma‑i aa ta ba ce ba wɛima‑i. Ba ciɛ kufaŋgu‑i a ji hi Nsãa bãaŋgu‑i. A doŋ Nsãa bãaŋgu-na, ba duɔŋ ta ba nu *Diiloŋ-nelle maama‑i. A ce dumaaŋo-na, nuɔmba‑i hiere ba gbãŋ kpelle da ba suur-diɛ. ");
INSERT INTO cmeNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","«Dɔrɔ‑i baa hĩɛma‑i ni gbuonumma dii fɛ̃u yaŋ ãnjĩnamma nelbelle diei gbuonumma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","«Na saa da; umaŋ duɔ nanna u ciɛŋo‑i aa jã unaŋo, kutieŋo ciɛ *fuocesĩnni‑i dumaaŋo-na; aa da ba nanna ciɛŋo maŋ aa ŋ biɛ-yo, ŋ bi ciɛ fuocesĩnni‑i dumaaŋo-na.» ");
INSERT INTO cmeNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","«Wɛiŋo naŋo waa tuɔ gbu u diiya u fɛrɛ. U taa u ce u bãaŋgu‑i aa bi tuɔ wuo niiwuofafanni yaa yinni maŋ joŋ. ");
INSERT INTO cmeNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","A ne da sũntieŋo naŋo waa tuɔ galla u dumɛlle yaaŋga-na, ba taa ba bĩ-yo Lasaar. Pãnni'i naa gbuyaa u kũɔma‑i hiere. ");
INSERT INTO cmeNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Wɛiŋ duɔ wuo aa juuru maŋ diire hĩɛma-na, Lasaar tuɔ nenu-duɔ, ŋga u siɛ bi da-du. Juoraamba tiraa waa hie ta ba nallã u pãnni‑i? ");
INSERT INTO cmeNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Uŋ juɔ ku, *dɔrpɔpuɔrbiemba biɛ-yo kã baa-yo *Abiramu caaŋ-nu dii ninsoŋ-nelle-na. Ku huoŋgu-na, wɛiŋo bi ji ku, ba fuure-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","U kã ka tuɔ gbu u ce sũlma‑i dãamu-na. U juɔ ciir u yuŋgu‑i ku yaa nuɔ‑i, a fara da Lasaar dii Abiramu caaŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","U fara tuɔ piiye da gbagaga wuɔ: ‹Abiramu, mi to nuɔ, mi mulĩɛŋ mi cor dãaŋ daamu-na, jande, ce hujarre miɛ aa ŋ puɔr Lasaar ka dii u niele‑i hũmma-na a ji dii mi nuŋgu-na mi nuhɔlle fɛ̃rɛ̃.› ");
INSERT INTO cmeNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","«Abiramu gbɛ̃-yo wuɔ: ‹Mi biɛ, ma sĩ ŋ suyaa wuɔ niŋ waa miwaaŋo-na, ŋ waa ŋ fɛrɛŋ nuɔ aa Lasaar waa sũlma-na kɛ? Fiɛfiɛ‑i-na, uu dii fiisaaŋ-nu bande‑i-na aa nuɔ ŋ cɛr waa sũlma-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Da mi fiɛ hũu-ma, fobãmbãale dii i hɔlma-na. Molo siɛ gbãa hel bande‑i-na a karnu kã namaa terieŋgu-na, aa molo siɛ bi gbãa hel namaa terieŋgu-na a karnu jo bande‑i-na.› ");
INSERT INTO cmeNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","«Wɛiŋo gbɛ̃-yo wuɔ: ‹Da ma waa dumaaŋo-na, yaŋ aa ŋ puɔr-o miɛ cĩiŋgu-na ");
INSERT INTO cmeNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","u ka piiye tũnu mi hãmba‑i, baa dii ba ndii; ba baa ji jo yaahuol-terieŋ daaku-na.› ");
INSERT INTO cmeNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","«Abiramu gbɛ̃-yo wuɔ: ‹*Moisi nelma dii baa-ba, a naara *Diilopɔpuɔrbiemba maama‑i, mafamma ka saanu baa-ba.› ");
INSERT INTO cmeNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","«Wɛiŋo cira: ‹Abiramu, mi to nuɔ, mafamma siɛ gbɛ̃ baa-ba. Ŋga moloŋ duɔ hel kuoŋ-nelle-na a ka piiye baa-ba, ŋ ka da ba naana ba cilɔbabalaŋo‑i.› ");
INSERT INTO cmeNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","«Abiramu gbɛ̃-yo wuɔ: ‹Da ba'a ba sa nu Moisi nelma‑i baa Diilopɔpuɔrbiemba maama‑i, molo duɔ fiɛ hel kuoŋ-nelle-na kã, u kãa gbãŋgbãŋ.›» ");
INSERT INTO cmeNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ku huoŋgu-na, Yesu wuɔ waŋ baa u *hãalãbiemba‑i wuɔ: «Nuɔmba siɛ gbãa naa kuubabalaaŋgu muncemmu‑i, ŋga umaŋ duɔ dii u nanolŋo‑i kuubabalaaŋgu cemma-na, sũlma haraa kutieŋo-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Kumaŋ ka haa-yuɔ, kuɔ baa naa to namɛlle u nuoŋgu-na aa sɛ-yo dii-yo nuoraaŋ-nu kuu naa ce bɔlbɔl yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Terieŋgu faŋgu-na, bilaaŋ na fɛrɛ. «Ŋ natobiŋ duɔ cãl-ni, ŋ piiye baa-yo da yambaa. Duɔ siɛ u cãlmuɔ‑i, ŋ yaŋ ma tĩ. ");
INSERT INTO cmeNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Duɔ fiɛ cãl-ni ku yu niehãi yinduɔŋgu-na aa tuɔ suɔ-ma u jo u cãrã-niɛ, baa gãŋ baa-yo.» ");
INSERT INTO cmeNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Yesu *pɔpuɔrbieŋ baa waŋ baa-yo wuɔ: «Itie, iŋ haa i naŋga‑i niɛ dumaa, kãyã-yiɛ kunaŋgu naara-kuɔ.» ");
INSERT INTO cmeNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Yesu wuɔ gbɛ̃-ba wuɔ: «Halle da ku fiɛ waa na haa na niele'i miɛ yoŋ, na gbãa gbɛ̃ tibiiŋ daaku‑i wuɔ ku fuur ka sũ ku fɛrɛ nuoraaŋgu-na, aa ma bi ce.» ");
INSERT INTO cmeNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Aa naa cira: «Namaaŋo-na, umaŋ duɔ biɛ maacembiloŋo jĩna u suoŋgu-na, sisɔ u biyaa-yo u tuɔ ceŋ u muɔru, duɔ hel hĩɛŋgu-na jo, kutieŋo ka gbɛ̃-yo wuɔ u tĩɛna donduo wuo niiwuoni‑i wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ma sĩ u bir gbɛ̃-yo wuɔ: ‹Ce mɛi niiwuoni‑i aa ŋ hor ŋ niidiini‑i aa ŋ biɛ ŋ hã mi wuo igɛ̃na. Da mi wuo tĩ, nuɔ ŋ ka suɔ wuo.› Ma sa ce dumɛi wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Maacembiloŋ duɔ ce u maacemma‑i, ku saaya ba jaal-o tĩiŋgu wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ku yaa ŋaa namaa kũŋgu‑i. Baŋ hãa-na mamaŋ, da na ce-ma, na saaya na cira: ‹Miɛŋo‑i maacembieŋ miɛ yoŋ, i ciɛ i maacemma.›» ");
INSERT INTO cmeNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesuŋ taa u kã *Yerusalɛmu‑i-na, u bilaaya *Galile‑i baa *Samari‑i cor. ");
INSERT INTO cmeNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","U kaa tuɔ suur nelle nande-na, *wontuɔrmba namba sire ta ba jãrã-yuɔ. Ba waa wontuɔrmba cĩncieluo. Baŋ juɔ piɛ, baa yiɛra aa naa ta ba fara ba piiye baa-yo wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","«Hãalãtie, jande, ce hujarre yiɛ.» ");
INSERT INTO cmeNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yesu wuɔ fara waŋ baa-ba wuɔ: «Kãaŋ *Diilojigãntaamba ka ne-na.» Baa ta ta ba kã. Baŋ kãŋ hũmelle-na, ba jarŋ maa ta-bɛi. ");
INSERT INTO cmeNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Unaŋ wuɔ bir tuɔ gbɛliɛŋ Diiloŋo‑i da gbagaga u jo. ");
INSERT INTO cmeNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Uŋ juɔ hi Yesu caaŋgu-na, wuɔ dũuna jaal-o. A ne da u waa *niɛryiɛŋo; u taa u hel Samari. ");
INSERT INTO cmeNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesu wuɔ cira: «Ba siire cĩncieluo‑i-na hiere, ŋga nennaa baamba curaa hie? ");
INSERT INTO cmeNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Bige‑i ciɛ ba saa suɔ-ma bir jo ji jaal Diiloŋo‑i ŋaa niɛryiɛŋ daa uŋ birii ji jaal-o dumaa?» ");
INSERT INTO cmeNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Aa naa gbɛ̃ naacolŋo‑i wuɔ: «Sire ŋ kã! Niŋ haa ŋ naŋga‑i miɛ ŋ kuraa.» ");
INSERT INTO cmeNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Yiiŋgu naŋgu-na, *Farisĩɛbaa-ba yuu Yesu‑i wuɔ: «*Diiloŋ-bãaŋgu ka doŋ yaku‑i?» Yesu wuɔ cira: «Diiloŋ-bãaŋgu sa ji doŋ domma naŋ temma ba da-ku baa ba yufelle, ");
INSERT INTO cmeNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","aa cira: ‹Ku yaa bande ku yaŋga; ku yaa dɛ ku yaŋga.› Na saaya na suɔ wuɔ Diiloŋ-bãaŋgu duɔŋ tĩ na hɔlma-na.» ");
INSERT INTO cmeNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Aa naa waŋ baa *hãalãbiemba‑i wuɔ: «Yiiŋgu dii baa yiiŋgu, *Moloŋ-Biɛŋo kũɔma kaa bel-na, ŋga na siɛ da-yo halle yinduɔŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Nuɔmba kaa ta ba tãal-na wuɔ ba daa-yo yaŋga naŋga. Banamba ka gbɛ̃-na wuɔ: ‹Uu dii daalɛi›, banaŋ ba'a: ‹Uu dii terieŋ daaku-na.› Da ba pigãaŋ-na terieŋgu maŋ, baa na kã; ba tãal-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Diiloŋ uŋ nyiɛsĩŋ dumaa ba da-yo terni-na hiere, Moloŋ-Biɛŋ duɔ u bir jo, ba ka da-yo dumɛi terni-na hiere. Molo si dii duɔ ji pigãaŋ moloŋo baa-yo. ");
INSERT INTO cmeNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ŋga, aa mafamma suɔ da ma ce, fiɛfiɛ ku nuɔmba ka cĩina-yuɔ aa ce-yo sũlma. ");
INSERT INTO cmeNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","«Mamaŋ taa ma ce *Nowe bãaŋgu-na, Moloŋ-Biɛŋ duɔ u bir jo, ma temma ka ce. ");
INSERT INTO cmeNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Nowe bãaŋgu-na, nuɔmba naa gonya niiwuoni baa kolma baa cɛjãlle. Ba tĩyãa ku yaa nuɔ‑i a ji hi yiiŋgu maŋ Noweŋ suurii begubuɔ‑i-na aa yaŋ diilopepetieŋo dãa hɔr-ba hiere. ");
INSERT INTO cmeNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Mamaŋ taa ma bi ce Lɔti bãaŋgu-na, ma temma ka ce. Lɔti bãaŋgu-na, nuɔŋ baa bi guɔnya wuolalle baa nyɔlle, suoruŋgu baa sãamuŋgu, kũlle baa jaaguɔ. ");
INSERT INTO cmeNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ŋga yiiŋgu maŋ Lɔtiŋ hilaa Sodɔmu‑i-na, Diiloŋ wuɔ kũnna dãŋgbɔguɔŋgu naŋ temma a kukul nuɔmba‑i hiere. ");
INSERT INTO cmeNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Moloŋ-Biɛŋ duɔ u bir jo, ma temma ka ce. ");
INSERT INTO cmeNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Duɔ jo yiiŋgu maŋ nuɔ‑i, umaŋ duɔ ji waa gɔ̃ŋgũɔŋ-nu, u baa cira u suur dũŋ-nu a biɛra u bĩmbĩnni‑i; umaŋ duɔ bi waa hĩɛŋ-nu, u baa bi cira u bir kũŋ. ");
INSERT INTO cmeNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Mamaŋ daa Lɔti ciɛŋo‑i ma sĩ ma tĩyãanu-nɛi kɛ? ");
INSERT INTO cmeNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Umaŋ duɔ tuɔ kaal baa u yuŋgu yoŋ, kutieŋo ka kɔsuɔŋ u fɛrɛ; ŋga umaŋ duɔ tuɔ kɔsuɔŋ u fɛrɛ, kutieŋo ka kor u fɛrɛ. ");
INSERT INTO cmeNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Mi tũnu-nɛi, yiiŋgu faŋgu-na, nuɔmba hãi gbãa waa galla muŋgalladuɔmu-na, ba biɛ u diei ta aa yaŋ unaŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Caamba hãi gbãa waa ta ba sɔrɔŋ, ba biɛ u diei ta aa yaŋ unaŋo‑i.  ");
INSERT INTO cmeNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Nuɔmba hãi gbãa waa ta ba guona, ba biɛ u diei ta aa yaŋ unaŋo‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Hãalãbieŋ baa yuu-yo wuɔ: «Itie, mafamma ka ce hie-na?» Wuɔ gbɛ̃-ba wuɔ: «Bĩŋkũkuliiŋ da ku waa kusuɔŋ-nu, kpaalbaa-ba tigiiŋ kusuɔŋ-nu'i.» ");
INSERT INTO cmeNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ku huoŋgu-na, Yesu wuɔ naŋ gbãnalãaŋ daaku‑i baa u *hãalãbiemba‑i duɔ pigãaŋ-ba wuɔ ba saaya ba ta ba cãrã Diiloŋo‑i yinni maŋ joŋ; ba baa yaŋ ba kũɔma seŋ. U gbĩɛ-ba wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","«Gɛ̃ŋgɛrtieŋo naŋo waa nelle nande-na, u saa tuɔ kãalã Diiloŋo‑i aa u saa bi tuɔ kãŋ moloŋo. ");
INSERT INTO cmeNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","A ne da, bikulciɛŋo naŋo bi waa nelle fande-na. Bikulciɛŋ daayo ji da wɛima baa moloŋo naŋo; u kã ka bĩ kutieŋo‑i gɛ̃ŋgɛrtieŋo wulaa. ");
INSERT INTO cmeNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Duɔ kã, gɛ̃ŋgɛrtieŋo siɛ ne u yaaŋ-na. Ciɛŋo siɛ bi bir. Yiiŋgu naŋgu-na, gɛ̃ŋgɛrtieŋo ji cira: ‹Mi suyaa miɛ mi sa kãalã Diiloŋo‑i aa mi sa bi kãŋ nɛliɛŋo. ");
INSERT INTO cmeNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Ŋga ciɛŋ daa uŋ jo u mulĩɛŋ-mi yinni maŋ joŋ dumandɛ‑i-na, mi ka ce ba ãndaaŋgu‑i aa gbuu da fiisa; ni ma'i sĩ u ka tuɔ jo u huol mi yaaŋ-na.›» ");
INSERT INTO cmeNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Yesu wuɔ cira: «Na nuɔ gɛŋgɛrtiebabalaŋ daa uŋ waaŋ mamaŋ kɛ? ");
INSERT INTO cmeNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Aa Diiloŋo maŋ Diiloŋo, ku ce niɛ aa u yufelleŋ hilaa bamaŋ nuɔ‑i, da ba ta ba cãrã-yuɔ bãaŋgu‑i baa isuɔŋgu‑i u siɛ ne ba yaaŋ-na? ");
INSERT INTO cmeNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Mi tũnu-nɛi: U siɛ dure aa ce-ma. *Moloŋ-Biɛŋ duɔ ka bir jo, u ka jo ji da nuɔmba haa ba naŋga yuɔ wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Nuɔmba namba taa ba ne ba fɛrɛ wuɔ ba vii, a ce dumaaŋo-na, ba taa ba ne wuɔ ba bɔyaa banamba‑na. Yesu wuɔ naŋ gbãnalãaŋ daaku‑i hã-ba wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","«*Farisĩɛyiɛŋo naŋo‑i baa *nampohũutieŋo naŋo‑i ba kãa *Diilodubuɔ‑i-na da ba ka cãrã Diiloŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farisĩɛyiɛŋ wuɔ sire yiɛra aa naa cira: ‹Diilo, mi jaal-ni. Mi jaal-ni hama‑i nuɔ‑i? Mi sa ce kuubabalaaŋgu ŋaa banambaŋ ceŋ dumaa: Mi sa cuo, mi huɔŋga saa balaŋ baa nɛliɛŋo, mi sa wuɔra mi ce caamba. Mii si dii ŋaa nampohũutieŋo maŋ yiɛraaya duɔlɛi u temma. ");
INSERT INTO cmeNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Mi dii sũŋgu‑i i hãi saahɔlma-na, aa da mi da bĩŋkũŋgu bĩŋkũŋgu, mi hiel ŋ *yufelle‑i hã-ni.› ");
INSERT INTO cmeNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","«Nampohũutieŋ wuɔ yiɛra dii huoŋ-nu, u saa siɛ duɔ ciir u yaaŋga‑i, aa tuɔ muo u pãmpĩnaŋga‑i aa cira: ‹Diilo, mi suyaa miɛ mi ciluɔ saa fa, jande, baa gãŋ baa-mi.›» ");
INSERT INTO cmeNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yesu wuɔ waŋ baa nuɔmba‑i wuɔ: «Yaaŋ mi tũnu-nɛi, balaŋ daaba‑i ba hãi‑i-na, aa ba suɔ da ba bir kũŋ, Diiloŋo hurii nampohũutieŋo ãmbabalma‑i aa yaŋ Farisĩɛyiɛŋo maama‑i. Na saa da, umaŋ duɔ tuɔ tɛtɛŋ u fɛrɛ, ba ka hiire-yuɔ; ŋga umaŋ duɔ tuɔ hiire u fɛrɛ, ba ka tɛtɛŋ-yo.» ");
INSERT INTO cmeNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ku huoŋgu-na, baa jo baa tontobaa-ba namba Yesu wulaa wuɔ u ji haa u nammu‑i bɛi a cãrã Diiloŋo‑i hã-ba. U *hãalãbiembaŋ daa mafamma‑i, baa sire ta ba nuola bamaŋ juɔ baa-ba. ");
INSERT INTO cmeNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Yesu wuɔ cira: «Yaaŋ bisãlmba jo mi wulaa, baa na cie-ba». Baŋ juɔ, wuɔ cira: «Bamaŋ dii bafamba temma‑i, *Diiloŋ-nelle dii bafamba diele. ");
INSERT INTO cmeNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Yaaŋ mi waŋ ninsoŋo‑i baa-na: Umaŋ duɔ saa siɛ *Diiloŋ-nellentesĩnni‑i ŋaa bisãlãaŋo, kutieŋo siɛ gbãa suur *Diiloŋ-nelle-na.» ");
INSERT INTO cmeNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","*Yuifu ba yuntieŋo naŋ wuɔ yuu Yesu‑i wuɔ: «Hãalãtiefɛfɛi, da mi ta mi taara mi da cicɛ̃lma maŋ sa tĩɛŋ dede‑i, mi saaya mi ce bige‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesu wuɔ cira: «Bige‑i ciɛ ŋ ta ŋ bĩ-mi nelfɛfɛiŋ muɔ? Da ma hel Diiloŋo-na, nelfɛfɛiŋo dii wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Diiloŋ uŋ'a i tiɛ wuɔ hũmieŋa maŋ, ma sĩ ŋ suɔ-ya kɛ? Ta ŋ wuɔ a yaa‑i: ‹Baa ce *fuocesĩnni, baa ko nɛliɛŋo, baa cuo, baa kar coima ŋ haa moloŋ-na, aa ta ŋ dii ŋ to‑i baa ŋ nyu‑i ba nuŋgu‑i.›» ");
INSERT INTO cmeNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Naacolŋ wuɔ bir waŋ baa Yesu‑i wuɔ: «Mi duɔŋ dii mi bisãnsĩnniŋ ta mi ce mafamma‑i hiere.» ");
INSERT INTO cmeNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Uŋ piiye dumaaŋo-na, Yesu wuɔ cira: «Ma tĩyãa ma diei: Suor ŋ nagãŋ-niini‑i hiere aa ŋ cal gbeiŋa faŋa‑i ŋ hã sũntaamba baa-ya, ku yaa ŋ ka ce wɛiŋ nuɔ dɔrɔ‑i-na. Da ŋ ce mafamma‑i, ŋ jo ŋ ji ta ŋ nyaanu-miɛ.» ");
INSERT INTO cmeNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Naacolŋ daayo naa silaa waa wɛiŋo cor. Yesuŋ juɔ waŋ mafamma‑i, wuɔ gbuu pãŋ vãa u yaaŋga‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu wuɔ cira: «Kumaŋ ka ce wɛiŋo duɔ gbãa suur *Diiloŋ-nelle-na kuu dii kpelle. ");
INSERT INTO cmeNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Na saa da, kumaŋ ka ce nyɔgɔ̃mɛ duɔ gbãa cor misɛ̃nɛ fuoŋgu-na kuu dii kpelle dɛ! Ŋga kumaŋ ka ce wɛiŋo duɔ gbãa suur *Diiloŋ-nelle-na, kufaŋgu dii kpelle yaŋ.» ");
INSERT INTO cmeNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Nuɔŋ baa yuu-yo wuɔ: «Dumaaŋo-na, hai moloŋo‑i ka gbãa da Diiloŋo‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesu wuɔ cira: «Mamaŋ da ma yar nuɔmba‑i cemma, ma siɛ gbãa yar Diiloŋo‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Piɛr wuɔ cira: «Itie, aa miɛ maŋ yaaŋ i nagãŋ-niini‑i hiere aa tiɛ nyaanu-niɛ, i ka da bige‑i kuɔ?» ");
INSERT INTO cmeNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesu wuɔ waŋ baa-ba wuɔ: «Yaaŋ mi waŋ ninsoŋo‑i baa-na: Umaŋ duɔ ta aa yaŋ u dumɛlle‑i, u ciɛŋo‑i, u hãmba‑i, u bĩncuɔmba‑i, u bisãlmba‑i Diiloŋ-maama-na, ");
INSERT INTO cmeNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","kutieŋ uŋ ka da kumaŋ hĩɛma-na bande‑i-na, ku ka maar uŋ taa aa yaŋ kumaŋ. Aa u ka da cicɛ̃lma maŋ sa tĩɛŋ dede‑i bisĩnuɔ‑i-na.» ");
INSERT INTO cmeNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ku huoŋgu-na, Yesu wuɔ bĩ u *hãalãbieŋ cĩncieluo ba hãi baamba‑i ba deŋ, a waŋ baa-ba wuɔ: «Na daa iŋ kãŋ *Yerusalɛmu‑i-na kɛ? *Diilopɔpuɔrbiembaŋ nyɛgãaŋ mamaŋ *Moloŋ-Biɛŋo maama-na, ma ka ce kusuɔŋ-nu'i. ");
INSERT INTO cmeNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ba ka bel-o hã *niɛraamba‑i baa-yo ba nyɛ-yo sũlma, aa tuora-yuɔ, aa tu taalni yuɔ, ");
INSERT INTO cmeNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","aa muo-yo, aa ko-yo. Ŋga da ba ko-yo, u ka ce yinni hãi hĩɛma-na, siɛliŋ-yiiŋgu-na, u ka sire hel jo.» ");
INSERT INTO cmeNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Hãalãbiemba saa suɔ u nelma yaaŋga‑i, ma yuŋgu naa fuo-bɛi, a ce dumaaŋo-na, ba saa suɔ uŋ taaraŋ u waŋ mamaŋ baa-ba. ");
INSERT INTO cmeNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesuŋ kaa tuɔ piɛ Yeriko‑i, yiroŋo naŋo waa tĩɛna hũmelle tũŋgu-na tuɔ cãrã. ");
INSERT INTO cmeNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Uŋ juɔ nu nuɔmba ce ijieni‑i ba cor, wuɔ yuu wuɔ: «Bige‑i ciɛ?» ");
INSERT INTO cmeNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Baa cira: «Ma sĩ Nasarɛtitaaŋ Yesu'i curaaŋ.» ");
INSERT INTO cmeNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Wuɔ pãŋ tuɔ fara u piiye da gbagaga wuɔ: «Yesu, *Davidi hãayɛ̃lŋ nuɔ, jande, ce hujarre miɛ!» ");
INSERT INTO cmeNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Bamaŋ naa taa yaaŋga-na, baa ta ba nuola-yuɔ wuɔ u suuye u nuŋgu‑i. Wuɔ migãaŋ tuɔ kaasĩŋ u naara wuɔ: «Davidi hãayɛ̃lŋ nuɔ, jande, ce hujarre miɛ!» ");
INSERT INTO cmeNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesuŋ juɔ saanu baa-yo, wuɔ yiɛra aa naa ce ba jo baa-yo. Baŋ juɔ baa-yo, wuɔ yuu-yo wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«Ŋ taara mi ce bige‑i hã-ni?» Naacolŋ wuɔ cira: «Itie, mi taara ŋ puur mi yufieŋa‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesu wuɔ cira: «Puur ŋ yufieŋa‑i! Niŋ haa ŋ naŋga‑i miɛ ŋ kuraa.» ");
INSERT INTO cmeNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","U yufieŋ aa bi pãŋ puur terduɔŋgu faŋgu-na, wuɔ cu Yesu huoŋ-nu tuɔ gbɛliɛŋ Diiloŋo‑i u kã. Nuɔmbaŋ daa mafamma‑i, ba hieroŋo‑i baa bi kã ba ta ba gbɛliɛŋ Diiloŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesuŋ suurii Yeriko‑i-na tuɔ karnu duɔ cor, ");
INSERT INTO cmeNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","*nampohũutaamba yuntieŋo naŋo waa nelle fande-na, ba taa ba bĩ-yo Sase. Sase waa bĩŋkũntieŋo. ");
INSERT INTO cmeNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Yesuŋ kãa, Sase wuɔ tuɔ taara u da-yo suɔ-yo; a ne da u waa beterie. Nuɔmbaŋ yuu dumaaŋo-na, u saa gbãa duɔ hi da Yesu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Wuɔ gbar ta u yaaŋ-na ka nyugũŋ tibiiŋ-nu wuɔ duɔ ji tuɔ cor fuɔ da-yo. ");
INSERT INTO cmeNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yesuŋ juɔ hi terieŋgu faŋgu‑i, wuɔ ciir u yuŋgu‑i a waŋ baa-yo wuɔ: «Sase, hiire i ta, mi saaya mi har nuɔnɛi nuɔ‑i nyuŋgo‑i-na.» ");
INSERT INTO cmeNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sase huɔŋ kaa pãŋ fɛ̃, wuɔ hiire da donduo kũŋ baa-yo. ");
INSERT INTO cmeNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Nuɔmba daa mafamma‑i ce bige‑i? Baa ta ba waana wuɔ Yesu ciɛ niɛ jo ji har nelbabalaŋ daayo temma wulaa? ");
INSERT INTO cmeNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Sase wuɔ sire yiɛra Yesu yaaŋga-na aa naa cira: «Itie, ne, mi ka calnu mi nagãŋ-niini‑i sɔmma hãi, a hã sũntaamba‑i sɔmma diei aa muɔmi ce sɔmma diei-maama namma‑i. Miŋ duu bamaŋ a hũu ba gbeiŋa‑i, mi ka hã-ba a temma sɔmma naa.» ");
INSERT INTO cmeNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesu wuɔ cira: «Naacolŋ daa uŋ bi yeŋ *Abiramu hãayɛ̃lŋo, koŋkoro suurii u dumɛlle-na nyuŋgo‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","*Moloŋ-Biɛŋo juɔ duɔ ji taara bamaŋ baala a kor-ba.» ");
INSERT INTO cmeNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Baŋ kaa ta ba piɛ *Yerusalɛmu‑i, nuɔŋ baa da niɛ sĩ *Diiloŋ-bãaŋgu ka pãŋ doŋ huɔŋgu faŋgu'i nuɔ‑i. Yesu wuɔ suɔ baa-ba. A ne da huɔŋgu faŋgu-na, u waa tuɔ piiye baa-ba. ");
INSERT INTO cmeNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Wuɔ naŋ gbãnalãaŋ daaku‑i baa-ba wuɔ: «Nelbuɔ naŋo kãa nemaale ba da ba ka hã-yo nellentesĩnni u duɔ ji tĩɛna u nelle-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Uŋ'a u ta, u bĩ u maacembiemba cĩncieluo a ji cal gbeiŋa hã-ba, aa waŋ baa-ba wuɔ: ‹Taa na torgoŋ baa gbeiŋ daaya‑i, mi kã aa jo.› ");
INSERT INTO cmeNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","A ne da u nelleŋ-baamba naa bigãaŋ-yo. Uŋ taa, ba sire puɔr nuɔmba u huoŋ-nu dii ku yuŋ-terieŋgu-na wuɔ ba ka waŋ baa-ba wuɔ ba sa taara naacolŋ daayo nellentesĩnni‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","«Naacolŋ uŋ kaa da nellentesĩnni‑i aa bir jo, u ce ba bĩ u maacembiemba maŋ uŋ ŋa naa cal gbeiŋa‑i hã-ba wuɔ ba ta ba torgoŋ, duɔ ji ne baŋ daa kumaŋ. ");
INSERT INTO cmeNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Dĩɛlã-wuoŋo jo ji cira: ‹Yuntie, mi bibiriiye mi naŋga‑i baa niŋ hãa-mi gbeiŋa maŋ, a da gbeinyuŋo temma sɔmma cĩncieluo.› ");
INSERT INTO cmeNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","«Nellentieŋo cira: ‹Ku faa, maacembilofɛfɛiŋ nuɔ; niŋ suyaa cɛllɛ-kũŋ daaku belma, mi ka haa-ni nilɛiŋa cĩnciel yuŋ-nu.› ");
INSERT INTO cmeNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","«Hãalĩŋ-wuoŋo jo ji cira: ‹Yuntie, mi bibiriiye mi naŋga‑i baa niŋ hãa-mi gbeiŋa maŋ, a da gbeinyuŋo temma sɔmma ndii.› ");
INSERT INTO cmeNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","«Nellentieŋo gbɛ̃-yo wuɔ: ‹Mi ka bi haa nuɔŋo‑i nilɛiŋa ndii yuŋ-nu.› ");
INSERT INTO cmeNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","«Siɛliŋ-wuoŋ wuɔ jo ji cira: ‹Yuntie, ŋ gbeiŋa yaa daaya, mii naa fĩnya-yiɛ baa fɔtɔruɔ jĩna kɔtuɔŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Naŋ huɔŋga doŋ ka cor a ce mɛi sa hĩrã-niɛ, ku'i ciɛ mi fĩnya-yiɛ jĩna kɔtuɔŋgu. Da ŋ saa jĩna kumaŋ, ŋ biɛ ku yaa‑i; aa da ŋ saa duu kumaŋ, ŋ kar ku yaa‑i.› ");
INSERT INTO cmeNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","«Nellentieŋo gbɛ̃-yo wuɔ: ‹Maacembilobabalaŋ nuɔ naŋ temma‑i daani‑i, ŋ piiye bel ŋ fɛrɛ. Niŋ suyaa wuɔ mi huɔŋga doŋ, aa da mi saa jĩna kumaŋ mi biɛ ku yaa‑i, da mi saa duu kumaŋ mi kar ku yaa‑i; ");
INSERT INTO cmeNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","bige‑i ciɛ ŋ saa kã ka jĩna mi gbeiŋa‑i gbeiŋ-dũŋ-nu? Miŋ juɔ dɛ‑i-na, mii naa saa jo ji da a huonaana mi hũu-ya wɛi?› ");
INSERT INTO cmeNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Nuɔmba waa u caaŋgu-na, u waŋ baa-ba wuɔ: ‹Hũyãaŋ u gbeiŋa‑i na hã umaŋ daa gbeinyuŋo‑i sɔmma cĩncieluo‑i.› ");
INSERT INTO cmeNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","«Ba cira: ‹Yuntie, ma sĩ fuɔ daa gbeinyuŋo temma sɔmma cĩncieluo kɛ!› ");
INSERT INTO cmeNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","«U cira: ‹Yaaŋ mi tũnu-nɛi, umaŋ duɔ da, kunaŋgu ka naara u kũŋgu‑i, ŋga umaŋ duɔ saa da, cɛllɛ-kũŋgu maŋ dii, ku hũu.› ");
INSERT INTO cmeNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Uŋ waaŋ mafamma‑i, u cira: ‹Mi bigãarãamba maŋ saa ta ba taara mi waa ba yuŋgu-na, bilaaŋ-baŋ na jo baa-ba bande, na ji ko-ba mi yufelleŋ.›» ");
INSERT INTO cmeNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesuŋ juɔ piiye tĩ, wuɔ ta nuɔmba yaaŋ-na ba ta ba kã Yerusalɛmu‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Yesubaa-baŋ kaa ta ba piɛ Betani‑i baa Betifage‑i dii *Olivi-tibinni-tãnuŋgu caaŋgu-na, Yesu wuɔ waŋ baa u *hãalãbiemba hãi wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","«Kãaŋ nelle maŋ i yaaŋga-na daade‑i, na suurma-na, na ka da ba vaa kakũmbiloŋo naŋo, molo saa nyugũŋ-yuɔ dede. Na fir-o na jo baa-yo. ");
INSERT INTO cmeNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Umaŋ duɔ yuu-na, na cira Itieŋo yaa ciɛra na fir-o ka hã-yo.» ");
INSERT INTO cmeNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Uŋ puɔraa bamaŋ, baa kã ka bi da kakũmbiloŋo‑i ŋaa uŋ waaŋ-ma dumaa. ");
INSERT INTO cmeNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ba ture ta ba fir-o, u taamba yuu-ba wuɔ: «Bige‑i ciɛ na ta na fir kakũmbiloŋo‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Baa cira: «Itieŋo yaa ciɛra i fir-o ka hã-yo.» ");
INSERT INTO cmeNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Aa naa fir-o ka hã Yesu‑i baa-yo. Baŋ kãa baa-yo, baa hiel ba joŋgorbaa-ba‑i haa u huoŋgu-na aa ce Yesu nyugũŋ ba ta ba wuɔ ba suur nelle-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Nuɔmba maŋ waa, baa bi hiel ba baamba‑i ta ba fara-bɛi hĩɛma-na u tuɔ wuɔ ba dɔrɔ u kã. ");
INSERT INTO cmeNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Baŋ kaa ta ba hiire Olivi-tibinni-tãnuŋgu-na aa da ba suur *Yerusalɛmu‑i-na, hãalãbiemba‑i ba kũŋgu-na hiere, ba hɔmmu gbuu fɛ̃. Baa doŋ ta ba hãl nɛini da kabakaba ba gbɛliɛŋ Diiloŋo‑i wuɔ u ciɛ gbɛrɛ-wɛima bɔi pigãaŋ-ba. ");
INSERT INTO cmeNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ba taa ba hãl wuɔ: «Itieŋ uŋ saaŋ nellentieŋo maŋ u jo, Diilo baa-yo! I suuriinu i-naa baa Diiloŋo‑i Dɔrwuoŋo gbĩɛ baa tuɔlnumma.» ");
INSERT INTO cmeNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","A ne da *Farisĩɛbaa-ba namba waa ba hɔlma-na. Baŋ juɔ da ba hãl nɛini‑i kabakaba dumaaŋo-na, baa waŋ baa Yesu‑i wuɔ: «Ŋ sa waŋ baa ŋ hãalãbiemba budii wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesu wuɔ cira: «Mi tũnu-nɛi, da ba fiɛ budii, tãmpĩɛŋa ka sire ta a hãl ba sɔlaaŋgu‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesuŋ kaa piɛ da nelle‑i, wuɔ pãŋ tuɔ kaal ");
INSERT INTO cmeNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","aa naa cira: «E! Yerusalɛmutaaŋ namaa, kuɔ naa naa suɔ kumaŋ ka fɛ̃ na hɔmmu‑i nyuŋgo daayo-na, kuu naa fa. Ŋga ku fuyaa-nɛi; na siɛ gbãa suɔ-ku. ");
INSERT INTO cmeNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Yiiŋgu dii baa yiiŋgu, na bigãarãamba ka jo ji dii-na huɔŋga. Ba ka suuye-nɛi terni-na hiere na siɛ da muŋkormu. ");
INSERT INTO cmeNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Diiloŋ uŋ juɔ duɔ ji kor-na aa na saa hũu-ma, ba ka muonu na nelle‑i aa ko-na hiere. Ba siɛ yaŋ dũŋgu diei ku gbeiniŋ.» ");
INSERT INTO cmeNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesuŋ kãa ka suur *Diilodubuɔ‑i-na da niisuornintaamba‑i, wuɔ tuɔ donya-bɛi ");
INSERT INTO cmeNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","aa naa tuɔ piiye baa-ba wuɔ: «Ma nyɛgãaŋ Diiloŋ-nelma-na wuɔ: ‹Mi dũŋgu ka ce Diilojaaldũŋgu.› Ma sĩnni niɛ namaa ce-ku cuo ba terieŋgu?» ");
INSERT INTO cmeNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yesu taa u waŋ Diiloŋ-nelma‑i u pigãaŋ nuɔmba‑i yinni maŋ joŋ Diilodubuɔ‑i-na. *Diilojigãntaamba yuntaambaŋ daa-ma dumaaŋo-na, baa *ãnjĩnamma pigãataamba‑i, a naara nelle yuntaamba‑i, baa ta ba taara ba ko-yo. ");
INSERT INTO cmeNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ŋga u nelma taa ma suurnu nuɔmba‑i ma cor a ce ba saa suɔ baŋ ka ce-yo dumaa da-yo ko-yo. ");
INSERT INTO cmeNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Yesuŋ kãa ka tuɔ waŋ *Neldɔdɔlma‑i u pigãaŋ nuɔmba‑i *Diilodubuɔ‑i-na, yiiŋgu naŋgu-na, *Diilojigãntaamba yuntaamba‑i baa *ãnjĩnamma pigãataamba‑i a naara nelle bĩncuɔŋ baa kã ");
INSERT INTO cmeNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ka cira: «Naacolŋ nuɔ, hai hãa-nuɔ hũmelle‑i ŋ ta ŋ ce niŋ ceŋ kumaŋ daaku‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yesu wuɔ cira: «Muɔmi ka bi yuu-na baa nelma diei: ");
INSERT INTO cmeNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Pigãaŋ-muɔ umaŋ naa puɔraa Nsãa tuɔ *batiseŋ nuɔmba‑i; Diiloŋo'i naa puɔraa-yo sisɔ nelbiliemba'i naa puɔraa-yo?» ");
INSERT INTO cmeNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Baa doŋ ta ba piiye ba-naa nuɔ wuɔ: «Diɛ cira Diiloŋo'i naa puɔraa-yo, u ka cira: ‹Naŋ suyaa-ma dumaaŋo-na, bige‑i ciɛ na saa hũu u nelma‑i?› ");
INSERT INTO cmeNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Diɛ bi hɔr-ma cira nelbiliemba'i naa puɔraa-yo, bamaŋ dii bande‑i hiere, ba suyaa wuɔ Nsãa waa *Diilopɔpuɔrbiloŋo; ba ka naŋ-ye baa tãmpɛ̃lɛ̃iŋa ko-ye.» ");
INSERT INTO cmeNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Baa naa ba cira: «I saa suɔ umaŋ naa puɔraa-yo.» ");
INSERT INTO cmeNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yesu wuɔ cira: «Muɔmi siɛ bi pigãaŋ-na umaŋ hãa-mi hũmelle‑i mi ta mi ce miŋ ceŋ kumaŋ daaku‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ku huoŋgu-na, Yesu wuɔ naŋ gbãnalãaŋ daaku‑i baa nuɔmba‑i wuɔ: «Naacolŋo naŋo diyaa *ɛrɛsɛ̃-suoŋgu aa biɛ maacenciraamba jĩna-kuɔ aa kã nelle duɔ ka vaaya. ");
INSERT INTO cmeNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Tibibieŋaŋ juɔ hi karma, u puɔr u maacembiloŋo diei maacenciraamba wulaa, wuɔ u ka hũu fuɔ yufelle‑i ka hã-yo. Maacembiloŋo ta kã. Uŋ kãa, maacenciraamba bel-o muo-yo aa bir-o; ba saa hã-yo bĩŋkũŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Suontieŋo tiraa puɔr maacembiloŋo naŋo ba wulaa. Ba tiraa bel ufaŋo‑i a muo-yo aa gbuu tuora-yuɔ aa bir-o; ba saa hã-yo bĩŋkũŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","U tiraa puɔr maacembiloŋo naŋo ba wulaa ba ce ba siɛi. Ba muo ufaŋo‑i posol-o aa donya-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Suontieŋo cira: ‹Mi ka ce niɛ?› Aa ji cira: ‹Mi ka puɔr mi bɛduɔla yaa ba wulaa; fuɔ duɔ kã, kuniɛ sĩ ba ka kãŋ-yo.› Aa ce u biɛŋo ta kã ba wulaa. ");
INSERT INTO cmeNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Baŋ juɔ'a ba ne da u jo, ba piiye baa ba-naa wuɔ: ‹Ciiluwuotieŋo yaa juɔŋ daayo. Yaaŋ i ko-yo aa ciiluŋgu ce miɛ kũŋgu.› ");
INSERT INTO cmeNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ba sire ku yaa nuɔ‑i a bel naacombiloŋo‑i hel baa-yo suoŋgu-na ka ko-yo.» Yesu wuɔ cira: «Suontieŋ daa u ka ce bige‑i? ");
INSERT INTO cmeNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","U ka jo ji ko-ba aa hã banamba baa suoŋgu‑i.» Nuɔŋ baa cira: «Diilo baa jo baa-ma!» ");
INSERT INTO cmeNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Baŋ piiye dumaaŋo-na, Yesu wuɔ cira: «Mafamma da ma saa ce, baŋ nyɛgãaŋ nelma maŋ Diiloŋ-nelma-na wuɔ: ‹Dũmarãambaŋ cĩinaana kpãŋkpara maŋ, u yaa juɔ bella dũŋgu‑i›, nelma famma yuŋgu yaa haku‑i? ");
INSERT INTO cmeNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Nuɔni maŋ da ŋ par diire a naŋ ŋ fɛrɛ kpãŋkpara daayo-na, ŋ ka kara ŋ fɛrɛ; duɔ bi par diire naŋ nuɔni maŋ, u ka putĩɛnu-niɛ.» ");
INSERT INTO cmeNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","*Diilojigãntaamba yuntaamba‑i, baa *ãnjĩnamma pigãataaŋ baa pãŋ suɔ wuɔ Yesu naaŋ gbãnalãaŋ daaku‑i hã ba yaa‑i, baa ta ba taara ba bel-o huɔŋgu faŋgu-na, ŋga ba taa ba kãalã nuɔmba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","A doŋ huɔŋgu faŋgu-na, baa doŋ ta ba cumaŋ Yesu‑i da ba bel-o. Baŋ puu mafamma‑i, baa ce huhurmantaamba namba kã u wulaa ka ce ba fɛrɛ nelfafaamba wuɔ sĩ ba ka gbãa ce u piiye cãl ba bel-o hã fãamaambaa-ba‑i baa-yo. ");
INSERT INTO cmeNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Baŋ kãa, baa cira: «Hãalãtie, i suyaa wuɔ ŋ waŋ ninsoŋo yaa‑i, aa ŋ sa kãalã nɛliɛŋo baa ŋ ninsoŋo‑i, ŋ sa bi ce ciɛluɔ, ŋ gbu ŋ pigãaŋ nuɔmba‑i Diiloŋ-hũmelle yaa‑i kelkel. ");
INSERT INTO cmeNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ŋga, a saa baa miɛ hũmelle‑i, ku saaya i tiɛ pã nampo‑i i hã *Oromɛ ba *jãmatigi‑i wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Yesu wuɔ suɔ baa-ba, wuɔ gbɛ̃-ba wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«Hãa-miŋ warbelle mi ne.» Baa hã-yo warbelle‑i. Wuɔ yuu-ba wuɔ: «Ba ciɛ hai yuŋgu‑i diɛ?» Baa cira: «Ba ciɛ Oromɛ ba jãmatigi yuŋgu.» Wuɔ tiraa yuu-ba wuɔ: «Ba nyɛgãaŋ hai yerre‑i diɛ?» Baa cira: «Ba nyɛgãaŋ Oromɛ ba jãmatigi yerre‑i diɛ.» ");
INSERT INTO cmeNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Yesu wuɔ cira: «Kumaŋ da ku waa jãmatigi kũŋgu, pãaŋ-kuŋ na hã jãmatigi‑i baa-ku, aa kumaŋ da ku waa Diiloŋ-kũŋgu‑i, na bi pã-ku na hã Diiloŋo‑i baa-ku.» ");
INSERT INTO cmeNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ba saa gbãa cure-yuɔ bel-o nuɔmba yaaŋga-na. U nel maa bir yaŋ aa naa cu ba hɔmmu‑i, baa naa ba par fĩinamma. ");
INSERT INTO cmeNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","*Sadusĩɛbaa-ba wulaa kuomba siɛ sire. Banaŋ baa kã ka gbɛ̃ Yesu‑i wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","«Hãalãtie, *Moisi nyɛgãaŋ nelma namma hã-ye wuɔ: ‹Umaŋ duɔ ku aa yaŋ u ciɛŋo‑i u saa da biloŋo baa-yo, u hãaŋo saaya u biɛ-yo a hoŋ biloŋo hã kuloŋo‑i.› ");
INSERT INTO cmeNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","A ne da naacombiemba namba waa niehãi ba nyu wulaa. Mɔlŋo sire jã ciɛŋo, u saa da bisãlmba baa-yo aa ku. ");
INSERT INTO cmeNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Umaŋ cuu-yo, u biɛ ciɛŋo‑i u saa da bisãlmba baa-yo, fuɔ tiraa ku aa yaŋ-yo; ");
INSERT INTO cmeNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","siɛliŋ-wuoŋo‑i maaduɔma. Ba kuu dumɛi niehãi‑i-na ka gbuo hiere unaa saa da biloŋo baa ciɛŋ daayo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ku huoŋgu-na, fuɔ fɛrɛ u suɔ tuɔ nyaanu-bɛi. ");
INSERT INTO cmeNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ba hieroŋo-na, baŋ diyaa-yo ba ciɛŋo cor, yiiŋgu maŋ kuoŋ da ba ji sire, u ka ce hai wuoŋo‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesu wuɔ cira: «Miwaaŋ daayo-na cadiile dii, ");
INSERT INTO cmeNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ŋga Diiloŋ uŋ ka fiɛl bamaŋ wuɔ nelfafaamba a sire-bɛi hiel-ba kuomba hɔlma-na ba da ba tĩɛna u nelle-na, bafamba siɛ ji ta ba dii caamba. ");
INSERT INTO cmeNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ba kaa waa gbula ŋaa *dɔrpɔpuɔrbiemba; ba siɛ tiraa gbãa ku. Baŋ siire hel kuomba hɔlma-na ba ciɛ Diiloŋ-biemba. ");
INSERT INTO cmeNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Moisi bi waaŋ kuomba siremmaŋ-kũŋgu‑i uŋ piiye pɛrfiɛlu maama‑i kusuɔŋ-nu wuɔ dãamu bilaa-du. U gbaraa-ma wuɔ: ‹*Abiramu Diiloŋo, *Isaki Diiloŋo, *Yakɔbu Diiloŋo!› ");
INSERT INTO cmeNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Diiloŋo‑i cicɛ̃lmantaaŋ-wuoŋo, bikuoŋ-wuoŋo sĩ. Diiloŋo wulaa nuɔmba‑i hiere baa dii cicɛ̃lma.» ");
INSERT INTO cmeNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Uŋ piiye dumaaŋo-na, *ãnjĩnamma pigãataamba naŋ baa cira: «Hãalãtie, ŋ suyaa piiyemma.» ");
INSERT INTO cmeNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Aa ba saa siɛ da ba tiraa yuu-yo baa nelma namma. ");
INSERT INTO cmeNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ku huoŋgu-na, Yesu wuɔ yuu-ba wuɔ: «Bige‑i ciɛ Diiloŋ uŋ pãa nuŋgu‑i wuɔ u ka saaŋ *Koŋkortieŋo maŋ, nuɔmba ta ba piiye wuɔ u ka waa *Davidi hãayɛ̃lŋo? Ba taara ba waŋ wuɔ niɛ dumaaŋo-na? ");
INSERT INTO cmeNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ma sĩ Davidi fuɔ fɛrɛ waaŋ-ma gbar-ma Gbɛliɛmaŋ-nɛini-na wuɔ: ‹Itieŋo gbĩɛ mi Tieŋo‑i wuɔ: «Jo ŋ ji tĩɛna mi caaŋ-nu, ");
INSERT INTO cmeNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","aa ŋ yaŋ mi mal ŋ bigãarãamba‑i hã ŋ ce ŋ bãaŋgu‑i bɛi.»› ");
INSERT INTO cmeNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Diiloŋ uŋ pãa nuŋgu‑i aa saaŋ Koŋkortieŋo maŋ, Davidi bĩ-yo u Tieŋo, u ce niɛ aa ce u hãayɛ̃lŋo yoŋ?» ");
INSERT INTO cmeNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ku huoŋgu-na, Yesu wuɔ waŋ baa u *hãalãbiemba‑i nuɔmba-na wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Bilaaŋ na fɛrɛ, baa na ta na ce *ãnjĩnamma pigãataamba temma‑i, ba maacemma saa fa: Ba hinu ba dii joŋgorbɔ̃mbɔ̃mbaa, aa da ba waa nuɔmba-na, ba taara ba ta ba piɛ ba jaal-ba. Da ba kã *Diilonelhãalãdũŋgu maŋ nuɔ‑i, sisɔ kãlle maŋ nuɔ‑i, ba taara ba tĩɛna yaaŋ-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Da ba ce ba bel diiloŋo‑i a hũu bikulcaamba nagãŋ-niini‑i hiere a wuo-ni, a ne da da ba'a ba cãrã Diiloŋo‑i, ba cãrã-yuɔ da agaga wuɔ nuɔmba cira bafamba faa. Kumaŋ ka haa-bɛi ku ka balaŋ cor.» ");
INSERT INTO cmeNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ku huoŋgu-na, Yesu wuɔ ne da waamba namba dii gbeiŋa‑i kekerieŋgu-na da ba hã Diiloŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Wuɔ u ne da bikulciɛŋo naŋo kãa ka dii tãmabieŋa hãi. A ne da u waa sũntieŋo. ");
INSERT INTO cmeNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Yesu wuɔ cira: «Yaaŋ mi waŋ ninsoŋo‑i baa-na: Ciɛŋ daayoŋ diyaa kumaŋ, ku maaraa banambaŋ diyaa kumaŋ hiere. ");
INSERT INTO cmeNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Bafamba paraa dii aa yaŋ boluoŋgu; ŋga ciɛŋ daa uŋ diyaa kumaŋ, ku yaa waa u yuŋgu-na yoŋ; kunaŋgu si dii yaŋga naŋga.» ");
INSERT INTO cmeNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Nuɔmba naŋ baa yiɛraaya ta ba piiye wuɔ: «*Diilodubuɔ daayo faa cor. Ba maa-yo baa tãmpɛ̃fɛfɛiŋa, aa baŋ pãa bĩmbĩnni maŋ hã ba tuɔlnu-yuɔ ni bi tiraa fa cor.» Yesu wuɔ gbɛ̃-ba wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«Naŋ daa dũŋgu maŋ daaku‑i, yiiŋgu dii baa yiiŋgu, ku ka fara hiere hĩɛma-na!» ");
INSERT INTO cmeNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Baa yuu-yo wuɔ: «Hãalãtie, mafamma ka ce yaku‑i, aa i ka ce niɛ suɔ huɔŋgu faŋgu‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesu wuɔ cira: «Baa na yaŋ molo ji pira-nɛi. Nuɔmba bɔi ka ta ba jo. Umaŋ duɔ jo, u ka cira wuɔ Diiloŋ uŋ pãa nuŋgu‑i wuɔ u ka saaŋ *Koŋkortieŋo maŋ, u yaa ufaŋo‑i, aa tiraa cira, miwaaŋo tĩmma hii. Baa na cu ba huoŋ-nu! Ba tãal-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Da na ji ta na da bɛrru ce terni-na hiere, aa nuɔmba ta ba cĩina ba yuntaamba‑i, baa na yaŋ korma da-na. Mafamma'i saaya ma ce igɛ̃na, ŋga miwaaŋo tĩmma'i siɛ pãŋ waa huɔŋgu faŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Nuɔmba kaa ta ba gãŋ siyaabaa siyaabaa, baa nilɛiŋa nilɛiŋa. ");
INSERT INTO cmeNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Hĩɛma kaa ta ma sagalla bɔ̃mbɔ̃ŋ a naara nyulmu‑i baa jarcelienumma kaa waa terni nanni-na. Korda-bĩmbĩnni kaa ta ni hel dɔrɔ‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ŋga, aa mafamma suɔ da ma ce, ba ka bel-na ce-na kpãncɔ̃lgũɔ. Ba ka kã baa-na *Diilonelhãalãdũnni-na ka gɛr-na aa dii-na kaso. Naŋ cuu muɔmi huoŋ-nu, yiiŋgu dii baa yiiŋgu ba ka bel-na kã baa-na fãamaambaa-ba wulaa, baa fɔ̃ŋgɔ̃taamba wulaa. ");
INSERT INTO cmeNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Huɔŋgu faŋgu'i nuɔ‑i na ka da na fɛrɛ piiye kumaŋ ciɛ na ta na nyaanu-miɛ. ");
INSERT INTO cmeNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Baa na tie holle wuɔ na siɛ ji suɔ naŋ kaa piiye mamaŋ a kor. ");
INSERT INTO cmeNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Naŋ ka waŋ mamaŋ, mɛi fɛrɛ'i ka dii-ma na nunni-na. A ce dumaaŋo-na, da na waŋ-ma, na bigãarãamba siɛ gbãa da manamma waŋ. ");
INSERT INTO cmeNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Halle na tobaa-ba‑i baa na nyubaa-ba‑i, baa na mɔlbaa-ba‑i, baa na hãmba‑i, baa na huraamba‑i, a naara na jɛ̃naamba ka dii-na na bigãarãamba nammu-na ba ko banamba nɛi. ");
INSERT INTO cmeNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Nuɔmba‑i hiere ba ka bigãaŋ-na mɛi maama-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ŋga, halle unaŋ yukuɔsibelle diei siɛ kar diire. ");
INSERT INTO cmeNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Da na hĩrã na kũɔma‑i na ka da cicɛ̃lma maŋ sa tĩɛŋ dede‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","«Da na ji da sorosibaa-ba cĩilãayã *Yerusalɛmu‑i huɔŋgu maŋ nuɔ‑i, na saaya na suɔ wuɔ u muonumma hii tĩ. ");
INSERT INTO cmeNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Bamaŋ da ba ji waa *Yude‑i-na, ba ta ba gbar ba kã tãnniŋ; bamaŋ da ba ji waa Yerusalɛmu huɔŋga-na ba hel; aa bamaŋ da ba ji waa hĩɛŋgu-na, ba baa cira ba suur nelle huɔŋ-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Mamaŋ nyɛgãaŋ hiere Yerusalɛmu kũŋgu-na Diiloŋ-nelma-na, ma ka ce yinni fanni'i nuɔ‑i. *Isirahɛl-baambaŋ ciɛ ãmbabalma maŋ, ba ka pã ma sullu‑i yinni fanni'i nuɔ‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Yiŋ daani ka huol. Kusũntaamba‑i baa bientaamba‑i sũlma haraa-bɛi yinni fanni-na. Diiloŋo ka pigãaŋ Isirahɛl-baamba‑i u jãyãmma‑i yinni fanni'i nuɔ‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ba ka ko banamba baa jigãmmu, aa bel banamba a pisãllã baa-ba jãmalãbaa-ba-na hiere. *Niɛraamba ka jo ji muonu Yerusalɛmu‑i aa sɛrɛ-yuɔ ce ba bãaŋgu‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","«Bãaŋgu kaa bir ku deŋ birma baa cɛiŋo‑i baa mɔɛŋa‑i hiere. Dãmmaŋ-nuoraaŋgu siɛ ji ta ku suɔ dumma, a ce dumaaŋo-na, nuɔmba hɔmmu kaa cu baa-ku, korma siɛ ji waa dɛi bɛi. ");
INSERT INTO cmeNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Bĩmbĩnni maŋ dii dɔrɔ‑i-na hiere, ni ka hel ni fonni-na. Nuɔmba da ba jɔguɔŋ ne mamaŋ ka da-ba, korma ka ce ba naŋ yir. ");
INSERT INTO cmeNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Huɔŋgu faŋgu'i nuɔ‑i, baŋ ka da *Moloŋ-Biɛŋo hilaa dɔrɔ‑i-na baa u fɔ̃ŋgũɔ‑i duherru suuye-yuɔ u tuɔ jo. ");
INSERT INTO cmeNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Mafamma da ma ji doŋ ta ma ce, siireŋ na ta na ne u hũmelle‑i, na kormaŋ-huɔŋgu piyaa.» ");
INSERT INTO cmeNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Aa naa waŋ nel daama‑i pigãaŋ-ba wuɔ: «Niɛŋ *yensãaŋgu‑i baa tibinni nanni‑i hiere, ");
INSERT INTO cmeNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","da na ji da ni duɔŋ ta ni caa fiɛlu‑i, na bi suɔ kerre ifɛlle hii tĩ. ");
INSERT INTO cmeNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Kuuduɔŋgu yaa‑i, da na bi ji da mamaŋ daama duɔŋ ta ma ce, na saaya na suɔ wuɔ *Diiloŋ-bãaŋgu hii tĩ. ");
INSERT INTO cmeNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Yaaŋ mi waŋ ninsoŋo‑i baa-na: Nel daama ka ce hi fiɛfiɛ ku nuɔmba namba aa ba suɔ ku. ");
INSERT INTO cmeNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Dɔrɔ‑i baa hĩɛma‑i ni ka gbuo, ŋga mɛi nelma sa ji gbuo dede. ");
INSERT INTO cmeNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Bilaaŋ na fɛrɛ, baa na yaŋ na hɔmmu yu baa ponsanniŋ-maama, baa konyɔlleŋ-maama, baa ãnjɔguɔma. Da na saa bel na fɛrɛ, yiiŋ daaku ka tugol-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ku ka tugol nuɔmba‑i hiere ŋaa kɔlluŋ tugol bĩŋwuoŋo dumaa bel-o. ");
INSERT INTO cmeNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Yaahuolo maŋ juɔŋ, vaaŋ na fɛrɛ baa Diilocãrãlle‑i ku yaa u ka kãyã-nɛi na hel-yuɔ. Da na hel yaahuolo daayo-na, na gbãa yiɛra Moloŋ-Biɛŋo yaaŋga-na a piiye.» ");
INSERT INTO cmeNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yesu taa u dii bãaŋgu‑i *Diilodubuɔ‑i-na u waŋ Diiloŋ-nelma‑i u pigãaŋ nuɔmba‑i, aa tuɔ kã u cɔ *Olivi-tibinni-tãnuŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Cuo duɔ kaal, nuɔmba naar kũɔl ba-naa jo Diilodubuɔ‑i-na ji ta ba nu u nelma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","*Baŋ'a ba sa dii siini‑i *buruo maŋ nuɔ‑i u ponsaaŋguŋ juɔ ta ku piɛ, ba bi bĩ ponsaaŋgu faŋgu yaa *kɔrsĩnni tĩmmaŋ-ponsaaŋgu‑i, ");
INSERT INTO cmeNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","*Diilojigãntaamba yuntaamba‑i, baa *ãnjĩnamma pigãataaŋ baa ta ba taara ba ko Yesu‑i, ŋga ba taa ba kãalã nuɔmba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Huɔŋgu faŋgu'i nuɔ‑i, *Sitãniŋ suurii *Yuda‑i-na, u yerre nande yaa Isikaro. Yuda nuŋgu waa Yesu *hãalãbieŋ cĩncieluo ba hãi baamba‑na. ");
INSERT INTO cmeNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Wuɔ sire kã ba ka nunu ba-naa baa Diilojigãntaamba yuntaamba‑i baa *Diilodubuɔ niyataamba yuntaamba‑i, uŋ ka kãyã-bɛi dumaa ba bel Yesu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Kuɔ gbuu dɔlnu-bɛi, baa cira ba ka hã-yo gbeiŋa. ");
INSERT INTO cmeNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yuda wuɔ hũu-ma aa naa tuɔ ne uŋ ka da hɔfafaaŋgu maŋ ba bel Yesu‑i nuɔmba baa suɔ. ");
INSERT INTO cmeNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","*Baŋ'a ba sa dii siini‑i *buruo maŋ nuɔ‑i u ponsaaŋguŋ juɔ hi, baŋ koŋ *kɔrsĩnni tĩmmaŋ-ponsaaŋgu tũlmba‑i yiiŋgu maŋ nuɔ‑i, ");
INSERT INTO cmeNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesu wuɔ waŋ baa Piɛr‑i baa Nsãa‑i wuɔ: «Kãaŋ na ka ce ponsaaŋgu niiwuoni‑i, diɛ kã i ka wuo.» ");
INSERT INTO cmeNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Baa yuu-yo wuɔ: «I ka ce-ni hie?» ");
INSERT INTO cmeNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Wuɔ cira: «Da na ka suur nelleŋ-huɔŋga-na, na ka da naacolŋo naŋo tũyãa hũmmaŋ-bũnaŋga, na cu u huoŋ-nu. Duɔ ka suur dumɛlle maŋ nuɔ‑i, na suur baa-yo. ");
INSERT INTO cmeNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Da na suur, na waŋ baa dumɛllentieŋo‑i wuɔ hãalãtieŋ wuɔ u pigãaŋ-na dũŋgu maŋ uŋ ka hã-yo baa-ku u wuo kɔrsĩnni tĩmmaŋ-ponsaaŋgu niiwuoni‑i baa u *hãalãbiemba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","U ka pigãaŋ-na dubuɔ naŋo dɔrɔ‑i-na; bĩmbĩnni dii-yuɔ tĩ. Na ce niiwuoni‑i kusuɔŋ-nu'i.» ");
INSERT INTO cmeNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Piɛrbaa-ba ta. Baŋ kãa ka hi, baa bi da-ma ŋaa Yesuŋ waaŋ-ma dumaa. Baa ce kɔrsĩnni tĩmmaŋ-ponsaaŋgu niiwuoni‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Niiwuoniŋ-huɔŋguŋ juɔ hi, Yesu wuɔ jo ji tĩɛna baa u *pɔpuɔrbiemba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Wuɔ waŋ baa-ba wuɔ: «Mi gbuu ta mi taara mi ce ponsaaŋ daaku‑i baa-na aa suɔ suur yaahuolo-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Yaaŋ mi tũnu-nɛi, da ŋ da yiɛ i da i-naa diɛ tiraa ce ponsaaŋ daaku‑i ku siɛ waa bande; ku ka waa *Diiloŋ-nelleŋ. Kuŋ donyaŋ kumaŋ kuu dii kusuɔŋ-nu'i.» ");
INSERT INTO cmeNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Uŋ waaŋ mafamma‑i, wuɔ biɛ duvɛ̃ŋo ciiŋ-na a jaal Diiloŋo‑i, aa cira: «Hũyãaŋ na nyɔŋ tɛ̃ntɛ̃ŋ. ");
INSERT INTO cmeNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Mi tũnu-nɛi, *Diiloŋ-bãaŋ da ku saa ji doŋ, mi sa ji tiraa dii duvɛ̃ŋo mi nuŋgu-na.» ");
INSERT INTO cmeNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ku huoŋgu-na, wuɔ biɛ *buruo aa jaal Diiloŋo‑i aa bũlnu-yuɔ hã-ba, aa cira: «Mi kũɔma yaa‑i, ma ka ce tãmmaŋ-kũŋgu na maama-na. Taa na ce miŋ ciɛ kumaŋ daaku‑i mi maama ta ma tĩɛnu-nɛi.» ");
INSERT INTO cmeNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Baŋ juɔ wuo niiwuoni‑i tĩ, wuɔ tiraa biɛ duvɛ̃ŋ-ciiŋga‑i hã-ba aa cira: «Mi tãmma maŋ ka kũnna na maama-na ma yaa daama ciiŋga-na. Diiloŋo ka bel u *tobisĩfɛlɛnni‑i baa ma yaa‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Niɛŋ, umaŋ ka hel mi huoŋ-nu, uu dii tĩɛna tuɔ wuo baa-ye bande‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ba ka ko *Moloŋ-Biɛŋo‑i ninsoŋo ŋaa Diiloŋ uŋ'a ma ce dumaa, ŋga umaŋ ka hã-ba baa-yo ba ko-yo, sũlma haraa kutieŋo-na.» ");
INSERT INTO cmeNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","*Hãalãbieŋ baa doŋ ta ba yuu ba-naa wuɔ: «Miɛŋo-na bande‑i-na, hai moloŋo‑i siɛ ce daama temma‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ku huoŋgu-na, *hãalãbieŋ baa ta ba taara ba suɔ umaŋ yuŋgu ba hɔlma-na. Kuɔ ce ijieni. ");
INSERT INTO cmeNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesu wuɔ waŋ baa-ba wuɔ: «Nellentaamba haa fɔ̃ŋgũɔ‑i nuɔmba-na, fɔ̃ŋgɔ̃taamba ta ba guor nuɔmba ta ba bĩ-ba nelfafaamba. ");
INSERT INTO cmeNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ku saa saaya ku waa dumaaŋo-na namaa na wulaa. Umaŋ duɔ waa nelbuɔ‑i na hɔlma-na, kutieŋo saaya u ce u fɛrɛ cɛkũɔ, umaŋ duɔ waa na yuŋgu-na, kutieŋo ce u fɛrɛ ŋaa maacembiloŋo. ");
INSERT INTO cmeNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Yaaŋ mi yuu-na nelma diei: Nuɔ baa ŋ maacembiloŋo‑i hai nelbuɔ‑i? Nuɔnɛi sĩ wɛi? Ŋga mɛi dii na hɔlma-na ŋaa na maacembiloŋ muɔ. ");
INSERT INTO cmeNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Miŋ ciɛ mulĩɛma maŋ cor hiere, na hĩɛrã na kũɔma‑i a tĩɛna baa-mi. ");
INSERT INTO cmeNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Terieŋgu faŋgu-na, mi To uŋ hãa-mi fɔ̃ŋgũɔ‑i dumaa, muɔmi ka bi hã-na baa-yo dumɛi, ");
INSERT INTO cmeNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","i diɛ ka waa baa i-naa mi nelle-na a tiɛ wuo aa tiɛ nyɔŋ baa i-naa. Aa na ka waa *Isirahɛl dũnni cĩncieluo ni hãi-niini yuŋ-nu.» ");
INSERT INTO cmeNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ku huoŋgu-na, Yesu wuɔ tuɔ piiye baa Simɔ‑i wuɔ: «Simɔ, ne! *Sitãni cãarã-nɛi Diiloŋo wulaa duɔ sagalla-nɛi ne sĩ u ka gbãa hũu-na mi wulaa. ");
INSERT INTO cmeNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ŋga mɛi cãarã Diiloŋo‑i a hã nuɔŋo‑i wuɔ ŋ Diiloŋ-hũmelleŋ-kũŋgu baa ku. Ŋ ka nanna-miɛ ŋga ŋ ka bir jo. Da ŋ jo, ŋ kãyã ŋ nabaamba‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Piɛr wuɔ cira: «Itie, da ba fiɛ dii-ni kaso, ŋ ka bi da ba diyaa muɔŋo‑i baa-ni. Halle da ku fiɛ waa kuliiŋgu, mii dii ŋ huoŋ-nu.» ");
INSERT INTO cmeNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesu wuɔ cira: «Piɛr, yaŋ ŋ fɛrɛ, muɔmɛi tũɔ-niŋ, isuɔduɔŋ daaku-na, kɔhɔldĩɛlãŋo siɛ hi bu, ŋ ka cĩina-miɛ da i siɛi wuɔ naŋ sa suɔ-mi.» ");
INSERT INTO cmeNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ku huoŋgu-na, Yesu wuɔ waŋ baa *hãalãbiemba‑i hiere wuɔ: «Mi naŋ puɔraa-na aa naa cira nɛliɛ baa biɛ gbeiŋa, nɛliɛ baa biɛ buɔra, nɛliɛ baa biɛ naatɛnni; bĩŋkũŋgu kaa naa na wulaa wɛi?» Baa cira: «E'e, ma saa ka ce.» ");
INSERT INTO cmeNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Wuɔ gbɛ̃-ba wuɔ: «Fiɛfiɛ ku kũŋgu‑i kuuduɔŋgu sĩ: Gbeiŋ da a waa baa umaŋ, u biɛ-ya. Buɔra duɔ waa baa umaŋ, u biɛ-yo. Aa nuɔni maŋ jigãŋga sĩ baa-ni, ŋ suor ŋ joŋgoruo‑i ŋ sãa kanaŋga. ");
INSERT INTO cmeNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Yaaŋ mi tũnu-nɛi, mamaŋ nyɛgãaŋ Diiloŋ-nelma-na wuɔ: ‹Ba ka ce-yo nelbabalaŋo›, ba gbɛ̃ muɔmɛi. Ma ka bi ce. Mi maama maŋ nyɛgãaŋ sɛbɛ‑i-na, ma cemmaŋ-yiiŋgu hii.» ");
INSERT INTO cmeNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Hãalãbieŋ baa cira: «Itie, jigãmmu hãi daa tĩ.» Yesu wuɔ cira: «Ku ka saanu.» ");
INSERT INTO cmeNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesuŋ waaŋ mafamma‑i, wuɔ hel ta tuɔ kã *Olivi-tibinni-tãnuŋgu-na. Ba taa ba kã koko terieŋgu faŋgu-na. U *hãalãbieŋ baa bi sire cu u huoŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Baŋ kaa hi, wuɔ gbɛ̃-ba wuɔ: «Cãarãŋ Diiloŋo‑i wɛima baa gbãa tãal-na dii-na kuubabalaaŋgu cemma-na.» ");
INSERT INTO cmeNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Aa fuɔ wuɔ cor kã yaaŋ-na cɛllɛ ka dũuna tuɔ cãrã wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","«Baba, da ŋ siɛ ŋ maaya yaahuolo daayo‑i muɔ-na; ŋga baa cira ŋ fer muɔ, ce-ma niŋ taaraŋ ma ce dumaa.»  ");
INSERT INTO cmeNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Huɔŋgu faŋgu-na, *dɔrpɔpuɔrbiloŋo naŋ wuɔ jo ji carra-yuɔ a dii holle yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","U huɔŋgaŋ ŋa na'a ka saa waa huɔŋga dumaaŋo-na, kunaŋ kuɔ migãaŋ naara u Diilocãrãlle‑i. U cufaluŋ kuɔ ta ku kũnna ŋaa tãmma. ");
INSERT INTO cmeNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Uŋ juɔ cãrã tĩ, wuɔ sire jo u hãalãbiemba wulaa jo ji da hɔculle ciɛ ba kor duɔfũŋ. ");
INSERT INTO cmeNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Wuɔ cira: «Bige‑i ciɛ na ta na duɔfũŋ? Siireŋ na ta na cãrã Diiloŋo‑i bĩŋkũŋgu baa gbãa tãal-na dii-na kuubabalaaŋgu cemma-na.» ");
INSERT INTO cmeNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Nelma saa ji tĩ Yesu nuŋgu-na, ba'a ba ne da nuɔmba namba jo. Yesu *hãalãbieŋ cĩncieluo ba hãi baamba-na, baŋ taa ba bĩ umaŋ *Yuda‑i, u yaa waa nuɔŋ daaba yaaŋga-na. Baŋ juɔ hi, wuɔ piɛ duɔ pũrã Yesu‑i jaal-o. ");
INSERT INTO cmeNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Yesu wuɔ cira: «Yuda, ŋ ka jaal *Moloŋ-Biɛŋo‑i baa jaaluŋ daaku yaa‑i a da ŋ pigãaŋ-ba baa-yo ba bel-o kɛ?» ");
INSERT INTO cmeNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Bamaŋ waa baa Yesu‑i baa suɔ suɔ fiɛfiɛ‑i-na wuɔ ku huoŋgu siɛ fa. Baa yuu Yesu‑i wuɔ: «Itie, i biɛ i jigãmmu‑i bɛi wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Unaŋ wuɔ pãŋ biɛ u kaaŋga‑i a jafũŋ *Diilojigãntaamba yuntieŋo maacembiloŋo naŋo nadietũŋgu‑i a yer-ku. ");
INSERT INTO cmeNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Yesu wuɔ cira: «Yaaŋ dumaa, daaku ka saanu!» Aa naa kã ka bel naacolŋo tũŋgu‑i a nar-ku ku temma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Uŋ naraa-ku, wuɔ waŋ baa *Diilojigãntaamba yuntaamba‑i, baa *Diilodubuɔ niyataamba yuntaamba‑i, a naara bĩncuɔmba‑i wuɔ: «Na hilaa baa jigãmmu baa bɔ̃ɛŋa da na ji bel-mi ŋaa cuoyuo muɔ. ");
INSERT INTO cmeNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ma sĩ yinni maŋ joŋ i da i-naa Diilodubuɔ‑i-na kɛ? Bige‑i ciɛ na saa siɛ bel-mi terieŋgu faŋgu-na? Fiɛfiɛ yaa namaa huɔŋgu‑i, baa *Sitãni bi huɔŋgu‑i; na gbãa ce kumaŋ dɔlaanu-nɛi.» ");
INSERT INTO cmeNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Baŋ bilaa Yesu‑i, baa ta baa-yo ta ba kã baa-yo *Diilojigãntaamba yuntieŋo cĩiŋgu-na. Piɛr wuɔ yaŋ ba maa aa suɔ cu ba huoŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Uŋ kaa hi, wuɔ da nuɔmba namba yiraaŋ dãamu gɔ̃ŋgũɔŋ-huɔŋga-na, wuɔ kã ka tĩɛna baa-ba. ");
INSERT INTO cmeNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Maacembiloŋo naŋ wuɔ ne Piɛr da kelkelkel aa naa cira: «Naacolŋ daayo waa baa Yesu‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Piɛr wuɔ cira: «Ciɛŋ nuɔ, mɛi sa suɔ-yo.» ");
INSERT INTO cmeNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Cɛllɛ, naacolŋo naŋo da-yo, wuɔ cira: «Ma sĩ nuɔ ŋ bi waa baa-ba kɛ?» Piɛr wuɔ cira: «Naacolŋ nuɔ, ŋ haanu, muɔ sĩ!» ");
INSERT INTO cmeNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Kuɔ vaaya cɛllɛ, unaŋo saa hũu-ma, wuɔ cira: «Coima saa fa, naacolŋ daayo hel *Galile; u waa baa-yo.» ");
INSERT INTO cmeNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Piɛr wuɔ cira: «Naacolŋ nuɔ, ŋ waŋ wuɔ niɛ dumandɛ‑i?» Uŋ taa u waŋ mafamma‑i, kɔhɔldĩɛlãŋo doŋ tuɔ bu. ");
INSERT INTO cmeNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Yesu wuɔ miɛl ne-yo. Uŋ ŋa naa gboya-yuɔ baa nelma maŋ wuɔ isuɔduɔŋ daaku-na, kɔhɔldĩɛlãŋo siɛ hi bu, kɛrɛ u ka cĩina-yuɔ da i siɛi wuɔ u sa suɔ-yo maa pãŋ tĩɛnu Piɛr‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Wuɔ hel fuoreŋ gbuu pãŋ tuɔ kaal. ");
INSERT INTO cmeNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Baŋ bilaa Yesu‑i aa jĩna nuɔmba maŋ ta ba niya-yuɔ ba taa ba muo-yo aa ta ba nyɛ-yo. ");
INSERT INTO cmeNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Baa naa vaa u yufieŋa‑i aa ta ba muo-yo. Umaŋ duɔ muo, ba yuu-yo wuɔ: «Hai moloŋo‑i muyaa-ni? Bĩ kutieŋo yerre‑i i ne!» ");
INSERT INTO cmeNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Aa ba tuoraaya-yuɔ ŋaa ba ka ko-yo. ");
INSERT INTO cmeNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Cuoŋ juɔ kaal, *Yuifu ba bĩncuɔmba‑i, baa *Diilojigãntaamba yuntaamba‑i, baa *ãnjĩnamma pigãataaŋ baa jãnu ba-naa aa naa ce ba jo baa-yo wuɔ ba ji ce u ãndaaŋgu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Baŋ juɔ baa-yo, baa yuu-yo wuɔ: «Da kuɔ Diiloŋ uŋ pãa nuŋgu‑i wuɔ u ka saaŋ *Koŋkortieŋo maŋ u yaa nuɔŋo‑i waŋ-ma baa-ye.» Yesu wuɔ cira: «Da mi fiɛ waŋ wuɔ niɛ, na siɛ hũu-ma, ");
INSERT INTO cmeNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","aa da mi yuu-na baa mamaŋ, na siɛ siɛ-mi. ");
INSERT INTO cmeNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ŋga mamaŋ dii, *Moloŋ-Biɛŋo ka kã ka waa Itieŋo caaŋ-nu.» ");
INSERT INTO cmeNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Uŋ waaŋ mafamma‑i, ba hieroŋo‑i baa cira: «Diiloŋ-Biɛŋo yaa nuɔŋo‑i wɛi?» Yesu wuɔ cira: «Muɔmɛi.» ");
INSERT INTO cmeNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Baa cira: «Ii si dii diɛ ka yuu moloŋo, miɛ fɛrɛ‑i i nuɔ-ma u nuŋgu-na; wuɔ fuɔ Diiloŋ-Biɛŋo.» ");
INSERT INTO cmeNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ku huoŋgu-na, baa sire hiere a kã baa Yesu‑i *Pilati wulaa. ");
INSERT INTO cmeNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Baŋ kaa hi, baa gbɛ̃ Pilati‑i wuɔ: «I daa naacolŋ daa u wuɔra u gbo nuɔmba‑i nelle-na wuɔ ba baa pã nampo‑i a hã *Oromɛ ba *jãmatigi‑i. Aa cira Diiloŋ uŋ pãa nuŋgu‑i wuɔ u ka saaŋ *Koŋkortieŋo maŋ, u yaa ufaŋo‑i aa tiraa cira fuɔ nellentieŋo.» ");
INSERT INTO cmeNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilati wuɔ yuu-yo wuɔ: «*Yuifu ba nellentieŋo yaa nuɔŋo‑i wɛi?» Yesu wuɔ cira: «Muɔmɛi.» ");
INSERT INTO cmeNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilati wuɔ waŋ baa *Diilojigãntaamba yuntaamba‑i, baa nuɔmba‑i hiere wuɔ: «Mɛi saa da cãlmuɔ naacolŋ daayo-na.» ");
INSERT INTO cmeNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Baa yagar aa naa ta ba kaasĩŋ wuɔ: «U saa fa; nelgboroŋo. U duɔŋ baa-ku dii *Galile a jo ji wuɔra gbuo *Yude‑i hiere baa-ku, fiɛfiɛ‑i u juɔ ji cor baa ku yaa‑i *Yerusalɛmu‑i-na bande‑i-na; wuɔ nuɔmba ta ba ce ba fɛrɛŋ-maama.» ");
INSERT INTO cmeNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilatiŋ juɔ nu ba bĩɛ Galile yerre‑i, wuɔ yuu-ba wuɔ: «Naacolŋ daayo‑i Galileyiɛŋo‑i wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Baa cira: «Ũu, Galileyiɛŋo.» A ne da huɔŋgu faŋgu-na, *Erɔdi yaa waa Galile yuŋgu-na. Kuɔ bi saanu u juɔ yinni fanni-na Yerusalɛmu-na. Pilati wuɔ saaŋ Yesu‑i a hã-yo. ");
INSERT INTO cmeNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Erɔdi wuɔ nuɔ Yesu maama‑i ku bãaŋgu cuɔ, wuɔ tuɔ taara u da u yufelle ŋga u saa ji da-yo. Pilatiŋ juɔ saaŋ-yo hã-yo, kuɔ gbuu dɔlnu-yuɔ; wuɔ tuɔ taara u ce gbɛrɛ-wɛima fuɔ ne. ");
INSERT INTO cmeNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Wuɔ yuu-yo baa nelma bɔi, ŋga Yesu saa ji seŋ sũnuŋgu yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","A ne da huɔŋgu faŋgu-na, *Diilojigãntaamba yuntaamba‑i, baa *ãnjĩnamma pigãataamba waa Erɔdi terieŋgu-na gbuu ta ba kar coikãŋkarɛiŋa ba haa-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Erɔdi‑i baa u sorosibaa-ba‑i baa nyɛ-yo aa tuora-yuɔ da dɛi aa dii yuntaaŋ-joŋgoruo hã-yo ku da ku col-o aa bir saaŋ-yo hã Pilati‑i baa-yo. ");
INSERT INTO cmeNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Erɔdi‑i baa Pilati‑i ba saa ta ba gbo, ŋga yiiŋgu faŋgu-na, baa pãŋ bel jĩɛru. ");
INSERT INTO cmeNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Yesuŋ birii jo, *Pilati wuɔ bĩ *Diilojigãntaamba yuntaamba‑i, baa *Yuifu ba yuntaamba‑i, a naara nelleŋ-nuɔmba‑i ");
INSERT INTO cmeNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","a ji cira: «Namɛi juɔ baa naacolŋ daayo‑i ji hã-mi wuɔ u wuɔra u gbo nuɔmba‑i. Mɛi yuu-yo namaa fɛrɛ‑i na yufelleŋ, naŋ haa mamaŋ yuɔ mi saa da-ma yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Na saa da *Erɔdiŋ birii saaŋ-yo hã-mi wɛi? Fuɔ saa bi da uŋ ciɛ kumaŋ aa ku hi u kuliiŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Mi ka ce ba muo-yo yoŋ aa nanna-yuɔ.»  ");
INSERT INTO cmeNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Belle belle, *Yuifubaa da ba'a ba ce ba *kɔrsĩnni tĩmmaŋ-ponsaaŋgu‑i, Pilati nanna ba kasobiloŋo diei. ");
INSERT INTO cmeNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Nuɔŋ baa sire hiere ta ba kaasĩŋ wuɔ: «Ko naacolŋ daayo‑i aa ŋ nanna Barabasi yaa‑i!» ");
INSERT INTO cmeNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabasi wuɔ gbuɔ nuɔmba ce ijieni nanni nelleŋ-huɔŋga-na, aa naa tiraa ko nɛliɛŋo. Baa bel-o dii-yo kaso‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilati saa tuɔ taara ba ko Yesu‑i, wuɔ tiraa piiye baa-ba. ");
INSERT INTO cmeNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Baa yagar aa ta ba kaasĩŋ wuɔ: «Gbu-yo *daaŋ-nu! Gbu-yo daaŋ-nu!» ");
INSERT INTO cmeNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilati wuɔ yuu-ba ku yu u bɛyufieŋa siɛi wuɔ: «U guɔlaaya hama‑i? Mɛi saa da uŋ ciɛ kumaŋ aa na'a i ko-yo. Mamaŋ dii, mi ka ce ba muo-yo aa nanna-yuɔ.» ");
INSERT INTO cmeNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Baa yagar aa naa gbuu pãŋ ta ba kaasĩŋ da gbagaga wuɔ ba saaya ba gbu-yo daaŋ-nu ko-yo. ");
INSERT INTO cmeNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Baŋ kaasĩŋ dumaaŋo-na, Pilati saa gbãa duɔ yagar, wuɔ naa u hũu-ma. ");
INSERT INTO cmeNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Uŋ hũyãa-ma dumaaŋo-na, wuɔ ce ba nanna Barabasi‑i, fuɔ maŋ gbuɔ nuɔmba ce ijieni‑i aa tiraa ko nɛliɛŋo, aa hã-ba Yesu‑i wuɔ ba kã, kumaŋ da ku ka dɔlnuŋ-bɛi, ba ce-ku yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","*Pilatiŋ hãa-ba Yesu‑i, sorosibaa baa biɛ baŋ ka gbuŋ-yoŋ *daaŋgu maŋ nuɔ‑i a haa-ku hã-yo, aa naa ta baa-yo da ba ka ko-yo. Baŋ kãŋ hũmelle-na, baa suu baa Sirɛniyiɛŋo naŋo hilaa suoŋ-nu. Ba bĩ-yo Simɔ. Baa bel-o haa daaŋgu‑i hã-yo, aa ce u cu Yesu huoŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Nuɔmba saa waa dɛi ba huoŋgu-na. Caamba bi waa ba hɔlma-na, baa haa ba nammu‑i ba yunniŋ ta ba kaal. ");
INSERT INTO cmeNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesu wuɔ miɛl tuɔ piiye baa-ba wuɔ: «*Yerusalɛmu caaŋ namaa, baa na kaal mɛi maama-na, taa na kaal namaa fɛrɛŋ maa-na baa na bisãlmba maa-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Na saa da, yiiŋgu dii baa yiiŋgu, ba kaa cira: ‹Caamba maŋ saa hoŋ da, baa bamaŋ saa fiɛ dede, ba yunni dɔlaa.› ");
INSERT INTO cmeNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Yiiŋgu faŋgu-na, nuɔmba kaa ta ba gbɛ̃ tãnni‑i wuɔ: ‹Ciiŋ na haa-yiɛ!› aa gbɛ̃ tãnyieŋa‑i wuɔ: ‹Suuyeŋ-yiɛ!› ");
INSERT INTO cmeNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Da ba dii daabĩnaaŋgu‑i dãamu-na, ba ka ce daakuraaŋgu fuɔ niɛ?» ");
INSERT INTO cmeNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Baa bilaa gburaŋgbotaamba namba ba hãi, baa gbonu-bɛi baa Yesu‑i da ba ka ko-ba. ");
INSERT INTO cmeNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Tãnyelle nande dii ba bĩ-de Yukoluoŋgu. Baŋ kaa hi tãnyelle fande‑i baa gbu Yesu‑i baa gburaŋgbotaaŋ daaba‑i ba hãi‑i-na. Unaŋo‑i u nadieŋ-na, unaŋo‑i u nanyuɔŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Baŋ gbuu-ba, Yesu wuɔ cira: «Baba, baa gãŋ baa-ba; baŋ ceŋ kumaŋ ba sa suɔ-ku.» Sorosibaa-ba‑i ba-naa nuɔ, baa ta ba taara ba calnu u joŋgorbaa-ba‑i, ba saa suɔ baŋ ka hã umaŋ aa yaŋ umaŋ. Baa naa ba ful tieŋa calnu-bɛi. ");
INSERT INTO cmeNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Nuɔŋ baa yiɛra ta ba fara ba ne. *Yuifu ba yuntaaŋ baa ta ba piiye wuɔ: «U kuraa banamba‑i, fiɛfiɛ‑i ku hii u yaa‑i, u kor u fɛrɛ i ne. Duɔ kor u fɛrɛ, ku yaa i ka suɔ wuɔ Diiloŋo uŋ pãa nuŋgu‑i aa saaŋ *Koŋkortieŋo maŋ u yaa ufaŋo‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Sorosibaa baa bi ta ba nyɛ-yo aa naa hã-yo niisaarni wuɔ u nyɔŋ, ");
INSERT INTO cmeNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","aa naa cira: «Da kuɔ nuɔnɛi Yuifu ba nellentieŋ nuɔŋo‑i, kor ŋ fɛrɛ i ne.» ");
INSERT INTO cmeNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Baa nyɛgãaŋ u yudɔrɔ‑i-na wuɔ: «Yuifu ba nellentieŋo yaa daayo.» ");
INSERT INTO cmeNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ba naŋ gbuu gburaŋgbotaamba maŋ, unaŋ wuɔ bir gbɛ̃ Yesu‑i wuɔ: «Naŋ saa cira wuɔ Diiloŋo uŋ pãa nuŋgu‑i aa saaŋ Koŋkortieŋo maŋ u yaa nuɔŋo‑i wɛi? Kor ŋ fɛrɛ aa ŋ kor miɛŋo‑i kɛ!» ");
INSERT INTO cmeNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ku saa dɔlnu u nawuoŋo‑i, wuɔ tuɔ waŋ baa-yo wuɔ: «Naŋ sa kãalã Diiloŋo‑i dɛ! Ma sĩ ii dii mulĩɛnduɔma yaa nuɔ‑i baa-yo kɛ? ");
INSERT INTO cmeNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Baŋ bilaa miɛŋo‑i ba ninsoŋo. Miɛ ãntaaramma'i diyaa-ye kuliiŋ daaku-na, aa fuɔ saa bi guɔla bĩŋkũŋgu ba bel-o da ba ko-yo gbãŋgbãŋ.» ");
INSERT INTO cmeNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Aa naa waŋ baa Yesu‑i wuɔ: «Yesu, da ŋ ji waa ŋ nellentesĩnni-na, ŋ baa yaŋ mi maama karaanu-niɛ.» ");
INSERT INTO cmeNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesu wuɔ cira: «Mi waŋ ninsoŋo‑i baa-ni: Nyuŋgo daayo-na, ŋ ka suur baa-mi Diiloŋ-nelle-na.» ");
INSERT INTO cmeNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Bãaŋguŋ juɔ hi yuhuɔŋga‑i, ba'a ba ne da terieŋgu cuure hiere da bĩntũu. Ku tĩyãa dumɛi fuɔ bãaŋgu ji tɛrɛŋ. ");
INSERT INTO cmeNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Kompaŋga maŋ naa karaanu *Diilodubuɔ‑i, kaa pãŋ taalnu ka holle-na sɔmma hãi. ");
INSERT INTO cmeNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesu wuɔ kaasĩŋ da gbagaga wuɔ: «Baba, hũu-mi.» Aa bi hũu u fɛrɛ. ");
INSERT INTO cmeNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Sorosi ba yuntieŋo naŋ uŋ daa mafamma‑i, wuɔ gbɛliɛŋ Diiloŋo‑i aa naa cira: «Coima saa fa, naacolŋ daayo naa vii.» ");
INSERT INTO cmeNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Nuɔmba maŋ naa kãa ka ta ba ne, baŋ juɔ da-ku dumaaŋo-na, baa bir ta ba misĩrrã ba yunni‑i ba kũŋ. ");
INSERT INTO cmeNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Yesu sɔsuɔtaamba‑i baa caamba maŋ naa nyaanu-yuɔ a hel *Galile‑i-na kã, baa yiɛra da yargaa ta ba fara ba ne. ");
INSERT INTO cmeNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Naacofɛfɛiŋo naŋo waa *Yuifu ba *nellentaamba hɔlma-na, ba taa ba bĩ-yo Yosɛfu. Yosɛfu naa tuɔ kãalã Diiloŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","U nabaambaŋ ciɛ kumaŋ Yesu‑i-na, u saa siɛ dii u nuŋgu‑i baa-ba. U taa u hel Arimate. Yuifu ba nelle nande'i difande‑i. U taa u niya *Diiloŋ-bãaŋgu domma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Yesuŋ kuu, wuɔ kã *Pilati wulaa ka cãrã-yuɔ. Pilati wuɔ hã-yo baa-yo. ");
INSERT INTO cmeNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Wuɔ kã ka har-o a fĩnya-yuɔ aa kã ka fuure-yuɔ cĩncorre nande-na, baa hĩɛŋ-de tãmpɛ̃lleŋ. Baa sa fuure moloŋo diɛ dede. ");
INSERT INTO cmeNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Yiiŋgu faŋgu waa jumayiiŋgu, Yuifu ba *yitĩɛnaŋgu naa saaya ku doŋ bãsuuruŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Caamba maŋ naa hilaa *Galile‑i-na a nyaanu Yesu‑i, baa cu Yosɛfu huoŋ-nu ka ne baŋ naana dumaa. ");
INSERT INTO cmeNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Baŋ kaa nanna tĩ, baa bir kũŋ da ba ka taara nantiilma baa natikolo ka kũnna-yuɔ. Baŋ'a ba ce mafamma‑i bãl, bãaŋgu suurii tĩ. Yitĩɛnaŋgu hii. Baa tĩɛna fiisa ŋaa maŋ nyɛgãaŋ dumaa *ãnjĩnamma-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","*Yitĩɛnaŋgu cuo kaala‑i-na, caaŋ daaba naar kã cĩncorre-na baa natikolo‑i ");
INSERT INTO cmeNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","kã ka da tãmpɛ̃lle maŋ baŋ ŋa naa ce-de suu cĩncorre nuŋgu‑i di bũmalãa halaŋ. ");
INSERT INTO cmeNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ba suurii ku yaa‑i, ba saa da kuloŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ba hɔŋ muɔ cu, ba'a ba ne da nuɔmba hãi, ba joŋgorbaa-ba caa da kpɛikpɛi. ");
INSERT INTO cmeNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Kor maa ta ma da-ba, baa nisĩŋ ba yammu‑i. Nuɔŋ daa baa gbɛ̃-ba wuɔ: «Bige‑i ciɛ na jo ji ta na taara umaŋ dii cicɛ̃lma‑i bikuoŋ hɔlma-na? ");
INSERT INTO cmeNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Uu si dii bande‑i, u siire hel. Uŋ taa u waŋ mamaŋ baa-na *Galile‑i-na, ma tĩyãanu-nɛi wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ma sĩ uu naa cira: ‹Fuɔ ba hã nelbabalaamba baa *Moloŋ-Biɛŋo‑i ba gbu-yo *daaŋ-nu ko-yo. Da ba ko-yo, u ka ce yinni hãi yoŋ hĩɛma-na, siɛliŋ-yiiŋgu‑i u ka sire hel jo.› Ma saa waŋ wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Yesu nel maa pãŋ tĩɛnu-bɛi. ");
INSERT INTO cmeNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Baa ta kũŋ ka tũnu u *hãalãbiemba‑i ba kũŋgu-na hiere. ");
INSERT INTO cmeNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Caamba maŋ waa da mafamma‑i ba yirɛiŋa yaa daaya: Maari maŋ taa u hel Magidala‑i-na u waa, a naara u duoŋo‑i Sake nyu‑i, baa Sani, a naara caamba namba. Ba yaa daa-ma aa kã ka tũnu Yesu *pɔpuɔrbiemba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Baŋ tũɔnu-bɛi, pɔpuɔrbiemba da niɛ sĩ ba ce kɔrni; ba saa hũu-ma. ");
INSERT INTO cmeNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Piɛr wuɔ sire gbar kã cĩncorre-na ka gbĩina ne, a da kompaŋga yaa yoŋ hĩɛma-na. U huɔŋ kaa cu, wuɔ naa wuɔ bir kũŋ. ");
INSERT INTO cmeNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Yinduɔŋgu faŋgu-na, bamaŋ taa ba nyaanu Yesu‑i, ba hãi baa sire ta ba kã nelle nande-na, ba bĩ-de Emawusi. Di hɔlma yuu kilobaa cĩncieluo u diei temma baa *Yerusalɛmu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ba taa ba piiye Yesu maama yaa‑i ba kã. ");
INSERT INTO cmeNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Yesu wuɔ jo ji hi-ba ba gbonu. ");
INSERT INTO cmeNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ba daa moloŋo‑i, ŋga ba yammu cuu-yuɔ, ba saa suɔ-yo. ");
INSERT INTO cmeNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yesu wuɔ yuu-ba wuɔ: «Na waŋ wuɔ niɛ?» Baa yiɛra, ba yammu gbuu vãa hiere. ");
INSERT INTO cmeNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Unaŋo‑i ba taa ba bĩ-yo Kilopasi. Fuɔ wuɔ cira: «Ku ce naŋ saa nu mamaŋ ciɛ Yerusalɛmu‑i-na yiŋ daani-na wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yesu wuɔ yuu-ba wuɔ: «Bige‑i ciɛ?» Baa cira: «Mamaŋ daa Nasarɛtitaaŋ Yesu‑i, naŋ saa nu-ma wɛi? Da ŋ nu wuɔ *Diilopɔpuɔrbiloŋo‑i, u yaa waa naacolŋ daayo‑i. Uŋ taa u ce mamaŋ hiere, ma taa ma dɔlnu Diiloŋo‑i aa bi ta ma dɔlnu nelbiliemba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","*Diilojigãntaamba yuntaamba‑i, baa i yuntaamba hãa sorosibaa-ba‑i baa-yo wuɔ ba ko-yo. Ba bel-o gbu-yo *daaŋ-nu ko-yo. ");
INSERT INTO cmeNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ii naa haa i naŋga‑i u yaa nuɔ‑i wuɔ u'i ka kor *Isirahɛl-baaŋ miɛŋo‑i. Ŋga ba kuɔ-yo ku yinni siɛi yaa nyuŋgo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Caamba maŋ dii baa-ye, banamba naaraa kã cĩncorre-na, aa jo ji tiraa cu i hɔmmu‑i ");
INSERT INTO cmeNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","wuɔ ba saa ka da-yo. Aa tiraa cira *dɔrpɔpuɔrbiemba kaa carra-bɛi a waŋ baa-ba wuɔ u siire hel. ");
INSERT INTO cmeNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Baŋ piiye dumaaŋo-na, i nabaamba namba bi sire kã ka da-ma ŋaa baŋ waaŋ-ma dumaa. Ba saa da Yesu yufelle.» ");
INSERT INTO cmeNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yesu wuɔ waŋ baa-ba wuɔ: «Namaaŋo‑i, na sa gbuu suɔ ku yuŋgu. Na sa hũu nɛliɛŋ maama donduo. Diilopɔpuɔrbiemba saa waŋ-ma baa-na wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ba saa waŋ-ma wuɔ Diiloŋ uŋ pãa nuŋgu‑i wuɔ u ka saaŋ *Koŋkortieŋo maŋ, duɔ jo, u ka ce sũlma aa suɔ doŋ u yuntesĩnni‑i wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Baŋ nyɛgãaŋ u maama maŋ Diiloŋ-nelma-na, wuɔ suur ma yaaŋga-na tuɔ waŋ-ma baa-ba. U duɔŋ *Moisi sɛbɛbaa-ba yaa nuɔ‑i ka cor baa Diilopɔpuɔrbiemba baamba‑i hiere, aa baa cor ta ba kã. ");
INSERT INTO cmeNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Baŋ kaa hi Emawusi‑i, Yesu wuɔ ce ŋaa u cor yaaŋ-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ba saa hũu-ma u duɔ cor; aa naa cira: «Bãaŋgu tĩɛ tĩ, yaŋ aa ŋ haar ŋ cɔ bande.» Yesu wuɔ haar duɔ ka cɔ baa-ba. ");
INSERT INTO cmeNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Baŋ juɔ cira ba wuo niiwuoni‑i, wuɔ biɛ *buruo‑i aa jaal Diiloŋo‑i, aa bũl-oŋ hã-ba. ");
INSERT INTO cmeNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Huɔŋgu faŋgu-na, ba yammu suɔ kaala-yuɔ baa suɔ-yo. Baŋ bi suyaa-yo terieŋgu maŋ nuɔ‑i, ba'a ba ne naa-yo. ");
INSERT INTO cmeNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Baa ta ba piiye wuɔ: «Uŋ taa u piiye Diiloŋ-sɛbɛ maama‑i baa-ye hũmelle-na huɔŋgu maŋ nuɔ‑i, i hɔmmu naa gbuu fɛ̃ ŋaa ba kũɔna hũŋhĩnaŋo muɔ.» ");
INSERT INTO cmeNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ba saa tiraa tĩɛna, baa pãŋ sire bir kã Yerusalɛmu‑i-na kã ka da *hãalãbiemba maŋ tĩyãa cĩncieluo u diei, ba tigiiŋ ba-naa, a naara ba nabaamba namba. ");
INSERT INTO cmeNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Baŋ kãa ka da bamaŋ, baa cira: «Itieŋo siire ninsoŋo, Simɔ daa-yo.» ");
INSERT INTO cmeNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Bafambaŋ bi daa mamaŋ Emawusi hũmelle-na, baa bi suur ma yaaŋga-na waŋ-ma. Aa naa cira: «U juɔ tuɔ calnu buruo yaa i suɔ suɔ-yo.» ");
INSERT INTO cmeNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","*Hãalãbieŋ baŋ waa ta ba piiye, ba'a ba ne da Yesu fuɔ fɛrɛ‑i ba hɔlma-na. Wuɔ waŋ baa-ba wuɔ: «Tĩyãaŋ dɛi!» ");
INSERT INTO cmeNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Korma pãŋ ta ma da-ba wuɔ sĩ *jĩna. ");
INSERT INTO cmeNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Yesu wuɔ cira: «Bige‑i kormaŋ-kũŋgu fuɔ? Bige‑i ciɛ na ta na dii nuharuŋgu miɛ? ");
INSERT INTO cmeNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Niɛŋ mi nammu‑i baa mi gbeini‑i. Muɔmɛi mi fɛrɛ! Juɔŋ na ji yiɛya-miɛ na ne. Jĩna muɔ sĩ. Jĩna dii ŋaa fafalmu; kũɔma si dii-yuɔ, kokonni bi si dii-yuɔ, ŋga ni yaa daani muɔmi-na.» ");
INSERT INTO cmeNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Uŋ taa u waŋ mafamma‑i, wuɔ tuɔ pigãaŋ-ba u nammu‑i baa u gbeini‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ba hɔŋ muɔ gbuu fɛ̃ da yogogo, ŋga ba saa hũu-ma wuɔ u yaa‑i. Baa yiɛra kar da hãmmu! Yesu wuɔ yuu-ba wuɔ: «Kuuwuoŋgu dii baa-na bande‑i-na wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Teterieŋo naŋo waa boluoŋgu, baa hĩɛ-yo, baa biɛ-yo hã-yo. ");
INSERT INTO cmeNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Wuɔ hũu-yo wuo-yo ba yufelle-na. ");
INSERT INTO cmeNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Aa naa waŋ baa-ba wuɔ: «Miŋ taa mi waŋ mamaŋ baa-na i wuɔramma-na, ma'i sĩ daama‑i wɛi? Mi maama maŋ nyɛgãaŋ *Moisi *ãnjĩnamma-na, baa *Diilopɔpuɔrbiemba sɛbɛbaa-ba-na a naara gbɛliɛmaŋ-nɛini-na, maa naa saaya ma ce; ma bi ciɛ.» ");
INSERT INTO cmeNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Uŋ piiye dumaaŋo-na, kuɔ kãyã-bɛi ba suɔ Diiloŋ-nelma yaaŋga‑i. ");
INSERT INTO cmeNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Uŋ waaŋ mafamma‑i, wuɔ cira: «Baŋ nyɛgãaŋ mamaŋ, ba ciɛra wuɔ: Diiloŋ uŋ pãa nuŋgu‑i aa saaŋ *Koŋkortieŋo maŋ, u saaya u ku a ce yinni hãi hĩɛma-na aa siɛliŋ-yiiŋgu-na u sire hel kuomba hɔlma-na ");
INSERT INTO cmeNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","aa nuɔmba ka nu u maama‑i nilɛiŋa-na hiere ka saa. Ba ka doŋ ta ba waŋ-ma *Yerusalɛmu yaa nuɔ‑i wuɔ nuɔmba nanna ba cilɔbabalaŋo‑i, ku yaa Diiloŋo ka ce jande ba ãmbabalma-na hiere. ");
INSERT INTO cmeNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Mamaŋ ciɛ daama‑i hiere, namɛi daa-ma, namɛi saaya na wuɔra waŋ-ma. ");
INSERT INTO cmeNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Terieŋgu faŋgu-na, mi To uŋ pãa nuŋgu‑i wuɔ u ka hã-na fɔ̃ŋgũɔ maŋ, da mi kã, mi ka saaŋ-yo hã-na. Baa na kã terieŋgu; tĩɛnaanaŋ na cie u jo igɛ̃na.» ");
INSERT INTO cmeNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ku huoŋgu-na, Yesu wuɔ ce ba hel *Yerusalɛmu-huɔŋga-na a kã Betani caaŋ-nu. Baŋ kaa hi, wuɔ sire u nammu‑i dɔrɔ tuɔ cãrã Diiloŋo‑i u hã-ba. ");
INSERT INTO cmeNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ba juɔ'a ba ne da u nyugũŋ dɔrɔ. ");
INSERT INTO cmeNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Baa jaal-o aa naa ta kũŋ, ba hɔmmu gbuu fɛ̃ da yogogo. ");
INSERT INTO cmeNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ba saa ta ba naa *Diilodubuɔ‑i-na; ba taa ba kã ba jaal Diiloŋo‑i.");
INSERT INTO cmeNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ku domma-na, Nelma naa waa tĩ. Nelma naa waa baa Diiloŋo, aa maa naa waa Diiloŋo. ");
INSERT INTO cmeNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ku domma-na, Nelma naa waa baa Diiloŋo. ");
INSERT INTO cmeNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Diiloŋo ciɛ ma yaa ce bĩmbĩnni‑i hiere. Bĩmbĩnni maŋ ciɛ hiere, ma nuŋgu dii ni cemma-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Cicɛ̃lma waa Nelma yaa nuɔ‑i. Aa cicɛ̃lma famma yaa waa nelbiliemba fitĩnuɔ‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Fitĩnuɔ uŋ juɔ, kukulma saa gbãa cie-yo. ");
INSERT INTO cmeNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Huɔŋgu naŋgu juɔ hi, Diiloŋo saaŋ molo jo. Ba taa ba bĩ kutieŋo‑i Nsãa. ");
INSERT INTO cmeNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","U saaŋ-yo wuɔ u ji piiye fitĩnuɔ maama baa nuɔmba‑i kumaŋ ka ce ba hũu u maama‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ku saa ce ŋaa Nsãa yaa waa fitĩnuɔ‑i dɛ! Ŋga uu naa jo duɔ ji waŋ fitĩnuɔ maama yoŋ baa nelbiliemba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Nelma yaa waa ninsoŋ-fitĩnuɔ‑i. Ma juɔ hĩɛma-na ji kaala nuɔmba yammu‑i hiere. ");
INSERT INTO cmeNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Nelma waa tĩ miwaaŋo-na. Ma yaa jĩɛna miwaaŋo‑i. Ŋga nelbiliemba yagaraa-ma. ");
INSERT INTO cmeNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ma juɔ ma fɛrɛŋ nelle-na, ma nelleŋ-baamba cĩina-mɛi. ");
INSERT INTO cmeNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ŋga banamba siyaa-ma aa hũu ma maama‑i. Ma hãa kufaŋgu taamba‑i ku fɔ̃ŋgũɔ‑i ba da ba ce Diiloŋ-bisãlmba. ");
INSERT INTO cmeNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Diiloŋ-bisãlmba famba‑i ku saa ce ŋaa u huɔŋ-ba nelbiloŋ temma, ku saa bi ce ŋaa ku dɔlaanu moloŋo‑i u ce u hoŋ-ba, ŋga ku dɔlaanu fuɔ fɛrɛ yaa u hoŋ-ba. ");
INSERT INTO cmeNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Nelma ciɛ ma fɛrɛ nelbiloŋo jo ji waa i hɔlma-na. I daa u fafaaŋgu‑i. U waa hujantieŋo aa tiraa waa ninsowaraŋo. Fafaaŋgu faŋgu‑i i To‑i hãa u Bɛduɔla‑i baa-ku. ");
INSERT INTO cmeNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Nsãa yaa juɔ ji tuɔ waŋ u maama‑i. U taa u piiye baa nuɔmba‑i wuɔ: «Miŋ taa mi gbɛ̃ umaŋ miɛ uu dii huoŋ-nu, u yaa daayo‑i. Aa mɛi suɔ da mi hoŋ, uu naa waa tĩ; a ce dumaaŋo-na u maaraa muɔŋo‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","U ciɛ baa-ye cor. Cuobaa-baŋ kaal, u bi ce baa-ye dumɛi. ");
INSERT INTO cmeNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","*Moisi yaa juɔ baa *ãnjĩnamma‑i ji hã-ye, ŋga hujarre‑i baa ninsoŋo‑i, Yesu-Kirsa yaa juɔ baa-ni. ");
INSERT INTO cmeNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Moloŋ yufelle saa haa Diiloŋo-na dede. Ŋga u Bɛduɔla pigãaŋ-ye u sĩnni‑i. U yaa dii tĩɛna baa-yo. ");
INSERT INTO cmeNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Nsãa nuŋ-ãndaaŋgu yaa daaku. Uŋ waa tuɔ *batiseŋ nuɔmba‑i, *Yuifu ba yuntaamba maŋ waa *Yerusalɛmu‑i-na, baa puɔr *Diilojigãntaamba namba‑i baa *Levitibaa-ba namba‑i wuɔ ba ka yuu u sĩnni‑i. Baŋ kãa ka hi, baa cira: «Naacolŋ nuɔ, naŋ hilaa hie?» ");
INSERT INTO cmeNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Nsãa saa fuo ma diei bɛi; wuɔ cira: «Baa na ta na ne wuɔ sĩ Diiloŋ uŋ pãa nuŋgu‑i wuɔ u ka saaŋ *Koŋkortieŋo maŋ, u yaa juɔ muɔŋo‑i, muɔ sĩ.» ");
INSERT INTO cmeNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Baa cira: «Nuɔnɛi *Eli‑i wɛi?» Nsãa wuɔ cira: «E'e, muɔ sĩ.» Baa cira: «Nuɔnɛi *Diilopɔpuɔrbiloŋ nuɔŋo‑i wɛi?» Wuɔ cira: «E'e.» ");
INSERT INTO cmeNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Baa cira: «A naŋ hilaa hie? Nuɔmba'i puɔraa-ye; pigãaŋ-ye ŋ sĩnni‑i i ka tũnu-bɛi.» ");
INSERT INTO cmeNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Nsãa wuɔ siɛ-ba baa *Isayi ãndaaŋ daaku‑i wuɔ: «Muɔmɛi hohuolaayaŋ *hĩɛkuraaŋgu-na wuɔ: ‹Siireŋ na cãa Itieŋo hũmelle‑i›.» ");
INSERT INTO cmeNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","*Farisĩɛbaa-ba waa pɔpuɔrbieŋ daaba hɔlma-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Baa cira: «Ŋ ciɛra wuɔ Diiloŋ uŋ pãa nuŋgu‑i wuɔ u ka saaŋ Koŋkortieŋo maŋ, u'i sĩ nuɔŋo‑i, aa cira Eli'i sĩ nuɔŋo‑i aa tiraa cira Diilopɔpuɔrbiloŋo'i bi sĩ nuɔŋo‑i; a ma bilaa niɛ ŋ ta ŋ batiseŋ nuɔmba‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Nsãa wuɔ cira: «Muɔmi batiseŋ-na baa hũmma yoŋ, ŋga moloŋo naŋo dii na hɔlma-na, na sa suɔ-yo. ");
INSERT INTO cmeNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Mi juɔ yaaŋga kufaŋgu tieŋo-na, ŋga mi saa piɛra u natãaŋgu‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Nel daama‑i hiere ma ciɛ Betani. Nsãa taa u batiseŋ nuɔmba‑i kusuɔŋ-nu'i, dii *Yurdɛ̃ bomborma-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ku cuo kaala‑i-na, Nsãa wuɔ u ne da Yesu jo u wulaa. Wuɔ cira: «*Diiloŋ-Tũmbiloŋo yaa juɔŋ daayo. U yaa piriiŋ nelbiliemba ãmbabalma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Mi taa mi gbɛ̃ u yaa‑i miɛ uu dii huoŋ-nu, ŋga u taa yaaŋga muɔŋo-na, a ce dumaaŋo-na u maaraa-mi. ");
INSERT INTO cmeNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Mɛi saa ta mi suɔ-yo, ŋga mi juɔ ji ta mi *batiseŋ nuɔmba‑i hũmma‑na da mi ce *Isirahɛl-baamba suɔ-yo.» ");
INSERT INTO cmeNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Uŋ waaŋ mafamma‑i, u cira: «Mi daa *Diiloŋ-Yalle hilaa dɔrɔ‑i-na koŋhuruŋ temma jo ji diire-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Mi saa ta mi suɔ-yo. Ŋga umaŋ puɔraa-mi wuɔ mi ji batiseŋ nuɔmba‑i hũmma‑na, uu naa gbɛ̃-mi wuɔ: ‹Da ŋ ji da mi Yalle hiiriiye ji diire umaŋ nuɔ‑i, u yaa ka tuɔ batiseŋ nuɔmba‑i baa-de.› ");
INSERT INTO cmeNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Mi daa mafamma‑i nuɔ baa mi yufelle. Mi siɛ fuo-ma: Naacolŋ daa u yaa Diiloŋ-Biɛŋo‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ku cuo kaala‑i-na, Nsãa wuɔ tiraa kã baa u *hãalãbiemba hãi terduɔŋgu faŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","U juɔ'a u ne da Yesu cor. Wuɔ cira: «*Diiloŋ-Tũmbiloŋo yaa kãaŋ daayo!» ");
INSERT INTO cmeNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Hãalãbieŋ daabaŋ nuɔ mafamma‑i, baa pãŋ ta cu Yesu huoŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesu wuɔ u miɛl ne ku yaa nuɔ‑i, a da-ba u huoŋgu-na. Wuɔ yuu-ba wuɔ: «Kuu dii niɛ?» Baa cira: «Arabi, ŋ haraa hie?» (Arabi yuŋgu yaa wuɔ hãalãtie.) ");
INSERT INTO cmeNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yesu wuɔ cira: «Juɔŋ i ta, na ka suɔ-ku.» Baa kã baa-yo ka suɔ uŋ haraa kusuɔŋ-nu. Bãaŋgu naa tɛrɛŋ tĩ, baa pãŋ perieŋ bãaŋgu boluoŋgu‑i baa-yo. ");
INSERT INTO cmeNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Hãalãbieŋ daaba‑i ba hãi‑i-na, ba taa ba bĩ unaŋo‑i Ãndere, Simɔ-Piɛr hãaŋo'i waa. ");
INSERT INTO cmeNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Fuɔ wuɔ ta kã mɔlŋo yaa wulaa‑i igɛ̃na ka waŋ baa-yo wuɔ: «Diiloŋ uŋ pãa nuŋgu‑i wuɔ u ka saaŋ *Koŋkortieŋo maŋ, i daa-yo.» (Ba bĩ u yaa‑i *Kirsa‑i girɛkimma-na.) ");
INSERT INTO cmeNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Aa naa kã baa Simɔ‑i Yesu wulaa. Yesu wuɔ ne-yo aa naa cira: «Nsãa biɛŋ nuɔ, ba bĩ-ni Simɔ; i ka tiɛ bĩ-ni fiɛfiɛ‑i-na Sefasi.» (Sefasi yuŋgu yaa wuɔ tãmpɛ̃lle.) ");
INSERT INTO cmeNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ku cuo kaala‑i-na, Yesu wuɔ cira u kã *Galile. Uŋ hilaa, wuɔ suu baa naacolŋo naŋo‑i ba bĩ-yo Filipu; wuɔ gbɛ̃-yo wuɔ: «Filipu, jo i ta!» ");
INSERT INTO cmeNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipu taa u hel Betisada. Ba taa ba hel neduɔle baa Ãndere‑i baa Piɛr hiere. ");
INSERT INTO cmeNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ku huoŋgu-na, Filipu wuɔ bi kã ka da Natanayɛl; wuɔ gbɛ̃-yo wuɔ: «*Moisi‑i baa *Diilopɔpuɔrbieŋ baŋ waaŋ naacolŋo maŋ maama‑i ba sɛbɛbaa-ba-na, i daa-yo. Ba bĩ-yo Yesu, Nasarɛtitaaŋ Yosɛfu biɛŋo.» ");
INSERT INTO cmeNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanayɛl wuɔ cira: «Niŋ huɔŋ, ŋ nuɔ ba'a bĩŋkũfafaaŋgu hilaa Nasarɛti‑i-na dede wɛi?» Filipu wuɔ cira: «Jo i ta ŋ ka da baa ŋ yufelle.» ");
INSERT INTO cmeNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yesuŋ juɔ'a u ne da Natanayɛl jo, wuɔ cira: «*Isirahɛlyiɛŋ kerre yaa daade‑i; huhurma diei maa si dii-yuɔ.» ");
INSERT INTO cmeNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanayɛl wuɔ yuu-yo wuɔ: «Naŋ suyaa muɔ hie?» Yesu wuɔ cira: «Aa Filipu suɔ duɔ bĩ-ni, mii naa da-ni *yensãaŋgu yuŋgu-na.» ");
INSERT INTO cmeNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Uŋ waaŋ mafamma‑i, Natanayɛl wuɔ cira: «Hãalãtie, Diiloŋ-Biɛŋo yaa nuɔŋo‑i, *Isirahɛl-baamba nellentieŋo yaa nuɔŋo‑i!» ");
INSERT INTO cmeNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesu wuɔ cira: «Miŋ ciɛra mi daa-ni yensãaŋgu yuŋgu-na ku'i ciɛ ŋ hũu mi nelma‑i. Yiiŋgu dii baa yiiŋgu, ŋ ka da mamaŋ maaraa daama‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Aa naa cira: «Mi waŋ ninsoŋo‑i baa-na: Yiiŋgu dii baa yiiŋgu na ka da dɔrɔ puurii aa *dɔrpɔpuɔrbiemba ta ba nyugũŋ aa ta ba hiire *Moloŋ-Biɛŋo yudɔrɔ‑i-na.» ");
INSERT INTO cmeNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Yesuŋ bĩɛ Filipu‑i baa Natanayɛl, yiiŋgu diei cor, hãalĩŋ-yiiŋgu-na, ba ta ba jã ciɛŋo dii nelle nande-na ba bĩ-de Kana; dii dii *Galile huɔŋ-na. Yesu nyu waa kãlle fande-na ");
INSERT INTO cmeNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","a naara Yesu‑i baa u *hãalãbiemba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Huɔŋgu naŋgu juɔ hi, ba kolma yor. Yesu nyu wuɔ gbɛ̃-yo wuɔ: «Ba kolma yuraa.» ");
INSERT INTO cmeNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesu wuɔ cira: «Nnaa, yaŋ-ma ŋ hã muɔ, ku saa hi mi wulaa yogo.» ");
INSERT INTO cmeNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Nyuŋ wuɔ waŋ baa maacembiemba‑i wuɔ: «Duɔ waŋ mamaŋ baa-na, na ce-ma.» ");
INSERT INTO cmeNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","A ne da bɔ̃ɛŋa naŋa waa terieŋgu-na; baa naa jĩna-yɛi ta ba dii hũmma ba saara ba fɛrɛ a saa baa *Yuifu ba Diiloŋ-hũmelle‑i. A waa bɔ̃ɛŋ niediei. Di diei gbãa yu litiribaa komuɔŋa ndii temma. ");
INSERT INTO cmeNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesu wuɔ waŋ baa maacembiemba‑i wuɔ: «Kãaŋ na ka hu hũmma na ji dii bɔ̃ɛŋ daaya yu.» Baa kã ka hu hũmma‑i ji dii bɔ̃ɛŋa yu. ");
INSERT INTO cmeNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Wuɔ gbɛ̃-ba wuɔ: «Kaaŋ manamma na ka hã umaŋ niɛŋ niiwuoni‑i.» Ba kaa ka hã-yo. ");
INSERT INTO cmeNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Hũmma birii kolma! Wuɔ hũu nyɔŋ, u saa suɔ maŋ hilaa kusuɔŋ-nu. Maacembiemba fuɔ ba suyaa. Wuɔ bĩ dɔrbiɛŋo‑i ");
INSERT INTO cmeNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","a ji tuɔ piiye baa-yo wuɔ: «Kolma maŋ dɔlaaŋ, ba hã nuɔmba‑i ma yaa‑i igɛ̃na. Da ba ji nyɔŋ ye, ba suɔ hã-ba mamaŋ sa dɔlaaŋ. Nuɔ fuɔ, naŋ bir yaŋ kondɔdɔlma‑i ji ta ŋ hã-ba baa-ma huoŋ-nu!» ");
INSERT INTO cmeNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yesu kaaŋ ce hiŋ daama yaa‑i. U ciɛ-ma Kana dii Galile mara nuɔ. U pigãaŋ u fɛrɛ pigãaŋ daama temma yaa‑i u hãalãbiemba hũu u maama‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Uŋ hilaa terieŋgu-na, u kã Kafarnamu ka ce yinni cɛllɛ. U nyu waa baa-yo baa u hãmba‑i a naara u hãalãbiemba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","*Yuifu ba *kɔrsĩnni tĩmmaŋ-ponsaaŋguŋ juɔ ta ku piɛ, Yesu wuɔ kã *Yerusalɛmu‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Uŋ kãa, wuɔ kã ka da ba suor niimba baa tũlmba baa nɔnsɔr ba huriimba *Diilodubuɔ‑i-na. Aa da bamaŋ huraaŋ gbeiŋa‑i ba tĩɛnaana ba taabalebaa-ba canni-na ta ba hor gbeiŋa‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Wuɔ ce iyiemba a pãl comelle a muo-ba hiere donya-bɛi hiel-ba Diilodubuɔ‑i-na baa ba niimba‑i baa ba tũlmba‑i hiere. Aa naa sɛ gbeihortaamba taabalebaa-ba‑i nanna baa ba gbeiŋa‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Aa gbɛ̃ bamaŋ taa ba suor nɔnsɔr ba huriimba‑i wuɔ: «Biyaaŋ na huriimba‑i na hiel-ba bande‑i-na; baa na ce mi To dũŋgu‑i gbeitaara-terieŋgu.» ");
INSERT INTO cmeNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Uŋ ciɛ mafamma‑i, mamaŋ nyɛgãaŋ Diiloŋ-nelma-na wuɔ: «Diilo, mi kuye ŋ dũŋgu maama‑i. Ma gbu ma ko-mi», nelma faŋ maa tĩɛnu u *hãalãbiemba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Yuifubaa baa yuu-yo wuɔ: «Ŋ ka ce hiŋ hama‑i pigãaŋ-ye i suɔ wuɔ niŋ ciɛ mamaŋ daama‑i, ba hãa-ni hũmelle‑i aa ŋ suɔ ce-ma?» ");
INSERT INTO cmeNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesu wuɔ gbɛ̃-ba wuɔ: «Muyaanuŋ Diilodubuɔ‑i, na ka da mi maa-yo yinni siɛi hɔlma-na yoŋ.» ");
INSERT INTO cmeNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Baa cira: «Baŋ maa bĩŋkũŋgu maŋ bieŋ komuɔŋa hãi baa niediei, naŋ'a naŋ ka ma-ku yinni siɛi hɔlma-na yoŋ!» ");
INSERT INTO cmeNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Yesuŋ taa u waŋ Diilodubuɔ maŋ maama‑i, u yaa fuɔ fɛrɛŋ kerre‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Uŋ juɔ ku aa sire, nelma faŋ maa tĩɛnu u *hãalãbiemba‑i; baa pãŋ hũu mamaŋ nyɛgãaŋ hiere Diiloŋ-nelma-na baa Yesuŋ waaŋ mamaŋ hiere. ");
INSERT INTO cmeNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yesuŋ kãa *Yerusalɛmu‑i-na, u ciɛ gbɛrɛ-wɛima bɔi *kɔrsĩnni tĩmmaŋ-ponsaaŋgu yinni-na. A ce dumaaŋo-na, nuɔmba maŋ daa gbɛrɛ-wɛiŋ daama‑i, ba fɔ̃ŋgũɔ baa hũu u maama‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ŋga Yesu naa konnu-bɛi, a ce u saa haa u naŋga bɛi. ");
INSERT INTO cmeNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Fuɔ fɛrɛ taa u suɔ nelbiloŋo kusũŋgu‑i, u saa waa duɔ ka yuu moloŋo wuɔ mɛlŋo dii niɛ? ");
INSERT INTO cmeNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","*Farisĩɛyiɛŋo naŋo waa ba taa ba bĩ-yo Nikodɛmu; u waa *Yuifu ba yuntieŋo. ");
INSERT INTO cmeNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Isuɔŋgu naŋgu-na, wuɔ sire kã Yesu wulaa ka cira: «Hãalãtie, i suyaa yiɛ nuɔŋo‑i Diiloŋo'i puɔraa-ni baa u nelma‑i; ni ma'i sĩ niŋ ceŋ gbɛrɛ-wɛima maŋ daama‑i, nelgbãŋgbãlãaŋ siɛ gbãa ce-ma.» ");
INSERT INTO cmeNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesu wuɔ cira: «Yaŋ mi waŋ ninsoŋo‑i baa-ni: Umaŋ duɔ saa puma hoŋ fɛlɛmma, kutieŋo yufelle siɛ gbãa haa *Diiloŋ-nelle-na.» ");
INSERT INTO cmeNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodɛmu wuɔ yuu-yo wuɔ: «Nɛliɛŋo maŋ vãa tĩ, u ce niɛ gbãa puma hoŋ fɛlɛmma‑i? U gbãa bir suur u nyu kusũŋgu-na u tiraa hoŋ-yo wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesu wuɔ cira: «Yaŋ mi waŋ ninsoŋo‑i baa-ni: Umaŋ duɔ saa hoŋ hũmma-na baa *Diiloŋ-Yalle-na, kutieŋo siɛ gbãa suur Diiloŋ-nelle-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Da ŋ hoŋ nelbiloŋ homma‑i, nelbiloŋ huɔŋga'i waaŋ-niɛ, da ŋ bi hoŋ Diiloŋ-Yalleŋ homma‑i, Diiloŋ-Yalleŋ huɔŋga'i waaŋ-niɛ. ");
INSERT INTO cmeNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Miŋ ciɛra na puma hoŋ fɛlɛmma‑i, baa yaŋ ma cu ŋ huɔŋga‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ŋ saa da, terieŋgu maŋ da ku dɔlnu fafalmu‑i mu sire; da ŋ ji cira ŋ suɔ, ŋ da mu du; ŋ siɛ suɔ muŋ hilaa kusuɔŋ-nu, ŋ siɛ bi tiraa suɔ muŋ kãŋ kusuɔŋ-nu. Bamaŋ huɔŋ Diiloŋ-Yalle homma‑i baa dii dumɛi.» ");
INSERT INTO cmeNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodɛmu wuɔ yuu-yo wuɔ: «Nel daama gbãa ce niɛ ce?» ");
INSERT INTO cmeNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesu wuɔ cira: «Ŋ siɛ suɔ wuɔ nelpigãatieŋ nuɔ *Isirahɛl-na, nel daama ciɛ niɛ yar-ni suɔma? ");
INSERT INTO cmeNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Yaŋ mi waŋ ninsoŋo‑i baa-ni: Iŋ suɔ mamaŋ, i piiye ma yaa‑i; aa iŋ daa mamaŋ, i waŋ ma yaa‑i aa na sa taara na hũu-ma. ");
INSERT INTO cmeNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nelma maŋ ciɛŋ hĩɛma-na bande‑i-na, da mi waŋ-ma na sa hũu-ma, na ka ce niɛ gbãa hũu dɔr-maama‑i mi wulaa? ");
INSERT INTO cmeNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Molo saa kã dɔrɔ‑i-na dede, da ku saa waa *Moloŋ-Biɛŋo yaa‑i. U yaa hilaa dɔrɔ‑i-na jo. ");
INSERT INTO cmeNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","*Moisi naŋ haa kɔvɛ̃lluŋ-jĩɛŋo‑i daaŋgu-na dumaa *hĩɛkuraaŋgu-na, ba ka bi haa Moloŋ-Biɛŋo‑i daaŋgu-na dumɛi. ");
INSERT INTO cmeNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ku yaa bamaŋ hũyãa u maama‑i, ba ka da cicɛ̃lma maŋ sa tĩɛŋ dede‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Na saa da, nelbiliemba maama gbuu silaa dɔlnu Diiloŋo‑i u naa u hã-ba u Bɛduɔla‑i wuɔ umaŋ duɔ hũu u maama‑i, kutieŋo baa ka caa, ŋga u da cicɛ̃lma maŋ sa tĩɛŋ dede. ");
INSERT INTO cmeNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Diiloŋo saa saaŋ u Biɛŋo jo hĩɛma-na duɔ ji kɔsuɔŋ nelbiliemba‑i, ŋga u saaŋ-yo wuɔ u ji kor-ba. ");
INSERT INTO cmeNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Umaŋ duɔ hũu Diiloŋ-Biɛŋo maama‑i, ba sa ka yuu kutieŋo‑i baa wɛima. Ŋga umaŋ duɔ saa hũu-ma, kumaŋ ciɛ u saa hũu Diiloŋ-Bɛduɔla maama‑i, Diiloŋo ka gãŋ baa-yo. ");
INSERT INTO cmeNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Kumaŋ juɔ baa kufaŋgu‑i ku yaa daaku: Fitĩnuɔ juɔ miwaaŋo-na, ŋga nelbiliemba ciluɔŋ balaaŋ dumaaŋo-na, ba bir yaŋ aa par kukulma. ");
INSERT INTO cmeNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Nɛliɛŋo maŋ duɔ tuɔ ce kuubabalaaŋgu‑i, cecerma sa dɔlnu-yuɔ. U sa taara u carra wuɔ ba ka da u cilɔbabalaŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ŋga nelfɛfɛiŋo sa fuo; u ce u wɛima‑i hiere cecerma-na wuɔ nuɔmba da uŋ ceŋ Diiloŋo huɔŋga‑i dumaa.» ");
INSERT INTO cmeNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ku huoŋgu-na, Yesu wuɔ ji kã *Yude baa u *hãalãbiemba‑i ka tuɔ *batiseŋ nuɔmba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","*Nsãa waa terieŋgu naŋgu-na bi tuɔ batiseŋ. Ba bĩ terieŋgu faŋgu‑i Ayinɔ. Kuu dii Salimu caaŋ-nu. Hũmma waa bɔi terieŋgu-na ku'i ciɛ Nsãa wuɔ kã ka waa terieŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Huɔŋgu faŋgu-na, ba saa naa hi dii-yo kaso‑i-na yogo. ");
INSERT INTO cmeNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Yiiŋgu naŋgu-na, u hãalãbiemba namba ji ta ba fanu ba-naa baa *Yuifuyiɛŋo naŋo‑i nɛliɛŋ nuɔ niŋ saaya ŋ migãaŋ ŋ fɛrɛ dumaa a saanu baa Yuifu ba Diiloŋ-hũmelle‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Baa kã ka gbɛ̃ Nsãa‑i wuɔ: «Hãalãtie, niŋ waaŋ naacolŋo maŋ maama‑i baa-ye; umaŋ waa baa-ni dii *Yurdɛ̃ bomborma namma-na, u duɔŋ tuɔ batiseŋ nuɔmba‑i, a ce dumaaŋo-na nuɔmba‑i hiere ba kã fuɔ yaa wulaa‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Nsãa wuɔ gbɛ̃-ba wuɔ: «Diiloŋ duɔ saa hã-ni baa kumaŋ, ŋ siɛ gbãa da-ku. ");
INSERT INTO cmeNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Namaa fɛrɛ‑i mi waaŋ-ma na yufelleŋ miɛ Diiloŋ uŋ pãa nuŋgu‑i wuɔ u ka saaŋ *Koŋkortieŋo maŋ, u'i sĩ muɔŋo‑i, ŋga u puɔraa muɔmi da mi jo u yaaŋ-na yoŋ.» ");
INSERT INTO cmeNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Uŋ waaŋ mafamma‑i, wuɔ naŋ gbãnalãaŋ daaku‑i baa-ba wuɔ: «Na suyaa wuɔ da ŋ ta ŋ jã ciɛŋo, ŋ huɔŋga gbuu fɛ̃ da yogogo wuɔ ŋ ka da hũnyɔmma. Ŋ jĩɛŋ duɔ ne da ŋ huɔŋga fĩɛ, ŋ bi da fuɔ kaaŋga fĩɛ. Muɔ mii dii ŋaa dɔrbiɛŋo jĩɛŋo'i baa-mi; mi huɔŋga fĩɛ gbarnu. ");
INSERT INTO cmeNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ku saaya kunaŋgu ta ku suur-yuɔ ku naara aa kunaŋgu cɛr ta ku hel muɔmi-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","«Umaŋ hilaa dɔrɔ‑i-na jo, uu dii nuɔmba‑i hiere ba yuŋ-nu. Umaŋ duɔ hoŋ hĩɛma-na, hĩɛmaŋ-wuoŋo, u waŋ hĩɛmaŋ-tĩmma. Umaŋ hilaa dɔrɔ‑i-na jo, uu dii nuɔmba‑i hiere ba yuŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Uŋ daa mamaŋ baa uŋ nuɔ mamaŋ, u waŋ ma yaa‑i, ŋga molo sa hũu u nelma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Umaŋ duɔ hũu u nelma‑i, kutieŋo pigãaŋ wuɔ Diiloŋo waŋ ninsoŋo. ");
INSERT INTO cmeNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Na saa da, Diiloŋ uŋ puɔraa umaŋ, u yuu kutieŋo huɔŋga‑i baa u *Yalle‑i, a ce dumaaŋo-na u waŋ Diiloŋ-nelma. ");
INSERT INTO cmeNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Bɛpolŋo maama dɔlnu Tuoŋo‑i a ce Tuoŋo diyaa wɛima‑i hiere u naŋ-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Umaŋ duɔ hũu Bɛpolŋo maama‑i, kutieŋo ka da cicɛ̃lma maŋ sa tĩɛŋ dede‑i. Ŋga umaŋ duɔ saa hũu Bɛpolŋo maama‑i, u siɛ da cicɛ̃lŋ daama‑i aa Diiloŋo tiraa gãŋ baa-yo.» ");
INSERT INTO cmeNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Nuɔmbaŋ kãŋ Yesu tuɔ *batiseŋ-ba, ba kã ka tũnu *Farisĩɛbaa-ba‑i wuɔ Yesu da nuɔmba u batiseŋ u yaŋ Nsãa‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","A ne da fuɔ saa tuɔ batiseŋ-ba u fɛrɛ, u *hãalãbiemba'i taa ba batiseŋ-ba. ");
INSERT INTO cmeNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Maŋ juɔ waa dumaaŋo-na, wuɔ sire *Yude‑i-na a bir tuɔ kã *Galile‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Uu naa saaya u karnu *Samari‑i cor. ");
INSERT INTO cmeNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Uŋ kãa ka hi tuɔ karnu, wuɔ kã ka suur nelle nande‑na ba bĩ-de Sikaar. Dii dii Yosɛfu suoŋgu caaŋ-nu. Suoŋgu faŋgu‑i *Yakɔbu yaa hãa Yosɛfu‑i baa-ku. ");
INSERT INTO cmeNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Yakɔbu kɔlɛŋo waa kusuɔŋ-nu'i. Yesuŋ wuɔyaa mulĩɛŋ dumaaŋo-na, wuɔ tĩɛna kɔlɛŋ daayo nuŋgu-na tuɔ fiisa. Bãaŋgu naa hi yuhuɔŋga‑i tĩ. ");
INSERT INTO cmeNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Samariciɛŋo naŋo jo duɔ ji hu hũmma. Yesu wuɔ cira: «Ciɛŋ nuɔ, ŋ sa hã-mi hũmma namma mi nyɔŋ wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","A ne da u hãalãbiemba naa kã nelleŋ-huɔŋ-na da ba ka sãa niiwuoni. ");
INSERT INTO cmeNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ciɛŋo gbɛ̃-yo wuɔ: «Ma sĩ *Yuifuyiɛŋ nuɔ kɛ? A bige‑i ciɛ ŋ ta ŋ cãrã hũmma‑i *Samariyiɛŋ muɔmi wulaa?» Ninsie ninsie, Yuifubaa-ba saa ta ba siɛ ba ce wɛima baa Samaritaamba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesu wuɔ cira: «Kuɔ ŋ taa ŋ suɔ Diiloŋ-caluɔ‑i aa suɔ umaŋ cãarãŋ hũmma‑i ŋ wulaa, nuɔnɛi naa bir cãrã u wulaa aa uu naa hã-ni cicɛ̃lmaŋ-hũmma.» ");
INSERT INTO cmeNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ciɛŋ wuɔ cira: «Kɔlɛŋo‑i filofilo dumandɛ‑i-na aa kɔlɛncaŋga bi sĩ baa nuɔ, naŋ ka da kufaŋgu cicɛ̃lmaŋ-hũmma‑i hie a hã muɔ baa-ma? ");
INSERT INTO cmeNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","I bĩncɔiŋo‑i Yakɔbu yaa birii kɔlɛŋ daayo‑i hã-ye, fuɔ fɛrɛ nyuɔŋ u hũmma‑i, u bisãlmba sire nyɔŋ-ma baa ba muɔru‑i hiere. Naŋ ne wuɔ sĩ naŋ maaraa Yakɔbu‑i wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesu wuɔ cira: «Umaŋ duɔ nyɔŋ hũŋ daama‑i, hũŋkuɔsĩnni ka tiraa bir bel-o. ");
INSERT INTO cmeNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ŋga muɔ da mi hã umaŋ mi hũmma‑i u nyɔŋ, ma ka ce hũnfoele kutieŋo huɔŋga-na, aa cicɛ̃lma maŋ sa tĩɛŋ dede ma'i ka ta ma hel hũnfoele fande-na, a ce dumaaŋo-na hũŋkuɔsĩnni cɛraa ni ji bel-o.» ");
INSERT INTO cmeNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ciɛŋ wuɔ: «Hã muɔ hũmma famma‑i hũŋkuɔsĩnni baa ji tiraa bel-mi aa mi baa ji tiraa jo bande‑i-na wuɔ mi ji hu hũmma.» ");
INSERT INTO cmeNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesu wuɔ: «Kã ŋ ka bĩ ŋ bɔlɔ‑i na jo.» ");
INSERT INTO cmeNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ciɛŋ wuɔ: «Bɔlŋo si dii baa-mi.» Yesu wuɔ: «Ma dɔlaa-ni! ");
INSERT INTO cmeNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ŋ tĩɛnaana baa bibɛmba ndii cor tĩ. Aa niŋ yeŋ baa umaŋ fiɛfiɛ‑i-na, ŋ bɔlɔ‑i sĩ. Ŋ saa kar coima.» ");
INSERT INTO cmeNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Uŋ waaŋ mafamma‑i, ciɛŋ wuɔ: «Ku biyaa ŋaa nuɔŋo‑i *Diilopɔpuɔrbiloŋ nuɔ.» ");
INSERT INTO cmeNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Aa naa cira: «Yaŋ mi yuu-ni nelma diei: Samari-bĩncuɔmba siire jaal Diiloŋo‑i tãnuŋ daaku yaa nuɔ‑i, bige‑i ciɛ Yuifubaa namaaŋo‑i na'a Diilojaalterieŋgu dii *Yerusalɛmu?» ");
INSERT INTO cmeNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesu wuɔ: «Ciɛŋ nuɔ, yaŋ mi waŋ ninsoŋo‑i baa-ni: Yiiŋgu dii baa yiiŋgu na siɛ ji tiraa ta na jaal i To‑i Diiloŋo‑i tãnuŋ daaku-na, na siɛ bi ji tiraa ta na jaal-o Yerusalɛmu‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Samaritaaŋ namaaŋo‑i na sa suɔ naŋ jaal umaŋ, a ne da Yuifubaa miɛŋo‑i, Koŋkortieŋo hilaa miɛmɛi nuɔ‑i, a ce dumaaŋo-na i suɔ iŋ jaal umaŋ. ");
INSERT INTO cmeNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ŋga yiiŋgu dii baa yiiŋgu, *Diiloŋ-Yalle ka ce ninsoŋ-Diilojaaltaamba ta ba jaal i To‑i Diiloŋo‑i baa huɔŋga diei. Yiiŋgu faŋgu hii tĩ yɛrɛ. I To‑i Diiloŋo‑i taara ba ta ba jaal-o dumɛi. ");
INSERT INTO cmeNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Diiloŋo‑i molo sa da-yo; bamaŋ jaalaaŋ-yoŋ ba saaya ba ta ba jaal-o baa huɔŋga diei, aa ba yaŋ u *Yalle dii-ba hũmelle-na.» ");
INSERT INTO cmeNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ciɛŋ wuɔ: «Mi suyaa miɛ Diiloŋ uŋ pãa nuŋgu‑i wuɔ u ka saaŋ *Koŋkortieŋo maŋ, u ka jo. Ba bĩ u yaa‑i *Kirsa‑i. Duɔ jo, u ka waŋ ma yaaŋga‑i hiere baa-ye.» ");
INSERT INTO cmeNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesu wuɔ: «Niŋ gbɛ̃ŋ umaŋ, u yaa piiyeŋ baa-ni daayo‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Uŋ taa u waŋ mafamma‑i, u hãalãbiemba jo ji ta ba yiɛra. Baŋ juɔ ji da u piiye baa ciɛŋ daayo‑i, kuɔ cu ba hɔmmu‑i. Ŋga molo saa siɛ duɔ yuu-yo wuɔ: «Bige‑i ciɛ ŋ ta ŋ piiye baa ciɛŋ daayo‑i? Ŋ'a u ce bige‑i hã-ni?» ");
INSERT INTO cmeNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ciɛŋ wuɔ yaŋ u bũnaŋga‑i aa naa gbar kã nelleŋ-huɔŋga-na ka tuɔ piiye baa nuɔmba‑i wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«Juɔŋ i ta na ka da, ma miŋ siire ce mamaŋ hiere, naacolŋo naŋo waaŋ-ma baa-mi. Ku biyaa ŋaa Diiloŋ uŋ pãa nuŋgu‑i wuɔ u ka saaŋ Koŋkortieŋo maŋ, u yaa juɔ.» ");
INSERT INTO cmeNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Nuɔŋ baa hel kã Yesu wulaa. ");
INSERT INTO cmeNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","A ne da huɔŋgu faŋgu-na, u hãalãbiemba waa ta ba cãrã-yuɔ wuɔ u wuo niiwuoni‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Yesu wuɔ gbɛ̃-ba wuɔ: «Mi daa niiwuoni nanni da mi wuo ŋga namaa na sa suɔ niiwuoni fanni‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Hãalãbieŋ baa ta ba yuu ba-naa wuɔ: «Ku ce molo juɔ baa niiwuoni ji hã-yo wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesu wuɔ cira: «Umaŋ puɔraa-mi, da mi gbãa ce u huɔŋga‑i, a ce u maacemma ka bãl, mɛi niiwuoni yaa nifanni‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ma sĩ namaa fɛrɛ‑i da na ce na ta na piiye wuɔ dĩmma ce caamba naa aa ba suɔ kar-ma kɛ? Ciiriiŋ na yunni‑i na ne; nuɔmba maŋ juɔŋ, baa dii ŋaa dĩmma maŋ vãa hi karma. ");
INSERT INTO cmeNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Umaŋ karaaŋ dĩmma‑i u ka da u cufaluŋgu sullu‑i aa uŋ karaa dĩmma maŋ, ma ka kã Diiloŋ-nelleŋ. A ce dumaaŋo-na, umaŋ duuŋ baa umaŋ karaaŋ, ba hɔfɛ̃lle‑i diiduɔle. ");
INSERT INTO cmeNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Da ba cira: ‹Unaŋo‑i duuŋ aa unaa kar› ba saa kar coima. ");
INSERT INTO cmeNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Suoŋgu maŋ namaa saa kũ-ku, mi puɔraa na ka ta na ka kufaŋgu dĩmma yaa‑i. Banamba'i kũɔ-ku cufal, aa namaa kã ka ta na ka ku dĩmma‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ciɛŋ uŋ tũɔnu nuɔmba‑i wuɔ uŋ siire ce mamaŋ hiere Yesu waaŋ-ma baa-yo, ba fɔ̃ŋgũɔ hũu Yesu maama‑i nelle fande-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","A ce dumaaŋo-na, baŋ juɔ ji da-yo, baa cãrã-yuɔ wuɔ u tĩɛna baa-ba. Yesu wuɔ tĩɛna ce yinni hãi ");
INSERT INTO cmeNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","a piiye baa-ba u fɛrɛ. Uŋ ciɛ mafamma‑i, nuɔmba bɔi tiraa hũu u maama‑i naara. ");
INSERT INTO cmeNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Baa ta ba piiye baa ciɛŋo‑i wuɔ: «Iŋ nuɔ naŋ nelma‑i aa jo ji nu fuɔ maama‑i a suɔ wuɔ u yaa miwaaŋo koŋkortieŋo‑i kelkel, ku yaa kãyã-yiɛ i hũu u maama‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Yesuŋ siire Sikaar-na, wuɔ cor baa u hũmelle‑i tuɔ kã *Galile‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Fuɔ fɛrɛ wuɔ waaŋ-ma wuɔ: «Ba sa kãŋ *Diilopɔpuɔrbiloŋo‑i u fɛrɛŋ nelle-na.» ");
INSERT INTO cmeNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Uŋ kaa hi Galile‑i, Galiletaaŋ baa gbuu bel-o da fafamma. Baŋ ŋa naa kã *Yerusalɛmu‑i-na *kɔrsĩnni tĩmmaŋ-ponsaaŋgu‑na, ba daa uŋ ciɛ mamaŋ hiere, ku'i ciɛ uŋ kãa ba terieŋgu-na, ba suɔ u belma. ");
INSERT INTO cmeNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ku huoŋgu-na, wuɔ ji tiraa kã Kana‑i-na uŋ ŋa naŋ birii hũmma‑i kolma‑i kusuɔŋ-nu. A ne da fãamaaŋo naŋo biɛŋo taa u jaŋ. U waa Kafarnamu. ");
INSERT INTO cmeNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Tuoŋ uŋ juɔ nu wuɔ Yesu hilaa *Yude‑i-na jo Galile‑i-na, wuɔ kã ka cãrã-yuɔ wuɔ u ce jande aa u kã baa-yo Kafarnamu‑i-na ka sire u biɛŋo‑i hã-yo, kɛrɛ jarma cɔraanu-yuɔ cor. ");
INSERT INTO cmeNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesu wuɔ cira: «Ku ce ŋaa da na saa da gbɛrɛ‑i baa na yufelle‑i na sa hũu-ma wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Naacolŋ wuɔ cira: «Itie, jande baa sɛrɛ. Da ŋ sɛrɛ, mi biɛŋo ka ku.» ");
INSERT INTO cmeNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesu wuɔ cira: «Bir ŋ kũŋ, ŋ biɛŋo siire.» Naacolŋ wuɔ bi hũu-ma aa naa bir tuɔ kũŋ. ");
INSERT INTO cmeNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Uŋ kãŋ hũmelle-na, wuɔ suu baa u maacembiemba jo u wulaa. Wuɔ yuu-ba. Baa cira: «Ŋ biɛŋo siire, i taa i kã diɛ ka waŋ ma yaa baa-ni.» ");
INSERT INTO cmeNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Wuɔ yuu-ba wuɔ: «U siire yaku‑i?» Baa cira: «U siire cicuɔŋ-nu, bãaŋgu naa ciɛl yuhuɔŋga-na cɛllɛ.» ");
INSERT INTO cmeNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Tuoŋ wuɔ bi ne da huɔŋgu bi faŋgu'i nuɔ‑i Yesu naa gbɛ̃-yo wuɔ u biɛŋo siire. Kuŋ ciɛ dumaaŋo-na, fuɔ baa u dumɛlleŋ-baamba‑i hiere baa pãŋ hũu Yesu maama‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yesuŋ hilaa Yude‑i-na bir kã Galile‑i-na, u gbɛrɛ daayo yaa ciɛ ba ce ba hãi terieŋgu faŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ku huoŋgu-na, *Yuifubaa-ba ji ta ba ce ba ponsaaŋgu naŋgu‑i *Yerusalɛmu‑i-na. Yesu wuɔ kã. ");
INSERT INTO cmeNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","A ne da Tũlŋ-dumɛlle caaŋgu-na hũnfuoŋgu naŋgu dii, ba bĩ-ku ebiremma-na «Bɛtisata». Gbuganni ndii waa cĩilã-kuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","*Dɔrpɔpuɔrbiloŋo naŋo waa tuɔ jo u sagalla hũmma‑i hũnfuoŋ daaku-na. Duɔ sagalla-mɛi, jɛiŋo maŋ duɔ gbãa suur igɛ̃na, u jarŋ da ma fiɛ kuola niɛ niɛ, fafalmu pãŋ da-yuɔ. A ce dumaaŋo-na, jaamba bɔi waa terieŋgu-na ta ba cɔrɔ gbugaŋ daani-na ba cie hũmma sagallamma‑i: Yiriemba waa, cisɛduɔlbaa-ba waa a naara murgubaa-ba bi waa. ");
INSERT INTO cmeNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Unaŋo waa ba hɔlma-na, uŋ gaala jarma-na, ku bieŋ komorre baa cĩncieluo niisiɛi waa belle fande-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesuŋ kãa ka da u gaala, aa nu wuɔ u bãaŋgu cuɔ jarma-na, wuɔ yuu-yo wuɔ: «Ŋ taara ŋ sire wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Jɛiŋ wuɔ cira: «Hãalãtie, hũŋ da ma sagalla, mi siɛ da molo dii-mi; muɔ da mi namallã da mi ka suur dii huɔŋgu-na, unaa ta yaaŋga miɛ suur. Mi ce-ma niɛ?» ");
INSERT INTO cmeNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesu wuɔ: «Sire ŋ biɛ ŋ figĩiŋgu‑i ŋ kũŋ.» ");
INSERT INTO cmeNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Terduɔŋgu faŋgu-na, fafalmu pãŋ da naacolŋo-na. Wuɔ sire biɛ u figĩiŋgu‑i tuɔ kũŋ. A ne da yiiŋgu faŋgu waa *yitĩɛnaŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Yuifu ba yuntaambaŋ daa u tũyãa figĩiŋgu‑i, baa ta ba waŋ baa-yo wuɔ: «Ŋ saa suɔ wuɔ nyuŋgo‑i yitĩɛnaŋgu wɛi? Bige‑i ciɛ ŋ sire biɛ figĩiŋgu tũu?» ");
INSERT INTO cmeNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Naacolŋ wuɔ: «Umaŋ siire-miɛ u yaa ciɛra mi biɛ mi figĩiŋgu‑i kũŋ.» ");
INSERT INTO cmeNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Baa cira: «Hai moloŋo‑i ufaŋo‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Naacolŋo yiɛra bege! U sa suɔ Yesu‑i duɔ pigãaŋ-yo. A ne da nuɔmba naa maara cor. Yesu baala ba hɔlma-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ku huoŋgu-na, Yesu wuɔ ji da naacolŋo‑i *Diilodubuɔ‑i-na. Wuɔ waŋ baa-yo wuɔ: «Nuɔnɛi daani yeryer fiɛfiɛ‑i-na, da ŋ'a ŋ sa taara wɛima namma da-ni mamaŋ balaaŋ yaŋ dĩɛlã-maaŋ daama‑i, baa tiraa ŋ cãl Diiloŋo‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Naacolŋ wuɔ kã ka waŋ baa Yuifu ba yuntaamba‑i wuɔ naacolŋ daayo yaa naa sire-yuɔ u jarma-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Yuifu ba yuntaaŋ baa sire ku yaa nuɔ‑i a cɔ̃ Yesu‑i wuɔ u ciɛ niɛ sire moloŋo yitĩɛnaŋgu-na? ");
INSERT INTO cmeNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yesu wuɔ gbɛ̃-ba wuɔ: «Mi biyaa mi to-maama. Mi To sa nanna yiiŋgu baa u maacemma‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Uŋ waaŋ mafamma‑i, Yuifu ba yuntaaŋ baa pãŋ ta ba taara-yuɔ baa komma, wuɔ u saa kãŋ yitĩɛnaŋgu‑i aa tiraa cira Diiloŋo‑i fuɔ tohoiŋo; dumaaŋo-na, u saa u fɛrɛ baa Diiloŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesu wuɔ gbɛ̃-ba wuɔ: «Yaaŋ mi waŋ ninsoŋo‑i baa-na: Bɛpolŋo siɛ gbãa da dumaa u tuɔ ce. U ne Tuoŋo yaa‑i aa tuɔ ce. Tuoŋ uŋ ceŋ mamaŋ, Bɛpolŋo bi ce ma yaa‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Bɛpolŋo maama dɔlnu Tuoŋo‑i, u yaa pigãaŋ-yoŋ u maacemma‑i u tuɔ ce. U ka pigãaŋ-yo mamaŋ maaraa daama‑i a ce-na gbɛrɛ. ");
INSERT INTO cmeNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Tuoŋ uŋ pĩŋ bikuomba‑i dumaa ba sire, Bɛpolŋ duɔ tuɔ taara umaŋ waa u gbeini-na u sire-yuɔ dumɛi. ");
INSERT INTO cmeNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Aa Tuoŋo sa ce moloŋ ãndaaŋgu, u yaaŋ ãndacelle‑i hã Bɛpolŋo yaa‑i, ");
INSERT INTO cmeNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ku yaa nuɔmba ka ta ba kãŋ-yo ŋaa baŋ kãŋ Tuoŋo‑i dumaa. Umaŋ duɔ u sa kãŋ Bɛpolŋo‑i, kuu dii ŋaa u sa kãŋ u To maŋ puɔraa-yo. ");
INSERT INTO cmeNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","«Yaaŋ mi waŋ ninsoŋo‑i baa-na: Mi To yaa puɔraa-mi, a ce dumaaŋo-na umaŋ duɔ nu mi nelma‑i aa haa u naŋga mi To‑i-na, kutieŋo daa cicɛ̃lma maŋ sa tĩɛŋ dede‑i tĩ. Ba siɛ ka yuu-yo baa wɛima. Kuu dii ŋaa kutieŋo kuu tĩ aa sire. ");
INSERT INTO cmeNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Yaaŋ mi tũnu-nɛi: Yiiŋgu dii baa yiiŋgu, bikuomba ka nu Diiloŋ-Biɛŋo piiye. Ku yiiŋgu hii tĩ yɛrɛ. Umaŋ duɔ nu u nuŋgu‑i, kutieŋo ka da cicɛ̃lma maŋ siɛ ji tĩ dede. ");
INSERT INTO cmeNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Cicɛ̃lmaŋ yeŋ baa Tuoŋo‑i dumaa u tuɔ hã nuɔmba‑i baa-ma, u bi hãa Bɛpolŋo‑i baa-ma dumɛi u tuɔ hã-ba. ");
INSERT INTO cmeNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Aa u birii ãndacelle‑i hã Bɛpolŋo yaa baa-de wuɔ u yaa *Moloŋ-Biɛŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Baa na yaŋ ma ce-na gbɛrɛ. Na saa da, yiiŋgu dii baa yiiŋgu, bamaŋ suurii hĩɛma-na ba ka nu Moloŋ-Biɛŋo piiye. ");
INSERT INTO cmeNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Da ba ji nu u piiye, ba ka sire hel cĩncuɔŋa-na. Bamaŋ taa ba ce ãnfafamma‑i ba ka kã Diiloŋ-nelleŋ, ŋga bamaŋ taa ba ce kuubabalaaŋgu‑i ba ka kã dãamu-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Mɛi siɛ gbãa ce bĩŋkũŋgu mi fɛrɛ. Baŋ ciɛra mi gɛr dumaa, mi gɛr dumɛi. Mi sa ce kumaŋ dɔlaanu muɔ, umaŋ puɔraa-mi, mi ce fuɔ kuudɔlnuŋgu'i. Terieŋgu faŋgu-na, mi gbãa cira mi suɔ gɛrma. ");
INSERT INTO cmeNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","«Kuɔ muɔmɛi taa mi waŋ mi maama‑i mi fɛrɛ, yuŋgu naa saa waa mi nelma-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ŋga unaŋo‑i waaŋ-maŋ, aa mi suyaa miɛ u waŋ ma yaaŋga yaa‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ma sĩ na puɔraa nuɔmba Nsãa wulaa wuɔ ba ka yuure mi sĩnni‑i kɛ? Baŋ kãa, Nsãa saa ka fuo ninsoŋo‑i bɛi. ");
INSERT INTO cmeNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Uŋ waaŋ mamaŋ baa-ba mi maama-na, ma sa kãyã muɔ, ma kãyã namɛi. Mi waŋ mafamma‑i da mi kor namɛi. ");
INSERT INTO cmeNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Nsãa waa ŋaa fitĩnuɔ na hɔlma-na, na hũyãa-ma ce na bãaŋgu‑i cɛllɛ yoŋ baa-yo. ");
INSERT INTO cmeNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","A ne da mɛi maaraa Nsãa‑i. Mi Toŋ hãa-mi maacemma maŋ mi ta mi ce, ma yaa pigãaŋ mi sĩnni‑i aa ma yaa bi pigãaŋ wuɔ mi To yaa puɔraa-mi. ");
INSERT INTO cmeNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Aa umaŋ puɔraa-mi, u bi bĩ mi yefafalle. Ŋga na saa nu u yalle‑i dede, na saa bi da u yufelle dede. ");
INSERT INTO cmeNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Uŋ puɔraa umaŋ, naŋ'a na saa hũu u nelma‑i, na ce niɛ aa gbãa hũu fuɔ maama‑i? ");
INSERT INTO cmeNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Na suyaa wuɔ cicɛ̃lma maŋ sa tĩɛŋ dede ma da Diiloŋ-nelma yaa nuɔ‑i, ku'i ciɛ na vaa na fɛrɛ baa ma kalamma‑i. A ne da ma yaa bi piiyeŋ mɛi maama‑i ");
INSERT INTO cmeNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","aa na sa taara na cu mi huoŋ-nu a ji kor. ");
INSERT INTO cmeNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","«Mi sa taara nuɔmba dɔl-mi. ");
INSERT INTO cmeNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Mi suɔ-na. Mi suyaa miɛ Diiloŋo maama sa dɔlnu-nɛi. ");
INSERT INTO cmeNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Mi juɔ mi To yerreŋ aa na sa taara na da mi yufelle. Ŋga moloŋ duɔ jo u fɛrɛŋ jomma, na sire ta na gbar na nyaanu-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Namaa naŋ birii yaŋ Diiloŋo‑i aa ta na taara nelbiliemba'i dɔl-na, na ka ce niɛ gbãa hũu u maama‑i? ");
INSERT INTO cmeNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Baa na da niɛ sĩ muɔmɛi kaa cãl-na mi To terieŋgu-na; muɔ sĩ. Naŋ haa na naŋga‑i *Moisi maŋ nuɔ‑i, u yaa ka cãlãaŋ-naŋ. ");
INSERT INTO cmeNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Na saa da, Moisi nyɛgãaŋ mɛi maama'i u sɛbɛ‑i-na. Kuɔ naa naa hũu u maama‑i, naa naa bi hũu mɛi maama‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ŋga naŋ'a na saa hũu uŋ nyɛgãaŋ mamaŋ, na ka ce niɛ gbãa hũu mɛi nelma‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ku huoŋgu-na, Yesu wuɔ kã *Galile dalaŋga yiɛŋgu naŋgu-na; ba bi bĩ dalaŋga faŋga‑i Tiberiyadi-dalaŋga. ");
INSERT INTO cmeNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Uŋ taa u ce himma‑i u sire jaamba‑i dumaaŋo-na, nuɔŋ baa kũɔl ba-naa ta ba nyaanu-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Wuɔ kã ka nyugũŋ tãnuŋgu naŋgu-na tĩɛna baa u *hãalãbiemba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","*Yuifu ba *kɔrsĩnni tĩmmaŋ-ponsaaŋgu naa piɛ tĩ. ");
INSERT INTO cmeNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Wuɔ u ne da nelpũŋgu naŋgu jo. Wuɔ yuu Filipu‑i wuɔ: «I ka da niiwuoni‑i hie diɛ sãa hã nuɔŋ daaba‑i hiere ba wuo?» ");
INSERT INTO cmeNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Uu naa suɔ uŋ saaya u ce kumaŋ, ŋga u taa u yuu duɔ ne Filipuŋ ka waŋ mamaŋ. ");
INSERT INTO cmeNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipu wuɔ cira: «Da ŋ fiɛ biɛ *deniebaa nuɔsũɔ a sãa niiwuoni‑i wuɔ ŋ cal hã-ba tɛ̃ntɛ̃ŋ, ba siɛ da hiere.» ");
INSERT INTO cmeNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","U hãalãbiloŋo naŋo waa, Simɔ-Piɛr hãaŋo; ba taa ba bĩ-yo Ãndere. Fuɔ wuɔ cira: ");
INSERT INTO cmeNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«*Buruo u ndii dii baa naacombiloŋo naŋo bande‑i-na a naara titiraamba hãi. Ŋga nifanni gbãa fa hama‑i a hã nelpũŋ daaku temma‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesu wuɔ waŋ baa-ba wuɔ: «Ciɛŋ ba tĩɛna hiere.» Hɔlma famma-na, hĩɛŋgu waa bɔi. Nuɔŋ baa tĩɛna. Bibɛmba maŋ waa, ba gbãa yu nuɔmba neifieŋa hãi nuɔsiba ndii temma. ");
INSERT INTO cmeNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yesu wuɔ biɛ buruo‑i a jaal Diiloŋo‑i aa naa calnu-yuɔ hã-ba. Aa naa bi hã-ba titiraamba‑i baŋ taaraŋ dumaa. ");
INSERT INTO cmeNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Baŋ gbuu ji wuo ye tĩ huɔŋgu maŋ nuɔ‑i, wuɔ waŋ baa u hãalãbiemba‑i wuɔ: «Biɛraayaŋ boini maŋ tĩyãa, mi sa taara ni bĩɛna.» ");
INSERT INTO cmeNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Baa biɛra baŋ wuyaa buruo u ndii daayo‑i aa boini maŋ tĩɛ, niɛ yu segebaa cĩncieluo ba hãi. ");
INSERT INTO cmeNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Nuɔmbaŋ daa gbɛrɛ faŋo‑i, baa ta ba piiye wuɔ: «*Diilopɔpuɔrbiloŋo maŋ naa saaya u jo hĩɛma-na, u yaa juɔ daayo‑i, nuharuŋgu si dii-mɛi.» ");
INSERT INTO cmeNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesu wuɔ suɔ wuɔ ba ka jo ji bel-o fɔ̃ŋgũɔ ce-yo nellentieŋo; wuɔ ta halaŋ ba caaŋgu-na bir ka tĩɛna u da-u-diei dii tãnuŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Bãaŋguŋ juɔ hir huɔŋgu maŋ nuɔ‑i, Yesu *hãalãbieŋ baa hiire kã dalaŋga-na, ");
INSERT INTO cmeNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ka biɛ beŋo ta ba karnu ba kã Kafarnamu yaŋga. Bãaŋgu ji tĩ ba sa da Yesu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Fafalpepetieŋo naŋo sire tuɔ sagalla hũmma‑i dalaŋga-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ba gbaraa kilobaa-ba ndii, sisɔ niediei temma, ba'a ba ne da Yesu‑i ba caaŋ-nu; u wuɔ hũmma dɔrɔ‑i-na u jo. Kor maa pãŋ ta ma da-ba. ");
INSERT INTO cmeNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Yesu wuɔ cira: «Baa na tie holle, muɔmɛi!» ");
INSERT INTO cmeNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ba'a ba yiɛra biɛ-yo ku yaa nuɔ‑i, a da ba hii baŋ taa ba kã kusuɔŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ku cuo kaala‑i-na, nuɔmba maŋ naa tĩyãa bomborma namma-na ba saa da Yesu‑i. A ne da u *hãalãbiembaŋ taa ba ta dɛ̃ndĩɛle-na, beŋo diei waa yoŋ hũmma nuŋgu-na. Ba biyaa u yaa‑i ta. Cuoŋ kaalaa nuɔmba saa da Yesu‑i, baa ta ba yuu ba-naa wuɔ: «Naacolŋ daayo curaa hie? U saa naa bi suur baa u hãalãbiemba‑i cicuɔŋgu-na!» ");
INSERT INTO cmeNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ba'a ba ne da benni nanni hilaa Tiberiyadi‑i-na jo ji yiɛra Yesuŋ ŋa naa jaal Diiloŋo‑i aa hã-ba *buruo‑i kusuɔŋ-nu ku caaŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Baa ne da Yesu‑i baa u hãalãbiemba‑i molo si dii benaamba famba-na. Baa bel-ba nyugũŋ ta ba karnu ba kã Kafarnamu‑i-na da ba ka taara-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Baŋ karaanu ka da-yo, baa cira: «Hãalãtie, ŋ juɔ yaku‑i bande‑i-na?» ");
INSERT INTO cmeNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesu wuɔ cira: «Yaaŋ mi waŋ ninsoŋo‑i baa-na: Miŋ ceŋ gbɛrɛ maŋ, ku saa ce ŋaa na suyaa fuɔ yuŋgu yaa‑i aa ta na taara-miɛ, ŋga miŋ hãa-na niiwuoni‑i na wuo ni yar-na, ku'i ciɛ na ta na taara-miɛ. ");
INSERT INTO cmeNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Baa na ta na ce maacemma‑i na taara niiwuoni maŋ bĩɛnaanaŋ, taa na ce na taara niiwuoni maŋ sa bĩɛnaanaŋ aa ta ni kã baa nɛliɛŋo Diiloŋ-nelle-na. *Moloŋ-Biɛŋo hã nuɔmba‑i ni yaa‑i; u To‑i Diiloŋo haa u dãnyuɔ‑i u yaa nuɔ‑i duɔ pigãaŋ wuɔ u'i hãa-yo ku fɔ̃ŋgũɔ‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Baa yuu-yo wuɔ: «I saaya i tiɛ ce Diiloŋo huɔŋga‑i niɛ?» ");
INSERT INTO cmeNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesu wuɔ cira: «Diiloŋ uŋ taaraŋ kumaŋ na wulaa, ku yaa daaku: U taara uŋ puɔraa umaŋ, na hũu u maama‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Baa cira: «Ŋ ka ce gbɛrɛ hayo‑i pigãaŋ-ye i suɔ wuɔ Diiloŋo puɔraa nuɔnɛi? ");
INSERT INTO cmeNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","I bĩncuɔmbaŋ waa *hĩɛkuraaŋgu-na, Diiloŋo naa tuɔ hã-ba niiwuoni ba ta ba wuo. Ma nyɛgãaŋ Diiloŋ-nelma-na wuɔ: ‹U hielaa niiwuoni dɔrɔ‑i-na nanna hã ba wuo.›» ");
INSERT INTO cmeNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesu wuɔ cira: «Yaaŋ mi waŋ ninsoŋo‑i baa-na: Niiwuoni maŋ hilaa dɔrɔ‑i-na *Moisi saa hã-na baa-ni. Mi To yaa hãaŋ-naŋ ninsoŋ-niiwuoni maŋ hilaaŋ dɔrɔ‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Diiloŋ-niiwuoni yaa nimaŋ hilaaŋ dɔrɔ‑i-na. Ni yaa hãaŋ nuɔmba‑i ninsoŋ-cicɛ̃lma‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Uŋ waaŋ mafamma‑i, baa cira: «Itie, ta ŋ hã-ye niiwuoni fanni‑i i tiɛ wuo.» ");
INSERT INTO cmeNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesu wuɔ gbɛ̃-ba wuɔ: «Muɔmɛi cicɛ̃lmaŋ-niiwuoni‑i. Umaŋ duɔ cu mi huoŋ-nu, nyulmu cɛraa mu bel-o aa umaŋ duɔ hũu mi nelma‑i, hũŋkuɔsĩnni cɛraa ni bel-o. ");
INSERT INTO cmeNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Mi waaŋ-ma baa-na cor tĩ, aa na tiraa da-ma baa na yufieŋa‑i, ŋga na saa hũu-ma. ");
INSERT INTO cmeNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Mi To duɔ hã-mi bamaŋ hiere, ba ka cu mi huoŋ-nu. Umaŋ duɔ cu mi huoŋ-nu, mi sa ji donya-yuɔ mi fɛrɛŋ nuɔ dede. ");
INSERT INTO cmeNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Hama‑i nuɔ‑i? Mi saa hel dɔrɔ‑i-na da mi ji ce mi kuudɔlnuŋgu, mi juɔ da mi ji ce umaŋ puɔraa-mi u kuudɔlnuŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","A ne da umaŋ puɔraa-mi u sa taara uŋ hãa-mi bamaŋ, u diei balla-bɛi. U taara miwaaŋo tĩmmaŋ-yiiŋgu‑i, mi sire kutaamba‑i hiel-ba cĩncuɔŋa-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Na saa da, mi To taara umaŋ duɔ suɔ-mi aa hũu mi nelma‑i, kutieŋo da cicɛ̃lma maŋ sa tĩɛŋ dede‑i aa mi sire-yuɔ miwaaŋo tĩmmaŋ-yiiŋgu-na.» ");
INSERT INTO cmeNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Yesuŋ ciɛra wuɔ u yaa‑i cicɛ̃lmaŋ-niiwuoni maŋ hilaa dɔrɔ‑i-na, ku saa dɔlnu *Yuifubaa-ba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Baa ta ba piiye wuɔ: «Yosɛfu biɛŋ daa u sa suɔ aa cɔrnu! I suɔ u to‑i aa suɔ u nyu‑i, u bir gbɛ̃-ye dumaa wuɔ fuɔ hilaa dɔrɔ.» ");
INSERT INTO cmeNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesu wuɔ cira: «Baa na yaŋ na hɔmmu guɔla. ");
INSERT INTO cmeNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Mi To yaa puɔraa-mi, a ce dumaaŋo-na molo siɛ gbãa cu mi huoŋ-nu u fɛrɛ ni u saa dii u nuŋgu‑i. Umaŋ duɔ cu mi huoŋ-nu, duɔ fiɛ ku, miwaaŋo tĩmmaŋ-yiiŋgu-na, mi ka sire-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","*Diilopɔpuɔrbiemba nyɛgãaŋ nel daama‑i wuɔ: ‹Diiloŋo ka hãalã-bɛi hiere baa u nelma‑i.› Umaŋ duɔ nu mi To nelma‑i aa siɛ u nuŋ-ãndaaŋgu‑i, kutieŋo ka cu mi huoŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Dumaaŋo-na ku saa ce ŋaa molo daa mi To‑i dede dɛ! Ma'i sĩ. Umaŋ hilaa Diiloŋo wulaa jo, u yaa daa-yo u diei yoŋ. ");
INSERT INTO cmeNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","«Yaaŋ mi waŋ ninsoŋo‑i baa-na: Umaŋ duɔ hũu mi nelma‑i, kutieŋo daa cicɛ̃lma maŋ sa tĩɛŋ dede‑i tĩ. ");
INSERT INTO cmeNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Muɔmɛi cicɛ̃lmaŋ-niiwuoni‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Na tobaa-ba wuyaa niiwuoni‑i hĩɛkuraaŋgu-na ŋga ba kuu. ");
INSERT INTO cmeNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","A ne da niiwuoni maŋ hilaaŋ dɔrɔ‑i-na, umaŋ duɔ wuo-ni, kutieŋo sa ku. ");
INSERT INTO cmeNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Muɔmɛi cicɛ̃lmaŋ-niiwuoni maŋ hilaa dɔrɔ‑i-na jo. Umaŋ duɔ wuo-ni, kutieŋo ka da cicɛ̃lma maŋ sa tĩɛŋ dede‑i. Miŋ ka hã nelbiliemba‑i niiwuoni maŋ ba da ba da ninsoŋ-cicɛ̃lma‑i, mɛi fɛrɛŋ kũɔma yaa‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Uŋ waaŋ mafamma‑i, maa gbuu jaŋ Yuifubaa-ba‑i, baa ta ba yuu ba-naa wuɔ: «Naacolŋ daa wuɔ u hã-ye u kũɔma‑i i wuo-ma wuoŋ hama‑i temma‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yesu wuɔ cira: «Yaaŋ mi waŋ ninsoŋo‑i baa-na: Da ŋ da na saa wuo *Moloŋ-Biɛŋo kũɔma‑i aa nyɔŋ u tãmma‑i, na siɛ da ninsoŋ-cicɛ̃lma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Umaŋ duɔ wuo mi kũɔma‑i aa nyɔŋ mi tãmma‑i, u daa cicɛ̃lma maŋ sa tĩɛŋ dede‑i tĩ. Duɔ fiɛ ku, miwaaŋo tĩmmaŋ-yiiŋgu-na, mi ka sire-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Mi kũɔma‑i ninsoŋ-niiwuoni aa mi tãmma‑i ninsoŋ-kuunyɔŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Umaŋ duɔ wuo mi kũɔma‑i aa nyɔŋ mi tãmma‑i, kutieŋo dii baa-mi aa mi bi waa baa-yo. ");
INSERT INTO cmeNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Mi To maŋ puɔraa-mi, cicɛ̃lma dii baa u yaa‑i. U yaa hãa muɔŋo‑i cicɛ̃lŋ daama‑i; a ce dumaaŋo-na, umaŋ duɔ wuo mi kũɔma‑i, mi ka bi hã kutieŋo‑i cicɛ̃lma famma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Niiwuoni maŋ hilaa dɔrɔ‑i-na jo, ni yaa daani. Nii sĩ niiduɔni baa na tobaa-baŋ wuyaa nimaŋ aa ku. Umaŋ duɔ wuo niiwuoŋ daani‑i, kutieŋo ka da cicɛ̃lma maŋ sa tĩɛŋ dede‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesuŋ waaŋ mamaŋ baa nuɔmba‑i Kafarnamu *Diilonelhãalãdũŋgu-na ma yaa mafamma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Yesuŋ piiye dumaaŋo-na, u *hãalãbiemba fɔ̃ŋgũɔ baa cira: «Nel daama cemma dii kpelle cor; hai gbãa siɛ daama temma‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesu wuɔ suɔ wuɔ ku saa dɔlnu-bɛi, wuɔ yuu-ba wuɔ: «Nel daama ciɛ kpelle na wulaa wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Aa da na ji da *Moloŋ-Biɛŋo nyugũŋ u kã u muntercɔlɔmmu-na, na ka waŋ wuɔ niɛ? ");
INSERT INTO cmeNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","*Diiloŋ-Yalle yaa hãaŋ nɛliɛŋ nuɔŋo‑i cicɛ̃lma‑i, ni ma'i sĩ nɛliɛŋ nuɔŋo‑i baa ŋ yundaaŋgu‑i ŋ siɛ gbãa ce bĩŋkũŋgu. Miŋ waaŋ nelma maŋ baa-na, Diiloŋ-Yalle dii ma yaa nuɔ‑i baa cicɛ̃lma‑i hiere. ");
INSERT INTO cmeNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ŋga banamba dii na hɔlma-na, ba saa hũu-ma.» Ninsie ninsie, Yesu wuɔ suyaa ãnyagarmantaamba‑i dii ku domma-na, aa wuɔ bi suyaa umaŋ ka hel u huoŋ-nu, ku'i ciɛ wuɔ tuɔ waŋ mafamma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Uŋ piiye dumaaŋo-na, wuɔ cira: «Da na da mi ciɛra molo siɛ gbãa cu mi huoŋ-nu ni Diilo saa dii u nuŋgu, ku yuŋgu yaa kufaŋgu‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","A doŋ yiiŋgu faŋgu-na, u hãalãbiemba fɔ̃ŋgũɔ bir, ba sa tiraa nyaanu-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Baŋ birii, Yesu wuɔ yuu u hãalãbieŋ cĩncieluo ba hãi baamba‑i wuɔ: «Namaa na bi taara na bir mi huoŋ-nu wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simɔ-Piɛr wuɔ cira: «Itie, cicɛ̃lma maŋ sa tĩɛŋ dede‑i ma nelma dii baa nuɔnɛi; i bir naŋ huoŋgu-na ka nyaanu hai? ");
INSERT INTO cmeNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","I haa i naŋga‑i nuɔnɛi nuɔ‑i, aa i suyaa wuɔ Diiloŋ uŋ puɔraa u nolŋo maŋ jo, u yaa nuɔŋo‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesu wuɔ cira: «Ma sĩ naa dii cĩncieluo baa na hãi kɛ? Hai fiɛlaa-na? Muɔmɛi sĩ wɛi? A ne da Sitãni-nolŋo dii na hɔlma-na.» ");
INSERT INTO cmeNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","U gbɛ̃ *Yuda yaa dumaaŋo-na. Simɔ‑Isikaro biɛŋo. U nuŋgu waa Yesu hãalãbieŋ cĩncieluo ba hãi baamba-na. U yaa juɔ hel Yesu huoŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ku huoŋgu-na, Yesu wuɔ cor tuɔ wuɔra *Galile yaa nuɔ‑i, u sa taara u kã *Yude‑i-na. *Yuifu ba yuntaamba taa ba taara-yuɔ baa komma ku'i ciɛ u saa tuɔ taara u kã. ");
INSERT INTO cmeNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","A ne da huɔŋgu faŋgu-na Yuifu ba ponsaaŋgu maŋ baŋ bĩŋ-kuŋ *gbuganniŋ-ponsaaŋgu‑i kuu naa piɛ tĩ. ");
INSERT INTO cmeNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","U hãmba gbɛ̃-yo wuɔ: «Ŋ sa ta bande‑i-na kã Yude‑i-na wɛi? Da ŋ kã, ŋ *hãalãbiemba maŋ dii terieŋgu-na ba ka bi da ŋ ãncemma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Nɛliɛŋ nuɔ da ŋ ta ŋ taara ba suɔ-ni, ŋ saaya ŋ hel pigãaŋ ŋ fɛrɛ. Niŋ ceŋ himma maŋ daama‑i, ŋ saaya ŋ hel nuɔmba‑i hiere ba da-ni.» ");
INSERT INTO cmeNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","A ne da bafamba fɛrɛ‑i ba saa naa haa ba naŋga Yesu‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yesu wuɔ gbɛ̃-ba wuɔ: «Namaa daa ma cemmaŋ-huɔŋgu hii, ŋga mɛi wulaa ku saa hi yogo. ");
INSERT INTO cmeNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Nelbiliemba siɛ gbãa bigãaŋ namaaŋo‑i, ŋga ba bigãaŋ muɔŋo‑i wuɔ mi ciɛ niɛ ta mi piiye wuɔ ba maacemma saa fa?» ");
INSERT INTO cmeNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Aa naa cira: «Taa na kã mi yaaŋ-na ponsaaŋgu-na, muɔmi kãmmaŋ-huɔŋgu saa hi.» ");
INSERT INTO cmeNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","U waaŋ ma yaa‑i baa-ba aa bir tĩɛna Galile‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Yesu hãmbaŋ taa ponsaaŋgu-na, wuɔ bi sire nyaa ba huoŋ-nu. Ŋga u saa yaŋ molo da-yo. ");
INSERT INTO cmeNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ponsaaŋguŋ kaa doŋ, *Yuifu ba yuntaamba taara-yuɔ ba saa da-yo. Baa ta ba yuu ba-naa wuɔ: «U curaa hie?» ");
INSERT INTO cmeNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Fuɔ nelma yaa waa nuɔmba nunni-na. Banaŋ ba'a nelfɛfɛiŋo. Banaŋ ba'a nelfɛfɛiŋo sĩ, kɛrɛ u pira nuɔmba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ŋga ba taa ba kãalã Yuifu ba yuntaamba‑i a ce ba sa siɛ piiye u maama‑i gbagaga. ");
INSERT INTO cmeNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ponsaaŋguŋ juɔ hi ku holle‑i, Yesu wuɔ kã *Diilodubuɔ‑i-na ka tuɔ waŋ Diiloŋ-nelma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Kuɔ ce Yuifubaa-ba‑i gbɛrɛ. Baa ta ba piiye wuɔ: «Naacolŋ daa u saa bi ce kalaŋo, fuɔ ciɛ niɛ tuɔ suɔ Diiloŋ-nelma‑i jeje dumandɛ‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesu wuɔ cira: «Miŋ waŋ mamaŋ daama‑i mɛi huɔya-maama sĩ, Diiloŋo'i puɔraa-mi baa-ma. ");
INSERT INTO cmeNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Umaŋ duɔ hũu-ma duɔ ce Diiloŋo huɔŋga‑i, kutieŋo ka suɔ wuɔ mɛi nelma sĩ. ");
INSERT INTO cmeNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Umaŋ duɔ tuɔ waŋ fuɔ fɛrɛŋ maama‑i, ŋ da kutieŋo kaal u fɛrɛ. Ŋga umaŋ duɔ tuɔ taara u ce u pɔpuɔrtieŋo ce bɔi, fuɔ yaa ninsontieŋo‑i, huhurma sa waa u nelma-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ma sĩ *Moisi yaa hãa-na *ãnjĩnamma‑i kɛ? A bige‑i ciɛ na sa wuɔ ma hũmelle‑i? Ma bilaa niɛ na ta na taara na ko-mi?» ");
INSERT INTO cmeNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Nuɔŋ baa cira: «Ŋ yuŋgu siire wɛi? Hai taaraayaŋ duɔ ko-ni?» ");
INSERT INTO cmeNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesu wuɔ gbɛ̃-ba wuɔ: «Mi ciɛ nelma diei yoŋ aa ma ce-na gbɛrɛ. ");
INSERT INTO cmeNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moisi wuɔ na ta na *jã bibɛmba‑i; ŋga ku saa doŋ fuɔ bãaŋ-nu, ku duɔŋ i bĩncuɔŋ-bãaŋ-nu. Ŋga Moisiŋ waaŋ-ma, da ku fiɛ waa *yitĩɛnaŋgu‑i na jã nuɔmba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Namaa da na ta na jã yitĩɛnaŋgu-na wuɔ na wuɔ Moisi hũmelle, ku ce niɛ muɔ miŋ siire nelfifiŋo‑i yitĩɛnaŋgu-na, na sire wuɔ hĩi? ");
INSERT INTO cmeNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Baa na ta na ne nuɔmba yammu aa na ta na piiye. Da na da mamaŋ, na taara ma yaaŋga‑i igɛ̃na ku yaa na ka suɔ naŋ saaya na waŋ mamaŋ.» ");
INSERT INTO cmeNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Yesuŋ waa tuɔ piiye, Yerusalɛmutaamba namba da-yo. Baa ta ba piiye wuɔ: «Baŋ taaraŋ naacolŋo maŋ da ba ko-yo, u'i sĩ daayo‑i wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","U yaa piiyeŋ daayo nuɔmba-na aa ba fĩinaŋ aa yaŋ-yo. Ku baa ji waa i yuntaamba daa niɛ sĩ u yaa *Koŋkortieŋo‑i? ");
INSERT INTO cmeNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ba siɛ siɛ! Naacolŋ daayo‑i i suɔ uŋ hilaa kusuɔŋ-nu, a ne da Koŋkortieŋ duɔ ji jo, molo siɛ suɔ uŋ hilaa kusuɔŋ-nu.» ");
INSERT INTO cmeNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Huɔŋgu faŋgu-na, Yesu waa tuɔ waŋ Diiloŋ-nelma‑i *Diilodubuɔ‑i-na, wuɔ piiye da gbagaga wuɔ: «Ma sĩ na'a na suɔ-mi aa tiraa suɔ mi muŋhelmu‑i? Na saaya na suɔ wuɔ mi saa jo mi fɛrɛŋ jomma; moloŋo‑i ciɛ mi jo. Aa kutieŋo‑i huhurmantieŋo sĩ, ŋga na sa suɔ-yo. ");
INSERT INTO cmeNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Muɔ fuɔ, mɛi suɔ-yo. Kumaŋ ciɛ mi ta mi suɔ-yo, mi hilaa fuɔ terieŋ-nu'i jo, aa u yaa puɔraa-mi.» ");
INSERT INTO cmeNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Yesuŋ waaŋ mafamma‑i, baa pãŋ ta ba taara ba bel-o. Ŋga u belmaŋ-huɔŋgu saa naa hi, a ce molo saa siɛ duɔ haa u naŋga yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Mafammaŋ fiɛ ce, nuɔmba bɔi yagar hũu u nelma‑i ba hɔlma-na aa naa ta ba cuo ba piiye baa ba-naa wuɔ: «Diiloŋ uŋ pãa nuŋgu‑i wuɔ u ka saaŋ Koŋkortieŋo maŋ, duɔ fiɛ ji jo, u ji ce gbɛrɛ hayo‑i u maar naacolŋ daayo wuoŋo‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Nuɔmbaŋ cuo ba waŋ Yesu maama‑i, *Farisĩɛbaa-ba ji nu-ma. Baŋ nuɔ-ma, ba sire baa *Diilojigãntaamba yuntaamba‑i a puɔr *Diilodubuɔ niyataamba namba wuɔ ba ka bel-o. ");
INSERT INTO cmeNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yesu wuɔ ka gbɛ̃-ba wuɔ: «Mi ka tĩɛna baa-na ce yinni cɛllɛ aa suɔ bir kã umaŋ puɔraa-mi u wulaa. ");
INSERT INTO cmeNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Miŋ kãŋ kusuɔŋ-nu, na siɛ gbãa kã, a ce dumaaŋo-na, na ka taara-miɛ na siɛ da-mi.» ");
INSERT INTO cmeNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","*Yuifubaa baa ta ba yuu ba-naa wuɔ: «Wuɔ u kã hie aa cira i siɛ gbãa da-yo? Ku ce Yuifubaa-ba maŋ dii hĩɛŋgu-na u taara duɔ kã ba yaa wulaa‑i ka waŋ Diiloŋ-nelma‑i baa *niɛraamba‑i wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Nel hama‑i temma‑i dumandɛ‑i? ‹Miŋ kãŋ kusuɔŋ-nu namaa na siɛ gbãa kã, a ce dumaaŋo-na na ka taara-miɛ na siɛ da-mi?›» ");
INSERT INTO cmeNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","*Gbuganniŋ-ponsaaŋgu tĩmmaŋ-yiiŋgu yaa waa yibuɔ‑i. Yiiŋgu faŋguŋ juɔ hi, Yesu wuɔ sire yiɛra aa naa piiye da gbagaga baa nuɔmba‑i wuɔ: «Hũŋkuɔsĩŋ da ni bel umaŋ, u jo mi wulaa u ji nyɔŋ hũmma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ŋaa maŋ waaŋ dumaa Diiloŋ-nelma-na wuɔ: ‹Umaŋ duɔ haa u naŋga miɛ, cicɛ̃lmaŋ-hũmma ka ta ma bũŋ kutieŋo huɔŋga-na ŋaa nuoraaŋgu.›» ");
INSERT INTO cmeNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Bamaŋ naa hũyãa Yesu nelma‑i, baŋ ŋa naa saaya ba da *Diiloŋ-Yalle maŋ, Yesu taa u waŋ difande maama yaa dumaaŋo-na. Huɔŋgu faŋgu-na, Diiloŋo saa naa hi pigãaŋ Yesu bɔbɔima‑i, a ce dumaaŋo-na, molo saa naa hi da Diiloŋ-Yalle‑i yogo. ");
INSERT INTO cmeNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Yesuŋ piiye dumaaŋo-na, banaŋ baa ta ba piiye dii nuɔmba hɔlma-na wuɔ: «Coima saa fa, naacolŋ daayo yaa *Diilopɔpuɔrbiloŋo‑i!» ");
INSERT INTO cmeNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Banaŋ ba'a: «Diiloŋ uŋ pãa nuŋgu‑i wuɔ u ka saaŋ *Koŋkortieŋo maŋ, u yaa‑i!» Banaŋ ba'a: «Diiloŋ uŋ pãa nuŋgu‑i wuɔ u ka saaŋ Koŋkortieŋo maŋ, u ce niɛ aa hel *Galile? ");
INSERT INTO cmeNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Diiloŋ-nelma saa cira wuɔ Koŋkortieŋo ka waa *Davidi hãayɛ̃lŋo wɛi? Aa tiraa cira wuɔ u ka hoŋ Betelɛmu, Davidi ba nelle-na.» ");
INSERT INTO cmeNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Kuŋ ciɛ dumaaŋo-na, ba saa nunu ba-naa Yesu kũŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Banaŋ baa ta ba taara ba bel-o, ŋga hai ka siɛ haa u naŋga yuɔ? ");
INSERT INTO cmeNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","*Diilodubuɔ niyataamba bir kã bamaŋ puɔraa-ba ba wulaa. Baŋ kãa, baa yuu-ba wuɔ: «Ku kaa ce niɛ aa na saa bel-o jo baa-yo?» ");
INSERT INTO cmeNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Baa cira: «Iŋ siire, i saa da molo piiye naacolŋ daayo temma‑i dede.» ");
INSERT INTO cmeNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","*Farisĩɛbaa baa cira: «Ku ce namaa na bi yaaŋ u pira-nɛi tĩ yaa dɛ‑i-na wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Na nuɔ ba'a i yuntieŋ hayo‑i cuu u huoŋ-nu? Sisɔ Farisĩɛyiɛŋ hayo‑i cuu u huoŋ-nu? ");
INSERT INTO cmeNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Bamaŋ cuu u huoŋ-nu, u diei sa suɔ *ãnjĩnamma‑i. Niŋ daaba dɛ‑i hiere Diiloŋo gãaŋ baa-ba!» ");
INSERT INTO cmeNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Farisĩɛyiɛŋo naŋo waa ba hɔlma-na, ba taa ba bĩ-yo Nikodɛmu; u yaa naa kãa Yesu wulaa isuɔŋgu naŋgu-na. Fuɔ wuɔ gbɛ̃-ba wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«Na suyaa wuɔ a saa baa miɛ ãnjĩnamma‑i, diɛ saa yuu moloŋo‑i a suɔ uŋ ciɛ kumaŋ, i siɛ gbãa ce-yo bĩŋkũŋgu dɛ?» ");
INSERT INTO cmeNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Baa cira: «Nuɔ ŋ taara ŋ cu Galiletaamba huoŋ-nu wɛi? Kã ŋ ka migãaŋ ŋ kalaŋ Diiloŋ-nelma‑i fafamma ŋ ne, ŋ sa ka da *Diilopɔpuɔrbilo naŋo hilaa Galile‑i-na.» ");
INSERT INTO cmeNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Baŋ juɔ piiye tĩ, baa sire bɔrɔ kũŋ ba cĩnniŋ. ");
INSERT INTO cmeNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Nuɔmbaŋ buɔra, Yesu wuɔ ta kã *Olivi-tibinni-tãnuŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ku cuo kaala‑i-na, wuɔ naar jo *Diilodubuɔ‑i-na. Nuɔmba‑i hiere baa kũɔl ba-naa jo u wulaa. Wuɔ tĩɛna tuɔ waŋ Diiloŋ-nelma‑i baa-ba. ");
INSERT INTO cmeNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","U juɔ'a u ne da *ãnjĩnamma pigãataamba‑i baa *Farisĩɛbaa-ba juɔ ji jĩna moloŋ ciɛŋo naŋo‑i ba yaaŋga-na, wuɔ ba bilaa-yo baa bibiɛŋo. ");
INSERT INTO cmeNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Baŋ jĩɛna-yuɔ, baa gbɛ̃ Yesu‑i wuɔ: «Hãalãtie, i bilaa ciɛŋ daayo‑i baa bibiɛŋo. ");
INSERT INTO cmeNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","A ne da ãnjĩnamma‑na, *Moisi ciɛra wuɔ i tiɛ naŋ caamba famba temma‑i baa tãmpɛ̃lɛ̃iŋa i ko-ba. Nuɔ fuɔ, naŋ'a niɛ?» ");
INSERT INTO cmeNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ba yuu-yo dumaaŋo-na da ba ne sĩ u ka piiye cãl ba bel-o. Yesu wuɔ yaŋ-ba aa naa ture u yuŋgu‑i tuɔ nyɛgɛ̃ŋ hĩɛma-na baa u niele. ");
INSERT INTO cmeNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Baa cor ta ba yuu-yo. Baŋ yuu-yoŋ ba titirre dumaaŋo-na, wuɔ ciir u yuŋgu‑i aa naa cira: «Namaaŋo-na, umaŋ duɔ saa ce kuubabalaaŋgu dede, kutieŋo doŋ u naŋ-yo mi ne.» ");
INSERT INTO cmeNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Aa naa tiraa ture u yuŋgu‑i tuɔ nyɛgɛ̃ŋ hĩɛma-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Uŋ piiye baa-ba dumaaŋo-na, baa doŋ ta ba ta ba da-ba-diei. Ba bĩncɔiŋo yaa taa igɛ̃na aa banamba cu. Ba taa dumɛi hiere aa ji yaŋ Yesu yaa yoŋ baa ciɛŋ daayo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yesu wuɔ ciir u yuŋgu‑i aa naa cira: «Ciɛŋ nuɔ, ba curaa hie? Molo saa naŋ-ni wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ciɛŋ wuɔ cira: «Hãalãtie, molo saa naŋ-mi.» Yesu wuɔ cira: «Ãhãa! Kã, muɔmi siɛ bi gãŋ baa-ni. Ŋga baa tiraa ŋ ce kuubabalaaŋgu.» ");
INSERT INTO cmeNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ku huoŋgu-na, Yesu wuɔ ji tiraa tuɔ piiye baa nuɔmba‑i wuɔ: «Muɔmɛi fitĩnuɔ‑i nelbiliemba hɔlma-na. Umaŋ duɔ cu mi huoŋ-nu, u siɛ waa kukulma-na, u ka da gbagbaama maŋ kãaŋ baa-yo Diiloŋ-nelle‑na.» ");
INSERT INTO cmeNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","*Farisĩɛbaa baa gbɛ̃-yo wuɔ: «Nuɔ da ŋ ji ta ŋ waŋ naŋ fɛrɛŋ maama‑i, yuŋgu ce niɛ waa naŋ nelma-na?» ");
INSERT INTO cmeNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesu wuɔ cira: «Muɔ mi suyaa mi muŋhelmu‑i aa tiraa suɔ mi muŋkãmmu‑i, a ce dumaaŋo-na, da mi fiɛ ta mi waŋ mamaŋ mi kũŋgu-na, mi sa kar coima. A ne da namaaŋo‑i, na sa suɔ mi muŋhelmu, na sa suɔ mi muŋkãmmu. ");
INSERT INTO cmeNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Namaa ne nelma‑i nelbilieŋ nemma aa ta na cãl nuɔmba‑i, a ne da mɛi sa cãl nɛliɛŋo. ");
INSERT INTO cmeNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Aa da mi fiɛ cãl umaŋ, da ŋ ne-ma, ŋ da-ma ninsoŋo. Hama‑i nuɔ‑i? Mi sa ce wɛima‑i mi diei; umaŋ puɔraa-mi, uu dii baa-mi. ");
INSERT INTO cmeNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ma sĩ ma nyɛgãaŋ na *ãnjĩnamma-na wuɔ: ‹Siɛrtaaŋ da ba yu ba hãi nelma maŋ nuɔ‑i, ninsoŋo.› ");
INSERT INTO cmeNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Terieŋgu faŋgu-na, muɔ baa mi To‑i miɛmɛi siɛrtaaŋ miɛ mɛi maama-na; u yaa puɔraa-mi.» ");
INSERT INTO cmeNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Farisĩɛbaa-ba yuu-yo wuɔ: «Ŋ to dii hie?» Yesu wuɔ cira: «Na sa suɔ muɔŋo‑i na ka ce niɛ gbãa suɔ mi To‑i. Kuɔ na taa na suɔ muɔŋo‑i, naa naa gbãa suɔ mi To‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesu waa *Diilodubuɔ-na tuɔ waŋ Diiloŋ-nelma‑i aa tuɔ piiye nel daama‑i. U waa baŋ dii gbeiŋa‑i kusuɔŋ-nu ba hã Diiloŋo‑i. U belmaŋ-huɔŋguŋ ŋa naa ku saa hi dumaaŋo-na, molo saa haa u naŋga yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesu wuɔ suonu u ãndaaŋgu‑i baa-ba wuɔ: «Mi ka ta. Aa mi suyaa miɛ na ka taara-miɛ. Na siɛ bi gbãa kã miŋ kãŋ kusuɔŋ-nu; a ce dumaaŋo-na, na ka ku baa na ãmbabalma‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","*Yuifubaa baa ta ba yuu ba-naa wuɔ: «Bige‑i ciɛ wuɔ i siɛ gbãa kã uŋ kãŋ kusuɔŋ-nu? U taara duɔ ko u fɛrɛ wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesu wuɔ cira: «Namaa hilaa hĩɛmaŋ bande aa mɛi hel dɔrɔ. Hĩɛmaŋ-baamba'i namaaŋo‑i aa muɔŋo‑i hĩɛmaŋ-wuoŋ muɔ sĩ, ");
INSERT INTO cmeNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","ku'i ciɛ miɛ na ka ku baa na ãmbabalma‑i. Coima saa fa, da na saa hũu-ma wuɔ umaŋ dii gbula u yaa muɔŋo‑i, na ka ku baa na ãmbabalma‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Baa yuu-yo wuɔ: «Nuɔŋo‑i hai moloŋ nuɔnɛi?» Yesu wuɔ cira: «Mi pigãaŋ-na mi sĩnni‑i dii ku domma-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Na nelma bɔi dii mi da mi waŋ-ma baa-na, na yuŋ-maama bɔi bi dii mi da mi fiɛlnu-mɛi. Ŋga umaŋ puɔraa-mi huhurmantieŋo sĩ. Uŋ pigãaŋ-mi mamaŋ, mi waŋ ma yaa‑i baa nuɔmba‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Yesuŋ piiye baa-ba, ba saa suɔ wuɔ u gbɛ̃ u To yaa‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Wuɔ cira: «Da na ji haa *Moloŋ-Biɛŋo‑i dɔrɔ huɔŋgu maŋ nuɔ‑i, na ka suɔ suɔ wuɔ umaŋ dii gbula u yaa muɔŋo‑i. Na ka bi suɔ wuɔ mi sa ce wɛima mi fɛrɛ. Mi Toŋ waaŋ mamaŋ baa-mi, mi waŋ ma yaa‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Umaŋ puɔraa-mi, mi ce u huɔŋga‑i; a ce dumaaŋo-na uu dii baa-mi; u saa nanna-miɛ mi diei yoŋ.» ");
INSERT INTO cmeNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yesuŋ piiye dumaaŋo-na, nuɔmba bɔi hũu u nelma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","*Yuifubaa-ba maŋ naa hũyãa Yesu nelma‑i, wuɔ waŋ baa-ba wuɔ: «Da na bel mi nelma‑i nammu hãi, na ka ce mi *hãalãbieŋ namaa kelkel. ");
INSERT INTO cmeNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Na ka suɔ ninsoŋo‑i aa ninsoŋo ka ce na waa na fɛrɛŋ nuɔ.» ");
INSERT INTO cmeNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Baa cira: «Ŋ waŋ wuɔ niɛ dɛ‑i? Miɛŋo‑i *Abiramu hãayɛ̃lŋ miɛ, ii dii i fɛrɛŋ nuɔ, i saa ce nɛliɛŋ-kɔrsĩnni dede.» ");
INSERT INTO cmeNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesu wuɔ cira: «Yaaŋ mi waŋ ninsoŋo‑i baa-na: Umaŋ duɔ ce ãmbabalma‑i, kutieŋo ciɛ kɔriɛŋo ãmbabalma wulaa. ");
INSERT INTO cmeNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","A ne da kɔriɛŋo siɛ gbãa ce dũŋgu baa u yuntieŋo‑i, ŋga u yuntieŋo biɛŋo yaa gbãa ce dũŋgu‑i baa u to‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Terieŋgu faŋgu-na, Bɛpolŋ duɔ cira nuɔni maŋ dii ŋ fɛrɛŋ nuɔ, nii dii ŋ fɛrɛ nuɔ kelkel. ");
INSERT INTO cmeNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Mi suyaa miɛ Abiramu hãayɛ̃lŋ namaa, ŋga na taara na ko-mi wuɔ mi nelma sa dɔlnu-nɛi. ");
INSERT INTO cmeNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Muɔ miŋ daa mamaŋ mi To wulaa, mi waŋ ma yaa‑i. Ŋga namaaŋo‑i, na toŋ hãalãayã-nɛi mamaŋ, na ce ma yaa‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Baa cira: «Miɛ to yaa Abiramu.» Yesu wuɔ cira: «Kuɔ naa naa waa Abiramu bisãlŋ namaa kelkel, naa naa ta na ce Abiramu temma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ŋga na bir yaŋ aa ta na taara na ko-mi a ne da miŋ daa ninsoŋo maŋ mi To wulaa, mi waaŋ u yaa baa-na. Naŋ ceŋ mamaŋ mafamma‑i Abiramu maacemma'i wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Na biyaa na to u maama.» Baa cira: «Miɛŋo‑i bũɔrãaŋ miɛ sĩ; i to dii u diei yoŋ, u yaa Diiloŋo‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesu wuɔ gbɛ̃-ba wuɔ: «Muɔmi hilaa Diiloŋ-terieŋ-nu'i jo, aa mi juɔ fuɔ jomma'i. Kuɔ na to yaa naa waa Diiloŋo‑i ninsoŋo, muɔmi kũŋgu naa ta ku dɔlnu-nɛi. Mi saa jo mi fɛrɛŋ jomma, u yaa puɔraa-mi. ");
INSERT INTO cmeNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Naŋ'a na sa nu mi nelma‑i ku'i ciɛ miŋ waŋ mamaŋ baa-na, na sa suɔ ma yuŋgu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Na to yaa *Sitãni. Na taara na ce fuɔ kusũŋgu yaa‑i. Dii ku domma-na, u yii baa nelkolle yaa‑i. Uŋ'a u sa waŋ ninsoŋo‑i dumaaŋo-na, u saa siɛ ninsoŋo‑i dede. U yaa coima tieŋo‑i, a ce dumaaŋo-na u nelma‑i hiere coima. ");
INSERT INTO cmeNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ŋga muɔ fuɔ, mɛi waŋ ninsoŋo yaa‑i; ku'i ciɛ ŋ da na saa hũu mi nelma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Namaaŋo-na, hai gbãa da cãlmuɔ haa-miɛ? Da kuɔ mi waŋ ninsoŋo, bige‑i ciɛ na ta na cĩina mi nelma‑i? ");
INSERT INTO cmeNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Umaŋ duɔ waa Diiloŋ-wuoŋo, ŋ da kutieŋo nu Diiloŋo nelma‑i. Ŋga namaaŋo‑i, Diiloŋ-baaŋ namaa sĩ, ku'i ciɛ na sa nu mi nelma‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Baa cira: «Diɛ cira nuɔŋo‑i *Samariyiɛŋ nuɔ, i saa kar coima; aa *jĩna ka sire ŋ yuŋgu‑i dii.» ");
INSERT INTO cmeNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesu wuɔ cira: «Mi yuŋgu saa sire; mi kãŋ mi To yaa‑i aa namaa na yagar wuɔ na siɛ kãŋ muɔŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Mɛi sa taara mi jĩna mi fɛrɛ dɔrɔ, moloŋo'i dii tuɔ ce mafamma‑i, aa kufaŋgu tieŋo yaa suyaaŋ nɛliɛŋo nɛliɛŋo kumaŋ gbĩɛ baa-yo. ");
INSERT INTO cmeNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Yaaŋ mi waŋ ninsoŋo‑i baa-na: Umaŋ duɔ tuɔ nu mi nuŋgu‑i u sa ji suu baa kuliiŋgu‑i dede.» ");
INSERT INTO cmeNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Yesuŋ waaŋ mafamma‑i, Yuifubaa-ba gbɛ̃-yo wuɔ: «Fiɛfiɛ fuɔ, nuharuŋgu si dii, i suyaa wuɔ nii si dii gbãŋgbãŋ. Abiramu‑i baa *Diilopɔpuɔrbiemba‑i ba kuu hiere, aa naŋ ta ŋ piiye wuɔ umaŋ duɔ tuɔ nu naŋ nuŋgu‑i kutieŋo sa ji suu baa kuliiŋgu‑i dede. ");
INSERT INTO cmeNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Daa u cɔrnu dɛ! Naŋ daa niɛ sĩ naŋ maaraa i to‑i Abiramu‑i wɛi? Ŋga fuɔ u kuu, Diilopɔpuɔrbiemba tiraa ku.» ");
INSERT INTO cmeNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesu wuɔ cira: «Kuɔ muɔmɛi taa mi kaal mi fɛrɛ, yuŋgu naa saa waa-kuɔ. Ŋga mi To yaa kaalaaŋ-miŋ. Na gbɛ̃ u yaa‑i wuɔ namaa Diiloŋo ");
INSERT INTO cmeNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","aa na sa bi suɔ-yo. Muɔ fuɔ, mɛi suɔ-yo. Da mi cira mi sa suɔ-yo, mi ka ce coikartieŋ muɔ namaa temma‑i. Mi suɔ-yo aa tiraa ta mi nu u nuŋgu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Abiramu maŋ namaa to, uŋ juɔ suɔ wuɔ u ka hi mi jommaŋ-yiiŋgu‑i, u huɔŋga gbuu pãŋ fɛ̃. Uŋ juɔ da-mi, kuɔ gbuu silaa dɔlnu-yuɔ ŋaa bige‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Yuifubaa baa cira: «Naŋ saa bi hi da bieŋ komuɔŋa hãi baa cĩncieluo‑i yogo aa cira naŋ daa Abiramu‑i; ŋ daa-yo daŋ hama‑i temma‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesu wuɔ cira: «Yaaŋ mi waŋ ninsoŋo‑i baa-na: Aa Abiramu suɔ duɔ hoŋ, muɔmi maŋ dii gbula mii naa waa.» ");
INSERT INTO cmeNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Uŋ waaŋ mafamma‑i, baa biɛra tãmpɛ̃lɛ̃iŋa wuɔ ba naŋ-yo. Wuɔ yaŋ-ba aa naa fuo hel *Diilodubuɔ‑i-na ta. ");
INSERT INTO cmeNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesuŋ taa ka hi hɔlma namma‑i, wuɔ da yiroŋo naŋo. Kutieŋo huɔŋ baa u yirsĩnni‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","U *hãalãbieŋ baa yuu-yo wuɔ: «Hãalãtie, bige‑i yirii naacolŋ daayo‑i? Fuɔ fɛrɛŋ ãmbabalma'i yirii-yo waa u bĩncuɔŋ-maama'i yirii-yo?» ");
INSERT INTO cmeNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesu wuɔ cira: «Fuɔ ãmbabalma sĩ, u bĩncuɔŋ-maama bi sĩ. Diiloŋ uŋ hii dumaa, u yirii duɔ pigãaŋ nelbiliemba‑i ku yaa‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Cuo duɔ gbãŋ kaal, i saaya i tiɛ ce mi pɔpuɔrtieŋo maacemma‑i, ni ma'i sĩ, bãaŋ da ku tĩ, molo siɛ gbãa ce bĩŋkũŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Miŋ yeŋ nelbiliemba hɔlma-na, muɔmɛi ba fitĩnuɔ‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Uŋ waaŋ mafamma‑i, wuɔ tu taaluŋgu hĩɛma-na aa guɔlnu-kuɔ baa hĩɛma‑i a hure yiroŋ daa u yufieŋa-na ");
INSERT INTO cmeNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","aa naa cira: «Kã ŋ ka saar ŋ yaaŋga‑i Siloe hũnfuoŋgu-na.» (Siloe yuŋgu yaa wuɔ pɔpuɔrbiloŋo.) Naacolŋ wuɔ kã ka saar u yaaŋga‑i, u yufieŋ aa pãŋ puur; wuɔ bir tuɔ kũŋ. ");
INSERT INTO cmeNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Uŋ kãa ka hi, u caantaamba‑i baa bamaŋ taa ba suɔ-yo hiere baa piel u maa-na. Baa ta ba piiye wuɔ: «Naacolŋ daa u yaa saa tuɔ tĩɛna u cãrã wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Banaŋ ba'a u yaa‑i, banaŋ ba'a u'i sĩ kɛrɛ u nabiɛraŋo. Naacolŋ fuɔ fɛrɛ wuɔ cira: «Muɔmɛi mi fɛrɛ!» ");
INSERT INTO cmeNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Baa yuu-yo wuɔ: «Ŋ ciɛ ŋ yufieŋa‑i niɛ a puur?» ");
INSERT INTO cmeNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Wuɔ cira: «Baŋ bĩŋ naacolŋo maŋ Yesu‑i, u yaa ciɛ kpɔkpɔtuɔŋgu hure-yɛi aa cira mi kã Siloe‑i-na ka saar-a. Mi kãa ku yaa‑i ka saar-a, a pãŋ puur.» ");
INSERT INTO cmeNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Baa yuu-yo wuɔ: «Naacolŋo faŋo we‑i-na?» Wuɔ cira: «Na feŋ muɔ, mɛi suɔ hie?» ");
INSERT INTO cmeNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Yesuŋ puurii naacolŋ daayo yufieŋa‑i yiiŋgu maŋ nuɔ‑i, ku waa *yitĩɛnaŋgu. Naacolŋ uŋ piiye dumaaŋo-na, baa bel-o kã baa-yo *Farisĩɛbaa-ba wulaa. ");
INSERT INTO cmeNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Farisĩɛbaa baa bi yuu-yo u yufieŋaŋ ciɛ dumaa puur. Wuɔ cira: «U huure kpɔkpɔtuɔŋgu yɛi aa cira mi kã ka saar mi yaaŋga‑i. Mi kãa ka saar-ka ku yaa nuɔ‑i, mi yufieŋa puur.» ");
INSERT INTO cmeNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Farisĩɛbaa-ba namba ta ba piiye wuɔ: «Naacolŋo maŋ ciɛ maaceŋ daama‑i u siɛ gbãa jo Diiloŋ-jomma. Na saa da, u sa kãŋ yitĩɛnaŋgu baa u maacemma‑i.» Banaŋ ba'a: «Ãmbabalmanceroŋ hayo‑i gbãa ce nel daama temma‑i?» Kuŋ ciɛ dumaaŋo-na, baa hel ba-naa honniŋ. ");
INSERT INTO cmeNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Farisĩɛbaa baa yuu naacolŋo‑i wuɔ: «Nuɔ fuɔ, naŋ'a niɛ naacolŋ daayo kũŋgu-na?» Wuɔ cira: «Mɛi wulaa, *Diilopɔpuɔrbiloŋo.» ");
INSERT INTO cmeNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","*Yuifubaa baa sire wuɔ naacolŋ daa u saa naa yir. Baa bĩ u bĩncuɔmba jo. ");
INSERT INTO cmeNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","20","Baŋ juɔ, baa yuu-ba wuɔ: «Namaa biɛŋo‑i naacolŋ daayo‑i wɛi?» Baa cira: «Ũu, miɛ biɛŋo.» Yuifubaa ba'a: «U huɔŋ baa yirsĩnni‑i wɛi?» Naacolŋo bĩncuɔŋ ba'a: «Ũu, u huɔŋ baa-ni.» Yuifubaa ba'a: «U yufieŋa ciɛ niɛ aa puur fiɛfiɛ‑i-na?» ");
INSERT INTO cmeNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","U bĩncuɔŋ ba'a: «Coima saa fa, i saa suɔ u yufieŋaŋ ciɛ dumaa puur, aa i saa bi tiraa suɔ umaŋ puurii-ya.» Aa naa cira: «Yuuŋ fuɔ fɛrɛ‑i, bisãlãaŋo sĩ; maŋ ciɛ dumaa, u ka waŋ-ma baa-na.» ");
INSERT INTO cmeNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Kumaŋ naa ciɛ ba waŋ mafamma‑i, Yuifubaa baa wurii-ba wuɔ umaŋ duɔ cira Diiloŋ uŋ pãa nuŋgu‑i wuɔ u ka saaŋ *Koŋkortieŋo maŋ u yaa Yesu‑i, ba nyaa kutieŋo‑i *Diilonelhãalãdũŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Kufaŋgu korma'i naa ciɛ u bĩncuɔmba cira ba yuu fuɔ fɛrɛ‑i bisãlãaŋo sĩ. ");
INSERT INTO cmeNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ku huoŋgu-na, Farisĩɛbaa-ba tiraa ji bĩ naacolŋo‑i ji cira: «Ne Diiloŋo‑i aa ŋ waŋ ninsoŋo‑i; naacolŋ daayo‑i nelfɛfɛiŋo sĩ, miɛ fɛrɛ‑i i suyaa-ma.» ");
INSERT INTO cmeNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Naacolŋ wuɔ cira: «Mɛi siɛ gbãa cira nelfɛfɛiŋo, mɛi siɛ bi gbãa cira nelfɛfɛiŋo sĩ. Ŋga ma diei maama maŋ mɛiŋ suyaa-ma: U puurii mɛi yufieŋa‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Baa yuu-yo wuɔ: «U ciɛ-ni niɛ? U puurii ŋ yufieŋa‑i puur hama‑i temma‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Naacolŋ wuɔ cira: «Mi waaŋ-ma baa-na, na saa yiɛra nu-ma. Bige‑i ciɛ na'a mi tir-ma? Namaa na bi taara da na ce u *hãalãbieŋ namaa wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Baa pãŋ ta ba tuora-yuɔ aa naa cira: «Nuɔnɛi u hãalãbiloŋ nuɔ! Miɛ fuɔ, *Moisi hãalãbieŋ miɛ. ");
INSERT INTO cmeNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","I suyaa wuɔ Diiloŋo piiye baa Moisi‑i, ŋga daayo‑i i sa suɔ u muŋhelmu!» ");
INSERT INTO cmeNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Naacolŋ wuɔ cira: «Namaa gbɛrɛ! Na sa suɔ u muŋhelmu a ne da u puurii mɛi yufieŋa‑i! ");
INSERT INTO cmeNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Na suyaa kerre wuɔ Diiloŋo sa nu nelbabalaamba nunni‑i dɛ! Umaŋ duɔ tuɔ wuɔ u hũmelle‑i aa tuɔ ce u huɔŋga‑i u nu fuɔ nuŋgu yaa‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Moloŋo maŋ huɔŋ baa yirsĩnni‑i, iŋ siire ji hi baa nyuŋgo, i saa nu-ma dede wuɔ mɛlŋ daayo puurii kutieŋo yufieŋa‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Kuɔ naacolŋ daa u saa naa jo Diiloŋ-jomma, uu naa saa gbãa ce bĩŋkũŋgu.» ");
INSERT INTO cmeNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Baa cira: «Daa u cɔrnu dɛ! Nuɔni maŋ huɔŋ baa ãmbabalma‑i, nuɔnɛi gbãa pigãaŋ miɛŋo‑i nelma wɛi?» Aa naa pãŋ nyaa-yo hiel-o Diilonelhãalãdũŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Baŋ duɔnya naacolŋo‑i, Yesu wuɔ nu-ma aa kã u wulaa ka yuu-yo wuɔ: «Ŋ haa ŋ naŋga‑i *Moloŋ-Biɛŋo-na wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Naacolŋ wuɔ: «Hãalãtie, u yaa hai? Pigãaŋ-mi baa-yo; mi taara mi hũu u maama‑i!» ");
INSERT INTO cmeNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesu wuɔ: «U yaa ŋ yaaŋga-na; u yaa piiyeŋ baa-ni.» ");
INSERT INTO cmeNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Naacolŋ wuɔ: «Itie, mi hũyãa-ma.» Aa naa pãŋ dũuna Yesu yaaŋga-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesu wuɔ cira: «Mi juɔ hĩɛma-na da mi ji ce nelma diei. Mi juɔ da mi ji puur yiriemba yufieŋa‑i aa suuye bamaŋ daaŋ ba waaŋa‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","*Farisĩɛbaa-ba namba waa u caaŋgu-na, baa cira: «Miɛ fuɔ i saa yir yogo.» ");
INSERT INTO cmeNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesu wuɔ cira: «Kuɔ naa naa suɔ-ma wuɔ na yirii, ãmbabalma naa saa waa-nɛi, ŋga naŋ ciɛra namaa saa yir, na ãmbabalma dii ma temma‑i yogo.» ");
INSERT INTO cmeNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Baŋ tĩyãa nelma famma-na, Yesu wuɔ ji naŋ gbãnalãaŋ daaku‑i baa-ba wuɔ: «Umaŋ duɔ yaŋ naatuɔŋgu dumɛlle‑i aa suur yaŋga naŋga, coima saa fa, ba bĩ u yaa‑i cuoyuo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ŋga umaŋ duɔ suur baa dumɛlle‑i, u yaa naatuɔntieŋo‑i, u yaa ãncĩinaŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Tũlmba suɔ ba tieŋo‑i. Duɔ kã dɛ‑i-na, umaŋ niɛyaŋ naatuɔŋgu‑i u sire puur dumɛlle‑i hã-yo, u tuɔ bĩ tũlmba‑i ba yirɛiŋ-na ba da-ba-diei, ba ta ba hel. ");
INSERT INTO cmeNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Baŋ suɔ-yoŋ dumaaŋo-na, duɔ ji bĩ-ba ba hel hiere, u ta ba yaaŋ-na aa ba cu-yo. ");
INSERT INTO cmeNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ŋga da ba'a ba sa suɔ-ni, ba siɛ siɛ cu ŋ huoŋ-nu. Baŋ'a ba sa suɔ ŋ yalle‑i, da ŋ bĩ-ba, ba bir yaŋ aa ta ba gbar-niɛ.» ");
INSERT INTO cmeNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesuŋ naaŋ gbãnalãaŋ daaku‑i, ba saa suɔ ku yuŋgu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Wuɔ tiraa cira: «Yaaŋ mi waŋ ninsoŋo‑i baa-na: Muɔmɛi naatuɔŋgu dumɛlle‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Bamaŋ juɔ yaaŋga muɔmi-na hiere, cuobaa; ŋga tũlmba saa nu ba nunni‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Muɔmɛi dumɛlle‑i. Umaŋ duɔ suur baa dumɛlle‑i, kutieŋo kuraa. U gbãa tuɔ suur aa tuɔ hel kuŋ dɔlaanu-yuɔ dumaa, aa u ka tuɔ da u niiwuoni‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Cuoyuo jommaŋ-yuŋgu yaa a ji cuo, sisɔ a ji ko, da ma'i bi sĩ a ji guɔla. Ŋga muɔmi juɔ da mi ji kor nelbiliemba‑i ba waa ba fɛrɛŋ nuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","«Da ŋ nu wuɔ ãncĩinafɛfɛiŋo‑i, u yaa muɔŋo‑i. Umaŋ ka hũu-ma ku u tũlmba maama-na, u yaa ãncĩinafɛfɛiŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Da ba biɛ umaŋ u tuɔ ceŋ tũlmba‑i, ba sa bĩ ufaŋo‑i ãncĩinaŋo. Tũlmba‑i fuɔ baamba sĩ; u taara gbeiŋa. Fuɔ temma‑i, duɔ ji da jara jo, u gbar aa yaŋ u jo ji bel u yufelleŋ-wuoŋo‑i ta. ");
INSERT INTO cmeNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Fuɔ juɔ duɔ ji taara gbeiŋa; tũlmba maama ce niɛ aa waa kpelle u huɔŋga-na? ");
INSERT INTO cmeNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Muɔmɛi ãncĩinafɛfɛiŋ muɔŋo‑i. Muɔ baa mi To‑i iŋ suɔ i-naa dumaa, muɔ baa mi tũlmba‑i i bi suɔ i-naa dumɛi. Aa mi hũyãa-ma da mi ku ba maama-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Tũlmba namba bi dii baa-mi yaŋga naŋga. Mi saaya mi kã ka nyaa-ba jo baa-ba tũusɛ̃lle ji ce di diei aa ãncĩinaŋo bi waa u diei. Da mi kã, ba ka nu mi nuŋgu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","«Miŋ hũyãa-ma da mi ku mi tũlmba maama-na aa da mi sire, ku ciɛ mi maama ta ma dɔlnu mi To‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Muɔ da mi saa siɛ, molo siɛ gbãa ko-mi. Ku dɔlaanu muɔmɛi mi pã mi fɛrɛ. Ku fɔ̃ŋgũɔ dii-miɛ mi da mi ku aa sire. Mi To puɔraa-mi baa ma yaa‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Yesuŋ waaŋ mafamma‑i, *Yuifubaa baa tiraa hel ba-naa honniŋ. ");
INSERT INTO cmeNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ba fɔ̃ŋgũɔ baa ta ba piiye wuɔ: «Naacolŋ daa u yuŋgu si dii! *Jĩna dii-yuɔ! Baa na ta na nu u nelma‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Banaŋ ba'a: «Jĩna duɔ waa moloŋo maŋ nuɔ‑i, u siɛ gbãa piiye dumandɛ‑i-na. Namaa daa jĩna ba nolŋo gbãa puur moloŋ yufieŋa wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Waaŋ-huɔŋguŋ juɔ hi, *Yuifubaa baa ta ba ce *Diilodubuɔ *migãamaŋ-ponsaaŋgu‑i *Yerusalɛmu‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesu wuɔ kã ka tuɔ wuɔra u bĩŋ *Salomɔ kukuruuŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Yuifubaa baa kã ka cĩilã-yuɔ aa naa yuu-yo wuɔ: «Ŋ ka kaala ŋ nelma‑i baa-ye yaku‑i? Da kuɔ Diiloŋ uŋ pãa nuŋgu‑i wuɔ u ka saaŋ *Koŋkortieŋo maŋ u yaa nuɔŋo‑i, waŋ ninsoŋo‑i baa-ye kɛ!» ");
INSERT INTO cmeNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesu wuɔ cira: «Mi waaŋ-ma baa-na cor tĩ, ŋga na saa hũu-ma. Miŋ ceŋ mamaŋ mi To yerre-na ma yaa pigãaŋ mi sĩnni‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ŋga naŋ'a naa sĩ mɛi tũlŋ namaa, na saa hũu mi nelma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Mi suɔ mi tũlmba‑i. Ba nu mi nelma‑i aa ta ba nyaanu-miɛ. ");
INSERT INTO cmeNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Mi hã-ba cicɛ̃lma maŋ sa tĩɛŋ dede. Ba cɛraa ba ku, aa molo siɛ gbãa hũu-ba mi wulaa. ");
INSERT INTO cmeNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Mi To yaa hãa-mi baa-ba, u fɔ̃ŋgũɔ jĩɛnya nuɔmba‑i hiere ba wuoŋo‑i, a ce dumaaŋo-na, molo siɛ gbãa hũu u diei u wulaa. ");
INSERT INTO cmeNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Muɔ baa mi To‑i kuuduɔŋgu yaa‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Uŋ piiye dumaaŋo-na, Yuifubaa baa tiraa biɛra tãmpɛ̃lɛ̃iŋa da ba naŋ-yo. ");
INSERT INTO cmeNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Wuɔ gbɛ̃-ba wuɔ: «Mi To ciɛ mi ce nelfafamma bɔi pigãaŋ-na. Miŋ ciɛ mamaŋ, na taara na naŋ-mi ko-mi hama‑i yuŋ-nu'i jebi?» ");
INSERT INTO cmeNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Yuifubaa ba'a: «Niŋ ciɛ nelfafamma maŋ, i saa cira i naŋ-ni mafamma maa-na; niŋ wuɔraŋ ŋ bĩɛna Diiloŋo yerre‑i wuɔ nuɔ Diiloŋ nuɔ, ku'i ciɛ yiɛ i naŋ-ni ko-ni.» ");
INSERT INTO cmeNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesu wuɔ: «Ma nyɛgãaŋ na *ãnjĩnamma-na wuɔ Diiloŋo ciɛra: ‹Namaaŋo‑i naa dii ŋaa Diiloŋo.› ");
INSERT INTO cmeNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Diiloŋ-nelmaŋ vii bamaŋ, Diiloŋo ciɛra wuɔ baa dii ŋaa Diiloŋo. I siɛ bi gbãa maar Diiloŋ-ãndaaŋgu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Uŋ hielaa muɔmi maŋ puɔr-mi mi jo hĩɛma-na, bige‑i ciɛ da mi cira Diiloŋ-Biɛŋ muɔ, na'a mi bĩɛna Diiloŋo yerre? ");
INSERT INTO cmeNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Da kuɔ mi sa ce mi To maacemma, baa na hũu mi nelma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ŋga da kuɔ mi ce ma yaa‑i, hũyãaŋ-maŋ. Da na fiɛ'a na saa haa na naŋga miɛ, miŋ ceŋ mamaŋ, hũyãaŋ-maŋ wuɔ Diiloŋ-maacemma; ku yaa na ka suɔ wuɔ mi To dii baa-mi aa mi bi waa baa-yo.» ");
INSERT INTO cmeNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Uŋ waaŋ mafamma‑i, Yuifubaa baa tiraa sire wuɔ ba bel-o. Wuɔ kor ba wulaa. ");
INSERT INTO cmeNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ku huoŋgu-na, Yesu wuɔ bir kã *Yurdɛ̃ bomborre nande-na, dii Nsãaŋ taa u *batiseŋ nuɔmba‑i kusuɔŋ-nu, ka tĩɛna da huɔŋgu cɛllɛ. ");
INSERT INTO cmeNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Nuɔŋ baa kũɔl ba-naa nyaa u huoŋ-nu. Ba taa ba piiye wuɔ: «Nsãaŋ siire, u saa ce himma dede. Ŋga uŋ waaŋ mamaŋ hiere naacolŋ daayo kũŋgu-na, ninsoŋo.» ");
INSERT INTO cmeNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Nuɔmba bɔi hũyãa Yesu nelma‑i terieŋgu faŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Yesu jĩɛŋo naŋo waa Betani‑i-na ba taa ba bĩ-yo Lasaar. U tũɔbaa-ba waa ba hãi: Ba taa ba bĩ unaŋo‑i Marti aa bĩ unaŋo‑i Maari. Maari faŋo yaa naa kũɔna natikolo-hũmma‑i Itieŋo gbeini-na aa naa hurre-niɛ baa u yukuɔsĩnni‑i. Lasaar wuɔ ji cii jarma-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","U tũɔbaa-ba puɔr ba ka waŋ baa Yesu‑i wuɔ u jĩɛŋo jaŋ. ");
INSERT INTO cmeNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Baŋ waaŋ-ma, Yesu wuɔ cira: «Jarŋ daama saa jo da ma ji ko Lasaar, ŋga ma juɔ da ma ji ce Diiloŋo‑i bɔi baa u Biɛŋo‑i hiere.» ");
INSERT INTO cmeNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Lasaar baa u tũɔbaa-ba‑i, ba maama taa ma dɔlnu Yesu‑i ma cor. ");
INSERT INTO cmeNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Baŋ tũɔnu-yuɔ wuɔ Lasaar si dii hĩnni, wuɔ yaŋ yinni hãi cor ");
INSERT INTO cmeNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","aa naa suɔ gbɛ̃ u *hãalãbiemba‑i wuɔ: «I ka bir kã *Yude‑i-na.» ");
INSERT INTO cmeNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","U hãalãbiemba cira: «Hãalãtie, ma sĩ *Yuifubaa-ba taa ba taara ba naŋ-ni baa tãmpɛ̃lɛ̃iŋa ko-ni terieŋgu faŋgu-na kɛ? Ku saa bi da yinni yogo aa ŋ'a i bir kã!» ");
INSERT INTO cmeNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesu wuɔ naŋ gbãnalãaŋ daaku‑i baa-ba wuɔ: «Ma sĩ lɛrbaa cĩncieluo ba hãi dii bãaŋgu-na kɛ? Da ŋ ta ŋ wuɔ bãaŋgu-na, ŋ sa tisĩŋ ŋ fɛrɛ dumaa, ");
INSERT INTO cmeNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","ŋga da ŋ ta ŋ wuɔ isuɔŋgu-na, cecer maa sĩ, ŋ sa gbãŋ aa tisĩŋ ŋ fɛrɛ.» ");
INSERT INTO cmeNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Uŋ waaŋ mafamma‑i, wuɔ cira: «I jĩɛŋo‑i Lasaar yaa kuraa duɔfũŋ, mi ka kã ka pĩŋ-yo.» ");
INSERT INTO cmeNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","U hãalãbiemba cira: «Da kuɔ u kuraa duɔfũŋ, yaŋ-yo fafalmu ka da-yuɔ.» ");
INSERT INTO cmeNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yesu taa u taara u waŋ Lasaar kuliiŋgu maama yaa baa-ba dumaaŋo-na, ŋga ba saa suɔ. Bafamba daa niɛ sĩ u waŋ duɔfũgbãŋgbãlãmmuŋ maama. ");
INSERT INTO cmeNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Baŋ'a ba saa suɔ Yesu nelma yaaŋga‑i dumaaŋo-na, wuɔ naa wuɔ waŋ-ma gbar-ma baa-ba wuɔ Lasaar jarma yaraa-yo. ");
INSERT INTO cmeNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Aa naa cira: «Uŋ'a u saa ku mi caaŋ-nu, ku dɔlaanu-miɛ cor. Ku ka kãyã-nɛi na haa na naŋga‑i miɛ fafamma. Siireŋ i ka ne kuŋ yeŋ dii dumaa.» ");
INSERT INTO cmeNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","U hãalãbiloŋo naŋo waa, ba taa ba bĩ-yo Toma, Girɛkibaa ba'a Didimu; ku yuŋgu yaa wuɔ pĩɛbaa. Fuɔ wuɔ gbɛ̃ u nahãalãbiemba namba‑i wuɔ: «Yaaŋ i kã, da ku ka waa kuliiŋgu, i bi ku baa Itieŋo‑i hiere.» ");
INSERT INTO cmeNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yesuŋ kãa ka hi, wuɔ nu wuɔ baŋ fuuriiye Lasaar u yinni naa yaa waa yiiŋgu faŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani‑i baa *Yerusalɛmu‑i ku saa yu kilobaa-ba siɛi, ");
INSERT INTO cmeNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","a ce dumaaŋo-na, *Yuifubaa bɔi baa hilaa kã da ba ka jaal kuliiŋgu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Martiŋ juɔ nu wuɔ Yesu jo dii, wuɔ sire tuɔ jãrã-yuɔ aa naa yaŋ Maari yaa tĩɛna dumɛlle-na baa niraamba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Uŋ kaa hi, wuɔ gbɛ̃ Yesu‑i wuɔ: «Itie, kuɔ nii naa waa, mi tũɔ naa saa ku. ");
INSERT INTO cmeNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ŋga mi suyaa miɛ niŋ yeŋ terieŋgu maŋ nuɔ‑i fiɛfiɛ‑i-na, da ŋ cãrã kumaŋ Diiloŋo wulaa, u ka hã-ni baa-ku.» ");
INSERT INTO cmeNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesu wuɔ cira: «Ŋ tũɔ ka sire.» ");
INSERT INTO cmeNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marti wuɔ cira: «Mi suyaa miɛ miwaaŋo tĩmmaŋ-yiiŋgu-na, kuoŋ da ba ji ta ba sire, u ka sire.» ");
INSERT INTO cmeNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesu wuɔ cira: «Muɔmɛi siireŋ kuomba‑i aa muɔmɛi cicɛ̃lma‑i. Umaŋ duɔ haa u naŋga miɛ, duɔ fiɛ ku, u ka sire. ");
INSERT INTO cmeNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Aa umaŋ duɔ haa u naŋga miɛ, u cɛraa u ku; ku yuŋgu yaa wuɔ u daa cicɛ̃lma maŋ sa tĩɛŋ dede‑i. Ŋ hũyãa mafamma‑i wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marti wuɔ: «Itie, mi hũyãa-ma. Mi hũyãa-ma wuɔ *Koŋkortieŋo maŋ naa saaya u jo, u yaa nuɔŋo‑i. Nuɔnɛi Diiloŋ-Biɛŋ nuɔŋo‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Martiŋ waaŋ mafamma‑i, wuɔ ta kũŋ. Uŋ kaa hi, wuɔ cuo bĩ Maari‑i a waŋ baa-yo wuɔ: «Hãalãtieŋo juɔ; wuɔ mi ji waŋ baa-ni ŋ kã u wulaa.» ");
INSERT INTO cmeNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maariŋ nuɔ mafamma‑i, wuɔ pãŋ sire baa gbaruŋgu tuɔ kã Yesu wulaa. ");
INSERT INTO cmeNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yesu wuɔ sa hi suur nelleŋ-huɔŋga-na yogo, Martiŋ kãa ka da-yo terieŋgu maŋ nuɔ‑i, u waa yogo kusuɔŋ-nu'i. ");
INSERT INTO cmeNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Yuifubaa-ba maŋ waa ta ba ce jaaluŋgu‑i, baŋ juɔ da Maari tãanu hel dumaaŋo-na, baa sire cu u huoŋ-nu wuɔ sĩ u kã tɔ̃ɛŋo cĩncorre'i nuɔ‑i duɔ ka kaal. ");
INSERT INTO cmeNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Wuɔ kã ka hel Yesu terieŋgu-na. Uŋ kaa'a u ne da Yesu‑i, wuɔ kã ka dũuna u yaaŋga-na aa naa cira: «Itie, kuɔ nii naa waa, mi tũɔ naa saa ku.» ");
INSERT INTO cmeNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Aa pãŋ haa u nammu‑i u yuŋ-nu. Bamaŋ naa kãa baa-yo, baa bi kã ba ta ba kaal hiere. Yesuŋ daa baŋ kaal dumaaŋo-na, u huɔŋ kaa pãŋ kũɔl. ");
INSERT INTO cmeNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Wuɔ yuu-ba wuɔ: «Na fuuriiye-yuɔ hie?» Baa cira: «Itie, jo i ta i ka pigãaŋ-ni baa terieŋgu‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesu wuɔ pãŋ doŋ tuɔ kaal. ");
INSERT INTO cmeNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Yuifubaa baa ta ba piiye baa ba-naa wuɔ: «Na saa da, kuloŋo maama taa ma dɔlnu-yuɔ dɛ!» ");
INSERT INTO cmeNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Banaŋ baa ta ba piiye wuɔ: «Ma sĩ u yaa puurii yiroŋo yufieŋa‑i kɛ? Bige‑i ciɛ u saa cie Lasaar baa ku?» ");
INSERT INTO cmeNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yesu huɔŋgaŋ ŋa naa gbuu kũɔl dumaaŋo-na, wuɔ kã ba kã cĩncorre terieŋgu-na. Di waa tãmpɛ̃fuoŋ-nu aa ba ce tãmpɛ̃lle suuye di nuŋgu‑i. Baŋ kaa hi, ");
INSERT INTO cmeNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","wuɔ cira: «Halaaŋ tãmpɛ̃lle‑i!» Marti wuɔ cira: «Itie, u yinni naa yaa dɛ‑i uŋ fuuriiye; u ka doŋ tuɔ hũŋ dii.» ");
INSERT INTO cmeNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesu wuɔ cira: «Marti, ma sĩ mi waaŋ-ma baa-ni miɛ da ŋ haa ŋ naŋga miɛ ŋ ka da Diiloŋ uŋ hii dumaa kɛ?» ");
INSERT INTO cmeNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Baa halaŋ tãmpɛ̃lle‑i. Yesu wuɔ tã u yuŋgu‑i dɔrɔ aa naa cira: «Baba, niŋ nuɔ mi nuŋgu‑i mi jaal-ni bɔi. ");
INSERT INTO cmeNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Mi suyaa miɛ ŋ sa yagar mi nuŋgu‑i, ŋga bamaŋ dii mi caaŋgu-na mi piiye ba yaa da ba suɔ wuɔ nuɔnɛi puɔraa-mi.» ");
INSERT INTO cmeNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Uŋ waaŋ mafamma‑i, wuɔ piiye da gbagaga wuɔ: «Lasaar, sire ŋ hel ŋ jo bande!» ");
INSERT INTO cmeNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Kuloŋ wuɔ hel jo; u gbeini fĩɛnya baa u nammu‑i hiere ka hel baa u yuŋgu‑i. Yesu wuɔ cira: «Firiiŋ-yoŋ aa na yaŋ u kã!» ");
INSERT INTO cmeNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","*Yuifubaa bɔi baa kãa Maari ba terieŋgu-na da ba ka jaal ba tũɔ kuliiŋgu‑i. Baŋ juɔ da Yesu ciɛ nel daama‑i, ba fɔ̃ŋgũɔ baa hũu u maama‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Banaŋ baa bir yaŋ aa kã ka tũnu *Farisĩɛbaa-ba‑i baa uŋ ciɛ mamaŋ. ");
INSERT INTO cmeNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Baŋ tũɔnu-bɛi dumaaŋo-na, *Diilojigãntaamba yuntaamba‑i baa Farisĩɛbaa baa tigiiŋ *nellentaamba‑i aa naa cira: «Naacolŋ daa u wuɔra u ce himma bɔi, i ka ce niɛ? ");
INSERT INTO cmeNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Diɛ bi yaŋ u cor tuɔ ce, nuɔmba‑i hiere ba ka cu u huoŋ-nu. Da ŋ bi da ba cuu u huoŋ-nu, *Oromɛbaa-ba ka jo ji muonu i *Diilodubuɔ‑i aa ko-ye hiere.» ");
INSERT INTO cmeNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Unaŋo waa ba hɔlma-na, ba taa ba bĩ-yo Kayifu. U yaa waa *Diilojigãntaamba yuntieŋo‑i belle fande-na. Fuɔ wuɔ cira: «Na sa suɔ ku yaaŋga‑i dɛ! ");
INSERT INTO cmeNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Na saa suɔ wuɔ nelduɔŋ duɔ ku a kor nelle‑i hiere ku bɔyaa nelle da di muonu wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kayifuŋ waaŋ nelma maŋ daama‑i fuɔ maawamma sĩ. Uŋ waa Diilojigãntaamba yuntieŋo‑i belle fande-na dumaaŋo-na, Diiloŋo yaa diyaa-ma u nuŋgu-na, wuɔ Yesu yaa saaya u ku Yuifubaa-ba maama-na ");
INSERT INTO cmeNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","aa bi ku tigiiŋ Diiloŋ-bisãlmba maŋ dii hĩɛŋgu-na a ce-ba kuuduɔŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Yinduɔŋgu faŋgu-na, Yuifu ba yuntaaŋ baa yiɛra-mɛi wuɔ fuɔ ba ko Yesu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Baŋ puu mafamma‑i, Yesu wuɔ yaŋ-ba aa tuɔ fuo u hel. Duɔ hel u sa yaŋ ba da-yo. Ku huoŋgu-na, wuɔ ji ta baa u *hãalãbiemba‑i ka tĩɛna nelle nande-na ba bĩ-de Efiramu, di saa maa baa hĩɛkuraaŋgu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","*Kɔrsĩnni tĩmmaŋ-ponsaaŋguŋ juɔ piɛ, *Yuifubaa baa jãnu ba-naa da bãmbãale *Yerusalɛmu‑i-na da ba tigiiŋ ba fɛrɛ a saa baa ba Diiloŋ-hũmelle‑i aa ponsaaŋgu suɔ da ku hi. ");
INSERT INTO cmeNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Nuɔmbaŋ juɔ dumaaŋo-na, baa ta ba taara Yesu‑i Diilodubuɔ dumɛlle huɔŋga-na, ba sa da-yo ba da-yo. Baa ta ba piiye wuɔ: «Na yuu ba'a naacolŋ daayo ka jo ponsaaŋ daaku-na wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","A ne da Diilojigãntaamba yuntaamba‑i baa Farisĩɛbaa-ba naa waŋ baa nuɔmba‑i wuɔ umaŋ duɔ suɔ uŋ yeŋ kusuɔŋ-nu, kutieŋo pigãaŋ-ba baa-yo ba ka bel-o. ");
INSERT INTO cmeNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","*Kɔrsĩnni tĩmmaŋ-ponsaaŋguŋ juɔ tĩɛ yinni niediei aa da ku hi, Yesu wuɔ kã Lasaarbaa-ba wulaa dii Betani‑i-na. Lasaar faŋo yaa naa kuu aa Yesu wuɔ sire-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Uŋ kãa, baa haa bituoŋgu u yerreŋ. Marti yaa ciɛ niiwuoni‑i aa biɛ hã-ba. Lasaar waa baa-ba tuɔ wuo. ");
INSERT INTO cmeNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Maari wuɔ biɛ natikolo naŋo‑i litiri boluoŋgu, a kũnna Yesu gbeini-na aa ce u yukuɔsĩnni‑i hurre-niɛ. Natikolo faŋo‑i baa ciɛ-yo baa *naar-yɔmma ma kula. U sullu waa kpelle. Wuɔ sire nyaayã dũŋgu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Yesu *hãalãbiloŋo maŋ ba naŋ bĩŋ-yoŋ *Yuda‑Isikaro‑i, umaŋ juɔ hel Yesu huoŋgu-na, wuɔ cira: ");
INSERT INTO cmeNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«Natikolo daayo naa gbãa da *deniebaa nuɔsũɔ komuɔŋa ndii. Bige‑i ciɛ u saa yaŋ i suor-o a hã sũntaamba baa gbeiŋa faŋa‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ku saa ce ŋaa sũntaamba hujarre waa-yuɔ ku'i ciɛ u tuɔ waŋ mafamma‑i dɛ! U taa u waŋ-ma baa u huɔya-maama. U yaa taa u tiera ba gbeiŋa‑i, a ne da u taa u cuo; a ce dumaaŋo-na u taa u dii u naŋga‑i yɛi. ");
INSERT INTO cmeNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Uŋ waaŋ mafamma‑i, Yesu wuɔ cira: «Yuda, yaŋ ciɛŋo fiisa! U kũɔna natikolo daayo‑i miɛ tuɔ cie mi kuliiŋgu yaa‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Sũntaamba dii baa-na bãaŋgu‑i baa isuɔŋgu‑i, ŋga muɔmi siɛ tĩɛna baa-na gbula.» ");
INSERT INTO cmeNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","*Yuifubaa-baŋ juɔ nu wuɔ Yesu juɔ dii Betani‑i-na, baa sire kaal ba-naa kã da ba ka ne-yo aa bi ne Lasaar. ");
INSERT INTO cmeNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","*Diilojigãntaamba yuntaaŋ baa sire wuɔ ba ko Lasaar ");
INSERT INTO cmeNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","wuɔ u siremma ciɛ Yuifubaa bɔi nanna ba bĩncuɔŋ-hũmelle‑i aa hũu Yesu maama‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ku cuo kaala‑i-na, nelpũŋgu maŋ naa juɔ *Yerusalɛmu‑i-na da ba ji ce *kɔrsĩnni tĩmmaŋ-ponsaaŋgu‑i, baa nu-ma hiere ka saa wuɔ Yesu jo dii. ");
INSERT INTO cmeNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Baa sire kar nampurni ta ba kã da ba ka jãrã-yuɔ. Ba taa ba hãl wuɔ: «Diiloŋo temma si dii! Itieŋ uŋ saaŋ umaŋ jo, Diilo baa-yo! Diilo baa *Isirahɛl-baamba nellentieŋo‑i!» ");
INSERT INTO cmeNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesuŋ joŋ hũmelle-na, wuɔ ji da kakũmuɔ naŋo‑i, wuɔ bel-o nyugũŋ. Ma bi nyɛgãaŋ dumɛi Diiloŋ-nelma-na wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«*Sinyɔtaaŋ namaa, baa na tie holle. Niɛŋ, na nellentieŋo'i juɔŋ daayo na wulaa. U nyugãaŋ tĩɛna kakũmbiloŋ-na.» ");
INSERT INTO cmeNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Nel daamaŋ taa ma ce huɔŋgu maŋ nuɔ‑i, u *hãalãbiemba saa naa suɔ ma yaaŋga‑i. Yesuŋ juɔ nyugũŋ kã dɔrɔ‑i-na, maa suɔ tĩɛnu-bɛi wuɔ *Diilopɔpuɔrbiembaŋ waaŋ mamaŋ u kũŋgu-na, ma yaa taa ma ce-yuɔ dumaaŋo-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Bamaŋ waa hiere da uŋ siire Lasaar dumaa, baa ta ba waŋ-ma baa nuɔmba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Nuɔmbaŋ nuɔ gbɛrɛ daayo maama‑i, baa kũɔl ba-naa ta ba jo u wulaa. ");
INSERT INTO cmeNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","*Farisĩɛbaa baa ta ba piiye baa ba-naa wuɔ: «Ma sĩ na daa kɛ? Nuɔmba‑i hiere baa dii u huoŋ-nu; ma maaraa-na na gbãa ce bĩŋkũŋgu!» ");
INSERT INTO cmeNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Bamaŋ naa juɔ *Yerusalɛmu‑i-na da ba ji jaal Diiloŋo‑i ponsaaŋgu-na, Girɛkibaa-ba bi waa-bɛi. ");
INSERT INTO cmeNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Baa kã ka ta ba piiye baa Filipu‑i wuɔ: «I taara diɛ piiye baa Yesu‑i.» Filipu waa Yesu *hãalãbiloŋo. U taa u hel Betisada dii *Galile mara nuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipu wuɔ kã ka tũnu Ãndere. Baa sire ba hãi‑i-na ka hi Yesu‑i baa-ma. ");
INSERT INTO cmeNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesu wuɔ cira: «*Moloŋ-Biɛŋo uŋ ka da yerre huɔŋgu maŋ nuɔ‑i, ku yaa hii daaku‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Aa naa cira: «Yaaŋ mi waŋ ninsoŋo‑i baa-na: Da ŋ da dĩbelle saa suur hĩɛma-na a hɔr, di bi tĩɛ di diei yaa‑i; ŋga da di suur hĩɛma-na a hɔr, ŋ da di diyaa bieŋa bɔi. ");
INSERT INTO cmeNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Umaŋ duɔ tuɔ dɔl u fɛrɛ, kutieŋo ka kɔsuɔŋ u fɛrɛ; ŋga umaŋ duɔ hiel u naŋga u fɛrɛŋ nuɔ miwaaŋ daayo-na, kutieŋo ka da cicɛ̃lma maŋ sa tĩɛŋ dede‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Umaŋ duɔ tuɔ taara duɔ ce mi cãarãŋo, kutieŋo saaya u tuɔ nyaanu-miɛ. Muɔ da mi waa kusuɔŋ-nu, mi cãarãŋo ka bi waa kusuɔŋ-nu'i. Mi To ka ce mi cãarãŋo ce bɔi. ");
INSERT INTO cmeNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","«Miŋ yeŋ terieŋgu maŋ nuɔ‑i fiɛfiɛ‑i-na, mi huɔŋga si dii huɔŋga. Mi sa suɔ miŋ ka waŋ mamaŋ baa mi To‑i. Mi juɔ yaahuolo daayo maama yaa nuɔ‑i, mi siɛ bi siɛ cira u kor-mi yuɔ.» ");
INSERT INTO cmeNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Aa naa cira: «Baba, ce ŋ yerre ce bɔi!» Uŋ waaŋ mafamma‑i, baa nu molo piiye dɔrɔ‑i-na wuɔ: «Mi ciɛ mi yerre ce bɔi tĩ, mi ka tiraa ce di ce bɔi.» ");
INSERT INTO cmeNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Bamaŋ waa nu moloŋ daa uŋ piiye, baa ta ba piiye wuɔ: «Diiloŋo'i naaraa!» Banaŋ ba'a: «*Dɔrpɔpuɔrbiloŋo'i piiye baa-yo!» ");
INSERT INTO cmeNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yesu wuɔ gbɛ̃-ba wuɔ: «Moloŋ daa u saa piiye mɛi maa-na, u piiye namaa maa-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Fiɛfiɛ yaa Diiloŋo ka pigãaŋ nelbiliemba‑i u jãyãmma‑i. Kuŋ hii terieŋgu maŋ fiɛfiɛ‑i, Diiloŋo ka donya miwaaŋ daayo tieŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Aa da ba ji haa-mi dɔrɔ, mi ka fa nelbiliemba‑i hiere piɛ-ba mi caaŋ-nu.» ");
INSERT INTO cmeNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yesu waaŋ nel daama‑i a pigãaŋ uŋ ka ku kuliiŋgu maŋ. ");
INSERT INTO cmeNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Nuɔŋ baa cira: «*Ãnjĩnamma ciɛra wuɔ Diiloŋ uŋ pãa nuŋgu‑i wuɔ u ka saaŋ *Koŋkortieŋo maŋ, u sa ku dede. Ma da niɛ naŋ'a Moloŋ-Biɛŋo gbĩɛ ba haa-yo dɔrɔ? Ma diei ma hãi Moloŋ-Biɛŋo yaa hai moloŋo‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yesu wuɔ gbɛ̃-ba wuɔ: «Fitĩnuɔ dii baa-na yogo, ŋga u siɛ cɔ. Terieŋgu faŋgu-na, wuɔsaaŋgu maŋ dii na gbeini-na, siireŋ na ce-ku, ku yaa na ka hi baa cecerma‑i. Na saa da, da ŋ ta ŋ wuɔ kukulma-na ŋ sa suɔ niŋ kãŋ kusuɔŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Da na ta na taara na waa cecerma-na, fitĩnuɔŋ yeŋ baa-na huɔŋgu maŋ nuɔ‑i, haaŋ na naŋga yuɔ huɔŋgu faŋgu'i nuɔ‑i.» Yesuŋ waaŋ mafamma‑i, wuɔ hel ba hɔlma-na ka fuo. ");
INSERT INTO cmeNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yesuŋ fiɛ ce gbɛrɛ-wɛima bɔi *Yuifubaa-ba yufelle-na, molo saa hũu u nelma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Diiloŋ uŋ puɔraa *Isayiŋ waŋ mamaŋ, ma'i sĩ daama‑i wɛi? Isayi ciɛra wuɔ: «Itie, ŋ daa hai moloŋo‑i hũyãa i nelma‑i? Ŋ pigãaŋ hai moloŋo‑i wuɔ ŋ hii?» ");
INSERT INTO cmeNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Kumaŋ ciɛ ba siɛ gbãa hũu-ma, Isayi bi waaŋ-ma. U ciɛra wuɔ: «Diiloŋo ciɛra: ");
INSERT INTO cmeNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","‹Mi ciɛ-ba yiriemba, a ce ba baa ta ba da baa ba yufieŋa‑i. Mi guɔlaa ba ãnjɔguɔma‑i, a ce ba baa ta ba suɔ nelma yaaŋga‑i. Ku'i ciɛ ba siɛ gbãa hũu mi nelma‑i aa jo mi ji sire-bɛi ba jarma-na.›» ");
INSERT INTO cmeNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isayi naa fara da Yesu bɔbɔima‑i ku'i ciɛ u piiye nel daama‑i. U waaŋ Yesu maama'i dumaaŋo-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","*Yuifu ba yuntaamba famba fɛrɛ‑i, ba fɔ̃ŋgũɔ baa hũyãa Yesu nelma‑i, ŋga baa kãalã *Farisĩɛbaa-ba‑i wuɔ da ba waŋ-ma, ba ka nyaa-ba *Diilonelhãalãdũŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Bafamba wulaa, bɔlbɔl nelbiliemba dɔl-ba aa Diiloŋo bigãaŋ-ba. ");
INSERT INTO cmeNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ku huoŋgu-na, Yesu wuɔ tuɔ piiye baa nuɔmba‑i da gbagaga wuɔ: «Umaŋ duɔ hũu mi nelma‑i, kutieŋo saa hũu mɛi nelma, u hũyãa umaŋ puɔraa-mi u nelma. ");
INSERT INTO cmeNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Da ŋ da muɔŋo‑i, ŋ daa umaŋ puɔraa-mi. ");
INSERT INTO cmeNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Muɔmi dii ŋaa fitĩnuɔ. Mi juɔ hĩɛma-na miɛ umaŋ duɔ hũu mi maama‑i, kutieŋo baa tĩɛ kukulma-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Mi saa jo da mi ji gãŋ baa nelbiliemba‑i, mi juɔ da mi ji kor-ba; a ce dumaaŋo-na, umaŋ duɔ nu mi nelma‑i aa yagar ma hũmelle wuɔsaaŋgu‑i, mɛi sa gãŋ baa-yo. ");
INSERT INTO cmeNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Umaŋ duɔ cĩina-miɛ baa mi nelma‑i hiere, kutieŋo daa muotieŋo u fɛrɛŋ nuɔ tĩ. Miŋ waaŋ nelma maŋ baa-yo, ma'i ka gãŋ baa-yo miwaaŋo tĩmmaŋ-yiiŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Hama‑i nuɔ‑i? Mi sa waŋ mɛi kusũŋ-maama. Mi To yaa puɔraa-mi, aa miŋ gbĩɛ mi waŋ mamaŋ hiere, u pigãaŋ-mi baa-ma u fɛrɛ. ");
INSERT INTO cmeNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Aa mi suyaa miɛ uŋ waaŋ mamaŋ baa-mi, ma yaa diyaaŋ nɛliɛŋ nuɔŋo‑i cicɛ̃lmaŋ-hũmelle-na. A ce dumaaŋo-na uŋ waaŋ-ma baa-mi dumaa, mi bi waŋ-ma dumɛi.» ");
INSERT INTO cmeNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","*Kɔrsĩnni tĩmmaŋ-ponsaaŋgu waa ŋaa bisĩŋ ku temma. Nyuŋgo ku temma‑i, Yesu wuɔ suɔ wuɔ u tammaŋ-huɔŋgu hii tĩ duɔ kã Tuoŋo wulaa. Bamaŋ waa baa-yo hĩɛma-na, ba maama taa ma dɔlnu-yuɔ. U dɔlaa-ba a ji hi u tamma. ");
INSERT INTO cmeNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ku isuɔŋgu-na, baa tĩɛna ta ba wuo niiwuoni‑i. A ne da huɔŋgu faŋgu-na, *Sitãni naa dii-ma tĩ *Yuda huɔŋga-na wuɔ u hel Yesu huoŋgu-na. Yuda to yaa Simɔ-Isikaro‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ŋga Yesu wuɔ suyaa wuɔ fuɔ fɛrɛ hilaa Diiloŋ-terieŋ-nu jo, aa u ka bir kã u wulaa. Aa tiraa suɔ wuɔ u To birii wɛima‑i hiere hã-yo. ");
INSERT INTO cmeNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Wuɔ sire jukalaaŋgu-na a hiel u joŋgoruo‑i aa biɛ kompaŋga naŋga pɛ̃yɛ̃ u nɛgɛlle‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Uŋ ciɛ mafamma‑i, wuɔ biɛ bĩŋkũŋgu a dii hũmma tuɔ saara u *hãalãbiemba gbeini‑i aa tuɔ hurre-niɛ baa kompaŋga maŋ u nɛgɛlle-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Uŋ kaa hi Simɔ-Piɛr, Simɔ-Piɛr wuɔ gbɛ̃-yo wuɔ: «Itie, naŋ siɛ gbãa saara mɛi gbeini‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesu wuɔ: «Piɛr, miŋ ceŋ kumaŋ daaku‑i ŋ siɛ gbãa suɔ ku yuŋgu‑i nyuŋgo‑i-na, ŋga yiiŋgu dii baa yiiŋgu ŋ ka suɔ-ku.» ");
INSERT INTO cmeNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Piɛr wuɔ: «Mi siɛ siɛ aa yaŋ nuɔ ŋ saara mi gbeini‑i!» Yesu wuɔ: «Da ŋ saa yaŋ mi saara-niɛ, ŋ suɔ kerre ŋ nuŋgu sĩ baa-mi wɛima-na!» ");
INSERT INTO cmeNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simɔ-Piɛr wuɔ: «Da ma waa dumaaŋo-na, saara-niɛ aa ŋ saara baa mi nammu‑i baa mi yuŋgu‑i hiere.» ");
INSERT INTO cmeNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesu wuɔ: «Umaŋ duɔ cɛ hũmma‑i u ne welewele hiere, u kuɔŋ, u saara u fɛrɛ ce niɛ? Mi saa yagar-ma u gbeini. Namaa na kuɔŋ, ŋga na hieroŋo sĩ.» ");
INSERT INTO cmeNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Uu naa suɔ umaŋ ka hel u huoŋgu-na ku'i ciɛ wuɔ ba saa koŋ hiere. ");
INSERT INTO cmeNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Uŋ juɔ saara ba gbeini‑i tĩ, wuɔ biɛ u joŋgoruo‑i dii, aa kã ka tĩɛna u muntĩɛnammu-na aa cira: «Miŋ ciɛ kumaŋ nɛi daaku‑i, na suyaa ku yuŋgu‑i wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Da na ce na ta na bĩ-mi wuɔ: ‹Hãalãtie.› Kuniɛ na'a: ‹Itie.› Ma dɔlaa-na; na saa kar coima. ");
INSERT INTO cmeNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Muɔmi maŋ na Tieŋ muɔ baa na hãalãtieŋ muɔ, da mi saara na gbeini‑i, namaa na saaya na bi ta na saara na-naa gbeini. ");
INSERT INTO cmeNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Mi pigãaŋ-na nelma'i. Taa na ce ku yaa‑i na hɔlma-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Yaaŋ mi waŋ ninsoŋo‑i baa-na: Maacembiloŋo sa maar u yuntieŋo‑i, aa pɔpuɔrbiloŋo sa maar umaŋ puɔraa-yo. ");
INSERT INTO cmeNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Da kuɔ na saa naa suɔ-ma, fiɛfiɛ‑i-na na suyaa-ma. Da na wuɔ ma hũmelle‑i, na yunni dɔlaa. ");
INSERT INTO cmeNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","«Da na da mi piiye dɛ‑i-na, mi sa gbɛ̃ na hieroŋo. Mi suɔ miŋ fiɛlaa bamaŋ. Ŋga mamaŋ nyɛgãaŋ Diiloŋ-nelma-na, ma gbĩɛ ma ce. Ma nyɛgãaŋ wuɔ: ‹Umaŋ taa u wuo baa-mi kaladuɔŋgu-na, u birii tuɔ gãŋ baa-mi.› ");
INSERT INTO cmeNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Mi ka wuɔya waŋ-ma baa-na aa ma suɔ da ma ce; ku yaa da ma ji ce, na ka hũu-ma wuɔ umaŋ dii gbula u yaa muɔŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Yaaŋ mi waŋ ninsoŋo‑i baa-na: Umaŋ duɔ bel mi pɔpuɔrbiloŋo‑i fafamma, kutieŋo bilaa muɔmɛi; aa umaŋ duɔ bel muɔŋo‑i fafamma, u bilaa umaŋ puɔraa-mi.» ");
INSERT INTO cmeNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesuŋ waaŋ mafamma‑i, u huɔŋga pãŋ kũɔl. Wuɔ cira: «Mi siɛ fuo-ma nɛi: Na hɔlma-na, unaa ka hel mi huoŋ-nu.» ");
INSERT INTO cmeNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","*Hãalãbieŋ baa bir ta ba ne ba-naa aa ta ba yuu ba-naa wuɔ: «U gbɛ̃ hai?» ");
INSERT INTO cmeNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Hãalãbiloŋo maŋ maama‑i taa ma dɔlnu Yesu‑i ma yaŋ, u waa tĩɛna u caaŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simɔ-Piɛr wuɔ piiye baa-yo baa u naŋga, wuɔ u yuu-yo u gbɛ̃ hai? ");
INSERT INTO cmeNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Hãalãbiloŋ wuɔ miɛl cira: «Itie, ŋ gbɛ̃ hai moloŋo‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesu wuɔ cira: «Da mi nafiiye *buruo‑i hã umaŋ, u yaa‑i.» Aa naa bũl buruo‑i a nafiiye hã *Yuda‑Isikaro. ");
INSERT INTO cmeNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yudaŋ hũyãa buruo‑i, *Sitãni wuɔ pãŋ sire-yuɔ. Yesu wuɔ cira: «Yuda, sire ŋ ce niŋ saaya ŋ ce mamaŋ, baa sɛrɛ baa-ma!» ");
INSERT INTO cmeNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Bamaŋ waa hiere juwuoterieŋgu-na ba saa suɔ u nelma yaaŋga‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yudaŋ taa u tiera ba gbeiŋa‑i, banamba da niɛ sĩ Yesu taara u ka sãa baŋ saaya ba ce ponsaaŋgu‑i baa nimaŋ, sisɔ wuɔ u ka hã sũntaamba‑i bĩŋkũŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yudaŋ hũyãa buruo‑i dumaaŋo-na, wuɔ pãŋ sire hel. Ku waa isuɔŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","*Yudaŋ hilaa, Yesu wuɔ cira: «Fiɛfiɛ‑i-na, nuɔmba daa *Moloŋ-Biɛŋo bɔbɔima‑i baa Diiloŋo maama‑i Moloŋ-Biɛŋo-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Uŋ ciɛ ba da Diiloŋo bɔbɔima‑i yuɔ, ku siɛ vaaya, Diiloŋo ka bi ce ba da Moloŋ-Biɛŋo maama‑i fuɔ‑i-na.» ");
INSERT INTO cmeNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Aa naa cira: «Mi jɛ̃naaŋ namaa, mi yinni saa tiraa tĩɛ bɔi na hɔlma-na. Na ka taara-miɛ na siɛ da-mi. Miŋ taa mi waŋ mamaŋ baa *Yuifubaa-ba‑i, mi waŋ-ma baa namɛi fiɛfiɛ‑i-na: ‹Miŋ kãŋ kusuɔŋ-nu, na siɛ gbãa kã.› ");
INSERT INTO cmeNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Mi ka hã-na nelfɛlɛmma aa suɔ ta. Nelfɛlɛmma famma yaa daama: Taa na dɔl na-naa. Muɔ miŋ dɔlaa-na dumaa, taa na dɔl na-naa dumɛi. ");
INSERT INTO cmeNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Da na ta na dɔl na-naa, nuɔmba ka suɔ ku yaa nuɔ‑i wuɔ mɛi baaŋ namaa.» ");
INSERT INTO cmeNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simɔ-Piɛr wuɔ cira: «Itie, ŋ kã hie?» Yesu wuɔ cira: «Piɛr, miŋ kãŋ kusuɔŋ-nu, ŋ siɛ gbãa kã baa-mi fiɛfiɛ‑i-na, ŋga ŋ ka ta ŋ jo huoŋ-nu.» ");
INSERT INTO cmeNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Simɔ-Piɛr wuɔ cira: «Itie, bige‑i dii fiɛfiɛ‑i-na aa ŋ'a mi siɛ gbãa kã baa-ni? Da mi fiɛ'a mi ka ku naŋ maama-na, wɛima sĩ.» ");
INSERT INTO cmeNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesu wuɔ cira: «Ŋ ka siɛ ku mɛi maama-na ninsoŋo wɛi? Ne! Yaŋ mi waŋ ninsoŋo‑i baa-ni: Kɔhɔldĩɛlãŋo siɛ hi bu, ŋ ka cĩina-miɛ da i siɛi wuɔ naŋ sa suɔ-mi.» ");
INSERT INTO cmeNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ku huoŋgu-na, Yesu wuɔ cira: «Baa na yaŋ na hɔmmu cu. Yaaŋ aa na haa na naŋga‑i Diiloŋo-na baa muɔmi-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Muntĩɛnammu bɔi dii mi To dumɛlle-na. Kuɔ muntĩɛnammu saa naa waa, mii naa waa hie wuɔ mi ka tigiiŋ muntĩɛnammu cie-na? ");
INSERT INTO cmeNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Da mi kã ka tigiiŋ na muntĩɛnammu‑i tĩ, mi ka bir ji biɛ-na na ka tĩɛna mi caaŋ-nu.» ");
INSERT INTO cmeNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Aa naa cira: «Miŋ kãŋ kusuɔŋ-nu na sa bi yaŋ ku hũmelle‑i suɔma.» ");
INSERT INTO cmeNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Toma wuɔ cira: «Itie, i sa suɔ niŋ kãŋ kusuɔŋ-nu, i ce niɛ gbãa suɔ ku hũmelle‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesu wuɔ: «Muɔmɛi hũmelle‑i, muɔmɛi ninsoŋo‑i aa muɔmɛi cicɛ̃lma‑i. Molo siɛ gbãa kã mi To wulaa ni kutieŋo saa cor baa muɔ. ");
INSERT INTO cmeNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Da na suɔ muɔŋo‑i, na ka suɔ mi To‑i. Ŋga fiɛfiɛ‑i-na, na suyaa-yo aa na daa-yo.» ");
INSERT INTO cmeNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipu wuɔ cira: «Itie, da ŋ pigãaŋ-ye ŋ To‑i i siɛ tiraa yuu-ni baa wɛima.» ");
INSERT INTO cmeNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesu wuɔ: «Filipu, mi bãaŋgu cuɔ baa-na, aa naŋ waa yogo naŋ sa suɔ-mi! Da ŋ da muɔŋo‑i, ŋ daa mi To yaa‑i; ku ce niɛ ŋ'a mi pigãaŋ-na mi To‑i? ");
INSERT INTO cmeNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ŋ saa hũu-ma wuɔ muɔ baa mi To‑i kuuduɔŋgu yaa‑i wɛi? Miŋ waŋ nelma maŋ baa-na, mɛi huɔya-maama sĩ. Iŋ yeŋ kuuduɔŋgu baa mi To‑i, u'i ciɛŋ u fɛrɛŋ maacemma. ");
INSERT INTO cmeNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Da mi cira muɔ baa mi To‑i kuuduɔŋgu yaa‑i, na saaya na hũu-ma wuɔ ninsoŋo. Da kuɔ coima, na sa ne miŋ ceŋ mamaŋ wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Yaaŋ mi waŋ ninsoŋo‑i baa-na, miŋ ceŋ mamaŋ daama‑i, umaŋ duɔ haa u naŋga miɛ, u gbãa ce ma temma. Aa ji da miŋ kãŋ mi To wulaa dɛ‑i-na, kutieŋo gbãa ce mamaŋ maaraa daama‑i yɛrɛ. ");
INSERT INTO cmeNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Da na cãrã bĩŋkũŋgu bĩŋkũŋgu, aa bĩ mi yerre‑i, mi ka ce-ku hã-na a ce mi To ce bɔi. ");
INSERT INTO cmeNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Da na cãrã kumaŋ aa bĩ mi yerre‑i, mi ka ce-ku hã-na.» ");
INSERT INTO cmeNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","«Da kuɔ mi maama dɔlnu-nɛi, na ka vaa na fɛrɛ ta na ce miŋ waaŋ mamaŋ baa-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Mi ka waŋ baa mi To‑i u hã-na kakãyãtieŋo u ji tĩɛ baa-na gbula. ");
INSERT INTO cmeNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Kakãyãtieŋo faŋo yaa *Diiloŋ-Yalle‑i; di yaa ninsontieŋo‑i. Nelbiliemba sa da-yo, ba sa bi suɔ-yo, a ce dumaaŋo-na u siɛ gbãa jo ba wulaa. Ŋga uŋ yeŋ baa namaaŋo‑i, na suɔ-yo aa u ka tĩɛ baa-na gbula. ");
INSERT INTO cmeNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Mi siɛ ta aa yaŋ-na yombĩŋ namaa; mi ka bir jo. ");
INSERT INTO cmeNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Cɛllɛ, nuɔmba siɛ tiraa ta ba da-mi, ŋga namaaŋo‑i, na ka ta na da-mi. Mi ka tĩɛ gbula aa namaa na ka tĩɛ gbula. ");
INSERT INTO cmeNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ku yiiŋ da ku hi, na ka suɔ wuɔ muɔ baa mi To‑i kuuduɔŋgu yaa‑i, aa namaa baa muɔŋo‑i kuuduɔŋgu bi yaa‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Umaŋ duɔ bella mi nelma‑i aa tuɔ ce-ma, mi maama dɔlnu u yaa‑i. A ne da mi maamaŋ dɔlnuŋ umaŋ, kutieŋo maama ka dɔlnu mi To‑i aa bi dɔlnu mɛi fɛrɛ‑i, aa mi ka pigãaŋ kutieŋo‑i mi fɛrɛ.» ");
INSERT INTO cmeNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","*Yuda naŋo waa a naara *Yuda‑Isikaro‑i, fuɔ wuɔ cira: «Itie, bige‑i ciɛ ŋ'a ŋ ka yaŋ nuɔmba namba‑i aa pigãaŋ miɛmɛi baa ŋ fɛrɛ?» ");
INSERT INTO cmeNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesu wuɔ cira: «Mi maama da ma ta ma dɔlnu umaŋ, u ka tuɔ ce miŋ waaŋ mamaŋ. Duɔ tuɔ ce-ma, u maama ka dɔlnu mi To‑i. Aa u maaŋ da ma dɔlnu mi To‑i, i ka jo ji har kutieŋo-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Mi maaŋ da ma'a ma sa dɔlnu umaŋ, u sa ce miŋ waaŋ mamaŋ. A ne da miŋ waŋ mamaŋ baa-na, mɛi kusũŋ-maama sĩ, mi To maama. U yaa puɔraa-mi. ");
INSERT INTO cmeNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Mii dii baa-na yogo aa waŋ daama‑i hiere baa-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Mi To ka saaŋ Diiloŋ-Yalle jo mɛi yerreŋ. Di ka kãyã-nɛi. Di ka jo ji waŋ ma yaaŋga‑i baa-na hiere aa miŋ waaŋ mamaŋ cor hiere, di ka ce ma tĩɛnu-nɛi. ");
INSERT INTO cmeNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Mi fɛ̃ na hɔmmu‑i, aa mi fɛ̃-mu mɛi fɛ̃mma. Mi sa fɛ̃-mu ŋaa nelbiliembaŋ fɛ̃ŋ ba-naa hɔmmu dumaa. Baa na yaŋ na hɔmmu cu, baa na bi yaŋ korma ta ma da-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ma sĩ mi waaŋ-ma baa-na miɛ: ‹Mi ka ta ŋga mi ka bir jo kɛ?› Da kuɔ mi maama dɔlnu-nɛi, miŋ kãŋ mi To wulaa, ku saaya ku dɔlnu-nɛi. Hama‑i nuɔ‑i? Mi To maaraa muɔŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Mi waliɛya waŋ nel daama‑i baa-na ku yaa da ma ji ta ma ce na ka suɔ wuɔ mi waaŋ ninsoŋo. ");
INSERT INTO cmeNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Miwaaŋ daayo tieŋo jo dii mi huoŋ-nu; a ce dumaaŋo-na, mi siɛ tiraa da piiye bɔi baa-na. Ŋga u siɛ gbãa ce bĩŋkũŋgu miɛ. ");
INSERT INTO cmeNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Nelbiliemba saaya ba suɔ wuɔ mi To maama dɔlnu-miɛ, aa tiraa suɔ wuɔ mi Toŋ'a mi ce mamaŋ, mi ce ma yaa‑i ku'i ciɛ *Bigãarãŋo tuɔ jo. Siireŋ i halaŋ bande‑i-na!» ");
INSERT INTO cmeNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Ku huoŋgu-na, Yesu wuɔ ji naŋ gbãnalãaŋ daaku‑i baa u *hãalãbiemba‑i wuɔ: «Muɔmɛi *ɛrɛsɛ̃-tibiiŋ-kerre‑i aa mi To yaa ku tieŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Mi negemmu maŋ sa maaŋ hiere, u ka kar-mu nanna aa mumaŋ maaŋ, u ka jũɔrã-muɔ a ce mu migãaŋ ta mu maŋ fafamma. ");
INSERT INTO cmeNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Miŋ waaŋ nelma maŋ baa-na, ma migãaŋ-na tĩ. ");
INSERT INTO cmeNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Nyaarãaŋ-miɛ ŋaa muɔ miŋ nyaarãa-nɛi dumaa. Na suyaa wuɔ negeŋga maŋ da ka saa nyaar ka nyu‑i-na ka siɛ gbãa maŋ dɛ! Kuuduɔŋgu yaa baa namaaŋo‑i: Da na saa nyaar muɔmi-na, na siɛ gbãa ce bĩŋkũfafaaŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","«Muɔmɛi tibiiŋgu‑i, aa namɛi ku negemmu‑i. Muɔ da miɛ mii si dii, na siɛ gbãa ce bĩŋkũŋgu. Umaŋ duɔ nyaar-miɛ aa muɔmi bi nyaar-yuɔ, kutieŋo gbãa ce wɛima bɔi. ");
INSERT INTO cmeNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Umaŋ duɔ saa nyaar-miɛ, ba bũul kutieŋo‑i ka nanna puona ŋaa da ba jã negeŋga‑i baŋ bũul-kaŋ ka nanna dumaa ka kuol ba biɛ-ka dii-ka dãamu-na caa-ka. ");
INSERT INTO cmeNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ŋga da na nyaar-miɛ, aa mi nelma waa na hɔmmu-na, da na ta na taara kumaŋ, na cãrã-kuɔ, na ka da-ku. ");
INSERT INTO cmeNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Da na ta na ce maacenfafamma na hã Diiloŋo‑i, aa cu mi huoŋ-nu, ku yaa ciɛŋ mi To ce bɔi. ");
INSERT INTO cmeNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Mi Toŋ dɔlaa-mi dumaa, muɔmi bi dɔlaa namaaŋo‑i dumɛi. Tĩyãaŋ mi caaŋ-nu mi ta mi ce baa-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Miŋ waaŋ mamaŋ baa-na, da na ta na ce-ma, na maama ka ta ma dɔlnu-miɛ ŋaa muɔ miŋ ceŋ mi To maama‑i mi maama ta ma dɔlnu-yuɔ dumaa.» ");
INSERT INTO cmeNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Yesuŋ waaŋ mafamma‑i, wuɔ cira: «Mi taara na hɔmmu fɛ̃ da yogogo mɛi kaaŋga temma‑i ku'i ciɛ mi ta mi waŋ nel daama‑i baa-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Mi nelma yaa daama: Taa na dɔl na-naa ŋaa muɔmiŋ dɔlaa-na dumaa. ");
INSERT INTO cmeNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Nɛliɛŋ nuɔ da ŋ hũu-ma ku ŋ jɛ̃naamba maama-na, nelnyul hamu‑i dii ji maar mufammu‑i? ");
INSERT INTO cmeNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Miŋ waaŋ mamaŋ baa-na, da na ce-ma, na ka ce mi jɛ̃naaŋ namaa. ");
INSERT INTO cmeNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Mi sa tiraa mi bĩ-na maacembieŋ namaa, mi bĩ-na mi jɛ̃naaŋ namaa. Hama‑i nuɔ‑i? Maacembiloŋo sa suɔ u yuntieŋo kusũŋgu‑i. A ne da namaaŋo‑i, mi Toŋ waaŋ mamaŋ baa-mi hiere, mi waaŋ-ma baa-na. Terieŋgu faŋgu-na, mi siɛ gbãa bĩ-na mi maacembieŋ namaa. ");
INSERT INTO cmeNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ku saa ce ŋaa namɛi fiɛlaa muɔ, muɔmɛi fiɛlaa namaa aa puɔr-na wuɔ na ka ce maacenfafamma aa na yaŋ na maacemma da belle, ku yaa da na cãrã bĩŋkũŋgu bĩŋkũŋgu mi To wulaa aa bĩ mi yerre‑i u ka hã-na baa-ku. ");
INSERT INTO cmeNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ŋga miŋ taaraŋ kumaŋ na wulaa, ku yaa daaku: Taa na dɔl na-naa.» ");
INSERT INTO cmeNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","«Da na da nelbiliemba bigãaŋ-na, na saaya na suɔ wuɔ ba bigãaŋ muɔmɛi igɛ̃na. ");
INSERT INTO cmeNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Kuɔ na waa baa-ba, baa naa dɔl-na wuɔ bafamba baaŋ namaa. Ŋga mi fiɛlaa namaaŋo‑i hiel-na ba hɔlma-na; bafamba baaŋ namaa sĩ, ku'i ciɛ ba bigãaŋ-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Yaaŋ mi nel daama ta ma tĩɛnu-nɛi: ‹Maacembiloŋo sa maar u yuntieŋo‑i.› Da ba huol mi yaaŋ-na, ba ka bi huol namaa na yaaŋ-na. Da ba nu mi nuŋgu‑i, ba ka bi nu namaa kũŋgu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ba ka ce mafamma‑i mɛi maa-na. Baŋ'a ba saa suɔ umaŋ puɔraa-mi, ku'i ciɛ. ");
INSERT INTO cmeNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Kuɔ mi saa naa jo ji piiye baa-ba, molo naa saa cãl-ba. Ŋga dɛ‑i-na, ba siɛ gbãa da ãntãalãmma.» ");
INSERT INTO cmeNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","«Umaŋ duɔ bigãaŋ muɔŋo‑i, kutieŋo bi bigãaŋ mi To‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Miŋ ciɛ himma maŋ ba daa-ma. Aa ba suyaa wuɔ molo siɛ gbãa ce ma temma. Kuɔ ba saa naa da-ma, molo naa saa cãl-ba. Ŋga ba daa-ma aa cor ta ba bigãaŋ-mi baa mi To‑i hiere. ");
INSERT INTO cmeNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Na saa da! Mamaŋ nyɛgãaŋ ba *ãnjĩnamma-na, ma'i saa ce daama‑i wɛi? Ma nyɛgãaŋ wuɔ: ‹Ba bigãaŋ-mi gbãŋgbãŋ.› ");
INSERT INTO cmeNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","«Mi To uŋ ka hã-mi kakãyãtieŋo maŋ mi saaŋ-yo hã-na, u yaa ninsontieŋo‑i. Duɔ jo, u ka piiye mi maama‑i tũnu nuɔmba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Aa namaa fɛrɛ‑i, iŋ waa baa i-naa dii ku domma-na, na ka bi ce mi siɛrtaaŋ namaa. ");
INSERT INTO cmeNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","«Mi sa taara ku ji nuɔl-na Diiloŋ-hũmelle-na ku'i ciɛ mi ta mi waŋ daama‑i hiere baa-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ba ka nyaa-na *Diilonelhãalãdũnni-na. Aa yiiŋgu dii baa yiiŋgu, bamaŋ ji taa ba ko-na, ba ka da niɛ sĩ ba cãa Diiloŋo'i dumaaŋo-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Baŋ'a ba saa suɔ mi To‑i baa mɛi fɛrɛ‑i hiere, ku'i ka dii-ba mafamma cemma-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Kumaŋ ciɛ mi wuɔya ta mi waŋ-ma baa-na, mi taara da ma ji ta ma ce, na suɔ wuɔ mi waaŋ-ma baa-na cor tĩ. Mii naa waa na caaŋ-nu ku'i ciɛ mi saa waŋ-ma baa-na dii ku domma-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Dɛ‑i-na, mi ta da mi kã umaŋ puɔraa-mi u wulaa, aa molo saa da duɔ yuu-mi wuɔ: ‹Ŋ kã hie?› ");
INSERT INTO cmeNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Mi suyaa miɛ miŋ waaŋ mamaŋ baa-na daama‑i, ma'i saa dɔlnu-nɛi. ");
INSERT INTO cmeNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","A ne da mi waaŋ ninsoŋo yaa baa-na. Da mi ta, ku ka kãyã-nɛi. Na saa da, da mi saa ta, kakãyãtieŋo siɛ gbãa jo. Fuɔ mi kã ka hi aa saaŋ-yo hã-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Duɔ jo, u ka pigãaŋ nelbiliemba‑i wuɔ ba piɛra ãmbabalma kũŋgu-na, ba piɛra viisĩnni kũŋgu‑na aa pira Diiloŋ-bɛrru kũŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Baŋ'a ba saa hũu mɛi nelma‑i, ku'i pigãaŋ ãmbabalma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Aa miŋ kãŋ mi To wulaa, na siɛ tiraa da-mi, ku'i pigãaŋ viisĩnni‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Aa miwaaŋ daayo tieŋo yuŋ-maamaŋ fiɛlaanu tĩ, ku'i pigãaŋ Diiloŋ-bɛrru‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","«Nelma bɔi dii yogo mi da mi waŋ-ma baa-na, ŋga da mi waŋ-ma baa-na fiɛfiɛ‑i-na, ma ka mulĩɛŋ-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","*Diiloŋ-Yalle da di ji jo, di yaa ninsoŋo tieŋo‑i, di ka kaala ninsoŋ-belle‑i baa-na. Di sa ji waŋ difande kusũŋ-maama. Diŋ nuɔ mamaŋ, di ji waŋ ma yaa‑i aa bi tũnu-nɛi mamaŋ juɔŋ. ");
INSERT INTO cmeNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Di ka da mi kusũŋ-maama‑i ji piiye tũnu-nɛi, a ce dumaaŋo-na di ka ce-mi bɔi. ");
INSERT INTO cmeNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Mi To maama‑i hiere mɛi maama, ku'i ciɛ na da mi ciɛra di ka da mi kusũŋ-maama‑i ji piiye tũnu-nɛi.» ");
INSERT INTO cmeNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Kufaŋgu huoŋgu-na, Yesu wuɔ gbɛ̃ u *hãalãbiemba‑i wuɔ: «Cɛllɛ na ka naa-mi, aa cɛllɛ na ka bir da-mi.» ");
INSERT INTO cmeNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","U hãalãbiemba namba ta ba yuu ba-naa wuɔ: «Nel hama‑i temma'i dumandɛ‑i: ‹Cɛllɛ na ka naa-mi, aa cɛllɛ na ka bir da-mi›? Aa tiraa cira u kã u To wulaa. ");
INSERT INTO cmeNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Uŋ gbɛ̃ŋ cɛllɛ maŋ, u yuŋgu yaa wuɔ niɛ? I saa suɔ u nelma yaaŋga‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu wuɔ suɔ wuɔ ba taara ba yuu-yo. Wuɔ gbɛ̃-ba wuɔ: «Mi waaŋ-ma baa-na miɛ: ‹Cɛllɛ na ka naa-mi, aa cɛllɛ na ka bir da-mi.› Na yuu na-naa ma yaa nuɔ‑i wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Yaaŋ mi waŋ ninsoŋo‑i baa-na: Namaaŋo‑i na kaa haa na nammu‑i na yunniŋ ta na gbu na kaal aa banamba waa ponsaaŋ-nu. Na hɔmmu ka guɔla, ŋga na hɔguɔla ka bir ce hɔfɛ̃lle. ");
INSERT INTO cmeNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ciɛŋo kusũŋ da ku bel-o, yaaŋga sa waa-yuɔ. Ŋga duɔ ji gbãŋ da u yuŋgu‑i, biloŋo fɛ̃ u huɔŋga‑i a ce u mulĩɛma karaanu-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ku yaa ŋaa namaa kũŋgu‑i: Na yammu vãa fiɛfiɛ‑i-na, ŋga yiiŋgu dii baa yiiŋgu, mi ka tiraa da-na. Da mi ji'a mi da-na, na hɔmmu ka fɛ̃ aa molo cɛraa u gbãa guɔla-muɔ. ");
INSERT INTO cmeNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ku yiiŋ da ku ji hi, na siɛ yuu-mi baa nelma. Yaaŋ mi waŋ ninsoŋo‑i baa-na: Da na cãrã kumaŋ aa bĩ mi yerre‑i, mi To ka hã-na baa-ku. ");
INSERT INTO cmeNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Na saa hi cãrã bĩŋkũŋgu yogo aa bĩ mi yerre‑i. Cãarãŋ, na ka da, aa da na da, na hɔmmu ka fɛ̃ gbarnu. ");
INSERT INTO cmeNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","«Mi waaŋ nel daama‑i hiere baa-na gbãnɛiniŋ. Ŋga yiiŋgu dii baa yiiŋgu, mi siɛ tiraa ta mi piiye baa-na dumaaŋo-na. Mi To u maamaŋ yeŋ dumaa, mi ka bi waŋ-ma baa-na dumɛi. ");
INSERT INTO cmeNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ku yiiŋgu da ku hi, na ka cãrã Diiloŋo‑i aa bĩ mi yerre‑i. Mi saa cira mi kaa cãrã Diiloŋo‑i hã-na dɛ! Na maama dɔlnu-yuɔ, na gbãa cãrã-yuɔ na fɛrɛ. ");
INSERT INTO cmeNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Naŋ dɔlaa muɔŋo‑i aa hũu-ma wuɔ mi hilaa fuɔ terieŋ-nu'i jo, ku'i ciɛ na maama ta ma dɔlnu-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Mi hilaa mi To yaa wulaa‑i jo hĩɛma-na. Fiɛfiɛ‑i-na, mi ka ta hĩɛma-na bir kã mi To wulaa.» ");
INSERT INTO cmeNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Uŋ waaŋ mafamma‑i, u hãalãbieŋ baa cira: «Fiɛfiɛ fuɔ, ŋ yaaŋ gbãnɛini‑i aa ta ŋ kaala ŋ nelma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","I suyaa yende‑i-na wuɔ ŋ suɔ wɛima‑i hiere. Diɛ tiɛ taara diɛ yuu-ni baa mamaŋ, ŋ wuɔya suɔ-ma. Terieŋgu faŋgu-na, i hũyãa-ma wuɔ ŋ juɔ Diiloŋ-jomma.» ");
INSERT INTO cmeNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesu wuɔ gbɛ̃-ba wuɔ: «Ma sĩ na'a na hũyãa mi nelma‑i fiɛfiɛ‑i-na kɛ? ");
INSERT INTO cmeNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ŋga mi tũnu-nɛi, huɔŋgu naŋgu ka hi, aa ku hii tĩ yɛrɛ, na ka pisãllã; nɛliɛŋo nɛliɛŋo baa u muŋkãmmu aa yaŋ mi tĩɛ mi diei yoŋ. Ŋga mi siɛ tĩɛ mi diei; mi To dii baa-mi. ");
INSERT INTO cmeNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Naŋ cuu mi huoŋ-nu, mi taara na hɔmmu fɛ̃ ku'i ciɛ mi ta mi waŋ mafamma‑i baa-na. Nelbiliemba ka mulĩɛŋ-na miwaaŋ daayo-na, ŋga vaaŋ na fɛrɛ, mi guɔlaaya ba fɔ̃ŋgũɔ‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesuŋ juɔ piiye tĩ, wuɔ tã u yuŋgu‑i dɔrɔ aa naa cira: «Baba, ku hii. Ce ŋ Biɛŋo ce bɔi, kumaŋ ka ce fuɔ bi ce nuɔ ŋ ce bɔi. ");
INSERT INTO cmeNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ŋ haa-yo nelbiliemba yuŋ-nu wuɔ u hã u dombũurãamba‑i cicɛ̃lma maŋ sa tĩɛŋ dede‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","A ne da cicɛ̃lma maŋ sa tĩɛŋ dede‑i ma yaa a suɔ ninsoŋ-Diiloŋ nuɔŋo‑i aa bi suɔ *Koŋkortieŋo muɔmi maŋ niŋ puɔraa-mi. ");
INSERT INTO cmeNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Mi ciɛ ŋ ce bɔi hĩɛma-na. Niŋ ŋa naa hã-mi maacemma maŋ, mi ciɛ-ma. ");
INSERT INTO cmeNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Baba, miŋ ŋa naa waa baa-ni aa miwaaŋo suɔ duɔ doŋ, niŋ ŋa naa ce mi ce bɔi dumaa, ce mi ce bɔi dumɛi fiɛfiɛ‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","«Niŋ fiɛlaa bamaŋ miwaaŋo-na hã-mi, mi pigãaŋ-ba ŋ sĩnni‑i. Naŋ baamba'i waa, ŋ bir-ba hã muɔ baa-ba. Ba nuɔ ŋ nuŋgu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ba suyaa fiɛfiɛ‑i-na wuɔ niŋ hãa-mi mamaŋ hiere, naŋ kusũŋ-maama. ");
INSERT INTO cmeNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Niŋ waaŋ mamaŋ baa-mi, mi waaŋ-ma baa-ba. Ba siyaa-ma. Ba suyaa wuɔ mi hilaa naŋ terieŋ-nu'i jo. Aa ba suyaa wuɔ nuɔnɛi puɔraa-mi. ");
INSERT INTO cmeNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Mi cãrã-niɛ da mi hã-ba. Mi sa cãrã-niɛ da mi hã nelbiliemba‑i hiere dɛ! Niŋ hãa-mi bamaŋ, mi cãrã-niɛ da mi hã ba yaa‑i; naŋ baamba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Mɛi kũŋgu‑i naŋ kũŋgu, aa naŋ kũŋgu‑i mɛi kũŋgu. Mi bɔbɔima da ba yaa nuɔ‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Muɔmi sa tiraa mi ye dii miwaaŋo-na, mi kã naŋ terieŋ-nu, a ne da bafamba dii-yuɔ yogo. Baba, cãlmuɔ sĩ nuɔni maŋ nuɔ‑i, jande, ta ŋ niya-bɛi ŋ fɛrɛ baa naŋ fɛrɛŋ fɔ̃ŋgũɔ; ŋ hãa muɔŋo‑i u yaa‑i. Ku yaa ba ka waa baaduɔmba ŋaa muɔ baa nuɔŋo‑i iŋ yeŋ baaduɔŋ miɛ dumaa. ");
INSERT INTO cmeNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Niŋ hãa-mi fɔ̃ŋgũɔ maŋ, miŋ ciɛ huɔŋgu maŋ baa-ba, mi niɛya-bɛi baa u yaa‑i. Mi niɛya-bɛi, u diei saa ji balla mi wulaa, da ku saa waa umaŋ naa saaya u balla ŋaa maŋ nyɛgãaŋ dumaa Diiloŋ-nelma-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","«Fiɛfiɛ‑i-na, mi ka bir kã ŋ wulaa. Mi taara ba hɔmmu fɛ̃ gbarnu mɛi kaaŋga temma‑i, ku'i ciɛ mi tĩɛ hĩɛma-na aa ta mi waŋ mafamma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Miŋ waaŋ ŋ nelma‑i baa-ba, nelbiliemba bigãaŋ-ba wuɔ ba sa wuɔ hũmeduɔle baa-ba ŋaa muɔ. ");
INSERT INTO cmeNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ku saa ce ŋaa mi cãrã-niɛ wuɔ ŋ hiel-ba miwaaŋo-na dɛ! Ma'i sĩ. Mi cãrã-niɛ wuɔ ŋ ta ŋ niya-bɛi *Bigãarãŋo baa da suur ba hɔlma-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ba sa wuɔ hũmeduɔle baa nelbiliemba‑i ŋaa muɔ. ");
INSERT INTO cmeNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Naŋ nelma yaa ninsoŋo‑i. Pigãaŋ-ba baa-ma ba suɔ-ma aa ta ba cãa nuɔnɛi yoŋ. ");
INSERT INTO cmeNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Niŋ puɔraa muɔmi‑i dumaa miwaaŋo-na, mi bi puɔraa bafamba‑i dumɛi miwaaŋo-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Muɔ mi cãa nuɔnɛi yoŋ ba da ba da ninsoŋo‑i aa fulnu nuɔnɛi ta ba bi cãa-ni. ");
INSERT INTO cmeNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","«Mi sa cãrã-niɛ da mi hã bafamba yoŋ dɛ! Bamaŋ ka nu ba nelma‑i aa hũu mi maama‑i, mi bi cãrã-niɛ da mi hã kutaamba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Baba, mi cãrã-niɛ wuɔ ŋ yaŋ ba ce kuuduɔŋgu ŋaa muɔ baa nuɔ iŋ yeŋ baaduɔŋ miɛ dumaa. Yaŋ i suurnu i-naa, ku yaa nuɔmba ka suɔ wuɔ nuɔnɛi puɔraa-mi. ");
INSERT INTO cmeNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Niŋ ciɛ mi ce bɔi dumaa, mi bi ciɛ ba ce bɔi dumɛi, ku yaa ba ka gbãa ce kuuduɔŋgu ŋaa muɔ baa nuɔ iŋ yeŋ kuuduɔŋgu dumaa. ");
INSERT INTO cmeNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ku yuŋgu yaa daaku: Mi ka waa baa-ba aa ŋ waa baa-mi, ku yaa ba ka gbãa ce kuuduɔŋgu kelkel. Dumaaŋo-na, nuɔmba ka suɔ wuɔ nuɔnɛi puɔraa-mi aa tiraa suɔ wuɔ ba maama dɔlnu-niɛ ŋaa mɛi maamaŋ dɔlnuŋ-niɛ dumaa. ");
INSERT INTO cmeNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","«Baba, niŋ dɔlaa-mi dumaa aa miwaaŋo suɔ duɔ doŋ, mi taara niŋ ciɛ mi ce bɔi dumaa, da mi waa kusuɔŋ-nu, mi dombũurãamba waa mi caaŋ-nu ta ba da-mi. ");
INSERT INTO cmeNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Baba, ŋ faa teu! Nelbiliemba saa suɔ-ni, ŋga mɛi suyaa-ni aa dombũurãamba suyaa wuɔ nuɔnɛi puɔraa-mi. ");
INSERT INTO cmeNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Mi pigãaŋ-ba ŋ sĩnni‑i, aa mi ka cor ta mi pigãaŋ-ba baa-ni, ku yaa niŋ dɔlaa muɔŋo‑i dumaa, bafamba ka bi dɔl ba-naa dumɛi, aa muɔ baa bafamba‑i i gbonu ce baaduɔŋ miɛ.» ");
INSERT INTO cmeNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesuŋ juɔ cãrã Diiloŋo‑i tĩ, wuɔ hel baa u *hãalãbiemba‑i a jãal Sedurɔ̃ kaaŋgu‑i kã bomborma namma-na. Tibinniŋ-suoŋgu naŋgu waa terieŋgu faŋgu-na, baa kã ka suur-kuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ba taa ba kã terieŋ daaku-na koko; a ce dumaaŋo-na, *Yuda maŋ taa u taara u hel u huoŋgu-na, u taa u suɔ ku saaŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Wuɔ sire nyaa ba huoŋ-nu dii tibinniŋ-suoŋgu-na baa sorosibaa-ba‑i a naara *Diilodubuɔ niyataamba namba. *Diilojigãntaamba yuntaamba‑i baa *Farisĩɛbaa-ba yaa naa hãa-yo Diilodubuɔ niyataamba‑i. Fitĩmbaa-ba waa baa-ba a naara jigãmmu. ");
INSERT INTO cmeNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesu wuɔ suyaa mamaŋ ka da-yo. Baŋ kãa ka hi, wuɔ piɛ yuu-ba wuɔ: «Na taara hai moloŋo‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Baa cira: «I taara Nasarɛtitaaŋ Yesu.» Yesu wuɔ cira: «Muɔmɛi.» Yuda maŋ taa u taara u hel u huoŋgu-na, u waa baa-ba. ");
INSERT INTO cmeNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yesuŋ ciɛra muɔmɛi terieŋgu maŋ nuɔ‑i, baa bir baa ba honni kã ka cii da burɔŋ! ");
INSERT INTO cmeNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yesu wuɔ tiraa yuu-ba wuɔ: «Na taara hai?» Baa cira: «I taara Nasarɛtitaaŋ Yesu.» ");
INSERT INTO cmeNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesu wuɔ cira: «Mi saa cira muɔmɛi wɛi? Da na'a na taara muɔmɛi, yaaŋ bamaŋ daaba kã.» U gbɛ̃ u hãalãbiemba yaa‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Uŋ ŋa naa waŋ mamaŋ, ma'i sa ciɛŋ daama‑i wɛi? Uu naa cira: «Baba, niŋ hãa-mi bamaŋ, u diei saa balla mi wulaa.» ");
INSERT INTO cmeNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","A ne da jigãŋga waa baa Simɔ-Piɛr; wuɔ fa-ka hiel-ka pãŋ jafũŋ *Diilojigãntaamba yuntieŋo maacembiloŋo nadietũŋgu‑i a yer-ku. Ba taa ba bĩ naacolŋo‑i Malkusi. ");
INSERT INTO cmeNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yesu wuɔ cira: «Piɛr, dii ŋ jigãŋga‑i ka foguoŋgu-na!» Aa naa cira: «Mi To uŋ ciɛra mamaŋ da-mi, ŋ sa taara ma da-mi wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Yesuŋ bi waaŋ mafamma‑i, sorosibaa-ba‑i baa ba yuntieŋo‑i a naara Diilodubuɔ niyataamba kã ka bel-o vaa u nammu‑i mu hãi‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Belle fande-na, Kayifu yaa waa Diilojigãntaamba yuntieŋo‑i. Baŋ vaa-yo, baa kã baa-yo Kayifu cura yaa wulaa‑i igɛ̃na. Ba taa ba bĩ-yo Ani. ");
INSERT INTO cmeNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","A ne da Kayifu duɔŋo faŋo yaa naa gbɛ̃ *Yuifu ba yuntaamba‑i wuɔ nelduɔŋ duɔ ku a kor nelle‑i hiere ku bɔyaa nelle da di muonu. ");
INSERT INTO cmeNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Baŋ bilaa Yesu‑i ta ba kã baa-yo, Simɔ-Piɛr baa u nahãalãbiloŋo naŋo‑i baa cu ba huoŋ-nu. *Diilojigãntaamba yuntieŋo taa u suɔ Simɔ-Piɛr nabentieŋo‑i, a ce dumaaŋo-na, baŋ kaa hi Diilojigãntaamba yuntieŋo cĩiŋgu‑i, *hãalãbiloŋ daa wuɔ kã ka suur baa Yesu‑i hiere. ");
INSERT INTO cmeNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Piɛr wuɔ yiɛra fondumɛlle-na u saa suur. Hãalãbiloŋ daa wuɔ hel piiye baa ciɛŋo maŋ taa u niya dumɛlle‑i aa naa ce Piɛr suur. ");
INSERT INTO cmeNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ciɛŋ daa wuɔ yuu Piɛr wuɔ: «Ma sĩ naacolŋ daa u hãalãbiloŋo naŋo'i nuɔŋo‑i kɛ?» Piɛr wuɔ cira: «U hãalãbiloŋo sĩ muɔ dɛ!» ");
INSERT INTO cmeNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Waaŋgu waa; *Diilojigãntaamba yuntieŋo maacembiemba‑i baa bamaŋ niɛyaŋ-yuɔ baa dii dãamu ta ba yiraaŋ. Piɛr wuɔ kã ka tuɔ yiraaŋ baa-ba. ");
INSERT INTO cmeNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Baŋ kãa baa Yesu‑i, *Diilojigãntaamba yuntieŋo wuɔ yuu-yo a kã u *hãalãbiemba yaŋga, baa uŋ wuɔraŋ u waŋ nelma maŋ baa nuɔmba‑i ma yaŋga. ");
INSERT INTO cmeNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesu wuɔ cira: «Mamaŋ waa mi wulaa, mi piiye-mɛi nuɔmba‑i hiere ba yufelleŋ. Mi piiye-mɛi *Diilonelhãalãdũnni-na aa piiye-mɛi *Diilodubuɔ‑i-na. *Yuifubaa-ba jãnu ba-naa terni fanni'i nuɔ‑i. Mi saa fuo ma diei bɛi. ");
INSERT INTO cmeNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ma ce niɛ ŋ ta ŋ yuu-mi? Miŋ piiye baa bamaŋ, ba suyaa miŋ waaŋ mamaŋ baa-ba; yuu ba yaa‑i, ba ka waŋ ma yaaŋga‑i baa-ni.» ");
INSERT INTO cmeNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yesuŋ piiye dumaaŋo-na, Diilojigãntaamba yuntieŋo niyatieŋo naŋ wuɔ caa u tũŋgu‑i aa naa cira: «Ŋ piiye baa Diilojigãntaamba yuntieŋo yaa dɛ‑i-na wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesu wuɔ cira: «Da kuɔ mi cãlãa piiyemma, pigãaŋ-mi miŋ cãlãa kusuɔŋ-nu; ŋga da kuɔ mi saa cãl piiyemma, ŋ muyaa-mi hama‑i nuɔ‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ani wuɔ yaŋ-yo baa iyiemba‑i aa saaŋ-yo hã Kayifu‑i baa-yo, u yaa waa Diilojigãntaamba yuntieŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Baŋ taa baa Yesu‑i ta ba kã Kayifu terieŋgu-na, Simɔ-Piɛr wuɔ tĩɛna dii dãntorre-na. Naacolŋo naŋ wuɔ yuu-yo wuɔ: «Ma sĩ naacolŋ daa u *hãalãbiloŋo naŋo'i nuɔŋo‑i kɛ?» Piɛr wuɔ cira: «U hãalãbiloŋo sĩ muɔ dɛ!» ");
INSERT INTO cmeNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","*Diilojigãntaamba yuntieŋo maacembiloŋo naŋo waa, ba kuuduɔŋgu'i baa Piɛrŋ jafãaŋ umaŋ tũŋgu‑i yer-ku. Fuɔ wuɔ cira: «Ma sĩ mɛi daa nuɔ baa naacolŋ daayo‑i tibinniŋ-suoŋgu-na kɛ?» ");
INSERT INTO cmeNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Piɛr wuɔ tiraa hel-kuɔ wuɔ coima, fuɔ sĩ. Kɔhɔldĩɛlãŋ wuɔ doŋ tuɔ bu. ");
INSERT INTO cmeNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Cuoŋ kaalaa kãŋkãŋkãŋ, baa naar hel baa Yesu‑i Kayifu terieŋgu-na a kã baa-yo ba fãamaaŋo wulaa. Fãamaaŋo faŋo waa *Oromɛyiɛŋo. Baŋ kaa hi, *Yuifu ba yuntaamba saa siɛ suur fãamaaŋo dumɛlle-na; wuɔ da ba suur, ba ka guɔla ba fɛrɛ a ce ba siɛ gbãa wuo *kɔrsĩnni tĩmmaŋ-ponsaaŋgu niiwuoni‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","*Pilati yaa waa fãamaaŋo‑i belle fande-na. Wuɔ hel yuu-ba wuɔ: «Na'a naacolŋ daayo ciɛ bige‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Baa cira: «Kuɔ u maacemma naa fa, ii naa saa jo baa-yo ji hã-ni.» ");
INSERT INTO cmeNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilati wuɔ gbɛ̃-ba wuɔ: «Biyaaŋ-yoŋ na kã baa-yo na ka ce u ãndaaŋgu‑i namaa cemma.» Baa cira: «Miɛ siɛ gbãa hã-ba hũmelle‑i i fɛrɛ wuɔ ba ko moloŋo.» ");
INSERT INTO cmeNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Yesuŋ ŋa na'a u ka ku kuliiŋgu maŋ, ku'i sa juɔŋ daaku‑i wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilati wuɔ bir suur u dumɛlle-na aa bĩ Yesu‑i ji yuu-yo wuɔ: «Nuɔnɛi Yuifu ba nellentieŋ nuɔŋo‑i wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesu wuɔ cira: «Moloŋo‑i waaŋ mi maama baa-ni wɛi? Sisɔ naŋ kusũŋ-maama'i?» ");
INSERT INTO cmeNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilati wuɔ cira: «Ne niŋ feŋ-miŋ! Ŋ daa muɔ Yuifuyiɛŋ muɔ wɛi? Ŋ nelleŋ-baamba'i hãa muɔ baa-ni baa *Diilojigãntaamba yuntaamba‑i, ŋ guɔlaaya bige‑i ba wulaa?» ");
INSERT INTO cmeNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesu wuɔ cira: «Mɛi nellentesĩnni sa hel hĩɛma-na bande. Kuɔ ni taa ni hel hĩɛma-na bande, bamaŋ cuu mi huoŋ-nu baa naa gbãŋ kpelle a hũu-mi Yuifubaa-ba nammu-na. Ŋga mɛi nellentesĩnni‑i miwaaŋ daayo niini sĩ.» ");
INSERT INTO cmeNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Uŋ waaŋ mafamma‑i, Pilati wuɔ cira: «Terieŋgu faŋgu-na, nellentieŋ nuɔ wɛi?» Yesu wuɔ cira: «Nellentieŋ muɔ ŋaa niŋ waaŋ-ma dumaa. Mi juɔ ji hoŋ hĩɛma-na da mi waŋ ninsoŋo maama. Umaŋ duɔ cu ninsoŋo huoŋ-nu ŋ da kutieŋo nu mi nelma‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilati wuɔ yuu-yo wuɔ: «Ninsoŋo yaa bige‑i fuɔ?» Aa naa tiraa hel kã Yuifubaa-ba wulaa ka cira: «Mɛi saa da kumaŋ ciɛ na'a na ko naacolŋ daayo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ŋga ma diei dii, kumaŋ ciɛŋ koko, belle belle, da na'a na ce na kɔrsĩnni tĩmmaŋ-ponsaaŋgu‑i, mi nanna kasobiloŋo diei hã-na. Na taara bende‑i mi nanna Yuifu ba nellentieŋo yaa hã-na wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Baa kaasĩŋ wuɔ: «I sa taara ŋ nanna ufaŋo‑i! I taara ŋ nanna Barabasi!» A ne da Barabasi faŋo waa cuoyuo. ");
INSERT INTO cmeNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Maŋ juɔ waa dumaaŋo-na, *Pilati wuɔ cira ba jo baa Yesu‑i ji muo-yo. ");
INSERT INTO cmeNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Sorosibaa baa ce huɔni a sũ nyantuoluo dii u yuŋgu-na. Aa naa bi dii joŋgorbuɔ hã-yo ce-yo ŋaa nellentieŋo. Joŋgorbuɔ faŋo waa dãa-wuoŋo. ");
INSERT INTO cmeNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Baŋ ciɛ mafamma‑i, baa ta ba piɛ ba jaal-o. Umaŋ duɔ piɛ, wuɔ: «*Yuifu ba nellentie, mi jaalaa-ni.» Aa caa u tũŋgu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilati wuɔ tiraa hel waŋ baa-ba wuɔ: «Mi ka ce ba hel baa-yo jo baa-yo, ku yaa na ka suɔ wuɔ mɛi saa da kumaŋ ciɛ na'a na ko-yo.» ");
INSERT INTO cmeNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Aa naa bi ce ba hel baa Yesu‑i baa huɔniŋ-nyantuoluo‑i u yuŋgu-na a naara joŋgorbuɔ‑i u nuoŋgu-na. Baŋ juɔ baa-yo, Pilati wuɔ cira: «U yaa daayo!» ");
INSERT INTO cmeNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","*Diilojigãntaamba yuntaamba‑i baa *Diilodubuɔ niyataaŋ baŋ juɔ'a ba ne da Yesu‑i, baa pãŋ doŋ ta ba kaasĩŋ wuɔ: «Gbu-yo *daaŋ-nu! Gbu-yo daaŋ-nu!» Pilati wuɔ cira: «Kãaŋ na ka gbu-yo na fɛrɛ; mɛi saa da kumaŋ ciɛ na'a na ko-yo.» ");
INSERT INTO cmeNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Yuifubaa baa cira: «U ciɛ u fɛrɛ Diiloŋ-Biɛŋo; a ne da a saa baa miɛ *ãnjĩnamma‑i, fuɔ temma‑i i saa saaya i yaŋ-yo, i gbĩɛ i ko-yo.» ");
INSERT INTO cmeNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Baŋ waaŋ mafamma‑i, Pilati holle pãŋ caar. ");
INSERT INTO cmeNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Wuɔ bir suur baa Yesu‑i ka yuu-yo wuɔ: «Naŋ hel hie?» Yesu saa seŋ sũnuŋgu yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilati wuɔ cira: «Ŋ fĩinaaŋ muɔmɛi nuɔ‑i wɛi? Ŋ saa suɔ wuɔ mi gbãa nanna-niɛ, mi gbãa bi ce ba gbu-ni *daaŋgu-na wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesu wuɔ cira: «Kuɔ Diilo saa naa hã-ni baa ku fɔ̃ŋgũɔ‑i, nii naa saa gbãa ce bĩŋkũŋgu muɔmi-na. Terieŋgu faŋgu-na, umaŋ juɔ baa-mi ji hã-ni, fuɔ cãlmuɔ maaraa naŋ wuoŋo‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pilatiŋ nuɔ nel daama‑i wuɔ pãŋ tuɔ taara u nanna Yesu‑i. Yuifubaa baa sire ta ba kaasĩŋ wuɔ: «Da kuɔ naŋ jĩɛŋo sĩ *jãmatigi‑i, nanna-yuɔ! Umaŋ duɔ ce u fɛrɛ nellentieŋo, jãmatigi bigãarãŋo!» ");
INSERT INTO cmeNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Baŋ piiye dumaaŋo-na, Pilati wuɔ tiraa hel baa Yesu‑i kã baa-yo terieŋgu naŋgu-na ba bĩ-ku «Gabata» ebiremma-na. Fãamaaŋo tĩɛna kusuɔŋ-nu'i u gɛr. Baŋ kãa, wuɔ tĩɛna u teterre-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Bãaŋgu naa hi yuhuɔŋga‑i tĩ, aa *kɔrsĩnni tĩmmaŋ-ponsaaŋgu waa ŋaa bisĩŋ ku temma. Pilati wuɔ gbɛ̃ Yuifubaa-ba‑i wuɔ: «Na nellentieŋo yaa daayo!» ");
INSERT INTO cmeNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","U waaŋ mafamma‑i ce niɛ? Baa sire ta ba kaasĩŋ wuɔ: «Ko-yo! Ko-yo! Gbu-yo daaŋ-nu!» Pilati wuɔ cira: «Na'a mi gbu na nellentieŋo yaa daaŋgu-na wɛi?» *Diilojigãntaamba yuntaaŋ baa cira: «Da ma hel *Oromɛ ba *jãmatigi‑i-na, nellentieŋo naŋo si dii baa-ye.» ");
INSERT INTO cmeNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Pilati wuɔ hã-ba Yesu‑i wuɔ ba ka gbu-yo daaŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","*Pilatiŋ hãa-ba hũmelle‑i, baa hel baa Yesu‑i nelleŋ-huɔŋga-na kã baa-yo baŋ bĩŋ terieŋgu maŋ ebiremma-na «Gɔlgota‑i», ku yuŋgu yaa wuɔ yukoluoŋgu. Baŋ ka gbuŋ-yoŋ *daaŋgu maŋ nuɔ‑i, baa haa-ku hã fuɔ fɛrɛ yaa tũu-ku. ");
INSERT INTO cmeNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ba kãa baa-yo kusuɔŋ-nu'i ka gbu-yo, a naara nuɔmba namba ba hãi; unaŋo‑i kɔtuɔŋ daaku-na, unaŋo‑i kɔtuɔŋ daaku-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilati wuɔ nyɛgɛ̃ŋ haa Yesu yudɔrɔ‑i-na wuɔ: «Nasarɛtitaaŋ Yesu, *Yuifu ba nellentieŋo.» ");
INSERT INTO cmeNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ba naŋ gbuu-yo terieŋgu maŋ nuɔ‑i, kuɔ sa maa baa nelleŋ-huɔŋga‑i, aa ba naŋ nyɛgãaŋ nelma maŋ haa u yudɔrɔ‑i-na, baa nyɛgãaŋ-ma ebiremma-na, baa latɛ̃mma-na, baa girɛkimma-na; a ce dumaaŋo-na, Yuifubaa bɔi baa kalaŋ-ma. ");
INSERT INTO cmeNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","*Diilojigãntaamba yuntaaŋ baa sire kã Pilati wulaa ka cira: «Hur Yuifu ba nellentieŋo‑i aa ŋ nyɛgɛ̃ŋ wuɔ: ‹Naacolŋ daayo ciɛra u yaa Yuifu ba nellentieŋo‑i.›» ");
INSERT INTO cmeNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilati wuɔ gbɛ̃-ba wuɔ: «Miŋ nyɛgãaŋ kumaŋ, mi nyɛgãaŋ ku yaa‑i; mi siɛ gbãa hur-ku aa nyɛgɛ̃ŋ kunaŋgu.» ");
INSERT INTO cmeNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Sorosibaa-baŋ gbuu Yesu‑i, baa biɛ u niidiini‑i calnu-niɛ sɔmma naa; nelduɔŋo biɛ sɔmma diei. Aa naa bi biɛ u joŋgorbuɔ‑i. Joŋgorbuɔ daayo‑i muŋgbommu saa waa-yuɔ; kompaŋga diei duɔŋ dɔrɔ‑i-na ji hi cicaara‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Baa ta ba piiye baa ba-naa wuɔ: «Baa na yaŋ i taalnu joŋgorbuɔ daayo‑i, yaaŋ i ful tieŋa i ne umaŋ ka da-yo.» Mamaŋ nyɛgãaŋ Diiloŋ-nelma-na ma'i sĩ daama‑i wɛi? Ma nyɛgãaŋ wuɔ: «Ba calaanu mi niidiini‑i ba-naa nuɔ aa ful tieŋa biɛ mi joŋgorbuɔ‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Baŋ gbuu Yesu‑i, u nyu waa u caaŋgu-na baa u nyu hãaŋo naŋo, a naara Maari maŋ Kulopasi ciɛŋo‑i, baa Maari maŋ taa u hel Magidala‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesu wuɔ ne da u nyu‑i baa u *hãalãbiloŋo maŋ maama‑i taa ma dɔlnu-yuɔ ba waa yiɛra ba-naa canniŋ; wuɔ gbɛ̃ nyuŋo‑i wuɔ: «Nnaa, ŋ biɛŋo yaa‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Aa gbɛ̃ hãalãbiloŋo‑i wuɔ: «Ŋ nyu yaa‑i.» Uŋ piiye dumaaŋo-na, hãalãbiloŋ daa u saa bir u huoŋgu nyuŋo-na; wuɔ biɛ-yo u ka tĩɛna fuɔ terieŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yesuŋ ciɛ mafamma‑i, wuɔ ne da mamaŋ waa cemma hiere ma ciɛ. Wuɔ cira: «Hũŋkuɔsĩnni bilaa-mi.» U waaŋ ma yaa‑i a ce mamaŋ nyɛgãaŋ Diiloŋ-nelma-na ma da ma gbãa ce. ");
INSERT INTO cmeNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Bũnaŋga naŋga waa terieŋgu-na niisaarni'i naa yuu-ka. Sorosibaa baa dii kãnsaarma niisaarŋ daani-na aa naa ful-ma *isopegboruoŋ-nu kã baa-ma Yesu nuŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesu wuɔ mɔsũnya niisaarŋ daani‑i aa naa cira: «Fiɛfiɛ fuɔ, wɛima tĩɛ.» Aa naa bi nisĩŋ u yuŋgu‑i, u tamma yaa dumaaŋo-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Baŋ gbuu Yesubaa-ba‑i yiiŋgu maŋ nuɔ‑i, ku waa jumayiiŋgu. Ku cuo kaala waa *yitĩɛnaŋgu; a ce dumaaŋo-na, *Yuifu ba yuntaamba saa ta ba taara yitĩɛnaŋgu hi Yesubaa-ba‑i dii dɔrɔ‑i-na. A tiraa naara yitĩɛnaŋgu faŋgu waa yibuɔ ba wulaa. Baa kã ka cãrã *Pilati‑i wuɔ u yaŋ ba ka kara ba gbeini‑i ku yaa ba ka ku donduo ba har-ba aa yitĩɛnaŋgu suɔ da ku hi. ");
INSERT INTO cmeNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Pilati wuɔ hã-ba hũmelle‑i. Sorosibaa baa kã. Baŋ ŋa naa gbu bamaŋ baa Yesu‑i, baa kara dĩɛlã-wuoŋo gbeini‑i aa kã ka kara hãalĩŋ-wuoŋo niini‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ba birii ku yaa nuɔ‑i da ba kara Yesu niini‑i, a da u kuu; a ce dumaaŋo-na ba saa kara-niɛ. ");
INSERT INTO cmeNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Sorosiyiɛŋo naŋo yagar fɔ̃ u gbugbɛiŋo‑i baa u puɔluŋgu‑i. Uŋ fũɔ-yo dumaaŋo-na, tãŋ maa ta ma hel baa hũmma. ");
INSERT INTO cmeNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Umaŋ nyɛgãaŋ nel daama‑i, u daa-ma nuɔ baa u yufelle, u sa kar u huɔyasaŋga. Fuɔ fɛrɛ suyaa wuɔ u waŋ ninsoŋo. U taara na hũu-ma wuɔ ninsoŋo ku'i ciɛ u tuɔ waŋ-ma baa-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Diiloŋ-nelmaŋ piiye terieŋgu maŋ nuɔ‑i wuɔ: «Ba siɛ kanu halle u gboluoŋgu diei», ma'i saa ce daama‑i wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Aa ma tiraa piiye terieŋgu naŋgu-na wuɔ: «Ba ka bir ta ba ne baŋ fũɔ umaŋ.» ");
INSERT INTO cmeNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ku huoŋgu-na, Yosɛfu maŋ taa u hel Arimate‑i-na, wuɔ kã ka cãrã *Pilati‑i aa duɔ ka har Yesu‑i. Fuɔ bi waa Yesu huoŋgu-na, ŋga fuɔ taa u kãalã *Yuifu ba yuntaamba‑i, a ce dumaaŋo-na, u taa u fuo u kũŋgu‑i. Pilati wuɔ hã-yo hũmelle‑i u kã ka har Yesu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodɛmu maŋ naa kãa Yesu wulaa isuɔŋgu naŋgu-na, wuɔ kã ka naara-yuɔ. Nikodɛmu wuɔ guɔlaa *miir-namma baa alowɛsi-namma a kã. Ma yoyondoŋ maa yuu kilobaa komorre baa cĩnciel temma. ");
INSERT INTO cmeNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Baa kãyã ba-naa ba hãi‑i-na a tiil kuloŋo‑i baa natikolo-naŋ daama‑i aa fĩnya-yuɔ. Ba migãaŋ-yo ŋaa Yuifubaa-baŋ bi migãaŋ ba kuomba‑i dumaa aa suɔ fuure-bɛi. ");
INSERT INTO cmeNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ba naŋ gbuu Yesu‑i kusuɔŋ-nu, tibinniŋ-suoŋgu naŋgu waa ku caaŋgu-na. Tibinniŋ-suoŋ daaku huɔŋga-na, cĩncorfɛlɛnde waa, baa sa hi fuure moloŋo diɛ yogo. ");
INSERT INTO cmeNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","*Yitĩɛnaŋguŋ hii tĩ dumaaŋo-na, baa kã baa Yesu‑i kusuɔŋ-nu'i ka fuure-yuɔ aa da ba da ba fɛrɛ tigiiŋ cie yitĩɛnaŋgu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","*Yitĩɛnaŋgu cuo kaala‑i-na, Maari maŋ taa u hel Magidala‑i-na, wuɔ sire naar cicãnjãale-na a kã Yesu cĩncorre-na. Tãmpɛ̃buɔ naŋo naa suuye di nuŋgu‑i. Uŋ kãa ka hi, wuɔ da tãmpɛ̃l daade bũmalãa halaŋ. ");
INSERT INTO cmeNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Wuɔ bir gũunu baa gbaruŋgu kã ka da Simɔ-Piɛr baa *hãalãbiloŋo maŋ maama‑i taa ma dɔlnu Yesu‑i. Wuɔ gbɛ̃-ba wuɔ: «Ba hielaa Itieŋo‑i cĩncorre-na, aa i saa suɔ baŋ diyaa-yo kusuɔŋ-nu.» ");
INSERT INTO cmeNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Piɛr baa hãalãbiloŋ daayo‑i baa sire ta ba gbar ba kã cĩncorre terieŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Hãalãbiloŋ daa wuɔ gbar ka hi yaaŋga Piɛr-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Uŋ hii, u saa suur, wuɔ yiɛra aa naa gbĩina tuɔ ne. U niɛ ku yaa‑i a da kompabieŋa yaa yoŋ cĩncorre huɔŋga-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simɔ-Piɛrŋ juɔ ji hi, wuɔ cor suur a bi da kompabieŋa jĩɛna dumandɛ hĩɛma-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Baa naa ce kompaŋga naŋga a fĩnya kuloŋo yaaŋga‑i, wuɔ da kafaŋga fĩɛŋ jĩna ka deŋ. ");
INSERT INTO cmeNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Hãalãbiloŋ daayo suɔ suur fiɛfiɛ‑i-na. Uŋ suurii ka da-ku dumaaŋo-na, wuɔ suɔ hũu-ma wuɔ Yesu siire ninsoŋo. ");
INSERT INTO cmeNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ninsie ninsie, Diiloŋ-nelmaŋ waaŋ mamaŋ wuɔ Yesu naa saaya u sire hel kuomba hɔlma-na, u hãalãbiemba saa naa hi suɔ ma yaaŋga‑i yogo. ");
INSERT INTO cmeNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Hãalãbieŋ daabaŋ kaa da-ma dumaaŋo-na, baa bir kũŋ. ");
INSERT INTO cmeNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","*Hãalãbieŋ daabaŋ taa, Maari wuɔ yiɛra cĩncorre nuŋgu-na tuɔ kaal. Uŋ kaal, wuɔ ji gbĩina wuɔ fuɔ ne cĩncorre huɔŋga‑i; ");
INSERT INTO cmeNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","a da bige‑i daaku‑i? *Dɔrpɔpuɔrbiemba hãi baa joŋgorpiɛlmba. Ba tĩɛnaana baŋ ŋa naa galla Yesu‑i kusuɔŋ-nu: Unaŋo‑i u yuŋguŋ waa kusuɔŋ-nu, unaŋo‑i u gbeiniŋ waa kusuɔŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Dɔrpɔpuɔrbiemba yuu-yo wuɔ: «Bige‑i ciɛ ŋ ta ŋ kaal?» Maari wuɔ cira: «Ba hielaa mi Tieŋo‑i aa mi saa suɔ baŋ diyaa-yo kusuɔŋ-nu.» ");
INSERT INTO cmeNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Wuɔ u miɛl ne ku yaa‑i a da Yesu‑i u huoŋgu-na, ŋga u saa suɔ wuɔ u yaa‑i; ");
INSERT INTO cmeNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","u daa niɛ sĩ baŋ fuuriiye Yesu‑i suoŋgu maŋ nuɔ‑i kutieŋo yaa‑i. Yesu wuɔ cira: «Ciɛŋ nuɔ, bige‑i ciɛ ŋ ta ŋ kaal? Ŋ taara hai moloŋo‑i?» Wuɔ cira: «Naacolŋ nuɔ, da kuɔ nuɔnɛi biyaa-yo, pigãaŋ-mi niŋ jĩɛna-yuɔ kusuɔŋ-nu mi ka biɛ-yo.» ");
INSERT INTO cmeNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesu wuɔ cira: «Maari!» U miɛlãa ku yaa‑i a suɔ suɔ-yo. Wuɔ piiye ebiremma-na wuɔ: «Araabuuni!» Ku yuŋgu yaa wuɔ: Hãalãtie. ");
INSERT INTO cmeNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesu wuɔ cira: «Baa bella-miɛ! Mi saa hi nyugũŋ kã mi To wulaa yogo. Mamaŋ dii cemma: Kã ŋ ka waŋ baa mi baamba‑i wuɔ miɛ mi nyugũŋ kã mi To wulaa, u yaa namaa bi To. Mi kã mi Diiloŋo wulaa, u yaa namaa bi Diiloŋo.» ");
INSERT INTO cmeNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Maari wuɔ bi ta ka tũnu hãalãbiemba‑i wuɔ u daa Itieŋo‑i, aa bi waŋ uŋ puɔraa-yo baa mamaŋ. ");
INSERT INTO cmeNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Yinduɔŋgu faŋgu dãnambãaŋgu-na, *hãalãbiemba tigiiŋ ba-naa dũŋgu naŋgu-na aa naa gbonu-kuɔ ba fɛrɛŋ nuɔ. Ba taa ba kãalã *Yuifu ba yuntaamba‑i ku'i ciɛ baa gbonu-kuɔ ba fɛrɛŋ nuɔ. Ba juɔ'a ba ne da Yesu‑i ba hɔlma-na. Wuɔ gbɛ̃-ba wuɔ: «Tĩyãaŋ dɛi!» ");
INSERT INTO cmeNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Uŋ waaŋ mafamma‑i, wuɔ pigãaŋ-ba u nammu‑i baa u gbugbɛiŋo‑i. Hãalãbiembaŋ daa-yo, ba hɔmmu gbuu pãŋ fɛ̃ da yogogo. ");
INSERT INTO cmeNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yesu wuɔ tiraa cira: «Tĩyãaŋ dɛi!» Aa naa cira: «Mi To uŋ puɔraa-mi dumaa, muɔ mi bi puɔr-na dumɛi.» ");
INSERT INTO cmeNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Uŋ waaŋ mafamma‑i, wuɔ hul fafalmu dii-bɛi aa naa cira: «Mi hãa-na *Diiloŋ-Yalle yaa‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Da na pir bamaŋ ãmbabalma‑i, ma ka pir, ŋga da na saa pir bamaŋ maama‑i, ma ka tĩɛ ba yunni-na.» ");
INSERT INTO cmeNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","*Hãalãbiembaŋ daa Yesu‑i, Toma maŋ ba naŋ bĩŋ-yoŋ Pĩɛbaa-ba‑i u saa waa. ");
INSERT INTO cmeNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","U nabaamba kã ka tũnu-yuɔ wuɔ ba daa Itieŋo‑i. Toma wuɔ cira: «Muɔ da mi saa da hɛiŋa fonni‑i u nammu-na, da mi saa dii mi niele‑i foŋ daani-na, da mi saa dii mi naŋga‑i u gbugbɛiŋo-na, mi cɛraa mi hũu-ma.» ");
INSERT INTO cmeNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Yinni niediei cor, niehãi yiiŋgu-na, hãalãbiemba tiraa tigiiŋ ba-naa duduɔŋgu faŋgu-na. Toma waa baa-ba kufaŋgu‑i. Baa gbonu dũŋgu‑i ba fɛrɛŋ nuɔ. Ba juɔ'a ba ne tiraa da Yesu‑i ba hɔlma-na. Wuɔ gbɛ̃-ba wuɔ: «Tĩyãaŋ dɛi!» ");
INSERT INTO cmeNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Aa naa cira: «Toma, jo baa ŋ niele‑i bande. Ne mi nammu‑i. Dii ŋ naŋga‑i mi gbugbɛiŋo-na ŋ ne. Baa ce ŋ hɔmmu‑i mu hãi; hũu-ma wuɔ muɔmɛi!» ");
INSERT INTO cmeNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Toma wuɔ cira: «Nuɔnɛi mi Tieŋ nuɔ, nuɔnɛi mi Diiloŋ nuɔ!» ");
INSERT INTO cmeNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yesu wuɔ cira: «Ŋ daa mi yufelle ku'i ciɛ ŋ hũu-ma; yaŋ mi tũnu-niɛ: Bamaŋ da ba saa da mi yufelle aa hũu-ma, kutaamba yunni dɔlaa.» ");
INSERT INTO cmeNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu ciɛ gbɛrɛ-wɛima namma u hãalãbiemba hɔlma-na aa ma saa waŋ sɛbɛ daayo-na. Gbɛrɛ-wɛima famma bi ciinu. ");
INSERT INTO cmeNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ŋga mamaŋ nyɛgãaŋ daama‑i, ma nyɛgãaŋ wuɔ na suɔ aa hũu-ma wuɔ Yesu yaa *Koŋkortieŋo maŋ Diiloŋ uŋ saaŋ-yo, u yaa Diiloŋ-Biɛŋo‑i. Aa da na hũu u nelma‑i, na ka da cicɛ̃lma maŋ sa tĩɛŋ dede‑i fuɔ barguɔ yaa nuɔ‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ku huoŋgu-na, Yesu *hãalãbiemba namba tiraa da-yo dii Tiberiyadi dalaŋga-na. Baŋ daa-yo dumaa ku yaa daaku: ");
INSERT INTO cmeNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simɔ-Piɛr, baa Toma maŋ ba naŋ bĩŋ-yoŋ Pĩɛbaa-ba‑i, ba waa yiiŋgu naŋgu-na baa ba-naa, a naara Natanayɛl maŋ taa u hel Kana nelle-na dii *Galile mara‑i-na, baa Sebede bɛpuɔmba‑i a naara hãalãbiemba namba ba hãi. ");
INSERT INTO cmeNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simɔ-Piɛr wuɔ gbɛ̃-ba wuɔ: «Mɛi taara da mi ka naŋ juɔŋo.» Baa cira: «Miɛ fɛrɛ‑i i ka kã baa-ni.» Ba taa ku yaa‑i, ku waa isuɔŋgu, kã ka suur beŋo-na a naŋ juɔŋo‑i da suu, ba saa da bĩŋkũŋgu bel. ");
INSERT INTO cmeNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Kuŋ juɔ ta ku kaala huɔŋgu maŋ nuɔ‑i, baa da moloŋo naŋo yiɛraaya bomborma-na; ŋga ba saa suɔ wuɔ Yesu yaa‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yesu wuɔ cira: «Mi jɛ̃naaŋ namaa, na daa bel wɛi?» Baa cira: «I saa da bĩŋkũŋgu.» ");
INSERT INTO cmeNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Yesu wuɔ cira: «Naaŋ juɔŋo‑i na nadieyaŋga‑i na ka da.» Baa bi naŋ juɔŋo‑i a bel titiraamba‑i juɔŋo yu tuɔ yar-ba famma. ");
INSERT INTO cmeNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","*Hãalãbiloŋo maŋ maama‑i taa ma dɔlnu Yesu‑i u waa. Fuɔ wuɔ gbɛ̃ Simɔ-Piɛr wuɔ: «Itieŋo yaa‑i!» Simɔ-Piɛrŋ nuɔ mafamma‑i, uu naa hiel u joŋgoruo‑i, wuɔ pãŋ biɛ-yo dii-yo aa naa tie suur hũmma-na. ");
INSERT INTO cmeNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","U nabaaŋ baa fa titiraaŋ daaba‑i kã baa-ba bomborma-na baa beŋo‑i. Ku saa naa gbãa maa dumaa, mɛtiribaa komuɔŋa ndii temma. ");
INSERT INTO cmeNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Baŋ huɔlaa, baa da dãamu baa teterieŋo mu dɔrɔ a naara *buruo. ");
INSERT INTO cmeNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesu wuɔ cira: «Naŋ bilaa titiraamba maŋ, juɔŋ baa banamba bande.» ");
INSERT INTO cmeNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simɔ-Piɛr wuɔ suur beŋo-na a fa juɔŋo‑i hel baa-yo bomborma-na. Uu naa yu baa tetekãŋkarɛiŋa. Ba waa komuɔŋ-niehãi baa cĩncieluo titiraamba siɛi juɔŋo-na. Baŋ fiɛ ciinu dumaaŋo-na, juɔŋo saa kar. ");
INSERT INTO cmeNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesu wuɔ cira: «Juɔŋ na ji wuo niiwuoni‑i.» Hãalãbieŋ baa pãŋ suɔ wuɔ Itieŋo yaa‑i, ŋga hai ka siɛ yuu-yo? ");
INSERT INTO cmeNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yesu wuɔ piɛ a biɛ buruo‑i bũlnu-yuɔ hã-ba; aa naa bi hã-ba titiraamba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yesuŋ siire hel kuomba hɔlma-na, u caraaya u hãalãbiemba‑i i siɛi yaa dɛ‑i. ");
INSERT INTO cmeNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Baŋ juɔ wuo niiwuoni‑i tĩ, Yesu wuɔ cira: «Simɔ, Nsãa biɛŋ nuɔ, mi maama dɔlnu-niɛ a yaŋ daaba‑i wɛi?» Simɔ wuɔ siɛ wuɔ: «Ũu.» Aa naa cira: «Itie, naŋ fɛrɛ ŋ suyaa wuɔ ŋ maama dɔlnu-miɛ.» Yesu wuɔ cira: «Bel mi dombũurãamba‑i dɛi.» ");
INSERT INTO cmeNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Aa naa tiraa cira: «Simɔ, Nsãa biɛŋ nuɔ, mi maama dɔlnu-niɛ wɛi?» Simɔ wuɔ siɛ wuɔ: «Ũu.» Aa naa cira: «Itie, naŋ fɛrɛ ŋ suyaa wuɔ ŋ maama dɔlnu-miɛ.» Yesu wuɔ cira: «Ta ŋ ne mi dombũurãamba‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Aa naa tiraa yuu-yo ku yu u bɛyufieŋa‑i wuɔ: «Simɔ, Nsãa biɛŋ nuɔ, mi maama dɔlnu-niɛ wɛi?» Simɔ huɔŋ kaa pãŋ du baa Yesu‑i, wuɔ u ciɛ niɛ tuɔ yuu-yo i sa‑i-siɛi dumaaŋo-na. Wuɔ cira: «Itie, ŋ suɔ nelma‑i hiere, aa ŋ suyaa kerre wuɔ ŋ maama dɔlnu-miɛ!» Yesu wuɔ cira: «Bel mi dombũurãamba‑i dɛi.» ");
INSERT INTO cmeNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Aa naa cira: «Yaŋ mi waŋ ninsoŋo‑i baa-ni: Niŋ ŋa naa waa naacoloŋ nuɔŋo‑i, ŋ taa ŋ pɛ̃yɛ̃ ŋ nɛgɛlle‑i ŋ fɛrɛ, aa terieŋgu maŋ dɔlaanu-niɛ ŋ kã kusuɔŋ-nu'i; ŋga da ŋ ji vãa, ŋ ka tɛtɛŋ ŋ nammu‑i ba pɛ̃yɛ̃ ŋ nɛgɛlle‑i hã-ni, aa niŋ'a ŋ sa taara ŋ kã kusuɔŋ-nu, ba kã baa-ni kusuɔŋ-nu'i.» ");
INSERT INTO cmeNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesu piiye ãndaaŋ daaku‑i duɔ pigãaŋ Piɛrŋ ka ku kuliiŋgu maŋ a ce Diiloŋo ce bɔi. Uŋ waaŋ mafamma‑i, wuɔ gbɛ̃-yo wuɔ: «Suur mi nallu-na.» ");
INSERT INTO cmeNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Piɛr wuɔ u miɛl ne ku yaa nuɔ‑i, a da *hãalãbiloŋo maŋ maama‑i taa ma dɔlnu Yesu‑i ma yaŋ ba huoŋgu-na. Hãalãbiloŋo faŋo yaa naa yuu Yesu‑i jukalaaŋgu-na wuɔ: «Itie, ŋ'a hai ka hel ŋ huoŋgu-na?» ");
INSERT INTO cmeNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Piɛrŋ daa-yo dumaaŋo-na, wuɔ cira: «Itie, daa fuɔ, hama‑i ka da-yo?» ");
INSERT INTO cmeNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesu wuɔ cira: «Da mi fiɛ cira u tĩɛ ji hi mi birma‑i ma hii nuɔ baa bige‑i? Nuɔ suur mi nallu-na.» ");
INSERT INTO cmeNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Nel daa maa sire gbuo terni‑i hiere wuɔ hãalãbiloŋ daayo siɛ ku. A ne da Yesu saa waŋ mafamma; u ciɛra: «Da mi fiɛ cira u tĩɛ ji hi mi birma‑i ma hii nuɔ baa bige‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Hãalãbiloŋo faŋo yaa daa nel daama‑i aa nyɛgɛ̃ŋ-ma, aa i suyaa wuɔ u saa kar u huɔyasaŋga. ");
INSERT INTO cmeNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesu ciɛ nelma bɔi. Diɛ i biɛ-ma ma yuŋ-nu hiere nyɛgɛ̃ŋ-ma maŋ ciɛ dumaa, mɛi huɔŋ-na, sɛbɛbaa-ba famba siɛ gbãa suur miwaaŋo-na.");
INSERT INTO cmeNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Tofil, Yesuŋ siire waŋ Diiloŋ-nelma‑i aa ce mamaŋ hiere a ji hi u nyugũmma‑i, mi waaŋ ma yaa‑i mi sɛbɛdĩɛlãŋo-na. Aa suɔ duɔ ta, uŋ ŋa naa hiel bamaŋ ce-ba u *pɔpuɔrbiemba, *Diiloŋ-Yalle ciɛ u pigãaŋ-ba ba maacemma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Uŋ kuu aa sire, u taa u carra ba yaa‑i ba da ba suɔ wuɔ u siire. U ciɛ yinni komuɔŋa hãi baa-ba tuɔ carra-bɛi u piiye *Diiloŋ-bãaŋgu maama‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Yiiŋgu naŋgu-na, ba waa ta ba wuo niiwuoni, wuɔ gbɛ̃-ba wuɔ: «Baa na maa *Yerusalɛmu‑i-na; miŋ waaŋ mamaŋ baa-na wuɔ mi To pãa-na nuŋgu, ciyaaŋ ma ce igɛ̃na. ");
INSERT INTO cmeNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Na saa da, Nsãa *baatiseŋ nuɔmba‑i baa hũmma, ŋga namaaŋo‑i, ku siɛ da yinni, mi ka batiseŋ-na baa Diiloŋ-Yalle‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Yiiŋgu naŋgu-na, baa ji tigiiŋ ba-naa. U pɔpuɔrbiemba yuu-yo wuɔ: «Itie, ku ce ŋ ka bir hã *Isirahɛl-baamba‑i baa fɔ̃ŋgũɔ‑i fiɛfiɛ dumandɛ wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yesu wuɔ cira: «Mi To uŋ diyaa huɔŋgu maŋ baa ma cemma‑i, kuu sĩ namaa kuusuɔŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ŋga u Yalle da di jo-nɛi, na ka da fɔ̃ŋgũɔ ta na waŋ mi maama‑i Yerusalɛmu‑i-na, baa *Yude‑i-na, baa *Samari‑i-na ka cor baa nilɛiŋa naŋa‑i hiere hĩɛma-na.» ");
INSERT INTO cmeNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Uŋ waaŋ mafamma‑i, ba'a ba ne da u nyugũŋ u kã dɔrɔ, u nyugũŋ u kã dɔrɔ, kã ka balla nyaasĩnni-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Baa bi yagar yiɛra tã ba yunni‑i ta ba ne. Ba juɔ'a ba ne da joŋgorpiɛlntaamba hãi ba caaŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Joŋgorpiɛlntaaŋ daaba gbɛ̃-ba wuɔ: «Galiletaaŋ namaa, bige‑i ciɛ na yiɛra dĩŋ dɔrɔ‑i-na ta na ne dumaaŋo-na? Naŋ daa Yesuŋ taa dumaa kã dɔrɔ‑i-na, duɔ ji cira u jo, u ka bi jo dumɛi.» ");
INSERT INTO cmeNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ba waa *Olivi-tibinni-tãnuŋ-nu. Ku hɔlma yuu kilo diei temma baa Yerusalɛmu huɔŋga‑i. Baa bir gũunu jo Yerusalɛmu‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Baŋ juɔ, baa kã ka nyugũŋ suur dũŋgu naŋgu-na, ba jo ba tigiiŋ ba-naa kusuɔŋ-nu'i koko. Bamaŋ waa, ba yaa daaba: Piɛr, Nsãa, Sake baa Ãndere, Filipu baa Toma, Batelemi baa Matie, Sake maŋ Alfe biɛŋo waa, Simɔ maŋ taa u kuye u nelle maama‑i a naara *Yuda maŋ Sake biɛŋo‑i, ba'i waa dumaaŋo-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ba hieroŋo‑i, baa ta ba tigiiŋ ba-naa kpɛ̃kpɛ̃ ba cãrã Diiloŋo‑i. Caamba namba waa baa-ba, Yesu nyu waa a naara u hãmba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Yiiŋgu naŋgu-na, Piɛr wuɔ ji sire yiɛra Diiloŋ-dũŋ-baamba hɔlma-na, ba waa nuɔmba komuɔŋ-niediei temma, aa naa cira: ");
INSERT INTO cmeNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«Tobiŋ namaa, nelma maŋ nyɛgãaŋ Diiloŋ-nelma-na, maa naa saaya ma ce. *Diiloŋ-Yalleŋ ciɛ *Davidi waŋ mamaŋ *Yuda kũŋgu-na, ma ciɛ. Yuda yaa juɔ ce tayaana ba ka bel Yesu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yuda waa baa-ye i tiɛ ce maacenduɔma. ");
INSERT INTO cmeNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Uŋ ciɛ maacembabalaŋ daama‑i da gbeiŋa maŋ, u sãa suoŋgu baa-ya. U juɔ par diire u yuŋ-nu suoŋgu faŋgu-na a muonu u kusũŋgu‑i, u purru hel hiere bomborma-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Yerusalɛmutaamba nuɔ nel daama‑i hiere ka saa, a ce ba haa suoŋgu faŋgu yerre‑i ba nelma-na wuɔ ‹Hakɛldama›, ku yuŋgu yaa wuɔ tãmmaŋ-suoŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","A ne da ma nyɛgãaŋ Gbɛliɛmaŋ-nɛini-na wuɔ: ‹U dumɛlle saaya di muonu; molo baa waa tĩɛna-diɛ.› Aa tiraa nyɛgɛ̃ŋ wuɔ: ‹Molo saaya u biɛ u maacemma‑i.› ");
INSERT INTO cmeNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","«Terieŋgu faŋgu-na, bamaŋ waa baa-ye i wuɔramma-na hiere baa Itieŋo‑i, ");
INSERT INTO cmeNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","a doŋ Nsãa uŋ *baatiseŋ-yo huɔŋgu maŋ nuɔ‑i, a ka hi u nyugũmmaŋ-yiiŋgu‑i, kutieŋo saaya u hel ba yaa nuɔ‑i a naara-yiɛ i tiɛ waŋ u siremma kũŋgu‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Uŋ juɔ piiye tĩ, baa hiel nuɔmba hãi da ba fiɛl u diei bɛi: Yosɛfu baa Matiyasi. Yosɛfu yerre nande yaa waa Barsabasi aa dinande‑i Yutusi. ");
INSERT INTO cmeNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Baŋ ciɛ mafamma‑i, baa cãrã Diiloŋo‑i cira: «Itieŋ nuɔ, nuɔnɛi suyaaŋ i hɔmmu‑i hiere. Niŋ ka hiel umaŋ ba hãi baaŋ daaba-na, pigãaŋ-ye baa-yo ");
INSERT INTO cmeNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","u biɛ maacemma maŋ Yudaŋ naana-mɛi aa kã u muŋkãmmu.» ");
INSERT INTO cmeNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Baŋ juɔ cãrã tĩ, baa ful tieŋa a hiel. Tieŋa bel Matiyasi. Matiyasi wuɔ suur naara *pɔpuɔrbiemba‑i. Baa naa tĩɛ cĩncieluo u diei. ");
INSERT INTO cmeNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","*Pãntekɔti-yiiŋgu-na, Diiloŋ-dũŋ-baamba waa hiere tigiiŋ terduɔŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ba juɔ'a ba ne da ijieni naŋ temma hilaa dɔrɔ‑i-na ŋaa fafalmu, a jo ji yu baŋ waa dũŋgu maŋ nuɔ‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ba'a ba tiraa ne, a da dãamu nammu calnu mu haa ba yunni-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Muŋ calaanu haa-bɛi dumaaŋo-na, *Diiloŋ-Yalle pãŋ yu ba hɔmmu‑i a ce ba doŋ ta ba piiye niɛraaŋ-nelma. ");
INSERT INTO cmeNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","A ne da *Yuifubaa-ba maŋ wuɔyaaŋ ba Diiloŋ-hũmelle‑i fafamma, ba fɔ̃ŋgũɔ baa hilaa nilɛiŋa-na hiere jo *Yerusalɛmu‑i-na yibieŋa faŋa-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Baa tĩɛna ji nu ijieŋ daani‑i, baa sire gbar kã ka yu. Bamaŋ waa hiere, nɛliɛŋo nɛliɛŋo u nuɔ Yesu *pɔpuɔrbiemba piiye fuɔ fɛrɛŋ nelma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Kuɔ cu ba hɔmmu‑i, baa ta ba piiye wuɔ: «Ma sĩ Galiletaamba‑i daaba‑i hiere kɛ? ");
INSERT INTO cmeNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ba ciɛ niɛ ta ba nu i nelma‑i hiere ba waŋ-ma baa-ye? ");
INSERT INTO cmeNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ŋ siɛ suɔ wuɔ miɛ maŋ jãanu i-naa bande‑i-na, Partitaamba dii-yiɛ, Meditaamba dii, Elamutaamba dii, Mesopotamitaamba dii, bamaŋ hilaa *Yude‑i-na baa bi dii, Kapadɔsitaamba dii, Pɔ̃taamba dii, Asitaamba dii, ");
INSERT INTO cmeNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Firgitaamba dii, Pãnfilitaamba dii, Esipitaamba dii, Libitaamba maŋ dii Sirɛni caaŋgu-na baa dii, bamaŋ hilaaŋ *Ɔrɔmu‑i-na bafamba bi dii, ");
INSERT INTO cmeNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Yuifukirɛiŋa dii, bamaŋ bi suurii Yuifusĩnni-na baa bi dii, Kirɛtitaamba dii, Arabubaa-ba dii, aa i hieroŋo-na, Diiloŋ uŋ ciɛ maacenfafamma maŋ, nɛliɛŋo nɛliɛŋo u nuɔ-ma u fɛrɛŋ nelma-na.» ");
INSERT INTO cmeNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Kuɔ ce-ba gbɛrɛ, ba sa suɔ baŋ jɔguɔŋ mamaŋ. Baa ta ba yuu ba-naa wuɔ: «Nel hama‑i temma‑i dumandɛ‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Banaŋ baa bir yaŋ aa ta ba nyɛ pɔpuɔrbiemba‑i wuɔ ba nyuɔŋ kolma. ");
INSERT INTO cmeNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Maŋ juɔ waa dumaaŋo-na, Piɛr wuɔ sire yiɛra baa u nabaamba‑i aa naa doŋ tuɔ piiye da gbagaga wuɔ: «*Yuifubaa namaa, baa namaa namaŋ dii tĩɛna *Yerusalɛmu‑i-na, mi ka waŋ nelma diei baa-na, karaaŋ na tũnni‑i dɛi na nu-ma. ");
INSERT INTO cmeNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Na suyaa wuɔ bãaŋgu saa hi boŋ yogo aa na'a ba nyuɔŋ kolma, ba daa-ma hie? ");
INSERT INTO cmeNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Na saa da, Diiloŋ uŋ puɔraa Yowɛl waŋ mamaŋ, ma'i ciɛŋ. ");
INSERT INTO cmeNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Yowɛl waaŋ-ma wuɔ: ‹Diiloŋo ciɛra wuɔ: «Miwaaŋo tĩmmaŋ-huɔŋgu-na, mi ka gbuo nuɔmba‑i hiere baa mi *Yalle‑i. Na bisãlmba ka ta ba ce mi pɔpuɔruŋgu‑i. Mi kaa ta mi carra naaciemba‑i mi piiye baa-ba. Aa ta mi piiye baa bĩncuɔmba‑i dãnsãnniŋ. ");
INSERT INTO cmeNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Coima saa fa, bamaŋ cãa-miŋ hiere, caamba‑i baa bɛmba‑i, mi ka gbuo-ba baa mi Yalle‑i huɔŋ daaku-na, ba ka waa mi pɔpuɔrbiemba. ");
INSERT INTO cmeNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Mi ka ce gbɛrɛ-wɛima dɔrɔ‑i-na baa hĩɛma-na hiere: Tãmma kaa waa, dãamu kaa waa, nyaasĩnni kaa bi waa bɔi. ");
INSERT INTO cmeNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Bãaŋgu kaa bir cure ŋaa isuɔŋgu aa cɛiŋo bir ce dãa ŋaa tãmma. Mafamma ka ce aa Itieŋo jommaŋ-yiiŋgu suɔ hi. Yiiŋgu faŋgu temma siɛ ji waa; ku kaa waa yibuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","A ce dumaaŋo-na, umaŋ duɔ ji tuɔ gbuuse Itieŋo‑i, kutieŋo ka kor.»›» ");
INSERT INTO cmeNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Piɛr wuɔ suonu u ãndaaŋgu‑i wuɔ: «*Isirahɛl-baaŋ namaa, yaaŋ mi waŋ nelma diei baa-na: Diiloŋo pigãaŋ-na Nasarɛtitaaŋ Yesu fɔ̃ŋgũɔ‑i. U ciɛ u ce gbɛrɛ-wɛima bɔi na hɔlma-na. Namaa fɛrɛ‑i na saa yaŋ-ma damma. ");
INSERT INTO cmeNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ba bel diiloŋo‑i bel-o hã-na. Diiloŋo suɔ wɛima‑i hiere; uu naa suɔ wuɔ na siɛ yaŋ-yo. Ma bi ciɛ: Na bilaa-yo a hã bamaŋ sa kãaŋ Diiloŋo‑i ba gbu-yo *daaŋ-nu ko-yo. ");
INSERT INTO cmeNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ŋga hĩɛma saa naa waa ma gbãa wuo-yo. A ce dumaaŋo-na, baŋ kuɔ-yo, Diiloŋo yaŋ-ba aa sire-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Na saa da, *Davidi piiye u maama wuɔ: ‹Mi da Itieŋo‑i hɔnni maŋ joŋ mi yaaŋga-na. U sa taara mi kũɔma nyɛŋ, ku'i ciɛ u jo ji waa mi caaŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Kufaŋgu hɔfɛ̃lle yaa yuu mi huɔŋga‑i a ce mi ta mi piiye dumandɛ‑i-na. Mi suyaa wuɔ da mi ku, mi ka fiisa. ");
INSERT INTO cmeNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Diilo, mi suyaa wuɔ ŋ siɛ yaŋ mi tĩɛ dii kuoŋ-nelle-na. Ŋ siɛ siɛ yaŋ naŋ nolŋo hɔr dii hĩɛma-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Hũmelle maŋ kãaŋ ŋ wulaa, ŋ pigãaŋ-mi baa-de. Da mi waa ŋ caaŋgu-na ŋ ka ta ŋ ce baa-mi.›» ");
INSERT INTO cmeNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Piɛr wuɔ cor baa u ãndaaŋgu‑i wuɔ: «Tobiŋ namaa, mi ka waŋ ninsoŋo‑i baa-na i bĩncɔiŋo‑i Davidi kũŋgu-na: Davidi kuu ba fuure-yuɔ, a ji hi baa nyuŋgo u cĩncorre dii i hɔlma-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Davidi waa Diilopɔpuɔrbiloŋo. Diiloŋo naa pã nuŋgu baa-yo wuɔ duɔ saa ji waa, u jãmatigisĩnni‑i, u ka hã u hãayɛ̃lŋo naŋo'i baa-ni. ");
INSERT INTO cmeNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","A ce dumaaŋo-na, Davidi naa tĩɛna baa-ma wuɔ *Koŋkortieŋo ka ku aa sire. Na saa da u ciɛra: ‹Diiloŋo siɛ yaŋ u nolŋo tĩɛ dii kuoŋ-nelle-na› aa ‹u siɛ yaŋ u hɔr dii hĩɛma-na.› ");
INSERT INTO cmeNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Koŋkortieŋo faŋo yaa Yesu‑i. Diiloŋ uŋ siire-yuɔ, miɛ maŋ daaye‑i hiere i daa-ma nuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Diiloŋo kãa baa-yo u ka tĩɛna u caaŋ-nu, aa uŋ ŋa naa pã nuŋgu maŋ baa-yo wuɔ u ka hã-yo u Yalle‑i, u hãa-yo baa-de u gbuo-ye baa-de hiere. Naŋ daŋ mamaŋ daama‑i baa naŋ nuŋ mamaŋ, difande maacemma'i. ");
INSERT INTO cmeNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Davidi fuɔ fɛrɛ saa kã dɔrɔ‑i-na, ŋga u piiye Yesu kũŋgu‑i wuɔ: ‹Itieŋo gbĩɛ mi Tieŋo‑i wuɔ: «Jo ŋ ji tĩɛna mi caaŋ-nu ");
INSERT INTO cmeNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","aa ŋ yaŋ mi mal ŋ bigãarãamba‑i hã ŋ ce ŋ bãaŋgu‑i bɛi.»› ");
INSERT INTO cmeNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Terieŋgu faŋgu-na, nuharuŋgu si dii, Isirahɛl-baaŋ namaaŋo‑i hiere na saaya na suɔ wuɔ naŋ gbuu Yesu maŋ *daaŋgu-na, Diiloŋo ciɛ u yaa‑i Itieŋo‑i aa tiraa ce-yo Koŋkortieŋo.» ");
INSERT INTO cmeNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Baŋ juɔ nu nel daama‑i, kuɔ ce-ba bĩŋkũŋgu. Baa yuu Piɛrbaa-ba‑i wuɔ: «Dumaaŋo-na, i saaya i ce bige‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Piɛr wuɔ gbɛ̃-ba wuɔ: «Naanaŋ na cilɔbabalaŋo‑i aa na jo ba ji *batiseŋ-na Yesu-Kirsa yerre-na, ku yaa Diiloŋo ka hur na ãmbabalma‑i. Mafaŋ da ma ce, Diiloŋo ka hã-na u Yalle‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Na saa da, Diiloŋo pãa nuŋgu‑i baa namɛi baa na bisãlmba, wuɔ u ka hã-na u Yalle‑i. U bi pãa-ku baa uŋ ka bĩ bamaŋ yaayargaa-terni-na hiere ba cu u huoŋ-nu.» ");
INSERT INTO cmeNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Piɛr waaŋ nelma bɔi baa-ba a dii sirɛiŋa bɛi ba da ba hũu-ma. U taa u piiye baa-ba wuɔ: «Siyaaŋ koŋkoro‑i, ku yaa mamaŋ kaa da fiɛfiɛ ku nuɔmba‑i ma siɛ ka da-na.» ");
INSERT INTO cmeNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Yiiŋgu faŋgu-na, nuɔmba bɔi hũyãa Piɛr nelma‑i aa ce ba batiseŋ-ba. Ba yuu nuɔmba neifelle nuɔsiba ndii temma bamaŋ naa suurii naara Diiloŋ-dũŋ-baamba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Baa bilaanu ta ba jo ba nu Diiloŋ-nelma‑i Yesu pɔpuɔrbiemba wulaa. Ba waa ŋaa cɛduɔŋ-biemba, ta ba wuo niiwuoni‑i baa ba-naa aa ta ba bi cãrã Diiloŋo‑i baa ba-naa. ");
INSERT INTO cmeNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Yesu pɔpuɔrbiemba taa ba ce gbɛrɛ-wɛima bɔi, a ce dumaaŋo-na korma taa ma da nuɔmba‑i baa-ba. ");
INSERT INTO cmeNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Diiloŋ-dũŋ-baamba naa bel ba-naa hiere, ba saa ta ba ce huɔŋga baa ba nagãŋ-niini‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ba waa umaŋ duɔ da kumaŋ, u suor-ku aa jo baa gbeiŋa‑i ba ji cal-a ba-naa nuɔ a saa baa gbeiŋ-maamaŋ yeŋ-bɛi dumaa. ");
INSERT INTO cmeNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Yinni maŋ joŋ baa dii *Diilodubuɔ‑i-na, ba sa nanna yiiŋgu. Ba taa ba wuo niiwuoni‑i baa ba-naa cĩnni-na. Ba niiwuoni wuoma taa ma dɔl aa ba hɔmmu na firnu baa mu-naa. ");
INSERT INTO cmeNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ba taa ba hãl nɛini‑i ba tuɔlnu Diiloŋo‑i. Ba maama taa ma dɔlnu nuɔmba‑i hiere nelle-na. Aa yinniŋ taa ni cor dumaa, Itieŋo taa u kor nuɔmba‑i dumɛi u naara ba kãlle-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Yiiŋgu naŋgu-na, bãtaruŋgu-na, Piɛr baa Nsãa‑i ba taa ba kã da ba ka cãrã Diiloŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","A ne da naacolŋo naŋo waa, uŋ siire, u saa gbãa wuɔ dede. Yinni maŋ joŋ, ba biɛ-yo ba kã ba jĩna *Diilodubuɔ dumɛlle nande yaaŋga-na u tuɔ cãrã bamaŋ suuriiŋ ba wulaa. Dumɛlle fande‑i, ba bĩ-de wuɔ «Dumɛfafalle». ");
INSERT INTO cmeNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Piɛrbaa-baŋ kãa da ba ka suur, wuɔ tuɔ cãrã ba wulaa. ");
INSERT INTO cmeNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Baa ne-yo aa naa cira: «Ne bande.» ");
INSERT INTO cmeNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Naacolŋ wuɔ tuɔ ne-ba wuɔ sĩ ba taara ba hã-yo bĩŋkũŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Piɛr wuɔ cira: «Warbelle sĩ mi yerreŋ, ŋga kumaŋ dii baa-mi, mi ka hã-ni baa-ku.» Aa naa cira: «Nasarɛtitaaŋ Yesu-Kirsa yerre-na, sire ŋ ta ŋ wuɔ!» ");
INSERT INTO cmeNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Aa kã ka bel u nadienaŋga‑i duɔ sire-yuɔ. Naacolŋo gbeiŋ niɛ pãŋ firnu. ");
INSERT INTO cmeNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Wuɔ wuɔr sire pãŋ tuɔ wuɔ. Uŋ siire dumaaŋo-na, wuɔ tuɔ gbɛliɛŋ Diiloŋo‑i aa tuɔ tetiera aa kã ba ta ba suur baa Piɛrbaa-ba‑i Diilodubuɔ‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Nuɔmba juɔ'a ba ne da hai moloŋo‑i gbɛlaaŋ Diiloŋo‑i u suur daayo‑i? ");
INSERT INTO cmeNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Umaŋ tĩɛnaanaŋ Diilodubuɔ dumɛlle yaaŋga-na u cãrã, u yaa‑i. Kuɔ ce-ba gbɛrɛ aa tiraa dii kũɔnyɛlle-bɛi. ");
INSERT INTO cmeNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Naacolŋ daa uŋ siire, wuɔ pãŋ nyaarãa Piɛrbaa-ba‑i. Nuɔŋ baa jo ji yu-bɛi dii *Salomɔ kukuruuŋgu-na ta ba ne-ba. ");
INSERT INTO cmeNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Piɛrŋ daa baŋ neŋ-baŋ dumaaŋo-na, wuɔ cira: «*Isirahɛl-baaŋ namaa, baa na yaŋ ku ce-na gbɛrɛ. Baa na ta na ne wuɔ sĩ miɛmɛi siire naacolŋ daayo‑i baa i fɛrɛŋ fɔ̃ŋgũɔ, sisɔ i wuɔ Diiloŋ-hũmelle‑i fafamma ku'i ciɛ i gbãa sire-yuɔ; ku'i sĩ. ");
INSERT INTO cmeNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","I bĩncuɔmbaŋ siire wuɔ Diiloŋo maŋ hũmelle‑i, *Abiramu‑i baa *Isaki‑i a naara *Yakɔbu‑i, baŋ siire wuɔ Diiloŋo maŋ hũmelle‑i, u'i ciɛ u cãarãŋo ce bɔi. U cãarãŋo faŋo yaa Yesu‑i. Na ciɛ ba bel-o ka hã *Pilati‑i baa-yo. Pilati wuɔ u nanna-yuɔ, na'a ma siɛ gbãa wuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Na cĩinaana Diiloŋ-nolŋo‑i, na ciɛ ba bel nelviiŋo‑i aa ce ba nanna nelkoroŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Na ciɛ ba ko cicɛ̃lma tieŋo‑i. Ŋga naŋ fiɛ ko-yo, Diiloŋo siire-yuɔ hiel-o kuomba hɔlma-na, i daa-yo nuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Iŋ haa i naŋga‑i yuɔ ku'i kãayã naacolŋ daayo‑i; na sa bi yaŋ-yo suɔma. Iŋ haa i naŋga‑i Yesu‑i-na, ku'i ciɛ u sire-yuɔ yeryer dumandɛ‑i-na na yufelle-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","«Tobiŋ namaa, mi suyaa miɛ na saa naa suɔ-ma aa ce-ma, halle baa na yuntaamba‑i hiere. ");
INSERT INTO cmeNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ŋga Diiloŋ uŋ ŋa naa ce u *pɔpuɔrbiemba wuɔya waŋ mamaŋ, wuɔ uŋ ka saaŋ *Koŋkortieŋo maŋ, u ka mulĩɛŋ; nelma famma yaa ciɛ. ");
INSERT INTO cmeNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","«Mamaŋ dii cemma fiɛfiɛ‑i-na, naanaŋ na cilɔbabalaŋo‑i aa na bir na jo Diiloŋo wulaa, ku yaa u ka hur na ãmbabalma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Mafaŋ da ma ce, u ka pa kufĩɛŋ-bãaŋgu nɛi. Aa uŋ ŋa naa hiel Koŋkortieŋo maŋ dii ku domma-na, u ka bir saaŋ u jo. Koŋkortieŋo faŋo yaa Yesu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Dumandɛ‑i-na, uu dii tĩɛna dii dɔrɔ‑i-na tuɔ cie miwaaŋo duɔ bibirre ŋaa Diiloŋ uŋ ciɛ u pɔpuɔrbiemba waŋ-ma dumaa dii ku bembieŋa-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Na saa da, *Moisi waaŋ Yesu-Kirsa maama yaa wuɔ: ‹Diiloŋo ka hiel u *pɔpuɔrbiloŋo naŋo mɛi temma na hɔlma-na. Pɔpuɔrbiloŋo faŋ duɔ waŋ mamaŋ, baa na yagar-ma. ");
INSERT INTO cmeNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Umaŋ duɔ saa nu u nuŋgu‑i, ba ka hiel kutieŋo nuŋgu‑i Diiloŋo baamba-na aa ba ka ko-yo.› ");
INSERT INTO cmeNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Diilopɔpuɔrbiemba maŋ siire piiye hiere, a doŋ *Samiɛl-na, ba waaŋ nyuŋgo ku yiŋ daani maama‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Diiloŋ uŋ pãa nuŋgu maŋ aa ce u pɔpuɔrbiemba waŋ ku maama‑i, u pãa-ku baa namɛi. Aa uŋ pãa nuŋgu‑i baa na bĩncuɔmba‑i kusuɔŋ-nu aa gbɛ̃ Abiramu‑i wuɔ: ‹Mi ka ta mi cor baa naŋ hãayɛ̃lmba yaa‑i mi ce baa dũnni‑i hiere hĩɛma-na›, na nuŋgu dii nupãlle fande-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ku'i ciɛ na da Diiloŋo ciɛ u cãarãŋo jo namɛi wulaa‑i igɛ̃na duɔ ji kãyã-nɛi na nanna na maacembabalamma‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Piɛr baa Nsãa‑i baŋ waa ta ba piiye baa nuɔmba‑i, *Diilojigãntaamba‑i baa *Diilodubuɔ sorosibaa-ba yuntieŋo‑i, a naara *Sadusĩɛbaa-ba jo ji da-ba. ");
INSERT INTO cmeNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Piɛrbaa-ba taa ba piiye baa nuɔmba‑i wuɔ Yesu kuu aa sire, kɛrɛ yiiŋgu dii baa yiiŋgu kuomba ka bi sire fuɔ temma‑i. Baŋ juɔ ji da ba piiye dumaaŋo-na, ku saa dɔlnu-bɛi. ");
INSERT INTO cmeNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Baa bel-ba. Bãaŋgu naa tĩ tĩ. Baa kã ka dii-ba kaso ba cɔ. ");
INSERT INTO cmeNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Baŋ fiɛ bel-ba, baŋ hii piiye baa bamaŋ hiere, ba fɔ̃ŋgũɔ baa hũu-ma. Bamaŋ naa hũyãa-ma, ba gbãa yu nuɔmba neifieŋa hãi nuɔsiba ndii temma. ");
INSERT INTO cmeNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ku cuo kaala‑i-na, *Yuifu ba yuntaamba‑i baa nelle bĩncuɔmba‑i, a naara *ãnjĩnamma pigãataamba‑i, baa jãnu ba-naa *Yerusalɛmu‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","*Diilojigãntaamba yuntieŋo maŋ ba naŋ bĩŋ-yoŋ Ani‑i, u waa baa u dumɛlleŋ-baamba‑i hiere, a naara Kayifu, baa Nsãa, baa Alɛsãndire. ");
INSERT INTO cmeNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Baŋ jãanu ba-naa, baa ce ba jo baa Piɛrbaa-ba‑i. Baŋ juɔ, baa yuu-ba wuɔ: «Namaa hilaa baa hiŋ daama‑i hie a ji sire naacolŋ daayo‑i? Hai moloŋo‑i puɔraa-na?» ");
INSERT INTO cmeNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Huɔŋgu faŋgu-na, *Diiloŋ-Yalle naa yu Piɛr huɔŋga‑i, wuɔ cira: «Nelle yuntaaŋ namaa, baa bĩncuɔŋ namaa, ");
INSERT INTO cmeNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","i ciɛ ãnfafamma molo-na aa na bĩ-ye ji ta na yuu-ye iŋ ciɛ dumaa sire-yuɔ u murgusĩnni-na, dumɛi sĩ wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Nelma diei dii na saaya na suɔ-ma hiere baa *Isirahɛl-baamba‑i: Naŋ gbuu Nasarɛtitaaŋ Yesu maŋ *daaŋgu-na ko-yo aa Diiloŋo sire-yuɔ, fuɔ barguɔ yaa nuɔ‑i naacolŋ daayoŋ siire yeryer na yufelle-na dumandɛ‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ba waaŋ Yesu fuɔ maama yaa Diiloŋ-nelma-na wuɔ: ‹Tãmpɛ̃lle maŋ dumarãaŋ namaaŋo‑i naŋ cĩinaana-diɛ, di yaa juɔ bella dũŋgu‑i.› ");
INSERT INTO cmeNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Yesu yaa gbãa kor nelbiliemba‑i u diei yoŋ. Da ma hel ufaŋo-na, Diiloŋo saa hã-ye moloŋo yaŋga naŋga umaŋ gbãa kor-e.» ");
INSERT INTO cmeNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Piɛrbaa-baŋ daa holle‑i piiye dumaa, kuɔ cu ãndacetaamba hɔmmu‑i. Da ba ne, ba da-ba nelgbãŋgbãlãamba; ba sa suɔ sɛbɛ. Baa pãŋ suɔ wuɔ Yesu wuɔrataamba. ");
INSERT INTO cmeNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Da ba ne naacolŋo maŋ siire ba caaŋgu-na, ba siɛ suɔ baŋ ka waŋ mamaŋ. ");
INSERT INTO cmeNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Baa ce ba hiel Piɛrbaa-ba‑i gɔ̃ŋgũɔŋ-nu aa naa yuu ba-naa wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","«I ka ce-ba niɛ? Nuɔmba‑i hiere Yerusalɛmu‑i-na ba suyaa wuɔ ba yaa siire naacolŋ daayo‑i, nuharuŋgu si dii-mɛi; i siɛ bi gbãa ju-ma. ");
INSERT INTO cmeNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ŋga diɛ i sa taara nel daama gbuo nelle‑i hiere, i saaya i gboya-bɛi wuɔ ba baa yaŋ i tiraa nu ba bĩɛ Yesu yerre‑i baa moloŋo. Umaŋ duɔ bĩ-de, kumaŋ da ku waa, u ka da-ku.» ");
INSERT INTO cmeNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Baŋ juɔ da ba-naa tĩ, baa bĩ Piɛrbaa-ba‑i a ji waŋ baa-ba wuɔ ba baa yaŋ ba tiraa nu ba bĩɛ Yesu yerre‑i ba nunni-na, ba baa bi waŋ u maama baa moloŋo. ");
INSERT INTO cmeNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Piɛrbaa baa gbɛ̃-ba wuɔ: «Namaa fɛrɛ‑i niɛ-kuŋ na ne! I ce namaa maama yaa‑i aa yaŋ Diiloŋ-maama‑i wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Miɛ fuɔ, iŋ nuɔ mamaŋ, aa da mamaŋ, i siɛ gbãa fĩinaŋ-mɛi.» ");
INSERT INTO cmeNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Baŋ siire naacolŋo‑i, kuɔ gbuu dɔlnu nuɔmba‑i, baa ta ba gbɛliɛŋ Diiloŋo‑i, a ce dumaaŋo-na ãndacetaamba saa da nelma da ba cãl-ba; baa naa ba sĩɛl ba yufieŋa yaa piiye baa-ba aa nanna-bɛi ba kã. ");
INSERT INTO cmeNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Baŋ siire naacolŋo maŋ, u bieŋa naa cor bieŋ komuɔŋa hãi. ");
INSERT INTO cmeNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Baŋ naana Piɛr‑i baa Nsãa‑i, baa ta kã ba nabaamba wulaa. *Diilojigãntaamba yuntaamba‑i baa bĩncuɔmbaŋ waaŋ mamaŋ baa-ba hiere, baa tũnu ba nabaamba‑i baa-ma. ");
INSERT INTO cmeNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Baŋ tũɔnu-bɛi dumaaŋo-na, baa gbonu cãrã Diiloŋo‑i wuɔ: «Itie, nuɔnɛi hielaa dɔrɔ‑i baa hĩɛma‑i, baa dãmmaŋ-nuoraaŋgu‑i. Aa bi hiel ni huɔya-niini‑i hiere. ");
INSERT INTO cmeNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Nuɔnɛi ciɛ ŋ *Yalle dii nel daama‑i i bĩncɔiŋo‑i *Davidi nuŋgu-na u waŋ-ma wuɔ: ‹Bige‑i ciɛ nuɔmba sire ta ba pepiena nilɛiŋa-na? Ba saa suɔ wuɔ baŋ puu mamaŋ, ma siɛ kã terieŋgu wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Fɔ̃ŋgɔ̃taamba siire tɛrɛŋ yiɛra, aa yuntaamba pũulã Itieŋo‑i baa u Yufelleŋ-Nolŋo‑i.› ");
INSERT INTO cmeNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ninsie ninsie, *Erɔdi‑i baa *Pɔ̃se-Pilati‑i a naara *niɛraamba‑i baa *Isirahɛl-baamba‑i hiere, ba tigiiŋ ba-naa nel daade yaa nuɔ‑i, a pũulã ŋ cãarãŋo‑i Yesu‑i. Ba tigiiŋ ba-naa a pũulã ŋ Yufelleŋ-Nolŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Dumandɛ‑i-na, niŋ ŋa naa pu mamaŋ, mamaŋ waa ŋ huɔŋga-na, ba ciɛ ma yaa‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Fiɛfiɛ‑i-na, Itie, ŋ daa baŋ wur ŋ cãarãaŋ miɛŋo‑i dumaa. Hã-ye holle i tiɛ gbã i waŋ ŋ nelma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Kãyã-yiɛ i tiɛ gbã i sire jaamba‑i aa bi tiɛ ce nelma bɔi baa gbɛrɛ-wɛima bɔi ŋ cãarãŋo‑i Yesu yerre-na.» ");
INSERT INTO cmeNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Baŋ juɔ cãrã Diiloŋo‑i tĩ, hĩɛŋ maa sagalla baŋ waa tigiiŋ kusuɔŋ-nu. Diiloŋ-Yalle pãŋ yu ba hɔmmu‑i hiere. Baa da holle ta ba waŋ Diiloŋ-nelma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Diiloŋ-dũŋ-baamba‑i baa ba ciinumma‑i hiere baa naa gbuu bel ba-naa fafamma. Ba hɔlma-na, ŋ siɛ gbãa suɔ wuɔ mɛl kũŋgu‑i daaku‑i aa mɛl kũŋgu‑i daaku‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Himma naŋ temma waa Yesu *pɔpuɔrbiemba ãncemma-na ta ma pigãaŋ wuɔ Yesu siire kelkel. Diiloŋo naa silaa tuɔ ce baa-ba u cor. ");
INSERT INTO cmeNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Sonniŋ waa baa bamaŋ hiere, baa cĩnniŋ bi waa baa bamaŋ, ba taa ba suor-ni ba jo ba hã Yesu pɔpuɔrbiemba‑i baa ni gbeiŋa‑i. Bafaŋ da ba hũu-ya, ba ne ba gbeiŋ-maamaŋ jĩɛnya ma-naa dumaa aa bi hɔnu-yɛi dumɛi. A ce dumaaŋo-na sũntie saa waa ba hɔlma-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Unaŋo waa ba hɔlma-na, ba taa ba bĩ-yo Yosɛfu. U waa *Levitiyiɛŋo. U taa u hel Sipire. Pɔpuɔrbiemba taa ba bĩ-yo Barnabasi, ku yuŋgu yaa wuɔ Sirɛintieŋo. ");
INSERT INTO cmeNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Suoŋgu naŋgu waa baa-yo, wuɔ suor-ku aa naa jo baa ku gbeiŋa‑i ji hã pɔpuɔrbiemba‑i baa-ya. ");
INSERT INTO cmeNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Naacolŋo naŋo waa, ba taa ba bĩ-yo Ananiyasi aa bĩ u ciɛŋo‑i Safira. Terieŋgu naŋgu waa baa-ba, baa suor terieŋ daaku‑i ");
INSERT INTO cmeNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","aa naa saa-ma aa bɔlŋo hiel gbeiŋa naŋa aa kã baa a boluoŋgu‑i ka hã Yesu *pɔpuɔrbiemba‑i baa-ya. ");
INSERT INTO cmeNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Uŋ kãa, Piɛr wuɔ gbɛ̃-yo wuɔ: «Ananiyasi, bige‑i ciɛ ŋ yaŋ *Sitãni tãal-ni ŋ hiel kunaŋgu gbeiŋa-na aa jo ji ta ŋ kar coima‑i baa *Diiloŋ-Yalle‑i? ");
INSERT INTO cmeNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Terieŋgu‑i naŋ kũŋgu, molo saa cira ŋ suor-ku. Niŋ fiɛ suor-ku, gbeiŋa‑i naŋ waaŋa. Bige‑i ciɛ ŋ ce maaceŋ daama temma‑i? Niŋ karaa coima maŋ, ŋ saa kar-ma baa ŋ nanuɔmba, ŋ karaa-ma baa Diiloŋo.» ");
INSERT INTO cmeNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananiyasiŋ nuɔ nel daama‑i, u pãŋ cii, u bi kuliiŋgu yaa dumaaŋo-na. Umaŋ duɔ nu nel daama‑i, u kũɔma pãŋ ta ma nyɛŋ. ");
INSERT INTO cmeNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Naacieŋ baa jo ji biɛ-yo ka fuure. ");
INSERT INTO cmeNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ciɛŋo saa waa. Bɔlŋoŋ kuu, lɛrbaa-ba siɛi temma cor aa u suɔ tuɔ jo. Uŋ juɔ ji suur, u saa suɔ wuɔ wɛima ciɛ. ");
INSERT INTO cmeNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Piɛr yuu-yo wuɔ: «Ciɛŋ nuɔ, na suoraa na terieŋgu‑i sul daadu'i nuɔ‑i wɛi?» Ciɛŋ wuɔ siɛ wuɔ: «Ũu, ku sullu yaa‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Piɛr wuɔ cira: «Bige‑i ciɛ na saa-ma baa ŋ bɔlɔ‑i aa da na cure Diiloŋ-Yalle‑i? Ne, bamaŋ kãa ka fuure ŋ bɔlɔ‑i ba yaa bi suuriiŋ daaba, ba ka bi biɛ nuɔŋo‑i ka fuure-niɛ.» ");
INSERT INTO cmeNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ciɛŋ wuɔ pãŋ cii terieŋgu faŋgu-na a ku Piɛr caaŋgu-na. Naacieŋ ba'a ba suur ku yaa nuɔ‑i, a da u kuu. Baa tiraa biɛ ufaŋo‑i bir gũunu ka fuure bɔlŋo caaŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Diiloŋ-dũŋ-baamba kũɔma migãaŋ ta ma nyɛŋ ma naara. Umaŋ duɔ nu nel daama‑i, ku ce-yo kũɔnyɛlle. ");
INSERT INTO cmeNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Yesu *pɔpuɔrbiemba taa ba ce nelma bɔi baa gbɛrɛ-wɛima bɔi nuɔmba hɔlma-na. Ba taa ba tigiiŋ ba-naa *Salomɔ kukuruuŋgu yaa nuɔ‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Nuɔmba‑i hiere nelle-na ba taa waŋ ba yefafalle, ŋga molo saa tuɔ siɛ u piɛ-ba. ");
INSERT INTO cmeNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Caamba‑i baa bɛmba maŋ naa hũyãaŋ Itieŋo maama‑i baa sa waa dɛi baa yuliiŋgu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Nuɔmba waa da ba ce ba hel baa gbãŋgbaarbaa, baa figĩnni a galla ba jaamba‑i Piɛr muncormu-na, wuɔ duɔ tuɔ cor aa u yalle yiɛya umaŋ, u sire. ");
INSERT INTO cmeNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Nilɛiŋa maŋ *Yerusalɛmu kɔtɔnni-na hiere, nuɔmba bɔi taa ba hel-yɛi ba jo baa ba jaamba‑i pɔpuɔrbiemba wulaa. *Jĩnabaa-baŋ bi waa bamaŋ nuɔ‑i, ba taa ba jo baa-ba. Umaŋ duɔ jo baa u wuoŋo, u sire. ");
INSERT INTO cmeNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Nuɔmbaŋ joŋ pirpir Yesu *pɔpuɔrbiemba wulaa dumaaŋo-na, ku saa dɔlnu *Diilojigãntaamba yuntieŋo‑i baa u kuoyataamba‑i *Sadusĩɛbaa-ba‑i. Baa ce-ku nenemuŋgu ");
INSERT INTO cmeNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","aa naa bel pɔpuɔrbiemba‑i ka dii-ba kaso. ");
INSERT INTO cmeNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ku isuɔŋgu-na, Itieŋo *dɔrpɔpuɔrbiloŋo jo ji hĩl kaso‑i a hiel-ba aa naa gbɛ̃-ba wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«Kãaŋ *Diilodubuɔ‑i-na na ka waŋ hũmefɛlɛnde maama‑i hiere baa nuɔmba‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ku cuo kaala‑i-na, pɔpuɔrbieŋ baa naar kã Diilodubuɔ‑i-na ka doŋ ta ba waŋ Diiloŋ-nelma‑i. Diilojigãntaamba yuntieŋo‑i baa u kuoyataamba saa suɔ wuɔ ba hilaa. Cuoŋ kaalaa, baa bĩ bĩncuɔmba‑i da ba ji ce ãndaaŋgu‑i. Baŋ juɔ, baa puɔr wuɔ ba ka hiel-ba kaso‑i-na jo baa-ba. ");
INSERT INTO cmeNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Baa kã ba saa ka da-ba. Baa bir jo ji cira: ");
INSERT INTO cmeNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","«I saa ka da moloŋo kaso‑i-na. Iŋ kãa, kaso naa waa bĩŋ u temma‑i, aa bamaŋ niɛyaŋ-yuɔ ba waa ba munyiɛrammu-na hiere dumiɛŋa yammu-na. I hĩlãa-yo ku yaa nuɔ‑i, i saa da moloŋo huɔŋga-na.» ");
INSERT INTO cmeNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Sorosibaa-ba maŋ niɛyaŋ Diilodubuɔ‑i ba yuntieŋo‑i, baa *Diilojigãntaamba yuntaambaŋ nuɔ nel daama‑i, ba hɔŋ muɔ pãŋ cu; ba sa suɔ ku huoŋguŋ ka jo baa kumaŋ. ");
INSERT INTO cmeNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ba'a ba ne da naacolŋo naŋo juɔ ji tuɔ tũnu-bɛi wuɔ: «Naŋ bilaa balamba maŋ ka dii-ba kaso‑i-na, baa dii ta ba waŋ Diiloŋ-nelma‑i dii Diilodubuɔ‑i-na.» ");
INSERT INTO cmeNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Sorosi ba yuntieŋ wuɔ pãŋ sire baa u sorosibaa-ba‑i ka bel-ba jo baa-ba. Baŋ kãa, ba saa kã baa bubuɔsĩnni, wuɔ sĩ nuɔmba ka naŋ-ba baa tãmpɛ̃lɛ̃iŋa. ");
INSERT INTO cmeNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Baŋ kãa ka bel Yesu *pɔpuɔrbiemba‑i jo baa-ba, *Diilojigãntaamba yuntieŋ wuɔ yuu-ba wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","«Ma sĩ i waaŋ-ma baa-na kuola-mɛi wuɔ na baa bĩ naacolŋ daayo yerre‑i baa moloŋo kɛ? Ma daa niɛ na yaŋ-ye aa sire gbuo *Yerusalɛmu‑i hiere baa u maama‑i? Na taara na cira miɛmɛi kuɔ-yo kɛ?» ");
INSERT INTO cmeNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Piɛr baa u nabaamba‑i baa cira: «I siɛ gbãa maar Diiloŋo nuŋgu‑i ka ce nelbilieŋ kũŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Naŋ gbuu Yesu maŋ *daaŋgu-na ko-yo, i tobaa-baŋ siire wuɔ Diiloŋo maŋ hũmelle‑i, u siire-yuɔ ");
INSERT INTO cmeNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","aa kã baa-yo ka jĩna u caaŋ-nu. U hãa-yo yuntesĩnni‑i aa ce-yo koŋkortieŋo. U ciɛ kufaŋgu‑i duɔ kãyã *Isirahɛl-baamba da ba nanna ba cilɔbabalaŋo‑i aa u duɔ hur ba ãmbabalma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Nel daama‑i miɛ i daa-ma nuɔ, *Diiloŋ-Yalle bi daa-ma. Bamaŋ nuɔŋ Diiloŋo nuŋgu‑i, u hã-ba di yaa‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","*Nellentaambaŋ juɔ nu nel daama‑i, ba hɔmmu pãŋ guɔla. Baa pãŋ ta ba taara ba komma. ");
INSERT INTO cmeNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","*Farisĩɛyiɛŋo naŋo waa baa-ba, ba taa ba bĩ-yo Gamaliɛl. U waa *ãnjĩnamma pigãatieŋo. Nuɔmba taa ba kãŋ-yo nelle-na. Wuɔ sire yiɛra ba hɔlma-na aa naa cira: «Ciɛŋ ba hel gɔ̃ŋgũɔŋ-nu.» ");
INSERT INTO cmeNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Baŋ hilaa, wuɔ gbɛ̃ nuɔmba‑i wuɔ: «Isirahɛl-baaŋ namaa, jɔgaaŋ na ne igɛ̃na aa na suɔ na ce naŋ taaraŋ na ce kumaŋ balaŋ daaba-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ku belle-na, Tedasi siire ce u fɛrɛ nelbuɔ. Nuɔmba sire cu u huoŋ-nu ta ba kã nuɔmba nuɔsiba hãi caaŋ-nu. Baŋ juɔ ko-yo, ba curaa hie? Ba saa pisãllã hiere wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Fuɔ kũŋguŋ curaa, baŋ taa ba kãŋ nuɔmba‑i belle-na, Yuda maŋ taa u hel *Galile‑i-na, u siire hiel u yerre‑i. Nuɔmba bɔi cu u huoŋ-nu. Baŋ juɔ ko ufaŋo‑i, bamaŋ naa cu u huoŋ-nu, na daa-ba wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Fiɛfiɛ‑i-na, bamaŋ daaba‑i, mi gbãa waŋ mamaŋ: Niɛŋ-baŋ aa na yaŋ-ba. Da kuɔ ba ce nɛliɛŋ-maama, yiiŋgu dii baa yiiŋgu, ma ka bĩɛna. ");
INSERT INTO cmeNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ŋga da kuɔ Diiloŋ-maama ninsoŋo, na siɛ gbãa bĩɛna-mɛi. Niɛŋ torro, na baa ji ta na gãŋ baa Diiloŋo aa cira na gãŋ baa nelbiliemba?» ");
INSERT INTO cmeNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Gamaliɛlŋ piiye dumaaŋo-na, ba kã ka ciire aa naa bĩ pɔpuɔrbiemba suur. Baŋ suurii, baa bel-ba muo-ba da dɛi aa naa waŋ baa-ba wuɔ ba baa tiraa yaŋ ba da ba bĩɛ Yesu yerre‑i baa moloŋo! Baŋ ciɛ mafamma‑i, baa nanna-bɛi ba ta. ");
INSERT INTO cmeNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Baŋ bilaa-ba muo-ba Yesu maama-na, kuɔ gbuu silaa dɔlnu-bɛi wuɔ Diiloŋo ka tuɔ kãŋ-ba nelfafaamba Yesu huoŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Kuŋ ciɛ dumaaŋo-na, yinni maŋ joŋ, ba waŋ *Neldɔdɔlma‑i *Diilodubuɔ‑i-na baa cĩnni-na wuɔ Yesu yaa *Koŋkortieŋo maŋ Diiloŋ uŋ saaŋ-yo. ");
INSERT INTO cmeNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Nuɔmba bɔi taa ba hũu Yesu maama‑i huɔŋ daaku-na, a ce dumaaŋo-na bamaŋ piiyeŋ girɛkimma‑i, baa ta ba waana wuɔ bamaŋ piiyeŋ ebiremma‑i, ba cal niiwuoni‑i yinni maŋ joŋ aa ba sa hã bafamba bikulcaamba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Yesu *pɔpuɔrbiembaŋ daa ba waana dumaaŋo-na, baa tigiiŋ Diiloŋ-dũŋ-baamba‑i hiere a waŋ baa-ba wuɔ: «Tobiŋ namaa, na suyaa wuɔ i siɛ gbãa yaŋ Diiloŋ-nelma wamma‑i aa diɛ ne niiwuoniŋ-kũŋgu, ku saa biɛ dumaaŋo-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Hielaaŋ nuɔmba niehãi na hɔlma-na. Nuɔmba famba yefafalle saaya di waa nuɔmba nunni-na. *Diiloŋ-Yalle saaya di yu ba hɔmmu‑i aa ba saaya ba ta ba nu nelma. Da na hiel-ba, i ka bir maaceŋ daama‑i hã ba yaa‑i ");
INSERT INTO cmeNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","aa miɛ i fulnu Diilocãrãlle baa u nelma wamma.» ");
INSERT INTO cmeNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Bamaŋ waa hiere, baa hũu-ma aa naa sire hiel Etiɛni. Diiloŋ-maama‑i baa Diiloŋ-Yalle naa yu Etiɛni huɔŋga‑i. Baŋ hielaa Etiɛni‑i, baa hiel Filipu, baa Purokɔr, baa Nikanɔr, baa Timɔ a naara Parmenasi, baa Nikola. Nikola taa u hel Ãntiyɔsi, ŋga uu naa suur Yuifusĩnni-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Baŋ hielaa-ba, baa pigãaŋ pɔpuɔrbiemba‑i baa-ba. Baa haa ba nammu‑i ba yunni-na a cãrã Diiloŋo‑i hã-ba. ");
INSERT INTO cmeNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Diiloŋ-nelma taa ma gbuo terni‑i ma kã. Yinniŋ cor dumaa, nuɔmba hũu-ma dumɛi *Yerusalɛmu‑i-na. *Diilojigãntaamba maŋ naa hũyãa Yesu maama‑i baa sa waa dɛi. ");
INSERT INTO cmeNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Diiloŋo naa silaa ce baa Etiɛni‑i: Uu naa hã-yo himma u tuɔ ce gbɛrɛ-wɛima bɔi nelle-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","A ne da *Yuifubaa-ba namba taa ba kã *Diilonelhãalãdũŋgu naŋgu-na ba kã ba nu Diiloŋ-nelma‑i. Ba taa ba bĩ Diilonelhãalãdũŋgu faŋgu‑i «Kufĩɛŋ ba dũŋgu». Yuifubaa-ba famba kã ba ta ba fanu ba-naa baa Etiɛni‑i Diiloŋ-nelma-na. Ba hɔlma-na, banamba taa ba hel Sirɛni, banamba Alɛsãndiri, banamba Silisi, banamba *Asi. ");
INSERT INTO cmeNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","*Diiloŋ-Yalle naa waa baa Etiɛni a ce ba saa gbãa piiye yar-o. ");
INSERT INTO cmeNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Kuŋ nuɔlaa-ba, ba bir yaŋ aa biɛ nuɔmba gbeiŋa-na ba ta ba wuɔra ba waŋ wuɔ: «Naacolŋ daayo u wuɔra u tuora *Moisi‑i baa Diiloŋo‑i; baaŋo sĩ.» ");
INSERT INTO cmeNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ba ciɛ ku yaa‑i nuɔmba hɔmmu du baa Etiɛni‑i nelle-na. Bĩncuɔmba‑i baa *ãnjĩnamma pigãataamba‑i hiere ba hɔmmu duu baa-yo. Baŋ ciɛ kufaŋgu‑i, ba kã ka bel-o kã baa-yo *nellentaamba wulaa. ");
INSERT INTO cmeNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Baŋ kãa baa-yo, ba tiraa bĩ coikartaamba namba kã, wuɔ siɛrtaamba. Baa kã ka ta ba kar coima‑i ba haa-yuɔ wuɔ: «Naacolŋ daayo sa gbuu piiye *Diilodubuɔ yefafalle, halle baa *ãnjĩnamma‑i hiere. ");
INSERT INTO cmeNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","I daa u wuɔra u piiye wuɔ Nasarɛtitaaŋ Yesu ka muonu Diilodubuɔ‑i aa bir Moisi nelma‑i birma namma.» ");
INSERT INTO cmeNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Bamaŋ waa hiere gɛ̃ŋgɛrterieŋgu-na, baa dĩŋ-yuɔ ta ba ne-yo. U yaaŋga taa ka caa ŋaa *dɔrpɔpuɔrbiloŋ yaaŋga. ");
INSERT INTO cmeNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Siɛrtaambaŋ juɔ piiye tĩ, *Diilojigãntaamba yuntieŋ wuɔ yuu Etiɛni‑i wuɔ: «Baŋ waŋ mamaŋ ninsoŋo wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Etiɛni wuɔ cira: «Mi nelleŋ-tobiŋ namaa, baa mi tobaa namaa, mi ka waŋ nelma diei baa-na: Na suyaa wuɔ aa i bĩncɔiŋo‑i *Abiramu suɔ duɔ sire Mesopotami‑i-na ka tĩɛna Arã‑i-na, Cagaaŋ-Diiloŋo naa carra-yuɔ ");
INSERT INTO cmeNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","a waŋ baa-yo wuɔ u yaŋ u huraamba‑i aa u sire ba jãmalã‑i-na, kɛrɛ u ka pigãaŋ-yo jãmalã naŋo u ka tĩɛna. ");
INSERT INTO cmeNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Abiramu sire ka tĩɛna Arã‑i-na. Uŋ kãa terieŋgu-na, u toŋ juɔ ku, Diiloŋo ce u jo ji tĩɛna naŋ yeŋ jãmalã maŋ nuɔ‑i daayo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","«Uŋ juɔ, Diiloŋo saa hã-yo munturemmu aa bi cira mu yaa daamu. U yaaŋ aa pã nuŋgu baa-yo wuɔ: ‹Mi ka hã-ni jãmalã daayo‑i. Da ŋ saa ji waa, ŋ huoŋ-baamba ka biɛ-yo cor.› A ne da huɔŋgu faŋgu-na, bilo saa waa baa Abiramu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Diiloŋo gbɛ̃-yo wuɔ: ‹Ŋ huoŋ-baamba ka waa juɔma-na, ba ka bel-ba kɔrsĩnni-na jãmalã faŋo-na gbuu mulĩɛŋ-ba. Ba ka ce bieŋ nuɔsiba hãi mulĩɛma. ");
INSERT INTO cmeNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ŋga bamaŋ ka bel-ba kɔrsĩnni-na, muɔmɛi ka pã kutaamba‑i mi fɛrɛ. Da mi ji ce mafamma‑i, ŋ hãayɛ̃lmba ka suɔ sire terieŋgu-na ji tĩɛna bande ta ba buol-mi.› ");
INSERT INTO cmeNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","«Uŋ waaŋ mafamma‑i, wuɔ bel *tobisĩnni baa Abiramu‑i aa naa ce u *jã a dãnya tobisĩnni fanni‑i. Ku'i ciɛ na da *Isakiŋ juɔ hoŋ, yinni niehãi cor, niisiɛi yiiŋgu-na, Abiramu jã-yo. Isakiŋ bi siire da *Yakɔbu‑i, u bi jã-yo. Yakɔbu bi sire ce maaduɔma baa i bĩncuɔmba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","«I bĩncuɔmba sire bigãaŋ ba hãaŋo‑i Yosɛfu‑i aa bel-o suor-o ba sãa-yo kã baa-yo Esipi. Ŋga Diiloŋo waa baa Yosɛfu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","U hielaa u yuŋgu‑i mulĩɛma-na hiere aa ce-yo nelnurãŋo aa tiraa ce u kũŋgu dɔlnu Esipitaaŋ jãmatigi‑i. Jãmatigi haa-yo u jãmalã yuŋ-nu baa u dumɛlle bi yuŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","«Nyulmu nammu ji suur Esipi‑i-na, ka hel baa *Kanaa jãmalã‑i hiere. Kuu naa balaŋ cor, a ce i bĩncuɔmba sa da niiwuoni ba wuo dii Kanaa‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Yakɔbu ji nu wuɔ ba suor dĩmma dii Esipi‑i-na. U puɔr i bĩncuɔmba kã ka sãa bir kũŋ. ");
INSERT INTO cmeNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","«Baŋ juɔ kã hãalĩŋo‑i, Yosɛfu pigãaŋ-ba u fɛrɛ wuɔ fuɔ yaa Yosɛfu‑i. Terieŋgu faŋgu'i nuɔ‑i, jãmatigiŋ suyaa Yosɛfu baamba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Yosɛfu wuɔ ce u mɔlbaa-ba bir kũŋ ka jo baa tuoŋo‑i baa u dumɛlleŋ-baamba‑i hiere. Ba kũŋgu-na, ba waa nuɔmba komuɔŋa siɛi baa cĩncieluo nuɔmba ndii. ");
INSERT INTO cmeNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yakɔbu kãa kãmma famma yaa‑i Esipi‑i-na. Diiloŋ-babĩmuɔ kaa hi-yo kusuɔŋ-nu'i baa i bĩncuɔmba‑i hiere. ");
INSERT INTO cmeNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ba waa umaŋ duɔ ku, ba biɛ-yo ka fuure-yuɔ Sisɛmu. Ba fuuriiye-bɛi Abiramuŋ sãa cĩncorre maŋ Amɔr bisãlmba wulaa. ");
INSERT INTO cmeNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","«Diiloŋ uŋ pãa nuŋgu maŋ baa Abiramu‑i, ku cemmaŋ-huɔŋguŋ juɔ ta ku piɛ, miɛ baamba sire gbuu ciinu Esipi‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Jãmatigi naŋo ji nyugũŋ. Jãmatigi faŋo saa tuɔ suɔ Yosɛfu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Wuɔ fũnuŋ tuɔ ce karaaŋgu baa i bĩncuɔmba‑i. U waa ciɛŋo maŋ duɔ hoŋ u biloŋo‑i, u bel diiloŋo‑i ce u nanna-yuɔ u kaal ji ku. ");
INSERT INTO cmeNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","*Moisi huɔŋ huɔŋgu faŋgu'i nuɔ‑i. U maama saa naa fa baa fafaaŋgu‑i. Uŋ huɔŋ, u bĩncuɔmba gbãaŋ fuo-yo ba dũŋgu-na u ce caamba siɛi yoŋ baa-ba. ");
INSERT INTO cmeNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Baŋ juɔ suɔ baa-ba aa ce ba biɛ-yo ka nanna, jãmatigi biloŋ wuɔ biɛ-yo ce-yo ŋaa fuɔ bilohoiŋo, a fiɛ-yo u ji vãa. ");
INSERT INTO cmeNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ku ciɛ dumɛi Moisi suɔ Esipitaamba ãncemma‑i hiere. U taa u nu nelma‑i ŋaa u yuŋgu ka muonu aa wɛima saa ta ma yar-o cemma. ");
INSERT INTO cmeNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","«Uŋ juɔ da bieŋ komuɔŋa hãi, wuɔ kã duɔ ka ne u nelleŋ-baamba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Yiiŋgu naŋgu-na, wuɔ ji da Esipiyiɛŋo naŋo ce ba wuoŋo naŋo‑i sũlma. Wuɔ hũu naacolŋo‑i aa naa muo Esipiyiɛŋo‑i ko-yo. ");
INSERT INTO cmeNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","U taa u taara u ce u nelleŋ-baamba suɔ wuɔ Diiloŋo ciɛ u'i jo duɔ ji kor-ba. Ŋga ba saa suɔ-ma. ");
INSERT INTO cmeNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","«Ku cuo kaala‑i-na, wuɔ da ba baamba namba gãŋ. Wuɔ karnu-bɛi aa naa tuɔ piiye baa-ba wuɔ: ‹Bige‑i ciɛ na ta na gãŋ, ma sĩ namɛi kuuduɔŋgu?› ");
INSERT INTO cmeNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Umaŋ taa u jĩnya u nawuoŋo‑i wuɔ sɛ Moisi‑i da yɛr, aa naa cira: ‹Hai moloŋo‑i diyaa naŋ nuŋgu‑i? ");
INSERT INTO cmeNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ŋ taara da ŋ ko-mi ŋaa niŋ kuɔ Esipiyiɛŋo‑i dumaa cicuɔŋgu-na wɛi?› ");
INSERT INTO cmeNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Uŋ piiye dumaaŋo-na, Moisi saa gbãa duɔ tiraa tĩɛna; wuɔ gbar ka tĩɛna Madiyã. U kaa biɛ ciɛŋo‑i kusuɔŋ-nu'i a hoŋ bisãlmba hãi baa-yo. ");
INSERT INTO cmeNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","«Bieŋ komuɔŋa hãi cor. Yiiŋgu naŋgu-na, *dɔrpɔpuɔrbiloŋo naŋo carra Moisi‑i dii *hĩɛkuraaŋgu-na Sinayi tãnuŋgu hɔlma-na. Wuɔ u ne da bige‑i daaku‑i? Dãamu'i caaŋ tibiyelle nande‑i aa dɔrpɔpuɔrbiloŋo waa dii mu huɔŋga-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Kuɔ cu u huɔŋga‑i. Wuɔ ta tuɔ piɛ duɔ ka ne dãamu fammu‑i dɛi. Wuɔ u ne da Itieŋo piiye baa-yo wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‹Moisi, ŋ bĩncuɔmba Diiloŋo yaa muɔŋo‑i: Abiramu siire wuɔ mɛi hũmelle yaa‑i, Isaki‑i baa Yakɔbu‑i hiere maaduɔma.› Moisi kũɔma pãŋ ta ma nyɛŋ, a ce u saa tiraa siɛ duɔ ne terieŋgu faŋgu yaŋga-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Itieŋo gbɛ̃-yo wuɔ: ‹Hiel naatɛnni‑i ŋ gbeini-na; niŋ yeŋ terieŋgu maŋ nuɔ‑i daaku‑i Diiloŋ-terieŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Mi baambaŋ ceŋ sũlma maŋ Esipi‑i-na, mi daa-ma; baŋ bireŋ, mi nuɔ, ku'i ciɛ mi hiire jo miɛ mi ji kor-ba. Jo mi ji puɔr-ni ba wulaa.› ");
INSERT INTO cmeNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","«*Isirahɛl-baambaŋ siɛ Moisi maŋ wuɔ u halaŋ, molo saa dii u nuŋgu ba bɛrru-na, Moisi duɔŋo faŋo yaa Diiloŋ uŋ ciɛ dɔrpɔpuɔrbiloŋo jo ji puɔr-o wuɔ u ka waa ba yuŋ-nu aa hũu-ba Esipitaamba nyisɛ̃nni-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moisi yaa ciɛ himma‑i a hiel i bĩncuɔmba‑i Esipi‑i-na. U ciɛ-ma Esipi‑i-na, aa ce-ma dãmmaŋ-nuoradãama‑i-na aa tiraa ce-ma hĩɛkuraaŋgu-na duɔ gbãa kor-ba. U ciɛ kufaŋgu‑i bieŋ komuɔŋa hãi. ");
INSERT INTO cmeNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","«Moisi duɔŋo faŋo yaa gbĩɛ Isirahɛl-baamba‑i wuɔ Diiloŋo ka hiel ba nelleŋ-wuoŋo naŋo ce-yo u *pɔpuɔrbiloŋo fuɔ temma hã-ba. ");
INSERT INTO cmeNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Aa i bĩncuɔmbaŋ waa hĩɛkuraaŋgu-na, u yaa waa ba hɔlma-na baa Diiloŋo‑i. Dɔrpɔpuɔrbiloŋo taa u piiye baa u yaa‑i Sinayi tãnuŋgu-na u tuɔ kã u tũnu i bĩncuɔmba‑i. U yaa taa u jo baa cicɛ̃lmaŋ-nelma‑i u jo u waŋ-ma baa-ye. ");
INSERT INTO cmeNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","I bĩncuɔmba bir yaŋ ba sa nu u nuŋgu‑i. Ba cĩinaana-yuɔ aa ta ba taara ba bir kã Esipi‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","«Baŋ diyaa mafamma‑i ba hɔmmu-na, ba gbɛ̃ *Aarɔ̃‑i wuɔ: ‹Ce tĩnni ŋ hã-ye, nimaŋ ka kãyã-yiɛ i hi i muŋkãmmu‑i. Moisi hielaa-ye Esipi‑i-na, u yaa daayo i sa suɔ uŋ curaa kusuɔŋ-nu.› ");
INSERT INTO cmeNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Yibieŋa faŋa-na, baa sire kul nambiloŋo a ce-yo tĩiŋgu ta ba buol. Baŋ kulii nambiloŋo‑i, kuɔ silaa gbuu dɔlnu-bɛi ŋaa bige‑i! Baa ce ponsaaŋgu ma yerreŋ. ");
INSERT INTO cmeNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Diiloŋ wuɔ ne-ba aa yaŋ-ba ba ta ba buol mɔɛŋa baa cɛiŋo baa bãaŋgu ŋaa maŋ nyɛgãaŋ dumaa Diilopɔpuɔrbiemba sɛbɛ‑i-na wuɔ: ‹Isirahɛl-baaŋ namaa, naŋ ciɛ bieŋ komuɔŋa hãi maŋ hĩɛkuraaŋgu-na, na taa na ko niikonni‑i na hã muɔmɛi wɛi? Na taa na bi pã niipãnni‑i na hã muɔmɛi wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ma sĩ na birii yaŋ aa kul tĩnni ta na buol? Na saa tũu Molɔkidũŋgu‑i baa Erefãmɔɛle‑i ta baa-ni wɛi? Na ciɛ kɔlluŋ-nobimba famba‑i ta na buol-ba. Mi ka ce ba kã baa-na dii *Babilɔni huoŋ-nu.›» ");
INSERT INTO cmeNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Etiɛni wuɔ cor baa u ãndaaŋgu‑i wuɔ: «*Tobisĩnniŋ-dũŋgu waa baa i bĩncuɔmba‑i hĩɛkuraaŋgu-na. Diiloŋ-nelma waa ku yaa nuɔ‑i. Moisi ciɛ-ku ŋaa Diiloŋoŋ pigãaŋ-yo ku cemma‑i dumaa. ");
INSERT INTO cmeNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ku huoŋgu-na, i bĩncuɔmba huoŋ-baamba ji wuo dũŋ daaku ciiluŋgu‑i. Yosuwe yaa waa ba yaaŋga-na. Diiloŋ wuɔ kãyã-bɛi ba donya nuɔmba maŋ waa hiere jãmalã daayo-na aa biɛ dũŋ daaku‑i ji tĩɛna baa-ku. Ku tĩyãa dumɛi ji hi *Davidi bãaŋgu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Diiloŋo taa u ce baa Davidi‑i u cor; Davidi wuɔ cãrã hũmelle‑i u wulaa wuɔ u yaŋ u ma ninsoŋ-dũŋgu hã-yo *Isirahɛl-baamba ta ba jo ba jaal-o kuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Dũŋgu faŋgu‑i, *Salomɔ'i juɔ ma-ku hã Diiloŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ŋga Dɔrwuoŋo sa cɔ dũŋ-nu ŋaa Diilopɔpuɔrbiloŋ uŋ waaŋ-ma dumaa wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‹Itieŋo ciɛra wuɔ: «Dɔrɔ yaa mɛi fɔ̃ŋgɔ̃tesĩnniŋ-teterre‑i. Mi ciɛ hĩɛma‑i ta mi haa mi gbeini. Namaa gbãa ma dũŋ haku‑i hã muɔŋo‑i? Mi munfiisammuŋ-terieŋgu yaa hie hĩɛma-na? ");
INSERT INTO cmeNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Bĩmbĩnni maŋ dii hiere, mɛi napɔrreŋ-niini'i sĩ wɛi?»›» ");
INSERT INTO cmeNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Etiɛni wuɔ cira: «Ãnyagarmantaaŋ namaa temma‑i daana‑i, Diiloŋo bĩɛ-na ji gbɛ̃! Na sa siɛ *Diiloŋ-Yalle wulaa. Na biyaa na bĩncuɔŋ-maama. ");
INSERT INTO cmeNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Diilopɔpuɔrbiloŋ hayo‑i siire aa na bĩncuɔmba saa ce-yo sũlma? Halle bamaŋ siire piiye Nelviiŋo jommaŋ-kũŋgu‑i, na bĩncuɔmba kuɔ-ba. Fiɛfiɛ‑i-na Nelviiŋ uŋ juɔ, namaa na hel u huoŋ-nu aa bel-o ko-yo. ");
INSERT INTO cmeNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ŋ siɛ suɔ wuɔ Diiloŋo puɔraa dɔrpɔpuɔrbiemba ji hã namɛi baa u *ãnjĩnamma‑i, na yaŋ aa hũu-ma nanna.» ");
INSERT INTO cmeNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Etiɛniŋ piiye dumaaŋo-na, u piiye suur *nellentaamba-na. Baa pãŋ pu baa-yo. ");
INSERT INTO cmeNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","A ne da *Diiloŋ-Yalle naa yu u huɔŋga‑i. Wuɔ tã u yuŋgu‑i tuɔ ne dɔrɔ. Wuɔ u ne da Diiloŋo yaaŋga caa da kpoikpoi aa da Yesu yiɛraaya Diiloŋo caaŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Wuɔ cira: «Niɛŋ, dɔrɔ puurii, aa *Moloŋ-Biɛŋo yaa yiɛraaya daayo Diiloŋo caaŋgu-na!» ");
INSERT INTO cmeNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Baa pãŋ suunu ba tũnni‑i aa naa ta ba kaasĩŋ, aa kã ka yu-yuɔ bel-o. ");
INSERT INTO cmeNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Baŋ bilaa-yo, baa hel baa-yo nelleŋ-huɔŋga-na, kã baa-yo kɔtuɔŋgu ka ta ba naŋ-yo baa tãmpɛ̃lɛ̃iŋa da ba ko-yo. Naacombiloŋo naŋo waa baa-ba, ba taa ba bĩ-yo Sol. Siɛrtaaŋ baa hielaa ba joŋgorbaa-ba‑i hã u yaa tuɔ niya-bɛi aa kã ka ta ba naŋ Etiɛni‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Baŋ naŋ-yoŋ dumaaŋo-na, wuɔ ji cira: «Yesu, Itieŋ nuɔ, hũu-mi.» ");
INSERT INTO cmeNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Uŋ waaŋ mafamma‑i, wuɔ dũuna aa naa piiye da gbagaga wuɔ: «Itie, baa ne baŋ ceŋ kumaŋ.» Uŋ waaŋ mafamma‑i, wuɔ cii, u kuliiŋgu yaa dumaaŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Etiɛni kuliiŋgu dɔlaanu Sol ŋaa bige‑i! Etiɛniŋ kuu yiiŋgu maŋ nuɔ‑i, baa sire suuye Diiloŋ-dũŋ-baamba‑i *Yerusalɛmu‑i-na. Baa pisãllã hiere; banamba ta ba kã *Yude, banamba *Samari aa naa yaŋ Yesu *pɔpuɔrbiemba yaa yoŋ. ");
INSERT INTO cmeNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Nelfafaamba namba biɛ Etiɛni‑i ka fuure aa ce mamaŋ waa cemma hiere u kuliiŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sol wuɔ gbuu faya u fɛrɛ tuɔ ce karaaŋgu‑i baa Diiloŋ-dũŋ-baamba‑i: U taa u wuɔra cĩnni-na u bel caamba‑i baa bɛmba‑i hiere u kã u dii-ba kaso. ");
INSERT INTO cmeNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Diiloŋ-dũŋ-baamba maŋ gbaraa pisãllã, ba taa ba wuɔra ba waŋ *Neldɔdɔlma‑i nilɛiŋa-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipu wuɔ kã ka hel *Samari nelle nande-na, a doŋ tuɔ piiye *Koŋkortieŋo maama‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","U bi taa u ce gbɛrɛ-wɛima ba hɔlma-na. U waa duɔ waŋ mamaŋ, u ce-ma nuɔmba yufelle-na. A ce dumaaŋo-na duɔ tuɔ piiye, ba kar ba tũnni‑i fafamma ta ba nu. ");
INSERT INTO cmeNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","U duɔnya *jĩnabaa bɔi nuɔmba-na. Duɔ donya umaŋ, u kaasĩŋ da gbagaga aa hel. U bi siire murgubaa bɔi baa jaamba bɔi. ");
INSERT INTO cmeNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Kuɔ gbuu fũnuŋ dɔlnu nuɔmba‑i nelle fande-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","A ne da hiroŋo naŋo waa nelle fande-na, ba taa ba bĩ-yo Simɔ. Simɔ himma naa ce *Samaritaamba‑i gbɛrɛ, a ce dumaaŋo-na u saa tuɔ jĩna u fɛrɛ kpaga. ");
INSERT INTO cmeNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Bĩncuɔmba‑i baa bisãlmba‑i hiere, ba taa ba kãalã-yuɔ. Ba taa ba piiye wuɔ: «Diiloŋ-himma yaa dii baa naacolŋ daayo‑i, baŋ bĩŋ mamaŋ ‹ninsoŋ-himma‑i›.» ");
INSERT INTO cmeNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Simɔ naa da yinni baa u himma cemma‑i ba hɔlma-na, ku'i ciɛ ba ta ba kãalã-yuɔ kãalãŋ daama temma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Filipuŋ juɔ kã ka waŋ *Diiloŋ-bãaŋgu maama‑i baa Yesu-Kirsa maama‑i, caamba‑i baa bɛmba‑i hiere baa hũu Neldɔdɔlŋ daama‑i aa naa ce ba *batiseŋ-ba. ");
INSERT INTO cmeNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simɔ fuɔ fɛrɛ wuɔ bi hũu-ma aa ce ba *batiseŋ-yo. Baŋ baatiseŋ-yo, wuɔ pãŋ nyaarãa Filipu‑i. Filipu himma bir yaŋ aa ta ma ce fuɔ fɛrɛ‑i gbɛrɛ. ");
INSERT INTO cmeNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Yesu *pɔpuɔrbiembaŋ juɔ nu-ma dii *Yerusalɛmu‑i-na wuɔ Samaritaamba hũyãa Diiloŋ-nelma‑i, baa saaŋ Piɛr‑i baa Nsãa‑i ba wulaa. ");
INSERT INTO cmeNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Piɛr‑i baa Nsãa‑i baŋ kãa, baa cãrã Diiloŋo‑i hã-ba wuɔ u hã-ba u *Yalle‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Huɔŋgu faŋgu-na, Samaritaamba saa naa hi da *Diiloŋ-Yalle‑i yogo. Baa baatiseŋ-ba yaa yoŋ. ");
INSERT INTO cmeNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ku'i ciɛ Piɛrbaa-baŋ kãa, baa haa ba nammu‑i ba yunni-na a cãrã Diiloŋo hã-ba u Yalle‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simɔ daa mafamma‑i ce bige‑i? Wuɔ hiel gbeiŋa duɔ hã Piɛrbaa-ba‑i. Aa naa cira: ");
INSERT INTO cmeNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","«Hãaŋ-muɔ baa hiŋ daama‑i; da mi haa mi nammu‑i umaŋ nuɔ‑i, kutieŋo da Diiloŋ-Yalle‑i!» ");
INSERT INTO cmeNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Piɛr wuɔ cira: «Simɔ, ŋ daa niɛ sĩ ba sãa Diiloŋ-caluɔ‑i baa gbeiŋa wɛi? Niŋ diyaa mafamma‑i ŋ huɔŋga-na, mi waasaaŋ-ni baa ŋ gbeiŋa‑i hiere. ");
INSERT INTO cmeNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ŋ saa koŋ baa Diiloŋo‑i. Ŋ siɛ gbãa da bĩŋkũŋgu bande‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Hiel nel daama‑i ŋ huɔŋga-na, ma saa fa, aa ŋ cãrã Itieŋo‑i si u ka ce jande niɛ. ");
INSERT INTO cmeNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Mi niɛ da ŋ balaaŋ cor, aa da *Sitãni taa yaaŋga niɛ.» ");
INSERT INTO cmeNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Uŋ piiye dumaaŋo-na, Simɔ wuɔ gbɛ̃-ba wuɔ: «Namaa fɛrɛ‑i, cãarãŋ Itieŋo‑i na hã-mi, wuɔ naŋ waaŋ mamaŋ daama‑i, u baa yaŋ ma da-mi.» ");
INSERT INTO cmeNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Piɛrbaa-baŋ juɔ waŋ Itieŋo melma‑i tĩ, baa bir kã Yerusalɛmu‑i-na. Ba taa ba waŋ Neldɔdɔlma‑i Samari nilɛiŋa bɔi-na ba kã. ");
INSERT INTO cmeNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Yiiŋgu naŋgu-na, Itieŋo *dɔrpɔpuɔrbiloŋo ji waŋ baa Filipu‑i wuɔ: «Sire ŋ ka biɛ hũmelle maŋ hilaa *Yerusalɛmu‑i-na ta di kã Gasa‑i-na. Hũmelle fande‑i nuɔmba sa biɛ-de dumaa.» ");
INSERT INTO cmeNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Filipu wuɔ sire ta, u saa sɛrɛ. Uŋ biyaa hũmelle‑i tuɔ kã, wuɔ fara da wotortieŋo naŋo kã u yaaŋga-na. Fãamaaŋo naŋo'i waa u huɔŋga-na. U taa u hel Etiyopi. Jãmatigi maŋ waa Etiyopi‑i-na ba ta ba bĩ-yo Kãndasi, u yaa waa u nagãŋ-niini yuŋgu-na. Wuɔ juɔ Yerusalɛmu‑i-na ji jaal Diiloŋo ");
INSERT INTO cmeNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","aa bir tuɔ kũŋ. U taa u kalaŋ *Isayi sɛbɛ‑i u kũŋ. ");
INSERT INTO cmeNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","*Diiloŋ-Yalle gbɛ̃ Filipu‑i wuɔ: «Gbãana ŋ ka hi wotortieŋ daayo‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filipu wuɔ gbar ka hi-yo. Uŋ hii, wuɔ da u kalaŋ *Isayi sɛbɛ. Wuɔ yuu-yo wuɔ: «Niŋ kalaŋ mamaŋ, ŋ suɔ-ma wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Naacolŋ wuɔ cira: «Molo duɔ saa hielnu-mɛi baa-mi, mi siɛ gbãa suɔ-ma.» Aa naa ce Filipu nyugũŋ tĩɛna u caaŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Uŋ taa u kalaŋ terieŋgu maŋ, ku yaa daaku: «Ba ciɛ-yo sũlma u saa ji puur u nuŋgu‑i waŋ wɛima ŋaa tũmaaŋo. Ba bilaa-yo da ba ka ko-yo wa, ba bilaa-yo ta ba karra u kuɔsĩnni‑i wa, u sa waŋ wɛima. ");
INSERT INTO cmeNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ba ciɛ-yo nelsɔsɔiŋo aa hũu ninsoŋo‑i u wulaa. Baŋ kuɔ-yo, u ka ce niɛ da huoŋgu molo duɔ ji waŋ ku maama?» ");
INSERT INTO cmeNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Naacolŋ wuɔ yuu Filipu‑i wuɔ: «*Diilopɔpuɔrbiloŋo piiye hai maama‑i dumandɛ‑i? U piiye fuɔ maama waa u piiye unaŋ maama?» ");
INSERT INTO cmeNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Filipu wuɔ suur nelma yaaŋga-na, a doŋ tuɔ piiye Yesu *Neldɔdɔlma‑i baa-yo. ");
INSERT INTO cmeNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Baŋ kaa hi yaaŋga‑i, baa da hũmma namma. Naacolŋ wuɔ cira: «Hũmma namma yaa daama, ŋ sa *batiseŋ-mi wɛi?»  ");
INSERT INTO cmeNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filipu wuɔ cira: «Da kuɔ ŋ hũyãa Yesu maama‑i hĩŋ, mi gbãa batiseŋ-ni, wɛima si dii.» Naacolŋ wuɔ cira: «Mi hũyãa-ma wuɔ Yesu-Kirsa yaa Diiloŋ-Biɛŋo‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Aa naa ce ba yiɛra. Baŋ yiɛraaya, baa hiire ba hãi‑i-na suur hũmma-na, Filipu wuɔ batiseŋ-yo. ");
INSERT INTO cmeNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Baŋ hilaa, naacolŋo huɔŋga gbuu fɛ̃. Wuɔ u ne naa Filipu‑i; Diiloŋ-Yalle biyaa-yo ta baa-yo. Ku saa ce-yo bĩŋkũŋgu; wuɔ cor baa hɔfɛ̃lle‑i tuɔ kũŋ. ");
INSERT INTO cmeNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filipu juɔ'a u suɔ da u fɛrɛ Asɔti. Wuɔ cor tuɔ waŋ Neldɔdɔlma‑i nilɛiŋa-na hiere u kã. U ciɛ dumɛi fuɔ ka hi Sesare. ");
INSERT INTO cmeNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","A ne da huɔŋgu faŋgu-na, Sol waa yogo u sa taara u da Itieŋo baamba‑i baa u yufelle, wuɔ duɔ hi umaŋ, u ko-yo. Yiiŋgu naŋgu-na, wuɔ ji sire kã *Diilojigãntaamba yuntieŋo wulaa, ");
INSERT INTO cmeNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","wuɔ u ce sɛbɛbaa hã-yo, u kã Damasi *Diilonelhãalãdũnni-na, wuɔ ba hã-yo hũmelle‑i duɔ da bamaŋ suurii Itieŋo hũmelle-na; caamba‑i ka hel baa bɛmba‑i hiere, u bel-ba jo baa-ba *Yerusalɛmu‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Diilojigãntaamba yuntieŋo ce sɛbɛbaa-ba‑i hã u ta. Uŋ kaa tuɔ piɛ Damasi‑i, wuɔ u ne da cecerma naŋ temma hilaa dɔrɔ‑i-na jo ji dii-yo huɔŋga. ");
INSERT INTO cmeNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Wuɔ pãŋ hel cii. Uŋ cii dumaaŋo-na, wuɔ nu molo piiye baa-yo wuɔ: «Sol, bige‑i ciɛ ŋ ta ŋ ce karaaŋ daaku temma‑i baa-mi?» ");
INSERT INTO cmeNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Wuɔ yuu wuɔ: «Hai moloŋo'i?» Kutieŋ wuɔ cira: «Muɔ Yesu. Ŋ ce karaaŋgu‑i baa muɔmɛi. ");
INSERT INTO cmeNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Sire ŋ perieŋ ŋ suur nelle-na; mamaŋ dii cemma, da ŋ suur ba ka waŋ-ma baa-ni.» ");
INSERT INTO cmeNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Nuɔmba namba waa baa Sol‑i, bafamba bi nuɔ moloŋ daayo piiye, da ba ne, ba siɛ da-yo. Baa yiɛra kar da hãmmu! ");
INSERT INTO cmeNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sol wuɔ sire. Duɔ puur u yufieŋa‑i, u siɛ da bĩŋkũŋgu. Baa bel u naŋ-na, a perieŋ suur baa-yo Damasi‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","U ciɛ yinni siɛi aa u yufieŋa suɔ da a puur. Yiŋ daani‑i ni siɛi‑i-na, u saa dii bĩŋkũŋgu u nuŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","A ne da Itieŋo wuoŋo naŋo waa Damasi‑i-na, ba taa ba bĩ-yo Ananiyasi. Itieŋ wuɔ carra-yuɔ aa naa cira: «Ananiyasi!» Ananiyasi wuɔ cira: «Mi siyaa.» Itieŋ wuɔ cira: ");
INSERT INTO cmeNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","«Sire mi puɔr-ni naacolŋo naŋo wulaa, ba bĩ-yo Sol; u hel Tarse. U haraa Yuda dumɛlleŋ, dii hũmelle maŋ baŋ bĩŋ-deŋ Hũmeviile‑i di tũŋgu-na. Dumandɛ‑i-na, uu dii tuɔ cãrã Diiloŋo‑i, ");
INSERT INTO cmeNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","aa u daa ŋ kãa u wulaa dii dũŋgu-na ka haa ŋ nammu‑i yuɔ a cãrã Diiloŋo‑i u yufieŋa da a puur.» ");
INSERT INTO cmeNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananiyasi wuɔ cira: «Itie, nuɔmba bɔi waaŋ naacolŋ daayo maama baa-mi. Bamaŋ cuu ŋ huoŋ-nu Yerusalɛmu‑i-na, uŋ haa kumaŋ bɛi, mi nuɔ-ku. ");
INSERT INTO cmeNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Niŋ daa uŋ juɔ bande‑i-na, *Diilojigãntaamba yuntaamba'i hãa-yo hũmelle‑i u duɔ ji bel bamaŋ gbuusiiŋ ŋ yerre‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Itieŋ wuɔ cira: «Yaŋ aa ŋ kã, mi hielaa naacolŋ daayo‑i u duɔ pigãaŋ *niɛraamba‑i mi sĩnni‑i, aa bi pigãaŋ nellentaamba‑i baa-ni, baa *Isirahɛl-baamba‑i hiere. ");
INSERT INTO cmeNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Uŋ ka mulĩɛŋ dumaa mi maama-na, mɛi fɛrɛ yaa ka pigãaŋ-yo baa-ku.» ");
INSERT INTO cmeNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Uŋ juɔ piiye dumaaŋo-na, Ananiyasi wuɔ sire ta kã Yuda cĩiŋgu-na ka haa u nammu‑i Sol-na aa naa cira: «Sol, Itieŋo yaa puɔraa-mi ŋ wulaa wuɔ mi ji puur ŋ yufieŋa‑i aa yu ŋ huɔŋga‑i baa *Diiloŋ-Yalle‑i. Ba bĩ-yo Yesu. Niŋ taa ŋ jo hũmelle-na u yaa caraaya-niɛ.» ");
INSERT INTO cmeNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Uŋ bi waaŋ mafamma‑i, ninanni nanni yer u yufieŋa-na ŋaa tetefuoru a diire. U yufieŋa pãŋ puur. Wuɔ pãŋ sire baa *batiseŋ-yo. ");
INSERT INTO cmeNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ku huoŋgu-na, wuɔ wuo niiwuoni‑i a da fɔ̃ŋgũɔ. Sol yufieŋaŋ puurii, wuɔ tĩɛna Damasi‑i-na ce yinni cɛllɛ baa Yesu baamba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Uŋ tĩɛnaana, wuɔ doŋ tuɔ waŋ Yesu maama‑i Diilonelhãalãdũnni-na, wuɔ Yesu yaa Diiloŋ-Biɛŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Kuɔ cu nuɔmba hɔmmu‑i. Baa ta ba yuu ba-naa wuɔ: «Bamaŋ taa ba gbuuse Yesu yerre‑i Yerusalɛmu‑i-na, naacolŋ daayo'i saa tuɔ huol ba yammu‑i wɛi? Ku baa ji waa u suyaa u fɛrɛ jo duɔ ji bel-ba ka hã Diilojigãntaamba yuntaamba yaa baa-ba?» ");
INSERT INTO cmeNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Baŋ fiɛ ba waŋ mafamma‑i, Sol kũɔma saa kara; yinniŋ cor dumaa, kunaŋgu'i suuriiŋ-yuɔ ku naara. Duɔ biɛ tagaaya pigãaŋ wuɔ Diiloŋ uŋ saaŋ *Koŋkortieŋo maŋ, u yaa Yesu‑i, *Yuifubaa-ba maŋ Damasi‑i-na ba siɛ da nelma waŋ. ");
INSERT INTO cmeNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ku huoŋgu-na, Yuifubaa-ba ji saa-ma wuɔ ba ko-yo. ");
INSERT INTO cmeNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Baŋ puu mafamma‑i, baa ta ba niya nelle munsuurmu‑i bãaŋgu‑i baa isuɔŋgu‑i. Sol wuɔ nu-ma wuɔ ba'a ba ko-yo. ");
INSERT INTO cmeNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Isuɔŋgu naŋgu-na, bamaŋ waa u huoŋgu-na, baa dii-yo sãmbaga nuɔ a hiire-yuɔ jĩna nelle huoŋ-yaŋga-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Baŋ hiiriiye Sol jĩna nelle huoŋgu-na, wuɔ ta bir kã *Yerusalɛmu‑i-na. Uŋ kãa ka hi, wuɔ kã Diiloŋ-dũŋ-baamba wulaa. Baa bir yaŋ aa ta ba kãalã-yuɔ. Baa sa hũu-ma wuɔ u hũyãa Yesu maama‑i ninsoŋo. ");
INSERT INTO cmeNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Barnabasiŋ daa ba kãalã-yuɔ dumaaŋo-na, wuɔ kã baa-yo Yesu *pɔpuɔrbiemba wulaa. Baŋ kãa, Itieŋ uŋ caraaya-yuɔ dumaa Damasi hũmelle-na a piiye baa-yo, Barnabasi wuɔ suur ma yaaŋga-na hiere a waŋ-ma baa-ba, aa uŋ bi daa holle‑i dumaa a waŋ Yesu maama‑i Damasi‑i-na, wuɔ bi waŋ mafamma‑i baa-ba. ");
INSERT INTO cmeNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","A doŋ huɔŋgu faŋgu-na, Sol wuɔ ce ba wuɔratieŋo: U taa u wuɔra baa-ba Yerusalɛmu huɔŋga-na u waŋ Itieŋo maama‑i. Uu naa fɛ̃ u huɔŋga‑i baa ma wamma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ba taa ba bi fanu ba-naa baa *Yuifubaa-ba maŋ piiyeŋ girɛkimma‑i, a ce bafamba ta ba taara-yuɔ baa komma. ");
INSERT INTO cmeNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Diiloŋ-dũŋ-baambaŋ juɔ nu wuɔ ba taara-yuɔ baa komma, baa saaŋ-yo ba kã Sesare, ka ce u cor kã Tarse. ");
INSERT INTO cmeNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Huɔŋgu faŋgu-na, Diiloŋ-dũŋ-baamba waa ba fɛrɛŋ nuɔ *Yude‑i-na, baa *Galile‑i-na, baa *Samari‑i-na hiere. Kunaŋgu taa ku naara ba Diiloŋ-hũmelleŋ-kũŋgu-na. Ba taa ba siɛ Itieŋo wulaa aa *Diiloŋ-Yalle naa ce ba ta ba ciinu ba kã. ");
INSERT INTO cmeNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Piɛr fuɔ taa u wuɔra terni-na hiere u waŋ Diiloŋ-nelma‑i. Yiiŋgu naŋgu-na, wuɔ ji kã Lida duɔ ka ne Diiloŋ-dũŋ-baamba maŋ waa terieŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","A ne da murgu naŋo waa nelle fande-na, ba taa ba bĩ-yo Ene. U bieŋ niisiɛi waa belle fande-na u sa gbãa sire. ");
INSERT INTO cmeNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Piɛr wuɔ kã ka da-yo. Wuɔ cira: «Ene, Yesu-Kirsa siire-niɛ! Sire ŋ pĩŋ ŋ figĩiŋgu‑i ŋ jĩna.» Ene wuɔ bi pãŋ yiiye sire. ");
INSERT INTO cmeNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Uŋ siire dumaaŋo-na Lidataamba da-yo, baa pãŋ hũu Itieŋo maama‑i baa Sarɔ̃taamba‑i hiere. ");
INSERT INTO cmeNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Diiloŋ-dũŋ-wuoŋo naŋo waa Yope‑i-na, ba taa ba bĩ-yo Tabita, Girɛkibaa ba'a Dɔrkasi. Ku yuŋgu yaa wuɔ yɔrɔŋo. U waa ciɛŋo. Uu naa firnu u naŋga‑i cor baa nuɔmba‑i. U taa u kãyã sũntaamba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Piɛrŋ waa yibieŋa maŋ nuɔ‑i Lida‑i-na, Dɔrkasi wuɔ cii jarma-na a ji yii ji ku. Baa cɛ-yuɔ hũmma‑i aa biɛ-yo ka galla-yuɔ dũŋgu naŋgu-na. Dũŋgu faŋgu waa dɔrɔ. ");
INSERT INTO cmeNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lida‑i baa Yope‑i ni saa gbãa da hɔlma baa ni-naa, a ce dumaaŋo-na, Diiloŋ-dũŋ-baamba naa nu-ma Yope‑i-na wuɔ Piɛr juɔ ji waa dii Lida‑i-na. Baa puɔr nuɔmba hãi u wulaa wuɔ ba ka cãrã-yuɔ u jo donduo. ");
INSERT INTO cmeNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pɔpuɔrbiembaŋ kãa ka hi, baa waŋ ma yaaŋga‑i baa Piɛr. Piɛr saa tiraa tĩɛna; wuɔ kã ba gbonu ta ba jo Yope‑i-na. Baŋ juɔ ji hi, baa nyugũŋ baa Piɛr kuloŋ uŋ waa dũŋgu maŋ nuɔ‑i. Bikulcaamba sire baa kaaluŋgu‑i jo ji ta ba pigãaŋ Piɛr kuloŋ uŋ waa baa-ba aa nyɛ joŋgorbaa-ba maŋ hã-ba. ");
INSERT INTO cmeNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Piɛr wuɔ ce nuɔmba hel hiere dũŋgu-na aa wuɔ dũuna cãrã Diiloŋo‑i. Uŋ juɔ cãrã tĩ, wuɔ bir u yaaŋga‑i kuloŋo-na aa naa cira: «Tabita, sire!» Kuloŋ wuɔ puur u yufieŋa‑i. Uŋ puurii u yufieŋa‑i da-yo, wuɔ sire tĩɛna. ");
INSERT INTO cmeNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Piɛr wuɔ bel u naŋ-na u sire u gbeiniŋ. Uŋ siire, wuɔ bĩ Diiloŋ-dũŋ-baamba‑i baa bikulcaamba‑i ji pigãaŋ-ba baa-yo. ");
INSERT INTO cmeNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Nel daa maa sire gbuo Yope‑i hiere, a ce dumaaŋo-na, Yopetaamba fɔ̃ŋgũɔ baa hũu Itieŋo maama‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Piɛr wuɔ tĩɛna Yope‑i-na da huɔŋgu. U naŋ haraa naacolŋo maŋ nuɔ‑i, ba bĩ-yo Simɔ, u waa jeruo. ");
INSERT INTO cmeNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","*Oromɛ ba sorosibaa-ba namba waa Sesare‑i-na, ba taa ba bĩ-ba *Italitaaŋ-sorosibaa. Ba yuntieŋo naŋo waa, ba taa ba bĩ-yo Kɔrnɛi. ");
INSERT INTO cmeNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","U taa u wuɔ *Yuifu ba Diiloŋ-hũmelle‑i fafamma baa u dumɛlleŋ-baamba‑i. U taa u kãalã Diiloŋo‑i. U taa u kãyã sũntaamba‑i aa bi tuɔ cãrã Diiloŋo‑i bãaŋgu‑i baa isuɔŋgu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Bãtaruŋgu naŋgu-na, wuɔ tĩɛna u dũŋgu-na a ji da *dɔrpɔpuɔrbiloŋo naŋo suurii-yuɔ ka cira: «Kɔrnɛi!» ");
INSERT INTO cmeNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kɔrnɛi kũɔma pãŋ doŋ ta ma nyɛŋ. Wuɔ dĩŋ dɔrpɔpuɔrbiloŋo-na tuɔ ne aa yuu-yo wuɔ: «Kuu dii niɛ?» Dɔrpɔpuɔrbiloŋo cira: «Diiloŋo'i puɔraa-mi ŋ wulaa; niŋ cãrãŋ-yuɔ aa bi tiraa ta ŋ kãyã sũntaamba‑i ku dɔlaanu-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ku'i ciɛ wuɔ mi ji waŋ baa-ni ŋ puɔr nuɔmba Yope‑i-na, ba ka bĩ naacolŋo naŋo jo; ba bĩ-yo Simɔ. U yerre nande yaa Piɛr. ");
INSERT INTO cmeNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Uŋ haraa umaŋ nuɔ‑i, ba bi bĩ-yo Simɔ; jeruo. U cĩiŋgu dii dãmmaŋ-nuoraaŋgu nuŋ-nu.» ");
INSERT INTO cmeNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Dɔrpɔpuɔrbiloŋoŋ juɔ piiye tĩ aa ta, Kɔrnɛi wuɔ bĩ u maacembiemba hãi baa u sorosiyiɛŋo naŋo. Sorosiyiɛŋo faŋo taa u bi wuɔ Yuifu ba Diiloŋ-hũmelle‑i fafamma. ");
INSERT INTO cmeNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Baŋ juɔ, u biɛ piiye mamaŋ ciɛ hiere tũnu-bɛi, aa puɔr-ba Yope‑i-na Piɛr wulaa. ");
INSERT INTO cmeNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ku cuo kaala‑i-na, Piɛr fuɔ saa bi suɔ wuɔ ba puɔraa nuɔmba ta ba jo dii u wulaa. Bãaŋguŋ juɔ hi yuhuɔŋga‑i, u nyugũŋ dũŋgu naŋgu dɔrɔ‑i-na duɔ jaal Diiloŋo‑i. A ne da huɔŋgu faŋgu-na, Kɔrnɛi pɔpuɔrbiemba naa piɛ nelle‑i tĩ. ");
INSERT INTO cmeNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Nyulmu ji bel Piɛr dii dɔrɔ‑i-na, u ce ba ta ba ce niiwuoni da ba hã-yo. Wuɔ u ne dɔrɔ‑i-na, a da bige‑i daaku‑i? ");
INSERT INTO cmeNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Dɔrɔ puurii aa bĩŋkũŋgu naŋgu ta ku hiire ku jo. Ku waa ŋaa kompaŋga, da bãmbãale aa to ka nunni naa‑i-na hiere. ");
INSERT INTO cmeNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Bĩmbaamba‑i ba sĩnni-na hiere ba waa: Hĩɛŋ-baamba‑i, baa huriimba‑i a naara baabũulãamba waa hiere. ");
INSERT INTO cmeNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Kaŋ juɔ saanu baa Piɛr, wuɔ nu molo piiye wuɔ: «Piɛr, sire ŋ bel ŋ ko ŋ wuo!» ");
INSERT INTO cmeNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Piɛr wuɔ cira: «Mi siɛ wuo; niiwuoni maŋ nyaa-ye, niiwuoni maŋ saa fa hiere, miŋ siire mi saa wuo-ni dede.» ");
INSERT INTO cmeNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Moloŋ daa wuɔ cira: «Diiloŋ duɔ migãaŋ kumaŋ, nuɔ baa ce-ku kuubabalaaŋgu.» ");
INSERT INTO cmeNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ku tirii ce i siɛi aa kompaŋga bir nyugũŋ dɔrɔ‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Kɔrnɛi pɔpuɔrbiembaŋ kãa ka hi Yope‑i, baa yuure ba pigãaŋ-ba Simɔ dumɛlle‑i. A ne da huɔŋgu faŋgu-na, Piɛr waa tuɔ jɔguɔŋ nel daama‑i u sa da yaaŋga mɛi. Pɔpuɔrbiembaŋ kãa ka hi fondumɛlle‑i, ");
INSERT INTO cmeNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","ba fara ta ba yuu wuɔ: «Baŋ bĩŋ Simɔ maŋ Piɛr, u haraa bande yaa nuɔ‑i wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","*Diiloŋ-Yalle gbɛ̃ Piɛr wuɔ: «Sire, nuɔmba namba juɔ ji ta ba yuu ŋ maama, baa dii nuɔmba siɛi. ");
INSERT INTO cmeNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Hiire ŋ kã na kã, muɔmɛi puɔraa-ba ŋ wulaa, baa ce ŋ hɔmmu‑i mu hãi.» ");
INSERT INTO cmeNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Piɛr wuɔ hiire jo ji cira: «Muɔmɛi Piɛr. Ku faa wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Baa cira: «Ku faa. Sorosi ba yuntieŋo naŋo'i puɔraa-ye ŋ wulaa, ba bĩ-yo Kɔrnɛi. Naacolŋ daayo‑i nelfɛfɛiŋo aa u kãalã Diiloŋo‑i. Yuifubaa-ba‑i hiere ba bĩ u yefafalle. Diiloŋo puɔraa dɔrpɔpuɔrbiloŋo naŋo ji waŋ baa-yo wuɔ u ce ŋ kã u wulaa kɛrɛ nelma dii ŋ da ŋ ka piiye baa-yo.» ");
INSERT INTO cmeNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Piɛr wuɔ ce ba suur nyɔŋ hũmma‑i aa naa cɔ yiiŋgu faŋgu-na. Ku cuo kaala‑i-na, wuɔ sire baa-ba ba ta ba kã Sesare‑i-na. Diiloŋ-dũŋ-baamba maŋ waa Yope‑i-na, banaŋ baa sire kã baa-ba. ");
INSERT INTO cmeNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Piɛrbaa-ba wuɔyaa yififiiŋgu diei. Ku cuo kaala‑i-na, ba suɔ hi Sesare‑i. Ba kãa ka da Kɔrnɛi tigiiŋ u dũŋ-baamba‑i baa u jɛ̃nakpekpelmba‑i tuɔ cie-ba. ");
INSERT INTO cmeNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Piɛrŋ kãa ka tuɔ suur, Kɔrnɛi wuɔ sire jãrã-yuɔ kã ka dũuna duɔ jaal-o. ");
INSERT INTO cmeNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Piɛr wuɔ cira: «Baa ce dumaa, Diiloŋ muɔ sĩ, sire!» Aa naa bel u sire. ");
INSERT INTO cmeNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Uŋ siire, baa ta ba piiye ba suur. Piɛr suurii ku yaa‑i, a da nuɔmba tĩɛnaana da bãmbãale. ");
INSERT INTO cmeNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Wuɔ jaal-ba aa naa cira: «Na suyaa wuɔ a saanu baa *Yuifubaa miɛ Diiloŋ-hũmelle‑i, Yuifubaa-ba saa saaya ba ta ba piɛ *niɛraamba‑i, ba saa bi saaya ba ta ba suur ba dumiɛŋa-na. Ŋga ma miŋ yeŋ terieŋgu maŋ nuɔ‑i nyuŋgo‑i-na, Diiloŋo pigãaŋ-mi wuɔ mi baa ta mi ne moloŋo wuɔ u balaaŋ. ");
INSERT INTO cmeNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ku'i ciɛ na da naŋ bĩɛ-mi, mi saa ce mi hɔmmu‑i mu hãi, mi sire ta jo. Dɛ‑i-na mi taara mi suɔ, ku faa na bĩ-mi wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kɔrnɛi wuɔ cira: «Ku faa. Ku yinni naa yaa dɛ‑i, bãaŋgu naa bi doŋ ta ku tɛrɛŋ fiɛfiɛ ku bi temma yaa dɛ‑i. Mi suur mi dũŋgu-na ta mi jaal Diiloŋo‑i. Mi juɔ'a mi ne da naacolŋo naŋo‑i mi yaaŋga-na, u joŋgorbaa-ba carra ŋaa duɔleŋo. ");
INSERT INTO cmeNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Naacolŋo gbɛ̃-mi wuɔ: ‹Kɔrnɛi, niŋ cãrãŋ kumaŋ Diiloŋo wulaa u ka hã-ni baa-ku. Aa niŋ kãyãŋ sũntaamba‑i u daa-ni. ");
INSERT INTO cmeNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Puɔr nuɔmba Yope‑i-na, ba ka bĩ naacolŋo naŋo jo, ba bĩ-yo Simɔ. U yerre nande yaa Piɛr. Uŋ haraa naacolŋo maŋ nuɔ‑i, ba bi bĩ-yo Simɔ; jeruo. U cĩiŋgu dii dãmmaŋ-nuoraaŋgu nuŋ-nu.› ");
INSERT INTO cmeNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Miŋ nuɔ mafamma‑i mi saa sɛrɛ; mi pãŋ puɔr miɛ ba ka bĩ-ni. Niŋ hũyãa-ma jo, ku faa. Itieŋ uŋ hãa-ni mamaŋ ŋ da ŋ ji waŋ baa-ye, i tigiiŋ i-naa diɛ nu ma yaa‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Piɛr wuɔ biɛ ãndaaŋgu‑i aa naa cira: «Yende‑i-na, mɛi suyaa miɛ Diiloŋo sa ce ciɛluɔ. ");
INSERT INTO cmeNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Da ŋ fiɛ ta ŋ hel hie, aa ta ŋ kãŋ-yo, aa bi ta ŋ ce kuuviiŋgu, ŋ maama ta ma dɔlnu-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","U puɔraa ba ka waŋ *Neldɔdɔlma‑i baa *Isirahɛl-baamba‑i, wuɔ Yesu-Kirsa diyaa-ye i-naa nuɔ baa-yo, kɛrɛ u yaa nuɔmba‑i hiere ba Tieŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Nsãaŋ waaŋ Diiloŋ-nelma‑i aa *batiseŋ nuɔmba‑i aa kumaŋ ce *Yude‑i-na hiere na suyaa-ku. Ku duɔŋ *Galile yaa nuɔ‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Diiloŋ uŋ hielaa Nasarɛtitaaŋ Yesu‑i dumaa aa hã-yo u *Yalle‑i baa himma‑i, na suyaa-ku. Diiloŋo waa baa-yo, a ce duɔ cor terieŋgu terieŋgu, u kãyã nuɔmba‑i aa donya *jĩnabaa-ba‑i nuɔmba-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Uŋ ciɛ mamaŋ *Yerusalɛmu‑i-na baa *Yuifu ba nilɛiŋa naŋa-na hiere i daa-ma nuɔ. Ba yaŋ aa bel-o gbu-yo *daaŋ-nu ko-yo. ");
INSERT INTO cmeNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Baŋ fiɛ ko-yo, u ciɛ yinni hãi yoŋ hĩɛma-na, siɛliŋ-yiiŋgu‑i, Diiloŋo sire-yuɔ aa ce u wuɔra carra nuɔmba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Nuɔmba hiero saa da-yo. Diiloŋ uŋ hielaa miɛ maŋ ku domma-na wuɔ siɛrtaaŋ miɛ, miɛmɛi daa-yo. I wuyaa baa i-naa, aa nyɔŋ baa i-naa. ");
INSERT INTO cmeNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","U puɔraa-ye wuɔ i waŋ Neldɔdɔlma‑i baa Isirahɛl-baamba‑i, aa waŋ baa-ba wuɔ Diiloŋo haa u yaa‑i gɛ̃ŋgɛrtieŋo‑i nuɔmba‑i hiere ba yuŋgu-na ka hel baa bikuomba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","*Diilopɔpuɔrbiemba‑i hiere ba siire waŋ u maama cor, wuɔ nuɔni maŋ da ŋ hũu u maama‑i, ŋ ãmbabalma hur halaŋ.» ");
INSERT INTO cmeNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Nelma saa ji tĩ Piɛr nuŋgu-na, Diiloŋ wuɔ saaŋ u *Yalle‑i Kɔrnɛibaa-ba-na hiere. ");
INSERT INTO cmeNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","*Yuifubaa-ba maŋ naa hilaa jo baa Piɛr, kuɔ ce-ba gbɛrɛ wuɔ *niɛraamba bi daa *Diiloŋ-Yalle‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Niɛraaŋ baŋ daa Diiloŋ-Yalle‑i, baa doŋ ta ba piiye nelfɛlɛmma-na aa ta ba hãl nɛini ba tuɔlnu Diiloŋo‑i. Piɛr wuɔ cira: ");
INSERT INTO cmeNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","«Ba daa Diiloŋ-Yalle‑i miɛ bi temma‑i, hai gbãa cie-ba wuɔ ba siɛ da *batiseŋ.» ");
INSERT INTO cmeNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Aa naa ce ba *batiseŋ-ba Yesu-Kirsa yerre-na. Kɔrnɛibaa baa cãrã-yuɔ wuɔ u tĩɛna ce yinni cɛllɛ baa-ba. ");
INSERT INTO cmeNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","*Niɛraambaŋ hũyãa Yesu maama‑i, Yesu *pɔpuɔrbiemba‑i baa Diiloŋ-dũŋ-baamba maŋ waa *Yude‑i-na baa nu-ma. ");
INSERT INTO cmeNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Piɛrŋ juɔ bir kã *Yerusalɛmu‑i-na, Diiloŋ-dũŋ-baamba maŋ waa *Yuifubaa-ba‑i, baa ta ba waŋ baa-yo ");
INSERT INTO cmeNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","wuɔ u ciɛ niɛ suur *niɛraamba dũnni-na, aa tiraa wuo niiwuoni‑i baa-ba? ");
INSERT INTO cmeNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Maŋ ciɛ dumaa hiere, Piɛr wuɔ suur ma yaaŋga-na a waŋ-ma baa-ba wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","«Mi waa Yope‑i-na ta mi cãrã Diiloŋo‑i, mi juɔ'a mi ne da bĩŋkũŋgu naŋgu hilaa dɔrɔ‑i-na ta ku jo. Ku waa ŋaa kompaŋga, da bãmbãale aa to ka nunni naa‑i-na. Kaŋ juɔ saanu baa-mi, ka yiɛra. ");
INSERT INTO cmeNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Mi ne ka huɔŋga-na da suu a da bĩmbaamba‑i ba sĩnni-na hiere: Hĩɛŋ-baamba‑i, baa huriimba‑i a naara baabũulãamba waa hiere. ");
INSERT INTO cmeNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Miŋ daa-ba dumaaŋo-na, mi nu molo piiye baa-mi wuɔ: ‹Piɛr, sire ŋ bel ŋ ko ŋ wuo!› ");
INSERT INTO cmeNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Miɛ: ‹Moloŋ nuɔ, mɛi siɛ wuo. Niiwuoni maŋ nyaa-ye baa nimaŋ saa fa hiere, miŋ siire mi saa dii ku diei mi nuŋgu-na dede.› ");
INSERT INTO cmeNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Moloŋ daa u tĩɛ dii dɔrɔ‑i-na aa cira: ‹Diiloŋ duɔ migãaŋ kumaŋ, nuɔ baa ce-ku kuubabalaaŋgu.› ");
INSERT INTO cmeNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ku tirii ce i siɛi aa kompaŋga bir nyugũŋ baa bĩmbaamba‑i hiere dɔrɔ‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","«Kaŋ bi birii nyugũŋ, miɛ mi ne da nuɔmba siɛi juɔ ji ta ba suur miŋ haraa dumɛlle maŋ nuɔ‑i, wuɔ ba hilaa Sesare. Ba puɔraa-ba muɔmɛi wulaa‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","*Diiloŋ-Yalle gbɛ̃-mi wuɔ: ‹Baa ce ŋ hɔmmu‑i mu hãi, sire na kã.› Naŋ daa nuɔmba niediei maŋ daaba‑i, ba yaa saaŋ-mi i kã Kɔrnɛi terieŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Iŋ kãa, u biɛ piiye pigãaŋ-ye, wuɔ u tĩɛnaana u dũŋgu-na, a ji da *dɔrpɔpuɔrbiloŋo naŋo caraaya-yuɔ a waŋ baa-yo wuɔ u puɔr ba ka bĩ-mi Yope‑i-na ");
INSERT INTO cmeNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","mi ka waŋ nelma namma baa-yo, kɛrɛ nelma famma ka kor-o baa u dumɛlleŋ-baamba‑i hiere. ");
INSERT INTO cmeNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Miŋ kãa ka hi doŋ ta mi piiye, ku saa vaaya, Diiloŋ-Yalle suur ba hɔmmu-na ŋaa diŋ bi suurii miɛŋo-na dumaa ku domma-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Itieŋ uŋ waaŋ nelma maŋ, wuɔ Nsãa *baatiseŋ-ye baa hũmma, ŋga yiiŋgu dii baa yiiŋgu Diiloŋo ka batiseŋ-ye baa u *Yalle‑i; nelma famma pãŋ tĩɛnu-miɛ. ");
INSERT INTO cmeNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Miɛ iŋ hũyãa Itieŋo‑i Yesu-Kirsa maama‑i aa Diiloŋo hã-ye kumaŋ, u bi hãa bafamba‑i kuuduɔŋgu faŋgu yaa‑i. Muɔmi naa gbãa cie Diiloŋo‑i wuɔ u baa hã-ba wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Piɛrŋ juɔ piiye dumaaŋo-na, ba hɔmmu suɔ ciire. Baa ta ba piiye wuɔ: «Diiloŋo‑i bibiɛŋo! U bi kãayã niɛraamba da ba nanna ba cilɔbabalaŋo‑i aa duɔ kor-ba.» ");
INSERT INTO cmeNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Baŋ kuɔ Etiɛni‑i aa pisãllã Diiloŋ-dũŋ-baamba maŋ, banamba kã ka hel dii Fenisi, banamba Sipire, banamba Ãntiyɔsi. Baa naa fulnu *Yuifubaa-ba yaa yoŋ ta ba waŋ Yesu maama‑i baa-ba. ");
INSERT INTO cmeNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Sipiretaamba namba waa ba hɔlma-na baa Sirɛnitaamba namba. Baŋ kaa hi Ãntiyɔsi‑i, baa bi piiye-mɛi baa *niɛraamba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Itieŋo taa u kãyã-bɛi, a ce dumaaŋo-na, nuɔmba bɔi baa hũyãa Diiloŋ-nelma‑i a cu Itieŋo huoŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Nel daama kã ka hi Diiloŋ-dũŋ-baamba‑i *Yerusalɛmu‑i-na. Baŋ nuɔ-ma, baa saaŋ Barnabasi‑i ba wulaa dii Ãntiyɔsi‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Barnabasiŋ kãa ka hi da Diiloŋ uŋ ciɛ baa-ba cemma maŋ, kuɔ gbuu fũnuŋ dɔlnu-yuɔ. Wuɔ dii sirɛiŋa bɛi, wuɔ ba baa hel Itieŋo huoŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabasi waa nelviiŋo, *Diiloŋ-Yalle naa yu u huɔŋga‑i baa Yesu maama‑i, a ce dumaaŋo-na, nuɔmba bɔi baa hũyãa Itieŋo maama‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ku huoŋgu-na, Barnabasi ji ta kã Tarse duɔ ka taara Sol‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Uŋ kaa da-yo, wuɔ ce ba bir kã Ãntiyɔsi‑i-na ka tĩɛna ce benfifille baa Diiloŋ-dũŋ-baamba‑i. Ba hãalãayã nuɔmba bɔi Diiloŋ-hũmelle‑i terieŋgu-na. Ba duɔŋ Ãntiyɔsi yaa nuɔ‑i ta ba bĩ Diiloŋ-dũŋ-baamba‑i «Kertĩɛbaa-ba‑i». ");
INSERT INTO cmeNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Huɔŋgu faŋgu-na, *Diilopɔpuɔrbiemba namba hel Yerusalɛmu‑i-na a kã Ãntiyɔsi‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ba taa ba bĩ unaŋo‑i Agabusi. Diiloŋ-Yal diɛ sire-yuɔ a ce u tuɔ piiye wuɔ nyulbabalammu ka suur nilɛiŋa-na hiere. (Ninsie ninsie, nyulmu fammu yaa juɔ suur *Oromɛ ba *jãmatigi maŋ ba naŋ bĩŋ-yoŋ Kulodi‑i u bãaŋgu-na.) ");
INSERT INTO cmeNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Uŋ piiye dumaaŋo-na, Diiloŋ-dũŋ-baamba‑i Ãntiyɔsi‑i-na, baa saa-ma wuɔ umaŋ duɔ saanu kumaŋ, u jo baa-ku ba saaŋ-ku hã tobimba maŋ *Yude‑i-na ba kãyã ba fɛrɛ. ");
INSERT INTO cmeNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Baŋ saanu baa kumaŋ hiere, baa jãnu-kuɔ a puɔr Barnabasi baa Sol ba ka hã yaataamba‑i baa-ku dii Yude‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Huɔŋgu bi faŋgu-na, jãmatigi maŋ waa *Yude‑i-na, wuɔ bel Diiloŋ-dũŋ-baamba namba‑i tuɔ ce-ba sũlma. Ba taa ba bĩ-yo *Erɔdi. ");
INSERT INTO cmeNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","U tĩyãa kufaŋgu-na ji ce ba ko Nsãa mɔlɔ̃‑i Sake‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Uŋ ciɛ mafamma‑i, wuɔ ne da ku dɔlaanu *Yuifubaa-ba‑i, wuɔ tiraa ce ba bel Piɛr. Baŋ bilaa Piɛr yibieŋa maŋ nuɔ‑i, *baŋ'a ba sa dii siini‑i *buruo maŋ nuɔ‑i, ba taa ba ce u ponsaaŋgu‑i yinni fanni yaa nuɔ‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Wuɔ ce ba kã ka dii-yo kaso aa naa ce sorosibaa cĩncieluo niediei ba ta ba niya-yuɔ ba hor ba-naa, ba na-ba-naa. U taa u ne wuɔ *kɔrsĩnni tĩmmaŋ-ponsaaŋ da ku cor, u bĩ nuɔmba‑i ji ce u ãndaaŋgu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Piɛr wuɔ tĩɛ ba nammu-na dii kaso‑i-na. Diiloŋ-dũŋ-baamba gbuu faya ba fɛrɛ ta ba cãrã Diiloŋo‑i ba hã-yo. ");
INSERT INTO cmeNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ãndaaŋgu naa saaya ku ce ŋaa bisĩŋ ku temma, isuɔŋgu-na, sorosibaa-ba hãi jo ji yiɛra Piɛr yudɔrɔ‑i-na u tuɔ duɔfũŋ aa banamba waa dumɛlle yaaŋga‑na. Baa naa vaa-yo baa jɔlgɔbaa-ba hãi. ");
INSERT INTO cmeNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Itieŋo *dɔrpɔpuɔrbiloŋo naŋo hiire jo. Piɛrŋ waa dũŋgu maŋ nuɔ‑i, kuɔ pãŋ ce da cerre. Wuɔ kã ka muo Piɛr aa cira: «Sire donduo!» Piɛr wuɔ sire. Jɔlgɔbaa-ba fir u nammu-na hiere. ");
INSERT INTO cmeNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Dɔrpɔpuɔrbiloŋo cira: «Migãaŋ ŋ vaa ŋ kpaŋkpaaŋgu‑i aa ŋ vaa naatɛnni comieŋa‑i.» Piɛr wuɔ migãaŋ vaa u kpaŋkpaaŋgu‑i aa naa bi vaa u naatɛnni comieŋa‑i. Dɔrpɔpuɔrbiloŋ wuɔ cira: «Dii ŋ joŋgoruo‑i i ta.» ");
INSERT INTO cmeNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Piɛr wuɔ dii u joŋgoruo‑i aa naa hel ba ta. Ku waa u wulaa ŋaa dãnsãaŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ba kã ka cor munniyadĩɛlãmmu‑i, aa sire ka cor hãalĩŋ-muumu‑i. Baŋ kaa hi dumɛbuɔ‑i, wuɔ puur u fɛrɛ ba hel. Dumɛlle fande waa kɔlluŋ-diele. Baŋ hilaa a wuɔ maa cɛllɛ, Piɛr wuɔ u ne naa dɔrpɔpuɔrbiloŋo‑i, u taa. ");
INSERT INTO cmeNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Uŋ taa huɔŋgu-na, Piɛr wuɔ suɔ suɔ wuɔ dãnsãaŋgu sĩ. Wuɔ cira: «Fiɛfiɛ‑i-na, mi suyaa miɛ Itieŋo yaa puɔraa dɔrpɔpuɔrbiloŋo ji hũu-mi Erɔdi nyisɛ̃nni-na. Yuifubaa-baŋ taa ba jɔguɔŋ-mi baa mamaŋ, Diiloŋo saa hũu-ma.» ");
INSERT INTO cmeNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Piɛrŋ juɔ suɔ u fɛrɛŋ maa-na dumaaŋo-na, wuɔ ta kã Nsãa maŋ ba naŋ bĩŋ-yoŋ Marke‑i u nyu dumɛlle-na; ba taa baa bĩ nyuŋo‑i Maari. Nuɔmba bɔi waa terieŋgu-na ta ba cãrã Diiloŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Uŋ kãa ka hi tuɔ muo dumɛlle‑i, maacembiloŋo naŋo waa, ba taa ba bĩ-yo Ɔrɔdi, wuɔ kã duɔ ka hĩl-de. ");
INSERT INTO cmeNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Uŋ kaa nu Piɛr yalle‑i, u huɔŋga pãŋ fɛ̃ a ce dumɛlle hĩlma maama karaanu-yuɔ. Wuɔ bir gũunu baa gbaruŋgu ka tũnu-bɛi wuɔ Piɛr juɔ. ");
INSERT INTO cmeNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Nuɔŋ baa cira: «Ŋ yuŋgu si dii wɛi?» Maacembiloŋ wuɔ cira: «Mi sa kar coima, Piɛr yaa‑i.» Baa cira: «Piɛr sĩ, ku ka waa u jufoiŋo.» ");
INSERT INTO cmeNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Piɛr wuɔ bi faya u fɛrɛ tuɔ muo dumɛlle‑i. Ba ji naa ba kã ka hĩl-de a da-yo; kuɔ ce-ba gbɛrɛ. ");
INSERT INTO cmeNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Piɛr wuɔ ce u naŋga‑i ce ba budii aa naa suur ma yaaŋga-na piiye tũnu-bɛi Itieŋ uŋ hielaa-yo dumaa kaso‑i-na. Uŋ juɔ piiye tĩ, wuɔ cira: «Kãaŋ na ka tũnu Sake‑i baa tobimba namba‑i.» Aa naa hel ta tuɔ kã yaŋga naŋga. ");
INSERT INTO cmeNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Cuoŋ juɔ kaal, sorosibaa-ba saa suɔ Piɛrŋ curaa kusuɔŋ-nu. Baa ta ba yuu ba-naa wuɔ: «U curaa hie?» ");
INSERT INTO cmeNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Jãmatigi wuɔ ce ba wuɔra taara-yuɔ ba saa da-yo. Wuɔ ce ba bel sorosibaa daaba‑i ka yuu-ba baŋ ciɛ dumaa u ji tuɔ kor, aa naa ko-ba. Uŋ ciɛ mafamma‑i, wuɔ ta kã Sesare ka da yinni cɛllɛ. ");
INSERT INTO cmeNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","*Erɔdi waa bɛrruŋ baa Tiirtaamba‑i baa Sidɔ̃taamba‑i. A ne da niiwuoni hel *Erɔdi jãmalã yaa nuɔ‑i ni kã ba wulaa. Baa nunu ba-naa da ba ka cãrã-yuɔ. Umaŋ taa u ce maacemma‑i Erɔdi ducɔŋgu-na, ba taa ba bĩ-yo Bilatusi; baa cãrã u yaa duɔ ta ba yaaŋ-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Baŋ diyaa yiiŋgu maŋ kuŋ juɔ hi, Erɔdi wuɔ dii u nellentesĩnniŋ-joŋgoruo‑i ka tĩɛna u fɔ̃ŋgɔ̃sĩnniŋ-teterre-na tuɔ gbu u piiye baa nuɔmba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Duɔ piiye, nuɔŋ ba'a: «Diiloŋo'i piiyeŋ daayo‑i, nelbiloŋo sĩ.» ");
INSERT INTO cmeNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Terduɔŋgu faŋgu-na, Itieŋo *dɔrpɔpuɔrbiloŋo pãŋ naŋ Erɔdi‑i baa jarma, wuɔ u ciɛ niɛ hũu Diiloŋo yerre‑i ce-de u diele? U naaŋ-yo baa jĩaŋ-jarma. Jĩamba wuo-yo ko-yo. ");
INSERT INTO cmeNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Diiloŋ-nelma taa ma muonu terni‑na hiere ma kã. ");
INSERT INTO cmeNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnabasi‑i baa Sol baŋ kãa baa coŋgoruoŋgu maŋ *Yerusalɛmu‑i-na, baŋ kaa hũu-ku, baa gũunu kã Ãntiyɔsi‑i-na. Ba kãmma-na, baa kã baa Nsãa maŋ ba naŋ bĩŋ-yoŋ Marke‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","*Diilopɔpuɔrbiemba namba waa Ãntiyɔsi Diiloŋ-dũŋ-baamba-na, baa Diilonelpigãataamba namba. Ba hɔlma-na Barnabasi waa a naara Siminyɔ. Siminyɔ faŋo‑i, ba taa ba bĩ-yo Uubiloŋo. Lusiwusi maŋ taa u hel Sirɛni‑i-na, u waa. Manahai maŋ ciɛ niɛŋgu‑i baa *Erɔdi-Ãntipasi‑i, u waa; Sol bi waa. ");
INSERT INTO cmeNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Yiiŋgu naŋgu-na, ba ji dii sũŋgu aa tigiiŋ ba-naa ta ba cãrã Itieŋo‑i. *Diiloŋ-Yalle gbɛ̃-ba wuɔ: «Miŋ hãa Barnabasi‑i baa Sol maacemma maŋ, yaaŋ-baŋ ba fɛrɛŋ nuɔ ba ce-ma.» ");
INSERT INTO cmeNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Baŋ juɔ bãl sũŋgu‑i baa Diilojaale‑i, baa haa ba nammu‑i Barnabasibaa-ba-na aa cãrã Diiloŋo‑i hã-ba, aa hã-ba hũmelle‑i ba ta. ");
INSERT INTO cmeNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","*Diiloŋ-Yalleŋ ciɛ Barnabasi‑i baa Sol ba ta dumaaŋo-na, baa kã Selusi ka biɛ baatoŋo‑i ta ba kã Sipire. ");
INSERT INTO cmeNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Baŋ kaa hi Sipire‑i, baa hiire Salamine ta ba waŋ Diiloŋ-nelma‑i *Yuifu ba *Diilonelhãalãdũnni-na. Baŋ bĩŋ Nsãa maŋ Marke‑i, u waa baa-ba tuɔ kãyã-bɛi. ");
INSERT INTO cmeNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Baa karnu Salamine huɔŋga‑i hiere ka hi Pafɔsi. Baŋ kãa Pafɔsi‑i-na, ba da hiroŋo naŋo‑i, ba bĩ-yo Bar-Yesu. U waa Yuifuyiɛŋo. U taa u wuɔra u tãal nuɔmba‑i wuɔ fuɔ Diilopɔpuɔrbiloŋo. ");
INSERT INTO cmeNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","U waa Sɛrju-Polusi dumɛlleŋ. Sɛrju-Polusi yaa waa fãamaaŋo‑i nelle fande-na. U taa u cɛ̃ ŋaa jumɛlĩɛŋo. Barnabasibaa-baŋ kãa, wuɔ ce ba bĩ-ba wuɔ ba ka waŋ Diiloŋ-nelma‑i baa-yo, kɛrɛ ma nyulmu dii-yuɔ. Baa kã ku'i nuɔ‑i ka ta ba piiye. ");
INSERT INTO cmeNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Hiroŋ daayo‑i Girɛkibaa-ba taa ba bĩ-yo Elimasi, ku yuŋgu yaa wuɔ hiroŋo. Wuɔ sire wuɔ hĩi, wuɔ Sɛrju-Polusi baa hũu ba nelma‑i, kɛrɛ ba tãal-o. ");
INSERT INTO cmeNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Sol yerre nande yaa wuɔ Pol, Diiloŋ-Yalle naa yu u huɔŋga‑i. Wuɔ dĩŋ hiroŋo-na tuɔ ne, ");
INSERT INTO cmeNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","aa ji gbɛ̃-yo wuɔ: «Huhurmantieŋ nuɔni maŋ daani‑i, ŋ balaaŋ cor. Nuɔŋo‑i Sitãnitieŋ nuɔ. Ŋ sa taara ŋ da ãnfafamma‑i baa ŋ yufelle. Ŋ sa yaŋ Itieŋo maacemma bĩɛnamma‑i dumaa wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ne! Diiloŋo ka gãŋ baa-ni, u ka ce ŋ yir suur dũŋ-nu a da huɔŋgu cɛllɛ.» Terduɔŋgu faŋgu-na, hiroŋ daa u yufieŋa pãŋ dĩŋ aa yaŋ-yo. Wuɔ da terieŋgu‑i hiere da kullu. Wuɔ tuɔ wuɔra u tafũrrã u taara molo duɔ bel u naŋ-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Sɛrju-Polusiŋ daa mafamma‑i, Itieŋo nelma pãŋ ce-yo gbɛrɛ; wuɔ pãŋ hũu-ma. ");
INSERT INTO cmeNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Ku huoŋgu-na, Pol baa u wuɔrataamba sire Pafɔsi‑i-na a biɛ baatoŋo‑i kã Pɛrge, dii Pãnfili mara nuɔ. Baŋ kãa Pɛrge‑i-na, Nsãa wuɔ ka bir kã *Yerusalɛmu aa yaŋ-ba. ");
INSERT INTO cmeNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Pol baa Barnabasi baa cor kã Ãntiyɔsi, dii Pisidi mara nuɔ. *Yitĩɛnaŋguŋ juɔ hi, baa kã *Diilonelhãalãdũŋgu-na ka suur tĩɛna. ");
INSERT INTO cmeNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Baŋ juɔ kalaŋ *ãnjĩnamma sɛbɛ‑i tĩ, baa *Diilopɔpuɔrbiemba baamba‑i, Diilonelhãalãdũŋgu yuntaamba puɔr ba waŋ baa Polbaa-ba‑i wuɔ da kuɔ nelma dii ba da ba piiye dii sirɛiŋa nuɔmba-na, kɛrɛ ba gbãa sire piiye. ");
INSERT INTO cmeNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pol wuɔ sire yiɛra aa naa ce nuɔmba budii baa u naŋga. Baŋ budii, wuɔ cira: «*Isirahɛl-baaŋ namaa, baa *niɛraaŋ namaa namaŋ suurii *Yuifu ba Diiloŋ-hũmelle-na, karaaŋ na tũnni‑i na nu mi nelma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Isirahɛl-baaŋ miɛ iŋ wuɔ Diiloŋo maŋ hũmelle‑i, Diiloŋo faŋo yufelle hilaa miɛ bĩncuɔmba yaa nuɔ‑i u hã-ba huoŋgu bɔi baŋ ŋa naa waa juɔma-na huɔŋgu-na dii Esipi‑i-na. Uŋ ciɛ mafamma‑i, u kãyã-bɛi ba hel terieŋgu faŋgu-na, ");
INSERT INTO cmeNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","aa fiɛ-ba bieŋ komuɔŋa hãi temma *hĩɛkuraaŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Mafammaŋ curaa, u ko siyaabaa niehãi *Kanaa jãmalã‑i-na aa hã Isirahɛl-baamba‑i baa ba terieŋgu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Nel daama‑i hiere ma ciɛ bieŋ nuɔsiba hãi komuɔŋa hãi baa cĩnciel temmaŋ hɔlma-na. Ku huoŋgu-na, u hã-ba yuntaamba. Yuntaaŋ daaba tĩyãa baa-ba a ji hi *Samiɛl bãaŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","«Kufaŋgu huoŋgu-na, i bĩncuɔmba ji cira ba taara jãmatigi. Diiloŋo hã-ba Sawul. Ba taa ba bĩ u to‑i Kisi. *Bensaamiɛ dũŋ-baamba'i waa. Sawul ciɛ bieŋ komuɔŋa hãi jãmatigisĩnni-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ku huoŋgu-na, Diiloŋo halaŋ-yo aa haa *Davidi. Uŋ haa Davidi‑i, u cira: ‹Miŋ taa mi taara umaŋ, mi daa-yo, u yaa Davidi‑i Yese biɛŋo‑i. U'i ka tuɔ ce mi huɔŋga‑i.› ");
INSERT INTO cmeNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","«Diiloŋo ciɛ Davidi hãayɛ̃lŋo naŋo yaa jo Yesu‑i ji kor Isirahɛl-baamba‑i ŋaa uŋ ŋa naŋ pãa ma nuŋgu‑i dumaa. ");
INSERT INTO cmeNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Aa Yesu suɔ duɔ doŋ u maacemma‑i, Nsãa waaŋ Diiloŋ-nelma‑i baa Isirahɛl-baamba‑i hiere, aa cira ba nanna ba cilɔbabalaŋo‑i aa jo u ji *batiseŋ-ba. ");
INSERT INTO cmeNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","«Nsãa maacemmaŋ juɔ piɛ tĩmma, wuɔ tuɔ piiye wuɔ: ‹Umaŋ saaya u jo, uu dii huoŋ-nu. Baa na ta na ne wuɔ sĩ muɔmɛi; muɔ sĩ. Naacolŋo faŋo‑i mɛi saa piɛra u natãaŋgu‑i.› ");
INSERT INTO cmeNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","«Tobiŋ namaa, nelma maŋ kuraaŋ-yeŋ, Diiloŋo saaŋ-ma hã miɛmɛi baa-ma. U saaŋ-ma hã *Abiramu hãayɛ̃lmba‑i aa bi saaŋ-ma hã namaa namaŋ suurii Yuifu ba Diiloŋ-hũmelle-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Yerusalɛmutaamba‑i baa ba yuntaamba saa suɔ Yesu sĩnni‑i, ba bel-o ko-yo. Baŋ waŋ mamaŋ yitĩɛnanni-na hiere *Diilopɔpuɔrbiemba sɛbɛbaa-ba-na, ba ciɛ ma yaa‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","«Baŋ bilaa-yo a fiɛ ka da u saa cãl, ba yagar ce *Pilati ko-yo. ");
INSERT INTO cmeNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Maama nyɛgãaŋ Yesu kũŋgu-na, maŋ juɔ ce-yuɔ hiere, ba har-o *daaŋgu-na ka fuure-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Diiloŋo yaŋ-ba aa sire-yuɔ hiel-o kuomba hɔlma-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Bamaŋ cuu u huoŋ-nu a hel *Galile‑i-na a kã Yerusalɛmu‑i-na, uŋ siire, u caraaya ba yaa‑i yinni bɔi-na. Nyuŋgo ku bãaŋgu-na, ba yaa dii ta ba waŋ u maama‑i baa Isirahɛl-baamba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Miɛ fɛrɛ‑i, i juɔ diɛ ji waŋ *Neldɔdɔlma famma yaa baa-na wuɔ Diiloŋ uŋ pãa nuŋgu maŋ baa i bĩncuɔmba‑i, ");
INSERT INTO cmeNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","u ciɛ-ku hã ba huoŋ-baaŋ miɛmɛi: U siire Yesu‑i hiel-o kuomba hɔlma-na ŋaa maŋ nyɛgãaŋ dumaa Gbɛliɛmaŋ-nalãaŋgu maŋ hãalĩŋ-kũŋgu-na wuɔ: ‹Mi biɛŋo yaa nuɔŋo‑i. Muɔmɛi huɔŋ-ni nyuŋgo‑i-na.› ");
INSERT INTO cmeNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Diiloŋo siire-yuɔ hiel-o kuomba hɔlma-na, u saa yaŋ u hɔr. Uu naa hi waŋ-ma wuɔ: ‹Miŋ pãa nufafaaŋgu maŋ baa Davidi‑i, nuharuŋgu si dii, mi ka ce-ku hã-na.› ");
INSERT INTO cmeNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ku'i ciɛ na da ma waaŋ terieŋgu naŋgu-na wuɔ: ‹Ŋ siɛ siɛ yaŋ ŋ nolŋo hɔr hĩɛma-na.› ");
INSERT INTO cmeNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","A ne da Davidi maŋ waaŋ mafamma‑i, u siire ce Diiloŋo huɔŋga‑i ji ku. Uŋ kuu, ba fuuriiye-yuɔ baa u bĩncuɔmba‑i aa u hɔraa. ");
INSERT INTO cmeNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ŋga Diiloŋo siire Yesu yaa hiel-o hĩɛma-na, u saa da hɔr. ");
INSERT INTO cmeNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Tobiŋ namaa, terieŋgu faŋgu-na, na saaya na suɔ wuɔ fuɔ barguɔ yaa nuɔ‑i iŋ juɔ ji tiɛ waŋ ãmbabalma hurmaŋ-maama‑i baa-na. *Moisi ãnjĩnamma saa gbãa hur na ãmbabalma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Ŋga bamaŋ hũyãa fuɔ maama‑i, ba ãmbabalma hurii aa yaŋ-ba ba fɛrɛŋ nuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Terieŋgu faŋgu-na, bilaaŋ na fɛrɛ, baa na yaŋ Diilopɔpuɔrbiembaŋ waaŋ mamaŋ, ma ji wuo-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Ba ciɛra wuɔ: ‹Diiloŋo ciɛra: «Bombolmantaaŋ namaa, niɛŋ! Mi ka ce nelma namma na bãaŋgu-na. Nelma famma‑i molo duɔ waŋ-ma baa-na na siɛ hũu-ma. Ma ka ce-na gbɛrɛ aa na ka ku halaŋ.»›» ");
INSERT INTO cmeNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Baŋ juɔ hel Diilonelhãalãdũŋgu-na, nuɔmba jo ji ta ba cãrã Pol baa Barnabasi‑i wuɔ yitĩɛnaŋgu maŋ juɔŋ, ba tiraa ba tir nelduɔŋ daama‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Nuɔmbaŋ juɔ bɔrɔ, Yuifubaa-ba‑i baa niɛraamba maŋ suurii Yuifusĩnni-na, baa cu Pol baa Barnabasi‑i ba huoŋ-nu ta ba piiye baa-ba ba dii sirɛiŋa bɛi wuɔ ba ne Diiloŋo ãnfafamma‑i aa ba nyaar-yuɔ. Ba maama saa waa dɛi baa yuliiŋgu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Yitĩɛnaŋguŋ juɔ hi, nuɔmba‑i hiere nelle-na baa tigiiŋ ba-naa da ba nu Itieŋo nelma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Yuifubaa-baŋ juɔ da nelpũŋ daaku temmaŋ hilaa, ba bir yaŋ aa ce-ku nenemuŋgu. Pol duɔ waŋ mamaŋ, ba'a coima aa ta ba tuora-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Polbaa-ba doŋ holle waŋ baa-ba wuɔ: «Diiloŋ-nelma naa vii Yuifubaa namɛi igɛ̃na. Ŋga naŋ juɔ ta na cĩina-mɛi wuɔ na sa taara na da cicɛ̃lma maŋ sa tĩɛŋ dede‑i, i ka yaŋ-na aa ka waŋ-ma baa niɛraamba. ");
INSERT INTO cmeNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Itieŋo waaŋ ma yaa baa-ye wuɔ: ‹Mi ciɛ-ni nilɛiŋa‑i hiere a fitĩnuɔ nuɔ ŋ da ŋ gbãa hi terni‑i hiere baa koŋkor-nelma‑i.›» ");
INSERT INTO cmeNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Niɛraambaŋ juɔ nu nel daama‑i, kuɔ gbuu dɔlnu-bɛi. Baa pãŋ ta ba kaal Itieŋo nelma‑i wuɔ ma faa. Bamaŋ naa waa da ba da kor, baa hũu-ma. ");
INSERT INTO cmeNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Itieŋo nelma doŋ ta ma gbuo nilɛiŋa faŋa‑i hiere. ");
INSERT INTO cmeNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Yuifubaa-ba bir yaŋ aa tãal caamba maŋ waa bĩŋkũntaamba‑i aa suur Yuifu ba Diiloŋ-hũmelle-na, baa nelleŋ-bĩncuɔmba‑i a gbo-ba Polbaa-ba-na. Baa bel-ba huol ba yammu‑i da dɛi aa donya-bɛi ba nelle-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Pol baa Barnabasi‑i baa pir ba nallu‑i ba terieŋgu-na, aa ta kã Ikoniyɔmu. ");
INSERT INTO cmeNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Baŋ fiɛ donya-bɛi, bamaŋ naa cu Yesu huoŋgu-na, baa cor baa ba hɔfɛ̃lle‑i. *Diiloŋ-Yalle naa bi yu ba hɔmmu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pol baa Barnabasi‑i baŋ kãa Ikoniyɔmu‑i-na, baa tiraa kã *Yuifu ba *Diilonelhãalãdũŋgu-na ka ta ba waŋ Diiloŋ-nelma‑i. Baŋ waŋ-maŋ dumaa, Yuifubaa-ba saa gbãa da ba yagar-ma baa *niɛraamba‑i. Ba bɔi baa hũyãa-ma. ");
INSERT INTO cmeNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Yuifubaa-ba maŋ saa hũu-ma, baa yaŋ aa kã ka gbo niɛraamba‑i baa Diiloŋ-dũŋ-baamba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Baŋ fiɛ gbo-ba, Polbaa-ba saa ta; baa tĩɛna da huɔŋgu Ikoniyɔmu‑i-na. Baa naa haa ba naŋga Itieŋo-na aa ta ba piiye. U taa u kãyã-bɛi ba ta ba ce nelma bɔi baa gbɛrɛ-wɛima bɔi a pigãaŋ wuɔ baŋ waŋ u ãnfafamma maŋ, coima sĩ. ");
INSERT INTO cmeNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Kuŋ ciɛ dumaaŋo-na, nuɔmba saa gbãa nunu ba-naa nelle-na: Banamba waa baa Yuifubaa-ba‑i, banamba waa baa Yesu *pɔpuɔrbiemba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Yuifubaa-ba‑i baa niɛraamba‑i a naara ba yuntaamba‑i, baa nunu ba-naa da ba bel Polbaa-ba‑i huol ba yammu‑i aa naŋ-ba baa tãmpɛ̃lɛ̃iŋa ko-ba. ");
INSERT INTO cmeNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","7","Polbaa-ba nu-ma. Baŋ nuɔ-ma, baa gbar kã Likawoni ka ta ba waŋ *Neldɔdɔlma‑i. Ba waaŋ-ma Lisire‑i-na, baa Dɛrbu‑i-na baa nilɛiŋa maŋ kɔtɔnni-na hiere. ");
INSERT INTO cmeNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Naacolŋo naŋo waa Lisire‑i-na, u saa gbãa tuɔ sire u yiɛra. Uŋ siire, u saa gbãa tɛtɛŋ u gboluoŋgu‑i dede. ");
INSERT INTO cmeNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Yiiŋgu naŋgu-na, wuɔ tĩɛna tuɔ nu Pol tuɔ piiye. Pol wuɔ ji dĩŋ-yuɔ tuɔ ne, a ji da u suyaa wuɔ Diiloŋo gbãa sire-yuɔ u jarma-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Wuɔ piiye baa-yo da gbagaga wuɔ: «Sire ŋ yiɛra ŋ gbeiniŋ!» Naacolŋ wuɔ tie sire pãŋ tuɔ wuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Lisiretaambaŋ daa mafamma‑i, baa ta ba piiye likawonimma-na wuɔ: «I tĩnni cĩɛŋ nelbiliemba a hiire jo ji tĩɛna baa-ye.» ");
INSERT INTO cmeNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Kuŋ ciɛ dumaaŋo-na, baa ta ba bĩ Barnabasi‑i Yewusi. Ba waa da ba cor kusuɔŋ-nu Pol yaa piiyeŋ, a ce dumaaŋo-na baa ta ba bĩ ufaŋo‑i Hɛrmɛsi. ");
INSERT INTO cmeNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Yewusi jigãntieŋ wuɔ kã ba nunu ba-naa baa nuɔmba‑i aa wuɔ bel balmba namba a tuɔlnu-bɛi jo baa-ba u tĩnniŋ-dũŋgu-na duɔ ji ko-ba tĩnni-na hã Pol baa Barnabasi‑i. U tĩnniŋ-dũŋgu waa nelle munsuurmu-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Polbaa-ba saa suɔ ku yuŋgu. Baŋ juɔ suɔ, ba hɔmmu pãŋ guɔla; baa taalnu ba joŋgorbaa-ba‑i aa gbar kã ba wulaa ka ta ba waŋ baa-ba wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","«Na ce bige‑i maacemma‑i dumandɛ‑i-na? Caamba'i bi huɔŋ miɛŋo‑i namaa temma‑i. I juɔ baa *Neldɔdɔlma'i diɛ ji tũnu-nɛi, wuɔ na nanna ãnsɔsɔŋ daama‑i aa na cu Cicɛ̃lmantieŋo huoŋ-nu. U yaa hielaa dɔrɔ‑i baa hĩɛma‑i baa dãmmaŋ-nuoraaŋgu‑i baa ni huɔya-niini‑i hiere. ");
INSERT INTO cmeNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Yiinaa‑i-na, u yaaŋ nuɔmba‑i ba fɛrɛŋ nuɔ ba sire wuɔ ba hũmieŋa. ");
INSERT INTO cmeNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Naŋ fiɛ waa na fɛrɛŋ nuɔ, u saa yaŋ u ãnfafamma cemma‑i: U dãa u hã-na dii, u ce na dĩmma ta ma ce fafamma, u hã na ta na wuo na ye aa tiraa tuɔ fɛ̃ na hɔmmu‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Polbaa-baŋ fiɛ piiye dumaaŋo-na, nuɔmba saa ta ba ne da ba yaŋ niiŋ daaba komma‑i da ba hã-ba. ");
INSERT INTO cmeNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ku huoŋgu-na, *Yuifubaa-ba namba ji jo; banamba hilaa Ikoniyɔmu, banamba hel Ãntiyɔsi maŋ Pisidi mara‑i-na. Baŋ juɔ, baa gbo nuɔmba‑i Polbaa-ba-na. Ba sire ta ba naŋ Pol baa tãmpɛ̃lɛ̃iŋa wuɔ ba ko-yo. Huɔŋgu naŋgu juɔ hi, ba da niɛ sĩ u kuu, baa bũul-o hel baa-yo nelle-na ka nanna. ");
INSERT INTO cmeNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Diiloŋ-dũŋ-baamba kã ka tigiiŋ u caaŋgu-na, wuɔ sire ba bir suur nelleŋ-huɔŋga-na. Ku cuo kaala‑i-na, Pol wuɔ ta baa Barnabasi‑i ta ba kã Dɛrbu. ");
INSERT INTO cmeNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Baŋ kaa hi, baa waŋ *Neldɔdɔlma‑i baa Dɛrbutaamba‑i. Nuɔmba fɔ̃ŋgũɔ baa hũu-ma. Baŋ siire Dɛrbu‑i-na, baa bir kã Lisire‑i-na ka cor kã Ikoniyɔmu. Baŋ hilaa Ikoniyɔmu‑i-na, baa kã Ãntiyɔsi maŋ Pisidi mara‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ba waa da ba cor terieŋgu terieŋgu, ba ta ba piiye ba dii sirɛiŋa Diiloŋ-dũŋ-baamba-na wuɔ ba bel Yesu maama‑i nammu hãi. Aa bi ta ba piiye baa-ba wuɔ: «I saaya i mulĩɛŋ da dɛi aa suɔ diɛ suur *Diiloŋ-nelle‑na.» ");
INSERT INTO cmeNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Diiloŋ-dũŋ-baamba maŋ waa hiere nilɛiŋa faŋa-na, Polbaa-ba hiel yaataamba bɛi aa dii sũŋgu, aa cãrã Itieŋo‑i hã-ba, ba haa ba naŋga‑i u yaa nuɔ‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Baŋ ciɛ mafamma‑i, baa sire karnu Pisidi mara‑i a kã Pãnfili mara nuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Baŋ kãa Pãnfili‑i-na, baa waŋ Diiloŋ-nelma‑i Pɛrge‑i-na, aa cor kã Atali ");
INSERT INTO cmeNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","ka biɛ baatoŋo‑i ta ba kã Ãntiyɔsi maŋ Siiri‑i-na. Ba wuɔsaaŋgu duɔŋ kusuɔŋ-nu'i. Baŋ wuɔraaya ce mamaŋ daama‑i hiere, ba cãarã Diiloŋo‑i hã-ba kusuɔŋ-nu'i aa ba suɔ ta. ");
INSERT INTO cmeNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Diiloŋ uŋ kãayã-bɛi ba ce mamaŋ hiere, baŋ kãa ka hi, baa tigiiŋ Diiloŋ-dũŋ-baamba‑i hiere tũnu-bɛi baa-ma, aa uŋ bi kãayã *niɛraamba‑i dumaa ba hũu Yesu maama‑i, baa tiraa waŋ mafamma‑i baa-ba. ");
INSERT INTO cmeNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Baŋ ciɛ mafamma‑i, baa tĩɛna ce huɔŋgu baa-ba cɛllɛ. ");
INSERT INTO cmeNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Nuɔmba naŋ baa hilaa *Yude‑i-na jo Ãntiyɔsi‑i-na ji ta ba piiye baa *niɛraamba maŋ hũyãa Yesu maama‑i wuɔ: «Da na saa *jã ŋaa *Moisi *ãnjĩnammaŋ waaŋ-ma dumaa, na siɛ gbãa kor.» ");
INSERT INTO cmeNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pol baa Barnabasi‑i ba saa hũu-ma baa-ba. Kuɔ sire bel vaa. Diiloŋ-dũŋ-baamba ji naa ba hiel Pol baa Barnabasi‑i a naara terieŋgu faŋgu taamba namba, wuɔ ba kã *Yerusalɛmu‑i-na ka hi Yesu *pɔpuɔrbiemba‑i baa yaataamba‑i baa-ma. ");
INSERT INTO cmeNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Aa naa tigiiŋ ba hũmelle‑i hã-ba; ba sire ta. Ba kãmma-na, ba curaa baa Fenisi, a kã ka hel *Samari. Niɛraambaŋ hũyãa Itieŋo maama‑i dumaa, da ba hi nelle nelle, ba tũnu Diiloŋ-dũŋ-baamba‑i baa-ma aa cor. Da ba waŋ-ma baa bamaŋ, ku gbuu fũnuŋ dɔlnu kutaamba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Baŋ kaa hi Yerusalɛmu‑i, Diiloŋ-dũŋ-baamba jãrã-bɛi. Yaataamba waa hiere baa Yesu pɔpuɔrbiemba‑i. Diiloŋ uŋ kãayã Polbaa-ba ce mamaŋ hiere, baa tũnu-bɛi baa-ma. ");
INSERT INTO cmeNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Baŋ juɔ piiye tĩ, *Farisĩɛbaa-ba maŋ hũyãa Yesu maama‑i ba hɔlma-na, banamba sire wuɔ niɛraamba maŋ hũyãa Yesu maama‑i, ba saaya ba jã aa ta ba wuɔ Moisi ãnjĩnamma hũmelle‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Baŋ piiye dumaaŋo-na, Yesu *pɔpuɔrbiemba‑i baa yaataamba da ba-naa ku ãndaaŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ãndaaŋ daaku waa pãnna cor. Piɛr wuɔ ji naa u sire yiɛra aa naa cira: «Tobiŋ namaa, na suyaa wuɔ dii ku domma-na Diiloŋ uŋ hielaa-mi na hɔlma-na wuɔ mi ka waŋ *Neldɔdɔlma‑i baa *niɛraamba‑i ba nu-ma aa hũu-ma. ");
INSERT INTO cmeNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Fuɔ maŋ suyaaŋ nuɔmba kusũnni‑i, da na da u hãa-ba u *Yalle‑i ŋaa uŋ hãa miɛŋo‑i baa-de dumaa, kuu dii ŋaa u pigãaŋ wuɔ u hũyãa-ma ba da ba piɛ-yo. ");
INSERT INTO cmeNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Diiloŋo kãŋ-ye kuuduɔŋgu hiere baa-ba. Ba hũyãa u maama‑i ku'i ciɛ u hur ba ãmbabalma‑i aa yaŋ-ba welewele waaŋ daama temma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Coŋgoruoŋgu maŋ i bĩncuɔmba saa gbãa tũu-ku, miɛ fɛrɛ‑i i saa gbãa tũu-ku, bige‑i ciɛ na'a i haa-ku hã niɛraamba‑i baa-ku? Baa na feŋ Diiloŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","I hũyãa-ma wuɔ Yesu kuraa-ye gbãŋgbãŋ, kuuduɔŋgu yaa baa bafamba‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Piɛrŋ piiye dumaaŋo-na, terieŋgu ce da sensenseŋ ŋaa molo si dii. Diiloŋ uŋ kãayã Pol baa Barnabasi‑i ba ce nelma maŋ hiere niɛraamba hɔlma-na, ka hel baa gbɛrɛ-wɛima‑i, bafaŋ baa suur ma yaaŋga-na ta ba waŋ-ma. ");
INSERT INTO cmeNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Baŋ juɔ piiye tĩ, Sake wuɔ cira: «Tobiŋ namaa, niɛŋ, ");
INSERT INTO cmeNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","dii ku domma-na, Diiloŋ uŋ curaa corma maŋ duɔ hiel niɛraamba namba ce-ba fuɔ baamba, Simɔ waaŋ ma yaaŋga‑i hiere baa-ye. ");
INSERT INTO cmeNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Kuŋ curaa corma maŋ, ku juɔ ji ce kuuduɔŋgu baa *Diilopɔpuɔrbiemba nelma‑i. Diilopɔpuɔrbiemba nyɛgãaŋ wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Itieŋo ciɛra: ‹Yiiŋgu dii baa yiiŋgu, mi ka bir jo. Da mi jo, *Davidi dũŋgu maŋ cii, mi ka sire-kuɔ. Mi ka migãaŋ-ku ma-ku ku yiɛra ku gbeiniŋ. ");
INSERT INTO cmeNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Mafaŋ da ma ce, nuɔmba maŋ saa hi suɔ-mi yogo, ba ka taara-miɛ suɔ-mi. Miŋ bĩɛ bamaŋ nilɛiŋa-na hiere da mi ce-ba mi baamba, ba ka ta ba taara ba Tieŋo‑i. Muɔmɛi waaŋ-ma dumaa. Da mi waŋ mamaŋ, mi ce-ma. ");
INSERT INTO cmeNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Aa miŋ waaŋ-ma ku bãaŋgu cuɔ.›» ");
INSERT INTO cmeNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Sake wuɔ suonu u ãndaaŋgu‑i wuɔ: «Ku'i ciɛ na da niɛraamba maŋ cuu Itieŋo huoŋ-nu, mɛi sa taara i mulĩɛŋ-ba. ");
INSERT INTO cmeNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ŋga mamaŋ dii cemma, i nyɛgɛ̃ŋ sɛbɛ a waŋ baa-ba wuɔ ba yaŋ cufĩɛŋ-kũɔma wuoma‑i, baa bĩmbaamba maŋ ba saa cãa ba nonni‑i, ka hel baa tãmma‑i hiere. Aa ba hiel ba naŋga bĩŋwosĩnni-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Na saa da, a doŋ dii i bĩncuɔŋ-bãaŋ-nu, *Moisi *ãnjĩnamma waŋ nilɛiŋa-na hiere, aa ba sa nanna *yitĩɛnaŋgu baa ma kalamma‑i *Diilonelhãalãdũnni-na.» ");
INSERT INTO cmeNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Sakeŋ juɔ piiye dumaaŋo-na, Yesu pɔpuɔrbiemba‑i baa Diiloŋ-dũŋ-baamba‑i, ka hel baa ba yaataamba‑i hiere, baa cira ba ka hiel nuɔmba ba hɔlma-na a puɔr-ba baa Polbaa-ba‑i Ãntiyɔsi‑i-na. Aa naa sire hiel yaataamba hãi; Silasi baa *Yuda. Yuda yerre nande yaa waa Barsabasi. ");
INSERT INTO cmeNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Baŋ hielaa-ba, baa nyɛgɛ̃ŋ sɛbɛ‑i hã-ba. Sɛbɛ huɔya-maama yaa daa-ma: «I natobiŋ namaa namaŋ niɛraaŋ namaaŋo‑i Ãntiyɔsi‑i-na, baa Siiri‑i-na, baa Silisi‑i-na, i jaalaa-na. Yesu pɔpuɔrbieŋ miɛŋo‑i a naara *Yerusalɛmu Diiloŋ-dũŋ-baamba yaataamba‑i, miɛmɛi nyɛgãaŋ sɛbɛ daayo‑i diɛ hã-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","I nuɔ wuɔ i nelleŋ-baamba namba kãa na terieŋgu-na ka piiye cu na hɔmmu‑i. Baa na tie holle, miɛ saa puɔr-ba. ");
INSERT INTO cmeNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Iŋ nuɔ-ma, i daa i-naa aa hiel nuɔmba diɛ puɔr-ba na wulaa. Kutaamba ka gbonu baa Pol baa Barnabasi‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Ba yaa i jɛ̃naamba. Ba siyaa kuliiŋgu‑i Itieŋo‑i Yesu-Kirsa maama-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","I hielaa Yuda baa Silasi ba da ba ka waŋ iŋ nyɛgãaŋ mamaŋ sɛbɛ‑i-na hã-na baa ba fɛrɛŋ nunni. ");
INSERT INTO cmeNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","*Diiloŋ-Yalle‑i baa miɛ fɛrɛ‑i i sa taara i haa coŋgoruoŋgu naŋ temma hã-na, ŋga mamaŋ siɛ gbãa ciɛl kɔtuɔŋgu ma yaa daa-ma: ");
INSERT INTO cmeNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Na hiel na naŋga cufĩɛŋ-kũɔma wuoma-na, baa bĩmbaamba maŋ ba saa cãa ba nonni‑i, baa tãmma‑i. Aa na ne bĩŋwosĩnni‑i aa na yaŋ-ni. Da na ce-ma ŋaa iŋ waaŋ-ma dumaa, ku ka fa. I ka waa Diiloŋ-yiiŋgu.» ");
INSERT INTO cmeNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Ba taa baa sɛbɛ‑i ku yaa nuɔ‑i, kã ka hi Ãntiyɔsi‑i; ba tigiiŋ Diiloŋ-dũŋ-baamba‑i hiere a hã-ba baa-yo. ");
INSERT INTO cmeNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Diiloŋ-dũŋ-baamba hũu-yo kalaŋ-yo. Baŋ kalaaŋ-yo, u huɔya-maama gbuu silaa dɔlnu-bɛi hiere ŋaa bige‑i! Ba kũɔma pãŋ firnu. ");
INSERT INTO cmeNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yuda‑i baa Silasi‑i ba waa *Diilopɔpuɔrbiemba, baa piiye nelma bɔi baa Diiloŋ-dũŋ-baamba‑i a dii sirɛiŋa bɛi ba migãaŋ bel Yesu maama‑i nammu hãi. ");
INSERT INTO cmeNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Ba daa huɔŋgu cɛllɛ baa-ba aa suɔ da ba bir kũŋ. Baŋ'a ba ta yiiŋgu-na, Diiloŋ-dũŋ-baamba gbuu jaal-ba da dɛi aa hã-ba hũmelle‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Baŋ hãa-ba hũmelle‑i, Silasi saa ta. ");
INSERT INTO cmeNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pol baa Barnabasi‑i bafamba waa tĩɛna Ãntiyɔsi ta ba waŋ Itieŋo maama‑i. Nuɔmba bɔi waa baa-ba naara. ");
INSERT INTO cmeNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Huɔŋgu naŋgu juɔ hi, Pol wuɔ gbɛ̃ Barnabasi‑i wuɔ: «Iŋ curaa waŋ Itieŋo maama‑i nilɛiŋa maŋ nuɔ‑i hiere, yaŋ i bir i kã-yɛi i ka ne bamaŋ hũyãa-ma baŋ yeŋ mamaŋ nuɔ‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabasi wuɔ tuɔ taara ba kã baa Nsãa maŋ ba naŋ bĩŋ-yoŋ Marke‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Pol saa hũu-ma, wuɔ uu naa kã baa-ba aa ka bir aa yaŋ-ba dii Pãnfili. ");
INSERT INTO cmeNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Kuɔ sire bel vaa. Ba saa ji nunu ba-naa, ba naa ba bɔrɔ. Barnabasi wuɔ biɛ Marke‑i ba kã ka biɛ baatoŋo ta ba kã Sipire. ");
INSERT INTO cmeNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Diiloŋ-dũŋ-baamba cãrã Diiloŋo‑i hã Pol aa u biɛ Silasi‑i ba ta. ");
INSERT INTO cmeNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ba wuɔraaya bĩŋ Siiri nilɛiŋa-na hiere baa Silisi waaŋa‑i ta ba dii sirɛiŋa Diiloŋ-dũŋ-baamba‑na. ");
INSERT INTO cmeNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pol baa Silasi‑i baŋ taa dumaaŋo-na, ba kã ka hel Dɛrbu, cor ka hel Lisire. A ne da Yesu wuoŋo naŋo waa nelle fande-na, ba taa ba bĩ-yo Timote. U nyu waa *Yuifuyiɛŋo aa hũu Yesu maama‑i aa u to‑i Girɛkiyiɛŋo. ");
INSERT INTO cmeNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Tobimba maŋ waa Lisire‑i-na baa Ikoniyɔmu‑i-na, ba taa ba bĩ Timote yefafalle. ");
INSERT INTO cmeNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pol wuɔ tuɔ taara u ta baa-yo. A ne da Yuifubaa-ba maŋ waa terieŋgu-na, baa suyaa wuɔ Timote to‑i Girɛkiyiɛŋo. Pol wuɔ naa u *jã-yo aa ba suɔ ta. ");
INSERT INTO cmeNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Yesu *pɔpuɔrbiemba‑i baa *Yerusalɛmu Diiloŋ-dũŋ-baamba yaataambaŋ yiɛraaya nelma maŋ nuɔ‑i, Polbaa da ba cor terieŋgu terieŋgu, ba waŋ ma yaa‑i baa Diiloŋ-dũŋ-baamba‑i; aa cira ba wuɔ ma hũmelle‑i ŋaa baŋ waaŋ-ma dumaa. ");
INSERT INTO cmeNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Yinniŋ taa ni cor dumaa, Diiloŋ-dũŋ-baamba taa ba naŋ kaasĩnni Diiloŋ-hũmelle-na dumɛi, aa bi ta ba ciinu ba kã. ");
INSERT INTO cmeNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Ku huoŋgu-na, Polbaa-ba ji ta ba taara ba ka waŋ Diiloŋ-nelma‑i *Asi nilɛiŋa-na. *Diiloŋ-Yalle saa hũu-ma. Ba naa ba karnu Firgi mara‑i cor baa Galasi wuoŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Baŋ kaa piɛ Misi‑i, baa ta ba taara ba kã Bitini. Yesu Yalle saa hũu-ma. ");
INSERT INTO cmeNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Ba naa ba karnu Misi‑i cor, a kã ka hi Torasi. ");
INSERT INTO cmeNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Isuɔŋgu naŋgu-na, Pol wuɔ dãnsã da Maseduɔniyiɛŋo naŋo juɔ ji yiɛra tuɔ cãrã-yuɔ wuɔ u kã ka kãyã-bɛi dii Maseduɔni‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Yiɛ pãŋ suɔ yiɛ Diiloŋo taara i ka waŋ *Neldɔdɔlma‑i baa Maseduɔnitaamba‑i. I saa tiraa tĩɛna, yiɛ pãŋ sire tiɛ tigiiŋ i hũmelle‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Iŋ juɔ'a i ta yiiŋgu maŋ nuɔ‑i Torasi‑i-na, yiɛ biɛ baatoŋo‑i pãŋ kar vii Samotirase, ka hiire. Iŋ hii yiiŋgu maŋ nuɔ‑i, ku cuo kaala‑i-na, yiɛ cor kã Neyapolisi. ");
INSERT INTO cmeNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Iŋ siire terieŋgu-na, yiɛ kã Filipu ka tĩɛna da yinni terieŋgu faŋgu-na. Filipu yaa waa nebuɔ‑i Maseduɔni‑i-na. *Oromɛbaa-ba'i waa tĩɛna terieŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Iŋ kãa Filipu‑i-na, *yitĩɛnaŋguŋ juɔ hi, yiɛ hel nelleŋ-huɔŋga-na a kã kaaŋgu naŋgu nuŋgu-na. Ii naa suɔ wuɔ Diilojaalterieŋgu ka waa terieŋgu-na. Iŋ kãa, yiɛ da caamba namba; yiɛ tĩɛna piiye baa-ba. ");
INSERT INTO cmeNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Unaŋo waa ba hɔlma-na, ba taa ba bĩ-yo Lidi. U taa u hel Tiyatire. U taa u suor nelbɔ̃mbɔ̃ŋ ba kompammu aa u taa u kuye Diiloŋ-kũŋgu‑i. Iŋ kãa ka tiɛ piiye dumaaŋo-na, wuɔ kar u tũŋgu‑i tuɔ nu iŋ waŋ mamaŋ. Polŋ waaŋ mamaŋ hiere, Itieŋ wuɔ kãyã-yuɔ ma suur u tũnni-na dɛi. ");
INSERT INTO cmeNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Maŋ suurii u tũnni-na dɛi dumaaŋo-na, wuɔ ce ba *batiseŋ-yo baa u dumɛlleŋ-baamba‑i hiere aa naa gbɛ̃-ye wuɔ: «Da kuɔ na hũyãa-ma wuɔ mi hũyãa Itieŋo maama‑i kelkel, juɔŋ na ji har mɛi terieŋ-nu.» Aa naa gbãŋ baa-ye i ji hũu-ma. ");
INSERT INTO cmeNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Yiiŋgu naŋgu-na, i taa i kã Diilojaalterieŋgu-na a suu baa maacembiloŋo naŋo. Maacembiloŋ daayo‑i, *jĩna waa u yuŋgu-na a ce u tuɔ suɔ mamaŋ juɔŋ u waŋ-ma. U taa u da gbeiŋa bɔi kufaŋgu-na u hã bamaŋ biyaa-yo maacemma-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Maacembiloŋ daa wuɔ cu i huoŋ-nu tuɔ piiye da gbagaga wuɔ: «Balaŋ daaba cãa Dɔrwuoŋo. Ba pigãaŋ-na koŋkor-hũmelle yaa‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","U ciɛ kufaŋgu‑i da yinni bɔi i huoŋgu-na. Pol huɔŋga ji guɔla baa-yo. Wuɔ waŋ baa u jĩna‑i wuɔ: «Yesu-Kirsa yerre-na, cor ŋ hel ciɛŋo-na!» Terduɔŋgu faŋgu-na, jĩna wuɔ pãŋ yaŋ ciɛŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","U taambaŋ juɔ da u sa tiraa u da bĩŋkũŋgu u hã-ba, baa bel Pol baa Silasi‑i kã baa-ba ãndacetaamba wulaa dii gɛ̃ŋgɛrterieŋgu-na ");
INSERT INTO cmeNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","ka hã *Oromɛ ba fãamaambaa-ba‑i baa-ba aa cira: «*Yuifubaa-ba'i daaba‑i, ba juɔ ji ta ba guɔl nelle‑i ba hã-ye. ");
INSERT INTO cmeNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Ba juɔ baa hũmefɛlɛnde. A ne da hũmelle fande nyaa Oromɛbaa miɛŋo‑i: I siɛ gbãa siɛ-de, i siɛ bi gbãa wuɔ-de.» ");
INSERT INTO cmeNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Baŋ piiye dumaaŋo-na, nuɔmba maŋ waa hiere, baa sire wuɔ ba siɛ yaŋ Polbaa-ba‑i. Fãamaambaa-ba ce ba col ba joŋgorbaa-ba‑i aa hã-ba hũmelle‑i wuɔ ba muo-ba. ");
INSERT INTO cmeNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Baa fũnuŋ muo-ba da dɛi aa kã ka dii-ba kaso. Baŋ diyaa-ba, baa waŋ baa umaŋ niɛyaŋ kasobiemba‑i wuɔ u tuɔ ne-ba dɛi. ");
INSERT INTO cmeNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Naacolŋ uŋ nuɔ mafamma‑i, wuɔ kã baa Polbaa-ba‑i dubiloŋo maŋ dii tuogbuole-na ka sɔgɔlnu ba gbeini‑i daaŋgu naŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Isuɔholleŋ juɔ hi, Pol baa Silasi‑i baa ta ba cãrã Diiloŋo‑i aa ta ba hãl nɛini ba tuɔlnu-yuɔ. Kasobiemba namba waa dii ba dũnni-na aa ta ba fara ba nu. ");
INSERT INTO cmeNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Ba juɔ'a ba suɔ, da hĩɛma sagalaaya hɔduɔŋgu, ka hel baa kasodũŋgu‑i hiere! Dũnfenni pãŋ puur. Baŋ ŋa naa vaa kasobiemba‑i baa jɔlgɔbaa-ba maŋ, ba fir hiere. ");
INSERT INTO cmeNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Umaŋ taa u niya kasobiemba‑i u taa u duɔfũŋ; wuɔ cɛ̃. Wuɔ u ne da dũnfenni puurii hiere. Wuɔ fa u taacɛrɛŋo‑i hiel-o duɔ ko u fɛrɛ wuɔ sĩ kasobiemba gbaraa hiere. ");
INSERT INTO cmeNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Pol wuɔ kaasĩŋ wuɔ: «Baa ce ŋ fɛrɛ gbomma, molo saa kã terieŋgu!» ");
INSERT INTO cmeNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Naacolŋo kũɔma nyɛŋ dumaa ma fɛrɛŋ nuɔ. Wuɔ ce ba hã-yo dãamu; u gbar kã ka dũuna Polbaa-ba caaŋgu-na ");
INSERT INTO cmeNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","aa cira ba hel gɔ̃ŋgũɔŋ-nu. Baŋ hilaa, wuɔ yuu-ba wuɔ: «Mi jɛ̃naaŋ namaa, muɔmi saaya mi ce bige‑i a gbãa da mi kor?» ");
INSERT INTO cmeNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Baa cira: «Da ŋ hũu Itieŋo‑i Yesu maama‑i, ku yaa gbãa kor-ni baa ŋ dumɛlleŋ-baamba‑i hiere.» ");
INSERT INTO cmeNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Aa naa doŋ ta ba waŋ Itieŋo maama‑i baa-yo baa u dumɛlleŋ-baamba‑i hiere. ");
INSERT INTO cmeNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Isuɔduɔŋgu faŋgu-na, wuɔ kã baa-ba ka saar ba pãnni‑i aa naa pãŋ ce ba *batiseŋ-yo baa u baamba‑i hiere. ");
INSERT INTO cmeNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Baŋ juɔ batiseŋ-ba tĩ, wuɔ kã baa Polbaa-ba‑i u dumɛlle-na ba ka wuo niiwuoni. Uŋ hũyãa Yesu maama‑i baa u baamba‑i hiere, ba hɔmmu gbuu pãŋ fɛ̃ da yogogo. ");
INSERT INTO cmeNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Cuoŋ juɔ kaal, fãamaambaa-ba puɔr sorosibaa-ba ka waŋ baa kasobiemba niyatieŋo‑i wuɔ u nanna Polbaa-ba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Naacolŋ wuɔ kã ka cira: «Pol, fãamaambaa-ba puɔraa ba jo wuɔ mi nanna-nɛi. Hilaaŋ na kã na muŋkãmmu.» ");
INSERT INTO cmeNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Pol wuɔ yagar aa naa gbɛ̃ sorosibaa-ba‑i wuɔ: «Ku ciɛ niɛ ba bel-e ba saa bi yuu-ye, ba muo-ye nuɔmba-na ŋ siɛ suɔ wuɔ Oromɛbaa miɛ, aa jo ji dii-ye kaso. Fiɛfiɛ‑i, ba ta ba taara ba fuo nanna-yiɛ! Ma siɛ gbãa wuɔ dumaaŋo-na! Kãaŋ na ka waŋ baa-ba wuɔ ba jo ba fɛrɛ ba ji hiel-e.» ");
INSERT INTO cmeNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","A ne da fãamaambaa-ba saa naa suɔ wuɔ Pol baa Silasi‑i Oromɛbaa. Sorosibaa-baŋ kãa ka hi-ba baa nelma‑i, ba kũɔma pãŋ ta ma nyɛŋ. ");
INSERT INTO cmeNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Baa sire jo ba wulaa ji cãrã-bɛi aa ce ba hel kaso‑i-na. Baŋ hilaa, baa cãrã-bɛi wuɔ ba ce jande aa ba hel nelle-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Baa ta kã Lidi terieŋ-nu; kã ka da Diiloŋ-dũŋ-baamba‑i. Baa piiye dii sirɛiŋa bɛi aa naa cãrã hũmelle‑i ta. ");
INSERT INTO cmeNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pol baa Silasi‑i baŋ taa Filipu‑i-na, baa cor baa Ãnfipolisi, kã ka hel Apoloni a suɔ ta ba kã Tesalonike‑i-na. *Diilonelhãalãdũŋgu waa baa *Yuifubaa-ba‑i nelle fande-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","A ne da Pol sa da Diilonelhãalãdũŋgu aa cor-ku. Wuɔ kã ka suur a tuɔ firnu Diiloŋ-nelma‑i baa-ba. U ciɛ mafamma‑i *yitĩɛnanni siɛi. ");
INSERT INTO cmeNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","U tagaaya pigãaŋ-ba wuɔ *Koŋkortieŋo naa saaya u mulĩɛŋ aa ku. Aa duɔ ku, Diiloŋo sire-yuɔ. Aa Koŋkortieŋo faŋo yaa Yesu maŋ uŋ waŋ u maama‑i baa-ba. ");
INSERT INTO cmeNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Polŋ piiye dumaaŋo-na, Yuifubaa-ba namba hũu-ma cu ba huoŋ-nu fuɔ baa Silasi‑i, a naara Girɛkibaa-ba maŋ taa ba kuye Diiloŋ-kũŋgu‑i ba bɔi bi cuu ba huoŋ-nu, baa caamba bɔi. Caamba famba waa nelbɔ̃mbɔ̃mbaa. ");
INSERT INTO cmeNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ku saa dɔlnu Yuifubaa-ba namba‑i. Baa ce-ku nenemuŋgu aa wuɔra taara naŋgalbaa a tigiiŋ nuɔmba‑i ta ba wuɔra ba ce ijieni ba du nelle‑i. Aa naa kũɔl ba-naa kã Yasɔ̃ dumɛlle-na wuɔ ba ka bel Polbaa-ba‑i ka hã fãamaambaa-ba‑i baa-ba. Polbaa-ba naa har kusuɔŋ-nu'i. ");
INSERT INTO cmeNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ba kãa ku yaa‑i ba saa ka da-ba. Baa bel Yasɔ̃ yaa‑i baa Diiloŋ-dũŋ-baamba namba kã baa-ba fɔ̃ŋgɔ̃taamba wulaa ka ta ba piiye da gbagaga wuɔ: «Balaŋ daaba wuɔraaya du nilɛiŋa‑i hiere, ba hii bande yaa fiɛfiɛ‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Yasɔ̃ yaa haraa-ba u dumɛlle-na. Ba maacemma saa fa; ba yagaraa *jãmatigi nuŋgu‑i aa ta ba piiye wuɔ jãmatigi naŋo dii, kɛrɛ ba bĩ-yo Yesu.» ");
INSERT INTO cmeNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Nel daama saa dɔlnu nuɔmba‑i baa fɔ̃ŋgɔ̃taamba‑i hiere. ");
INSERT INTO cmeNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Yasɔ̃baa-ba juɔ pã gbeibuɔ hã-ba aa ba suɔ nanna-bɛi. ");
INSERT INTO cmeNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ku isuɔŋgu-na, Diiloŋ-dũŋ-baamba ce Polbaa-ba ta kã Bere. Baŋ hii, baa kã *Yuifu ba *Diilonelhãalãdũŋgu-na ka ta ba waŋ Diiloŋ-nelma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Yuifubaa-ba maŋ waa Bere‑i-na baa naa fa yaŋ bamaŋ waa Tesalonike‑i-na. Diiloŋ-nelma numma taa ma dɔlnu bafamba‑i ŋaa bige‑i! Yinni maŋ joŋ ba kalaŋ-ma ba ne da kuɔ Polŋ waŋ mamaŋ baa-ba ma yaaŋga yaa‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Nuɔmba bɔi baa hũyãa Yesu maama‑i ba hɔlma-na. Aa Girɛkibaa-ba maŋ bi waa, ba fɔ̃ŋgũɔ baa hũyãa-ma. Caamba waa-bɛi. Caamba famba waa nelbɔ̃mbɔ̃mbaa. ");
INSERT INTO cmeNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Yuifubaa-ba maŋ waa Tesalonike‑i-na baŋ juɔ nu wuɔ Pol kãa Bere‑i-na ka tiraa tuɔ waŋ Diiloŋ-nelma‑i, baa sire nyaa u huoŋ-nu wuɔ ba ka du terieŋgu‑i aa gbo nuɔmba‑i yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Diiloŋ-dũŋ-baambaŋ daa-ma dumaaŋo-na, baa kã baa Pol dãmmaŋ-nuoraaŋgu-na ka biɛ baatoŋo ta, aa yaŋ Silasi yaa baa Timote‑i Bere‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Ba saaŋ Pol ka hi Atɛni aa bir. Baŋ'a ba bir, wuɔ puɔr-ba wuɔ ba ka waŋ baa Silasi‑i baa Timote‑i ba jo u wulaa donduo. ");
INSERT INTO cmeNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Polŋ tĩɛnaana Atɛni‑i-na tuɔ cie Silasi‑i baa Timote‑i, duɔ cor kusuɔŋ-nu, u da cufɛ̃llu, a cor kusuɔŋ-nu, u da tĩnni; kuɔ gbuu fũnuŋ ta ku kukul-o. ");
INSERT INTO cmeNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","A ce duɔ kã *Diilonelhãalãdũŋgu-na, u waŋ ma yaa‑i baa *Yuifubaa-ba‑i baa *niɛraamba maŋ taa ba kuye Diiloŋ-kũŋgu‑i. Aa yiiŋgu yiiŋgu, duɔ kã nelleŋ-huɔŋga-na ka da bamaŋ, u bi piiye baa-ba. ");
INSERT INTO cmeNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Bamaŋ naa ciɛ Epikure ba kalaŋo‑i baa Sitoyisi ba kalaŋo‑i kã yaaŋ-na, yiiŋgu naŋgu-na, banamba jo ji ta ba piiye baa Pol. Banamba ta ba yuu ba-naa wuɔ: «Ãndapirrentieŋ daa u waŋ wuɔ niɛ?» Bamaŋ naa nuɔ Polŋ piiyeŋ Yesu maama‑i baa kuomba siremmaŋ-kũŋgu‑i, baa cira: «Ku biyaa ŋaa u piiye Diilohũmefɛlɛndeŋ-maama.» ");
INSERT INTO cmeNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Baŋ piiye dumaaŋo-na, baa bel Pol kã baa-yo gɛ̃ŋgɛrtaamba wulaa ka cira: «Niŋ juɔ ji ta ŋ piiye hũmefɛlɛnde maŋ maama‑i, i taara i suɔnu kunaŋgu diɛ. ");
INSERT INTO cmeNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Niŋ waŋ mamaŋ, ma ciɛ nerma miɛŋo-na, i taara i suɔ ma yaaŋga‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","A ne da nelfɛlɛmma numma‑i baa ma wamma taa ma dɔlnu Atɛnitaamba‑i baa niraamba maŋ waa ba hɔlma-na ŋaa bige‑i! ");
INSERT INTO cmeNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Pol wuɔ sire yiɛra gɛ̃ŋgɛrtaamba yaaŋga-na aa naa cira: «Atɛnitaaŋ namaa, ma miŋ daa-na damma maŋ, ku biyaa ŋaa cufɛ̃llu sa cor-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Na saa da, mi wuɔramma-na, mi daa na cufɛ̃llu‑i hiere nelleŋ-huɔŋga-na. Aa mi daa ba nyɛgãaŋ dunandu-na wuɔ: ‹Cufɛ̃nerieŋo.› Naŋ buol cufɛ̃nerieŋo maŋ aa na sa suɔ-yo, muɔmi juɔ da mi ji pigãaŋ-na u yaa‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","U yaa Diiloŋo‑i. U yaa hielaa bĩmbĩnni‑i hiere. U yaa dɔrɔ‑i baa hĩɛma‑i ni Tieŋo‑i. Molo siɛ gbãa ma dũŋgu a hã u suur. ");
INSERT INTO cmeNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","U yaa hãaŋ-yeŋ fafalmu‑i i tiɛ fiisa. Bĩŋkũŋgu bĩŋkũŋgu, u yaa hãaŋ nelbiliemba‑i baa-ku, a ce dumaaŋo-na, u sa taara moloŋ napɔrreŋ-bĩŋkũŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","U hielaa siyaabaa-ba‑i hiere nelduɔŋo diei nuɔ ba tĩɛna gbuo hĩɛma‑i hiere. U huɔnu huɔŋgu‑i hã-ba belle-na aa dii yumma ba nilɛiŋa-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","U taara nelbiliemba taara-yuɔ, ku'i ciɛ u ce-ma dumaaŋo-na. Da ku fiɛ balaŋ niɛ niɛ, ŋ gbãa tafũrrã da-yo. Coima saa fa, Diiloŋo saa maa baa-ye. ");
INSERT INTO cmeNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Fuɔ barguɔ yaa nuɔ‑i iŋ yeŋ hĩɛma-na tiɛ gbã i ce i wɛimambaa-ba‑i. Na fãnaamba namba waaŋ ma yaa‑i wuɔ: ‹Diiloŋo bisãlmba namba'i miɛŋo‑i.› ");
INSERT INTO cmeNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Iŋ yeŋ Diiloŋ bisãlŋ miɛ, bige‑i ciɛ da na ce na kul sɛ̃nɛ jĩna wuɔ Diiloŋo yaa dumaaŋo-na? Bige‑i ciɛ da na ce na kul wargbɛ? Bige‑i ciɛ da na ce na sisĩŋ tãmpɛ̃lle jĩna? Diiloŋo‑i nɛliɛ siɛ gbãa suɔ-yo kul-o. ");
INSERT INTO cmeNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Mamaŋ ciɛ cor ku huɔŋgu-na, Diiloŋo sa ne-ma, wuɔ nuɔmba saa ta ba suɔ kuyuŋgu. Fiɛfiɛ‑i-na, u taara nɛliɛŋo nɛliɛŋo, duɔ fiɛ waa hie, u nanna u cilɔbabalaŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Bige‑i ciɛ wuɔ ma ce dumaaŋo-na? U diyaa yiiŋgu duɔ ce nuɔmba‑i hiere ba ãndaaŋgu‑i ku cemma‑i. U hielaa molo duɔ ji ce-ma. U siire kutieŋo‑i hiel-o kuomba hɔlma-na a pigãaŋ wuɔ u yaa hielaa-yo.» ");
INSERT INTO cmeNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Polŋ juɔ cira Diiloŋo siire moloŋo hiel-o kuomba hɔlma-na, banaŋ baa bir yaŋ aa ta ba nyɛ-yo, banaŋ baa cira: «Cie yiiŋgu naŋgu ŋ ji waŋ mafamma‑i baa-ye.» ");
INSERT INTO cmeNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Pol wuɔ ta aa naa yaŋ-ba. ");
INSERT INTO cmeNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Kuŋ fiɛ ce dumaaŋo-na, banamba yagar hũu Yesu maama‑i a cu u huoŋ-nu. Ba hɔlma-na, gɛ̃ŋgɛrtieŋo naŋo waa, ba taa ba bĩ-yo Deni, aa ciɛŋo naŋo bi waa, ba taa ba bĩ-yo Damarisi, a naara nuɔmba namba. ");
INSERT INTO cmeNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Ku huoŋgu-na, Pol wuɔ ji ta Atɛni‑i-na kã Korɛ̃nti. ");
INSERT INTO cmeNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Belle fande-na, *jãmatigi maŋ waa *Ɔrɔmu‑i-na, wuɔ ciɛra *Yuifubaa-ba sire hiere Ɔrɔmu‑i-na. Ba taa ba bĩ-yo Kulodi. A ne da Yuifuyiɛŋo naŋo waa, ba taa ba bĩ-yo Akilasi, u taa u hel Pɔ̃. Ba taa ba bĩ u ciɛŋo‑i Pirsili. Bafamba waa tĩɛna *Itali. Baŋ juɔ cira ba sire, baa sire kã Korɛ̃nti‑i-na. Baŋ kãa, ku saa da huɔŋgu Pol wuɔ kã ka da-ba; wuɔ bel jĩɛru baa-ba. ");
INSERT INTO cmeNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Ba taa ba ce maacenduɔma hiere. Ba taa ba ce kompadũnni. Polŋ wuɔ har ba yaa nuɔ‑i ba ta ba gbonu ba ce maacemma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Da ku waa *yitĩɛnaŋgu‑i, u kã *Diilonelhãalãdũŋgu-na ka tuɔ gbãŋ baa Yuifubaa-ba‑i baa *niɛraamba‑i ba da ba hũu Yesu maama‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Silasi‑i baa Timote‑i baŋ juɔ hel Maseduɔni‑i-na jo, Pol wuɔ yaŋ u maacemma‑i aa fulnu Diiloŋ-nelma wamma yaa yoŋ. U taa u piiye u pigãaŋ Yuifubaa-ba‑i wuɔ Yesu yaa *Koŋkortieŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Baa bir yaŋ aa bigãaŋ-yo aa ta ba tuora-yuɔ. Pol wuɔ muora u joŋgorbaa-ba‑i aa gbɛ̃-ba wuɔ: «Mamaŋ da ma ji da-na, namaa yuŋ-maama‑i; na baa feŋ-mi! Mi ka ta kã niɛraaŋ wulaa.» ");
INSERT INTO cmeNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Uŋ taa terieŋgu-na, wuɔ kã niɛryiɛŋo naŋo cĩiŋgu-na, ba taa ba bĩ-yo Titiyusi-Yutusi. U taa u kuye Diiloŋ-kũŋgu‑i. U cĩiŋgu naa kuo Diilonelhãalãdũŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Umaŋ waa Diilonelhãalãdũŋgu yuŋgu-na, ba taa ba bĩ-yo Kiripusi. Fuɔ wuɔ hũu Itieŋo maama‑i baa u dumɛlleŋ-baamba‑i hiere. Korɛ̃ntitaamba bɔi taa ba hũu Yesu maama‑i Pol wulaa aa ta ba ce ba ta ba *batiseŋ-ba. ");
INSERT INTO cmeNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Isuɔŋgu naŋgu-na, Itieŋo ji piiye baa Pol dãnsãaŋ-nu wuɔ: «Baa kãalã, cor ŋ ta ŋ piiye. ");
INSERT INTO cmeNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Mi dii baa-ni, molo siɛ gbãa ce-ni bĩŋkũŋgu. Mi baamba dii bɔi nel daade-na, ta ŋ piiye.» ");
INSERT INTO cmeNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Pol wuɔ tĩɛna Korɛ̃nti‑i-na tuɔ waŋ Diiloŋ-nelma‑i. U tĩɛnaana ce belle diei baa boluoŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Yiiŋgu naŋgu-na, Yuifubaa-ba ji gbo ba-naa bel Pol kã baa-yo fãamaaŋ ba terieŋ-nu. Umaŋ waa ku huɔŋgu-na Akayi yuŋgu-na, ba taa ba bĩ-yo Galinyɔ. ");
INSERT INTO cmeNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Baŋ kãa baa-yo, baa gbɛ̃-yo wuɔ: «Naacolŋ daa u juɔ baa u deŋ Diilojaale, a ne da di sa kã hũmeduɔle baa *ãnjĩnamma‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pol wuɔ u puur u nuŋgu‑i duɔ piiye, Galinyɔ wuɔ sĩɛŋ-yo cira: «Yuifubaa namaa, kuɔ uu naa ce kuubabalaaŋgu naŋ temma‑i, mii naa ce ãndaaŋgu‑i ku cemma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ŋga naŋ ceŋ na-naa na Diiloŋ-hũmelleŋ-kũŋ-nu, baa yirɛiŋ-kũŋ-nu, baa na ãnjĩnammaŋ-kũŋ-nu, namɛi saaya na fiɛlnu-kuɔ na-naa nuɔ; mɛi nuŋgu sĩ.» ");
INSERT INTO cmeNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Aa naa hiel-ba gɛ̃ŋgɛrdũŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Baŋ hilaa, ba hieroŋo‑i baa bel Diilonelhãalãdũŋgu yuntieŋo‑i ta ba muo-yo gɛ̃ŋgɛrdũŋgu yaaŋga-na. Ba taa ba bĩ naacolŋo‑i Sɔsitɛni. Galinyɔ wuɔ gbuu fĩinaaŋ ce ŋaa u saa da-ba. ");
INSERT INTO cmeNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Ijieŋ daaniŋ ciɛ cor, Pol wuɔ tiraa tĩɛna da huɔŋgu Korɛ̃nti‑i-na. Ku huoŋgu-na, wuɔ ji cãrã hũmelle‑i tobimba wulaa duɔ kã Siiri mara nuɔ; fuɔ baa Akilasi‑i baa u ciɛŋo‑i Pirsili‑i hiere. Wuɔ pãa nuŋgu baa Diiloŋo‑i, a ce dumaaŋo-na baŋ kaa hi Sãŋkire‑i, wuɔ ce ba cir u yuŋgu‑i aa ba suɔ da ba suur baatoŋo-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Baŋ kaa hi Efɛsi‑i, baa bɔrɔ. Pol wuɔ kã *Diilonelhãalãdũŋgu-na ka tuɔ piiye baa *Yuifubaa-ba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Uŋ juɔ'a u ta, baa cãrã-yuɔ wuɔ u yaŋ aa tĩɛna ce yinni cɛllɛ baa-ba. ");
INSERT INTO cmeNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Wuɔ cira: «Yaaŋ mi ta. Diiloŋ duɔ siɛ, mi ka bir jo.» Aa naa ta ka biɛ baatoŋo‑i ka hiire Sesare. ");
INSERT INTO cmeNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Uŋ hiiriiye Sesare‑i-na, wuɔ kã *Yerusalɛmu‑i-na ka jaal Diiloŋ-dũŋ-baamba‑i aa suɔ tuɔ kã Ãntiyɔsi‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Polŋ kãa Ãntiyɔsi‑i-na, wuɔ tĩɛna da huɔŋgu cɛllɛ aa naa tiraa sire biɛ Galasi nilɛiŋa‑i a yuŋ-nu baa Firgi waaŋa‑i tuɔ wuɔra u dii sirɛiŋa bamaŋ cuu Yesu huoŋ-nu hiere. ");
INSERT INTO cmeNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Polŋ taa u wuɔra u dii sirɛiŋa‑i Diiloŋ-dũŋ-baamba-na huɔŋgu maŋ nuɔ‑i, *Yuifuyiɛŋo naŋ wuɔ jo Efɛsi‑i-na, ba taa ba bĩ-yo Apolɔsi. U taa u hel Alɛsãndiri. Naacolŋ daa u taa u suɔ u piiye aa tiraa tuɔ suɔ Diiloŋ-nelma‑i ŋaa bige‑i! ");
INSERT INTO cmeNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","U taa u suɔ Yesu hũmelle‑i aa u taa u hinu pãama baa u nelma wamma‑i. Aa duɔ u waŋ-ma, ma sa ciɛl; ŋ siɛ suɔ wuɔ u taa u suɔ Nsãa *batɛmu yaa yoŋ. ");
INSERT INTO cmeNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Yiiŋgu naŋgu-na, wuɔ gbuu fɛ̃ u huɔŋga‑i baa nelma‑i *Diilonelhãalãdũŋgu-na. Akilasi waa baa u ciɛŋo‑i. Baŋ juɔ hel, baa bĩ-yo ka migãaŋ kaala Diiloŋ-hũmelle‑i baa-yo. ");
INSERT INTO cmeNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Akayi kãmmaŋ-maama waa-yuɔ, Diiloŋ-dũŋ-baamba dii sirɛiŋa yuɔ aa naa nyɛgɛ̃ŋ sɛbɛ hã Akayi Diiloŋ-dũŋ-baamba‑i wuɔ duɔ kã, ba bel-o dɛi. Uŋ kãa, Diiloŋ uŋ ciɛ baa bamaŋ ba hũu Yesu maama‑i, ku kãayã-bɛi bɔi. ");
INSERT INTO cmeNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","U waa duɔ ce u biɛ Diiloŋ-nelma‑i a tagaaya pigãaŋ Yuifubaa-ba‑i nuɔmba-na, wuɔ ba suurii hĩɛŋ-nu, kɛrɛ Diiloŋ uŋ pãa nuŋgu‑i wuɔ u ka saaŋ *Koŋkortieŋo maŋ, u yaa juɔ Yesu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolɔsiŋ waa Korɛ̃nti‑i-na huɔŋgu maŋ nuɔ‑i, Pol wuɔ karnu tãnni‑i kã ka hi Efɛsi‑i. Uŋ kãa, wuɔ da Diiloŋ-dũŋ-baamba namba‑i, ");
INSERT INTO cmeNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","wuɔ yuu-ba wuɔ: «Naŋ hũyãa Yesu maama‑i, na daa *Diiloŋ-Yalle‑i wɛi?» Baa cira: «Ba bĩ bige‑i Diiloŋ-Yalle‑i? I saa nu di maama dede!» ");
INSERT INTO cmeNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Pol wuɔ yuu-ba wuɔ: «Namaa daa *batɛmu hayo‑i?» Baa cira: «Nsãa batɛmu.» ");
INSERT INTO cmeNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pol wuɔ cira: «Bamaŋ naana ba cilɔbabalaŋo‑i Nsãa taa u hã ba yaa‑i u batɛmu‑i aa tuɔ piiye baa nuɔmba‑i wuɔ umaŋ ka jo fuɔ huoŋgu-na, ba haa ba naŋga yuɔ. U taa u gbɛ̃ Yesu yaa‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Polŋ piiye baa-ba dumaaŋo-na, baa ce ba *batiseŋ-ba Itieŋo‑i Yesu yerre-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Baŋ baatiseŋ-ba, wuɔ haa u nammu‑i bɛi aa cãrã Diiloŋo saaŋ u *Yalle‑i hã-ba. Baŋ juɔ da Diiloŋ-Yalle‑i, baa doŋ ta ba piiye nelfɛlɛmma-na. Diiloŋ uŋ diyaa mamaŋ ba nunni-na, baa ta ba waŋ-ma baa nuɔmba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Bamaŋ naa ciɛŋ mafamma‑i, ba gbãa yu nuɔmba cĩncieluo baa ba hãi temma. ");
INSERT INTO cmeNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pol saa tuɔ naa *Diilonelhãalãdũŋgu-na. Duɔ kã, u biɛ *Diiloŋ-bãaŋgu maama‑i a piiye ma yaaŋga‑i baa nuɔmba‑i ba da ba hũu-ma. U nuŋgu saa ta ku ce yelma baa ma wamma‑i. U ciɛ mafamma‑i caamba siɛi. ");
INSERT INTO cmeNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ŋga banamba saa hũu-ma, aa bir ta ba nyɛ Itieŋo hũmelle‑i nuɔmba-na. Polŋ juɔ da ba ce dumaaŋo-na, wuɔ kã baa bamaŋ hũyãa-ma Tiranusi nakoleŋ-cĩiŋgu-na ka tuɔ waŋ Diiloŋ-nelma‑i baa-ba kusuɔŋ-nu'i yinni maŋ joŋ. ");
INSERT INTO cmeNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","U ciɛ mafamma‑i bieŋa hãi. A ce dumaaŋo-na, *Yuifubaa-ba maŋ waa hiere *Asi‑i-na baa *niɛraamba‑i, baa nu Itieŋo maama‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Diiloŋo naa hã Pol himma naŋ temma u tuɔ ce gbɛrɛ-wɛima‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","A ce nyarkpãtãaŋgu maŋ da ku yiɛya Pol kũɔma‑i aa ba haa-ku jɛiŋo maŋ nuɔ‑i, u sire. Jaamba bɔi siire dumaaŋo-na, aa *jĩnabaa-ba bi hilaa nuɔmba bɔi-na dumaaŋo-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","*Yuifubaa-ba namba bi waa ta ba wuɔra ba donya *jĩnabaa-ba‑i ba hiel-ba nuɔmba-na. Yiiŋgu naŋgu-na, baa ji sire wuɔ bafamba cĩŋ Yesu‑i-na aa donya-bɛi ne si ba ka gbãa. Aa naa maa cira: «Polŋ piiyeŋ Yesu maŋ maama‑i, fuɔ yerre-na curaaŋ na hel naacolŋ daayo-na!» ");
INSERT INTO cmeNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Diilojigãntaamba yuntieŋo maŋ ba naŋ bĩŋ-yoŋ Sikeva‑i, fuɔ bɛpuɔmba'i naa ciɛ maacemma famma‑i. Ba waa nuɔmba niehãi. ");
INSERT INTO cmeNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Baŋ piiye dumaaŋo-na, jĩna bir gbɛ̃-ba wuɔ: «Mi suɔ Yesu‑i baa Pol hiere, namaa fuɔ, namaa hilaa hie?» ");
INSERT INTO cmeNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Uŋ waa naacolŋo maŋ nuɔ‑i wuɔ pãŋ diire-bɛi baa muoru. Ma saa ji fa baa gbar. Ba gbaraa hel tãmporni naacolŋo cĩiŋgu-na, baa tãmma‑i nyɛlɛ̃lɛ̃ ba kũɔma-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Korma pãŋ ta ma da Yuifubaa-ba maŋ waa Efɛsi‑i-na hiere baa *niɛraamba‑i, a ce ba sa siɛ bĩ Yesu yerre‑i ãnsɔsɔmma-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Bamaŋ naa hũyãa Yesu maama‑i, baŋ ciɛ guɔyuɔ maŋ cor hiere, ba fɔ̃ŋgũɔ baa ta ba jo ba yiɛra nuɔmba-na ba waŋ-ma a pigãaŋ wuɔ ba siɛ tiraa ce ma temma. ");
INSERT INTO cmeNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Bamaŋ naa bi waa hiriemba‑i, ba fɔ̃ŋgũɔ baa jo baa ba himmaŋ-sɛbɛbaa-ba‑i ji tigiiŋ-ba caa-ba nuɔmba yufelle-na. Baa tagaaya sɛbɛbaa daaba sullu‑i, a da ba yuu bafamba neifieŋ-komorre baa a ndii temma. ");
INSERT INTO cmeNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Itieŋo barguɔ‑i-na, Diiloŋ-nel maa da fɔ̃ŋgũɔ ta ma gbuo terni‑i hiere ma kã. ");
INSERT INTO cmeNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Ku huoŋgu-na, Pol wuɔ ji cira u ka cor kã *Yerusalɛmu. Ŋga aa suɔ duɔ kã Yerusalɛmu‑i-na, u ka cor Maseduɔni igɛ̃na baa Akayi. U taa u bi piiye wuɔ duɔ hi Yerusalɛmu‑i, u saaya u bi kã *Ɔrɔmu. ");
INSERT INTO cmeNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Uŋ puu mafamma‑i dumaaŋo-na, wuɔ saaŋ kakãyãtaamba hãi Maseduɔni‑i-na: Timote baa Erati; aa fuɔ wuɔ tĩɛna *Asi‑i-na a ce yinni cɛllɛ. ");
INSERT INTO cmeNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Kufaŋgu yinni-na, Itieŋo hũmelle kũŋ kuɔ ce nelle sire du. ");
INSERT INTO cmeNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Fãnaŋo naŋo waa tuɔ kul niikulni, ba taa ba bĩ-yo Demetursi. Uu naa biɛ maacenciraamba ta ba kul baa-yo. Tĩiŋgu naŋgu waa Efɛsi‑i-na, ba taa ba bĩ-ku Artemisi. Tĩiŋgu faŋgu dũŋgu‑i, Demetursibaa-ba taa ba kul ku temma baa wargbɛ ba suor. Ba taa ba kũɔl gbeiŋa‑i ku maacemma-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","26","Polŋ kãa ka tuɔ waŋ Yesu maama‑i, Demetursi wuɔ da u gbuonu bafamba saŋga. Wuɔ bĩ u maacenciraamba‑i baa u nafãnaamba‑i hiere a ji tuɔ piiye baa-ba wuɔ: «Naacolŋo maŋ juɔ ji tuɔ wuɔra u piiye daayo‑i, wuɔ ba bĩ-yo Pol; uŋ wuɔraŋ u waŋ mamaŋ na saa bi yaŋ-ma numma. Wuɔ iŋ kul tĩnni maŋ, yuŋgu si dii-niɛ. A ne da miɛ i wuo ma'i nuɔ‑i. Nuɔmba cuu u huoŋ-nu wuɔ u waŋ ninsoŋo. U saa bãl-ku Efɛsi bande yoŋ; u yii duɔ gbuo Asi nilɛiŋa‑i hiere baa nel daama‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Mamaŋ jaaŋ muɔ, ku saa ce ŋaa u yii duɔ bĩɛna hã miɛ yoŋ, ŋga u ka ce Artemisi dũŋgu nuoŋgu hel nuɔmba-na, a ce ba siɛ tiraa ta ba kãŋ Artemisi fuɔ fɛrɛ‑i, a ne da Asitaamba‑i baa nuɔmba‑i hiere miwaaŋo-na ba buol u yaa‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Demetursiŋ piiye dumaaŋo-na, nuɔmba hɔmmu gbuu pãŋ guɔla; baa sire ta ba kaasĩŋ wuɔ: «Efɛsitaaŋ Artemisi temma si dii!» ");
INSERT INTO cmeNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Ijieŋ daa niɛ ce nelle‑i hiere di sire yiɛra di gbeiniŋ. A ne da Maseduɔnitaamba namba naa nyaanu Pol jo. Ba waa ba hãi. Ba taa ba bĩ unaŋo‑i Gawusi aa bĩ unaŋo‑i Aritarke. Baa bel bafamba‑i kã baa-ba ponsanatigerre-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pol wuɔ cira u kã. Diiloŋ-dũŋ-baamba cie-yo wuɔ u baa kã. ");
INSERT INTO cmeNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","U jɛ̃naamba namba bi waa nelbɔ̃mbɔ̃mbaa Asi‑i-na, bafamba puɔr ba ji waŋ baa-yo wuɔ u baa kã. ");
INSERT INTO cmeNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Ijieni saa waa dɛi ponsanatigerre-na: Hooi haai! Hooi haai! Ba fɔ̃ŋgũɔ waa da ŋ yuu-ba, ba siɛ suɔ kumaŋ ciɛ nuɔmba tigiiŋ ba-naa. ");
INSERT INTO cmeNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","*Yuifuyiɛŋo naŋo waa ba hɔlma-na, ba taa ba bĩ-yo Alɛsãndiri. Baa waŋ ma yaaŋga‑i baa-yo aa naa titiire-yuɔ dii-yo nuɔmba hɔlma-na wuɔ u piiye baa-ba. Wuɔ sire u naŋga‑i wuɔ nuɔmba budii. ");
INSERT INTO cmeNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Nuɔmba saa naa suɔ wuɔ Yuifuyiɛŋo. Baŋ juɔ suɔ, baa cor ta ba kaasĩŋ wuɔ: «Efɛsitaaŋ Artemisi temma si dii! Efɛsitaaŋ Artemisi temma si dii!» Ba ciɛ lɛrbaa-ba hãi temma kaasĩŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Kombiyiɛŋo maŋ waa ba nelle-na, u yaa juɔ gbãŋ baa nuɔmba‑i ba budii. Baŋ budii, wuɔ cira: «Efɛsitaaŋ namaa, hai moloŋo‑i dii aa u saa suɔ wuɔ Artemisi dũŋgu‑i baa ku nobiŋo maŋ hilaa dɔrɔ‑i-na diire, miɛ niini? ");
INSERT INTO cmeNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Kutieŋo si dii. Terieŋgu faŋgu-na, na saaya na budii. Aa da na'a na ce kumaŋ, na jɔguɔŋ na ne aa na suɔ na ce-ku. ");
INSERT INTO cmeNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Naŋ siire bel balaŋ daaba‑i ta na jo baa-ba, ba saa bi guɔla bĩŋkũŋgu Artemisi dũŋgu-na, ba saa bi bĩ u yebabalande, na'a i ce-ba niɛ? ");
INSERT INTO cmeNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Demetursi‑i baa u nabaamba‑i, da ba'a ba ka bĩ umaŋ, gɛ̃ŋgɛrtaamba dii, ba bĩ kutieŋo‑i kusuɔŋ-nu'i; ba jĩɛna yinni ta ba ce ãndɛnni‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Da ku bi waa nelma namma dii na wulaa, diɛ ji tigiiŋ i-naa hiere, na jo, i ka fiɛlnu-mɛi. ");
INSERT INTO cmeNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Ni ma'i sĩ, dumandɛ‑i-na, fɔ̃ŋgɔ̃taaŋ da ba bĩ-ye yuu-ye wuɔ: ‹Bige‑i dii nyuŋgo‑i-na aa na tigiiŋ na-naa?› I da hama‑i waŋ-ma aa ba hũu-ma? I ka ce ba da niɛ sĩ i taara i hel ba huoŋ-nu, a ne da ma'i sĩ.» ");
INSERT INTO cmeNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Uŋ waaŋ mafamma‑i, wuɔ ce nuɔmba bɔrɔ kũŋ ba cĩnniŋ. ");
INSERT INTO cmeNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ijieŋ daaniŋ juɔ bãl, Pol wuɔ tigiiŋ Diiloŋ-dũŋ-baamba‑i a dii sirɛiŋa bɛi, aa cãrã hũmelle‑i ba wulaa a ta tuɔ kã Maseduɔni. ");
INSERT INTO cmeNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Uŋ kaa hi, wuɔ tuɔ waŋ Diiloŋ-nelma‑i baa tobimba‑i u dii sirɛiŋa bɛi u kã, ka hi Girɛsi. ");
INSERT INTO cmeNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Uŋ hii Girɛsi‑i wuɔ tĩɛna ce caamba siɛi. Ku huoŋgu-na, u ji tuɔ taara u biɛ baatoŋo‑i kã Siiri. Baa gbuya-yuɔ wuɔ *Yuifubaa-ba taara-yuɔ baa wɛima. Wuɔ yaŋ baatoŋo‑i aa naa bir hel Maseduɔni yaŋga. ");
INSERT INTO cmeNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Bamaŋ taa ba wuɔra baa-yo, ba yirɛiŋa yaa daaya: Sopatɛr waa. Sopatɛr to‑i ba taa ba bĩ-yo Pirusi, ba taa ba hel Bere. Aritarke waa, baa Sekɔ̃ndusi. Bafamba taa ba hel Tesalonike. Gawusi waa, fuɔ taa u hel Dɛrbu. Tisike waa baa Turofimu. Bafamba taa ba hel *Asi. A naara Timote‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Yiɛ ce ba ta yaaŋga ka ta ba cie-ye Torasi. ");
INSERT INTO cmeNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","*Baŋ'a ba sa dii siini‑i *buruo maŋ nuɔ‑i, u ponsaaŋgu naa piɛ tĩ, kuŋ juɔ ce cor tĩ, yiɛ biɛ baatoŋo‑i Filipu‑i-na a nyaa ba huoŋ-nu Torasi‑i-na. I ciɛ yinni ndii hũmelle-na aa suɔ diɛ hi. Iŋ kãa Torasi‑i-na, yiɛ ce yinni niehãi terieŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Sãmadi-dãnambãaŋgu-na, yiɛ tigiiŋ i-naa baa Diiloŋ-dũŋ-baamba‑i diɛ wuo Itieŋo niiwuoni‑i. Pol naa saaya u ta ku cuo kaala‑i-na, a ce dumaaŋo-na u nelma sa tĩ. U piiye ji tuɔ hi isuɔholle. ");
INSERT INTO cmeNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ii naa waa sãŋkãnso dɔrɔ. Iŋ waa dũŋgu maŋ nuɔ‑i, fitĩmbaa-ba waa bɔi kuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Naacombiloŋo naŋo waa baa-ye tĩɛna fɛ̃nɛtiri‑i-na tuɔ nu Pol tuɔ piiye; ba bĩ-yo Etike. Nelmaŋ juɔ'a ma sa tĩ ma tĩ dumaaŋo-na, naacombiloŋ daa wuɔ kor duɔfũŋ. Iŋ juɔ'a i suɔ, u hilaa dii sãŋkãnso dɔrɔ‑i-na a cor dũnni siɛi jo ji diire hĩɛma-na. I kãa ka sire-yuɔ ku yaa nuɔ‑i, a da u kuu. ");
INSERT INTO cmeNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pol wuɔ hiire pãŋ jo ji tũu-yo aa naa cira: «Baa na tie holle, uu dii cicɛ̃lma!» ");
INSERT INTO cmeNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Iŋ birii nyugũŋ kufaŋgu‑i, wuɔ calnu Itieŋo niiwuoni‑i i wuo aa tiraa cor baa u nelma‑i. U piiye dumɛi ji kaal cuo‑i aa suɔ ta. ");
INSERT INTO cmeNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Uŋ siire naacombiloŋo‑i, kuɔ fũnuŋ dɔlnu nuɔmba‑i ŋaa bige‑i! Baa saaŋ-yo kũŋ baa-yo. ");
INSERT INTO cmeNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Iŋ siire Torasi‑i-na, yiɛ kã Asɔsi. Iŋ'a i ta, Pol wuɔ fuɔ ka wuɔ kã. Miɛ yiɛ suur baatoŋ-na ta yaaŋga ka tiɛ cie-yo. ");
INSERT INTO cmeNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Uŋ juɔ jo, wuɔ suur baa-ye yiɛ cor kã Mitilɛni. ");
INSERT INTO cmeNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Iŋ siire Mitilɛni‑i-na yiiŋgu maŋ nuɔ‑i, ku cuo kaala‑i-na, yiɛ kã ka tiɛ hi Kiyɔsi. Iŋ siire Kiyɔsi‑i-na, cuo kaal yiɛ kã ka tiɛ hi Samɔsi. Siɛliŋ-yiiŋgu‑i, i suɔ tiɛ suur Milɛti‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pol taa u taara u hi *Yerusalɛmu‑i donduo a ce *Pãntekɔti‑i kusuɔŋ-nu'i, a ce dumaaŋo-na, wuɔ bella Efɛsi‑i cor; wuɔ duɔ haar ba kaa bella-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Iŋ hii Milɛti‑i, wuɔ puɔr ba ka bĩ Diiloŋ-dũŋ-baamba yaataamba yaa Efɛsi‑i-na ba jo. ");
INSERT INTO cmeNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Baŋ juɔ, wuɔ cira: «Miŋ waa waama maŋ na hɔlma-na ji ta mi ta, na suɔ-ku. ");
INSERT INTO cmeNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Mi saa ce Itieŋo maacemma‑i baa bombolma. Da ku ce kuniɛ mi ji ta mi hiel nyinyɔlma. *Yuifubaa-baŋ haa kumaŋ miɛ, Diiloŋo'i suyaaŋ-kuŋ. ");
INSERT INTO cmeNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Mamaŋ gbãa fa na maama‑i hiere, mi saa fuo ma diei nɛi: Mi waaŋ-ma baa-na puoŋa-na aa tiraa waŋ-ma baa-na na dumiɛŋa-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Mi muyaa mi natiɛŋa Yuifubaa-ba‑na baa *niɛraamba‑i hiere wuɔ ba nanna ba cilɔbabalaŋo‑i a gbãa cu Diiloŋo huoŋ-nu, aa hũu Itieŋo‑i Yesu maama‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Dumandɛ‑i, *Diiloŋ-Yalle ciɛ mi ta mi kã Yerusalɛmu; mi saa suɔ mamaŋ ciyaaŋ-miŋ terieŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Miŋ suyaa mamaŋ, da mi kã terieŋgu terieŋgu, Diiloŋ-Yalle gbuya-miɛ wuɔ ba kaa huol mi yaaŋ-na aa dii-mi kaso. ");
INSERT INTO cmeNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Da mi fiɛ ku, mɛi wulaa wɛima sĩ. Kumaŋ gbãaŋ, miŋ biyaa mi gboluoŋgu‑i mamaŋ nuɔ‑i, mi ce-ma ma cemma‑i. Diiloŋ uŋ ciɛ baa nelbiliemba‑i cemma maŋ, aa Itieŋ wuɔ mi wuɔra waŋ-ma, mi donya ku yaa‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","«Mi curaa na terni-na hiere a waŋ *Diiloŋ-bãaŋgu maama‑i baa-na, ŋga fiɛfiɛ‑i-na, mi suyaa miɛ na siɛ tiraa da mi yufelle. ");
INSERT INTO cmeNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Ku'i ciɛ mi ta mi kuola-mɛi baa-na nyuŋgo‑i-na miɛ nuɔni maŋ da ŋ hũu mi nelma‑i nanna, mɛi yuŋ-maama sĩ. ");
INSERT INTO cmeNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Diiloŋ uŋ taaraŋ kumaŋ, mi waaŋ-ku baa-na hiere, mi saa fuo ma diei nɛi. ");
INSERT INTO cmeNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Bilaaŋ na fɛrɛ fafamma, aa na bi bel Diiloŋ-Yalleŋ hãa-na bamaŋ. Taa na ne Diiloŋ-dũŋ-baamba‑i fafamma. Diiloŋo pãa fuɔ fɛrɛŋ Biɛŋo yaa duɔ gbãa da-ba. ");
INSERT INTO cmeNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Mi suyaa miɛ da mi bir mi huoŋgu‑i, nelbabalaamba ka jo ji suur na hɔlma-na a guɔla-nɛi. Ba sa ce hujarre ŋaa maamunaamba. ");
INSERT INTO cmeNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Namaa fɛrɛ‑i na hɔlma-na, banamba ka sire baa coima‑i a tãal Diiloŋ-dũŋ-baamba cu ba huoŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Terieŋgu faŋgu-na, suyaaŋ na fɛrɛŋ belma, aa na baa yaŋ ma karaanu-nɛi wuɔ mi ciɛ bieŋa siɛi baa-na ta mi dii nelma‑i na tũnni-na bãaŋgu‑i baa isuɔŋgu‑i, kuniɛ mi ji ta mi kaal baa-ma yɛrɛ. ");
INSERT INTO cmeNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","«Fiɛfiɛ‑i-na, mi diyaa-na Diiloŋo naŋ-na aa tiraa dii-na u hujarreŋ-nelma naŋ-na. U yaa gbãa ce na naŋ kaasĩnni u hũmelle-na aa hã-na ciiluŋgu maŋ jĩɛna ta ku cie u baamba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Miŋ waa baa-na, mi saa ji nenu moloŋ warbelle dede, mi saa bi nenu moloŋ nyarkpãtãaŋgu dede. ");
INSERT INTO cmeNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Niɛŋ mi nammu‑i, mi ciɛ maacemma‑i baa mu yaa‑i a yiɛra baa i yuŋ-maama‑i muɔ baa mi nabaamba‑i hiere; namaa fɛrɛ‑i na suyaa-ma. ");
INSERT INTO cmeNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Mi taa mi ce da mi pigãaŋ-na wuɔ na saaya na siɛya na napuɔŋa‑i dumɛi a gbãa da na da kãyã sũntaamba‑i aa yaŋ Itieŋo‑i Yesu nelma ta ma tĩɛnu-nɛi wuɔ: ‹Yudɔdɔlle dii hãmma-na yaŋ hũuma-na.›» ");
INSERT INTO cmeNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Polŋ juɔ piiye tĩ, baa dũuna hiere cãrã Diiloŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Baŋ juɔ ta ba jaal-o aa u duɔ ta, baa naŋ yuŋgu hiere ta ba kaal. ");
INSERT INTO cmeNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Uŋ ciɛra ba siɛ tiraa da u yufelle, ku yaa migãaŋ ce ba ta ba kaal. Baŋ juɔ jaal-o tĩ, baa saaŋ-yo u ka suur baatoŋo-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Iŋ buɔra baa Efɛsi Diiloŋ-dũŋ-baamba yaataamba‑i, miɛ yiɛ ta baa baatoŋo‑i tiɛ kã Kɔsi. Ku cuo kaala‑i-na, yiɛ sire Kɔsi‑i-na a kã Ɔrɔdi. Iŋ siire Ɔrɔdi‑i-na, yiɛ kã Patara. ");
INSERT INTO cmeNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Iŋ kãa Patara‑i-na, yiɛ da baatoŋo naŋo kã Fenisi; yiɛ suur ufaŋo-na a ta. ");
INSERT INTO cmeNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Iŋ kaa piɛ Sipire‑i, yiɛ yaŋ-yo i nanyuɔŋ-nu aa naa bella cor tiɛ kã Tiir, dii Siiri mara nuɔ. Coŋgorni maŋ waa baatoŋo-na, nii naa saaya ni hiire kusuɔŋ-nu'i. ");
INSERT INTO cmeNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Iŋ hii terieŋgu‑i, yiɛ da Diiloŋ-dũŋ-baamba namba, yiɛ tĩɛna ce yinni niehãi baa-ba. Bafaŋ baa ta ba piiye baa Pol wuɔ u baa kã *Yerusalɛmu‑i-na. *Diiloŋ-Yalle'i naa diyaa nelma famma‑i ba nunni-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Iŋ juɔ'a i ta yiiŋgu maŋ nuɔ‑i, baa hel hiere baa ba caamba‑i baa ba bisãlmba‑i a saaŋ-ye kã baa-ye dãmmaŋ-nuoraaŋgu-na. Iŋ kaa hi nuoraaŋgu nuŋgu‑i, yiɛ dũuna cãrã Diiloŋo‑i ");
INSERT INTO cmeNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","aa sire jaal i-naa. Iŋ jaalaa i-naa, miɛ yiɛ suur baatoŋo-na aa bafaŋ baa gũunu ta ba kũŋ. ");
INSERT INTO cmeNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Iŋ siire terieŋgu-na, yiɛ kã Pitolemayisi. Iŋ hiiriiye Pitolemayisi‑i-na, molo saa ji tiraa suur baatoŋ-na. Iŋ hiiriiye, yiɛ kã ka jaal tobimba maŋ dii terieŋgu-na aa tĩɛna ce yiiŋgu diei baa-ba. ");
INSERT INTO cmeNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Ku cuo kaala‑i-na, yiɛ sire cor kã Sesare. Iŋ hii, yiɛ har Filipu terieŋ-nu. Filipu faŋo waa Diilonelwaraŋo. Ba naŋ hielaa nuɔmba niehãi maŋ Yerusalɛmu‑i-na wuɔ ba ta ba kãyã Yesu *pɔpuɔrbiemba‑i, u waa ba hɔlma-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","U biemba waa ba naa. Ba saa naa hi soŋ yogo. Ba waa *Diilopɔpuɔrbiemba hiere. ");
INSERT INTO cmeNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Yiiŋgu naŋgu-na, *Diilopɔpuɔrbiloŋo naŋ wuɔ hel *Yude‑i-na jo, ba taa ba bĩ-yo Agabusi. ");
INSERT INTO cmeNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Uŋ juɔ ji da-ye, wuɔ biɛ Pol kpaŋkpaaŋgu‑i a vaa fuɔ fɛrɛŋ gbeini‑i baa u nammu‑i aa cira: «Diiloŋ-Yalle ciɛra wuɔ kpaŋkpaaŋ daaku tieŋ duɔ kã Yerusalɛmu‑i-na, *Yuifubaa-ba ka bel-o vaa-yo dumandɛ yaa nuɔ‑i a hã *niɛraamba‑i baa-yo.» ");
INSERT INTO cmeNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Uŋ piiye dumaaŋo-na, miɛ fɛrɛ‑i yiɛ gbuu cãrã Pol baa terieŋgu faŋgu taamba‑i wuɔ u baa kã Yerusalɛmu‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Wuɔ bir gbɛ̃-ye wuɔ: «Bige‑i ciɛ na ta na kaal da na caar mi holle‑i? Da ba ka vaa-mi, wɛima sĩ. Da ba fiɛ ka ko-mi, wɛima sĩ. Mi hũyãa-ma da mi ku Yerusalɛmu‑i-na Itieŋo‑i Yesu maama-na.» ");
INSERT INTO cmeNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Uŋ yagaraa miɛ nuŋgu‑i, i saa ce-ku ku hãi; yiɛ yaŋ-yo aa naa cira: «Ma ce ŋaa Itieŋ uŋ taaraŋ-mɛi dumaa.» ");
INSERT INTO cmeNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Ku huoŋgu-na, yiɛ tigiiŋ ta tiɛ kã Yerusalɛmu‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Diiloŋ-dũŋ-baamba namba hel Sesare‑i-na a cu i huoŋ-nu. Iŋ kaa hi, baa ce i kã ka har naacolŋo naŋo-na, ba bĩ-yo Minasɔ̃. U taa u hel Sipire. U huɔŋgu cuɔ Yesu hũmelle-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Iŋ kãa *Yerusalɛmu‑i-na, kuɔ fũnuŋ dɔlnu tobimba maŋ waa terieŋgu-na! ");
INSERT INTO cmeNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Ku cuo kaala‑i-na, Pol wuɔ kã baa-ye Sake dumɛlle-na. Yiɛ kã ka da Diiloŋ-dũŋ-baamba yaataamba‑i hiere terieŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pol wuɔ jaal-ba, aa Diiloŋ uŋ kãayã-yuɔ u ce mamaŋ hiere *niɛraamba hɔlma-na, wuɔ suur ma yaaŋga-na a waŋ-ma baa-ba. ");
INSERT INTO cmeNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Uŋ juɔ piiye tĩ, baa gbɛliɛŋ Diiloŋo‑i aa naa cira: «Pol, ne, *Yuifubaa-ba maŋ cuu Yesu huoŋ-nu aa yagar nyaar *Moisi *ãnjĩnamma‑na ba ciinu cor. ");
INSERT INTO cmeNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ba nuɔ ŋ maama‑i. Ba gbĩɛ-ba wuɔ naŋ wuɔra ŋ piiye baa Yuifubaa-ba maŋ dii juɔma-na wuɔ ba nanna Moisi ãnjĩnamma‑i. Wuɔ naŋ ciɛra ba baa tiraa ba ta ba *jã ba bisãlmba‑i aa ba nanna ba bĩncuɔŋ-maama‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Dɛ‑i-na, nuharuŋgu si dii-mɛi, ba ka suɔ wuɔ ŋ juɔ. Terieŋgu faŋgu-na, i ka ce-ma niɛ?» ");
INSERT INTO cmeNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Aa naa cira: «Ne, mamaŋ dii cemma, nuɔmba naa dii bande‑i-na, ba pãa nuŋgu baa Diiloŋo‑i, ");
INSERT INTO cmeNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","ne-ba na ka migãaŋ na yunniŋ-maama‑i aa ŋ yiɛra baa nimaŋ dii pãmma hiere ba yunni-na aa ba cir ba yunni‑i. Da ŋ ce mafamma‑i, nuɔmba ka ne da naŋ fɛrɛ‑i ŋ wuɔ Moisi ãnjĩnamma hũmelle‑i. Ba ka suɔ terieŋgu faŋgu-na wuɔ baŋ waŋ mamaŋ ŋ kũŋgu-na hiere coima. ");
INSERT INTO cmeNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Aa niɛraamba maŋ cuu Yesu huoŋ-nu, iŋ yiɛraaya mamaŋ, i nyɛgãaŋ-ma hã-ba, wuɔ ba yaŋ cufĩɛŋ-kũɔma wuoma‑i, baa bĩmbaamba maŋ ba saa cãa ba nonni‑i, baa tãmma famma fɛrɛ‑i aa ba hiel ba naŋga bĩŋwosĩnni‑na.» ");
INSERT INTO cmeNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Baŋ piiye dumaaŋo-na, ku cuo kaala‑i-na, Pol wuɔ gbonu baa balaŋ daaba‑i ka doŋ tuɔ migãaŋ u yuŋ-maama‑i. Baŋ hilaa migãmmaŋ-terieŋgu-na, wuɔ kã *Diilodubuɔ‑i-na ka tũnu *Diilojigãntaamba‑i kuŋ saaya ku bãl yiiŋgu maŋ nuɔ‑i aa ba ko ba niikonni‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Polbaa-ba yunniŋ-maama migãama naa saaya ma ce yinni niehãi. Yiŋ daaniŋ juɔ ta ni kã bãlma‑i, *Yuifubaa-ba naŋ baa da Pol *Diilodubuɔ‑i-na, baa gbo nuɔmba‑i yuɔ ba bel-o. Yuifubaa-ba famba taa ba hel *Asi. ");
INSERT INTO cmeNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Ba siire ta ba kaasĩŋ wuɔ: «*Isirahɛl-baaŋ namaa, kuraaŋ-kuŋ! Naacolŋo maŋ wuɔraayaŋ u bĩɛna i yerre‑i terni-na hiere u yaa daayo. U wuɔra u piiye wuɔ Isirahɛl-baaŋ miɛ i saa fa, nuɔŋ miɛ sĩ. Aa tiraa cira *Moisi *ãnjĩnamma saa fa baa Diilodubuɔ‑i hiere. U yaa tiraa sire biɛ *niɛraamba jo ji suur baa-ba Diilodubuɔ‑i-na a guɔla-yuɔ hã-ye.» ");
INSERT INTO cmeNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Kumaŋ ciɛ ba ta ba piiye wuɔ u juɔ baa niɛraamba Diilodubuɔ‑i-na, ba daa-yo baa Efɛsiyiɛŋo naŋo nelleŋ-huɔŋga-na, ba da niɛ sĩ u juɔ baa-yo Diilodubuɔ‑i-na. Efɛsiyiɛŋo faŋo‑i, ba taa ba bĩ-yo Turofimu. ");
INSERT INTO cmeNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Ijieŋ daani sire gbuo nelle‑i hiere. Nuɔmba hel terni-na hiere jo ji yu Pol-na a bel-o hiel-o Diilodubuɔ‑i-na aa pãŋ bĩŋ dũnfenni‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Baŋ hielaa-yo, baa ta ba taara ba ko-yo. Yalle kã ka hi *Oromɛ ba sorosi ba yuntieŋo‑i, wuɔ *Yerusalɛmu huolaa. ");
INSERT INTO cmeNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Sorosi ba yuntieŋo pãŋ sire ne sorosibaa-ba namba baa u nayuntaamba namba, ba ta ta ba gbar ba kã. Nuɔmbaŋ juɔ'a ba ne da sorosibaa-ba jo dii, baa yaŋ Pol muoma‑i aa naa yiɛra ta ba ne. ");
INSERT INTO cmeNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Baŋ juɔ ji hi, sorosi ba yuntieŋo bel Pol aa ce ba vaa-yo baa jɔlgɔbaa-ba hãi. Baŋ vaa-yo, wuɔ yuu u sĩnni‑i aa naa yuu uŋ ciɛ kumaŋ. ");
INSERT INTO cmeNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Ŋga, nuɔmbaŋ yuu dumaaŋo-na, ba piiye ba da-ba-deŋ hiere; a ce sorosi ba yuntieŋo saa ji suɔ baŋ waŋ mamaŋ. Wuɔ naa wuɔ cira ba kã baa-yo sorosi ba cĩiŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","36","Baa biɛ-yo ta. Nuɔmba‑i hiere baa cu ba huoŋ-nu ta ba kaasĩŋ wuɔ: «Kuɔŋ-yoŋ! Kuɔŋ-yoŋ!» Baŋ kaa ta ba nyugũŋ baa-yo munyugũmmu-na da ba suur baa-yo, baa ta ba nii-yuɔ. Sorosibaa baa naa baa tũu-yo ta ba suur baa-yo. ");
INSERT INTO cmeNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Baŋ suur baa Pol sorosi ba cĩiŋgu-na, wuɔ yuu sorosi ba yuntieŋo‑i girɛkimma-na wuɔ: «Mi gbãa piiye baa-ni wɛi?» Sorosi ba yuntieŋo cira: «Naŋ daa girɛkimma‑i hie ta ŋ nu-ma? ");
INSERT INTO cmeNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Esipiyiɛŋo maŋ siire pu aa nuɔmba neifieŋa hãi cu u huoŋ-nu hĩɛŋgu-na, mɛi na'a sĩ u yaa nuɔŋo‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pol wuɔ cira: «Muɔŋo‑i, *Yuifuyiɛŋ muɔ, mi huɔŋ Tarse, dii Silisi mara nuɔ; mi hel nebuɔ-na; nelgbãŋgbãlãŋ muɔ sĩ. Jande mi cãrã-niɛ, yaŋ mi piiye cɛllɛ baa nuɔmba‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Sorosi ba yuntieŋo hã-yo hũmelle‑i. Pol wuɔ yiɛra munyugũmmu-na aa naa ce u naŋga‑i wuɔ nuɔmba budii. Baa bi budii. Wuɔ biɛ nelma‑i ebiremma-na wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","«Mi mɔlbaa namaa, baa mi tobaa namaa, yaaŋ mi waŋ nelma yaaŋga‑i baa-na.» ");
INSERT INTO cmeNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Polŋ duɔŋ tuɔ piiye ebiremma-na, baa gbuu budii da tententeŋ ŋaa molo si dii. Wuɔ cira: ");
INSERT INTO cmeNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","«Muɔŋo‑i *Yuifuyiɛŋ muɔ. Mi huɔŋ Tarse, dii Silisi mara nuɔ; ŋga mi vãa bande yaa nuɔ‑i. Mi waa baa Gamaliɛl. U yaa hãalãayã-miɛ bĩncuɔŋ-hũmelle‑i hiere. Mi Diiloŋ-kũŋgu waa kpelle ŋaa kũŋ yeŋ kpelle namaa na wulaa dumaa nyuŋgo‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Bamaŋ naa suur Itieŋo hũmelle-na, mi taa mi ko-ba. Mi ciɛ ba bel caamba namba baa bɛmba namba dii-ba kaso. ");
INSERT INTO cmeNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Da na'a mi tãal-na, na yuu *Diilojigãntaamba yuntieŋo‑i baa nelle bĩncuɔmba‑i, ba ka waŋ-ma baa-na.» «Ba nyɛgãaŋ sɛbɛbaa hã-mi wuɔ mi ka hã i nelleŋ-tobimba maŋ dii Damasi‑i-na, wuɔ ba hã-mi hũmelle‑i mi bel bamaŋ cuu Yesu huoŋ-nu terieŋgu-na jo baa-ba *Yerusalɛmu‑i-na bande‑i-na ji huol ba yammu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Mi taa ku yaa‑i. Miŋ kaa ta mi piɛ Damasi‑i, bãaŋgu naa hi yuhuɔŋga‑i tĩ. Mi juɔ'a mi suɔ da cecerma naŋ temma hilaa dɔrɔ‑i-na jo ji dii-mi huɔŋga. ");
INSERT INTO cmeNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Mi pãŋ cii. Miŋ cii dumaaŋo-na, mi nu molo piiye baa-mi wuɔ: ‹Sol, bige‑i ciɛ ŋ ta ŋ ce karaaŋ daaku temma‑i baa-mi?› ");
INSERT INTO cmeNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","«Mi yuu miɛ: ‹Hai moloŋo‑i piiyeŋ?› Kutieŋo gbɛ̃-mi wuɔ: ‹Muɔ Nasarɛtitaaŋ Yesu, muɔmɛi piiyeŋ. Ŋ ce karaaŋgu‑i baa muɔmɛi.› ");
INSERT INTO cmeNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Bamaŋ waa baa-mi, ba daa cecerma‑i, ŋga moloŋ daa uŋ waaŋ mamaŋ ba saa nu-ma. ");
INSERT INTO cmeNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Uŋ piiye dumaaŋo-na, mi yuu miɛ: ‹Mɛi Tie, mi saaya mi ce niɛ?› U gbɛ̃-mi wuɔ: ‹Diiloŋ uŋ taaraŋ ŋ ce mamaŋ, sire ŋ kã Damasi‑i-na ba ka pigãaŋ-ni baa-ma.› ");
INSERT INTO cmeNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Cecerŋ daama pãŋ yir muɔ gbula. Baa bel mi naŋ-na kã baa-mi Damasi‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","«A ne da naacolŋo naŋo waa Damasi‑i-na, ba taa ba bĩ-yo Ananiyasi. U taa u wuɔ *ãnjĩnamma‑i fafamma. *Yuifubaa-ba maŋ waa hiere Damasi‑i-na, ba taa ba bĩ u yefafalle. ");
INSERT INTO cmeNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Wuɔ jo ji da-mi. Wuɔ piɛ mi caaŋ-nu aa naa cira: ‹Sol, puur ŋ yufieŋa‑i!› Mi yufieŋa bi pãŋ puur terduɔŋgu faŋgu-na mi ta mi da. ");
INSERT INTO cmeNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Wuɔ gbɛ̃-mi wuɔ: ‹I bĩncuɔmbaŋ siire cu Diiloŋo maŋ huoŋ-nu'i, u hielaa-ni duɔ pigãaŋ-ni u huɔŋga‑i aa duɔ ce ŋ da ŋ da Nelviiŋo‑i baa ŋ yufelle, aa tiraa ce u piiye baa-ni baa fuɔ fɛrɛŋ nuŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","U taara niŋ daa mamaŋ aa nu mamaŋ, ŋ wuɔra ŋ waŋ-ma baa nuɔmba‑i hiere. ");
INSERT INTO cmeNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Baa sɛrɛ, sire ŋ ce ba *batiseŋ-ni aa ŋ gbuuse-yuɔ u hur ŋ ãmbabalma‑i hiere niɛ.› ");
INSERT INTO cmeNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","«Miŋ juɔ bir kã Yerusalɛmu‑i-na, yiiŋgu naŋgu-na, mi kã *Diilodubuɔ‑i-na ka ta mi cãrã Diiloŋo‑i. Itieŋ wuɔ carra-miɛ. ");
INSERT INTO cmeNT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Miɛ mi ne da-yo. U gbɛ̃-mi wuɔ: ‹Pol, da ŋ fiɛ waŋ wuɔ niɛ mi maama-na, Yerusalɛmutaamba siɛ hũu-ma. Sire ŋ hel ba nelle-na donduo, baa tĩɛna!› ");
INSERT INTO cmeNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","«Miɛ cira miɛ: ‹Itie, ba suyaa wuɔ bamaŋ cuu ŋ huoŋ-nu muɔmɛi taa mi wuɔra *Diilonelhãalãdũnni-na mi bel-ba mi muo-ba aa ta mi dii-ba kaso. ");
INSERT INTO cmeNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Aa mi waa baŋ taa ba ko Etiɛni maŋ taa u waŋ ŋ maama‑i. U kuliiŋgu dɔlaanu-miɛ. Bamaŋ kuɔ-yo, muɔmɛi taa mi niya ba joŋgorbaa-ba‑i.› ");
INSERT INTO cmeNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Miŋ waaŋ mafamma‑i, Itieŋo gbɛ̃-mi wuɔ: ‹Sire ŋ kã, mi taara mi puɔr-ni termaaŋ-nu *niɛraamba wulaa.›» ");
INSERT INTO cmeNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Nuɔmba naa kar ba tũnni‑i ta ba nu Pol tuɔ piiye. Uŋ juɔ cira wuɔ Diiloŋ wuɔ u ka saaŋ u yaa‑i niɛraamba wulaa, baa pãŋ doŋ ta ba kaasĩŋ wuɔ: «Kuɔŋ naacolŋ daayo‑i, baa na yaŋ-yo!» ");
INSERT INTO cmeNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ba taa ba kakarra aa hiel ba joŋgorbaa-ba‑i ta ba naŋ-ba dɔrɔ aa ta ba bi kũɔl hĩɛma‑i ba naŋ dɔrɔ‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Maŋ juɔ waa dumaaŋo-na, sorosi ba yuntieŋ wuɔ cira ba suur baa Pol ba cĩiŋgu-na ka muo-yo, ku yaa u ka waŋ ninsoŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Baa suur baa-yo ka vaa-yo aa da ba muo-yo. Wuɔ yuu sorosi ba yuntieŋo maŋ waa u caaŋgu-na wuɔ: «Hai hãa-na hũmelle‑i wuɔ da na bel *Oromɛyiɛŋo maŋ, na gbãa muo-yo a ne da na saa ce u ãndaaŋgu‑i yogo?» ");
INSERT INTO cmeNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Uŋ piiye dumaaŋo-na, yuntieŋ daayo kã ka gbɛ̃ ba yuntieŋo maŋ naa cira ba muo-yo wuɔ: «Yuntie, i taa i yii diɛ cãl dɛ! Naacolŋ daayo‑i Oromɛyiɛŋo.» ");
INSERT INTO cmeNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Sorosi ba yuntieŋ wuɔ sire jo ji yuu Pol wuɔ: «Nuɔŋo‑i Oromɛyiɛŋ nuɔ wɛi?» Pol wuɔ cira: «Ũu.» ");
INSERT INTO cmeNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Sorosi ba yuntieŋo cira: «Muɔmi hielaa gbeibuɔ da mi gbãa da Oromɛsĩnni‑i.» Pol wuɔ cira: «Muɔ fuɔ, mi huɔŋ baa-ni.» ");
INSERT INTO cmeNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Uŋ piiye dumaaŋo-na, bamaŋ naa saaya ba muo-yo, baa pãŋ forra u caaŋgu-na. Sorosi ba yuntieŋ uŋ ciɛ ba vaa-yo, kor maa pãŋ ta ma da-yo. ");
INSERT INTO cmeNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Ku cuo kaala‑i-na, sorosi ba yuntieŋo ce ba bĩ *Diilojigãntaamba yuntaamba‑i baa *nellentaamba‑i duɔ ji suɔ baŋ cãl Pol mamaŋ nuɔ‑i jebi. Baŋ juɔ, wuɔ ce ba fir Pol jo baa-yo ba wulaa. ");
INSERT INTO cmeNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pol wuɔ tuɔ ne *nellentaamba‑i da kelkelkel, aa naa cira: «Tobiŋ namaa, mi suyaa miɛ ji hi baa nyuŋgo, mi wuɔyaa Diiloŋ-hũmelle‑i baa huɔŋga diei; terieŋgu faŋgu-na, mi sa cãl mi fɛrɛ baa wɛima.» ");
INSERT INTO cmeNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","*Diilojigãntaamba yuntieŋo‑i ba taa ba bĩ-yo Ananiyasi; wuɔ gbɛ̃ bamaŋ waa Pol caaŋgu-na wuɔ: «Muyaaŋ u nuŋgu‑i na hã-yo!» ");
INSERT INTO cmeNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Pol wuɔ cira: «Ŋ ciɛra ba muo muɔmɛi wɛi? Diiloŋo ka bi muo nuɔŋo‑i. Huhurmantieŋ nuɔni maŋ daani‑i; ma sĩ ŋ juɔ da ŋ ji ce ãndaaŋgu‑i a saanu baa *ãnjĩnamma yaa kɛ? Ma ce niɛ ŋ bir ciɛl-ma jĩna aa cira ba muo-mi?» ");
INSERT INTO cmeNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Nuɔŋ baa cira: «Ŋ tuora Diilojigãntaamba yuntieŋo yaa wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pol wuɔ cira: «Aoo! Tobiŋ namaa, mi saa naa suɔ wuɔ u yaa‑i Diilojigãntaamba yuntieŋo‑i, mi cãlãa. Diiloŋ-nelma ciɛra wuɔ: ‹Baa piiye babalaa ŋ hã nellentieŋo‑i.›» ");
INSERT INTO cmeNT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Pol wuɔ suyaa wuɔ nellentaamba namba waa *Sadusĩɛbaa aa banamba *Farisĩɛbaa, wuɔ cira: «Tobiŋ namaa, muɔŋo‑i Farisĩɛyiɛŋ muɔ, mi bĩncuɔmba‑i Farisĩɛbaa. Da na da na ce mɛi ãndaaŋgu‑i nyuŋgo‑i-na, kuu dii ŋaa miŋ hĩŋ taaluŋgu‑i kuomba siremma-na, ku'i juɔ baa mafamma‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Uŋ piiye dumaaŋo-na, Sadusĩɛbaa-ba‑i baa Farisĩɛbaa-ba sire ta ba fanu ba-naa u nelma-na, a ji ce calnu sɔmma hãi. ");
INSERT INTO cmeNT_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Kumaŋ ciɛ ku ce ijieni‑i, Sadusĩɛbaa-ba ciɛra bafamba saa hũu-ma wuɔ kuomba ka sire, ba saa bi hũu-ma wuɔ *dɔrpɔpuɔrbiemba dii baa Diiloŋo‑i, ba saa bi tiraa hũu-ma wuɔ jĩnabaa-ba dii. Farisĩɛbaa ba'a bafamba hũyãa-ma wuɔ daani‑i hiere nii dii; ku'i juɔ baa ijieni‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","*Ãnjĩnamma pigãataamba namba waa ba hɔlma-na, ba waa Farisĩɛbaa; bafamba sire muo jãŋ wuɔ bafamba saa da Polŋ cãlãa kusuɔŋ-nu, kɛrɛ jĩna'i ka carra-yuɔ dii; da ma'i sĩ dɔrpɔpuɔrbiloŋo. ");
INSERT INTO cmeNT_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Kuɔ sire bel vaa. Korma doŋ ta ma da sorosi ba yuntieŋo‑i wuɔ sĩ ba ka hɔnu Pol. Wuɔ ce sorosibaa-ba jo ji hiel-o ba hɔlma-na a kã baa-yo ba cĩiŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Ku isuɔŋgu-na, Itieŋ wuɔ carra Pol a waŋ baa-yo wuɔ: «Vaa ŋ fɛrɛ! Niŋ waaŋ mi maama‑i dumaa *Yerusalɛmu‑i-na bande‑i-na, da ŋ kã, ŋ waŋ-ma dumɛi *Ɔrɔmu‑i-na.» ");
INSERT INTO cmeNT_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Ku cuo kaala‑i-na, *Yuifubaa-ba sire nunu ba-naa cucuuyuŋgu-na da ba ko Pol, aa naa waasa wuɔ da ba saa ko-yo, juuru sa wuo, hũmma sa nyɔŋ. ");
INSERT INTO cmeNT_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Bamaŋ naa ciɛ mafamma‑i baa curaa nuɔmba komuɔŋa hãi‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Baa sire kã ka ne *Diilojigãntaamba yuntaamba‑i, baa nelle bĩncuɔmba‑i a waŋ baa-ba wuɔ: «I daa i-naa, aa i waasaaŋ wuɔ diɛ saa ko Pol, molo sa dii bĩŋkũŋgu u nuŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Fiɛfiɛ‑i-na, namaa da na siɛ baa *nellentaamba‑i, na kã sorosi ba yuntieŋo wulaa, wuɔ u ce ba jo baa-yo na ji migãaŋ ce u ãndaaŋgu‑i fafamma. Da ba ta ba jo baa-yo, miɛ i ka gbãŋ kpelle ko-yo hũmelle-na.» ");
INSERT INTO cmeNT_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Pol hãsĩŋo naŋo waa nu-ma. Wuɔ kã ka tũnu Pol baa-ma dii sorosi ba cĩiŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Pol wuɔ bĩ sorosi ba yuntieŋo naŋo‑i a ji waŋ baa-yo wuɔ: «Kã baa naacombiloŋ daayo‑i na yuntieŋo wulaa, nelma dii u duɔ waŋ-ma baa-yo.» ");
INSERT INTO cmeNT_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Sorosiyiɛŋ wuɔ kã baa naacombiloŋo‑i ba yuntieŋo wulaa ka cira: «Pol yaa bĩɛ-mi hã-mi naacombiloŋ daayo‑i wuɔ mi jo baa-yo ŋ wulaa, kɛrɛ ŋ pɔpuɔruŋgu dii u wulaa.» ");
INSERT INTO cmeNT_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Ba yuntieŋ wuɔ bel naacombiloŋo naŋ-na ba kã ba deŋ ka yuu-yo wuɔ: «Ku faa wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Naacombiloŋ wuɔ cira: «Ku faa. Kuu dii ŋaa Yuifubaa-ba saa-ma wuɔ ba ka jo ji waŋ baa-ni ŋ kã baa Pol bisĩnuɔ‑i-na ba ka migãaŋ ce u ãndaaŋgu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Da ba jo, ŋ baa hũu-ma. Bamaŋ taaraayaŋ-yuɔ baa komma‑i ba curaa nuɔmba komuɔŋa hãi‑i. Ba waasaaŋ wuɔ da ba saa ko-yo, molo sa dii bĩŋkũŋgu u nuŋgu-na. Bafamba tigiiŋ tĩ, ba cie nuɔnɛi.» ");
INSERT INTO cmeNT_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Sorosi ba yuntieŋ wuɔ cira: «Mi nuɔ, ŋga ma diei dii: Baa yaŋ molo suɔ wuɔ ŋ tũɔnu-miɛ.» Aa naa ce u bir kũŋ. ");
INSERT INTO cmeNT_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Naacombiloŋ uŋ taa, sorosi ba yuntieŋo bĩ bamaŋ cuu ufaŋo‑i ba hãi, a ji gbɛ̃-ba wuɔ: «Hielaaŋ sorosibaa nuɔsũɔ na tigiiŋ-ba, baa sũŋgbartaamba komuɔŋa siɛi baa cĩncieluo, a naara puɔlnintaamba nuɔsũɔ. Diɛ wuo isuɔniiwuoni‑i tĩ, na ka kã Sesare. ");
INSERT INTO cmeNT_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Niɛŋ sũnaamba namba na ji kã baa Pol. Mi taara u hi fãamaaŋo terieŋgu‑i u yuŋgu baa jaŋ-yo.» Fãamaaŋo faŋo‑i ba taa ba bĩ-yo Felisi. ");
INSERT INTO cmeNT_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Aa nyɛgɛ̃ŋ sɛbɛ daayo‑i hã-ba wuɔ ba ka hã-yo. U nyɛgãaŋ wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","«Fãamaa, mi pãa-ni jaaluŋgu. Muɔ Kulodi-Lisiyasi, muɔmɛi nyɛgãaŋ sɛbɛ daayo‑i da mi hã-ni. ");
INSERT INTO cmeNT_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Baŋ kãa baa naacolŋo maŋ, *Yuifubaa-ba naa bel-o ta ba taara ba ko-yo. Miŋ juɔ suɔ miɛ *Oromɛyiɛŋo, mi kã baa sorosibaa-ba‑i ka hũu-yo ba wulaa ");
INSERT INTO cmeNT_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","kã baa-yo ba *nellentaamba wulaa da mi ka suɔ baŋ cãl-oŋ mamaŋ nuɔ‑i jebi. ");
INSERT INTO cmeNT_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Mi kãa ku yaa nuɔ‑i, ka da ba cãl-o ba hũmelleŋ-kũŋ-nu. U saa ce mamaŋ hii ba bel-o dii-yo kaso aa ji da baa a ko-yo. ");
INSERT INTO cmeNT_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Dumandɛ‑i-na, mi nuɔ ba'a ba jɔguɔŋ-yo baa komma, ku'i ciɛ mi saaŋ-yo hã-ni. Mi waaŋ-ma baa-ba miɛ da kuɔ wɛima dii, ba kã naŋ wulaa. I ka waa.» ");
INSERT INTO cmeNT_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Sorosibaa baa bi biɛ Pol isuɔŋgu faŋgu-na a kã ka hi Ãntipatirisi. ");
INSERT INTO cmeNT_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Ku cuo kaala‑i-na, bamaŋ waa baa ba gbeini‑i, baa gũunu aa naa yaŋ bamaŋ waa baa sũnaamba yaa cor baa Pol. ");
INSERT INTO cmeNT_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Baŋ kaa hi Sesare‑i, baa dii sɛbɛ‑i fãamaaŋo naŋ-na baa Pol hiere. ");
INSERT INTO cmeNT_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Fãamaaŋ wuɔ kalaŋ sɛbɛ‑i aa naa yuu Pol uŋ hel yasĩnni maŋ nuɔ‑i. Pol wuɔ cira u hel Silisi mara nuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Fãamaaŋ wuɔ cira: «Bamaŋ cãlãaŋ-niŋ da ba jo, nelma maŋ dii yuuma‑i, mi ka yuu-ni baa-ma.» Aa naa ce ba kã baa-yo ka jĩna-yuɔ *Erɔdi cĩiŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Baŋ juɔ baa Pol ji hã fãamaaŋo‑i, yinni naa cor, diiluŋ-yiiŋgu-na, *Diilojigãntaamba yuntieŋo‑i Ananiyasi wuɔ sire baa nelle bĩncuɔmba namba‑i a jo baa ãndaaŋgu‑i fãamaaŋo wulaa. Baa naa bi jo baa naacolŋo naŋo u duɔ ji piiye cu ba huoŋ-nu. Ba bĩ naacolŋo‑i Tɛrtulusi. ");
INSERT INTO cmeNT_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Baŋ juɔ, fãamaaŋ wuɔ ce ba bĩ Pol jo. Uŋ juɔ, Tɛrtulusi wuɔ doŋ tuɔ piiye wuɔ: «Yuntie, iŋ yeŋ fiisaaŋgu maŋ nuɔ‑i daaku‑i nuɔnɛi juɔ baa-ku. Ŋ migãaŋ wɛima bɔi hã-ye. ");
INSERT INTO cmeNT_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","I siɛ gbuu gbãa jaal-ni. ");
INSERT INTO cmeNT_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Mi sa taara mi bella-niɛ jĩna ku'i ciɛ mi ta mi cãrã-niɛ miɛ ŋ ce jande aa ŋ kar ŋ tũŋgu‑i i piiye cɛllɛ yoŋ baa-ni. ");
INSERT INTO cmeNT_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Naacolŋ daayo‑i nɛliɛŋo sĩ; i daa u wuɔra u gbo *Yuifubaa-ba‑i baa ba-naa terni-na hiere. Nasarɛtitaaŋ Diiloŋ-hũmelle yuntieŋo naŋo'i. ");
INSERT INTO cmeNT_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","U taa u yii duɔ bi bĩɛna *Diilodubuɔ‑i hã-ye, ku'i ciɛ i bel-o. Ii naa cira i ce ãndaaŋgu‑i miɛ cemma, ");
INSERT INTO cmeNT_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Lisiyasi yaŋ aa kã ka hũu-yo i wulaa fɔ̃ŋgũɔ ");
INSERT INTO cmeNT_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","aa cira mamaŋ da ma waa i jo naŋ wulaa. Miŋ waaŋ mamaŋ, da kuɔ coima, u yaa‑i ŋ yuu-yo.» ");
INSERT INTO cmeNT_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Yuifubaa baa cira ma yaaŋga yaa‑i, kɛrɛ ma ciɛ dumɛi. ");
INSERT INTO cmeNT_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Fãamaaŋ wuɔ hã Pol baa ãndaaŋgu‑i. Pol wuɔ cira: «Yuntie, mi suyaa miɛ nyuŋgo saa jĩna-niɛ ãndacelle-na miɛ jãmalã‑i-na. Terieŋgu faŋgu-na, mi holle sa tie baa wɛima. ");
INSERT INTO cmeNT_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Mi kãa *Yerusalɛmu‑i-na da mi ka jaal Diiloŋo. Miŋ kãa, ku saa cor yinni cĩncieluo ni hãi yogo. Da ŋ'a mi tãal-ni yuu-ba ŋ ne. ");
INSERT INTO cmeNT_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Aa ŋ yuu-ba da kuɔ ba daa mi ciɛ ãndapirre baa moloŋo Diilodubuɔ‑i-na, sisɔ *Diilonelhãalãdũnni-na, da ma'i bi sĩ yaŋga naŋga, ba waŋ-ma. Da kuɔ ba bi daa mi wuɔra mi gbo nuɔmba‑i, ba bi tiraa ba waŋ mafamma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","«Baŋ waaŋ mamaŋ hiere daama‑i ãŋgbãŋgbãlãmma. ");
INSERT INTO cmeNT_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Mi gbãa waŋ mamaŋ baa-ni, ma yaa daama: Hũmelle maŋ bafamba ciɛra di saa fa, muɔ mi suurii di yaa nuɔ‑i ta mi cãa i bĩncuɔmbaŋ siire cu Diiloŋo maŋ huoŋ-nu'i. Mamaŋ nyɛgãaŋ *ãnjĩnamma-na baa *Diilopɔpuɔrbiemba sɛbɛbaa-ba-na, mi hũyãa-ma wuɔ ninsoŋo. ");
INSERT INTO cmeNT_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Mi hũyãa-ma miɛ nelfafaamba maŋ kuu baa nelbabalaamba‑i hiere, yiiŋgu dii baa yiiŋgu, Diiloŋo ka sire-bɛi. Bafamba fɛrɛ maŋ daaba‑i ba bi hũyãa-ma mɛi temma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Terieŋgu faŋgu-na, ku'i ciɛ mi ta mi gbãŋ kpelle, mi baa cãl Diiloŋo‑i, mi baa bi cãl moloŋo. ");
INSERT INTO cmeNT_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","«Miŋ hilaa Yerusalɛmu‑i-na ku bãaŋgu cuɔ. Miŋ kaa wuɔra, mi da gbeiŋa cɛllɛ bel mi naŋ-na da mi ji kãyã mi nelleŋ-baamba‑i aa bi da hã Diiloŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Da ŋ da ba daa-mi Diilodubuɔ‑i-na, kuu dii ŋaa mii naa kã baa ma yaa‑i: Mi kãa ka migãaŋ mi yuŋ-maama. Nuɔmba bɔi saa waa baa-mi! Ijieni saa bi waa! ");
INSERT INTO cmeNT_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Da ku waa wɛima, Yuifubaa-ba maŋ hilaaŋ *Asi‑i-na, ba yaa waa. Kuɔ mii naa cãl, ba yaa naa saaya ba waa nyuŋgo‑i-na a pigãaŋ-ni miŋ cãlãa terieŋgu maŋ nuɔ‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Baŋ kãa baa-mi *nellentaamba wulaa, ba kaa da cãlmuɔ hayo‑i haa-miɛ? ");
INSERT INTO cmeNT_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Iŋ kãa, aa mi sire yiɛra waŋ nelma maŋ miɛ: ‹Mi suyaa miɛ da ŋ da ba ce mɛi ãndaaŋgu‑i nyuŋgo‑i-na, kuu dii ŋaa miŋ hĩŋ taaluŋgu‑i kuomba siremma-na ku'i juɔ baa mafamma‑i›, ba ka ta ba nii-miɛ ma yaa nuɔ‑i, ni ma'i sĩ, ba nuɔ wuɔ mi guɔlaaya bige‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Fãamaaŋo‑i ba taa ba bĩ-yo Felisi, wuɔ suyaa Yesu hũmelle‑i konnu-diɛ. Polŋ juɔ piiye tĩ, u saa kar ãndaaŋgu‑i yiiŋgu faŋgu-na, wuɔ gbɛ̃-ba wuɔ: «Lisiyasi duɔ ji jo, mamaŋ da ma waa, mi ka tũnu-nɛi baa-ma.» ");
INSERT INTO cmeNT_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Aa naa waŋ baa sorosi ba yuntieŋo naŋo‑i wuɔ u dii Pol kaso jĩna. Duɔ dii-yo, u yaŋ u waa u fɛrɛŋ nuɔ u jɛ̃naamba ta ba gbã ba kã ba ne-yo aa ta ba ce u pɔpuɔrni‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Ku saa da yinni, wuɔ jo baa u ciɛŋo‑i aa naa puɔr ba ka bĩ Pol wuɔ u ji piiye Yesu-Kirsa hũmelleŋ-kũŋgu‑i pigãaŋ-ba. U ciɛŋo‑i, ba taa ba bĩ-yo Durusil, u waa Yuifuyiɛŋo. ");
INSERT INTO cmeNT_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Pol wuɔ jo ji tuɔ piiye baa-ba nɛliɛŋ nuɔ niŋ saaya ŋ ce Diiloŋo huɔŋga‑i dumaa, baa niŋ saaya ŋ bel ŋ fɛrɛ dumaa, baa Diiloŋ uŋ kaa yuu-ye dumaa. Uŋ piiyeŋ, Felisi hol diɛ doŋ ta di tie, wuɔ cira: «Yiɛra dumaa nyuŋgo‑i-na; da mi ji da mi fɛrɛ yiiŋgu maŋ nuɔ‑i, mi ka tiraa ce ba bĩ-ni ŋ jo.» ");
INSERT INTO cmeNT_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","U taa u bi ne wuɔ sĩ Pol ka hã-yo gbeiŋa. A ce dumaaŋo-na, wuɔ tuɔ puɔr ba ta ba bĩ-yo kpɛ̃kpɛ̃ ba hã-yo. ");
INSERT INTO cmeNT_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","U ciɛ dumɛi suu! Naacolŋo naŋo ji jo ji hor-o fãamaansĩnni-na. A ne da bieŋa hãi naa cor tĩ. Naacolŋo faŋo‑i ba taa ba bĩ-yo Pɔrkusi-Fɛtusi. Felisiŋ taa u taara Yuifubaa-ba dɔl-o dumaaŋo-na, wuɔ yaŋ Pol dii kaso‑i-na u saa hiel-o. ");
INSERT INTO cmeNT_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Fɛtusiŋ juɔ ji hor Felisi‑i, wuɔ ce yinni siɛi aa naa sire kã *Yerusalɛmu‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Uŋ kãa, *Diilojigãntaamba yuntaamba‑i baa nelle yuntaamba sire kã baa Pol maama‑i u wulaa ka ta ba waana. ");
INSERT INTO cmeNT_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Aa naa cira wuɔ u ce jande aa u jo baa-yo Yerusalɛmu‑i-na ba ji ce u ãndaaŋgu‑i. A ne da ba taa ba taara u jomma-na ba ko-yo hũmelle-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Fɛtusi wuɔ waŋ baa-ba wuɔ Pol siɛ gbãa jo, uu dii kaso. Aa cira fuɔ fɛrɛ‑i u saa jo duɔ ji vaaya Yerusalɛmu‑i-na; ");
INSERT INTO cmeNT_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","da kuɔ Pol cãlãa, duɔ u ta, ba hiel nuɔmba ba gbonu, da ba ka hi Sesare‑i ba ka ce u ãndaaŋgu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Fɛtusiŋ ciɛ yinni maŋ Yerusalɛmu‑i-na aa bir kã Sesare‑i-na, ni saa cor yinni cĩncieluo‑i. Uŋ kãa yiiŋgu maŋ nuɔ‑i, ku cuo kaala‑i-na, wuɔ kã gɛ̃ŋgɛrterieŋgu-na aa naa ce ba jo baa Pol. ");
INSERT INTO cmeNT_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Baŋ juɔ baa-yo, *Yuifubaa-ba maŋ hilaa Yerusalɛmu‑i-na kã, baa sire cĩilã-yuɔ hiere ta ba gbu ba kar coikãŋkarɛiŋa ba haa-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Pol wuɔ cira: «Mi saa cãl manamma Yuifu ba Diiloŋ-hũmelle-na, mi saa bi cãl manamma *Diilodubuɔ‑i-na, mi saa bi tiraa cãl *Oromɛ ba *jãmatigi‑i, na hiire-miɛ hama‑i nuɔ‑i?» ");
INSERT INTO cmeNT_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Fɛtusiŋ taa u taara Yuifubaa-ba dɔl-o dumaaŋo-na, wuɔ yuu Pol wuɔ: «Ŋ taara mi kã baa ãndaaŋ daaku‑i ka ce-ku Yerusalɛmu wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pol wuɔ cira: «Mɛi ãndaaŋguŋ hii fãamaaŋ ba terieŋgu‑i ku kar kusuɔŋ-nu'i, ku siɛ gbãa bir kã terieŋgu naŋ-nu. Naŋ fɛrɛ‑i ŋ suyaa kerre wuɔ mi saa cãl Yuifubaa-ba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Da kuɔ mi cãlãa ninsoŋo, aa miŋ ciɛ mamaŋ ma hii ba ko-mi, mi siɛ cĩina kuliiŋgu‑i. Ŋga baŋ haa mamaŋ miɛ, da kuɔ mi saa ce-ma, molo siɛ gbãa hã-ba baa-mi. Kuŋ hii terieŋgu maŋ daaku‑i, yaaŋ ãndaaŋgu‑i na hã Oromɛ ba jãmatigi‑i baa-ku.» ");
INSERT INTO cmeNT_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Fɛtusi wuɔ piiye baa u caantaamba‑i aa naa waŋ baa Pol wuɔ: «Niŋ'a i yaŋ ãndaaŋgu‑i hã jãmatigi‑i, ŋ ka kã u wulaa.» ");
INSERT INTO cmeNT_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","A ne da nellentieŋo naŋo waa ba taa ba bĩ-yo Agirpa. Agirpa tũɔ naŋo waa, ba taa ba bĩ-yo Berenisi. Fɛtusiŋ ciɛ Pol ãndaaŋgu‑i, ku saa da yinni, Agirpa‑i baa u tũɔ‑i baa jo Sesare‑i-na wuɔ ba ji jaal Fɛtusi‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Baŋ juɔ ji ta ba da yinni dumaaŋo-na, yiiŋgu naŋgu-na, Fɛtusi wuɔ biɛ Pol kũŋgu‑i tuɔ piiye baa-ba wuɔ: «Mi juɔ ji da Felisi bilaa naacolŋo naŋo‑i jĩna dii kaso‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Miŋ kãa *Yerusalɛmu‑i-na, *Diilojigãntaamba yuntaamba‑i baa *Yuifu ba bĩncuɔmba jo mi wulaa wuɔ mi ko-yo, mi baa yaŋ-yo. ");
INSERT INTO cmeNT_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Mi gbɛ̃-ba miɛ *Oromɛbaa miɛ diɛ bel moloŋo‑i aa i saa ce u ãndaaŋgu‑i i siɛ gbãa ko-yo. ");
INSERT INTO cmeNT_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Ba sire jo baa-mi. Iŋ juɔ mi saa sɛrɛ; ku cuo kaala‑i-na, mi ce ba jo baa-yo i diɛ ji ce u ãndaaŋgu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Mɛi na'a sĩ u ciɛ kuubabalaaŋgu naŋ temma‑i, a ji da ma'i sĩ. ");
INSERT INTO cmeNT_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Ba fanu ba-naa ba Diiloŋ-hũmelleŋ-kũŋ-nu, baa naacolŋo naŋ kũŋ-nu. Naacolŋo faŋo‑i wuɔ ba bĩ-yo Yesu. U kuu, Pol fuɔ wuɔ u kuu aa sire. ");
INSERT INTO cmeNT_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Mɛi ne nel daama cu mi huɔŋga‑i; mi saa suɔ miŋ ka ce kumaŋ. Mi naa mi yuu Pol da kuɔ u taara ãndaaŋ daaku kã Yerusalɛmu. ");
INSERT INTO cmeNT_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Pol wuɔ fuɔ ãndaaŋgu sa kã terieŋgu, kɛrɛ kuŋ hii terieŋgu maŋ nuɔ‑i, i yaŋ-ku i hã *jãmatigi‑i baa-ku. Mi naa mi ce ba bir dii-yo jĩna miɛ da mi da yiiŋgu, mi saaŋ-yo hã jãmatigi‑i baa-yo.» ");
INSERT INTO cmeNT_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agirpa wuɔ cira: «Naacolŋ daayo‑i mɛi taara mi da-yo baa mi yufelle u piiye mi nu.» Fɛtusi wuɔ cira: «Wɛima sĩ, bisĩnuɔ ŋ ka da-yo.» ");
INSERT INTO cmeNT_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Ku cuo kaala‑i-na, baa saaŋ Agirpa‑i baa niimarni u jo ji suur gɛ̃ŋgɛrdũŋgu-na baa u tũɔ‑i baa sorosi ba yuntaamba‑i a naara nelbɔ̃mbɔ̃mbaa-ba maŋ waa nelle-na. Baŋ juɔ, Fɛtusi wuɔ ce ba jo baa Pol. ");
INSERT INTO cmeNT_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Baŋ juɔ baa-yo, Fɛtusi wuɔ cira: «Nellentieŋo‑i baa namaa namaŋ dii bande‑i-na hiere, na daa naacolŋ daayo‑i kɛ? Miŋ kãa Yerusalɛmu‑i-na, Yuifubaa-ba‑i hiere ba sire jo mi wulaa, aa tiraa nyaanu-miɛ jo bande‑i-na, wuɔ naacolŋ daa u saa baa kuliiŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Muɔ da mi ne, mi siɛ da uŋ ciɛ kumaŋ aa ba'a ba ko-yo. Ŋga uŋ ciɛra i yaŋ ãndaaŋgu‑i hã jãmatigi‑i baa-ku, mi ka saaŋ-yo hã-yo baa-yo. ");
INSERT INTO cmeNT_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Mi saa da nelma jebi u kũŋgu-na da mi nyɛgɛ̃ŋ saaŋ hã jãmatigi‑i, ku'i ciɛ na da mi ciɛ ba jo baa-yo nyuŋgo‑i-na i diɛ ji yuu-yo Agirpa naŋ fɛrɛ‑i ŋ yufelle-na, ku niɛ sĩ mi ka gbãa da manamma nyɛgɛ̃ŋ. ");
INSERT INTO cmeNT_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Mɛi niɛ da, da na bel moloŋo‑i da na saaŋ-yo terieŋgu naŋ-nu, uŋ ciɛ kumaŋ na bel-o, na saaya na nyɛgɛ̃ŋ-ku hã terieŋgu faŋgu taamba‑i bafamba bi suɔ.» ");
INSERT INTO cmeNT_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agirpa wuɔ cira: «Pol, ãndaaŋgu‑i dii nuɔnɛi wulaa‑i; piiye mamaŋ dii naŋ wulaa.» Pol wuɔ fara u naŋga‑i aa naa cira: ");
INSERT INTO cmeNT_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","«Nellentie, *Yuifubaa-baŋ haa mamaŋ miɛ hiere, niŋ hãa-mi hũmelle‑i mi da mi waŋ maŋ bilaa dumaa tũnu-niɛ nyuŋgo‑i-na, ku dɔlaanu-miɛ cor. ");
INSERT INTO cmeNT_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Na niŋ yeŋ terieŋgu maŋ nuɔ‑i, molo siɛ gbãa pigãaŋ-ni Yuifu ba bĩncuɔŋ-maama‑i, aa ŋ suɔ baŋ fanuŋ ba-naa nelma maŋ nuɔ‑i hiere. Terieŋgu faŋgu-na, jande, fɛ̃ ŋ huɔŋga‑i aa ŋ nu mi nelma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","«Ma miŋ siire ce kumaŋ *Yerusalɛmu‑i-na, Yuifubaa-ba‑i hiere ba suyaa-ku. ");
INSERT INTO cmeNT_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Nyuŋgo saa jĩna-yiɛ baa i-naa. Ba suyaa wuɔ *Farisĩɛyiɛŋ muɔ, aa tiraa suɔ wuɔ i Diiloŋ-hũmelleŋ-kũŋgu kuolaaya yaŋ Yuifubaa-ba namba‑i. Da ŋ yuu-ba, da ba'a ba ka waŋ ninsoŋo‑i baa-ni, ba ka waŋ-ma baa-ni. ");
INSERT INTO cmeNT_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Aa da ŋ da ba ce mɛi ãndaaŋgu‑i nyuŋgo‑i-na, kuu dii ŋaa Diiloŋ uŋ pãa nuŋgu maŋ baa i tobaa-ba‑i, miŋ hĩŋ ku taaluŋgu‑i, ku'i juɔ baa mafamma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","*Isirahɛl-baamba‑i hiere ba kũŋgu-na ba hĩŋ ku taaluŋgu‑i, ku'i ciɛ ba ta ba cãrã Diiloŋo‑i bãaŋgu‑i baa isuɔŋgu‑i. «Nellentie, muɔ miŋ bi hĩŋ taaluduɔŋgu faŋgu‑i, Yuifubaa-ba gãŋ baa-mi ma yaa nuɔ‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Namaa niɛ-ma niɛ, Yuifubaa namaaŋo‑i, aa cira Diiloŋo siɛ gbãa sire kuomba‑i? ");
INSERT INTO cmeNT_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Mɛi fɛrɛ maŋ daami‑i, mii naa da niɛ sĩ mi saaya mi gbãŋ kpelle a hiel Nasarɛtitaaŋ Yesu yerre‑i nuɔmba nunni-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Mi taa mi ce ma yaa‑i Yerusalɛmu‑i-na. Bamaŋ naa cu Yesu huoŋ-nu, *Diilojigãntaamba yuntaamba naa hã-mi hũmelle‑i mi bel ba fɔ̃ŋgũɔ dii-ba kaso, aa da ba'a ba ko-ba, mi sa yagar. ");
INSERT INTO cmeNT_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Mi taa mi wuɔra *Diilonelhãalãdũnni-na hiere mi ce-ba gbomma. Mi taa mi taara mi kpakpaa-ba hiel-ba Yesu hũmelle-na. Mi huɔŋgaŋ ŋa naa gbuu du baa-ba dumaaŋo-na, da mi ce mi hel nyaa ba huoŋ-nu nilɛiŋa naŋa-na.» ");
INSERT INTO cmeNT_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","«Miŋ waa ta mi ce karaaŋgu faŋgu‑i, yiiŋgu naŋgu-na, Diilojigãntaamba yuntaamba ji hã-mi hũmelle‑i mi ta mi kã Damasi. ");
INSERT INTO cmeNT_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Mi waa baa nuɔmba namba. Nellentie, muɔmɛi tũɔ-niŋ, bãaŋguŋ juɔ hi yuhuɔŋga‑i, miɛ mi ne da cecerma naŋ temma hilaa dɔrɔ‑i-na jo ji dii-ye huɔŋga. Cecerŋ daama taa ma carra ma yaŋ bãaŋgu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Yiɛ pãŋ cii hiere, mɛi nu molo piiye baa-mi ebiremma-na wuɔ: ‹Sol, bige‑i ciɛ ŋ ta ŋ ce karaaŋ daaku temma‑i baa-mi? Ŋ saa suɔ wuɔ ŋ ce gbãŋgbãŋ wɛi?› ");
INSERT INTO cmeNT_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","«Miɛ yuu miɛ: ‹Hai moloŋo‑i piiyeŋ?› «Kutieŋo gbɛ̃-mi wuɔ: ‹Muɔ Yesu, muɔmɛi piiyeŋ, ŋ ce karaaŋgu‑i baa muɔmɛi. ");
INSERT INTO cmeNT_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Sire ŋ yiɛra. Mi caraaya-niɛ da mi ce-ni mi cãarãŋ nuɔ, aa niŋ daa mamaŋ daama‑i nyuŋgo‑i-na, ŋ ce ma watieŋ nuɔ baa miŋ ka ta mi pigãaŋ-ni mamaŋ hiere. ");
INSERT INTO cmeNT_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Mi ka puɔr-ni ŋ nelleŋ-baamba wulaa baa *niɛraamba bi wulaa. Mi ka waa baa-ni, molo siɛ gbãa ce-ni bĩŋkũŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Kã ŋ ka hiel-ba kukulma-na ŋ dii-ba cecerma-na. Kã ŋ ka hũu-ba *Sitãni wulaa ŋ hã Diiloŋo‑i baa-ba. Da ba hũu mi maama‑i, ba ãmbabalma ka hur aa ba nuŋgu ka waa baa Diiloŋ-baamba‑i.› ");
INSERT INTO cmeNT_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","«Nellentie, Itieŋ uŋ caraaya-miɛ a waŋ mamaŋ baa-mi mi siɛ gbãa yagar-ma. ");
INSERT INTO cmeNT_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Mi duɔŋ Damasi yaa nuɔ‑i igɛ̃na ta mi waŋ u maama‑i, aa hel terieŋgu-na kã *Yerusalɛmu. Miŋ siire Yerusalɛmu‑i-na, mi wuɔra gbuo *Yude nilɛiŋa‑i hiere ka cor baa niɛraamba‑i. Mi taa mi piiye baa-ba miɛ: ‹Naanaŋ na cilɔbabalaŋo‑i aa na suur Diiloŋ-hũmelle-na. Yaaŋ na ciluɔ tuɔ fa ku yaa pigãaŋ wuɔ na naana na cilɔbabalaŋo‑i ninsoŋo.› ");
INSERT INTO cmeNT_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Da ŋ da *Yuifubaa-ba bilaa-mi *Diilodubuɔ‑i-na ta ba taara ba ko-mi, ku yuŋgu yaa kufaŋgu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Ŋga Diiloŋo saa hũu-ma. Ji hi baa nyuŋgo, muɔmɛi daami ta mi waŋ u maama‑i baa nuɔmba‑i hiere, mi sa bɔ moloŋo baa-ma. *Diilopɔpuɔrbiembaŋ siire waŋ mamaŋ a naara *Moisi‑i, mi tir ma yaa‑i; mi saa haa manamma mɛi. ");
INSERT INTO cmeNT_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Ba waaŋ-ma wuɔ: ‹Diiloŋ uŋ ka saaŋ *Koŋkortieŋo maŋ, u ka mulĩɛŋ. Aa duɔ ku, u yaa ka sire igɛ̃na kuomba hɔlma-na. Duɔ sire, u ka pigãaŋ i baamba‑i koŋkor-hũmelle‑i baa niɛraamba‑i hiere.›» ");
INSERT INTO cmeNT_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Polŋ juɔ piiye hi terieŋ daaku‑i, Fɛtusi wuɔ kaasĩŋ da gbagaga wuɔ: «Pol, nuɔ ŋ siɛ waa dii ŋ fɛrɛ nuɔ! Sɛbɛ siire ŋ yuŋgu‑i!» ");
INSERT INTO cmeNT_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Pol wuɔ cira: «Fɛtusi, mi saa piel. Miŋ waŋ-maŋ dumaa ma ciɛ dumɛi. ");
INSERT INTO cmeNT_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Maŋ ciɛ terieŋgu maŋ nuɔ‑i, ku saa fuo. Agirpa suyaa-ma hiere, ku'i ciɛ mi da holle yiɛra u yaaŋga-na ta mi waŋ-ma.» ");
INSERT INTO cmeNT_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Aa naa cira: «Nellentie, Diilopɔpuɔrbiembaŋ waaŋ mamaŋ, ŋ hũyãa-ma wɛi? Mi suyaa miɛ ŋ hũyãa-ma.» ");
INSERT INTO cmeNT_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agirpa wuɔ cira: «Pol, ŋ taara ŋ ce-mi Kirsa wuoŋ muɔ hoi dumandɛ‑i-na wɛi?» ");
INSERT INTO cmeNT_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Pol wuɔ cira: «Da ku fiɛ waa fiɛfiɛ sĩ, wɛima sĩ. Aa naŋ diei sĩ, miŋ piiyeŋ baa namaa namaŋ hiere nyuŋgo‑i-na, mi cãrã Diiloŋo‑i miɛ u ce-na mɛi temma‑i; ŋga mamaŋ daa-mi daama‑i u baa yaŋ ma yaa da-na.» ");
INSERT INTO cmeNT_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Polŋ juɔ piiye tĩ, Agirpa‑i baa Fɛtusi‑i a naara Berenisi‑i baa bamaŋ waa hiere, baa sire ta ba hel. ");
INSERT INTO cmeNT_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Umaŋ duɔ puur duɔ piiye, wuɔ: «Mɛi saa suɔ kumaŋ ciɛ ba bel naacolŋ daayo‑i aa migãaŋ ta ba taara ba ko-yo.» ");
INSERT INTO cmeNT_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agirpa wuɔ tuɔ piiye baa Fɛtusi‑i wuɔ: «Kuɔ u saa naa cira na yaŋ ãndaaŋgu‑i hã *jãmatigi‑i baa-ku, dumandɛ‑i-na nii naa nanna-yuɔ.» ");
INSERT INTO cmeNT_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","I tammaŋ juɔ hel yiiŋgu-na diɛ kã *Itali‑i-na, baa cira i ta baa baatoŋo, aa naa dii Pol sorosi ba yuntieŋo naŋo naŋ-na a naara kasobiemba namba. Ba taa ba bĩ sorosi ba yuntieŋo faŋo‑i Yulusi. U waa *jãmatigi sorosibaa-ba yaa nuɔ‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Iŋ taa baa baatoŋo maŋ, uu naa hel Adarmiti jo aa bir tuɔ kã *Asi‑i-na. Naacolŋo naŋo waa baa-ye, ba taa ba bĩ-yo Aritarke; u taa u hel Tesalonike, dii Maseduɔni mara nuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Iŋ taa yiiŋgu maŋ nuɔ‑i, ku cuo kaala‑i-na, yiɛ kã ka hi Sidɔ̃. Yulusi taa u ce baa Pol u cor. Iŋ hii Sidɔ̃‑i, wuɔ hã-yo hũmelle‑i u suur nelleŋ-huɔŋga-na ka taara u yufieŋ-niini‑i u jɛ̃naamba wulaa bir jo. ");
INSERT INTO cmeNT_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Iŋ siire Sidɔ̃‑i-na diɛ cor, fafal muɔ ta mu jãrã-yiɛ. Yiɛ naa yiɛ cĩil ka bella Sipire kɔtuɔŋgu‑i tiɛ kã, ");
INSERT INTO cmeNT_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","kã ka cor Silisi‑i aa sire ka cor Pãnfili‑i kã ka hi Mira, dii Lisi mara nuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Iŋ hii Mira‑i, sorosi ba yuntieŋ wuɔ da baatoŋo naŋo hilaa Alɛsãndiri tuɔ kã Itali‑i-na, wuɔ ce i hel suur u yaa nuɔ‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Iŋ biyaa hũmelle‑i, i saa gbãa tiɛ gbar fafamma; i ciɛ sũlma‑i dumɛi diɛ ka hi Kinide‑i. Kuŋ ciɛ dumaaŋo-na, i daa yinni hũmelle-na. Iŋ juɔ ne da fafalmu sa hũu-ma, yiɛ karnu hel Salmone, a cĩil Kirɛti kɔtuɔŋgu naŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Iŋ fiɛ kã terieŋgu-na, i ciɛ sũlma‑i dumɛi aa diɛ hi baatoŋ ba munyiɛrammu maŋ baŋ bĩŋ-muŋ «Munyiɛrafafammu‑i»; dii Lase caaŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","I bãaŋgu cuɔ hũmelle-na cor, a ce *Yuifu ba sũŋgu maŋ baŋ dii-kuŋ dĩkara-huɔŋgu-na, ku ji cor. Kuɔ migãaŋ ta ku balaŋ-yiɛ baatoŋo gbarma-na ku kã. Polŋ daa-ku dumaaŋo-na, wuɔ gboya bamaŋ waa baatoŋo-na wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","«Mi jɛ̃naaŋ namaa, diɛ suuye i yufieŋa‑i aa cor, i siɛ ka hi. Baatoŋo siɛ hi, coŋgorni siɛ hi! Aa miɛ fɛrɛ‑i diɛ saa gbãŋ, i ka tĩɛ-maŋ.» ");
INSERT INTO cmeNT_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Baatoŋo yuntieŋo‑i baa u tieŋo‑i baa yagar Pol nuŋgu‑i. Sorosi ba yuntieŋ wuɔ bi cu ba huoŋ-nu. ");
INSERT INTO cmeNT_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Iŋ ŋa naa yiɛra munyiɛrammu maŋ nuɔ‑i, mu saa fa waaŋ-huɔŋgu‑i. Munyiɛrammu nammu bi waa Feniki‑i-na dii Kirɛti bãsuuruŋgu-na. Iŋ waa baa bamaŋ, ba fɔ̃ŋgũɔ baa cira i gbãŋ kpelle a hi terieŋgu faŋgu‑i, kɛrɛ ba taara ba ka tĩɛna kusuɔŋ-nu'i aa waaŋgu cor. ");
INSERT INTO cmeNT_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Fafalmu maŋ taa mu jo huɔŋgu faŋgu-na, mu saa waa baa fɔ̃ŋgũɔ dumaa. Muɔ hilaa cicaaryaŋga ta mu kã dɔryaŋga. Baa da niɛ sĩ ma ka dɔl-ba. Baa ce yiɛ sire bella Kirɛti kɔtuɔŋgu‑i tiɛ kã. ");
INSERT INTO cmeNT_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","I saa maa, fafalmu naŋ teŋ muɔ sire i dɔryaŋga-na a jo ji suuye-yiɛ; ba bĩ fafalmu fammu‑i «Erakilɔ̃». ");
INSERT INTO cmeNT_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Baatoŋ wuɔ tuɔ kã kɔtuɔŋgu; i saa gbãa diɛ yiɛra-yuɔ, yiɛ naa yiɛ yaŋ muɔ ta mu kã baa-ye mu muŋkãmmu. ");
INSERT INTO cmeNT_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Yiɛ kã ka cor terieŋgu naŋgu kɔtuɔŋgu-na aa yaŋ-ku i nadieŋ-na. Ba bĩ terieŋgu‑i Koda. Kuɔ cĩnnu-yiɛ cɛllɛ fafalmu-na. Beŋo naŋo waa baa-ye tuɔ kãyã-yiɛ. Iŋ cĩɛnu dumaaŋo-na, yiɛ gbãŋ baa ufaŋo‑i haa-yo baatoŋo-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Iŋ haa-yo, maacenciraamba maŋ dii baatoŋo-na, baa ce iyiemba a pɛ̃rã baatoŋo‑i wuɔ u baa ji bĩɛna. Yiɛ kãalã yiɛ sĩ fafalmu ka kã baa baatoŋo‑i Libi jãmalã yaŋga u ka nyugũŋ hĩɛmugãaŋgu-na yiɛra i wulaa; a ce dumaaŋo-na, yiɛ hiire baatoŋo kompaŋga‑i aa naa yaŋ i fɛrɛ hã fafalmu ta mu kã baa-ye mu muŋkãmmu. ");
INSERT INTO cmeNT_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Ku cuo kaala‑i-na, fafalmu yagar ce hũmma ta ma sagalla-yiɛ bɔ̃mbɔ̃ŋ ma naara. Yiɛ naa yiɛ parra coŋgorni‑i nanna hũmma-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Yiiŋgu faŋgu curoŋo-na, bamaŋ ciɛŋ maacemma‑i baatoŋo-na, baa biɛ baatoŋ-bĩmbĩnni‑i baa ba fɛrɛŋ nammu a nanna-niɛ. ");
INSERT INTO cmeNT_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","I ciɛ yinni bɔi molo sa da bãaŋgu yufelle baa mɔɛŋa‑i hiere. Fafal muɔ bi tĩɛ mu temma‑i kunaŋgu sa parra-muɔ. I saa tiraa tiɛ hĩŋ taaluŋgu i fɛrɛŋ nuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","I daa yinni i saa wuo kuuwuoŋgu. Pol wuɔ sire yiɛra i hɔlma-na aa cira: «Mi jɛ̃naaŋ namaa, kuɔ naa naa nu mi nuŋgu‑i aa i tĩɛna dii Kirɛti‑i-na, mamaŋ juɔ ta ma da-ye daama‑i a ji ce i tiɛ nanna coŋgorni‑i, maa naa saa da-ye. ");
INSERT INTO cmeNT_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Mamaŋ dii fiɛfiɛ‑i-na, fĩɛŋ na hɔmmu‑i, molo siɛ ku, baatoŋo yaa ka tĩɛ-maŋ yoŋ. ");
INSERT INTO cmeNT_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Miŋ cuu Diiloŋo maŋ huoŋ-nu'i ta mi cãa-yo, u puɔraa *dɔrpɔpuɔrbiloŋo naŋo‑i mi wulaa isuɔŋgu-na u ji waŋ baa-mi ");
INSERT INTO cmeNT_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","wuɔ mi baa kãalã, kɛrɛ da ku fiɛ ce niɛ niɛ, mi ka hi jãmatigi‑i u ce mi ãndaaŋgu‑i. A ce dumaaŋo-na, bamaŋ dii baa-mi hiere u ka bi kor-ba, u siɛ yaŋ ba ku. ");
INSERT INTO cmeNT_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Terieŋgu faŋgu-na, fĩɛŋ na hɔmmu‑i, mi haa mi naŋga‑i Diiloŋo-na. Uŋ waaŋ-ma dumaa u ka bi ce-ma dumɛi. ");
INSERT INTO cmeNT_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Mi suyaa miɛ fafalmu ka kã baa-ye ka nanna bomborma nammaŋ.» ");
INSERT INTO cmeNT_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Fafalmu bĩɛŋ baa-ye da suu hũmma-na a ce yinni cĩncieluo ni siɛi. Cĩncieluo ni naa yiiŋgu isuɔŋgu-na, isuɔholleŋ juɔ ta di hi, bamaŋ ciɛŋ maacemma‑i baatoŋo-na, baa suɔ wuɔ i piɛ bomborma namma. ");
INSERT INTO cmeNT_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Baa fi hũmma pupurma‑i a da ma yuu mɛtiribaa komorre baa cĩncieluo niehãi. Yiɛ cor. Iŋ kaa maa cɛllɛ, ba tiraa fi-ma, a da ma yuu mɛtiribaa komorre baa niisiɛi. ");
INSERT INTO cmeNT_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Baa ta ba kãalã wuɔ sĩ baatoŋo ka kã ka jũŋ tãmpĩɛŋa hũmma-na. Baa ful baatoŋo fagammu naa huoŋ-yaŋga-na aa tĩɛna ta ba niya cuo kaalma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Ku huoŋgu-na, baa ji ta ba taara ba hel gbar. Baa hiire beŋo maŋ waa baa-ye baatoŋo-na aa gbɛ̃-ye dumaa wuɔ ba taara ba hiire gbu baatoŋo fagammu nammu yaaŋga-na a bella-yuɔ u baa ji bibirre. ");
INSERT INTO cmeNT_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Pol wuɔ gbɛ̃ sorosibaa-ba‑i baa ba yuntieŋo‑i wuɔ: «Da ŋ da na yaaŋ balaŋ daaba hel, na ka tĩɛ-maŋ.» ");
INSERT INTO cmeNT_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Baa naa hiel beŋo‑i aa vaa-yo baa iyiemba namba bella-yuɔ. Polŋ juɔ piiye dumaaŋo-na, sorosibaa baa kar iyieŋ daaba‑i aa naa yaŋ beŋo ta. ");
INSERT INTO cmeNT_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Iŋ tĩɛnaana tiɛ cie cuo kaalma‑i, Pol wuɔ cira: «I ciɛ yinni cĩncieluo baa ni naa yaa dɛi hɔculle-na, aa molo saa dii kuuwuoŋgu u nuŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Jande, wuyaaŋ! Ku yaa fɔ̃ŋgũɔ ka da-nɛi na hel-mɛi. Baa na tie holle, i ka hi hĩnni hiere unaŋ yuŋgu siɛ jaŋ-yo.» ");
INSERT INTO cmeNT_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Uŋ piiye dumaaŋo-na, *buruo naŋo waa, wuɔ biɛ-yo aa jaal Diiloŋo‑i ba yaaŋga-na hiere aa bũl-oŋ a doŋ tuɔ wuo. ");
INSERT INTO cmeNT_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Sirɛiŋa suɔ da-ba hiere baa kã ba ta ba wuo. ");
INSERT INTO cmeNT_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Miɛ maŋ waa baatoŋo-na, i waa nuɔŋ miɛ nuɔsũɔ komuɔŋa siɛi baa cĩncieluo nuɔŋ miɛ niediei. ");
INSERT INTO cmeNT_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Baatoŋ daa wuɔ tũyãa dĩmma yaa bɔi. Baŋ juɔ wuo tĩ, baa huɔl-ma kũnna hũmma-na a parra coŋgorni‑i aa baatoŋo duɔ ce fiɛfiɛ. ");
INSERT INTO cmeNT_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Cuoŋ juɔ kaal, maacenciraaŋ baa fara da terieŋgu naŋgu‑i ba saa suɔ-ku, aa da hũmma wuyaa terieŋgu faŋgu yiɛŋgu naŋgu‑i. Baa cira ba ka gbãŋ kpelle hi terieŋgu faŋgu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Baa fir baatoŋo‑i aa yaŋ fagammu‑i dii hũmma-na, aa naa bi fir yilemmu iyiemba‑i. Baŋ ciɛ mafamma‑i, baa vaa baatoŋo kompaŋga‑i yaaŋga-na fafalmu da mu kã baa-ye terieŋ daaku-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Iŋ taa ka hi hɔlma namma‑i, hĩɛmugãaŋ kuɔ yiɛra baatoŋo‑i u saa gbãa duɔ cor. U yaaŋga suurii hiere hĩɛmugãaŋgu-na. Hũŋ maa ta ma jo ma naŋ u tuole‑i ma kara-diɛ. ");
INSERT INTO cmeNT_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Sorosibaa-baŋ daa-ma dumaaŋo-na, baa cira ba ko kasobiemba maŋ waa baa-ye hiere wuɔ sĩ da ba sɔ hel ba ka gbar. ");
INSERT INTO cmeNT_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Ba yuntieŋ wuɔ cie-ba. U saa tuɔ taara ba ko Pol ku'i ciɛ wuɔ cie-ba aa naa cira: «Bamaŋ suyaaŋ sɔmma, ba ta yaaŋga ba ta ba sɔ ba kã bomborma-na, ");
INSERT INTO cmeNT_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","banamba ka nyugũŋ baatoŋ-yilanni-na cu ba huoŋ-nu.» Ba ciɛ dumɛi a gbãa huɔl hiere; molo saa tĩɛ-maŋ. ");
INSERT INTO cmeNT_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Iŋ namalãayã huɔl hũmma-na tĩ huɔŋgu maŋ nuɔ‑i, yiɛ yuu, baa cira terieŋgu faŋgu‑i ba bĩ-ku Malti. ");
INSERT INTO cmeNT_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","A ne da diilo taa u dãa, waaŋgu'i daaku. Terieŋgu faŋgu taamba silaa ce baa-ye, a dii dãŋgbɔguɔŋgu naŋ temma aa bĩ-ye i ka tiɛ yiraaŋ. ");
INSERT INTO cmeNT_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pol wuɔ kaal daamiɛŋa naŋa duɔ dii dãamu-na, a ne da gbeina waa galla-yɛi, Pol saa da-yo. Dãamuŋ wurii bel-o, wuɔ doŋ Pol naŋga‑i a pãŋ nyaar. ");
INSERT INTO cmeNT_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Terieŋgu faŋgu taambaŋ daa mafamma‑i, ba tĩiŋgu naŋgu waa ba taa ba bĩ-ku «Ninsontieŋo», baa ta ba piiye baa ba-naa wuɔ: «Naacolŋ daayo siɛ waa dii nelfɛfɛiŋo, u ka waa nelkoroŋo. Na saa da, uŋ fiɛ kor hũmma-na, Ninsontieŋo saa yaŋ-yo.» ");
INSERT INTO cmeNT_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Pol wuɔ misĩrrã jĩɛŋo‑i dii-yo dii dãamu-na aa yiɛra tuɔ ne; bĩŋkũŋgu saa ce-yo. ");
INSERT INTO cmeNT_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Ba taa ba ne wuɔ sĩ u ka pãŋ nyurã terduɔŋgu faŋgu-na, sisɔ u ka pãŋ ku. Baa niya, niya, ba saa ji da bĩŋkũŋgu ciɛ. Baa bir yaŋ aa ta ba piiye wuɔ: «Naacolŋ daa u siɛ waa dii gbãŋgbãŋ.» ");
INSERT INTO cmeNT_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Iŋ waa terieŋgu maŋ nuɔ‑i, ba fãamaaŋo dumɛlle saa naa maa baa-ku. Ba taa ba bĩ-yo Pubilusi. Wuɔ gbuu bel-e ŋaa u jɛ̃naaŋ miɛ aa ce i ce yinni siɛi baa-yo u dumɛlle-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","U to wuɔ waa galla; wuɔ sa waa hĩnni, tɔgɔtɔgɔniŋo'i waa-yuɔ aa u kũɔma tiraa huol da pãmpãmpãŋ. Pol wuɔ suur ka haa u nammu‑i yuɔ aa cãrã Diiloŋo‑i hã-yo; wuɔ pãŋ sire. ");
INSERT INTO cmeNT_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Polŋ siire bĩncɔiŋo‑i, jaamba maŋ waa nelle-na, baa jo u ji sire-bɛi. ");
INSERT INTO cmeNT_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Uŋ siire jaamba‑i dumaaŋo-na, baa migãaŋ bel-e fafamma naara. Iŋ juɔ'a i ta, bĩmbĩnni maŋ maama‑i waa-yiɛ hiere, baa hã-ye baa-ni wuɔ i bel i naŋ-na tiɛ kã. ");
INSERT INTO cmeNT_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","I ciɛ caamba siɛi Malti‑i-na aa suɔ diɛ cor. Iŋ'a i ta, yiɛ suur baatoŋo naŋo-na, ba bĩ-yo «Diyɔsikuur» ku yuŋgu yaa wuɔ pĩɛbaa. Baatoŋo faŋ wuɔ hilaa Alɛsãndiri a jo ji yiɛra cie waaŋ-huɔŋgu cor. ");
INSERT INTO cmeNT_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Iŋ taa dumaaŋo-na, yiɛ kã ka hi Sirakuse; yiɛ ce yinni siɛi kusuɔŋgu-na aa cor. ");
INSERT INTO cmeNT_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Iŋ curaa, yiɛ bella koŋkondaaŋgu‑i kã ka hi Erejo. Ku cuo kaala‑i-na, fafalmu naŋ muɔ sire i huoŋ-yaŋga-na ta mu tisĩŋ-ye; a ce dumaaŋo-na, yiɛ ce yinni hãi yoŋ aa hi Pusɔli‑i. ");
INSERT INTO cmeNT_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Iŋ hii nelle fande‑i, yiɛ da Diiloŋ-dũŋ-baamba namba. Baa cira i tĩɛna ce yinni niehãi baa-ba. Yiɛ tĩɛna ce yinni fanni‑i aa suɔ cor tiɛ kã *Ɔrɔmu‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Diiloŋ-dũŋ-baamba maŋ Ɔrɔmu‑i-na baŋ juɔ nu wuɔ i jo dii, baa sire jãrã jo nelle nande-na, ba bĩ-de «Ducɔnni siɛi». Banaŋ baa cor jo Apiyusi saŋga-na da ba ji jãrã-yiɛ. Polŋ juɔ'a u ne da-ba, wuɔ jaal Diiloŋo‑i aa naa migãaŋ dii sirɛiŋa u fɛrɛŋ nuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Iŋ kaa hi Ɔrɔmu‑i, ba saa dii Pol kaso‑i-na baa kasobiemba namba‑i; baa ce u kã ka biɛ dũŋgu u deŋ, aa jĩna sorosiyiɛ tuɔ niya-yuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Polbaa-baŋ hii *Ɔrɔmu‑i, wuɔ ce yinni hãi, siɛliŋ-yiiŋgu‑i, wuɔ bĩ *Yuifu ba bĩncuɔmba maŋ waa terieŋgu-na ba jo u wulaa. Baŋ juɔ, wuɔ gbɛ̃-ba wuɔ: «Tobiŋ namaa, naŋ daa mi bĩɛ-na dɛ‑i, ku saa balaŋ. Mi saa cãl miɛ nelleŋ-baamba‑i, mi saa bi guɔla manamma i bĩncuɔŋ-hũmelle-na, ŋga ba bilaa-mi *Yerusalɛmu‑i-na a hã *Oromɛbaa-ba‑i baa-mi. ");
INSERT INTO cmeNT_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Oromɛbaa-ba yuu-mi, mi biɛ piiye. Ba ne da mafamma saa hi mi kuliiŋgu. Ba'a ba nanna-miɛ, ");
INSERT INTO cmeNT_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","ŋga i nelleŋ-baamba yagar wuɔ ma siɛ gbãa ce. Ku yaa nuɔ‑i mi naa miɛ ba yaŋ mi ãndaaŋgu‑i hã *Oromɛ ba *jãmatigi ka ce-ku. Na baa ji da niɛ sĩ mi taara da mi dii mi nelleŋ-baamba yunni‑i wɛima-na? Ma'i sĩ. ");
INSERT INTO cmeNT_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Ku'i ciɛ mi bĩ-na da mi ji waŋ ma yaaŋga‑i baa-na. *Isirahɛl-baambaŋ hĩŋ kumaŋ taaluŋgu‑i, ba bilaa muɔŋo‑i kufaŋgu maama'i nuɔ‑i dumandɛ‑i-na.» ");
INSERT INTO cmeNT_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Bĩncuɔŋ baa cira: «Fɛ̃ ŋ huɔŋga‑i; i saa da sɛbɛ hilaa *Yude‑i-na jo wuɔ ŋ ciɛ wɛima, i saa bi da i natobiŋo naŋo juɔ wuɔ ŋ guɔlaaya bĩŋkũŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","I suyaa yiɛ niŋ suurii Diiloŋ-hũmelle maŋ nuɔ‑i, nuɔmba cĩina-diɛ terni-na hiere, ŋga miɛ taara naŋ fɛrɛ‑i ŋ waŋ di maama baa-ye.» ");
INSERT INTO cmeNT_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Baŋ piiye dumaaŋo-na, baa dii yiiŋgu baa ba-naa. Yiiŋgu faŋguŋ juɔ hi, baa jo maar yidĩɛlãŋgu‑i Pol wulaa dii u dumɛlle-na. Pol wuɔ biɛ *Diiloŋ-bãaŋgu maama‑i tuɔ piiye baa-ba, a doŋ cucuuyuŋgu-na ji tuɔ hi dãnambãaŋgu. Duɔ tuɔ piiye u kã, u ka biɛ *Moisi *ãnjĩnamma‑i piiye baa-ba, kuniɛ u biɛ *Diilopɔpuɔrbiemba maama‑i a piiye baa-ba. U taa u ce mafamma‑i ba da ba suɔ wuɔ uŋ waŋ mamaŋ Yesu kũŋgu-na coima sĩ. ");
INSERT INTO cmeNT_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Banaŋ baa hũu-ma, banamba saa hũu-ma. ");
INSERT INTO cmeNT_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Kuŋ ciɛ dumaaŋo-na, baa hel ba-naa honniŋ aa naa sire ta ba ta. Pol wuɔ cira: «Ma dɔlaa *Diiloŋ-Yalle puɔr *Isayi‑i i bĩncuɔmba wulaa. Diiloŋ-Yalle gbĩɛ-yo wuɔ: ");
INSERT INTO cmeNT_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‹Kã ŋ ka waŋ baa Isirahɛl-baamba‑i wuɔ ba nu nelma‑i ŋga ba sa suɔ ma yaaŋga‑i; ba ne colcol ŋga ba sa da bĩŋkũŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Ba nyaayã ba fɛrɛ. Ba suuye ba tũnni‑i ba sa taara ba nu baa-ni, aa suuye ba yufieŋa‑i ba sa taara ba da baa-ya. Ba sa taara ba suɔ mi nelma yaaŋga‑i aa jo mi ji kor-ba.›» ");
INSERT INTO cmeNT_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Pol wuɔ cira: «Terieŋgu faŋgu-na, na saaya na suɔ wuɔ fiɛfiɛ‑i-na, Diiloŋo birii saaŋ koŋkor-nelma‑i hã *niɛraamba baa-ma. Bafamba fuɔ, ba ka nu-ma.»  ");
INSERT INTO cmeNT_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Polŋ piiye dumaaŋo-na, Yuifubaa baa gbuu ta ba fanu ba-naa u nelma-na ba kũŋ. ");
INSERT INTO cmeNT_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Pol wuɔ biyaa u yerreŋ dũŋgu Ɔrɔmu‑i-na. U ciɛ bieŋa hãi dũŋgu faŋgu-na. Nuɔmba taa ba kã u wulaa. U saa tuɔ donya moloŋo u fɛrɛŋ nuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","U taa u waŋ Diiloŋ-bãaŋgu maama‑i baa nuɔmba‑i aa tuɔ kalaŋ-ba baa Itieŋo‑i Yesu-Kirsa maama‑i. U holle saa ta di tie baa ma cemma‑i aa u waa u fɛrɛŋ nuɔ.");
INSERT INTO cmeNT_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Muɔ Pol, muɔmɛi nyɛgãaŋ sɛbɛ daayo‑i. Yesu-Kirsa cãarãŋ muɔ. Diiloŋo ciɛ-mi Yesu *pɔpuɔrbiloŋ muɔ aa bɔ-mi mi deŋ mi ta mi wuɔra mi waŋ u *Neldɔdɔlma‑i baa nuɔmba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Nelma famma‑i Diiloŋ uŋ pãa ma nuŋgu‑i ku bãaŋgu cuɔ. Wuɔ ciɛ u *pɔpuɔrbiemba yaa nyɛgɛ̃ŋ-ma u sɛbɛ‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Ma vii u Biɛŋo yaa‑i Itieŋo‑i Yesu-Kirsa‑i. A saa baa u nelbilosĩnni‑i, u waa jãmatigi *Davidi hãayɛ̃lŋo. ");
INSERT INTO cmeNT_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Ŋga uŋ kuu aa sire, *Diiloŋ-Yalle pigãaŋ wuɔ Diiloŋ-Biɛŋo kelkel. ");
INSERT INTO cmeNT_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Fuɔ barguɔ yaa nuɔ‑i Diiloŋ uŋ ciɛ baa-mi a ce-mi u pɔpuɔrbiloŋ muɔ u yerre fafaaŋgu maama-na, nuɔmba‑i nilɛiŋa-na hiere ba da ba haa ba naŋga yuɔ aa ta ba nu u nuŋgu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Diiloŋ uŋ bĩɛ namaa namaŋ a hã Yesu-Kirsa‑i, na nuŋgu bi dii nuɔŋ daaba-na. ");
INSERT INTO cmeNT_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Diiloŋ uŋ dɔlaa namaa namaŋ Ɔrɔmu‑i-na hiere aa bĩ-na ce-na u baaŋ namaa, mi nyɛgɛ̃ŋ sɛbɛ daayo‑i da mi hã namɛi. I To‑i Diiloŋo‑i, baa Itieŋo‑i Yesu-Kirsa‑i ba kãyã-nɛi aa fɛ̃ na hɔmmu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Mi ka jaal Diiloŋo yaa igɛ̃na na maama-na, Yesu-Kirsa barguɔ‑i-na. Hama‑i nuɔ‑i? Ku yuŋgu yaa daaku: Nilɛiŋa-na hiere ba waŋ na Diiloŋ-hũmelleŋ-kũŋgu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Yinni maŋ joŋ na maama sa karaanu-miɛ mi Diilocãrãlle-na; Diiloŋo yaa mi siɛra. Mi waŋ u Biɛŋo *Neldɔdɔlma‑i baa nuɔmba‑i, kuu dii ŋaa mi cãa Diiloŋo‑i baa huɔŋga diei yoŋ. ");
INSERT INTO cmeNT_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Mi bi cãrã-yuɔ bãaŋgu‑i baa isuɔŋgu‑i, wuɔ duɔ siɛ, u yaŋ mi da kã na wulaa. ");
INSERT INTO cmeNT_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Mi gbu mi taara mi da na yufelle a cal Diiloŋo sãmma‑i baa-na ku yaa fɔ̃ŋgũɔ ka da-nɛi. ");
INSERT INTO cmeNT_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Mi taara mi cira: Da mi kã i ka da i-naa, i ka gbãa dii sirɛiŋa i-naa nuɔ i Diiloŋ-hũmelle wuɔsaaŋgu-na. ");
INSERT INTO cmeNT_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Tobiŋ namaa, mi taara na suɔ wuɔ miŋ duɔŋ ta mi dii yinni‑i wuɔ mi kã na terieŋgu-na ku yuu niele, ŋga ji hi baa nyuŋgo, mi saa hi da mi fɛrɛ yogo. Mi taara mi maacemma da belle na hɔlma-na ŋaa maŋ daa belle dumaa yammu nammu-na. ");
INSERT INTO cmeNT_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Mi saaya mi hi nuɔmba‑i hiere baa Neldɔdɔlma‑i: bamaŋ yufieŋa‑i puurii baa bamaŋ yufieŋa‑i saa puur, ka cor baa bamaŋ suyaaŋ yiɛŋgu‑i baa bamaŋ sa suyaaŋ yiɛŋgu‑i hiere. ");
INSERT INTO cmeNT_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Ku'i ciɛ mi ta mi taara mi ka waŋ-ma baa namaa namaŋ bi dii tĩɛna Ɔrɔmu‑i-na. ");
INSERT INTO cmeNT_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Senserre sa da-mi baa *Neldɔdɔlma wamma‑i. Ma yaa Diiloŋo fɔ̃ŋgũɔ‑i. U ce ma yaa‑i u kor bamaŋ hũyãa-ma hiere, a doŋ *Yuifubaa-ba-na ka cor baa *niɛraamba‑i hiere. ");
INSERT INTO cmeNT_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Neldɔdɔl daama pigãaŋ Diiloŋ uŋ kãŋ nuɔmba‑i dumaa nelviimba. Viisĩnni da Yesu yaa nuɔ‑i yoŋ; da ŋ haa ŋ naŋga‑i yuɔ, Diiloŋo tuɔ kãŋ-ni nelviiŋ nuɔ ŋaa maŋ nyɛgãaŋ dumaa u nelma-na wuɔ: «Umaŋ duɔ haa u naŋga‑i Diiloŋo-na, nelviiŋo; u ka kor.» ");
INSERT INTO cmeNT_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Diiloŋo tĩyãa dii dɔrɔ‑i-na aa tuɔ pigãaŋ nelbiliemba‑i wuɔ u huɔŋga duu baa-ba, kɛrɛ ba sa kãŋ-yo aa ba sa bi tiraa ce u huɔŋga‑i. Ba ce ba maacembabalamma‑i ba fĩɛna ninsoŋo‑i. ");
INSERT INTO cmeNT_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Ŋ siɛ suɔ wuɔ kumaŋ gbãa suɔ Diiloŋ-kũŋgu-na, ku saa fuo-bɛi. Diilo fuɔ fɛrɛ yaa pigãaŋ-ba baa-ku. ");
INSERT INTO cmeNT_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","U pigãaŋ-ba baa-ku niɛ niɛ? Moloŋ yufelle saa haa Diiloŋo-na dede, ŋga diɛ ne uŋ hielaa miwaaŋo‑i dumaa dii ku huɔŋgu-na ji hi baa nyuŋgo, i da u sĩnni‑i baa u himma‑i u maacemma-na. A ce dumaaŋo-na nelbiliemba siɛ da ãntãalãmma. ");
INSERT INTO cmeNT_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Ba suyaa Diiloŋo‑i aa yagar ba sa dii u nuŋgu‑i ku diima, ba sa jaal-o ku jaaluŋgu. Ba yunni kuu aa yaŋ-ba, ba ãnjɔguɔma piɛra-bɛi dii-ba kukulma-na. ");
INSERT INTO cmeNT_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Ba daa niɛ sĩ ba cɛ̃ a ne da ba milãaŋ. ");
INSERT INTO cmeNT_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Ba birii yaŋ Cagaaŋ-Diiloŋo maŋ sa ji kãaŋ terieŋgu aa sisĩŋ nelbiliemba baa bĩmbaamba‑i ta ba buol. Huriimba‑i dii, baabũulãamba bi dii. A ne da tãmmaŋ-bĩŋkũŋgu sa cɔ. ");
INSERT INTO cmeNT_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Diiloŋo daa-ma dumɛi u yaŋ-ba ba fɛrɛŋ nuɔ ba kakarkuoŋ-maacemma-na ba ta ba ce kumaŋ dɔlaanuŋ-bɛi. Ba tĩyãa ku yaa nuɔ‑i ta ba ce sensenda-wɛima‑i ba-naa nuɔ. ");
INSERT INTO cmeNT_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Ba yaaŋ Diiloŋo ninsoŋo‑i aa cu coimaŋ huoŋ-nu. Diiloŋ uŋ hielaa bĩmbĩnni maŋ, ba buol ni yaa‑i aa ta ba pã niipãnni ba hã-ni aa bir yaŋ umaŋ hielaa-ni. A ne da u yaa saaya gbɛliɛma hɔnni maŋ joŋ. Ma ciɛ! ");
INSERT INTO cmeNT_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Diiloŋo daa-ma dumɛi u yaŋ-ba ba fɛrɛŋ nuɔ ba ta ba ce ba sensenda-wɛima‑i. Ba caamba birii yaŋ bɛmba‑i aa ta ba galla baa ba nacaamba. ");
INSERT INTO cmeNT_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Bɛmba‑i maaduɔma, ba yaaŋ caamba‑i aa ta ba ku ba-naa maa-na. Ba naaŋ bĩŋwosĩnniŋ; ba galla baa ba nabɛmba. A ce dumaaŋo-na, baŋ taaraŋ kumaŋ ba da-ku. ");
INSERT INTO cmeNT_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Baŋ juɔ'a Diiloŋ-maama saa hi-ba, Diiloŋo naa u yaŋ-ba baa ba ãnjɔgɔbabalamma‑i ba ta ba ce kumaŋ saa saaya cemma. ");
INSERT INTO cmeNT_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Balaaŋgu‑i hiere ku gbuɔra ku-naa bɛi. Ba sa fũnuŋ suɔ baŋ bĩŋ kumaŋ ãnfafamma‑i gbula: cãncaaya'i daayo, hɔbabalaŋga'i daaka, nenemuŋgu'i daaku, nelkolle'i daade, bɛrru'i daadu, huhurma'i daama, balaaŋgu'i daaku. Ba yaa sikuɔntaamba, ");
INSERT INTO cmeNT_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","yebĩɛnataamba. Ba bigãaŋ Diiloŋo‑i, bubɔlaamba, bombolmantaamba, fofortaamba, ba hinu kuubabalaaŋgu cemma'i ŋaa bige‑i, ba sa nu ba bĩncɔiŋ nuŋgu. ");
INSERT INTO cmeNT_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Ba yunni kuu aa yaŋ-ba, ba sa kã yaduɔŋga, hɔduraamba, ba sa ce hujarre nɛliɛŋ-na. ");
INSERT INTO cmeNT_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","A ne da ba suyaa wuɔ Diiloŋo wulaa, bamaŋ ciɛŋ kumaŋ daaku temma‑i, ba saa baa kuliiŋgu! Ŋga ba suuye ba yufieŋa‑i ta ba ce-ku, aa tiraa ta ba dii sũnuŋgu ba hã bamaŋ ciɛŋ-kuŋ. ");
INSERT INTO cmeNT_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Nuɔni maŋ daaŋ nelma ŋ cãl banamba‑i, da ŋ fiɛ waa niɛ niɛ, ŋ siɛ kor. Da ŋ ta ŋ cãl banamba‑i, kuu dii ŋaa ŋ cãl ŋ fɛrɛ. Hama‑i nuɔ‑i? Naa dii kuuduɔŋgu yaa hiere. ");
INSERT INTO cmeNT_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","I suyaa wuɔ bamaŋ ciɛŋ maacembabalaŋ daama temma‑i, Diiloŋ uŋ haa kumaŋ bɛi, u ninsoŋo. ");
INSERT INTO cmeNT_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Nuɔ da ŋ ta ŋ cãl banamba‑i, aa bi ta ŋ ce ba temma‑i, ŋ yuu wuɔ ŋ ka kor Diiloŋo wulaa wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Sisɔ Diiloŋ uŋ gbuu fũnuŋ fa aa waa hɔhĩnantieŋo, naŋ daa kufaŋgu‑i ãnsɔsɔmma wɛi? Ŋ saa suɔ wuɔ u fafaaŋgu saaya ku ce ŋ bir ŋ ciluɔ‑i wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Ŋga niŋ'a ŋ sa nu baa ŋ tũnni‑i, aa yagar wuɔ ŋ siɛ bir ŋ ciluɔ‑i, naŋ fɛrɛ'i taaraayaŋ yaahuolbabalaŋo‑i ŋ hã ŋ fɛrɛ Diiloŋ uŋ ka pigãaŋ nuɔmba‑i u jãyãmma‑i yiiŋgu maŋ nuɔ‑i. U suɔ u pã. ");
INSERT INTO cmeNT_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","U ka pã nɛliɛŋo nɛliɛŋo baa u maacemma sullu‑i. ");
INSERT INTO cmeNT_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Bamaŋ vaa ba fɛrɛ baa ãnfaaŋo‑i Diiloŋo duɔ gbɛliɛŋ-ba aa da ba da cicɛ̃lma maŋ sa tĩɛŋ dede‑i, ma ka dɔl-ba. ");
INSERT INTO cmeNT_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Ŋga bamaŋ puu bubuɔsĩnni baa-yo, bamaŋ cĩinaana ninsoŋo‑i aa faya ba fɛrɛ baa ãmbabalma cemma‑i, u ka pigãaŋ-ba u jãyãmma‑i. ");
INSERT INTO cmeNT_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Bamaŋ ciɛŋ ãmbabalma‑i, ba ka da yaahuolo‑i baa mulĩɛma yar-ba. A doŋ *Yuifubaa-ba-na ka cor baa *niɛraamba‑i hiere. ");
INSERT INTO cmeNT_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","11","A ne da umaŋ ciɛŋ ãnfafamma‑i, duɔ fiɛ tuɔ hel hie, Diiloŋo sa ce ciɛluɔ; u ka gbɛliɛŋ kutieŋo‑i aa ce-yo bɔi aa fɛ̃ u huɔŋga‑i. A doŋ Yuifubaa-ba-na ka cor baa niɛraamba‑i hiere. ");
INSERT INTO cmeNT_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Bamaŋ saa suɔ *Moisi *ãnjĩnamma‑i aa ta ba wuɔ ba cãl, Diiloŋo ka caa-ba; ŋga u sa ka ne ãnjĩnamma aa caa-ba. A ne da bamaŋ suyaa-ma hiere aa suuye ba yufieŋa‑i ta ba wuɔ ba cãl-ma, u ka yuu-ba saa baa ma yaa‑i aa caa-ba. ");
INSERT INTO cmeNT_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Baa na ta na ne wuɔ sĩ bamaŋ nuɔŋ ãnjĩnamma‑i yoŋ ba yaa nelviimba‑i Diiloŋo wulaa; ba'i sĩ. Bamaŋ wuɔyaaŋ ma hũmelle‑i di kũŋgu-na hiere, ba yaa nelviimba‑i. ");
INSERT INTO cmeNT_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Na saa da, ãnjĩnamma si dii baa niɛraamba‑i, ŋga ba suɔ-ma ba karnu ba wuɔ ma hũmelle‑i. Maŋ fiɛ'a maa si dii baa-ba ba nammu-na, maa dii ba hɔmmu-na. ");
INSERT INTO cmeNT_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Dumaaŋo-na, ba ciluɔ pigãaŋ wuɔ ãnjĩnammaŋ taaraŋ nuɔmba ta ba ce kumaŋ, kuu dii ba hɔmmu-na. A naara kufaŋgu‑i, baŋ suɔ ãnfafamma‑i bɔ-ma ãmbabalma-na, ba hɔmmu sa hũu-ma ba ce manaŋ temma, ku bi pigãaŋ wuɔ ãnjĩnamma dii ba hɔmmu-na. ");
INSERT INTO cmeNT_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Gɛ̃ŋgɛryiiŋgu-na, mafamma‑i hiere ma ka suɔ. A saanu baa miŋ waŋ *Neldɔdɔlma maŋ, yiiŋgu faŋgu-na, Diiloŋo ka ce Yesu-Kirsa gɛr nuɔmba yuŋ-maama‑i. Mamaŋ fuyaa hiere, ma ka hel bomborma-na. ");
INSERT INTO cmeNT_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Nuɔni maŋ wuɔ nuɔ *Yuifuyiɛŋ nuɔ, wuɔ naŋ suɔ *Moisi *ãnjĩnamma‑i, ŋ kaal ŋ fɛrɛ wuɔ Diiloŋo‑i namaa wuoŋo, ");
INSERT INTO cmeNT_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","ŋ suɔ Diiloŋo kusũŋgu‑i, aa ãnjĩnamma ciɛ ŋ ta ŋ suɔ kumaŋ faa cemma. ");
INSERT INTO cmeNT_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Nuɔni maŋ wuɔ nuɔnɛi diyaaŋ nuɔmba‑i hũmelle-na, wuɔ nuɔnɛi puuriiŋ nuɔmba yufieŋa‑i, ");
INSERT INTO cmeNT_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","wuɔ nuɔnɛi pigãaŋ bamaŋ sa suyaaŋ kuyuŋgu, wuɔ nuɔnɛi kalaaŋ bamaŋ sa suyaaŋ yiɛŋgu, wuɔ ãnjĩnamma ciɛ naŋ suɔ nelma‑i hiere baa ninsoŋo‑i hiere. ");
INSERT INTO cmeNT_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Nuɔni maŋ hãalãayãŋ banamba‑i, bige‑i ciɛ ŋ sa hãalã ŋ fɛrɛ? Nuɔni maŋ wuɔ cuoyuŋgu saa fa, bige‑i ciɛ naŋ ta ŋ cuo? ");
INSERT INTO cmeNT_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Nuɔni maŋ wuɔ *fuocesĩnni saa fa, bige‑i ciɛ naŋ ta ŋ ce-ni? Nuɔni maŋ sa taaraayaŋ ŋ da tĩnni‑i baa ŋ yufelle, bige‑i ciɛ ŋ ta ŋ biɛ bĩmbĩnni‑i tĩnniŋ-dũnni-na? ");
INSERT INTO cmeNT_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Nuɔni maŋ kaalaaŋ ŋ fɛrɛ wuɔ ãnjĩnamma dii baa-ni, bige‑i ciɛ ŋ ta ŋ cãl ma wuɔsaaŋgu‑i ŋ bĩɛna Diiloŋo yerre‑i. ");
INSERT INTO cmeNT_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Diiloŋ-nelma gbaraa-ma wuɔ: «Namɛi ciɛ *niɛraamba sa kãŋ Diiloŋo‑i.» ");
INSERT INTO cmeNT_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Da ŋ ta ŋ wuɔ ãnjĩnamma‑i, yuŋgu dii ŋ *jãmma-na. Ŋga da ŋ'a ŋ sa wuɔ ãnjĩnamma‑i, yuŋgu si dii ŋ jãmma-na. ");
INSERT INTO cmeNT_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Ŋaa umaŋ duɔ saa *jã aa tuɔ wuɔ ãnjĩnamma‑i fafamma, ku ce Diiloŋo ka cĩina-yuɔ wuɔ u saa jã wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Terieŋgu faŋgu-na, nuɔni maŋ jãa aa ãnjĩnamma sɛbɛ waa baa-ni aa ŋ sa wuɔ ma hũmelle‑i, fuɔ maŋ saa jã aa tuɔ wuɔ-de u ka cira ŋ cãlãa cemma. ");
INSERT INTO cmeNT_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Da ŋ nu wuɔ Yuifuyiɛŋo‑i, yufieŋ-nemma sĩ; aa *sĩnjãaŋgu‑i pãdorre sĩ. ");
INSERT INTO cmeNT_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Ŋga da ŋ nu wuɔ Yuifuyiɛŋo‑i, ba suɔ-yo u huɔŋ-na. Aa da ŋ bi nu wuɔ sĩnjãaŋgu‑i ba da-ku ŋ huɔŋ-na. *Diiloŋ-Yalleŋ-sĩnjãaŋgu yaa kufaŋgu‑i, ãnjĩnammaŋ-sĩnjãaŋgu sĩ. Yuifuyiɛŋ fuɔ temma‑i nuɔmba sa gbɛliɛŋ-yo, ŋga Diiloŋo'i gbɛlaaŋ-yoŋ. ");
INSERT INTO cmeNT_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Terieŋgu faŋgu-na, yuŋ haku‑i dii Yuifusĩnni-na? Yuŋgu dii sĩnjãaŋgu-na wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Yuŋgu dii Yuifusĩnni-na bãmbãale. Dĩɛlã-kũŋgu yaa daaku: Diiloŋo diyaa u nelma‑i *Yuifubaa-ba nammu yaa nuɔ‑i. ");
INSERT INTO cmeNT_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Baŋ fiɛ'a ba hiero saa ji yiɛra-mɛi, ku ce Diiloŋo ka bir baa huoŋ-ãndaaŋgu wuɔ ba saa ji yiɛra-mɛi wɛi? ");
INSERT INTO cmeNT_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","U siɛ bir baa huoŋ-ãndaaŋgu. Nelbilieŋ da ba fiɛ waa huhurmantaamba hiere, Diiloŋo siɛ gbãa ce huhurmantieŋo dede, ŋaa maŋ nyɛgãaŋ dumaa u nelma-na wuɔ: «Ninsoŋo ka waa baa-ni ŋ nelma-na hiere. Umaŋ duɔ cãl-ni, u cãlãa-ni gbãŋgbãŋ.» ");
INSERT INTO cmeNT_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Nelbiliemba gbãa bi cira wuɔ diɛ tiɛ ce ãmbabalma‑i ku saa balaŋ, kɛrɛ ku faa. Ku faa yuŋgu maŋ nuɔ‑i ku yaa daaku: Diɛ ne miɛ ãncemma‑i baa Diiloŋ-maama‑i, i suɔ ku'i nuɔ‑i wuɔ Diiloŋo faa. Wuɔ da kuɔ miɛ ãmbabalma ce i tiɛ da Diiloŋo fafaaŋgu‑i, ma bilaa niɛ u tuɔ gãŋ baa-ye? ");
INSERT INTO cmeNT_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Diiloŋ duɔ tuɔ gãŋ baa-ye, u ninsoŋo! Kuɔ u saa naa fa, uu naa ce niɛ tuɔ suɔ nuɔmba pãmma baa ba maacemma sullu‑i? ");
INSERT INTO cmeNT_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Ŋga da kuɔ miŋ kar coima maŋ, ma kaala Diiloŋo sĩnni‑i ninsoŋo aa ta ma ce Diiloŋo‑i bɔi, ma da niɛ u dii-mi baa ãmbabalmanciraamba tuɔ gãŋ baa-mi? ");
INSERT INTO cmeNT_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Da kuɔ miɛ ãmbabalma yaa ciɛŋ i tiɛ da Diiloŋo fafaaŋgu‑i, i gbãa cira ku saaya i tiɛ ce ãmbabalma‑i Diiloŋo tuɔ pigãaŋ u fafaaŋgu‑i kɛ? Yebĩɛnataamba gbĩɛ-ku dumaa wuɔ mɛi wuɔra mi waŋ ma yaa‑i. Kutaamba‑i Diiloŋo ka gãŋ baa-ba; aa ba yaa taaraaya-mɛi. ");
INSERT INTO cmeNT_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Mi gbãa waŋ wuɔ niɛ? *Yuifubaa miɛ i bɔyaa banamba-na wɛi? I saa buɔ-bɛi! Mi tagaaya pigãaŋ-na cor miɛ Yuifubaa-ba‑i baa *niɛraamba‑i hiere ãmbabalma nyugãaŋ-bɛi hiere ka saa. ");
INSERT INTO cmeNT_vpl VALUES