﻿USE sofia;
DROP TABLE IF EXISTS sofia.clu_vpl;
CREATE TABLE clu_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES clu_vpl WRITE;
INSERT INTO clu_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Maman dia anang ginalinan ni Jesu-Cristo. Si Jesu-Cristo nga dia anang kaapo-apoan ni David kag si David isara sa anang mga kaapo-apoan ni Abraham. ");
INSERT INTO clu_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Si Abraham anang tatay ni Isaac, si Isaac anang tatay ni Jacob, kag si Jacob anang tatay ni Juda kag anang mga kabogto. ");
INSERT INTO clu_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Si Juda nakapangasawa kay Tamar kag darwa andang bata, si Fares kag si Zara. Si Fares tatay ni Esrom, kag si Esrom tatay ni Aram. ");
INSERT INTO clu_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Si Aram tatay ni Aminadab, si Aminadab tatay ni Naason, kag si Naason tatay ni Salmon. ");
INSERT INTO clu_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Si Salmon nakapangasawa kay Rahab kag si Boaz andang naging bata. Si Boaz tatay ni Obed. Si Ruth anang nanay ni Obed, kag si Obed tatay ni Jesse, ");
INSERT INTO clu_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","kag si Jesse maman anang tatay ni Aring David. Kag si David nga dia tatay ni Solomon. Kag anang nanay ni Solomon ara iba kondi ang babai nga dati asawa ni Orias. ");
INSERT INTO clu_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Si Solomon tatay ni Roboam, si Roboam tatay ni Abias, kag si Abias tatay ni Asa. ");
INSERT INTO clu_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Si Asa tatay ni Josafat, si Josafat tatay ni Joram, kag si Joram tatay ni Ozias. ");
INSERT INTO clu_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Si Ozias tatay ni Jotam, si Jotam tatay ni Acaz, kag si Acaz tatay ni Esequias. ");
INSERT INTO clu_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Si Esequias tatay ni Manases, si Manases tatay ni Amos, si Amos tatay ni Josias, ");
INSERT INTO clu_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","kag si Josias tatay ni Jeconias kag anang mga kabogto. Maman dato ang tyimpo nga ang mga taga-Israel ginbiag ang mga taga-Babilonia kag gindara sanda doto sa Babilonia. ");
INSERT INTO clu_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ang sanda doto ron sa Babilonia naging bata ni Jeconias si Salatiel nga tatay ni Zorobabel, ");
INSERT INTO clu_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","si Zorobabel tatay ni Abiud, si Abiud tatay ni Eliaquim, kag si Eliaquim tatay ni Azor. ");
INSERT INTO clu_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Si Azor tatay ni Sadoc, si Sadoc tatay ni Aquim, kag si Aquim tatay ni Eliud. ");
INSERT INTO clu_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Si Eliud tatay ni Eleazar, si Eleazar tatay ni Matan, si Matan tatay ni Jacob, ");
INSERT INTO clu_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","kag si Jacob tatay ni Jose nga asawa ni Maria. Kag si Maria nga dia maman anang naging nanay ni Jesus nga ginatawag nga Cristo. ");
INSERT INTO clu_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Gani alin kay Abraham asta kay David 14 ka magbarata ang nagdarason-dason. Kag alin kay David asta sa oras nga gindara sanda sa Babilonia, 14 ra ka magbarata ang nagdarason-dason. Kag alin ruman doto asta ibata si Cristo 14 ra ka magbarata ang nagdarason-dason. ");
INSERT INTO clu_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Toladia anang pagkabata ni Jesu-Cristo. Si Maria nga anang nanay ginpangako ron kay Jose nga maging anang asawa. Piro bago sanda nagdapun nasapoan ni Maria nga tana nagabudus run paagi sa anang gaum ang Ispirito Santo. ");
INSERT INTO clu_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Karon, si Jose nga anang maging asawa tao nga matarung. Kag tungud nga si Maria nagabudus run bisan ara sanda pa nagdapun indi tana run magpakasal kanana, piro indi na ra gosto nga mauyaan si Maria. Gani naisip na nga bulagan na tana sa sikrito. ");
INSERT INTO clu_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Mintras ginabinag-binag ni Jose anang imoon, may sangka angil nga alin sa Ginoo ang nagpakita kanana sa damgo kag nagkoon dayon kanana, makon na, “Jose, ikaw nga isara sa anang mga kaapo-apoan ni David, indi kaw magkaadluk nga pangasawaun si Maria tungud nga nagpanamkun tana paagi sa Ispirito Santo. ");
INSERT INTO clu_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Lalaki anang maging bata, kag aranan mo nga Jesus, tungud nga lowasun na anang mga tao sa andang mga sala.” ");
INSERT INTO clu_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Dia tanan natabo agud matoman anang ginkoon ang Ginoo paagi sa propita nga nagakoon, ");
INSERT INTO clu_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Magabudus ang sangka daraga kag magabata lalaki, kag tawagun tana nga Emmanuel” (nga anang gostong ambalun, “Ang Dios kaiban ta”). ");
INSERT INTO clu_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Gani pagkabogtaw ni Jose gintoman na ang ginambal kanana anang angil ang Ginoo, kag ginbaton na si Maria bilang anang asawa. ");
INSERT INTO clu_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Piro ara gid magtandug si Jose kay Maria mintras ara pa nabata anang ginabudus nga dato. Kag pagkabata, ginaranan na nga Jesus. ");
INSERT INTO clu_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Si Jesus ginbata sa Betlehem sa probinsya ang Judea sa tyimpo ni Aring Herodes. Pagkabata kay Jesus may mga tao nga nagapanilag sa mga bitoon nga nagabot sa Jerusalem. Alin sanda sa sangka logar sa mororan kampi ang Jerusalem. ");
INSERT INTO clu_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Nagpamangkot sanda sa mga tao, makon, “Diin dun ang nabata nga ari ang mga Judio? Nakita namun anang bitoon pagmora, gani nagayan kami digi agud magsimba kanana.” ");
INSERT INTO clu_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Pagkabati ni Aring Herodes sa barita nga dia, indi tana run mapabutang, pati ang tanan nga mga tao sa Jerusalem. ");
INSERT INTO clu_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Gani ginpatawag na ang tanan nga mga manogdomara nga mga pari kag mga manogtodlo ang Kasogoan kag nagpamangkot kananda kon diin mababata ang Cristo. ");
INSERT INTO clu_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Makon nanda, “Doto sa Banwa ang Betlehem nga sakup ang Judea, tungud nga maman dia ang nasolat ang ona paagi sa propita nga nagakoon, ");
INSERT INTO clu_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Kamo nga mga taga-Betlehem nga nagaoli sa probinsya ang Juda, Indong banwa indi ra gid magpaori sa mga banwa nga nagapangona sa Juda; Tungud nga dian kanindo magaalin ang manogdomara nga magaasikaso sa akun mga tinao nga mga Israelita.’” ");
INSERT INTO clu_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Pagkabati dato ni Herodes ginpatawag na dayon sa sikrito ang mga tao nga dato nga nagabot alin sa mororan kag ginpamangkot na sanda kon kano gid naggoa ang bitoon nga andang ginakoon nga andang nakita. ");
INSERT INTO clu_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Pagkatapos ginpaayan na sanda sa Betlehem, makon na, “Sigi, panaw kamo kag pangitaun nindo gid ang bata. Kag kon makita nindo tana gani, paulamun nindo ako ra, agud makaayan ako ra doto kag magsimba kanana.” ");
INSERT INTO clu_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Pagkaambal ang ari nagpanaw sanda. Kag mintras nagapanaw sanda nakita nanda ruman ang bitoon nga dato nga andang nakita. Gani nalipay sanda nga mayad. Nagpangona kananda ang bitoon asta sa anang logar ang bata, kag pagabot doto nagtadung. ");
INSERT INTO clu_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Pagsulud nanda sa kamalig nakita nanda ang bata kag anang nanay nga si Maria. Kag naglood sanda kag nagsimba sa bata. Ginbokasan nanda dayon andang mga dara, kag nagrigalo sanda sa bata ang bolawan, insinso, kag ang paamot nga mira. ");
INSERT INTO clu_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Pagoli nanda sa andang logar iba run nga dalan andang ginagian ay ginpaandaman sanda ang Dios paagi sa damgo nga indi sanda run magbalik kay Herodes. ");
INSERT INTO clu_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Pagkatapos nga nakaalin sanda, anang angil ang Ginoo nagpakita kay Jose sa damgo kag nagkoon, “Pagbangon, daraa ang bata kag anang nanay kag magpalagyaw kamo sa Egipto. Kag doto kamo lang anay magtinir mintras ara ako pa nagkoon kanindo nga magalin, tungud nga papangitaun run ni Herodes ang bata nga dan agud patayun.” ");
INSERT INTO clu_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Gani ang gabi mismo nga dato nagbangon si Jose kag gindara na ang bata kag anang nanay doto sa Egipto. ");
INSERT INTO clu_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Doto sanda nagtinir asta napatay si Herodes. Dia natabo agud matoman anang ginkoon ang Ginoo paagi sa propita nga nagakoon, “Gintawag ko akun bata alin sa Egipto.” ");
INSERT INTO clu_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Pagkaulam ni Herodes nga ginloko tana gali ang mga tao nga dato nga alin sa mororan, nasilag tana nga mayad. Nagmandar tana nga pamatayun ang tanan nga mga bata nga lalaki sa Betlehem kag sa anang palibot nga mga logar, alin sa darwa ka toig paubus. Ginpaimo na dato agud mapatay si Jesus. Tungud nga sono sa anang naulaman sa mga tao nga nagabot doto alin sa mororan, aros darwa run ka toig ang nakalubas alin andang pagkakita ang bitoon. ");
INSERT INTO clu_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Sa natabo nga dato natoman anang gintagna ni propita Jeremias nga nagakoon, ");
INSERT INTO clu_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“May nabatian nga pagpanangis kag pagwawaw sa banwa ang Rama. Ay nagapanangis si Raquel para sa anang mga bata. Nagapanangis tana kag indi run gid mapaugpay anang buut Tungud nga anang mga bata patay run.” ");
INSERT INTO clu_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Karon, pagkapatay ni Herodes, anang angil ang Ginoo nagpakita ruman kay Jose sa damgo doto sa Egipto, ");
INSERT INTO clu_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","makon na, “Pagbangon kag dara dayon ang bata kag anang nanay kag magbalik kamo sa Israel tungud nga napatay run ang nagingabot nga patayun ang bata.” ");
INSERT INTO clu_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Gani nagbangon si Jose kag gindara na ang bata kag anang nanay pabalik sa Israel. ");
INSERT INTO clu_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Piro pagkabati ni Jose nga si Arquelao maman run ang nagsali sa anang tatay bilang ari sa Judea, ginadlukan tana nga magoli doto. Kag may paandam kanana ang Dios sa damgo, gani nagdiritso sanda run lang sa probinsya ang Galilea. ");
INSERT INTO clu_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Kag doto sanda nagoli sa banwa ang Nazaret. Gani natoman anang ginkoon ang mga propita ang ona nga tatawagun tana nga Nazareno. ");
INSERT INTO clu_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Karon, nagabot ang tyimpo nga si Juan nga manogbunyag nagayan sa naligwin nga logar doto sa Judea kag doto tana nagompisa wali sa mga tao, makon na, ");
INSERT INTO clu_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Maginulsul kamo kag bayaan nindo ron indong mga sala, ay madali run lang magari ang Dios digi sa kalibotan.” ");
INSERT INTO clu_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Si Juan gid anang ginakoon ni propita Isaias ang magkoon tana nga, “May nagasinggit sa naligwin nga logar, makon na, ‘Ipriparar nindo anang aragian ang Ginoo, Tadlunga nindo ang dalan ay madali tana run lang magabot.’” ");
INSERT INTO clu_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Si Juan nga dia, anang lambong bolbol ang kamilyo nga ginabul kag anang akus panit. Anang pagkaun apan kag dugus. ");
INSERT INTO clu_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Doro gid nga mga tao alin sa Jerusalem kag sa mga banwa ang Judea kag sa mga banwa nga marapit sa Soba ang Jordan ang nagarayan doto kanana. ");
INSERT INTO clu_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ginako nanda andang mga sala kag ginbunyagan na sanda sa Soba ang Jordan. ");
INSERT INTO clu_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Nakita ni Juan nga doro nga mga Pariseo kag mga Saduseo ang nagaarayan doto nga maparabunyag. Makon na kananda, “Kamo nga lai ang mga magkal, basi nagayan kamo digi? Sino ang nagkoon kanindo nga makakapalagyaw kamo sa anang silot ang Dios nga madali run lang magabot? ");
INSERT INTO clu_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Kon matood nga kamo naginulsul run sa indong mga sala pamatodi nindo sa indong mga inimoan. ");
INSERT INTO clu_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Indi kamo magsarig nga indi kamo pagasilotan tungud nga kamo anang mga kaapo-apoan ni Abraham. Ay miski ang mga bato nga dia poidi nga imoon ang Dios nga anang mga bata ni Abraham kon gosto na. ");
INSERT INTO clu_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Tandaan nindo dia: ang wasay ginaanda run sa anang pono gid ang mga kaoy. Ang kada kaoy nga ara nagapamonga ang mayad nga bonga pokanun kag ipilak sa kalayo. ");
INSERT INTO clu_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Kamo ginabunyagan ko sa tobig bilang pagpakilala nga kamo nagainulsul run sa indong mga sala, piro ang masonod kanakun mas gamanan pa kanakun kag bisan maging anang sorogoon indi ako pa gani poidi. Tana magabunyag kanindo sa Ispirito Santo kag kon indi, sa kalayo. ");
INSERT INTO clu_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Tungud nga bubulagun na ang mga matarung kag ang mga malain nga mga tao, pario tana sa tao nga nagapaangin anang inani agud bulagun ang timgas sa opa. Ang timgas ibutang na sa bodiga, piro ang opa tana sonogon na sa kalayo nga indi mapatay.” ");
INSERT INTO clu_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Karon, nagalin si Jesus sa Galilea kag nagayan tana ra doto kay Juan sa Soba ang Jordan agud magpabunyag. ");
INSERT INTO clu_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Indi andan magbunyag si Juan ay makon na, “Basi mapabunyag kaw kanakun? Ako tana gani ang kinanglan nga magpabunyag kanimo.” ");
INSERT INTO clu_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Piro makon ni Jesus kanana, “Sigi lang, tungud nga maman dia ang dapat ta nga imoon agud matoman anang gosto ang Dios.” Gani nagpasogot si Juan kag ginbunyagan na si Jesus. ");
INSERT INTO clu_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Pagkatapos nga nabunyagan si Jesus, nagtakas tana alin sa tobig. Kag nagabri dayon ang langit kag nakita ni Jesus anang Ispirito ang Dios nga nagtugpa kanana nga midyo sa salampati. ");
INSERT INTO clu_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Kag may nabatian tana dayon nga limug alin sa langit nga nagakoon, “Maman dia akun pinalangga nga Bata. Nalilipay ako nga mayad kanana.” ");
INSERT INTO clu_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Pagkatapos dato, gindara dayon ang Ispirito Santo si Jesus sa naligwin nga logar agud solayun ni Satanas. ");
INSERT INTO clu_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Sa sulud ang 40 ka adlaw kag 40 ka gabi nagpoasa si Jesus, kag gingutum tana. ");
INSERT INTO clu_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Nagparapit kanana si Satanas kag nagkoon, makon na, “Abi kon ikaw manda anang Bata ang Dios, imoa abi nga tinapay ang mga bato nga dan.” ");
INSERT INTO clu_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Piro makon ni Jesus kanana, “Ang Kasolatan nagakoon nga ang tao bukun lang sa pagkaun maboboi, kondi kinanglan na ra ang tanan nga anang ambal ang Dios.” ");
INSERT INTO clu_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Pagkatapos dato, gindara tana dayon ni Satanas sa Balaan nga Siodad, doto sa borobongan gid ang timplo. ");
INSERT INTO clu_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Kag makon na dayon kay Jesus, “Kon ikaw manda anang Bata ang Dios, abi paglokso paidalum. Ay kabay may nakasolat sa Kasolatan nga, ‘Sosogoon ang Dios anang mga angil agud bantayan kaw. Samboton kaw nanda agud bisan imong siki indi matigbak sa bato.’” ");
INSERT INTO clu_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Piro makon ni Jesus kanana, “May nakasolat ra sa Kasolatan nga nagakoon, ‘Indi mo pagtirawan ang Ginoo nga imong Dios.’” ");
INSERT INTO clu_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Pagkatapos dato gindara na pa gid si Jesus sa mataas gid nga bokid, kag ginpakita na kanana ang tanan nga mga ginarian sa kalibotan kag kon paiwan kasadya. ");
INSERT INTO clu_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Makon dayon ni Satanas kanana, “Ang tanan nga dan itaw ko kanimo kon maglood kaw kag magsimba kanakun.” ");
INSERT INTO clu_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Makon dayon ni Jesus kanana, “Satanas, pagalin digi kanakun! Ay may nakasolat sa Kasolatan nga nagakoon, ‘Simbaun mo ang Ginoo nga imong Dios kag tana lang gid imong sirbian.’” ");
INSERT INTO clu_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Nagalin dayon si Satanas; kag anang mga angil ang Dios nagabot kag nagasikaso kay Jesus. ");
INSERT INTO clu_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Pagkabati ni Jesus nga napriso si Juan nga manogbunyag, nagbalik tana sa probinsya ang Galilea. ");
INSERT INTO clu_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Piro ara tana run nagtinir sa Nazaret kondi nagdiritso tana sa banwa ang Capernaum. Dia nga banwa sa obayun ang Dagat ang Galilea kag sakup anang tiritorio ang Zabulon kag Naptali. ");
INSERT INTO clu_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Maman dia ang natabo agud matoman anang gintagna ni propita Isaias, ay makon na, ");
INSERT INTO clu_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Ang mga taga-Zabulon kag taga-Naptali nagaoli marapit sa baybay kag sa loyo ang Soba ang Jordan. Dia nga mga tiritorio sakup ang Galilea nga ginaolian ang mga bukun Judio. ");
INSERT INTO clu_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Piro bisan ang mga tao sa mga logar nga dia naduduluman, makakakita sanda ang solo nga masanag gid. Ang mga naduduluman nga ginaadlukan nga mapatay masanagan run.” ");
INSERT INTO clu_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Doto sa logar nga dato nagompisa run wali si Jesus; makon na sa mga tao, “Maginulsul kamo kag bayaan nindo ron indong mga sala, ay maman run dia ang oras nga ang Dios magaari run digi sa kalibotan.” ");
INSERT INTO clu_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","May adlaw nga si Jesus nagapanaw doto sa baybay ang Dagat ang Galilea nakita na ang magkabogto nga mangingisda nga si Simon nga ginatawag ra nga Pedro kag anang libayun nga si Andres. Nagaladlad sanda andang lambat ay sanda mga manogpangisda. ");
INSERT INTO clu_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Makon ni Jesus kananda, “Dali, pagsonod kamo kanakun ay bukun dun isda indong pangitaun kondi todloan ko kamo nga magpangita ang mga tao nga maging akun mga somolonod.” ");
INSERT INTO clu_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Kag ginbayaan nanda nga lagi andang mga lambat kag nagsonod kanana. ");
INSERT INTO clu_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Pagkatapos, nagpadayon tana sa anang pagpanaw kag sa onaan nakita na ra ang magkabogto nga si Santiago kag si Juan nga mga bata ni Zebedeo. Sanda nga darwa pati andang tatay nga si Zebedeo doto sa sakayan nga nagapona andang mga lambat. Gintawag ni Jesus ang magkabogto ");
INSERT INTO clu_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","kag ginbayaan nanda ra nga lagi andang sakayan kag andang tatay kag nagtabid kay Jesus. ");
INSERT INTO clu_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Kag naglibot si Jesus sa bilog nga Galilea nga nagatodlo sa anang mga simbaan ang mga Judio. Ginwali na kananda ang Mayad nga Barita parti sa anang pagari ang Dios. Kag ginpangayad na ang mga tao sa tanan nga klasi nga masakit kag balatian. ");
INSERT INTO clu_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Naging bantog tana sa bilog nga Syria, gani ginpandara ang mga tao kanana ang tanan nga mga masakitun; bisan ang mga nagaantos nga mayad tungud sa andang mga masakit, ang mga ginasuludan ang mga malain nga ispirito, ang mga koyapun kag ang mga paralitiko. Kag sanda tanan ginpangayad ni Jesus. ");
INSERT INTO clu_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Doro gid ang mga tao nga nagtarabid kay Jesus, mga taga-Galilea, taga-Decapolis, taga-Jerusalem, taga-Judea, kag ang iba alin sa tabok ang Soba ang Jordan. ");
INSERT INTO clu_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Pagkakita ni Jesus sa doro nga mga tao nagtokad tana sa bokid kag nagpongko doto. Anang mga somolonod nagparapit kanana ");
INSERT INTO clu_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","kag gintodloan na sanda dayon, makon na, ");
INSERT INTO clu_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Masoirti ang mga tao nga nakaulam nga kolang sanda sa Dios, ay kabilang sanda sa anang ginarian ang Dios. ");
INSERT INTO clu_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Masoirti ang mga nagakasubu, ay lilipayun sanda ang Dios. ");
INSERT INTO clu_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Masoirti ang mga malolo, ay magiging anda ang bilog nga kalibotan. ");
INSERT INTO clu_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Masoirti ang mga tao nga gosto gid magimo anang kabubutun ang Dios, ay boligan sanda ang Dios agud maimo nanda andang ginaandum nga dato. ");
INSERT INTO clu_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Masoirti ang mga maloloyon, ay kaloyan sanda ra ang Dios. ");
INSERT INTO clu_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Masoirti ang mga tao nga limpyo andang tagiposoon, ay makikita nanda ang Dios. ");
INSERT INTO clu_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Masoirti ang mga tao nga nagaimo paagi nga magkarasogot ang mga ara nagairintindian, ay ibibilang sanda nga anang mga bata ang Dios. ");
INSERT INTO clu_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Masoirti ang mga tao nga ginaingabot tungud sa andang pagsonod sa anang kabubutun ang Dios, ay kabilang sanda sa anang ginarian ang Dios. ");
INSERT INTO clu_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Masoirti kamo kon tungud sa indong pagsonod kanakun kamo ginapasipalaan, ginaingabot, kag ginaambalan ang tanan nga klasi nga mga malain nga mga ambal nga poros botig. ");
INSERT INTO clu_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Maman da dia andang ginimo ang ona sa mga propita. Gani magkalipay kamo nga mayad tungud nga mabaul nga balus indong mababaton doto sa langit.” ");
INSERT INTO clu_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Kamo nga akun mga somolonod maman ang pinakaasin digi sa kalibotan. Piro kon magrimo anang lasa ang asin, ara run may maimo para mapabalik anang dati nga lasa. Gani indi run mapolosan kondi ginapilak run lang kag ginalapak-lapakan ang mga tao. ");
INSERT INTO clu_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Indong kaalimbawa pario ra sa solo nga nagasanag sa mga tao digi sa kalibotan. Ang banwa nga ginpatindug sa ibabaw ang bokid indi matago. ");
INSERT INTO clu_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ara ra may nagasindi ang solo kag takluban ang surukuban, kondi ginatongtong gid sa torongtongan agud masanagan ang tanan sa sulud ang balay. ");
INSERT INTO clu_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Gani toladan ra indong imoon. Pasanagun nindo indong solo sa mga tao, agud makita nanda indong mga inimoan nga mayad kag dayawon nanda indong Tatay sa langit.” ");
INSERT INTO clu_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Indi kamo gid maguna-una nga ako nagayan digi agud doraun ang Kasogoan kag anang mga panodlo ang mga propita. Nagayan ako digi agud matoman dato. ");
INSERT INTO clu_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Sa matood tana, mintras dian ang langit kag ang logta ara gid parti sa Kasogoan nga madodora. Miski ang mga parti nga midyo bukun importanti indi gid madoraan andang kinaologan mintras ara pa natotoman ang tanan nga dapat matoman. ");
INSERT INTO clu_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Gani ang bisan sino nga magsoway bisan ang pinakamaistan nga parti ang Kasogoan, kag magtodlo ra sa iba nga magsoway, tana ang pinakakubus sa anang ginarian ang Dios. Piro ang bisan sino nga magtoman ang Kasogoan, kag magtodlo ra sa iba nga magtoman, kikilalaun tana sa anang ginarian ang Dios. ");
INSERT INTO clu_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Gani ginasogidan ko kamo nga kinanglan indong pagsonod sa anang kabubutun ang Dios maglabaw pa sa anang pagsonod ang mga manogtodlo ang Kasogoan kag ang mga Pariseo, ay kon indi, indi kamo mapabilang sa mga tao nga ginaarian ang Dios.” ");
INSERT INTO clu_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Makon pa ni Jesus, “Nabatian nindo nga atun mga kaolang-olangan ang ona ginkonan nga indi sanda dapat magpatay andang isigkatao, ay ang bisan sino nga magpatay sisintinsyaan ang silot sa ukuman. ");
INSERT INTO clu_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Piro dadi sogidan ko kamo nga ang bisan sino nga nasisilag sa anang kapario sisintinsyaan ang silot sa ukuman. Kag ang bisan sino nga magboyayaw anang kapario nga nagakoon nga tana kabos-kabos, dadaraun tana sa mataas gid nga ukuman agud sintinsyaan. Kag ang bisan sino nga magkoon sa anang kapario nga tana omang-omang gid, sintinsyaan tana sa nagadaba-daba nga kalayo sa impyirno. ");
INSERT INTO clu_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Gani miski doto ka run sa altar nga nagadara imong alad sa Dios kag may madumduman kaw nga may malain nga buut imong kapario kanimo, ");
INSERT INTO clu_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","isala mo anay imong inogalad marapit sa altar kag ayanan mo nga lagi ang tao nga dato kag magpakigosay kanana. Pagkatapos bago kaw garing magbalik sa altar kag magalad imong inogalad sa Dios. ");
INSERT INTO clu_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Kon may magakosar kanimo, magpakigariglo kaw nga lagi kanana mintras ara kamo pa kaabot sa korti. Ay kon kamo doto ron sa wis basi kon iintriga kaw ang wis sa polis kag prisoon kaw dayon. ");
INSERT INTO clu_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Kag sigorado gid nga indi kaw makagoa mintras ara mo pa nabayadan ang tanan imong molta.” ");
INSERT INTO clu_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Nabatian nindo nga ang ona ginkonan ang mga tao nga indi sanda magpanginbabai. ");
INSERT INTO clu_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Piro dadi sogidan ko kamo nga ang lalaki nga nagasulung sa babai nga may malain nga andum, pario ron da sa nagapanginbabai tana. ");
INSERT INTO clu_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Gani kon imong too nga mata maman ang kabangdanan nga ikaw nagakasala, lukada kag ipilak. Ay mas mayad pa nga madora ang sangka parti imong lawas kaysa komplito imong lawas piro ipilak kaw sa impyirno. ");
INSERT INTO clu_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Kag kon imong too nga alima maman ang kabangdanan nga ikaw nagakasala otoda kag ipilak. Ay mas mayad pa nga madora ang sangka parti imong lawas kaysa komplito imong lawas piro ipilak kaw sa impyirno.” ");
INSERT INTO clu_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Gintodlo ra ang ona nga kon ang lalaki gosto nga magpakigbulag sa anang asawa, dapat tawan na kasolatan bilang pamatood nga sanda nagbulag run. ");
INSERT INTO clu_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Piro dadi sogidan ko kamo nga kon bulagan ang lalaki anang asawa nga ara ra nagpanginlalaki, tana mismo ang nagatolod sa anang asawa nga magkasala ay mapaasawa tana ruman kag magaolid sa bukun anang matood nga asawa. Kag ang bisan sino nga magpangasawa sa babai nga dato nga ginbulagan anang asawa nagakasala ra sa pagpakigolid kanana.” ");
INSERT INTO clu_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Makon pa ni Jesus, “Nabatian nindo ra nga atun mga kaolang-olangan ang ona ginkonan nga kon ang tao may ginpangako kag ginsompaan na pa sa anang aran ang Ginoo, kinanglan tomanun na gid. ");
INSERT INTO clu_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Piro dadi sogidan ko kamo nga kon kamo magpangako, indi kamo gid magsompa. Indi kamo ron magkoon nga ‘Dan pa ang langit’ ay dian anang trono ang Dios, ");
INSERT INTO clu_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","okon ‘Dan pa ang logta’ ay dan anang ginatongtongan anang siki. Indi kamo ra maggamit ang Jerusalem sa indong pagsompa tungud nga maman dan anang siodad ang bantog nga ari. ");
INSERT INTO clu_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Indi kamo ra magkoon nga, ‘Bisan mapatay ako pa,’ ay bisan sangka book lang gani indi mo mapapoti okon mapaitum. ");
INSERT INTO clu_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ang dapat tana, magkoon kaw nga ‘Uu’ kon uu kag ‘Indi’ kon indi; ay kon dogangan nindo pa mga sompa-sompa, alin run dan kay Satanas.” ");
INSERT INTO clu_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Nabatian nindo ra ang panodlo ang ona nga, ‘Ang nakalotak anang mata anang kapario, lotakun ra anang mata; kag ang nakabingaw anang ipun anang kapario, bingawon ra anang ipun.’ ");
INSERT INTO clu_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Piro dadi sogidan ko kamo nga indi nindo pagbalusi malain ang nagaimo malain kanindo. Kon tampalingun kaw sa too, agoantaun mo lang bisan tampalingun kaw pa sa wala. ");
INSERT INTO clu_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Kag kon may magdimanda kanimo agud bulun imong pinakakamisita, itaw ron lang kanana pati imong lambong kon bulun na ra. ");
INSERT INTO clu_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Kon may soldado nga magrugus kanimo nga papasanun kaw anang karga mga sangka kilomitro, imoa nga darwa. ");
INSERT INTO clu_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Tawi ang nagapangayo kanimo, kag paurama ang magauram.” ");
INSERT INTO clu_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Nabatian nindo ra ang panodlo ang ona nga nagakoon, ‘Igogmaa nindo indong amigo, kag dumuti nindo indong kaaway.’ ");
INSERT INTO clu_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Piro dadi ginakonan ko kamo, igogmaa nindo indong kaaway. Bisan pa ang mga nagaingabot kanindo ipangamoyo nindo. ");
INSERT INTO clu_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Kag kon imoon nindo dia, maging matood kamo nga mga bata indong Tatay nga sa langit (tungud nga pario kamo kanana nga mayad indong pagtratar sa tanan). Ay bukun lang sa mga mayad nga mga tao anang ginapasirakan anang adlaw kondi pati sa mga malain. Kag bukun lang sa mga matarung anang ginatawan ang oran kondi pati sa mga bukun matarung. ");
INSERT INTO clu_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Indi kamo magisip nga may balus kamo nga paaboton alin sa Dios kon mayad kamo ra lang sa mga tao nga mayad kanindo. Ay miski ang mga manogsokot ang bois nga ginabilang nindo nga malain nga mga tao toladan ra andang ginaimo. ");
INSERT INTO clu_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Kag kon indong mga kabogto lang indong ginabogno, ano gid indong ginaimo nga mas mayad kaysa iba? Bisan ang mga tao nga ara nagakilala sa Dios toladan ra andang ginaimo. ");
INSERT INTO clu_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Gani maging mayad kamo, pario sa indong Tatay nga sa langit nga ara gid kasawayan sa anang pagogali.” ");
INSERT INTO clu_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Magandam kamo ay basi kon indong ginaimo sa pagpakadiosnon pakita-kita lang sa mga tao. Ay kon pakita-kita lang gani, ara kamo gid babatonon nga balus alin sa indong Tatay nga sa langit. ");
INSERT INTO clu_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Gani kon kamo nagalimos indi nindo ipanogid-sogid pario anang ginaimo ang iba nga nagapakita-kita lang sa mga simbaan kag sa mga dalan. Toladan andang ginaimo agud dayawon sanda ang mga tao. Piro ang matood tana, bukun sanda sinsiro sa andang ginaimo. Kag tungud nga gindayaw sanda run ang mga tao, nabaton nanda run andang balus. Gani ara sanda run paaboton alin sa Dios. ");
INSERT INTO clu_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Kamo tana, kon kamo nagabolig sa mga malisud, indi nindo ron pagipaulam bisan pa sa indong pinakamasuud nga amigo. ");
INSERT INTO clu_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Kag kon sa sikrito indong pagtaw indong bolig, nakikita dan indong Tatay nga sa langit, kag tana maman ang mabalus kanindo.” ");
INSERT INTO clu_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Kag kon kamo magpangamoyo, indi kamo magwad sa anang ginaimo ang mga tao nga poros lang pakita-kita andang ginaimo. Gosto nanda magpangamoyo nga nagatindug sa mga simbaan kag sa mga kanto ang mga karsada agud makita ang mga tao nga sanda diosnon. Sa matood tana, nabaton nanda run anang pagdayaw ang mga tao kananda. Gani ara sanda run paaboton alin sa Dios. ");
INSERT INTO clu_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Piro kamo tana, kon kamo magpangamoyo, magsulud kamo sa indong koarto kag magpanirado. Kag doto kamo magpangamoyo sa indong Tatay nga sa langit nga indi makita. Kag indong Tatay nga nakakakita indong ginaimo sa sikrito maman ang magabalus kanindo. ");
INSERT INTO clu_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Kon kamo nagapangamoyo, indi kamo maggamit doro nga mga arambalun nga ara polos. Dan toladan anang ginaimo ang mga tao nga ara nagakilala sa Dios. Ay andang pagsarig sasabatun sanda ang Dios kon malawig andang mga pagpangamoyo. ");
INSERT INTO clu_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Indi nindo pagwadun andang ginaimo. Ay atung Tatay kaulam run nga lagi kon ano atun mga kinanglan bisan ara kita pa kapangamoyo. ");
INSERT INTO clu_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Gani magpangamoyo kamo toladia; ‘Amun Tatay nga sa langit, Kabay pa nga taodon kaw ang mga tao, ");
INSERT INTO clu_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Kabay pa nga magari kaw ron digi kanamun, Kag kon paiwan nga imong kabubutun ginatoman doto sa langit, Kabay pa nga tomanun ra digi sa kalibotan. ");
INSERT INTO clu_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Tawi kami amun kinanglan nga pagkaun sa adlaw nga dia, ");
INSERT INTO clu_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Patawada kami sa amun mga sala, Ay ginpatawad namun ra ang nagkasala kanamun. ");
INSERT INTO clu_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Indi mo kami pagipadaug sa mga pagsolay, Kondi lowasa kami kay Satanas. Tungud nga ikaw ang Ari, ang Makagagaum, kag ang Darayawon asta sa ara kataposan. Amin.’ ");
INSERT INTO clu_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Kon ginapatawad nindo ang mga tao nga nagkasala kanindo, patawadun kamo ra indong Tatay nga sa langit. ");
INSERT INTO clu_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Piro kon indi kamo magpatawad kananda, indong Tatay indi ra magpatawad kanindo.” ");
INSERT INTO clu_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Kag kon kamo magpoasa, indi kamo magwad sa mga tao nga nagapakita-kita lang nga sanda nagapoasa agud dayawon sanda. Nagalagaw sanda lang nga ara nagapangramos kag ara nagapanodlay agud maulaman ang iba nga sanda nagapoasa. Sa matood tana, nabaton nanda run anang pagdayaw ang mga tao kananda, gani ara sanda run paaboton alin sa Dios. ");
INSERT INTO clu_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Piro kon kamo tana ang magpoasa, magpangramos kamo kag sodlayun nindo indong book, ");
INSERT INTO clu_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","agud ara may makaulam nga kamo nagapoasa loas sa indong Tatay nga indi makita. Kag tana nga nakakakita indong mga ginaimo sa sikrito maman ang magabalus kanindo.” ");
INSERT INTO clu_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Indi kamo magtipon ang manggad para sa indong kaogalingun digi sa kalibotan, tungud nga digi kutkutun ang mga sapat-sapat, kag kon indi, tuktukun ra lang. Okon maimo ra nga suludun ang takawan indong balay kag takawon. ");
INSERT INTO clu_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Indong imoon tana, magtipon kamo indong manggad doto sa langit, ay doto ara may nagapangutkut, ara tuktuk, kag indi makasulud ang takawan. ");
INSERT INTO clu_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ay kon diin indong manggad doto ra pirmi indong tagiposoon.” ");
INSERT INTO clu_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Atun mata anang pinakasolo atun lawas. Gani kon masanag imong panulung nasasanagan run da imong bilog nga lawas. ");
INSERT INTO clu_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Piro kon imong panulung madulum naduduluman ra imong bilog nga lawas. Gani kon ang ginakoon nga solo nga dian kanimo ara nagataw kasanag, tay masyado kadulum imong kaimtangan.” ");
INSERT INTO clu_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Ara tao nga makasirbi ang dungan sa darwa ka agalun, ay ang matatabo marimoan tana sa isara kag magapalangga sa isara; magakampi tana sa isara kag magapakalain sa isara. Kamo indi ra makasirbi ang dungan sa Dios kag sa manggad. ");
INSERT INTO clu_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Maman dan nga nagakoon ako kanindo nga indi kamo magsari palibug kon sa diin kamo mabuul indong kaunun agud maboi kamo. Indi kamo ra magsari palibug kon sa diin kamo mabuul indong ilambong. Ay kon kamo ginatawan na kaboi kag lawas indi maimo nga indi na kamo pagtawan pagkaun kag indong inoglambong. ");
INSERT INTO clu_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Sulunga nindo ang mga pispis nga nagarulupad. Ara sanda nagatanum, ara sanda nagaani, kag ara sanda nagatipon bisan ano sa bodiga. Piro sono sa bugna indong Tatay sa langit ginatawan na sanda andang pagkaun. Kag kabay mas palangga kamo kaysa mga pispis. ");
INSERT INTO clu_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Kag bisan magpalibug kamo para mapalabug indong kaboi, indi nindo ra gid mapapalabug bisan maistan lang. ");
INSERT INTO clu_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Kag basi nagapalibug kamo gid kon sa diin kamo mabuul indong ilambong? Sulunga nindo lang bala ang mga bolak nga nagatobo bisan diin. Ara sanda nagapangabudlay; kag ara sanda ra nagapamudbud. ");
INSERT INTO clu_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Piro sa matood tana, bisan ang bantog kag manggaranun nga ari nga si Solomon, anang mga lambong indi gid makapario sa anang kasadya ang bisan isara sa mga bolak. ");
INSERT INTO clu_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Gani kon ginapasadya ang Dios ang mga ilamonon nga boi dadi, piro maboay-boay malalayung ra lang kag totodan, ta kondi mas labi run gid kamo nga anang palambongan. Ang kaistan indong pagsarig sa Dios. ");
INSERT INTO clu_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Indi kamo magsari-palibug kon sa diin kamo mabuul indong kaunun kag inumun, kag indong ilambong. ");
INSERT INTO clu_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","(Maman dia anang ginapalibugan pirmi ang mga tao nga ara nagakilala sa Dios.) Kaulam indong Tatay nga sa langit nga kinanglan nindo ang mga butang nga dia. ");
INSERT INTO clu_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Indong imoon tana, onaun nindo anay anang ginarian kag kon ano ang mga mayad nga imoon sono sa anang kabubutun, kag indong mga kinanglanun nga dan, tanan itaw na kanindo. ");
INSERT INTO clu_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Gani indi kamo magsari palibug parti sa indong paraaboton, kondi isipun nindo garing kon dian run. Indi kinanglan nga dogangan nindo pa ang paralibugan nga sa dadi.” ");
INSERT INTO clu_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Indi nindo pakalainun ang iba agud indi kamo ra pagpakalainun ang Dios. ");
INSERT INTO clu_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ay kon ano indong gamitun sa pagpakalain sa iba maman ra dato anang gamitun ang Dios sa pagpakalain kanindo. Kon sa surukuban, ang surukuban nga indong ginagamit sa iba maman ra ang surukuban nga gamitun ang Dios kanindo. ");
INSERT INTO clu_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Basi ginapamolalungan mo gid ang maistan nga poling sa anang mata imong kapario, piro ara mo ginasapaka imong poling nga midyo sa tablon kabaul? ");
INSERT INTO clu_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Paiwan imong pagkoon kanana nga ‘Abi bulun ko imong poling,’ kon sa imong mata mismo may poling nga midyo tablon anang kabaul? ");
INSERT INTO clu_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Gani sino ka gid nga nagapakalain sa imong kapario nga ikaw gani sobra pa kanana? Dapat tana bulun mo anay ang poling nga daw tablon dian sa imong mata, agud masadya imong pagsulung, kag bago mo garing bulun anang poling nga maistan imong kapario. ");
INSERT INTO clu_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Indi kamo magtodlo anang mga panodlo ang Dios sa mga tao nga ara naliag magpamati. Kon imoon nindo dan, midyo sa ginapilak nindo sa mga ayam ang mga butang nga parti sa Dios. Kag ang matatabo, balikidun kamo pa kag kagatun dayon. Midyo ra dan sa ginpilak nindo indong mga pirlas sa mga baboy, pagkatapos lapak-lapakun nanda ra lang.” ");
INSERT INTO clu_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Magpangayo kamo sa Dios kag tawan kamo. Magpadayon kamo gid sa pagparapit kanana parti sa indong mga kinanglan kag tigayonon na kamo. Magpangamoyo kamo sa Dios kag sabatun na kamo. ");
INSERT INTO clu_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Tungud nga ang tanan nga nagapangayo sa Dios nakakabaton. Ang mga nagaparapit tigayonon. Kag ang mga nagapangamoyo sabatun. ");
INSERT INTO clu_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Kamo nga mga ginikanan, kon nagapangayo ang pagkaun indong bata ginatawan nindo ang bato? ");
INSERT INTO clu_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Kon nagapangayo isda ginatawan nindo ang magkal? Syimpri ara! ");
INSERT INTO clu_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ta kon kamo nga mga makasasala antigo magtaw ang mayad nga mga butang sa indong mga bata, sigorado gid nga indong Tatay nga sa langit magataw ra ang mayad nga mga butang sa mga nagapangayo kanana. ");
INSERT INTO clu_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Kon ano indong gosto nga imoon kanindo indong kapario, maman da indong imoon kananda. Maman dia ang osto nga pagtoman sa Kasogoan nga ginbilin ni Moises kag sa mga panodlo ang mga propita.” ");
INSERT INTO clu_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Magsulud kamo sa masipot nga poirtaan, tungud nga ang mawayang nga poirtaan kag malapad nga dalan maman ang nagapaayan sa impyirno, kag doro ang nagaagi sa dalan nga dan. ");
INSERT INTO clu_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Piro ang masipot tana nga poirtaan kag malisud nga dalan nagapaayan sa kaboi nga ara kataposan, kag malaka ang nagaagi dian.” ");
INSERT INTO clu_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Magandam kamo sa mga tao nga sala andang mga panodlo. Dia nga mga tao midyo mga tomoloo kon sulungun mo piro ang matood tana pario sanda sa mapirintas nga mga sapat. ");
INSERT INTO clu_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Makikilala nindo sanda paagi sa andang mga inimoan. Pario ra dan sa mga ilamonon nga may siit, ara napopolosi andang bonga. ");
INSERT INTO clu_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","18","Ang kaoy nga ara dipirinsya, masadya anang bonga, kag indi makapamonga ang marimo. Piro ang kaoy tana nga may dipirinsya, marimo anang bonga, kag indi makapamonga ang masadya. ");
INSERT INTO clu_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ang tanan nga kaoy nga ara nagapamonga ang masadya nga bonga ginatapas kag ginasonog dayon. ");
INSERT INTO clu_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Gani ang mga tao nga sala andang panodlo makikilala nindo sa andang mga inimoan.” ");
INSERT INTO clu_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Doro nga mga tao ang nagatawag kanakun nga, ‘Ginoo,’ piro ara nagakaologan nga sanda makakabilang run sa mga tao nga ginaarian ang Dios. Ang mga tao lang gid tana nga nagatoman anang gosto akun Tatay nga sa langit maman ang makasulud sa anang ginarian. ");
INSERT INTO clu_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Kon magabot ang adlaw ang pagukum doro ang magakoon kanakun nga, ‘Ginoo, kabay sa imong aran nagsogid kami sa mga tao imong ambal, nagpagoa kami ang mga malain nga ispirito, kag doro nga mga milagro amun ginpangimo.’ ");
INSERT INTO clu_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Sasabatun ko dayon sanda nga, ‘Ara ako gid kakilala kanindo. Parayu kamo kanakun, kamo nga manogimo ang malain!’” ");
INSERT INTO clu_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Gani ang bisan sino nga nagapamati kag nagasonod sa akun mga panodlo nga dia, anang kaalimbawa pario sa tao nga maaram nga nagapatindug anang balay sa pondasyon nga bato. ");
INSERT INTO clu_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Kag bisan magoran todo kag magbaa, kag magbira-bira uyup ang angin nga mabaskug, indi maguba tungud nga ginpatindug sa marigun nga pondasyon nga bato. ");
INSERT INTO clu_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Piro ang tao tana nga nakabati akun mga ginatodlo, garing ara nagasonod, maging pario sa tao nga kabos-kabos nga nagapatindug anang balay sa baras. ");
INSERT INTO clu_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Kag kon magoran todo kag mabaa, kag magbira-bira uyup ang angin nga mabaskug, maguguba anang balay, kag magarinagamak asta mawasak.” ");
INSERT INTO clu_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Pagkatapos ambal ni Jesus parti sa mga butang nga dato, natingala nga mayad ang mga tao ");
INSERT INTO clu_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","tungud nga nagtodlo tana nga may awtoridad, kag bukun pario sa andang mga manogtodlo ang Kasogoan. ");
INSERT INTO clu_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Pagkatapos anang pagtodlo ni Jesus doto sa bokid, naglusub tana kag doro nga mga tao ang nagsonod kanana. ");
INSERT INTO clu_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Karon, may sangka aroon nga nagparapit kanana kag naglood, kag nagkoon, “Ginoo, nagapati ako nga mapaayad mo ako sa akun masakit nga marisna kon gosto mo.” ");
INSERT INTO clu_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Gintandug tana dayon ni Jesus nga nagakoon, “Gosto ko. Sigi, maayad kaw ron.” Kag lagi-lagi nagayad tana sa anang aro. ");
INSERT INTO clu_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Kag ginbilinan tana dayon ni Jesus, makon na, “Indi kaw gid magpamarita bisan kino, kondi magdiritso kaw sa pari kag magpasulung kanana. Pagkatapos magalad kaw dayon ang alad nga ginsogo ni Moises agud mapamatodan ang mga tao nga mayad ka run.” ");
INSERT INTO clu_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Karon, ang nagapasulud run si Jesus sa banwa ang Capernaum, may nagparapit kanana nga sangka tao. Dia nga tao kapitan ang bali 100 ka soldado nga Romano. Makon na nga nagapakitloy, ");
INSERT INTO clu_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Ginoo, akun sorogoon doto sa balay nagamasakit. Indi tana run makaolag kag sugung anang pamatyag.” ");
INSERT INTO clu_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Makon ni Jesus kanana, “Sigi, maayan ako sa imong balay kag ayadun ko tana dayon.” ");
INSERT INTO clu_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Piro makon anang sabat ang kapitan, “Ginoo, bukun ako bagay nga magsulud kaw pa sa akun balay. Magambal ka lang kag magaayad run akun sorogoon. ");
INSERT INTO clu_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Naulaman ko dia tungud nga ako sa idalum ra ang opisyalis, kag may mga sinakupan ako ra nga mga soldado. Gani kon magkoon ako sa isara nga magpanaw, nagapanaw tana. Kag kon magkoon ako sa isara nga magparapit, nagaparapit tana. Kag kon ano akun ginasogo sa akun oripun, ginaimo na ra. Gani nagapati ako nga kon ano imong iambal matotoman.” ");
INSERT INTO clu_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Pagkabati dato ni Jesus natingala tana nga mayad. Kag makon na dayon sa mga tao nga nagatabid kanana, “Ara ako pa gid kakita tao sa Israel nga may pagtoo nga pario dia. ");
INSERT INTO clu_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Gani tandaan nindo dia! Doro nga mga tao nga bukun Judio ang magaalin sa mororan kag kasalupan kag maging kaiban sanda nanday Abraham, Isaac, kag Jacob sa ponsyon doto sa anang ginarian ang Dios sa langit. ");
INSERT INTO clu_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Piro doro nga mga kaapo-apoan ni Israel nga ginpripararan ang Dios anang ginarian ang ipipilak sa goa, doto sa madulum nga marayu sa Dios. Kag magapanangis sanda gid tana kag magabagrut andang ipun.” ");
INSERT INTO clu_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Makon dayon ni Jesus sa kapitan, “Pagoli run. Nagtoo kaw, gani matatabo imong ginapangayo.” Kag dato nga lagi nagayad anang sorogoon ang kapitan. ");
INSERT INTO clu_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Nagayan si Jesus sa anang balay ni Pedro. Pagabot na doto nakita na nga anang panogangan ni Pedro nga babai nagaingga tungud nga may ragnat. ");
INSERT INTO clu_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Gintandug ni Jesus anang alima ang babai, kag lagi-lagi nagayad. Kag nagbangon tana kag ginpripararan na pagkaun sanday Jesus. ");
INSERT INTO clu_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Pagkasirum, doro nga mga tao nga may malain nga ispirito ang ginpandara kay Jesus. Sangka pagambal na lang nagralayas ang mga malain nga ispirito, kag ang mga nagamarasakit ginpangayad na ra tanan. ");
INSERT INTO clu_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ginimo na dato agud matoman anang gintagna ni propita Isaias nga nagakoon, “Tana gid ang nagayad atun mga masakit, Kag ginbuul na atun mga balatian.” ");
INSERT INTO clu_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Pagkakita ni Jesus nga dorong tao ang nagtiripon doto kanana, ginsogo na anang mga somolonod nga magpriparar ay matabok sanda sa loyong baybay. ");
INSERT INTO clu_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Karon may sangka manogtodlo ang Kasogoan nga nagparapit kanana kag nagkoon, makon na, “Maistro, masonod ako kanimo abir kon diin kaw magayan.” ");
INSERT INTO clu_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Piro makon ni Jesus kanana, “Ang mga singgarong may boo nga ginaolian, kag ang mga pispis may pogad, piro Ako nga Naging Tao, ara ako balay nga akun gid nga sarang ko mapawayan. Ta, matabid kaw pa kanakun?” ");
INSERT INTO clu_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","May sangka somolonod ra si Jesus nga nagkoon, makon na, “Ginoo, abi maoli ako anay, kag kon mapatay run akun tatay kag maipalubung ko bago ako masonod kanimo.” ");
INSERT INTO clu_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Makon ni Jesus kanana, “Ang mga tao nga patay sa panulung ang Dios maman imong palubungun ang mga patay. Ikaw tana magsonod kanakun.” ");
INSERT INTO clu_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Nagsakay dayon si Jesus sa sakayan kag anang mga somolonod nagtabid ra kanana. ");
INSERT INTO clu_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Mintras nagapalayag sanda, golpi lang nga nagdurus, kag aros indi run kitaun andang sakayan sa daloyon. Piro si Jesus tana nagakatorog. ");
INSERT INTO clu_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Gani ginparapitan tana anang mga somolonod kag ginpokaw. Makon nanda, “Ginoo, tabang! Malolonod kita run!” ");
INSERT INTO clu_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Makon ni Jesus kananda, “Ay dan basi ginaadlukan kamo? Kolang indong pagtoo.” Nagbangon tana dayon kag ginsaway na ang angin kag ang mga daloyon nga magpoas. Kag golpi lang nga naglinaw. ");
INSERT INTO clu_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Natingala nga mayad anang mga somolonod. Makon nanda, “Ano nga tao dia nga bisan ang angin kag ang dagat nagatoman kanana?” ");
INSERT INTO clu_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Pagabot nanda sa loyong baybay nga sakup ang Gadareno, ginsolang-solang si Jesus ang darwa ka tao nga nagalin sa mga kowiba nga rulubungan. Ang darwa nga dato ka tao pario nga may mga malain nga ispirito. Masyado sanda kaisug, gani naadlukan ang mga tao nga magagi doto. ");
INSERT INTO clu_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Pagkakita nanda kay Jesus nagsinggit sanda, makon, “Ikaw nga Bata ang Dios, ano imong labut kanamun? Nagayan kaw digi agud silotan kami? Bukun pa gani ang oras.” ");
INSERT INTO clu_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Karon, doto sa marayu-rayu doro nga mga baboy ang nagaparanginaun. ");
INSERT INTO clu_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Nagpakitloy ang mga malain nga ispirito nga nagakoon, “Kon pagoaun mo gid man kami, abi togoti kami nga magsulud doto sa mga baboy nga dato.” ");
INSERT INTO clu_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Makon ni Jesus kananda, “Ala sigi doto kamo!” Gani naggoa sanda sa darwa ka tao kag nagsulud sanda sa mga baboy. Kag nagdaragoyon dayon ang tanan nga mga baboy palusub sa matidluk nga banggilid diritso sa tobig kag nagkaralumus. ");
INSERT INTO clu_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ang mga manogsagod tana ang baboy nagdaralagan sa kaadluk paayan sa banwa kag pagabot nanda doto nagpamarita sanda kon ano ang natabo sa mga baboy kag sa darwa ka tao nga dati may malain nga ispirito. ");
INSERT INTO clu_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Gani ang tanan nga tao sa banwa nagarayan kay Jesus kag nagpakitloy nga kon maimo magalin tana doto sa andang logar. ");
INSERT INTO clu_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Gani nagsakay ruman sanday Jesus sa sakayan kag nagpalayag sanda pabalik. Kag pagabot nanda doto nagoli dayon si Jesus sa anang banwa. ");
INSERT INTO clu_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ang tana doto ron, may mga tao nga nagabot nga nagakantoang ang tao nga paralitiko. Pagkakita ni Jesus nga mabaul andang pagtoo kanana, nagkoon tana sa paralitiko, makon na, “Magkalipay kaw, imong mga sala ginpatawad run.” ");
INSERT INTO clu_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Karon, may mga manogtodlo doto ang Kasogoan nga nakabati, gani makon nanda sa andang una-una lang, “Anang ginaambal ang tao nga dia kontra sa Dios.” ");
INSERT INTO clu_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Naulaman ni Jesus kon ano andang ginaisip, gani makon na kananda, “Basi nagaisip kamo ang marimo? ");
INSERT INTO clu_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Diin bala ang mas maulas, ang magkoon sa paralitiko nga ‘Imong mga sala ginpatawad run,’ okon ang magkoon nga ‘Pagtindug kag magpanaw’? ");
INSERT INTO clu_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Dadi pamatodan ko kanindo paagi sa pagayad ang paralitiko nga dia nga Ako nga Naging Tao may gaum digi sa logta sa pagpatawad ang mga sala.” Kag makon na dayon sa paralitiko, “Pagtindug, daraa imong iringgaan kag magoli.” ");
INSERT INTO clu_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Kag nagtindug ra nga lagi ang tao kag nagoli. ");
INSERT INTO clu_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Pagkakita dato ang mga tao ginkulbaan sanda, kag gindayaw nanda ang Dios ay nagtaw tana ang gaum nga toladato sa mga tao. ");
INSERT INTO clu_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Pagalin ni Jesus doto nakita na ang manogsokot ang bois nga si Mateo nga nagapongko sa anang opisina. Makon ni Jesus kanana, “Dali, pagsonod kanakun.” Kag nagtindug ra dayon si Mateo kag nagsonod kay Jesus. ");
INSERT INTO clu_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Karon, ang si Jesus kag anang mga somolonod nagakaun sa balay ni Mateo, doro nga manogsokot ang bois kag iba pa nga ginakilala kono nga mga makasasala ang nagabot kag nakaiban nanda sa pagkaun. ");
INSERT INTO clu_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Kag dia nakita ang mga Pariseo. Gani ginpamangkot nanda anang mga somolonod, makon nanda, “Basi nagadapun sa pagkaun indong manogtodlo sa mga tao nga dan nga mga makasasala?” ");
INSERT INTO clu_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Dato nga pamangkot nabatian ni Jesus, gani ginsabat na paagi sa paanggid, makon na, “Bukun ang mga tao nga mayad andang lawas ang nagakinanglan ang manogbolong, kondi ang nagamasakit. ");
INSERT INTO clu_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Osisaa nindo kon ano anang kaologan anang ginakoon ang nakasolat sa Kasolatan nga, ‘Bukun indong mga alad akun gosto kondi indong kalooy sa isara kag isara.’ Ara ako nagayan digi agud tawagun ang mga tao nga nagakabig sa andang kaogalingun nga sanda matarung, kondi nagayan ako tana digi para sa mga tao nga nagaako nga sanda makasasala.” ");
INSERT INTO clu_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","May mga somolonod si Juan nga manogbunyag nga nagayan doto kay Jesus kag nagpamangkot, makon nanda, “Kami kag ang mga Pariseo pirmi nga nagapoasa. Piro basi imong mga somolonod tana ara nagapoasa?” ");
INSERT INTO clu_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Makon ni Jesus nga nagsabat kananda, “Ipabutang ta may kasal. Syimpri indi maimo nga magpangasubu ang mga bisita mintras kaiban nanda pa ang nobyo. Piro magaabot ang adlaw nga ang nobyo bulun run kananda, kag bago sanda magaporoasa.” ");
INSERT INTO clu_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Nagsogid ra si Jesus ang mga paanggid agud itodlo kananda nga indi maimo nga dapunun anang mga panodlo kag ang dati nga mga panodlo ang mga Judio. Makon na, “Ang bago nga tila nga ara pa mapakuru bukun mayad nga itambul sa lagi nga lambong, tungud nga kon bonakan run ang tinambulan nga lambong, magakuru ang bago nga tila kag magairit ang tinambulan. Kag magabaul run gid anang gisak. ");
INSERT INTO clu_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Maman ra dan ang matatabo kon ibutang ang bago nga bino sa lagi nga suruludan nga panit. Mabobostik ang suruludan, kag maooyang ang bino. Kag indi run da mapolosan ang suruludan. Gani kinanglan gid nga ang bago nga bino ibutang sa bago ra nga suruludan nga panit agud ara may maiwan.” ");
INSERT INTO clu_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Mintras nagaambal pa si Jesus, may Judio nga opisyal nga nagabot. Naglood tana kay Jesus kag nagpakitloy, makon na, “Akun bata nga babai bago lang gid napatay, piro kon ayanan mo kag itongtong imong alima kanana, nagapati ako nga maboboi tana ruman.” ");
INSERT INTO clu_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Gani nagtindug si Jesus kag magtabid kanana. Anang mga somolonod ni Jesus nagtabid ra. ");
INSERT INTO clu_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Mintras nagapanaw sanda, may babai nga nagaparapit gid sa anang likod kampi ni Jesus. Dato nga babai ginatagas-tagasan ang dogo sa sulud dosi ka toig. Naisip na nga kon tana makatandug lang gid sa anang lambong ni Jesus magaayad tana. Gani gintandug na anang sidsid anang lambong ni Jesus. ");
INSERT INTO clu_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Nagliso dayon si Jesus kag pagkakita na sa babai makon na, “Nene, magkalipay kaw, imong pagtoo kanakun ang nagpaayad kanimo.” Kag lagi-lagi nagayad ang babai nga dato. ");
INSERT INTO clu_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Nagdayon sanday Jesus sa anang balay ang opisyal, kag pagsulud na doto nakita na nga doto ron ang mga mosikiro para sa patay kag ang mga tao nga nagakinagolo. ");
INSERT INTO clu_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Gani makon na sa mga tao, “Abi paggoa kamo anay, ay bukun patay ang bata kondi nagakatorog tana lang.” Kag ginkadlawan nanda si Jesus. ");
INSERT INTO clu_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Pagkapagoa ni Jesus sa mga tao, nagsulud tana dayon sa anang koarto ang bata. Ginkaputan na anang alima kag nagbangon dayon ang bata. ");
INSERT INTO clu_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Kag ang natabo nga dia nabantog sa tanan nga mga banwa sa palibot. ");
INSERT INTO clu_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Pagalin ni Jesus sa logar nga dato, may darwa ka bolag nga nagsonod kanana nga nagasinggit. Makon nanda, “Ikaw nga manonobli anang ginarian ni David, abi kaloyi kami ra!” ");
INSERT INTO clu_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Pagabot ni Jesus sa balay nga anang ginadayonan, nagparapit kanana ang darwa nga dato ka bolag. Ginpamangkot na sanda, makon na, “Nagapati kamo bala nga mapaayad ko kamo?” Makon nanda, “Uu, nagapati kami.” ");
INSERT INTO clu_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Kag gintandug dayon ni Jesus andang mata kag magkoon, “Sono sa indong pagtoo maman da ang matatabo kanindo.” ");
INSERT INTO clu_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Kag nagayad ra nga lagi andang mata kag nakakita sanda run. Ginbilinan sanda dayon ni Jesus nga indi sanda gid magpanogid-sogid bisan kino. ");
INSERT INTO clu_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Piro andang ginimo tana, nagpanaw sanda kag ginpamarita nanda sa bilog nga logar nga dato kon ano anang ginimo ni Jesus kananda. ");
INSERT INTO clu_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Pagkaalin nanda, may gindara kay Jesus nga sangka apa nga ginsuludan ang malain nga ispirito. ");
INSERT INTO clu_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Pagkatapos nga napagoa ni Jesus ang malain nga ispirito, nakaambal ra nga lagi ang apa. Natingala nga mayad ang mga tao. Makon nanda, “Alin pa ang ona ara kita may nakita nga pario dia sa bilog nga Israel.” ");
INSERT INTO clu_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Piro nagkoon ang mga Pariseo, makon, “Anang manogdomara ang mga malain nga ispirito maman ang nagataw gaum kanana agud mapalayas na ang mga malain nga ispirito.” ");
INSERT INTO clu_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Naglibot si Jesus sa mga banwa kag mga bario kag nagtodlo tana sa anang mga simbaan ang mga Judio. Ginwali na ang Mayad nga Barita parti sa anang pagari ang Dios, kag ginpangayad na ang mga tao sa sari-sari nga mga masakit kag mga balatian. ");
INSERT INTO clu_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Pagkakita na sa doro nga mga tao, nalooy tana kananda tungud nga doro andang mga paralibugan piro ara may nagabolig kananda. Andang kaalimbawa pario sa mga karniro nga ara may nagabantay. ");
INSERT INTO clu_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Gani nagkoon tana sa anang mga somolonod, makon na, “Doro ang mga tao nga priparado ron sa pagbaton ang Mayad nga Barita. Andang kaalimbawa pario sa araniun nga kaostoan run gid nga aniun. Malapad ang araniun, garing malaka ang nagaani. ");
INSERT INTO clu_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Gani magpangamoyo kamo sa Dios nga tagya ang araniun nga magpadara tana pa gid ang mga manogani.” ");
INSERT INTO clu_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Gintawag ni Jesus anang dosi ka somolonod kag ginpanawan na sanda gaum nga magpalayas ang mga malain nga ispirito sa mga tao nga andang ginsuludan, kag ginpanawan na sanda ra ang gaum nga magayad ang bisan ano nga klasi nga masakit kag balatian. ");
INSERT INTO clu_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Maman dia anang aran ang dosi ka apostolis: ona sa tanan, si Simon nga gintawag ni Jesus nga Pedro kag anang libayun nga si Andres; kabilang ra anang darwa ka bata ni Zebedeo nga si Santiago kag anang libayun nga si Juan; ");
INSERT INTO clu_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","sonod si Felipe, si Bartolomeo, si Tomas, si Mateo nga manogsokot ang bois, si Santiago nga bata ni Alfeo, si Tadeo, ");
INSERT INTO clu_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","si Simon (dati nga ribildi sa gobyirno ang Roma), kag si Judas Iscariote nga maman ang nagtraidor kanana. ");
INSERT INTO clu_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Bago papanawon ni Jesus ang dosi nga dato ginbilinan na sanda anay; makon na, “Indi kamo magayan sa anang logar ang mga bukun Judio okon sa mga banwa ang Samaria; ");
INSERT INTO clu_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","kondi sa anang mga kaapo-apoan lang ni Israel kamo magpangwalian. Andang kaalimbawa pario sa mga karniro nga nagtaralang. ");
INSERT INTO clu_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Sogidan nindo sanda nga oras run dia nga ang Dios magaari run sa mga tao. ");
INSERT INTO clu_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ayadun nindo ang mga masakitun, boiun nindo ang mga patay, ayadun nindo ra ang mga aroon, kag palayasun nindo ang mga malain nga ispirito sa mga tao nga andang ginsuludan. Ginbaton nindo sa Dios nga libri, gani itaw nindo ra nga libri. ");
INSERT INTO clu_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Indi kamo magimorat nga magdara koarta ");
INSERT INTO clu_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","okon bag okon irilisan nga lambong okon sandalyas okon baston, tungud nga ang tao nga nagapangabudlay dapat gid man nga tawan anang mga kinanglanun. ");
INSERT INTO clu_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Kon magabot kamo sa sangka banwa okon sa sangka bario, magpangita kamo ang tao nga mayad nga dayonan. Kag doto kamo magdayon asta kamo magalin sa logar nga dato. ");
INSERT INTO clu_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Pagsulud nindo sa balay nga nagabaton kanindo bindisyonan nindo ang mga nagaoli doto. ");
INSERT INTO clu_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Karon, kon ang panimalay nga dato mga mayad nga tao, dan bindisyonan sanda ang Dios, piro kon bukun, bawiun nindo ron lang indong pagbindisyon. ");
INSERT INTO clu_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Kon may mga panimalay okon banwa nga indi gid magbaton kanindo okon indi gid magpamati sa indong ginasogid, bayai nindo ron lang, kag pagalin nindo tapokan nindo ang yabok sa indong siki bilang tanda kontra kananda. ");
INSERT INTO clu_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Sa matood tana, ang silot nga andang mababaton sa Adlaw ang Pagukum sobra pa sa silot nga mababaton ang mga taga-Sodoma kag ang mga taga-Gomora.” ");
INSERT INTO clu_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Tandaan nindo dia! Indong kaalimbawa pario sa mga karniro nga akun ginapadara sa mga mapirintas nga sapat. Gani magmaaram kamo pario sa mga magkal, piro maging pario kamo ra sa mga salampati nga ara nagaimo ang malain. ");
INSERT INTO clu_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Magandam kamo kananda ay pandakupun nanda kamo kag daraun sa andang mga manogsintinsya kag panganoton nanda kamo doto sa andang mga simbaan. ");
INSERT INTO clu_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Iakosar nanda kamo sa mga gobirnador kag mga ari tungud nga kamo nagatoo kanakun, kag doto magasogid kamo ang Mayad nga Barita kananda pati sa andang mga tinao nga bukun Judio. ");
INSERT INTO clu_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Kon kamo ginaimbistigar run indi kamo magpalibug kon ano indong iambal, kag kon paiwan indong panabat; tungud nga kon kamo doto ron ang Ispirito Santo maman ang magatodlo kanindo indong iambal. ");
INSERT INTO clu_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Gani indong iambal bukun indo kondi ana ang Ispirito nga alin sa indong Tatay. Tana ang magaambal paagi kanindo. ");
INSERT INTO clu_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Sa mga adlaw nga dato may mga tao nga ipapatay nanda bisan andang kabogto gid. May mga tatay nga ipapatay nanda andang mga bata. Kag may mga bata nga magakontra sa andang mga ginikanan, kag ipapatay nanda sanda. ");
INSERT INTO clu_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Dumutan kamo ang tanan tungud nga kamo akun mga somolonod. Piro ang magpadayon nga magsonod kanakun asta sa kataposan maman ang malowas. ");
INSERT INTO clu_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Kon kamo ingaboton sa sangka banwa, magpalagyaw kamo sa isara. Ay sa matood tana, indi nindo pa malibot ang tanan nga mga banwa ang Israel bago Ako nga Naging Tao makabalik. ");
INSERT INTO clu_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Ara istodyanti nga nagalabaw sa anang maistro, kag ara ra oripun nga nagalabaw sa anang agalun. ");
INSERT INTO clu_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Gani dapat maging kontinto ang istodyanti kon tana tratarun pario sa anang maistro, kag ang oripun kon tana tratarun pario sa anang agalun. Kon ako gani nga pinakatatay ang panimalay gintawag nga Satanas, mas sobra pa dian andang itawag kanindo nga akun mga somolonod.” ");
INSERT INTO clu_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Gani indi kamo magkaadluk sa mga tao. Ay ara sikrito nga ginatago nga indi maggoa kag maulaman sa ori. ");
INSERT INTO clu_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ang mga butang nga kanindo ko lang gid ginasogid, isogid nindo sa tanan. Kag ang mga butang nga akun ginaotik kanindo, ibantala nindo sa mga tao. ");
INSERT INTO clu_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Indi kamo magkaadluk sa mga tao nga makapatay indong lawas piro indi makapatay indong kalag. Dapat tana ang Dios maman indong kaadlukan, tungud nga tana ang sarang makadora indong lawas kag indong kalag nga ipilak doto sa impyirno. ");
INSERT INTO clu_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Kabay ang kabarato lang gid anang bayad ang pispis nga mairintuk kon ibaligya. Piro ara gid pispis nga nagalagpak sa logta kon bukun anang pagbuut indong Tatay. ");
INSERT INTO clu_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Kag kon parti kanindo, bisan indong book bilang na tanan. ");
INSERT INTO clu_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Gani indi kamo magkaadluk, ay mas palangga kamo kaysa mga pispis.” ");
INSERT INTO clu_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Ang bisan sino nga nagasogid sa mga tao nga ako anang Ginoo, kilalaun ko ra nga tana akun sa anang atobangan akun Tatay nga sa langit. ");
INSERT INTO clu_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Piro ang bisan sino nga nagapanginwara sa mga tao nga ako anang Ginoo, indi ko tana ra pagkilalaun sa atobangan akun Tatay nga sa langit.” ");
INSERT INTO clu_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Indi kamo maguna-una nga nagayan ako digi sa kalibotan agud indi run magaraway ang mga tao. Ara ako nagayan digi para magdara kalinung. ");
INSERT INTO clu_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nagayan ako digi agud magkontra ang mga bata nga lalaki sa andang tatay, ang mga bata nga babai sa andang nanay, kag ang mga omagad nga babai sa andang ogangan nga babai. ");
INSERT INTO clu_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Anang maging kakontra ang tao anang pamilya mismo. ");
INSERT INTO clu_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Piro ang nagapalabi anang tatay okon anang nanay kaysa kanakun indi poidi kanakun. Kag ang nagapalabi sa anang bata kaysa kanakun indi ra piodi kanakun. ");
INSERT INTO clu_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ang bisan sino nga indi magsonod kanakun bisan pa kon kamatayun anang atobangan indi poidi kanakun. ");
INSERT INTO clu_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ang mga tao nga nagapanigoro andang kaboi digi sa kalibotan nga dia madodora pa ra gid; piro ang mga ara nagapanginayang andang kaboi tungud sa andang pagsonod kanakun maman ang makakabaton ang kaboi nga ara kataposan.” ");
INSERT INTO clu_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ang tao nga nagabaton kanindo nagabaton ra kanakun. Kag ang mga nagabaton kanakun nagabaton ra sa nagpadara kanakun. ");
INSERT INTO clu_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ang tao nga nagabaton anang manogambal ang Dios tungud nga manogambal tana gani ang Dios, magabaton ra balus alin sa Dios pario anang babatonon anang manogambal ang Dios. Kag ang nagabaton ang matarung nga tao tungud gani nga tana matarung, magabaton ra balus alin sa Dios pario anang babatonon ang matarung nga tao. ");
INSERT INTO clu_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Kag ang bisan sino nga magtaw bisan sangka baso lang gid nga tobig sa isara sa akun pinakakubus nga somolonod tungud nga tana akun somolonod, dan nga tao indi gid madoraan anang balus.” ");
INSERT INTO clu_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Pagkatapos nga mapasanag ni Jesus anang mga bilin sa anang dosi ka somolonod nagayan tana sa palibot nga mga banwa para magtodlo kag magwali sa mga tao. ");
INSERT INTO clu_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Pagkabati ni Juan nga manogbunyag doto sa prisoan parti sa anang mga ginimo ni Jesus, ginpaayan na kay Jesus anang mga somolonod para magpamangkot. ");
INSERT INTO clu_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Makon nanda kay Jesus, “Abi sogidi kami kon ikaw maman run amun ginapaabot okon mapaabot kami pa ang iba?” ");
INSERT INTO clu_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ginsabat sanda ni Jesus, makon na, “Pagbalik kamo kay Juan kag sogidan nindo tana kon ano akun ginaimo nga indong nakita kag kon ano akun ginaambal nga indong nabatian. ");
INSERT INTO clu_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Konon nindo tana nga ang mga bolag nakakakita, ang mga piang nakakapanaw, ang mga bungul nakakabati, ang mga aroon nagaayad, ang mga patay naboboi, kag ang Mayad nga Barita ginawali sa mga marilisud. ");
INSERT INTO clu_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Kag masoirti ang mga tao nga ara nagadoda kanakun.” ");
INSERT INTO clu_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Pagkalombos anang mga somolonod ni Juan, nagpamangkot si Jesus sa mga tao; makon na, “Pagayan nindo kay Juan sa naligwin nga logar, ano indong ginapaabot nga makita? Nagayan kamo doto agud makita nindo ang tao nga nagapaayon-ayon pario sa kogon kon uyupun ang angin? ");
INSERT INTO clu_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Nagayan kamo doto agud makita nindo ang tao nga maraalun anang lambong? Bukun ra, ay ang tao nga toladan makikita lang tana sa palasyo. ");
INSERT INTO clu_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Abi sogidi nindo ako kon basi nagayan kamo doto. Para makita anang propita ang Dios? Tama, propita tana manda kag sobra tana pa gani. ");
INSERT INTO clu_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ay tana maman anang ginakoon ang Dios sa Kasolatan nga nagakoon, ‘Paonaun ko kanimo akun manogbarita agud ipriparar na imong aragian.’” ");
INSERT INTO clu_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Kag makon pa ni Jesus, “Sa matood tana, asta dadi ara may nabata sa kalibotan nga maglabaw kay Juan nga manogbunyag. Piro ang tao dadi nga nagapasakup sa anang ginarian ang Dios, bisan tana ang pinakakubus, mas labaw pa kay Juan. ");
INSERT INTO clu_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Alin anang pagompisa wali ni Juan asta dadi, ang mga tao nagarugus nga pasuludun sanda ang Dios sa anang ginarian. ");
INSERT INTO clu_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ay bago magabot si Juan, ang tanan nga mga propita kag ang Kasogoan nagatodlo ron nga lagi parti sa anang pagari ang Dios. ");
INSERT INTO clu_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Kag kon patiun nindo andang mga ginakoon, si Juan ara iba kondi si Elias nga gintagna nga magaabot. ");
INSERT INTO clu_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Gani binag-binagun nindo dia nga mayad. ");
INSERT INTO clu_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Ta, sa ano ko kabay ipaanggid ang mga tao sa tyimpo nga dia? Midyo sanda sa mga bata nga nagaporongko sa plasa. Makon ang sangka gropo sa isara, ");
INSERT INTO clu_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Gintokaran namun kamo ang sonata nga pangkasal, garing ara kamo magsaot. Ginkantaan namun kamo ang kanta para sa patay, piro ara kamo ra magpanangis.’ ");
INSERT INTO clu_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ang mga tao dadi toladan ra, ay pagabot ni Juan, nakita nanda nga nagapoasa tana kag ara nagainum ang mga irinumun nga karilingin, gani nagakoon sanda nga tana may malain nga ispirito. ");
INSERT INTO clu_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Kag Ako nga Naging Tao, pagabot ko, nakita nanda nga ako nagakaun kag nagainum, gani nagakoon sanda nga ako kono takaban kag manogpalingin. Nagakoon sanda ra nga ako anang amigo ang mga tao nga makasasala pario ang mga manogsokot ang bois. Piro indi bali, anang inimoan ang tao maman ang nagapamatood kon osto anang ginaimo okon bukun.” ");
INSERT INTO clu_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Pagkatapos dato nagambal si Jesus kontra sa mga banwa nga anang ginpangimoan ang kadoroan anang mga milagro tungud nga ara sanda gid magirinulsul sa andang mga sala. ");
INSERT INTO clu_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Makon na, “Kailo kamo nga mga taga-Corazin! Kag kailo kamo ra nga mga taga-Betsaida! Ay kon ang mga milagro nga akun ginpangimo dian kanindo ginimo ko sa Tiro kag sa Sidon, boay sanda run andan maglambong ang lambong nga sako kag magbutang abo sa andang olo bilang pagpakilala nga sanda nagainulsul run sa andang mga sala. ");
INSERT INTO clu_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Gani dumdumun nindo nga sa adlaw nga ang Dios magukum, ang silot nga para kanindo sobra pa sa silot nga para sa mga taga-Tiro kag taga-Sidon. ");
INSERT INTO clu_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Kag kamo nga taga-Capernaum, indong pagsarig dayawon kamo ang tanan. Piro sa impyirno kamo gid tana itatagbung! Ay kon ang mga milagro nga akun ginpangimo dian kanindo ginimo ko sa Sodoma, andan asta dadi dian pa ang Sodoma! ");
INSERT INTO clu_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Gani dumdumun nindo nga sa adlaw nga ang Dios magukum, ang silot nga indong batonon sobra pa sa silot nga para sa taga-Sodoma.” ");
INSERT INTO clu_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Kag nagpangamoyo dayon si Jesus nga nagakoon, makon na, “Itay, nga tagya ang langit kag logta, ginadayaw ta kaw tungud nga ang kamatoodan nga gintago mo sa mga maaram kag may tinonan ginpasanag mo sa mga tao nga midyo sa mga bata. ");
INSERT INTO clu_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Salamat gid, Itay, nga toladato imong gosto.” ");
INSERT INTO clu_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Pagkatapos makon ni Jesus sa mga tao doto, “Ang tanan nga butang gintogyan kanakun akun Tatay. Ang Tatay lang ang nakakikilala gid kanakun nga anang bata. Kag ang nakakikilala gid sa Tatay ako lang nga anang bata kag ang mga tao nga akun gosto nga pakilalaun sa Tatay. ");
INSERT INTO clu_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Pagrapit kamo kanakun, tanan kamo nga ginapilayan kag ginabugatan kag papawayun ko kamo. ");
INSERT INTO clu_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Magsonod kamo kag magpatodlo kanakun ay ako malolo kag mabuut. Makapaway kamo, ");
INSERT INTO clu_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","ay akun mga sogo madali nga tomanun kag maugan lang akun ginapaimo.” ");
INSERT INTO clu_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","May pira ka adlaw pagkatapos dato, ang Adlaw nga Inogpaway, nagagi sanday Jesus sa katrigoan. Gutum anang mga somolonod, gani nagpangutul sanda anang mga way kag magkaun. ");
INSERT INTO clu_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Pagkakita dato ang mga Pariseo makon nanda kay Jesus, “Sulunga bala anang ginaimo imong mga somolonod. Kabay dadi Adlaw nga Inogpaway. Kontra sa Kasogoan andang ginaimo nga dan.” ");
INSERT INTO clu_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ginsabat sanda ni Jesus, makon na, “Basi bawal? Ara nindo bala nabasai sa Kasolatan anang ginimo ni David ang ona ang gingutum tana kag anang mga kaiban? ");
INSERT INTO clu_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Kabay nagsulud sanda sa anang balay ang Dios kag ginkaun nanda doto ang pagkaun nga ginalad sa Dios. Kag ara sanda nagkasala bisan kontra gani sa Kasogoan ang magkaun dato, loas lang ang mga pari. ");
INSERT INTO clu_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Kag isara pa, ara nindo ra bala nabasai sa anang mga ginsolat ni Moises nga ang mga pari mismo sa timplo nagasoway ang Kasogoan kada Adlaw nga Inogpaway tungud nga ara sanda nagapaway? Piro dato ara ginabilanga nga sala para kananda. ");
INSERT INTO clu_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ang matood tana may digi dadi nga mas importanti kaysa sa timplo. ");
INSERT INTO clu_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","8","Ay Ako nga Naging Tao may gaum nga magkoon kon ano ang tama nga imoon sa Adlaw nga Inogpaway. Ara nindo andan pagpakalaina ang mga tao nga ara sala kon naintindian nindo anang ginakoon ang Dios sa Kasolatan nga ‘Ara ako naliag sa indong mga alad, kondi gosto ko tana nga maging maloloyon kamo sa indong kapario.’” ");
INSERT INTO clu_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Pagkatapos dato nagalin dayon si Jesus doto kag magayan sa isara sa anang mga simbaan ang mga Judio. ");
INSERT INTO clu_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Karon may tao doto nga ukru anang alima. Kag may mga tao ra doto nga nagapanilag kag nagapangita paagi agud iakosar nanda si Jesus sa anang ginaimo. Gani nagpamangkot sanda kay Jesus, makon nanda, “Ano kabay, bawal ang magayad ang masakitun kon Adlaw nga Inugpaway?” ");
INSERT INTO clu_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Makon ni Jesus kananda, “Alimbawa abi may karniro kamo nga naolog sa boo sa Adlaw nga Inogpaway. Ano, pabayanan nindo lang tungud Adlaw nga Inogpaway? Natoral indi. ");
INSERT INTO clu_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Piro ang tao mas importanti kaysa karniro. Gani ara ta ginasowaya ang Kasogoan kon nagabolig kita sa atun kapario abir kon Adlaw nga Inogpaway.” ");
INSERT INTO clu_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Makon dayon ni Jesus sa tao nga ukru anang alima, “Abi onata imong alima.” Kag ginonat na ra gani, kag nagayad nga pario ron sa anang isara nga alima. ");
INSERT INTO clu_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Nagaralin dayon ang mga Pariseo kag nagsorogidanun sanda kon paiwan nanda ipapatay si Jesus. ");
INSERT INTO clu_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Pagkaulam ni Jesus sa anang plano ang mga Pariseo, nagalin tana sa logar nga dato. Dorong mga tao ang nagsonod kanana kag ang tanan nga mga nagamarasakit ginayad na. ");
INSERT INTO clu_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Piro ginbilinan na sanda nga indi sanda magpanogid-sogid parti kanana ");
INSERT INTO clu_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","agud matoman anang koon ang Dios paagi sa propita Isaias. Makon na, ");
INSERT INTO clu_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Maman dia akun ginpili nga sorogoon. Palangga ko tana kag nalilipay ako nga mayad kanana. Paagobayan ko tana sa akun Ispirito. Kag pasanagan na ang mga tao sa tanan nga logar ang parti sa katarungan. ");
INSERT INTO clu_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Indi tana magpakigdiskosyon ang mainit sa mga tao, Okon magsinggit, Okon magdiskorso sa mga karsada. ");
INSERT INTO clu_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Indi na pagpabayanan ang mga maroya sa pagtoo, Ay boboligan na ang tanan bisan ang tao nga maistan lang gid anang pagtoo kanana. Indi tana magtadung asta matoman anang mga sogo ang Dios. ");
INSERT INTO clu_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Kag ang mga tao sa tanan nga logar magasarig kanana.” ");
INSERT INTO clu_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Karon may gindara kay Jesus nga tao nga bolag kag apa tungud nga ginsuludan tana ang malain nga ispirito. Ginayad ni Jesus ang tao nga dato kag lagi-lagi nakaambal tana kag nakakita. ");
INSERT INTO clu_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Natingala ang tanan, kag makon nanda, “Ano kabay, maman run dia anang pinakaapo ni Aring David nga mapanobli anang ginarian?” ");
INSERT INTO clu_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Pagkabati ang mga Pariseo makon nanda, “Dan nga tao nagapalayas ang mga malain nga ispirito tungud nga gintawan tana gaum ni Satanas. Ay si Satanas maman anang manogdomara ang mga malain nga ispirito.” ");
INSERT INTO clu_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Naulaman ni Jesus andang mga una-una, gani makon na kananda, “Kon anang mga pomoloyo ang sangka ginarian magburulag-bulag kag magaraway, dan nga ginarian madodora. Pario ra dan ang matabo sa bisan ano nga banwa okon pamilya kon anang mga sinakupan magaraway. ");
INSERT INTO clu_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Gani kon paagi sa anang gaum ni Satanas nagapalayas ako anang mga sinakupan, tay ginarangga na lang anang kaogalingun nga ginarian. ");
INSERT INTO clu_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Kag kon anang gaum ni Satanas akun ginagamit para magpalayas ang mga malain nga ispirito, ta sino ang nagataw gaum sa indong mga somolonod nga nagapalayas ra ang mga malain nga ispirito? Indong mga somolonod mismo nagapamatood nga sala kamo. ");
INSERT INTO clu_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Karon, tungud nga paagi sa anang Ispirito ang Dios nagasobol ako ang mga malain nga ispirito, dia nagapamatood nga anang ginarian ang Dios nagabot ron kanindo. ");
INSERT INTO clu_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Napirdi ko ron si Satanas. Maman dan napapalayas ko anang mga sinakupan. Tungud nga ara tao nga sarang makasulud sa anang balay ang mapurus nga tao agud bulun na anang pagkabutang kon indi na anay paggaposon ang tao nga dan. ");
INSERT INTO clu_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Ang ara nagakampi kanakun nagakontra kanakun. Kag ang ara nagabolig kanakun sa pagtipon anang mga tao ang Dios nagaparapta lang. ");
INSERT INTO clu_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Gani sogidan ko kamo; ang tao sarang mapatawad sa bisan ano nga sala, bisan magyagota tana. Piro ang nagayagota sa Ispirito Santo indi gid mapatawad. ");
INSERT INTO clu_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ang bisan sino nga magambal malain kontra Kanakun nga Naging Tao mapapatawad; piro ang magambal malain kontra sa Ispirito Santo indi gid mapapatawad asta kon sano.” ");
INSERT INTO clu_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Makakoon kita nga masadya ang kaoy kon makita ta nga masadya anang bonga, okon marimo ang kaoy kon makita ta nga marimo anang bonga. Ay ang kaoy nakikilala sa anang bonga. ");
INSERT INTO clu_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Kamo mga liwat ang magkal. Kag tungud nga kamo malain, paiwan indong pagambal ang mayad? Ay kon ano ang sa tagiposoon maman ra ang nagagoa sa baba. ");
INSERT INTO clu_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ang tao nga mayad nagaambal ra ang mayad, ay mayad anang ginaisip. Piro ang tao nga malain nagaambal ang malain, ay marimo anang ginaisip. ");
INSERT INTO clu_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Sa matood tana, sa Adlaw ang Pagukum ang kada isara magapanabat sa Dios sa anang mga ginambal nga ara polos. ");
INSERT INTO clu_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ay dipindi sa imong mga ginambal kon ikaw silotan okon indi.” ");
INSERT INTO clu_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","May mga manogtodlo ang Kasogoan kag mga Pariseo nga nagkoon kay Jesus, makon nanda, “Manogtodlo, abi pakitai kami ra tanda alin sa langit?” ");
INSERT INTO clu_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Makon ni Jesus kananda, “Ang mga tao lang nga malain kag nagtalikod sa Dios ang nagapangayo anay milagro bago sanda magtoo. Piro ara iba nga milagro akun ipakita kanindo kondi ang milagro nga natabo kay propita Jonas. ");
INSERT INTO clu_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Kon paiwan nga si Jonas tatlo ka adlaw kag tatlo ka gabi sa sulud anang tian ang isda, dan toladan ra ang matatabo Kanakun nga Naging Tao. Ay magatinir ako ra tatlo ka adlaw kag tatlo ka gabi sa idalum ang logta. ");
INSERT INTO clu_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Sa Adlaw ang Pagukum ang mga taga-Ninive magabasol kanindo ay sanda tana, pagkabati nanda anang wali ni Jonas, nagirinulsul. Kag dadi gani sobra pa kay Jonas ang digi, piro indi kamo magpati sa anang mga panodlo. ");
INSERT INTO clu_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Sa adlaw nga dato mababanaw ang Rayna ang Salatanan kaiban nindo nga mga tao sa dadi kag basolon na kamo ra. Ay tana nagalin sa anang logar gid sa salatanan agud magpamati sa anang kaaram ni Aring Solomon. Piro dadi may nagatodlo digi nga sobra pa kay Solomon, piro kamo tana indi magbaton anang ginatodlo.” ");
INSERT INTO clu_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Kon ang malain nga ispirito maggoa sa tao nga anang ginsuludan, nagapanlagoyawan tana sa mga logar nga ara tobig ay nagapangita tana ang logar nga anang mapawayan. Kag kon indi tana makakita anang parawayan ");
INSERT INTO clu_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","maisipan na nga mabalik tana run lang sa anang ginalinan. Kag kon sa anang pagbalik makita na nga ang logar nga anang ginalinan ara may nagaistar, limpyo kag naimus ang tanan, ");
INSERT INTO clu_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","mapanaw tana dayon kag mapangagad pito pa gid ka mga ispirito nga mas malain pa kaysa kanana. Kag masulud sanda dayon sa tao nga dato kag olian. Kag ang tao nga dato maging mas malain pa gid kaysa dati. Dan toladan ra ang matatabo sa mga tao dadi, magadogang pa gid andang kalain.” ");
INSERT INTO clu_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Mintras nagaambal pa si Jesus, nagabot anang nanay kag anang mga kabogto. Doto sanda sa goa nagaulat ay may inogambal sanda kanana. ");
INSERT INTO clu_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Makon ang sangka tao kanana, “Imong nanay kag imong mga kabogto nagatirindug doto sa goa. Gosto nanda nga magpakigsogidanun kanimo.” ");
INSERT INTO clu_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Nagsabat si Jesus kanana, makon na, “Naulaman mo bala kon sino gid akun nanay kag akun mga kabogto?” ");
INSERT INTO clu_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Pagkatapos gintodlo na dayon anang mga somolonod kag makon na, “Dia tana maman akun nanay kag akun mga kabogto. ");
INSERT INTO clu_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ay ang bisan sino nga nagaimo anang kabubutun akun Tatay sa langit, maman akun nanay kag mga kabogto.” ");
INSERT INTO clu_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ang adlaw ra nga dato, paggoa ni Jesus sa balay nagayan tana sa binit ang baybay kag magpongko. ");
INSERT INTO clu_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Piro tungud nga gintiripokpokan tana ang doro gid nga mga tao, somakay tana sa sakayan nga nagapondo kag doto nagpongko. Ang mga tao tana doto sa baybay nagaparamati mintras nagatodlo tana. ");
INSERT INTO clu_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Doro nga mga butang anang gintodlo kananda paagi sa mga paanggid nga pario dia: makon na, “May sangka mangongoma nga nagpanggas. ");
INSERT INTO clu_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Sa anang pagpanggas, ang iba nga bini nagtugpa sa binit ang dalan, kag gintoka ang mga pispis. ");
INSERT INTO clu_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ang iba nagtugpa sa kabatoan. Ang logta doto manipis lang. Gani madali nga nagtobo ang bini tungud nga manabaw ang logta. ");
INSERT INTO clu_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Piro paginit ang adlaw, nagkaralayung, ay anang gamot manabaw. ");
INSERT INTO clu_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ang iba pa gid nga bini nagtugpa sa logar nga dorong ilamonon nga masiit. Gani pagrabong ang mga ilamonon nalumus ang ginpanggas. ");
INSERT INTO clu_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Piro ang iba tana nagtugpa sa mayad nga logta kag dia tana nagpamonga. Ang iba tama-tama lang anang bonga, ang iba doro, kag ang iba doro gid. ");
INSERT INTO clu_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ta binag-binagun nindo gid indong nabatian nga dia.” ");
INSERT INTO clu_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Nagparapit dayon kay Jesus anang mga somolonod kag nagpamangkot. Makon nanda, “Basi nagaambal kaw sa mga tao paagi sa mga paanggid?” ");
INSERT INTO clu_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Makon ni Jesus kanada, “Tungud nga ang mga tinago ang ona parti sa anang pagari ang Dios ginasogid kanindo nga akun mga somolonod agud maintindian nindo, piro sa iba tana ara ginasogidan ang diritso. ");
INSERT INTO clu_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ay ang tao nga may naulaman run nga kamatoodan kag anang ginasonod dogangan pa gid ang Dios anang pagintindi, kag doro anang idogang kanana. Piro ang tao tana nga ara nagasonod sa anang naulaman nga kamatoodan, pati anang naulaman nga maistan bubulun pa kanana. ");
INSERT INTO clu_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Gani nagaambal ako kananda paagi sa mga paanggid tungud nga sigi andang sulung piro indi sanda makakita, kag sigi andang pamati piro indi makaintindi. ");
INSERT INTO clu_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Gani natoman kananda anang ginkoon ang Dios ang ona paagi sa propita nga si Isaias. Ay makon na, ‘Sigi indong pamati piro indi kamo gid makaintindi, Kag sigi indong sulung piro indi kamo gid makakita ang kamatoodan. ");
INSERT INTO clu_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Tungud nga nagturugas anang olo ang mga tao nga dia, kag indi magpati. Gintabonan nanda andang mga talinga, Kag ginpuyung nanda andang mga mata. Ay sabun makakita sanda kag makabati, Kag maintindian kag magliso dayon kanakun, Kag ayadun ko sanda.’ ");
INSERT INTO clu_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Piro,” makon ni Jesus, “kamo tana nga nagasonod kanakun masoirti, ay kamo nakakikita kag nakababati. ");
INSERT INTO clu_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Sa matood tana, doro nga mga propita kag mga matarung nga mga tao ang ona ang nagarandum nga makakita kag makabati indong nakikita kag nababatian dadi, piro ara natabo sa andang tyimpo.” ");
INSERT INTO clu_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Gani, pamatii nindo dia kag toonan nindo kon ano anang kaologan ang paanggid parti sa tao nga nagpanggas. ");
INSERT INTO clu_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ang tao nga nagapamati ang minsai parti sa anang pagari ang Dios piro ara kaintindi, pario sa anang binit ang dalan nga gintugpaan ang bini. Nagaabot kanana si Satanas, kag ginaagaw na ang ginpanggas sa anang tagiposoon. ");
INSERT INTO clu_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ang kabatoan nga manipis lang ang logta nga gintugpaan ang bini pario sa tao nga nakabati ang minsai parti sa pagari ang Dios. Nagbaton tana nga lagi nga may kalipay. ");
INSERT INTO clu_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Garing bukun gid tuduk sa anang tagiposoon, gani ara lang boay anang pagtoo. Pagabot ang kalisud okon pagingabot tungud sa anang ambal ang Dios nga anang ginabaton, ginabayaan na nga lagi anang pagtoo. ");
INSERT INTO clu_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ang logar nga dorong masiit nga mga ilamonon nga gintugpaan ang bini pario sa tao nga nakabati ra anang ambal ang Dios. Garing tungud sa mga paralibugan sa pangaboi kag andum nga magmanggad nalilipatan na anang ambal ang Dios nga anang nabatian kag ara napolosi. ");
INSERT INTO clu_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Piro ang mayad nga logta nga gintugpaan ang bini pario sa tao nga nagpamati gid kag nagaintindi anang ambal ang Dios. Gani napolosan na gid anang ambal ang Dios sa anang pagkaboi. Ang iba sa mga tao nga dia tama-tama lang andang napolosan sa andang nabatian, ang iba doro, kag ang iba doro gid.” ");
INSERT INTO clu_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Nagpadayon si Jesus sa anang pagtodlo sa mga tao paagi sa paanggid. Makon na, “Anang pagari ang Dios pario sa tao nga nagpanggas ang mayad nga bini sa anang logta. ");
INSERT INTO clu_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Pagkatapos nga tana nakapanggas, pagkagabi mintras tana nagakatorog, may tao nga may dumut kanana nga nagayan ra doto kag nagpanggas ang bugang kag magoli. ");
INSERT INTO clu_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Nagtorobo ang tanum, kag pagbonga bago pa nakita ang mga bugang. ");
INSERT INTO clu_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Gani anang mga sorogoon nagayan kanana kag nagkoon, makon, ‘Kabay mayad nga bini atun ginpanggas sa imong logta. Ta diin kabay nagalin ang mga bugang nga dato?’ ");
INSERT INTO clu_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Makon andang agalun, ‘Ang tao nga may dumut kanakun ang nagimo dan.’ Gani nagpamangkot sanda sa andang agalun kon panggaboton nanda. ");
INSERT INTO clu_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Makon andang agalun, ‘Indi lang ay basi kon magabot nindo pati ang tanum. ");
INSERT INTO clu_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Pabayani nindo ron lang asta magabot ang tigarani. Sa tigarani ko garing konon ang mga manogani nga panggaboton anay ang mga bugang kag bugkusun agud sonogon. Pagkatapos bago ko ipatipon kananda ang tubas sa akun bodiga.’” ");
INSERT INTO clu_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ginsogidan na sanda ra ang paanggid nga dia, makon na, “Anang pagari ang Dios pario sa bosol nga mostasa nga ginpanggas ang sangka tao sa anang logta. ");
INSERT INTO clu_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Anang bosol ang mostasa maman ang maistan gid sa tanan nga bosol. Piro kon magtobo ron gani maman gid ang mataas sa mga laswa, kag midyo ron sa kaoy anang kataas. Bisan gani ang mga pispis sarang run makapogad sa anang mga sanga.” ");
INSERT INTO clu_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ginsogidan na sanda pa gid sangka paanggid, makon na, “Anang kaalimbawa anang pagari ang Dios pario ra sa pampaabok nga ginlakut ang babai sa sangka labador nga arina kag anang ginmasa, kag nagabok dayon ang tanan nga ginmasa.” ");
INSERT INTO clu_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ginpaagi ni Jesus sa mga paanggid ang tanan nga anang mga panodlo parti sa anang pagari ang Dios. Ara tana may ginambal sa mga tao nga bukun paagi sa paanggid. ");
INSERT INTO clu_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ginimo na dato agud matoman anang ginkoon ang Dios paagi sa anang propita ang ona nga nagkoon, “Ako magaambal paagi sa mga paanggid, Isogid ko ang mga butang nga ara pa gid naulami alin pa ang pagimo ang kalibotan.” ");
INSERT INTO clu_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Pagkatapos dato ginbayaan ni Jesus ang mga tao kag nagsulud tana sa balay. Anang mga somolonod nagsulud ra doto kag nagpamangkot kanana, makon nanda, “Sogidi kami abi kon ano anang kaologan ang paanggid nga dato parti sa bugang.” ");
INSERT INTO clu_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Makon na, “Ang tao nga dato nga nagpanggas ang mayad nga bini ara iba kondi Ako nga Naging Tao. ");
INSERT INTO clu_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ang logta nga ginpanggasan maman ang kalibotan. Ang mayad nga bini ara iba kondi ang mga tao nga nagapasakup sa anang pagari ang Dios. Kag ang mga bugang maman ang mga tao nga mga sinakupan ni Satanas. ");
INSERT INTO clu_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Si Satanas tana maman ang tao nga may dumut nga nagpanggas ang mga bugang. Ang tigarani, anang kataposan run ang kalibotan, kag ang mga manogani ara iba kondi ang mga angil. ");
INSERT INTO clu_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Kon paiwan nga ang bugang ginagabot kag ginasonog dayon, dan toladan ra ang matatabo sa kataposan ang kalibotan. ");
INSERT INTO clu_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ako nga Naging Tao magapadara akun mga angil agud tiponon kag paalinun sa akun ginarian ang tanan nga nagaimo malain nga nagiging kabangdanan ra nga ang iba magkasala. ");
INSERT INTO clu_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Kag ipilak sanda dayon sa kalayo sa impyirno. Kag doto magaparanangis sanda kag magabaragrut andang mga ipun. ");
INSERT INTO clu_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ang mga matarung tana magasanag nga midyo sa adlaw doto sa anang ginarian andang Tatay. Ta binag-binagun nindo gid indong nabatian nga dia!” ");
INSERT INTO clu_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Anang pagari ang Dios pario ra sa manggad nga ginlubung sa logta nga nadiskobri ang sangka tao. Anang ginimo, gintampukan na ruman. Nalipay tana nga mayad. Gani pagoli na ginbaligya na anang tanan nga pagkabutang kag ginbakal na dayon ang logta nga dato.” ");
INSERT INTO clu_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Anang kaalimbawa anang pagari ang Dios pario ra sa nigosyanti nga nagapangita ang mga pirlas. ");
INSERT INTO clu_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Pagkakita na ang maraalun gid nga pirlas, nagoli tana kag ginbaligya na anang tanan nga pagkabutang kag ginbakal na dayon ang pirlas nga dato.” ");
INSERT INTO clu_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Anang pagari ang Dios pario ra sa lambat nga ginaladlad sa dagat, kag sari-sari nga mga isda ang nabubuul. ");
INSERT INTO clu_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Kon doro ron nga isda sa lambat ginabutung pabaybay. Kag nagaporongko dayon ang mga tao agud piliun ang isda. Ang mayad nga mga isda ginabutang nanda sa mga baskit, piro ang marimo tana ginapamilak nanda. ");
INSERT INTO clu_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Toladan ra ang matatabo sa kataposan ang kalibotan. Ang mga angil maabot digi agud ipabulag ang mga tao nga malain sa mga tao nga mayad. ");
INSERT INTO clu_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Kag ang mga tao nga malain ipilak dayon sa kalayo sa impyirno. Kag magaparanangis sanda kag magabaragrut andang ipun.” ");
INSERT INTO clu_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Nagpamangkot dayon si Jesus kananda, makon na, “Ta naintindian nindo tanan akun ginambal kanindo?” Makon nanda, “Uu.” ");
INSERT INTO clu_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Makon roman ni Jesus, “Gani ang kada manogtodlo nga may natonan parti sa anang pagari ang Dios pario sa tagbalay nga doro anang pagkabutang. Ay bukun lang ang dati nga mga butang anang ginatodlo kondi pati run da ang bago.” ");
INSERT INTO clu_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","54","Pagkatapos nga nakatodlo si Jesus ang mga paanggid nga dia, nagayan tana dayon sa anang banwa. Kag nagtodlo tana ra doto sa anang simbaan ang mga Judio. Ang mga nakabati sa anang mga ginatodlo nagkaratingala. Kag nagparamangkotan sanda, makon nanda, “Diin tana kabay nakabuul anang kinaraman nga dan, kag anang abilidad nga magimo ang mga milagro? ");
INSERT INTO clu_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Kabay anang bata ra lang dan ang panday. Anang nanay kabay si Maria kag anang mga kabogto sanday Santiago, Jose, Simon, kag si Judas? ");
INSERT INTO clu_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Kag anang mga kabogto nga babai digi ra nagaoli. Diin tana kabay kabuul anang abilidad nga dan?” ");
INSERT INTO clu_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Gani indi sanda magpati kanana. Makon ni Jesus kananda, “Ang propita ginataod bisan diin loas lang sa anang kaogalingun nga banwa kag panimalay.” ");
INSERT INTO clu_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Maman dato nga pira lang gid kabilog ang mga milagro nga anang ginimo doto, tungud nga indi sanda magtoo kanana. ");
INSERT INTO clu_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ang mga adlaw nga dato si Herodes nga manogdomara ang Galilea nakabati parti kay Jesus. ");
INSERT INTO clu_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Gani nagkoon tana sa anang mga opisyalis, makon na, “Sigoro dia si Juan nga manogbunyag nga nabanaw. Maman dan nga may gaum tana nga magimo ang mga milagro.” ");
INSERT INTO clu_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Si Juan ginpadakup ni Herodes tungud nga ginkonan na tana nga, “Kontra sa Kasogoan imong pagoroasawa kay Herodias.” Ay si Herodes nga dia anang bayaw mismo ni Herodias, tungud nga asawa tana anang kabogto nga si Felipe. Kag tungud sa anang ginambal nga dato ni Juan, ginpadakup tana ni Herodes kag ginpapriso dayon. ");
INSERT INTO clu_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ipapatay andan ni Herodes si Juan, garing naadlukan tana ra sa mga Judio tungud nga ginakabig nanda si Juan nga propita. ");
INSERT INTO clu_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Pagabot anang komplianyo ni Herodes ang daraga nga bata ni Herodias nagsaot para sa mga bisita nga nagtambong doto kag nalipay gid nga mayad si Herodes. ");
INSERT INTO clu_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Gani makon na, “Sigi, magpangayo kaw kanakun bisan ano kag itaw ko kanimo, kag ginasompa ko dan nga imoon ko.” ");
INSERT INTO clu_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Sa sugiut anang nanay nagsabat ang daraga, makon na, “Itaw mo dadi kanakun anang olo ni Juan nga manogbunyag nga nagabutang sa bandiado.” ");
INSERT INTO clu_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Pagkabati dato ni Aring Herodes naborido tana. Piro tungud nga nakapanompa tana kag nabatian mismo anang mga bisita, ginpaimo na anang ginapangayo ang daraga. ");
INSERT INTO clu_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ginpaotod na anang olo ni Juan doto sa prisoan. ");
INSERT INTO clu_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ginbutang nanda dayon sa bandiado kag gindara sa daraga. Kag gintaw ra dayon ang daraga sa anang nanay. ");
INSERT INTO clu_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Anang lawas tana ni Juan ginbuul anang mga somolonod kag ginlubung nanda dayon. Pagkatapos nagayan sanda kay Jesus kag ginsogid kanana ang natabo kay Juan. ");
INSERT INTO clu_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Pagkabati dato ni Jesus, nagsakay tana sa sakayan kag nagayan sa naligwin nga logar. Piro pagkabati ang mga tao alin sa sari-sari nga mga banwa nga si Jesus nakaalin run, nagbagtas sanda paayan sa anang arayanan. ");
INSERT INTO clu_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Pagsalta ni Jesus, nakita na ang doro gid nga mga tao. Nalooy tana nga mayad kananda, gani ginpangayad na ang mga masakitun nga andang gindara doto. ");
INSERT INTO clu_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Pagkaapon, nagparapit kanana anang mga somolonod. Makon nanda, “Madali run lang masalup ang adlaw, kag ara paman bario nga marapit-rapit digi. Paayana run ang mga tao sa mga bario agud makabakal sanda andang pagkaun.” ");
INSERT INTO clu_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Makon ni Jesus kananda, “Indi kinanglan nga paalinun sanda. Kamo mismo ang magtaw pagkaun kananda.” ");
INSERT INTO clu_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Makon nanda, “Os, lima lang gid kabilog atun tinapay digi kag darwa ka bilog nga isda.” ");
INSERT INTO clu_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Makon ni Jesus kananda, “Abi daraa nindo digi.” ");
INSERT INTO clu_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Kag ginkonan na ang mga tao nga magporongko sa ilamonon. Pagkabuul na ang lima ka bilog nga tinapay kag darwa ka bilog nga isda nagtangra tana sa langit, kag ginpasalamatan na dato sa Dios. Pagkatapos ginpiak-piak na dayon ang tinapay kag gintaw sa anang mga somolonod kag ginpanagtag nanda sa mga tao. ");
INSERT INTO clu_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ang kada isara nakakaun kag nabosog. Kag pagkatapos nga nakakaun run ang tanan, gintipon nanda ang mga nabilin, kag bali dosi ka baskit ang napono. ");
INSERT INTO clu_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ang mga lalaki lang nga nagkaun bali 5,000 nga lagi, poira pa ang mga babai kag mga bata. ");
INSERT INTO clu_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Pagkatapos dato ginsogo ni Jesus anang mga somolonod nga magsakay sa sakayan kag magona doto sa tabok mintras ginapaoli na pa ang mga tao. ");
INSERT INTO clu_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Kag pagkatapos nga makapanaw ang mga tao nagtokad tana sa bokid nga tana lang agud magpangamoyo. Nagabian tana doto. ");
INSERT INTO clu_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Kag sa oras nga dato ang sakayan nga ginasakayan anang mga somolonod doto ron sa tunga ang laod kag ginasampi-sampi nga mayad ang daloyon ay kontra ang angin. ");
INSERT INTO clu_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ang kasanagun run nagayan si Jesus doto kananda nga nagapanaw sa ibabaw ang tobig. ");
INSERT INTO clu_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Pagkakita anang mga somolonod nga may nagapanaw sa ibabaw ang tobig ginadlukan sanda. Kag nagsiringgit sanda, makon nanda, “Morto!” ");
INSERT INTO clu_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Makon nga lagi ni Jesus kananda, “Indi kamo magkaadluk, ako dia!” ");
INSERT INTO clu_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Makon dayon ni Pedro, “Ginoo, abi kon ikaw manda dan, paayana ako dian kanimo nga nagapanaw ra sa ibabaw ang tobig.” ");
INSERT INTO clu_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Makon ni Jesus kanana, “Sigi dali!” Gani naglosong si Pedro sa sakayan kag nagpanaw sa ibabaw ang tobig paayan kay Jesus. ");
INSERT INTO clu_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Piro pagkamarasmas ni Pedro nga mabaskug ang angin, ginadlukan tana kag amat-amat tana nga nagpaidalum. Gani nagsinggit tana, makon na, “Ginoo, tabangi ako!” ");
INSERT INTO clu_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Kag ginkirabot tana ra nga lagi ni Jesus. Pagkatapos, makon na kay Pedro. “Basi nagdoda kaw? Ang kaistan imong pagtoo kanakun.” ");
INSERT INTO clu_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Pagsakay nanda nga darwa sa sakayan golpi nga naglinaw. ");
INSERT INTO clu_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Kag ginsimba tana ang mga tao sa sakayan, makon nanda, “Matood ra gid nga ikaw anang Bata ang Dios.” ");
INSERT INTO clu_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Pagabot nanda sa loyo, nagpondo sanda sa Genesaret. ");
INSERT INTO clu_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Nakilala nga lagi si Jesus ang mga tao doto kag ginpamarita nanda sa palibot nga mga logar nga doto ron si Jesus. Gani ginpangdara ang mga tao ang tanan nga may masakit kanana. ");
INSERT INTO clu_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ginpangabay nanda si Jesus nga kon maimo, togotan na ang mga masakitun nga magtandug kanana, bisan sa anang sidsid run lang anang lambong. Kag ang tanan nga nakatandug nagayad. ");
INSERT INTO clu_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Pagkatapos dato may mga Pariseo kag mga manogtodlo ang Kasogoan alin sa Jerusalem nga nagparapit kay Jesus kag nagpamangkot. ");
INSERT INTO clu_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Makon nanda, “Basi ginasoway imong mga somolonod anang mga soronodon atun mga kaolang-olangan? Ay ara sanda nagapangogas andang alima sono sa nakaogalian bago magkaun.” ");
INSERT INTO clu_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Makon ni Jesus kananda, “kamo tana, basi ginasoway nindo ra anang sogo ang Dios tungud sa indong pagsonod indong mga soronodon nga dan. ");
INSERT INTO clu_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ay makon ang Dios, ‘Taoda imong tatay kag nanay,’ kag ‘Ang nagaambal malain kontra sa anang tatay okon nanay dapat patayun.’ ");
INSERT INTO clu_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Piro kamo tana nagatodlo nga kon ang tao may inogbolig sa anang mga ginikanan ginatogotan nindo nga indi run magbolig kon magkoon tana sa anang mga ginikanan nga, ‘Dia andan akun inogbolig kanindo, garing indi ko ron makataw kanindo ay nakapabulag ko ron para sa Dios.’ ");
INSERT INTO clu_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Maman dan indong paagi agud indi nindo masonod anang ginatodlo ang Dios para masonod nindo indong mga pinalaton-laton nga soronodon. ");
INSERT INTO clu_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mga salimpapaw! Matood ra gid anang koon ang Dios parti kanindo paagi kay Isaias. Makon na, ");
INSERT INTO clu_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Ang mga tao nga dia nagataod kanakun sa baba lang. Piro ang matood tana andang tagiposoon marayu kanakun. ");
INSERT INTO clu_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ara polos andang pagsimba kanakun, ay andang mga ginatodlo mga soronodon nga ginimo-imo lang ang mga tao.’” ");
INSERT INTO clu_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Gintawag ni Jesus ang mga tao nga magparapit kanana. Kag makon na dayon kananda, “Pagpamati kamo kag intindiun nindo akun iambal kanindo. ");
INSERT INTO clu_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ang mga butang nga nagasulud sa anang baba ang tao ara nagapalain kanana, kondi ang mga marimo nga mga ambal nga nagagoa sa anang baba.” ");
INSERT INTO clu_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Lagat-lagat nagparapit kananda anang mga somolonod kag nagkoon, “Ta kaulam ka ra nga nagsakit anang buut ang mga Pariseo sa imong ginambal nga dato?” ");
INSERT INTO clu_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Nagsabat si Jesus, makon na, “Ang kada tanum nga ara pagtanuman akun Tatay nga sa langit sigorado nga gagaboton. ");
INSERT INTO clu_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Pabayani nindo sanda lang. Mga bolag sanda nga manogagobay ang mga bolag. Kag kon ang bolag maman da ang magagobay sa bolag, pario sanda nga maolog sa boo.” ");
INSERT INTO clu_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Makon dayon ni Pedro kay Jesus, “Abi pasanagan kanamun anang kaologan ang paanggid nga dato kaina.” ");
INSERT INTO clu_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Makon ni Jesus kananda, “Pati kamo ara pa ra nakaintindi? ");
INSERT INTO clu_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ara kamo bala kaulam nga ang bisan ano nga nagasulud sa baba nagadiritso sa tian kag sa ori nagagoa dayon sa lawas? ");
INSERT INTO clu_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Piro ang nagagoa tana sa baba sa tagiposoon nagaalin, kag maman ang nagapalain sa tao. ");
INSERT INTO clu_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Tungud nga dian sa anang tagiposoon ang tao nagaalin ang malain nga mga una-una, ang pagpatay, ang pagpanginbabai okon pagpanginlalaki, ang pagolid sa bukun anang asawa, ang pagpanakaw, ang pagtistigo ang botig, kag ang pagambal ang malain kontra sa anang kapario. ");
INSERT INTO clu_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Maman dia ang nagapalain sa tao kag bukun nga kon ara tana kapangogas anang alima bago magkaun.” ");
INSERT INTO clu_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Nagalin si Jesus sa logar nga dato kag nagayan tana sa mga logar nga marapit sa mga siodad ang Tiro kag Sidon. ");
INSERT INTO clu_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Karon may sangka babai nga Canaanun nga nagaoli sa logar nga dato. Nagayan tana kay Jesus nga nagapakitloy. Makon na, “Ginoo, ikaw nga manogpanobli anang ginarian ni David, abi kaloyi ako ra! Akun bata nga babai ginsuludan ang malain nga ispirito kag sugung anang pamati.” ");
INSERT INTO clu_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Piro ara nagsapak si Jesus. Anang mga somolonod nagparapit kanana kag magkoon, “Paalina ang babai nga dan, way sigi anang sonod kanatun kag nagalingaw!” ");
INSERT INTO clu_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Gani makon dayon ni Jesus, “Ako ginpadara digi agud pangitaun kag boligan ang mga Israelita nga pario sa mga karniro nga nagkaradora.” ");
INSERT INTO clu_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Piro nagparapit pa gid ang babai kay Jesus kag naglood kanana nga nagakoon, makon, “Ginoo, boligi ako ra!” ");
INSERT INTO clu_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Makon ni Jesus kanana, “Bukun mayad nga bulun anang pagkaun ang mga bata kag itaw sa mga ayam.” (Naulaman ang babai kon ano anang gostong ambalun ni Jesus, nga boligan na anay ang mga Judio kag bago garing ang bukun Judio.) ");
INSERT INTO clu_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Gani makon ang babai, “Tama dan Ginoo, piro bisan ang mga ayam nagakaun ra ang mga pagkaun nga nagakaraolog sa lamisa andang agalun.” ");
INSERT INTO clu_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Makon dayon ni Jesus kanana, “Ang kabaul imong pagtoo! Gani mababaton mo imong ginapangayo kanakun.” Kag dato nga lagi nagayad anang bata. ");
INSERT INTO clu_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Nagalin doto si Jesus kag nagobay sa baybay ang Dagat ang Galilea. Ang ori nagtokad tana sa bokid kag nagpongko doto. ");
INSERT INTO clu_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Doro nga mga tao ang nagarayan doto kanana. Gindara nanda ang mga piang, ang mga pingkaw, ang mga bolag, ang mga apa kag doro pa gid nga masakitun. Ginpamutang nanda lang sa sikian ni Jesus kag ginpangayad na sanda tanan. ");
INSERT INTO clu_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Natingala nga mayad ang mga tao ay nakita nanda nga ang mga apa nakaaambal run, mayad run anang alima ang mga pingkaw, ang mga piang nakapapanaw ron kag ang mga bolag nakakikita run. Kag gindayaw nanda ang Dios nga ginasimba anang mga kaapo-apoan ni Isreal. ");
INSERT INTO clu_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Gintawag ni Jesus anang mga somolonod kag magkoon kananda, “Nalooy ako sa mga tao nga dia, ay tatlo ron dia ka adlaw nga nagkaiban sanda kanakun kag ara sanda run may makaun. Indi ko gosto nga paoliun sanda nga ara kakaun ay basi kon doplayun sanda sa dalan.” ");
INSERT INTO clu_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Makon anang mga somolonod kanana. “Ta sa diin kita mabuul digi sa naligwin nga logar ang pagkaun nga magaigo sa karaku nga dia nga mga tao?” ");
INSERT INTO clu_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Nagpamangkot kananda si Jesus, makon na, “Pira ka bilog indong tinapay dian?” Makon nanda, “Pito ka bilog nga tinapay kag pira lang gid ka bilog nga isda nga mairintuk.” ");
INSERT INTO clu_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Makon dayon ni Jesus sa mga tao, “Abi pagporongko kamo sa logta.” ");
INSERT INTO clu_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Kag ginbuul na dayon ang pito ka bilog nga tinapay kag ang mga isda kag nagpasalamat sa Dios. Pagkatapos, ginpamisang-pisang na dato kag gintaw sa anang mga somolonod. Kag anang mga somolonod ang nagpanagtag sa mga tao. ");
INSERT INTO clu_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Tanan sanda nakakaun kag nabosog. Pagkatapos ginpanipon nanda ang tinapay nga sobra, kag nakapono sanda pito ka baskit. ");
INSERT INTO clu_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Mga 4,000 ka lalaki ang nakakaun poira pa ang mga babai kag mga bata. ");
INSERT INTO clu_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Pagkatapos dato ginpaoli dayon ni Jesus ang mga tao. Tana tana nagsakay sa sakayan kag magtabok sa logar ang Magadan. ");
INSERT INTO clu_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","May mga Pariseo kag mga Saduseo nga nagayan kay Jesus agud tirawan tana. Makon nanda, “Kon ikaw ginpadara manda ang Dios, abi pagimo ang milagro alin sa Dios.” ");
INSERT INTO clu_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Makon ni Jesus kananda, “Kon nagainalup ang adlaw kag ang langit mapola, nagakoon kamo nga ‘Mayad ang tyimpo aruman.’ ");
INSERT INTO clu_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Kag kon aga pa kag ang langit mapola kag magalum, nagakoon kamo nga ‘Maoran dia dadi.’ Kon magsulung kamo sa langit naulaman nindo kon magainit okon magaoran, piro sa mga tyimpo tana nga dia indi kamo makaintindi ang mga tanda sa mga nagakaratabo. ");
INSERT INTO clu_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kamo nga mga tao sa dadi, masyado kamo kalain kag bukun matutum sa pagsonod sa Dios. Nagapangayo kamo milagro, piro ara iba nga milagro akun ipakita kanindo kondi ang milagro nga natabo kay Jonas.” Kag nagalin tana dayon. ");
INSERT INTO clu_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Nagtabok sanday Jesus sa loyo, piro anang mga somolonod nalipat magbalon ang pagkaun. ");
INSERT INTO clu_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Makon ni Jesus kananda, “Magandam kamo nga mayad sa anang pampaabok ang mga Pariseo kag mga Saduseo.” ");
INSERT INTO clu_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Pagkabati dato anang mga somolonod, makon nanda, “Sigoro ginambal na dia tungud nga ara kita nakadara ang tinapay.” ");
INSERT INTO clu_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Piro naulaman ni Jesus kon ano andang ginaisip. Gani makon na kananda, “Basi nagabarais-baisan kamo? Kon ara kamo dara nga tinapay maiwan gid? Ara kamo pa gid pagsarig kanakun ay? ");
INSERT INTO clu_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ara nindo pa gid bala naintindii nga indi kita dapat magpalibug parti sa tinapay? Ara nindo bala nadumdumi ang lima ka bilog nga tinapay nga akun ginpamiakpiak agud makakaun ang 5,000 ka tao? Nalipatan nindo ron bala kon pira ka baskit indong napono sa mga nabilin nga tinapay? ");
INSERT INTO clu_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ara nindo ra bala nadumdumi nga sa pito ka bilog nga tinapay ginpakaun ko ang 4,000, kag pira pa ka baskit ang sobra? ");
INSERT INTO clu_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ara kamo bala kaintindi nga bukun tinapay akun gostong ambalun pagkoon ko nga ‘Magandam kamo sa anang pampaabok ang mga Pariseo kag mga Saduseo?’” ");
INSERT INTO clu_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Kag bago nanda pa naulaman nga bukun gali ang pampaabok nga ginagamit sa tinapay andang dapat likawan kondi anang panodlo ang mga Pariseo kag mga Saduseo. ");
INSERT INTO clu_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Karon, ang doto ron sanday Jesus sa logar ang Cesarea sa Filipos nagpamangkot tana sa anang mga somolonod, makon na, “Sino Ako nga Naging Tao sono sa anang pagkakilala ang mga tao?” ");
INSERT INTO clu_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Makon nanda, “May mga nagakoon nga ikaw si Juan nga manogbunyag. Ang iba nagakoon nga ikaw si Elias. Kag may iba pa gid nga nagakoon nga ikaw si Jeremias, kag kon bukun, basta isara sa mga propita.” ");
INSERT INTO clu_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Makon ni Jesus kananda, “Piro para kanindo, sino ako?” ");
INSERT INTO clu_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Nagsabat si Pedro, makon na, “Ikaw ang Cristo nga anang ginpangako ang Dios nga magari, anang Bata ang Dios nga boi!” ");
INSERT INTO clu_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Makon ni Jesus kanana, “Simon nga bata ni Jonas, masoirti kaw, tungud nga dia nga butang bukun tao ang nagsogid kanimo kondi akun Tatay nga sa langit. ");
INSERT INTO clu_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ikaw ginatawag ko nga Pedro nga kon sayodon bato. Kag sa ibabaw ang pondasyon nga dia nga bato patindugun ko ang mga tao nga magatoo kanakun kag bisan anang gaum ang kamatayun indi makadaug kananda. ");
INSERT INTO clu_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Kanimo ko itaw ang awtoridad sa anang ginarian ang Dios. Ang bisan ano nga imong itogot nga imoon digi sa kalibotan maman ra ang itogot ang Dios, kag ang bisan ano nga indi mo pagitogot maman ra ang indi pagitogot ang Dios.” ");
INSERT INTO clu_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Pagkatapos ginbilinan dayon ni Jesus anang mga somolonod nga indi sanda gid magsogid bisan kino nga tana ang Cristo. ");
INSERT INTO clu_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Alin dato ginsaysay ni Jesus sa anang mga somolonod kon ano ang matatabo kanana. Makon na, “Kinanglan gid nga ako magayan sa Jerusalem. Doto magaantos ako nga mayad sa anang imoon kanakun anang mga manogdomara ang mga Judio, ang mga monogdomara nga pari, kag ang mga manogtodlo ang Kasogoan. Papatayun nanda ako, piro sa ikatlo ka adlaw mababanaw ako.” ");
INSERT INTO clu_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pagkakoon na dato gindara tana ni Pedro sa marayu-rayu kag sawayun; makon na, “Iparayu lang imong ginambal nga dan. Indi pagitogot ang Dios nga matabo dan kanimo.” ");
INSERT INTO clu_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Nagliso si Jesus kag nagkoon kanana, “Parayu kaw kanakun Satanas. Ginapamalabagan mo ako nga magimo anang kabubutun ang Dios tungud nga imong naisipan nga dan bukun anang gosto ang Dios kondi maman dan anang gosto ang tao!” ");
INSERT INTO clu_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Makon dayon ni Jesus sa anang mga somolonod, “Kon may tao nga gosto magsonod kanakun, indi na run dapat pagisipun anang kaogalingun, kondi kinanglan magtoman kanakun abir kon kamatayun anang aboton sa pagsonod kanakun. ");
INSERT INTO clu_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ay ang bisan sino nga nagakanogon anang kaboi digi sa kalibotan nga dia mapapatay pa ra gid. Piro ang bisan sino nga priparado nga mapatay tungud kanakun makakaangkun ang kaboi nga ara kataposan. ");
INSERT INTO clu_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ano gid anang mabubuul ang tao kon maangkun na ang tanan nga butang digi sa kalibotan, piro madora ra lang anang kaboi? Ara gid! Ay ara gid pagkabutang nga sarang na nga itaw agud mabawi na ruman anang kaboi. ");
INSERT INTO clu_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ay Ako nga Naging Tao magabalik digi sa kalibotan nga nagalanyag sa anang gaum akun Tatay, kag kaiban ko ra anang mga angil. Kag balusan ko dayon ang tanan nga tao sono sa andang mga inimoan. ");
INSERT INTO clu_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Sa matood tana, may mga tao digi dadi nga indi mapatay mintras indi nanda makita Ako nga Naging Tao nga nagabalik digi bilang Ari.” ");
INSERT INTO clu_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Pagkalubas ang anum ka adlaw gindara ni Jesus si Pedro kag ang magkabogto nga si Santiago kag si Juan sa mataas nga bokid. Sanda-sanda lang gid ang nagayan doto. ");
INSERT INTO clu_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ang doto sanda run, mintras nagasulung sanda kay Jesus, nagiba anang itsora. Anang oyaun nagsanag nga midyo ron sa adlaw, kag anang lambong nagpoti nga nagasirak. ");
INSERT INTO clu_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Kag golpi lang nga nakita nanda ra si Moises kag si Elias nga nagpakigsogidanun kanana. ");
INSERT INTO clu_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Makon dayon ni Pedro kay Jesus, “Ginoo, mayad digi kami. Kon maliag kaw, maimo ako digi tatlo ka kamalig, ang sakabilog kanimo, ang sakabilog kay Moises, kag ang sakabilog kay Elias.” ");
INSERT INTO clu_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ara tana pa katapos anang ambal nga dato ginlikupan sanda ang panganod nga masilaw kag nabatian nanda dayon ang limug nga alin sa panganod nga nagakoon, “Maman dia akun pinalangga nga Bata. Nalilipay ako nga mayad kanana. Pamatian nindo tana!” ");
INSERT INTO clu_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Pagkabati dato nanday Pedro nagdapa sanda sa sugung nga kaadluk. ");
INSERT INTO clu_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ginrapitan sanda ni Jesus kag gintandug nga nagakoon, “Bangon kamo! Indi kamo magkaadluk!” ");
INSERT INTO clu_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Pagsulung nanda ara sanda ibang nakita doto kondi si Jesus run lang. ");
INSERT INTO clu_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ang nagalusub sanda run sa bokid, ginkonan sanda ni Jesus, makon na, “Indi kamo gid magsogid bisan kino parti sa indong nakita mintras Ako nga Naging Tao ara pa mabanaw.” ");
INSERT INTO clu_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Pagkatapos nagpamangkot kanana anang mga somolonod, makon nanda, “Basi kabay nagakoon ang mga manogtodlo ang Kasogoan nga kinanglan magabot anay si Elias bago magabot ang Cristo?” ");
INSERT INTO clu_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Makon ni Jesus kananda, “Pario anang koon ang Kasolatan maabot ra gani si Elias agud ipriparar ang tanan nga butang. ");
INSERT INTO clu_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Piro sogidan ko kamo, si Elias nakaabot ron. Garing ara tana lang bala nakilala ang mga tao kag ginimo nanda andang gosto nga imoon kanana. Kag maman ra dan andang imoon Kanakun nga Naging Tao. Paantoson nanda ako ra.” ");
INSERT INTO clu_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Kag bago pa naangupan anang mga somolonod nga si Juan nga manogbunyag maman anang ginatomod. ");
INSERT INTO clu_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Pagabot nanda doto sa dorong tao may sangka lalaki nga nagparapit kay Jesus kag naglood nga nagakoon, makon na, ");
INSERT INTO clu_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Ginoo, abi kaloyi ra akun bata nga lalaki. Koyapun tana kag kon aboton gani sugung gid anang pamati. Pirmi tana gid nga natotomba sa kalayo kag pirmi ra nga naoolog sa tobig. ");
INSERT INTO clu_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Gindara ko tana sa imong mga somolonod, piro indi sanda makapaayad.” ");
INSERT INTO clu_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Makon dayon ni Jesus, “Kamo nga mga tao sa tyimpo nga dia, ara kamo gid pagtoo, kag baliskad indong ginaisip kag ginaimo. Asta sano pa akun pagantos kanindo? Dara nindo digi kanakun ang bata!” ");
INSERT INTO clu_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Kag ginsaway dayon ni Jesus ang malain nga ispirito doto sa bata kag naggoa ra nga lagi. Kag sa oras nga dato nagayad ang bata. ");
INSERT INTO clu_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ang sanda-sanda run lang nagparapit kay Jesus anang mga somolonod kag nagpamangkot, makon nanda, “Basi kabay indi namun mapagoa ang malain nga ispirito nga dato sa bata?” ");
INSERT INTO clu_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Makon ni Jesus kananda, “Tungud nga kolang indong pagtoo. Sa matood tana, kon kamo may pagtoo nga bisan pario lang sa anang bosol ang mostasa anang kabaul, sarang kamo ron makakoon sa bokid nga dia nga magsaylo sa sangka logar, kag dan magasaylo. Ara gid butang nga indi nindo maimo.”  ");
INSERT INTO clu_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Garing ang toladato nga klasi nga malain nga ispirito indi nindo basta mapagoa kon indi kamo magpangamoyo kag magpoasa. ");
INSERT INTO clu_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Pagtiripon anang mga somolonod doto sa Galilea, makon ni Jesus kananda, “Ako nga Naging Tao kinanglan nga iintriga sa mga tao ");
INSERT INTO clu_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","nga magapatay kanakun. Piro sa ikatlo ka adlaw mababanaw ako.” Naborido gid anang mga somolonod. ");
INSERT INTO clu_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Pagabot nanday Jesus sa Capernaum, si Pedro ginparapitan ang mga manogsokot ang bois para sa timplo kag ginpamangkot. Makon nanda, “Nagabayad ra indong manogtodlo ang bois para sa timplo?” ");
INSERT INTO clu_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Makon ni Pedro kanana, “Uu, nagabayad tana.” Pagsulud ni Pedro sa balay ginpamangkot tana nga lagi ni Jesus. Makon na, “Simon, kon sa kanimo abi, sino anang ginapabayad ang mga ari digi sa kalibotan ang bois, andang mga bata okon iba?” ");
INSERT INTO clu_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Makon anang sabat ni Pedro, “Syimpri ang iba.” Makon ni Jesus, “Kon toladato nagakaologan nga andang mga bata indi gani kinanglan nga magbayad. ");
INSERT INTO clu_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Garing kon indi kita magbayad basi kon maglain andang buut kanatun, gani magayan kaw sa dagat kag magpamonit dayon. Ang ona nga isda nga imong madawi bosik-sikun mo anang baba kag makikita mo doto ang koarta nga bastanti run nga ibayad para sa atun bois nga darwa. Bulun mo kag ibayad dayon sa mga nagasokot ang bois para sa timplo.” ");
INSERT INTO clu_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Sa oras nga dato nagparapit kay Jesus anang mga somolonod kag nagpamangkot, makon nanda, “Sino gid kabay ang labaw sa tanan sa anang Ginarian ang Dios?” ");
INSERT INTO clu_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Anang ginimo ni Jesus gintawag na ang bata nga maistan kag ginpatindug na sa andang tunga. ");
INSERT INTO clu_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Makon na dayon kananda, “Sa matood tana, kon kamo indi magbago kag maging pario sa mairintuk nga mga bata, indi kamo gid mapabilang sa mga tao nga anang ginaarian ang Dios. ");
INSERT INTO clu_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ay ang tao nga nagapaubus pario sa bata nga dia, maman ang ginabilang nga pinakalabaw sa anang Ginarian ang Dios. ");
INSERT INTO clu_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Kag ang bisan sino nga tungud sa anang pagtoo kanakun nagabaton kag nagaasikaso sa bata nga toladia nagabaton ra kanakun.” ");
INSERT INTO clu_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Piro ang bisan sino nga maging kabangdanan nga ang mga bata nga dia magbaya sa andang pagtoo kanakun mas mayad pa nga igotan anang liug kag itagkus dayon sa galingan nga bato kag ipandag sa laod. ");
INSERT INTO clu_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kailo ra ang mga tao digi sa kalibotan ay ang pagsolay pirmi gid nga nagaabot kananda. Kon sa bagay dia nga mga butang matatabo gid man. Piro kailo gid ang tao nga nagasolay sa anang kapario. ");
INSERT INTO clu_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Kon imong alima okon siki ang maging kabangdanan nga ikaw magbaya kanakun, otoda run lang kag ipilak! Mas mayad pa nga sakabilog lang imong alima okon siki kag may kaboi kaw nga ara kataposan kaysa komplito imong alima kag siki piro ipilak ka ra lang sa kalayo nga ara kataposan. ");
INSERT INTO clu_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Kag kon imong mata maging kabangdanan nga ikaw magbaya kanakun, lukada kag ipilak! Ay mas mayad pa nga sakabilog lang imong mata kag may kaboi kaw nga ara kataposan kaysa komplito imong mata piro ipilak ka ra lang sa kalayo sa impyirno.” ");
INSERT INTO clu_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Magandam kamo nga indi nindo gid pagtamayun bisan ang sakabilog sa mairintuk nga dia nga mga bata. Ay sa matood tana anang mga angil ang Dios nga nagabantay kananda pirmi doto sa akun Tatay nga sa langit.  ");
INSERT INTO clu_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ay Ako nga Naging Tao nagayan digi sa kalibotan agud lowasun ang mga tao nga nagkaradora tungud sa andang mga sala. ");
INSERT INTO clu_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Kon may tao nga may 100 ka karniro kag nadora ang sakabilog, ano kabay anang imoon? Sigorado gid nga bayaan na ang 99 nga nagaparangarab sa mga bokid-bokid kag pangitaun na ang karniro nga nadora. ");
INSERT INTO clu_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Kag kon anang makita malilipay tana nga mayad. Sa matood tana mas malilipay tana sa sakabilog nga dato nga nadora nga anang nakita kaysa 99 nga ara nadora. ");
INSERT INTO clu_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Toladan ra anang nababatyagan indong Tatay nga sa langit. Indi na gid gosto nga madora ang bisan sangka bata nga maistan.” ");
INSERT INTO clu_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Kon imong kapario nga tomoloo magkasala kanimo, ayanan mo tana kag sogidan mo dayon anang ginimo nga sala. Piro dia imoon mo nga kamo-kamo lang. Kon tana magpakigosay kanimo, ta kondi magaayadan kamo roman, kag mapabalik mo tana sa Dios. ");
INSERT INTO clu_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Piro kon indi tana magpakigosay kanimo, magdara kaw sangka tomoloo pa gid okon darwa man agud masonod mo ang sono sa nakasolat sa Kasolatan nga ang mga butang nga indong ambalan mapamatodan ang darwa okon tatlo ka tao. ");
INSERT INTO clu_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Piro kon indi tana pa gid magpamati kananda isogid sa tanan nga mga tomoloo sa andang ginatiriponan. Kag kon indi tana pa gid magpamati kananda, ayaw nindo tana run pagsapaka kondi ibilang nindo tana run lang nga pario sa mga tao nga ara nagakilala sa Dios okon pario sa mga manogsokot ang bois nga nagapandaya kag mga traidor.” ");
INSERT INTO clu_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Ang bisan ano nga indong itogot digi sa kalibotan maman ra ang itogot ang Dios, kag ang bisan ano nga indi nindo pagitogot maman ra ang indi pagitogot ang Dios. ");
INSERT INTO clu_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Kag gosto ko ra nga maulaman nindo dia, nga kon ang darwa kanindo digi sa kalibotan magkasogot parti sa bisan ano nga indong pangayoon sa pangamoyo, dan imoon kanindo akun Tatay nga sa langit. ");
INSERT INTO clu_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ay kon diin ang darwa okon tatlo nga nagatiripon tungud kanakun, ako kaiban nanda ra.” ");
INSERT INTO clu_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Nagparapit si Pedro kay Jesus kag magpamangkot, makon na, “Ginoo, kon akun kapario nga tomoloo pirmi nga nagakasala kanakun, kapira ko gid tana dapat patawadun? Pito ka bisis?” ");
INSERT INTO clu_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Makon ni Jesus kanana, “Bukun lang asta sa ikapito ka bisis, kondi asta sa 77 ka bisis. ");
INSERT INTO clu_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ay anang pagari ang Dios pario sa natabo sa sangka ari nga nagaosisa ang mga otang kanana anang mga sorogoon. ");
INSERT INTO clu_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Mintras nagaosisa tana andang mga otang, may gindara kanana nga sorogoon nga anang otang minilyon. ");
INSERT INTO clu_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Kag tungud nga indi tana run makabayad nagsogo ang ari nga ibaligya tana bilang oripun pati anang asawa kag anang mga bata. Kag ibaligya ra ang tanan na nga pagkabutang agud mabayadan na anang otang. ");
INSERT INTO clu_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Anang ginimo ang sorogoon nga dato, naglood tana sa ari kag magpakitloy, makon na, ‘Pasinsyaa ako lang anay dadi, ay bayadan ko ra dan kanimo tanan!’ ");
INSERT INTO clu_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Kag nalooy ang ari kanana, gani ginpatawad na tana kag ara tana run pagpabayada anang otang, kondi ginpaoli run lang. ");
INSERT INTO clu_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Pagoli ang tao nga dato nasoblang na anang kapario nga sorogoon nga may otang kanana nga maistan lang gid. Gindakup na ang sorogoon nga dato nga may otang kanana kag ginkuga na dayon nga nagakoon, ‘Bayadi ako ron imong otang kanakun!’ ");
INSERT INTO clu_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Kag naglood kanana anang kapario nga dato nga sorogoon nga nagapakitloy, makon na, ‘Pasinsyaa ako lang anay dadi, ay bayadan ko ra dan kanimo!’ ");
INSERT INTO clu_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Piro indi tana gid magpasogot. Anang ginimo tana, ginpapriso na ang sorogoon nga dato nga may otang asta makabayad. ");
INSERT INTO clu_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Pagkakita dato ang iba pa gid nga mga sorogoon naglain andang buut, gani ginayanan nanda andang agalun nga ari kag ginsogidan parti sa natabo nga dato. ");
INSERT INTO clu_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ginpatawag ang ari anang sorogoon nga dato kag magkoon, ‘Masyado kaw kalain nga sorogoon. Kabay ginpatawad ta kaw sa imong otang kanakun tungud nga nagpakitloy kaw kanakun. ");
INSERT INTO clu_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ta basi ara mo pagkaloyi imong kapario nga sorogoon pario akun pagkalooy kanimo?’ ");
INSERT INTO clu_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Doro gid anang kasilag ang ari kanana. Ginpapriso na tana kag ginpasilotan asta mabayadan na tanan anang otang kanana.” ");
INSERT INTO clu_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Makon dayon ni Jesus kananda, “Dan toladan ra anang imoon akun Tatay nga sa langit sa kada isara kanindo kon kamo indi magpatawad sa indong kapario ang tuduk gid sa indong tagiposoon.” ");
INSERT INTO clu_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Pagkatapos nga si Jesus nakatodlo ang mga butang nga dato, nagalin tana sa Galilea kag nagayan sa mga logar nga sakup ang Judea sa tabok ang Soba ang Jordan. ");
INSERT INTO clu_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Dorong mga tao ang nagsonod kanana, kag ginpangayad na sanda sa andang mga masakit. ");
INSERT INTO clu_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Karon, may mga Pariseo nga nagayan ra doto kanana. Gosto nanda nga magpangita paagi agud maiakosar nanda tana. Nagpamangkot sanda kay Jesus, makon nanda, “Nagatogot bala ang Kasogoan nga bulagan ang lalaki anang asawa sa bisan ano nga kabangdanan?” ");
INSERT INTO clu_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Nagsabat si Jesus, makon na, “Ara kamo gid bala kabasa sa Kasolatan nga pagimo ang Dios ang tao ginimo na sanda nga lalaki kag babai? ");
INSERT INTO clu_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Kag pagkatapos makon na, ‘Maman dan nga bayaan ang lalaki anang tatay kag nanay kag magdapun tana dayon sa anang asawa, kag sanda nga darwa maging isara run lang.’ ");
INSERT INTO clu_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Gani bukun sanda run darwa kondi isara. Kon maman dan, ta kondi indi dapat bulagun ang tao ang gindapun ang Dios.” ");
INSERT INTO clu_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Makon roman ang mga Pariseo kanana, “Ta basi nagakoon si Moises nga poidi nga bulagan ang lalaki anang asawa, basta tawan na lang tana ang kasolatan nga sa pagkamatood bulag sanda run?” ");
INSERT INTO clu_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Makon ni Jesus kananda, “Gintogotan kamo ni Moises nga bulagan indong asawa tungud nga matugas indong olo. Piro bukun toladan anang plano ang Dios alin pa ang ompisa. ");
INSERT INTO clu_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Maman dan nga nagakoon ako kanindo nga kon ang lalaki magbulag sa anang asawa nga ara ra nagpanginlalaki, pagkatapos magpangasawa tana ang iba, nagapanginbabai tana. Kag ang magpangasawa sa babai nga ginbulagan nagakasala ra sa pagpanginbabai.” ");
INSERT INTO clu_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Makon dayon anang mga somolonod ni Jesus, “Kon toladia gali ang may asawa, mayad pa indi run lang magpangasawa.” ");
INSERT INTO clu_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Makon anang sabat ni Jesus, “Indi dan mabaton ang tanan loas sa mga tao nga maman dato anang bugna ang Dios kananda. ");
INSERT INTO clu_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","May sari-sari nga kabangdanan kon basi may mga lalaki nga indi makaasawa; ang iba natao nga indi makaasawa; ang iba indi makaasawa tungud nga ginkapon sanda; kag ang iba pa gid indi magpangasawa tungud sa andang pagpanikasug para sa anang ginarian ang Dios. Ta, ang makaimo dia nga indi mag- pangasawa, indi magpangasawa.” ");
INSERT INTO clu_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Karon, may mga tao nga nagdara ang mga bata nga mairintuk kay Jesus agud tongtongan anang alima kag ipangamoyo. Piro ginsaway sanda anang mga somolonod ni Jesus. ");
INSERT INTO clu_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Garing makon ni Jesus kananda, “Pabayani nindo lang ang mga bata nga magparapit digi kanakun. Indi nindo sanda pagbawali, ay kabilang sa anang ginarian ang Dios ang mga pario kananda.” ");
INSERT INTO clu_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Kag gintongtong dayon ni Jesus anang alima sa mga bata kag ginbindisyonan na sanda. Kag pagkatapos dato nagpanaw tana dayon. ");
INSERT INTO clu_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","May sangka tao nga nagparapit kay Jesus kag nagpamangkot, makon na, “Maistro, ano kabay ang mayad nga dapat ko nga imoon agud makabaton ako ang kaboi nga ara kataposan?” ");
INSERT INTO clu_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Makon ni Jesus kanana, “Basi nagpamangkot kaw kanakun kon ano ang mayad? Sakabilog lang ang mayad, kag dan ara iba kondi ang Dios. Kon gosto mo nga makabaton kaw ang kaboi nga ara kataposan tomanun mo anang mga sogo.” ");
INSERT INTO clu_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Nagpamangkot ruman ang tao nga dato, makon na, “Ano nga mga sogo?” Makon ni Jesus kanana, “Indi kaw magpatay, indi kaw magpanginbabai okon magpanginlalaki, indi kaw magpanakaw, indi kaw magtistigos ang botig, ");
INSERT INTO clu_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","taodon mo imong tatay kag imong nanay, kag igogmaun mo imong kapario pario imong pagigogma imong kaogalingun.” ");
INSERT INTO clu_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Makon ang lalaki nga dato nga bataun pa, “Ang tanan nga dan natoman ko ron. Ta ano pa ang kolang kanakun?” ");
INSERT INTO clu_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Makon ni Jesus kanana. “Ta kon gosto mo nga ara kaw ron gid kakolangan sa panulung ang Dios, pagoli kag ibaligya mo imong mga pagkabutang, kag anang bayad ipanagtag mo dayon sa mga pobri. Sa toladia nga paagi magamanggaranun kaw doto sa langit. Pagkatapos, magbalik kaw kag magsonod kanakun.” ");
INSERT INTO clu_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Pagkabati ang lalaki nga dato nagalin tana nga masubu ay doro anang manggad. ");
INSERT INTO clu_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Gani makon ni Jesus sa anang mga somolonod, “Sa matood tana, mabudlay para sa manggaranun nga tao ang magpasakup sa anang pagari ang Dios. ");
INSERT INTO clu_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Mas maulas pa gani nga magagi ang sapat nga kamilyo sa anang boo ang dagum kaysa magpasakup ang manggaranun sa anang pagari ang Dios.” ");
INSERT INTO clu_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Pagkabati dato anang mga somolonod, natingala sanda nga mayad. Gani nagpamangkot sanda, makon, “Ta kon toladan, sino ron lang kabay ang malowas?” ");
INSERT INTO clu_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ginsulung sanda ni Jesus kag magkoon, “Kon sa mga tao lang indi gid maimo, piro sa Dios tana ang tanan nga butang sarang maimo.” ");
INSERT INTO clu_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Makon dayon ni Pedro kanana, “Ta kami, ginbayaan namun ang tanan kag nagsonod kanimo. Ta ano amun mabubuul nga balus?” ");
INSERT INTO clu_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Makon ni Jesus kananda, “Sa matood tana, magaabot ang adlaw nga bagoon ang Dios ang kalibotan nga dia, kag Ako nga Naging Tao magapongko sa akun trono agud magari. Sa adlaw nga dato, kamo nga nagsonod kanakun magapongko sa dosi ka trono agud ukuman nindo anang dosi ka tribo ang Israel. ");
INSERT INTO clu_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Kag ang bisan sino nga nagbaya anang balay, anang mga kabogto, anang tatay, anang nanay, anang mga bata, okon anang mga logta tungud kanakun sigorado nga mas doro pa gid anang babatonon nga balus, kag tawan pa kaboi nga ara kataposan. ");
INSERT INTO clu_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Doro nga mga tao nga ginakilala nga importanti dadi ang magagoa nga bukun, kag doro ang ara ginasapaka dadi ang magagoa nga importanti.” ");
INSERT INTO clu_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Makon ni Jesus kananda, “Anang pagari ang Dios pario sa tao nga may asinda. Aga tana pa gid nagpanaw kag nagpangita ang mga tao nga maobra sa anang logta nga may mga tanum nga obas. ");
INSERT INTO clu_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Nagkarasogot sanda ang mga tao nga ona na nga nagkarakita, nga andang sool sono ra sa inadlaw ang mga tao doto sa logar nga dato. Kag ginpadara na sanda dayon doto sa anang kaobasan. ");
INSERT INTO clu_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Datong mga alas noibi run ang adlaw nagayan tana sa may mga tindaan kag may mga nakita tana doto nga mga tao nga nagairistambay ay ara sanda obra. ");
INSERT INTO clu_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Makon na kananda, ‘Pagobra kamo doto sa akun kaobasan, ay soolan ta kamo ang osto.’ ");
INSERT INTO clu_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Gani nagayan sanda doto kag nagobra. Pagabot ang ogtong adlaw nagbalik ruman ang asindiro sa may mga tindaan, kag may mga tao tana ruman nga nakita kag anang ginpaobra. Kag maman ra anang ginimo pagabot ang mga alas tris ang apon. ");
INSERT INTO clu_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Pagabot ang alas singko nagbalik tana ruman sa may mga tindaan kag may nakita tana pa gid nga mga tao nga nagaistambay. Makon na kananda, ‘Ay dan basi nagistambay kamo lang digi sa bilog nga adlaw?’ ");
INSERT INTO clu_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Makon nanda nga nagsabat, ‘Ta maiwan kami, ay ara may nagapaobra kanamun.’ Gani ginkonan na sanda nga magayan doto sa anang kaobasan kag magobra. ");
INSERT INTO clu_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Pagsirum, makon ang asindiro sa anang kapatas, ‘Ta tawaga run ang mga nagaorobra kag soolan. Onaun mo bayad ang naori gid magobra kag pasonod asta sa mga naona magobra.’ ");
INSERT INTO clu_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ang mga nagsulud sa obra ang mga alas singko ron gintawan andang sool para sa sangadlaw nga obra. ");
INSERT INTO clu_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Pagabot nga soolan run ang mga aga pa gid magobra nagaisip sanda nga mabaul andang mababaton kaysa mga tao nga naori magobra. Piro ang kada isara kananda ginsoolan ra ang para sa sangadlaw nga obra. ");
INSERT INTO clu_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Pagkabaton nanda dato, nagriklamo sanda sa asindiro. ");
INSERT INTO clu_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Makon nanda, ‘Ang mga naori sangka oras lang andang obra, piro kami tana sangadlaw gid amun paolas kag painit, pagkatapos pario ra lang imong sool kanamun!’ ");
INSERT INTO clu_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Makon na sa isara kananda, ‘Amigo, ara ta kaw pagdayaa. Kabay nagkasogot kita nga soolan ta kaw ang para sa sangadlaw. ");
INSERT INTO clu_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Batona lang ang kantidad nga para sa imong inobraan kag magoli. Ay gosto ko tana nga soolan ang naori nga dia magobra pario ra akun ginataw kanimo. ");
INSERT INTO clu_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Pagosto ako kabay kon ano akun imoon sa akun koarta ay akun. Basi kon nainggit kaw lang tungud nga mayad ako kananda?’” ");
INSERT INTO clu_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Makon dayon ni Jesus, “Dan toladan ra sa oring mga adlaw. Ang mga ara ginasapaka dadi maman ang magagoa nga importanti, kag ang mga tao nga ginakilala nga importanti dadi ang magagoa nga bukun importanti.” ");
INSERT INTO clu_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ang sanday Jesus nagapaayan run sa Jerusalem, ginpabulag na anang mga somolonod sa mga tao ay may inogsogid tana kananda. ");
INSERT INTO clu_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Makon na, “Dia kita nagapaayan run sa Jerusalem. Pagabot ta doto Ako nga Naging Tao iintriga sa mga manogdomara nga mga pari kag mga manogtodlo ang Kasogoan, kag sisintinsyaan nanda ako nga patayun. ");
INSERT INTO clu_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Iintriga nanda ako dayon sa mga bukun Judio agud yagotaun nanda ako, anoton, kag pagkatapos ilansang dayon sa kros. Piro sa ikatlo ka adlaw mababanaw ako.” ");
INSERT INTO clu_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Nagparapit kay Jesus anang asawa ni Zebedeo kaiban anang darwa ka bata nga lalaki. Naglood tana kay Jesus ay may ginapangabay tana. ");
INSERT INTO clu_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Gani makon ni Jesus kanana, “Ano imong gosto?” Makon anang asawa ni Zebedeo, “Kon maimo, kon magari ka run gani, papongkoon mo ra akun darwa nga dia ka bata sa imong kilid; ang isara sa too kag ang isara sa wala.” ");
INSERT INTO clu_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Piro ginsabat sanda ni Jesus, makon na, “Ara kamo kaulam kon ano indong ginapangayo. Ano, masarangan nindo ang mga pagantos nga madali ko ron lang nga antoson?” Makon nanda, “Uu. Masarangan namun.” ");
INSERT INTO clu_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Makon roman ni Jesus, “Masarangan nindo manda, piro bukun ako ang nagapili kon sino ang mapongko sa akun too okon sa akun wala. Dan nga mga porongkoan para sa mga tao nga ginatiganaan akun Tatay.” ");
INSERT INTO clu_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Pagkaulam ang napolo ka somolonod kon ano andang ginpangayo, naglain andang buut sa magkabogto. ");
INSERT INTO clu_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Gani gintawag sanda tanan ni Jesus kag magkoon kananda, “Naulaman nindo nga ang mga manogdomara digi sa kalibotan nga dia may gaum sa andang mga sinakupan kag pagosto sanda lang kon ano andang ipaimo kananda. ");
INSERT INTO clu_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Piro iba tana ang kanindo. Ay kon sino kanindo ang gosto nga maging importanti, dapat tana ang maging sorogoon anang mga kaiban. ");
INSERT INTO clu_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Kag kon sino kanindo ang gosto nga maging labaw sa tanan, dapat tana ang maging oripun anang mga kaiban. ");
INSERT INTO clu_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Dan toladan akun ginimo, Ako nga Naging Tao ara nagayan digi sa kalibotan para magpasirbi kondi para magsirbi kag magtaw akun kaboi agud matobos ang doro nga mga tao.” ");
INSERT INTO clu_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ang nagapagoa run sanday Jesus sa Jerico doro nga mga tao ang nagsonod kanana. ");
INSERT INTO clu_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Karon, may darwa doto ka bolag nga nagapongko sa binit ang dalan. Nabatian nanda nga si Jesus nagaagi, gani nagsinggit sanda, makon, “Ginoo, nga kaliwat ni David kag manonobli anang ginarian, abi kaloyi kami ra!” ");
INSERT INTO clu_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ginsaway sanda ang mga tao nga magipus. Piro andang ginimo tana, tinodoan nanda pa gani andang singgit nga nagakoon, “Ginoo, nga kaliwat ni David, kaloyi kami ra!” ");
INSERT INTO clu_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Nagtadung si Jesus, gintawag sanda kag magkoon, “Ano indong gosto nga imoon ko kanindo?” ");
INSERT INTO clu_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Makon nanda, “Ginoo, gosto namun nga makakita!” ");
INSERT INTO clu_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Nalooy si Jesus kananda, gani gintandug na andang mga mata, kag lagi-lagi nakakita sanda; kag nagtabid sanda dayon kanana. ");
INSERT INTO clu_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Datong marapit sanda run lang sa Jerusalem kag nagainamput sa bario ang Bitpage sa may Bokid ang mga Olibo, ginpaona ni Jesus anang darwa ka somolonod. ");
INSERT INTO clu_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Makon na kananda, “Pagayan kamo sa bario nga dian sa onaan. Pagabot nindo doto makikita nindo nga lagi ang asno nga nagaigot kag anang bata doto ra. Obadun nindo kag daraun digi kanakun. ");
INSERT INTO clu_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Kon may magpamangkot kanindo parti digi konon nindo lang nga kinanglan ang Ginoo, kag dan ipadara na ra nga lagi kanindo.” ");
INSERT INTO clu_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Dia natabo agud matoman anang ginambal ang propita nga nagkoon, ");
INSERT INTO clu_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Koona nindo ang mga taga-Sion nga digi run indong Ari, Mapinaubusun tana, ay nagaabot tana nga nagasakay sa bataun pa nga asno!” ");
INSERT INTO clu_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Gani nagpanaw ang darwa nga dato ka somolonod kag gintoman nanda anang sogo ni Jesus. ");
INSERT INTO clu_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Gindara nanda ang asno pati anang bata doto kay Jesus. Andang lambong maman andang ginbutang nga ampilo kag ginsakayan dayon ni Jesus. ");
INSERT INTO clu_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Dorong tao ang nagtiripon doto. Andang ginimo, ginumlad nanda andang lambong sa dalan. Ang iba nagtapas anang mga sanga ang mga kaoy kag ginladlad nanda ra sa dalan bilang pagpadungug kay Jesus. ");
INSERT INTO clu_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Nagsiringgit ang mga tao nga nagaona pati ang nagasonod kanana nga nagakoon, “Dayawon ang manonobli anang ginarian ni David! Ginakaloyan ra gid ang Dios anang ginsogo nga nagaabot dadi digi kanatun! Dayawon ang Dios!” ");
INSERT INTO clu_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Pagabot ni Jesus sa Jerusalem nagkinagolo ang mga tao doto. Makon nanda, “Sino ang tao nga dan?” ");
INSERT INTO clu_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Makon ang mga tao nga kaiban ni Jesus, “Maman dan ang propita nga si Jesus nga taga-Nazaret nga sakup ang Galilea.” ");
INSERT INTO clu_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Nagsulud si Jesus sa timplo kag ginpalayas na doto ang mga tao nga nagaparamakal kag nagabaraligya. Ginpamaliskad na anang mga lamisa ang mga manogbaylo ang koarta pati anang mga porongkoan ang mga tao nga nagapamaligya ang mga salampati. ");
INSERT INTO clu_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Makon na kananda, “Kabay nagkoon ang Dios sa Kasolatan nga anang balay dapat tawagun nga balay nga parangamoyoan. Piro ginaimo nindo tana nga parantagoan ang mga tolisan!” ");
INSERT INTO clu_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","May mga bolag kag mga lopog nga nagayan kanana doto sa timplo kag ginpangayad na sanda. ");
INSERT INTO clu_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ginugutan ang mga manogdomara nga mga pari kag ang mga manogtodlo ang Kasogoan pagkakita nanda sa mga makatiringala nga mga butang nga anang ginapangimo kag pagkabati nanda nga nagasiringgit ang mga bata doto sa timplo nga nagakoon, “Dayawon ang manonobli anang ginarian ni David!” ");
INSERT INTO clu_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Gani makon nanda kay Jesus, “Nababatian mo ra kon ano andang ginakoon?” Makon ni Jesus, “Uu. Basi, ara kamo gid kabasa sa Kasolatan nga nagakoon nga miski ang mga bata nga mairintuk gintodloan ang Dios nga magdayaw kanana?” ");
INSERT INTO clu_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Kag ginbayaan sanda dayon ni Jesus. Nagoa tana sa siodad ang Jerusalem kag nagpa-Betania kag doto tana nagkatorog. ");
INSERT INTO clu_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Pagkaaga, ang nagapabalik run si Jesus sa siodad ang Jerusalem gingutum tana. ");
INSERT INTO clu_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Karon, may nakita tana nga kaoy nga igira marapit sa dalan. Gani ginparapitan na, piro ara tana gid may nakita nga bonga kondi mga daon lang gid. Makon na dayon sa kaoy, “Alin dadi indi ka run gid magbonga!” Kag nalayung nga lagi ang igira. ");
INSERT INTO clu_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Pagkakita dato anang mga somolonod natingala sanda nga mayad. Makon nanda, “Paiwan nga nalayung nga lagi ang igira?” ");
INSERT INTO clu_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Makon ni Jesus kananda, “Sa matood tana, kon may pagtoo kamo kag indi kamo gid magpandoa-doa, maiimo nindo ra akun ginimo nga dia sa kaoy nga igira. Kag bukun lang dan kondi makakoon kamo bisan sa bokid nga dan nga ‘Magalin dian kag magsaylo sa dagat,’ kag matabo ra dan. ");
INSERT INTO clu_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ang bisan ano nga indong pangayoon sa indong pangamoyo mababaton nindo gid, basta magtoo kamo.” ");
INSERT INTO clu_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Nagsulud ruman si Jesus sa timplo kag gintodloan na ang mga tao. Karon may mga manogdomara doto nga mga pari kag mga manogdomara ang mga Judio nga nagparapit kanana kag nagpamangkot, makon nanda, “Ano imong awtoridad nga nagaimo kaw ang mga butang nga imong ginaimo digi sa timplo, kag sino ang nagtaw kanimo ang awtoridad nga dan?” ");
INSERT INTO clu_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Makon ni Jesus kananda, “May pamangkot ako ra anay kanindo. Kag kon masabat nindo dia, sabatun ko kamo ra kon ano akun awtoridad sa pagimo ang mga butang nga dia. ");
INSERT INTO clu_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Akun pamangkot maman dia: kino magalin anang awtoridad ni Juan sa pagpangbunyag, sa Dios okon sa tao?” Nagbais-baisan sanda anay nga sanda-sanda lang kon ano andang isabat; makon nanda, “Kon magkoon kita nga ‘Alin sa Dios,’ makoon tana nga, ‘Ta basi ara kamo nagpati kay Juan?’ ");
INSERT INTO clu_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Kag kon magkoon kita ra nga ‘Alin sa tao,’ dilikado kita ra sa mga tao ay nagapati sanda nga si Juan anang propita ang Dios.” ");
INSERT INTO clu_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Gani andang sabat run lang kay Jesus, “Ilam, ara kami kaulam.” Makon ra ni Jesus kananda, “Ta indi ko kamo ra pagsogidan kon kino nga awtoridad ko ginaimo ang mga butang nga dia nga akun ginaimo.” ");
INSERT INTO clu_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Kag makon ra ni Jesus kananda, “Kon sa kanindo, ano kabay dia? May sangka tao nga may darwa ka bata nga lalaki. Ginayanan na ang gorang kag magkoon, makon na, ‘Doy, magayan kaw dadi sa atun kaobasan kag magobra.’ ");
INSERT INTO clu_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Makon anang bata, ‘Indi ako!’ Piro ang ori nagbago anang isip kag nagayan tana sa andang kaobasan kag magobra. ");
INSERT INTO clu_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Nagayan ra ang tatay sa libayun kag ginkonan na ra pario anang ginkoon sa gorang. Makon anang sabat ang libayun, ‘Uu, tay,’ piro ara tana nagtoman. ");
INSERT INTO clu_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ta diin digi sa darwa ang nagtoman anang sogo anang tatay?” Makon nanda, “Ang gorang.” Makon ni Jesus kananda, “Sa matood tana, maona pa kanindo nga makasulud sa anang ginarian ang Dios ang mga tao nga pario sa mga manogsokot ang bois kag mga babai nga nagabaligya andang dungug. ");
INSERT INTO clu_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ay si Juan nga manogbunyag nagayan digi kag nagtodlo kanindo ang osto nga paagi agud maging matarung kamo sa panulung ang Dios, piro ara kamo nagpati kanana. Ang mga manogsokot tana ang bois kag ang mga babai nga nagbaligya andang dungug nagpati kanana. Kag bisan nakita nindo dia, ara kamo gid nagbago indong isip kag magpati kanana.” ");
INSERT INTO clu_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Makon ni Jesus kananda, “Pamatii nindo ang isara pa gid ka paanggid. May sangka tao nga may logta nga ginpatanuman na obas. Ginpakodalan na, kag nagpaimo tana mabaul nga boo sa mabaul nga bato bilang purugaan ang obas. Nagpatindug tana ra ang mataas nga balay nga ralantawan ang bantay. Pagkatapos ginpaagsaan na dayon kag nagayan sa marayu nga logar. ");
INSERT INTO clu_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Datong inogpopo ron ang obas, ginsogo na anang mga sorogoon nga bulun anang parti sa patubas. ");
INSERT INTO clu_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Garing pagabot doto ang mga sorogoon, ginpandakup sanda ang mga agsador. Ginbalbal nanda ang sakabilog, ginpatay nanda ang sakabilog, kag ginbato nanda ang sakabilog pa gid. ");
INSERT INTO clu_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Pagkatapos dato nagsogo roman ang tagya ang iba pa nga mga sorogoon nga mas doro pa gid kaysa sa naona. Piro toladato ra andang ginimo kananda. ");
INSERT INTO clu_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ang ori anang bata run gid anang ginsogo, ay makon na, ‘Indi maimo nga indi nanda pagtaodon akun bata.’ ");
INSERT INTO clu_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Piro pagkakita ang mga agsador nga anang bata run ang nagabot, makon nanda, ‘Dia ang manogpanobli ang kaobasan. Dali, patayun ta agud maging atun anang sorobliun.’ ");
INSERT INTO clu_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Gani gindakup nanda tana kag gindara doto sa goa ang kaobasan kag ginpatay nanda dayon.” ");
INSERT INTO clu_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Ta,” makon ni Jesus, “kon magbalik anang tagya ang kaobasan, ano kabay anang imoon sa mga agsador nga dato?” ");
INSERT INTO clu_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Makon nanda, “Pamatayun na gid ang mga agsador nga dato nga malain kag indi na gid pagkaloyan. Kag anang kaobasan paagsaan na dayon sa agsador nga mataw anang parti kada patubas.” ");
INSERT INTO clu_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Makon ni Jesus kananda, “Kabay nabasa nindo anang ginakoon sa Kasolatan nga, ‘Ang bato nga ginsikway ang mga panday Maman gid ang naging pondasyon nga bato. Maman dia anang ginimo ang Ginoo, Kag makatiringala kanatun!’” ");
INSERT INTO clu_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Makon pa gid ni Jesus kananda, “Maman dan nga anang Ginarian ang Dios bulun kanindo kag itaw sa mga tao nga nagaimo anang mga ginapaimo.  ");
INSERT INTO clu_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ang bisan sino nga maglagpak sa bato nga dia magakarabari, piro ang lagpakan ang bato nga dia matudtud gid.” ");
INSERT INTO clu_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Pagkabati ang mga manogdomara nga mga pari kag mga Pariseo ang mga paanggid ni Jesus, nasatuman nanda nga sanda anang ginatomod. ");
INSERT INTO clu_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Gani gosto nanda run gid andan nga dakupun si Jesus, piro ginaadlukan sanda sa mga tao tungud nga ginakilala nanda nga propita si Jesus. ");
INSERT INTO clu_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Nagtodlo roman si Jesus kananda paagi sa paanggid. ");
INSERT INTO clu_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Makon na, “Anang pagari ang Dios pario sa natabo sa sangka ari nga nagpriparar ang ponsyon para sa kasal anang bata nga lalaki. ");
INSERT INTO clu_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ginsogo na anang mga sorogoon nga tawagun run ang mga tao nga anang ginpangimbitar. Garing ara sanda naliag magtambong. ");
INSERT INTO clu_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Gani ginsogo na ruman ang iba pa gid nga sorogoon. Makon na, ‘Konon mo ang mga ginpangimbitar nga ginpamatay ko ron ang mga baka pati ang iba nga mga sapat nga akun ginpatambuk kag priparado ron ang pagkaun. Gani magayan sanda run digi kag magpamonsyon.’ ");
INSERT INTO clu_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Piro ang mga tao nga ginpangimbitar ara nagsapak. Sigi tana andang asikaso andang obra. Ang isara nagayan sa anang mga tanum, kag ang isara sa anang nigosyo. ");
INSERT INTO clu_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ang iba tana, andang ginimo, gindakup nanda anang mga ginsogo ang ari kag ginpasipalaan nanda kag ginpamatay. ");
INSERT INTO clu_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Gani nasilag nga mayad ang ari. Ginsogo na anang mga soldado nga pamatayun ang nagpamatay anang mga sorogoon kag sonogon andang banwa. ");
INSERT INTO clu_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Pagkatapos gintawag na dayon anang mga sorogoon kag magkoon, makon na, ‘Ang pagkaun sa kasal akun bata priparado ron, garing ara kointa ang mga ginpangimbitar. ");
INSERT INTO clu_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Pagayan kamo ron lang sa mga karsada nga doro ang nagaagi kag imbitara nindo digi ang tanan nga indong makita.’ ");
INSERT INTO clu_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Gani nagpanaw ang mga sorogoon kag nagayan sanda sa mga karsada, kag tanan nga andang nakita mayad okon malain ginimbitar nanda. Kag napono tao ang ponsyonan. ");
INSERT INTO clu_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Malagat-lagat nagsulud ang ari ay gosto na nga makita ang mga bisita. Karon, may nakita tana doto nga tao nga ara nagilis ang lambong nga para sa ponsyon. ");
INSERT INTO clu_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Gani makon ang ari kanana, ‘Amigo, basi nakasulud kaw digi nga ara nakailis ang lambong nga para sa ponsyon?’ Piro ang tao nga dato ara gid limug-limug ay ara tana isabat. ");
INSERT INTO clu_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Makon dayon ang ari sa anang mga sorogoon, ‘Gaposa nindo anang alima kag anang siki kag ipilak doto sa goa sa madulum. Doto magapanangis tana kag magapabagrut anang ipun.’” ");
INSERT INTO clu_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Pagkatapos makon dayon ni Jesus, “Doro anang ginatawag ang Dios sa anang ginarian, piro maistan lang ang mga napili nga makasulud.” ");
INSERT INTO clu_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Nagalin ang mga Pariseo kag nagplano sanda kon paiwan nanda madakup si Jesus paagi sa anang ambal. ");
INSERT INTO clu_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ginsogo nanda dayon ang iba sa andang mga somolonod kag ang pira ka mimbro anang partido ni Herodes. Pagabot nanda kay Jesus nagpamangkot sanda, makon, “Maistro, naulaman namun nga poros matood imong ginasogid. Ginatodlo mo ang kamatoodan parti sa anang gosto ipaimo ang Dios sa mga tao. Kag indi kaw madara-dara sa anang gosto ang mga tao abir kon sino sanda. ");
INSERT INTO clu_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Abi kon sa kanimo, osto bala nga kita bilang mga Judio magbayad ang bois sa Impirador ang Roma okon indi?” ");
INSERT INTO clu_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Naulaman ni Jesus andang katoyoan nga marimo. Gani makon na kananda, “Mga botigun kamo. Basi ginatirawan nindo ako nga dakupun paagi sa indong pagpamangkot nga dan? ");
INSERT INTO clu_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Abi pakitaan nindo kanakun ang koarta nga ginagamit sa pagbayad ang bois.” Kag ginpakita nanda ang koarta. ");
INSERT INTO clu_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Makon ni Jesus kananda, “Kinong itsora dia kag kinong aran?” ");
INSERT INTO clu_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Makon nanda, “Ana ang Impirador.” Gani makon ni Jesus kananda, “Ta kondi itaw nindo sa Impirador ang ana ang Impirador, kag itaw nindo ra sa Dios ang ana ang Dios.” ");
INSERT INTO clu_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Pagkabati nanda anang sabat ni Jesus natingala sanda nga mayad. Gani ginbayaan nanda tana run lang. ");
INSERT INTO clu_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ang adlaw ra nga dato may mga Saduseo nga nagarayan kay Jesus. Dia nga mga tao ara nagapati nga ang mga tao mababanaw. Makon nanda, ");
INSERT INTO clu_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Maistro, si Moises nagkoon nga kon ang lalaki may asawa kag mapatay tana nga ara kapabata, dapat anang kabogto roman ang mapangasawa sa anang asawa nga nabalo agud makapabata tana para sa anang kabogto. ");
INSERT INTO clu_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Karon, ang ona may pito digi ka magkarabogto nga lalaki. Ang gorang gid nagpangasawa, garing napatay tana nga ara kapabata. Gani ang balo ginpangasawa anang kabogto nga sonod kanana. ");
INSERT INTO clu_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Kag ang ikarwa nga dato napatay ra nga ara kapabata. Gani ginpangasawa ruman ang ikatlo kag maman ra ang natabo kanana kag sa tanan nga magkarabogto asta sa ikapito. ");
INSERT INTO clu_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ang ori ang babai napatay ra. ");
INSERT INTO clu_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Karon kon magabot ron ang pagkabanaw kino tana nga asawa, ay sanda tanan nakapangasawa sa babai nga dato?” ");
INSERT INTO clu_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Makon ni Jesus kananda, “Sala kamo gid, tungud nga ara kamo kaintindi kon ano anang ginakoon ang Kasolatan. Kag ara kamo ra kaintindi anang gaum ang Dios. ");
INSERT INTO clu_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ay sa adlaw ang pagkabanaw, ang mga tao indi run magarasawa, tungud nga pario sanda run sa mga angil sa langit. ");
INSERT INTO clu_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Kon parti sa pagkabanaw, nakabasa kamo ra kabay anang ginambal ang Dios kanindo. ");
INSERT INTO clu_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Kabay makon na, ‘Ako anang Dios ni Abraham, kag anang Dios ni Isaac, kag anang Dios ni Jacob.’ Piro dia nga mga tao patay run. Garing ang Dios bukun Dios ang mga patay, kondi Dios tana ang mga boi. Dia nagapamatood kanatun nga ang mga napatay naboboi.” ");
INSERT INTO clu_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Pagkabati dato ang mga tao natingala sanda sa anang mga panodlo. ");
INSERT INTO clu_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Pagkabati ang mga Pariseo nga ang mga Saduseo ara gid may maimo kay Jesus, nagtiripon sanda ruman kag nagayan kanana. ");
INSERT INTO clu_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Isara sa mga manogtodlo ang Kasogoan maman ruman ang nagpamangkot kay Jesus agud dakupun tana sa anang sabat. ");
INSERT INTO clu_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Makon na, “Maistro, ano gid kabay ang pinakaimportanti nga sogo sa Kasogoan?” ");
INSERT INTO clu_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Makon ni Jesus kanana, “‘Igogmaun mo ang Ginoo nga imong Dios nga tuduk sa imong tagiposoon kag sa bilog mo nga kalag, nga imong isip pirmi gid kanana.’ ");
INSERT INTO clu_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Maman gid dia ang pinakaimportanti nga sogo sa tanan. ");
INSERT INTO clu_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Kag ang masonod toladato ra, ‘Igogmaun mo imong kapario pario imong pagigogma sa imong kaogalingun.’ ");
INSERT INTO clu_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ang tanan nga Kasogoan nga ginsolat ni Moises pati anang mga panodlo ang mga propita digi nagalin sa darwa nga dia ka sogo.” ");
INSERT INTO clu_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Bago nagburulag ang mga Pariseo nagpamangkot si Jesus kananda, ");
INSERT INTO clu_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","makon na, “Kon sa kanindo ano indong pagkakilala sa Cristo? Kino tana nga kaliwat?” Makon nanda, “Kay David.” ");
INSERT INTO clu_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Makon dayon ni Jesus kananda, “Kon tana anang kaliwat ni David, ta basi si David nga ginbugnaan ang Ispirito Santo nagtawag kanana nga Ginoo? Ay makon na, ");
INSERT INTO clu_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Ang Ginoo nagkoon sa akun Ginoo, Pagpongko digi sa akun too, Asta pasokoon ko kanimo imong mga kaaway.’ ");
INSERT INTO clu_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Karon, kon gintawag na tana nga Ginoo, paiwan nga tana anang kaliwat lang gid ni David?” ");
INSERT INTO clu_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Kag ara gid may nakasabat kay Jesus sa anang pamangkot nga dato. Kag alin dato ara run gid may nagpangaas nga magpamangkot kanana. ");
INSERT INTO clu_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Nagambal dayon si Jesus sa mga tao kag sa anang mga somolonod. ");
INSERT INTO clu_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Makon na, “Ang mga manogtodlo ang Kasogoan kag mga Pariseo maman ang ginsarigan nga magsaysay anang Kasogoan ni Moises. ");
INSERT INTO clu_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Gani tomana nindo andang ginatodlo kanindo, piro indi nindo pagsonodon andang ginaimo tungud nga iba andang ginaimo sa andang ginaambal. ");
INSERT INTO clu_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Nagaimo sanda ang mga malisud nga mga soronodon nga ginapasonod sa mga tao, piro bisan maistan lang gid nga bolig ara sanda gid may ginaimo agud masonod andang ginapasonod. ");
INSERT INTO clu_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ang tanan nga andang ginaimo pakita-kita lang sa mga tao. Ginapalapad nanda ang mga kaon-kaon nga burutangan ang mga pili nga mga dinalan nga alin sa Kasolatan nga andang ginabugkus sa andang dai kag sa andang butkun. Kag ginapalabug nanda pa ang mga ramoy-ramoy sa anang sidsid andang mga lambong agud konon nga sanda kono mga diosnon. ");
INSERT INTO clu_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Kon sa mga ponsyon kag sa mga simbaan, gosto nanda gid nga magpongko sa mga porongkoan nga para sa mga dungganun. ");
INSERT INTO clu_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Kon sa mga logar nga ginatiriponan ang mga tao, gosto nanda gid nga taodon sanda kag tawagun nga ‘Maistro.’ ");
INSERT INTO clu_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Piro kamo tana, indi kamo magpatawag nga ‘Maistro,’ ay magkarabogto kamo kag sakabilog lang indong manogtodlo. ");
INSERT INTO clu_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Indi kamo ra magtawag sa bisan kino digi sa logta nga ‘Tatay,’ ay sakabilog lang gid indong Tatay, kag tana maman ang doto sa langit. ");
INSERT INTO clu_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Kag indi kamo magpatawag nga ‘Agalun,’ ay sakabilog lang indong agalun. Dan ara iba kondi ang Cristo. ");
INSERT INTO clu_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Kon sino kanindo ang nagasirbi sa anang kaiban maman ang pinakaimportanti kanindo. ");
INSERT INTO clu_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ang nagapataas-taas anang kaogalingun panabaun ang Dios. Piro ang nagapaubus tana maman anang imoon ang Dios nga pinakamataas sa tanan.” ");
INSERT INTO clu_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Kailo kamo ra nga mga manogtodlo ang Kasogoan kag mga Pariseo. Indong pagtoo sa Dios pakita-kita lang! Ay ginasiradoan nindo anang poirtaan anang ginarian ang Dios sa mga tao. Indi kamo ra magsulud, piro ginapamalabagan nindo pa ang mga tao nga nagaimorat nga magsulud.  ");
INSERT INTO clu_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Kailo kamo ra nga mga manogtodlo ang Kasogoan kag mga Pariseo. Indong pagtoo sa Dios pakita-kita lang. Ay ginabuul nindo anang pagkabutang ang mga babai nga balo, kag ginatabon-tabonan nindo lang paagi sa indong malawig nga mga pangadi. Gani mabaul nga silot indong mababaton! ");
INSERT INTO clu_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Kailo kamo ra nga mga manogtodlo ang Kasogoan kag mga Pariseo. Indong pagtoo sa Dios pakita-kita lang! Ay ginaalid nindo ang bilog nga kalibotan agud makabinsir kamo bisan sangka tao sa indong pagparatian. Piro kon makombinsir nindo ron gani ginaimo nindo tana nga sobra pa kanindo anang kalain kag bagay nga ipilak sa impyirno. ");
INSERT INTO clu_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Kailo kamo ra, kamo nga mga bolag nga mga manogtodlo. Ay nagatodlo kamo nga ‘kon ang tao magsompa sa timplo, indi bali nga indi na pagtomanun anang ginsompa. Piro kon tana magsompa sa bolawan nga doto sa timplo, kinanglan tomanun na gid anang ginsompa.’ ");
INSERT INTO clu_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Boang-boang kamo kag bolag. Ay diin ang mas importanti, ang bolawan okon ang timplo nga nagapabalaan sa bolawan nga dato? ");
INSERT INTO clu_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Kag nagatodlo kamo ra nga ‘kon ang tao magsompa sa altar, indi bali kon indi nanda pagtomanun anang ginsompa. Piro kon magsompa tana sa alad nga nagatongtong sa altar kinanglan tomanun na gid anang ginsompa.’ ");
INSERT INTO clu_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Mga bolag kamo! Diin ang mas importanti, ang alad okon ang altar nga nagapabalaan sa alad? ");
INSERT INTO clu_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Maman dan nga kon ang tao magsompa sa altar, nagasompa tana sa altar kag sa tanan nga alad nga sa altar. ");
INSERT INTO clu_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Kag kon ang tao magsompa sa timplo, nagasompa tana sa timplo kag sa Dios nga nagaoli doto sa timplo nga dato. ");
INSERT INTO clu_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Kag kon ang tao magsompa sa langit, nagasompa tana sa anang trono ang Dios, kag sa Dios mismo nga nagapongko doto. ");
INSERT INTO clu_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Kailo kamo ra nga mga manogtodlo ang Kasogoan kag mga Pariseo. Indong pagtoo sa Dios pakita-kita lang. Ay nagataw kamo sa Dios indong ikanapolo bisan sa mga panlakut sa pagkaun, piro ara nindo ginasonoda ang mas importanti nga mga sogo parti sa matarung nga pagkaboi, pagkamaloloyon, kag ang sogo nga kamo dapat masarigan. Dapat magtaw kamo manda indong ikanapolo piro indi nindo ra pagpabayanan ang mas importanti nga mga sogo. ");
INSERT INTO clu_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Bolag kamo manda nga mga manogtodlo. Indong ginaimo nga dan pario sa ginasara nindo ang sapat-sapat sa indong mga irinumun, piro ginagapil nindo ra inum ang mabaul gid nga sapat. ");
INSERT INTO clu_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Kailo kamo ra nga mga manogtodlo ang Kasogoan kag mga Pariseo. Indong pagtoo sa Dios pakita-kita lang! Ay ginalimpyo nindo anang goa ang mga baso kag mga pinggan piro ang matood tana, sa sulud indong tagiposoon marisna ay mga akug kamo kag ginapangrugus nindo ang mga tao agud mabuul andang pagkabutang. ");
INSERT INTO clu_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Bolag kamo nga mga Pariseo! Limpyoa nindo anay ang sa sulud ang baso kag ang sa goa magalimpyo ra. ");
INSERT INTO clu_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Kailo kamo ra nga mga manogtodlo ang Kasogoan kag mga Pariseo. Indong pagtoo sa Dios pakita-kita lang! Ay pario kamo sa mga pantion nga ginpintaan ang poti kag masadya nga sulungun sa goa, piro sa sulud tana maboro kag poros tolan ang patay. ");
INSERT INTO clu_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Kamo toladan gid ay kon sulungun kamo ang mga tao midyo osto indong ginaimo piro ang matood tana, poros pakita-kita lang, ay sa sulud indong tagiposoon masyado kamo kalain nga mga tao.” ");
INSERT INTO clu_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Kailo kamo ra nga mga manogtodlo ang Kasogoan kag mga Pariseo. Indong pagtoo sa Dios pakita-kita lang! Ay ginapaobra nindo kag ginaponian anang pantion ang mga tao nga matarung kag mga propita, ");
INSERT INTO clu_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","kag nagakoon kamo nga kon kamo andan boi sa tyimpo indong mga kaolang-olangan, ara nindo pagpataya ang mga propita pario andang ginimo. ");
INSERT INTO clu_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ta, ginaako nindo mismo nga kamo anang mga kaliwat manda ang mga tao nga nagapamatay ang mga propita, kondi napanobli nindo ra andang mga ogali. ");
INSERT INTO clu_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Sigi, taposa nindo anang ginompisaan indong mga kaolang-olangan! ");
INSERT INTO clu_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Pario kamo sa magkal, anang lai kamo ang mga madalit nga mga magkal. Indi kamo gid makapalagyaw sa silot sa impyirno. ");
INSERT INTO clu_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Gani pamati kamo, ako magapadara kanindo ang mga propita kag maaram nga mga tao kag mga manogtodlo. Ang iba kananda papatayun nindo. Ipalansang nindo sanda sa kros. Kag ang iba panganoton nindo sa indong mga simbaan kag bisan diin sanda nga logar magpalagyaw lalagasun nindo. ");
INSERT INTO clu_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Maman dia nga kamo ang sisilotan sa pagpamatay ang tanan nga mga tao nga matarung alin pa kay Abel asta kay Zacarias nga bata ni Baraquias, nga indong ginpatay sa anang ulut ang timplo kag ang altar nga ginaaladan. ");
INSERT INTO clu_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Sa matood tana, kamo nga mga tao sa tyimpo nga dia maman ang masabat sa tanan nga dia nga mga sala.” ");
INSERT INTO clu_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Kamo nga mga taga-Jerusalem, basi ginapamatay nindo ang mga propita kag ginapambato anang mga ginapadara ang Dios kanindo? Boay run akun andum nga tiponon kamo kag atipanun pario sa inaan nga manok nga nagatipon anang mga pisu sa idalum anang mga pakpak, garing indi kamo kanakun! ");
INSERT INTO clu_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Dadi, baala kamo ron sa indong kaogalingun. Pabayanan kamo ron lang nga magbagsak indong logar. ");
INSERT INTO clu_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ay indi nindo ako ron gid makita asta magabot ang adlaw nga magkoon kamo nga, ‘Dayawon ang nagaabot nga ginpadara ang Ginoo.’” ");
INSERT INTO clu_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Naggoa si Jesus sa timplo kag mintras nagapanaw tana nagparapit kanana ang mga somolonod kag gintodlo nanda kanana anang mga balay ang timplo. ");
INSERT INTO clu_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Makon ni Jesus kananda, “Sulunga nindo dan tanan. Sa matood tana, magakararompag ang tanan kag ara gid may mabilin nga mga bato nga nagakamada.” ");
INSERT INTO clu_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Mintras nagapongko si Jesus doto sa Bokid ang mga Olibo, nagparapit kanana anang mga somolonod ang sanda-sanda run lang. Makon nanda, “Abi sogidi kami kon sano matatabo ang mga butang nga dato nga imong ginkoon? Ano ang mga tanda nga ikaw madali run magbalik digi kag matapos ang tyimpo nga dia?” ");
INSERT INTO clu_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Nagsabat si Jesus kananda, “Magandam kamo nga ara may makapatalang kanindo. ");
INSERT INTO clu_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ay doro ang magaabot kag kada isara magakoon nga sanda kono ako, ay magakoon sanda nga sanda maman ang Cristo, kag doro andang mapatalang. ");
INSERT INTO clu_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Makakabati kamo mga gira dian sa indong marapit kag makakabarita kamo nga doto sa marayu nagagira ra. Piro indi kamo magpakulba ay dia kinanglan nga matabo gid man, piro bukun pa dan ang kataposan. ");
INSERT INTO clu_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Magaaraway ang mga nasyon kag magaaraway ang mga ginarian. May mga gutum kag mga linog nga magaabot sa bisan diin nga logar. ");
INSERT INTO clu_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Piro dia tanan ompisa pa lang ang mga kalisud nga magaabot. ");
INSERT INTO clu_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Sa mga adlaw nga dato dudumutan kamo ang tanan nga mga tao tungud nga kamo akun mga somolonod. Dadakupun nanda kamo kag iintriga dayon sa mga tao nga magasilot kanindo kag ang iba kanindo papatayun gid. ");
INSERT INTO clu_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Kag kon magabot ron ang mga pagingabot nga dan, doro ang magatalikod sa andang pagtoo. Dudumutan nanda kag tatraidoran andang kapario nga tomoloo. ");
INSERT INTO clu_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Kag magagoa ra ang mga botigun nga mga propita kag doro andang papatalangun. ");
INSERT INTO clu_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kag tungud nga bisan diin malain run gid anang ginaimo ang mga tao, anang gogma ang doro nga mga tomoloo magalasay. ");
INSERT INTO clu_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Piro ang nagapadayon tana asta sa kataposan malolowas. ");
INSERT INTO clu_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Kag bago pa magaabot ang kataposan kon ang Mayad nga Barita parti sa anang pagari ang Dios maiwali run sa bilog nga kalibotan agud makaulam ang tanan nga mga tao. ");
INSERT INTO clu_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Ang propita nga si Daniel nagtagna parti sa pinakamaraway nga manogpangrangga. (Ang nagabasa anang gintagna magangup gid kon ano anang kaologan.) Kag kon dia makita nindo nga doto ron sa sagrado nga logar, ");
INSERT INTO clu_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","kamo nga nagaoli sa Judea dapat magparalagyaw sa kabokidan. ");
INSERT INTO clu_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ang tao nga mataboan nga sa goa anang balay indi run magpaawat sulud para magbuul anang pagkabutang. ");
INSERT INTO clu_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Kag ang mataboan nga nagaobra sa anang logta indi run dapat magoli para magbuul anang lambong. ");
INSERT INTO clu_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Sa mga adlaw nga dato kailo ra ang mga nagaburudus kag ang mga nagaparatiti tungud nga malilisudan sanda sa pagpalagyaw. ");
INSERT INTO clu_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ipangamoyo nindo nga indong pagpalagyaw indi makatabo sa tigraramig okon sa Adlaw nga Inogpaway. ");
INSERT INTO clu_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ay sa tyimpo nga dato masyado gid kalisud anang maagian ang mga tao. Ara pa gid may natabo sa kalibotan nga pario sa matatabo nga dato, kag ara run da may matatabo pa nga magapario dato asta kon sano. ");
INSERT INTO clu_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ang matood tana, kon ara ginpatagud ang Dios ang mga adlaw nga dato nga maabot, ara gid may mabilin nga tao. Piro tungud sa anang kalooy sa anang mga pinili ginpatagud na. ");
INSERT INTO clu_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Gani kon may magkoon kanindo nga ‘Dagi run ang Cristo!’ okon ‘Doto tana!’ indi kamo magpati. ");
INSERT INTO clu_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ay magagoa ang bukun matood nga mga Cristo kag ang bukun matood nga mga propita. Magaimo sanda mga milagro kag mga katiringalaan sa katoyoan nga patalangun, kon maimo, bisan pa anang mga pinili ang Dios. ");
INSERT INTO clu_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Gani tandaan nindo gid! Ginasogid ko ron nga lagi kanindo ang mga butang nga dia mintras ara pa natatabo. ");
INSERT INTO clu_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Gani kon alimbawa may mga tao nga magkoon kanindo nga ‘Si Cristo doto sa naligwin nga logar,’ indi kamo gid magayan doto. Kag kon may magkoon nga, ‘Dian tana sa sulud nga nagapantago,’ indi kamo gid magpati. ");
INSERT INTO clu_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ay kon Ako nga Naging Tao magbalik run, makikita ang tanan tungud nga maging pario sa kilat nga anang lanyag nakikita sa mororan asta sa kasalupan. ");
INSERT INTO clu_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“May orobatun nga nagakoon, ‘Kon diin ang may patay nga sapat, doto ra nagatiripon ang mga wak.’” ");
INSERT INTO clu_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Pagkatapos lang ang mga kalisud sa tyimpo nga dato, ang adlaw magadulum kag ang bolan indi run magsanag, kag ang mga bitoon magakaraolog. Ang mga dian sa langit magataralang sa andang dati nga ginaagian. ");
INSERT INTO clu_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Kag makikita dayon sa langit nga Ako nga Naging Tao nagabalik run sa kalibotan. Kag ang tanan nga tao sa kalibotan magaparanangis sa kaadluk kon makita nanda ako ron nga nagaabot sa mga panganod nga may gaum kag nagalanyag nga mayad. ");
INSERT INTO clu_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Sa mabaskug nga tonog ang trompita sogoon ko dayon akun mga angil agud tiponon akun mga pinili nga mga tao alin sa tanan nga logar sa kalibotan.” ");
INSERT INTO clu_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Magtoon kamo liksyon sa kaoy nga igira. Kabay kon anang mga sanga magpangogbos ron naulaman ta nga madali run lang ang tingadlaw. ");
INSERT INTO clu_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Dan toladan ra, kon makita nindo gani nga nagakaratabo ron ang mga butang nga dia nga akun ginasogid kanindo, maulaman nindo nga madali ako ron lang magabot. ");
INSERT INTO clu_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Sa matood tana, dia tanan magakaratoman bago mapatay ang mga tao nga dia sa dadi. ");
INSERT INTO clu_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Madodora ang langit kag ang logta, piro akun mga ambal indi gid maimo nga indi matoman.” ");
INSERT INTO clu_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Kon parti sa oras kag adlaw akun pagabot, ara gid may nakaulam bisan ang mga angil sa langit okon Ako nga Bata ang Dios, kondi ang Amay lang. ");
INSERT INTO clu_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ay anang imoon ang mga tao sa tyimpo nga Ako nga Naging Tao mabalik maging pario sa anang ginaimo ang mga tao sa anang tyimpo ni Noe. ");
INSERT INTO clu_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ay bago magabot ang gonaw ara sanda iba nga ginaisip kondi ang magpagosto sa pagkaun, paginum, kag pagasawa asta sa adlaw nga si Noe nagsulud sa arka. ");
INSERT INTO clu_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ara sanda gid kaulam kon ano ang matatabo asta magabot ang gonaw kag nagkaralumus sanda tanan. Toladato ra ang matatabo kon Ako nga Naging Tao magabot. ");
INSERT INTO clu_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Sa adlaw nga dato maimo nga may matataboan nga darwa ka lalaki nga nagaobra sa taramnan; ang isara bulun kag ang isara ibilin. ");
INSERT INTO clu_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","May darwa ka babai nga nagagaling; ang isara bulun kag ang isara ibilin. ");
INSERT INTO clu_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Gani magbantay kamo, ay ara kamo kaulam kon sano nga adlaw maabot indong Ginoo. ");
INSERT INTO clu_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Tandai nindo dia: kon naulaman lang ang tagbalay kon anong oras sa gabi maabot ang takawan, sigorado nga bantayan na gid agud indi makasulud ang takawan sa anang balay. ");
INSERT INTO clu_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Gani magbantay kamo pirmi, ay sa oras nga ara nindo ginadaumdauma, magaabot Ako nga Naging Tao.” ");
INSERT INTO clu_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Ang masarigan kag maaram nga sorogoon maman anang ginapili ang tagbalay nga magdomara sa anang kapario nga mga sorogoon. Kag tana ang nagataw kananda andang pagkaun sa tama nga oras. ");
INSERT INTO clu_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Masoirti ang sorogoon nga dan kon sa pagbalik anang agalun maabotan tana nga ginaimo na ang ginpaimo kanana. ");
INSERT INTO clu_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Sigorado gid nga imoon tana run gid anang agalun nga manogdomara sa anang tanan nga pagkabutang. ");
INSERT INTO clu_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Piro kailo ra ang bukun mayad nga sorogoon nga kon paglarga anang agalun maisipan na nga maboay tana pa magbalik, ");
INSERT INTO clu_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","gani maompisa tana run magpamintas sa anang kapario nga mga sorogoon kag magpakigbarkada sa pagkaun kag paginum sa mga manogpalingin. ");
INSERT INTO clu_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Maabot anang agalun sa oras nga ara na gid ginadumduma. ");
INSERT INTO clu_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Kag silotan tana dayon anang agalun. Ipadara tana sa mga tao nga andang pagtoo sa Dios pakita-kita lang, kag doto may pagpanangis kag pagbagrut ang ipun.” ");
INSERT INTO clu_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Kon magabot ang adlaw nga dato, anang pagari ang Dios mapaanggid sa napolo ka daraga nga nagadara andang solo ay masolang sanda sa nobyo. ");
INSERT INTO clu_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ang lima kananda kabos-kabos kag ang lima kananda may isip. ");
INSERT INTO clu_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ang lima nga dato nga kabos-kabos nagdara andang solo garing ara nagdara risirba nga langis nga kon maobos ang sa solo may itogong sanda ruman. ");
INSERT INTO clu_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ang mga daraga tana nga may isip nagdara ra andang solo kag nagdara pa gid langis. ");
INSERT INTO clu_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Kag tungud nga maboay magabot ang nobyo gindoyog sanda kag natorogan sanda tanan. ");
INSERT INTO clu_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Pagtungang gabi run may nagsinggit, makon, ‘Dagi run ang nobyo. Dali kamo, solanga nindo ron!’ ");
INSERT INTO clu_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ang napolo nga dato ka daraga nagborogtaw kag ginpriparar nanda andang mga solo. ");
INSERT INTO clu_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Makon dayon ang mga daraga nga kabos-kabos sa mga daraga nga may isip, ‘Abi, tawi kami ra indong langis ay amun solo nagapiraw-piraw ron.’ ");
INSERT INTO clu_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Makon ang mga daraga nga may isip, ‘Indi maimo ay kon tungaan namun kamo pa parario kita nga kokolangun. Pagayan kamo ron lang sa mga nagatinda kag magbakal ang para kanindo.’ ");
INSERT INTO clu_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Pagkaalin ang mga kabos-kabos agud magbakal ang langis maman da anang pagabot ang nobyo. Kag ang lima tana nga nakapangaman nakatabid kanana sa sulud ang ponsyonan. Pagkasulud nanda, ginsiradoan dayon ang poirtaan. ");
INSERT INTO clu_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Lagat-lagat nagabot ra andang kaiban nga mga daraga nga nagbakal ang langis, kag nagpanawag sanda, makon, ‘Sir, sir, pasuluda kami ra.’ ");
INSERT INTO clu_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Piro makon ang nobyo, ‘Ara ako gid kakilala kanindo.’” ");
INSERT INTO clu_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Makon dayon ni Jesus, “Maman dan nga kinanglan gid nga magbantay kamo ay ara kamo kaulam kon sano nga adlaw okon oras ako maabot.” ");
INSERT INTO clu_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Anang pagari ang Dios pario sa sangka tao nga parapanawon sa ibang logar. Gani gintawag na anang mga sorogoon kag ginpiar na kananda anang koarta agud inigosyo nanda. ");
INSERT INTO clu_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ang kada isara kananda gintawan na sono sa andang masarangan sa pagnigosyo. Ang isara gintawan na 5,000, ang isara 2,000, kag ang isara pa gid gintawan na 1,000. Pagkatapos nagpanaw tana dayon. ");
INSERT INTO clu_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ang sorogoon nga nakabaton 5,000 nagnigosyo nga lagi kag nakaganansia tana pa gid 5,000. ");
INSERT INTO clu_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Maman ra anang ginimo ang nakabaton 2,000, kag nakaganansia tana 2,000. ");
INSERT INTO clu_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Piro ang nakabaton 1,000 nagpanaw kag nagkotkot sa logta, kag ginlubung na dayon ang koarta nga dato nga gintaw anang agalun nga inognigosyo. ");
INSERT INTO clu_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Ang ori nagbalik andang agalun nga dato nga nagpanaw kag gintawag na anang mga sorogoon agud magsomada sanda anang koarta nga ginpanigosyo kananda. ");
INSERT INTO clu_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ang sorogoon nga nakabaton 5,000 nagparapit kag gintaw na sa anang agalun ang 5,000 pati ang 5,000 pa gid nga anang ganansya. Makon na, ‘Kabay gintawan mo ako 5,000. Way dagi nakaganansia ako 5,000 pa.’ ");
INSERT INTO clu_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Makon anang agalun kanana, ‘Mayad kaw nga sorogoon! Masarigan kaw! Kag tungud nga masarigan kaw kag mayad magpatikang ang maistan nga kantidad, dadi piaran ta kaw ang mas mabaul pa gid nga kantidad. Dali, magkalipay kaw kaiban ko!’ ");
INSERT INTO clu_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ang sorogoon nga nakabaton 2,000 nagparapit ra. Makon na sa anang agalun, ‘Kabay gintawan mo ako 2,000. Way dagi nakaganansia ako 2,000 pa.’ ");
INSERT INTO clu_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Makon anang agalun kanana, ‘Mayad kaw nga sorogoon! Masarigan kaw! Kag tungud nga masarigan kaw kag mayad magpatikang ang maistan nga kantidad, dadi piaran ta kaw ron ang mas mabaul nga kantidad. Dali, magkalipay kaw kaiban ko!’ ");
INSERT INTO clu_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Kag nagparapit ra ang sorogoon nga nakabaton 1,000. Makon na, ‘Naulaman ko nga mapintas kaw kag ara kalooy nga tao, ay ginabuul mo anang ganansya ang iba nga nagpangabudlay. ");
INSERT INTO clu_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Gani ginadlukan ako. Maman dan nga ginlubung ko sa logta imong koarta. Dagi ra imong koarta.’ ");
INSERT INTO clu_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Makon anang agalun, ‘Malain kaw kag tamad nga sorogoon! Kon naulaman mo nga ginabuul ko anang ganansya ang iba nga nagapangabudlay, ");
INSERT INTO clu_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ta kondi dapat ginbutang mo akun koarta sa bangko agud kon magbalik ako mabubuul ko akun koarta pati anang saka.’ ");
INSERT INTO clu_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Makon na dayon sa ibang mga sorogoon, ‘Sigi bula nindo anang koarta kag itaw sa sorogoon nga may 10,000. ");
INSERT INTO clu_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ay ang kada isara nga masarigan tawan pa gid asta sa magdoro gid ang kanana, piro ang indi masarigan, pati ang maistan nga ginpiar kanana bulun pa gid. ");
INSERT INTO clu_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Kag ang sorogoon nga dato nga ara polos ipilak nindo sa madulum gid doto sa goa. Doto tana magapanangis kag magapabagrut anang ipun.’” ");
INSERT INTO clu_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Kon Ako nga Naging Tao magabot ron bilang Ari kaiban ang tanan nga mga angil mapongko ako dayon sa akun trono nga arianun. ");
INSERT INTO clu_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Kag ang tanan nga tao sa kalibotan magatiripon agud magatobang kanakun. Kag bulagun ko sanda dayon sa darwa ka gropo pario anang pagbulag ang manogbantay ang mga karniro sa mga kambing. ");
INSERT INTO clu_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ang mga tao nga andang kaalimbawa mga karniro ibutang ko sa akun too kag ang mga tao nga andang kaalimbawa mga kambing ibutang ko sa akun wala. ");
INSERT INTO clu_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Pagkatapos, bilang Ari magakoon ako sa mga tao nga sa akun too, ‘Kamo nga ginpakamayad ang Dios nga akun Tatay, panoblia nindo ang ginarian nga ginpriparar para kanindo alin pa ang pagimo ang kalibotan. ");
INSERT INTO clu_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ay ang gingutum ako ginpakaun nindo ako, kag ang ginwaw ako ginpainum nindo ako. Ang ako ara gid kilala ginpadayon nindo ako sa indong balay; ");
INSERT INTO clu_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ang ako ara lambong ginpalambongan nindo ako; akun pagmasakit ginatipan nindo ako; kag akun pagkapriso ginbisita nindo ako.’ ");
INSERT INTO clu_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Magasabat ang mga matarung nga sa akun too, ‘Ginoo, kano kaw namun nakita nga nagutum kag ginpakaun, okon nawaw kag ginpainum. ");
INSERT INTO clu_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Kano kaw namun nakita nga ara kaw darayonan kag ginpadayon kaw namun sa amun balay, okon ara kaw lambong kag ginpalambongan kaw namun? ");
INSERT INTO clu_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Kano ka ra namun nakita nga nagmasakit okon napriso kag ginbisita kaw namun?’ ");
INSERT INTO clu_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Kag ako nga Ari masabat, ‘Sa matood tana, kon ano indong ginimo sa akun mga kabogto bisan sa pinakakubus sa panulung ang mga tao, ginimo nindo dan kanakun.’ ");
INSERT INTO clu_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Kag magakoon ako dayon sa mga tao nga sa akun wala, ‘Alin kamo digi kanakun, kamo nga ginsompa ang Dios! Doto kamo sa kalayo nga nagadabadaba nga ara kataposan nga ginpriparar para kay Satanas kag sa anang mga angil. ");
INSERT INTO clu_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Tungud nga gingutum ako piro ara nindo ako gid pagpakauna, ginwaw ako kag ara nindo ako pagpainuma. ");
INSERT INTO clu_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Datong ara ako kilala ara nindo ako gid pagpadayona sa indong balay; ang ara ako lambong ara nindo ako pagpalambongi; pagmasakit ko kag ang pagkapriso ko ara nindo ako pagatipana.’ ");
INSERT INTO clu_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Kag magasabat sanda ra dayon, makon, ‘Ginoo, kano kaw namun nakita nga gingutum okon ginwaw, okon ara madayonan, okon ara lambong, okon nagamasakit, okon napriso nga ara kami nagbolig kanimo?’ ");
INSERT INTO clu_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Kag Ako nga Ari magasabat nga, ‘Sa matood tana, datong ara nindo pagboligi akun mga kabogto, bisan ang pinakakubus sa panulung ang mga tao, daw ako ron da ang ara nindo pagboligi.’ ");
INSERT INTO clu_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Kag dia sanda paalinun kag sisilotan ang silot nga ara kataposan. Piro ang mga matarung tana tatawan kaboi nga ara kataposan.” ");
INSERT INTO clu_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Pagkatapos nga nakatodlo si Jesus ang mga butang nga dia, nagkoon tana sa anang mga somolonod, makon na, ");
INSERT INTO clu_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Naulaman nindo nga darwa run lang ka adlaw bago magabot ang Pista anang Paglubas ang Angil, kag Ako nga Naging Tao iintriga run sa mga tao agud ilansang sa kros.” ");
INSERT INTO clu_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Sa oras ra nga dato doto sa anang palasyo ni Caifas nga pinakamataas nga pari nagtiripon ang mga manogdomara nga mga pari kag anang mga manogdomara ang mga Judio. ");
INSERT INTO clu_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ginmitingan nanda kon paiwan nanda madakup si Jesus nga indi maulaman ang mga tao, kag pagkatapos patayun dayon. ");
INSERT INTO clu_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Makon nanda, “Indi ta lang pagtaboon sa pista ay basi kon magkinagolo ang mga tao.” ");
INSERT INTO clu_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ang si Jesus doto sa banwa ang Betania, sa balay ni Simon nga dati aroon, ");
INSERT INTO clu_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","may nagparapit kanana nga sangka babai. May dara tana nga tibod-tibod nga may sulud nga maraalun nga agoa. Ginbobo na dato sa anang olo ni Jesus mintras nagakaun. ");
INSERT INTO clu_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Pagkakita dato anang mga somolonod ginugutan sanda. Makon nanda, “Basi ginoyangan na lang? ");
INSERT INTO clu_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Sarang andan dan kabaligya sa mabaul nga kantidad kag anang bayad ipanaw sa mga pobri!” ");
INSERT INTO clu_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Naulaman ni Jesus kon ano andang ginambal, gani nagkoon tana kananda, makon na, “Basi ginatoblag nindo tana? Mayad anang ginaimo nga dia kanakun. ");
INSERT INTO clu_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ang mga pobri pirmi nindo nga makakaiban, piro ako tana indi nindo pirmi makakaiban. ");
INSERT INTO clu_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ginboboan na ako ang agoa agud ipriparar akun lawas sa akun lubung. ");
INSERT INTO clu_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Sa matood tana, bisan diin iwali ang Mayad nga Barita sa bilog nga kalibotan, anang ginimo nga dia kanakun masasambit ra bilang andumanan kanana.” ");
INSERT INTO clu_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Karon, ang isara sa dosi ka apostolis nga anang aran si Judas Iscariote nagayan sa mga manogdomara nga mga pari. ");
INSERT INTO clu_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Makon na kananda, “Pira indong ibayad kanakun kon iintriga ko kanindo si Jesus?” Ginbilangan nanda nga lagi si Judas 30 ka bilog nga pilak nga koarta. ");
INSERT INTO clu_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kag alin dato nagpangita tana kaigayonan kon paiwan na maintriga si Jesus. ");
INSERT INTO clu_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ang primiro nga adlaw ang Pista ang Tinapay nga ara Pampaabok, nagparapit kay Jesus anang mga somolonod kag nagpamangkot, makon nanda, “Sa diin mo gosto nga magpriparar kami atun yapon sa Pista anang Paglubas ang Angil.” ");
INSERT INTO clu_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Makon anang sabat ni Jesus, “Magayan kamo sa siodad doto sa tao nga akun ginsogid kanindo kag konon nindo tana nga ang manogtodlo nagkoon nga nagabot ron ang oras nga tana papatayun. Magasilibrar tana kono ang Pista anang Paglubas ang Angil digi sa imong balay kaiban anang mga somolonod.” ");
INSERT INTO clu_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Gintoman dato anang mga somolonod, kag ginpriparar nanda doto ang yapon para sa pista nga dato. ");
INSERT INTO clu_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Pagkasirum, si Jesus kag anang dosi ka somolonod nagiriyapon. ");
INSERT INTO clu_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Mintras nagakaun sanda, si Jesus nagkoon, “Sogidan ko kamo ang matood, isara kanindo ang magatraidor kanakun.” ");
INSERT INTO clu_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Pagkabati dato anang mga somolonod naborido sanda nga mayad kag nagburulus-bulus sanda pamangkot kanana, makon nanda, “Ginoo, bukun ako, ano?” ");
INSERT INTO clu_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Makon ni Jesus kananda, “Isara sa mga nagasaro kanakun sa mangkok ang magatraidor kanakun. ");
INSERT INTO clu_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ako nga Naging Tao mapapatay sono sa tagna ang Kasolatan, piro kailo ra ang tao nga magatraidor kanakun. Mas mayad pa kon ara tana run lang nabata.” ");
INSERT INTO clu_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Makon dayon ni Judas nga traidor, “Sir, bukun ako, ano?” Makon ni Jesus kanana, “Ikaw ang nagakoon dan.” ");
INSERT INTO clu_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Mintras nagakaun sanda, nagbuul si Jesus ang tinapay. Ginpasalamatan na dato sa Dios kag ginpamisang-pisang na dayon. Pagkatapos gintaw na sa anang mga somolonod nga nagakoon, “Pagbuul kamo kag magkaun, maman dia akun lawas.” ");
INSERT INTO clu_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Pagkatapos nagbuul tana dayon ang irinumun kag nagpasalamat ruman sa Dios, kag gintaw na dayon kananda nga nagakoon, “Maginum kamo tanan digi, ");
INSERT INTO clu_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","tungud nga maman dia akun dogo nga iola agud doro ang mapatawad sa andang mga sala. Dia nagapamatood nga may bago ron nga kasogtanan ang Dios sa mga tao. ");
INSERT INTO clu_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Kag sogidan ko kamo, alin dadi indi ako ron maginum anang duga ang obas. Bago ako mainum ruman kon magkaraiban kita run nga maginum ang bago doto sa anang Ginarian akun Tatay.” ");
INSERT INTO clu_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Nagkanta sanda dayon mga pagdayaw sa Dios, kag pagkatapos nagayan sanda sa Bokid ang mga Olibo. ");
INSERT INTO clu_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Makon ni Jesus kananda, “Karon sa gabi tanan kamo magabaraya kanakun, ay makon ang Dios sa Kasolatan, ‘Papatayun ko ang manogbantay kag magarapta ang mga karniro.’ ");
INSERT INTO clu_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Piro pagkatapos nga ako mabanaw maona ako kanindo doto sa probinsya ang Galilea.” ");
INSERT INTO clu_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Makon ni Pedro kay Jesus, “Bisan sanda tanan magbaya kanimo ako tana indi gid!” ");
INSERT INTO clu_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Makon ni Jesus kay Pedro, “Ang matood tana, sa gabi ra nga dia, bago magtorok ang manok, katlo mo ako ron ipanginwara nga ara kaw kakilala kanakun.” ");
INSERT INTO clu_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Makon pa gid ni Pedro, “Indi ta kaw gid ipanginwara, abir patayun nanda ako pa kaiban mo!” Kag toladato ra anang koon ang tanan nga mga somolonod. ");
INSERT INTO clu_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Nagayan sanda dayon sa logar nga kon tawagun Getsemane. Pagabot nanda doto, makon ni Jesus sa anang mga somolonod, “Pagpongko kamo digi mintras nagapangamoyo ako doto sa onaan.” ");
INSERT INTO clu_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Kag gindara na si Pedro kag anang darwa ka bata ni Zebedeo. Nagabot ang kagolo sa anang isip kag masubu tana gid. ");
INSERT INTO clu_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Makon na kananda, “Daw sa mapatay ako dadi sa kalisud. Magulat kamo digi kag magirug kamo polaw kanakun.” ");
INSERT INTO clu_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Kag nagayan tana dayon sa onaan-onaan kag magpangamoyo nga nagadapa. Makon na, “Itay, abi kon maimo ilikaw kanakun ang pagantos nga magaabot. Piro bukun akun gosto ang dapat imoon, kondi kon ano ang imong kabubutun.” ");
INSERT INTO clu_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Pagbalik na sa anang mga somolonod naabotan na sanda nga nagakatorog. Gani makon na kay Pedro, “Ay dan, indi kamo gid makairug polaw kanakun bisan sangka oras lang? ");
INSERT INTO clu_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Magpolaw kamo kag magpangamoyo nga indi kamo madaug ang panolay. Naliliag kamo ra andan magpangamoyo garing indong lawas masyado karoya.” ");
INSERT INTO clu_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Kag nagpanaw roman si Jesus sa onaan-onaan kag nagpangamoyo. Makon na, “Itay kon kinanglan nga pasanun ko ang pagantos nga dan, imong kabubutun maman imong tomanun.” ");
INSERT INTO clu_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Nagbalik tana ruman sa anang mga somolonod kag naabotan na sanda ruman nga nagakatorog, ay nadoyog sanda gid nga mayad. ");
INSERT INTO clu_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Gani ginbayaan na sanda kag nagbalik tana ruman. Nagpangamoyo tana sa ikatlo ka bisis kag anang pangamoyo pario ra ang sa dati. ");
INSERT INTO clu_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Pagkatapos nagbalik tana ruman sa anang mga somolonod kag magkoon, “Ta nagakaratorog kamo pa ra gid kag nagapawayway? Sulunga nindo! Maman run dia ang oras nga Ako nga Naging Tao iintriga run sa mga makasasala! ");
INSERT INTO clu_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ta run! Way, dagi run ang tao nga matraidor kanakun!” ");
INSERT INTO clu_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Mintras nagaambal pa si Jesus nagabot si Judas nga isara sa dosi ka mga somolonod. Kag kaiban na ang dorong mga tao nga may dara nga mga ispada kag mga inoglampus. Maman dato ang mga tao nga ginpadara ang mga manogdomara nga mga pari kag mga manogdomara ang mga Judio. ");
INSERT INTO clu_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Karon, si Judas nga traidor nagkoon nga lagi sa mga manogdakup kon ano anang isinyas, nga kon sino anang arukan maman dato andang dakupun. ");
INSERT INTO clu_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Gani pagabot ni Judas diritso tana nga lagi kay Jesus kag magkoon, “Manogtodlo, mayad nga gabi.” Kag ginarukan na dayon. ");
INSERT INTO clu_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Makon ni Jesus kanana, “Amigo, sigi, imoa run kon ano imong ginayan digi.” Kag ginparapitan nanda si Jesus kag gindakup. ");
INSERT INTO clu_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Isara sa anang kaiban ni Jesus ang naggabot anang ispada kag ginlabo na anang oripun ang pinakamataas nga pari kag natigbas anang talinga. ");
INSERT INTO clu_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Makon ni Jesus kanana, “Ibalik sa taguban imong ispada! Ang nagagamit ang ispada sa ispada ra mapapatay. ");
INSERT INTO clu_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ara kaw sigoro kaulam nga sarang ako makapangayo bolig sa akun Tatay kag lagi-lagi padaran na ako sobra dosi ka batalyon nga mga angil. ");
INSERT INTO clu_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Garing kon toladan akun imoon paiwan anang pagkatoman ang Kasolatan nga toladia ang dapat matabo?” ");
INSERT INTO clu_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Makon dayon ni Jesus sa mga tao, “Basi kinanglan gid nga magdara kamo pa ang mga ispada kag mga inoglampus sa pagdakup kanakun? Ano ako tolisan? Kabay adlaw-adlaw dian ako sa timplo nga nagatodlo kag doto kamo ra. Ta basi ara nindo ako nga lagi pagdakupa? ");
INSERT INTO clu_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Piro dia tanan nagakaratabo agud matoman ang ginsolat ang mga propita sa Kasolatan parti kanakun.” Pagkaambal dato ni Jesus ginbayaan tana anang mga somolonod kag nagparalagyaw sanda tanan. ");
INSERT INTO clu_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Kag gindara dayon si Jesus ang mga nagdakup kanana doto kay Caifas nga maman ang pinakamataas nga pari. Doto ra nagtiripon ang mga manogtodlo ang Kasogoan kag anang mga manogdomara ang mga Judio. ");
INSERT INTO clu_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Si Pedro nagsonod ra, garing marayu anang antad kay Jesus. Pagabot nanda sa balay ang pinakamataas nga pari, nagsulud tana sa lagwirta kag nagpongko tana doto kaiban ang mga goardia agud makita na kon ano ang matatabo kay Jesus. ");
INSERT INTO clu_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ang mga manogdomara nga mga pari kag ang tanan nga mimbro ang konsilyo ang mga Judio nagpangita ang mga botig nga ibidinsya kontra kay Jesus agud ipapatay nanda tana. ");
INSERT INTO clu_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Piro bisan doro ang nagparapit kag nagsogid ang botig kontra kay Jesus, ara sanda ra gid may nakita nga ibidinsya agud sarang nanda tana nga ipapatay. Ang ori may darwa ka tao nga nagprisintar, ");
INSERT INTO clu_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","kag makon nanda, “Nabatian namun ang tao nga dia nga nagkoon nga sarang na kono nga gubaun anang timplo ang Dios kag sa sulud tatlo ka adlaw patindugun na ruman.” ");
INSERT INTO clu_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Gani nagtindug ang pinakamataas nga pari kag magpamangkot kay Jesus, makon na, “Ta ara kaw isabat sa mga akosasyon nga dan kontra kanimo?” ");
INSERT INTO clu_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ara gid naglimug-limug si Jesus. Makon roman ang pinakamataas nga pari, “Sogidi kami sa atobangan ang Dios nga nagapamati. Ano, ikaw ra gid bala ang Cristo nga Bata ang Dios?” ");
INSERT INTO clu_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Makon ni Jesus kanana, “Ginambal mo, kag sogidan ko kamo, alin dadi makikita nindo Ako nga Naging Tao nga nagapongko sa anang too ang Makagagaum nga Dios, kag makikita nindo ako ra sa mga panganod sa langit nga nagabalik digi sa kalibotan.” ");
INSERT INTO clu_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Pagkabati dato ang pinakamataas nga pari ginisak na anang lambong sa anang kasilag nga nagakoon, “Nagpasipala tana sa Dios! Indi ta run kinanglan ang mga tistigos! Nabatian nindo ron mismo anang pagpasipala sa Dios! ");
INSERT INTO clu_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ta ano sa kanindo?” Makon nanda, “Dapat patayun tana.” ");
INSERT INTO clu_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Kag gindoraan nanda dayon anang oyaun kag ginboroligan sombag. Kag ang mga nagsampal kanana ");
INSERT INTO clu_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","nagkoon, “Abi, kon ikaw gid manda ang Cristo, pintoa kon sino ang nagsampal kanimo.” ");
INSERT INTO clu_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Si Pedro tana doto pa ra gid sa lagwirta nagapongko. Karon, may nagparapit kanana nga sorogoon nga babai ang Pinakamataas nga Pari. Makon na, “Kabay kaiban kaw ni Jesus nga taga-Galilea?” ");
INSERT INTO clu_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Piro ginpanginwara dato ni Pedro sa tanan nga mga tao doto sa goa. Makon na, “Ara ako kaulam kon ano imong ginakoon.” ");
INSERT INTO clu_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Kag nagayan tana dayon sa may poirtaan. Nakita tana ang sangka sorogoon roman nga babai, kag makon na sa mga tao doto, “Dia nga tao anang kaiban ra ni Jesus nga taga-Nazaret.” ");
INSERT INTO clu_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Kag nagpanginwara ruman si Pedro nga nagakoon, “Ara ako baya kakilala sa tao nga dan nga indong ginakoon. Sompa pa!” ");
INSERT INTO clu_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Kag lagat-lagat nagparapit kay Pedro ang mga tao doto. Makon nanda, “Anang kaiban ka ra gid ni Jesus, ay anang ponto indong ambal pario.” ");
INSERT INTO clu_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Kag nagpanompa run gid si Pedro nga nagakoon, “Mapatay ako pa! Ara ako gid baya kakilala sa tao nga dan nga indong ginakoon.” Pagkatapos na ambal, nagtorook nga lagi ang manok. ");
INSERT INTO clu_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Kag nadumduman dayon ni Pedro anang ginambal ni Jesus kanana nga, “Bago magtorook ang manok, katlo mo ako ron ipanginwara nga ara kaw kakilala kanakun.” Gani dayon tanang goa kag nagpanangis nga mayad. ");
INSERT INTO clu_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Pagkaaga, aga pa gid, nagmiting ang mga manogdomara nga mga pari kag anang mga manogdomara ang mga Judio kon ano andang imoon para maipapatay nanda si Jesus. ");
INSERT INTO clu_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Pagkatapos gingapos nanda tana kag gindara nanda dayon doto kay Pilato nga Gobirnador kag ginintriga dayon kanana. ");
INSERT INTO clu_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Pagkaulam ni Judas nga nagtraidor kay Jesus nga ginsintinsyaan run si Jesus nga patayun, nagnusul tana kag nagayan sa mga manogdomara nga mga pari kag mga manogdomara nga mga Judio agud ioli ang 30 ka bilog nga pilak nga koarta. ");
INSERT INTO clu_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Makon na, “Nagkasala ako tungud nga ginintriga ko kanindo ang tao nga ara gid sala.” Makon nanda, “Ano ra amun labut? Baala kaw dian!” ");
INSERT INTO clu_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Sinaboag ni Judas ang koarta doto sa sulud ang timplo. Naggoa tana dayon kag ginbitay na anang kaogalingun. ");
INSERT INTO clu_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Kag ang koarta nga nagrapta ginpamorot ang mga manogdomara nga mga pari. Makon nanda, “Dia nga koarta indi maimo nga ibutang sa burutangan ang koarta ang timplo ay kontra dia sa atun kasogoan tungud nga maman dia ang koarta nga ginbayad agud ipapatay ang sangka tao.” ");
INSERT INTO clu_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ang ori nagkarasogot sanda nga ang koarta nga dato ibakal anang logta ang manogimo ang koron agud imoon nanda nga rulubungan para sa mga taga-ibang logar. ");
INSERT INTO clu_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Maman dan nga asta dadi ang logta nga dato ginatawag nga Nadogoan nga Logta. ");
INSERT INTO clu_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Doto sa natabo nga dato natoman anang gintagna ni propita Jeremias nga nagkoon, “Ginbuul nanda ang 30 ka bilog nga pilak nga koarta nga ginkarasogotan anang mga kaapo-apoan ni Israel nga ibakal kanana, ");
INSERT INTO clu_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","kag ang koarta nga dato maman andang ginbakal anang logta ang manogimo ang koron, sono sa anang sogo kanakun ang Ginoo.” ");
INSERT INTO clu_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Karon, ang si Jesus doto ron kay Pilato ginpamangkot tana ni Pilato, makon na, “Ikaw gali anang ari ang mga Judio?” Makon anang sabat ni Jesus, “Ginambal mo.” ");
INSERT INTO clu_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Garing sa anang mga akosasyon ang mga manogdomara nga mga pari kag anang mga manogdomara ang mga Judio kontra kay Jesus ara tana gid nagsabat kananda. ");
INSERT INTO clu_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Gani makon ni Pilato kanana, “Basi ara kaw gid nagasabat sa andang mga akosasyon nga dia kontra kanimo?” ");
INSERT INTO clu_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Kag ara ra gid nagsabat si Jesus, gani natingala nga mayad ang Gobirnador. ");
INSERT INTO clu_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Nakaogalian ang Gobirnador nga kada Pista anang Paglubas ang Angil nagabolyaw tana sangka priso nga ginapangayo ang mga tao. ");
INSERT INTO clu_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Sa oras nga dato may bantog doto nga priso nga anang aran si Barabas. ");
INSERT INTO clu_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Datong nagatiripon ron ang mga tao, nagpamangkot si Pilato, makon na, “Sino indong gosto nga akun bolyawan, si Barabas okon si Jesus nga ginatawag nga Cristo?” ");
INSERT INTO clu_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ay naulaman ni Pilato nga naakig ang mga manogdomara kay Jesus, maman dato nga ginakosar nanda si Jesus doto kanana. ");
INSERT INTO clu_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Mintras nagapongko si Pilato doto sa ukuman, ginpasogoan tana anang asawa nga nagakoon, “Indi mo gid pagpasilabutan ang matarung nga dan nga tao, ay kagabi sugung akun pamati tungud sa akun damgo parti kanana.” ");
INSERT INTO clu_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Piro anang ginimo ang mga manogdomara nga mga pari kag anang mga manogdomara ang mga Judio, ginkombinsir nanda ang mga tao nga si Barabas andang pangayoon nga bolyawan kag si Jesus tana ipapatay. ");
INSERT INTO clu_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Gani nagpamangkot roman ang Gobirnador, makon na, “Sino sa darwa nga dia indong gosto nga akun bolyawan?” Makon nanda, “Si Barabas!” ");
INSERT INTO clu_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Makon ni Pilato, “Ta ano tana akun imoon kay Jesus nga ginatawag nga Cristo?” Nagsabat sanda tanan, “Ilansang sa kros!” ");
INSERT INTO clu_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Makon ni Pilato kananda, “Ay basi, ano nga sala anang naimo?” Kag nagbaskug pa gid andang pagsiringgit, makon, “Ilansang sa kros!” ");
INSERT INTO clu_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pagkakita ni Pilato nga ara tana run maimo ay ang mga tao nagakinagolo ron, nagpabuul tana ang tobig kag nagpangogas mismo sa atobangan ang mga tao. Makon na, “Ako ara sarabatun sa anang kamatayun. Kamo ang baala. Limpyo akun alima.” ");
INSERT INTO clu_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Makon anang sabat ang mga tao, “Sigi, kami ang baala. Kami kag amun mga bata maman ang mapanabat sa anang kamatayun.” ");
INSERT INTO clu_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Kag ginbolyawan dayon ni Pilato si Barabas. Piro si Jesus tana anang ginpaanot kag ginintriga sa mga soldado agud ilansang sa kros. ");
INSERT INTO clu_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Kag gindara ang mga soldado si Jesus doto sa palasyo ang Gobirnador, kag nagtiripon doto kanana ang sangka batalyon nga mga soldado. ");
INSERT INTO clu_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ginobaan nanda tana kag ginpasoksokan ang kapa nga granati. ");
INSERT INTO clu_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Pagkatapos nagimo sanda ang koro-korona nga poros siit kag ginsoksok nanda dayon sa anang olo ni Jesus. Kag ginpakaputan nanda sa anang too nga alima ang baston-baston. Pagkatapos naglood-lood sanda dayon kanana kag nagyagota nga nagakoon, “Dayawon anang Ari ang mga Judio!” ");
INSERT INTO clu_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Gindoraan nanda tana dayon kag ginbuul anang ginakaputan nga baston-baston kag ginpikan lampus anang olo. ");
INSERT INTO clu_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Pagkatapos andang yagota, ginoba nanda ang kapa kag ginpasoksok roman anang lambong. Gindara nanda tana dayon sa goa agud ilansang sa kros. ");
INSERT INTO clu_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ang doto sanda run sa dalan sa goa ang siodad may nasoblang sanda nga tao nga si Simon nga taga-Cirene. Ginpirit nanda tana nga magpasan anang kros ni Jesus. ");
INSERT INTO clu_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Pagabot nanda sa logar nga ginatawag Golgota (nga kon sayodon logar nga midyo sa bongo), ");
INSERT INTO clu_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ginpainum nanda si Jesus ang bino nga may lakut nga mapait. Piro pagkatiraw na dato, ara na run paginuma. ");
INSERT INTO clu_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ginlansang nanda tana dayon sa kros. Pagkatapos ginparti-parti nanda anang mga lambong paagi sa pagbonot-bonot. ");
INSERT INTO clu_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Kag pagkatapos dato nagporongko sanda kag magbantay kanana. ");
INSERT INTO clu_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Sa anang oloan nagbutang sanda ang karatola sa kros. Ginsolat nanda doto ang akosasyon kontra kanana nga nagakoon, “Maman dia si Jesus nga anang Ari ang mga Judio.” ");
INSERT INTO clu_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","May darwa ra doto ka tolisan nga andang ginpadungan lansang kay Jesus. Ang isara sa anang too kag ang isara sa anang wala. ");
INSERT INTO clu_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ang mga tao nga nagarulubas doto sa marapit nagtarango-tango andang olo nga nagainsolto kag nagayagota kay Jesus. ");
INSERT INTO clu_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Makon nanda, “Gubaun mo kabay ang timplo kag sa sulud tatlo ka adlaw patindugun mo roman. Ta abi lowasa run imong kaogalingun! Abi kon ikaw manda anang Bata ang Dios, paglosong dian sa kros!” ");
INSERT INTO clu_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Kag toladato ra anang yagota ang mga manogdomara nga mga pari, ang mga manogtodlo ang Kasogoan, kag ang mga manogdomara ang mga Judio. ");
INSERT INTO clu_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Makon nanda, “Ginlowas na ang iba, piro indi tana makalowas anang kaogalingun! Kabay Ari tana kono ang Israel! Ta maglosong tana sa kros, kag matoo kita kanana! ");
INSERT INTO clu_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Nagakoon tana nga nagasarig tana sa Dios, kag anang Bata tana kono ang Dios! Ta kondi lowasun tana ang Dios kon palangga na tana manda!” ");
INSERT INTO clu_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Toladan ra anang yagota ang mga tolisan nga ginlansang kaiban na. ");
INSERT INTO clu_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Pagabot ang ogtong adlaw nagdulum ang kalibotan sa sulud tatlo ka oras. ");
INSERT INTO clu_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Kag pagalas tris ang apon nagsinggit si Jesus ang mabaskug, makon na, “Eli, Eli, lama sabactani?” Anang gostong ambalun dato, “Dios ko, Dios ko, basi ginpabayanan mo ako?” ");
INSERT INTO clu_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Makon ang iba nga nagatirindug doto nga nakabati anang ginsinggit, “Ginatawag na si Elias!” ");
INSERT INTO clu_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","May sangka tao doto nga nagdalagan kag nagbuul isponga. Gintosmog na dato sa maaslum nga bino kag gintakud na sa sangka sanga kag ginsulsul na dayon sa anang baba ni Jesus agud supsupun na. ");
INSERT INTO clu_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Piro makon ang iba, “Sulungun ta abi kon maabot manda si Elias agud lowasun tana.” ");
INSERT INTO clu_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Kag nagsinggit tana ruman ang mabaskug kag nabogto anang ginawa. ");
INSERT INTO clu_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Kag sa oras ra nga dato ang kortina sa sulud ang Timplo ang Jerusalem nagisak sa tunga alin sa ibabaw paidalum. Ay naglinog kag pati ang mga pangpang nagkarabuka ");
INSERT INTO clu_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","asta ang mga rulubungan nagkaraabrian. Doro nga mga tao nga nagtoo sa Dios nga patay run ang nagkarabanaw. ");
INSERT INTO clu_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ay pagkabanaw ni Jesus naggoa sanda sa andang mga rulubungan kag nagsulud sanda sa balaan nga siodad ang Jerusalem kag dorong tao ang nakakita kananda. ");
INSERT INTO clu_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Pagkakita ang kapitan kag anang mga soldado nga nagabantay kay Jesus ang paglinog kag sa mga nagkaratabo ginkulbaan sanda nga mayad. Makon nanda, “Matood ra gid nga anang Bata tana ang Dios!” ");
INSERT INTO clu_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Doto sa marayu-rayu may mga babai nga nagasurulung. Sanda maman ang nagtarabid kag nagasikaso kay Jesus alin pa sa Galilea. ");
INSERT INTO clu_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Kabilang kananda si Maria Magdalena, si Maria nga anang nanay ni Santiago kag ni Jose, kag anang asawa ni Zebedeo. ");
INSERT INTO clu_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Pagkaapon may nagabot nga sangka manggaranun nga taga-Arimatea. Anang aran si Jose kag isara tana ra sa anang mga somolonod ni Jesus. ");
INSERT INTO clu_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ginayanan na si Pilato kag ginpangayo na anang bangkay ni Jesus. Kag nagsogo si Pilato nga itaw kanana. ");
INSERT INTO clu_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Pagkabuul ni Jose anang bangkay ni Jesus ginbarubudan na ang bago nga panaptun nga poti. ");
INSERT INTO clu_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Si Jose nga dia may bago lang nga ginpaimo nga rulubungan para sa anang kaogalingun. Ang rulubungan nga dato boo nga ginimo sa pangpang ang banggilid kag midyo ron sa giub. Doto na ginpasulud anang bangkay ni Jesus. Kag nagpaligid tana dayon ang mabaul nga bato bilang anang takup ang ginlubungan. Pagkatapos nagpanaw tana dayon. ");
INSERT INTO clu_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Nagpasala doto si Maria nga taga-Magdala kag ang isara pa gid nga Maria. Nagapongko sanda nga nagatobang sa ginlubungan. ");
INSERT INTO clu_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ang madason nga adlaw, adlaw dato nga Sabado, ang mga manogdomara nga mga pari kag mga Pariseo nagayan kay Pilato. ");
INSERT INTO clu_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Makon nanda, “Alangdun nga Gobernador, nadumduman namun nga ang boi pa ang tao nga dato nga manogpatalang, nagkoon tana nga tana kono mababanaw pagkatapos tatlo ka adlaw. ");
INSERT INTO clu_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Gani mayad sigoro pabantayan mo ang ginlubungan kanana sa sulud tatlo ka adlaw, ay basi kon ang bangkay takawon anang mga somolonod kag sogidan nanda dayon ang mga tao nga nabanaw tana. Kag kon dia matabo magagoa nga andang panloko maging mas sobra pa sa dati.” ");
INSERT INTO clu_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Makon ni Pilato kananda, “May goardia kamo. Kamo mismo ang magpabantay sono sa indong naulaman.” ");
INSERT INTO clu_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Gani nagayan sanda sa ginlubungan, kag ginmarkaan nanda anang takup agud maulaman kon may magbokas. Kag ginsala nanda dayon doto andang mga goardia. ");
INSERT INTO clu_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Pagkatapos ang Adlaw nga Inogpaway, aga pa gid ang Domingo, nagayan si Maria nga taga-Magdala kag ang isara pa nga Maria doto sa ginlubungan ay gosto nanda magsulung. ");
INSERT INTO clu_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Karon golpi lang nga naglinog ang mabaskug, ay nagtugpa anang angil ang Ginoo alin sa langit kag ginpaligid na ang bato nga nagatakup sa ginlubungan kag ginpongkoan na dayon. ");
INSERT INTO clu_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Anang itsora masyado ka solaw nga daw kilat, kag anang lambong mapoti gid nga mayad. ");
INSERT INTO clu_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ang mga goardia nga nagabantay doto nagkurulkug sa kaadluk kag nagkaradismayo. ");
INSERT INTO clu_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Makon ang angil sa mga babai, “Indi kamo magkaadluk. Naulaman ko kon basi nagayan kamo digi. Ginapangita nindo si Jesus nga ginlansang sa kros. ");
INSERT INTO clu_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ara tana run digi tungud nga nabanaw tana pario anang ginkoon kanindo. Dali kamo digi, sulunga nindo ang ginbutangan kanana.” ");
INSERT INTO clu_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Pagkatapos makon ang angil kananda, “Ta ayani nindo nga lagi anang mga somolonod, kag sogidan nindo sanda nga nabanaw tana run, kag maona tana doto sa Galilea. Doto nindo tana makikita. Indi nindo paglipatan akun ginsogid nga dia kanindo.” ");
INSERT INTO clu_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Gani dali-dali sanda nga nagalin doto sa ginlubungan. Ginaadlukan sanda piro nalipay sanda ra nga mayad sa barita nga dato mintras nagadalagan sanda agud sogidan anang mga somolonod. ");
INSERT INTO clu_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Malagat-lagat nasoblang nanda si Jesus nga nagpangomosta kananda. Kag nagparapit sanda dayon kay Jesus kag maglood kanana. Ginakus nanda anang siki ni Jesus kag nagsimba sanda dayon kanana. ");
INSERT INTO clu_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Makon ni Jesus kananda, “Indi kamo magkaadluk. Ayani nindo akun mga kabogto kag konon nindo sanda nga magayan sanda doto sa Galilea. Doto makikita nanda ako.” ");
INSERT INTO clu_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Pagkaalin ang mga babai sa ginlubungan, ang iba nga mga goardia nagpanaw ra kag nagayan doto sa siodad kag ginsogid nanda sa mga manogdomara nga mga pari ang tanan nga natabo doto sa ginlubungan. ");
INSERT INTO clu_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Gani nagmiting ang mga manogdomara nga mga pari kaiban ang mga manogdomara ang mga Judio. Kag nagkarasogot sanda nga tawan dorong koarta ang mga soldado agud indi sanda magsogid kon ano gid ang matood nga natabo. ");
INSERT INTO clu_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Gintodloan nanda ang mga soldado kon ano andang isogid sa mga tao. Makon nanda, “Sogidan nindo ang mga tao nga mintras nagakatorog kamo kagabi nagabot anang mga somolonod kag gintakaw nanda anang bangkay ni Jesus. ");
INSERT INTO clu_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Kag kon alimbawa mabatian dia ang Gobirnador kami run ang baala kanana agud indi kamo maiwan.” ");
INSERT INTO clu_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Gani ginbaton nanda ang koarta kag gintoman nanda dayon ang ginapasogid kananda. Gani asta dadi maman ra dia nga istorya anang ginapalapnag ang mga Judio. ");
INSERT INTO clu_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Karon, nagayan ang onsi ka somolonod ni Jesus doto sa Galilea, sa bokid nga anang ginkoon kananda. ");
INSERT INTO clu_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Pagkakita nanda kanana nagsimba sanda, piro ang iba tana nagpandoa-doa nga si Jesus gid andang nakita. ");
INSERT INTO clu_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Nagparapit si Jesus kananda kag magkoon, makon na, “Ang tanan nga gaum sa langit kag sa logta gintaw kanakun. ");
INSERT INTO clu_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Gani ayani nindo ang mga tao sa tanan nga mga banwa. Kag imoon nindo sanda nga akun mga somolonod. Bunyagan nindo sanda sa aran ang Amay, ang Anak, kag ang Ispirito Santo. ");
INSERT INTO clu_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Todloan nindo sanda nga tomanun ang tanan nga akun ginsogo kanindo. Kag dumdumun nindo nga ako kaiban nindo pirmi asta sa kataposan ang kalibotan.”");
INSERT INTO clu_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Maman dia ang Mayad nga Barita parti kay Jesu-Cristo nga Bata ang Dios. ");
INSERT INTO clu_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Nagompisa dia ang matoman anang gintagna ni Isaias nga propita. Ang ona pa gid ginsolat ni Isaias anang ambal ang Dios sa anang Bata nga nagakoon: “Paonaun ko kanimo akun manogbarita agud ipriparar na imong aragian. ");
INSERT INTO clu_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ang tao nga dia maman ang magawali mabaskug nga mababatian ang mga tao sa naligwin nga logar; magakoon tana, ‘Ang Ginoo paraaboton ron. Awani nindo anang aragian.’” ");
INSERT INTO clu_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","5","Kag dia natoman gani anang pagabot ni Juan nga manogbunyag sa naligwin nga logar. Dorong tao ang nagarayan doto kanana nga alin sa tanan nga banwa ang Judea, kag doro gid ang alin sa Jerusalem. Ginwalian sanda dayon ni Juan nga dapat inulsulan nanda run kag magparabunyag dayon agud ipakita nga ginabayaan nanda run andang mga sala, kag patawadun sanda ang Dios. Kag ang mga tao nga nagkilala nga sanda nagkasala ginbunyagan na sa soba ang Jordan. ");
INSERT INTO clu_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Anang lambong ni Juan bolbol ang sapat nga kamilyo nga ginabul kag anang akus panit. Anang ginakaun apan kag dugus. ");
INSERT INTO clu_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Pirmi na nga ginasambit sa anang pagsaysay nga nagakoon, “May maabot nga nagasonod kanakun nga mas gamanan pa kanakun kag indi ako bagay bisan maging anang sorogoon.” ");
INSERT INTO clu_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Makon na pa, “Ako nagabunyag kanindo sa tobig, piro tana magabunyag kanindo sa Ispirito Santo.” ");
INSERT INTO clu_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Sa mga tyimpo nga dato nagabot doto si Jesus alin sa Nazaret nga sakup ang probinsya ang Galilea, kag nagpabunyag tana kay Juan sa soba ang Jordan. ");
INSERT INTO clu_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Pagtakas ni Jesus sa tobig, lagi-lagi nakita na nga nagabri ang langit, kag ang Ispirito Santo nagtugpa kanana nga midyo sa salampati. ");
INSERT INTO clu_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Kag nabatian ang limug nga alin sa langit nga nagakoon, makon, “Ikaw maman akun pinalangga nga Bata. Nalilipay ako nga mayad kanimo.” ");
INSERT INTO clu_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Dato ra nga lagi ginpaayan tana ang Ispirito Santo sa naligwin nga logar. ");
INSERT INTO clu_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Kag doto tana nagtinir sa sulud 40 ka adlaw nga ginsolay ni Satanas. May mga mapintas nga mga sapat doto, piro ginboligan tana ang mga angil. ");
INSERT INTO clu_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Pagkapriso kay Juan nga manogbunyag, nagayan si Jesus sa Galilea kag nagpangwalian doto parti sa Mayad nga Barita nga alin sa Dios. ");
INSERT INTO clu_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Makon na, “Maman run dia ang oras nga anang gintagna ang mga propita ang ona. Marapit run gid nga magari ang Dios. Gani inulsuli nindo indong mga sala kag magtoo kamo sa Mayad nga Barita.” ");
INSERT INTO clu_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","May sangka adlaw nga mintras nagapanaw si Jesus sa baybay ang Dagat ang Galilea, nakita na ang magkabogto nga si Simon kag si Andres nga nagapangisda. Dia sanda mga manogpangisda. ");
INSERT INTO clu_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Makon ni Jesus kananda, “Dali, pagtabid kamo kanakun ay bukun run isda indong pangitaun kondi todloan ko kamo nga magpangita ang mga tao nga maging akun mga somolonod.” ");
INSERT INTO clu_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Kag ginbayaan nanda nga lagi andang mga lambat kag nagsonod kanana. ");
INSERT INTO clu_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Pagkatapos, nagpadayon tana panaw, kag sa onaan nakita na ra ang magkabogto nga si Santiago kag si Juan nga mga bata ni Zebedeo. Doto sanda sa andang sakayan nga nagapamona andang mga lambat. ");
INSERT INTO clu_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Pagkakita na kananda gintawag na sanda ra. Kag lagi-lagi ginbayaan nanda ra andang tatay nga si Zebedeo doto sa sakayan kag nagtabid kay Jesus. Ang mga tao nga andang ginasolan maman ang nabilin nga kaiban andang tatay. ");
INSERT INTO clu_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Nagayan sanday Jesus sa banwa ang Capernaum. Pagabot ang Sabado nga maman ang Adlaw nga Inogpaway ang mga Judio, nagsulud si Jesus sa simbaan ang mga Judio kag nagtodlo. ");
INSERT INTO clu_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Natingala nga mayad ang mga tao nga nakabati kanana tungud nga nagtodlo tana nga may awtoridad, kag bukun pario sa mga manogtodlo ang Kasogoan. ");
INSERT INTO clu_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Sa mga tao doto nga nagatiripon may doto nga may mga malain nga ispirito nga nagsinggit ");
INSERT INTO clu_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","nga nagakoon, “Jesus nga taga-Nazaret, ano imong labut kanamun? Nagayan kaw bala digi agud madora kami? Naulaman ko kon sino kaw. Ikaw ang matarung nga bata ang Dios.” ");
INSERT INTO clu_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ginsaway ni Jesus ang malain nga ispirito, makon na, “Pagipus dian kag maggoa sa tao nga dan!” ");
INSERT INTO clu_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ang tao nga dato ginpakulkug nga mayad ang malain nga ispirito nga nagasinggit nga nagagoa kanana. ");
INSERT INTO clu_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Natingala nga mayad ang mga tao, gani makon nanda, “Ano kabay dia? Bago dia nga klasi nga mga pagpanodlo. Bisan ang mga malain nga ispirito ginamandaran na kag nagatoman kanana.” ");
INSERT INTO clu_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Gani madali nga nagrapta ang barita parti kay Jesus sa bilog nga probinsya ang Galilea. ");
INSERT INTO clu_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Pagkagoa nanda sa anang simbaan ang mga Judio, nagayan sanda sa anang balay ang magkabogto nga si Simon kag si Andres. Nagtabid ra si Santiago kag si Juan. ");
INSERT INTO clu_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ang oras ra nga dato nagaingga anang panogangan nga babai ni Simon ay may ragnat. Ginsogidan nanda si Jesus nga anang panogangan nga babai ni Simon nagamasakit. ");
INSERT INTO clu_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Gani ginparapitan tana ni Jesus kag ginkaputan na anang alima kag pabangonon. Dato ra nga lagi nagayad tana kag ginimusan na pagkaun sanday Jesus. ");
INSERT INTO clu_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Pagkasirum ginpangdara ang mga tao kanana ang tanan nga nagamarasakit kag ang mga may malain nga ispirito. ");
INSERT INTO clu_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Doro gid nga mga tao sa banwa ang nagtiripon sa atobangan ang balay. ");
INSERT INTO clu_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Dorong nagamarasakit anang ginpangayad sa sari-sari nga mga masakit kag doro ra nga mga malain nga ispirito anang ginpalayas. Ara na pagtogoti nga magambal ang mga malain nga ispirito ay kilala nanda gid kon sino tana. ");
INSERT INTO clu_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ang madason nga adlaw, madulumdulum pa, nagbangon si Jesus kag nagayan sa naligwin nga logar kag nagpangamoyo. ");
INSERT INTO clu_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Pagkaaga ginpangita tana ni Simon kag anang mga kaiban. ");
INSERT INTO clu_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Pagkakita nanda kay Jesus makon nanda, “Ginapangita kaw ang tanan.” ");
INSERT INTO clu_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Piro makon na kananda, “Ta run, maayan kita sa marapit nga mga banwa agud makawali ako ra doto, ay maman dia ang kabangdanan kon basi nagayan ako digi sa kalibotan.” ");
INSERT INTO clu_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Gani ginlibot ni Jesus ang bilog nga Galilea nga nagawali sa mga simbaan ang mga Judio kag nagapalayas ang mga malain nga ispirito sa mga tao nga andang ginsuludan. ");
INSERT INTO clu_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","May aroon nga nagparapit kay Jesus. Naglood tana nga nagapakitloy, makon na, “Nagapati ako nga mapaayad mo ako sa akun masakit nga marisna kon gosto mo.” ");
INSERT INTO clu_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Nalooy nga mayad si Jesus kanana. Gani gintandug na nga nagakoon, “Gosto ko. Sigi, mayad kaw ron.” ");
INSERT INTO clu_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Kag lagi-lagi nadora anang aro kag naglimpyo anang panit. ");
INSERT INTO clu_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ginpaandaman na dayon ang aroon nga dato, makon na, ");
INSERT INTO clu_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Indi kaw gid magpanogid-sogid bisan kino, kondi magdiritso kaw sa pari kag magpasulung kanana. Kag magalad kaw dayon ang alad nga ginsogo ni Moises agud mapamatodan ang mga tao nga mayad ka run.” ");
INSERT INTO clu_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Piro anang ginimo tana ang tao nga dato, nagpanaw tana kag ginpamarita na ang natabo kanana. Gani naglapnag ang barita parti sa natabo nga dato asta nga si Jesus indi run makaayan sa mga banwa ay nagadaragusu nga mayad ang mga tao kanana. Doto tana run lang nagtinir sa naligwin nga logar. Piro padayon pa ra gid anang pagayan ang mga tao doto kanana alin sa iba-ibang mga logar. ");
INSERT INTO clu_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Magpira ka adlaw, nagbalik si Jesus sa Capernaum. Naglapnag ang barita nga tana doto sa anang balay. ");
INSERT INTO clu_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Gani dorong tao ang nagtiripon doto asta nga napono ang balay kag bisan sa goa ang poirtaan nagadurukdukan ang mga tao. Ginsaysay na kananda anang Ambal ang Dios. ");
INSERT INTO clu_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Karon may nagabot ra doto nga paralitiko nga ginakarantoangan ang apat ka tao. ");
INSERT INTO clu_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Piro tungud nga nagagurutuk ang mga tao indi sanda makaparapit kay Jesus. Gani andang ginimo, gingoaban nanda ang atup doto sa anang tungud ni Jesus. Pagkatapos gintonton nanda dayon ang paralitiko nga nagaingga sa anang iringgaan. ");
INSERT INTO clu_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Pagkakita ni Jesus nga mabaul andang pagtoo kanana, makon na sa paralitiko, “Imong mga sala ginpatawad run.” ");
INSERT INTO clu_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","May mga manogtodlo ang Kasogoan nga nagaporongko doto nga nakabati. Sa andang isip-isip lang makon nanda, ");
INSERT INTO clu_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Basi kabay nagambal toladan ang tao nga dia? Kontra sa Dios anang ambal nga dan, ay ara may makapatawad ang mga sala kondi ang Dios lang.” ");
INSERT INTO clu_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Naulaman ra nga lagi ni Jesus andang ginaisip. Gani makon na kananda, “Basi nagaisip kamo toladan? ");
INSERT INTO clu_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Diin bala ang mas maulas, ang magkoon sa paralitiko nga ‘Imong mga sala ginpatawad run,’ okon ang magkoon nga ‘Pagtindug, kag dara imong iringgaan kag magpanaw’? ");
INSERT INTO clu_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Dadi pamatodan ko kanindo paagi sa pagayad ang paralitiko nga dia nga Ako nga Naging Tao may gaum digi sa kalibotan sa pagpatawad ang mga sala.” ");
INSERT INTO clu_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Makon na dayon sa paralitiko, “Pagtindug, dara imong iringgaan kag magoli!” ");
INSERT INTO clu_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Mintras nagasurulung sanda, nagtindug ang paralitiko kag gindara na anang iringgaan kag naggoa. Tanan sanda natingala nga mayad kag gindayaw nanda ang Dios. Makon nanda, “Ara kita pa gid kakita ang toladia.” ");
INSERT INTO clu_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Pagkatapos dato nagbalik ruman si Jesus sa baybay ang Dagat ang Galilea. Dorong tao ang nagarayan doto kanana, gani gintodloan na sanda. ");
INSERT INTO clu_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Pagkatapos dayon tanang panaw kag nakita na ang manogsokot ang bois nga si Levi nga bata ni Alfeo. Doto tana nagapongko sa sulud anang opisina. Makon ni Jesus kanana, “Dali, pagsonod kanakun.” Kag nagtindug ra dayon si Levi kag nagsonod kanana. ");
INSERT INTO clu_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Mintras nagakaun si Jesus kag anang mga somolonod doto sa balay ni Levi, doro andang kaiban nga mga manogsokot ang bois kag iba pa nga ginakilala kono nga mga makasasala, ay doro ron ang nagasoronod kanana. ");
INSERT INTO clu_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","May doto ra nga mga manogtodlo ang Kasogoan nga mga Pariseo. Nakita nanda si Jesus nga nagakaun kaiban ang mga tao nga andang ginabilang nga mga makasasala pario sa mga manogsokot ang bois. Nagpamangkot sanda sa anang mga somolonod, makon nanda, “Basi nagadapun tana kaun sa toladan nga mga tao?” ");
INSERT INTO clu_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Dato nga pamangkot nabatian ni Jesus, gani ginsabat na sanda paagi sa paanggid; makon na, “Bukun ang mga tao nga mayad andang lawas ang nagakinanglan ang manogbolong, kondi ang nagamasakit. Gani ara ako nagayan digi agud tawagun ang mga tao nga nagakabig sa andang kaogalingun nga sanda matarung, kondi nagayan ako tana digi para sa mga tao nga nagaako nga sanda makasasala.” ");
INSERT INTO clu_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Anang mga somolonod ni Juan nga manogbunyag kag ang mga Pariseo nagaporoasa sono sa anang ginatodlo ang mga Judio. May mga tao nga nagparapit kay Jesus kag nagpamangkot, makon nanda, “Ay basi anang mga somolonod ni Juan kag ang mga somolonod ang mga Pariseo nagaporoasa, piro ang kanimo tana ara?” ");
INSERT INTO clu_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Makon ni Jesus nga nagsabat kananda, “Ipabutang ta may kasal. Syimpri indi maimo nga magporoasa ang mga bisita mintras kaiban nanda pa ang nobyo. ");
INSERT INTO clu_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Piro magaabot ang adlaw nga ang nobyo bulun run kananda, kag bago sanda magaporoasa.” ");
INSERT INTO clu_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ginsogidan sanda ra ni Jesus ang mga paanggid agud itodlo kananda nga indi maimo nga dapunun anang bago nga panodlo kag ang dati nga mga panodlo ang mga Judio. Makon na, “Ang bago nga tila nga ara pa mapakuru bukun mayad nga itambul sa lagi nga lambong, tungud nga kon bonakan run ang tinambulan nga lambong magakuru ang bago nga tila kag magigisi ang lagi nga panaptun. Kag magabaul run gid anang gisak. ");
INSERT INTO clu_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Maman ra dan ang matatabo kon ibutang ang bago nga bino sa lagi nga suruludan nga panit. Mabobostik ang suruludan kag ang bino maoola, kag pario nga indi run mapolosan. Gani kinanglan gid nga ang bago nga bino ibutang sa bago ra nga suruludan nga panit.” ");
INSERT INTO clu_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","May sangka Sabado nga nakaagi sanday Jesus sa katrigoan, kag mintras nagalubas sanda, anang mga somolonod nagparangutul anang mga way ang trigo. ");
INSERT INTO clu_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Gani makon ang mga Pariseo kay Jesus, “Sulunga anang ginaimo imong mga somolonod! Basi nagapangutul sanda ang trigo? Kabay bawal ang magimo pario dan sa Adlaw nga Inogpaway?” ");
INSERT INTO clu_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ginsabat sanda ni Jesus, makon na, “Ara nindo gid bala mabasai anang ginimo ni David nga atun kaolang-olangan ang tana kag anang mga kaiban gingutum kag nagakinanglan sanda pagkaun? ");
INSERT INTO clu_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Dia natabo ang si Abiatar maman ang pinakamataas nga pari. Kabay nagsulud si David sa balay ang Dios kag nagkaun ang tinapay nga ginaalad sa Dios nga sono sa Kasogoan bawal nga ipakaun sa iba, ay dato nga tinapay para lang gid sa mga pari. Kag gintawan na pa anang mga kaiban.” ");
INSERT INTO clu_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Makon pa ni Jesus kananda, “Ang Adlaw nga Inogpaway ginimo para sa tao, bukun nga ang tao ginimo para sa Adlaw nga Inogpaway. ");
INSERT INTO clu_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Gani, Ako nga Naging Tao may gaum nga magkoon kon ano ang tama nga imoon bisan pa sa Adlaw nga Inogpaway.” ");
INSERT INTO clu_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Nagayan ruman si Jesus sa simbaan ang mga Judio kag may tao doto nga ukru anang alima. ");
INSERT INTO clu_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Tungud nga dato Adlaw nga Inogpaway, may mga Pariseo doto nga nagabantay kanana kon ayadun na ang tao nga dato para may kaso sanda kontra kanana. ");
INSERT INTO clu_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Makon ni Jesus sa tao nga ukru anang alima, “Abi pagayan digi sa atobangan.” ");
INSERT INTO clu_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Pagkatapos, nagpamangkot tana sa mga Pariseo, makon na, “Ano anang ginatogot ang Kasogoan sa Adlaw nga Inogpaway: ang magimo ang mayad sa mga tao, okon ang magimo ang malain? Ang magbolig nga maglawig andang kaboi okon ang magpatay?” Ang mga tao nga dato ara gid naglimuglimug. ");
INSERT INTO clu_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ginsulung sanda ni Jesus nga may kasilag, piro masubu tana ra sa katugas andang mga tagiposoon. Makon na dayon sa lalaki nga ukru anang alima, “Abi onata imong alima!” Kag ginonat na ra gani, kag anang alima nagayad. ");
INSERT INTO clu_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Pagkatapos dato, naggoa ang mga Pariseo sa andang ginatiriponan kag nagpakigkita sa anang mga sinakupan ni Aring Herodes. Nagsorogidanun sanda dayon kon paiwan nanda ipapatay si Jesus. ");
INSERT INTO clu_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Si Jesus kag anang mga somolonod nagarayan sa baybay ang Dagat ang Galilea. Nagsonod kananda ang doro nga mga tao nga alin sa Galilea kag sa Judea. ");
INSERT INTO clu_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Doro ra ang nagaralin sa Jerusalem, sa Idumea, sa loyo ang Jordan kag sa palibot ang Tiro kag Sidon ay nabaritaan nanda anang ginapangimo. ");
INSERT INTO clu_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Tungud sa kadoroon ang mga tao ginkoonan na anang mga somolonod nga magpriparar ang sakayan para kanana, agud nga kon magsinagusu kanana ang mga tao may masakayan tana. ");
INSERT INTO clu_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Tungud nga doro anang ginpangayad, tanan nga may masakit nagadurukdukan agud makatandug kanana. ");
INSERT INTO clu_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Kag kada makita tana ang mga tao nga may malain nga ispirito, nagadapa sanda kanana kag nagasinggit nga nagakoon, “Ikaw maman anang Bata ang Dios!” ");
INSERT INTO clu_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Piro ginpaandaman na ang mga malain nga ispirito nga indi magsogid kon sino tana. ");
INSERT INTO clu_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Pagkatapos dato, nagtokad si Jesus sa bokid kag gintawag na anang mga gosto nga piliun. Gani nagparapit sanda kanana. ");
INSERT INTO clu_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Kag pagkatapos, nagpili tana dosi nga anang maging kaiban kag agud sogoon nga magpangwalian. ");
INSERT INTO clu_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Dia nga mga tao gintawan na ra gaum agud magpalayas ang mga malain nga mga ispirito. ");
INSERT INTO clu_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Maman dia ang dosi nga anang napili: una si Simon (nga anang giningaranan nga Pedro); ");
INSERT INTO clu_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","dason anang mga bata ni Zebedeo nga sanday Santiago kag Juan (nga giningaranan nga Boanerges nga ang gostong ambalun, mga bata ang dagub); ");
INSERT INTO clu_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","kaiban ra sa mga napili sanday Andres, Felipe, Bartolome, Mateo, Tomas, Santiago nga bata ni Alfeo, Tadeo, Simon (nga dati nga ribildi sa gobyirno ang Roma), ");
INSERT INTO clu_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","kag si Judas Iscariote nga maman ang nagtraidor kanana. ");
INSERT INTO clu_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Pagkatapos, nagoli dayon sanday Jesus. Kag nagtiripon roman doto ang mga tao, gani sanday Jesus ara run tyimpo bisan magkaun. ");
INSERT INTO clu_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Pagkabati anang pamilya parti sa anang mga ginaimo ni Jesus, nagayan sanda doto agud bulun tana ay nagkoon ang mga tao nagaomang-omang tana. ");
INSERT INTO clu_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Makon ra ang mga manogtodlo ang Kasogoan nga nagaralin sa Jerusalem, “Ginsoot tana ni Satanas nga anang manogdomara ang mga malain nga ispirito. Gani paagi sa anang gaum ni Satanas ginapalayas na ang mga malain nga ispirito.” ");
INSERT INTO clu_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Gani gintawag ni Jesus ang mga tao nga magparapit kanana. Pagkatapos nagambal tana kananda paagi sa mga paanggid, makon na, “Indi maimo nga si Satanas magtabog anang mga kaiban. ");
INSERT INTO clu_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Alimbawa abi, kon ang mga pomoloyo ang sangka ginarian magburulag-bulag kag magaraway, dan nga ginarian indi makapadayon. ");
INSERT INTO clu_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Pario ra sa sangka pamilya: kon ang mga tao sa pamilya magburulag-bulag kag magaraway, mararangga ang pamilya. ");
INSERT INTO clu_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Gani toladan ra ang matabo kon si Satanas kag anang mga sakup magburulag-bulag kag magaraway; anang ginarian indi magpadayon kondi maburulag. ");
INSERT INTO clu_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Piro ang matood,” makon ni Jesus, “napirdi ko ron si Satanas. Maman dan ang kabangdanan nga makapalayas ako anang mga somolonod. Ay ara tao nga makasulud sa anang balay ang mapurus nga tao agud magbuul anang mga pagkabutang kon indi na anay paggaposon ang mapurus nga tao. Piro kon magapos na run ang mapurus nga tao, pagosto tana run kon ano anang imoon sa balay nga dato. ");
INSERT INTO clu_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Sa matood tana, tanan nga klasi nga sala kag mga pagambal ang malain kontra sa Dios mapapatawad, ");
INSERT INTO clu_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","piro ang bisan sino nga nagaambal malain kontra sa Ispirito Santo indi gid mapatawad. Dia nga klasi nga sala indi mapatawad asta kon sano.” ");
INSERT INTO clu_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ginambal dia ni Jesus ay nagakoon ang mga manogtodlo ang Kasogoan nga tana may malain nga ispirito. ");
INSERT INTO clu_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Nagabot dayon anang nanay kag anang mga kabogto ni Jesus. Mintras nagatirindug sanda doto sa goa ang balay ginpatawag nanda tana. ");
INSERT INTO clu_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Dorong tao doto ang nagaporongko sa anang palibot ni Jesus. Makon ang mga tao kanana, “Imong nanay kag imong mga kabogto dian sa goa kag ginapatawag kaw.” ");
INSERT INTO clu_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Makon na nga nagsabat, “Naulaman nindo bala kon sino akun nanay kag akun mga kabogto?” ");
INSERT INTO clu_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Nagsulung tana sa mga tao nga nagaporongko sa anang palibot kag nagkoon, “Dia tana maman akun nanay kag akun mga kabogto! ");
INSERT INTO clu_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ang bisan sino nga nagaimo anang kabubutun ang Dios maman akun nanay kag mga kabogto.” ");
INSERT INTO clu_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","May sangka okasyon, nagtodlo roman si Jesus sa baybay. Doro gid ang mga tao nga nagtiripon doto sa anang palibot. Gani nagsakay tana sa sakayan nga nagapondo kag nagpongko doto. Ang mga tao tana nagpabilin sa baybay. ");
INSERT INTO clu_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Dorong mga butang anang gintodlo kananda paagi sa sari-sari nga mga paanggid. ");
INSERT INTO clu_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Makon na kananda, “Pamati kamo bala! May sangka mangongoma nga nagpanggas. ");
INSERT INTO clu_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Sa anang pagpanggas, ang iba nga bini nagtugpa sa dalan kag dia gindapo ang mga pispis kag gintoka. ");
INSERT INTO clu_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ang ibang bini nagtugpa sa kabatoan nga tapaw lang gid ang logta, kag tungud nga manabaw ang logta ara lang boay magtobo. ");
INSERT INTO clu_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Garing pagabot ang tig-irinit nagkaralayung kag tungud nga kolang anang gamot, nauga. ");
INSERT INTO clu_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ang ibang bini nagtugpa sa logar nga dorong ilamonon nga masiit, kag pagrabong ang ilamonon nalumus ang tanum, gani ara nakapamonga. ");
INSERT INTO clu_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ang iba nagtugpa sa mayad nga logta, kag dia nagtorobo kag nagparamonga. Ang iba tama-tama lang anang bonga, ang iba doro, kag ang iba doro gid.” ");
INSERT INTO clu_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Makon pa ni Jesus kananda, “Dapat intindiun nindo ang indong nabatian nga dia.” ");
INSERT INTO clu_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Pagoroli ang mga tao, anang dosi ka apostolis kag ang iba pa ra nga nagtarabid kanana nagparamangkot kon ano anang kaologan ang paanggid nga dato. ");
INSERT INTO clu_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Makon ni Jesus kananda, “Ang mga tinago ang ona parti sa anang pagari ang Dios ginasogid kanindo ang diritso, piro sa ibang tao tana tanan nga butang ginasogid kananda paagi sa mga paanggid, ");
INSERT INTO clu_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","agud nga, Sigi andang sulung piro indi sanda makakita, Kag sigi ra andang pamati piro indi sanda ra makaintindi, Ay kon andang maintindian, mainulsul sanda kag patawadun sanda ang Dios.” ");
INSERT INTO clu_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Nagpamangkot dayon si Jesus kananda, makon na, “Ta kon kamo indi ra makaintindi ang paanggid nga dato, paiwan indong pagkaintindi ang iba ko pa nga mga paanggid? ");
INSERT INTO clu_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Anang gostong ambalun akun paanggid maman dia: anang ginapanggas ang mangongoma ara iba kondi anang ambal ang Dios. ");
INSERT INTO clu_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ang mga bini nga nagtugpa sa dalan ambal ang Dios nga nabatian ang mga tao, garing nagaabot ra nga lagi si Satanas kag ginaagaw na anang ambal ang Dios nga ginpanggas sa andang mga tagiposoon. ");
INSERT INTO clu_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ang mga bini ra tana nga nagtugpa sa kabatoan ambal ang Dios nga nabatian ang mga tao nga lagi-lagi ginbaton nanda nga may kalipay. ");
INSERT INTO clu_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Garing bukun tuduk sa andang tagiposoon, gani ara lang boay andang pagtoo. Pagabot ang kalisud okon pagingabot tungud sa anang ambal ang Dios nga andang ginbaton, nagabaya sanda nga lagi sa andang pagtoo. ");
INSERT INTO clu_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ang mga bini nga nagtugpa sa may mga masiit nga ilamonon ambal ang Dios nga nabatian ang mga tao, ");
INSERT INTO clu_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","piro tungud sa mga paralibugan sa pangaboi kag pagimorat sa pagmanggad, kag sobra nga andum sa iba pa nga mga butang, nalipatan nanda anang ambal ang Dios nga andang nabatian kag ara napolosi. ");
INSERT INTO clu_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Piro ang mga bini nga nagtugpa sa masadya nga logta ambal ang Dios nga nabatian ang mga tao kag ginbaton nanda sa andang tagiposoon kag napolosan nanda gid. Ang iba tama-tama lang andang napolosan sa andang nabatian, ang iba doro, kag ang iba doro gid.” ");
INSERT INTO clu_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Pagkatapos dato sigi pa gid anang ambal ni Jesus kananda, makon na, “Kon ang tao magsindi ang solo, ara na ginataklubi okon ginabutang sa idalum ang katri, kondi ginatongtong gid sa torongtongan. ");
INSERT INTO clu_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Maman ra dan nga ara gid tinago nga indi maggoa sa ori, kag ara likum parti sa anang pagari ang Dios nga indi maboyagyag. ");
INSERT INTO clu_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Dapat binag-binagun nindo gid indong nabatian nga dia.” ");
INSERT INTO clu_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Makon na pa, “Pamatii nindo ako nga mayad, tungud nga magataw ang Dios kanindo pagintindi sono sa indong pagpamati kag dogangan na pa gani. ");
INSERT INTO clu_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ay ang tao nga may naulaman run nga kamatoodan kag ana nga ginasonod, dogangan pa gid ang Dios anang pagintindi. Piro ang tao tana nga ara nagasonod sa anang naulaman nga kamatoodan, pati anang naulaman nga maistan bubulun pa kanana.” ");
INSERT INTO clu_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Makon pa gid ni Jesus, “Anang pagari ang Dios pario sa tao nga nagpanggas. ");
INSERT INTO clu_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Mintras nagapadayon tana sa anang obra kada adlaw kag sa anang pagkatorog kada gabi, ang mga bini nga anang ginpanggas padayon nga nagatobo bisan ara na maulami kon paiwan. ");
INSERT INTO clu_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ang logta mismo maman ang nagapatobo sa mga tanum: primiro magoroa anay andang tobo, dason mapandaon, pagkatapos magoroa andang bonga. ");
INSERT INTO clu_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Kag kon loto ron gani ginaani anang tagya tungud nga araniun run.” ");
INSERT INTO clu_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Makon ni Jesus nga nagpamangkot kananda, “Sa ano ta kabay ipatolad anang pagari ang Dios? Ano nga paanggid atun gamitun agud ipasanag?” Makon na dayon, ");
INSERT INTO clu_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","“Pario dia sa bini nga mostasa nga maman ang maistan gid sa tanan nga bini nga ginapanggas ang mga tao. ");
INSERT INTO clu_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Piro kon ipanggas run, nagatobo kag nagalabaw pa sa tanan nga mga laswa nga asta ang mga pispis sarang makapogad sa nalalandongan anang mga sanga.” ");
INSERT INTO clu_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Doro pa gid nga mga paanggid nga pario dia anang gingamit ni Jesus sa anang pagpanodlo sa mga tao, kompormi sa andang masarangan lang nga maintindian. ");
INSERT INTO clu_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ara tana nagambal sa mga tao nga ara nagagamit paanggid, piro ginapasanag na tanan sa anang mga somolonod kon sanda-sanda run lang. ");
INSERT INTO clu_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Pagkasirum ang adlaw ra nga dato, makon ni Jesus sa anang mga somolonod, “Dali, matabok kita.” ");
INSERT INTO clu_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Gani ginbayaan ang mga somolonod ang dorong mga tao nga nagatiripon kag nagsakay sanda sa sakayan nga ginasakayan ni Jesus kag naglarga. May mga sakayan ra doto nga nagpadungan kananda. ");
INSERT INTO clu_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Kag mintras nagapalayag sanda, golpi lang nga nagdurus. Sigi ang sampi ang mabaraul nga daloyon, kag aros maponoan ang sakayan. ");
INSERT INTO clu_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Piro si Jesus tana doto sa boli ang sakayan nagakatorog nga may olonan. Ginpokaw nanda tana. Makon nanda, “Malolonod kita run! Bali ara lang bala dia kanimo?” ");
INSERT INTO clu_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Gani nagbangon tana kag ginsaway na ang angin, makon na, “Angin, puut!” kag ang angin nagpuut. Makon na ra sa dagat, “Dagat, paglantap!” Kag naglantap. ");
INSERT INTO clu_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Makon dayon ni Jesus kananda, “Ay basi ginapangadlukan kamo? Ano, ara kamo pa ra gid pagtoo kanakun?” ");
INSERT INTO clu_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Kag mabaul gid andang katingala kanana. Makon nanda sa isara kag isara, “Sino gid kabay dia nga bisan ang angin kag ang dagat nagatoman kanana?” ");
INSERT INTO clu_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Pagkatapos dato nakaabot sanda sa loyong baybay ang Dagat ang Galilea, sa logar ang mga taga-Gerasa. ");
INSERT INTO clu_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Osto lang nga makasalta si Jesus sa sakayan, ginsolang-solang tana nga lagi ang tao nga may malain nga ispirito. ");
INSERT INTO clu_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ang tao nga dato nagaoli sa mga kowiba nga rulubungan. Ara run tao nga makagapos kanana, bisan kadina pa. ");
INSERT INTO clu_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Kon kapira run gingapos anang mga siki kag anang mga alima, piro kada gaposon tana, ginapamogto na lang ang mga kadina pati ang mga posas sa anang mga siki. Ara run gid may makapugung kanana. ");
INSERT INTO clu_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Adlaw-gabi, sa mga kowiba nga rulubungan tana man okon sa mga bokid, pirmi tana nga nagasinggit kag ginagurut na anang lawas ang bato. ");
INSERT INTO clu_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Pagkakita na kay Jesus sa marayu, nagdalagan tana paayan kanana kag naglood. ");
INSERT INTO clu_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Makon dayon ni Jesus sa malain nga ispirito nga nagaoli sa tao nga dato, makon na, “Ikaw nga malain nga ispirito, paggoa sa tao nga dan!” Dayong singgit ang tao, makon na, “Jesus nga Bata ang Dios nga labaw sa tanan, ano imong labut kanakun? Nagapakitloy ako kanimo sa aran ang Dios nga indi mo ako pagsilotan.” ");
INSERT INTO clu_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ginpamangkot tana dayon ni Jesus, makon na, “Sino imong aran?” Kag nagsabat tana, makon na, “Akun aran si Panung ay doro kami.” ");
INSERT INTO clu_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Kag nagpakitloy tana nga mayad kay Jesus nga indi sanda lang pagpalayasun sa logar nga dato. ");
INSERT INTO clu_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Doto sa marapit nga banggilid doro nga mga baboy ang nagaparanginaun. ");
INSERT INTO clu_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Nagpakitloy kay Jesus ang mga malain nga ispirito nga togotan sanda nga magsulud sa mga baboy nga dato. ");
INSERT INTO clu_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Gani gintogotan na sanda. Kag naggoa ang mga malain nga ispirito sa tao nga dato kag nagsurulud sa mga baboy. Kag ang tanan nga mga baboy doto nga mga darwa ka libo nagdaragoyon palusub sa matidluk nga banggilid diritso sa tobig kag obos nagkaralumus. ");
INSERT INTO clu_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Nagdaralagan sa kaadluk ang mga manogsagod ang mga baboy kag ginpamarita nanda sa mga tao sa banwa kag sa bokid ang mga natabo nga dato. Gani nagarayan ang mga tao doto kay Jesus agud sulungun kon ano ang natabo. ");
INSERT INTO clu_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Pagabot nanda doto nakita nanda ang tao nga dati may mga malain nga ispirito. Nagapongko tana nga may lambong ron kag osto ron anang pinsar. Gani ginkulbaan sanda. ");
INSERT INTO clu_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ang mga nakakita mismo sa natabo ang nagsaysay sa mga tao nga bago lang nagarabot doto kon ano ang natabo sa tao nga dati may mga malain nga ispirito kag sa mga baboy. ");
INSERT INTO clu_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Gani tungud sa mga natabo nga dato nagpakitloy sanda kay Jesus nga magalin sa andang logar. ");
INSERT INTO clu_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Datong masakay run si Jesus sa sakayan, ang tao nga dato nga may mga malain nga ispirito anay nagpakitloy kanana nga kon maimo patabidun tana. ");
INSERT INTO clu_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Garing ara tana pagtogoti ni Jesus, kondi makon na kanana, “Magoli kaw sa imong pamilya kag sogidan mo sanda kon ano anang ginimo ang Ginoo kanimo kag kon paiwan tana nalooy kanimo sa imong dati nga kaimtangan.” ");
INSERT INTO clu_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Gani nagpanaw ang tao nga dato kag nagayan sa probinsya ang Decapolis (kon kanatun pa “Napolo ka Banwa”). Kag doto ginbarita na kon ano anang ginimo ni Jesus kanana. Kag ang tanan nga nakabati kanana natingala nga mayad. ");
INSERT INTO clu_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Pagkatabok roman ni Jesus sa loyong baybay, doro roman nga mga tao ang nagtiripon doto kanana. ");
INSERT INTO clu_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","23","Nagayan ra doto si Jairo nga sangka manogdomara sa simbaan ang mga Judio. Pagkakita na kay Jesus naglood tana kanana kag nagpakitloy, makon na, “Akun bata nga dalagita tagomatayun doto sa balay. Abi kon maimo pagtabid ra anay kanakun kag itongtong imong alima kanana agud magayad tana kag maboi!” ");
INSERT INTO clu_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Gani nagtabid si Jesus kanana. Kag doro gid nga mga tao ang nagtarabid ra kay Jesus kag nagadurukdukan sanda doto kanana. ");
INSERT INTO clu_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","May babai doto nga dosi ka toig run nga ginatagas-tagasan ang dogo. ");
INSERT INTO clu_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Doro gid anang nagastos sa anang pagpabolong sa iba-iba nga mga manogbolong. Nagastos na run tanan anang pagkabutang, piro sa baylo nga magayad, nagdogang pa gani anang masakit. ");
INSERT INTO clu_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Nabatian na ang mga barita parti kay Jesus, gani nagpanalut-salut tana sa dorong mga tao agud makaparapit tana sa anang likod ni Jesus. ");
INSERT INTO clu_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Sa anang unauna lang makon na, “Kon matandug ko bisan anang lambong ron lang, magaayad ako.” ");
INSERT INTO clu_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Gani ginimoratan na nga makatandug sa anang lambong ni Jesus kag lagi-lagi napuut ang pagtagas anang dogo, kag nabatyagan na nga nagayad tana run sa anang masakit. ");
INSERT INTO clu_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Nabatyagan ni Jesus nga may gaum nga naggoa kanana, gani nagliso tana kag nagkoon, “Sino ang nagtandug akun lambong?” ");
INSERT INTO clu_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Makon anang mga somolonod, “Dorong tao ang nagadurukdukan dian kanimo, gani basi nagapamangkot ka pa gid kon sino ang nagtandug kanimo?” ");
INSERT INTO clu_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Piro nagpanulung-sulung tana pa gid kon sino ang nagtandug kanana. ");
INSERT INTO clu_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Tungud nga naulaman ang babai kon ano ang natabo kanana, nagparapit tana kay Jesus nga nagakurudug sa kaadluk. Naglood tana kag nagsogid ang matood. ");
INSERT INTO clu_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Makon dayon ni Jesus kanana, “Nene, nalowas kaw tungud sa imong pagtoo. Pagoli run kag indi ka run magpalibug sa imong masakit ay mayad ka run.” ");
INSERT INTO clu_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Mintras nagaambal tana pa sa babai may nagarabot nga pira ka tao alin sa anang balay ni Jairo. Makon nanda kay Jairo, “Patay run imong bata. Indi run pagbudlaya ang manogtodlo.” ");
INSERT INTO clu_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Piro ara nagsapak si Jesus sa andang barita nga dato. Makon na kay Jairo, “Indi kaw magkaadluk. Magtoo ka lang.” ");
INSERT INTO clu_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Gani nagdayon sanda ra gid. Piro ara tana run may ginpatabid loas kay Pedro kag ang magkabogto nga si Santiago kag si Juan. ");
INSERT INTO clu_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Pagabot nanda sa balay ni Jairo nakita ni Jesus nga ang mga tao nagakinagolo. Ang iba nagaparanangis kag ang iba nagatiriyabaw gid. ");
INSERT INTO clu_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Nagsulud tana sa balay kag makon na sa mga tao, “Basi nagarilingaw kamo kag nagaparanangis? Bukun patay ang bata; nagakatorog lang.” ");
INSERT INTO clu_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ginkadlawan nanda si Jesus. Gani ginpagoa na ang tanan nga mga tao kag ginpasulud na sa koarto ang bata anang tatay, anang nanay, kag ang tatlo nga anang kaiban. ");
INSERT INTO clu_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Pagkatapos ginawidan na dayon anang alima ang bata kag magkoon, “Talitha, Koum,” nga kon kanatun pa, “Nene, pagbangon!” ");
INSERT INTO clu_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Kag lagi-lagi nagbangon ang dalagita kag nagpanaw-panaw. (Ang dalagita nga dato nagaidad dosi ka toig). Tungud sa natabo nga dia, natingala sanda nga mayad. ");
INSERT INTO clu_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Piro ginbilinan na sanda nga indi gid magpanogid-sogid bisan kino parti sa natabo. Kag ginkonan na sanda dayon nga tawan pagkaun ang bata. ");
INSERT INTO clu_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Pagkatapos dato, nagoli si Jesus sa anang banwa. Nagtabid ra kanana anang mga somolonod. ");
INSERT INTO clu_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Pagabot ang Adlaw nga Inogpaway nagtodlo tana sa anang simbaan ang mga Judio. Dorong tao doto ang nakabati kanana kag natingala sanda nga mayad. Makon nanda, “Basi doro anang naulaman ang tao nga dia? Sa diin tana kabay nakabuul anang kinaraman? Kag basi nakakaimo tana ang mga milagro? ");
INSERT INTO clu_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Kabay maman dia ang panday nga bata ni Maria kag anang mga kabogto si Santiago, si Jose, si Judas kag si Simon. Kag anang mga kabogto nga babai digi ra nagaoli.” Gani indi sanda magpati kanana. ");
INSERT INTO clu_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Makon dayon ni Jesus kananda, “Ang propita ginataod gid loas lang sa anang kaogalingun nga banwa kag anang mga paryinti kag panimalay.” ");
INSERT INTO clu_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Maman dato nga ara tana kaimo ang mga milagro doto sa logar nga dato, loas sa pira ka tao lang nga nagamarasakit nga anang gintongtongan anang alima kag ginayad. ");
INSERT INTO clu_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Natingala tana nga indi sanda magtoo kanana. Pagkatapos dato naglibot si Jesus sa mga bario nga nagapanodlo. ");
INSERT INTO clu_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Gintawag na anang dosi ka somolonod kag ginpadara na sanda nga tag-darwadarwa. Ginpanawan na sanda gaum kontra sa mga malain nga ispirito. ");
INSERT INTO clu_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ginbilinan na sanda nga indi sanda magdara bisan ano sa andang pagpanaw kondi baston lang gid. Ginkonan na sanda nga indi magdara pagkaun, koarta okon bag. ");
INSERT INTO clu_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Sarang sanda makasandalyas, piro indi magdara ang irilisan nga lambong. ");
INSERT INTO clu_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Kag makon na dayon kananda, “Kon padayonon kamo sa sangka balay, doto kamo ron lang gid magdayon asta magalin kamo sa logar nga dato. ");
INSERT INTO clu_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Piro kon ang mga tao sa sangka logar indi magbaton kanindo kag indi magpamati sa indong ginasogid, bayai nindo ron lang, kag pagalin nindo tapokan nindo ang yabok indong siki bilang tanda kontra kananda.” ");
INSERT INTO clu_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Gani nagparanaw sanda kag nagparangwalian nga ang mga tao dapat maginulsul sa andang mga sala. ");
INSERT INTO clu_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Dorong malain nga ispirito andang ginpalayas kag dorong masakitun andang ginpanglugudan ang langis kag nagarayad. ");
INSERT INTO clu_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Nakaabot kay Aring Herodes ang mga barita parti kay Jesus tungud nga bantog tana run. Ang iba nagakoon nga si Jesus nga dia si Juan nga manogbunyag nga nabanaw, gani maman dan nga nakakaimo tana mga milagro. ");
INSERT INTO clu_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Piro nagakoon ang iba nga tana si Elias nga propita. Kag nagakoon pa gid ang iba nga iba tana nga propita pario anang mga propita ang Dios ang ona. ");
INSERT INTO clu_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Piro pagkabati ni Herodes sa mga barita nga dia, makon na, “Nabanaw si Juan nga akun ginpaotodan anang olo.” ");
INSERT INTO clu_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Ginpaotod ni Herodes anang olo ni Juan tungud sa anang dumut ni Herodias kanana, ay toladia ang natabo: si Herodes nga dia, ginpangasawa na si Herodias nga asawa anang kabogto nga si Felipe. Karon, nagkoon si Juan kay Herodes nga bukun mayad nga pangasawaun na anang asawa anang kabogto. Gani tungud kay Herodias ginpadakup ni Herodes si Juan kag ginpapriso. ");
INSERT INTO clu_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Kag tungud sa anang dumut ni Herodias kay Juan gosto na nga ipapatay, garing indi na ra maimo tungud nga indi tana pagtogotan ni Herodes. ");
INSERT INTO clu_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ay naadlukan ra si Herodes kay Juan tungud nga naulaman na nga si Juan diosnon kag matarung nga tao. Gani ginpangapinan ni Herodes si Juan agud indi maiwan. Gosto ni Herodes nga magpamati sa anang mga wali ni Juan bisan matood nga anang mga nababatian nagagolo anang isip. ");
INSERT INTO clu_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Piro nagabot ra gid ang oras nga ginaulat ni Herodias. Dia natabo ang magkomplianyo si Herodes. Nagponsyon si Herodes kag ginpangimbitar na ang mga nagadomara sa banwa ang Galilea, ang mga kapitan ang mga soldado, kag ang mga ginakilala nga mga tao doto. ");
INSERT INTO clu_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ang oras run ang ponsyon, nagsulud anang bata nga daraga ni Herodias kag nagsaot. Kag nalipay nga mayad si Herodes pati anang mga bisita. Gani nagkoon si Herodes sa daraga; makon na, “Pagpangayo kanakun bisan ano nga imong naliagan kag itaw ko kanimo.” ");
INSERT INTO clu_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Kag makon na pa gid sa daraga nga nagasompa, “Bisan ano imong pangayoon kanakun itaw ko kanimo, bisan katunga pa akun ginarian.” ");
INSERT INTO clu_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Naggoa ang daraga kag nagpamangkot sa anang nanay kon ano anang pangayoon. Kag ginkoonan tana anang nanay nga pangayoon na anang olo ni Juan nga manogbunyag. ");
INSERT INTO clu_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Gani nagdali-dali tana balik sa ari. Pagabot na doto, makon na, “Gosto ko nga itaw mo kanakun dadi nga lagi anang olo ni Juan nga manogbunyag nga nagabutang sa bandiado.” ");
INSERT INTO clu_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Pagkabati dato ang ari naborido tana nga mayad, piro tungud nga nakasompa tana kag nabatian mismo anang mga bisita, indi na gosto nga marangga anang pangako sa daraga. ");
INSERT INTO clu_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Gani lagi-lagi ginsogo na ang sangka soldado nga daraun doto kanana anang olo ni Juan. Nagayan ang soldado sa prisoan kag ginotod na anang olo ni Juan. ");
INSERT INTO clu_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Pagkatapos, ginbutang na sa bandiado kag gintaw sa daraga, kag gintaw ra dayon ang daraga sa anang nanay. ");
INSERT INTO clu_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Pagkabati anang mga somolonod ni Juan sa natabo, ginayanan nanda kag ginbuul anang lawas kag ginlubung. ");
INSERT INTO clu_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Nagbaralik kay Jesus ang mga apostolis nga nagparangwalian. Ginsogid nanda kanana ang tanan nga andang naimo kag mga gintodlo. ");
INSERT INTO clu_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Sa kadoroon ang mga tao nga nagaarabot kag nagaaralin, ara sanda run tyimpo bisan sa pagkaun. Gani makon ni Jesus sa anang mga somolonod, “Ta run, maayan kita sa naligwin nga logar agud makapawayway kamo maistan.” ");
INSERT INTO clu_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Gani nagsakay sanda sa sakayan kag nagpaayan sa naligwin nga logar. ");
INSERT INTO clu_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Garing doro ang nakakita kananda andang pagalin kag nakilala sanda ang mga tao. Gani nagdaralagan ang mga tao alin sa iba-ibang mga banwa paayan sa logar nga ginapaayanan nanday Jesus kag naona sanda pa doto. ");
INSERT INTO clu_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Pagsalta ni Jesus nakita na ang doro gid nga mga tao nga nagtiripon doto kag nalooy tana kananda, ay pario sanda sa mga karniro nga ara manogbantay. Kag gintodloan na sanda ang sari-sari nga mga butang. ");
INSERT INTO clu_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ang apon ron gid, nagparapit kanana anang mga somolonod. Makon nanda, “Apon ron dia, kag digi kita paman sa naligwin nga logar. ");
INSERT INTO clu_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Paayana run ang mga tao sa mga bario kag sa mga sityo sa palibot agud makabakal sanda andang pagkaun.” ");
INSERT INTO clu_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Piro makon ni Jesus kananda, “Kamo mismo ang magtaw pagkaun kananda.” Makon nanda kay Jesus, “Ano, mapanaw kami kag magbakal ang tinapay nga anang kantidad bali walo ka bolan nga soildo ang sangka tao agud ipakaun kananda?” ");
INSERT INTO clu_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Makon ni Jesus kananda, “Pira ka bilog indong tinapay dian? Abi, sulunga nindo.” Pagkatapos nga andang maosisa, makon nanda, “Lima ka tinapay kag darwa ka bilog nga isda.” ");
INSERT INTO clu_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ginsogo dayon ni Jesus anang mga somolonod nga papongkoon ang mga tao gropo-gropo sa mga ilamonon. ");
INSERT INTO clu_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Gani nagporongko ang mga tao, tag-100 kag tag-50. ");
INSERT INTO clu_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Pagkatapos, ginbuul dayon ni Jesus ang lima ka bilog nga tinapay kag darwa ka bilog nga isda, kag nagtangra tana sa langit kag ginpasalamatan na dato sa Dios. Ginpamisang-pisang na dayon ang tinapay kag gintaw na sa anang mga somolonod agud itaw sa mga tao. Kag toladato ra anang ginimo sa isda. ");
INSERT INTO clu_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Kag nakakaun sanda tanan kag nagkarabosog. ");
INSERT INTO clu_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Pagkatapos nga nakakaun run ang tanan, gintipon nanda ang mga nabilin nga tinapay kag isda kag bali dosi ka baskit andang napono. ");
INSERT INTO clu_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Sa mga nagkaraun, ang mga lalaki lang lima ka libo nga lagi. ");
INSERT INTO clu_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Pagkatapos dato, ginsogo ni Jesus anang mga somolonod nga magsakay sa andang sakayan kag magona doto sa tabok, sa banwa ang Betsaida, mintras ginapaoli na ang mga tao. ");
INSERT INTO clu_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Kag pagkatapos nga makaalin ang mga tao nagtokad tana sa bokid agud magpangamoyo. ");
INSERT INTO clu_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Pagkagabi, ang sakayan doto ron sa tunga ang laod, piro si Jesus tana doto pa ra gid sa takas nga tana lang. ");
INSERT INTO clu_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Nakita na nga ginaugtasan sanda run ang gayong ay kontra ang angin. Ang kasanagun run nagayan tana doto kananda nga nagapanaw sa ibabaw ang tobig. Malubas tana run lang andan kananda, ");
INSERT INTO clu_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","piro pagkakita nanda kanana nga nagapanaw sa ibabaw ang tobig, ginpangadlukan sanda nga mayad, ay andang pagsarig morto. Gani nagsiringgit sanda. ");
INSERT INTO clu_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Piro makon ra nga lagi ni Jesus kananda, “Indi kamo magkaadluk! Ako dia! Magpakaisug kamo!” ");
INSERT INTO clu_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Nagsakay tana dayon sa sakayan kag nagpoas ang angin. Kag natingala sanda nga mayad. ");
INSERT INTO clu_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ay bisan nakita nanda ang milagro nga anang ginimo sa tinapay ara sanda pa ra gid kaintindi anang kaologan dato, ay naduluman pa andang isip. ");
INSERT INTO clu_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Pagabot nanda sa loyong baybay, doto sanda nagpondo sa Genesaret. ");
INSERT INTO clu_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Pagkasalta nanda, nakilala nga lagi ang mga tao si Jesus. ");
INSERT INTO clu_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","56","Gani nagdarali-dali sanda ayan sa palibot nga mga logar kag ginpamutang nanda sa iringgaan ang mga masakitun kag ginpandara nanda kay Jesus. Doto sa logar nga dato, miski sa diin tana magayan, sa sityo, sa bario okon sa banwa, basta nabaritaan nanda nga doto si Jesus ginpandara nanda andang masakitun doto kanana, sa logar nga ginatiriponan ang mga tao. Kag nagparakitloy sanda kay Jesus nga kon maimo, patandugun na ang mga masakitun bisan sa sidsid run lang anang lambong. Kag ang tanan nga nakatandug nagayad. ");
INSERT INTO clu_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","May mga Pariseo kag pira ka mga manogtodlo ang Kasogoan nga nagabot alin sa Jerusalem nga nagtiripon doto kay Jesus. ");
INSERT INTO clu_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Kag napanilagan nanda nga ang iba sa anang mga somolonod nagakaraun nga ara nagaparangogas andang alima. Dia kontra sa anang panodlo ang mga Pariseo. ");
INSERT INTO clu_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Bukun lang ang mga Pariseo kondi ang tanan nga mga Judio indi ra magkaun kon indi gid anay makapangogas andang alima sono sa andang soronodon nga ginsonod sa andang mga kaolang-olangan. ");
INSERT INTO clu_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Indi sanda ra magkaun miski ano nga nagalin sa mga baraligyaan kon indi nanda anay maogasan. Kag doro pa gid andang mga soronodon pario sa pagpangogas ang mga tasa, koron, kag mga saway nga mga suruludan. ");
INSERT INTO clu_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Gani nagparamangkot kay Jesus ang mga Pariseo kag ang mga manogtodlo ang Kasogoan; makon nanda, “Ay basi imong mga somolonod ara nagasonod sa mga soronodon atun mga kaolang-olangan? Nagakaraun sanda nga ara kaparangogas andang mga alima.” ");
INSERT INTO clu_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ginsabat sanda ni Jesus nga nagakoon, “Ara gid matood nagsala si Isaias nga propita sa anang gintagna parti kanindo nga mga salimpapaw. Makon ang Dios sa anang ginsolat ni Isaias: ‘Ang mga tao nga dia nagataod kanakun sa baba lang, Piro ang matood tana andang tagiposoon marayu kanakun. ");
INSERT INTO clu_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ara polos andang pagsimba kanakun, Ay andang mga ginatodlo mga soronodon nga ginimo-imo lang ang mga tao.’ ");
INSERT INTO clu_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ginasikway nindo anang sogo ang Dios, kag anang mga tradisyon tana ang mga tao maman indong ginasonod.” ");
INSERT INTO clu_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Makon pa ni Jesus kananda, “Antigo kamo gid magpaito agud sikwayun anang ginapatoman ang Dios para masonod nindo indong mga tradisyon. ");
INSERT INTO clu_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Pario abi dia: si Moises nagkoon nga ‘dapat taodon mo imong tatay kag imong nanay.’ Kag ‘ang tao nga nagaambal malain kontra sa anang tatay okon nanay dapat patayun.’ ");
INSERT INTO clu_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Piro kamo nagatodlo nga kon ang tao may inogbolig sa anang mga ginikanan kag magkoon tana nga ‘korban dia’ (nga anang gostong ambalun ‘dia inogtaw sa Dios’) ");
INSERT INTO clu_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ara nindo ron tana ginatogoti nga magbolig sa anang mga ginikanan. ");
INSERT INTO clu_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Gani tungud sa indong ginpanobli nga dan nga tradisyon ginaimo nindo nga ara polos anang ambal ang Dios. Kag doro pa gid nga toladan indong ginaimo.” ");
INSERT INTO clu_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","16","Kag gintawag ruman ni Jesus ang mga tao kag ginkonan na sanda; makon na, “Pamati kamo bala tanan kanakun, kag binag-binagun nindo gid akun iambal. Ara butang nga nagasulud sa tao nga nagapalain kanana kondi ang mga nagagoa kanana.” ");
INSERT INTO clu_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Pagkatapos ginbayaan na ang mga tao kag nagsulud tana sa balay. Ang sa sulud tana run, anang mga somolonod nagparamangkot kanana kon ano anang kaologan anang paanggid nga dato. ");
INSERT INTO clu_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Makon ni Jesus kananda, “Basi, ara kamo ra kaintindi? Ara nindo bala naulami nga ang bisan ano nga ginakaun indi makapalain sa tao, ");
INSERT INTO clu_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ay ara ra nagasulud sa anang tagiposoon kondi sa anang tian kag nagagoa dayon sa anang lawas.” (Sa anang ambal nga dan naulaman ta nga ginakabig ni Jesus nga ang tanan nga pagkaun poidi nga kaunun.) ");
INSERT INTO clu_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Makon na pa, “Ang nagagoa sa tao maman ang nagapalain kanana sa panulung ang Dios. ");
INSERT INTO clu_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ay alin sa anang tagiposoon ang tao nagagoa ang malain nga mga una-una pario ang pagolid sa bukun anang asawa, ang pagpanakaw, ang pagpatay, ");
INSERT INTO clu_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ang pagpanginlalaki okon ang pagpanginbabai, ang paginakug, ang pagimo ang tanan nga klasi nga malain, ang pagpandaya, ang pagbinastos, ang paginggit, ang pagambal ang malain kontra sa anang kapario, ang pagadak, kag kon ano pa nga mga kalokoan. ");
INSERT INTO clu_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ang tanan nga dia nga mga malain nagaalin sa sulud anang tagiposoon ang tao, kag maman ang nagapalain kanana.” ");
INSERT INTO clu_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Nagalin tana dayon doto sa probinsya ang Galilea kag nagayan sa mga logar nga sakup ang Tiro. Pagabot na doto nagdayon tana sa sangka balay kag indi na gosto nga maulaman ang mga tao nga doto tana. Garing indi matago ang barita nga doto tana. ");
INSERT INTO clu_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Karon, may babai doto nga nakabati nga doto si Jesus. Dia nga babai taga-Fenicia nga sakup ang Siria kag anang ambal Griego. Bukun tana Judio. May bata tana nga babai nga ginsoot ang malain nga ispirito. Gani nagayan tana nga lagi kay Jesus, naglood tana, kag nagpakitloy nga kon maimo sobolon na ra ang malain nga ispirito sa anang bata. ");
INSERT INTO clu_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Piro makon ni Jesus kanana sa paanggid, “Kinanglan nga pakaunun anay ang mga bata, ay bukun mayad nga bulun anang pagkaun ang mga bata kag itaw sa mga ayam.” Naulaman ang babai kon ano anang gostong ambalun ni Jesus, nga boligan na anay ang mga Judio kag bago garing ang bukun Judio. ");
INSERT INTO clu_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Gani makon ang babai kanana, “Tama dan Ginoo, piro bisan ang mga ayam nagakaraun da ang mga pagkaun nga nagakaraolog alin sa mga bata nga nagakaraun sa lamisa.” ");
INSERT INTO clu_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Makon dayon ni Jesus kanana, “Tungud sa imong sabat nga dan, sarang ka run makaoli. Ang malain nga ispirito naggoa run sa imong bata.” ");
INSERT INTO clu_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Nagoli ang babai kag naabotan na anang bata nga nagaingga sa katri, kag ang malain nga ispirito nakagoa run kanana. ");
INSERT INTO clu_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Pagalin ni Jesus sa mga logar nga sakup ang Tiro, nagagi tana sa Sidon kag sa probinsya ang Decapolis. Pagkatapos nagdiritso tana sa Dagat ang Galilea. ");
INSERT INTO clu_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","May tao doto nga bungul kag apa nga gindara ang mga tao doto kay Jesus. Nagpakitloy sanda kanana nga itongtong na anang alima sa tao nga dato nga bungul kag apa. ");
INSERT INTO clu_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ginpabulag tana ni Jesus sa kadoroan, kag gingoro na anang mga todlo sa anang mga talinga. Pagkatapos gindopraan na anang todlo kag ginlugudan anang dila ang lalaki nga dato. ");
INSERT INTO clu_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Kag nagtangra dayon si Jesus sa langit kag magginawa malawig. Makon na dayon kanana, “Effata!” Kon kanatun pa, “Pagabri!” ");
INSERT INTO clu_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Pagkatapos dato, nakakabati tana run kag nagtadlung anang pagambal. ");
INSERT INTO clu_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ginbilinan na dayon ang mga tao nga indi sanda magpanogid-sogid bisan kino parti sa natabo. Piro bisan iwanun na bawal nagdogang gani andang pagpamarita sa mga tao. ");
INSERT INTO clu_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Natingala nga mayad ang mga tao. Makon nanda, “Bisan ano anang imoon, masadya. Miski ang mga bungul ginapabati na kag ang mga apa ginapaambal na.” ");
INSERT INTO clu_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","May pira ka adlaw, nagtiripon roman ang dorong mga tao kay Jesus. Ang ara sanda run pagkaun gintawag ni Jesus anang mga somolonod kag ginkonan na sanda, makon na, ");
INSERT INTO clu_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Nalooy ako sa mga tao nga dia, ay tatlo ron dia ka adlaw nga nagkaiban sanda kanakun kag ara sanda run may makaun. ");
INSERT INTO clu_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Kon paoliun ko sanda nga gutum sabun doplayun sanda sa dalan ay marayu gid anang ginalinan ang iba kananda.” ");
INSERT INTO clu_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Nagsabat anang mga somolonod kanana, makon nanda, “Ta sa diin kita kabay makabuul ang pagkaun digi sa naligwin nga dia nga logar nga ipakaun sa mga tao nga dia?” ");
INSERT INTO clu_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Piro nagpamangkot tana kananda, makon na, “Pira ka bilog indong tinapay dian?” Makon nanda, “Pito.” ");
INSERT INTO clu_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Pagkatapos dato ginpapongko na ang mga tao. Kag ginbuul na dayon ang pito ka bilog nga tinapay, kag nagpasalamat sa Dios. Ginpamisang-pisang na dayon ang mga tinapay kag gintaw sa anang mga somolonod agud ipanagtag sa mga tao. ");
INSERT INTO clu_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","May pira sanda ra ka bilog nga isda nga mairintuk. Gani ginpasalamatan na ra dato kag gintaw sa anang mga somolonod agud ipanagtag ra sa mga tao. ");
INSERT INTO clu_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Nagkaraun ang mga tao kag nagkarabosog. Pagkatapos, gintipon nanda ang tinapay nga sobra, kag nakapono sanda pito ka baskit. ");
INSERT INTO clu_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ang mga tao nga nakakaun mga 4,000. Pagkatapos dato, ginpaoli ni Jesus ang mga tao ");
INSERT INTO clu_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","kag nagsakay tana kaiban anang mga somolonod sa sakayan kag nagpa-Dalmanuta. ");
INSERT INTO clu_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Pagabot nanda doto, may mga Pariseo nga nagarayan kay Jesus kag nagpakigdiskosyon kanana. Nagpangayo sanda milagro kanana bilang pamatood nga tana ginpadara manda ang Dios. ");
INSERT INTO clu_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Garing nagpangayay si Jesus kag nagkoon, “Basi kabay pirmi nagapangayo mga milagro ang mga tao sa tyimpo nga dia? Sa matood tana, ara gid milagro nga ipakita kananda!” ");
INSERT INTO clu_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ginbayaan na dayon ang mga Pariseo nga dato. Nagbalik tana sa sakayan kag nagtabok roman sa loyong baybay. ");
INSERT INTO clu_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Nalipatan anang mga somolonod nga magdara tinapay. Andang tinapay nga nadara doto sa sakayan sangka bilog lang gid. ");
INSERT INTO clu_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ginpaandaman sanda ni Jesus nga indi sanda dapat magsonod sa marimo nga ogali ang iba. Ginambal na dia paagi sa paanggid, makon na, “Magandam kamo nga mayad sa anang pampaabok ang mga Pariseo kag anang pampaabok ni Aring Herodes.” Garing ara sanda kaulam nga dato paanggid lang. ");
INSERT INTO clu_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Gani nagbarais-baisan sanda, makon nanda, “Ginambal na dato ay ara kita kadara tinapay.” ");
INSERT INTO clu_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Naulaman ni Jesus kon ano andang ginabarais-baisan. Gani nagkoon tana kananda, makon na, “Ay basi ginabarais-baisan nindo nga ara kamo tinapay? Indi kamo pa gid makaintindi? Ara kamo nagaisip ay? ");
INSERT INTO clu_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","19","May mga mata kamo, indi kamo makakita? May mga talinga kamo, indi kamo makabati? Ara nindo gid bala nadumdumi ang magpamisang-pisang ako lima ka bilog nga tinapay para sa 5,000? Pira ka baskit ang napono sa indong natipon nga sobra?” Makon nanda nga nagsabat, “Dosi!” ");
INSERT INTO clu_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Kag ang magpamisang-pisang ako pito ka bilog nga tinapay para sa 4,000, pira ka baskit ang sobra nga indong natipon?” Makon nanda, “Pito.” ");
INSERT INTO clu_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Makon dayon ni Jesus, “Ta, dapat maintindian nindo ron nga bukun tinapay akun gostong ambalun?” ");
INSERT INTO clu_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Pagabot nanda sa banwa ang Betsaida may mga tao doto nga nagdara lalaki nga bolag kay Jesus. Nagpakitloy sanda dayon kanana nga kon maimo tandugun na ang bolag nga dato agud makakita. ");
INSERT INTO clu_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Gani ginawidan na anang alima ang bolag nga dato kag gindara na doto sa goa ang banwa. Pagabot nanda sa goa ang banwa gindoraan na anang mga mata ang tao nga dato nga bolag. Pagkatapos gintongtong na dayon anang mga alima kanana kag nagpamangkot kon may nakikita tana run. ");
INSERT INTO clu_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Nagtangra ang lalaki kag magkoon, “Kakikita ako ron mga tao, garing midyo sa mga kaoy nga nagaparanaw.” ");
INSERT INTO clu_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Gani gintongtong roman ni Jesus anang alima sa anang mga mata ang bolag. Pagkatapos nagpanulung-sulung nga mayad ang bolag nga dato kag nagayad anang mga mata, kag masanag run anang panulung sa tanan nga butang. ");
INSERT INTO clu_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Bago tana ginpaoli ni Jesus ginkonan na tana nga indi tana dapat magagi sa banwa kag magpanogid-sogid sa mga tao. ");
INSERT INTO clu_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Pagkatapos dato, si Jesus kag anang mga somolonod nagayan sa mga bario nga sakup ang Cesaria Filipos. Mintras nagaparanaw sanda nagpamangkot si Jesus sa anang mga somolonod, makon na, “Sono sa mga tao, sino ako kono?” ");
INSERT INTO clu_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Makon nanda, “May mga nagakoon nga ikaw si Juan nga manogbunyag. Ang iba nagakoon nga ikaw si Elias, kag ang iba pa gid nagakoon nga ikaw isara sa mga propita ang Dios ang ona pa.” ");
INSERT INTO clu_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Nagpamangkot tana dayon kananda, makon na, “Piro para kanindo sino ako?” Nagsabat si Pedro, makon na, “Ikaw ang Cristo nga anang ginpangako ang Dios nga magari.” ");
INSERT INTO clu_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Nagpaandam dayon si Jesus kananda nga indi sanda gid magsogid bisan kino parti kanana. ");
INSERT INTO clu_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Makon dayon ni Jesus kananda, “Ako nga Naging Tao kinanglan nga magantos nga mayad sa anang imoon kanakun anang mga manogdomara ang mga Judio, ang mga manogdomara nga pari, kag ang mga manogtodlo ang Kasogoan. Isikway nanda ako kag patayun, piro pagkatapos tatlo ka adlaw mababanaw ako.” ");
INSERT INTO clu_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ginpasanag na dia nga mayad kananda. Pagkabati dato ni Pedro, gindara na si Jesus sa marayu-rayu kag ginsaway na tana nga indi dato maimo. ");
INSERT INTO clu_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Piro nagliso si Jesus kag nagatobang sa anang mga somolonod, kag ginsaway na si Pedro nga nagakoon, “Parayu kaw kanakun Satanas! Ay imong naisipan nga dan bukun anang gosto ang Dios kondi maman dan anang gosto ang tao.” ");
INSERT INTO clu_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Gintawag na dayon ang mga tao kaiban anang mga somolonod nga magparapit kanana. Makon na kananda, “Kon may tao nga gosto magsonod kanakun, indi na run dapat pagisipun anang kaogalingun, kondi kinanglan magtoman kanakun abir kon kamatayun anang aboton sa pagsonod kanakun. ");
INSERT INTO clu_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ay ang bisan sino nga nagakanogon sa anang kaboi digi sa kalibotan nga dia mapapatay pa ra gid. Piro ang bisan sino nga priparado nga mapatay tungud kanakun kag sa Mayad nga Barita makaangkun ang kaboi nga ara kataposan. ");
INSERT INTO clu_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ano gid anang mabubuul ang tao kon maangkun na ang tanan nga butang digi sa kalibotan, piro madora ra lang anang kaboi? Ara gid! ");
INSERT INTO clu_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ay ara gid pagkabutang nga sarang na nga itaw agud mabawi na ruman anang kaboi. ");
INSERT INTO clu_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ang bisan sino nga magkauya kanakun kag sa akun mga panodlo sa tyimpo nga dia nga ang mga tao malain kag naboyo sa sala ikauya ko ra kon Ako nga Naging Tao magbalik run nga nagalanyag nga may gaum alin sa Amay, kag kaiban ko anang mga angil.” ");
INSERT INTO clu_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Makon pa ni Jesus kananda, “Sa matood tana, may mga tao digi dadi nga indi mapatay mintras indi nanda makita anang pagari ang Dios nga nagaabot nga may gaum.” ");
INSERT INTO clu_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Pagkalubas ang anum ka adlaw gindara ni Jesus si Pedro, si Santiago, kag si Juan sa mataas nga bokid. Ang doto sanda run, mintras nagasulung sanda kay Jesus, nagiba anang itsora ni Jesus. ");
INSERT INTO clu_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Anang lambong nagpoti gid kag masolaw. Ara gid may manogpamonak nga makapapoti pario dato digi sa kalibotan. ");
INSERT INTO clu_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Pagkatapos nakita nanda dayon si Elias kag si Moises nga nagapakigsogidanun kanana. ");
INSERT INTO clu_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Makon ni Pedro kay Jesus, “Maistro, mayad digi kami. Maimo kami tatlo ka kamalig, ang sakabilog kanimo, ang sakabilog kay Moises, kag ang sakabilog kay Elias.” ");
INSERT INTO clu_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Maman dia anang koon ay indi na maulaman kon ano anang dapat iambal tungud nga sugung andang kakulba. ");
INSERT INTO clu_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Karon, may nagabot nga panganod kag ginlikupan sanda. Alin doto sa panganod nga dato may limug nga nagambal. Makon ang limug, “Maman dia akun pinalangga nga Bata. Pamatian nindo tana!” ");
INSERT INTO clu_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Pagkatapos dato nagpanulung-sulung sanda sa andang palibot, piro ara sanda run may iba nga nakita kondi si Jesus lang. ");
INSERT INTO clu_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ang nagalusub sanda run sa bokid, ginkonan sanda ni Jesus, makon na, “Indi kamo gid magsogid bisan kino parti sa indong nakita mintras Ako nga Naging Tao ara pa mabanaw.” ");
INSERT INTO clu_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Gani ara nanda gid pagsogidan ang mga natabo nga dato. Piro nagparamangkotan sanda nga tatlo kon ano anang gostong ambalun nga tana kono mabanaw. ");
INSERT INTO clu_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Pagkatapos, nagpamangkot sanda kay Jesus, makon nanda, “Basi kabay nagakoon ang mga manogtodlo ang Kasogoan nga kinanglan magabot anay si Elias bago magabot ang Cristo.” ");
INSERT INTO clu_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Makon na kananda, “Osto dan, kinanglan nga magabot anay si Elias agud ipriparar na ang tanan nga mga butang. Piro sogidan ko kamo, si Elias nagabot ron. Kag ginimo ang mga tao kanana andang gosto sono sa nasolat parti kanana. Piro basi nasolat ra nga Ako nga Naging Tao kinanglan nga magantos dorong mga butang kag sikwayun ang mga tao?” ");
INSERT INTO clu_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Pagabot nanday Jesus sa anang mga somolonod nga nasala, nakita nanda nga dorong mga tao ang nagatiripon doto kananda. May pira ka mga manogtodlo ang Kasogoan nga nagapakigdiskosyon sa mga somolonod. ");
INSERT INTO clu_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Pagkakita ang mga tao kay Jesus natingala sanda nga mayad, gani nagdaralagan sanda paayan kanana agud solang-solangun tana. ");
INSERT INTO clu_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Nagpamangkot dayon si Jesus kananda, makon na, “Ano indong ginadiskosyonan?” ");
INSERT INTO clu_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","May sangka tao doto sa nagatiripon nga nagsabat, makon na, “Maistro, gindara ko digi kanimo akun bata nga lalaki ay ginsuludan tana ang malain nga ispirito nga nagpaapa kanana. ");
INSERT INTO clu_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kon ang malain nga ispirito magabot kanana, natotomba tana sa logta kag nagabora, kag nagabaragrut ra anang mga ipun. Pagkatapos nagatiskug tana dayon. Ginpangabay ko imong mga somolonod nga palayasun nanda ang malain nga ispirito sa akun bata nga dia, piro indi sanda makasarang.” ");
INSERT INTO clu_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Makon dayon ni Jesus, “Kamo nga mga tao sa tyimpo nga dia, ara kamo gid pagtoo! Asta sano pa kabay akun pagantos kanindo? Dara nindo digi ang bata.” ");
INSERT INTO clu_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Gani gindara nanda ang bata doto kanana. Pagkakita ang malain nga ispirito kay Jesus, ginpakulkug na nga lagi ang bata. Kag nagligid-ligid ang bata sa logta nga nagabora. ");
INSERT INTO clu_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Nagpamangkot si Jesus sa anang tatay, makon na, “Pira run kaboay nga nagatoladan ang bata?” Makon anang tatay ang bata, “Alin ang maistan tana pa. ");
INSERT INTO clu_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Pirmi tana lang ginapalokso ang malain nga ispirito sa kalayo kag sa tobig agud patayun. Piro kon may maimo kaw, abi kaloyi kag tabangi kami ra!” ");
INSERT INTO clu_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Makon ni Jesus kanana, “Basi nagkoon kaw nga kon may maimo ako? Ang tanan nga butang maimo ko sa tao nga nagatoo kanakun.” ");
INSERT INTO clu_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Lagi-lagi nagsabat anang tatay ang bata, makon na, “Nagatoo ako, piro kolang pa. Dogangi akun pagtoo.” ");
INSERT INTO clu_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Pagkakita ni Jesus nga nagdaragoyon ron ang mga tao paayan kanana, nagkoon tana sa malain nga ispirito, “Ikaw nga ispirito nga nagapaapa kag nagapabungul sa bata nga dia, ginamandaran ko ikaw nga maglayas sa bata nga dia kag indi ka run gid magbalik-balik kanana!” ");
INSERT INTO clu_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Nagsinggit ang malain nga ispirito kag ginpakulkug na nga mayad ang bata bago naggoa sa bata. Ang bata midyo patay, gani makon ang kadoroan, “Patay run!” ");
INSERT INTO clu_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Piro ginkaputan ni Jesus anang alima ang bata kag ginpabangon, kag nagtindug ang bata. ");
INSERT INTO clu_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Pagkasulud ni Jesus sa balay nga andang ginadayonan nagparamangkot kanana anang mga somolonod ang sanda-sanda run lang, makon nanda, “Basi kabay indi namun mapagoa ang malain nga ispirito nga dato?” ");
INSERT INTO clu_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Makon na kananda, “Dato nga klasi nga malain nga ispirito mapagoa lang paagi sa pangamoyo.” ");
INSERT INTO clu_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Pagkatapos dato, nagalin sanda sa logar nga dato kag nagagi sa Galilea. Indi na gosto nga maulaman ang mga tao nga doto tana, ");
INSERT INTO clu_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ay nagatodlo tana sa anang mga somolonod. Makon na kananda, “Ako nga Naging Tao iintriga sa mga tao kag papatayun nanda, piro pagkatapos tatlo ka adlaw mababanaw ako.” ");
INSERT INTO clu_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Garing anang mga somolonod ara kaintindi kon ano anang gostong ambalun. Piro naalangan sanda ra magpamangkot kanana kon ano dato. ");
INSERT INTO clu_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Pagabot nanda sa Capernaum, ang doto sanda run sa balay, nagpamangkot si Jesus kananda kon ano andang ginbarais-baisan sa dalan mintras nagaparanaw sanda. ");
INSERT INTO clu_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Piro nagiripus sanda lang ay nauya sanda tungud nga ginbarais-baisan nanda kon sino kananda ang labaw sa tanan. ");
INSERT INTO clu_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Gani nagpongko si Jesus kag gintawag na anang dosi ka apostolis. Makon na dayon kananda, “Kon sino kanindo ang gosto nga maging manogdomara, kinanglan magpaubus tana kag maging sorogoon ang tanan.” ");
INSERT INTO clu_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Nagbuul tana dayon ang bata nga maistan kag ginbutang na sa andang tunga. Pagkatapos ginsabak na dayon ang bata kag nagkoon kananda, makon na, ");
INSERT INTO clu_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ang bisan sino nga tungud sa anang pagsonod kanakun nagabaton kag nagaasikaso sa mga bata nga toladia nagabaton ra kanakun. Kag ang nagabaton kanakun nagabaton ra sa nagpadara kanakun.” ");
INSERT INTO clu_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Makon ni Juan kanana, “Maistro, nakakita kami ang tao nga nagasobol ang mga malain nga ispirito kag imong aran anang ginagamit. Ginbawalan namun tana nga indi tana dapat magimo toladato ay bukun tana atun kaiban.” ");
INSERT INTO clu_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Piro makon ni Jesus, “Indi nindo tana pagbawali ay ara may nagaimo milagro sa akun aran nga maambal dayon malain kontra kanakun. ");
INSERT INTO clu_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ay ang bisan sino nga ara nagakontra kanatun nagadampig kanatun. ");
INSERT INTO clu_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Sa matood tana, ang bisan sino nga magtaw kanindo bisan sangka baso lang nga tobig tungud nga kamo nagadara akun aran, dan nga tao indi gid madoraan anang balus.” ");
INSERT INTO clu_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Piro ang bisan sino nga maging kabangdanan nga ang mga bata nga dia magbaya sa andang pagtoo kanakun, mas mayad pa nga igotan anang liug ang galingan nga bato kag ipandag sa laod. ");
INSERT INTO clu_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Kon imong alima ang maging kabangdanan nga ikaw magbaya kanakun, otoda! Mas mayad pa nga sakabilog lang imong alima kag may kaboi nga ara kataposan kaysa komplito imong alima piro maayan kaw ra lang sa impyirno. Doto ang kalayo indi gid mapatay. ");
INSERT INTO clu_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Kag kon imong siki ang maging kabangdanan nga ikaw magbaya kanakun, otoda! Mas mayad pa nga sakabilog lang imong siki kag may kaboi nga ara kataposan kaysa komplito piro ipilak ka ra lang sa impyirno. ");
INSERT INTO clu_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Kag kon imong mata maman ang maging kabangdanan nga ikaw magkasala, lukada! Mas mayad pa nga magsulud kaw sa anang ginarian ang Dios nga sakabilog lang imong mata kaysa komplito imong mata nga ipilak kaw sa impyirno. ");
INSERT INTO clu_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Doto ‘oolodon sanda asta kon sano kag ang kalayo ara ra napaparung.’ ");
INSERT INTO clu_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Kon paiwan nga ang pagkaun ginabutangan ang asin agud indi marangga, kag ang bolawan ginapaagi sa kalayo para maglimpyo, toladan ra ang imoon kanindo. Papaagiun kamo ra ang Dios sa mga pagtiraw agud maging mayad indong kaboi. ");
INSERT INTO clu_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ang asin mayad, piro kon ang asin magtabang run gani, ara run gid may maimo para mapabalik anang dati nga lasa. Dapat maging pario kamo sa asin, nga indong mga inimoan pirmi nga makabolig sa mga tao agud maging mayad sanda. Kag dapat pirming mayad indong rilasyon sa isara kag isara.” ");
INSERT INTO clu_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Nagalin dayon si Jesus sa Capernaum kag nagayan sa mga logar nga sakup ang Judea, kag nagtabok tana sa soba ang Jordan. Doro roman nga mga tao ang nagtiripon doto kanana kag pario sa anang naanadan, gintodloan na sanda. ");
INSERT INTO clu_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","May mga Pariseo ra nga nagarayan doto. Gosto nanda nga magpangita paagi agud maiakosar nanda tana. Gani nagpamangkot sanda kay Jesus, makon nanda, “Nagatogot bala ang Kasogoan nga bulagan ang lalaki anang asawa?” ");
INSERT INTO clu_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ginsabat sanda ni Jesus paagi sa sangka pamangkot, makon na, “Ta ano anang sogo kanindo ni Moises?” ");
INSERT INTO clu_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Makon nanda, “Si Moises nagtogot nga ang lalaki makaimo kasolatan sa pagbulagan, pagkatapos poidi na run bulagan anang asawa.” ");
INSERT INTO clu_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Makon ni Jesus kananda, “Tungud nga matugas indong olo maman dan nga ginsolat ni Moises kanindo ang kasogoan nga toladato. ");
INSERT INTO clu_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Piro ompisa ang pagimo ang kalibotan, ‘ginimo sanda ang Dios nga lalaki kag babai.’ ");
INSERT INTO clu_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Maman dan nga bayaan ang lalaki anang tatay kag nanay kag magpakigdapun sa anang asawa, ");
INSERT INTO clu_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","kag sanda nga darwa maging isara run lang.’ Gani bukun sanda run darwa kondi isara run lang. ");
INSERT INTO clu_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ta kondi indi dapat nga bulagun ang tao ang gindapun ang Dios.” ");
INSERT INTO clu_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Pagabot nanda sa balay nagpamangkot roman anang mga somolonod parti sa butang nga dato. ");
INSERT INTO clu_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Makon na kananda, “Kon ang lalaki magbulag sa anang asawa kag magpangasawa ang iba, nagapanginbabai tana kag nagakasala sa anang dati nga asawa. ");
INSERT INTO clu_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Kag kon bulagan ang babai anang asawa kag magpaasawa sa iba, tana nagapanginlalaki ra kag nagakasala sa anang dati nga asawa.” ");
INSERT INTO clu_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","May mga tao nga nagdara andang mga bata nga mairintuk kay Jesus agud bindisyonan na. Garing ginsaway sanda ang mga somolonod. ");
INSERT INTO clu_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Pagkakita ni Jesus sa natabo ginugutan tana kag nagkoon tana sa mga somolonod, makon na, “Pabayani nindo ang mga bata nga magparapit kanakun. Indi nindo sanda pagbawali, ay kabilang sa anang ginarian ang Dios ang mga pario kananda. ");
INSERT INTO clu_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ang matood tana gani, ang bisan sino nga indi magpasakup sa anang pagari ang Dios pario anang pagpasakup ang mga bata nga dia indi gid mapabilang sa anang ginaarian ang Dios.” ");
INSERT INTO clu_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ginsabak na dayon ang mga bata. Pagkatapos gintongtong na anang alima kananda kag ginbindisyonan na. ");
INSERT INTO clu_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Datong mapanaw ron sanday Jesus, may tao nga nagdalagan paayan kanana kag naglood. Nagpamangkot dayon ang tao nga dato, makon na, “Mayad nga maistro, ano kabay akun imoon agud makabaton ako ang kaboi nga ara kataposan?” ");
INSERT INTO clu_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Makon ni Jesus kanana, “Basi nagakoon kaw nga ako mayad? Ara kabay iba nga mayad kondi ang Dios lang. ");
INSERT INTO clu_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Kon parti sa imong pamangkot nga dan, naulaman mo ra kabay anang ginakoon ang Kasogoan: ‘Indi kaw magpatay, indi kaw magpanginbabai okon magpanginlalaki, indi kaw magpanakaw, indi kaw magtistigos ang botig, indi kaw magpangdaug-daug, taodon mo imong tatay kag imong nanay.’” ");
INSERT INTO clu_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Makon na nga nagsabat kay Jesus, “Maistro, dan tanan ginatoman ko alin ang maistan ako pa.” ");
INSERT INTO clu_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ginsulung tana ni Jesus nga may pagpamalangga kag magkoon, “Sangka butang run lang ang kolang kanimo. Pagoli kag ibaligya imong pagkabutang, kag ang bayad ipanagtag mo dayon sa mga pobri. Paagi digi maging manggaranun kaw sa langit. Pagkatapos, magbalik kaw kag magsonod kanakun.” ");
INSERT INTO clu_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Naborido nga mayad ang tao pagkabati na dato, kag nagalin tana nga masubu, ay doro anang manggad. ");
INSERT INTO clu_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Pagkatapos nga makaalin ang tao nga dato, nagpanulung-sulung si Jesus sa palibot kag magkoon sa anang mga somolonod, “Malisud ra gid para sa mga manggaranun ang magpasakup sa anang pagari ang Dios.” ");
INSERT INTO clu_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Natingala ang mga somolonod sa anang ginambal. Gani makon na pa gid, “Malisud matood ang magsulud sa anang ginarian ang Dios. ");
INSERT INTO clu_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Mas maulas pa gani nga magagi ang sapat nga kamilyo sa anang boo ang dagum kaysa magpasakup ang manggaranun sa anang pagari ang Dios.” ");
INSERT INTO clu_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Kag natingala sanda pa gid nga mayad. Gani makon nanda, “Ta kon toladan sino ron lang kabay ang malowas?” ");
INSERT INTO clu_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ginsulung sanda ni Jesus kag nagkoon, “Sa mga tao dia imposibli, piro sa Dios tana ara imposibli; ay ang tanan nga butang maimo na.” ");
INSERT INTO clu_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Makon ni Pedro kanana, “Ta kami, ginbayaan namun ang tanan kag magsonod kanimo.” ");
INSERT INTO clu_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Makon ni Jesus kananda, “Sa matood tana, ara tao nga nagbaya anang balay, mga kabogto, nanay, tatay, mga bata, okon mga logta tungud kanakun kag sa Mayad nga Barita, ");
INSERT INTO clu_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","nga indi makabaton mas doro pa gid nga balus sa tyimpo nga dia: mga balay, mga kabogto, mga nanay, mga bata, mga logta, kag pati ra mga pagingabot, kag sa paraaboton nga mga adlaw makabaton tana ra kaboi nga ara kataposan. ");
INSERT INTO clu_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Doro nga mga tao nga ginakilala nga importanti dadi ang magagoa nga bukun, kag doro ang ara ginasapaka dadi ang magagoa nga importanti.” ");
INSERT INTO clu_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ang sa dalan sanda run nga nagapaayan sa Jerusalem, si Jesus nagaona kananda. Anang mga somolonod ginapangkulbaan kag ang iba nga nagasoronod kanana ginapangadlukan run gid ay nagapaayan sanda sa Jerusalem. Ginpabulag na ruman anang dosi ka somolonod kag ginsogidan na sanda kon ano ang matatabo kanana. ");
INSERT INTO clu_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Makon na kananda, “Kita dadi nagapaayan sa Jerusalem kag doto Ako nga Naging Tao itogyan sa mga manogdomara nga mga pari kag mga manogtodlo ang Kasogoan. Pagkatapos sisintinsyaan nanda ako kamatayun kag iintriga sa mga tao nga bukun Judio. ");
INSERT INTO clu_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Yagotaun nanda ako, doraan, anoton, kag patayun dayon. Piro pagkatapos tatlo ka adlaw mababanaw ako.” ");
INSERT INTO clu_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Nagparapit kanana si Juan kag si Santiago nga mga bata ni Zebedeo kag nagkoon, “Maistro, may gosto kami andan nga pangayoon kanimo.” ");
INSERT INTO clu_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Makon ni Jesus kananda, “Ta ano indong gosto nga imoon ko para kanindo?” ");
INSERT INTO clu_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Makon nanda, “Kon magari kaw ron doto sa imong ginarian, papongkoon mo kami nga darwa sa imong kilid; ang isara kanamun sa imong too, kag ang isara sa imong wala.” ");
INSERT INTO clu_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Piro makon ni Jesus kananda, “Ara kamo kaulam kon ano indong ginapangayo. Masarangan nindo bala ang mga pagantos nga antoson ko? Kag masarangan nindo bala ang mga kalisud nga akun maagian?” ");
INSERT INTO clu_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Makon nanda, “Uu, masarangan namun.” Makon dayon ni Jesus kananda, “Kon sa bagay, masarangan nindo manda ang mga pagantos kag ang mga kalisud nga akun maagian. ");
INSERT INTO clu_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Piro bukun ako ang nagapili kon sino ang mapongko sa akun too kag sa akun wala, ay dia may mga ginpripararan run.” ");
INSERT INTO clu_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Pagkabati ang napolo ka somolonod kon ano andang ginpangayo, naglain andang buut kay Santiago kag kay Juan. ");
INSERT INTO clu_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Gani gintawag sanda tanan ni Jesus kag magkoon kananda, “Naulaman nindo nga ang mga manogdomara digi sa kalibotan nga dia may gaum sa andang mga sinakupan kag pagosto sanda lang kon ano andang ipaimo kananda. ");
INSERT INTO clu_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Piro iba tana ang kanindo. Ay kon sino kanindo ang gosto nga maging importanti, dapat tana ang maging sorogoon anang mga kaiban. ");
INSERT INTO clu_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Kag kon sino kanindo ang gosto nga maging labaw sa tanan, dapat tana ang maging oripun ang tanan. ");
INSERT INTO clu_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ay bisan Ako gani nga Naging Tao ara nagayan digi sa kalibotan para magpasirbi, kondi para magsirbi kag magtaw akun kaboi agud matobos ang doro nga mga tao.” ");
INSERT INTO clu_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Nagabot sanda sa Jerico. Pagkatapos, mintras nagapagoa run si Jesus sa banwa nga dato kaiban anang mga somolonod kag ang dorong mga tao, may sangka bolag nga manogpakilimos nga nagapongko doto sa binit ang dalan. Si Bartimeo dato nga bata ni Timeo. ");
INSERT INTO clu_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Pagkabati na nga nagaagi si Jesus nga taga-Nazaret, nagsinggit tana nga nagakoon, “Jesus, nga kaliwat ni David kag manonobli anang ginarian, abi kaloyi ako ra!” ");
INSERT INTO clu_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Doro nga mga tao doto ang nagsaway kanana nga magipus. Piro gintodoan na pa gani singgit nga nagakoon, “Kaliwat ni David, kaloyi ako ra!” ");
INSERT INTO clu_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Nagtadung si Jesus kag nagkoon, “Paayana nindo digi kanakun ang tao nga dan.” Gani gintawag nanda ang bolag. Makon nanda, “Magkalipay kaw, tindug run kag magayan kay Jesus ay ginapatawag kaw.” ");
INSERT INTO clu_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Gani ginwaslik na anang kapa kag nagdali-dali parapit kay Jesus. ");
INSERT INTO clu_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Makon dayon ni Jesus kanana, “Ano imong gosto nga imoon ko kanimo?” Makon ang bolag, “Ginoo, gosto ko nga makakita ruman.” ");
INSERT INTO clu_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Makon dayon ni Jesus kanana, “Imong pagtoo maman ang naglowas kanimo. Sigi, panaw ron.” Kag lagi-lagi nakakita tana kag nagsonod dayon kay Jesus sa anang paarayanan. ");
INSERT INTO clu_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Datong marapit sanda run sa Jerusalem nga nagainamput sanda sa mga banwa ang Betfage kag Betania sa may Bokid ang mga Olivo, ginpaona ni Jesus anang darwa ka somolonod. ");
INSERT INTO clu_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Makon na kananda, “Pagona kamo doto sa masonod nga bario. Pagsulud nindo doto, makikita nindo nga lagi ang bataun pa nga asno nga ara pa gid masakayi nga nagaigot. Obadun nindo kag daraun digi. ");
INSERT INTO clu_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Kon may magpamangkot kanindo kon basi ginaobad nindo, sabatun nindo nga kinanglan ang Ginoo kag ibalik ra nga lagi pagkatapos.” ");
INSERT INTO clu_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Gani nagpanaw sanda kag pagabot nanda doto sa banwa nakita nanda ang bataun pa nga asno sa binit ang dalan nga nagatagkus sa poirtaan. Gani ginobad nanda dayon. ");
INSERT INTO clu_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Mintras nagaobad sanda may mga nagatirindug doto nga nagparamangkot kananda, makon nanda, “Oy, ano indong ginaimo dian? Basi ginaobad nindo ang asno?” ");
INSERT INTO clu_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Kag ginsabat nanda ang mga tao sono sa anang bilin ni Jesus. Gani gintogotan sanda ang mga tao. ");
INSERT INTO clu_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Pagkatapos dato gindara ang darwa ka somolonod ang asno kay Jesus. Pagabot doto ginampiloan nanda andang mga lambong kag ginsakayan dayon ni Jesus paayan sa Jerusalem. ");
INSERT INTO clu_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Dorong mga tao ang nagladlad andang mga lambong sa dalan, kag ang iba, andang ginladlad tana, ang mga sanga nga marabong anang daon nga andang gintapas sa mga kaoy. Dia ginimo nanda bilang pagpadungug kanana. ");
INSERT INTO clu_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ang nagaorona kay Jesus pati ang nagasoronod nagsiringgit nga nagakoon, “Dayawon ang Dios! Ginakaloyan ra gid ang Dios anang ginsogo nga nagaabot dadi digi kanatun! ");
INSERT INTO clu_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ginakaloyan ra gid ang Dios anang ginarian atun kaolang-olangan nga si David nga ginapatindug ruman! Dayawon ang Dios sa langit!” ");
INSERT INTO clu_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Pagabot nanday Jesus sa banwa ang Jerusalem, nagsulud tana sa timplo. Nagpanulung- sulung tana sa tanan nga mga butang doto sa sulud. Pagkatapos, tungud nga madali run lang masalup ang adlaw, naggoa tana kag nagayan sa Bitania kaiban anang dosi ka apostolis. ");
INSERT INTO clu_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Pagkaaga, pagalin nanda sa Betania pabalik sa Jerusalem, gingutum si Jesus. ");
INSERT INTO clu_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","May nalantawan tana nga kaoy nga igira nga marabong. Gani ginayanan na kon may bonga. Garing ara tana gid may nakita nga bonga kondi poros lang daon, ay bukun pa anang oras nga inogpamonga. ");
INSERT INTO clu_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Makon dayon ni Jesus sa igira, “Alin dadi ara run tao nga makakaun imong bonga!” Anang ambal nga dia nabatian anang mga somolonod. ");
INSERT INTO clu_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Pagabot nanda sa Jerusalem, nagsulud tana sa timplo. Ginpalayas na doto ang mga tao nga nagabaraligya kag nagabarakal sa sulud ang timplo. Ginpamaliskad na ra anang mga lamisa ang mga manogbaylo ang koarta pati anang mga porongkoan ang mga manogbaligya ang mga salampati nga inogalad. ");
INSERT INTO clu_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Kag indi tana magtogot nga ang mga tao magagi sa sulud ang timplo nga nagadara andang mga inogbaligya. ");
INSERT INTO clu_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Pagkatapos dato gintodloan na ang mga tao doto sa timplo. Makon na, “Kabay nagkoon ron nga lagi ang Dios sa Kasolatan nga anang balay logar nga parangamoyoan para sa tanan nga nasyon. Piro ginimo nindo tana nga parantagoan ang mga tolisan.” ");
INSERT INTO clu_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Anang ginimo nga dato ni Jesus nabatian ang mga manogdomara nga mga pari kag mga manogtodlo ang Kasogoan. Gani nagpangita sanda paagi agud patayun tana. Garing naadlukan sanda ra kanana ay ang mga tao tana naliliag sa anang panodlo. ");
INSERT INTO clu_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Pagkasirum, si Jesus kag anang mga somolonod nagalin doto sa siodad. ");
INSERT INTO clu_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Pagkaaga, ang nagabalik sanda run sa Jerusalem, doto sanda ruman nagagi sa may igira nga kaoy kag nakita nanda nga nalayung run anang daon, kag pati anang gamot nagkurupus. ");
INSERT INTO clu_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Nadumduman ni Pedro ang natabo. Gani makon na kay Jesus, “Ginoo, sulunga ang kaoy nga igira nga imong ginsompa! Nalayung run!” ");
INSERT INTO clu_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Makon ni Jesus kananda, “Magtoo kamo sa Dios! ");
INSERT INTO clu_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Sa matood tana kon may pagtoo kamo, sarang kamo makakoon sa bokid nga dan nga ‘Magalin dian kag maglokso sa dagat,’ kag kon kamo ara nagapangdoadoa kondi nagapati nga dia matatabo, matatabo gani sono sa indong ambal. ");
INSERT INTO clu_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Gani ginasogidan ko kamo nga bisan ano indong pangayoon sa Dios sa pangamoyo, magtoo kamo nga nabaton nindo ron, kag dan mababaton nindo. ");
INSERT INTO clu_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Kag kon kamo nagapangamoyo, patawada nindo anay ang mga nakaimo sala kanindo agud indong mga sala patawadun ra indong Tatay nga sa langit.  ");
INSERT INTO clu_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ay kon kamo ara nagapatawad sa iba, indi kamo ra pagpatawadun indong Tatay nga sa langit.” ");
INSERT INTO clu_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Pagabot nanda sa Jerusalem, nagbalik si Jesus sa timplo. Kag mintras nagapanaw-panaw tana doto sa sulud ang timplo, nagparapit kanana ang mga manogdomara nga mga pari kag mga manogtodlo ang Kasogoan kag anang mga manogdomara ang mga Judio. ");
INSERT INTO clu_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Nagparamangkot sanda kay Jesus, makon nanda, “Ano imong awtoridad nga nagaimo kaw ang mga butang nga imong ginaimo digi sa timplo? Sino ang nagtaw kanimo ang awtoridad nga dan nga magimo imong ginaimo digi?” ");
INSERT INTO clu_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Makon ni Jesus kananda, “Mapamangkot ako ra kanindo. Sabatun nindo ako anay bago ko kamo sabatun kon ano akun awtoridad sa pagimo ang mga butang nga dia. ");
INSERT INTO clu_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Akun pamangkot maman dia: kino magalin anang awtoridad ni Juan sa pagbunyag, sa Dios okon sa tao? Sabata nindo ako!” ");
INSERT INTO clu_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Nagbarais-baisan sanda anay nga sanda-sanda lang kon ano andang isabat. Makon nanda, “Kon magkoon kita nga ‘Alin sa Dios,’ makoon tana nga, ‘Ta basi ara kamo nagpati kay Juan?’ ");
INSERT INTO clu_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Piro kon magkoon kita nga ‘Alin sa tao,’ masisilag kanatun ang mga tao.” (Naadlukan sanda sa mga tao ay nagpati sanda nga si Juan anang propita ang Dios.) ");
INSERT INTO clu_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Gani ginsabat nanda si Jesus, “Ilam, ara kami kaulam.” Makon ra ni Jesus kananda, “Ta indi ko kamo ra pagsogidan kon kino nga awtoridad ko ginaimo ang mga butang nga akun ginaimo.” ");
INSERT INTO clu_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Nagistoria dayon si Jesus sa mga tao paagi sa mga paanggid, makon na, “May sangka tao nga may logta nga ginpatanuman na obas. Ginpakodalan na, kag nagpaimo tana mabaul nga boo sa mabaul nga bato bilang purugaan ang obas. Nagpatindug tana ra ang mataas nga balay nga ralantawan ang bantay. Pagkatapos ginpaagsaan na dayon kag nagayan sa marayu nga logar. ");
INSERT INTO clu_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Datong inogpopo ron ang obas, ginsogo na anang sorogoon sa mga agsador agud bulun anang parti sa patubas. ");
INSERT INTO clu_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Garing pagabot doto ang sorogoon, gindakup nanda tana kag ginbalbal, kag ginpaoli nga ara gid dara. ");
INSERT INTO clu_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ginsogo roman anang tagya ang obasan ang sangka sorogoon pa gid, piro ginpakauyan nanda kag ginlampusan anang olo. ");
INSERT INTO clu_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Nagsogo tana pa gid ibang sorogoon kag dia ginpatay nanda run gid. Doro pa gid anang ginsogo ang tagya nga dato. Ang iba ginbalbal nanda, kag ang iba ginpatay. ");
INSERT INTO clu_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ang ori, ara tana run gid sorogoon nga masosogo. Gani ginsogo na anang pinalangga nga bata. Anang pagsarig taodon nanda tana ay anang bata run gid. ");
INSERT INTO clu_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Piro pagkakita ang mga agsador sa anang bata, makon nanda sa isara kag isara, ‘Dia run ang manogpanobli. Dali, patayun ta kag maging atun anang sorobliun.’ ");
INSERT INTO clu_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Gani gindakup nanda tana kag ginpatay. Doto nanda tana gindara sa goa ang obasan.” ");
INSERT INTO clu_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Nagpamangkot si Jesus sa mga tao, makon na, “Ta ano kabay anang imoon kananda anang tagya ang kaobasan? Sigorado gid nga ayanan na anang mga agsador kag pamatayun. Kag paagsan na dayon sa iba anang obasan.” ");
INSERT INTO clu_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Makon dayon ni Jesus, “Nabasa nindo kabay sa Kasolatan nga nagakoon, ‘Ang bato nga ginsikway ang mga panday Maman gid ang naging pondasyon nga bato. ");
INSERT INTO clu_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Maman dia anang ginimo ang Ginoo, Kag makatiringala kanatun.’” ");
INSERT INTO clu_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Naulaman ang mga manogdomara nga mga Judio nga sanda gid anang ginatomod sa anang paanggid nga dato. Gani gosto nanda nga dakupun si Jesus, garing ginaadlukan sanda sa mga tao. Gani ginpabayanan nanda tana run lang kag nagaralin. ");
INSERT INTO clu_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ginsogo nanda ang pira ka Pariseo kag pira ka mimbro anang partido ni Herodes nga dakupun si Jesus sa anang ambal agud iakosar nanda tana. ");
INSERT INTO clu_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Gani nagayan sanda kay Jesus kag magpamangkot, makon nanda, “Maistro, naulaman namun nga poros matood imong ginasogid. Indi kaw madara-dara sa anang gosto ang mga tao abir kon sino sanda, kondi kon ano anang kabubutun ang Dios sa tao maman gid imong ginatodlo. Abi, kon sa kanimo, osto bala nga kita bilang mga Judio magbayad bois sa Impirador ang Roma? Dapat bala kita magbayad okon indi?” ");
INSERT INTO clu_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Piro tungud nga naulaman na nga iba andang katoyoan, makon na kananda, “Basi ginatirawan nindo nga dakupun ako sa indong pamangkot nga dan? Abi darai nindo ako digi koarta ay sulungun ko.” ");
INSERT INTO clu_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Gani gindaraan nanda tana. Pagkatapos nga anang masulung nagpamangkot tana dayon, makon na, “Kinong itsora dia kag kinong aran?” Makon nanda nga nagsabat, “Ana ang Impirador.” ");
INSERT INTO clu_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Makon dayon ni Jesus kananda, “Ta kondi itaw nindo sa Impirador ang ana ang Impirador kag itaw nindo ra sa Dios ang ana ang Dios.” Kag sa anang sabat nga dia natingala sanda nga mayad kanana. ");
INSERT INTO clu_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Pagkatapos dato ang mga Saduceo roman ang nagarayan kay Jesus. Dia nga mga tao ara nagapati nga ang mga tao mababanaw. ");
INSERT INTO clu_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Makon nanda, “Maistro, si Moises nagsolat kanatun nga kon mapatay ang lalaki nga ara pa nakapabata sa anang asawa, dapat anang kabogto roman ang magpangasawa sa anang asawa nga nabalo agud makapabata tana para sa anang kabogto. ");
INSERT INTO clu_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Karon, may pito ka magkarabogto nga poros lalaki. Ang panganay nagpangasawa kag napatay nga ara nakapabata. ");
INSERT INTO clu_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Gani ang balo ginpangasawa ang madason nga kabogto ang napatay. Piro napatay tana ra nga ara nakapabata sa babai nga dato. Gani ang balo ginpangasawa ruman ang ikatlo kag maman da ang natabo. ");
INSERT INTO clu_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Asta ang ikapito napatay ra nga ara gid may nakapabata. Ang ori ang babai napatay ra. ");
INSERT INTO clu_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Karon, kon magabot ron ang pagkabanaw, kino tana nga asawa, ay sanda nga pito nakapangasawa kanana?” ");
INSERT INTO clu_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Makon ni Jesus kananda, “Sala kamo gid, tungud nga ara kamo kaintindi kon ano anang ginakoon ang Kasolatan. Kag ara kamo ra kaintindi anang gaum ang Dios. ");
INSERT INTO clu_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ay kon ang mga patay mabanaw, indi sanda run magarasawa, tungud nga pario sanda run sa mga angil sa langit. ");
INSERT INTO clu_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Kag kon parti sa mga patay nga mababanaw, nakabasa kamo ra kabay anang ginsolat ni Moises parti sa anang naagian sa nagadabadaba nga palongpong. Doto nagkoon ang Dios kay Moises, makon na, ‘Ako anang Dios ni Abraham, kag anang Dios ni Isaac, kag anang Dios ni Jacob.’ ");
INSERT INTO clu_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Piro dia nga mga tao patay run bago dia solatun ni Moises. Garing ang Dios bukun Dios ang mga patay, kondi Dios tana ang mga boi. Dia nagapamatood kanatun nga ang mga napatay naboboi. Gani sala kamo gid nga mayad sa indong panodlo nga ara pagkabanaw.” ");
INSERT INTO clu_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","May sangka manogtodlo ang Kasogoan doto nga nakabati andang diskosyon. Nabatian na nga masadya anang sabat ni Jesus. Gani nagparapit tana kag nagpamangkot ra, makon na, “Ano gid kabay ang pinakaimportanti sa tanan nga sogo?” ");
INSERT INTO clu_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Nagsabat si Jesus, makon na, “Ang pinakaimportanti nga sogo maman dia: ‘Pamati kamo nga mga taga-Israel! Ang Ginoo nga atun Dios sangka Ginoo lang. ");
INSERT INTO clu_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Gani kinanglan igogmaun mo ang Ginoo nga imong Dios nga tuduk sa imong tagiposoon, sa bilog mo nga kalag, sa tanan nga imong ginaimo, kag imong isip pirmi gid kanana.’ ");
INSERT INTO clu_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ang madason nga pinakaimportanti nga sogo maman dia: ‘Igogmaun mo imong kapario pario imong pagigogma sa imong kaogalingun.’ Ara run iba nga kasogoan nga labaw pa sa darwa nga dia.” ");
INSERT INTO clu_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Makon ang manogtodlo ang Kasogoan kanana, “Osto kaw maistro. Matood imong koon nga may sangka Dios lang kag ara run iba. ");
INSERT INTO clu_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Kag ang pagigogma kanana nga tuduk sa tagiposoon, sa tanan nga ginaimo, kag pirmi kanana ang isip, kag ang pagigogma sa atun kapario pario atun kaogalingun mas importanti pa kaysa tanan nga alad nga sinonog kag iba pa nga mga alad.” ");
INSERT INTO clu_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Pagkabati ni Jesus nga tama gid anang mga sabat, makon na kanana, “Marapit ka run lang sa anang ginarian ang Dios.” Pagkatapos dato ara run gid may nagpangas nga magpamangkot kay Jesus. ");
INSERT INTO clu_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ang nagatodlo tana run sa timplo makon na, “Basi nagakoon ang mga manogtodlo ang Kasogoan nga ang Cristo anang kaliwat ni David? ");
INSERT INTO clu_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Kon matood nga tana anang kaliwat lang gid ni David basi si David mismo nga ginagobayan ang Ispirito Santo nagkoon nga, ‘Ang Ginoo nagkoon sa akun Ginoo, Pagpongko digi sa akun too Asta mapasoko ko kanimo imong mga kaaway’? ");
INSERT INTO clu_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Kon gintawag tana ni David nga anang Ginoo, paiwan nga tana anang kaliwat lang gid ni David?” Doro nga nga tao ang naliag nga mayad magpamati kay Jesus. ");
INSERT INTO clu_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Sa anang mga pagtodlo makon na, “Magandam kamo sa mga manogtodlo ang Kasogoan nga gosto maglagaw nga nagasoksok ang malabug nga lambong. Kon sa mga logar nga ginatiriponan ang mga tao, gosto nanda nga taodon sanda gid. ");
INSERT INTO clu_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Kon sa mga simbaan okon sa ponsyon, ginapili nanda gid ang mga porongkoan nga para sa mga dungganun nga tao. ");
INSERT INTO clu_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ginaobos nanda buul anang mga pagkabutang ang mga balo nga babai, kag ginatabon-tabonan nanda lang andang ginaimo paagi sa malawig nga mga pangadi. Mas mabaul nga silot andang babatonon.” ");
INSERT INTO clu_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Nagpongko si Jesus sa tupad ang ginaologan ang koarta doto sa timplo kag ginpanilagan na ang mga tao nga nagaorolog andang mga koarta sa burutangan. Doro nga mga manggaranun ang nagorolog mabaraul nga mga kantidad. ");
INSERT INTO clu_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","May babai ra nga balo nga pobri ang nagparapit kag nagolog darwa lang ka sinsilyo nga maistan anang kantidad. ");
INSERT INTO clu_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Pagkatapos dato gintawag ni Jesus anang mga somolonod kag nagkoon kananda, “Sa matood tana, sa panulung ang Dios, mas doro anang ginolog ang pobri nga balo nga dato kaysa tanan nga nagorolog. ");
INSERT INTO clu_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ay sanda tanan nagtaw tungud nga abonda sanda, piro tana tana nagtaw anang bilog nga pagkabutang bisan malisud tana.” ");
INSERT INTO clu_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ang nagagoa run si Jesus sa timplo makon ang isara sa anang mga somolonod kanana, “Maistro, sulunga bala ang timplo nga dia. Ang gingamit nga mga bato mabaraul kag masadya ang pagkaimo.” ");
INSERT INTO clu_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Makon ni Jesus kanana, “Ang timplo nga dan nga ginimo sa mabaraul nga mga bato magakararompag sa paraaboton kag ara gid may mabilin nga mga bato nga nagakamada.” ");
INSERT INTO clu_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Mintras nagapongko si Jesus sa Bokid ang mga Olivo nga nagaatobang sa timplo, nagparapit si Pedro, si Santiago, si Juan kag si Andres kag magpamangkot kanana ang sanda-sanda run lang, ");
INSERT INTO clu_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","makon nanda, “Abi sogidi kami kon sano matatabo ang mga butang nga dato. Ano ang mga tanda nga madali run lang matabo imong ginakoon nga dato tanan?” ");
INSERT INTO clu_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Gani makon ni Jesus kananda, “Magandam kamo nga ara may makapatalang kanindo. ");
INSERT INTO clu_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ay doro ang magaabot kag kada isara magakoon nga sanda kono ako, kag doro andang mapatalang. ");
INSERT INTO clu_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Kag kon makabati kamo ang mga gira sa indong marapit kag makabarita kamo nga doto sa marayu nagagira ra, indi kamo magkaadluk, ay dia kinanglan nga matabo gid man, piro bukun pa dan ang kataposan. ");
INSERT INTO clu_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Magaaraway ang mga nasyon kag magaaraway ang mga ginarian. May magaabot nga mga linog sa iba-ibang mga logar kag may magaabot nga mga gutum. Piro dia nga mga butang ompisa pa lang ang mga kalisud nga magaabot. ");
INSERT INTO clu_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Andaman nindo indong kaogalingun, ay pandakupun kamo kag daraun sa mga manogsintinsya, kag panganoton kamo sa anang mga simbaan ang mga Judio. Magaatobang kamo sa mga ari kag sa iba pa nga mga manogdomara ang banwa tungud nga kamo nagatoo kanakun. Kag doto masogidan nindo sanda parti kanakun. ");
INSERT INTO clu_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Bago magabot ang kataposan, kinanglan iwali ang Mayad nga Barita parti kanakun sa tanan nga mga banwa. ");
INSERT INTO clu_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Kon pandakupun kamo kag daraun sa korti, indi kamo magpalibug kon ano indong isabat mintras ara pa, ay kon sa oras nga kamo kinanglan magambal, iambal nindo lang anang ginapaambal kanindo ang Ispirito Santo. (Ay bukun kamo ang maambal kondi ang Ispirito Santo paagi kanindo.) ");
INSERT INTO clu_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Sa mga adlaw nga dato may mga tao nga ipapatay nanda bisan andang kabogto gid. May mga tatay nga ipapatay nanda andang mga bata. Kag may mga bata nga magakontra sa andang mga ginikanan, kag ipapatay nanda. ");
INSERT INTO clu_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Dumutan kamo ang tanan tungud nga kamo akun mga somolonod. Piro ang nagapadayon tana asta sa kataposan maman ang malolowas. ");
INSERT INTO clu_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Kon makita nindo ron ang pinakamaraway nga manogpangrangga nga nagatindug sa logar nga indi na dapat tindugan,” (kamo nga nagabasa, intindiun nindo kon ano anang kaologan dia), “sa oras nga dato, ang mga nagaoli sa Judea dapat magparalagyaw ron sa mga bokid. ");
INSERT INTO clu_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ang tao nga mataboan nga sa goa anang balay indi run magpaawat sulud para magbuul ang bisan ano. ");
INSERT INTO clu_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Kag ang mataboan nga nagaobra sa anang logta indi run dapat magoli para magbuul anang lambong. ");
INSERT INTO clu_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Sa mga adlaw nga dato kailo ra ang mga nagaburudus kag ang mga nagaparatiti tungud nga malilisudan sanda sa pagpalagyaw. ");
INSERT INTO clu_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ipangamoyo nindo nga dia indi matabo sa tigraramig. ");
INSERT INTO clu_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ay sa mga adlaw nga dato magaabot ang kalisud nga ara pa gid natabo alin anang pagimo ang Dios ang kalibotan asta dadi. Kag ara run gid may makapapario dato asta kon sano. ");
INSERT INTO clu_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ang matood tana, kon ara ginpatagud ang Dios ang mga adlaw nga dato nga maabot, ara may mabilin nga tao. Piro tungud sa anang kalooy sa anang mga pinili, ginpatagud na ang mga adlaw nga dato. ");
INSERT INTO clu_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Kag kon may magkoon kanindo nga ‘Dagi run ang Cristo!’ okon ‘Doto tana!’ indi kamo magpati. ");
INSERT INTO clu_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ay magagoa ang bukun matood nga mga Cristo kag ang bukun matood nga mga propita. Magaimo sanda mga milagro kag mga katiringalaan sa katoyoan nga patalangun, kon maimo, anang mga pinili ang Dios. ");
INSERT INTO clu_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Gani magbantay kamo! Ginasogid ko ron nga lagi kanindo ang mga butang nga dia mintras ara pa matabo.” ");
INSERT INTO clu_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Piro pagkatapos ang mga kalisud sa mga adlaw nga dato, ang adlaw magadulum, kag ang bolan indi run magsanag, ");
INSERT INTO clu_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","kag ang mga bitoon magakaraolog. Ang mga dian sa langit magataralang sa andang dati nga ginaagian. ");
INSERT INTO clu_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Kag Ako nga Naging Tao makikita dayon sa mga panganod nga nagabalik run digi sa kalibotan nga may gaum kag nagalanyag. ");
INSERT INTO clu_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Sogoon ko akun mga angil agud tiponon akun mga pinili nga mga tao alin sa tanan nga logar sa kalibotan.” ");
INSERT INTO clu_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Magtoon kamo liksyon sa kaoy nga igira. Kabay, kon anang mga sanga magpangogbos ron naulaman ta nga madali run lang ang tingadlaw. ");
INSERT INTO clu_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Dan toladan ra, kon makita nindo nga nagakaratabo ron ang mga butang nga dia nga akun ginasogid kanindo, maulaman nindo nga madali ako ron lang magabot. ");
INSERT INTO clu_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Sa matood tana, dia tanan nga mga butang magakaratoman bago mapatay ang mga tao nga dia sa dadi. ");
INSERT INTO clu_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Madodora ang langit kag ang logta, piro akun mga ambal indi gid maimo nga indi matoman.” ");
INSERT INTO clu_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Kon parti sa adlaw okon sa oras akun pagabot, ara gid may nakaulam bisan ang mga angil sa langit okon Ako nga Bata ang Dios, kondi ang Amay lang. ");
INSERT INTO clu_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Gani magbantay kamo kag magandam, ay ara nindo naulami kon sano ako maabot. ");
INSERT INTO clu_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Pario ako sa tao nga naglarga paayan sa marayu nga logar. Pagalin na sa anang balay, ginintriga na sa anang mga sorogoon ang mga orobraun kag kada isara may ana-ana nga obra. Kag ginkonan na ang goardya sa poirtaan nga magbantay. ");
INSERT INTO clu_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Gani magbantay kamo, ay ara kamo kaulam kon sano mabalik anang tagya ang balay, maimo nga sa apon, sa tungang gabi, sa kasanagun okon sa aga. ");
INSERT INTO clu_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Basi kon sa anang pagbalik maabotan na kamo nga nagakaratorog. ");
INSERT INTO clu_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Akun ginakoon nga dia kanindo ginakoon ko sa tanan: magbantay kamo!” ");
INSERT INTO clu_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Darwa run lang ka adlaw bago magabot anang mga pista ang mga Judio nga ginatawag nga Pista anang Paglubas ang Angil kag Pista ang Tinapay nga Ara Pampaabok. Ang mga manogdomara nga mga pari kag ang mga manogtodlo ang Kasogoan may toyo nga patayun si Jesus. Gani nagapangita sanda paagi kon paiwan nanda madakup si Jesus nga indi maulaman ang mga tao. ");
INSERT INTO clu_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Makon nanda, “Indi ta lang pagtaboon sa pista, ay basi kon magkinagolo ang mga tao.” ");
INSERT INTO clu_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ang doto si Jesus sa Betania, mintras nagakaun tana sa anang balay ni Simon nga aroon nga anang ginayad, may sangka babai nga nagabot. May dara tana nga tibod-tibod nga pono maraalun gid nga agoa. Dia nga agoa alin gid sa maamot nga tanum nga ginatawag nga “nardo”. Pagrapit na kay Jesus ginpusa na anang liug-liug ang tibod-tibod kag pagkatapos ginbobo na dayon ang agoa sa anang olo ni Jesus. ");
INSERT INTO clu_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","May mga tao doto nga ginugutan kag nagsorogidanun sanda, “Basi ginoyangan na lang ang agoa? ");
INSERT INTO clu_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Sarang andan dan maibaligya sa kantidad nga bali sangka toig nga soildo kag anang bayad ipanaw sa mga pobri.” Kag ginpangisugan nanda ang babai. ");
INSERT INTO clu_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Piro makon ni Jesus kananda, “Basi ginatoblag nindo tana? Pabayani nindo lang. Mayad anang ginimo nga dia kanakun. ");
INSERT INTO clu_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ang mga pobri pirmi nindo nga makakaiban kag sarang kamo makabolig kananda sa bisan anong oras nga gosto nindo nga magbolig, piro ako tana indi nindo pirmi makakaiban. ");
INSERT INTO clu_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Dia nga babai nagimo anang masarangan para kanakun. Ginlugudan na agoa akun lawas agud ipriparar para sa akun lubung. ");
INSERT INTO clu_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Kag sa matood tana, bisan diin sa bilog nga kalibotan nga iwali ang Mayad nga Barita, anang ginimo nga dia kanakun masasambit ra bilang andumanan kanana.” ");
INSERT INTO clu_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Si Judas Iscariote nga isara sa dosi ka apostolis nagayan sa mga manogdomara nga mga pari agud iintriga si Jesus kananda. ");
INSERT INTO clu_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Pagkabati ang mga manogdomara nga mga pari kon ano anang katoyoan ni Judas nalipay sanda nga mayad kag ginpangakoan nanda nga tawan tana koarta. Gani alin dato nagpangita si Judas kaigayonan kon paiwan na maintriga si Jesus kananda. ");
INSERT INTO clu_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Nagabot ang ona nga adlaw ang Pista ang Tinapay nga Ara Pampaabok. Maman dia ang adlaw nga ginaalad ang mga karniro nga ginakaun para sa Pista anang Paglubas ang Angil. Gani anang mga somolonod ni Jesus nagpamangkot kanana, makon nanda, “Sa diin nga balay imong gosto nga magpriparar kami atun yapon sa Pista anang Paglubas ang Angil?” ");
INSERT INTO clu_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Gani ginsogo na ang darwa sa anang mga somolonod, makon na, “Pagayan kamo doto sa siodad ang Jerusalem. Pagabot nindo doto masosolang nindo ang tao nga nagadara ang banga nga may tobig. Sonoda nindo tana ");
INSERT INTO clu_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","kag kon diin nga balay tana magsulud, toladia indong iambal sa tagbalay, ‘Ang Manogtodlo nagapamangkot kon diin ang koarto nga anang kaunan kaiban anang mga somolonod para sa pagsilibrar ang Pista anang Paglubas ang Angil.’ ");
INSERT INTO clu_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ipakita na dayon kanindo ang mawayang nga koarto sa ibabaw nga komplito ang kagamitan kag priparado ron. Doto kamo magimus atun yapon.” ");
INSERT INTO clu_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Nagpanaw ang darwa nga anang ginsogo, kag pagabot nanda sa siodad nakita nanda ang tanan sono sa anang ginkoon ni Jesus kananda. Kag doto sanda nagpriparar andang yapon para sa pista. ");
INSERT INTO clu_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Pagkasirum, nagabot si Jesus kag anang dosi ka somolonod. ");
INSERT INTO clu_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Mintras nagakaraun sanda sa lamisa, makon ni Jesus, “May isogid ako kanindo nga matatabo dadi. Isara kanindo nga kaiban ko dadi sa pagkaun maman ang magatraidor kanakun.” ");
INSERT INTO clu_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Pagkabati dato anang mga somolonod, naborido sanda kag kada isara kananda nagpamangkot kanana, makon nanda, “Bukun ako, ano?” ");
INSERT INTO clu_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Makon ni Jesus kananda, “Ang magatraidor kanakun isara sa kanindo nga dosi nga nagasaro kanakun sa mangkok. ");
INSERT INTO clu_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ako nga Naging Tao mapapatay sono sa tagna sa Kasolatan, piro kailo ra ang tao nga magatraidor kanakun! Mas mayad pa kon ara tana run lang nabata.” ");
INSERT INTO clu_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Mintras nagakaraun sanda, nagbuul si Jesus ang tinapay. Ginpasalamatan na dato sa Dios kag ginpamisang-pisang na dayon. Pagkatapos ginapanaw na sa anang mga somolonod nga nagakoon, “Kaun kamo, maman dia akun lawas.” ");
INSERT INTO clu_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Pagkatapos nagbuul tana dayon ang irinumun kag nagpasalamat ruman sa Dios, kag ginpanaw na kananda. Kag sanda tanan naginum dayon. ");
INSERT INTO clu_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Makon na kananda, “Maman dia akun dogo nga iola para sa dorong tao. Dia nagapamatood nga may bago nga kasogtanan ang Dios sa mga tao. ");
INSERT INTO clu_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Sa matood tana, ako indi run magoman inum ang irinumun nga alin sa obas asta sa adlaw nga magainum ako ang bago sa anang ginarian ang Dios.” ");
INSERT INTO clu_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Nagkanta sanda dayon mga pagdayaw sa Dios, kag pagkatapos nagayan sanda sa Bokid ang mga Olivo. ");
INSERT INTO clu_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Makon ni Jesus sa anang mga somolonod, “Tanan kamo magabaya kanakun, ay makon ang Dios sa Kasolatan, ‘Patayun ko ang manogbantay kag magararapta ang mga karniro.’ ");
INSERT INTO clu_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Piro pagkatapos nga ako mabanaw, maona ako kanindo doto sa probinsya ang Galilea.” ");
INSERT INTO clu_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Makon ni Pedro kanana, “Bisan sanda tanan magbaya kanimo ako tana indi gid.” ");
INSERT INTO clu_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Makon ni Jesus kanana, “Ang matood tana, karon mismo sa gabi bago makatorook ang manok karwa, katlo mo ako ron ipanginwara nga ara kaw kakilala kanakun.” ");
INSERT INTO clu_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Piro nagparugus gid si Pedro, makon na, “Indi ta kaw gid ipanginwara abir patayun nanda ako nga kaiban kanimo.” Kag maman ra anang koon ang tanan nga mga somolonod. ");
INSERT INTO clu_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Nagayan sanda dayon sa logar nga ginatawag nga Getsemani. Pagabot nanda doto, makon ni Jesus sa anang mga somolonod. “Pagpongko kamo digi mintras nagapangamoyo ako.” ");
INSERT INTO clu_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Piro gindara na si Pedro, si Santiago, kag si Juan doto sa onaan. Nagabot ang kagolo sa anang isip. ");
INSERT INTO clu_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Makon na kananda, “Midyo mapatay ako dadi sa kalisud. Magpasala kamo digi kag magbantay.” ");
INSERT INTO clu_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Pagkaayan na sa marayu-rayu, nagdapa tana sa logta kag nagpangamoyo nga kon maimo palampasun lang ang pagantos nga anang ginaatobang. ");
INSERT INTO clu_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Makon na, “Amay, ang tanan nga butang maimo mo. Gani kon maimo ilikaw mo ang pagantos nga nagaabot kanakun. Piro bukun akun gosto ang dapat matoman kondi ang kanimo.” ");
INSERT INTO clu_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Nagbalik tana sa anang tatlo ka somolonod kag naabotan na sanda nga nagakaratorog. Makon na dayon kay Pedro, “Simon, ay dan, nagakatorog kaw? Indi ka gid makapolaw bisan sangka oras lang?” ");
INSERT INTO clu_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Kag makon na kananda, “Magpolaw kamo kag magpangamoyo nga indi kamo madaug ang panolay. Naliliag kamo ra andan magpangamoyo garing indong lawas masyado karoya.” ");
INSERT INTO clu_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Nagayan ruman si Jesus sa onaan-onaan kag nagpangamoyo. Anang pangamoyo pario ra ang dati. ");
INSERT INTO clu_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Pagkatapos nagbalik tana ruman sa anang mga somolonod kag naabotan na sanda ruman nga nagakatorog, ay nadoyog sanda gid nga mayad. Kag indi nanda maulaman kon ano andang isabat. ");
INSERT INTO clu_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Sa anang ikatlo nga pagbalik makon na kananda, “Ta, nagakaratorog kamo pa ra gid kag nagaparawayway? Osto ron dan! Maman run dia ang oras nga Ako nga Naging Tao iintriga run sa mga makakasala. ");
INSERT INTO clu_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ta run! Way, dagi run ang tao nga matraidor kanakun.” ");
INSERT INTO clu_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Mintras nagaambal pa si Jesus nagabot si Judas nga isara sa dosi ka somolonod. Dorong tao anang kaiban kag may dara sanda nga mga ispada kag mga inoglampus. Ginsogo sanda ang mga manogdomara nga mga pari kag mga manogtodlo ang Kasogoan kag mga maulam-ulam nga mga Judio. ");
INSERT INTO clu_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Nagsogid nga lagi si Judas nga traidor sa mga manogdakup kon ano anang isinyas. Makon na, “Ang tao nga akun arukan maman ang tao nga indong ginapangita. Dakupa nindo tana kag daraun nga ginagoardyaan nga mayad.” ");
INSERT INTO clu_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Gani pagabot ni Judas, diritso tana nga lagi kay Jesus kag nagkoon, “Manogtodlo!” Kag ginarukan na dayon. ");
INSERT INTO clu_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Pagkatapos dato gindakup nanda si Jesus. ");
INSERT INTO clu_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Piro may isara sa anang mga kaiban ni Jesus nga naggabot anang ispada kag ginlabo na anang sorogoon ang pinakamataas nga pari kag natigbas anang talinga. ");
INSERT INTO clu_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Makon dayon ni Jesus sa mga nagdakup kanana, “Ano, ako tolisan nga kinanglan nindo gid nga magdara pa ang mga ispada kag mga inoglampus sa pagdakup kanakun? ");
INSERT INTO clu_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Kabay adlaw-adlaw dian ako sa timplo nga nagatodlo kag doto kamo ra. Ta basi ara nindo ako nga lagi pagdakupa? Garing kinanglan nga dia matabo agud matoman ang mga nakasolat sa Kasolatan parti kanakun.” ");
INSERT INTO clu_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Kag ginbayaan tana dayon anang mga somolonod kag nagparalagyaw sanda tanan. ");
INSERT INTO clu_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","May sangka soltiro doto nga nagsonod kay Jesus nga nagapangalikupkup lang ang manipis nga lino nga panaptun. Gindakup tana ra ang mga soldado, ");
INSERT INTO clu_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","garing nakapangimodlos tana kag nagpalagyaw nga oblas, ay naawidan nanda anang ginapangalikupkup. ");
INSERT INTO clu_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Gindara nanda si Jesus sa anang balay ang pinakamataas nga pari. Doto nagatiripon ang mga manogdomara nga mga pari, ang mga maulam-ulam ang mga Judio, kag ang mga manogtodlo ang Kasogoan. ");
INSERT INTO clu_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Si Pedro tana nagsonod ra, garing doto tana lang sa marayu-rayu. Nagsulud tana sa anang lagwirta ang balay ang pinakamataas nga pari kag nagpongko sa anang ginapongkoan ang mga goardya agud magpainit-init sa kalayo. ");
INSERT INTO clu_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Karon, ang mga manogdomara nga mga pari kag ang tanan nga mimbro ang Konsilyo ang mga Judio nagpangita mga ibidinsya kontra kay Jesus agud mapatay nanda tana, piro ara sanda gid may nakita. ");
INSERT INTO clu_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Doro matood ang nagtistigo ang botig kontra kanana piro ara nagsirinanto andang mga sogid. ");
INSERT INTO clu_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","May mga tao pa gid doto nga nagtistigo ra ang botig kontra kay Jesus, makon nanda, ");
INSERT INTO clu_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Nabatian namun tana nga nagakoon nga gubaun na kono ang timplo nga dia nga ginpatindug ang tao, kag sa sulud tatlo ka adlaw patindugun na ang iba nga timplo nga bukun tao ang maimo.” ");
INSERT INTO clu_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Piro pati andang mga sogid ara ra nagirinsakto. ");
INSERT INTO clu_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Nagtindug sa tunga ang pinakamataas nga pari kag nagpamangkot kay Jesus, makon na, “Ta, ara kaw gid isabat sa mga akosasyon nga dan kontra kanimo?” ");
INSERT INTO clu_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ara gid naglimug-limug si Jesus. Gani ginpamangkot tana ruman ang pinakamataas nga pari, makon na, “Ikaw bala ang Cristo nga Bata ang Darayawon nga Dios?” ");
INSERT INTO clu_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Makon ni Jesus kanana, “Uu, ako matood, kag Ako nga Naging Tao makikita nindo nga nagapongko sa anang too ang Makagagaum nga Dios, kag makikita nindo ako ra sa mga panganod sa langit nga nagabalik digi sa kalibotan.” ");
INSERT INTO clu_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Pagkabati dato ang pinakamataas nga pari, ginisak na anang lambong sa kasilag kag nagkoon, “Indi ta run kinanglan ang iba pa nga mga tistigos. ");
INSERT INTO clu_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Nabatian nindo mismo dadi anang pagpasipala sa Dios. Ano sa kanindo?” Kag ginsintinsyaan nanda tana nga patayun. ");
INSERT INTO clu_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ang iba kananda nagdopra kay Jesus. Gintabonan nanda anang mga mata kag ginsombag. Makon nanda dayon, “Pintoa kon sino ang nagsombag kanimo?” Pagkatapos ginbuul tana ang mga goardya kag ginpikaan nanda tana sampal. ");
INSERT INTO clu_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Si Pedro tana doto pa sa lagwirta kag nagagi ang isara sa mga babai nga sorogoon ang pinakamataas nga pari. ");
INSERT INTO clu_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pagkakita na kay Pedro nga nagapainit-init sa kalayo, ginpamolalungan na kag magkoon, “Kabay kaiban kaw ni Jesus nga taga-Nazaret?” ");
INSERT INTO clu_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Piro nagpanginwara tana nga nagakoon, “Ara ako gid kaulam kon ano imong ginaambal.” Pagkaambal dato ni Pedro nagayan tana sa poirtaan ang kodal. Sa oras ra gid nga dato nagtorook ang manok. ");
INSERT INTO clu_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Doto nakita tana ruman ang sorogoon nga babai, kag makon na sa mga tao doto, “Dia nga tao isara ra sa anang mga kaiban ni Jesus.” ");
INSERT INTO clu_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Piro nagpanginwara ruman si Pedro. Lagat-lagat makon ang mga tao doto, “Anang kaiban ka ra gid ay taga-Galilea ka ra.” ");
INSERT INTO clu_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Piro nagpanompa run gid si Pedro nga nagakoon, “Mapatay ako pa! Ara ako gid baya kakilala sa tao nga dan nga indong ginakoon.” ");
INSERT INTO clu_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Pagkatapos na ambal nagtorook roman ang manok. Kag nadumduman dayon ni Pedro anang ginambal kanana ni Jesus nga bago magtorook ang manok karwa, ipanginwara na tana tatlo ka bisis. Kag nagpanangis tana dayon. ");
INSERT INTO clu_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Pagkaaga, aga pa gid, nagmiting ang mga manogdomara nga mga pari kaiban ang mga manogdomara ang mga Judio, ang mga manogtodlo ang Kasogoan kag ang iba pa nga mga konsyal ang mga Judio. Gingapos nanda si Jesus kag gindara doto kay Pilato nga gobirnador kag ginintriga dayon kanana. ");
INSERT INTO clu_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ginpamangkot tana ni Pilato, makon na, “Ikaw gali anang Ari ang mga Judio?” Makon ni Jesus kanana, “Ginambal mo.” ");
INSERT INTO clu_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Doro anang ginbintang ang mga manogdomara nga mga pari kontra kay Jesus. ");
INSERT INTO clu_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Gani ginpamangkot tana ruman ni Pilato, makon na, “Ta ara kaw gid may isabat sa mga bintang nga dan? Doro gid andang ginabintang kontra kanimo.” ");
INSERT INTO clu_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Piro ara gid magsabat si Jesus, gani natingala nga mayad si Pilato. ");
INSERT INTO clu_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Karon, kada Pista anang Paglubas ang Angil nakaogalian ni Pilato nga magbolyaw sangka priso nga ginpangayo ang mga tao nga bolyawan. ");
INSERT INTO clu_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Natabo ra dato nga may sangka tao doto nga anang aran si Barrabas. Dia nga tao ginpriso kaiban ang mga tao nga nakapatay pagribildi nanda sa gobyirno. ");
INSERT INTO clu_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Dorong tao ang nagparapit kay Pilato kag nagpangabay nga imoon na ruman sa toig nga dato anang dati nga ginaimo. ");
INSERT INTO clu_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Makon na kananda, “Gosto nindo bala nga bolyawan ko anang Ari ang mga Judio?” ");
INSERT INTO clu_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ay naulaman ni Pilato nga naakig kay Jesus ang mga manogdomara nga mga pari, maman dato nga ginakosar nanda si Jesus doto kanana. ");
INSERT INTO clu_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Piro anang ginimo ang mga manogdomara nga mga pari, ginkonan nanda ang mga tao nga si Barrabas andang pangayoon kag bukun si Jesus. Kag maman da gani andang ginimo. ");
INSERT INTO clu_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ginpamangkot ni Pilato ang mga tao, makon na, “Ta ano akun imoon sa tao nga indong ginakoon nga anang Ari ang mga Judio?” ");
INSERT INTO clu_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Nagsiringgit ang mga tao, makon nanda, “Ilansang sa kros!” ");
INSERT INTO clu_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Makon ni Pilato kananda, “Ay basi, ano nga sala anang naimo?” Piro tinodoan nanda pa gid singgit nga nagakoon, “Basta ilansang tana sa kros!” ");
INSERT INTO clu_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Gani tungud nga gosto ni Pilato nga paoyonan ang mga tao, ginbolyawan na si Barrabas. Piro si Jesus tana anang ginpaanot kag ginintriga sa mga soldado agud ilansang sa kros. ");
INSERT INTO clu_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Gindara ang mga soldado si Jesus sa sulud anang palasyo ang gobirnador kag gintawag nanda ang bilog nga batalyon nga mga soldado nga magtiripon doto. ");
INSERT INTO clu_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Pagkatapos ginsokloban nanda tana ang kapa nga granati kag nagimo sanda koro-korona nga poros siit kag ginsoklob nanda dayon sa anang olo ni Jesus. ");
INSERT INTO clu_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Pagkatapos, dayon sandang soro-salodo kanana nga nagakoon, “Dayawon anang Ari ang mga Judio!” ");
INSERT INTO clu_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Kag ginpikaan nanda tana lampus ang baston-baston sa anang olo kag gindoraan nanda pa. Ginlood-loodan nanda ra tana kag ginsorosimba bilang insolto kanana. ");
INSERT INTO clu_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Pagkatapos andang yagota kanana, ginoba nanda ang kapa nga granati kag ginpasoksok roman anang lambong. Gindara nanda tana dayon sa goa ang banwa agud ilansang sa kros. ");
INSERT INTO clu_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ang sa dalan sanda run, nasoblang nanda ang sangka tao nga alin sa bokid. (Anang aran ang tao nga dato si Simon nga taga-Cirene, nga tatay ni Alejandro kag ni Rufo). Ginpirit nanda tana nga magpasan anang kros ni Jesus. ");
INSERT INTO clu_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Kag gindara nanda dayon si Jesus sa logar nga kon tawagun Golgota (nga anang gostong ambalun, logar nga midyo sa bongo.) ");
INSERT INTO clu_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Pagabot nanda doto gintawan nanda si Jesus ang bino nga may lakut nga mira, piro ara paginuma ni Jesus. ");
INSERT INTO clu_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Kag ginlansang nanda tana dayon sa kros. Pagkatapos ginparti-parti nanda anang lambong paagi sa pagbonot-bonot, agud maulaman kon ano anang mabuul ang kada isara. ");
INSERT INTO clu_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Mga alas noibi ang aga nanda ginlansang si Jesus. ");
INSERT INTO clu_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ang nakasolat sa karatola sa kros bilang bintang kontra kanana nagakoon, “Anang Ari ang mga Judio.” ");
INSERT INTO clu_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","May darwa ra doto ka tolisan nga ginlansang sa kros, ang isara sa anang too kampi ni Jesus kag ang isara sa anang wala. ");
INSERT INTO clu_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Sa toladia nga paagi natoman ang tagna nga nasolat sa Kasolatan nga nagakoon, “Ginbilang tana nga isara sa mga kriminal.” ");
INSERT INTO clu_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ang mga tao nga nagarulubas doto sa marapit nagtarango-tango andang olo nga nagainsolto kag nagayagota kay Jesus. Makon nanda, “Ay dan, gubaun mo kabay ang timplo kag sa ikatlo ka adlaw patindugun mo roman. ");
INSERT INTO clu_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ta kondi maglosong kaw dian sa kros kag lowasun imong kaogalingun!” ");
INSERT INTO clu_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Maman ra dato anang yagota ang mga manogdomara nga mga pari kag mga manogtodlo ang Kasogoan. Makon nanda sa isara kag isara, “Ginlowas na ang iba, piro indi tana makalowas anang kaogalingun. ");
INSERT INTO clu_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Sulungun ta abi dadi kon makalosong sa kros ang Cristo nga Ari kono ang Israel, kag kon makalosong tana matoo kita kanana.” Pati anang mga kaiban nga ginlansang naginsolto ra kanana. ");
INSERT INTO clu_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Pagogto ang adlaw, nagdulum ang kalibotan sa sulud tatlo ka oras. ");
INSERT INTO clu_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Kag pagalas tris ang apon nagsinggit si Jesus ang mabaskug, makon na, “Eloi, Eloi lema sabactani?” Anang gostong ambalun, “Dios ko, Dios ko, basi ginpabayanan mo ako?” ");
INSERT INTO clu_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Makon ang iba nga nagatirindug doto nga nakabati sa anang ginsinggit, “Ginatawag na si Elias.” ");
INSERT INTO clu_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Domalagan ang sangka tao kag nagbuul isponga kag gintosmog na sa maaslum nga bino. Pagkatapos gintakud na sa sangka sanga agud ipasupsup kay Jesus. Makon na, “Sulungun ta anay kon maabot si Elias agud bulun tana sa kros nga dan.” ");
INSERT INTO clu_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Nagsinggit todo si Jesus kag nabogto dayon anang ginawa. ");
INSERT INTO clu_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Kag sa oras nga dato, ang kortina sa sulud ang timplo sa Jerusalem nagisak sa tunga, alin sa ibabaw paidalum. ");
INSERT INTO clu_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Anang kapitan ang mga soldado nga nagatindug sa atobangan ang kros nga ginalansangan kay Jesus nakakita kon paiwan nabogto anang ginawa ni Jesus. Makon na, “Matood ra gid nga ang tao nga dia anang Bata ang Dios!” ");
INSERT INTO clu_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Sa marayu-rayu may pira ra ka babai nga nagalantaw sa nagakaratabo. Ang iba kananda si Salome, si Maria nga taga-Magdala, kag si Maria nga anang nanay ni Jose kag ni Santiago nga anang libayun. ");
INSERT INTO clu_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ang doto pa si Jesus sa Galilea dia nga mga babai nagatawas kag nagabolig kanana. Kag may iba pa ra nga mga babai doto nga nagtabid kay Jesus anang pagayan sa Jerusalem. ");
INSERT INTO clu_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Nataboan nga ang adlaw nga napatay si Jesus adlaw nga inogpriparar para sa pista. Apon ron kag tungud nga ang madason nga adlaw Adlaw ron nga Inogpaway, nagpatutum si Jose nga taga-Arimatea nga magayan kay Pilato agud pangayoon anang bangkay ni Jesus. Si Jose nga dia isara sa mga ginataod nga mimbro ang Konsilyo kag isara ra sa mga nagapaabot anang pagari ang Dios. ");
INSERT INTO clu_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pagkabati ni Pilato nga si Jesus patay run, natingala tana. Gani ginpatawag na anang opisyal ang mga soldado kag ginpamangkot na kon patay run gani si Jesus. ");
INSERT INTO clu_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pagkatapos nga mabatian ni Pilato anang sogid ang opisyal nga patay run si Jesus, gintogotan na si Jose nga bulun anang bangkay. ");
INSERT INTO clu_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Gani nagbakal si Jose ang maraalun nga tila nga poti. Kag ginpatangtang na dayon anang bangkay ni Jesus sa kros kag ginbarubudan ang tila nga dato nga anang ginbakal. Pagkatapos ginpabutang na dayon sa rulubungan nga midyo sa giub nga gingoab sa bato. Kag nagpaligid tana dayon ang mabaul nga bato bilang takup sa anang poirtaan ang rulubungan. ");
INSERT INTO clu_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Nagasulung ra doto si Maria nga taga-Magdala kag si Maria nga nanay ni Jose, gani nakita nanda kon diin ginlubung si Jesus. ");
INSERT INTO clu_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Pagkatapos ang Adlaw nga Inogpaway, si Maria nga taga-Magdala, si Maria nga nanay ni Santiago kag si Salome nagbarakal paamot nga inoglugud sa patay ay maayan sanda sa ginlubungan kay Jesus agud lugudan anang bangkay. ");
INSERT INTO clu_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ang adlaw ang Domingo, aga sanda pa gid nagayan sa ginlubungan. ");
INSERT INTO clu_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","Mintras nagapanaw sanda, makon nanda, “Ta sino kabay atun pangabayun nga magpaligid ang bato nga nagatakup sa ginlubungan?” (Ay masyado ka baul anang takup nga dato nga bato). Piro pagabot nanda doto, nakita nanda nga ang bato ginpaligid run. ");
INSERT INTO clu_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Gani dayon sandang sulud sa ginlubungan kag nakita nanda ang sangka lalaki nga bataun pa, mapoti anang lambong kag nagapongko sa too kampi. Kag ginpangadlukan sanda nga mayad. ");
INSERT INTO clu_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Makon dayon ang lalaki nga dato kananda, “Indi kamo magkaadluk! Ulam ko nga ginapangita nindo si Jesus nga taga-Nazaret nga ginlansang sa kros. Ara tana run digi! Nabanaw tana run! Dali kamo, sulunga nindo ang ginbutangan kanana.” ");
INSERT INTO clu_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Pagkatapos nga andang nakita dato makon na, “Ta panaw kamo, sogidi nindo anang mga somolonod kag labi run gid si Pedro nga maona si Jesus doto sa Galilea, kag doto nindo tana makikita sono sa anang koon kanindo.” ");
INSERT INTO clu_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Gani naggoroa ang mga babai sa ginlubungan kag nagdaralagan ay nagakurudug sanda sa kulba. Ara sanda gid may ginsogidan ay ginpangadlukan sanda gani. ");
INSERT INTO clu_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Timprano pa gid ang Domingo nabanaw si Jesus. Primiro gid nagpakita tana kay Maria nga taga-Magdala nga anang ginsobolan ang pito ka malain nga ispirito. ");
INSERT INTO clu_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Pagkatapos ginayanan ni Maria anang mga somolonod ni Jesus nga nagaparaborido kag nagaparanangis kag ginsogidan na sanda. ");
INSERT INTO clu_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Garing ara sanda nagpati sa anang sogid nga si Jesus boi kag nagpakita kanana. ");
INSERT INTO clu_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Pagkatapos dato, nagpakita si Jesus sa iba nga itsora sa anang darwa ka somolonod mintras nagapaayan sanda sa bokid. ");
INSERT INTO clu_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Gani nagbalik sa Jerusalem anang darwa ka somolonod kag ginsogidan nanda andang mga kaiban nga si Jesus nagpakita kananda, piro ara sanda ra nagpati. ");
INSERT INTO clu_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ang ori nagpakita ruman si Jesus sa onsi ka somolonod mismo mintras nagakaraun sanda. Ginsabdung na sanda tungud nga ara sanda pagtoo kag tungud sa katugas andang mga tagiposoon, ay ara sanda nagpati sa anang sogid ang mga nakakita kanana pagkatapos nga tana nabanaw. ");
INSERT INTO clu_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Pagkatapos dato makon ni Jesus kananda, “Panaw kamo sa bilog nga kalibotan kag iwali ang Mayad nga Barita parti kanakun sa tanan nga mga tao. ");
INSERT INTO clu_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ang bisan sino nga magtoo kag mabunyagan malowas, piro ang indi magtoo silotan. ");
INSERT INTO clu_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ang mga tanda nga dia makikita sa mga tao nga nagatoo kanakun: paagi sa akun gaum magapalayas sanda ang mga malain nga ispirito sa mga tao nga andang ginsuludan; magaambal sanda sa ibang mga ambal nga ara nanda natoni; ");
INSERT INTO clu_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","kon makakaput sanda ang mga magkal okon makainum sanda bisan ano nga ilo indi sanda maiwan; kag kon itongtong nanda andang alima sa mga nagamasakit, magaayad.” ");
INSERT INTO clu_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Pagkaambal kananda ni Jesus gindara tana paibabaw sa langit kag nagpongko dayon sa anang too ang Dios. ");
INSERT INTO clu_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Nagparangwalian dayon anang mga somolonod sa bisan diin nga logar kag ginboligan sanda ang Ginoo. Kag ginpamatodan na anang ginawali ang mga somolonod paagi sa mga tanda nga andang naimo.");
INSERT INTO clu_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Taraodon nga Teofilo: Doro ron ang mga nagsolat parti sa mga butang nga nagkaratabo digi kanatun. ");
INSERT INTO clu_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ginsolat nanda ang parti kay Jesus nga ginsaysay ra kanatun ang mga tao nga nakakita mismo ang mga nagkaratabo alin pa ang ompisa, nga maman ra ang nagasogid ang Mayad nga Barita. ");
INSERT INTO clu_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Kag ginosisa ko gid dia tanan alin ra ang ona pa, kag naisip ko nga isolat ang nagkaratabo kag isaysay ang maatag kanimo ");
INSERT INTO clu_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","agud masigoro mo nga matood manda ang mga butang nga ginasogid kanimo. ");
INSERT INTO clu_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ang si Herodes ang ari sa Judea, may pari doto nga anang aran si Zacarias. Isara tana sa gropo ni Abias. Anang asawa si Elizabet nga alin ra sa lai ang mga pari. ");
INSERT INTO clu_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ang magasawa nga dia pario nga nagakaboi ang matarung sa panulung ang Dios ay ginasonod nanda ang tanan nga anang mga sogo. ");
INSERT INTO clu_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Garing ara sanda bata tungud nga si Elizabet bawas kag pario sanda nga malam run. ");
INSERT INTO clu_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Karon nagabot ang adlaw nga anang gropo ron nanday Zacarias ang magasirbi sa Dios doto sa timplo. ");
INSERT INTO clu_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Nagboronot-bonot ang mga pari sono sa andang nakaogalian kag si Zacarias maman ang napili nga magsonog ang insinso sa altar. Gani nagsulud tana doto sa timplo ang Ginoo. ");
INSERT INTO clu_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Mintras nagasonog tana ang insinso doto sa sulud, dorong mga tao doto sa goa ang nagaparangamoyo sa Dios. ");
INSERT INTO clu_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Malagat-lagat nagpakita kanana anang angil ang Ginoo nga nagatindug sa too kampi ang altar nga anang ginasonogan ang insinso. ");
INSERT INTO clu_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Pagkakita ni Zacarias sa angil nagolpian tana kag ginadlukan. ");
INSERT INTO clu_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Piro nagkoon ang angil kanana, makon na, “Zacarias indi kaw magkaadluk! Ginsabat ang Dios imong pangamoyo; si Elizabet nga imong asawa magabata lalaki. Aranan mo nga Juan. ");
INSERT INTO clu_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Malilipay kaw nga mayad kanana kag doro nga mga tao ang malilipay ra sa anang pagkabata. ");
INSERT INTO clu_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ay magiging mataas tana sa panulung ang Ginoo. Indi tana dapat maginum ang bino okon bisan ano nga irinumun nga makarilingin. Alin lagi sa anang tian anang nanay dian run kanana ang Ispirito Santo. ");
INSERT INTO clu_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Kag paagi sa anang mga panodlo doro anang mga kaapo-apoan ni Israel anang pabalikun sa Ginoo nga andang Dios. ");
INSERT INTO clu_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Maoona tana sa Ginoo agud ipriparar na ang mga tao para sa anang pagabot ang Ginoo. Itaw kanana ang Dios ang Ispirito kag ang gaum nga pario ang sa kay Elias ang ona. Pabalikun na anang kalolo ang mga ginikanan sa andang mga bata, kag ang mga tao nga ara nagatoman sa Dios ana ra nga pabalikun sa matarung nga pagisip.” ");
INSERT INTO clu_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Makon ni Zacarias sa angil, “Ta paiwan ko masigoro nga matatabo imong ginaambal nga dan, ay kami nga magasawa malam run?” ");
INSERT INTO clu_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Nagsabat ang angil, makon na, “Ako si Gabriel nga sorogoon ang Dios, kag doto ako pirmi sa anang tupad. Tana ang nagsogo kanakun nga sogidan kaw ang mayad nga barita nga akun ginsogid kanimo. ");
INSERT INTO clu_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Piro tungud nga ara kaw nagpati sa akun ginsogid magaapa kaw asta sa adlaw nga matoman akun ginsogid kanimo, ay dia matotoman gid tana kon magabot ron ang adlaw nga gintaning ang Dios.” ");
INSERT INTO clu_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ang mga tao tana sa goa, sigi run andang ulat kay Zacarias, kag natingala sanda kon basi naboay tana run doto sa sulud ang timplo. ");
INSERT INTO clu_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Pagkagoa na indi tana run makaambal. Sigi run lang anang sinyas sa mga tao. Gani nasatuman nanda nga may ginpakita kanana ang Dios doto sa sulud ang timplo. Alin dato naging apa tana run. ");
INSERT INTO clu_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Pagkatapos anang torno sa pagsirbi doto sa timplo, nagoli tana. ");
INSERT INTO clu_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Magpira ka adlaw, nagpanamkun gani si Elizabet nga anang asawa. Kag sa sulud lima ka bolan ara tana naggoa-goa sa balay. ");
INSERT INTO clu_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Makon na, “Ginkaloyan ako ra gid ang Ginoo ay dadi ginlibri na ako ron sa akun kauruyan sa mga tao tungud nga ako bawas.” ");
INSERT INTO clu_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ang mga anum ka bolan anang budus ni Elisabet, ginsogo roman ang Dios ang angil nga si Gabriel nga magayan sa Nazaret nga sangka banwa sa Galilea. ");
INSERT INTO clu_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ginpaayan tana doto sa daraga nga anang aran si Maria. Si Maria nga dia karasalun run kay Jose, nga isara sa anang mga kaapo-apoan ni aring David. ");
INSERT INTO clu_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Gani nagayan ang angil nga si Gabriel kay Maria kag nagkoon, makon na, “Maria, magkalipay kaw, ay ang Ginoo kaiban mo kag ikaw anang ginkaloyan.” ");
INSERT INTO clu_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Pagkabati dato ni Maria naglibug anang olo, kag ginbinag-binag na kon ano anang gostong ambalun. ");
INSERT INTO clu_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Gani makon ang angil kanana, “Maria indi kaw magkaadluk. Mabaul nga dungug anang gintaw ang Dios kanimo. ");
INSERT INTO clu_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Magabudus kaw kag magabata lalaki. Kag kon mabata tana run gani, aranan mo tana nga Jesus. ");
INSERT INTO clu_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Maging bantog tana kag kikilalaun nga anang Bata ang Dios nga labaw sa tanan. Kanana ipasobli ang Ginoong Dios ang ginarian anang kaolang-olangan nga si David. ");
INSERT INTO clu_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Magaari tana sa anang mga kaapo-apoan ni Jacob asta kon sano; anang ginarian magapadayon nga ara kataposan.” ");
INSERT INTO clu_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Makon ni Maria sa angil, “Ta paiwan dia ay ako ara pa asawa?” ");
INSERT INTO clu_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Nagsabat ang angil, makon na, “Ang Ispirito Santo magakunsad kanimo, kag magalikup dayon kanimo anang gaum ang Dios nga labaw sa tanan. Maman dan nga diosnon ang bata nga imong ibata kag tawagun nga anang Bata ang Dios. ");
INSERT INTO clu_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Isipa bala imong paryinti nga si Elisabet. Nagkoon ang mga tao nga indi tana magbata tungud nga malam tana run gid. Piro dadi anum run ka bolan anang budus, ");
INSERT INTO clu_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","tungud nga sa Dios tana, ang tanan sarang maimo.” ");
INSERT INTO clu_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Gani makon ni Maria, “Sorogoon ako lang ang Ginoo. Kabay pa nga matoman kanakun imong ginambal.” Kag nagalin dayon ang angil. ");
INSERT INTO clu_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Magpira ka adlaw nagimus si Maria kag nagdali-dali ayan sa sangka banwa nga may dorong bokid nga sakup ang Judea. ");
INSERT INTO clu_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Kag doto nagsulud tana sa anang balay nanday Zacarias kag nagpangamosta kay Elizabet. ");
INSERT INTO clu_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Pagkabati ni Elizabet sa anang pagpangamosta ni Maria, golpi ra nga nagolag mabaskug ang bata sa anang tian, kag gingauman si Elizabet ang Ispirito Santo. ");
INSERT INTO clu_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Kag sa mabaskug nga limug nagambal tana dayon, makon na, “Sa tanan nga babai ikaw lang ang ginbindisyonan ang Dios ang toladia! Kag ginbindisyonan na ra imong ginabudus nga dan. ");
INSERT INTO clu_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Mabaul dia nga dungug kanakun tungud nga ako ginbisita anang nanay akun Ginoo. ");
INSERT INTO clu_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Naulaman ko ang parti kanimo tungud nga pagkabati ko imong pangomosta, ang bata sa akun tian golpi nga nagolag ang mabaskug sa anang kalipay. ");
INSERT INTO clu_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Masoirti kaw gid tungud nga nagpati kaw nga ang ginpabarita kanimo ang Ginoo matotoman!” ");
INSERT INTO clu_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Makon dayon ni Maria, “Nagadayaw ako gid sa Ginoo! ");
INSERT INTO clu_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Kag nagakalipay ako nga mayad tungud sa Dios nga akun Manlolowas. ");
INSERT INTO clu_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ay gindumdum na ako nga anang kubus nga sorogoon. Alin dadi ang tanan nga mga tao magakoon nga masoirti ako, ");
INSERT INTO clu_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Tungud sa mga makatiringala nga mga butang nga ginimo kanakun ang Makagagaum nga Dios. Matarung tana, kag taraodon labaw sa tanan. ");
INSERT INTO clu_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Alin pa ang ona ginakaloyan na ang mga tao nga nagataod kanana. ");
INSERT INTO clu_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ginpakita na nga tana gamanan paagi sa anang mga inimoan. Gintabog na ang mga tao nga mataas andang pabutang sa andang kaogalingun. ");
INSERT INTO clu_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ginpaalin na ang mga gamanan nga mga ari sa andang trono. Kag ginpataas na ang mga kubus andang kaimtangan. ");
INSERT INTO clu_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Gintawan na ang mayad nga mga butang ang mga pobri, Piro ang mga manggaranun tana ginpaalin na lang nga ara gid dara. ");
INSERT INTO clu_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Kita nga anang mga sorogoon, nga mga kaapo-apoan ni Israel, ana nga ginboligan. Ay ara na paglipati anang pangako sa atun mga kaolang-olangan, nga si Abraham kag sa anang mga lai kaloyan na sa ara kataposan!” Maman dia anang ginpangambal ni Maria. ");
INSERT INTO clu_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Kag nagtinir tana doto kanday Elizabet mga tatlo ka bolan bago tana nagoli. ");
INSERT INTO clu_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Karon nagabot ron ang oras nga inogbata ni Elizabet, kag nagbata tana lalaki. ");
INSERT INTO clu_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Pagkabati anang mga kamalay kag mga paryinti nga tana ginkaloyan nga mayad ang Ginoo, nagkalipay sanda kaiban ni Elizabet. ");
INSERT INTO clu_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Datong walo ron ka adlaw ang bata, nagabot anang mga kamalay kag mga paryinti agud toriun ang bata sono sa andang nakaogalian. Aranan nanda tana andan nga Zacarias pario anang aran anang tatay, ");
INSERT INTO clu_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","garing indi magkompormi si Elizabet. Makon na, “Indi maimo, Juan tana ang iaran kanana.” ");
INSERT INTO clu_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Makon nanda, “Basi dato? Ara kamo gid paryinti nga toladan anang aran.” ");
INSERT INTO clu_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Kag ginsinyasan nanda anang tatay ang bata kon ano anang gosto nga iaran sa anang bata. ");
INSERT INTO clu_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Nagsinyas tana ra nga tawan tana ang sorolatan kag nagsolat tana dayon nga Juan anang aran. Kag natingala sanda nga tanan. ");
INSERT INTO clu_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Pagkatapos dato nakaambal run si Zacarias nga nagadayaw sa Dios. ");
INSERT INTO clu_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ginkulbaan andang mga kamalay sa barita parti sa mga butang nga dato nga natabo, kag naging bantog ra sa tanan nga mabokid-bokid nga mga logar ang Judea. ");
INSERT INTO clu_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Kag ang tanan nga mga tao nga nakabarita nagisip nga mayad. Makon nanda, “Maging ano kabay ang bata nga dia kon tana magbaul?” Ay nasatum ang mga tao nga kaiban na ang Ginoo. ");
INSERT INTO clu_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Si Zacarias nga anang tatay gingauman ang Ispirito Santo kag nagkoon tana dayon, makon na, ");
INSERT INTO clu_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Dayawon ta ang Ginoo nga anang Dios ang Israel! Ay gindumdum na kag ginlibri kita nga anang mga sinakupan. ");
INSERT INTO clu_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ginpadara na run kanatun ang makagagaum nga manlolowas nga isara sa anang mga kaliwat anang sorogoon anay nga si David. ");
INSERT INTO clu_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Dia maman ra nga lagi anang ginkoon paagi sa anang mga propita. ");
INSERT INTO clu_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Nagpangako tana nga lowasun na kita sa atun mga kaaway Kag sa mga tao nga nagadumut kanatun. ");
INSERT INTO clu_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Nagkoon tana ra nga kaloyan na atun mga kaolangan, Kag indi na gid paglipatan anang pangako kananda. ");
INSERT INTO clu_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Maman dan anang ginsompa sa atun kaolang-olangan nga si Abraham, ");
INSERT INTO clu_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Nga lowasun na kita gid sa atun mga kaaway Agud makasimba kita nga ara kaadluk. ");
INSERT INTO clu_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Kag maging balaan kag matarung kita sa anang panulung sa atun pangadlaw-adlaw nga pagkaboi digi sa kalibotan.” ");
INSERT INTO clu_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Pagkatapos dato nagambal dayon si Zacarias sa anang bata, makon na, “Ikaw tana, Juan, tatawagun nga anang propita ang Dios, ang Dios nga labaw sa tanan; Ay magaona kaw sa Ginoo agud sogidan mo ang mga tao nga magpriparar sanda para sa anang pagabot. ");
INSERT INTO clu_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Magatodlo kaw sa anang mga tao nga sanda malolowas sa andang mga sala, Kon sanda magpangayo patawad sa Dios. ");
INSERT INTO clu_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ay atun Dios maloloyon kag maigogmaun. Ipadara na ang Manlolowas nga maging pario sa anang pagmora ang adlaw ");
INSERT INTO clu_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Nga magasirak sa mga tao nga sa madulum kag naadlukan sa kamatayun. Magatodlo tana kanatun kon paiwan maging masadya atun rilasyon sa Dios kag sa atun kapario.” Maman dia anang ambal ni Zacarias. ");
INSERT INTO clu_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Karon, ang bata nga si Juan nagbaul kag naging mabaskug sa ispirito. Nagtinir tana sa naligwin nga logar asta sa adlaw nga tana nagompisa nga magtodlo anang ambal ang Dios sa anang kapario nga mga Israelita. ");
INSERT INTO clu_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Sa mga tyimpo nga dato, ang Impirador ang Roma nga si Augusto nagimo kasogoan nga ang tanan nga mga pomoloyo sa anang ginarian magpalista. ");
INSERT INTO clu_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","(Maman dato ang ona nga sinsos ang si Cirenio ang gobirnador sa probinsya ang Syria. ");
INSERT INTO clu_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Gani nagoli ang tanan nga tao sa anang kaogalingun nga banwa agud magpalista.) ");
INSERT INTO clu_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Maman dato nga si Jose nga nagaoli sa banwa ang Nazaret nga sakup ang Galilea nagbalik sa Betlehem nga sakup anang probinsya ang Judea, tungud nga isara tana sa anang mga kaliwat ni aring David nga nabata sa logar nga dato. ");
INSERT INTO clu_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Gindara ni Jose anang maging asawa nga si Maria nga nagabudus agud magpalista ra. ");
INSERT INTO clu_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Kag mintras doto sanda sa Betlehem nagabot anang oras nga inogbata. ");
INSERT INTO clu_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Kag nagbata tana gani kag anang bata lalaki. Maman dato anang panganay nga bata. Kag ginpotos na sa lampin kag ginpaingga sa sulud ang pasongan nga ginapakaunan ang mga ayup, ay doto sanda sa kamalig nga para sa mga ayup tungud nga ara logar para kananda sa mga balay nga darayonan. ");
INSERT INTO clu_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Marapit ra sa banwa ang Betlehem may mga manogbantay ang mga karniro nga nagaporolaw sa datag ay ginabantayan nanda andang mga karniro. ");
INSERT INTO clu_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Nagpakita kananda ang sangka angil ang Ginoo kag ginlikupan sanda anang sanag ang Ginoo. Ginpangadlukan sanda nga mayad, ");
INSERT INTO clu_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","piro makon ang angil kananda, “Indi kamo magkaadluk, ay nagayan ako digi kanindo agud sogidan kamo ang mayad nga barita nga magataw mabaul nga kalipay sa tanan nga mga tao. ");
INSERT INTO clu_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Nabata dadi indong Manlolowas sa anang banwa ni Aring David. Tana ang Ginoo nga ginpili ang Dios nga magari. ");
INSERT INTO clu_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ang tanda bilang pamatood sa akun ginakoon maman dia: makikita nindo ang bata nga ginapotos ang lampin kag nagaingga sa pasongan.” ");
INSERT INTO clu_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Pagkatapos ambal ang angil nga dato, golpi lang nga nagpakita ang doro gid nga mga angil kag nagirug kanana nga nagadayaw sa Dios nga nagakoon: ");
INSERT INTO clu_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Dayawon ang Dios sa langit, Digi sa logta malinung run anang kaimtangan ang mga tao nga anang naliagan!” ");
INSERT INTO clu_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Pagkatapos dato, nagbalik ang mga angil doto sa langit. Kag pagkaalin nanda, makon ang mga manogbantay ang mga karniro, “Dali, maayan kita sa Betlehem kag sulungun ta ang natabo nga dia nga anang ginpasogid kanatun ang Ginoong Dios!” ");
INSERT INTO clu_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Gani dali-dali sanda nga nagayan sa Betlehem kag pagabot nanda doto nakita nanda si Maria kag si Jose, kag ang bata nga nagaingga sa pasongan. ");
INSERT INTO clu_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Kag ginsaysay nanda anang ginambal ang angil parti sa bata. ");
INSERT INTO clu_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Natingala nga mayad ang tanan nga nakabati sa anang ginbarita ang mga manogbantay ang mga karniro. ");
INSERT INTO clu_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Gintipigan ni Maria ang mga butang nga dia sa anang tagiposoon kag ginaisip na pirmi. ");
INSERT INTO clu_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Nagbalik sa andang logar ang mga manogbantay nga dato ang mga karniro nga nagadayaw nga mayad sa Dios tungud sa tanan nga andang nabatian kag nakita nga sono gid sa anang ginsogid kananda ang angil. ");
INSERT INTO clu_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Pagabot ang ikawalo ka adlaw nga nabata ang lapsag gintori nanda kag ginaranan nga Jesus. Maman dia ang aran nga ginkoon ang angil nga iaran sa bata bago tana ginpanamkun. ");
INSERT INTO clu_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Karon, nagabot ang adlaw nga si Jose kag si Maria magaalad run sa timplo ang Jerusalem para tomanun anang Kasogoan ni Moises parti sa babai nga bagong nagbata agud maging limpyo sanda. Kag gindara nanda ra ang bata sa Jerusalem agud ialad sa Ginoo. ");
INSERT INTO clu_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ay nakasolat sa anang Kasogoan ang Ginoo nga “Ang kada panganay nga lalaki ialad sa Ginoo.” ");
INSERT INTO clu_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Kag agud maging limpyo si Maria nagalad sanda sono sa nakasolat sa anang Kasogoan ang Ginoo, nga “Darwa ka ladu okon darwa ka bataun nga salampati.” ");
INSERT INTO clu_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Doto sa Jerusalem may tao nga anang aran si Simeon. Dia nga tao matarung kag diosnon kag nagaulat tana nga matoman ang tagna nga boligan ang Dios ang mga taga-Israel sa andang kasubu. Dian kanana ang Ispirito Santo ");
INSERT INTO clu_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","nga nagpaayag kanana nga indi tana mapatay mintras ara na pa makita anang ipadara ang Ginoong Dios nga magaari. ");
INSERT INTO clu_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Karon, ginpasulud tana ang Ispirito Santo doto sa timplo. Kag doto ra gindara si Jesus anang mga ginikanan agud sonodon nanda anang ginkoon sa Kasogoan para kananda. ");
INSERT INTO clu_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Pagkakita ni Simeon sa bata, ginbuul na kag nagdayaw tana sa Dios; makon na, ");
INSERT INTO clu_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Dadi Ginoo, poidi mo ako ron nga bawiun, Tungud nga natoman run imong ginpangako kanakun. Mataway run akun isip. ");
INSERT INTO clu_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ay dadi nakita ko ron mismo ang Manlolowas ");
INSERT INTO clu_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Nga imong gintigana para sa tanan nga mga tao. ");
INSERT INTO clu_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Tana ang magataw kasanag sa anang mga isip ang mga bukun Judio nga ara kakilala kanimo, Kag magataw ra dungug kanamun nga mga kaapo-apoan ni Israel, nga imong mga pinili nga mga tao.” ");
INSERT INTO clu_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Natingala nga mayad anang tatay kag anang nanay ang bata sa anang ginambal nga dato ni Simeon parti sa bata. ");
INSERT INTO clu_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ginpangamoyo sanda ni Simon nga bindisyonan sanda ang Dios. Pagkatapos nagkoon tana kay Maria nga anang nanay ang bata, makon na, “Imong bata nga dia maman anang ginpili ang Dios nga magapanaba kag magapataas ang doro sa Israel. Maging tanda tana nga alin sa Dios, kag doro ang magaambal malain kontra kanana. ");
INSERT INTO clu_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ipakita na ang mga marimo nga isip ang mga tao ay magakontra sanda kanana. Kag ikaw bilang anang nanay magabatyag ang kasubu nga midyo ginabono imong tagiposoon.” ");
INSERT INTO clu_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","May sangka propita ra doto nga babai nga anang aran si Ana. Bata tana ni Fanuel nga anang kaapo-apoan ni Aser. Ang daraga tana pa ginpangasawa tana, piro pito lang ka dagon andang pagdapunan bilang magasawa ");
INSERT INTO clu_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","kag nabalo tana. Dadi 84 anyos tana run kag pirmi tana doto sa timplo, ay adlaw gabi ara tana iba nga ginaimo kondi ang magsimba sa Dios paagi sa mga pagpoasa kag pagpangamoyo. ");
INSERT INTO clu_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Nagparapit tana kanday Jose kag nagpasalamat sa Dios tungud sa bata. Kag nagambal tana ra parti kay Jesus sa mga tao nga nagapaabot ang adlaw nga libriun ang Dios ang mga kaapo-apoan ni Israel. ");
INSERT INTO clu_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Pagkatapos nga natoman nanday Jose kag Maria ang tanan nga ginapaimo anang Kasogoan ang Ginoo, nagoli sanda sa Galilea, sa andang banwa nga Nazaret. ");
INSERT INTO clu_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ang bata nagbaul kag nagbaskug kag nagaram nga mayad; kag ginbindisyonan tana ang Dios. ");
INSERT INTO clu_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Kada toig anang mga ginikanan ni Jesus nagaayan sa Jerusalem agud magpamista sa Pista anang Paglubas ang Angil. ");
INSERT INTO clu_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Kag ang si Jesus dosi run ka toig nagpamista sanda ra pario andang nakaogalian. ");
INSERT INTO clu_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Pagkatapos ang pista nagoli sanda, piro si Jesus tana nagpasala sa Jerusalem. Ara dia naulami anang mga ginikanan, ");
INSERT INTO clu_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ay andang pagsarig nagatabid tana ra sa andang mga kaiban nga nagaoroli. Gani sangka adlaw gid andang panaw. Ang ori ginpangita nanda si Jesus sa andang mga paryinti kag mga kakilala ");
INSERT INTO clu_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","kag bago nanda pa naulaman nga ara tana gali nakatabid. Gani nagbalik sanda sa Jerusalem agud pangitaun tana. ");
INSERT INTO clu_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ang ikatlo ron ka adlaw bago nanda tana nakita doto sa timplo nga nagapongko kaiban ang mga manogtodlo ang Kasogoan. Nagapamati tana kag nagapamangkot kananda. ");
INSERT INTO clu_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ang tanan nga nagaparamati kanana natingala gid sa anang mga naulaman kag mga sabat. ");
INSERT INTO clu_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Pagkakita kanana anang mga ginikanan, natingala sanda ra nga mayad. Kag makon anang nanay kanana, “Basi ginimo mo dia kanamun ni tatay mo? Ginkulbaan kami nga mayad sa amun pagpangita kanimo!” ");
INSERT INTO clu_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Makon ni Jesus kananda, “Ta basi ginpangita nindo ako? Ara kamo bala kaulam nga dapat digi ako sa anang balay akun Tatay?” ");
INSERT INTO clu_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Piro ara sanda kaangup kon ano anang gostong ambalun. ");
INSERT INTO clu_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Kag nagtabid run da lang si Jesus sa anang mga ginikanan paoli sa Nazaret, kag nagsonod tana sa tanan nga andang gosto. Dia tanan nga mga butang gintipigan ni Maria sa anang tagiposoon. ");
INSERT INTO clu_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Nagdogang pa gid anang kaaram ni Jesus kag padayon anang pagbaul, kag nalilipay gid nga mayad ang Dios kag ang mga tao kanana. ");
INSERT INTO clu_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Pagkalubas ang pira ka toig, may ginambal ang Dios kay Juan nga bata ni Zacarias doto sa naligwin nga logar. Dia natabo sa ika-15 ka toig anang pagdomara ni Tiberio bilang Impirador ang Roma. Sa tyimpo ra nga dato si Poncio Pilato ang gobirnador sa probinsya ang Judea, kag si Herodes ang manogdomara sa Galilea. Si Felipe tana nga kabogto ni Herodes maman ang manogdomara sa mga probinsya ang Iturea kag Traconite; kag si Lisanias maman ang sa probinsya ang Abilinia. Si Anas kag si Caifas ang mga pinakamataas nga pari. ");
INSERT INTO clu_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Tungud sa anang ginambal ang Dios kay Juan nagayan tana sa mga logar nga marapit sa Soba ang Jordan kag nagpangwalian. Nagkoon tana sa mga tao nga dapat inulsulan kag bayaan nanda run andang mga sala, kag magparabunyag dayon agud patawadun sanda ang Dios. ");
INSERT INTO clu_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Sa anang ginaimo nga dia ni Juan natoman anang ginsolat ni propita Isaias nga nagakoon, “May nagasinggit sa naligwin nga logar, ‘Ipriparar nindo anang aragian ang Ginoo, Tadlunga nindo ang dalan ay madali tana run lang magabot! ");
INSERT INTO clu_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ang kada madaralum nga logar tampukan nindo, Kag ang kada bokid kag bongyod tapanun nindo. Tadlunga nindo ang mga kilo, Kag kayadun nindo ang mga lobak-lobak. ");
INSERT INTO clu_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Kag makikita ang tanan nga mga tao kon ano anang imoon ang Dios sa paglowas kananda.’” ");
INSERT INTO clu_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Dorong tao ang nagarayan kay Juan agud magpabunyag. Makon ni Juan kananda, “Kamo nga liwat ang mga magkal, basi nagayan kamo digi? Sino ang nagkoon kanindo nga makapalagyaw kamo sa anang silot ang Dios nga madali run lang magabot? ");
INSERT INTO clu_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ipakita nindo nga kamo naginulsul run sa indong mga sala paagi sa indong mga inimoan. Indi kamo magsarig nga indi kamo pagsilotan tungud nga kamo anang kaliwat ni Abraham. Ay miski ang mga bato nga dia poidi nga imoon ang Dios nga anang mga bata ni Abraham kon gosto na. ");
INSERT INTO clu_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Tandaan nindo dia: ang wasay ginaanda run sa kaoy nga ara nagapamonga ang mayad nga bonga agud pokanun kag sonogon.” ");
INSERT INTO clu_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Makon ang mga tao kay Juan, “Ta kon toladan, ano amun imoon?” ");
INSERT INTO clu_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Makon ni Juan, “Kon sino kanindo ang darwa anang lambong, itaw na ang sakabilog sa ara lambong. Kag kon sino kanindo ang may pagkaun, tawan na ra ang ara.” ");
INSERT INTO clu_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","May mga manogsokot ra ang bois nga nagayan kay Juan agud magpabunyag. Makon nanda kay Juan, “Sir, ano amun imoon?” ");
INSERT INTO clu_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Makon ni Juan, “Kon kamo nagasokot ang bois, indi kamo magpanokot ang sobra kondi kon pira anang ginapasokot ang gobyirno maman ra lang indong bulun.” ");
INSERT INTO clu_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","May mga soldado ra nga nagpamangkot kon ano ra anang gosto ang Dios para kananda. Makon ni Juan kananda, “Indi kamo magsari pamaug sa mga tao okon magimo-imo mga bintang kontra kananda agud makapangoarta kamo. Maging kontinto kamo sa indong soildo.” ");
INSERT INTO clu_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Pagkabati ang mga tao sa anang mga panodlo ni Juan, ginisip nanda nga basi kon si Juan nga dia maman run anang ginpili ang Dios nga magaari nga andang ginapaabot. ");
INSERT INTO clu_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Piro makon ni Juan kananda, “Ako nagabunyag kanindo sa tobig, piro may maabot nga mas gamanan pa kanakun. Indi ako pa gani bagay bisan maging anang sorogoon. Ang mga tao nga magtoo kanana bubunyagan na sa Ispirito Santo; piro ang indi tana, bubunyagan na sa kalayo. ");
INSERT INTO clu_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ay bubulagun na ang mga matarung kag ang mga malain nga mga tao, pario tana sa tao nga nagapaangin anang inani agud bulagun ang timgas sa opa. Ang timgas ibutang na sa anang bodiga piro ang opa tana sonogon na sa kalayo nga indi mapatay.” ");
INSERT INTO clu_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Mintras ginatodlo ni Juan ang Mayad nga Barita sa mga tao ginasugyut na sanda ra nga tomanun nanda ang mga butang nga anang ginatodlo kananda. ");
INSERT INTO clu_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Bisan pa gani si Herodes nga manogdomara sa Galilea ginsaway na tungud nga ginapanginbabai na anang bayaw nga si Herodias kag sa doro pa gid nga anang malain nga mga inimoan. ");
INSERT INTO clu_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Kag ang ori nagdogang pa gid anang sala ni Herodes, ay ginpapriso na si Juan. ");
INSERT INTO clu_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","May adlaw nga nagapangbunyag si Juan sa mga tao kag si Jesus nagpabunyag ra kanana. Pagkatapos, mintras nagapangamoyo si Jesus, nagabri ang langit ");
INSERT INTO clu_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","kag nagtugpa kanana ang Ispirito Santo sa porma ang salampati. Kag may limug dayon nga nabatian alin sa langit nga nagakoon, makon, “Ikaw maman akun pinalangga nga Bata. Nalilipay ako nga mayad kanimo.” ");
INSERT INTO clu_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Mga 30 anyos anang idad ni Jesus bago tana magompisa imo anang ginapaimo ang Dios kanana. Sono sa anang pagkaulam ang mga tao, si Jesus anang bata ni Jose nga bata ni Eli. ");
INSERT INTO clu_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Si Eli bata ni Matat. Si Matat bata ni Levi. Si Levi bata ni Melqui. Si Melqui bata ni Jana. Si Jana bata ni Jose. ");
INSERT INTO clu_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Si Jose bata ni Matatias. Si Matatias bata ni Amos. Si Amos bata ni Nahum. Si Nahum bata ni Esli. Si Esli bata ni Nage. ");
INSERT INTO clu_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Si Nage bata ni Maat. Si Maat bata ni Matatias. Si Matatias bata ni Semei. Si Semei bata ni Jose. Si Jose bata ni Juda. ");
INSERT INTO clu_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Si Juda bata ni Joana. Si Joana bata ni Resa. Si Resa bata ni Zorobabel. Si Zorobabel bata ni Salatiel. Si Salatiel bata ni Neri. ");
INSERT INTO clu_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Si Neri bata ni Melqui. Si Melqui bata ni Adi. Si Adi bata ni Cosam. Si Cosam bata ni Elmodam. Si Elmodam bata ni Er. ");
INSERT INTO clu_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Si Er bata ni Josue. Si Josue bata ni Eliezer. Si Eliezer bata ni Jorim. Si Jorim bata ni Matat. Si Matat bata ni Levi. ");
INSERT INTO clu_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Si Levi bata ni Simeon. Si Simeon bata ni Juda. Si Juda bata ni Jose. Si Jose bata ni Jonan. Si Jonan bata ni Eliaquim. ");
INSERT INTO clu_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Si Eliaquim bata ni Melea. Si Melea bata ni Mainan. Si Mainan bata ni Matata. Si Matata bata ni Natan. Si Natan bata ni David. ");
INSERT INTO clu_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Si David bata ni Jesse. Si Jesse bata ni Obed. Si Obed bata ni Boaz. Si Boaz bata ni Salmon. Si Salmon bata ni Naason. ");
INSERT INTO clu_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Si Naason bata ni Aminadab. Si Aminadab bata ni Admin. Si Admin bata ni Arni. Si Arni bata ni Esrom. Si Esrom bata ni Fares. Si Fares bata ni Juda. ");
INSERT INTO clu_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Si Juda bata ni Jacob. Si Jacob bata ni Isaac. Si Isaac bata ni Abraham. Si Abraham bata ni Tare. Si Tare bata ni Nacor. ");
INSERT INTO clu_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Si Nacor bata ni Serug. Si Serug bata ni Ragau. Si Ragau bata ni Peleg. Si Peleg bata ni Heber. Si Heber bata ni Sala. ");
INSERT INTO clu_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Si Sala bata ni Cainan. Si Cainan bata ni Arfaxad. Si Arfaxad bata ni Sem. Si Sem bata ni Noe. Si Noe bata ni Lamec. ");
INSERT INTO clu_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Si Lamec bata ni Metusalem. Si Metusalem bata ni Enoc. Si Enoc bata ni Jared. Si Jared bata ni Mahalaleel. Si Mahalaleel bata ni Cainan. ");
INSERT INTO clu_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Si Cainan bata ni Enos. Si Enos bata ni Set. Si Set bata ni Adan. Si Adan bata ang Dios. ");
INSERT INTO clu_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Pagkatapos nga nakapabunyag run si Jesus, nagalin tana doto sa Soba ang Jordan nga ginagauman tana ang Ispirito Santo. Kag gindara tana ang Ispirito Santo sa naligwin nga logar. ");
INSERT INTO clu_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Doto ginsolay tana ni Satanas sa sulud 40 ka adlaw. Kag sa mga inadlaw nga dato ara gid nagkaun si Jesus, gani gingutum tana. ");
INSERT INTO clu_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Makon ni Satanas kanana, “Abi kon ikaw gid anang Bata ang Dios, imoa abi nga tinapay ang bato nga dan.” ");
INSERT INTO clu_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Piro makon ni Jesus kanana, “Ang Kasolatan nagakoon nga ‘Ang tao bukun lang sa pagkaun maboboi.’” ");
INSERT INTO clu_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Pagkatapos dato gindara tana ni Satanas sa mataas nga logar, kag sa sangka pamisuk lang gid ginpakita na kay Jesus ang tanan nga mga ginarian sa bilog nga kalibotan. ");
INSERT INTO clu_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Makon na dayon kay Jesus, “Ikaw akun padomaraun sa tanan nga dan nga mga ginarian pati andang manggad, tungud nga dan tanan gintaw kanakun kag poidi ko ra itaw sa bisan kino nga gosto ko nga tawan. ");
INSERT INTO clu_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Gani dan tanan maging imo kon magsimba kaw kanakun.” ");
INSERT INTO clu_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ginsabat tana ni Jesus, makon na, “Ang Kasolatan nagakoon, ‘Simbaun mo ang Ginoo nga imong Dios kag tana lang gid imong sirbian.’” ");
INSERT INTO clu_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Pagkatapos dato gindara tana pa gid ni Satanas doto sa Jerusalem, doto sa borobongan gid ang timplo. Kag makon na dayon kay Jesus, “Kon ikaw gid anang Bata ang Dios, abi paglokso alin digi paidalum. ");
INSERT INTO clu_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ay kabay may nakasolat sa Kasolatan, ‘Sosogoon ang Dios anang mga angil agud bantayan kaw. ");
INSERT INTO clu_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Samboton kaw nanda agud bisan imong siki indi matigbak sa bato.’” ");
INSERT INTO clu_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Piro ginsabat tana ni Jesus, makon na, “May nakasolat ra sa Kasolatan nga nagakoon, ‘Indi mo pagtirawan ang Ginoo nga imong Dios.’” ");
INSERT INTO clu_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Pagkakita ni Satanas nga indi na gid masolay si Jesus ginbayaan na tana anay. ");
INSERT INTO clu_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Pagkatapos dato nagbalik si Jesus sa Galilea nga may gaum ang Ispirito Santo. Kag ang barita parti kanana naglapnag doto sa bilog nga logar nga dato. ");
INSERT INTO clu_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nagtodlo tana sa anang mga simbaan ang mga Judio kag gindayaw tana ang tanan. ");
INSERT INTO clu_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Nagayan dayon si Jesus sa Nazaret. Maman dia ang logar nga anang ginbaulan. Sono sa anang nakaogalian, pagabot ang Adlaw nga Inogpaway, nagayan tana sa anang simbaan ang mga Judio. Nagtindug tana agud magbasa sa Kasolatan. ");
INSERT INTO clu_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Gintaw nanda kanana anang solat ni propita Isaias. Ginbokasan na kag pagkakita na anang ginapangita ginbasa na dayon ang nakasolat nga nagakoon; ");
INSERT INTO clu_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Anang Ispirito ang Ginoo digi kanakun. Ay ako ginpili na nga magwali ang Mayad nga Barita sa mga pobri. Ginpadara na ako agud ibantala sa mga biag nga libri sanda run, Kag sa mga bolag nga sanda makakita run, Kag sa mga ginapigus nga libri sanda run da. ");
INSERT INTO clu_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ginpadara na ako agud ibantala sa mga tao nga maman run dia ang oras nga sanda lowasun run ang Ginoo.” ");
INSERT INTO clu_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Pagkabasa ni Jesus dato, ginbaroron na anang ginbasa kag ginbalik sa kabolig. Nagpongko tana dayon agud magompisa todlo. Kag nagsulung nga mayad kanana ang tanan nga mga tao. ");
INSERT INTO clu_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Makon na, “Ang Kasolatan nga dia nga indong nabatian natoman run dadi.” ");
INSERT INTO clu_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Kag gindayaw tana ang tanan. Midyo indi sanda makapati nga makasaysay tana ang toladato kasadya. Makon nanda, “Kabay anang bata ra lang dan ni Jose.” ");
INSERT INTO clu_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Makon ni Jesus kananda, “Sigorado gid nga sambitun nindo kanakun ang orobatun nga nagakoon, ‘Ikaw nga manogbolong, bolonga anay imong kaogalingun.’ Indong gostong ambalun nga ang mga butang nga indong nabatian nga akun ginpangimo sa banwa ang Capernaum dapat imoon ko ra digi mismo sa akun logar. ");
INSERT INTO clu_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Piro ang matood tana ara propita nga ginakilala sa anang kaogalingun nga banwa. ");
INSERT INTO clu_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Indong ginaimo dadi pario ra ang natabo ang ona sa tyimpo ni Elias nga propita. Kabay ara pagpaorana ang Dios sa sulud tatlo ka toig kag tunga kag sugung ang gutum nga naagian ang mga tao. Dorong mga balo nga babai sa bilog nga Israel sa tyimpo nga dato ang nagutuman. ");
INSERT INTO clu_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Piro tungud nga ara sanda nagatoo sa Dios, ara gid pagsogoa ang Dios si Elias agud boligan ang bisan sino kananda; kondi ginsogo tana sa sangka balo nga babai nga bukun Judio nga nagaoli sa banwa ang Sarepta nga sakup ang Sidon. ");
INSERT INTO clu_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Toladan ra ang natabo sa tyimpo ni Eliseo nga propita. Doro nga mga aroon doto sa Israel, piro ara gid may ginayad kananda tungud nga ara sanda nagatoo sa Dios. Si Naaman tana nga bukun Judio nga taga-Syria maman anang ginayad.” ");
INSERT INTO clu_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Pagkabati dato ang mga tao nasilag sanda gid nga mayad. ");
INSERT INTO clu_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Nagtirindug sanda kag gingoyod nanda si Jesus pagoa sa banwa paayan sa timpas, (ay andang banwa sa ibabaw ang bokid mismo). Gosto nanda nga iboslog si Jesus doto. ");
INSERT INTO clu_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Piro anang ginimo ni Jesus, lomosot tana sa kadoroan kag binayaan na sanda. ");
INSERT INTO clu_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Alin doto, naglusub si Jesus sa banwa ang Capernaum nga sakup ang Galilea. Pagabot ang Adlaw nga Inogpaway nagtodlo tana sa anang simbaan ang mga Judio. ");
INSERT INTO clu_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Natingala nga mayad ang mga tao sa anang mga panodlo tungud nga may awtoridad tana kon magambal. ");
INSERT INTO clu_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Karon, doto sa simbaan may tao nga ginsuludan ang malain nga ispirito. Nagsinggit tana todo; makon na, ");
INSERT INTO clu_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Aroy! Jesus nga taga-Nazaret, ano imong labut kanamun? Nagayan kaw bala digi agud madora kami? Naulaman ko kon sino kaw. Ikaw anang matarung nga Bata ang Dios.” ");
INSERT INTO clu_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ginsaway ni Jesus ang malain nga ispirito; makon na, “Pagipus dian kag maggoa sa tao nga dan!” Kag doto mismo sa tunga ang kadoroan ginpalagomba ang malain nga ispirito ang tao kag naggoa dayon, piro ara ra maiwan ang tao nga dato. ");
INSERT INTO clu_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Natingala nga mayad ang mga tao doto, kag makon nanda sa isara kag isara, “Ano kabay ang dian sa anang ambal ang tao nga dan? Ay may awtoridad tana kag gaum nga magmandar sa mga malain nga ispirito nga maggoa, kag nagatoman sanda.” ");
INSERT INTO clu_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Kag ang barita parti kay Jesus naglapnag sa tanan nga mga logar sa palibot. ");
INSERT INTO clu_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Naggoa si Jesus sa anang simbaan ang mga Judio kag nagayan tana sa anang balay ni Simon. Nataboan nga anang ogangan ni Simon nga babai mataas anang ragnat, gani ginpangabay nanda si Jesus nga kon maimo ayadun na tana. ");
INSERT INTO clu_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Nagparapit tana kag nagtindug sa kilid anang ginainggan kag ginsaway anang ragnat. Nagayad tana kag nagbangon nga lagi, kag ginimusan na pagkaun sanday Jesus. ");
INSERT INTO clu_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Pagkasirum, doro gid nga mga tao ang nagdara andang mga masakitun doto kay Jesus. Gintongtong ni Jesus anang alima sa kada isara kananda kag nagayad sanda tanan. ");
INSERT INTO clu_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Pati ang mga malain nga ispirito ginpagoa na sa dorong mga tao. Kag mintras nagagoa ang mga malain nga ispirito nagasinggit sanda kay Jesus, makon nanda, “Ikaw anang Bata ang Dios!” Piro ginsaway sanda ni Jesus nga indi sanda run magambal tungud nga naulaman nanda nga tana ang Cristo nga anang ginpili ang Dios nga magari. ");
INSERT INTO clu_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ang kasanagun run naggoa si Jesus sa banwa nga dato kag nagayan sa naligwin nga logar. Ang mga tao nagpangita kanana kag pagkakita nanda nagpakitloy sanda nga indi tana magalin doto sa andang logar. ");
INSERT INTO clu_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Piro makon ni Jesus kananda, “Kinanglan iwali ko ra sa ibang mga banwa ang Mayad nga Barita parti sa anang pagari ang Dios, tungud nga maman dia ang kabangdanan nga ginpadara na ako.” ");
INSERT INTO clu_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Gani nagpadayon si Jesus sa anang pagpangwalian sa anang mga simbaan ang mga Judio doto sa probinsya ang Judea. ");
INSERT INTO clu_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","May adlaw nga si Jesus nagayan doto sa baybay anang lagona ang Genesaret. Dorong tao ang nagdaragusu doto kanana tungud nga gosto nanda nga magpamati sa anang mga ginatodlo nga alin sa Dios. ");
INSERT INTO clu_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Karon, may nakita si Jesus nga darwa ka sakayan doto sa baybay nga ara run tao ay nagrolosong ang mga mangingisda agud ogasan andang mga lambat. ");
INSERT INTO clu_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Kay Simon ang isara sa mga sakayan nga dato. Doto tana nagsakay kag ginpangabay na dayon si Simon nga itolod-tolod maistan ang sakayan. Kag nagpongko si Jesus sa sakayan kag nagtodlo sa mga tao. ");
INSERT INTO clu_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Pagkatapos na todlo, nagkoon tana dayon kay Simon, makon na, “Simon, mapalaod kita kag itaktak nindo dayon indong mga lambat agud makabuul kamo isda.” ");
INSERT INTO clu_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Makon dayon ni Simon kay Jesus, “Ginoo, sanggabi gid tana amun pangisda kagabi piro ara kami gid may nabuul. Piro tungud nga nagkoon kaw nga itaktak, itaktak ko.” ");
INSERT INTO clu_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Kag nagpalaod sanda kag gintaktak nanda dayon andang mga lambat. Dorong isda andang nabuul kag aros magkaragisi andang mga lambat. ");
INSERT INTO clu_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Gani ginpaypayan nanda andang mga kaiban sa isara nga sakayan agud boligan sanda. Pagabot andang mga kaiban nga dato ginpono nanda isda ang darwa ka sakayan, kag midyo malonod sanda run sa kadoroon ang isda. ");
INSERT INTO clu_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Pagkakita dato ni Simon Pedro, naglood tana kay Jesus kag magkoon, makon na, “Ginoo, bayai ako tungud nga ako tao nga makasasala.” ");
INSERT INTO clu_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ay natingala gid nga mayad si Simon pati anang mga kaiban sa karakuun ang isda nga andang nabuul. ");
INSERT INTO clu_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Kaiban ra doto anang mga kasosyo ni Simon nga si Santiago kag si Juan nga mga bata ni Zebedeo. Makon dayon ni Jesus kay Simon, “Indi kaw magkaadluk. Alin dadi bukun run isda imong pangitaun kondi ang mga tao agud malowas sanda.” ");
INSERT INTO clu_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Gani ginpatakas nanda andang mga sakayan kag ginbayaan nanda ang tanan kag nagsonod kay Jesus. ");
INSERT INTO clu_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","May bisis nga ang si Jesus doto sa sangka banwa, may tao ra doto nga grabi anang masakit nga aro. Pagkakita na kay Jesus nagparapit tana kag nagdapa sa logta nga nagapakitloy nga nagakoon, makon na, “Ginoo, nagapati ako nga mapaayad mo ako sa akun masakit nga dia nga marisna kon gosto mo.” ");
INSERT INTO clu_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Gintandug tana dayon ni Jesus nga nagakoon, “Gosto ko. Sigi, malimpyo ka run!” Kag lagi-lagi nadora anang marisna nga masakit. ");
INSERT INTO clu_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Pagkatapos ginbilinan tana dayon ni Jesus, makon na, “Indi kaw gid magpamarita bisan kino, kondi magdiritso kaw sa pari kag magpasulung kanana. Kag magalad kaw dayon ang alad nga ginsogo ni Moises sa pagpamatood sa mga tao nga limpyo ka run.” ");
INSERT INTO clu_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Piro bisan toladato anang bilin sa tao nga dato naglapnag pa ra gid ang barita parti kay Jesus, kag nagapanung ang mga tao nga nagarabot agud magpamati sa anang mga panodlo kag magpabolong sa andang mga masakit. ");
INSERT INTO clu_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Piro anang ginimo tana ni Jesus, nagayan tana sa naligwin nga logar kag nagpangamoyo. ");
INSERT INTO clu_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","May sangka adlaw, mintras nagatodlo si Jesus, may mga Pariseo kag mga manogtodlo ang Kasogoan nga nagaporongko sa anang marapit. Ang mga tao nga dia nagaralin pa sa sari-sari nga mga banwa ang Galilea kag Judea, kag pati sa Jerusalem. Dian kay Jesus anang gaum ang Dios para magayad ang mga masakitun. ");
INSERT INTO clu_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Karon, may mga tao nga nagabot nga nagakarantoang ang tao nga paralitiko. Ginaimoratan nanda nga daraun doto kay Jesus sa sulud ang balay. ");
INSERT INTO clu_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Garing tungud sa kadoroon ang mga tao ara sanda gid maagian pasulud. Gani andang ginimo, nagsaka sanda sa anang borobongan ang balay kag ginlobotan ang atup. Pagkatapos, tinonton nanda doto mismo kay Jesus ang paralitiko nga nagaingga sa anang iringgaan. ");
INSERT INTO clu_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Pagkakita ni Jesus nga mabaul andang pagtoo kanana, makon na sa paralitiko, “Imong mga sala ginpatawad run.” ");
INSERT INTO clu_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Pagkabati dato ang mga Pariseo kag mga manogtodlo ang Kasogoan, makon nanda sa andang isip, “Sino gid kabay ang tao nga dia nga nagaambal ang kontra sa Dios? Ara may makapatawad ang mga sala kondi ang Dios lang.” ");
INSERT INTO clu_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Naulaman ni Jesus andang ginaisip, gani makon na kananda, “Basi nagisip kamo ang toladan? ");
INSERT INTO clu_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Diin bala ang mas maulas, ang magkoon nga ‘Imong mga sala ginpatawad run,’ okon ang magkoon nga ‘Pagtindug kag magpanaw’? ");
INSERT INTO clu_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Dadi pamatodan ko kanindo paagi sa pagayad ang paralitiko nga dia nga Ako nga Naging Tao may gaum digi sa kalibotan sa pagpatawad ang mga sala.” Kag nagkoon tana dayon sa paralitiko, makon na, “Pagtindug, dara imong iringgaan kag magoli.” ");
INSERT INTO clu_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Kag lagi-lagi sa atobangan ang tanan nagbangon ang paralitiko nga dato. Gindara na dayon anang iringgaan kag nagoli nga nagadayaw sa Dios. ");
INSERT INTO clu_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Kag ang tanan nga mga tao doto natingala nga mayad. Gindayaw nanda ang Dios. Piro ginadlukan sanda ra. Makon nanda, “Katiringala nga mga butang atun nakita dadi.” ");
INSERT INTO clu_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Pagkatapos dato nagalin si Jesus doto kag nakita na ang manogsokot ang bois nga si Levi nga nagapongko sa anang opisina. Makon ni Jesus kanana, “Dali, pagsonod kanakun.” ");
INSERT INTO clu_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Kag ginbayaan ra gani ni Levi ang tanan kag nagsonod kay Jesus. ");
INSERT INTO clu_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Kag nagpriparar tana ponsyon para kay Jesus doto sa anang balay. Doro nga mga manogsokot ang bois kag iba pa nga mga tao ang nagtambong nga naging kaiban nanda sa pagkaun. ");
INSERT INTO clu_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","May mga Pariseo doto kag andang mga kaiban nga mga manogtodlo ang Kasogoan nga nakakita kananda nga magkaraiban nga nagakaraun. Nagmoro-moro sanda sa anang mga somolonod ni Jesus, makon nanda, “Basi nagadapun kamo kaun kag inum sa mga tao nga dan nga mga makasasala?” ");
INSERT INTO clu_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Si Jesus ang nagsabat kananda, makon na, “Ang tao nga mayad anang lawas ara nagakinanglan ang manogbolong, kondi ang nagamasakit. ");
INSERT INTO clu_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ara ako nagayan digi agud tawagun ang mga tao nga nagakabig sa andang kaogalingun nga sanda matarung, kondi nagayan ako tana digi para sa mga tao nga nagaako nga sanda makasasala agud magirinulsul sanda.” ");
INSERT INTO clu_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","May mga tao ra doto nga nagkoon kay Jesus, makon nanda, “Anang mga somolonod ni Juan nga manogbunyag kag anang mga somolonod ang mga Pariseo masami nga nagapoasa kag nagapangamoyo, piro ang imo tana sigi lang ang kaun kag inum.” ");
INSERT INTO clu_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Makon ni Jesus nga nagsabat kananda, “Maimo bala nga indi pagpakaunun ang mga bisita sa kasal mintras kaiban nanda pa ang nobyo? Syimpri indi maimo. ");
INSERT INTO clu_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Piro magaabot ang adlaw nga ang nobyo bulun kananda, kag bago sanda magaporoasa.” ");
INSERT INTO clu_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ginsogidan sanda ra ni Jesus ang mga paanggid agud itodlo kananda nga indi maimo nga dapunun anang mga panodlo kag ang dati nga mga panodlo ang mga Judio. Makon na, “Ara tao nga nagagisi anang bagong lambong agud itambul sa lagi nga lambong; tungud nga kon imoon na dia, loas sa nagisi ang bago, ang gintambul nga dato nga alin sa bago nga lambong indi ra magbagay sa lagi nga lambong. ");
INSERT INTO clu_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Maman ra dan ang matatabo kon ibutang ang bago nga bino sa lagi nga suruludan nga panit. Mabobostik ang suruludan kag indi run gid mapolosan kag pati ang bino maoola. ");
INSERT INTO clu_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Gani kinanglan gid nga ang bago nga bino ibutang sa bago ra nga suruludan nga panit.” ");
INSERT INTO clu_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Nagtaw dayon si Jesus sangka paanggid parti sa tao nga indi magbaton anang ginatodlo. Makon na, “Ara tao nga anad run sa lagi nga bino nga magpangita ang bago, ay sono kanana, masabor kono ang lagi nga bino.” ");
INSERT INTO clu_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","May sangka Adlaw nga Inogpaway nga mintras nagaagi sanday Jesus sa katrigoan, anang mga somolonod nagpangutul anang mga way ang trigo, kag ginkurukusu nanda dayon kag kinaun. ");
INSERT INTO clu_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Karon, may mga Pariseo nga nagkoon kay Jesus, makon, “Basi ginaimo nindo ang bawal nga imoon kon Adlaw nga Inogpaway?” ");
INSERT INTO clu_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ginsabat sanda ni Jesus, makon na, “Ara nindo gid bala nabasai sa Kasolatan anang ginimo ni David ang tana kag anang mga kaiban gingutum? ");
INSERT INTO clu_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Nagsulud tana sa anang balay ang Dios kag nagbuul ang tinapay nga ginaalad sa Dios kag ginkaun na dayon. Kag ginpakaun na pa gani sa anang mga kaiban. Ara tana nagkasala bisan kontra gani sa Kasogoan ang magkaun dato ay para lang dato sa mga pari.” ");
INSERT INTO clu_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Kag makon pa ni Jesus kananda, “Ako nga Naging Tao ang may gaum nga magkoon kon ano ang tama nga imoon sa Adlaw nga Inogpaway.” ");
INSERT INTO clu_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","May sangka adlaw roman nga Inogpaway nagsulud si Jesus sa simbaan ang mga Judio agud magtodlo. May lalaki doto nga ukru anang too nga alima. ");
INSERT INTO clu_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Tungud nga ang mga manogtodlo ang Kasogoan kag mga Pariseo nagaangad gid nga magakosar kay Jesus binantayan nanda gid kon ayadun na ang tao nga dato bisan Adlaw nga Inogpaway. ");
INSERT INTO clu_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Piro naulaman ni Jesus kon ano andang ginaisip. Gani nagkoon tana sa tao nga ukru anang alima, makon na, “Abi pagtindug kag magayan digi sa onaan.” Kag nagtindug tana kag nagayan kay Jesus. ");
INSERT INTO clu_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Makon dayon ni Jesus sa mga manogtodlo ang Kasogoan kag mga Pariseo, “Ano anang ginatogot atun Kasogoan sa Adlaw nga Inogpaway, ang magimo ang mayad sa mga tao, okon ang magimo malain? Ang magbolig nga magayad sanda okon ang magpatay?” ");
INSERT INTO clu_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ginsulung na sanda tanan piro ara gid may nagsabat. Makon na dayon sa tao nga ukru anang alima, “Abi onata imong alima.” Kag ginonat na ra gani, kag anang alima nagayad. ");
INSERT INTO clu_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Kag tungud sa anang ginimo nga dia ni Jesus nagpaugut ang mga manogtodlo ang Kasogoan kag ang mga Pariseo, gani ginarambalan nanda kon ano andang imoon kay Jesus. ");
INSERT INTO clu_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Sa mga inadlaw nga dato may bisis nga si Jesus nagtokad sa may bokid agud magpangamoyo, kag sang gabi gid anang pangamoyo doto. ");
INSERT INTO clu_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Pagkaaga gintawag na anang mga somolonod, kag nagpili tana kananda dosi ka tao. Kag gintawag na sanda nga mga apostolis. ");
INSERT INTO clu_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Andang mga aran, si Simon nga ginaranan na nga Pedro, kag anang libayun nga si Andres, si Santiago kag si Juan, si Felipe kag si Bartolome, ");
INSERT INTO clu_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","si Mateo kag si Tomas, si Santiago nga bata ni Alfeo kag si Simon nga dati ribildi sa gobyirno ang Roma, ");
INSERT INTO clu_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","si Judas nga bata ang ibang Santiago kag si Judas Iscariote nga maman ang naggoa nga traidor. ");
INSERT INTO clu_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Pagkatapos nga tana nakapili run anang mga apostolis, naglusub sanda sa patag. Nagtiripon doto anang mga somolonod kag doro pa gid nga mga tao nga alin sa mga banwa nga sakup ang Judea kag sa siodad ang Jerusalem. May mga tao ra doto nga alin pa sa siodad ang Tiro kag Sidon nga marapit sa dagat. ");
INSERT INTO clu_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Nagayan sanda doto agud magpamati sa anang mga ginatodlo ni Jesus kag magpabolong sa andang mga masakit. Pati ang mga tao nga ginapaantos ang mga malain nga ispirito ginpangayad na ra. ");
INSERT INTO clu_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Kag ang tanan nga mga tao doto nagimorat gid nga makatandug kanana tungud nga may gaum nga nagagoa kanana nga nagapaayad kananda nga tanan. ");
INSERT INTO clu_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Nagsulung dayon si Jesus sa anang mga somolonod kag magkoon, “Masoirti kamo nga mga pobri, kamo nga nakaulam nga kinanglan nindo anang bolig ang Dios, tungud nga sakup kamo sa anang ginarian ang Dios. ");
INSERT INTO clu_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Masoirti kamo nga gosto gid magimo anang kabubutun ang Dios, ay boligan na kamo agud maimo nindo indong ginaandum nga dan. Masoirti kamo nga nagapanangis, ay kamo lilipayun.” ");
INSERT INTO clu_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Masoirti kamo kon tungud sa indong pagsonod Kanakun nga Naging Tao ugutan kanindo ang mga tao, kag isikway nanda kamo, kag yagotaun kamo kag pakalainun indong aran. ");
INSERT INTO clu_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Maman ra dan anang ginimo andang mga kaolang-olangan sa mga propita ang ona. Gani kon imoon nanda dan kanindo, magkalipay kamo nga mayad tungud nga mabaul indong maging balus doto sa langit. ");
INSERT INTO clu_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Piro kamo tana nga mga manggaranun, kamo nga sa indong isip ara nagakinanglan anang bolig ang Dios, kailo kamo ra, ay naangkun nindo ron indong kalipayan. ");
INSERT INTO clu_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Kag kamo nga nagaparagosto dadi, kailo kamo ra, ay magaabot ang adlaw nga indi nindo ron maangkun indong ginaandum. Kag kamo nga nagakadlaw dadi, kailo kamo ra, ay magaabot ang adlaw nga magapangasubu kamo kag magapanangis. ");
INSERT INTO clu_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Kailo kamo ra kon kamo ginadayaw ang tanan, ay maman ra dan anang ginimo andang mga kaolang-olangan sa mga tao nga nagpakono-kono nga sanda mga propita ang Dios.” ");
INSERT INTO clu_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Makon pa ni Jesus, “Piro kamo tana nga nagaparamati kanakun, akun ikoon kanindo, igogmaun nindo indong kaaway kag magimo ang mayad bisan pa sa mga naugutan kanindo. ");
INSERT INTO clu_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Pangayoon nindo sa Dios nga kalooyan na ra ang mga nagasompa kanindo, kag ipangamoyo nindo ang mga tao nga nagapasipala kanindo. ");
INSERT INTO clu_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Kon tampaun kaw sa sangka pisngi, agoantaun mo lang bisan tampaun kaw pa sa isarang pisngi. Kon may magbuul imong lambong, itaw, kag kon pati imong pinakakamisita ginabuul pa gid itaw ra. ");
INSERT INTO clu_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Tawi ang bisan sino nga nagapangayo kanimo, kag kon may magbuul imong pagkabutang indi mo ron pagbawiun. ");
INSERT INTO clu_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Imoa nindo sa indong isigkatao ang bisan ano nga gosto nindo nga imoon nanda ra kanindo. ");
INSERT INTO clu_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Kon ang mga tao nga nagaigogma kanindo maman ra lang indong ginaigogma, ta makakabaton kamo ra balus alin sa Dios? Ay bisan ang mga tao nga makasasala nagaigogma ra sa mga nagaigogma kananda. ");
INSERT INTO clu_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Kag kon kamo nagaimo lang mayad sa mga tao nga mayad kanindo, makakabaton kamo ra balus alin sa Dios? Bisan ang mga makasasala nagaimo ra toladan. ");
INSERT INTO clu_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Kag kon nagapauram kamo lang sa mga tao nga naulaman nindo nga magabayad, ta makakabaton kamo ra balus alin sa Dios? Bisan ang mga tao nga makasasala nagapauram ra sa andang kapario nga makasasala basta naulaman nanda nga magabalik andang ginpauram. ");
INSERT INTO clu_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Toladia tana indong imoon: Igogmaa nindo indong kaaway kag imoan nindo sanda ang mayad. Kag kon maguram sanda kanindo, pauramun nindo nga ara run nagapaabot anang bayad. Kon toladia indong imoon, mabaul indong balus nga mababaton kag maging anang mga bata kamo ang Dios nga Makagagaum sa tanan. Ay tana mayad bisan sa mga tao nga malain kag ara kabaraslan. ");
INSERT INTO clu_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Magmaloloyon kamo pario sa indong Dios nga Amay. ");
INSERT INTO clu_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Indi nindo pagpakalainun ang iba agud indi kamo ra pagpakalainun ang Dios. Indi kamo ra magkoon nga dapat silotan tana, agud indi kamo ra silotan ang Dios. Indong imoon tana, patawadun nindo ang mga nagkasala kanindo agud patawadun kamo ra ang Dios. ");
INSERT INTO clu_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Magtaw kamo agud kamo tawan ra ang Dios. Kag kon ang Dios ang magtaw kanindo, ginasukub na gid nga mayad, ginauyug, ginadasuk, nagaarawas pa bago ibobo sa indong suruludan. Ay kon paiwan indong pagtaw sa iba toladato ra anang pagtaw kanindo ang Dios.” ");
INSERT INTO clu_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Pagkatapos dato ginsogidan sanda ni Jesus ang mga paanggid. Makon na, “Ara tao nga bolag nga sarang makaagobay sa anang kapario nga bolag, ay pario sanda lang nga maoolog sa boo. ");
INSERT INTO clu_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ara istodyanti nga labaw pa sa anang maistro, piro kon ang kada istodyanti natodloan gid nga mayad kag makatapos ron anang pagtoon, magapario tana run da sa anang maistro. ");
INSERT INTO clu_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Basi ginapamolalungan mo gid ang maistan nga poling sa anang mata imong kapario, piro ara mo ginasapaka imong poling nga midyo sa tablon kabaul? ");
INSERT INTO clu_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Paiwan imong pagkoon kanana nga ‘Abi, bulun ko imong poling nga maistan’ kon indi mo gani makita imong poling nga midyo sa tablon kabaul? Gani sino ka gid nga nagapakalain sa imong kapario nga ikaw gani sobra pa kanana? Dapat tana bulun mo anay ang mabaul nga poling nga dian sa imong mata, agud masadya imong pagsulung, kag bago mo garing bulun anang poling nga maistan imong kapario.” ");
INSERT INTO clu_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Ang masadya nga kaoy ara nagapamonga ang marimo, kag ang marimo nga kaoy ara nagapamonga ang masadya. ");
INSERT INTO clu_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ang kada kaoy makikilala mo paagi sa anang bonga. Ara may nagapamopo anang bonga ang igos sa sapinit kag ara ra may nagapamopo anang bonga ang obas sa borot. ");
INSERT INTO clu_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ang tao pario ra dan. Ang mayad nga tao nagaambal ang mayad tungud nga dian sa anang tagiposoon ang mayad. Ang tao tana nga malain nagaambal ra ang malain tungud nga malain ang dian sa anang tagiposoon. Kon ano ang sa anang tagiposoon ang tao maman ra dan ang nagagoa sa anang baba.” ");
INSERT INTO clu_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Basi nagasari kamo tawag kanakun nga ‘Ginoo’? Ara kamo ra gani nagatoman akun ginakoon kanindo. ");
INSERT INTO clu_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ipakita ko kanindo anang kaalimbawa ang tao nga nagaparapit kanakun, kag nagapamati kag nagaimo akun ginakoon. ");
INSERT INTO clu_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Pario tana sa tao nga nagkotkot ang madalum kag nagpatindug anang balay sa pondasyon nga bato. Nagbaa kag nagarawas ang soba kag ginagian ang balay nga dato, piro ara gid maiwan tungud nga mapagun ang pagkaimo. ");
INSERT INTO clu_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ang tao tana nga nagapamati sa akun ginakoon piro ara nagatoman, anang kaalimbawa pario sa tao nga nagpatindug anang balay nga ara pagbutangi ang pondasyon. Pagbaa ang soba, ginaagian ang balay nga dato kag natomba nga lagi, kag nawasak.” ");
INSERT INTO clu_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Pagkatapos nga nakatodlo si Jesus sa mga tao, nagayan tana sa Capernaum. ");
INSERT INTO clu_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","May sangka kapitan doto nga may sakup nga bali 100 ka soldado nga Romano. Ang kapitan nga dato may oripun nga palangga na gid nga nagamasakit kag tagomatayun. ");
INSERT INTO clu_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Pagkabati ang kapitan parti kay Jesus, ginsogo na ang pira ka manogdomara ang mga Judio agud pangabayun si Jesus nga magayan doto sa anang balay kag ayadun anang oripun. ");
INSERT INTO clu_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Pagabot nanda kay Jesus nagpakitloy sanda nga mayad kanana. Makon nanda, “Kon maimo boligi ra ang kapitan, ay mayad tana gid nga tao. ");
INSERT INTO clu_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Palangga na kita nga mga Judio kag nagpatindug tana pa gani ang simbaan para kanatun.” ");
INSERT INTO clu_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Kag nagtawas si Jesus kananda. Ang sanda marapit run sa anang balay ang kapitan, ginsogo ang kapitan anang pira ka amigo agud solang-solangun si Jesus kag nagbilin nga konon tana toladia, “Ginoo, bukun ako bagay nga magsulud kaw pa sa akun balay. ");
INSERT INTO clu_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Maman ra dan nga bukun ako mismo ang nagayan kanimo tungud nga ginakilala ko nga bukun ako ra bagay nga magpangatobang kanimo. Magambal kaw lang kag magaayad run akun sorogoon. ");
INSERT INTO clu_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Naulaman ko dia tungud nga ako may opisyal, kag ako may mga sinakupan ra nga mga soldado. Kon magkoon ako sa isara nga magpanaw, nagapanaw tana. Kag kon magkoon ako sa isara nga magparapit, nagaparapit tana. Kag kon ano akun ginasogo sa akun sorogoon, ginaimo na ra. Gani nagapati ako nga kon ano imong iambal matotoman.” ");
INSERT INTO clu_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Pagkabati dato ni Jesus natingala tana nga mayad. Nagatobang tana sa mga tao nga nagatarawas kanana kag nagkoon, makon na, “Sa matood tana, ara ako pa gid kakita tao sa Israel nga may pagtoo nga pario dia.” ");
INSERT INTO clu_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Anang mga ginpadara ang kapitan nagbalik sa anang balay kag pagabot nanda, nakita nanda nga mayad run ang oripun. ");
INSERT INTO clu_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ara lang boay si Jesus doto kag nagayan tana sa banwa ang Nain. Nagtawas kanana anang mga somolonod kag doro pa nga mga tao. ");
INSERT INTO clu_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ang sanda nagainamput run sa banwa ang Nain nataboan nanda nga nagapagoa ang malubung ang patay kag doro gid nga mga tao ang nagakorompanyar. Ang patay nga lalaki nga inoglubung bogtong pa man nga bata ang balo nga babai. ");
INSERT INTO clu_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Pagkakita ni Jesus sa anang nanay ang napatay, nalooy tana. Makon na, “Indi kaw ron magpanangis.” ");
INSERT INTO clu_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Nagparapit dayon si Jesus sa ginabutangan ang patay kag ginawidan na agud magtadung ang mga nagadara. Kag nagtadung sanda. Makon dayon ni Jesus sa patay, “Noy, pagbangon!” ");
INSERT INTO clu_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Nagbangon ang patay, nagpongko kag nagambal dayon. Pagkatapos ginintriga tana ni Jesus sa anang nanay. ");
INSERT INTO clu_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Pagkakita dato ang mga tao ginkulbaan sanda, kag gindayaw nanda ang Dios. Makon nanda, “Gindumdum ang Dios anang mga tao. Ay sulunga, gintawan na kita gamanan nga propita.” ");
INSERT INTO clu_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Kag ang barita parti sa anang ginimo ni Jesus naglapnag sa bilog nga Judea kag sa tanan nga mga logar sa palibot. ");
INSERT INTO clu_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ang tanan nga dia nga natabo ginbarita kay Juan anang mga somolonod. ");
INSERT INTO clu_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Gani gintawag ni Juan ang darwa sa anang mga somolonod kag ginsogo na nga magayan sa Ginoo agud pamangkoton kon tana run andang ginapaabot okon maulat sanda pa ang iba. ");
INSERT INTO clu_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","21","Gani nagayan sanda kay Jesus. Pagabot nanda doto doro anang ginapangayad ni Jesus nga mga masakitun, ang mga sugung andang pamatyag, kag ang mga ginsuludan ang malain nga ispirito. Doro ra nga mga bolag anang ginapangayad kag nakakita run. Karon, nagpamangkot kay Jesus ang darwa nga dato ka somolonod ni Juan, makon nanda, “Kami ginsogo digi ni Juan nga manogbunyag agud magpamangkot kanimo kon ikaw ron manda amun ginapaabot okon maulat kami pa ang iba?” ");
INSERT INTO clu_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Makon ni Jesus kananda, “Pagbalik kamo doto kay Juan kag sogidan nindo tana kon ano akun ginaimo nga indong nakita kag kon ano akun ginaambal nga indong nabatian. Konon nindo tana nga ang mga bolag nakakakita, ang mga piang nakakapanaw, ang mga bungul nakakabati, ang mga aroon nagaayad, ang mga patay ginaboi, kag ang Mayad nga Barita ginawali sa mga pobri. ");
INSERT INTO clu_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Masoirti ang mga tao nga ara nagadoda kanakun.” ");
INSERT INTO clu_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Pagkalombos anang mga ginsogo ni Juan, nagpamangkot si Jesus sa mga tao, makon na, “Pagayan nindo kay Juan sa naligwin nga logar, ano indong ginapaabot nga makita? Nagayan kamo doto agud makita nindo ang tao nga nagapaayon-ayon pario sa kogon kon uyupun ang angin? ");
INSERT INTO clu_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Okon nagayan kamo doto agud makita nindo ang tao nga maraalun anang lambong? Garing ang mga tao tana nga masaradya andang lambong kag pagosto andang pangaboi nakikita sa mga palasyo. ");
INSERT INTO clu_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Abi sogidi nindo ako kon basi nagayan kamo doto. Para makita anang propita ang Dios? Tama, propita tana manda kag sobra pa gani sa propita. ");
INSERT INTO clu_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ay tana maman anang ginakoon ang Dios sa Kasolatan nga nagakoon, ‘Paonaun ko kanimo akun manogbarita agud ipriparar na imong aragian.’” ");
INSERT INTO clu_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Kag makon pa ni Jesus, “Sa matood tana, asta dadi ara may nabata sa kalibotan nga maglabaw pa kay Juan. Piro ang tao dadi nga nagapasakup sa anang pagari ang Dios, bisan tana ang pinakakubus, mas labaw tana kay Juan.” ");
INSERT INTO clu_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Pagkabati nanda sa anang mga panodlo ni Jesus, doro nga tao, pati ang mga manogsokot ang bois, ang nagkompormi sa anang ginapaimo ang Dios, ay nagparabunyag sanda ra kay Juan. ");
INSERT INTO clu_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Piro ang mga Pariseo tana kag ang mga manogtodlo ang Kasogoan ara nagkompormi sa anang ginapaimo ang Dios kananda, ay ara sanda magparabunyag kay Juan. ");
INSERT INTO clu_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Makon pa gid ni Jesus, “Sa ano ko kabay ipaalimbawa ang mga tao sa tyimpo nga dia? ");
INSERT INTO clu_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Midyo sanda sa mga bata nga nagaporongko sa plasa nga nagakoon sa isara kag isara, makon nanda, ‘Gintokaran namun kamo ang sonata nga pangkasal, garing ara kamo magsaot. Ginkantaan namun kamo ang kanta nga para sa patay, garing ara kamo ra magpanangis!’ ");
INSERT INTO clu_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Kamo toladan ra, ay pagabot ni Juan, nakita nindo nga limitado anang ginakaun kag ara tana nagainum ang mga irinumun nga karilingin. Gani nagakoon kamo nga tana may malain nga ispirito. ");
INSERT INTO clu_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Kag Ako nga Naging Tao, pagabot ko, nakita nindo nga sigi akun kaun kag inum, gani nagakoon kamo nga ako nagatinakab kag parapalingin. Kag nagakoon kamo ra nga ako anang amigo ang mga makasasala pario ang mga manogsokot ang bois. ");
INSERT INTO clu_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Piro indi bali, ang mga tao nga nagasonod sa anang kabubutun ang Dios nagapamatood nga osto manda anang ginapaimo ang Dios.” ");
INSERT INTO clu_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Karon, may sangka Pariseo nga nagimbitar kay Jesus nga doto magkaun sa anang balay. Gani nagayan doto si Jesus kag nagkaun. ");
INSERT INTO clu_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Doto sa banwa ra nga dato may sangka babai nga kilala nga makasasala. Pagkabati na nga si Jesus doto sa anang balay ang Pariseo nagayan tana doto. May dara tana nga tibod-tibod nga may sulud nga agoa. ");
INSERT INTO clu_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Nagparapit tana sa anang likod ni Jesus kag doto tana sa anang sikian kampi nagpanangis. Anang mga loa nagtoro sa anang siki ni Jesus. Ginpaidan na anang book kag ginarukan. Pagkatapos ginboboan na paamot anang siki ni Jesus. ");
INSERT INTO clu_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Pagkakita dato ang Pariseo nga nagimbitar kay Jesus, makon na sa anang isip lang, “Kon dia nga tao matood manda nga propita, andan naulaman na kon sino kag kon anong klasi nga babai ang nagatandug kanana, ay ang babai nga dan makasasala.” ");
INSERT INTO clu_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Piro naulaman ni Jesus kon ano anang ginaisip, gani makon na, “Simon, may isogid ako kanimo.” Makon ni Simon, “Ano dato maistro?” ");
INSERT INTO clu_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Kag nagsabat si Jesus paagi sa paanggid, makon na, “May darwa ka tao nga nagpangotang koarta sa manogpaotang. Ang isara nagotang 500, kag ang isara 50. ");
INSERT INTO clu_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ang ori tungud nga indi sanda makabayad ara sanda run lang pagpabayada ang nagpaotang kananda. Ta sino sa darwa nga dato ang mas mabaul anang pagpamalangga sa andang naotangan?” ");
INSERT INTO clu_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Nagsabat si Simon, makon na, “Sigoro ang mas mabaul anang otang.” Makon ni Jesus, “Osto imong sabat.” ");
INSERT INTO clu_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Kag ginbalikid na dayon ang babai kag magkoon kay Simon, “Ta nakita mo ang babai nga dia? Pagsulud ko kaina digi sa imong balay ara mo ako gani pagtawi ang tobig nga inogogas sa akun siki. Piro ang babai nga dia anang loa anang ginogas sa akun siki, kag anang book pa gani anang ginimo nga pamaid. ");
INSERT INTO clu_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ara mo ako pagaruki bilang imong bisita, piro tana tana alin pa akun pagabot digi sigi anang aruk sa akun siki. ");
INSERT INTO clu_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ara mo pagpatoroi lana akun olo bilang pagbaton kanakun, piro ang babai tana nga dia, ang maraalun pa nga paamot anang ginbobo sa akun siki. ");
INSERT INTO clu_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Gani sogidan ta kaw, nga anang mabaul nga gogma nga ginpakita nagapamatood nga anang mga sala nga doro gid ginpatawad run; piro ang tao tana nga maistan lang anang sala nga ginpatawad, maistan ra lang ang pagigogma nga anang ginapakita.” ");
INSERT INTO clu_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Makon dayon ni Jesus sa babai, “Ginpatawad run imong mga sala.” ");
INSERT INTO clu_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ang mga nagkaraun kaiban ni Jesus nagkoon sa andang isip lang, makon, “Sino gid kabay dia, nga bisan ang mga sala ginapatawad na?” ");
INSERT INTO clu_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Makon dayon ni Jesus sa babai, “Nalowas kaw tungud sa imong pagtoo. Sigi, pagoli run, kag indi ka run magsari palibug.” ");
INSERT INTO clu_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Pagkatapos dato, naglibot si Jesus sa mga banwa kag mga bario nga nagabantala ang Mayad nga Barita parti sa anang pagari ang Dios. Kaiban na anang dosi ka mga apostolis, ");
INSERT INTO clu_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","kag ang iba nga mga babai nga anang ginpangayad sa mga malain nga ispirito kag mga balatian. Isara kananda si Maria nga taga-Magdala nga pito gid ka malain nga ispirito ang ginpagoa kanana. ");
INSERT INTO clu_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Nakaiban nanda ra si Juana nga asawa ni Cusa nga maman anang ginasarigan ni Herodes sa anang palasyo. Si Susana isara ra kananda kag may doro pa gid nga mga babai. Sanda ang nagtaw anang mga kinanglanun nanday Jesus alin sa andang pagkabutang. ");
INSERT INTO clu_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","May adlaw nga doro gid nga mga tao ang nagarayan kag nagtiripon doto kay Jesus alin sa iba-ibang mga banwa. Ginsogidan na sanda ang paanggid, makon na, ");
INSERT INTO clu_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“May sangka mangongoma nga nagpanggas anang bini. Sa anang pagpanggas ang iba nagtugpa sa binit gid ang dalan, kag dia nalapakan ang nagaaragi kag gintoka ang mga pispis. ");
INSERT INTO clu_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ang iba tana nagtugpa sa kabatoan, piro pagtobo nalayung dayon ay masyado ka mara ang logta. ");
INSERT INTO clu_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ang iba nagtugpa sa logar nga nagatorobo ang mga ilamonon nga masiit, kag dungan nga nagtobo sa mga ilamonon. Piro ang ori nalumus. ");
INSERT INTO clu_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ang iba nagtugpa sa mayad nga logta, nagtorobo kag doro gid anang naging bonga.” Makon pa ni Jesus kananda, “Dapat intindiun nindo indong nabatian nga dia.” ");
INSERT INTO clu_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ginpamangkot tana anang mga somolonod kon ano anang kaologan ang paanggid nga dato. ");
INSERT INTO clu_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Makon na nga nagsabat, “Ang mga tinago ang ona parti sa anang pagari ang Dios ginasogid kanindo nga akun mga somolonod agud maintindian nindo, piro sa iba tana ginasogid paagi sa mga paanggid agud ‘bisan magsulung sanda indi sanda makakita, kag bisan magpamati indi sanda makaintindi.’” ");
INSERT INTO clu_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ginsaysay dayon ni Jesus anang kaologan ang paanggid. Makon na, “Ang bini nga dato ara iba kondi anang ambal ang Dios. ");
INSERT INTO clu_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Anang binit ang dalan nga gintugpaan ang bini mga tao nga nakabati anang ambal ang Dios, garing nagabot si Satanas kag ginbuul na anang ambal ang Dios sa andang tagiposoon, ay sabun magtoo sanda kag malowas. ");
INSERT INTO clu_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ang kabatoan nga logta nga gintugpaan ang bini mga tao nga nakabati ra anang ambal ang Dios kag ginbaton nanda nga may kalipay, garing bukun tuduk sa andang tagiposoon. Gani ara lang boay andang pagtoo ay pagabot ang mga pagsolay nagtalikod sanda dayon. ");
INSERT INTO clu_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ang iba nga bini nagtugpa sa masiit nga mga ilamonon. Maman dia ang mga tao nga nakabati, garing andang mga paralibugan kag andang mga manggad pati ang mga kalipayan sa kaboi nga dia maman ang nagaadlang kananda sa pagsonod sa anang kabubutun ang Dios para kananda. ");
INSERT INTO clu_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Piro ang iba tana nga bini nagtugpa sa mayad nga logta. Maman dia ang mga tao nga nakabati anang ambal ang Dios, ginatipigan nanda gid sa andang tagiposoon kag nagaimorat sanda nga tomanun andang nabatian. Kag bisan ano nga pagsolay nga nagaabot kananda nagapadayon sanda pa gid sa pagimo anang kabubutun ang Dios para kananda.” ");
INSERT INTO clu_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Makon pa gid ni Jesus, “Ara may nagasindi ang solo kag pagkatapos takluban dayon okon ibutang sa idalum ang katri, kondi ginatongtong gid sa torongtongan agud masanagan ang mga tao nga magasulud sa balay. ");
INSERT INTO clu_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Maman ra dan nga ara gid tinago nga indi maggoa sa ori, kag ara likum parti sa anang pagari ang Dios nga indi maulaman kag maboyagyag. ");
INSERT INTO clu_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Gani pamatii nindo ako nga mayad, ay ang tao nga may naulaman run nga kamatoodan kag anang ginasonod, dogangan pa gid ang Dios anang pagintindi. Piro ang tao tana nga ara nagasonod sa anang naulaman nga kamatoodan, pati anang pagsarig nga dian kanana bubulun pa.” ");
INSERT INTO clu_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Karon, nagabot anang nanay kag anang mga kabogto ni Jesus. Piro tungud sa kadoroon ang tao indi sanda makaparapit kanana. ");
INSERT INTO clu_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Gani may nagsogid kay Jesus, makon, “Imong nanay kag imong mga kabogto nagatirindug doto sa goa. Gosto nanda nga magpakigkita kanimo.” ");
INSERT INTO clu_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Piro makon ni Jesus kananda, “Ang mga nagapamati kag nagatoman anang ambal ang Dios maman akun nanay kag mga kabogto.” ");
INSERT INTO clu_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","May adlaw nga si Jesus kag anang mga somolonod nagsakay sa sakayan. Makon na kananda, “Amos matabok kita sa loyo.” Kag naglayag sanda dayon. ");
INSERT INTO clu_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Mintras nagapalayag sanda natorogan si Jesus. Malagat-lagat golpi lang nga nagbaskug ang angin kag indi nanda run masakat ang limasun, kag napabutang sanda run gid sa piligro nga kaimtangan. ");
INSERT INTO clu_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Gani ginparapitan nanda si Jesus kag ginpokaw. Makon nanda, “Ginoo! Ginoo! Malolonod kita run!” Nagbangon si Jesus kag ginsabdung na ang angin kag ang daloyon nga magtadung. Kag golpi lang nga naglinaw. ");
INSERT INTO clu_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Makon dayon ni Jesus sa anang mga somolonod, “Ay dan, sadin run indong pagtoo?” Natingala nga mayad ang mga somolonod nga may kakulba nga nagakoon sa isara kag isara, “Sino gid kabay dia nga bisan ang angin kag ang mga daloyon ginamandaran na lang kag nagasonod kanana?” ");
INSERT INTO clu_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Nagpadayon sanda layag asta nakaabot sanda sa logar ang mga taga-Gerasa nga nagaatobang sa Galilea. ");
INSERT INTO clu_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Pagsalta ni Jesus, ginsolang-solang tana nga lagi ang lalaki nga ginsuludan ang mga malain nga ispirito. Dia nga lalaki boay run nga ara nagalambong kag ara run da nagaoli sa anang balay sa banwa. Doto tana run nagaoli sa mga kowiba nga ginalubungan. ");
INSERT INTO clu_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Pagkakita na kay Jesus nagsinggit tana kag naglood kanana. Makon na dayon sa mabaskug nga limug, “Jesus nga Bata ang Dios nga labaw sa tanan, ano imong labut kanakun? Nagapakitloy ako kanimo nga indi mo ako pagsilotan.” ");
INSERT INTO clu_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Toladato anang koon tungud nga ginsogo ron ni Jesus ang malain nga ispirito nga maggoa sa lalaki. Ay boay run nga ginagauman tana ang malain nga ispirito nga dato, kag bisan ginagapos tana pa ang mga tao ang mga kadina sa anang alima kag sa anang siki kag ginabantayan nga mayad, ginabogto na lang kag ginapalayas tana ang malain nga ispirito sa naligwin nga logar. ");
INSERT INTO clu_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ginpamangkot tana ni Jesus, makon na, “Sino imong aran?” Makon ang lalaki, “Ako si Panung.” Toladan anang sabat tungud nga doro nga mga malain nga ispirito ang nagsurulud kanana. ");
INSERT INTO clu_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Kag nagpakitloy ang mga malain nga ispirito nga kon maimo indi sanda lang pagmandaran nga maglokso sa pinakamadalum nga logar nga ginasilotan kananda. ");
INSERT INTO clu_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Doto sa marapit doro nga mga baboy ang nagaparanginaun sa banggilid. Nagpakitloy kay Jesus ang mga malain nga ispirito nga togotan sanda nga magsulud sa mga baboy nga dato. Kag gintogotan sanda ni Jesus. ");
INSERT INTO clu_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Gani naggoa ang mga malain nga ispirito sa tao kag nagsulud sanda sa mga baboy. Kag nagdaragoyon dayon ang mga baboy palusub sa matidluk nga banggilid diritso sa tobig kag nagkaralumus. ");
INSERT INTO clu_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Pagkakita ang mga manogsagod ang mga baboy sa natabo, nagdaralagan sanda sa kaadluk, kag ang mga natabo nga dato ginbarita nanda sa mga tao sa banwa kag sa bokid. ");
INSERT INTO clu_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Gani nagarayan doto kay Jesus ang mga tao ay gosto nanda nga makita ang natabo. Pagabot nanda doto nakita nanda ang tao nga dati may mga malain nga ispirito nga nagapongko ron doto marapit kay Jesus, may lambong ron kag sa logar run anang isip. Gani ginkulbaan sanda. ");
INSERT INTO clu_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ang mga nakakita mismo sa natabo nagsogid sa mga tao nga bago lang nagarabot doto kon paiwan nagayad ang lalaki nga dato nga ginsuludan anay ang mga malain nga ispirito. ");
INSERT INTO clu_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Kag ang tanan nga mga tao doto nga nagaoroli sa mga logar nga sakup ang Gergeseno nagpakitloy kay Jesus nga kon maimo magalin tana doto kananda, ay sugung gid andang kaadluk. Gani nagsakay ruman sanday Jesus sa sakayan agud magbalik sa andang ginalinan. ");
INSERT INTO clu_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ang lalaki tana nga ginsobolan ang mga malain nga ispirito nagpakitloy kay Jesus nga kon maimo matawas tana kanana. Garing ginpaoli tana ni Jesus nga nagakoon, makon na, ");
INSERT INTO clu_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Pagoli doto sa indo, kag isogid mo kon ano anang mga ginimo ang Dios kanimo.” Gani nagoli ang lalaki nga dato, kag naglibot tana sa bilog nga banwa nga nagapanogid sa tanan kon ano anang mga ginimo ni Jesus kanana. ");
INSERT INTO clu_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Pagabot ni Jesus sa loyong baybay, nalipay nga mayad ang mga tao sa pagsolang-solang kanana tungud nga tanan sanda nagaulat kanana. ");
INSERT INTO clu_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Malagat-lagat may nagabot nga tao nga anang aran si Jairo. Tana sangka manogdomara sa simbaan ang mga Judio. Pagrapit na kay Jesus naglood tana kag nagpakitloy nga kon maimo magayan tana anay doto sa anang balay ");
INSERT INTO clu_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","tungud nga tagomatayun anang bogtong nga bata. Ang bata nga dia nga babai nagaidad mga dosi lang ka toig. Nagtabid kanana si Jesus. Ang nagapaayan run sanday Jesus doto sa anang balay ni Jairo nagadurukdukan ang dorong tao doto kanana. ");
INSERT INTO clu_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Karon, may babai doto nga dosi run ka toig nga ginatagas-tagasan ang dogo. Naobos ron gastos ang tanan nga anang pagkabutang sa pagpabolong. Piro ara gid may nakaayad kanana. ");
INSERT INTO clu_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Anang ginimo, nagpanalut-salut tana sa mga tao asta nakaparapit sa anang likod kampi ni Jesus, kag gintandug na dayon anang sidsid anang lambong ni Jesus, kag nagpuut nga lagi ang paggoa anang dogo. ");
INSERT INTO clu_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Makon dayon ni Jesus, “Sino ang nagtandug kanakun?” Tanan sanda doto nagkoon nga ara sanda katandug kanana. Gani makon ni Pedro, “Ginoo, ang kadoro nga dan ang nagagurutuk kag nagadurukduk dian kanimo, mapamangkot kaw pa gid kon sino ang nagtandug kanimo.” ");
INSERT INTO clu_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Piro nagkoon si Jesus, makon na, “May nagtandug baya kanakun, tungud nga nabatyagan ko nga may gaum nga naggoa kanakun.” ");
INSERT INTO clu_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Pagkaulam ang babai nga naulaman ni Jesus anang ginimo, nagparapit tana nga nagakurudug kag naglood kay Jesus. Kag doto sa atobangan ang tanan ginsogid na kay Jesus kon basi gintandug na tana kag kon paiwan tana nagayad nga lagi. ");
INSERT INTO clu_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Makon ni Jesus kanana, “Nene, nalowas kaw tungud sa imong pagtoo. Sigi, pagoli run kag indi kaw ron magsari palibug.” ");
INSERT INTO clu_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Mintras nagaambal tana pa sa babai may nagabot alin sa anang balay ni Jairo. Makon na kay Jairo, “Imong bata patay run. Indi run pagbudlaya ang Manogtodlo.” ");
INSERT INTO clu_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Piro pagkabati dato ni Jesus nagkoon tana kay Jairo, makon na, “Indi kaw magkaadluk, magsarig kaw lang kag magaayad tana.” ");
INSERT INTO clu_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Pagabot nanda sa anang balay ni Jairo ara na pagtogoti ang iba nga magtabid kanana sa sulud loas kanday Pedro, Juan, kag Santiago, kag anang tatay kag nanay ang bata. ");
INSERT INTO clu_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Sigi anang paranangis ang mga tao doto. Gani makon ni Jesus kananda, “Indi kamo magparanangis, ay bukun ra patay ang bata. Nagakatorog tana lang.” ");
INSERT INTO clu_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ginkadlawan nanda lang si Jesus tungud nga naulaman nanda nga patay ra gid ang bata. ");
INSERT INTO clu_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Nagparapit si Jesus sa bata kag ginawidan na anang alima kag gintawag nga nagakoon, “Nene, pagbangon!” ");
INSERT INTO clu_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Kag nagbalik anang ispirito kag nagbangon tana nga lagi. Ginkonan sanda dayon ni Jesus nga pakaunun ang bata. ");
INSERT INTO clu_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Natingala gid anang mga ginikanan; piro ginbilinan sanda ni Jesus nga indi gid magpanogid-sogid sa bisan kino parti sa natabo nga dato. ");
INSERT INTO clu_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","May adlaw nga gintipon ni Jesus anang dosi ka apostolis, kag ginpanawan na sanda awtoridad kag gaum nga magpalayas ang tanan nga mga malain nga ispirito kag magpangayad ang mga tao nga may masakit. ");
INSERT INTO clu_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Pagkatapos, ginsogo na sanda dayon nga magpangwalian ang parti sa anang pagari ang Dios kag magpangayad ang mga tao nga may masakit. ");
INSERT INTO clu_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ginbilinan na sanda, makon na, “Indi kamo magbalon bisan ano sa indong pagpanaw; miski baston, bag, pagkaun, koarta, okon lambong nga irilisan. ");
INSERT INTO clu_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Kon padayonon kamo sa sangka balay, doto kamo ron lang gid magdayon asta magalin kamo sa logar nga dato. ");
INSERT INTO clu_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Piro kon ang mga tao sa sangka logar indi magbaton kanindo, bayai nindo ron lang; kag pagalin nindo, tapokan nindo ang yabok sa indong siki bilang tanda kontra kananda.” ");
INSERT INTO clu_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Kag nagparanaw dayon ang mga somolonod kag naglibot sanda sa mga bario nga nagawali ang Mayad nga Barita kag nagapangayad ang mga nagamarasakit. ");
INSERT INTO clu_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Karon, ang barita parti sa anang ginaimo nanday Jesus nakaabot kay Herodes nga manogdomara ang Galilea. Naglibug nga mayad anang olo ni Herodes tungud nga may mga tao nga nagakoon nga si Jesus maman si Juan nga manogbunyag nga nabanaw. ");
INSERT INTO clu_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","May iba ra nga nagakoon nga tana si Elias nga propita ang ona nga nagabot ron. Kag may iba pa gid nga nagakoon nga iba tana nga propita sa naona nga nabanaw. ");
INSERT INTO clu_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Sa anang isip lang ni Herodes makon na, “Kon parti kay Juan, ginpapogotan ko tana run anang olo. Piro sino tana kabay ang tao nga dia? Ay katiringala nga mga butang akun nabatian parti kanana.” Gani nagaimorat si Herodes nga makita na si Jesus. ");
INSERT INTO clu_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Pagkabalik anang mga apostolis ni Jesus, ginsogid nanda kanana kon ano andang mga naimo. Kag pagkatapos dato gindara sanda ni Jesus sa banwa ang Betsaida. Ara tana may ginpatawas nga iba. ");
INSERT INTO clu_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Piro pagkasapo ang mga tao nga sanday Jesus nakaalin run, nagsonod sanda. Pagabot nanda kanday Jesus, ginbaton sanda ni Jesus kag ginsaysayan na parti sa anang pagari ang Dios. Kag ginpangayad na ang mga nagamarasakit. ");
INSERT INTO clu_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Datong masasalup run ang adlaw, nagparapit kanana anang dosi ka Apostolis. Makon nanda, “Paayana run ang mga tao sa mga bario kag sa mga sitio nga sa palibot agud makapangita sanda andang pagkaun kag karatorogan, ay digi kita paman sa naligwin nga logar.” ");
INSERT INTO clu_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Piro makon ni Jesus, “Kamo mismo ang magtaw pagkaun kananda.” Makon nanda, “Lima lang gid ka bilog atun tinapay digi kag darwa ka bilog nga isda. Indi dia makaigo, loas kon magbakal kita pa pagkaun para kananda tanan.” ");
INSERT INTO clu_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Ang mga lalaki lang doto bali 5,000 nga lagi, poira pa sa mga babai kag mga bata.) Gani makon ni Jesus sa anang mga somolonod, “Abi gropo-gropoa nindo ang mga tao tag-50 kag papongkoon.” ");
INSERT INTO clu_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ginsonod nanda anang sogo ni Jesus kag ginpapongko nanda ang tanan nga mga tao. ");
INSERT INTO clu_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ginbuul dayon ni Jesus ang lima ka bilog nga tinapay kag darwa ka bilog nga isda, kag nagtangra tana sa langit kag ginpasalamatan na dato sa Dios. Pagkatapos, ginpamisang-pisang na dayon kag gintaw sa anang mga somolonod agud ipanagtag sa mga tao. ");
INSERT INTO clu_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Kag nakakaun sanda tanan kag nagkarabosog. Pagkatapos nga ang tanan nakakaun run gintipon nanda ang tinapay kag ang isda nga nabilin, kag bali dosi ka baskit andang napono. ");
INSERT INTO clu_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","May adlaw nga nagpabulag si Jesus sa mga tao agud magpangamoyo. Anang mga somolonod kaiban na ra. Karon nagpamangkot si Jesus kananda, makon na, “Sono sa mga tao, sino ako kono?” ");
INSERT INTO clu_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Makon nanda, “May nagakoon nga ikaw si Juan nga manogbunyag. Ang iba nagakoon nga ikaw si Elias, kag may iba pa gid nga nagakoon nga ikaw isara sa mga propita sa naona nga nabanaw.” ");
INSERT INTO clu_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Makon ni Jesus kananda, “Piro para kanindo sino ako?” Nagsabat si Pedro, makon na, “Ikaw ang Cristo nga anang ginpangako ang Dios nga magari.” ");
INSERT INTO clu_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ginkonan sanda dayon ni Jesus nga indi sanda gid magsogid bisan kino nga tana ang Cristo nga ginpangako ang Dios nga magari. ");
INSERT INTO clu_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ay makon na, “Ako nga Naging Tao kinanglan nga magantos nga mayad sa anang imoon kanakun anang mga manogdomara ang mga Judio, ang mga manogdomara nga pari, kag ang mga manogtodlo ang Kasogoan. Isikway nanda ako kag ipapatay, piro sa ikatlo ka adlaw mababanaw ako.” ");
INSERT INTO clu_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Pagkatapos nagkoon si Jesus sa tanan nga mga tao doto, makon na, “Kon may tao nga gosto magsonod kanakun, indi na run dapat pagisipun anang kaogalingun, kondi kada adlaw kinanglan magtoman tana kanakun abir kon kamatayun anang aboton sa pagsonod kanakun. ");
INSERT INTO clu_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ay ang bisan sino nga nagakanogon anang kaboi digi sa kalibotan nga dia mapapatay pa ra gid. Piro ang bisan sino nga priparado nga mapatay tungud kanakun makakaangkun ang kaboi nga ara kataposan. ");
INSERT INTO clu_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ano gid anang mabubuul ang tao kon maangkun na ang tanan nga butang digi sa kalibotan, piro madora anang kaboi? Ara gid! ");
INSERT INTO clu_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ay ang bisan sino nga magkauya kanakun kag sa akun mga panodlo, ikauya ko tana ra kon Ako nga Naging Tao magbalik run nga may gaum nga nagalanyag alin kanakun kag sa Amay kag sa mga angil. ");
INSERT INTO clu_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Sa matood tana, may mga tao digi dadi nga indi mapatay mintras indi nanda makita anang pagari ang Dios.” ");
INSERT INTO clu_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Mga walo ka adlaw pagkatapos nga maambal na dia, gindara na si Pedro, si Juan, kag si Santiago patokad sa bokid agud magpangamoyo. ");
INSERT INTO clu_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Mintras nagapangamoyo tana nagiba anang itsora, kag anang lambong nagpoti gid nga mayad kag masolaw. ");
INSERT INTO clu_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Kag golpi lang may nagpakita nga darwa ka tao nga nagapakigambal kanana. Dia sanday Moises kag Elias. ");
INSERT INTO clu_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Nagalanyag sanda ra, kag nagapakigambal kay Jesus parti sa anang pagalin digi sa kalibotan nga madali run lang matabo sa Jerusalem. ");
INSERT INTO clu_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Mintras nagakaratabo dia nga mga butang, sanday Pedro tana namuukan nga mayad. Piro pagbogtaw nanda, nakita nanda si Jesus nga nagalanyag kag ang darwa ka tao nga nagatindug sa anang tupad. ");
INSERT INTO clu_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Datong maalin run ang darwa nga dato kay Jesus, nagkoon si Pedro kanana, makon na, “Ginoo, mayad digi kami. Maimo kami tatlo ka kamalig, ang sakabilog kanimo, ang sakabilog kay Moises, kag sakabilog ra kay Elias.” (Ang matood tana si Pedro ara gid kaisip sa anang ginaambal nga dato.) ");
INSERT INTO clu_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ara pa natapos anang ambal ni Pedro kag nagabot ang panganod kag ginlikupan sanda. Ginadlukan sanday Pedro pagtabon kananda ang panganod nga dato. ");
INSERT INTO clu_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Pagkatapos may limug sanda nga nabatian nga nagaalin doto sa panganod nga nagakoon, makon, “Maman dia akun Bata, akun Pinili. Pamatian nindo tana!” ");
INSERT INTO clu_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Pagkaambal dato, nakita nanda nga si Jesus run lang ang nabilin. Sa mga naglubas nga mga inadlaw ara anay pagsogidan nanday Pedro kon ano andang nakita. ");
INSERT INTO clu_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ang madason nga adlaw, paglusub nanda alin sa bokid, dorong mga tao ang nagsolang-solang kay Jesus. ");
INSERT INTO clu_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Doto sa kadoroan may sangka tao nga nagsinggit nga nagakoon, makon na, “Maistro, abi kon maimo lang sulunga ra anay akun bata nga lalaki nga bogtong. ");
INSERT INTO clu_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Masami tana nga ginasuludan ang malain nga ispirito. Kon magabot gani, golpi tana lang nga nagasiagit, nagakulkug, kag nagabora dayon. Aros indi magalin kanana ang malain nga ispirito, kag kon magalin run, tigbak nga mayad akun bata. ");
INSERT INTO clu_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nagpakitloy ako ron sa imong mga somolonod nga sobolon nanda, garing indi nanda masarangan.” ");
INSERT INTO clu_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Makon dayon ni Jesus, “Kamo nga mga tao sa tyimpo nga dia, ara kamo pagtoo kag baliskad indong ginaisip kag ginaimo. Asta sano pa akun pagantos kanindo? Abi, dara digi imong bata.” ");
INSERT INTO clu_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Mintras nagaparapit kay Jesus ang bata, ginpatomba tana ang malain nga ispirito sa logta kag ginpakulkug. Piro ginpalayas ni Jesus ang malain nga ispirito kag ginayad na ang bata, kag ginbalik na dayon sa anang tatay. ");
INSERT INTO clu_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ang tanan nga mga tao doto natingala nga mayad sa andang nakita nga nagapakilala anang mabaul nga gaum ang Dios. Mintras natitingala pa ang mga tao sa tanan nga anang ginimo ni Jesus, nagkoon tana sa anang mga somolonod, makon na, ");
INSERT INTO clu_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Tandaan nindo gid dia: Ako nga Naging Tao kinanglan nga iintriga sa mga tao nga nagakontra kanakun.” ");
INSERT INTO clu_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Garing ara sanda dato kaintindi ay midyo ginalipudan andang isip agud indi nanda maangupan. Kag naalangan sanda nga magpamangkot kanana parti sa butang nga dato. ");
INSERT INTO clu_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","May sangka bisis nga nagbarais-baisan anang mga somolonod kon sino gid kananda ang labaw sa tanan. ");
INSERT INTO clu_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Piro naulaman ni Jesus kon ano andang ginaisip. Gani nagbuul tana ang bata kag ginpatindug na dayon sa anang kilid. ");
INSERT INTO clu_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Pagkatapos nagkoon tana dayon, makon na, “Ang bisan sino nga tungud sa anang pagtoo kanakun nagabaton kag nagaasikaso sa bata nga toladia nagabaton ra kanakun. Kag ang nagabaton kanakun nagabaton ra sa nagpadara kanakun. Ay ang pinakakubus kanindo maman ang labaw sa tanan.” ");
INSERT INTO clu_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Nagkoon si Juan kay Jesus, makon na, “Ginoo, nakakita kami ang tao nga nagasobol ang mga malain nga ispirito kag imong aran anang ginagamit. Ginbawalan namun tana nga dapat indi tana magimo toladato ay bukun tana atun kaiban.” ");
INSERT INTO clu_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Piro makon ni Jesus kanana, “Indi nindo pagbawali, ay ang bisan sino nga ara nagakontra kanindo nagadampig kanindo.” ");
INSERT INTO clu_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Datong madali run lang magabot ang adlaw nga si Jesus daraun run pa langit, nagdisisyon tana nga maayan run sa Jerusalem. ");
INSERT INTO clu_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Gani may ginpaona tana nga mga tao sa sangka bario sa Samaria agud magpriparar anang madayonan. ");
INSERT INTO clu_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Piro ang mga tao doto sa bario nga dato indi magbaton kanana ay naulaman nanda nga mapa-Jerusalem tana. ");
INSERT INTO clu_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Pagkaulam anang mga somolonod nga si Santiago kag si Juan nagkoon sanda kay Jesus, makon nanda, “Ginoo, ano kanimo, mapangayo kita ang kalayo alin sa langit agud mapagba sanda?” ");
INSERT INTO clu_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Piro ginbalikid sanda ni Jesus kag ginsaway. ");
INSERT INTO clu_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Gani nagdiritso sanda run lang sa ibang bario. ");
INSERT INTO clu_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Mintras nagapadayon sanda sa andang pagpanaw, may sangka tao nga nagkoon kay Jesus, makon na, “Masonod ako kanimo bisan diin kaw magayan.” ");
INSERT INTO clu_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Piro makon ni Jesus kanana, “Ang mga singgarong may boo nga ginaolian, kag ang mga pispis may pogad, piro Ako nga Naging Tao, ara ako balay nga akun gid nga sarang mapaowayan. Ta, matabid kaw pa kanakun?” ");
INSERT INTO clu_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Nagkoon dayon si Jesus sa isara, makon na, “Pagsonod kanakun!” Makon anang sabat ang tao, “Ginoo, abi maoli ako anay, kag kon patay run akun tatay kag maipalubung ko bago ako masonod kanimo.” ");
INSERT INTO clu_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Makon ni Jesus kanana, “Ang mga tao nga patay sa panulung ang Dios maman imong palubungun ang mga patay. Piro ikaw tana magpanaw kag magwali ang parti sa anang pagari ang Dios.” ");
INSERT INTO clu_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","May isara pa gid nga nagkoon kay Jesus, makon na, “Ginoo, masonod ako kanimo; piro togoti ako anay nga magoli kag maglisinsya sa akun pamilya.” ");
INSERT INTO clu_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Makon ni Jesus kanana, “Ang tao nga nagaarado nga sigi anang balikid indi mapolosan anang pagarado. Dan toladan ra ang tao nga nagasonod kanakun nga may ginapamalikidan, bukun tana bagay sa anang Ginarian ang Dios.” ");
INSERT INTO clu_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Pagkatapos dato, ang Ginoo nagpili 72 pa gid ka tao nga anang paonaun nga tagdarwa-darwa sa mga banwa nga anang ayanan. ");
INSERT INTO clu_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Makon na kananda, “Doro ang mga tao nga magatoo andan kanakun. Andang kaalimbawa pario sa araniun nga malapad garing kolang gid ang manogani. Gani magpangamoyo kamo sa Ginoo nga magpadara tana mga manogani sa anang araniun. ");
INSERT INTO clu_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Sigi, panaw kamo ron. Piro magandam kamo, ay indong kaalimbawa pario sa mga bata pa nga mga karniro nga akun ginapadara sa mga mapirintas nga sapat. ");
INSERT INTO clu_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Indi kamo magdara ang koarta, bag, okon sandalyas. Kag indi kamo ra magtadung sa dalan kag magpakigampang sa indong mga mabagat. ");
INSERT INTO clu_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Kon magsulud kamo ron sa balay, magkoon kamo, ‘Kabay pa nga bindisyonan ang Dios ang pamilya nga dia.’ ");
INSERT INTO clu_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Kag kon bagay sanda nga magbaton indong pagbindisyon, bindisyonan sanda manda ang Dios. Piro kon indi, indi sanda ra pagbindisyonan ang Dios. ");
INSERT INTO clu_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Magdayon kamo sa primiro nga balay nga nagabaton kanindo, kag indi kamo magsaylo-saylo indong darayonan. Batona nindo andang ginapakaun kanindo, ay ang nagapangabudlay dapat gid man nga soolan. ");
INSERT INTO clu_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Kag kon diin kamo nga logar magayan kag sanda nagabaton kanindo, kauna nindo ang bisan ano nga andang ginapakaun kanindo. ");
INSERT INTO clu_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ayada nindo doto ang mga nagamarasakit kag sogidan nindo nga oras run dia nga ang Dios magaari kananda. ");
INSERT INTO clu_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Piro kon magabot kamo sa sangka banwa kag indi nanda kamo pagbatonon, magayan kamo sa andang sa mga karsada kag magkoon, ");
INSERT INTO clu_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Tungud nga kamo indi magbaton kanamun, bisan ang yabok sa indong banwa nga nagadukut sa amun siki amun tapokon bilang paandam kanindo. Tandaan nindo dia: nagabot ron ang oras nga ang Dios magaari run.’” ");
INSERT INTO clu_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Makon pa gid ni Jesus sa anang mga inogpadara, makon na, “Sogidan ko kamo, pagabot ang adlaw ang pagukum, anang silot ang Dios sa mga tao sa banwa nga indi magbaton kanindo mas sobra pa kaysa anang silot sa mga taga-Sodoma.” ");
INSERT INTO clu_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Pagkatapos dato nagambal si Jesus kontra sa mga banwa nga ara naginulsul. Makon na, “Kailo kamo nga mga taga-Corazin! Kag kailo kamo ra nga taga-Betsaida! Ay kon ang mga milagro nga akun ginimo dian kanindo ginimo ko sa Tiro kag sa Sidon, boay sanda run andan maglambong ang lambong nga sako kag magbutang abo sa andang olo bilang pagpakilala nga sanda nagainulsul run sa andang mga sala. ");
INSERT INTO clu_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Gani sa adlaw nga ang Dios magukum, ang silot nga para kanindo magasobra pa sa silot nga para sa mga taga-Tiro kag taga-Sidon. ");
INSERT INTO clu_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Kag kamo nga taga-Capernaum, indong pagsarig dayawon kamo ang tanan. Piro sa impyirno kamo gid tana itatagbung!” ");
INSERT INTO clu_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Makon dayon ni Jesus sa anang mga inogpadara, “Ang nagapamati kanindo nagapamati ra kanakun, kag ang nagasikway kanindo nagasikway ra kanakun, kag ang nagsikway kanakun nagasikway ra sa nagpadara kanakun.” ");
INSERT INTO clu_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Pagbalik ang 72 nga ginpapanaw ang Ginoo malipayun sanda, kag makon nanda kay Jesus, “Ginoo, bisan ang mga malain nga ispirito soko kanamun paagi sa amun paggamit imong aran!” ");
INSERT INTO clu_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Makon ni Jesus kananda, “Nakita ko anang pagkaolog ni Satanas alin sa langit nga midyo kilat anang kadasig. ");
INSERT INTO clu_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Gintawan ko kamo gaum agud madaug nindo ang tanan nga gaum atun kaaway nga si Satanas. Miski lapakun nindo ang mga magkal kag mga iwi-iwi indi kamo maiwan. Ara gid bisan ano nga makaalit kanindo. ");
INSERT INTO clu_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Piro indi kamo magkalipay tungud nga ang mga malain nga ispirito soko kanindo, kondi magkalipay kamo tungud nga indong aran nakasolat run doto sa langit.” ");
INSERT INTO clu_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Sa oras nga dato ginlipay nga mayad si Jesus ang Ispirito Santo. Kag makon na, “Itay, tagya kaw ang langit kag logta. Nagapasalamat ako kanimo tungud nga ang kamatoodan nga gintago mo sa mga maaram kag may mga tinonan ginpasanag mo sa mga tao nga simpli ang kabubutun pario sa mga bata. Itay, salamat gid nga toladato imong gosto.” ");
INSERT INTO clu_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Pagkatapos, makon ni Jesus sa mga tao doto, “Ang tanan nga butang gintogyan kanakun akun Amay. Ang Amay lang ang nakakikilala gid kanakun nga anang Bata. Kag ang nakakikilala gid sa Amay ako ra lang nga anang Bata kag ang mga tao nga akun gosto nga pakilalaun sa Amay.” ");
INSERT INTO clu_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Nagatobang dayon si Jesus sa anang mga somolonod kag magkoon kananda nga sanda-sanda lang, makon na, “Masoirti kamo tungud nga nakita nindo gid ang mga butang nga akun ginapangimo. ");
INSERT INTO clu_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Sa matood tana, doro nga mga propita kag mga ari ang ona ang nagandum nga makakita kag makabati indong nakita kag nabatian dadi, piro ara natabo sa andang tyimpo.” ");
INSERT INTO clu_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","May sangka manogtodlo doto ang Kasogoan nga nagtindug kag nagpamangkot agud tirawan si Jesus. Makon na, “Maistro, ano kabay akun dapat imoon agud makaangkun ako ang kaboi nga ara kataposan?” ");
INSERT INTO clu_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Makon ni Jesus kanana, “Ta ano anang ginakoon ang Kasogoan sono sa imong nabasaan?” ");
INSERT INTO clu_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Nagsabat ang tao, makon na, “Igogmaun mo ang Ginoo nga imong Dios nga tuduk gid sa imong tagiposoon, sa bilog mo nga kalag, sa tanan nga imong ginaimo, kag imong isip pirmi gid kanana. Kag igogmaun mo imong kapario pario imong pagigogma sa imong kaogalingun.” ");
INSERT INTO clu_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Makon ni Jesus kanana, “Osto gid imong sabat. Imoon mo dan agud may kaboi kaw nga ara kataposan.” ");
INSERT INTO clu_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Piro indi gosto ang manogtodlo nga dato ang Kasogoan nga mauyan tana, gani nagpamangkot tana pa gid, makon na, “Ta sino gid abi akun kapario?” ");
INSERT INTO clu_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ginsabat tana ni Jesus paagi sa sangka istoria, makon na, “May sangka tao nga naglusub sa Jerico alin sa Jerusalem. Mintras nagapanaw tana golpi tana lang nga ginlambayan ang mga tolisan. Ginbuul nanda anang pagkabutang pati anang lambong kag ginpikaan lampus, kag ginbayaan nanda tana nga midyo sa patay run. ");
INSERT INTO clu_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Karon, nataboan nga may pari nga doto ra naglusub sa dalan nga dato. Pagkakita na sa tao nga dato nga nagaonat doto sa dalan nagpalikay tana sa binit ang dalan kag ginlubasan na lang. ");
INSERT INTO clu_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Nagagi ra doto ang sangka kabolig ang mga pari sa Timplo. Kag pagkakita na sa tao nga dato doto sa dalan, nagpalikay tana ra kag ginlubasan na ra lang. ");
INSERT INTO clu_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ang ori may nakaagi doto nga bukun Judio nga taga-Samaria. Pagkakita na sa tao nga ginbalbal nalooy tana nga mayad. ");
INSERT INTO clu_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Gani ginparapitan na kag ginbolong. Ginbutangan na ang langis kag bino anang mga igad kag ginbugkusan. Pagkatapos ginpasakay na dayon sa anang ginasakayan nga sapat kag gindara na sa sangka darayonan. Doto ginasikaso na tana pa gid. ");
INSERT INTO clu_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ang madason nga adlaw, gintawan na koarta anang tagya ang darayonan kag nagkoon, makon na, ‘Asikasoon mo tana kag kon kolang pa dan bayadan ko lang pagbalik ko digi.’” ");
INSERT INTO clu_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Makon dayon ni Jesus sa manogtodlo ang Kasogoan, “Ta kon sa kanimo, sino kananda nga tatlo ang nagpakita nga tana manda anang kapario ang tao nga ginlambayan ang mga tolisan?” ");
INSERT INTO clu_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Makon ang manogtodlo ang Kasogoan, “Ang tao nga nagkalooy kanana.” Makon dayon ni Jesus kanana, “Ta imoa ra ang pario anang ginimo.” ");
INSERT INTO clu_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Nagpadayon panaw sanday Jesus kag nakaabot sanda sa sangka bario. May sangka babai doto nga anang aran si Marta. Ginpadayon na sanda sa anang balay. ");
INSERT INTO clu_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","May kabogto tana nga si Maria nga nagpongko doto gid sa anang sikian ni Ginoong Jesus ay gosto na nga magpamati sa anang mga ginatodlo. ");
INSERT INTO clu_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Piro si Marta tana nagapalibug nga mayad sa anang pagimus anang pagkaun nanday Jesus. Gani nagparapit tana kay Jesus kag nagkoon, makon na, “Ginoo, ay dan bali ara lang kanimo nga ako ginapabayanan lang akun kabogto sa pagimus ang pagkaun. Abi kona ra nga boligan na ako!” ");
INSERT INTO clu_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Makon ang Ginoo kay Marta, “Marta, doro nga mga butang imong ginapalibugan kag nagarikot imong isip sa mga butang nga bukun ra gid importanti. ");
INSERT INTO clu_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ang matood tana, sangka butang lang gid ang pinakaimportanti kag maman dia anang ginpili ni Maria, kag dia ara may makabuul kanana.” ");
INSERT INTO clu_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","May sangka adlaw nga pagkatapos pangamoyo ni Jesus, isara sa anang mga somolonod ang nagparapit kanana kag magkoon, makon na, “Ginoo, si Juan nga manogbunyag nagtodlo sa anang mga somolonod kon paiwan magpangamoyo. Todloi kami ra kon paiwan magpangamoyo.” ");
INSERT INTO clu_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Gani makon ni Jesus kananda, “Kon kamo magpangamoyo, magkoon kamo: ‘Amay, kabay pa nga taodon kaw ang mga tao. Kabay pa nga magari ka run digi kanamun. ");
INSERT INTO clu_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Tawi kami amun kinanglan nga pagkaun sa adlaw-adlaw. ");
INSERT INTO clu_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Patawada kami amun mga sala, ay kami nagapatawad ra sa tanan nga nagkasala kanamun. Kag indi mo kami pagipadaug sa mga pagsolay.’” ");
INSERT INTO clu_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Makon pa ni Jesus kananda, “Alimbawa abi, ikaw may amigo, kag pagtungang gabi nagayan kaw doto sa anang balay kag magkoon kanana, ‘Amigo, abi paurama ako ra anay imong pagkaun dian, ");
INSERT INTO clu_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ay may amigo ako bala nga bago lang nagabot kag ara ako gid ipakaun kanana.’ ");
INSERT INTO clu_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Abi-abi lang nagsabat tana doto sa sulud nga nagakoon, ‘Atig ayaw ako ron pagistorboa. Nasiradoan run paman ang poirtaan kag nagairingga kami run akun mga bata, gani mabudlay run ang magbangon para tawan kaw.’ ");
INSERT INTO clu_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ta ano karon? Sa matood tana bisan indi tana magbangon kag magtaw kanimo tungud sa indong pagamigoan, magabangon tana pa ra gid tungud nga ara kaw nauya magpirit kanana, kag tawan kaw imong ginakinanglan. ");
INSERT INTO clu_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ta maman dan nga nagakoon ako kanindo nga magpangayo kamo sa Dios kag tawan na kamo. Magpadayon kamo gid sa pagparapit kanana parti sa indong mga kinanglan kag tigayonon na kamo. Magpangamoyo kamo sa Dios kag sabatun na kamo. ");
INSERT INTO clu_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Tungud nga ang tanan nga nagapangayo sa Dios nakakabaton. Ang mga nagaparapit ginatigayon. Kag ang mga nagapangamoyo sabatun. ");
INSERT INTO clu_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Kamo nga mga ginikanan, kon indong bata magpangayo ang isda ano indong ginataw, magkal? ");
INSERT INTO clu_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Kon magpangayo itlog, tawan nindo ang iwi-iwi? ");
INSERT INTO clu_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ta kon kamo gani nga mga tao nga malain antigo magtaw ang mayad nga mga butang sa indong mga bata, ang Tatay pa nga sa langit! Itaw na ra gid ang Ispirito Santo sa mga tao nga nagapangayo kanana.” ");
INSERT INTO clu_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","May sangka bisis si Jesus nagsobol ang malain nga ispirito nga nagsulud sa sangka tao nga anang ginpaapa. Kag pagkasobol na sa malain nga ispirito nakaambal ang apa nga dato. Natingala nga mayad ang mga tao. ");
INSERT INTO clu_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Piro may pira ka tao doto nga nagkoon, makon nanda, “Nagasobol dan ang mga malain nga ispirito tungud nga gintawan tana gaum ni Satanas nga anang manogdomara ang mga malain nga ispirito.” ");
INSERT INTO clu_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ang iba tana doto gosto nanda nga tirawan si Jesus, gani ginkonan nanda si Jesus nga magimo ang milagro, ay gosto nanda makita ang pamatood nga ginpadara tana manda ang Dios. ");
INSERT INTO clu_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Piro naulaman tana ni Jesus kon ano andang ginaisip, gani makon na kananda, “Kon anang mga pomoloyo ang sangka ginarian magburulag-bulag kag magaraway, dan nga ginarian madodora. Kag toladan ra ang matatabo sa pamilya nga nagaburulag-bulag kag nagaaraway. ");
INSERT INTO clu_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Gani kon si Satanas kag anang mga sakup magburulag-bulag kag magaraway paiwan magpadayon anang ginarian? Ay kamo nagakoon nga ako nagapalayas ang mga malain nga ispirito tungud nga gintawan ako gaum ni Satanas nga manogdomara ang mga malain nga ispirito. ");
INSERT INTO clu_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Piro kon anang gaum ni Satanas akun ginagamit para magpalayas ang mga malain nga ispirito, ta sino ang nagataw gaum sa indong mga somolonod nga nagapalayas ra ang mga malain nga ispirito? Indong mga somolonod mismo nagapamatood nga sala kamo. ");
INSERT INTO clu_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Karon, tungud nga paagi sa anang gaum ang Dios nagasobol ako ang mga malain nga ispirito, dia nagapamatood nga anang ginarian ang Dios nagabot ron digi kanindo.” ");
INSERT INTO clu_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Kag ginsogidan sanda pa gid ni Jesus sangka paanggid, makon na, “Kon nagagoardya ang mapurus nga tao anang balay, basta komplito anang armas indi gid maiwan anang mga pagkabutang. ");
INSERT INTO clu_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Piro kon solongon tana ang mas mapurus kanana, mapipirdi tana kag anang ginasarigan nga mga armas bulun kanana, kag pati anang pagkabutang ururayun dayon.” ");
INSERT INTO clu_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Pagkatapos makon ni Jesus, “Ang ara nagakampi kanakun kontra kanakun. Kag ang ara nagabolig kanakun sa pagtipon ang mga tao sa Dios nagaparapta lang.” ");
INSERT INTO clu_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Kon ang malain nga ispirito maggoa sa tao nga anang ginsuludan, nagaalid tana sa mga logar nga ara tobig ay nagapangita tana ang logar nga anang mapawayan. Karon kon indi tana makakita anang parawayan maisipan na nga mabalik tana run lang sa anang ginalinan. ");
INSERT INTO clu_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Kag kon sa anang pagbalik makita na nga ang logar nga anang ginalinan limpyo ron kag naimus ang tanan, ");
INSERT INTO clu_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","mapanaw tana dayon kag magpangagad pito pa gid ka mga malain nga ispirito nga mas malain pa kaysa kanana. Kag masulud sanda dayon sa tao nga dato kag olian. Kag ang tao maging mas malain pa gid kaysa dati.” ");
INSERT INTO clu_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Pagkaambal dato ni Jesus, may babai doto sa mga tao nga nagsinggit kanana, makon na, “Masoirti ang babai nga nagbudus kag nagpatiti kanimo!” ");
INSERT INTO clu_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Nagsabat si Jesus, makon na, “Piro mas masoirti pa gid ang mga tao nga nagapamati kag nagasonod sa anang ambal ang Dios.” ");
INSERT INTO clu_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Mintras nagadurukdukan ang mga tao kay Jesus, makon na, “Masyado ra gid kalain ang mga tao sa tyimpo nga dia. Nagapangayo sanda kanakun nga pakitaan ko sanda ang milagro bilang pagpamatood kono nga ako ginsogo manda ang Dios. Piro ara iba nga milagro akun ipakita kananda kondi ang milagro nga natabo kay Jonas. ");
INSERT INTO clu_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ay kon paiwan nga ang natabo dato anay kay Jonas naging tanda sa mga taga-Neneve nga tana ginsogo ang Dios, ang matatabo Kanakun nga Naging Tao maging tanda ra sa mga tao sa tyimpo nga dia nga ako ginsogo manda ang Dios. ");
INSERT INTO clu_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Sa adlaw ang pagukum mababanaw ang Rayna ang Salatanan pati ang mga tao sa dadi kag basolon na sanda. Ay tana sa marayu pa gid gani nga logar sa salatanan nagalin agud magpamati sa anang kaaram ni Aring Solomon. Piro dadi may nagatodlo digi nga sobra pa kay Solomon, piro kamo tana indi magbaton anang ginatodlo. ");
INSERT INTO clu_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Pagabot ang pagukum, ang mga taga-Neneve mababanaw ra kaiban ang mga tao sa dadi kag basolon nanda sanda. Ay pagkabati ang mga taga-Neneve dato anay sa anang wali ni Jonas, nagirinulsul sanda. Piro dadi may nagatodlo nga sobra pa kay Jonas, garing kamo tana indi magbaton anang ginatodlo.” ");
INSERT INTO clu_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Makon pa ni Jesus, “Ara tao nga nagasindi ang solo kag pagkatapos tagoon dayon okon takluban ang tabig, kondi ginabutang gid tana sa torongtongan agud makakita ang mga nagasulud. ");
INSERT INTO clu_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Atun mata anang pinakasolo atun lawas. Ay kon masanag imong panulung nasanagan run da imong bilog nga lawas. Piro kon imong panulung madulum naduduluman ra imong lawas. ");
INSERT INTO clu_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Gani sigoroon mo nga nasanagan kaw ron manda, ay sabun dan imong ginakoon nga kasanag madulum. ");
INSERT INTO clu_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kag kon imong bilog nga lawas nasanagan run kag ara gid parti nga madulum, dan obos masanagan, pario sa nalanyagan kaw ang masanag nga solo.” ");
INSERT INTO clu_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Pagkatapos ambal ni Jesus, may sangka Pariseo nga nagagad kanana nga magkaun doto sa anang balay. Gani nagtabid tana doto kag nagkaun. ");
INSERT INTO clu_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Natingala ang Pariseo pagkakita na nga si Jesus ara nagpangogas bago magkaun sono sa andang nakaogalian. ");
INSERT INTO clu_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Gani makon ang Ginoo kanana, “Kamo nga mga Pariseo nagapakita-kita lang nga mayad indong mga ginaimo, piro ang matood gid tana indong tagiposoon pono kaakugan kag kalainan. Pario kamo sa tasa okon sa pinggan nga ginalimpyoan lang sa goa. ");
INSERT INTO clu_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ara kamo manda nagagamit indong isip. Kabay ang Dios nga nagimo atun lawas nga nakikita sa goa maman da ang nagimo ang sa sulud. ");
INSERT INTO clu_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Gani para maging limpyo kamo gid sa anang panulung, kaloyi nindo ra ang mga malisud kag ayaw nindo pagikawi kon ano andang kinanglan. ");
INSERT INTO clu_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Kailo kamo nga mga Pariseo! Ginataw nindo indong ikapolo bisan sa indong mga laswa kag mga panlakut, piro ginpabayanan nindo ang mga mas importanti pa gid nga mga butang pario sa pagimo ang matarung sa indong isigkatao kag pagigogma sa Dios. Dapat andan ginaimo nindo ang mga butang nga dia, nga ara ra ginapabayani ang pagtaw indong ikapolo. ");
INSERT INTO clu_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Kailo kamo ra gid nga mga Pariseo! Ay kon kamo sa mga simbaan, gosto nindo gid nga magpongko sa mga porongkoan nga para sa mga dungganun nga mga tao. Kag sa mga logar nga dorong tao gosto nindo gid nga magtaod sanda kanindo. ");
INSERT INTO clu_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Kailo kamo ra gid, ay ginapalatonan nindo ang mga tao indong ginaimo nga malain. Indong kaalimbawa pario sa rulubungan nga ara anang tanda kag ginalapak-lapak ang mga tao nga ara kaulam nga dato gali sa idalum may patay nga nagaparisna kananda.” ");
INSERT INTO clu_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Pagkaambal ni Jesus dato, may manogtodlo ang Kasogoan nga nagkoon, makon na, “Sir, sa imong ambal nga dan pati kami ginagapil mo ra insolto.” ");
INSERT INTO clu_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Nagsabat si Jesus, makon na, “Pati kamo nga mga manogtodlo ang Kasogoan kailo ra tungud nga ginapabugatan nindo ang mga tao sa doro nga mga soronodon nga ginadogang nindo sa Kasogoan, piro kamo mismo ara gid gani nagatoman. ");
INSERT INTO clu_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Kailo kamo ra! Ginapaimoan nindo anang mga pantyon ang mga propita nga ginpamatay indong mga kaolang-olangan. ");
INSERT INTO clu_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Gani sa indong ginaimo nga dia nagapamatood kamo kag nagakompormi ra sa andang ginimo. Ay sanda ang nagpamatay kananda kag kamo ang nagapaimo andang mga pantyon. ");
INSERT INTO clu_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Maman dan nga sono sa anang kaaram ang Dios nagkoon tana run nga lagi ang ona, makon na, ‘Magapadara ako kananda ang mga propita kag mga apostolis; kag ang iba sa akun mga ipadara patayun nanda, kag ang iba ingaboton nanda.’ ");
INSERT INTO clu_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Gani kamo nga mga tao sa dadi sisilotan ra ang Dios tungud sa anang pagkapatay ang mga propita ang ona, alin pa ang pagimo ang kalibotan ");
INSERT INTO clu_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","alin pa kay Abel asta kay Zacarias nga ginpatay sa anang ulut ang Timplo kag ang altar nga ginasonogan ang ginaalad sa Dios. Uu, sogidan ko kamo, kamo nga mga tao sa dadi sisilotan gid tungud sa andang mga ginimo. ");
INSERT INTO clu_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Kailo kamo ra nga mga manogtodlo ang Kasogoan, ay ginatago nindo ang pinakasosi sa pagintindi ang kamatoodan. Bukun lang nga ara kamo nagasonod sa kamatoodan, kondi ginapamalabagan nindo pa ang iba nga gosto magsonod.” ");
INSERT INTO clu_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Pagkaalin ni Jesus sa balay nga dato, ang mga manogtodlo ang Kasogoan kag ang mga Pariseo nagompisa run nga magdumut gid nga mayad kanana. Ginboroligan nanda tana pamangkot parti sa sari-sari nga mga butang ");
INSERT INTO clu_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","agud kon magsala gani anang sabat iakosar nanda tana. ");
INSERT INTO clu_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Sigi-sigi anang abot ang linibo nga mga tao doto kay Jesus kag nagaduruk-dukan sanda run. Mintras nagaparamati ang mga tao nagkoon si Jesus sa anang mga somolonod, makon na, “Magandam kamo, ay sabun malatonan kamo anang ogali ang mga Pariseo nga poros lang pakita-kita. ");
INSERT INTO clu_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Piro ara sikrito nga ginatago nga indi maggoa kag maulaman sa ori. ");
INSERT INTO clu_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Gani, bisan ano indong ginsoro-sikrito sa madulum, masanag gid nga mababatian kag bisan ano indong ginotik-otik sa koarto, mabaritaan ang tanan.” ");
INSERT INTO clu_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Mga amigo, indi kamo magkaadluk sa mga tao nga makapatay lang indong lawas kag pagkatapos ara sanda run sarang maimo pa kanindo. ");
INSERT INTO clu_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Indong kaadlukan tana ara iba kondi ang Dios, tungud nga pagkatapos nga patayun na anang lawas ang tao may gaum tana pa sa pagpilak anang kalag sa impyirno. Gani maman dan nga nagapadumdum ako kanindo nga tana maman indong kaadlukan. ");
INSERT INTO clu_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Kabay ang kabarato lang gid anang bayad ang pispis nga mairintuk kon ibaligya. Piro bisan bali ara sa mga tao ang mga pispis nga dan, sa Dios tana ginadumdum na gid ang kada isara. ");
INSERT INTO clu_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Gani labi run gid kamo, bisan indong mga book naulaman na kon pira. Maman dan nga indi kamo gid dapat magkaadluk ay mas labi kamo pa sa abir kon pira pa karaku nga mga pispis.” ");
INSERT INTO clu_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Makon pa ni Jesus kananda, “Sa matood tana, ang bisan sino nga nagakoon sa mga tao nga ako anang Ginoo, Ako nga Naging Tao magakilala ra nga tana akun sa atobangan anang mga angil ang Dios. ");
INSERT INTO clu_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Piro ang nagakoon sa mga tao nga ako bukun anang Ginoo, indi ko ra pagkilalaun nga tana akun sa atobangan anang mga angil ang Dios. ");
INSERT INTO clu_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ang bisan sino nga magambal kontra Kanakun nga Naging Tao mapapatawad; piro ang magambal kontra sa Ispirito Santo indi gid pagpatawadun. ");
INSERT INTO clu_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Kon tungud sa indong pagtoo daraun kamo sa anang mga simbaan ang mga Judio okon sa mga manogdomara ang mga banwa agud imbistigarun, indi kamo magpalibug kon ano indong isabat. ");
INSERT INTO clu_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ay sa oras nga dato ang Ispirito Santo maman ang magatodlo kanindo kon ano indong isabat.” ");
INSERT INTO clu_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","May tao doto nga nagkoon, makon na, “Maistro, abi kona ra akun gorang nga lalaki nga partian na ako amun sorobliun.” ");
INSERT INTO clu_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Makon ni Jesus kanana, “Ikaw nga tao kaw, sino ang nagimo kanakun nga wis okon manogparti indong pagkabutang?” ");
INSERT INTO clu_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Makon dayon ni Jesus sa mga tao, “Magamdam kamo sa tanan nga klasi nga kaakugan, ay ang matood nga kaboi bukun dipindi sa dorong manggad.” ");
INSERT INTO clu_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Kag ginsogidan na sanda dayon ang sangka paanggid, makon na, “May sangka tao nga manggaranun nga may logta nga doro gid anang tubas. ");
INSERT INTO clu_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Gani sa anang isip ang tao nga dato makon na, ‘Ano kabay akun imoon? Ara ako ron butangan akun patubas! ");
INSERT INTO clu_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Mayad pa sigoro ipaguba ko akun mga bodiga kag mapaimo ako dayon ang mas mabaul pa gid, kag doto ko ibutang akun mga patubas kag mga pagkabutang. ");
INSERT INTO clu_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Pagkatapos, tungud nga doro ron akun natipon para sa paraaboton nga mga tinoig, mapaway-way ako ron lang, magkaun, maginum, kag magpangalipay.’ ");
INSERT INTO clu_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Garing makon ang Dios kanana, ‘Kabos-kabos nga tao! Karon sa gabi bawiun run imong kaboi. Ta sino kabay ang mapolos imong gintipon nga manggad?’ ");
INSERT INTO clu_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Dan toladan anang kaalimbawa ang tao nga nagatipon ang manggad para gid lang sa anang kaogalingun piro pobri sa anang panulung ang Dios.” ");
INSERT INTO clu_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Makon dayon ni Jesus sa anang mga somolonod, makon na, “Maman dan nga ginakonan ko kamo nga indi kamo magsari palibug sa indong pagpangaboi kon ano indong kaunun kag kon ano indong isoksok. ");
INSERT INTO clu_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ay gintawan kamo ang Dios kaboi kag lawas nga mas importanti kaysa pagkaun kag sa lambong, gani indi maimo nga indi na kamo pagtawan indong pagkaun kag paglambong. ");
INSERT INTO clu_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Sulunga nindo ang mga wak: ara sanda nagatanum, ara nagaani, kag ara sanda bodiga nga ginatiponan andang pagkaun, piro ginapakaun sanda ang Dios. Mas labi kamo kaysa mga pispis, gani indi na kamo gid pagpabayanan! ");
INSERT INTO clu_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Sino kanindo ang makapalawig indong kaboi bisan maistan lang paagi sa indong pagpalibug? Ara gid! ");
INSERT INTO clu_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Gani, tungud nga ara kamo ra gid maimo para mapalawig indong kaboi bisan maistan lang gid, ta basi kon ano-ano pa gid nga mga butang indong ginapalibugan? ");
INSERT INTO clu_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Sulunga nindo bala kon paiwan nagatobo ang mga bolak; ara sanda nagapangabudlay okon nagaabul. Piro sa matood tana, bisan ang bantog kag manggaranun nga ari nga si Solomon, anang mga lambong indi makaiwan-iwan sa anang kasadya ang bisan isara sa mga bolak. ");
INSERT INTO clu_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Gani kon ginapasadya ang Dios ang mga ilamonon nga boi dadi dian sa taramnan, piro sa kaboayan ginatotodan ra lang, maimo bala nga indi na kamo pagpalambongan? Ang kaistan gid indong pagtoo! ");
INSERT INTO clu_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Kag indi kamo ra magsari palibug kon ano indong kaunun kag inumun. ");
INSERT INTO clu_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ay maman dan anang ginasari palibugan ang mga tao nga ara nagatoo sa Dios. Piro kamo tana, indong Tatay sa langit nakaulam nga kinanglan nindo dan. ");
INSERT INTO clu_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Gani indong imoon tana, intindiun nindo anang ginarian kag indong mga kinanglanun nga dan itaw na ra kanindo.” ");
INSERT INTO clu_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Kamo nga nagasonod kanakun pira lang gid, piro indi kamo magkaadluk ay ginbuut indong Tatay nga paariun kamo sa anang ginarian. ");
INSERT INTO clu_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Pamaligyaan nindo indong pagkabutang kag ipanaw nindo anang bayad sa mga malisud agud indi kamo gid mawaran kag magapatago kamo pa ang sigorado nga manggad doto sa langit. Doto tana indong pinatago indi run gid maboinan okon marangga, tungud nga ara doto takawan nga makaparapit kag ara ra may nagapangutkut. ");
INSERT INTO clu_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ay kon diin nakabutang indong pinakamanggad doto ra pirmi indong isip.” ");
INSERT INTO clu_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Kag makon pa gid ni Jesus kananda, “Magpriparar kamo pirmi agud indi kamo magolpian kon magbalik indong Ginoo. Wada nindo ang mga sorogoon nga nagaulat sa anang pagbalik andang agalun nga nagayan sa ponsyon. Nagabantay sanda kag ara nanda ginapataya andang mga solo. Gani bisan anong oras magabot andang agalun, kon magpanoktok, mabobokasan nanda ra nga lagi ang poirtaan. ");
INSERT INTO clu_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Masoirti dan nga mga sorogoon nga pagabot andang agalun nagabogtaw kag priparado. Sa matood tana, papongkoon na ang mga sorogoon nga dato doto sa anang lamisa kag tana mismo ang masirbi kananda. ");
INSERT INTO clu_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Masoirti sanda manda kon maabotan sanda nga priparado sa anang pagabot bisan tungang gabi okon kasanagun pa. ");
INSERT INTO clu_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Tandai nindo dia: kon naulaman lang ang tagbalay kon sano maabot ang takawan, sigorado nga bantayan na gid agud indi makasulud ang takawan sa anang balay. ");
INSERT INTO clu_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Gani magbantay kamo pirmi, ay sa oras nga ara nindo ginadaumdauma, magaabot Ako nga Naging Tao.” ");
INSERT INTO clu_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Nagpamangkot si Pedro, makon na, “Ginoo, para kino ang paanggid nga dato, para kanamun nga imong mga somolonod okon para sa tanan?” ");
INSERT INTO clu_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ginsabat tana ni Jesus paagi sa sangka paanggid pa gid, makon na, “Indi bala nga kon sino ang masarigan kag maaram nga sorogoon maman anang ginapili ang tagbalay nga magdomara sa anang kaiban nga mga sorogoon, kag tana ang nagataw kananda andang pagkaun sa tama nga oras? ");
INSERT INTO clu_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Masoirti ang sorogoon nga dan kon sa pagbalik anang agalun maabotan tana nga ginaimo na ang ginapaimo kanana. ");
INSERT INTO clu_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Sa matood tana, imoon tana run gid anang agalun nga manogdomara sa anang tanan nga pagkabutang. ");
INSERT INTO clu_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Piro kailo ra ang sorogoon nga kon paglarga anang agalun maisipan na nga maboay tana pa magbalik, gani ompisaan na run pamintas anang kapario nga mga sorogoon, lalaki kag babai, kag ara tana run iba nga ginaimo kondi ang magpagosto kaun, inum kag palingin. ");
INSERT INTO clu_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Maabot anang agalun sa oras nga ara na gid ginadaumdauma, kag tuktukun tana dayon. Ibilang tana sa mga tao nga indi gid masarigan. ");
INSERT INTO clu_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Ang sorogoon nga nakaulam kon ano anang gosto anang agalun piro ara nagaliuk-liuk kag ara nagasonod sa anang gosto anang agalun doro nga anot anang matitirawan. ");
INSERT INTO clu_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Kag ang sorogoon tana nga ara kaulam kon ano anang gosto anang agalun kag nakaimo ang mga butang nga bukun mayad anoton ra, piro maistan lang. Ay ang bisan sino nga gintawan doro, doro ra ang ginapaabot alin kanana. Mas doro ang ginapaabot sa tao nga ginpiaran doro.” ");
INSERT INTO clu_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Nagkoon ra si Jesus kananda, makon na, “Ako nagayan digi sa kalibotan nga dia agud sintinsyaan ang mga tao. Andang sintinsya maging pario sa kalayo kag gosto ko nga magrarab run. ");
INSERT INTO clu_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Piro bago dan matabo doro anay nga mga kalisud akun maagian. Kag indi ako gid mapabutang mintras ara pa matapos. ");
INSERT INTO clu_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","“Indong pagsarig nagayan ako digi para magdara kalinung sa kalibotan nga dia. Piro ang matood tana, nagayan ako digi agud magpaburulag-bulag ang mga tao. ");
INSERT INTO clu_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ay alin dadi, tungud kanakun may lima ka tao sa pamilya nga magakarampi-kampian. Ang tatlo kontra sa darwa kag ang darwa kontra sa tatlo. ");
INSERT INTO clu_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ang tatay kag anang bata nga lalaki magakontraan. Ang nanay kag anang bata nga babai magakontraan. Kag ang panogangan nga babai kag anang omagad nga babai magakontraan.” ");
INSERT INTO clu_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Makon dayon ni Jesus sa mga tao, makon na, “Digi kanatun kon makita nindo gani ang galum sa kasalupan kampi nagakoon kamo nga maoran, kag nagaoran manda. ");
INSERT INTO clu_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Kag kon maguyup run gani ang salatan nagakoon kamo nga magainit, kag nagainit ra gani. ");
INSERT INTO clu_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Antigo kamo magpanilag kon ano ang matatabo sa kalibotan sa indong pagsulung sa logta kag sa langit, piro basi indi kamo magpanilag sa mga nagakaratabo dadi? Pakita-kita lang indong pagkadiosnon!” ");
INSERT INTO clu_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Basi ara nindo gid ginabinag-binaga kon ano ang tama. ");
INSERT INTO clu_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Kon may magakosar kanimo, imoratan mo nga lagi nga magpakigariglo mintras nagapaayan kamo pa lang sa korti. Ay sabun daraun na kaw gid sa wis kag iintriga kaw dayon ang wis sa polis agud prisoon. ");
INSERT INTO clu_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Kag indi kaw gid makagoa kon indi mo anay pagbayadan ang tanan mo nga molta.” ");
INSERT INTO clu_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","May mga tao doto nga nagbarita kay Jesus parti sa mga taga-Galilea nga ginpapatay ni Pilato mintras nagaalad sanda ang mga sapat. ");
INSERT INTO clu_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Makon ni Jesus sa mga nagbarita kanana, “Sigoro nagaisip kamo nga natabo dato kananda tungud nga mas malain sanda nga mga tao kaysa sa iba nga mga taga-Galilea. ");
INSERT INTO clu_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Piro bukun! Sogidan ko kamo, loas kon magirinulsul kamo kag magtaralikod sa indong mga sala, kamo tanan madodora ra. ");
INSERT INTO clu_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Pario ra sa natabo sa 18 ka tao nga natombaan ang tori doto sa Siloam kag nagkarapatay. Sigoro indong pagsarig sanda run gid ang pinakamalain sa mga taga-Jerusalem. ");
INSERT INTO clu_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Piro bukun! Sogidan ta kamo, kon indi kamo magirinulsul kag magtaralikod sa indong mga sala, kamo tanan madodora ra.” ");
INSERT INTO clu_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Kag ginistorian sanda dayon ni Jesus ang sangka paanggid, makon na, “May sangka tao nga may gintanum nga igira sa anang kaobasan. Ginayanan na anang tanum nga dato kag ginsulung kon may bonga, piro ara tana gid may nakita. ");
INSERT INTO clu_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Gani ginkonan na ang nagaasikaso anang kaobasan, makon na, ‘Tatlo ron ka toig akun balik-balik digi nga nagasulung kon may bonga ang igira nga dia, piro ara pa ra gid man. Mayad pa putputun mo ron lang. Ginabuul na lang anang abono ang logta.’ ");
INSERT INTO clu_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Piro makon ang nagaasikaso anang logta, ‘Pabayanan ta lang anay sa dagon nga dia ay kalian ko anang palibot kag abonoan dayon. ");
INSERT INTO clu_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Kag basi pa lang nga magpamonga sa madason nga toig. Piro kon indi pa ra gid, bago ta run putputun.’” ");
INSERT INTO clu_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","May Adlaw nga Inogpaway nga si Jesus nagayan sa anang simbaan ang mga Judio kag nagtodlo doto. ");
INSERT INTO clu_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Karon, may babai doto nga bogtot tungud nga ginapamasakit tana ang malain nga ispirito. Sa sulud 18 ka toig indi tana gid makatadlung anang lawas. ");
INSERT INTO clu_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Pagkakita kanana ni Jesus gintawag na kag magkoon, makon na, “Manding, libri ka run sa imong masakit nga dan.” ");
INSERT INTO clu_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Kag gintongtong na dayon anang alima sa babai nga dato. Lagi-lagi nagtadlung anang likod kag nagdayaw tana sa Dios. ");
INSERT INTO clu_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Piro nasilag nga mayad ang manogdomara sa simbaan, tungud nga nagpaayad si Jesus sa Adlaw nga Inogpaway. Makon na sa mga tao, “Sa sangka simana may anum kita kabay ka adlaw nga inogobra. Sa mga adlaw nga dan magayan kamo digi agud magpabolong, piro indi tana kon Adlaw nga Inogpaway.” ");
INSERT INTO clu_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ginsabat tana ang Ginoo, makon na, “Pakita-kita lang indong pagkadiosnon. Indi bala nga kon kamo may baka okon kabayo, ginaobad nindo kag ginagoyod sa mga parainuman bisan Adlaw nga Inogpaway? ");
INSERT INTO clu_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Kon ginaimo nindo dan sa sapat, basi indi ta pagimoon ang mayad sa babai nga dia nga isara ra sa anang mga kaliwat ni Abraham? Gingapos tana ni Satanas sa sulud 18 ka toig, gani dapat libriun tana sa anang gaum ni Satanas abir kon dia Adlaw nga Inogpaway.” ");
INSERT INTO clu_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Sa anang sabat nga dato ni Jesus nauya ang mga nagakontra kanana. Piro ang mga tao tana nalipay nga mayad tungud sa mga makatiringala nga mga butang nga anang ginpangimo. ");
INSERT INTO clu_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Nagpadayon pa gid si Jesus sa pagambal. Makon na, “Sa ano ko kabay ipatolad anang pagari ang Dios? ");
INSERT INTO clu_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Anang pagari ang Dios pario sa bosol ang mostasa nga ginpanggas ang sangka tao sa anang gardin. Nagtobo ang mostasa kag nagbaul nga daw sa kaoy anang kataas, kag napogadan ang mga pispis anang mga sanga.” ");
INSERT INTO clu_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Pagkatapos nagambal ruman si Jesus parti sa pagrapta anang pagari ang Dios sa mga tao. Makon na, “Sa ano pa kabay ipaalimbawa anang pagari ang Dios? ");
INSERT INTO clu_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Pario dia sa pampaabok nga ginlakut ang babai sa sangka labador nga arina nga anang ginmasa, kag nagabok dayon ang bilog nga minasa.” ");
INSERT INTO clu_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Mintras nagapaayan si Jesus sa Jerusalem sigi anang panodlo sa mga bario kag mga banwa nga anang naagian. ");
INSERT INTO clu_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Karon, may sangka tao nga nagpamangkot kanana, makon na, “Ginoo, ano kabay, maistan lang ang mga tao nga malowas?” Ginsabat tana ni Jesus paagi sa paanggid. Makon na, ");
INSERT INTO clu_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Magimorat kamo gid sa pagsulud sa masipot nga poirtaan. Ay ang matood tana, doro andan ang maliag nga magsulud, garing indi sanda makasulud. ");
INSERT INTO clu_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Kon nakapanirado ron ang tagbalay anang poirtaan magaagoanta kamo ron lang gid tindug sa goa nga magapanoktok kag magasari koon nga ‘Ginoo, pasuluda kami ra.’ Piro sasabatun na kamo nga nagakoon, ‘Ara ako kakilala kanindo.’ ");
INSERT INTO clu_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Pagkatapos masabat kamo nga, ‘Kabay nagkaraiban kita sa pagkaun, kag nakatodlo kaw ra sa mga karsada sa amun banwa.’ ");
INSERT INTO clu_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Piro masabat tana kanindo nga, ‘Basta ara ko kamo gid nakilala. Pagparayu kamo kanakun, tanan kamo nga nagaimo ang malain!’ ");
INSERT INTO clu_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Magapanangis kamo kag mapapagut indong ngipun kon makita nindo indong mga kaolang-olangan nga sanday Abaraham, Isaac, Jacob kag ang tanan nga mga propita doto sa anang ginarian ang Dios, piro kamo tana ginpilak sa goa. ");
INSERT INTO clu_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Kag bukun lang dan, kondi makikita nindo pa ang mga bukun Judio nga nagaralin sa tanan nga parti ang kalibotan nga magapongko kag magakaun doto mismo sa anang ginarian ang Dios. ");
INSERT INTO clu_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","May mga tao nga midyo bali ara sanda dadi, piro kon magabot ron ang adlaw nga dato kikilalaun sanda. Kag may mga ginakilala dadi nga kon magabot ron ang adlaw nga dato bali ara sanda run lang.” ");
INSERT INTO clu_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Sa oras ra nga dato may mga Pariseo nga nagparapit kay Jesus kag nagkoon, makon nanda, “Kinanglan magalin kaw digi tungud nga gosto ni Herodes nga ipapatay kaw.” ");
INSERT INTO clu_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Piro ginsabat sanda ni Jesus, makon na, “Panaw, sogidi nindo ang toso nga dan nga Herodes nga sigi akun pangsobol ang mga malain nga ispirito kag nagapangayad ako ang mga masakitun dadi asta sa aruman kag sa ikatlo ka adlaw matatapos ko ron akun obra. ");
INSERT INTO clu_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Kinanglan gid nga padayonon ko akun pagpanaw nga dia dadi, aruman, kag asta sa isarang aruman tungud nga bukun bagay nga ang propita patayun sa ibang logar kondi sa Jerusalem. ");
INSERT INTO clu_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Kamo nga mga taga-Jerusalem, basi ginapamato kag ginapamatay nindo ang mga propita ang Dios nga ginpadara kanindo? Boay run akun andum nga tiponon kamo kag atipanun pario sa inan nga manok nga nagatipon anang mga pisu sa idalum anang mga pakpak, garing indi kamo kanakun. ");
INSERT INTO clu_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Dadi, baala kamo ron sa indong kaogalingun. Ay indi nindo ako ron gid makita asta magabot ang adlaw nga magakoon kamo nga, ‘Dayawon ang nagaabot nga ginpadara ang Ginoo.’” ");
INSERT INTO clu_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","May sangka Adlaw ruman nga Inogpaway nga si Jesus ginimbitar ang isara sa mga manogdomara ang mga Pariseo nga magkaun doto sa anang balay. Pagabot ni Jesus doto ginbantayan tana nga mayad ang mga tao nga nagakontra kanana kon lapasun na ang Kasogoan. ");
INSERT INTO clu_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Karon, may tao doto nga nagaparamanug anang bilog nga lawas. ");
INSERT INTO clu_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Nagpamangkot si Jesus sa mga manogtodlo ang Kasogoan kag sa mga Pariseo, makon na, “Ginatogot bala atun Kasogoan nga magpangayad ang mga masakitun kon Adlaw nga Inogpaway okon ara?” ");
INSERT INTO clu_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Piro ara sanda gid naglimug-limug. Ginkaputan na dayon ang tao nga dato kag ginayad na. Pagkatapos ginpaoli na. ");
INSERT INTO clu_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Kag nagkoon tana sa mga tao doto, makon na, “Pario abi may dian kanindo nga anang bata okon anang baka naolog sa bobon ang Adlaw nga Inogpaway, ta pabayanan nindo lang ay Adlaw nga Inogpaway?” ");
INSERT INTO clu_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Piro ara ra gid may nagsabat kanana sa anang pamangkot nga dia. ");
INSERT INTO clu_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Napanilagan doto ni Jesus nga ang mga tao nga ginpangimbitar nagapili gid ang mga porongkoan nga para sa mga importanti nga mga tao. Gani nagsaysay tana kananda. ");
INSERT INTO clu_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Makon na, “Kon ikaw ginaimbitar sa mga ponsyon ang kasal, indi mo pagpiliun ang porongkoan nga para sa mga importanti nga mga tao. Ay sabun may ginimbitar nga mas importanti pa gid kaysa kanimo. ");
INSERT INTO clu_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Kag ang nagimbitar kanindo nga darwa magaparapit kanimo kag magkoon, ‘Abi pagalin anay dian, ay dan nga porongkoan para sa tao nga dia.’ Ta kon toladan ang matabo, mauyan kaw kag kon diin ka run lang nga binit-binit mapongko. ");
INSERT INTO clu_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Piro imong imoon tana kon ikaw imbitarun, piliun mo lang ang porongkoan nga sa binit-binit, agud pagabot ang nagimbitar kanimo parapitan kaw kag daraun doto sa importanti nga mga porongkoan. Ta kondi mapadungugan kaw sa atobangan ang tanan nga ginimbitar. ");
INSERT INTO clu_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ay ang bisan sino nga nagapataas-taas anang kaogalingun ibubutang sa ubus, piro ang nagapaubus tana pataasun ang Dios.” ");
INSERT INTO clu_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Makon na ra sa tao nga nagimbitar kanana, “Kon magimbitar kaw ang mga tao nga magigma okon magyapon kanindo, indi basta lang imong mga amigo okon imong mga kabogto okon imong mga paryinti okon imong mga kamalay nga manggaranun imong imbitarun, ay basi kon imbitarun ka nanda ra. Kon toladan ang matabo nabaton mo ron imong balus. ");
INSERT INTO clu_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Imong imoon tana kon magponsyon kaw, ang mga pobri, ang mga pingkaw, ang mga piang, kag ang mga bolag maman imong pangimbitarun. ");
INSERT INTO clu_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Dan maging masoirti kaw nga mayad tungud nga indi sanda makabalus kanimo, piro ang Dios tana maman gid ang magabalus kanimo pagabot ang oras nga mabanaw ang mga matarung.” ");
INSERT INTO clu_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Pagkabati dato ang isara sa mga tao nga nakaiban kay Jesus doto sa pagkaun, nagambal tana, “Masoirti gid ang mga tao nga makairug sa pagkaun doto sa anang ginarian ang Dios!” ");
INSERT INTO clu_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ginistorian tana dayon ni Jesus, makon na, “May sangka tao nga nagpriparar mabaul nga ponsyon, kag doro anang ginpangimbitar. ");
INSERT INTO clu_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Pagabot ang oras nga inogkaun run, ginsogo na anang sorogoon nga ayanan run anang mga ginpangimbitar kag konon nga ‘Magayan run doto ay priparado ron ang tanan!’ ");
INSERT INTO clu_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Garing kada isara kananda nagbaribad nga sanda kono indi makaayan. Makon ang isara, ‘Bago ako lang kabakal logta kag dapat ayanan ko dato kag sulungun. Gani pasinsyaa ako lang.’ ");
INSERT INTO clu_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Makon pa ang isara, ‘Indi ako makaayan ay bago ako lang kabakal napolo ka bilog nga baka kag tirawan ko dadi kon masadya iarado. Gani pasinsyaa ako lang.’ ");
INSERT INTO clu_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Makon pa gid ang isara, ‘Bago ako lang nga nagpakasal, gani indi ako makaayan.’ ");
INSERT INTO clu_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Pagkatapos, nagbalik ang sorogoon sa anang agalun kag ginsogidan na tana kon basi indi sanda kono makaayan. Pagkabati dato ang agalun nagugut anang ginawa. Gani makon na sa sorogoon nga dato, ‘Pagayan doto sa mga karsada kag mga dalan atun banwa kag daraa digi ang mga pobri, mga pingkaw, mga bolag kag mga piang.’ ");
INSERT INTO clu_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Pagkaimo dato ang sorogoon, makon na sa anang agalun, ‘Sir natoman run imong sogo, piro may bakanti pa gid ang karaunan.’ ");
INSERT INTO clu_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Gani makon ang agalun kanana, ‘Ta pagayan doto sa mga dalan sa goa ang banwa kag piritun mo ang mga tao nga imong makita nga magayan digi agud mapono akun balay. ");
INSERT INTO clu_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Sogidan ko kamo ang matood, doto sa mga tao nga ona ko nga ginpangimbitar, ara gid may makatiraw kananda akun ginpriparar nga pagkaun.’” ");
INSERT INTO clu_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Mintras nagapadayon si Jesus sa anang pagpanaw paayan sa Jerusalem, doro nga mga tao ang nagtawas kanana. Ginbalikid na sanda kag magkoon, ");
INSERT INTO clu_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Kon may tao nga gosto magsonod kanakun, piro mas palangga na anang mga ginikanan, anang asawa, anang mga bata, anang mga kabogto okon anang kaogalingun kaysa kanakun, indi tana poidi nga maging akun somolonod. ");
INSERT INTO clu_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ang bisan sino nga bukun disidido nga magsonod kanakun asta sa kamatayun indi poidi nga maging akun somolonod. ");
INSERT INTO clu_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ang tao nga gosto magsonod kanakun pario sa tao nga nagaplano nga mapatindug ang mataas nga balay. Primiro binag-binagun na anay kon pira anang magastos kag kon magaigo anang koarta nga garastoson asta matapos ang balay. ");
INSERT INTO clu_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ay kon indi na dia pagimoon sabun pondasyon pa lang anang mapaobra maobos ron anang koarta kag indi na run makapatapos. Gani kadlawan tana ang mga tao nga makakita. ");
INSERT INTO clu_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Magakoon sanda nga ‘Nagsari pa patindug ang tao nga dia nga indi ra lang makapatapos.’ ");
INSERT INTO clu_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Pario ra sa sangka ari nga mapakiggira sa ibang ari. Dapat isip-isipun na anay kon anang soldado nga 10,000 poidi ikontra sa 20,000 ka soldado ang isara. ");
INSERT INTO clu_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ta kon matimbang-timbang na nga indi poidi, mas mayad nga sa mas timprano pa magsogo tana nga lagi ang iba nga anang mga tinao sa ang kakontra nga ari nga gosto na nga magpakigosay. ");
INSERT INTO clu_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Dan toladan ra indong dapat imoon. Isip-isipun nindo anay ay kon indi nindo pagsalaan ang tanan nga indong pagkabutang nga indong ginapalabi digi sa kalibotan, indi kamo poidi nga maging akun somolonod.” ");
INSERT INTO clu_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Ang asin mayad, piro kon magrimo anang lasa, ara run may maimo para mapabalik anang dati nga lasa. ");
INSERT INTO clu_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Indi run mapolosan bisan ilakut pa sa mga risna agud iabono. Gani ginapilak run lang. Ta binag-binaga nindo nga mayad indong mga nabatian nga dia.” ");
INSERT INTO clu_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Doro gid nga mga manogsokot ang boiskag ibang mga tao nga ginakabig nga makasasala ang nagaparapit kay Jesus para magpamati sa anang mga panodlo. ");
INSERT INTO clu_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Nagmoro-moro ang mga Pariseo kag mga manogtodlo ang Kasogoan. Makon nanda, “Ang tao nga dia nagabaton bisan sa mga makasasala, kag nagairug pa kananda sa pagkaun!” ");
INSERT INTO clu_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Gani ginistorian sanda ni Jesus ang mga paanggid, makon na, ");
INSERT INTO clu_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Alimbawa abi may tao nga may 100 ka karniro. Karon ang sakabilog abi nadora. Ta ano anang imoon? Syimpri salaan na anay ang 99 doto sa araraban kag pangitaun na dayon ang nadora nga dato nga sakabilog asta makita. ");
INSERT INTO clu_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ta kon makita na run gani malilipay tana kag pasanun na dayon paoli. ");
INSERT INTO clu_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Pagabot na sa anang balay panawagun na anang mga amigo kag mga kamalay kag magkoon, ‘Dali makalipay kita, ay nakita ko ron akun karniro nga nadora.’” ");
INSERT INTO clu_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Makon dayon ni Jesus, “Toladato ra doto sa langit. Mas mabaul ang kalipay tungud sa sangka makasasala nga nagainulsul kaysa sa 99 nga kono mga matarung kag indi kinanglan nga maginulsul.” ");
INSERT INTO clu_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Okon alimbawa abi may babai nga may napolo ka sinsilyo. Ano kabay anang imoon kon madora ang sakabilog? Syimpri sindian na gid ang solo kag siligan na nga mayad anang balay agud sagapun ang sinsilyo asta makita. ");
INSERT INTO clu_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Kag kon makita na run gani, panawagun na anang mga amiga kag mga kamalay kag makoon nga, ‘Magkalipay kita, ay nakita ko ron akun sinsilyo nga nadora.’” ");
INSERT INTO clu_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Kag makon dayon ni Jesus, “Toladan ra anang kalipay ang mga angil ang Dios doto sa langit kon ang sangka makasasala maginulsul.” ");
INSERT INTO clu_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","May sangka paanggid pa gid nga ginsogid si Jesus. Makon na, “May sangka tao nga may darwa ka bata nga lalaki. ");
INSERT INTO clu_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Makon ang libayun sa anang tatay, ‘Tay, abi tawan run kanakun akun parti nga sorobliun.’ Gani ginuray na anang pagkabutang sa anang darwa ka bata. ");
INSERT INTO clu_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Magpira ka adlaw, ginpamaligya ang libayun anang parti nga mga pagkabutang kag pagkatapos nagayan tana dayon sa marayu nga logar kag ginoyangan na doto anang koarta sa mga butang nga ara gid kapolos-polos. ");
INSERT INTO clu_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Kag pagkatapos nga naobos na run gastos anang koarta, nagabot ra ang tig-gurutum gid sa logar nga dato. Gani naglisud tana nga mayad. ");
INSERT INTO clu_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Anang ginimo nagpamogon tana run lang sa tao nga taga-doto bilang manogdamog ang baboy doto sa bokid. ");
INSERT INTO clu_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Kon kaisan gosto na run nga magkaun ang damog agud maoli-olian anang gutum, ay ara gid may nagataw kanana pagkaun. ");
INSERT INTO clu_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ang ori, nakaisip tana sa anang kaimtangan kag kon basi nagtoladato. Nadumduman na nga doto kananda pagosto sa pagkaun anang mga sorogoon anang tatay kag tana tana masosobok ron. ");
INSERT INTO clu_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Makon na, ‘Mayad pa maoli ako ron lang doto kay tatay kag konon ko tana nga, “Tay nagkasala ako sa Dios kag kanimo. ");
INSERT INTO clu_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Dadi indi ako ron bagay nga ibilang pa nga imong bata, kabiga ako ron lang nga isara sa imong mga sorogoon.” ’ ");
INSERT INTO clu_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Gani nagoli tana. Mintras sa marayu tana pa, nakita tana nga lagi anang tatay. Nalooy tana nga mayad sa anang bata. Domalagan dayon ang tatay paayan sa anang bata kag ginakus na kag ginarukan. ");
INSERT INTO clu_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Makon dayon anang bata kanana, ‘Itay, nagkasala ako sa Dios kag kanimo. Indi ako ron bagay nga tawagun pa nga imong bata. Imoa ako ron lang nga sorogoon.’ ");
INSERT INTO clu_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Piro anang ginimo tana anang tatay, gintawag na anang mga sorogoon kag magkoon, makon na, ‘Dali, pagbuul kamo ang pinakamasadya nga lambong kag pasoksoki nindo tana. Pasoksoki nindo ra ang singsing kag pasapatosan. ");
INSERT INTO clu_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Pagkatapos bulun nindo dayon ang toriti nga baka nga ginapatambuk kag yawon. Maponsyon kita. ");
INSERT INTO clu_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Tungud nga ginbilang ko nga patay run akun bata nga dia, piro dadi naboi. Nadora tana piro dadi nakita run.’ Kondi nagompisa sanda run ang pangalipay. ");
INSERT INTO clu_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Natabo dia mintras sa oma ang gorang nga bata. Ang tana nagaoli run, kag marapit run sa balay, nababatian na nga may mga nagasonata kag nagasaraot. ");
INSERT INTO clu_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Gani tinawag na ang isara sa mga sorogoon kag nagpamangkot kon may ano doto sa andang balay. ");
INSERT INTO clu_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ginsogidan tana ang sorogoon, makon na, ‘Imong libayun nagoli run kag ginpayaw ni tatay mo ang ginpatambuk nga toriti, ay nakaoli tana nga mayad ra anang lawas kag ara dipirinsya.’ ");
INSERT INTO clu_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Pagkabati na dato nagugut anang ginawa kag indi tana run magsulud sa balay. Gani naggoa anang tatay kag ginaramaraman na tana. ");
INSERT INTO clu_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Piro nagsabat tana kay tatay na, makon na, ‘Dumduma bala kon pira run ka toig akun sirbi kanimo. Ara ako gid magsoay kanimo kag pirmi ko gid nga ginatoman imong ginasogo, piro bisan kambing lang ara mo ako gid pagtawi agud magkalipay kami akun mga amigo. ");
INSERT INTO clu_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Dadi, pagabot imong bata nga dan nga nagobos imong pagkabutang sa mga babai nga malain, ginpayawan mo pa baka.’ ");
INSERT INTO clu_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Makon anang tatay kanana, ‘Ikaw pirmi digi kanakun, kag ang tanan nga akun imo ra. ");
INSERT INTO clu_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Dapat magkalipay kita, ay dati ginbilang ta nga patay run imong libayun nga dia, piro dadi naboi tana. Nadora tana piro dadi nakita run.’” ");
INSERT INTO clu_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Pagkatapos, nagistoria pa si Jesus sa anang mga somolonod. Makon na, “Ang ona may sangka manggaranun nga may sorogoon nga anang gintogyanan anang mga pagkabutang. Karon may nagsogid sa manggaranun nga dato nga anang mga pagkabutang ginaoyang-oyang anang gintogyanan nga sorogoon. ");
INSERT INTO clu_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Gani ginpatawag ang manggaranun anang sorogoon nga dato nga gintogyanan. Makon na, ‘May mga nabatian ako nga ginaoyang-oyangan mo kono akun pagkabutang. Mayad pa masomada kita parti sa akun pagkabutang nga gintogyanan kanimo ay alin dadi bukun ka run akun ginatogyanan digi.’ ");
INSERT INTO clu_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Tungud nga ginapaalin tana run anang agalun ginaisip na kon ano anang imoon. Makon na, ‘Indi ako ra paman makasarang ang maburugat nga obra pario pagpangali, kag nauya ako ra nga magpalimos. ");
INSERT INTO clu_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Toladia gali akun imoon agud bisan paalinun ako akun agalun may maayanan ako pa ra gid nga mga tao nga magabaton kanakun sa andang mga balay.’ ");
INSERT INTO clu_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Anang ginimo, isara isara na nga ginpatawag ang mga may otang sa anang agalun. Nagpamangkot tana sa naona, makon na, ‘Pira imong otang sa akun agalun?’” ");
INSERT INTO clu_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Makon na, “100 ka lata nga mantika.” Makon ang gintogyanan kanana, “Sigi, dagi imong risibo, pagpongko kag ilisi nga lagi. Ibutang mo 50 run lang.” ");
INSERT INTO clu_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Pagkatapos nagpamangkot tana ruman sa isara nga may otang. Makon na, “Pira imong otang sa akun agalun?” Makon ang ikarwa, “100 ka pasong nga trigo.” “Sigi, dagi imong risibo, ibutang mo ron lang nga 80 ka pasong.” ");
INSERT INTO clu_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Pagkaulam ang agalun kon ano anang ginimo, gindayaw na anang dayaun nga gintogyanan sa anang kaaram tungud nga nakapriparar tana run para sa anang paraaboton. Ay mas maaram ang mga tao nga nagapalabi sa mga butang digi sa kalibotan kag mas maaram magpakigbagay sa andang kapario kaysa mga tao nga nasanagan parti sa Dios. ");
INSERT INTO clu_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Gani akun koon kanindo, gamita nindo indong manggad digi sa kalibotan para sa pagpangamigo, agud pagabot ang adlaw nga ara run ang kalibotanun nga manggad, batonon kamo ra doto sa iristaran nga ara run kataposan. ");
INSERT INTO clu_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ang tao nga masarigan sa mga mairintuk nga mga butang masasarigan ra sa mga importanti nga mga butang. Kag ang tao nga nagadaya sa mga mairintuk nga mga butang, nagadaya ra sa mga importanti nga mga butang. ");
INSERT INTO clu_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","12","Ta kon indi kamo masarigan nga magkaput ang manggad nga digi sa kalibotan nga bukun indo gid, sino ang mapiar kanindo ang matood gid nga manggad nga para andan kanindo? ");
INSERT INTO clu_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Ara sorogoon nga makasirbi ang dungan sa darwa ka agalun, ay ang matatabo malainan tana sa isara kag magapalangga sa isara; kampian na ang isara kag pakalainun na ang isara. Kamo indi ra makasirbi ang dungan sa Dios kag sa manggad.” ");
INSERT INTO clu_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Pagkabati dato ang mga Pariseo ginyagota nanda si Jesus ay masyado sanda kadalok sa koarta. ");
INSERT INTO clu_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Piro nagkoon si Jesus kananda, makon na, “Masyado kamo gid magpakita-kita sa mga tao nga kamo mayad. Piro naulaman ang Dios kon ano gid ang sa indong tagiposoon. Ay ang mga butang nga dan nga ginapalabi ang tao kaurugut tana sa panulung ang Dios. ");
INSERT INTO clu_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Bago magabot si Juan nga manogbunyag, anang Kasogoan ni Moises kag anang mga ginsolat ang mga propita maman anang ginasonod ang mga tao. Alin kay Juan nga manogbunyag, ang Mayad nga Barita parti sa anang pagari ang Dios maman run ang ginatodlo, kag doro gid ang nagarugus nga magpasakup. ");
INSERT INTO clu_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Piro dia ara nagakaologan nga nadora run ang Kasogoan. Mas maulas nga madora ang langit kag ang logta kaysa maging ara polos bisan ang pinakamaistan nga parti ang Kasogoan. ");
INSERT INTO clu_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Gani ang bisan sino nga magbulag sa anang asawa kag magpangasawa ruman sa iba nagapanginbabai. Kag ang magpangasawa sa babai nga ginbulagan nagapanginbabai ra.” ");
INSERT INTO clu_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Nagpadayon pa gid si Jesus sa pagambal, makon na, “Ang ona may sangka manggaranun nga anang lambong poros gid maraalun kag pagosto gid sa manaramit nga pagkaun adlaw-adlaw. ");
INSERT INTO clu_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Kag may sangka tao ra nga pobri gid nga anang aran si Lazaro. Si Lazaro nga dia anang lawas poros gid katul nga nagadalimaso. Ginadara tana doto sa may poirtaan anang balay ang manggaranun. ");
INSERT INTO clu_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Gosto na andan nga makakaun bisan ang mga pagkaun ron lang nga nagakaraolog sa anang lamisa ang manggaranun nga dato. Ginparapitan tana pa gani ang mga ayam kag gindilatan nanda anang mga igad. ");
INSERT INTO clu_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ang ori napatay si Lazaro kag gindara tana ang mga angil doto sa anang tupad gid ni Abraham. Ang manggaranun napatay ra kag ginlubung. ");
INSERT INTO clu_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Kag mintras nagaantos tana nga mayad doto sa logar nga ginasilotan ang mga napatay natangraan na sa marayu si Abraham kag doto sa anang tupad si Lazaro. ");
INSERT INTO clu_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Gani nagsinggit ang manggaranun kay Abraham, makon na, ‘Olang Abraham, kaloyi ako ra! Sogoa ra si Lazaro nga isawsaw na sa tobig bisan anang todlo ron lang kag patoroan akun dila agud magramig-ramig ra, ay sugung akun pagantos digi sa kalayo nga dia.’ ");
INSERT INTO clu_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Piro ginsabat tana ni Abraham, ‘Kabay ang boi ka pa mayad gid imong kaimtangan, kag si Lazaro tana nagkalisud. Piro dadi ginalipay tana digi kag ikaw nagaantos. ");
INSERT INTO clu_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Loas pa dian, indi ra gid maimo imong ginakoon, tungud nga may malapad nga ulut nga nagaulang kanatun nga ang bisan sino digi kanamun nga maliag magsaylo dian indi makatabok, kag ara ra may makatabok nga alin dian kanindo paayan digi kanamun.’ ");
INSERT INTO clu_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Makon roman ang manggaranun, ‘Olang Abraham, kon toladan, mapangabay ako ron lang nga kon maimo paayana ra si Lazaro sa anang balay ni tatay, ");
INSERT INTO clu_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ay may lima ako pa ka kabogto nga lalaki, kag paandaman na sanda agud indi sanda ra makaayan digi sa logar nga dia nga poros lang pagantos.’ ");
INSERT INTO clu_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Piro ginsabat tana ni Abraham, makon na, ‘Doto ra kananda anang mga sinolat ni Moises kag ang mga propita. Magpamati sanda doto.’ ");
INSERT INTO clu_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Makon ang manggaranun, ‘Piro olang Abraham, indi sanda magpati doto. Piro kon may napatay nga magayan doto kananda, mainulsul sanda sa andang mga sala.’ ");
INSERT INTO clu_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Piro nagkoon si Abraham, makon na, ‘Kon indi sanda magpati sa anang mga ginsolat ni Moises kag ang mga propita, indi sanda ra gid magpati bisan may mabanaw pa nga patay!’” ");
INSERT INTO clu_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Makon ni Jesus sa anang mga somolonod, “Indi maimo nga indi magabot ang mga pagsolay. Piro kailo ra ang tao nga ginaalinan anang pagpakasala anang kapario. ");
INSERT INTO clu_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Mas mayad pa kanana nga igotan ang galingan nga bato anang liug kag ipandag dayon sa dagat kaysa tana ang maging kabangdanan nga magkasala ang isara sa mga kubus nga dia. ");
INSERT INTO clu_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Gani magandam kamo! “Kon imong kabogto magkasala kanimo, sawayun mo. Kag kon maginulsul tana, patawada. ");
INSERT INTO clu_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Kag kon sa sulud sangka adlaw kapito tana magkasala kanimo kag kada magkasala tana nagapangayo tana ra patawad, patawadun mo.” ");
INSERT INTO clu_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Makon ang mga apostolis kanana, “Ginoo, dogangi ra amun pagtoo!” ");
INSERT INTO clu_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Makon ang Ginoo kananda, “Kon kamo may pagtoo nga bisan pario lang sa anang bosol ang mostasa anang kabaul, sarang kamo makakoon sa kaoy nga dan nga ‘Gabota imong kaogalingun kag isaylo sa dagat!’ Kag matoman kanindo ang kaoy nga dan.” ");
INSERT INTO clu_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Makon roman ni Jesus kananda, “Alimbawa abi may sorogoon kaw nga nagaarado okon nagabantay imong mga sapat, kag bago tana lang kaoli alin sa anang obra. Ta bilang agalun ano kabay, magakoon kaw nga, ‘Dali makaun run.’ ");
INSERT INTO clu_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ara kamo nagakoon toladan kondi nagakoon kamo tana nga, ‘Abi, imusi ako ron akun yapon kag magsirbi kanakun. Pagkatapos ikaw roman ang magkaun.’ ");
INSERT INTO clu_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Kag ara ra ginapasalamati ang sorogoon tungud nga ginaimo na lang anang katungdanan. ");
INSERT INTO clu_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Pario sa sorogoon nga dan indong kaalimbawa. Pagkatapos nga indong maimo ang ginapaimo kanindo, isipun nindo nga kamo mga sorogoon ra lang nga nagatoman indong katungdanan.” ");
INSERT INTO clu_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Mintras nagapaayan si Jesus sa siodad ang Jerusalem, doto tana nagagi sa anang dolonan anang probinsya ang Samaria kag Galilea. ");
INSERT INTO clu_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Datong nagapasulud tana sa sangka bario ginsolang-solang tana ang napolo ka tao. Piro ara sanda nagparapit gid ay sanda mga aroon. Nagtirindug sanda lang doto sa marayu, ");
INSERT INTO clu_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","kag nagasiringgit nga nagakoon, makon, “Jesus! Ginoo! Malooy kaw ra kanamun!” ");
INSERT INTO clu_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Pagkakita ni Jesus kananda, makon na, “Pagayan kamo doto sa mga Pari kag magpasulung kananda.” Kag datong nagapanaw sanda run, nagayad sanda nga lagi. ");
INSERT INTO clu_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Pagkakita ang isara kananda nga tana nagayad run, nagbalik tana kay Jesus nga nagasinggit ang pagdayaw sa Dios. ");
INSERT INTO clu_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Naglood tana kay Jesus kag nagpasalamat nga mayad kanana. Ang tao nga dato taga-Samaria. ");
INSERT INTO clu_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Makon dayon ni Jesus, “Kabay napolo ang nagayad? Ta sadin run ang siam? ");
INSERT INTO clu_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Basi ara iba nga nagbalik digi agud magpasalamat sa Dios loas sa tao nga dia nga bukun Judio?” ");
INSERT INTO clu_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Makon dayon ni Jesus kanana, “Pagtindug kag magoli. Nalowas kaw tungud sa imong pagtoo.” ");
INSERT INTO clu_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","May mga Pariseo nga nagpamangkot kay Jesus kon sano maompisa anang pagari ang Dios. Makon ni Jesus kananda, “Sa anang pagompisa anang pagari ang Dios ara tanda nga makikita. ");
INSERT INTO clu_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Gani ara gid may makakoon nga ‘Way sulunga nindo, dagi run!’ okon, ‘Way dato!’ Ay anang pagari tana ang Dios dian mismo sa indong palibot.” ");
INSERT INTO clu_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Makon dayon ni Jesus sa anang mga somolonod, “Magaabot ang adlaw nga magaandum kamo nga andan makita nindo Ako nga Naging Tao bisan sangka adlaw lang, piro indi pa matabo. ");
INSERT INTO clu_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","May mga magakoon kanindo nga, ‘Doto tana!’ okon ‘Digi tana!’ Indi kamo magpati kananda okon magsagiap kanakun. ");
INSERT INTO clu_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ay kon magabot ron ang adlaw nga Ako nga Naging Tao magbalik, makikita ang tanan, tungud nga maging pario sa kilat nga nagalanyag sa palibot gid. ");
INSERT INTO clu_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Piro doro anay nga mga kalisud akun dapat antoson. Sisikwayun ako ang mga tao nga dia. ");
INSERT INTO clu_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Kon ano anang ginaimo ang mga tao sa tyimpo ni Noe, maman ra dan anang imoon ang mga tao kon magabot Ako nga Naging Tao. ");
INSERT INTO clu_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Sa tyimpo nga dato ni Noe ara iba nga ginaisip ang mga tao kondi ang magpangalipay. Sigi lang andang kaun, inum, kag pangasawa asta sa adlaw nga si Noe nagsulud sa arka. Nagabot dayon ang gonaw kag nadora sanda tanan. ");
INSERT INTO clu_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Anang imoon ang mga tao maging pario ra sa anang ginaimo ang mga tao sa anang tyimpo ni Lot. Ang mga tao dato sigi ra lang andang karaun kag irinum. Nagabarakal sanda kag nagabaraligya, nagaparananum, kag nagaparatindug andang mga balay. ");
INSERT INTO clu_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Piro pagabot tana ang adlaw nga si Lot naggoa sa Sodoma ginpaoran ang Dios ang kalayo kag asopri, kag nadora sanda tanan. ");
INSERT INTO clu_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Dan toladan ra ang matatabo kon Ako nga Naging Tao magabot. ");
INSERT INTO clu_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Sa adlaw nga dato, ang tao sa goa anang balay indi dapat magpaawat nga magsulud pa para magbuul anang mga pagkabutang. Kag ang doto sa taramnan indi run dapat nga magoli pa sa anang balay. ");
INSERT INTO clu_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Dumdumun nindo ang natabo sa anang asawa ni Lot. ");
INSERT INTO clu_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ang bisan sino nga nagaimorat nga indi madora anang kaboi madodora gani. Piro ang bisan sino nga bali ara anang kaboi tungud sa anang pagsonod kanakun makakabaton ang kaboi nga ara kataposan. ");
INSERT INTO clu_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Sa matood tana, sa gabi nga dato, kon may darwa ka tao nga nagaolid nga nagakatorog, ang isara bulun kag ang isara tana salaan. ");
INSERT INTO clu_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Kon may darwa ka babai nga nagagaling, ang isara bulun kag ang isara tana salaan. ");
INSERT INTO clu_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Kag kon may darwa ka tao nga nagaobra sa andang ginaobraan, ang isara bulun kag ang isara tana salaan.” ");
INSERT INTO clu_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Makon anang mga somolonod, “Ginoo, diin dia matatabo?” Ginsabat na sanda sa paanggid, makon na, “Kon diin ang may patay nga sapat, doto ra nagatiripon ang mga wak.” ");
INSERT INTO clu_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Kag ginsogidan pa gid ni Jesus anang mga somolonod ang sangka paanggid agud todloan sanda nga magpangamoyo pirmi kag indi gid madoraan andang paglaum. ");
INSERT INTO clu_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Makon na, “May sangka wis anay sa sangka siodad nga ara naadluki sa Dios kag bali ara kanana anang isigkatao. ");
INSERT INTO clu_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Kag doto ra sa siodad nga dato may balo nga nagabalik-balik pirmi sa wis nga dato ay nagapabolig tana sa anang kaso. ");
INSERT INTO clu_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","Ang primiro indi gosto ang wis nga magbolig. Piro ang ori, tungud nga sigi anang balik-balik kag ginatoblag tana pirmi ang balo nga dato, naisip na nga bisan ara tana naadluki sa Dios kag bali ara anang isigkatao boligan na run lang agud indi tana pagtakaan.” ");
INSERT INTO clu_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Makon dayon ni Jesus kananda, “Ta nakita nindo anang ginimo ang wis nga bukun gani matarung? ");
INSERT INTO clu_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ta ang Dios pa. Indi maimo nga indi tana magbolig sa anang kaso anang mga pinili nga nagapanawag kanana adlaw-gabi. Sigorado gid nga indi na sanda pagpabayanan. ");
INSERT INTO clu_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Sa matood tana, boboligan na sanda lagi-lagi. Garing pagbalik ko digi sa kalibotan, Ako nga Naging Tao, ano kabay, makikita ko ra ang mga tao nga nagatoo?” ");
INSERT INTO clu_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Karon, may mga tao doto nga nagasarig nga sanda lang gid ang matarung kag ginamolay nanda ang iba. Gani ginistorian sanda ni Jesus ang paanggid nga dia. ");
INSERT INTO clu_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Makon na, “May darwa ka tao nga nagayan sa timplo agud magpangamoyo. Ang isara Pariseo kag ang isara manogsokot ang bois. ");
INSERT INTO clu_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ang Pariseo nagtindug doto kag silinsio nga nagpangamoyo. Makon na, ‘Dios ko, nagapasalamat ako kanimo nga bukun ako pario sa iba nga mga tao nga takawan, dayaun, kag manogpanginbabai. Kag salamat nga bukun ako ra pario sa manogsokot nga dia ang bois. ");
INSERT INTO clu_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Darwa gid ka bisis ako nagapoasa kada simana. Kag ginataw ko akun ikapolo sa tanan ko nga kinitaan.’ ");
INSERT INTO clu_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ang manogsokot tana ang bois sa marayu-rayu nagtindug. Ara tana nagtangra sa langit kondi nagadongok nga nagapolpog anang dugan nga nagakoon, makon na, ‘Dios ko, kaloyi ako ra ay ako makasasala!’ ");
INSERT INTO clu_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Sa matood tana, ang tao nga dia nagoli sa anang balay nga ginabilang run ang Dios nga matarung. Ang isara tana ara. Ay ang bisan sino nga nagapataas sa anang kaogalingun ipaubus ang Dios, piro ang nagapaubus tana anang kaogalingun pataasun.” ");
INSERT INTO clu_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","May sangka adlaw nga ginpandara ang mga tao kay Jesus pati andang mga lapsag agud tongtongan anang alima bilang pagbindisyon kananda. Pagkakita anang mga somolonod nga nagapaayan ang mga tao doto kay Jesus, ginsaway nanda ang mga tao. ");
INSERT INTO clu_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Piro gintawag ni Jesus anang mga somolonod, makon na, “Pabayani nindo lang ang mga bata nga magparapit kanakun. Indi nindo sanda pagbawali, ay kabilang sa anang ginaarian ang Dios ang mga pario kananda. ");
INSERT INTO clu_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ang matood tana gani, ang bisan sino nga indi magpasakup sa anang pagari ang Dios pario anang pagpasakup ang mga bata nga dia indi gid mapabilang sa mga tao nga ginaarian ang Dios.” ");
INSERT INTO clu_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","May sangka manogdomara ang mga Judio nga nagpamangkot kay Jesus. Makon na, “Mayad nga Maistro, ano kabay akun imoon agud makaangkun ako ang kaboi nga ara kataposan?” ");
INSERT INTO clu_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Makon ni Jesus kanana, “Basi nagakoon kaw nga ako mayad? Ara kabay iba nga mayad kondi ang Dios lang. ");
INSERT INTO clu_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Kon parti sa imong pamangkot nga dan, naulaman mo ra kabay anang ginakoon ang Kasogoan: ‘Indi kaw magpanginbabai okon magpanginlalaki, indi kaw magpatay, indi kaw magpanakaw, indi kaw magtistigo ang botig, taodon mo imong tatay kag imong nanay.’” ");
INSERT INTO clu_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Nagsabat ang tao, makon na, “Ang tanan nga dan natoman ko ron alin ang maistan ako pa.” ");
INSERT INTO clu_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Pagkabati ni Jesus sa anang sabat, makon na, “May sangka butang pa gid nga dapat mo nga imoon. Ibaligya mo imong pagkabutang kag anang bayad ipanagtag mo dayon sa mga pobri. Kag sa toladia nga paagi maging manggaranun kaw doto sa langit. Pagkatapos, magbalik kaw kag magsonod kanakun.” ");
INSERT INTO clu_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Piro pagkabati na dato naborido tana nga mayad tungud nga manggaranun tana gid. ");
INSERT INTO clu_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Pagkakita ni Jesus nga naborido tana nga mayad, makon na, “Malisud ra gid para sa mga manggaranun nga magpasakup sa anang pagari ang Dios. ");
INSERT INTO clu_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Mas maulas pa gani nga magagi ang sapat nga kamilyo sa anang boo ang dagum kaysa magpasakup ang manggaranun sa anang pagari ang Dios.” ");
INSERT INTO clu_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ang mga nakabati anang ginambal nga dato ni Jesus nagpamangkot, makon nanda, “Ta kon toladan sino ron lang kabay ang malowas?” ");
INSERT INTO clu_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Piro ginsabat sanda ni Jesus, makon na, “Ang mga butang nga indi maimo ang tao maimo ang Dios.” ");
INSERT INTO clu_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Makon dayon ni Pedro, “Ta kami, ginbayaan namun amun mga pagkabutang kag nagsonod kami kanimo!” ");
INSERT INTO clu_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Makon ni Jesus kananda, “Sa matood tana, ara gid may nagbaya anang pamilya, asawa, mga kabogto, ginikanan, okon mga bata tungud sa anang pagpasakup sa pagari ang Dios ");
INSERT INTO clu_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","nga indi makabaton pilo-pilo nga balus sa tyimpo nga dia, kag sa paraaboton may kaboi tana pa nga ara kataposan.” ");
INSERT INTO clu_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ang ori ginpabulag ni Jesus anang dosi ka apostolis kag ginkonan na sanda, makon na, “Pamati kamo! Maayan kita dadi sa Jerusalem, kag doto matotoman run anang mga gintagna ang mga propita parti kanakun. ");
INSERT INTO clu_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ako nga Naging Tao iintriga run sa mga bukun Judio. Yagotaun nanda ako, pakauyan kag doraan. ");
INSERT INTO clu_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Anoton nanda ako ra kag patayun dayon. Piro sa sulud tatlo ka adlaw mababanaw ako.” ");
INSERT INTO clu_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Garing ang mga apostolis ara gid dato kaangup kon ano anang gostong ambalun ni Jesus ay ginlipudan andang pagangup sa anang ginambal nga dato. ");
INSERT INTO clu_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ang marapit run sanday Jesus doto sa Jerico, may sangka bolag nga nagapongko sa binit ang dalan nga nagapalimos. ");
INSERT INTO clu_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Pagkabati na nga doro nga mga tao ang nagaaragi nagpamangkot tana kon anono dato. ");
INSERT INTO clu_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ginsogidan nanda tana nga si Jesus nga taga-Nazaret nagaagi. ");
INSERT INTO clu_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Pagkaulam na dato nagsinggit tana, makon na, “Jesus, nga kaliwat ni David kag manonobli anang ginarian, kaloyi ako ra!” ");
INSERT INTO clu_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ginsaway tana ang mga tao nga sa onaan nga magipus. Piro anang ginimo tana, ginpurusan na pa gani anang singgit nga nagakoon, “Jesus, nga kaliwat ni David, kaloyi ako ra!” ");
INSERT INTO clu_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Nagtadung dayon si Jesus kag nagsogo tana nga daraun ang bolag nga dato doto kanana. Pagabot ang bolag doto kay Jesus ginpamangkot na, ");
INSERT INTO clu_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ano imong gosto nga imoon ko kanimo?” Makon ang bolag, “Ginoo, gosto ko andan nga makakita ruman.” ");
INSERT INTO clu_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Makon ni Jesus kanana, “Sigi, makakita ka run. Nalowas kaw tungud sa imong pagtoo.” ");
INSERT INTO clu_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Kag lagi-lagi nakakita ang bolag nga dato. Nagsonod tana dayon kay Jesus nga nagadayaw sa Dios. Pagkakita ang mga tao sa natabo nga dia nagdayaw sanda ra sa Dios. ");
INSERT INTO clu_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Nagsulud si Jesus sa banwa ang Jerico, kag mintras nagaagi tana doto, ");
INSERT INTO clu_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","may tao doto nga manggaranun nga anang aran si Zaqueo. Tana anang manogdomara ang mga manogsokot ang bois. ");
INSERT INTO clu_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Gosto na gid nga makita kon sino si Jesus nga dia, piro tungud sa kadoroon ang tao indi na makita si Jesus ay potot tana. ");
INSERT INTO clu_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Gani anang ginimo, nagdalagan tana sa onaan kag nagsaka dayon sa kaoy nga sikomoro agud makita na si Jesus, ay doto tana gid maagi sa dalan nga dato. ");
INSERT INTO clu_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Pagabot ni Jesus doto sa anang tungud nagtangra tana kag nagambal kay Zaqueo, makon na “Zaqueo, pagdali-dali losong ay dadi dapat doto ako madayon sa indong balay.” ");
INSERT INTO clu_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Gani nagdali-dali losong si Zaqueo, kag ginbaton na si Jesus nga malipayun gid. ");
INSERT INTO clu_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Pagkakita ang mga tao nga si Jesus doto nagadayon sa balay ni Zaqueo, nagmoro-moro sanda, makon nanda, “Basi doto tana gid nagadayon sa anang balay ang tao nga dan nga makasasala?” ");
INSERT INTO clu_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ang doto sanda run sa balay nagtindug si Zaqueo kag nagkoon sa Ginoo, makon na, “Alin dadi, Ginoo, ipanagtag ko sa malisud ang katunga akun pagkabutang. Kag kon ako may gindayaan, apat ka pilo akun ibalik kanana.” ");
INSERT INTO clu_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Makon ni Jesus kanana, “Dadi ginlowas ang pamilya nga dia, tungud nga tana anang kaliwat ra ni Abraham. ");
INSERT INTO clu_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ay Ako nga Naging Tao nagayan digi sa kalibotan agud pangitaun kag lowasun ang tanan nga nagtalang sa matood nga dalan.” ");
INSERT INTO clu_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Mintras nagapamati pa ang mga tao ginsogidan na sanda ang paanggid tungud nga marapit sanda run gid sa Jerusalem kag anang kaisip ang mga tao maompisa run gid anang pagari ang Dios. ");
INSERT INTO clu_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Makon ni Jesus kananda, “May sangka prinsipi nga nagayan sa marayu nga logar agud batonon na ang awtoridad bilang ari sa anang banwa, kag pagkatapos mabalik tana ra. ");
INSERT INTO clu_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Piro bago tana nagalin ginpatawag na anang napolo ka sorogoon kag ginpanawan koarta ang kada isara kananda nga parario anang kantidad, kag nagkoon tana kananda, makon na, ‘Patikanga nindo akun ginpanaw nga dan kanindo mintras ara ako.’ ");
INSERT INTO clu_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Karon, anang mga kasimanwa ara naliag kanana. Gani pagkatapos nga tana nakaalin, nagpadara sanda mga riprisintanti sa anang ginayanan ang prinsipi agud magkoon nga indi nanda gosto nga magari kananda ang prinsipi nga dato. ");
INSERT INTO clu_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Piro ginimo pa ra gid nga ari ang prinsipi. Pagbalik na sa anang logar ginpatawag na ang mga sorogoon nga anang ginpanawan koarta nga inogpatikang agud maulaman na kon tagpira andang naganansya. ");
INSERT INTO clu_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ang primiro nga nagabot doto kanana nagkoon, makon na, ‘Ginoo, imong koarta nga gintaw kanakun nakaganasia napolo ka pilo.’ ");
INSERT INTO clu_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Makon ang ari, ‘Ta mayad, mayad kaw nga sorogoon! Tungud nga nasarigan kaw sa maistan nga dia nga butang, dadi padomaraun ta kaw sa napolo ka siodad.’ ");
INSERT INTO clu_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ang isara nga sorogoon nagabot ra. Makon na, ‘Ginoo, imong gintaw kanakun nga koarta nakaganansya bali lima ka pilo.’ ");
INSERT INTO clu_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Makon ang ari kanana, ‘Ikaw padomaraun ko ra sa lima ka siodad.’ ");
INSERT INTO clu_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Kag nagabot ang isara pa gid, makon na, ‘Ginoo, way dagi imong koarta. Ginpotos ko gid dan kag gintago, ");
INSERT INTO clu_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","tungud nga ginaadlukan ako kanimo ay masyado kaw ka istrikto nga tao. Nagabuul kaw ang ganansya sa anang kinabudlayan ang iba, kag nagabuul kaw ang patubas bisan bukun ikaw ang nagatanum.’ ");
INSERT INTO clu_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Makon ang ari kanana, ‘Ara kaw polos nga sorogoon! Imong ginambal mismo akun gamitun sa pagsintinsya kanimo. Naulaman mo gali nga ako istrikto nga tao kag nagabuul ako ang ganansya sa anang kinabudlayan ang iba, kag nagabuul ako ang patubas bisan bukun ako ang nagatanum. ");
INSERT INTO clu_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ta basi ara mo pagbutangan akun koarta sa bangko agud nga pagbalik ko mabubuul ko akun koarta kag may saka pa!’ ");
INSERT INTO clu_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Gani makon ang ari sa mga tao nga nagatirindug doto, ‘Sigi, bula nindo kanana ang koarta kag itaw doto sa tao nga nakaganansya napolo ka pilo.’ ");
INSERT INTO clu_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Piro nagsabat sanda, makon nanda, ‘Ginoo, kabay napolo ron gani ang kanana.’ ");
INSERT INTO clu_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Makon ang ari, ‘Sogidan ta kamo, ang bisan sino nga may dian tawan pa gid. Piro ang tao tana nga ara, bisan ang maistan nga ginpiar kanana bulun pa.’ ");
INSERT INTO clu_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Pagkatapos makon dayon ang ari, ‘Kon parti sa mga tao nga dato nga nagakontra kanakun kag indi gosto nga ako magari kananda, ala, pandara nindo digi kanakun kag pamatayun!’” ");
INSERT INTO clu_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Pagkatapos anang istoria nga dato, nagpadayon tana panaw paayan sa Jerusalem. ");
INSERT INTO clu_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ang marapit sanda run sa Betfage kag Betania, doto sa may bokid nga ginatawag Bokid ang mga Olibo, ginpaona ni Jesus ang darwa sa anang mga somolonod. ");
INSERT INTO clu_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Makon na kananda, “Pagona kamo doto sa masonod nga bario. Pagsamput nindo doto makikita nindo ang bataun pa nga asno nga nagaigot. Dia ara pa gid nasakayi. Obadun nindo kag daraun digi kanakun. ");
INSERT INTO clu_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Kon may magpamangkot gani kon basi ginaobad nindo, sabatun nindo nga kinanglan ang Ginoo.” ");
INSERT INTO clu_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Gani nagpanaw ang darwa, kag kon ano anang ginkoon ni Jesus kananda maman ra gid gani andang ginabotan. Doto ang bataun pa nga asno, ");
INSERT INTO clu_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","kag pagobad nanda ginpamangkot sanda gani anang mga tagya kon basi ginaobad nanda. ");
INSERT INTO clu_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ginsabat nanda nga “Kinanglan ni Ginoong Jesus.” ");
INSERT INTO clu_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Kag gindara nanda dayon kay Jesus. Pagabot doto, ginampiloan nanda ang asno andang mga lambong kag ginpasakay nanda dayon si Jesus. ");
INSERT INTO clu_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Sa anang pagsakay paayan sa Jerusalem ginladlad ang mga tao andang lambong sa dalan nga anang naagian bilang pagpadungug kanana. ");
INSERT INTO clu_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Kag ang tana nagapalusub run alin sa Bokid ang Olibo, nagapangalipay anang mga somolonod kag nagasiringgit nga nagadayaw sa Dios tungud sa mga milagro nga andang nagkarakita. ");
INSERT INTO clu_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Makon nanda, “Dayawon ang Ari nga nagaabot nga ginpadara ang Ginoo! Mayad run atun rilasyon sa Dios. Dayawon ta tana!” ");
INSERT INTO clu_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Doto sa karakuan may mga Pariseo nga nagkoon kay Jesus, makon nanda, “Maistro, paipusa imong mga somolonod.” ");
INSERT INTO clu_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Makon ni Jesus kananda, “Ang matood tana, kon magipus sanda, ang mga bato roman ang magasiringgit ang mga pagdayaw.” ");
INSERT INTO clu_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ang si Jesus marapit run sa Jerusalem, pagkakita na sa siodad, nagpanangis tana para sa mga taga-doto. ");
INSERT INTO clu_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Makon na, “Kon naulaman nindo lang andan dadi kon ano ang makakataw kanindo ang kalinung! Garing natabonan lang indong pagangup. ");
INSERT INTO clu_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Magaabot gid ang adlaw nga indong siodad sirkoloon indong mga kaaway padir agud indi kamo gid makapalagyaw. Kag sagusuun kamo sa tanan nga diriksyon. ");
INSERT INTO clu_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Pamatayun nanda kamo, kag gugubaun nanda indong siodad asta ara gid may masala nga bato nga nagakamada dian. Dia tanan matatabo kanindo tungud nga ara nindo pagsapaka ang oras nga lowasun kamo ron andan ang Dios.” ");
INSERT INTO clu_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Pagabot nanda sa Jerusalem, nagdiritso si Jesus sa timplo, kag pagsulud na doto ginpalayas na ang mga tao nga nagabaraligya. ");
INSERT INTO clu_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Makon na kananda, “Kabay nagakoon ang Dios sa Kasolatan nga anang balay logar nga parangamoyoan. Piro ginimo nindo tana nga parantagoan ang mga tolisan.” ");
INSERT INTO clu_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Alin dato kada adlaw nagatodlo tana doto sa timplo. Ang mga manogdomara tana nga mga pari, kag ang mga manogtodlo ang Kasogoan, pati ang mga opisyalis ang banwa nagpangita paagi agud patayun tana. ");
INSERT INTO clu_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Garing ara sanda kakita kaigayonan tungud nga ang mga tao tana nawiwili gid nga magpamati sa anang mga panodlo. ");
INSERT INTO clu_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","May sangka adlaw mintras nagatodlo si Jesus ang Mayad nga Barita sa mga tao doto sa timplo, nagparapit kanana ang mga manogdomara nga pari kag ang mga manogtodlo ang Kasogoan pati anang mga manogdomara ang mga Judio kag nagpamangkot kanana. ");
INSERT INTO clu_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Makon nanda, “Abi sogidi kami kon ano imong awtoridad nga nagaimo kaw ang mga butang nga imong ginaimo digi sa timplo. Sino ang nagtaw kanimo ang awtoridad nga dan?” ");
INSERT INTO clu_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Makon ni Jesus kananda, “Mapamangkot ako ra anay kanindo. Abi sogidi nindo ako. ");
INSERT INTO clu_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Kino magalin anang awtoridad ni Juan sa pagpangbunyag, sa Dios okon sa tao?” ");
INSERT INTO clu_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ginbarais-baisan nanda kon ano andang isabat; makon nanda, “Kon magkoon kita nga ‘Alin sa Dios,’ makoon tana nga, ‘Ta basi ara kamo nagpati kay Juan?’ ");
INSERT INTO clu_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Piro kon magkoon kita ra nga ‘Alin sa tao,’ babatoon kita ang mga tao, ay konbinsido sanda nga si Juan anang propita ang Dios.” ");
INSERT INTO clu_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Gani ginsabat nanda run lang si Jesus nga ara sanda kaulam. ");
INSERT INTO clu_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Gani makon ni Jesus kananda, “Ta kon indi kamo magsogid kanakun, indi ko kamo ra pagsogidan kon kino nga awtoridad ko ginaimo ang mga butang nga akun ginaimo.” ");
INSERT INTO clu_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Kag ginsogidan dayon ni Jesus ang mga tao ang paanggid, makon na, “May sangka tao nga may logta nga ginpatanuman na obas. Pagkatapos ginpaagsaan na kag nagayan dayon sa marayu nga logar. ");
INSERT INTO clu_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Datong inogpopo ron ang obas ginsogo na anang sorogoon agud magbuul anang parti doto sa mga agsador. Piro pagabot doto ang sorogoon nga dato ginbalbal nanda kag ginpaoli nga ara gid dara. ");
INSERT INTO clu_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Anang ginimo ang tagya, nagsogo tana pa gid sangka sorogoon. Piro pagabot ang sorogoon sa mga agsador ginbalbal tana ra kag ginpakauyan. Pagkatapos ginpabalik nanda ra nga ara gid dara. ");
INSERT INTO clu_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ginpadara pa gid ang tagya ang ikatlo nga sorogoon, piro pagabot na doto gintigbak nanda run gid kag ginpalayas. ");
INSERT INTO clu_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Gani makon anang tagya ang kaobasan nga dato, ‘Ano ron lang kabay akun imoon? A,’ makon na, ‘akun pinalangga gali nga bata maman akun sogoon. Ay sigoro gid nga taodon nanda tana.’ ");
INSERT INTO clu_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Piro pagkakita ang mga agsador nga anang bata run ang nagabot, makon nanda, ‘Dia run ang manogpanobli. Dali, patayun ta agud maging atun anang sorobliun.’ ");
INSERT INTO clu_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Gani gindara nanda tana doto sa goa ang kaobasan kag ginpatay nanda dayon.” Makon dayon ni Jesus kananda, “Ta ano kabay anang imoon ang tagya kananda? ");
INSERT INTO clu_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Sigorado gid nga ayanan na anang mga agsador nga dato kag pamatayun. Kag paagsaan na dayon sa iba anang kaobasan.” Pagkabati dato ang mga tao, makon nanda, “Kabay pa nga indi ra itogot ang Dios nga matabo ang toladato!” ");
INSERT INTO clu_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Piro ginsulung sanda ni Jesus kag magkoon, makon na, “Tay ano tana anang gostong ambalun ang Kasolatan nga nagakoon, ‘Ang bato nga ginsikway ang mga panday Maman gid ang naging pondasyon nga bato.’ ");
INSERT INTO clu_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ang bisan sino nga maglagpak sa bato nga dato magakarabari, piro ang lagpakan tana ang bato nga dato matutudtud gid.” ");
INSERT INTO clu_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Sa oras gid nga dato dadakupun tana run andan ang mga manogtodlo ang Kasogoan kag ang mga manogdomara nga mga pari, ay nasatuman nanda nga sanda anang ginatomod sa anang paanggid nga dato. Garing ginaadlukan sanda sa mga tao. ");
INSERT INTO clu_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Gani andang ginimo, nagulat sanda nga may kaigayonan. Nagpadara sanda mga ispia nga nagpakono-kono nga osto andang katoyoan, agud kon may makita sanda nga sala sa anang ambal iakosar nanda tana dayon sa gobirnador. ");
INSERT INTO clu_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Nagpamangkot ang mga tao nga dato kay Jesus, makon nanda, “Maistro, naulaman namun nga osto imong ginaambal kag ginatodlo, kag ara kaw may ginapasolabi bisan sino kondi kon ano anang kabubutun ang Dios sa tao maman gid imong ginatodlo. ");
INSERT INTO clu_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Abi, kon sa kanimo, osto bala nga kita bilang mga Judio magbayad ang bois sa Impirador ang Roma okon indi?” ");
INSERT INTO clu_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Piro naulaman tana ni Jesus andang paito nga dato, gani ginsabat na sanda, makon na, ");
INSERT INTO clu_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Abi pasulunga nindo ako ang koarta. Kinong itsora kag aran ang nagabutang digi?” Makon nanda, “Ana ang Impirador.” ");
INSERT INTO clu_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Gani ginsabat sanda ni Jesus, makon na, “Ta kondi itaw nindo sa Impirador ang ana ang Impirador kag itaw nindo ra sa Dios ang ana ang Dios.” ");
INSERT INTO clu_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Gani sa atobangan ang tanan ara sanda gid kadakup kanana sa anang ambal. Kag tungud nga natingala sanda nga mayad sa anang sabat ni Jesus, nagipus sanda run lang. ");
INSERT INTO clu_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","May mga Saduseo ra nga nagparapit kay Jesus. Dia nga mga tao ara nagapati nga ang mga tao mababanaw. ");
INSERT INTO clu_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Makon nanda, “Maistro, si Moises nagsolat kanatun nga kon mapatay ang lalaki nga ara pa nakapabata sa anang asawa, dapat anang kabogto roman ang mapangasawa sa anang asawa nga nabalo agud makapabata tana para sa anang kabogto. ");
INSERT INTO clu_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Karon, may pito ka magkarabogto nga lalaki. Ang panganay nagpangasawa kag napatay nga ara nakapabata. ");
INSERT INTO clu_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Gani anang asawa nga nabalo ginpangasawa ang madason nga kabogto ang napatay. Piro napatay tana ra nga ara nakapabata sa babai nga dato. ");
INSERT INTO clu_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Toladan ra ang natabo sa ikatlo nga kabogto, asta pa sa ikapito. Nagkarapatay sanda tanan nga ara gid kapabata. ");
INSERT INTO clu_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ang ori ang babai napatay ra. ");
INSERT INTO clu_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ta, kon magabot ron ang pagkabanaw, kino tana nga asawa, ay sanda nga pito naging asawa na?” ");
INSERT INTO clu_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ginsabat sanda ni Jesus, makon na, “Sa tyimpo nga dia nagaarasawa ang mga tao. ");
INSERT INTO clu_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Piro ang bisan sino tana nga sono sa Dios bagay banawon kag daraun doto sa isarang kinaboi ara run nagaarasawa. ");
INSERT INTO clu_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Indi sanda run gid mapatay tungud nga maging pario sanda run sa mga angil; mga bata sanda gani ang Dios, ay ginbanaw na sanda. ");
INSERT INTO clu_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Kon parti sa pagbanaw ang mga patay, ginpamatodan dia ni Moises sa anang ginambal doto sa nagadabadaba nga palongpong. Kabay gintawag na ang Ginoo nga ‘anang Dios ni Abraham, ni Isaac, kag ni Jacob.’ ");
INSERT INTO clu_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Dia nagakaologan nga bisan boay sanda run nga napatay, boi sanda pa ra gid, ay ang Dios bukun Dios ang mga patay, kondi Dios tana ang mga boi. Kon sa Dios, ang tanan boi pa ra gid.” ");
INSERT INTO clu_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Makon ang iba nga mga manogtodlo ang Kasogoan, “Maistro, tama imong sabat nga dan.” ");
INSERT INTO clu_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Kag ara run may nagpangas pa nga magpamangkot kanana. ");
INSERT INTO clu_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Karon, nagpamangkot si Jesus sa mga tao, makon na, “Basi nagakoon sanda nga ang Cristo anang kaliwat ni David? ");
INSERT INTO clu_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ay si David mismo nagkoon sa Libro ang mga Salmos nga, ‘Ang Ginoo nagkoon sa akun Ginoo, Pagpongko digi sa akun too, ");
INSERT INTO clu_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Asta mapasoko ko kanimo imong mga kaaway.’ ");
INSERT INTO clu_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ta kon gintawag na tana nga Ginoo, paiwan nga tana anang kaliwat lang gid ni David?” ");
INSERT INTO clu_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Mintras nagapamati ang mga tao kay Jesus, nagkoon tana sa anang mga somolonod, makon na, ");
INSERT INTO clu_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Magandam kamo sa mga manogtodlo ang Kasogoan nga gosto maglagaw nga nagasoksok ang malabug nga lambong. Kag kon sa mga logar nga ginatiriponan ang mga tao, gosto nanda gid nga taodon sanda. Kon sa mga simbaan okon sa mga ponsyon ginapili nanda gid ang porongkoan nga para sa mga dungganun nga tao. ");
INSERT INTO clu_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ginaobos nanda buul anang mga pagkabutang ang mga balo nga babai, kag ginatabon-tabonan nanda lang andang ginaimo paagi sa andang malawig nga mga pangadi. Mas mabaul nga silot andang babatonon.” ");
INSERT INTO clu_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ang ori nagpanulung-sulung si Jesus kag nakita na ang mga manggaranun nga nagabutang andang koarta sa ginaologan ang mga alad. ");
INSERT INTO clu_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Kag nakita na ra ang balo nga babai nga pobri gid nga nagolog darwa lang ka sinsilyo nga maistan anang kantidad. ");
INSERT INTO clu_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Makon dayon ni Jesus, “Sa matood tana, sa panulung ang Dios mas doro anang ginolog ang pobri nga balo kaysa kananda nga tanan. ");
INSERT INTO clu_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ay sanda nagtaw tungud nga abonda sanda; piro tana tana, bisan masyado ka lisud anang kaimtangan gintaw na tanan anang pangaboian.” ");
INSERT INTO clu_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","May mga tao doto nga nagasorogidanun parti sa mga mabaraul nga mga bato kag sa mga ginrigalo ang mga tao nga gingamit sa pagpasadya ang timplo. Piro nagkoon si Jesus kananda, makon na, ");
INSERT INTO clu_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Magaabot ang adlaw nga ang mga butang nga dan nga indong nakikita dadi magakararompag kag ara gid may mabilin nga mga bato nga nagakamada.” ");
INSERT INTO clu_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Nagpamangkot sanda kay Jesus, makon nanda, “Maistro, sano matatabo ang mga butang nga dan? Ano ang mga tanda nga dan nga mga butang madali run lang matabo?” ");
INSERT INTO clu_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Makon ni Jesus kananda, “Magandam kamo nga indi kamo mapatalang ang iba. Ay doro ang magaabot kag kada isara magakoon nga sanda kono ako kag nagabot ron ang oras. Piro indi kamo gid magpati okon magsonod kananda. ");
INSERT INTO clu_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kon makabati kamo nga may mga gira kag mga paggirinamo, indi kamo magpakulba, ay dan tana kinanglan nga matabo anay, piro ara nagakaologan nga magaabot ron nga lagi anang kataposan ang kalibotan.” ");
INSERT INTO clu_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Kag makon pa gid ni Jesus kananda, “Magaaraway ang mga nasyon kag magaaraway ang mga ginarian. ");
INSERT INTO clu_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","May magaabot nga mga linog nga mabaraskug kag may mga gutum kag mga pisti nga magaabot sa mga tao sa iba-iba nga mga logar. Kag may makikita kamo ra nga mga kaaradluk kag makatiringala nga mga tanda alin sa langit. ");
INSERT INTO clu_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Piro bago magkaratabo dan dadakupun kamo kag ingaboton ang mga tao. Dadaraun nanda kamo sa mga simbaan ang mga Judio agud sintinsyaan kag ipapriso dayon. Dadaraun nanda kamo ra sa mga ari kag mga gobirnador agud imbistigarun kamo. Dia tanan imoon nanda kanindo tungud sa indong pagsonod kanakun. ");
INSERT INTO clu_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Piro dia maging kaigayonan para kanindo agud sogidan nindo sanda ang Mayad nga Barita parti kanakun. ");
INSERT INTO clu_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Gani pagdisisyon kamo nga lagi nga kon matabo dato indi kamo magpalibug kon ano indong isabat, ");
INSERT INTO clu_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ay ako tana ang magataw kanindo kaaram kag inogsabat agud indi gid makasabat kontra kanindo indong mga kakontra. ");
INSERT INTO clu_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ang iba kanindo iakosar mismo indong mga ginikanan, indong mga kabogto, indong mga paryinti, kag indong mga amigo, kag ang iba kanindo patayun nanda gid gani. ");
INSERT INTO clu_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Dumutan kamo ang tanan tungud nga kamo akun mga somolonod. ");
INSERT INTO clu_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Piro indi kamo gid maiwan, ");
INSERT INTO clu_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","ay kon magpadayon kamo sa indong pagtoo kanakun makaangkun kamo kaboi nga ara kataposan.” ");
INSERT INTO clu_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Kon makita nindo nga ang Jerusalem ginasirkolo ron ang mga soldado, dan maulaman nindo nga madali run lang nga gubaun. ");
INSERT INTO clu_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Gani ang mga nagaoli sa Judea dapat magparalagyaw ron sa kabokidan. Kag ang mga sa siodad ang Jerusalem magparalagyaw ron da. Ang mga tao sa bokid dapat indi magsulud sa Jerusalem. ");
INSERT INTO clu_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ay maman run dan ang mga adlaw nga silotan ang Dios ang mga tao doto agud matoman anang ginakoon ang Kasolatan. ");
INSERT INTO clu_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Sa mga adlaw nga dato kailo ra ang mga nagaburudus kag ang mga nagaparatiti tungud nga malilisudan sanda sa pagpalagyaw. Mabaul nga kalisud ang magaabot sa logar nga dia ay mabaul anang kaugut ang Dios sa mga tao digi. ");
INSERT INTO clu_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ang iba kananda magakarapatay sa gira, kag ang iba dadakupun kag daraun sa iba-ibang mga nasyon. Kag anang siodad nga dia ang Jerusalem gugubaun kag dodomaraan ang mga bukun Judio mintras ginatogotan pa ang Dios.” ");
INSERT INTO clu_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Matatabo ra nga may mga tanda nga makikita sa adlaw, sa bolan, kag sa mga bitoon. Digi sa logta kukulbaan nga mayad ang mga tao tungud sa mabaraul nga mga daloyon nga nagaralagomba. ");
INSERT INTO clu_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Magakaradismayo ang mga tao sa kaadluk sa kon ano ang matatabo sa kalibotan nga dia, ay ang mga butang nga sa langit patalangun sa andang dati nga aragian. ");
INSERT INTO clu_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Sa oras nga dato, Ako nga Naging Tao makikita sa mga panganod nga nagabalik run digi sa kalibotan nga may gaum kag nagalanyag nga mayad. ");
INSERT INTO clu_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Kon ang mga butang nga dia magompisa run nga magkaratabo, indi kamo magkaadluk ay madali run lang gid ang paglowas kanindo.” ");
INSERT INTO clu_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Kag ginsogidan sanda dayon ni Jesus ang paanggid. Makon na, “Sulunga nindo bala ang kaoy nga igira, kag ang iba pa nga mga kaoy. ");
INSERT INTO clu_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Kabay kon makita ta nga nagapangogbos ron nagakoon kita nga madali run lang ang tigirinit. ");
INSERT INTO clu_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Dan toladan ra, kon makita nindo nga nagakaratabo ron ang mga butang nga dia nga akun ginasogid kanindo, maulaman nindo nga marapit run anang pagari ang Dios. ");
INSERT INTO clu_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Sa matood tana, dia tanan nga mga butang magakaratoman gid bago magkaradora ang mga tao nga dia sa dadi. ");
INSERT INTO clu_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Madodora ang langit kag ang logta, piro akun mga ambal indi gid maimo nga indi matoman.” ");
INSERT INTO clu_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Gani bantayan nindo indong kaogalingun nga indi kamo mawili sa pabasta-basta nga pagpangaboi, sa pagpalingin, kag sa pagpalibug sa indong pagpangaboi, ay basi kon golpi lang magabot ang adlaw nga dato nga ara kamo kapriparar, nga midyo sa nasiud kamo. ");
INSERT INTO clu_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ay dia tana golpi lang nga maabot sa tanan nga nagaoli digi sa kalibotan. ");
INSERT INTO clu_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Gani maging alisto kamo pirmi kag magpangamoyo nga kon matabo ron ang tanan nga dia nga mga butang, may kabaskug kamo agud indi kamo maiwan kondi makaatobang kamo Kanakun nga Naging Tao nga indi kamo mauya.” ");
INSERT INTO clu_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Kada adlaw nagayan si Jesus doto sa timplo kag nagtodlo. Kon gabi, nagdayon tana sa Bokid ang mga Olibo. ");
INSERT INTO clu_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Kada aga, dorong tao ang aga pa gid nga nagayan doto sa timplo ay gosto nanda nga magpamati kanana. ");
INSERT INTO clu_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Marapit run lang dato ang Pista ang Tinapay nga ara Pampaabok nga ginatawag ra nga Pista anang Paglubas ang Angil. ");
INSERT INTO clu_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ang mga manogdomara nga mga pari kag ang mga manogtodlo ang Kasogoan nagapangita paagi kon paiwan nanda mapatay si Jesus nga indi magkinagolo, ay naadlukan sanda sa mga tao. ");
INSERT INTO clu_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Nakasulud run dato si Satanas kay Judas nga ginatawag nga Iscariote. Isara tana sa anang dosi ka apostolis ni Jesus. ");
INSERT INTO clu_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Gani nagpanaw tana kag nagpakigkita sa mga manogdomara nga pari kag sa mga opisyalis ang mga goardya sa timplo. Ginambalan nanda kon paiwan na maitogyan kananda si Jesus. ");
INSERT INTO clu_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Nalipay sanda nga mayad kag nagkasogot sanda nga mabayad kanana. ");
INSERT INTO clu_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Kag nagkasogot ra si Judas, kag alin dato nagpangita tana run kaigayonan kon paiwan na maitogyan si Jesus kananda nga indi maulaman ang mga tao. ");
INSERT INTO clu_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Karon, nagabot ron gid ang Pista ang Tinapay nga ara Pampaabok. Maman dia ang adlaw nga ang mga Judio kinanglan nga magalad ang mga karniro nga andang ginakaun para sa Pista anang Paglubas ang Angil. ");
INSERT INTO clu_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Gani ginsogo ni Jesus si Pedro kag si Juan nga magona kag magpriparar andang yapon sa pagsilibrar ang Pista anang Paglubas ang Angil. ");
INSERT INTO clu_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Bago sanda magpanaw nagpamangkot sanda kon diin sanda nga balay mapriparar. ");
INSERT INTO clu_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Makon ni Jesus kananda, “Pagabot nindo sa siodad, may masosoblang kamo nga tao nga nagadara ang banga nga may tobig. Sonodon nindo tana doto sa balay nga anang susuludan. ");
INSERT INTO clu_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Kag toladia indong iambal sa tagbalay, ‘Ang manogtodlo nagapamangkot kon diin ang koarto nga anang kaunan kaiban anang mga somolonod para sa pagsilibrar ang Pista anang Paglubas ang Angil.’ ");
INSERT INTO clu_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ipakita na dayon kanindo ang mawayang nga koarto sa ibabaw nga komplito ron sa kasangkapan. Doto kamo magimus atun yapon.” ");
INSERT INTO clu_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Nagpanaw dayon ang darwa nga anang ginsogo, kag nakita nanda nga kon ano anang ginkoon ni Jesus maman ra gid ang natabo. Kag doto sanda nagpriparar andang yapon para sa pista. ");
INSERT INTO clu_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Pagabot ang oras nga inogyapon ron, nagpongko si Jesus kaiban anang mga apostolis agud magkaun. ");
INSERT INTO clu_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Makon dayon ni Jesus kananda, “Mabaul gid akun andum nga bago ako magantos magkaraiban kita anay sa pagkaun sa pagsilibrar ang Pista anang Paglubas ang Angil. ");
INSERT INTO clu_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ay sa matood tana, indi ako ron magoman kaun dia asta matoman anang matood nga kaologan doto sa anang ginarian ang Dios.” ");
INSERT INTO clu_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Kag nagbuul tana dayon ang irinumun kag ginpasalamatan na sa Dios. Pagkatapos makon na kananda, “Palibotan nindo dia kag maginum kamo tanan. ");
INSERT INTO clu_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Sa matood tana, alin dadi indi ako ron gid maginum ang irinumun nga alin sa obas mintras ara pa nagabot anang ginarian ang Dios.” ");
INSERT INTO clu_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Kag nagbuul tana ang tinapay kag ginpasalamatan na sa Dios. Ginpamisang-pisang na dayon, kag ginpanaw kananda nga nagakoon, makon na, “Maman dia akun lawas nga ginataw para kanindo. Imoa nindo dia bilang andumanan kanakun.” ");
INSERT INTO clu_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Pagkatapos nanda kaun nagbuul tana ruman ang irinumun kag nagkoon, makon na, “Ang irinumun nga dia akun dogo nga iola para kanindo nga nagapapagun sa bago nga Kasogtanan nga ginataw ang Dios. ");
INSERT INTO clu_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Piro pamatii nindo, kaiban ta ra digi sa pagkaun ang tao nga magaintriga kanakun sa akun mga kaaway. ");
INSERT INTO clu_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ay Ako nga Naging Tao mapapatay sono sa anang plano ang Dios, piro kailo ra ang tao nga matraidor kanakun.” ");
INSERT INTO clu_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Pagkabati nanda dato nagompisa sanda run paramangkotan sa isara kag isara kon sino gid kananda ang magaimo dato. ");
INSERT INTO clu_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ang ori nagbarais-baisan sanda ra kon sino gid kananda nga mga apostolis ang pinakaimportanti. ");
INSERT INTO clu_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Gani nagkoon si Jesus kananda, makon na, “Digi sa kalibotan nga dia anang mga ari ang kada banwa nagamandar sa andang mga sakup. Gosto ang mga may awtoridad nga tawagun sanda nga mga ‘manogbolig sa mga tao.’ ");
INSERT INTO clu_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Piro kanindo tana bukun pario dan. Ay kon sino kanindo ang may mataas nga katungdanan sa tanan, tana ang dapat magpaubus. Kag kon sino kanindo ang nagadomara, tana ang dapat magsirbi. ");
INSERT INTO clu_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ay sino sa darwa ang mas importanti, ang nagakaun sa lamisa okon ang nagasirbi? Syimpri mas importanti ang nagakaun sa lamisa. Piro ako tana maman ang nagasirbi kanindo bisan ako indong agalun.” ");
INSERT INTO clu_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Makon ra ni Jesus kananda, “Kamo nagaonong kanakun sa mga pagtiraw nga akun ginaagian. ");
INSERT INTO clu_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Gani kon paiwan nga akun Tatay nagtaw kanakun gaum para magari, kamo tawan ko ra gaum nga magari. ");
INSERT INTO clu_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Magiging kaiban ko kamo sa pagkaun kag paginum sa akun lamisa kon ako magari run. Kamo akun padomaraun kag paukumun sa dosi ka tribo ang Israel.” ");
INSERT INTO clu_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Makon dayon ni Jesus kay Pedro, “Simon, pamati bala! Si Satanas naglisinsya nga tirawan na kamo pario sa arayagun nga anang aayagun. ");
INSERT INTO clu_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Piro ginpangamoyo ko ikaw nga bisan ano ang matabo indi gid madora imong pagtoo kanakun. Kag pagkatapos nga makapanombalik ka run gani, pabaskugun mo anang pagtoo imong mga kabogto.” ");
INSERT INTO clu_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Nagsabat si Pedro, makon na, “Ginoo, priparado ako nga magonong kanimo bisan sa prisoan okon sa kamatayun.” ");
INSERT INTO clu_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Makon ni Jesus kanana, “Pedro sogidan ko ikaw ang matood, bago magtorok ang manok karon katlo mo ako ron ipanginwara nga ara kaw kakilala kanakun.” ");
INSERT INTO clu_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Pagkatapos ginpamangkot ni Jesus anang mga apostolis, makon na, “Pagsogo ko kanindo dato anay nga magpanaw kamo kag magpangwalian, ginkonan ko kamo kabay nga indi kamo magdara koarta, bag, okon sandalyas. Ta ano, ginkolang kamo?” Makon nanda, “Ara gid.” ");
INSERT INTO clu_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","“Piro dadi,” makon ni Jesus, “kon sino ang may kaita okon bag, dapat daraun na. Kag kon sino kanindo ang ara ispada ibaligya na anang lambong kag magbakal dayon ispada. ");
INSERT INTO clu_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ay sa matood tana, dapat matoman anang koon ang Kasolatan parti kanakun nga ‘Ginbilang tana nga isara sa mga kriminal.’ Matotoman gid anang ginakoon nga dia ang Kasolatan tungud nga ang tanan nga nasolat sa Kasolatan parti kanakun nagakaratoman run.” ");
INSERT INTO clu_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Makon anang mga apostolis, “Ginoo, way may darwa ka ispada digi.” Makon ni Jesus kananda, “Ta tama run dan.” ");
INSERT INTO clu_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Pagalin doto ni Jesus nagayan tana sa Bokid ang mga Olibo ay maman run dato anang nakaogalian. Anang mga somolonod nagtabid ra kanana. ");
INSERT INTO clu_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Pagabot nanda doto makon na, “Pagparangamoyo kamo nga indi kamo madaug ang pagsolay.” ");
INSERT INTO clu_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Nagpabulag tana kananda kag nagayan doto sa onaan. Doto tana naglood kag nagpangamoyo. ");
INSERT INTO clu_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Makon na, “Itay, kon gosto mo, ilikaw mo ang pagantos nga nagaabot kanakun. Piro bukun akun gosto ang matoman, kondi ang kanimo.” ");
INSERT INTO clu_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Nagpakita kanana ang angil nga alin sa langit kag ginpabaskug na tana. ");
INSERT INTO clu_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Tungud sa mabaul nga kalisud nga anang ginabatyag, nagpangamoyo tana pa gid nga ugut sa anang tagiposoon, kag anang olas midyo ron sa dogo nga nagatoro sa logta. ");
INSERT INTO clu_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Pagkatapos na pangamoyo nagtindug tana kag nagbalik doto sa anang mga somolonod, kag naabotan na sanda nga nagakaratorog tungud sa kabudlay sa sobra nga kasubu. ");
INSERT INTO clu_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Makon ni Jesus kananda, “Ay dan, basi nagakaratorog kamo? Pagbangon kamo kag magpangamoyo nga indi kamo madaug ang pagsolay.” ");
INSERT INTO clu_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Mintras nagaambal pa si Jesus nagabot ang sangka panung nga mga tao. Si Judas mismo nga isara sa dosi ka apostolis ang nagapangona kananda. Nagparapit si Judas kay Jesus agud arukan tana. ");
INSERT INTO clu_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Makon ni Jesus kanana, “Judas, ay dan, traidoran mo Ako nga Naging Tao paagi sa aruk?” ");
INSERT INTO clu_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Pagkakita anang mga kaiban ni Jesus nga may imoon ron kanana ang mga tao, makon nanda, “Ginoo, panlaboon namun run?” ");
INSERT INTO clu_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Kag isara gani sa anang mga somolonod ni Jesus ang naglabo anang sorogoon ang pinakamataas nga pari kag nautas anang too nga talinga. ");
INSERT INTO clu_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Piro makon ni Jesus kananda, “Tama run dan!” Kag ginbalik dayon ni Jesus anang talinga ang tao nga dato kag ginayad na. ");
INSERT INTO clu_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Makon dayon ni Jesus sa mga manogdomara nga mga pari kag sa mga opisyalis ang mga goardya sa timplo kag sa iba pa nga mga manogdomara ang mga Judio nga nagarayan doto para magdakup kanana, “Basi nagdara kamo pa gid mga ispada kag mga ralampus para magdakup kanakun? Ano ako, tolisan? ");
INSERT INTO clu_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Kabay kada adlaw doto ako sa timplo kag doto kamo ra. Ta basi ara nindo ako nga lagi pagdakupa? Garing maman run dia indong oras nga ginagauman ang madulum okon malain.” ");
INSERT INTO clu_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Gindakup nanda dayon si Jesus kag gindara sa anang balay ang pinakamataas nga pari. Si Pedro tana nagsonod ra, garing marayu lang anang antad. ");
INSERT INTO clu_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Doto sa tunga ang lagwirta nagadabok kalayo ang mga tao kag nagaporongko sa marapit agud magpainit-init. Si Pedro nagparapit ra doto kananda kag nagpongko. ");
INSERT INTO clu_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","May sangka sorogoon nga babai nga nakakita kay Pedro nga nagapongko doto sa may dapong. Ginsulung na nga mayad si Pedro, kag makon na dayon, “Ang tao nga dia anang kaiban ra ang tao nga dato nga si Jesus.” ");
INSERT INTO clu_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Garing nagpanginwara si Pedro, makon na, “Ara ako kakilala kanana.” ");
INSERT INTO clu_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Malagat-lagat may nakakita kanana nga lalaki nga nagkoon, makon na, “Ikaw isara ra gid sa anang mga kaiban.” Piro makon ni Pedro nga nagsabat, “Ikaw nga tao kaw, bukun ako anang kaiban.” ");
INSERT INTO clu_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Pagkalubas mga saka oras may doto roman nga nagkoon, makon na, “Matood ra gid nga ang tao nga dia isara sa anang mga kaiban ang tao nga dato ay tana taga-Galilea ra.” ");
INSERT INTO clu_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Piro makon roman ni Pedro, “Wi ang tao nga dia, ilam kanimo, ara ako baya kaulam imong ginaambal nga dan.” Kag mintras nagaambal pa si Pedro, tomorook ang manok. ");
INSERT INTO clu_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ginbalikid tana ang Ginoo kag ginsulung nga mayad. Kag nadumduman dayon ni Pedro anang ginaambal ang Ginoo nga bago magtorok ang manok, katlo na tana ipanginwara. ");
INSERT INTO clu_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Gani naggoa si Pedro kag nagpanangis nga mayad. ");
INSERT INTO clu_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Si Jesus tana gintoya-toya kag ginanot ang mga tao nga nagagoardya kanana. ");
INSERT INTO clu_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ginpudungan nanda ra anang mata, kag pagkatapos ginpamangkot nanda, makon, “Kabay propita kaw? Ta abi sogidi kami kon sino ang nagsampal kanimo.” ");
INSERT INTO clu_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Kag doro pa gid andang ginapangambal nga malain kontra kanana. ");
INSERT INTO clu_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Pagkaaga nagtiripon anang mga maulam-ulam ang mga Judio. Ang iba kananda mga manogdomara nga mga pari, kag ang iba mga manogtodlo ang Kasogoan. Gindara nanda si Jesus doto sa andang ginatiriponan. ");
INSERT INTO clu_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Makon nanda kay Jesus, “Abi sogidi kami kon ikaw manda ang Cristo.” Makon anang sabat, “Bisan sogidan ko kamo indi kamo ra gid magpati. ");
INSERT INTO clu_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Kag kon may pamangkot ako kanindo indi kamo ra magsabat. ");
INSERT INTO clu_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Piro alin dadi Ako nga Naging Tao magapongko ron sa anang too ang makagagaum nga Dios.” ");
INSERT INTO clu_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Makon nanda tanan, “Kon toladan, ikaw gali anang Bata ang Dios.” Nagsabat si Jesus, makon na, “Ta kamo mismo ang nagambal.” ");
INSERT INTO clu_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Gani makon nanda, “Ta ano pa gid nga mga ibidinsya atun kinanglan? Kita run mismo ang nakabati anang ginambal.” ");
INSERT INTO clu_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Pagkatapos dato nagtirindug sanda tanan kag gindara nanda si Jesus doto kay Pilato. ");
INSERT INTO clu_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Pagabot nanda doto ginsogidan nanda si Pilato kon ano andang mga bintang kontra kay Jesus. Makon nanda, “Dia nga tao nadakupan namun nga nagapatalang amun kasimanwa nga mga Judio ay ginakonan na sanda nga indi magbayad bois sa Impirador, kag nagakoon tana pa nga tana kono ang Cristo. Anang gostong ambalun tana ang ari.” ");
INSERT INTO clu_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Gani ginpamangkot tana ni Pilato. Makon na, “Ikaw gali anang ari ang mga Judio?” Makon ni Jesus kanana, “Ginambal mo.” ");
INSERT INTO clu_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pagkatapos makon ni Pilato sa mga manogdomara nga pari kag sa mga tao, “Ara ako sala nga nakita sa tao nga dia para silotan tana.” ");
INSERT INTO clu_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Piro nagapirit sanda gid nga nagakoon, makon nanda, “Nagadara tana golo sa mga tao sa bilog nga Judea paagi sa anang mga panodlo, alin sa probinsya ang Galilea asta digi sa siodad ang Jerusalem.” ");
INSERT INTO clu_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pagkabati dato ni Pilato, nagpamangkot tana kon taga-Galilea si Jesus. ");
INSERT INTO clu_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Kag pagkaulam na nga si Jesus alin sa logar nga ginadomaraan ni Herodes, ginpadara na si Jesus kanana, ay sa oras nga dato doto ra si Herodes sa Jerusalem. ");
INSERT INTO clu_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Pagkakita ni Herodes kay Jesus nalipay tana nga mayad, ay boay run anang andum nga makita si Jesus tungud nga doro ron anang nabatian parti kanana kag gosto na nga magimo tana milagro agud makita na. ");
INSERT INTO clu_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Doro anang mga pamangkot ni Herodes kay Jesus, garing ara tana gid magsabat. ");
INSERT INTO clu_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ang mga manogdomara tana nga pari kag ang mga manogtodlo ang Kasogoan nagatirindug doto kag kon ano-ano ron andang mga ginabintang kay Jesus. ");
INSERT INTO clu_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Anang ginimo ni Herodes kag anang mga goardya, ginmolay nanda kag ginpakauyan si Jesus. Ginpasoksokan nanda tana ang lambong nga masadya kag ginpabalik doto kay Pilato. ");
INSERT INTO clu_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Sa adlaw nga dato naging magamigo si Pilato kag si Herodes. Dati nagakontraan sanda. ");
INSERT INTO clu_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ginpatawag ni Pilato ang mga manogdomara nga pari kag ang mga manogdomara ang banwa pati ang mga tao mismo. ");
INSERT INTO clu_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Makon na dayon kananda, “Gindara nindo digi kanakun ang tao nga dia nga makon kamo nagapatalang sa mga tao. Piro sono sa akun pagosisa, kag digi kamo ra, ara ako gid may nakita nga sala kanana nga pario indong ginabintang. ");
INSERT INTO clu_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Bisan si Herodes gani ara ra may nakita nga sala sa tao nga dia. Maman dan nga ginpabalik na tana digi. Ara tana gid may ginimo nga nababagay nga sintinsyaan nga patayun. ");
INSERT INTO clu_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Gani ipaanot ko tana run lang kag pagkatapos pabolyawan.”  ");
INSERT INTO clu_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ay kada magpista ang Pista anang Paglubas ang Angil ginabolyawan gid ni Pilato ang sangka priso. ");
INSERT INTO clu_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Piro nagsiringgit ang mga tao, makon nanda, “Patayun ang tao nga dan! Si Barrabas imong bolyawan!” ");
INSERT INTO clu_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Si Barrabas nga dia napriso ra tungud nga kaiban tana ang pagkinagolo sa Jerusalem kag nakapatay tana pa.) ");
INSERT INTO clu_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Gosto andan ni Pilato nga malibri si Jesus, gani ginambalan na pa gid ang mga tao. ");
INSERT INTO clu_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Piro sigi anang siringgit ang mga tao nga “Ilansang tana sa kros! Ilansang tana sa kros!” ");
INSERT INTO clu_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Sa ikatlo nga pagambal ni Pilato kananda, makon na, “Ay basi, ano gid nga sala anang naimo? Ara ako gid may nakita nga sala agud ipapatay tana. Ipaanot ko tana run lang kag pabolyawan ko dayon.” ");
INSERT INTO clu_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Piro sigi pa gid andang parugus nga nagasiringgit nga ilansang tana sa kros. Kag ang ori nagdaug sanda ra gid. ");
INSERT INTO clu_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ay ginpasonodan run lang ni Pilato anang gosto ang mga tao nga ilansang si Jesus sa kros. ");
INSERT INTO clu_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ginbolyawan na ang tao nga napriso tungud sa anang pagintra sa pagpanggolo sa gobyirno kag pagpatay, ay maman andang ginpangayo. Piro si Jesus tana ginintriga na kananda agud imoon nanda andang gosto nga imoon kanana. ");
INSERT INTO clu_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Pagdara nanda kay Jesus sa logar nga lansangan kanana, may nasoblang sanda nga tao nga si Simon nga taga-Cirene. Bago tana lang nagapasulud sa siodad alin sa bokid. Ginawidan nanda tana, kag ginpapasan nanda ang kros, kag ginpasonod kay Jesus. ");
INSERT INTO clu_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Doro nga mga tao ang nagsoronod kay Jesus. May mga babai doto nga nagaparanangis kag nagatiriabaw tungud nga nalooy sanda kay Jesus. ");
INSERT INTO clu_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Piro ginbalikid sanda ni Jesus kag ginkonan, makon na, “Kamo nga mga babai nga taga-Jerusalem, indi kamo magpanangis tungud kanakun. Tangisi nindo indong kaogalingun kag indong mga bata. ");
INSERT INTO clu_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Tungud nga magaabot ang adlaw nga magakoon ang mga tao nga, ‘Masoirti ang mga babai nga bawas kag ara may ginapatiti.’ ");
INSERT INTO clu_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Sa adlaw nga dato magakoon ang mga tao sa mga bokid nga ‘Timpai kami!’ kag sa mga banggilid nga ‘Taboni kami!’ ");
INSERT INTO clu_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ay kon toladia andang ginaimo kanakun nga ako gani ara sala, ta kondi mas malain gid andang imoon sa tao nga may sala.” ");
INSERT INTO clu_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Loas kay Jesus may darwa pa gid ka tao nga mga kriminal nga andang gindara agud patayun. ");
INSERT INTO clu_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Pagabot nanda sa logar nga ginatawag nga Bongo, ginlansang nanda si Jesus sa kros, pati ang darwa ka kriminal. Ang isara ginbutang nanda sa too kampi ni Jesus kag ang isara sa wala.  ");
INSERT INTO clu_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Makon ni Jesus, “Itay, patawada sanda ay ara sanda kaulam kon ano andang ginaimo.” Kag naggarabot-gabot ang mga soldado agud parti-partiun anang mga lambong ni Jesus. ");
INSERT INTO clu_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ang mga tao nagatirindug doto nga nagasulung. Anang mga manogdomara tana ang mga Judio nagyagota kanana; makon nanda, “Ginlowas na ang iba, kondi lowasun na ra anang kaogalingun kon tana manda ang Cristo nga anang pinili ang Dios.” ");
INSERT INTO clu_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Pati ang mga soldado nagyagota ra kanana mintras nagaparapit agud painumun tana ang maaslum nga bino. ");
INSERT INTO clu_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Makon nanda, “Ta kon ikaw manda anang Ari ang mga Judio, lowasa run imong kaogalingun!” ");
INSERT INTO clu_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Kag may ginbutang sanda nga karatola doto sa anang oloan nga nagakoon, “Maman dia anang Ari ang mga Judio.” ");
INSERT INTO clu_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ang isara sa mga kriminal nga nakalansang sa kros nagpasipala ra kay Jesus. Makon na, “Indi bala nga ikaw ang Cristo? Ta lowasa run imong kaogalingun kag pati kami!” ");
INSERT INTO clu_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Piro ginsaway tana ang isara nga kriminal nga nagakoon, makon na, “Oy, ara kaw naadluki sa Dios? Parario kita nga ginasilotan, ");
INSERT INTO clu_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","piro kita nga darwa dapat ra gid nga silotan tungud sa atun ginpangimo nga sala. Piro ang tao tana nga dia ara gid may naimo nga sala.” ");
INSERT INTO clu_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Pagkatapos makon na dayon kay Jesus, “Jesus, dumduma ako ra kon ikaw magari run!” ");
INSERT INTO clu_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Makon ni Jesus kanana, “Sa matood tana, sa adlaw nga dia makakaiban ta kaw sa Paraiso.” ");
INSERT INTO clu_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Datong mga alas dosi run ara run nagsirak ang adlaw kag nagdulum ang bilog nga kalibotan sa sulud tatlo ka oras. Kag anang kortina ang timplo nagisak alin sa ibabaw paidalum. ");
INSERT INTO clu_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Nagsinggit dayon si Jesus, makon na, “Itay, ginatogyan ko kanimo akun ispirito!” Pagkaambal na dato nabogto anang ginawa. ");
INSERT INTO clu_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Pagkakita anang kapitan ang mga soldado sa natabo nagdayaw tana sa Dios nga nagakoon, “Matood ra gid nga ara sala ang tao nga dia!” ");
INSERT INTO clu_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Pagkakita ang mga tao nga nagasurulung doto sa nagakaratabo nagoroli sanda nga nagapulpug andang dugan tungud sa kasubu. ");
INSERT INTO clu_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ang mga nakakilala kay Jesus pati ang mga babai nga nagtarawas kanana alin pa sa Galilea doto nagtirindug sa marayu-rayu kag nakita nanda ra ang nagkaratabo. ");
INSERT INTO clu_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Karon, may tao nga anang aran si Jose nga alin sa Arimatea sa probinsya ang Judea. Isara tana sa anang mga opisyalis ang mga Judio, piro ara tana nagkompormi sa andang ginimo nga pagpapatay kay Jesus. Mayad tana nga tao kag matarung, kag nagaulat tana sa anang pagari ang Dios. ");
INSERT INTO clu_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Nagayan tana kay Pilato kag ginpangayo na anang bangkay ni Jesus. ");
INSERT INTO clu_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Pagkatapos gintangtang na anang bangkay ni Jesus doto sa kros kag ginpotos na ang poti nga tila. Pagkatapos, ginsulud na dayon sa rulubungan. Ang rulubungan nga dato gingoab sa bato kag ara pa gid malubungi. ");
INSERT INTO clu_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Biyirnis dato kag inogpriparar para sa Adlaw nga Inogpaway, nga maompisa run pagkasalup ang adlaw. ");
INSERT INTO clu_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ang mga babai nga nagtarabid kay Jesus alin sa Galilea nagsonod kay Jose kag nakita nanda gid ang ginlubungan kag kon paiwan ang pagkabutang anang bangkay ni Jesus. ");
INSERT INTO clu_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Pagkatapos nagoroli sanda kag nagpriparar ang sari-sari nga mga paamot nga inoglugud sa anang bangkay ni Jesus. Piro sa Adlaw nga Inogpaway, nagpaway sanda sono sa Kasogoan. ");
INSERT INTO clu_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Aga pa gid ang primiro nga adlaw ang simana, ang mga babai nagayan doto sa ginlubungan kay Jesus nga nagadara andang ginpriparar nga paamot. ");
INSERT INTO clu_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Pagabot nanda doto, nakita nanda nga ang bato nga pinakatakup ang rulubungan ginpaligid run. ");
INSERT INTO clu_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Nagsulud sanda, piro ara nanda nakita anang bangkay ni Ginoong Jesus. ");
INSERT INTO clu_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Mintras nagapalibug sanda kon ano ang natabo, golpi lang nga may nagtindug nga darwa ka lalaki doto sa andang marapit. Anang lambong ang mga lalaki nga dato masyado ka solaw. ");
INSERT INTO clu_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ginpangadlukan ang mga babai. Gani nagdorongok sanda run lang. Piro makon ang darwa, “Basi ginapangita nindo ang boi digi sa mga patay? Ara tana run digi. Nabanaw tana run! ");
INSERT INTO clu_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Kabay nagkoon tana nga lagi kanindo ang doto tana pa sa Galilea, ");
INSERT INTO clu_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","nga Tana nga Naging Tao dapat itogyan sa mga makasasala kag ilansang sa kros, piro sa ikatlo ka adlaw mabanaw tana.” ");
INSERT INTO clu_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Kag nadumduman ang mga babai anang ginambal ni Jesus. ");
INSERT INTO clu_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Gani nagoroli sanda kag ginsogidan nanda anang onsi ka apostolis kag ang iba pa nga mga somolonod. ");
INSERT INTO clu_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ang mga babai nga nagsogid sa mga apostolis sanday Maria nga taga-Magdala, si Juana, si Maria nga nanay ni Santiago, kag ang iba pa gid nga mga babai. ");
INSERT INTO clu_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Piro ara sanda nagpati ay andang pagsarig, oroistoria lang dato ang mga babai. ");
INSERT INTO clu_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Piro si Pedro tana nagdalagan paayan sa rulubungan. Pagabot na doto nagkuub tana kag naglingling, kag nakita na nga ang mga panaptun nga ginpotos kay Jesus maman run lang ang doto. Gani nagoli tana nga natitingala kon ano gid ang natabo. ");
INSERT INTO clu_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ang adlaw ra nga dato may darwa ka somolonod ni Jesus nga nagapanaw paayan sa Emaus. Dia nga bario mga onsi ka kilomitro alin sa Jerusalem. ");
INSERT INTO clu_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Kag mintras nagapanaw sanda, nagaistorian sanda parti sa mga nagkaratabo doto sa Jerusalem. ");
INSERT INTO clu_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Mintras nagasogidanun sanda kag nagabaisan parti sa mga butang nga dato nagparapit kananda si Jesus kag nagtawas. ");
INSERT INTO clu_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ara sanda kakilala kanana tungud nga midyo sa ginpakorapkorap andang mga panulung. ");
INSERT INTO clu_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Makon ni Jesus kananda, “Ano indong ginakointoan mintras nagapanaw kamo?” Nagtadung ang darwa kag andang oyaun nagapakita nga borido sanda gid. ");
INSERT INTO clu_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ang isara kananda nga anang aran si Cleopas nagsabat, “Ikaw lang sigoro ang nagadayon sa Jerusalem nga ara kaulam kon ano ang mga nagkaratabo doto ang pira nga dia ka adlaw.” ");
INSERT INTO clu_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Nagpamangkot si Jesus, makon na, “Ay basi ano ang natabo?” Makon ang darwa, “Ang natabo bala kay Jesus nga taga-Nazaret. Naging makagagaum tana nga propita sa panulung ang Dios kag sa mga tao paagi sa anang mga panodlo kag mga inimoan nga gamanan. ");
INSERT INTO clu_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ginakosar tana atun mga manogdomara nga mga pari kag ang iba pa gid nga mga manogdomara agud sintinsyaan tana nga patayun. Kag ginlansang nanda tana gani sa kros. ");
INSERT INTO clu_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Amun pagsarig paman, tana run amun ginaulat nga magabawi atun nasyon nga Israel sa anang alima ang mga taga-Roma. Garing ikatlo ron dia dadi ka adlaw nga tana ginpatay. ");
INSERT INTO clu_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Piro ang katingalaan pa gid, ginsogidan kami amun mga kaiban nga mga babai nga kainang aga timprano sanda pa gid doto sa ginlubungan, ");
INSERT INTO clu_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","piro ara nanda run doto makita anang bangkay. Kag pagbalik nanda doto kanamun ginsogidan nanda kami nga may nakita sanda nga angil nga nagkoon kananda nga boi si Jesus. ");
INSERT INTO clu_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ang iba namun nga mga kaiban nagayan gid doto sa ginlubungan, kag nakita nanda nga tama ra gid anang ginsogid ang mga babai. Piro si Jesus ara nanda nakita doto.” ");
INSERT INTO clu_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Makon dayon ni Jesus kananda, “Balingag manda indong mga isip! Ay basi ara nindo nga lagi pagpatia ang tanan nga ginambal ang mga propita! ");
INSERT INTO clu_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Indi bala nga kinanglan ra gid nga ang Cristo magantos anay ang mga butang nga dia bago tana padungugan ang Dios?” ");
INSERT INTO clu_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Kag ginpasanag kananda ni Jesus ang tanan nga ginakoon ang Kasolatan parti kanana, ompisa sa anang mga ginsolat ni Moises asta sa anang ginsolat ang mga propita. ");
INSERT INTO clu_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Pagabot nanda sa bario nga andang ginapaayanan, midyo ginpakita ni Jesus nga tana madayon ron lang. ");
INSERT INTO clu_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Piro pirit nanda nga ginawidan. Makon nanda, “Digi ka lang anay kanamun ay sirum run dia. Lagat-lagat madulum run.” Gani nagtabid tana run lang kananda. ");
INSERT INTO clu_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ang sanda nagaporongko ron para magkaun, nagbuul tana ang tinapay kag ginpasalamatan na sa Dios. Pagkatapos, ginpamisang-pisang na dayon kag ginpanawan na sanda. ");
INSERT INTO clu_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Kag bago pa ginpasanag andang mga mata kag nakilala nanda nga si Ginoong Jesus gali dato, garing golpi tana lang dayon nga nadora sa andang panulung. ");
INSERT INTO clu_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Makon nanda, “Maman gali dato nga ang kasadya gid atun nabatyagan mintras ginasaysayan na kita ang Kasolatan doto sa dalan.” ");
INSERT INTO clu_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Lagi-lagi bomalik sanda sa Jerusalem sa oras nga dato kag naabotan nanda ang onsi ka apostolis pati ang iba pa gid nga mga somolonod nga nagatiripon. ");
INSERT INTO clu_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Nagakoon sanda nga “Matood ra gid nga nabanaw ang Ginoo! Nagpakita tana kay Simon.” ");
INSERT INTO clu_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Kag ang darwa nagsogid ra kon ano ang natabo kananda doto sa dalan pa Emaus kag kon paiwan nanda tana nakilala ang tana nagpamisang-pisang run ang tinapay. ");
INSERT INTO clu_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Mintras nagasogid sanda dato, golpi lang nga nagtindug si Jesus doto sa andang tunga kag magkoon, “Kaloyan kamo ang Dios.” ");
INSERT INTO clu_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ginkulbaan sanda kag ginadlukan ay andang pagsarig morto ron andang nakita. ");
INSERT INTO clu_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Piro nagkoon si Jesus kananda, makon na, “Basi nagogoloan kamo? Kag basi nagadoda kamo nga ako dia? ");
INSERT INTO clu_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Sulunga nindo bala akun alima kag akun siki. Kag kaputi nindo ako. Bukun ako morto. Ang morto ara lawas piro ako tana may lawas kag nakikita nindo gani.” ");
INSERT INTO clu_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Kag pagkaambal na dia, ginpakita na kananda anang mga alima kag mga siki. ");
INSERT INTO clu_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Sa andang kalipay kag katingala midyo sa indi sanda pa gid makapati sa andang nakikita. Gani nagpamangkot si Jesus kananda, makon na, “May pagkaun kamo digi?” ");
INSERT INTO clu_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Gintawan nanda tana sangka gurut nga linugub nga isda. ");
INSERT INTO clu_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ginbuul na dato kag ginkaun na dayon mintras nagasulung sanda. ");
INSERT INTO clu_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Pagkatapos dato, makon na kananda, “Maman dia akun ginakoon kanindo ang nagakaraiban kita pa, nga ang tanan nga nasolat parti kanakun sa Kasogoan ni Moises kag sa mga sinolat ang mga propita pati ang sa salmo kinanglan gid nga matoman.” ");
INSERT INTO clu_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Kag ginbokasan dayon ni Jesus andang mga isip agud maangupan nanda ang Kasolatan. ");
INSERT INTO clu_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Makon na kananda, “Ang Kasolatan nagakoon nga ang Cristo kinanglan gid nga magantos kag mapatay dayon, piro mababanaw sa ikatlo ka adlaw. ");
INSERT INTO clu_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Kag kinanglan nga isogid sa bilog nga kalibotan ompisa sa Jerusalem nga tungud kanana patawadun ang Dios ang mga tao nga nagainulsul andang mga sala. ");
INSERT INTO clu_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Kamo ang mga tistigo sa mga butang nga dia. ");
INSERT INTO clu_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ipadara ko kanindo ang Ispirito Santo nga ginpangako akun Tatay. Piro indi kamo anay magalin digi sa Jerusalem mintras ara nindo pa mabaton ang gaum nga maalin sa langit.” ");
INSERT INTO clu_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Pagkatapos dato gindara sanda ni Jesus sa may Betania. Pagabot nanda doto ginalsa na anang alima kag ginbindisyonan na sanda dayon. ");
INSERT INTO clu_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Kag mintras nagabindisyon tana amat-amat tana run nga nagpabulag kananda kag gindara pa-langit. ");
INSERT INTO clu_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ginsimba nanda tana kag pagkatapos malipayun sanda nga nagbalik sa Jerusalem. ");
INSERT INTO clu_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Kag alin dato pirmi sanda run doto sa timplo nga nagadayaw sa Dios.");
INSERT INTO clu_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ang ona pa nga lagi, bago imoon ang kalibotan, dian run ang ginatawag nga Ambal ang Dios. Ang Ambal nga dato kaiban ang Dios, kag ang Ambal Dios mismo. ");
INSERT INTO clu_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Kaiban tana nga lagi ang Dios alin pa ang ona. ");
INSERT INTO clu_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Paagi kanana ang tanan nga mga butang ginimo, kag ara gid may naimo nga bukun paagi kanana. ");
INSERT INTO clu_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ang Ambal nga dato maman anang ginaalinan ang kaboi nga ara kataposan. Kag dia nga kaboi pario sa solo tungud nga maman dia ang nagapasanag sa isip ang mga tao nga naduluman. ");
INSERT INTO clu_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ang solo nga dato nagasanag sa kalibotan nga naduduluman tungud sa sala, kag anang sanag ara nadaug ang dulum. ");
INSERT INTO clu_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Karon may tao nga ginpadara ang Dios. Anang aran ang tao nga dato si Juan. ");
INSERT INTO clu_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ginpadara tana ang Dios para magpamarita sa mga tao nga si Jesu-Cristo maman ang matood nga solo, agud paagi sa anang pagbarita makatoo ang tanan nga mga tao. ");
INSERT INTO clu_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Bukun si Juan ang solo, kondi nagabot tana agud pamatodan kon sino ang solo. ");
INSERT INTO clu_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Si Jesu-Cristo maman ang matood nga solo nga sa oras nga dato nagabot digi sa kalibotan kag dadi nagataw kasanag sa anang mga isip ang mga tao. ");
INSERT INTO clu_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Nagabot tana matood digi sa kalibotan. Kag bisan pa nga ang kalibotan ginimo paagi kanana, ang mga tao digi sa kalibotan ara kakilala kanana. ");
INSERT INTO clu_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Nagayan tana sa anang mga kasimanwa mismo, piro ang kalabanan sa anang mga kasimanwa ara nagbaton kanana. ");
INSERT INTO clu_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Piro ang bisan sino nga nagbaton kag nagtoo kanana gintawan na podir nga maging bata ang Dios. ");
INSERT INTO clu_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Naging mga bata sanda ang Dios bukun paagi sa lawasnun nga pagkabata okon pagbuut ang tao, kondi paagi sa anang pagbuut ang Dios. ");
INSERT INTO clu_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Karon, ang ginatawag nga Ambal ang Dios nagpakatao kag nagpakigdapun digi kanatun. Nakita namun anang mataas nga katungdanan bilang anang bogtong nga Bata ang Amay. Maloloyon tana gid kag poros kamatoodan anang ginasogid. ");
INSERT INTO clu_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Si Juan nagpamatood parti kay Jesu-Cristo. Makon na, “Tana maman akun ginakoon kanindo nga magaabot nga ori kanakun piro mas mataas anang katungdanan kaysa kanakun, ay bago ako natao, dian tana run nga lagi.” ");
INSERT INTO clu_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Tungud nga abonda anang gogma ni Cristo, anang mga kalooy kanatun nga tanan nagadarason-dason. ");
INSERT INTO clu_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ang Kasogoan gintaw ang Dios kanatun paagi kay Moises, piro ang kalooy kag kamatoodan nagabot kanatun paagi kay Jesu-Cristo. ");
INSERT INTO clu_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ara gid tao nga nakakita sa Dios nga Amay. Piro ginpakilala tana kanatun ang bogtong nga Bata nga Dios nga kaiban pirmi ang Amay. ");
INSERT INTO clu_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Anang mga manogdomara ang mga Judio sa Jerusalem nagsogo sa mga pari kag mga manogasikaso sa timplo nga ginatawag nga mga Levita nga ayanan nanda si Juan kag pamangkoton kon sino tana. ");
INSERT INTO clu_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ginprangka sanda ni Juan, makon na, “Bukun ako ang Cristo nga indong ginaulat.” ");
INSERT INTO clu_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Makon nanda, “Ta kon bukun kaw ang Cristo, sino kaw? Si Elias nga propita?” Makon ni Juan, “Bukun ako si Elias.” Gani makon nanda ruman, “Sigoro ikaw ang ginakoon nga propita nga maabot?” Piro nagkoon roman si Juan nga bukun tana ra ang propita nga dato nga andang ginakoon. ");
INSERT INTO clu_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Gani makon nanda, “Ta sogidi kami kon sino kaw agud may isogid kami sa mga nagsogo kanamun. Ano imong maisogid parti sa imong kaogalingun?” ");
INSERT INTO clu_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Makon ni Juan, “Ako ang tao nga gintagna ni Isaias nga propita. Kabay makon na, ‘May magawali sa mga tao sa logar nga ara ginaolii ang tao, kag anang wali maman dia: Ipriparar nindo ang dalan ay maabot ang Ginoo!’” ");
INSERT INTO clu_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ang mga nagsogo gali sa mga tao nga dato nga magayan kay Juan ara iba kondi ang mga Pariseo. ");
INSERT INTO clu_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ginpamangkot pa gid ang mga tao nga dato si Juan. Makon nanda, “Kon ikaw bukun ang Cristo, okon si Elias, okon ang propita nga amun ginaulat nga maabot, ta basi nagapangbunyag kaw ang mga tao?” ");
INSERT INTO clu_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Makon ni Juan kananda, “Ako nagabunyag manda sa tobig, piro may dian kanindo dadi nga ara nindo nakilala. ");
INSERT INTO clu_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Matood nga naori tana kanakun magabot, piro bisan maging anang sorogoon lang indi ako pa poidi.” ");
INSERT INTO clu_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Dia natabo sa Betania, doto sa loyo ang soba nga Jordan, ay doto si Juan nagapangbunyag. ");
INSERT INTO clu_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Pagdason nga adlaw nakita ni Juan si Jesus nga nagaparapit kanana. Makon dayon ni Juan sa mga tao, “Dagi run anang pinakakarniro ang Dios nga inogalad agud bulun anang mga sala ang mga tao sa kalibotan. ");
INSERT INTO clu_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Tana maman akun ginakoon nga maabot nga ori kanakun piro mas mataas kanakun, ay bago ako natao, tana dian run nga lagi. ");
INSERT INTO clu_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ang ona pati ako gani ara kaulam kon sino tana gid, piro nagayan ako digi nga nagapangbunyag sa mga tao agud ipakilala tana sa atun mga kapario nga taga-Israel. ");
INSERT INTO clu_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","“Dadi kilala ko tana run ay nakita ko ron ang Ispirito Santo nga nagkunsad kanana alin sa langit nga pario sa salampati kag nagtinir kanana. ");
INSERT INTO clu_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ang ona ara ko tana pa nakilala, piro ang Dios nga nagsogo kanakun nga magbunyag kanindo sa tobig maman ang nagkoon nga lagi kanakun nga kon makita ko ang Ispirito Santo nga magkunsad kag magpabilin sa sangka tao, dan nga tao maman ang magabunyag sa Ispirito Santo. ");
INSERT INTO clu_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Kag dia nakita ko gid. Gani ginapamatodan ko nga tana maman anang Bata ang Dios.” ");
INSERT INTO clu_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Pagdason nga adlaw, doto roman si Juan kaiban ang darwa ka tao nga anang ginatodloan. ");
INSERT INTO clu_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Pagkakita na kay Jesus nga nagalubas, makon na, “Maman dan anang pinakakarniro ang Dios nga inogalad para sa atun mga sala.” ");
INSERT INTO clu_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Pagkabati dato anang darwa ka kaiban, nagsonod sanda dayon kay Jesus. ");
INSERT INTO clu_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Pagbalikid ni Jesus, nakita na sanda nga nagasonod kanana. Gani makon na kananda, “Ano indong ginapangita?” Makon nanda, “Rabbi, sa diin kaw nagaoli?” (Anang gostong ambalun ang Rabbi “Manogtodlo”.) ");
INSERT INTO clu_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Makon na, “Dali, pagtawas kamo kanakun agud makita nindo.” Gani nagtabid sanda kay Jesus kag nakita nanda kon diin tana nagaoli. Mga alas koatro ron dato ang apon, gani doto sanda run lang nagpagabi. ");
INSERT INTO clu_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ang isara sa darwa nga dato nga nakabati anang koon ni Juan nga nagsonod kay Jesus ara iba kondi si Andres nga kabogto ni Simon Pedro. ");
INSERT INTO clu_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Pagkaaga ginpangita na nga lagi anang kabogto nga si Simon kag ginsogidan na nga nakita nanda ang Mesias. (Anang gostong ambalun ang Mesias “Cristo”.) ");
INSERT INTO clu_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Pagkatapos, gindara na dayon si Simon kay Jesus. Pagabot nanda kay Jesus, ginsulung ni Jesus si Simon kag nagkoon, “Ikaw si Simon nga bata ni Juan. Piro dadi tawagun ta ka run nga Cefas.” (Ang Cefas nga dia pario ra ang aran nga Pedro kag anang gostong ambalun “Bato”.) ");
INSERT INTO clu_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Pagdason nga adlaw, naisipan ni Jesus nga magayan sa probinsya ang Galilea. Pagabot nanda doto, nakita na si Felipe. Makon na dayon kay Felipe, “Dali, pagtawas kanakun!” ");
INSERT INTO clu_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","(Si Felipe nga dia taga-Betsaida nga isara sa mga logar sa Galilea. Taga-doto ra si Andres kag si Pedro.) ");
INSERT INTO clu_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Anang ginimo ni Felipe, ginpangita na si Natanael, kag pagkakita na kanana, makon na, “Nakita namun run ang tao nga atun ginaulat nga ginsambit ang mga propita sa andang mga ginsolat. Kag ginsambit tana ra ni Moises sa anang ginsolat sa libro ang Kasogoan. Si Jesus gali nga taga-Nazaret nga bata ni Jose maman andang ginatomod.” ");
INSERT INTO clu_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Makon ni Natanael, “Ara sigoro taga-Nazaret nga makalosot nga may abilidad.” Makon ni Felipe kanana, “Dali, pagtabid agud makita mo.” ");
INSERT INTO clu_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Pagkakita ni Jesus kay Natanael nga nagaparapit kanana, makon na, “Dagi ang matood nga Israelita nga ara gid nagadaya.” ");
INSERT INTO clu_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Makon dayon ni Natanael kanana, “Basi kilala mo ako?” Makon da ni Jesus, “Bago kaw daraun digi ni Felipe, nakita ta kaw ron doto sa idalum ang kaoy nga igira.” ");
INSERT INTO clu_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Gani makon ni Natanael, “Manogtodlo, matood gid manda nga ikaw anang Bata ang Dios! Ikaw ra gid amun ginaulat nga magaari sa Israel!” ");
INSERT INTO clu_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Makon dayon ni Jesus kanana, “Ta nagatoo kaw kanakun tungud nga nagkoon ako nga nakita ta kaw doto sa idalum ang kaoy nga igira? Mas sobra pa dian imong makikita sa pira ka adlaw.” ");
INSERT INTO clu_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Kag makon dayon ni Jesus kananda, “Sa matood tana, magaabot ang adlaw nga makikita nindo ang langit nga magaabri kag makikita nindo anang mga angil ang Dios nga nagasaraka kag nagarolosong paayan Kanakun nga Naging Tao!” ");
INSERT INTO clu_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Pagkalubas ang darwa ka adlaw, may kasal sa banwa ang Cana sa probinsya ang Galilea. Doto anang nanay ni Jesus. ");
INSERT INTO clu_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ginimbitar ra si Jesus pati anang mga somolonod. ");
INSERT INTO clu_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Kag natabo nga nagkolang ang bino nga obas doto sa ponsyon. Gani makon anang nanay ni Jesus kanana, “Naobosan sanda run bino.” ");
INSERT INTO clu_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Makon ni Jesus kanana, “Indi kinanglan nga konon mo ako pa kon ano akun imoon. Ara pa nagabot akun oras agud ipakita ko akun gaum sa mga tao.” ");
INSERT INTO clu_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Makon dayon anang nanay ni Jesus sa mga sorogoon, “Sonoda nindo lang ang bisan ano nga anang isogo kanindo.” ");
INSERT INTO clu_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Karon, may mga soronodon ang mga Judio sa pagpangogas bago sanda magkaun. Gani may anum ka tadyaw doto nga ang kada tadyaw sarang masuludan mga 20 okon 30 ka galon nga tobig. ");
INSERT INTO clu_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Makon ni Jesus sa mga sorogoon, “Ponoa nindo tobig ang mga tadyaw.” Gani ginpono nanda. ");
INSERT INTO clu_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Pagkatapos, makon ni Jesus kananda, “Sigi, pagsarok kamo kag daraun doto sa nagadomara ang ponsyon.” Gani nagsarok sanda kag gindara nanda doto sa nagadomara, ");
INSERT INTO clu_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","kag ginsamitan dayon ang manogdomara ang tobig nga dato nga naimo ron nga bino. Ara tana kaulam kon diin nagalin ang bino nga dato, (piro naulaman ang mga sorogoon nga nagsarok ang tobig). Pagkatiraw na, gintawag na ang nobyo. ");
INSERT INTO clu_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Makon na kanana, “Kalabanan sa mga tao nagasirbi ang mayad nga klasi nga bino sa ompisa kag kon doro ron anang nainum ang mga bisita, bago nanda ginapainum ang ordinaryo nga bino. Piro ikaw tana iba, ay dadi mo ginpagoa ang pinakamanamit.” ");
INSERT INTO clu_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ang natabo nga dato sa Cana nga sa Galilea maman ang ona nga milagro nga ginimo ni Jesus. Sa anang ginimo nga dato ginpakita na anang gaum, kag anang mga somolonod nagtoo kanana. ");
INSERT INTO clu_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Pagkatapos ang kasal, nagpa-Capernaum si Jesus kaiban anang nanay, anang mga kabogto nga lalaki, kag anang mga somolonod, kag nagtinir sanda doto mga pira ka adlaw. ");
INSERT INTO clu_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Marapit run anang pista ang mga Judio nga ginatawag nga Pista anang Paglubas ang Angil. Gani nagpa-Jerusalem si Jesus. ");
INSERT INTO clu_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ang doto tana run sa Jerusalem may nakita tana nga mga tao sa timplo nga nagabaraligya ang mga inogalad nga mga baka, mga karniro, kag mga salampati. May mga tao ra doto sa andang mga lamisa nga nagapamaylo koarta. ");
INSERT INTO clu_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Pagkakita na sa andang mga ginaimo doto nagimo tana aranot nga lobid. Pagkatapos, ginpanabog na dayon ang mga karniro kag mga baka pa goa sa timplo. Ginpamaliskad na ra anang mga lamisa ang mga manogbaylo ang koarta kag ginpangwasag na andang mga koarta. ");
INSERT INTO clu_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Makon na dayon sa mga nagabaraligya ang salampati, “Pamula nindo dia digi! Ayaw nindo pagimoa nga baraligyaan anang balay akun Tatay!” ");
INSERT INTO clu_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Pagkakita anang mga somolonod sa anang ginimo nga dato, nadumduman nanda anang koon ang Dios sa Kasolatan nga nagakoon, “Masakit nga mayad akun buut nga makita nga imong balay ara ginataoda ang mga tao.” ");
INSERT INTO clu_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Tungud sa anang ginimo nga dato, anang mga manogdomara ang mga Judio nagpamangkot kanana, makon nanda, “Ano nga milagro imong maimo agud ipakita kanamun nga ikaw may podir nga magimo imong ginimo nga dato?” ");
INSERT INTO clu_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Makon ni Jesus, “Gubaa nindo ang timplo nga dia kag sa sulud tatlo ka adlaw patindugun ko roman.” ");
INSERT INTO clu_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Makon nanda, “Ang timplo nga dia ginpatindug sa sulud 46 ka toig, ta patindugun mo lang sa sulud tatlo ka adlaw?” ");
INSERT INTO clu_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Piro ara sanda kaintindi, ay anang gintomod tana ni Jesus nga timplo ara iba kondi anang lawas. ");
INSERT INTO clu_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Gani pagkabanaw kanana nadumduman anang mga somolonod anang ambal nga dia. Kag nagpati sanda nga tama matood anang gintagna ang Kasolatan kag anang koon parti sa anang pagkabanaw. ");
INSERT INTO clu_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ang doto si Jesus sa Jerusalem sa tyimpo ang Pista anang Paglubas ang Angil, doro ang nakakita sa mga milagro nga anang ginpangimo, kag doro kananda ang nagtoo kanana. ");
INSERT INTO clu_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Piro si Jesus ara nagsarig sa andang pagtoo kanana ay naulaman na ang tanan nga tao. ");
INSERT INTO clu_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Indi tana run kinanglan nga sogidan pa parti sa mga tao, ay naulaman na nga lagi kon ano gid ang sa sulud andang tagiposoon. ");
INSERT INTO clu_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","May sangka tao nga anang aran si Nicodemo. Ang tao nga dia isara sa mga manogdomara ang mga Judio, kag mimbro tana ang gropo nga ginatawag nga Pariseo. ");
INSERT INTO clu_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","May gabi nga si Nicodemo nga dia nagayan kay Jesus kag magkoon, makon na, “Rabbi, naulaman namun nga ikaw manogtodlo nga ginpadara ang Dios, tungud nga ara may makaimo ang mga milagro nga pario imong ginapangimo kon ang Dios ara dian kanana.” ");
INSERT INTO clu_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Makon ni Jesus kay Nicodemo, “Sa matood tana, ara tao nga makairug sa anang ginarian ang Dios kon indi tana maoman bata.” ");
INSERT INTO clu_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nagpamangkot si Nicodemo, makon na, “Ta paiwan anang pagkabata oman ang tao kon malam tana run? Indi tana run da makabalik sa tian anang nanay agud ibata ruman.” ");
INSERT INTO clu_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Makon ni Jesus, “Ginasogid ko gid tana kanimo ang matood nga ara gid tao nga makasulud sa anang ginarian ang Dios kon indi tana mabata paagi sa tobig kag sa Ispirito Santo. ");
INSERT INTO clu_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ang ginbata paagi sa tao, tao ra lang, piro ang ginbata tana paagi sa anang gaum ang Ispirito Santo, ispiritoanun. ");
INSERT INTO clu_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Gani indi kaw matingala sa akun koon kanimo nga kinanglan maoman kamo bata. ");
INSERT INTO clu_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Dia pario sa angin. Ang angin kabay nagauyup sa bisan diin anang gosto. Nababatian ta nga nagauyup, piro ara kita kaulam kon diin nagaalin kag kon diin nagapaayan. Dan toladan ra anang gaum ang Ispirito Santo sa tao nga nabata paagi sa anang gaum, indi mo maintindian piro matood nga natatabo.” ");
INSERT INTO clu_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Gani nagpamangkot si Nicodemo, makon na, “Ta paiwan dato?” ");
INSERT INTO clu_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Makon ni Jesus, “Bantog kaw nga manogtodlo sa Israel, piro ara kaw kaulam kon ano dia? ");
INSERT INTO clu_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Makasarig kaw nga akun ginasogid kanimo matood, tungud nga ang mga butang nga amun ginasogid ay mga butang nga amun naulaman kag nakita mismo. Garing indi kamo magpati sa amun ginasogid. ");
INSERT INTO clu_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Karon, kon kamo ara gani nagapati sa akun ginasogid kanindo parti sa mga butang digi sa kalibotan, mas indi kamo ron gid magpati kanakun kon sogidan ko kamo ang parti sa mga butang doto sa langit. ");
INSERT INTO clu_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Kag Ako nga Naging Tao maman lang gid ang nakasaka sa langit, ay doto ako sa langit nagalin.” ");
INSERT INTO clu_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Makon pa ni Jesus, “Ang ona nga mga adlaw, ang si Moises doto pa sa logar nga ara ginaolii ang tao, nagimo tana ang magkal nga saway. Pagkatapos, gintagkus na dayon sa kaoy nga malabug kag ginbandira agud makita ang mga tao. Dan toladan ra ang imoon kanakun. Ako nga Naging Tao kinanglan ra nga ibutang sa kaoy kag ibandira, ");
INSERT INTO clu_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","agud ang kada isara nga magtoo kanakun makaangkun kaboi nga ara kataposan. ");
INSERT INTO clu_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Tungud sa anang mabaul nga pagigogma ang Dios sa mga tao digi sa kalibotan, ginpadara na anang bogtong nga Bata, agud nga ang kada isara nga nagatoo kanana indi run pagsilotan ang kamatayun nga ara kataposan, kondi tawan kaboi nga ara kataposan. ");
INSERT INTO clu_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ara nagpadara kanakun ang Dios digi sa kalibotan agud sintinsyaan ang mga tao, kondi ginpadara na ako agud malibri sanda sa silot. ");
INSERT INTO clu_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Gani ang mga tao nga nagatoo kanakun indi run pagsintinsyaan, piro ang bisan sino nga ara nagatoo kanakun sintinsyado ron tungud nga ara tana nagtoo kanakun nga anang bogtong nga Bata ang Dios. ");
INSERT INTO clu_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Sisilotan sanda tungud nga nagabot ako digi sa kalibotan agud magtaw kasanag sa anang mga isip ang mga tao, piro mas gosto nanda pa nga magpabilin sa madulum kaysa magparapit kanakun nga pinakasolo, ay malain andang mga ginaimo. ");
INSERT INTO clu_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ang tao nga malain anang ginaimo ara naliag sa masanag. Nagalikaw tana pa gani sa masanag ay sabun maulaman anang ginaimo nga malain. ");
INSERT INTO clu_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Piro ang tao tana nga nagaogali sono sa kamatoodan nagaparapit sa masanag, agud makita nga anang mga inimoan nga mayad naiimo na paagi sa anang bolig ang Dios.” ");
INSERT INTO clu_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Pagkatapos dia, si Jesus kag anang mga somolonod nagayan sa probinsya ang Judea. Pira ra ka simana andang tinir doto nga nagapangbunyag ang mga tao. ");
INSERT INTO clu_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Si Juan nagapangbunyag ra piro doto sa Enon, marapit sa Salim, ay dorong tobig doto. Sigi-sigi anang ayan doto ang mga tao kay Juan agud magparabunyag. ");
INSERT INTO clu_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Sa mga oras nga dato si Juan ara pa napriso.) ");
INSERT INTO clu_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Karon ang iba sa anang mga gintodloan ni Juan nakapakigdiskosyon sa sangka Judio parti sa bunyag. ");
INSERT INTO clu_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ang ori nagayan sanda kay Juan kag magkoon, “Manogtodlo, nadumduman mo ang tao ang doto kaw sa loyo ang soba ang Jordan, ang tao bala nga imong ginpakilala sa mga tao? Nagapangbunyag tana run da dadi kag aros tanan nga mga tao doto ron kanana nagaarayan!” ");
INSERT INTO clu_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Makon ni Juan kananda, “Ara gid sarang maimo ang tao kon bukun sa anang pagbuut ang Dios. ");
INSERT INTO clu_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Kamo mismo makapamatood nga ako nagkoon nga bukun ako ang Cristo, kondi ginpaona ako lang ang Dios para magbarita nga tana magaabot ron. ");
INSERT INTO clu_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Pario bala kon may kasal: ang nobya para gid sa nobyo, kag anang amigo ang nobyo nga nagatambong kag nagapamati nalilipay kon nababatian na nga dian run ang nobyo. Dan toladan akun kaalimbawa dadi. Nalilipay ako nga ang mga tao nagaayan run kay Jesus. ");
INSERT INTO clu_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Kinanglan nga magdogang pa gid anang pagkabantog ni Jesus, kag ako tana dapat run nga lipatan.” ");
INSERT INTO clu_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Si Cristo alin sa langit, gani labaw tana sa tanan. Kita taga-digi sa kalibotan kag ang mga butang nga atun ginaambal ara iba kondi ang digi lang gid sa kalibotan. Piro tana tana nga nagalin sa langit labaw sa tanan. ");
INSERT INTO clu_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Nagasogid tana parti sa mga butang nga anang nakita kag nabatian doto sa langit, piro malaka gid lang ang nagapati sa anang ginasogid. ");
INSERT INTO clu_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Piro ang mga nagapati tana sa anang ginasogid nagapamatood nga anang ginasogid ang Dios matood. ");
INSERT INTO clu_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ay si Cristo nga anang ginpadara ang Dios digi sa kalibotan nagasogid kanatun kon ano anang ginapasogid ang Dios kanana, tungud nga ara limitasyon anang pagtaw ang Dios kanana ang Ispirito Santo. ");
INSERT INTO clu_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ginaigogma ang Amay anang Bata kag gintogyan na kanana ang tanan. ");
INSERT INTO clu_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ang bisan sino nga nagatoo sa anang Bata ang Dios may kaboi nga ara kataposan. Piro ang bisan sino nga indi magtoman sa anang Bata ang Dios indi pagtawan kaboi nga ara kataposan, kondi anang kasilag ang Dios dian kanana asta kon sano. ");
INSERT INTO clu_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Karon, ang mga Pariseo nakabarita nga mas doro ron anang mga somolonod ni Jesus kaysa kay Juan, kag mas doro ron da anang ginapangbunyagan. ");
INSERT INTO clu_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Sa matood tana, bukun si Jesus mismo ang nagapangbunyag, kondi anang mga somolonod.) ");
INSERT INTO clu_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Pagkaulam ni Jesus nga dia naulaman run ang mga Pariseo, nagalin tana sa probinsya ang Judea kag nagbalik sa Galilea. ");
INSERT INTO clu_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Pagayan nanday Jesus sa Galilea, kinanglan nga sanda magagi sa probinsya ang Samaria. ");
INSERT INTO clu_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ang nagaagi sanda run sa Samaria, nagabot sanda sa banwa nga kon tawagun Sicar, marapit sa logta nga gintaw ni Jacob sa anang bata nga si Jose. ");
INSERT INTO clu_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","May bobon doto nga ginimo ni Jacob. Kag tungud nga ogtong adlaw ron kag si Jesus ginpilayan nga mayad sa anang pagpanaw, nagpongko tana run lang sa binit ang bobon nga dato. ");
INSERT INTO clu_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Anang mga somolonod tana nagdiritso sa banwa agud magbakal ang pagkaun. Karon, mintras nagapongko tana doto, nagabot ang sangka babai nga taga-Samaria nga masagub. Makon ni Jesus kanana, “Abi painuma ako ra.” ");
INSERT INTO clu_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Makon ang babai kanana, “Ikaw kabay Judio kag ako tana Samarianun kag babai pa. Basi nagapangayo kaw kanakun ang tobig?” (Toladan anang koon tungud nga ang mga Judio ara nagasapak sa mga Samarianun.) ");
INSERT INTO clu_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Makon ni Jesus sa babai, “Kon naulaman mo lang kon ano anang ginataw ang Dios, kag kon sino ang nagapangayo kanimo tobig, ikaw pa andan ang mapangayo kanakun agud tawan ta kaw ang tobig nga nagataw kaboi nga ara kataposan.” ");
INSERT INTO clu_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Makon ang babai kanana, “Paiwan imong pagtaw kanakun ang tobig nga imong ginakoon, ay ang bobon madalum kag ara kaw timba? Diin kaw makabuul imong ginakoon nga tobig nga nagataw kaboi? ");
INSERT INTO clu_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Atun kaolang-olangan nga si Jacob maman ang nagkotkot ang bobon nga dia. Tana kag anang mga bata pati anang mga ayup naginum sa bobon nga dia. Ano, sobra ka pa bala sa atun kaolang-olangan nga si Jacob?” ");
INSERT INTO clu_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Makon ni Jesus sa babai, “Ang bisan sino nga nagainum ang tobig nga dia wawon roman. ");
INSERT INTO clu_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Piro ang nagainum tana ang tobig nga akun itaw indi run gid pagwawon. Ay ang tobig nga akun itaw maging pario sa boi nga toboran dian kanana nga magataw kaboi nga ara kataposan.” ");
INSERT INTO clu_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Gani makon ang babai kay Jesus, “Ta tawi ako ra ang tobig nga dan nga imong ginakoon agud indi ako ron gid pagwawon, kag agud indi run kinanglan nga magbalik-balik ako pa digi para magsagub.” ");
INSERT INTO clu_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Makon dayon ni Jesus kanana, “Ta ayani imong asawa kag daraun digi.” ");
INSERT INTO clu_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Nagsabat ang babai, makon na, “Ara ako asawa.” Makon ni Jesus, “Tama dan. Ara kaw matood asawa, ");
INSERT INTO clu_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","tungud nga lima run imong naging asawa, kag ang lalaki nga imong ginadapunan dadi bukun da imong matood nga asawa. Gani matood imong sogid nga dan.” ");
INSERT INTO clu_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Makon ang babai kanana, “Sigoro anang propita kaw ang Dios. ");
INSERT INTO clu_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Amun mga kaolang-olangan nga mga Samarianun nagsimba sa Dios sa bokid nga dia, piro kamo tana nga mga Judio nagakoon nga ang mga tao dapat magsimba sa Dios sa Jerusalem.” ");
INSERT INTO clu_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Makon ni Jesus sa babai, “Pamatii anay bala! Magaabot ang adlaw nga indi kamo ron magsimba sa Amay digi sa bokid nga dia okon sa Jerusalem. ");
INSERT INTO clu_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Kag kon parti kanindo nga mga Samarianun, ara kamo gid kakilala kon sino indong ginasimba. Kami tana nga mga Judio nakakilala kon sino amun ginasimba, tungud nga paagi kanamun nga mga Judio lowasun ang Dios ang mga tao.” ");
INSERT INTO clu_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Makon pa ni Jesus, “Sa matood tana magaabot ang adlaw, kag nagabot ron gani, nga ang matood nga manogsimba magasimba sa Amay paagi sa anang ispirito kag sono sa kamatoodan. Kag ang toladia nga mga manogsimba maman anang gosto ang Dios. ");
INSERT INTO clu_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ang Dios ispirito, gani ang nagasimba kanana dapat magsimba paagi sa anang ispirito kag sono sa kamatoodan.” ");
INSERT INTO clu_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Makon ang babai, “Naulaman ko nga magaabot ang Mesias nga ginatawag ra nga Cristo. Kag kon magabot tana run, sogidan na kita parti sa tanan nga mga butang.” ");
INSERT INTO clu_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Makon ni Jesus kanana, “Ako dato. Ang nagapakigambal nga dia kanimo dadi maman imong ginakoon nga magaabot.” ");
INSERT INTO clu_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Pagkakoon na dia nagabot dayon anang mga somolonod. Mabaul andang katingala pagkakita nanda kanana nga nagapakigambal sa sangka babai. Piro ara gid may nagpamangkot sa babai kon ano anang kinanglan. Ara sanda ra nagpamangkot kay Jesus kon basi nagapakigambal tana sa babai. ");
INSERT INTO clu_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ginbilin dayon ang babai anang banga nga ginasaguban kag nagbalik sa banwa. Pagabot na doto makon na sa mga tao, ");
INSERT INTO clu_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Dali kamo bala, sulunga nindo ang tao nga nakaulam ang tanan nga akun ginimo. Sigoro maman run dia ang Cristo.” ");
INSERT INTO clu_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Gani nagarayan ang mga tao doto kay Jesus. ");
INSERT INTO clu_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Mintras ara pa nagarabot doto ang mga tao sigi anang pirit kanana anang mga somolonod nga magkaun tana run. ");
INSERT INTO clu_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Piro makon ni Jesus kananda, “May pagkaun Ako nga ara nindo naulami.” ");
INSERT INTO clu_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Gani anang mga somolonod nagparamangkot sa isara kag isara kon may nagdara kanana pagkaun. ");
INSERT INTO clu_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Makon dayon ni Jesus kananda, “Akun pinakapagkaun ara iba kondi nga tomanun ko anang kabubutun ang Dios nga nagpadara kanakun digi kag taposon anang ginapaimo kanakun. ");
INSERT INTO clu_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Nagakoon kamo nga apat pa ka bolan bago magabot ang tigarani. Piro kon sa kanakun tana tigarani run dia. Sulunga nindo bala ang maraku nga dan nga mga tao nga nagaarabot! Kon sa mga araniun loto ron gid, kag araniun run. ");
INSERT INTO clu_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Indong kaalimbawa mga manogani tungud nga kamo nagasaysay sa mga tao agud magtoo sanda kanakun. Ang Dios may ginatigana nga balus para kanindo. Kag ang mga tao nga kon sa mga araniun maman indong ginaani tawan na kaboi nga ara kataposan. Gani ang mga nagatanum anang mga ambal ang Dios kag ang mga nagaani anang pinakabonga pario nga magakalipay. ");
INSERT INTO clu_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Matood manda ang ginakoon nga ‘iba ang nagatanum kag iba ra ang nagaani.’ ");
INSERT INTO clu_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Indong kaalimbawa mga manogani nga akun ginpadara nga magaani sa mga araniun nga bukun kamo ang nagtanum. Tungud nga iba ang nagtodlo anay kananda, kag kamo ang nagapolos andang pinangabudlayan.” ");
INSERT INTO clu_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Doro nga mga Samarianun sa logar nga dato ang nagtoo kay Jesus tungud sa anang sogid ang babai nga naulaman ni Jesus ang tanan nga anang inimoan ang ona. ");
INSERT INTO clu_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Gani pagabot doto kay Jesus ang mga Samarianun nga ginabat ang babai, nagpangabay sanda gid kanana nga kon maimo magtinir tana ra anay doto kananda. Gani nagtinir doto sanday Jesus darwa ka adlaw. ");
INSERT INTO clu_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Kag doro pa gid ang mga tao doto nga nagtoo kanana tungud sa anang mga panodlo. ");
INSERT INTO clu_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Makon dayon ang mga tao sa babai, “Dadi nagatoo kami kanana bukun lang tungud sa imong sogid kanamun, kondi kami mismo nakabati kanana. Kag naulaman namun run nga tana maman gid ang Manlolowas ang kalibotan.” ");
INSERT INTO clu_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Pagkatapos ang darwa ka adlaw nga pagtinir nanday Jesus doto, nagpa-Galilea sanda dayon. ");
INSERT INTO clu_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Tana mismo ang nagkoon nga anang propita ang Dios ara ginataoda sa anang kaogalingun nga banwa. ");
INSERT INTO clu_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Piro pagabot nanday Jesus sa Galilea, mayad ang pagbaton kanana ang mga tao, ay ang pagpista sa Jerusalem, ang mga tao nga dia doto ra kag nakita nanda ang tanan nga anang ginpangimo ni Jesus doto. ");
INSERT INTO clu_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Nagbalik ruman si Jesus sa Cana nga sakup ang Galilea, sa logar nga ang tobig ginimo na nga bino. Karon, doto sa Cana may sangka opisyal ang gobyirno nga anang bata nga lalaki nagamasakit doto sa Capernaum. ");
INSERT INTO clu_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Pagkabati na nga si Jesus nagbalik sa Galilea alin sa Judea, nagayan tana kay Jesus. Ginpangabay na dayon si Jesus nga magayan sa Capernaum kag ayadun anang bata nga tagomatayun. ");
INSERT INTO clu_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Makon ni Jesus kanana, “Kon indi nindo makita ang mga milagro kag mga katiringalaan, indi kamo magtoo kanakun.” ");
INSERT INTO clu_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Piro nagpakitloy ang opisyal, makon na, “Kon maimo pagtawas ra anay kanakun mintras boi pa akun bata.” ");
INSERT INTO clu_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Makon dayon ni Jesus kanana, “Pagoli run. Mayad run imong bata.” Ang opisyal nga dato nagpati sa anang ambal ni Jesus, gani nagoli tana dayon. ");
INSERT INTO clu_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Mintras nagapaoli tana, ginsolang-solang tana anang mga sorogoon kag ginsogidan nga anang bata mayad run. ");
INSERT INTO clu_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Gani nagpamangkot tana kon anong oras nagayad anang bata. Makon anang mga sorogoon, “Mga ala ona kaapon ang apon nadora anang ragnat.” ");
INSERT INTO clu_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Nadumduman dayon ang opisyal nga maman gid dato nga oras anang pagkoon ni Jesus kanana nga anang bata mayad run. Gani tana kag anang bilog nga pamilya nagtoo kay Jesus. ");
INSERT INTO clu_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Maman dia ang ikarwa nga milagro nga ginimo ni Jesus sa Galilea pagkaalin na sa probinsya ang Judea. ");
INSERT INTO clu_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Pagkatapos dato may pista ang mga Judio, gani nagpa-Jerusalem ruman si Jesus. ");
INSERT INTO clu_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Doto sa padir nga nagalibot sa siodad ang Jerusalem may poirtaan nga aragian ang mga karniro. Kag marapit sa poirtaan nga dato may tobig nga pararigosan nga kon sa Hebreo nga ambal ginatawag nanda nga Betsata. Sa palibot ang tobig nga dato may lima ka parasirongan. ");
INSERT INTO clu_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Doto sa mga parasirongan nga dato dorong mga tao nga nagamarasakit ang nagairinggamga bolag, mga piang, kag mga paralitiko. Nagaulat sanda nga lawgawon ang tobig, ");
INSERT INTO clu_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","ay kaisan kono, may angil ang Dios nga nagalosong doto kag ginalawgaw na ang tobig. Ang makaona losong sa tobig pagkatapos nga lawgawon ang angil nagaayad kono bisan ano anang masakit. ");
INSERT INTO clu_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Karon, may sangka tao doto nga anang masakit 38 ron ka toig. ");
INSERT INTO clu_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ang tao nga dato nakita ni Jesus nga nagaingga doto, kag ulam na nga anang masakit toladato ron boay. Gani makon ni Jesus kanana, “Gosto mo bala nga magayad?” ");
INSERT INTO clu_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Makon da ang masakitun nga dato, “Andan, piro ara tao nga magdara kanakun sa tobig kon ginalawgaw ron ang angil. Mintras nagapaayan ako pa lang sa tobig may naoona pirmi kanakun.” ");
INSERT INTO clu_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Makon dayon ni Jesus kanana, “Pagtindug, dara imong banig kag magpanaw.” ");
INSERT INTO clu_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Lagi-lagi nagayad ang tao nga dato sa anang masakit, kag gindara na anang banig kag nagpanaw. Dia natabo ang Adlaw nga Inogpaway. ");
INSERT INTO clu_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Gani makon anang mga manogdomara ang mga Judio sa tao nga ginayad, “Oy, kabay Adlaw dia nga Inogpaway, kag sono sa atun Kasogoan bawal ang magobra bisan ang pagdara imong banig.” ");
INSERT INTO clu_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Makon ang tao nga ginayad, “Ang tao nga nagayad kanakun maman ang nagkoon kanakun nga daraun ko akun banig kag magpanaw.” ");
INSERT INTO clu_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Gani ginpamangkot nanda tana kon sino ang tao nga nagsogo kanana nga magdara anang banig kag magpanaw. ");
INSERT INTO clu_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Piro ang tao nga ginayad ara kakilala kon sino ang nagayad kanana, tungud nga nadora run si Jesus sa karakuun ang mga tao. ");
INSERT INTO clu_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ang ori nakita ni Jesus sa timplo ang tao nga anang ginayad, kag makon na kanana, “Ta mayad ka run dadi. Indi kaw ron magpakasala, ay sabun mas malain pa gid ang matabo kanimo.” ");
INSERT INTO clu_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Nagpanaw dayon ang tao kag nagayan sa mga manogdomara ang mga Judio. Ginsogidan na sanda nga si Jesus gali ang nagayad kanana. ");
INSERT INTO clu_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Alin dato anang mga manogdomara ang mga Judio nagompisa run nga magingabot kay Jesus, ay si Jesus nagayad sa Adlaw nga Inogpaway. ");
INSERT INTO clu_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Piro may sabat si Jesus para kananda, makon na, “Akun Tatay padayon nga nagaimo ang mayad, gani ako nagaimo ra ang mayad.” ");
INSERT INTO clu_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Tungud sa anang ginambal nga dato ni Jesus, mas nagdogang pa gid anang andum anang mga manogdomara ang mga Judio nga patayun tana, tungud nga bukun lang nga ginlapas na ang Kasogoan parti sa Adlaw nga Inogpaway, kondi nagkoon tana pa nga Tatay na gid ang Dios, nga nagakaologan nga tana nagapakigtupung sa Dios. ");
INSERT INTO clu_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Gani makon ni Jesus kananda, “Sa matood tana, ako bilang anang Bata ang Dios ara ako may maimo kon sa kanakun lang; kondi kon ano akun nakita nga ginaimo akun Tatay maman da akun ginaimo. Kon ano anang ginaimo ang Amay, maman ra anang ginaimo anang Bata. ");
INSERT INTO clu_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Palangga ako ang Amay bilang anang Bata, gani ginapakita na kanakun ang tanan nga anang ginaimo. Kag sobra pa sa mga butang nga dia anang itodlo kanakun ang Amay nga akun imoon agud matingala kamo. ");
INSERT INTO clu_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Kon ang Amay nagabanaw ang mga patay kag nagataw kananda kaboi, ako nga anang Bata nagataw ra kaboi sa miski kino nga gosto ko nga tawan. ");
INSERT INTO clu_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Bukun ang Amay ang magaukum sa mga tao. Ako nga anang Bata maman anang gintawan awtoridad nga magukum, ");
INSERT INTO clu_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","agud ang tanan magpadungug sa Bata pario andang pagpadungug sa Amay. Gani ang ara nagapadungug kanakun ara ra nagapadungug sa Amay nga nagpadara kanakun. ");
INSERT INTO clu_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Ang matood tana, ang tao nga nagatoman akun mga ambal kag nagatoo sa nagpadara kanakun may kaboi nga ara kataposan. Indi tana run pagsilotan tungud nga anang kalag nakalibri run sa kamatayun kag may kaboi run nga ara kataposan. ");
INSERT INTO clu_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Sa panulung ang Dios ang tanan nga mga tao patay tungud sa andang mga sala. Piro sa matood tana, magaabot ang tyimpo, kag nagabot ron gani, nga ang mga tao nga dia nga patay sa anang panulung ang Dios makakabati anang mga ginasaysay anang Bata ang Dios, kag ang magbaton anang ambal tawan kaboi nga ara kataposan. ");
INSERT INTO clu_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Tungud nga ang Amay may gaum nga magtaw kaboi, ako nga anang Bata makataw ra kaboi, ay gintawan na ako gaum nga magtaw kaboi sa mga tao. ");
INSERT INTO clu_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Gintawan na ako ra awtoridad nga magukum sa tanan nga mga tao tungud nga ako naging tao. ");
INSERT INTO clu_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Indi kamo matingala sa mga butang nga dia, ay magaabot gid ang adlaw nga ang tanan nga mga patay sa rulubungan makakabati akun limug, ");
INSERT INTO clu_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","kag magagoa sanda sa andang mga rulubungan. Ang mga tao nga nakaimo ang mayad banawon kag tawan kaboi nga ara kataposan, kag ang mga tao tana nga nakaimo ang malain banawon ra, piro silotan.” ");
INSERT INTO clu_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Makon pa ni Jesus, “Ara ako sarang maimo kon ako lang. Nagaukum ako matood, piro akun pagukum sono sa anang gintodlo kanakun ang Amay. Gani matarung akun pagukum tungud nga ara ako nagaimo akun gosto, kondi anang gosto ang nagpadara kanakun. ");
INSERT INTO clu_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Karon, kon ako lang gid ang nagasogid parti sa akun kaogalingun, makadoda kamo sa akun ambal. ");
INSERT INTO clu_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Piro may iba nga nagapamatood parti kanakun, kag naulaman ko nga anang ambal masarigan. ");
INSERT INTO clu_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Si Juan nga manogbunyag nagpamatood ra parti kanakun. Kabay kamo may mga ginpaayan kay Juan agud pamangkoton tana. Kag anang sogid matood. ");
INSERT INTO clu_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Kon sa bagay ara ako nagakinanglan anang pagpamatood ang tao parti kanakun. Ginasambit ko lang si Juan ay basi pa kon magtoo kamo kanakun kag malowas kamo sa silot nga paraaboton. ");
INSERT INTO clu_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Anang kaalimbawa ni Juan pario sa solo nga nagadabdad kag nagasanag; kag bisan ara lang boay, nalipay kamo sa anang mga ginpasanag kanindo. ");
INSERT INTO clu_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Piro may nagapamatood pa gid parti kanakun nga sobra pa kay Juan. Dia ara iba kondi ang mga butang nga akun ginaimo nga ginapaimo ang Amay kanakun. Dia nagapamatood nga ang Amay maman ang nagpadara kanakun. ");
INSERT INTO clu_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Kag ang Amay mismo nga nagpadara kanakun maman da ang nagapamatood parti kanakun. Piro ara nindo gid tana nakita, kag ara nindo tana ra nabatii nga nagaambal. ");
INSERT INTO clu_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Gani indi nindo pagbatonon anang ambal, tungud nga indi kamo magpati kanakun nga anang ginpadara. ");
INSERT INTO clu_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ginatonan nindo nga mayad anang mga Kasolatan ang Dios ay indong pagsarig sa toladan nga paagi maangkun nindo ang kaboi nga ara kataposan. Ang mga Kasolatan mismo nagapamatood parti kanakun. ");
INSERT INTO clu_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Piro indi kamo ra magparapit kanakun agud maangkun nindo ang kaboi nga ara kataposan. ");
INSERT INTO clu_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Ara ako nagaangad nga dayawon ako ang mga tao. ");
INSERT INTO clu_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ay kilala ko kamo gani. Naulaman ko indong mga tagiposoon, nga ara kamo pagigogma sa Dios. ");
INSERT INTO clu_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ako nagayan digi nga may awtoridad alin sa Amay, garing indi kamo magbaton kanakun. Piro kon may iba nga magabot nga nagagamit anang kaogalingun nga awtoridad, maman indong batonon. ");
INSERT INTO clu_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Paiwan indong pagtoo kanakun kon anang pagdayaw indong kapario maman indong ginapangita, kag ara nindo ginapangitaa ang pagdayaw nga alin sa Dios, nga maman lang ang matood nga Dios? ");
INSERT INTO clu_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Indi kamo magisip nga ako ang magaakosar kanindo sa Amay. Si Moises mismo nga indong ginasarigan maman ang magaakosar kanindo. ");
INSERT INTO clu_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kon matood nga nagapati kamo kay Moises, magatoo kamo andan kanakun, tungud nga parti kanakun anang mga ginsolat ni Moises. ");
INSERT INTO clu_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Piro tungud nga ara kamo nagpati sa anang mga ginsolat, maman dan nga indi kamo ra magpati sa akun ginakoon kanindo.” ");
INSERT INTO clu_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Pagkatapos dato, nagtabok roman si Jesus sa Dagat ang Galilea nga ginatawag ra nga Dagat ang Tiberias. ");
INSERT INTO clu_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Dorong tao ang nagsoronod kanana sa anang ginaayanan, tungud nga nakita nanda anang mga ginaimo nga mga milagro sa pagpangayad ang mga nagamarasakit. ");
INSERT INTO clu_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Nagtokad si Jesus kag anang mga somolonod sa bokid kag nagporongko doto. ");
INSERT INTO clu_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","(Marapit run lang dato anang pista ang mga Judio nga kon tawagun Pista anang Paglubas ang Angil.) ");
INSERT INTO clu_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Paglantaw ni Jesus, nakita na nga dorong mga tao ang nagapaarayan doto kanana. Makon na kay Felipe, “Sa diin kita kabay makabakal pagkaun para makakaun ang mga tao nga dia?” ");
INSERT INTO clu_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Toladato anang pamangkot tungud nga gosto na nga tirawan si Felipe. Piro ang matood tana, may plano tana run nga lagi kon ano anang imoon.) ");
INSERT INTO clu_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Makon ni Felipe kanana, “Ang kadoro nga dan! Miski panawan ta lang tagmairintuk, ang walo ka bolan nga soildo ang sangka tao kolang pa nga ibakal andang pagkaun.” ");
INSERT INTO clu_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Piro makon anang kabogto ni Pedro nga si Andres nga isara ra sa anang mga somolonod ni Jesus, ");
INSERT INTO clu_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“May bata digi nga lalaki nga may lima ka bilog nga tinapay kag darwa ka bilog nga isda. Piro ano ra gid dia sa kadoroon ang tao?” ");
INSERT INTO clu_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Makon ni Jesus sa anang mga kaiban, “Abi papongkoa nindo ang mga tao.” Kag ginpapongko nanda sanda, ay kailamonan ang logar nga dato. Ang mga lalaki lang mga lima ka libo nga lagi. ");
INSERT INTO clu_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Pagkatapos, anang ginimo ni Jesus, ginbuul na ang tinapay nga dato kag nagpasalamat sa Dios, kag ginpatagtag na sa mga tao nga nagaporongko doto. Maman da dato anang ginimo sa isda, kag nagkarabosog sanda tanan. ");
INSERT INTO clu_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Pagkatapos kaun, makon ni Jesus sa anang mga somolonod, “Timusa nindo ang nabilin agud ara gid may masayang.” ");
INSERT INTO clu_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Gani gintipon nanda ang tanan nga nabilin, kag alin sa lima ka bilog nga tinapay nga dato nga ginpakaun sa mga tao, nakapono sanda pa dosi ka baskit. ");
INSERT INTO clu_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Pagkakita ang mga tao sa milagro nga dato nga anang ginimo ni Jesus, makon nanda, “Maman run da gid dia matood ang Propita nga atun ginaulat nga magaabot digi sa kalibotan!” ");
INSERT INTO clu_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Naulaman run nga lagi ni Jesus andang isip nga may toyo sanda nga bulun tana kag rugusun nga maging andang ari. Gani nagalin tana doto kag nagtokad roman sa bokid nga tana lang. ");
INSERT INTO clu_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Pagkasirum, anang mga somolonod naglusub sa baybay ");
INSERT INTO clu_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","kag nagsakay sa sakayan. Gabi run, piro ara pa ra gid kabalik si Jesus doto kananda. Gani nagompisa sanda gayong pabalik sa Capernaum. ");
INSERT INTO clu_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Mintras nagatabok sanda nagbaskug ang angin kag nagbaraul ang mga daloyon. ");
INSERT INTO clu_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Pagkaantad nanda mga lima okon anum ka kilomitro, nakita nanda si Jesus nga nagapanaw sa ibabaw ang dagat paayan sa andang sakayan. Ginpangadlukan sanda nga mayad. ");
INSERT INTO clu_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Piro makon ni Jesus kananda, “Indi kamo magkaadluk, ako dia!” ");
INSERT INTO clu_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Gani ginpasakay nanda tana. Pagkasakay ni Jesus, nakaabot sanda nga lagi sa andang arayanan. ");
INSERT INTO clu_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","23","Pagkasanag, ang mga tao ara pa ra gid nagalin sa logar nga ginpakaunan kananda ang Ginoo ang tinapay nga anang ginpasalamatan sa Dios. Naulaman nanda nga ang gabi nga naglubas may sangka sakayan lang, kag maman dato anang ginsakayan anang mga somolonod ni Jesus. Naulaman nanda ra nga si Jesus ara nagsakay nga kaiban sa anang mga somolonod. Karon, may nagabot doto nga mga sakayan nga alin sa Tiberias. ");
INSERT INTO clu_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Gani pagkaulam ang mga tao nga si Jesus kag anang mga somolonod ara run doto, somakay sanda sa mga sakayan kag nagpa-Capernaum agud pangitaun si Jesus. ");
INSERT INTO clu_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Pagabot nanda doto sa Capernaum nakita nanda si Jesus. Makon nanda, “Manogtodlo, kano ka pa digi?” ");
INSERT INTO clu_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Makon ni Jesus kananda, “Ang matood tana, ginapangita nindo ako bukun nga makon tungud sa mga milagro nga indong nakita, kondi tungud nga kamo ginpakaun ko ang tinapay kag nagkarabosog kamo. ");
INSERT INTO clu_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Piro indi kamo magpangabudlay para sa pagkaun nga nadodora ra lang, kondi magpangabudlay kamo para sa pagkaun nga indi madora asta kon sano. Ako nga Naging Tao maman ang magataw kanindo ang pagkaun nga dia ay ako anang gintawan ang Dios nga Amay ang awtoridad nga magtaw dia.” ");
INSERT INTO clu_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Gani nagpamangkot sanda kanana, makon nanda, “Ta ano amun imoon agud amun masonod anang gosto nga ipaimo ang Dios?” ");
INSERT INTO clu_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Makon anang sabat ni Jesus, “Anang gosto ang Dios nga indong imoon maman dia: magtoo kamo kanakun nga anang ginpadara digi.” ");
INSERT INTO clu_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Makon nanda ra, “Ta ano nga milagro imong mapakita kanamun agud magtoo kami kanimo? ");
INSERT INTO clu_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Atun mga kaolang-olangan dato anay nagkaun ang pagkaun nga ginatawag nga ‘manna’ ang doto sanda sa logar nga ara ginaolii ang tao. Ay nagakoon ang Kasolatan nga gintawan sanda ni Moises ang pagkaun nga alin sa langit!” ");
INSERT INTO clu_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Makon ni Jesus kananda, “Ang matood tana, bukun si Moises ang nagtaw pagkaun alin sa langit kondi akun Tatay. Kag tana maman da ang nagataw kanindo ang matood nga pagkaun alin sa langit. ");
INSERT INTO clu_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ay ang pagkaun nga ginataw ang Dios ara iba kondi tana nga nagalin sa langit kag nagataw kaboi sa mga tao digi sa kalibotan.” ");
INSERT INTO clu_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Makon dayon ang mga tao, “Ta tawi kami ra pirmi ang pagkaun nga dan nga imong ginakoon.” ");
INSERT INTO clu_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Makon ni Jesus, “Ako maman ang pagkaun nga dato nga nagataw kaboi nga ara kataposan. Ang nagaparapit kanakun kag magtoo indi run gid paggutumun okon wawon. ");
INSERT INTO clu_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","“Piro pario akun koon anay kanindo, indi kamo pa ra gid magtoo kanakun bisan nakita nindo ron ang mga milagro nga akun ginaimo. ");
INSERT INTO clu_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ang tanan nga mga tao nga ginataw ang Amay kanakun magaparapit kanakun, kag ang bisan sino nga nagaparapit kanakun indi ko gid pagpangindian. ");
INSERT INTO clu_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ay nagayan ako digi alin sa langit agud sonodon ko anang kabubutun ang Amay nga nagpadara kanakun. Ara ako nagayan digi agud imoon akun kaogalingun nga kabubutun. ");
INSERT INTO clu_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Kag anang kabubutun ang nagpadara kanakun maman dia: indi ko pagpabayanan nga madora ang bisan sangka tao nga anang gintogyan kanakun, kondi banawon ko sanda sa ori nga adlaw. ");
INSERT INTO clu_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ay maman dia anang gosto akun Tatay, nga ang tanan nga magkilala kag magtoo kanakun may kaboi nga ara kataposan, kag banawon ko sanda tanan sa ori nga adlaw.” ");
INSERT INTO clu_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Karon, ang mga Judio nagmororomoro kontra kay Jesus, ay nagkoon tana nga tana ang pagkaun nga nagalin sa langit. ");
INSERT INTO clu_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Makon nanda, “Si Jesus ra lang dan. Anang bata kabay dan ni Jose. Basi kabay nagakoon tana nga tana nagalin sa langit, ay kilala ta ra gani anang tatay kag anang nanay?” ");
INSERT INTO clu_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Sinabat sanda ni Jesus, makon na, “Indi kamo magsari moromoro dian. ");
INSERT INTO clu_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ara tao nga makaparapit kanakun kon indi pagtandugun anang tagiposoon ang Amay nga nagpadara kanakun. Kag ang mga tao nga magparapit kanakun banawon ko sa ori nga adlaw. ");
INSERT INTO clu_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","May ginsolat ang sangka propita nga nagakoon, ‘Sanda nga tanan todloan ang Dios.’ Gani ang tanan nga nagapamati sa mga ginatodlo ang Amay magaparapit gid kanakun. ");
INSERT INTO clu_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ara ako nagakoon nga may tao ron nga nakakita sa Amay. Ako nga nagalin sa Dios nga Amay maman lang gid ang nakakita kanana. ");
INSERT INTO clu_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“Sa matood tana, ang nagatoo kanakun may kaboi run nga ara kataposan, ");
INSERT INTO clu_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","tungud nga ako maman ang pagkaun nga nagataw kaboi nga ara kataposan. ");
INSERT INTO clu_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Indong mga kaolang-olangan nagkaun ang pagkaun nga ginatawag nga manna ang doto sanda sa logar nga ara ginaolii ang tao, piro nagkarapatay sanda pa ra gid. ");
INSERT INTO clu_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Piro ako ang pagkaun nga nagalin sa langit. Ang bisan sino nga magkaun sa pagkaun nga dia indi run pagsilotan kamatayun nga ara kataposan. ");
INSERT INTO clu_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ako gid ang pagkaun nga boi nga nagalin sa langit. Ang bisan sino nga magkaun sa pagkaun nga dia maboboi sa ara kataposan. Tungud nga ang pagkaun nga akun itaw kanana ara iba kondi akun lawas. Dia nga lawas itaw ko agud ang mga tao sa kalibotan makabaton kaboi nga ara kataposan.” ");
INSERT INTO clu_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ang mga Judio nga nagaparamati kay Jesus nagbarais-baisan. Makon nanda, “Paiwan kabay anang pagtaw kanatun ang tao nga dia anang lawas agud kaunun ta?” ");
INSERT INTO clu_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Makon ni Jesus kananda, “Sa matood tana, kon indi kamo magkaun anang lawas ang Naging Tao kag kon indi kamo maginum anang dogo, ara kamo gid kaboi nga ara kataposan. ");
INSERT INTO clu_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Piro ang bisan sino nga nagakaun akun lawas kag nagainum akun dogo may kaboi nga ara kataposan, kag banawon ko tana sa ori nga adlaw. ");
INSERT INTO clu_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ay akun lawas kag akun dogo maman ang pagkaun kag irinumun nga nagataw matood nga kaboi. ");
INSERT INTO clu_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ang bisan sino nga nagakaun akun lawas kag nagainum akun dogo ara gid nagapabulag kanakun kag ako ara ra nagapabulag kanana. ");
INSERT INTO clu_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ang Dios nga Amay nga nagpadara kanakun maman ang ginaalinan ang kaboi, kag tungud kanana nagakaboi ako. Toladan ra ang matatabo sa mga nagakaun kanakun, magakaboi sanda ra tungud kanakun. ");
INSERT INTO clu_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ang pagkaun nga dia nagalin sa langit. Bukun dia pario sa pagkaun nga ‘manna’ nga ginkaun indong mga kaolang-olangan, ay sanda nagkarapatay pa ra gid. Ang nagakaun tana ang pagkaun nga dia nga akun ginakoon kanindo magakaboi run sa ara kataposan.” ");
INSERT INTO clu_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Dia nga mga butang ginambal ni Jesus ang tana nagapanodlo doto sa simbaan ang mga Judio sa Capernaum. ");
INSERT INTO clu_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Doro sa anang mga somolonod ang nakabati sa anang gintodlo nga dato kag makon nanda, “Ang kaibara anang mga ginatodlo nga dan. Sino ra ang makabaton dan?” ");
INSERT INTO clu_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Bisan ara may nagsogid kay Jesus, naulaman na nga anang mga somolonod mismo nagamoromoro tungud sa anang panodlo nga dato. Gani makon na kananda, “Naibaran kamo ra bala sa akun ginaambal? ");
INSERT INTO clu_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ta paiwan kabay kon Ako nga Naging Tao makita nindo nga nagakayab pabalik sa akun ginalinan? ");
INSERT INTO clu_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Anang Ispirito ang Dios maman ang nagataw kaboi nga ara kataposan. Ang tao indi makaimo dia. Akun mga ginaambal kanindo alin sa Ispirito Santo, kag nagataw kaboi nga ara kataposan. ");
INSERT INTO clu_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Piro may dian kanindo nga ara nagatoo kanakun.” (Nagkoon tana toladia tungud nga naulaman na nga lagi kon sino-sino ang indi magtoo kag kon sino ang magatraidor kanana.) ");
INSERT INTO clu_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Kag makon na pa gid, “Maman dia ang kabangdanan kon basi nagkoon ako kanindo nga ara may makaparapit kanakun kon indi tana pagpaparapitun ang Amay.” ");
INSERT INTO clu_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ompisa dato, doro sa anang mga somolonod ni Jesus ang nagparabulag kanana kag ara run magsari tabid. ");
INSERT INTO clu_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Makon dayon ni Jesus sa anang dosi ka Apostolis, “Ta indi kamo ra magbaya kanakun?” ");
INSERT INTO clu_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Makon anang sabat ni Pedro kanana, “Ginoo, kino kami ra maayan? Ikaw lang ang nagatodlo ang parti sa kaboi nga ara kataposan. ");
INSERT INTO clu_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Kami nagatoo kanimo tungud nga naulaman namun nga ikaw maman gid anang ginpili ang Dios nga magari.” ");
INSERT INTO clu_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Makon ni Jesus kananda, “Kabay ginpili ko kamo nga dosi. Piro ang isara kanindo ginsoot ni Satanas!” ");
INSERT INTO clu_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Anang ginatomod dato ni Jesus ara iba kondi si Judas nga anang bata ni Simon Iscariote. Ay bisan kabilang sa dosi ka apostolis si Judas, tana maman ang magatraidor kay Jesus. ");
INSERT INTO clu_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Pagkatapos dato naglibot-libot si Jesus sa Galilea. Ginlikawan na nga magayan sa Judea tungud nga gosto tana nga patayun ang mga manogdomara ang mga Judio. ");
INSERT INTO clu_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Karon, ang marapit run anang pista ang mga Judio nga kon tawagun Pista ang mga Koro-kamalig, ");
INSERT INTO clu_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","gintoya-toya tana anang mga kabogto nga nagakoon, makon nanda, “Basi indi kaw magalin digi kag magayan sa Judea agud makita imong mga somolonod ang mga milagro nga imong ginaimo? ");
INSERT INTO clu_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Tungud nga kon gosto ang tao nga tana makilala ang tanan, indi na pagimoon anang mga ginaimo sa sikrito. Gani kon ikaw nakakaimo ang mga milagro, ipakita mo sa tanan!” ");
INSERT INTO clu_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","(Toladato anang koon anang mga kabogto ni Jesus ay bisan sanda gani ara ra nagtoo kanana.) ");
INSERT INTO clu_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Makon ni Jesus kananda, “Kamo poidi magimo indong gosto bisan anong oras, piro kon sa kanakun, bukun pa dia ang oras nga imoon ko akun dapat nga imoon. ");
INSERT INTO clu_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Kamo indi pagkasilagan ang mga tao digi sa kalibotan, piro ako ginakasilagan nanda ay ginaboyagyag ko ang mga malain nga andang ginaimo. ");
INSERT INTO clu_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Kamo ang magpamista. Piro ako tana indi ay bukun pa dia akun oras.” ");
INSERT INTO clu_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Pagkaambal na dia kananda nagpasala tana sa Galilea. ");
INSERT INTO clu_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Pagkalombos anang mga kabogto nga nagparamista, nagsonod ra si Jesus. Ara tana nagtabid sa kadoroan tungud nga indi na gosto nga maulaman nga doto tana. ");
INSERT INTO clu_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Doto sa pista ginpangita tana ang mga manogdomara nga mga Judio. Makon nanda, “Diin tana kabay?” ");
INSERT INTO clu_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ang mga tao tana sigi andang arampang parti kay Jesus. Makon ang iba, “Mayad tana nga tao.” Makon ra ang iba, “Bukun, ginaloko na lang ang mga tao.” ");
INSERT INTO clu_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Piro sikrito gid lang andang pagsorogidanun parti kanana, ay naadlukan sanda sa mga manogdomara nga mga Judio. ");
INSERT INTO clu_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ang nagatunga-tunga run ang pista, nagayan si Jesus sa timplo kag nagtodlo. ");
INSERT INTO clu_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Natingala nga mayad anang mga manogdomara ang mga Judio, makon nanda, “Sa diin kabay nakabuul anang kinaaraman ang tao nga dia? Ara tana gani kaiskoila.” ");
INSERT INTO clu_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Makon ni Jesus kananda, “Akun mga ginatodlo kanindo bukun kanakun alin, kondi alin sa Amay nga nagpadara kanakun. ");
INSERT INTO clu_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ang bisan sino nga gosto magtoman anang kabubutun ang Dios makaulam kon akun ginatodlo nga dia alin sa Dios okon kanakun lang. ");
INSERT INTO clu_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ang tao nga nagatodlo anang kaogalingun nga kinaaraman nagapadungug sa anang kaogalingun lang gid. Piro ang nagapadungug sa nagpadara kanana tao nga mapatian kag bukun botigun. ");
INSERT INTO clu_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Indi bala nga gintaw kanindo ni Moises ang Kasogoan? Piro ara gid bisan isara kanindo nga nagatoman ang Kasogoan, tungud nga kon nagatoman kamo basi gosto nindo ako nga patayun?” ");
INSERT INTO clu_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Makon ang mga tao, “Ginsuludan kaw sigoro ang malain nga ispirito! Ay basi sino ang gosto magpatay kanimo?” ");
INSERT INTO clu_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Makon ni Jesus, “Natingala kamo tungud nga may tao ako nga ginayad sa Adlaw nga Inogpaway. ");
INSERT INTO clu_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Piro isipa nindo bala: gintodloan kamo ni Moises nga dapat toriun nindo indong mga bata. Kon sa bagay dia ara nagompisa kay Moises kondi sa indong mga kaolang-olangan ang ona pa gid. Gani dadi, kon indong mga bata tororiun run, ginapanori nindo sanda bisan Adlaw nga Inogpaway. ");
INSERT INTO clu_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Kon ginapanori nindo ang bata sa Adlaw nga Inogpaway agud indi nindo masoway anang Kasogoan ni Moises, ta basi nasisilag kamo kanakun kon ginayad ko ang sangka tao sa Adlaw nga Inogpaway? ");
INSERT INTO clu_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Indi kamo magsari koon nga anang ginimo ang tao malain kon ara kamo makaosisa. Osisaun nindo tana anay agud maulaman nindo kon ano ang tama.” ");
INSERT INTO clu_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","May mga taga-Jerusalem nga nagkoon, “Bukun bala nga ang tao nga dia maman anang ginaingabot atun mga manogdomara nga patayun? ");
INSERT INTO clu_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Piro daya tana ra nagaambal sa mga tao, kag atun mga manogdomara ara ra nagaambal kontra kanana. Basi kon naisip nanda nga tana manda ang Cristo. ");
INSERT INTO clu_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Garing naulaman ta gid kon diin nagalin ang tao nga dia. Piro kon ang Cristo tana ang magabot ara may makaulam kon diin tana magalin.” ");
INSERT INTO clu_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ginbaskugan dayon ni Jesus anang limug doto sa timplo. Makon na, “Ta ano, kilala nindo ron gid bala kon sino ako, kag kon diin ako nagalin? Ang matood tana, ara ako nagayan digi sa kalibotan sono lang gid sa akun kaogalingun nga gosto, kondi ang matood nga Dios maman ang nagpadara kanakun. Ara nindo tana nakilala. ");
INSERT INTO clu_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Piro Ako tana, kilala ko tana, tungud nga doto ako nagalin kanana, kag tana mismo ang nagpadara kanakun.” ");
INSERT INTO clu_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Tungud sa anang ginambal nga dia ni Jesus, dakupun tana run andan anang mga manogdomara ang mga Judio. Piro ara may nagdakup kanana, ay bukun pa anang kabubutun ang Dios. ");
INSERT INTO clu_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Bisan gosto tana nga dakupun ang mga manogdomara, doro sa mga tao ang nagtoo kanana. Makon nanda, “Tana ra gid sigoro ang Cristo, ay ara may makadaug kanana sa mga milagro nga anang ginaimo.” ");
INSERT INTO clu_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Nabatian ang mga Pariseo anang mga otik-otik ang mga tao parti kay Jesus, gani sanda pati ang mga manogdomara nga mga pari nagsogo sa mga goardya nga dakupun si Jesus. ");
INSERT INTO clu_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Makon ni Jesus, “Indi run lang boay akun pagtinir digi kanindo tungud nga mabalik ako ron sa nagpadara kanakun. ");
INSERT INTO clu_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Pangitaun nindo ako, garing indi nindo ako ron makita tungud nga indi kamo makaayan sa akun arayanan.” ");
INSERT INTO clu_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Nagparamangkotan anang mga manogdomara ang mga Judio, makon nanda, “Diin tana kabay maayan nga indi ta tana makita? Ano, maayan tana sa mga siodad ang mga Griego nga anang ginaolian ang iba nga mga Judio kag magpanodlo dayon sa mga bukun Judio? ");
INSERT INTO clu_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ay basi nagkoon tana nga ‘Pangitaun nindo ako, garing indi nindo ako ron makita tungud nga indi kamo makaayan sa akun arayanan.’” ");
INSERT INTO clu_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Karon, nagabot ang kataposan nga adlaw ang pista. Maman dia ang pinakaimportanti nga adlaw ang pista para sa mga Judio. Ang adlaw nga dato nagtindug si Jesus kag nagambal mabaskug, makon na, “Ang bisan sino nga ginawaw magparapit kanakun kag maginum. ");
INSERT INTO clu_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ay nagakoon ang Kasolatan nga alin sa anang tagiposoon ang nagatoo kanakun magailig ang tobig nga nagataw kaboi.” ");
INSERT INTO clu_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","(Anang gostong ambalun ni Jesus sa tobig nga nagataw kaboi ara iba kondi ang Ispirito Santo nga madali run lang itaw sa mga tao nga nagtoo kanana. Sa oras nga dato ara pa kataw ang Ispirito Santo, tungud nga si Jesus ara pa kabalik sa langit.) ");
INSERT INTO clu_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Dorong tao ang nakabati sa anang ginambal nga dia ni Jesus, kag makon ang iba, “Dia nga tao maman run da gid ang propita nga atun ginapaabot.” ");
INSERT INTO clu_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Makon da ang iba, “Maman run dia ang Cristo!” Piro makon pa ra gid ang iba, “Bukun, ay indi maimo nga sa Galilea maalin ang Cristo. ");
INSERT INTO clu_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Kabay nagakoon ang Kasolatan nga magaalin ang Cristo sa anang kaliwat ni David, kag mababata sa banwa ang Betlehem nga anang logar ni David.” ");
INSERT INTO clu_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Gani indi magtorono ang mga tao sa andang pabutang parti kay Jesus. ");
INSERT INTO clu_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ang iba doto gosto nga dakupun tana, piro ara ra gid may nagpangaas nga magdakup kanana. ");
INSERT INTO clu_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Karon, nagbaralik ang mga goardya sa mga manogdomara nga pari kag mga Pariseo nga nagsogo kananda agud dakupun si Jesus. Pagabot ang mga goardya, makon nga lagi ang nagsogo kananda, “Basi ara nindo tana pagdakupa kag daraun digi?” ");
INSERT INTO clu_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Makon ang mga goardya, “Dadi kami lang gid nakabati sa tao nga nagaambal toladan.” ");
INSERT INTO clu_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Makon ang mga Pariseo, “Indong gostong ambalun pati kamo naloko na ra? ");
INSERT INTO clu_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","May nakita kamo nga mga Pariseo kag mga manogdomara nga nagatoo kanana? ");
INSERT INTO clu_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ara! Ang mga tao lang gid nga ara naulaman sa Kasogoan ni Moises ang nagatoo kanana. Sompaun sanda gid ang Dios.” ");
INSERT INTO clu_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Isara doto sa mga manogdomara nga dato si Nicodemo. Maman dia ang tao nga nagpakigkita kay Jesus dato anay. ");
INSERT INTO clu_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Makon na sa anang mga kaiban, “Indi bala nga kontra sa atun kasogoan ang pagsintinsya sa tao nga ara ta pa nabatian kanana mismo kon ano anang ginimo?” ");
INSERT INTO clu_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Makon nanda kay Nicodemo, “Midyo ka ra sa taga-Galilea. Osisaa bala ang Kasolatan kag makikita mo nga ara gid propita ang Dios nga magaalin sa Galilea.” ");
INSERT INTO clu_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Pagkatapos dato nagoroli sanda. ");
INSERT INTO clu_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Si Jesus tana nagayan sa Bokid ang mga Olibo. ");
INSERT INTO clu_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Pagkaaga, aga tana pa gid nagbalik sa timplo. Doro gid nga mga tao ang nagtiripon doto kanana. Gani nagpongko tana kag gintodloan na sanda. ");
INSERT INTO clu_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Karon, ang mga manogtodlo ang Kasogoan kag ang mga Pariseo may gindara doto kay Jesus nga babai nga nadakupan nga nagapanginlalaki, kag ginpatindug nanda tana sa atobangan ang tanan. ");
INSERT INTO clu_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Makon nanda dayon kay Jesus, “Manogtodlo, ang babai nga dia nadakupan sa akto mismo nga nagapanginlalaki. ");
INSERT INTO clu_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Sono sa anang Kasogoan ni Moises ang toladia nga klasi nga babai kinanglan pasilun ang bato asta mapatay. Karon, ano sa kanimo?” ");
INSERT INTO clu_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Toladato andang pamangkot tungud nga ginatirawan nanda si Jesus, agud nga kon magsala tana sa anang sabat may akosasyon sanda run kontra kanana. Garing anang ginimo ni Jesus, nagkatin-katin tana kag nagsolat anang todlo sa yabok. ");
INSERT INTO clu_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Piro tungud nga sigi pa ra gid andang pamangkot kanana, nagtindug si Jesus kag nagkoon kananda, “Kon sino kanindo ang ara sala maman ang magona pasil kanana ang bato.” ");
INSERT INTO clu_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Pagkaambal na dato, nagkatin-katin tana ruman kag nagsolat sa yabok. ");
INSERT INTO clu_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Pagkabati dato ang mga manogtodlo ang Kasogoan kag ang mga Pariseo, isara-isara sanda nga nagalin ompisa sa pinakamalam, asta nga ang nasala run lang ara iba kondi si Jesus kag ang babai nga nagatindug doto. ");
INSERT INTO clu_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Nagtindug si Jesus kag makon na sa babai, “Ta diin sanda run? Ara gid may nagsintinsya kanimo?” ");
INSERT INTO clu_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Makon ang babai, “Ara.” Makon ni Jesus kanana, “Ako ara ra nagasintinsya kanimo. Pagoli run. Piro indi ka run da magoman pakasala.” ");
INSERT INTO clu_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Makon roman ni Jesus sa mga tao, “Ako ang solo nga nagataw kasanag sa isip ang mga tao. Ang nagasonod kanakun anang isip bukun madulum, kondi nasasanagan tana ang solo nga nagataw kaboi nga ara kataposan.” ");
INSERT INTO clu_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Pagkabati dato ang mga Pariseo, makon nanda, “Ikaw ra lang ang nagasogid parti sa imong kaogalingun, gani indi kaw mapatian.” ");
INSERT INTO clu_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Makon ni Jesus kananda, “Bisan matood nga nagasogid ako parti sa akun kaogalingun, akun ginasogid matood, tungud nga naulaman ko akun ginalinan kag akun paayanan. Piro kamo tana ara kaulam kon sa diin ako nagalin kag kon sa diin ako maayan. ");
INSERT INTO clu_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Indong pagsintinsya indi masarigan tungud nga sono lang gid sa anang isip ang tao. Ako tana ara nagasintinsya bisan kino. ");
INSERT INTO clu_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Piro kon ako ron da gid ang magsintinsya, akun sintinsya osto, tungud nga bukun lang gid ako ang magasintinsya kondi darwa kami, ako kag ang Amay nga nagpadara kanakun. ");
INSERT INTO clu_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Kabay nasolat sa indong Kasogoan nga kon magsinanto anang sogid ang darwa ka tao, andang sogid matood. ");
INSERT INTO clu_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ako nagapamatood parti sa akun kaogalingun kag ang Amay nga nagpadara kanakun nagapamatood ra parti kanakun.” ");
INSERT INTO clu_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Makon ang mga Pariseo kanana, “Ta sa diin imong tatay?” Makon ni Jesus, “Ara kamo kakilala kanakun okon sa akun Tatay. Kon nakilala nindo ako, makikilala nindo ra akun Tatay.” ");
INSERT INTO clu_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Dia tanan ginambal ni Jesus ang nagatodlo tana sa timplo, marapit sa ginadipositoan ang koarta. Piro ara may nagdakup kanana, ay bukun pa anang kabubutun ang Dios. ");
INSERT INTO clu_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Makon roman ni Jesus sa mga manogdomara ang mga Judio, “Mapanaw ako, kag kon ara ako ron digi pangitaun nindo ako, piro magakarapatay kamo lang nga indong mga sala ara napatawad. Kag indi kamo makaayan sa akun ayanan.” ");
INSERT INTO clu_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Gani makon ang mga Judio nga nagaarampang, “Ano kabay anang gostong ambalun dato? Kita kono indi makaayan sa anang ayanan. Ano kabay, mapangugut tana?” ");
INSERT INTO clu_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Makon ni Jesus kananda, “Kamo taga-digi sa kalibotan, piro ako tana taga-langit. Kamo alin digi sa idalum, ako tana alin sa ibabaw. ");
INSERT INTO clu_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Maman dan nga nagkoon ako kanindo nga magakarapatay kamo lang nga indong mga sala ara napatawad. Ay kon indi kamo magtoo nga ako ang Cristo, sigorado nga magakarapatay kamo lang gid nga indong mga sala ara napatawad.” ");
INSERT INTO clu_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Makon nanda, “Basi, sino ka gid ay?” Makon ni Jesus, “Ginsogidan ko kamo ron kabay alin pa ang ona kon sino ako. ");
INSERT INTO clu_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Doro akun inogambal kontra sa indong mga ginaimo. Sa matood tana, ang mga butang nga akun ginasogid sa mga tao ara iba kondi ang mga butang lang nga ginapaambal kanakun ang nagpadara kanakun. Kag ang tanan nga anang ginaambal matood kag masasarigan.” ");
INSERT INTO clu_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ara sanda kasatum nga ang nagpadara kanana nga anang ginakoon ay ang Amay mismo. ");
INSERT INTO clu_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Gani makon ni Jesus kananda, “Kon Ako nga Naging Tao maipabutang nindo ron sa kaoy kag ibandira, dan bago nindo maulaman nga ako manda ang Cristo. Sa oras nga dato maulaman nindo ra nga ang tanan nga akun ginaimo kag ginasogid ara iba kondi ang mga butang nga ginapaimo kag ginapasogid kanakun ang Amay. ");
INSERT INTO clu_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ang nagpadara kanakun kaiban ko pirmi kag ara na ako gid ginapabayani, tungud nga kon ano anang gosto maman da akun ginaimo.” ");
INSERT INTO clu_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Pagkabati ang mga tao sa anang mga ginaambal nga dato ni Jesus, doro kananda ang nagtoo kanana. ");
INSERT INTO clu_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Karon, makon ni Jesus sa mga Judio nga nagtoo kanana, “Kon padayon kamo nga nagatoman akun mga ginatodlo, dan mga somolonod ko kamo nga matood. ");
INSERT INTO clu_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Maulaman nindo ang kamatoodan kag ang kamatoodan maman ang magalibri kanindo.” ");
INSERT INTO clu_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Makon nanda kanana, “Anang mga kaliwat kami ni Abraham, kag ara pa gid may nakaoripun kanamun. Basi nakakoon kaw nga malilibri kami?” ");
INSERT INTO clu_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Makon ni Jesus, “Ang matood tana, ang bisan sino nga nagapakasala, oripun ang sala. ");
INSERT INTO clu_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Maimo nga paalinun ang oripun sa balay nga anang ginaolian, piro ang bata tana pirmaninti doto. ");
INSERT INTO clu_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Gani kon ako nga anang Bata ang Dios maman ang maglibri kanindo, maging libri kamo gid tana sa sala nga nagaoripun kanindo. ");
INSERT INTO clu_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Naulaman ko nga kamo anang mga kaliwat ni Abraham, garing ginaimoratan nindo ako nga patayun tungud nga indi nindo gosto akun mga panodlo. ");
INSERT INTO clu_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ginasogid ko kanindo ang mga butang nga akun nakita sa Amay; kamo tana, ginaimo nindo indong nabatian sa indong tatay.” ");
INSERT INTO clu_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Makon nanda kay Jesus, “Amun tatay gid nga ginalinan si Abraham.” Makon ni Jesus, “Kon kamo anang mga kaliwat ni Abraham, andan ginaimo nindo ang mayad pario anang mga ginimo. ");
INSERT INTO clu_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Piro indong ginaimo tana, ginaimoratan nindo nga patayun ako, bisan ara ako may ginimo kondi nagsogid ako ra lang kanindo ang kamatoodan nga akun nabatian sa Dios. Ara gid kaimo si Abraham pario indong ginaimo. ");
INSERT INTO clu_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Indong ginaimo maman da anang ginaimo indong tatay.” Makon nanda, “Bukun kami mga bata sa loas. Ang Dios maman amun tatay.” ");
INSERT INTO clu_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Makon ni Jesus kananda, “Kon matood nga ang Dios maman indong tatay, andan palanggaun nindo ako, ay ako nagalin sa Dios. Ara ako nagayan digi sa kalibotan sa akun kagostoan lang, kondi tana maman ang nagpadara kanakun. ");
INSERT INTO clu_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Indi nindo maintindian akun mga ginaambal tungud nga indi nindo pagbatonon akun ginatodlo kanindo. ");
INSERT INTO clu_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Si Satanas maman indong tatay, kag kon ano anang gosto indong tatay nga si Satanas maman da indong gosto nga imoon. Manogpatay tao si Satanas ompisa pa ang ona. Ara kointa kanana ang kamatoodan tungud nga ara gid kamatoodan kanana. Ogali na ang magbotig, tungud nga botigun tana kag tana maman ang ginaalinan ang tanan nga kabotigan. ");
INSERT INTO clu_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Piro ako tana, ang kamatoodan maman akun ginasogid kanindo, kag maman dan nga indi kamo magpati kanakun. ");
INSERT INTO clu_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Sino kanindo ang makapamatood nga nakaimo ako sala? Ara gid! Ta basi indi kamo magpati kanakun kon nagasogid ako ang kamatoodan? ");
INSERT INTO clu_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Anang mga bata ang Dios nagapati sa anang ambal ang Dios. Piro tungud nga bukun kamo anang mga bata ang Dios, maman dan nga indi kamo magpati kanakun.” ");
INSERT INTO clu_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Anang mga manogdomara ang mga Judio nagsabat kay Jesus, makon nanda, “Matood manda gali amun koon nga minos kaw nga tao pario sa mga taga-Samaria, kag ginsuludan kaw ang malain nga ispirito.” ");
INSERT INTO clu_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Makon ni Jesus, “Ara malain nga ispirito nga nagsoot kanakun. Ginapadungugan ko lang akun Tatay, piro kamo tana, ginapakauyan nindo ako. ");
INSERT INTO clu_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ara ako nagaangad kadungganan para sa akun kaogalingun. Ang Amay maman ang nagaangad nga ako padungugan ang mga tao, kag naulaman na nga matood ang mga butang nga akun ginasogid. ");
INSERT INTO clu_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Tandaan nindo: ang mga nagatoman akun mga panodlo indi run gid mapatay.” ");
INSERT INTO clu_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Makon ang mga Judio kanana, “Dadi sigorado kami run gid nga ginsuludan kaw ang malain nga ispirito. Bisan si Abraham napatay, kag ang mga propita nagkarapatay ra. Piro nagakoon kaw nga ang nagatoman imong mga panodlo indi run gid mapatay asta kon sano. ");
INSERT INTO clu_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ano, mas mayad kaw pa kay Abraham? Tana napatay. Ang mga propita nagkarapatay ra. Basi sino ka gid ay?” ");
INSERT INTO clu_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Makon ni Jesus kananda, “Kon ako lang gid ang magpadungug sa akun kaogalingun, ara kointa dan. Piro akun Tatay maman gid tana ang nagapadungug kanakun. Tana maman da indong ginakoon nga indong Dios. ");
INSERT INTO clu_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Garing ara nindo tana makilala. Piro ako tana, kilala ko tana. Karon, kon magkoon ako nga ara ako kakilala kanana, magagoa nga ako botigun pario kanindo. Piro ang matood tana kilala ko tana gid kag ginatoman ko anang mga ambal. ");
INSERT INTO clu_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Nalipay nga mayad indong kaolang-olangan nga si Abraham pagkaulam na nga ako maayan digi sa kalibotan. Kag dadi nakita na nga ako digi run kag nalilipay tana gid.” ");
INSERT INTO clu_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Makon ang mga Judio kanana, “Paiwan imong pagkakita kay Abraham ay ara pa gani singkwinta imong idad?” ");
INSERT INTO clu_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Makon ni Jesus, “Sa matood tana, ang ara pa mabata si Abraham, ako ron nga lagi.” ");
INSERT INTO clu_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Tungud sa anang ginambal nga dato ni Jesus nagporot sanda bato agud pasilun tana. Garing nagpanliut-liut si Jesus kag nagalin doto sa timplo. ");
INSERT INTO clu_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Mintras nagapanaw sanday Jesus, may nakita sanda nga tao nga bolag alin pa anang pagkabata. ");
INSERT INTO clu_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Karon ginpamangkot si Jesus anang mga somolonod, makon nanda, “Manogtodlo, tungud nga tana nabata nga bolag, sino kabay ang nagkasala? Tana okon anang mga ginikanan?” ");
INSERT INTO clu_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Makon ni Jesus, “Bukun! Anang pagkabolag bukun nga makon tungud sa anang sala okon sa sala anang mga ginikanan, kondi para makita ang mga tao anang gaum ang Dios paagi sa pagayad kanana. ");
INSERT INTO clu_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Kabay ang tao nagaobra kon adlaw ay kon gabi indi tana run makaobra. Akun gostong ambalun, dapat ta nga imoon anang ginapaimo ang Dios nga nagpadara kanakun mintras maiimo ta pa. Ay magaabot ang oras nga indi ta run maimo anang ginapaimo. ");
INSERT INTO clu_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Mintras digi ako sa kalibotan ako ang pinakasolo nga nagataw sanag sa tanan nga mga tao.” ");
INSERT INTO clu_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Pagkaambal na dato dayon tanang pandora sa logta. Ginsampora na ang logta sa anang dora kag ginbutang sa anang mata ang bolag. ");
INSERT INTO clu_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Makon na dayon sa bolag, “Ta pagayan sa pararigosan sa Siloam kag magpangramos doto.” (Anang gostong ambalun ang Siloam “Ginpadara”.) Gani ang bolag nga dato nagayan sa Siloam kag nagpangramos. Pagkatapos dayon tanang balik kag nakakikita run. ");
INSERT INTO clu_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Makon anang mga kamalay kag ang mga tao nga nakakita anay kanana nga nagapakilimos, “Bukun bala nga ang tao nga dia maman anay ang nagasari pongko nga nagapakilimos?” ");
INSERT INTO clu_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Makon ang iba, “Maman!” Piro makon da ang iba, “Bukun! Magkaitsora sanda lang.” Gani makon ang tao nga dato mismo, “Ako gid tana ang tao nga indong ginakoon.” ");
INSERT INTO clu_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Karon, ginpamangkot nanda tana, makon nanda, “Ta paiwan nagayad imong mata?” ");
INSERT INTO clu_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Makon na, “Ang tao nga andang ginatawag nga si Jesus nagimo lapok. Pagkatapos ginbutang na sa akun mata. Kag ginkonan na ako dayon nga magayan sa pararigosan ang Siloam kag magpangramos. Gani nagayan ako ra doto kag pagkatapos nga ako nagpangramos nakakita ako ron.” ");
INSERT INTO clu_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ginpamangkot nanda tana kon diin run ang tao nga nagayad kanana. Makon na, “Ilam, ara ako kaulam.” ");
INSERT INTO clu_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Gindara nanda dayon ang tao nga dato nga dati bolag sa mga Pariseo. ");
INSERT INTO clu_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Adlaw dato nga Inogpaway ang magsampora si Jesus ang logta kag dora kag nagayad anang mata ang tao nga bolag. ");
INSERT INTO clu_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Gani ginpamangkot tana ra ang mga Pariseo kon paiwan nagayad anang mata. Kag ginsogidan na sanda, makon na, “Ginbutangan ni Jesus lapok akun mata kag pagkatapos nagpangramos ako kag dadi nakakikita ako ron.” ");
INSERT INTO clu_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","May mga Pariseo nga nagkoon, makon nanda, “Ang tao nga nagimo dia bukun alin sa Dios, tungud nga ara tana nagatoman ang Kasogoan sa Adlaw nga Inogpaway.” Piro makon ang iba, “Kon tana tao nga makasasala indi tana makaimo ang mga milagro nga pario dia.” Gani indi sanda magtorono. ");
INSERT INTO clu_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Nagpamangkot pa gid ang mga Pariseo sa tao nga dati bolag, makon nanda, “Ikaw ginayad na, ta ano sa kanimo ang tao nga dato?” Makon na, “Kon sa kanakun, propita tana.” ");
INSERT INTO clu_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Piro ang mga manogdomara ang mga Judio indi magpati nga tana dati nga bolag nga dadi nakakikita run, gani ginpatawag nanda anang mga ginikanan. ");
INSERT INTO clu_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Pagkatapos ginpamangkot nanda, makon nanda, “Indong bata dia? Matood ra gid bala nga nabata tana nga bolag? Basi dadi nakakikita tana run?” ");
INSERT INTO clu_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Makon anang mga ginikanan, “Amun bata manda dia, kag matood nga ginbata tana nga bolag. ");
INSERT INTO clu_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Piro kon paiwan nagayad anang mga mata kag kon sino ang nagpaayad kanana, dan ang ara kami kaulam. Pamangkota nindo tana ay may buut tana run da kag makasabat para sa anang kaogalingun.” ");
INSERT INTO clu_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Toladia anang sabat anang mga ginikanan tungud nga naadlukan sanda sa mga manogdomara ang mga Judio. Ay anang mga manogdomara nga dia ang mga Judio nagkarasogot ron nga lagi nga ang bisan sino nga magkilala kay Jesus nga tana ang Cristo indi nanda run pagpasuludun sa andang simbaan. ");
INSERT INTO clu_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Maman dan nga makon anang mga ginikanan, “Pamangkota nindo tana ay may buut tana run da.” ");
INSERT INTO clu_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Gani gintawag nanda ruman ang tao nga dato nga dati bolag. Makon nanda, “Abi pagsogid ang matood parti sa tao nga dato, ay ang Dios nagapamati. Kon sa kanamun naulaman namun nga tana makasasala.” ");
INSERT INTO clu_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Makon anang sabat ang tao, “Ara ako kaulam kon makasasala tana okon bukun. Basta naulaman ko nga ang ona bolag ako piro dadi tana kakikita ako ron.” ");
INSERT INTO clu_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Makon nanda ruman, “Ano anang ginimo kanimo? Paiwan na ginayad imong mata?” ");
INSERT INTO clu_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Makon na, “Ginsogidan ko kamo ron kabay, piro indi kamo magpamati. Ta basi nagapamangkot kamo roman? Ano, gosto nindo ra nga maging anang mga somolonod?” ");
INSERT INTO clu_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Gani nasilag sanda kag ginboyayaw nanda tana, makon nanda, “Ikaw maman anang somolonod, kami tana anang mga somolonod ni Moises. ");
INSERT INTO clu_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Naulaman namun nga nagpakigambal ang Dios kay Moises ang ona, piro kon parti sa tao nga dan, ara kami gani kaulam kon diin tana nagalin!” ");
INSERT INTO clu_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Makon dayon ang tao, “Ano ron dan! Tana ang nagayad kanakun, pagkatapos nagakoon kamo nga ara kamo kaulam kon sa diin tana nagalin. ");
INSERT INTO clu_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Naulaman ta nga ara nagasabat ang Dios sa mga makasasala. Piro ginasabat na ang mga tao nga nagataod kanana kag nagatoman anang kabubutun. ");
INSERT INTO clu_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Alin ang magompisa ang kalibotan ara kita pa gid kabati nga may tao nga nakaayad anang mata ang tao nga bolag alin anang pagkabata. ");
INSERT INTO clu_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Kon ara tana nagalin sa Dios, indi tana makaimo toladia.” ");
INSERT INTO clu_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Makon anang sabat ang mga manogdomara nga mga Judio, “Nabata kaw kag nagbaul sa sala, kag dadi todloan mo pa kami?” Kag ginkonan nanda tana nga indi tana run pagtogotan nga magsulud sa andang mga simbaan. ");
INSERT INTO clu_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Karon, nabaritaan ni Jesus nga ginpaalin nanda ang tao nga dati bolag sa andang simbaan. Gani ginsagap na ang tao. Pagkakita na kanana ginpamangkot na, makon na, “Nagatoo kaw sa anang Bata ang Dios nga Naging Tao?” ");
INSERT INTO clu_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Makon ang tao nga dato, “Sogidi ako ra kon sino tana agud makatoo ako kanana!” ");
INSERT INTO clu_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Makon ni Jesus, “Nakita mo tana run, ay tana mismo ang nagapakigambal nga dia kanimo.” ");
INSERT INTO clu_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Makon dayon ang tao, “Ginoo, nagatoo ako kanimo!” Kag naglood tana dayon kag nagsimba kay Jesus. ");
INSERT INTO clu_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Makon ni Jesus, “Ako nagayan digi sa kalibotan agud sintinsyaan ang mga tao. Ang mga tao nga nakaulam nga sanda bolag tungud nga naduluman andang mga isip bolongon ko agud makakita. Kag ang mga tao nga nagakoon nga sanda bukun bolag kondi masanag kono andang isip, magagoa nga sanda maman ang bolag.” ");
INSERT INTO clu_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Karon, may mga Pariseo doto sa andang marapit nga nakabati sa anang ginaambal ni Jesus. Makon nanda, “Ano imong gostong ambalun, pati kami bolag ra?” ");
INSERT INTO clu_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Makon ni Jesus kananda, “Kon ginabaton nindo nga kamo bolag kag indi kaintindi, ara kamo andan sala. Piro tungud nga kamo nagakoon nga kamo bukun bolag ay nakakaintindi, nagakaologan lang nga may sala kamo pa ra gid.” ");
INSERT INTO clu_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Nagsaysay si Jesus kananda paagi sa paanggid, makon na, “Sa matood tana, kon ang tao nagasulud sa toril ang mga karniro piro ara nagaagi sa poirtaan kondi nagatakras sa kodal, dan nga tao takawan kag tolisan. ");
INSERT INTO clu_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ang tao tana nga nagasulud sa poirtaan maman ang matood nga manogbantay ang mga karniro. ");
INSERT INTO clu_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ginapasulud tana ang bantay sa poirtaan kag anang limug nakikilala ang mga karniro. Ginatawag na anang mga karniro sa andang mga aran, kag ginadara na sanda dayon sa goa. ");
INSERT INTO clu_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Pagkatapos nagaona tana, kag anang mga karniro nagasonod kanana tungud nga kilala nanda anang limug. ");
INSERT INTO clu_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Indi magsonod ang mga karniro sa tao nga indi nanda makilala, kondi magapalagyaw gani tungud nga ara sanda kakilala sa anang limug.” ");
INSERT INTO clu_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ginsogid kananda ni Jesus ang paanggid nga dia, piro ara sanda gid kaintindi kon ano anang gostong ambalun. ");
INSERT INTO clu_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Gani makon ni Jesus, “Ang matood tana, ako ang pinakapoirtaan nga ginaagian ang mga tao nga maman ang mga pinakakarniro. ");
INSERT INTO clu_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","May mga naona kanakun nga mga manogtodlo nga andang kaalimbawa pario mga takawan kag mga tolisan. Piro akun mga karniro ara nagpati kananda. ");
INSERT INTO clu_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ako maman ang poirtaan. Ang nagasulud paagi kanakun malowas. Pario tana sa karniro nga nagasulud kag nagagoa kag nakakikita ang parangaraban. ");
INSERT INTO clu_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ang takawan nagasulud lang sa kolongan agud magpanakaw, magrangga, kag magpatay. Piro ako tana nagayan digi sa kalibotan agud matawan ko ang mga tao kaboi nga ara kataposan kag ara gid kolang. ");
INSERT INTO clu_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Ako maman ang mayad nga manogbantay ang mga karniro. Ang mayad nga manogbantay disidido nga magpanginmatay para sa anang mga karniro. ");
INSERT INTO clu_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Bukun tana pario sa tao nga ginasoolan lang nga magbantay. Ay ang tao nga ginasoolan lang magapalagyaw kon makita na nga nagaabot ang manogpanukub nga sapat, kag bayaan na lang ang mga karniro. Gani magarapta ang mga karniro kag ang iba tutukubun. ");
INSERT INTO clu_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Nagapalagyaw tana tungud nga ginasoolan tana ra lang gani kag bali ara kanana kon ano ang matabo sa mga karniro. ");
INSERT INTO clu_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Piro ako tana, mayad nga manogbantay ang mga karniro. Kon paiwan anang pagkakilala kanakun ang Amay kag akun pagkakilala kanana, toladan ra akun pagkakilala sa akun mga karniro kag andang pagkakilala kanakun. Kag itaw ko akun kaboi para kananda. ");
INSERT INTO clu_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","May iba ako pa ra nga mga karniro nga ara digi sa indong gropo bilang mga Judio. Dapat pasuludun ko sanda ra. Magapamati sanda ra kanakun, kag ang tanan nga nagapamati kanakun maging sangka gropo ron lang nga may sangka manogbantay. ");
INSERT INTO clu_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Ginapalangga ako ang Amay tungud nga magapanginmatay ako para kananda, kag pagkatapos maboboi ako roman. ");
INSERT INTO clu_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ara may makapatay kanakun kon indi ko itogot. Piro ginabolontad ko akun kaboi. Pagosto ako sa pagbolontad akun kaboi, kag pagosto ako ra kon bawiun ko. Maman dia anang koon ang Amay kanakun.” ");
INSERT INTO clu_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Tungud sa anang ginambal nga dato ni Jesus nagsoroag-soagan ruman ang mga Judio. ");
INSERT INTO clu_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Doro kananda ang nagkoon, “Ang tao nga dan ginsuludan ang malain nga ispirito kag omang-omang. Basi nagasari kamo pamati kanana?” ");
INSERT INTO clu_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Piro makon da ang iba, “Ang tao nga ginsuludan ang malain nga ispirito indi makatodlo pario dan. Kag isara pa, ang tao nga ginsuludan ang malain nga ispirito indi makapaayad sa anang mata ang tao nga bolag.” ");
INSERT INTO clu_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Karon, nagabot sa Jerusalem ang tyimpo anang pista ang mga Judio parti sa andang pagdumdum ang pagdidikar ang timplo sa Dios. Tigraramig dato, ");
INSERT INTO clu_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","kag si Jesus nagapanaw-panaw doto sa timplo sa ginatawag nga Balkon ni Solomon. ");
INSERT INTO clu_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Nagtiripon ang mga Judio doto kanana kag magkoon, makon nanda, “Basi ginatago-tago mo pa gid kanamun kon sino kaw? Sogidi kami ang diritso kon ikaw manda ang Cristo.” ");
INSERT INTO clu_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Makon ni Jesus kananda, “Ginsogidan ko kamo ron kon sino ako piro indi kamo magpati kanakun. Ang mga milagro nga ginapaimo kanakun ang Amay nagapamatood ra kon sino ako. ");
INSERT INTO clu_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Piro indi kamo magpati kanakun tungud nga bukun kamo kabilang sa akun mga karniro. ");
INSERT INTO clu_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ang akun nagapamati kanakun. Kilala ko sanda kag nagasonod sanda kanakun. ");
INSERT INTO clu_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ginatawan ko sanda kaboi nga ara kataposan, kag indi sanda gid mapatay. Ara gid may makaagaw kananda sa akun alima. ");
INSERT INTO clu_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Gintaw sanda kanakun ang Amay nga gamanan sa tanan, kag ara gid may makaagaw kananda sa anang alima ang Amay. ");
INSERT INTO clu_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ako kag ang Amay isara lang.” ");
INSERT INTO clu_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Pagkabati dato ang mga Judio nagporot sanda ruman ang mga bato agud pasilun tana. ");
INSERT INTO clu_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Piro makon ni Jesus kananda, “Doro akun ginimo nga mayad nga nakita nindo mismo. Kag dato ginpaimo kanakun ang Amay. Diin sa akun mga ginpangimo nga dato ang kabangdanan nga ako papasilun nindo?” ");
INSERT INTO clu_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Makon ang mga Judio, “Indi kami magpasil kanimo tungud sa imong mayad nga mga inimoan, kondi pasilun kaw namun tungud nga ikaw nagaambal kontra sa Dios! Ay ikaw tao ra lang piro nagakoon kaw nga ikaw Dios.” ");
INSERT INTO clu_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Makon ni Jesus kananda, “Kabay nasolat sa indong Kasogoan nga nagkoon ang Dios nga kamo mga dios. ");
INSERT INTO clu_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","36","Kag naulaman ta nga matood pirmi kon ano anang ginakoon ang Kasolatan. Gani kon nagkoon ang Dios nga mga dios ang mga tao nga anang gintawan anang minsai, ta basi nagakoon kamo nga ako nagaambal kontra sa Dios tungud nga nagkoon ako nga ako anang Bata ang Dios? Tana mismo ang nagpili kag nagpadara kanakun digi sa kalibotan. ");
INSERT INTO clu_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Kon ara ako nagaimo anang ginapaimo ang Amay kanakun, dapat indi kamo magpati kanakun. ");
INSERT INTO clu_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Piro kon ginaimo ko anang ginapaimo ang Amay, bisan indi nindo gosto nga magpati sa akun mga ginakoon, dapat patian nindo tungud sa akun mga inimoan, agud maulaman nindo gid nga ang Amay digi kanakun kag ako kanana.” ");
INSERT INTO clu_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ginimoratan nanda ruman nga dakupun si Jesus, piro nakalikaw tana kananda. ");
INSERT INTO clu_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Nagtabok roman si Jesus sa soba ang Jordan kag nagayan tana sa logar nga doto nagpangbunyag si Juan. Kag doto tana dayon nagtinir. ");
INSERT INTO clu_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Dorong mga tao ang nagarayan doto kanana. Makon nanda, “Ara matood nakaimo mga milagro si Juan, piro ang tanan nga anang ginambal parti sa tao nga dia matood.” ");
INSERT INTO clu_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Gani doro sa mga tao doto ang nagtoo kay Jesus. ");
INSERT INTO clu_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","May sangka tao nga anang aran si Lazaro. Tana kag anang mga kabogto nga si Maria kag si Marta nagaoli sa Betania. Ang Maria nga dia maman ang nagbobo ang agoa sa anang siki ni Ginoong Jesus kag anang book maman anang gingamit nga paraid. Anang kabogto nga si Lazaro nagmasakit. ");
INSERT INTO clu_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Gani ang magkabogto nga babai nagpadara barita kay Jesus nga anang pinalangga nga amigo nagamasakit. ");
INSERT INTO clu_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Pagkabati ni Jesus nga si Lazaro nagamasakit, makon na, “Indi tana mapatay sa anang masakit nga dato, kondi ang katoyoan tana nga tana nagamasakit ay agud mapadungugan ang Dios tungud sa anang gaum kag agud Ako nga anang Bata ang Dios mapadungugan ra.” ");
INSERT INTO clu_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Palangga ni Jesus si Marta, si Maria, kag si Lazaro. ");
INSERT INTO clu_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Piro pinalubas na pa ang darwa ka adlaw pagkatapos nga anang nabaritaan nga si Lazaro nagamasakit. ");
INSERT INTO clu_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Pagkatapos makon na sa anang mga somolonod, “Amos, mabalik kita run sa probinsya ang Judea.” ");
INSERT INTO clu_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Makon anang mga somolonod, “Manogtodlo, kabay pira pa lang ka adlaw nga ginbato kaw andan doto ang mga Judio. Dadi mabalik ka ruman?” ");
INSERT INTO clu_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Makon ni Jesus, “Indi bala nga may dosi ka oras ang sang adlaw? Gani kon ang tao magpanaw kon adlaw indi tana makasandad, tungud nga masanag pa. ");
INSERT INTO clu_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Piro kon gabi tana magpanaw makakasandad tana ay madulum.” ");
INSERT INTO clu_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","(Ginaambal ni Jesus ang paanggid nga dia agud ipasanag kananda nga ara pa may matabo nga malain kananda doto sa Judea.) Pagkatapos makon pa ni Jesus, “Atun amigo nga si Lazaro nagakatorog. Ayanan ko tana kag pokawon.” ");
INSERT INTO clu_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Nagsabat anang mga somolonod, makon nanda, “Ginoo, kon tana nagakatorog, magaayad tana.” ");
INSERT INTO clu_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Andang pagsarig nagakatorog matood si Lazaro, piro anang gostong ambalun tana ni Jesus si Lazaro patay run. ");
INSERT INTO clu_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Gani ginpasanag ni Jesus anang koon, makon na, “Patay run si Lazaro. ");
INSERT INTO clu_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Piro nagapasalamat ako nga ara ako doto ay para dia sa indong kaarayadan, tungud nga may imoon ako agud magdogang indong pagtoo kanakun. Dali, ayanan ta tana.” ");
INSERT INTO clu_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Karon, si Tomas nga ginatawag nga si Kapid nagkoon sa anang mga kaiban, “Ta, matabid kita run lang abir patayun kita ra kaiban na.” ");
INSERT INTO clu_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Pagabot ni Jesus sa Betania, nabaritaan na nga apat run ka adlaw nga nakalubung si Lazaro. ");
INSERT INTO clu_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Mga tatlo lang ka kilomitro ang Betania sa Jerusalem. ");
INSERT INTO clu_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Gani dorong mga Judio nga taga-Jerusalem ang nagarayan doto agud lipayun si Marta kag si Maria sa pagkapatay andang kabogto. ");
INSERT INTO clu_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Pagkabati ni Marta nga nagaabot si Jesus, gomoa tana kag nagsolang-solang kanana, piro si Maria tana nagpasala sa balay. ");
INSERT INTO clu_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Pagabot ni Marta kay Jesus, makon na, “Ginoo, kon digi kaw, andan ara napatay akun kabogto. ");
INSERT INTO clu_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Piro naulaman ko nga bisan dadi, bisan ano imong pangayoon sa Dios itaw na kanimo.” ");
INSERT INTO clu_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Makon ni Jesus kanana, “Mababanaw imong kabogto.” ");
INSERT INTO clu_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Makon ni Marta, “Naulaman ko nga mababanaw tana sa ori nga adlaw kon banawon ron ang mga patay.” ");
INSERT INTO clu_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Makon ni Jesus kanana, “Ako ang nagabanaw ang mga patay, kag ako ra ang nagataw kaboi. Ang nagatoo kanakun, bisan mapatay maboboi ruman. ");
INSERT INTO clu_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ang bisan sino nga naboboi kag nagatoo kanakun indi mapatay asta sa ara kataposan. Ta nagapati kaw dia?” ");
INSERT INTO clu_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Makon ni Marta, “Uu, Ginoo! Nagapati ako nga ikaw ang Cristo, anang Bata ang Dios nga amun ginaulat nga magaabot digi sa kalibotan.” ");
INSERT INTO clu_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Pagkaambal dato ni Marta, bomalik tana sa andang balay kag gintawag na anang kabogto nga si Maria. Ginotikan na tana dayon, makon na, “Dian run ang Manogtodlo kag ginapatawag kaw.” ");
INSERT INTO clu_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Pagkabati dato ni Maria, tomindug tana kag magdali-dali goa kag nagayan doto kay Jesus. ");
INSERT INTO clu_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","(Si Jesus gali ara pa gid kasulud sa bario ang Betania. Doto tana pa sa logar nga ginkitaan nanda ni Marta.) ");
INSERT INTO clu_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Pagkakita ang mga Judio nga nagalipay kay Maria nga nagtindug tana kag dali-dali nga naggoa, somonod sanda ay andang pagsarig maayan tana sa ginlubungan agud magpanangis doto. ");
INSERT INTO clu_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Pagabot ni Maria doto kay Jesus, naglood tana kag nagkoon, “Ginoo, kon digi kaw, andan ara napatay akun kabogto.” ");
INSERT INTO clu_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Pagkakita ni Jesus nga nagapanangis si Maria pati anang kaiban nga mga Judio, nagngitngit nga mayad anang tagiposoon. ");
INSERT INTO clu_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Nagpamangkot tana dayon kananda, makon na, “Diin nindo tana ginlubung?” Makon nanda, “Ginoo, amos, itodlo namun kanimo.” ");
INSERT INTO clu_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Nagtangis si Jesus. ");
INSERT INTO clu_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Gani makon ang mga Judio, “Palangga na gid matood si Lazaro.” ");
INSERT INTO clu_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Piro makon ang iba, “Indi bala nga ginayad na anang mga mata ang bolag? Ta basi ara na mapaiwas anang kamatayun ni Lazaro?” ");
INSERT INTO clu_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Nagngitngit ruman anang tagiposoon ni Jesus. Kag nagayan sanda dayon doto sa ginlubungan kay Lazaro. Sangka giub dato nga ginatakluban ang bato. ");
INSERT INTO clu_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Pagabot nanda doto, makon ni Jesus, “Bula nindo anang takup nga bato.” Piro makon ni Marta nga anang kabogto ang napatay, “Ginoo, maboro tana run dadi, ay apat run ka adlaw nga tana ginlubung!” ");
INSERT INTO clu_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Makon ni Jesus kanana, “Indi bala nga nagkoon ako kanimo nga kon nagtoo kaw, makikita mo anang gaum ang Dios?” ");
INSERT INTO clu_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Gani ginbuul nanda ang bato. Nagtangra si Jesus sa langit kag magkoon, “Amay, nagapasalamat ako kanimo tungud nga ginsabat mo akun pangabay kanimo. ");
INSERT INTO clu_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Naulaman ko nga pirmi mo ako nga ginapamatian, piro nagakoon ako toladia kanimo dadi para sa mga tao nga digi dadi sa akun palibot, agud magpati sanda nga ikaw manda ang nagpadara kanakun digi sa kalibotan.” ");
INSERT INTO clu_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Pagkatapos nga makaambal tana toladia nagsinggit tana, makon na, “Lazaro, paggoa!” ");
INSERT INTO clu_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Kag naggoa manda ang napatay nga si Lazaro nga anang alima kag anang siki may nagabarubud nga mga panaptun kag anang itsora napotos ra ang panyo. Makon ni Jesus kananda, “Badbadi nindo tana kag papanawon.” ");
INSERT INTO clu_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Doro sa mga Judio nga nagbisita kanday Maria ang nagtoo kay Jesus pagkakita nanda sa anang ginimo. ");
INSERT INTO clu_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Piro may mga doto ra nga pagalin nanda kanday Maria, nagdiritso sanda sa mga Pariseo kag nagsogid anang ginimo ni Jesus. ");
INSERT INTO clu_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Gani ang mga Pariseo kag anang mga manogdomara ang mga pari nagtawag miting ang konsyal, kag pagtiripon nanda makon, “Ano kabay atun imoon? Doro nga mga milagro anang ginaimo ang tao nga dia. ");
INSERT INTO clu_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Kon pabayanan ta tana lang, ang tanan magatoo ron kanana nga tana maman ang ari nga ginpili ang Dios. Kag kon toladia ang matabo, sosolongon kita ang mga soldado ang Roma kag ranggaun nanda atun timplo kag atun bilog nga nasyon!” ");
INSERT INTO clu_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Karon, si Caifas isara sa nagamiriting. Tana maman ang pinakamataas nga pari sa toig nga dato. Makon na kananda, “Ara kamo manda may naulaman! ");
INSERT INTO clu_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ara nindo bala naisipi nga mas mayad kon sangka tao lang ang mapatay para sa atun nasyon kaysa ang bilog nga nasyon ang madora?” ");
INSERT INTO clu_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Anang ginambal nga dato bukun lang kanana nagalin, kondi bilang pinakamataas nga pari sa toig nga dato, nagambal ang Dios paagi kanana nga kinanglan nga mapatay si Jesus para sa anang kasimanwa nga mga Judio. ");
INSERT INTO clu_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Kag bukun lang para kananda, kondi para matipon kag magorogyon ang tanan nga mga bata ang Dios nga nagrarapta sa iba ibang logar. ");
INSERT INTO clu_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Kag ompisa ang adlaw nga dato nagimo ron plano ang mga manogdomara nga mga Judio agud patayun si Jesus. ");
INSERT INTO clu_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Gani ara run nagpakita si Jesus sa mga banwa ang mga Judio, kondi nagayan tana sa banwa ang Efraim nga marapit sa logar nga ara ginaolii ang tao. Doto tana nagtinir kaiban anang mga somolonod. ");
INSERT INTO clu_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Karon, marapit run lang anang pista ang mga Judio nga kon tawagun Pista anang Paglubas ang Angil. Gani doro nga mga tao ang nagarayan sa Jerusalem agud bago magabot ang pista makaparanglimpyo sanda andang kaogalingun sono sa soronodon andang rilyon. ");
INSERT INTO clu_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ginpangita nanda si Jesus, piro ara nanda nakita. Gani nagparamangkotan sanda sa isara kag isara. Makon nanda, “Ano kabay? Indi tana sigoro magpamista, ano?” ");
INSERT INTO clu_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Dato gali nagsogo ron nga lagi ang mga manogdomara nga mga pari kag ang mga Pariseo nga ang bisan sino nga makaulam kon diin si Jesus dapat magsogid kananda agud madakup nanda tana. ");
INSERT INTO clu_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Karon, anum run lang ka adlaw bago magabot ang pista, nagayan si Jesus sa Betania, sa logar ni Lazaro nga anang ginbanaw. ");
INSERT INTO clu_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Nagpriparar sanda doto yapon para kay Jesus. Si Lazaro isara sa mga kaiban ni Jesus nga nagakaun sa lamisa. Si Marta maman ang nagasirbi. ");
INSERT INTO clu_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Si Maria tana nagbuul ang maraalun nga agoa nga poro gid nardo nga bali tunga sa litro. Ginbobo na dato sa anang siki ni Jesus. Pagkatapos, anang book maman anang ginamit nga paraid. Ang bilog nga balay natugub anang amot ang aggoa. ");
INSERT INTO clu_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Isara doto sa mga kaiban ni Jesus si Judas Iscariote nga magatraidor kanana. Makon ni Judas, ");
INSERT INTO clu_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Sigoro anang bili ang aggoa nga dia katombas sa sangka toig nga soildo ang sangka tao. Basi ara pagbaligyaan kag anang bayad ipanagtag sa mga pobri?” ");
INSERT INTO clu_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ang kabangdanan kon basi toladato anang ambal ay bukun nga makon tana nalolooy sa mga pobri, kondi tungud nga ang matood tana, takawan tana. Tana maman ang nagaawid andang koarta kag pirmi na nga ginabulan. ");
INSERT INTO clu_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Piro makon ni Jesus, “Pabayani tana lang! Ipatago kanana ang nabilin agud itigana kon ako ilubung run. ");
INSERT INTO clu_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Bisan anong oras poidi kamo makabolig sa mga pobri, piro ako tana madali run lang magalin digi kanindo.” ");
INSERT INTO clu_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Dorong mga Judio ang nakabarita nga doto sa Betania si Jesus, gani nagarayan sanda doto. Andang ayan doto bukun lang tungud kay Jesus, kondi gosto nanda ra nga makita si Lazaro nga anang ginbanaw. ");
INSERT INTO clu_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Gani ginplano ra ang mga manogdomara nga mga pari nga patayun pati si Lazaro, ");
INSERT INTO clu_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ay tungud kanana doro ron nga mga Judio ang nagparabulag kananda kag nagtoo kay Jesus. ");
INSERT INTO clu_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ang madason nga adlaw nabaritaan ang mga tao nga nagarabot sa pista nga si Jesus nagapaayan run sa Jerusalem. ");
INSERT INTO clu_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Gani nagpanapas sanda mga daon nga pario anang daon ang pitogo kag ginsolang-solang nanda si Jesus nga nagasiringgit, makon nanda, “Dayawon ang Dios! Dayawon ang nagaabot nga dia nga ginpadara ang Ginoo! Dayawon anang Ari ang Israel!” ");
INSERT INTO clu_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","May nakita si Jesus nga bataun pa nga asno kag maman dato anang ginsakayan. Sa anang ginimo nga dato natoman anang koon ang Dios sa Kasolatan nga nagakoon: ");
INSERT INTO clu_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Kamo nga mga tao sa Jerusalem, indi kamo magkaadluk, Tungud nga indong ari nagaabot, Nga nagasakay sa bataun pa nga asno.” ");
INSERT INTO clu_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Sa oras nga dato, anang mga somolonod ni Jesus ara kaintindi kon ano anang kaologan ang mga nagakaratabo nga dato. Piro pagkatapos nga si Jesus nakabalik run sa langit, bago nanda pa naisipan nga anang ginimo nga dato ang mga tao maman gid gali ang nakabutang sa Kasolatan. ");
INSERT INTO clu_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Dorong tao ang nakakita anang pagtawag kag pagbanaw ni Jesus kay Lazaro alin sa rulubungan. Kag dia nga mga tao nagpamarita parti sa natabo. ");
INSERT INTO clu_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Gani dorong tao ang nagsolang-solang kay Jesus, ay nabaritaan nanda ang milagro nga dato nga anang ginimo. ");
INSERT INTO clu_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Gani makon ang mga Pariseo sa isara kag isara, “Ta sulunga nindo, ang tanan nga mga tao nagasoronod ron kanana. Ara kita run maimo!” ");
INSERT INTO clu_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","May mga Griego ra nga nagarabot sa Jerusalem agud magpamista kag magsimba sa Dios. ");
INSERT INTO clu_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Nagayan sanda kay Felipe. Si Felipe nga dia taga-Betsaida nga sakup anang probinsya ang Galilea. Makon ang mga Griego nga dato, “Gosto namun andan nga magpakigkita kay Jesus.” ");
INSERT INTO clu_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ginsogidan ni Felipe si Andres kag darwa sanda ang nagayan kay Jesus kag ginsogidan tana. ");
INSERT INTO clu_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Makon dayon ni Jesus kananda, “Dadi nagabot ron akun oras. Ako nga Naging Tao, makikita run akun gaum. ");
INSERT INTO clu_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Sa matood tana, kon ang bini indi ilubung sa logta, dan nga bini tugka lang gid sa sangka lugas. Piro kon dia ilubung kag mapatay magatobo kag magapamonga. Ako pario dan, tungud nga kon mapatay ako ron, doro ang matatawan bago nga kaboi. ");
INSERT INTO clu_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ang tao nga sobra anang pagigogma sa anang kaboi digi sa kalibotan nga dia mapapatay ra lang, piro ang tao tana nga ara nagapanginayang anang kaboi tungud kanakun makaangkun kaboi nga ara kataposan. ");
INSERT INTO clu_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ang bisan sino nga maliag magsirbi kanakun kinanglan magsonod kanakun, agud nga kon diin ako doto ra akun sorogoon. Ang tao nga nagasirbi kanakun padungugan akun Tatay.” ");
INSERT INTO clu_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Makon pa ni Jesus, “Dadi malingug akun isip. Ano kabay akun iambal? Ano, makon ako sa Amay nga indi na ako lang pagpaantoson? Piro maman dia anang katoyoan akun pagayan digi, ang magantos ang mga kasakitan sa oras nga dia.” ");
INSERT INTO clu_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Makon dayon ni Jesus sa Amay, “Amay, ipakita imong gaum sa mga tao.” May nagambal dayon alin sa langit, makon, “Ginpakita ko ron paagi kanimo, kag ipakita ko pa.” ");
INSERT INTO clu_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ang mga tao nga nagtarambong doto nakabati ang limug nga dato. Makon nanda, “Nagapandagub!” Piro makon ra ang iba, “Nagapakigambal kanana ang angil!” ");
INSERT INTO clu_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Piro makon ni Jesus kananda, “Ginpabati dato ang Dios bukun para kanakun kondi para kanindo. ");
INSERT INTO clu_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Alin dadi sintinsyaan na run anang mga kaaway digi sa kalibotan, kag mapipirdi na run si Satanas nga maman ang nagagaum digi sa kalibotan nga dia. ");
INSERT INTO clu_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Kag kon alsaun ako ron gani sa logta, parapitun ko ron ang tanan nga mga tao kanakun.” ");
INSERT INTO clu_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","(Sa anang ambal nga dato ginsogid na kon anong klasi nga kamatayun anang antoson.) ");
INSERT INTO clu_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Makon ang mga tao kanana, “Sono sa amun Kasogoan ara kamatayun ang Cristo nga anang ipadara ang Dios nga magari. Gani basi nagakoon kaw nga anang Bata ang Dios nga Naging Tao mapapatay? Sino ang Bata ang Dios nga dato nga Naging Tao nga imong ginakoon?” ");
INSERT INTO clu_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Makon ni Jesus kananda, “Madali run lang madora ang solo digi kanindo sa kalibotan tungud nga ako nga maman ang solo madali run lang magalin. Gani magkaboi kamo sa solo nga dia mintras digi pa, ay basi kon aboton kamo ang dulum. Tungud nga ang nagapanaw sa madulum indi kaulam kon diin tana nagapaayan. ");
INSERT INTO clu_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Magtoo kamo sa solo mintras digi pa kanindo, agud masanagan pirmi indong mga isip.” Pagkatapos na dia ambal nagpanaw tana kag nagpantago kananda. ");
INSERT INTO clu_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Bisan nakita nanda run gid ang mga milagro nga ginpangimo ni Jesus, ara sanda pa ra gid nagtoo kanana. ");
INSERT INTO clu_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Gani napamatodan anang koon ni propita Isaias nga nagakoon, “Ginoo, ara may nagpati amun ginbarita. Ara sanda kaulam nga ginpakita mo ron kananda imong gaum.” ");
INSERT INTO clu_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","40","Makon pa ni Isaias, “Ginbolag sanda ang Dios agud indi sanda makakita, kag gintakupan na andang mga una-una agud indi sanda makaangup, Ay basi kon magliso sanda sa Dios kag ayadun na sanda.” Gani maman dan angkabangdanan kon basi ara sanda nagtoo kay Jesus. ");
INSERT INTO clu_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ginambal dato ni Isaias ang parti kay Jesus tungud nga nakita na run nga lagi ang ona anang gaum. ");
INSERT INTO clu_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Piro bisan toladato matood anang koon ni Isaias, doro pa ra gid sa anang mga manogdomara ang mga Judio ang nagtoo kay Jesus. Piro ara sanda lang nagpabotyag andang pagtoo tungud nga ginaadlukan sanda nga indi sanda run pagpasuludun ang mga Pariseo sa anang mga simbaan ang mga Judio. ");
INSERT INTO clu_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ay ginpasolabi nanda anang pagdayaw ang mga tao kaysa anang pagdayaw ang Dios. ");
INSERT INTO clu_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Nagambal mabaskug si Jesus, makon na, “Kon ang tao magtoo kanakun, bukun lang kanakun tana nagatoo kondi nagatoo tana ra sa Amay nga nagpadara kanakun. ");
INSERT INTO clu_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ang nakakita kanakun nakakita run da sa nagpadara kanakun. ");
INSERT INTO clu_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nagayan ako digi sa kalibotan agud masanagan anang mga isip ang mga tao nga magatoo kanakun, agud indi sanda magtinir sa madulum. ");
INSERT INTO clu_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Kon may dian nga nakabati akun mga panodlo piro ara nagasonod, bukun ako ang magasintinsya kanana nga silotan. Ay ara ako nagayan digi sa kalibotan para silotan ang mga tao kondi para lowasun. ");
INSERT INTO clu_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","May dian nga magasintinsya sa mga tao nga nagasikway kanakun kag indi magsonod sa akun mga panodlo; ang mga ambal nga akun gintodlo maman ang magasintinsya kananda sa ori nga adlaw. ");
INSERT INTO clu_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ay akun mga panodlo bukun alin kanakun kondi sa Amay nga nagpadara kanakun. Tana maman ang nagsogo kanakun kon ano akun itodlo. ");
INSERT INTO clu_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Kag naulaman ko nga anang mga panodlo nga dia nga anang ginkoon kanakun nga ipanodlo nagataw kaboi nga ara kataposan. Gani ginasogid ko kanindo ang tanan nga anang ginapasogid.” ");
INSERT INTO clu_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Bago magabot anang adlaw ang pista, naulaman run nga lagi ni Jesus nga nagabot ron ang oras nga tana maalin run sa kalibotan nga dia kag magbalik sa Amay. Palangga na nga mayad anang mga somolonod digi sa kalibotan kag asta sa kataposan ginpakita na anang pagpamalangga. ");
INSERT INTO clu_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ang gabi nga dato, si Jesus kag anang mga somolonod nagairiyapon. Karon, ginbutang run nga lagi ni Satanas sa anang isip ni Judas nga bata ni Simon Iscariote nga traidoron na si Jesus. ");
INSERT INTO clu_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Naulaman ni Jesus nga ang tanan nga gaum gintaw ron ang Amay kanana. Naulaman na ra nga tana sa Dios nagalin kag sa Dios tana ra mabalik. ");
INSERT INTO clu_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Mintras sa lamisa pa anang mga somolonod, nagtindug tana kag nagoba anang kapa. Pagkatapos nagbuul tana dayon ang toalya kag ginbugkus na sa anang awak. ");
INSERT INTO clu_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ginboboan na dayon tobig ang palanggana kag ginpangogasan anang mga siki anang mga somolonod. Kada maogasan na, ginapaidan na dayon ang toalya nga anang ginbugkus sa anang awak. ");
INSERT INTO clu_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Pagabot na kay Simon Pedro, makon ni Simon kanana, “Ginoo, ogasan mo akun siki?” ");
INSERT INTO clu_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Makon ni Jesus kanana, “Dadi indi mo pa maulaman kon ano anang kaologan akun ginaimo nga dia, piro maulaman mo ra sa ori.” ");
INSERT INTO clu_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Makon ni Pedro, “Indi gid maimo nga ikaw ang magogas akun siki.” Piro makon ni Jesus kanana, “Ta kon indi kaw magpaogas imong siki kanakun, bukun ka run akun kaiban.” ");
INSERT INTO clu_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Gani makon ni Simon Pedro, “Ta kon toladato, bukun lang akun siki imong ogasan, kondi pati akun alima kag akun olo.” ");
INSERT INTO clu_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Piro makon ni Jesus, “Ang nakaparigos limpyo ron anang bilog nga lawas, kag indi run kinanglan nga ogasan loas sa anang mga siki. Limpyo kamo ron, piro bukun tanan kamo.” ");
INSERT INTO clu_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","(Nagkoon tana nga bukun limpyo ang tanan tungud nga naulaman na kon sino ang matraidor kanana.) ");
INSERT INTO clu_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Pagkaogas ni Jesus andang mga siki, ginsoksok na ruman anang kapa kag nagbalik sa lamisa. Nagpamangkot tana dayon kananda, makon na, “Ta naulaman nindo kon ano anang kaologan akun ginimo kanindo? ");
INSERT INTO clu_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ginatawag nindo ako nga manogtodlo kag Ginoo, kag osto dan ay ako ra gid gani indong manogtodlo kag Ginoo. ");
INSERT INTO clu_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ta kon ako nga indong Ginoo kag Manogtodlo nagogas indong siki, kamo dapat ra nga magogas anang siki indong kaiban. ");
INSERT INTO clu_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ginimo ko dia bilang alimbawa agud wadun nindo. Gani imoon nindo ra sa isara kag isara akun ginimo nga dia kanindo. ");
INSERT INTO clu_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Sa matood tana ara sorogoon nga labaw sa anang agalun, kag ara sinogo nga labaw sa nagsogo kanana. ");
INSERT INTO clu_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Dadi nga naintindian nindo ron akun gintodlo nga dia, masoirti kamo kon imoon nindo. ");
INSERT INTO clu_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Ara ako nagakoon nga masoirti kamo tanan, ay naulaman ko akun mga pinili. Piro kinanglan matoman anang ginakoon ang Kasolatan nga ang tao nga nagasaro kanakun sa pagkaun maman pa ang nagkontra kanakun. ");
INSERT INTO clu_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Dia ginasogid ko ron nga lagi kanindo mintras ara pa matabo, agud nga kon matabo ron magapati kamo nga ako ra gid ang Cristo. ");
INSERT INTO clu_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Sa matood tana, ang nagabaton sa mga tao nga akun ginapadara nagabaton ra kanakun, kag ang nagabaton kanakun nagabaton ra sa Amay nga nagpadara kanakun.” ");
INSERT INTO clu_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Pagkaambal dato ni Jesus nagngitngit anang tagiposoon. Makon na dayon, “Sa matood tana, isara kanindo ang magatraidor kanakun agud patayun ako.” ");
INSERT INTO clu_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Gani nagsurulungan anang mga somolonod nga nagaparalibug kon sino kananda anang ginatomod. ");
INSERT INTO clu_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Karon, isara sa mga somolonod nga palangga gid ni Jesus doto mismo nagaingud kanana. ");
INSERT INTO clu_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Gani ginsinyasan tana ni Simon Pedro nga pamangkoton si Jesus kon sino anang ginatomod. ");
INSERT INTO clu_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Gani nagparapit tana pa gid kay Jesus kag nagpamangkot kon sino anang ginatomod nga magatraidor kanana. ");
INSERT INTO clu_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Nagsabat si Jesus, “Itosmog ko ang tinapay nga dia, pagkatapos kon sino akun tawan, dan maman ang magatraidor kanakun.” Kag gintosmog na gani ang tinapay nga dato kag gintaw na dayon kay Judas nga bata ni Simon Iscariote. ");
INSERT INTO clu_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Pagkabaton ni Judas ang tinapay nga dato, lagi-lagi nagsulud kanana si Satanas. Makon dayon ni Jesus kanana, “Sigi, imoa run imong imoon.” ");
INSERT INTO clu_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","(Doto sa mga nagairiyapon ara may nakaulam kon basi nagambal toladato si Jesus kay Judas. ");
INSERT INTO clu_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Anang kaisip ang iba nga mga somolonod ginsogo tana ni Jesus nga magbakal andang mga kinanglan para sa pista, okon magtaw limos sa mga pobri, ay si Judas maman ang nagakaput andang koarta.) ");
INSERT INTO clu_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Pagkakaun ni Judas ang tinapay naggoa tana dayon. Gabi run dato. ");
INSERT INTO clu_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Pagkaalin ni Judas makon ni Jesus, “Dadi Ako nga Naging Tao padungugan run, kag paagi kanakun ang Dios padungugan ra. ");
INSERT INTO clu_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Kag kon paagi kanakun dayawon ang Dios, ipakita na ra nga ako darayawon manda. Kag dia imoon na nga lagi.” ");
INSERT INTO clu_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Makon pa ni Jesus, “Kamo nga akun ginabilang nga akun mga bata, indi run lang boay atun pagkaraiban. Magapangita kamo kanakun, piro pario akun koon sa mga Judio ginasogid ko ra kanindo dadi nga indi kamo makaayan sa akun arayanan. ");
INSERT INTO clu_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Gani dadi ginatawan ko kamo ang bago nga sogo: magirigogmaan kamo. Kon paiwan akun pagigogma kanindo dapat toladato ra indong pagigogma sa isara kag isara. ");
INSERT INTO clu_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Kon kamo nagairigogmaan, dian maulaman ang tanan nga kamo akun mga somolonod manda.” ");
INSERT INTO clu_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Karon, ginpamangkot tana ni Simon Pedro, makon na, “Ginoo, diin kaw maayan?” Makon anang sabat ni Jesus, “Dadi indi kaw makatabid kanakun sa akun arayanan, piro sa ori magasonod kaw ra kanakun doto.” ");
INSERT INTO clu_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Piro makon ni Pedro, “Ginoo, basi indi ako makatabid kanimo dadi? Ay priparado ako ra nga mapatay para kanimo.” ");
INSERT INTO clu_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Makon ni Jesus kanana, “Ano, mapanginmatay ka gid para kanakun? Tandaan mo dia: bago magtorook ang manok, ipanginwara mo ako tatlo gid ka bisis.” ");
INSERT INTO clu_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Makon ni Jesus kananda, “Indi kamo magsari palibug. Magsarig kamo sa Dios kag magsarig kamo ra kanakun. ");
INSERT INTO clu_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Doto sa anang ginaolian akun Tatay dorong maistaran. Ako maona doto agud magpriparar logar para kanindo. Indi ako magsogid dia kanindo kon dia bukun matood. ");
INSERT INTO clu_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Pagkatapos nga ako doto ron kag nakapriparar logar para kanindo, mabalik ako ruman digi sa kalibotan agud bulun ko kamo, agud nga kon diin ako doto kamo ra. ");
INSERT INTO clu_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Kag naulaman nindo ang dalan paayan sa logar nga akun ayanan.” ");
INSERT INTO clu_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Makon ni Tomas kanana, “Ginoo, ara kami gani kaulam kon diin kaw maayan, gani paiwan amun pagkaulam ang dalan?” ");
INSERT INTO clu_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Makon ni Jesus kanana, “Ako ang dalan. Ara may makaayan sa Amay kon bukun paagi kanakun. Ako anang ginaalinan ang kamatoodan kag ang kaboi. ");
INSERT INTO clu_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Kon kilala nindo ako, nakilala nindo ron da akun Tatay. Kag alin gani dadi kilala nindo tana run gid kag nakita pa.” ");
INSERT INTO clu_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Makon ni Felipe kanana, “Ginoo, abi ipakita kanamun ang Amay agud lobos ron gid amun pagpati.” ");
INSERT INTO clu_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Makon ni Jesus kanana, “Felipe, ang kaboay run atun pagtawasan, ara kaw pa gid kakilala kon sino ako? Ang nakakita kanakun nakakita run da sa Amay. Basi nagakoon ka pa nga ipakita ko kanindo ang Amay? ");
INSERT INTO clu_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ano, ara kaw nagapati nga ako sa Amay kag ang Amay digi kanakun? Ang mga panodlo nga akun ginatodlo kanindo bukun alin kanakun. Ang Amay nga digi kanakun maman ang nagaimo ang mga butang nga akun ginaimo. ");
INSERT INTO clu_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Magpati kamo kanakun nga ako sa Amay kag ang Amay digi kanakun. Kon indi kamo magpati sa akun sogid andan magpati kamo tungud sa akun inimoan. ");
INSERT INTO clu_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Sa matood tana, ang nagatoo kanakun magaimo ra akun mga ginaimo kag mas sobra pa, tungud nga ako mabalik run sa Amay. ");
INSERT INTO clu_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Gani makapangayo kamo ron ang bisan ano kanakun kag dan imoon ko, agud nga paagi kanakun mapadungugan ang Amay ay ako anang Bata. ");
INSERT INTO clu_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Bisan ano indong ipangamoyo kanakun, imoon ko.” ");
INSERT INTO clu_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Kon ako ginaigogma nindo tomanun nindo akun mga sogo. ");
INSERT INTO clu_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","17","Kag pangayoon ko sa Amay nga ipadara na kanindo ang Manogbolig nga magatulus kanakun. Ang Manogbolig nga dia ara iba kondi ang Ispirito Santo nga maman ang magatodlo kanindo ang kamatoodan. Kag tana indi run gid magalin-alin kanindo asta kon sano. Indi tana pagbatonon ang mga tao nga ara nagatoo kanakun tungud nga ara nanda tana nakikita okon nakikilala. Piro kamo tana kilala nindo tana tungud nga tana kaiban nindo dian, kag magaistar sa indong tagiposoon asta kon sano. ");
INSERT INTO clu_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Indi ko kamo pagbayaan nga ara kaiban; mabalik ako ra kanindo. ");
INSERT INTO clu_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Madali ako ron lang madora sa anang panulung ang mga tao digi sa kalibotan, piro kamo tana makakikita kanakun. Kag tungud nga ako may kaboi nga ara kataposan kamo may kaboi ra nga ara kataposan. ");
INSERT INTO clu_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Pagabot ang adlaw akun pagbalik kanindo, maulaman nindo gid nga ako sa akun Tatay, kag kamo digi kanakun, kag ako dian ra kanindo. ");
INSERT INTO clu_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Ang tao nga nagabaton kag nagatoman akun mga sogo maman ang nagaigogma kanakun. Kag ang nagaigogma kanakun igogmaun ra akun Tatay. Igogmaun ko tana ra kag ipakilala ko gid kanana kon sino ako.” ");
INSERT INTO clu_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Karon ginpamangkot tana ni Judas, (bukun dia si Judas Iscariote), makon na, “Ginoo, basi kanamun ka lang mapakilala kon sino kaw gid? Basi indi kaw magpakilala sa tanan?” ");
INSERT INTO clu_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Makon ni Jesus kanana, “Ang nagaigogma kanakun magatoman akun mga ginatodlo; akun Tatay magapalangga kanana, kag kami magaistar dian kanana mismo. ");
INSERT INTO clu_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Piro ang ara nagaigogma kanakun ara nagatoman akun mga ginatodlo. Akun mga ginatodlo kanindo bukun alin kanakun, kondi alin sa Amay nga nagpadara kanakun. ");
INSERT INTO clu_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Dia nga mga butang ginasogid ko ron nga lagi kanindo mintras kaiban nindo ako pa. ");
INSERT INTO clu_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Piro kon makaalin ako ron gani ang Manogbolig nga ara iba kondi ang Ispirito Santo maman anang ipadara ang Amay bilang tulus kanakun. Tana ang matodlo kanindo ang tanan nga butang padumdumun na kamo ang tanan nga akun ginkoon kanindo. ");
INSERT INTO clu_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Indi kamo magpalibug kag indi kamo ra magkaadluk, tungud nga ginasala ko kanindo ang kalinung. Akun kalinung mismo akun ginataw kanindo; dia bukun pario ang kalinung nga ginataw ang kalibotan. ");
INSERT INTO clu_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Nabatian nindo kanakun nga ako maalin piro mabalik ako ra kanindo. Kon ginaigogma nindo ako, andan malilipay kamo nga makaayan ako sa Amay nga mas gamanan kanakun. ");
INSERT INTO clu_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Dia ginasogid ko ron nga lagi kanindo mintras ara pa matabo, agud nga kon matabo ron gani magabaskug indong pagtoo kanakun. ");
INSERT INTO clu_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Indi ko ron pagpalabugun akun pagambal kanindo tungud nga nagaabot ron si Satanas nga nagagaum sa mga tao nga ara nagatoo kanakun. Ara tana gaum kanakun. ");
INSERT INTO clu_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Piro agud maulaman ang tanan nga mga tao nga ginaigogma ko ang Amay ginasonod ko anang ginapaimo ang Amay kanakun. Dali run. Mapanaw kita run.” ");
INSERT INTO clu_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Makon pa ni Jesus, “Akun kaalimbawa pario sa matood nga pono ang obas, kag akun Tatay maman ang manogasikaso. ");
INSERT INTO clu_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Akun mga sanga nga ara nagapamonga ginapangotod na, kag ang kada sanga nga nagapamonga ginalimpyoan na agud magdoro pa gid anang bonga. ");
INSERT INTO clu_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Kamo nalimpyoan run paagi sa akun mga gintodlo kanindo. ");
INSERT INTO clu_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Indi kamo magpabulag kanakun, kag ako indi ra magpabulag kanindo. Kon paiwan nga ang sanga indi makapamonga kon ara nagaangut sa pono, kamo indi ra makapamonga mga mayad nga inimoan kon bulag kamo kanakun. ");
INSERT INTO clu_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Gani nagakoon ako nga akun kaalimbawa anang pono ang obas, kag kamo akun mga sanga. Ang tao nga ara nagapabulag kanakun kag ako ara ra nagapabulag kanana, tana maman ang magapamonga doro, ay kon ako ara kanindo ara kamo gid maimo. ");
INSERT INTO clu_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ang tao nga nagapabulag kanakun ipilak lang, pario sa mga sanga nga ginapilak kag nauuga, pagkatapos ginatipon dayon kag ginadapong sa kalayo agud masonog. ");
INSERT INTO clu_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Kon kamo indi magpabulag kanakun kag ginatipigan nindo sa indong mga tagiposoon akun mga panodlo, makapangayo kamo kanakun bisan ano indong gosto, kag dan mababaton nindo. ");
INSERT INTO clu_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Kon kamo padayon nga nagapamonga ang mga mayad nga mga inimoan, akun Tatay dayawon ang mga tao, kag dian ra maulaman nga kamo akun mga somolonod manda. ");
INSERT INTO clu_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Kon paiwan anang pagigogma kanakun ang Amay, pario ra dan akun pagigogma kanindo. Indi kamo magpabulag sa akun gogma. ");
INSERT INTO clu_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Kon ginatoman nindo akun mga sogo, padayon akun pagigogma kanindo. Pario ra dia kanakun nga nagatoman anang sogo akun Tatay kag nagapadayon anang pagigogma kanakun. ");
INSERT INTO clu_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Ginasogid ko dia kanindo agud makairug kamo ra sa akun kalipay, agud maging lobos indong kalipay. ");
INSERT INTO clu_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Dagi akun sogo kanindo: magirigogmaan kamo pario akun pagigogma kanindo. ");
INSERT INTO clu_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Kon may tao nga magpanginmatay para sa anang mga amigo, dan nga pagigogma indi run malabawan. ");
INSERT INTO clu_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Kamo akun mga amigo kon ginatoman nindo akun mga sogo. ");
INSERT INTO clu_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Indi ko kamo ron pagtawagun nga mga oripun, ay ang oripun ara kaulam kon ano anang ginaimo anang agalun. Kamo ginatawag ko ron dadi nga akun mga amigo, ay kon ano akun nabatian sa akun Tatay maman da akun ginasogid kanindo. ");
INSERT INTO clu_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Bukun kamo ang nagpili kanakun kondi ako ang nagpili kanindo. Ginpili ko kamo agud makapamonga kamo dorong mayad nga inimoan kag makapadayon indong mga bonga. Kag bisan ano indong pangayoon sa Amay tungud nga kamo nagatoo kanakun, itaw na kanindo. ");
INSERT INTO clu_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Gani akun sogo kanindo maman dia: magirigogmaan kamo.” ");
INSERT INTO clu_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Makon pa ni Jesus, “Kon ginadumutan kamo ang mga tao nga nagakontra sa Dios, indi kamo dapat matingala tungud nga naulaman nindo nga ako maman ang ona nga andang gindumutan. ");
INSERT INTO clu_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Kon pario kamo kananda nga nagakontra sa Dios, igogmaun nanda kamo. Piro ginadumutan nanda kamo tungud nga bukun kamo ron kabilang kananda kondi ginpili ko kamo alin kananda. ");
INSERT INTO clu_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Dumdumun nindo akun ginambal kanindo nga ara oripun nga labaw sa anang agalun. Gani kon ako giningabot nanda, kamo ingaboton nanda ra. (Kag kon tomanun nanda akun mga panodlo, tomanun nanda ra indong mga panodlo.) ");
INSERT INTO clu_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Toladan andang imoon kanindo tungud nga kamo nagatoo kanakun, kag ara sanda kakilala sa nagpadara kanakun. ");
INSERT INTO clu_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Kon ara ako nagayan digi sa kalibotan kag nagtodlo kananda, ara sanda andan sarabatun; piro dadi indi sanda makabaribad sa andang mga sala. ");
INSERT INTO clu_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ang nagadumut kanakun nagadumut ra sa akun Tatay. ");
INSERT INTO clu_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Kon ara ako nagimo sa andang tunga ang mga milagro nga ara bisan sino nga tao ang makaimo, andan ara sanda sarabatun sa andang mga malain nga ginaimo kanakun. Garing bisan nakita nanda akun mga inimoan, nagadumut sanda pa ra gid kanakun kag sa akun Tatay. ");
INSERT INTO clu_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Sa andang ginaimo nga dia natoman ang ginsolat sa andang Kasogoan nga nagakoon nga ‘Gindumutan nanda ako nga ara gid kabangdanan.’” ");
INSERT INTO clu_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Makon dayon ni Jesus kananda, “Ipadara ko kanindo ang Ispirito Santo nga alin sa Amay. Tana maman ang ginatawag nga Manogbolig kag tana ra ang manogtodlo ang kamatoodan. Kag kon magabot tana run isogid na kanindo kon sino ako gid. ");
INSERT INTO clu_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Kag dapat magsogid kamo ra dayon parti kanakun tungud nga kaiban ko kamo alin pa ang ona. ");
INSERT INTO clu_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Ginasogid ko nga lagi kanindo ang mga butang nga dia, agud miski ano pa ang matabo sa ori indi madora indong pagtoo kanakun. ");
INSERT INTO clu_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Paalinun nanda kamo sa andang mga simbaan, kag magaabot ang oras nga kon sino ang makapatay kanindo magaunauna nga nagasirbi tana sa Dios. ");
INSERT INTO clu_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Dia imoon nanda kanindo tungud nga ara sanda kakilala sa Amay okon kanakun. ");
INSERT INTO clu_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Piro ginasogid ko dia kanindo agud nga kon magabot ron ang oras nga imoon nanda dia kanindo, madumduman nindo nga ginpaandaman ko kamo ron nga lagi.” “Dia nga mga butang ara ko pagsogidan kanindo ang ona ay kaiban nindo ako pa. ");
INSERT INTO clu_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Piro dadi mabalik ako ron sa nagpadara kanakun kag miski sino kanindo ara may nagapamangkot kanakun kon diin ako maayan. ");
INSERT INTO clu_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Dadi nga ginsogidan ko kamo ang mga butang nga dia nagakasubu kamo nga mayad. ");
INSERT INTO clu_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Piro sa matood tana, mas mayad para kanindo nga magalin ako digi. Ay kon indi ako magalin, ang Manogbolig indi magabot kanindo. Piro kon magalin ako, ipadara ko tana digi kanindo. ");
INSERT INTO clu_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Kag kon magabot tana run digi sa kalibotan ipakita na sa mga tao nga sanda mga makasasala kag ako maman ang matarung. Kag ipakita na ra nga ang Dios magasintinsya kananda. ");
INSERT INTO clu_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ipakita na sa mga tao nga sanda mga makasasala, tungud nga ara sanda nagtoo kanakun. ");
INSERT INTO clu_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ipakita na nga ako ang matarung tungud nga ako maayan sa Amay kag indi kamo ron makakita kanakun. ");
INSERT INTO clu_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ipakita na ra kananda nga ang Dios magasintinsya kananda, ay sintinsyado ron si Satanas nga maman ang nagagaum sa mga tao nga ara nagatoo kanakun. ");
INSERT INTO clu_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Doro pa gid andan akun inogsogid kanindo, garing dadi indi kamo pa dia kasarang magangup. ");
INSERT INTO clu_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Piro kon magabot ron ang Ispirito Santo nga maman ang manogtodlo ang kamatoodan, todloan na kamo ang tanan nga kamatoodan. Ang mga butang nga anang itodlo kanindo bukun alin kanana, kondi kon ano anang nabatian alin sa Amay dan maman da anang isogid kanindo. Isogid na ra kanindo kon ano ang magakaratabo sa paraaboton. ");
INSERT INTO clu_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ako maman anang padungugan tungud nga ipasanag na kanindo akun mga ginpanodlo kag ginpangimo. ");
INSERT INTO clu_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ay kon ano anang ginapanodlo ang Amay maman da ang kanakun. Maman dan nga nagkoon ako nga akun mga panodlo maman anang ipasanag kanindo.” ");
INSERT INTO clu_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Indi run lang boay kag indi nindo ako ron makita. Piro indi ra maboay kag makikita nindo ako roman.” ");
INSERT INTO clu_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Karon, ang iba sa anang mga somolonod nagparamangkotan, makon nanda, “Ano kabay anang gostong ambalun nga indi run lang boay kag indi ta tana run makita, pagkatapos indi ra lang boay kag makikita ta tana ruman? Kag nagkoon tana pa nga dia matabo tungud nga mabalik tana run sa Amay. ");
INSERT INTO clu_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ano kabay anang gostong ambalun sa ‘indi run lang boay’? Indi ta maintindian kon ano anang ginakoon nga dia.” ");
INSERT INTO clu_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Naulaman ni Jesus nga gosto nanda andan nga magpamangkot kanana, gani makon na kananda, “Nagkoon ako nga indi run lang boay kag indi nindo ako ron makita piro indi ra maboay kag makikita nindo ako roman. Indi bala nga maman dia indong gosto andan nga ipamangkot kanakun? ");
INSERT INTO clu_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Sa matood tana, ang mga tao digi sa kalibotan nga nagakontra kanakun malilipay nga mayad sa matatabo kanakun, piro kamo tana magaparanangis sa kasubu. Piro indong mga kasubu madodora kag mababayloan ang kalipay. ");
INSERT INTO clu_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Pario sa babai nga nagapasakit, ginaagoanta na ang sakit tungud nga mabata tana run. Piro kon makagoa run gani ang bata, nalilipatan na run anang pagpasakit ay nalilipay tana nga natao ron anang bata digi sa kalibotan. ");
INSERT INTO clu_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Kamo toladan ra. Dadi nagapaborido kamo, piro pagkirita ta ruman malilipay kamo nga mayad. Kag ara gid may makabuul indong kalipay nga dan. ");
INSERT INTO clu_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Kag kon magabot ron ang adlaw nga dato indi run kinanglan nga magpamangkot kamo pa kanakun bisan ano. Ang matood tana, bisan ano indong pangayoon sa Amay sa akun aran itaw na kanindo. ");
INSERT INTO clu_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Asta dadi ara kamo pa kapangayo bisan ano kanana sa akun aran. Magpangayo kamo agud makabaton kamo, kag agud malobos indong kalipay.” ");
INSERT INTO clu_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Ang mga butang nga dia ginsogid ko kanindo paagi sa mga paanggid. Piro magaabot ang adlaw nga indi ako ron maggamit mga paanggid, kondi diritso ko ron nga isogid kanindo ang parti sa Amay. ");
INSERT INTO clu_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Kon magabot ron ang adlaw nga dato, kamo mismo ang magapangayo sa Amay sa akun aran. Indi run kinanglan nga ako pa ang magpangayo sa Amay para kanindo. ");
INSERT INTO clu_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ay kamo ginaigogma ang Amay tungud nga kamo nagaigogma kanakun, kag nagapati nga ako alin sa Dios. ");
INSERT INTO clu_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Sa Amay ako gid nagalin kag nagayan digi sa kalibotan. Piro dadi maalin ako ron digi sa kalibotan nga dia kag magabalik sa Amay.” ");
INSERT INTO clu_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Makon dayon anang mga somolonod, “Dan, masanag run imong mga ambal ay ara ka run nagagamit mga paanggid. ");
INSERT INTO clu_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Dadi sigorado kami run nga naulaman mo ang tanan nga mga butang, ay bisan gani ara kami kapamangkot kanimo naulaman mo ron nga lagi amun ginaisip. Gani nagapati kami nga ikaw alin gid manda sa Dios.” ");
INSERT INTO clu_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Makon ni Jesus kananda, “Ta, nagatoo kamo ron dadi kanakun? ");
INSERT INTO clu_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Piro maabot ang oras kag nagabot ron gani dadi nga kamo magaburulag kag mansig-oroli, kag bayaan nindo ako. Piro bisan bayaan nindo ako, may kaiban ako pa ra gid tungud nga kaiban ko ang Amay. ");
INSERT INTO clu_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ginasogid ko kanindo ang mga butang nga dia agud may kalinung kamo tungud sa indong pagtoo kanakun. Digi sa kalibotan nga dia paantoson kamo ang mga tao, piro indi kamo magkaadluk tungud nga ginpirdi ko ron ang tanan nga nagakontra sa Dios digi sa kalibotan.” ");
INSERT INTO clu_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Pagkaambal dia ni Jesus, nagtangra tana sa langit kag nagkoon, makon na, “Amay, nagabot ron ang oras. Padungugi imong Bata agud padungugan ka ra imong Bata. ");
INSERT INTO clu_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ay gintawan mo ako awtoridad nga maggaum sa tanan nga mga tao, agud matawan ko kaboi nga ara kataposan ang tanan nga mga tao nga imong gintaw kanakun. ");
INSERT INTO clu_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Kag maman dia ang kaboi nga ara kataposan, nga ang mga tao magkilala kanimo nga maman lang ang matood nga Dios kag magkilala ra kanakun nga imong ginpadara. ");
INSERT INTO clu_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ginpadungugan ta kaw digi sa kalibotan nga dia tungud nga natapos ko ron imong ginpaimo kanakun. ");
INSERT INTO clu_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Gani dadi Amay, padungugi ako dian sa imong prisinsya. Ibalik mo kanakun ang dungug nga kanakun ra nga lagi ang dian ako pa kanimo bago imoon ang kalibotan. ");
INSERT INTO clu_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Ginpakilala ta kaw sa mga tao nga imong ginpili sa kalibotan kag gintaw kanakun. Imo sanda anay kag gintaw mo sanda kanakun, kag gintoman nanda imong mga sogo. ");
INSERT INTO clu_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Dadi naulaman nanda run nga ang tanan nga imong gintaw kanakun kanimo gid nagalin. ");
INSERT INTO clu_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Kon ano imong gintodlo kanakun maman da akun gintodlo kananda, kag ginbaton nanda ra. Kag naulaman nanda run nga matood ra gid nga kanimo ako nagalin. Kag nagapati sanda nga ikaw ang nagpadara kanakun. ");
INSERT INTO clu_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Ginapangamoyo ko sanda. Ara ako nagapangamoyo para sa mga tao nga ara nagatoo kanakun, kondi ang mga tao tana nga imong gintaw kanakun maman akun ginapangamoyo, tungud nga dia sanda imo. ");
INSERT INTO clu_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ang tanan nga mga tao nga akun imo, kag ang tanan nga imo akun. Kag ginapadungugan nanda ako. ");
INSERT INTO clu_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Dadi mabalik ako ron dian kanimo kag indi ako ron magtinir sa kalibotan nga dia. Piro sanda tana masasala pa digi sa kalibotan. O matarung nga Amay, paagi sa imong gaum nga imong gintaw kanakun bantayi ang mga tao nga dia, agud sanda nga tanan maging isara run lang pario nga ikaw kag ako isara. ");
INSERT INTO clu_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ang ako kaiban nanda pa ginbantayan ko sanda paagi sa imong gaum nga imong gintaw kanakun. Ginbantayan ko sanda, kag ara gid may nadora kananda loas sa tao nga madodora ra gid agud matoman ang gintagna sa Kasolatan. ");
INSERT INTO clu_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Dadi mabalik ako ron dian kanimo. Dia nga mga butang ginasogid ko ron nga lagi mintras digi ako pa sa kalibotan agud magkalipay sanda ra nga mayad pario kanakun. ");
INSERT INTO clu_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Gintodlo ko kananda imong ginpatodlo kanakun. Gindumutan sanda ang mga tao nga nagakontra kanimo. Ay bukun sanda ana ang kalibotan, pario ra kanakun nga bukun ana ang kalibotan. ");
INSERT INTO clu_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ara ako nagapangamoyo nga bulun mo sanda run digi sa kalibotan, kondi apinan mo sanda kay Satanas. ");
INSERT INTO clu_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Bukun sanda ana ang kalibotan, pario ra kanakun nga bukun ana ang kalibotan. ");
INSERT INTO clu_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ipabulag mo sanda nga para kanimo paagi sa kamatoodan; imong ambal maman ang kamatoodan. ");
INSERT INTO clu_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ginpadara mo ako digi sa kalibotan, gani ginapadara ko sanda ra nga magpanodlo imong mga ambal sa mga tao sa kalibotan. ");
INSERT INTO clu_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Tungud kananda ginaalad ko kanimo akun kaogalingun, agud maging imo sanda ra matood paagi sa kamatoodan. ");
INSERT INTO clu_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Bukun lang ang mga tao nga dia nga nagatoo ron kanakun akun ginapangamoyo, kondi pati run da ang mga tao nga magatoo kanakun sa ori tungud sa andang mga pagpanodlo. ");
INSERT INTO clu_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Amay, ginapangamoyo ko kanimo nga sanda tanan maging isara lang, pario kanatun nga isara ra lang. Kag kon paiwan nga ikaw digi kanakun kag ako dian ra kanimo, kabay pa nga digi sanda ra kanatun agud ang mga tao nga ara nagatoo kanakun magapati nga ikaw manda ang nagpadara kanakun. ");
INSERT INTO clu_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Gintawan ko sanda dungug pario sa dungug nga imong gintaw kanakun, agud maging isara sanda pario ra kanatun nga isara lang. ");
INSERT INTO clu_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Kon paiwan nga digi kaw kanakun ako dian ra kananda, agud maging isara sanda run lang gid. Kag sa toladia nga paagi maulaman ang mga tao nga ara nagatoo kanakun nga ikaw manda ang nagpadara kanakun digi. Kag maulaman nanda ra nga ginapalangga mo ang mga tomoloo pario sa imong pagpalangga kanakun. ");
INSERT INTO clu_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Amay, gosto ko nga ang mga tao nga dia nga imong gintaw kanakun makaiban ko sa akun orolian, agud makikita nanda akun dungug, ang dungug nga imong gintaw kanakun bago imoon ang kalibotan tungud nga palangga mo ako. ");
INSERT INTO clu_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Amay, matarung kaw. Garing ang mga tao digi sa kalibotan ara kakilala kanimo. Piro ako tana kakilala kanimo, kag akun mga kaiban nga dia kaulam run nga ikaw maman ang nagpadara kanakun. ");
INSERT INTO clu_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ginpakilala ko ikaw kananda, kag ipakilala pa gid agud imong pagigogma kanakun maging dian ra kananda, kag agud makaoli ako sa andang mga tagiposoon.” ");
INSERT INTO clu_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Pagkatapos pangamoyo ni Jesus, nagpanaw tana dayon kaiban anang mga somolonod patabok sa soba ang Kedron. Doto sanda nagayan sa logar nga may gintanum nga mga kaoy. ");
INSERT INTO clu_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Dato nga logar kabisado ron ni Judas nga traidor ay pirmi doto si Jesus kag anang mga somolonod. ");
INSERT INTO clu_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Gani nagayan doto sa logar nga dato si Judas nga may dara nga mga Romano nga soldado pati mga goardya sa timplo nga ginsogo ang mga manogdomara nga mga pari kag mga Pariseo. May dara sanda nga mga solo kag mga boron. May dara sanda ra nga mga armas. ");
INSERT INTO clu_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Naulaman ni Jesus ang tanan nga matatabo kanana, gani ginsolang-solang na sanda kag nagpamangkot, makon na, “Sino indong ginapangita?” ");
INSERT INTO clu_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Makon nanda, “Si Jesus nga-taga-Nazaret.” Makon ni Jesus kananda, “Ako dato.” Si Judas nga nagtraidor doto ra nagatindug nga kaiban ang mga tao nga nagapangita kay Jesus. ");
INSERT INTO clu_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Pagkoon ni Jesus nga tana maman andang ginapangita, nagaratras sanda kag nagkaratomba sa logta. ");
INSERT INTO clu_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ginpamangkot sanda ruman ni Jesus kon sino andang ginapangita. Makon nanda ruman, “Si Jesus nga taga-Nazaret.” ");
INSERT INTO clu_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Makon ni Jesus kananda, “Kabay ginkonan ko kamo ron nga ako dato. Gani kon ako gid man indong ginapangita, pabayani nindo lang nga magalin akun mga kaiban nga dia.” ");
INSERT INTO clu_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","(Ginambal na dia agud matoman anang koon sa Amay, nga ara gid may nadora bisan sangka tao sa mga ginintriga kanana.) ");
INSERT INTO clu_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Karon, si Simon Pedro tana may dara nga garab. Ginabot na anang garab nga dato kag linabo anang sorogoon ang pinakamataas nga pari kag nautas anang too nga talinga. (Anang aran ang sorogoon nga dato si Malco.) ");
INSERT INTO clu_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Makon ni Jesus kay Pedro, “Balikan imong garab sa anang taguban. Basi imong pagsarig indi ko pagantoson anang ginapaantos kanakun ang Amay?” ");
INSERT INTO clu_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Gindakup si Jesus ang mga Romano nga soldado sa pagpangona andang kapitan, kag kaiban ra ang mga goardya nga mga Judio. Ginapos nanda tana ");
INSERT INTO clu_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","kag gindara dayon doto kay Anas nga panogangan ni Caifas. Si Caifas nga dia maman ang pinakamataas nga pari sa toig nga dato. ");
INSERT INTO clu_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Tana ra ang nagkoon sa mga Judio nga mas mayad nga sangka tao lang ang mapatay para sa tanan nga mga tao. ");
INSERT INTO clu_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Si Simon Pedro kag ang isara pa gid ka somolonod nagsonod ra doto kay Jesus. Kilala ang pinakamataas nga pari ang somolonod nga dato, gani nakasulud tana sa lagwirta ang pinakamataas nga pari kaiban ni Jesus. ");
INSERT INTO clu_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Piro si Pedro tana nasala doto sa goa sa may poirtaan. Karon, ang somolonod nga dato nga kilala ang pinakamataas nga pari nagbalik doto sa goa kag ginambal na ang babai nga nagabantay doto sa poirtaan, kag ginpasulud na si Pedro. ");
INSERT INTO clu_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Makon ang babai nga dato kay Pedro, “Indi bala nga ikaw isara ra sa anang mga somolonod ang tao nga dato?” Makon ni Pedro kanana, “Bukun.” ");
INSERT INTO clu_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Tungud nga maramig ang gabi nga dato, nagdabok kalayo ang mga sorogoon kag ang mga goardya kag nagtirindug sa palibot agud magpainit-init. Nagtindug ra doto si Pedro kag nagpainit-init. ");
INSERT INTO clu_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Karon, ginimbistigar ang pinakamataas nga pari si Jesus ang parti sa anang mga somolonod kag sa anang mga ginapanodlo. ");
INSERT INTO clu_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Makon ni Jesus kanana, “Bukun sa sikrito akun ginatodlo sa mga tao. Ay nagpanodlo ako mismo sa mga simbaan kag sa timplo nga ginatiriponan ang tanan nga mga Judio. Ara ako may gintodlo sa sikrito. ");
INSERT INTO clu_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ta basi ako indong ginapamangkot? Pamangkota nindo ang mga tao nga nakabati kon ano akun mga gintodlo kananda ay naulaman nanda.” ");
INSERT INTO clu_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Pagkaambal dia ni Jesus, sinampal tana ang sangka goardya nga nagatindug doto sa anang marapit. Makon ang goardya kanana, “Basi toladan imong sabat sa pinakamataas nga pari?” ");
INSERT INTO clu_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Makon ni Jesus kanana, “Kon akun sabat malain, magkoon kaw kon ano doto ang malain. Piro kon osto ra, ta basi ginsampal mo ako?” ");
INSERT INTO clu_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Karon, si Jesus nga nakagapos pa ginpadara dayon ni Anas kay Caifas nga maman gid ang pinakamataas nga pari sa tyimpo nga dato. ");
INSERT INTO clu_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Mintras nagatindug pa si Pedro sa marapit ang kalayo nga nagapainit-init, ginpamangkot tana ang mga tao. Makon nanda, “Indi bala nga ikaw isara ra sa anang mga somolonod ang tao nga dato?” Nagpanginwara ruman si Pedro, makon na, “Bukun.” ");
INSERT INTO clu_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Karon, ang isara doto sa mga sorogoon ang pinakamataas nga pari paryinti ang tao nga anang talinga gintigbas ni Pedro. Makon na, “Midyo nakita ta kaw gani nga kaiban ang tao nga dato doto sa logar nga may gintanum nga mga kaoy.” ");
INSERT INTO clu_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Piro nagpanginwara ruman gid si Pedro nga bukun tana. Kag lagi-lagi nagtorook ang manok. ");
INSERT INTO clu_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Alin kay Caifas gindara nanda si Jesus doto sa palasyo ang Gobirnador. Kasanagun run dato. Ang mga Judio ara nagsulud sa palasyo tungud nga sono sa andang mga soronodon, kon magsulud sanda sa balay ang bukun Judio, indi sanda run pagtogotan nga magkaun ang yapon nga para sa Pista anang Paglubas ang Angil. ");
INSERT INTO clu_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Gani si Pilato maman ang naggoa doto kananda kag nagpamangkot kon ano andang akosasyon kontra kay Jesus. ");
INSERT INTO clu_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Makon nanda, “Kon ara tana may naimo nga malain ara namun tana gindara digi kanimo.” ");
INSERT INTO clu_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Makon ni Pilato kananda, “Ta dara nindo tana kag kamo tana ang magosgar kanana sono sa indong kasogoan.” Makon roman ang mga Judio, “Piro ara kami awtoridad nga magsintinsya kamatayun sa tao.” ");
INSERT INTO clu_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","(Dia natabo agud matoman anang koon ni Jesus kon ano nga klasi nga kamatayun anang maagian.) ");
INSERT INTO clu_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Gani nagsulud ruman si Pilato kag gintawag na si Jesus. Makon na, “Ikaw manda anang ari ang mga Judio?” ");
INSERT INTO clu_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Makon anang sabat ni Jesus, “Kanimo gid bala dan nga pamangkot, okon may mga nagsogid kanimo parti kanakun?” ");
INSERT INTO clu_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Makon ni Pilato, “Ano imong pagsarig kanakun ay, Judio? Imong mga kasimanwa kag andang mga manogdomara nga mga pari maman ang nagdara kanimo digi kanakun. Ay basi ano imong ginimo?” ");
INSERT INTO clu_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Makon ni Jesus kanana, “Akun ginarian ara digi sa kalibotan nga dia. Kon digi akun ginarian sa kalibotan nga dia, nagpakigaway andan akun mga somolonod agud indi ako madakup ang mga Judio. Piro ang matood tana, akun ginarian ara digi sa kalibotan nga dia.” ");
INSERT INTO clu_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Gani makon ni Pilato kanana, “Kon maman dan, ari kaw gali!” Makon ni Jesus kanana, “Tama imong koon nga ako ari. Kag ang kabangdanan nga nagayan ako digi sa kalibotan kag nagpakatao ay agud isogid ko sa mga tao ang kamatoodan. Kag ang tanan nga gosto makaulam ang kamatoodan nagapamati kanakun.” ");
INSERT INTO clu_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Makon dayon ni Pilato, “Ta ano ang kamatoodan?” Pagkaambal dato ni Pilato, naggoa tana ruman doto sa mga Judio. Makon na kananda, “Ara ako may nakita nga sala sa tao nga dia. ");
INSERT INTO clu_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Kabay may ogali kamo nga kada Pista anang Paglubas ang Angil nagapangayo kamo kanakun sangka priso nga bolyawan. Gani gosto nindo bala nga bolyawan ko anang Ari ang mga Judio?” ");
INSERT INTO clu_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Nagsabat ang mga tao nga nagasiringgit, makon nanda, “Indi mo pagbolyawan ang tao nga dan! Si Barrabas run lang!” (Si Barrabas nga dia tolisan.) ");
INSERT INTO clu_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Gani ginpabuul ni Pilato si Jesus kag ginpaanot na. ");
INSERT INTO clu_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Pagkatapos nagimo dayon ang mga soldado ang koro-korona nga poros siit kag ginsoklob nanda sa anang olo ni Jesus. Ginpasoksokan nanda tana ra ang kapa nga granati, ");
INSERT INTO clu_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","kag pagkatapos sigi andang parapit kanana nga nagaintrimis nga nagakoon, “Dayawon anang Ari ang mga Judio.” Kag ginsampal nanda tana dayon. ");
INSERT INTO clu_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Naggoa ruman si Pilato doto sa mga tao kag makon na kananda, “Pagoaun ko tana ruman digi kanindo agud ipakita kanindo nga ara ako gid may nakita nga kabangdanan agud sintinsyaan tana.” ");
INSERT INTO clu_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Gani naggoa si Jesus nga may koro-korona nga poros siit kag kapa nga granati. Makon dayon ni Pilato kananda, “Sulunga nindo tana!” ");
INSERT INTO clu_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Pagkakita kanana ang mga manogdomara nga mga pari kag mga goardya, nagsiringgit sanda, makon nanda, “Ilansang tana sa kros! Ilansang tana sa kros!” Makon ni Pilato kananda, “Sigi, kamo ang maglansang kanana sa kros, ay ara ako gid may nakita nga sala kanana.” ");
INSERT INTO clu_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Nagsabat ang mga Judio, makon nanda, “May kasogoan kami, kag sono sa amun kasogoan ang tao nga dia dapat nga patayun, ay nagakoon tana nga tana kono anang Bata ang Dios.” ");
INSERT INTO clu_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pagkabati dato ni Pilato, nagdogang run gid anang kaadluk. ");
INSERT INTO clu_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Gani gindara na ruman si Jesus sa sulud ang palasyo kag ginpamangkot kon taga-diin tana. Piro ara nagsabat si Jesus. ");
INSERT INTO clu_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Gani makon ni Pilato kanana, “Basi indi kaw magsabat kanakun? Ara kaw bala kaulam nga ako may awtoridad nga bolyawan kaw okon ipalansang sa kros?” ");
INSERT INTO clu_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Makon ni Jesus kanana, “Ikaw ara gid may maimo kanakun kon ara kaw pagtawi gaum ang Dios. Gani mas mabaul anang sala ang tao nga nagintriga kanakun digi kanimo.” ");
INSERT INTO clu_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pagkabati dato ni Pilato nagpangita tana pa gid paagi nga mabolyawan si Jesus. Garing nagsiringgit ang mga Judio, makon nanda, “Kon bolyawan mo tana, nagakontra kaw sa Impirador ang Roma. Ay ang bisan sino nga nagapakaari anang kaaway ang Impirador.” ");
INSERT INTO clu_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pagkabati dato ni Pilato, gindara na si Jesus sa goa kag nagpongko tana sa anang porongkoan ang manogsintinsya, doto sa logar nga kon tawagun “Plataporma nga Bato.” (Sa Hebreo nga ambal dia ginatawag “Gabbata”.) ");
INSERT INTO clu_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Mga alas dosi gid dato ang ogto kag dispiras ang pista. Makon ni Pilato sa mga Judio, “Dagi run indong ari.” ");
INSERT INTO clu_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Nagsiringgit sanda dayon nga nagakoon, “Patayun tana! Ilansang tana sa kros!” Gani nagpamangkot kananda si Pilato, makon na, “Gosto nindo bala nga ilansang ko sa kros indong ari?” Makon ang mga manogdomara nga mga pari, “Ara kami ibang ari kondi ang Impirador!” ");
INSERT INTO clu_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Gani ginintriga ni Pilato si Jesus kananda agud ipalansang sa kros. Gani gindara si Jesus ang mga soldado ");
INSERT INTO clu_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","kag naggoa sanda sa siodad. Ginpapasan nanda kay Jesus anang kros paayan sa logar nga kon tawagun, “Bongo ang Tao.” (Sa Hebreo nga ambal dia ginatawag “Golgota”.) ");
INSERT INTO clu_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Doto nanda tana ginlansang sa kros. May darwa ra ka tao nga andang ginpadungan lansang kanana, ang isara sa wala kag ang isara sa too, kag si Jesus nakabutang sa tunga. ");
INSERT INTO clu_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Si Pilato nagpaimo karatola nga anang ginpabutang sa anang kros ni Jesus. Ang nakasolat doto toladia, “Si Jesus nga taga-Nazaret, anang Ari ang mga Judio.” ");
INSERT INTO clu_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ginsolat dato sa mga ambal nga Hebreo, Latin, kag Griego, kag dorong mga Judio ang nakabasa, ay ang logar nga ginlansangan kay Jesus marapit lang sa siodad. ");
INSERT INTO clu_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Makon anang mga manogdomara nga mga pari ang mga Judio kay Pilato, “Andan bukun ‘Anang Ari ang mga Judio’ imong ginsolat, kondi ‘Ang tao nga dia nagakoon nga tana kono anang Ari ang mga Judio.’” ");
INSERT INTO clu_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Makon ni Pilato, “Kon ano akun ginsolat doto indi ko ron pagomanun ay nakasolat ko ron.” ");
INSERT INTO clu_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Pagkalansang ang mga soldado kay Jesus sa kros ginbuul nanda anang mga lambong kag ginparti apat ka parti, kada soldado sangka parti. Ginbuul nanda ra anang pangidalum nga lambong ni Jesus nga ara binudbudan, ay diritso ang pagabul. ");
INSERT INTO clu_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Makon ang mga soldado sa isara kag isara, “Indi ta lang dia paggisakun. Maggarabot-gabot kita lang agud maulaman ta kon sino ang makabuul.” Sa andang ginimo nga dato natoman ang nasolat sa Kasolatan nga nagakoon, “Ginparti-parti nanda akun mga lambong kag gingabot-gabotan nanda akun pangidalum nga lambong.” Kag toladato manda anang ginimo ang mga soldado. ");
INSERT INTO clu_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Doto sa marapit anang kros ni Jesus nagatindug anang nanay, anang kabogto anang nanay, si Maria nga anang asawa ni Cleopas, kag si Maria nga taga-Magdala. ");
INSERT INTO clu_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Pagkakita ni Jesus sa anang nanay kag sa anang pinalangga nga somolonod nga nagatindug doto, makon na sa anang nanay, “Dan imong bata.” ");
INSERT INTO clu_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Makon na ra dayon sa anang somolonod nga dato, “Dan imong nanay.” Kag alin dato, anang nanay ni Jesus doto ron nagoli sa anang balay anang somolonod nga dato. ");
INSERT INTO clu_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Naulaman ni Jesus nga tapos ron ang tanan, gani agud matoman anang koon ang Kasolatan, makon na, “Ginawaw ako.” ");
INSERT INTO clu_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","May sangka suruludan doto nga may sulud nga maaslum nga bino. Gani gintosmog nanda ang isponga sa irinumun nga dato kag gintakud nanda dayon sa anang sanga ang isopo kag ginsulsul sa anang baba ni Jesus. ");
INSERT INTO clu_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Pagkasupsup na dato, makon na, “Tapos ron!” Nagdongok tana dayon kag nabogto anang ginawa. ");
INSERT INTO clu_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ang adlaw nga dato dispiras ang pista. Indi maliag ang mga Judio nga anang bangkay ang mga tao nga ginlansang sa kros masala doto tungud nga ang masonod nga adlaw, Adlaw nga Inogpaway, kag importanti gid nga pista para sa mga Judio. Gani ginpangabay nanda kay Pilato nga kon maimo pamariun anang mga batiis ang mga tao nga ginlansang sa kros agud magkarapatay sanda, kag pamulun dayon andang mga bangkay doto. ");
INSERT INTO clu_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Gani nagayan doto ang mga soldado kag ginpamari nanda anang mga batiis ang darwa ka tao nga ginlansang kaiban ni Jesus. ");
INSERT INTO clu_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Piro pagabot nanda kay Jesus, nakita nanda nga patay tana run, gani ara nanda run pagbaria anang mga batiis. ");
INSERT INTO clu_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Garing anang ginimo ang isara sa mga soldado, ginbono na ang bangkaw anang kilid ni Jesus kag lagi-lagi nagilig dayon ang dogo kag tobig. ");
INSERT INTO clu_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Dia nga mga natabo matood tungud nga nakita ko mismo. Gani naulaman ko nga akun ginsolat nga dia matood, kag ginsolat ko agud magtoo kamo ra. ");
INSERT INTO clu_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Dia natabo agud matoman ang nasolat sa Kasolatan nga nagakoon, “Ara gid miski sangka tolan nga bariun kanana.” ");
INSERT INTO clu_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","May nasolat pa gid sa Kasolatan nga nagakoon nga, “Sulungun nanda ang tao nga andang ginbono.” ");
INSERT INTO clu_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Pagkatapos dato, nagayan si Jose nga taga-Arimatea kay Pilato kag naglisinsya nga kon maimo togotan tana nga bulun anang bangkay ni Jesus sa kros. (Si Jose nga dia isara sa mga somolonod ni Jesus, garing sikrito lang ay naadlukan tana sa mga manogdomara ang mga Judio.) Gintogotan tana ni Pilato, gani ginbuul na anang bangkay ni Jesus. ");
INSERT INTO clu_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nagtabid ra kanana si Nicodemo. Ang ona, ang tao nga dia gabi nagayan kay Jesus. May dara tana nga bali 45 kilos nga paamot nga may simbog nga mira kag aloe. ");
INSERT INTO clu_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Pagkabuul nanda anang bangkay ni Jesus, ginpotos nanda sa panaptun nga mapoti nga andang ginamug ang paamot sono sa anang ogali ang mga Judio kon nagalubung ang patay. ");
INSERT INTO clu_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Karon, doto sa logar nga dato nga ginlansangan kay Jesus may gardin nga ginpananuman ang mga kaoy, kag doto may bago nga rulubungan nga gingoab sa bato nga midyo sa kowiba kag ara pa nalubungi. ");
INSERT INTO clu_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Kag tungud nga nagadali sanda ay ang adlaw nga dato dispiras run anang pista ang mga Judio, kag tungud nga marapit ang rulubungan nga dato, doto nanda run lang ginlubung si Jesus. ");
INSERT INTO clu_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Pagabot ang adlaw nga Domingo, madulum-dulum pa nagayan si Maria nga taga-Magdala doto sa ginlubungan. Pagabot na doto, nakita na nga anang takup nga bato ara run doto sa anang baba ang ginlubungan. ");
INSERT INTO clu_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Gani domalagan tana paayan kay Simon Pedro kag sa somolonod nga palangga ni Jesus. Pagabot na kananda makon na, “Ginbuul nanda ang Ginoo sa ginlubungan, kag ara kami kaulam kon diin nanda tana ginbutang!” ");
INSERT INTO clu_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Gani nagayan si Pedro kag ang somolonod nga dato doto sa ginlubungan. ");
INSERT INTO clu_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Nagdalagan sanda nga darwa, piro mas madasig ang isara nga dato kaysa kay Pedro. Gani naona tana nga nagabot sa ginlubungan. ");
INSERT INTO clu_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Pagabot na doto nagdongok tana kag naglingling. Nakita na doto ang mga panaptun nga mapoti nga gingamit ang paglubung, piro ara tana nagsulud. ");
INSERT INTO clu_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Malagat-lagat nagabot ra si Simon Pedro, piro tana tana nagdiritso sulud sa ginlubungan. Nakita na ra ang mga panaptun nga dato. ");
INSERT INTO clu_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Kag ang panyo nga ginpotos sa anang olo ni Jesus doto ra nagabalilin, piro bulag sa mga panaptun. ");
INSERT INTO clu_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","9","Nagsulud ra dayon ang somolonod nga naona magabot. Nakita na ra ang mga butang sa sulud, kag bisan ara sanda pa kaangup anang ginakoon ang Kasolatan nga kinanglan mabanaw si Jesus sa mga patay, nagpati tana sa oras nga dato nga nabanaw si Jesus. ");
INSERT INTO clu_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Kag nagoli dayon ang darwa nga dato ka somolonod ni Jesus. ");
INSERT INTO clu_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Karon, si Maria tana nagatindug pa gid doto sa goa ang ginlubungan nga nagapanangis. Mintras nagapanangis tana, nagdongok tana kag naglingling sa sulud ang ginlubungan. ");
INSERT INTO clu_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Nakita na nga doto sa sulud may darwa ka angil nga nagalambong ang poti. Doto sanda nagapongko sa logar nga ginbutangan anang bangkay ni Jesus. Ang isara sa oloan kampi kag ang isara sa sikian. ");
INSERT INTO clu_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Makon ang mga angil kay Maria, “Basi nagatangis kaw?” Makon ni Maria, “Ay may nagbuul anang bangkay akun Ginoo kag ara ako kaulam kon diin nanda ginbutang!” ");
INSERT INTO clu_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Pagkaambal na dato nagbalikid tana kag nakita na si Jesus nga nagatindug doto, piro ara na nakilala nga dato si Jesus gali. ");
INSERT INTO clu_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Nagpamangkot kanana si Jesus, makon na, “Basi nagatangis kaw? Sino imong ginapangita?” Anang pagsarig ni Maria anang nabalikidan nga dato manogasikaso ang mga tanum doto. Gani makon na kanana, “Kon ikaw ang nagbuul kanana, abi sogidi ako kon diin mo tana ginbutang, ay bulun ko.” ");
INSERT INTO clu_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Makon ni Jesus kanana, “Maria!” Nagliso si Maria kag nagatobang kay Jesus, kag makon na sa ambal nga Hebreo, “Rabboni!” (Kon kanatun pa, “Manogtodlo”.) ");
INSERT INTO clu_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Makon ni Jesus kanana, “Indi kaw anay magkaput kanakun, ay ara ako pa kakayab sa Amay. Imong imoon tana, ayanan mo akun mga kabogto kag sogidan mo sanda nga ako makayab run sa akun Tatay kag indong Tatay, sa akun Dios kag indong Dios.” ");
INSERT INTO clu_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Gani ginayanan ni Maria nga taga-Magdala anang mga somolonod ni Jesus kag ginsogidan na sanda dayon nga nakita na ang Ginoo. Kag ginsogid na ra kananda anang ginbilin ni Jesus. ");
INSERT INTO clu_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Pagkasirum ang adlaw nga dato nga Domingo, nagtiripon sa sangka balay ang mga somolonod. Kag tungud nga ginapangadlukan sanda sa mga manogdomara ang mga Judio ginpantrangkaan nanda anang mga poirtaan ang balay nga andang ginatiriponan. Nagabot dayon si Jesus kag nagtindug doto sa andang tunga. Makon na, “Ang kalinung dian kanindo.” ");
INSERT INTO clu_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Kag ginpakita na dayon kananda anang mga igad sa anang mga alima kag sa anang kilid. Kag nalipay nga mayad ang mga somolonod pagkakita nanda sa Ginoo. ");
INSERT INTO clu_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Kag makon na ruman, “Ang kalinung dian kanindo. Kon paiwan nga ginpadara ako ang Amay, magapadara ako ra kanindo.” ");
INSERT INTO clu_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Kag ginuyupan na sanda dayon kag nagkoon, “Batona nindo ang Ispirito Santo. ");
INSERT INTO clu_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Kon patawadun nindo anang mga sala ang bisan sino, dan patawadun da ang Dios. Piro kon indi nindo pagpatawadun, dan indi ra pagpatawadun ang Dios.” ");
INSERT INTO clu_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Karon, si Tomas nga anang ayo si Kapid isara ra sa anang dosi ka somolonod ni Jesus. Garing ara tana doto anang pagpakita ni Jesus. ");
INSERT INTO clu_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Gani ginsogidan tana anang mga kaiban nga mga somolonod nga nakita nanda ang Ginoo. Piro makon ni Tomas kananda, “Kon indi ko makita anang agi ang mga lansang sa anang alima, kag kon indi ko matandug anang mga igad, kag kon indi ko makagoro akun alima sa anang kilid, indi ako ra gid magpati.” ");
INSERT INTO clu_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Pagkatapos sangka simana, nagtiripon roman anang mga somolonod sa balay nga andang ginatiriponan, kag kaiban nanda run si Tomas. Ginpantrangkaan nanda anang poirtaan ang balay, piro nagsulud ruman si Jesus kag nagtindug doto sa andang tunga. Makon na ruman kananda, “Ang kalinung dian kanindo.” ");
INSERT INTO clu_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Kag makon na dayon kay Tomas, “Tomas, dali, sulunga run akun alima kag tanduga akun igad. Goroan ra dayon imong alima sa akun kilid. Indi ka run magdoda, kondi magtoo kaw.” ");
INSERT INTO clu_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Makon ni Tomas kay Jesus, “Ginoo ko kag Dios ko!” ");
INSERT INTO clu_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Makon dayon ni Jesus, “Ta nagatoo ka run dadi ay nakita mo ako? Piro mas masoirti ang mga tao nga nagatoo kanakun bisan ara nanda ako makita.” ");
INSERT INTO clu_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Doro pa gid nga mga milagro anang ginpangimo ni Jesus nga nakita mismo anang mga somolonod nga ara nagapil solat sa libro nga dia. ");
INSERT INTO clu_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Piro ang mga nasolat sa libro nga dia ginsolat agud magtoo kamo nga si Jesus manda ang Cristo nga anang Bata ang Dios. Kag kon magtoo kamo kanana may kaboi kamo nga ara kataposan. ");
INSERT INTO clu_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Pagkatapos pira ka adlaw, nagpakita ruman si Jesus sa anang mga somolonod doto sa baybay ang Dagat ang Tiberias. Toladia anang pagkakita kananda. ");
INSERT INTO clu_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Doto sa logar nga dato nagatiripon sanday Simon Pedro, si Tomas nga ginatawag nga si Kapid, si Natanael nga taga-Cana sa Galilea, anang mga bata ni Zebedeo, kag may darwa pa gid ka somolonod ni Jesus. ");
INSERT INTO clu_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Karon, makon ni Simon Pedro sa anang mga kaiban, “Mapangisda ako.” Makon nanda ra, “Matabid kami kanimo.” Gani nagsakay sanda sa sakayan kag nagpalaod. Piro sa sanggabi nga dato ara sanda gid may nabuul. ");
INSERT INTO clu_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Datong nagapamotipoti run ang adlaw, nakita nanda nga may nagatindug doto sa baybay. Ara sanda kaulam nga si Jesus gali dato. ");
INSERT INTO clu_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Makon ni Jesus kananda, “Ta may nabuul kamo?” Makon nanda, “Ara gid.” ");
INSERT INTO clu_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Makon na kananda, “Taktakan nindo indong lambat sa too kampi ang sakayan, dan may mabubuul kamo.” Gani tinaktak nanda doto andang lambat. Pagbatak nanda, indi sanda run kadaug sa karakuun ang isda nga andang nabuul. ");
INSERT INTO clu_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Makon kay Pedro ang somolonod nga palangga ni Jesus, “Ang Ginoo gali dato!” Pagkabati ni Pedro nga ang Ginoo gali dato, ginsoksok na anang lambong nga anang ginoba kag naglokso sa tobig kag naglangoy paayan kay Jesus doto sa baybay. ");
INSERT INTO clu_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ang iba nga mga somolonod nga doto sa sakayan nagparabaybay ra nga nagabutung ang lambat nga pono isda, ay andang karayuun sa baybay mga 50 ra lang ka dupa. ");
INSERT INTO clu_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Pagkatakas nanda, may nakita sanda nga nagatompok nga baga nga may nagasogba nga isda kag may tinapay ra. ");
INSERT INTO clu_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Makon dayon ni Jesus kananda, “Pagdara kamo digi pira ka bilog nga isda nga indong nabuul.” ");
INSERT INTO clu_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Gani nagsaka si Simon Pedro sa sakayan kag ginbutung na pabaybay ang lambat nga pono mabaraul nga isda nga bali 153 ka bilog tanan. Ara ra gid nagisi ang lambat miski toladato karaku andang nabuul. ");
INSERT INTO clu_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Makon ni Jesus kananda, “Dali, pagpamaw kamo.” Kag ara gid may nagpangaas sa anang mga somolonod nga magpamangkot kon sino tana, ay naulaman nanda nga tana ang Ginoo. ");
INSERT INTO clu_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ginbuul dayon ni Jesus ang tinapay kag ginpanawan na sanda. Toladato ra anang ginimo sa isda. ");
INSERT INTO clu_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ikatlo ron dia ka bisis nga si Jesus nagpakita sa anang mga somolonod alin anang pagkabanaw. ");
INSERT INTO clu_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Pagkatapos nanda pamaw makon ni Jesus kay Simon Pedro, “Simon nga bata ni Juan, ano, ginaigogma mo bala ako kaysa imong mga kaiban nga dia?” Makon anang sabat ni Pedro, “Uu, Ginoo, naulaman mo nga ginaigogma ko ikaw.” Makon ni Jesus kanana, “Ta asikasoa akun mga tomoloo pario anang pagasikaso ang pastor sa anang mga karniro.” ");
INSERT INTO clu_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Makon roman ni Jesus kanana, “Simon nga bata ni Juan, ano, ginaigogma mo ako?” Makon na ruman, “Uu, Ginoo, naulaman mo nga ginaigogma ko ikaw.” Makon ni Jesus kanana, “Asikasoa akun mga karniro.” ");
INSERT INTO clu_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Sa ikatlo ka bisis makon ni Jesus kanana, “Simon nga bata ni Juan, ano, ginaigogma mo ako?” Naborido si Pedro tungud nga ikatlo ron ka bisis nga tana ginpamangkot ni Jesus kon ginaigogma na tana. Gani makon ni Pedro, “Ginoo, naulaman mo ang tanan, kag naulaman mo gid nga ikaw ginaigogma ko.” Makon ni Jesus kanana, “Asikasoa akun mga karniro. ");
INSERT INTO clu_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Sa matood tana, ang ona ang bata ka pa, ikaw mismo ang nagsoksok imong akus kag nagayan sa kon diin imong gosto. Piro kon malam ka run gani, padupaun ka lang kag iba run ang magaakus kanimo, kag daraun kaw dayon sa logar nga indi mo gosto nga ayanan.” ");
INSERT INTO clu_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Ginambal dia ni Jesus agud ipakita kananda kon ano ang klasi nga kamatayun anang maagian ni Pedro, kag paagi sa kamatayun nga dato dadayawon ang Dios.) Pagkatapos makon ni Jesus kay Pedro, “Pagsonod kanakun.” ");
INSERT INTO clu_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pagbalikid ni Pedro nakita na nga nagasonod kananda anang pinalangga nga somolonod ni Jesus. (Tana maman ang marapit gid kay Jesus ang nagayapon sanda kag maman ang nagpamangkot sa Ginoo kon sino ang magatraidor kanana.) ");
INSERT INTO clu_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pagkakita ni Pedro kanana makon na kay Jesus, “Ginoo, ano tana anang maagian ang tao nga dan?” ");
INSERT INTO clu_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Makon ni Jesus kanana, “Kon gosto ko nga indi tana mapatay asta magbalik ako digi sa kalibotan, ta ano ra dan anang labut kanimo? Basta ikaw tana magsonod kanakun.” ");
INSERT INTO clu_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Gani naglapnag ang barita sa mga kabogto sa Ginoo nga ang somolonod nga dato indi mapatay. Piro ara nagkoon si Jesus nga indi tana mapatay, kondi anang koon tana, “Kon gosto ko nga indi tana mapatay asta magbalik ako, ta ano ra dan anang labut kanimo?” ");
INSERT INTO clu_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ako ang somolonod nga dato kag ako mismo nagapamatood nga matood akun mga ginsolat nga dia. Kag naulaman ta nga akun mga ginasogid matood. ");
INSERT INTO clu_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Doro pa gid anang mga ginpangimo ni Jesus nga kon isara-isaraun solat, sigoro indi magigo sa bilog nga kalibotan ang tanan nga libro nga solatan.");
INSERT INTO clu_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Pinalangga ko nga Teofilo, sa akun primiro nga libro ginsolat ko ang tanan nga ginimo kag ginpanodlo ni Jesus alin pa ang ompisa ");
INSERT INTO clu_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","3","asta sa oras nga tana gindara sa langit. Pagkatapos nga tana napatay kag nabanaw, kon kapira tana nagpakita sa sari-sari nga paagi sa anang mga apostolis nga tana nabanaw matood alin sa mga patay. Sa sulud 40 ka adlaw nagpakita tana kananda kag gintodloan na sanda parti sa anang ginarian ang Dios. Kag bago tana magpalangit may mga sogo tana nga ginbilin sa anang mga pinili nga mga apostolis. Anang mga bilin nga dato gintaw na kananda paagi sa anang gaum ang Ispirito Santo. ");
INSERT INTO clu_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","May bisis nga mintras nagakaun si Jesus kaiban nanda nagbilin tana kananda nga makon na, “Indi kamo anay magalin sa Jerusalem. Ulatun nindo anay ang Ispirito Santo nga ginpangako ang Dios nga Amay. Ginsogid ko ron nga lagi dia kanindo ang ona. ");
INSERT INTO clu_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ang ona, si Juan nagpangbunyag ang mga tao sa tobig, piro sa pira ka adlaw bubunyagan kamo sa Ispirito Santo.” ");
INSERT INTO clu_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","May sangka bisis ruman nga mintras nagatiripon sanda ginpamangkot nanda si Jesus, makon nanda, “Ginoo, maman run bala dia ang oras nga paalinun mo ang mga taga-Roma nga nagadomara kanatun agud kita nga mga taga-Israel makadomara ruman atun kaogalingun?” ");
INSERT INTO clu_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Makon anang sabat ni Jesus, “Ara kamo ginatogoti ang Amay nga maulaman nindo kon sano magakaratabo ang mga butang nga anang gintakda. ");
INSERT INTO clu_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Piro pagabot kanindo ang Ispirito Santo tawan na kamo gaum. Kag isogid nindo dayon ang mga butang parti kanakun, alin digi sa siodad ang Jerusalem asta sa bilog nga probinsya ang Judea kag Samaria, kag asta sa bilog nga kalibotan.” ");
INSERT INTO clu_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Pagkakoon na dia, gindara tana pa langit. Kag mintras nagasulung sanda kanana nga nagapaibabaw, ginlikupan tana dayon ang panganod kag nadora tana sa andang panulung. ");
INSERT INTO clu_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Mintras nagasulung sanda pa nga mayad sa langit, may darwa ka lalaki nga nagalambong ang mapoti nga golpi nga nagtindug sa andang marapit. ");
INSERT INTO clu_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Makon dayon ang mga lalaki kananda, “Kamo nga mga taga-Galilea, basi nagatirindug kamo pa gid digi nga nagasulung sa langit? Si Jesus nga dia nga indong nakita nga gindara paibabaw magabalik digi sa kalibotan. Kag kon paiwan tana nagpaibabaw, toladan ra anang pagbalik.” ");
INSERT INTO clu_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Pagkatapos dato, nagbalik ang mga apostolis sa Jerusalem alin sa Bokid ang mga Olibo. Ang bokid nga dia mga sangka kilomitro anang karayu sa siodad ang Jerusalem. ");
INSERT INTO clu_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Pagabot nanda sa Jerusalem nagsaka sanda sa ibabaw nga koarto ang balay nga andang ginadayonan. Ang mga lalaki nga dato sanday Pedro, Juan, Santiago, Andres, Felipe, Tomas, Bartolome, Mateo, si Santiago nga bata ni Alfeo, si Simon nga mimbro anay ang mga ribolosionario, kag si Judas nga bata ni Santiago. ");
INSERT INTO clu_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Dia sanda pirmi nga nagatiripon agud magpangamoyo. Kaiban nanda ra ang pira ka mga babai pati si Maria nga nanay ni Jesus, kag anang mga kabogto nga lalaki ni Jesus. ");
INSERT INTO clu_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","May pira ka adlaw nagtiripon ang mga 120 ka tomoloo. Nagtindug si Pedro kag magkoon, makon na, ");
INSERT INTO clu_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Mga kabogto, kinanglan matoman anang koon ang Kasolatan nga gintagna ang Ispirito Santo ang ona paagi kay David parti kay Judas, nga maman ang nagdara sa mga nagdakup kay Jesus. ");
INSERT INTO clu_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Kabilang tana ra kanamun nga mga apostolis nga anang ginpili ni Jesus, kag kaiban namun tana ra sa amun obra.” ");
INSERT INTO clu_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Piro si Judas nagbakal logta alin sa koarta nga anang nabaton sa anang ginimo nga malain, kag doto tana naglagpak nga padapa. Anang tian nabostik kag nagwagay anang tinai. ");
INSERT INTO clu_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Nabaritaan dia ang tanan nga tao sa Jerusalem, gani gintawag nanda ang logta nga dato nga Akeldama, nga ang gostong ambalun, “Logta nga nadogoan”.) ");
INSERT INTO clu_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Makon pa ni Pedro, “Nasolat run nga lagi sa mga Salmo nga nagakoon, ‘Pabayanan run lang anang ginaolian, Kag dapat ara run may magoli doto.’ Kag nasolat ra, ‘Itaw ron lang sa iba anang obra.’ ");
INSERT INTO clu_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Gani, kinanglan nga magpili kita sangka tao nga idogang kanamun nga onsi ka apostolis. Kinanglan isara tana sa mga naging kaiban namun nga nagtabid-tabid kay Ginoong Jesus ang digi tana pa sa kalibotan, ompisa ang nagpabunyag tana kay Juan asta sa oras nga gindara si Jesus sa langit, tungud nga kinanglan nga makapamatood tana kaiban namun parti sa anang pagkabanaw ni Jesus.” ");
INSERT INTO clu_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Gani nagpili sanda darwa ka lalaki: si Matias kag si Jose nga kon tawagun si Barsabas (okon Justo). ");
INSERT INTO clu_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Pagkatapos nagpangamoyo sanda dayon, makon nanda, “Ginoo, ikaw ang kaulam anang tagiposoon ang tanan nga tao. Gani ipakita mo kanamun kon sino sa darwa nga dia imong ginpili ");
INSERT INTO clu_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","nga maging apostol bilang tulus ni Judas. Ay ginbayaan ni Judas anang obra bilang isara sa mga apostolis, kag nagayan tana sa logar nga bagay kanana.” ");
INSERT INTO clu_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Pagkatapos nga sanda makapangamoyo, naggabot-gabot sanda. Kag ang napili si Matias. Gani si Matias maman ang gindogang sa onsi ka apostolis. ");
INSERT INTO clu_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pagabot ang adlaw ang pista nga kon tawagun Pentecostes, nagtiripon ang tanan nga mga tomoloo sa sangka balay. ");
INSERT INTO clu_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Mintras nagatiripon sanda, golpi lang nga may nagdagono nga alin sa langit nga midyo sa mabaskug nga angin nga nagabagrong, kag poros ron lang dagono andang nababatian sa sulud ang balay nga andang ginatiriponan. ");
INSERT INTO clu_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Kag may nakita sanda dayon nga mga dabdab ang kalayo nga midyo sa mga dila nga nagrapta kag nagtongtong sa kada isara kananda. ");
INSERT INTO clu_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Sanda tanan gingauman ang Ispirito Santo, kag nagarambal sanda dayon sa iba-ibang mga ambal nga ara nanda natoni. Ang Ispirito Santo maman ang nagpaambal kananda toladato. ");
INSERT INTO clu_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Karon, doto sa Jerusalem may mga Judio nga riliyoso nga nagaralin sa iba-ibang nasyon sa bilog nga kalibotan. ");
INSERT INTO clu_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Pagkabati nanda ang dagono nga dato, nagdaragoyon sanda doto sa ginatiriponan ang mga apostolis. Natingala sanda nga mayad tungud nga ang kada isara kananda nakabati nga anang linggowai ginaambal ang mga tomoloo. ");
INSERT INTO clu_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Makon nanda, “Ano kabay dia? Poros dia mga taga-Galilea. ");
INSERT INTO clu_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Piro basi atun mga ambal maman atun nababatian nga andang ginaambal? ");
INSERT INTO clu_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ang iba kanatun taga-Partia. May mga taga-Media, kag ang iba taga-Elam. May mga taga-Mesopotamia, Judea, kag Capadocia. May digi ra nga taga-Ponto kag Asia. ");
INSERT INTO clu_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Ang iba mga taga-Frigia, taga-Panfilia, taga-Egipto, kag ang iba alin sa mga logar nga sakup ang Libia nga marapit sa Cirene. May mga taga-Roma, mga Judio kag mga bukun Judio nga nagintra sa anang riliyon ang mga Judio. ");
INSERT INTO clu_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Kag ang iba alin sa Creta kag Arabia. Piro bisan iba-iba atun mga linggowai nababatian ta nga sanda nagaarambal sa tanan ta nga mga linggowai parti sa makatiringala nga mga inimoan ang Dios!” ");
INSERT INTO clu_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Natingala nga mayad ang tanan nga mga tao doto. Kag tungud nga indi nanda maintindian kon ano ang natatabo sigi-sigi run lang andang paramangkotan sa isara kag isara. Makon nanda, “Ano kabay dia?” ");
INSERT INTO clu_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Piro ang iba tana nagtoya-toya sa mga tomoloo. Makon nanda, “Mga Lingin ang mga tao nga dan!” ");
INSERT INTO clu_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Gani tomindug si Pedro kaiban ang iba nga onsi ka apostolis kag nagambal mabaskug sa mga tao, makon na, “Mga kapario ko nga mga Judio, kag tanan kamo nga mga pomoloyo sa Jerusalem, pamatii nindo ako ay isogid ko kon ano anang kaologan ang mga butang nga dia. ");
INSERT INTO clu_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Sala indong isip nga lingin ang mga tao nga dia, ay alas noibi pa lang dia ang aga. ");
INSERT INTO clu_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Kondi dia tana maman anang gintagna ang ona ni propita Joel. Makon na, ");
INSERT INTO clu_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Ang Dios nagkoon, “Sa oring mga adlaw itaw ko akun Ispirito sa tanan nga klasi nga mga tao. Kag anang risolta dan, indong mga bata nga lalaki kag babai magabarita akun mga ambal; Indong mga binata makakikita akun mga ipapakita kananda; Kag ang mga maulam-ulam nga mga lalaki padamgoon ko. ");
INSERT INTO clu_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Magabot matood ang adlaw nga itaw ko akun Ispirito sa akun mga sorogoon nga lalaki kag babai, Kag sanda magabarita akun mga ambal. ");
INSERT INTO clu_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Magapakita ako mga milagro sa langit kag sa logta: may makikita nga dogo, kalayo, kag madamul nga aso nga nagarobokrobok. ");
INSERT INTO clu_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Magadulum ang adlaw, kag ang bolan magapola pario sa dogo. Dia matatabo bago magabot ang makatiringala nga adlaw nga dato nga ang Ginoo magaukum. ");
INSERT INTO clu_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Piro ang bisan sino nga magpanawag sa Ginoo malilibri sa silot nga magaabot.”’” ");
INSERT INTO clu_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Makon pa ni Pedro, “Mga kapario ko nga mga kaapo-apoan ni Israel, pamatii nindo ako! Si Jesus nga taga-Nazaret ginsogo digi ang Dios, kag dia ginpamatodan ang Dios paagi sa mga milagro kag mga katiringala nga mga butang nga anang ginpangimo paagi kanana. Kag kamo mismo nakaulam sa mga butang nga dia tungud nga tanan dia nagkaratabo digi kanindo. ");
INSERT INTO clu_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Naulaman nga lagi ang Dios ang ona nga si Jesus nga dia itogyan kanindo tungud nga maman da nga lagi dato anang plano. Kag ginpapatay nindo tana sa mga makasasala nga mga tao nga naglansang kanana sa kros. ");
INSERT INTO clu_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Piro ginbanaw tana ang Dios kag ginlowas sa gaum ang kamatayun, tungud nga ang matood tana, miski kamatayun pa ara gaum nga magawid kanana. ");
INSERT INTO clu_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Makon ni David parti kanana, ‘Naulaman ko nga ang Ginoo pirmi nga nagatabid kanakun kag ara na ako ginabayai. Gani indi ako matoblag. ");
INSERT INTO clu_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Maman dia nga nalilipay ako Kag indi mapugungan akun pagdayaw sa Dios. Kag bisan mapapatay ako, padayon ako nga may paglaum. ");
INSERT INTO clu_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ay naulaman ko nga indi mo pagpabayanan akun kalag doto sa anang logar ang mga patay. Kag indi mo ra pagtogotan nga maronot imong matutum nga sorogoon. ");
INSERT INTO clu_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Gintodlo mo kanakun ang mga dalan nga paayan sa kaboi nga ara kataposan, Kag tungud nga ikaw pirmi akun kaiban, malilipay ako nga mayad.’” ");
INSERT INTO clu_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Makon pa ni Pedro, “Mga kabogto, masanag nga ara nagambal si David parti sa anang kaogalingun, ay ulam ta nga atun kaolang-olangan nga si David napatay kag ginlubung, kag asta gani dadi ulam ta kon diin ang ginlubungan kanana. ");
INSERT INTO clu_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Propita si David kag naulaman na nga ang Dios nagpangako kanana nga isara sa anang mga kaapo-apoan maman ang magapanobli anang ginarian. ");
INSERT INTO clu_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Kag tungud nga naulaman ni David kon ano anang imoon ang Dios, nagambal tana parti sa anang pagkabanaw ni Cristo, nga ara tana pagpabayani doto sa anang logar ang mga patay, kag anang lawas ara naronot. ");
INSERT INTO clu_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Anang ginatomod ara iba kondi si Jesus nga ginbanaw ang Dios sa mga minatay, kag kami tanan makapamatood nga nabanaw tana manda tungud nga nakita namun tana mismo. ");
INSERT INTO clu_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ginpapongko tana sa pinakamataas nga podir sa anang too ang Dios. Gintaw kanana ang Amay ang Ispirito Santo nga anang ginpangako kanana. Kag ang Ispirito Santo nga dia ginpadara ni Jesus kanamun, kag anang gaum maman indong nakikita kag nababatian dadi. ");
INSERT INTO clu_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Makon pa ni David, ‘Makon ang Ginoong Dios sa akun Ginoo, Digi pagpongko sa akun too, Asta mapasoko ko kanimo imong mga kaaway.’ Pagsolat ni David dato bukun anang kaogalingun nga lawas anang ginakoon kondi anang Ginoo nga si Jesus. Ay si David tana ara pa kasaka sa langit. ");
INSERT INTO clu_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Gani dapat gid nga maulaman ang tanan nga mga kaapo-apoan ni Israel nga si Jesus nga dia nga indong ginlansang sa kros maman anang ginpili ang Dios nga maging atun Ginoo kag Cristo.” ");
INSERT INTO clu_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Pagkabati dato ang mga tao natandug andang mga tagiposoon. Gani makon nanda kay Pedro kag sa iba nga mga apostolis, “Mga kabogto, ano amun dapat imoon?” ");
INSERT INTO clu_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Makon ni Pedro kananda, “Magirinulsul kamo indong mga sala kag magparabunyag ang kada isara kanindo agud ipakita nga kamo kay Jesu-Cristo ron, kag mapatawad dayon indong mga sala kag mababaton nindo anang ginpangako ang Dios nga ara iba kondi ang Ispirito Santo. ");
INSERT INTO clu_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Tungud nga ang ginpangako nga dia nga Ispirito Santo para kanindo kag sa indong mga bata. Kag bukun lang para kanindo kondi para ra sa tanan nga mga tao doto sa marayu nga mga logar, ang tanan nga tatawagun ang Ginoo nga atun Dios nga magrapit kanana.” ");
INSERT INTO clu_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Kag doro pa anang mga ginsambit ni Pedro agud pamatodan kananda anang mga ginambal. Kag ginsugyut na sanda nga magpanginlowas sa silot nga magaabot sa mga malain nga mga tao. ");
INSERT INTO clu_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Doro ang nagpati sa anang minsai kag nagparabunyag sanda dayon. Sa adlaw nga dato mga 3,000 ka mga tao ang nagdogang sa mga tomoloo. ");
INSERT INTO clu_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Kag nagmaukud sanda sa pagtoon anang mga ginatodlo ang mga apostolis, sa pagtiripon bilang magkarabogto, sa pagpamiak-piak ang tinapay, kag sa pagpangamoyo. ");
INSERT INTO clu_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Dorong mga milagro kag mga makatiringala nga mga butang anang ginpaimo ang Dios sa mga apostolis. Gani ang mga tao nagkaboi nga may pagtaod kag kaadluk sa Dios. ");
INSERT INTO clu_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Masuud anang pagtarabidan ang mga tomoloo kag ginbilang nanda nga andang mga pagkabutang bukun ana-ana lang kondi para sa tanan. ");
INSERT INTO clu_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ginapamaligya nanda andang mga logta kag mga pagkabutang, kag ginapanagtag nanda anang bayad sa andang mga kaiban sono sa anang kinanglan ang kada isara. ");
INSERT INTO clu_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Kada adlaw nagatiripon sanda sa timplo kag nagapamiak-piak ang tinapay sa andang mga balay. Malipayun sanda gid sa andang pagkaraiban sa pagkaun, ");
INSERT INTO clu_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","kag sigi andang pagdayaw sa Dios. Naliagan sanda ang tanan nga mga tao. Kag kada adlaw gindogang kananda ang Ginoo ang mga tao nga anang ginalowas. ");
INSERT INTO clu_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","May adlaw nga si Pedro kag si Juan nagayan sa timplo ang mga alas tris ang apon, tungud nga oras dato nga inogpangamoyo. ");
INSERT INTO clu_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Karon, doto sa poirtaan ang timplo may tao nga piang alin pa anang pagkabata. Adlaw-adlaw ginadara tana sa poirtaan nga dato, nga kon tawagun “Masadya”, agud magpalimos sa mga tao nga nagasurulud sa timplo. ");
INSERT INTO clu_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Pagkakita na kay Pedro kag kay Juan nga nagapasulud sa timplo, nagpangayo tana limos. ");
INSERT INTO clu_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ginsulung tana nga mayad ni Pedro kag ni Juan. Makon dayon ni Pedro kanana, “Pagsulung kanamun.” ");
INSERT INTO clu_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Nagsulung ra gani ang tao nga dato ay anang pagsarig lilimosan tana run. ");
INSERT INTO clu_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Piro makon ni Pedro kanana, “Ako ara gid koarta. Piro may digi ako nga inogtaw kanimo. Sa anang gaum ni Jesu-Cristo nga taga-Nazaret, pagpanaw!” ");
INSERT INTO clu_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Kag ginkaputan dayon ni Pedro anang too nga alima ang tao nga dato kag patindugun. Lagi-lagi nagbaraskug anang mga siki kag mga bokoboko. ");
INSERT INTO clu_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Naggolpi tana dayon tindug kag nagpanaw-panaw. Pagkatapos nagtabid tana kananda nga nagsulud sa timplo. Sigi anang panaw-panaw kag tombo-tombo nga nagadayaw sa Dios. ");
INSERT INTO clu_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Nakita ang tanan nga tana nagapanaw kag nagadayaw sa Dios. ");
INSERT INTO clu_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Namarasmasan nanda nga tana gali ang tao nga nagasari pongko kag nagapakilimos doto sa poirtaan ang timplo nga kon tawagun “Masadya”. Gani natingala sanda nga mayad sa natabo kanana. ");
INSERT INTO clu_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Aros indi run magbulag kay Pedro kag kay Juan ang tao nga dato, kondi sigi anang pangaput kananda mintras nagayan sanda sa logar nga kon tawagun Balkon ni Solomon. Nagdaragoyon ang tanan nga mga tao doto kananda ay natingala sanda gid. ");
INSERT INTO clu_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pagkakita ni Pedro sa mga tao makon na kananda, “Mga kapario ko nga mga kaapo-apoan ni Israel, basi natingala kamo? Basi nagasulung kamo nga mayad kanamun? Sigoro nagaunauna kamo nga napapanaw namun ang tao nga dia tungud sa amun gaum kag pagkadiosnon. ");
INSERT INTO clu_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Bukun! Kondi ang Dios nga ginsimba atun mga kaolang-olangan nga si Abraham, si Isaac, kag si Jacob maman ang nagimo dia agud padungugan na anang sorogoon nga si Jesus. Maman dia ang Jesus nga indong gintogyan sa mga may awtoridad kag indong ginsikway sa atobangan ni Pilato, miski nadisisyonan na run nga bolyawan. ");
INSERT INTO clu_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Matarung tana nga tao kag ara gid sala, piro ginsikway nindo tana kag ginpangabay nindo si Pilato nga bolyawan ang manogpatay tao sa baylo nga si Jesus. ");
INSERT INTO clu_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ginpatay nindo ang nagataw kaboi nga ara kataposan, piro ginbanaw tana ang Dios. Kag kami makapamatood nga nabanaw tana ay nakita namun mismo. ");
INSERT INTO clu_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Anang gaum anang aran ni Jesus maman ang nagtaw kabaskug sa tao nga dia nga indong kilala kag nakikita dadi. Kamo mga tistigo nga nagayad tana. Kag dia natabo tungud sa pagtoo kay Jesus. ");
INSERT INTO clu_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Mga kabogto, ulam ko nga kamo kag indong mga manogdomara nagimo toladato kay Jesus tungud nga ara kamo kaulam kon sino tana gid. ");
INSERT INTO clu_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Dan ginsogid run nga lagi ang Dios ang ona paagi sa mga propita, nga si Cristo kinanglan gid nga magantos, kag sa indong ginimo nga dato kanana natoman anang koon nga dato ang Dios. ");
INSERT INTO clu_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Gani dadi, kinanglan magirinulsul kamo ron kag magparapit sa Dios agud patawadun na kamo sa indong mga sala, ");
INSERT INTO clu_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","agud magaabot kanindo ang bago nga kabaskug nga alin sa Ginoo. Pagkatapos ipadara na ra si Jesus nga mismo ang Cristo nga anang ginpili ang ona para kanatun. ");
INSERT INTO clu_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Piro kinanglan doto lang anay si Jesus sa langit asta magabot ang oras nga mabago ang Dios ang tanan nga butang. Toladan nga lagi anang koon ang Dios ang ona paagi sa anang mga propita. ");
INSERT INTO clu_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Pario anang koon ni Moises, makon na, ‘Ang Ginoo nga atun Dios magataw kanindo sangka propita pario kanakun nga kanindo ra mismo magaalin. Dapat sonodon nindo ang tanan nga anang ginakoon kanindo. ");
INSERT INTO clu_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ang indi magtoman sa anang ginakoon ang propita nga dato ipabulag sa mga tao ang Dios kag madodora.’ ");
INSERT INTO clu_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Toladan ra anang koon ang tanan nga mga propita alin nga lagi kay Samuel, sanda nga tanan nagsogid parti sa mga butang nga nagakaratabo dadi. ");
INSERT INTO clu_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Anang mga ginpangako ang Dios paagi sa anang mga propita para gid kanatun nga mga Judio, kag kabilang kita sa kasogtanan nga ginimo ang Dios sa atun mga kaolang-olangan tungud nga nagkoon tana kay Abraham, makon na, ‘Bindisyonan ko ang tanan nga mga tao sa kalibotan paagi sa imong kaliwat.’ ");
INSERT INTO clu_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Gani ginpadara anay ang Dios anang pinili nga Sorogoon kanatun nga mga Judio agud maboligan na kita nga magbaya sa atun ginaimo nga malain.” ");
INSERT INTO clu_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Mintras nagaambal pa si Pedro kag si Juan sa mga tao, ginparapitan sanda ang mga pari kag mga Saduceo kag anang pangolo ang mga goardya sa timplo. ");
INSERT INTO clu_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ginaugutan sanda tungud nga nagapanodlo ang darwa nga dia nga si Jesus nabanaw, kag dia nagapamatood nga ang mga patay babanawon. ");
INSERT INTO clu_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Gani gindakup nanda si Pedro kag si Juan. Andan bistigarun nanda, garing tungud nga sirum run, ginsulud nanda sa prisoan asta maaga. ");
INSERT INTO clu_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Piro bisan toladato ang natabo kananda, doro pa ra sa mga nakabati andang panodlo ang nagtoo. Ang mga lalaki lang nga nagatoo ron mga 5,000 nga lagi. ");
INSERT INTO clu_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Pagkaaga, nagtiripon sa Jerusalem anang mga maulam-ulam ang mga Judio, ang mga manogtodlo ang Kasogoan, kag ang iba pa nga mga manogdomara ang mga Judio. ");
INSERT INTO clu_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Doto ra si Annas nga pinakamataas nga pari, si Caifas, si Juan, si Alejandro, kag ang iba pa nga mga mimbro anang pamilya ni Annas. ");
INSERT INTO clu_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Gindara kananda si Pedro kag si Juan kag ginimbistigar nanda dayon. Makon nanda, “Anong gaum indong gingamit kag kinong aran indong ginsambit sa pagayad ang tao nga piang?” ");
INSERT INTO clu_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Si Pedro nga ginagauman ang Ispirito Santo nagsabat, makon na, “Kamo nga amun mga manogdomara kag mga maulam-ulam ang banwa, ");
INSERT INTO clu_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","kon ang ginapamangkot nindo kanamun ay parti sa anang pagayad ang tao nga dia nga piang, ");
INSERT INTO clu_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","dapat nindo tanan nga maulaman ang tanan ra nga taga-Israel, nga ginayad ang tao nga dia nga nagatindug dadi digi sa onaan paagi sa anang gaum anang aran ni Jesu-Cristo nga taga-Nazaret. Tana maman indong ginlansang sa kros kag napatay. Piro ginbanaw tana ang Dios. ");
INSERT INTO clu_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Si Jesus maman ang ginatomod nga bato doto sa Kasolatan nga nagakoon: ‘Ang bato nga ginagamit sa pagpatindug ang balay ginpilak nindo nga mga panday, tungud nga indong kaisip ara polos. Piro dadi maman dato ang bato nga ginimo nga pinakapondasyon.’ ");
INSERT INTO clu_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ara run iba sa bilog nga kalibotan nga makalowas kanatun kondi si Jesus lang.” ");
INSERT INTO clu_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Natingala anang mga manogdomara ang mga Judio nga si Pedro kag si Juan ara gid ginaadluki sa pagsogid, ay naulaman nanda nga dia sanda mga ordinario nga mga tao kag ara mataas nga tinonan. Namarasmasan nanda dayon nga dia sanda anang mga kaiban ni Jesus ang ona. ");
INSERT INTO clu_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Andan gosto nanda nga magambal kontra sa milagro nga ginimo nanday Pedro, piro tungud nga ang tao mismo nga ginayad doto ra nagipus sanda run lang. ");
INSERT INTO clu_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Gani andang ginimo, ginpagoa nanda anay si Pedro kag si Juan sa andang ginatiponan kag nagsorogidanun sanda dayon. ");
INSERT INTO clu_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Makon nanda, “Ano kabay atun imoon sa mga tao nga dia? Ay bantog ron sa bilog nga Jerusalem nga nakaimo sanda matood milagro kag indi kita makakoon nga botig. ");
INSERT INTO clu_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Gani agud indi run maglapnag andang panodlo sa mga tao, paandaman ta sanda nga indi sanda run gid magsari todlo ang pagtoo kay Jesus.” ");
INSERT INTO clu_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Pagkatapos, ginpatawag nanda dayon si Pedro kag si Juan kag ginkonan nga indi sanda run gid magoman todlo ang parti kay Jesus. ");
INSERT INTO clu_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Piro makon ni Pedro kag ni Juan kananda, “Abi binagbinaga nindo kon diin digi sa darwa ang osto sa panulung ang Dios; ang kami magtoman kanindo okon sa Dios? ");
INSERT INTO clu_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Kon sa kanamun tana, indi maimo nga indi kami magsogid ang parti sa amun nakita kag nabatian.” ");
INSERT INTO clu_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Piro ginpaandaman sanda pa ra gid nga indi run gid magsari panogid, kag pagkatapos ginbolyawan sanda dayon. Miski gosto nanda nga sakitun ang darwa indi nanda ra maimo tungud nga naadlukan sanda ra sa mga tao, ay ang mga tao nagdayaw sa Dios tungud sa milagro nga naimo. ");
INSERT INTO clu_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ay anang idad ang tao nga ginayad paagi sa milagro nga dato sobra run 40 ka toig. ");
INSERT INTO clu_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pagkatapos nga nabolyawan si Pedro kag si Juan nagbalik sanda sa andang mga kaiban nga mga tomoloo, kag ginsogid nanda kananda kon ano anang koon ang mga manogdomara nga mga pari kag mga maulam-ulam ang mga Judio. ");
INSERT INTO clu_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Pagkabati dato ang mga tomoloo nagpangamoyo sanda. Makon nanda, “Ginoo nga makagagaum sa tanan, ikaw ang nagimo ang langit, ang logta, ang dagat, kag ang tanan nga mga butang sa mga logar nga dan. ");
INSERT INTO clu_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Paagi sa Ispirito Santo ginpaambal mo amun kaolang-olangan nga si David nga imong sorogoon. Makon na, ‘Basi nasisilag nga mayad ang mga bukun Judio? Kag basi ang mga Judio nagaplano ang ara polos? ");
INSERT INTO clu_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ang mga ari sa kalibotan kag ang mga manogdomara nagtiripon kag nagpriparar agud magpakigaway sa Ginoo kag sa anang Cristo.’ ");
INSERT INTO clu_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Natabo ron dadi imong ginambal nga dato ang ona tungud nga digi mismo sa Jerusalem ang mga bukun Judio kag mga Judio, pati si Herodes nga ari kag si Pilato nga gobirnador nagkarasogot nga kontraun imong Balaan nga Sorogoon nga si Jesus nga imong ginpili nga maging Ari. ");
INSERT INTO clu_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Sa andang ginimo nga dato natoman imong ginplano ron nga lagi ang ona. Kag dia natabo sono sa imong gaum kag kagostoan. ");
INSERT INTO clu_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Kag dadi, Ginoo, ginapaug nanda kami. Boligan mo kami nga imong mga sorogoon nga iwali nga may kaisug imong minsai. ");
INSERT INTO clu_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ipakita mo imong gaum. Itogot mo nga paagi sa anang aran ni Jesus nga imong ginpili nga Sorogoon makapangayad kami ang mga masakitun kag makaimo mga milagro kag mga katiringala nga mga butang.” ");
INSERT INTO clu_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Pagkatapos nanda pangamoyo, nagkudug ang balay nga andang ginatiriponan. Sanda nga tanan gingauman ang Ispirito Santo kag nagisug sanda sa pagwali anang minsai ang Dios. ");
INSERT INTO clu_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Nagtorono nga mayad ang mga nagatoo kay Jesus, kag parario andang ginaisip kag baratyagun. Ang kada isara kananda ara nagkabig nga anang mga pagkabutang ana lang gid, kondi ginbilang nanda nga para sa tanan. ");
INSERT INTO clu_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Sigi anang imo ang mga apostolis ang mga katiringalaan sa pagpamatood nga si Ginoong Jesus nabanaw manda. Kag mabaul ra anang bolig ang Dios sa tanan nga mga tomoloo. ");
INSERT INTO clu_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ara gid may nalisudan kananda sa andang mga kinanglan tungud nga may mga tomoloo nga may mga logta kag mga balay nga andang ginpamaligya, ");
INSERT INTO clu_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","kag gintaw nanda dayon anang bayad sa mga apostolis. Kag ginpanagtag ra dayon ang mga apostolis sa mga tomoloo nga nalilisudan. ");
INSERT INTO clu_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Toladato ra anang ginimo ni Jose nga taga-Cipre. Judio tana nga alin sa lai ni Levi. Anang panawag kanana ang mga apostolis si Barnabas, nga anang gostong ambalun “Manogpabaskug”. ");
INSERT INTO clu_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ginbaligya ni Jose anang logta kag gintaw na dayon anang bayad sa mga apostolis. ");
INSERT INTO clu_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Piro may tao doto nga anang aran si Ananias. Anang asawa si Safira. May ginbaligya sanda ra nga logta. ");
INSERT INTO clu_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Piro bago daraun ni Ananias anang bayad ang logta sa mga apostolis, gintago na ang iba nga kantidad para sa andang kaogalingun. Anang asawa nagkompormi ra. Pagtaw na sa mga apostolis nagkoon tana nga maman run dato anang bayad andang logta. ");
INSERT INTO clu_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Makon ni Pedro, “Ananias, basi nagpadaug kaw kay Satanas? Nagabotig kaw sa Ispirito Santo tungud nga ang iba nga koarta nga bayad imong logta gintago mo! ");
INSERT INTO clu_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Kabay bago mo ibaligya imong logta imo ra lagi dato. Kag pagkabaligya mo imo pa ra gid ang koarta nga naging bayad. Ta basi naisip mo pa nga imoon dia? Ara kaw magbotig sa tao kondi sa Dios.” ");
INSERT INTO clu_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","6","Pagkabati dato ni Ananias, natomba tana kag napatay. Kag ginrapitan tana dayon ang mga soltiro kag ginpotos nanda anang bangkay. Pagkatapos gindara nanda sa goa kag ginlubung. Kag ang tanan nga nakabati sa natabo ginpangadlukan nga mayad. ");
INSERT INTO clu_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Pagkalubas mga tatlo ka oras, nagsulud anang asawa ni Ananias. Ara tana kaulam kon ano ang natabo sa anang asawa. ");
INSERT INTO clu_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ginpamangkot tana ni Pedro, makon na, “Abi sogidi ako ang matood, maman gid bala dia tanan ang kantidad nga indong nabaton sa indong ginbaligya nga logta?” Makon ni Safira, “Uu, maman dan tanan amun nabaton.” ");
INSERT INTO clu_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Makon ruman ni Pedro kanana, “Basi nagkasogot kamo nga magasawa nga tirawan anang Ispirito ang Ginoo? Sulunga, dian run sa poirtaan ang mga soltiro nga naglubung imong asawa, kag ikaw kakantoangan nanda ra kag ilubung.” ");
INSERT INTO clu_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Dato ra nga lagi natomba si Safira sa anang atobangan ni Pedro kag napatay. Pagsulud ang mga soltiro nakita nanda nga patay run si Safira. Gani ginkantoangan nanda pa goa kag ginlubung sa tupad anang asawa. ");
INSERT INTO clu_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Tungud sa mga natabo nga dato, ginpangadlukan nga mayad ang tanan nga mga tomoloo kag ang tanan nga nakabarita sa natabo. ");
INSERT INTO clu_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Dorong mga milagro kag mga katiringalaan anang ginimo ang mga apostolis sa mga tao. Pirmi nga nagatiripon ang tanan nga mga tomoloo doto sa Balkon ni Solomon. ");
INSERT INTO clu_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ginataod sanda ang mga bukun tomoloo, bisan ara sanda magpangas dapun kananda. ");
INSERT INTO clu_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Piro nagdogang pa ra gid ang mga tomoloo tungud nga doro pa gid ang nagtoo sa Ginoo, mga lalaki kag mga babai. ");
INSERT INTO clu_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Tungud sa mga milagro nga anang ginpangimo ang mga apostolis, ginpandara ang mga tao andang mga masakitun sa binit ang mga dalan kag ginbutang nanda sa mga iringgaan, agud nga kon magagi si Pedro maagian sanda bisan anang anino ron lang. ");
INSERT INTO clu_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Bukun lang dan, kondi doro ra nga mga tao sa mga bario sa palibot ang nagabot sa Jerusalem nga dara andang mga masakitun kag ang mga tao nga may malain nga ispirito. Kag tanan sanda nagarayad. ");
INSERT INTO clu_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Nainggit nga mayad ang pinakamataas nga pari kag anang mga kaiban nga mga mimbro ang sikta nga Saduceo. ");
INSERT INTO clu_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Gani ginpangdakup nanda ang mga apostolis kag ginsulud sa prisoan. ");
INSERT INTO clu_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Piro pagkagabi, ginbokasan anang angil ang Ginoo anang poirtaan ang prisoan kag ginpagoa na sanda dayon. Makon ang angil kananda, ");
INSERT INTO clu_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Pagayan kamo doto sa timplo kag todloan nindo ang mga tao parti sa bago nga kaboi nga ginataw ang Dios.” ");
INSERT INTO clu_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Gintoman nanda anang koon ang angil, gani pagmora ang adlaw nagsulud sanda sa timplo kag nagtodlo sa mga tao. Karon, ginpatawag ang pinakamataas nga pari kag anang mga kaiban ang tanan nga mga maulam-ulam ang mga Judio agud magmiting ang bilog nga konsilyo. Kag may ginsogo sanda ra nga magayan sa prisoan agud bulun ang mga apostolis kag daraun doto kananda. ");
INSERT INTO clu_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Piro pagabot ang mga polis doto sa prisoan, ara run doto ang mga apostolis. Gani dayon sandang balik doto sa konsilyo. ");
INSERT INTO clu_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Makon nanda, “Pagabot namun doto sa prisoan nakita namun nga may mga kandado pa ang mga poirtaan, kag ang mga goardya doto ra sa may mga poirtaan nagabantay. Piro pagbokas namun ang prisoan ara kami may nakita nga tao doto.” ");
INSERT INTO clu_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Pagkabati dato anang kapitan ang mga goardya ang timplo kag ang mga manogdomara nga mga pari, naglibug andang olo kag indi nanda maabot isip kon ano ang natabo sa mga apostolis. ");
INSERT INTO clu_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Lagat-lagat may sangka tao nga nagabot kag nagsogid, makon na, “Ang mga tao nga indong ginsulud sa prisoan doto sa timplo, kag nagatodlo sanda sa mga tao.” ");
INSERT INTO clu_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Gani nagayan dayon doto sa timplo anang kapitan ang mga goardya kag anang mga sinakupan kag ginbuul nanda ang mga apostolis, piro ara nanda pagpoirsaa tungud nga naadlukan sanda basi kon pasilun sanda ang mga tao. ");
INSERT INTO clu_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Gindara nanda dayon ang mga apostolis doto sa konsilyo. Makon ang pinakamataas nga pari kananda, ");
INSERT INTO clu_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Kabay ginbawalan namun kamo ron nga indi kamo magsari todlo parti kay Jesus. Piro sulunga nindo indong ginimo! Naglapnag run indong mga panodlo sa bilog nga Jerusalem, kag kami pa indong ginabangdanan nga nagpatay kanana!” ");
INSERT INTO clu_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Si Pedro kag anang mga kaiban nagsabat, makon nanda, “Kinanglan ang Dios maman amun dapat tomanun, bukun ang tao. ");
INSERT INTO clu_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ginpatay nindo si Jesus paagi sa pagpalansang kanana sa kros. Piro ginbanaw tana ang Dios, ang Dios nga ginsimba atun mga kaolang-olangan. ");
INSERT INTO clu_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ginpataas ang Dios anang kaimtangan ni Jesus kag doto tana run sa anang too bilang Manogdomara kag Manlolowas, agud kita nga mga Judio matawan kaigayonan nga maginulsul para mapatawad atun mga sala. ");
INSERT INTO clu_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Kami nagapamatood nga dia tanan matood. Kag ang Ispirito Santo nga anang ginataw ang Dios sa tanan nga nagatoman kanana nagapamatood ra sa mga butang nga dia.” ");
INSERT INTO clu_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Pagkabati dato anang mga mimbro ang konsilyo nasilag sanda nga mayad kag gosto nanda nga ipapatay ang mga apostolis. ");
INSERT INTO clu_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Piro nagtindug andang kaiban nga si Gamaliel. Ang tao nga dia Pariseo kag manogtodlo ang Kasogoan. Ginataod tana ang tanan. Nagsogo tana nga pagoaun anay ang mga apostolis. ");
INSERT INTO clu_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Pagkatapos nga nakagoa ang mga apostolis nagambal si Gamaliel sa anang mga kaiban, makon na, “Mga kasimanwa ko nga mga taga-Israel, isipun ta gid anay kon ano atun imoon sa mga tao nga dia ay basi kon makasala kita. ");
INSERT INTO clu_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Tungud nga kano lang may tao nga anang aran si Teudas nga nagapaadak kon sino tana gid. Kag may mga 400 ka tao ang nagsonod kanana. Piro ang ori ginpatay tana kag anang mga kaiban nagburulag dayon, kag nadora ra lang dato. ");
INSERT INTO clu_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Pagkatapos dato, ang pagsinsos ang mga tao, si Judas ruman nga taga-Galilea ang nakatipon mga tao nga nagsonod kanana. Piro ginpatay tana ra kag nagburulag ra anang mga sinakupan. ");
INSERT INTO clu_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Gani akun maambal kanindo maman dia: pabayanan ta lang ang mga tao nga dia, kag indi ta sanda pagpasilabutan. Tungud nga kon andang mga ginaimo kag ginatodlo alin ra lang sa tao, madodora ra lang dan. ");
INSERT INTO clu_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Piro kon dia alin sa Dios indi ta sanda mapugungan. Kag bukun lang dan, kondi basi kon maggoa pa nga ang Dios maman atun kakontra.” Gani ginsonod ang konsilyo anang laygay ni Gamaliel. ");
INSERT INTO clu_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ginpatawag nanda ruman ang mga apostolis kag ginpaanot. Pagkatapos ginpaandaman nanda nga indi sanda run gid magtodlo parti kay Jesus, kag ginbolyawan sanda dayon. ");
INSERT INTO clu_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Nagalin doto ang mga apostolis nga nalilipay nga mayad, tungud nga gintawan sanda ang Dios pribilio nga magantos para sa anang aran ni Cristo. ");
INSERT INTO clu_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Kag kada adlaw nagaayan sanda sa timplo kag sa mga balay kag sigi andang panodlo kag wali ang Mayad nga Barita parti kay Jesus nga tana ang Cristo. ");
INSERT INTO clu_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Sa mga tyimpo nga dato, nagadoro ron gid ang mga nagatoo kay Jesus. Karon, nagriklamo ang mga Judio nga alin sa Grecia kontra sa mga Judio nga alin sa Judea tungud nga napabayanan lang andang mga balo nga babai kag ara ginatawi rasyon nga pangadlaw-adlaw. ");
INSERT INTO clu_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Gani ginpatawag ang dosi ka apostolis ang tanan nga mga tomoloo. Makon nanda dayon, “Bukun mayad nga pabayanan namun ang pagwali anang ambal ang Dios para lang maasikaso ang parti sa mga aboloy. ");
INSERT INTO clu_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ang mayad sigoro, mga kabogto, magpili kamo sa indong mga kaiban pito ka lalaki nga kilala nga mga mayad nga tao, maaram, kag andang kaboi ginagauman ang Ispirito Santo. Sanda maman atun padomaraun sa mga aboloy nga dia. ");
INSERT INTO clu_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Kag kami tana, gamitun namun amun tyimpo sa pagpangamoyo kag sa pagwali anang ambal ang Dios.” ");
INSERT INTO clu_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Kompormi ang tanan nga mga tomoloo sa sowistyon nga dato. Gani nagpili sanda dayon. Isara sa andang napili si Esteban. Dia nga tao ugut anang pagtoo kay Jesus kag anang kaboi ginagauman ang Ispirito Santo. Napili nanda ra si Felipe, si Procoro, si Nicanor, si Timon, si Parmenas, kag si Nicolas nga taga-Antioquia. Si Nicolas nga dia bukun Judio, piro nagsaylo tana sa anang riliyon ang mga Judio. ");
INSERT INTO clu_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ang mga napili nga dia gindara nanda sa mga apostolis. Kag ang mga apostolis nagpangamoyo para kananda, kag gintongtongan nanda andang mga alima bilang pagtaw awtoridad kananda. ");
INSERT INTO clu_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Gani padayon nga naglapnag anang ambal ang Dios. Doro pa gid nga mga taga-Jerusalem kag doro ra nga mga pari ang nagtoo kay Jesus. ");
INSERT INTO clu_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ginkaloyan nga mayad ang Dios si Esteban kag gintawan gaum. Gani dorong mga milagro kag mga katingalaan anang ginpangimo nga nakita ang mga tao. ");
INSERT INTO clu_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Piro may mga tao nga nagkontra kay Esteban. Dia nga mga tao mga Judio nga alin sa Cirene, sa Alejandria, sa Cilicia kag sa Asia. Mga mimbro dia anang simbaan ang mga Judio nga kon tawagun Simbaan ang mga Ginlibri sa Pagkaoripun. Sigi andang pakigdiskosyon kay Esteban. ");
INSERT INTO clu_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Piro tungud nga si Esteban gintawan kaaram ang Ispirito Santo, indi sanda gid kadaug kanana. ");
INSERT INTO clu_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Gani andang ginimo, nagsool sanda pira ka tao nga magkoon nga nabatian nanda si Esteban nga nagaambal marimo kontra kay Moises kag sa Dios. ");
INSERT INTO clu_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Sa toladato nga paagi nasolsolan nanda ang mga tao, ang mga maulam-ulam ang mga Judio, kag ang mga manogtodlo ang Kasogoan. Gindakup nanda si Esteban kag gindara dayon sa konsilyo. ");
INSERT INTO clu_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","May ginpasulud sanda ra nga pira ka tao nga magatistigo ang botig kontra kay Esteban. Makon ang mga tistigo, “Dia nga tao pirmi gid nga nagaambal kontra sa atun sagrado nga timplo kag sa Kasogoan ni Moises. ");
INSERT INTO clu_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Nabatian namun tana nga nagakoon nga atun timplo ranggaun ni Jesus nga taga-Nazaret kag ilisan na tanan ang mga kaogalian nga gintaw kanatun ni Moises!” ");
INSERT INTO clu_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ang tanan nga mimbro ang konsilyo nagsulung nga mayad kay Esteban, kag nakita nanda anang oyaun nga midyo anang oyaun ang angil. ");
INSERT INTO clu_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Karon, nagpamangkot ang pinakamataas nga pari kay Esteban, makon na, “Ano, matood anang ginasogid ang mga tao nga dia?” ");
INSERT INTO clu_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Makon ni Esteban, “Mga kabogto kag mga ginikanan, pamatii nindo ako. Ang ona nga mga tyimpo ang Dios nga makagagaum nagpakita sa atun kaolang-olangan nga si Abraham ang doto tana pa nagaoli sa Mesopotamia bago tana magsaylo sa Haran. ");
INSERT INTO clu_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Makon ang Dios kay Abraham, ‘Magalin kaw sa imong banwa nga dia, bayaan mo imong mga parinti kag magayan kaw sa logar nga akun itodlo kanimo.’ ");
INSERT INTO clu_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Gani nagalin si Abraham sa banwa nga dato ang Caldea kag doto tana nagoli sa Haran. Pagkapatay anang tatay ginpaayan tana ruman ang Dios sa logar nga dia nga atun ginaolian dadi. ");
INSERT INTO clu_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Sa mga tyimpo nga dato si Abraham ara pa pagtawi ang Dios bisan maistan lang nga logta. Piro nagpangako ang Dios nga ang logar nga dia itaw na kanana kag sa anang mga kaliwat, bisan sa oras nga dato ara pa gid bata si Abraham. ");
INSERT INTO clu_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Makon pa ang Dios kanana, ‘Imong mga kaapo-apoan sa ori magaoli sa ibang banwa, kag doto imoon sanda nga mga oripun kag pintasan sanda ang mga taga-doto sa sulud 400 ka toig. ");
INSERT INTO clu_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Piro sisilotan ko ang nasyon nga magaoripun kananda. Pagkatapos magaalin sanda sa banwa nga dato kag magabalik sa logar nga dia kag digi sanda magasimba kanakun.’ ");
INSERT INTO clu_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Kag bilang tanda sa anang pangako nagsogo ang Dios kay Abraham nga ang tanan nga mga lalaki dapat toriun. Gani pagkabata anang bata nga si Isaac, gintori na datong walo tana run ka adlaw nga nabata. Maman da anang ginimo ni Isaac kay Jacob nga anang bata. Kag si Jacob maman da anang ginimo sa anang dosi ka mga bata nga maman atun ginalinan nga mga Judio. ");
INSERT INTO clu_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Si Jose nga isara sa dosi nga dato gininggitan anang mga kabogto, gani ginbaligya nanda tana. Gindara tana dayon sa Egipto kag naging oripun doto. Piro tungud nga ang Dios kaiban ni Jose, ");
INSERT INTO clu_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ginboligan na tana sa tanan nga mga kalisud nga anang ginaagian. Gintawan tana ra ang Dios kaaram, gani nagostoan tana ang Faraon, anang ari ang Egipto. Ginimo tana ang ari nga manogdomara sa bilog nga Egipto kag sa tanan na nga pagkabutang. ");
INSERT INTO clu_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ang ori nagabot ang tiggurutum sa bilog nga Egipto kag sa Canaan. Naglisud nga mayad ang mga tao, kag atun mga kaolang-olangan ara gid mabulan pagkaun. ");
INSERT INTO clu_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Gani pagkabati ni Jacob nga may pagkaun doto sa Egipto, ginpaayan na doto anang mga bata nga atun mga kaolang-olangan. Maman dato andang ona nga pagayan doto sa Egipto. ");
INSERT INTO clu_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Datong ikarwa nanda nga pagayan doto, nagpakilala kananda si Jose nga tana andang kabogto, kag ginsogid na ra kay Faraon ang parti sa anang pamilya. ");
INSERT INTO clu_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Nagbilin dayon si Jose nga anang tatay nga si Jacob magayan doto sa Egipto kag daraun na anang bilog nga pamilya. (Mga 75 sanda tanan.) ");
INSERT INTO clu_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Gani si Jacob kag atun mga kaolang-olangan nagayan doto sa Egipto, kag doto sanda nagoli asta sanda nagkarapatay. ");
INSERT INTO clu_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Andang mga bangkay gindara sa Siquem kag doto ginlubung sa rulubungan nga ginbakal ni Abraham ang ona sa anang mga bata ni Amor. ");
INSERT INTO clu_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Karon, datong marapit run matoman anang ginpangako ang Dios kay Abraham, nagraku run gid atun mga kaolang-olangan doto sa Egipto. ");
INSERT INTO clu_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Nagabot ra ang adlaw nga iba run nga ari ang nagdomara sa Egipto. Tana ara kaulam parti kay Jose. ");
INSERT INTO clu_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ginloko ang ari nga dato atun mga kaolang-olangan kag ginpintasan. Ginpirit na sanda nga ipamilak andang mga lapsag agud makarapatay. ");
INSERT INTO clu_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Maman dato ang tyimpo nga nabata si Moises. Si Moises nga dia masadya nga bata kag nagostoan ang Dios. Ginsagod tana anang mga ginikanan sa andang balay sa sulud tatlo ka bolan. ");
INSERT INTO clu_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ang tana ginpapilak run, ginbuul tana anang bata nga babai ni Faraon kag ginsagod nga midyo anang bata gid. ");
INSERT INTO clu_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Gintodloan si Moises ang tanan nga kinaaram sa Egipto, kag naging bantog tana sa anang mga inambalan kag sa anang mga inimoan. ");
INSERT INTO clu_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Ang 40 run ka toig anang idad ni Moises naisipan na nga magbisita sa anang mga kapario nga mga Israelita. ");
INSERT INTO clu_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Kag doto nakita na ang isara kananda nga ginapintasan ang Egiptoanun. Gintabangan na anang kapario nga Israelita kag bilang balus ginpatay na ang Egiptoanun. ");
INSERT INTO clu_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Tungud sa anang ginimo nga dato anang kaisip ni Moises masasatuman ang mga Israelita nga tana maman anang gamitun ang Dios agud malibri sanda sa pagantos nga andang ginaagian. Garing ara sanda gali kasatum. ");
INSERT INTO clu_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ang madason nga adlaw nagbalik si Moises kag nakita na ang darwa ka Israelita nga nagaaway. Gosto na andan nga osayun ang darwa, gani makon na kananda, ‘Pario kamo kabay nga Israelita. Ta basi nagaaway kamo?’ ");
INSERT INTO clu_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Piro ginkaig tana ang tao nga nagapandaugdaug nga nagakoon, makon na, ‘Sino ang nagimo kanimo nga manogdomara kag manogosay kanamun? ");
INSERT INTO clu_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ano, patayun mo ako ra pario imong pagpatay sa Egiptoanun nga dato kaapon?’ ");
INSERT INTO clu_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Pagkabati dato ni Moises nagpalagyaw tana sa Egipto kag nagayan sa Median, kag doto nagoli. Doto tana nakapangasawa kag doto ra nabata anang darwa ka bata nga lalaki. ");
INSERT INTO clu_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Pagkalubas 40 ka toig may sangka angil nga nagpakita kay Moises ang doto tana sa logar nga ara ginaolii ang tao nga marapit sa Bokid ang Sinai. Nakita ni Moises ang angil sa palongpong nga nagadabadaba. ");
INSERT INTO clu_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Natingala nga mayad si Moises sa anang nakita, gani ginparapitan na ang palongpong nga dato agud sulungun kon ano. Ang tana nagaparapit run nabatian na anang limug ang Ginoo nga nagambal kanana, makon na, ");
INSERT INTO clu_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Ako ang Dios nga ginsimba imong mga kaolang-olangan nga si Abraham, si Isaac, kag si Jacob.’ Pagkabati dato ni Moises nagkudug tana sa kaadluk kag ginadlukan tana run nga magsulung. ");
INSERT INTO clu_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Makon dayon ang Dios kanana, ‘Obaa imong sandalyas ay sagrado ang logar nga dia nga imong ginatindugan. ");
INSERT INTO clu_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nakita ko gid ang mga kalisud nga ginaantos akun mga pinili nga mga tao doto sa Egipto, kag nabatian ko ra andang mga pagpanangis. Gani naglosong ako agud ilibri sanda. Dadi pagpriparar run ay ikaw maman akun ipadara doto sa Egipto.’ ");
INSERT INTO clu_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Maman dia ang Moises nga ginsikway anay anang mga kapario nga Israelita nga nagkoon, ‘Sino ang nagimo kanimo nga manogdomara kag manogosay kanamun?’ Maman da dia mismo ang Moises nga ginpadara ang Dios nga maging manogdomara kag manoglibri sa mga Israelita paagi sa bolig ang angil nga anang nakita doto sa nagadabadaba nga palongpong. ");
INSERT INTO clu_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Si Moises ang nagdara ang mga Israelita paggoa sa Egipto. Nagimo tana mga milagro kag mga katiringalaan sa Egipto kag sa Dagat nga Mapola kag pati sa logar nga ara ginaolii ang tao nga andang ginpanawan sa sulud 40 ka toig. ");
INSERT INTO clu_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Maman da dia nga Moises ang nagkoon sa mga Israelita nga kon paiwan nga tana ginpadara ang Dios kananda, magapadara pa gid ang Dios sangka propita nga alin ra kananda. ");
INSERT INTO clu_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Kag ang doto ron atun mga kaolang-olangan sa logar nga ara ginaolii ang tao, tana ra ang nagpatunga sa mga tao kag sa angil nga nagpakigambal kanana sa Bokid ang Sinai, kag doto tana nagbaton anang ambal ang Dios nga nagataw kaboi agud itaw na kanatun. ");
INSERT INTO clu_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Garing bago makabalik si Moises alin sa bokid, atun mga kaolang-olangan ara nagtoman sa anang ginapaimo ni Moises kananda. Ginsikway nanda si Moises bilang andang manogdomara, kag gosto nanda nga mabalik sa Egipto. ");
INSERT INTO clu_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Makon nanda sa anang gorang ni Moises nga si Aaron, ‘Imoi kami mga ribolto agud may mga dios kami nga sonodon, tungud nga ara kami kaulam kon ano ron ang natabo kay Moises nga dato nga nagpagoa kanamun sa Egipto.’ ");
INSERT INTO clu_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Kag nagimo sanda dayon ribolto nga anang itsora pario sa tinday nga baka. Nagalad sanda sa ribolto nga dato kag nagpista sanda ra agud padungugan andang ginimo nga dios-dios. ");
INSERT INTO clu_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Piro tungud sa andang ginimo nga dato, gintalikodan sanda ang Dios, kag ginpabayanan na sanda run lang nga magsimba sa mga bitoon sa langit. Toladato gid ang nakabutang sa mga ginsolat ang mga propita. Makon doto ang Dios, ‘Kamo nga mga Israelita, sa sulud 40 ka toig nga kamo doto sa logar nga ara ginaolii ang tao nagpatay kamo mga ayup kag indong ginalad. Piro bukun ako indong ginaladan ang mga sapat nga dato. ");
INSERT INTO clu_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Gindara-dara nindo pa anang torda indong dios-dios nga si Moloc, kag anang borobitoon indong dios-dios nga si Refan. Ang mga ribolto nga dato ginpangimo nindo agud simbaun. Maman dia nga palayasun ko kamo asta doto sa loyo pa ang Babilonia.’” ");
INSERT INTO clu_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Makon pa ni Esteban sa konsilyo, “Ang doto sanda pa sa logar nga ara ginaolii ang tao, atun mga kaolang-olangan may torda nga doto anang prisinsya ang Dios. Ang torda nga dato ginimo sono sa anang sogo ang Dios kay Moises, sono sa plano nga ginpakita kanana. ");
INSERT INTO clu_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ang ori, pagkapatay atun mga kaolang-olangan, andang mga bata maman ruman ang nagdara ang torda nga dato. Andang manogdomara dato si Josue run. Naangkun nanda ang mga logar nga ginpangako ang Dios pagkatapos nga palayasun ang Dios ang mga nagaoroli doto sa mga logar nga dato. Kag ang torda nga gindara ang mga Israelita doto asta run sa tyimpo nga si David naging ari. ");
INSERT INTO clu_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Ginpangayo ni David sa Dios nga togotan tana nga magpatindug balay para kanana agud makasimba doto anang mga kaapo-apoan ni Jacob. Piro bisan nalipay nga mayad ang Dios kay David, ara na tana pagtogoti. ");
INSERT INTO clu_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Si Solomon maman ang nagimo ang balay nga sirimbaan sa Dios. ");
INSERT INTO clu_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Garing ang Dios nga labaw sa tanan ara nagaistar sa mga balay nga ginimo lang ang tao. Ay sono sa propita ang ona pa, makon ang Dios, ");
INSERT INTO clu_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Ang langit akun trono, kag ang logta anang torongtongan akun siki. Gani anong klasi nga balay indong imoon para kanakun? Ta diin ang logar nga akun mapawayan? ");
INSERT INTO clu_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Indi bala nga ako maman ang nagimo ang tanan nga butang!’” ");
INSERT INTO clu_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Pagkatapos makon ni Esteban sa mga tao doto sa konsilyo, “Maturugas indong mga olo! Nagapabungul kamo sa anang minsai ang Dios ay indi nindo gosto nga magtoman sa anang mga ginakoon kanindo. Pirmi nindo nga ginakontra ang Ispirito Santo. Pario kamo gid sa indong mga kaolang-olangan. ");
INSERT INTO clu_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ara gid propita sa andang tyimpo nga ara nanda pagingabota. Pati ang mga nagsogid parti sa pagabot ang Matarung nga Sorogoon nga si Jesus ginpatay nanda ra. Kag pagabot digi ni Jesus, kamo roman ang nagtraidor kag nagpatay kanana. ");
INSERT INTO clu_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Nagbaton kamo ang kasogoan nga gintaw ang Dios paagi sa mga angil, piro ara nindo pagtomana.” ");
INSERT INTO clu_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Pagkabati dato anang mga mimbro ang konsilyo, nasilag sanda nga mayad kay Esteban. Nagpapagut sanda andang mga ipun sa kasilag. ");
INSERT INTO clu_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Piro si Esteban nga gingauman ang Ispirito Santo nagtangra sa langit kag nakita na anang gaum ang Dios nga nagalanyag kag si Jesus nga nagatindug sa too ang Dios. ");
INSERT INTO clu_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Pagkakita na dato, makon na, “Sulunga nindo! Nakikita ko nga abri ang langit kag doto si Jesus nga Naging Tao nga nagatindug sa anang too ang Dios!” ");
INSERT INTO clu_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Nagsiringgit anang mga mimbro ang konsilyo kag gintakupan nanda andang mga talinga agud indi nanda mabatian anang ginaambal ni Esteban. Kag nagdaragoyon sanda dayon paayan kanana. ");
INSERT INTO clu_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Gindara nanda si Esteban sa goa ang siodad kag ginboroligan nanda pasil ang bato. Ginoba ang mga nagtistigo kontra kay Esteban andang mga panguslub nga lambong kag ginsala sa tao nga bataun pa nga anang aran si Saulo. ");
INSERT INTO clu_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Kag mintras ginaboroligan nanda pasil si Esteban, nagapangamoyo tana sa Ginoo, makon na, “Ginoong Jesus, batona akun ispirito.” ");
INSERT INTO clu_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Kag naglood tana dayon kag nagsinggit ang mabaskug, makon na, “Ginoo, indi mo sanda pagpapanabatun sa sala nga dia nga andang ginaimo.” Pagkaambal na dia, napatay tana. ");
INSERT INTO clu_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Ginlubung si Esteban ang mga diosnon nga mga tao, kag gintangisan nanda tana nga mayad. Alin dato, nagompisa ang poirti nga pagingabot sa mga tomoloo sa Jerusalem. Gani nagrarapta ang mga tomoloo sa bilog nga probinsya ang Judea kag Samaria. Ang mga apostolis lang ang ara nagaralin sa Jerusalem. Si Saulo nga nagkompormi sa pagpatay kay Esteban ");
INSERT INTO clu_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","nagimorat gid nga madora ang mga tomoloo kay Cristo. Gani ginpamalaybalay na sanda kag ginpandara sa prisoan, bukun lang ang mga lalaki, kondi pati ang mga babai. ");
INSERT INTO clu_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Pagrapta ang mga tomoloo, ginwali nanda ang Mayad nga Barita bisan diin sanda magayan. ");
INSERT INTO clu_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Isara sa mga tomoloo nga dato si Felipe. Nagayan tana sa sangka siodad ang Samaria kag nagwali tana doto sa mga tao ang parti kay Cristo. ");
INSERT INTO clu_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Pagkabati ang mga tao sa anang mga ginambal ni Felipe kag pagkakita nanda sa mga milagro nga anang ginapangimo, nagpamati sanda nga mayad. ");
INSERT INTO clu_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Dorong mga tao nga may mga malain nga ispirito anang ginpangayad. Nagsinggit todo ang mga malain nga ispirito mintras nagagoa sanda sa mga tao. Doro ra nga mga paralitiko kag mga piang ang nagarayad. ");
INSERT INTO clu_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Gani doro anang kalipay ang mga tao doto sa siodad nga dato. ");
INSERT INTO clu_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","May tao ra doto nga anang aran si Simon. Maboay run nga natitingala nga mayad kanana ang mga taga-Samaria tungud sa anang abilidad sa madyik. Nagapaadak tana pa kon sino tana gid. ");
INSERT INTO clu_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ang tanan nga tao doto sa siodad, pobri kag manggaranun, nagapamati nga mayad kanana. Makon nanda, “Ang tao nga dia maman run anang gaum ang Dios nga kon tawagun, ‘Mabaskug nga Gaum.’” ");
INSERT INTO clu_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Maboay na run nga nadara ang mga tao sa anang abilidad, maman dato nga nagpati ang mga tao kanana. ");
INSERT INTO clu_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Piro pagwali ni Felipe kananda parti sa Mayad nga Barita anang Ginarian ang Dios kag parti kay Jesu-Cristo, nagtoo sanda kag nagparabunyag dayon, lalaki kag babai. ");
INSERT INTO clu_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Pati si Simon nga dato nagtoo ra kag pagkatapos nga tana nabunyagan nagtawas tana dayon kay Felipe. Natingala tana nga mayad sa mga katiringalaan kag mga milagro nga ginimo ni Felipe. ");
INSERT INTO clu_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Pagkabati ang mga apostolis sa Jerusalem nga ang mga taga-Samaria nagtoo ron sa anang ambal ang Dios, ginpadara nanda doto si Pedro kag si Juan. ");
INSERT INTO clu_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Pagabot nanda sa Samaria nagpangamoyo sanda para sa mga tomoloo doto nga mabaton nanda ang Ispirito Santo. ");
INSERT INTO clu_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Tungud nga bisan matood nga sanda nabunyagan run sa anang aran ni Ginoong Jesus, ara sanda pa gid nakabaton ang Ispirito Santo. ");
INSERT INTO clu_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Gintongtongan sanda ni Pedro kag ni Juan andang mga alima, kag nabaton nanda dayon ang Ispirito Santo. ");
INSERT INTO clu_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Nakita ni Simon nga pagtongtong ang mga apostolis andang alima sa mga tomoloo nabaton nanda ang Ispirito Santo. Gani ginpadoydoyan na koarta si Pedro kag si Juan kag magkoon, ");
INSERT INTO clu_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Tawi nindo ako ra ang gaum nga dan, agud ang bisan sino nga akun tongtongan akun alima magabaton da ang Ispirito Santo.” ");
INSERT INTO clu_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Makon ni Pedro kanana, “Kabay pa nga madora kaw kag imong koarta! Ay imong pagsarig mababakal mo anang rigalo ang Dios? ");
INSERT INTO clu_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ara kaw labut kag ara kaw parti sa anang ginapaimo kanamun ang Dios tungud nga imong tagiposoon bukun osto sa anang panulung. ");
INSERT INTO clu_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Gani inulsuli imong katoyoan nga malain kag magpangamoyo kaw sa Ginoo nga patawadun kaw sa imong ginaisip nga marimo. ");
INSERT INTO clu_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Tungud nga nakikita ko nga nainggit kaw nga mayad kag ginagapos kaw imong mga sala.” ");
INSERT INTO clu_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Makon ni Simon kay Pedro kag kay Juan, “Kon maimo ipangamoyo nindo ako ra sa Ginoo agud indi matabo kanakun ang silot nga indong ginakoon.” ");
INSERT INTO clu_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pagkatapos nga sanda makapamatood kag makawali anang minsai ang Ginoo, nagbalik sanda sa Jerusalem. Kag ginwali nanda ra ang Mayad nga Barita sa mga bario sa probinsya ang Samaria nga andang naagian paoli. ");
INSERT INTO clu_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Karon, may angil ang Ginoo nga nagambal kay Felipe, makon na, “Magayan kaw dadi nga lagi sa abagatnan kampi, kag osoyon mo ang dalan nga alin sa Jerusalem paayan sa Gaza.” (Dia nga dalan talagsa run lang nga ginaagian.) ");
INSERT INTO clu_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Gani pomanaw si Felipe kag mintras nagapanaw tana nakita na ang tao nga taga-Etiopia nga nagayan sa Jerusalem agud magsimba sa Dios. Dato nga tao mataas anang katungdanan tungud nga tana ang ginatogyanan anang manggad ang Candace. (Ang Candace nga dia Rayna ang Etiopia.) ");
INSERT INTO clu_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ang tao nga dato nagaoli run nga nagasakay sa anang karo. Nagabasa tana anang libro ni Isaias nga propita. ");
INSERT INTO clu_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Makon ang Ispirito Santo kay Felipe, “Ayani doto kag magpadungan sa karo.” ");
INSERT INTO clu_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Gani nagdalagan si Felipe kag naabot na ang karo, kag nabatian na nga nagabasa ang opisyal anang libro ni Isaias nga propita. Ginpamangkot tana ni Felipe kon naintindian na anang ginabasa. ");
INSERT INTO clu_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Makon ang opisyal, “Indi gani. Ay paiwan akun pagkaintindi kon ara may magpasanag kanakun?” Kag ginkonan na dayon si Felipe nga magsakay sa anang karo kag magtupad kanana. ");
INSERT INTO clu_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Kag maman dia ang parti sa Kasolatan nga anang ginabasa: “Ara tana gid nagriklamo, Pario tana sa karniro nga ginadara sa iriyawan agud patayun, Okon sa karniro nga mintras ginabologan anang bolbol ara gid nagalimug-limug. ");
INSERT INTO clu_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ginpakauyan tana kag ang pagsintinsya kanana bukun tama, Ara may makasogid parti sa anang mga irinsia tungud nga anang pagpangaboi digi sa logta ginpatagud lang gid.” ");
INSERT INTO clu_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Makon ang opisyal kay Felipe, “Abi sogidi ako kon sino anang ginatomod digi ang propitaanang kaogalingun okon ibang tao?” ");
INSERT INTO clu_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Gani ompisa sa parti nga dato ang Kasolatan, ginsaysay kanana ni Felipe ang Mayad nga Barita parti kay Jesus. ");
INSERT INTO clu_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Mintras sigi andang paayan sa logar ang taga-Etiopia nakaabot sanda sa logar nga may tobig. Makon ang opisyal kay Felipe, “Way may tobig digi. Ano kabay, may kabangdanan pa nga indi ako mabunyagan?” ");
INSERT INTO clu_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Makon ni Felipe kanana, “Poidi ka run mabunyagan kon imong pagtoo ugut gid sa imong tagiposoon.” Makon ang opisyal, “Uu, nagatoo ako nga si Jesu-Cristo maman anang Bata ang Dios”. ");
INSERT INTO clu_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ginpatadung ang opisyal ang karo kag naglosong sanda nga darwa sa tobig kag ginbunyagan tana dayon ni Felipe. ");
INSERT INTO clu_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Pagkatakas nanda alin sa tobig, golpi nga gindara si Felipe anang Ispirito ang Ginoo. Ara tana run nakita ang opisyal, piro malipayun gid ang opisyal nga nagpadayon sa anang pagoli. ");
INSERT INTO clu_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Mamarasmasan ni Felipe, doto tana run sa logar ang Asdod. Kag nagpangwalian tana ang Mayad nga Barita sa mga banwa nga anang ginaagian asta nakaabot tana sa Cesarea. ");
INSERT INTO clu_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Si Saulo tana sigi pa gid anang pagpamaug sa anang mga somolonod ni Ginoong Jesus nga papamatayun na sanda. Nagayan tana pa sa pinakamataas nga pari ");
INSERT INTO clu_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","kag nagpangayo mga solat nga magataw awtoridad kag magapakilala kanana doto sa anang mga simbaan ang mga Judio sa Damasco. Toyo na nga pandakupun kag daraun pabalik sa Jerusalem anang makita doto nga mga somolonod ni Cristo, lalaki okon babai. ");
INSERT INTO clu_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Datong si Saulo nagainamput run sa siodad ang Damasco, may sanag nga alin sa langit nga golpi lang nga naglanyag kanana. ");
INSERT INTO clu_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Natomba tana dayon sa logta kag may nabatian tana nga limug nga nagakoon, “Saulo, Saulo! Basi ginaingabot mo ako?” ");
INSERT INTO clu_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Makon ni Saulo, “Sino kaw, Ginoo?” Makon ang limug, “Ako si Jesus nga imong ginaingabot. ");
INSERT INTO clu_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Pagtindug kag magdiritso sa siodad, ay doto may masogid kanimo kon ano imong dapat imoon.” ");
INSERT INTO clu_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ara gid may nakalimug sa anang mga kaiban ni Saulo kondi nagtirindug sanda lang gid doto. Nakabati sanda ang limug, piro ara sanda may nakita. ");
INSERT INTO clu_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Nagtindug si Saulo, piro pagmoklat na indi tana run makakita. Gani ginagobay tana anang mga kaiban asta sa Damasco. ");
INSERT INTO clu_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Sa sulud tatlo ka adlaw indi tana makakita, kag ara tana magkaun okon maginum. ");
INSERT INTO clu_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Karon, doto sa Damasco may sangka somolonod si Jesus nga anang aran si Ananias. Nagpakita kanana ang Ginoo nga nagatawag, makon, “Ananias!” Makon ni Ananias, “Ginoo, dagi ako.” ");
INSERT INTO clu_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Makon ang Ginoo kanana, “Dadi nga lagi magayan kaw sa dalan nga ginatawag Matadlung, kag doto sa anang balay ni Judas sagapun mo ang tao nga taga-Tarso nga anang aran si Saulo. Nagapangamoyo tana dadi, ");
INSERT INTO clu_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","kag paagi sa akun gaum ginpakita ko kanana nga ikaw nagsulud kag nagtongtong imong alima kanana agud makakita tana ruman.” ");
INSERT INTO clu_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Piro nagsabat si Ananias, makon na, “Ginoo, doro ron akun nabatian parti sa tao nga dan. Imong mga somolonod sa Jerusalem ginpangingabot na nga mayad. ");
INSERT INTO clu_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Kag nagayan tana gani digi sa Damasco nga may paanogot alin sa mga manogdomara nga mga pari agud pandakupun na ang tanan nga nagapanawag kanimo.” ");
INSERT INTO clu_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Piro makon ang Ginoo kay Ananias, “Panaw lang ay ginpili ko tana para magsirbi kanakun agud ipakilala na akun aran sa mga bukun Judio, sa mga ari, kag sa mga Israelita. ");
INSERT INTO clu_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Kag ipakita ko ra kanana ang mga arantoson nga dapat na nga agian para kanakun.” ");
INSERT INTO clu_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Gani ginayanan ni Ananias si Saulo sa balay nga anang ginadayonan, kag pagsulud na doto gintongtong na anang alima kay Saulo. Makon na dayon, “Saulo, kabogto ko sa Ginoo, ginsogo ako ni Ginoong Jesus digi kanimo. Tana ang nagpakita kanimo sa dalan ang nagapaayan kaw digi. Ginsogo na ako digi agud makakita kaw roman kag agud gauman kaw ang Ispirito Santo.” ");
INSERT INTO clu_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Lagi-lagi nagkaraolog alin sa anang mga mata ni Saulo ang midyo sa mga imbis ang isda kag nakakita tana ruman. Pagkatapos dato dayon tanang tindug kag nagpabunyag. ");
INSERT INTO clu_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Nagkaun tana kag nagbaraskug ruman anang lawas. Sa sulud pira ka adlaw nga si Saulo doto sa Damasco nagtawas-tawas tana sa anang mga somolonod ni Jesus. ");
INSERT INTO clu_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Nagayan tana sa anang mga simbaan ang mga Judio kag doto ginwali na ang parti kay Jesus nga tana maman anang Bata ang Dios. ");
INSERT INTO clu_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ang tanan nga nakabati kanana natingala nga mayad. Makon nanda, “Indi bala nga maman dia ang tao nga nagapamatay ang mga tao nga nagatoo kay Jesus doto sa Jerusalem? Kabay nagayan tana gani digi agud pandakupun ang mga tao nga nagatoo sa aran nga dato kag daraun sa mga manogdomara nga mga pari?” ");
INSERT INTO clu_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Nagdogang pa gid anang abilidad ni Saulo sa pagwali. Ginpamatodan na nga indi maimotig nga si Jesus maman ang Cristo, kag ang mga Judio sa Damasco indi makasabat kanana. ");
INSERT INTO clu_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Pagkalubas dorong mga inadlaw nagtiripon ang mga Judio kag nagplano nga patayun nanda si Saulo. ");
INSERT INTO clu_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Adlaw-gabi ginbantayan nanda anang mga poirtaan ang siodad ay patayun nanda tana kon andang makita. Garing may nakasogid kay Saulo parti sa andang plano. ");
INSERT INTO clu_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Gani may gabi nga ginpasulud tana anang mga somolonod sa tiklis kag gintonton sa goa anang padir ang siodad. ");
INSERT INTO clu_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Pagabot ni Saulo sa Jerusalem, gosto na gid andan nga magpakigkaiban sa anang mga somolonod ni Jesus, garing naadlukan sanda kanana. Indi sanda magpati nga tana somolonod ron da ni Jesus. ");
INSERT INTO clu_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Piro ginboligan tana ni Bernabe. Gindara na tana sa mga apostolis kag ginpakilala. Ginsaysay ni Bernabe kananda kon paiwan nakita ni Saulo si Ginoong Jesus sa dalan kag kon ano anang ginambal kanana. Kag ginsogid na ra anang kaisug ni Saulo sa pagwali parti kay Jesus doto sa Damasco. ");
INSERT INTO clu_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Gani alin dato naging kaiban nanda run si Saulo, kag miski diin sa Jerusalem ara naadluki si Saulo nga magwali parti sa Ginoo. ");
INSERT INTO clu_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Nagambal tana ra kag nagpakigdiskosyon sa mga Judio nga andang ambal Griego, piro nasilag sanda kag nagplano sanda nga patayun tana. ");
INSERT INTO clu_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Pagkaulam ang mga kabogto kay Cristo sa plano nga dato, ginatud nanda si Saulo sa banwa ang Cesarea kag pinaoli dayon sa Tarso. ");
INSERT INTO clu_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Pagkatapos dato, naging mataway anang kaboi ang mga tomoloo sa bilog nga Judea, sa Galilea, kag sa Samaria. Nagrigun pa gid anang pagtoo ang mga tomoloo kag nagtaod sanda sa Ginoo; kag tungud nga ginapabaskug sanda ang Ispirito Santo nagdogang sanda pa gid. ");
INSERT INTO clu_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Karon, si Pedro tana, sigi anang libot-libot sa iba-ibang logar agud bisitaun anang mga bata ang Dios. Kag nagayan tana ra sa mga tomoloo doto sa Lida. ");
INSERT INTO clu_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Doto sa logar nga dato nakita ni Pedro ang tao nga anang aran si Eneas. Dia nga tao paralitiko kag ara gid kabangon sa anang iringgaan sa sulud walo ka toig. ");
INSERT INTO clu_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Makon ni Pedro kanana, “Eneas, ginayad ka run ni Ginoong Jesu-Cristo. Gani pagbangon kag imusun imong iringgaan.” Kag nagbangon ra nga lagi si Eneas. ");
INSERT INTO clu_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Nakita ang tanan nga mga pomoloyo sa Lida kag sa Saron nga mayad run si Eneas. Kag nagtoo sanda ra sa Ginoo. ");
INSERT INTO clu_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Karon, doto sa Jope may tomoloo nga babai nga anang aran si Tabita. (Sa Griego anang aran Dorcas nga ang gostong ambalun osa.) Dia nga babai doro anang mayad nga mga inimoan kapin pa sa mga malisud. ");
INSERT INTO clu_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Natabo ra dato nga nagmasakit ang babai nga dia kag napatay. Ginponasan nanda anang bangkay kag ginsulud sa koarto sa ibabaw. ");
INSERT INTO clu_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ang Jope bukun ra gid marayu sa Lida. Gani pagkabati ang mga tomoloo nga si Pedro doto sa Lida, ginsogo nanda ang darwa ka tao nga ayanan tana doto kag pangabayun nga magayan doto sa Jope lagi-lagi. ");
INSERT INTO clu_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pagkaabot ang mga ginsogo nga dia doto kay Pedro, lagi-lagi nagimus ra si Pedro kag nagtabid kananda. Pagabot nanda doto sa Jope gindara tana sa koarto nga ginabutangan ang patay. May mga balo doto nga nagaparanangis. Ginpakita nanda kay Pedro ang mga lambong nga ginpamudbud ni Docras ang boi tana pa. ");
INSERT INTO clu_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pagkatapos, anang ginimo ni Pedro, pinagoa na sanda tanan sa koarto. Naglood tana dayon kag nagpangamoyo. Pagkatapos nagatobang tana sa bangkay kag magkoon, “Tabita, bangon!” Nagmoklat si Tabita kag pagkakita na kay Pedro nagpongko tana. ");
INSERT INTO clu_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Kinaputan tana ni Pedro sa anang alima kag ginboligan nga magtindug. Pagkatapos gintawag na dayon ang mga balo kag ang iba nga mga tomoloo doto kag ginpakita kananda si Tabita nga boi run. ");
INSERT INTO clu_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Dia nga itabo nabaritaan sa bilog nga Jope, kag doro ang nagtoo kay Ginoong Jesus. ");
INSERT INTO clu_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Maboay-boay pa ra anang tinir ni Pedro doto sa Jope sa anang balay ni Simon nga manogbulad ang panit. ");
INSERT INTO clu_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Doto sa Cesarea may tao nga anang aran si Cornelio. Dia nga tao isara sa mga kapitan ang mga soldado nga Romano sa batalion nga ginatawag Batalion Italiano. ");
INSERT INTO clu_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Si Cornelio riliyoso nga tao; tana kag anang bilog nga pamilya nagasimba sa Dios. Doro anang naimo nga bolig sa mga Judio nga pobri, kag pirmi tana nga nagapangamoyo sa Dios. ");
INSERT INTO clu_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Karon, may sangka adlaw, mga alas tris ang apon, may nagpakita kanana nga angil ang Dios. Masanag gid anang panulung sa angil nga nagsulud sa anang balay kag nagtawag kanana. Makon na, “Cornelio!” ");
INSERT INTO clu_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Pagkakita na sa angil ginadlukan tana, kag makon na, “Ano imong kinanglan?” Makon ang angil kanana, “Ginpamatian ang Dios imong mga pangamoyo kag nalilipay tana sa imong bolig sa mga malisud. Gani ginadumdum kaw ang Dios. ");
INSERT INTO clu_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Imong imoon dadi, magsogo kaw mga tao sa Jope kag ipasolang si Simon nga ginatawag ra nga Pedro. ");
INSERT INTO clu_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Doto tana nagadayon kay Simon nga manogbulad ang panit. Anang balay sa binit ang baybay.” ");
INSERT INTO clu_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Pagkaalin ang angil nga dato, tinawag ni Cornelio ang darwa sa anang mga sorogoon kag ang isara sa soldado nga anang ginasogo-sogo. Ang soldado nga dato riliyoso ra nga tao. ");
INSERT INTO clu_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ginsogidan sanda ni Cornelio ang tanan nga natabo kag pagkatapos ginsogo na sanda sa Jope. ");
INSERT INTO clu_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ang madason nga adlaw mintras nagarapit sanda run sa banwa ang Jope, nagsaka si Pedro sa parawaywayan doto sa borobongan nga tapan agud magpangamoyo. Nagaingogto gid dato ang adlaw. ");
INSERT INTO clu_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Gingutum si Pedro kag gosto na andan nga magkaun. Piro mintras ginapriparar nanda pa ang pagkaun may ginpakita kanana ang Dios. ");
INSERT INTO clu_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Nakita na ang langit nga nagbokas kag may nagapaidalum sa logta nga midyo sa oslon nga malapad nga ginatonton sa anang apat ka posod. ");
INSERT INTO clu_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Kag doto sa oslon nga dato nakita na ang tanan nga klasi nga mga sapatꞋang mga sapat nga nagaparanaw, ang mga nagakaramang, kag ang mga nagarulupad. ");
INSERT INTO clu_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Kag may limug tana dayon nga nabatian nga nagakoon, “Pedro, pagtindug! Pagyaw kag magkaun!” ");
INSERT INTO clu_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Makon ni Pedro, “Ginoo, indi maimo, tungud nga asta dadi ara ako pa gid kakaun ang mga sapat nga pario dan nga sono sa Kasogoan ginabilang nga marisna.” ");
INSERT INTO clu_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Makon roman ang limug kay Pedro, “Ayaw pagkona nga marisna ang bisan ano nga butang nga ginlimpyo ron ang Dios.” ");
INSERT INTO clu_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Dia tatlo gid ka bisis nga ginolit, kag pagkatapos, ang gintonton nga dato ginbatak pabalik sa langit. ");
INSERT INTO clu_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Mintras ginaisip pa ni Pedro kon ano anang kaologan anang nakita nga dato, nagabot ron ang mga tao nga ginsogo ni Cornelio. Ay pagkaulam nanda kon diin anang balay ni Simon, nagdiritso sanda doto; kag pagabot nanda sa may poirtaan ang kodal ");
INSERT INTO clu_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","nagpanawag sanda kag nagpamangkot kon may nagadayon doto nga tao nga anang aran si Simon Pedro. ");
INSERT INTO clu_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Nagkoon ang Ispirito Santo kay Pedro nga nagapalibug pa kon ano anang kaologan anang nakita, makon na, “May tatlo ka tao dian nga nagapangita kanimo. ");
INSERT INTO clu_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Sigi, paglosong kag magtabid kananda, kag indi kaw magpangalangan tungud nga ako mismo ang nagsogo kananda.” ");
INSERT INTO clu_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Gani naglosong dayon si Pedro kag nagkoon sa mga tao, “Ako maman ang tao nga indong ginapangita. Ano indong kinanglan kanakun?” ");
INSERT INTO clu_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Makon nanda, “Kami ginsogo digi ni Kapitan Cornelio. Mayad tana nga kag tao nagasimba sa Dios. Ginataod tana ang tanan nga mga Judio. Anang angil ang Dios nagkoon kanana nga agadun kaw doto sa anang balay agud mabatian na kon ano imong iambal.” ");
INSERT INTO clu_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ginpasulud sanda ni Pedro kag doto sanda nagkatorog ang gabi nga dato. Ang madason nga adlaw nagtabid si Pedro kananda. May pira ra ka mga tomoloo sa Jope nga nagtawas ra kanana. ");
INSERT INTO clu_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Pagkadason nga adlaw nagabot sanda sa Cesarea. Nagapaabot ron da si Cornelio kananda pati anang mga paryinti kag masuud nga mga amigo nga anang ginpanawag. ");
INSERT INTO clu_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pagabot ni Pedro, ginsolang-solang tana ni Cornelio kag naglood agud simbaun tana. ");
INSERT INTO clu_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Piro ginpatindug tana ni Pedro kag magkoon, “Pagtindug, ay ako tao ra lang.” ");
INSERT INTO clu_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Kag padayon andang sogidanun mintras nagasulud sanda sa balay, kag doto sa sulud nakita ni Pedro nga dorong tao ang nagatiripon. ");
INSERT INTO clu_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Makon ni Pedro kananda, “Kamo mismo nakaulam nga kami nga mga Judio ginabawalan amun riliyon nga magbisita okon magpakigkaiban sa mga bukun Judio. Piro ginpasanag kanakun ang Dios nga indi ko dapat kabigun nga marisna ang bisan sino nga tao. ");
INSERT INTO clu_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Gani pagpasogo nindo kanakun nga magayan digi, ara ako magriklamo. Piro dadi gosto ko nga maulaman kon basi ginpatawag nindo ako.” ");
INSERT INTO clu_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Nagsabat si Cornelio, makon na, “Mga tatlo ron dadi ka adlaw ang nakalubas nga ako nagapangamoyo digi sa balay, kag midyo toladia ra nga oras dato, mga alas tris ang apon. Mintras nagapangamoyo ako, golpi lang nga nagpakita kanakun ang tao nga may masolaw nga lambong. ");
INSERT INTO clu_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Kag makon na dayon kanakun, ‘Cornelio, ginpamatian ang Dios imong pangamoyo kag ginadumdum na imong pagbolig sa mga pobri. ");
INSERT INTO clu_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Dadi, magsogo kaw mga tao sa Jope kag ipaabat ang tao nga anang aran si Simon Pedro. Doto tana nagadayon sa anang balay ni Simon nga manogbulad ang panit. Anang balay sa binit gid ang baybay.’ ");
INSERT INTO clu_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Gani ginpasogoan ta kaw nga lagi, kag salamat ay nagabot ka ra. Ta, digi kami tanan sa prisinsya ang Dios agud pamatian kon ano anang ginsogo ang Dios kanimo nga isogid kanamun.” ");
INSERT INTO clu_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Gani nagambal si Pedro, makon na, “Dadi naulaman ko ron nga ang Dios ara pinilian. ");
INSERT INTO clu_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Kon ang tao gali may kaadluk sa Dios kag osto anang ginaimo, bisan ano anang lai batonon tana ang Dios. ");
INSERT INTO clu_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Nabatian nindo ra ang Mayad nga Barita nga ginsogid ang Dios kanamun nga mga Israelita nga ang tao makapasagoli run kanana paagi sa pagtoo kay Jesu-Cristo. Tana anang Ginoo ang tanan. ");
INSERT INTO clu_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","38","Naulaman nindo ra ang mga natabo sa bilog nga probinsya ang Judea parti kay Jesus nga taga-Nazaret. Kabay nagompisa dia sa Galilea pagkatapos nga makawali si Juan parti sa pagbunyag. Gintawan ang Dios si Jesus ang Ispirito Santo kag gaum. Kag tungud nga kaiban na ang Dios, nagayan tana sa iba-ibang logar nga nagaimo mayad. Kag ginaayad na ra ang tanan nga ginapaantos ang dimonyo. ");
INSERT INTO clu_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Kami mismo makapamatood sa tanan nga anang ginpangimo tungud nga nakita namun mismo anang mga ginpangimo sa Jerusalem kag sa ibang mga banwa ang mga Judio. Ginpatay tana ang mga Judio paagi sa paglansang kanana sa kros. ");
INSERT INTO clu_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Piro ginbanaw tana ang Dios sa ikatlo ka adlaw kag ginpakita kanamun nga tana boi. ");
INSERT INTO clu_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ara tana pagpakitaan ang Dios sa tanan kondi kanamun lang nga anang ginpili run nga lagi ang ona bilang mga tistigo para ibarita sa iba ang parti kanana. Pagkabanaw kanana, nakaiban namun tana nga nagkaun kag naginum. ");
INSERT INTO clu_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Kag ginsogo na kami nga magwali ang Mayad nga Barita sa mga tao. Ginkonan na kami ra nga pamatodan nga tana maman gid anang ginpili ang Dios nga maging manogukum sa mga boi kag sa mga napatay run. ");
INSERT INTO clu_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Si Jesu-Cristo maman anang ginakoon ang tanan nga mga propita nga ang tanan nga nagatoo kanana patawadun andang mga sala paagi sa anang gaum anang aran.” ");
INSERT INTO clu_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Mintras nagawali pa si Pedro nagkunsad ang Ispirito Santo sa tanan nga nagaparamati doto. ");
INSERT INTO clu_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ang mga tomoloo nga mga Judio nga nagtabid kay Pedro alin sa Jope natingala nga ang Dios nagtaw ra ang Ispirito Santo sa mga bukun Judio. ");
INSERT INTO clu_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Ay nabatian nanda sanda nga nagaambal sa iba-ibang mga ambal kag nagadayaw sa Dios. Gani makon ni Pedro, ");
INSERT INTO clu_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Dia nga mga tao nakabaton ron ang Ispirito Santo nga pario atun nabaton bisan matood nga sanda bukun Judio. Gani ara run adlang para mabunyagan sanda sa tobig.” ");
INSERT INTO clu_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Nagsogo tana dayon nga dia sanda bunyagan agud ipakita nga sanda kay Jesu-Cristo ron. Pagkatapos dato ginpangabay nanda si Pedro nga magtinir anay pira ka adlaw doto kananda. ");
INSERT INTO clu_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Karon, nabatian ang mga apostolis kag mga tomoloo sa Judea nga ang mga bukun Judio nagbaton ra anang ambal ang Dios. ");
INSERT INTO clu_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Gani pagbalik ni Pedro sa Jerusalem, ginbasol tana ang mga tomoloo nga mga Judio nga nagapati nga ang mga bukun Judio kinanglan magpatori anay bago makadapun kananda. ");
INSERT INTO clu_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Makon nanda kay Pedro, “Ikaw kabay Judio, ta basi nagayan kaw doto kag nagkaun pa sa anang balay ang mga bukun Judio nga ara matori?” ");
INSERT INTO clu_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Gani ginsaysay ni Pedro kananda ang tanan nga natabo kanana alin sa ompisa. ");
INSERT INTO clu_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Makon na, “Ang ako nagapangamoyo doto sa siodad ang Jope may ginpakita kanakun ang Dios. May nakita ako nga midyo sa malapad nga oslon nga nagapaidalum alin sa langit. Dia ginatonton sa anang apat ka pamosod, kag sa akun tupad mismo nagtadung. ");
INSERT INTO clu_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ginsulung ko nga mayad kag nakita ko nga anang sulud sari-sari nga klasi ang sapat. May doto nga may apat andang siki, may mga mapirintas, may mga nagakaramang, kag may mga nagarulupad. ");
INSERT INTO clu_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Kag may nabatian ako nga limug nga nagkoon kanakun, makon, ‘Pedro, pagtindug! Pagyaw kag magkaun!’ ");
INSERT INTO clu_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Piro nagsabat ako nga indi ko dato maimo tungud nga ako ara pa gid kakaun ang mga sapat nga toladato nga marisna kag ginabawal ang Kasogoan. ");
INSERT INTO clu_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Pagkatapos makon roman ang limug alin sa langit, ‘Ayaw pagkona nga marisna ang mga butang nga ginakoon ang Dios nga limpyo.’ ");
INSERT INTO clu_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Tatlo gid ka bisis dia natabo, kag pagkatapos dato ginbatak ruman ang mga butang nga dato sa langit. ");
INSERT INTO clu_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Sa oras ra gid nga dato may tatlo ka tao alin sa Cesarea nga nagabot doto sa balay nga akun ginadayonan. Ang mga tao nga dato ginsogo doto agud pangitaun ako. ");
INSERT INTO clu_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ang Ispirito Santo nagkoon kanakun nga indi ako magpangalangan nga magtabid kananda. Ang anum nga dia nga atun mga kabogto kay Cristo nga taga-Jope kaiban ko mismo pagayan ko doto sa anang balay ni Cornelio sa Cesarea. ");
INSERT INTO clu_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Pagabot namun doto ginsogidan kami ni Cornelio nga may nakita tana nga angil doto sa sulud anang balay. Nagkoon kono ang angil kanana nga magsogo tana mga tao nga ipasolang doto sa Jope si Simon nga kon tawagun Pedro. ");
INSERT INTO clu_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Isogid na kanana kon paiwan tana malowas pati anang pamilya. ");
INSERT INTO clu_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Pagkaambal dato ni Cornelio, nagompisa ako gani nga magambal kananda, kag mintras nagaambal ako pa nagabot ang Ispirito Santo kananda pario anang pagabot kanatun ang ona. ");
INSERT INTO clu_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Kag nadumduman ko dayon anang koon ni Ginoong Jesus: ‘Ginbunyagan ni Juan ang mga tao sa tobig, piro kamo bunyagan sa Ispirito Santo.’ ");
INSERT INTO clu_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Gani ang natabo nga dato nagapamatood nga anang gintaw ang Dios kanatun nga mga Judio pagtoo ta kay Ginoong Jesu-Cristo gintaw na ra sa mga bukun Judio. Ta kon maman dato anang gosto ang Dios, sino ako nga magkontra sa anang gosto?” ");
INSERT INTO clu_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Pagkabati dato ang mga tomoloo nga Judio, ara sanda run magsari basol kay Pedro, kondi nagdayaw sanda sa Dios. Makon nanda, “Kon toladato, ang mga bukun Judio gali ginapainulsul ra ang Dios sa andang mga sala agud makabaton sanda ra kaboi nga ara kataposan.” ");
INSERT INTO clu_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Alin ang pagpatay kay Esteban nagrarapta ang mga tomoloo tungud sa pagingabot kananda. Ang iba kananda nagarabot sa logar ang Fenicia, sa isla ang Cipre, kag pati sa banwa ang Antioquia. Ginsogid nanda ang Mayad nga Barita miski sa diin sanda makaayan, garing sa mga Judio lang. ");
INSERT INTO clu_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Piro ang iba nga mga tomoloo nga taga-Cipre kag taga-Cirene nagayan ra sa Antioquia kag pati ang mga bukun Judio ginasogidan nanda ang Mayad nga Barita parti kay Ginoong Jesu-Cristo. ");
INSERT INTO clu_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ginboligan sanda ang Ginoo, kag doro ang nagtoo kag nagliso sa Ginoo. ");
INSERT INTO clu_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ang natabo nga dia nabaritaan ang mga tomoloo sa Jerusalem, gani ginpadara nanda si Bernabe doto sa Antioquia. ");
INSERT INTO clu_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Pagabot na doto nalipay tana ay nakita na nga ginkaloyan gid matood ang Dios ang mga tao doto. Kag ginlaygayan na sanda nga magpakatutum kag magpakarigun sa andang pagtoo sa Ginoo. ");
INSERT INTO clu_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Si Bernabe nga dia mayad nga tao, ginagauman ang Ispirito Santo, kag ugut anang pagtoo sa Dios. Gani doro doto ang nagtoo sa Ginoo. ");
INSERT INTO clu_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Nagayan dayon si Bernabe sa Tarso agud pangitaun si Saulo. ");
INSERT INTO clu_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Pagkakita na kanana gindara na pabalik sa Antioquia. Sangka toig sanda gid nga naging kaiban ang mga tomoloo doto kag dorong tao andang gintodloan. Ang mga tomoloo doto sa Antioquia maman ang ona nga gintawag nga mga Kristiano. ");
INSERT INTO clu_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ang mga adlaw nga dato may mga propita doto sa Jerusalem nga nagayan sa Antioquia. ");
INSERT INTO clu_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ang isara kananda anang aran si Agabo. Nagtindug tana kag paagi sa anang gaum ang Ispirito Santo nagtagna tana nga may tiggurutum nga magaabot sa bilog nga kalibotan. (Ang tiggurutum nga dato natabo matood sa tyimpo nga si Claudio ang Impirador sa Roma.) ");
INSERT INTO clu_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Gani anang ginimo ang mga tomoloo doto sa Antioquia, nagkarasogot sanda nga kada isara kananda mapadara bolig sa andang mga kabogto kay Cristo nga doto sa Judea sono sa andang masarangan. ");
INSERT INTO clu_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Kag ginpadara nanda dia kay Bernabe kag kay Saulo agud itaw sa mga maulam-ulam nga nagadomara sa mga tomoloo doto sa Jerusalem. ");
INSERT INTO clu_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Sa mga tyimpo nga dato ginompisaan ingabot ni Aring Herodes ang pira ka mga tomoloo kay Cristo. ");
INSERT INTO clu_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ginpapatay na si Santiago nga anang kabogto ni Juan paagi sa ispada. ");
INSERT INTO clu_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Pagkakita na nga nalipay ang mga Judio tungud sa anang ginimo nga dato, ginpadakup na ra si Pedro. Dia natabo ang nagapista ang mga Judio ang Pista ang Tinapay nga ara Pampaabok. ");
INSERT INTO clu_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Ginpasulud na si Pedro sa prisoan kag ginpagoardyaan sa apat ka gropo nga mga soldado nga tag-apat. Sono sa anang plano ni Herodes, anang bista ni Pedro imoon na sa pobliko pagkatapos ang Pista anang Paglubas ang Angil. ");
INSERT INTO clu_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Gani ginpabantayan na lang sa mga soldado si Pedro doto sa prisoan. Piro ang mga tomoloo tana padayon andang maugut nga pagpangamoyo sa Dios para kanana. ");
INSERT INTO clu_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ang gabi nga bago bistaun anang kaso ni Pedro, nagakatorog tana nga ginakadinaan darwa ka kadina sa tunga ang darwa ka soldado. May mga goardya pa nga nagabantay sa poirtaan ang prisoan. ");
INSERT INTO clu_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Karon, golpi lang nga nagsanag sa sulud ang prisoan kag may nagpakita doto nga angil nga ginsogo ang Ginoo. Gintapik na anang kilid ni Pedro agud pokawon, kag makon na dayon “Dali! Pagbangon!” Kag nagkaraukas ang mga kadina nga nagabugkus sa anang alima. ");
INSERT INTO clu_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Makon ra ang angil, “Soksokan imong akus kag imong sandalyas.” Kag ginsonod ra dato ni Pedro. Pagkatapos makon dayon ang angil kanana, “Soksokan imong inogpangalikupkup kag magsonod kanakun.” ");
INSERT INTO clu_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Kag nagsonod tana sa angil pagoa sa prisoan. Ara kaulam si Pedro kon matood ang nagakaratabo. Anang pagsarig tana taginup lang dato. ");
INSERT INTO clu_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ginlubasan nanda ang primiro kag ang ikarwa nga mga goardya. Pagabot nanda sa salsalun nga poirtaan nga nagaatobang sa siodad, ang poirtaan nagabri lang ang ana. Kag naggoa sanda dayon. Pagkalampas nanda sa sangka kalyi golpi tana lang nga ginbayaan ang angil. ");
INSERT INTO clu_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Bago na pa naulaman nga bukun gali taginup ang natabo kanana. Makon na, “Matood ra gid nga ginpadara ang Ginoo anang angil kag ginloas na ako kay Herodes kag sa tanan anang ginalauman ang mga Judio nga matabo kanakun.” ");
INSERT INTO clu_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Pagkaulam na nga tana libri run, nagayan tana doto sa anang balay ni Maria nga nanay ni Juan Marcos. Dorong tao ang nagtiripon doto kag nagaparangamoyo. ");
INSERT INTO clu_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Nagpanoktok si Pedro sa poirtaan sa goa, kag naggoa ang sorogoon nga si Roda agud sulungun kon sino ang nagapanoktok. ");
INSERT INTO clu_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Nakilala na anang limug ni Pedro kag sa anang kalipay sa baylo nga abrian na ang poirtaan, domalagan tana pasulud agud sogidan anang mga kaiban nga si Pedro doto sa goa. ");
INSERT INTO clu_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Makon nanda kay Roda, “Nagomang ka run sigoro!” Piro ginapirit ni Roda nga doto gani si Pedro. Gani makon nanda, “Basi kon anang angil ni Pedro dato.” ");
INSERT INTO clu_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Si Pedro tana sigi pa ra gid anang panoktok. Gani ang ori ginbokasan nanda ang poirtaan kag aros indi sanda makapati tungud nga si Pedro ra gid gani. ");
INSERT INTO clu_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ginsinyasan sanda ni Pedro nga magipus, kag ginsaysay na dayon kananda kon paiwan tana ginpagoa ang Ginoo sa prisoan. Kag ginkonan na sanda nga sogidan nanda si Santiago kag ang iba pa nga mga tomoloo. Pagkatapos dato naggoa tana kag nagayan sa ibang logar. ");
INSERT INTO clu_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Pagkasanag nagkagolo nga mayad ang mga goardya ay ara run si Pedro kag ara sanda kaulam kon ano ang natabo kanana. ");
INSERT INTO clu_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Nagsogo si Herodes nga pangitaun tana, piro ara nanda gid makita. Gani ginpaimbistigar na ang mga goardya kag ginpapatay na dayon. Pagkatapos dato nagalin si Herodes sa Judea. Nagayan tana sa Cesarea kag doto nagtinir. ");
INSERT INTO clu_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Karon, si Herodes nga dia, doro gid anang kasilag sa mga tao sa Tiro kag Sidon. Piro ang mga taga-Tiro kag taga-Sidon nagabuul andang pagkaun sa anang banwa ang ari, gani nagkarasogot sanda nga magpakigosay sa ari. Primiro ginamigo nanda anay si Blasto agud boligan sanda, ay tana maman anang ginasarigan ang ari sa palasyo. Pagkatapos, nagayan sanda dayon sa ari agud magpakigkita kanana. ");
INSERT INTO clu_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Pagabot ang adlaw nga si Herodes magapakigkita run sa mga taga-Tiro kag taga-Sidon, ginsoksok na anang lambong nga para sa ari kag nagpongko tana dayon sa anang trono kag magdiskorso. ");
INSERT INTO clu_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Nagsiringgit ang mga tao, makon nanda, “Bukun tao ang nagaambal nga dan, kondi dios!” ");
INSERT INTO clu_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Kag dato ra nga lagi ginsilotan tana anang angil ang Ginoo, tungud nga ara na pagtawan ang padungug sa Dios. Ginolod tana kag napatay dayon. ");
INSERT INTO clu_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Gani anang ambal ang Dios padayon nga naglapnag kag nagdoro pa gid ang mga tomoloo. ");
INSERT INTO clu_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Karon, si Bernabe kag si Saulo tana, pagkaatud nanda anang bolig ang mga tomoloo sa mga tomoloo doto sa Jerusalem, nagbalik sanda sa Antioquia. Gindara nanda ra si Juan Marcos. ");
INSERT INTO clu_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Doto sa Antioquia may mga propita kag mga manogtodlo nga kabilang sa mga tomoloo kay Cristo. Ang iba kananda si Bernabe, si Simeon nga ginatawag nga Nigro, si Lucio nga taga-Cirene, si Manaen nga nagbaul kaiban ni Herodes nga Gobirnador, kag si Saulo. ");
INSERT INTO clu_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Mintras nagapoasa sanda kag nagasimba sa Ginoo, nagkoon kananda ang Ispirito Santo, makon, “Pabulagan nindo si Bernabe kag si Saulo ay ako may ipaimo nga obra kananda.” ");
INSERT INTO clu_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Pagkatapos andang poasa kag pagpangamoyo, gintongtongan nanda si Bernabe kag si Saulo andang alima kag ginpapanaw dayon. ");
INSERT INTO clu_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Gani nagpa-Seleucia si Bernabe kag si Saulo nga ginpadara ang Ispirito Santo. Kag alin doto nagsakay sanda paayan sa isla ang Cipre. ");
INSERT INTO clu_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Pagabot nanda doto sa banwa ang Salamina ginwali nanda anang ambal ang Dios sa anang mga simbaan ang mga Judio. Kaiban nanda ra si Juan Marcos nga mabolig kananda sa andang obra. ");
INSERT INTO clu_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Gintaris-taris nanda ang bilog nga isla asta nakaabot sanda sa banwa ang Pafos sa loyong baybay. May nakita sanda doto nga madyikiro nga si Bar-Jesus. Judio tana, kag nagapakono-kono nga tana propita nga ginsogo ang Dios. ");
INSERT INTO clu_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Amigo tana ni Sergio Paulo nga gobirnador ang isla nga dato. Si Sergio Paulo nga dia maaram nga tao. Ginpatawag na si Bernabe kag si Saulo tungud nga gosto na nga magpamati anang ambal ang Dios. ");
INSERT INTO clu_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Garing ginpamalabagan sanda ang madyikiro nga si Elimas. (Maman dia anang aran ni Bar-Jesus sa ambal nga Griego.) Ginimoratan na gid nga ipalikaw ang gobirnador agud indi tana magtoo kay Jesus. ");
INSERT INTO clu_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Piro si Saulo nga ginatawag ra nga Pablo gingauman ang Ispirito Santo. Ginsulung na nga mayad si Elimas kag magkoon, ");
INSERT INTO clu_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Bata kaw ni Satanas! Kaaway kaw ang tanan nga mayad! Poros pandaya kag panloko imong ginaimo. Ginabaliskad mo pirmi ang mga kamatoodan nga alin sa Ginoo. ");
INSERT INTO clu_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Dadi sisilotan na ikaw. Mabobolag kaw kag indi gid makakita sa sulud ang pira ka adlaw.” Lagi-lagi nagdulum anang panulung ni Elimas kag nabolag tana. Nagpangapkap tana run lang nga nagasagiap ang maagobay kanana. ");
INSERT INTO clu_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Pagkakita ang gobirnador sa natabo kay Elimas nagtoo tana, ay natingala tana nga mayad sa mga panodlo parti sa Ginoo. ");
INSERT INTO clu_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pagalin nanday Pablo sa Pafos, nagsakay sanda sa sakayan nga pa Perga sa probinsya ang Panfilia. Pagabot nanda doto ginbayaan sanda ni Juan Marcos. Nagbalik tana sa Jerusalem. ");
INSERT INTO clu_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Sanday Pablo tana nagdiritso sa Antioquia nga sa probinsya ang Pisidia. Pagabot ang Adlaw nga Inogpaway nagayan sanda sa anang simbaan ang mga Judio kag nagpongko doto. ");
INSERT INTO clu_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","May nagbasa sa anang Kasogoan ni Moises kag sa anang mga ginsolat ang mga propita. Pagkatapos may ginsogo ang mga opisyalis nga konon sanday Pablo kon may inogambal sanda nga makabolig sa mga tao. ");
INSERT INTO clu_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Gani nagtindug si Pablo kag ginsinyasan na ang mga tao nga magpamati kanana. Makon na, “Mga kapario ko nga mga Israelita, kag kamo nga bukun Israelita piro nagasimba ra sa Dios, pamatii nindo ako! ");
INSERT INTO clu_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Ang Dios nga ginasimba ang mga Israelita maman ang nagpili atun mga kaolang-olangan, kag ginpadoro na sanda mintras doto sanda pa nagaoli sa Egipto. Kag paagi sa anang gaum ginboligan na sanda agud makaalin sa Egipto. ");
INSERT INTO clu_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Sa sulud 40 ka toig ang sanda doto ron sa logar nga ara ginaolii ang tao ginagoanta lang gid ang Dios andang kasotil. ");
INSERT INTO clu_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Pagkatapos, ginpamirdi na ang pito ka nasyon sa Canaan, kag gintaw na dayon ang mga logar nga dato sa atun mga kaolang-olangan. ");
INSERT INTO clu_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Dia tanan ginimo ang Dios sa sulud 450 anyos. “Pagkatapos gintawan na sanda mga manogosgar agud magdomara kananda asta sa anang tyimpo ni Samuel nga propita. ");
INSERT INTO clu_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ang ori nagpangayo sanda ari, gani gintaw ang Dios si Saulo nga bata ni Cis kag isara sa anang kaapo-apoan ni Benjamin. Nagari si Saulo kananda sa sulud 40 ka toig. ");
INSERT INTO clu_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Pagkatapos nga paalinun ang Dios si Saulo bilang ari, si David ruman anang ginpaari kananda. Kon parti kay David maman dia anang koon ang Dios, ‘Nagostoan ko si David nga bata ni Jesse. Tana ang magatoman ang tanan nga akun isogo kanana.’” ");
INSERT INTO clu_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Makon pa ni Pablo sa mga tao, “Kag digi sa anang kaliwat ni David nagalin si Jesus nga maman ang Manlolowas nga ginpangako ang Dios sa Israel. ");
INSERT INTO clu_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Bago magompisa todlo si Jesus, nagwali run nga lagi si Juan sa tanan nga mga Israelita nga maginulsul sanda andang mga sala kag magparabunyag. ");
INSERT INTO clu_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Kag datong matatapos ron ni Juan anang obra, makon na sa mga tao, ‘Sigoro indong kaisip ako ron indong ginapaabot. Bukun ako. Ako ginpaona lang. Tana masonod dayon kag miski maging anang sorogoon lang indi ako poidi.’” ");
INSERT INTO clu_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Makon dayon ni Pablo, “Mga kabogto, kamo nga mga kaliwat ni Abraham kag kamo nga mga bukun Judio piro nagasimba ra sa Dios, kita maman anang ginpadaraan ang Dios ang Mayad nga dia nga Barita parti sa kalowasan. ");
INSERT INTO clu_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Piro ang mga Judio nga nagaoroli sa Jerusalem pati andang mga manogdomara ara nagkilala nga si Jesus maman ang Manlolowas. Ara sanda ra kaintindi anang ginambal ang mga propita nga ginabasa nanda kada Adlaw nga Inogpaway sa andang mga simbaan; piro sanda run da mismo ang nakaimo anang mga gintagna ang mga propita pagkondinar nanda kay Jesus nga patayun. ");
INSERT INTO clu_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Bisan ara sanda marigun nga ibidinsya agud patayun tana, ginpangayo nanda pa gid kay Pilato nga ipapatay si Jesus. ");
INSERT INTO clu_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Kag pagkatapos nga naimo nanda run ang tanan nga ginambal sa Kasolatan nga matatabo kanana, gintangtang nanda tana dayon sa kros kag ginbutang sa rulubungan. ");
INSERT INTO clu_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Piro ginbanaw tana ang Dios alin sa mga minatay. ");
INSERT INTO clu_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Kag sa sulud doro nga mga adlaw kon kapira-pira tana lang nagpakita sa mga tao nga nagtarabid kanana anang pagalin sa Galilea nga nagaayan sa Jerusalem. Ang mga tao nga dato maman run ang nagapanogid dadi sa mga Israelita parti kay Jesus. ");
INSERT INTO clu_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Kag kami dadi digi ra agud sogidan kamo ang mayad nga barita nga ginpangako ang Dios sa atun mga kaolang-olangan, ");
INSERT INTO clu_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","nga natoman na run kanatun nga andang mga kaapo-apoan. Kag ginimo na dia pagbanaw na kay Jesus. Toladia ra gid ang nakabutang sa ikarwa nga Salmo. Makon doto, ‘Ikaw akun Bata kag dadi ipakita ko nga ako imong Tatay.’ ");
INSERT INTO clu_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ay ginpangako ra nga lagi ang Dios nga tana banawon na kag anang lawas indi maronot tungud nga makon na ra, ‘Ang mga pangako nga akun ginpangako kay David imoon ko kanindo.’ ");
INSERT INTO clu_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Gani makon doto sa isara pa nga Salmo, ‘Indi kaw magtogot nga maronot anang lawas imong matutum nga sorogoon.’ ");
INSERT INTO clu_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Karon, bukun si David anang ginakoon nga dato, tungud nga pagkatapos anang pagsirbi ni David sa mga tao sono sa anang ginapaimo ang Dios kanana, napatay tana kag ginlubung sa kilid ang ginlubungan anang mga kaolang-olangan kag anang lawas naronot. ");
INSERT INTO clu_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Piro si Jesus tana nga ginbanaw ang Dios alin sa mga minatay ara gid maronot. ");
INSERT INTO clu_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Gani mga kabogto, dapat nindo nga maulaman nga paagi kay Jesus ginasogid namun kanindo ang barita nga kita mapapatawad ang Dios sa atun mga sala; ang bisan sino nga nagatoo kay Jesus ginabilang ang Dios nga matarung. Dia indi maimo paagi sa pagsonod sa Kasogoan ni Moises. ");
INSERT INTO clu_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Gani magandam kamo agud indi matabo kanindo anang koon ang mga propita. Makon nanda, ");
INSERT INTO clu_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Kamo nga masyado magtoyatoya, Matitingala kamo nga mayad sa akun imoon. Magakarapatay kamo lang tungud nga may imoon ako sa indong tyimpo nga indi kamo gid magpati bisan may magsaysay kanindo.’” ");
INSERT INTO clu_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Karon, datong nagagoa run si Pablo kag si Bernabe sa simbaan, ginkonan sanda ang mga tao nga magbalik sa madason nga Adlaw nga Inogpaway agud sogidan sanda pa gid parti sa mga butang nga dato. ");
INSERT INTO clu_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Pagburulag ang mga tao, doro nga mga Judio kag mga bukun Judio nga nadara sa riliyon ang mga Judio ang nagsonod kay Pablo kag kay Bernabe. Ginambalan sanda nanday Pablo kag ginlaygayan nga magpadayon sanda sarig sa anang kalooy ang Dios. ");
INSERT INTO clu_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Pagabot ang nagdason nga Adlaw nga Inogpaway aros ang tanan nga mga pomoloyo sa Antioquia nagtipon doto sa simbaan ang mga Judio agud pamatian anang ambal ang Ginoo. ");
INSERT INTO clu_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Pagkakita ang mga Judio sa doro nga mga tao nga nagtarambong, naakig sanda nga mayad kag ginkontra nanda anang mga ginpangambal ni Pablo kag gininsolto nanda tana pa. ");
INSERT INTO clu_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Piro mas nagisug pa gid gani si Pablo kag si Bernabe. Makon nanda sa mga Judio, “Kinanglan gid nga iwali anay kanindo nga mga Judio anang ambal ang Dios. Piro tungud nga ginasikway nindo nagapakilala lang nga kamo indi bagay nga tawan kaboi nga ara kataposan. Gani alin dadi, sa mga bukun Judio kami run mawali ang Mayad nga Barita. ");
INSERT INTO clu_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Tungud nga maman dia anang sogo ang Ginoo kanamun ay may nasolat nga nagakoon: ‘Ginimo ko ikaw nga solo nga magataw kasanag sa mga bukun Judio, agud paagi kanimo ang kalowasan mapalapnag sa bilog nga kalibotan.’” ");
INSERT INTO clu_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Pagkabati dato ang mga bukun Judio nalipay sanda kag nagdayaw sanda sa anang ambal ang Ginoo. Kag ang tanan nga mga ginpili para sa kaboi nga ara kataposan naging tomoloo. ");
INSERT INTO clu_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Gani naglapnag anang ambal ang Ginoo sa logar nga dato. ");
INSERT INTO clu_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Garing ginsolsolan ang mga Judio ang mga nagadomara sa siodad pati ang mga riliyoso kag ginakilala nga mga babai nga kontraun sanday Pablo. Gani giningabot nanda si Pablo kag si Bernabe kag ginpalayas nanda sa andang logar nga dato. ");
INSERT INTO clu_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Anang ginimo ni Pablo kag ni Bernabe, gintapokan nanda ang yabok andang mga siki bilang tanda nga ara sanda run sarabatun kon silotan ang Dios ang mga tao doto. Kag nagayan sanda dayon sa Iconio. ");
INSERT INTO clu_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Doto tana sa Antioquia ang mga nagasonod kay Jesus nga nagkarabilin ginagauman ang Ispirito Santo, kag malipayun sanda gid. ");
INSERT INTO clu_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ang natabo sa Iconio pario ra ang natabo sa Antioquia: si Pablo kag si Bernabe nagayan sa anang simbaan ang mga Judio kag tungud sa andang pagwali doro nga mga Judio kag mga bukun Judio ang nagtoo kay Jesus. ");
INSERT INTO clu_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Piro ang mga Judio nga ara nagtoo, ginpalain nanda anang buut ang mga bukun Judio sa mga tomoloo, kag ginsolsolan nanda pa nga kontraun sanda. ");
INSERT INTO clu_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Maboay ra anang tinir doto ni Pablo kag ni Bernabe. Kag ara sanda ginaadluki magambal parti sa Ginoo. Ginpakita ang Ginoo nga matood andang ginatodlo parti sa anang kalooy, ay gintawan na sanda gaum nga magimo mga milagro kag mga katiringalaan. ");
INSERT INTO clu_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Gani, ang mga tao doto sa siodad nga dato natunga; ang iba nagkampi sa mga Judio nga ara nagatoo, kag ang iba tana nagkampi sa mga apostolis. ");
INSERT INTO clu_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Karon, ang mga Judio kag andang mga manogdomara, pati ang mga bukun Judio, nagplano nga sakitun nanda kag pasilun ang mga apostolis. ");
INSERT INTO clu_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Pagkaulam ang mga apostolis nga toladato ang plano kananda nagpalagyaw sanda sa Listra kag sa Derbe, nga mga siodad nga sakup ang Licaonia, kag sa palibot nga logar. ");
INSERT INTO clu_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Kag ginwali nanda doto ang Mayad nga Barita. ");
INSERT INTO clu_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Doto sa Listra may sangka tao nga indi kapanaw ay lopog tana alin pa anang pagkabata. ");
INSERT INTO clu_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Mintras nagapongko tana doto nagpamati tana sa anang mga ginaambal ni Pablo. Ginsulung tana nga mayad ni Pablo kag nakita na nga may pagtoo tana nga ang Ginoo makaayad kanana. ");
INSERT INTO clu_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Gani sa mabaskug nga limug makon ni Pablo kanana, “Pagtindug tadlung!” Naggolpi ra tindug ang tao nga dato kag nagpanaw-panaw. ");
INSERT INTO clu_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Pagkakita ang mga tao sa anang ginimo ni Pablo, nagsiringgit sanda sa Licaonia nga ambal, makon nanda, “Ang mga dios nagpapario sa tao kag naglosong digi kanatun!” ");
INSERT INTO clu_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Gintawag nanda si Bernabe nga andang dios nga si Zeus, kag si Pablo tana andang dios nga si Hermes tungud nga tana maman ang manogambal. ");
INSERT INTO clu_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Anang timplo andang dios nga si Zeus marapit lang sa goa ang siodad. Gani anang pari ni Zeus nagdara mga baka nga may kolintas nga bolak doto sa poirtaan ang siodad. Gosto na kag gosto ra ang mga tao nga ialad dato sa mga apostolis. ");
INSERT INTO clu_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Pagkaulam ni Bernabe kag ni Pablo kon ano andang toyo nga imoon, ginisi nanda andang mga lambong tungud nga para kananda marimo gid anang ginaimo ang mga tao. Nagdalagan sanda sa tunga ang mga tao kag nagsinggit nga nagakoon, ");
INSERT INTO clu_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Mga amigo, basi maalad kamo kanamun? Kami mga tao ra lang nga pario kanindo. Ginawali namun kanindo ang Mayad nga Barita agud bayaan nindo ron ang mga ara polos nga dia nga mga butang kag magparapit sa Dios nga boi. Tana maman ang nagimo ang langit, ang logta, ang dagat, kag ang tanan nga mga butang sa mga logar nga dia. ");
INSERT INTO clu_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ang ona ginpabayanan lang ang Dios ang mga tao nga sonodon andang gosto. ");
INSERT INTO clu_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Piro sa tanan nga oras ginapakilala ang Dios anang kaogalingun sa mga tao paagi sa anang mga ginaimo nga mayad. Ginatawan na kamo oran kag mga patubas pagabot ang tigarani; abonda nga pagkaun anang ginataw kanindo agud malipay kamo.” ");
INSERT INTO clu_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Piro bisan toladato anang ginaambal ang mga apostolis, nalisudan sanda pa ra gid magpigar sa mga tao nga magpatay andang mga baka agud ialad kananda. ");
INSERT INTO clu_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Karon, may nagabot nga mga Judio nga alin sa Antioquia nga sa Pisidia kag sa Iconio. Ginkombinsi nanda ang mga tao nga magkampi kananda. Ginboroligan nanda pasil si Pablo kag gingoyod dayon sa goa ang banwa, ay andang pagsarig patay tana run. ");
INSERT INTO clu_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Piro pagtiripon ang mga tomoloo doto sa anang palibot, nagbangon tana kag magbalik sa banwa. Ang madason nga adlaw nagayan sanda nga darwa ni Bernabe sa Derbe. ");
INSERT INTO clu_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Ginwali ni Pablo kag ni Bernabe ang Mayad nga Barita doto sa Derbe kag doro andang nadara nga maging somolonod ni Jesu-Cristo. Pagkatapos nagbalik sanda ruman sa Listra, sa Iconio, kag sa Antioquia nga sa Pisidia. ");
INSERT INTO clu_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ginparigun nanda ang mga tomoloo kag ginlaygayan nga magpadayon gid sa andang pagtoo. Makon nanda pa sa mga tomoloo, “Doro nga mga kalisud atun kinanglan nga maagian anay bago kita makasulud sa anang ginarian ang Dios.” ");
INSERT INTO clu_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Sa kada logar nga may mga tomoloo nga nagatiripon, nagpili sanda mga maulam-ulam nga magadomara kananda. Nagpoasa sanda kag nagpangamoyo para sa mga napili kag gintogyan nanda dayon sa Ginoo nga andang ginatooan. ");
INSERT INTO clu_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pagkatapos nagagi sanda sa mga logar nga sakup ang probinsya ang Pisidia kag nagabot sanda sa Panfilia. ");
INSERT INTO clu_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Nagwali sanda doto sa Perga kag naglusub sanda dayon sa Atalia. ");
INSERT INTO clu_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Alin doto nagsakay sanda pabalik sa Antioquia. Maman dia ang logar nga andang ginalinan, kag digi ra sanda ginpangamoyo ang mga tomoloo nga kaloyan sanda ra gid ang Dios sa andang irimoon nga dadi natapos nanda run. ");
INSERT INTO clu_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Pagabot ni Pablo kag ni Bernabe sa Antioquia gintipon nanda ang tanan nga mga tomoloo kag ginsogid nanda dayon ang tanan nga anang ginimo ang Dios paagi kananda, kag kon paiwan nga ang Dios nagtaw kaigayonan agud makatoo ra ang mga bukun Judio. ");
INSERT INTO clu_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Kag maboay anang tinir ni Pablo kag ni Bernabe doto sa mga tomoloo sa Antioquia. ");
INSERT INTO clu_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Karon, may mga tao alin sa probinsya ang Judea nga nagarayan sa Antioquia kag nagtodlo sa mga tomoloo doto nga sanda nga mga bukun Judio indi kono malowas kon indi sanda magpatori sono sa ginatodlo anang Kasogoan ni Moises. ");
INSERT INTO clu_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Piro ginkontra sanda nga mayad ni Pablo kag ni Bernabe kag naging mainit andang pagdiriskosyon. Gani nagkarasogot ang mga tomoloo doto nga si Pablo kag si Bernabe kag ang iba pa nga mga tomoloo sa Antioquia magarayan sa Jerusalem agud magpakigkita sa mga apostolis kag sa mga maulam-ulam doto parti sa butang nga dia. ");
INSERT INTO clu_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Kag ginpapanaw nanda dayon sanday Pablo. Mintras nagaagi sanda sa Fenicia kag sa Samaria, ginabarita nanda sa mga tomoloo doto nga may mga bukun Judio nga nagtoo ron da kay Cristo. Kag pagkabati nanda dato, nalipay sanda nga mayad. ");
INSERT INTO clu_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Pagabot nanday Pablo sa Jerusalem ginbaton sanda ang mga apostolis, mga maulam-ulam, kag tanan nga mga tomoloo doto. Kag ginsaysay nanday Pablo ang tanan nga ginimo ang Dios paagi kananda. ");
INSERT INTO clu_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Karon, may mga tomoloo doto nga mga mimbro anang gropo ang mga Pariseo. Nagtindug sanda kag magkoon, “Kinanglan toriun ang mga bukun Judio kag konon sanda nga magtoman sa Kasogoan ni Moises.” ");
INSERT INTO clu_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Gani nagmiting ang mga apostolis kag ang mga maulam-ulam agud ambalan ang butang nga dato. ");
INSERT INTO clu_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Malawig andang diriskosyon. Ang ori nagtindug si Pedro kag nagkoon, “Mga kabogto, naulaman nindo ra nga ako ginpili ang Dios alin kanindo ang ona pa agud itodlo ko ang Mayad nga Barita sa mga bukun Judio, agud makabati sanda ra kag magtoo. ");
INSERT INTO clu_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Naulaman ang Dios kon ano ang sa tagiposoon ang mga tao. Kag ginpakita na nga ginabaton na ra ang mga bukun Judio tungud nga gintaw na ra ang Ispirito Santo kananda pario anang ginimo kanatun ang ona. ");
INSERT INTO clu_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Sa panulung ang Dios, kita nga mga Judio kag sanda nga bukun Judio pario lang. Ay ginlimpyoan na ra andang mga tagiposoon sa andang mga sala tungud nga nagtoo sanda. ");
INSERT INTO clu_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ta basi ginapaugut nindo ang Dios? Basi gosto nindo nga pasonodon atun kapario nga mga tomoloo ang mga soronodon nga bisan gani atun mga kaolang-olangan pati kita ara ra kasonod? ");
INSERT INTO clu_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Kabay nagapati kita nga anang kalowasan ang mga bukun Judio pario ra ang kanatun nga mga Judio. Malowas sanda ra paagi lang gid sa anang kalooy ni Ginoong Jesu-Cristo.” ");
INSERT INTO clu_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Pagkabati nanda dato nagiripus sanda tanan. Kag ginpamatian nanda dayon anang ginsaysay ni Bernabe kag ni Pablo parti sa mga katiringalaan kag mga milagro nga ginimo ang Dios sa mga bukun Judio paagi kananda. ");
INSERT INTO clu_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Pagkatapos nanda ambal, si Santiago ruman ang nagambal. Makon na, “Mga kabogto, pamatii nindo ako. ");
INSERT INTO clu_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Ginsaysay kanatun ni Simon Pedro ang primiro nga pagtawag ang Dios sa mga bukun Judio agud may mga tao ra nga alin kananda nga maging ana. ");
INSERT INTO clu_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Kag dia sono ra sa anang mga ginsolat ang mga propita ang ona, ay makon sa Kasolatan, ");
INSERT INTO clu_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Pagkatapos dia magabalik ako, Kag patindugun ko roman anang ginarian ni David nga nagbagsak. Pabangonon ko roman sa anang pagkarompag, ");
INSERT INTO clu_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Agud ang ibang mga tao makapangita kanakun, ang tanan nga bukun Judio nga akun gintawag nga maging akun. ");
INSERT INTO clu_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Maman dia anang koon ang Ginoo, kag maboay na run dia ginpaulam.’” ");
INSERT INTO clu_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Gani,” makon ni Santiago, “kon sa kanakun indi ta run pagpabudlayan ang mga bukun Judio nga nagtoo sa Dios. ");
INSERT INTO clu_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Atun imoon, solatan ta sanda nga indi magkaun ang mga pagkaun nga ginalad sa mga ribolto tungud nga marimo dato sa atun panulung. Konon ta sanda ra nga dapat indi sanda magolid sa bukun andang asawa. Indi sanda ra dapat magkaun ang dogo okon anang karni ang sapat nga anang dogo ara kagoa. ");
INSERT INTO clu_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Maman lang dia anang mga sogo ni Moises nga dapat sonodon nanda agud indi marimoan ang mga Judio kananda, tungud nga alin pa ang ona ginabasa ang mga Judio kada Adlaw nga Inogpaway sa andang mga simbaan ang nasolat nga Kasogoan nga ginsala ni Moises. Kag dia ginatodlo nanda sa kada banwa.” ");
INSERT INTO clu_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Kag nagkarasogot dayon ang mga apostolis kag ang mga maulam-ulam kag ang tanan nga mga tomoloo doto nga sanda mapili mga lalaki sa andang gropo nga andang patawasun kay Pablo kag kay Bernabe sa Antioquia. Si Judas nga kon tawagun Barsabas kag si Silas maman andang napili. Dia nga mga tao ginataod ang mga tomoloo. ");
INSERT INTO clu_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ang solat nga ginpadara kananda nagakoon: “Kami nga mga apostolis kag mga maulam-ulam digi nga indong mga kabogto kay Cristo nagapangomosta kanindo nga mga bukun Judio nga dian sa Antioquia, Siria, kag Cilicia. ");
INSERT INTO clu_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Nakabati kami nga may mga tao nga alin digi kanamun nga nagayan dian kanindo kag gingolo nanda indong mga isip tungud sa andang mga gintodlo dian. Ara kami nagsogo kananda nga magayan dian kag magtodlo toladato. ");
INSERT INTO clu_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Gani pagkabati namun dato nagtiripon kami digi kag nagkarasogot kami nga magpili ang mga tao nga amun ipadara dian agud isaysay kanindo amun ginkasogtanan. Kaiban sanda ni Pablo kag ni Bernabe nga atun mga pinalangga nga mga kabogto kay Cristo. ");
INSERT INTO clu_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Si Bernabe nga dia kag si Pablo nagtaya andang kaboi sa pagsirbi sa atun Ginoong Jesu-Cristo. ");
INSERT INTO clu_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Si Judas kag si Silas nga amun ginapadara kanindo magasogid ra ang parti sa mga butang nga nasambit digi sa amun solat nga dia. ");
INSERT INTO clu_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Nagkarasogot kami sono sa toytoy ang Ispirito Santo nga indi run pagdogangan indong mga soronodon loas sa mga masonod nga kinanglan gid nga tomanun nindo. ");
INSERT INTO clu_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Indi kamo magkaun ang mga pagkaun nga ginalad sa mga ribolto; indi kamo magkaun ang dogo kag mga karni nga anang dogo ara kagoa; kag indi kamo magolid sa bukun indong asawa. Mayad kon likawan nindo ang mga butang nga dia. Asta digi run lang.” ");
INSERT INTO clu_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Kag nagpanaw dayon ang mga tao nga andang ginpadara. Pagabot nanda doto sa Antioquia gintipon nanda ang tanan nga mga tomoloo kag gintaw nanda dayon ang solat. ");
INSERT INTO clu_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Pagkabasa ang mga tomoloo sa mga pagpabaskug kananda, nalipay sanda nga mayad. ");
INSERT INTO clu_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Si Judas kag si Silas mga propita ra, kag doro andang mga gintodlo sa mga tomoloo agud pabaskugun sanda kag parigunun pa gid andang pagtoo. ");
INSERT INTO clu_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","May mga pira ra ka adlaw andang tinir doto. Pagkatapos nagbalik sanda sa Jerusalem sa mga nagpadara kananda. Piro bago sanda magpanaw ginpangamoyo sanda ang mga tomoloo nga maging mayad ra gid andang pagparanawon. ");
INSERT INTO clu_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Piro si Silas tana nagdisisyon nga magpasala doto. ");
INSERT INTO clu_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Maboay-boay ra anang tinir ni Pablo kag ni Bernabe doto sa Antioquia. Doro andang kaiban nga nagpanodlo kag nagwali anang ambal ang Ginoo. ");
INSERT INTO clu_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ang ori makon ni Pablo kay Bernabe, “Ta, mabalik kita sa tanan nga mga banwa nga atun ginwalian anang ambal ang Ginoo kag bistaan ta ang mga tomoloo agud maulaman ta kon paiwan andang kaimtangan.” ");
INSERT INTO clu_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Kompormi si Bernabe piro gosto na nga daraun si Juan nga ginatawag nga Marcos. ");
INSERT INTO clu_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Si Pablo tana indi maliag tungud nga ang ona naging kaiban nanda si Marcos nga dia, garing ang ori ara tana run nagbolig kananda kondi ginbayaan na sanda doto sa Panfilia. ");
INSERT INTO clu_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Naginit andang diskosyon, gani nagbulagan sanda. Gindara ni Bernabe si Marcos kag nagsakay sanda sa sakayan nga pa-Cipre. ");
INSERT INTO clu_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Si Pablo tana, si Silas anang gindara. Bago sanda magalin ginpangamoyo ang mga tomoloo sa Ginoo nga boligan na ang darwa nga dia sa andang pagpanaw. ");
INSERT INTO clu_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ginalid nanda anang probinsya ang Siria kag Cilicia. Ginayanan nanda ang mga tomoloo sa andang ginatiriponan kag ginpabaskug nanda andang pagtoo. ");
INSERT INTO clu_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Nagpadayon sanday Pablo asta sa Derbe kag sa Listra. Karon may tomoloo doto sa Listra nga si Timoteo. Anang nanay Judio kag tomoloo ra, piro anang tatay Griego. ");
INSERT INTO clu_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Sono sa mga tomoloo doto sa Listra kag Iconio, si Timoteo nga dia mayad nga tao. ");
INSERT INTO clu_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Gosto ni Pablo nga daraun si Timoteo, gani gintori na tana agud ara riklamo ang mga Judio kontra kay Timoteo, ay ang tanan nga mga Judio nga nagaoli sa logar nga dato nakaulam nga Griego anang tatay ni Timoteo. ");
INSERT INTO clu_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Pagkatapos nagayan sanda dayon sa mga banwa kag ginsaysay nanda sa mga tomoloo ang mga soronodon nga ginkarasogotan ang mga apostolis kag mga maulam-ulam doto sa Jerusalem. Ginkonan nanda ang mga tomoloo nga kinanglan tomanun nanda ang mga soronodon nga dato. ");
INSERT INTO clu_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Gani nagrigun pa gid anang pagtoo ang mga tomoloo, kag adlaw-adlaw nagdogang pa gid ang mga nagatoo. ");
INSERT INTO clu_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pagkatapos, nagayan sanda dayon sa mga logar nga sakup ang Frigia kag Galacia. Ay ara sanda pagtogoti ang Ispirito Santo nga magwali anang ambal ang Dios doto sa probinsya ang Asia. ");
INSERT INTO clu_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Pagabot nanda sa dolonan ang Misia, gosto nanda andan nga magayan sa probinsya ang Bitinia, piro ara sanda ruman pagtogoti anang Ispirito ni Jesus. ");
INSERT INTO clu_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Gani andang ginimo, nagagi sanda run lang sa probinsya ang Misia kag naglusub sa banwa ang Troas. ");
INSERT INTO clu_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ang gabi nga dato may ginpakita ang Dios kay Pablo. Nakita na ang sangka tao nga taga-Macedonia nga nagatindug kag nagapakitloy kanana, makon na, “Pagtabok ra digi sa Macedonia kag boligi kami.” ");
INSERT INTO clu_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Gani lagi-lagi nagimus kami agud magayan sa Macedonia, tungud nga naisip namun nga ginatawag kami ang Dios nga magwali ang Mayad nga Barita sa mga tao sa Macedonia. ");
INSERT INTO clu_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Nagsakay kami sa sakayan alin sa Troas kag nagdiritso sa isla ang Samotracia, kag ang masonod nga adlaw nagabot kami doto sa banwa ang Neapolis. ");
INSERT INTO clu_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Alin sa Neapolis nagtakas kami sa Filipos. Ang Filipos nga dia maman ang pinakaimportanti nga siodad sa logar nga dato ang Macedonia. Kadoroan sa mga nagaoli doto pati andang mga manogdomara taga-Roma. Nagtinir kami sa Filipos pira ka adlaw. ");
INSERT INTO clu_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Pagabot ang Adlaw nga Inogpaway, naggoa kami sa siodad kag nagayan sa binit ang soba tungud nga amun pagsarig may logar doto nga ginatiriponan ang mga Judio agud magpangamoyo. May mga babai doto nga nagtiripon, gani nagpongko kami kag magpakigsogidanun kananda. ");
INSERT INTO clu_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Isara sa mga nagapamati kanamun si Lydia nga taga-Tiatira. Nigosyanti tana ang maraalun nga mga tila nga granati, kag nagasimba ra sa Dios. Gintandug ang Ginoo anang tagiposoon nga batonon anang mga ginaambal ni Pablo. ");
INSERT INTO clu_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Nagpabunyag tana kag ang tanan nga nagaoli doto sa anang balay. Pagkatapos ginimbitar na kami sa anang balay. Makon na, “Kon kamo nagapati nga ako matood ron nga tomoloo sa Ginoo, abi doto kamo pagdayon sa balay.” Kag napiritan kami. ");
INSERT INTO clu_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","May sangka adlaw ang kami nagapaayan sa logar nga ginatiriponan agud magpangamoyo, ginsolang-solang kami ang sangka oripun nga dalagita. Dato nga dalagita ginagauman ang malain nga ispirito nga nagataw kanana abilidad nga magpinto ang mga matatabo sa paraaboton. Kag paagi sa anang abilidad nga dato nakokoartaan tana nga mayad anang mga agalun. ");
INSERT INTO clu_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Karon nagsari run sonod-sonod kanamun ni Pablo ang babai nga dato, kag sigi anang singgit, makon na, “Dia nga mga tao anang mga sorogoon ang Dios nga Makagagaum! Ginawali nanda kanindo kon paiwan kamo malowas!” ");
INSERT INTO clu_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Adlaw-adlaw maman dato anang ginaimo asta ginugutan si Pablo. Gani binalikid na ang babai nga dato kag magkoon sa malain nga ispirito nga nagaoli kanana, makon na, “Sa aran ni Jesu-Cristo ginamandaran ko ikaw nga maggoa sa babai nga dan!” Kag lagi-lagi naggoa kanana ang malain nga ispirito. ");
INSERT INTO clu_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Pagkakita anang mga agalun nga ara sanda run paglaum nga makakita pa koarta paagi kanana, gindakup nanda si Pablo kag si Silas kag gingoyod sa plasa sa mga manogdomara ang logar nga dato. ");
INSERT INTO clu_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Makon nanda sa mga manogdomara, “Dia nga mga tao mga Judio kag nagagamo digi sa atun siodad. ");
INSERT INTO clu_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Nagatodlo sanda mga pagogali nga kontra sa atun kasogoan. Mga Romano kita, gani indi kita makasonod andang mga ginatodlo!” ");
INSERT INTO clu_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Kag ang mga tao doto nagborolig run da tigbak kanday Pablo. Pagkatapos ginpabukras ang mga opisyalis anang mga lambong ni Pablo kag ni Silas kag ginpaanot dayon. ");
INSERT INTO clu_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Datong naanot sanda run nga mayad, ginsulud sanda dayon sa prisoan. Ginbilinan nanda ang goardya doto nga bantayan sanda gid nga mayad. ");
INSERT INTO clu_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Gani ginsulud sanda ang bantay sa sulud gid nga koarto kag gingapos andang mga siki. ");
INSERT INTO clu_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Karon, datong mga tungang gabi run, si Pablo kag si Silas nagapangamoyo kag nagakanta ang mga pagdayaw sa Dios. Andang mga kaiban nga mga priso nagapamati kananda. ");
INSERT INTO clu_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Lagat-lagat golpi lang nga naglinog mabaskug kag naguyug nga mayad ang prisoan. Nagkaraabrian anang mga poirtaan ang prisoan kag nagkaraukas anang mga kadina ang tanan nga priso. ");
INSERT INTO clu_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Nagbongkaras ang goardya, kag pagkakita na nga bokas run anang mga poirtaan ang prisoan, anang kaisip nakapalagyaw ron ang tanan nga priso. Gani ginabot na anang ispada agud magpanginmatay. ");
INSERT INTO clu_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Piro nagsinggit si Pablo, makon na, “Indi kaw magpanginmatay! Dagi kami tanan!” ");
INSERT INTO clu_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Nagpabuul solo ang goardya kag nagdali-dali tana sulud doto kag naglood sa anang atobangan nanday Pablo kag Silas nga nagakurudug. ");
INSERT INTO clu_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Pagkatapos, gindara na sanday Pablo sa goa kag nagpamangkot, makon na, “Ano akun imoon agud malowas ako?” ");
INSERT INTO clu_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Nagsabat sanday Pablo, makon nanda, “Magtoo kaw kay Ginoong Jesus kag malowas kaw kag imong pamilya.” ");
INSERT INTO clu_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Kag gintodlo dayon nanday Pablo anang ambal ang Dios kanana kag sa tanan nga doto sa anang balay. ");
INSERT INTO clu_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ang gabi ra gid nga dato ginogasan ang goardya andang mga igad, kag nagpabunyag tana nga lagi pati anang bilog nga pamilya. ");
INSERT INTO clu_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Pagkatapos gindara na sanday Pablo sa anang balay kag ginpakaun. Ang goardya kag anang bilog nga pamilya nalipay nga mayad nga sanda nagatoo ron sa Dios. ");
INSERT INTO clu_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Pagkaaga nagsogo ang mga opisyalis sa mga polis nga pamolyawan run sanday Pablo. ");
INSERT INTO clu_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Kag dia ginbarita ang goardya kay Pablo, makon na, “Ang mga opisyalis nagpasogo nga bolyawan kamo ron. Gani paggoa kamo ron kag mayad lang nga pagpanaw.” ");
INSERT INTO clu_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Piro makon ni Pablo sa mga polis nga ginsogo, “Indi maimo nga kami basta maggoa lang, tungud nga kami mga pomoloyo ra ang Roma. Ginlapas nanda ang kasogoan ang Roma tungud nga ara nanda anay kami pagimbistigara kondi ginpaanot nanda kami sa pobliko kag pagkatapos ginsulud nanda kami dayon sa prisoan. Piro dadi gosto nanda nga ipus-ipusan lang ang pagpagoa kanamun? Indi maimo! Kinanglan ang mga opisyalis mismo ang magayan digi kag sanda gid ang magpagoa kanamun.” ");
INSERT INTO clu_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Pagkasogid ang mga polis sa mga opisyalis anang ambal ni Pablo nga sanda mga pomoloyo ra nga sakup ang Roma, kinulbaan sanda. ");
INSERT INTO clu_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Gani nagayan ang mga opisyalis sa prisoan kag nagpangayo pasinsya kanday Pablo. Pagkatapos ginpagoa nanda dayon sanday Pablo kag ginpangabay nga magalin sanda doto sa siodad. ");
INSERT INTO clu_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Pagkagoa ni Pablo kag ni Silas doto sa prisoan, nagayan sanda dayon sa anang balay ni Lydia. Nagpakigkita sanda doto sa mga tomoloo, kag ginlaygayan nanda agud pabaskugun andang pagtoo. Pagkatapos nagpanaw sanda dayon. ");
INSERT INTO clu_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Nagagi sanda sa Anfipolis kag sa Apolonia asta nakaabot sanda sa Tesalonica. Doto sa Tesalonica may simbaan ang mga Judio. ");
INSERT INTO clu_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Kag pario anang ginaimo pirmi ni Pablo, nagsulud tana sa andang simbaan kag sa sulud tatlo ka Adlaw nga Inogpaway nagpakigdiskosyon tana sa mga tao doto. Ang Kasolatan maman anang ginamit ");
INSERT INTO clu_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","agud pamatodan kananda nga ang Cristo kinanglan gid nga magantos kag pagkatapos kinanglan ra nga mabanaw alin sa mga minatay. Makon pa ni Pablo, “Ang Jesus nga dia nga akun ginasogid kanindo maman mismo ang Cristo.” ");
INSERT INTO clu_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ang iba kananda nagpati sa anang ambal ni Pablo, kag nagsonod sanda kay Pablo kag kay Silas. Doro ra nga mga Griego nga nagasirimba sa Dios kag mga kilala nga mga babai ang nagirug kananda. ");
INSERT INTO clu_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Karon, nainggit ang mga Judio. Gani andang ginimo, gintipon nanda ang mga orong nga mga istambay kag datong doro ron andang natipon ginpagolo nanda ang mga tao sa bilog nga siodad. Nagdaragoyon sanda paayan sa anang balay ni Jason ay ginapangita nanda si Pablo kag si Silas tungud nga gosto nanda nga pasabatun sa pobliko mismo. ");
INSERT INTO clu_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Piro datong indi nanda makita si Pablo kag si Silas, dinakup nanda si Jason kag ang iba pa nga mga tomoloo kag gingoyod nanda sanda dayon sa mga opisyalis ang siodad. Sa andang kasilag kanday Pablo nagsiringgit sanda nga nagakoon, “Ang mga tao nga dato nagadara gamo bisan diin sanda magayan tungud sa andang mga ginatodlo. Kag dadi digi sanda run sa atun siodad. ");
INSERT INTO clu_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Ginpadayon sanda pa ni Jason sa anang balay. Dia sanda nga tanan nagakontra sa anang mga kasogoan ang Impirador tungud nga nagakoon sanda nga may ari pa gid nga anang aran si Jesus.” ");
INSERT INTO clu_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Pagkabati dato ang mga tao kag ang mga opisyalis, nagkinagolo sanda. ");
INSERT INTO clu_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Kag bago nanda bolyawan si Jason kag anang mga kaiban, ginpabayad sanda anay ang piansa. ");
INSERT INTO clu_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Pagkagabi ginpadara ang mga tomoloo si Pablo kag si Silas doto sa Berea. Pagabot nanda doto nagayan sanda sa anang simbaan ang mga Judio. ");
INSERT INTO clu_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Sa Berea tana ang mga Judio mas bokas andang isip kay sa mga taga-Tesalonica. Doro anang kaliag ang mga taga-Berea nga magpamati anang ginatodlo nanday Pablo. Kag adlaw-adlaw sigi andang osisa ang Kasolatan agud sulungun kon matood manda andang mga ginaambal. ");
INSERT INTO clu_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Doro kananda ang nagtoo pati ang mga kilala nga mga babai kag mga lalaki nga taga-Grecia. ");
INSERT INTO clu_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Piro pagkabati ang mga Judio sa Tesalonica nga si Pablo nagwali ra anang ambal ang Dios doto sa Berea, nagayan sanda ra doto kag ginsolsolan nanda ruman ang mga tao nga magpanggolo. ");
INSERT INTO clu_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Gani lagi-lagi ginpaatud ang mga tomoloo si Pablo doto sa baybay. Piro si Silas tana kag si Timoteo nagpasala sa Berea. ");
INSERT INTO clu_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Ang mga tao nga nagatud kay Pablo nagtabid kanana asta sa Atenas. Pagkatapos, nagbalik sanda dayon sa Berea nga may bilin alin kay Pablo nga si Silas kag si Timoteo magsonod nga lagi kanana sa Atenas. ");
INSERT INTO clu_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Mintras nagaulat si Pablo kay Silas kag kay Timoteo doto sa Atenas, nakita na nga masyado ka raku doto andang mga ribolto nga dios-dios. Kag dato nakataw kasubu kanana. ");
INSERT INTO clu_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Gani nagsulud tana sa anang simbaan ang mga Judio kag magpakigdiskosyon kananda kag sa mga bukun Judio nga nagasimba ra sa Dios. Adlaw-adlaw doto tana ra sa plasa nga nagapakigdiskosyon sa mga tao nga anang mabagat. ");
INSERT INTO clu_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Darwa ka klasi nga mga manogtodlo ang nagpakigdiskosyon kay Pablo. Ang isara ko