﻿USE sofia;
DROP TABLE IF EXISTS sofia.cko_vpl;
CREATE TABLE cko_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cko_vpl WRITE;
INSERT INTO cko_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ahin duma kɛrɛɛ­wam kɛrɛ ti Yesu Kristo nam busu wɔ, fiteeri Abraham kɔ tu Fɛmɛ Davidi fa ba juuri saŋga bo bu wuuri yiri Yesu ni. I nam n busu yaa ni, ");
INSERT INTO cko_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham wuuri Izaki, na Izaki awu Jakɔbu, na Jakɔbu awu Yuda ni i niɛmam, ");
INSERT INTO cko_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","na Yuda awu Farɛsɛ ni Zara bo bu ni yo la Tama ni, na Farɛsɛ awu Hɛsarom, na Hɛsarom awu Aram, ");
INSERT INTO cko_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","na Aram awu Aminadabu, na Aminadabu awu Naasoni, na Naasoni awu Salɛmɔ, ");
INSERT INTO cko_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","na Salɛmɔ awu Boosi bo i ni yo la Rahabu ni, na Boosi gusu awu Yobedi bo i ni yo la Ruti ni, na Yobedi gusu anya awu Yese ");
INSERT INTO cko_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","bo i gusu wuuri Fɛmɛ Davidi ni. Tɔ, na Fɛmɛ Davidi awu Fɛmɛ Solomon bo i ni yo la Yuriya yi ni, ");
INSERT INTO cko_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","na Fɛmɛ Solomon gusu awu Fɛmɛ Robowam, na Fɛmɛ Robowam awu Fɛmɛ Abiya, na Fɛmɛ Abiya awu Fɛmɛ Asafu, ");
INSERT INTO cko_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","na Fɛmɛ Asafu awu Fɛmɛ Yosafati, na Fɛmɛ Yosafati awu Fɛmɛ Yoram, na Fɛmɛ Yoram awu Fɛmɛ Yoziya, ");
INSERT INTO cko_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","na Fɛmɛ Yoziya awu Fɛmɛ Yowatam, na Fɛmɛ Yowatam awu Fɛmɛ Ahazi, na Fɛmɛ Ahazi awu Fɛmɛ Hɛzɛkiya, ");
INSERT INTO cko_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","na Fɛmɛ Hɛzɛkiya awu Fɛmɛ Manase, na Fɛmɛ Manase awu Fɛmɛ Amoni, na Fɛmɛ Amoni awu Fɛmɛ Yosiya, ");
INSERT INTO cko_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","na Fɛmɛ Yosiya awu Fɛmɛ Yɛkoniya ni i niɛmam. Nyini saŋga n ye bu miɛɛri Yisareli­fɔm fiteeri bu asiɛn su kɔɔri Babilɔniya asiɛn su n a. ");
INSERT INTO cko_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Bu faari bu kɔɔri Babilɔniya n dɛɛ n sin ni, na Fɛmɛ Yɛkoniya awu Salatiyeli, na Salatiyeli awu Zorobabɛli, ");
INSERT INTO cko_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","na Zorobabɛli awu Abiyidu, na Abiyidu awu Eliyakimu, na Eliyakimu awu Azore, ");
INSERT INTO cko_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","na Azore awu Sadoki, na Sadoki awu Akim, na Akim awu Eliyudu, ");
INSERT INTO cko_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","na Eliyudu awu Eleyaza, na Eleyaza awu Matan, na Matan awu Jakɔbu nyiŋga bekun, ");
INSERT INTO cko_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","na nyini Jakɔbu n awu Yosefu, Mariya hun. Mariya wuuri Yesu bo bu fere i ka Kristo n a, Tii­de­fɔ n bo Nyɛmɛ ase ka i súnma i ni. ");
INSERT INTO cko_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Tɔ, nyini kere ka fiteeri Abraham fa ba juuri Fɛmɛ Davidi, bu tiiri nanam buru ni nna wɔ, na fiteeri Fɛmɛ Davidi fa ba juuri saŋga bo bu miɛɛri Yisareli­fɔm kɔɔri Babilɔniya asiɛn n su ni, bu tiiri nanam buru ni nna wɔ, na fiteeri nyini saŋga n fa ba juuri saŋga bo bu wuuri Kristo Tii­de­fɔ ni, bu gusu tiiri nanam buru ni nna wɔ. ");
INSERT INTO cko_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Kabo bu wuuri Yesu Kristo n yaa. Bu yo faari i ni Mariya ceeri Yosefu wɔ, ama, kana bu ba ja i kɔ i hun n dika ni, na ba fa nu ka i bita nyinsɛ bo i fite Nyɛmɛ Awiɛwiɛ Casi n dɛɛ yiko nu wɔ. ");
INSERT INTO cko_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","I hun Yosefu yo ti sɔnɔ bo i yo sa bo i kɔ atin su Nyɛmɛ dɔ ɔ, nyini ti, wɔ koro má ka i wura i yi n nyinsɛ jama nu, na wɔ fa sunsunni ka i yaki i asiri nu. ");
INSERT INTO cko_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Saŋga bo i wo birisi su n sɔ ni, na Micɛra n dɛɛ mɛrɛkɛ aba i dɔ alɛlɛ nu, aba ase i ka, “Fɛmɛ Davidi anuma Yosefu, má a soro sɛrɛ ka a ja Mariya, na a fa i kɔ u dika, dama Nyɛmɛ Awiɛwiɛ Casi ni maari i nyinsɛ n a. ");
INSERT INTO cko_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","I wú baa­biɛsɔ na a fere i ka Yesu, i bu la ka Tii­de­fɔ, dama yiri bá yi i minɛm fite bu satiɛm nu a.” ");
INSERT INTO cko_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Tɔ, nyini n kɛrɛ yoori sɔ, adena i ma Nyɛmɛ nɔaniɛ kan­fɔ n nɔaniɛ n bá yo yii­wa, kabo wɔ jɔjɔ ka, ");
INSERT INTO cko_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Suŋguru bo wɔ nya si má biɛsɔ bá nyinsɛ, na i wú baa­biɛsɔ, na bu fére i ka Emanuwɛli,” i bu la ka, Nyɛmɛ wo ya dɔ. ");
INSERT INTO cko_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Saŋga bo Yosefu teŋgeeri ni, na wɔ yo kabo Micɛra n dɛɛ mɛrɛkɛ n seeri i ni, na wɔ fa Mariya aba i dika. ");
INSERT INTO cko_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ama, i ni yiri asaŋga má bara ni biɛsɔ, haari Mariya ba wuuri baa­biɛsɔ, na Yosefu atun i duma ka Yesu. ");
INSERT INTO cko_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Saŋga bo bu wuuri Yesu miɛ n bo bu fere i ka Bɛtilɛhɛm na i wo Yudiya awɔrɛ n nu ni, nyini saŋga ni Herode ti nyini awɔrɛ n nu fɛmɛ a. Na asara­mbaa kɔrɛsi­yi­fɔm nbem afite wiɛ afiiri, aba Yɛrusalem aba abisa ka, ");
INSERT INTO cko_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Baa n bo ba wu i na i bá yo Yuda­fɔm fɛmɛ n wo ni wɔ? Ya ŋu i asara­mbaa wiɛ afiiri dɔ, ye ya ŋa ya bá na ya bá kutu i a.” ");
INSERT INTO cko_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Fɛmɛ Herode tiiri sɔ ni, na jɔrɛ n amiɛ i ni Yɛrusalem­fɔm kɛrɛ. ");
INSERT INTO cko_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Na wɔ fere Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm nkpiɛn­kpiɛnm, ni Nyɛmɛ nɔaniɛ kere­fɔm kɛrɛ atiɛn bu nɔɔ, na wɔ bisa bu ka, “Ye bu wú Kristo Tii­de­fɔ n ni wɔ?” ");
INSERT INTO cko_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Na ba bɔ i nu ka, “Bɛtilɛhɛm bo i wo Yudiya asiɛn n su ni, dama kabo Nyɛmɛ nɔaniɛ kan­fɔ n kɛrɛɛri i lɛɛ. Micɛra n ŋa o, ");
INSERT INTO cko_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Wɔrɔ Bɛtilɛhɛm bo a wo Yuda asiɛn n su ni, a ti má miɛ kaan. Wɔrɔ ti Yuda asiɛn n su miɛm anyunuyi­fɔm kun a, dama ka fɛmɛ n bo m yí i na i bá yo m minɛ Yisareli­fɔm tii­fɔ ni, i fíte u dɔ ɔ.’” ");
INSERT INTO cko_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Na Fɛmɛ Herode afere asara­mbaa kɔrɛsi­yi­fɔm n asiri nu na i si saŋga bo asara­mbaa n tiɛɛri ni. ");
INSERT INTO cko_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Na wɔ kere bu ka, “Am kɔ Bɛtilɛhɛm, na am kɔ niɛniɛ nyunyumi, na nzɛn am ŋuuri baa ni, am kpie am nyi ba se m na m gusu kɔ́ kutu i.” ");
INSERT INTO cko_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Fɛmɛ n jɔjɔɔri bu dɔ wieeri sɔ n na ba de atin, bu wo kɔ su sɔ ni, na ba ŋu asara­mbaa n bo bu ŋuuri i wiɛ afiiri ni, ka i du bu mɔ haari na wɔ kɔ ajina awuru n bo baa n wo nu n tii su. ");
INSERT INTO cko_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Bu ŋuuri asara­mbaa n sɔ ni, na bu ahore ajɔ agaya. ");
INSERT INTO cko_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Na ba kɔ awura awuru n nu, na ba ŋu baa n ni i ni Mariya na ba kutu i, na ba yo i ansɛ. Na ba nya ateke bu kurukum, na ba yi aceerim ace i. Aceerim n la sika, ni tulaalɛɛ nva­nvani­fɔ be, i ti samɛnɛ wɔ, ni baka nyunvuin nva­nvani­fɔ. ");
INSERT INTO cko_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Nyini sin na ba fa atin be akpie bu nyi akɔ bu bɔsu, dama Nyɛmɛ ase bu alɛlɛ nu ka má bu kɔ Fɛmɛ Herode dɔ kun. ");
INSERT INTO cko_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Asara­mbaa kɔrɛsi­yi­fɔm n kɔ wieeri ni, na Micɛra n dɛɛ mɛrɛkɛ aba Yosefu dɔ alɛlɛ nu, aba ase i ka, “Yasu fa baa n ni i ni na am ŋmati kɔ Ijipiti asiɛn su, má nyini Fɛmɛ Herode wo baa niɛniɛ su na i kun i. Am kɔ wo dɔ haari cɛɛn bo m bá kaaki ba ma am nɔɔ ka am yasu dɔ.” ");
INSERT INTO cko_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Na Yosefu ayasu afa baa n ni i ni aŋmati kɔŋguɛ n kɛrɛ, na ba kɔ Ijipiti asiɛn n su, ");
INSERT INTO cko_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","na ba wo dɔ haari Fɛmɛ Herode aba awu. Ahin yoori sɔ ni, i ma kabo Micɛra n ma i nɔaniɛ kan­fɔm n yo jɔjɔɔri n yo yii­wa a. I ŋa, “Ma fere m wa n afite Ijipiti asiɛn n su.” ");
INSERT INTO cko_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Saŋga bo Fɛmɛ Herode ba faari nu ka asara­mbaa kɔrɛsi­yi­fɔm n adadaka i ni, na wɔ fa yaa agaya, na wɔ ma i sojam nɔɔ ka bu kɔ Bɛtilɛhɛm miɛ n nu, ni i ahɛmɛ ahɛmɛ n kɛrɛ su na bu kɔ kun nbaa­biɛsɔ kan kanm kɛrɛ bo ba wu bu kisa, kɔ ju afɔ nnyɔ, dama i sunsun ka saŋga n bo asara­mbaa kɔrɛsi­yi­fɔm n ŋa asara­mbaa n tiɛɛri ni, wɔ ju ka afɔ nnyɔ. ");
INSERT INTO cko_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Nyini kere ka, kabo Nyɛmɛ nɔaniɛ kan­fɔ Jeremiya yo jɔjɔɔri n ayo yii­wa. I ŋa, ");
INSERT INTO cko_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ya ti awie bo ŋga Rama miɛ kpiri nu, sun ni ahoresaaki wo dɔ, bara Rakɛli susun i nbaam busu. Wɔ kete ka má be kpata i, dama i nbaam wo má bɛrɛ kun.” ");
INSERT INTO cko_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Saŋga bo Fɛmɛ Herode ba wuuri ni, na Micɛra n dɛɛ mɛrɛkɛ aba Yosefu dɔ alɛlɛ nu Ijipiti asiɛn n su, aba ase i ka, ");
INSERT INTO cko_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Yasu fa baa n ni i ni, na am kpie am nyi kɔ Yisareli asiɛn su, dama minɛm bo bu kpiiri ka bu kun baa ni, ba wu.” ");
INSERT INTO cko_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Na Yosefu ayasu afa baa n ni i ni, na ba kpie bu nyi akɔ Yisareli asiɛn n su. ");
INSERT INTO cko_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ama, saŋga bo i tiiri ka Akilawu adi i si Fɛmɛ Herode fɛmɛya n Yudiya awɔrɛ n nu ni, na sɛrɛ ati i ni kabo i kɔ wo dɔ. Na Nyɛmɛ mɛrɛkɛ aba i dɔ alɛlɛ nu, aba akere i kabo i yo, na wɔ yasu akɔ Galili awɔrɛ n nu akɔ awo miɛ be bo bu fere i ka Nazarɛti n su. ");
INSERT INTO cko_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nyini n kere ka, kabo Nyɛmɛ ma i nɔaniɛ kan­fɔm n jɔjɔɔri n yo yii­wa a, fa kɔ Kristo Tii­de­fɔ n dɔ. I ŋa, “Bu fére i ka Nazarɛti­fɔ ɔ.” ");
INSERT INTO cko_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Nyini saŋga n na Yohane Nyɛmɛ Nzue Biɛ­fɔ n akɔ Yudiya boro kpantain n nu, kɔ sukan Nyɛmɛ jɔrɛ, i ŋa, ");
INSERT INTO cko_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Am kaaki am wo, dama saŋga n adodo bo Nyɛmɛ Fɛmɛ bá niɛ i minɛm su.” ");
INSERT INTO cko_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yiri Yohane n ye Nyɛmɛ nɔaniɛ kan­fɔ Esaya yo jɔjɔɔri i jɔrɛ n a. I ŋa, “Sɔnɔ be subo ndoori boro kpantain n nu se ka, ‘Am sɛsɛ Mibiɛ n atin n su, na am yo i atin n dɔŋgu.’” ");
INSERT INTO cko_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yohane wuraari sutura bo bu faari nyɔɔma ndɔrɛ wuuri i a. Na wɔ fa jina abo i wi nu. I diire yo la lalom ni wiɛ wɔ. ");
INSERT INTO cko_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Na minɛ afite Yɛrusalem miɛ kpiri n nu, ni Yudiya dɛɛ awɔrɛ miɛm kɛrɛ su, ni Yodan dɛɛ bue n kɛrɛ aba i dɔ, ");
INSERT INTO cko_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","na ba kan bu ŋgasi ni bu satiɛ kɛrɛ akere Nyɛmɛ, na Yohane abiɛ bu Nyɛmɛ nzue Yodan kunma n nu. ");
INSERT INTO cko_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ama, saŋga bo i ba ŋuuri ka Farasi­fɔm ni Sadusi­fɔm dɔŋgu suba i dɔ ka i biɛ bu Nyɛmɛ nzue ni, na wɔ se bu ka, “Ambɛrɛ burukɔɔ­nu­fɔm bo am ti ka woom ni, ŋma seeri am ka am ŋmati fite nyini sui­cin kekereke n bo Nyɛmɛ sufa ba am dɔ n nu a? ");
INSERT INTO cko_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Am yo sakpa bo i kere ka am akaaki am wo. ");
INSERT INTO cko_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Na má am sunsun ka Abraham ti am na n dɛɛ ti, na am koro fite nyini sui­cin n nu. M suse am wɔ lɛɛ, ka, Nyɛmɛ koro ma ahin yabuɛm ni kaaki nbaam ma Abraham. ");
INSERT INTO cko_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Nyɛmɛ asi i samba n nana ase baka kɛrɛ bu na i kpiɛ i ji sin nu, yiri bo i suu­wa ti má kpa ni. ");
INSERT INTO cko_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Mini sufa nzue biɛ am a, na am yo casi, bo i kere ka am akaaki am wo, ama, yiri bo i wo m sin suba n tara m fieo, m ti kaan ni bo m dodo i. Yiri fá Awiɛwiɛ Casi n ni sin yo am casi a, kabo sɔnɔ biɛ nzue na i yo casi ni. ");
INSERT INTO cko_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","I bita i ŋgani kpaja fieeba bo i ba bobo ŋgani n gbaŋgba n su, na i kpája yi ŋgani mbaa n fa gɔ i bondo nu, na i nyá yara kunkun n sin n bo i je na i nɔ má n nu.” ");
INSERT INTO cko_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Nyini saŋga n na Yesu afite Galili awɔrɛ n nu, aba Yohane dɔ Yodan kunma n nu ka Yohane biɛ i Nyɛmɛ nzue. ");
INSERT INTO cko_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ama, na Yohane akete ka i biɛ má Yesu Nyɛmɛ nzue ni. I ŋa, “Má i ti ye ni ka wɔrɔ biɛ m Nyɛmɛ nzue a, ye nzu ti ye a ŋa mini biɛ u a?” ");
INSERT INTO cko_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ama, na Yesu abɔ i nu ka, “Ma ya yo sɔ adena ya yo deke kɛrɛ bo Nyɛmɛ koro ni.” I seeri sɔ n na Yohane asoro su. ");
INSERT INTO cko_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Saŋga bo Yohane biɛɛri Yesu Nyɛmɛ nzue n wieeri n na i fiteeri nzue n nu ni, kpeŋga na aŋgoro ateke, na wɔ ŋu ka Nyɛmɛ Awiɛwiɛ n ajura ka tiiwa dɛɛ su aba atana i ŋu. ");
INSERT INTO cko_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Dɔ na wɔ ti akonvi be ŋga aŋgoro, i ŋa, “Ahin ti m wa a, m koro i agaya, m ahore ajɔ i ŋu.” ");
INSERT INTO cko_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Nyini sin na Nyɛmɛ Awiɛwiɛ Casi n afa Yesu akɔ boro kpantain n nu ka Sitana kɔ yo i na i niɛ, ka i yó yiri Sitana n dɛɛ koroo­wa nzɛn i yó má. ");
INSERT INTO cko_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Dɔ na Yesu acici i nɔɔ haari cɛɛn abura­na, kɔŋguɛ ni wiɛsu bo i di má pui, na ahɔɛ aba ati i. ");
INSERT INTO cko_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Na Sitana bo bu kaaki fere i ka Ŋgɛɛ­sɔ­fɔ n aba ase i ka, “Nzɛn a ti Nyɛmɛ Wa, se ahin yabuɛm n na bu kaaki diire.” ");
INSERT INTO cko_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ama, na Yesu abɔ i nu ka, “Ba kɛrɛ i Nyɛmɛ Jɔrɛ Kadasi n nu ka, ‘Má diire ŋgumi ma sɔnɔ ŋgɔɔ a, ama, i de nɔaniɛ kɛrɛ bo i fite Nyɛmɛ dɔ n gusu.’” ");
INSERT INTO cko_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Na Sitana n akaaki afa Yesu akɔ Yɛrusalem miɛ kpiri n nu, na wɔ kɔ afa i ajina Nyɛmɛ Seree­biri Awuru n tii su lenleŋge, na wɔ se i ka, ");
INSERT INTO cko_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“Nzɛn a ti Nyɛmɛ Wa, ti tɔ asiɛŋgu na m niɛ. Dama ba kɛrɛ i Nyɛmɛ Jɔrɛ Kadasi n nu ka, ‘Nyɛmɛ má i mɛrɛkɛm nɔɔ na bu niɛ u dika.’ Ba kaaki akɛrɛ i ka, ‘Bu fá bu saa so u nu, na má u jaa bo yabuɛ be.’” ");
INSERT INTO cko_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Na Yesu ase i ka, “Ba kaaki akɛrɛ i Nyɛmɛ Jɔrɛ Kadasi n nu bekun ka, ‘Má a yo Micɛra Nyɛmɛ n na a niɛ kabo i yiko ti barasu.’” ");
INSERT INTO cko_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Nyini sin na Sitana n afa i akɔ buka be tii su lenleŋge, na wɔ kere i durunya n nu asiɛn kɛrɛ, ni kabo bu ti na bu yo nyumi barasu. ");
INSERT INTO cko_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Na wɔ se i ka, “Nzɛn a kutu suuri m, m fá nyinim n kɛrɛ ma u.” ");
INSERT INTO cko_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Na Yesu ase i ka, “Wɔrɔ Sitana, fa cinsi m bi bɛrɛ. Dama ba kɛrɛ i Nyɛmɛ Jɔrɛ Kadasi n nu ka, ‘Kutu Micɛra u Nyɛmɛ ni, na a su yiri ŋgumi.’” ");
INSERT INTO cko_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Na Sitana n akɔ ayaki i, na Nyɛmɛ mɛrɛkɛm aba i dɔ na ba ba asu i. ");
INSERT INTO cko_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Na saŋga bo Yesu ba tiiri ka ba tara Yohane anyi i dan­saraka ni, na wɔ fite bɛrɛ akɔ Galili awɔrɛ n nu. ");
INSERT INTO cko_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","I yasuuri Nazarɛti miɛ n nu ni, na wɔ kɔ awo Kapɛnam miɛ kpiri n bo i wo dodo Galili kunma kpiri ni, na i wo Zabulon­fɔm ni Nafatali­fɔm dɛɛ awɔrɛ n nu ni. ");
INSERT INTO cko_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","I kɔ tanaari dɔ ni, adena kabo Nyɛmɛ nɔaniɛ kan­fɔ Esaya yo jɔjɔɔri n yo yii­wa. I ŋa, ");
INSERT INTO cko_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Zabulon ni Nafatali­fɔm, am so am sui, ambɛrɛ bo am wo dodo kunma kpiri n bo i wo Yodan kunma n wiɛ afiiri dɛɛ bue ni, ambɛrɛ bo am wo Galili awɔrɛ n ni, deke bo bu ti má Yuda­fɔm wo ni, am so am sui. ");
INSERT INTO cko_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Minɛm bo bu wo awosin nu ni, ba ŋu wein bambaka ni. Na bo bu wo awosin ni yiwee nu ni, bɛrɛ ye sin ni jé ta wein ma bu a.” ");
INSERT INTO cko_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Fite nyini saŋga n na Yesu abo i bu sukan Nyɛmɛ jɔrɛ, i ŋa, “Am kaaki am wo, dama saŋga n aju bo Nyɛmɛ Fɛmɛ bá niɛ i minɛm su.” ");
INSERT INTO cko_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Na saŋga bo Yesu sunati Galili kunma kpiri n nɔɔ su ni, na wɔ ŋu minɛ nnyɔ nbem, bu ti sɔnɔ kun nbaam wɔ. Bɛrɛ la Simon bo bu fere i ka Petoro ni, ni i niɛma Andere. Bu wo bu diɛndiɛ sandi su kunma kpiri n nu, dama bu ti jombaa tara­fɔm wɔ. ");
INSERT INTO cko_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Na Yesu ase bu ka, “Am bra na am ba su m su na m má am tiɛn minɛm nɔɔ ma m, kabo am tara jombaam ni.” ");
INSERT INTO cko_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","I seeri sɔ ni, na ba kaba ayaki bu diɛndiɛm ni, na ba su i su. ");
INSERT INTO cko_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","I nati kɔɔri i nyunu kaan, na wɔ ŋu minɛ nnyɔ nbem bekun, bu ni bu si, bu fere i ka Zɛbɛdi, bɛrɛ la Yakobo ni i niɛma Yohane. Bu ni bu si n wo lee nu suyo bu diɛndiɛm dɔŋgu, na Yesu afere bu. ");
INSERT INTO cko_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Dɔ na ba kaba afite lee n nu ayaki bu si ni, na ba su i su. ");
INSERT INTO cko_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Na Yesu abara ayɛ Galili awɔrɛ n kɛrɛ nu, na i sukere minɛm bu tiɛntiɛn­bunɔɔ sɔɔm n nu, deke bo bu sere Nyɛmɛ na bu kere minɛm Nyɛmɛ jɔrɛ nu ni, na i sukan labari kpa n fa kɔ Nyɛmɛ fɛmɛya n su, na wɔ ma minɛm bo bu la tukpaki barasu barasu n kɛrɛ anya laifiɛ. ");
INSERT INTO cko_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Na i duma ata abara ayɛ Siriya awɔrɛ n kɛrɛ nu, na ba sɔ minɛm bo bu la tukpaki barasu barasu kɛrɛ, ni bo bu di yaari agaya bu ŋuniɛ­mbaa nu, aba i dɔ ka i ma bu nya laifiɛ. Ajinim wo bu nbem ŋu, na nbem tɔ ŋgbiti, na nbem gusu saam ni bu jaam awu, na wɔ ma bu kɛrɛ anya laifiɛ. ");
INSERT INTO cko_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Na jama beberebe afite Galili awɔrɛ n nu, ni Miɛ Burum dɛɛ awɔrɛ n nu, ni Yɛrusalem miɛ kpiri n nu, ni Yudiya dɛɛ awɔrɛ n nu, ni Yodan kunma n sin dɔ, na bu kɛrɛ aba asu i su. ");
INSERT INTO cko_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu ŋuuri jama n ni, na wɔ fun akɔ atana buka be su. Na i susu­fɔm n aba i dɔ. ");
INSERT INTO cko_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Na wɔ bo i bu ka i kere bu, i ŋa, ");
INSERT INTO cko_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Bɛrɛ bo bu ti yaari­fɔm bu ahore su ni, tere­fiɛ wo bu dɔ, dama Nyɛmɛ fɛmɛya n ti bu dɛɛ wɔ. ");
INSERT INTO cko_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Bɛrɛ bo bu ahore asaaki ni, tere­fiɛ wo bu dɔ, dama Nyɛmɛ dá bu ahore a. ");
INSERT INTO cko_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Bɛrɛ bo bu yo bu ŋu kaan ma Nyɛmɛ ni, tere­fiɛ wo bu dɔ, dama Nyɛmɛ bá fa durunya n ma bɛrɛ wɔ. ");
INSERT INTO cko_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Bɛrɛ bo bu nyunu aboro ka bu yo sa bo i kɔ atin su kabo sɔnɔ la konviki fa kɔ diire ni nzue busu ni, tere­fiɛ wo bu dɔ, dama Nyɛmɛ bá ma bu akunnuyi a. ");
INSERT INTO cko_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Bɛrɛ bo bu si aŋunfɔ ni, tere­fiɛ wo bu dɔ, dama Nyɛmɛ bá si bu aŋunfɔ a. ");
INSERT INTO cko_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Bɛrɛ bo bu ahore­mbaa ti casi ni, tere­fiɛ wo bu dɔ, dama bɛrɛ bá ŋu Nyɛmɛ a. ");
INSERT INTO cko_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Bɛrɛ bo bu kpata aluwa ni, tere­fiɛ wo bu dɔ, dama Nyɛmɛ bá fere bu ka i nbaam a. ");
INSERT INTO cko_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Bɛrɛ bo bu yo sa bo i kɔ atin su n dɛɛ ti na minɛm kere bu wuwuruwa ni, tere­fiɛ wo bu dɔ, dama Nyɛmɛ fɛmɛya n ti bɛrɛ dɛɛ a.” ");
INSERT INTO cko_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Na Yesu akaaki ase ka, “Ambɛrɛ bo minɛm bá kpiɛ am nzukɔ, na bu kére am wuwuruwa, na bu bú kɔrɛ barasu kɛrɛ sɔ am, na i kɛrɛ fite ka am ti m dɛɛm dɛɛ ti, tere­fiɛ wo am dɔ. ");
INSERT INTO cko_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Bu bá yo am sɔ, am ma am ahore jɔ agaya, dama am nyá ŋkatɔ bambaka Nyɛmɛ dɔ. I fite ka, kabo bu yo kereeri dawa dɛɛ Nyɛmɛ nɔaniɛ kan­fɔm n wuwuruwa n lɛɛ.” ");
INSERT INTO cko_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Na Yesu ase ka, “Ambɛrɛ, m susu­fɔm ni, am ti ka njin wo durunya n nu a. Ama, nzɛn njin fiɛfiɛ nya ba saari wieeri, i koro yo má i fiɛfiɛ kun. Nyini saŋga ni, wɔ ka ŋgbɛɛn lɛɛ, ŋka bu fá butu wɔ, na minɛm tiɛntiɛn saŋga i ni fa. ");
INSERT INTO cko_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ambɛrɛ ti wein bo i ta ma durunya n nu­fɔm a. Miɛ kɛrɛ bo i wo kpɛrɛ su, sɔnɔ kɛrɛ ŋu i wɔ. ");
INSERT INTO cko_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Sɔnɔ be nya so má fitana su na i fa gaŋga butu su, ama, i fa taka deke su aŋgoro wɔ na i ta wein ma awuru n nu­fɔm kɛrɛ. ");
INSERT INTO cko_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Nyini ti, am ma am wein ta durunya n nu, na sɔnɔ kɛrɛ ŋu am sakpa yoo­wa, adena bu kansi am Si Nyɛmɛ bo i wo aŋgoro ni.” ");
INSERT INTO cko_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Na Yesu ase ka, “Fa kɔ Moyisi nɔaniɛ kpamaa­wa n ni Nyɛmɛ nɔaniɛ kan­fɔm dɛɛ keree­wa n su, má am sunsun ka ma ba ka m ba cɛ bu se wɔ. Ai, ma ba má ka m ba cɛ bu se wɔ, ama, ma ba ka m ma i kɛrɛ bá yo yii­wa a. ");
INSERT INTO cko_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nahɔrɛ ye m suse am n a, kabo aŋgoro ni asiɛŋgu toko wo bɛrɛ ni, bu yí má nɔaniɛ n be haari kampiti sɔ n mmɔɔ fite má nɔaniɛ kpamaa­wa n nu, haari na i deke n kɛrɛ ba awieeri. ");
INSERT INTO cko_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Nyini ti, sɔnɔ kɛrɛ bo i buuri Nyɛmɛ nɔaniɛ maa­wa n kampiti sɔ mmɔɔ ŋgbɛɛn, na i kereeri minɛm ka bɛrɛ gusu yo sɔ, bu fére i mi ka sɔnɔ kaan Nyɛmɛ fɛmɛya n nu. Ama, sɔnɔ kɛrɛ bo i suuri Nyɛmɛ nɔaniɛ kpamaa­wa n su na i kereeri minɛm ka bu gusu yo sɔ, bu fére i mi ka sɔnɔ bambaka Nyɛmɛ fɛmɛya n nu. ");
INSERT INTO cko_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nyini ti, m suse am wɔ lɛɛ, ka, kana am bá wura Nyɛmɛ fɛmɛya n nu, má ka am yo sa bo i kɔ atin su Nyɛmɛ dɔ n tara Farasi­fɔm, ni Nyɛmɛ nɔaniɛ kere­fɔm dɛɛ ni.” ");
INSERT INTO cko_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Na Yesu akaaki ase ka, “Am ati ka bu seeri ya nam ka, ‘Má a kun sɔnɔ,’ na ‘Nzɛn wɔrɔ kɛrɛ bo a kuunri sɔnɔ, bu dí u jɔrɛ.’ ");
INSERT INTO cko_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ama, m suse am wɔ lɛɛ, ka, wɔrɔ kɛrɛ bo a faari yaa u beŋgu ŋu, wɔ yo daka ka bu di u jɔrɛ. Sasu bekun, wɔrɔ kɛrɛ bo a seeri u beŋgu ka i ti sɔnɔ ŋgbɛɛn, wɔ yo daka ka bu fa u jina Yuda­fɔm jɔrɛ­di­fɔ nkpiɛn­kpiɛnm n nyunu na bu di u jɔrɛ. Na nzɛn wɔrɔ kɛrɛ bo a seeri u beŋgu ka i ti sinnzin, Nyɛmɛ fá u wura cɛɛma sin n nu. ");
INSERT INTO cko_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Nyini ti, nzɛn a fa u aceeri aba ka a ba sere Nyɛmɛ, na a teŋge su ka u ni u beŋgu be la ŋgasi, ");
INSERT INTO cko_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","yaki u aceeri n yoo­wa yoo­biri n ka, na a kɔ na am kɔ yo am afiɛn dɔŋgu, na a nya ba fa u aceeri n ma Nyɛmɛ. ");
INSERT INTO cko_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Nzɛn u ni be la jɔrɛ, na nzɛn i koro ka i fa u kɔ jɔrɛ dii­biri, jɔkɔti tara i mi n jaa, na má jɔrɛ n ju jɔrɛ dii­biri n ni, má nyini, i mi ni fá u kɔ wura jɔrɛ­di­fɔ n saa nu, na yiri gusu fá u ma dan­saraka niɛ­fɔ ni, na yiri gusu nyá nyi u. ");
INSERT INTO cko_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nahɔrɛ ye m suse u n a, nzɛn a woori dɔ na a tɔ má kaari n kɛrɛ awie má, a nyá má atin fite má dan­saraka n nu.” ");
INSERT INTO cko_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Na Yesu akaaki ase ka, “Am ati ka ba se ka, ‘Má a saaki ajaa ciire.’ ");
INSERT INTO cko_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ama, mini, m suse am wɔ lɛɛ, ka, wɔrɔ kɛrɛ bo a niɛ bara, na u konvi wuraari i, i ti ka a saaki ajaa ciire u ahore su wɔ lɛɛ. ");
INSERT INTO cko_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Nzɛn u nyu­mbaa n kun cin u wuraari satiɛ nu, lokoti yi i tu. I ti ye ni ka a fun u ŋuniɛ­mbaa n bue kun, ni bo a fa u ŋuniɛ­mbaa n kɛrɛ wura cɛɛma sin nu. ");
INSERT INTO cko_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Nzɛn u saa fɔmbɔrɔ cin u wuraari satiɛ nu, kaba kpiɛ i tu. I ti ye ni ka a fun u ŋuniɛ­mbaa n bue kun, ni bo a fa u ŋuniɛ­mbaa n kɛrɛ wura cɛɛma sin nu.” ");
INSERT INTO cko_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Na Yesu akaaki ase ka, “Sasu bekun, ba kaaki ase am ka, ‘Sɔnɔ kɛrɛ bo i yaki i yi ajaa, i ti ye ni ka i mi ma bara n ajaa yaki kadasi bo i kere ka i hun ayaki i ajaa.’ ");
INSERT INTO cko_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ama, mini, m suse am wɔ lɛɛ, ka, sɔnɔ kɛrɛ bo i faari i yi jiiri, na wɔ yo má ka bara n akɔ somaya ye i fa i jiiri a, na nzɛn bara n kɔ jaari biɛsɔ fɔfɔrɛ, i mi n ma bara n asaaki ajaa ciire lɛɛ. Na sɔnɔ bo i faari bara n jaari, yiri gusu asaaki ajaa ciire lɛɛ.” ");
INSERT INTO cko_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Na Yesu akaaki ase ka, “Am akaaki ati ka ba se ya nam ka, ‘Má a tan ndiɛ na a kaaki wɔrɔ u nɔɔ, ama, ma u sui wo ndiɛ bo a tan i ama Micɛra n su, na a yo i.’ ");
INSERT INTO cko_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ama, mini, m suse am wɔ lɛɛ, ka, má am tan ndiɛ mmɔɔ fieo. Má am tan aŋgoro, dama Nyɛmɛ fɛmɛya n woo­biri lɛɛ. ");
INSERT INTO cko_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Má a tan asiɛŋgu gusu, dama i ti Nyɛmɛ jaa gbagbaa jinaa­biri wɔ. Má a tan Yɛrusalem, dama i ti ya Micɛra Fɛmɛ n dɛɛ miɛ kpiri wɔ. ");
INSERT INTO cko_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Má a kaaki se ka a tan u tii­awa, dama a koro yo má u tii­ŋmiɛ kun mmɔɔ fofoe, wara biri. ");
INSERT INTO cko_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Am ma am nɔaniɛ kɛrɛ yo tika. Nzɛn i ti ‘Ɛɛn,’ am se ka, ‘Ɛɛn.’ Nzɛn i ti ‘Ai’ gusu a, am se ka, ‘Ai.’ Sin nyini sin, nɔaniɛ kɛrɛ bo i buka su n fite Sitana dɔ ɔ.” ");
INSERT INTO cko_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Na Yesu akaaki ase ka, “Am ati ka ba se ka, ‘Nzɛn sɔnɔ yi u nyu­mbaa, wɔrɔ gusu yi i mi dɛɛ, na nzɛn i bo tuuri u jee, wɔrɔ gusu tu i mi dɛɛ.’ ");
INSERT INTO cko_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ama, mini, m suse am wɔ lɛɛ, ka, nzɛn sɔnɔ yoori u satiɛ, má a wɔrɔ satiɛ ma i mi. Haari nzɛn be fiinri u nyɔɔnu, kaaki bue nyiŋga n gusu ma i na i fin buka su. ");
INSERT INTO cko_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Nzɛn be cici u lekisi ka i fa u kɔ jɔrɛ dii­biri, na i de u tanlɛɛ kaan n be i wo i bu ni, kaba yi i tii su dɛɛ bambaka n mmɔɔ buka i su. ");
INSERT INTO cko_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Nzɛn faŋga­fɔ be miɛɛri u ka a sɔ i sɔɔri kɔ ju ajaari natii­wa akpii kun ma i, kaba fa i kɔ ju akpii nnyɔ. ");
INSERT INTO cko_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Sɔnɔ bo i sereeri u deke be, má a kpiɛ i, na sɔnɔ bo i ŋa a fiɛ i deke be, má a kete.” ");
INSERT INTO cko_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Na Yesu akaaki ase ka, “Am ati ka ba se ka, ‘A koro sɔnɔ bo i koro u ni, na a kpɔ sɔnɔ bo i kpɔ u ni.’ ");
INSERT INTO cko_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ama, mini, m suse am wɔ lɛɛ, ka, am koro am kpɔ­fɔm, na am sere Nyɛmɛ ma bo bu kere am wuwuruwa ni, ");
INSERT INTO cko_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","adena am yó am Si Nyɛmɛ bo i wo aŋgoro ni nbaam. Dama yiri ma wiɛ fite ma satiɛ­yo­fɔm, ni sakpa­yo­fɔm kɛrɛ a, na i kaaki ma nzue tɔ ma bo bu yo sa bo i kɔ atin su i dɔ ni, ni bo bu yo má sa bo i kɔ atin su i dɔ n kɛrɛ. ");
INSERT INTO cko_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Nzɛn am nya koroori minɛm bo bu koro am ŋgumi ni, nzu ŋkatɔ, ye am nya i a? Dama haari lampo­de­fɔm bo bu sisi minɛm ni mmɔɔ yo sɔ ɔ. ");
INSERT INTO cko_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Na nzɛn am bisa am danfom ŋgumi ahin, am sunsun ka am ayo nzu sakpa ye be koro yo má i a? Bo bu su má Nyɛmɛ ni mmɔɔ koro yo sɔ, má sɔ? ");
INSERT INTO cko_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Tɔ, am ma am woo­wa n ti kpa bo i la má aŋusu, kabo am Si Nyɛmɛ bo i wo aŋgoro n dɛɛ woo­wa n ti kpa bo i la má aŋusu ni.” ");
INSERT INTO cko_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Na Yesu ase bu ka, “Am si am ŋu sa, na má am yi am nyɛmɛsu sa­yoo­wa fite fofoe nu, adena minɛm ŋu i na bu kansi am. Nzɛn am yoori sɔ, am nya má ŋkatɔ be, am Si Nyɛmɛ bo i wo aŋgoro n dɔ. ");
INSERT INTO cko_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Nyini ti, nzɛn a ŋa a ce yaari­fɔm aceeri, má a bo ndoori na sɔnɔ kɛrɛ ti, kabo burukɔɔ­nu­fɔm yo i bu tiɛntiɛn­bunɔɔ sɔɔ n nu, ni miɛ kunnu atiŋgberem n su ni, dama bu yo sɔ ɔ, adena minɛm kansi bu. Nahɔrɛ ye m suse am n a, bɛrɛ ŋkatɔ awieeri lɛɛ, ye ba du mɔ anya i n a. ");
INSERT INTO cko_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ama, nzɛn a ŋa a ce yaari­fɔm aceeri, má a ma be ŋu i fieo, na bu si sa bo a suyo i ni, ");
INSERT INTO cko_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","adena u aceeri n yo asiri nu. Dɔ na u Si Nyɛmɛ bo i ŋu sa kɛrɛ bo a yo i asiri nu ni, n tɔ́ u kaari.” ");
INSERT INTO cko_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Na Yesu akaaki ase ka, “Nzɛn saŋga bo am ba susere Nyɛmɛ, má am yo kabo burukɔɔ­nu­fɔm yo ni, dama bɛrɛ koro ka bu sujina bu tiɛntiɛn­bunɔɔ sɔɔm n nu, ni deke bo atiŋgberem jaja nu ni, na bu sere Nyɛmɛ adena minɛm ŋu bu. Nahɔrɛ ye m suse am n a, bu ŋkatɔ awieeri lɛɛ, ye ba du mɔ anya i n a. ");
INSERT INTO cko_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ama, saŋga bo a ba susere Nyɛmɛ, wura u sɔrɔ na a nyi u anɔ, na a sere u Si Nyɛmɛ bo be ŋu má i ni, na u Si Nyɛmɛ bo i ŋu sa kɛrɛ bo a yo i asiri nu ni, nyá tɔ u kaari. ");
INSERT INTO cko_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Na saŋga bo am ba susere Nyɛmɛ, má am yo naŋmiɛ kabo bo bu su má Nyɛmɛ n yo ni, dama bu sunsun ka bu jɔjɔɔri beberebe n ye Nyɛmɛ de bu sere a. ");
INSERT INTO cko_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Má ambɛrɛ yo ka bɛrɛ, dama am Si Nyɛmɛ si am sa koroo­wa kɛrɛ n mmɔɔ ka, ye am nya sere i a. ");
INSERT INTO cko_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Nyini ti, kabo i ti ye ni ka am sere Nyɛmɛ yaa. ‘Ya Si, bo a wo aŋgoro ni, ma minɛm bu u duma casi ni. ");
INSERT INTO cko_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ma u fɛmɛya n bra. Ma u koroo­wa yo asiɛŋgu fɛn, ka alecɛɛma nu. ");
INSERT INTO cko_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ma ya nyuma dɛɛ cɛɛn nu, ya nɔɔ nu diire. ");
INSERT INTO cko_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Fa ya ŋgasi fa ce ya, kabo ya gusu afa ace bo bu do ya ŋgasi ni. ");
INSERT INTO cko_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Má a ma deke be yo ya na ya wura satiɛ nu, ama, yi ya fite anyumbiri nu. Dama, u dɛɛ la fɛmɛya, ni faŋga, ni jirima saŋga kɛrɛ. Ami.’ ");
INSERT INTO cko_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Dama nzɛn am fa minɛm ŋgasi ce bu, am Si Nyɛmɛ bo i wo aŋgoro n gusu fá am dɛɛ ce am. ");
INSERT INTO cko_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ama, nzɛn am afa má minɛm ŋgasi ace má bu, am Si Nyɛmɛ bo i wo aŋgoro n gusu fá má am dɛɛ ce má am.” ");
INSERT INTO cko_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Na Yesu akaaki ase ka, “Saŋga bo am sucici am nɔɔ, má am niɛ aŋunfɔ niɛ kabo burukɔɔ­nu­fɔm yo ni, bu yo má bu ŋu nyankandi, adena minɛm ŋu ka ba cici bu nɔɔ. Nahɔrɛ ye m suse am n a, bu ŋkatɔ awieeri lɛɛ, ye ba du mɔ anya i n a. ");
INSERT INTO cko_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ama, nzɛn a ba sucici u nɔɔ, yo u ŋu nyankandi, ");
INSERT INTO cko_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","adena má minɛm si nu ka a sucici u nɔɔ, má ka u Si Nyɛmɛ bo be ŋu má i ni, na yiri u Si Nyɛmɛ bo i ŋu sa kɛrɛ bo a yo i asiri nu ni n tɔ́ u kaari.” ");
INSERT INTO cko_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Na Yesu akaaki ase ka, “Má am tiɛn ajɛkɛ nɔɔ se durunya n nu fɛn, bo watarawam muka i na i kpɔrɔ, na i tɔ ŋgambulaari, na awiefɔm gusu bá wura wɔ i. ");
INSERT INTO cko_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ama, am tiɛn ajɛkɛ nɔɔ se Nyɛmɛ dika n nu, bo watarawam koro muka má i, na i koro tɔ má ŋgambulaari, na awiefɔm gusu koro wura wɔ má i. ");
INSERT INTO cko_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Dama deke bo u ajɛkɛ wo ni, u ahore­mbaa kɛrɛ gusu wó dɔ ɔ.” ");
INSERT INTO cko_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Na Yesu akaaki ase ka, “Ya nyu­mbaa ni ti ka fitana ma ya ŋuniɛ­mbaa n a. Nzɛn u nyu­mbaa nya ti kpa, u ŋuniɛ­mbaa n kɛrɛ tá wein n wɔ lɛɛ. ");
INSERT INTO cko_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ama, nzɛn u nyu­mbaa nya ti má kpa, u ŋuniɛ kɛrɛ wo awosin nu wɔ lɛɛ. Nyini ti, nzɛn wein wo má u dɔ, nyini n la ka, a wo awosin bambaka bo i la má aŋusu nu lɛɛ.” ");
INSERT INTO cko_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Na Yesu akaaki ase ka, “Sɔnɔ kun koro saŋga su má mibiɛm nnyɔ. Nzɛn i ŋa i yó sɔ, i kpɔ́ kun wɔ, na i kóro nyiŋga ni, wara i bóro i nyi su kun n wɔ, na i bú nyiŋga ni ŋgbɛɛn. Am koro saŋga su má Nyɛmɛ ni ajɛkɛ.” ");
INSERT INTO cko_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Na Yesu akaaki ase ka, “Nyini ti, m suse am wɔ lɛɛ, ka, má am tana sukoko fa kɔ am ŋgɔɔ su, kabo am dí, ni kabo am nú, na má am kaaki sukoko fa kɔ am ŋuniɛ su, kabo am nyá suturam bo am fá wura na am kára. Dama ŋgɔɔ n tara diire, na aŋuniɛ­mbaa n gusu tara suturam, má sɔ? ");
INSERT INTO cko_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Am niɛ anumam, haari ni bo bu dɔ má ni, na bu kaaki kpiɛ má ni, bu tambu gɔ má bondo nu gusu, se am Si Nyɛmɛ ma bu diire ye bu di a. Ambɛrɛ la anyunuyi tara anumam, má sɔ? ");
INSERT INTO cko_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Am nu, ŋma tana koko fa kɔ i koroo­wam su ye i mi koro buka i ŋgɔɔ tintiin su haari kaan sɔ a? ");
INSERT INTO cko_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ye nzu ti ye am ma suturam sa miɛ am a? Am niɛ kabo wuram bo pum barasu barasu a. Bu yo má juma be, bu tu má gise. ");
INSERT INTO cko_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ama, m suse am wɔ lɛɛ, ka, haari Fɛmɛ Solomon, ni i neŋge n kɛrɛ bo i yo la i ni, wɔ la má sutura bo i yo nyumi juuri nyini wura pum ni be. ");
INSERT INTO cko_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Nzɛn wuram bo bu wo bɛrɛ nyuma, na ahunma a ŋú ka ba kpiɛ bu na bu yara bu, ye Nyɛmɛ niɛ bu dika, nzu ti ye i níɛ má ambɛrɛ bo am tara wuram co n a? Ambɛrɛ, am yarada n ti kaan sɔ. ");
INSERT INTO cko_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Nyini ti, má am tana koko se ka, ‘Ye ya dí nzu wɔ?’ wara ‘Ya nú nzu wɔ?’ wara ‘Ya wúra nzu wɔ?’ ");
INSERT INTO cko_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Dama bo bu su má Nyɛmɛ ni, bɛrɛ sunsun sɔ saŋga kɛrɛ a. Am Si Nyɛmɛ si ka am koro nyinim n kɛrɛ. ");
INSERT INTO cko_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Nyini ti, am du mɔ kpini Nyɛmɛ fɛmɛya n ni sa bo i kɔ atin su i dɔ n busu ka, na i nyá ba fa nyini dekem n kɛrɛ buka am su. ");
INSERT INTO cko_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Nyini ti, má am koko fa kɔ ahunma su, ahunma mmɔɔ kpíni i dɛɛ. Dama nyuma dɛɛ sunsunni mmɔɔ asɛ su.” ");
INSERT INTO cko_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Na Yesu ase bu ka, “Má am jɔjɔ be jɔrɛ na am jaraki i, adena má Nyɛmɛ gusu jɔjɔ ambɛrɛ jɔrɛ jaraki am. ");
INSERT INTO cko_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Dama kabo am jɔjɔ am beŋgum jɔrɛ jaraki bu ni, sɔ ye Nyɛmɛ gusu jɔjɔ am gusu jɔrɛ jaraki am a. Gɔŋgɔ bo am fa susu ma minɛm ni, sɔ ye Nyɛmɛ gusu fá susu ma am a. ");
INSERT INTO cko_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Nzu ti ye a niɛ ŋu wura mbaa n bo i wo u niwa nyu­mbaa nu, ye a niɛ ŋu má yeenzin n bo i wo u dɛɛ nyu­mbaa n nu a? ");
INSERT INTO cko_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","A yo sɛ koro se u niwa ka, ‘Ma m yi wura mbaa n bo i wo u nyu­mbaa nu ni,’ ye saŋga kɛrɛ yeenzin n wo u dɛɛ nyu­mbaa n nu a? ");
INSERT INTO cko_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Wɔrɔ burukɔɔ­nu­fɔ ni, du mɔ yi yeenzin n bo i wo u nyu­mbaa nu n ka, na a nyá ŋu asi nyunyumi na a yi wura mbaa n bo i wo u niwa n dɛɛ nyu­mbaa nu ni. ");
INSERT INTO cko_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Má am se ka am fa deke bo i ti casi fa ma caam, nzɛn am yoori sɔ, bu kpíe bu nyi fɔn tara am wɔ, na bu kán titi am nu. Sasu bekun, má am se ka am fa afere fofoem bo bu la gɔ agaya, fa tu afam. Má nyini, bu tíɛntiɛn i su wura fa nu wɔ.” ");
INSERT INTO cko_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Na Yesu akaaki ase bu ka, “Am sere deke bo am koro i Nyɛmɛ dɔ, na i má am. Am niɛniɛ deke bo am koro i dɔ, na am ŋú i. Am bobo anɔ ni, na i téke i ma am. ");
INSERT INTO cko_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Dama sɔnɔ kɛrɛ bo i sere Nyɛmɛ deke be, i má i, na sɔnɔ kɛrɛ bo i niɛniɛ deke be, i ŋú i, na sɔnɔ kɛrɛ bo i bobo anɔ ni, i téke i ma i. ");
INSERT INTO cko_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ambɛrɛ nu, ŋma ye i wa sere i diire, ye i mi kéte na i fá yabuɛ ma i wa n a? Ai, be yo má sɔ. ");
INSERT INTO cko_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Wara, ambɛrɛ nu, ŋma ye i wa sere i jombaa ye i kéte na i fá woo ma i wa n a? Ai, be yo má sɔ. ");
INSERT INTO cko_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Tɔ, ambɛrɛ, haari ni bo am ti satiɛ­yo­fɔm ni, am si aceeri kpam bo am fá ce am nbaam, nzu ti ye nzɛn am sereeri am Si Nyɛmɛ bo i wo aŋgoro ni, i koro ma má am aceeri kpam a? ");
INSERT INTO cko_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Nyini ti, kabo am koro ka minɛm yó ma am ni, am yo i sɔ ma bu, dama Nyɛmɛ nɔaniɛ kpamaa­wa n jɔrɛ n kɛrɛ lɛɛ, na i nɔaniɛ kan­fɔm dɛɛ buka su.” ");
INSERT INTO cko_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Na Yesu akaaki ase ka, “Am fa anɔ n bo i ti fii n na am wura. Dama atin n bo i fa minɛm kɔ saakii­biri ni, i anɔ n ti tɛtɛrɛ wɔ, na i natiiri ti má kekere, nyini dɛɛ ti, minɛm dɔŋgu fa yiri wɔ. ");
INSERT INTO cko_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ama, atin n bo i fa minɛm kɔ ŋgɔɔ woo­biri ni, i anɔ n ti fii wɔ, na i atin gusu nati ti kekereke, nyini dɛɛ ti, minɛm bo bu ŋu nyini atin n na bu su i su ni, bu sunnu má.” ");
INSERT INTO cko_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Na Yesu akaaki ase ka, “Am si am ŋu sa ni kɔrɛ­fɔm bo bu yo bu ŋu ka bu ti Nyɛmɛ nɔaniɛ kan­fɔm ni. Bu yo bu ŋu bɛnlɛ ka nbɔɛm wɔ, ama, bu ti ka bedim wɔ, na bu ti tiɛ. ");
INSERT INTO cko_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Bu sa­yoo­wa n nu, ye am koro fa si kabo bu ti barasu a. Am aŋu ka buwe asu koto? Wara, am aŋu ka bedikantoŋga asu ndɔrɔwa? Ai. ");
INSERT INTO cko_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ama, i ti sɔ ɔ lɛɛ, ka baka kpa kɛrɛ su suu­wa kpa a, na baka ŋgbɛɛn kɛrɛ su suu­wa ŋgbɛɛn­ŋgbɛɛn. ");
INSERT INTO cko_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Baka kpa koro su má suu­wa ŋgbɛɛn, na baka ŋgbɛɛn gusu koro su má suu­wa kpa. ");
INSERT INTO cko_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Baka kɛrɛ bo i su má suu­wa kpa, bu kpiɛ i wɔ, na bu fa ji sin nu. ");
INSERT INTO cko_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Nyini ti, bo bu yo bu ŋu ka bu ti Nyɛmɛ nɔaniɛ kan­fɔm ni, bu sa­yoo­wa n nu, ye am koro fa si kabo bu ti barasu a.” ");
INSERT INTO cko_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Na Yesu akaaki ase ka, “Má sɔnɔ kɛrɛ bo i bo fere m ka, ‘M Mibiɛ, m Mibiɛ,’ ni wura Nyɛmɛ fɛmɛya n nu a, se má ka bo bu yo m Si Nyɛmɛ bo i wo aŋgoro n dɛɛ koroo­wa ni. ");
INSERT INTO cko_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Jina cɛɛn n ba juuri, minɛ dɔŋgu bá se m ka, ‘Ya Mibiɛ, niɛ e. Ya yo faari u dɛɛ duma, na ya fa akan Nyɛmɛ jɔrɛ, na ya fa u duma n afɔn ayi ajinim afite minɛm ŋu, na ya kaaki afa u duma n ayo alekutura sam dɔŋgu.’ ");
INSERT INTO cko_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Na m nya se bu ka, ‘Ambɛrɛ satiɛ­yo­fɔm ni, am fa cinsi m bi bɛrɛ. M si má am cɛɛn n be cɛɛn n be da.’” ");
INSERT INTO cko_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Na Yesu akaaki ase ka, “Nyini ti, sɔnɔ kɛrɛ bo i tiiri m dɛɛ nɔaniɛm n na i deeri i na i fa yoori juma, i mi ti ka alecira­fɔ be bo i taari i awuru na i seeri i jaa n yabuɛ su n wɔ. ");
INSERT INTO cko_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Na nzue aba atɔ, na wawa n kɛrɛ ayi asandi, na aŋuma akpisi awuru ni, ama, wɔ tɔ má, dama i jaa jina yabuɛ su n dɛɛ ti. ");
INSERT INTO cko_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ama, sɔnɔ kɛrɛ bo i tiiri m dɛɛ nɔaniɛm n na wɔ de má i, afa ayo má juma, i mi ti ka sinnzin be bo i taari i awuru ŋmiɛ nu n wɔ. ");
INSERT INTO cko_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Na nzue aba atɔ, na wawa n kɛrɛ ayi asandi, na aŋuma akpisi awuru n na i kɛrɛ abereki atɔ liim. Nyini awuru n tɔɔ­wa n tiiri tiɛ haari.” ");
INSERT INTO cko_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Saŋga bo Yesu ba jɔjɔɔri sɔ wieeri n na jama n ayo alekutura fa kɔ i keree­wa n su, ");
INSERT INTO cko_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","dama i keree­wa n awo i ŋgumi ni Yuda­fɔm dɛɛ Nyɛmɛ nɔaniɛ kere­fɔm ni. I keree­wa n nu la yiko. ");
INSERT INTO cko_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Saŋga bo Yesu juraari buka n su ba juuri n na jama beberebe asu i su. ");
INSERT INTO cko_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Na koko­fɔ be aba i dɔ, na wɔ ba akutu i nyunu asere i ka i buka i, i ŋa, “M Mibiɛ, nzɛn a koro ka a ma m nya laifiɛ, a koro ma m nya i.” ");
INSERT INTO cko_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Na Yesu ateŋge i saa anana i ŋu, na wɔ se i ka, “M koro. Nya laifiɛ.” Na kokobi n akaba ayaki sɔnɔ n na wɔ nya laifiɛ. ");
INSERT INTO cko_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Dɔ na Yesu ase i ka, “Má a se ka a se be ahin jɔrɛ ni, ama, kɔ na a kɔ fa u ŋu kere Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ ni, na a kɔ yo yoo­wa n bo Moyisi yo kereeri dawa­fɔm ni, dama nyini kere minɛm ka a nya u ŋu a.” ");
INSERT INTO cko_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Saŋga bo Yesu kɔ wuraari Kapɛnam miɛ kpiri n nu ni, na Roma­fɔm soja kpiɛn be aba asere Yesu jande ka i buka i, ");
INSERT INTO cko_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","i ŋa, “M Mibiɛ, m gbɛfɛnɛ da awuru, i saa ni i jaa kɛrɛ awu, i sudi wahara agaya.” ");
INSERT INTO cko_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Na Yesu ase i ka, “M bá na m ma i nya laifiɛ.” ");
INSERT INTO cko_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Na soja kpiɛn n ase i ka, “M Mibiɛ, m ti kaan ni be a ba m dika. Ama, haari a ma nɔaniɛ n mmɔɔ, m gbɛfɛnɛ ni nyá laifiɛ. ");
INSERT INTO cko_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Dama mini mmɔɔ ni m tii n wo sɔnɔ saa nu wɔ, na mini gusu nya la m dɛɛ sojam bo m niɛ bu su. Na bo m nya se i ka, ‘Kɔ fɛn,’ na i kɔ, na m se nyiŋga gusu ka, ‘Bra fɛn,’ na i ba. Na m se m akɔɔ n gusu ka, ‘Yo ahin,’ na i yo i.” ");
INSERT INTO cko_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Saŋga bo Yesu tiiri sɔ ni, na wɔ yo alekutura, na wɔ se minɛm bo bu su i su n ka, “Nahɔrɛ ye m suse am n a, ma nya aŋu má sɔnɔ bo i la yarada agaya ka ahin sɔnɔ n ŋusu, haari fa saŋga ni Yisareli­fɔm mmɔɔ. ");
INSERT INTO cko_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","M suse am wɔ lɛɛ, ka, minɛm beberebe fíte durunya n wiɛ afiiri, ni wiɛ atɔɔri kɛrɛ, na bɛrɛ, ni Abraham, ni Izaki, ni Jakɔbu bá saŋga tana Nyɛmɛ fɛmɛya n nu, na bu dí na bu nú. ");
INSERT INTO cko_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ama, na minɛm n bo má i ti ye ni ka bɛrɛ wo Nyɛmɛ fɛmɛya n nu ni, na Nyɛmɛ fa bu tu awosin nu. Dɔ na bu sún, na bu kán bu saa.” ");
INSERT INTO cko_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Na Yesu anya ase soja kpiɛn n ka, “Kɔ awuru. Kabo a yo yarada ni, i yó sɔ ma u a.” Na soja kpiɛn n gbɛfɛnɛ n anya laifiɛ, nyini saŋga n bo Yesu fa jɔjɔɔri ni. ");
INSERT INTO cko_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Saŋga bo Yesu wuraari Petoro dika n na wɔ ŋu ka Petoro sibara da sɔrɔ, i la má i ŋu, yakɔkɔ abo i. ");
INSERT INTO cko_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Na Yesu aso i saa nu, na yakɔkɔ n ayaki i, na bara n ayasu, na wɔ kɔ ayo diire ama i. ");
INSERT INTO cko_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Nyini cɛɛn n naasɔ, na ba fa minɛm beberebe n bo ajinim wo bu ŋu ni, aba Yesu dɔ. Na wɔ ma ajinim nɔɔ na ba fite, na wɔ tuntun tukpaki­fɔm na bu kɛrɛ anya laifiɛ. ");
INSERT INTO cko_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","I yoori sɔ, na nɔaniɛ n bo Nyɛmɛ nɔaniɛ kan­fɔ Esaya yo jɔjɔɔri i n yo yii­wa wɔ, i ŋa, “Na wɔ de ya afite ya tɔrɛm, ni ya tukpaki kɛrɛ nu.” ");
INSERT INTO cko_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Saŋga bo Yesu ŋuuri jama n sɔ ni, na wɔ se i susu­fɔm n ka bu kpiɛ kɔ kunma kpiri n buekun dɔ. ");
INSERT INTO cko_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Na Nyɛmɛ nɔaniɛ kere­fɔ kun aba Yesu dɔ, aba ase i ka, “Ya Kere­fɔ, deke kɛrɛ bo a kɔ, m sú u su wɔ.” ");
INSERT INTO cko_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Na Yesu ase i ka, “Ŋaakum la kunmam, na anumam gusu la tiɛɛrim, ama, mini Adamande Wa n yiri, m la má m tii daa­biri.” ");
INSERT INTO cko_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Na i susu­fɔm n kun be gusu ase i ka, “M Mibiɛ, ma m du mɔ kɔ yo m si sutura ka, na m nyá ba su u su.” ");
INSERT INTO cko_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ama, na Yesu ase i ka, “Wɔrɔ su m su, na a yaki bo ba wu ni, na bu se bu beŋgu.” ");
INSERT INTO cko_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Nyini sin na Yesu awura lee nu, na i susu­fɔm n asu i su. ");
INSERT INTO cko_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Bu wo kɔ su sɔ ni, na aŋuma bambaka be ayasu nzue n nu, na i subo nzue gɔ lee n nu. Má lee ni suyi ni nzue wɔ. Ama, nyini saŋga na Yesu wo daafiri su. ");
INSERT INTO cko_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Na i susu­fɔm n akɔ ateŋge i, na ba se i ka, “Ya Mibiɛ, de ya tii ji, má nyini, ya wu awie.” ");
INSERT INTO cko_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Na wɔ se bu ka, “Nzu ti ye am soro sɛrɛ sɔ a? Ambɛrɛ, am yarada n ti kaan sɔ ɔ.” Na wɔ yasu atiɛn aŋuma n ni nzue n ŋu, na dika n kɛrɛ atara jum. ");
INSERT INTO cko_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Na ba yo alekutura, na ba se ka, “Nzu sɔnɔmbiri barasu la ahin, bo aŋuma ni nzue n mmɔɔ de i nɔaniɛ a?” ");
INSERT INTO cko_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Saŋga bo Yesu kpiɛɛri kunma kpiri n kɔ juuri awɔrɛ n bo bu fere i ka Gadara n ni, na i ni minɛ nnyɔ nbem ayɛ, bu fite faŋ­kunmam nu wɔ, ajinim wo bu ŋu. Bu ti tiɛ haari bo be koro nati sin má nyini awɔrɛ n nu. ");
INSERT INTO cko_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Bu ŋuuri Yesu sɔ ni, na ba tiɛn afere i, bu ŋa, “Nyɛmɛ Wa, a koro nzu ya nu fɛn a? A ba ka a ba ma ya ŋu anyum­boro wɔ ka, na saŋga n nya ju, nzɛn sɛ?” ");
INSERT INTO cko_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Nyini saŋga afam beberebe wo di su, bu waari má ni bɛrɛ, ");
INSERT INTO cko_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","na ajinim n asere Yesu ka, “Nzɛn a ŋa a fɔn ya fite minɛm n ŋu, ma ya kɔ fun afam n ŋu.” ");
INSERT INTO cko_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Na Yesu ase bu ka, “Am kɔ.” Na ba fite ayaki minɛm ni, na ba kɔ afun afam n ŋu. Dika n nu bɛrɛ, na bu kɛrɛ aŋmati acɔɔndi akɔ ato kunma kpiri nzue n nu, na nzue n adi bu. ");
INSERT INTO cko_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Afa sasa­fɔm ni ŋuuri nyini n sɔ ni, na ba ŋmati akɔ miɛ n kunnu akɔ abo ndoori, fa kɔ sa n bo wɔ yo n su. Na ba kan sa kɛrɛ bo i tuuri minɛm n bo ajinim woori bu ŋu ni. ");
INSERT INTO cko_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Na miɛ n nu­fɔm kɛrɛ pepere afite akɔ Yesu dɔ. Saŋga bo bu kɔ ŋuuri i sɔ ni, na ba sere i jande ka i fite bu awɔrɛ n nu. ");
INSERT INTO cko_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Na Yesu akaaki awura lee n nu, akpiɛ akɔ i bɔsu. ");
INSERT INTO cko_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Dɔ na minɛ nbem afa sɔnɔ be aba i dɔ, i saam ni i jaam awu. Bu sɔɔri i ni i dasu kɛrɛ baari a. Yesu ŋuuri kabo bu yoori i yarada n sɔ ni, na wɔ se sɔnɔ n bo i saam ni i jaam awu n ka, “M wa, ma u ahore si, dama ma fa u satiɛ ace u.” ");
INSERT INTO cko_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Dɔ na Yuda­fɔm Nyɛmɛ nɔaniɛ kere­fɔm nbem asunsun bu ahore su ka, “Ahin sɔnɔ n sujɔjɔ wura Nyɛmɛ ŋgasi nu.” ");
INSERT INTO cko_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesu siiri bu sunsunni nu sɔ ni, na wɔ bisa bu ka, “Nzu ti ye am bita sunsunni tiɛ am ahore su a? ");
INSERT INTO cko_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Bɔnɔ ti kekereke a, bo m se ka, ‘Ma fa u satiɛ ace u,’ nzɛn, ‘Yasu fa u dasu n na a nati’ n a? ");
INSERT INTO cko_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ama, m kére am ka mini Adamande Wa n la yiko durunya n nu bo m fa minɛm satiɛ ni bu ŋgasi ce bu.” Na wɔ se sɔnɔ n ka, “Yasu fa u dasu n na a kɔ awuru.” ");
INSERT INTO cko_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Na sɔnɔ n ayasu, na wɔ kɔ awuru. ");
INSERT INTO cko_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Saŋga bo jama n ŋuuri nyini n sɔ ni, na ba yo alekutura, na ba kansi Nyɛmɛ, kabo wɔ ma minɛm nyini yiko n ni. ");
INSERT INTO cko_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Na Yesu ayasu dɔ akɔ. I wo kɔ su sɔ ni, na wɔ ŋu lampo­de­fɔ be, bo bu fere i ka Matio, ka i tana i juma yoo­biri. Na Yesu ase i ka, “Yasu bra na a ba su m su.” Na wɔ yasu asu i su. ");
INSERT INTO cko_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Saŋga bo Yesu wo Matio dika, sudi diire ni, na satiɛ­yo­fɔm, ni lampo­de­fɔm beberebe aba Yesu ni i susu­fɔm n dɔ, na ba saŋga adi diire. ");
INSERT INTO cko_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Farasi­fɔm ŋuuri nyini sɔ ni, na ba bisa Yesu susu­fɔm n ka, “Nzu ti ye am kerefɔ n ni lampo­de­fɔm, ni satiɛ­yo­fɔm saŋga di diire a?” ");
INSERT INTO cko_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Na Yesu ati bu jɔjɔɔ­wa n na wɔ bɔ bu nu ka, “Minɛm bo bu la laifiɛ n koro má ayiri­fɔ, má ka bo bu la má laifiɛ ni koro a. ");
INSERT INTO cko_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Am kɔ na am kɔ fiiti Nyɛmɛ nɔaniɛ n nu na am ti i bu, kabo ba kɛrɛ i ka, ‘M koro aŋunfɔ si tara bo am yo yoo­wa ma m.’ Ma ba má ka m bá fere minɛm bo bu ŋa bu yo sa bo i kɔ atin su Nyɛmɛ dɔ n wɔ, ama, m baari ka m bá fere satiɛ­yo­fɔm wɔ.” ");
INSERT INTO cko_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Na Yohane susu­fɔm n aba Yesu dɔ, aba abisa i ka, “Nzu ti ye yɛrɛ ni Farasi­fɔm cici ya nɔɔ, ye u dɛɛ susu­fɔm bɛrɛ cici má?” ");
INSERT INTO cko_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Na Yesu abɔ bu nu ka, “Am sunsun ka konyaya­fɔm koro wo ni ahoresaaki, saŋga bo konyafan n toko wo bu dɔ ni? Ama, saŋga suba bo bu bá yi konyafan n fite bu nu, nyini saŋga n ye bu nyá cici bu nɔɔ a.” ");
INSERT INTO cko_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Na Yesu akaaki ase ka, “Be koro fa má sanvuin fɔfɔrɛ kpa tɔ má tani dawa kunma, nzɛn i yoori sɔ, sanvuin fɔfɔrɛ ni sɔ́n tani dawa n wɔ, na i téke i kunma buka su. ");
INSERT INTO cko_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","I kaaki ti sɔ ɔ bekun ka be koro fa má nzan nyii­wa faŋga­fɔ gɔ má dundu dawa bɛbɛtɛ nu, nzɛn i yoori sɔ, dundu ni tíɛ wɔ, na i ká ŋgbɛɛn, na nzan n kɛrɛ sóŋgi butu. Ama, i ti ye ni ka, bu fa nzan nyii­wa faŋga­fɔ gɔ dundu fɔfɔrɛ bii­wa nu wɔ, na bu fa taka bo pui yo má i.” ");
INSERT INTO cko_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Saŋga bo Yesu wo jɔjɔ su sɔ ni, na Yuda­fɔm kpiɛn be bo i niɛ bu tiɛntiɛn­bunɔɔ sɔɔ n su n aba akutu i nyunu, ase i ka, “M wa baa­bara awu, jina n nu bɛrɛ. Bra na a ba fa u saa nana i ŋu, na i nyá ŋgɔɔ.” ");
INSERT INTO cko_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Na Yesu ayasu, na i ni yiri akɔ, na i susu­fɔm n asu su. ");
INSERT INTO cko_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Dɔ na bara be woori jama n nu, i bita abiɛɛri i afɔ buru ni nnyɔ lɛɛ bo i kpu na i kpiɛ má. Na wɔ sakati awura jama n nu Yesu sin, afa i saa akan Yesu tanlɛɛ n jaa bu. ");
INSERT INTO cko_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Dama i seeri i kunnu ka, “Haari m fa m saa kaanri i tanlɛɛ ni mmɔɔ, m nyá laifiɛ.” ");
INSERT INTO cko_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Na Yesu akaaki aniɛ aŋu i, na wɔ se i ka, “M wa, ma u ahore si. Yarada n bo a yo m ni, yiri ma a nya laifiɛ a.” Dika n nu bɛrɛ, na bara n anya laifiɛ. ");
INSERT INTO cko_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Saŋga bo Yesu kɔ juuri kpiɛn n dika ni, na wɔ ŋu sɛɛ mbiɛ kan­fɔm, ni jamam ka bu wo naŋmiɛ su. ");
INSERT INTO cko_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Na wɔ se bu ka, “Am fa sin fite, baa­bara n awu má, wɔ daafi wɔ.” Ama, na ba siri i. ");
INSERT INTO cko_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","I fɔɔnri jama n kɛrɛ fite wieeri ni, na wɔ nya awura sɔɔ n bo baa­bara n da nu n nu, na wɔ kɔ atara i saa, na wɔ yasu. ");
INSERT INTO cko_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Na nyini labari n abara ayɛ dɔ dɛɛ awɔrɛ n kɛrɛ nu. ");
INSERT INTO cko_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Na Yesu afite bɛrɛ, i sukɔ n na anyinsin nnyɔ nbem asu i su, subo fere i, bu ŋa, “Fɛmɛ Davidi anuma, si ya aŋunfɔ.” ");
INSERT INTO cko_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Na saŋga bo Yesu kɔ wuraari awuru n nu ni, na anyinsinm n aba i dɔ na wɔ bisa bu ka, “Am yo yarada ka m koro ma am nya laifiɛ?” Na ba bɔ i nu ka, “Ɛɛn, ya Mibiɛ, ya yo yarada.” ");
INSERT INTO cko_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Dɔ na wɔ fa i saa akan bu nyu­mbaam, na wɔ se bu ka, “Kabo am ayo m yarada ni, i yó sɔ ma am.” ");
INSERT INTO cko_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Na bu nyu­mbaam n ateke, na ba ŋu asi. Na Yesu abɔbɔ bu ni nahɔrɛ su ka, má bu ma be si sa n bo wɔ yo i ni. ");
INSERT INTO cko_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ama, na ba kɔ abo ndoori abara ayɛ dɔ dɛɛ awɔrɛ n kɛrɛ nu, fa kɔ sa n bo Yesu ayo i ni. ");
INSERT INTO cko_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Saŋga bo anyinsinm n fite kɔɔri n dɛɛ sin, na minɛ nbem afa sɔnɔ be aba Yesu dɔ, ajini ayo i bobo wɔ. ");
INSERT INTO cko_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yesu fɔn yiiri ajini n fiteeri sɔnɔ n ŋu wieeri n na wɔ koro ajɔjɔ. Na jama n ayo alekutura, na ba se ka, “Ya nya ŋu má ahin sa n be ŋusu cɛɛn be, Yisareli asiɛn n su.” ");
INSERT INTO cko_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ama, na Farasi­fɔm n ase ka, “Ajinim kɛrɛ dɛɛ fɛmɛ ni ma i yiko ye i koro fɔn yi ajinim n a.” ");
INSERT INTO cko_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Na Yesu abara ayɛ miɛ ŋgbiŋgbirim, ni kan kanm n kɛrɛ su, na i sukere minɛm, bu tiɛntiɛn­bunɔɔ sɔɔm n nu, na i sukan labari kpa n fa kɔ Nyɛmɛ fɛmɛya n su, na wɔ tuntun minɛ bo tukpaki barasu barasu n kɛrɛ bita bu ni, na ba nya laifiɛ. ");
INSERT INTO cko_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Saŋga bo Yesu ŋuuri jama n na wɔ si bu aŋunfɔ, dama ba di wahara, na bu la má buka­fɔ. Bu ti ka nbɔɛm bo bu la má sasa­fɔ ɔ. ");
INSERT INTO cko_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Na wɔ se i susu­fɔm n ka, “Fiesu diire n sunnu, ama, bo bu kɔ i tambu n sunnu má. ");
INSERT INTO cko_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Nyini ti, am sere Mibiɛ n bo i dɛɛ la fie n ka i sunma juma­yo­fɔm na bu kɔ i tambu.” ");
INSERT INTO cko_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Na Yesu afere i susu­fɔ buru ni nnyɔm ni, na wɔ ma bu yiko ka bu kɔ sufɔn yi ajinim fite minɛm ŋu, na bu ma tukpaki­fɔm barasu barasu kɛrɛ nya laifiɛ. ");
INSERT INTO cko_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","I jaramasa buru ni nnyɔm n bo i yiiri bu n duma n la Simon, bo bu fere i ka Petoro ni, ni i niɛma Andere, ni Yakobo ni i niɛma Yohane bo bu si la Zɛbɛdi ni, ");
INSERT INTO cko_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ni Filipu, ni Batolomeyo, ni Tomasi, ni Matio bo i ti lampo­de­fɔ ni, ni Yakobo bo i si la Alafeyo ni, ni Tadayɔ, ");
INSERT INTO cko_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ni Simon bo i tu ŋgoni fa kɔ i asiɛn su ni, ni Yudasi Isikariyoti bo i ba tɔɔri Yesu ni. ");
INSERT INTO cko_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Na Yesu asunma nyini minɛ buru ni nnyɔm n na wɔ ma bu ahin nɔaniɛ ni, i ŋa, “Má am kɔ miɛm bo bu ti má Yuda­fɔm miɛm n nu, wara am wura Samariya­fɔm miɛ be nu. ");
INSERT INTO cko_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ama, am kɔ Yisareli­fɔm bo bu ti ka nbɔɛm na ba mini n dɔ. ");
INSERT INTO cko_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Am kɔ na am kɔ kan Nyɛmɛ jɔrɛ kere bu, na am se bu ka, saŋga n adodo bo Nyɛmɛ Fɛmɛ bá niɛ i minɛm su. ");
INSERT INTO cko_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Na am ma tukpaki­fɔm nya laifiɛ, na am teŋge bo ba wu ni, na am ma koko­fɔm nya laifiɛ, na am fɔn yi ajinim fite minɛm ŋu. Kabo ma ma am ahin yiko n na ma de má pui ni, am gusu yo sɔ n na má am de pui. ");
INSERT INTO cko_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Má am se ka am bita ŋwaa be, haari ŋwaa kaan mmɔɔ. ");
INSERT INTO cko_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ahin atin n bo am sukɔ i ni, má am se ka am bita kuruku, má am fa tanlɛɛ be buka bo am wura i n su, má am fa gbagbaa, má am fa kpama, dama juma­yo­fɔ kɛrɛ ti ye ni ka bu ma i diire wɔ.” ");
INSERT INTO cko_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Na wɔ se ka, “Miɛ kpiri, wara miɛ kan kan kɛrɛ bo am kɔ wuraari nu, am niɛniɛ sɔnɔ kpa, na am kɔ wo i dɔ, haari am bá fite miɛ n nu. ");
INSERT INTO cko_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Awuru kɛrɛ bo am kɔ suwura nu, am bisa bu dɔŋgu, na am se bu ka Nyɛmɛ yo bu kisi. ");
INSERT INTO cko_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Nzɛn nyini awuru n nu­fɔm deeri am wɔfɔ, am ma nyini kisi n ka bu dɔ, ama, nzɛn ba de má am, am kaaki de nyini kisi n bu dɔ. ");
INSERT INTO cko_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Sasu bekun, nzɛn awuru, wara miɛ bo am kɔ wuraari nu, na ba de má am wɔfɔ, wara ba soro má am su ka bu ti am nɔaniɛ ni, am fite yaki nyini awuru n wara miɛ ni, na am kpɔnkpɔn yi am jaa tuturi kɛrɛ. ");
INSERT INTO cko_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nahɔrɛ ye m suse am n a, jina cɛɛn, Nyɛmɛ cín nyini miɛ n nu­fɔm sui tara Sodom ni Gomora miɛm n nu satiɛ­yo­fɔm ni.” ");
INSERT INTO cko_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Na Yesu akaaki ase bu ka, “Am ti fɛn. M susunma am wɔ lɛɛ kabo nbɔɛm kɔ saŋga bedim nu barasu ni. Nyini ti, am fa ŋgɔnlɛ na am tara am ŋu ka woom, na am yo am ŋu bɛnlɛ ka tiiwam. ");
INSERT INTO cko_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Am si am ŋu sa, dama minɛ bá fa am wura jɔrɛ­di­fɔm saa nu, na bu fín am ŋgbere bu tiɛntiɛn­bunɔɔ sɔɔm n nu. ");
INSERT INTO cko_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Mini dɛɛ ti, bu cín am wura gominam ni nfɛmɛm saa nu. Nyini má am atin na am di m daani kere bɛrɛ a, ni bo bu ti má Yuda­fɔm n kɛrɛ. ");
INSERT INTO cko_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Saŋga bo bu bá faari am wuraari jɔrɛ­di­fɔm saa nu ni, má am ma am ahore saaki fa kɔ kabo am kɔ́ jɔjɔ barasu. Nyini saŋga n ba juuri, Nyɛmɛ má am nɔaniɛ ye am jɔjɔ a. ");
INSERT INTO cko_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Nɔaniɛ ni fíte má am dɔ, ama, i fíte am Si Nyɛmɛ dɛɛ Awiɛwiɛ n dɔ, ye am jɔ́jɔ a. ");
INSERT INTO cko_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Gɔrɔm ni niɛmam bá tɔ bu beŋgu ma bu kpɔ­fɔm na bu kún bu, na nbaasim tɔ́ bu nbaam, na nbaam kéte bu wu­fɔm ŋu, na bu má minɛm kun bu wu­fɔm ni. ");
INSERT INTO cko_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Mini dɛɛ ti, sɔnɔ kɛrɛ kpɔ́ am. Ama, wɔrɔ kɛrɛ bo a mindi deeri nyini n kɛrɛ kɔ juuri i awieeri su, Nyɛmɛ dé u tii ji. ");
INSERT INTO cko_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Saŋga bo bu bá sukere am wuwuruwa miɛ be su, am ŋmati kɔ miɛ nyiŋga su. Nahɔrɛ ye m suse am n a, am koro kan má Nyɛmɛ jɔrɛ bara yɛ má Yisareli miɛm kɛrɛ su ka, ye mini Adamande Wa ni kpíe m nyi ba. ");
INSERT INTO cko_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Sɔnsɔn­fɔ tara má i kere­fɔ, akɔɔ gusu tara má i mibiɛ. ");
INSERT INTO cko_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Nzɛn sɔnsɔn­fɔ n ba juuri i kere­fɔ n juu­biri, i ti ye ni ka i nyunu yi i tii. Na nzɛn akɔɔ n ba juuri i mibiɛ n juu­biri, i ti ye ni ka i nyunu yi i tii. Nzɛn bu nya fereeri awuru­fɔ­biɛ n ka Bɛlazɛbuli, bo bu kaaki fere i ka Sitana ni, nyini saŋga bu fére i dika­fɔm bɛrɛ kɛrɛ ka sɛ wɔ lɛɛ?” ");
INSERT INTO cko_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Na wɔ kaaki ase bu ka, “Nyini ti, má am soro sɛrɛ ni minɛm. Dama deke be wo má bɛrɛ bo i wo fiɛɛ­wa nu na bu bá ŋu má i, deke be gusu wo má bɛrɛ bo i wo asiri nu na bu bá si má i. ");
INSERT INTO cko_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Deke kɛrɛ bo m jɔjɔ seeri am kɔŋguɛ, wɔ yo daka ka am jɔjɔ i wiɛsu wɔ. Na deke kɛrɛ bo m tuuri i asuturi am dɔ, wɔ yo daka ka am bo i ndoori na sɔnɔ kɛrɛ ti i. ");
INSERT INTO cko_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Má am soro minɛm bo bu koro kun aŋuniɛ­mbaa n na bu koro kun má awiɛwiɛ n ni. Ama, am soro Nyɛmɛ bo i koro saaki awiɛwiɛ n ni aŋuniɛ­mbaa n kɛrɛ, cɛɛma sin nu ni. ");
INSERT INTO cko_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Am si ka njɔrɛm nnu ŋwaa ti kaan sɔ ɔ, má sɔ? Ama, bu kun n kpein mmɔɔ tɔ́ má asiɛŋgu bo i ti má ya Si Nyɛmɛ koroya­nu. ");
INSERT INTO cko_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Haari am tii­ŋmiɛ kɛrɛ mmɔɔ bo i wo am tii su ni, Nyɛmɛ si i kɛrɛ nɔ. ");
INSERT INTO cko_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Nyini ti, má am soro sɛrɛ. Am la anyunuyi Nyɛmɛ dɔ tara njɔrɛm beberebe.” ");
INSERT INTO cko_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Na Yesu akaaki ase bu ka, “Sɔnɔ kɛrɛ bo i kan kereeri minɛm ka i ti m susu­fɔ, mini gusu bá kan kere m Si Nyɛmɛ bo i wo aŋgoro n ka i mi ti m dɛɛ wɔ. ");
INSERT INTO cko_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ama, sɔnɔ kɛrɛ bo i keteeri minɛm nyunu ka i ti má m susu­fɔ, mini gusu bá kete m Si Nyɛmɛ bo i wo aŋgoro n nyunu ka i mi ti má m dɛɛ.” ");
INSERT INTO cko_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Na Yesu akaaki ase ka, “Má am sunsun ka ma ba ka m fa tana­laifiɛ ba ma durunya n nu­fɔm wɔ. Ma ba má ka m fa tana­laifiɛ ba, ama, m faari luɛ baari a. ");
INSERT INTO cko_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","M baari ka m ba kpura baa ni i si tii wɔ, na m kpura baa­bara ni i ni tii, na m kaaki kpura baa n ni, ni i wa yi tii, ");
INSERT INTO cko_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","na sɔnɔ dika­fɔm káaki i kpɔ­fɔm. ");
INSERT INTO cko_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Sɔnɔ kɛrɛ bo i koro i si, wara i ni tara mini, i ti má ye ni ka i mi wo m dɔ. Na sɔnɔ kɛrɛ bo i koro i wa baa­biɛsɔ, wara baa­bara tara mini, i ti má ye ni ka i mi wo m dɔ. ");
INSERT INTO cko_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Na sɔnɔ kɛrɛ bo i sɔ má i yiwee baka jaanu n na i su m su, i ti má ye ni ka i mi wo m dɔ. ");
INSERT INTO cko_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Sɔnɔ kɛrɛ bo i ŋa i kpíni i ŋgɔɔ busu, i mi bá fun i, ama, na sɔnɔ kɛrɛ bo i tɔɔri i ŋgɔɔ mini dɛɛ ti, i mi nyá ŋgɔɔ.” ");
INSERT INTO cko_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Na Yesu akaaki ase bu ka, “Sɔnɔ kɛrɛ bo i de am wɔfɔ, i mi de mini wɔ lɛɛ, na sɔnɔ kɛrɛ bo i de mini, i mi de yiri bo i sunmaari m wɔ lɛɛ. ");
INSERT INTO cko_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Sɔnɔ kɛrɛ bo i de Nyɛmɛ nɔaniɛ kan­fɔ ka i ti Nyɛmɛ nɔaniɛ kan­fɔ n dɛɛ ti, i mi nyá ŋkatɔ kabo Nyɛmɛ nɔaniɛ kan­fɔ nya i n wɔ, na sɔnɔ kɛrɛ bo i de sɔnɔ bo i yo sa bo i kɔ atin su Nyɛmɛ dɔ, na wɔ de i ka i yo sa bo i kɔ atin su n dɛɛ ti, i mi nyá ŋkatɔ kabo sɔnɔ bo i yo sa bo i kɔ atin su n nya i n wɔ. ");
INSERT INTO cko_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nahɔrɛ ye m suse am n a, sɔnɔ kɛrɛ bo i saari nzue niniki kaan sɔ mmɔɔ, maari m susu­fɔ n bo i ti bu kɛrɛ kaan n kun, ka i mi ti m dɛɛ susu­fɔ n ti, i mi nyá i ŋkatɔ.” ");
INSERT INTO cko_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Saŋga bo Yesu jɔjɔɔri i susu­fɔm n dɔ wieeri ni, na wɔ jeŋgbe Galili awɔrɛ n nu miɛ miɛm su, sukere minɛm, na wɔ kan Nyɛmɛ jɔrɛ. ");
INSERT INTO cko_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Nyini saŋga ni, ba nyi Yohane Nyɛmɛ Nzue Biɛ­fɔ n dan­saraka sɔrɔ. Na wɔ ti sam kɛrɛ bo Kristo Tii­de­fɔ n suyo bu ni, na wɔ sunma i susu­fɔm ka bu kɔ bisa i ka, ");
INSERT INTO cko_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Wɔrɔ ye bu yo seeri ka a bá n a, nzɛn ya ŋmínda sɔnɔ fɔfɔrɛ be wɔ?” ");
INSERT INTO cko_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Na Yesu abɔ bu nu ka, “Am kpie am nyi kɔ se Yohane fa kɔ sam bo am ati bu na am aŋu bu ni, ka ");
INSERT INTO cko_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","anyinsinm aŋu asi, wɔbukam akoro anati, koko­fɔm anya laifiɛ, asuturim ati asui, minɛm bo ba wu n ateŋge, na yaari­fɔm gusu akoro ati labari kpa ni. ");
INSERT INTO cko_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Tere­fiɛ wo minɛm bo bu yo m yarada na bu la má sika be ni mini n dɔ.” ");
INSERT INTO cko_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Saŋga bo Yohane susu­fɔm kaaki sukɔ ni, na Yesu ajɔjɔ jama n dɔ, fa kɔ Yohane ŋusu jɔrɛ, i ŋa, “Saŋga bo am fite kɔɔri Yohane dɔ, boro kpantain n nu ni, am kɔɔri ka am kɔ ŋu nzu wɔ? Am kɔɔri ka am kɔ ŋu sɔnɔ bo i ti ka barankpaati fofoe bo aŋuma n kankan i wɔ? ");
INSERT INTO cko_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Nzɛn má nyini, nzu ti ye am kɔɔri a? Am ŋa am kɔ ŋu sɔnɔ bo i wura sutura ŋgbiŋgbiri wɔ? Ai, am si ka minɛm bo bu wura nyini suturam ni, bu wo nfɛmɛm dika a. ");
INSERT INTO cko_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Nzɛn má nyini, nzu ti ye am kɔɔri a? Am kɔɔri ka am kɔ ŋu Nyɛmɛ nɔaniɛ kan­fɔ ɔ? Ɛɛn, m suse am wɔ lɛɛ, ka, am aŋu sɔnɔ bo i tara Nyɛmɛ nɔaniɛ kan­fɔ. ");
INSERT INTO cko_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Dama Yohane ye bu yo kɛrɛɛri i Nyɛmɛ Jɔrɛ Kadasi n nu ka, ‘Nyɛmɛ ŋa o, “M dú mɔ sunma m sunma­fɔ n na i dú u mɔ, yiri kɔ́ yo u atin n dɔŋgu se u a.”’ ");
INSERT INTO cko_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nahɔrɛ ye m suse am n a, Yohane Nyɛmɛ Nzue Biɛ­fɔ n la má abeŋgu, bo i tara i durunya n nu. Ama, sɔnɔ kɛrɛ bo i ti kaan, Nyɛmɛ fɛmɛya n nu n tara yiri Yohane.” ");
INSERT INTO cko_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Na Yesu akaaki ase ka, “Fite saŋga bo Yohane Nyɛmɛ Nzue Biɛ­fɔ n boori Nyɛmɛ jɔrɛ kan n bu ni, fa ba ju ni kisa, ye Nyɛmɛ fɛmɛya n ŋuuri kekereke a, na minɛm afa anyum­boro ka bu wura nu de i. ");
INSERT INTO cko_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Nyɛmɛ nɔaniɛ kan­fɔm kɛrɛ, ni Moyisi du mɔ kɛrɛɛri Nyɛmɛ Jɔrɛ Kadasi n nu fa kɔ Nyɛmɛ fɛmɛya n su ka, ye Yohane nya baari a. ");
INSERT INTO cko_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Nzɛn am yó bu nɔaniɛm yarada, Yohane la yiri n bo bu yo kɛrɛɛri ka Eliya káaki ba n a. ");
INSERT INTO cko_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Bo i koro ka i ti ahin jɔrɛ n bu, i ti ye ni ka i so i sui na i ti.” ");
INSERT INTO cko_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Na Yesu akaaki ase ka, “Ye m fá nzu fa sunsun kabo nyuma­fɔ ti a? Bu ti ka nbaatuma kan kanm bo bu tana gɔɔsu wɔ. Na bu sufere bu beŋgu, ");
INSERT INTO cko_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","bu ŋa, ‘Ya kan tere ama am, ama, am abo má kereba. Ya di sɛɛ jue ama am, ama, am asun má.’ ");
INSERT INTO cko_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Deke bo i ti na m se sɔ n la ka, Yohane ba juuri ni, i ciciiri i nɔɔ ɔ, i di má diire, i nu má nzan yiri fieo, nyini ti, na ba se ka ajini wo i ŋu a. ");
INSERT INTO cko_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ama, mini Adamande Wa n ba juuri, na m ni minɛ asaŋga adi, na ya saŋga anu, na ba se ka, ‘Am niɛ, ahin sɔnɔ n yiri, i ti ayaakpiri­fɔ ɔ, na i nu nzan nahɔrɛ su. Wɔ tara lampo­de­fɔm, ni satiɛ­yo­fɔm danfoya.’ Tɔ, minɛm kɛrɛ bo bu su Nyɛmɛ dɛɛ alecira n atin n su ni, bu sa­yoo­wam kere ka i ti nahɔrɛ a.” ");
INSERT INTO cko_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Miɛm bo Yesu yoori alekutura sam beberebe nu ni, bu minɛm n akaaki má bu wo, nyini ti, na Yesu akan bu ndiɛ, ");
INSERT INTO cko_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","i ŋa, “Ambɛrɛ Korazin­fɔm, am bá ŋu anyum­boro. Ambɛrɛ Besayida­fɔm gusu, am bá ŋu anyum­boro. Alekutura sam bo m yo maari am ni, má nzɛn m yoori bu Tiro ni Sidon miɛ kpirim n nu, má minɛm n akaaki bu wo dada kɛrɛ na bu fa pirim bɔtɔ, ni nzuin yo bu yoo­wa n bo i kere ka bu ahore asaaki, bu satiɛ yoo­wa n dɛɛ ti ni. ");
INSERT INTO cko_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ama, m suse am wɔ lɛɛ, ka, jina cɛɛn, Nyɛmɛ bá cin am sui tara Tiro ni Sidon dɛɛ satiɛ­yo­fɔm. ");
INSERT INTO cko_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ambɛrɛ Kapɛnam­fɔm gusu, am sunsun ka Nyɛmɛ bá yɛ am su kɔ aŋgoro wɔ? Ai, i bá yo am kaan wɔ, na i fá am cɔɔndi kɔ Yiwee­fɔm Woo­biri nu. Alekutura sam bo m yo maari am ni, má nzɛn m yoori bu Sodom miɛ kpiri n nu, má kisa, miɛ n toko wo bɛrɛ haari ni nyuma. ");
INSERT INTO cko_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ama, m suse am wɔ lɛɛ, ka, jina cɛɛn, Nyɛmɛ bá cin am sui tara Sodom dɛɛ satiɛ­yo­fɔm.” ");
INSERT INTO cko_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Nyini saŋga n na Yesu ase ka, “M Si Nyɛmɛ, wɔrɔ ti aŋgoro ni asiɛŋgu kɛrɛ Mibiɛ a. M da u asi ka a fa nyini dekem bo alecira­fɔm ni si­fɔm si má i ni, ayi akere bo bu ti ka nbaatam ni. ");
INSERT INTO cko_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","M Si, i ti nahɔrɛ wɔ, kabo a koroori ka i yo lɛɛ.” ");
INSERT INTO cko_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Na wɔ kaaki ase bu ka, “M Si Nyɛmɛ afa deke kɛrɛ awura m saa nu. Be si má Nyɛmɛ Wa ni, má ka i Si Nyɛmɛ si i a, na be gusu si má i Si ni, má ka Baa ni si i a, ni minɛm bo Baa n koro ka i yi i kere bu ni, bɛrɛ si i a.” ");
INSERT INTO cko_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Na wɔ kaaki ase ka, “Ambɛrɛ kɛrɛ bo am sɔ sɔɔri nɔnɔɔri n na am afie ni, am bra m dɔ, na m má am ŋumi­yi. ");
INSERT INTO cko_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Am de m sɔɔri ni, na am ma am wo ti kabo m dɛɛ n ti ni, dama m ti bɛnlɛ wɔ, na m yo m ŋu kaan. Mini dɔ ye am nyá ŋumi­yi a. ");
INSERT INTO cko_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Dama keree­wa n bo m fa ma am n ti má kekereke, na sɔɔri n gusu bo m fa sɔ am n wo má nɔ.” ");
INSERT INTO cko_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Nyini saŋga n na Yesu ni i susu­fɔm ni sunati sin alɛ­mbaa fie be nu, Yuda­fɔm Ŋumi­yi cɛɛn ni. Na ahɔɛ ati i susu­fɔm ni, na ba bubu be akpɛsɛ. ");
INSERT INTO cko_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Saŋga bo Farasi­fɔm ni ŋuuri nyini sɔ ni, na ba se Yesu ka, “Niɛ fɛn. Kabo u susu­fɔm ni suyo ni, Nyɛmɛ nɔaniɛ kpamaa­wa n kere ka má be yo sɔ, Ŋumi­yi cɛɛn ni.” ");
INSERT INTO cko_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Na wɔ se bu ka, “Am nya kan má Nyɛmɛ Jɔrɛ Kadasi n nu, kabo Fɛmɛ Davidi yo yoori saŋga bo ahɔɛ tiiri i ni i minɛm na ba si má kabo bu yo ni, nzɛn sɛ? ");
INSERT INTO cko_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ahɔɛ n ti, na wɔ kɔ awura Nyɛmɛ Seree­biri Awuru n nu, na wɔ di kpɔnɔ n bo ba fa ama Nyɛmɛ ni, na wɔ ma i minɛm ni be. Ama, am si ka ya dɛɛ atin n su, Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm ŋgumi ti ye ni ka bu di nyini kpɔnɔ n a. ");
INSERT INTO cko_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Sasu bekun, am nya kan má Nyɛmɛ Jɔrɛ Kadasi n nu, kabo Ŋumi­yi cɛɛn n kɛrɛ cɛɛn, na Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm ni saaki Ŋumi­yi cɛɛn n ciire ni, na bu yo bu yoo­wam Nyɛmɛ Seree­biri Awuru n nu, na be se má bu pui, nzɛn sɛ? ");
INSERT INTO cko_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","M suse am wɔ lɛɛ, ka, deke bo i tara Nyɛmɛ Seree­biri Awuru n wo fɛn. ");
INSERT INTO cko_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ba kɛrɛ i Nyɛmɛ Jɔrɛ Kadasi n nu ka, Nyɛmɛ ŋa o, ‘M koro aŋunfɔ si tara bo am yo yoo­wa ma m.’ Nzɛn má am si nyini nɔaniɛ n bu, má am ma má bu di minɛm jɔrɛ cin bu sui, bɛrɛ bo bu la má ŋgasi be ni. ");
INSERT INTO cko_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Dama mini Adamande Wa ni ti Ŋumi­yi cɛɛn n Mibiɛ n a.” ");
INSERT INTO cko_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Na Yesu ayasu dɔ akɔ awura bu tiɛntiɛn­bunɔɔ sɔɔ n nu. ");
INSERT INTO cko_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Sɔnɔ asaa fuin be woori dɔ. Na minɛ nbem akoro ka bu sɔ́ Yesu ŋgɛɛ na bu járaki i ka na wɔ saaki Ŋumi­yi cɛɛn n ciire ni. Dɔ na ba bisa i ka, “Atin wo nu ka ya koro ma sɔnɔ nya laifiɛ, Ŋumi­yi cɛɛn ni?” ");
INSERT INTO cko_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Na Yesu abɔ bu nu ka, “Am nu, ŋma ye i bɔɛ ti kun n kpein ye i toori kunma ŋgoŋgo nu Ŋumi­yi cɛɛn n ye i mi wúra yi má i a? ");
INSERT INTO cko_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Adamande tara bɔɛ fieo. Nyini ti, ya dɛɛ atin n su, atin wo nu ka ya yo sakpa Ŋumi­yi cɛɛn ni.” ");
INSERT INTO cko_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Na wɔ nya ase sɔnɔ n ka, “Teŋge u saa ni.” Na wɔ teŋge i saa ni, na i saa n ayo faŋga bekun ka nyiŋga ni. ");
INSERT INTO cko_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Dɔ na, Farasi­fɔm n afite akɔ asɛsɛ bu ŋu su, kabo bu yó na bu kun Yesu. ");
INSERT INTO cko_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Saŋga bo Yesu siiri nu sɔ ni, na wɔ yasu bɛrɛ. Na jama beberebe asu i su, na wɔ ma bu tukpaki­fɔm kɛrɛ anya laifiɛ. ");
INSERT INTO cko_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Na wɔ bɔbɔ bu ka, má bu ma be si i sɔnɔ nzuin nu. ");
INSERT INTO cko_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","I yoori sɔ, adena kabo Nyɛmɛ nɔaniɛ kan­fɔ Esaya yo jɔjɔɔri n yo yii­wa a, i ŋa, ");
INSERT INTO cko_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Nyɛmɛ ŋa o, ‘M amusui­su­fɔ bo ma yi i ka i yo m sa koroo­wa n yaa. Yiri ye m koro i a, m ahore ajɔ i ŋu. M má m Awiɛwiɛ n ba wura i ŋu. Na i kɔ́ kan kere durunya n nu­fɔm kɛrɛ kabo m nahɔrɛ atin n ti barasu. ");
INSERT INTO cko_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","I ni be sé má akuruwa, wara i tíɛntiɛn má. I káaki yo má naŋmiɛ atiŋgberem su. ");
INSERT INTO cko_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","I búbu má janja wura bo wɔ biri, na i nɔ́ má fitana bo i je má nyunyumi. I wó bɛrɛ sɔ haari na m nahɔrɛ atin n bá kunma deke n kɛrɛ. ");
INSERT INTO cko_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Na durunya n nu­fɔm kɛrɛ bá ti i duma ni, na bu yó i tama.’” ");
INSERT INTO cko_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Nyini sin na ba fa sɔnɔ be aba Yesu dɔ, ajini ayo i anyinsin ni bobo wɔ. Na Yesu ama wɔ nya laifiɛ, na wɔ koro ajɔjɔ, na wɔ ŋu asi. ");
INSERT INTO cko_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Na minɛm kɛrɛ ayo alekutura, na ba bisa bu ŋuŋu nu ka, “Fɛmɛ Davidi anuma n lɛɛ, nzɛn sɛ a?” ");
INSERT INTO cko_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ama, Farasi­fɔm tiiri sɔ n na ba se ka, “Bɛlazɛbuli bo i ti ajinim kɛrɛ dɛɛ fɛmɛ ni, yiri ŋgumi ma ahin sɔnɔ n yiko dɛɛ ti, ye i koro fɔn yi ajinim n a.” ");
INSERT INTO cko_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesu siiri bu sunsunni n sɔ n na wɔ se bu ka, “Fɛmɛya kɛrɛ bo i nya kpakpaakiiri nu wieeri, nyini fɛmɛya ni ká ŋgbɛɛn wɔ. Awuru, wara miɛ kɛrɛ gusu bo i nya kpakpaakiiri nu wieeri, nyini awuru, wara miɛ ni sándi wɔ. ");
INSERT INTO cko_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Nyini ti, nzɛn má Sitana bo i ti ajinim kɛrɛ fɛmɛ n nya fɔn i ajinim fite minɛm ŋu, má nyini kere ka ba kpakpaaki nu lɛɛ. Ye i yó sɛ ye i fɛmɛya ni kóro jina a? ");
INSERT INTO cko_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Tɔ, ye nzɛn am ŋa Bɛlazɛbuli maari m yiko, ye m fa fɔn yi ajinim a, ye ŋma maari am dɛɛ minɛm ni yiko ye bu bita fɔn yi bu n a? Nyini ti, kabo am minɛm yoori ni, nyini kere ka am la má nahɔrɛ. ");
INSERT INTO cko_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ama, Nyɛmɛ dɛɛ Awiɛwiɛ ni ma m yiko ye m fa fɔn yi ajinim a. Nyini n kere ka Nyɛmɛ Fɛmɛ wo am nu suniɛ i minɛm su lɛɛ. ");
INSERT INTO cko_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Bekun, i bá yo sɛ ye be koro wura sɔnɔ faŋga­fɔ dika na i fin i neŋge a, má ka wɔ tara i faŋga­fɔ acin i nyama ka? Nyini sin na i nyá koro fin i neŋge bo i wo awuru n nu. ");
INSERT INTO cko_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Sɔnɔ kɛrɛ bo i jina má m sin, i mi ti m kpɔ­fɔ ɔ. Na sɔnɔ kɛrɛ gusu bo i buka má m na ya tiɛn minɛm nɔɔ, i mi sandi minɛm wɔ. ");
INSERT INTO cko_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Nyini ti, m suse am wɔ lɛɛ, ka, Nyɛmɛ koro fa minɛm satiɛ kɛrɛ fa ce bu, haari fa kɔ saŋga ni jɔrɛ ŋgbɛɛn­ŋgbɛɛn kɛrɛ bo bu jɔjɔɔri i fa kɔ Nyɛmɛ dɔ, ama, sɔnɔ kɛrɛ bo i jɔjɔ wuraari Awiɛwiɛ Casi ni ŋgasi nu, Nyɛmɛ fá má i mi ŋgasi ce má i. ");
INSERT INTO cko_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Sɔnɔ kɛrɛ bo i jɔjɔ wuraari mini Adamande Wa ni ŋgasi nu, Nyɛmɛ fá i mi ŋgasi ce i. Ama, sɔnɔ kɛrɛ bo i jɔjɔ wuraari Awiɛwiɛ Casi ni ŋgasi nu, Nyɛmɛ fá má i mi ŋgasi ce má i, fite kisa haari fa kɔ fa ba.” ");
INSERT INTO cko_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Na Yesu akaaki ase bu ka, “Baka kɛrɛ bo i nya ti kpa, su suu­wa kpa a, na baka kɛrɛ gusu bo i nya ti má kpa, su suu­wa tiɛtiɛ wɔ. Dama baka kɛrɛ suu­wa, ye a fa si kabo i ti a. ");
INSERT INTO cko_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ambɛrɛ burukɔɔ­nu­fɔm ka woom ni, kabo am ti satiɛ­yo­fɔm sɔ ni, am yo sɛ koro yo sakpa bekun a? Dama dekem n bo am sunsun bu am ahore su n ye am jɔjɔ bu a. ");
INSERT INTO cko_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Sɔnɔ kpa ni i deke kpa kɛrɛ bo i bita i, fa sakpa ba a. Na sɔnɔ tiɛ gusu ni i deke tiɛ bo i bita i, fa satiɛ ba a. ");
INSERT INTO cko_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","M suse am wɔ lɛɛ, ka, jina cɛɛn, Nyɛmɛ dí sɔnɔ kɛrɛ jɔrɛ fa kɔ jɔrɛ ŋgbɛɛn­ŋgbɛɛn kɛrɛ bo i yo jɔjɔɔri i. ");
INSERT INTO cko_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Dama u nɔaniɛ jɔjɔɔ­wa má a fite nu a, na u nɔaniɛ jɔjɔɔ­wa gusu má bu di u jɔrɛ cin u sui a.” ");
INSERT INTO cko_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Na Nyɛmɛ nɔaniɛ kere­fɔm, ni Farasi­fɔm nbem ase Yesu ka, “Ya Kere­fɔ, ya koro ka a yo alekutura sa be kere ya na ya ŋu i.” ");
INSERT INTO cko_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Na Yesu ase bu ka, “Ambɛrɛ nyuma­fɔ, satiɛ­yo­fɔm bo am su má Nyɛmɛ ni, ye am koro ka m yó alekutura sa be na am niɛ a? Ai, m yó má alekutura sa be na am ŋu i fieo, má ka alekutura sa n bo Nyɛmɛ yo yoori i maari i nɔaniɛ kan­fɔ Jona ni ŋgumi. ");
INSERT INTO cko_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Dama kabo Jona yo woori jombaa bambaka be kunnu kɔ juuri le­san, kɔŋguɛ ni wiɛsu ni, sɔ ye mini Adamande Wa ni bá wo asiɛn n bu kɔ ju le­san, kɔŋguɛ ni wiɛsu a. ");
INSERT INTO cko_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Jona yo kaanri Nyɛmɛ jɔrɛ kereeri Ninɛva­fɔm na ba kaaki bu wo. Jina cɛɛn, bɛrɛ bá yasu jina na bu járaki ambɛrɛ nyuma­fɔm, dama kisa, m suse am wɔ ka, mini tara Jona, ama, am akete ka am kaaki má am wo. ");
INSERT INTO cko_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Fɛmɛ bara be yo fiteeri haari i bɔsu Seba wɔ, na i bá ti Fɛmɛ Solomon dɛɛ alecira jɔjɔɔ­wa nɔaniɛ ni. Jina cɛɛn, yiri bá yasu jina na i járaki ambɛrɛ nyuma­fɔm nahɔrɛ su, dama kisa, m suse am wɔ ka, mini tara Fɛmɛ Solomon, ama, am ade má m nɔaniɛ ni.” ");
INSERT INTO cko_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Na Yesu akaaki ase bu ka, “Nzɛn ajini nya fite yakiiri sɔnɔ, i kɔ jeŋgbe bara yɛ boro kpantain nu wɔ, deke bo nzue wo má, na i kɔ niɛniɛ woo­biri bo i tana yi i ŋumi. Nzɛn wɔ nya má woo­biri, ");
INSERT INTO cko_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","nyini saŋga, a ti ka i ŋa, ‘Ma m kpie m nyi kɔ m woo­biri dawa ni.’ Na i kaaki kɔ, i kɔ ŋu ka ba kpara dika n nyunyumi, asɛsɛ deke kɛrɛ su, be wo má nu. ");
INSERT INTO cko_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Na i nyá kɔ fa ajinim nso, bo bu ti tiɛ tara yiri ni i tii, na bu kɛrɛ bá wura woo­biri dawa n nu. Nyini saŋga, a ŋu ka sɔnɔ n woo­wa ayo tiɛ atara kabo i yo ti dawa ni. Sɔ ye i bá yo ma ahin nyuma­fɔm bo bu satiɛ­yo asunnu n a.” ");
INSERT INTO cko_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu toko wo minɛm dɔ jɔjɔ su ni, na i ni, ni i niɛmam aba aka ajina dasin, na ba se ka bu koro ka bu jɔjɔ i dɔ ɔ. ");
INSERT INTO cko_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Na minɛm ni kun ase i ka, “Ti fɛn, u ni, ni u niɛmam jina dasin koro ka bu jɔjɔ u dɔ.” ");
INSERT INTO cko_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Sɔnɔ n seeri i sɔ wieeri ni, na Yesu ase i ka, “Ma m kere u bo bu ti m ni, ni m niɛmam.” ");
INSERT INTO cko_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Na wɔ fa i saa akere i susu­fɔm ni, na wɔ se ka, “Niɛ fɛn. M ni, ni m niɛmam n yaa. ");
INSERT INTO cko_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Dama sɔnɔ kɛrɛ bo i yo m Si Nyɛmɛ bo i wo aŋgoro n dɛɛ sa koroo­wa, yiri ti m siwa, ni m niwa, ni m ni a.” ");
INSERT INTO cko_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Nyini cɛɛn n na Yesu afite awuru n nu akɔ atana Galili kunma kpiri n nɔɔ su, ka i kan Nyɛmɛ jɔrɛ kere jama ni. ");
INSERT INTO cko_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Na jama beberebe atiɛn bu nɔɔ i dɔ. Bu sunnuuri beberebe sɔ n dɛɛ ti, na wɔ wura lee nu atana, na bɛrɛ aka ajina nzue n nɔɔ su. ");
INSERT INTO cko_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Na wɔ bo miɛɛnum na wɔ kere bu dekem beberebe. I ŋa, “Dɔdɔɔri­fɔ be fiteeri sɔ ɔ, ka i kɔ sandi alɛ­mbaa. ");
INSERT INTO cko_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Saŋga bo i wo sandi su ni, na alɛ­mbaa ni nbem atɔtɔ atin n nɔɔ, na anumam aba atambu bu ami. ");
INSERT INTO cko_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Na nbem atɔtɔ tiɛka su, deke bo fa sunnu má ni, fa n sunnu má n dɛɛ ti, wɔ cɛ má, na wɔ fi, ");
INSERT INTO cko_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ama, wiɛ ba fiteeri agaya ni, na ba waandi, dama bunlui n akpama abi má. ");
INSERT INTO cko_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Na alɛ­mbaa ni nbem atɔtɔ lɔlɔɛ nu, na lɔlɔɛ n anyi akata bu ŋu. ");
INSERT INTO cko_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ama, na alɛ­mbaa ni nbem atɔtɔ asiɛn kpa su, na wɔ nyi awura mbaa zɔi zɔi.” ");
INSERT INTO cko_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Na Yesu ase bu ka, “Bo i koro ka i ti ahin jɔrɛ n bu, i ti ye ni ka i so i sui na i ti.” ");
INSERT INTO cko_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Nyini sin na i susu­fɔm n aba i dɔ, aba abisa i ka, “Nzu ti ye a nya ba ŋa a jɔjɔ minɛm dɔ, a bo bu miɛɛnu a?” ");
INSERT INTO cko_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Na Yesu abɔ bu nu ka, “Ambɛrɛ ye Nyɛmɛ ma am asi i fɛmɛya n nu asiri jɔrɛ kɛrɛ a, ama, bɛrɛ bo ba ka ni, i ma bu si má i. ");
INSERT INTO cko_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Dama sɔnɔ kɛrɛ bo wɔ nya deke be Nyɛmɛ dɔ na i mi si i bita, Nyɛmɛ búka i su wɔ, na i nyá beberebe, ama, bo i si má i bita, haari ni nyini kaan n bo i la i ni, Nyɛmɛ dé i dɔ ɔ. ");
INSERT INTO cko_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Deke bo i ti na m bo bu miɛɛnu n la ka, bu niɛ wɔ, ama, bu ŋu má pui. Bu so bu sui wɔ, ama, bu ti má deke n bo bu so bu sui ka bu ti i n bu. ");
INSERT INTO cko_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Bu ti sɔ n dɛɛ ti, ye Nyɛmɛ nɔaniɛ kan­fɔ Esaya yo jɔjɔ niiri bu n a, i ŋa, ‘Nyɛmɛ ŋa o, Am só am sui ni nahɔrɛ su, ama, am tí má deke bo am so am sui ka am ti i n bu. Am káaki niɛ ni nahɔrɛ su, ama, am ŋú má pui. ");
INSERT INTO cko_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Dama ahin minɛm tii ti kekereke, ba tɔ bu sui na má bu ti, ba kata bu nyu­mbaa na má bu ŋu. Má nyini, bu nyu­mbaa ŋú i wɔ, na bu sui tí, na bu sí bu ahore su, na bu káaki bu wo, na m má bu nya laifiɛ.’ ");
INSERT INTO cko_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ama, ambɛrɛ la tere­fiɛ, dama am ŋu asi, na am kaaki ti asui. ");
INSERT INTO cko_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nahɔrɛ ye m suse am n a, Nyɛmɛ nɔaniɛ kan­fɔm ni minɛm beberebe bo bu yo sa bo i kɔ atin su Nyɛmɛ dɔ n kɛrɛ koroori ka bu ŋu deke bo am aŋu i ni, ama, ba ŋu má i, na ba koro ka bu ti deke bo am ati i ni, ama, ba ti má i.” ");
INSERT INTO cko_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Na Yesu ase i susu­fɔm ni ka, “Am so am sui, na m se am miɛɛnu n bu, fa kɔ dɔdɔɔri­fɔ n bo i sandiiri alɛ­mbaa n su. ");
INSERT INTO cko_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Nbem de Nyɛmɛ nɔaniɛ n fa kɔ i fɛmɛya n su kabo alɛ­mbaa n tɔtɔɔri atin nɔɔ n wɔ. Bu nya tiiri Nyɛmɛ nɔaniɛ n na bu ti má i bu, i cɛ má, na Sitana bo i ti sɔnɔ tiɛ ni, bá yi nɔaniɛ n fite bu ahore su, a ŋu ka bu wara afi i sa. ");
INSERT INTO cko_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Nbem gusu de Nyɛmɛ nɔaniɛ n kabo alɛ­mbaa tɔtɔɔri tiɛka su n wɔ. Bu nya tiiri Nyɛmɛ nɔaniɛ ni, a ŋu ka ba de i ndende ni ahorejɔ, ");
INSERT INTO cko_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ama, i da má bu ahore su. Bu kaaki ti ka alɛ­mbaa n bo bu bunlui akpama abi má n wɔ. I woori bu dɔ kaan sɔ, na nzɛn wahara, wara kekereke be ba tuuri bu, fa kɔ bu Nyɛmɛ su n su, a ŋu ka ba fa ati. ");
INSERT INTO cko_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Nbem gusu de Nyɛmɛ nɔaniɛ n kabo alɛ­mbaa n tɔtɔɔri lɔlɔɛ nu n wɔ. Bu nya tiiri Nyɛmɛ nɔaniɛ ni, a ŋu ka bu sunsunni kɛrɛ wo deke bo bu yó na bu asiri káta su, na bu koro kabo bu yó na bu nyá ajɛkɛ kɛrɛ, na bu ahore bi fa kɔ durunya n nu neŋgem su, na Nyɛmɛ nɔaniɛ n koro da má bu ahore su na i yo juma. Bu ti ka alɛ­mbaa n bo i wura má mbaa n wɔ. ");
INSERT INTO cko_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ama, nbem de Nyɛmɛ nɔaniɛ n kabo alɛ­mbaa n tɔtɔɔri asiɛn kpa su n wɔ. Bu nya tiiri Nyɛmɛ nɔaniɛ ni, na bu de i, na bu fa yo juma, na i yo kpɛrɛ beberebe.” ");
INSERT INTO cko_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Na Yesu abo bu miɛɛnu be bekun. I ŋa, “Kabo Nyɛmɛ Fɛmɛ bá niɛ i minɛm su yaa. Sɔnɔ be kɔ sandiiri nvoni i fiesu a. ");
INSERT INTO cko_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Cɛɛn n be kɔŋguɛ n sɔ ɔ, saŋga bo sɔnɔ kɛrɛ ada adaafi ni, na i kpɔ­fɔ be anya ayasu akɔ afa jaŋmɔŋgu nvoni asandi nvoni fie n nu. ");
INSERT INTO cko_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Saŋga bo nvoni n ba fi sukɔ nyinsɛ ni, na jaŋmɔŋgu nvoni n gusu atu asaŋga nvoni kpa n nu. ");
INSERT INTO cko_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Na awuru­fɔ­biɛ ni akɔɔm aba i dɔ, aba ase i ka, ‘Ya mibiɛ, m ŋa ya sandiiri nvoni kpa fie n nu e. Ye jaŋmɔŋgu nvoni n fiteeri ni, kɔ saŋgaari nu a?’ ");
INSERT INTO cko_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Na wɔ bɔ bu nu ka, ‘M kpɔ­fɔ be kɔ yoori nyini a.’ Na i akɔɔm n abisa i ka, ‘Ye a koro ka ya kɔ tutu jaŋmɔŋgu nvoni n butu wɔ, nzɛn sɛ a?’ ");
INSERT INTO cko_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Na wɔ bɔ bu nu ka, ‘Am yaki i, dama nzɛn am ŋa am tutu jaŋmɔŋgu nvoni ni, am sáŋga tutu i ni nvoni kpa n kɛrɛ wɔ. ");
INSERT INTO cko_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Am ma bu kɛrɛ saŋga nyi, haari nvoni n kpiɛ bá ju. Nyini saŋga na m nya se nvoni kpiɛ­fɔm ni ka bu kpiɛ i kɛrɛ na bu cin wɔrɔ jaŋmɔŋgu nvoni n tiɛn i nɔɔ yara i ka. Nyini saŋga na bu nya tiɛn nvoni kpa ba gɔ m bondo nu.’” ");
INSERT INTO cko_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Na Yesu abo bu miɛɛnu be bekun. I ŋa, “Kabo Nyɛmɛ fɛmɛya n ti yaa, i ti ka alɛ­mbaa kaan kabo nyɛm mbaa ti n wɔ, bo sɔnɔ be dɔɔri i fiesu ni. ");
INSERT INTO cko_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Yiri ti alɛ­mbaam kɛrɛ kaan, ama, bu nya ba dɔɔri na i fiiri, i tara toro nyawam n kɛrɛ bambaka, i koro nyi na i tɛtɛrɛki asa­mbaam bo anumam koro yo bu tiɛɛrim su.” ");
INSERT INTO cko_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Na Yesu akaaki abo bu miɛɛnu be bekun. I ŋa, “Kabo Nyɛmɛ fɛmɛya n ti yaa, i ti ka ayiri bo bu fa gɔ kpɔnɔ samɛnɛ nu na i yasu ni, na bara be fa gɔɔri samɛnɛ beberebe nu, na i kɛrɛ yasuuri n wɔ.” ");
INSERT INTO cko_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ahin n kɛrɛ, Yesu boori jama n miɛɛnu wɔ. Nahɔrɛ, i se má bu pui, má ka miɛɛnu ye i bo bu a. ");
INSERT INTO cko_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","I yoori sɔ, adena nɔaniɛ n bo Nyɛmɛ nɔaniɛ kan­fɔ n yo jɔjɔɔri n yo yii­wa a. I ŋa, “Nyɛmɛ ŋa o, ‘M bó bu miɛɛnu wɔ, na m má bu si deke n bo ba si má i, fite haari durunya n bumboori ni.’” ");
INSERT INTO cko_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Saŋga bo Yesu cin yakiiri jama n na i kɔ wuraari awuru n nu ni, na i susu­fɔm n aba i dɔ, aba ase i ka, “Ya koro ka a yi jaŋmɔŋgu nvoni n dɛɛ miɛɛnu n bu kere ya.” ");
INSERT INTO cko_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Na wɔ bɔ bu nu ka, “Sɔnɔ n bo i sandiiri nvoni kpa n la mini Adamande Wa ni. ");
INSERT INTO cko_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Fie n la durunya ni, na nvoni n la minɛm bo bu fa Nyɛmɛ yo bu fɛmɛ ni. Na jaŋmɔŋgu nvoni n la Sitana dɛɛ minɛm ni. ");
INSERT INTO cko_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ye kpɔ­fɔ n bo i fa jaŋmɔŋgu nvoni n saŋga nvoni kpa n nu n la Sitana. Nvoni kpiɛ saŋga n la durunya n awieeri, ye nvoni n kpiɛ­fɔm la Nyɛmɛ mɛrɛkɛm ni. ");
INSERT INTO cko_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Kabo bu tiɛntiɛɛnri jaŋmɔŋgu nvoni n nɔɔ, na bu yaraari i ni, sɔ ye i bá yo durunya n awieeri a. ");
INSERT INTO cko_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mini Adamande Wa ni súnma Nyɛmɛ mɛrɛkɛm, na bu bá tambu yi satiɛ­yo­fɔm kɛrɛ, ni deke kɛrɛ bo i wura minɛm konvi na bu yo satiɛ. ");
INSERT INTO cko_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Na Nyɛmɛ mɛrɛkɛm ni fá bu tu cɛɛma sin nu, dɔ na bu sún, na bu kán bu saa. ");
INSERT INTO cko_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Na bo bu yo Nyɛmɛ sa koroo­wa n yiri nya yo wein ka wiɛ, bu Si Nyɛmɛ fɛmɛya n nu. Bo i koro ka i ti ahin jɔrɛ n bu, i ti ye ni ka i so i sui na i ti.” ");
INSERT INTO cko_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Na Yesu akaaki abo bu miɛɛnu be bekun. I ŋa, “Kabo Nyɛmɛ Fɛmɛ niɛ i minɛm su yaa, i ti kabo sɔnɔ be kɔ ŋuuri ajɛkɛ be, bo ba fundu i ase fie be nu n wɔ. I ŋuuri i sɔ n na wɔ kaaki akata su, na ahorejɔ aba i dɔ agaya, na wɔ kɔ atɔ i neŋge kɛrɛ bo i la i ni, na wɔ kpie i nyi aba ato nyini asiɛn ni.” ");
INSERT INTO cko_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Na Yesu akaaki ase ka, “Bekun, kabo Nyɛmɛ Fɛmɛ niɛ i minɛm su yaa, i ti kabo wata­fɔ be bo i nati niɛniɛ afere fofoem bo bu la anyunuyi agaya na i to n wɔ. ");
INSERT INTO cko_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Saŋga bo i ba kɔ ŋuuri be bo i la anyunuyi na i la gɔ agaya ni, na wɔ kɔ atɔ i neŋge kɛrɛ, na wɔ fa ato i.” ");
INSERT INTO cko_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Na Yesu akaaki ase ka, “Bekun, kabo Nyɛmɛ Fɛmɛ niɛ i minɛm su yaa, i ti ka diɛndiɛ be bo bu fa sandiiri nzue nu, na bu taraari jombaa barasu barasu kɛrɛ n wɔ. ");
INSERT INTO cko_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Saŋga bo diɛndiɛ n yiiri ni jombaam ni, na ba cin i afite kpɛrɛ su, na ba tana ka bu yiyi jombaam ni. Bo bu nya ŋuuri ka bu ti kpakpam ni, na bu fa bɛrɛ ji bu jombaa tara bɔtɔm nu. Na bu nya fa bo bu ti má kpam fikindi tu. ");
INSERT INTO cko_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","I bá yo sɔ ɔ, durunya n awieeri, Nyɛmɛ má i mɛrɛkɛm ni nati ba yi satiɛ­yo­fɔm n fite bo bu yo sa bo i kɔ atin su Nyɛmɛ dɔ nu, ");
INSERT INTO cko_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","na i fa satiɛ­yo­fɔm ni tu cɛɛma sin nu. Dɔ na bu sún, na bu kán bu saa.” ");
INSERT INTO cko_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Na Yesu abisa bu ka, “Am ati ahin miɛɛnu n kɛrɛ bu?” Na ba bɔ i nu ka, “Ya ti i bu.” ");
INSERT INTO cko_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Na Yesu ase bu ka, “Tɔ, sɔnɔ kɛrɛ bo i kere Nyɛmɛ nɔaniɛ ni, na i siiri kabo Nyɛmɛ Fɛmɛ atin ti barasu, i mi ayo ka awuru­fɔ­biɛ bo i yi i neŋge fɔfɔrɛ ni i neŋge dawa fite i neŋge woo­biri sɔɔ n nu, na i fa ma minɛm wɔ.” ");
INSERT INTO cko_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Saŋga bo Yesu boori nyini miɛɛnu kɛrɛ kɔ wieeri ni, na wɔ yasu dika n nu dɔ. ");
INSERT INTO cko_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Na wɔ kpie i nyi akɔ i bɔsu. Na wɔ kan Nyɛmɛ jɔrɛ akere minɛm, bu tiɛntiɛn­bunɔɔ sɔɔ n nu. Na bo bu tiiri i keree­wa n kɛrɛ ayo alekutura. Na ba bisa bu ŋuŋu nu ka, “Nifansu ye ahin sɔnɔ n nyaari nyini alecira n ni yiko koro yo nyini alekutura sam n a? ");
INSERT INTO cko_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Má kampenta n wa n lɛɛ? Má i ni la Mariya a? Má Yakobo, ni Yosefu, ni Simon, ni Yudasi n gɔrɔ n lɛɛ? ");
INSERT INTO cko_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Am niɛ e. Má i niɛma nbaram kɛrɛ wo ya nu fɛn n a? Ye nifansu ye ahin sɔnɔ n kɔ sɔnsɔɔnri i si n kɛrɛ a?” ");
INSERT INTO cko_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Na ba bu i ŋgbɛɛn. Na Yesu ase bu ka, “Deke n kɛrɛ bu ma Nyɛmɛ nɔaniɛ kan­fɔ jirima a, má ka i bɔsu­fɔm, ni i gisan­nu­fɔm ŋgumi dɔ.” ");
INSERT INTO cko_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","I bɔsu­fɔm ayo má i yarada n dɛɛ ti, wɔ yo má alekutura sam beberebe dɔ. ");
INSERT INTO cko_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Nyini saŋga ni, na Fɛmɛ Herode ati Yesu ŋga. ");
INSERT INTO cko_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Na wɔ se i nkpiɛn­kpiɛnm bo bu wo i nyunu n ka, “Yohane Nyɛmɛ Nzue Biɛ­fɔ n lɛɛ, ye wɔ teŋge i yiwee n nu a, nyini ti ye i la yiko koro yo nyini alekutura sam kɛrɛ a.” ");
INSERT INTO cko_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Fɛmɛ Herode yo ma bu taraari Yohane nyiiri i wɔ, dama yiri Fɛmɛ Herode yo fiinri i gɔrɔ Filipu yi Herodiya jaari wɔ. ");
INSERT INTO cko_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Má pui ti, Yohane yo seeri Fɛmɛ Herode ka, “Nyɛmɛ nɔaniɛ kpamaa­wa n kere ka a la má atin ka a fa u gɔrɔ yi ja i ŋgɔɔ su.” ");
INSERT INTO cko_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Má Fɛmɛ Herode yo koroori ka i kun Yohane wɔ, ama, i soroori Yuda­fɔm jama n wɔ, dama ba se ka Yohane ti Nyɛmɛ nɔaniɛ kan­fɔ ɔ. ");
INSERT INTO cko_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Na Fɛmɛ Herode baa­wu cɛɛn­kpiri di cɛɛn, na Herodiya wa suŋguru agɔ agɔrɛ fɛmɛ ni i jama n kɛrɛ nyunu, na fɛmɛ n ahore ajɔ. ");
INSERT INTO cko_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Nyini ti, na wɔ tan ndiɛ ase suŋguru n ka, “Deke kɛrɛ bo a koro, se m, na m má u.” ");
INSERT INTO cko_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Na suŋguru n ni ase i ka i kɔ se ka i koro Yohane Nyɛmɛ Nzue Biɛ­fɔ n tii­awa a. Na wɔ kɔ ase fɛmɛ n ka, “M koro ka na a fa Yohane Nyɛmɛ Nzue Biɛ­fɔ n tii­awa ma m pɛrɛntɛ nu kisa kisa.” ");
INSERT INTO cko_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Fɛmɛ n tiiri sɔ ni, na i ahore asaaki, ama, ndiɛ n bo i taanri i jama n nyunu n dɛɛ ti, wɔ koro akaaki má i nɔɔ. Na wɔ ma nɔɔ ka bu yo suŋguru n koroo­wa ma i. ");
INSERT INTO cko_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Nyini ti, na wɔ ma bu akɔ akpiɛ Yohane tii dan­saraka sɔɔ n nu dɔ. ");
INSERT INTO cko_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Na ba fa i tii­awa n ada pɛrɛntɛ n nu, aba ama suŋguru ni, na yiri gusu afa akɔ ama i ni. ");
INSERT INTO cko_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Na Yohane susu­fɔm n aba afa fuin n akɔ ase i, na ba kɔ ama Yesu labari. ");
INSERT INTO cko_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesu tiiri Yohane n jɔrɛ labari n sɔ ni, na wɔ fa lee akɔ deke bo minɛ n wo má, i ni i susu­fɔm ŋgumi. Minɛm tiiri sɔ ni, na ba fite miɛ miɛm su anati bu jaa su, asa i su. ");
INSERT INTO cko_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Saŋga bo Yesu kɔ fiteeri lee n nu ni, na wɔ ŋu jama beberebe, na wɔ si bu aŋunfɔ, na wɔ ma tukpaki­fɔm bo bu woori dɔ n anya laifiɛ. ");
INSERT INTO cko_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Nyini cɛɛn n naasɔ saŋga, na i susu­fɔm n aba i dɔ, aba ase i ka, “Kisa wiɛ atɔ, ya wo boro gusu wɔ lɛɛ. Ma minɛm n atin na bu kɔ miɛ kunnu, na bu kɔ nya diire be to di.” ");
INSERT INTO cko_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Na Yesu ase bu ka, “I ti má deke bo bu kɔ pui, ambɛrɛ mmɔɔ ni am tii nya deke be ma bu na bu di.” ");
INSERT INTO cko_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Na ba se i ka, “Deke bo ya la i fɛn n kɛrɛ ti kpɔnɔ nnu wɔ, ni jombaa nnyɔ.” ");
INSERT INTO cko_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Na wɔ se bu ka, “Am fa bu ba ma m fɛn.” ");
INSERT INTO cko_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Na wɔ ma minɛm nɔɔ ka, bu tantana wura fiɛfiɛɛ­wa n su. Na wɔ fa kpɔnɔ nnu ni, ni jombaa nnyɔ ni, na wɔ yɛ i tii su aŋgoro na wɔ da Nyɛmɛ asi. Na wɔ nya akpiɛkpiɛ kpɔnɔ n nu afa ama i susu­fɔm ni, na bɛrɛ gusu afa ama minɛm ni. ");
INSERT INTO cko_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Na sɔnɔ kɛrɛ adi, na bu kunnu ayi. Na i susu­fɔm n atambu kpɔnɔ ni jombaa sinsin n bo bu diiri na i kaari ni, na ba nya kandiɛ buru ni nnyɔ. ");
INSERT INTO cko_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Minɛm bo bu diiri kpɔnɔ n ni jombaa n kɛrɛ kɔ yasuuri nbiɛsɔm akpii nnu wɔ, ba kan má nbaram ni nbaatumam awura má nu. ");
INSERT INTO cko_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Nyini sin na Yesu ama i susu­fɔm n awura lee n nu na bu du i mɔ kpiɛ kɔ kunma kpiri n buekun, na yiri aka na i kaari jama ni. ");
INSERT INTO cko_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","I kaariiri jama n wieeri ni, na wɔ fun akɔ kpɛrɛ be su i ŋgumi ka i kɔ sere Nyɛmɛ. Haari wiɛ ba tɔɔri kɛrɛ, i toko wo dɔ i ŋgumi. ");
INSERT INTO cko_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Nyini saŋga na lee n yiri wo nzue n afiɛn dede dɔ, na nzue nyama sukpara i, dama aŋuma sun bu kɔ bu sin wɔ. ");
INSERT INTO cko_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Na fa kɔ akɔnyuma ciciri su, na wɔ nati nzue n su suba bu dɔ. ");
INSERT INTO cko_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Saŋga bo bu ŋuuri ka i nati nzue n su ni, na sɛrɛ ati bu agaya, bu ŋa, “Ŋumi lɛɛ o.” Na ba bo awie, sɛrɛ n dɛɛ ti. ");
INSERT INTO cko_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Kpeŋga na Yesu ajɔjɔ bu dɔ, na wɔ se bu ka, “Am ma am ahore si, mini a, má am soro sɛrɛ.” ");
INSERT INTO cko_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Na Petoro ase i ka, “M Mibiɛ, nzɛn i ti wɔrɔ nahɔrɛ su a, se m ka m nati nzue n su bra u dɔ.” ");
INSERT INTO cko_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Na Yesu ase i ka, “Bra.” Na Petoro afite lee n nu sunati nzue n su sukɔ Yesu dɔ. ");
INSERT INTO cko_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ama, saŋga bo i ŋuuri ka aŋuma ni sukpiɛ agaya sɔ ni, na sɛrɛ akaaki ati i, kpeŋga i suwura nzue n bu. Na wɔ bo awie ase ka, “M Mibiɛ, de m tii ji.” ");
INSERT INTO cko_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Kpeŋga na Yesu alaandi i saa aso i nu, na wɔ se i ka, “Wɔrɔ, u yarada n ti kaan sɔ. Nzu ti ye u sunsunni ti nnyɔ nnyɔ a?” ");
INSERT INTO cko_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Na bu nnyɔ n kɛrɛ awura lee n nu, na aŋuma n atara. ");
INSERT INTO cko_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Na i susu­fɔm bo bu wo lee n nu n kɛrɛ akansi i, bu ŋa, “A ti Nyɛmɛ Wa a, nahɔrɛ su.” ");
INSERT INTO cko_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Na ba kpiɛ nzue n aba aju awɔrɛ n bo bu fere i ka Gɛnɛsarɛti ni. ");
INSERT INTO cko_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Na dɔ­fɔm asi ka Yesu lɛɛ, na ba sunma akɔ ase awɔrɛ n nu­fɔm kɛrɛ, na ba fa tukpaki­fɔm kɛrɛ aba Yesu dɔ, ");
INSERT INTO cko_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","na ba sere i jande ka i ma bu fa bu saa kan i tanlɛɛ n jaa bu. Na bo bu yoori sɔ n kɛrɛ anya laifiɛ. ");
INSERT INTO cko_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Na Farasi­fɔ nbem, ni Yuda­fɔm Nyɛmɛ nɔaniɛ kere­fɔm afite Yɛrusalem miɛ kpiri n nu aba Yesu dɔ, aba abisa i ka, ");
INSERT INTO cko_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Nzu ti ye u susu­fɔm n akete ya nam sa­yoo­wa n a? Dama bu ŋmisi má bu saa ka, na bu nya di diire.” ");
INSERT INTO cko_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Na Yesu abɔ bu nu ka, “Nzu ti ye am akete Nyɛmɛ nɔaniɛ maa­wa n ye am su am dɛɛ sa­yoo­wam su a? ");
INSERT INTO cko_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Dama Nyɛmɛ ama nɔɔ ka, ‘Bu u si, ni u ni.’ Ye wɔ kaaki ase ka, ‘Sɔnɔ kɛrɛ bo i jɔjɔɔri i si, ni i ni jɔrɛ tiɛ, wɔ yo daka ka bu kun i mi.’ ");
INSERT INTO cko_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ama, ambɛrɛ kere ka nzɛn sɔnɔ be la deke be bo i ti ye ni ka i fa buka i si, ni i ni, i koro se bu ka, ‘Deke bo má m ŋa m fa ma am ni, ma fa ayi saraka ama Nyɛmɛ.’ ");
INSERT INTO cko_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Am suse ka i mi koro kpiɛ i si, ni i ni n nyini deke n lɛɛ. Nyini n kere ka am abu Nyɛmɛ dɛɛ nɔaniɛ ni ŋgbɛɛn lɛɛ, ye am su am dɛɛ sa­yoo­wam n su a. ");
INSERT INTO cko_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ambɛrɛ burukɔɔ­nu­fɔm ni, nahɔrɛ ye Nyɛmɛ nɔaniɛ kan­fɔ Esaya yo kaanri am jɔrɛ n a. Wɔ kɛrɛ i kadasi n nu ka, Nyɛmɛ ŋa o, ");
INSERT INTO cko_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Ahin minɛm ni, bu ma m jirima bu nɔɔ nu bɛrɛ wɔ, ama, i wo má bu ahore su. ");
INSERT INTO cko_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Bu kansi m ŋgbɛɛn wɔ, dama bu kere minɛ adamande dɛɛ keree­wam wɔ, na bu se ka nyini keree­wa n fite Nyɛmɛ dɔ ɔ.’” ");
INSERT INTO cko_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Na Yesu afere jama n aba i bi, na wɔ se bu ka, “Am so am sui na am ti jɔrɛ n bo m sujɔjɔ i ma am n bu. ");
INSERT INTO cko_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Má diire bo i wura sɔnɔ nɔɔ nu n yo i fin a, ama, jɔjɔɔ­wa bo i fite sɔnɔ nɔɔ nu ni, yiri yo i fin a.” ");
INSERT INTO cko_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Na i susu­fɔm n aba i dɔ, aba abisa i ka, “A si ka u jɔrɛ n bo a jɔjɔɔri i n asun má Farasi­fɔm n nu e?” ");
INSERT INTO cko_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","14","Na Yesu ase i susu­fɔm n ka, “Má am bɔ bu nu, bu ti ka anyinsinm wɔ. Anyinsin gusu nya bitaari i beŋgu anyinsin n kpama, bu kɛrɛ kɔ́ to kunma nu wɔ. Baka kɛrɛ bo m Si Nyɛmɛ bo i wo aŋgoro n ata má i, i cín tu i wɔ.” ");
INSERT INTO cko_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Na Petoro ase i ka, “Kere ya anyundɛrɛ n bu, bo a ŋa sɔnɔ nɔaniɛ jɔjɔɔ­wa yo i fin ni.” ");
INSERT INTO cko_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Na Yesu abisa bu ka, “Ŋka ambɛrɛ gusu ati má jɔrɛ n bu lɛɛ? ");
INSERT INTO cko_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Deke bo i wura sɔnɔ nɔɔ nu, wura i kunnu wɔ, na i kɔ je yi i, má sɔ? ");
INSERT INTO cko_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ama, jɔjɔɔ­wa bo i fite sɔnɔ nɔɔ nu fite i ahore su wɔ, nyini yo i fin a. ");
INSERT INTO cko_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Dama deke bo i wo sɔnɔ ahore su ma i sunsunni tiɛ a. I koro ma i nati sukun minɛm, na i suyo sakaraya, na i susaaki ajaa ciire, na i suwɔ, na i nati sudi kɔrɛ daani, na i nati susaaki minɛm duma. ");
INSERT INTO cko_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Nyini dekem kɛrɛ koro yo sɔnɔ fin a. Ama, nzɛn sɔnɔ di diire na wɔ ŋmisi má i saa, i yo má i fin.” ");
INSERT INTO cko_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Na Yesu afite bɛrɛ akɔ awɔrɛ n bo i dodo Tiro ni Sidon miɛ kpirim ni. ");
INSERT INTO cko_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Na bara be aba Yesu dɔ, i ti má Yuda­fɔ, i ti Kanana­fɔ ɔ, bo i fite nyini awɔrɛ n nu. Na wɔ bo afere Yesu, ase i ka, “M Mibiɛ, Fɛmɛ Davidi anuma, si m aŋunfɔ. Ajinim wo m wa baa­bara ŋu, sukere i yaari agaya.” ");
INSERT INTO cko_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ama, Yesu abɔ má i nu. Na i susu­fɔm n aba i dɔ, aba asere i jande, ase i ka, “Fɔn bara n na i kɔ. Niɛ kabo i su ya su, yo naŋmiɛ barasu a.” ");
INSERT INTO cko_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Na Yesu ase ka, “Nyɛmɛ asunma m Yisareli­fɔm bo bu ti ka nbɔɛm na ba mini ni ŋgumi dɔ a.” ");
INSERT INTO cko_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Na bara n aba akutu i nyunu, ase i ka, “M Mibiɛ, buka m.” ");
INSERT INTO cko_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Na Yesu ase i ka, “I ti má ye ni ka, a fa nbaatumam diire na a fa ma caam.” ");
INSERT INTO cko_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Na bara n ase i ka, “M Mibiɛ, a la nahɔrɛ, ama, haari ni nyini mmɔɔ, caam n tambu diire n bo bu fɔm di, na i tɔtɔ asiɛŋgu n na bu fa di.” ");
INSERT INTO cko_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Na Yesu ase i ka, “A ti bara yarada­yo­fɔ ɔ, nahɔrɛ su. Nyini ti, kabo a koro ni, i yó sɔ ma u a.” Dika n nu bɛrɛ, na i wa n anya laifiɛ. ");
INSERT INTO cko_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Na Yesu afite bɛrɛ, asu Galili kunma kpiri n su, na wɔ kɔ afun atana buka be su. ");
INSERT INTO cko_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Na jama beberebe afa wɔbukam, ni anyinsinm, ni bo bu saam ni bu jaam awu ni, ni bobom, ni tukpaki­fɔm beberebe, ka i ma bu laifiɛ, na wɔ ma bu anya laifiɛ. ");
INSERT INTO cko_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Na minɛm n ayo alekutura, ni kabo bu ŋuuri ka bobom sujɔjɔ, na minɛm bo bu saam ni bu jaam awu n anya laifiɛ, na wɔbukam sunati, na anyinsinm suŋu asi ni, na ba kansi Nyɛmɛ n bo bɛrɛ Yisareli­fɔm su i ni. ");
INSERT INTO cko_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Na Yesu afere i susu­fɔm ni, na wɔ se bu ka, “Ahin jama n la m aŋunfɔ, dama i nyuma le­san lɛɛ bo bu wo m dɔ na bu la má deke bo bu di. M koro má ka m yaki bu na bu kɔ awuru ni ahɔɛ, má nyini, bu nbem tɔ́ cin atin nu wɔ.” ");
INSERT INTO cko_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Na i susu­fɔm n abisa i ka, “Ye nifansu ye ya nyá diire ma ahin jama beberebe n sɔ n na bu di na bu kunnu yi a?” ");
INSERT INTO cko_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Na Yesu abisa bu ka, “Am la kpɔnɔ nyɛ wɔ?” Na ba bɔ i nu ka, “Ya la kpɔnɔ nso wɔ, ni jombaa kan kan nbem.” ");
INSERT INTO cko_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Na Yesu ama jama n nɔɔ ka bu tana asiɛŋgu. ");
INSERT INTO cko_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Na wɔ fa kpɔnɔ nso n ni jombaa ni, na wɔ da Nyɛmɛ asi, na wɔ kpiɛkpiɛ i nu, na wɔ fa ama i susu­fɔm ni, na bɛrɛ gusu afa ama jama n ka bu di. ");
INSERT INTO cko_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Bu kɛrɛ diiri, na bu kunnu ayi. Na i susu­fɔm n atambu sinsin kaa­wa n kandiɛ nso. ");
INSERT INTO cko_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Minɛm bo bu diiri diire ni, nbiɛsɔm ŋgumi kɔ yasuuri akpii nna a, ba kan má nbaram ni nbaatumam awura má nu. ");
INSERT INTO cko_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Na Yesu anya kaari jama ni, na ba kɔ awuru, na wɔ nya awura lee nu, akɔ awɔrɛ n bo bu fere i ka Magadan n nu. ");
INSERT INTO cko_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Na Farasi­fɔm, ni Sadusi­fɔ nbem aba Yesu dɔ, na ba koro ka bu sɔ i ŋgɛɛ. Nyini ti, na ba se i ka i yo alekutura sa be bo i kere ka i yiko n fite Nyɛmɛ dɔ ɔ. ");
INSERT INTO cko_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Na Yesu ase bu ka, “Saŋga bo wiɛ nya ba sutɔ, na am ŋu ka aŋgoro n kɛrɛ ayo kɔkɔrɛ, a ti ka am ŋa, ‘Ahunma dika ni bó, dama i ti kɔkɔrɛ wɔ.’ ");
INSERT INTO cko_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Nzɛn ŋgarama fuun, na am ŋu ka aŋgoro asaŋga kɔkɔrɛ ni biri, a ti ka am ŋa, ‘Nyuma nzue tɔ́.’ Am koro niɛ aŋgoro n na am si sa bo i bá yo, ama, am koro si má sam bo bu suyo jina n nu n yiri bu. ");
INSERT INTO cko_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ambɛrɛ nyuma­fɔ, satiɛ­yo­fɔm bo am su má Nyɛmɛ ni, ye am koro ka m yó alekutura sa be na am niɛ? Ai, m yó ma alekutura sa be na am ŋu i fieo, má ka alekutura sa n bo Nyɛmɛ yo yoori i maari Jona ŋgumi ni.” I seeri sɔ wieeri ni, na wɔ yaki bu, na wɔ kɔ. ");
INSERT INTO cko_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Saŋga bo Yesu susu­fɔm n kpiɛ kɔ juuri kunma kpiri n bue kun dɔ ni, na bu wara afi diire sa, ba bita má kpɔnɔ nu. ");
INSERT INTO cko_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Na Yesu ase bu ka, “Am si am ŋu sa ni Farasi­fɔm ni Sadusi­fɔm dɛɛ kpɔnɔ ayiri n bo bu fa gɔ kpɔnɔ nu na i yasu ni.” ");
INSERT INTO cko_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Na ba se bu ŋuŋu nu ka, “Ya bita má kpɔnɔ aba má n dɛɛ ti, ye i se sɔ n a.” ");
INSERT INTO cko_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Na Yesu afa nu kabo i susu­fɔm n sujɔjɔ bu ŋuŋu nu ni, na wɔ se bu ka, “Ambɛrɛ bo am yarada n ti kaan sɔ ni, nzu ti ye am sujɔjɔ am ŋuŋu nu ka am bita má kpɔnɔ a? ");
INSERT INTO cko_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Am nya ti má sa n bu, nzɛn sɛ? Am teŋge má su ka m yo faari kpɔnɔ nnu kpiɛkpiɛ maari minɛ akpii nnu? Ye bo i kaari ni, kandiɛ nyɛ ye am sasaari a? ");
INSERT INTO cko_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ye kpɔnɔ nso n bo m yo fa kpiɛkpiɛ maari minɛ akpii nna n di? Kandiɛ nyɛ ye am sasaari a? ");
INSERT INTO cko_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ye nzu ti ye am si má ka m sujɔjɔ má kpɔnɔ jɔrɛ a? M ŋa am si am ŋu sa ni Farasi­fɔm ni Sadusi­fɔm dɛɛ kpɔnɔ ayiri n bo bu fa gɔ kpɔnɔ nu na i yasu ni.” ");
INSERT INTO cko_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Na ba nya asi ka i suse má bu ka bu si bu ŋu sa ni Farasi­fɔm ni Sadusi­fɔm dɛɛ kpɔnɔ ayiri n wɔ, ama, i ŋa bu si bu ŋu sa fa kɔ bu keree­wa n dɛɛ atin su wɔ. ");
INSERT INTO cko_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Saŋga bo Yesu fa ba juuri Sizariya Filipiya dɛɛ miɛ kan kanm su ni, na wɔ bisa i susu­fɔm ka, “Minɛm fa mini Adamande Wa n bu ŋma a?” ");
INSERT INTO cko_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Na ba bɔ i nu ka, “Nbem ŋa wɔrɔ la Yohane Nyɛmɛ Nzue Biɛ­fɔ n a, nbem ŋa wɔrɔ la Nyɛmɛ nɔaniɛ kan­fɔ Eliya, nbem ŋa wɔrɔ la Nyɛmɛ nɔaniɛ kan­fɔ Jeremiya, ye nbem gusu ŋa a ti dawa dɛɛ Nyɛmɛ nɔaniɛ kan­fɔ nyiŋgam n kun wɔ.” ");
INSERT INTO cko_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Na wɔ nya abisa bu bekun ka, “Ye ambɛrɛ fa m bu ŋma a?” ");
INSERT INTO cko_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Na Simon Petoro abɔ i nu ka, “Wɔrɔ ti Kristo Tii­de­fɔ n a, Nyɛmɛ n bo i wo bɛrɛ saŋga kɛrɛ n dɛɛ Wa ni.” ");
INSERT INTO cko_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Na Yesu ase i ka, “Simon Jona wa, tere­fiɛ wo u dɔ. Dama má adamande yiiri ahin jɔrɛ n bu kereeri u ka a jɔjɔ a, ama, m Si Nyɛmɛ bo i wo aŋgoro ni yi kereeri u a. ");
INSERT INTO cko_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nyini ti, m suse u wɔ lɛɛ ka, wɔrɔ ti Petoro a, u duma bu la ka yabuɛ ni. Nyini yabuɛ n su ye m ma m jama minɛm kɛrɛ jina a, na yiwee mmɔɔ koro yo má bu pui. ");
INSERT INTO cko_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","M fá Nyɛmɛ fɛmɛya n anɔ kadombaam ma u, na deke kɛrɛ bo a ma minɛm atin ka bu yo i durunya n nu fɛn, i ti sɔ ɔ lɛɛ, Nyɛmɛ dɔ. Na deke kɛrɛ bo a ma má minɛm atin ka bu yo i durunya n nu fɛn, i kaaki ti sɔ ɔ lɛɛ, Nyɛmɛ dɔ.” ");
INSERT INTO cko_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Nyini sin, na Yesu abɔbɔ i susu­fɔm ni ka má bu ma be si ka yiri ti Kristo Tii­de­fɔ n a. ");
INSERT INTO cko_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Fite nyini saŋga n fa kɔ, na Yesu abo i bu sukere i susu­fɔm n ka, “Wɔ yo daka ka m kɔ Yɛrusalem na m kɔ di wahara dɔŋgu fite Yuda­fɔm nkpiɛn­kpiɛnm, ni Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ nkpiɛn­kpiɛnm, ni Nyɛmɛ nɔaniɛ kere­fɔm dɔ na bu kún m. Ama, na i le­san cɛɛn, na Nyɛmɛ má m teŋge m yiwee n nu.” ");
INSERT INTO cko_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Na Petoro afa i akɔ ahɛmɛ, na wɔ jaraki i ase i ka, “M Mibiɛ, má a se ka a se sɔ, Nyɛmɛ yo u kisi ni nyini sa ni. Nyini koro yo má cɛɛn be da.” ");
INSERT INTO cko_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Na Yesu acɛ aniɛ Petoro na wɔ tiɛn i ŋu ase i ka, “Sitana, fa cinsi m bi bɛrɛ. A sukanda m atin wɔ. A sunsun má kabo Nyɛmɛ sunsun ni. A sunsun kabo adamande sunsun n wɔ.” ");
INSERT INTO cko_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Na Yesu ase i susu­fɔm n ka, “Sɔnɔ kɛrɛ bo i koro ka i su m su, wɔ yo daka ka i mi wara fi i tiɛŋgu sa koroo­wa sa, na i fa i yiwee baka jaanu n sɔ, na i su m su. ");
INSERT INTO cko_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Dama sɔnɔ kɛrɛ bo i koro ka i fa i ŋgɔɔ fiɛ, i mi bá fun i. Ama, sɔnɔ kɛrɛ bo i tɔɔri i ŋgɔɔ mini ni m labari kpa n dɛɛ ti, i mi nyá ŋgɔɔ. ");
INSERT INTO cko_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Nzɛn sɔnɔ nyaari durunya n nu deke n kɛrɛ, na i fuunri i ŋgɔɔ, i kpɛrɛ la bɔnɔ? Nzu deke ye sɔnɔ fá kaaki i ŋgɔɔ a? ");
INSERT INTO cko_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Dama mini Adamande Wa ni bá ba ni m Si Nyɛmɛ jirima woo­wa n nu, ni i mɛrɛkɛm ni, na m nyá tɔ sɔnɔ kɛrɛ kaari, kabo i juma, wara i sa­yoo­wa ti barasu. ");
INSERT INTO cko_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nahɔrɛ ye m suse am n a, am nbem wo fɛn bo am wu má, má ka am aba aŋu ka mini Adamande Wa ni suba ka m bá niɛ m fɛmɛya n su.” ");
INSERT INTO cko_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Le­sɛn cɛɛn sin na Yesu afa Petoro, ni Yakobo, ni yiri Yakobo niɛma Yohane, afun akɔ buka lenleŋge be su, bu ni yiri ŋgumi. ");
INSERT INTO cko_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Bu woori dɔ n na ba ŋu ka i ŋuniɛ akaaki wo, na i nyunuawa aje ka wiɛ, na i tanlɛɛ n akaaki fofoe papasi. ");
INSERT INTO cko_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Dɔ na ba ŋu minɛ nnyɔ nbem atiɛ bu ŋu, na bu ni Yesu subo anzama, bɛrɛ la Moyisi ni Eliya, dawa dɛɛ Nyɛmɛ nɔaniɛ kan­fɔm ni. ");
INSERT INTO cko_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Na Petoro ase Yesu ka, “M Mibiɛ, i ti kpa ka na ya wo fɛn. Nzɛn má a soro su, m bó nambue nsan fɛn, u dɛɛ kun, Moyisi kun, na Eliya gusu dɛɛ kun.” ");
INSERT INTO cko_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Saŋga bo i jina wo jɔjɔɔri su n na yinyiŋgu papasi akata bu ŋu, na ba ti akonvi be ŋga yinyiŋgu n nu, na wɔ jɔjɔ bu dɔ, i ŋa, “M wa koroo­wa lɛɛ bo m ahore ajɔ i ŋu. Am de i nɔaniɛ.” ");
INSERT INTO cko_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","I susu­fɔm n tiiri akonvi ni ŋga sɔ ni, na sɛrɛ ati bu agaya, na ba butu asiɛŋgu. ");
INSERT INTO cko_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Na Yesu aba afa i saa akan bu, na wɔ se ka, “Má am ma sɛrɛ ti am, am yasu.” ");
INSERT INTO cko_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Na ba yɛ bu tii su aniɛ, ba ŋu má sɔnɔ be kun, má ka Yesu ŋgumi. ");
INSERT INTO cko_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Na saŋga bo bu ba sujura buka n su ni, na Yesu abɔbɔ bu ka, “Má am be se ka i bo sa n bo am aŋu i n sufa kere sɔnɔ be, haari fa kɔ saŋga bo mini Adamande Wa ni bá wu na Nyɛmɛ bá ma m teŋge m yiwee n nu ka.” ");
INSERT INTO cko_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Dɔ na i susu­fɔm n abisa i ka, “Ye nzu ti ye Nyɛmɛ nɔaniɛ kere­fɔm n bita jɔjɔ ka wɔ yo daka ka Eliya dú mɔ ba ka, ye Kristo Tii­de­fɔ ni bá ba n a?” ");
INSERT INTO cko_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Na wɔ bɔ bu nu ka, “I ti nahɔrɛ wɔ ka, Eliya dú mɔ ba na i bá sɛsɛ deke n kɛrɛ su. ");
INSERT INTO cko_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ama, m suse am wɔ lɛɛ, ka, Eliya adu mɔ aba, na minɛm asi má i, na ba yo i kabo bu koro. Sɔ ye mini Adamande Wa n gusu bá di wahara minɛm saa nu a.” ");
INSERT INTO cko_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Dɔ na i susu­fɔm n anya asi ka i jɔjɔ Yohane Nyɛmɛ Nzue Biɛ­fɔ n dɛɛ jɔrɛ wɔ. ");
INSERT INTO cko_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Saŋga bo Yesu ni i susu­fɔ nsanm ni kpieeri bu nyi ba juuri jama n bi ni, na sɔnɔ be aba akutu i nyunu, ");
INSERT INTO cko_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ase i ka, “M Mibiɛ, si m wa baa­biɛsɔ n aŋunfɔ. I tɔ ŋgbiti wɔ, bo i di wahara agaya. Saŋga kɛrɛ bo i nya ba yasu i ŋu, i fa i wura sin nu wɔ, wara nzue nu. ");
INSERT INTO cko_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ma fa i aba u susu­fɔm n dɔ lɛɛ ka bu ma i nya laifiɛ, ama, ba koro atuntun má i na i nya laifiɛ.” ");
INSERT INTO cko_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Na Yesu ase bu ka, “Amaa. Ambɛrɛ satiɛ­yo­fɔm, am la má yarada fieo. Nyuma sa ye m wo am dɔ fɛn a? Ye m yó sawɔrɛ ni ambɛrɛ kɔ ju sɛ wɔ? Am fa baa n ba ma m fɛn.” ");
INSERT INTO cko_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Na Yesu atiɛn ajini n ŋu, na wɔ fite ayaki baa ni. Dika n nu bɛrɛ, na baa n anya laifiɛ. ");
INSERT INTO cko_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Nyini sin na Yesu susu­fɔm n aba i dɔ, bɛrɛ ŋgumi, aba abisa i ka, “Nzu ti ye yɛrɛ akoro afɔn má nyini ajini n a?” ");
INSERT INTO cko_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Na Yesu abɔ bu nu ka, “I fite ka am yarada n ti kaan sɔ n dɛɛ ti a. Nahɔrɛ ye m suse am n a, nzɛn am yoori Nyɛmɛ yarada bo i kɔ juuri kabo nyɛm mbaa ti ni mmɔɔ, am koro se nyini buka n ka, ‘Fite fɛn kɔ dɔ,’ na i kɔ. Deke wo má bɛrɛ bo i yó kekereke ma am.  ");
INSERT INTO cko_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ama, nyini ajini n ŋusu sɔ koro fite yaki má sɔnɔ ŋgbɛɛn sɔ, má ka nyɛmɛsere ni nɔɔ cici.” ");
INSERT INTO cko_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Saŋga bo i susu­fɔm ba tiɛɛnri bu nɔɔ Galili awɔrɛ n nu ni, na Yesu ase bu ka, “Bu bá tɔ mini Adamande Wa n ma minɛ nbem, ");
INSERT INTO cko_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","na bu kún m, ama, bu kuunri m wieeri, i le­san cɛɛn, Nyɛmɛ má m teŋge m yiwee n nu.” I jɔjɔɔri sɔ ni, na i susu­fɔm n ahore asaaki agaya. ");
INSERT INTO cko_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Saŋga bo Yesu ni i susu­fɔm n ba juuri Kapɛnam miɛ kpiri n nu ni, na Nyɛmɛ Seree­biri Awuru n nu lampo­de­fɔm n aba Petoro dɔ, aba abisa i ka, “Am kpiɛn n tɔ Nyɛmɛ Seree­biri Awuru n nu lampo kaari, nzɛn i tɔ má?” ");
INSERT INTO cko_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Na Petoro abɔ i nu ka, “I tɔ wanla.” Saŋga bo Petoro kɔ juuri awuru n nu n na Yesu adu mɔ abisa i dɔ ka, “Simon, ye wɔrɔ ŋa sɛ wɔ? Ŋmam tɔ lampo ŋwaa ma durunya n nu fɛn nfɛmɛm a, miɛnbaam nzɛn wɔfɔm?” ");
INSERT INTO cko_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Na Petoro abɔ i nu ka, “Wɔfɔm.” Na Yesu ase i ka, “Nzɛn i nya tiiri sɔ de, miɛnbaam tɔ má lɛɛ. ");
INSERT INTO cko_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ama, yɛrɛ koro má ka ya wura bu ŋgasi nu. Nyini ti, kɔ kunma kpiri n nu na a kɔ fa u kuwa n ji nu, jombaa kɛrɛ bo a du mɔ taraari i, niɛ i nɔɔ nu, a ŋú ŋwaa bo i ju mini ni wɔrɔ dɛɛ Nyɛmɛ Seree­biri Awuru n nu lampo ŋwaa tɔ. Fa i na a fa kɔ tɔ mini ni wɔrɔ tii su kaari.” ");
INSERT INTO cko_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Nyini saŋga ni, na Yesu susu­fɔm n aba i dɔ, aba abisa i ka, “Ŋma yo ya kɛrɛ tii Nyɛmɛ fɛmɛya n nu a?” ");
INSERT INTO cko_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Dɔ na Yesu afere baa kaan be, aba ajina bu afiɛn. ");
INSERT INTO cko_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Na wɔ se ka, “Nahɔrɛ ye m suse am n a, am wúra má Nyɛmɛ fɛmɛya n nu, má ka am kaaki am wo na am yo am ŋu ka baatuma kaan. ");
INSERT INTO cko_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Nyini ti, sɔnɔ kɛrɛ bo i yo i ŋu kaan ka ahin baa ni, yiri ti minɛm kɛrɛ tii Nyɛmɛ fɛmɛya n nu a. ");
INSERT INTO cko_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Sɔnɔ kɛrɛ bo i deeri ahin baa­kan n ŋusu m dɛɛ ti, wɔ de mini wɔ lɛɛ.” ");
INSERT INTO cko_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Na Yesu akaaki ase ka, “Wɔrɔ kɛrɛ bo u sa­yoo­wa ma ahin nbaatuma kan kanm n be bo i yo m yarada n be wuraari satiɛ nu ni, i ti má kpa. Nzɛn má bu faari ŋgani san yabuɛ bambaka ciciiri u kɔm na bu fa u kɔ tu tieku nu ka nzue di u, i ti ye tara bo a ma ahin nbaatuma kan kanm n be wura satiɛ nu ni. ");
INSERT INTO cko_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Durunya n nu­fɔm bá ŋu anyum­boro, dama bu yo sam bo bu ma minɛ kaaki bu sin bo m dɛɛ atin n wɔ. Nyini sam ni yo wɔ, saŋga kɛrɛ, ama, sɔnɔ kɛrɛ bo i ma nyini sam yoori ni, yiri bá ŋu anyum­boro. ");
INSERT INTO cko_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Nzɛn u saa, wara u jaa cin u wura satiɛ nu a, kaba kpiɛ i fa tu na a ka asaasin, wara, ajaasin, na a nyá u ŋu kɔ Nyɛmɛ dɔ. I ti ye ni bo a la u saa nnyɔ ni u jaa nnyɔ n kɛrɛ, na bu ba fa u tu cɛɛma sin n bo i nɔ má n nu. ");
INSERT INTO cko_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Nzɛn u nyu­mbaa kun gusu cin u wura satiɛ nu a, lokoti yi i tu na a ka anyunu kun, na a nyá u ŋu kɔ Nyɛmɛ dɔ. I ti ye ni bo a la u nyu­mbaa nnyɔ n kɛrɛ na bu ba fa u tu cɛɛma sin nu ni.” ");
INSERT INTO cko_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Na Yesu ase ka, “Má am se ka am bu ahin nbaatuma kan kanm n be ŋgbɛɛn. M suse am wɔ lɛɛ, ka, bu dɛɛ mɛrɛkɛm bo bu wo aŋgoro ni, wo m Si Nyɛmɛ nyunu saŋga kɛrɛ a.  ");
INSERT INTO cko_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Dama, mini Adamande Wa n baari ka m ba niɛniɛ bo ba mini n wɔ, na m de bu tii ji. ");
INSERT INTO cko_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Nzɛn sɔnɔ la nbɔɛm yaa, na bu nu kun miniiri, am sunsun ka i yo sɛ wɔ? I yáki abura­ŋgɔna ni ŋgɔna n wura dii­biri kpɛrɛ n su, na i kɔ́ niɛniɛ kun n bo wɔ mini ni, má sɔ? ");
INSERT INTO cko_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nahɔrɛ ye m suse am n a, nzɛn i niɛniɛ kɔ ŋuuri nyini kun ni, i ahore jɔ i ŋu tara abura­ŋgɔna ni ŋgɔna n bo ba mini má ni. ");
INSERT INTO cko_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","I ti sɔ ɔ lɛɛ, am Si Nyɛmɛ bo i wo aŋgoro n dɔ, i koro má ka ahin nbaatumam kun n kpein mmɔɔ mini.” ");
INSERT INTO cko_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Na Yesu akaaki ase ka, “Nzɛn wɔrɔ kɛrɛ bo u niwa yoori u satiɛ be, kɔ i dɔ na u ni yiri minɛ nnyɔ ni ŋgumi, na a se i ka wɔ yo u satiɛ. Nzɛn i tiiri i bu ka wɔ yo u satiɛ, i toko ti u niwa lɛɛ. ");
INSERT INTO cko_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ama, nzɛn i keteeri, yo aniɛ na a nya sɔnɔ kun, wara minɛ nnyɔ buka u ŋu su, na am kɔ ŋu i, adena minɛ nnyɔ, wara minɛ nsan n bo ba ti jɔrɛ n yo u daani­fɔm. ");
INSERT INTO cko_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Nzɛn i keteeri bɛrɛ gusu, na a nya fa i sereya n kɔ Kristo jama n kɛrɛ dɔ. Nzɛn i nya keteeri Kristo jama ni, am fa i ka sɔnɔ bo i su má Nyɛmɛ, wara satiɛ­yo­fɔ bo wɔ kete ka i kaaki má i wo lɛɛ.” ");
INSERT INTO cko_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Na Yesu akaaki ase ka, “Nahɔrɛ ye m suse am n a, deke kɛrɛ bo am ma minɛm atin ka bu yo i durunya n nu fɛn, i ti sɔ ɔ lɛɛ Nyɛmɛ dɔ, na deke kɛrɛ bo am ma má minɛm atin ka bu yo i durunya n nu, i kaaki ti sɔ ɔ lɛɛ Nyɛmɛ dɔ. ");
INSERT INTO cko_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Nahɔrɛ ye m suse am bekun n a, saŋga kɛrɛ bo am minɛ nnyɔ yoori am nɔɔkun, na am sereeri m Si Nyɛmɛ deke be, i yó i ma am. ");
INSERT INTO cko_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Dama deke kɛrɛ bo minɛ nnyɔ, wara nsan tiɛɛnri bu nɔɔ m dɛɛ duma n nu, m wo bu dɔ.” ");
INSERT INTO cko_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Nyini sin na Petoro aba Yesu dɔ, aba abisa i ka, “M Mibiɛ, nzɛn m niwa nati yo m satiɛ saŋga kɛrɛ, kpe nyɛ ye m fa i satiɛ ce i a? Kpe nso, nzɛn sɛ?” ");
INSERT INTO cko_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Na Yesu abɔ i nu ka, “Ai, m suse u wɔ lɛɛ ka, má kpe nso co, ama, kpe abura­soso busu nso.” ");
INSERT INTO cko_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Na Yesu akaaki ase ka, “Nyini ti, kabo Nyɛmɛ fɛmɛya n ti yaa. Fɛmɛ be yo woori bɛrɛ a, cɛɛn n be na wɔ se ka i bu akunta ni i akɔɔm bo bu wo i dɔ yo juma ni, na i si ŋwaa bo bu bita i. ");
INSERT INTO cko_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Saŋga bo i boori i bu na i bu akunta ni, na ba fa i akɔɔ n kun be bo i bita i ŋwaa kaari bo i la má nɔɔ, aba i dɔ. ");
INSERT INTO cko_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Kabo ŋwaa n sunnu sɔ na i koro tɔ má kaari n ni, na fɛmɛ n ama nɔɔ ka bu tɔ i ni i yi, ni i nbaam, ni i deke kɛrɛ bo i la i, na bu fa tɔ kaari ni. ");
INSERT INTO cko_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Na akɔɔ n akutu i mibiɛ n nyunu asiɛŋgu, asere i ka, ‘Jande, si m aŋunfɔ, na m kɔ́ niɛniɛ ŋwaa n na m bá tɔ kaari ni.’ ");
INSERT INTO cko_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Na i mibiɛ n asi i aŋunfɔ, na wɔ fa kaari n ace i, na wɔ yaki i aji. ");
INSERT INTO cko_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","I fiteeri bɛrɛ, na i ni i beŋgu akɔɔ n kun be bo i gusu bita i kaari n ayɛ, i dɛɛ n sunnu má fieo. Na wɔ so i beŋgu n kɔm nu amiɛ i, na wɔ se i ka, ‘Tɔ m kaari n kisa kisa bɛrɛ.’ ");
INSERT INTO cko_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Na i beŋgu n akutu haari asiɛŋgu, asere i ka, ‘Jande, si m aŋunfɔ, na m kɔ́ niɛniɛ u ŋwaa na m bá tɔ u kaari.’ ");
INSERT INTO cko_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ama, na wɔ kete, na wɔ kɔ anyi i beŋgu n saraka, na wɔ se i ka má ka wɔ tɔ i kaari ni. ");
INSERT INTO cko_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","I beŋgu nyiŋgam ŋuuri sa n bo wɔ yo i n sɔ ni, na bu ahore asaaki agaya, na ba kɔ ase fɛmɛ n sa n bo wɔ yo i n kɛrɛ. ");
INSERT INTO cko_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Dɔ na fɛmɛ n afere i, ase i ka, ‘Wɔrɔ satiɛ­yo­fɔ ŋgbɛɛn ni, a sereeri m dɛɛ ti, ye m yakiiri u kaari n kɛrɛ bo a bita i n fa ceeri u a. ");
INSERT INTO cko_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Má wɔ yo daka ka wɔrɔ mmɔɔ siiri u beŋgu n aŋunfɔ na a fa ce i, kabo m ŋuuri u aŋunfɔ na m fa ceeri u ni.’ ");
INSERT INTO cko_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Na yaa ati fɛmɛ n agaya, na wɔ ma bu afa nyini akɔɔ n akɔ anyi i saraka, ka i kɔ di wahara dɔ, haari fa kɔ ju saŋga bo i bá tɔ kaari n kɛrɛ wie.” ");
INSERT INTO cko_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Na Yesu ase bu ka, “Nzɛn am afa má am beŋgum satiɛ ace má bu am ahore su, sɔ ye m Si Nyɛmɛ bo i wo aŋgoro ni cín am sui a.” ");
INSERT INTO cko_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Saŋga bo Yesu jɔjɔɔri ahin jɔrɛm n kɛrɛ wieeri ni, na wɔ yasu Galili awɔrɛ n nu, akɔ Yudiya dɛɛ awɔrɛ n nu, na wɔ kɔ akpiɛ Yodan kunma n buekun dɔ. ");
INSERT INTO cko_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Na jama beberebe asu i su, na wɔ ma tukpaki­fɔm bo bu wo jama n nu n anya laifiɛ. ");
INSERT INTO cko_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Na Farasi­fɔ nbem aba i dɔ, ka bu ba sɔ i ŋgɛɛ fa kɔ i nɔaniɛ jɔjɔɔ­wa n su, na ba bisa i ka, “Ya dɛɛ atin n su, atin wo nu ka sɔnɔ koro fa i yi ji deke be dɛɛ ti?” ");
INSERT INTO cko_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Na Yesu abɔ bu nu ka, “Ye ba kɛrɛ i Nyɛmɛ Jɔrɛ Kadasi n nu sɛ wɔ? Ba kɛrɛ ka, fite durunya n bumboori, saŋga n bo Nyɛmɛ yiiri adamande ni, i yiiri biɛsɔ ni bara wɔ, ");
INSERT INTO cko_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","na wɔ se ka, ‘Nyini dɛɛ ti, i ti ye ni ka biɛsɔ n kpaaki i gisan yaki i si ni i ni, na i ni i yi n saŋga wo. Nyini saŋga, bu minɛ nnyɔ n ayo deke kun lɛɛ.’ ");
INSERT INTO cko_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Bu wo má bu ŋguŋgumi kun. Nyini ti, deke bo Nyɛmɛ anya asaŋga i awie, má sɔnɔ kpaaki i nu kun.” ");
INSERT INTO cko_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Na ba bisa Yesu bekun ka, “Ye nzu ti ye Moyisi yo maari atin ka, nzɛn sɔnɔ koro ka i fa i yi ji, i ti ye ni ka i mi ma bara n ajaa yaki kadasi ka, na i nya fa i ji a?” ");
INSERT INTO cko_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Na Yesu abɔ bu nu ka, “Am ahore­mbaa kekereke n dɛɛ ti, ye Moyisi yo maari am nyini atin n a. Ama, fite durunya n bumboori, i yo ti má sɔ. ");
INSERT INTO cko_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","M suse am wɔ lɛɛ, ka, sɔnɔ kɛrɛ bo i faari i yi jiiri, na wɔ yo má ka bara n akɔ somaya ye i fa i jiiri, na i jaari bara fɔfɔrɛ, i mi n asaaki ajaa ciire lɛɛ.” ");
INSERT INTO cko_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Na i susu­fɔm n ase i ka, “Nzɛn i nya tiiri sɔ yiri, fa kɔ biɛsɔ ni bara dɔ, i ti kpa ka má be ja ajaa.” ");
INSERT INTO cko_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Na wɔ se bu ka, “Má sɔnɔ kɛrɛ koro su ahin nɔaniɛ n su a, má ka bɛrɛ bo Nyɛmɛ adu mɔ afa ama bu ni. ");
INSERT INTO cko_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Dama deke bo i ti na minɛ nbem ja má ajaa n la ka, bu biɛsɔ dika yo má juma n dɛɛ ti, nbem gusu, ba sa bu wɔ, ye nbem gusu kete ajaa fa kɔ Nyɛmɛ fɛmɛya n jɔrɛ dɛɛ ti. Nyini ti, sɔnɔ kɛrɛ bo i koro de ahin nɔaniɛ ni, i mi de i.” ");
INSERT INTO cko_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Na minɛ nbem afa nbaatumam aba Yesu dɔ, ka i fa i saa nana bu ŋu na i sere Nyɛmɛ ma bu. Ama, na i susu­fɔm n atiɛn minɛm ni ŋu. ");
INSERT INTO cko_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Na Yesu ase bu ka, “Am ma nbaatumam n bra m dɔ, má am fɔn bu. Dama bɛrɛ ŋusu sɔ ye Nyɛmɛ fɛmɛya n ti bu dɛɛ a.” ");
INSERT INTO cko_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Na wɔ fa i saa anana bu ŋu na wɔ yo bu kisi, na wɔ nya afite bɛrɛ akɔ. ");
INSERT INTO cko_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Cɛɛn be, na gbɛfɛnɛ be aba Yesu dɔ, aba abisa i ka, “Ya Kere­fɔ, m yo nzu sakpa ye m bá nya ŋgɔɔ n bo i la má awieeri n a?” ");
INSERT INTO cko_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Na Yesu abɔ i nu ka, “Nzu ti ye a bisa m fa kɔ deke bo i ti sakpa su a? Sɔnɔ kun n kpein wo bɛrɛ bo i ti kpa. Nzɛn a koro ka a nya ŋgɔɔ, su Nyɛmɛ nɔaniɛ maa­wam n su.” ");
INSERT INTO cko_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Na wɔ bisa Yesu ka, “Nɔaniɛ maa­wa nbɔnɔm?” Na Yesu abɔ i nu ka, “Má a kun sɔnɔ. Má a saaki ajaa ciire. Má a wɔ. Má a di kɔrɛ daani. ");
INSERT INTO cko_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Bu u si ni u ni. Koro u beŋgu kabo a koro u ŋu ni.” ");
INSERT INTO cko_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Na gbɛfɛnɛ n ase i ka, “Ma su nyini nɔaniɛ maa­wa n kɛrɛ su, ye nzu kaari a?” ");
INSERT INTO cko_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Na Yesu ase i ka, “Nzɛn a koro ka u woo­wa n ti kabo Nyɛmɛ koro ka i ti n wɔ, kɔ na a kɔ tɔ u aja kɛrɛ, na a fa ŋwaa n ma yaari­fɔm, na a bá nya ajɛkɛ Nyɛmɛ dɔ, na a bra, ba su m su.” ");
INSERT INTO cko_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Saŋga bo gbɛfɛnɛ n tiiri nyini sɔ ni, na wɔ yasu akɔ ni ahoresaaki, dama i la neŋge agaya n dɛɛ ti. ");
INSERT INTO cko_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Na Yesu ase i susu­fɔm n ka, “Nahɔrɛ ye m suse am n a, i yó kekereke ni bo neŋge­fɔ wura Nyɛmɛ fɛmɛya n nu. ");
INSERT INTO cko_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","M suse am wɔ bekun lɛɛ ka, kabo nyɔɔma sin misini bue nu ni, i ti má kekereke tara má kabo neŋge­fɔ yo na i wura Nyɛmɛ fɛmɛya n nu ni.” ");
INSERT INTO cko_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Saŋga bo Yesu susu­fɔm n tiiri nyini n sɔ ni, na ba yo alekutura agaya, na ba bisa i ka, “Ye nzɛn i ti sɔ, ŋma koro fite nu a?” ");
INSERT INTO cko_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Na Yesu aniɛ bu dɔ, na wɔ se ka, “Ahin ti deke bo adamande koro yo má i, ama, Nyɛmɛ dɔ, i ti má pui, dama Nyɛmɛ koro yo deke kɛrɛ.” ");
INSERT INTO cko_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Na Petoro ase i ka, “Tɔ, ye yɛrɛ ayaki deke kɛrɛ susu u su e. Ye ya nyá nzu wɔ?” ");
INSERT INTO cko_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Na Yesu ase bu ka, “Nahɔrɛ ye m suse am n a, saŋga bo mini Adamande Wa n ba tanaari m jirima tanaa­biri n durunya fɔfɔrɛ n nu, m má ambɛrɛ bo am asu m su ni tana fɛmɛya biɛ buru ni nnyɔm n su, na am níɛ Yisareli­fɔm anɔ buru ni nnyɔm n su. ");
INSERT INTO cko_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Na sɔnɔ kɛrɛ bo i yakiiri i awuru, wara i ninbaam, wara i si, ni i ni, wara i nbaam, wara i asiɛnm, mini dɛɛ ti, i mi nyá nyini n kɛrɛ ŋusu yaa i ŋgɔɔ su, na i káaki nya ŋgɔɔ bo i la má awieeri. ");
INSERT INTO cko_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Am minɛ dɔŋgu bo bu wo mɔ kisa ni bá ka sin, na bo bu ka sin kisa n bá du mɔ.” ");
INSERT INTO cko_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Na Yesu akaaki ase ka, “Nyɛmɛ fɛmɛya n ti ka sɔnɔ be bo i yasuuri alecin ŋgarama fuun, ka i kɔ niɛniɛ npa­di­fɔm na bu kɔ yo i fie juma n wɔ. ");
INSERT INTO cko_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Na i ni bɛrɛ adi gɔ, na wɔ soro su ka i tɔ bu le­kun juma­yoo­wa ŋkatɔ, jɛtɛ ŋwaa kun. Na wɔ fa bu akɔ fie n su. ");
INSERT INTO cko_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Na fa kɔ kerefi ŋgɔna saŋga, na wɔ kaaki akɔ aŋu ka minɛ nbem tana gɔɔsu, bu yo má pui. ");
INSERT INTO cko_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Na wɔ se bu ka, ‘Am ma ya kɔ m fie n su, na am kɔ yo m juma, na m tɔ am kaari, kabo am juma­yoo­wa ti barasu.’ ");
INSERT INTO cko_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Nyini ti, na ba kɔ. Na kerefi buru ni nnyɔ saŋga, na wɔ kaaki akɔ gɔɔsu, akɔ aŋu ka minɛ nbem jina, na wɔ fa bu akɔ i fie n su. Na kerefi nsan saŋga, na wɔ yo sɔ bekun. ");
INSERT INTO cko_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Na fa kɔ naasɔ kerefi nnu saŋga, na wɔ kɔ aŋu ka minɛ nbem jina ŋgbɛɛn, bu yo má pui. Na wɔ bisa bu ka, ‘Nzu ti ye am ba jina fɛn ŋgarama kun kɛrɛ ŋgbɛɛn sɔ, na am yo má pui a?’ ");
INSERT INTO cko_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Na ba bɔ i nu ka, ‘Be afa má ya ka ya yo i juma.’ Na wɔ se bu ka bɛrɛ gusu kɔ na bu kɔ yo juma i fie n su. ");
INSERT INTO cko_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Saŋga bo wiɛ ba tɔɔri n na fie­fɔ n fere i juma niɛsu­fɔ n na wɔ se i ka, ‘Fere juma­yo­fɔm n kɛrɛ na a tɔ bu kaari. Bo i bu tɔ bo bu baari kasin n ka, na a nya ba tɔ bo bu duuri mɔ baari ni.’ ");
INSERT INTO cko_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Na bo bu baari ka sin n kɛrɛ aba, na wɔ tɔ bu jɛtɛ ŋwaa kun kun. ");
INSERT INTO cko_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Saŋga bo i ba kpuraari bo bu duuri mɔ baari ni, bu sunsuunri ka bu dɛɛ ŋkatɔ tara bo bu kaari sin baari n dɛɛ n wɔ. Ama, bu tɔɔri bu kɛrɛ jɛtɛ ŋwaa kun kun wɔ, kabo bu tɔɔri kasin­fɔm ni. ");
INSERT INTO cko_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Bu deeri ŋwaa wieeri sɔ ni, na ba ŋuŋuti fie n fɔ ni. ");
INSERT INTO cko_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Bu ŋa, ‘A tɔ kasin­fɔm bo ba yo má juma kpa be ni ŋkatɔ nyunyumi, na kabo a tɔɔri bu ni, a tɔ yɛrɛ gusu bo ya baari ŋgarama kun kɛrɛ, na ya ba adi yaari, na wiɛ abo ya n gusu sɔ ɔ.’ ");
INSERT INTO cko_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ama, na fie n fɔ n abɔ nu, ase bu kun ka, ‘M dɔn, ti fɛn, ma sisi má am e. Bo mini si i n la ka, am soroori su ka am yo le­kun juma, na am de jɛtɛ ŋwaa kun wɔ. ");
INSERT INTO cko_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Nyini ti, de u ŋwaa na a kɔ. M koro ka m ma kasin­fɔ n kabo m maari u n wɔ. ");
INSERT INTO cko_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","M la má atin ka m yo m ŋwaa kabo m koro, nzɛn sɛ? Wara, a si m kɔrɛ fa kɔ m sakpa bo ma yo i n wɔ?’” ");
INSERT INTO cko_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Na Yesu ase bu ka, “Ahin miɛɛnu n bu la ka, minɛm bo ba ka sin kisa ni, bá du mɔ, na bo ba du mɔ kisa n bá ka sin.” ");
INSERT INTO cko_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Saŋga bo Yesu ni i susu­fɔm, ni jama n sukɔ Yɛrusalem miɛ kpiri n nu ni, bu wo kɔ su sɔ ni, na wɔ fere i susu­fɔ buru ni nnyɔm n akɔ ahɛmɛ, na wɔ se bu ka, ");
INSERT INTO cko_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Am ti fɛn. Ya sukɔ Yɛrusalem lɛɛ, dɔ ye bu kɔ́ tara mini Adamande Wa n a, na bu fá ma Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ nkpiɛn­kpiɛnm ni, ni Nyɛmɛ nɔaniɛ kere­fɔm ni, na bu dí m jɔrɛ, na bu sóro su ka bu kún m. ");
INSERT INTO cko_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Na bɛrɛ gusu nyá fa m wura minɛm bo bu ti má Yuda­fɔm saa nu, na bu yó m anzasi, na bu fín m ŋgbere, na bu nyá kpama m baka jaanu n su na m wu, na i le­san cɛɛn, na Nyɛmɛ má m teŋge m yiwee n nu.” ");
INSERT INTO cko_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Na Zɛbɛdi yi afa i nbaa nnyɔm n aba akutu Yesu nyunu, asere i ahɔrɔma ka i yo sa be ma i. ");
INSERT INTO cko_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Na Yesu abisa i ka, “A koro ka m yo nzu ma u a?” Na bara n abɔ i nu ka, “M koro ka a ma nɔɔ ka saŋga bo a bá diiri u fɛmɛya ni, a má m ahin nbaa nnyɔm ni atin na bu nu kun tana u saa fɔmbɔrɔ su, na kun gusu tana u saa biɛ su.” ");
INSERT INTO cko_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Na Yesu ase bu ka, “Am si má deke bo am susere i n ti a. Am kóro di wahara n bo m dí i ni?” Na ba bɔ i nu ka, “Ɛɛn, ya koro yo i kɛrɛ.” ");
INSERT INTO cko_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Na Yesu ase bu ka, “Nahɔrɛ, am dí wahara n bo m dí i ni. Ama, mini la má atin bo m má am be tana m saa fɔmbɔrɔ su, na be tana m saa biɛ su. Ama, m Si Nyɛmɛ asɛsɛ nyini tanaa­biri n su, afa ase minɛm bo yiri ni i tii ayi bu n a.” ");
INSERT INTO cko_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Saŋga bo i susu­fɔ burum n ba tiiri kabo Zɛbɛdi nbaa nnyɔm n seeri Yesu ni, na ba fa yaa bu ŋu. ");
INSERT INTO cko_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Na Yesu afere bu kɛrɛ aba i bi, na wɔ se bu ka, “Am si tenle su ka minɛm bo bu su má Nyɛmɛ, na bu yo bu ŋu nkpiɛn­kpiɛnm ni, bɛrɛ miɛ bu minɛm a, na bu tere­tere­fɔm gusu kere kabo bu yiko ti barasu. ");
INSERT INTO cko_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ama, i ti má ye ni ka ambɛrɛ yo sɔ. Nzɛn sɔnɔ bo i koro ka i wura i ŋu kpiri am kɛrɛ nu, wɔ yo daka ka i mi yo i ŋu kaan, na i su am. ");
INSERT INTO cko_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Na bo i kaaki koro ka i yo am mɔ­fɔ, i ti ye ni ka i mi yo am kɛrɛ akɔɔ, ");
INSERT INTO cko_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","kabo mini Adamande Wa n ni m tii aba má ka minɛm su m ni, ama, m baari ka m ba su minɛm wɔ, na m wu ma bu, na m de minɛ dɔŋgu tii ji.” ");
INSERT INTO cko_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Saŋga bo Yesu, ni i susu­fɔm ni sufite miɛ kpiri n bo bu fere i ka Yeriko ni, na jama beberebe asu bu su. ");
INSERT INTO cko_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Bu sukɔ ni, anyinsin nnyɔ nbem tana atin n nɔɔ su. Saŋga bo bu tiiri ka Yesu susin ni, na ba bo afere i, bu ŋa, “Ya Mibiɛ, Fɛmɛ Davidi anuma, si ya aŋunfɔ.” ");
INSERT INTO cko_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Na jama n atiɛn bu ŋu ka bu yaki naŋmiɛ. Ama, na ba kaaki abo afere abuka su ka, “Ya Mibiɛ, Fɛmɛ Davidi anuma, si ya aŋunfɔ.” ");
INSERT INTO cko_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Na Yesu aka ajina, na wɔ fere bu, na wɔ bisa bu ka, “Am koro ka m yo nzu ma am a?” ");
INSERT INTO cko_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Na ba bɔ i nu ka, “Ya Mibiɛ, ya koro ka a ma ya ŋu asi wɔ.” ");
INSERT INTO cko_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Na Yesu asi bu aŋunfɔ, na wɔ fa i saa akan bu nyu­mbaa ni, kpeŋga na ba ŋu asi, na ba su i su. ");
INSERT INTO cko_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Bu kɔ ŋa bu dodo Yɛrusalem miɛ kpiri n nu, na bu ŋa bu wura miɛ n bo bu fere i ka Befage ni, nyini miɛ n dodo buka n bo bu fere i ka Oliva Buka n wɔ, dama oliva bakam gɔ su wɔ. Dɔ na Yesu asunma i susu­fɔm n nu nnyɔ, ");
INSERT INTO cko_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","na wɔ se bu ka, “Am kɔ miɛ kaan n bo i wo am nyunu dɔ ni, am kɔ juuri, am ŋú ka kaako be minda, i wa jina i bi bɛrɛ. Am nyaŋgi i ni baa n kɛrɛ bra. ");
INSERT INTO cko_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Nzɛn be bisaari am ka nzu ti ye am sunyaŋgi i a, am se i ka Mibiɛ ni koro bu a, na i má am kaaki fa bu ba kisa kisa.” ");
INSERT INTO cko_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ahin yoori sɔ ɔ, adena Nyɛmɛ nɔaniɛ kan­fɔ n nɔaniɛ n bo i yo jɔjɔɔri i n yo yii­wa a, i ŋa, ");
INSERT INTO cko_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Se Siyon­fɔm ka, Am niɛ, am fɛmɛ ni suba n a. Wɔ yo i ŋu taraka, i fun kaako wɔ.” ");
INSERT INTO cko_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Na i susu­fɔm n akɔ ayo kabo i seeri bu ni. ");
INSERT INTO cko_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Na ba fa kaako n ni i wa n aba, na ba fa bu suturam anana bu ŋu, na Yesu afun atana su. ");
INSERT INTO cko_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Na minɛ beberebe afa bu suturam atɛrɛki ase atin n nu, na nbem gusu abubu nyawa asese atin n nu. ");
INSERT INTO cko_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Na jamam bo bu du i nyunu n ni bo bu wo i sin n kɛrɛ, subo kuyigindi, bu ŋa, “Hosana. Ya kansi Fɛmɛ Davidi anuma ni. Tere­fiɛ wo yiri n bo i suba Micɛra n dɛɛ duma n nu n dɔ. Ya kansi Nyɛmɛ bo i wo aŋgoro ni.” ");
INSERT INTO cko_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesu kɔ wuraari Yɛrusalem ni, na miɛ n abo nu, na ba bisa ka, “Ye sɔnɔ bɔnɔ la ahin a?” ");
INSERT INTO cko_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Na jama n abɔ nu ka, “Ahin ti Yesu wɔ, Nyɛmɛ nɔaniɛ kan­fɔ n bo i fite Nazarɛti miɛ n bo i wo Galili awɔrɛ n nu ni.” ");
INSERT INTO cko_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Na Yesu akɔ awura Nyɛmɛ Seree­biri Awuru n nu, na wɔ fɔn neŋge tɔ­fɔm ni to­fɔm kɛrɛ afite awuru n nu, na wɔ kaaki ŋwaa kaaki­fɔm teebirim, ni tiiwa tɔ­fɔm biɛm kɛrɛ alanlaŋga. ");
INSERT INTO cko_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Na wɔ se bu ka, “Ba kɛrɛ i Nyɛmɛ Jɔrɛ Kadasi n nu ka, Nyɛmɛ ŋa o, ‘M awuru ni, bu bá fere i ka awuru bo bu bá sere Nyɛmɛ nu wɔ.’ Ama, ambɛrɛ afa i yo awiefɔm fiɛɛ­biri.” ");
INSERT INTO cko_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Na anyinsinm, ni wɔbukam aba i dɔ, Nyɛmɛ Seree­biri Awuru n nu, na wɔ ma bu anya laifiɛ. ");
INSERT INTO cko_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Saŋga bo Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ nkpiɛn­kpiɛnm, ni Nyɛmɛ nɔaniɛ kere­fɔm n ŋuuri sam n bo i yoori bu ni, ni kabo nbaatumam bo bu woori Nyɛmɛ Seree­biri Awuru n nu bo tuntuunri i ka, “Hosana. Ya kansi Fɛmɛ Davidi anuma ni,” na yaa ati bu. ");
INSERT INTO cko_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Nyini ti, na ba bisa Yesu ka, “A ti kabo nbaatumam n ase ni e?” Na Yesu abɔ bu nu ka, “Ɛɛn, ma ti. Am nya kan má kabo ba kɛrɛ i Nyɛmɛ Jɔrɛ Kadasi n nu n wɔ? Bo ba kɛrɛ ka, ‘Wɔrɔ Nyɛmɛ ye a kere nbaatumam, ni nbaatuma kan kanm, kabo bu kansi u nahɔrɛ su a.’” ");
INSERT INTO cko_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Na Yesu ayaki bu bɛrɛ, na wɔ fite miɛ n nu akɔ Betani miɛ n nu, akɔ ada dɔ. ");
INSERT INTO cko_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","I alecin ŋgarama fuun, na Yesu sukpie i nyi kɔ Yɛrusalem miɛ n kunnu, na ahɔɛ ati i. ");
INSERT INTO cko_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Na wɔ niɛ aŋu damba baka be, atin n nɔɔ, na wɔ kɔ aniɛ ka i nyá suu­wa n be di. Ama, i kɔ juuri baka n bu ni, wɔ ŋu má pui su, se nyawa ŋgumi a. Dɔ na wɔ se baka n ka, “Sin nyuma sin, wɔrɔ su má suu­wa kun.” Dika n nu bɛrɛ, na baka n akaba awu. ");
INSERT INTO cko_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Saŋga bo i susu­fɔm n ŋuuri nyini n sɔ ni, na ba yo alekutura. Na ba bisa i ka, “Nzu ti ye baka n wuuri ndende sɔ a?” ");
INSERT INTO cko_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Na Yesu abɔ bu nu ka, “Nahɔrɛ ye m suse am n a, wɔrɔ kɛrɛ bo a yoori Nyɛmɛ yarada na a yo má sika, a koro yo sa n bo ma fa ayo ahin damba baka n be. Má ahin ni ŋgumi, haari nzɛn a seeri ahin buka n ka, ‘Yasu kɔ to tieku n nu,’ i yó sɔ ɔ. ");
INSERT INTO cko_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nzɛn am yoori yarada, deke kɛrɛ bo am sere Nyɛmɛ ka am koro i, Nyɛmɛ yó i ma am.” ");
INSERT INTO cko_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Na Yesu akpie i nyi aba awura Nyɛmɛ Seree­biri Awuru n nu, na i sukere minɛm. I wo kere su sɔ n na Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm, ni Yuda­fɔm nkpiɛn­kpiɛnm aba i dɔ, na ba bisa i ka, “Ŋma dɛɛ yiko nu ye a yo nyini sam kɛrɛ a? Ŋma ma u nyini yiko ni, ye a yo nyini sam n a?” ");
INSERT INTO cko_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Na Yesu abɔ bu nu, ase bu ka, “Am ma m du mɔ bisa am bisaa­wa kun be ka, na nzɛn am bɔɔri m nu, na m gusu nyá se am deke bo m yiko n fite. ");
INSERT INTO cko_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ŋma maari Yohane atin ye i ba biɛɛri minɛm Nyɛmɛ nzue n a? Nyɛmɛ nzɛn adamande?” Na ba se akuruwa bu ŋuŋu nu, kabo bu bɔ Yesu nu barasu. Bu ŋa, “Nzɛn ya se i ka Nyɛmɛ maari i atin a, i bísa ya ka ye nzu ti ye ya da má Yohane ŋu a? ");
INSERT INTO cko_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ama, nzɛn ya seeri i ka adamande dɔ, ya soro sɛrɛ ka jama ni yáki má ya. Má pui ti, dama sɔnɔ kɛrɛ soroori su ka Yohane yo tiiri Nyɛmɛ nɔaniɛ kan­fɔ ɔ nahɔrɛ su.” ");
INSERT INTO cko_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Nyini ti, na ba bɔ i nu ka, “Ya si má.” Na yiri gusu ase bu ka, “Mini mmɔɔ sé má am sɔnɔ bo i dɛɛ yiko nu na m yo ahin sam n kɛrɛ ni.” ");
INSERT INTO cko_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Na Yesu abisa bu ka, “Am sunsun ka ahin miɛɛnu bu la ka sɛ wɔ lɛɛ? Sɔnɔ be yo woori bɛrɛ a, i la nbaa­biɛsɔm nnyɔ. Cɛɛn be na wɔ kɔ kpiɛn n dɔ, akɔ ase i ka, ‘M wa, kɔ baka suu­wam fie n nu, na a kɔ yo juma nyuma.’ ");
INSERT INTO cko_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Na baa n ase i ka, ‘M kɔ́ má.’ Ama, kasin, na baa n aba akaaki i sunsunni, na wɔ kɔ. ");
INSERT INTO cko_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Na wɔ kɔ nyiŋga n dɔ, akɔ ase i gusu. Na baa n ase i ka, ‘Ma ti, m kɔ́.’ Ama, wɔ kɔ má. ");
INSERT INTO cko_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Tɔ, bu minɛ nnyɔm n nu, ŋma yoori i si n sa koroo­wa?” Na ba bɔ i nu ka, “Baa­kpiɛn ni.” Dɔ na Yesu ase bu ka, “Nahɔrɛ ye m suse am n a, lampo­de­fɔm ni sakaram kɛrɛ sufa Nyɛmɛ yo bu fɛmɛ yaki am. ");
INSERT INTO cko_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Dama ka, Yohane baari ka i bá kere am sa bo i kɔ atin su Nyɛmɛ dɔ ɔ, ama, am ayo má i yarada, na lampo­de­fɔm ni sakaram, bɛrɛ ayo i. Haari ni bo am ŋuuri kabo bu yoori yarada ni, am akaaki má am wo, na am yo i yarada.” ");
INSERT INTO cko_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Na Yesu ase bu ka, “Am so am sui na am ti miɛɛnu n be bekun. Awuru­fɔ­biɛ be yo woori bɛrɛ a, na wɔ dɔ i baka suu­wa barasu be fie, na wɔ kanda abara ayɛ fie ni. Na wɔ lokoti yabuɛ bambaka be kunma, ka i sumiɛmiɛ baka suu­wam ni nzue gɔ nu. Na wɔ ta kpafiri lenleŋge be ka bu tana su suniɛ fie n kɛrɛ su, na wɔ nya afa fie n awura i npa­di­fɔm saa nu. Na wɔ kɔ atin. ");
INSERT INTO cko_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Saŋga bo i siiri ka wɔ ka kaan na baka suu­wam n bí ni, na wɔ sunma i akɔɔm i npa­di­fɔm n dɔ ka bu kɔ de i dɛɛ bo ba nya i n bra. ");
INSERT INTO cko_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Akɔɔm n kɔ juuri ni, na ba bo bu nu kun, na ba kun nyiŋga, na ba tu nyiŋga n gusu yabuɛ. ");
INSERT INTO cko_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Na sɔnɔ n asunma i akɔɔ nyiŋgam bekun, bu sunnu tara ciciri dɛɛm ni, na npa­di­fɔm n ayo bu kabo bu yoori ciciri su dɛɛm ni. ");
INSERT INTO cko_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Na kasin, na wɔ ba asunma i wa, na wɔ se ka, ‘Bu má m wa n yiri jirima.’ ");
INSERT INTO cko_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ama, saŋga bo npa­di­fɔm n ŋuuri ka baa ni suba ni, na ba se bu ŋuŋu nu ka, ‘I wa n bo i dí i aja n lɛɛ suba n a. Am bra na ya kun i na aja n kɛrɛ ká ya dɛɛ.’ ");
INSERT INTO cko_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Dɔ na ba tara i, na ba cin i atu baka suu­wa fie n ahɛmɛ, na ba kun i.” ");
INSERT INTO cko_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Na Yesu anya abisa bu ka, “Am sunsun ka fie fɔ n ba baari, i yó nyini npa­di­fɔm ni sɛ wɔ?” ");
INSERT INTO cko_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Na ba bɔ i nu ka, “I bá ma nyini minɛ tiɛ­fɔm n kɛrɛ wu kenkesi yiwee wɔ, na i fá fie n wura npa­di­fɔ fɔfɔrɛm saa nu, bɛrɛ bo bu má i nya i dɛɛ baka suu­wam, saŋga bo bu ba biiri ni.” ");
INSERT INTO cko_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Na Yesu ase bu ka, “Am nya kan má kabo ba kɛrɛ i Nyɛmɛ Jɔrɛ Kadasi n nu ni, nzɛn sɛ? Bu ŋa, ‘Yabuɛ n bo bondo ta­fɔm n faari i tuuri ni, yiri ye wɔ kaaki bondo n jaa yabuɛm n kɛrɛ tii a. Micɛra ni yoori i sɔ a. Ya ŋu i na wɔ yo ya alekutura.’” ");
INSERT INTO cko_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Na Yesu ase bu ka, “M suse am wɔ lɛɛ, ka, bu dé Nyɛmɛ fɛmɛya n fite am dɔ, na bu fá ma minɛm bo bu bita i na i la kpɛrɛ ni.”  ");
INSERT INTO cko_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Na wɔ kaaki ase ka, “Sɔnɔ kɛrɛ bo i kpaasiiri ahin yabuɛ n su, i mi búbu nu wɔ mumuku, na sɔnɔ kɛrɛ gusu bo ahin yabuɛ n tɔɔri i ŋu, i sán i mi samɛnɛ wɔ.” ");
INSERT INTO cko_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm, ni Farasi­fɔm n tiiri miɛɛnu n bo Yesu boori i sɔ ni, na ba fa nu ka i boori i niiri bɛrɛ wɔ. ");
INSERT INTO cko_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Nyini ti, na ba kpini atin kabo bu yo na bu tara i, ama, bu soroori jama n wɔ, dama bu kɛrɛ ŋa i ti Nyɛmɛ nɔaniɛ kan­fɔ ɔ. ");
INSERT INTO cko_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Na Yesu akaaki abo miɛɛnu be bekun, i ŋa, ");
INSERT INTO cko_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Kabo Nyɛmɛ fɛmɛya n ti yaa. Fɛmɛ be yo sɛsɛɛri i wa konyaya di ni nu su fa seeri a. ");
INSERT INTO cko_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Na wɔ sunma i akɔɔm ka bu kɔ fere minɛm bo wɔ du mɔ abaandi bu ka bu ba konyaya di ni nu ni, ka bu bra. Ama, na ba kete ka bu ba má. ");
INSERT INTO cko_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Na wɔ kaaki asunma akɔɔ nyiŋgam ka bu kɔ se bɛrɛ n bo wɔ du mɔ abaandi bu n ka, ‘Am bra, dama ma yo m di ni nu n siriya kɛrɛ awie. Haari ma kun m tooram, ni neŋge­ndɔrɛ bo bu la lui ni, ayo siriya kɛrɛ awie. Am bra na am ba konyaya di ni nu ni.’ ");
INSERT INTO cko_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ama, bu be mmɔɔ abɔ má bu nu. Na ba ka bu juma n yo su. Kun kɔɔri i fiesu wɔ, na nyiŋga gusu akɔ i juma yoo­biri. ");
INSERT INTO cko_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Na nyiŋgam n atara i akɔɔm ni, na ba kere bu wuwuruwa, na ba kun bu. ");
INSERT INTO cko_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Dɔ na yaa ati fɛmɛ n agaya, na wɔ sunma i sojam, na ba kɔ akun nyini minɛ kun­fɔm ni kɛrɛ, na ba yara bu miɛ ni. ");
INSERT INTO cko_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Na wɔ fere i akɔɔm ni, na wɔ se bu ka, ‘Konyaya di ni nu n ayo siriya, ama, minɛm bo m duuri mɔ baandiiri bu ka bu ba di i ni, i ti má ye ni ka bu dí i kun. ");
INSERT INTO cko_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Nyini ti, am fite kɔ atiŋgberem su, na am kɔ fere minɛm barasu kɛrɛ bo am ŋuuri bu ni, ka bu bra konyaya di ni nu ni.’ ");
INSERT INTO cko_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Na akɔɔm n akɔ atiŋgberem su, akɔ atiɛn minɛm kɛrɛ bo bu kɔ ŋuuri bu n nɔɔ aba, minɛ kpam ni tiɛm kɛrɛ. Na konyaya awuru n ayi ni jama beberebe. ");
INSERT INTO cko_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Na fɛmɛ n akɔ, ka i kɔ niɛ jama ni, na wɔ ŋu ka sɔnɔ kun be wo jama n nu, i wura má konyaya sutura. ");
INSERT INTO cko_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Na fɛmɛ n abisa i ka, ‘M dɔn, a yo sɛ wuraari awuru n nu fɛn, ye a wura má konyaya sutura a?’ Ama, sɔnɔ n akoro abɔ má i nu. ");
INSERT INTO cko_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Na fɛmɛ n ase i ngbɛfɛnɛm ka, ‘Am tara i, na am cici i saam, ni i jaam nyama, na am fa i tu dasin dɔ, awosin n nu. Dɔ na i sún, na i kán i saa.’” ");
INSERT INTO cko_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Na Yesu anya ase bu ka, “Minɛm bo Nyɛmɛ afere bu n sunnu, ama, bo wɔ yi bu n sunnu má.” ");
INSERT INTO cko_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Na Farasi­fɔm n afite akɔ asɛsɛ su kabo bu sɔ Yesu ŋgɛɛ, na bu nya i taraa­biri fa kɔ i nɔaniɛ jɔjɔɔ­wa su. ");
INSERT INTO cko_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Na ba sunma bu susu­fɔm, ni Fɛmɛ Herode minɛm Yesu dɔ, na ba kɔ ase i ka, “Ya Kere­fɔ, ya si ka a ti nahɔrɛ se­fɔ ɔ, na a kere minɛm kabo Nyɛmɛ atin ti nahɔrɛ su, na u cɛcɛ wo má kabo minɛm jɔjɔ nu, dama a niɛ má sɔnɔ jinaa­biri ti. ");
INSERT INTO cko_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Tɔ, a ŋa sɛ wɔ? Ya dɛɛ atin n su, atin wo nu ka ya tɔ lampo ma Roma­fɔm Fɛmɛ Kpiri Siza, nzɛn atin wo má nu?” ");
INSERT INTO cko_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ama, na Yesu asi ka bu bita sunsunni tiɛ wɔ, na wɔ se bu ka, “Ambɛrɛ burukɔɔ­nu­fɔm ni, nzu ti ye am sukoro ka am sɔ m ŋgɛɛ a? ");
INSERT INTO cko_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Am fa ŋwaa n bo bu fa tɔ lampo kaari n bra na m niɛ.” Na ba fa ŋwaa n aba ama i, ");
INSERT INTO cko_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","na wɔ de ŋwaa n aniɛ, na wɔ bisa bu ka, “Ŋma dɛɛ tii ni i duma wo ŋwaa n su n a?” ");
INSERT INTO cko_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Na ba bɔ i nu ka, “Fɛmɛ Siza dɛɛ a.” Na Yesu ase bu ka, “Tɔ, deke bo i ti Fɛmɛ Siza dɛɛ, am fa ma Fɛmɛ Siza, na deke bo i ti Nyɛmɛ dɛɛ, am fa ma Nyɛmɛ.” ");
INSERT INTO cko_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Saŋga bo bu tiiri ahin nɔaniɛ n sɔ ni, na ba miɛ, na ba kɔ ayaki i. ");
INSERT INTO cko_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Nyini cɛɛn n gbingbin na Sadusi­fɔ nbem aba Yesu dɔ. Bu dɛɛ keree­wa la ka Nyɛmɛ téŋge má minɛm bu yiwee n nu n a. Na ba ba abisa i jɔrɛ be, bu ŋa, ");
INSERT INTO cko_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Ya Kere­fɔ, Moyisi yo seeri ka, nzɛn sɔnɔ wu yakiiri i yi, na i ni bara n anya má baa, wɔ yo daka ka i niɛma n fa kuna­fɔ n na bu wu nbaam ma yiri n bo wɔ wu ni. ");
INSERT INTO cko_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Tɔ, sɔnɔ be yo laari nbaa­biɛsɔm nso wɔ, ya nu fɛn, na baa­kpiɛn n aja bara, na wɔ wu ayaki bara ni, ba wu má baa. ");
INSERT INTO cko_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Sɔ ye bo i tɔ i su nnyɔ su, ni nsan su n yoori a, haari fa kɔ kpuraari nso su ni. ");
INSERT INTO cko_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Na bara n ni i tii aba aka sin awu. ");
INSERT INTO cko_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Tɔ, kabo bu minɛ nso n kɛrɛ aja bara n na ba wu sɔ ni, cɛɛn bo Nyɛmɛ bá teŋge minɛm bu yiwee n nu ni, bara ni ká ŋma dɛɛ tenle su a?” ");
INSERT INTO cko_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Na Yesu abɔ bu nu ka, “Am amini atin. Dama am ti má deke bo ba kɛrɛ i Nyɛmɛ Jɔrɛ Kadasi n nu n bu, na am kaaki si má kabo Nyɛmɛ yiko n ti barasu. ");
INSERT INTO cko_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Dama saŋga bo Nyɛmɛ bá teŋge minɛm bu yiwee n nu ni, ajaa wo má bɛrɛ kun. Ama, nyini cɛɛn ni, sɔnɔ kɛrɛ kaaki ka Nyɛmɛ mɛrɛkɛm bo bu wo aŋgoro n wɔ, dama bu ja má ajaa kun. ");
INSERT INTO cko_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Na fa kɔ kabo Nyɛmɛ bá teŋge minɛm bu yiwee n nu barasu ni, am akan má Nyɛmɛ Jɔrɛ Kadasi n nu kabo i yo seeri am n wɔ, nzɛn sɛ? I ŋa, ");
INSERT INTO cko_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Mini ti Abraham, ni Izaki, ni Jakɔbu dɛɛ Nyɛmɛ n a.’” Na Yesu asa su ase bu ka, “Tɔ, kabo Nyɛmɛ ŋa i ti nyini minɛm n dɛɛ Nyɛmɛ ni, nyini kere ka bu toko la ŋgɔɔ lɛɛ, dama Nyɛmɛ ti má bo ba wu n dɛɛ Nyɛmɛ, ama, i ti bo bu la ŋgɔɔ ni dɛɛ Nyɛmɛ a.” ");
INSERT INTO cko_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Minɛm n tiiri i keree­wa n sɔ ni, na ba yo alekutura. ");
INSERT INTO cko_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Saŋga bo Farasi­fɔm tiiri ka Yesu ajɔjɔ ayi Sadusi­fɔm ni, na ba tiɛn bu nɔɔ i dɔ. ");
INSERT INTO cko_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Na bu nu kun be, bo i ti Nyɛmɛ nɔaniɛ kere­fɔ n abisa Yesu bisaa­wa be ka i sɔ i ŋgɛɛ. I ŋa, ");
INSERT INTO cko_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Ya Kere­fɔ, Nyɛmɛ nɔaniɛ maa­wa n bo i wo i nɔaniɛ kpamaa­wa n nu ni, bɔnɔ tara bu kɛrɛ a?” ");
INSERT INTO cko_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Na Yesu abɔ i nu ka, “Ba kɛrɛ ka, ‘Koro Micɛra u Nyɛmɛ ni, ni u ahore­mbaa kun, ni u awiɛwiɛ, ni u sunsunni kɛrɛ.’ ");
INSERT INTO cko_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ahin ti nɔaniɛ maa­wa n bo i tara i kɛrɛ a. ");
INSERT INTO cko_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Bo i tɔ su nnyɔ su n ti ka nyini n wɔ. Ka o, ‘Koro u beŋgu kabo a koro u ŋu ni.’ ");
INSERT INTO cko_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Kabo ba kɛrɛ Nyɛmɛ nɔaniɛ kpamaa­wam n kadasi n nu, ni Nyɛmɛ nɔaniɛ kan­fɔm n dɛɛ n nu ni, i kɛrɛ jina ahin nɔaniɛ maa­wa nnyɔm n su wɔ.” ");
INSERT INTO cko_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Saŋga bo Farasi­fɔ nbem ba tiɛntiɛɛnri bu nɔɔ ni, na Yesu abisa bu jɔrɛ be fa kɔ Kristo Tii­de­fɔ n su. I ŋa, ");
INSERT INTO cko_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Am fa Kristo Tii­de­fɔ n bu ŋma a? Am sunsun ka i ti ŋma dɛɛ anuma a?” Na ba bɔ i nu ka, “I ti Fɛmɛ Davidi anuma a.” ");
INSERT INTO cko_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Na Yesu abisa bu ka, “Ye nzu ti ye Nyɛmɛ Awiɛwiɛ n ba wuraari Fɛmɛ Davidi ŋu, ye i fereeri i ka i Mibiɛ a? I ŋa, ");
INSERT INTO cko_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Na Micɛra n ase m Mibiɛ n ka, “Ba tana m saa fɔmbɔrɔ su fɛn, haari m bá má u kpɔ­fɔm kɛrɛ ba kutu u jaa bu.”’ ");
INSERT INTO cko_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Tɔ, nzɛn Fɛmɛ Davidi mmɔɔ ni i tii yo fereeri Kristo n ka i Mibiɛ, ye Kristo n yo sɛ kaaki yo Fɛmɛ Davidi anuma a?” ");
INSERT INTO cko_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Be akoro anya má nɔaniɛ be abɔ má i nu. Nyini ti, fite nyini cɛɛn n sin, be abo má su ka i bisa Yesu jɔrɛ bekun. ");
INSERT INTO cko_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Na Yesu ajɔjɔ i susu­fɔm n ni jama n dɔ, na wɔ se bu ka, ");
INSERT INTO cko_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Nyɛmɛ nɔaniɛ kere­fɔm, ni Farasi­fɔm n ade Moyisi dɛɛ jinaa­biri ni, ye bu kere minɛm Nyɛmɛ nɔaniɛ kpamaa­wa n a. ");
INSERT INTO cko_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Nyini ti, deke kɛrɛ bo bu fa kere am ni, am soro i su, ama, má am yo sam bo bu yo bu ni, dama bɛrɛ yo má sam bo bu kere ka minɛm yo bu ni. ");
INSERT INTO cko_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Bu cici sɔɔri nɔnɔɔri sɔ minɛm wɔ, ama, bɛrɛ ni bu tii soro má su ka bu fa bu saa kan i. ");
INSERT INTO cko_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Deke kɛrɛ bo bu yo i, bu koro ka minɛm ŋu bu wɔ, na bu kansi bu. Bu kɛrɛ Nyɛmɛ nɔaniɛ n wɔ, na bu yo i ka sɛbɛ, na bu fa cici bu ŋuma su, adena minɛm ŋu i. Na bu yo bu tanlɛɛ nɔɔ njɔrɛm tintiin. ");
INSERT INTO cko_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Nyini minɛm n anya awura bu tiɛntiɛn­bunɔɔ sɔɔm n nu ni, wara ba nya afere bu tiɛntiɛn­bunɔɔ bambaka diire dii­birim ni, bu koro ka bu tana kpirikoro tanaa­birim wɔ. ");
INSERT INTO cko_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Bu koro ka minɛm suyo bu ansɛ gɔɔsu wɔ, na bu ma bu jirima, na bu fere bu ka, ‘Ya Kere­fɔ.’ ");
INSERT INTO cko_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ambɛrɛ, má am ma be fere am ka ‘Ya Kere­fɔ,’ dama am la kere­fɔ kun n kpein wɔ. Ambɛrɛ kɛrɛ ti nibaam wɔ. ");
INSERT INTO cko_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Má am fere be ka am si, durunya n nu fɛn, dama am la Si kun n kpein wɔ, yiri wo aŋgoro n a. ");
INSERT INTO cko_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Má am ma be fere am ka i kpiɛn, dama am kpiɛn ti kun n kpein wɔ, yiri la Kristo Tii­de­fɔ ni. ");
INSERT INTO cko_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Bo i ti am kɛrɛ tii ni, wɔ yo daka ka yiri su am a. ");
INSERT INTO cko_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Sɔnɔ kɛrɛ bo i wura i ŋu kpiri, Nyɛmɛ yó i mi kaan, na sɔnɔ kɛrɛ bo i yo i ŋu kaan, Nyɛmɛ wúra i mi kpiri.” ");
INSERT INTO cko_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Na Yesu akaaki ase ka, “Ambɛrɛ Nyɛmɛ nɔaniɛ kere­fɔm, ni Farasi­fɔm n bo am ti burukɔɔ­nu­fɔm ni, am bá ŋu anyum­boro. Am kanda minɛm wɔ, adena má bu su Nyɛmɛ fɛmɛya n atin su, dama ambɛrɛ ni am tii kete ka am su má i atin n su, na am sukanda bo bu koro ka bu su i su ni.  ");
INSERT INTO cko_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Ambɛrɛ Nyɛmɛ nɔaniɛ kere­fɔm ni Farasi­fɔm n bo am ti burukɔɔ­nu­fɔm ni, am bá ŋu anyum­boro. Am sisi nkuna­fɔm na am fin bu neŋgem wɔ, na am jina sere Nyɛmɛ cɛ, adena minɛm ŋu ka am ti minɛ kpam wɔ. Jina cɛɛn, ambɛrɛ bá nya sui­cin tara minɛm kɛrɛ. ");
INSERT INTO cko_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ambɛrɛ Nyɛmɛ nɔaniɛ kere­fɔm ni Farasi­fɔm n bo am ti burukɔɔ­nu­fɔm ni, am bá ŋu anyum­boro. Am kpiɛ tiekum wɔ, na am kɔ miɛm bo bu waarim su, adena am nya sɔnɔ kun mmɔɔ bo i káaki i wo na i su am su, na saŋga bo am nya nyaari i mi, am ma i satiɛ yoo­wa tara am dɛɛ wɔ, adena yiri dú am mɔ kɔ cɛɛma sin nu. ");
INSERT INTO cko_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Ambɛrɛ bo am ti ka anyinsinm na am kere minɛm atin ni, am bá ŋu anyum­boro. Am ŋa nzɛn sɔnɔ taanri ndiɛ fa kɔ Nyɛmɛ Seree­biri Awuru n dɔ, i ti má pui. Ama, nzɛn sɔnɔ kɛrɛ bo i taanri sika neŋgem n bo bu wo Nyɛmɛ Seree­biri Awuru n nu ni, i mi ma i ndiɛ taan­wa n yo yii­wa. ");
INSERT INTO cko_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ambɛrɛ bo am ti ka anyinsin sinnzinm ni, bɔnɔ tara i beŋgu a? Sika neŋgem ni, nzɛn Nyɛmɛ Seree­biri Awuru n bo yiri ma sika neŋgem n yo casi n a? ");
INSERT INTO cko_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Am kaaki ŋa, nzɛn sɔnɔ taanri Mikun n yoo­wa yoo­biri ni, i ti má pui. Ama, nzɛn sɔnɔ taanri aceerim bo ba fa ase Mikun n yoo­wa yoo­biri n su ni, wɔ yo daka ka i mi ma i ndiɛ taan­wa n yo yii­wa. ");
INSERT INTO cko_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ambɛrɛ bo am ti ka anyinsinm ni, bɔnɔ tara i beŋgu a? Aceerim ni, nzɛn Mikun n yoo­wa yoo­biri n bo i ma aceerim n yo casi n a? ");
INSERT INTO cko_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Nyini dɛɛ ti, sɔnɔ kɛrɛ bo i taanri Mikun n yoo­wa yoo­biri ni, i mi atan i ni dekem kɛrɛ bo bu wo su n wɔ lɛɛ. ");
INSERT INTO cko_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Na sɔnɔ kɛrɛ bo i taanri Nyɛmɛ Seree­biri Awuru ni, i mi atan i ni Nyɛmɛ bo i wo nu n wɔ lɛɛ. ");
INSERT INTO cko_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Na nzɛn sɔnɔ kɛrɛ bo i taanri aŋgoro ni, i mi atan Nyɛmɛ fɛmɛya biɛ n wɔ lɛɛ, ni yiri Nyɛmɛ bo i tana su ni. ");
INSERT INTO cko_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Ambɛrɛ Nyɛmɛ nɔaniɛ kere­fɔm, ni Farasi­fɔm n bo am ti burukɔɔ­nu­fɔm ni, am bá ŋu anyum­boro. Am yi am jakam ma Nyɛmɛ wɔ, haari ni am maakunm, ni ŋgɛtɛm, ni nvan­nvanm kɛrɛ, ama, am yo má sam bo Nyɛmɛ nɔaniɛ kpamaa­wa n kere ka am yo bu n na bu la anyunuyi tara bu kɛrɛ ni. Bɛrɛ la nahɔrɛ sam, ni aŋunfɔ si, ni yarada­yo. Wɔ yo daka ka na am yo nyini sam saŋga kɛrɛ, na am fa jaka yii­wam buka su. ");
INSERT INTO cko_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ambɛrɛ ti ka anyinsinm na am kere minɛm atin ni. Am kpokpo yi ŋminsɛnm bo bu ti kan kanm n wɔ, am deke nuu­wam nu, ama, na am saŋga nu nyɔɔmam bɛrɛ, am deke nuu­wam nu. ");
INSERT INTO cko_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Ambɛrɛ Nyɛmɛ nɔaniɛ kere­fɔm, ni Farasi­fɔm n bo am ti burukɔɔ­nu­fɔm ni, am bá ŋu anyum­boro. Am ŋmisi am kɔpum ni taalɛm sin wɔ, ama, na bu kunnu ayi ni dekem bo am fin bu faŋga, ni anyii sa­yoo­wam wɔ. ");
INSERT INTO cko_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Wɔrɔ Farasi­fɔ bo a ti ka anyinsin ni, du mɔ yo u kɔpu n kunnu casi ka, na i sin n gusu nyá yo casi. ");
INSERT INTO cko_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Ambɛrɛ Nyɛmɛ nɔaniɛ kere­fɔm, ni Farasi­fɔm n bo am ti burukɔɔ­nu­fɔm ni, am bá ŋu anyum­boro. Am ti ka faŋ­kunmam bo ba bo bu nzue fofoe kpakpari, na bu yo nyunyumi n wɔ, ama, bu kunnu yiri ayi ni fuin buwem wɔ, ni fin barasu kɛrɛ. ");
INSERT INTO cko_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Am ti sɔ ɔ lɛɛ. Am ma minɛm ŋu am ka am ti minɛm bo bu yo sa bo i kɔ atin su Nyɛmɛ dɔ n wɔ, ama, am ahore su ayi ni burukɔɔ­nu, ni satiɛm wɔ.” ");
INSERT INTO cko_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Na Yesu asa su ase ka, “Ambɛrɛ Nyɛmɛ nɔaniɛ kere­fɔm, ni Farasi­fɔm n bo am ti burukɔɔ­nu­fɔm ni, am bá ŋu anyum­boro. Am yo faŋ­kunmam dɔŋgu fa ma Nyɛmɛ nɔaniɛ kan­fɔm wɔ, na am yo minɛm bo bu yo sa bo i kɔ atin su Nyɛmɛ dɔ n faŋ­kunmam nyunyumi. ");
INSERT INTO cko_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Na am se ka, nzɛn má ambɛrɛ yo woori bɛrɛ, am nam saŋga ni, má am kun má Nyɛmɛ nɔaniɛ kan­fɔm n ni, kabo am nam yo yoori bu ni. ");
INSERT INTO cko_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Nyini ti, am asoro su ka am ti bɛrɛ bo bu yo kuunri Nyɛmɛ nɔaniɛ kan­fɔm n dɛɛ busu nu­fɔm wɔ lɛɛ. ");
INSERT INTO cko_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Tɔ, i ti ye ni ka am de am nam jinaa­biri ni, na am yo bu satiɛ yoo­wam n kɔ wie. ");
INSERT INTO cko_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ambɛrɛ burukɔɔ­nu­fɔm bo am ti woom na am ti ka pumpuni nbaam ni, am yo sɛ ye am koro ŋmati fite nu, bo am wura má cɛɛma sin n nu a? ");
INSERT INTO cko_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Nyini ti ye m súnma Nyɛmɛ nɔaniɛ kan­fɔm, ni minɛ alecira­fɔm, ni kere­fɔm am dɔ n a. Am kún bu nbem, na am fá bu nbem sense baka jaanu n su, na am fín bu nbem ŋgbere, am tiɛntiɛn­bunɔɔ sɔɔm n nu, na am kɔ́ miɛ miɛm su na am kere bu wuwuruwa. ");
INSERT INTO cko_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Nyini dɛɛ ti, Nyɛmɛ cín ambɛrɛ sui fa kɔ kabo am nam yo kuunri minɛm bo bu yo sa bo i kɔ atin su Nyɛmɛ dɔ durunya n nu. Bu yo yoori sɔ ɔ fite saŋga n bo bu kuunri sɔnɔ be bo i yo sa bo i kɔ atin su Nyɛmɛ dɔ n na bu fere i ka Abɛli ni, fa ba juuri saŋga n bo bu kuunri sɔnɔ be bo bu fere i ka Zakariya, Berakaya wa ni. Yiri ye am kuunri i Nyɛmɛ Seree­biri Awuru n nu, Casi Kɛrɛ Casi Sɔɔ n ni Mikun yoo­wa yoo­biri n afiɛn n a. ");
INSERT INTO cko_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nahɔrɛ ye m suse am n a, nyini n kɛrɛ dɛɛ ti ye Nyɛmɛ bá cin ambɛrɛ nyuma­fɔm sui n a.” ");
INSERT INTO cko_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Na Yesu abo awie ase ka, “Keto, keto, ambɛrɛ Yɛrusalem­fɔm. Ambɛrɛ kuunri Nyɛmɛ nɔaniɛ kan­fɔm n a, na minɛm bo Nyɛmɛ sunmaari bu am dɔ ni, am atu bu yabuɛ. Saŋga kɛrɛ m koroori ka m tiɛn am nɔɔ, na m fa m saa bara yɛ am, kabo akɔ tiɛn i nbaam nɔɔ, i laŋkpɛtɛ nu ni, ama, am soro má m su. ");
INSERT INTO cko_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Am niɛ fɛn, Nyɛmɛ yáki am nu ji, na am miɛ n ká ŋgbɛɛn. ");
INSERT INTO cko_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","M suse am wɔ lɛɛ, ka, fite kisa fa kɔ, am ŋú má m kun, má ka saŋga bo am bá se ka, ‘Tere­fiɛ wo yiri n bo i suba Micɛra n dɛɛ duma n nu n dɔ.’” ");
INSERT INTO cko_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Saŋga bo Yesu fiteeri Nyɛmɛ Seree­biri Awuru n nu na i wo kɔ su ni, na i susu­fɔm n aba i dɔ, aba ase i ka i niɛ kabo Nyɛmɛ seree­biri n ti barasu a. ");
INSERT INTO cko_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Na wɔ se bu ka, “M ŋa am aŋu ahinm kɛrɛ e? Nahɔrɛ ye m suse am n a, yabuɛ kun n kpein n mmɔɔ bá nana má i beŋgu su. Bu bá bereki i kɛrɛ gɔ ɔ lɛɛ.” ");
INSERT INTO cko_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Saŋga bo Yesu fun kɔ tanaari Oliva Buka n su ni, na i susu­fɔm n aba i dɔ, bu ni yiri ŋgumi, na ba se i ka, “Ya Kere­fɔ, se ya, saŋga bɔnɔ ye ahin sam kɛrɛ bá yo a? Ye nzu deke bá kere ya ka saŋga n adodo bo a bá bekun, na durunya n bá awieeri a?” ");
INSERT INTO cko_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Na Yesu abɔ bu nu ka, “Am si am ŋu sa, na má am ma be dadaka am. ");
INSERT INTO cko_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Dama minɛ dɔŋgu bá fa m duma ba, na bu sé ka, ‘Kristo Tii­de­fɔ n la mini wɔ.’ Na bu dádaka minɛ beberebe. ");
INSERT INTO cko_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Saŋga bo am bá ti aluwa ŋga fɛn, wara bu sukun luɛ dɔ, má am ma am ahore saaki. Wɔ yo daka ka nyini sam n kɛrɛ bá yo sin ka, ama, má am niɛ ka durunya n awieeri lɛɛ. ");
INSERT INTO cko_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Daanfiɛ daanfiɛ bá kun luɛ ni bu beŋgum, na nfɛmɛm kún luɛ ni bu beŋgu nfɛmɛm. Na asiɛn bá kpisi awɔrɛ awɔrɛm nu, na ahɔɛ tɔ́. ");
INSERT INTO cko_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Nyini n kɛrɛ bá yo kabo bara kutu cɛɛn bumboori dɛɛ wahara n ti n wɔ. ");
INSERT INTO cko_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Nyini saŋga, na bu tára am ma yiko­fɔm na bu kére am wuwuruwa, na bu kún am. Mini dɛɛ ti, sɔnɔ kɛrɛ kpɔ́ am. ");
INSERT INTO cko_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Nyini saŋga n na minɛ dɔŋgu bá kete m na bu su má m kun, na bu tɔ́ bu beŋgu, na bu kpɔ́ bu beŋgu. ");
INSERT INTO cko_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Na kɔrɛ­fɔm dɔŋgu bo bu yo bu ŋu ka bɛrɛ ti Nyɛmɛ nɔaniɛ kan­fɔm ni bá ba, na bu dádaka minɛm beberebe. ");
INSERT INTO cko_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Satiɛ­yo bá sunnu n dɛɛ ti, minɛ dɔŋgu koro bá kɔ i sin. ");
INSERT INTO cko_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ama, wɔrɔ kɛrɛ bo a mindi deeri nyini n kɛrɛ kɔ juuri i awieeri, Nyɛmɛ dé u tii ji. ");
INSERT INTO cko_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Na bu bá kan ahin labari kpa n fa kɔ Nyɛmɛ fɛmɛya n jɔrɛ su, kere durunya n nu­fɔm, na adamande kɛrɛ tí i ka, na durunya n nya bá awieeri.” ");
INSERT INTO cko_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Na Yesu akaaki ase bu ka, “Am bá ŋu anyumbaa ciire sa be bo Nyɛmɛ mmɔɔ kpɔ i n na Nyɛmɛ nɔaniɛ kan­fɔ Daniɛli yo jɔjɔɔri i jɔrɛ ni, ka i jina sɔɔ casi n bo i wo Nyɛmɛ Seree­biri Awuru n nu ni. Ma sɔnɔ kɛrɛ bo i kan ahin kadasi n ti i bu nyunyumi. ");
INSERT INTO cko_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Nyini saŋga ni, wɔrɔ kɛrɛ bo a tiiri i ŋga na a wo Yudiya asiɛn n su, ŋmati kɔ bukam n su. ");
INSERT INTO cko_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Wɔrɔ kɛrɛ bo a wo kpata nu, má a wura gisan nu fa pui. ");
INSERT INTO cko_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Na wɔrɔ kɛrɛ gusu bo a wo fiesu, má a kpie u nyi kɔ awuru kɔ fa u sutura be. ");
INSERT INTO cko_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Nyini saŋga ni yó kekereke agaya ma nyinsɛ­fɔm, ni nbaram bo bu nbaam toko nu ni. ");
INSERT INTO cko_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Am sere Nyɛmɛ ka má nyini sa n yó buke saŋga, wara Yuda­fɔm Ŋumi­yi cɛɛn ni. ");
INSERT INTO cko_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Nyini saŋga ni wahara bo minɛ dí i, i tára wahara kɛrɛ bo ba di i asin ni, fite saŋga n bo Nyɛmɛ yiiri durunya ni, haari ni kisa. Nahɔrɛ, nyini wahara n ŋusu bá má kun. ");
INSERT INTO cko_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ama, Nyɛmɛ akpiɛ nyini saŋga n su. Nzɛn má wɔ kpiɛ má i su, má sɔnɔ wo má bɛrɛ bo i nya ŋgɔɔ, ama, i dɛɛ tiɛŋgu minɛm bo wɔ yi bu n dɛɛ ti, ye wɔ kpiɛ saŋga n su a. ");
INSERT INTO cko_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Nyini saŋga ni, na nzɛn be bá se am ka, ‘Am niɛ, Kristo Tii­de­fɔ ni wo fɛn n a,’ wara, ‘Am niɛ, yiri wo dɔ n a,’ má am de i mi nɔaniɛ ni. ");
INSERT INTO cko_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Dama kɔrɛ­fɔ nbem bá ba, na bu yó bu ŋu ka bɛrɛ ti Kristo n a, na nbem gusu yó bu ŋu ka bu ti Nyɛmɛ nɔaniɛ kan­fɔm wɔ. Bu yó alekutura sam beberebe fa kere am, na nzɛn bu koro nyaari atin, bu dádaka Nyɛmɛ dɛɛ minɛm mmɔɔ bo wɔ yi bu ni. ");
INSERT INTO cko_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ambɛrɛ, am ti fɛn, ma se am wɔ lɛɛ ka, na saŋga n nyá ba ju. ");
INSERT INTO cko_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Na nzɛn be bá seeri am ka, ‘Am niɛ, Kristo ni wo boro kpantain n nu dɔ n a,’ má am kɔ dɔ. Wara, nzɛn be bá seeri am ka, ‘Yiri fiɛ sɔrɔ dɔ n a,’ má am yo i mi yarada. ");
INSERT INTO cko_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Dama mini Adamande Wa n ba ni, i bá ti kabo nzue kpɛsɛ na i ta bara yɛ deke kɛrɛ n wɔ, fite wiɛ afiiri fa kɔ ju wiɛ atɔɔri n wɔ. ");
INSERT INTO cko_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Deke kɛrɛ bo deke fuin nya wo, pɛtɛm bara yɛ dɔ ɔ.” ");
INSERT INTO cko_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Na Yesu akaaki ase bu ka, “Saŋga bo nyini wahara n kɛrɛ ba siinri, ‘Awosin káta wiɛ n su, na sara n gusu tá má bo minɛm ŋu i. Na asara­mbaam fíte aŋgoro titi tɔtɔ, na aŋgoro n kɛrɛ kpísi.’ ");
INSERT INTO cko_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Nyini saŋga ni, na minɛ ŋú deke be aŋgoro bo i kere ka mini Adamande Wa ni suba. Na minɛm bo bu wo durunya n nu n kɛrɛ bó awie, na bu nyá ŋu ka mini Adamande Wa ni sufite aŋgoro yinyiŋgu n nu suje piɛpiɛu suba ni yiko bambaka ni. ");
INSERT INTO cko_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Na bu tí ka awiɛ be sukpura ni faŋga su, na m nyá sunma Nyɛmɛ mɛrɛkɛm durunya n awɔrɛ n kɛrɛ nu, na bu tíɛn minɛm bo Nyɛmɛ ayi bu durunya n nu n kɛrɛ nɔɔ.” ");
INSERT INTO cko_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Na Yesu akaaki ase ka, “Am fa damba baka n fa se nyaari. Saŋga bo am ba ŋu ka i nyawa akpɔnkpɔn, na i sufiɛfiɛ fɔfɔrɛ ni, am si ka dɔdɔɔri saŋga adodo lɛɛ. ");
INSERT INTO cko_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Mini Adamande Wa n ba ni bá yo sɔ ɔ. Saŋga bo am ba ŋu ka nyini sam kɛrɛ bá suyo ni, am si tenle su ka saŋga n adodo lɛɛ, i cɛ́ má kun. ");
INSERT INTO cko_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nahɔrɛ ye m suse am n a, ahin nyuma­fɔm busu kɛrɛ wú wie má ka, ye nyini sam kɛrɛ bá yo a. ");
INSERT INTO cko_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Aŋgoro n ni asiɛŋgu n kɛrɛ bá la awieeri, ama, m dɛɛ nɔaniɛ n yiri la má awieeri cɛɛn be.” ");
INSERT INTO cko_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Na Yesu akaaki ase ka, “Be si má saŋga ni, wara cɛɛn n bo m bá kpie m nyi ba ni. Haari Nyɛmɛ mɛrɛkɛm bo bu wo i dɔ ni, ni mini bo m ti i wa ni mmɔɔ si má. Má ka ya Si Nyɛmɛ ŋgumi si a. ");
INSERT INTO cko_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Mini Adamande Wa n ba saŋga ni yó kabo sɔnɔ be bo bu fere i ka Nowa saŋga na i yoori n wɔ. ");
INSERT INTO cko_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Saŋga bo wɔmbu n nya di má durunya n ni, sɔnɔ kɛrɛ woori di ni nu su wɔ, na nbaram ni nbiɛsɔm suja bu beŋgum, fa kɔ juuri haari cɛɛn n bo Nowa wuraari lee bambaka n nu ni. ");
INSERT INTO cko_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Minɛm ayo asi má sa bo i bá yo ni, haari cɛɛn n bo wɔmbu n ba diiri bu kɛrɛ ni. I yó sɔ ɔ, fa kɔ saŋga n bo mini Adamande Wa ni bá ba ni. ");
INSERT INTO cko_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Nyini saŋga ni, minɛ nnyɔ bá wo juma yo su fiesu, na Nyɛmɛ má bu bá fa kun n kɔ yaki kun ni. ");
INSERT INTO cko_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Na nbaram nnyɔ wo ŋgani saan­biri, na Nyɛmɛ má bu bá fa kun n kɔ yaki kun ni. ");
INSERT INTO cko_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Tɔ, nyini ti, má am fa am ŋu ji na am daafi, dama am si má cɛɛn n bo am Mibiɛ ni bá ni. ");
INSERT INTO cko_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Am si tenle su ka nzɛn má awuru­fɔ­biɛ n si saŋga bo awiefɔ ni bá i dika na i bá wɔ i, má i tana ŋminda a, na awiefɔ n koro ba wura má. ");
INSERT INTO cko_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Nyini ti, ambɛrɛ gusu kpa am ŋu saŋga kɛrɛ, dama mini Adamande Wa ni, m bá saŋga bo am sunsun má ka m bá n wɔ.” ");
INSERT INTO cko_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Na Yesu akaaki ase ka, “Akɔɔ kpiɛn n bo i la dabuŋu na i kaaki la alecira n la ŋma a? Yiri la bo i mibiɛ n afa akɔɔ nyiŋgam awura i saa nu ka i kpaaki diire nu ma bu, saŋga bo i ti ye ni ka i ma bu ni. ");
INSERT INTO cko_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Nzɛn i mibiɛ n ba ŋuuri ka i suyo i juma kabo i seeri ka i yo ni, tere­fiɛ wo nyini akɔɔ n dɔ. ");
INSERT INTO cko_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nahɔrɛ ye m suse am n a, mibiɛ ni fá i aja kɛrɛ wura nyini akɔɔ n saa nu wɔ, na i níɛ i dika. ");
INSERT INTO cko_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ama, nzɛn i ti akɔɔ tiɛ­fɔ, i súnsun ka i mibiɛ ni kpíe má i nyi nde. ");
INSERT INTO cko_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","A ŋu ka i subo akɔɔ nyiŋgam wɔ, na i sudi, na i ni nzan nu­fɔm sunu bo. ");
INSERT INTO cko_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Dɔ, na i mibiɛ n ba kpieeri i nyi baari cɛɛn bo i sunsun má ka i bá, na i kaaki si má ba n saŋga ni. ");
INSERT INTO cko_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Nyini saŋga n na i mibiɛ n cín i sui agaya, na i fá i bo burukɔɔ­nu­fɔm n su. Dɔ na i sún, na i kán i saa.” ");
INSERT INTO cko_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Na Yesu akaaki ase bu ka, “Saŋga bo mini Adamande Wa ni bá ba, na Nyɛmɛ Fɛmɛ bá niɛ i minɛm su ni, i yó ka nsuŋguru buru nbem bo bu faari bu fitanam ka bu kɔ kpa konyafan atin n wɔ. ");
INSERT INTO cko_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Bu minɛ nnu tiiri alecira­fɔm wɔ, na nnu nyiŋgam n ati sinnzinm. ");
INSERT INTO cko_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Na sinnzinm n afa bu fitanam, ama, ba bita má ŋguin nu, ");
INSERT INTO cko_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","na alecira­fɔm n bɛrɛ afa ŋguin abita nu. ");
INSERT INTO cko_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Na ba kɔ aŋminda konyafan n acɛ, wɔ ba má nde, na daafiri aba ati nsuŋgurum ni, na ba daafi. ");
INSERT INTO cko_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Na jinanjin saŋga, na ba ti ka bu subo ndoori ka, ‘Konyafan ni suba o, am fite na ya kɔ kpa i atin.’ ");
INSERT INTO cko_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Na nsuŋguru burum kɛrɛ ayasu, ayo bu fitanam dɔŋgu. ");
INSERT INTO cko_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Na sinnzinm n ase alecira­fɔm ni ka, ‘Am bu am ŋguin n be ma ya, ya fitanam ni sunɔ.’ ");
INSERT INTO cko_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Na alecira­fɔm n ase bu ka, ‘Ai, ya ŋguin ni koro ju má ya ni ambɛrɛ kɛrɛ. Am kɔ ŋguin tɔ­fɔm dɔ, na am kɔ to.’ ");
INSERT INTO cko_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Na nsuŋguru sinnzinm n akɔ ka bu kɔ to ŋguin ni. Bu kɔ wieeri ni, na konyafan n aju. Na nsuŋguru nnum bo ba kpa bu ŋu ni, asu i su, awura konyaya awuru n nu. Na ba tu anɔ ni. ");
INSERT INTO cko_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Kasin, na nsuŋguru nyiŋgam bo bu kɔɔri ŋguin to ni, aba ajina anɔ n nu, abo afere i ka, ‘Ya mibiɛ, ya mibiɛ, teke anɔ n ma ya na ya wura.’ ");
INSERT INTO cko_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Na konyafan n ase bu ka, ‘Ai, nahɔrɛ ye m suse am n a, m si má am cɛɛn be cɛɛn be.’” ");
INSERT INTO cko_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Na Yesu ase i susu­fɔm n ka, “Tɔ, nyini ti, má am fa am ŋu ji na am daafi, dama am si má cɛɛn n bo m bá ni.” ");
INSERT INTO cko_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Na Yesu ase bu ka, “Saŋga bo m bá ba ni, i yó kabo sɔnɔ be sukɔ atin, na i fereeri i akɔɔm, na i faari i neŋge kɛrɛ wuraari bu saa nu, ka bu niɛ i dika n wɔ. ");
INSERT INTO cko_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Na wɔ fa ŋwaa akpaaki bu kɛrɛ nu, kabo bu koro bita i barasu. I faari ŋwaa n busu nnu maari kun wɔ, na wɔ fa busu nnyɔ n ama kun gusu, na wɔ nya afa busu kun n ama nyiŋga ni. Na wɔ kɔ atin ni. ");
INSERT INTO cko_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Na bo i maari i busu nnu ni afa abo wata bu, na wɔ nya i ŋusu nnu abuka su. ");
INSERT INTO cko_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Na bo i maari i busu nnyɔ n gusu ayo sɔ, na wɔ nya i ŋusu nnyɔ abuka su. ");
INSERT INTO cko_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ama, bo i maari i sesee­wa kun ni kɔ funduuri kunma wɔ, na wɔ fa i dɛɛ ŋwaa n awura nu, na wɔ kata su. ");
INSERT INTO cko_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Na bu mibiɛ n akɔ acɛ dɔ, haari na wɔ ba aba ka i ba niɛ kabo bu bita i ŋwaa n barasu ni. ");
INSERT INTO cko_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Na bo i maari i busu nnu n afa i dɛɛ ŋwaa aba, na wɔ se i mibiɛ n ka, ‘M mibiɛ, niɛ. A maari m ŋwaa n busu nnu wɔ, ama, ma nya i ŋusu nnu abuka su.’ ");
INSERT INTO cko_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Na i mibiɛ n ase i ka, ‘Nfan. Wɔrɔ akɔɔ kpa bo a la dabuŋu ni, kabo a kere ka a la dabuŋu niɛ deke kaan su ni, m fá dɔŋgu n mmɔɔ wura u saa nu na a niɛ i dika. Bra na a ba nya ahorejɔ n bo ma nya i n be.’ ");
INSERT INTO cko_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Na bo i maari i busu nnyɔ n gusu aba ase i mibiɛ n ka, ‘M mibiɛ, niɛ. A maari m ŋwaa n busu nnyɔ ɔ, ama, ma nya i ŋusu nnyɔ abuka su.’ ");
INSERT INTO cko_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Na i mibiɛ n ase i ka, ‘Nfan. Wɔrɔ akɔɔ kpa bo a la dabuŋu ni, kabo a kere ka a la dabuŋu niɛ deke kaan su ni, m fá dɔŋgu n mmɔɔ wura u saa nu na a niɛ i dika. Bra na a ba nya ahorejɔ n bo ma nya i n be.’ ");
INSERT INTO cko_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Kasin, na bo i maari i sesee­wa kun ni aba, na wɔ se ka, ‘M mibiɛ, m si u sa ka a ti sɔnɔ faŋga­fɔ ɔ. Deke bo a dɔ má i ni, a kpiɛ nyini wɔ. Na deke bo a bobo má i ni, a tiɛntiɛn nyini nɔɔ a. ");
INSERT INTO cko_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nyini ti ye sɛrɛ tiiri m a, na ma fundu kunma afa u ŋwaa n afiɛ i nu. Yiri yaa, de u deke.’ ");
INSERT INTO cko_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Na i mibiɛ n akaaki ase i ka, ‘Wɔrɔ akɔɔ tiɛ nviɛya­fɔ ni, a si tenle su ka deke bo ma dɔ má i ni, m kpiɛ nyini wɔ, na deke bo ma bobo má i ni, m tiɛntiɛn nyini nɔɔ a. ");
INSERT INTO cko_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Tɔ, má a si ka i ti sɔ ni, má wɔ yo daka ka a fa m ŋwaa n kɔ seeri baŋkifɔm dɔ, na má m ba kpieeri m nyi baari, má m de m deke na m nya kpɛrɛ buka su.’ ");
INSERT INTO cko_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Dɔ na mibiɛ n ase i minɛm ka, ‘Tɔ, am de ŋwaa ni i dɔ kisa kisa, na am fa ma akɔɔ n bo i bita ŋwaa n busu buru ni. ");
INSERT INTO cko_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Dama sɔnɔ kɛrɛ bo wɔ nya deke na i mi si i bita, bu má i buka su wɔ, na i nyá beberebe, ama, bo i si má i bita, haari ni nyini kaan n bo i la i ni, bu cín de i dɔ ɔ. ");
INSERT INTO cko_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ama, m ahin akɔɔ ŋgbɛɛn ni, am fa i tu awosin n nu, deke bo i sún, na i kán i saa.’” ");
INSERT INTO cko_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Na Yesu akaaki ase ka, “Saŋga bo mini Adamande Wa ni bá baari ni m jirima woo­wa n nu ni, ni Nyɛmɛ mɛrɛkɛm kɛrɛ ni, m bá tana m jirima fɛmɛya biɛ n su. ");
INSERT INTO cko_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Na durunya n nu minɛm kɛrɛ bá tiɛn bu nɔɔ m nyunu, na m kpáaki bu nu, busu nnyɔ, kabo bɔɛ­sasa­fɔ kpaaki yi nbɔɛm ni sirim nu barasu ni. ");
INSERT INTO cko_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Na m má m dɛɛ minɛm bo bu ti ka nbɔɛm ni jina m saa fɔmbɔrɔ su, na m má bo ba ka na bu ti ka sirim ni jina m saa biɛ su. ");
INSERT INTO cko_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Na mini fɛmɛ n sé bo bu wo m saa fɔmbɔrɔ su n ka, ‘Ambɛrɛ bo m Si Nyɛmɛ ayo am kisi ni, am bra na am ba de fɛmɛya n bo wɔ sɛsɛ i su ase ama am, fite durunya n bumboori kɛrɛ ni. ");
INSERT INTO cko_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Deke bo i ti na m se am sɔ n la ka, ahɔɛ yo tiiri m, na am ama m diire. Nzuehɔɛ yo tiiri m, na am ama m nzue. M yo baari am dɔ ka wɔfɔ, na am ade m. ");
INSERT INTO cko_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","M yo kaari m bu ŋgbɛɛn, na am ama m sutura. M yo daari tukpaki, na am aba aniɛ m dika. Bu yo nyiiri m dan­saraka, na am akɔ aniɛ m busu.’ ");
INSERT INTO cko_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Dɔ na m minɛm bo bu yo sa bo i kɔ atin su ni nyá bɔ m nu ka, ‘Ya Mibiɛ, saŋga bɔnɔ ye ya ŋuuri ka ahɔɛ ati u, ye ya maari u diire a, wara nzuehɔɛ ati u, ye ya maari u nzue a? ");
INSERT INTO cko_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Saŋga bɔnɔ tenle su, ye a baari ya dɔ ka wɔfɔ, ye ya deeri u a, wara saŋga bɔnɔ ye a kaari u bu ŋgbɛɛn, ye ya maari u sutura a? ");
INSERT INTO cko_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Saŋga bɔnɔ ye ya ŋuuri ka a daari tukpaki, wara saŋga bɔnɔ ye bu nyiiri u dan­saraka, ye ya kɔ niɛɛri u busu a?’ ");
INSERT INTO cko_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Dɔ na m nyá bɔ bu nu ka, ‘Nahɔrɛ ye m suse am n a, saŋga kɛrɛ bo am yo yoori sakpa fa maari m ahin ninbaa kan kanm ni kun, am yo maari mini wɔ lɛɛ.’ ");
INSERT INTO cko_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Na m nyá se bo bu wo m saa biɛ su n ka, ‘Ambɛrɛ bo m Si Nyɛmɛ ayo am ŋgbɛɛn na wɔ fa nɔɔ tiɛ ase am ŋu ni, am fa cinsi m bi bɛrɛ na am kɔ wura sin n bo i nɔ má n nu, nyini sin n ye ba tɔrɔ i afa ase Sitana ni i dɛɛ mɛrɛkɛm n a. ");
INSERT INTO cko_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Deke bo i ti na m se am sɔ n la ka, ahɔɛ yo tiiri m, ama, am ama má m diire. Nzuehɔɛ yo tiiri m, ama, am ama má m nzue. ");
INSERT INTO cko_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","M yo baari am dika, ama, am ade má m wɔfɔ. M yo kaari m bu ŋgbɛɛn, ama, am ama má m sutura. M yo daari tukpaki, wara m yo woori dan­saraka nu, ama, am akɔ aniɛ má m busu.’ ");
INSERT INTO cko_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Dɔ na bɛrɛ bo bu wo m saa biɛ su ni nyá bɔ m nu ka, ‘Ya Mibiɛ, saŋga bɔnɔ ye ya ŋuuri u ka ahɔɛ ati u, wara nzuehɔɛ ati u, wara a baari ya wɔfɔ, wara a kaari u bu ŋgbɛɛn, wara a daari tukpaki, wara a woori dan­saraka, ye ya buka má u a?’ ");
INSERT INTO cko_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Na m nyá kaaki se bu ka, ‘Nahɔrɛ ye m suse am n a, saŋga kɛrɛ bo am ayo má sakpa, ama má m ahin ninbaa kan kanm ni kun, am ayo ama má mini wɔ lɛɛ.’ ");
INSERT INTO cko_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Na nyinim bɛrɛ kɔ́ wo sui­cin n bo i la má awieeri n nu. Ama, na bo bu yo sa bo i kɔ atin su Nyɛmɛ dɔ ni, bɛrɛ kɔ́ wo ŋgɔɔ bo i la má awieeri n nu.” ");
INSERT INTO cko_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Saŋga bo Yesu kereeri nyini keree­wam kɛrɛ wieeri ni, na wɔ se i susu­fɔm ni ka, ");
INSERT INTO cko_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Am si ka wɔ ka le­nnyɔ ɔ, na bu di Butara cɛɛn­kpiri ni. Dɔ ye bu nyá mini Adamande Wa n taraa­biri a, na bu kpáma m baka jaanu n su.” ");
INSERT INTO cko_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Dɔ na Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ nkpiɛn­kpiɛnm ni, ni Yuda­fɔm nkpiɛn­kpiɛnm n atiɛn bu nɔɔ bu kpiɛn n dika, bu fere i ka Kayafasi, yiri ti Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm kɛrɛ kpiɛn a, ");
INSERT INTO cko_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","na ba fa sɛsɛ­su ka bu tara Yesu asiri nu na bu kun i. ");
INSERT INTO cko_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Na ba se bu ŋuŋu nu ka, “Má am ma ya yo i cɛɛn­kpiri n saŋga. Má nyini, minɛm ni kéte yo naŋmiɛ wɔ, na bu sutiɛntiɛn.” ");
INSERT INTO cko_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesu woori Betani miɛ n nu wɔ, sɔnɔ be dika, bu fere i ka Simon, i yo ti koko­fɔ ɔ. ");
INSERT INTO cko_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Saŋga bo Yesu wo diire di su ni, na bara be aba i dɔ, ni tulaalɛɛ tuwa nva­nvani bo i la gɔ agaya. Na wɔ teke tulaalɛɛ tuwa n nɔɔ, na wɔ kaaki tulaalɛɛ n kɛrɛ agɔ Yesu tii su. ");
INSERT INTO cko_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Yesu susu­fɔm ni ŋuuri i sɔ ni, na yaa ati bu agaya, na ba bisa bu ŋuŋu nu ka, “Nzu ti ye wɔ saaki i sɔ a? ");
INSERT INTO cko_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Má ya tɔɔri nyini tulaalɛɛ ni, má ya nyá ŋwaa beberebe, na má ya fá nyini ŋwaa n ma yaari­fɔm.” ");
INSERT INTO cko_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Na Yesu asi sunsunni bo bu bita i, na wɔ se bu ka, “Nzu ti ye am sukan bara ni ndiɛ a? Sakpa lɛɛ ye wɔ yo ama m n a. ");
INSERT INTO cko_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Am ni yaari­fɔm ni wo bɛrɛ saŋga kɛrɛ a, ama, mini, m wó má am dɔ saŋga kɛrɛ. ");
INSERT INTO cko_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Tulaalɛɛ n bo wɔ kaaki agɔ m ŋu ni, i kere ka i nzee bo wɔ fa ayo m siriya afa aŋminda m yiwee cɛɛn lɛɛ. ");
INSERT INTO cko_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nahɔrɛ ye m suse am n a, deke kɛrɛ bo bu bá kaanri Nyɛmɛ labari kpa n durunya n kɛrɛ nu, bu kán i sa­yoo­wa n na minɛm teŋge i su.” ");
INSERT INTO cko_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Na Yesu susu­fɔ buru ni nnyɔm nu kun bo bu fere i ka Yudasi Isikariyoti ni, akɔ Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ nkpiɛn­kpiɛnm ni dɔ, ");
INSERT INTO cko_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","akɔ abisa bu ka, “Nzɛn m tɔɔri Yesu maari am, am má m nzu wɔ?” Na ba kan jɛtɛ ŋwaa abura­san, afa ama i. ");
INSERT INTO cko_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Fite nyini cɛɛn n na Yudasi akpini atin kabo i yó na bu nya Yesu taraa­biri. ");
INSERT INTO cko_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Na cɛɛn­kpiri n bo bu di i ni kpɔnɔ bo bu gɔ má ayiri nu na i yasu ni, i le­kun cɛɛn, na Yesu susu­fɔm n aba i dɔ, aba abisa ka, “A koro ka ya kɔ ni kɔ sɛsɛ Butara cɛɛn­kpiri n diire n su se a?” ");
INSERT INTO cko_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Na wɔ se bu ka, “Am kɔ miɛ n kunnu, sɔnɔ be wo dɔ, na am kɔ se i ka, ‘Ya Kere­fɔ n ŋa o, i saŋga n aju. Na i ni i susu­fɔm ni bá di Butara cɛɛn­kpiri diire ni, u dika n nu.’” ");
INSERT INTO cko_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Na Yesu susu­fɔm n akɔ ayo kabo i seeri bu ni, na ba sɛsɛ Butara cɛɛn­kpiri n diire n su. ");
INSERT INTO cko_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Na naasɔ saŋga, na Yesu ni i susu­fɔ buru ni nnyɔm n aba atana ka bu di diire ni. ");
INSERT INTO cko_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Saŋga bo bu tana wo diire n di su ni, na Yesu ase bu ka, “Nahɔrɛ ye m suse am n a, am nu kun bá tɔ m ma m kpɔ­fɔm a.” ");
INSERT INTO cko_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Na bu ahore asaaki, na bu kun kun n kɛrɛ abisa i ka, “M Mibiɛ, ye m ŋa má mini yiri e?” ");
INSERT INTO cko_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Na Yesu abɔ bu nu ka, “Am nu kun bo m ni yiri saŋga fa ya saa wura taalɛ kun nu ni, yiri tɔ́ m a. ");
INSERT INTO cko_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mini Adamande Wa ni wú kabo ba kɛrɛ i Nyɛmɛ Jɔrɛ Kadasi n nu ase ka m wú n wɔ, ama, sɔnɔ n bo i tɔ mini Adamande Wa n ni, i mi bá ŋu anyum­boro. Má ba wu má i mi n mmɔɔ, má i ti ye.” ");
INSERT INTO cko_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Na Yudasi bo i tɔ́ Yesu n abisa i ka, “Ya Kere­fɔ, m ŋa má mini yiri e?” Na Yesu abɔ i nu ka, “Kabo a jɔjɔɔri ni, i ti sɔ ɔ.” ");
INSERT INTO cko_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Saŋga bo Yesu ni i susu­fɔm ni wo diire n di su ni, na Yesu afa kpɔnɔ, na wɔ da Nyɛmɛ asi, na wɔ bubu i nu, na wɔ fa ama bu, na wɔ se bu ka, “Am de ahin kpɔnɔ n na am di, i ti m ŋuniɛ­mbaa a.” ");
INSERT INTO cko_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Na wɔ kaaki afa awa ni nzan, na wɔ da Nyɛmɛ asi, na wɔ fa ama bu, na wɔ se bu ka, “Am kɛrɛ nu be. ");
INSERT INTO cko_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ahin nzan n ti m mbunja a lɛɛ, ye m sufa ma am n a. M mbunja n dɛɛ ti, ye Nyɛmɛ sufa sɛsɛ­su na i di i di n a. Minɛm dɔŋgu satiɛ dɛɛ ti, ye m mbunja ni soŋgi gɔ a, na Nyɛmɛ fa bu satiɛ ce bu.” ");
INSERT INTO cko_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Na wɔ kaaki ase bu ka, “M suse am wɔ lɛɛ, ka, m nú má ahin nzan bekun, má ka cɛɛn be bo m ni ambɛrɛ bá saŋga nu i fɔfɔrɛ, m Si Nyɛmɛ fɛmɛya n nu ni.” ");
INSERT INTO cko_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Nyini sin na ba di jue akansi Nyɛmɛ, na ba fite akɔ Oliva Buka n su. ");
INSERT INTO cko_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Dɔ na Yesu ase i susu­fɔm ni ka, “Nyuma dɛɛ kɔŋguɛ n nu, am kɛrɛ ŋmáti yaki m, dama ba kɛrɛ i Nyɛmɛ Jɔrɛ Kadasi n nu ka, Nyɛmɛ ŋa, ‘M bó kun bɔɛ­sasa­fɔ ni, na nbɔɛm bá sandi.’ ");
INSERT INTO cko_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ama, m bá teŋgeeri m yiwee n nu, m dú am mɔ kɔ Galili awɔrɛ n nu.” ");
INSERT INTO cko_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Na Petoro ase i ka, “Nzɛn ahinm kɛrɛ ŋmati yakiiri u, mini ŋmáti yaki má u da.” ");
INSERT INTO cko_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Na Yesu ase Petoro ka, “Nahɔrɛ ye m suse u n a, nyuma kɔŋguɛ n nu, kana akɔnyuma bá bo, a kéte kpe nsan ka a si má m.” ");
INSERT INTO cko_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Na Petoro akaaki ase i ka, “Mini sé má sɔ da. Nzɛn haari wɔ yo daka ka mini ni wɔrɔ kɛrɛ saŋga wú mmɔɔ, ŋka ya wú wɔ.” Na i susu­fɔm n kɛrɛ ase sɔ. ");
INSERT INTO cko_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Na Yesu ni i susu­fɔm n ayasu akɔ aju awɔrɛ be bo bu fere i ka Gɛsɛmane ni, na Yesu ase i susu­fɔm ni ka, “Am tana fɛn ŋminda m, na m kɔ́ dɔ kɔ sere Nyɛmɛ.” ");
INSERT INTO cko_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Na wɔ fa Petoro ni Zɛbɛdi nbaa nnyɔm ni, na ba kɔ mɔ kaan. Bu kɔ juuri dɔ, na ahoresaaki aba i dɔ agaya, na i jeke ati. ");
INSERT INTO cko_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Na wɔ se bu ka, “Ahoresaaki aba m dɔ agaya, i yo m ka m wu wɔ mmɔɔ. Am wo fɛn na am ŋminda m. Má am daafi.” ");
INSERT INTO cko_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Na wɔ kɔ dede kaan, na wɔ butu i kunnu su. Na wɔ sere Nyɛmɛ, i ŋa, “M Si Nyɛmɛ, nzɛn má a soro su, yi m fite ahin anyum­boro n bo i suba m dɔ n nu. Haari ni nyini mmɔɔ, má a yo kabo m koro ni, ama, yo kabo a koro ni.” ");
INSERT INTO cko_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","I sere Nyɛmɛ wieeri ni, na wɔ kpie i nyi akɔ aŋu ka i susu­fɔ nsanm ni wo daafiri su. Na wɔ bisa Petoro ka, “Nzu ti ye am minɛ nsan n kɛrɛ be mmɔɔ koro kpiɛ má daafiri haari kaan sɔ mmɔɔ a?” ");
INSERT INTO cko_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Na wɔ kaaki ase bu ka, “Am kpiɛ daafiri, na am sere Nyɛmɛ adena má deke be yo am na am wura satiɛ nu. Ahore­mbaa n koro nyɛmɛsu, ama, aŋuniɛ­mbaa n ayɔrɔki.” ");
INSERT INTO cko_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Na wɔ kaaki akɔ asere Nyɛmɛ bekun, i ŋa, “M Si Nyɛmɛ, nzɛn i ti u dɛɛ koroya­nu ka m fite má ahin anyum­boro n bo i suba m dɔ n nu, ma u dɛɛ koroo­wa n yo.” ");
INSERT INTO cko_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Na wɔ kpie i nyi aba i susu­fɔm n dɔ, na wɔ ba aŋu ka ba daafi bekun, dama daafiri ati bu agaya. ");
INSERT INTO cko_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Na Yesu ayaki bu bekun, na wɔ kɔ asere Nyɛmɛ kpe nsan su, ni nyini nɔaniɛ jɔjɔɔ­wa kun bo i du mɔ jɔjɔɔri i ni. ");
INSERT INTO cko_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Nyini sin, na wɔ kpie i nyi aba i susu­fɔm n dɔ, aba aŋu ka bu toko wo daafiri su, na wɔ se bu ka, “Am toko daafi yi am ŋumi wɔ? Am niɛ, saŋga n aju, wɔ tɔ mini Adamande Wa ni ama satiɛ­yo­fɔm. ");
INSERT INTO cko_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Am niɛ, sɔnɔ n bo wɔ tɔ m lɛɛ. Am yasu na ya kɔ.” ");
INSERT INTO cko_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Na saŋga bo Yesu toko wo jɔjɔɔri su ni, na Yudasi bo i ti Yesu susu­fɔ buru ni nnyɔm nu kun aju ni jama beberebe. Bu bita takobem ni kɔrɔmam. Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm, ni Yuda­fɔm nkpiɛn­kpiɛnm ni sunmaari bu a. ");
INSERT INTO cko_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Na Yudasi bo i tɔɔri Yesu ni akere jama n nyaari su kabo bu sí Yesu na bu tara i. I ŋa, “Sɔnɔ n bo m kɔ́ biti i ni, yiri lɛɛ. Am tara i.” ");
INSERT INTO cko_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Saŋga bo bu kɔ juuri deke bo Yesu wo ni, na Yudasi akaba akɔ i dɔ, na wɔ se i ka, “Ya Kere­fɔ.” Na wɔ biti i, na wɔ yo i ansɛ. ");
INSERT INTO cko_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Na Yesu ase i ka, “M dɔn, yo deke n bo a koro ka a yo i ni ndende.” Na minɛm n aba atara Yesu, na ba bita i kenken. ");
INSERT INTO cko_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Na Yesu susu­fɔm n nu kun acin awɔrɔ i takobe, na wɔ kpiɛ sɔnɔ be sui, nyini sɔnɔ n ti Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm kpiɛn n akɔɔ ɔ. ");
INSERT INTO cko_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Na Yesu ase i ka, “Fa u takobe n kaaki wura i buɛ nu. Dama minɛm kɛrɛ bo bu fa takobe yo juma ni, bɛrɛ gusu bá wu ni takobe wɔ. ");
INSERT INTO cko_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","A si má ka nzɛn má m sereeri m Si Nyɛmɛ, i súnma i mɛrɛkɛm asɛsɛ asɛsɛ buru ni nnyɔ, na bu bá buka m kisa kisa bɛrɛ? ");
INSERT INTO cko_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ama, nzɛn m nya yoori sɔ, kabo ba kɛrɛ i Nyɛmɛ Jɔrɛ Kadasi n nu ka wɔ yo daka ka i yó sɔ ni, i yó sɛ ye i bá yo yii­wa?” ");
INSERT INTO cko_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Na Yesu abisa jama n ka, “M ti fin­fɔ ɔ, ye am fa takobem ni kɔrɔmam na am ba tara m a? Cɛɛn kɛrɛ cɛɛn m ni ambɛrɛ wo Nyɛmɛ Seree­biri Awuru n nu a, ye m kere minɛm a, ama, am atara má m. ");
INSERT INTO cko_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ama, ahin kɛrɛ yó sɔ, adena kabo Nyɛmɛ nɔaniɛ kan­fɔm akɛrɛ i Nyɛmɛ Jɔrɛ Kadasi n nu n yo yii­wa a.” Dɔ na i susu­fɔm n kɛrɛ aŋmati ayaki i. ");
INSERT INTO cko_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Na bo bu taraari Yesu n afa i akɔ Kayafasi dɔ, yiri ti Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm kpiɛn n a. I dika n nu ye Nyɛmɛ nɔaniɛ kere­fɔm ni, ni Yuda­fɔm nkpiɛn­kpiɛnm n tiɛɛnri bu nɔɔ a. ");
INSERT INTO cko_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Na Petoro asu Yesu su, i woori dede kaan ni yiri, haari i kɔ wuraari Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm kpiɛn n dika gisan nu. I wuraari gisan n nu ni, na wɔ kɔ asaŋga atana tintini­jina­fɔm nu, adena i ŋu sa n bo i yo n awieeri. ");
INSERT INTO cko_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Na Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ nkpiɛn­kpiɛnm ni, ni Yuda­fɔm tere­tere­fɔm n kɛrɛ aniɛniɛ minɛm bo bu bá di kɔrɛ daani fa kɔ ŋgasi bo Yesu ado i ni, adena bu nya i taraa­biri na bu kun i. ");
INSERT INTO cko_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Haari ni bo minɛ beberebe fite jina diiri kɔrɛ daani n kɛrɛ, ba nya má jɔrɛ bo bu fa kpiɛ sɔ i. Kasin na minɛ nnyɔ nbem ayasu ajina, ");
INSERT INTO cko_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","na ba se ka, “Ahin sɔnɔ n ŋa yiri koro fufu Nyɛmɛ Seree­biri Awuru ni, na i káaki ta i le­san afiɛn.” ");
INSERT INTO cko_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Na Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm kpiɛn n ayasu ajina, na wɔ bisa Yesu ka, “A la má bɔnu be fa kɔ ahin jɔrɛ n bo minɛm ni akpiɛ asɔ u n su?” ");
INSERT INTO cko_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ama, na Yesu amɔ i nɔɔ. Na Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm kpiɛn n ajɔjɔ i dɔ bekun, i ŋa, “Kisa, m koro ka a tan Nyɛmɛ bo i wo bɛrɛ saŋga kɛrɛ ni. Nzɛn wɔrɔ ti Nyɛmɛ Wa n bo i ti Kristo Tii­de­fɔ ni, se ya.” ");
INSERT INTO cko_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Na Yesu abɔ i nu ka, “Kabo a jɔjɔɔri ni, i ti sɔ ɔ. Ama, m suse am kɛrɛ wɔ lɛɛ ka, ‘Fite nyuma fa kɔ, am bá ŋu mini Adamande Wa ni ka m tana Nyɛmɛ Yiko­fɔ n saa fɔmbɔrɔ su, na am ŋú ka m fite aŋgoro yinyiŋgu n nu suba.’” ");
INSERT INTO cko_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Yesu bɔ nu sɔ wieeri ni, na Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm kpiɛn n asɔn i tanlɛɛ. Na wɔ se ka, “Wɔ jɔjɔ awura Nyɛmɛ ŋgasi nu. Ya koro má daani­fɔ bekun. Ambɛrɛ mmɔɔ ti kabo wɔ jɔjɔ awura Nyɛmɛ ŋgasi n nu e. ");
INSERT INTO cko_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ye am ŋa sɛ wɔ?” Na bu kɛrɛ ase ka, “Wɔ kan ciire jɔrɛ lɛɛ, wɔ yo daka ka i wu.” ");
INSERT INTO cko_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Na ba yi nanzue agɔ Yesu nyunuawa nu, na ba bo i, na ba bo i nyɔɔnu, ");
INSERT INTO cko_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","na ba se i ka, “Wɔrɔ Kristo Tii­de­fɔ ni, ŋma bo u a? Kan kere ya.” ");
INSERT INTO cko_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Bu wo nyini kɛrɛ su ni, na Petoro toko tana gisan n nu, na afani be aba i bi, na wɔ se Petoro ka, “Wɔrɔ mmɔɔ yo woori nyini Yesu Galili­fɔ n dɔ ɔ.” ");
INSERT INTO cko_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ama, na Petoro akete bu kɛrɛ nyunu ase ka, “Ai, m si má nyini jɔrɛ n bo a sujɔjɔ i ni mmɔɔ.” ");
INSERT INTO cko_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Na Petoro afite akɔ gisan n anɔ n nu, na afani nyiŋga be aba aŋu i, na wɔ se minɛm bo bu jina bɛrɛ n ka, “Ahin sɔnɔ ni mmɔɔ yo woori Yesu Nazarɛti­fɔ n dɔ ɔ.” ");
INSERT INTO cko_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Na Petoro akete bekun, na wɔ tan ndiɛ, i ŋa, “Mini si má nyini sɔnɔ ni mmɔɔ.” ");
INSERT INTO cko_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Wɔ cɛ má na minɛm n bo bu jina bɛrɛ n gusu ase Petoro ka, “Nahɔrɛ, a ti bu kun wɔ, dama u jɔjɔɔ­wa ni kere sɔ a.” ");
INSERT INTO cko_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Na Petoro atan ndiɛ afa i saa awura sin nu, i ŋa, “M si má nyini sɔnɔ ni.” Kpeŋga na akɔnyuma abo. ");
INSERT INTO cko_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Na Petoro ateŋge su kabo Yesu seeri i ni, i ŋa “Kana akɔnyuma bá bo, a kéte kpe nsan su ka a si má m.” Na wɔ fite akɔ asun agaya. ");
INSERT INTO cko_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Na alecin saŋga na Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ nkpiɛn­kpiɛnm, ni Yuda­fɔm nkpiɛn­kpiɛnm n atana asɛsɛ su kabo bu yo barasu na bu kun i. ");
INSERT INTO cko_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Na ba wura i jɔrɔkɔ, na ba fa i akɔ ama Pilato bo i ti Roma­fɔm gomina ni. ");
INSERT INTO cko_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Saŋga bo Yudasi bo i tɔɔri Yesu n tiiri ka ba ma nɔɔ ka bu kun Yesu ni, na wɔ yo m si n sɔ, na wɔ kaaki awɔrɔ jɛtɛ ŋwaa abura­san n aba ama Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ nkpiɛn­kpiɛnm, ni Yuda­fɔm nkpiɛn­kpiɛnm ni. ");
INSERT INTO cko_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Na wɔ se bu ka, “Ma yo satiɛ kabo ma tɔ sɔnɔ bo i la má ŋgasi be na bu kun i ni.” Na ba se i ka, “Ya cɛcɛ bɔnɔ wo nyini nu a? U dɛɛ jɔrɛ lɛɛ.” ");
INSERT INTO cko_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Na Yudasi afa ŋwaa n atu Nyɛmɛ Seree­biri Awuru n nu, na wɔ fite akɔ awura i kɔm nyama akun i ŋu. ");
INSERT INTO cko_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Na Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ nkpiɛn­kpiɛnm n afa ŋwaa ni, na ba se ka, “Ahin ŋwaa n ti mbunja yii­wa ŋwaa a. Nyɛmɛ nɔaniɛ kpamaa­wa n kere ka má be fa i ŋusu fa saŋga Nyɛmɛ Seree­biri Awuru dɛɛ ŋwaa n nu.” ");
INSERT INTO cko_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Na ba yo anɔɔsɛ, afa ŋwaa n ato asiɛn be, bo bu fere i ka yakati ta­fɔ juma yoo­biri ni, ka bu fa yo wɔfɔm see­biri. ");
INSERT INTO cko_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Nyini ti ye bu fere nyini asiɛn n ka Mbunja Asiɛn, haari ni nyuma sɔ n a. ");
INSERT INTO cko_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Dɔ na nɔaniɛ n bo Nyɛmɛ nɔaniɛ kan­fɔ Jeremiya yo jɔjɔɔri n ayo yii­wa, i ŋa, “Ba fa jɛtɛ ŋwaa abura­san n bo Yisareli­fɔm kɛrɛ soroori su ka bu tɔ i kaari, sɔnɔ n dɛɛ ti ni, ");
INSERT INTO cko_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","na ba fa ŋwaa n ato yakati ta­fɔ juma yoo­biri, kabo Micɛra n seeri m ka bu yó lɛɛ.” ");
INSERT INTO cko_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Na ba fa Yesu akɔ ajina Gomina Pilato n nyunu, na wɔ bisa Yesu ka, “Wɔrɔ ti Yuda­fɔm fɛmɛ n a?” Na wɔ bɔ i nu ka, “Kabo a jɔjɔ ni, i ti sɔ ɔ.” ");
INSERT INTO cko_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Na Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ nkpiɛn­kpiɛnm, ni Yuda­fɔm nkpiɛn­kpiɛnm akpiɛ jɔrɛ asɔ Yesu, ama, wɔ bɔ má be nu. ");
INSERT INTO cko_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Na Gomina Pilato abisa i ka, “A ti má jɔrɛ n kɛrɛ bo ba kpiɛ asɔ u ni?” ");
INSERT INTO cko_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ama, Yesu abɔ má jɔrɛ n haari kun be mmɔɔ nu, na gomina n abirisi agaya kabo wɔ bɔ má nu ni. ");
INSERT INTO cko_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Afɔ kɛrɛ afɔ, Butara cɛɛn­kpiri n nya ba ju, Roma­fɔm gomina yi dan­saraka n bo jama n koro ka i yi i ji n wɔ. ");
INSERT INTO cko_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Nyini saŋga ni, sɔnɔ be woori dan­saraka n nu dɔ, bu fere i ka Barabasi, i ti má jɔrɛ bu, sɔnɔ kɛrɛ si i sa. ");
INSERT INTO cko_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Na saŋga bo jama n kɛrɛ ba tiɛɛnri bu nɔɔ ni, na Gomina Pilato abisa bu ka, “Am koro ka m yi ŋma ma am a, Barabasi ni, nzɛn Yesu n bo bu fere i ka Kristo Tii­de­fɔ ni?” ");
INSERT INTO cko_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","I seeri sɔ ni, dama i siiri tenle su ka bu si Yesu kɔrɛ ti ye bu faari i ba wuraari i saa nu a. ");
INSERT INTO cko_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Saŋga bo Gomina Pilato wo Yesu jɔrɛ­di su ni, na i yi asunma ase ka, “Má a se ka a yo nyini nahɔrɛ­fɔ n sa be, dama anuma kɔŋguɛ, ma cin alɛlɛ fa kɔ nyini sɔnɔ n dɔ bo wɔ miɛ m agaya.” ");
INSERT INTO cko_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ama, na Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ nkpiɛn­kpiɛnm, ni Yuda­fɔm nkpiɛn­kpiɛnm n awura jama n bu sin ka bu sere Gomina Pilato ka i yí Barabasi ma bu, na i kún Yesu. ");
INSERT INTO cko_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ama, na Gomina Pilato akaaki abisa jama n ka, “Nyini minɛ nnyɔm ni nu, am koro ka m yi ŋma ma am a?” Na ba bɔ i nu ka, “Barabasi.” ");
INSERT INTO cko_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Na Gomina Pilato abisa bekun ka, “Ye ahin Yesu n bo bu fere i ka Kristo Tii­de­fɔ ni, am koro ka m yó i sɛ wɔ?” Na bu kɛrɛ abɔ i nu ka, “Kpama i baka jaanu n su na i wu.” ");
INSERT INTO cko_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Na Pilato abisa ka, “Ye nzu satiɛ ye wɔ yo i a?” Ama, na ba kaaki atiɛn kpa agaya bekun ase ka, “Kpama i baka jaanu n su na i wu.” ");
INSERT INTO cko_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Saŋga bo Gomina Pilato ŋuuri ka i koro yo má jɔrɛ n dɔŋgu, haari ni bo wɔ boro i nyi na i yo i dɔŋgu ni, jama n akete sukoro ka bu yo naŋmiɛ. Nyini ti, na wɔ fa nzue aŋmisi i saa, jama n kɛrɛ nyunu, na wɔ se bu ka, “M saa wo má ahin sɔnɔ n yiwee nu. Am dɛɛ jɔrɛ lɛɛ.” ");
INSERT INTO cko_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Na jama n kɛrɛ ase i ka, “Tɔ, ma i yiwee ni ŋgasi su ya su, ni ya anumam kɛrɛ.” ");
INSERT INTO cko_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Dɔ na Gomina Pilato ayi Barabasi aji, na wɔ ma sojam n afin Yesu ŋgbere, na wɔ nya afa i awura bu saa nu ka bu kɔ kpama i baka jaanu n su na i wu. ");
INSERT INTO cko_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Na Gomina Pilato n dɛɛ sojam n afa Yesu awura i gisan n nu, na ba tiɛn bu beŋgu sojam kɛrɛ nɔɔ abara ayɛ i. ");
INSERT INTO cko_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Na ba yi Yesu sutura bo i wura i ni, na ba fa tanlɛɛ kɔkɔrɛ yorom be ka fɛmɛya tanlɛɛ dɛɛ su awura i. ");
INSERT INTO cko_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Na ba fa buwe aŋɔ i ka kaba dɛɛ su, na ba fa aforo i tii ka fɛmɛya kere dɛɛ su. Na ba fa kpama awura i saa nu, na ba kutu i nyunu suyo i anzasi, bu ŋa, “Yuda­fɔm Fɛmɛ ni, ya yo u ansɛ.” ");
INSERT INTO cko_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Na ba yi nanzue agɔ i ŋu, na ba de kpama ni i dɔ, na bu sufin i tii baka. ");
INSERT INTO cko_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Bu ba yoori i anzasi n wieeri ni, na ba yi tanlɛɛ kɔkɔrɛ yorom ni, na ba kaaki afa i tiɛŋgu dɛɛ sutura n awura i. Na ba nya afa i akɔ ka bu kɔ kpama i baka jaanu n su. ");
INSERT INTO cko_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Saŋga bo bu sukɔ ni, na bu ni Sirenefɔ biɛ be ayɛ, bu fere i ka Simon. Na sojam n amiɛ i ka i sɔ Yesu baka jaanu ni. ");
INSERT INTO cko_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Na ba kɔ aju awɔrɛ be bo bu fere i ka Gologota ni, Gologota n bu la ka Tere­awa Woo­biri. ");
INSERT INTO cko_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Na ba saŋga nzan ni ayiri wiwi barasu be ama Yesu ka i nu na i jɔ yaari ni, ama, i kaanri i nɔɔ ɔ, na wɔ kete, wɔ nu má i. ");
INSERT INTO cko_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Na ba nya akpama i baka jaanu n su, na ba yɛ i su ajina. Bu yoori sɔ wieeri ni, na ba tu mbaa na bu si kabo bu kpaaki i suturam nu, bu ŋuŋu nu. ");
INSERT INTO cko_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Nyini sin na ba ka atana suniɛ Yesu. ");
INSERT INTO cko_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Na ba kɛrɛ jɔrɛ n bo bu kpiɛ sɔɔri i ni, afa abo akpama i baka jaanu n tii su, kɛrɛɛ­wa n la ka, “Yesu bo i ti Yuda­fɔm Fɛmɛ n lɛɛ.” ");
INSERT INTO cko_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Na ba kpama fin­fɔ nnyɔ nbem baka jaanu su adodo i, bu kpamaari kun i saa fɔmbɔrɔ su, na ba kpama kun n gusu i saa biɛ su. ");
INSERT INTO cko_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Na minɛm kɛrɛ bo bu sin dɔ ni, subobo bu tii, na ba kpiɛ i nzukɔ, bu ŋa, ");
INSERT INTO cko_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Wɔrɔ bo a ŋa a fúfu Nyɛmɛ Seree­biri Awuru n na a káaki ta i le­san afiɛn n lɛɛ, de u tii ji. Nzɛn a ti Nyɛmɛ Wa nahɔrɛ su, jura baka jaanu n su.” ");
INSERT INTO cko_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Sɔ ye Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ nkpiɛn­kpiɛnm, ni Nyɛmɛ nɔaniɛ kere­fɔm, ni Yuda­fɔm nkpiɛn­kpiɛnm n gusu yoori i anzasi a, ");
INSERT INTO cko_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","bu ŋa, “Wɔ de minɛm tii aji, ama, i sukoro de má yiri ni i tii. M ŋa i ti Yisareli­fɔm Fɛmɛ n wɔ e. Tɔ, ma i jura baka jaanu n su bra kisa kisa na ya niɛ, na ya yó i yarada. ");
INSERT INTO cko_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","I daafi Nyɛmɛ ŋu a, ye i ŋa i ti Nyɛmɛ Wa a. Tɔ, nzɛn Nyɛmɛ koro i a, ma i de i tii ji kisa na ya niɛ.” ");
INSERT INTO cko_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Haari na fin­fɔ nnyɔm n bo bu kpamaari bu dodoori Yesu ni mmɔɔ akpiɛ i nzukɔ sɔ. ");
INSERT INTO cko_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Wiɛsu kerefi buru ni nnyɔ saŋga na awosin akata asiɛn n kɛrɛ su, haari naasɔ kerefi nsan. ");
INSERT INTO cko_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Na fa kɔ nyini saŋga ni, na Yesu abo awie kpa ase ka, “Eli, Eli, lama sabatani?” I bu la ka, “M Nyɛmɛ, m Nyɛmɛ, nzu ti ye a yaki m aji a?” ");
INSERT INTO cko_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Na minɛ nbem jinaari bɛrɛ, bu nbem n tiiri sɔ ni, na ba se ka, “Am ti, ahin sɔnɔ n sufere Eliya.” ");
INSERT INTO cko_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Kpeŋga na bu nu kun aŋmati afa mɛnɛ, adɔ nzan gagaraki be nu, na wɔ fa awɔ baka su alaandi atɔ Yesu nɔɔ ka i nu. ");
INSERT INTO cko_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ama, na nyiŋgam n ase ka, “Am yaki na ya niɛ, ka Eliya bá de i tii ji?” ");
INSERT INTO cko_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Na Yesu abo awie kpa, na wɔ nya ayo Nyɛmɛ dɛɛ. ");
INSERT INTO cko_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Dɔ na tani bambaka n bo bu fa kanda kpaakiiri Sɔɔ Casi n bo i wo Nyɛmɛ Seree­biri Awuru n nu n ati nu nnyɔ, fa i aŋgoro kɔ jura i asiɛŋgu. Na asiɛn n akpisi, na yabuɛ ŋgbiŋgbirim akpakpaaki nu. ");
INSERT INTO cko_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Na faŋ­kunmam ateke, na Nyɛmɛ minɛm dɔŋgu bo ba wu n ateŋge bu yiwee nu. ");
INSERT INTO cko_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Na ba fite faŋ­kunmam n nu, na saŋga bo Yesu ba teŋgeeri i yiwee n nu ni, na ba kɔ awura Yɛrusalem miɛ kpiri n nu, na minɛ dɔŋgu aŋu bu. ");
INSERT INTO cko_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Na soja kpiɛn n ni i sojam n bo bu jina niɛɛri Yesu ni, na bu ŋuuri kabo asiɛn n kpisiiri barasu, ni kabo sa n kɛrɛ yoori ni, na sɛrɛ ati bu agaya, na ba se ka, “Ahin sɔnɔ n ti Nyɛmɛ Wa a nahɔrɛ su.” ");
INSERT INTO cko_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Na nbaram beberebe bo bu su i su fite Galili awɔrɛ n nu na bu buka i ni, ajina dede suniɛ Yesu. ");
INSERT INTO cko_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Bu nu nbem la Mariya bo i fite Magadala miɛ n nu ni, ni Mariya n bo i nbaam la Yakobo ni Yosefu ni, ni Zɛbɛdi yi. ");
INSERT INTO cko_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Na naasɔ saŋga na neŋge­fɔ be aba, i fite Aramatiya miɛ kpiri n nu wɔ, bu fere i ka Yosefu. Yiri mmɔɔ ti Yesu susu­fɔm kun wɔ. ");
INSERT INTO cko_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Na wɔ kɔ asere Gomina Pilato ka i fa Yesu ŋuniɛ n ma i. Na Gomina Pilato ama nɔɔ ka bu kɔ fa ma i. ");
INSERT INTO cko_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Na Yosefu akɔ ayi Yesu fuin n apɔɔndi nzee fɔfɔrɛ nu, ");
INSERT INTO cko_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","na wɔ kɔ ase i faŋ­kunma nu, yiri Yosefu dɛɛ tiɛŋgu yabuɛ buɛ faŋ­kunma n bo ba lokoti i fɔfɔrɛ ni. Na wɔ nya akundu yabuɛ bambaka afa atɔ faŋ­kunma n anɔ ni, na wɔ kɔ. ");
INSERT INTO cko_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Na Mariya Magadala­fɔ ni, ni Mariya nyiŋga n atana afa bu nyunu awɔ faŋ­kunma ni. ");
INSERT INTO cko_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Na alecin fɔfɔrɛ bo i ti Yuda­fɔm Ŋumi­yi cɛɛn ni, na Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ nkpiɛn­kpiɛnm, ni Farasi­fɔm n akɔ Gomina Pilato dɔ. ");
INSERT INTO cko_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Na ba kɔ ase i ka, “Ya si, ya teŋge su ka saŋga bo nyini kɔrɛ­fɔ n yo la ŋgɔɔ ni, na wɔ se ka yiri wuuri, i le­san cɛɛn, i téŋge i yiwee n nu. ");
INSERT INTO cko_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Nyini ti, ma nɔɔ na bu kɔ jina ŋminda i faŋ­kunma ni, fa kɔ ju haari le­san cɛɛn ni, má nyini, i susu­fɔm ni koro kɔ wɔ yi i ŋuniɛ ni, na bu bu kɔrɛ ka wɔ teŋge wɔ. Nyini saŋga, kasin dɛɛ kɔrɛ ni tára bumboori dɛɛ ni.” ");
INSERT INTO cko_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Na Gomina Pilato ase bu ka, “Am fa tintini­jina­fɔm, na am ma bu kɔ jina ŋminda i faŋ­kunma n kabo am koro i barasu ni, na má be koro yo pui.” ");
INSERT INTO cko_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Nyini ti, na ba kɔ ata atɔ faŋ­kunma n anɔ n kɛrɛ, na ba ma tintini­jina­fɔm n ajina aŋminda abara ayɛ i, adena má be koro yo pui. ");
INSERT INTO cko_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Yuda­fɔm Ŋumi­yi cɛɛn n sin dɛɛ alecin, bakuɛ n bumboori, mɔnɛ cɛɛn ŋgarama fuun, na Mariya Magadala­fɔ ni, ni Mariya nyiŋga ni, akɔ ka bu kɔ niɛ Yesu faŋ­kunma ni. ");
INSERT INTO cko_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Kpeŋga na asiɛn n akpisi agaya, dama Micɛra n mɛrɛkɛ be fiteeri aŋgoro jura ba kundu yiiri yabuɛ bambaka n faŋ­kunma n anɔ n su a, na wɔ fun atana su. ");
INSERT INTO cko_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Na wɔ ta fofoe papasi ka nzue kpɛsɛɛ­wa dɛɛ su, na i sutura n kɛrɛ ayo fofoe ka cisɛn. ");
INSERT INTO cko_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Na sɛrɛ ati tintini­jina­fɔm ni, na bu ŋuniɛ subobo bu, na ba yo ka ba wu dɛɛ su wɔ. ");
INSERT INTO cko_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Na Nyɛmɛ mɛrɛkɛ n ase nbaram n ka, “Má am ma sɛrɛ ti am. M si ka am niɛniɛ Yesu bo bu kpamaari i baka jaanu n su n wɔ. ");
INSERT INTO cko_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","I wo má fɛn. Wɔ teŋge i yiwee n nu, kabo i yo seeri am ni. Am ba niɛ deke bo bu faari i seeri ni. ");
INSERT INTO cko_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Am kpie am nyi na am kɔ se i susu­fɔm ni ka wɔ teŋge i yiwee n nu. Am ti fɛn, i sudu am mɔ kɔ Galili awɔrɛ n nu, dɔ ye am kɔ́ ŋu i a. Ma se am lɛɛ.” ");
INSERT INTO cko_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Na ba fite faŋ­kunma n nu ndende ni sɛrɛ, ama, ni ahorejɔ, na ba ŋmati na bu kɔ se i susu­fɔm ni. ");
INSERT INTO cko_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Bu sukɔ ni, kpeŋga na bu ni Yesu ayɛ, na wɔ yo bu ansɛ. Na ba kutu i jaa bu, na ba ma i jirima. ");
INSERT INTO cko_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Na wɔ se bu ka, “Má am ma sɛrɛ ti am. Am kɔ se m ninbaam ka bu kɔ Galili, dɔ ye bu kɔ́ ŋu m a.” ");
INSERT INTO cko_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Saŋga bo nbaram n wo kɔ su ni, na tintini­jina­fɔm nbem akɔ miɛ n kunnu, akɔ ama Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ nkpiɛn­kpiɛnm ni labari, fa kɔ sa n kɛrɛ bo wɔ yo n su. ");
INSERT INTO cko_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Na Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ nkpiɛn­kpiɛnm, ni Yuda­fɔ nkpiɛn­kpiɛnm n atiɛn bu nɔɔ, afa asɛsɛ su, na ba ma tintini­jina­fɔm ni ŋwaa beberebe, ");
INSERT INTO cko_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","na ba se bu ka, “Am se minɛm ka, saŋga bo am adaafi kɔŋguɛ n ye i susu­fɔm ni ba wɔ yiiri i a. ");
INSERT INTO cko_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Na nzɛn haari gomina n ba tiiri nyini labari ni, yɛrɛ kán de am tii, na i yó má am pui.” ");
INSERT INTO cko_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Na tintini­jina­fɔm n ade ŋwaa n na ba kɔ ase minɛm kabo nkpiɛn­kpiɛnm n seeri bu ni. Nyini dɛɛ ti ye nyini labari n abara ayɛ Yuda­fɔm dɔ, fa ba ju haari ni nyuma n a. ");
INSERT INTO cko_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Na i susu­fɔ buru ni kunm n akɔ Galili awɔrɛ n nu na ba fun akɔ buka n su, deke bo Yesu seeri bu ka bu kɔ ni. ");
INSERT INTO cko_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Saŋga bo bu kɔ ŋuuri i ni, na ba kutu ama i jirima, ama, bu nbem asunsun ka má yiri lɛɛ. ");
INSERT INTO cko_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Na Yesu acin adodo bu, na wɔ se bu ka, “Nyɛmɛ afa aŋgoro ni asiɛŋgu fɛn kɛrɛ yiko, afa awura m saa nu. ");
INSERT INTO cko_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Nyini ti, am kɔ durunya n kɛrɛ nu, na am ma daanfiɛ kɛrɛ yo m susu­fɔm. Na am biɛ bu Nyɛmɛ nzue, Si, ni Baa, ni Awiɛwiɛ Casi n dɛɛ duma nu. ");
INSERT INTO cko_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Na am kere bu ka bu de m nɔaniɛ maa­wa n kɛrɛ bo ma fa ama am ni. Am ti fɛn, m wo am dɔ, saŋga kɛrɛ, fa kɔ haari durunya n awieeri.”");
INSERT INTO cko_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ahin jɔrɛ ni, i ti Nyɛmɛ Wa Yesu Kristo dɛɛ labari kpa n wɔ. Kabo i boori i bu yaa. ");
INSERT INTO cko_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","3","Nyɛmɛ yo seeri i wa n ka, “Ti fɛn, m súnma m sunma­fɔ n na i dú u mɔ, yiri sɛ́sɛ u atin n su a. Yiri kɔ́ subo ndoori boro kpantain n nu se ka, ‘Am sɛsɛ Mibiɛ n atin n su, na am yo i atin n dɔŋgu.’” Na Nyɛmɛ ama ba kɛrɛ nyini jɔjɔɔ­wa n kɛrɛ Nyɛmɛ nɔaniɛ kan­fɔ Esaya dɛɛ kadasi n nu. ");
INSERT INTO cko_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Nyini sɔnɔ n bo Nyɛmɛ sunmaari i n la sɔnɔ be bo bu fere i ka Yohane Nyɛmɛ Nzue Biɛ­fɔ ni. I baari boro kpantain n nu, na i sukan Nyɛmɛ jɔrɛ, i ŋa, “Am kaaki am wo na m biɛ am Nyɛmɛ nzue, na Nyɛmɛ fa am ŋgasi ni am satiɛ kɛrɛ ce am.” ");
INSERT INTO cko_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Na Yudiya asiɛn­su­fɔm, ni Yɛrusalem miɛ nu­fɔm kɛrɛ afite aba i dɔ, na ba kan bu ŋgasi ni bu satiɛ kɛrɛ bo ba yo i akere Nyɛmɛ, na Yohane abiɛ bu Nyɛmɛ nzue Yodan kunma n nu. ");
INSERT INTO cko_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohane sutura wuraa­wa yo ti deke bo bu faari nyɔɔma ndɔrɛ wuuri i a, na wɔ fa jina abo i wi nu. I diire yo la lalom ni wiɛ wɔ. ");
INSERT INTO cko_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","I kaanri Nyɛmɛ jɔrɛ, i ŋa, “Sɔnɔ be wo m sin suba, i tara m fieo, m ti kaan ni bo m dodo i. ");
INSERT INTO cko_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Mini afa nzue abiɛ am a, na am yo casi, ama, yiri fá Nyɛmɛ Awiɛwiɛ Casi n wura am ŋu yo am casi a, kabo sɔnɔ biɛ nzue na i yo casi ni.” ");
INSERT INTO cko_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Nyini saŋga n na Yesu afite Nazarɛti, miɛ n bo i wo Galili awɔrɛ n nu ni, na wɔ ba Yohane dɔ, na Yohane abiɛ i Nyɛmɛ nzue Yodan kunma n nu. ");
INSERT INTO cko_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Saŋga bo Yesu fiteeri nzue n nu ni, kpeŋga na wɔ ŋu ka aŋgoro n ateke, na Awiɛwiɛ Casi n ajura ka tiiwa dɛɛ su aba atana i ŋu. ");
INSERT INTO cko_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Na wɔ ti akonvi be ŋga aŋgoro, i ŋa, “Wɔrɔ ti m wa a, m koro u agaya, m ahore ajɔ u ŋu.” ");
INSERT INTO cko_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Nyini jinaa­biri n nu na Awiɛwiɛ Casi n ama Yesu akɔ boro kpantain n nu. ");
INSERT INTO cko_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","I woori dɔ cɛɛn abura­na, i ni boro neŋgem woori dɔ a, na Sitana ayo i na i niɛ ka, i yó yiri Sitana n dɛɛ koroo­wa, nzɛn i yó má. Ama, Yesu asoro má su. Na Nyɛmɛ mɛrɛkɛm aba asu i. ");
INSERT INTO cko_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Saŋga bo bu taraari Yohane nyiiri i dan­saraka n sin, na Yesu akɔ Galili awɔrɛ n nu, na i sukan labari kpa n fa kɔ Nyɛmɛ atin n su kere minɛm, ");
INSERT INTO cko_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","i ŋa, “Saŋga n aju bo Nyɛmɛ Fɛmɛ bá niɛ i minɛm su. Am kaaki am wo, na am de Nyɛmɛ labari kpa n na am yo i yarada.” ");
INSERT INTO cko_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ye i ba sunati sin Galili kunma kpiri n nɔɔ su, na wɔ ŋu jombaa tara­fɔ nnyɔ nbem. Bɛrɛ la Simon ni i niɛma Andere. Bu wo bu diɛndiɛ sandi su kunma kpiri n nu. ");
INSERT INTO cko_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Na Yesu ase bu ka, “Am bra na am ba su m su, na m má am tiɛn minɛm nɔɔ ma m, kabo am tara jombaa ni.” ");
INSERT INTO cko_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","I seeri sɔ ni, na ba kaba ayaki bu diɛndiɛm ni, na ba su i su. ");
INSERT INTO cko_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","I nati kɔɔri mɔ kaan bekun, na wɔ ŋu minɛ nnyɔ nbem. Bɛrɛ la Yakobo ni i niɛma Yohane. Bu fere bu si ka Zɛbɛdi. Bu wo lee nu suyo bu diɛndiɛm dɔŋgu. ");
INSERT INTO cko_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Dɔ na wɔ fere bu ka bu su i su, na ba yaki bu si ni, ni i npaadi­fɔm n lee n nu, na ba su i su. ");
INSERT INTO cko_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Na ba kɔ aju miɛ kpiri n bo bu fere i ka Kapɛnam su. Na Yuda­fɔm Ŋumi­yi cɛɛn na Yesu awura bu tiɛntiɛn­bunɔɔ sɔɔ n nu, bo bu sere Nyɛmɛ na bu kere Nyɛmɛ jɔrɛ nu ni, na wɔ kan Nyɛmɛ nɔaniɛ akere minɛm ni. ");
INSERT INTO cko_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Na bu kɛrɛ ayo alekutura fa kɔ i keree­wa n su, dama i keree­wa n awo i ŋgumi ni Yuda­fɔm dɛɛ Nyɛmɛ nɔaniɛ kere­fɔm ni. I keree­wa n la yiko. ");
INSERT INTO cko_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Nyini saŋga n nu na sɔnɔ bo ajini wo i ŋu n aba bu dɔ bu tiɛntiɛn­bunɔɔ sɔɔ n nu, na wɔ bo awie ");
INSERT INTO cko_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ase ka, “Yesu Nazarɛti­fɔ, a koro nzu ya nu fɛn a? A ba ka a ba yo ya ŋgbɛɛn wɔ? M si u sa, wɔrɔ ti sɔnɔ casi n bo Nyɛmɛ asunma u n a.” ");
INSERT INTO cko_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Na Yesu atiɛn ajini n ŋu ase ka, “Mɔ u nɔɔ bɛrɛ, na a fite yaki sɔnɔ ni.” ");
INSERT INTO cko_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Na ajini n akpisi sɔnɔ ni, na wɔ ciindi afite ayaki i. ");
INSERT INTO cko_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Na minɛm kɛrɛ ayo alekutura akɔ asin su, na ba bisa bu ŋuŋu nu ka, “Ee. Nzu la ahin? I ti keree­wa fɔfɔrɛ wɔ. Ahin sɔnɔ n la yiko bo i koro ma ajinim n mmɔɔ nɔɔ na bu de i.” ");
INSERT INTO cko_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Nyini ti na Yesu duma akaba ata abara ayɛ Galili awɔrɛ n kɛrɛ nu. ");
INSERT INTO cko_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Saŋga bo i fiteeri tiɛntiɛn­bunɔɔ sɔɔ n nu ni, na i ni Yakobo ni Yohane akɔ awura Simon ni Andere dika. ");
INSERT INTO cko_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Bu kɔ juuri awuru n nu ni, na ba se Yesu ka Simon sibara la má i ŋu, yakɔkɔ abo i, i da sɔrɔ. ");
INSERT INTO cko_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Na wɔ kɔ aso i saa nu ayɛ i su atana, na yakɔkɔ n ayaki i, na wɔ kɔ ayo diire ama bu. ");
INSERT INTO cko_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Nyini cɛɛn n naasɔ, dika bibiri saŋga, na minɛm afa tukpaki­fɔm kɛrɛ ni minɛm bo ajinim wo bu ŋu n aba Yesu dɔ. ");
INSERT INTO cko_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Na miɛ n nu jama n kɛrɛ aba atiɛn bu nɔɔ i dɔ anuŋgbere n nu. ");
INSERT INTO cko_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Na wɔ tuntun tukpaki barasu barasu­fɔm beberebe, na ba nya laifiɛ, na wɔ fɔn ayi ajinim gusu beberebe. Wɔ du má su na ajinim n jɔjɔ, dama bu si i sa. ");
INSERT INTO cko_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Na alecin akɔnyuma ciciri su, na Yesu ayasu afite akɔ dede awɔrɛ be nu i ŋgumi, na wɔ kɔ asere Nyɛmɛ. ");
INSERT INTO cko_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Na Simon ni i beŋgum akɔ i niɛniɛ. ");
INSERT INTO cko_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Bu kɔ ŋuuri i ni, na ba se i ka, “Sɔnɔ kɛrɛ suniɛniɛ u busu.” ");
INSERT INTO cko_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Na Yesu ase bu ka, “Am ma ya kɔ miɛ nyiŋgam n su na m kɔ kan Nyɛmɛ jɔrɛ kere bu gusu, dama ka nyini ti ye m baari durunya n nu a.” ");
INSERT INTO cko_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Na wɔ bara ayɛ Galili awɔrɛ n kɛrɛ nu, sukan Nyɛmɛ jɔrɛ bu tiɛntiɛn­bunɔɔ sɔɔm n nu, ye i fɔn yi ajinim minɛm ŋu a. ");
INSERT INTO cko_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Na koko­fɔ be aba Yesu dɔ, na wɔ ba akutu i nyunu asere i jande ka i buka i. I ŋa, “Nzɛn a koro ka a ma m nya laifiɛ, a koro ma m nya i.” ");
INSERT INTO cko_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Na Yesu aŋu i aŋunfɔ, na wɔ teŋge i saa anana i ŋu, na wɔ se i ka, “M koro. Nya laifiɛ.” ");
INSERT INTO cko_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Na kokobi n akaba ayaki sɔnɔ n na wɔ nya laifiɛ. ");
INSERT INTO cko_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Na Yesu ama i atin ka i kɔ, na wɔ bɔbɔ i ");
INSERT INTO cko_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","ase i ka, “Má a se ka a se be ahin jɔrɛ ni, ama, kɔ na a kɔ fa u ŋu kere Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ ni, na a kɔ yo yoo­wa n bo Moyisi yo kereeri dawa­fɔm ni, dama nyini kere minɛm ka a nya u ŋu a.” ");
INSERT INTO cko_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ama, na wɔ kɔ abo ndoori, na labari n abara ayɛ deke n kɛrɛ, nyini ti, Yesu akoro ayi má i ŋu fofoe nu miɛm be nu kun, i fiɛɛri i ŋu ahɛmɛ wɔ, na minɛ afite awɔrɛ n kɛrɛ nu aba i dɔ. ");
INSERT INTO cko_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","I yoori le­nnyɔ na Yesu akpie i nyi aba Kapɛnam miɛ kpiri n nu, na labari abara ayɛ ka i wo awuru, ");
INSERT INTO cko_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","na minɛ atiɛn bu nɔɔ i dɔ agaya haari fofoe anya má anɔ n bo bu fa wura sɔɔ n nu mmɔɔ, na Yesu akan Nyɛmɛ jɔrɛ sukere bu. ");
INSERT INTO cko_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","I wo bu kere su ni, na minɛ nbem aba i dɔ, bu nu minɛ nna sɔ sɔnɔ bo i saam ni i jaam awu. ");
INSERT INTO cko_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Jama n sunnuuri sɔ n dɛɛ ti, ba koro anya má fofoe bo bu fa sɔnɔ n dodo Yesu, na ba fiiti sɔɔ n bo Yesu wo nu n aŋgoro buekun, na ba fa i ni i dasu n kɛrɛ acɔɔndi afa i ada sɔɔ n nu. ");
INSERT INTO cko_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesu ŋuuri kabo bu yoori i yarada n sɔ ni, na wɔ se sɔnɔ n bo i saam ni i jaam awu n ka, “M dɔn, ma fa u satiɛ ace u.” ");
INSERT INTO cko_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Tɔ. Yuda­fɔm Nyɛmɛ nɔaniɛ kere­fɔm nbem tana bɛrɛ, na ba sunsun bu ahore su ka, ");
INSERT INTO cko_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ahin sɔnɔ n la atin bɔnɔ ye i jɔjɔ wura Nyɛmɛ ŋgasi nu sɔ a? Be wo má bɛrɛ bo i koro fa minɛm satiɛ ni bu ŋgasi ce, sin Nyɛmɛ ŋu.” ");
INSERT INTO cko_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Na Yesu afa nu i ahore su fa kɔ bu sunsunni bo bu bita i n su, na wɔ bisa bu ka, “Nzu ti ye am bita nyini sunsunni ni am ahore su a? ");
INSERT INTO cko_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Bɔnɔ ti kekereke a, bo m se sɔnɔ n ka, ‘Ma fa u satiɛ ace u,’ nzɛn, ‘Yasu fa u dasu n na a nati n a’? ");
INSERT INTO cko_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","M kére am ka mini Adamande Wa n la yiko durunya n nu bo m fa minɛm satiɛ ni bu ŋgasi ce bu.” Na wɔ se sɔnɔ n ka, ");
INSERT INTO cko_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Wɔrɔ, yasu fa u dasu n na a kɔ awuru.” ");
INSERT INTO cko_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","I kaba yasu faari i dasu n wɔ, na wɔ fite jama n kɛrɛ nyu­mbaa nu. Na bu kɛrɛ ayo alekutura, na ba kansi Nyɛmɛ, na ba se ka, “Ya nya ŋu má ahin sa n ŋusu cɛɛn be.” ");
INSERT INTO cko_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Na Yesu akaaki akpie i nyi akɔ Galili kunma kpiri n nɔɔ su, na jama beberebe akɔ atiɛn bu nɔɔ i dɔ, na wɔ kan Nyɛmɛ jɔrɛ akere bu. ");
INSERT INTO cko_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","I wo natiiri su susin ni, na wɔ ŋu lampo­de­fɔ be bo bu fere i ka Levi, Alafeyo wa ni, ka i tana i juma yoo­biri, na Yesu ase i ka, “Yasu bra na a ba su m su.” Na wɔ yasu asu i su. ");
INSERT INTO cko_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Na Yesu akɔ Levi dika ka i kɔ di diire. Na satiɛ­yo­fɔm, ni lampo­de­fɔm beberebe asu i su. Diire n dii­biri dɔ ni, na bu dɔŋgu aba atana Yesu ni i susu­fɔm n dɔ, na ba saŋga adi diire. ");
INSERT INTO cko_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Na Nyɛmɛ nɔaniɛ kere­fɔ nbem bo bu su Farasi­fɔm dɛɛ atin su ni, aŋu ka Yesu ni satiɛ­yo­fɔm, ni lampo­de­fɔm tana sudi diire, na ba bisa i susu­fɔm ni ka, “Nzu ti ye Yesu ni lampo­de­fɔm, ni satiɛ­yo­fɔm saŋga di diire a?” ");
INSERT INTO cko_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Na Yesu ati bu jɔjɔɔ­wa n na wɔ bɔ bu nu ka, “Minɛm bo bu la laifiɛ n koro má ayiri­fɔ, má ka bo bu la má laifiɛ ni koro a. Ma ba má ka m bá fere minɛm bo bu ŋa bu yo sa bo i kɔ atin su Nyɛmɛ dɔ n wɔ, ama, m baari satiɛ­yo­fɔm n dɛɛ ti wɔ.” ");
INSERT INTO cko_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Cɛɛn be na Yohane dɛɛ susu­fɔm ni Farasi­fɔm sucici bu nɔɔ, na minɛ nbem aba na ba bisa Yesu ka, “Nzu ti ye Yohane susu­fɔm ni Farasi­fɔm dɛɛ susu­fɔm cici bu nɔɔ, ye u dɛɛm bɛrɛ cici má?” ");
INSERT INTO cko_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Na Yesu abɔ bu nu ka, “Am sunsun ka konyaya­fɔm koro cici bu nɔɔ saŋga bo konyafan n toko wo bu dɔ ni, nzɛn sɛ? Ai, saŋga bo konyafan n wo bu dɔ ni, bu yo má nyini. ");
INSERT INTO cko_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ama, saŋga suba bo bu bá yi konyafan n fite bu nu, nyini saŋga n ye bu nyá cici bu nɔɔ a.” ");
INSERT INTO cko_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Na Yesu akaaki ase ka, “Be koro fa má sanvuin fɔfɔrɛ kpa tɔ má tani dawa kunma, nzɛn i yoori sɔ, sanvuin fɔfɔrɛ ni sɔ́n tani dawa n wɔ, na i téke i kunma n agaya buka su. ");
INSERT INTO cko_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","I kaaki ti sɔ ɔ bekun ka be koro fa má nzan nyii­wa faŋga­fɔ gɔ má dundu dawa bɛbɛtɛ nu, nzɛn i yoori sɔ, dundu ni tíɛ wɔ, na i ká ŋgbɛɛn, na nzan n kɛrɛ sóŋgi. Ama, i ti ye ni ka bu fá nzan nyii­wa faŋga­fɔ gɔ dundu fɔfɔrɛ bii­wa nu.” ");
INSERT INTO cko_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Yuda­fɔm Ŋumi­yi cɛɛn be, na Yesu ni i susu­fɔm ni sunati sin alɛ­mbaa fie be nu, na i susu­fɔm n abubu be akpɛsɛ. ");
INSERT INTO cko_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Na Farasi­fɔm n ase i ka, “Niɛ fɛn. Nzu ti ye u susu­fɔm ni suyo sɔ a? Nyɛmɛ nɔaniɛ kpamaa­wa n kere ka má be yo sɔ, Ŋumi­yi cɛɛn ni.” ");
INSERT INTO cko_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Na wɔ bɔ bu nu ka, “Am nya kan má Nyɛmɛ Jɔrɛ Kadasi n nu, kabo Fɛmɛ Davidi yo yoori saŋga bo i ni i minɛm miɛɛri diire busu n wɔ, nzɛn sɛ? ");
INSERT INTO cko_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Nyini saŋga Abiyata yo ti Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm kɛrɛ kpiɛn n a. Ahɔɛ n ti, na Fɛmɛ Davidi akɔ awura Nyɛmɛ Seree­biri Awuru n nu, na wɔ di kpɔnɔ n bo ba fa ama Nyɛmɛ ni, na wɔ ma i minɛm be. Ama, am si ka ya dɛɛ atin n su, Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm ŋgumi di nyini kpɔnɔ n a.” ");
INSERT INTO cko_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Na Yesu akaaki ase bu ka, “Adamande dɛɛ ti ye Nyɛmɛ yiiri Ŋumi­yi cɛɛn n a, má Ŋumi­yi cɛɛn n dɛɛ ti ye Nyɛmɛ yiiri adamande a. ");
INSERT INTO cko_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Nyini ti, Ŋumi­yi cɛɛn ni mmɔɔ, mini Adamande Wa ni ti i Mibiɛ a.” ");
INSERT INTO cko_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Na Yesu akaaki akɔ tiɛntiɛn­bunɔɔ sɔɔ n nu dɔ bekun. Sɔnɔ asaa fuin be woori dɔ. ");
INSERT INTO cko_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Na minɛm bo bu wo dɔ n atu bu nyu­mbaa aniɛ Yesu, na bu niɛ ka i túntun asaa fuin n Ŋumi­yi cɛɛn ni, nzɛn i túntun má i, adena bu sɔ́ i ŋgɛɛ na bu járaki i ka wɔ saaki Ŋumi­yi cɛɛn n ciire ni. ");
INSERT INTO cko_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Na Yesu ase asaa fuin n ka, “Ba jina afiɛn fɛn.” ");
INSERT INTO cko_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Na wɔ bisa bu ka, “Ya dɛɛ atin n su, atin wo nu ka ya yo sakpa Ŋumi­yi cɛɛn ni, nzɛn ya yo satiɛ wɔ? I kaaki ti ye ni ka ya de ŋgɔɔ, nzɛn ya yi ŋgɔɔ ɔ?” Ama, ba bɔ má i nu. ");
INSERT INTO cko_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Na Yesu aniɛ bu nyunu abara ayɛ, na wɔ fa yaa bu ŋu, na i ahore asaaki fa kɔ bu atii kekere n dɛɛ ti, na wɔ se sɔnɔ n ka, “Teŋge u saa ni.” Na wɔ teŋge i saa ni, na wɔ yo faŋga bekun. ");
INSERT INTO cko_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Na Farasi­fɔm n akaba afite tiɛntiɛn­bunɔɔ sɔɔ n nu akɔ Fɛmɛ Herode minɛm dɔ, na ba sɛsɛ bu ŋu su kabo bu yó na bu kún Yesu. ");
INSERT INTO cko_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Nyini sin na Yesu ni i susu­fɔm n afite akɔ kunma kpiri n nɔɔ su, na jama beberebe afite Galili awɔrɛ n nu asu i su. Nbem gusu fiteeri Yudiya dɛɛ awɔrɛ n nu, ");
INSERT INTO cko_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ni Yɛrusalem miɛ kpiri n nu, ni Idumeya dɛɛ awɔrɛ n nu, na nbem gusu afite Yodan kunma n wiɛ afiiri ni, ni Tiro ni Sidon dɛɛ bue ni. Bu tiiri kabo Yesu yoori alekutura sam barasu ni, nyini ti ye bu baari i dɔ a. ");
INSERT INTO cko_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Yesu ama tukpaki­fɔm beberebe anya laifiɛ n dɛɛ ti, bo bu la tukpaki kɛrɛ koro ka bu miɛ bu nyi wɔ, na bu sakati wura na bu fa bu saa kan i. Nyini ti, na wɔ se i susu­fɔm ni ka bu kpa bu ŋu ni lee ma i, na nzɛn minɛm ba ŋa bu miɛ i ŋu na i koro wura lee n nu. ");
INSERT INTO cko_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Saŋga kɛrɛ bo minɛm bo ajinim wo bu ŋu n nya ŋuuri i, bu kutu i nyunu wɔ, na bu ciindi na bu se ka, “Wɔrɔ ti Nyɛmɛ Wa n a.” ");
INSERT INTO cko_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Na wɔ bɔbɔ ajinim ni ni anyum­boro ka, má bu ma be si i sɔnɔ nzuin nu. ");
INSERT INTO cko_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Na Yesu afun akɔ buka be su, na wɔ fere minɛ n bo i koroori ka bu ba i dɔ ni, na ba ba i dɔ. ");
INSERT INTO cko_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Na wɔ yi bu nu buru ni nnyɔ, na wɔ fa bu ayo i jaramasam ka bu wo i dɔ, na i susunma bu ka bu kɔ sukan Nyɛmɛ jɔrɛ, ");
INSERT INTO cko_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","na wɔ ma bu yiko ka bu kɔ sufɔn yi ajinim minɛm ŋu. ");
INSERT INTO cko_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","I jaramasa buru ni nnyɔm ni bo i yiiri bu n la Simon bo Yesu tuunri i duma ka Petoro ni, ");
INSERT INTO cko_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ni Yakobo ni i niɛma Yohane, bo bu si la Zɛbɛdi na Yesu kaaki tuunri bu duma ka Bowanaje, i bu la ka bu tiɛntiɛn agaya ka nzue wɔ. ");
INSERT INTO cko_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Bu nbem gusu la Andere, ni Filipu, ni Batolomeyo, ni Matio, ni Tomasi, ni Yakobo bo i si la Alafeyo ni, ni Tadayɔ, ni Simon bo i tu ŋgoni fa kɔ i asiɛn su ni, ");
INSERT INTO cko_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ni Yudasi Isikariyoti bo i ba tɔɔri Yesu ni. ");
INSERT INTO cko_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Na Yesu akɔ awuru, na jama aba atiɛn bu nɔɔ bekun bo i ni i susu­fɔm n akoro anya má tana bo bu di diire mmɔɔ. ");
INSERT INTO cko_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Na saŋga bo i minɛm tiiri i ŋga ni, na ba kɔ ka bu kɔ fa i ba awuru, dama minɛm ŋa i nyunu akan i. ");
INSERT INTO cko_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Na Yuda­fɔm Nyɛmɛ nɔaniɛ kere­fɔm bo bu fiteeri Yɛrusalem miɛ kpiri n nu n ase ka, “Bɛlazɛbuli bo i ti ajinim kɛrɛ dɛɛ fɛmɛ ni, wo i ŋu a.” Na ba kaaki ase ka, “Yiri ajinim kɛrɛ fɛmɛ ni ma i yiko ye i koro fɔn yi ajinim n a.” ");
INSERT INTO cko_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Bu seeri sɔ ni, na Yesu afere bu, na wɔ bo bu miɛɛnu. I ŋa, “Sitana koro yo sɛ fɔn yi i dɛɛ ajinim minɛm ŋu a? ");
INSERT INTO cko_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ya fa i ka, nzɛn fɛmɛya nya kpakpaakiiri nu wieeri, nyini fɛmɛya ni kóro jina a? Ai, i kóro jina má. ");
INSERT INTO cko_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Na nzɛn awuru gusu bo i minɛm nya kpakpaakiiri nu, nyini awuru ni kóro jina a? Ai, i kóro jina má. ");
INSERT INTO cko_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Nzɛn Sitana dɛɛ fɛmɛya n nya kpaakiiri nu wieeri, i kóro jina a? Ai, i kóro jina má. Nzɛn i nya yoori sɔ, i faŋga wie wɔ. ");
INSERT INTO cko_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Be koro wura má sɔnɔ faŋga­fɔ dika na i fin i neŋge, má ka wɔ tara i faŋga acin i nyama ka, ye i nya koro fin i neŋge n bo i wo awuru n nu a.” ");
INSERT INTO cko_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Na Yesu akaaki ase ka, “M suse am nahɔrɛ wɔ lɛɛ ka, Nyɛmɛ koro fa minɛm satiɛ kɛrɛ fa ce bu, haari fa kɔ saŋga jɔrɛ ŋgbɛɛn­ŋgbɛɛn kɛrɛ bo bu jɔjɔɔri i fa kɔ Nyɛmɛ dɔ, ");
INSERT INTO cko_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","ama, sɔnɔ kɛrɛ bo i jɔjɔ wuraari Awiɛwiɛ Casi ni ŋgasi nu, Nyɛmɛ fá má i mi ŋgasi ce má i, dama i mi ayo satiɛ bo i la má awieeri lɛɛ.” ");
INSERT INTO cko_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Deke bo i ti na Yesu seeri sɔ n la ka, bɛrɛ Nyɛmɛ nɔaniɛ kere­fɔm ni, bu ŋa ajini wo i ŋu a. ");
INSERT INTO cko_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Na Yesu ni, ni i niɛmam aba i dɔ awuru n bo i wo nu ni, na ba ka ajina dasin asunma ka bu fere i. ");
INSERT INTO cko_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Na jama beberebe atana abara ayɛ yiri Yesu na ba se i ka, “Ti fɛn. U ni, ni u niɛmam wo dasin koro u.” ");
INSERT INTO cko_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Na wɔ se bu ka, “Am ma m kere am bo bu ti m ni, ni m niɛmam.” ");
INSERT INTO cko_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Na wɔ niɛ abara ayɛ minɛm bo bu tana bara yɛɛri i ni, na wɔ se bu ka, “Am niɛ. M ni, ni m niɛmam n yaa. ");
INSERT INTO cko_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Sɔnɔ kɛrɛ bo i yo Nyɛmɛ sa koroo­wa, yiri ti m siwa, ni m niwa, ni m ni a.” ");
INSERT INTO cko_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Na Yesu akaaki akɔ Galili kunma kpiri n nɔɔ su, na wɔ bo i bu sukere minɛm Nyɛmɛ jɔrɛ, na jama beberebe atiɛn bu nɔɔ i dɔ. Jama n sunnuuri beberebe n dɛɛ ti, na wɔ wura lee nu atana nzue n nu, na jama n kɛrɛ atiɛn bu nɔɔ fa dodo nzue n nɔɔ su. ");
INSERT INTO cko_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Na wɔ bo miɛɛnu, na wɔ kere bu dekem beberebe. I ŋa, ");
INSERT INTO cko_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Am ti fɛn. Dɔdɔɔri­fɔ be yo fiteeri sɔ ɔ, ka i kɔ sandi alɛ­mbaa. ");
INSERT INTO cko_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Saŋga bo i wo sandi su ni, na alɛ­mbaam nbem atɔtɔ atin n nɔɔ, na anumam aba atambu bu ami. ");
INSERT INTO cko_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Na nbem atɔtɔ tiɛka su, deke bo fa sunnu má ni, na fa sunnu má n dɛɛ ti, na wɔ cɛ má, na wɔ fi, ");
INSERT INTO cko_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ama, saŋga bo wiɛ ba fiteeri agaya ni, na wɔ waandi, dama bunlui n akpama abi má n dɛɛ ti. ");
INSERT INTO cko_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Na alɛ­mbaa ni nbem atɔtɔ lɔlɔɛ nu, na lɔlɔɛ n anyi akata i ŋu, nyini ti, wɔ koro awura má mbaa. ");
INSERT INTO cko_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ama, na alɛ­mbaam ni nbem atɔtɔ asiɛn kpa su, na wɔ nyi awura mbaa zɔi zɔi.” ");
INSERT INTO cko_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Na Yesu ase bu ka, “Bo i koro ka i ti ahin jɔrɛ n bu, i ti ye ni ka i so i sui na i ti.” ");
INSERT INTO cko_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Na saŋga bo i kaari i ni i susu­fɔ buru ni nnyɔm ni, ni minɛm bo bu wo i dɔ saŋga kɛrɛ ni, na ba bisa i nyini miɛɛnu n bu. ");
INSERT INTO cko_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Na wɔ bɔ bu nu ka, “Ambɛrɛ ye Nyɛmɛ ama am asi i fɛmɛya n nu asiri jɔrɛ a, ama, minɛm bo bu su má m su ni, m bo i miɛɛnu kere bu a, ");
INSERT INTO cko_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","adena i yó kabo ba kɛrɛ i Nyɛmɛ Jɔrɛ Kadasi n nu ni, ka, ‘Bu níɛ ni nahɔrɛ su, ama, bu ŋú má pui. Bu só bu sui ni nahɔrɛ su, ama, bu tí má deke n bo bu so bu sui ka bu ti i n bu, dama nzɛn má bu tiiri i bu, má bu káaki bu wo wɔ, na Nyɛmɛ fá bu satiɛ ce bu.’” ");
INSERT INTO cko_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Na Yesu abisa bu ka, “Am ati má ahin miɛɛnu n bu? Ye am yó sɛ ti miɛɛnu nyiŋgam n kɛrɛ bu a? ");
INSERT INTO cko_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ahin miɛɛnu n bu la ka, dɔdɔɔri­fɔ n ti ka sɔnɔ n bo i kan Nyɛmɛ jɔrɛ n wɔ. ");
INSERT INTO cko_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Minɛ nbem de Nyɛmɛ nɔaniɛ n kabo alɛ­mbaa n tɔtɔɔri atin n nɔɔ n wɔ. Bu nya tiiri Nyɛmɛ nɔaniɛ n na bu de i, i cɛ má, na Sitana bá yi nɔaniɛ n fite bu ahore su, a ŋu ka bu wara afi i sa. ");
INSERT INTO cko_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Minɛ nbem gusu de Nyɛmɛ nɔaniɛ n kabo alɛ­mbaa n tɔtɔɔri tiɛka su n wɔ. Bu nya tiiri Nyɛmɛ nɔaniɛ ni, a ŋu ka ba de i ndende ni ahorejɔ, ");
INSERT INTO cko_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ama, i da má bu ahore su. Bu kaaki ti ka alɛ­mbaa n bo i bunlui akpama abi má n wɔ. I woori bu dɔ kaan sɔ na nzɛn wahara, wara kekereke be ba tuuri bu fa kɔ bu nyɛmɛsu n su, a ŋu ka ba fa ati. ");
INSERT INTO cko_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Nbem gusu de Nyɛmɛ nɔaniɛ n kabo alɛ­mbaa n tɔtɔɔri lɔlɔɛ nu n wɔ. Bu nya tiiri Nyɛmɛ nɔaniɛ ni, ");
INSERT INTO cko_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ama, bu sunsunni kɛrɛ wo kabo bu yó na bu asiri káta su, na bu koro kabo bu yó na bu nyá ajɛkɛ kɛrɛ, na bu ahore bi fa kɔ durunya n nu neŋgem su, na Nyɛmɛ nɔaniɛ n koro da má bu ahore su na i yo juma. Bu ti ka alɛ­mbaa n bo i wura má mbaa n wɔ. ");
INSERT INTO cko_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ama, minɛ nbem de Nyɛmɛ nɔaniɛ n kabo alɛ­mbaa n tɔtɔɔri asiɛn kpa su n wɔ. Bu nya tiiri Nyɛmɛ nɔaniɛ ni, na bu de i, na bu fa yo juma na i yo kpɛrɛ beberebe.” ");
INSERT INTO cko_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Na Yesu abisa bu ka, “Am nya ŋu ka sɔnɔ be aso fitana su na i fa gaŋga butu su, nzɛn má nyini i fa kɔ se gado bu? I fa taka deke su aŋgoro wɔ bo sɔnɔ kɛrɛ koro ŋu i, má sɔ? ");
INSERT INTO cko_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Dama deke be wo má bɛrɛ bo i wo fiɛɛ­wa nu, na bu bá ŋu má i, na deke be gusu wo má bɛrɛ bo i wo asiri nu, na bu bá si má i. ");
INSERT INTO cko_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Sɔnɔ kɛrɛ bo i koro ka i ti ahin jɔrɛ n bu, i ti ye ni ka i so i sui na i ti.” ");
INSERT INTO cko_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Na wɔ se bu ka, “Am si am ŋu sa ni kabo am ti nɔaniɛ barasu ni. Gɔŋgɔ bo am fa susu ma minɛm ni, sɔ ye Nyɛmɛ gusu fá susu ma am a, na bo Nyɛmɛ yó ma am ni tara sɔ n mmɔɔ. ");
INSERT INTO cko_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Dama sɔnɔ kɛrɛ bo wɔ nya deke be Nyɛmɛ dɔ na i mi si i bita, Nyɛmɛ búka i su wɔ, ama, bo i si má i bita, haari ni nyini kaan n bo i la i ni, Nyɛmɛ dé i dɔ ɔ.” ");
INSERT INTO cko_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Na wɔ kaaki ase bu ka, “Nyɛmɛ fɛmɛya n ti ka kabo dɔdɔɔri­fɔ be kɔ sandi alɛ­mbaa i fiesu n wɔ. I dɛɛ la ka i sandi wɔ, ");
INSERT INTO cko_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","na i kɔ da kɔŋguɛ, na i teŋge alecin. Nyini saŋga n ye alɛ­mbaa n fi a, na i sunyi, i si má kabo i yoori barasu. ");
INSERT INTO cko_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Asiɛn n buka alɛ­mbaa n ye i fi a. I nya fi wieeri, na i nyi, na i nyinsɛ, na i wɔrɔ, na i nya bi mbaa. ");
INSERT INTO cko_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Alɛ­mbaa n ba bi ni, i kpiɛ saŋga lɛɛ, na i kpiɛ i.” ");
INSERT INTO cko_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Na wɔ kaaki ase bu ka, “Ya fá nzu deke fa sunsun Nyɛmɛ fɛmɛya n a? Wara ya fá miɛɛnu barasu bɔnɔ ye ya bó i fa kere kabo Nyɛmɛ fɛmɛya n ti a? ");
INSERT INTO cko_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","I ti ka nyɛm mbaa bo bu dɔ i wɔ. Yiri ti alɛ­mbaa n kɛrɛ kaan durunya n nu a. ");
INSERT INTO cko_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ama, bu nya ba dɔɔri i na i fiiri, i tara toro nyawam n kɛrɛ bambaka, i koro nyi na i tɛtɛrɛki asa­mbaa asa­mbaa bo anumam koro yo bu tiɛɛrim nu.” ");
INSERT INTO cko_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Na Yesu afa nyini miɛɛnu n ni miɛɛnu nyiŋgam beberebe akan Nyɛmɛ jɔrɛ akere bu, kabo sɔnɔ kɛrɛ koro ti i bu barasu. ");
INSERT INTO cko_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Jama n nya woori i dɔ, i se má bu pui, má ka miɛɛnu ye i bo bu a, ama, i ba kaari i ni i susu­fɔm ni, na i nya yi i bu kɛrɛ kere bu. ");
INSERT INTO cko_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Nyini cɛɛn n naasɔ saŋga, na Yesu ase i susu­fɔm n ka, “Am ma ya kpiɛ kɔ kunma kpiri n buekun dɔ.” ");
INSERT INTO cko_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Na i susu­fɔm n acin ayaki jama ni, na ba ba awura lee n bo Yesu wo nu n nu, na ba kɔ. Na nbem gusu afa lee nbem na ba su i su. ");
INSERT INTO cko_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Na aŋuma bambaka be ayasu, na i subo nzue gɔ lee n nu. Má lee ni suyi ni nzue wɔ. ");
INSERT INTO cko_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Nyini saŋga ni, Yesu afa piti asɔn i tii, ye i wo daafiri su lee n sin, na ba ba ateŋge i ase i ka, “Ya Kere­fɔ, nzɛn ya suwu, u cɛcɛ wo má ya nu fan?” ");
INSERT INTO cko_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Na wɔ yasu na wɔ tiɛn aŋuma n ŋu, na wɔ se nzue n ka, “Da surum.” Na aŋuma n atara, na dika n kɛrɛ atara jum. ");
INSERT INTO cko_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Na wɔ se bu ka, “Nzu ti ye am soro sɛrɛ sɔ a? Am yo má m yarada?” ");
INSERT INTO cko_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Na sɛrɛ akaaki ati bu agaya, na ba bisa bu ŋuŋu nu ka, “Nzu sɔnɔmbiri barasu la ahin bo aŋuma ni nzue n mmɔɔ de i nɔaniɛ a?” ");
INSERT INTO cko_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Na Yesu ni i susu­fɔm n akpiɛ kunma kpiri n akɔ aju Gɛrasafɔm dɛɛ awɔrɛ n nu. ");
INSERT INTO cko_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","3","Saŋga bo Yesu fiteeri lee n nu ni, na sɔnɔ be afite faŋ­kunma nu aba akpa i atin. Nyini sɔnɔ n nati da faŋ­kunma nu wɔ, dama ajini wo i ŋu. Sɔnɔ be wo má bɛrɛ bo i koro tara i cici i ni jɔrɔkɔ n mmɔɔ kun, ");
INSERT INTO cko_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","dama saŋga kɛrɛ bu bo i tobari wɔ na bu wura i jɔrɔkɔ buka su, ama, haari ni nyini n mmɔɔ i titi jɔrɔkɔ n wɔ na i kaaki bo sandi tobari n nu. Be wo má bɛrɛ bo i la faŋga koro tara i jina kun. ");
INSERT INTO cko_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Kɔŋguɛ ni wiɛsu kɛrɛ i wo faŋ­kunma nu sɔ ɔ, ni bukam su na i suciindi, na i sufa yabuɛ kpiɛkpiɛ i ŋu. ");
INSERT INTO cko_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","8","Na wɔ ŋu Yesu saŋga bo i toko wo dede ni yiri ni, na Yesu atiɛn ajini n ŋu ase i ka, “Ajini, fite yaki nyini sɔnɔ ni.” Na sɔnɔ n aŋmati akɔ akutu Yesu nyunu, na wɔ ciindi ase ka, “Yesu, Micɛra Nyɛmɛ Kpiri n Wa, a koro nzu m dɔ fɛn a? M sere u wɔ, Nyɛmɛ ti, má a ma m ŋu anyum­boro.” ");
INSERT INTO cko_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Na Yesu abisa i ka, “Bu fere u sɛ?” Na wɔ bɔ i nu ka, “Bu fere m ka Jama Beberebe­fɔ, dama ya sunnu.” ");
INSERT INTO cko_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Na wɔ sere Yesu jande ka má i fɔn bu fite nyini awɔrɛ n nu. ");
INSERT INTO cko_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Nyini saŋga afam beberebe wo dodo bɛrɛ, bu wo buka be su sudi, ");
INSERT INTO cko_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","na ajinim n asere Yesu ka, “Ma ya kɔ fun afam n ŋu.” ");
INSERT INTO cko_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Na Yesu ama bu atin na ba fite akɔ afun afam n ŋu. Afam n ju akpii nnyɔ dika, na bu kɛrɛ aŋmati acɔɔndi akɔ ato kunma kpiri nzue n nu, na nzue n adi bu. ");
INSERT INTO cko_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Afa sasa­fɔm ŋuuri nyini n sɔ ni, na ba ŋmati akɔ abo ndoori miɛ kunnu, ni ahɛmɛ ahɛmɛ kɛrɛ su. Na minɛ aba aniɛ sa n bo i yoori ni. ");
INSERT INTO cko_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Na ba ba Yesu dɔ, na ba ŋu sɔnɔ n bo ajinim n yo woori i ŋu n ka i tana Yesu bi wura tanlɛɛ, ni i nyunu koroya su, na sɛrɛ ati bu. ");
INSERT INTO cko_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Na minɛm bo bu ŋuuri sa n yoo­biri ni, akan jɔrɛ n kɛrɛ akere jama n fa kɔ sa n bo i tuuri sɔnɔ n bo ajinim yo woori i ŋu ni, ni sa n bo i tuuri afam ni. ");
INSERT INTO cko_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Bu tiiri jɔrɛ n sɔ ni, na ba nya asere Yesu jande ka i yasu bu awɔrɛ n nu. ");
INSERT INTO cko_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Saŋga n bo Yesu suwura lee n nu na i kɔ ni, na sɔnɔ n bo ajinim yo woori i ŋu ni, asere i jande ka i ma i su i su. ");
INSERT INTO cko_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ama, na Yesu akete, na wɔ se i ka, “Kpie u nyi kɔ awuru na a kɔ kan kere u lamɔkɔm fa kɔ sakpa n bo Mibiɛ n ayo ama u ni, ni kabo wɔ si u aŋunfɔ barasu ni.” ");
INSERT INTO cko_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Na sɔnɔ n akpie i nyi akɔ akan sakpa n kɛrɛ bo Yesu ayo ama i ni, abara ayɛ Miɛ Burum dɛɛ awɔrɛ n nu, na sɔnɔ kɛrɛ ayo alekutura. ");
INSERT INTO cko_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Na Yesu awura lee n nu akpie i nyi akpiɛ kunma kpiri n buekun dɔ, na jama beberebe aba atiɛn bu nɔɔ i bi nzue n nɔɔ su. ");
INSERT INTO cko_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Na Yuda­fɔm kpiɛn be wo bɛrɛ, yiri niɛ bu tiɛntiɛn­bunɔɔ sɔɔ n su a. Bu fere i ka Yarusi. Na wɔ ba Yesu dɔ nzue n nɔɔ su na wɔ kutu i jaa bu, ");
INSERT INTO cko_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","na wɔ sere i jande. I ŋa, “M wa suŋguru atɔ cin. Bra na a ba fa u saa nana i ŋu na i nya ŋgɔɔ ni laifiɛ.” ");
INSERT INTO cko_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Na Yesu asu i su na ba kɔ. Na jama beberebe asu Yesu su haari bu kɔ sumiɛ i ŋu. ");
INSERT INTO cko_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Bara be woori jama n nu, i bita abiɛɛri i afɔ buru ni nnyɔ lɛɛ bo i kpu na i kpiɛ má. ");
INSERT INTO cko_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Wɔ di wahara, na wɔ saaki i ŋwaa kɛrɛ atuntun i ŋu ayiri­fɔm dɔ dede haari wɔ ba afie, ama, wɔ nya má laifiɛ se tukpaki n buka su kɔ ɔ. ");
INSERT INTO cko_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Na wɔ ti Yesu ŋga, na wɔ sakati awura jama n nu Yesu sin, afa i saa akan Yesu tanlɛɛ ni. ");
INSERT INTO cko_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Dama i seeri i kunnu ka, “Nzɛn m koro yoori aniɛ faari m saa kaanri i tanlɛɛ n mmɔɔ, m nyá laifiɛ.” ");
INSERT INTO cko_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Na wɔ yo sɔ n kpeŋga na i abiɛɛri n akpiɛ, na yiri ni i tii aŋu ka wɔ nya laifiɛ. ");
INSERT INTO cko_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jina n nu bɛrɛ na Yesu afa nu ka i yiko n be afite i ŋuniɛ nu akɔ ayo juma. Na wɔ kaaki aniɛ jama n nu, na wɔ bisa ka, “Ŋma faari i saa kaanri m tanlɛɛ n a?” ");
INSERT INTO cko_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Na i susu­fɔm n ase i ka, “Wɔrɔ mmɔɔ aŋu kabo jama n amiɛ u barasu, ye nzu ti ye a bisa ka, ŋma fa i saa kaanri u a?” ");
INSERT INTO cko_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ama, na wɔ niɛ abara ayɛ na i si sɔnɔ n bo i yoori sɔ ni. ");
INSERT INTO cko_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Na sɛrɛ ati bara ni, i jina, i ŋuniɛ kɛrɛ subobo i fa kɔ sa n bo i tuuri i ni, na wɔ ba akutu Yesu nyunu, na wɔ kan jɔrɛ n kɛrɛ ni i nahɔrɛ atin su akere i. ");
INSERT INTO cko_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Na Yesu ase i ka, “M wa, yarada n bo a yo m ni, yiri ma a nya laifiɛ a. Kɔ awuru ni ahoreda, na má u tɔrɛ n ba u ŋu kun.” ");
INSERT INTO cko_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Saŋga n bo Yesu toko wo jɔjɔ su ni, na minɛ nbem afite tiɛntiɛn­bunɔɔ sɔɔ n kpiɛn n dika aba ase i ka, “U wa n wo má bɛrɛ. Nyini ti, má a dama ya Kere­fɔ n kun.” ");
INSERT INTO cko_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Na jɔrɛ n ato Yesu sui nu, ama, na wɔ se kpiɛn n ka, “Má a ma sɛrɛ ti u, wɔrɔ yo m yarada.” ");
INSERT INTO cko_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Wɔ soro má su ka be su i su kun, má ka Petoro, ni Yakobo, ni i niɛma Yohane. ");
INSERT INTO cko_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Bu kɔ juuri kpiɛn n dika ni, na Yesu awura aŋu ka minɛ beberebe suyo naŋmiɛ, bu susun subo awie. ");
INSERT INTO cko_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Na wɔ bisa bu ka, “Nzu ti ye am suyo naŋmiɛ sun sɔ a? Baa­bara n awu má, wɔ daafi wɔ.” ");
INSERT INTO cko_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Na ba siri i. Na wɔ fɔn bu kɛrɛ afite, na wɔ fa baa­bara n si ni i ni, ni i susu­fɔ nsanm ni, na ba kɔ sɔɔ n bo baa­bara n da nu ni. ");
INSERT INTO cko_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Na wɔ kɔ atara i saa, na wɔ se i ka, “Talita kumi.” I bu la ka, “Suŋguru kaan, m ŋa a yasu.” ");
INSERT INTO cko_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Kpeŋga na suŋguru n ayasu anati. I yo ti afɔ buru ni nnyɔ baa a. Na minɛm kɛrɛ bo bu woori bɛrɛ n ayo alekutura agaya. ");
INSERT INTO cko_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Na Yesu abɔbɔ bu ni nahɔrɛ su ka má bu ma be si sa n bo wɔ yo i ni, na wɔ se ka bu ma baa n deke be na i di. ");
INSERT INTO cko_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ye Yesu yasu kɔɔri i bɔsu na i susu­fɔm n asu i su. ");
INSERT INTO cko_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Na Yuda­fɔm Ŋumi­yi cɛɛn n na wɔ kɔ bu tiɛntiɛn­bunɔɔ sɔɔ n nu, na wɔ kɔ akan Nyɛmɛ jɔrɛ akere bu. Minɛm bo bu tiiri i keree­wa n kɛrɛ yoori alekutura. Na ba bisa bu ŋuŋu nu ka, “Nifansu ye ahin sɔnɔ n kɔ sɔnsɔɔnri i si n kɛrɛ a? Bu maari i alecira bɔnɔ ɔ? Ye alekutura sam bo i yo bu ni, i yo sɛ yo bu a? ");
INSERT INTO cko_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Má Mariya wa n bo i ti kampenta n lɛɛ? Má Yakobo ni Yose ni Yuda ni Simon n gɔrɔ n lɛɛ? Am niɛ e. Má i niɛma nbaram mmɔɔ wo ya nu fɛn n a?” Na ba bu i ŋgbɛɛn. ");
INSERT INTO cko_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Na Yesu ase bu ka, “Deke kɛrɛ bu ma Nyɛmɛ nɔaniɛ kan­fɔ jirima, má ka i bɔsu­fɔm ni i lamɔkɔm ni i gisan­nu­fɔm dɔ ŋgumi.” ");
INSERT INTO cko_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Nyini ti, wɔ koro ayo má alekutura sa be i bɔsu dɔ se i faari i saa nanaari tukpaki­fɔ nbem ŋu wɔ, na ba nya laifiɛ. ");
INSERT INTO cko_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Na wɔ yo i awarabo kabo i bɔsu­fɔm n ayo má i yarada ni. Na Yesu abara ayɛ ahɛmɛ miɛm n kɛrɛ su, na i sukere minɛm. ");
INSERT INTO cko_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Na wɔ fere i susu­fɔ buru ni nnyɔm ni, na wɔ sunma bu nnyɔ nnyɔ, na wɔ ma bu yiko ka bu kɔ sufɔn yi ajinim fite minɛm ŋu. ");
INSERT INTO cko_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Na wɔ se bu ka, “Má am fa puitiri­pui kɔ ahin atin n bo am sukɔ ni, diire o, kuruku o, ŋwaa o. Ama, am fa kpama ni gbagbaa yiri. Má am se ka am fa tanlɛɛ buka bo am wura i n su.” ");
INSERT INTO cko_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Na wɔ kaaki ase bu ka, “Am kɔ juuri miɛ be su, awuru kɛrɛ bo am kɔ wuraari nu, am ka nyini awuru n nu, haari am bá fite miɛ n nu. ");
INSERT INTO cko_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Sasu bekun miɛ bo am kɔ wuraari nu na ba de má am wɔfɔ, na ba kaaki asoro má am su ka bu ti am nɔaniɛ ni, am fite yaki nyini miɛ n ni, na am kpɔnkpɔn yi am jaa tuturi kɛrɛ. Nyini dí daani kere bu ka bu woo­wa ti má kpa.” ");
INSERT INTO cko_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Na i susu­fɔm n afite akɔ akan Nyɛmɛ jɔrɛ akere minɛm ka bu kaaki bu wo. ");
INSERT INTO cko_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Na ba fɔn ayi ajinim minɛm beberebe ŋu, na ba sere Nyɛmɛ ama tukpaki­fɔm dɔŋgu, na ba fa ŋguin agɔ bu ŋu, na ba nya laifiɛ. ");
INSERT INTO cko_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Na Fɛmɛ Herode ati nyini sa n kɛrɛ, dama Yesu duma ata abara ayɛ deke kɛrɛ. Na minɛ nbem ase ka, “Yohane Nyɛmɛ Nzue Biɛ­fɔ n ye wɔ teŋge i yiwee n nu a, nyini ti ye i la yiko koro yo nyini alekutura sam kɛrɛ a.” ");
INSERT INTO cko_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ama, na nbem ase ka, “Yiri la Eliya a.” Na nbem gusu ase ka, “I ti Nyɛmɛ nɔaniɛ kan­fɔ ka dawa dɛɛm wɔ.” ");
INSERT INTO cko_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ama, Fɛmɛ Herode tiiri nyini ni, na yiri ase ka, “Yohane bo m kpiɛɛri i tii n ye wɔ teŋge a.” ");
INSERT INTO cko_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Fɛmɛ Herode yo ma bu taraari Yohane nyiiri wɔ, dama yiri Fɛmɛ Herode afin i gɔrɔ Filipu yi Herodiya afa aja. ");
INSERT INTO cko_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Má pui ti, dama Yohane ase Fɛmɛ Herode ka, “Nyɛmɛ nɔaniɛ kpamaa­wa n kere ka a la má atin ka a fa u gɔrɔ yi ja i ŋgɔɔ su.” ");
INSERT INTO cko_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Yohane seeri sɔ ni, na Herodiya afa i ŋgasi na wɔ fɔ aŋminda i kabo i nya i na i kun i. Ama, wɔ koro anya má i, ");
INSERT INTO cko_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","dama Fɛmɛ Herode ni i tii soroori Yohane ka i ti sɔnɔ fofoe bo i yo sa bo i kɔ atin su Nyɛmɛ dɔ ɔ. Wɔ koro má ka pui yo i. Na Fɛmɛ Herode ajimi fa kɔ nɔaniɛ n kɛrɛ bo Yohane kan maari i n su, ama, haari ni nyini mmɔɔ, i koro ka i suti i nɔaniɛ n wɔ. ");
INSERT INTO cko_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Cɛɛn be sɔ ɔ na Herodiya aba anya Yohane taraa­biri. Nyini cɛɛn n ye Fɛmɛ Herode sugɔ i baa­wu cɛɛn agɔrɛ n a. Na wɔ fere i gomina minɛ ŋgbiŋgbirim, ni i soja nkpiɛn­kpiɛnm, ni Galili minɛ tere­tere­fɔm kɛrɛ ka bu ba di na bu nu. ");
INSERT INTO cko_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Agɔrɛ n nu ni, na Herodiya wa suŋguru awura agɔ akere Fɛmɛ Herode ni i jamam, na bu kɛrɛ ahore ajɔ. Dɔ ye fɛmɛ n seeri suŋguru n ka, “Deke kɛrɛ bo a koro, se m, na m má u.” ");
INSERT INTO cko_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Na wɔ tan ndiɛ ase i ka, “Haari a ŋa m kpaaki m fɛmɛya n buekun ma u mmɔɔ, m fá ma u.” ");
INSERT INTO cko_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Na suŋguru n afite akɔ abisa i ni ka, “Ye m sere nzu wɔ?” Na i ni n ase i ka, “Kɔ se i ka a koro Yohane Nyɛmɛ Nzue Biɛ­fɔ n tii­awa a.” ");
INSERT INTO cko_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Na wɔ ŋmati akpie i nyi ndende aba ase Fɛmɛ Herode n ka, “M koro ka na a fa Yohane Nyɛmɛ Nzue Biɛ­fɔ n tii­awa ma m pɛrɛntɛ nu kisa kisa.” ");
INSERT INTO cko_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Fɛmɛ n tiiri sɔ ni, na i ahore asaaki agaya, ama, ndiɛ n bo i taanri i jama n nyunu n dɛɛ ti, wɔ koro akaaki má i nɔɔ. ");
INSERT INTO cko_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Kpeŋga na fɛmɛ n asunma soja ŋminda­fɔm n kun ka i kɔ fa Yohane tii­awa bra. Na wɔ kɔ akpiɛ i tii dan­saraka sɔɔ n nu dɔ. ");
INSERT INTO cko_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Na wɔ fa ada pɛrɛntɛ n nu aba ama suŋguru ni, na yiri gusu afa akɔ ama i ni ni. ");
INSERT INTO cko_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Saŋga bo Yohane susu­fɔm tiiri sɔ n na ba ba afa fuin n akɔ ase i. ");
INSERT INTO cko_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Na jaramasam n akpie bu nyi aba i dɔ, na ba kan sam kɛrɛ bo ba yo i n akere i, ni kabo ba kan Nyɛmɛ jɔrɛ akere minɛ barasu. ");
INSERT INTO cko_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Jama n dɛɛ ti, ba nya má anyuŋkoro bo bu di diire. Nyini ti, na Yesu ase bu ka, “Am ma ya kɔ deke bo minɛm wo má, na am kɔ yi am ŋumi.” ");
INSERT INTO cko_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Na bɛrɛ ŋgumi afa lee ni na ba kɔ. ");
INSERT INTO cko_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Bu yasu sukɔ ni, na minɛm dɔŋgu aŋu bu, na ba si bu, na ba fite miɛ miɛm su aŋmati adu bu mɔ akɔ aju deke bo bu sukɔ ni. ");
INSERT INTO cko_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Saŋga bo Yesu fiteeri lee n nu ni, na wɔ ŋu jama beberebe, na wɔ si bu aŋunfɔ, dama bu ti ka nbɔɛm bo bu la má sasa­fɔ ɔ, na wɔ kere bu dekem beberebe. ");
INSERT INTO cko_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Na saŋga bo wiɛ ba sutɔ ni, na i susu­fɔm n aba i dɔ aba ase i ka, “Kisa, wiɛ sutɔ, ya wo boro gusu wɔ lɛɛ. ");
INSERT INTO cko_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ma minɛm n atin na bu kɔ miɛ kunnu ni ahɛmɛ ahɛmɛ miɛm su na bu kɔ nya diire be to di.” ");
INSERT INTO cko_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ama, na Yesu ase bu ka, “Ambɛrɛ mmɔɔ ni am tii nya deke be ma bu na bu di.” Na ba se i ka, “Nzɛn a ŋa ya to kpɔnɔ ma ahin jama n kɛrɛ, ya dí ŋwaa beberebe.” ");
INSERT INTO cko_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Na wɔ bisa bu ka, “Ambɛrɛ la kpɔnɔ nyɛ wɔ? Am niɛniɛ na am niɛ.” Na ba kɔ aniɛ na ba bɔ i nu ka, “Kpɔnɔ nnu ni jombaa nnyɔ wo bɛrɛ a.” ");
INSERT INTO cko_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Na Yesu ase i susu­fɔm n ka bu ma jama n tana asɛsɛ asɛsɛ wura fiɛfiɛɛ­wa n su. ");
INSERT INTO cko_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Na ba tana asɛsɛ asɛsɛ yaa yaa ni aburu­nu nnu. ");
INSERT INTO cko_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Na wɔ fa kpɔnɔ nnu ni, ni jombaa nnyɔ ni, na wɔ yɛ i tii su aŋgoro, na wɔ da Nyɛmɛ asi. Na wɔ kpiɛkpiɛ kpɔnɔ nnu n nu, na wɔ fa ama i susu­fɔm n ka bu fa ma minɛm ni, na wɔ fa jombaa nnyɔ n gusu akpaaki bu kɛrɛ nu. ");
INSERT INTO cko_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Na bu kɛrɛ adi na bu kunnu ayi. ");
INSERT INTO cko_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Na ba tambu kpɔnɔ, ni jombaa sinsin bo bu diiri na i kaanri ni, na ba nya kandiɛ buru ni nnyɔ. ");
INSERT INTO cko_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Minɛm bo bu diiri kpɔnɔ n ni jombaa n kɛrɛ yasuuri nbiɛsɔm akpii nnu wɔ. ");
INSERT INTO cko_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Nyini sin na Yesu ama i susu­fɔm n awura lee n nu na bu du i mɔ kpiɛ kɔ Besayida miɛ nu kunma kpiri n buekun, na yiri aka na i kaari jama ni. ");
INSERT INTO cko_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","I kaari bu wieeri ni, na wɔ fun akɔ buka n su ka i kɔ sere Nyɛmɛ. ");
INSERT INTO cko_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Saŋga bo ale ba saanri ni, lee n aju kunma kpiri n afiɛn, na Yesu ŋgumi aka kunma kpiri n sin. ");
INSERT INTO cko_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Na wɔ ŋu ka i susu­fɔm n sudi wahara lee n kaan­biri, dama aŋuma sun bu kɔ bu sin wɔ. Na fa kɔ akɔnyuma ciciri su, na wɔ nati nzue n su suba bu dɔ, na wɔ yo ka i susin bu ŋu. ");
INSERT INTO cko_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Saŋga bo bu ŋuuri ka i nati nzue n su ni, na ba sunsun ka, ŋumi a, na ba bo awie. ");
INSERT INTO cko_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Bu kɛrɛ ŋuuri i sɔ ni, na sɛrɛ ati bu agaya. Kpeŋga na Yesu ajɔjɔ bu dɔ, na wɔ se bu ka, “Am ma am ahore si, mini a, má am soro sɛrɛ.” ");
INSERT INTO cko_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Na wɔ wura lee n nu, na aŋuma n atara. Na i susu­fɔm n kɛrɛ ayo alekutura agaya. ");
INSERT INTO cko_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Dama ba koro ati má i bu kabo i la yiko koro faari kpɔnɔ nnu maari jama beberebem ni, bu ahore­mbaa ti kekereke n dɛɛ ti. ");
INSERT INTO cko_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Na ba kpiɛ nzue n aba aju awɔrɛ n bo bu fere i ka Gɛnɛsarɛti n nu, na ba minda lee n ahɛmɛ. ");
INSERT INTO cko_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Bu fiteeri lee n nu kpeŋga ni, na minɛm n asi ka Yesu lɛɛ. ");
INSERT INTO cko_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Na ba ŋmati abara ayɛ miɛm n kɛrɛ su, na deke kɛrɛ bo bu tiiri i ŋga, bu sɔ bu tukpaki­fɔm ni bu dasum kɛrɛ ba i dɔ ɔ. ");
INSERT INTO cko_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Na nzɛn i kɔɔri ahɛmɛ miɛm wara miɛ kunnu, deke kɛrɛ bo i fa, bu fa bu tukpaki­fɔm ba i dɔ sɔ ɔ, na bu sere i jande ka i ma bu fa bu saa kan i tanlɛɛ n jaa bu. Na bo bu yoori sɔ n kɛrɛ anya laifiɛ. ");
INSERT INTO cko_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Na Yuda­fɔm Nyɛmɛ nɔaniɛ kere­fɔm nbem bo bu fite Yɛrusalem miɛ kpiri n nu ni, ni Farasi­fɔm n aba atiɛn bu nɔɔ Yesu dɔ. ");
INSERT INTO cko_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Na ba ŋu ka Yesu susu­fɔm n nbem sudi diire bu saa fin, ba ŋmisi má bu saa kabo bu nana sa­yoo­wa ti barasu ni. ");
INSERT INTO cko_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Dama Farasi­fɔm ni Yuda­fɔm kɛrɛ la bu saa ŋmisi sa­yoo­wa bo i ti bu nana sa a. Bu nya ŋa bu di diire, bu du mɔ yo nyini sa n wɔ ka, na bu nya di. ");
INSERT INTO cko_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Nzɛn haari bu fiteeri gɔ ba juuri awuru, bu di má neŋgem bo ba fa aba ni, má ka ba ŋmisi i ka, na bu yo bu nana sa­yoo­wa bo bu yo na bu di ni. Bu sa­yoo­wam sunnu. Bu nbem la ka bu ŋmisi awam ni dundum ni ayabam wɔ. ");
INSERT INTO cko_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Na Farasi­fɔm ni, ni Yuda­fɔm Nyɛmɛ nɔaniɛ kere­fɔm n abisa Yesu ka, “Nzu ti ye u susu­fɔm n su má ya nam sa­yoo­wa n su, ye bu di diire bu saa fin a?” ");
INSERT INTO cko_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Na Yesu ase bu ka, “Nahɔrɛ ye Nyɛmɛ nɔaniɛ kan­fɔ Esaya yo kaanri am jɔrɛ ka am ti burukɔɔ­nu­fɔm n a. Wɔ kɛrɛ i kadasi n nu ka, Nyɛmɛ ŋa o, ‘Ahin minɛm ni, bu ma m jirima bu nɔɔ nu bɛrɛ wɔ, ama, i wo má bu ahore su. ");
INSERT INTO cko_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Bu kansi m ŋgbɛɛn wɔ, dama bu kere minɛ adamande dɛɛ keree­wam wɔ, na bu se ka nyini keree­wa n fite Nyɛmɛ dɔ ɔ.’” ");
INSERT INTO cko_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Na Yesu ase bu ka, “Am acɛ Nyɛmɛ nɔaniɛ maa­wa n ase buekun, na am nya susu adamande dɛɛ sa­yoo­wam su.” ");
INSERT INTO cko_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Na wɔ se bu bekun ka, “Am la nahɔrɛ bo am akpiɛ mbɛnlɛ ayaki Nyɛmɛ nɔaniɛ maa­wa n na am asu am dɛɛ sa­yoo­wam su ni. ");
INSERT INTO cko_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Dama Moyisi ase ka, ‘Bu u si ni u ni.’ Na wɔ kaaki ase ka, ‘Sɔnɔ kɛrɛ bo i jɔjɔɔri i si, ni i ni jɔrɛ tiɛ, wɔ yo daka ka bu kun i mi.’ ");
INSERT INTO cko_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ama, ambɛrɛ kere ka nzɛn sɔnɔ be la deke be bo i ti ye ni ka i fa buka i si ni i ni, i koro se bu ka ‘I ti Koroban wɔ.’ I bu la ka, ‘Deke bo má m fa ma am ni, ma fa ayi saraka ama Nyɛmɛ.’ ");
INSERT INTO cko_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Nyini saŋga ni, am akere ka i mi n koro buka má i si n ni i ni n lɛɛ. ");
INSERT INTO cko_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Nyini n kere ka am abu Nyɛmɛ dɛɛ nɔaniɛ n ŋgbɛɛn lɛɛ, ye am su am dɛɛ sa­yoo­wam n bo am kere bu n su a. Na am la ahin sa­yoo­wam dɔŋgu bo am kaaki yo bu sɔ ɔ.” ");
INSERT INTO cko_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Na Yesu akaaki afere jama n aba i bi bekun, na wɔ se bu ka, “Am kɛrɛ so am sui na am ti jɔrɛ n bo m sujɔjɔ ma am n bu. ");
INSERT INTO cko_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Deke bo i wura sɔnɔ nɔɔ nu koro yo má i mi fin, ama, deke bo i fite i mi ahore su yo i mi fin a.  ");
INSERT INTO cko_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Bo i koro ka i ti ahin jɔrɛ n bu, i ti ye ni ka i so i sui na i ti.” ");
INSERT INTO cko_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Saŋga bo Yesu ba cinsi yakiiri jama n na i wuraari awuru n nu ni, na i susu­fɔm n abisa i nyini anyundɛrɛ n bu. ");
INSERT INTO cko_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Na wɔ se bu ka, “Ŋka ambɛrɛ gusu ati má jɔrɛ n bu lɛɛ? Ambɛrɛ si má ka deke bo i wura sɔnɔ nɔɔ nu koro yo má i fin, ");
INSERT INTO cko_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","dama deke bo sɔnɔ di, i wura má i ahore su se i wura i kunnu wɔ, na i kaaki je yi i, má sɔ?” Yesu afa ahin jɔjɔɔ­wa n akere ka diire be la má ciire. ");
INSERT INTO cko_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Na wɔ kaaki ase bu ka, “Deke bo i fite sɔnɔ ahore su, nyini yo i fin a. ");
INSERT INTO cko_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Dama deke bo i wo i ahore su ma i sunsunni tiɛ a. I koro ma i nati suyo sakaraya, na i suwɔ, na i sukun minɛ, ");
INSERT INTO cko_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","na i susaaki ajaa ciire, na i nyunu suboro neŋge kpini su, na i suyo satiɛtiɛm, na i sudadaka minɛm, na i suyo sa ŋgbɛɛn­ŋgbɛɛn bo i cɛcɛ wo má nu, na i susi kɔrɛ, na i nati susaaki minɛm duma, na i la karambani, na i nati suyo sinnzinya sam. ");
INSERT INTO cko_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Nyini satiɛ n kɛrɛ mmɔɔ nya fite sɔnɔ ahore su, nyini ma i mi kaaki fin­di­fɔ a.” ");
INSERT INTO cko_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Na Yesu ayasu akɔ awɔrɛ n bo i wo dodo Tiro ni Sidon miɛ kpirim ni, na wɔ kɔ awura awuru be nu bɛnlɛ ka má sɔnɔ be ŋu i. Ama, wɔ koro afiɛ má i ŋu. ");
INSERT INTO cko_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Na bara be ati i ŋga na wɔ ba ndende aba akutu i jaa bu. Ajini wo i wa baa­bara ŋu. ");
INSERT INTO cko_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Bara n ti má Yuda­fɔ, i ti Fonisiya­fɔ ɔ, bo i fite Siriya awɔrɛ n nu wɔ. Na wɔ sere Yesu jande ka i fɔn yi ajini n bo i wo i wa n ŋu ni. ");
INSERT INTO cko_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Na Yesu ase i ka, “Ma nbaatumam n du mɔ di na bu kunnu yi ka, dama i ti má ye ni ka a fa nbaatumam diire na a fa ma caam.” ");
INSERT INTO cko_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ama, na bara n ase i ka, “M Mibiɛ, a la nahɔrɛ, ama, haari ni nyini mmɔɔ, caam n tambu nbaatumam n diire n bo bu di na i tɔtɔ asiɛŋgu n na bu fa di.” ");
INSERT INTO cko_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Na Yesu ase i ka, “U nɔaniɛ jɔjɔɔ­wa n dɛɛ ti, kɔ awuru. Ajini n afite ayaki u wa ni.” ");
INSERT INTO cko_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Na wɔ kɔ awuru akɔ aŋu ka i wa n da i dasu su, ajini n afite ayaki i. ");
INSERT INTO cko_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Na Yesu ayasu Tiro awɔrɛ n nu akɔ aju Sidon miɛ kpiri n nu, na wɔ fa bɛrɛ asin Miɛ Burum dɛɛ awɔrɛ n nu, aba aju Galili kunma kpiri n nɔɔ su. ");
INSERT INTO cko_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Na minɛ nbem afa sɔnɔ be aba Yesu dɔ, i ti asuturi wɔ, na i koro jɔjɔ má nyunyumi. Na ba sere Yesu jande ka i fa i saa nana i ŋu na i nya laifiɛ. ");
INSERT INTO cko_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Na Yesu afa sɔnɔ n afite jama n nu, i ni yiri ŋgumi, na wɔ fa i saa marakam awura i suim nu, na wɔ yi nanzue agɔ i saa su afa akan sɔnɔ n taferema, ");
INSERT INTO cko_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","na Yesu ayɛ i tii su aniɛ aŋgoro na wɔ ŋuundi, na wɔ se sɔnɔ n ka, “Efata.” Nyini la ka, “Teke.” ");
INSERT INTO cko_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Jina n nu bɛrɛ, na sɔnɔ n sui n ateke, na i taferema n gusu akaaki anyaŋgi nu, na wɔ koro ajɔjɔ nyunyumi. ");
INSERT INTO cko_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Na Yesu abɔbɔ bu ka má bu ma be ti ka wɔ tuntun sɔnɔ ni, ama, kabo i bɔbɔɔri bu barasu ni, bu boori ndoori n gusu sɔ ɔ bara yɛɛri a. ");
INSERT INTO cko_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Na minɛ ayo alekutura haari akɔ asin su, bu ŋa, “I sa­yoo­wa kɛrɛ kaba ti kpa a. I ma asuturim ti asui wɔ, na bobom jɔjɔ.” ");
INSERT INTO cko_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Nyini saŋga n na jama beberebe aba atiɛn bu nɔɔ Yesu dɔ bekun, bu la má deke bo bu di, na wɔ fere i susu­fɔm ni, na wɔ se bu ka, ");
INSERT INTO cko_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ahin jama n la m aŋunfɔ, dama i nyuma le­san lɛɛ bo bu wo m dɔ na bu la má deke bo bu di. ");
INSERT INTO cko_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","M koro yaki má bu na bu kɔ awuru ni ahɔɛ, má nyini, bu tɔ́ cin atin nu wɔ, dama bu nbem fite dede.” ");
INSERT INTO cko_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Na i susu­fɔm n ase i ka, “Ye nifansu ye ya koro nya diire ahin boro n nu fɛn ma ahin minɛm n kɛrɛ na bu kunnu yi a?” ");
INSERT INTO cko_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Na wɔ bisa bu ka, “Am la kpɔnɔ nyɛ wɔ?” Na ba bɔ i nu ka, “Nso.” ");
INSERT INTO cko_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Na wɔ ma jamam n nɔɔ ka bu tana asiɛŋgu, na wɔ fa kpɔnɔ nso n na wɔ da Nyɛmɛ asi. Na wɔ kpiɛkpiɛ i nu ama i susu­fɔm n ka bu fa ma jama ni. Na bɛrɛ gusu afa akpakpaaki bu nu. ");
INSERT INTO cko_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Bu la jombaa kan kan nbem gusu, na wɔ fa ada Nyɛmɛ asi, na wɔ fa ama i susu­fɔm n ka bu fa nyini n gusu ma jama ni. ");
INSERT INTO cko_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Bu diiri na bu kunnu ayi. Na i susu­fɔm n atambu sinsin kaa­wa n kandiɛ nso. ");
INSERT INTO cko_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Jama ni ju akpii nna dika. Na Yesu anya akaari bu na ba kɔ awuru. ");
INSERT INTO cko_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Na i ni i susu­fɔm n awura lee akɔ Damanuta dɛɛ awɔrɛ n nu. ");
INSERT INTO cko_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Na Farasi­fɔ nbem aba i dɔ, na ba se akuruwa ni Yesu. Bu koroori ka i yo alekutura sa be bo i kere ka i yiko n fite Nyɛmɛ dɔ ɔ, adena bu nya i ŋgɛɛ sɔɔ­biri. ");
INSERT INTO cko_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Na wɔ ŋuundi ni dimi i ahore su, na wɔ se ka, “Nzu ti ye ambɛrɛ nyuma­fɔm koro ka m yo alekutura sa na am ŋu i a? M suse am nahɔrɛ wɔ lɛɛ ka, m yó má alekutura sa ma má ambɛrɛ nyuma­fɔm fuu.” ");
INSERT INTO cko_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Na wɔ yasu ayaki bu, na wɔ wura lee n nu akpiɛ akɔ kunma n buekun dɔ. ");
INSERT INTO cko_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Na i susu­fɔm n wara afi diire sa, ba bita má pui, má ka kpɔnɔ kun n kpein woori lee n nu a. ");
INSERT INTO cko_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Na Yesu atu bu fɔ, i ŋa, “Am si am ŋu sa ni Farasi­fɔm, ni Fɛmɛ Herode dɛɛ kpɔnɔ ayiri n bo bu fa gɔ kpɔnɔ n nu na i yasu ni.” ");
INSERT INTO cko_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Na ba jɔjɔ bu ŋuŋu nu ka, “Ya la má kpɔnɔ n ti, ye i su se sɔ n a.” ");
INSERT INTO cko_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Na Yesu afa nu kabo i susu­fɔm n sujɔjɔ bu ŋuŋu nu ni, na wɔ bisa bu ka, “Nzu ti ye am sujɔjɔ ka am bita má kpɔnɔ a? Am nya si má deke bo m sujɔjɔ i ni, am nya ti má sa n bu? Am ahore­mbaa ti kekereke wanla. ");
INSERT INTO cko_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","I baari sɛ ye am la anyumbaa na am ŋu má asi a? Ye am la asui na am ti má? Am teŋge má su ka ");
INSERT INTO cko_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","m yo faari kpɔnɔ nnu kpiɛkpiɛ maari minɛ akpii nnu? Ye bo i kaari ni, kandiɛ nyɛ ye am sasaari a?” Na ba bɔ i nu ka, “Kandiɛ buru ni nnyɔ.” ");
INSERT INTO cko_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Na Yesu akaaki abisa bu bekun ka, “Ye kpɔnɔ nso n bo m yo fa kpiɛkpiɛ maari minɛ akpii nna n di? Sinsin kandiɛ nyɛ ye am sasaari a?” Na ba bɔ i nu ka, “Kandiɛ nso.” ");
INSERT INTO cko_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Na wɔ se bu ka, “Haari ni kisa, am nya ti má i bu?” ");
INSERT INTO cko_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Bu kɔ juuri Besayida miɛ n nu, na minɛ nbem afa anyinsin be aba Yesu dɔ, na ba sere i jande ka i fa i saa nana i ŋu na i nya laifiɛ. ");
INSERT INTO cko_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Na wɔ so sɔnɔ n saa nu afa i afite miɛ n nu, na wɔ yi nanzue agɔ i nyu­mbaa n nu. Na wɔ fa i saa anana i ŋu, na wɔ bisa i ka, “A niɛ, a ŋu deke be e?” ");
INSERT INTO cko_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Na anyinsin n ayɛ i tii su aniɛ, na wɔ se Yesu ka, “M ŋu minɛm ka bu nati, ama, bu ti ka bakam wɔ.” ");
INSERT INTO cko_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Na Yesu akaaki afa i saa anana i nyu­mbaa n su bekun, na anyinsin n aniɛ gbirim, na wɔ ŋu ka i nyu­mbaam n ateke, na wɔ ŋu deke kɛrɛ casi. ");
INSERT INTO cko_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Na Yesu ase i ka, “To atin nu kɔ awuru, na má a se ka a fa miɛ n nu.” ");
INSERT INTO cko_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Na Yesu ni i susu­fɔm n ayasu ka bu kɔ Sizariya Filipu miɛ kan kanm su. Bu wo natiiri su ni, na wɔ bisa i susu­fɔm n ka, “Minɛm fa m bu ŋma a?” ");
INSERT INTO cko_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Na ba bɔ i nu ka, “Bu ŋa wɔrɔ ti Yohane Nyɛmɛ Nzue Biɛ­fɔ n a, nbem ŋa wɔrɔ ti Nyɛmɛ nɔaniɛ kan­fɔ Eliya a, ye nbem gusu ŋa a ti dawa dɛɛ Nyɛmɛ nɔaniɛ kan­fɔ nyiŋgam n kun wɔ.” ");
INSERT INTO cko_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Na wɔ bisa bu bekun ka, “Ye ambɛrɛ fa m bu ŋma a?” Na Petoro abɔ i nu ka, “Wɔrɔ ti Kristo n a, Tii­de­fɔ n bo Nyɛmɛ ase ka i súnma i ni.” ");
INSERT INTO cko_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Na Yesu abɔbɔ bu ka má bu ma be si ka yiri ti Kristo Tii­de­fɔ n a. ");
INSERT INTO cko_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Nyini sin na wɔ bo i bu sukere i susu­fɔm n ka, “Wɔ yo daka ka mini Adamande Wa n di wahara dɔŋgu, na Yuda­fɔm nkpiɛn­kpiɛnm, ni Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ nkpiɛn­kpiɛnm, ni Nyɛmɛ nɔaniɛ kere­fɔm kɛrɛ bá kete m ŋu na bu kún m. Ama, le­san cɛɛn sin na m téŋge m yiwee n nu.” ");
INSERT INTO cko_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Na wɔ kan sa n kɛrɛ bu kpain akere bu. Na Petoro afa i akɔ ahɛmɛ, na wɔ jaraki i ase i ka, “Má a se ka a kan nyini jɔrɛ ni.” ");
INSERT INTO cko_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ama, na Yesu acɛ aniɛ i susu­fɔm ni, na wɔ tiɛn Petoro ŋu ase i ka, “Sitana, fa cinsi m bi bɛrɛ. A sunsun má kabo Nyɛmɛ koro ni. A sunsun kabo adamande koro n wɔ.” ");
INSERT INTO cko_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Na Yesu afere jama n ni i susu­fɔm n na wɔ se bu ka, “Sɔnɔ kɛrɛ bo i koro ka i su m su, wɔ yo daka ka i mi wara fi i tiɛŋgu sa koroo­wa sa, na i fa i yiwee baka jaanu n sɔ, na i su m su. ");
INSERT INTO cko_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Dama sɔnɔ kɛrɛ bo i koro ka i fa i ŋgɔɔ fiɛ, i mi bá fun i. Ama, sɔnɔ kɛrɛ bo i tɔɔri i ŋgɔɔ mini ni m dɛɛ labari kpa n dɛɛ ti, i mi nyá ŋgɔɔ. ");
INSERT INTO cko_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Nzɛn sɔnɔ nyaari durunya n nu deke n kɛrɛ na i fuunri i ŋgɔɔ, i kpɛrɛ la bɔnɔ? ");
INSERT INTO cko_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Nzu deke ye sɔnɔ koro fa kaaki i ŋgɔɔ a? ");
INSERT INTO cko_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Nyuma­fɔm ti satiɛ­yo­fɔm wɔ, bo bu su má Nyɛmɛ. Ambɛrɛ bo am wo bu nu, na nyinsɛ ti am fa kɔ mini ni m nɔaniɛ n dɛɛ ti ni, sɔ ye nyinsɛ tí mini Adamande Wa n gusu fa kɔ am su, saŋga bo m bá ba ni m Si Nyɛmɛ jirima woo­wa n nu, ni i mɛrɛkɛ casim ni.” ");
INSERT INTO cko_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Na wɔ se bu ka, “Nahɔrɛ ye m suse am n a, am nbem wo nu fɛn bo am wú má, má ka am aba aŋu ka Nyɛmɛ fɛmɛya n aba ni yiko.” ");
INSERT INTO cko_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Le­sɛn cɛɛn sin na Yesu afa Petoro ni Yakobo ni Yohane afun buka lenleŋge be su, bu ni yiri ŋgumi. Bu wo dɔ n na ba ŋu ka i ŋuniɛ akaaki wo, ");
INSERT INTO cko_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","na i tanlɛɛ n akaaki fofoe papasi bo i ŋusu nya má durunya n nu. ");
INSERT INTO cko_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Dɔ na minɛ nnyɔ nbem atiɛ bu ŋu, na bu ni Yesu subo anzama. Bɛrɛ la Eliya ni Moyisi, dawa dɛɛ Nyɛmɛ nɔaniɛ kan­fɔm ni. ");
INSERT INTO cko_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Na sɛrɛ ati Petoro ni susu­fɔ nyiŋgam ni, na Petoro ajimi agaya na i nɔɔ afinfin i. Nyini ti na wɔ se Yesu ka, “Ya Kere­fɔ, i ti kpa ka ya wo fɛn. Ma ya bo nambue nsan, u dɛɛ kun, Moyisi dɛɛ kun, na Eliya gusu dɛɛ kun.” ");
INSERT INTO cko_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Na yinyiŋgu akata bu ŋu, na ba ti akonvi be ŋga yinyiŋgu n nu, na wɔ jɔjɔ bu dɔ. I ŋa, “M wa koroo­wa lɛɛ. Am de i nɔaniɛ.” ");
INSERT INTO cko_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Bu tiiri jɔjɔɔ­wa n sɔ ni, kpeŋga na ba niɛniɛ abara ayɛ, ama, ba ŋu má sɔnɔ be kun, má ka Yesu ŋgumi wo bu dɔ a. ");
INSERT INTO cko_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Na saŋga bo bu ba sujura buka n su ni, na Yesu abɔbɔ bu ka, “Má am be se ka i bo sa n bo am aŋu i n su fa kere sɔnɔ be, haari fa kɔ saŋga bo mini Adamande Wa ni bá wu na m téŋge m yiwee n nu ka.” ");
INSERT INTO cko_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Na ba de i nɔaniɛ ni, ama, na ba bakati abisa bu ŋuŋu nu ka, “Ye nzu la ka, i bá wu na i téŋge i yiwee n nu a?” ");
INSERT INTO cko_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Na ba bisa Yesu ka, “Ye nzu ti ye Nyɛmɛ nɔaniɛ kere­fɔm n bita jɔjɔ ka Eliya dú mɔ ba ka, ye Kristo Tii­de­fɔ ni bá ba n a?” ");
INSERT INTO cko_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Na wɔ bɔ bu nu ka, “I ti nahɔrɛ wɔ ka Eliya dú mɔ ba na i bá sɛsɛ deke n kɛrɛ su. Bu kɛrɛɛri sɛ Nyɛmɛ Jɔrɛ Kadasi n nu fa kɔ Adamande Wa n dɔ a? Ba kɛrɛ ka i bá di wahara agaya, na minɛ bú i ŋgbɛɛn. ");
INSERT INTO cko_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ama, m suse am wɔ lɛɛ, ka, Eliya adu mɔ aba, na minɛm ayo i kabo bu koro, kabo ba kɛrɛ i Nyɛmɛ Jɔrɛ Kadasi n nu lɛɛ.” ");
INSERT INTO cko_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Saŋga bo Yesu ni i susu­fɔ nsanm ni kpieeri bu nyi ba juuri i susu­fɔ nyiŋgam bi ni, na ba ŋu ka jama beberebe atiɛn bu nɔɔ abara ayɛ bu. Ye Nyɛmɛ nɔaniɛ kere­fɔm n nbem bita bu ni akuruwa. ");
INSERT INTO cko_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Jama n ŋuuri Yesu sɔ ni, na ba yo alekutura, na ba bo nu aŋmati akpa i atin ayo i ansɛ. ");
INSERT INTO cko_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Na wɔ bisa bu ka, “Am se nzu akuruwa a?” ");
INSERT INTO cko_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Sɔnɔ be woori jama n nu na wɔ bɔ i nu ka, “Ya Kere­fɔ, ma fa m wa baa­biɛsɔ aba u dɔ ka a tuntun i ma m, dama ajini bobom wo i ŋu. ");
INSERT INTO cko_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Saŋga kɛrɛ bo ajini n anya aba afa i, a ŋu ka wɔ fa i abo asiɛŋgu, na i nanzue sufite fufuku, na i sukpɛsɛ i jee, na i kese i ŋu. Ma sere u susu­fɔm n ka bu fɔn yi ajini ni, ama, ba kura má nu.” ");
INSERT INTO cko_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Na Yesu ase bu ka, “Amaa. Ambɛrɛ nyuma­fɔm, am la má yarada fieo. Nyuma sa ye m wo am dɔ fɛn a? Ye m yó sawɔrɛ ni ambɛrɛ kɔ ju sɛ wɔ? Am fa baa n ba ma m.” ");
INSERT INTO cko_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Na ba fa baa ni aba i dɔ, na saŋga bo ajini n ŋuuri Yesu ni, kpeŋga na wɔ kpisi baa ni, na wɔ fa i abo asiɛŋgu, na wɔ da sukundu, na nanzue fufuku sufite i nɔɔ nu. ");
INSERT INTO cko_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Na Yesu abisa i si n ka, “Saŋga bɔnɔ ye tukpaki n taraari i a?” Na si n abɔ i nu ka, “I kaan nu kɛrɛ a. ");
INSERT INTO cko_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Saŋga kɛrɛ bo i nya ba yasu i ŋu, i fa i wura sin nu wɔ, wara nzue nu ka i kun i. Nyini ti, nzɛn a koro buka ya, si ya aŋunfɔ na a buka ya.” ");
INSERT INTO cko_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Na Yesu ase i ka, “Nzu ti ye a ŋa nzɛn m koro buka u a? Deke be ti má kekereke ma má minɛm bo bu yo Nyɛmɛ yarada ni.” ");
INSERT INTO cko_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Kpeŋga na baa n si asa Yesu nɔɔ su ka, “Ma yo yarada, ama, i sunnu má. Buka m na i sunnu.” ");
INSERT INTO cko_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Na Yesu aŋu ka jama n suŋmati ba i dɔ, na wɔ tiɛn ajini n ŋu, i ŋa, “Wɔrɔ ajini n bo a ma baa n ayo bobo ni asuturi ni, mini suse u ka a fite yaki i a, na má a kpie u nyi ba i dɔ kun.” ");
INSERT INTO cko_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Kpeŋga na wɔ ciindi na wɔ kpisi baa n agaya, na wɔ fite ayaki i, na baa n aka ada ka wɔ wu dɛɛ su. Na minɛm n dɔŋgu ase ka wɔ wu wɔ. ");
INSERT INTO cko_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ama, na Yesu atara i saa ayɛ i su, na wɔ jina. ");
INSERT INTO cko_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yesu ba wuraari awuru n nu ni, na i susu­fɔm n aba i dɔ, bɛrɛ ŋgumi, abisa i ka, “Nzu ti ye yɛrɛ akoro afɔn má nyini ajini n a?” ");
INSERT INTO cko_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Na wɔ bɔ bu nu ka, “Be koro fɔn má nyini ajini n ŋusu sɔ, má ka nyɛmɛsere.” ");
INSERT INTO cko_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Na Yesu ni i susu­fɔm n ayasu bɛrɛ akɔ asin Galili awɔrɛ n nu. Wɔ koro má ka be si i woo­biri, ");
INSERT INTO cko_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","dama i sukere i susu­fɔm wɔ. Na wɔ se bu ka, “Bu bá tɔ mini Adamande Wa n ma minɛ nbem na bu kún m, ama, bu kuunri m wieeri, i le­san cɛɛn sin, na m téŋge m yiwee n nu.” ");
INSERT INTO cko_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","I jɔjɔɔri sɔ ni, i susu­fɔm n ati má i bu, ama, sɛrɛ dɛɛ ti, ba koro abisa má i jɔrɛ be. ");
INSERT INTO cko_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Na ba kɔ aju Kapɛnam miɛ kpiri n nu, na saŋga bo bu wo awuru n nu ni, na Yesu abisa i susu­fɔm n ka, “Am wo atin n nu suba ni, am se nzu akuruwa a?” ");
INSERT INTO cko_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ama, na bu kɛrɛ atɔ amuna, dama bu wo atin n nu dɔ ni, na ba se akuruwa bu ŋuŋu nu fa kɔ sɔnɔ bo i tara bu kɛrɛ bu nu. ");
INSERT INTO cko_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Na wɔ tana, na wɔ fere bɛrɛ i susu­fɔ buru ni nnyɔm ni, na wɔ se bu ka, “Sɔnɔ kɛrɛ bo i koro ka i kaaki mɔ­fɔ, wɔ yo daka ka i mi yo i ŋu kaan tara am kɛrɛ na i kaaki yo am kɛrɛ dɛɛ amusui­su­fɔ.” ");
INSERT INTO cko_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Na wɔ fa baa kaan be aba ajina bu afiɛn, na wɔ biti i, na wɔ se bu ka, ");
INSERT INTO cko_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Wɔrɔ kɛrɛ bo ade ahin baa­kan n ŋusu m dɛɛ ti, a deeri mini wɔ lɛɛ. Bekun, wɔrɔ kɛrɛ gusu bo a nya deeri mini, a de m Si Nyɛmɛ bo i sunmaari m wɔ lɛɛ.” ");
INSERT INTO cko_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Na Yohane ase i ka, “Ya Kere­fɔ, ya ŋuuri ka sɔnɔ be afa u duma sufa fɔn yi ajinim fite minɛm ŋu, ye ya ŋa ya yaki má i, dama i wo má ya nu n dɛɛ ti.” ");
INSERT INTO cko_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Na Yesu ase ka, “Má am se ka am kanda i, dama sɔnɔ kɛrɛ bo i nya sufa m duma n yo alekutura sam, i mi bá koro kaaki jɔjɔ má jɔrɛ tiɛ fa kɔ m dɔ. ");
INSERT INTO cko_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Dama sɔnɔ kɛrɛ bo i fite má ya sin, i mi jina ya sin wɔ lɛɛ. ");
INSERT INTO cko_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","M suse am nahɔrɛ wɔ lɛɛ, ka sɔnɔ kɛrɛ bo i maari am nzue ka am nu dama am su mini dɛɛ ti, i mi nyá i ŋkatɔ.” ");
INSERT INTO cko_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Na Yesu akaaki ase bu ka, “Wɔrɔ kɛrɛ bo u sa­yoo­wa ma ahin nbaatuma kan kanm n be bo i yo m yarada n be wuraari satiɛ nu, i ti má kpa. Nzɛn má bu faari ŋgani san yabuɛ bambaka ciciiri u kɔm, na bu fa u kɔ tu tieku nu, i ti ye tara bo a ma ahin nbaatuma kan kanm n be wura satiɛ nu ni. ");
INSERT INTO cko_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Nzɛn u saa n be cin u wura satiɛ nu a, kaba kpiɛ i na a ka asaasin, na a nyá u ŋu kɔ Nyɛmɛ dɔ. I ti ye ni bo a la u saa nnyɔ n kɛrɛ na a wura cɛɛma sin n bo i nɔ má n nu. ");
INSERT INTO cko_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Nzɛn u jaa n be cin u wura satiɛ nu a, kaba kpiɛ i na a ka ajaasin, na a nyá u ŋu kɔ Nyɛmɛ dɔ. I ti ye ni bo a la u jaa nnyɔ n kɛrɛ na bu ba fa u tu cɛɛma sin nu. ");
INSERT INTO cko_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Nzɛn u nyu­mbaa kun gusu cin u wura satiɛ nu a, lokoti yi i tu, na a ka anyunu kun, na a wúra Nyɛmɛ fɛmɛya n nu. I ti ye ni bo a la u nyu­mbaa n nnyɔ n kɛrɛ na bu ba fa u tu cɛɛma sin nu. ");
INSERT INTO cko_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Dɔ dɛɛ kakabam ni bo bu wura minɛ bo ba wu ni, bɛrɛ wu má cɛɛn be, na sin n gusu bo i je nɔ má. ");
INSERT INTO cko_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Kabo bu fa njin nyina saraka neŋge kɛrɛ su fa ma Nyɛmɛ, na i yo casi barasu ni, sɔ ye Nyɛmɛ cín sɔnɔ kɛrɛ sui na i yó casi. ");
INSERT INTO cko_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ya si ka njin yo fiɛ, ama, nzɛn i fiɛfiɛ nya ba saari wieeri, i koro yo má fiɛfiɛ kun. Am ma am wo yo fiɛ ka njin am beŋgu nu, na am wo ni tanalaifiɛ.” ");
INSERT INTO cko_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu yasuuri Kapɛnam miɛ kpiri n nu, na wɔ kɔ Yudiya dɛɛ awɔrɛ n nu, na wɔ kpiɛ akɔ Yodan kunma n buekun dɔ fan, na jama beberebe ayandi aba atiɛn bu nɔɔ i dɔ. Na wɔ kere bu kabo saŋga kɛrɛ na i kere bu barasu ni. ");
INSERT INTO cko_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Na Farasi­fɔ nbem aba i dɔ ka bu sɔ i ŋgɛɛ fa kɔ i nɔaniɛ n jɔjɔɔ­wa su, na ba bisa i ka, “Ya dɛɛ atin n su, atin wo nu ka sɔnɔ koro fa i yi ji i?” ");
INSERT INTO cko_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Na Yesu abɔ bu nu ka, “Nɔaniɛ maa­wa bɔnɔ ye Moyisi yo fa maari am a?” ");
INSERT INTO cko_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Na ba bɔ i nu ka, “Moyisi yo maari atin ka nzɛn sɔnɔ koro ka i fa i yi ji, i ti ye ni ka i mi ma bara n ajaa yaki kadasi ka, na i nya fa i ji.” ");
INSERT INTO cko_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Na Yesu ase bu ka, “Am ahore­mbaa kekereke n dɛɛ ti ye Moyisi yo kɛrɛɛri nyini nɔaniɛ maa­wa n maari am a. ");
INSERT INTO cko_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ba kɛrɛ i Nyɛmɛ Jɔrɛ Kadasi n nu ka fite durunya n bumboori, ‘Nyɛmɛ yiiri biɛsɔ ni bara a.’ ");
INSERT INTO cko_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Na wɔ se ka, ‘Nyini dɛɛ ti, i ti ye ni ka biɛsɔ n kpaaki i gisan yaki i si ni i ni, na i ni i yi saŋga wo. ");
INSERT INTO cko_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Nyini saŋga bu minɛ nnyɔ n ayo deke kun lɛɛ.’ Bu wo má bu ŋguŋgumi kun. ");
INSERT INTO cko_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Nyini ti, deke bo Nyɛmɛ anya asaŋga i awie, má sɔnɔ kpaaki i nu kun.” ");
INSERT INTO cko_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Saŋga bo Yesu ni i susu­fɔm ba juuri awuru ni, na ba bisa i nyini nɔaniɛ n bu. ");
INSERT INTO cko_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Na wɔ se bu ka, “Sɔnɔ kɛrɛ bo i faari i yi jiiri, na i jaari bara fɔfɔrɛ, i mi n asaaki ajaa ciire ni i yi n bo wɔ fa i aji n lɛɛ. ");
INSERT INTO cko_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Sasu bekun, bara kɛrɛ bo i yakiiri i hun ajaa, na i kɔ jaari biɛsɔ fɔfɔrɛ, nyini bara n gusu asaaki ajaa ciire lɛɛ.” ");
INSERT INTO cko_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Minɛm sufa bu nbaam ba Yesu dɔ ka i fa i saa nana bu ŋu na i yo bu kisi, ama, na i susu­fɔm n atiɛn bu ŋu. ");
INSERT INTO cko_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesu ŋuuri i susu­fɔm sa­yoo­wa n sɔ ni, na yaa ati i, na wɔ se bu ka, “Am ma nbaatumam n bra m dɔ, má am fɔn bu. Dama bɛrɛ ŋusu sɔ ye Nyɛmɛ fɛmɛya n ti bu dɛɛ a. ");
INSERT INTO cko_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nahɔrɛ ye m suse am n a, wɔrɔ kɛrɛ bo a de má Nyɛmɛ fɛmɛya n nu jɔrɛ kabo baatuma de deke i saa nnyɔ ni, a wúra má Nyɛmɛ fɛmɛya n nu.” ");
INSERT INTO cko_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Na wɔ kuku nbaatumam ni i saa nu, na wɔ fa i saa anana bu ŋu, na wɔ yo bu kisi. ");
INSERT INTO cko_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Nyini sin na Yesu ayasu dɔ sukɔ. I wo kɔ n su ni, na sɔnɔ be aŋmati aba akutu i nyunu, na wɔ bisa i ka, “Ya Kere­fɔ sɔnɔ kpa, m yó sɛ ye m bá nya ŋgɔɔ n bo i la má awieeri n a?” ");
INSERT INTO cko_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Na Yesu abɔ i nu ka, “Nzu ti ye a fere m ka sɔnɔ kpa a? Be ti má kpa sin Nyɛmɛ ŋu. ");
INSERT INTO cko_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ye m ŋa a si Nyɛmɛ nɔaniɛ maa­wam ni e, bu ŋa, ‘Má a kun sɔnɔ. Má a saaki ajaa ciire. Má a wɔ. Má a di kɔrɛ daani. Má a sisi sɔnɔ. Bu u si ni u ni.’” ");
INSERT INTO cko_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Na sɔnɔ n abɔ i nu ka, “Ya Kere­fɔ, ma su nyini nɔaniɛ maa­wa n kɛrɛ su haari m kaan nu.” ");
INSERT INTO cko_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Na Yesu aniɛ sɔnɔ n na wɔ koro i agaya, na wɔ se i ka, “Deke kun ye wɔ kpiɛ u su a. Kɔ na a kɔ tɔ u aja kɛrɛ, na a fa ŋwaa n ma yaari­fɔm, na a bá nya ajɛkɛ Nyɛmɛ dɔ, na a bra ba su m su.” ");
INSERT INTO cko_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Yesu seeri i sɔ n na i ŋuniɛ ayɔrɔki i. Na wɔ kɔ awuru ni ahoresaaki, dama i la neŋge agaya n dɛɛ ti. ");
INSERT INTO cko_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Na Yesu aniɛ i susu­fɔm n abara ayɛ, na wɔ se bu ka, “I yó kekereke bo neŋge­fɔ wura Nyɛmɛ fɛmɛya n nu.” ");
INSERT INTO cko_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Na i susu­fɔm n ayo alekutura ni nyini jɔjɔɔ­wa ni. Ama, na Yesu ase bu bekun ka, “Njam, i ti kekereke ka neŋge­fɔm wura Nyɛmɛ fɛmɛya n nu. ");
INSERT INTO cko_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kabo nyɔɔma sin misini bue nu ni, i ti má kekereke tara má kabo neŋge­fɔ yo na i wura Nyɛmɛ fɛmɛya n nu ni.” ");
INSERT INTO cko_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Na i susu­fɔm n amiɛ akɔ asin su, na ba bisa bu ŋuŋu nu ka, “Ye nzɛn i ti sɔ e, ŋma koro fite nu a?” ");
INSERT INTO cko_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Na Yesu aniɛ bu dɔ na wɔ se ka, “I ti deke bo adamande koro yo má i, ama, Nyɛmɛ dɔ, i ti má pui, dama Nyɛmɛ koro yo deke kɛrɛ.” ");
INSERT INTO cko_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Na Petoro ase i ka, “Tɔ, ye yɛrɛ ayaki deke kɛrɛ susu u su e.” ");
INSERT INTO cko_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Na Yesu ase ka, “Nahɔrɛ ye m suse am n a, sɔnɔ kɛrɛ bo i yakiiri i awuru, wara i ninbaam, wara i ni, wara i si, wara i nbaam, wara i asiɛn, mini ni m labari kpa n dɛɛ ti, ");
INSERT INTO cko_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","i mi nyá nyinim sɔ ŋusu yaa i ŋgɔɔ su. I nyá awurum, ni ninbaam, ni nim, ni nbaam, ni asiɛnm, na minɛm má i di wahara, na fa kɔ fa ba i nyá ŋgɔɔ bo i la má awieeri. ");
INSERT INTO cko_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ama, minɛ dɔŋgu bo bu wo mɔ kisa ni bá ka sin, na bo bu ka sin kisa n bá du mɔ.” ");
INSERT INTO cko_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Saŋga bo Yesu ni i susu­fɔm sukɔ Yɛrusalem miɛ kpiri n nu ni, na Yesu adu bu mɔ sunati, na i susu­fɔm n ajimi, na sɛrɛ ati minɛm bo bu suuri i su ni, na wɔ kaaki afere i susu­fɔ buru ni nnyɔm n akɔ ahɛmɛ, na wɔ jɔjɔ bu dɔ bekun fa kɔ sa n bo i bá tu i ni. ");
INSERT INTO cko_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","I ŋa, “Am ti fɛn. Ya sukɔ Yɛrusalem lɛɛ, dɔ ye bu kɔ́ tara mini Adamande Wa n a, na bu fá m ma Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ nkpiɛn­kpiɛnm ni, ni Nyɛmɛ nɔaniɛ kere­fɔm ni, na bu dí m jɔrɛ, na bu sóro su ka bu kún m. Na bɛrɛ gusu nyá fa m wura minɛm bo bu ti má Yuda­fɔm saa nu, ");
INSERT INTO cko_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","na bu yó m anzasi, na bu yí nanzue gɔ m ŋu, na bu fín m ŋgbere, na bu nyá kun m, na i le­san cɛɛn sin, na m téŋge m yiwee n nu.” ");
INSERT INTO cko_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Na Zɛbɛdi nbaam Yakobo ni Yohane aba Yesu dɔ aba ase i ka, “Ya Kere­fɔ, ya koro ka deke kɛrɛ bo ya sere u, a yo i ma ya.” ");
INSERT INTO cko_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Na wɔ bisa bu ka, “Am koro ka m yo nzu ma am a?” ");
INSERT INTO cko_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Na ba se i ka, “Saŋga bo a bá tana u jirima tanaa­biri ni, ya koro ka a ma ya kun tana u saa fɔmbɔrɔ su, na kun gusu tana u saa biɛ su.” ");
INSERT INTO cko_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Na Yesu ase bu ka, “Am si má deke n bo am susere i n ti a. Am kóro di wahara n bo m dí i ni, am káaki koro wu yiwee n bo m wú i ni, nzɛn sɛ?” ");
INSERT INTO cko_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Na ba bɔ i nu ka, “Ɛɛn, ya kóro yo i kɛrɛ.” Na Yesu ase bu ka, “Nahɔrɛ. Am dí wahara n bo m dí i ni, na am káaki wu yiwee n bo m wú i ni. ");
INSERT INTO cko_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ama, mini la má atin bo m má am be tana m fɔmbɔrɔ su, na be tana m biɛ su. Ama, Nyɛmɛ asɛsɛ nyini tanaa­biri n su, afa ase ama minɛm bo yiri ni i tii ayi bu n a.” ");
INSERT INTO cko_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Saŋga bo i susu­fɔ burum ni tiiri kabo Yakobo ni Yohane n seeri Yesu ni, na ba fa yaa bu ŋu. ");
INSERT INTO cko_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Na Yesu afere bu kɛrɛ aba i bi, na wɔ se bu ka, “Am si tenle su ka minɛm bo bu su má Nyɛmɛ n na bu yo bu ŋu nkpiɛn­kpiɛnm ni, bɛrɛ miɛ bu minɛm a, na bu tere­tere­fɔm gusu kere kabo bu yiko ti barasu. ");
INSERT INTO cko_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ama, wɔ ti má ye ni ka ambɛrɛ yo sɔ. Nzɛn sɔnɔ be koro ka i wura i ŋu kpiri am kɛrɛ nu, i ti ye ni ka i mi yo i ŋu kaan, na i su am. ");
INSERT INTO cko_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Na bo i kaaki koro ka i yo am mɔ­fɔ, i ti ye ni ka i mi yo am kɛrɛ akɔɔ. ");
INSERT INTO cko_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Dama mini Adamande Wa n ni m tii aba má ka minɛm su m wɔ, ama, m baari ka m ba su minɛm wɔ, na m wu ma bu, na m de minɛm dɔŋgu tii ji.” ");
INSERT INTO cko_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Na ba kɔ aju miɛ kpiri n bo bu fere i ka Yeriko ni. Saŋga bo Yesu ni i susu­fɔm, ni jama beberebe n sufite miɛ n nu ni, anyinsin be tana atin n nɔɔ wo sere su. Bu fere i ka Batimeyo, Timeyo dɛɛ wa. ");
INSERT INTO cko_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","I tiiri ka Yesu Nazarɛti­fɔ ni susin ni, na wɔ tiɛn afere i, i ŋa, “Yesu, Fɛmɛ Davidi anuma, si m aŋunfɔ.” ");
INSERT INTO cko_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Na jama n atiɛn i ŋu ka i yaki naŋmiɛ. Ama, na wɔ kaaki atiɛn kpa abuka su ka, “Fɛmɛ Davidi anuma, si m aŋunfɔ.” ");
INSERT INTO cko_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Na Yesu aka ajina, na wɔ se bu ka, “Am fere i ma m.” Na ba fere anyinsin ni, na ba se i ka, “Ma u ahore si na a yasu, i fere u.” ");
INSERT INTO cko_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Na wɔ fikindi i zaba n atu, na wɔ warakpin, na wɔ ŋmati akɔ Yesu dɔ. ");
INSERT INTO cko_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","I kɔ juuri dɔ n na Yesu abisa i ka, “A koro ka m yo nzu ma u a?” Na anyinsin n abɔ i nu ka, “Ya Kere­fɔ, m koro ka a ma m ŋu asi wɔ.” ");
INSERT INTO cko_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Na Yesu ase i ka, “Kɔ. Yarada n bo a yo m ni, nyini ma a nya laifiɛ a.” Kpeŋga na wɔ kaba aŋu asi, na wɔ su i su akɔ. ");
INSERT INTO cko_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Bu kɔ ŋa bu dodo Yɛrusalem miɛ kpiri n nu, na bu ŋa bu wura miɛm bo bu fere bu ka Befage ni Betani n ni, nyini miɛm n dodo buka n bo bu fere i ka Oliva Buka n wɔ, dama oliva bakam gɔ su wɔ. Dɔ na Yesu asunma i susu­fɔm n nu nnyɔ, ");
INSERT INTO cko_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","na wɔ se bu ka, “Am kɔ miɛ kaan n bo i wo am nyunu dɔ ni, am kɔ ŋa am wura miɛ n nu, am ŋú ka kaako­baa be minda, be nya fun má i. Am nyaŋgi i bra. ");
INSERT INTO cko_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Nzɛn be bisaari am ka nzu ti ye am sunyaŋgi i a, am se i ka am Mibiɛ ni koro i a, ama, i má am kaaki fa i kpie i nyi ba kisa kisa.” ");
INSERT INTO cko_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Na ba kɔ, na ba kɔ aŋu ka kaako­baa n minda anɔ be nu atiŋgbere n su, na ba nyaŋgi i. ");
INSERT INTO cko_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Na minɛ n bo bu jina dɔ n abisa bu ka, “Am suyo nzu lɛɛ, am sunyaŋgi kaako­baa n kɔ ni wɔ?” ");
INSERT INTO cko_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Na ba se minɛm n kabo Yesu seeri bu ni, na ba ma bu atin. ");
INSERT INTO cko_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Na ba fa kaako­baa n aba Yesu dɔ, na ba fa bu suturam anana kaako­baa n ŋu, na Yesu afun atana su. ");
INSERT INTO cko_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Na minɛ beberebe afa bu suturam atɛrɛki ase atin n nu, na nbem gusu abubu nyawa asese atin n nu. ");
INSERT INTO cko_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Na bo bu du i nyunu n ni bo bu wo i sin n kɛrɛ subo kuyigindi, bu ŋa, “Hosana. Ya kansi Nyɛmɛ. Tere­fiɛ wo yiri n bo i suba Micɛra n dɛɛ duma n nu n dɔ. ");
INSERT INTO cko_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Tere­fiɛ wo ya si Davidi fɛmɛya n bo i suba n dɔ. Ya kansi Nyɛmɛ bo i wo aŋgoro ni.” ");
INSERT INTO cko_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Na Yesu awura Yɛrusalem miɛ kpiri n nu, na wɔ kɔ Nyɛmɛ Seree­biri Awuru n nu. I kɔ juuri dɔ na wɔ niɛ abara ayɛ deke n kɛrɛ. Nyini saŋga wiɛ atɔ, nyini ti, na i ni i susu­fɔ buru ni nnyɔm n akpie bu nyi akɔ Betani. ");
INSERT INTO cko_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Na i alecin na ba yasu Betani miɛ n nu sukɔ, na ahɔɛ ati Yesu. ");
INSERT INTO cko_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Na wɔ niɛ aŋu damba baka be ni i nyawa, ka i wo dede, na wɔ kɔ aniɛ ka i nyá suu­wa n be di. Saŋga bo i kɔ juuri baka n bu ni, wɔ ŋu má pui su, baka n jina ni nyawa ŋgumi wɔ, dama nyini saŋga n ti má damba su saŋga. ");
INSERT INTO cko_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Na wɔ se baka n ka, “Sin nyuma sin, sɔnɔ di má u suu­wa kun.” I seeri sɔ n na i susu­fɔm n ati. ");
INSERT INTO cko_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Saŋga bo Yesu ni i susu­fɔm kɔ juuri Yɛrusalem miɛ kpiri n nu ni, na wɔ kɔ awura Nyɛmɛ Seree­biri Awuru n nu, na wɔ fɔn neŋge tɔ­fɔm ni to­fɔm kɛrɛ afite awuru n nu, na wɔ kaaki ŋwaa kaaki­fɔm n teebirim n ni tiiwa tɔ­fɔm n biɛm kɛrɛ alanlaŋga. ");
INSERT INTO cko_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Wɔ soro má su na be sɔ sɔɔri nati sin Nyɛmɛ Seree­biri Awuru n nu. ");
INSERT INTO cko_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Na wɔ kere minɛm ka, “Ba kɛrɛ i Nyɛmɛ Jɔrɛ Kadasi n nu ka, Nyɛmɛ ŋa o, ‘M awuru ni, bu bá fere i ka awuru n bo bu bá sere Nyɛmɛ n nu fa ma durunya n nu­fɔm kɛrɛ wɔ.’ Ama, ambɛrɛ afa i ayo fin­fɔm woo­biri.” ");
INSERT INTO cko_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ nkpiɛn­kpiɛnm n ni Nyɛmɛ nɔaniɛ kere­fɔm n tiiri sa n bo Yesu yoori i ni, na ba kpini atin kabo bu yó na bu kún i, dama ba soro i. Deke bo i ti na bu soroori i n la ka, minɛ dɔŋgu tiiri i keree­wa n na ba yo alekutura. ");
INSERT INTO cko_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Nyini cɛɛn n naasɔ, na Yesu ni i susu­fɔm n afite miɛ n nu. ");
INSERT INTO cko_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Alecin ŋgarama bu ba susin sukɔ na ba ŋu ka damba baka n awu akɔ akpura haari i bunlui. ");
INSERT INTO cko_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Na Petoro ateŋge su kabo Yesu seeri baka n ni, na wɔ se i ka, “Ya Kere­fɔ, niɛ. Damba baka n bo anuma na a jɔjɔ gɔɔri i ŋu ni, wɔ wu.” ");
INSERT INTO cko_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Na Yesu ase bu ka, “Am yo Nyɛmɛ yarada. ");
INSERT INTO cko_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nahɔrɛ ye m suse am n a, wɔrɔ kɛrɛ bo a se ahin buka n ka, ‘Yasu kɔ to tieku n nu,’ na a yo má sika na a yo yarada ka deke n bo a seeri i ni, i yó, Nyɛmɛ yó i ma u. ");
INSERT INTO cko_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Nyini ti, m suse am wɔ lɛɛ, ka, deke kɛrɛ bo am sere Nyɛmɛ ka am koro i, am yo yarada ka am anya i, Nyɛmɛ yó i ma am wɔ. ");
INSERT INTO cko_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Saŋga kɛrɛ bo am ba susere Nyɛmɛ, na be ado am ŋgasi, am fa i mi ni ŋgasi ce i ka, adena am Si Nyɛmɛ bo i wo aŋgoro n gusu fá am dɛɛ ce am.  ");
INSERT INTO cko_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Nzɛn am fa má am beŋgum ŋgasi ce má bu, am Si Nyɛmɛ bo i wo aŋgoro n gusu fá má am dɛɛ ŋgasi ce má am.” ");
INSERT INTO cko_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Bu fa ba juuri Yɛrusalem miɛ kpiri n nu bekun, na Yesu awura Nyɛmɛ Seree­biri Awuru n nu, na i sunati bara yɛ i. I wo dɔ sɔ ɔ n na Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ nkpiɛn­kpiɛnm, ni Nyɛmɛ nɔaniɛ kere­fɔm, ni Yuda­fɔm nkpiɛn­kpiɛnm n aba i dɔ, ");
INSERT INTO cko_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","na ba bisa i ka, “Ŋma dɛɛ yiko nu ye a yo nyini sam kɛrɛ a? Ŋma ma u nyini yiko n ye a yo nyini sam n a?” ");
INSERT INTO cko_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Na Yesu abɔ bu nu ka, “Am ma m du mɔ bisa am bisaa­wa kun be ka, na nzɛn am bɔɔri m nu, na m gusu nyá se am deke bo m yiko n fite. ");
INSERT INTO cko_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ŋma maari Yohane atin ye i ba biɛɛri minɛm Nyɛmɛ nzue n a? Nyɛmɛ nzɛn adamande? Am bɔ m nu.” ");
INSERT INTO cko_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Na ba se akuruwa bu ŋuŋu nu, kabo bu bɔ Yesu nu barasu. Bu ŋa, “Nzɛn ya seeri i ka Nyɛmɛ maari i atin a, i bísa ya ka, ye nzu ti ye ya da má Yohane ŋu a? ");
INSERT INTO cko_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ama, nzɛn ya se i ka adamande dɔ?” Dɔ gusu na ba soro jama ni. Má pui ti, dama sɔnɔ kɛrɛ soroori su ka Yohane yo ti Nyɛmɛ nɔaniɛ kan­fɔ ɔ nahɔrɛ su. ");
INSERT INTO cko_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Nyini ti, na ba bɔ i nu ka, “Ya si má.” Na yiri gusu ase bu ka, “Mini mmɔɔ sé má am sɔnɔ bo i dɛɛ yiko nu na m yo ahin sam n kɛrɛ ni.” ");
INSERT INTO cko_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Na Yesu abo bu miɛɛnum. I ŋa, “Sɔnɔ be yo woori bɛrɛ a, na wɔ dɔ i baka suu­wa barasu be fie, na wɔ kanda abara ayɛ fie ni. Na wɔ lokoti yabuɛ bambaka be kunma, ka i sumiɛmiɛ baka suu­wam ni nzue gɔ nu. Na wɔ ta kpafiri lenleŋge be ka bu tana su suniɛ fie n kɛrɛ su, na wɔ nya afa fie n awura i npa­di­fɔm saa nu. Na wɔ kɔ atin. ");
INSERT INTO cko_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Saŋga ba juuri bo i si ka baka suu­wam n abi ni, na wɔ sunma i akɔɔm kun i npa­di­fɔm n dɔ ka i kɔ de i dɛɛ bo ba nya i n bra. ");
INSERT INTO cko_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Akɔɔ n kɔ juuri ni, na ba tara i abo i, na ba fɔn i akpie i nyi i saa ŋgbɛɛn. ");
INSERT INTO cko_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Na fie n fɔ n asunma i akɔɔ n kun bekun, na ba tara i abo i atiɛ i tii, na ba kpa i nyinyɛ. ");
INSERT INTO cko_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Na wɔ kaaki asunma kun bekun, na ba kun yiri. Akɔɔ kɛrɛ bo fie n fɔ n nya sunmaari i a, a ŋu ka bu bo i wɔ, wara bu kun i wɔ. ");
INSERT INTO cko_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Sɔnɔ kun n kpein be ba kaari a, yiri la i wa koroo­wa ni. Yiri ye i ba kaari sin sunmaari a, na wɔ se ka, ‘Bu má m wa n yiri jirima.’ ");
INSERT INTO cko_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ama, na nyini npa­di­fɔm n ase bu ŋuŋu nu ka, ‘I wa n bo i dí i aja n lɛɛ suba n a. Am bra na ya kun i na aja n kɛrɛ ká ya dɛɛ.’ ");
INSERT INTO cko_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Dɔ na ba tara i, na ba kun i, na ba cin i afite fie n nu afa i atu.” ");
INSERT INTO cko_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Na Yesu anya ase bu ka, “Am sunsun ka fie n fɔ ni yó sɛ wɔ? I bá kun nyini npa­di­fɔm n kɛrɛ wɔ, na i fá fie n wura minɛ fɔfɔrɛm saa nu.” ");
INSERT INTO cko_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Na wɔ sa su ase ka, “Ambɛrɛ ni am tii akan Nyɛmɛ Jɔrɛ Kadasi n nu aŋu i kabo ba kɛrɛ i barasu. Bu ŋa, ‘Yabuɛ n bo bondo ta­fɔm n faari i tuuri ni, yiri ye wɔ kaaki bondo n jaa yabuɛm kɛrɛ tii a. ");
INSERT INTO cko_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Micɛra ni yoori i sɔ a. Ya ŋu i, na wɔ yo ya alekutura.’” ");
INSERT INTO cko_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yesu seeri sɔ ni, na Yuda­fɔm nkpiɛn­kpiɛnm n akpini atin kabo bu yo na bu tara i, dama bu faari nu ka miɛɛnu n bo i boori i ni, i niiri bɛrɛ wɔ, ama, bu soroori jama n dɛɛ ti, na ba yasu akɔ ayaki i. ");
INSERT INTO cko_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Nyini sin na nkpiɛn­kpiɛnm n asunma Farasi­fɔm ni Fɛmɛ Herode minɛ nbem na bu ba sɔ Yesu ŋgɛɛ na bu ti i nɔaniɛ. ");
INSERT INTO cko_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Na ba ba ase i ka, “Ya Kere­fɔ, ya si ka a ti nahɔrɛ se­fɔ ɔ, u cɛcɛ wo má kabo minɛ jɔjɔ nu, dama a niɛ má sɔnɔ jinaa­biri ti, ama, a kere minɛm wɔ nahɔrɛ su kabo Nyɛmɛ atin ti barasu. Tɔ, ya dɛɛ atin n su, atin wo nu ka ya tɔ lampo ma Roma­fɔm Fɛmɛ Kpiri Siza, nzɛn atin wo má nu?” ");
INSERT INTO cko_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ama, na Yesu asi ka bu ti burukɔɔ­nu­fɔm wɔ, na wɔ bisa bu ka, “Nzu ti ye am sukoro ka am sɔ m ŋgɛɛ a? Am fa ŋwaa bra na m niɛ.” ");
INSERT INTO cko_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Na ba fa ŋwaa n aba ama i. Na wɔ de ŋwaa n aniɛ, na wɔ bisa bu ka, “Ŋma dɛɛ tii ni i duma wo ŋwaa n su n a?” Na ba bɔ i nu ka, “Fɛmɛ Siza dɛɛ a.” ");
INSERT INTO cko_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Na Yesu ase bu ka, “Deke bo i ti Fɛmɛ Siza dɛɛ, am fa ma Fɛmɛ Siza, na deke bo i ti Nyɛmɛ dɛɛ, am fa ma Nyɛmɛ.” Na ba miɛ ni i nɔaniɛ ni. ");
INSERT INTO cko_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Na Yuda­fɔm asɛsɛ barasu nbem bo bu fere bu ka Sadusi­fɔm ni, aba Yesu dɔ. Bu dɛɛ keree­wa la ka Nyɛmɛ téŋge má minɛm bu yiwee n nu n a. Na ba ba abisa i jɔrɛ be, bu ŋa, ");
INSERT INTO cko_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Ya Kere­fɔ, Moyisi yo kɛrɛɛri nɔaniɛ be maari ya, ka nzɛn sɔnɔ wu yakiiri i yi, na i ni bara n anya má baa, wɔ yo daka ka i niɛma n fa kuna­fɔ n na bu wu nbaam ma gɔrɔ n bo wɔ wu ni. ");
INSERT INTO cko_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Tɔ, sɔnɔ be yo laari nbaa­biɛsɔm nso, na baa­kpiɛn n aja bara, na wɔ wu ayaki bara ni, ba nya má baa. ");
INSERT INTO cko_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Na bo i tɔ i su n afa kuna­fɔ n aja, na yiri gusu awu ayaki bara ni, ba nya má baa. Na bo i tɔ i su nsan su n gusu afa i aja bekun. ");
INSERT INTO cko_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","I yo sɔ ɔ, na bu nso n kɛrɛ aja bara n abara ayɛ, na bu kɛrɛ awu ayaki i, ba nya má baa, na bara n gusu aba aka sin awu. ");
INSERT INTO cko_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Kabo bu minɛ nso n kɛrɛ aja bara n na ba wu sɔ ni, cɛɛn n bo Nyɛmɛ bá teŋge minɛm bu yiwee n nu ni, bara ni ká ŋma dɛɛ wɔ?” ");
INSERT INTO cko_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Na Yesu abɔ bu nu ka, “Am amini atin. Deke bo i ti na am amini atin n la ka, am ti má deke bo ba kɛrɛ i Nyɛmɛ Jɔrɛ Kadasi n nu n bu, na am kaaki si má kabo i yiko n ti barasu. ");
INSERT INTO cko_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Dama saŋga bo Nyɛmɛ má minɛm teŋge bu yiwee n nu ni, ajaa wo má bɛrɛ kun. Ama, nyini cɛɛn ni, sɔnɔ kɛrɛ káaki ka Nyɛmɛ mɛrɛkɛm bo bu wo aŋgoro n wɔ. ");
INSERT INTO cko_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Na fa kɔ kabo Nyɛmɛ bá teŋge minɛm bu yiwee n nu ni, am kaanri Moyisi dɛɛ kadasi ni, nzɛn am akan má i? Kabo i kɛrɛɛri fa kɔ saŋga bo sin n jeeri buwe baka n su n na Nyɛmɛ jɔjɔɔri i dɔ ni, i ŋa, ‘Mini ti Abraham, ni Izaki, ni Jakɔbu dɛɛ Nyɛmɛ n a.’” ");
INSERT INTO cko_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Na Yesu asa su ase bu ka, “Kabo Nyɛmɛ ŋa i ti nyini minɛm n dɛɛ Nyɛmɛ ni, nyini kere ka bu toko la ŋgɔɔ lɛɛ, dama Nyɛmɛ ti má bo ba wu n dɛɛ Nyɛmɛ, ama, i ti bo bu la ŋgɔɔ n dɛɛ Nyɛmɛ a. Nyini ti, kabo am ŋa Nyɛmɛ téŋge má minɛm bu yiwee n nu, am amini fieo.” ");
INSERT INTO cko_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Na Nyɛmɛ nɔaniɛ kere­fɔm kun aŋu kabo Sadusi­fɔm ni Yesu seeri bu beŋgu akuruwa ni, i tiiri kabo Yesu bɔɔri bu nu nyunyumi sɔ ni, na wɔ ba abisa i ka, “Nyɛmɛ nɔaniɛ maa­wam ni, bɔnɔ tara bu kɛrɛ a?” ");
INSERT INTO cko_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Na Yesu abɔ i nu ka, “Nɔaniɛ n bo i tara bu kɛrɛ n yaa, ba kɛrɛ ka, ‘Ambɛrɛ Yisareli­fɔm, am ti fɛn, ya Micɛra Nyɛmɛ n ti kun wɔ. ");
INSERT INTO cko_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Koro Micɛra u Nyɛmɛ ni, ni u ahore­mbaa kun, ni u awiɛwiɛ, ni u sunsunni, ni u faŋga kɛrɛ.’ ");
INSERT INTO cko_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Bo i tɔ su nnyɔ n la ka o, ‘Koro u beŋgu kabo a koro u ŋu ni.’ Nɔaniɛ maa­wa be wo má bɛrɛ bo i tara ahin nnyɔm ni.” ");
INSERT INTO cko_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Na Nyɛmɛ nɔaniɛ kere­fɔ n ase Yesu ka, “Aŋgba. Ya Kere­fɔ, i nahɔrɛ atin su lɛɛ ye a kan i n a. Ya Micɛra Nyɛmɛ n ti kun wɔ. Nyɛmɛ be wo má bɛrɛ sin i ŋu. ");
INSERT INTO cko_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Wɔ kaaki ayo daka ka ya koro Nyɛmɛ ni ya ahore­mbaa kun, ni ya sunsunni, ni ya faŋga kɛrɛ, na ya kaaki koro ya beŋgu kabo ya koro ya ŋu ni, nyini nnyɔm n ti ye tara bo ya yo tiɛm, ni bo ya yi sarakam ma Nyɛmɛ ni.” ");
INSERT INTO cko_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Na Yesu aŋu ka sɔnɔ n abɔ i nu kpa, na wɔ se i ka, “A waari má ni Nyɛmɛ fɛmɛya ni.” Nyini sin, be abo má su ka i bisa Yesu jɔrɛ bekun. ");
INSERT INTO cko_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Saŋga bo Yesu woori Nyɛmɛ Seree­biri Awuru n nu sukere Nyɛmɛ nɔaniɛ ni, na wɔ bisa minɛm jɔrɛ be fa kɔ Kristo Tii­de­fɔ n su. I ŋa, “Nzu ti ye Nyɛmɛ nɔaniɛ kere­fɔm n bita jɔjɔ ka Kristo n ti Fɛmɛ Davidi anuma a? ");
INSERT INTO cko_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dama Awiɛwiɛ Casi n yo wuraari Fɛmɛ Davidi ŋu ni, na yiri ni i tii ase ka, ‘Na Micɛra ase m Mibiɛ n ka, “Ba tana m saa fɔmbɔrɔ su fɛn, haari m bá ma u kpɔ­fɔm kɛrɛ ba kutu u jaa bu.”’ ");
INSERT INTO cko_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Tɔ, Fɛmɛ Davidi mmɔɔ ni i tii fereeri Kristo n ka i Mibiɛ wɔ, ye Kristo n yo sɛ kaaki yo Fɛmɛ Davidi anuma a?” Ye jama beberebe n jina tiiri Yesu nɔaniɛ n ni ahorejɔ a. ");
INSERT INTO cko_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","I woori bu kere n su ni, na wɔ se bu ka, “Am si am ŋu sa ni Nyɛmɛ nɔaniɛ kere­fɔm ni, deke bo bu koro i n la ka, bu wura sutura ŋgbiŋgbirim wɔ, na bu nati sujeŋgbe, na sɔnɔ kɛrɛ suyo bu ansɛ gɔɔsu. ");
INSERT INTO cko_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Nyini minɛm n anya awura bu tiɛntiɛn­bunɔɔ sɔɔm n nu ni, wara ba nya afere bu tiɛntiɛn­bunɔɔ bambaka diire dii­birim ni, bu koro ka bu tana kpirikoro tanaa­birim wɔ. ");
INSERT INTO cko_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Nyini minɛm n sɔ fin nkuna­fɔm neŋgem wɔ, na bu jina sere Nyɛmɛ cɛ, adena minɛm ŋu ka bu ti minɛ kpam wɔ. Jina cɛɛn, bɛrɛ bá nya sui­cin tara minɛm kɛrɛ.” ");
INSERT INTO cko_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Na Yesu akɔ atana adodo alaka bo minɛm yi bu saraka ŋwaa wura nu ni, na i suniɛ kabo minɛm yi saraka barasu. Neŋge­fɔm dɔŋgu yiiri ŋwaa beberebe wuraari saraka n nu. ");
INSERT INTO cko_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Na kuna­fɔ yaari­fɔ be gusu aba ayi ŋwaa kaan be bo i koro to má pui awura saraka n nu. ");
INSERT INTO cko_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Dɔ na Yesu afere i susu­fɔm n na wɔ se bu ka, “Nahɔrɛ ye m suse am n a, nyini kuna­fɔ n ayi ŋwaa atara minɛm n kɛrɛ. ");
INSERT INTO cko_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Dama neŋge­fɔm la ŋwaa beberebe n dɛɛ ti, ye ba yi be a. Ama, nyini kuna­fɔ n ni i yaari n kɛrɛ, i deke kɛrɛ bo i la i lɛɛ, ye wɔ yi i n a.” ");
INSERT INTO cko_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Saŋga bo Yesu sufite Nyɛmɛ Seree­biri Awuru n nu ni, na i susu­fɔm n nu kun be aba ase i ka, “Ya Kere­fɔ, niɛ nyini yabuɛ ŋgbiŋgbirim ni. Niɛ kabo bu ti a. Niɛ nyini awuru bambaka ni. Niɛ kabo ba ta i barasu a.” ");
INSERT INTO cko_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Na Yesu ase i ka, “M ŋa a ŋu nyini ataari ŋgbiŋgbirim n e? Yabuɛ kun n kpein n mmɔɔ bá nana má i beŋgu su. Bu bá bereki i kɛrɛ gɔ ɔ lɛɛ.” ");
INSERT INTO cko_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Na Yesu akɔ afun atana Oliva Buka n su suniɛ Nyɛmɛ Seree­biri Awuru ni. Na saŋga bo yiri ni Petoro ni Yakobo ni Yohane ni Andere woori bu ŋgumi ni, na ba bisa i ka, ");
INSERT INTO cko_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Ya Kere­fɔ, se ya, saŋga bɔnɔ ye ahin sam n kɛrɛ bá yo a? Ye nzu deke bá kere ya ka saŋga n adodo bo nyini sam n kɛrɛ bá yo a?” ");
INSERT INTO cko_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Na Yesu anya ase bu ka, “Am si am ŋu sa na má am ma be dadaka am. ");
INSERT INTO cko_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Dama minɛ dɔŋgu bá fa m duma n ba, na bu sé ka, ‘Yiri la mini n a.’ Na bu dádaka minɛ beberebe. ");
INSERT INTO cko_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Saŋga bo am bá ti aluwa ŋga fɛn, wara bu sukun luɛ dɔ, má am ma am ahore saaki. Wɔ yo daka ka nyini n kɛrɛ bá yo ka, ama, má am niɛ ka durunya n awieeri lɛɛ. ");
INSERT INTO cko_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Daanfiɛ daanfiɛ bá kun luɛ ni bu beŋgum, na nfɛmɛm kún luɛ ni bu beŋgu nfɛmɛm. Na asiɛn bá kpisi awɔrɛ awɔrɛm nu, na ahɔɛ tɔ́. Nyini n kɛrɛ bá yo kabo bara kutu cɛɛn bumboori dɛɛ wahara n ti n wɔ. ");
INSERT INTO cko_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Am si am ŋu sa, dama bu bá fa am wura jɔrɛ­di­fɔm saa nu, na bu bó am bu tiɛntiɛn­bunɔɔ sɔɔm n nu. Mini dɛɛ ti, na bu dí am jɔrɛ gominam ni nfɛmɛm nyunu. Nyini má am atin, na am di m daani kere bu a. ");
INSERT INTO cko_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ama, wɔ yo daka ka daanfiɛ kɛrɛ du mɔ ti labari kpa n ka, ye durunya n awieeri bá ju a. ");
INSERT INTO cko_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Saŋga n bo bu bá faari am kɔɔri jinaa­biri, na bu kɔ di am jɔrɛ ni, má am ma am ahore saaki fa kɔ kabo am kɔ́ jɔjɔ barasu. Nɔaniɛ kɛrɛ bo i tɔ́ am nɔɔ nyini saŋga ni, am jɔjɔ i, dama i fíte Awiɛwiɛ Casi n dɔ ɔ, i fíte má am dɔ. ");
INSERT INTO cko_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Gɔrɔm ni niɛmam bá tɔ bu beŋgu ma bu kpɔ­fɔm na bu kún bu, na sim tɔ́ bu nbaam, na nbaam kéte bu wu­fɔm ŋu, na bu má minɛm kun bu wu­fɔm ni. ");
INSERT INTO cko_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ama, wɔrɔ kɛrɛ bo a mindi deeri nyini n kɛrɛ kɔ ju i awieeri, Nyɛmɛ dé u tii ji.” ");
INSERT INTO cko_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Na Yesu akaaki ase bu ka, “Am bá ŋu anyumbaa ciire sa be bo Nyɛmɛ mmɔɔ kpɔ i, ka bu má i jina Nyɛmɛ Seree­biri Awuru n nu, deke bo wɔ yo má daka ka i jina, na i sáaki i ni. Ma sɔnɔ kɛrɛ bo i kan ahin kadasi n ti i bu nyunyumi. Nyini saŋga ni, wɔrɔ kɛrɛ bo a tiiri i ŋga, na a wo Yudiya asiɛn n su, ŋmati kɔ bukam n su. ");
INSERT INTO cko_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Wɔrɔ kɛrɛ bo a wo kpata nu, má a wura gisan n nu fa pui. ");
INSERT INTO cko_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Na wɔrɔ kɛrɛ gusu bo a wo fiesu, má a kpie u nyi kɔ awuru kɔ fa u sutura be. ");
INSERT INTO cko_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Nyini saŋga ni yó kekere agaya ma nyinsɛ­fɔm, ni nbaram bo bu nbaam toko nu ni. ");
INSERT INTO cko_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Am sere Nyɛmɛ ka má nyini sa n yó buke saŋga. ");
INSERT INTO cko_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Nyini saŋga ni, wahara bo minɛ dí i, i tára wahara kɛrɛ bo ba di i asin, fite saŋga n bo Nyɛmɛ yiiri durunya ni haari ni kisa, nyini wahara n ŋusu bá má kun. ");
INSERT INTO cko_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ama, Micɛra n akpiɛ nyini saŋga n su. Nzɛn má wɔ kpiɛ má i su, má sɔnɔ wo má bɛrɛ bo i nyá ŋgɔɔ, ama, i dɛɛ tiɛŋgu minɛm bo wɔ yi bu n dɛɛ ti, wɔ kpiɛ saŋga n su a. ");
INSERT INTO cko_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Nyini saŋga ni, nzɛn be bá se am ka, ‘Am niɛ, Kristo Tii­de­fɔ ni wo fɛn n a,’ wara ‘Am niɛ, yiri wo dɔ n a,’ má am de i mi nɔaniɛ ni. ");
INSERT INTO cko_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Dama kɔrɛ­fɔ nbem bá ba na bu yó bu ŋu ka bɛrɛ ti Kristo n a, na nbem gusu yó bu ŋu ka bu ti Nyɛmɛ nɔaniɛ kan­fɔm wɔ. Bu yó alekutura sam beberebe fa kere am, na nzɛn bu koro nyaari atin, bu dádaka Nyɛmɛ dɛɛ minɛm bo wɔ yi bu ni. ");
INSERT INTO cko_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ambɛrɛ, ma se am i kɛrɛ wɔ lɛɛ ka, na saŋga n nyá ba ju. Am si am ŋu sa.” ");
INSERT INTO cko_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Na Yesu akaaki ase bu ka, “Saŋga bo nyini wahara n kɛrɛ ba siinri, ‘Awosin káta wiɛ n su, na sara n gusu tá má bo minɛm ŋu i. ");
INSERT INTO cko_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Na asara­mbaam fíte aŋgoro titi tɔtɔ, na aŋgoro n kɛrɛ kpísi.’ ");
INSERT INTO cko_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Na minɛm nyá ŋu ka mini Adamande Wa ni sufite aŋgoro yinyiŋgu n nu suje piɛpiɛu suba ni yiko bambaka. ");
INSERT INTO cko_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Na m nyá sunma Nyɛmɛ mɛrɛkɛm durunya n awɔrɛ n kɛrɛ nu, na bu tíɛntiɛn Nyɛmɛ minɛm bo Nyɛmɛ ayi bu durunya n nu n kɛrɛ nɔɔ.” ");
INSERT INTO cko_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Na Yesu akaaki ase ka, “Am fa damba baka n fa se nyaari. Saŋga bo am ba ŋu ka i nyawa akpɔnkpɔn, na i sufiɛfiɛ fɔfɔrɛ ni, am si ka dɔdɔɔri saŋga adodo lɛɛ. ");
INSERT INTO cko_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Mini Adamande Wa n ba ni bá yo sɔ ɔ. Saŋga bo ambɛrɛ gusu bá ŋu ka nyini sam kɛrɛ bá suyo ni, am si tenle su ka saŋga n adodo lɛɛ, i cɛ́ má kun. ");
INSERT INTO cko_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nahɔrɛ ye m suse am n a, ka bo bu la ŋgɔɔ kisa n wú wie má ka, ye nyini sam kɛrɛ bá yo a. ");
INSERT INTO cko_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Aŋgoro ni asiɛŋgu kɛrɛ bá la awieeri, ama, m dɛɛ nɔaniɛ n yiri la má awieeri cɛɛn be.” ");
INSERT INTO cko_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Na Yesu akaaki ase ka, “Be si má saŋga ni, wara cɛɛn n bo m bá kpie m nyi ba ni. Haari Nyɛmɛ mɛrɛkɛm n bo bu wo i dɔ ni, ni mini bo m ti i wa n mmɔɔ si má. Má ka ya Si Nyɛmɛ ŋgumi si a. ");
INSERT INTO cko_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Nyini ti, am si am ŋu sa. Má am fa am ŋu ji, dama am si má saŋga n bo m bá ni. ");
INSERT INTO cko_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Mini Adamande Wa n baawa ni bá yo ka sɔnɔ be ye wɔ yasu i dika ka i kɔ atin. Saŋga bo i ba sukɔ ni, na wɔ fa i awuru n awura i akɔɔm saa nu, na wɔ ma bu kɛrɛ ni bu juma bo bu yo. Na wɔ se daŋminda­fɔ n ka má i fa i ŋu ji haari fa kɔ saŋga bo i bá ba. ");
INSERT INTO cko_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ambɛrɛ mmɔɔ si má saŋga bo mini Awuru­fɔ­biɛ ni bá ba. Nzɛn ŋgarama a? Naasɔ ɔ? Kɔŋguɛ jinanjin? Akɔnyuma bo saŋga? Be si má. Nyini ti, má am fa am ŋu ji, ");
INSERT INTO cko_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","na má am daafi na m bá fura am nu. ");
INSERT INTO cko_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Deke bo m sujɔjɔ se am ni, m jɔjɔ ni sɔnɔ kɛrɛ pepere wɔ lɛɛ, ka, má am fa am ŋu ji na am daafi.” ");
INSERT INTO cko_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Nyini saŋga ni, wɔ ka le­nnyɔ ɔ, na bu di bu cɛɛn­kpiri nbem. Bu fere kun n ka Butara cɛɛn­kpiri, bo bu di i na bu teŋge su kabo Nyɛmɛ yo deeri bu nam tii fiteeri Ijipiti­fɔm asiɛn su ni. Na kun la bo bu di i ni kpɔnɔ bo bu gɔ má ayiri nu na i yasu ni. Na Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ nkpiɛn­kpiɛnm ni, ni Nyɛmɛ nɔaniɛ kere­fɔm ni, aniɛniɛ atin kabo bu yó barasu na bu tára Yesu kun i fiɛɛ­wa nu. ");
INSERT INTO cko_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Na ba se bu ŋuŋu nu ka, “Má am ma ya yo i cɛɛn­kpiri n saŋga. Má nyini, minɛm ni kéte yo naŋmiɛ wɔ, na bu sutiɛntiɛn.” ");
INSERT INTO cko_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu woori Betani miɛ n nu wɔ, sɔnɔ be dika, bu fere i ka Simon, i yo ti koko­fɔ ɔ. Saŋga bo Yesu wo diire di su ni, na bara be aba ni tulaalɛɛ tuwa nva­nvani bo i la gɔ agaya. Na wɔ bo abu tulaalɛɛ tuwa n nɔɔ, na wɔ kaaki tulaalɛɛ n kɛrɛ agɔ Yesu tii su. ");
INSERT INTO cko_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Na yaa ati minɛm ni nbem bo bu wo dɔ ni, na ba se bu ŋuŋu nu ka, “Nzu ti ye wɔ saaki tulaalɛɛ n sɔ a? ");
INSERT INTO cko_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Má ya tɔɔri i, má ya nyá ŋwaa beberebe, na ya fá ma yaari­fɔm.” Na ba kan bara ni ndiɛ agaya. ");
INSERT INTO cko_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Na Yesu ase bu ka, “Am yaki i bɛnlɛ. Má am kan i ndiɛ. Sakpa lɛɛ ye wɔ yo ama m n a. ");
INSERT INTO cko_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Am ni yaari­fɔm ni wo bɛrɛ saŋga kɛrɛ a, na nzɛn saŋga be am ba koro ka am yo bu sakpa, am yo bu. Ama, mini, m wo má am dɔ saŋga kɛrɛ. ");
INSERT INTO cko_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Wɔ yo i dɛɛ faŋga nyaari lɛɛ, wɔ kaaki tulaalɛɛ n agɔ m ŋu ka i dɛɛ nzee bo wɔ fa ayo m siriya fa kɔ m yiwee cɛɛn lɛɛ. ");
INSERT INTO cko_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nahɔrɛ ye m suse am n a, deke kɛrɛ bo bu bá kaanri Nyɛmɛ labari kpa ni durunya n kɛrɛ nu, bu kán i sa­yoo­wa n na minɛm teŋge i su.” ");
INSERT INTO cko_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Na Yudasi Isikariyoti bo i ti Yesu susu­fɔ buru ni nnyɔm ni kun be ni, akɔ Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ nkpiɛn­kpiɛnm ni dɔ, ka i kɔ tɔ Yesu ma bu. ");
INSERT INTO cko_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Bu tiiri labari n sɔ ni, na bu ahore ajɔ, na bu gusu atan ndiɛ ama i ka bu má i ŋwaa. Na Yudasi akpini atin kabo i yó barasu na bu nya Yesu taraa­biri. ");
INSERT INTO cko_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Na cɛɛn­kpiri n bo bu di i ni kpɔnɔ bo bu gɔ má ayiri nu na i yasu ni, i le­kun cɛɛn, nyini cɛɛn ye bu kun nbɔmbaam bo bu di na bu teŋge Butara cɛɛn­kpiri n su n a, na Yesu susu­fɔm n abisa i ka, “A koro ka ya kɔ ni kɔ sɛsɛ Butara cɛɛn­kpiri n diire n su se a?” ");
INSERT INTO cko_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Na Yesu afere bu nu nnyɔ na wɔ se bu ka, “Am kɔ miɛ n kunnu. Am ni sɔnɔ be yɛ́. I sɔ nzue dundu. Am su i su, ");
INSERT INTO cko_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","kɔ awuru n bo i kɔ́ wura nu ni, na am bisa awuru­fɔ­biɛ n ka, ‘Ya Kere­fɔ n ŋa, sɔɔ bɔnɔ nu ye i ni i susu­fɔm ni dí Butara cɛɛn­kpiri n diire n a?’ ");
INSERT INTO cko_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Na i kére am aŋgoro sɔɔ bambaka n bo ba yo i dɔŋgu ase ni, dɔ ye am sɛ́sɛ diire n su se ya.” ");
INSERT INTO cko_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Na i susu­fɔm ni akɔ miɛ n nu, na ba kɔ aŋu deke n kɛrɛ sɔ, kabo Yesu seeri bu ni, na ba sɛsɛ Butara cɛɛn­kpiri diire n su. ");
INSERT INTO cko_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Na naasɔ saŋga, na Yesu ni i susu­fɔ buru ni nnyɔm ni kɛrɛ aba dɔ. ");
INSERT INTO cko_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Na saŋga bo bu tana wo diire n di su ni, na Yesu ase bu ka, “Nahɔrɛ ye m suse am n a, am nu kun bá tɔ m ma m kpɔ­fɔm a. I mi ni mini susaŋga di diire n a.” ");
INSERT INTO cko_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Na bu ahore asaaki, na bu kun kun n kɛrɛ abisa i ka, “Ye m ŋa má mini yiri e?” ");
INSERT INTO cko_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Na Yesu abɔ bu nu ka, “Ambɛrɛ buru ni nnyɔm nu kun yó nyini a, i mi ni mini susaŋga fa ya saa wura taalɛ kun nu a. ");
INSERT INTO cko_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Mini Adamande Wa ni wú kabo ba kɛrɛ i Nyɛmɛ Jɔrɛ Kadasi n nu ase ka m wú n wɔ, ama, sɔnɔ n bo i tɔ́ mini Adamande Wa n ni, i mi bá ŋu anyum­boro. Má ba wu má i mi n mmɔɔ, má i ti ye.” ");
INSERT INTO cko_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Saŋga bo Yesu ni i susu­fɔm ni wo diire n di su ni, na Yesu afa kpɔnɔ, na wɔ da Nyɛmɛ asi, na wɔ bubu i nu, na wɔ fa ama bu, na wɔ se bu ka, “Am de ahin kpɔnɔ n na am di, i ti m ŋuniɛ­mbaa a.” ");
INSERT INTO cko_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Na wɔ kaaki afa awa ni nzan, na wɔ da Nyɛmɛ asi, na wɔ fa ama bu, na bu kɛrɛ anu be. ");
INSERT INTO cko_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Na wɔ se bu ka, “Ahin nzan n ti m mbunja lɛɛ, ye m sufa ma am n a. Yiri ye Nyɛmɛ sufa sɛsɛ­su na i di i di n a. Minɛm dɔŋgu satiɛ dɛɛ ti, ye m mbunja ni soŋgi gɔ a.” ");
INSERT INTO cko_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Na wɔ kaaki ase bu ka, “Nahɔrɛ ye m suse am n a, m nú má nzan be kun, má ka cɛɛn n bo m bá nu i fɔfɔrɛ Nyɛmɛ fɛmɛya n nu ni.” ");
INSERT INTO cko_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Nyini sin na ba di jue akansi Nyɛmɛ, na ba fite akɔ Oliva Buka n su. ");
INSERT INTO cko_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Na Yesu ase i susu­fɔm n ka, “Am kɛrɛ bá ŋmati yaki m, dama ba kɛrɛ i Nyɛmɛ Jɔrɛ Kadasi n nu ka, Nyɛmɛ ŋa, ‘M bó kun bɔɛ­sasa­fɔ ni, na nbɔɛm bá sandi.’ ");
INSERT INTO cko_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ama, m bá teŋgeeri m yiwee n nu ni, m dú am mɔ kɔ Galili awɔrɛ n nu.” ");
INSERT INTO cko_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Na Petoro ase i ka, “Nzɛn ahinm kɛrɛ ŋmati yakiiri u, mini ŋmáti yaki má u da.” ");
INSERT INTO cko_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Na Yesu ase Petoro ka, “Nahɔrɛ ye m suse u a, nyuma kɔŋguɛ n nu, kana akɔnyuma bá bo kpe nnyɔ su, a kéte kpe nsan ka a si má m.” ");
INSERT INTO cko_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Na Petoro abo i hoe ase i ka, “Mini sé má sɔ da. Nzɛn haari wɔ yo daka ka mini ni wɔrɔ kɛrɛ sáŋga wu mmɔɔ, ya wú ɔ.” Na i susu­fɔm n kɛrɛ ase sɔ. ");
INSERT INTO cko_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Na ba yasu akɔ aju awɔrɛ be bo bu fere i ka Gɛsɛmane ni, na Yesu ase i susu­fɔm ni ka, “Am tana fɛn ŋminda m, na m kɔ́ sere Nyɛmɛ.” ");
INSERT INTO cko_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Na wɔ fa Petoro ni Yakobo ni Yohane na ba kɔ mɔ kaan. Bu kɔ juuri dɔ na ahoresaaki aba i dɔ agaya, na i jeke ati. ");
INSERT INTO cko_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Na wɔ se bu ka, “Ahoresaaki aba m dɔ agaya, i yo m ka m wú ɔ mmɔɔ. Am wo fɛn na am ŋminda m. Má am daafi.” ");
INSERT INTO cko_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Na wɔ kɔ dede kaan, na wɔ butu i kunnu su, na wɔ sere Nyɛmɛ ka nzɛn má i koro ma ahin anyum­boro n sin yaki i. ");
INSERT INTO cko_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","I ŋa, “ Abba,” i bu la ka, “M Si, wɔrɔ koro yo sa kɛrɛ a. Nyini ti, yi m fite ahin anyum­boro n bo i suba m dɔ n nu. Ama, má a yo kabo m koro ni, se kabo a koro ni.” ");
INSERT INTO cko_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","I sere Nyɛmɛ wieeri ni, na wɔ kpie i nyi akɔ aŋu ka i susu­fɔ nsanm ni wo daafiri su. Na wɔ teŋge bu na wɔ se Simon Petoro ka, “Simon, a daafi wɔ? A koro kpiɛ má daafiri, haari kaan sɔ mmɔɔ?” ");
INSERT INTO cko_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Na wɔ kaaki ase bu ka, “Am kpiɛ daafiri, na am sere Nyɛmɛ, adena má deke be yo am na am wura satiɛ nu. Ahore­mbaa n koro nyɛmɛsu, ama, aŋuniɛ­mbaa n ayɔrɔki.” ");
INSERT INTO cko_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Na wɔ kaaki akɔ asere Nyɛmɛ bekun ni nyini nɔaniɛ jɔjɔɔ­wa kun bo i du mɔ jɔjɔɔri ni. ");
INSERT INTO cko_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Na wɔ kpie i nyi aba i susu­fɔm n dɔ, na wɔ ba aŋu ka ba daafi bekun, dama daafiri ati bu agaya. Ba koro ase má i pui. ");
INSERT INTO cko_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Na wɔ kɔ asere Nyɛmɛ kpe nsan su, akaaki aba aŋu ka bu toko wo daafiri su, na wɔ se bu ka, “Am toko daafi yi am ŋumi wɔ? Wɔ sɛ su. Saŋga n aju, wɔ tɔ mini Adamande Wa ni ama satiɛ­yo­fɔm. ");
INSERT INTO cko_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Am niɛ, sɔnɔ n bo wɔ tɔ m lɛɛ. Am yasu na ya kɔ.” ");
INSERT INTO cko_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Na saŋga bo Yesu toko wo jɔjɔɔri su ni, na Yudasi bo i ti Yesu susu­fɔ buru ni nnyɔm nu kun aju ni jama beberebe. Bu bita takobem ni kɔrɔmam. Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ nkpiɛn­kpiɛnm n ni Nyɛmɛ nɔaniɛ kere­fɔm ni, ni Yuda­fɔm nkpiɛn­kpiɛnm ni sunmaari bu a. ");
INSERT INTO cko_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Na Yudasi bo i tɔɔri Yesu ni akere jama n nyaari su kabo bu sí Yesu na bu tara i. I ŋa, “Sɔnɔ n bo m kɔ́ biti i ni, yiri lɛɛ. Am tara i, na am bita i kenken, na am fa i kɔ.” ");
INSERT INTO cko_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Saŋga bo i kɔ juuri ni, i kaba kɔɔri Yesu dɔ ɔ, na wɔ bo afere i ka, “Ya Kere­fɔ.” Na wɔ biti i, na wɔ yo i ansɛ. ");
INSERT INTO cko_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Na minɛm n atara Yesu na ba bita i kenken. ");
INSERT INTO cko_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Na Yesu susu­fɔm bo bu jina bɛrɛ n nu kun acin ayi i takobe, na wɔ kpiɛ sɔnɔ be sui, nyini sɔnɔ n ti Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm kpiɛn n akɔɔ ɔ. ");
INSERT INTO cko_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Na Yesu abisa bu ka, “M ti fin­fɔ ɔ ye am fa takobem ni kɔrɔmam na am ba tara m a? ");
INSERT INTO cko_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Cɛɛn kɛrɛ cɛɛn m ni ambɛrɛ wo Nyɛmɛ Seree­biri Awuru n nu a, ye m kere minɛm a, ama, am atara má m. Tɔ, i ti ye ni ka kabo ba kɛrɛ i Nyɛmɛ Jɔrɛ Kadasi n nu ka bu yó m ni yo yii­wa.” ");
INSERT INTO cko_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Na i susu­fɔm n kɛrɛ aŋmati ayaki i. ");
INSERT INTO cko_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Na gbɛfɛnɛ be gusu su Yesu su. I kara tani ŋgumi wɔ. Na ba laandi ka bu tara i, ");
INSERT INTO cko_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","na wɔ foro bu saa aŋmati ayaki tani ni, i bu ŋgbɛɛn. ");
INSERT INTO cko_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Na ba fa Yesu akɔ Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm kpiɛn n dika, na Yuda­fɔm tere­tere­fɔm kɛrɛ aba atiɛn bu nɔɔ. Bɛrɛ la Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ nkpiɛn­kpiɛnm ni, ni Yuda­fɔm nkpiɛn­kpiɛnm ni, ni Nyɛmɛ nɔaniɛ kere­fɔm ni. ");
INSERT INTO cko_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Na Petoro asu Yesu su, ama, i woori dede kaan ni yiri, na wɔ kɔ awura Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm kpiɛn n dika gisan nu. Na wɔ kɔ asaŋga atana tintini­jina­fɔm n nu atun sin. ");
INSERT INTO cko_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Na Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ nkpiɛn­kpiɛnm ni, ni Yuda­fɔm tere­tere­fɔm n kɛrɛ aniɛniɛ minɛm bo bu bá di daani fa kɔ ŋgasi bo Yesu ado i ni, adena bu nya i taraa­biri na bu kun i, ama, ba nya má jɔrɛ bo bu fa kpiɛ sɔ i. ");
INSERT INTO cko_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Na daani di­fɔm beberebe afite ajina akpiɛ kɔrɛ asɔ Yesu, ama, bu nɔaniɛ n ayo má kun. ");
INSERT INTO cko_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Na minɛ nbem gusu ayasu ajina akpiɛ kɔrɛ asɔ Yesu, ");
INSERT INTO cko_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","bu ŋa, “Ya tiiri ka i ŋa, i fúfu ahin Nyɛmɛ Seree­biri Awuru n bo minɛm taari i ni, na le­san afiɛn, na i káaki ta fɔfɔrɛ bo i ti má kabo adamande ataari ti ni.” ");
INSERT INTO cko_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Haari ni nyini n mmɔɔ, bu nɔaniɛ ni ayo má kun. ");
INSERT INTO cko_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Na Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm kpiɛn ni ayasu ajina tere­tere­fɔm n afiɛn, na wɔ bisa Yesu ka, “A la má bɔnu be fa kɔ ahin jɔrɛ n bo minɛm ni akpiɛ asɔ u n su?” ");
INSERT INTO cko_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ama, na Yesu amɔ i nɔɔ, wɔ bɔ má jɔrɛ be nu. Na Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm kpiɛn ni abisa i bekun ka, “Wɔrɔ ti Nyɛmɛ n bo ya kɛrɛ kansi i n dɛɛ Wa, Kristo Tii­de­fɔ n a?” ");
INSERT INTO cko_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Na Yesu abɔ i nu ka, “Mini lɛɛ. Na ‘am bá ŋu mini Adamande Wa ni, ka m tana Nyɛmɛ Yiko­fɔ n saa fɔmbɔrɔ su, na am ŋú ka m fite aŋgoro yinyiŋgu n nu suba.’” ");
INSERT INTO cko_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Yesu bɔ nu sɔ wieeri ni, na Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm kpiɛn ni asɔn i tanlɛɛ. Na wɔ se ka, “Ya koro má daani­fɔ bekun. ");
INSERT INTO cko_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ambɛrɛ mmɔɔ ti kabo wɔ jɔjɔ awura Nyɛmɛ ŋgasi n nu e. Ye am ŋa sɛ wɔ?” Na bu kɛrɛ ase ka wɔ kan ciire jɔrɛ, nyini ti, wɔ yo daka ka i wu. ");
INSERT INTO cko_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Bu kaanri sɔ wieeri ni, na bu nbem ayi nanzue agɔ Yesu ŋu, na ba fa sanvuin acin akata i nyu­mbaa, na ba bobo i, na ba se i ka, “Wɔrɔ Nyɛmɛ nɔaniɛ kan­fɔ ni, kan kere ya sɔnɔ n bo i boori u ni.” Na tintini­jina­fɔm n gusu afinfin i nyɔɔnu. ");
INSERT INTO cko_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Bu wo nyini kɛrɛ su ni, na Petoro toko wo gisan n nu, na afani be aba i bi, yiri ti Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm kpiɛn n dɛɛ afani kun a. ");
INSERT INTO cko_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Saŋga bo i niɛ ŋuuri Petoro ka i wo sin tuun­biri n ni, na wɔ niɛ Petoro nyunu dika gbirim, na wɔ se i ka, “Wɔrɔ mmɔɔ yo woori nyini Yesu Nazarɛti­fɔ n dɔ ɔ.” ");
INSERT INTO cko_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Na Petoro akete, i ŋa, “Ai, m si má nyini jɔrɛ n bo a sujɔjɔ i ni.” Na wɔ fite gisan n nu aba lɛɛ n nu. Nyini saŋga ni na akɔnyuma abo kpe­kun. ");
INSERT INTO cko_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Na afani n aba aŋu i dɔ, na wɔ kaaki ase minɛm bo bu jina bɛrɛ ni ka, “Ahin sɔnɔ n ti bu nu kun wɔ.” ");
INSERT INTO cko_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ama, na Petoro akete bekun. Wɔ cɛ má na bo bu jina bɛrɛ n gusu ase Petoro ka, “Nahɔrɛ a, a ti bu nu kun wɔ, dama wɔrɔ mmɔɔ ti Galili­fɔ ɔ.” ");
INSERT INTO cko_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Na wɔ tan ndiɛ afa i saa awura sin nu, i ŋa, “M si má sɔnɔ n bo am sujɔjɔ i jɔrɛ ni.” ");
INSERT INTO cko_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Kpeŋga na akɔnyuma n abo kpe nnyɔ su, na Petoro ateŋge su kabo Yesu seeri i ni, i ŋa, “Kana akɔnyuma bá bo kpe nnyɔ su, a kéte kpe nsan su ka a si má m.” Na i ahore asaaki, na wɔ sun. ");
INSERT INTO cko_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Na alecin saŋga na Yuda­fɔm tere­tere­fɔm kɛrɛ atiɛn bu nɔɔ. Bɛrɛ la Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ nkpiɛn­kpiɛnm ni, ni Yuda­fɔm nkpiɛn­kpiɛnm ni, ni Nyɛmɛ nɔaniɛ kere­fɔm ni. Na ba tana asɛsɛ su kabo bu yó Yesu. Na ba wura i jɔrɔkɔ, na ba fa i akɔ ama Gomina Pilato. ");
INSERT INTO cko_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Na Gomina Pilato abisa i ka, “Wɔrɔ ti Yuda­fɔm fɛmɛ n a?” Na wɔ bɔ i nu ka, “Kabo a jɔjɔ ni, i ti sɔ ɔ.” ");
INSERT INTO cko_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Na Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ nkpiɛn­kpiɛnm ni akpiɛ jɔrɛ beberebe asɔ i. ");
INSERT INTO cko_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Na Gomina Pilato abisa i bekun ka, “A la má nɔaniɛ bo a bɔ bu nu? Niɛ jɔrɛ beberebe bo ba kpiɛ asɔ u a.” ");
INSERT INTO cko_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ama, Yesu abɔ má jɔrɛ be nu, na Gomina Pilato abirisi kabo Yesu abɔ má nu ni. ");
INSERT INTO cko_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Afɔ kɛrɛ afɔ Butara cɛɛn­kpiri n nya ba ju ni, Gomina Pilato yi dan­saraka n bo jama n sere i ka i yi i ji n wɔ. ");
INSERT INTO cko_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Nyini saŋga ni sɔnɔ be woori dan­saraka sɔɔ n nu dɔ, bu fere i ka Barabasi. Saŋga be minɛm yo keteeri gomina n ŋu wɔ, na ba tu luɛ, na i ni i beŋgu ketema­fɔ nbem akun minɛm, nyini ti, na ba tara bu anyi bu dan­saraka. ");
INSERT INTO cko_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Tɔ. Kabo afɔ kɛrɛ afɔ Gomina Pilato n yi dan­saraka n kun ma bu ni, na jama n aba atiɛn bu nɔɔ i bi na bu kere sɔnɔ n bo i yí ma bu ni. ");
INSERT INTO cko_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Na Gomina Pilato abisa bu ka, “Am koro ka m yi Yuda­fɔm fɛmɛ ni ma am a?” ");
INSERT INTO cko_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","I seeri sɔ ni, dama i si tenle su ka Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ nkpiɛn­kpiɛnm ni si Yesu kɔrɛ ti ye bu faari i ba wuraari i saa nu a. ");
INSERT INTO cko_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Na Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ nkpiɛn­kpiɛnm n awura jama n bu sin ka bu se Gomina Pilato ka i yi Barabasi ji ma bu. ");
INSERT INTO cko_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Na Gomina Pilato abisa bu ka, “Ye ahin sɔnɔ n bo am fere i ka Yuda­fɔm fɛmɛ ni, am koro ka m yo i sɛ wɔ?” ");
INSERT INTO cko_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Na jama n atiɛn ase ka, “Kpama i baka jaanu n su na i wu.” ");
INSERT INTO cko_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Na Gomina Pilato ase bu ka, “Ye nzu satiɛ ye wɔ yo i a?” Ama, na ba kaaki atiɛn agaya bekun ase ka, “Kpama i baka jaanu n su na i wu.” ");
INSERT INTO cko_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Dɔ na Gomina Pilato akoro ka i jɔ jama n ahore, nyini dɛɛ ti, na wɔ yi Barabasi aji, na wɔ ma sojam afin Yesu ŋgbere, na wɔ nya afa i awura bu saa nu ka bu kɔ kpama i baka jaanu n su na i wu. ");
INSERT INTO cko_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Na ba fa Yesu awura gomina n gisan n nu, na ba fere bu beŋgu sojam kɛrɛ ka bu tiɛn bu nɔɔ. ");
INSERT INTO cko_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Na ba wura Yesu tanlɛɛ kɔkɔrɛ yorom ka fɛmɛya tanlɛɛ su, na ba fa buwe aŋɔ i ka kaba dɛɛ su, na ba fa aforo i tii ka fɛmɛya kere dɛɛ su, adena bu yo i anzasi. ");
INSERT INTO cko_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Na ba yo bu ŋu ka bu suma i jirima, bu ŋa, “Yuda­fɔm Fɛmɛ ni, ya yo u ansɛ.” ");
INSERT INTO cko_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Na bu sufinfin i tii baka, na bu suyi nanzue gɔ i ŋu, na bu sukutu i nyunu. ");
INSERT INTO cko_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Bu ba yoori i anzasi n wieeri ni, na ba yi tanlɛɛ kɔkɔrɛ yorom ni, na ba kaaki afa i tiɛŋgu dɛɛ sutura n awura i. Na ba nya afa i akɔ ka bu kɔ kpama i baka jaanu n su. ");
INSERT INTO cko_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Saŋga bo bu sukɔ ni, na bu ni Sirenefɔ biɛ be ayɛ, bu fere i ka Simon, Alɛkizanda ni Rufusu si lɛɛ. I fite ahɛmɛ suba miɛ kunnu, na sojam n amiɛ i ka i sɔ Yesu baka jaanu ni. ");
INSERT INTO cko_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Na ba fa Yesu akɔ deke bo bu fere i ka Gologota ni, Gologota n bu la ka Tere­awa Woo­biri. ");
INSERT INTO cko_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Na minɛ nbem asaŋga nzan ni ayiri barasu be ama i ka i nu, na i jɔ yaari, ama, wɔ nu má i. ");
INSERT INTO cko_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Bu yoori nyini n kɛrɛ wieeri ni, na ba nya akpama i baka jaanu n su, na ba yɛ i su ajina, na ba tu mbaa na bu si kabo bu kpaaki i suturam nu, bu ŋuŋu nu. ");
INSERT INTO cko_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Bu kpamaari i baka jaanu n su ŋgarama kerefi ŋgɔna a. ");
INSERT INTO cko_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Na ba kɛrɛ jɔrɛ n bo bu kpiɛ sɔɔri i ni, na ba fa abo akpama i baka jaanu n tii su, kɛrɛɛ­wa n la ka, “Yuda­fɔm Fɛmɛ n lɛɛ.” ");
INSERT INTO cko_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Na ba kpama fin­fɔ nnyɔ nbem baka jaanu su adodo i, bu kpamaari kun i saa fɔmbɔrɔ su wɔ, na ba kpama kun n gusu i saa biɛ su. ");
INSERT INTO cko_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Na minɛm kɛrɛ bo bu sin dɔ ni subobo bu tii, na bu sukpiɛ i nzukɔ, bu ŋa, “Ɛɛnhɛɛn, wɔrɔ bo a ŋa a fúfu Nyɛmɛ Seree­biri Awuru n na a káaki ta i le­san afiɛn n lɛɛ, ");
INSERT INTO cko_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","jura baka jaanu n su na a de u tii ji.” ");
INSERT INTO cko_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Na Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ nkpiɛn­kpiɛnm ni, ni Nyɛmɛ nɔaniɛ kere­fɔm ni gusu suyo i anzasi bu ŋuŋu nu, bu ŋa, “Wɔ de minɛm tii aji, ama, i sukoro de má yiri ni i tii. ");
INSERT INTO cko_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Am ma ya niɛ Yisareli­fɔm Fɛmɛ n bo i ŋa i ti Kristo Tii­de­fɔ ni, nzɛn i koro juraari baka jaanu n su kisa kisa, ya yó i yarada.” Na minɛ nnyɔm ni bo bu kpamaari bu dodoori i ni mmɔɔ akpiɛ i nzukɔ. ");
INSERT INTO cko_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Wiɛsu kerefi buru ni nnyɔ saŋga na awosin akata asiɛn n kɛrɛ su, haari naasɔ kerefi nsan. ");
INSERT INTO cko_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Na nyini saŋga ni, na Yesu abo awie kpa ase ka, “Eli, Eli, lama sabatani?” I bu la ka, “M Nyɛmɛ, m Nyɛmɛ, nzu ti ye a yaki m aji a?” ");
INSERT INTO cko_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Na minɛm nbem jinaari bɛrɛ, bu nbem n tiiri sɔ ni, na ba se ka, “Am so am sui na am ti, i sufere Eliya.” ");
INSERT INTO cko_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Na bu kun nu aŋmati afa mɛnɛ adɔ nzan gagaraki be nu, na wɔ fa awɔ baka su alaandi atɔ Yesu nɔɔ ka i nu, na wɔ se ka, “Am yaki i na ya niɛ, ka Eliya bá jura i baka jaanu n su.” ");
INSERT INTO cko_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Na Yesu abo awie kpa kpe­kun, na wɔ nya ayo Nyɛmɛ dɛɛ. ");
INSERT INTO cko_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Na tani bambaka n bo bu fa kpaakiiri sɔɔ casi n bo i wo Nyɛmɛ Seree­biri Awuru n nu n ati nu nnyɔ, fa i aŋgoro kɔ jura asiɛŋgu. ");
INSERT INTO cko_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Na soja kpiɛn n bo i jinaari baka jaanu n nyunu ŋuuri kabo Yesu boori awie na i wuuri barasu ni, na wɔ se ka, “Ahin sɔnɔ n ti Nyɛmɛ Wa a nahɔrɛ su.” ");
INSERT INTO cko_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Na nbara nbem ajina dede suniɛ Yesu. Bu nu nbem la Mariya bo i fite Magadala miɛ n nu ni, ni Salome, ni Mariya n bo i nbaam la Yakobo kaan n ni Yose. ");
INSERT INTO cko_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Bɛrɛ yo suuri Yesu su wɔ saŋga bo i wo Galili awɔrɛ n nu na bu subuka i. Nbaram beberebe gusu yo woori dɔ bo bu suuri i su baari Yɛrusalem miɛ kpiri n nu. ");
INSERT INTO cko_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Kabo nyini cɛɛn n tiiri Ŋumi­yi cɛɛn n kpokpo cɛɛn ni, i naasɔ wiɛ, ");
INSERT INTO cko_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","na Yosefu bo i fite Aramatiya miɛ kpiri n nu ni, na wɔ fa ahoresi na wɔ kɔ aŋu Gomina Pilato, na wɔ sere i ka i fa Yesu ŋuniɛ n ma i. Yosefu yo ti sɔnɔ jirima­fɔ ɔ Yuda­fɔm tere­tere­fɔm n nu, na i sunsunni kɛrɛ yo la ka, i ŋminda saŋga bo Nyɛmɛ bá di i fɛmɛya n wɔ. ");
INSERT INTO cko_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Gomina Pilato tiiri kabo wɔ se ni, na wɔ yo alekutura kabo Yesu akaba awu ni. Na wɔ sunma afere soja kpiɛn n na i bisa i na i ti ka Yesu wuuri ni, wɔ cɛ? ");
INSERT INTO cko_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","I tiiri soja n nɔaniɛ wieeri ni, na wɔ ma Yosefu atin ka i kɔ fa i ŋuniɛ ni. ");
INSERT INTO cko_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Na Yosefu ato nzee, na wɔ yi fuin n baka jaanu n su, na wɔ fa nzee ni apɔɔndi i. Na wɔ kɔ afa i awura yabuɛ buɛ bo ba lokoti i ayo i faŋ­kunma n nu, na wɔ fa i ase nu, na wɔ kundu yabuɛ bambaka afa atɔ faŋ­kunma n anɔ ni. ");
INSERT INTO cko_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Na Mariya Magadala­fɔ ni, ni Mariya n bo i wa la Yose ni ajina aniɛ aŋu deke bo bu seeri Yesu ni. ");
INSERT INTO cko_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Na naasɔ saŋga bo Ŋumi­yi cɛɛn n asin ni, na Mariya Magadala­fɔ ni, ni Salome, ni Mariya n bo i wa la Yakobo ni, aba ato tulaalɛɛ nva­nvani ka bu fa kɔ gɔ Yesu ŋuniɛ n su. ");
INSERT INTO cko_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Na Yuda­fɔm bakuɛ n bumboori, mɔnɛ cɛɛn ŋgarama fuun, fa kɔ wiɛ tiɛ saŋga, na ba kɔ Yesu faŋ­kunma n su. ");
INSERT INTO cko_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Saŋga bo bu sukɔ ni, na ba bisa bu beŋgu ka, “Ŋma kɔ́ kundu yi yabuɛ n bo i tɔ faŋ­kunma n anɔ n ma ya?” ");
INSERT INTO cko_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Deke bo i ti na bu seeri sɔ n la ka, yabuɛ n ti bambaka agaya. Na ba tu bu tii aniɛ aŋu ka yabuɛ n tɔ má anɔ ni. ");
INSERT INTO cko_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Na ba wura yabuɛ buɛ faŋ­kunma n nu aŋu ka gbɛfɛnɛ be tana nu saa fɔmbɔrɔ su, i wura tanlɛɛ fofoe yorom be, na ba yo alekutura. ");
INSERT INTO cko_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Na wɔ se bu ka, “Má am yo alekutura. M si ka am niɛniɛ Yesu Nazarɛti­fɔ n bo bu kpamaari i baka jaanu n su n wɔ. Wɔ teŋge i yiwee n nu. I wo má fɛn. Am niɛ, deke bo bu faari i seeri n yaa. ");
INSERT INTO cko_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Am kpie am nyi na am kɔ se Petoro ni nyiŋgam n kɛrɛ ka wɔ du am mɔ sukɔ Galili, dɔ ye am kɔ́ ŋu i a, dama kabo i yo seeri am lɛɛ.” ");
INSERT INTO cko_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Na ba fite faŋ­kunma n nu ni ŋmatiiri, na bu ŋuniɛ subobo bu ni sɛrɛ. Ba bo má su ase má be, dama sɛrɛ ati bu agaya.  ");
INSERT INTO cko_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Mɔnɛ cɛɛn ŋgarama fuun ye Yesu teŋgeeri i yiwee n nu a. I du mɔ yiiri i ŋu kereeri Mariya Magadala­fɔ n wɔ. Yiri la bara n bo Yesu fɔn yiiri ajini nsom i ŋu ni. ");
INSERT INTO cko_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Na wɔ kɔ atu Yesu susu­fɔm ni ka bu wo ahoresaaki ni sun su, na wɔ se bu ka wɔ ŋu Yesu. ");
INSERT INTO cko_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Saŋga bo i seeri bu ka Yesu ateŋge i yiwee n nu na wɔ ŋu i ni, ba de má i nɔaniɛ ni. ");
INSERT INTO cko_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Nyini sin na Yesu susu­fɔ nnyɔ nbem afite Yɛrusalem miɛ kpiri n nu sukɔ ahɛmɛ, na wɔ yi i ŋu akere bu, bo ba koro afa má nu nde ka yiri lɛɛ. ");
INSERT INTO cko_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Na ba kpie bu nyi aba ase nyiŋgam n ka ba ŋu Yesu, ama, haari ni nyini mmɔɔ, ba de má. ");
INSERT INTO cko_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Nyini kɛrɛ sin na saŋga bo i susu­fɔ buru ni kunm n wo diire di su ni, na wɔ yi i ŋu akere bu. Na wɔ jaraki bu kabo bu ahore­mbaa ti kekereke ni, ni kabo ba yo má yarada ni minɛm bo bu ŋuuri i saŋga bo i teŋgeeri i yiwee n nu na bu ba seeri bu ni. ");
INSERT INTO cko_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Na wɔ se bu ka, “Am kɔ durunya n kɛrɛ nu na am kɔ kan m labari kpa n kere adamande kɛrɛ. ");
INSERT INTO cko_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Na sɔnɔ kɛrɛ bo i yoori m yarada, na am biɛɛri i Nyɛmɛ nzue, Nyɛmɛ dé i tii ji, ama, bo ba yo má yarada ni, Nyɛmɛ dí bu jɔrɛ na i yó bu ŋgbɛɛn. ");
INSERT INTO cko_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Na bo bu yoori yarada, bu nyá yiko bo bu koro yó ahin alekutura sam ni. Bu fá m duma fɔn yi ajinim fite minɛm n ŋu, na bu jɔ́jɔ aniɛ barasu barasu bo bu si má bu, ");
INSERT INTO cko_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","na nzɛn bu taraari woom wara bu diiri neŋge dii­wa n mmɔɔ, i yó má bu pui. Bu fá bu saa nana tukpaki­fɔm ŋu, na bu nyá laifiɛ.” ");
INSERT INTO cko_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Saŋga bo Mibiɛ Yesu jɔjɔɔri bu dɔ wieeri ni, na Nyɛmɛ afa i afun akɔ aŋgoro akɔ atana i saa fɔmbɔrɔ su. ");
INSERT INTO cko_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Na i susu­fɔm n akɔ deke n kɛrɛ kɔ sukan i labari kpa ni, na Mibiɛ n awo bu dɔ abuka bu, na wɔ ma bu yiko, na ba yo alekutura sam bo i kere ka bu labari kpa kaan­wa n kɛrɛ ti nahɔrɛ wɔ.");
INSERT INTO cko_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ya si Teyofilosi, minɛ dɔŋgu boroori bu nyi na ba kɛrɛ sam bo bu yoori ya nu fɛn n afa ase. ");
INSERT INTO cko_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Kabo jɔrɛ n ti na bu kɛrɛɛri i ni, yiri ye minɛm seeri ya n a, nyini minɛm bo bu woori i bumboori ni, bɛrɛ ŋuuri i a, bɛrɛ kaanri a. ");
INSERT INTO cko_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Tɔ, kabo mini ni m tii ayi kɔrɛsi aniɛ sereya n kɛrɛ, fite saŋga n bo jɔrɛ n boori i bu ni, ma ŋu ka i ti kpa ka mini gusu kɛrɛ i kɛrɛ sɛsɛ i su na i kɔ atin su fa ma wɔrɔ Teyofilosi bo a la anyunuyi ni, ");
INSERT INTO cko_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","adena a si ka bo ba kan akere u n kɛrɛ ti nahɔrɛ wɔ. ");
INSERT INTO cko_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Saŋga bo Herode yo ti Yudiya fɛmɛ ni, Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ be wo bɛrɛ, bu fere i ka Zakariya. I fite Abiya dɛɛ Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm asɛsɛ n nu wɔ. Bu fere i yi duma ka Elizabɛti, yiri mmɔɔ ti Aarɔn busu nu­fɔ ɔ. ");
INSERT INTO cko_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Bɛrɛ nnyɔm kɛrɛ yo ti minɛm bo bu su Nyɛmɛ nahɔrɛ su wɔ, na bu deeri i nɔaniɛ maa­wam ni, na bu yoori dekem kɛrɛ bo i se ka minɛm yo i ni. ");
INSERT INTO cko_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ama, ba wu má baa, dama Elizabɛti ti ŋɔrɔka a, na bekun i ni i hun n kɛrɛ ayo nkpiɛnm agaya. ");
INSERT INTO cko_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Cɛɛn n be, na Zakariya awo Yuda­fɔm Nyɛmɛ Seree­biri Awuru n Sɔɔ Casi n nu suyo i Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ juma, dama nyini cɛɛn n ti bu dɛɛ busu nu­fɔm cɛɛn wɔ. ");
INSERT INTO cko_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm la bu nana sa­yoo­wa be. Bu tu mbaa a, na bu yi bu nu kun. Nyini cɛɛn ni, bu yiiri Zakariya a, ka i wura bu Nyɛmɛ Seree­biri Awuru n Sɔɔ Casi n nu, na i kunkun ayiri kunkuun­wa nva­nvani. Nyini ti, na wɔ kɔ awura nu. ");
INSERT INTO cko_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ayiri nva­nvani n kunkun saŋga ba juuri ni, na jama kɛrɛ aka gisan nu susere Nyɛmɛ. ");
INSERT INTO cko_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Na Nyɛmɛ mɛrɛkɛ aba ayi i ŋu akere Zakariya, i jina Mikun n yoo­wa yoo­biri fɔmbɔrɔ su, deke bo wɔ kunkun ayiri nva­nvani n ni. ");
INSERT INTO cko_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","I ŋuuri mɛrɛkɛ n sɔ ni, na wɔ bo biri, na sɛrɛ ati i. ");
INSERT INTO cko_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ama, na mɛrɛkɛ n ase i ka, “Zakariya, má a ma sɛrɛ ti u. Nyɛmɛ ade u sere ni. U yi Elizabɛti bá wu baa­biɛsɔ, na a tún i duma ka Yohane. ");
INSERT INTO cko_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Baa n bo i wú i n dɛɛ ti, u ahore jɔ́ agaya kɔ sin su, na minɛ dɔŋgu gusu ahore jɔ́. ");
INSERT INTO cko_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Baa ni bá yo sɔnɔ bambaka a Nyɛmɛ dɔ. Wɔ yo má daka ka i nu nzan fieo. Haari i ni kunnu, ye Nyɛmɛ Awiɛwiɛ Casi ni wúra i ŋu a. ");
INSERT INTO cko_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Na i má Yisareli busu nu­fɔm dɔŋgu kpie bu nyi ba yiri Micɛra Nyɛmɛ n bo i ti ye ni ka bu su i n dɔ. ");
INSERT INTO cko_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Awiɛwiɛ Casi n faŋga wó yiri ŋu ka Nyɛmɛ nɔaniɛ kan­fɔ Eliya a, yiri dú Micɛra nyunu a, adena i yó nbaasim ni bu nbaam afiɛn dɔŋgu a, na i káaki minɛ ketee­wam sunsunni, na bu yó minɛ kpam, na i sɛ́sɛ Nyɛmɛ minɛm su se i.” ");
INSERT INTO cko_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Na Zakariya ase Nyɛmɛ mɛrɛkɛ n ka, “Nzu deke ye m fá si ka jɔrɛ n bo a sujɔjɔ i ni yó nahɔrɛ a? Dama ma yo kpiɛn, m yi gusu ayo buke.” ");
INSERT INTO cko_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Na mɛrɛkɛ n ase i ka, “Bu fere m ka Gabiriyeli. Mini wo Nyɛmɛ nyunu a. Ye wɔ sunma m u dɔ ka m fa ahin labari kpa n ba ma u a. ");
INSERT INTO cko_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ti fɛn. Nɔaniɛ n bo m sujɔjɔ i ni bá yo nahɔrɛ wɔ, saŋga bo Nyɛmɛ koro ka i yo ni. Ama, a yo má m nɔaniɛ n yarada dɛɛ ti, a tɔ́ amuna, na a kóro jɔjɔ má haari cɛɛn bo a bá ŋu ka nɔaniɛ n bo m sujɔjɔ i n ayo nahɔrɛ.” ");
INSERT INTO cko_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Nyini saŋga n kɛrɛ minɛm n toko jina gisan nu ŋminda Zakariya, na ba birisi deke bo i ti na wɔ cɛ Sɔɔ Casi n nu sɔ ni. ");
INSERT INTO cko_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Saŋga bo i ba fiteeri ni, wɔ koro ajɔjɔ má bu dɔ. Dɔ na ba fa nu ka wɔ ŋu alekutura deke be Sɔɔ Casi n nu. Dama wɔ koro ateke má i nɔɔ ajɔjɔ má, se i fa i saa jɔjɔ bu dɔ a. ");
INSERT INTO cko_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Saŋga bo Zakariya ba yoori i juma kɛrɛ wieeri Nyɛmɛ Seree­biri Awuru n nu ni, na wɔ kpie i nyi akɔ i bɔsu. ");
INSERT INTO cko_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Wɔ cɛ má, na i yi Elizabɛti anyinsɛ. Wɔ yi má i ŋu fofoe nu haari sara nnu. ");
INSERT INTO cko_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Na wɔ se ka, “Kisa, ya Micɛra n aniɛ aŋu m aŋunfɔ. Wɔ yi m afite nyinsɛ bambaka nu.” ");
INSERT INTO cko_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Saŋga bo Elizabɛti nyinsɛ n ba juuri sara nsɛn ni, na Nyɛmɛ asunma mɛrɛkɛ Gabiriyeli miɛ be bo i wo Galili awɔrɛ n nu, na bu fere i ka Nazarɛti ni, ");
INSERT INTO cko_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ka i kɔ fa labari ma suŋguru be bo bu fere i ka Mariya ni. Nyini saŋga, ba fa i ace biɛsɔ be, bu fere i ka Yosefu, i fite Fɛmɛ Davidi dɛɛ busu n nu wɔ. I ni Mariya nya saŋga da má, dama wɔ nya ja má i. ");
INSERT INTO cko_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Na mɛrɛkɛ n awura i ŋu, na wɔ se i ka, “Suŋguru, m yo u ansɛ ni tere­fiɛ. A di Nyɛmɛ ahɔrɔma, na i kaaki wo u dɔ.” ");
INSERT INTO cko_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mariya tiiri ahin nɔaniɛ n ni, na wɔ yo i alekutura, na wɔ birisi ase ka, “Ahin ansɛ yoo­wa n bu la ka sɛ wɔ lɛɛ?” ");
INSERT INTO cko_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Na mɛrɛkɛ n ase i ka, “Mariya, má a ma sɛrɛ ti u. A di Nyɛmɛ ahɔrɔma beberebe. ");
INSERT INTO cko_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","So u sui na a ti. M ŋa a bá nyinsɛ, na a wú baa­biɛsɔ, na a tún i duma ka Yesu. ");
INSERT INTO cko_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","I bá yo sɔnɔ bambaka, na bu fere i ka, Nyɛmɛ Fɛmɛ Kpiri n Wa. Ya Micɛra Nyɛmɛ fá i na Davidi fɛmɛya biɛ ma i, ");
INSERT INTO cko_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","na i yó Jakɔbu busu nu­fɔm fɛmɛ saŋga kɛrɛ, na i dɛɛ fɛmɛya ni lá má awieeri.” ");
INSERT INTO cko_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Na Mariya abisa mɛrɛkɛ n ka, “Ye ahin yó sɛ koro yo a? Dama m nya si má biɛsɔ.” ");
INSERT INTO cko_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Na mɛrɛkɛ n abɔ i nu ka, “Nyɛmɛ Awiɛwiɛ Casi ni bá wura u ŋu, na Nyɛmɛ dɛɛ yiko n bá wo u dɔ. Nyini ti, baa n bo a wú i ni, i bá yo baa casi wɔ, na bu fére i ka Nyɛmɛ Wa. ");
INSERT INTO cko_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Niɛ fɛn, Elizabɛti bo i ti u lamɔkɔ ni, yiri bo bu ŋa i ti ŋɔrɔka ni, haari ni bo wɔ yo buke ni, wɔ nyinsɛ, i sara nsɛn lɛɛ. ");
INSERT INTO cko_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Pui wo má bɛrɛ bo Nyɛmɛ koro yo má i.” ");
INSERT INTO cko_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Na Mariya ase i ka, “Tɔ, m ti Micɛra n afani wɔ. Ma nyini sam kɛrɛ yo ma m kabo a se ni.” Na mɛrɛkɛ n akɔ ayaki i. ");
INSERT INTO cko_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Nyini dɛɛ sin, wɔ cɛ má, na Mariya akpa i ŋu, na wɔ yasu ndende akɔ Zakariya ni i yi Elizabɛti bɔsu ka i kɔ niɛ bu busu. Nyini miɛ n wo Yudiya asiɛn n su bukam n afiɛn wɔ. ");
INSERT INTO cko_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Na wɔ kɔ awura Zakariya dika, na wɔ yo Elizabɛti ansɛ. ");
INSERT INTO cko_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elizabɛti tiiri Mariya ansɛ yoo­wa n ni, na baa n bo i wo i kunnu n akpisi i ŋu. Dɔ na Awiɛwiɛ Casi n awura Elizabɛti ŋu, ");
INSERT INTO cko_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","na wɔ bo awie kpa, i ŋa, “Nyɛmɛ ayo u kisi atara nbaram kɛrɛ, wɔ kaaki ayo baa n bo a bita i nyinsɛ n kisi. ");
INSERT INTO cko_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nzu jirima la ahin n bo Nyɛmɛ afa ama m n a, ka m Mibiɛ dɛɛ ni aba aniɛ m busu a? ");
INSERT INTO cko_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Dama m tiiri u ansɛ yoo­wa n na baa n bo i wo m kunnu ni, akaba akpisi i ŋu ni akunnujɔ. ");
INSERT INTO cko_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Tere­fiɛ wo u dɔ, dama a yo yarada ka Mibiɛ n nɔaniɛ n bo wɔ kan akere u ni, i bá yo yii­wa aŋgba.” ");
INSERT INTO cko_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Na Mariya ase ka, “M kansi Mibiɛ ni m ahore­mbaa su. ");
INSERT INTO cko_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","M ahore ajɔ Nyɛmɛ ŋu, yiri bo i ti m Tii­de­fɔ ni. ");
INSERT INTO cko_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Haari ni bo m ti i afani n kɛrɛ ni, i wara afi má m sa. Fite nyuma fa kɔ, minɛm kɛrɛ bá fere m ka tere­fiɛ­fɔ. ");
INSERT INTO cko_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Dama ka Micɛra yiko kɛrɛ fɔ ni ayo sakpa beberebe ama m, i duma ti casi. ");
INSERT INTO cko_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Saŋga kɛrɛ saŋga i si aŋunfɔ ɔ, i si minɛm bo bu soro i n kɛrɛ aŋunfɔ ɔ. ");
INSERT INTO cko_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Wɔ fa i yiko asaa ni, afɔn asandi karambani­fɔm, ni bu sunsunni tiɛ n kɛrɛ. ");
INSERT INTO cko_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Wɔ yi nfɛmɛ bambakam afite bu fɛmɛya biɛm n su, na wɔ yɛ tarakam saa su. ");
INSERT INTO cko_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Wɔ ma ahɔɛ­fɔm neŋge kpakpam na bu kunnu ayi, na wɔ fɔn neŋge­fɔm na ba ka bu saa ŋgbɛɛn. ");
INSERT INTO cko_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Sɛsɛ­su n bo i yo faari na i diiri i di ni ya nam ni, wɔ ma i ayo yii­wa, ye wɔ ba abuka Yisareli­fɔm bo bu su i ni. I wara afi má Abraham sa. Wɔ si i ni i sin­fɔm kɛrɛ aŋunfɔ saŋga kɛrɛ.” ");
INSERT INTO cko_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Na Mariya aka Elizabɛti bi, sara nsan, na wɔ nya aba akaaki akɔ i bɔsu. ");
INSERT INTO cko_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elizabɛti kutu cɛɛn ni, na wɔ wu baa­biɛsɔ. ");
INSERT INTO cko_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Na Elizabɛti tana­fɔm, ni i lamɔsim tiiri ka Micɛra n ayo i sakpa bo i la má aŋusu ni, na bu ni yiri kɛrɛ kunnu ajɔ. ");
INSERT INTO cko_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Baa n le­mɔcuɛ cɛɛn n ba juuri ni, na ba tiɛn bu nɔɔ na bu wura i kɛnkɛnnɛ, na bu tun i duma. Má bu koro ka bu fa i si Zakariya duma fa tun i a. ");
INSERT INTO cko_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ama, na i ni ase ka, “Ai, bu fére i ka Yohane wɔ.” ");
INSERT INTO cko_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Na ba se i ka, “U lamɔsi nu, bu fere ŋma sɔ a?” ");
INSERT INTO cko_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Na ba fa bu saa ajɔjɔ baa n si n dɔ, na bu si duma bo i koro ka bu fa tun i wa ni. ");
INSERT INTO cko_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Dɔ na Zakariya afa i saa akere ka, bu má i deke be na i kɛrɛ, na wɔ de i na wɔ kɛrɛ ka, “I duma la Yohane.” Na nyini jɔrɛ n ayo bu kɛrɛ alekutura. ");
INSERT INTO cko_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Jina n nu bɛrɛ, na Nyɛmɛ ateke i nɔɔ na wɔ bo i bu ajɔjɔ bekun, na i sukansi Nyɛmɛ. ");
INSERT INTO cko_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Na sɛrɛ ati bu tana­fɔm kɛrɛ. Na minɛm akan nyini sa n bo i yoori n jɔrɛ abara ayɛ Yudiya awɔrɛ n bukam n kɛrɛ su. ");
INSERT INTO cko_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Na minɛm kɛrɛ bo bu tiiri i n afa jɔrɛ n ase bu ahore su na bu susunsun, na ba bisa bu ŋu ka, “Baa n ba nyiiri, i yó nzu baa lɛɛ?” Bu seeri sɔ ni, dama bu kɛrɛ aŋu ka Micɛra n yiko n wo i ŋu. ");
INSERT INTO cko_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Na Awiɛwiɛ Casi n awura baa n si Zakariya ŋu, na wɔ kan Nyɛmɛ nɔaniɛ, i ŋa, ");
INSERT INTO cko_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Am ma ya kansi ya Micɛra ni, yiri bo i ti Yisareli­fɔm Nyɛmɛ ni. Dama ka wɔ ba aniɛ i minɛm busu, na wɔ de bu tii aji. ");
INSERT INTO cko_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Wɔ ma ya tii­de­fɔ faŋga­fɔ, i fite i amusui­su­fɔ Fɛmɛ Davidi dɛɛ busu n nu wɔ. ");
INSERT INTO cko_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Nyɛmɛ yo maari i nɔaniɛ kan­fɔ casim jɔjɔɔri dawa saŋga ");
INSERT INTO cko_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ka i bá de ya tii fite ya kpɔ­fɔm, ni bo bu koro má ya n saa nu. ");
INSERT INTO cko_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Sɔ ye i kereeri ka i si ya nam aŋunfɔ, na i wara fi má i sɛsɛ­su casi n sa a. ");
INSERT INTO cko_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","I yo faari nyini sɛsɛ­su n na wɔ di i di ni ya na Abraham ka i de ya tii fite ya kpɔ­fɔm saa nu, adena ya koro su i bo ya soro má sɛrɛ, ");
INSERT INTO cko_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","na ya yo casi na ya yo sa bo i kɔ atin n su i dɔ, haari ni ya ŋgɔɔ awieeri. ");
INSERT INTO cko_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Wɔrɔ, m wa ni, bu bá fere u ka Micɛra Nyɛmɛ Kpiri n dɛɛ nɔaniɛ kan­fɔ. Dama a dú ya Micɛra n mɔ na a kɔ́ sɛsɛ i atin su ŋminda i. ");
INSERT INTO cko_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Na a má i minɛm si ka i fá bu satiɛ ce bu n dɛɛ ti, ye i dé bu tii ji a. ");
INSERT INTO cko_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Dama Nyɛmɛ si ya aŋunfɔ agaya n dɛɛ ti, i má aŋgoro wein n ta ma ya. Nyini wein n ti kabo wiɛ fite na i ti n wɔ, ");
INSERT INTO cko_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","na i má wein ta ma minɛm bo bu wo awosin nu na bu soro yiwee sɛrɛ ni. Na i bá kere ya atin bo i ma ahoreda.” ");
INSERT INTO cko_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Na baa n anyi, na Nyɛmɛ ayo i sunsunni faŋga, na wɔ kɔ awo boro kpantain nu dɔ i ŋumi, haari cɛɛn n bo i ba yiiri i ŋu fiteeri fofoe nu kere Yisareli­fɔm ni. ");
INSERT INTO cko_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Nyini saŋga na Roma­fɔm fɛmɛ kpiri n bo bu fere i ka Siza Agusito ni, ama nɔɔ ka bu kɛrɛ i minɛm kɛrɛ duma. ");
INSERT INTO cko_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Nyini saŋga ni tiiri ciciri su dɛɛ minɛm duma kɛrɛɛ­wa n ŋusu a. Nyini saŋga n ye sɔnɔ be bo bu fere i ka Kurenɔsi n ti Siriya awɔrɛ n nu gomina n a. ");
INSERT INTO cko_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Nyini ti, na deke bo sɔnɔ kɛrɛ wo na ba kɔ bu na miɛ su na bu kɔ kɛrɛ bu duma. ");
INSERT INTO cko_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Dɔ na Yosefu gusu afite Nazarɛti miɛ n bo i wo Galili awɔrɛ n nu ni, na i kɔ kɛrɛ i duma. I kɔɔri miɛ n bo bu fere i ka Bɛtilɛhɛm na i wo Yudiya awɔrɛ n nu wɔ, dɔ ye bu wuuri Fɛmɛ Davidi a. Yosefu ti Fɛmɛ Davidi dɛɛ busu nu­fɔ n ti ye i kɔɔri awɔrɛ n nu dɔ a. ");
INSERT INTO cko_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","I ni Mariya bo ba fa ace i ni kɔɔri a. Nyini saŋga ni, Mariya bita nyinsɛ. ");
INSERT INTO cko_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Bu wo dɔ n na saŋga n aju bo Mariya wu baa. ");
INSERT INTO cko_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ba nya má fofoe wɔfɔm daa­biri n nu bo bu da. Nyini ti, na ba kɔ awura deke bo bu fa neŋge­ndɔrɛm wura, dɔ na wɔ wu i suŋguru baa, baa­biɛsɔ. Na wɔ fa baa n apɔɔndi sanvuin nu, na wɔ fa i ada neŋge­ndɔrɛm diire dii­biri alaka nu. ");
INSERT INTO cko_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Nbɔɛ­sasa­fɔm nbem wo nyini awɔrɛ n nu dɔ suniɛ bu nbɔɛm dika, kɔŋguɛ, ");
INSERT INTO cko_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","na Micɛra n mɛrɛkɛ akaba atiɛ bu ŋu, na Micɛra n ama i wein ata abara ayɛ bu, na sɛrɛ ati bu agaya, ");
INSERT INTO cko_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","ama, na mɛrɛkɛ n ase bu ka, “Má am ma sɛrɛ ti am. Ma ba ka m ba ma am labari kpa a. Nyini labari ni, yiri má minɛm kɛrɛ ahore jɔ agaya. ");
INSERT INTO cko_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ahin kɔŋguɛ n nu bɛrɛ, ba wu am Tii­de­fɔ ni, Fɛmɛ Davidi bɔsu n nu, yiri ti Kristo n bo Nyɛmɛ ase ka i súnma i n a, am Mibiɛ ni. ");
INSERT INTO cko_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Deke bo i kere am na am sí nu n la ka, am kɔ́ ŋu ka ba fa i apɔɔndi sanvuin nu afa i ada neŋge­ndɔrɛm diire dii­biri alaka nu.” ");
INSERT INTO cko_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Jinaa­biri n nu bɛrɛ na mɛrɛkɛm beberebe akaba afite aŋgoro abuka nyini kun n su, na bu sukansi Nyɛmɛ, bu ŋa, ");
INSERT INTO cko_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Kansi wo Nyɛmɛ bo i wo aŋgoro n dɔ. Na ahoreda wo minɛm bo bu wo asiɛŋgu fɛn n dɔ na Nyɛmɛ ahore ajɔ bu ŋu ni.” ");
INSERT INTO cko_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Saŋga bo mɛrɛkɛm n fiteeri bu dɔ kpieeri bu nyi kɔɔri aŋgoro ni, na nbɔɛ­sasa­fɔm ni ase bu ŋuŋu nu ka, “Am ma ya kɔ Bɛtilɛhɛm miɛ n nu na ya kɔ ŋu deke n bo wɔ yo na Micɛra n ayi akere ya ni.” ");
INSERT INTO cko_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Nyini ti, na ba kɔ ndende, na ba kɔ aŋu Mariya ni Yosefu, na ba ŋu baa n gusu ka i da neŋge­ndɔrɛm diire dii­biri alaka n nu. ");
INSERT INTO cko_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Saŋga bo bu kɔ ŋuuri baa n ni, na ba kan nɔaniɛ n kɛrɛ bo mɛrɛkɛ n fa maari bu fa kɔ baa n ŋusu jɔrɛ n akere minɛm. ");
INSERT INTO cko_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Na minɛm kɛrɛ bo bu tiiri kabo nbɔɛ­sasa­fɔm seeri bu ni, n ayo alekutura. ");
INSERT INTO cko_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Na Mariya afa nyini sereya n kɛrɛ bo i yoori ni ase i ahore su. ");
INSERT INTO cko_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Na nbɔɛ­sasa­fɔm n akpie bu nyi akɔ bu nbɔɛm n bi, na bu sukansi Nyɛmɛ na bu subo tuntun i fa kɔ deke n kɛrɛ bo ba ŋu i na ba ti i n dɛɛ ti. Deke n kɛrɛ yoori kabo mɛrɛkɛ n seeri bu n wɔ. ");
INSERT INTO cko_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Saŋga bo le­mɔcuɛ cɛɛn n ba juuri ni, na ba wura baa n kɛnkɛnnɛ, na ba tun i duma ka Yesu. Duma n bo mɛrɛkɛ n fa maari i ka, na i ni nyinsɛɛri i n lɛɛ. ");
INSERT INTO cko_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Na cɛɛn n aju bo Yosefu ni Mariya kɔ yo bu fin ŋmisi sa­yoo­wa kabo Nyɛmɛ nɔaniɛ kpamaa­wa n bo i fa maari Moyisi n kereeri ka bu yo ni. Nyini ti, na ba fa baa n akɔ Yɛrusalem miɛ kpiri n nu na bu kɔ fa i wura Micɛra n saa nu. ");
INSERT INTO cko_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Kabo ba kɛrɛ i Micɛra n nɔaniɛ kpamaa­wa n nu ni, ba kɛrɛ ka, “Baa­biɛsɔ kɛrɛ bo i ti i ni suŋguru baa, i ti ye ni ka bu fa i kɔ ma Micɛra ni, na i yó i dɛɛ.” ");
INSERT INTO cko_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Na ba kɔ ayo yoo­wa, kabo Micɛra n nɔaniɛ kpamaa­wa n akere ka bu yo i ni, bu faari bumbuku wara tiiwa nnyɔ yoori yoo­wa n a. ");
INSERT INTO cko_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Nyini saŋga ni, sɔnɔ be wo Yɛrusalem, bu fere i ka Simeyon. I yo ti sɔnɔ bo i yo sa bo i kɔ atin su Nyɛmɛ dɔ ɔ, na i ti sɔnɔ bo i soro Nyɛmɛ, na i ŋminda fa kɔ saŋga bo Yisareli­fɔm nya bu tii­de n wɔ. Na Awiɛwiɛ Casi n wo i ŋu. ");
INSERT INTO cko_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Na Awiɛwiɛ Casi n ama wɔ si ka i wú má, má ka i nyu­mbaa aba aŋu Kristo ni, Tii­de­fɔ n bo Micɛra n ase ka i súnma i ni. ");
INSERT INTO cko_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Na Awiɛwiɛ Casi n ama Simeyon akɔ Nyɛmɛ Seree­biri Awuru n nu. Nyini saŋga n ye Yesu si ni i ni gusu afa i akɔ ka bu kɔ yo yoo­wa kabo Nyɛmɛ nɔaniɛ kpamaa­wa n akere ka bu yo n a. ");
INSERT INTO cko_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeyon ŋuuri baa n sɔ ni, na wɔ kaba ade baa ni i saa nu, na wɔ kansi Nyɛmɛ, i ŋa, ");
INSERT INTO cko_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“M Mibiɛ, u nɔaniɛ n bo a yo seeri m ni, ayo yii­wa, ma mini u akɔɔ n atin kisa na m fíte durunya n nu ni ahoreda. ");
INSERT INTO cko_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Dama kisa mini ni m tii nyu­mbaa aŋu Tii­de­fɔ ni, ");
INSERT INTO cko_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","yiri ye a sɛsɛ i su, ye a ma minɛm kɛrɛ nyu­mbaa aŋu i a. ");
INSERT INTO cko_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Yiri ti wein n a, na i kére minɛm u atin ni, bɛrɛ bo bu ti má Yuda­fɔm ni, na i wúra Yisareli­fɔm kpiri, bɛrɛ bo bu ti u dɛɛ minɛm ni.” ");
INSERT INTO cko_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simeyon jɔjɔɔri baa n jɔrɛ sɔ ni, na i si ni i ni ayo alekutura. ");
INSERT INTO cko_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Na Simeyon asere Nyɛmɛ, na wɔ yo bu kisi. Na wɔ se baa n ni ka, “Ahin baa n ye Nyɛmɛ ayi i ka i má Yisareli­fɔm dɔŋgu kpaasi, na dɔŋgu gusu yásu n a. Yiri yó deke bo i ti alekutura sa, na minɛm dɔŋgu bá kete i. ");
INSERT INTO cko_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Sɔ ye i bá yi bu asiri nu sunsunni tiɛm kɛrɛ fite fofoe nu a. Na yiri ti, u ahore sáaki agaya, kabo takobe kpiɛ sɔnɔ na i yo ya ni.” ");
INSERT INTO cko_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","38","Nyini saŋga n nu nɔ ɔ, na bara be, i ti Nyɛmɛ nɔaniɛ kan­fɔ ɔ, na i gusu wo dɔ, na wɔ ba baa n bi. I duma la Anna, na bu fere i si ka Fanuwɛli, Aseri dɛɛ busu nu­fɔa. Bara n ti buke wɔ nahɔrɛ su, i jaari i hun, bu afɔ nso ye i kaari kuna­fɔ a. Nyini saŋga ni, i la afɔ abura­mɔcuɛ ni nna. Wɔ kpaaki ayaki má Nyɛmɛ Seree­biri Awuru ni, i cici i nɔɔ sɔ ɔ, na i kɔ susere Nyɛmɛ, wiɛsu ni kɔŋguɛ. I ba juuri baa n bi ni, na wɔ da Nyɛmɛ asi na yiri gusu ajɔjɔ baa n jɔrɛ akere minɛm kɛrɛ bo bu ŋminda ka Nyɛmɛ sunma Tii­de­fɔ n na i de Yisareli­fɔm tii ji ni. ");
INSERT INTO cko_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Saŋga bo Yosefu ni Mariya yoori yoo­wa n kɛrɛ bo Micɛra n nɔaniɛ kpamaa­wa n kere ka bu yo n wieeri ni, na ba kpie bu nyi akɔ bu bɔsu Nazarɛti bo i wo Galili awɔrɛ n nu ni. ");
INSERT INTO cko_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Na baa n anyi, na wɔ nya faŋga ni alecira, na Nyɛmɛ ahɔrɔma awo i dɔ agaya. ");
INSERT INTO cko_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Afɔ kɛrɛ afɔ, Yesu si ni i ni kɔ Yɛrusalem miɛ kpiri n nu wɔ, na bu kɔ di Butara cɛɛn­kpiri, bo bu di i na bu teŋge su kabo Nyɛmɛ yo deeri bu nam tii fiteeri Ijipiti­fɔm asiɛn su ni. ");
INSERT INTO cko_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Saŋga bo Yesu ba juuri afɔ buru ni nnyɔ ni, na ba kɔ na bu kɔ di cɛɛn­kpiri n kabo bu yo afɔ kɛrɛ afɔ ni. ");
INSERT INTO cko_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Bu ba diiri cɛɛn­kpiri n wieeri na bu sukpie bu nyi kɔ awuru ni, na Yesu yiri aka Yɛrusalem dɔ. I si ni i ni asi má ka wɔ ka dɔ. ");
INSERT INTO cko_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Bu sunsunni la ka i wo abeŋgu natiiri­fɔm n nu wɔ, nyini dɛɛ ti, bu wo kɔ su wɔ haari wiɛ kɔ sutɔ. Dɔ na ba bo i bu suniɛniɛ i, bu lamɔsim ni bu danfom nu. ");
INSERT INTO cko_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ama, ba ŋu má i, na ba nya kpie bu nyi akɔ Yɛrusalem na bu kɔ niɛniɛ i. ");
INSERT INTO cko_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","I le­san cɛɛn na ba kɔ aŋu ka i tana Nyɛmɛ Seree­biri Awuru n nu, Nyɛmɛ nɔaniɛ kere­fɔm afiɛn suso i sui, na i subisa bisaa­wam. ");
INSERT INTO cko_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Na minɛm bo bu tiiri i nɔaniɛ n kɛrɛ ayo alekutura, fa kɔ kabo i la si na i bɔ nɔaniɛ bisaa­wam nu barasu ni. ");
INSERT INTO cko_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Na saŋga bo i si ni i ni ba ŋuuri i n na ba miɛ, na i ni abisa i ka, “M wa, nzu ti ye a yo ya sɔ a? A ma mini ni u si ahore asaaki akɔ asin su, haari ya nati wo u niɛniɛ su.” ");
INSERT INTO cko_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Na wɔ se bu ka, “Nzu ti ye am nati niɛniɛ m busu a? Am si má ka wɔ yo daka ka m wo m Si awuru n nu wɔ?” ");
INSERT INTO cko_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ama, ba ti má nɔaniɛ n bo i seeri bu nu n bu. ");
INSERT INTO cko_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Na Yesu asu bu su, na ba kpie bu nyi akɔ Nazarɛti miɛ n nu, na wɔ de bu nɔaniɛ. Na i ni afa nyini sam kɛrɛ ase i ahore su. ");
INSERT INTO cko_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Na Yesu sunyi, na i alecira subuka su, na i sa­yoo­wam susun Nyɛmɛ ni adamande kɛrɛ nu. ");
INSERT INTO cko_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Roma­fɔm fɛmɛ kpiri bo bu fere i ka Siza Tiberiyosi n diiri i fɛmɛya ni, afɔ buru ni nnu, nyini saŋga ye sɔnɔ be bo bu fere i ka Pɔntiyo Pilato n ti Yudiya awɔrɛ n nu gomina, na sɔnɔ be bo bu fere i ka Herode n niɛ Galili awɔrɛ n nu su, na i gɔrɔ bo bu fere i ka Filipu n gusu niɛ awɔrɛ nnyɔ nbem bo bu fere bu ka Iturayɔ ni Tarakonitidɔ n su, na sɔnɔ be bo bu fere i ka Lusaniya n gusu niɛ awɔrɛ n bo bu fere i ka Abilene n su. ");
INSERT INTO cko_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Nyini saŋga ni, Anasi ni Kayafasi jina Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm kɛrɛ kpiɛn n jinaa­biri a. Na Nyɛmɛ afa i nɔaniɛ n ama Yohane Zakariya wa, boro kpantain n nu. ");
INSERT INTO cko_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Nyini ti, na Yohane akɔ Yodan kunma n awɔrɛ n kɛrɛ n nu sukan Nyɛmɛ jɔrɛ, i ŋa, “Am kaaki am wo na m biɛ am Nyɛmɛ nzue, na Nyɛmɛ fa am ŋgasi ni am satiɛ kɛrɛ ce am.” ");
INSERT INTO cko_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Sɔ ye wɔ yo yii­wa, kabo Nyɛmɛ ma ba kɛrɛ i nɔaniɛ kan­fɔ Esaya dɛɛ kadasi n nu ka, “Sɔnɔ be subo ndoori boro kpantain n nu ka, ‘Am sɛsɛ Mibiɛ n atin su, na am yo i atin n dɔŋgu. ");
INSERT INTO cko_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Na bu bá bereki bukam n ni kpɛrɛm kɛrɛ, na bu bá tɔtɔ kunma kunma kɛrɛ bo i wo buka n bu, na atin kɛrɛ bo wɔ biri, bu bá teŋge, na bu bá tɔtɔ i kunma kunma n kɛrɛ. ");
INSERT INTO cko_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Na adamande kɛrɛ bá ŋu kabo Nyɛmɛ dé bu tii ji barasu ni.’” ");
INSERT INTO cko_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Na jama beberebe afite aba Yohane dɔ ka i biɛ bu Nyɛmɛ nzue. Na wɔ se bu ka, “Ambɛrɛ burukɔɔ­nu­fɔm bo am ti ka woom ni, ŋma seeri am ka am ŋmati fite sui­cin kekereke n bo Nyɛmɛ sufa ba am dɔ n nu a? ");
INSERT INTO cko_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Am yo sakpa bo i kere ka am akaaki am wo. Na má am sunsun ka, Abraham ti am na dɛɛ ti, na am koro fite nyini sui­cin n nu. M suse am wɔ lɛɛ, ka, Nyɛmɛ koro ma ahin yabuɛm ni kaaki nbaam ma Abraham. ");
INSERT INTO cko_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Nyɛmɛ asi i samba n nana ase baka kɛrɛ bu na i kpiɛ i ji sin nu, yiri bo i suu­wa ti má kpa ni.” ");
INSERT INTO cko_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Na jama n abisa Yohane ka, “Ye ya yo sɛ wɔ lɛɛ kisa n a?” ");
INSERT INTO cko_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Na wɔ bɔ bu nu ka, “Sɔnɔ kɛrɛ bo i la tanlɛɛ nnyɔ, i mi ma sɔnɔ bo i la má be n kun, na bo i la diire gusu yo sɔ.” ");
INSERT INTO cko_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Na lampo­de­fɔ nbem aba i dɔ ka i biɛ bu Nyɛmɛ nzue, na ba bisa i ka, “Ya Kere­fɔ, ye ya yo sɛ wɔ?” ");
INSERT INTO cko_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Na wɔ se bu ka, “Má am de ŋwaa kɔ tara kabo i ti ye ni ka am de ni.” ");
INSERT INTO cko_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Na soja nbem gusu aba i dɔ aba abisa i ka, “Ye yɛrɛ di, ya yó sɛ wɔ?” Na wɔ se bu ka, “Má am miɛ be de ŋwaa i dɔ, na má am tun be nzuin. Am ma am nyunu yi am ŋkatɔ.” ");
INSERT INTO cko_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Na minɛm bo bu tana niɛ Kristo n atin nu ka i ba ni, yiri Tii­de­fɔ n bo Nyɛmɛ ase ka i súnma i ni, bu sunsun ka, beni, kisa Yohane ti Kristo Tii­de­fɔ n a. ");
INSERT INTO cko_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yohane siiri nyini dɛɛ ti, na wɔ se bu ka, “Mini sufa nzue biɛ am a, na am yo casi, ama, bo i tara m fieo wo m sin suba. M ti kaan ni bo m dodo i. Yiri fá Awiɛwiɛ Casi n ni sin yo am casi a, kabo sɔnɔ biɛ nzue na i yo casi ni. ");
INSERT INTO cko_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","I bita i ŋgani bakiti fieeba suba, na i bá bakiti yi ŋgani mbaa n busu gɔ i bondo nu, na i nya yára kunkun n sin n bo i je na i nɔ má n nu.” ");
INSERT INTO cko_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Sɔ ye Yohane kaanri labari kpa n kereeri minɛm a, na wɔ jɔjɔ jɔrɛ dɔŋgu ase bu ka bu kaaki bu wo. ");
INSERT INTO cko_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ama, na Yohane akan Fɛmɛ Herode ndiɛ ka wɔ fa i gɔrɔ yi Herodiya aja i hun ŋgɔɔ su, na wɔ kaaki ayo sa ŋgbɛɛn­ŋgbɛɛn beberebe. ");
INSERT INTO cko_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","I satiɛ bo i ti tiɛ tara i kɛrɛ n la ka i taraari Yohane nyiiri i dan­saraka a. ");
INSERT INTO cko_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Saŋga bo Yohane biɛɛri minɛm Nyɛmɛ nzue ni, na wɔ biɛ Yesu gusu. Bu biɛɛri i wieeri, na i susere Nyɛmɛ ni, dɔ na aŋgoro n ateke, ");
INSERT INTO cko_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","na Awiɛwiɛ Casi n ajura aba atana i ŋu ka tiiwa dɛɛ su. Na wɔ ti akonvi be ŋga aŋgoro, i ŋa, “Wɔrɔ ti m wa a, m koro u agaya, m ahore ajɔ u ŋu.” ");
INSERT INTO cko_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Saŋga bo Yesu boori i juma n bu ni, nyini saŋga i la afɔ abura­san. Minɛ yo sunsun ka i si la Yosefu bo i ti Heli wa n wɔ, na Heli si la ");
INSERT INTO cko_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Matati, na Matati si la Levi, na Levi si la Mɛlɛki, na Mɛlɛki si la Yanayi, na Yanayi si la Yosefu nyiŋga n bo ");
INSERT INTO cko_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","i si la Matatiya ni, na Matatiya si la Amosi, na Amosi si la Nahumu, na Nahumu si la Esili, na Esili si la Nagayi, ");
INSERT INTO cko_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","na Nagayi si la Maati, na Maati si la Matatiya nyiŋga n bo i si la Sɛmɛni ni, na Sɛmɛni si la Yoseki, na Yoseki si la Yoda, ");
INSERT INTO cko_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","na Yoda si la Yowanani, na Yowanani si la Resa, na Resa si la Zorobabɛli, na Zorobabɛli si la Salatiyeli, na Salatiyeli si la Niɛri, ");
INSERT INTO cko_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","na Niɛri si la Mɛlɛki nyiŋga n bo i si la Adi ni, na Adi si la Kosamu, na Kosamu si la Elimadamu, na Elimadamu si la Eri, ");
INSERT INTO cko_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","na Eri si la Yosuwa, na Yosuwa si la Eliyɛza, na Eliyɛza si la Yorimu, na Yorimu si la Matati nyiŋga bekun, na nyini Matati n si la Levi nyiŋga bekun, ");
INSERT INTO cko_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","na nyini Levi n si la Simeyon, na Simeyon si la Yuda, na Yuda si la Yosefu nyiŋga n bo i si la Yonamu ni, na Yonamu si la Eliyakimu, ");
INSERT INTO cko_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","na Eliyakimu si la Mɛliya, na Mɛliya si la Mɛnna, na Mɛnna si la Matata, na Matata si la Natani, na Natani si la Fɛmɛ Davidi, ");
INSERT INTO cko_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","na Fɛmɛ Davidi si la Jese, na Jese si la Yobedi, na Yobedi si la Boosi, na Boosi si la Sala, na Sala si la Naasoni, ");
INSERT INTO cko_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","na Naasoni si la Aminadabu, na Aminadabu si la Adimini, na Adimini si la Arani, na Arani si la Hɛsarom, na Hɛsarom si la Farɛsɛ, na Farɛsɛ si la Yuda nyiŋga n bo ");
INSERT INTO cko_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","i si la Jakɔbu ni, na Jakɔbu si la Izaki, na Izaki si la Abraham, na Abraham si la Tara, na Tara si la Nakoro, ");
INSERT INTO cko_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","na Nakoro si la Sɛruku, na Sɛruku si la Ragawu, na Ragawu si la Falɛki, na Falɛki si la Ebera, na Ebera si la Sala nyiŋga bekun, ");
INSERT INTO cko_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","na nyini Sala n si la Keena, na Keena si la Arafakadi, na Arafakadi si la Semu, na Semu si la Nowa, na Nowa si la Lamɛki, ");
INSERT INTO cko_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","na Lamɛki si la Matusala, na Matusala si la Henoki, na Henoki si la Yarɛti, na Yarɛti si la Malɛheeli, na Malɛheeli si la Keena nyiŋga bekun, ");
INSERT INTO cko_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","na Keena n si la Enosi, na Enosi si la Seti, na Seti si la Adam, na Adam si la Nyɛmɛ. ");
INSERT INTO cko_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Awiɛwiɛ Casi n woori Yesu ŋu agaya, na wɔ fite Yodan kunma n awɔrɛ n nu, na Awiɛwiɛ Casi n afa i akɔ boro kpantain n nu kɔ sukere i atin. ");
INSERT INTO cko_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","I woori dɔ cɛɛn abura­na, na Sitana ayo i na i niɛ ka, i yó yiri Sitana n dɛɛ koroo­wa, nzɛn i yó má i. Nyini cɛɛn abura­na n kɛrɛ ni, wɔ di má pui, nyini dɛɛ sin, na ahɔɛ aba ati i. ");
INSERT INTO cko_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Na Sitana n ase i ka, “Nzɛn a ti Nyɛmɛ Wa, se ahin yabuɛ n na i kaaki diire.” ");
INSERT INTO cko_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ama, na Yesu abɔ i nu ka, “Ba kɛrɛ i Nyɛmɛ Jɔrɛ Kadasi n nu ka, má diire ŋgumi ma sɔnɔ ŋgɔɔ a.” ");
INSERT INTO cko_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Na Sitana afa i afun akɔ aŋgoro lenleŋge, na i nyu­mbaa­mbaa n nu bɛrɛ, na wɔ kere i durunya n nu asiɛn n kɛrɛ. ");
INSERT INTO cko_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Na wɔ se i ka, “Wɔrɔ ye m má a niɛ ahin asiɛn n kɛrɛ su a, na m fá bu ajɛkɛm kɛrɛ ma u, dama Nyɛmɛ afa i kɛrɛ awura m saa nu, na mini gusu koro fa ma sɔnɔ kɛrɛ bo m koro. ");
INSERT INTO cko_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Nzɛn a kutu suuri m, m fá nyinim kɛrɛ ma u.” ");
INSERT INTO cko_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Na Yesu ase i bekun ka, “Ba kaaki akɛrɛ i Nyɛmɛ Jɔrɛ Kadasi n nu ka, ‘Kutu Micɛra u Nyɛmɛ ni, na a su yiri ŋgumi.’” ");
INSERT INTO cko_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Na Sitana n akaaki afa Yesu akɔ Yɛrusalem miɛ kpiri n nu, na wɔ fa i akɔ ajina Nyɛmɛ Seree­biri Awuru n tii su lenleŋge, na wɔ se i ka, “Nzɛn a ti Nyɛmɛ Wa, fite fɛn ti tɔ asiɛŋgu na m niɛ. ");
INSERT INTO cko_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Dama ba kɛrɛ i Nyɛmɛ Jɔrɛ Kadasi n nu ka, ‘Nyɛmɛ má i mɛrɛkɛm nɔɔ ka bu niɛ u dika na bu kanda u.’ ");
INSERT INTO cko_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ba kaaki akɛrɛ i ka, ‘Bu fá bu saa so u nu, na má u jaa bo yabuɛ be.’” ");
INSERT INTO cko_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ama, na Yesu akaaki ase i ka, “Ba kaaki akɛrɛ i Nyɛmɛ Jɔrɛ Kadasi n nu ka, ‘Má a yo Micɛra Nyɛmɛ n na a niɛ kabo i yiko ti barasu.’” ");
INSERT INTO cko_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Saŋga bo Sitana n yoori Yesu yoo­wa barasu n kɛrɛ na i niɛ i ni, na wɔ kɔ ayaki Yesu ka. ");
INSERT INTO cko_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Na Yesu akpie i nyi akɔ Galili awɔrɛ n nu, ni Awiɛwiɛ Casi n dɛɛ yiko nu. Na i labari abara ayɛ nyini awɔrɛ n kɛrɛ pepere nu. ");
INSERT INTO cko_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Na wɔ kere minɛm Yuda­fɔm tiɛntiɛn­bunɔɔ sɔɔm nu, na sɔnɔ kɛrɛ akansi i. ");
INSERT INTO cko_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Na Yesu akɔ Nazarɛti miɛ n nu, dɔ ye bu taari i a, na wɔ nyi, na Yuda­fɔm Ŋumi­yi cɛɛn n be, na wɔ kɔ bu tiɛntiɛn­bunɔɔ sɔɔ n nu, kabo i nati kɔ ni. Na wɔ yasu ajina ka i kan Nyɛmɛ Jɔrɛ Kadasi ni, ");
INSERT INTO cko_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","na ba fa Nyɛmɛ nɔaniɛ kan­fɔ Esaya dɛɛ kadasi n ama i. Na wɔ teke i, na wɔ niɛ aŋu awɔrɛ n bo ba kɛrɛ i nu ka, ");
INSERT INTO cko_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Micɛra n Awiɛwiɛ n wo m dɔ, dama wɔ yi m ka m kan labari kpa n kere yaari­fɔm. Na wɔ sunma m ka m kɔ minɛm bo ba tara bu domuɛm n dɔ, na m se bu ka m bá de bu tii ji, na m kɔ anyinsinm dɔ, na m se bu ka m bá teke bu nyu­mbaa, na m kɔ minɛm bo bu bita bu miɛ n dɔ, na m se bu ka m bá de bu tii ji, ");
INSERT INTO cko_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","na m bo ndoori ka, afɔ n nu Micɛra ni má i minɛm di i ahɔrɔma.” ");
INSERT INTO cko_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Na Yesu akan awie, na wɔ kata Nyɛmɛ Jɔrɛ Kadasi n su, na wɔ fa ama i bita­fɔ ni, na wɔ tana. Na minɛm kɛrɛ bo bu wo tiɛntiɛn­bunɔɔ sɔɔ n nu n afa bu nyu­mbaa akpama i ŋu. ");
INSERT INTO cko_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Na wɔ se bu ka, “Nyuma dɛɛ cɛɛn n nu, ahin Nyɛmɛ Jɔrɛ Kadasi n bo ma kan i na am ati i ni, ayo yii­wa.” ");
INSERT INTO cko_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Na sɔnɔ kɛrɛ akan kpa ama i, na ba yo alekutura kabo i nɔaniɛ jɔjɔɔ­wa n ti kpa barasu ni, na ba bisa bu ŋuŋu nu ka, “Má Yosefu wa n lɛɛ?” ");
INSERT INTO cko_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Na Yesu ase bu ka, “M si tenle ka am bó m ahin anyundɛrɛ ni ka, ‘Ayiri­fɔ, tuntun u ŋu.’ Na am sé m ka, ‘Sam n bo ya tiiri ka a yoori bu Kapɛnam miɛ kpiri n nu ni, yo bu u bɔsu fɛn gusu na ya niɛ.’” ");
INSERT INTO cko_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Na Yesu akaaki ase bu ka, “Nahɔrɛ ye m suse am n a, Nyɛmɛ nɔaniɛ kan­fɔ la má jirima haari kaan sɔ mmɔɔ i bɔsu­fɔm dɔ. ");
INSERT INTO cko_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Am teŋge su kabo Nyɛmɛ nɔaniɛ kan­fɔ Eliya dɛɛ saŋga n na nzue atɔ má afɔ nsan ni kpaaki nu, na ahɔɛ bambaka tɔɔri ni. I ti nahɔrɛ wɔ ka, nyini saŋga, kuna­fɔm beberebe woori Yisareli asiɛn n su, ");
INSERT INTO cko_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ama, Nyɛmɛ asunma má Eliya nyini kuna­fɔm be dɔ, se i sunmaari i kuna­fɔ kun be dɔ a, i wo miɛ be bo bu fere i ka Zarɛfati na i ti má Yuda­fɔm miɛ kpiri n wɔ, i wo Sidon dɛɛ awɔrɛ n nu wɔ. ");
INSERT INTO cko_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Sasu bekun, Nyɛmɛ nɔaniɛ kan­fɔ Elisa dɛɛ saŋga, i ti nahɔrɛ wɔ ka kokobi yo taraari minɛm beberebe Yisareli asiɛn n su, ama, Nyɛmɛ ama wɔ tuntun má bu kun n kpein mmɔɔ, se i tuntuunri koko­fɔ kun be wɔ, bu fere i ka Naama, i ti má Yuda­fɔ, i fite Siriya awɔrɛ nu wɔ.” ");
INSERT INTO cko_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Minɛm bo bu wo sɔɔ n nu n tiiri sɔ ni, na yaa ati bu agaya. ");
INSERT INTO cko_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Na ba yasu aso i nu, acin i afite miɛ n nu akɔ kpɛrɛ n bo miɛ n wo su ni, ka bu fa i ji buka n bu asiɛŋgu. ");
INSERT INTO cko_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ama, na wɔ nati asin jama n afiɛn akɔ. ");
INSERT INTO cko_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Dɔ na wɔ kɔ miɛ kpiri n bo bu fere i ka Kapɛnam na i wo Galili awɔrɛ n nu ni, na Ŋumi­yi cɛɛn ni, na wɔ kɔ awura bu tiɛntiɛn­bunɔɔ sɔɔ n nu sukere minɛm. ");
INSERT INTO cko_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Na ba yo alekutura fa kɔ i keree­wa n su, dama i jɔjɔɔ­wa n la yiko. ");
INSERT INTO cko_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Na sɔnɔ be wo tiɛntiɛn­bunɔɔ sɔɔ n nu dɔ, ajini wo i ŋu, na wɔ bo awie kpa ase ka, ");
INSERT INTO cko_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Oi, Yesu Nazarɛti­fɔ, a koro nzu ya nu fɛn a? A ba ka a ba yo ya ŋgbɛɛn wɔ, nzɛn sɛ? M si u sa, wɔrɔ ti sɔnɔ casi bo Nyɛmɛ asunma u n a.” ");
INSERT INTO cko_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Na Yesu atiɛn ajini n ŋu ase ka, “Mɔ u nɔɔ bɛrɛ na a fite yaki sɔnɔ ni.” Na ajini n akpisi sɔnɔ n abo asiɛŋgu jama n kɛrɛ nyunu, na ba fite ayaki sɔnɔ ni, ba ma má i mandim be. ");
INSERT INTO cko_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Na minɛm kɛrɛ ayo alekutura, na ba bisa bu ŋuŋu nu ka, “Nzu alekutura nɔaniɛ jɔjɔɔ­wa n la ahin? Dama i la yiko nahɔrɛ su bo i koro ma ajinim nɔɔ na bu fite yaki sɔnɔ.” ");
INSERT INTO cko_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Na i labari n abara ayɛ nyini awɔrɛ n kɛrɛ nu. ");
INSERT INTO cko_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Na Yesu afite tiɛntiɛn­bunɔɔ sɔɔ n nu, na wɔ kɔ awura Simon dika, na ba se i ka Simon sibara la má i ŋu, yakɔkɔ abo i agaya. ");
INSERT INTO cko_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Na Yesu akɔ ajina i bi, na wɔ ma yakɔkɔ n nɔɔ ka i fite yaki bara ni. Na wɔ fite ayaki i, na bara n akaba ayasu, na wɔ kɔ ayo diire ama bu. ");
INSERT INTO cko_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Na naasɔ dika bibiri saŋga, na minɛm n afa tukpaki barasu barasu fɔm kɛrɛ aba Yesu dɔ ka i tuntun bu, na wɔ fa i saa anana bu ŋu, na bu kɛrɛ anya laifiɛ. ");
INSERT INTO cko_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Na wɔ fɔn ayi ajinim n gusu afite minɛm beberebe ŋu, na ajinim n acindi, na ba se i ka, “Wɔrɔ ti Nyɛmɛ Wa n a.” Ama, na Yesu akan ajinim n ndiɛ, wɔ du má su na bu jɔjɔ, dama bu si ka yiri ti Kristo n a, Tii­de­fɔ n bo Nyɛmɛ ase ka i súnma i ni. ");
INSERT INTO cko_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ale ba ciinri, na Yesu afite miɛ n nu akɔ awo awɔrɛ be nu i ŋgumi. Na minɛm n akɔ i niɛniɛ, na saŋga bo bu kɔ ŋuuri i ni, na ba kpini atin kabo bu yo na má i kpaaki yaki bu. ");
INSERT INTO cko_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ama, na wɔ se bu ka, “Wɔ yo daka ka m kɔ miɛ nyiŋgam gusu su na m kɔ kan labari kpa fa kɔ Nyɛmɛ fɛmɛya n su kere bu gusu, dama ka nyini ti ye Nyɛmɛ sunmaari m a.” ");
INSERT INTO cko_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Nyini ti, na wɔ bara ayɛ sukan Nyɛmɛ jɔrɛ ni, tiɛntiɛn­bunɔɔ sɔɔm nu bu awɔrɛ n kɛrɛ nu. ");
INSERT INTO cko_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Cɛɛn be na Yesu jina Gɛnɛsarɛti kunma kpiri n nɔɔ su, na jama beberebe abara ayɛ i, na bu susun bu beŋgu ka bu ju i bi na bu ti Nyɛmɛ nɔaniɛ ni. ");
INSERT INTO cko_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Dɔ na wɔ ŋu lee nnyɔ nbem ka bu wo kunma n nɔɔ su. Jombaa tara­fɔm n afite ayaki leem wo bu diɛndiɛm ŋmisi su. ");
INSERT INTO cko_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Na Yesu awura lee n kun nu, nyini lee n ti Simon dɛɛ wɔ, na Yesu ase Simon ka i sun lee n kɔ kaan. Na Yesu atana lee n nu, na i sukere jama ni. ");
INSERT INTO cko_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Saŋga bo i kere wieeri ni, na wɔ se Simon ka, “Sun lee n na i kɔ ŋgoŋgo n nu, na am sandi am diɛndiɛm na am tara jombaa.” ");
INSERT INTO cko_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Na Simon ase Yesu ka, “M Mɔfɔ, ya yo jumam ni anyum­boro anuma kɔŋguɛ kɛrɛ fa ba ju haari ni kisa, ya tara má pui. Ama, nzɛn a se sɔ yiri, m fá diɛndiɛm n sandi nzue n nu.” ");
INSERT INTO cko_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Na ba fa diɛndiɛm n asandi nzue n nu, na ba tara jombaa beberebe haari má diɛndiɛm ni jinaari ka bu sɔ́n ɔ. ");
INSERT INTO cko_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Nyini ti, ba fa bu saa apaati bu lamɔkɔm bo bu wo lee nyiŋga n nu ka bu ba buka bu. Na ba yiyi jombaam n agɔ lee nnyɔ n nu, na ba yi haari leem ni jinaari ka bu sa nzue wɔ. ");
INSERT INTO cko_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Saŋga bo Simon Petoro ŋuuri nyini sɔ ni, na wɔ kɔ akutu Yesu jaa bu ase i ka, “M Mibiɛ, cinsi m bi bɛrɛ, dama m ti satiɛ­yo­fɔ ɔ.” ");
INSERT INTO cko_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Deke bo i ma i seeri sɔ n la ka, i ni nyiŋgam kɛrɛ ayo alekutura fa kɔ kabo ba tara nyini jombaa beberebe n barasu ni. ");
INSERT INTO cko_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Yakobo ni Yohane gusu woori bɛrɛ, bu si la Zɛbɛdi, bu ni Simon saŋga tara jombaa n a. Na bu gusu ayo alekutura. Na Yesu ase Simon ka, “Má a ma sɛrɛ ti u, fite kisa fa kɔ, m má a sutiɛn minɛm nɔɔ ma m, kabo a tara jombaa ni.” ");
INSERT INTO cko_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Na ba cin ayi lee n afite nzue n ahɛmɛ, na ba yaki deke n kɛrɛ bɛrɛ, na ba su i su. ");
INSERT INTO cko_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Cɛɛn n be sɔ ɔ, na Yesu wo miɛ be su, koko­fɔ be wo nyini miɛ n nu. Saŋga bo i ŋuuri Yesu sɔ ni, na wɔ ŋmati aba akutu, na wɔ fa i nyunu abutu asiɛŋgu, na wɔ sere i jande ka, “M Mibiɛ, nzɛn a koro ka a ma m nya laifiɛ, a koro ma m nya i.” ");
INSERT INTO cko_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Na Yesu ateŋge i saa anana i ŋu na wɔ se i ka, “M koro. Nya laifiɛ.” Na kokobi n akaba ayaki sɔnɔ ni. ");
INSERT INTO cko_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Na Yesu abɔbɔ i ase i ka, “Má a se ka a se be, ama, kɔ na a kɔ fa u ŋu kere Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ ni, na a kɔ yo yoo­wa n bo Moyisi yo kereeri dawa­fɔm ni, dama nyini kere minɛm ka a nya u ŋu a.” ");
INSERT INTO cko_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ama, haari ni nyini mmɔɔ, na i labari abara ayɛ deke n kɛrɛ, na minɛm aba i dɔ na bu ba ti Nyɛmɛ jɔrɛ kaan­wa n na i tuntun bu tukpaki barasu barasu kɛrɛ na bu nya laifiɛ. ");
INSERT INTO cko_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ama, yiri ba yo, i yi i ŋu kɔ deke bo minɛm wo má n wɔ, na i kɔ sere Nyɛmɛ. ");
INSERT INTO cko_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Cɛɛn n be sɔ ɔ, Yesu wo minɛm kere su, na Farasi­fɔm nbem, ni Yuda­fɔm Nyɛmɛ nɔaniɛ kere­fɔm tana bɛrɛ. Bu fiteeri miɛ miɛm bo bu wo Galili ni Yudiya awɔrɛm n nu, ni Yɛrusalem miɛ kpiri n nu baari a. Na Nyɛmɛ ama Yesu yiko bo i tuntun tukpaki­fɔm na bu nya laifiɛ. ");
INSERT INTO cko_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Dɔ na minɛ nbem asɔ sɔnɔ be ni i dasu aba, i saam ni i jaam awu, na bu sumiɛ bu nyi ka bu fa i wura sɔɔ n nu wɔ, na bu fa i se Yesu nyunu. ");
INSERT INTO cko_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ama, jama n sunnuuri sɔ n dɛɛ ti, ba koro anya má atin. Nyini ti, na ba fa i afun sɔɔ n tii su, na ba fiiti anya fofoe, na ba cɔɔndi i ni i dasu n kɛrɛ ase jama n afiɛn Yesu nyunu. ");
INSERT INTO cko_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesu ŋuuri kabo bu yoori i yarada n sɔ ni, na wɔ se biɛ n ka, “Ma fa u satiɛ ace u.” ");
INSERT INTO cko_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Na Nyɛmɛ nɔaniɛ kere­fɔm ni Farasi­fɔm n abisa bu ŋuŋu nu ka, “Sɔnɔ bɔnɔ la ahin bo i jɔjɔ wura Nyɛmɛ ŋgasi nu sɔ a? Be wo má bɛrɛ bo i koro fa minɛm satiɛ ni bu ŋgasi ce bu, sin Nyɛmɛ ŋgumi ŋu.” ");
INSERT INTO cko_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Na Yesu afa nu fa kɔ bu sunsunni bo bu bita i n su, na wɔ se bu ka, “Nzu ti ye am bita nyini sunsunni ni am ahore su a? ");
INSERT INTO cko_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Bɔnɔ ti kekereke a, bo m se ka, ‘Ma fa u satiɛ ace u,’ nzɛn, ‘Yasu nati’ n a? ");
INSERT INTO cko_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","M kére am ka mini Adamande Wa n la yiko durunya n nu bo m fa satiɛ ni ŋgasi ce.” Na wɔ se sɔnɔ n bo i saam ni i jaam awu n ka, “Wɔrɔ, yasu fa u dasu n na a kɔ awuru.” ");
INSERT INTO cko_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Kpeŋga na sɔnɔ n ayasu jama n kɛrɛ nyunu, na wɔ fa i dasu n na i sukansi Nyɛmɛ sukɔ awuru. ");
INSERT INTO cko_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Na bu kɛrɛ ayo alekutura agaya, na ba kansi Nyɛmɛ, na sɛrɛ ati bu, bu ŋa, “Nyuma, ya ŋu alekutura sam bo ya nya ŋu má i.” ");
INSERT INTO cko_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Nyini sin, na Yesu afite bɛrɛ, na wɔ kɔ aŋu lampo­de­fɔ be bo bu fere i ka Levi, i tana i juma yoo­biri. Na Yesu ase i ka, “Yasu bra na a ba su m su.” ");
INSERT INTO cko_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Na Levi ayaki deke n kɛrɛ, ayasu asu i su. ");
INSERT INTO cko_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Na Levi afa Yesu akɔ i dika, na wɔ kɔ ayo di ni nu bambaka, na ba tiɛn bu nɔɔ adi, bu ni lampo­de­fɔm beberebe, ni minɛ nyiŋga nbem. ");
INSERT INTO cko_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Na Farasi­fɔ nbem ni Nyɛmɛ nɔaniɛ kere­fɔm nbem bo bu ni bɛrɛ wo ni, aŋuŋuti i, na ba bisa Yesu susu­fɔm n ka, “Nzu ti ye am ni lampo­de­fɔm, ni satiɛ­yo­fɔm saŋga di diire na am nu nzan a?” ");
INSERT INTO cko_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Na Yesu ase bu ka, “Minɛm bo bu la laifiɛ n koro má ayiri­fɔ, má ka bo bu la má laifiɛ ni koro a. ");
INSERT INTO cko_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ma ba má ka m ba fere minɛm bo bu ŋa bu yo sa bo i kɔ atin su Nyɛmɛ dɔ n wɔ, ama, m baari ka m ba fere satiɛ­yo­fɔm wɔ, na bu kaaki bu wo.” ");
INSERT INTO cko_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Na minɛ nbem aba abisa Yesu ka, “Nzu ti ye Yohane dɛɛ susu­fɔm ni Farasi­fɔm dɛɛm cici bu nɔɔ na bu sere Nyɛmɛ saŋga kɛrɛ saŋga ye u dɛɛm bɛrɛ di ye bu nu a?” ");
INSERT INTO cko_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Na Yesu abɔ bu nu ka, “Am koro miɛ má konyaya­fɔm ka bu cici bu nɔɔ, saŋga bo konyafan n toko wo bu dɔ ni. ");
INSERT INTO cko_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ama, saŋga suba bo bu bá yi konyafan n fite bu nu, nyini saŋga n ye bu nyá cici bu nɔɔ a.” ");
INSERT INTO cko_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Na Yesu abo ahin miɛɛnu n akere bu, i ŋa, “Sɔnɔ koro fa má sanvuin fɔfɔrɛ kpa tɔ má tani dawa kunma, nzɛn i yoori sɔ, sanvuin fɔfɔrɛ ni sɔ́n dawa n wɔ, i tɔ́ má su. ");
INSERT INTO cko_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","I kaaki ti sɔ ɔ bekun ka be koro fa má nzan nyii­wa faŋga­fɔ gɔ má dundu dawa bɛbɛtɛ nu, nzɛn i yoori sɔ, dundu ni tíɛ wɔ, na i ká ŋgbɛɛn, na nzan n kɛrɛ sóŋgi butu. ");
INSERT INTO cko_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ama, i ti ye ni ka bu fa nzan nyii­wa faŋga­fɔ gɔ dundu fɔfɔrɛ bii­wa nu. ");
INSERT INTO cko_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Sɔnɔ nya nuuri nzan nyii­wa wieeri, i koro má nzan mɔnɛ kun. A tí ka i ŋa, ‘Nzan nyii­wa ni ti kpa a.’” ");
INSERT INTO cko_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ŋumi­yi cɛɛn be, na Yesu ni i susu­fɔm ni sunati sin alɛ­mbaa fie be nu, na i susu­fɔm n abubu be, na ba nunuka i bu saa nu akpɛsɛ. ");
INSERT INTO cko_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Na Farasi­fɔ nbem abisa bu ka, “Nzu ti ye am suyo sɔ a? Nyɛmɛ nɔaniɛ kpamaa­wa n kere ka má be yo sɔ Ŋumi­yi cɛɛn.” ");
INSERT INTO cko_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Na Yesu abisa bu ka, “Am nya kan má Nyɛmɛ Jɔrɛ Kadasi n nu, kabo Fɛmɛ Davidi yo yoori saŋga bo ahɔɛ tiiri i ni i minɛm na ba si má kabo bu yo n wɔ, nzɛn sɛ? ");
INSERT INTO cko_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ahɔɛ n ti, na wɔ kɔ awura Nyɛmɛ Seree­biri Awuru n nu, na wɔ fa kpɔnɔ n bo ba fa ama Nyɛmɛ ni, na wɔ di, na wɔ ma i minɛm be. Ama, am si ka ya dɛɛ atin n su, Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm ŋgumi di nyini kpɔnɔ n a.” ");
INSERT INTO cko_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Na Yesu ase bu ka, “Mini Adamande Wa ni ti Ŋumi­yi cɛɛn n Mibiɛ a.” ");
INSERT INTO cko_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Na Ŋumi­yi cɛɛn n be bekun, na Yesu akɔ awura tiɛntiɛn­bunɔɔ sɔɔ n nu, na wɔ kere minɛm. Sɔnɔ be woori dɔ, i saa fɔmbɔrɔ awu. ");
INSERT INTO cko_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Nyɛmɛ nɔaniɛ kere­fɔm ni Farasi­fɔm nbem woori dɔ, na ba koro ka bu nya ŋgɛɛ bo bu sɔ Yesu na bu nya i taraa­biri. Nyini ti, ba tu bu nyu­mbaa aniɛ Yesu, na bu niɛ ka i túntun sɔnɔ asaa fuin n Ŋumi­yi cɛɛn ni, nzɛn i túntun má i. ");
INSERT INTO cko_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ama, na Yesu asi bu sunsunni bo bu bita i, na wɔ se sɔnɔ asaa fuin n ka, “Yasu bra ba jina afiɛn fɛn.” Na sɔnɔ n ayasu akɔ ajina dɔ. ");
INSERT INTO cko_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Na Yesu abisa bu ka, “Ya dɛɛ atin n su, atin wo nu ka ya yo sakpa Ŋumi­yi cɛɛn ni, nzɛn ya yo satiɛ wɔ? I kaaki ti ye ni ka ya de ŋgɔɔ, nzɛn ya kun wɔ?” ");
INSERT INTO cko_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Na Yesu aniɛ bu nyunu abara ayɛ, na wɔ nya ase sɔnɔ asaa fuin n ka, “Teŋge u saa ni.” Na sɔnɔ n ayo sɔ, na i saa n ayo faŋga bekun. ");
INSERT INTO cko_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Na yaa ati bu agaya, na ba bo i bu afa sɛsɛ­su kabo bu yó Yesu barasu. ");
INSERT INTO cko_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Nyini saŋga n na Yesu afun akɔ buka be su ka i kɔ sere Nyɛmɛ, na wɔ sere Nyɛmɛ nyini kɔŋguɛ n kɛrɛ. ");
INSERT INTO cko_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Saŋga bo ale ba ciinri ni, na wɔ fere i susu­fɔm ni, na wɔ yi bu nu, buru ni nnyɔ, na wɔ fa bu ayo i jaramasam. ");
INSERT INTO cko_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Bɛrɛ la Simon bo Yesu tuunri i duma ka Petoro ni, ni i niɛma bo bu fere i ka Andere ni, ni Yakobo, ni Yohane, ni Filipu, ni Batolomeyo, ");
INSERT INTO cko_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ni Matio, ni Tomasi, ni Yakobo bo i si la Alafeyo ni, ni Simon bo i tu ŋgoni fa kɔ i asiɛn su ni, ");
INSERT INTO cko_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ni Yudasi bo i si la Yakobo ni, ni Yudasi Isikariyoti bo i ba tɔɔri Yesu ni. ");
INSERT INTO cko_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Na Yesu ni i jaramasam n acɔɔndi buka n aba ajina awɔrɛ be nu, i susu­fɔm nyiŋgam beberebe woori dɔ, ni jama beberebe. Bu fiteeri Yudiya dɛɛ awɔrɛ n kɛrɛ nu wɔ, ni Yɛrusalem miɛ kpiri n nu, ni Tiro ni Sidon awɔrɛ n bo i wo tieku n nɔɔ su ni. ");
INSERT INTO cko_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Bu baari ka bu ba ti i keree­wa n wɔ, na i tuntun bu, na minɛm bo ajinim wo bu ŋu kere bu yaari n gusu aba, na wɔ tuntun bu, na ba nya laifiɛ. ");
INSERT INTO cko_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Minɛm kɛrɛ boro bu nyi wɔ, na bu fa bu saa kan i, dama yiko fite i dɔ ye bu kɛrɛ nya laifiɛ a. ");
INSERT INTO cko_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Na Yesu aniɛ i susu­fɔm, na wɔ se bu ka, “Ambɛrɛ bo am ti yaari­fɔm ni, tere­fiɛ wo am dɔ, dama Nyɛmɛ fɛmɛya n ti am dɛɛ wɔ. ");
INSERT INTO cko_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ambɛrɛ bo ahɔɛ ati am kisa ni, tere­fiɛ wo am dɔ, dama Nyɛmɛ bá ma am akunnuyi. Ambɛrɛ bo am ahore asaaki kisa ni, tere­fiɛ wo am dɔ, dama Nyɛmɛ bá ma am ahoreda. ");
INSERT INTO cko_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ambɛrɛ bo minɛm bá kpɔ am, na bu kéte am, na bu kpíɛ am nzukɔ, na bu sáaki am duma ka am ti satiɛ­yo­fɔm ni, nzɛn i kɛrɛ fite ka mini Adamande Wa n dɛɛ ti, tere­fiɛ wo am dɔ. ");
INSERT INTO cko_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Bu bá yoori am sɔ, am ma am ahore jɔ, na am tutu am kɔm. Dama am bá nya ŋkatɔ bambaka Nyɛmɛ dɔ. Kabo bu nam yo yoori dawa dɛɛ Nyɛmɛ nɔaniɛ kan­fɔm n lɛɛ. ");
INSERT INTO cko_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ama, ambɛrɛ bo am la ajɛkɛ beberebe kisa ni, am bá ŋu anyum­boro bambaka, dama am adu mɔ ayo am koroo­wa n dɛɛ ti. ");
INSERT INTO cko_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ambɛrɛ bo am adi na am kunnu ayi kisa ni, am bá ŋu anyum­boro bambaka, dama ahɔɛ bá ti am. Ambɛrɛ bo am siri kisa ni, am bá ŋu anyum­boro bambaka, dama am bá sun haari na am bá nya má nyunvuin. ");
INSERT INTO cko_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ambɛrɛ bo sɔnɔ kɛrɛ kansi am ni, am bá ŋu anyum­boro bambaka, dama sɔ ye bu nam yo kansiiri kɔrɛ­fɔm n bo bu yo bu ŋu ka bu ti Nyɛmɛ nɔaniɛ kan­fɔm n a.” ");
INSERT INTO cko_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Na Yesu ase bu ka, “Ama, m se ambɛrɛ bo am suso am sui na am ti n wɔ lɛɛ ka, am koro am kpɔ­fɔm, na am yo sakpa ma bo bu yo am satiɛ ni. ");
INSERT INTO cko_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Minɛm bo bu jɔjɔ nɔaniɛ tiɛ gɔ am ŋu ni, am yo bu kisi, na minɛm bo bu kere am wuwuruwa ni, am kaaki sere Nyɛmɛ ma bu. ");
INSERT INTO cko_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Nzɛn be fin u nyɔɔnu, kaaki bue nyiŋga n gusu ma i na i fin i buka su, na nzɛn be de u tanlɛɛ bambaka, kaba fa u tanlɛɛ kaan n bo i wo i bu mmɔɔ n buka i su. ");
INSERT INTO cko_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Sɔnɔ kɛrɛ bo i sere u deke be, má a kpiɛ i, na sɔnɔ kɛrɛ bo i fa u deke be, má a bisa i busu kun. ");
INSERT INTO cko_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Kabo am koro ka minɛm yo ma am ni, am yo i sɔ ma bu.” ");
INSERT INTO cko_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Na wɔ kaaki ase bu ka, “Nzɛn am nya koroori minɛm bo bu koro am ni ŋgumi, i kansi la bɔnɔ ɔ, ye am ba nya i a? Dama haari satiɛ­yo­fɔm mmɔɔ yo sɔ ɔ. ");
INSERT INTO cko_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Na nzɛn am nya yoori sakpa maari minɛm bo bu yo sakpa ma am ni, i kansi la bɔnɔ ɔ? Dama haari satiɛ­yo­fɔm mmɔɔ yo sɔ ɔ. ");
INSERT INTO cko_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Na nzɛn am fa neŋge fiɛ minɛm bo am sunsun ka bu bá tɔ am kaari ni, i kansi la bɔnɔ ɔ, ye am bá nya i a? Dama haari satiɛ­yo­fɔm mmɔɔ fiɛ bu beŋgu satiɛ­yo­fɔm wɔ, na bu bá de i ŋusu sɔ. ");
INSERT INTO cko_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ama, wɔ yo daka ka am koro am kpɔ­fɔm, na am yo sakpa ma bu, na má am fiɛ be neŋge be, na am sunsun ka i tɔ́ kaari. Dɔ ye am nyá i ŋkatɔ bambaka a, na am yó Micɛra Nyɛmɛ Kpiri ni nbaam. Dama yiri yo sakpa ma satiɛ­yo­fɔm, ni bo bu si má aye ni. ");
INSERT INTO cko_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Am si aŋunfɔ kabo am Si Nyɛmɛ si aŋunfɔ ni.” ");
INSERT INTO cko_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Na Yesu ase bu ka, “Má am jɔjɔ be jɔrɛ na am jaraki i, na Nyɛmɛ gusu dí má am jɔrɛ na i járaki am. Má am ma bu di be jɔrɛ cin i sui, na Nyɛmɛ gusu dí má am jɔrɛ cin má am sui. Am fa minɛm satiɛ ce bu, na Nyɛmɛ gusu fá am dɛɛ ce am. ");
INSERT INTO cko_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Am ma minɛm deke bo bu koro, na Nyɛmɛ gusu má am. Kabo Nyɛmɛ má am n la ka, i fá gɔŋgɔ dɔŋgu susu ma am a, na i yí kɔ butu. Nyini ti, gɔŋgɔ bo am fa susu ma minɛm ni, sɔ ye Nyɛmɛ gusu fá susu ma am a.” ");
INSERT INTO cko_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Na Yesu abo ahin anyundɛrɛ n akere bu, i ŋa, “Anyinsin koro bita má i beŋgu anyinsin kpama, nzɛn i yoori sɔ, bu nnyɔ n kɛrɛ kɔ́ to kunma nu wɔ. ");
INSERT INTO cko_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Sɔnsɔn­fɔ tara má i kere­fɔ, ama, saŋga bo wɔ ba asɔnsɔn juma n awie, i ni i kere­fɔ n kɛrɛ asɛ wɔ lɛɛ.” ");
INSERT INTO cko_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Na wɔ bisa bu ka, “Nzu ti ye a niɛ ŋu wura mbaa n bo i wo u niwa nyu­mbaa nu, ye a niɛ ŋu má yeenzin n bo i wo u dɛɛ nyu­mbaa n nu a? ");
INSERT INTO cko_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","A yo sɛ koro se u niwa ka, ‘Ma m yi wura mbaa n bo i wo u nyu­mbaa nu ni,’ ye a ŋu má yeenzin n bo i wo u dɛɛ nyu­mbaa n nu n a? Wɔrɔ burukɔɔ­nu­fɔ ni, du mɔ yi yeenzin n bo i wo u nyu­mbaa nu n ka, na a nyá ŋu asi nyunyumi, na a yí wura mbaa n bo i wo u niwa n dɛɛ nyu­mbaa nu ni.” ");
INSERT INTO cko_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Na Yesu ase ka, “Baka bo i ti kpa su má suu­wa tiɛ, na baka bo i ti má kpa gusu su má suu­wa kpa. ");
INSERT INTO cko_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Baka kɛrɛ suu­wa kere kabo baka n ti barasu a. Sɔnɔ kɛrɛ si ka a koro titi má damba buwe baka su. A kaaki koro titi má cacabu kpanji baka su. ");
INSERT INTO cko_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Sɔnɔ kpa ni i deke kpa kɛrɛ bo i bita i ahore su, fa sakpa ba a. Na sɔnɔ tiɛ gusu ni i deke tiɛ bo i bita i ahore su, fa satiɛ ba a. Dama dekem bo am sunsun bu am ahore su saŋga kɛrɛ n ye am jɔjɔ bu a.” ");
INSERT INTO cko_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Na Yesu akaaki ase ka, “Nzu ti ye am fere m ka, ‘Ya Mibiɛ, ya Mibiɛ,’ ye am yo má deke bo m se ka am yo a? ");
INSERT INTO cko_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Sɔnɔ kɛrɛ bo i baari m dɔ, na i tiiri m nɔaniɛm n na i deeri bu na i fa yoori juma, m kére am kabo i mi ti barasu. ");
INSERT INTO cko_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","I mi ti ka sɔnɔ bo i ŋa i tá awuru na i fundu kunma ŋgoŋgo na i kɔ kpura yabuɛ, na i se sɔɔ n jaa. Wɔmbu koro wura na nzuetinm kɛrɛ koro yi sandi ba kpura awuru ni, i yó má i pui, dama ataari n ayo faŋga n ti. ");
INSERT INTO cko_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ama, sɔnɔ kɛrɛ bo i tiiri m nɔaniɛm n na wɔ de má i, afa ayo má juma, i mi ti ka sɔnɔ bo i taari i awuru na wɔ se má i jaa yabuɛ su n wɔ. Wɔmbu ba wuraari na nzuetinm kɛrɛ ba yi kpura nyini awuru ni, na i kaba tɔ faŋga su bo i busu ŋu má n wɔ.” ");
INSERT INTO cko_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Saŋga bo Yesu jɔjɔɔri minɛm dɔ ni nyini nɔaniɛm n kɛrɛ wieeri ni, na wɔ kɔ Kapɛnam miɛ kpiri n nu. ");
INSERT INTO cko_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Na Roma­fɔm soja kpiɛn be wo dɔ, i la i akɔɔ bo i koro i agaya, wɔ da tukpaki sukoro ka i wu. ");
INSERT INTO cko_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Soja kpiɛn n tiiri Yesu ŋga ni, na wɔ sunma Yuda­fɔm nkpiɛn­kpiɛnm nbem ka bu kɔ sere i ka i ba tuntun i akɔɔ n na i nya laifiɛ. ");
INSERT INTO cko_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Na ba kɔ Yesu dɔ akɔ asere i jande ka, “I ti ye ni ka a ba buka ahin soja kpiɛn ni. ");
INSERT INTO cko_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Dama i koro ya minɛm n agaya haari wɔ ta tiɛntiɛn­bunɔɔ sɔɔ ama ya.” ");
INSERT INTO cko_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Dɔ na Yesu asu bu su akɔ. Saŋga bo bu kɔ dodoori awuru n kaan sɔ ni, na soja kpiɛn n asunma i danfom Yesu dɔ, bu kɔ juuri ni, na ba se i ka, “Ya Mibiɛ, soja kpiɛn n ŋa má a fie u ŋu. I ŋa i ti kaan ni bo a ba i dika. ");
INSERT INTO cko_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Nyini ti ye i ŋa wɔ bu má ka i ti pui bo i ba u nyunu n a. Ama, haari a maari nɔaniɛ n mmɔɔ, i akɔɔ ni nyá laifiɛ. ");
INSERT INTO cko_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Dama yiri mmɔɔ ni i tii wo sɔnɔ saa nu wɔ, na yiri gusu nya la i dɛɛ sojam bo i niɛ bu su. Na bo i nya se i ka, ‘Kɔ fɛn,’ na i kɔ, na i se nyiŋga gusu ka, ‘Bra fɛn,’ na i ba. Na i se i akɔɔ n gusu ka, ‘Yo ahin,’ na i yo i.” ");
INSERT INTO cko_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Saŋga bo Yesu tiiri sɔ ni, na wɔ yo i alekutura, na wɔ kaaki aniɛ jama n bo bu su i su n na wɔ se ka, “M suse am wɔ lɛɛ, ka, ma nya aŋu má sɔnɔ bo i la yarada agaya ka ahin sɔnɔ n ŋusu, haari fa saŋga ni Yisareli­fɔm mmɔɔ.” ");
INSERT INTO cko_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Na minɛm bo soja kpiɛn n sunmaari bu n akpie bu nyi akɔ i dika. Bu kɔ juuri, na ba ŋu ka i akɔɔ n anya laifiɛ. ");
INSERT INTO cko_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Nyini sin, wɔ cɛ má, na Yesu akɔ miɛ kpiri be bo bu fere i ka Nayin n su, i ni i susu­fɔm, ni jama beberebe kɔɔri a. ");
INSERT INTO cko_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Saŋga bo i kɔ ŋa i wura miɛ n nu ni, kpeŋga i ni minɛm ayɛ, sɔnɔ be awu miɛ n nu, bu susɔ i fite na bu kɔ se i. Sɔnɔ n bo wɔ wu n ti bara kuna­fɔ be wa a, i wa kɛrɛ la yiri ŋgumi kpein wɔ. Na jama beberebe afite miɛ n nu susu kunafɔ n su. ");
INSERT INTO cko_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Mibiɛ Yesu n ŋuuri kuna­fɔ n sɔ ni, na aŋunfɔ ati i, na wɔ se i ka, “Má a sun.” ");
INSERT INTO cko_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Na Yesu akɔ afa i saa akan daŋgu n bo fuin n da su ni, na minɛm bo bu sɔ i n aka ajina. Na Yesu ase ka, “Gbɛfɛnɛ, m suse u wɔ lɛɛ, yasu.” ");
INSERT INTO cko_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Dɔ na gbɛfɛnɛ n ayasu atana na wɔ jɔjɔ minɛm dɔ, na Yesu akaaki afa i ama i ni. ");
INSERT INTO cko_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Na sɛrɛ ati sɔnɔ kɛrɛ, na ba kansi Nyɛmɛ, na ba se bu ŋuŋu nu ka, “Nyɛmɛ nɔaniɛ kan­fɔ bambaka be aba ya dɔ. Nyɛmɛ aba aniɛ i minɛm busu.” ");
INSERT INTO cko_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Sa n bo Yesu yoori i n dɛɛ ti, na i labari n abara ayɛ Yudiya awɔrɛ n kɛrɛ, ni awɔrɛm kɛrɛ bo bu dodo bɛrɛ ni. ");
INSERT INTO cko_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Saŋga bo Yohane dɛɛ susu­fɔm ba kaanri nyini jɔrɛm kɛrɛ kereeri i ni, na wɔ fere bu minɛ nnyɔ, ");
INSERT INTO cko_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","na wɔ sunma bu Mibiɛ Yesu n dɔ ka bu kɔ bisa i ka, “Wɔrɔ ye bu yo seeri ka a bá n a, nzɛn ya ŋminda sɔnɔ fɔfɔrɛ be wɔ?” ");
INSERT INTO cko_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Bu ba juuri Yesu dɔ n na ba se i ka, “Yohane Nyɛmɛ Nzue Biɛ­fɔ ni sunmaari ya u dɔ a, na ya ba bisa u ka, ‘Wɔrɔ ye bu yo seeri ka a bá n a, nzɛn ya ŋminda sɔnɔ fɔfɔrɛ be wɔ?’” ");
INSERT INTO cko_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Nyini saŋga n nu, na Yesu atuntun minɛ beberebe bo bu la tukpaki barasu barasum, na wɔ fɔn ayi ajinim afite minɛm ŋu, na wɔ ma anyinsinm beberebe aŋu asi. ");
INSERT INTO cko_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Na Yesu ase minɛm bo Yohane sunmaari bu n ka, “Am kpie am nyi na am kɔ se Yohane fa kɔ sam bo am ati bu na am aŋu bu ni, ka anyinsinm aŋu asi, wɔbukam akoro anati, koko­fɔm anya laifiɛ, asuturim ati asui, minɛm bo ba wu n ateŋge, na yaari­fɔm gusu akoro ati labari kpa ni. ");
INSERT INTO cko_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Tere­fiɛ wo minɛm bo bu yo m yarada na bu la má sika be, ni mini n dɔ.” ");
INSERT INTO cko_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Saŋga bo minɛm bo Yohane sunmaari bu n kɔ wieeri ni, na Yesu ajɔjɔ jama n dɔ, fa kɔ Yohane ŋusu jɔrɛ. I ŋa, “Saŋga bo am fite kɔɔri Yohane dɔ boro kpantain n nu ni, am kɔɔri ka am kɔ ŋu nzu wɔ? Am kɔɔri ka am kɔ ŋu sɔnɔ bo i ti ka barankpaati fofoe bo aŋuma n kankan i wɔ? ");
INSERT INTO cko_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Nzɛn má nyini, am fite kɔɔri ka am kɔ ŋu nzu wɔ? Am ŋa am kɔ ŋu sɔnɔ bo i wura sutura kpakpa a, nzɛn sɛ? Ai, am si ka minɛm bo bu wura nyini suturam na bu di fiɛfiɛ ni, bu wo nfɛmɛm dika a. ");
INSERT INTO cko_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Nzɛn má nyini, am kɔɔri ka am kɔ ŋu nzu wɔ? Am kɔɔri ka am kɔ ŋu Nyɛmɛ nɔaniɛ kan­fɔ ɔ, nzɛn sɛ? Ɛɛn, m suse am wɔ lɛɛ, ka, am aŋu sɔnɔ bo i tara Nyɛmɛ nɔaniɛ kan­fɔ. ");
INSERT INTO cko_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Dama Yohane ye bu yo kɛrɛɛri i ŋusu jɔrɛ, Nyɛmɛ Jɔrɛ Kadasi n nu ka, ‘Nyɛmɛ ŋa o, “M dú mɔ sunma m sunma­fɔ n na i dú u mɔ, yiri kɔ́ yo atin n dɔŋgu se u a.”’ ” ");
INSERT INTO cko_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Dɔ na Yesu ase bu ka, “M suse am wɔ lɛɛ, ka, sɔnɔ wo má durunya n nu fɛn bo i tara Yohane. Ama, sɔnɔ kɛrɛ bo i ti kaan Nyɛmɛ fɛmɛya n nu n tara yiri Yohane.” ");
INSERT INTO cko_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Minɛm kɛrɛ bo bu woori dɔ ni, haari fa saŋga ni lampo­de­fɔm ni, tiiri kabo Yesu jɔjɔɔri ni, na ba soro su ka Nyɛmɛ dɛɛ atin ni ti atin nahɔrɛ a, dama bu ma Yohane adu mɔ abiɛ bu Nyɛmɛ nzue. ");
INSERT INTO cko_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ama, na Farasi­fɔm ni Nyɛmɛ nɔaniɛ kere­fɔm n akete kabo Nyɛmɛ kereeri ka bu yo ni, dama ba kete ka má Yohane biɛ bu Nyɛmɛ nzue. ");
INSERT INTO cko_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Na Yesu ase bekun ka, “Ye m fá nzu fa sunsun kabo nyuma­fɔ ti a? Bu ti ka nzu wɔ? ");
INSERT INTO cko_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Bu ti ka nbaatuma kan kanm bo bu tana gɔɔsu wɔ, na bu sufere bu beŋgu, bu ŋa, ‘Ya kan tere ama am, ama, am abo má kereba. Ya di sɛɛ jue ama am, ama, am asun má.’ ");
INSERT INTO cko_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Deke bo i ti na m se sɔ n la ka, Yohane Nyɛmɛ Nzue Biɛ­fɔ n ba juuri ni, i ciciiri i nɔɔ ɔ, i di má diire, i nu má nzan yiri fieo, nyini ti, na am ase ka ajini wo i ŋu. ");
INSERT INTO cko_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ama, mini Adamande Wa n ba juuri, na m ni minɛ asaŋga adi, na ya saŋga anu, na am ase ka, ‘Am niɛ, ahin sɔnɔ n yiri, i ti ayaakpiri­fɔ ɔ, na i nu nzan nahɔrɛ su. Wɔ tara lampo­de­fɔm, ni satiɛ­yo­fɔm danfoya.’ ");
INSERT INTO cko_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Tɔ, minɛm kɛrɛ bo bu su Nyɛmɛ dɛɛ alecira n atin n su ni, bɛrɛ kere ka i ti nahɔrɛ a.” ");
INSERT INTO cko_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Farasi­fɔ be yo baandiiri Yesu a, ka i bra i dika ba di diire, na Yesu akɔ i dika, na wɔ kɔ awura ka i di diire ni. ");
INSERT INTO cko_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Bara be woori nyini miɛ n nu, i ti satiɛ­yo­fɔ ɔ. I tiiri ka Yesu wo Farasi­fɔ n dika n wo diire di su, na wɔ fa tulaalɛɛ nva­nvani tuwa kun aba. ");
INSERT INTO cko_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Na wɔ ba ajina Yesu jaa dika, na i susun, na i nyunvuin sugɔ Yesu jaa su. Na wɔ kutu aso i jaa nu, na wɔ fa i tii­ŋmiɛ tintiin anunuka i, na wɔ kaaki tulaalɛɛ n agɔ i jaa nnyɔ n kɛrɛ su. ");
INSERT INTO cko_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Na Farasi­fɔ n bo i baandiiri Yesu n ase i kunnu ka, “Ahin sɔnɔ n ti má Nyɛmɛ nɔaniɛ kan­fɔ, nzɛn má i ti Nyɛmɛ nɔaniɛ kan­fɔ, má i si ahin bara n bo i sufa i saa kan i n kabo i woo­wa ti barasu, má i si ka i ti satiɛ­yo­fɔ.” ");
INSERT INTO cko_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Dɔ na Yesu ase i ka, “Simon, m koro ka m se u jɔrɛ be.” Na wɔ se Yesu ka, “Ya Kere­fɔ, se m.” ");
INSERT INTO cko_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Na Yesu ase i ka, “Minɛ nnyɔ nbem wo bɛrɛ a, na ba kɔ ŋwaa­fɔ be dɔ akɔ afiɛ ŋwaa. Kun dɛɛ kaari n sunnu má, ama, kun n yiri dɛɛ sunnu, i kpaaki ciciri dɛɛ n ŋusu buru. ");
INSERT INTO cko_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Bu minɛ nnyɔ n nu, bu be mmɔɔ akoro atɔ má ŋwaa­fɔ n kaari ni, nyini ti, na wɔ yaki ŋwaa n ace bu. Ye a sunsun ka bu minɛ nnyɔ n nu, ŋma koro ŋwaa­fɔ n agaya?” ");
INSERT INTO cko_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Na Simon abɔ Yesu nu ka, “Mini dɔ, m sunsun ka sɔnɔ n bo i kaari sunnuuri ni, yiri koro i agaya.” Na Yesu ase i ka, “A la nahɔrɛ.” ");
INSERT INTO cko_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Dɔ na Yesu acɛ aniɛ bara ni, na wɔ se Simon ka, “M ŋa a ŋu ahin bara ni e? M ba juuri u dika n nu ni, a ma má m nzue ka m ŋmisi m jaa, ama, yiri afa i nyunvuin aŋmisi m jaa, ye wɔ fa i tii­ŋmiɛ n anunuka m jaa n na i wu. ");
INSERT INTO cko_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Bekun, a biti má m na a yo m ansɛ ni ba mmɔɔ, ama, kabo m ba juuri, yiri akere kabo i koro m, wɔ yaki má m jaa so nu. ");
INSERT INTO cko_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","A fa má ŋguin ka a kpakpa má m tii, ama, yiri afa tulaalɛɛ akaaki agɔ m jaa su. ");
INSERT INTO cko_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Nyini ti, m suse u wɔ lɛɛ ka, i satiɛ sunnu ye Nyɛmɛ afa i kɛrɛ ace i a, nyini dɛɛ ti, wɔ kere m i koro agaya. Ama, sɔnɔ bo i satiɛ sunnu má na Nyɛmɛ afa ace i a, i mi koro mmɔɔ sunnu má.” ");
INSERT INTO cko_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Dɔ na Yesu ase bara n ka, “Ma fa u satiɛ kɛrɛ ace u.” ");
INSERT INTO cko_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Minɛ nyiŋgam n bo bɛrɛ gusu tana wo diire n di su n tiiri sɔ ni, na ba bisa bu ŋuŋu nu ka, “Ŋma la ahin sɔnɔmbiri n bo i koro fa minɛm satiɛ ce bu a?” ");
INSERT INTO cko_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Na Yesu akaaki ase bara n ka, “Yarada n bo a yo m ni, nyini ma a nya u tii a. Kɔ awuru ni ahoreda.” ");
INSERT INTO cko_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Nyini sin na Yesu ajeŋgbe miɛ kpirim, ni ahɛmɛ ahɛmɛ miɛm su, na i sukan labari kpa n fa kɔ Nyɛmɛ fɛmɛya n su. I ni i susu­fɔ buru ni nnyɔm ni kɔɔri a. ");
INSERT INTO cko_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Na nbara beberebe nbem gusu asu i su. Bu nbem ye i tuntuunri bu tukpaki barasu barasu n a. Bu kun ye i fɔn yiiri ajinim nso fiteeri i ŋu n a, bu fere i ka Mariya Magadala­fɔ ni, ");
INSERT INTO cko_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ni kun bo bu fere i ka Yowana, na i hun la sɔnɔ be bo bu fere i ka Cusa na i niɛ Fɛmɛ Herode dika n kɛrɛ su ni, ni bara bo bu fere i ka Susanna ni. Nyini nbaram kɛrɛ fa bu tiɛŋgu deke bo bu la i wɔ, na ba fa abuka Yesu ni i susu­fɔm ni. ");
INSERT INTO cko_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Na jama beberebe atiɛn bu nɔɔ Yesu dɔ, bu fiteeri miɛ su miɛ su baari a. Na wɔ bo bu ahin miɛɛnu ni, i ŋa, ");
INSERT INTO cko_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Dɔdɔɔri­fɔ be fiteeri sɔ ɔ, ka i kɔ sandi alɛ­mbaa. Saŋga bo i wo sandi su ni, na nbem atɔtɔ atin n nɔɔ, na minɛm atiɛntiɛn su asin, na anumam aba atambu bu ami. ");
INSERT INTO cko_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Na nbem atɔtɔ tiɛka su, na wɔ fi, wɔ cɛ má na wɔ waandi, dama niniki awo má asiɛn n bu n dɛɛ ti. ");
INSERT INTO cko_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Na alɛ­mbaa ni nbem atɔtɔ lɔlɔɛ nu, na lɔlɔɛ n anyi akata i ŋu. ");
INSERT INTO cko_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ama, na nbem atɔtɔ asiɛn kpa su, na wɔ nyi awura mbaa zɔi zɔi.” Yesu seeri sɔ wieeri ni, na wɔ nya atiɛn kpa ase ka, “Bo i koro ka i ti ahin jɔrɛ n bu, i ti ye ni ka i so i sui na i ti.” ");
INSERT INTO cko_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Dɔ na Yesu susu­fɔm n abisa i nyini miɛɛnu n bu, ");
INSERT INTO cko_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","na wɔ bɔ bu nu ka, “Ambɛrɛ ye Nyɛmɛ ama am asi i fɛmɛya n nu asiri jɔrɛ kɛrɛ a, ama, bo ba ka ni, m bobo i miɛɛnu kere bu a. Adena i yó kabo ba kɛrɛ i Nyɛmɛ Jɔrɛ Kadasi n nu ni, ka, ‘Bu níɛ wɔ, ama, bu ŋú má pui. Bu só bu sui wɔ, ama, bu tí má deke n bo bu so bu sui ka bu ti i n bu.’” ");
INSERT INTO cko_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Na Yesu asa su ase bu ka, “Tɔ, miɛɛnu n bo m boori i n bu yaa. Alɛ­mbaa n ti Nyɛmɛ nɔaniɛ n wɔ lɛɛ. ");
INSERT INTO cko_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Alɛ­mbaa n bo bu tɔtɔɔri atin nɔɔ n la minɛm bo bu ti Nyɛmɛ nɔaniɛ ni, i cɛ má, na Sitana bá yi i fite bu ahore su, adena má bu yó yarada na bu nyá tii­de. ");
INSERT INTO cko_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Alɛ­mbaa n bo bu tɔtɔɔri tiɛka su n la minɛm bo bu ti Nyɛmɛ nɔaniɛ n na bu de i ni ahorejɔ, ama, i da má bu ahore su. Bu kaaki ti ka alɛ­mbaa n bo i bunlui akpama abi má n wɔ. I woori bu dɔ kaan sɔ, na saŋga bo kekereke be ba tuuri bu, a ŋu ka ba fa ati. ");
INSERT INTO cko_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Alɛ­mbaa n bo bu tɔtɔɔri lɔlɔɛ nu n la minɛm bo bu nya tiiri Nyɛmɛ nɔaniɛ ni na bu su i atin su, a ŋu ka bu sunsunni kɛrɛ wo kabo bu yó na bu asiri káta su, na bu nyá durunya n nu ajɛkɛm, na bu yó bu koroo­wa, a ŋu ka Nyɛmɛ nɔaniɛ n koro da má bu ahore su na i yo juma. Bu ti ka alɛ­mbaa bo i bi má n wɔ. ");
INSERT INTO cko_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ama, alɛ­mbaa n bo bu tɔtɔɔri asiɛn kpa su n la minɛm bo bu ti Nyɛmɛ nɔaniɛ n na bu de i ni bu ahore fofoe nahɔrɛ su, na bu de i ni bu saa nnyɔ, na bu mindi bita i, na bu fa i yo juma ni.” ");
INSERT INTO cko_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Na Yesu ase ka, “Sɔnɔ be nya so má fitana su na i fa gaŋga butu su, wara i fa se gado bu, ama, i fa taka deke su aŋgoro wɔ, adena minɛm bo bu ba wura awuru n nu n koro ŋu asi. ");
INSERT INTO cko_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Deke be wo má bɛrɛ bo i wo fiɛɛ­wa nu na bu bá ŋu má i, deke be gusu wo má bɛrɛ bo i wo asiri nu na bu bá si má i. ");
INSERT INTO cko_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Nyini dɛɛ ti, am si am ŋu sa ni kabo am ti nɔaniɛ n barasu ni. Dama sɔnɔ kɛrɛ bo wɔ nya deke be Nyɛmɛ dɔ na i mi si i bita, Nyɛmɛ búka i su wɔ, ama, bo i si má i bita, haari ni nyini kaan n bo i sunsun ka wɔ nya i ni, Nyɛmɛ dé i dɔ ɔ.” ");
INSERT INTO cko_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Na Yesu ni, ni i niɛmam aba i dɔ, ama, jama sunnuuri i dɔ n dɛɛ ti, ba koro aju má i bi. ");
INSERT INTO cko_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Na be ase i ka, “M Mibiɛ, u ni, ni u niɛmam jina dasin koro u.” ");
INSERT INTO cko_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Na Yesu ase bu ka, “M ni, ni m niɛmam la minɛm bo bu ti Nyɛmɛ nɔaniɛ n na bu de i na bu fa yo juma n wɔ.” ");
INSERT INTO cko_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Cɛɛn n be sɔ ɔ, na Yesu ni i susu­fɔm n awura lee nu, na wɔ se bu ka, “Am ma ya kpiɛ kɔ kunma kpiri n buekun dɔ.” Nyini ti, na ba yasu na bu kɔ. ");
INSERT INTO cko_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Bu wo kɔ su ni, na Yesu adaafi, na aŋuma bambaka be ayasu na i subo nzue gɔ lee n nu. Má lee ni suyi ni nzue wɔ, na anyum­boro atu bu. ");
INSERT INTO cko_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Na Yesu susu­fɔm n akɔ ateŋge i, na ba se i ka, “Ya Mɔ­fɔ, ya Mɔ­fɔ e, ya wu awie.” Na Yesu ayasu, na wɔ tiɛn nzue n ni aŋuma n bo i subo n ŋu, na ba tara, na dika n atara jum. ");
INSERT INTO cko_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Dɔ na Yesu ase i susu­fɔm ni ka, “Nzu ti ye am yo má m yarada a?” Na ba yo alekutura na sɛrɛ akaaki ati bu agaya, na ba bisa bu ŋuŋu nu ka, “Nzu sɔnɔmbiri barasu la ahin bo i ma aŋuma ni nzue mmɔɔ nɔɔ na bu de i a?” ");
INSERT INTO cko_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Na Yesu ni i susu­fɔm n akpiɛ kunma kpiri n akɔ aju Gɛrasafɔm dɛɛ awɔrɛ n nu, na kunma kpiri n wo i ni Galili dɛɛ awɔrɛ n afiɛn ni. ");
INSERT INTO cko_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesu fiteeri lee n nu ni, na miɛ n nu sɔnɔ be aba akpa i atin, ajinim wo i ŋu, wɔ cɛ, i nati i bu ŋgbɛɛn wɔ saŋga kɛrɛ, i da má awuru, má ka faŋ­kunma nu. ");
INSERT INTO cko_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","I ŋuuri Yesu ni, na wɔ bo awie kpa, na wɔ kutu haari Yesu jaa bu, na wɔ ciindi ase ka, “Yesu, Micɛra Nyɛmɛ Kpiri n Wa, a koro nzu ya nu fɛn a? M sere u wɔ ka, má a ma m ŋu anyum­boro.” ");
INSERT INTO cko_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Deke bo i ti na i seeri sɔ n la ka, Yesu ama ajinim n nɔɔ ka bu fite yaki i. Saŋga kɛrɛ saŋga ajinim n fun i ŋu wɔ, haari ni bo bu niɛ i dika, na bu bo i tobari, na bu wura i jɔrɔkɔ buka su ni, i sandi i kɛrɛ wɔ, na ajinim n fa i kɔ boro kpantain n nu. ");
INSERT INTO cko_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Na Yesu abisa i ka, “Bu fere u sɛ?” Na wɔ bɔ i nu ka, “Bu fere m ka Jama Beberebe­fɔ.” Deke bo i ti na i seeri sɔ n la ka, ajinim beberebe wo i ŋu wɔ. ");
INSERT INTO cko_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Na ba sere Yesu jande ka má i fɔn bu kɔ wura kunma n bo i kɔ ŋgoŋgo na i la má awieeri n nu. ");
INSERT INTO cko_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Nyini saŋga afam beberebe wo dodo bɛrɛ, bu wo buka be su sudi, na ajinim n asere Yesu ka i ma bu kɔ fun afam n ŋu, na wɔ ma bu atin. ");
INSERT INTO cko_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Na ba fite ayaki sɔnɔ ni, na ba kɔ afun afam n ŋu. Dika n nu bɛrɛ, na bu kɛrɛ aŋmati acɔɔndi akɔ ato kunma kpiri nzue n nu, na nzue n adi bu. ");
INSERT INTO cko_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Afa sasa­fɔm n ŋuuri nyini n sɔ ni, na ba ŋmati akɔ abo ndoori miɛ kunnu, ni ahɛmɛ ahɛmɛ kɛrɛ su. ");
INSERT INTO cko_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Na minɛm aba na bu ba niɛ sa n bo wɔ yo ni, na ba ba Yesu dɔ, aŋu sɔnɔ n bo ajinim n yo woori i ŋu n ka i tana Yesu bi wura tanlɛɛ, ni i nyunu koroya su. Dɔ na sɛrɛ ati bu. ");
INSERT INTO cko_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Na minɛm n bo bu ŋuuri sa n yoo­biri ni, akan jɔrɛ n kɛrɛ akere jama n kabo i ba yoori na sɔnɔ n bo ajinim yo woori i ŋu n anya laifiɛ ni. ");
INSERT INTO cko_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Na minɛm kɛrɛ bo bu fite nyini awɔrɛ n nu n asere Yesu jande ka, i yasu bu awɔrɛ n nu bɛrɛ, dama sɛrɛ ati bu agaya. Na Yesu ayasu awura lee nu ka i kɔ. ");
INSERT INTO cko_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Dɔ na sɔnɔ n bo ajinim afite ayaki i n asere Yesu ka, i ma i su i su. Ama, Yesu asoro má i su, na wɔ se i ka, ");
INSERT INTO cko_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Kpie u nyi kɔ awuru, na a kɔ kan kere minɛm fa kɔ sakpa n bo Nyɛmɛ ayo ama u n su.” Na sɔnɔ n akpie i nyi akɔ akan akere miɛ n nu­fɔm kɛrɛ fa kɔ sakpa n kɛrɛ bo Yesu ayo ama i ni. ");
INSERT INTO cko_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Saŋga bo Yesu kpieeri i nyi kɔ juuri kunma kpiri n buekun dɔ ni, i kɔ ŋu ka jama n atiɛn bu nɔɔ suŋminda i wɔ, na ba yo i ansɛ ni ba. ");
INSERT INTO cko_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Dɔ na sɔnɔ be aba Yesu dɔ, yiri ti kpiɛn bo i niɛ bu tiɛntiɛn­bunɔɔ sɔɔ n su a, bu fere i ka Yarusi. Na wɔ ba akutu asiɛŋgu Yesu jaa bu asere i ka, jande i bra i dika, ");
INSERT INTO cko_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","dama i wa baa­bara kun n kpein bo i la i n suwu, i la afɔ buru ni nnyɔ ɔ. Yesu wo kɔ su n na jama n amiɛ i ŋu agaya. ");
INSERT INTO cko_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Bara be woori jama n nu, i bita abiɛɛri i afɔ buru ni nnyɔ lɛɛ, bo i kpu na i kpiɛ má, ama, be akoro atuntun má i na i nya laifiɛ. ");
INSERT INTO cko_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Na wɔ sakati awura jama n nu Yesu sin, afa i saa akan Yesu tanlɛɛ n jaa bu ni, kpeŋga na abiɛɛri n ajina. ");
INSERT INTO cko_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Na Yesu abisa ka, “Ŋma fa i saa kaanri m a?” Na sɔnɔ kɛrɛ ase ka ba si má, na Petoro ase i ka, “Ya Mɔ­fɔ, wɔrɔ mmɔɔ ŋu kabo jama n abara ayɛ na bu miɛ u ŋu barasu.” ");
INSERT INTO cko_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ama, na Yesu ase ka, “Sɔnɔ be afa i saa akan m, dama ma fa nu ka m yiko n be afite m ŋuniɛ nu akɔ ayo juma.” ");
INSERT INTO cko_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Na bara n aŋu ka i koro fiɛ má i ŋu, na wɔ ba ajina Yesu nyunu, i ŋuniɛ kɛrɛ subobo i. Na wɔ kutu haari Yesu jaa bu akan jɔrɛ n akere i, jama n kɛrɛ nyunu, kabo i ba yoori na i kaba nyaari laifiɛ ni. ");
INSERT INTO cko_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Na Yesu ase i ka, “M wa, yarada n bo ayo m ni, yiri ma a nya laifiɛ a. Kɔ awuru ni ahoreda.” ");
INSERT INTO cko_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Saŋga n bo Yesu toko wo jɔjɔ su ni, na sɔnɔ be afite tiɛntiɛn­bunɔɔ sɔɔ n kpiɛn n dika aba ase i ka, “U wa n wo má bɛrɛ. Nyini ti, má a dama ya Kere­fɔ n kun.” ");
INSERT INTO cko_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ama, na Yesu ati jɔrɛ n na wɔ se baa n si n ka, “Má a ma sɛrɛ ti u, wɔrɔ yo m yarada, i nyá laifiɛ.” ");
INSERT INTO cko_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Bu kɔ juuri kpiɛn n dika n nu ni, wɔ soro má su, na be wura buka i su, má ka Petoro, ni Yakobo, ni i niɛma Yohane, ni baa n si, ni i ni. ");
INSERT INTO cko_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Minɛm kɛrɛ bo bu woori dɔ n wo awie bo su wɔ, na bu sukoko. Nyini dɛɛ ti, na Yesu ase ka, “Má am sun, wɔ wu má, wɔ daafi wɔ.” ");
INSERT INTO cko_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Na ba siri i, dama bu si ka wɔ wu wɔ. ");
INSERT INTO cko_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ama, na Yesu akɔ atara i saa, na wɔ tiɛn kpa ase i ka, “M wa, yasu jina.” ");
INSERT INTO cko_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Na wɔ nya ŋgɔɔ bekun, na wɔ kaba ayasu ajina, na Yesu ase ka bu ma baa n deke be na i di. ");
INSERT INTO cko_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Na baa n si, ni i ni ayo alekutura akɔ asin su, ama, na Yesu abɔbɔ bu ni nahɔrɛ su ka, má bu ma be si sa n bo wɔ yo ni. ");
INSERT INTO cko_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Na Yesu afere i susu­fɔ buru ni nnyɔm ni, na wɔ tiɛn bu nɔɔ, na wɔ ma bu yiko ka bu kɔ sufɔn yi ajini barasu barasum kɛrɛ fite minɛm ŋu, na bu ma tukpaki­fɔm nya laifiɛ. ");
INSERT INTO cko_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Dɔ na wɔ sunma bu ka bu kɔ kan Nyɛmɛ jɔrɛ fa kɔ kabo Nyɛmɛ bá niɛ i minɛm su ni, na bu tuntun tukpaki­fɔm na bu nya laifiɛ, ");
INSERT INTO cko_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","na wɔ se bu ka, “Má am fa puitiri­pui kɔ ahin atin n bo m susunma am ni, kpama o, kuruku o, diire o, ŋwaa o. Má am fa tanlɛɛ be mmɔɔ buka bo am wura i n su. ");
INSERT INTO cko_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Am kɔ juuri miɛ be su, na awuru kɛrɛ bo am kɔ wuraari nu, am ka nyini awuru n nu haari am bá fite miɛ n nu. ");
INSERT INTO cko_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Sasu bekun, miɛ bo am kɔ wuraari nu, na ba de má am wɔfɔ, am fite yaki nyini miɛ ni, na am kpɔnkpɔn yi am jaa tuturi kɛrɛ. Nyini dí daani kere bu ka bu woo­wa ti má kpa.” ");
INSERT INTO cko_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Na i jaramasam n akɔ ajeŋgbe abara ayɛ miɛ miɛm su akan labari kpa n jɔrɛ akere minɛm deke n kɛrɛ bo bu kɔɔri ni, na ba tuntun tukpaki­fɔm na ba nya laifiɛ. ");
INSERT INTO cko_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Na Fɛmɛ Herode ati sa n kɛrɛ bo Yesu ayo i ni, na wɔ birisi, dama minɛ nbem ŋa Yohane Nyɛmɛ Nzue Biɛ­fɔ n ye wɔ teŋge i yiwee n nu a, ");
INSERT INTO cko_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ye nbem ŋa Nyɛmɛ nɔaniɛ kan­fɔ Eliya ye wɔ yi i ŋu afite fofoe nu, na nbem gusu ase ka dawa dɛɛ Nyɛmɛ nɔaniɛ kan­fɔ nyiŋga n be ye wɔ kaaki ateŋge aba a. ");
INSERT INTO cko_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Na Fɛmɛ Herode ase ka, “M ma ba kpiɛ Yohane tii e, ye ŋma la ahin sɔnɔ n bo m ti i sa­yoo­wam ŋga sɔ n a?” Na wɔ boro i nyi ka i ŋu Yesu. ");
INSERT INTO cko_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Saŋga bo Yesu jaramasam n kpieeri bu nyi baari i dɔ ni, na ba kan sam kɛrɛ bo ba yo i n akere i. Na wɔ fa bu na ba kɔ awo miɛ be su awɔrɛ be nu bɛrɛ ŋgumi. Bu fere miɛ n ka Besayida. ");
INSERT INTO cko_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Jama n tiiri Yesu ŋga sɔ ni, na ba sa i su akɔ dɔ. Na wɔ de bu, na wɔ kan Nyɛmɛ jɔrɛ fa kɔ kabo Nyɛmɛ bá niɛ i minɛm su barasu. Na wɔ tuntun tukpaki­fɔm, na ba nya laifiɛ. ");
INSERT INTO cko_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Saŋga bo wiɛ ba sukɔ tɔ ni, na i jaramasam n aba i dɔ aba ase i ka, “Ma minɛm n atin na bu kɔ miɛ kunnu ni ahɛmɛ ahɛmɛ miɛm su na bu kɔ niɛniɛ diire di na bu nya daa­biri da, dama deke bo ya wo ni, ya wo boro wɔ lɛɛ.” ");
INSERT INTO cko_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ama, na Yesu ase bu ka, “Ambɛrɛ mmɔɔ ni am tii nya deke be ma bu na bu di.” Na ba se i ka, “Deke bo ya la i kɛrɛ la kpɔnɔ nnu wɔ, ni jombaa nnyɔ, i jú má. A koro ka ya kɔ to diire ba ma ahin jama n kɛrɛ wɔ, nzɛn sɛ a?” ");
INSERT INTO cko_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Deke bo i ti na bu seeri sɔ n la ka, nbiɛsɔm kɔ yasuuri minɛ akpii nnu wɔ. Na Yesu ase i susu­fɔm n ka, “Am ma bu tana asɛsɛ asɛsɛ aburu­nu nnu na bu di.” ");
INSERT INTO cko_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","I susu­fɔm ni maari bu kɛrɛ tanaari sɔ wieeri ni, ");
INSERT INTO cko_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","na Yesu afa kpɔnɔ nnu ni, ni jombaa nnyɔ ni, na wɔ yɛ i tii su aŋgoro, na wɔ da Nyɛmɛ asi, na wɔ kpiɛkpiɛ i kɛrɛ n nu, na wɔ fa ama i susu­fɔm ni ka bu fa ma minɛm ni. ");
INSERT INTO cko_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Na bu kɛrɛ adi, na bu kunnu ayi. Na ba tambu kpɔnɔ, ni jombaa sinsin bo bu diiri na i kaari ni, na ba nya kandiɛ buru ni nnyɔ. ");
INSERT INTO cko_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Cɛɛn n be sɔ ɔ, Yesu wo nyɛmɛsere su i ŋgumi, i susu­fɔm ni wo i bi. I sereeri Nyɛmɛ wieeri n na wɔ bisa bu ka, “Minɛm fa m bu ŋma a?” ");
INSERT INTO cko_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Na ba bɔ i nu ka, “Bu ŋa wɔrɔ ti Yohane Nyɛmɛ Nzue Biɛ­fɔ n a, nbem ŋa wɔrɔ ti Nyɛmɛ nɔaniɛ kan­fɔ Eliya, ye nbem gusu ŋa wɔrɔ ti dawa dɛɛ Nyɛmɛ nɔaniɛ kan­fɔ nyiŋga n be ye wɔ teŋge aba a.” ");
INSERT INTO cko_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Na wɔ nya abisa bu bekun ka, “Ye ambɛrɛ fa m bu ŋma a?” Na Petoro abɔ i nu ka, “Wɔrɔ ti Kristo n a, Tii­de­fɔ n bo Nyɛmɛ ase ka i súnma i ni.” ");
INSERT INTO cko_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Na Yesu abɔbɔ bu ka, má bu se ka bu se be jɔrɛ n bo Petoro ajɔjɔ i ni, ");
INSERT INTO cko_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","i ŋa, “Wɔ yo daka ka mini Adamande Wa n di wahara dɔŋgu, na Yuda­fɔm nkpiɛn­kpiɛnm, ni Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ nkpiɛn­kpiɛnm, ni Nyɛmɛ nɔaniɛ kere­fɔm kɛrɛ bá kete m ŋu, na bu kún m. Ama, na i le­san cɛɛn, na Nyɛmɛ má m teŋge m yiwee n nu.” ");
INSERT INTO cko_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Na wɔ se bɛrɛ kɛrɛ pepere ka, “Sɔnɔ kɛrɛ bo i koro ka i su m su, wɔ yo daka ka i mi wara fi i tiɛŋgu sa koroo­wa sa, na i fá i yiwee baka jaanu n sɔ, na i su m su cɛɛn kɛrɛ cɛɛn. ");
INSERT INTO cko_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Dama sɔnɔ kɛrɛ bo i koro ka i fa i ŋgɔɔ fiɛ, i mi bá fun i. Ama, sɔnɔ kɛrɛ bo i tɔɔri i ŋgɔɔ mini dɛɛ ti, i mi nyá ŋgɔɔ. ");
INSERT INTO cko_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Nzɛn sɔnɔ nyaari durunya n nu deke n kɛrɛ na i fuunri i ŋgɔɔ na i kaari ŋgbɛɛn, i kpɛrɛ la bɔnɔ? ");
INSERT INTO cko_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Sɔnɔ kɛrɛ bo nyinsɛ ti i fa kɔ mini ni m nɔaniɛ n su, sɔ ye nyinsɛ tí mini Adamande Wa n gusu fa kɔ bu su a, saŋga bo m bá ba ni m jirima woo­wa n nu, ni m Si Nyɛmɛ dɛɛ jirima woo­wa ni, ni i mɛrɛkɛ casim ni. ");
INSERT INTO cko_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nahɔrɛ ye m suse am n a, am nbem wo nu fɛn bo am wú má, má ka am aba aŋu ka Nyɛmɛ fɛmɛya n aba.” ");
INSERT INTO cko_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesu jɔjɔɔri nyinim kɛrɛ wieeri sɔ ni, fa kɔ i le­mɔcuɛ cɛɛn, na wɔ fa Petoro ni Yohane ni Yakobo na ba fun akɔ buka be su ka bu kɔ sere Nyɛmɛ. ");
INSERT INTO cko_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","I wo nyɛmɛsere n su ni, na i nyunu­awa akaaki wo, na i tanlɛɛ n akaaki fofoe papasi. ");
INSERT INTO cko_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Dɔ na minɛm nnyɔ nbem atiɛ bu ŋu, bu ni Yesu subo anzama. Bɛrɛ la Moyisi ni Eliya, dawa dɛɛ Nyɛmɛ nɔaniɛ kan­fɔm ni. ");
INSERT INTO cko_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Na bɛrɛ gusu ata fofoe papasi, na bu sujɔjɔ i dɔ fa kɔ kabo i saŋga bá ju bo i kɔ́ Yɛrusalem miɛ kpiri n nu ni, na i yoori sɔ na Nyɛmɛ koroo­wa n yó yii­wa. ");
INSERT INTO cko_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Nyini saŋga, Petoro ni i beŋgum wo daafiri su, bu ba teŋgeeri n na ba ŋu kabo Yesu woo­wa n akaaki barasu, i ni minɛ nnyɔm ni jina. ");
INSERT INTO cko_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Saŋga bo minɛm n ba sukɔ yaki Yesu ni, na Petoro ase i ka, “Ya Mɔ­fɔ, i ti kpa ka ya wo fɛn. Ma ya bo nambue nsan, u dɛɛ kun, Moyisi dɛɛ kun, na Eliya gusu dɛɛ kun.” I jɔjɔ ɔ, wɔ si má kabo i seeri ni. ");
INSERT INTO cko_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","I toko wo jɔjɔɔri su n na yinyiŋgu akata bu ŋu liim, na sɛrɛ ati i susu­fɔm ni, saŋga bo yinyiŋgu n sukata bu ŋu ni. ");
INSERT INTO cko_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Na ba ti akonvi be ŋga yinyiŋgu n nu, i ŋa, “M wa lɛɛ, yiri ye ma yi i a. Am de i nɔaniɛ.” ");
INSERT INTO cko_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Bu tiiri jɔjɔɔ­wa n sɔ ni, bu ŋu ka Yesu ŋgumi jina a. Nyini saŋga ni, i susu­fɔm n abo má su akan akere má be fa kɔ sam n bo bu ŋuuri i n su. ");
INSERT INTO cko_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Na i alecin, na Yesu ni i susu­fɔ nsanm ni sujura buka n su ni, na jama beberebe akpa i atin. ");
INSERT INTO cko_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Dɔ na sɔnɔ be awo jama n nu atiɛn ase ka, “Ya Kere­fɔ, m sere u wɔ, si m wa baa­biɛsɔ n aŋunfɔ, m wa kɛrɛ lɛɛ. ");
INSERT INTO cko_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Niɛ, ajini wo i ŋu, saŋga kɛrɛ bo i ba ŋa i yasu i ŋu, i kaba bo awie kungere­kun wɔ, na i fa i bo asiɛŋgu, na i nanzue sufite fufuku, i bita i kere i wahara sɔ ɔ saŋga kɛrɛ, i koro má ka i fite yaki i. ");
INSERT INTO cko_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ma sere u susu­fɔm ni lɛɛ ka bu fɔn yi ajini ni, ama, ba kura má nu.” ");
INSERT INTO cko_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Na Yesu ase ka, “Amaa. Ambɛrɛ nyuma­fɔ satiɛ­yo­fɔm, am la má yarada fieo. Nyuma sa ye m wo am dɔ fɛn a? Ye m yó sawɔrɛ ni ambɛrɛ kɔ ju sɛ wɔ?” Dɔ na wɔ se baa n si ka, “Fa baa n bra fɛn.” ");
INSERT INTO cko_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Saŋga bo baa ni suba Yesu dɔ ni, na ajini n abo i aji asiɛŋgu, na wɔ da sukpisi. Na Yesu atiɛn ajini n ŋu na baa n anya laifiɛ, na wɔ kaaki afa i ama i si. ");
INSERT INTO cko_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Na minɛm kɛrɛ amiɛ fa kɔ yiko bambaka bo Nyɛmɛ la i ni. Sam n kɛrɛ bo Yesu woori bu yo su n dɛɛ ti, nyini ma minɛ kɛrɛ yoori alekutura n a. Dɔ na wɔ se i susu­fɔm ka, ");
INSERT INTO cko_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ambɛrɛ, am so am sui na am ti deke bo m koro ka m se am ni. Bu bá tɔ mini Adamande Wa n ma minɛ nbem.” ");
INSERT INTO cko_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ama, i jɔjɔɔri sɔ ni, i susu­fɔm n ati má i bu. Nyɛmɛ ayi má i nyi akere má bu, nyini ti ye ba koro ati má i bu. Ama, sɛrɛ dɛɛ ti, ba koro abisa má i fa kɔ nyini jɔrɛ n su. ");
INSERT INTO cko_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Na i susu­fɔm n ase akuruwa bu ŋuŋu nu fa kɔ sɔnɔ bo i tara bu kɛrɛ ni. ");
INSERT INTO cko_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesu siiri bu sunsunni bo bu bita i n dɛɛ ti, na wɔ fa baa kaan be ajina bu afiɛn i bi, ");
INSERT INTO cko_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","na wɔ se bu ka, “Wɔrɔ kɛrɛ bo a deeri ahin baa­kan n ŋusu m dɛɛ ti, a deeri mini wɔ lɛɛ. Bekun, wɔrɔ kɛrɛ gusu bo a nya deeri mini, a deeri m si bo wɔ sunma m wɔ lɛɛ. Dama bo am sunsun ka i ti kaan am kɛrɛ nu ni, yiri ti kpiri tara am kɛrɛ a.” ");
INSERT INTO cko_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Dɔ na Yohane ase i ka, “Ya Mɔ­fɔ, ya ŋuuri ka sɔnɔ be afa u duma sufa fɔn yi ajinim fite minɛm ŋu, ye ya ŋa ya yáki má i, dama i wo má ya nu n dɛɛ ti.” ");
INSERT INTO cko_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Na Yesu ase ka, “Má am se ka am kanda i, dama sɔnɔ kɛrɛ bo i fite má am sin, i mi jina am sin wɔ lɛɛ.” ");
INSERT INTO cko_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Saŋga n ba dodoori bo Nyɛmɛ má Yesu fun kɔ aŋgoro ni, na wɔ bu i tii nu ka i ti ye ni ka i kɔ Yɛrusalem miɛ kpiri n nu. ");
INSERT INTO cko_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Na wɔ sunma sunma­fɔm Samariya ahɛmɛ miɛ be su ka bu kɔ suyo deke kɛrɛ siriya ŋminda i. ");
INSERT INTO cko_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ama, na Samariya­fɔm n akete ka bu de má i, dama ka i susin kɔ Yɛrusalem n dɛɛ ti. ");
INSERT INTO cko_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Yakobo ni Yohane ŋuuri nyini n sɔ ni, na ba se ka, “Ya Mibiɛ, a koro ka ya ma sin fite aŋgoro ba di bu, nzɛn sɛ a?” ");
INSERT INTO cko_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Na Yesu acɛ aniɛ, na wɔ jaraki bu. ");
INSERT INTO cko_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Dɔ na Yesu ni i susu­fɔm n asin akɔ miɛ nyiŋga be su. ");
INSERT INTO cko_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Saŋga bo Yesu ni i susu­fɔm n wo kɔ su ni, na sɔnɔ be aba ase Yesu ka, “Deke kɛrɛ bo a kɔ, m sú u su wɔ.” ");
INSERT INTO cko_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Na Yesu ase i ka, “Ŋaakum la kunmam, na anumam gusu la tiɛɛrim, ama, mini Adamande Wa n yiri, m la má m tii daa­biri.” ");
INSERT INTO cko_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Na wɔ se sɔnɔ nyiŋga be ka, “Su m su.” Ama, na sɔnɔ n ase i ka, “M Mibiɛ, ma m du mɔ kɔ yo m si sutura ka, na m nyá ba su u su.” ");
INSERT INTO cko_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Na Yesu ase i ka, “Yaki bo ba wu ni, na bu se bu beŋgu, wɔrɔ kɔ na a kɔ kan Nyɛmɛ jɔrɛ fa kɔ kabo Nyɛmɛ Fɛmɛ bá niɛ i minɛm su ni.” ");
INSERT INTO cko_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Na sɔnɔ nyiŋga be bekun ase Yesu ka, “M Mibiɛ, m bá su u su, ama, ma m kɔ kaari m dika­fɔm ka, na m bá.” ");
INSERT INTO cko_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Na Yesu ase i ka, “Sɔnɔ kɛrɛ bo i ti ka toora dɔdɔɔri­fɔ na i wo dɔ su, na i kaaki niɛ i sin, i ti má ye ni ka Nyɛmɛ yo i mi fɛmɛ.” ");
INSERT INTO cko_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Nyini sin na Mibiɛ Yesu n ayi i susu­fɔ abura­so ni nnyɔ nyiŋga nbem, na wɔ sunma bu nnyɔ nnyɔ ka bu du mɔ kɔ miɛ miɛm kɛrɛ bo yiri ni i tii ase ka i bá kɔ su ni. ");
INSERT INTO cko_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Na wɔ se bu ka, “Fiesu diire n sunnu, ama, bo bu kɔ i tambu n sunnu má. Nyini ti, am sere Mibiɛ n bo i dɛɛ la fie n ka i sunma juma­yo­fɔm na bu kɔ i tambu. ");
INSERT INTO cko_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ama, am ti fɛn. Am kɔ. M susunma am wɔ lɛɛ, kabo nbɔmbaam kɔ saŋga bedim nu barasu ni. ");
INSERT INTO cko_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Má am se ka am fa ŋwaa, wara kuruku, wara gbagbaa, má am se ka am jina atin nu yo be mmɔɔ ansɛ. ");
INSERT INTO cko_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Awuru kɛrɛ bo am kɔ wuraari nu, am du mɔ se ka, ‘Nyɛmɛ ma am tana­laifiɛ.’ ");
INSERT INTO cko_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Nzɛn tana­laifiɛ­fɔ wo nyini awuru n nu, am ma am tana­laifiɛ n ka i mi n dɔ, ama, nzɛn wɔ ti má sɔ, Nyɛmɛ dé tana­laifiɛ ni i mi n dɔ. ");
INSERT INTO cko_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Awuru bo am kɔ wuraari nu na bu deeri am wɔfɔ, am ka nyini awuru n nu, na am di na am nu deke kɛrɛ bo bu fa ma am, dama i ti ye ni ka juma­yo­fɔ nya i juma ni ŋkatɔ. Má am nati awuru kɛrɛ nu. ");
INSERT INTO cko_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Am kɔ juuri miɛ be su na bu deeri am wɔfɔ, am di deke kɛrɛ bo bu fa ma am. ");
INSERT INTO cko_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Am tuntun tukpaki­fɔm bo bu wo dɔ n na bu nya laifiɛ, na am se bu ka, ‘Saŋga bo Nyɛmɛ Fɛmɛ bá niɛ i minɛm su n adodo am lɛɛ.’ ");
INSERT INTO cko_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ama, nzɛn am kɔ juuri miɛ be su na ba de má am wɔfɔ, am fite kɔ atiŋgbere n su, na am se bu ka, ");
INSERT INTO cko_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Haari am miɛ n tuturi mmɔɔ mata má ya jaa, ya kpɔnkpɔn yi i wɔ, nyini di daani kere ka am woo­wa ti má kpa. Ama, i ti ye ni ka am si ka saŋga bo Nyɛmɛ Fɛmɛ bá niɛ i minɛm su n adodo lɛɛ.’ ");
INSERT INTO cko_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nyini ti, m suse am wɔ lɛɛ, ka, jina cɛɛn, nyini miɛ n nu­fɔm, Nyɛmɛ cín bu sui tara Sodom miɛ kpiri n nu satiɛ­yo­fɔm.” ");
INSERT INTO cko_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Na Yesu akaaki ase ka, “Tɔ, ambɛrɛ Korazin­fɔm, am bá ŋu anyum­boro. Ambɛrɛ Besayida­fɔm gusu, am bá ŋu anyum­boro. Alekutura sam bo m yo maari am ni, má nzɛn m yoori bu Tiro, ni Sidon miɛ kpirim n nu, má minɛm n akaaki bu wo dada kɛrɛ na bu fa pirim bɔtɔ, ni nzuin yo bu yoo­wa n bo i kere ka bu ahore asaaki, bu satiɛ yoo­wa n dɛɛ ti ni. ");
INSERT INTO cko_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ama, ambɛrɛ, Nyɛmɛ bá cin am sui tara Tiro ni Sidon dɛɛ satiɛ­yo­fɔm. ");
INSERT INTO cko_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ambɛrɛ Kapɛnam­fɔm gusu, am sunsun ka Nyɛmɛ bá yɛ am su kɔ aŋgoro wɔ, nzɛn sɛ? Ai. I bá yo am kaan wɔ, na i fá am cɔɔndi kɔ Yiwee­fɔm Woo­biri.” ");
INSERT INTO cko_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Na Yesu ase i susu­fɔm ka, “Sɔnɔ kɛrɛ bo i de am nɔaniɛ, i mi de m dɛɛ nɔaniɛ wɔ lɛɛ, na sɔnɔ kɛrɛ bo i kete am nɔaniɛ, i mi kete m dɛɛ nɔaniɛ wɔ lɛɛ, na sɔnɔ kɛrɛ bo i kete m dɛɛ nɔaniɛ, i mi kete yiri n bo i sunmaari m wɔ lɛɛ.” I jɔjɔ wieeri, na ba kɔ. ");
INSERT INTO cko_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Saŋga bo i susu­fɔ abura­so ni nnyɔm ni kpieeri bu nyi baari Yesu dɔ ni, na bu ahore ajɔ agaya, na ba se i ka, “Ya Mibiɛ, haari ajinim mmɔɔ de ya nɔaniɛ wɔ, nzɛn ya nya atiɛn bu ŋu u dɛɛ duma n nu.” ");
INSERT INTO cko_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Na Yesu ase bu ka, “M ŋuuri Sitana ka wɔ fite aŋgoro atɔ, kabo nzue kpɛsɛ na i ti barasu n wɔ.” ");
INSERT INTO cko_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Na Yesu ase ka, “Am ti fɛn. Ma ma am yiko adena am tiɛntiɛn woom ni bundaanim ŋu, na am kunma yiri kpɔ­fɔ n faŋga kɛrɛ na pui yó má am. ");
INSERT INTO cko_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Haari ni nyini kɛrɛ ni, má am ma am ahore jɔ ka ajinim de am nɔaniɛ ŋgumi n dɛɛ ti, ama, am ma am ahore jɔ ka ba kɛrɛ am duma ase Nyɛmɛ dika.” ");
INSERT INTO cko_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Nyini saŋga n na Awiɛwiɛ Casi n ama Yesu ahorejɔ akɔ sin su, na wɔ sere Nyɛmɛ ase ka, “M Si Nyɛmɛ, wɔrɔ ti aŋgoro ni asiɛŋgu kɛrɛ Mibiɛ a. M da u asi ka a fa nyini dekem bo alecira­fɔm ni si­fɔm si má i ni, ayi akere bo bu ti ka nbaatam ni. M Si, i ti nahɔrɛ wɔ, kabo a koroori ka i yo lɛɛ.” ");
INSERT INTO cko_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Yesu sereeri Nyɛmɛ n wieeri ni, na wɔ se ka, “M Si afa deke kɛrɛ awura m saa nu. Be si má Nyɛmɛ Wa ni, má ka i Si Nyɛmɛ ni si i a, na be gusu si má i Si ni, má ka Baa ni si i a, ni minɛm bo Baa n koro ka i yi i kere bu ni, bɛrɛ si i a.” ");
INSERT INTO cko_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Dɔ na Yesu acɛ aniɛ i susu­fɔm ni, na wɔ jɔjɔ bɛrɛ ŋgumi dɔ, i ŋa, “Ambɛrɛ la tere­fiɛ ka am aŋu dekem bo am ŋu bu ni. ");
INSERT INTO cko_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","M suse am wɔ lɛɛ, ka, Nyɛmɛ nɔaniɛ kan­fɔm ni nfɛmɛm beberebe koroori ka bu ŋu deke n bo am ŋu i ni, ama, ba ŋu má i, na ba koro ka bu ti deke n bo am ti i ni, ama, ba ti má i.” ");
INSERT INTO cko_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Na Nyɛmɛ nɔaniɛ kere­fɔ be aba Yesu dɔ ka i ba sɔ i ŋgɛɛ. Na wɔ bisa Yesu ka, “Ya Kere­fɔ, ye m yo sɛ wɔ, ye m nyá ŋgɔɔ n bo i la má awieeri n a?” ");
INSERT INTO cko_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Na Yesu abɔ i nu ka, “Ba kɛrɛ i sɛ wɔ, Nyɛmɛ Jɔrɛ Kadasi n nu a? A ti i bu sɛ wɔ?” ");
INSERT INTO cko_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Na sɔnɔ n abɔ Yesu nu ka, “Ba kɛrɛ ka, ‘Koro Micɛra u Nyɛmɛ ni, ni u ahore­mbaa kun, ni u awiɛwiɛ, ni u faŋga, ni u sunsunni kɛrɛ, na a koro u beŋgu kabo a koro u ŋu ni.’” ");
INSERT INTO cko_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Na Yesu ase i ka, “A kan nahɔrɛ wɔ, yo sɔ na a nyá ŋgɔɔ.” ");
INSERT INTO cko_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ama, na Nyɛmɛ nɔaniɛ kere­fɔ n akoro ka i yo i ŋu ka i ti sɔnɔ bo i yo sa bo i kɔ atin su Nyɛmɛ dɔ ɔ, nyini ti, na wɔ bisa Yesu ka, “M beŋgu la ŋma a?” ");
INSERT INTO cko_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Na Yesu abɔ i nu ka, “Sɔnɔ be yo woori bɛrɛ a, na wɔ yasu Yɛrusalem ka i kɔ miɛ kpiri be su, bu fere dɔ ka Yeriko, na atin bujaanu­fɔm akɔ atara i ade i neŋge kɛrɛ, na ba bo i akɔ ayaki i ŋgɔɔ n kaan sɔ ɔ. ");
INSERT INTO cko_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","I ba yoori ka Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ kpiɛn be su nyini atin n su, ama, saŋga bo i kɔ ŋuuri sɔnɔ n bo atin bujaanu­fɔm abo i ni, na wɔ san asin ayaki i. ");
INSERT INTO cko_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","I tiiri sɔ bekun, na Levi busu nu­fɔ be susin bɛrɛ, na wɔ ŋu i, na i gusu asan asin. ");
INSERT INTO cko_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ama, na Samariya­fɔ be gusu ba bita nyini atin ni, na wɔ ba aŋu sɔnɔ ni, i ŋuuri i sɔ ni, na aŋunfɔ ati i. ");
INSERT INTO cko_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Na wɔ kɔ sɔnɔ n bi, na wɔ fa ŋguin ni nzan afa aŋmisi kambuem ni, na wɔ cici i, na wɔ fa sɔnɔ n na wɔ ma wɔ tana i kaako su, na wɔ fa i akɔ wɔfɔm dee­biri, na wɔ kɔ aniɛ i dika. ");
INSERT INTO cko_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Alecin na wɔ yi ŋwaa be ama sɔnɔ bo i niɛ awuru n su ni. Na wɔ se i ka, ‘De na a niɛ i dika ma m, na m ba kpieeri m nyi baari, m tɔ́ deke kɛrɛ bo a saaki i afa aniɛ i dika ni.’ ");
INSERT INTO cko_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Tɔ, u sunsunni nu, nyini minɛ nsanm n nu, bɔnɔ kere ka i ti sɔnɔ n beŋgu a?” ");
INSERT INTO cko_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Na Nyɛmɛ nɔaniɛ kere­fɔ n abɔ i nu ka, “Sɔnɔ n bo i siiri i aŋunfɔ ni.” Na Yesu ase i ka, “Kɔ na a kɔ yo sɔ.” ");
INSERT INTO cko_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Saŋga bo Yesu ni i susu­fɔm n wo kɔ su ni, na ba kɔ aju miɛ be su, bara be woori dɔ, bu fere i ka Marata, na wɔ de Yesu wɔfɔ i dika. ");
INSERT INTO cko_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marata la i niɛma be, bu fere i ka Mariya, na wɔ tana Yesu bi, na i suti kabo Yesu kere barasu ni. ");
INSERT INTO cko_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ama, na wɔ yo Marata ahoresaaki kabo yiri ŋgumi wo juma yo su ni, nyini ti, na wɔ ba ase Yesu ka, “M Mibiɛ, u cɛcɛ wo má nu ka m niɛma n ayaki juma n kɛrɛ aji mini ŋgumi saa su, nzɛn sɛ? Se i ka i ba buka m.” ");
INSERT INTO cko_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Na Mibiɛ n abɔ i nu ka, “M danfo Marata, a fa juma beberebe ata u ŋu nyi, ye a suwaraki a, ");
INSERT INTO cko_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ama, deke kun n kpein be akpiɛ u su a. Mariya yiri, deke bo i ti kpa tara i kɛrɛ ye wɔ yi i n a, na be wo má bɛrɛ bo i koro de i dɔ.” ");
INSERT INTO cko_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Cɛɛn n be sɔ ɔ, na Yesu wo nyɛmɛsere su awɔrɛ be nu. I ba sere wieeri ni, na i susu­fɔm ni kun ase i ka, “Ya Mibiɛ, kere ya nyɛmɛsere atin, kabo Yohane kereeri i dɛɛ susu­fɔm ni.” ");
INSERT INTO cko_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Na Yesu ase bu ka, “Saŋga bo am ba susere Nyɛmɛ, am se ka o, ‘Ya Si Nyɛmɛ, ma minɛm bu u duma casi ni. Ma u fɛmɛya n bra. ");
INSERT INTO cko_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ma ya nɔɔ nu diire cɛɛn n kɛrɛ cɛɛn. ");
INSERT INTO cko_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Fa ya satiɛ ce ya, dama yɛrɛ gusu fa ce bo bu do ya ŋgasi n wɔ. Má a ma deke be yo ya na ya wura satiɛ nu.’” ");
INSERT INTO cko_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Na Yesu ase ka, “Ma m fa i ka, nzɛn am nu kun kɔɔri i danfo dika kɔŋguɛ jinanjin, na i kɔ se i ka, ‘M danfo, fiɛ m kpɔnɔ nsan. ");
INSERT INTO cko_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","M danfo atin natiiri­fɔ be aba m dika jina n nu bɛrɛ lɛɛ, m gusu la má diire bo m fá ma i.’ ");
INSERT INTO cko_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Na yiri n bo i wo sɔrɔ n ase ka, ‘Má a miɛ m. Ma tu anɔ awie, na m nbaam da a. M koro yasu má na m má u pui.’ ");
INSERT INTO cko_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Tɔ, m suse am wɔ lɛɛ, ka, má ka am ti danfoya n dɛɛ ti ye i yásu na i ma u kpɔnɔ n a, ama, i bá yasu na i ma u deke kɛrɛ bo a koro, dama ka a fie ni sere n dɛɛ ti. ");
INSERT INTO cko_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Nyini ti, m suse am wɔ lɛɛ, ka, am sere deke bo am koro i Nyɛmɛ dɔ, na i má am. Am niɛniɛ deke bo am koro i dɔ, na am ŋú i. Am bobo anɔ ni, na i téke i ma am. ");
INSERT INTO cko_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Dama sɔnɔ kɛrɛ bo i sere deke be Nyɛmɛ dɔ, i má i, na sɔnɔ kɛrɛ bo i niɛniɛ deke be, i ŋú i wɔ, na sɔnɔ kɛrɛ bo i bobo anɔ ni, i téke i ma i. ");
INSERT INTO cko_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ambɛrɛ bo am ti nbaasim ni, ŋma ye i wa sere i jombaa ye i mi kéte na i fá woo ma i wa n a? Ai, be yo má sɔ. ");
INSERT INTO cko_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Wara, ambɛrɛ nu ŋma ye i wa sere i karafɔ ye i kéte na i fá bundaani ma i wa n a? Ai, be yo má sɔ. ");
INSERT INTO cko_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Tɔ, ambɛrɛ, haari ni bo am ti satiɛ­yo­fɔm ni, am si aceeri kpam bo am fa ce am nbaam, nzu ti ye nzɛn am sereeri am Si Nyɛmɛ bo i wo aŋgoro ni, i koro ma má am Awiɛwiɛ Casi n a?” ");
INSERT INTO cko_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Saŋga be na Yesu afɔn ayi ajini afite sɔnɔ be ŋu, wɔ yo i bobo. Ajini n fite yakiiri sɔnɔ n sɔ ni, na wɔ koro ajɔjɔ. Na jama n ayo alekutura. ");
INSERT INTO cko_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ama, na minɛ nbem ase ka, “Bɛlazɛbuli bo i ti ajinim kɛrɛ dɛɛ fɛmɛ n na bu kaaki fere i ka Sitana ni, yiri ma ahin sɔnɔ n yiko ye i koro fɔn yi ajinim a.” ");
INSERT INTO cko_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Na nbem gusu akoro ka bu sɔ i ŋgɛɛ. Nyini ti, na ba se i ka i yo alekutura sa be bo i kere ka i yiko n fite Nyɛmɛ dɔ ɔ. ");
INSERT INTO cko_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ama, Yesu siiri bu sunsunni n sɔ ni, na wɔ se bu ka, “Fɛmɛya kɛrɛ bo i nya kpakpaakiiri nu wieeri, nyini fɛmɛya ni ká ŋgbɛɛn wɔ. Awuru gusu kɛrɛ bo i kpakpaakiiri nu wieeri, nyini awuru ni sándi wɔ. ");
INSERT INTO cko_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Na nzɛn Sitana dɛɛ fɛmɛya n nya kpaakiiri nu wieeri, i kóro jina a? Ai, i kóro jina má. Deke bo i ti na m se sɔ n la ka, am ŋa Bɛlazɛbuli ma m yiko ye m koro fa fɔn yi ajinim a. ");
INSERT INTO cko_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Tɔ, ye nzɛn am ŋa Bɛlazɛbuli maari m yiko, ye m fa fɔn yi ajinim a, ye ŋma maari am dɛɛ minɛm ni yiko ye bu bita fɔn yi bu n a? Nyini ti, kabo am minɛm yoori ni, nyini kere ka am la má nahɔrɛ. ");
INSERT INTO cko_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ama, Nyɛmɛ dɛɛ yiko nu ye mini fɔn yi ajinim a. Nyini n kere ka, Nyɛmɛ wo am nu suniɛ i minɛm su lɛɛ. ");
INSERT INTO cko_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Nzɛn sɔnɔ faŋga­fɔ nya faari i biɛsɔya neŋge kɛrɛ jina ŋmindaari i dika, pui koro yo má i awuru n nu neŋge be. ");
INSERT INTO cko_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ama, nzɛn sɔnɔ nyiŋga nya taraari i faŋga, i koro tu ŋgoni ni yiri na i kunma i faŋga, na i de i biɛsɔya neŋge n bo i daafi i ŋu ni, na i fin i neŋge kɛrɛ kɔ na i ni i beŋgum kɔ kpaaki nu. ");
INSERT INTO cko_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Sɔnɔ kɛrɛ bo i jina má m sin, i mi ti m kpɔ­fɔ ɔ. Na sɔnɔ kɛrɛ gusu bo i buka má m na ya tiɛn minɛm nɔɔ, i mi sandi minɛm wɔ. ");
INSERT INTO cko_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Nzɛn ajini nya fite yakiiri sɔnɔ, i kɔ jeŋgbe bara yɛ boro kpantain nu wɔ, deke bo nzue wo má, na i kɔ niɛniɛ woo­biri bo i tana yi i ŋumi. Nzɛn wɔ nya má woo­biri, nyini saŋga, a ti ka i ŋa, ‘Ma m kpie m nyi kɔ m woo­biri dawa ni.’ ");
INSERT INTO cko_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Na i kaaki kɔ, i kɔ ŋu ka ba kpara dika n nyunyumi, asɛsɛ deke kɛrɛ su. ");
INSERT INTO cko_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Na i nyá kɔ fa ajinim nso, bo bu ti tiɛ tara yiri ni i tii, na bu kɛrɛ bá wura woo­biri dawa n nu. Nyini saŋga, a ŋu ka sɔnɔ n woo­wa ayo tiɛ atara kabo i yo ti dawa ni.” ");
INSERT INTO cko_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Saŋga bo Yesu seeri sɔ wieeri ni, bara be wo jama n nu, na wɔ se Yesu ka, “Tere­fiɛ wo bara n bo i wuuri u na i maari u nyufini n dɔ.” ");
INSERT INTO cko_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ama, na Yesu ase i ka, “Tere­fiɛ wo minɛm bo bu ti Nyɛmɛ nɔaniɛ n na bu de i ni dɔ a.” ");
INSERT INTO cko_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Saŋga bo minɛm sutiɛn bu nɔɔ bara yɛ Yesu sɔ ni, na wɔ se bu ka, “Ambɛrɛ nyuma­fɔm ti satiɛ­yo­fɔm wɔ. Am koro ka m yo alekutura sa na am ŋu i wɔ, ama, m yó má i, má ka alekutura sa n bo Nyɛmɛ yo yoori i maari i nɔaniɛ kan­fɔ Jona ni ŋgumi. ");
INSERT INTO cko_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","I ti sɔ lɛɛ, kabo sa n bo i yo tuuri Jona n kereeri Ninɛva­fɔm ka Nyɛmɛ sunmaari i ni, sɔ ye sa n bo i bá tu mini Adamande Wa n gusu kére ambɛrɛ nyuma­fɔm ka Nyɛmɛ asunma m a. ");
INSERT INTO cko_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Fɛmɛ bara be yo fiteeri haari i bɔsu Seba wɔ, na i ba ti Fɛmɛ Solomon dɛɛ ŋgɔnlɛ jɔjɔɔ­wa nɔaniɛ ni. Jina cɛɛn, yiri bá yasu jina na i járaki ambɛrɛ nyuma­fɔm nahɔrɛ su, dama kisa, m suse am wɔ ka, mini tara Fɛmɛ Solomon, ama, am ade má m nɔaniɛ ni. ");
INSERT INTO cko_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Jona yo kaanri Nyɛmɛ jɔrɛ kereeri Ninɛva­fɔm na ba kaaki bu wo. Jina cɛɛn, bɛrɛ bá yasu jina na bu járaki ambɛrɛ nyuma­fɔm, dama kisa, m suse am wɔ ka, mini tara Jona, ama, am akete ka am kaaki má am wo.” ");
INSERT INTO cko_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Na Yesu akaaki ase ka, “Sɔnɔ koro so má fitana su na i fa se fiɛɛ­wa nu, wara i fa gaŋga butu su. Ama, i fa taka deke su aŋgoro wɔ, adena minɛm bo bu ba wura awuru n nu n koro ŋu asi. ");
INSERT INTO cko_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ya nyu­mbaa ni ti ka fitana ma ya ŋuniɛ­mbaa n a. Nzɛn u nyu­mbaa nya ti kpa, u ŋuniɛ­mbaa n kɛrɛ ta wein n wɔ lɛɛ. Ama, nzɛn i nya ti má kpa, u ŋuniɛ­mbaa n kɛrɛ wo awosin nu wɔ lɛɛ. ");
INSERT INTO cko_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Nyini ti, si u ŋu sa na má a se ka wein wo u dɔ, ama, i ti awosin wɔ. ");
INSERT INTO cko_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Nzɛn u ŋuniɛ­mbaa n kɛrɛ woori wein nu, na awosin be awo má nu, i tá a papasi, kabo fitana sin ta wura u ni.” ");
INSERT INTO cko_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Saŋga bo Yesu jɔjɔ wieeri sɔ ni, na Farasi­fɔ be asere i ka i bra na bu di diire i dika, na Yesu akɔ awura ka i di diire ni. ");
INSERT INTO cko_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Na Farasi­fɔ n abirisi kabo Yesu aŋmisi má i ŋu ka, ye i sudi diire ni. ");
INSERT INTO cko_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Na Mibiɛ n ase i ka, “Ambɛrɛ Farasi­fɔm, am ŋmisi am kɔpu ni am taalɛ sin wɔ, ama, am kunnu ayi ni anyii sa­yoo­wam, ni sunsunni tiɛm wɔ. ");
INSERT INTO cko_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ambɛrɛ sinnzinm ni, sɔnɔ kɛrɛ si ka Nyɛmɛ yoori deke kɛrɛ kunnu ni i sin a. ");
INSERT INTO cko_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Má nzɛn am fa deke bo i wo am kɔpu ni am taalɛ kunnu ma yaari­fɔm, má deke kɛrɛ bo am yo i, má i yo casi ma am wɔ Nyɛmɛ dɔ. ");
INSERT INTO cko_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ambɛrɛ Farasi­fɔm ni, am bá ŋu anyum­boro, dama am yi am jakam ma Nyɛmɛ wɔ, haari ni am maakunm, ni ŋgɛtɛm, ni nvan­nvanm kɛrɛ, ama, am yo má nahɔrɛ sam, na am kaaki koro má Nyɛmɛ. Wɔ yo daka ka am yo nyini sam saŋga kɛrɛ, na am fa jaka yii­wam buka su. ");
INSERT INTO cko_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ambɛrɛ Farasi­fɔm ni, am bá ŋu anyum­boro. Am koro ka am tana kpirikoro tanaa­birim wɔ, am tiɛntiɛn­bunɔɔ sɔɔm n nu, na am koro ka minɛm yo am ansɛ gɔɔsu wɔ, na bu ma am jirima. ");
INSERT INTO cko_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Am bá ŋu anyum­boro. Am ti ka faŋ­kunmam bo bu la má nyaari see­wa be n wɔ, na minɛm nati su na bu si má ka faŋ­kunma lɛɛ.” ");
INSERT INTO cko_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Na Nyɛmɛ nɔaniɛ kere­fɔm n kun ase Yesu ka, “Ya Kere­fɔ, nzɛn a seeri sɔ, a kpiɛ nzukɔ asaŋga ya kɛrɛ mmɔɔ lɛɛ.” ");
INSERT INTO cko_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Na Yesu ase i ka, “Ambɛrɛ Nyɛmɛ nɔaniɛ kere­fɔm ni, ambɛrɛ mmɔɔ bá ŋu anyum­boro. Am cici sɔɔri nɔnɔɔri sɔ minɛm wɔ, ama, ambɛrɛ ni am tii soro má su ka am fa am saa kan i. ");
INSERT INTO cko_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ambɛrɛ bá ŋu anyum­boro. Am yo faŋ­kunmam dɔŋgu fa ma Nyɛmɛ nɔaniɛ kan­fɔm wɔ, bɛrɛ bo am nam yo kuunri bu ni. ");
INSERT INTO cko_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Nyini kere ka ambɛrɛ ni am tii saa woori sa n bo am nam yo yoori i n nu lɛɛ. Bɛrɛ kuunri Nyɛmɛ nɔaniɛ kan­fɔm n a, na ambɛrɛ ata bu faŋ­kunmam. ");
INSERT INTO cko_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Nyini ti, ye Nyɛmɛ Alecira­fɔ n seeri ka, ‘M súnma m nɔaniɛ kan­fɔm, ni m jaramasam bu dɔ, na bu kún nbem, na bu kére nbem wuwuruwa.’ ");
INSERT INTO cko_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Nyini ti, Nyɛmɛ cín ambɛrɛ nyuma­fɔm sui fa kɔ kabo am nam yo kuunri Nyɛmɛ nɔaniɛ kan­fɔm, fiteeri durunya n bumboori fa ba ju haari ni kisa ni. ");
INSERT INTO cko_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Bu yo yoori sɔ ɔ, fite saŋga n bo bu kuunri sɔnɔ be bo bu fere i ka Abɛli n fa ba juuri saŋga n bo bu kuunri sɔnɔ be bo bu fere i ka Zakariya ni. Yiri ye bu kuunri i Nyɛmɛ Seree­biri Awuru n nu, Casi Kɛrɛ Casi Sɔɔ n ni Mikun yoo­wa yoo­biri n afiɛn n a. Nahɔrɛ ye m suse am n a, nyini sam kɛrɛ dɛɛ ti ye Nyɛmɛ bá cin ambɛrɛ nyuma­fɔm sui n a. ");
INSERT INTO cko_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ambɛrɛ Nyɛmɛ nɔaniɛ kere­fɔm ni, am bá ŋu anyum­boro. Am akere má minɛm Nyɛmɛ atin, kabo i ti ye ni ka am kere bu ni, na ambɛrɛ ni am tii akete ka am su má i atin n su, ye am akanda bo bu koro ka bu su i su ni.” ");
INSERT INTO cko_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Saŋga bo Yesu yasuuri nyini dika n nu ni, na Nyɛmɛ nɔaniɛ kere­fɔm, ni Farasi­fɔm n afa i kpɔ agaya, na ba bisa i bisaa­wam beberebe, ");
INSERT INTO cko_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","na ba boro bu nyi na bu sɔ i ŋgɛɛ, adena i jɔjɔ wura Nyɛmɛ ŋgasi nu. ");
INSERT INTO cko_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Saŋga n bo nyini n kɛrɛ sukɔ su ni, na jama beberebe aba atiɛn bu nɔɔ haari bu kɔ sutiɛntiɛn bu beŋgu ŋu. Na Yesu abo i bu ka i jɔjɔ, na wɔ du mɔ ase i susu­fɔm n ka, “Am si am ŋu sa ni Farasi­fɔm dɛɛ kpɔnɔ ayiri n bo bu fa gɔ kpɔnɔ nu na i yasu ni. M suni bu dɛɛ burukɔɔ­nu sa­yoo­wam wɔ. ");
INSERT INTO cko_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Deke be wo má fiɛɛ­wa nu bo bu bá ŋu má i, deke be gusu wo má asiri nu bo bu bá si má i. ");
INSERT INTO cko_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Nyini ti, deke kɛrɛ bo am jɔjɔɔri i kɔŋguɛ, bu bá jɔjɔ i wiɛsu wɔ. Na deke kɛrɛ bo am tuuri i asuturi sɔrɔ, bu bá bo i ndoori wɔ, na sɔnɔ kɛrɛ tí i.” ");
INSERT INTO cko_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Na Yesu akaaki ase ka, “M danfom, m suse am wɔ lɛɛ, ka, má am soro minɛm bo bu koro kun aŋuniɛ­mbaa ni, na nyini sin, bu koro yo má pui kun ni. ");
INSERT INTO cko_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ama, m kére am sɔnɔ bo i ti ye ni ka am soro i. Am soro Nyɛmɛ, yiri koro kun aŋuniɛ­mbaa n a, na i kaaki la yiko bo i koro fa i ji cɛɛma sin nu. M suse am wɔ lɛɛ, ka, yiri ti sɔnɔ bo am soro i a. ");
INSERT INTO cko_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Am si ka njɔrɛm nnu ŋwaa ti kaan sɔ ɔ, má sɔ? Ama, bu kun n kpein mmɔɔ wo má bɛrɛ bo Nyɛmɛ niɛ má i dika. ");
INSERT INTO cko_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Haari am tii­ŋmiɛ mmɔɔ bo i wo am tii su ni, Nyɛmɛ si i kɛrɛ nɔ. Nyini ti, má am soro sɛrɛ. Am la anyunuyi Nyɛmɛ dɔ tara njɔrɛm beberebe.” ");
INSERT INTO cko_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Na Yesu akaaki ase bu ka, “M suse am wɔ lɛɛ, ka, sɔnɔ kɛrɛ bo i kan kereeri minɛm ka i ti m susu­fɔ, mini Adamande Wa n gusu bá kan kere Nyɛmɛ mɛrɛkɛm n ka i mi ti m dɛɛ wɔ. ");
INSERT INTO cko_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ama, sɔnɔ kɛrɛ gusu bo i keteeri minɛm nyunu ka i ti má m susu­fɔ, mini Adamande Wa n gusu bá kete Nyɛmɛ mɛrɛkɛm nyunu ka i mi ti má m dɛɛ. ");
INSERT INTO cko_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Sɔnɔ kɛrɛ bo i jɔjɔ wuraari mini Adamande Wa ni ŋgasi nu, Nyɛmɛ fá i mi ŋgasi ce i, ama, sɔnɔ kɛrɛ bo i jɔjɔ wuraari Awiɛwiɛ Casi ni ŋgasi nu, Nyɛmɛ fá má i mi ŋgasi ce má i. ");
INSERT INTO cko_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Saŋga bo bu ba faari am baari bu tiɛntiɛn­bunɔɔ sɔɔm nu, wara nfɛmɛm ni nfaŋga­fɔm nyunu ka bu di am jɔrɛ, má am ma am ahore saaki fa kɔ kabo am jɔjɔ barasu. ");
INSERT INTO cko_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Dama nyini saŋga n ba juuri, Awiɛwiɛ Casi ni kére am nɔaniɛ kɛrɛ bo wɔ yo daka ka am jɔjɔ i a.” ");
INSERT INTO cko_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Sɔnɔ be woori jama n nu, na wɔ se Yesu ka, “M Kere­fɔ, se m gɔrɔ ka i kpaaki aja bo ya si ayaki i ama ya n nu, na i fa m dɛɛ ma m.” ");
INSERT INTO cko_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Na Yesu ase i ka, “Wɔrɔ, ŋma ayi m, ka m di am jɔrɛ na m kpaaki am aja nu ma am a?” ");
INSERT INTO cko_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Na Yesu ase jama n kɛrɛ ka, “Am niɛ am tii su dɔŋgu na am si am ŋu sa fa kɔ anyii barasu kɛrɛ sa, dama sɔnɔmbiri neŋge ti má i ŋgɔɔ, haari i mi n koro i la i ka sɛ.” ");
INSERT INTO cko_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Dɔ na Yesu abo bu ahin miɛɛnu ni, i ŋa, “Sɔnɔ neŋge­fɔ be yo woori bɛrɛ a, na wɔ dɔ i fie, na wɔ nya diire beberebe. ");
INSERT INTO cko_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Na wɔ sunsun i tii nu na wɔ se ka, ‘M la má deke bo m fa ahin diire n kɛrɛ se. Ye m yó sɛ wɔ?’ ");
INSERT INTO cko_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Na wɔ se ka, ‘Kabo m yó yaa, m sún m bondom kɛrɛ ji wɔ, na m tá ŋgbiŋgbirim, na m fá m diire n ni neŋge kɛrɛ bo m la bu n wura nu. ");
INSERT INTO cko_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Na m nyá se ka ma di tere­fiɛ, puitiri­pui kpíɛ má m su kun, m tána a, ahin afɔ nyɛ nyɛ n kɛrɛ, na m dí na m nú na m ahore jɔ́.’ ");
INSERT INTO cko_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ama, na Nyɛmɛ ase i ka, ‘Wɔrɔ sinnzin ŋgbɛɛn ni. Ahin kɔŋguɛ n nu bɛrɛ, m yí u ŋgɔɔ n fite u dɔ. Na m níɛ ka nyini neŋge n kɛrɛ bo a tiɛn i nɔɔ ni ká ŋma dɛɛ wɔ?’” ");
INSERT INTO cko_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Na Yesu akaaki ase bekun ka, “I ti sɔ ɔ lɛɛ, fa kɔ minɛm bo bu kpini neŋge beberebe fa se durunya n nu fɛn ni, ama, Nyɛmɛ dɔ, bu la má pui.” ");
INSERT INTO cko_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Na Yesu ase i susu­fɔm n ka, “Nyini ti, m suse am wɔ lɛɛ, ka, má am tana sukoko fa kɔ am ŋgɔɔ su, kabo am dí, na má am kaaki sukoko fa kɔ am ŋuniɛ su, kabo am nyá suturam bo am fá wura na am kára. ");
INSERT INTO cko_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Dama ŋgɔɔ tara diire, na aŋuniɛ­mbaa n gusu tara suturam. ");
INSERT INTO cko_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Am niɛ anumam, haari ni bo bu dɔ má ni, na bu kaaki kpiɛ má ni, bu la má bondo gusu, bo bu fa diire wura nu, se Nyɛmɛ ma bu diire ye bu di a. Ambɛrɛ la anyunuyi tara anumam e. ");
INSERT INTO cko_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Am nu, ŋma tana koko fa kɔ i koroo­wam su ye i mi koro buka i ŋgɔɔ tintiin su haari kaan sɔ a? Ai, be wo má bɛrɛ. ");
INSERT INTO cko_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Nzɛn am koro yo má nyini deke n kaan n be sɔ, nzu ti ye dekem bo bu kaari n kɛrɛ miɛ am a? ");
INSERT INTO cko_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Am niɛ kabo wuram bo pum barasu barasu a. Bu yo má juma be, bu kaaki tu má gise. Ama, m suse am wɔ lɛɛ, ka, haari Fɛmɛ Solomon ni i neŋge n kɛrɛ bo i yo la i ni, wɔ la má sutura bo i yo nyumi juuri nyini wura pum ni be. ");
INSERT INTO cko_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Nzɛn wuram bo bu wo bɛrɛ nyuma, na ahunma a ŋú ka ba kpiɛ bu na bu yara bu, ye Nyɛmɛ niɛ bu dika, nzu ti ye i níɛ má ambɛrɛ bo am tara wuram co n a? Ambɛrɛ, am la má yarada fieo. ");
INSERT INTO cko_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Nyini ti, saŋga kɛrɛ, má am ma am sunsunni wo deke bo am dí, ni deke bo am nú su. Má am tana koko fieo. ");
INSERT INTO cko_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Dama durunya n nu­fɔm bo bu su má Nyɛmɛ ni, bɛrɛ sunsun sɔ ɔ saŋga kɛrɛ. Am Si Nyɛmɛ si ka am koro nyini dekem ni. ");
INSERT INTO cko_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Má am yo sɔ, ama, am kpini Nyɛmɛ fɛmɛya n busu ka, na i nyá ba fa nyini dekem n buka am su.” ");
INSERT INTO cko_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Na Yesu akaaki ase ka, “Má am soro sɛrɛ, haari ni bo am ti ka nbɔɛm bo bu sunnu má ni, dama am Si Nyɛmɛ ayi am ka am ni yiri sáŋga di i fɛmɛya n a. ");
INSERT INTO cko_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Am tɔ am deke bo am la i, na am fa ŋwaa n ma yaari­fɔm. Am kpini ajɛkɛ see­biri bo i saaki má n busu. Am fa ajɛkɛ bo i kpiɛ má su n fa se Nyɛmɛ dika n nu, dɔ ye awiefɔ koro wura wɔ má i a, na watarawam gusu koro muka má i. ");
INSERT INTO cko_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Dama deke bo am ajɛkɛ wo ni, am ahore­mbaa kɛrɛ gusu wó dɔ ɔ.” ");
INSERT INTO cko_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Na Yesu ase ka, “Am kpa am ŋu wɔ, na am so am fitana suŋminda. ");
INSERT INTO cko_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Am yo sɔ ɔ, ka minɛm bo bu tana ŋminda bu mibiɛ bo wɔ kɔ konyaya, na i bá n wɔ, na saŋga bo i ba boboori anɔ n kpeŋga ni, bu kába teke i wɔ na i wúra. ");
INSERT INTO cko_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Tere­fiɛ wo nyini akɔɔm n dɔ, nzɛn bu mibiɛ n ba ŋu ka bu toko tana ŋminda i. Nahɔrɛ ye m suse am n a, i má bɛrɛ tana a, na yiri ni i tii fá diire ba ma bu na bu di. ");
INSERT INTO cko_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Nzɛn haari i kpieeri i nyi ba juuri kɔŋguɛ jinanjin, wara akɔnyuma bo saŋga, na i ba ŋu ka bu toko tana ŋminda i, tere­fiɛ wo bu dɔ. ");
INSERT INTO cko_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Am si tenle ka nzɛn má awuru­fɔ­biɛ n si saŋga bo awiefɔ ni bá i dika na i ba wɔ i, má i tana ŋminda a, na awiefɔ n koro ba wura má. ");
INSERT INTO cko_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ambɛrɛ gusu kpa am ŋu saŋga kɛrɛ, dama mini Adamande Wa ni bá saŋga bo am sunsun má ka m bá n wɔ.” ");
INSERT INTO cko_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","I jɔjɔɔri sɔ n na Petoro abisa i ka, “Ya Mibiɛ, a bo ahin miɛɛnu n ni yɛrɛ wɔ, nzɛn a ni sɔnɔ kɛrɛ wɔ?” ");
INSERT INTO cko_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Na Yesu abisa i ka, “Amusui­su­fɔ kpiɛn n bo i la dabuŋu na i kaaki la alecira n la ŋma a? Yiri la bo i mibiɛ n afa amusui­su­fɔ nyiŋgam awura i saa nu ka i kpaaki diire nu ma bu, saŋga bo i ti ye ni ka i ma bu ni. ");
INSERT INTO cko_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Nzɛn i mibiɛ n ba ŋuuri ka i suyo juma n kabo i seeri i ka i yo i ni, tere­fiɛ wo nyini amusui­su­fɔ n dɔ. ");
INSERT INTO cko_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nahɔrɛ ye m suse am n a, nyini amusui­su­fɔ n mibiɛ ni fá i aja kɛrɛ wura i saa nu wɔ, na i níɛ i dika. ");
INSERT INTO cko_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ama, nzɛn i ti amusui­su­fɔ tiɛ­fɔ, i súnsun ka i mibiɛ ni kpíe má i nyi ba má nde. A ŋu ka i subo amusui­su­fɔ nyiŋgam ni, bu nbiɛsɔm ni nbaram kɛrɛ, na i sudi na i sunu nzan bo, ");
INSERT INTO cko_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","dɔ na i mibiɛ n bá kpie i nyi ba cɛɛn bo i sunsun má ka i bá, na i kaaki si má ba n saŋga ni. Nyini saŋga n na i mibiɛ n cín i sui agaya, na i fá i bo minɛm bo bu yo má i yarada n su. ");
INSERT INTO cko_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Na nzɛn amusui­su­fɔ n si deke bo i mibiɛ n koro ka i yo i, na wɔ yo má siriya na i yo deke bo i mibiɛ n koro ka i yo ni, i bó i wɔ nyunyumi. ");
INSERT INTO cko_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ama, nzɛn amusui­su­fɔ bo i si má deke bo i mibiɛ n koro ka i yo i, na i yoori deke be bo i ti ye ni ka i cin i sui, i dɛɛ sui­cin n ti kaan sɔ ɔ. Sɔnɔ kɛrɛ bo bu ce i aceeri beberebe, i ti ye ni ka i mi fa yo deke bo wɔ yo daka ka i yo i, na sɔnɔ kɛrɛ bo Nyɛmɛ ce i aceeri beberebe agaya, i ti ye ni ka i mi su i kɔ tara sɔ.” ");
INSERT INTO cko_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Na Yesu akaaki ase bu ka, “Ma fa Nyɛmɛ jɔrɛ n aba ka i yara durunya n nu­fɔm ka sin dɛɛ su wɔ. Má nyini sin n jeeri kisa, má m koro. ");
INSERT INTO cko_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ama, m la wahara be bo i ti ye ni ka m di i, má ka ma di i awie, m ahore dá má. ");
INSERT INTO cko_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Am sunsun ka ma fa tana­laifiɛ aba durunya n nu a? Ai, m suse am wɔ lɛɛ, ka, ma fa má tana­laifiɛ baari a, ama, ma fa kpakpaaki­nu aba a. ");
INSERT INTO cko_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Fite kisa fa kɔ, awuru kun nu­fɔm minɛ nnu kpákpaaki nu. Minɛ nsan tí bu busu bu ŋgumi wɔ, na minɛ nnyɔ tí bu busu bu ŋgumi. ");
INSERT INTO cko_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Baa­biɛsɔ ni i si koro má bu beŋgu jɔrɛ, na baa­bara ni i ni koro má bu beŋgu jɔrɛ, na baa n ni, ni i wa yi koro má bu beŋgu jɔrɛ.” ");
INSERT INTO cko_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Na Yesu ase jama n ka, “Saŋga bo am ŋu ka nzue yinyiŋgu atiɛn i nɔɔ wiɛ afiiri, a ti ka am ŋa, nzue bá nyuma, a ŋu ka i bá a gusu. ");
INSERT INTO cko_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Na saŋga bo am ŋu ka aŋuma sukpiɛ fite nyunu ndiɛma biɛ su, a ti ka am ŋa, nyuma wiɛ fíte agaya, a ŋu ka i fíte wɔ. ");
INSERT INTO cko_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ambɛrɛ burukɔɔ­nu­fɔm ni, nzu dɛɛ ti ye am koro niɛ aŋgoro ni asiɛŋgu na am si sam bo bu bá yo n a, ye am niɛ ye am koro si má sam bo bu suyo ahin saŋga n bu a?” ");
INSERT INTO cko_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Na Yesu akaaki ase bu ka, “Nzu ti ye ambɛrɛ ni am tii sunsun má na am si sa bo i kɔ atin su a? ");
INSERT INTO cko_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nzɛn u ni be la jɔrɛ, na nzɛn i koro ka i fa u kɔ jɔrɛ­di­fɔ dɔ, jɔkɔti tara i mi n jaa, na má jɔrɛ n ju jɔrɛ­di­fɔ n dɔ, má nyini, i mi ni cín u kɔ jɔrɛ­di­fɔ n dɔ, na yiri gusu fá u ma dan­saraka niɛ­fɔ ni, na yiri gusu nyá nyi u. ");
INSERT INTO cko_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","M suse am wɔ lɛɛ, ka, nzɛn a woori dɔ, na a tɔ má kaari n kɛrɛ awie má, a nyá má atin fite má dan­saraka n nu.” ");
INSERT INTO cko_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Nyini saŋga n na minɛ nbem wo dɔ, na ba se Yesu kabo Galili­fɔ nbem yo kɔɔri ka bu kɔ yo yoo­wa ma Nyɛmɛ, na bu wo yo su ni, na Gomina Pilato gusu ama minɛm aba akun bu. ");
INSERT INTO cko_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Na wɔ se bu ka, “Ye kabo bu kuunri nyini Galili­fɔm ni, am sunsun ka nyini kere ka bu dɛɛ satiɛ yoo­wa tara Galili­fɔm kɛrɛ dɛɛ wɔ, nzɛn sɛ? ");
INSERT INTO cko_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ai, i ti má sɔ fieo. M suse am wɔ lɛɛ, ka, nzɛn am akaaki má am wo, ambɛrɛ mmɔɔ bá ka ŋgbɛɛn sɔ ɔ lɛɛ. ");
INSERT INTO cko_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ye minɛ buru ni mɔcuɛm bo Silowam dɛɛ awɔrɛ n nu kobe bambaka n tɔ gɔɔri bu ŋu n di? Am sunsun ka i kere ka bu dɛɛ satiɛ yoo­wa tara Yɛrusalem­fɔm kɛrɛ dɛɛ wɔ, nzɛn sɛ? ");
INSERT INTO cko_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ai, i ti má sɔ fieo. M suse am wɔ lɛɛ, ka, nzɛn am akaaki má am wo, ambɛrɛ mmɔɔ bá ka ŋgbɛɛn sɔ ɔ lɛɛ.” ");
INSERT INTO cko_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Dɔ na Yesu abo bu ahin miɛɛnu ni, i ŋa, “Sɔnɔ be yo woori bɛrɛ a, ye damba baka jina i baka suu­wa barasu barasum fie nu. Na wɔ kɔ aniɛniɛ ka i niɛ, beni i ŋú suu­wa su, ama, wɔ ŋu má puitiri­pui su. ");
INSERT INTO cko_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Nyini ti, na wɔ kɔ ase fie n niɛ­fɔ n ka, ‘Niɛ, afɔ kun kun sɔ nsan lɛɛ, bo m ba niɛ ahin damba baka n su ka, beni m ŋú suu­wa a, ama, m ŋu má pui su. Nyini ti, kpiɛ i ji. Nzu ti ye i jina bɛrɛ susaaki asiɛn n a?’ ");
INSERT INTO cko_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ama, na fie n niɛ­fɔ n abɔ i nu ka, ‘M mibiɛ, yaki i bɛnlɛ, na ya níɛ i kɔ ju afɔ kun bekun na ya niɛ. M fúndu kunma bara yɛ i bu wɔ, na m gɔ́ i nanyɛti. ");
INSERT INTO cko_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Dɔ na nzɛn baka n suuri suu­wa, i ti kpa, nzɛn wɔ su má, na a koro ma m kpiɛ i ji.’” ");
INSERT INTO cko_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ŋumi­yi cɛɛn n be sɔ ɔ, na Yesu wo minɛm kere su, tiɛntiɛn­bunɔɔ sɔɔm kun nu. ");
INSERT INTO cko_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Bara be woori dɔ, ajini wo i ŋu, wɔ bu i wi, i afɔ buru ni mɔcuɛ lɛɛ, i koro yasu jina má. ");
INSERT INTO cko_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Saŋga bo Yesu ŋuuri i n na wɔ bo afere i, na wɔ se i ka, “Bara, a nya u tii afite u tukpaki n nu.” ");
INSERT INTO cko_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Saŋga bo Yesu suse sɔ n na wɔ fa i saa anana i ŋu, kpeŋga na wɔ teŋge i ŋu ajina, na wɔ kansi Nyɛmɛ. ");
INSERT INTO cko_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ama, na yaa ati tiɛntiɛn­bunɔɔ sɔɔ n kpiɛn ni, ka Yesu atuntun sɔnɔ Ŋumi­yi cɛɛn ni. Na wɔ se minɛm ni ka, “Ya la le­sɛn bo wɔ yo daka ka ya fa yo juma, nyini ti, am bra nyini cɛɛnm ni, na bu bá tuntun am, ama, má Ŋumi­yi cɛɛn n yiri.” ");
INSERT INTO cko_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Na Yesu ase i ka, “Ambɛrɛ burukɔɔ­nu­fɔm ni. Ŋumi­yi cɛɛn ni, am ŋma nu ye i nyaŋgi má i naani, wara i kaako, na i kɔ ma i nzue a? ");
INSERT INTO cko_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ye ahin bara ni mmɔɔ ti Abraham busu nu­fɔɔ, ye Sitana afa i ayo i dɛɛ, afɔ buru ni mɔcuɛ lɛɛ, wɔ yo má daka ka m tuntun i Ŋumi­yi cɛɛn n na i nya laifiɛ, nzɛn sɛ?” ");
INSERT INTO cko_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","I seeri sɔ n na wɔ wura i kpɔ­fɔm ni nyinsɛ, ama, na minɛm n bɛrɛ ahore ajɔ fa kɔ alekutura sam bo wɔ yo bu n su. ");
INSERT INTO cko_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Na Yesu akaaki ase bu ka, “Nyɛmɛ fɛmɛya n ti ka nzu wɔ? Ye m fá nzu deke fa sunsun kabo i ti a? ");
INSERT INTO cko_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","I ti ka alɛ­mbaa kaan kabo nyɛm mbaa ti n wɔ, bo sɔnɔ be dɔɔri i fiesu ni, na wɔ fi, na wɔ nyi atɛtɛrɛki asa­mbaa asa­mbaa, na anumam akoro ayo bu tiɛɛrim su.” ");
INSERT INTO cko_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Na Yesu akaaki ase bu bekun ka, “Ye m fá nzu deke fa sunsun kabo Nyɛmɛ fɛmɛya n ti a? ");
INSERT INTO cko_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","I ti ka ayiri bo bu fa gɔ kpɔnɔ samɛnɛ nu na i yasu ni, na bara be fa gɔɔri samɛnɛ beberebe nu, na i kɛrɛ yasuuri n wɔ.” ");
INSERT INTO cko_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu sukɔ Yɛrusalem miɛ kpiri n su ni, na wɔ nati asin miɛ ŋgbiŋgbirim ni kan kanm su, sukere minɛm. ");
INSERT INTO cko_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Na sɔnɔ be abisa i ka, “Ya Mibiɛ, minɛm bo Nyɛmɛ dé bu tii ji ni, bu sunnu, nzɛn bu sunnu má?” Na Yesu ase bu ka, ");
INSERT INTO cko_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Am boro am nyi na am fa anɔ n bo i ti fii n na am wura, dama m suse am wɔ lɛɛ, ka, minɛ beberebe bá koro ka bu wura, ama, bu bá koro wura má. ");
INSERT INTO cko_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Saŋga n ba juuri, awuru­fɔ­biɛ ni yásu nyi anɔ n wɔ, nyini saŋga n na am jína anɔ n su, subobo, na am sére i jande ka, ‘Ya Mibiɛ, teke anɔ n ma ya.’ Na i gusu nyá se am ka, ‘Ai, m si má am sa.’ ");
INSERT INTO cko_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Dɔ na am sé i ka, ‘Ya ni wɔrɔ yo diiri a, na ya nu, na a kere minɛm ni yɛrɛ kɛrɛ, ya bɔsu dɔ.’ ");
INSERT INTO cko_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ama, na i káaki se am bekun ka, ‘Ambɛrɛ satiɛ­yo­fɔm ni, m si má am sa fieo, am cinsi m bi bɛrɛ.’ ");
INSERT INTO cko_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Na am ŋú ka Abraham, ni Izaki, ni Jakɔbu, ni Nyɛmɛ nɔaniɛ kan­fɔm ni, ka bu wo Nyɛmɛ fɛmɛya n nu, na kabo ba fa ambɛrɛ atu dasin ni, dɔ na am sún, na am kán am saa. ");
INSERT INTO cko_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Na minɛm fíte durunya n awɔrɛ nna n kɛrɛ nu, na bu bá tana Nyɛmɛ fɛmɛya n nu, na bu dí na bu nú. ");
INSERT INTO cko_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Am ti fɛn. Minɛm bo bu wo mɔ kisa ni, bá ka sin, na bo bu ka sin kisa n bá du mɔ.” ");
INSERT INTO cko_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Nyini saŋga n na Farasi­fɔ nbem aba Yesu dɔ aba ase i ka, “I ti ye ni ka a ŋmati fite fɛn, na a kɔ deke be, dama Fɛmɛ Herode koro ka i kun u wɔ.” ");
INSERT INTO cko_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Na Yesu ase bu ka, “Am kɔ na am kɔ se nyini ŋaaku sɔnɔmbiri ka o, ‘Ti fɛn. M sufɔn ajinim fite minɛm ŋu wɔ, na m ma tukpaki­fɔm nya laifiɛ, nyuma ni ahunma ŋgumi wɔ, na ahiɛni na m wíe m juma.’ ");
INSERT INTO cko_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Haari ni nyini mmɔɔ, wɔ yo daka ka m sukɔ ɔ, nyuma, ni ahunma, ni ahiɛni, dama Nyɛmɛ nɔaniɛ kan­fɔ kɛrɛ ti ye ni ka bu kun i Yɛrusalem miɛ kpiri n nu wɔ.” ");
INSERT INTO cko_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Na Yesu abo awie ase ka, “Oi, ambɛrɛ Yɛrusalem­fɔm. Ambɛrɛ kuunri Nyɛmɛ nɔaniɛ kan­fɔm n a, na minɛm bo Nyɛmɛ sunmaari bu am dɔ ni, am atu bu yabuɛ. Saŋga kɛrɛ m koro ka m tiɛn am nɔɔ, na m fa m saa bara yɛ am, kabo akɔ tiɛn i nbaam nɔɔ, i laŋkpɛtɛ nu ni, ama, am soro má m su. ");
INSERT INTO cko_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Am niɛ fɛn, Nyɛmɛ yáki am nu ji. M suse am wɔ lɛɛ, ka, fite kisa fa kɔ, am ŋú má m kun, má ka saŋga bo am bá se ka, ‘Tere­fiɛ wo yiri n bo i suba Micɛra n dɛɛ duma n nu n dɔ.’” ");
INSERT INTO cko_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ŋumi­yi cɛɛn n be sɔ ɔ, na Farasi­fɔm kpiɛn be afere Yesu ka i bra i dika na bu di diire, na Yesu akɔ. Saŋga bo i wo diire n di su ni, na minɛ aba atana suyi i kɔrɛsi. ");
INSERT INTO cko_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Kpeŋga na sɔnɔ be ayasu ajina Yesu nyunu, i saam ni i jaam kɛrɛ awura, ");
INSERT INTO cko_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesu ŋuuri sɔnɔ n sɔ ni, na wɔ bisa Nyɛmɛ nɔaniɛ kere­fɔm ni, ni Farasi­fɔm n ka, “Ya dɛɛ atin n su, atin wo nu ka ya tuntun tukpaki­fɔ Ŋumi­yi cɛɛn ni, nzɛn atin wo má nu?” ");
INSERT INTO cko_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ama, ba bɔ má i nu, na Yesu ama sɔnɔ n anya laifiɛ, na wɔ ma i atin na wɔ kɔ. ");
INSERT INTO cko_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Dɔ na wɔ nya abisa bu ka, “Am nu ŋma ye nzɛn i wa baa­biɛsɔ, wara i naani, toori bura nu, Ŋumi­yi cɛɛn ni, ye i mi kába yi má i fite má?” ");
INSERT INTO cko_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ama, ba koro abɔ má i ahin bisaa­wa n nu. ");
INSERT INTO cko_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Na Yesu aŋu kabo wɔfɔm nbem suniɛniɛ kpirikoro tanaa­biri na bu tana ni, dɔ na wɔ bo ahin miɛɛnu ni, akere bu kɛrɛ. ");
INSERT INTO cko_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","I ŋa, “Saŋga kɛrɛ bo sɔnɔ be ba fere u ka a bra ba di konyaya diire i dika, a kɔ, má a tana jirima tanaa­biri ni, a yoori sɔ, a kɔ ŋu ka wɔ fere sɔnɔ be bo i tara u, ");
INSERT INTO cko_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","nyini saŋga n na sɔnɔ n bo wɔ fere am kɛrɛ ni, yiri nyá ba u dɔ na i bá se u ka, ‘M dɔn, yasu ma ahin sɔnɔ n tanaa­biri.’ Nyini saŋga, a ŋu ka wɔ wura u nyinsɛ lɛɛ, na a kɔ́ kaan kɔɔ­biri. ");
INSERT INTO cko_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ama, sɔnɔ fereeri u ka a bra i dika ba di diire, a kɔ juuri, du mɔ kɔ tana kaan tanaa­biri ka. Dɔ na sɔnɔ n bo wɔ fere u ni, yiri nyá ba u dɔ na i bá se u ka, ‘M dɔn, yasu bra na a ba tana ahin tanaa­biri nyunyumi ni.’ Nyini n sɔ koro wura u kpiri, u beŋgu wɔfɔm kɛrɛ n nyunu a. ");
INSERT INTO cko_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Dama sɔnɔ kɛrɛ bo i wura i ŋu kpiri, Nyɛmɛ yó i mi kaan wɔ, na sɔnɔ bo i yo i ŋu kaan, Nyɛmɛ wúra i mi kpiri.” ");
INSERT INTO cko_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Dɔ na Yesu anya ase sɔnɔ n bo i baandiiri i n ka, “Saŋga bo a ŋa a fere minɛm na bu ba di diire u dika, má a fere u danfom, wara u ninbaam, wara u lamɔyam, wara u beŋgum bo bu la ajɛkɛ, nzɛn a yoori sɔ, bɛrɛ gusu bá fere u cɛɛn n be sɔ ɔ, nyini saŋga ni, ba tɔ u kaari awie lɛɛ. ");
INSERT INTO cko_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ama, saŋga kɛrɛ bo a ŋa a baandi minɛ na bu ba di diire u dika, baandi yaari­fɔm, ni wɔbukam, ni bo bu saam ni bu jaam awu ni, ni anyinsinm. ");
INSERT INTO cko_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","A nya yoori sɔ, tere­fiɛ wo u dɔ. Bɛrɛ koro tɔ má u kaari, ama, Nyɛmɛ bá tɔ u kaari a, cɛɛn bo minɛm bo bu yo sa bo i kɔ atin su Nyɛmɛ dɔ n bá teŋge bu yiwee n nu ni.” ");
INSERT INTO cko_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Yesu seeri sɔ n na wɔfɔm nu kun ase i ka, “Ŋka tere­fiɛ wo minɛm bo bu bá tana Nyɛmɛ fɛmɛya n nu di diire n dɔ.” ");
INSERT INTO cko_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Na Yesu ase i ka, “Sɔnɔ be yo woori bɛrɛ a, na wɔ yo diire beberebe, na wɔ baandi jama beberebe ka bu ba di diire ni. ");
INSERT INTO cko_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Na saŋga n bo diire n ba yoori siriya ni, na wɔ sunma i akɔɔ ka i kɔ se minɛm n bo wɔ du mɔ abaandi bu n ka, ‘Am bra, deke kɛrɛ ayo siriya.’ ");
INSERT INTO cko_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Na bu kun kun kɛrɛ asere atin ka bu koro ba má diire n di. Na ciciri su dɛɛ sɔnɔ n ase akɔɔ n ka, ‘Jande, m sere u wɔ, ma to asiɛn, i ti ye ni ka m kɔ niɛ kabo i ti wɔ, m koro ba má.’ ");
INSERT INTO cko_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Na nyiŋga n ase ka, ‘Ma to m tooram asɛsɛ busu nnu, m koro ka m kɔ fa bu yo juma kisa kisa na m niɛ, m sere u wɔ jande, m koro ba má.’ ");
INSERT INTO cko_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Na nyiŋga n gusu ase ka, ‘Ma ja bara kisa lɛɛ, nyini dɛɛ ti, m koro ba má.’ ");
INSERT INTO cko_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Na akɔɔ n akpie i nyi akɔ ase i mibiɛ n kabo minɛm kɛrɛ ase i ni. Dɔ na yaa ati awuru­fɔ­biɛ n agaya, na wɔ se yiri akɔɔ n ka, ‘Yo ndende na a kɔ miɛ kunnu atiŋgberem kɛrɛ su, na a kɔ fere yaari­fɔm, ni wɔbukam, ni anyinsinm, ni minɛm bo bu saam ni bu jaam awu ni, na a fa bu bra.’ ");
INSERT INTO cko_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Wɔ cɛ má na akɔɔ n akɔ aba, na wɔ se ka, ‘M mibiɛ, ma yo kabo a seeri ka m yo ni, ama, fofoe toko ka.’ ");
INSERT INTO cko_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Na awuru­fɔ­biɛ n ase i ka, ‘Fite kɔ miɛ n ahɛmɛ ahɛmɛ, ni i kɔrɔkam kɛrɛ nu, na a kɔ fere minɛm ka bu bra, adena m awuru n yi ni jama. ");
INSERT INTO cko_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","M suse am wɔ lɛɛ, ka, nyini minɛm kɛrɛ bo m baandiiri bu na ba ba má ni, bɛrɛ kun n kpein mmɔɔ nɔɔ kán má m diire n kun.’” ");
INSERT INTO cko_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Saŋga bo Yesu wo kɔ su ni, na jama beberebe asu i su, na wɔ cɛ aniɛ bu, na wɔ se bu ka, ");
INSERT INTO cko_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Sɔnɔ kɛrɛ bo i koro ka i ba m dɔ, i koro yo má m susu­fɔ, má ka i mi akoro m atara i si, ni i ni, ni i yi, ni i nbaam, ni i ninbaam, ni i sinbaam, ni haari yiri mmɔɔ ni i tii. ");
INSERT INTO cko_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Sɔnɔ kɛrɛ bo i koro sɔ má i yiwee baka jaanu n na i su m su, i mi koro yo má m susu­fɔ. ");
INSERT INTO cko_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ma m fa i ka sɔnɔ ŋa i ta awuru, i du mɔ tana wɔ, na i bu akunta ka, na i niɛ ka i la ŋwaa bo i koro ju awuru n ta. ");
INSERT INTO cko_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Nzɛn i ŋwaa ju má bo i ta awuru n wie, na i boori i bu na wɔ wie má i, sɔnɔ kɛrɛ bo i sin ŋuuri sa n bo wɔ yo i ni, i mi síri wɔ, ");
INSERT INTO cko_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","na bu sé ka, ‘Ahin sɔnɔ n boori i awuru n bu wɔ, ama, wɔ koro awie má i.’ ");
INSERT INTO cko_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ma m kaaki fa i ka nzɛn fɛmɛ bo i la i sojam akpii buru ye i koro ka i kɔ luɛ ni i beŋgu fɛmɛ be bo yiri la sojam akpii abura­nyɔ, i tána sunsun wɔ ka, na i niɛ ka i koro kun luɛ ni i beŋgu ni. ");
INSERT INTO cko_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Nzɛn i ŋuuri ka i koro kɔrɔ má nu, i dú mɔ sunma sɔnɔ ɔ, na i kpá i beŋgu fɛmɛ n atin na i kɔ́ sere i ka, i má bu yo jɔrɛ n dɔŋgu.” ");
INSERT INTO cko_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Na Yesu ase ka, “I ti sɔ ɔ lɛɛ, ni ambɛrɛ gusu dɔ, sɔnɔ kɛrɛ bo i wara afi má i tiɛŋgu deke, i mi koro yo má m susu­fɔ.” ");
INSERT INTO cko_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Na Yesu akaaki ase ka, “Njin yo fiɛ, ama, nzɛn i fiɛfiɛ nya ba saari wieeri, i koro yo má fiɛfiɛ kun. ");
INSERT INTO cko_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","I koro buka má asiɛn ni mmɔɔ na i kaaki koro buka má nanyɛti na i yo diire, ŋka bu fa butu wɔ. Bo i koro ka i ti ahin jɔrɛ n bu, i ti ye ni ka i mi so i sui na i ti.” ");
INSERT INTO cko_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Cɛɛn n be sɔ ɔ, na lampo­de­fɔm ni satiɛ­yo­fɔm beberebe aba Yesu dɔ na bu ba ti i keree­wam ni. ");
INSERT INTO cko_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Na Farasi­fɔm ni Yuda­fɔm Nyɛmɛ nɔaniɛ kere­fɔm n aŋuŋuti, bu ŋa, “Ahin sɔnɔ n de satiɛ­yo­fɔm wɔ, haari na i ni bɛrɛ saŋga di diire wɔ mmɔɔ.” ");
INSERT INTO cko_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Dɔ na wɔ bo bu ahin miɛɛnu ni, i ŋa, ");
INSERT INTO cko_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Nzɛn ambɛrɛ be nu la i nbɔɛm yaa, na kun miniiri, i mi yó sɛ wɔ? I yáki nbɔɛ abura­ŋgɔna ni ŋgɔnam ni boro n nu wɔ, na i kɔ́ niɛniɛ kun n bo wɔ mini ni haari i bá ŋu i. ");
INSERT INTO cko_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Saŋga bo i ba ŋuuri wieeri ni, na i ahore jɔ́ na i fá i fa bo i bɛtɛ, ");
INSERT INTO cko_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","na i fá i fa ba awuru. Dɔ na i fére i danfom ni i tana­fɔm kɛrɛ na bu tiɛn bu nɔɔ, na i sé bu ka, ‘M ahore ajɔ ka ma ŋu m bɔɛ n bo i miniiri ni. Nyini ti, am ma m ni ambɛrɛ kɛrɛ kunnu jɔ.’ ");
INSERT INTO cko_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","M suse am wɔ lɛɛ, ka, i tí sɔ ɔ lɛɛ, nzɛn sɔnɔ kun kaakiiri i wo, ahorejɔ wó Nyɛmɛ dika n nu tara minɛ abura­ŋgɔna ni ŋgɔna bo bu ŋa bu yo sa bo i kɔ atin su Nyɛmɛ dɔ na wɔ yo má daka ka bu kaaki bu wo ni.” ");
INSERT INTO cko_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Na Yesu abo bu miɛɛnu bekun, i ŋa, “Nzɛn bara be la i jɛtɛ ŋwaa buru, na kun miniiri, i mi yó sɛ? I só sin su wɔ, na i kpára bara yɛ awuru n nu, na i níɛniɛ deke n kɛrɛ, haari i bá ŋu i. ");
INSERT INTO cko_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Na saŋga bo i ba ŋuuri ni, i fére i danfom ni i tana­fɔm kɛrɛ, na bu tiɛn bu nɔɔ, na i sé bu ka, ‘M ahore ajɔ ka ma ŋu m ŋwaa n bo i miniiri ni. Nyini ti, am ma m ni ambɛrɛ kɛrɛ kunnu jɔ.’ ");
INSERT INTO cko_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","M suse am wɔ lɛɛ, ka, i ti sɔ ɔ lɛɛ, nzɛn satiɛ­yo­fɔ kun kaakiiri i wo, ahorejɔ wó Nyɛmɛ mɛrɛkɛm n dɔ.” ");
INSERT INTO cko_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Na Yesu akaaki abo bu miɛɛnu be bekun, i ŋa, “Sɔnɔ be yo woori bɛrɛ a, i la nbaa­biɛsɔm nnyɔ. ");
INSERT INTO cko_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Cɛɛn n be sɔ ɔ, na kaan n ase i si n ka, ‘M si, kpaaki u aja kɛrɛ nu na a fa m dɛɛ ma m kisa.’ Na i si n akpaaki aja n nu, na wɔ fa bu nnyɔ n kɛrɛ dɛɛ ama bu. ");
INSERT INTO cko_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Wɔ cɛ má, na kaan n atɔ i dɛɛ neŋge n kɛrɛ bo i si n fa maari i ni. I nyaari ŋwaa n wieeri sɔ ni, na wɔ yasu akɔ asiɛn dede be su. Dɔ na wɔ kɔ adi ŋwaa ni ŋgbɛɛn­ŋgbɛɛn haari na i kɛrɛ aba awie. ");
INSERT INTO cko_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Saŋga bo i ba diiri ŋwaa n kɛrɛ wieeri n na ahɔɛ bambaka be atɔ nyini asiɛn n su. Dɔ, wɔ la má pui bo i di kun. ");
INSERT INTO cko_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Nyini ti, na wɔ fa i ŋu akɔ awura nyini asiɛn n su miɛbaa be saa nu, ka i yo juma ma i mi ni, adena i nya diire di. Dɔ na miɛbaa n afa i akɔ i fiesu ka i kɔ suniɛ i afam dika. ");
INSERT INTO cko_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Na ahɔɛ aba ati i agaya, haari i ba koro ka i di afam dɛɛ diire n be mmɔɔ ɔ, ama, be ama má i deke be na i di. ");
INSERT INTO cko_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Kasin, na wɔ ba aŋu i ŋu ŋgbɛɛn fa kɔ sa n bo wɔ yo i n su, na wɔ bu i tii nu, na wɔ se i ŋu ka, ‘M si npa­di­fɔm kɛrɛ di diire wɔ na i ka, ama, mini ba wo fɛn suwu ni ahɔɛ n a. ");
INSERT INTO cko_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","M kpíe m nyi kɔ m si dɔ ɔ, na m kɔ́ se i ka, “M si, ma do Nyɛmɛ ni wɔrɔ kɛrɛ ŋgasi. ");
INSERT INTO cko_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","I ti má ye ni ka a fere m ka u wa kun, fa m yo u npa­di­fɔm ni kun.”’ ");
INSERT INTO cko_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Dɔ na wɔ yasu na i kpie i nyi kɔ i si dɔ. Saŋga bo i toko wo dede suba ni, na i si n aŋu i, na wɔ si i aŋunfɔ agaya. Na wɔ ŋmati akpa i atin, na wɔ fa i saa abara ayɛ i, na wɔ biti i. ");
INSERT INTO cko_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Na baa n ase i si n ka, ‘M si, ma do Nyɛmɛ ni wɔrɔ kɛrɛ ŋgasi. I ti má ye ni ka a fere m ka u wa kun.’ ");
INSERT INTO cko_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ama, na i si n afere i akɔɔm, na wɔ se bu ka, ‘Am kɔ ndende na am kɔ niɛ suturam kɛrɛ nu bo i ti kpa, na am fa ba wura i, na am fa ŋgaa ba wura i saa maraka, na am fa gbagbaa ba wura i jaa. ");
INSERT INTO cko_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Na am nya kɔ niɛ naanim n nu, na am tara bo i la anyunuyi bra, na am ba kpiɛ i kɔm yo i dɔŋgu, na am ma ya di na ya nu. ");
INSERT INTO cko_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Dama m ahin wa ni, i wuuri wɔ, ye wɔ teŋge a, i miniiri wɔ, ye ma ŋu i a.’ Dɔ na ba bo i bu ni di ni nu. ");
INSERT INTO cko_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Nyini saŋga n kɛrɛ baa­kpiɛn n toko wo fiesu. I ba suba awuru, na saŋga bo i ba dodoori awuru n na wɔ ti ka bu wo agɔrɛ gɔ su ni jue. ");
INSERT INTO cko_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Dɔ na wɔ fere i si akɔɔm kun, na wɔ bisa i ka, ‘Nzu sa yoori awuru a?’ ");
INSERT INTO cko_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Na akɔɔ n abɔ i nu ka, ‘U niɛma ye wɔ ba awuru a, ye u si ama nɔɔ ye ya kpiɛ naani bo i la anyunuyi n kɔm, dama u niɛma n aba awuru ni laifiɛ n ti.’ ");
INSERT INTO cko_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Na yaa ati baa­kpiɛn ni agaya, haari na wɔ kete ka i wura má awuru n nu. Nyini ti, na i si n afite aba asere i jande ka i wura. ");
INSERT INTO cko_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ama, na wɔ se i si n ka, ‘Ti fɛn, afɔ nyɛ nyɛ lɛɛ bo m wo u dɔ yo juma ma u, ka m ti akɔɔ ɔ, ma kete má u nɔaniɛ be. A koro ama má m puitiri­pui, haari siri­mbaa mmɔɔ ka m gusu fa na m ni m danfom fa di na ya nu. ");
INSERT INTO cko_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ama, u ahin wa n yiri, wɔ fa u aja bo a fa ama i n akɔ boro, na wɔ kɔ ayo i koroo­wa ni nbara­sakaram. Haari ni nyini n kɛrɛ ni, i kpieeri i nyi ba juuri awuru ni, a ma nɔɔ ka bu kpiɛ naani bo i la anyunuyi n kɔm ma i.’ ");
INSERT INTO cko_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Na i si n ase i ka, ‘M wa, saŋga kɛrɛ mini ni wɔrɔ wo bɛrɛ a, deke kɛrɛ bo i ti m dɛɛ ti u dɛɛ wɔ. ");
INSERT INTO cko_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ama, wɔ yo daka ka ya di na ya nu na ya gɔ agɔrɛ, dama u niɛma ni, i wuuri wɔ, ye wɔ teŋge a, i miniiri wɔ, ye ma ŋu i a.’” ");
INSERT INTO cko_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Na Yesu ase i susu­fɔm n ka, “Biɛ neŋge­fɔ be woori bɛrɛ a, i la i amusui­su­fɔ kpiɛn bo yiri niɛ i neŋge n kɛrɛ su a. Na minɛm aba neŋge­fɔ n dɔ aba se i ka i amusui­su­fɔ kpiɛn ni susaaki i neŋgem ni. ");
INSERT INTO cko_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Nyini ti, na wɔ fere i, na wɔ se i ka, ‘M suti jɔrɛ nbem fa kɔ u dɔ. Nyini ti, ba bu akunta kere m na m si kabo a bita m neŋgem barasu, dama a koro niɛ má bu dika kun.’ ");
INSERT INTO cko_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Na amusui­su­fɔ kpiɛn n ase i tii nu ka, ‘Ye kisa na m mibiɛ ni sufɔn m fite m juma n nu ni, m yó sɛ wɔ? M la má faŋga bo m koro dɔ, m gusu nyunu asin ni bo m nati susere. ");
INSERT INTO cko_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ɛɛnhɛɛn, kisa m si kabo m yo, na haari nzɛn m ba fuunri m juma ni, m fún má m danfom bo m kɔ́ wo bu dɔ.’ ");
INSERT INTO cko_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Nyini ti, na wɔ fere minɛm kɛrɛ bo bu bita i mibiɛ n kaari n kun kun. Na wɔ bisa ciciri su dɛɛ sɔnɔ n ka, ‘A bita m mibiɛ n kaari nyɛ wɔ?’ ");
INSERT INTO cko_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Na wɔ bɔ i nu ka, ‘M bita i ŋguin nzue sɔ gaŋga yaa kun wɔ.’ Na amusui­su­fɔ kpiɛn n ase i ka, ‘De u kaari kadasi ni, na a tana, na a kɛrɛ ka a bita gaŋga aburu­nu wɔ.’ ");
INSERT INTO cko_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Na wɔ nya abisa nyiŋga gusu ka, ‘Ye wɔrɔ di, a bita kaari nyɛ wɔ?’ Na wɔ bɔ i nu ka, ‘M bita i alɛ­mbaa pirim bɔtɔ yaa kun wɔ.’ Na amusui­su­fɔ kpiɛn n ase i gusu ka, ‘De u kaari kadasi na a kɛrɛ ka a bita pirim bɔtɔ abura­mɔcuɛ wɔ.’ ");
INSERT INTO cko_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","I mibiɛ ŋuuri sɔ ni, na wɔ kansi i fa kɔ nyini ŋgɔnlɛ bo i la i n su, haari ni bo i la má dabuŋu ni. Kabo i ti lɛɛ, durunya n nu­fɔm la ŋgɔnlɛ fa kɔ durunya n nu dɛɛ sa­yoo­wam n su tara minɛm bo Nyɛmɛ ma bu wo wein n nu ni.” ");
INSERT INTO cko_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Na Yesu ase bu bekun ka, “M suse am wɔ lɛɛ, ka, am fa durunya n nu dɛɛ fin ajɛkɛ bo am la i n fa tara danfoya, adena ajɛkɛ n ba ŋmati yakiiri am, na minɛm bá de am wura woo­biri kpa bo i la má awieeri n nu. ");
INSERT INTO cko_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Sɔnɔ kɛrɛ bo minɛm koro daafi i ŋu ka i bita deke kaan ni nahɔrɛ atin, yiri ye bu koro daafi i ŋu ka i bita deke bambaka mmɔɔ ni nahɔrɛ atin a. Ama, sɔnɔ kɛrɛ bo bu koro daafi má i ŋu ka i bita deke kaan ni nahɔrɛ atin, bu koro daafi má i mi ŋu ka i bita deke bambaka mmɔɔ. ");
INSERT INTO cko_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Tɔ, nzɛn ambɛrɛ la má dabuŋu bo am koro bita durunya n nu dɛɛ fin ajɛkɛm ni nahɔrɛ atin, ŋma fá Nyɛmɛ dɛɛ ajɛkɛm wura am saa nu? ");
INSERT INTO cko_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Na nzɛn am la má dabuŋu bo am koro bita be dɛɛ ajɛkɛm ni nahɔrɛ atin, ŋma fá deke bo i bá yo am tiɛŋgu dɛɛ ma am a? ");
INSERT INTO cko_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Sɔnɔ kun koro saŋga su má mibiɛm nnyɔ. Nzɛn i ŋa i yó sɔ, i kpɔ́ kun n wɔ, na i kóro nyiŋga ni, wara, i bóro i nyi su kun wɔ, na i bú nyiŋga ni ŋgbɛɛn. Am koro saŋga su má Nyɛmɛ ni ajɛkɛ.” ");
INSERT INTO cko_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Saŋga bo Farasi­fɔm n tiiri ahin n kɛrɛ n sɔ ni, na ba siri i, dama bu ti ŋwaa koro­fɔm wɔ. ");
INSERT INTO cko_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Na Yesu ase bu ka, “Ambɛrɛ ŋa am ti minɛm bo bu yo sa bo i kɔ atin su Nyɛmɛ dɔ na minɛm ŋu am n a, ama, Nyɛmɛ yiri si am ahore su kɛrɛ. Dama deke bo adamande sunsun ka i ŋusu nya má ni, nyini ye Nyɛmɛ kpɔ i a. ");
INSERT INTO cko_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Nyɛmɛ Jɔrɛ Kadasi n bo Moyisi ni Nyɛmɛ nɔaniɛ kan­fɔm kɛrɛɛri i n wo bɛrɛ ka, ye Yohane nya baari a, nyini n sin, na ba kan labari kpa n akere minɛm fa kɔ Nyɛmɛ fɛmɛya n su, na sɔnɔ kɛrɛ suboro i nyi ka i kpini atin na i wura nu. ");
INSERT INTO cko_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","I ti má kekereke na aŋgoro ni asiɛŋgu kɛrɛ bá mini, ama, Nyɛmɛ dɛɛ nɔaniɛ kpamaa­wa n kampiti sɔ mmɔɔ ká má ŋgbɛɛn. ");
INSERT INTO cko_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Sɔnɔ kɛrɛ bo i faari i yi jiiri na i jaari bara fɔfɔrɛ, i mi n asaaki ajaa ciire lɛɛ. Na sɔnɔ kɛrɛ bo i jaari bara bo wɔ fite i hun ajaa bu, i mi n asaaki ajaa ciire lɛɛ.” ");
INSERT INTO cko_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Na Yesu ase bu ka, “Neŋge­fɔ be yo woori bɛrɛ a, saŋga kɛrɛ saŋga, i wura sutura kpa kpa bo i la gɔ ɔ, na i sudi i koroo­wa cɛɛn n kɛrɛ cɛɛn. ");
INSERT INTO cko_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Na yaari­fɔ be gusu wo bɛrɛ, bu fere i ka Lazarosi, kambue abara ayɛ i deke kɛrɛ. Na bu sufa i ba tana neŋge­fɔ n anɔ nu, ");
INSERT INTO cko_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","adena neŋge­fɔ n ba sudi diire, na nzɛn be tɔtɔ asiɛŋgu, na i gusu fa di. Haari na caam ba sutafi i kambue n nu. ");
INSERT INTO cko_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Na sɔnɔ yaari­fɔ n aba awu, na Nyɛmɛ mɛrɛkɛm aba afa i akɔ aŋgoro Abraham bi. Na neŋge­fɔ n gusu aba awu na ba se i, ");
INSERT INTO cko_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","na yiri akɔ Yiwee­fɔm Woo­biri. I wo wahara di su dɔ sɔ ni, na wɔ yɛ i tii su aŋu Abraham dede dɔ, Lazarosi wo i bi. ");
INSERT INTO cko_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Dɔ na wɔ bo afere Abraham ase i ka, ‘Ya si Abraham, si m aŋunfɔ. Na a sunma Lazarosi na i fa i saa maraka dɔ nzue nu na i fa ba dɔ m taferema, dama m wo wahara bambaka nu wɔ, sin nu fɛn.’ ");
INSERT INTO cko_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ama, na Abraham ase i ka, ‘Teŋge su ka saŋga bo a la ŋgɔɔ wo durunya n nu ni, a yoori u koroo­wa a, na Lazarosi yiri adi durunya n nu wahara n kɛrɛ. Ama, kisa yiri wo fiɛ di su, ye wɔrɔ wo wahara di su n a. ");
INSERT INTO cko_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Bekun, kunma ŋgoŋgo wo u ni yɛrɛ afiɛn, bo be koro fite má fɛn na i kɔ u bi. Be gusu koro fite má u bi dɔ na i ba ya dɔ fɛn.’ ");
INSERT INTO cko_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Na neŋge­fɔ n ase ka, ‘Ya si Abraham, m sere u wɔ, ka a sunma Lazarosi na i kɔ m si awuru n nu, ");
INSERT INTO cko_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","m ninbaam nnu wo dɔ, na i kɔ bɔbɔ bu ka bu si bu ŋu sa na má bu bá wo ahin wahara bambaka woo­biri n bo m wo ni.’ ");
INSERT INTO cko_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Na Abraham ase i ka, ‘Nyɛmɛ Jɔrɛ Kadasi n bo Moyisi ni Nyɛmɛ nɔaniɛ kan­fɔm kɛrɛ maari bu ni, i wo bu dɔ. Wɔ yo daka ka bu so bu sui na bu ti i bu, na bu si bu ŋu sa.’ ");
INSERT INTO cko_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Na neŋge­fɔ n ase i ka, ‘Ya si Abraham, bu dé má i. Ama, nzɛn sɔnɔ fiteeri minɛm bo ba wu n dɔ kɔɔri bu dɔ, bu káaki bu wo.’ ");
INSERT INTO cko_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ama, na Abraham ase i ka, ‘Nzɛn ba so má bu sui na bu ti Nyɛmɛ Jɔrɛ Kadasi n bo Moyisi ni Nyɛmɛ nɔaniɛ kan­fɔm kɛrɛ maari bu ni, haari nzɛn sɔnɔ teŋgeeri i yiwee n nu mmɔɔ baari, bu dé má i.’” ");
INSERT INTO cko_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Na Yesu ase i susu­fɔm n ka, “Sam nbem bo bu yo na bu fa minɛ wura satiɛ nu ni, nyini sam ni bá yo saŋga kɛrɛ, ama, anyum­boro wo sɔnɔ kɛrɛ bo i ma nyini sam yoori n dɔ. ");
INSERT INTO cko_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Nzɛn má bu faari ŋgani san yabuɛ ciciiri i mi kɔm na bu fa i kɔ tuuri tieku nu mmɔɔ, má i ti ye tara bo i mi ma ahin yarada­yo­fɔm n be wura satiɛ nu. ");
INSERT INTO cko_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Nyini ti, am si am ŋu sa. Nzɛn wɔrɔ kɛrɛ bo u niwa yoori u satiɛ be, jaraki i, na nzɛn i kaakiiri i wo, na a fa i satiɛ n ce i. ");
INSERT INTO cko_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Nzɛn i yoori u satiɛ kɔ jinaari haari kpe nso mmɔɔ wiɛ kun nu, na i baari u dɔ ba seeri u ka, ‘Ma yo u satiɛ,’ fa i satiɛ n ce i.” ");
INSERT INTO cko_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Na Yesu jaramasam n ase i ka, “Buka ya na ya yarada yo bii­wa.” ");
INSERT INTO cko_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Na Mibiɛ n ase bu ka, “Nzɛn má am la yarada bo i kɔ ju kabo nyɛm mbaa ti ni mmɔɔ, má am koro se ahin koto baka n ka, ‘Kpekiti ni u bunlui n kɛrɛ na a kɔ jina tieku n nu,’ má i de am nɔaniɛ n wɔ. ");
INSERT INTO cko_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ma m fa i ka, am nu, nzɛn be la akɔɔ na i wo fiesu wara i sasa nbɔɛm wɔ, na i ba baari awuru, am nu ŋma ye i kaba se akɔɔ n ka, ‘Ba tana na a di diire’ a? ");
INSERT INTO cko_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Am be se má i sɔ da. Ama, kabo a se i n la ka, ‘Yo m diire siriya, na a jina ŋminda na m di na m nu ka, na a nya kɔ yo u dɛɛ di.’ ");
INSERT INTO cko_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Nzɛn u akɔɔ n deeri u nɔaniɛ na i yoori juma bo a se i ka i yo i ni, a se má i ka, ‘M da u asi.’ ");
INSERT INTO cko_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","I ti sɔ ɔ lɛɛ, ambɛrɛ gusu dɔ, saŋga bo am ayo juma n kɛrɛ bo am mibiɛ n ase ka am yo i ni, am se ka, ‘Yɛrɛ ti akɔɔm wɔ, ya ti má ye ni ka bu kansi ya, dama ya juma lɛɛ, ye ya yo i n a.’” ");
INSERT INTO cko_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Saŋga bo Yesu sukɔ Yɛrusalem miɛ kpiri n nu ni, na wɔ sin Samariya ni Galili awɔrɛm n afiɛn. ");
INSERT INTO cko_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","I kɔ ŋa i wura miɛ kaan be nu, na i ni koko­fɔ buru nbem ayɛ. Na ba jina dede ");
INSERT INTO cko_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","atiɛn kpa ka, “Ya Mɔ­fɔ Yesu, si ya aŋunfɔ.” ");
INSERT INTO cko_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","I ŋuuri bu sɔ n na wɔ se bu ka, “Am kɔ na am kɔ fa am ŋu kere Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm ni, na bu fiiti am na bu niɛ.” Na ba de atin sukɔ, bu wo kɔ su n na bu kɛrɛ aŋu ka ba nya laifiɛ. ");
INSERT INTO cko_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Dɔ na bu nu kun ŋuuri ka wɔ nya laifiɛ sɔ ni, na wɔ kpie i nyi aba Yesu dɔ sutiɛn kpa sukansi Nyɛmɛ. ");
INSERT INTO cko_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Na wɔ ba akutu haari Yesu jaa bu asiɛŋgu, na wɔ da i asi. Nyini sɔnɔ n ti Samariya­fɔ ɔ. ");
INSERT INTO cko_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Dɔ na Yesu abisa ka, “Má minɛ buru nyaari laifiɛ a, ye ŋgɔna nyiŋgam n wo ni? ");
INSERT INTO cko_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Nzu ti ye ahin sɔnɔ n bo i ti má Yuda­fɔ ni ŋgumi aba ka i ba da Nyɛmɛ asi a?” ");
INSERT INTO cko_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Dɔ na wɔ se sɔnɔ n ka, “Yarada n bo a yo m ni, yiri ma a nya laifiɛ a. Yasu na a kɔ awuru.” ");
INSERT INTO cko_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Na Farasi­fɔ nbem abisa Yesu ka, “Ye saŋga bɔnɔ ye Nyɛmɛ Fɛmɛ bá niɛ i minɛm su a?” Na wɔ bɔ bu nu ka, “Sa be wo má bɛrɛ bo i koro kere am saŋga bo Nyɛmɛ Fɛmɛ bá niɛ i minɛm su. ");
INSERT INTO cko_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Be se má ka, ‘Am niɛ, yiri yaa fɛn,’ wara, ‘Yiri lɛɛ dɔ.’ Dama m se am nahɔrɛ wɔ lɛɛ ka, Nyɛmɛ wo am nu fɛn jina n nu, suniɛ i minɛm su.” ");
INSERT INTO cko_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Na wɔ se i susu­fɔm ni ka, “Saŋga suba bo am bá koro ka am ŋu mini Adamande Wa n ba saŋga ni, haari cɛɛn kun mmɔɔ, ama, am ŋú má i. ");
INSERT INTO cko_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Nbem bá ba na bu sé am ka, ‘Am niɛ, yiri lɛɛ dɔ,’ wara, ‘Yiri yaa fɛn.’ Ama, má am fite kɔ su bu su. ");
INSERT INTO cko_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Dama mini Adamande Wa n ba cɛɛn ni, i tí kabo nzue kpɛsɛ na i ta papasi bara yɛ deke kɛrɛ n wɔ. ");
INSERT INTO cko_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ama, kana ahin kɛrɛ bá yo, wɔ yo daka ka m du mɔ di wahara beberebe, na ambɛrɛ nyuma­fɔm bá kete m. ");
INSERT INTO cko_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Mini Adamande Wa n ba saŋga ni yó kabo ya na Nowa saŋga na i yoori n wɔ. ");
INSERT INTO cko_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Nyini saŋga ni, sɔnɔ kɛrɛ woori di ni nu su wɔ, na nbaram ni nbiɛsɔm suja bu beŋgum, fa kɔ juuri haari cɛɛn n bo Nowa wuraari lee bambaka n nu, na wɔmbu n ba diiri deke kɛrɛ n wɔ. ");
INSERT INTO cko_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","I yo sɔ ɔ lɛɛ bekun, ka Loti dɛɛ saŋga ni. Nyini saŋga ni, sɔnɔ kɛrɛ woori di ni nu su wɔ, na nbem sutɔ, na nbem suto, na nbem sudɔ dɔdɔɔri, na nbem suta fa. ");
INSERT INTO cko_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Cɛɛn n bo Loti fa yasuuri Sodom miɛ kpiri n nu ni, nyini cɛɛn n ye sin ni ferewita sin fiteeri aŋgoro a, na wɔ ba atɔ miɛ n nu adi deke n kɛrɛ. ");
INSERT INTO cko_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Kabo cɛɛn n bo mini Adamande Wa ni bá yi m ŋu kere lɛɛ.” ");
INSERT INTO cko_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Na Yesu akaaki ase ka, “Nyini cɛɛn ni, wɔrɔ kɛrɛ bo a wo kpata nu, na u neŋge wo awuru n nu, má a wura gisan nu fa pui. I ti sɔ ɔ lɛɛ, wɔrɔ kɛrɛ gusu bo a wo fiesu, má a kpie u nyi kɔ awuru. ");
INSERT INTO cko_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Am teŋge su fa kɔ sa bo i yoori Loti yi ni. ");
INSERT INTO cko_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Dama sɔnɔ kɛrɛ bo i ŋa i kpíni i ŋgɔɔ busu, i mi bá fun i, ama, na sɔnɔ kɛrɛ bo i tɔɔri i ŋgɔɔ maari m, i mi nyá ŋgɔɔ. ");
INSERT INTO cko_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","M suse am wɔ lɛɛ, ka, nyini cɛɛn n kɔŋguɛ, minɛ nnyɔ ɔ dá dasu kun su wo daafiri su a, na Nyɛmɛ má bu bá fa kun n kɔ yaki kun ni. ");
INSERT INTO cko_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Na nbaram nnyɔ kási wo ŋgani san su, na Nyɛmɛ má bu bá fa kun n kɔ yaki kun ni.  ");
INSERT INTO cko_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Na biɛsɔm nnyɔ bá wo juma yo su fiesu, na Nyɛmɛ má bu bá fa kun yaki kun ni.” ");
INSERT INTO cko_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","I susu­fɔm tiiri sɔ ni, na ba bisa i ka, “Ya Mibiɛ, nifansu ye ahin sam kɛrɛ bá yo a?” Na wɔ bɔ bu nu ka, “Deke kɛrɛ bo deke fuin nya wo, pɛtɛm bara yɛ dɔ ɔ.” ");
INSERT INTO cko_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Dɔ na Yesu abo miɛɛnu akere i susu­fɔm n ka wɔ yo daka ka bu sere Nyɛmɛ saŋga kɛrɛ, na má bu yaki i sere. ");
INSERT INTO cko_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","I ŋa, “Jɔrɛ­di­fɔ be woori miɛ be su a, i soro má Nyɛmɛ, na i kaaki bu má be. ");
INSERT INTO cko_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Na bara kuna­fɔ be awo nyini miɛ n su, saŋga kɛrɛ i ba jɔrɛ­di­fɔ n dɔ ɔ, na i ba sere i ka, ‘Jɔrɛ bo mini ni m kpɔ­fɔ n bita i ni, buka m na m nya nahɔrɛ.’ ");
INSERT INTO cko_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Na wɔ cɛ bo jɔrɛ­di­fɔ n bɔ má i n nu. Ama, na kasin, na wɔ ba asunsun i tii nu, na wɔ se ka, ‘Haari ni bo m soro má Nyɛmɛ na m bu má be ni, ");
INSERT INTO cko_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ama, kabo saŋga kɛrɛ na ahin kuna­fɔ n bita kpiɛ m daafiri n dɛɛ ti, m má i nya nahɔrɛ wɔ. Nzɛn ma yo má sɔ, i suba m dɔ sɔ ɔ, haari i bá ma m wara yi m ŋu.’” ");
INSERT INTO cko_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Na Yesu akaaki ase bu ka, “Ye m ŋa am ati kabo nyini jɔrɛ­di­fɔ findi­fɔ n seeri ni. ");
INSERT INTO cko_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ye nzu ti ye Nyɛmɛ búka má i dɛɛ minɛm bo bu sun fere i kɔŋguɛ ni wiɛsu kɛrɛ a, na bu nyá nahɔrɛ a? I cɛ́ má ni bu buka. ");
INSERT INTO cko_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","M suse am wɔ lɛɛ, ka, i búka bu wɔ na bu nya nahɔrɛ ndende. Ama, haari ni nyini mmɔɔ, saŋga bo mini Adamande Wa n ba baari, m bá ŋu minɛm bo bu toko yo m yarada, nzɛn sɛ a? Ai, m ŋú má be.” ");
INSERT INTO cko_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Na Yesu akaaki abo ahin miɛɛnu n akere minɛm bo bu sunsun ka bɛrɛ yo sa bo i kɔ atin su Nyɛmɛ dɔ na bu bu má be ni. ");
INSERT INTO cko_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","I ŋa, “Cɛɛn n be sɔ ɔ, na minɛ nnyɔ nbem akɔ ka bu kɔ sere Nyɛmɛ, Nyɛmɛ Seree­biri Awuru n nu. Kun n ti Farasi­fɔ ɔ, na nyiŋga n ti lampo­de­fɔ. ");
INSERT INTO cko_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Na Farasi­fɔ n ajina i ŋgumi abo i hoe asere Nyɛmɛ ka, ‘Micɛra Nyɛmɛ, m da u asi ka m ti má kabo minɛ nyiŋgam ti barasu ni. M ti má anyii­fɔ, m ti má findi­fɔ, m saaki má ajaa ciire, haari m ti má ka nyini lampo­de­fɔ n bo i jina dɔ ni. ");
INSERT INTO cko_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Le­so kun kun kɛrɛ nu, m cici m nɔɔ kpe nnyɔ nnyɔ ɔ, na deke buru kɛrɛ bo m la i, m yi i kun kun ma u wɔ.’ ");
INSERT INTO cko_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ama, na lampo­de­fɔ n ajina dede, haari wɔ koro má ka i yɛ i tii su niɛ aŋgoro mmɔɔ, na wɔ fa i saa ataka i beŋgu nu, na wɔ se ka, ‘Micɛra Nyɛmɛ, m ti satiɛ­yo­fɔ ɔ, si m aŋunfɔ.’” ");
INSERT INTO cko_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Na Yesu ase ka, “M suse am wɔ lɛɛ, ka, nyini minɛ nnyɔm ni sereeri Nyɛmɛ wieeri, na bu kɔ juuri awuru ni, Nyɛmɛ deeri lampo­de­fɔ ni ka i ti sɔnɔ bo i yo sa bo i kɔ atin su i dɔ a, má Farasi­fɔ ni. Dama sɔnɔ kɛrɛ bo i wura i ŋu kpiri, Nyɛmɛ yó i kaan wɔ, ama, na sɔnɔ bo i yo i ŋu kaan, Nyɛmɛ wúra i mi kpiri wɔ.” ");
INSERT INTO cko_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Cɛɛn be na minɛ nbem sufa bu nbaam ba Yesu dɔ ka i fa i saa nana bu ŋu na i yo bu kisi. I susu­fɔm n ŋuuri i sɔ ni, na ba tiɛn minɛm n ŋu. ");
INSERT INTO cko_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ama, na Yesu afere nbaatumam ni, na wɔ se ka, “Am ma nbaatumam n bra m dɔ, má am fɔn bu. Dama bɛrɛ ŋusu sɔ ye Nyɛmɛ fɛmɛya n ti bu dɛɛ a. ");
INSERT INTO cko_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nahɔrɛ ye m suse am n a, wɔrɔ kɛrɛ bo a de má Nyɛmɛ fɛmɛya n nu jɔrɛ kabo baatuma de deke i saa nnyɔ ni, a wúra má Nyɛmɛ fɛmɛya n nu fieo.” ");
INSERT INTO cko_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Na Yuda­fɔ nkpiɛn­kpiɛnm be abisa Yesu ka, “Ya Kere­fɔ sɔnɔ kpa, m yó sɛ ye m bá nya ŋgɔɔ n bo i la má awieeri n a?” ");
INSERT INTO cko_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Na wɔ bɔ i nu ka, “Nzu ti ye a fere m ka sɔnɔ kpa a? Be ti má kpa sin Nyɛmɛ ŋu. ");
INSERT INTO cko_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ye m ŋa a si Nyɛmɛ nɔaniɛ maa­wam ni e, bu ŋa, ‘Má a saaki ajaa ciire. Má a kun sɔnɔ. Má a wɔ. Má a di kɔrɛ daani. Bu u si ni u ni.’” ");
INSERT INTO cko_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Na sɔnɔ n ase i ka, “Ma su nyini nɔaniɛ maa­wam n kɛrɛ su haari m kaan nu.” ");
INSERT INTO cko_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesu tiiri sɔ n na wɔ se i ka, “Deke kun be ye wɔ kpiɛ u su a. Kɔ na a kɔ tɔ u aja n kɛrɛ, na a fa ŋwaa n ma yaari­fɔm, na a bá nya ajɛkɛ Nyɛmɛ dɔ, na a bra ba su m su.” ");
INSERT INTO cko_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ama, sɔnɔ n tiiri sɔ n na i ahore asaaki, dama i la neŋge agaya n dɛɛ ti. ");
INSERT INTO cko_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Na Yesu aniɛ sɔnɔ n nyunu, na wɔ se i ka, “I ti kekereke bo neŋge­fɔ wura Nyɛmɛ fɛmɛya n nu. ");
INSERT INTO cko_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kabo nyɔɔma sin misini bue nu ni, i ti má kekereke tara má kabo neŋge­fɔ yo na i wura Nyɛmɛ fɛmɛya n nu.” ");
INSERT INTO cko_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Minɛm ni tiiri sɔ ni, na ba bisa ka, “Ye nzɛn i ti sɔ e, ŋma koro fite nu a?” ");
INSERT INTO cko_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Na wɔ bɔ nu ka, “Deke bo adamande koro yo má i, Nyɛmɛ koro yo i.” ");
INSERT INTO cko_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Na Petoro ase i ka, “Tɔ, ye yɛrɛ ayaki ya dekem kɛrɛ susu u su e.” ");
INSERT INTO cko_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Na wɔ se bu ka, “Nahɔrɛ ye m suse am n a, sɔnɔ kɛrɛ bo i yakiiri i awuru, wara i yi, wara i ninbaam, wara i wu­fɔm, wara i nbaam, Nyɛmɛ fɛmɛya n dɛɛ ti, ");
INSERT INTO cko_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","i mi nyá nyinim ŋusu sɔ yaa i ŋgɔɔ su, na fa kɔ fa ba, i nyá ŋgɔɔ n bo i la má awieeri ni.” ");
INSERT INTO cko_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Na Yesu afere i susu­fɔ buru ni nnyɔm n akɔ ahɛmɛ, na wɔ se bu ka, “Am ti fɛn. Ya sukɔ Yɛrusalem lɛɛ, dɔ ye bu kɔ́ yo mini Adamande Wa n kabo Nyɛmɛ nɔaniɛ kan­fɔm akɛrɛ ka bu yó m n a. ");
INSERT INTO cko_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Na bu fá m wura minɛm bo bu ti má Yuda­fɔm saa nu, na bu yó m anzasi, na bu kpíɛ m nzukɔ, na bu yí nanzue gɔ m ŋu, ");
INSERT INTO cko_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","na bu fín m ŋgbere, na bu nyá kun m, na i le­san cɛɛn, na m téŋge m yiwee n nu.” ");
INSERT INTO cko_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ama, i susu­fɔm n ati má i jɔjɔɔ­wa n be bu. Nyɛmɛ ayi má i nyi akere má bu, nyini ti, ba koro ati má i bu. ");
INSERT INTO cko_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Saŋga bo Yesu kɔ sudodo miɛ kpiri be bo bu fere i ka Yeriko ni, na anyinsin be tana atin n nɔɔ su wo sere su. ");
INSERT INTO cko_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","I tiiri ka jama n wo sin su ni, na wɔ bisa ka, “Nzu suyo a?” ");
INSERT INTO cko_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Na ba se i ka, “Yesu Nazarɛti­fɔ ni susin a.” ");
INSERT INTO cko_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Dɔ na wɔ tiɛn afere i, i ŋa, “Yesu, Fɛmɛ Davidi anuma, si m aŋunfɔ.” ");
INSERT INTO cko_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Na minɛm n atiɛn i ŋu ka i yaki naŋmiɛ. Ama, haari ni nyini mmɔɔ, na wɔ kaaki atiɛn kpa abuka su ka, “Fɛmɛ Davidi anuma, si m aŋunfɔ.” ");
INSERT INTO cko_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesu tiiri sɔ n na wɔ ka ajina, na wɔ se ka bu fa i bra i dɔ. Na ba fere i ama i. I ba dodoori ni, na Yesu abisa i ka, ");
INSERT INTO cko_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“A koro ka m yo nzu ma u a?” Na wɔ bɔ i nu ka, “M Mibiɛ, m koro ka a ma m ŋu asi wɔ.” ");
INSERT INTO cko_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Na Yesu ase i ka, “Ŋu asi bekun. Yarada n bo a yo m ni, nyini ma a nya laifiɛ a.” ");
INSERT INTO cko_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Kpeŋga na wɔ kaba aŋu asi, na wɔ su i su, sukansi Nyɛmɛ. Jama n ŋuuri i sɔ n na bu kɛrɛ gusu akansi Nyɛmɛ. ");
INSERT INTO cko_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu kɔ wuraari Yeriko miɛ kpiri n nu na wɔ koro ka i sin. ");
INSERT INTO cko_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Biɛ be woori dɔ, bu fere i ka Zakayosi, i ti lampo­de­fɔm kɛrɛ kpiɛn wɔ, na i la ajɛkɛ agaya. ");
INSERT INTO cko_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Na wɔ boro i nyi ka i ŋu Yesu na i si i. Ama, jama asunnu agaya n dɛɛ ti, wɔ koro aŋu má i, dama i ti sɔnɔ tika a. ");
INSERT INTO cko_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Nyini ti, na wɔ ŋmati adu jama n mɔ akɔ afun baka na i ŋu i, dama wɔ ŋu ka Yesu fá nyini baka n bu sin a. ");
INSERT INTO cko_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Saŋga bo Yesu ba juuri nyini awɔrɛ n nu n na wɔ niɛ aŋgoro, na wɔ se i ka, “Zakayosi, jura bra ndende, dama wɔ yo daka ka m yo u wɔfɔ ɔ nyuma.” ");
INSERT INTO cko_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Na wɔ jura ndende, na wɔ kɔ ade i wɔfɔ ni ahorejɔ bambaka. ");
INSERT INTO cko_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Na bo bu ŋuuri i n kɛrɛ aŋuŋuti. Bu ŋa, “Ahin sɔnɔ n akɔ na i kɔ da satiɛ­yo­fɔ dika.” ");
INSERT INTO cko_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Na Zakayosi ayasu ajina, na wɔ se Mibiɛ n ka, “M Mibiɛ, ti fɛn. M kpáaki m ajɛkɛ kɛrɛ nu busu nnyɔ, na m fá buekun n ma yaari­fɔm. Na nzɛn ma sisi be, m tɔ́ i sɔ ŋusu nna, na m fá ma i mi.” ");
INSERT INTO cko_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Na Yesu ase i ka, “Nyuma dɛɛ cɛɛn n nu, Nyɛmɛ ade ahin awuru n nu­fɔm tii aji, dama ahin sɔnɔ ni mmɔɔ ti Abraham busu nu­fɔɔ. ");
INSERT INTO cko_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Nahɔrɛ, mini Adamande Wa n baari ka m bá niɛniɛ minɛm bo ba mini n wɔ na m dé bu tii ji.” ");
INSERT INTO cko_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Saŋga bo minɛm ni toko so bu sui ti ahin jɔrɛm bo Yesu sujɔjɔ bu ni, na Yesu akaaki abo bu miɛɛnu be, dama nyini saŋga ni wɔ ka kaan sɔ na i wúra Yɛrusalem miɛ kpiri n nu, na minɛm asunsun ka saŋga n akaba aju bo Nyɛmɛ bá niɛ i minɛm su lɛɛ. ");
INSERT INTO cko_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Nyini ti, na wɔ se bu ka, “Fɛmɛ baa be yo woori bɛrɛ a, cɛɛn be sɔ ɔ, na wɔ yasu ka i kɔ asiɛn dede be su ka i kɔ di fɛmɛya na i kpie i nyi ba. ");
INSERT INTO cko_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Kana i ba kɔ ni, na wɔ fere i akɔɔm buru, na wɔ fa ŋwaa akpaaki bu kɛrɛ nu, na wɔ se bu ka, ‘M kɔ wieeri, ambɛrɛ si kabo am yo ahin ŋwaa n a, haari m bá kpie m nyi ba.’ ");
INSERT INTO cko_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Nyini sɔnɔ n gusu, i minɛm akoro má ka i yo bu fɛmɛ, bu kpɔ i wɔ, nyini ti, na ba sunma minɛm ka bu kɔ se ka, ‘Ya koro má ka ahin sɔnɔ n bá yo ya fɛmɛ.’ ");
INSERT INTO cko_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Na sɔnɔ n akɔ adi fɛmɛya ni, na wɔ kpie i nyi aba. I ba juuri kpeŋga i kaba tiɛɛnri i akɔɔm ni nɔɔ ɔ, adena i si kpɛrɛ bo ba nya i fite i ŋwaa bo i fa maari bu n nu. ");
INSERT INTO cko_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Na akɔɔ n bo i du mɔ baari n ase i ka, ‘M mibiɛ, u ŋwaa n bo a fa maari m ni, ma nya i ŋusu buru abuka su.’ ");
INSERT INTO cko_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Na i mibiɛ n ase i ka, ‘Nfan. Wɔrɔ akɔɔ kpa, kabo a kere ka a la dabuŋu niɛ deke kaan su ni, m má a niɛ miɛm buru su.’ ");
INSERT INTO cko_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Na akɔɔ n bo i tɔ su nnyɔ su n aba, na wɔ se ka, ‘M mibiɛ, u ŋwaa n bo a fa maari m ni, ma nya i ŋusu nnu abuka su.’ ");
INSERT INTO cko_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Na wɔ se nyini n gusu ka, ‘M má a niɛ miɛm nnu su.’ ");
INSERT INTO cko_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Na akɔɔm n kun be aba ase ka, ‘M mibiɛ, u ŋwaa n bo a fa maari m yaa, m fa pɔɔndiiri sanvuin nu fa seeri wɔ. ");
INSERT INTO cko_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","M soroori sɛrɛ wɔ, dama a ti u sɔnɔ faŋga­fɔ ɔ. A de deke bo i ti má u dɛɛ, na a kaaki kpiɛ deke bo a dɔ má i.’ ");
INSERT INTO cko_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Na wɔ se akɔɔ n ka, ‘Wɔrɔ akɔɔ tiɛ­fɔ ni, u nɔaniɛ n bo a jɔjɔ i n ye m fá yo u ŋgbɛɛn a. A ŋa a si tenle ka m ti m sɔnɔ faŋga­fɔ ɔ, na m de deke bo i ti má m dɛɛ, na m kaaki kpiɛ deke bo ma dɔ má i, má sɔ? ");
INSERT INTO cko_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Tɔ, ye nzu ti ye a fa má m ŋwaa n akɔ ase má baŋkifɔm dɔ a? Na má m ba kpieeri m nyi baari, má m nya kpɛrɛ buka su.’ ");
INSERT INTO cko_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Dɔ na wɔ se bo bu jina dɔ n kɛrɛ ka, ‘Am de ŋwaa n fite i dɔ, na am fa ma akɔɔ n bo wɔ nya m ŋwaa n ŋusu buru abuka su ni.’ ");
INSERT INTO cko_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ama, na ba se i ka, ‘Ya mibiɛ, ye yiri du mɔ la u ŋwaa n ŋusu buru e.’ ");
INSERT INTO cko_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Na wɔ se bu ka, ‘M suse am wɔ lɛɛ, ka, sɔnɔ kɛrɛ bo i la deke be, bu má i be buka su wɔ. Ama, sɔnɔ kɛrɛ bo i la má pui, haari ni nyini kaan n bo i la i ni, bu cín de i dɔ ɔ. ");
INSERT INTO cko_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ama, m ahin kpɔ­fɔm bɛrɛ yiri, má ba koro má ka m yo bu fɛmɛ, am fa bu ba jina m nyunu fɛn na am kun bu kɛrɛ.’” ");
INSERT INTO cko_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesu seeri sɔ wieeri ni, na wɔ du bu nyunu na bu kɔ Yɛrusalem miɛ kpiri n nu. ");
INSERT INTO cko_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","I ba dodoori miɛm bo bu fere bu ka Befage ni Betani, nyini miɛm ni dodo buka n bo bu fere i ka Oliva Buka n wɔ, dama oliva bakam gɔ su wɔ. Dɔ na wɔ sunma i susu­fɔm n nu nnyɔ, ");
INSERT INTO cko_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","na wɔ se bu ka, “Am kɔ miɛ kaan n bo i wo am nyunu dɔ ni, am kɔ ŋa am wura miɛ n nu, am ŋú ka kaako­baa be minda, be nya fun má i. Am nyaŋgi i bra fɛn. ");
INSERT INTO cko_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Nzɛn be bisaari am ka nzu ti ye am sunyaŋgi i a, am se i ka Mibiɛ ni koro i a.” ");
INSERT INTO cko_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Na bɛrɛ n bo i sunmaari bu n akɔ, akɔ aŋu kaako­baa n ka i minda kabo i seeri bu ni. ");
INSERT INTO cko_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Saŋga bo bu sunyaŋgi i ni, na i fɔm n abisa bu ka, “Nzu ti ye am sunyaŋgi kaako­baa n a?” ");
INSERT INTO cko_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Na ba bɔ bu nu ka, “Mibiɛ ni koro i a.” ");
INSERT INTO cko_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Na ba fa i aba Yesu dɔ, na minɛm n atɛrɛki bu suturam anana kaako­baa n ŋu, na ba buka Yesu na wɔ fun. ");
INSERT INTO cko_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","I fun tanaari su wieeri n na i wo kɔ su ni, na minɛm n afa bu suturam atɛrɛki ase atin n nu. ");
INSERT INTO cko_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Saŋga bo i ba dodoori Yɛrusalem miɛ kpiri n nu, fa kɔ awɔrɛ n bo i atin kaba cɔɔndi Oliva Buka n su ni, na i susu­fɔm beberebe sukansi Nyɛmɛ ni ahorejɔ, na bu subo kuyigindi, dama ba ŋu alekutura sakpa­kpam bo wɔ yo i n dɛɛ ti. ");
INSERT INTO cko_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Bu ŋa, “Tere­fiɛ wo fɛmɛ n dɔ, Yiri n bo i suba Micɛra n dɛɛ duma n nu ni. Ahoreda wo aŋgoro, na kansi wo Nyɛmɛ bo i wo aŋgoro n dɔ.” ");
INSERT INTO cko_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Dɔ na Farasi­fɔm nbem bo bu wo jama n nu n ase Yesu ka, “Ya Kere­fɔ, tiɛn u susu­fɔm n ŋu ka bu yaki naŋmiɛ.” ");
INSERT INTO cko_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Na wɔ se bu ka, “M suse am wɔ lɛɛ, ka, nzɛn má bɛrɛ yakiiri naŋmiɛ, má am ŋu ka yabuɛm bo bu da bɛrɛ n ayasu suyo naŋmiɛ.” ");
INSERT INTO cko_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Saŋga bo Yesu ba dodoori Yɛrusalem miɛ kpiri n na i ŋuuri i sɔ ni, na wɔ sun miɛ n dɛɛ ti, ");
INSERT INTO cko_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","na wɔ se ka, “Nzɛn má nyuma dɛɛ cɛɛn n nu am si sam bo bu fa ahoreda ba ni, má i ti má sɔ. Ama, kabo i ti ni, am koro ŋu má nyini sam ni. ");
INSERT INTO cko_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Saŋga ni suba bo am kpɔ­fɔm bá ta kanda bara yɛ am deke kɛrɛ na am kóro fite má nu. ");
INSERT INTO cko_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Bu kún am ni am nbaam, na bu fúfu am ahin miɛ n kɛrɛ pepere, haari yabuɛ kun n kpein mmɔɔ bá nana má i beŋgu su. Ahin n kɛrɛ bá yo sɔ, dama am asi má saŋga n bo Nyɛmɛ baari ka i ba de am tii ji ni.” ");
INSERT INTO cko_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Dɔ na Yesu akɔ awura Nyɛmɛ Seree­biri Awuru n nu, na wɔ bo i bu sufɔn yi wata­fɔm, ");
INSERT INTO cko_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","na wɔ se bu ka, “Ba kɛrɛ i Nyɛmɛ Jɔrɛ Kadasi n nu ka, Nyɛmɛ ŋa o, ‘M awuru ni, bu bá fere i ka awuru bo bu bá sere Nyɛmɛ nu.’ Ama, ambɛrɛ afa i ayo awiefɔm fiɛɛ­biri.” ");
INSERT INTO cko_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Cɛɛn n kɛrɛ cɛɛn, Yesu kere minɛm wɔ Nyɛmɛ Seree­biri Awuru n nu. Na Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ nkpiɛn­kpiɛnm, ni Nyɛmɛ nɔaniɛ kere­fɔm, ni Yuda­fɔm tere­tere­fɔm n akoro ka bu kun i, ");
INSERT INTO cko_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ama, ba koro anya má atin, dama minɛm n kɛrɛ koroori ka bu so bu sui wɔ, na bu ti i keree­wam ni. ");
INSERT INTO cko_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Cɛɛn be sɔ ɔ, Yesu wo Nyɛmɛ Seree­biri Awuru n nu sukere minɛm, na i sukan labari kpa n kere bu. I wo kere su n na Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ nkpiɛn­kpiɛnm, ni Nyɛmɛ nɔaniɛ kere­fɔm, ni Yuda­fɔm nkpiɛn­kpiɛnm aba i dɔ ");
INSERT INTO cko_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","aba ase i ka, “Ŋma dɛɛ yiko nu ye a yo nyini sam kɛrɛ a? Kan na ya ti. Ŋma ma u nyini yiko ni, ye a yo nyini sam n a?” ");
INSERT INTO cko_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Na wɔ bɔ bu nu ka, “Am ma m du mɔ bisa am bisaa­wa kun be ka. Kisa, ambɛrɛ kan na m ti, ");
INSERT INTO cko_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ŋma maari Yohane atin ye i ba biɛɛri minɛm Nyɛmɛ nzue n a? Nyɛmɛ nzɛn adamande?” ");
INSERT INTO cko_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Na ba bisa bu ŋuŋu nu kabo bu bɔ i nu barasu, bu ŋa, “Nzɛn ya seeri i ka Nyɛmɛ maari i atin a, i bísa ya ka, ye nzu ti ye ya da má Yohane ŋu a? ");
INSERT INTO cko_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ama, nzɛn ya seeri i ka adamande dɔ, minɛm kɛrɛ tú ya yabuɛ wɔ, dama bu kɛrɛ soroori su ka Yohane yo tiiri Nyɛmɛ nɔaniɛ kan­fɔ ɔ nahɔrɛ su.” ");
INSERT INTO cko_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Nyini ti, na ba bɔ i nu ka, “Ya si má sɔnɔ bo i maari i atin.” ");
INSERT INTO cko_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Na yiri gusu ase bu ka, “Mini mmɔɔ sé má am sɔnɔ bo i dɛɛ yiko nu na m yo ahin sam n kɛrɛ ni.” ");
INSERT INTO cko_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Dɔ na Yesu abo minɛm ahin miɛɛnu ni, i ŋa, “Sɔnɔ be yo woori bɛrɛ a, na wɔ dɔ i baka suu­wa barasu be fie. Na wɔ nya afa awura i npa­di­fɔm saa nu, na wɔ kɔ atin akɔ acɛ. ");
INSERT INTO cko_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Saŋga ba juuri bo i si ka baka suu­wam n abi ni, na wɔ sunma i akɔɔm kun i npa­di­fɔm n dɔ, ka i kɔ de i dɛɛ bo ba nya i n bra. Akɔɔ n kɔ juuri ni, na ba tara i abo i, na ba fɔn i akpie i nyi i saa ŋgbɛɛn. ");
INSERT INTO cko_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Na fie n fɔ n asunma i akɔɔ n kun bekun, na ba tara i abo i, na ba kpa i nyinyɛ, na ba ma wɔ kpie i nyi i saa ŋgbɛɛn. ");
INSERT INTO cko_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Kpe nsan su ni, na wɔ sunma akɔɔ nyiŋga, na ba tara i abo i, na ba ma i mandim, na ba fa i atu baka suu­wam fie n ahɛmɛ. ");
INSERT INTO cko_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Dɔ na fie n fɔ n ase ka, ‘Ye m yó sɛ wɔ lɛɛ kisa? M súnma m tiɛŋgu wa koroo­wa n wɔ, beni, bu má yiri jirima.’ ");
INSERT INTO cko_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ama, saŋga bo npa­di­fɔm n ŋuuri ka baa ni suba ni, na ba se bu ŋuŋu nu ka, ‘I wa n bo i dí i aja n lɛɛ suba n a. Am bra na ya kun i, adena aja n kɛrɛ ká ya dɛɛ.’ ");
INSERT INTO cko_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Dɔ na ba cin i atu baka suu­wam fie n ahɛmɛ, na ba kun i.” Na Yesu anya abisa bu ka, “Am sunsun ka fie n fɔ ni yó bu sɛ wɔ? ");
INSERT INTO cko_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","I bá kun nyini npa­di­fɔm n kɛrɛ wɔ, na i fá fie n wura minɛ fɔfɔrɛm saa nu.” Saŋga bo minɛm ni tiiri sɔ n na ba se ka, “Nyɛmɛ yo ya kisi ni nyini.” ");
INSERT INTO cko_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Na Yesu acɛ aniɛ bu dɔ na wɔ se bu ka, “Kabo ba kɛrɛ i Nyɛmɛ Jɔrɛ Kadasi n nu ni, am tiiri i bu sɛ wɔ? Bu ŋa, ‘Yabuɛ n bo bondo ta­fɔm n faari i tuuri ni, yiri ye wɔ kaaki bondo n jaa yabuɛm kɛrɛ tii a.’ ");
INSERT INTO cko_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Sɔnɔ kɛrɛ bo i kpaasiiri nyini yabuɛ n su, i mi búbu nu wɔ mumuku, na sɔnɔ kɛrɛ gusu bo nyini yabuɛ n tɔɔri i ŋu, i sán i mi samɛnɛ wɔ.” ");
INSERT INTO cko_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","I seeri sɔ ni, na Nyɛmɛ nɔaniɛ kere­fɔm ni, ni Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ nkpiɛn­kpiɛnm n akaba akpini atin kabo bu yo na bu tara i, dama bu faari nu ka miɛɛnu n bo i boori i ni, i bo niiri bɛrɛ wɔ, ama, bu soroori minɛm dɛɛ ti, na ba yaki i. ");
INSERT INTO cko_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Nyini ti, na Nyɛmɛ nɔaniɛ kere­fɔm ni, ni Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ nkpiɛn­kpiɛnm n akpini atin kabo bu yo na bu nya Yesu taraa­biri. Na ba bo minɛ nbem ajaa­kpiɛn ka bu yo bu ŋu ka bu ti minɛ kpam wɔ, na bu ba sɔ i ŋgɛɛ na bu bisa i nɔaniɛ nbem, adena bu koro fa i wura gomina yiko­fɔ n saa nu. ");
INSERT INTO cko_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Na nyini minɛm n ase Yesu ka, “Ya Kere­fɔ, ya si ka u nɔaniɛ jɔjɔɔ­wa ni u keree­wa kɛrɛ ti nahɔrɛ wɔ, na a tantambu má nu, ama, a kere minɛm wɔ nahɔrɛ su kabo Nyɛmɛ atin ti barasu. ");
INSERT INTO cko_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Tɔ, ya dɛɛ atin n su, atin wo nu ka ya tɔ lampo ma Roma­fɔm Fɛmɛ Kpiri Siza, nzɛn atin wo má nu?” ");
INSERT INTO cko_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ama, na wɔ fa nu ka bu koro ka bu kpiɛ i mbɛnlɛ wɔ, na wɔ se bu ka, ");
INSERT INTO cko_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Am fa ŋwaa bra na m niɛ.” Bu fa baari ni, na wɔ bisa bu ka, “Am niɛ ahin ŋwaa ni. Ŋma dɛɛ tii ni i duma wo su a?” Na ba bɔ i nu ka, “Fɛmɛ Siza dɛɛ a.” ");
INSERT INTO cko_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Na wɔ se bu ka, “Tɔ, deke bo i ti Fɛmɛ Siza dɛɛ, am fa ma Fɛmɛ Siza, na deke bo i ti Nyɛmɛ dɛɛ, am fa ma Nyɛmɛ.” ");
INSERT INTO cko_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Dɔ na ba ŋu ka bu koro nya má i taraa­biri minɛm nyunu bɛrɛ, ama, kabo i bɔɔri bu nu n dɛɛ ti, na ba miɛ, na ba tɔ amuna. ");
INSERT INTO cko_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Na Yuda­fɔm asɛsɛ barasu nbem bo bu fere bu ka Sadusi­fɔm ni, aba Yesu dɔ. Bu dɛɛ keree­wa la ka Nyɛmɛ téŋge má minɛm bu yiwee nu n a. Na ba ba abisa i jɔrɛ be, bu ŋa, ");
INSERT INTO cko_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Ya Kere­fɔ, Moyisi yo kɛrɛɛri nɔaniɛ be maari ya, ka nzɛn sɔnɔ wu yakiiri i yi na i ni bara n anya má baa, wɔ yo daka ka i niɛma n fa kuna­fɔ n na bu wu nbaam ma gɔrɔ n bo wɔ wu ni. ");
INSERT INTO cko_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Tɔ, sɔnɔ be yo laari nbaa­biɛsɔm nso a, na baa­kpiɛn n aja bara, na wɔ wu ayaki bara ni, ba nya má baa. ");
INSERT INTO cko_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Sɔ ye bo i tɔ i su nnyɔ su, ");
INSERT INTO cko_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ni nsan su n yoori a, haari fa kɔ kpuraari nso su ni, bu be mmɔɔ anya má baa ye bu wuuri a. ");
INSERT INTO cko_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Kasin na bara n gusu aba awu. ");
INSERT INTO cko_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Tɔ, kabo bu minɛ nso n kɛrɛ aja bara n na ba wu sɔ ni, cɛɛn n bo Nyɛmɛ bá teŋge minɛm bu yiwee n nu ni, bara ni ká ŋma dɛɛ wɔ?” ");
INSERT INTO cko_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Na Yesu abɔ bu nu ka, “Nbaram ni nbiɛsɔm bo bu wo bɛrɛ kisa ni ja ajaa, ");
INSERT INTO cko_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ama, nbaram ni nbiɛsɔm bo Nyɛmɛ aŋu ka bɛrɛ ti ye ni ka bu bá teŋge bu yiwee n nu fa kɔ fa ba ni, bɛrɛ ja má ajaa kun, ");
INSERT INTO cko_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","dama bu wu má kun. Bu wo bɛrɛ ka Nyɛmɛ mɛrɛkɛm wɔ. Bu ti Nyɛmɛ nbaam wɔ, dama ka ba teŋge bu yiwee n nu. ");
INSERT INTO cko_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Na fa kɔ kabo Nyɛmɛ bá teŋge minɛm bu yiwee n nu ni, Moyisi mmɔɔ yo kereeri ka i ti sɔ ɔ. Wɔ kɛrɛ i Nyɛmɛ Jɔrɛ Kadasi n nu, fa kɔ saŋga bo sin n jeeri buwe baka n su ni, ka, Micɛra ni ti Abraham, ni Izaki, ni Jakɔbu dɛɛ Nyɛmɛ a.” ");
INSERT INTO cko_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Na Yesu asa su ase bu ka, “Tɔ, kabo Micɛra n ti nyini minɛm dɛɛ Nyɛmɛ ni, nyini kere ka bu toko la ŋgɔɔ lɛɛ. Nyɛmɛ ti má bo ba wu n dɛɛ Nyɛmɛ, i ti bo bu la ŋgɔɔ ni dɛɛ Nyɛmɛ a, dama sɔnɔ kɛrɛ ŋgɔɔ fite yiri dɔ a.” ");
INSERT INTO cko_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Dɔ na Nyɛmɛ nɔaniɛ kere­fɔ nbem ayasu ase i ka, “Nfan. Ya Kere­fɔ, u bɔ nu n ti kpa.” ");
INSERT INTO cko_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Nyini sin, be abo má su ka i bisa i jɔrɛ bekun. ");
INSERT INTO cko_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Na Yesu ajɔjɔ minɛm dɔ fa kɔ Kristo Tii­de­fɔ n su, na wɔ bisa bu ka, “Ye nzu ti ye bu bita jɔjɔ ka Kristo n ti Fɛmɛ Davidi anuma a? ");
INSERT INTO cko_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Dama kabo ba kɛrɛ i Kansi Jue kɛrɛɛ­wam n nu ni, Fɛmɛ Davidi ni i tii ase ka, ‘Na Micɛra n ase m Mibiɛ n ka, “Ba tana m saa fɔmbɔrɔ su fɛn, ");
INSERT INTO cko_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","haari m bá ma u kpɔ­fɔm kɛrɛ ba kutu u jaa bu.”’ ");
INSERT INTO cko_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Tɔ, Fɛmɛ Davidi mmɔɔ fereeri Kristo n ka i Mibiɛ wɔ, ye Kristo n yo sɛ kaaki yo Fɛmɛ Davidi anuma a?” ");
INSERT INTO cko_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Saŋga bo minɛm n kɛrɛ jina wo i nɔaniɛ n ti su sɔ ni, na Yesu ase i susu­fɔm n ka, ");
INSERT INTO cko_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Am si am ŋu sa ni Nyɛmɛ nɔaniɛ kere­fɔm ni, deke bo bu koro i n la ka, bu wura sutura ŋgbiŋgbirim wɔ, na bu nati sujeŋgbe, na sɔnɔ kɛrɛ suyo bu ansɛ gɔɔsu. Nyini minɛm n anya awura bu tiɛntiɛn­bunɔɔ sɔɔm n nu ni, wara ba nya afere bu tiɛntiɛn­bunɔɔ bambaka diire dii­birim ni, bu koro ka bu tana kpirikoro tanaa­birim wɔ. ");
INSERT INTO cko_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Nyini minɛm n sɔ fin nkuna­fɔm neŋgem wɔ, na bu jina sere Nyɛmɛ cɛ, adena minɛm ŋu ka bu ti minɛ kpam wɔ. Jina cɛɛn, bɛrɛ bá nya sui­cin tara minɛm kɛrɛ.” ");
INSERT INTO cko_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Tɔ, na Yesu aniɛ aŋu kabo neŋge­fɔm suyi bu ŋwaa wura alaka bo minɛm yi saraka wura nu ni. ");
INSERT INTO cko_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Kuna­fɔ yaari­fɔ be gusu woori dɔ, na wɔ ba ayi ŋwaa kaan be bo i koro to má pui awura saraka n nu, na Yesu aŋu i. ");
INSERT INTO cko_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Dɔ na wɔ se ka, “Nahɔrɛ ye m suse am n a, nyini kuna­fɔ n ayi ŋwaa atara minɛm kɛrɛ. ");
INSERT INTO cko_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Dama neŋge­fɔm la ŋwaa beberebe n dɛɛ ti, ye ba yi be a. Ama, nyini kuna­fɔ n ni i yaari n kɛrɛ, i deke kɛrɛ bo i la i lɛɛ ye wɔ yi i n a.” ");
INSERT INTO cko_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Na Yesu susu­fɔ nbem ajɔjɔ fa kɔ Nyɛmɛ Seree­biri Awuru n su, kabo ba ta i ni yabuɛ ŋgbiŋgbirim ni aceerim bo bu fa ba ce Nyɛmɛ na i yo nyumi barasu ni. Bu wo jɔjɔ n su sɔ ni, na Yesu ase ka, ");
INSERT INTO cko_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Nyini dekem bo am ŋu bu ni, saŋga suba bo yabuɛ kun n kpein n mmɔɔ bá nana má i beŋgu su. Bu bá bereki i kɛrɛ gɔ ɔ lɛɛ.” ");
INSERT INTO cko_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Na Yesu susu­fɔm n abisa i ka, “Ya Kere­fɔ, saŋga bɔnɔ ye ahin sam kɛrɛ bá yo a? Ye nzu deke bá kere ya ka saŋga n adodo bo ahin sam n kɛrɛ bá yo a?” ");
INSERT INTO cko_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Na wɔ se bu ka, “Am si am ŋu sa, na má am ma be dadaka am. Dama minɛ dɔŋgu bá fa m duma ba, na bu sé ka, ‘Yiri la mini a.’ Na bu káaki se am ka, ‘Saŋga n aju lɛɛ.’ Ama, má am su bu su. ");
INSERT INTO cko_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Saŋga bo am bá ti aluwa ŋga fɛn, wara bu sukun luɛ dɔ, má am ma sɛrɛ ti am. Dama wɔ yo daka ka nyini sam n kɛrɛ bá yo sin ka, ama, i kere má ka durunya n awieeri lɛɛ.” ");
INSERT INTO cko_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Na wɔ kaaki ase bu ka, “Daanfiɛ daanfiɛ bá kun luɛ ni bu beŋgum, na nfɛmɛm kún luɛ ni bu beŋgu nfɛmɛm. ");
INSERT INTO cko_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Na asiɛn bá kpisi agaya, na ahɔɛ tɔ́, na alɔɔba tɔ́ awɔrɛ awɔrɛm nu, na ya bá ŋu anyumbaa ciire sa nbem ka bu sutiɛ fite aŋgoro n nu. ");
INSERT INTO cko_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ama, kana ahin sam kɛrɛ bá yo ni, bu tára am, na bu kére am wuwuruwa, na bu fá am wura yiko­fɔm saa nu, na bu dí am jɔrɛ bu tiɛntiɛn­bunɔɔ sɔɔm nu, na bu nyí am dan­saraka, na bu fá am wura nfɛmɛm ni gominam saa nu, na bu fá am jina bu nyunu, mini dɛɛ ti. ");
INSERT INTO cko_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ahin má am atin a, na am kóro kan labari kpa n kere bu. ");
INSERT INTO cko_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ama, am du mɔ yo am sunsunni nu na má am ma i miɛ am, kabo bu kɔ bisa am na am jɔjɔ barasu. ");
INSERT INTO cko_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Dama mini má am alecira nɔaniɛ bo am jɔ́jɔ a, na am kpɔ­fɔm be mmɔɔ kóro la má nɔaniɛ be bo bu kóro jɔjɔ bo am asi, wara bu fá ta am nyi. ");
INSERT INTO cko_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Haari am wu­fɔm, ni am ninbaam, ni am lamɔsim, ni am danfom mmɔɔ bá tɔ am ma nfaŋga­fɔm, na bu kún am nbem. ");
INSERT INTO cko_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Mini dɛɛ ti, sɔnɔ kɛrɛ kpɔ́ am. ");
INSERT INTO cko_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ama, am tii­ŋmiɛ kun n kpein mmɔɔ ká má ŋgbɛɛn. ");
INSERT INTO cko_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Nzɛn am mindi deeri nyini n kɛrɛ, am nyá ŋgɔɔ.” ");
INSERT INTO cko_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Na Yesu akaaki ase i susu­fɔm n ka, “Saŋga bo am bá ŋu ka sojam abara ayɛ Yɛrusalem miɛ kpiri n ni, am si tenle su ka i cɛ́ má, bu sáaki miɛ n kɛrɛ lɛɛ. ");
INSERT INTO cko_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Nyini saŋga ni, wɔrɔ kɛrɛ bo a tiiri i ŋga na a wo Yudiya asiɛn n su, ŋmati kɔ bukam n su. Wɔrɔ kɛrɛ bo a wo miɛ n nu, ŋmati fite nu. Na wɔrɔ kɛrɛ gusu bo a wo miɛ n ahɛmɛ, má a kpie u nyi kɔ miɛ n nu kun. ");
INSERT INTO cko_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Dama ahin sui­cin kekereke saŋga ni yó yii­wa, kabo ba kɛrɛ i Nyɛmɛ Jɔrɛ Kadasi n nu n kɛrɛ. ");
INSERT INTO cko_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Nyini saŋga ni yó kekereke agaya ma nyinsɛ­fɔm, ni nbaram bo bu nbaam toko nu ni. Dama minɛm n bo bu wo ahin asiɛn n su ni dí yaari agaya, na Nyɛmɛ cín bu sui. ");
INSERT INTO cko_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Na bu kún nbem luɛ nu, na bu tára nyiŋgam domuɛ, na bu fá bu kɔ asiɛn asiɛnm n kɛrɛ su, na minɛm bo bu ti má Yuda­fɔm ni sáaki miɛ n kɛrɛ haari fa kɔ ju saŋga bo bu yiko bá wie.” ");
INSERT INTO cko_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Na Yesu ase bu ka, “Na alekutura sam nyá ba tiɛ fite wiɛ n ni sara n, ni asara­mbaam kɛrɛ nu. Na durunya n nu fɛn, asiɛn asiɛnm n su­fɔm kɛrɛ ahore tánda, na sɛrɛ tí bu, fa kɔ kabo tieku nzue n bo barasu, na i yo naŋmiɛ agaya ni. ");
INSERT INTO cko_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Sam bo bu bá yo durunya n nu n dɛɛ ti, nyini má sɛrɛ ti minɛm na bu tɔ́ cin, dama aŋgoro n kɛrɛ kpísi wɔ. ");
INSERT INTO cko_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Na minɛm nyá ŋu ka mini Adamande Wa ni sufite aŋgoro yinyiŋgu n nu suje piɛpiɛu suba ni yiko bambaka. ");
INSERT INTO cko_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Saŋga bo nyini sam n kɛrɛ bá suyo ni, am yasu na am yɛ am tii su ni ahoresi, dama saŋga n adodo bo Nyɛmɛ bá de am tii lɛɛ.” ");
INSERT INTO cko_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Dɔ na Yesu abo ahin miɛɛnu n akere bu. I ŋa, “Am niɛ damba baka ni baka nyiŋgam kɛrɛ. ");
INSERT INTO cko_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Saŋga bo am nya ba ŋu ka bu sufiɛfiɛ nyawa fɔfɔrɛ ni, ambɛrɛ ni am tii si ka dɔdɔɔri saŋga adodo lɛɛ. ");
INSERT INTO cko_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Kabo Nyɛmɛ Fɛmɛ bá niɛ i minɛm su ni, i yó sɔ ɔ. Saŋga bo ambɛrɛ gusu bá ŋu ka nyini sam kɛrɛ suyo ni, am si tenle ka i cɛ́ má, Nyɛmɛ Fɛmɛ bá niɛ i minɛm su lɛɛ. ");
INSERT INTO cko_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Nahɔrɛ ye m suse am n a, bo bu la ŋgɔɔ kisa ni wú wie má ka, ye ahin sam kɛrɛ bá yo a. ");
INSERT INTO cko_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Aŋgoro n ni asiɛŋgu n kɛrɛ bá la awieeri, ama, m dɛɛ nɔaniɛ n yiri, i la má awieeri cɛɛn be.” ");
INSERT INTO cko_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Na Yesu ase i susu­fɔm n ka, “Am si am ŋu sa, na má am susaaki am saŋga sutiɛn am nɔɔ sunu nzan subo, na má am ma durunya n nu sa koroo­wa miɛ am, na má m ba ni fúra am nu ");
INSERT INTO cko_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","kabo toroku tara deke ni. Dama nyini cɛɛn bá fura minɛm bo bu wo durunya n nu wɔ. ");
INSERT INTO cko_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Má am fa am ŋu ji, am sere Nyɛmɛ saŋga kɛrɛ ka i ma am faŋga na am kóro fite nyini kekereke n kɛrɛ bo bu suba n nu, na am bá koro jina mini Adamande Wa n nyunu.” ");
INSERT INTO cko_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ale kɛrɛ bo i cin, Yesu kɔ Nyɛmɛ Seree­biri Awuru n nu wɔ, na i kɔ sukere minɛm, ale nya ba san, na i kɔ Oliva Buka n su. ");
INSERT INTO cko_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ale kɛrɛ bo i cin ŋgarama fuun, minɛm ni ba i dɔ Nyɛmɛ Seree­biri Awuru n nu wɔ, na bu ti i keree­wam ni. ");
INSERT INTO cko_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Saŋga n ba dodoori bo bu di bu cɛɛn­kpiri n bo bu di i ni kpɔnɔ bo bu gɔ má ayiri nu na i yasu ni. Yiri ye bu kaaki fere i ka Butara cɛɛn­kpiri n a. ");
INSERT INTO cko_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Na Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ nkpiɛn­kpiɛnm ni, ni Nyɛmɛ nɔaniɛ kere­fɔm ni, aniɛniɛ atin kabo bu yo barasu na bu kun Yesu, dama bu soroori minɛm ni ahore wɔ. ");
INSERT INTO cko_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Na Sitana awura Yudasi Isikariyoti ni, yiri ti Yesu susu­fɔ buru ni nnyɔm ni kun be a. ");
INSERT INTO cko_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Nyini ti, na wɔ kɔ asɛsɛ su ni Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ nkpiɛn­kpiɛnm ni, ni Nyɛmɛ Seree­biri Awuru n tintini­jina­fɔ nkpiɛnm ni, kabo i tɔ́ Yesu ma bu ni. ");
INSERT INTO cko_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Bu tiiri nyini n sɔ ni, na bu ahore ajɔ, na ba se ka bu má i ŋwaa. ");
INSERT INTO cko_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Na Yudasi asoro su, na wɔ kpini atin na i tɔ́ Yesu ma bu, saŋga bo jama wo má i dɔ ni. ");
INSERT INTO cko_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Na cɛɛn­kpiri cɛɛn n aju, cɛɛn n bo bu di kpɔnɔ bo bu gɔ má ayiri nu na i yasu ni. Nyini cɛɛn n ye wɔ yo daka ka bu kpiɛ nbɔmbaam kɔm n a, na bu fa teŋge Butara cɛɛn­kpiri n su. ");
INSERT INTO cko_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Na Yesu asunma Petoro ni Yohane, i ŋa, “Am kɔ sɛsɛ Butara cɛɛn­kpiri n diire n su na ya ba di.” ");
INSERT INTO cko_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Na ba bisa i ka, “A koro ka ya kɔ ni kɔ sɛsɛ diire n su a?” ");
INSERT INTO cko_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Na wɔ bɔ bu nu ka, “Am ti fɛn, am kɔ ŋa am wura miɛ n nu, am ni sɔnɔ be kába yɛ, i sɔ dundu ni nzue. Am su i su kɔ wura awuru n bo i kɔ wura nu ni. ");
INSERT INTO cko_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Na am bisa awuru­fɔ­biɛ n ka, ‘Ya Kere­fɔ n ŋa, sɔɔ bɔnɔ nu ye i ni i susu­fɔm ni dí Butara cɛɛn­kpiri diire n a?’ ");
INSERT INTO cko_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Na i kére am aŋgoro sɔɔ bambaka n bo ba yo i kɛrɛ dɔŋgu ni, dɔ ye am sɛsɛ diire n su se ya.” ");
INSERT INTO cko_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","I jɔjɔ wieeri ni, na ba kɔ aŋu deke n kɛrɛ sɔ kabo Yesu seeri bu ni, na ba sɛsɛ Butara cɛɛn­kpiri diire n su. ");
INSERT INTO cko_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Saŋga n ba juuri, na Yesu ni i jaramasam n aba atana ka bu di diire ni. ");
INSERT INTO cko_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Na wɔ se bu ka, “Kabo m koroori lɛɛ, m boroori m nyi wɔ ka m ni ambɛrɛ saŋga di ahin Butara cɛɛn­kpiri diire n ka, na m nyá di m wahara ni. ");
INSERT INTO cko_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Dama m suse am wɔ lɛɛ, ka, m dí má ahin diire n kun, má ka i bá yo yii­wa Nyɛmɛ fɛmɛya n nu.” ");
INSERT INTO cko_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Dɔ na wɔ fa awa ni nzan, na wɔ da Nyɛmɛ asi, na wɔ se bu ka, “Am de na am nu, na am fa ma am beŋgu. ");
INSERT INTO cko_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","M suse am wɔ lɛɛ, ka, m nú má ahin nzan n kun, má ka cɛɛn n bo Nyɛmɛ Fɛmɛ bá niɛ i minɛm su.” ");
INSERT INTO cko_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Na Yesu akaaki afa kpɔnɔ, na wɔ da Nyɛmɛ asi, na wɔ bubu i nu, na wɔ fa ama bu, na wɔ se bu ka, “Ahin kpɔnɔ n ti m ŋuniɛ­mbaa lɛɛ, ye m sufa ma am n a. Am yo ahin sɔ adena am fa teŋge m su.” ");
INSERT INTO cko_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Bu diiri diire n wieeri ni, na wɔ kaaki afa awa ni nzan ni, na wɔ yo sɔ, na wɔ se bu ka, “Ahin nzan n ti sɛsɛ­su fɔfɔrɛ n bo Nyɛmɛ sufa m mbunja n sudi i di n a. Ambɛrɛ dɛɛ ti ye m mbunja ni soŋgi gɔ a. ");
INSERT INTO cko_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ama, am niɛ. Sɔnɔ n bo i tɔ́ m ni wo diire n dii­biri fɛn, m ni yiri susaŋga di diire n a. ");
INSERT INTO cko_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Mini Adamande Wa ni wú kabo Nyɛmɛ adu mɔ acici ka m wú n wɔ, ama, sɔnɔ n bo i tɔ m ni, i mi bá ŋu anyum­boro.” ");
INSERT INTO cko_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Dɔ na ba bisa bu ŋuŋu nu ka, “Ye ya nu ŋma koro yo ahin sa n a?” ");
INSERT INTO cko_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Na Yesu jaramasam n ase akuruwa bu ŋuŋu nu fa kɔ sɔnɔ bo i tara bu kɛrɛ bu nu. ");
INSERT INTO cko_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Na Yesu ase bu ka, “Minɛm bo bu su má Nyɛmɛ n dɛɛ nfɛmɛm, bɛrɛ miɛ bu minɛm a, na bɛrɛ bo bu la yiko minɛm ŋu ni, bu fere bu ka buka­fɔm. ");
INSERT INTO cko_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ama, má ambɛrɛ yo sɔ. Sɔnɔ bo i tara am kɛrɛ am nu ni, i ti ye ni ka i mi yo i ŋu kaan, na bo i ti am mɔ­fɔ n gusu, i ti ye ni ka i mi yo i ŋu kaan na i su am. ");
INSERT INTO cko_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Sɔnɔ bo i tana di diire ni, ni bo i su amusui ni, ŋma tara i beŋgu a? Yiri la bo i tana di ni, má sɔ ɔ? Ama, mini wo am nu ka sɔnɔ bo i su amusui wɔ. ");
INSERT INTO cko_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Saŋga kɛrɛ bo m woori kekereke nu, ambɛrɛ jinaari m sin a. ");
INSERT INTO cko_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Kabo m Si Nyɛmɛ ama m atin ka m di fɛmɛya ni, sɔ ye mini gusu fá ma am a, ");
INSERT INTO cko_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","na am dí na am nú m fɛmɛya n nu, na am tána fɛmɛya biɛm su, na am níɛ Yisareli­fɔm anɔ buru ni nnyɔm n su.” ");
INSERT INTO cko_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Na Yesu ase Simon ka, “Simon, ti fɛn. Sitana asere atin ka i kpaja am kabo bu kpaja ŋgani n wɔ. ");
INSERT INTO cko_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ama, ma sere Nyɛmɛ ama u na má a yaki m yarada­yo. Na saŋga bo a ba kaaki ba suuri m su bekun ni, buka u ninbaam ni, na bu nya ahoresi.” ");
INSERT INTO cko_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Na wɔ se i ka, “M Mibiɛ, m ŋmáti yaki má u da, ŋka bu sáŋga nyi wɔrɔ ni mini kɛrɛ wɔ, na ya sáŋga wu.” ");
INSERT INTO cko_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Na Yesu ase i ka, “Petoro, m suse u wɔ lɛɛ ka, nyuma, kana akɔnyuma bá bo, a kéte kpe nsan su ka a si má m.” ");
INSERT INTO cko_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Na Yesu abisa i susu­fɔm n ka, “Saŋga bo m sunmaari am na am abita má ŋwaa kuruku, wara kuruku, wara gbagbaa ni, nzu kpiɛɛri am su a?” Na ba bɔ i nu ka, “Pui akpiɛ má ya su.” ");
INSERT INTO cko_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Na wɔ se bu ka, “Ama, kisa, wɔrɔ kɛrɛ bo a la ŋwaa kuruku, wara kuruku, fa i, na wɔrɔ kɛrɛ bo a la má takobe, tɔ u tanlɛɛ na a fa ŋwaa n to be. ");
INSERT INTO cko_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Dama ba kɛrɛ i Nyɛmɛ Jɔrɛ Kadasi n nu ka, ‘Bu faari m buuri satiɛ­yo­fɔm kun wɔ.’ M suse am wɔ lɛɛ, ka, wɔ yo daka ka, mini dɛɛ ti, na i yo yii­wa. Nahɔrɛ, deke n bo bu kɛrɛ niiri mini ni, i suyo yii­wa.” ");
INSERT INTO cko_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Na ba se i ka, “Ya Mibiɛ, niɛ. Takobe nnyɔ yaa fɛn.” Na wɔ se bu ka, “Wɔ sɛ su.” ");
INSERT INTO cko_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Na Yesu afite miɛ n nu, na wɔ kɔ Oliva Buka n su, kabo i nati yo ni, na i susu­fɔm n asu i su. ");
INSERT INTO cko_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Saŋga bo i kɔ juuri dɔ ni, na wɔ se i susu­fɔm n ka, “Am sere Nyɛmɛ, adena má deke be yo am na am wura satiɛ nu.” ");
INSERT INTO cko_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Dɔ na wɔ yaki bu, na wɔ kɔ mɔ kaan, na wɔ kutu asere Nyɛmɛ. ");
INSERT INTO cko_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","I ŋa, “M Si Nyɛmɛ, nzɛn i ti u koroya­nu, yi m fite ahin anyum­boro n bo i suba m dɔ n nu. Haari ni nyini mmɔɔ, má a yo kabo m koro ni, ama, se kabo a koro ni.” ");
INSERT INTO cko_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Na Nyɛmɛ mɛrɛkɛ be atiɛ afite aŋgoro aba asi i ahore. ");
INSERT INTO cko_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ahoretanda n bo i tuuri i n dɛɛ ti, na wɔ sere Nyɛmɛ ni anyum­boro abuka su, na i aŋuye sukpinkpin asiɛŋgu ka mbunja dɛɛ su. ");
INSERT INTO cko_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","I sereeri Nyɛmɛ n wieeri ni, na wɔ yasu akpie i nyi akɔ i susu­fɔm n dɔ, i kɔ ŋuuri ka bu wo daafiri su, dama bu ahore asaaki agaya n dɛɛ ti. ");
INSERT INTO cko_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Na wɔ se bu ka, “Nzu ti ye am da daafi a? Am yasu jina na am sere Nyɛmɛ, adena má deke be yo am na am wura satiɛ nu.” ");
INSERT INTO cko_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Na saŋga bo i toko wo jɔjɔɔri n su ni, na jama be aba aju. Yudasi bo i ti i susu­fɔ buru ni nnyɔm nu kun ni, duuri bu mɔ a, na wɔ kɔ Yesu dɔ ka i kɔ biti i, ");
INSERT INTO cko_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","ama, na Yesu abisa i ka, “Yudasi, a biti m ye a ma bu nya mini Adamande Wa n taraa­biri a?” ");
INSERT INTO cko_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Saŋga bo i susu­fɔm bo bu wo i dɔ n ŋuuri sa n bo i suba ni, na ba bisa i ka, “Ya Mibiɛ, ya kpiɛ bu takobe, nzɛn sɛ?” ");
INSERT INTO cko_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Na bu nu kun akpiɛ ayi sɔnɔ be sui, i saa fɔmbɔrɔ dɛɛ ni, nyini sɔnɔ n ti Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ n kɛrɛ kpiɛn n akɔɔ ɔ. ");
INSERT INTO cko_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ama, na Yesu atiɛn i susu­fɔm n ŋu ka, “Má am yo sɔ kun.” Na wɔ fa i saa akan sɔnɔ n sui ni, na wɔ nya laifiɛ. ");
INSERT INTO cko_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Dɔ na Yesu ase Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ nkpiɛn­kpiɛnm ni, ni tintini­jina­fɔ nkpiɛn­kpiɛnm ni, ni Yuda­fɔm nkpiɛn­kpiɛnm kɛrɛ bo bu baari ka bu ba tara i n ka, “M ti awiefɔ ɔ, ye am fa takobem ni kɔrɔmam na am ba tara m a? ");
INSERT INTO cko_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Cɛɛn n kɛrɛ cɛɛn m ni ambɛrɛ wo Nyɛmɛ Seree­biri Awuru n nu a, am atara má m. Ama, kisa ti saŋga bo Nyɛmɛ ama atin, na am ni Sitana bo i wo awosin nu n kere am yiko a.” ");
INSERT INTO cko_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Na ba tara Yesu afa i akɔ awura Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm n kɛrɛ kpiɛn n dika, na Petoro asu bu su, ama, i woori dede kaan ni bɛrɛ wɔ. ");
INSERT INTO cko_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Minɛ nbem atɔrɔ sin gisan n afiɛn, atana abara ayɛ i, na Petoro akɔ abuka bu su. ");
INSERT INTO cko_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","I tanaari na sin wein n gɔɔri i ŋu ni, na afani be aŋu i. Na wɔ niɛ i nyunu dika gbirim, na wɔ se bu ka, “Ahin sɔnɔ ni mmɔɔ ti i susu­fɔ ɔ.” ");
INSERT INTO cko_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ama, na wɔ kete, i ŋa, “Bara, m si má i.” ");
INSERT INTO cko_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Nyini sin, wɔ cɛ má, na sɔnɔ be gusu aba aŋu i, na wɔ se i ka, “Wɔrɔ mmɔɔ ti bu kun wɔ.” Ama, na wɔ se i ka, “Wɔrɔ, m ti má bu kun.” ");
INSERT INTO cko_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Na fa kɔ saŋga su bekun, na sɔnɔ kun be ajina su kekereke ase ka, “Nahɔrɛ, ahin sɔnɔ n ti bu kun wɔ, dama yiri gusu ti Galili­fɔ ɔ.” ");
INSERT INTO cko_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ama, na wɔ se i ka, “Wɔrɔ, m si má ahin jɔrɛ n bo a sujɔjɔ i ni mmɔɔ.” Saŋga bo i toko wo jɔjɔɔri n su ni, na akɔnyuma akaba abo. ");
INSERT INTO cko_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Na Mibiɛ Yesu n acɛ aniɛ Petoro nyunu, na wɔ teŋge su kabo Mibiɛ n seeri i ni, i ŋa, “Nyuma, kana akɔnyuma bá bo, a kéte kpe nsan su ka a si má m.” ");
INSERT INTO cko_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Na wɔ fite akɔ asun agaya. ");
INSERT INTO cko_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Na minɛm bo bu bita Yesu ni, ayo i anzasi, na ba bo i. ");
INSERT INTO cko_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Na ba fa sanvuin acin akata i nyu­mbaa, na ba bisa i ka, “Wɔrɔ Nyɛmɛ nɔaniɛ kan­fɔ ni, ŋma bo u a? Kan kere ya.” ");
INSERT INTO cko_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Na ba kpiɛ i nzukɔ barasu barasu n kɛrɛ. ");
INSERT INTO cko_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Na ale acin, na Yuda­fɔm tere­tere­fɔm atiɛn bu nɔɔ, Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ nkpiɛn­kpiɛnm ni, ni Nyɛmɛ nɔaniɛ kere­fɔm n gusu buka su, na ba fa Yesu aba bu tiɛntiɛn­bunɔɔ n nu. ");
INSERT INTO cko_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Na ba se i ka, “Nzɛn a ti Kristo Tii­de­fɔ n a, se ya.” Na wɔ se bu ka, “Nzɛn m seeri am ka yiri la mini, am dé má, ");
INSERT INTO cko_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","na nzɛn m bisaari am bisaa­wa, am bɔ́ má m nu. ");
INSERT INTO cko_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ama, fite kisa fa kɔ, mini Adamande Wa ni bá tana Nyɛmɛ Yiko­fɔ n saa fɔmbɔrɔ su wɔ.” ");
INSERT INTO cko_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Dɔ na bu kɛrɛ abisa i ka, “Ŋka wɔrɔ ti Nyɛmɛ Wa n a?” Na wɔ bɔ bu nu ka, “Kabo am jɔjɔɔri ni, i ti sɔ ɔ.” ");
INSERT INTO cko_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Na ba se ka, “Ya koro má daani­fɔ be kun. Yɛrɛ mmɔɔ ni ya tii ati kabo wɔ se ni.” ");
INSERT INTO cko_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Na bu tere­tere­fɔm n kɛrɛ bo ba tiɛn bu nɔɔ n ayasu, na ba fa Yesu akɔ ama Gomina Pilato. ");
INSERT INTO cko_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Na ba bo i bu sujaraki i, bu ŋa, “Ya kɔ aŋu ka ahin sɔnɔ ni sudaka ya minɛm ka bu kete gomina ni, na má bu tɔ lampo kaari ma Fɛmɛ Kpiri Siza, i ŋa ka yiri ni i tii ti Kristo Tii­de­fɔ n a, nyini la ka i ti fɛmɛ wɔ lɛɛ.” ");
INSERT INTO cko_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Na Gomina Pilato abisa i ka, “Wɔrɔ ti Yuda­fɔm fɛmɛ n a?” Na wɔ bɔ i nu ka, “Kabo a jɔjɔ ni, i ti sɔ ɔ.” ");
INSERT INTO cko_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Dɔ na Gomina Pilato ase Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ nkpiɛn­kpiɛnm ni, ni jama n kɛrɛ ka, “Ma ŋu má ŋgasi bo ahin sɔnɔ n ado i.” ");
INSERT INTO cko_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ama, na ba jina kun su, na ba jaraki i, bu ŋa, “I keree­wa n ama Yudiya awɔrɛ n nu minɛm kɛrɛ ahore ayasu. I boori i bu Galili awɔrɛ n nu wɔ, ye kisa wɔ fa aba fɛn n a.” ");
INSERT INTO cko_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Gomina Pilato tiiri sɔ ni, na wɔ bisa ka, “Sɔnɔ n ti Galili­fɔ ɔ?” ");
INSERT INTO cko_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","I tiiri ka i fite dɔ ni, na wɔ ma ba fa i akɔ Fɛmɛ Herode dɔ, dama yiri yo niɛ nyini awɔrɛ n su a. Nyini saŋga ni, Fɛmɛ Herode gusu woori Yɛrusalem miɛ kpiri n nu. ");
INSERT INTO cko_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Fɛmɛ Herode ŋuuri Yesu ni, na wɔ yo i fiɛ akɔ asin su, dama wɔ ti i ŋga acɛ, na wɔ koro ka i ŋu i na i yo alekutura sa nbem na i niɛ. ");
INSERT INTO cko_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Nyini ti, na wɔ bisa Yesu bisaa­wam beberebe, ama, wɔ bɔ má i nu. ");
INSERT INTO cko_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Na Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ nkpiɛn­kpiɛnm ni, ni Nyɛmɛ nɔaniɛ kere­fɔm n afite ajina sujaraki i ni anyum­boro su. ");
INSERT INTO cko_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Na Fɛmɛ Herode ni i sojam n ayo Yesu anzasi, na ba bu i ŋgbɛɛn, na ba fa tanlɛɛ nyunyumi awura i, na ba fa i akpie i nyi akɔ Gomina Pilato dɔ. ");
INSERT INTO cko_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Nyini saŋga ni, Fɛmɛ Herode ni Gomina Pilato yo kpɔ bu beŋgu wɔ, ama, nyini cɛɛn n gbingbin na ba kaaki danfom. ");
INSERT INTO cko_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Na Gomina Pilato afere Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ nkpiɛn­kpiɛnm ni, ni Yuda­fɔm tere­tere­fɔm ni, ni minɛm ni, ");
INSERT INTO cko_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","na wɔ se bu ka, “Am faari ahin sɔnɔ n baari m dɔ, na am ase ka i sukere minɛm na bu kete gomina n wɔ. Mini ni m tii aniɛ jɔrɛ n nu am nyunu fɛn, ama, ma ŋu má ŋgasi bo wɔ do i. ");
INSERT INTO cko_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Fɛmɛ Herode mmɔɔ ni i tii aŋu má i ŋgasi be, nyini dɛɛ ti ye wɔ kaaki i aba ama ya n a. Nahɔrɛ, ahin sɔnɔ n ado má ŋgasi be bo bu kun i. ");
INSERT INTO cko_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Nyini ti, m má bu fin i ŋgbere na m yáki i na i kɔ.”  ");
INSERT INTO cko_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Afɔ kɛrɛ afɔ, Butara cɛɛn­kpiri n nya ba juuri ni, wɔ yo daka ka Gomina Pilato yi dan­saraka n kun ji. ");
INSERT INTO cko_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ama, na jama n kɛrɛ atiɛn kungere­kun ase ka, “Yi ahin sɔnɔ ni ŋgɔɔ, na a yi Barabasi ma ya.” ");
INSERT INTO cko_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Yiri Barabasi ni i beŋgu ketema­fɔ nbem yo kpiɛɛri jɔrɛ, Yɛrusalem miɛ kpiri n nu, na ba di aluwa na ba kun minɛ. Nyini ti ye bu taraari i dan­saraka n a. ");
INSERT INTO cko_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Gomina Pilato koroori ka i yaki Yesu nu ji n dɛɛ ti, na wɔ kaaki ajɔjɔ jama n dɔ bekun. ");
INSERT INTO cko_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ama, na bu sutiɛntiɛn suse ka, “Kpama i baka jaanu n su na i wu. Kpama i.” ");
INSERT INTO cko_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Na wɔ kaaki ase bu kpe nsan su ka, “Ye nzu satiɛ ye wɔ yo i a? Mini aŋu má satiɛ be bo wɔ yo i na bu kun i. M má bu fin i ŋgbere wɔ, na m yáki i na i kɔ.” ");
INSERT INTO cko_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ama, na ba kaaki atiɛn kpa amiɛ i ka i kpama Yesu baka jaanu n su. Na bu naŋmiɛ yoo­wa agaya n akunma Gomina Pilato. ");
INSERT INTO cko_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Na wɔ ma nɔɔ ka bu yo Yesu kabo minɛm koro ni. ");
INSERT INTO cko_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Na wɔ yi sɔnɔ n bo minɛm n koroori i n aji, yiri bo i kpiniiri jɔrɛ na i kuunri minɛm na bu nyiiri i dan­saraka ni. Ama, Yesu yiri, na wɔ ma bu nɔɔ ka bu kun i, kabo Yuda­fɔm koro ni. ");
INSERT INTO cko_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Na sojam n afa Yesu afite, na saŋga bo bu wo kɔ su ni, na bu ni biɛ be ayɛ, bu fere i ka Simon, i ti Sirenefɔ ɔ. I fite ahɛmɛ suba miɛ kunnu, na sojam n amiɛ i ka i sɔ baka jaanu n su Yesu su. ");
INSERT INTO cko_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Na jama beberebe asu i su, bu nbem ti nbaram wɔ, na bu susun, na bu sukoko, i dɛɛ ti. ");
INSERT INTO cko_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Na Yesu acɛ aniɛ bu, na wɔ se bu ka, “Yɛrusalem nbaram, má am sun mini dɛɛ ti, ama, am sun ambɛrɛ ni am nbaam dɛɛ ti. ");
INSERT INTO cko_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Am ti fɛn, saŋga ni suba bo minɛm bá se ka, ‘Tere­fiɛ wo ŋɔrɔkam n dɔ, ni bo bu nya wu má nbaam ni, ni bo nbaam nya nu má bu nyufini ni.’ ");
INSERT INTO cko_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Nyini saŋga n ye minɛm sé ka, ‘Nzɛn má bukam bereki gɔ ya ŋu, na kpɛrɛm kata ya ŋu, má i ti ye.’ ");
INSERT INTO cko_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Nzɛn bu faari baka mɔnɛ wuraari sin nu na i jeeri, ye baka wuruu­wa yiri yó sɛ wɔ lɛɛ?” ");
INSERT INTO cko_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Na ba fa satiɛ­yo­fɔ nnyɔ nbem gusu akɔ ka bu kɔ kun bu ni Yesu kɛrɛ. ");
INSERT INTO cko_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Saŋga bo bu kɔ juuri dika be bo bu fere i ka Tere­awa woo­biri ni, na ba kpama Yesu baka jaanu n su, na ba yɛ i su ajina. Na ba kpama satiɛ­yo­fɔ nnyɔ nbem baka jaanu n su adodo i, bu kpamaari kun i saa fɔmbɔrɔ su wɔ, na ba kpama kun n gusu i saa biɛ su. ");
INSERT INTO cko_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Na Yesu ase ka, “M Si Nyɛmɛ, fa bu satiɛ ce bu, dama bu si má sa n bo bu suyo i ni.” Na ba tu mbaa na bu si kabo bu kpaaki i suturam nu. ");
INSERT INTO cko_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Na minɛm n ajina dɔ suniɛ i, na Yuda­fɔm tere­tere­fɔm mmɔɔ ayo i anzasi. Bu ŋa, “I ŋa i koro de minɛm tii ji. Nzɛn yiri ti Kristo Tii­de­fɔ n bo Nyɛmɛ ayi i ni, ma i de i ŋu tii ji.” ");
INSERT INTO cko_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Na sojam n gusu ayo i anzasi, na ba fa nzan gagaraki be ama i ka i nu, ");
INSERT INTO cko_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","na ba se ka, “Nzɛn wɔrɔ ti Yuda­fɔm Fɛmɛ n a, de u tii ji.” ");
INSERT INTO cko_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Na ba kɛrɛ kɛrɛɛ­wa be abo akpama i baka jaanu n tii su, kɛrɛɛ­wa n la ka, “Yuda­fɔm Fɛmɛ n lɛɛ.” ");
INSERT INTO cko_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Na satiɛ­yo­fɔ nnyɔm bo bu saŋga kpamaari bu ni Yesu ni, bu nu kun atɔ i ŋu ni nzukɔ, i ŋa, “Má wɔrɔ ti Kristo Tii­de­fɔ n a? De u tii ji na a de yɛrɛ gusu ji.” ");
INSERT INTO cko_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ama, na nyiŋga n ajaraki i, i ŋa, “A soro má Nyɛmɛ wɔ? M ŋa ya dɛɛ sui­cin ni i dɛɛ n kɛrɛ ti kun wɔ. ");
INSERT INTO cko_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ya dɛɛ sui­cin n yiri, i ti deke bo ya de i wɔ, dama kabo i ti ye ni ka bu yo ya lɛɛ, ama, yiri ado má ŋgasi be.” ");
INSERT INTO cko_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Na wɔ kaaki ase ka, “Yesu, a ba baari ni u fɛmɛya ni, teŋge m su.” ");
INSERT INTO cko_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Na Yesu ase i ka, “Nahɔrɛ ye m suse u n a, nyuma dɛɛ cɛɛn n nu, a bá wo m dɔ alezanda nu.” ");
INSERT INTO cko_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Na fa kɔ wiɛsu kerefi buru ni nnyɔ saŋga, wiɛ n afite má na awosin akata asiɛn n kɛrɛ su haari naasɔ kerefi nsan, na tani bambaka n bo bu fa kanda kpaakiiri Sɔɔ Casi n bo i wo Nyɛmɛ Seree­biri Awuru n nu n ati nu nnyɔ, i afiɛn. ");
INSERT INTO cko_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Na Yesu abo awie kpa, i ŋa, “M Si Nyɛmɛ, ma fa m ŋu awura u saa nu.” I seeri sɔ wieeri n na wɔ yo Nyɛmɛ dɛɛ. ");
INSERT INTO cko_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Saŋga bo soja kpiɛn ŋuuri sa n bo wɔ yo sɔ ni, na wɔ kansi Nyɛmɛ, na wɔ se ka, “Nahɔrɛ su, ahin sɔnɔ n tiiri sɔnɔ fofoe wɔ.” ");
INSERT INTO cko_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Na minɛm kɛrɛ bo ba tiɛn bu nɔɔ jina wo i niɛ su ni, saŋga bo bu ŋuuri sa n bo wɔ yo n sɔ ni, na bu kɛrɛ afa bu saa ataka i beŋgu nu, na ba kpie bu nyi akɔ awuru. ");
INSERT INTO cko_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Na Yesu danfom n kɛrɛ, ni nbaram bo bu suuri i su fiteeri Galili awɔrɛ n nu ni, ajina dede kaan suniɛ sam n kɛrɛ bo bu yoori ni. ");
INSERT INTO cko_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Sɔnɔ be woori bɛrɛ, bu fere i ka Yosefu, i ti Yuda­fɔm tere­tere­fɔm nu kun wɔ, na i ti sɔnɔ kpa, na i yo sa bo i kɔ atin su Nyɛmɛ dɔ. ");
INSERT INTO cko_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Wɔ soro má su ni sunsunni n bo i beŋgum faari i na bu yoori Yesu barasu ni. I fite miɛ kpiri n bo bu fere i ka Aramatiya na i wo Yudiya awɔrɛ nu n wɔ, na i dɛɛ la ka, i ŋminda wɔ, fa kɔ saŋga bo Nyɛmɛ Fɛmɛ bá niɛ i minɛm su. ");
INSERT INTO cko_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Na wɔ kɔ Gomina Pilato dɔ, na wɔ kɔ asere i ka i fa Yesu ŋuniɛ n ma i. ");
INSERT INTO cko_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Na wɔ kɔ ayi fuin ni baka jaanu n su, na wɔ fa nzee n apɔɔndi i. Na wɔ kɔ afa i awura yabuɛ buɛ bo ba lokoti i ayo i faŋ­kunma n nu na ba nya ase má sɔnɔ be nu ni, na wɔ fa i ase nu. ");
INSERT INTO cko_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Nyini cɛɛn n tiiri Ŋumi­yi cɛɛn n kpokpo cɛɛn wɔ, i naasɔ, wɔ ka kaan na bu di Ŋumi­yi cɛɛn ni. ");
INSERT INTO cko_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Nbaram bo bu suuri Yesu su fiteeri Galili awɔrɛ n nu ni, bɛrɛ suuri Yosefu su, na ba kɔ aŋu yabuɛ buɛ faŋ­kunma ni, ni kabo bu seeri fuin n barasu. ");
INSERT INTO cko_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Na ba kpie bu nyi akɔ awuru ka bu kɔ kpa bu ŋu ni ŋguin nva­nvanim ni tulaalɛɛm. Na alecin Ŋumi­yi cɛɛn ni, na ba yi bu ŋumi kabo Nyɛmɛ maari Moyisi nɔɔ ka bu yo ni. ");
INSERT INTO cko_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Na alecin, Yuda­fɔm bakuɛ n bumboori, mɔnɛ cɛɛn ŋgarama fuun, na nbaram n afa tulaalɛɛ nva­nvani bo ba kpini ase ni, na ba fa akɔ yabuɛ buɛ faŋ­kunma n su. ");
INSERT INTO cko_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Bu kɔ juuri dɔ n na ba ŋu ka yabuɛ bambaka n akundu ayaki faŋ­kunma n anɔ ni. ");
INSERT INTO cko_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ama, bu wuraari faŋ­kunma n nu ni, ba ŋu má Mibiɛ Yesu ŋuniɛ ni, ");
INSERT INTO cko_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","na ba miɛ aka ajina gbirim, kpeŋga na ba ŋu ka nbiɛsɔm nnyɔ jina, bu wura sutura fofoe papasi. ");
INSERT INTO cko_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Na sɛrɛ ati nbaram n agaya, na ba biri bu tii haari asiɛŋgu, na minɛm n abisa bu ka, “Nzu ti ye am suniɛniɛ fuinm nu na am ŋu sɔnɔ bo i la ŋgɔɔ a? ");
INSERT INTO cko_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","I wo má fɛn. Wɔ teŋge i yiwee n nu. Am teŋge su kabo i yo seeri am ni, saŋga bo i yo wo Galili awɔrɛ n nu ni, ");
INSERT INTO cko_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","i ŋa, ‘Wɔ yo daka ka bu bá fa mini Adamande Wa n wura satiɛ­yo­fɔm saa nu, na bu kpáma m baka jaanu n su, ama, na le­san cɛɛn na m téŋge m yiwee n nu.’” ");
INSERT INTO cko_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Dɔ na ba teŋge Yesu nɔaniɛ bo i yo seeri bu n su, ");
INSERT INTO cko_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","na ba fite faŋ­kunma n nu, na ba kpie bu nyi akɔ akan sam n kɛrɛ bo ba ŋu i ni, akere i susu­fɔ buru ni kunm ni, ni nyiŋgam kɛrɛ. ");
INSERT INTO cko_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Nbaram ni la Mariya bo i fite Magadala miɛ n nu ni, ni Yowana, ni Yakobo dɛɛ ni Mariya, ni bu beŋgu nbara nbem, bɛrɛ kaanri nyini sam n kɛrɛ kereeri i jaramasam n a. ");
INSERT INTO cko_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ama, bu tiiri jɔrɛ n bo nbaram kan kereeri bu ni, bu sunsuunri ka i ti jɔrɛ ŋgbɛɛn wɔ, ba yo má yarada. ");
INSERT INTO cko_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ama, na Petoro ayasu aŋmati akɔ faŋ­kunma n nu, i kɔ juuri n na wɔ kasi aniɛ faŋ­kunma n nu, wɔ ŋu má pui, má ka nzee n ŋgumi da. Na wɔ kpie i nyi aba awuru, na wɔ birisi fa kɔ sa n bo wɔ yo n su. ");
INSERT INTO cko_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Nyini cɛɛn ni, na Yesu susu­fɔ nnyɔ nbem sukɔ miɛ kaan be bo bu fere i ka Ɛmɔsi n su, i ni Yɛrusalem miɛ kpiri n waari má agaya. ");
INSERT INTO cko_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Bu wo kɔ su ni, na bu subo anzama fa kɔ sa n kɛrɛ bo wɔ yo n su. ");
INSERT INTO cko_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Bu nati wo nyini anzama n bo su ni akuruwa ni, na Yesu ni i tii aba atu bu atin nu, ");
INSERT INTO cko_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","na ba ŋu i, ama, ba koro asi má ka yiri lɛɛ. ");
INSERT INTO cko_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Na wɔ bisa bu ka, “Am wo natiiri n su atin n nu ni, am boori nzu anzama n a?” Na ba ka ajina gbirim ni ahoresaaki. ");
INSERT INTO cko_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Na bu nu kun be bo bu fere i ka Kɛlɔpasi n abɔ i nu ka, “I yo sɛ ye wɔfɔm kɛrɛ bo bu wo Yɛrusalem miɛ kpiri n nu n si sam bo ba yo nyini le­nnyɔ n nu bɛrɛ, ye wɔrɔ ŋgumi si má?” ");
INSERT INTO cko_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Na wɔ bisa bu ka, “Nzu sam?” Na ba bɔ i nu ka, “Yesu Nazarɛti­fɔ n jɔrɛ. I yo tiiri Nyɛmɛ nɔaniɛ kan­fɔ bo i la yiko wɔ, fa kɔ i alekutura sam ni i keree­wam su, na i sa­yoo­wam sun Nyɛmɛ ni minɛm n kɛrɛ nu. ");
INSERT INTO cko_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Na Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ nkpiɛn­kpiɛnm ni tere­tere­fɔm n ama ba di i jɔrɛ ka bu kun i, na ba kpama i baka jaanu n su. ");
INSERT INTO cko_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ama, yɛrɛ yo laari tama ka yiri ye wɔ ba ka i bá de Yisareli­fɔm tii ji a. Deke bo i buka nyinim kɛrɛ su n la ka, nyini sam kɛrɛ yoori, i nyuma le­san lɛɛ. ");
INSERT INTO cko_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Haari ni nyini n mmɔɔ, ya nbaram nbem ba kaanri alekutura jɔrɛ be kereeri ya. Bu kɔɔri yabuɛ buɛ faŋ­kunma n nu wɔ ŋgarama fuun, ");
INSERT INTO cko_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ama, ba ŋu má fuin n dɔ. Bu kpieeri bu nyi ba juuri ni, na ba se ya ka, bu kɔ ŋuuri Nyɛmɛ mɛrɛkɛm ka alɛlɛ nu wɔ, faŋ­kunma n nu, na ba se bu ka i la ŋgɔɔ. ");
INSERT INTO cko_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Na ya nu nbem gusu akɔ faŋ­kunma n nu, bu kɔ ŋuuri deke n kɛrɛ sɔ ɔ, kabo nbaram seeri ni, ama, ba ŋu má yiri.” ");
INSERT INTO cko_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Na Yesu ase bu ka, “Ambɛrɛ, ŋgɔnlɛ akpiɛ am su wɔ, nzɛn sɛ, ye dada kɛrɛ am nya yo má yarada, fa kɔ jɔrɛ n kɛrɛ bo Nyɛmɛ nɔaniɛ kan­fɔm jɔjɔɔri n su? ");
INSERT INTO cko_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Am si má ka wɔ yo daka ka Kristo Tii­de­fɔ n di nyini wahara n kɛrɛ ka, na Nyɛmɛ wura i kpiri?” ");
INSERT INTO cko_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","I seeri sɔ n na wɔ kan i ŋusu jɔrɛ akere bu, kabo ba kɛrɛ i Nyɛmɛ Jɔrɛ Kadasi n kɛrɛ nu ni, i boori i bu ni Moyisi dɛɛ kɛrɛɛ­wam wɔ, na wɔ nya akan kabo Nyɛmɛ nɔaniɛ kan­fɔm kɛrɛ kɛrɛɛri ni. ");
INSERT INTO cko_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Bu ba kɔ suju miɛ n bo bu sukɔ su ni, na Yesu ayo ka yiri susin kɔ mɔ, ");
INSERT INTO cko_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ama, na ba sere i ni anyum­boro, na ba se i ka, “Ba yo ya wɔfɔ. Wiɛ atɔ, ale susan lɛɛ.” Nyini ti, na wɔ wura awuru n nu ka i da bu dɔ. ");
INSERT INTO cko_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Saŋga bo i tanaari na bu kɛrɛ di diire n ni, na wɔ fa kpɔnɔ, na wɔ da Nyɛmɛ asi, na wɔ bubu i nu afa ama bu. ");
INSERT INTO cko_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Dɔ na bu nyunu ateke i ŋu, na ba si i, kpeŋga na wɔ mini ayaki bu. ");
INSERT INTO cko_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Na ba se bu beŋgu ka, “Saŋga bo i jɔjɔɔri ya dɔ atin n nu na i kaanri Nyɛmɛ Jɔrɛ Kadasi n bu kereeri ya ni, i maari ya ahorejɔ kɔ sin su wɔ, má sɔ?” ");
INSERT INTO cko_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Na ba kaba ayasu bɛrɛ akpie bu nyi akɔ Yɛrusalem miɛ kpiri n nu, na ba kɔ aŋu ka i susu­fɔ buru ni kunm ni, ni nyiŋgam n atiɛn bu nɔɔ, ");
INSERT INTO cko_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","bu suse ka, “Ya Mibiɛ n ateŋge nahɔrɛ su. Wɔ yi i ŋu akere Simon.” ");
INSERT INTO cko_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Na susu­fɔ nnyɔm n akan sa n bo i yoori atin n nu dɔ ni, ni kabo bu siiri ka yiri ni, saŋga bo i bubuuri kpɔnɔ n nu maari bu ni. ");
INSERT INTO cko_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Saŋga bo susu­fɔ nnyɔm n wo jɔrɛ n kan su sɔ ni, na Yesu ni i tii akaba aba ajina bu afiɛn, na wɔ se bu ka, “Nyɛmɛ ma am ahoreda.” ");
INSERT INTO cko_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Na sɛrɛ ati bu agaya, dama bu sunsun ka ŋumi ye ba ŋu i a. ");
INSERT INTO cko_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Na wɔ bisa bu ka, “Nzu deke miɛ am a? Nzu ti ye am yo sika? ");
INSERT INTO cko_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Am niɛ m saam ni m jaam, mini ni m tii lɛɛ. Am fa am saa kan m na am niɛ, ŋumi la má aŋuniɛ­mbaa ni buwem kabo am ŋu ka m la i ni.” ");
INSERT INTO cko_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","I seeri sɔ wieeri n na wɔ fa i saam ni i jaam deke bo bu boori i bulaari n afa akere bu. ");
INSERT INTO cko_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","I yoori bu alekutura na bu ahore jɔ kɔ siinri su ni, haari ni nyini n kɛrɛ, ba koro ayo má yarada. Dɔ na wɔ bisa bu ka, “Am la diire be fɛn bo am di?” ");
INSERT INTO cko_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Na ba fa jombaa n bo ba tun i n be ama i, ");
INSERT INTO cko_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","na wɔ de akpɛsɛ bu nyu­mbaa nu bɛrɛ. ");
INSERT INTO cko_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Na wɔ se bu ka, “Ahin nɔaniɛm bo m yo jɔjɔɔri bu saŋga bo m toko wo am dɔ n lɛɛ, ka, wɔ yo daka ka m ŋusu jɔrɛ kɛrɛ yo yii­wa, kabo ba kɛrɛ i Nyɛmɛ nɔaniɛ kpamaa­wa n bo i fa maari Moyisi dɛɛ kadasi n nu, ni Nyɛmɛ nɔaniɛ kan­fɔm dɛɛ n nu, ni kansi jue kɛrɛɛ­wam n nu ni.” ");
INSERT INTO cko_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Na wɔ teke bu nyi na bu si Nyɛmɛ Jɔrɛ Kadasi n bu, ");
INSERT INTO cko_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","na wɔ se bu ka, “Kabo ba kɛrɛ i Nyɛmɛ Jɔrɛ Kadasi n nu n lɛɛ, ka, Kristo Tii­de­fɔ ni bá di wahara, na bu kún i, na le­san cɛɛn na i téŋge i yiwee n nu. ");
INSERT INTO cko_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Bu bó i bu Yɛrusalem miɛ kpiri n nu wɔ, na bu kán labari kpa n jɔrɛ i duma nu kere daanfiɛ kɛrɛ, ka, bu kaaki bu wo na Nyɛmɛ fá bu satiɛ ce bu. ");
INSERT INTO cko_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ambɛrɛ dí nyini sam daani a. ");
INSERT INTO cko_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Am ti fɛn, mini bá sunma aceeri n bo m Si Nyɛmɛ seeri ka i fá ma am, na i bá wura am ŋu n a. Ama, ambɛrɛ ŋmínda miɛ n kunnu fɛn, haari saŋga bo yiko ni bá fite aŋgoro ba wura am ŋu.” ");
INSERT INTO cko_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Na wɔ fa bu afite miɛ n kunnu akɔ aju Betani miɛ n ahɛmɛ, dɔ na wɔ yɛ i saa su na wɔ yo kisi agɔ bu ŋu. ");
INSERT INTO cko_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","I wo bu kisi n yo su sɔ ni, na wɔ yaki bu, na Nyɛmɛ ama wɔ fun akɔ aŋgoro. ");
INSERT INTO cko_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Na ba kutu asu i, na ba kpie bu nyi akɔ Yɛrusalem miɛ kpiri n nu ni ahorejɔ bambaka. ");
INSERT INTO cko_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Na ba kɔ awo Nyɛmɛ Seree­biri Awuru n nu sukansi Nyɛmɛ saŋga kɛrɛ.");
INSERT INTO cko_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Kana Nyɛmɛ ba yi durunya ni, be woori bɛrɛ bo bu fere i ka Nɔaniɛ. I ni Nyɛmɛ woori bɛrɛ a. Yiri Nɔaniɛ ni ti Nyɛmɛ a. ");
INSERT INTO cko_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Fite i bumboori n kɛrɛ, yiri ni Nyɛmɛ wo bɛrɛ a. ");
INSERT INTO cko_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Na Nyɛmɛ ama Nɔaniɛ n ayi deke n kɛrɛ. Deke be wo má bɛrɛ bo wɔ yi má i. ");
INSERT INTO cko_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ŋgɔɔ fite yiri Nɔaniɛ ni dɔ a. Nyini ŋgɔɔ ni fa wein ba tekeeri adamande nyi a. ");
INSERT INTO cko_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Na wein n aje awosin nu, na awosin n akoro akunma má wein ni. ");
INSERT INTO cko_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Nyɛmɛ yo sunmaari sɔnɔ be, bu fere i ka Yohane. ");
INSERT INTO cko_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","I baari ka i ba di nyini wein n daani wɔ, na i kan i jɔrɛ kere minɛm, adena sɔnɔ kɛrɛ bo i tiiri kabo i kan ni, na bu daari nyini wein n ŋu. ");
INSERT INTO cko_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yohane n mmɔɔ ni i tii yo ti má wein ni, ama, i baari ka i ba di wein n daani wɔ. ");
INSERT INTO cko_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Nyini wein ni ti wein nahɔrɛ su n a, bo wɔ ba durunya n nu, na i teke adamande kɛrɛ nyi. ");
INSERT INTO cko_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Yiri n bo bu fere i ka Nɔaniɛ n yo woori durunya n nu wɔ, Nyɛmɛ faari yiri yiiri durunya n a, haari ni nyini n kɛrɛ mmɔɔ, durunya n nu­fɔm asi má i. ");
INSERT INTO cko_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Na wɔ ba i tiɛŋgu dɛɛ asiɛn n su minɛm dɔ, na ba kete ka bu de má i. ");
INSERT INTO cko_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ama, na minɛm kɛrɛ bo bu deeri i, na bu daari i ŋu ni, na wɔ ma bu atin ka bu kaaki Nyɛmɛ nbaam. ");
INSERT INTO cko_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Bu Nyɛmɛ nbaa kaakii­wam n ti má ka bu wu bu ni adamande mbunja a, nzɛn má nyini, i ti má ka biɛsɔ ni bara saŋga a ye bu wu bu a, ama, Nyɛmɛ ni i tii, ti bu Si a. ");
INSERT INTO cko_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Na yiri Nɔaniɛ n akaaki adamande aba awo ya dɔ. Ahɔrɔma ni nahɔrɛ wo i dɔ beberebe. Ya ŋu i jirima woo­wa ni, nyini jirima woo­wa n ye Nyɛmɛ afa ama i Wa kun n kpein n a. ");
INSERT INTO cko_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yohane diiri i daani kereeri minɛm, na wɔ tiɛn ase ka, “Nyini sɔnɔ n bo m yo seeri am ka i wo m sin suba na i tara m fieo n lɛɛ, dama kana bu ba wuuri m ni, yiri wo bɛrɛ wɔ.” ");
INSERT INTO cko_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","I ahɔrɔma beberebe n dɛɛ ti, ye ya di i ahɔrɔma, na ya toko di i buka su. ");
INSERT INTO cko_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Nyɛmɛ yo faari i nɔaniɛ kpamaa­wa ni maari Moyisi ka i fa kere Yisareli­fɔm, ama, Yesu Kristo aba ka i ba kere ya kabo Nyɛmɛ ahɔrɔma n ni i nahɔrɛ n ti barasu wɔ. ");
INSERT INTO cko_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Be nya ŋu má Nyɛmɛ, má ka i Wa kun n kpein n bo i ni i Si Nyɛmɛ n ti kun ni, na i wo Nyɛmɛ dɔ ni, yiri ye wɔ kere ya kabo Nyɛmɛ ti a. ");
INSERT INTO cko_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ahin ti daani dii­wa n bo Yohane yo diiri i, saŋga bo Yuda­fɔm nkpiɛn­kpiɛnm n bo bu wo Yɛrusalem miɛ kpiri n nu n sunmaari Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm ni bu buka­fɔm ka bu kɔ bisa Yohane ka, “Wɔrɔ la ŋma a?” ");
INSERT INTO cko_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yohane afiɛ má bu jɔrɛ be su, na wɔ kan i kɛrɛ kpain akere bu. I ŋa, “Má mini ti Kristo ni, Tii­de­fɔ n bo Nyɛmɛ ŋa i súnma i n a.” ");
INSERT INTO cko_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Na ba bisa i bekun ka, “Ye wɔrɔ la ŋma a? Wɔrɔ ti Nyɛmɛ nɔaniɛ kan­fɔ Eliya n a?” Na wɔ se bu ka, “Má yiri la mini.” Na ba kaaki abisa i ka, “Wɔrɔ ti Nyɛmɛ nɔaniɛ kan­fɔ n a?” I ŋa, “Ai.” ");
INSERT INTO cko_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Na ba sa su abisa i ka, “Ye wɔrɔ la ŋma a? Ma ya nɔaniɛ na ya kɔ se bo bu sunmaari ya ni. Wɔrɔ ŋa, wɔrɔ la ŋma tenle su a?” ");
INSERT INTO cko_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Na wɔ se bu ka, “Sɔnɔ n bo Nyɛmɛ nɔaniɛ kan­fɔ Esaya yo kɛrɛɛri i jɔrɛ ka i bá subo ndoori boro kpantain nu n ka, ‘Am yo Mibiɛ n atin n dɔŋgu.’ Yiri la mini.” ");
INSERT INTO cko_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Minɛm bo bu bisaari Yohane bisaa­wa ni, Farasi­fɔm bo bu ti Yuda­fɔm asɛsɛ be ni sunmaari bu a. ");
INSERT INTO cko_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Na ba kaaki abisa i ka, “A ŋa a ti má Kristo Tii­de­fɔ ni, a kaaki ti má Eliya, na a kaaki ti má Nyɛmɛ nɔaniɛ kan­fɔ n ni, ye nzu ti ye a biɛ minɛm Nyɛmɛ nzue a?” ");
INSERT INTO cko_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Na wɔ bɔ bu nu ka, “Mini biɛ minɛm Nyɛmɛ nzue wɔ. Ama, sɔnɔ be wo am nu fɛn bo ambɛrɛ si má i. ");
INSERT INTO cko_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","I wo m sin suba, m ti kaan ni bo m dodo i mmɔɔ.” ");
INSERT INTO cko_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ahin sa n kɛrɛ yo yoori miɛ n bo bu fere i ka Betani n nu wɔ, i wo Yodan kunma n wiɛ afiiri, deke bo Yohane yo biɛɛri minɛm Nyɛmɛ nzue n wɔ. ");
INSERT INTO cko_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Alecin fɔfɔrɛ na Yohane aŋu ka Yesu suba i dɔ, na wɔ se ka, “Am niɛ, Nyɛmɛ bɔmbaa n bo wɔ ba ka i ba yi durunya n nu­fɔm satiɛ n lɛɛ. ");
INSERT INTO cko_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Yiri, ye m yo seeri am ka sɔnɔ n bo i wo m sin suba na i tara m fieo n lɛɛ, dama i yo woori bɛrɛ wɔ ka, ye bu wuuri m a, yiri lɛɛ. ");
INSERT INTO cko_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Mini mmɔɔ ni m tii yo si má i, m dɛɛ la ka m biɛ minɛm Nyɛmɛ nzue wɔ, adena ambɛrɛ Yisareli­fɔm si i.” ");
INSERT INTO cko_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Na Yohane adi daani ase minɛm ka, “Ma ŋu ka Nyɛmɛ Awiɛwiɛ Casi n afite aŋgoro ajura ka tiiwa dɛɛ su aba atana i ŋu, na wɔ wo i dɔ. ");
INSERT INTO cko_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Mini mmɔɔ ni m tii yo si má i, ama, Nyɛmɛ bo i sunmaari m ka m ba biɛ minɛ Nyɛmɛ nzue ni, yiri seeri m ka, ‘A bá ŋu ka m Awiɛwiɛ ni júra ba tana sɔnɔ be ŋu, na i wó i dɔ, yiri má m Awiɛwiɛ Casi n ba wura minɛm ŋu a.’ ");
INSERT INTO cko_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ma ŋu i sɔ ye m sudi daani kere minɛ a, ka yiri ti Nyɛmɛ Wa n nahɔrɛ su a.” ");
INSERT INTO cko_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Na alecin fɔfɔrɛ bekun na Yohane ni i susu­fɔm ni nnyɔ jina. ");
INSERT INTO cko_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Na wɔ niɛ aŋu ka Yesu wo natiiri su susin, na wɔ se ka, “Am niɛ, Nyɛmɛ Bɔmbaa n lɛɛ.” ");
INSERT INTO cko_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","I susu­fɔ nnyɔm n tiiri sɔ n na ba kɔ asu Yesu su. ");
INSERT INTO cko_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Na Yesu akaaki aniɛ aŋu ka bu susu i su, na wɔ bisa bu ka, “Am koro nzu wɔ?” Na ba bisa i ka, “Rabi, a da ni wɔ?” Rabi bu la ka, ya Kere­fɔ. ");
INSERT INTO cko_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Na wɔ se bu ka, “Am bra na am ba niɛ.” Nyini saŋga ni, naasɔ kerefi nna abo, na ba su i su, na ba kɔ aŋu deke bo i wo ni. Na ba ka i dɔ nyini cɛɛn ni. ");
INSERT INTO cko_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Nyini minɛ n nnyɔm n bo bu yo tiiri kabo Yohane seeri n na bu suuri Yesu su ni, bu nu kun ye bu fere i ka Andere n a, bo i gɔrɔ la Simon Petoro ni. ");
INSERT INTO cko_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Nyini sin na Andere akɔ aŋu i gɔrɔ Simon, na wɔ se i ka, “Ya ŋu Mɛsaya ni.” Mɛsaya bu la ka Kristo, Tii­de­fɔ n bo Nyɛmɛ ase ka i súnma i ni. ");
INSERT INTO cko_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Na wɔ fa i aba Yesu dɔ. Na Yesu aniɛ i nyunu, na wɔ se i ka, “Bu fere u ka Simon wɔ, wɔrɔ ti Yohane wa n a, ama, bu bá fere u ka Kefasi.” I bu la ka yabuɛ, i ni Petoro kɛrɛ ti duma kun wɔ. ");
INSERT INTO cko_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Alecin fɔfɔrɛ na Yesu ayasu ka i kɔ Galili dɛɛ awɔrɛ n nu. Na wɔ kɔ aŋu sɔnɔ be bo bu fere i ka Filipu ni, na wɔ se i ka, “Ba su m su.” ");
INSERT INTO cko_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipu bɔsu la miɛ be bo bu fere i ka Besayida n wɔ. I ni Andere ni Petoro kɛrɛ fite miɛ kun su wɔ. ");
INSERT INTO cko_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Na Filipu gusu akɔ aŋu sɔnɔ be bo bu fere i ka Nataniɛli, na wɔ se i ka, “Ya ŋu sɔnɔ n bo Moyisi yo kɛrɛɛri i jɔrɛ Nyɛmɛ nɔaniɛ kpamaa­wa kadasi n nu ni, na Nyɛmɛ nɔaniɛ kan­fɔm gusu yo kɛrɛɛri i jɔrɛ bu dɛɛ kadasi n nu ni. Yiri la Yesu n bo i fite Nazarɛti ni, na i si la sɔnɔ be bo bu fere i ka Yosefu ni.” ");
INSERT INTO cko_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Na Nataniɛli abisa i ka, “Deke kpa koro fite Nazarɛti dɛɛ miɛ n gusu nu?” Na Filipu ase i ka, “Bra na a ba niɛ.” ");
INSERT INTO cko_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Nyini saŋga na Yesu aŋu ka Nataniɛli suba i dɔ, na wɔ se ka, “Ahin sɔnɔ n ti Yisareli­fɔ baa a nahɔrɛ su, bo sa be wo má i ŋu.” ");
INSERT INTO cko_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Na Nataniɛli abisa i ka, “A yo sɛ siiri m a?” Na Yesu abɔ i nu ka, “M ŋuuri u saŋga bo a toko tana damba baka n bu n wɔ, nyini sin ye Filipu fereeri u n a.” ");
INSERT INTO cko_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Na Nataniɛli ase i ka, “Ya Kere­fɔ, wɔrɔ ti Nyɛmɛ Wa n a, nahɔrɛ su. Wɔrɔ ti Yisareli­fɔm Fɛmɛ n a.” ");
INSERT INTO cko_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Na Yesu ase i ka, “Bo ma se u ka m ŋuuri u damba baka n bu n ti ye a yo m yarada, nzɛn sɛ? A bá ŋu alekutura sam bo bu tara sɔ. ");
INSERT INTO cko_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Nahɔrɛ ye m suse am a. Am bá ŋu kabo aŋgoro bá teke na Nyɛmɛ mɛrɛkɛm bá sufun kɔ aŋgoro, na bu bá sujura ba mini Adamande Wa n dɔ.” ");
INSERT INTO cko_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Nyini sin, i le­san cɛɛn na konyaya be awo Kana, miɛ kpiri n bo i wo Galili awɔrɛ n nu ni. Na Yesu ni gusu akɔ konyaya n nu. ");
INSERT INTO cko_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Na ba fere Yesu ni i susu­fɔm n ka bu gusu ba di konyaya n be. ");
INSERT INTO cko_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Saŋga bo konyaya­fɔm nzan n ba kpiɛɛri bu su ni, na Yesu ni aba ase i ka, “Bu nzan n awie.” ");
INSERT INTO cko_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Na Yesu abɔ i nu ka, “M ni, ye a ŋa m yo sɛ wɔ? M saŋga nya ju má.” ");
INSERT INTO cko_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Na i ni ase awuru­nbaam n ka, “Am yo deke kɛrɛ bo i se am.” ");
INSERT INTO cko_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Nyini dika n nu, yabuɛ cuŋgu nsɛn jina bɛrɛ, bo i kun kun kɛrɛ koro de nzue gaŋga nnu wara nsɛn. Yuda­fɔm la bu yoo­wa be, bu fa nyini cuŋgum n nu nzue ni, ye bu bita ŋmisi bu fin a. ");
INSERT INTO cko_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Na Yesu ase awuru­nbaam n ka, “Am sa nzue gɔ cuŋgum n nu na bu yi.” Na ba gɔ i kɛrɛ nzue na ba yi. ");
INSERT INTO cko_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Na Yesu akaaki ase bu ka, “Kisa am sa be kɔ ma konyafan danfo ni.” Na ba sa be akɔ ama i. ");
INSERT INTO cko_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Bu sa kɔ maari i ni, na nzue n akaaki nzan. Na wɔ fa akan i nɔɔ. Wɔ si má deke bo nyini nzan n fite. Ama, awuru­nbaam bo bu saari nzue ni, bɛrɛ si deke bo i fite. Na wɔ fere konyafan ni, ");
INSERT INTO cko_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ase i ka, “Sɔnɔ kɛrɛ nya ŋa bu ma nzan, bu du mɔ fa nzan fiɛfiɛ n ma jama n a ka, na ba nya aba anu abo ni, na bu nya fa bo i yo má fiɛ n ma bu, ama, wɔrɔ, a fa bo i yo fiɛ n aka sin a.” ");
INSERT INTO cko_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Kabo Yesu maari nzue kaaki nzan ni, nyini tiiri i ciciri su dɛɛ alekutura sa. I yoori nyini sa n Kana, bo i wo Galili awɔrɛ n nu n wɔ, na i kere kabo i la yiko n bo i fite Nyɛmɛ dɔ, na i susu­fɔm n ayo i yarada. ");
INSERT INTO cko_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Nyini sin, na i ni i ni, ni i niɛmam, ni i susu­fɔm n akɔ miɛ kpiri n bo bu fere i ka Kapɛnam, na ba kɔ ayo le­nnyɔ dɔ. ");
INSERT INTO cko_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Wɔ ka kaan na Yuda­fɔm di bu cɛɛn­kpiri n bo bu fere i ka Butara cɛɛn­kpiri ni. Na Yesu akɔ Yɛrusalem miɛ kpiri n nu. ");
INSERT INTO cko_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Na wɔ kɔ awura Nyɛmɛ Seree­biri Awuru n nu aŋu ka minɛ wo dɔ sutɔ naanim, ni nbɔɛm, ni bumbuku tiiwam, na ŋwaa kaaki­fɔm gusu tana dɔ. ");
INSERT INTO cko_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Na wɔ fa nyama aŋɔ i ka ŋgbere dɛɛ su, na wɔ fa afɔn ayi nbɔɛm n ni naanim n kɛrɛ afite Nyɛmɛ Seree­biri Awuru n nu. Na wɔ sandi ŋwaa kaaki­fɔm ŋwaa n kɛrɛ abutu, na wɔ nya akaaki bu teebirim kɛrɛ alanlaŋga. ");
INSERT INTO cko_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Na wɔ se minɛm bo bu tɔ bumbuku tiiwam n ka, “Am fa am bumbukum n fite fɛn. Má am se ka am fa m Si Nyɛmɛ Seree­biri Awuru n yo gɔ kun.” ");
INSERT INTO cko_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Na i susu­fɔm n aba ateŋge su ka ba kɛrɛ i Nyɛmɛ Jɔrɛ Kadasi n nu ka, “M Nyɛmɛ Fɛmɛ, m nyunu aboro u awuru n jɔrɛ su, nyini kún m a.” ");
INSERT INTO cko_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Na Yuda­fɔ nkpiɛnm abisa i ka, “A yó nzu alekutura sa bo i kere ya ka a la atin bo a yo sɔ a?” ");
INSERT INTO cko_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Na Yesu ase bu ka, “Am bo fufu ahin Nyɛmɛ Seree­biri Awuru ni, na le­san afiɛn m káaki ta i bekun.” ");
INSERT INTO cko_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Na ba se i ka, “Afɔ abura­na ni nsɛn ye bu fa taari ahin Nyɛmɛ Seree­biri Awuru n a. I yo sɛ ye wɔrɔ ba se ka a káaki ta i le­san afiɛn a?” ");
INSERT INTO cko_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","I yo kaanri sɔ ni, i faari i ŋuniɛ­mbaa ni fa sunsun Nyɛmɛ Seree­biri Awuru n a. ");
INSERT INTO cko_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Na saŋga bo i ba wu teŋgeeri i yiwee n nu ni, na i susu­fɔm n ateŋge su ka i yo seeri sɔ, na ba de nɔaniɛ n bo ba kɛrɛ i Nyɛmɛ Jɔrɛ Kadasi n nu ni, na ba yo Yesu jɔjɔɔ­wa n yarada. ");
INSERT INTO cko_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Saŋga bo i wo Yɛrusalem na bu sudi Butara cɛɛn­kpiri ni, i yoori alekutura sam, na minɛ dɔŋgu aŋu i, na ba yo i yarada. ");
INSERT INTO cko_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ama, yiri afa má i ŋu agɔ má bu ŋu, dama i si kabo adamande woo­wa ti. ");
INSERT INTO cko_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Má pui ti, yiri mmɔɔ ni i tii si kabo adamande ahore su ti barasu, má be se i a. ");
INSERT INTO cko_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","2","Cɛɛn be kɔŋguɛ sɔ ɔ, na Yuda­fɔm kpiɛn be aba Yesu dɔ, bu fere i ka Nikodemo. I ti Farasi­fɔm ni kun be wɔ. Na wɔ se Yesu ka, “Ya Kere­fɔ, ya si ka a ti kere­fɔ n bo a fite Nyɛmɛ dɔ ɔ, dama be koro yo má alekutura sa bo a yo bu ni, má ka Nyɛmɛ wo i mi dɔ.” ");
INSERT INTO cko_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Na Yesu ase i ka, “Nahɔrɛ ye m suse u a. Sɔnɔ koro fa má Nyɛmɛ yo má i fɛmɛ, má ka ba wu i fɔfɔrɛ.” ");
INSERT INTO cko_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Na Nikodemo abisa i ka, “Sɔnɔ nyunu ati, bu yo sɛ koro kaaki wu i fɔfɔrɛ a? I koro kaaki wura i ni kunnu na bu wu i bekun?” ");
INSERT INTO cko_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Na Yesu ase i ka, “Nahɔrɛ ye m suse u a, sɔnɔ koro wura má Nyɛmɛ fɛmɛya n nu, má ka ba wu i fɔfɔrɛ fa kɔ nzue biɛɛ­wa ni Awiɛwiɛ Casi n dɛɛ atin n su. ");
INSERT INTO cko_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Deke bo adamande awu i, i ti adamande wɔ, na deke bo Awiɛwiɛ Casi n awu i, i ti awiɛwiɛ wɔ. ");
INSERT INTO cko_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Má a ma i yo u alekutura fa kɔ kabo ma se u ka wɔ yo daka ka bu wu am fɔfɔrɛ ni. ");
INSERT INTO cko_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Saŋga kɛrɛ a ti ka aŋuma kpiɛ kɔ ɔ, ye a ti i naŋmiɛ ŋga a, ama, a si má deke bo i fite, na a kaaki si má deke bo i sukɔ, nyini ti, sɔnɔ kɛrɛ bo Awiɛwiɛ Casi n awu i ti sɔ ɔ.” ");
INSERT INTO cko_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Na Nikodemo abisa Yesu ka, “I yo sɛ ye ahin koro yo a?” ");
INSERT INTO cko_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Na Yesu akaaki abisa i ka, “Wɔrɔ bo a kere Yisareli­fɔm Nyɛmɛ nɔaniɛ n na bu nyunu yi u ni, i yo sɛ ye a si má ahin n a? ");
INSERT INTO cko_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nahɔrɛ ye m suse u a, sa bo ya si i, ye ya jɔjɔ i jɔrɛ a, na sa bo ya nyu­mbaa aŋu i, ye ya di i daani kere minɛm a, ama, am akete ya daani dii­wa ni. ");
INSERT INTO cko_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","M suse am sam bo bu wo durunya n nu fɛn wɔ lɛɛ, ama, am sude má i, ye m ba seeri am sam bo bu wo Nyɛmɛ fɛmɛya n nu, am yó sɛ de i a? ");
INSERT INTO cko_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Be nya fun má Nyɛmɛ dɔ, má ka mini Adamande Wa n bo m woori i dɔ na ma jura aba ni. ");
INSERT INTO cko_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Kabo Moyisi yo faari jawii yoori i ka woo dɛɛ su n na i fa i bara yɛɛri baka n na i yɛɛri i su kpamaari boro kpantain n nu ni, wɔ yo daka ka sɔ ye minɛm bá yɛ mini Adamande Wa n su a. ");
INSERT INTO cko_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Na sɔnɔ kɛrɛ bo i yoori m yarada, i nyá ŋgɔɔ bo i la má awieeri ni.” ");
INSERT INTO cko_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Nyɛmɛ akoro durunya n nu­fɔm agaya n dɛɛ ti, na wɔ fa i kunnu Wa kun n kpein n afa ama bu, adena sɔnɔ kɛrɛ bo i yo i yarada, i mi ká má ŋgbɛɛn, ama, i nya ŋgɔɔ bo i la má awieeri ni. ");
INSERT INTO cko_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Nyɛmɛ asunma má i Wa n durunya n nu ka i ba di bu jɔrɛ cin bu sui wɔ, ama, wɔ sunma i ka i ba de bu tii ji wɔ. ");
INSERT INTO cko_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Sɔnɔ kɛrɛ bo i daafiiri Nyɛmɛ Wa n ŋu, Nyɛmɛ dí má i mi n jɔrɛ, ama, sɔnɔ kɛrɛ bo wɔ da má i ŋu, Nyɛmɛ adu mɔ adi i jɔrɛ ka, dama ka wɔ da má Nyɛmɛ Wa kun n kpein n ŋu n dɛɛ ti. ");
INSERT INTO cko_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Kabo Nyɛmɛ di bu jɔrɛ n la ka, wein n aba durunya n nu­fɔm dɔ, ama, bu satiɛ yoo­wa n dɛɛ ti, ba koro awosin n atara wein ni. ");
INSERT INTO cko_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Sɔnɔ kɛrɛ bo i yo satiɛ kpɔ wein n wɔ, i koro má ka i kɔ wein n nu, na i satiɛm fite fofoe nu. ");
INSERT INTO cko_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ama, sɔnɔ kɛrɛ bo i su nahɔrɛ atin su, i fite fofoe nu wɔ, na minɛ kɛrɛ ŋu ka i sa­yoo­wa n su Nyɛmɛ atin n su wɔ. ");
INSERT INTO cko_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Nyini sin na Yesu ni i susu­fɔm n akɔ Yudiya dɛɛ awɔrɛ n nu. Na ba kɔ adi le­nnyɔ dɔ, na i subiɛ minɛm Nyɛmɛ nzue. ");
INSERT INTO cko_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Nyini saŋga n na Yohane gusu subiɛ minɛm Nyɛmɛ nzue. I wo Ayinon miɛ n nu fa dodo Salim awɔrɛ n nu, dama nzue sunnu dɔ n dɛɛ ti. Na minɛm suba i dɔ na i subiɛ bu Nyɛmɛ nzue. ");
INSERT INTO cko_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Nyini saŋga ni, ba nya anyi má Yohane dan­saraka. ");
INSERT INTO cko_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Na Yohane susu­fɔm ni Yuda­fɔ be awura akuruwa fa kɔ bu fin kpara n dɛɛ yoo­wa atin su. ");
INSERT INTO cko_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Na ba kɔ Yohane dɔ akɔ ase i ka, “Ya Kere­fɔ, niɛ. Sɔnɔ n bo i yo baari u dɔ Yodan kunma n wiɛ afiiri n na a yo diiri i ŋu daani kereeri minɛ ni, yiri wo dɔ subiɛ minɛm Nyɛmɛ nzue n a, bu kɛrɛ sukɔ i dɔ ɔ.” ");
INSERT INTO cko_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Na Yohane ase bu ka, “Sɔnɔ koro nya má deke be, má ka Nyɛmɛ afa nyini deke n ama i. ");
INSERT INTO cko_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ambɛrɛ ni am tii woori m daani ka m ŋa má mini ti Kristo Tii­de­fɔ n a, ama, Nyɛmɛ sunmaari m ka m du i mɔ ɔ. ");
INSERT INTO cko_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Bu nya jaari konya, i ti konyafan n dɛɛ wɔ, ama, na konyafan n danfo jina suso i sui ti deke bo konyafan ni jɔjɔ se i, nyini saŋga na i danfo n ahore jɔ. Nyini ahorejɔ kun ni, wo mini gusu dɔ a. ");
INSERT INTO cko_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Wɔ yo daka ka i dɛɛ duma n fun, na m dɛɛ n kpiɛ su.” ");
INSERT INTO cko_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Yiri bo i fite aŋgoro n tara sɔnɔ kɛrɛ. Na bo i fite durunya n nu fɛn ti durunya n nu fɛn fɔ ɔ, na i jɔjɔɔ­wa kɛrɛ ti durunya n nu fɛn jɔrɛ wɔ. Ama, yiri n bo i fite aŋgoro n tara sɔnɔ kɛrɛ. ");
INSERT INTO cko_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Deke bo wɔ ŋu i, ni bo wɔ ti i, ye i di i daani kere minɛ a, ama, be de má i daani dii­wa ni. ");
INSERT INTO cko_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ama, sɔnɔ kɛrɛ bo i deeri i daani dii­wa n asoro su akere ka Nyɛmɛ ti nahɔrɛ­fɔ lɛɛ. ");
INSERT INTO cko_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Dama yiri n bo Nyɛmɛ asunma i ni, Nyɛmɛ nɔaniɛ n ye i kan i a, dama Nyɛmɛ afa i Awiɛwiɛ Casi n ama i bo i la má aŋusu. ");
INSERT INTO cko_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Nyɛmɛ koro i Wa ni, na wɔ fa deke n kɛrɛ awura i saa nu. ");
INSERT INTO cko_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Na sɔnɔ kɛrɛ bo i daari Nyɛmɛ Wa n ŋu, i la ŋgɔɔ bo i la má awieeri ni. Na sɔnɔ kɛrɛ bo i kete i nɔaniɛ ni, i nyá má ŋgɔɔ n bo i la má awieeri ni, ama, Nyɛmɛ fá yaa cin i sui. ");
INSERT INTO cko_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","2","Tɔ. Na Farasi­fɔm n ati ka Yesu sunya minɛm dɔŋgu bo bu susu i su na i biɛ bu Nyɛmɛ nzue tara Yohane. Ama, má Yesu ni i tii biɛ bu Nyɛmɛ nzue n a, i susu­fɔm ni biɛ bu a. Saŋga bo Yesu faari nu sɔ ni, ");
INSERT INTO cko_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","na wɔ yasu Yudiya awɔrɛ n nu akaaki ka i kɔ Galili dɛɛ awɔrɛ n nu bekun. ");
INSERT INTO cko_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","I sukɔ ni, wɔ yo daka ka i fa Samariya dɛɛ awɔrɛ n nu sin a. ");
INSERT INTO cko_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Na wɔ kɔ aju Samariya miɛ kpiri be bo bu fere i ka Suka n su, na i wo dodo asiɛn n bo Jakɔbu yo fa maari i wa Yosefu dawa saŋga ni. ");
INSERT INTO cko_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Jakɔbu bura n wo nyini dika n nu wɔ. Natiiri fie n dɛɛ ti, na Yesu akɔ atana bura n su. Nyini saŋga wiɛ abi kenken. ");
INSERT INTO cko_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Na Samariya bara be aba ka i ba sa nzue, na Yesu ase i ka, “Ma m nzue n be na m nu.” ");
INSERT INTO cko_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Nyini saŋga ni, i susu­fɔm n akɔ miɛ kunnu ka bu kɔ to diire. ");
INSERT INTO cko_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Na bara n ase i ka, “Ee, wɔrɔ, a ti Yuda­fɔ e, ye m gusu ti m Samariya­fɔ bara. Nzu ti ye a se m ka m ma u nzue a?” Dama Yuda­fɔm ni Samariya­fɔm tɔ má pui. ");
INSERT INTO cko_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Na Yesu ase i ka, “Nzɛn má a si Nyɛmɛ aceeri ni, na má a si sɔnɔ n bo i susere u nzue ni, má wɔrɔ sere i a, na i má u nzue bo i ma ŋgɔɔ ni.” ");
INSERT INTO cko_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Na bara n ase i ka, “Ya si, bura n wo ŋgo, u gusu la má goroka, ye a nya nyini nzue n bo i ma ŋgɔɔ n ni wɔ? ");
INSERT INTO cko_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Wɔrɔ, ŋka a ŋa a tara ya na Jakɔbu n wɔ, nzɛn sɛ? Yiri maari ya nyini bura n a. I ni i nbaam fa saŋga ni i neŋge­ndɔrɛm kɛrɛ yo nuuri nyini bura n nu wɔ.” ");
INSERT INTO cko_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Na Yesu ase i ka, “Sɔnɔ kɛrɛ bo i nu ahin nzue ni, nzuehɔɛ tí i mi bekun, ");
INSERT INTO cko_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ama, sɔnɔ kɛrɛ bo i nu nzue n bo m má i ni, nzuehɔɛ tí má i mi kun fieo, dama nzue n bo m má i ni, i wó i kunnu tiɛ kabo bura nzue tiɛ n wɔ, na i má i ŋgɔɔ bo i la má awieeri ni.” ");
INSERT INTO cko_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Na bara n ase i ka, “Ya si, ma m nyini nzue n be na m nu, adena má nzuehɔɛ ti m kun, na má m kaaki ba sa nzue fɛn kun.” ");
INSERT INTO cko_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Na Yesu ase i ka, “Kɔ fere u hun na am bra.” ");
INSERT INTO cko_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Na bara n ase Yesu ka, “M la má hun.” Na Yesu ase i ka, “Kabo a ŋa a la má hun ni, i ti nahɔrɛ wɔ. ");
INSERT INTO cko_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Dama nbiɛsɔm nnu ye a fite bu ajaa bu n a, na haari bo u ni yiri wo bɛrɛ kisa mmɔɔ ni, i ti má u hun. A se nahɔrɛ wɔ.” ");
INSERT INTO cko_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Na bara n ase i ka, “Ya si, ma ŋu ka a ti Nyɛmɛ nɔaniɛ kan­fɔ ɔ. ");
INSERT INTO cko_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ya na Samariya­fɔm yo suuri Nyɛmɛ ahin buka n su wɔ. Ama, ambɛrɛ Yuda­fɔm ŋa wɔ yo daka ka sɔnɔ kɛrɛ su Nyɛmɛ Yɛrusalem miɛ kpiri n nu wɔ.” ");
INSERT INTO cko_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Na Yesu ase i ka, “Bara, de bo m suse u ni, saŋga suba bo am sú má ya Si Nyɛmɛ ahin buka n su, wara Yɛrusalem miɛ n nu. ");
INSERT INTO cko_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ambɛrɛ Samariya­fɔm ŋa am su Nyɛmɛ wɔ, ama, am si má i. Ama, yɛrɛ Yuda­fɔm si i, ye ya su i a. Dama tii­de n fite Yuda­fɔm dɔ ɔ. ");
INSERT INTO cko_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Saŋga suba bo wɔ ju awie, na bo bu su ya Si Nyɛmɛ ni, i Awiɛwiɛ Casi ni búka bu ye bu sú i ni nahɔrɛ su a. Dama nyini minɛm ŋusu ye ya Si Nyɛmɛ koro ka bu su i a. ");
INSERT INTO cko_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Nyɛmɛ ti awiɛwiɛ wɔ, nyini dɛɛ ti, bo bu su i ni, wɔ yo daka ka i Awiɛwiɛ Casi n búka bu na bu sú i ni nahɔrɛ su.” ");
INSERT INTO cko_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Na bara n ase i ka, “Tɔ, m si ka Kristo Tii­de­fɔ ni bá. I ba juuri, i kán ya deke kɛrɛ kere ya.” ");
INSERT INTO cko_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Na Yesu ase i ka, “Mini bo m sujɔjɔ u dɔ ni, mini lɛɛ.” ");
INSERT INTO cko_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Nyini saŋga n nu na Yesu susu­fɔm n afite miɛ n kunnu aju, na jɔrɛ n amiɛ bu kabo Yesu ni bara n wo jɔjɔ su ni. Ama, bu be abisa má bara n ka, “A koro nzu i dɔ a?” Be gusu abisa má Yesu ka, “Nzu ti ye a sujɔjɔ bara n dɔ a?” ");
INSERT INTO cko_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Na bara n ayaki i dundu n bɛrɛ, na wɔ kpie i nyi akɔ miɛ n kunnu akɔ ase minɛm ka, ");
INSERT INTO cko_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Am ba niɛ sɔnɔ be bo wɔ se m m tii su sa kɛrɛ bo ma yo i. Beni, kisa, Kristo Tii­de­fɔ n lɛɛ fan?” ");
INSERT INTO cko_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Na minɛm n afite miɛ n nu, na bu kɔ Yesu dɔ. ");
INSERT INTO cko_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Bara n kɔɔri n dɛɛ sin, na Yesu susu­fɔm n asere i ka, “Jande, ya Kere­fɔ, di diire.” ");
INSERT INTO cko_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Na wɔ se bu ka, “M la diire bo m di bo am si má i.” ");
INSERT INTO cko_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Na i susu­fɔm n abisa bu ŋuŋu nu ka, “Be afa diire aba ama i wɔ di wɔ, nzɛn sɛ?” ");
INSERT INTO cko_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Na wɔ se bu ka, “M diire n la ka, m yo yiri bo wɔ sunma m dɛɛ koroo­wa na m yó i juma n wie.” ");
INSERT INTO cko_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Na wɔ bo bu anyundɛrɛ ase ka, “Am ŋa wɔ ka sara nna na am tambu fiesu neŋgem. Ama, mini suse am wɔ lɛɛ, am tu am tii na am niɛ, fiesu diire n abi ni kpiɛ. ");
INSERT INTO cko_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Sɔnɔ bo i kpiɛ diire ni, i nya i ŋkatɔ, i ti ka sɔnɔ bo i tiɛn minɛ nɔɔ, na bu nya ŋgɔɔ bo i la má awieeri ni, dɔ­fɔ ni kpiɛ­fɔ n kɛrɛ nya ahorejɔ. ");
INSERT INTO cko_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Be bu ŋa ‘Be dɔ, na be kpiɛ ni,’ i ti nahɔrɛ wɔ. ");
INSERT INTO cko_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ambɛrɛ yiri, mini asunma am a, ka am kɔ kpiɛ diire n bo am adɔ má i ni. I ti ka nbem adu mɔ akan Nyɛmɛ nɔaniɛ n akere minɛm, ye am dɛɛ la ka am ma bu yo m yarada. Nbem dɛɛ juma­yoo­wa ye am sudi i kpɛrɛ n a.” ");
INSERT INTO cko_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Bara n seeri minɛm bo bu fite miɛ n nu n kabo Yesu ase i tii su sa kɛrɛ n dɛɛ ti, na Samariya­fɔm dɔŋgu bo bu fite miɛ n nu n ada Yesu ŋu. ");
INSERT INTO cko_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Nyini ti, bu ba juuri Yesu dɔ ni, na ba sere i ka i ka bu dɔ, na wɔ kɔ awo bu dɔ cɛɛn nnyɔ. ");
INSERT INTO cko_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Na minɛ dɔŋgu ada i ŋu abuka su fa kɔ i nɔaniɛ jɔjɔɔ­wa n ti. ");
INSERT INTO cko_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Na ba se bara n ka, “Kisa, má u dɛɛ jɔjɔɔ­wa n ŋgumi ti ye ya da i ŋu a, ama, yɛrɛ mmɔɔ ni ya tii ati i nɔaniɛ jɔjɔɔ­wa, na ya si nu ka ahin sɔnɔ n ti bo i baari ka i ba de durunya n nu­fɔm tii wɔ, nahɔrɛ su.” ");
INSERT INTO cko_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Yesu woori bu dɔ cɛɛn nnyɔ n sin, na wɔ yasu bɛrɛ akɔ Galili dɛɛ awɔrɛ n nu. ");
INSERT INTO cko_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Dama yiri mmɔɔ ni i tii adu mɔ akan ka Nyɛmɛ nɔaniɛ kan­fɔ la má jirima i tiɛŋgu bɔsu. ");
INSERT INTO cko_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Saŋga bo i kɔ juuri Galili ni, na ba de i ni bu sa nnyɔ, dama bu yo ŋuuri kabo i yoori alekutura sam cɛɛn­kpiri n saŋga, Yɛrusalem miɛ kpiri n nu ni, dama bɛrɛ mmɔɔ yo kɔɔri nyini cɛɛn­kpiri n di ti. ");
INSERT INTO cko_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Na Yesu akaaki akɔ Kana, miɛ kpiri n bo i wo Galili awɔrɛ n nu ni, deke bo i yo maari nzue kaakiiri nzan ni. Fɛmɛ n kpiɛn be woori dɔ. I wa be la má laifiɛ, i wo Kapɛnam miɛ kpiri n nu. ");
INSERT INTO cko_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Na saŋga bo kpiɛn n tiiri ka Yesu afite Yudiya dɛɛ awɔrɛ n nu akɔ aju Galili ni, na wɔ kɔ Yesu dɔ akɔ asere i ka i wa suwu, i ma bu kɔ na i kɔ tuntun i, na i nya laifiɛ. ");
INSERT INTO cko_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Na Yesu ase i ka, “Ma ŋu ka nzɛn am aŋu má alekutura sam, am yo má m yarada.” ");
INSERT INTO cko_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Na kpiɛn n ase i ka, “M Mibiɛ, bra ndende, má nyini, a cɛɛri, a bá ŋu ka m wa n awu.” ");
INSERT INTO cko_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Na Yesu ase i ka, “Kɔ. U wa n anya laifiɛ.” Na wɔ de Yesu nɔaniɛ ni, na wɔ kaaki akɔ. ");
INSERT INTO cko_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Na saŋga bo i sukɔ awuru ni, na i akɔɔm akpa i atin aba ase i ka, “U wa n anya laifiɛ.” ");
INSERT INTO cko_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Na wɔ bisa bu ka, “Saŋga bɔnɔ ye i ŋuniɛ n jɔɔri a?” Na ba se i ka, “Anuma wiɛsu kerefi kun saŋga ye i ŋuniɛ n jɔɔri a.” ");
INSERT INTO cko_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Dɔ na baa n si n ateŋge su ka, nyini saŋga n nu lɛɛ, ye Yesu seeri i ka i wa n anya laifiɛ n a. Na i ni i dika­fɔm kɛrɛ ada Yesu ŋu. ");
INSERT INTO cko_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Kabo Yesu ma baa n nyaari laifiɛ ni, nyini tiiri i alekutura sa nnyɔ su bo i yoori saŋga bo i fite Yudiya dɛɛ awɔrɛ n nu kɔɔri Galili n a, na i kere kabo i la yiko n bo i fite Nyɛmɛ dɔ. ");
INSERT INTO cko_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Nyini sin na Yesu akɔ Yɛrusalem miɛ kpiri n nu na i kɔ di Yuda­fɔm cɛɛn­kpiri be. ");
INSERT INTO cko_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Kunma be da dodoori anɔ n bo bu fa nbɔɛm fa sin wura miɛ n nu ni. Hiburu aniɛ nu bu fere nyini kunma n ka Besata, i la kpatam nnu wɔ. ");
INSERT INTO cko_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Landuri­fɔm beberebe dada kpatam n nu, bu nu nbem ti anyinsinm, nbem ti kujanda­fɔm, na bu nbem gusu ŋuniɛ buekun awu bo bu koro yasu má.  ");
INSERT INTO cko_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Bu da ŋminda dɔ, dama saŋga saŋga Nyɛmɛ mɛrɛkɛ jura ba kunma n nu wɔ, na i ba kankan nzue n nu. Nzue kankaan­wa n dɛɛ sin, na landuri­fɔ n bo i du mɔ juraari nzue n nu, i tukpaki n koro i ti ka sɛ, i yaki wɔ, na i nya laifiɛ. ");
INSERT INTO cko_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Sɔnɔ be woori bu nu bo wɔ da tukpaki i afɔ abura­san ni mɔcuɛ lɛɛ. ");
INSERT INTO cko_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesu ŋuuri i sɔ ni, na wɔ fa nu ka sɔnɔ n tukpaki n acɛ i ŋu, na wɔ bisa i ka, “A koro ka a nya laifiɛ wɔ?” ");
INSERT INTO cko_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Na tukpaki­fɔ n ase Yesu ka, “M Mibiɛ, m la má buka­fɔ be bo nzue n nya ba kankan, na i kuku m wura nu. Saŋga kɛrɛ bo nzue n nya ba kankan, na m ba ŋa m wura nu, a ŋu ka be adu m mɔ.” ");
INSERT INTO cko_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Na Yesu ase i ka, “Yasu, fa u dasu n na a nati.” ");
INSERT INTO cko_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Jinaa­biri n nu bɛrɛ na sɔnɔ n anya laifiɛ, na wɔ yasu afa i dasu n sunati. Nyini cɛɛn n bo Yesu tuntuunri sɔnɔ n ti Ŋumi­yi cɛɛn wɔ. ");
INSERT INTO cko_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Nyini ti na Yuda­fɔm nkpiɛn­kpiɛnm n ase sɔnɔ n bo wɔ nya laifiɛ n ka, “Nyuma ti Ŋumi­yi cɛɛn wɔ. Ya dɛɛ atin n su, atin wo má nu bo a sɔ u dasu ni.” ");
INSERT INTO cko_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Na wɔ se bu ka, “Sɔnɔ n bo i tuntuunri m ni, yiri seeri m ka m fa m dasu na m nati a.” ");
INSERT INTO cko_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Na ba bisa i ka, “Nyini sɔnɔ n la ŋma a, ye i seeri u ka a fa u dasu nati a?” ");
INSERT INTO cko_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ama, na sɔnɔ n bo wɔ nya laifiɛ n akoro asi má i mi n bo i tuntuunri i ni, dama Yesu awura jama n nu akɔ. ");
INSERT INTO cko_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Nyini sin na Yesu aba aŋu i, Nyɛmɛ Seree­biri Awuru n nu, na wɔ se i ka, “Ti fɛn. Kisa a nya laifiɛ, má a yo satiɛ kun. Má nyini, a dí wahara bo i tára nyini n ŋusu.” ");
INSERT INTO cko_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Na sɔnɔ n akɔ ase Yuda­fɔ nkpiɛn­kpiɛnm ni ka Yesu tuntuunri i a. ");
INSERT INTO cko_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Nyini ti, na ba kere Yesu wuwuruwa, dama wɔ tuntun sɔnɔ Ŋumi­yi cɛɛn n dɛɛ ti. ");
INSERT INTO cko_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Na wɔ se bu ka, “M Si toko yo juma haari ba ju ni nyuma, nyini ti ye m gusu yo a.” ");
INSERT INTO cko_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Yesu jɔjɔɔri sɔ n dɛɛ ti, na Yuda­fɔm nkpiɛn­kpiɛnm n aboro bu nyi abuka su ka bu kun i. Má ka bo wɔ saaki Ŋumi­yi cɛɛn n ciire n ŋgumi dɛɛ ti, ye bu kpi ka bu kun i a, ama, bo wɔ kaaki ase ka Nyɛmɛ ti i Si n dɛɛ ti. Nyini kere ka wɔ fa i ŋu abu Nyɛmɛ wɔ lɛɛ. ");
INSERT INTO cko_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Na Yesu ase bu ka, “Nahɔrɛ ye m suse am a, mini Nyɛmɛ Wa n ni m tii, m koro bo má m tiɛɛnu yo má pui, má ka deke bo m ŋu ka m Si yo i ni, ye mini gusu yo i a. ");
INSERT INTO cko_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Dama m Si Nyɛmɛ koro mini i Wa ni, na i sukere m deke kɛrɛ bo i yo i ni, na i bá kere m sakpa­kpam bo m yó bu tara sɔ, na i yó am alekutura. ");
INSERT INTO cko_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Kabo m Si Nyɛmɛ yɛ minɛm bo ba wu n su n na i ma bu ŋgɔɔ ni, sɔ ye mini gusu ma minɛm bo ma yi bu ni ŋgɔɔ a. ");
INSERT INTO cko_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Dama m Si Nyɛmɛ ni i tii di má be jɔrɛ, ama, wɔ fa jɔrɛ­di atin kɛrɛ ama mini i Wa n wɔ, ");
INSERT INTO cko_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","adena sɔnɔ kɛrɛ bu m kabo bu bu m Si ni. Sɔnɔ kɛrɛ bo i bu má m, i mi abu má m Si bo wɔ sunma m n lɛɛ. ");
INSERT INTO cko_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Nahɔrɛ ye m suse am a, sɔnɔ kɛrɛ bo i ti m nɔaniɛ n na i de i, na i da Nyɛmɛ bo wɔ sunma m n ŋu, i mi la ŋgɔɔ bo i la má awieeri, na m dí má i mi jɔrɛ. I mi afite yiwee nu anya ŋgɔɔ lɛɛ. ");
INSERT INTO cko_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nahɔrɛ ye m kaaki suse am a, ka saŋga suba bo wɔ ju awie, na minɛ bo ba wu ni tí mini Nyɛmɛ Wa n nɔaniɛ ni, na bo bu tiiri i na bu deeri i, bu nyá ŋgɔɔ. ");
INSERT INTO cko_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Dama kabo ŋgɔɔ fite yiri m Si Nyɛmɛ dɔ ni, sɔ ye wɔ ma mini i Wa n gusu yiko ka m ma minɛm ŋgɔɔ a, ");
INSERT INTO cko_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","na wɔ kaaki ama m atin ka m di minɛ jɔrɛ, dama m ti Adamande Wa a. ");
INSERT INTO cko_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Má am ma ahin jɔjɔɔ­wam n yo am alekutura. Saŋga suba bo minɛ bo ba wu n kɛrɛ tí m nɔaniɛ ni, ");
INSERT INTO cko_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","na bu téŋge bu yiwee n nu. Minɛm bo bu yo yoori sakpa ni, bu téŋge na bu nya ŋgɔɔ bo i la má awieeri, na minɛm bo bu gusu yo yoori satiɛ ni, bu téŋge na bu nya sui­cin.” ");
INSERT INTO cko_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Na Yesu asa su ase ka, “M koro bo má m tiɛɛnu yo má pui. Kabo Nyɛmɛ se m ni, sɔ ye m di minɛm jɔrɛ a. Nyini ti, m jɔrɛ dii­wa n ti nahɔrɛ wɔ, dama m yo má m dɛɛ koroo­wa, ama, m yo yiri n bo wɔ sunma m n dɛɛ koroo­wa a. ");
INSERT INTO cko_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Nzɛn m di m ŋu daani kere am, am de má ka i ti nahɔrɛ, ");
INSERT INTO cko_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","ama, be wo bɛrɛ bo i di m ŋu daani. Yiri la m Si Nyɛmɛ. Na m si ka i daani dii­wa n ti nahɔrɛ wɔ. ");
INSERT INTO cko_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Am yo sunmaari minɛm Yohane dɔ, na wɔ se am nahɔrɛ, kabo m ti barasu. ");
INSERT INTO cko_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","M de má adamande daani dii­wa, ama, m kan kabo Yohane seeri am ni, adena am nya am tii. ");
INSERT INTO cko_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yohane yo ti ka fitana bo i je na i ta a, na ambɛrɛ ayo asoro su ka am wo i wein nu ni ahorejɔ fa kɔ saŋga su. ");
INSERT INTO cko_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ama, m la deke bo i di m ŋu daani bo i tara Yohane dɛɛ ni, yiri la sam bo m Si Nyɛmɛ akere m ka m yo bu wie ni. Nyini sam ni di m ŋu daani ka m Si asunma m a. ");
INSERT INTO cko_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Na m Si bo wɔ sunma m ni, yiri gusu adi m ŋu daani a. Am nya ti má i konvi, am kaaki nya ŋu má i kabo i ti barasu, ");
INSERT INTO cko_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","na i nɔaniɛ wo má am ahore su, dama wɔ sunma m am dɔ, na am ada má m ŋu. ");
INSERT INTO cko_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Am kan Nyɛmɛ Jɔrɛ Kadasi n wɔ, na am fiiti i nu, dama am sunsun ka nyini kere am atin bo am fa na am nya ŋgɔɔ bo i la má awieeri a, ama, nyini kɛrɛɛ­wam nu di m ŋu daani a. ");
INSERT INTO cko_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Haari ni nyini n mmɔɔ am akete ka am ba má m dɔ na am ba nya ŋgɔɔ. ");
INSERT INTO cko_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","M koro má kansi adamande dɔ. ");
INSERT INTO cko_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","M si am sa, na m si ka, Nyɛmɛ dɛɛ koro n wo má am ahore su. ");
INSERT INTO cko_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Mini ade m Si jinaa­biri aba, ye am ade má m, ama, nzɛn be baari ni i tiɛŋgu ba, am dé yiri wɔ. ");
INSERT INTO cko_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ambɛrɛ, am koro am ŋuŋu nu kansi wɔ, na bu susu am, ama, am koro má kansi yiri n ŋgumi bo i ti Nyɛmɛ n dɔ, nyini ti, i yo sɛ ye am koro da m ŋu a? ");
INSERT INTO cko_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Má am sunsun ka mini kɔ́ jaraki am m Si Nyɛmɛ dɔ a. Am jaraki­fɔ la Moyisi, bo am la tama ka yiri búka am ni. ");
INSERT INTO cko_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Moyisi yo kɛrɛɛri m ŋusu jɔrɛ wɔ. Nyini ti, nzɛn má am de i nɔaniɛ ni, má am de m gusu dɛɛ ni. ");
INSERT INTO cko_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ama, am ade má kabo i yo kɛrɛɛri i ni, i yó sɛ ye am koro de bo m suse am n a?” ");
INSERT INTO cko_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Nyini sin, na Yesu akpiɛ akɔ Galili kunma kpiri n bo bu kaaki fere i ka Tiberiya n buekun dɔ. ");
INSERT INTO cko_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","4","Nyini saŋga, wɔ ka kaan, na Yuda­fɔm di bu Butara cɛɛn­kpiri ni. Na jama beberebe asu i su, dama ba ŋu kabo wɔ yo alekutura sam atuntun tukpaki­fɔm na ba nya laifiɛ ni. Na Yesu ni i susu­fɔm n afun akɔ atana buka be su. ");
INSERT INTO cko_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Na Yesu atu i tii aniɛ aŋu ka jama beberebe suba i dɔ, na wɔ bisa Filipu ka, “Ya nya diire nifansu wɔ, na ya to ma ahin minɛm kɛrɛ a?” ");
INSERT INTO cko_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yiri mmɔɔ ni i tii si kabo i yó barasu, ama, i subo Filipu kunnu na i niɛ wɔ. ");
INSERT INTO cko_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Na Filipu ase i ka, “Haari nzɛn ya faari ŋwaa beberebe toori diire maari bu, i jú má bo bu kɛrɛ koro nya kan kan di.” ");
INSERT INTO cko_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Na i susu­fɔm kun bo bu fere i ka Andere, na i gɔrɔ la Simon Petoro n ase Yesu ka, ");
INSERT INTO cko_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Gbɛfɛnɛ kaan be wo ya nu fɛn, i bita kpɔnɔ nnu ni jombaa nnyɔ, ama, i koro ju má ahin minɛm kɛrɛ.” ");
INSERT INTO cko_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Wura mɔnɛ sunnu bɛrɛ, na Yesu ase i susu­fɔm ka, “Am ma minɛm kɛrɛ tantana wura n su.” Na ba ma minɛm kɛrɛ atantana. Nbiɛsɔm ŋgumi kɔ yasuuri minɛ akpii nnu wɔ. ");
INSERT INTO cko_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Na Yesu afa kpɔnɔ n na wɔ da Nyɛmɛ asi, na wɔ kpakpaaki i nu ama minɛm bo bu tantana ni, na wɔ kaaki afa jombaa n ayo i sɔ, na bu kɛrɛ anya kabo bu koro. ");
INSERT INTO cko_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Bu kɛrɛ diiri na bu kunnu yiiri ni, na wɔ se i susu­fɔm n ka, “Am tiɛntiɛn sinsin n bo ba di i na wɔ ka n nɔɔ. Má am ma be ka ŋgbɛɛn.” ");
INSERT INTO cko_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Na ba tiɛntiɛn kpɔnɔ sinsin n bo ba di i na wɔ ka n nɔɔ, na wɔ yi kandiɛ buru ni nnyɔ. ");
INSERT INTO cko_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Minɛm n ŋuuri nyini alekutura sa n bo Yesu yoori ni, na ba se ka, “Nahɔrɛ, ahin sɔnɔ n ti Nyɛmɛ nɔaniɛ kan­fɔ n bo bu seeri ka i bá durunya n nu n a.” ");
INSERT INTO cko_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesu faari nu ka bu koro ka bu tara i faŋga, na bu fa i yo bu fɛmɛ n dɛɛ ti, na wɔ yasu afite bu nu yiri ŋgumi, akɔ buka n su. ");
INSERT INTO cko_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","I naasɔ saŋga, na Yesu susu­fɔm n ajura akɔ kunma kpiri n nu, ");
INSERT INTO cko_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","na ba kɔ awura lee nu ka bu kaaki kpiɛ kɔ Kapɛnam miɛ kpiri n nu. Ale aba asan kɛrɛ, na Yesu nya ba má bu dɔ, ");
INSERT INTO cko_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","na aŋuma sukpiɛ faŋga su, na nzue nyama gusu suyasu. ");
INSERT INTO cko_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Nyini saŋga ni, i susu­fɔm n wo nzue n su akɔ aju kunma kpiri n afiɛn, na ba ŋu Yesu ka i nati nzue n su suba dodo lee ni, na sɛrɛ ati bu. ");
INSERT INTO cko_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Na Yesu ase bu ka, “Mini a, má am ma sɛrɛ ti am.” ");
INSERT INTO cko_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Na ba ma wɔ wura lee n nu. Jinaa­biri n nu bɛrɛ, na ba ju deke bo bu sukɔ ni. ");
INSERT INTO cko_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Alecin na jama n bo bu kaari kunma kpiri n buekun dɔ n afa nu ka lee kun n kpein woori kunma n su anuma n a. Na ba si nu ka Yesu susu­fɔm n ŋgumi wuraari lee n nu kɔɔri a, ama, yiri mmɔɔ ni i tii awura má nu. ");
INSERT INTO cko_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Na lee nbem afite miɛ n bo bu fere i ka Tiberiya n aba aju kunma n nɔɔ su, fa dodo deke bo Yesu sereeri Nyɛmɛ gɔɔri kpɔnɔ n su maari minɛm na bu diiri ni. ");
INSERT INTO cko_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Na jama n aniɛ, ba ŋu má Yesu ni i susu­fɔm n bɛrɛ, nyini ti, na ba wura leem n nu akɔ Kapɛnam kɔ suniɛniɛ Yesu busu. ");
INSERT INTO cko_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Minɛm n kɔ ŋuuri Yesu kunma kpiri n buekun dɔ ni, na ba bisa i ka, “Ya Kere­fɔ, saŋga bɔnɔ ye a baari fɛn a?” ");
INSERT INTO cko_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Na wɔ se bu ka, “Nahɔrɛ ye m suse am n a, má alekutura sam bo m yoori bu n ti ye am suniɛniɛ m busu a, ama, kabo m maari am diire na am kunnu ayi n dɛɛ ti a. ");
INSERT INTO cko_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Má am ma am nyunu boro diire bo i saaki n busu, ama, am ma am nyunu boro diire bo i wie má, na i ma ŋgɔɔ bo i la má awieeri n busu. Mini Adamande Wa ni má am nyini diire n a, dama mini ŋgumi, ye m Si Nyɛmɛ ase m nyaari akere ka m ti i dɛɛ a.” ");
INSERT INTO cko_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Na ba bisa i ka, “Ya yo sɛ koro yo juma n bo Nyɛmɛ koro ka ya yo i n a?” ");
INSERT INTO cko_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Na Yesu abɔ bu nu ka, “Juma n bo Nyɛmɛ koro ka am yo i n la ka, am yo mini bo wɔ sunma m yarada.” ");
INSERT INTO cko_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Na ba bisa i ka, “Ye a yó nzu alekutura sa kere ya, na ya ŋu i na ya yo u yarada? A yó sa bɔnɔ ɔ? ");
INSERT INTO cko_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Dama saŋga bo ya nam yo woori boro kpantain nu ni, bu diiri diire be bo bu fere i ka mana n wɔ. Kabo ba kɛrɛ i Nyɛmɛ Jɔrɛ Kadasi n nu lɛɛ, ka yiri maari bu diire n bo i fite aŋgoro ye bu diiri a.” ");
INSERT INTO cko_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Na Yesu ase bu ka, “Nahɔrɛ ye m suse am n a, má Moyisi yo maari nyini diire n bo i fite aŋgoro n a, ama, m Si Nyɛmɛ maari am diire n bo i fite aŋgoro nahɔrɛ su a. ");
INSERT INTO cko_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Dama diire n bo Nyɛmɛ ma n la bo i fite aŋgoro, na i ba ma durunya n nu­fɔm ŋgɔɔ ni.” ");
INSERT INTO cko_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Na ba se i ka, “Ya Mibiɛ, ŋka a ma ya nyini diire n saŋga kɛrɛ.” ");
INSERT INTO cko_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Na Yesu ase bu ka, “Mini ti diire n bo i ma ŋgɔɔ n a. Sɔnɔ kɛrɛ bo i ba m dɔ, ahɔɛ ti má i mi, na sɔnɔ kɛrɛ bo i yo m yarada, nzuehɔɛ ti má i mi kun. ");
INSERT INTO cko_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ama, ma se am, haari ni bo am aŋu m n kɛrɛ, am suyo má m yarada. ");
INSERT INTO cko_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Sɔnɔ kɛrɛ bo m Si fa i maari m, i bá m dɔ, na wɔrɔ kɛrɛ bo a ba m dɔ, m kéte má u fieo. ");
INSERT INTO cko_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Dama ma fite má aŋgoro aba má ka m ba yo m dɛɛ koroo­wa, ama, m baari ka m ba yo Nyɛmɛ bo wɔ sunma m dɛɛ koroo­wa a. ");
INSERT INTO cko_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Yiri n bo wɔ sunma m dɛɛ koroo­wa la ka, minɛm kɛrɛ bo wɔ fa ama m ni, má m ma bu be mmɔɔ mini, ama, i koro ka m teŋge bu kɛrɛ jina cɛɛn na bu nya ŋgɔɔ. ");
INSERT INTO cko_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Dama m Si koroo­wa la ka, sɔnɔ kɛrɛ bo i ŋu mini i Wa n na i yo m yarada, i mi nyá ŋgɔɔ bo i la má awieeri, na m téŋge i jina cɛɛn.” ");
INSERT INTO cko_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","I seeri ka yiri ti diire n bo wɔ fite aŋgoro aba n dɛɛ ti, na minɛm ni suŋuŋuti i. ");
INSERT INTO cko_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Na ba se ka, “Má Yosefu wa Yesu n lɛɛ? Ya si i si ni i ni kɛrɛ e. Ye i baari sɛ, ye i ŋa i fiteeri aŋgoro baari a?” ");
INSERT INTO cko_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Na Yesu ase bu ka, “Má am ŋuŋuti am ŋuŋu nu. ");
INSERT INTO cko_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Be koro ba má m dɔ, má ka m Si Nyɛmɛ bo wɔ sunma m ni, acin i mi adodo m, na m téŋge i mi jina cɛɛn. ");
INSERT INTO cko_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Kabo Nyɛmɛ nɔaniɛ kan­fɔm yo kɛrɛɛri lɛɛ, ka, ‘Nyɛmɛ kére sɔnɔ kɛrɛ nyaari a.’ Na sɔnɔ kɛrɛ bo i ti Nyɛmɛ keree­wa n na i siiri nu, i mi bá m dɔ. ");
INSERT INTO cko_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Nyini kere má ka be adu mɔ aŋu Nyɛmɛ wɔ lɛɛ, má ka mini ŋgumi bo m fite m Si Nyɛmɛ dɔ n aŋu i a. ");
INSERT INTO cko_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Nahɔrɛ ye m suse am n a, ka sɔnɔ kɛrɛ bo i yo m yarada, i la ŋgɔɔ bo i la má awieeri. ");
INSERT INTO cko_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Mini ti diire n bo i ma ŋgɔɔ n a. ");
INSERT INTO cko_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Am nam yo diiri diire n bo bu fere i ka mana n boro kpantain nu, ama, na ba wu. ");
INSERT INTO cko_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ama, ahin diire n ti diire barasu be bo i fite aŋgoro wɔ, na sɔnɔ kɛrɛ bo i diiri i, i wú má. ");
INSERT INTO cko_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Mini ti diire n bo wɔ fite aŋgoro aba, na i ma ŋgɔɔ n a. Sɔnɔ kɛrɛ bo i di ahin diire ni, i nyá ŋgɔɔ bo i la má awieeri. Diire n bo m má n la m ŋuniɛ­mbaa ni, bo m fá ma durunya n nu­fɔm, na bu nyá ŋgɔɔ ni.” ");
INSERT INTO cko_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Yesu seeri sɔ ni, na yaa ati bu, na bu suse akuruwa bu ŋuŋu nu ka, “Ahin sɔnɔ ni yo sɛ koro fa i ŋuniɛ ma ya na ya di a?” ");
INSERT INTO cko_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Na Yesu ase bu ka, “Nahɔrɛ ye m suse am n a, má ka am di mini Adamande Wa n ŋuniɛ­mbaa ni, na am nu m dɛɛ mbunja ni, ambɛrɛ ni am tii la má ŋgɔɔ n bo i la má awieeri ni. ");
INSERT INTO cko_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Sɔnɔ kɛrɛ bo i di m dɛɛ ŋuniɛ­mbaa ni, na i nu m mbunja ni, i mi la ŋgɔɔ n bo i la má awieeri ni, na m téŋge i mi jina cɛɛn. ");
INSERT INTO cko_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Dama m dɛɛ ŋuniɛ­mbaa ni, ti deke bo i ti diire nahɔrɛ su a, na m mbunja n ti deke bo i ti nuu­wa nahɔrɛ su a. ");
INSERT INTO cko_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Sɔnɔ kɛrɛ bo i di m dɛɛ ŋuniɛ­mbaa ni, na i nu m mbunja ni, i mi wo ni mini, na mini gusu wo ni yiri lɛɛ. ");
INSERT INTO cko_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Yiri m Si bo i ma ŋgɔɔ ni sunmaari m a, i dɛɛ ti, ye m la ŋgɔɔ a, sɔ ye sɔnɔ kɛrɛ bo i di m ŋuniɛ­mbaa ni, mini dɛɛ ti, ye i nyá ŋgɔɔ a. ");
INSERT INTO cko_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ahin ni ti diire n bo wɔ fite aŋgoro aba n a, i ti má ka diire n bo am nam yo diiri na i sin na bu wuuri ni. Sɔnɔ kɛrɛ bo i di ahin diire ni, i nyá ŋgɔɔ n bo i la má awieeri.” ");
INSERT INTO cko_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu kereeri nyini keree­wa n kɛrɛ saŋga bo i wo Kapɛnam bu tiɛntiɛn­bunɔɔ sɔɔ nu n wɔ. ");
INSERT INTO cko_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Yesu susu­fɔm dɔŋgu tiiri i jɔjɔɔ­wa n sɔ ni, na ba se ka, “Ahin keree­wa n ti kekereke. Ŋma koro de i a?” ");
INSERT INTO cko_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Na Yesu afa nu ka bu suŋuŋuti fa kɔ i keree­wa n su, na wɔ se bu ka, “Ahin jɔjɔɔ­wa n dɛɛ ti ye am koro ka am kaaki am sin n a? ");
INSERT INTO cko_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ye nzɛn má am ŋu ka mini Adamande Wa n sukaaki sufun kɔ aŋgoro, deke bo m fite baari ni, má am se sɛ wɔ lɛɛ? ");
INSERT INTO cko_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Awiɛwiɛ Casi ni ma minɛ ŋgɔɔ a. Adamande yiko be koro ma má ŋgɔɔ. Nɔaniɛ n bo ma jɔjɔ akere am ni, yiri ma am nya Awiɛwiɛ Casi n bo i ma ŋgɔɔ n a. ");
INSERT INTO cko_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ama, am be n mmɔɔ ada má m ŋu.” Má pui ti, fite saŋga bo Yesu boori i juma n bu ni, ye i si bo bu yo má i yarada n a, ni sɔnɔ n bo i bá tɔ i ni. ");
INSERT INTO cko_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Na wɔ se bu ka, “Nyini dɛɛ ti ye ma se am ka be wo má bɛrɛ bo i koro ba m dɔ, má ka m Si ama atin ka i mi yo m susu­fɔ.” ");
INSERT INTO cko_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","I seeri sɔ n sin, na i susu­fɔm dɔŋgu akaaki ayaki i ka bu su má i su kun. ");
INSERT INTO cko_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Na wɔ bisa i susu­fɔ buru ni nnyɔm ni ka, “Ambɛrɛ gusu koro ka am kaaki yaki m wɔ fan?” ");
INSERT INTO cko_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Na Simon Petoro abɔ i nu ka, “M Mibiɛ, ya kɔ́ ŋma dɔ a? Wɔrɔ ti sɔnɔ n bo i la nɔaniɛ n bo i ma ŋgɔɔ n bo i la má awieeri n a. ");
INSERT INTO cko_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ye ya yo u yarada, na ya si ka wɔrɔ ti sɔnɔ casi n bo a fite Nyɛmɛ dɔ n a.” ");
INSERT INTO cko_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Na Yesu abɔ nu ka, “M ŋa am buru ni nnyɔ ye m yiiri am e, má sɔ? Ama, am nu kun ti Sitana sɔnɔ ɔ.” ");
INSERT INTO cko_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","I jɔjɔ niiri Yudasi wɔ, Simon Isikariyoti wa ni. Yiri Yudasi tiiri buru ni nnyɔm ni kun wɔ, ama, yiri bá tɔ Yesu n a. ");
INSERT INTO cko_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Nyini sin na Yesu afa Galili awɔrɛ n nu subara yɛ, wɔ koro má ka i kɔ Yudiya dɛɛ awɔrɛ n nu, dama Yuda­fɔm nkpiɛn­kpiɛnm koro ka bu kun i wɔ. ");
INSERT INTO cko_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Nyini saŋga, wɔ ka kaan na Yuda­fɔm di bu cɛɛn­kpiri be bo bu fere i ka Nambue Bo cɛɛn­kpiri ni. ");
INSERT INTO cko_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Na Yesu niɛmam ase i ka, “Fite ahin awɔrɛ n nu na a kɔ Yudiya, adena u susu­fɔm gusu kɔ́ ŋu sam bo a yo bu ni. ");
INSERT INTO cko_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Dama sɔnɔ kɛrɛ bo i koro ka minɛ si kabo i ti barasu, i fa má i sa­yoo­wa fiɛ má minɛm sin, nzɛn a yo alekutura sam wɔ, ma durunya n nu­fɔm kɛrɛ si u sa.” ");
INSERT INTO cko_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","I niɛmam n mmɔɔ ayo má i yarada, nyini ti ye bu seeri sɔ n a. ");
INSERT INTO cko_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Na Yesu ase bu ka, “M saŋga nya ju má, ama, ambɛrɛ yiri, saŋga kɛrɛ bo am koro, am kɔ ɔ. ");
INSERT INTO cko_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ambɛrɛ ye durunya n nu­fɔm koro kpɔ má am a, ama, bu kpɔ mini wɔ, dama m se bu wɔ, ka bu sa­yoo­wam ti má kpa. ");
INSERT INTO cko_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Am kɔ cɛɛn­kpiri n di, m kɔ́ má, dama m saŋga nya ju má.” ");
INSERT INTO cko_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","I seeri bu sɔ ni, na wɔ ka Galili dɔ lee nnyɔ. ");
INSERT INTO cko_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","I niɛmam kɔɔri ka bu kɔ di cɛɛn­kpiri ni, na Yesu gusu aba asa bu su, ama, wɔ yi má i ŋu fofoe nu, i fiɛ kɔɔri a. ");
INSERT INTO cko_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Na Yuda­fɔm nkpiɛn­kpiɛnm ni suniɛniɛ i, na ba bisa ka, “Ye i wo ni wɔ?” ");
INSERT INTO cko_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Na jama n sutu asuturi bu beŋgu dɔ i busu. Nbem ŋa, “I ti sɔnɔ kpa a.” Ye nbem gusu ŋa, “Ai, i dadaka minɛm wɔ.” ");
INSERT INTO cko_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ama, be akoro akan má i jɔrɛ fofoe nu, dama bu kɛrɛ soro Yuda­fɔm nkpiɛn­kpiɛnm n wɔ. ");
INSERT INTO cko_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Saŋga bo ba di cɛɛn­kpiri n akɔ aju afiɛn ni, na Yesu akɔ awura Nyɛmɛ Seree­biri Awuru n nu, sukere minɛm. ");
INSERT INTO cko_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Na Yuda­fɔm nkpiɛn­kpiɛnm n ayo alekutura, na ba bisa ka, “I yo sɛ ye ahin sɔnɔ n la nyini si n ŋusu sɔ a, bo be akere má i a?” ");
INSERT INTO cko_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Na Yesu ase bu ka, “Deke bo m fa kere am ni, i ti má m tiɛŋgu keree­wa, ama, m Si Nyɛmɛ bo wɔ sunma m ni, yiri kere m kabo m kere a. ");
INSERT INTO cko_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Sɔnɔ kɛrɛ bo i ŋa i yó Nyɛmɛ koroo­wa ni, ye i sí kabo m keree­wa n ti a, nzɛn m keree­wa n fite Nyɛmɛ dɔ, wara m tiɛŋgu keree­wa. ");
INSERT INTO cko_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Sɔnɔ kɛrɛ bo i jɔjɔ i koroya­nu, i mi koro ka bu kansi i wɔ, ama, bo i koro ka bu kansi sɔnɔ bo i sunma i ni, nyini sɔnɔ ni jɔjɔ nahɔrɛ a, na kɔrɛ be wo má i ŋu. ");
INSERT INTO cko_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","M ŋa Moyisi yo maari am Nyɛmɛ nɔaniɛ kpamaa­wa n a, má sɔ? Ama, am be n mmɔɔ su má i atin su. Ye nzu ti ye am koro ka am kun m a?” ");
INSERT INTO cko_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Na jama n ase i ka, “Ajini wo u ŋu. Ŋma koro ka i kun u a?” ");
INSERT INTO cko_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Na Yesu ase bu ka, “Sa kun be lɛɛ, ye ma yo i n a, ye wɔ yo am kɛrɛ alekutura n a. ");
INSERT INTO cko_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moyisi yo maari am nɔɔ ka am wura am nbaa­biɛsɔm kɛnkɛnnɛ le­mɔcuɛ cɛɛn, nzɛn haari i tɔ Ŋumi­yi cɛɛn n mmɔɔ, am yo i, ama, má Moyisi yo boori i bu ka bu wura kɛnkɛnnɛ n a, am nam yo boori i bu a. ");
INSERT INTO cko_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Am wura nbaa­biɛsɔm kɛnkɛnnɛ Ŋumi­yi cɛɛn wɔ, adena má am bu nɔaniɛ kpamaa­wa n bo Nyɛmɛ fa maari Moyisi ni ŋgbɛɛn, ye nzɛn ma tuntun sɔnɔ mɔmɔ kun Ŋumi­yi cɛɛn n na wɔ nya laifiɛ, nzu ti ye am afa yaa m ŋu a? ");
INSERT INTO cko_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Má am niɛ sɔnɔ nyunu dika na am di i jɔrɛ, ama, am si i wo nahɔrɛ su, na am nya di i jɔrɛ.” ");
INSERT INTO cko_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Yesu seeri sɔ ni, na Yɛrusalem­fɔm nbem abisa bu ŋuŋu nu ka, “Má ahin sɔnɔ n ye Yuda­fɔm nkpiɛn­kpiɛnm koro ka bu kun i n a? ");
INSERT INTO cko_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Am niɛ e. Wɔ yi i ŋu fofoe nu ye i jɔjɔ a. Be suse má i pui mmɔɔ. Beni, Yuda­fɔm nkpiɛn­kpiɛnm asi ka yiri ti Kristo Tii­de­fɔ n nahɔrɛ su n a. ");
INSERT INTO cko_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ama, saŋga bo Kristo Tii­de­fɔ n ba baari, be sí má deke bo i fite. Ahin sɔnɔ n yiri, ya si deke bo i fite.” ");
INSERT INTO cko_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Na saŋga bo Yesu sukere Nyɛmɛ Seree­biri Awuru n nu ni, na wɔ tiɛn faŋga su ase ka, “Am sunsun ka am si m nahɔrɛ su, nzɛn sɛ? Ye am si deke bo m fite? Ma ba má ni m dɛɛ yiko nu wɔ. Yiri n bo wɔ sunma m ni ti nahɔrɛ­fɔ a, ama, am si má i. ");
INSERT INTO cko_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Mini si i a, dama m fite i dɔ ɔ, yiri sunmaari m a.” ");
INSERT INTO cko_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Nyini ti, na ba kpi ka bu tara i, ama, be afa má i saa akan má i, dama i saŋga nya ju má. ");
INSERT INTO cko_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Na jama n dɔŋgu ayo i yarada, na ba se ka, “Saŋga bo Kristo Tii­de­fɔ n ba baari, i yó alekutura sam tara ahin sɔnɔ n wɔ, nzɛn sɛ?” ");
INSERT INTO cko_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Na Farasi­fɔm n ati kabo jama n sutu asuturi sukan Yesu jɔrɛ, na bu ni Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ nkpiɛn­kpiɛnm n asunma tintini­jina­fɔm ka bu kɔ tara i. ");
INSERT INTO cko_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Na wɔ se ka, “M wó am dɔ saŋga kaan, na m nya bá kɔ yiri n bo i sunmaari m n dɔ. ");
INSERT INTO cko_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Am bá niɛniɛ m busu, na am ŋú má m. Deke bo m bá wo ni, am koro kɔ má dɔ.” ");
INSERT INTO cko_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Na Yuda­fɔm nkpiɛn­kpiɛnm n abisa bu ŋuŋu nu ka, “Yiri koro ka i kɔ ni wɔ, ye yɛrɛ koro ŋu má i a? I kɔ́ ya minɛm dɔ ɔ, bo ba sandi awura Giriki­fɔm asiɛn su ni, na i kɔ́ kere Giriki­fɔm ni Nyɛmɛ jɔrɛ ni, nzɛn sɛ a? ");
INSERT INTO cko_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","I ŋa sɛ wɔ lɛɛ? Bo i ŋa ya bá niɛniɛ i busu na ya ŋú má i ni, na bekun, deke bo i sukɔ ni, ya koro kɔ má dɔ.” ");
INSERT INTO cko_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Cɛɛn­kpiri n awieeri cɛɛn n ti cɛɛn­kpiri n tii a. Nyini cɛɛn n na Yesu ayasu ajina, na wɔ tiɛn faŋga su ase ka, “Sɔnɔ kɛrɛ bo nzuehɔɛ ati i, i mi bra m dɔ na i ba nu. ");
INSERT INTO cko_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Dama ba kɛrɛ i Nyɛmɛ Jɔrɛ Kadasi n nu ka, sɔnɔ kɛrɛ bo i yo m yarada, ‘Nzuetin bo i ma ŋgɔɔ ni, i sóŋgi fite i mi ahore­mbaa su a.’” ");
INSERT INTO cko_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesu jɔjɔ niiri Awiɛwiɛ Casi n wɔ, ka sɔnɔ kɛrɛ bo i yo yiri Yesu yarada nyá Awiɛwiɛ Casi ni. Nyini saŋga ni, Nyɛmɛ nya fa má i Awiɛwiɛ Casi n ma má, dama wɔ nya wura má Yesu kpiri. ");
INSERT INTO cko_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Na jama n nu minɛ nbem tiiri kabo i seeri sɔ ni, na ba se ka, “Ahin sɔnɔ n ti Nyɛmɛ nɔaniɛ kan­fɔ n wɔ nahɔrɛ su.” ");
INSERT INTO cko_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Na nbem ase ka, “Yiri ti Kristo Tii­de­fɔ n a.” Ama, na nbem gusu ase ka, “Kristo Tii­de­fɔ ni fite má Galili da. ");
INSERT INTO cko_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ba kɛrɛ i Nyɛmɛ Jɔrɛ Kadasi n nu ka Kristo Tii­de­fɔ ni yó Fɛmɛ Davidi anuma a, na bu wú i Bɛtilɛhɛm, Fɛmɛ Davidi bɔsu wɔ.” ");
INSERT INTO cko_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Yesu dɛɛ ti, na jama n nɔɔ awo bu ŋguŋgumi, ");
INSERT INTO cko_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","na nbem akoro ka bu tara i, ama, be afa má i saa akan má i. ");
INSERT INTO cko_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Na tintini­jina­fɔm n akpie bu nyi akɔ Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm ni, ni Farasi­fɔm n dɔ, na ba bisa bu ka, “Nzu ti ye am afa má i aba má?” ");
INSERT INTO cko_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Na tintini­jina­fɔm n abɔ bu nu ka, “Be nya koro jɔjɔ má kabo nyini sɔnɔ n jɔjɔ ni.” ");
INSERT INTO cko_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Na Farasi­fɔm n abisa bu ka, “Wɔ daka ambɛrɛ gusu wɔ fan? ");
INSERT INTO cko_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Am nya ti ka Yuda­fɔm nkpiɛn­kpiɛnm wara Farasi­fɔm n be ayo i yarada a? ");
INSERT INTO cko_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ama, ahin jama n si má Nyɛmɛ nɔaniɛ kpamaa­wa ni, nyini ti, Nyɛmɛ ayo bu ŋgbɛɛn.” ");
INSERT INTO cko_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Na Nikodemo bo i ti Farasi­fɔm kun n na i yo kɔ ŋuuri Yesu ni, ase bu ka, ");
INSERT INTO cko_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Ya dɛɛ atin n su, kana ya ba di sɔnɔ jɔrɛ jaraki i, má ka ya bisa i na ya ti sa bo wɔ yo i n ka.” ");
INSERT INTO cko_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Na ba bisa i ka, “Wɔrɔ n mmɔɔ fite Galili wɔ? Kan Nyɛmɛ Jɔrɛ Kadasi n na a niɛ. A ŋú má ka Nyɛmɛ nɔaniɛ kan­fɔ n be mmɔɔ fite Galili.”  ");
INSERT INTO cko_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Bu se sɔ wieeri ni, na bu kɛrɛ asandi akɔ awuru. ");
INSERT INTO cko_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Na Yesu akɔ buka n bo bu fere i ka Oliva Buka n su, dama oliva bakam gɔ su wɔ. ");
INSERT INTO cko_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Alecin ŋgarama fuun na Yesu akaaki akɔ Nyɛmɛ Seree­biri Awuru n nu. Na jama n kɛrɛ aba atiɛn bu nɔɔ i dɔ. Na wɔ tana sukere bu Nyɛmɛ nɔaniɛ. ");
INSERT INTO cko_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Na Nyɛmɛ nɔaniɛ kere­fɔm, ni Farasi­fɔm nbem afa bara ajaa­fɔ be bo bu kɔ taraari i ka i ni biɛsɔ da, na ba fa i ajina bu afiɛn. ");
INSERT INTO cko_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Na ba se Yesu ka, “Ya Kere­fɔ, ya kɔ atara ahin bara n ka i susaaki ajaa ciire wɔ. ");
INSERT INTO cko_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Nɔaniɛ kpamaa­wa n bo Nyɛmɛ fa maari Moyisi n kere ka, nyini nbaram ŋusu sɔ, ya tu bu yabuɛ bo kun bu. Nyini ti, ye wɔrɔ ŋa sɛ?” ");
INSERT INTO cko_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Bu seeri sɔ n na bu sɔ i ŋgɛɛ, na bu jaraki i wɔ. Na Yesu abiri i tii asiɛŋgu sufa i saa maraka sukɛrɛ asiɛŋgu. ");
INSERT INTO cko_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Bu wo i bisa n su ni, na wɔ yɛ i tii su ase bu ka, “Bo i ŋa wɔ nya yo má satiɛ am nu, ma i mi du mɔ tu i yabuɛ.” ");
INSERT INTO cko_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Na wɔ kaaki abiri i tii sukɛrɛ asiɛŋgu. ");
INSERT INTO cko_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Bu tiiri sɔ ni, na bu kɛrɛ alɔrɔki kun kun akɔ. Nkpiɛnm ni du mɔ a. Na wɔ ka Yesu ni bara ni ŋgumi. ");
INSERT INTO cko_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Na Yesu ayɛ i tii su, na wɔ bisa bara n ka, “Bara, bu wo ni? Be ase má ka i ti ye ni ka bu kun u, nzɛn sɛ?” ");
INSERT INTO cko_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Na bara n abɔ i nu ka, “Ai, m Mibiɛ, be ase má ka i kún m.” Na Yesu ase i ka, “Mini mmɔɔ se má ka be kún u. Kɔ, ama, má a yo satiɛ kun.” ");
INSERT INTO cko_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Na Yesu akaaki ase jama n ka, “Mini ti durunya n nu­fɔm wein a. Bo i su m su kɛrɛ wo má awosin nu kun, ama, i nyá wein bo i ma ŋgɔɔ ni.” ");
INSERT INTO cko_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Na Farasi­fɔm n ase i ka, “Wɔrɔ, a sudi u ŋu daani wɔ, be de má u daani n ka i ti nahɔrɛ.” ");
INSERT INTO cko_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Na Yesu ase bu ka, “Haari nzɛn m di m ŋu daani n mmɔɔ, m daani dii­wa n ti nahɔrɛ wɔ, dama m si deke n bo m fite baari, na m kaaki si deke bo m sukɔ ni. Ama, ambɛrɛ, am si má deke bo m fite, na am kaaki si má deke bo m sukɔ n gusu. ");
INSERT INTO cko_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ambɛrɛ, am di jɔrɛ kabo durunya n nu­fɔm di bu beŋgum jɔrɛ n wɔ, ama, mini ni m tii, m di má be jɔrɛ. ");
INSERT INTO cko_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ama, haari nzɛn m di minɛ jɔrɛ n mmɔɔ, m jɔrɛ dii­wa n ti nahɔrɛ wɔ, dama má mini ŋgumi di minɛm jɔrɛ a, ama, mini ni m Si bo i sunmaari m ni di a. ");
INSERT INTO cko_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ba kɛrɛ am Nyɛmɛ nɔaniɛ kpamaa­wa n nu ka, nzɛn minɛ nnyɔ daani dii­wa yo kun, nyini la ka i ti nahɔrɛ wɔ lɛɛ. ");
INSERT INTO cko_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Mini ni m tii di m ŋu daani a, na m Si bo wɔ sunma m gusu di m daani.” ");
INSERT INTO cko_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Na ba bisa i ka, “U si wo ni?” Na wɔ bɔ bu nu ka, “Am si má m ni m Si n be n mmɔɔ. Nzɛn má am si mini, má am si m Si n mmɔɔ.” ");
INSERT INTO cko_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Saŋga bo Yesu seeri sɔ ni, i wo minɛm kere su Nyɛmɛ Seree­biri Awuru n nu, fa dodo deke bo bu yi bu saraka ŋwaa fa ma Nyɛmɛ n wɔ. Ama, be akoro atara má i, dama i saŋga nya ju má. ");
INSERT INTO cko_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Na Yesu akaaki ase bu ka, “M bá kɔ yaki am, na am bá niɛniɛ m busu, ama, am ŋú má m, na am bá wu ni am satiɛ ni. Deke bo m sukɔ ni, am koro kɔ má dɔ.” ");
INSERT INTO cko_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Na Yuda­fɔm n abisa ka, “I ŋa deke bo i sukɔ ni, ya koro kɔ má dɔ. Nyini la ka, i kún i ŋu wɔ lɛɛ, nzɛn sɛ a?” ");
INSERT INTO cko_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Na wɔ se bu ka, “Ambɛrɛ fite durunya n nu fɛn wɔ, ama, mini fite aŋgoro wɔ. Ambɛrɛ ti durunya n nu fɛn fɔm wɔ, ama, mini fite má durunya n nu fɛn. ");
INSERT INTO cko_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Nyini ti ye ma se am ka, am wú ni am satiɛ n a, dama nzɛn am yo má m yarada ka mini la sɔnɔhɔrɛ n bo m se am ka m ti ni, am wú ni am satiɛ n wɔ.” ");
INSERT INTO cko_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Na ba bisa i ka, “Ye wɔrɔ la ŋma a?” Na Yesu ase bu ka, “Kabo m se am saŋga kɛrɛ ni, m ti sɔ ɔ. ");
INSERT INTO cko_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","M la sa dɔŋgu bo m jɔjɔ fa kɔ am dɔ, na m la sa dɔŋgu bo m fa di am jɔrɛ jaraki am, ama, yiri bo i sunmaari m ti nahɔrɛ­fɔ ɔ, na deke bo i se m ni, nyini ye m kan kere durunya n nu­fɔm a.” ");
INSERT INTO cko_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Yesu seeri sɔ ni, ba si má ka i jɔjɔ niiri i Si Nyɛmɛ wɔ. ");
INSERT INTO cko_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Na wɔ se bu ka, “Am bá yɛɛri mini Adamande Wa n su baka jaanu n su, ye am sí ka mini la sɔnɔhɔrɛ n bo m se am kabo m ti n a, na m yo má deke be m dɛɛ yiko nu, ama, m se kabo m Si akere m wɔ. ");
INSERT INTO cko_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Yiri bo i sunmaari m n wo m dɔ, wɔ nya yaki má m cɛɛn be, dama saŋga kɛrɛ m yo deke bo i sun i nu wɔ.” ");
INSERT INTO cko_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","I jɔjɔɔri sɔ ni, na jama n dɔŋgu ayo i yarada. ");
INSERT INTO cko_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Na Yesu ase Yuda­fɔm bo bu yo i yarada n ka, “Nzɛn am de m nɔaniɛ ni, am ti m susu­fɔm wɔ nahɔrɛ su. ");
INSERT INTO cko_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Na am sí deke bo i ti nahɔrɛ ni, na nahɔrɛ ni má am nya am tii a.” ");
INSERT INTO cko_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Na ba se i ka, “Ya ti Abraham anumam wɔ, be nya fa má ya yo má i akɔɔm. Ye nzu ti ye a ŋa ya nyá ya tii a?” ");
INSERT INTO cko_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Na Yesu ase bu ka, “Nahɔrɛ ye m suse am a, ka, sɔnɔ kɛrɛ bo i yo satiɛ, i mi ti satiɛ akɔɔ. ");
INSERT INTO cko_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Akɔɔ­baa koro ka má awuru n nu saŋga kɛrɛ, ama, awuru­baa yiri wo awuru n nu wɔ saŋga kɛrɛ. ");
INSERT INTO cko_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Nyini ti, nzɛn mini awuru­baa n nya deeri am tii jiiri, am nyá am tii nahɔrɛ su. ");
INSERT INTO cko_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","M si ka am ti Abraham anumam wɔ, ama, am koro ka am kun m wɔ, dama am ade má m nɔaniɛ ni. ");
INSERT INTO cko_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Deke bo mini aŋu i m Si dɔ n ye m suse am a, ama, ambɛrɛ, deke bo am ti i am si dɔ, ye am yo a.” ");
INSERT INTO cko_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Na ba se i ka, “Ya si la Abraham.” Na wɔ se bu ka, “Nzɛn má am ti Abraham nbaam, má am yo i sa­yoo­wa a. ");
INSERT INTO cko_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Kabo i ti ni, ma se am nahɔrɛ sam bo m tiiri i Nyɛmɛ dɔ n wɔ, ama, am koro ka am kun m wɔ. Abraham ayo má nyini be sɔ. ");
INSERT INTO cko_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ambɛrɛ, am yo am si sa­yoo­wa a.” Na ba se i ka, “Yɛrɛ, ya ti má soma nbaam. Ya si la Nyɛmɛ ŋgumi wɔ.” ");
INSERT INTO cko_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Na Yesu ase bu ka, “Nzɛn má Nyɛmɛ ti am Si, má am koro m, dama m fiteeri Nyɛmɛ dɔ ɔ, ye m baari fɛn n a. Ma ba má ni m dɛɛ yiko nu, ama, yiri sunmaari m a. ");
INSERT INTO cko_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Nzu ti ye am ti má m jɔjɔɔ­wa n bu a? Dama am koro de má m nɔaniɛ n dɛɛ ti. ");
INSERT INTO cko_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Sitana ti am si wɔ, na am koro ka am yo kabo am si koro n wɔ, i fite ka i bumboori kɛrɛ, i ti sɔnɔ kun­fɔ ɔ, na i su má nahɔrɛ su, dama nahɔrɛ haari kun mmɔɔ wo má i dɔ, i dɛɛ la ka i bu kɔrɛ wɔ, dama yiri ti kɔrɛ­fɔ a, na yiri kaaki ti kɔrɛ­fɔm kɛrɛ si a. ");
INSERT INTO cko_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ama, mini se nahɔrɛ n ti, am de má m nɔaniɛ ni. ");
INSERT INTO cko_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Am ŋma koro kere m satiɛ bo ma yo i a? Nzu ti ye m se am nahɔrɛ, ye am de má m nɔaniɛ n a? ");
INSERT INTO cko_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Sɔnɔ kɛrɛ bo i ti Nyɛmɛ dɛɛ, i mi ti Nyɛmɛ nɔaniɛ wɔ. Deke bo i ti na am ti má Nyɛmɛ nɔaniɛ n la ka, am ti má i dɛɛm wɔ.” ");
INSERT INTO cko_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Na Yuda­fɔm n ase i ka, “Bo ya ŋa a ti Samariya­fɔ ɔ, na ajini wo u ŋu ni, i ti má nahɔrɛ wɔ, nzɛn sɛ a?” ");
INSERT INTO cko_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Na Yesu ase bu ka, “Ajini wo má m ŋu, ama, m bu m Si n wɔ, ye ambɛrɛ bu má m. ");
INSERT INTO cko_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","M sukoro má ka minɛ wura m ŋu kpiri wɔ, be wo bɛrɛ bo i koro ka i wura m kpiri, yiri ti jɔrɛ­di­fɔ a. ");
INSERT INTO cko_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nahɔrɛ ye m suse am a, ka, sɔnɔ kɛrɛ bo i bita m nɔaniɛ ni, i mi wú má fieo.” ");
INSERT INTO cko_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Na ba se i ka, “Kisa, ye ya si ka ajini wo u ŋu a. Abraham ni Nyɛmɛ nɔaniɛ kan­fɔm ni kɛrɛ awu, ama, wɔrɔ ŋa sɔnɔ kɛrɛ bo i bita u nɔaniɛ ni, i mi wú má fieo. ");
INSERT INTO cko_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","A tara ya si Abraham bo wɔ wu n wɔ? I ni Nyɛmɛ nɔaniɛ kan­fɔm kɛrɛ awu. A bu u ŋu sɛ wɔ?” ");
INSERT INTO cko_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Na Yesu ase bu ka, “Nzɛn m wura m ŋu kpiri, i ti ŋgbɛɛn wɔ. M Si wura m kpiri a, yiri bo am ŋa i ti am Nyɛmɛ ni, ");
INSERT INTO cko_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","ama, am si má i. Mini si i a. Haari nzɛn m ŋa m si má i, m yó kɔrɛ­fɔ ka ambɛrɛ wɔ. Ama, m si i, na m bita i nɔaniɛ ni. ");
INSERT INTO cko_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","I yoori am si Abraham fiɛ ka i ŋu m ba n nu, i ŋuuri i, na i ahore ajɔ.” ");
INSERT INTO cko_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Na ba se i ka, “A nya ju má afɔ aburu­nu, ye i yo sɛ ye a ŋa a ŋuuri Abraham a?” ");
INSERT INTO cko_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Na Yesu ase bu ka, “Nahɔrɛ ye m suse am a, kana bu ba wuuri Abraham ni, mini wo bɛrɛ wɔ.” ");
INSERT INTO cko_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","I seeri sɔ ni, na ba fa yabuɛ ka bu bo kun i, ama, na wɔ lɔrɔki afite Nyɛmɛ Seree­biri Awuru n nu. ");
INSERT INTO cko_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Na saŋga bo Yesu wo natiiri su ni, na wɔ ŋu sɔnɔ be, bu wuuri i ni, i ti anyinsin wɔ. ");
INSERT INTO cko_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Na i susu­fɔm n abisa i ka, “Ya Kere­fɔ, nzu ti ye bu wuuri ahin sɔnɔ ni anyinsin a? I wu­fɔm yoori satiɛ, nzɛn i dɛɛ satiɛ a?” ");
INSERT INTO cko_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Na Yesu ase bu ka, “I ti má i ni i wu­fɔm be mmɔɔ satiɛ dɛɛ ti, ama, Nyɛmɛ koro ka minɛm ŋu kabo i yo alekutura sa fa ma i a. ");
INSERT INTO cko_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Kabo wiɛ toko wo bɛrɛ ni, am ma ya yo yiri n bo wɔ sunma m juma ni. Ale bá san bo be koro yo má juma be. ");
INSERT INTO cko_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Kabo m toko wo durunya n nu ni, mini ti durunya n nu­fɔm wein a.” ");
INSERT INTO cko_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Yesu seeri sɔ ni, na wɔ yi nanzue agɔ asiɛŋgu, na wɔ fa akpita naatiɛ afa abɔrɔki anyinsin nyu­mbaa nnyɔ n kɛrɛ. ");
INSERT INTO cko_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Na wɔ se i ka, “Kɔ na a kɔ ŋmisi u nyunu Silowam bura n nu.” Silowam n bu la ka, ba sunma i wɔ. Na wɔ kɔ aŋmisi i nyunu n na wɔ ŋu asi, na wɔ kaaki aba awuru. ");
INSERT INTO cko_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Na i lamɔkɔm ni minɛm bo bu yo ŋuuri i saŋga kɛrɛ ka i sere ni, abisa ka, “Má ahin sɔnɔ ni yo tana fɛn sere n a?” ");
INSERT INTO cko_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Nbem ŋa, “Yiri a.” Nbem gusu ŋa, “Má yiri a. I ferema­fɔ a.” Na yiri n mmɔɔ ni i tii suse bu ka, “Mini a.” ");
INSERT INTO cko_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Na ba bisa i ka, “Ye i yoori sɛ ye u nyu­mbaa n ateke a?” ");
INSERT INTO cko_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Na wɔ se bu ka, “Sɔnɔ n bo bu fere i ka Yesu ni, yiri kpitaari naatiɛ bɔrɔkiiri m nyu­mbaa n a. Na wɔ se m ka m kɔ Silowam bura n nu, na m kɔ ŋmisi m nyunu. Na ma kɔ aŋmisi, kpeŋga na ma ŋu asi.” ");
INSERT INTO cko_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Na ba bisa i ka, “Ye yiri n wo ni?” Na wɔ se bu ka, “M si má.” ");
INSERT INTO cko_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Na ba fa sɔnɔ n bo i yo tiiri anyinsin n akɔ Farasi­fɔm dɔ. ");
INSERT INTO cko_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Nyini cɛɛn n bo Yesu kpitaari naatiɛ na i fa tekeeri anyinsin nyu­mbaa n tiiri Ŋumi­yi cɛɛn wɔ. ");
INSERT INTO cko_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Nyini ti, na Farasi­fɔm gusu akaaki abisa i ka, “I yoori sɛ ye a ŋuuri asi a?” Na wɔ se bu ka, “I faari naatiɛ bɔrɔkiiri m nyu­mbaa n a, na ma ŋmisi i, na ma ŋu asi.” ");
INSERT INTO cko_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Na Farasi­fɔm nbem ase ka, “Ahin sɔnɔ n fite má Nyɛmɛ dɔ, dama i bita má Ŋumi­yi cɛɛn ciire ni.” Ama, na nbem gusu ase ka, “I yo sɛ ye satiɛ­yo­fɔ koro yo alekutura sam ka ahin ŋusu sɔ a?” Na bu kɛrɛ nɔɔ awo i ŋguŋgumi. ");
INSERT INTO cko_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Na ba kaaki abisa sɔnɔ n bo i yo tiiri anyinsin bekun ka, “Ye wɔrɔ bo wɔ teke u nyu­mbaa ni, a bu i sɛ wɔ?” Na wɔ se ka, “I ti Nyɛmɛ nɔaniɛ kan­fɔ ɔ.” ");
INSERT INTO cko_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Yuda­fɔ nkpiɛn­kpiɛnm n ade má ka i yo tiiri anyinsin wɔ, ye i ŋu asi kisa, má ka bu ba fereeri i si, ni i ni, ");
INSERT INTO cko_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","na ba bisa bu ka, “Am wa n bo am ŋa am wuuri i na i ti anyinsin ni, yiri la ahin? Ye i yoori sɛ ye i ŋu asi kisa a?” ");
INSERT INTO cko_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Na i si, ni i ni abɔ bu nu ka, “Ya si i ka i ti ya wa a, ya wuuri i anyinsin wɔ. ");
INSERT INTO cko_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ama, ya si má kabo i yoori barasu na i koro ŋu asi kisa ni, yɛrɛ gusu kaaki si má sɔnɔ bo i tekeeri i nyu­mbaa ni. Wɔ ju i tiɛŋgu sɔnɔ, am bisa i, yiri mmɔɔ ni i tii sé am.” ");
INSERT INTO cko_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Deke bo i ti na i si, ni i ni seeri sɔ ni, bu soroori Yuda­fɔ nkpiɛn­kpiɛnm n ahore wɔ, dama Yuda­fɔ nkpiɛn­kpiɛnm n adu mɔ ase ka sɔnɔ kɛrɛ bo i seeri ka Yesu ti Kristo Tii­de­fɔ ni, bu fɔ́n i mi fite bu tiɛntiɛn­bunɔɔ sɔɔ n nu wɔ. ");
INSERT INTO cko_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Nyini dɛɛ ti ye i si, ni i ni seeri ka, “Wɔ ju i tiɛŋgu sɔnɔ, am bisa yiri mmɔɔ ni i tii n a.” ");
INSERT INTO cko_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Na ba kaaki afere sɔnɔ n bo i yo tiiri anyinsin n bekun, na ba se i ka, “Niɛ Nyɛmɛ ti, na a jɔjɔ nahɔrɛ. Yɛrɛ si ka ahin sɔnɔ n ti satiɛ­yo­fɔ ɔ.” ");
INSERT INTO cko_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Na wɔ se bu ka, “Nzɛn i ti satiɛ­yo­fɔ ɔ, i ti má satiɛ­yo­fɔ ɔ, mini si má. Deke bo m si i n la ka, m yo tiiri anyinsin wɔ, ama, kisa m ŋu asi.” ");
INSERT INTO cko_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Na ba bisa i ka, “I yoori u sɛ wɔ, ye i tekeeri u nyu­mbaa n sɛ wɔ?” ");
INSERT INTO cko_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Na wɔ bɔ bu nu ka, “Ma du mɔ ase am kabo i tekeeri m nyu­mbaa ni, ye am ade má. Ye nzu ti ye am koro ka m kan kere am bekun a? Ambɛrɛ gusu, am koro ka am yo i susu­fɔm wɔ, nzɛn sɛ?” ");
INSERT INTO cko_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Na ba tɔ i ŋu ni nzukɔ kpiɛ ase i ka, “Wɔrɔ ti nyini sɔnɔ n susu­fɔ a, yɛrɛ yiri, ya ti Moyisi dɛɛ susu­fɔm wɔ. ");
INSERT INTO cko_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ya si ka Nyɛmɛ yo jɔjɔɔri Moyisi dɔ a, ama, nyini sɔnɔ n yiri, ya si má i fitee­biri n mmɔɔ.” ");
INSERT INTO cko_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Na wɔ se bu ka, “Ahin ti alekutura wanla, am si má i fitee­biri, ama, wɔ teke m nyu­mbaa. ");
INSERT INTO cko_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ya si ka Nyɛmɛ de má satiɛ­yo­fɔ nyɛmɛsere, ama, sɔnɔ kɛrɛ bo i su Nyɛmɛ atin su, na i yo i sa koroo­wa, Nyɛmɛ de i sere wɔ. ");
INSERT INTO cko_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Fite durunya n bumboori, sɔnɔ be nya ti má ka be ateke sɔnɔ bo bu wuuri i na i ti anyinsin nyu­mbaa. ");
INSERT INTO cko_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Nzɛn má ahin sɔnɔ n afite má Nyɛmɛ dɔ, má i koro yo má pui.” ");
INSERT INTO cko_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Na ba se i ka, “Wɔrɔ yiri, bu wuuri u satiɛ­yo­fɔ ɔ, ye wɔrɔ koro ka a kere yɛrɛ a?” Na ba fɔn i afite. ");
INSERT INTO cko_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu tiiri ka ba fɔn ayi sɔnɔ n ni, na wɔ kɔ aŋu i, na wɔ bisa i ka, “A yo Adamande Wa n yarada a?” ");
INSERT INTO cko_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Na sɔnɔ n abisa i ka, “M Mibiɛ, yiri la ŋma a? Se m na m yo i yarada.” ");
INSERT INTO cko_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Na Yesu ase i ka, “A ŋu i e, yiri la mini n bo m sujɔjɔ u dɔ ni.” ");
INSERT INTO cko_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Na sɔnɔ n ase i ka, “M Mibiɛ, ma yo u yarada.” Na wɔ kutu Yesu nyunu akansi i. ");
INSERT INTO cko_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Na Yesu ase ka, “M baari durunya n nu ka m ba di minɛm jɔrɛ wɔ, na bo bu ŋu má asi n ŋú asi, na bo bu ŋu asi n yó anyinsinm.” ");
INSERT INTO cko_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Farasi­fɔm nbem bo bu woori i bi dɔ n tiiri sɔ ni, na ba se i ka, “Ŋka a ŋa a se ka yɛrɛ gusu ti anyinsinm wɔ lɛɛ fan?” ");
INSERT INTO cko_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Na Yesu ase bu ka, “Nzɛn má am ti anyinsinm, má am la má ŋgasi, ama, kabo am nya ŋa am ŋu asi ni, am toko la ŋgasi lɛɛ.” ");
INSERT INTO cko_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Na Yesu ase ka, “Nahɔrɛ ye m suse am a, sɔnɔ bo i lɔrɔki wura nbɔɛm sɔɔ n nu, na wɔ fa má anɔ n nu awura má, i mi ti awiefɔ ɔ, na i kaaki ti sɔnɔ bo i nati fin minɛm di wɔ. ");
INSERT INTO cko_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Sɔnɔ bo i fa anɔ n wura nbɔɛm sɔɔ n nu, yiri ti nbɔɛm sasa­fɔ n a. ");
INSERT INTO cko_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Anɔ niɛ­fɔ ni teke anɔ n ma i a, na i fere i dɛɛ nbɔɛm n duma, na i nbɔɛm ni ti i konvi, na i fa bu fite. ");
INSERT INTO cko_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Nzɛn i nya faari i nbɔɛm kɛrɛ fiteeri, i du bu mɔ ɔ, na i dɛɛ nbɔɛm n su i su, dama bu si i konvi. ");
INSERT INTO cko_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Sɔnɔ bo bu si má i, bu sú má i su fieo, bu ŋmáti yaki i wɔ, dama bu si má i konvi.” ");
INSERT INTO cko_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Na Yesu abo ahin miɛɛnu n akere bu, ama, ba ti má i bu. ");
INSERT INTO cko_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ba ti má miɛɛnu n bu n ti, na Yesu akaaki ase bu bekun ka, “Nahɔrɛ ye m suse am a, mini ti nbɔɛm anɔ n bo bu fa wura sɔɔ n nu n a. ");
INSERT INTO cko_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Bɛrɛ kɛrɛ bo bu duuri m mɔ baari, na bu yo bu ŋu ka bu niɛ nbɔɛm su ni, bu ti awiefɔm wɔ, ni minɛm bo bu nati fin minɛm di wɔ, ama, nbɔɛm n ade má bu jɔjɔɔ­wa ni. ");
INSERT INTO cko_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Mini ti anɔ n a, na sɔnɔ kɛrɛ bo i fa m dɛɛ anɔ n wuraari, i nyá tii­de, na i wúra na i fíte, na i nyá i diire di. ");
INSERT INTO cko_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Awiefɔ dɛɛ la ka i ba wɔ ɔ, na i kun, na i saaki. Mini aba ka bu nyá ŋgɔɔ bo i la má aŋusu. ");
INSERT INTO cko_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Mini ti bɔɛ­sasa­fɔ kpa n a. Bɔɛ­sasa­fɔ kpa n tɔ i ŋgɔɔ ɔ, na i wu ma i nbɔɛm ni. ");
INSERT INTO cko_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Pa­di­fɔ n bo ba fa i ka i sasa nbɔɛm n ti má bɔɛ­sasa­fɔ nahɔrɛ su, na nbɔɛm n ti má i dɛɛm. Nyini ti, nzɛn i ba ŋuuri ka bedi suba, i ŋmati yaki nbɔɛm wɔ. Na bedi n wura bu nu tara nbem, na bo ba ka n sandi. ");
INSERT INTO cko_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","I ti pa­di­fɔ n dɛɛ ti, na i cɛcɛ wo má nbɔɛm n nu, nyini ti ye i ŋmati yaki bu n a. ");
INSERT INTO cko_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Mini ti bɔɛ­sasa­fɔ kpa n a. Kabo m Si Nyɛmɛ si m na m si i ni, sɔ ye mini gusu si m dɛɛ nbɔɛm a, na bu gusu si m. Na m tɔ m dɛɛ ŋgɔɔ na m wu ma bu. ");
INSERT INTO cko_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","M la nbɔɛ nyiŋga nbem bo bu ti m dɛɛm, bo bu wo má ahin nbɔɛm n nu. Wɔ yo daka ka m fa bu gusu ba wura ahinm n nu. Bɛrɛ gusu tí m konvi na bu dé i, na bu yó kun na bu sasa­fɔ yó kun. ");
INSERT INTO cko_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","M tɔ m dɛɛ ŋgɔɔ fa ma m minɛm, na m káaki de i bekun, nyini dɛɛ ti ye m Si koro m n a. ");
INSERT INTO cko_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Be sude má m dɛɛ ŋgɔɔ ni m dɔ, ama, mini ni m tii sutɔ i m koroya­nu a. M la atin bo m tɔ m dɛɛ ŋgɔɔ ni, na m kaaki la atin bo m de i bekun. M Si maari m nɔɔ ka m yo sɔ a.” ");
INSERT INTO cko_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Yesu seeri sɔ n dɛɛ ti, na Yuda­fɔ nkpiɛn­kpiɛnm n nɔɔ awo i ŋguŋgumi bekun. ");
INSERT INTO cko_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Na bu dɔŋgu n ase ka, “Ajini wo i ŋu, nyini dɛɛ ti, wɔ bo fiɛ a. Nzu ti ye am so am sui i dɔ a?” ");
INSERT INTO cko_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ama, nbem ŋa, “Má sɔnɔ bo ajini wo i ŋu jɔjɔɔ­wa la ahin. Ajini yo sɛ koro teke anyinsin nyu­mbaa?” ");
INSERT INTO cko_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Fufuku saŋga na Yuda­fɔm ba sudi bu cɛɛn­kpiri n Yɛrusalem miɛ kpiri n nu, na bu teŋge su kabo bu yo tekeeri Nyɛmɛ Seree­biri Awuru n ni, na bu yoori i dɔŋgu ni. ");
INSERT INTO cko_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Na Yesu sunati bara yɛ Solomon Lɛlɛ n bo i wo Nyɛmɛ Seree­biri Awuru n nu ni. ");
INSERT INTO cko_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Na Yuda­fɔ nbem atiɛn bu nɔɔ abara ayɛ i, na ba bisa i ka, “Saŋga bɔnɔ ye a bá kan teke ya nyi a? Nzɛn wɔrɔ ti Kristo Tii­de­fɔ n a, se ya nahɔrɛ kpain.” ");
INSERT INTO cko_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Na Yesu ase bu ka, “Ma se am, ye am ade má a. Alekutura sam bo m yo bu m Si duma n nu ni, di m ŋu daani a. ");
INSERT INTO cko_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ama, am yo má m yarada, dama am ti má m dɛɛ nbɔɛm. ");
INSERT INTO cko_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","M dɛɛ nbɔɛm ti m konvi. M si bu, na bu su m su. ");
INSERT INTO cko_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","M ma bu ŋgɔɔ bo i la má awieeri, na bu ká má ŋgbɛɛn cɛɛn be fieo. Be gusu koro fin má bu fite má m saa nu. ");
INSERT INTO cko_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","M Si bo i faari bu maari m ni, tara deke kɛrɛ faŋga, na be wo má bɛrɛ bo i koro fin bu fite m Si saa nu. ");
INSERT INTO cko_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Mini ni m Si ti deke kun wɔ.” ");
INSERT INTO cko_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Na Yuda­fɔm afa yabuɛ bekun ka bu bo kun i. ");
INSERT INTO cko_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Na Yesu ase bu ka, “Ma yo alekutura sakpam dɔŋgu, bo m Si kereeri m na am aŋu i, ye sa bɔnɔ ti ye am ŋa am kun m n a?” ");
INSERT INTO cko_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Na Yuda­fɔm n ase i ka, “Má sakpam bo a yo bu n be dɛɛ ti ye ya ŋa ya kún u a, ama, bo a jɔjɔ wura Nyɛmɛ ŋgasi nu n ti, dama a ti adamande wɔ, ama, na a se ka a ti Nyɛmɛ wɔ.” ");
INSERT INTO cko_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Na wɔ se bu ka, “Ba kɛrɛ i am Nyɛmɛ Jɔrɛ Kadasi n nu ka, Nyɛmɛ ŋa, ‘Am ti ka Nyɛmɛ wɔ.’ ");
INSERT INTO cko_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Be koro bu má Nyɛmɛ Jɔrɛ Kadasi ni ŋgbɛɛn. Nyɛmɛ yo seeri bu ka bu ti ka Nyɛmɛ wɔ, bɛrɛ bo bu deeri Nyɛmɛ nɔaniɛ ni, ");
INSERT INTO cko_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ama, mini yiri, m Si Nyɛmɛ ayi m, ye wɔ sunma m durunya n nu a. Ye nzu ti ye ambɛrɛ ŋa ma kan ciire jɔrɛ, dama m ŋa mini ti Nyɛmɛ Wa a? ");
INSERT INTO cko_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Nzɛn m yo má m Si juma ni, má am yo m yarada. ");
INSERT INTO cko_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ama, nzɛn m yo bu na haari am yo má m yarada mmɔɔ a, am yo m juma n yarada, adena am si nahɔrɛ su ka mini ni m Si n ti deke kun wɔ.” ");
INSERT INTO cko_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","I seeri sɔ ni, na ba kpi ka bu tara i bekun, na wɔ lɔrɔki afite bu nu. ");
INSERT INTO cko_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Na Yesu akaaki akpiɛ akɔ Yodan kunma n buekun dɔ akɔ aju deke bo Yohane yo biɛɛri minɛm Nyɛmɛ nzue ni, na wɔ wo dɔ. ");
INSERT INTO cko_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Na jama beberebe aba i dɔ, na ba se ka, “Yohane ayo má alekutura sa be, ama, jɔjɔɔ­wa kɛrɛ bo i yo jɔjɔ fa kɔɔri ahin sɔnɔ n ŋusu n ti nahɔrɛ wɔ.” ");
INSERT INTO cko_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Na minɛ dɔŋgu ayo i yarada dɔ. ");
INSERT INTO cko_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Na sɔnɔ be bo bu fere i ka Lazarosi n ada tukpaki. I ninbaam la Mariya ni Marata. Bu bɔsu la Betani. ");
INSERT INTO cko_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Nyini Mariya n bo i niwa Lazarosi daari tukpaki ni, yiri ba faari tulaalɛɛ nva­nvani­fɔ gɔɔri Yesu jaa su ye i faari i tii­ŋmiɛ tintiin nunukaari i n a. ");
INSERT INTO cko_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Na i ninbaa nbaa­baram n asunma ka bu kɔ se Yesu ka, “Ya Mibiɛ, u danfo n bo a koro i agaya n ada tukpaki.” ");
INSERT INTO cko_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesu tiiri sɔ ni, na wɔ se ka, “Ahin tukpaki n ti má yiwee tukpaki, ama, i yo sɔ, na minɛm ŋu Nyɛmɛ jirima woo­wa kabo i ti, na Nyɛmɛ ma minɛm ŋu mini bo m ti i Wa n gusu jirima woo­wa.” ");
INSERT INTO cko_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Tɔ, Yesu koroori Marata ni Mariya ni bu niwa Lazarosi. ");
INSERT INTO cko_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ama, i tiiri ka Lazarosi ada tukpaki ni, na wɔ ka deke bo i woori n cɛɛn nnyɔ abuka su. ");
INSERT INTO cko_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Nyini sin na Yesu ase i susu­fɔm ka, “Am ma ya kaaki kɔ Yudiya dɛɛ awɔrɛ n nu.” ");
INSERT INTO cko_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Na i susu­fɔm n ase i ka, “Ya Kere­fɔ, má anzɔni fɛn ye Yuda­fɔm ŋa bu tu yabuɛ bo kun u n a? Ye a sukoro ka ya kpie ya nyi kɔ dɔ bekun n a?” ");
INSERT INTO cko_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Na Yesu ase bu ka, “Fa ŋgarama kɔ ju naasɔ, m ŋa i ti wiɛ kun wɔ e. Sɔnɔ bo i nati wiɛsu bo má i jaa, dama durunya n nu wein ni ma i ŋu asi a. ");
INSERT INTO cko_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ama, sɔnɔ bo i nati kɔŋguɛ bo i jaa, dama wein wo má i dɔ.” ");
INSERT INTO cko_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesu jɔjɔɔri sɔ n sin, na wɔ kaaki ase bu ka, “Ya danfo Lazarosi adaafi, ama, m sukɔ na m kɔ teŋge i lɛɛ.” ");
INSERT INTO cko_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Na i susu­fɔm n ase i ka, “Ya Mibiɛ, nzɛn wɔ daafi wɔ, i nyá laifiɛ.” ");
INSERT INTO cko_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Kabo Yesu seeri n la ka, Lazarosi awu wɔ, ama, i susu­fɔm bɛrɛ sunsun ka i ŋa wɔ daafi nahɔrɛ su wɔ. ");
INSERT INTO cko_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Nyini ti, na Yesu ase bu kpain ka, “Lazarosi awu. ");
INSERT INTO cko_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ama, ambɛrɛ dɛɛ ti, wɔ yo m fiɛ ka ma wo má dɔ, adena am yo yarada. Am ma ya kɔ i dɔ.” ");
INSERT INTO cko_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Na Tomasi bo bu fere i ka Ndaa n ase i lamɔkɔ susu­fɔm n ka, “Am ma yɛrɛ gusu kɔ, nzɛn bu kɔ kuunri i a, na ya ni yiri kɛrɛ awu.” ");
INSERT INTO cko_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Saŋga bo Yesu kɔ juuri ni, i ŋuuri ka ba se Lazarosi i le­nna lɛɛ. ");
INSERT INTO cko_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani ni Yɛrusalem miɛm waari má ni i beŋgu. ");
INSERT INTO cko_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Na Yuda­fɔm dɔŋgu aba Marata, ni Mariya dɔ ka bu ba dada bu ahore, bu niwa n bo wɔ wu n dɛɛ ti. ");
INSERT INTO cko_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Marata tiiri ka Yesu suba ni, na wɔ kpa i atin, ama, na Mariya aka awuru. ");
INSERT INTO cko_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Na Marata ase Yesu ka, “M Mibiɛ, nzɛn má a woori fɛn, má m niwa n awu má. ");
INSERT INTO cko_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ama, haari ni nyini mmɔɔ, m si ka deke kɛrɛ bo a sere Nyɛmɛ, i yó i ma u.” ");
INSERT INTO cko_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Na Yesu ase i ka, “U niwa ni téŋge i yiwee n nu bekun.” ");
INSERT INTO cko_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Na Marata ase i ka, “M si ka i bá teŋge i yiwee nu jina cɛɛn, saŋga bo Nyɛmɛ bá teŋge minɛm bu yiwee nu ni.” ");
INSERT INTO cko_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Na Yesu ase i ka, “Mini ti sɔnɔ bo i teŋge minɛm bu yiwee nu, na i má bu ŋgɔɔ n a. Sɔnɔ kɛrɛ bo i yo m yarada, haari nzɛn i wuuri, i nyá ŋgɔɔ. ");
INSERT INTO cko_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Na sɔnɔ kɛrɛ bo i la ŋgɔɔ na i yo m yarada, i mi wu má fieo. A yo ahin jɔjɔɔ­wa n yarada a?” ");
INSERT INTO cko_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Na Marata ase i ka, “M Mibiɛ, ma yo yarada ka wɔrɔ ti Nyɛmɛ Wa, Kristo Tii­de­fɔ n a, bo i ŋa i súnma i durunya n nu ni.” ");
INSERT INTO cko_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marata seeri sɔ n sin, na wɔ kaaki akɔ afere i niwa Mariya bɛnlɛ, na wɔ se i ka, “Ya Mibiɛ n aba, i ŋa a bra.” ");
INSERT INTO cko_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mariya tiiri sɔ ni, i kaba bereki yasuuri wɔ, na wɔ kɔ i dɔ. ");
INSERT INTO cko_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Nyini saŋga, na Yesu nya ju má miɛ n nu, i toko wo deke bo Marata kɔ tuuri i n wɔ. ");
INSERT INTO cko_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Na Yuda­fɔm bo bu woori awuru n nu Mariya bi, na bu sudada i ahore ni, bu ŋuuri kabo i bereki yasu fiteeri ni, na ba su i su. Bu sunsuunri ka i sukɔ deke bo bu seeri Lazarosi n wɔ, na i kɔ sun. ");
INSERT INTO cko_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Saŋga bo Mariya kɔ juuri deke bo Yesu wo n na i ŋuuri i ni, na wɔ kutu i nyunu, na wɔ se i ka, “M Mibiɛ, nzɛn má a woori fɛn, má m niwa n awu má.” ");
INSERT INTO cko_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesu ŋuuri ka i susun ni, ni kabo Yuda­fɔm n bo bu suuri i su baari n gusu wo sun su ni, na i ahore asaaki, na wɔ mi i ŋumi. ");
INSERT INTO cko_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Na wɔ bisa bu ka, “Am seeri i ni wɔ?” Na ba se i ka, “Ya Mibiɛ, bra na a ba niɛ.” ");
INSERT INTO cko_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Na Yesu asun. ");
INSERT INTO cko_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Nyini ti na Yuda­fɔm n ase ka, “Am niɛ kabo i koro i agaya barasu a.” ");
INSERT INTO cko_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ama, na bu nbem ase ka, “Yiri n bo i teke anyinsin n nyu­mbaa ni, má i koro tuntun má sɔnɔ ni, na i wu má, nzɛn sɛ?” ");
INSERT INTO cko_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Na Yesu ahore asaaki bekun, na wɔ kɔ deke bo bu seeri Lazarosi ni. I ti yabuɛ buɛ faŋ­kunma wɔ, ye bu faari i seeri nu a, na ba fa yabuɛ nyiŋga atɔ anɔ ni. ");
INSERT INTO cko_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Na Yesu ase bu ka, “Am ba yi yabuɛ ni.” Na sɔnɔ n bo wɔ wu n niwa Marata ase i ka, “M Mibiɛ, kisa wɔ bun, dama bu seeri i nyuma le­nna lɛɛ.” ");
INSERT INTO cko_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Na Yesu ase i ka, “Ma se má u ka, nzɛn a yoori m yarada, a ŋú Nyɛmɛ jirima woo­wa kabo i ti barasu?” ");
INSERT INTO cko_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","I seeri sɔ ni, na ba lakati yabuɛ ni. Na wɔ yɛ i tii su aŋgoro, na wɔ se ka, “M Si, m da u asi ka a de m sere. ");
INSERT INTO cko_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","M si ka saŋga kɛrɛ a de m sere wɔ, ama, ahin minɛm bo bu jina fɛn n dɛɛ ti, ye m seeri sɔ a, adena bu yo m yarada ka wɔrɔ sunmaari m a.” ");
INSERT INTO cko_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","I sereeri Nyɛmɛ n wieeri ni, na wɔ tiɛn ase ka, “Lazarosi, fite.” ");
INSERT INTO cko_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Na sɔnɔ n bo wɔ wu n afite faŋ­kunma n nu. Tani pɔɔndiiri i saa, ni i jaa, na tani kun pɔɔndiiri i tii. Na Yesu ase bu ka, “Am nyaŋgi yi tani n na am ma i kɔ.” ");
INSERT INTO cko_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Yuda­fɔm dɔŋgu bo bu baari Mariya dɔ ŋuuri sa n bo Yesu yoori i ni, na ba yo i yarada. ");
INSERT INTO cko_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Na bu nbem akɔ Farasi­fɔm n dɔ akɔ ase bu kabo Yesu ayo ni. ");
INSERT INTO cko_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Na Farasi­fɔm ni Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ nkpiɛn­kpiɛnm n afere Yuda­fɔm tere­tere­fɔm ni, na ba tiɛn bu nɔɔ. Na ba se ka, “Ye ya yo sɛ wɔ? Am niɛ e, ahin sɔnɔ ni suyo alekutura sa­yoo­wam dɔŋgu. ");
INSERT INTO cko_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nzɛn ya yaki i na i suyo sɔ, minɛm kɛrɛ yó i yarada a, na Roma yiko­fɔm bá saaki ya Nyɛmɛ Seree­biri Awuru ni, na bu kún ya minɛm ni.” ");
INSERT INTO cko_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Na bu nu sɔnɔ be bo bu fere i ka Kayafasi ni, bo i ti Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm kɛrɛ kpiɛn nyini afɔ n ase ka, “Ambɛrɛ, am si má pui. ");
INSERT INTO cko_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Am si má kabo i ti n wɔ, nzɛn sɛ? Ka nzɛn am ma sɔnɔ kun wu maari minɛm kɛrɛ, i ti ye ni bo ya minɛm kɛrɛ bá wu ni.” ");
INSERT INTO cko_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Má i koroya­nu ye i seeri sɔ a, ama, yiri ti Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm kɛrɛ kpiɛn nyini afɔ n ti, ye Nyɛmɛ ma i seeri ka Yesu wú ma Yuda­fɔm n a. ");
INSERT INTO cko_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Na má bɛrɛ ŋgumi dɛɛ ti ye i wú a, ama, adena i tiɛn Nyɛmɛ nbaam nɔɔ, na bu yo kun, bɛrɛ bo ba sandi akɔ asiɛn nbem n su. ");
INSERT INTO cko_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Nyini dɛɛ ti, fite nyini cɛɛn n fa kɔ, na ba sɛsɛ su ka bu kun Yesu. ");
INSERT INTO cko_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Nyini dɛɛ ti, wɔ yi má i ŋu fofoe nu anati má Yuda­fɔm nu kun. Ama, i fiteeri bɛrɛ ni, na wɔ kɔ awɔrɛ be bo i wo dodo boro kpantain dɛɛ bue ni, na i ni i susu­fɔm n akɔ awo miɛ n bo bu fere i ka Efirayim n su. ");
INSERT INTO cko_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Nyini saŋga, wɔ ka kaan, na Yuda­fɔm di bu Butara cɛɛn­kpiri ni, na minɛ dɔŋgu afite ahɛmɛm aba Yɛrusalem miɛ kpiri n nu, na bu ba kpakpara bu ŋu fin ka, na cɛɛn­kpiri n nya ju. ");
INSERT INTO cko_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Na ba niɛniɛ Yesu busu, na saŋga bo bu wo Nyɛmɛ Seree­biri Awuru n nu ni, na ba bisa bu ŋuŋu nu ka, “Am sunsun sɛ wɔ? I bá cɛɛn­kpiri ni? Ya de má ka i bá.” ");
INSERT INTO cko_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ama, Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ nkpiɛn­kpiɛnm ni, ni Farasi­fɔm n ama nɔɔ ka sɔnɔ kɛrɛ bo i si deke bo Yesu wo, i se bu na bu kɔ tara i. ");
INSERT INTO cko_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Na saŋga bo i ba kaari le­sɛn, na bu di Butara cɛɛn­kpiri ni, na Yesu akɔ Betani, Lazarosi bɔsu, yiri bo Yesu teŋgeeri i yiwee n nu ni. ");
INSERT INTO cko_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Na ba su Yesu wɔfɔ dɔ. Marata faari diire n ba maari bu a, Lazarosi gusu woori minɛm bo bu ni Yesu diiri diire n nu. ");
INSERT INTO cko_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Na Mariya afa tulaalɛɛ nva­nvani bo i la gɔ agaya tuwa bambaka kun, na wɔ fa agɔ Yesu jaa su, na wɔ fa i tii­ŋmiɛ tintiin anunuka i jaam kɛrɛ su, na tulaalɛɛ ni nvani ade awuru n kɛrɛ. ");
INSERT INTO cko_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Na Yesu susu­fɔm kun bo bu fere i ka Yudasi Isikariyoti bo i bá tɔ Yesu n abisa ka, ");
INSERT INTO cko_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Nzu ti ye bara n atɔ má tulaalɛɛ n na i nya ŋwaa beberebe, na ya fa ma yaari­fɔm a?” ");
INSERT INTO cko_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","I ti awiefɔ n dɛɛ ti ye i seeri sɔ a, má ka i cɛcɛ wo yaari­fɔm nu wɔ. Yiri ti bu ŋwaa bita­fɔ a, na i suwɔ ŋwaa n be saŋga saŋga. ");
INSERT INTO cko_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Na Yesu ase ka, “Yaki Mariya bɛnlɛ, i dɛɛ nzee bo i sufa yo m fa kɔ m yiwee cɛɛn lɛɛ. ");
INSERT INTO cko_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Dama am ni yaari­fɔm ni wo bɛrɛ saŋga kɛrɛ a, ama, am ni mini koro wo má bɛrɛ saŋga kɛrɛ.” ");
INSERT INTO cko_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Yuda­fɔm beberebe tiiri ka Yesu woori dɔ ni, na ba ba i dɔ, má ka Yesu ŋgumi ti ye bu baari a, ama, bu baari ka bu ba ŋu Lazarosi n bo Yesu teŋgeeri i yiwee n nu n wɔ. ");
INSERT INTO cko_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Nyini dɛɛ ti, na Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ nkpiɛn­kpiɛnm n asɛsɛ su ka bu kun Lazarosi gusu. ");
INSERT INTO cko_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Dama i dɛɛ ti ye Yuda­fɔm dɔŋgu akaaki bu sin abo bu a, ye ba yo Yesu yarada n a. ");
INSERT INTO cko_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Na alecin na jama n bo bu baari ka bu ba di Butara cɛɛn­kpiri n ati ka Yesu suba Yɛrusalem miɛ kpiri n nu. ");
INSERT INTO cko_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Na ba kpiɛkpiɛ kpakpa nyawa akɔ akpa i atin, na bu subo kuyigindi, bu ŋa, “Hosana. Ya kansi Nyɛmɛ. Tere­fiɛ wo yiri n bo i suba Micɛra n dɛɛ duma n nu n dɔ. Tere­fiɛ wo Yisareli­fɔm fɛmɛ n dɔ.” ");
INSERT INTO cko_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Na Yesu aŋu kaako­baa be, na wɔ fun atana su, kabo ba kɛrɛ i Nyɛmɛ Jɔrɛ Kadasi n nu ni, ");
INSERT INTO cko_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Ambɛrɛ Siyon­fɔm, má am soro sɛrɛ. Am niɛ, am fɛmɛ ni suba n a, i fun kaako­baa wɔ.” ");
INSERT INTO cko_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Nyini saŋga, i susu­fɔm nya si má nyini sam n bo ba yo n kɛrɛ bu. Má ka saŋga bo Yesu ba teŋgeeri i yiwee n nu, na bu ŋuuri i jirima woo­wa n sin, na ba nya ateŋge su, ka ba kɛrɛ i Nyɛmɛ Jɔrɛ Kadasi n nu ka bu yó i sɔ ɔ, na ba kaaki ateŋge su, ka ba yo i sɔ nahɔrɛ su. ");
INSERT INTO cko_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Na jama n bo bu yo woori Yesu dɔ, saŋga n bo i fereeri Lazarosi fiteeri faŋ­kunma n nu, na i teŋgeeri i yiwee n nu ni, na bu sukan labari ni. ");
INSERT INTO cko_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Nyini alekutura sa n bo i yoori i na minɛm tiiri n dɛɛ ti, na ba kpa i atin. ");
INSERT INTO cko_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Na Farasi­fɔm n ase bu ŋuŋu nu ka, “Am aŋu má i? Ya koro yo má pui kun. Yiri ye durunya n nu­fɔm kɛrɛ susu i su n a.” ");
INSERT INTO cko_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Minɛm bo bu baari Yɛrusalem miɛ kpiri n nu Butara cɛɛn­kpiri n saŋga n ka bu ba su Nyɛmɛ ni, bu nbem ti Giriki­fɔm wɔ. ");
INSERT INTO cko_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Na ba ba Filipu dɔ, i fite miɛ n bo bu fere i ka Besayida na i wo Galili awɔrɛ n nu n wɔ. Na ba se i ka, “Njabiɛ, ya koro ka ya ŋu Yesu wɔ.” ");
INSERT INTO cko_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Na Filipu akɔ ase Andere, na bu nnyɔ n kɛrɛ akɔ ase Yesu. ");
INSERT INTO cko_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Na Yesu ase ka, “Saŋga n aju bo Nyɛmɛ wúra mini Adamande Wa n kpiri. ");
INSERT INTO cko_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nahɔrɛ ye m suse am n a, má ka alɛ­mbaa awura fa nu, na wɔ kpɔrɔ, i ti i tii wɔ. Ama, nzɛn i wuraari fa nu na i kpɔrɔɔri, ye i wúra mbaa beberebe a. ");
INSERT INTO cko_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Sɔnɔ kɛrɛ bo i koro i ŋgɔɔ, i mi bá fun i, ama, sɔnɔ kɛrɛ bo i koro má i ŋgɔɔ durunya n nu fɛn, i mi bá nya ŋgɔɔ bo i la má awieeri. ");
INSERT INTO cko_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Sɔnɔ kɛrɛ bo i su m, wɔ yo daka ka i mi su m su, na deke bo m wo ni, m amusui­su­fɔ gusu wó dɔ ɔ. Na sɔnɔ kɛrɛ bo i suuri m, m Si Nyɛmɛ wúra i mi kpiri.” ");
INSERT INTO cko_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Na Yesu ase ka, “Kisa, m ahore asaaki, ye m se sɛ wɔ? M koro se ka, m Si Nyɛmɛ, yi m fite ahin anyum­boro bo i suba m dɔ n nu, nzɛn sɛ? Ai, m koro se má sɔ, dama nyini dɛɛ ti ye m baari a. ");
INSERT INTO cko_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","M dɛɛ bo m se la ka, m Si, kere kabo u jirima woo­wa ti.” Na akonvi be atiɛn afite aŋgoro ase ka, “Ma du mɔ akere kabo m jirima woo­wa ti, na m káaki kere i bekun.” ");
INSERT INTO cko_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Jama n bo bu jina Yesu bi n tiiri akonvi ni ŋga ni, na bu nbem ase ka, “Nzue akpura.” Na nbem gusu ase ka, “Nyɛmɛ mɛrɛkɛ ajɔjɔ i dɔ a.” ");
INSERT INTO cko_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Na Yesu ase bu ka, “Ambɛrɛ dɛɛ ti ye akonvi n jɔjɔɔri a, má mini dɛɛ ti a. ");
INSERT INTO cko_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Saŋga n aju bo Nyɛmɛ dí durunya n nu­fɔm jɔrɛ, na i fɔ́n yi Sitana bo i ti bu fɛmɛ ni. ");
INSERT INTO cko_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ama, mini, bu ba yɛɛri m su jinaari aŋgoro baka jaanu n su, m cín sɔnɔ kɛrɛ ba m dɔ.” ");
INSERT INTO cko_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Kabo i yo seeri sɔ n kere yiwee n bo i bá wu i n wɔ. ");
INSERT INTO cko_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Na jama n ase i ka, “Ya ti i Nyɛmɛ Jɔrɛ Kadasi n nu ka, Kristo Tii­de­fɔ ni wo bɛrɛ saŋga kɛrɛ. I wú má. Ye i yoori sɛ ye wɔrɔ ŋa, wɔ yo daka ka bu bá yɛɛri Adamande Wa n su jinaari aŋgoro baka jaanu n su a? Ye Adamande Wa n la ŋma a?” ");
INSERT INTO cko_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Na Yesu ase bu ka, “Mini bo m ti wein ni, m wo am nu kisa, ama, m cɛ́ má. Nyini dɛɛ ti, am nya wo ni wein ni, am sunati wein nu wɔ, na má awosin tu am. Sɔnɔ kɛrɛ bo i wo awosin nu, i mi si má deke bo i sukɔ ni. ");
INSERT INTO cko_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Am nya wo ni wein ni, am yo i yarada, na m má am yo wein dɛɛ nbaam.” Yesu seeri sɔ ni, na wɔ fite bu nu akɔ afiɛ deke be, na má be ŋu i. ");
INSERT INTO cko_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yesu yo yoori alekutura sam dɔŋgu na ba ŋu i, haari ni nyini mmɔɔ, ba yo má i yarada. ");
INSERT INTO cko_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Nyini ma Nyɛmɛ nɔaniɛ kan­fɔ Esaya jɔrɛ n bo i yo kɛrɛɛri n yo yii­wa. I ŋa, “M Nyɛmɛ Fɛmɛ, ŋma ade jɔrɛ n bo ya kan i n a? Ye ŋma ye a yi u yiko akere i a?” ");
INSERT INTO cko_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Nyini dɛɛ ti, ye ba koro ayo má Yesu yarada n a. Kabo Esaya akaaki ase ka, ");
INSERT INTO cko_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Nyɛmɛ ama ba yo anyinsinm na má bu ŋu asi, na wɔ ma bu ahore ayo kekereke na má bu ti i nɔaniɛ n bu, adena má bu kaaki ba i dɔ na bu nya laifiɛ.” ");
INSERT INTO cko_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Esaya yo ŋuuri Yesu jirima woo­wa n dɛɛ ti, ye i kaanri i ŋu jɔrɛ n a. ");
INSERT INTO cko_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Yuda­fɔ nkpiɛn­kpiɛnm dɔŋgu mmɔɔ yoori Yesu yarada, ama, bu soroori Farasi­fɔm n ahore n dɛɛ ti, ba koro ayi má bu ŋu fofoe nu. Nzɛn bu yiiri bu ŋu ka ba yo i yarada, Farasi­fɔm ni fɔ́n bu fite bu tiɛntiɛn­bunɔɔ sɔɔ n nu wɔ. ");
INSERT INTO cko_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Dama Yuda­fɔ nkpiɛn­kpiɛnm n yo koroori adamande kansi taraari Nyɛmɛ dɛɛ. ");
INSERT INTO cko_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Na Yesu atiɛn ase ka, “Sɔnɔ kɛrɛ bo i yo m yarada, má mini ŋgumi ye i yo m yarada, ama, i yo bo wɔ sunma m n gusu yarada a. ");
INSERT INTO cko_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Na sɔnɔ kɛrɛ bo i niɛ na i ŋuuri m, ti ka wɔ ŋu m Si Nyɛmɛ bo i sunmaari m n lɛɛ. ");
INSERT INTO cko_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Mini bo m ti wein n aba durunya n nu, adena sɔnɔ kɛrɛ bo i yo m yarada, i wó má awosin nu. ");
INSERT INTO cko_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Sɔnɔ kɛrɛ bo i ti m nɔaniɛ n na i de má i, m di má i mi jɔrɛ, dama ma ba má ka m ba di durunya n nu­fɔm jɔrɛ wɔ, ama, m baari ka m ba de bu tii ji wɔ. ");
INSERT INTO cko_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Sɔnɔ kɛrɛ bo i kete m, na i de má m nɔaniɛ ni, i jɔrɛ­di­fɔ wo bɛrɛ wɔ. Nɔaniɛ n bo ma jɔjɔ i ni, yiri dí i mi jɔrɛ jina cɛɛn n a. ");
INSERT INTO cko_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Dama má m koroya­nu ye m kan sɔ a, ama, m Si n bo wɔ sunma m ni, yiri maari m nɔɔ, kereeri m nɔaniɛ kun kun kɛrɛ bo m jɔjɔ i n a. ");
INSERT INTO cko_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","M si ka i nɔaniɛ maa­wa n ti deke bo i ma ŋgɔɔ bo i la má awieeri n wɔ. Nyini dɛɛ ti, kabo m Si seeri m ni, sɔ ye m jɔjɔ a.” ");
INSERT INTO cko_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Alecin bo má bu di Butara cɛɛn­kpiri n ni, na Yesu asi nu ka saŋga n aju bo i fíte durunya n nu kaaki kɔ i Si Nyɛmɛ dɔ. Na i dɛɛ tiɛŋgu minɛm bo bu wo durunya n nu na i koro bu ni, i koro bu sɔ ɔ haari i kɔ ju i faŋga nyaari. ");
INSERT INTO cko_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Na kɔŋguɛ saŋga bo bu wo diire n di su ni, na Sitana awura Yudasi, Simon Isikariyoti wa n tii nu ka i tɔ Yesu ma i kpɔ­fɔm. ");
INSERT INTO cko_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Na Yesu asi nu ka i Si Nyɛmɛ afa deke n kɛrɛ awura i saa nu, na i kaaki si ka i fiteeri Nyɛmɛ dɔ baari a, na i káaki kɔ i dɔ ɔ. ");
INSERT INTO cko_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Na wɔ nya yasu ajina, na wɔ yi i tanlɛɛ n ase, na wɔ fa papawo abo i wi nu. ");
INSERT INTO cko_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Na wɔ sa nzue agɔ nyaŋga nu, na wɔ bo i bu suŋmisi i susu­fɔm n jaa, na wɔ fa papawo n bo i bo i wi nu ni sunuka bu jaam. ");
INSERT INTO cko_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","I ba kpuraari Simon Petoro, na wɔ bisa Yesu ka, “M Mibiɛ, na wɔrɔ ba ŋmisi m dɛɛ jaa?” ");
INSERT INTO cko_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Na Yesu ase i ka, “Sa bo m suyo i ni, a koro ti má i bu kisa, ama, fa kɔ fa ba, a bá ti i bu.” ");
INSERT INTO cko_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Na Petoro ase i ka, “Ai, a ŋmísi má m jaa haari durunya n ba yasu.” Na Yesu ase i ka, “Nzɛn ma ŋmisi má u jaa, m ni wɔrɔ akpaaki lɛɛ.” ");
INSERT INTO cko_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Dɔ na Simon Petoro anya ase i ka, “M Mibiɛ, nzɛn i ti sɔ a, má a ŋmisi m jaa ŋgumi, ama, ŋmisi m saam ni m tii kɛrɛ.” ");
INSERT INTO cko_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Na Yesu ase i ka, “Sɔnɔ anya abiɛ nzue, ŋka i ŋmisi i jaa a, i biɛ má nzue kun, dama i ŋuniɛ kɛrɛ ti casi wɔ. Ambɛrɛ, am ti casi wɔ, ama, má am kɛrɛ.” ");
INSERT INTO cko_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesu siiri bo i bá tɔ i ma i kpɔ­fɔm ni, nyini ti ye i ŋa má bu kɛrɛ ti casi n a. ");
INSERT INTO cko_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","I ŋmisi bu jaam wieeri ni, na wɔ fa i tanlɛɛ n awura, na wɔ kɔ atana i tanaa­biri ni. Na wɔ bisa bu ka, “Kabo ma yo am ni, am ati i bu? ");
INSERT INTO cko_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Am fere m ka am Kere­fɔ ɔ, na am kaaki fere m ka am Mibiɛ. Am jɔjɔ nahɔrɛ wɔ, dama m ti sɔ ɔ. ");
INSERT INTO cko_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Tɔ. Kisa na mini bo m ti am Mibiɛ, ni am Kere­fɔ, na ma ŋmisi am jaam ni, wɔ yo daka ka ambɛrɛ gusu ŋmisi am beŋgum jaam sɔ. ");
INSERT INTO cko_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Dama ma yo akere am lɛɛ, na am gusu yo am beŋgum kabo ma yo am ni.” ");
INSERT INTO cko_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Na wɔ se bu ka, “Nahɔrɛ ye m suse am a, akɔɔ koro tara má i mibiɛ, na bekun sunma­fɔ gusu koro tara má bo i sunmaari i ni. ");
INSERT INTO cko_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Nzɛn am sin ahin n kɛrɛ, na am yoori sɔ, tere­fiɛ wo am dɔ. ");
INSERT INTO cko_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","M sujɔjɔ ni má am kɛrɛ wɔ, dama m si bo ma du mɔ ayi bu ni. Ama, kabo ba kɛrɛ i Nyɛmɛ Jɔrɛ Kadasi n nu ni, i ti ye ni ka i yo yii­wa, ka, ‘Sɔnɔ n bo m ni yiri saŋga di diire taalɛ kun nu, yiri akaaki m jaa tu­fɔ n a.’ ");
INSERT INTO cko_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","M suse am sa bo i bá yo wɔ lɛɛ, na i ba yoori, na am yo m yarada ka mini la sɔnɔhɔrɛ n bo ma se am kabo m ti n a. ");
INSERT INTO cko_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nahɔrɛ ye m suse am a, sɔnɔ kɛrɛ bo i de sɔnɔ bo m sunma i ni, i mi ade mini wɔ lɛɛ, na sɔnɔ kɛrɛ bo i de mini, i mi ade yiri bo i sunmaari m wɔ lɛɛ.” ");
INSERT INTO cko_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesu seeri bu sɔ wieeri ni, na i ahore asaaki akɔ asin su, na wɔ se bu kpain ka, “Nahɔrɛ ye m suse am a, am nu kun bá tɔ m ma m kpɔ­fɔm a.” ");
INSERT INTO cko_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Na i susu­fɔm n abirisi, suniɛ bu ŋuŋu nu, ama, ba si má bo i yó nyini sa n ni. ");
INSERT INTO cko_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Bu nu kun be bo Yesu koro i agaya n tana mata Yesu. ");
INSERT INTO cko_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Na Simon Petoro abo i nyu­mbaa i dɔ ka i bisa Yesu ka, i ni ŋma a? ");
INSERT INTO cko_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Na yiri n acin adodo Yesu, na wɔ bisa i ka, “Ya Mibiɛ, a ni ŋma a?” ");
INSERT INTO cko_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Na Yesu ase i ka, “Sɔnɔ n bo m kpíɛ too n bo toro n nu na m fá ma i ni, yiri lɛɛ.” Na wɔ fa too n abo toro n nu, na wɔ fa ama Yudasi, Simon Isikariyoti wa ni. ");
INSERT INTO cko_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yesu faari too n maari Yudasi wieeri ni, na Sitana awura i tii nu, na Yesu ase i ka, “Sa n bo a ŋa a yó i ni, kɔ yo i ndende.” ");
INSERT INTO cko_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ama, bu kɛrɛ bo bu woori diire n di su ni, bu be mmɔɔ asi má deke n bo i ti na Yesu seeri i sɔ ni. ");
INSERT INTO cko_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yudasi tiiri bu ŋwaa bita­fɔ n dɛɛ ti, bu nbem sunsun ka Yesu ŋa i kɔ to deke be na bu fa di cɛɛn­kpiri n wɔ, wara i kɔ yi ŋwaa n be fa ma yaari­fɔm wɔ. ");
INSERT INTO cko_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yudasi diiri too n wieeri ni, na wɔ yasu afite akɔ. Nyini saŋga ni, i ti kɔŋguɛ wɔ. ");
INSERT INTO cko_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yudasi fite kɔ wieeri ni, na Yesu ase ka, “Kisa ye Nyɛmɛ wúra mini Adamande Wa n kpiri a, na m dɛɛ ti ye minɛ wúra m Si Nyɛmɛ kpiri a. ");
INSERT INTO cko_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Na nzɛn bu wuraari Nyɛmɛ kpiri m dɛɛ ti, Nyɛmɛ gusu wúra m kpiri, na Nyɛmɛ má i yo kisa bɛrɛ.” ");
INSERT INTO cko_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Na wɔ se bu ka, “M nbaam, m cɛ́ má am nu fɛn. Am bá niɛniɛ m busu fie wɔ, na kabo m yo seeri Yuda­fɔm ni, sɔ ye m suse am kisa, ka am koro kɔ má deke bo m sukɔ ni. ");
INSERT INTO cko_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nɔaniɛ maa­wa fɔfɔrɛ ye m sufa ma am n a, yiri la ka, am koro am beŋgum. Kabo ma koro am ni, am koro am beŋgu sɔ. ");
INSERT INTO cko_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Nzɛn am koro am beŋgu, nyini ye sɔnɔ kɛrɛ si ka am ti m susu­fɔm a.” ");
INSERT INTO cko_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Na Simon Petoro abisa i ka, “Ya Mibiɛ, a kɔ́ ni wɔ?” Na Yesu abɔ i nu ka, “Deke bo m sukɔ ni, a koro su má m su kisa, ama, saŋga suba bo a bá su m su.” ");
INSERT INTO cko_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Na Petoro akaaki abisa i ka, “Ya Mibiɛ, nzu ti ye m koro su má u su kisa? Nzɛn i yo yiwee mmɔɔ a, m wú u dɛɛ ti.” ");
INSERT INTO cko_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Na Yesu abisa i ka, “A koro wu m dɛɛ ti? Nahɔrɛ ye m suse u a, kana akɔnyuma bá bo, a kéte kpe nsan su ka a si má m.” ");
INSERT INTO cko_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Na Yesu ase i susu­fɔm n ka, “Má am ma am ahore saaki. Am yo Nyɛmɛ yarada, na am yo m gusu yarada. ");
INSERT INTO cko_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","M Si Nyɛmɛ dika n nu, sɔɔm sunnu dɔ, nzɛn má i ti má sɔ, má m se má am. M kɔ́ na m kɔ sɛsɛ woo­biri su se am. ");
INSERT INTO cko_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Na nzɛn m kɔ sɛsɛ woo­biri n su seeri am, m káaki ba fa am kɔ deke bo m kɔ́ wo ni, na deke bo m wó ni, am gusu wó dɔ ɔ. ");
INSERT INTO cko_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Na deke bo m sukɔ ni, am si atin ni.” ");
INSERT INTO cko_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Na Tomasi ase i ka, “Ya Mibiɛ, ya si má deke bo a sukɔ ni, ye ya yo sɛ si atin n a?” ");
INSERT INTO cko_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Na Yesu ase i ka, “Mini ti atin n a, ni nahɔrɛ, ni ŋgɔɔ n a. Mini ŋgumi ti atin n bo sɔnɔ koro fa i na i kɔ m Si Nyɛmɛ dɔ a. ");
INSERT INTO cko_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nzɛn má am siiri m, má am si m Si mmɔɔ, ama, fa nyuma fa kɔ, am asi i, na am aŋu i.” ");
INSERT INTO cko_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Na Filipu ase i ka, “Ya Mibiɛ, kere ya u Si ni, deke bo ya koro i kɛrɛ lɛɛ.” ");
INSERT INTO cko_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Na Yesu abisa i ka, “Filipu, bo m ni ambɛrɛ awo bɛrɛ acɛ sɔ n na a si má m? Sɔnɔ kɛrɛ bo wɔ ŋu mini aŋu m Si lɛɛ, ye nzu ti ye am ŋa m kere am m Si n a? ");
INSERT INTO cko_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","A yo má yarada ka m ni m Si n ti deke kun wɔ, nzɛn sɛ? Jɔrɛ n bo ma jɔjɔ ama am ni, má m tiɛŋgu jɔjɔɔ­wa, ama, m Si bo m ni yiri ti kun ni, yo i juma. ");
INSERT INTO cko_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Bo m ŋa, m ni m Si n ti deke kun ni, am yo m yarada. Nzɛn má nyini, am yo m yarada sam bo m yo bu n dɛɛ ti. ");
INSERT INTO cko_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Nahɔrɛ ye m suse am n a. Sɔnɔ kɛrɛ bo i yo m yarada, yiri mmɔɔ yó ahin sam bo m yo bu ni, na i yó bo bu tara ahin mmɔɔ, dama m sukɔ m Si dɔ ɔ. ");
INSERT INTO cko_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Na deke kɛrɛ bo am fa m duma fa sereeri i, m yó i ma am, adena mini Baa ni má minɛm wura m Si kpiri. ");
INSERT INTO cko_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Na nzɛn am ba faari m duma fa sereeri m deke be, m yó i ma am.” ");
INSERT INTO cko_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Na Yesu ase bu ka, “Nzɛn am koro m, am dé m nɔaniɛ maa­wam ni. ");
INSERT INTO cko_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","M sére m Si Nyɛmɛ, na i má am Buka­fɔ fɔfɔrɛ bo i bá wo am dɔ saŋga kɛrɛ. ");
INSERT INTO cko_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Yiri la Awiɛwiɛ Casi n bo i se nahɔrɛ ni. Durunya n nu­fɔm koro de má i, dama bu ŋu má i, na bekun bu kaaki si má i, ama, ambɛrɛ si i, dama i wo am dɔ, na i bá wo am nu. ");
INSERT INTO cko_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","M kɔɔri, m yaki má am na am ka ayikam, m káaki ba am dɔ. ");
INSERT INTO cko_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Wɔ ka kaan na durunya n nu­fɔm ŋu má m kun, ama, ambɛrɛ ŋú m. M la ŋgɔɔ n dɛɛ ti, am gusu nyá ŋgɔɔ. ");
INSERT INTO cko_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Nyini cɛɛn n ye am sí ka mini ni m Si n ti deke kun a, na mini ni ambɛrɛ gusu ti deke kun wɔ. ");
INSERT INTO cko_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Sɔnɔ kɛrɛ bo i de m nɔaniɛ maa­wam, na i su i su, i mi ti bo i koro m a, na bo i koro m ni, m Si gusu koro yiri wɔ, na mini mmɔɔ kóro i mi, na m yí m ŋu kere i.” ");
INSERT INTO cko_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Na Yudasi, má Yudasi Isikariyoti ni, ase ka, “Ya Mibiɛ, nzu ti ye a yí u ŋu kere yɛrɛ a, ye a yí má u ŋu kere má durunya n nu­fɔm a?” ");
INSERT INTO cko_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Na Yesu ase i ka, “Sɔnɔ kɛrɛ bo i koro m, i dé m nɔaniɛ ni, na m Si mmɔɔ kóro i mi, na ya bá, na ya bá wo i dɔ. ");
INSERT INTO cko_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Sɔnɔ kɛrɛ bo i koro má m, i dé má m nɔaniɛ ni. Nɔaniɛ n bo ma jɔjɔ i ni, i ti má m dɛɛ nɔaniɛ, i ti m Si n bo i sunmaari m dɛɛ wɔ. ");
INSERT INTO cko_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","M toko wo am dɔ, ye m suse am ahin kɛrɛ a, ");
INSERT INTO cko_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","ama, m Si Nyɛmɛ súnma Buka­fɔ ni, m duma n nu, yiri la Awiɛwiɛ Casi ni, yiri kére am deke kɛrɛ a, na i káaki teŋge am su fa kɔ deke kɛrɛ bo ma kere am ni.” ");
INSERT INTO cko_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Na wɔ se bu ka, “Ahoreda n ye m sufa ma am n a. M dɛɛ ahoreda n ye m sufa ma am a. Má kabo durunya n nu­fɔm ma am ahoreda ye m suma am n a. Má am ma am ahore saaki, má am soro sɛrɛ. ");
INSERT INTO cko_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Am ati ka ma se ka, ‘M kɔ́ na m káaki ba am dɔ bekun.’ Nzɛn má am koro m, má am ahore jɔ ka m sukɔ m Si n dɔ, dama m Si tara m. ");
INSERT INTO cko_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Sa bo wɔ nya yo má lɛɛ, ye ma se am n a, adena i bá yoori, na am yo m yarada. ");
INSERT INTO cko_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","M jɔ́jɔ má am dɔ jɔrɛ beberebe kun, dama Sitana bo i ti durunya n nu­fɔm tii ni suba. Ama, i koro yo má m pui. ");
INSERT INTO cko_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","M koro ka durunya n nu­fɔm si ka, m koro m Si ni, nyini dɛɛ ti ye m yo deke kɛrɛ bo i se m ka m yo i n a.” Na wɔ se bu ka, “Am yasu na ya kɔ.” ");
INSERT INTO cko_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Na Yesu ase bu ka, “Mini ti baka n bo i su suu­wa nahɔrɛ su a, ye m Si Nyɛmɛ ti nyini baka n fie niɛ­fɔ. ");
INSERT INTO cko_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Asa­mbaa kɛrɛ bo i wo m su na i su má, m Si kpiɛ i ji wɔ, na asa­mbaa kɛrɛ bo i wo m su na i su, i kpiɛkpiɛ i nyawa n yo i dɔŋgu wɔ, na i su nyunyumi. ");
INSERT INTO cko_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Jɔrɛ n bo m jɔjɔ maari am ni, yiri adu mɔ ayo am casi a. ");
INSERT INTO cko_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Am wo ni mini na m gusu wo ni ambɛrɛ. Kabo baka asa­mbaa be wo má bɛrɛ bo i koro su i ŋgumi, má ka i wo baka n su. Sɔ ye am gusu koro su má, má ka am wo m dɔ. ");
INSERT INTO cko_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Mini ti baka n a, ye ambɛrɛ ti asa­mbaam ni, sɔnɔ kɛrɛ bo i wo m dɔ, na mini mmɔɔ wo i dɔ, i mi su suu­wa nyunyumi wɔ, dama am koro yo má pui, má ka am awo m dɔ. ");
INSERT INTO cko_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Sɔnɔ kɛrɛ bo i wo má m dɔ, bu kpiɛ i ji wɔ, kabo bu kpiɛ baka asa­mbaa na i wu n wɔ, na bu tiɛn bu nɔɔ wura sin nu na bu je ni. ");
INSERT INTO cko_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Nzɛn am wo m dɔ, na m nɔaniɛ n wo am ahore su, deke kɛrɛ bo am koroori i, na am sereeri Nyɛmɛ, am nyá i. ");
INSERT INTO cko_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nzɛn am su suu­wa nyunyumi, nyini kere ka am ti m susu­fɔm a, na i wura m Si kpiri. ");
INSERT INTO cko_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Kabo m Si koro m ni, sɔ ye mini mmɔɔ koro am a, am wo ni m koro ni. ");
INSERT INTO cko_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ma de m Si nɔaniɛ maa­wam n dɛɛ ti ye i koro m a. Nzɛn am gusu de m nɔaniɛ maa­wam ni, m gusu kóro am sɔ ɔ. ");
INSERT INTO cko_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ma se am ahin sam na am ahore jɔ kabo m ahore ajɔ n wɔ, na am ahore jɔ n kɔ sin su. ");
INSERT INTO cko_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","M nɔaniɛ maa­wa n la ka o, am koro am beŋgu kabo m koro am ni. ");
INSERT INTO cko_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Koro be wo má ahin koro n sin, ka sɔnɔ wu i danfom ti. ");
INSERT INTO cko_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Nzɛn am su m nɔaniɛ maa­wa n su, am ti m danfom wɔ lɛɛ. ");
INSERT INTO cko_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","M fere am m danfom wɔ, m fere má am ka m akɔɔm kun, dama sɔnɔ akɔɔ si má i mibiɛ sa­yoo­wa kɛrɛ, ama, deke kɛrɛ bo ma ti i m Si dɔ ni, ma fa akere am. ");
INSERT INTO cko_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Má ambɛrɛ yiiri m a, ama, mini ayi am ase ka am kɔ su suu­wa bo i wó bɛrɛ saŋga kɛrɛ, na deke kɛrɛ bo am bá fa m duma n sereeri m Si, i yó i ma am. ");
INSERT INTO cko_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Nɔaniɛ maa­wam n bo m sufa ma am la ka, am koro am beŋgum.” ");
INSERT INTO cko_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Na Yesu asa su ase bu ka, “Nzɛn durunya n nu­fɔm kpɔ am, am si nu ka o, ba du mɔ akpɔ mini wɔ, ye bu nya ba sukpɔ am n a. ");
INSERT INTO cko_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Nzɛn má am ti durunya n nu­fɔm dɛɛ minɛm, má bu koro am kabo bu koro bu beŋgu n wɔ. Ama, bo ma yi am afite durunya n nu­fɔm nu, na am ti má durunya n nu­fɔm dɛɛ minɛm n ti, ye bu kpɔ am n a. ");
INSERT INTO cko_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Má am ma am wara fi ka ma se am ka, akɔɔ tara má i mibiɛ. Nzɛn bu yo kereeri m wuwuruwa, sɔ ye bu kére am gusu wuwuruwa a. Na nzɛn bu yo deeri m nɔaniɛ, bu dé am gusu dɛɛ ni. ");
INSERT INTO cko_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Bu yó am nyini n kɛrɛ, m dɛɛ ti, dama bu si má m Si bo i sunmaari m ni. ");
INSERT INTO cko_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Nzɛn má ma ba akan má m ŋu jɔrɛ akere má bu, má bu si má ka ba yo satiɛ, ama, kisa na ma kan akere bu ni, bu koro kan fite má nu ka ba yo má satiɛ. ");
INSERT INTO cko_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Sɔnɔ kɛrɛ bo i kpɔ m, i kpɔ mini ni m Si n kɛrɛ wɔ lɛɛ. ");
INSERT INTO cko_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ma yo alekutura sam bo ba ŋu i. Be wo má bɛrɛ bo i koro yo nyini alekutura sam sɔ. Nzɛn má ma yo má nyini alekutura sam na ba ŋu má i, má be fa má bu ŋgasi ka bu ti satiɛ­yo­fɔm. Ama, kisa, ba ŋu nyini n kɛrɛ, na bu toko kpɔ m ni m Si ni. ");
INSERT INTO cko_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Nyini ma kabo ba kɛrɛ i Nyɛmɛ Jɔrɛ Kadasi n nu n ayo yii­wa n a, ka, ‘Bu kpɔ m kpɔ ŋgbɛɛn wɔ.’ ");
INSERT INTO cko_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Na Buka­fɔ n bo m súnma i fite m Si dɔ na i bá am dɔ ni, yiri ti Awiɛwiɛ Casi n bo i kere kabo Nyɛmɛ ti nahɔrɛ su n a, yiri dí m ŋusu daani kere am a. ");
INSERT INTO cko_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Na am gusu di m daani, dama m ni ambɛrɛ wo bɛrɛ a, fite m juma n bumboori ba ju ni kisa. ");
INSERT INTO cko_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","M suse am ahin sam kɛrɛ bo bu bá yo n wɔ, na bu ba yoori, na má am kaaki am sin bo m. ");
INSERT INTO cko_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Bu bá fɔn yi am fite bu tiɛntiɛn­bunɔɔ sɔɔm n nu, ama, saŋga suba bo bu bá kun am, na bu súnsun ka bu susu Nyɛmɛ wɔ. ");
INSERT INTO cko_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Bu si má m ni m Si n dɛɛ ti, ye bu yó nyini sam kɛrɛ n a. ");
INSERT INTO cko_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ma se am sam bo bu bá yo lɛɛ, na i saŋga ba juuri, na am téŋge su ka m yo seeri am.” Na Yesu asa su ase bu ka, “M ni ambɛrɛ yo woori bumboori n dɛɛ ti, ye ma yo ase má am ahin kɛrɛ a. ");
INSERT INTO cko_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ama, kisa m sukaaki kɔ yiri bo i sunmaari m n dɔ ɔ, ye am be akoro abisa má m ka, ‘Ye a sukɔ ni wɔ?’ ");
INSERT INTO cko_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Bo ma se ka m kɔ́ yaki am dɛɛ ti, am ahore asaaki agaya. ");
INSERT INTO cko_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ama, nahɔrɛ ye m suse am n a, i ti am buka su wɔ ka m kɔ, dama nzɛn má m kɔ má, má Buka­fɔ ni bá má, ama, nzɛn m kɔɔri, m súnma i am dɔ. ");
INSERT INTO cko_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","I baari, i kére durunya n nu­fɔm deke bo i ti satiɛ, na i kére bu deke bo i ti sakpa na i kɔ atin su Nyɛmɛ dɔ, na i káaki kere bu kabo Nyɛmɛ bá di sɔnɔ kɛrɛ jɔrɛ barasu. ");
INSERT INTO cko_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","I kére bu deke bo i ti satiɛ, dama bu yo má m yarada. ");
INSERT INTO cko_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Na i kére bu deke bo i ti kpa na i kɔ atin su Nyɛmɛ dɔ, dama m sukɔ m Si n dɔ ɔ, na am ŋú má m kun. ");
INSERT INTO cko_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Na i káaki kere bu kabo Nyɛmɛ bá di sɔnɔ kɛrɛ jɔrɛ, dama Nyɛmɛ adi Sitana bo i ti durunya n nu­fɔm kɛrɛ tii n jɔrɛ ayo i ŋgbɛɛn. ");
INSERT INTO cko_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","M toko la jɔrɛ dɔŋgu bo má m se am, ama, am koro de má i kɛrɛ kisa. ");
INSERT INTO cko_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ama, Awiɛwiɛ Casi n bo i se nahɔrɛ n ba baari, yiri kére am nahɔrɛ atin kɛrɛ a, dama jɔrɛ kɛrɛ bo i kán kere am ni, má i dɛɛ yiko nu ye i fá kan, ama, kabo Nyɛmɛ kére i ni, sɔ ye i kán, na i kére am sam bo bu bá yo ni. ");
INSERT INTO cko_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Yiri wúra m kpiri a, dama i kán m ŋu jɔrɛ kere am. ");
INSERT INTO cko_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Deke kɛrɛ bo i ti m Si dɛɛ, i ti m dɛɛ wɔ, nyini dɛɛ ti ye ma se am ka, i kán m ŋu jɔrɛ kere am n a.” ");
INSERT INTO cko_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Na Yesu ase bu ka, “Wɔ ka kaan na am ŋú má m, ama, i ba yoori kaan buka su na am ŋú m bekun.” ");
INSERT INTO cko_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Na i susu­fɔm n nbem abisa bu ŋuŋu nu ka, “Nzu jɔrɛ ye i jɔjɔɔri i sɔ n a? I ŋa, wɔ ka kaan na ya ŋú má i, ama, i ba yoori kaan buka su, ya ŋú i bekun. Ye wɔ kaaki ase bekun ka, i sukɔ i Si dɔ ɔ.” ");
INSERT INTO cko_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Na ba kaaki abisa bu ŋuŋu nu ka, “Ye ahin dɛɛ, i ba yoori kaan n bu la ka sɛ wɔ lɛɛ? Ya si má i jɔjɔɔ­wa n bu.” ");
INSERT INTO cko_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Na Yesu afa nu ka bu koro ka bu bisa i nyini jɔjɔɔ­wa n bu wɔ. Na wɔ bisa bu ka, “Bo m seeri ka wɔ ka kaan na am ŋú má m, ama, i ba yoori kaan buka su, am ŋú m bekun n ye am subisa am ŋuŋu nu, na am si i bu, nzɛn sɛ? ");
INSERT INTO cko_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nahɔrɛ ye m suse am a, ambɛrɛ bá sun na am kóko, ama, na durunya n nu­fɔm bɛrɛ ahore jɔ́. Ambɛrɛ ahore bá saaki, ama, am ahoresaaki ni bá kaaki ahorejɔ. ");
INSERT INTO cko_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Nzɛn bara anya akutu ka i wu baa, i la ahoresaaki, dama i wahara saŋga ye wɔ ju a, ama, i ba wuuri baa n wieeri, i téŋge má i wahara n bo wɔ sin n su kun, dama baa n bo wɔ wu i durunya n nu n ti, i ahore ajɔ. ");
INSERT INTO cko_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","I ti sɔ ɔ, am gusu dɔ, kisa, am la ahoresaaki, ama, m bá ŋu am bekun, na am ahore jɔ́ bo sɔnɔ koro dé má am ahorejɔ n am dɔ. ");
INSERT INTO cko_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Nyini cɛɛn ni, am bísa má deke be busu m dɔ. Nahɔrɛ ye m suse am a, deke kɛrɛ bo am sereeri m Si ni, m duma n nu, i yó i ma am. ");
INSERT INTO cko_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Am nya sere má m Si deke be m duma n nu haari ni nyuma. Kisa am sere i, na am nyá i, na am ahore jɔ́ kɔ sin su.” ");
INSERT INTO cko_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Na Yesu ase bu ka, “Ma se am ahin n kɛrɛ anyundɛrɛ nu wɔ lɛɛ, saŋga suba bo m bó má am anyundɛrɛ kun, ama, m kán m Si ŋu jɔrɛ kɛrɛ kpain kere am a. ");
INSERT INTO cko_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Nyini cɛɛn ni, am fá m duma n fa sere Nyɛmɛ, má mini sere Nyɛmɛ ma am a. ");
INSERT INTO cko_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Yiri m Si ni i tii koro am a, dama am koro m na am ayo yarada ka m fite i dɔ ɔ. ");
INSERT INTO cko_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","M fiteeri m Si dɔ ɔ baari durunya n nu a, ye kisa m sufite durunya n nu kaaki kɔ i dɔ a.” ");
INSERT INTO cko_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Na Yesu susu­fɔm n ase i ka, “Kisa a jɔjɔ ya dɔ wein­wein wɔ, a bo má ya anyundɛrɛ kun. ");
INSERT INTO cko_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ama, kisa ya si ka a si deke kɛrɛ, wɔ ti má ye ni ka be bisa u deke be, dama kana bu ba bisa u deke be, a si kabo bu koro ka bu bisa u ni, nyini ma ya si ka a fite Nyɛmɛ dɔ n a.” ");
INSERT INTO cko_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Na wɔ bisa bu ka, “Am ayo yarada kisa? ");
INSERT INTO cko_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ama, saŋga suba bo wɔ ju awie, bo am kɛrɛ bá sandi yaki mini ŋgumi, na sɔnɔ kɛrɛ kɔ́ i dika, ama, m wo má m ŋgumi, dama m Si Nyɛmɛ wo m dɔ. ");
INSERT INTO cko_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ma se am ahin kɛrɛ na am la ahoreda m dɔ. Am ŋú kekereke durunya n nu, ama, am fa ahoresi, dama ma kunma durunya ni.” ");
INSERT INTO cko_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesu seeri sɔ wieeri ni, na wɔ yɛ i tii su aniɛ aŋgoro na wɔ sere Nyɛmɛ. I ŋa, “M Si, saŋga n aju. Wura mini u Wa n kpiri, adena m gusu wura u kpiri. ");
INSERT INTO cko_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Dama a ma m yiko ka m niɛ minɛm kɛrɛ su, na bo a fa bu ama m ni, m má bu ŋgɔɔ bo i la má awieeri. ");
INSERT INTO cko_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Wɔrɔ ŋgumi ti Nyɛmɛ nahɔrɛ su a. Na minɛ bo bu si u, na bu si mini Yesu Kristo n bo a sunmaari m ni, bɛrɛ la ŋgɔɔ bo i la má awieeri n a. ");
INSERT INTO cko_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ma wura u kpiri durunya n nu, dama ma yo juma n bo a ma m ka m yo i n awie. ");
INSERT INTO cko_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","M Si, saŋga bo durunya nya bo má i bu ni, m yo woori u dɔ ɔ, ye a wura m kpiri a. Kisa, kaaki wura m kpiri u dɔ bekun. ");
INSERT INTO cko_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Minɛm n bo a yiiri bu fiteeri durunya n nu fɛn, ma kere bu kabo a ti barasu. Bu tiiri u dɛɛm wɔ, ye a faari bu maari m a, ye ba de u nɔaniɛ n a. ");
INSERT INTO cko_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Kisa bu si ka deke kɛrɛ bo a fa ama m ni, fite u dɔ ɔ. ");
INSERT INTO cko_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Dama nɔaniɛ n kɛrɛ bo a jɔjɔ fa maari m ni, m gusu ajɔjɔ ama bu, ye ba de i, ye ba si ka i ti nahɔrɛ ka m fiteeri u dɔ ɔ, ye ba yo yarada ka wɔrɔ sunmaari m a. ");
INSERT INTO cko_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","M susere u ma bɛrɛ wɔ, má bo bu wo durunya n nu ni, ama, minɛm bo a fa bu ama m ni, bɛrɛ ye m sere u ma bu a, dama bu ti u dɛɛ minɛm wɔ. ");
INSERT INTO cko_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","M minɛm kɛrɛ ti u dɛɛm wɔ, ye u dɛɛm gusu kɛrɛ ti m dɛɛm, ye ba ma minɛm aŋu m jirima woo­wa ni. ");
INSERT INTO cko_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Kisa, m suba u dɔ lɛɛ, m ká má durunya n nu fɛn kun, ama, bɛrɛ ká fɛn wɔ. M Si, wɔrɔ bo a ti casi ni, yo bu kanda u duma n bo a fa maari m n yiko nu, na bu yo deke kun, kabo mini ni wɔrɔ ti kun ni. ");
INSERT INTO cko_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Saŋga bo m woori bu dɔ ni, m yoori bu kanda u duma n bo afa ama m yiko nu wɔ. M niɛɛri bu su, na bu be aka má ŋgbɛɛn, má ka bo wɔ ka ŋgbɛɛn haari i ni kunnu ni, adena kabo ba kɛrɛ i Nyɛmɛ Jɔrɛ Kadasi n nu n yo yii­wa. ");
INSERT INTO cko_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Kisa m suba u dɔ lɛɛ, ama, m toko wo durunya n nu ye m jɔjɔ ahin jɔjɔɔ­wa n na bu nya m dɛɛ ahorejɔ n kɔ sin su. ");
INSERT INTO cko_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ma fa u nɔaniɛ n afa ama bu, na kabo m ti má durunya n nu fɛn fɔ be ni, sɔ ye bu gusu ti má durunya n nu fɛn fɔm a, nyini dɛɛ ti, durunya n nu­fɔm koro má bu jɔrɛ. ");
INSERT INTO cko_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","M susere má u ka a yi bu fite durunya n nu wɔ, ama, m susere u ka a kanda Sitana satiɛ­yo­fɔ ni, na i yaki bu. ");
INSERT INTO cko_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Kabo m ti má durunya n nu fɛn fɔ ni, sɔ ye bu gusu ti má durunya n nu fɛn fɔm a. ");
INSERT INTO cko_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","U nɔaniɛ n ti nahɔrɛ wɔ. Ma u nɔaniɛ n bo i ti nahɔrɛ n yo bu casi. ");
INSERT INTO cko_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Kabo a sunmaari m durunya n nu ni, sɔ ye m gusu asunma bu a. ");
INSERT INTO cko_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Bɛrɛ dɛɛ ti, ye ma fa m ŋu ama u a, adena bɛrɛ gusu fa bu ŋu ma u nahɔrɛ n dɛɛ ti. ");
INSERT INTO cko_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","M susere má u ma má bɛrɛ ŋgumi wɔ, ama, m susere u ma minɛm bo bu bá yo m yarada ahinm dɛɛ nɔaniɛ kaan­wa n ti wɔ. ");
INSERT INTO cko_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","M Si, m sere u ka a ma bu kɛrɛ yo kun, kabo a wo m dɔ, na m gusu wo u dɔ ni, ma bɛrɛ gusu wo ya dɔ, adena durunya n nu­fɔm yo yarada ka wɔrɔ sunmaari m a. ");
INSERT INTO cko_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","U jirima woo­wa n bo a maari m ni, ma fa ama bu, na bu yó kun kabo m ni wɔrɔ ti kun ni. ");
INSERT INTO cko_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","M wo bu dɔ, na u gusu wo m dɔ, nyini ma bu yo deke kun kabo a koro ka bu ti n a, na durunya n nu­fɔm si ka wɔrɔ sunmaari m a, na kabo a koro m ni, a koro u minɛm gusu sɔ ɔ. ");
INSERT INTO cko_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","M Si, m koro ka a ma minɛm bo a fa bu ama m n bá wo m dɔ, deke bo m wo ni, na bu ŋú m jirima woo­wa n bo a fa maari m ni, dama saŋga bo a nya ayi má durunya n ye a koro m a. ");
INSERT INTO cko_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","M Si, wɔrɔ yo sa kɛrɛ bo i kɔ atin su n a, durunya n nu­fɔm si má u, ama, mini si u, na ahinm gusu si ka wɔrɔ sunmaari m a. ");
INSERT INTO cko_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ma kere bu kabo a ti barasu, na m toko sukere bu wɔ, adena koro n bo a koro m n wó bu nu, na m ni bɛrɛ yó kun.” ");
INSERT INTO cko_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesu sereeri Nyɛmɛ wieeri ni, na i ni i susu­fɔm n ayasu akɔ akpiɛ Kɛdɔrɔn nzuetin n buekun dɔ, deke bo baka fie be wo ni, na ba kɔ awura baka fie n nu. ");
INSERT INTO cko_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yudasi bo i sutɔ Yesu ma i kpɔ­fɔm ni si dika n nu, dama Yesu ni i susu­fɔm nati tiɛn bu nɔɔ dɔ ɔ saŋga saŋga. ");
INSERT INTO cko_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Na Yudasi aba dɔ. Sojam su i su, ni tintini­jina­fɔm bo Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm nkpiɛn­kpiɛnm n ni Farasi­fɔm asunma bu n buka su. Bu bita fitanam, ni wura sinm, ni biɛsɔya neŋgem. ");
INSERT INTO cko_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesu si sa kɛrɛ bo i bá tu i ni, na wɔ kpa bu atin abisa bu ka, “Am koro ŋma a?” ");
INSERT INTO cko_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Na ba bɔ i nu ase i ka, “Ya koro Yesu Nazarɛti­fɔ n wɔ.” Na wɔ se bu ka, “Yiri la mini.” Yudasi bo i tɔɔri i ni jina sojam n nu. ");
INSERT INTO cko_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yesu seeri ka, “Yiri la mini” ni, na bu kɛrɛ akɔkɔ bu sin akpakpaasi asiɛŋgu. ");
INSERT INTO cko_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Na wɔ kaaki abisa bu bekun ka, “Am koro ŋma a?” Na ba se i ka, “Ya koro Yesu Nazarɛti­fɔ n wɔ.” ");
INSERT INTO cko_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Na wɔ se bu ka, “Ma se am ka yiri la mini. Nzɛn am koro mini wɔ, am ma ahin minɛm bɛrɛ kɔ.” ");
INSERT INTO cko_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","I seeri sɔ ni, na i nɔaniɛ bo i yo jɔjɔɔri i n ayo yii­wa, ka, “Minɛm bo a fa bu ama m ni, m ma má bu be ka má ŋgbɛɛn.” ");
INSERT INTO cko_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Nyini saŋga Simon Petoro jina bita takobe, na wɔ cin awɔrɔ i akpiɛ sɔnɔ be sui, i saa fɔmbɔrɔ dɛɛ ni, nyini sɔnɔ n ti Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm kpiɛn n akɔɔ ɔ. Bu fere i ka Malikusi. ");
INSERT INTO cko_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Na Yesu ase Petoro ka, “Fa u takobe n wura i buɛ nu. A ŋa má m ŋu anyum­boro n bo m Si afa ama m n wɔ?” ");
INSERT INTO cko_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Na sojam, ni bu kpiɛn, ni Yuda­fɔm nkpiɛn­kpiɛnm n tintini­jina­fɔm n atara Yesu acici i nyama. ");
INSERT INTO cko_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Bu du mɔ faari i kɔɔri sɔnɔ be bo bu fere i ka Anasi n dɔ ɔ ka. Anasi sibiɛ la Kayafasi. Kayafasi ti Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm kpiɛn n nyini afɔ n a. ");
INSERT INTO cko_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Yiri Kayafasi ti bo i yo seeri Yuda­fɔm ka i ti ye ni ka sɔnɔ kun wu ma minɛm kɛrɛ n a. ");
INSERT INTO cko_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Bu taraari Yesu sukɔ ni, na Simon Petoro ni Yesu susu­fɔ n kun asu i su akɔ. Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm kpiɛn n si nyini Yesu susu­fɔ n dɛɛ ti, ye i suuri Yesu su wuraari yiri Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm kpiɛn n gisan nu a. ");
INSERT INTO cko_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ama, na Petoro yiri aka ajina dasin anɔ n nu, na yiri susu­fɔ n bo Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm kpiɛn n si i ni afite, na wɔ ba afani n bo i jina kanda anɔ n dɔ, na wɔ sere i atin na wɔ fa Petoro awura. ");
INSERT INTO cko_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Na afani n bo i jina kanda anɔ n abisa Petoro ka, “Wɔrɔ mmɔɔ ti nyini sɔnɔ n susu­fɔm nu kun wɔ, má sɔ?” Na Petoro ase i ka, “Ai, m ti má bu kun.” ");
INSERT INTO cko_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ayɛrɛ saŋga lɛɛ, na Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm kpiɛn ni ngbɛfɛnɛm, ni tintini­jina­fɔm atɔrɔ sin wo tun su, na Petoro gusu ajina bu bi sutun sin n be. ");
INSERT INTO cko_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Na Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm n kpiɛn n abisa Yesu fa kɔ i susu­fɔm n jɔrɛ, ni kabo i keree­wa n ti barasu ni. ");
INSERT INTO cko_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Na Yesu ase i ka, “Saŋga kɛrɛ m jɔjɔ sɔnɔ kɛrɛ nyunu wɔ, na m kere bu Nyɛmɛ nɔaniɛ ni bu tiɛntiɛn­bunɔɔ sɔɔm n nu, ni Nyɛmɛ Seree­biri Awuru n nu, deke bo Yuda­fɔm kɛrɛ tiɛn bu nɔɔ ni, m kan má jɔrɛ be fiɛɛ­wa nu. ");
INSERT INTO cko_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ye nzu ti ye a bisa m a? Bisa minɛm bo bu tiiri m keree­wa n ka m seeri bu sɛ wɔ. Bɛrɛ si kabo m seeri bu n a.” ");
INSERT INTO cko_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yesu seeri sɔ ni, na tintini­jina­fɔ n bo i jina dodo i n abo i nyɔɔnu, na wɔ bisa Yesu ka, “Sɔ ye a bɔ Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm kpiɛn n nu a?” ");
INSERT INTO cko_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Na Yesu ase i ka, “Nzɛn ma jɔjɔ jɔrɛ bo wɔ kɔ má atin su, kan na m ti. Ye nzɛn bo ma se n ti nahɔrɛ, nzu ti ye a bo m nyɔɔnu a?” ");
INSERT INTO cko_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Na Anasi ama ba fa i ni nyama cicii­wa n sɔ akɔ Kayafasi bo i ti Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm n kpiɛn n dɔ. ");
INSERT INTO cko_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simon Petoro jina woori sin n tun su ni, na ba bisa i ka, “Wɔrɔ mmɔɔ ti i susu­fɔm kun wɔ, má sɔ?” Na Petoro akete, i ŋa, “Ai, m ti má bu kun.” ");
INSERT INTO cko_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Na Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm kpiɛn n akɔɔ be, i dika­fɔ la sɔnɔ n bo Petoro kpiɛ yiiri i sui ni, na wɔ se Petoro ka, “Ma ŋu má u ka a wo i bi baka fie n nu dɔ?” ");
INSERT INTO cko_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Na Petoro akete bekun, kpeŋga akɔnyuma abo. ");
INSERT INTO cko_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Na alecin ŋgarama fun na ba fa Yesu afite Kayafasi dika n nu, na ba fa i akɔ gomina n dika, bu fere gomina n ka Pilato. Yuda­fɔm awura má gisan nu, adena má bu yo bu ŋu fin, na bu koro di má Butara cɛɛn­kpiri ni. ");
INSERT INTO cko_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Nyini ti, na Pilato afite aba bu dɔ dasin abisa bu ka, “Ahin sɔnɔ n bo am afa i aba m dɔ ni, i ŋgasi la bɔnɔ?” ");
INSERT INTO cko_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Na ba se i ka, “Nzɛn má wɔ do má ŋgasi be, má ya fa má i ba má u dɔ.” ");
INSERT INTO cko_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Na Pilato ase bu ka, “Ambɛrɛ mmɔɔ ni am tii fa i kɔ di i jɔrɛ kabo am jɔrɛ­di atin kere ni.” Na Yuda­fɔm n ase i ka, “Ya la má atin bo ya kun sɔnɔ.” ");
INSERT INTO cko_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Bu seeri sɔ ni, adena Yesu nɔaniɛ n bo i seeri kabo i bá wu barasu n yo yii­wa. ");
INSERT INTO cko_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Na Pilato akaaki awura gisan n nu, na wɔ fere Yesu abisa i ka, “Wɔrɔ ti Yuda­fɔm Fɛmɛ n a?” ");
INSERT INTO cko_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Na Yesu abisa i ka, “U dɛɛ sunsunni nu lɛɛ, nzɛn be seeri u a?” ");
INSERT INTO cko_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Na Pilato abisa i ka, “M ti Yuda­fɔ ɔ? U minɛm ni Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm nkpiɛn­kpiɛnm ni faari u baari m dɔ a. A do nzu ŋgasi wɔ?” ");
INSERT INTO cko_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Na Yesu ase i ka, “M fɛmɛya n ti má durunya n nu fɛn fɛmɛya. Nzɛn má m fɛmɛya n ti durunya n nu fɛn fɛmɛya, má m susu­fɔm bá kun luɛ m busu, na má be koro tara má m wura má Yuda­fɔm saa nu. Ama, m fɛmɛya n ti má durunya n nu fɛn dɛɛ.” ");
INSERT INTO cko_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Na Pilato abisa i bekun ka, “Ŋka a ti fɛmɛ wɔ lɛɛ?” Na Yesu ase i ka, “Bo a ŋa m ti fɛmɛ ni, i ti sɔ ɔ. Bu wuuri m durunya n nu ka m ba di nahɔrɛ n daani wɔ. Na sɔnɔ kɛrɛ bo i su nahɔrɛ n su, i de m nɔaniɛ n wɔ.” ");
INSERT INTO cko_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Na Pilato abisa i ka, “Nahɔrɛ la nzu wɔ?” Pilato seeri i sɔ, na wɔ kaaki afite akɔ Yuda­fɔm dɔ akɔ ase bu ka, “Ma ŋu má i ŋgasi be wɔ do i. ");
INSERT INTO cko_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ama, am la am yoo­wa be bo i ma m atin ka m yi dan­saraka kun ma am Butara cɛɛn­kpiri n di saŋga. Am koro ka m yi ambɛrɛ Yuda­fɔm Fɛmɛ ni ji ma am a, nzɛn sɛ?” ");
INSERT INTO cko_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Na ba tiɛn ase ka, “Má yiri. Ya koro Barabasi wɔ.” Barabasi ti sɔnɔ bo i nati fin minɛm di wɔ. ");
INSERT INTO cko_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Na Pilato ama ba fa Yesu akɔ afin i ŋgbere. ");
INSERT INTO cko_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Na sojam n awura i tanlɛɛ kɔkɔrɛ yorom ka fɛmɛya dɛɛ su, na ba fa buwe aŋɔ i ka kaba dɛɛ su, na ba fa aforo i tii. ");
INSERT INTO cko_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Na bu suba i dɔ suyo i anzasi se i ka, “Yuda­fɔm Fɛmɛ, ya yo u ansɛ.” Na ba bo i nyɔɔnu. ");
INSERT INTO cko_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Na Pilato akaaki afite aba Yuda­fɔm dɔ aba ase bu ka, “Am ti fɛn, m sufa i fite ba kere am wɔ, na am si ka ma ŋu má ŋgasi bo wɔ do i.” ");
INSERT INTO cko_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Yesu tiɛ fiteeri ni tanlɛɛ kɔkɔrɛ yorom ni, ni i tii buwe kaba n ni, na Pilato ase bu ka, “Am niɛ, sɔnɔ n yaa.” ");
INSERT INTO cko_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Deke bo i tiɛ fiteeri na Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm nkpiɛn­kpiɛnm ni tintini­jina­fɔm ŋuuri i sɔ ni, kpeŋga na ba tiɛn, bu ŋa, “Am kpama i baka jaanu n su na i wu. Am kpama i.” Na Pilato ase bu ka, “Ambɛrɛ mmɔɔ ni am tii fa i kɔ kpama i e. Mini, ma ŋu má ŋgasi bo wɔ do i.” ");
INSERT INTO cko_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Na ba se i ka, “Ya la nɔaniɛ kpamaa­wa be, wɔ yo daka ka i wu, dama i ŋa i ti Nyɛmɛ Wa a.” ");
INSERT INTO cko_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilato tiiri ka Yesu ŋa i ti Nyɛmɛ wa ni, na sɛrɛ ati i abuka su. ");
INSERT INTO cko_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Na wɔ kaaki awura gisan n nu abisa Yesu ka, “A fite ni wɔ?” Ama, Yesu abɔ má i nu. ");
INSERT INTO cko_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Na Pilato akaaki abisa i ka, “A bɔ má m nu? A si má ka m la yiko bo m koro ma bu fa u ji, na m kaaki la yiko bo m koro ma bu kpama u baka jaanu n su?” ");
INSERT INTO cko_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Na Yesu ase i ka, “Nzɛn má Nyɛmɛ ama má u atin, maala má yiko bo a koro yo m pui. Nyini ti, sɔnɔ n bo i faari m wuraari u saa nu ni, i satiɛ yoo­wa tara u dɛɛ.” ");
INSERT INTO cko_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","I seeri sɔ ni, na Pilato akpi kabo i yo na i yaki Yesu nu ji. Ama, na Yuda­fɔm sutiɛntiɛn suse ka, “Nzɛn a yakiiri i nu jiiri, u ni Fɛmɛ Siza danfoya awie lɛɛ, dama sɔnɔ kɛrɛ bo i yo i ŋu ka i ti fɛmɛ, i mi ti Fɛmɛ Siza kpɔ­fɔ ɔ.” ");
INSERT INTO cko_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilato tiiri sɔ ni, na wɔ fa Yesu afite, na wɔ tana jɔrɛ dii­biri n su bimbindi n su. Yuda­fɔm aniɛ nu bu fere i ka Gabata, i bu la ka, deke bo ba fa yabuɛ asɛsɛ su ayo i dɔŋgu ni. ");
INSERT INTO cko_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Nyini cɛɛn n tiiri bu Butara cɛɛn­kpiri n kpokpo cɛɛn wɔ, wiɛsu kerefi buru ni nnyɔ saŋga a. Na Pilato ase Yuda­fɔm ka, “Am fɛmɛ n yaa.” ");
INSERT INTO cko_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Na ba kaaki atiɛn ase ka, “Am fa i kɔ, am fa i kɔ kpama i baka jaanu n su.” Na Pilato abisa bu ka, “M fá am fɛmɛ n kɔ kpama i baka jaanu n su?” Na Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm nkpiɛn­kpiɛnm n ase ka, “Ya la má fɛmɛ be sin Fɛmɛ Siza ŋu.” ");
INSERT INTO cko_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Bu seeri sɔ wieeri ni, na Pilato anya afa i ama bu ka bu kɔ kpama i baka jaanu n su. Na ba de Yesu akɔ. ");
INSERT INTO cko_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Na yiri ni i tii asɔ i baka jaanu n akɔ awɔrɛ n bo bu fere i ka Tere­awa Woo­biri ni, Yuda­fɔm aniɛ nu bu fere dɔ ka Gologota. ");
INSERT INTO cko_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Na ba kpama i baka jaanu n su dɔ, na ba kaaki akpama minɛ nnyɔ nbem adodo i, bu kpamaari kun i saa fɔmbɔrɔ su, na ba kpama kun i saa biɛ su, na Yesu awo bu afiɛn. ");
INSERT INTO cko_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Na Pilato akɛrɛ kɛrɛɛ­wa be amata i tii su baka jaanu n su. Kɛrɛɛ­wa n la ka, “Yesu Nazarɛti­fɔ n bo i ti Yuda­fɔm Fɛmɛ n lɛɛ.” ");
INSERT INTO cko_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Bu kɛrɛɛri nyini kɛrɛɛ­wa n Yuda­fɔm, ni Roma­fɔm, ni Giriki­fɔm dɛɛ aniɛm kɛrɛ nu wɔ, na Yuda­fɔm dɔŋgu aŋu i, na ba kan i, dama deke bo bu kpamaari i n waari má ni miɛ kunnu. ");
INSERT INTO cko_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Na Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm nkpiɛn­kpiɛnm n akete ase Pilato ka, “Má a kɛrɛ ka, ‘Yuda­fɔm Fɛmɛ n lɛɛ,’ ama, kɛrɛ ka, ‘Ahin sɔnɔ ŋa, “Mini ti Yuda­fɔm Fɛmɛ n a.”’ ” ");
INSERT INTO cko_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Na Pilato ase bu ka, “Bo ma kɛrɛ i ni, nyini lɛɛ wɔ.” ");
INSERT INTO cko_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Sojam n kpamaari i baka jaanu n su wieeri ni, na ba kpaaki i neŋge wuraa­wam nu busu nna, na bu kɛrɛ afa kun kun, na wɔ ka i tanlɛɛ yorom bo i wo i bu na i wura be gɔ su ni, i la má gise kpaa­biri, ama, ba wu i kɛrɛ aŋgoro kɔ jura asiɛŋgu wɔ. ");
INSERT INTO cko_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Na ba se ka, “Má am ma ya sɔnsɔn i nu, ama, am ma ya tu mbaa na ya si bo i dí i.” Bu yoori sɔ adena Nyɛmɛ Jɔrɛ Kadasi n yo yii­wa, bo ba kɛrɛ i ka, “Ba kpaaki m neŋge wuraa­wam nu, na ba tu mbaa m tanlɛɛ n bo i wo m bu n busu ni.” Nyini ti ye sojam yoori sɔ n a. ");
INSERT INTO cko_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Na Yesu ni, ni Yesu ni niɛma­bara, ni Kolopasi yi Mariya, fa kɔ tuuri Mariya n bo i fite Magadala n jina dodo deke bo bu kpamaari Yesu ni. ");
INSERT INTO cko_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesu niɛ ŋuuri i ni ni, ni i susu­fɔ n bo i koro i agaya n ka bu jina dodo i ni, na wɔ se i ni n ka, “M ni, niɛ fɛn, u wa la ahin.” ");
INSERT INTO cko_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Na wɔ se i susu­fɔ n gusu ka, “Niɛ fɛn, u gusu ni lɛɛ.” Nyini cɛɛn n kɛrɛ na Yesu susu­fɔ n afa Yesu ni, na wɔ kɔ awo i dɔ. ");
INSERT INTO cko_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Nyini sin na Yesu asi nu ka wɔ yo i juma kɛrɛ awie, na wɔ se ka, “Nzuehɔɛ ti m wɔ.” I seeri sɔ ni, adena Nyɛmɛ nɔaniɛ n yo yii­wa. ");
INSERT INTO cko_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Nyini saŋga dundu be taka bɛrɛ, wɔ yi ni nzan gagaraki, na ba fa mɛnɛ afa awɔ baka su afa abo nu alaandi atɔ i nɔɔ. ");
INSERT INTO cko_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesu de nu wieeri ni, na wɔ se ka, “Wɔ wie.” Na wɔ biri i tii, na wɔ yo Nyɛmɛ dɛɛ. ");
INSERT INTO cko_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Nyini cɛɛn n ti Ŋumi­yi cɛɛn n kpokpo cɛɛn n ti, ba koro má ka minɛm bo ba kpama bu baka jaanu n su n ka sense su bu Ŋumi­yi cɛɛn ni, dama Ŋumi­yi cɛɛn n bo i suba n ti cɛɛn­kpiri bambaka bu dɔ ɔ. Nyini dɛɛ ti, ye bu sereeri Pilato ka i ma bu kɔ bubu bo ba kpama bu baka jaanu n su jaam n a, na bu yi bu kɔ se bu. ");
INSERT INTO cko_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Nyini ti, na sojam n akɔ abo abubu sɔnɔ n kun jaam, ni nyiŋga n gusu dɛɛ, bɛrɛ n bo bu kpamaari bu dodoori Yesu ni. ");
INSERT INTO cko_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ama, saŋga bo bu ba kpuraari Yesu ni, bu ŋuuri ka yiri awu, nyini dɛɛ ti, ba bubu má i jaam. ");
INSERT INTO cko_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ama, na sojam kun afa kpiɛ awɔ Yesu nvin nu, kpeŋga na nzue ni mbunja susoŋgi fite. ");
INSERT INTO cko_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Sɔnɔ n bo i nyu­mbaa ŋuuri i ni, yiri di i daani a, adena am yo yarada. I jɔrɛ n ti nahɔrɛ wɔ, na kabo i di daani n gusu ti nahɔrɛ wɔ. ");
INSERT INTO cko_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ahin n kɛrɛ yoori, adena kabo ba kɛrɛ i Nyɛmɛ Jɔrɛ Kadasi n nu n yo yii­wa. Ba kɛrɛ ka, “I buwe kun n kpein mmɔɔ bu má.” ");
INSERT INTO cko_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ye ba kaaki akɛrɛ ka, “Minɛm bá niɛ yiri n bo ba wɔ i kpiɛ n wɔ.” ");
INSERT INTO cko_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Nyini dɛɛ sin, na sɔnɔ be bo bu fere i ka Yosefu n asere Pilato atin na i yi Yesu ŋuniɛ n kɔ se i. Na Pilato ama i atin, na wɔ kɔ ayi i ŋuniɛ n baka jaanu n su akɔ. Yiri Yosefu fite miɛ kpiri n bo bu fere i ka Aramatiya n su wɔ, i yo tiiri Yesu susu­fɔm kun wɔ, ama, i soroori Yuda­fɔm ahore ti, wɔ yi má i ŋu fofoe nu. ");
INSERT INTO cko_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Na Nikodemo bo i yo baari Yesu dɔ kɔŋguɛ be n gusu aba, i bita ŋguin nva­nvani ni tulaalɛɛ saŋgaa­wa, i nɔnɔɔri ju pobu abura­na. ");
INSERT INTO cko_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Na ba fa Yesu ŋuniɛ ni, na ba yo i kabo Yuda­fɔm yo bu fuin na bu se i ni, bu faari tulaalɛɛ n gɔɔri i ŋu wɔ, na ba nya afa nzee apɔɔndi i. ");
INSERT INTO cko_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Deke bo bu kpamaari Yesu ni, baka fie be wo dɔ. Nyini baka fie n nu yabuɛ buɛ bo ba lokoti i ayo i faŋ­kunma wo dɔ, bo bu nya se má fuin nu ni. ");
INSERT INTO cko_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Nyini cɛɛn n ti Ŋumi­yi cɛɛn n kpokpo n dɛɛ ti, na bekun, faŋ­kunma n waari má ni bɛrɛ ni, ye bu faari i kɔ seeri nu n a. ");
INSERT INTO cko_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Yuda­fɔm bakuɛ n bumboori, mɔnɛ cɛɛn ŋgarama fuun, nyini saŋga dika toko ti liim, na Mariya n bo i fite Magadala n akɔ yabuɛ buɛ faŋ­kunma n su. I kɔ juuri ni, i ŋuuri ka ba yi yabuɛ bambaka n bo bu fa tɔɔri faŋ­kunma n anɔ ni. ");
INSERT INTO cko_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Na wɔ ŋmati akɔ Simon Petoro ni Yesu susu­fɔ n bo i koro i agaya n dɔ, na wɔ se bu ka, “Ba yi Mibiɛ n faŋ­kunma n nu, ya si má deke bo ba fa i akɔ ase.” ");
INSERT INTO cko_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Na Petoro ni i lamɔkɔ n ayasu ka bu kɔ faŋ­kunma n su. ");
INSERT INTO cko_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Bu minɛ nnyɔ ni suŋmati kɔ a, ama, na kun n aŋmati asin Petoro ŋu adu mɔ aju faŋ­kunma n su. ");
INSERT INTO cko_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Na wɔ kasi aniɛ faŋ­kunma n nu, aŋu ka nzee n da, ama, wɔ wura má faŋ­kunma n nu. ");
INSERT INTO cko_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ama, na Simon Petoro yiri aka sin aba aju, na wɔ wura faŋ­kunma n nu, aŋu ka nzee n da, ");
INSERT INTO cko_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","na wɔ ŋu ka tani n bo bu fa ciinri Yesu tii ka kaba n gusu bubu nu da i ŋgumi. ");
INSERT INTO cko_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Nyini saŋga na yiri n bo i du mɔ juuri faŋ­kunma n su n awura nu, i ŋuuri i ni, na wɔ yo yarada kabo Yesu yo seeri bu ni. ");
INSERT INTO cko_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ama, ba nya asi má Nyɛmɛ Jɔrɛ Kadasi n bo i ŋa Yesu téŋge i yiwee n nu n bu. ");
INSERT INTO cko_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Na ba kaaki akɔ awuru. ");
INSERT INTO cko_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ama, na Mariya aka ajina faŋ­kunma n su, na i susun. I wo sun su ni, na wɔ kasi aniɛ faŋ­kunma n nu. ");
INSERT INTO cko_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Na wɔ ŋu mɛrɛkɛm nnyɔ ka bu wura tanlɛɛ fofoe tana deke bo bu faari Yesu ŋuniɛ n daari ni, kun tana deke bo bu faari i tii wɔɔri ni, na nyiŋga gusu tana deke bo bu faari i jaa wɔɔri ni. ");
INSERT INTO cko_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Na ba bisa i ka, “Bara, nzu ti ye a sun a?” Na wɔ se bu ka, “Ba yi m Mibiɛ n wɔ, ye m si má deke bo ba fa i ase.” ");
INSERT INTO cko_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","I seeri sɔ ni, na wɔ kaaki aniɛ i sin. I ŋuuri ka Yesu jina, ama, wɔ si má ka Yesu lɛɛ. ");
INSERT INTO cko_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Na Yesu abisa i ka, “Bara, nzu ti ye a sun a? A koro ŋma a?” Mariya ŋuuri i sɔ ni, i sunsun ka fie n niɛ­fɔ a. Na wɔ se i ka, “M jakpiɛn, nzɛn wɔrɔ ayi i akɔ ase deke be a, kere m na m kɔ fa i.” ");
INSERT INTO cko_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Na Yesu afere i ka, “Mariya.” Na wɔ kaaki aniɛ Yesu dɔ, na wɔ se i ka, “Raboni.” Yuda­fɔm dɛɛ aniɛ n nu, i bu la ka, ya Kere­fɔ. ");
INSERT INTO cko_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Na Yesu ase i ka, “Má a fa u saa kan m, dama ma nya akɔ má m Si dɔ, ama, kɔ na a kɔ se m ninbaam n ka, ‘M sukɔ m Si bo i ti am Si ni, ni m Nyɛmɛ bo i ti ambɛrɛ mmɔɔ Nyɛmɛ n dɔ.’” ");
INSERT INTO cko_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Na Mariya n bo i fite Magadala n akɔ ase bu ka, “Ma ŋu Mibiɛ ni.” Na wɔ se bu jɔrɛ n kɛrɛ bo Yesu akan akere i ni. ");
INSERT INTO cko_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Na bakuɛ n bumboori, mɔnɛ cɛɛn n naasɔ saŋga, na Yesu susu­fɔm woori sɔɔ be nu, na ba tu anɔ n agɔ bu ŋu, dama bu soroori Yuda­fɔ nkpiɛn­kpiɛnm wɔ. Na Yesu aba ajina bu afiɛn ase bu ka, “Am ma am ahore da.” ");
INSERT INTO cko_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","I seeri sɔ wieeri ni, na wɔ fa i saam deke bo bu boori i bulaari ni, ni i nvin deke bo bu wɔɔri i kpiɛ n akere bu. I susu­fɔm ŋuuri i sɔ ni, na bu ahore ajɔ. ");
INSERT INTO cko_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Na wɔ kaaki ase bu ka, “Am ma am ahore da, kabo m Si sunmaari m ni, sɔ ye mini gusu susunma am a.” ");
INSERT INTO cko_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","I seeri sɔ wieeri ni, na wɔ yi i ŋumi agɔ bu ŋu, na wɔ se bu ka, “Am de Nyɛmɛ Awiɛwiɛ Casi ni. ");
INSERT INTO cko_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Sɔnɔ kɛrɛ bo am faari i satiɛ ceeri i, Nyɛmɛ fá i satiɛ ce i. Ama, sɔnɔ kɛrɛ bo am fa má i satiɛ ce má i, Nyɛmɛ fá má i satiɛ ce má i.” ");
INSERT INTO cko_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Saŋga bo Yesu yiiri i ŋu kereeri i susu­fɔm buru ni nnyɔm ni, bu nu kun awo má bu nu. Yiri la Tomasi bo bu fere i ka Ndaa ni. ");
INSERT INTO cko_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","I ba baari ni, na ba se i ka, “Ya ŋu Mibiɛ ni.” Na wɔ se bu ka, “Má ka ma ŋu i saa kunma n bo bu kpamaari i ni, na m fa m saa maraka wura nu, na m fa m saa wura i nvin nu deke bo bu wɔɔri i kpiɛ ni, m yó má yarada fieo.” ");
INSERT INTO cko_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Na i le­mɔcuɛ cɛɛn, na ba wo sɔɔ n nu bekun. Nyini cɛɛn ni, Tomasi gusu woori bu nu, na ba yandi atu anɔ ni. Na Yesu aba ajina bu nu, na wɔ se bu ka, “Am ma am ahore da.” ");
INSERT INTO cko_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Na wɔ se Tomasi ka, “Fa u saa maraka ba wura m saa kunma n nu, na a fa u saa ba wura m nvin kunma n nu. Na a yaki sika na a yo yarada.” ");
INSERT INTO cko_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Na Tomasi ase i ka, “Wɔrɔ ti m Mibiɛ, ni m Nyɛmɛ a.” ");
INSERT INTO cko_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Na Yesu ase i ka, “Bo a ŋu m ti ye a yo yarada? Tere­fiɛ wo bu dɔ, bo bu nya ŋu má m na bu yo yarada ni.” ");
INSERT INTO cko_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu yo yoori alekutura sam beberebe na i susu­fɔm n aŋu i, ama, ba kɛrɛ má i kɛrɛ awura má ahin kadasi n nu. ");
INSERT INTO cko_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ama, ba kɛrɛ ahinm ni, adena am yo yarada ka Yesu Nyɛmɛ Wa ni ti Kristo n a, Tii­de­fɔ n bo Nyɛmɛ ase ka i súnma i ni, na am yarada ni ma am nya ŋgɔɔ i dɛɛ duma n nu. ");
INSERT INTO cko_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Nyini sin, na Yesu ayi i ŋu akere i susu­fɔm n bekun kunma kpiri n bo bu fere i ka Tiberiya n nɔɔ su. Kabo i faari i ŋu kereeri bu n la ka, ");
INSERT INTO cko_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","i susu­fɔ nbem atiɛn bu nɔɔ, bɛrɛ la Simon Petoro, ni Tomasi n bo bu fere i ka Ndaa ni, ni Nataniɛli n bo i fite Kana bo i wo Galili asiɛn n su ni, ni Zɛbɛdi nbaa nnyɔm ni, ni i susu­fɔ nnyɔ nbem. ");
INSERT INTO cko_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Na Simon Petoro ase bu ka, “M sukɔ jombaa tara lɛɛ.” Na ba se i ka, “Yɛrɛ mmɔɔ sú u su kɔ ɔ.” Na ba wura lee n nu akɔ, bu woori nzue n nu haari ale kɔ sucin, ba nya koro tara má pui. ");
INSERT INTO cko_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Saŋga bo ale ba ciinri wein ni, na Yesu aba ajina kunma n nɔɔ su, ama, i susu­fɔm n asi má ka yiri lɛɛ. ");
INSERT INTO cko_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Na wɔ bisa bu ka, “M nbaam, am anya má jombaa, má sɔ?” Na ba se i ka, “Ai, ya nya má be.” ");
INSERT INTO cko_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Na wɔ se bu ka, “Am sandi am diɛndiɛ n lee n fɔmbɔrɔ su dɛɛ bue ni, am nyá be.” Bu sandiiri ni, na ba tara jombaa beberebe, haari ba koro ama má diɛndiɛ n su. ");
INSERT INTO cko_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Na Yesu susu­fɔ n bo i koro i agaya n ase Petoro ka, “Ya Mibiɛ lɛɛ.” Deke bo Petoro tiiri ka, bu Mibiɛ lɛɛ ni, nyini saŋga i jina i ŋuniɛ ŋgbɛɛn wɔ. Na wɔ yo ndende afa i tanlɛɛ abo i wi nu, na wɔ ti ato nzue n nu. ");
INSERT INTO cko_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ama, na i beŋgu susu­fɔm n bo bu wo lee n nu ni, sucin diɛndiɛ n bo wɔ yi ni jombaa ni, na bu fa ba kunma n nɔɔ su ni. Deke bo bu wo n ni kunma n nɔɔ su n waari má, i tiiri ajaari natii­wa yaa kun wɔ. ");
INSERT INTO cko_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Bu cin kɔ juuri kunma n nɔɔ su ni, na bu fiteeri lee n nu ni, bu ŋuuri ka sin­mɔnɛ da, jombaa nana su, kpɔnɔ da bɛrɛ. ");
INSERT INTO cko_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Na Yesu ase bu ka, “Am fa jombaa n bo am atara bu kisa n be bra.” ");
INSERT INTO cko_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Na Simon Petoro awura lee n nu, na wɔ cin diɛndiɛ n bo wɔ yi ni jombaa ŋgbiŋgbiri n aba ahɛmɛ. Jombaa n kɛrɛ kɔ yasuuri yaa ni aburu­nu ni nsan a, ama, haari ni nyini jombaa beberebe n kɛrɛ, diɛndiɛ n ati má. ");
INSERT INTO cko_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Na Yesu ase i susu­fɔm n ka, “Am ba yo daraka.” Bu be abo má su, na i bisa i ka, “Wɔrɔ ŋma?” dama bu kɛrɛ si ka bu Mibiɛ n a. ");
INSERT INTO cko_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Na Yesu aba afa kpɔnɔ n ama bu, na wɔ fa jombaa n gusu abuka bu su. ");
INSERT INTO cko_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ahin yoori kpe nsan su, bo i yiiri i ŋu kereeri i susu­fɔm n a, saŋga bo i teŋgeeri i yiwee n nu ni. ");
INSERT INTO cko_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Bu yoori daraka n wieeri ni, na Yesu abisa Simon Petoro ka, “Yohane wa Simon, a koro m tara kabo nyiŋgam ni koro m ni?” Na wɔ se i ka, “Ɛɛn, m Mibiɛ, wɔrɔ mmɔɔ si ka m koro u.” Na Yesu ase i ka, “Niɛ m nbɔmbaam dika.” ");
INSERT INTO cko_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Na wɔ kaaki abisa i kpe nnyɔ su ka, “Yohane wa Simon, a koro m?” Na Petoro ase i ka, “Ɛɛn, m Mibiɛ, wɔrɔ mmɔɔ si ka m koro u.” Na Yesu ase i ka, “Niɛ m nbɔɛm dika.” ");
INSERT INTO cko_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Na wɔ kaaki abisa i kpe nsan su ka, “Yohane wa Simon, a koro m?” Na Petoro ahore asaaki kabo wɔ bisa i kpe nsan su kɛrɛ ka, i koro i ni? Na Petoro ase i ka, “M Mibiɛ, wɔrɔ si deke n kɛrɛ a, a si ka m koro u.” Na Yesu ase i ka, “Niɛ m nbɔɛm dika. ");
INSERT INTO cko_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nahɔrɛ ye m suse u n a, ka saŋga bo a yo ti gbɛfɛnɛ ni, wɔrɔ mmɔɔ ni u tii bo u wi nu kujara kɔ deke kɛrɛ bo a koro a, ama, a ba yoori kpiɛn, a yɛ́ u saa su aŋgoro wɔ, na be bó u kujara na i fá u kɔ deke bo a koro má ni.” ");
INSERT INTO cko_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","I seeri sɔ n na i kere kabo Petoro bá wu barasu, na minɛm ŋú kabo Nyɛmɛ jirima woo­wa n ti barasu. Nyini sin na wɔ se Petoro ka, “Su m su.” ");
INSERT INTO cko_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Na Petoro akaaki aniɛ aŋu ka bɛrɛ susu­fɔm nu kun bo Yesu koro i agaya n su bu su. Yiri la bo bu yo sudi diire na i tana mataari Yesu na i bisaari i ka, “M Mibiɛ, ŋma tɔ́ u n a?” ");
INSERT INTO cko_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Petoro ŋuuri ka i su bu su sɔ ni, na wɔ bisa Yesu ka, “M Mibiɛ, ye ahin n gusu di?” ");
INSERT INTO cko_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Na Yesu ase i ka, “Nzɛn m koro ka i wo bɛrɛ haari saŋga bo m bá kaaki ba, i nya u sɛ? Wɔrɔ su m su.” ");
INSERT INTO cko_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","I seeri sɔ n na labari n abara ayɛ i susu­fɔm dɔ, ka i nyini susu­fɔ ni wú má. Yesu ase má ka i wú má, ama, i ŋa, “Nzɛn m koro ka i wo bɛrɛ haari saŋga bo m bá kaaki ba, i nya u sɛ?” ");
INSERT INTO cko_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Nyini Yesu susu­fɔ ni diiri ahin jɔrɛm kɛrɛ daani a, yiri kaaki kɛrɛɛri ahin jɔrɛm kɛrɛ a, na ya si ka i daani dii­wa n ti nahɔrɛ n a. ");
INSERT INTO cko_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesu yo yoori sam dɔŋgu, bo má bu ŋa bu kɛrɛ i kɛrɛ, ma de má ka bu nyá fofoe durunya n nu, bo bu fá nyini kadasim n kɛrɛ fa se.");
INSERT INTO cko_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ya si Teyofilosi, m kadasi n bo m du mɔ kɛrɛ maari u ni, m yo seeri u fa kɔ sam bo Yesu yo yoori bu n kɛrɛ, ni kabo i kereeri minɛm, saŋga bo i boori i juma n bu ni, ");
INSERT INTO cko_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","haari fa kɔ ju saŋga bo Nyɛmɛ faari i fun kɔɔri aŋgoro ni. Kana i ba fun kɔ ni, Nyɛmɛ Awiɛwiɛ Casi n dɛɛ yiko nu ye i yo seeri i jaramasam bo wɔ yi bu n sam bo bu bá yo n a. ");
INSERT INTO cko_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Yesu wu teŋgeeri n dɛɛ sin, na wɔ wo durunya n nu cɛɛn abura­na, na i suyi i ŋu sukere bu saŋga saŋga su, bo i kere ka i la ŋgɔɔ nahɔrɛ su. Na ba ŋu i, na wɔ jɔjɔ bu dɔ fa kɔ Nyɛmɛ fɛmɛya n su. ");
INSERT INTO cko_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Na saŋga bo Yesu ni i jaramasam ba tiɛɛnri bu nɔɔ wo diire di su ni, na wɔ se bu ka, “Má am se ka am fite Yɛrusalem miɛ kpiri n nu, ama, am ŋminda kɔ ju saŋga bo m Si Nyɛmɛ fá Awiɛwiɛ Casi n bá ma am, yiri ye i yo seeri ka i fá ma am n a. Yiri ye m yo kaanri i jɔrɛ kereeri am n a. ");
INSERT INTO cko_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yohane yo faari nzue biɛɛri am a, ama, i cɛ má, mini fá Awiɛwiɛ Casi n ba wura am ŋu a.” ");
INSERT INTO cko_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Na saŋga bo Yesu ni i jaramasam n ba tiɛɛnri bu nɔɔ ni, na ba bisa i ka, “Ya Mibiɛ, kisa ye a káaki fa fɛmɛya n ma yɛrɛ Yisareli­fɔm, nzɛn sɛ?” ");
INSERT INTO cko_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Na Yesu ase bu ka, “Deke bo m Si Nyɛmɛ koro ka i yo i, ye i yo a, ambɛrɛ koro si má nyini saŋga wara cɛɛn ni.” ");
INSERT INTO cko_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ama, saŋga bo Awiɛwiɛ Casi n ba wuraari am ŋu, i má am faŋga na am dí m ŋusu daani Yɛrusalem miɛ kpiri n nu, ni Yudiya awɔrɛ n kɛrɛ nu, ni Samariya awɔrɛ n kɛrɛ nu, haari kɔ kpura durunya n kɛrɛ pepere su. ");
INSERT INTO cko_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Saŋga bo Yesu seeri sɔ wieeri ni, na Nyɛmɛ ama wɔ fun akɔ aŋgoro, bu toko jina wo niɛ su ni, na yinyiŋgu akata i ŋu, ba ŋu má i kun. ");
INSERT INTO cko_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Bu jina wo niɛ su kabo i sufun kɔ aŋgoro n nu barasu ni, na minɛ nnyɔ nbem akaba aba ajina bu bi, bu wura sutura fofoe, ");
INSERT INTO cko_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","na ba bisa bu ka, “Galili­fɔm, nzu ti ye am jina niɛ aŋgoro n nu sɔ a? Yiri Yesu ni, kabo am aŋu ka i sufun kɔ aŋgoro n nu barasu ni, am bá kaaki ŋu i sɔ ɔ lɛɛ, saŋga bo i bá sukpie i nyi ba ni.” ");
INSERT INTO cko_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Nyini saŋga ni, Yesu jaramasam yo woori buka n bo bu fere i ka Oliva Buka n su wɔ. Dɔ ni Yɛrusalem miɛ kpiri n nu waari má. Na ba kpie bu nyi akɔ Yɛrusalem. ");
INSERT INTO cko_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Bu kɔ juuri n na ba fun akɔ aŋgoro sɔɔ n bo bu da nu n ni. Bɛrɛ bo bu kɔɔri dɔ n la Petoro, ni Yohane, ni Yakobo, ni Andere, ni Filipu, ni Tomasi, ni Batolomeyo, ni Matio, Yakobo bo i si la Alafeyo ni, ni Simon bo i tu ŋgoni fa kɔ i asiɛn su ni, ni Yudasi bo i si la Yakobo ni. ");
INSERT INTO cko_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Bu tiɛn bu nɔɔ sɔ ɔ saŋga kɛrɛ, na bu susere Nyɛmɛ, bu ni nbaram nbem, ni Yesu ni Mariya, ni Yesu niɛmam ni. ");
INSERT INTO cko_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Cɛɛn be sɔ ɔ, na yarada­yo­fɔm n atiɛn bu nɔɔ, bu kɛrɛ kɔ yasuuri minɛ yaa ni abura­nyɔ ɔ. Dɔ na Petoro ayasu ajina bu afiɛn ase bu ka, ");
INSERT INTO cko_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“M ninbaam, wɔ yo daka ka nɔaniɛ n bo Awiɛwiɛ Casi n yo maari Fɛmɛ Davidi nɔɔ na i kɛrɛɛri i Nyɛmɛ Jɔrɛ Kadasi n nu n yo yii­wa, kabo i kɛrɛɛri fa kɔ Yudasi jɔrɛ ni, ka yiri dú minɛm bo bu ba tara Yesu n mɔ a. ");
INSERT INTO cko_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yudasi yo tiiri ya nu kun wɔ, ya ni yiri saŋga yoori juma n a.” ");
INSERT INTO cko_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Ya si Teyofilosi, si nu ka Yudasi afa ŋwaa n bo i yoori satiɛ na i nyaari i ni, na wɔ fa ato asiɛn, dɔ na wɔ kpaasi, na wɔ wu, na i kunnu atiɛ, na i ayaya kɛrɛ afite agɔ. ");
INSERT INTO cko_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Na Yɛrusalem­fɔm kɛrɛ ati nyini jɔrɛ ni, nyini ti, na ba fere nyini asiɛn ni, bu aniɛ nu ka Akelidama, i bu la ka, Mbunja Asiɛn. ");
INSERT INTO cko_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Tɔ, na Petoro akaaki ase bu ka, “Bu yo kɛrɛɛri i Kansi Jue kɛrɛɛ­wam n nu, ka, ‘Ma i dika n ka bɔnfɔ, na má be wo nu.’ Na wɔ kaaki akɛrɛ ka, ‘Ma sɔnɔ be de i jinaa­biri ni.’ ");
INSERT INTO cko_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Nyini ti, wɔ yo daka ka i mi ti sɔnɔ bo i woori ya nu, saŋga bo ya Mibiɛ Yesu woori bɛrɛ na ya nati tiɛn ya nɔɔ i dɔ ni, fite saŋga n bo Yohane biɛɛri Yesu Nyɛmɛ nzue ni, haari fa kɔ juuri cɛɛn n bo Nyɛmɛ maari Yesu fun kɔɔri aŋgoro yakiiri ya ni.” ");
INSERT INTO cko_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Nyini ti, na ba yi minɛ nnyɔ ajina. Bu kun la Yosefu bo bu fere i ka Basabasi, na bu kaaki fere i ka Jusitosi ni, ye kun n la bo bu fere i ka Matiyasi ni. ");
INSERT INTO cko_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Dɔ na ba sere Nyɛmɛ, bu ŋa, “Ya Mibiɛ, wɔrɔ si kabo sɔnɔ kɛrɛ sunsunni ti barasu a. Ahin minɛ nnyɔm ni nu, kere ya bo a koro ka ya yi i, ");
INSERT INTO cko_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","na i yo u jaramasa na i yo ahin juma ni, na i jina Yudasi jinaa­biri, yiri bo wɔ yaki u akɔ i koroo­biri ni.” ");
INSERT INTO cko_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Na ba tu mbaa na bu yi minɛ nnyɔm nu kun, na ba yi Matiyasi abuka Yesu jaramasa buru ni kunm n su. ");
INSERT INTO cko_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Yuda­fɔm cɛɛn­kpiri n bo bu fere i ka Pɛntɛkoti n di cɛɛn, nyini saŋga ni, na Yesu susu­fɔm kɛrɛ atiɛn bu nɔɔ dika hɔrɛ kun. ");
INSERT INTO cko_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Kpeŋga na ba ti naŋmiɛ be ŋga aŋgoro n nu ka aŋuma bo i sukpiɛ faŋga su, na wɔ de sɔɔ n bo bu tana nu n kɛrɛ abara ayɛ. ");
INSERT INTO cko_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Dɔ na ba ŋu deke be ka sin taferema dɛɛ su, na wɔ sandi atantana bu kun kun n kɛrɛ tii su. ");
INSERT INTO cko_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Na Awiɛwiɛ Casi n awura bu kɛrɛ ŋu, na bu sujɔjɔ aniɛ barasu barasu bo Awiɛwiɛ Casi n ma bu koro jɔjɔ i. ");
INSERT INTO cko_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Tɔ, nyini saŋga, Yuda­fɔm bo bu soro Nyɛmɛ n atiɛn bu nɔɔ Yɛrusalem miɛ kpiri n nu, bu fiteeri durunya n awɔrɛ n kɛrɛ baari a, ka bu ba su Nyɛmɛ. ");
INSERT INTO cko_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Saŋga bo bu tiiri naŋmiɛ ni ŋga sɔ ni, na jama beberebe aba atiɛn bu nɔɔ, na jɔrɛ n amiɛ bu, dama bu kɛrɛ tiiri ka Yesu susu­fɔm ni sujɔjɔ bɛrɛ kun kun n kɛrɛ bo ba tiɛn bu nɔɔ n dɛɛ aniɛ nu. ");
INSERT INTO cko_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Na ba birisi na ba yo alekutura, na ba se ka, “Ahin minɛm kɛrɛ bo bu wo jɔjɔ su n ti Galili­fɔm wɔ, ");
INSERT INTO cko_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","ye i baari sɛ, ye bu sujɔjɔ, ye ya kun kun n kɛrɛ ti ka bu jɔjɔ ya dɛɛ aniɛm n a? ");
INSERT INTO cko_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ya fite awɔrɛ barasu barasu kɛrɛ n nu wɔ, nbem fite Patiya, na nbem fite Mediya, na nbem fite Elam, na nbem fite Mesopotamiya, na nbem fite Yudiya, na nbem fite Kapadosiya, na nbem fite Pontusi ni Esiya, ");
INSERT INTO cko_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","na nbem fite Firigiya, na nbem fite Pamfiliya, na nbem fite Ijipiti asiɛn n su, na nbem fite Libiya asiɛn bo i wo dodo Sirene miɛ kpiri n ni. Ya nbem gusu fite Roma miɛ kpiri n su wɔ. ");
INSERT INTO cko_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ya nbem ti Yuda­fɔm, ni minɛm bo bu ti má Yuda­fɔm na ba kaaki bu wo ka bu ti Yuda­fɔm ni, ye ya nbem gusu fite Kereti asiɛn n su, na nbem fite Arabiya asiɛn n su, ama, ya kɛrɛ ti ka bu jɔjɔ ya dɛɛ aniɛm n nu wɔ, fa kɔ sakpa­kpam kɛrɛ bo Nyɛmɛ ayo bu n su.” ");
INSERT INTO cko_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Na ba yo alekutura, ba si má kabo bu yo, na bu subisa bu ŋuŋu nu ka, “Ahin sa n bu la ka sɛ wɔ lɛɛ?” ");
INSERT INTO cko_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ama, na bu nbem ayo Yesu susu­fɔm n anzasi, na ba se ka, “Ai, ba nu nzan abo wɔ.” ");
INSERT INTO cko_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Dɔ na Petoro ni i beŋgu buru ni kunm n ayasu ajina, na wɔ yɛ i konvi su ase jama n ka, “M lamɔkɔ Yuda­fɔm, ni ambɛrɛ kɛrɛ bo am wo Yɛrusalem miɛ kpiri n nu ni, am so am sui nyunyumi na am ti deke n bo m sukan kere am ni. ");
INSERT INTO cko_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ahin minɛm bo am sunsun ka ba nu nzan abo ni, ba nu má nzan, kisa ŋgarama kerefi ŋgɔna ye ya wo nu n a. ");
INSERT INTO cko_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ama, nyini n bo am ti ka bu jɔjɔ aniɛ barasu barasu ni, i ti kabo Nyɛmɛ nɔaniɛ kan­fɔ Jowɛli yo jɔjɔɔri n wɔ lɛɛ, i ŋa, ");
INSERT INTO cko_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Nyɛmɛ ŋa o, fa kɔ durunya n awieeri, m fá m Awiɛwiɛ n wura minɛm kɛrɛ ŋu. Na am nbaa­biɛsɔm ni nbaa­baram kán Nyɛmɛ nɔaniɛ n kere minɛm, na am ngbɛfɛnɛm ŋú deke nbem nahɔrɛ su ka alɛlɛ nu, na am nkpiɛn­kpiɛnm dá cin alɛlɛ. ");
INSERT INTO cko_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Nahɔrɛ, nzɛn cɛɛn n ba juuri, m fá m Awiɛwiɛ n wura m akɔɔm n ŋu, i bara ni i biɛsɔ kɛrɛ, na bu kán m nɔaniɛ n kere minɛ. ");
INSERT INTO cko_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Na m yó alekutura sam barasu barasu beberebe aŋgoro ni asiɛŋgu fɛn, na am ŋú mbunja, ni sin, ni ŋmisini bambaka. ");
INSERT INTO cko_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Na wiɛ n sí biri, na sara n káaki kɔkɔrɛ ka mbunja. Nyini sin, na Mibiɛ n cɛɛn bambaka n bo i la jirima n nyá ju. ");
INSERT INTO cko_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Nyini cɛɛn ni, sɔnɔ kɛrɛ bo i bo fereeri Mibiɛ n duma, i mi nyá tii­de.’” ");
INSERT INTO cko_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Na Petoro ase bu ka, “Ambɛrɛ Yisareli­fɔm, am so am sui na am ti fɛn. Nyɛmɛ akere am ka yiri sunmaari Yesu bo i fite Nazarɛti miɛ n nu n a. Nyini ti, ye i ma i yoori alekutura sam, ni sa ŋgbiŋgbirim am nu n a, kabo ambɛrɛ ni am tii si i ni. ");
INSERT INTO cko_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Nyɛmɛ dɛɛ koroya­nu, ye i du mɔ ciciiri ka i má am nya Yesu taraa­biri a, ye am faari i wuraari minɛ tiɛm saa nu, ye bu kpamaari i baka jaanu n su kuunri i n a. ");
INSERT INTO cko_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ama, na Nyɛmɛ ateŋge i afite i yiwee n nu, yiwee akoro ala má i yiko, dama i tiiri kekereke na yiwee koro kunma i. ");
INSERT INTO cko_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Dama Fɛmɛ Davidi yo jɔjɔɔri fa kɔ yiri Yesu ŋusu jɔrɛ, i ŋa, ‘Ma ŋu i ka Mibiɛ n wo m dɔ saŋga kɛrɛ, nyini dɛɛ ti, puitiri­pui koro yo má m. ");
INSERT INTO cko_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Nyini dɛɛ ti, m ahore ti daa­wa, na m jɔjɔ ni ahorejɔ, haari ni bo m bá wu ni, m la tama fa kɔ m ŋuniɛ­mbaa n su, ");
INSERT INTO cko_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","dama wɔrɔ Nyɛmɛ, a yáki má m na m ka fuinm n nu, a yáki má na u dɛɛ amusui­su­fɔ casi ka mini sɔ wu kpɔrɔ. ");
INSERT INTO cko_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","A kere m atin bo m fa na m nya ŋgɔɔ, na kabo a wo m dɔ ni, nyini má m la ahorejɔ nahɔrɛ su a.’ ");
INSERT INTO cko_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","M ninbaam, m koro ka m se am nahɔrɛ su wɔ, fa kɔ ya na Fɛmɛ Davidi ŋusu jɔrɛ. I yo wuuri wɔ, na ba se i, i faŋ­kunma toko wo ya nu fɛn haari ni nyuma. ");
INSERT INTO cko_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","I tiiri Nyɛmɛ nɔaniɛ kan­fɔ n dɛɛ ti, na wɔ si ka Nyɛmɛ atan ndiɛ ka, i yí yiri Fɛmɛ Davidi busu nu­fɔm n nu kun, na i dí i fɛmɛya n kabo yiri Fɛmɛ Davidi yo tiiri barasu ni. ");
INSERT INTO cko_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Fɛmɛ Davidi du mɔ ŋuuri sa n bo Nyɛmɛ bá yo i ni, na wɔ jɔjɔ fa kɔ Kristo su, Tii­de­fɔ n bo Nyɛmɛ ase ka i súnma i ni, ka i bá wu na i téŋge i yiwee nu, i ŋa, ‘Nyɛmɛ yáki má na i ka fuinm nu, na i ŋuniɛ­mbaa n kpɔ́rɔ.’ ");
INSERT INTO cko_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Yiri Yesu n ye Nyɛmɛ teŋgeeri i yiwee n nu a, na ya kɛrɛ aŋu i, ye ya sudi i daani a. ");
INSERT INTO cko_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","I Si Nyɛmɛ ayɛ i su akɔ aŋgoro afa atana i saa fɔmbɔrɔ su, ye wɔ ma i Awiɛwiɛ Casi n bo wɔ se ka i fá ma i ni. Deke bo am aŋu i ni, ni deke n bo am ati i ni, yiri la Awiɛwiɛ Casi n bo i seeri ka i fá ma ya ni. ");
INSERT INTO cko_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Má Fɛmɛ Davidi ni i tii fun kɔɔri aŋgoro a, ama, na wɔ se ka, ‘Micɛra n ase m Mibiɛ n ka, “Bra, ba tana m saa fɔmbɔrɔ su fɛn, ");
INSERT INTO cko_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","haari m bá ma a kunma u kpɔ­fɔm.”’ ” ");
INSERT INTO cko_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Na Petoro akaaki ase ka, “I ti ye ni ka Yisareli­fɔm kɛrɛ si ka, yiri Yesu n bo ambɛrɛ yo kpamaari i baka jaanu n su n ye Nyɛmɛ afa i ayo Mibiɛ n ni Kristo, ya Tii­de­fɔ n a.” ");
INSERT INTO cko_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Saŋga bo minɛm n tiiri ahin jɔrɛ n sɔ ni, na bu ahore asaaki agaya, na ba bisa Petoro ni Yesu jaramasa nyiŋgam n ka, “Ya ninbaam, ye ya yo sɛ wɔ?” ");
INSERT INTO cko_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Na Petoro ase bu ka, “Am kaaki am wo, na ya bíɛ am kun kun kɛrɛ Nyɛmɛ nzue, Yesu Kristo dɛɛ duma n nu, na Nyɛmɛ fá am satiɛ ce am, na i fá Awiɛwiɛ Casi n ce am. ");
INSERT INTO cko_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Dama Nyɛmɛ yo seeri ka i fá Awiɛwiɛ Casi n ma ambɛrɛ ni am busu nu­fɔm, ni minɛm bo bu wo dede ni, ni minɛm kɛrɛ bo ya Micɛra Nyɛmɛ n fere bu ka bu bra yiri ni i tii dɔ n wɔ.” ");
INSERT INTO cko_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Na Petoro ajɔjɔ jɔrɛ beberebe atu bu fɔ ni anyum­boro su, i ŋa, “Am yi am ŋu fite sui­cin n bo Nyɛmɛ bá fa cin ahin nyuma­fɔ satiɛ­yo­fɔm n nu.” ");
INSERT INTO cko_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Na bu dɔŋgu ayo i nɔaniɛ n yarada, na ba biɛ bu Nyɛmɛ nzue, nyini cɛɛn ni, na ba nya minɛ, ba yo ka akpii nsan abuka bu ŋu su. ");
INSERT INTO cko_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Na bu nyunu aboro ka bu sɔnsɔn Yesu jaramasam keree­wam ni, na bu kɛrɛ ayo anɔɔkun, na bu susaŋga di diire, na bu susaŋga sere Nyɛmɛ. ");
INSERT INTO cko_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Na Nyɛmɛ ama Yesu jaramasam n ayo alekutura sam barasu barasu beberebe, na sɔnɔ kɛrɛ asoro Nyɛmɛ. ");
INSERT INTO cko_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Na yarada­yo­fɔm n ayo deke kɛrɛ ni anɔɔsɛ, na ba soro su ka, deke kɛrɛ bo bu la i n ti bu kɛrɛ dɛɛ wɔ. ");
INSERT INTO cko_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Bu tɔ bu neŋge kɛrɛ bo bu la i wɔ, na bu kpaaki ŋwaa n nu, na bo bu la má be n kɛrɛ nya be. ");
INSERT INTO cko_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Cɛɛn n kɛrɛ cɛɛn, bu ba tiɛn bu nɔɔ Nyɛmɛ Seree­biri Awuru n nu wɔ, na bu nati sutiɛn bu nɔɔ awuru awurum nu, na bu saŋga di diire ni ahorejɔ, ni bu kunnu fofoe, ");
INSERT INTO cko_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","na bu sukansi Nyɛmɛ, na minɛm akoro bu jɔrɛ. Na cɛɛn kɛrɛ cɛɛn na bu sunya minɛm bo Nyɛmɛ ma bu anya tii­de n abuka bu ŋu su. ");
INSERT INTO cko_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Cɛɛn n be naasɔ wiɛ kerefi nsan saŋga, na Petoro ni Yohane akɔ Nyɛmɛ Seree­biri Awuru n nu ka bu kɔ sere Nyɛmɛ. Saŋga bo bu fa sere Nyɛmɛ lɛɛ. ");
INSERT INTO cko_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Sɔnɔ be woori dɔ, bu wuuri i wɔbuka wɔ, na minɛ nbem asɔ i aba atana Nyɛmɛ Seree­biri Awuru nu anɔ n bo bu fere i ka Anɔ Nyunyumi ni, na i tana susere minɛm bo bu ba nyɛmɛsere ni, ka bu ma i ŋwaa. Cɛɛn n kɛrɛ cɛɛn bu fa i ba wɔ, na i ba susere. ");
INSERT INTO cko_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Nyini cɛɛn ni, saŋga bo i ŋuuri Petoro ni Yohane ka bu suwura Nyɛmɛ Seree­biri Awuru n nu ni, na wɔ sere bɛrɛ gusu ka bu ma i deke be. ");
INSERT INTO cko_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Na Petoro ni Yohane afa bu nyu­mbaa akpama i ŋu, na Petoro ase i ka, “Niɛ ya dɔ fɛn.” ");
INSERT INTO cko_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Nyini ti, na wɔ tu i tii suniɛ bu dɔ, i sunsun ka bu má i deke be wɔ. ");
INSERT INTO cko_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Na Petoro ase i ka, “M la má ŋwaa bo m ma u, ama, deke bo m la i na m fa ma u yaa, Yesu Kristo Nazarɛti­fɔ n dɛɛ duma nu, m ŋa, a yasu nati.” ");
INSERT INTO cko_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Dɔ na Petoro aso wɔbuka n saa fɔmbɔrɔ nu, na wɔ yɛ i su ajina, kpeŋga sɔnɔ n jaam kɛrɛ ayo faŋga, ");
INSERT INTO cko_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","nyini ti, na wɔ warakpin, na wɔ jina i jaa su, na wɔ bo i bu sunati bara yɛ. Dɔ na wɔ su bu su awura Nyɛmɛ Seree­biri Awuru n nu, na i sunati, na i suwarakpin, na i sukansi Nyɛmɛ. ");
INSERT INTO cko_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Na jama n kɛrɛ aŋu ka i sunati, na i sukansi Nyɛmɛ. ");
INSERT INTO cko_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Saŋga bo minɛm ni siiri nu ka, yiri bo i yo tana Nyɛmɛ Seree­biri Awuru n Anɔ Nyunyumi n nu sere n lɛɛ ni, na ba miɛ atana, na sa n bo i yoori sɔnɔ n ayo bu alekutura. ");
INSERT INTO cko_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Saŋga bo wɔbuka n bita Petoro ni Yohane barasu ni, na minɛ kɛrɛ ayo alekutura, na ba ŋmati aba bu dɔ awɔrɛ be bo bu fere i ka Solomon dɛɛ Lɛlɛ n nu. ");
INSERT INTO cko_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Saŋga bo Petoro ŋuuri minɛm sɔ ni, na wɔ se bu ka, “Yisareli­fɔm, nzu ti ye am fa ahin sa n yo alekutura ye am niɛ ya sɔ a? Am sunsun ka ya dɛɛ yiko nu ye ahin sɔnɔ n anati a, wara am sunsun ka ya yo sa bo i kɔ atin su Nyɛmɛ dɔ n dɛɛ ti, nzɛn sɛ? Ai, i ti má sɔ. ");
INSERT INTO cko_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Nyɛmɛ bo Abraham ni Izaki ni Jakɔbu ni ya nam suuri i ni, yiri ye wɔ wura i amusui­su­fɔ Yesu n kpiri bambaka a. Ama, am faari i wuraari yiko­fɔm saa nu wɔ, na am akete i Gomina Pilato nyunu, ka am koro má i, haari ni bo má gomina n ŋa i yaki i nu ji ni. ");
INSERT INTO cko_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","I ti Nyɛmɛ sɔnɔ fofoe wɔ, bo i yo sa bo i kɔ atin su Nyɛmɛ dɔ ɔ, ama, na am akete i, na am asere gomina n jande ka i yaki sɔnɔ kun­fɔ nu ji. ");
INSERT INTO cko_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Na am akun yiri Yesu n bo i ma ya ŋgɔɔ ni, ama, Nyɛmɛ ateŋge i yiwee n nu, ya ŋuuri i wɔ ye ya sudi i daani a. ");
INSERT INTO cko_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ahin sɔnɔ bo am ŋu i na am si i ni, Yesu dɛɛ duma n yiko nu ma i jaam kɛrɛ ayo faŋga n a. Deke n bo am aŋu i ni, i fite ka sɔnɔ n ayo Yesu duma n yarada n dɛɛ ti, nyini ma wɔ nya laifiɛ ye am kɛrɛ aŋu i n a.” ");
INSERT INTO cko_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Na Petoro anya ase bu ka, “M ninbaam, m si ka ambɛrɛ ni am tere­tere­fɔm kɛrɛ be mmɔɔ asi má sam bo am yo yoori bu ni. ");
INSERT INTO cko_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Dawa saŋga, Nyɛmɛ ma i nɔaniɛ kan­fɔm kɛrɛ yo jɔjɔɔri ahin jɔrɛ kɛrɛ, ka, Kristo, Tii­de­fɔ n bo Nyɛmɛ ase ka i súnma i ni bá, na i bá di wahara, nyini lɛɛ ye wɔ yo yii­wa bɛrɛ n a. ");
INSERT INTO cko_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Nyini dɛɛ ti, am kaaki am wo, na am su Nyɛmɛ, na i fá am satiɛ ce am, ");
INSERT INTO cko_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","na i má am nyá ŋumi­yi, na i nyá sunma Kristo, Tii­de­fɔ n bo wɔ yi i ka i bá am dɔ ni, yiri la Yesu. ");
INSERT INTO cko_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Wɔ yo daka ka i wó Nyɛmɛ dɔ aŋgoro, haari fa kɔ ju saŋga n bo Nyɛmɛ má deke kɛrɛ yo yii­wa, kabo dawa saŋga na i maari i nɔaniɛ kan­fɔ casim n nɔɔ na bu seeri ni. ");
INSERT INTO cko_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moyisi yo seeri ka, ‘Am Micɛra Nyɛmɛ súnma i nɔaniɛ kan­fɔ kabo i sunmaari mini Moyisi n wɔ. Nyini sɔnɔ ni yó am dɛɛ tiɛŋgu sɔnɔ bo i fite am nu wɔ. I ti ye ni ka am de i nɔaniɛ, na am yo deke kɛrɛ bo i se ka am yo i. ");
INSERT INTO cko_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Sɔnɔ kɛrɛ bo i de má Nyɛmɛ nɔaniɛ kan­fɔ n nɔaniɛ ni, Nyɛmɛ yí i mi fite i dɛɛ minɛm nu wɔ, na i ká ŋgbɛɛn.’ ");
INSERT INTO cko_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Nyɛmɛ nɔaniɛ kan­fɔm kɛrɛ bo bu jɔjɔɔri fite Samuwɛli saŋga haari ba ju ni nyuma, bu kɛrɛ jɔjɔɔri fa kɔ ahin sam bo bu suyo nyuma n su wɔ. ");
INSERT INTO cko_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ambɛrɛ ti Nyɛmɛ nɔaniɛ kan­fɔ dɛɛ busu nu­fɔm a, am dɛɛ la sɛsɛ­su n bo Nyɛmɛ yo diiri i di ni am nam ni. Na wɔ se ya na Abraham ka, ‘U busu nu­fɔm dɛɛ ti ye m yó durunya n nu­fɔm kɛrɛ kisi a.’ ");
INSERT INTO cko_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Nyini dɛɛ ti, ye i du mɔ yiiri i amusui­su­fɔ n ye i sunmaari i am dɔ n a, ka i bá yo am kisi, nyini la ka, i má am kaaki am wo, na i yí am fite am satiɛ kɛrɛ nu.” ");
INSERT INTO cko_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Petoro ni Yohane toko jɔjɔ jama n dɔ ni, na minɛm nbem aba bu dɔ, bɛrɛ la Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm nbem, ni Nyɛmɛ Seree­biri Awuru n nu tintini­jina­fɔm kpiɛn, ni Sadusi­fɔm nbem. ");
INSERT INTO cko_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Bu baari ni yaa su wɔ, kabo Yesu jaramasa nnyɔm ni sukere minɛm ka Yesu wuuri ni, i teŋgeeri i yiwee nu wɔ, nyini kere ka minɛm wu, bu teŋge bu yiwee nu wɔ lɛɛ. ");
INSERT INTO cko_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Nyini ti, na ba tara Petoro ni Yohane. Bu taraari bu naasɔ saŋga a, na ba nyi bu haari ale akɔ acin. ");
INSERT INTO cko_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ama, na minɛ dɔŋgu bo bu tiiri Yesu jaramasa ni keree­wa n ayo yarada. Nyini ti, bɛrɛ kɛrɛ bo bu yoori yarada ni, bu nbiɛsɔm kɔ yasuuri minɛ akpii nnu wɔ. ");
INSERT INTO cko_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Alecin ŋgarama na Yuda­fɔm tere­tere­fɔm, ni bu nkpiɛn­kpiɛnm, ni Nyɛmɛ nɔaniɛ kere­fɔm kɛrɛ atiɛn bu nɔɔ Yɛrusalem miɛ kpiri n nu. ");
INSERT INTO cko_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Bo bu gusu woori dɔ n la Anasi bo i ti Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm kɛrɛ kpiɛn ni, ni minɛ nbem bo bu fere bu ka Kayafasi, ni Yohane, ni Alɛkizanda, ni minɛm bo bu wo Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm busu nu n kɛrɛ tiɛɛnri bu nɔɔ ɔ. ");
INSERT INTO cko_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Na ba fa Petoro ni Yohane aba ajina bu afiɛn, na ba bisa bu ka, “Am yoori sɛ yoori ahin sa n a? Am la yiko bɔnɔ, wara ŋma dɛɛ duma nu ye am fa tuntuunri sɔnɔ n ye wɔ nya laifiɛ n a?” ");
INSERT INTO cko_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Na Awiɛwiɛ Casi n awura Petoro ŋu, na wɔ se bu ka, “Ya tere­tere­fɔm ni ya nkpiɛn­kpiɛnm, ");
INSERT INTO cko_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","sakpa n bo ya yo i ama wɔbuka ni, ni kabo i yoori barasu na wɔ nya laifiɛ n dɛɛ ti, ye am sudi ya jɔrɛ bisa ya sɔ a, nzɛn sɛ? ");
INSERT INTO cko_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","I ti ye ni ka ambɛrɛ ni Yisareli­fɔm kɛrɛ si ka o, ahin sɔnɔ n bo i jina bɛrɛ na wɔ nya laifiɛ ni, i fite Yesu Kristo Nazarɛti­fɔ n duma n nu wɔ. Yiri ye am kuunri i, ye Nyɛmɛ teŋgeeri i fiteeri i yiwee n nu n a. ");
INSERT INTO cko_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ba kɛrɛ i ŋusu jɔrɛ Nyɛmɛ Jɔrɛ Kadasi n nu ka, ‘Yabuɛ n bo ambɛrɛ bondo ta­fɔm faari i tuuri ni, yiri ye wɔ kaaki bondo n jaa yabuɛm kɛrɛ tii a.’ ");
INSERT INTO cko_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Yiri ŋgumi ye Nyɛmɛ ayi i ka i ba de sɔnɔ kɛrɛ tii a, duma be wo má durunya n kɛrɛ nu bo i koro de ya tii ji, má ka Yesu Kristo dɛɛ duma ni ŋgumi.” ");
INSERT INTO cko_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Na Yuda­fɔ yiko­fɔm ni tere­tere­fɔm n aŋu kabo Petoro ni Yohane la ahoresi barasu ni, na ba si ka ba kɔ má kara be mmɔɔ, na wɔ yo bu alekutura. Dɔ na ba si nu ka bu yo suuri Yesu su wɔ. ");
INSERT INTO cko_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Bu ŋuuri ka sɔnɔ n bo wɔ nya laifiɛ n jina Petoro ni Yohane bi ni, nyini dɛɛ ti, ba koro ase má jɔrɛ be. ");
INSERT INTO cko_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Na ba se Petoro ni Yohane ka bu fite sɔɔ n nu. Bu fite wieeri ni, na bɛrɛ nkpiɛn­kpiɛnm n abo Petoro ni Yohane n ŋusu anzama. ");
INSERT INTO cko_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Na ba bisa bu ŋuŋu nu ka, “Ye ya yó ahin minɛm sɛ wɔ? Dama sɔnɔ kɛrɛ bo i wo Yɛrusalem miɛ kpiri n nu si ka ba yo ahin alekutura sa bambaka ni, ya koro se má ka ba yo má i e. ");
INSERT INTO cko_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ama, nzɛn ya koro má ka ahin jɔrɛ n bara yɛ deke n kɛrɛ, am ma ya ŋɔŋɔnɔ bu ka, má bu se ka bu bo Yesu duma mmɔɔ na be ti.” ");
INSERT INTO cko_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Nyini ti, na ba kaaki afere Petoro ni Yohane awura, na ba ma bu nɔɔ ka, má bu se ka bu bo Yesu duma, wara bu kan i ŋusu jɔrɛ kere minɛm. ");
INSERT INTO cko_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ama, na Petoro ni Yohane ase bu ka, “Ambɛrɛ mmɔɔ ni am tii, am niɛ nu na am niɛ e, Nyɛmɛ atin su, bɔnɔ ti ye a, ya de am dɛɛ nɔaniɛ n wɔ, nzɛn ya de Nyɛmɛ dɛɛ n wɔ? ");
INSERT INTO cko_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ya sukan kere minɛm n wɔ fa kɔ sam n bo yɛrɛ ni ya tii ati bu, na ya ŋu bu ni, ya koro mɔ má ya nɔɔ.” ");
INSERT INTO cko_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Na bɛrɛ yiko­fɔm, ni tere­tere­fɔm n aŋɔŋɔnɔ bu nahɔrɛ su, na ba yaki bu nu aji. Bu niɛɛri nu, bu ŋu ka bu koro yo má bu pui, dama minɛm kɛrɛ wo Nyɛmɛ kansi su wɔ fa kɔ sa n bo wɔ yo ni. ");
INSERT INTO cko_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Sɔnɔ n bo bu yoori nyini alekutura sa n maari i na i nyaari laifiɛ ni, i tara afɔ abura­na. ");
INSERT INTO cko_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Saŋga bo Petoro ni Yohane nyaari bu tii ni, bu kaba kpieeri bu nyi kɔɔri bu beŋgu Yesu susu­fɔm n dɔ ɔ, na ba kan jɔrɛ n kɛrɛ bo Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ nkpiɛnm, ni nkpiɛn­kpiɛnm n seeri ni. ");
INSERT INTO cko_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Yarada­yo­fɔm ni tiiri nyini jɔrɛ n kɛrɛ sɔ ni, na bu kɛrɛ ayo anɔɔkun, na ba sere Nyɛmɛ, bu ŋa, “Ya Micɛra Yiko­fɔ, wɔrɔ yiiri aŋgoro ni asiɛŋgu a, ni tieku n ni dekem kɛrɛ bo bu wo nu ni. ");
INSERT INTO cko_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Wɔrɔ yo ma u Awiɛwiɛ Casi n wuraari ya na Davidi bo i ti u dɛɛ amusui­su­fɔ n ŋu a, na wɔ se ka, ‘Nzu ti ye minɛm bo bu ti má Yuda­fɔm afa yaa agaya sɔ a. ye minɛm bita sunsunni bo i la má kpɛrɛ a? ");
INSERT INTO cko_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ye durunya n nu nfɛmɛm ayasu ajina, na bu yiko­fɔm atiɛn bu nɔɔ, ka bu tu luɛ ni Micɛra Nyɛmɛ ni, ni Kristo, Tii­de­fɔ n bo Nyɛmɛ ase ka i súnma i n a.’ ");
INSERT INTO cko_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Tɔ, kabo Fɛmɛ Davidi yo kaanri ni, i ti nahɔrɛ wɔ, ka Fɛmɛ Herode, ni Gomina Pɔntiyo Pilato fa saŋga ni minɛm bo bu ti má Yuda­fɔm, ni Yuda­fɔm yo tiɛɛnri bu nɔɔ ahin miɛ n nu wɔ, na ba kete Yesu, u amusui­su­fɔ casi n bo a yiiri i ka yiri ti Tii­de­fɔ ni. ");
INSERT INTO cko_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Bu tiɛɛnri bu nɔɔ ɔ, na ba yo dekem kɛrɛ bo u dɛɛ yiko n ni u koroya­nu na a du mɔ acici ka bu yo ni. ");
INSERT INTO cko_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ya Mibiɛ, ti kabo kisa bu ŋɔŋɔnɔ ya barasu, nyini ti, ma yɛrɛ u akɔɔm n ahoresi, na ya kan u dɛɛ labari kpa n na má ya soro sɛrɛ. ");
INSERT INTO cko_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Fa u yiko n tuntun tukpaki­fɔm na bu nya laifiɛ, na a ma ya yiko na ya tuntun minɛ, na ya yo alekutura sam barasu barasu, u amusui­su­fɔ casi Yesu n dɛɛ duma nu.” ");
INSERT INTO cko_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Saŋga bo bu sereeri Nyɛmɛ n wieeri sɔ ni, na dika n bo bu wo nu n akpisi. Na Awiɛwiɛ Casi n awura bu kɛrɛ ŋu, na ba kan Nyɛmɛ jɔrɛ ni ahoresi. ");
INSERT INTO cko_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Yarada­yo­fɔm n yo yoori anɔɔsɛ wɔ, na ba saŋga ayo deke n kɛrɛ kun. Be wo má bɛrɛ bo i se ka i neŋge be tiiri i tiɛŋgu dɛɛ. Ama, bu kɛrɛ kpaaki deke n kɛrɛ bo bu la i nu ma bu beŋgu wɔ. ");
INSERT INTO cko_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Na Yesu jaramasam n akan Nyɛmɛ jɔrɛ ni yiko bambaka, na ba kan akere minɛm kabo Yesu teŋgeeri i yiwee n nu ni. Na Nyɛmɛ ama bu kɛrɛ adi ahɔrɔma beberebe. ");
INSERT INTO cko_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Be awo má bu nu bo i miɛɛri deke be busu. Bo bu laari asiɛnm, ni awurum tɔɔri bu wɔ, na ba fa ŋwaa kɛrɛ bo bu nyaari i ni, ");
INSERT INTO cko_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","aba ama Yesu jaramasam ni, na bɛrɛ gusu akpaaki i nu ama bo bu la má pui ni, na ba fa ayo deke bo i miɛ bu. ");
INSERT INTO cko_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Sɔnɔ be yo woori bu nu, bu fere i ka Yosefu, i ti Levi busu nu­fɔ ɔ, bu wuuri i asiɛn be bo bu fere i ka Sipurusi n su wɔ. Na Yesu jaramasam n atun i duma ka Banabasi, i bu la ka, sɔnɔ bo i ma minɛ ahoresi ni. ");
INSERT INTO cko_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Nyini sɔnɔ n tɔɔri i asiɛn n bo i la i, na wɔ fa ŋwaa n aba ama Yesu jaramasam ni. ");
INSERT INTO cko_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Sɔnɔ be yo woori dɔ bu fere i ka Ananiyasi, na bu fere i yi ka Safira, na ba tɔ bu aja be. ");
INSERT INTO cko_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ama, na yiri ni i yi n ayo bu nɔɔkun, na wɔ yi ŋwaa n be afiɛ, na wɔ fa bo i kaari n ama Yesu jaramasam ni. ");
INSERT INTO cko_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Na Petoro abisa i ka, “Ananiyasi, nzu ti ye a ma Sitana awura u sunsunni nu, ye a fa ŋwaa n bo a tɔɔri u asiɛn n na a nyaari i n be afiɛ a, ye a ŋa a dadaka Nyɛmɛ Awiɛwiɛ Casi n a? ");
INSERT INTO cko_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Saŋga n bo a nya tɔ má i ni, i ti u dɛɛ wɔ, kisa gusu bo a tɔ i ni, ŋwaa n ti u dɛɛ wɔ. Ye nzu ti ye a yo ahin sa n a? Má adamande ŋgumi ye a ŋa a dadaka a, ama, a ŋa a dadaka Nyɛmɛ wɔ.” ");
INSERT INTO cko_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananiyasi tiiri nyini nɔaniɛ n sɔ ni, i kaba kpaasiiri wɔ, na wɔ wu, na sɔnɔ kɛrɛ bo i tiiri nyini sa n bo wɔ yo ni, na sɛrɛ ati bu agaya. ");
INSERT INTO cko_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Na ngbɛfɛnɛm ayasu afa tani apɔɔndi i, na ba fa i afite akɔ ase i. ");
INSERT INTO cko_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Wɔ cɛ má, na i yi gusu aba, wɔ si má sa bo wɔ yo ni. ");
INSERT INTO cko_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Na Petoro abisa i ka, “U ni u hun aja n bo am tɔɔri i n ŋwaa n kɛrɛ lɛɛ?” Na wɔ bɔ Petoro n nu ka, “Ɛɛn, i kɛrɛ lɛɛ.” ");
INSERT INTO cko_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Dɔ na Petoro abisa i ka, “Nzu ti ye u ni u hun ayo am nɔɔkun na am yo Micɛra n Awiɛwiɛ n na am niɛ a? Niɛ fɛn, minɛm bo bu faari u hun kɔ seeri i ni, bu jaa busu wo anɔ n nu, bu fá wɔrɔ mmɔɔ fite lɛɛ.” ");
INSERT INTO cko_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Jina n nu bɛrɛ, na wɔ kaba akpaasi Petoro jaa bu, na wɔ wu. Bo bu seeri i hun n ba ŋuuri ka yiri gusu awu, na ba fa i akɔ ase i adodo i hun ni. ");
INSERT INTO cko_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Na Kristo jama n kɛrɛ, ni minɛm kɛrɛ bo bu tiiri nyini sa n bo wɔ yo ni, na sɛrɛ ati bu kɛrɛ agaya. ");
INSERT INTO cko_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Na Yesu jaramasam n ayo alekutura sam barasu barasu dɔŋgu minɛm n nu bo i kere ka Nyɛmɛ wo bu dɔ. Na yarada­yo­fɔm n kɛrɛ atiɛn bu nɔɔ Solomon Lɛlɛ n bo i wo Nyɛmɛ Seree­biri Awuru n nu ni. ");
INSERT INTO cko_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Minɛm bo ba yo má Yesu yarada ni soroori sɛrɛ wɔ, ba koro asaŋga má bu nu, ama, na minɛm n awura bu kpiri. ");
INSERT INTO cko_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Na minɛ beberebe ayo Mibiɛ n yarada, subuka bu su saŋga kɛrɛ, bu sunnu, nbiɛsɔm ni nbaram. ");
INSERT INTO cko_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Na alekutura sam bo Yesu jaramasam yoori bu n dɛɛ ti, na minɛ asɔ bu tukpaki­fɔm, ni bu dasum aba ase atiŋgberem nɔɔ su, adena Petoro ba sunati sin, na haari i awiɛwiɛ mmɔɔ tɔ gɔ bu nbem ŋu, na bu nyá laifiɛ. ");
INSERT INTO cko_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Na minɛ beberebe afite miɛ miɛm bo bu bara yɛ Yɛrusalem miɛ kpiri n su ni, na ba fa tukpaki­fɔm ni minɛm bo ajinim yaki má bu n aba, na bu kɛrɛ anya laifiɛ. ");
INSERT INTO cko_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Na Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm n kɛrɛ kpiɛn ni, ni i beŋgum bo bu su Sadusi­fɔm atin su ni, aba asi Yesu jaramasam ni kɔrɛ agaya. ");
INSERT INTO cko_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Na ba tara Yesu jaramasam ni, akɔ anyi bu dan­saraka. ");
INSERT INTO cko_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ama, nyini cɛɛn n kɔŋguɛ, na Nyɛmɛ mɛrɛkɛ aba ateke dan­saraka anɔ ni, na wɔ yi Yesu jaramasam n afite, na wɔ se bu ka, ");
INSERT INTO cko_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Am kɔ na am kɔ jina Nyɛmɛ Seree­biri Awuru n nu, na am kan ahin ŋgɔɔ fɔfɔrɛ n bo am anya i n jɔrɛ kɛrɛ kere minɛm.” ");
INSERT INTO cko_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Na jaramasam n ade i nɔaniɛ ni, na alecin ŋgarama fuun, na ba kɔ ajina Nyɛmɛ Seree­biri Awuru n nu, na ba bo i bu sukere minɛ. Saŋga bo Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm n kɛrɛ kpiɛn n ni i dɛɛ jama nbaam n ba juuri ni, na ba fere Yuda­fɔ tere­tere­fɔm ni, ni Yisareli nkpiɛn­kpiɛnm kɛrɛ, na ba tiɛn bu nɔɔ na bu fa sɛsɛ­su, dɔ na ba ma nɔɔ ka bu kɔ yi Yesu jaramasam ni dan­saraka n nu bra. ");
INSERT INTO cko_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ama, minɛm n bo bu sunmaari bu n kɔ juuri ni, ba ŋu má jaramasam ni dan­saraka sɔɔ n nu, na ba kpie bu nyi aba ase bu. ");
INSERT INTO cko_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Bu ŋa, “Saŋga bo ya kɔ juuri ni, dan­saraka anɔ n kɛrɛ nyi wɔ kenken, tintini­jina­fɔm gusu jina anɔ n nu bɛrɛ, ama, saŋga bo ya ba tekeeri anɔ n ni, ya ŋu má sɔnɔ kun n kpein mmɔɔ sɔɔ n nu.” ");
INSERT INTO cko_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Saŋga bo Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ n kɛrɛ nkpiɛnm, ni Nyɛmɛ Seree­biri Awuru n nu tintini­jina­fɔm kpiɛn n tiiri sɔ ni, na ba birisi, ba si má sa bo wɔ yo. ");
INSERT INTO cko_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Dɔ na sɔnɔ be aba ase bu ka, “Am ti fɛn. Minɛm bo am taraari bu kɔ nyiiri bu ni, bu wo Nyɛmɛ Seree­biri Awuru n nu wo minɛm kere su.” ");
INSERT INTO cko_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Nyini ti, na Nyɛmɛ Seree­biri Awuru n nu tintini­jina­fɔm kpiɛn n afa i minɛm akɔ, na ba kɔ atara Yesu jaramasam n aba. Bu kɔ faari bu ni, ba miɛ má bu, dama bu soroori ka minɛm ni tu bu yabuɛ wɔ. ");
INSERT INTO cko_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Na ba fa jaramasam n aba, na ba fa bu ajina minɛm bo ba tiɛn bu nɔɔ n nyunu. Na Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm n kɛrɛ kpiɛn n abisa bu bisaa­wam. ");
INSERT INTO cko_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","I ŋa, “Ya maari am nɔɔ nahɔrɛ su ka, má am se ka am kere keree­wa be ahin sɔnɔ n duma nu. Ama, am niɛ kabo am ayo a. Am afa am keree­wa n abara ayɛ Yɛrusalem miɛ kpiri n kɛrɛ nu, ye am koro ka am se ka yɛrɛ kuunri i a.” ");
INSERT INTO cko_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Na Petoro ni jaramasa nyiŋgam n abɔ bu nu ka, “Wɔ yo daka ka ya de Nyɛmɛ nɔaniɛ wɔ, má adamande dɛɛ. ");
INSERT INTO cko_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Nyɛmɛ bo i ti ya nam dɛɛ Nyɛmɛ ni, yiri teŋgeeri Yesu fiteeri i yiwee n nu, yiri bo am kuunri i na am kpamaari i baka jaanu n su ni. ");
INSERT INTO cko_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Yiri Yesu, ye Nyɛmɛ afa i atana i saa fɔmbɔrɔ su, ka i yo ya Mɔ­fɔ ni ya Tii­de­fɔ, na i ma yɛrɛ Yisareli­fɔm atin, na ya kaaki ya wo, na Nyɛmɛ fa ya satiɛ kɛrɛ ce ya. ");
INSERT INTO cko_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Yɛrɛ ni Awiɛwiɛ Casi ni di ahin sam n daani kan kere minɛ a. Yiri Awiɛwiɛ Casi n ye Nyɛmɛ afa ama minɛm bo bu de i nɔaniɛ n a.” ");
INSERT INTO cko_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Saŋga bo minɛm bo ba tiɛn bu nɔɔ n tiiri nyini jɔrɛ n sɔ ni, na yaa ati bu agaya, má bu koroori ka bu kun Yesu jaramasam wɔ. ");
INSERT INTO cko_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ama, na bu nu kun, i ti Farasi­fɔ ɔ, bu fere i ka Gamɛli, i kaaki ti Nyɛmɛ nɔaniɛ kpamaa­wa n kere­fɔ ɔ, bo minɛm kɛrɛ ma i jirima agaya. Na wɔ yasu ajina, na wɔ ma nɔɔ ka bu fa jaramasam n fite dasin kaan ka. ");
INSERT INTO cko_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Dɔ na wɔ se jama n kɛrɛ ka, “M lamɔkɔ Yisareli­fɔm, am niɛ am tii su dɔŋgu fa kɔ sa n bo am koro ka am fa yo ahin minɛm ni. ");
INSERT INTO cko_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Am teŋge su ka afɔ be, na sɔnɔ be, bu fere i ka Tiyodasi, na wɔ ba, na wɔ yo i ŋu ka i ti sɔnɔ bo i ŋusu nya má durunya n nu wɔ, na minɛ ba yo ka yaa nna kɛrɛ asu i su. Ama, wɔ cɛ má, na minɛ akun i, na i susu­fɔm n kɛrɛ aŋmati asandi, na i dɛɛ atin n aka ŋgbɛɛn. ");
INSERT INTO cko_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Nyini sin, saŋga bo bu ŋa bu kɛrɛ asiɛn n su jama duma na bu si bu nɔ ni, na sɔnɔ be gusu aba, yiri la Yudasi bo i fite Galili asiɛn n su ni. Na jama beberebe asu i su, ama, na minɛ akun yiri gusu, na i susu­fɔm n kɛrɛ aŋmati asandi. ");
INSERT INTO cko_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Nyini ti, kabo i ti ni, m suse am wɔ, má am se ka am yo ahin minɛm ni pui. Am yaki bu bɛnlɛ. Nzɛn atin n bo bu bita i n ti adamande dɛɛ, i ká ŋgbɛɛn wɔ. ");
INSERT INTO cko_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ama, nzɛn i ti Nyɛmɛ dɛɛ, am kóro yo má ahin minɛ ni pui. Am bá ŋu ka am si má na am sukun luɛ ni Nyɛmɛ.” ");
INSERT INTO cko_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Na ba de Gamɛli fɔ­tuu­wa ni. Na ba fere Yesu jaramasam n awura, na ba fin bu ŋgbere, na ba ma bu nɔɔ ka, má bu se ka bu bo Yesu duma mmɔɔ kere minɛ kun. Na ba yaki bu, na ba kɔ. ");
INSERT INTO cko_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Yesu jaramasam ni fiteeri minɛm bo ba tiɛn bu nɔɔ n dɔ wieeri ni, na bu ahore ajɔ agaya, ka Nyɛmɛ abu bu awura be nu, dama ba di nyinsɛ Yesu dɛɛ duma n nu. ");
INSERT INTO cko_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Na cɛɛn n kɛrɛ cɛɛn, na bu suwura Nyɛmɛ Seree­biri Awuru n nu, ni minɛm dika, na bu yaki má Nyɛmɛ nɔaniɛ n kere ni, na bu sukan Nyɛmɛ labari kpa n kere bu ka Yesu ti Kristo n a, Tii­de­fɔ n bo Nyɛmɛ ase ka i súnma i ni. ");
INSERT INTO cko_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Na fa kɔ saŋga su, na Yesu susu­fɔm n asunnu abuka su, na Yuda­fɔm bo bu jɔjɔ Giriki aniɛ n ni aŋuŋuti Yuda­fɔm bo bu jɔjɔ Hiburu aniɛ ni. Bu ŋa cɛɛn kɛrɛ cɛɛn na bu ce nkuna­fɔm diire ni, bu bu má bu dɛɛm wura má nu. ");
INSERT INTO cko_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Nyini ti, na Yesu jaramasam buru ni nnyɔm n afere susu­fɔm n kɛrɛ pepere atiɛn bu nɔɔ, na ba se bu ka, “I ti má ye ni ka yɛrɛ ni ya tii yaki Nyɛmɛ jɔrɛ n kan, na ya suniɛ diire jɔrɛ su. ");
INSERT INTO cko_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Nyini ti, m ninbaam, am niɛ am ŋuŋu nu, na am yi minɛ nso bo bu la anyunuyi, na Awiɛwiɛ Casi n wo bu dɔ, na bu la alecira, na bu kaaki la sunsunni kpa, na ya má bɛrɛ niɛ nyini sereyam n kɛrɛ su. ");
INSERT INTO cko_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Na yɛrɛ ni ya tii nyá ya ŋu, na ya nyunu bóro nyɛmɛsere, ni Nyɛmɛ nɔaniɛ n kan su.” ");
INSERT INTO cko_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Yesu jaramasam n seeri sɔ ni, na wɔ yo minɛm kɛrɛ fiɛ fa kɔ bu jɔjɔɔ­wa n su. Na ba yi sɔnɔ be, bu fere i ka Satɛfano, i ti sɔnɔ bo i la yarada nahɔrɛ su wɔ, na Awiɛwiɛ Casi n wo i ŋu, ni Filipu, ni Porokoron ni, ni Nikanɔ, ni Timona, ni Pamɛnasi, ni Nikola bo i fite miɛ kpiri n bo bu fere i ka Antiyoki n su, na wɔ kaaki i ŋu ka i ti Yuda­fɔ, na i su bu dɛɛ atin n su ni. ");
INSERT INTO cko_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Na jama n afa bu aba Yesu jaramasam n dɔ, na ba fa bu saa anana bu ŋu, na ba sere Nyɛmɛ ama bu. ");
INSERT INTO cko_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Na Nyɛmɛ nɔaniɛ ni susandi subuka su. Na minɛ beberebe ayo yarada abuka Yesu susu­fɔm su Yɛrusalem miɛ kpiri n nu. Na Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm gusu dɔŋgu ayo yarada. ");
INSERT INTO cko_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Satɛfano ti sɔnɔ bo i diiri Nyɛmɛ ahɔrɔma wɔ beberebe, na Nyɛmɛ ama i yiko nahɔrɛ su, na wɔ yo alekutura sa barasu barasu minɛm n nu. ");
INSERT INTO cko_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ama, na Yuda­fɔ nbem ayasu ajina ase akuruwa ni yiri. Nyini minɛm wo asɛsɛ n bo bu fere i ka Ma De M Tii tiɛntiɛn­bunɔɔ sɔɔ n nu wɔ. Bu nbem fite miɛ kpirim n bo bu fere bu ka Sirene, ni Alɛkizanderiya n wɔ. Na bu nbem gusu fite Silisiya ni Esiya dɛɛ awɔrɛm n nu wɔ. ");
INSERT INTO cko_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ama, na Awiɛwiɛ Casi ni ama Satɛfano alecira, na wɔ koro akan ayi bu. ");
INSERT INTO cko_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Nyini dɛɛ ti, na ba ma minɛ nbem ŋwaa ka bu kpiɛ kɔrɛ sɔ Satɛfano ka, ba ti ka wɔ kpiɛ Moyisi ni Nyɛmɛ nzukɔ. ");
INSERT INTO cko_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Bu seeri sɔ n dɛɛ ti, na ba yɛ minɛm yaa su, ni nkpiɛn­kpiɛnm ni, ni Nyɛmɛ nɔaniɛ kere­fɔm, na ba tara i akɔ Yuda­fɔ tere­tere­fɔm dɔ. ");
INSERT INTO cko_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Dɔ na ba fa minɛ nbem aba, na ba kpiɛ kɔrɛ asɔ i. Bu ŋa, “Saŋga kɛrɛ ahin sɔnɔ n jɔjɔ ŋgbɛɛn­ŋgbɛɛn wɔ fa kɔ ya Nyɛmɛ Seree­biri Awuru casi n su, na i kaaki jɔjɔ ŋgbɛɛn­ŋgbɛɛn fa kɔ Nyɛmɛ nɔaniɛ kpamaa­wa su. ");
INSERT INTO cko_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ya ti ka i ŋa, Yesu Nazarɛti­fɔ ni bó fufu ya Nyɛmɛ Seree­biri Awuru n kɛrɛ gɔ, na i kaaki ya nana sa­yoo­wam kɛrɛ bo Moyisi fa kereeri ya ni.” ");
INSERT INTO cko_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Na bɛrɛ tere­tere­fɔm n kɛrɛ afa bu nyu­mbaa akpama Satɛfano ŋu, na ba ŋu ka i nyunu­awa akaaki wo ka Nyɛmɛ mɛrɛkɛ dɛɛ su. ");
INSERT INTO cko_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Na Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm kɛrɛ kpiɛn n abisa Satɛfano ka, “Ahin jɔrɛ n kɛrɛ bo ba kan i n ti nahɔrɛ wɔ?” ");
INSERT INTO cko_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Na Satɛfano abɔ i nu ka, “M sim ni m ninbaam, am so am sui na am ti fɛn. Kana ya na Abraham kɔ wo Harani miɛ kpiri n nu ni, Nyɛmɛ Kpiri n yo yiiri i ŋu kereeri Abraham Mesopotamiya dɛɛ asiɛn n su wɔ. ");
INSERT INTO cko_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Na wɔ se i ka, ‘Fite yaki u asiɛn n bo a tana su ni, ni u minɛm, na m kére u asiɛn bo m koro ka a kɔ tana su ni.’ ");
INSERT INTO cko_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Nyini ti, na Abraham ayasu Kaladiya asiɛn n su, na wɔ kɔ awo Harani miɛ kpiri n nu. I woori dɔ ye i si ba wuuri a. Nyini sin, na Nyɛmɛ ama wɔ yasu dɔ aba atana ahin asiɛn n bo ya wo su kisa ni. ");
INSERT INTO cko_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Nyini saŋga, Nyɛmɛ nya fa má asiɛn n haari kampiti sɔ mmɔɔ ma má Abraham na i se ka i ti i dɛɛ. Nyɛmɛ yo seeri i ka i fá asiɛn n ma i ni i busu nu­fɔm wɔ. Saŋga bo i seeri i sɔ ni, na Abraham nya wu má baa. ");
INSERT INTO cko_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Na Nyɛmɛ ase i ka, ‘U busu nu­fɔm bá kɔ yo wɔfɔm wɔ asiɛn be su, na bu fá bu yo nkɔkɔm, na bu kére bu wahara agaya kɔ ju afɔ yaa nna.’ ");
INSERT INTO cko_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ama, na Nyɛmɛ ase ka, ‘M bá cin minɛm n bo bu fá u minɛm yo bu nkɔkɔm n sui, na m nyá yi u minɛm fite nyini asiɛn n su, na bu káaki ba fɛn, na bu bá su m.’ ");
INSERT INTO cko_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Dɔ na Nyɛmɛ afa sɛsɛ­su na wɔ di i di ni Abraham, i ŋa, ‘Baa kɛrɛ bo a wuuri i, i ti ye ni ka a wura i kɛnkɛnnɛ. Nyini kere ka a bita sɛsɛ­su n bo ya di i di n a.’ Nyini ti, Abraham ba wuuri Izaki ni, i wuraari i kɛnkɛnnɛ wɔ le­mɔcuɛ cɛɛn. Na Izaki gusu aba wu Jakɔbu, na wɔ wura i kɛnkɛnnɛ i le­mɔcuɛ cɛɛn, na Jakɔbu gusu aba awu i nbaa buru ni nnyɔm bo bu ti ya nam ni, na wɔ wura bu kɛnkɛnnɛ le­mɔcuɛ cɛɛn. ");
INSERT INTO cko_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Na Jakɔbu nbaam n asi bu niɛma Yosefu kɔrɛ, na ba tɔ i afa ama Ijipiti asiɛn n su­fɔm. Ama, na Nyɛmɛ awo i dɔ, ");
INSERT INTO cko_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","na wɔ yi i afite kekereke kɛrɛ bo i tuuri i nu, na wɔ ma i alecira, na wɔ di Ijipiti Fɛmɛ Faaro ahɔrɔma. Na fɛmɛ n afa i dika n kɛrɛ, ni Ijipiti asiɛn n ama i ka i niɛ i dika. ");
INSERT INTO cko_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Na ahɔɛ aba atɔ Ijipiti, ni Kanana asiɛnm n su, abi aboro minɛ ŋu, bo ya nam anya má diire bo bu di. ");
INSERT INTO cko_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Na bu si Jakɔbu ati ka diire wo Ijipiti asiɛn n su, na wɔ sunma i nbaam. Ciciri su dɛɛ sunma ni, na ba kɔ ato diire n aba. ");
INSERT INTO cko_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Bu ba kpieeri bu nyi kɔɔri ajaari nnyɔ su ni, na Yosefu ayi i ŋu akere i sinbaam ni, na Fɛmɛ Faaro gusu asi Yosefu dika­fɔm. ");
INSERT INTO cko_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Na Yosefu asunma i sinbaam n ka bu kɔ fa bu si, ni i dika­fɔm kɛrɛ ka bu bra i dɔ Ijipiti asiɛn n su. Minɛm kɛrɛ kɔ yasuuri abura­so ni nnu wɔ, bo bu baari Ijipiti asiɛn n su. ");
INSERT INTO cko_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Na Jakɔbu, ni i dika­fɔm kɛrɛ akɔ Ijipiti asiɛn n su, dɔ ye i ni i nbaam n kɛrɛ kɔ wuuri a. ");
INSERT INTO cko_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Na ba fa bu aba Sɛkɛm miɛ kpiri n nu, na ba se bu faŋ­kunma n bo Abraham toori i jɛtɛ ŋwaa beberebe Hamɔ nbaam dɔ ni. ");
INSERT INTO cko_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Saŋga n ba dodoori bo deke n bo Nyɛmɛ yo seeri ka i yo ma Abraham n yo yii­wa ni, nyini saŋga ni, na ya minɛm ni atɛrɛ ade Ijipiti asiɛn n kɛrɛ su. ");
INSERT INTO cko_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Bo woori dɔ sɔ ɔ, haari na sɔnɔ be aba adi Ijipiti asiɛn n su fɛmɛ, yiri asi má Yosefu. ");
INSERT INTO cko_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Na yiri ni afa sunsunni tiɛ adadaka ya nam, na wɔ bita bu ni tiɛ bita, na wɔ se ya nam ka bu fa bu nbaam fa tu, adena bu wu. ");
INSERT INTO cko_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Nyini saŋga n ye bu wuuri Moyisi a, i yo ti baa bo i yo nyumi agaya Nyɛmɛ dɔ ɔ. Na ba bita i i si dika haari sara nsan, ");
INSERT INTO cko_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","na ba nya ayi i afite, na Fɛmɛ Faaro wa baa­bara afa i ayo i kunnu wa. ");
INSERT INTO cko_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Na ba kere i Ijipiti­fɔm ŋgɔnlɛ ni alecira barasu barasu kɛrɛ, na wɔ yasu, na i duma ata fa kɔ i sa­yoo­wa ni i jɔjɔɔ­wa kɛrɛ nu. ");
INSERT INTO cko_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Saŋga bo Moyisi ba juuri afɔ abura­na ni, na i sunsunni ama i ka i kɔ niɛ i lamɔkɔ Yisareli­fɔm busu. ");
INSERT INTO cko_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Na wɔ ŋu ka Ijipiti­fɔm be sukere Yisareli­fɔ kun be wuwuruwa. I ŋuuri i sɔ ni, wɔ sun má i nu, na wɔ kɔ abo akun Ijipiti­fɔ ni. ");
INSERT INTO cko_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moyisi sunsuunri ka, i dɛɛ minɛm ni tí i bu wɔ, ka, Nyɛmɛ ye wɔ yi i ka i ba de bu tii ji a, ama, ba ti má i bu sɔ. ");
INSERT INTO cko_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","I alecin, na wɔ ŋu ka Yisareli­fɔm minɛ nnyɔ sudi aluwa n bu ŋuŋu nu, na wɔ kɔ akpata bu, na wɔ se bu ka, ‘Njam, am ti fɛn, m ŋa am kɛrɛ ti kun wɔ e, ye nzu ti ye am sudi aluwa?’ ");
INSERT INTO cko_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ama, na yiri n bo i sukere i beŋgu n wuwuruwa n asun Moyisi akɔ i sin, na wɔ bisa i ka, ‘Ŋma fa u yoori ya niɛsu­fɔ ni ya jɔrɛ­di­fɔ a? ");
INSERT INTO cko_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","A koro ka a kun mini gusu, kabo anuma a kuunri Ijipiti­fɔm wɔ, nzɛn sɛ a?’ ");
INSERT INTO cko_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Moyisi tiiri nyini jɔrɛ n sɔ ni, na wɔ ŋmati afite Ijipiti asiɛn n su akɔ awo Madiya asiɛn n su akaaki wɔfɔ dɔ. Dɔ na wɔ ba aja bara, na wɔ wu nbaa­biɛsɔm nnyɔ. ");
INSERT INTO cko_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Na afɔ abura­na sin, na Nyɛmɛ mɛrɛkɛ be ayi i ŋu akere Moyisi boro kpantain n nu, fa dodo buka n bo bu fere i ka Sinayi n su, i ŋu ka sin fofoe be je buwe baka be su, ama, i yara má, mɛrɛkɛ n wo sin n nu. ");
INSERT INTO cko_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moyisi ŋuuri i sɔ ni, na wɔ yo alekutura, na wɔ cin adodo ka i niɛ i nyunyumi. Dɔ na Micɛra n ajɔjɔ i dɔ, ase i ka, ");
INSERT INTO cko_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Mini ti u nam Nyɛmɛ a, u na Abraham, ni Izaki, ni Jakɔbu.’ Na sɛrɛ ati Moyisi, na i ŋuniɛ subobo i, wɔ bo má su ka i niɛ i kun. ");
INSERT INTO cko_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Na Micɛra n ase Moyisi ka, ‘Deke bo a jina n ti m tiɛŋgu dɛɛ asiɛn casi wɔ, cin yi u gbagbaa ni. ");
INSERT INTO cko_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ma ŋu kabo m minɛm wo kekereke nu Ijipiti asiɛn n su barasu. Ma ŋu kabo bu fiɛfiɛ barasu, nyini dɛɛ ti ye ma jura aba ka m ba de bu tii ji. Bra na m sunma u Ijipiti asiɛn n su.’ ");
INSERT INTO cko_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Tɔ, yiri Moyisi ye Yisareli­fɔm keteeri i n a, na ba bisa i ka, ‘Ŋma fa u yoori ya niɛsu­fɔ ni ya jɔrɛ­di­fɔ a?’ Moyisi, yiri ye Nyɛmɛ sunmaari i mɛrɛkɛ i dɔ baka n bo i je sin fofoe na i yara má n su, na mɛrɛkɛ n ase i ka i kɔ de minɛm tii ji na i yo bu kpiɛn n a. ");
INSERT INTO cko_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Na wɔ du Yisareli­fɔm mɔ, na wɔ yi bu afite Ijipiti asiɛn n su, na wɔ yo alekutura sam beberebe dɔ, ni kunma kpiri n bo bu fere i ka Kunma Kɔkɔrɛ n su, ni saŋga bo bu wo boro kpantain n nu afɔ abura­na ni. ");
INSERT INTO cko_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Yiri Moyisi yo seeri Yisareli­fɔm ka, ‘Nyɛmɛ bá yi am busu nu­fɔ be na i yó i nɔaniɛ kan­fɔ, kabo m ti ni.’ ");
INSERT INTO cko_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Yiri Moyisi, i ni ya na Yisareli­fɔm yo woori boro kpantain n nu n a, yiri ye Nyɛmɛ mɛrɛkɛ n jɔjɔɔri i dɔ Sinayi Buka n su n a, yiri ye Nyɛmɛ yo faari i nɔaniɛ n bo i ma ŋgɔɔ n maari i ka i fa ma ya nam n a. ");
INSERT INTO cko_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Ama, ya nam akoro má ka bu de i, na ba kete i na ba koro ka má bu kpie bu nyi kɔ Ijipiti asiɛn n su. ");
INSERT INTO cko_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Na ba se Moyisi gɔrɔ Aarɔn ka, ‘Ta amɔɛm ma ya na bu du ya mɔ fa ya nati. Ya si má sa bo wɔ yo yiri Moyisi n bo i faari ya fiteeri Ijipiti asiɛn n su ni.’ ");
INSERT INTO cko_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Na ba yiyi bu sikam, na ba fa ata amɔɛ ka nambaa dɛɛ su, na ba yo tiɛ ama i, na ba su i, na ba di cɛɛn­kpiri fa kɔ nyini deke n bo bɛrɛ ni bu tii ayo i n su. ");
INSERT INTO cko_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Nyini ti, na Nyɛmɛ akaaki i sin abo bu, na wɔ ma bu susu asara­mbaam bo bu wo aŋgoro ni, kabo ba kɛrɛ i Nyɛmɛ nɔaniɛ kan­fɔm dɛɛ kadasi n nu lɛɛ. Bu ŋa, ‘Ambɛrɛ Yisareli­fɔm, am yo yoori yoo­wam boro kpantain n nu afɔ abura­na ni, am yo maari mini wɔ? ");
INSERT INTO cko_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ai, am yo sɔɔri amɔɛ n bo bu fere i ka Mɔlɛki na am afa tani abo i nambue n sɔ i nati wɔ, ni amɔɛ n bo bu fere i ka Rɛfani na i ti ka asara­mbaa be ni. Bɛrɛ ye am ta bu ka amɔɛm ye am su bu a. Nyini ti, ye m má bu taraari am kɔ miɛ be bo i sin Babilɔn miɛ kpiri n ŋu n a.’ ");
INSERT INTO cko_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Ya nam ni, bɛrɛ yo laari nambue n bo i kere ka Nyɛmɛ wo bu dɔ n boro kpantain n nu a. Bu yoori i kabo Nyɛmɛ kereeri Moyisi ka i yo i n wɔ. ");
INSERT INTO cko_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ya nam yo faari nyini nambue n maari bu sin­fɔm wɔ, na bu ni bu mɔ­fɔ Yosuwa afa i akɔ asiɛn n bo Nyɛmɛ fɔn yiiri minɛm su na i fa maari bu ni. Na nyini nambue n awo bu dɔ haari Fɛmɛ Davidi saŋga. ");
INSERT INTO cko_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Na Fɛmɛ Davidi adi ahɔrɔma Nyɛmɛ dɔ, na wɔ sere Nyɛmɛ ka i ma i ta awuru bo Jakɔbu ni i dika­fɔm fa su Nyɛmɛ. Fɛmɛ Davidi akoro ata má i, ");
INSERT INTO cko_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","ama, i wa Fɛmɛ Solomon yo taari awuru n maari Nyɛmɛ a. ");
INSERT INTO cko_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Haari ni nyini mmɔɔ, Micɛra Nyɛmɛ Kpiri n yiri tana má awuru bo adamande ata i nu, kabo Nyɛmɛ nɔaniɛ kan­fɔ n ajɔjɔ i ni. I ŋa, ");
INSERT INTO cko_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Micɛra n ŋa o, Aŋgoro ni ti m fɛmɛya tanaa­biri a, na asiɛŋgu nya ti deke bo m jaa gbagbaa tiɛn. Ye am ta nzu awuru barasu ma m a? Am nya nyini fofoe n ni ye m wo nu a? ");
INSERT INTO cko_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Má mini yoori ahin dekem ni kɛrɛ a?’” ");
INSERT INTO cko_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Na Satɛfano akaaki ase bu ka, “Ambɛrɛ, am ahore­mbaa ti kekereke, na am sui ti tan­tanantan ka minɛm bo bu su má Nyɛmɛ ni. Am nati kete Nyɛmɛ Awiɛwiɛ Casi n wɔ, kabo am nam yo yoori lɛɛ. ");
INSERT INTO cko_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Nyɛmɛ nɔaniɛ kan­fɔ bɔnɔ ye am nam akere má i wuwuruwa? Na ba kun minɛm ni, bo bu seeri ka Sɔnɔ n bo i yo sa bo i kɔ atin su ni bá ni. ");
INSERT INTO cko_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ambɛrɛ ye Nyɛmɛ yo sunmaari i mɛrɛkɛm ye bu faari i nɔaniɛ kpamaa­wa maari am n a, ama, am ade má i.” ");
INSERT INTO cko_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Kabo Satɛfano jɔjɔɔri sɔ ni, na yaa ati Yuda­fɔ tere­tere­fɔm n agaya, na ba kan bu nɔɔ awura nu, na bu sukpɛsɛ bu jee. ");
INSERT INTO cko_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ama, na Awiɛwiɛ Casi n awura Satɛfano ŋu, na wɔ tu i tii aniɛ aŋgoro, na wɔ ŋu kabo Nyɛmɛ woo­wa ata papasi barasu. Na wɔ ŋu ka Yesu jina Nyɛmɛ saa fɔmbɔrɔ su. ");
INSERT INTO cko_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Na wɔ se bu ka, “Am niɛ, ma ŋu ka aŋgoro n ateke ye Adamande Wa n jina Nyɛmɛ saa fɔmbɔrɔ su.” ");
INSERT INTO cko_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","I seeri sɔ ni, na Yuda­fɔ tere­tere­fɔm n atiɛn kpa, na ba fa bu saa atɔ bu suim. Dɔ na ba kaba abereki atɔ Satɛfano ŋu. ");
INSERT INTO cko_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Na ba cin i afite miɛ n ahɛmɛ, na bu sutu i yabuɛ, na bɛrɛ bo bu di daani jaraki i, na bu sutu i yabuɛ, na ba yi bu suturam ama gbɛfɛnɛ anyunuti­fɔ be ka i suniɛ bu dika, bu fere nyini gbɛfɛnɛ n ka Sɔɔlu. ");
INSERT INTO cko_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Bu wo Satɛfano yabuɛ n tu su sɔ ni, na i gusu subo fere Mibiɛ ni, i ŋa, “M Mibiɛ Yesu, de m ŋgɔɔ ni.” ");
INSERT INTO cko_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Na wɔ kutu asiɛŋgu, na wɔ bo awie kpa, i ŋa, “M Mibiɛ, má a fa bu ŋgasi fa kɔ sa n bo bu suyo i n su.” I seeri sɔ wieeri ni, kpeŋga na i ni durunya n akpaaki. ");
INSERT INTO cko_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sɔɔlu yo soroori su ka bu kun Satɛfano a. Nyini cɛɛn n gbingbin ye bu boori i bu kereeri Kristo jamam wuwuruwa agaya, bɛrɛ bo bu wo Yɛrusalem miɛ kpiri n nu ni. Na bu kɛrɛ aŋmati asandi akɔ Yudiya, ni Samariya dɛɛ awɔrɛ n kɛrɛ nu, i kɔ kaari Yesu jaramasam ni ŋgumi wɔ, Yɛrusalem miɛ kpiri n nu a. ");
INSERT INTO cko_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Na Nyɛmɛ su­fɔ nbem akɔ ayo Satɛfano sutura, na ba sun sukoko agaya. ");
INSERT INTO cko_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ama, na Sɔɔlu aboro i nyi kabo i yo na i ka Kristo jama ni ŋgbɛɛn, na i suwura awuru awurum nu, na i sucin yi yarada­yo­fɔm ni, nbaram ni nbiɛsɔm kɛrɛ, na i ma bu kɔ nyi bu dan­saraka. ");
INSERT INTO cko_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Yarada­yo­fɔm n bo bu sandiiri awɔrɛ n kɛrɛ nu ni, na ba nati sukan labari kpa n kere minɛm kɛrɛ. ");
INSERT INTO cko_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Na Filipu akɔ Samariya miɛ kpiri n su, akɔ sukan kere minɛm fa kɔ Kristo, Tii­de­fɔ n bo Nyɛmɛ ase ka i súnma i ni. ");
INSERT INTO cko_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Na wɔ yo alekutura sam. Bu tiiri kabo i jɔjɔ na bu ŋuuri alekutura sam bo i yoori bu ni, na bu kɛrɛ aso bu sui nyunyumi, na ba ti kabo i se ni. ");
INSERT INTO cko_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Na wɔ fɔn ayi ajinim minɛ dɔŋgu ŋu. Bu ba sufite yaki minɛm ni, bu tiɛn ni faŋga su na bu fite. Na minɛm beberebe bo bu saam ni bu jaam awu ni, ni wɔbukam kɛrɛ anya laifiɛ. ");
INSERT INTO cko_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Nyini ti, na ahorejɔ bambaka aba Samariya miɛ kpiri n nu. ");
INSERT INTO cko_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Na sɔnɔ be ayo awo Samariya miɛ kpiri n nu, bu fere i ka Simon, i nati yo boboyaya wɔ, na minɛm bo bu wo miɛ n nu ayo alekutura, na i sukere i ŋu ka i ti sɔnɔ bambaka a. ");
INSERT INTO cko_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Na sɔnɔ kɛrɛ, tarakam ni nfaŋga­fɔm kɛrɛ asoro su ka yiri la Nyɛmɛ dɛɛ yiko n a. Na ba fere i ka Yiko Bambaka­fɔ n bo i fite Nyɛmɛ dɔ n a. ");
INSERT INTO cko_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Deke bo i ti na bu koro i jɔrɛ n la ka, i yo yoori nyini boboyaya juma n bu dɔ acɛ. ");
INSERT INTO cko_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ama, saŋga bo Filipu ba kaanri labari kpa n jɔrɛ n fa kɔ Nyɛmɛ fɛmɛya n ni Yesu Kristo dɛɛ atin n su, na bu deeri i nɔaniɛ ni, na wɔ biɛ bu Nyɛmɛ nzue, nbaram ni nbiɛsɔm kɛrɛ. ");
INSERT INTO cko_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Na Simon mmɔɔ ni i tii ayo yarada, na Filipu abiɛ i Nyɛmɛ nzue, na i susu Filipu su deke kɛrɛ bo i kɔ, na wɔ ŋu abonɔ sam barasu beberebe bo Filipu yoori bu ni, na wɔ yo i alekutura. ");
INSERT INTO cko_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Na Yesu jaramasam bo bu wo Yɛrusalem miɛ kpiri n nu n ati ka Samariya­fɔm gusu ade Nyɛmɛ nɔaniɛ n ni, nyini ti, na ba sunma Petoro ni Yohane bu dɔ. ");
INSERT INTO cko_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Saŋga bo bu kɔ juuri dɔ ni, na ba sere Nyɛmɛ ama bɛrɛ bo ba yo yarada ni, adena Awiɛwiɛ Casi n wura bu ŋu. ");
INSERT INTO cko_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Dama ba biɛ bu Nyɛmɛ nzue ya Mibiɛ Yesu dɛɛ duma n nu wɔ, ama, Awiɛwiɛ Casi n nya wura má bu ŋu. ");
INSERT INTO cko_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Na Petoro ni Yohane afa bu saa anana bu tii su, na ba sere Nyɛmɛ ama bu, na Awiɛwiɛ Casi n awura bu ŋu. ");
INSERT INTO cko_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simon ŋuuri ka Yesu jaramasam faari bu saa nanaari yarada­yo­fɔm ni tii su, na bu sereeri Nyɛmɛ maari bu, na Awiɛwiɛ Casi n wuraari bu ŋu ni, na wɔ fa ŋwaa aba ka i fa ma Petoro ni Yohane, ");
INSERT INTO cko_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","na wɔ se bu ka, “Am ma mini mmɔɔ ahin yiko n be, adena sɔnɔ kɛrɛ bo m fa m saa nana i ŋu na Awiɛwiɛ Casi n wura i mi ŋu.” ");
INSERT INTO cko_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ama, na Petoro ase i ka, “Wɔrɔ, u ni u ŋwaa kɛrɛ ka ŋgbɛɛn, dama a sunsun ka a koro fa ŋwaa to Nyɛmɛ aceeri n wɔ. ");
INSERT INTO cko_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","U saa wo má juma n nu fieo, dama u sunsunni ti má kpa Nyɛmɛ dɔ. ");
INSERT INTO cko_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Kaaki u wo fa kɔ u satiɛ n bo a bita i n su, na a sere Nyɛmɛ, adena nyini sunsunni tiɛ n bo i wo u ahore su ni, i fá ce u. ");
INSERT INTO cko_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Dama ma ŋu ka u ahore­mbaa yo wi agaya, na u satiɛ akunma u.” ");
INSERT INTO cko_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Dɔ na Simon ase Petoro ni Yohane ka, “Jande, am sere Mibiɛ n ma m, adena má ahin sam kɛrɛ bo am ajɔjɔ i n be ba tu m.” ");
INSERT INTO cko_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Petoro ni Yohane diiri daani n na bu kaanri Mibiɛ n labari kpa n jɔrɛ kereeri minɛ wieeri ni, na ba kpie bu nyi akɔ Yɛrusalem miɛ kpiri n nu. Bu wo kɔ su ni, na ba kan labari kpa n Samariya miɛ ahɛmɛ ahɛmɛ dɔŋgu su. ");
INSERT INTO cko_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Na Micɛra n mɛrɛkɛ aba ase Filipu ka, “Yasu na a fa wiɛ atɔɔri u saa biɛ su dɛɛ atin n bo i fa Yɛrusalem miɛ kpiri n nu fa kɔ Gaza miɛ kpiri n nu ni.” I ti atin bo i fa boro kpantain n nu wɔ. ");
INSERT INTO cko_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Na Filipu ayasu, na wɔ kɔ, i wo kɔ su n na wɔ kɔ atu Itiyopiya sɔnɔ bo i fite Itiyopiya asiɛn su, i la jinaa­biri bambaka, yiri niɛ Itiyopiya fɛmɛ bara n neŋge kɛrɛ su a. Wɔ kɔ asu Nyɛmɛ Yɛrusalem ");
INSERT INTO cko_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","sukpie i nyi kɔ awuru, i tana i kpɔŋgɔ toroku nu wɔ, na i sukan Nyɛmɛ nɔaniɛ kan­fɔ Esaya dɛɛ kadasi ni. ");
INSERT INTO cko_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Na Awiɛwiɛ Casi n ase Filipu ka, “Cin dodo kpɔŋgɔ toroku n na a su i su.” ");
INSERT INTO cko_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Na wɔ ŋmati akɔ ati ka i sukan Nyɛmɛ nɔaniɛ kan­fɔ Esaya dɛɛ kadasi ni. Na wɔ bisa sɔnɔ n ka, “A ti kadasi n bo a sukan i n bu?” ");
INSERT INTO cko_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Na sɔnɔ n abɔ i nu ka, “M yo sɛ ti i bu a, bo má ka sɔnɔ akan i bu akere m?” Na wɔ se Filipu ka i wura toroku n nu ba tana i bi. ");
INSERT INTO cko_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Nɔaniɛ n bo i wo i kan su n la bo ba kɛrɛ i ka, “Yiri ti ka bɔɛ bo bu sufa i kɔ kpiɛ i kɔm wɔ, i kaaki ti ka bɔmbaa bo bu sukpiɛkpiɛ i ndɔrɛ, na i sun má, sɔ ye wɔ se má jɔrɛ be a. ");
INSERT INTO cko_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Bu yo faari i wuraari jɔrɛ­di­fɔm saa nu wɔ, na ba kpiɛ kɔrɛ asɔ i, na ba wura i nyinsɛ. Be wo má bɛrɛ bo i bá koro jɔjɔ fa kɔ i busu nu­fɔm dɔ, dama bu yo yiiri i ŋgɔɔ durunya n nu fɛn.” ");
INSERT INTO cko_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Na Itiyopiya sɔnɔ n abisa Filipu ka, “Jande, m koro ka a se m, Nyɛmɛ nɔaniɛ kan­fɔ n yo jɔjɔ ahin jɔrɛ n ni ŋma a? I jɔjɔ niiri i ŋu wɔ, nzɛn be a?” ");
INSERT INTO cko_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Dɔ na Filipu abo i bu ni nyini Nyɛmɛ Jɔrɛ Kadasi n bo yiri sɔnɔ n sukan i ni, na wɔ kan Yesu labari kpa n jɔrɛ n akere i. ");
INSERT INTO cko_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Bu wo kɔ su ni, na ba kɔ aju awɔrɛ be nu, na ba ŋu nzue, na sɔnɔ n ase i ka, “Niɛ, nzue yaa e, ye nzu kanda ka a koro biɛ má m Nyɛmɛ nzue a?”  ");
INSERT INTO cko_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Na Filipu abɔ i nu ka, “Nzɛn a yoori Yesu Kristo yarada ni u ahore­mbaa kɛrɛ, m koro biɛ u.” Na sɔnɔ n ase i ka, “Ma yo yarada ka Yesu Kristo ti Nyɛmɛ Wa n a.” ");
INSERT INTO cko_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Na wɔ ma toroku n ajina, na bu kɛrɛ ajura awura nzue n nu, na Filipu abiɛ i Nyɛmɛ nzue ni. ");
INSERT INTO cko_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Na ba fite nzue n nu, bu fite wieeri ni, na Mibiɛ n Awiɛwiɛ n akaba akpara Filipu akɔ, sɔnɔ n aŋu má i kun, na wɔ kɔ awuru ni ahorejɔ. ");
INSERT INTO cko_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Na Filipu aŋu ka i wo miɛ kpiri n bo bu fere i ka Azotusi n nu, na wɔ yasu dɔ sukɔ, na wɔ kan labari kpa n akere minɛm miɛ kɛrɛ bo i siinri su ni, haari na wɔ kɔ aju Sizariya miɛ kpiri n nu. ");
INSERT INTO cko_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","2","Nyini saŋga n kɛrɛ ni, na Sɔɔlu suboro i nyi se kabo i yo na i kere Yesu susu­fɔm n wuwuruwa haari i bá kun bu. Na wɔ koro ka i kɔ Damasiko miɛ kpiri n nu, na i kɔ tara nbaram ni nbiɛsɔm bo bu su Yesu atin su ni, na i wura bu jɔrɔkɔ, na i fa bu ba Yɛrusalem miɛ kpiri n nu. Nyini dɛɛ ti, na wɔ kɔ Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm kɛrɛ kpiɛn n dɔ, akɔ ade kadasi bo i koro la atin wura Yuda­fɔm tiɛntiɛn­bunɔɔ sɔɔm n nu na i tara bu. ");
INSERT INTO cko_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Na wɔ de atin akɔ, i kɔ sudodo Damasiko, na sin akaba afite aŋgoro ata abara ayɛ i. ");
INSERT INTO cko_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Na wɔ kpaasi haari asiɛŋgu, na wɔ ti akonvi be ŋga, i ŋa, “Sɔɔlu, Sɔɔlu e, nzu ti ye a kere m wuwuruwa sɔ a?” ");
INSERT INTO cko_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Na wɔ bisa ka, “M Mibiɛ, wɔrɔ ŋma a?” Na wɔ bɔ i nu ka, “Mini Yesu, mini ye a kere m wuwuruwa n a. ");
INSERT INTO cko_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ama, yasu jina na a wura miɛ n kunnu na m má sɔnɔ be kere u deke bo wɔ yo daka ka a yo ni.” ");
INSERT INTO cko_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Na minɛm n bo bu su Sɔɔlu su n aka ajina surum, ba koro ase má jɔrɛ be, bu tiiri akonvi ni ŋga a, ama, ba ŋu má sɔnɔ be. ");
INSERT INTO cko_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Na Sɔɔlu ayasu ajina, na wɔ teke i nyu­mbaa, ama, wɔ ŋu má asi. Nyini ti, na ba so i saa nu, na ba cin i awura Damasiko miɛ n kunnu. ");
INSERT INTO cko_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","I woori dɔ, i le­san bo wɔ nya koro ŋu má asi, nyini saŋga n gusu, i di má, i nu má. ");
INSERT INTO cko_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Yesu susu­fɔ n kun be woori Damasiko miɛ kpiri n nu dɔ, bu fere i ka Ananiyasi. Na Mibiɛ ni aba i dɔ ka alɛlɛ nu. Na wɔ jɔjɔ i dɔ ka, “Ananiyasi.” Na wɔ bɔ i nu ka, “M Mibiɛ, mini yaa.” ");
INSERT INTO cko_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Na Mibiɛ n ase i ka, “Yasu, fa atin n bo bu fere i ka Atiŋgbere Teŋgee­wa n su, na a kɔ sɔnɔ n bo bu fere i ka Yudasi n dika, na a bisa ka a koro sɔnɔ be bo bu fere i ka Sɔɔlu ni, na i fite miɛ kpiri n bo bu fere i ka Tarasu n wɔ. Yiri Sɔɔlu n wo dɔ wo nyɛmɛsere su, ");
INSERT INTO cko_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","wɔ ŋu sɔnɔ be ka alɛlɛ nu, bu fere i ka Ananiyasi, wɔ wura i dɔ afa i saa anana i ŋu ka i kaaki ŋu asi bekun.” ");
INSERT INTO cko_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Na Ananiyasi abɔ i nu ka, “M Mibiɛ, minɛ dɔŋgu akan nyini sɔnɔ n jɔrɛ akere m, kabo i kere u minɛm ni wuwuruwa Yɛrusalem miɛ kpiri n nu barasu. ");
INSERT INTO cko_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ye wɔ de yiko afite Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ nkpiɛn­kpiɛnm dɔ, aba Damasiko fɛn, na i ba tara minɛm bo bu su u n kɛrɛ.” ");
INSERT INTO cko_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ama, na Mibiɛ n ase i ka, “Kɔ, dama mini ye ma yi i ka i yo m juma a, na i kɔ bo m duma kere minɛm bo bu ti má Yuda­fɔm ni, ni bu nfɛmɛm, ni Yisareli­fɔm, adena bu si m. ");
INSERT INTO cko_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Na m kére i wahara n kɛrɛ bo wɔ yo daka ka i di i, mini dɛɛ ti ni.” ");
INSERT INTO cko_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Nyini ti, na Ananiyasi akɔ Yudasi dika, na wɔ wura Sɔɔlu dɔ, na wɔ fa i saa anana i ŋu, na wɔ se i ka, “M niwa Sɔɔlu, ya Mibiɛ ni sunmaari m u dɔ a, yiri Yesu n ye i yiiri i ŋu kereeri u saŋga bo a wo atin n nu suba n a. Yiri sunmaari m ka m ba ma a ŋu asi bekun, na Awiɛwiɛ Casi n wura u ŋu a.” ");
INSERT INTO cko_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Kpeŋga na deke be afite Sɔɔlu nyu­mbaa n nu atɔ, i ti ka jombaa bui wɔ. Na wɔ kaaki aŋu asi bekun. Na wɔ yasu ajina, na Ananiyasi abiɛ i Nyɛmɛ nzue, ");
INSERT INTO cko_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","na wɔ di diire, na wɔ nya faŋga bekun. Na Sɔɔlu awo Yesu susu­fɔm n dɔ le­nnyɔ Damasiko miɛ kpiri n nu. ");
INSERT INTO cko_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Na wɔ kaba sukan Nyɛmɛ jɔrɛ Yuda­fɔm tiɛntiɛn­bunɔɔ sɔɔm nu, ka Yesu ti Nyɛmɛ Wa n a. ");
INSERT INTO cko_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Na jɔrɛ n amiɛ minɛm kɛrɛ bo bu tiiri ka i sukan Nyɛmɛ jɔrɛ ni, na ba bisa bu ŋuŋu nu ka, “Má sɔnɔ n bo i wo Yɛrusalem miɛ kpiri n nu kun minɛm bo bu su Yesu su n lɛɛ? Ye kisa wɔ ba fɛn ka i ba tara minɛm wura bu jɔrɔkɔ, fa bu kpie bu nyi kɔ ma Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ nkpiɛn­kpiɛnm ni, má sɔ?” ");
INSERT INTO cko_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ama, na Sɔɔlu anya faŋga abuka su, na wɔ kan akunma Yuda­fɔm bo bu wo Damasiko n nu, na wɔ kan ateke bu nyi na wɔ ma ba si ka Yesu ti Kristo n a, Tii­de­fɔ n bo Nyɛmɛ ase ka i súnma i ni. ");
INSERT INTO cko_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Na wɔ yo le­nnyɔ, na Yuda­fɔm n atiɛn bu nɔɔ afa sɛsɛ­su kabo bu yo na bu kun Sɔɔlu, ");
INSERT INTO cko_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","ama, na wɔ ti kabo ba sɛsɛ­su ka bu kun i ni. Na ba ŋminda i miɛ ni anɔm n nu, wiɛsu ni kɔŋguɛ, ka nzɛn i ba sufite na bu kun i. ");
INSERT INTO cko_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ama, na cɛɛn n be kɔŋguɛ, na Sɔɔlu susu­fɔm afa i awura kandiɛ nu, na ba fa i acɔɔndi miɛ n kobe tukoro nu ase. ");
INSERT INTO cko_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saŋga bo Sɔɔlu kɔ juuri Yɛrusalem miɛ kpiri n nu ni, na wɔ koro ka i fa i ŋu bo Yesu susu­fɔm n su, na i ni bɛrɛ yo kun, na sɛrɛ ati bu, dama ba yo má yarada ka i ti Yesu susu­fɔm n be wɔ. ");
INSERT INTO cko_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Dɔ na Banabasi afa i akɔ Yesu jaramasam n dɔ. Na yiri Banabasi akan akere bu kabo Sɔɔlu wo atin n nu sukɔ Damasiko miɛ kpiri n nu, na i ŋuuri Mibiɛ ni, ni kabo Mibiɛ n jɔjɔɔri i dɔ barasu ni, ni kabo Sɔɔlu kaanri Nyɛmɛ jɔrɛ Yesu duma nu Damasiko, ni ahoresi ni. ");
INSERT INTO cko_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Banabasi seeri sɔ ni, na ba soro su, na Sɔɔlu awo bu dɔ Yɛrusalem, na i sujeŋgbe sukan Nyɛmɛ jɔrɛ Yesu duma nu, ni ahoresi. ");
INSERT INTO cko_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Na i ni Yuda­fɔm bo bu jɔjɔ Giriki aniɛ ni abo anzama haari na ba se akuruwa ni bu beŋgu. Na ba koro ka bu kun i. ");
INSERT INTO cko_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Saŋga bo yarada­yo­fɔm n tiiri ahin jɔrɛ n sɔ ni, na ba fa Sɔɔlu akɔ aju Sizariya miɛ kpiri n nu, na ba ma wɔ kɔ Tarasu miɛ kpiri n nu. ");
INSERT INTO cko_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Na Kristo jama n anya faŋga abuka su, na bu susoro Mibiɛ n nahɔrɛ su, na bu suwo ni Awiɛwiɛ Casi n dɛɛ ahoresi nu, na bu sunya minɛm subuka su. ");
INSERT INTO cko_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Na Petoro ajeŋgbe ka i bara yɛ awɔrɛ n kɛrɛ, na cɛɛn n be sɔ ɔ, na wɔ kɔ ka i kɔ niɛ Nyɛmɛ minɛm n bo bu wo Luda dɛɛ miɛ kpiri n nu n busu. ");
INSERT INTO cko_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Dɔ na wɔ kɔ aŋu sɔnɔ be, bu fere i ka Aniyasi, i saam ni i jaam kɛrɛ awu, i da sɔrɔ ɔ, i afɔ mɔcuɛ lɛɛ bo i koro yasu má. ");
INSERT INTO cko_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Na Petoro ase i ka, “Aniyasi, Yesu Kristo ama u laifiɛ. Yasu na a nyanya u dasu ni.” Kpeŋga na wɔ kaba ayasu. ");
INSERT INTO cko_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Minɛm kɛrɛ bo bu wo Luda miɛ kpiri n nu, ni bo bu wo Saroni awɔrɛ n nu n kɛrɛ ŋuuri i sɔ ni, na ba kaaki bu wo na ba fa bu ŋu ama Mibiɛ ni. ");
INSERT INTO cko_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Bara be yo woori miɛ kpiri be bo bu fere i ka Jopa n nu, bu fere i ka Tabita, i ti Yesu susu­fɔ ɔ, bu fere i duma Giriki aniɛ nu ka Dɔkasi, i bu la ka aja. I yo sakpa wɔ saŋga kɛrɛ, na i si yaari­fɔm aŋunfɔ. ");
INSERT INTO cko_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ama, na wɔ ba ada tukpaki na wɔ wu, na ba biɛ i nzue, na ba fa i ada aŋgoro sɔɔ nu. ");
INSERT INTO cko_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Jopa gusu waari má ni Luda, na saŋga bo Yesu susu­fɔm bo bu wo Jopa n tiiri ka Petoro wo Luda ni, na ba sunma minɛ nnyɔ i dɔ ka i yo aniɛ na i bra ndende. ");
INSERT INTO cko_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Nyini ti, na Petoro ayasu asu bu su na bu kɛrɛ akɔ. Saŋga bo i kɔ juuri ni, na ba fa i afun akɔ aŋgoro sɔɔ n nu, na nkuna­fɔm kɛrɛ atiɛn bu nɔɔ abara ayɛ i, na bu susun, na ba fa tanlɛɛm ni tani barasu barasu bo Dɔkasi la ŋgɔɔ na i kpa maari bu n akere yiri Petoro. ");
INSERT INTO cko_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Na Petoro afɔn bu kɛrɛ afite sɔɔ n nu, na wɔ kutu i naŋgoroma su, na wɔ sere Nyɛmɛ, na wɔ kaaki i nyunu awɔ fuin ni, na wɔ se i ka, “Tabita, yasu.” Saŋga bo i tekeeri i nyu­mbaa ni, na wɔ ŋu Petoro, na wɔ yasu atana. ");
INSERT INTO cko_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Na Petoro aso i saa nu abuka i, na wɔ yasu ajina, na wɔ fere Nyɛmɛ minɛm n ni nkuna­fɔm ni kɛrɛ, na wɔ fa i akere bu ka wɔ teŋge. ");
INSERT INTO cko_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Na nyini labari ni abara ayɛ Jopa miɛ n kɛrɛ nu, na minɛ beberebe ayo Mibiɛ n yarada. ");
INSERT INTO cko_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Na Petoro awo Jopa le­nnyɔ, i yo woori jɛrɛkɛ be dika a, bu fere i ka Simon. ");
INSERT INTO cko_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Sɔnɔ be yo woori Sizariya miɛ kpiri n nu, bu fere i ka Koneliyo, i ti Roma­fɔ sojam n kpiɛn wɔ, i niɛ soja mbaa yaa su a. Bu fere nyini soja jama mbaa n ka Itali sojam. ");
INSERT INTO cko_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Koneliyo ti sɔnɔ bo i su Nyɛmɛ atin su wɔ, i ni i dika­fɔm kɛrɛ, na bu soro Nyɛmɛ. Na i suyo sakpa ma Yuda­fɔm bo bu ti yaari­fɔm ni, na i susere Nyɛmɛ saŋga kɛrɛ. ");
INSERT INTO cko_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Na cɛɛn n be wiɛsu kerefi nsan saŋga, na wɔ kaba aŋu Nyɛmɛ mɛrɛkɛ be, na mɛrɛkɛ n aba ase i ka, “Koneliyo.” ");
INSERT INTO cko_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Na wɔ niɛ i gbirim, na sɛrɛ ati i, na wɔ bisa i ka, “M Mibiɛ, nzu a?” Na mɛrɛkɛ n abɔ i nu ka, “Nyɛmɛ ade u sere, wɔ ŋu sakpa n bo a yo ama yaari­fɔm ni, i wara koro fi má nyini sam kɛrɛ. ");
INSERT INTO cko_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Tɔ, kisa, sunma minɛm na bu kɔ Jopa miɛ kpiri n nu na bu kɔ fere sɔnɔ bo bu fere i ka Simon Petoro ni. ");
INSERT INTO cko_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","I wo jɛrɛkɛ be dika a, bu fere i gusu ka Simon, i dika n wo fa dodo tieku n wɔ.” ");
INSERT INTO cko_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Mɛrɛkɛ n jɔjɔɔri i dɔ wieeri ni, na wɔ kɔ, na Koneliyo afere i ngbɛfɛnɛm nnyɔ, ni soja kun be bo i su Nyɛmɛ atin su na i wo i dika ni. ");
INSERT INTO cko_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Na wɔ kan jɔrɛ n kɛrɛ bo mɛrɛkɛ n seeri i ni akere bu, na wɔ sunma bu Jopa miɛ kpiri n nu. ");
INSERT INTO cko_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Na alecin ŋgarama, na ba de atin na bu kɔ Jopa, bu kɔ sudodo dɔ fa kɔ wiɛ kekete saŋga, na Petoro gusu ayasu afun sɔɔ su ka i sere Nyɛmɛ. ");
INSERT INTO cko_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Na ahɔɛ ati i, na wɔ koro deke be i di. Saŋga bo bu wo diire n yo su ni, na deke be aba i dɔ ka alɛlɛ nu dɛɛ su. ");
INSERT INTO cko_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Na wɔ ŋu ka aŋgoro n ateke, na wɔ ŋu deke be i ti ka tani bambaka wɔ, ba cici i bue nna n kɛrɛ, i sucɔɔndi ba asiɛŋgu. ");
INSERT INTO cko_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ajaa­nna barasu kɛrɛ, ni cin­bukunnu­su­fɔm barasu kɛrɛ, ni laŋkpɛtɛ­fɔm barasu kɛrɛ ka bu wo nu. ");
INSERT INTO cko_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Na wɔ ti akonvi be ŋga, i ŋa, “Petoro, yasu na a kun di.” ");
INSERT INTO cko_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ama, na Petoro ase i ka, “M Mibiɛ, ai. M nya di má deke bo i ti ciire na i la fin.” ");
INSERT INTO cko_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Na akonvi n akaaki ase i bekun ka, “Deke kɛrɛ bo Nyɛmɛ ayo i casi, má a se ka i ti fin.” ");
INSERT INTO cko_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Deke n yoori sɔ kɔ juuri kun kun kpe nsan a, na wɔ kaba afun akɔ aŋgoro. ");
INSERT INTO cko_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Saŋga n bo Petoro subirisi fa kɔ deke n bo wɔ ŋu i n su ni, nyini saŋga, minɛm bo Koneliyo sunmaari bu ni, abisa asi Simon dika, na ba ka ajina awuru n anɔ nu. ");
INSERT INTO cko_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Na ba fere sɔnɔ be, abisa i ka, Simon Petoro wo dɔ ɔ? ");
INSERT INTO cko_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Petoro toko wo sunsun su, fa kɔ deke bo i baari i dɔ ka alɛlɛ nu n bu. Dɔ na Awiɛwiɛ Casi n ase i ka, “Ti fɛn. Minɛ nsan nbem wo fɛn suniɛniɛ u busu. ");
INSERT INTO cko_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Nyini ti, yasu na a jura, na u ni bɛrɛ kɔ, má a yo sika, dama mini sunmaari bu a.” ");
INSERT INTO cko_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Na Petoro ajura akɔ minɛm n dɔ, na wɔ se bu ka, “Mini ye am niɛniɛ m n a. Am natiiri bu la ka sɛ wɔ?” ");
INSERT INTO cko_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Na ba bɔ i nu ka, “Sojam kpiɛn Koneliyo sunmaari ya u dɔ a. I ti sɔnɔ kpa a, na i soro Nyɛmɛ, na Yuda­fɔm kɛrɛ bu i agaya. Nyɛmɛ mɛrɛkɛ be seeri i ka i fere u, na a ba i dika na a ba kan jɔrɛ bo a la i kere i a.” ");
INSERT INTO cko_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Nyini ti, na Petoro ade minɛm n awura, na ba da i dɔ. Alecin ŋgarama, na Petoro ayasu, na i ni minɛm n akɔ, bu sukɔ ni, na yarada­yo­fɔm nbem bo bu wo Jopa n gusu asu i su akɔ. ");
INSERT INTO cko_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Na i alecin fɔfɔrɛ, na ba ju Sizariya, bu kɔ ŋu ka Koneliyo atiɛn i lamɔsim, ni i danfo kpam nɔɔ suŋminda yiri Petoro. ");
INSERT INTO cko_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Saŋga bo Petoro kɔ ŋa i wura awuru n nu ni, na Koneliyo akpa i atin akutu i jaa bu haari asiɛŋgu, na wɔ su i. ");
INSERT INTO cko_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ama, na Petoro ayɛ i su ajina, na wɔ se i ka, “Mini ni m tii mmɔɔ, ti adamande wɔ.” ");
INSERT INTO cko_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Petoro ni Koneliyo bitaari anzama sɔ ɔ haari bu kɔ wuraari awuru n nu, dɔ na wɔ ŋu ka minɛ beberebe atiɛn bu nɔɔ. ");
INSERT INTO cko_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Na wɔ se bu ka, “Ambɛrɛ mmɔɔ ni am tii si ka, i ti ciire wɔ ka yɛrɛ Yuda­fɔm fa ya ŋu saŋga ni daanfiɛ barasu be nu, wara ya wura bu dika. Ama, Nyɛmɛ akere m ka má m sinndi sɔnɔ be ka i woo­wa ti fin. ");
INSERT INTO cko_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Nyini ti, ye a sunma fereeri m ye ma kete má ye ma ba n a. M koro ka m bisa u wɔ, nzu ti ye a sunma fereeri m a?” ");
INSERT INTO cko_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Na Koneliyo ase i ka, “I nyuma le­nna lɛɛ, ka ahin saŋga n sɔ, fa kɔ wiɛsu kerefi nsan, m wo m dika n nu wo nyɛmɛsere su, na sɔnɔ be akaba aba ajina m nyunu, i wura sutura fofoe papasi, ");
INSERT INTO cko_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","na wɔ se m ka, ‘Koneliyo, Nyɛmɛ ade u sere, ye wɔ teŋge u sakpa bo a yo ama yaari­fɔm n su. ");
INSERT INTO cko_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Nyini ti, sunma na bu kɔ Jopa, na bu kɔ fere Simon Petoro ni. I wo jɛrɛkɛ be dika a, bu fere i gusu ka Simon, i dika n wo dodo tieku n wɔ.’ ");
INSERT INTO cko_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Nyini ti, ye m kaba sunmaari ka bu fere u n a, ye wɔrɔ gusu a yo sakpa ye a ba. Kisa, ya kɛrɛ gusu atiɛn ya nɔɔ fɛn Nyɛmɛ nyunu, na ya ti deke n kɛrɛ bo Mibiɛ n ama u nɔɔ ka a fa ma ya ni.” ");
INSERT INTO cko_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Na Petoro anya ase ka, “Kisa, ma si nahɔrɛ su ka adamande kɛrɛ ti kun wɔ Nyɛmɛ dɔ, i tambu má nu. ");
INSERT INTO cko_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Sɔnɔ kɛrɛ bo i soro Nyɛmɛ na i yo sa bo i kɔ atin su i dɔ, i mi koro i ti nzu daanfiɛ sɔnɔ, Nyɛmɛ de i wɔ. ");
INSERT INTO cko_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Am si labari n bo Nyɛmɛ fa maari Yisareli­fɔm, nyini labari kpa n kere ka minɛm nya tana­laifiɛ Yesu Kristo dɛɛ ti, yiri ti sɔnɔ kɛrɛ Mibiɛ a. ");
INSERT INTO cko_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Am kɛrɛ si sa bo i boori i bu Galili dɛɛ awɔrɛ n nu, saŋga bo Yohane kaanri Nyɛmɛ nzue biɛ n jɔrɛ ni, haari na wɔ bara ayɛ Yudiya dɛɛ awɔrɛ n kɛrɛ nu. ");
INSERT INTO cko_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Am si Yesu Nazarɛti­fɔ n jɔrɛ ni, kabo Nyɛmɛ faari i Awiɛwiɛ Casi n ni yiko n wuraari i ŋu ni, ni kabo i nati bara yɛɛri deke kɛrɛ suyo sakpa sutuntun minɛm kɛrɛ bo Sitana miɛ bu n na bu nya laifiɛ, dama Nyɛmɛ woori i dɔ a. ");
INSERT INTO cko_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Yɛrɛ, ya ŋuuri deke n kɛrɛ bo i yoori bu Yuda­fɔm dɛɛ asiɛn su, ni Yɛrusalem miɛ kpiri n nu ni. Na ba kpama i baka jaanu n su, na wɔ wu. ");
INSERT INTO cko_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ama, i le­san cɛɛn, na Nyɛmɛ ateŋge i afite i yiwee n nu, na Nyɛmɛ ama minɛm aŋu i. ");
INSERT INTO cko_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Má sɔnɔ kɛrɛ ŋuuri i a, ama, yɛrɛ bo Nyɛmɛ du mɔ yiiri ya ka ya di i daani ni, yɛrɛ ŋuuri i a, na ya ni yiri asaŋga adi, na ya nu, saŋga bo i teŋgeeri ni. ");
INSERT INTO cko_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Na wɔ ma ya nɔɔ ka ya kɔ kan labari kpa n kere minɛm na ya di daani ka, yiri ye Nyɛmɛ ayi i ka i bá di ŋgɔɔ­fɔm, ni bo ba wu n kɛrɛ jɔrɛ a. ");
INSERT INTO cko_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Nyɛmɛ nɔaniɛ kan­fɔm kɛrɛ yo jɔjɔɔri Yesu jɔrɛ, bu ŋa, ‘Sɔnɔ kɛrɛ bo i yoori i yarada, Nyɛmɛ fá i mi satiɛ bo wɔ yo i fa ce i, Yesu dɛɛ duma n nu.’” ");
INSERT INTO cko_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Saŋga bo Petoro toko jina wo jɔjɔ su ni, na Awiɛwiɛ Casi n aba awura minɛm kɛrɛ bo bu jina suti labari n ŋu. ");
INSERT INTO cko_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Na Yuda­fɔm bo bu ti yarada­yo­fɔm na bu suuri Petoro su fiteeri Jopa miɛ kpiri n nu baari n ayo alekutura, kabo Nyɛmɛ afa i Awiɛwiɛ Casi n awura minɛm n bo bu ti má Yuda­fɔm mmɔɔ ŋu ni. ");
INSERT INTO cko_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Na bɛrɛ Yuda­fɔm ni, ati ka minɛm n sujɔjɔ aniɛ barasu barasu sukansi Nyɛmɛ. Na Petoro ase ka, ");
INSERT INTO cko_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Nyɛmɛ afa i Awiɛwiɛ Casi n awura ahin minɛm n ŋu, kabo i fa wuraari ya ŋu ni. Ye ŋma koro kete ka má ya biɛ bu Nyɛmɛ nzue a?” ");
INSERT INTO cko_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Nyini ti, na Petoro ama nɔɔ ka bu biɛ bu Nyɛmɛ nzue, Yesu Kristo duma n nu. Na ba sere i ka i wo bu dɔ le­nnyɔ. ");
INSERT INTO cko_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Na Yesu jaramasam ni, ni yarada­yo­fɔm n kɛrɛ bo bu wo Yudiya awɔrɛ n nu n ati ka, minɛm bo bu ti má Yuda­fɔm n gusu ade Nyɛmɛ nɔaniɛ n ayo i yarada. ");
INSERT INTO cko_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Nyini ti, saŋga bo Petoro kɔ Yɛrusalem miɛ kpiri n nu ni, na Yuda­fɔ yarada­yo­fɔm nbem ajaraki i. ");
INSERT INTO cko_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Bu ŋa, “Nzu ti ye a kɔ minɛm bo bu wura má kɛnkɛnɛ n dika ye u ni bɛrɛ kɔ saŋga di diire a?” ");
INSERT INTO cko_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Dɔ na Petoro abo i bu, na wɔ kan kabo jɔrɛ n kɛrɛ boori i bu kun kun n akere bu. ");
INSERT INTO cko_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","I ŋa, “M wo Jopa miɛ kpiri n nu, wo nyɛmɛsere su ni, na ma ŋu deke be, i yo m ka alɛlɛ dɛɛ su wɔ. M ŋuuri deke be, i ti ka tani bambaka wɔ, ba cici i bue nna n kɛrɛ, i sucɔɔndi fite aŋgoro n nu suba asiɛŋgu, na wɔ ba ajina m bi. ");
INSERT INTO cko_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Na ma niɛ i nu nyunyumi, na ma ŋu ajaa­nnam barasu kɛrɛ, ni cin­bukunnu­su­fɔm barasu kɛrɛ, ni laŋkpɛtɛ­fɔm barasu kɛrɛ ka bu wo nu. ");
INSERT INTO cko_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Na ma ti akonvi be ŋga, i ŋa, ‘Petoro, yasu na a kun di.’ ");
INSERT INTO cko_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ama, na ma se i ka, ‘M Mibiɛ, ai. M nya di má deke bo i ti ciire na i la fin.’ ");
INSERT INTO cko_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Na ma kaaki ati akonvi ni ŋga bekun, i fite aŋgoro wɔ, i ŋa, ‘Deke kɛrɛ bo Nyɛmɛ ayo i casi, má a se ka i ti fin.’ ");
INSERT INTO cko_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Deke n yoori sɔ kɔ juuri kun kun kpe nsan a, na wɔ kaaki afun akɔ aŋgoro. ");
INSERT INTO cko_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Nyini saŋga n nu, na minɛ nsanm n bo bu sunmaari bu m dɔ n afite Sizariya miɛ kpiri n nu aba aju awuru n bo m wo nu ni. ");
INSERT INTO cko_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Na Nyɛmɛ Awiɛwiɛ Casi n ase m ka m yasu na m su bu su kɔ, má m yo sika. Na ma su bu su, na ya kɛrɛ akɔ. Na ahin yarada­yo­fɔ nsɛnm n gusu asunma m afite Jopa, na ya kɛrɛ akɔ Sizariya, na ya kɔ awura Koneliyo dika. ");
INSERT INTO cko_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Na wɔ se ya kabo i ŋuuri Nyɛmɛ mɛrɛkɛ i dika barasu ni, ni kabo mɛrɛkɛ n ase i ka i sunma na bu kɔ Jopa, na bu kɔ fere sɔnɔ n bo bu fere i ka Simon Petoro ni, ");
INSERT INTO cko_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","na i bá kan jɔrɛ be kere u ni u dika­fɔm kɛrɛ na am nya tii­de. ");
INSERT INTO cko_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Na ma bo i bu ka m jɔjɔ. Saŋga bo m wo jɔjɔ su ni, na Awiɛwiɛ Casi n ajura awura bu ŋu, kabo i yo ba wuraari ya ŋu bumboori ni. ");
INSERT INTO cko_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Na ma teŋge su kabo Mibiɛ n yo seeri ni. I ŋa, ‘Yohane yo faari nzue biɛɛri am a, ama, mini fá Awiɛwiɛ Casi n ba wura am ŋu a.’ ");
INSERT INTO cko_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","I ti nahɔrɛ wɔ ka Nyɛmɛ faari i Awiɛwiɛ Casi n wuraari yɛrɛ Yuda­fɔm bo ya yo ya Mibiɛ Yesu Kristo yarada n ŋu, ye wɔ fa awura bo bu ti má Yuda­fɔm gusu ŋu. Mini la ŋma bo m koro kanda Nyɛmɛ ka má i yo sa bo i koro ka i yo i a?” ");
INSERT INTO cko_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Saŋga bo bɛrɛ Yuda­fɔm tiiri sɔ ni, ba se má jɔrɛ be kun, na ba kansi Nyɛmɛ, bu ŋa, “Nyɛmɛ ama minɛm bo bu ti má Yuda­fɔm n atin ka bɛrɛ gusu kaaki bu wo na bu nya ŋgɔɔ.” ");
INSERT INTO cko_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Fite saŋga n bo bu kuunri Satɛfano n dɛɛ sin, na ba kere yarada­yo­fɔm wuwuruwa, nyini ti, na ba sandi abara ayɛ deke kɛrɛ, na nbem akɔ Fonisiya awɔrɛ n nu, ni Sipurusi asiɛn n su, ni Antiyoki miɛ kpiri n nu, na bu kɔ sukan Nyɛmɛ nɔaniɛ n sukere Yuda­fɔm ŋgumi. ");
INSERT INTO cko_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ama, bu nbem wo nu, bu fite Sipurusi, na nbem gusu fite Sirene miɛ kpiri n nu, na ba kɔ Antiyoki, na bu sukan ya Mibiɛ Yesu labari kpa n jɔrɛ sukere minɛm bo bu ti má Yuda­fɔm ni. ");
INSERT INTO cko_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Na Mibiɛ n yiko awo bu dɔ nahɔrɛ su, na minɛ beberebe ayo yarada, na ba kaaki bu wo, na ba su Mibiɛ n dɛɛ atin n su. ");
INSERT INTO cko_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Nyɛmɛ minɛm bo bu wo Yɛrusalem miɛ kpiri n nu n tiiri nyini labari sɔ ni, na ba sunma Banabasi Antiyoki dɔ. ");
INSERT INTO cko_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Saŋga bo i juuri na i ŋuuri sakpa bo Nyɛmɛ ayo ama minɛm sɔ ni, na i ahore ajɔ, na wɔ tu bu fɔ ka bu ma bu nyunu boro yarada n bo bu bita i fa kɔ Mibiɛ n dɛɛ atin n su ni, na bu su i su ni bu ahore­mbaa kun. ");
INSERT INTO cko_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banabasi tiiri sɔnɔ kpa a, na Awiɛwiɛ Casi n awo i dɔ, na i la yarada agaya. Na minɛ beberebe aba ayo Mibiɛ n yarada. ");
INSERT INTO cko_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Na Banabasi akɔ Tarasu miɛ kpiri n nu ka i kɔ niɛniɛ Sɔɔlu. ");
INSERT INTO cko_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Saŋga bo Banabasi kɔ ŋuuri Sɔɔlu ni, na wɔ fa i na ba kɔ Antiyoki, na bɛrɛ minɛ nnyɔ n kɛrɛ akɔ awo dɔ afɔ kun, na ba tiɛn Kristo jama n nɔɔ, na ba kere minɛ beberebe. Antiyoki dɔ ye bu du mɔ fereeri yarada­yo­fɔm n ka Kristo­fɔm a. ");
INSERT INTO cko_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Nyini saŋga n nu, na Nyɛmɛ nɔaniɛ kan­fɔ nbem afite Yɛrusalem aba Antiyoki dɔ. ");
INSERT INTO cko_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Bu fere bu nu kun ka Agabusi, dɔ na Awiɛwiɛ Casi n ama i yiko, na wɔ yasu ajina ajɔjɔ ka, ahɔɛ bambaka be bá tɔ durunya n kɛrɛ nu. Nyini ahɔɛ n ba tɔɔri saŋga bo Roma­fɔm fɛmɛ kpiri bo bu fere i ka Kalodisi n diiri i fɛmɛya n a. ");
INSERT INTO cko_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Na Kristo susu­fɔm ni ayo anɔɔkun ka bu kun kun n kɛrɛ yiyi ŋwaa kabo bu faŋga nyaari ti barasu, na bu fa kɔ buka bu beŋgu yarada­yo­fɔm bo bu wo Yudiya awɔrɛ n nu ni. ");
INSERT INTO cko_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Na ba yiyi ŋwaa ni, na ba fa ŋwaa n asunma Banabasi ni Sɔɔlu ka bu fa kɔ ma Kristo jama nkpiɛn­kpiɛnm ni. ");
INSERT INTO cko_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Fa kɔ nyini saŋga n nu, na Fɛmɛ Herode abo i bu sukere Kristo jama minɛ nbem wuwuruwa. ");
INSERT INTO cko_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Na wɔ ma ba fa takobe akun Yohane gɔrɔ Yakobo. ");
INSERT INTO cko_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","I yoori saŋga bo Yuda­fɔm sudi bu Butara cɛɛn­kpiri n wɔ. ");
INSERT INTO cko_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Bu taraari Petoro wuraari dan­saraka nu ni, na ba fa i awura sojam buru ni nsɛn saa nu ka bu niɛ i dika. Na bɛrɛ gusu akpaaki nu ka minɛ nna niɛ i dika kɔ ju saŋga su, na nyiŋgam nya de. Na Fɛmɛ Herode asɛsɛ su ka bu diiri Butara cɛɛn­kpiri n siinri, i fa Petoro jina jama n kɛrɛ nyunu wɔ, na i di i jɔrɛ. ");
INSERT INTO cko_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Nyini ti, na wɔ ka dan­saraka n nu, na Kristo jama n asere Nyɛmɛ ni anyum­boro ama i. ");
INSERT INTO cko_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Nyini cɛɛn n kɔŋguɛ n bo i alecin na Fɛmɛ Herode má bu yi Petoro fite na bu di i jɔrɛ ni, i da sojam nnyɔ afiɛn wɔ. Na ba wura i jɔrɔkɔ aminda bu i bue nnyɔ n kɛrɛ, na nbem gusu kaaki jina dan­saraka anɔ n nu ŋminda. ");
INSERT INTO cko_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Kpeŋga na Nyɛmɛ mɛrɛkɛ be aba ajina dan­saraka n nu, na sɔɔ n ata wein. Na mɛrɛkɛ n abo Petoro gbɛngbɛn, na wɔ teŋge i, na wɔ se i ka, “Yasu ndende.” Na jɔrɔkɔ n bo i wo Petoro saa n afite atɔ. ");
INSERT INTO cko_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Na mɛrɛkɛ n ase i ka, “Bo u dambara ni, na a fa u gbagbaa n wura.” Na Petoro ayo sɔ, na wɔ kaaki ase i ka, “Fa u tanlɛɛ n wura, na a su m su.” ");
INSERT INTO cko_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Na Petoro asu i su afite dan­saraka sɔɔ n nu, wɔ si má ka sa n bo mɛrɛkɛ n suyo i n ti nahɔrɛ wɔ, i sunsun ka i yo i ka alɛlɛ dɛɛ su wɔ. ");
INSERT INTO cko_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Na ba kɔ asin sojam ciciri su dɛɛ n ŋu, na ba kɔ asin nnyɔ su dɛɛ n gusu ŋu, na ba kɔ aju bulaari anɔ n bo bu teke i ka na bu sin kɔ miɛ n kunnu ni. Na anɔ n ni i tii ateke, na ba fite. Bu toori atiŋgbere n nu kɔɔri mɔ kaan, na mɛrɛkɛ n akaba ayaki Petoro. ");
INSERT INTO cko_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Dɔ na Petoro nyunu akoro, na wɔ se ka, “Kisa, ma si ka i ti nahɔrɛ wɔ, ka Micɛra n ye wɔ sunma i mɛrɛkɛ n ka i yi m fite Fɛmɛ Herode saa nu, ni deke n kɛrɛ bo Yuda­fɔm sunsun ka bu yó m ni.” ");
INSERT INTO cko_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","I faari nyini sa n kɛrɛ nu sɔ ni, na wɔ kɔ Mariya dika, i wa la Yohane n bo bu kaaki fere i Marako ni, nyini saŋga, jama beberebe atiɛn bu nɔɔ wo nyɛmɛsere su. ");
INSERT INTO cko_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Na Petoro abobo dasin anɔ ni, na afani be, bu fere i ka Roda, na wɔ ba ka i ba niɛ sɔnɔ n bo i bobo anɔ ni. ");
INSERT INTO cko_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Na wɔ si akonvi n ka Petoro lɛɛ, i ahore ajɔ agaya n dɛɛ ti, wɔ teke má anɔ ni, na wɔ ŋmati akpie i nyi, na wɔ kɔ ase minɛm bo bu wo awuru n nu n ka Petoro jina dasin. ");
INSERT INTO cko_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Na ba se i ka, “A bo fiɛ wɔ.” Ama, na wɔ kaaki ajɔjɔ ni anyum­boro ka i ti nahɔrɛ wɔ. Dɔ na ba se ka, “Kisa, i mɛrɛkɛ a.” ");
INSERT INTO cko_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Nyini saŋga n kɛrɛ Petoro toko jina anɔ n nu wo bobo su. Kasin, na ba ba ateke anɔ ni, na saŋga bo bu ŋuuri ka yiri ni, na ba yo alekutura. ");
INSERT INTO cko_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Na Petoro afa i saa ayo bu ka bu yaki naŋmiɛ. Na wɔ kan akere bu kabo Mibiɛ n yiiri i fiteeri dan­saraka sɔɔ n nu barasu ni. Na wɔ se bu ka, “Am kɔ kan ahin jɔrɛ n kere Yakobo ni yarada­yo­fɔ nyiŋgam n kɛrɛ.” Na wɔ fite bu bi bɛrɛ akɔ deke be. ");
INSERT INTO cko_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ale ba ciinri ni, na jɔrɛ n amiɛ sojam ni, ba si má kabo bu yo. Na ba se ka, “Ye nzu ayo Petoro a?” ");
INSERT INTO cko_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Na Fɛmɛ Herode ama nɔɔ ka bu niɛniɛ Petoro busu, ama, ba ŋu má i. Nyini ti, na wɔ bisa sojam bu jɔrɛ ni, na wɔ ma nɔɔ ka bu kun bu. Nyini sin, na Fɛmɛ Herode afite Yudiya awɔrɛ n nu, na wɔ kɔ awo Sizariya miɛ kpiri n nu fa kɔ saŋga su. ");
INSERT INTO cko_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Na Fɛmɛ Herode afa yaa agaya Tiro ni Sidon miɛ n nu­fɔm ŋu, nyini ti, na ba fa sɛsɛ­su, na ba kɔ ka bu ŋu i. Bu du mɔ kɔɔri sɔnɔ be dɔ ɔ ka, bu fere i ka Blasitusi, na bu ni i dɛɛ ayo kun ka. Blasitusi ti Fɛmɛ Herode gisan n niɛ­fɔ kpiɛn wɔ. Na wɔ nya fa bu akɔ Fɛmɛ Herode dɔ, na ba kɔ asere ka i ma bu ni yiri nya tana­laifiɛ. Deke bo i ti na bu yoori sɔ n la ka, dama bu diire kɛrɛ fite yiri fɛmɛ n dɛɛ asiɛn n su wɔ. ");
INSERT INTO cko_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Cɛɛn n bo bu kpamaari i ba juuri ni, na Fɛmɛ Herode awura i fɛmɛya sutura, na wɔ tana i fɛmɛya biɛ n su, na wɔ jɔjɔ minɛm n dɔ. ");
INSERT INTO cko_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","I jɔjɔ wieeri ni, na minɛ kɛrɛ atiɛn, bu ŋa, “Ahin yiri, nyɛmɛ be ajɔjɔ a, má adamande.” ");
INSERT INTO cko_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Kpeŋga na Micɛra n mɛrɛkɛ akaba abo i aji, dama wɔ ma má Nyɛmɛ jirima n dɛɛ ti. Na wɔ da tukpaki, na kakabam awura i, na wɔ wu. ");
INSERT INTO cko_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Na Nyɛmɛ nɔaniɛ n asandi abara ayɛ deke n kɛrɛ, na ba nya minɛ dɔŋgu abuka su. ");
INSERT INTO cko_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Banabasi ni Sɔɔlu yoori bu juma n Yɛrusalem miɛ nu wieeri ni, na ba fa Yohane bo bu kaaki fere i ka Marako ni, na ba fite Yɛrusalem na ba kaaki akɔ Antiyoki miɛ kpiri n nu. ");
INSERT INTO cko_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Kristo jama n bo i wo Antiyoki miɛ kpiri n nu ni, bu nu nbem ti Nyɛmɛ nɔaniɛ kan­fɔm wɔ, na nbem gusu ti kere­fɔm. Bɛrɛ la Banabasi, ni Simeyon bo bu kaaki fere i ka Nigɛri ni, ni Lukiyosi bo i fite Sirene miɛ kpiri n nu ni, ni Manaye bo bu yo saŋga taari i ni Fɛmɛ Herode, ni Sɔɔlu ni. ");
INSERT INTO cko_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Saŋga bo bu cici bu nɔɔ na bu wo Mibiɛ n su su ni, na Awiɛwiɛ Casi n ase bu ka, “Am yi Banabasi ni Sɔɔlu ma m, na bu yo juma n bo ma yi bu ka bu yo i ni.” ");
INSERT INTO cko_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Bu ciciiri bu nɔɔ, na bu sereeri Nyɛmɛ n wieeri ni, na ba fa bu saa anana bu ŋu, na ba ma bu atin na ba kɔ. ");
INSERT INTO cko_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Na Awiɛwiɛ Casi n asunma Banabasi ni Sɔɔlu na ba kɔ aju miɛ kpiri be su, bu fere i ka Sɛlusiya, na ba fa lee bambaka dɔ, na ba kɔ miɛ be bo i wo lui bambaka be su, bu fere nyini lui n ka Sipurusi n su. ");
INSERT INTO cko_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Saŋga bo bu kɔ juuri lui n miɛ kpiri n bo bu fere i ka Salamisi n su ni, na ba kan Nyɛmɛ jɔrɛ Yuda­fɔm tiɛntiɛn­bunɔɔ sɔɔm nu. Na Yohane bo bu kaaki fere i ka Marako n awo bu dɔ abuka bu juma. ");
INSERT INTO cko_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Na ba fa bɛrɛ asin akɔ aju lui bambaka n wiɛ atɔɔri dɛɛ bue ni, miɛ kpiri be su, bu fere i ka Pafɔsi. Na ba kɔ aŋu boboyaya­fɔ be dɔ, bu fere i ka Baari Yesu, i ti Yuda­fɔ ɔ, i yo i ŋu ka i ti Nyɛmɛ nɔaniɛ kan­fɔ ɔ, ama, i ti má i. ");
INSERT INTO cko_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","I yo wo lui bambaka n su gomina n dɔ ɔ, bu fere gomina n ka Sɛgosi Pɔɔlu, i ti si­fɔ ɔ. Na wɔ fere Banabasi ni Sɔɔlu, dama i koroori ka i ti Nyɛmɛ nɔaniɛ n wɔ. ");
INSERT INTO cko_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ama, boboyaya­fɔ ni, bu kaaki fere i duma Giriki aniɛ nu ka Elamasi ni, na wɔ boro i nyi ka i kanda gomina n na má i yo Yesu yarada. ");
INSERT INTO cko_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ama, na Nyɛmɛ Awiɛwiɛ Casi n awura Sɔɔlu, bo bu kaaki fere i ka Pɔɔlu ŋu, na wɔ niɛ boboyaya­fɔ n gbirim, na wɔ se i ka, ");
INSERT INTO cko_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Wɔrɔ, a ti Sitana dɛɛ wa a. A ti deke kɛrɛ bo i ti kpa n kpɔ­fɔ ɔ. Kɔrɛ ni satiɛ­yo asunnu u ŋu. A ti Mibiɛ n atin kpa n saaki­fɔ ɔ. Cɛɛn bɔnɔ ye a yaki i a? ");
INSERT INTO cko_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ti fɛn, Mibiɛ ni bó u ji kisa, na a yó anyinsin fa kɔ saŋga su, na a ŋú má wiɛ ka i ta kun.” Kpeŋga na i nyunu akaba asi biri, na i suturiŋgi suniɛniɛ sɔnɔ bo i kere i atin. ");
INSERT INTO cko_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Saŋga bo gomina n ŋuuri nyini n sɔ ni, na i tiiri kabo bu kan Nyɛmɛ nɔaniɛ ni, na wɔ yo i alekutura, nyini dɛɛ ti, na wɔ yo Mibiɛ n yarada. ");
INSERT INTO cko_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Na Pɔɔlu ni i lamɔkɔm n afa lee bambaka afite Pafɔsi dɛɛ miɛ kpiri n nu akɔ aju miɛ kpiri n bo bu fere i ka Pɛrɛga na i wo Pamfiliya awɔrɛ n nu ni. Na Yohane bo bu kaaki fere i ka Marako n akpaaki ayaki bu, na wɔ kpie i nyi akɔ Yɛrusalem miɛ kpiri n nu. ");
INSERT INTO cko_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Na ba fite Pɛrɛga akɔ aju Antiyoki miɛ kpiri n bo i wo Pisidiya awɔrɛ n nu ni. Na Ŋumi­yi cɛɛn, na ba kɔ awura atana bu tiɛntiɛn­bunɔɔ sɔɔ n nu. ");
INSERT INTO cko_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Saŋga bo bu kaanri Nyɛmɛ nɔaniɛ kpamaa­wa kadasi n bo Moyisi kɛrɛɛri i ni, ni Nyɛmɛ nɔaniɛ kan­fɔm dɛɛ kadasi n wieeri ni, na bu tiɛntiɛn­bunɔɔ sɔɔ ni nkpiɛn­kpiɛnm n asunma ase Pɔɔlu ka, “Njam, nzɛn am la jɔrɛ be bo am kan kere jama ni, na i ma bu ahoresi, am kan kere bu.” ");
INSERT INTO cko_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Dɔ na Pɔɔlu ayasu ajina, na wɔ yɛ i saa su, na wɔ bo i bu na i jɔjɔ, i ŋa, “M lamɔkɔ Yuda­fɔm, ni ambɛrɛ bo am ti má Yuda­fɔm na am su Nyɛmɛ ni, am ti fɛn. ");
INSERT INTO cko_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Yisareli­fɔm Nyɛmɛ ni, yiri yo yiiri ya nam a, na wɔ ma ba tɛrɛ abuka su, saŋga bo bu yo ti wɔfɔm Ijipiti asiɛn su ni. Na Nyɛmɛ afa i dɛɛ yiko bambaka n na wɔ yi bu afite Ijipiti asiɛn n su, ");
INSERT INTO cko_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","na wɔ mindi abita bu boro kpantain n nu akɔ aju afɔ abura­na. ");
INSERT INTO cko_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Na wɔ butu daanfiɛ barasu nso n bo bu wo Kanana asiɛn n su ni, na wɔ fa bu asiɛn n ama Yisareli­fɔm ka bu fa yo bu tiɛŋgu dɛɛ. ");
INSERT INTO cko_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ahin n kɛrɛ yoori sɔ kɔ juuri afɔ yaa nna ni afɔ aburu­nu wɔ. Nyini sin, na Nyɛmɛ ayi mɔ­fɔm ama bu haari fa kɔ ju saŋga bo i yiiri i nɔaniɛ kan­fɔ Samuwɛli maari bu ni. ");
INSERT INTO cko_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Na ba ba ase Samuwɛli ka bu koro fɛmɛ wɔ, na Nyɛmɛ ama Sɔɔlu bo i ti Kisi wa n ayo bu fɛmɛ, i fite Bɛnjamin n dɛɛ busu nu wɔ, na wɔ bita bu akɔ aju afɔ abura­na. ");
INSERT INTO cko_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Na Nyɛmɛ ayi Sɔɔlu fɛmɛya n nu, na wɔ fa Fɛmɛ Davidi bo i ti Jese wa n ajina i jinaa­biri. Na Nyɛmɛ adi i ŋusu daani, i ŋa, ‘Yiri Davidi, Jese wa n ti sɔnɔ bo m ahore atara i a, yiri yó m sa koroo­wa kɛrɛ a.’ ");
INSERT INTO cko_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Yiri Fɛmɛ Davidi dɛɛ busu nu ye Nyɛmɛ seeri ka Yisareli­fɔm Tii­de­fɔ Yesu ni fite n a. ");
INSERT INTO cko_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Kana Yesu ba ba, Yohane du mɔ ba kaanri Nyɛmɛ jɔrɛ kereeri Yisareli­fɔm wɔ, ka bu kaaki bu wo na i biɛ bu Nyɛmɛ nzue. ");
INSERT INTO cko_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Na saŋga bo Yohane ba sukoro ka i wie i juma n ni, na wɔ se minɛm n ka, ‘Am sunsun ka mini la ŋma a? Ai, má mini la sɔnɔ n bo am ŋminda i ka i bá n a. Ama, am ti fɛn. Yiri bo i wo m sin suba ni, m ti kaan mmɔɔ ni bo m dodo i.’ ");
INSERT INTO cko_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","M ninbaam, ambɛrɛ bo am ti Abraham busu nu­fɔm ni, ni ambɛrɛ bo am ti má Yuda­fɔm na am su Nyɛmɛ ni, yɛrɛ ye Nyɛmɛ ma ba fa ahin tii­de labari n ama ya a. ");
INSERT INTO cko_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Dama Yɛrusalem­fɔm ni bu nkpiɛn­kpiɛnm kɛrɛ asi má Nyɛmɛ nɔaniɛ kan­fɔm dɛɛ kadasi n bu, haari ni bo bu kan i bu Ŋumi­yi cɛɛn n kɛrɛ mmɔɔ ni. Ba kaaki asi má kabo Yesu ti barasu, na ba ma ba kun i. Nyini ma Nyɛmɛ nɔaniɛ kan­fɔm kadasi n ayo yii­wa a. ");
INSERT INTO cko_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Haari ni bo ba yo aŋu má deke n bo i ti na wɔ yo daka ka bu kun i ni, bu sereeri Gomina Pilato wɔ, ka i ma bu kun i. ");
INSERT INTO cko_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Na saŋga bo bu yoori sa n kɛrɛ bo ba kɛrɛ i Nyɛmɛ Jɔrɛ Kadasi n nu fa kɔ i ŋusu jɔrɛ ni, na ba jura i baka jaanu n su, na ba fa i awura yabuɛ buɛ faŋ­kunma nu. ");
INSERT INTO cko_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ama, na Nyɛmɛ ateŋge i yiwee n nu, ");
INSERT INTO cko_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","na wɔ yi i ŋu bo i la má nɔ akere minɛm kɛrɛ bo bu suuri i su fiteeri Galili awɔrɛ n nu kɔɔri Yɛrusalem ni. Bɛrɛ n bo bu ŋuuri sam bo bu yoori ni, kisa bɛrɛ sudi i daani kere ya minɛm n a. ");
INSERT INTO cko_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Nyini ti, ya ba ka ya kan labari kpa sam n bo Nyɛmɛ seeri ka i fa ma ya nam ni kere am a, ");
INSERT INTO cko_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ye i ma nɔaniɛ n ayo yii­wa ama yɛrɛ bo ya ti bu busu nu­fɔm n a, wɔ teŋge Yesu i yiwee n nu, kabo ba kɛrɛ i Kansi Jue kɛrɛɛ­wam n nu, i jue nnyɔ su ni. Nyɛmɛ ŋa, ‘Wɔrɔ ti m Wa a, nyuma, m káaki u Si.’ ");
INSERT INTO cko_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Bekun, kabo i teŋgeeri i yiwee n nu na i kpɔrɔ má faŋ­kunma nu ni, Nyɛmɛ akaaki ase ka, ‘M fá deke kpa n bo i ti casi na i la anyunuyi n ma u, yiri ye m seeri ka m fa ma Fɛmɛ Davidi n a.’ ");
INSERT INTO cko_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ba kaaki akɛrɛ i Kansi Jue kɛrɛɛ­wam n awɔrɛ be nu, ka, ‘A yáki má na u Amusui­su­fɔ Casi n wu kpɔrɔ.’ ");
INSERT INTO cko_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Fɛmɛ Davidi yo yoori Nyɛmɛ kun koroo­wa haari na wɔ ba awu, na ba se i deke bo bu seeri i nam ni, na i ŋuniɛ­mbaa n akpɔrɔ faŋ­kunma n nu. ");
INSERT INTO cko_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ama, yiri n bo Nyɛmɛ teŋgeeri i yiwee n nu ni, wɔ kpɔrɔ má. ");
INSERT INTO cko_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Nyini ti, m ninbaam, m koro ka am si ka yiri Yesu dɛɛ ti ye bu kaanri labari kpa n jɔrɛ kereeri am a, ka Nyɛmɛ afa am satiɛ ace am. ");
INSERT INTO cko_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Sɔnɔ kɛrɛ bo i yoori yiri n yarada, Nyɛmɛ afa i mi satiɛ kɛrɛ ace i. Nɔaniɛ kpamaa­wa n bo Moyisi fa maari ni, wɔ koro afa má minɛm satiɛ ace má bu. ");
INSERT INTO cko_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Am si am ŋu sa, adena má sam bo Nyɛmɛ nɔaniɛ kan­fɔm yo seeri n be tu am. ");
INSERT INTO cko_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Bu yo seeri ka, ‘Ambɛrɛ bo am yo Nyɛmɛ anzasi ni, am ti fɛn, am yo alekutura na am ka ŋgbɛɛn, dama m suyo juma be am dɛɛ saŋga nu, haari má be kan kereeri am, am dé má i.’” ");
INSERT INTO cko_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Na saŋga bo Pɔɔlu ni Banabasi sufite tiɛntiɛn­bunɔɔ sɔɔ n nu ni, na minɛm n asere bu ka bu kaaki bra Ŋumi­yi cɛɛn n bo i suba ni, na bu ba kan nyini jɔrɛm bo ba kan akere bu ni, na bu tí bekun. ");
INSERT INTO cko_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Saŋga bo minɛm ni ba sandiiri tiɛntiɛn­bunɔɔ sɔɔ n ni, na Yuda­fɔm nbem, ni bo bu ti má Yuda­fɔm na ba kaaki bu woo­wa na bu su Yuda­fɔm atin n su ni, na bu dɔŋgu asu Pɔɔlu ni Banabasi su. Na Pɔɔlu ni Banabasi atu bu fɔ, ka má bu kaaki bu sin bo sakpa n bo Nyɛmɛ ayo ama bu ni. ");
INSERT INTO cko_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ŋumi­yi cɛɛn n ba juuri ni, na minɛm n dɔŋgu bo bu wo miɛ n nu n aba atiɛn bu nɔɔ tiɛntiɛn­bunɔɔ sɔɔ n nu na bu ti Nyɛmɛ jɔrɛ ni. ");
INSERT INTO cko_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Saŋga bo Yuda­fɔm nkpiɛn­kpiɛnm ni ŋuuri jama n sɔ ni, na ba si Pɔɔlu kɔrɛ, na bu ni yiri awura akuruwa, na ba kpiɛ i nzukɔ. ");
INSERT INTO cko_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ama, na Pɔɔlu ni Banabasi ajɔjɔ ni ahoresi, bu ŋa, “I ti ye ni ka ya du mɔ kan Nyɛmɛ nɔaniɛ n kere ambɛrɛ wɔ ka. Ama, kabo am akete i na am koro má ka am nya ŋgɔɔ n bo i la má awieeri ni, ya yáki am wɔ, na ya kɔ́ kan kere minɛm bo bu ti má Yuda­fɔm ni. ");
INSERT INTO cko_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Dama nɔaniɛ maa­wa bo Mibiɛ n fa maari ya n lɛɛ. I ŋa, ‘Ma yi u ka a yo wein ma minɛm bo bu ti má Yuda­fɔm ni, adena durunya n nu­fɔm kɛrɛ nya tii­de.’” ");
INSERT INTO cko_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Saŋga bo minɛm n bo bu ti má Yuda­fɔm tiiri ahin nɔaniɛ n sɔ ni, na bu ahore ajɔ, na ba kansi Mibiɛ n nɔaniɛ ni. Na minɛm bo Nyɛmɛ ayi bu ka bu nya ŋgɔɔ n bo i la má awieeri n ayo yarada. ");
INSERT INTO cko_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Na Mibiɛ n nɔaniɛ n asandi abara ayɛ nyini awɔrɛ n kɛrɛ nu. ");
INSERT INTO cko_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ama, na Yuda­fɔm nkpiɛn­kpiɛnm n awura minɛm bu sin, bɛrɛ la nbaram bo bu la wo na bu su Nyɛmɛ ni, ni nbiɛsɔm bo bu wo miɛ n nu na bu se na i bi ni. Na ba kere Pɔɔlu ni Banabasi wuwuruwa, na ba fɔn bu afite bu asiɛn n su. ");
INSERT INTO cko_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Na Pɔɔlu ni Banabasi akpɔnkpɔn bu jaa tuturi agɔ bu ŋu, nyini kere ka ba kete miɛ n nu­fɔm lɛɛ, na ba kɔ miɛ kpiri be bo bu fere i ka Ikoniyom n su. ");
INSERT INTO cko_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Na Yesu susu­fɔm bo bu wo Antiyoki dɔ ni, bu ahore ajɔ agaya, na Awiɛwiɛ Casi n awo bu dɔ. ");
INSERT INTO cko_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pɔɔlu ni Banabasi kɔ juuri Ikoniyom miɛ kpiri n nu ni, bu kaaki yoori sɔ bekun, na ba wura bu tiɛntiɛn­bunɔɔ sɔɔ n nu, na ba kan Nyɛmɛ jɔrɛ n ni anyum­boro haari na minɛ beberebe ayo yarada, Yuda­fɔm, ni bo bu ti má Yuda­fɔm n kɛrɛ. ");
INSERT INTO cko_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ama, na Yuda­fɔm nbem bo bu yo má yarada n awura minɛm bo bu ti má Yuda­fɔm bu sin akpura bu ni yarada­yo­fɔm n tii. ");
INSERT INTO cko_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Na Pɔɔlu ni Banabasi awo dɔ ayo le­nnyɔ. Na bu sujɔjɔ Mibiɛ n jɔrɛ ni ahoresi, na Mibiɛ n ama bu faŋga, na wɔ ma bu atin na ba yo alekutura sa barasu barasum, adena minɛ ŋu bu na bu si ka i ti nahɔrɛ wɔ. ");
INSERT INTO cko_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Na kpakpaaki­nu aba miɛ n nu­fɔm dɔ, na nbem ajina Yuda­fɔm n sin, na nbem gusu ajina Yesu jaramasam n sin. ");
INSERT INTO cko_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Na bo bu ti má Yuda­fɔm ni, ni Yuda­fɔm ni, fa saŋga ni bu mɔ­fɔm n afa sɛsɛ­su atara kabo bu yo Yesu jaramasam ni tiɛ, na bu tu bu yabuɛ. ");
INSERT INTO cko_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Na Yesu jaramasam n afa nu fa kɔ kabo bu koro ka bu yo ni, na ba ŋmati akɔ miɛ kpiri nbem bo bu fere bu ka Lisitira ni Dɛrɛbi n su. Bu wo Likawoniya awɔrɛ n nu wɔ, na bu nya nati subara yɛ ahɛmɛ ahɛmɛm. ");
INSERT INTO cko_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Dɔ na ba kan labari kpa n akere minɛm. ");
INSERT INTO cko_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Sɔnɔ be woori Lisitira miɛ kpiri n nu, i jaa awu, kabo bu wuuri i ni, i ti wɔbuka a, wɔ nati má. ");
INSERT INTO cko_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Na wɔ tana aso i sui ati kabo Pɔɔlu sujɔjɔ ni. Na Pɔɔlu afa i nyu­mbaa akpama i ŋu, na wɔ fa nu ka sɔnɔ n ayo yarada, ka i koro tuntun i na i nya laifiɛ. ");
INSERT INTO cko_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Na wɔ tiɛn kpa ase i ka, “Yasu jina cencen.” Na sɔnɔ n ayasu kungere­kun awarakpin sunati bara yɛ. ");
INSERT INTO cko_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Saŋga bo jama n ŋuuri sa n bo Pɔɔlu ayo i sɔ ni, na ba tiɛn kpa Likawoniya aniɛ n nu, bu ŋa, “Ya nyɛmɛm akaaki ka adamandem wɔ, ye ba jura aba ya dɔ a.” ");
INSERT INTO cko_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Na ba fere Banabasi duma ka Ziyosi, bu amɔɛ kpiri duma lɛɛ, na ba fere Pɔɔlu ka Hɛrɛmesi, dama yiri ti amɔɛ n cɛm a. ");
INSERT INTO cko_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Na amɔɛ n bo bu fere i ka Ziyosi n sɔɔ jina miɛ n ahɛmɛ, na amɔɛ n fɔ n ni miɛ n nu­fɔm anyɔndi tooram ni baka pum afa aba miɛ n anɔ nu ka bu fa yo tiɛ ma Pɔɔlu ni Banabasi. ");
INSERT INTO cko_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Saŋga bo Pɔɔlu ni Banabasi tiiri kabo minɛm koro ka bu yo ni, na bu ahore asaaki na yaa ati bu, nyini ti, na ba cin asɔn bu sutura bo bu wura i, na ba ŋmati awura jama n afiɛn sutiɛn bu ŋu, ");
INSERT INTO cko_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","bu ŋa, “Njam o e, nzu ti ye am suyo sɔ a? Yɛrɛ mmɔɔ ni ya tii, ti adamandem kabo am ti n wɔ. Ya ba ka ya kan labari kpa n kere am wɔ, na am yaki nyini deke ŋgbɛɛnm ni, na am su Nyɛmɛ bo i wo bɛrɛ saŋga kɛrɛ ni. Yiri yiiri aŋgoro, ni asiɛŋgu, ni tieku n ni dekem kɛrɛ bo bu wo nu n a. ");
INSERT INTO cko_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Dawa saŋga ni, yiri Nyɛmɛ yo maari atin wɔ ka daanfiɛ kɛrɛ yo kabo i koro. ");
INSERT INTO cko_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ama, haari ni nyini n kɛrɛ, saŋga kɛrɛ i yo sakpa ma am wɔ, i ma nzue tɔ ma am wɔ, na am alɛ­mbaa bo am dɔ bu n yo nyunyumi, na am di, na am kunnu yi, na i ma am ahorejɔ. Nyini kɛrɛ kere am ka i wo bɛrɛ a.” ");
INSERT INTO cko_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Haari ni nyini jɔjɔɔ­wa n kɛrɛ n mmɔɔ ni, i yoori kekereke maari Pɔɔlu ni Banabasi ye bu koro kandaari jama n ye ba yo má tiɛ ama bu n a. ");
INSERT INTO cko_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Na Yuda­fɔ nbem afite Antiyoki ni Ikoniyom miɛ kpirim n nu aba Lisitira, na ba ma minɛm ade bu nɔaniɛ, na ba tutu Pɔɔlu yabuɛ, bu sunsun ka wɔ wu wɔ, na ba cin i afite miɛ n nu. ");
INSERT INTO cko_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ama, na Yesu susu­fɔm n atiɛn bu nɔɔ abara ayɛ i, na wɔ yasu, na wɔ kpie i nyi awura miɛ n nu. Na alecin fɔfɔrɛ, na yiri ni Banabasi afite dɔ, na ba kɔ Dɛrɛbi miɛ kpiri n nu. ");
INSERT INTO cko_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Na Pɔɔlu ni Banabasi akan labari kpa n Dɛrɛbi miɛ kpiri n nu, na ba nya susu­fɔm beberebe dɔ. Na ba kpie bu nyi akɔ Lisitira, ni Ikoniyom miɛ kpirim n nu, na ba nya akɔ Antiyoki miɛ kpiri n bo i wo Pisidiya awɔrɛ n nu ni. ");
INSERT INTO cko_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Na ba se yarada­yo­fɔm ni ka, bu ma bu yarada n yo bii­wa, na ba ma bu ahoresi. Na ba se bu ka, “Wɔ yo daka ka bu kere ya wuwuruwa beberebe ka, na ya nya koro wura Nyɛmɛ fɛmɛya n nu.” ");
INSERT INTO cko_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Miɛ kɛrɛ bo bu wɔɔri su, bu yi nkpiɛn­kpiɛnm wɔ Kristo jama n nu, na bu cici bu nɔɔ, na bu sere Nyɛmɛ, na bu fa bu wura yiri Mibiɛ n bo ba yo i yarada n saa nu ka i niɛ bu dika. ");
INSERT INTO cko_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Bu fite dɔ ni, na ba fa Pisidiya awɔrɛ n nu akɔ atiɛ Pamfiliya dɛɛ awɔrɛ n nu. ");
INSERT INTO cko_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Dɔ na ba kan Nyɛmɛ jɔrɛ Pɛrɛga miɛ kpiri n nu, na ba nya akɔ Ataliya miɛ kpiri n nu, ");
INSERT INTO cko_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","na ba fa lee bambaka afite dɔ akpie bu nyi akaaki akɔ Antiyoki miɛ kpiri n bo i wo Siriya awɔrɛ n nu. Dɔ ye bu du mɔ sereeri Nyɛmɛ maari bu ka bu di i ahɔrɔma fa kɔ nyini juma n bo kisa ba yo i awie ni. ");
INSERT INTO cko_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Saŋga bo bu kɔ juuri Antiyoki ni, na ba tiɛn Kristo jama n nɔɔ, na ba kan sam n bo Nyɛmɛ ayo bu ni, ni kabo wɔ teke atin ama bo bu ti má Yuda­fɔm na ba yo yarada barasu ni. ");
INSERT INTO cko_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Na ba wo yarada­yo­fɔm n dɔ miɛ n nu acɛ. ");
INSERT INTO cko_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Tɔ, na minɛ nbem afite Yudiya awɔrɛ n nu aba Antiyoki miɛ kpiri n nu, na bu sukere yarada­yo­fɔm ni bu dɛɛ keree­wam. Bu ŋa, “Má ka ba wura am kɛnkɛnnɛ kabo Moyisi yo kereeri ni, am koro nya má tii­de.” ");
INSERT INTO cko_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Na Pɔɔlu, ni Banabasi, ni bɛrɛ ase akuruwa nyannyan fa kɔ nyini jɔrɛ n bu su. Nyini ti, na ba fa sɛsɛ­su ka Pɔɔlu, ni Banabasi, ni yarada­yo­fɔm nbem bo bu wo Antiyoki ni, ka bu kɔ Yɛrusalem miɛ kpiri n nu na bu kɔ bisa Yesu jaramasam ni, ni Kristo jama nkpiɛn­kpiɛnm n nyini jɔrɛ ni. ");
INSERT INTO cko_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Na Kristo jama n akaari bu na ba kɔ. Bu wo kɔ su ni, na ba fa Fonisiya, ni Samariya awɔrɛm n nu, na ba kan akere dɔ­fɔm kabo minɛm bo bu ti má Yuda­fɔm n ayo Nyɛmɛ yarada barasu ni, na nyini labari n ama yarada­yo­fɔm n ahore ajɔ akɔ asin su. ");
INSERT INTO cko_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Saŋga bo bu kɔ juuri Yɛrusalem ni, na Kristo jama ni, ni Yesu jaramasam, ni nkpiɛn­kpiɛnm n ade bu ni bu saa nnyɔ, na ba kan akere bu fa kɔ deke n kɛrɛ bo Nyɛmɛ ma ba koro ayo i ni. ");
INSERT INTO cko_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ama, na yarada­yo­fɔ nbem bo bu su Farasi­fɔm atin n su n ayasu ajina, ase ka, “Wɔ yo daka ka minɛm bo bu ti má Yuda­fɔm na ba yo Yesu yarada n awura kɛnkɛnnɛ ka, na bu nya ma bu nɔɔ ka bu su Nyɛmɛ nɔaniɛ kpamaa­wa n bo i fa maari Moyisi n su.” ");
INSERT INTO cko_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Na Yesu jaramasam ni nkpiɛn­kpiɛnm ni, atiɛn bu nɔɔ, na bu kpokpo jɔrɛ n nu nyunyumi. ");
INSERT INTO cko_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Na ba se nyini jɔrɛ n akuruwa bu ŋuŋu nu acɛ, na Petoro ayasu ajina, na wɔ se bu ka, “M ninbaam, am si ka mini ye Nyɛmɛ du mɔ yiiri m fiteeri am nu, ka m ma minɛm bo bu ti má Yuda­fɔm n ti labari kpa ni, adena bu yo yarada. ");
INSERT INTO cko_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Na Nyɛmɛ bo i si kabo adamande ahore­mbaa ti barasu ni, akere ka ba yo yarada nahɔrɛ su, dama wɔ fa i Awiɛwiɛ Casi n ama bu, kabo i yo fa maari yɛrɛ mmɔɔ ni. ");
INSERT INTO cko_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Nyɛmɛ dɔ, yɛrɛ ni bɛrɛ la má kpakpaaki­nu lɛɛ, dama yarada n bo ba yo i n dɛɛ ti, wɔ ŋmisi ayi satiɛ kɛrɛ bo i wo bu ahore su ni. ");
INSERT INTO cko_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Kisa, nzu ti ye am koro ka am yo Nyɛmɛ na am niɛ a, ye am susɔ yarada­yo­fɔm sɔɔri bo ya nam, ni yɛrɛ ni ya tii akoro asɔ má i a? ");
INSERT INTO cko_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ai. Yɛrɛ ayo yarada ka ya Mibiɛ Yesu ahɔrɔma n dɛɛ ti, ye ya nya tii­de a, nyini ma bɛrɛ gusu nya tii­de a.” ");
INSERT INTO cko_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Na minɛm kɛrɛ atɔ amuna, na bu ti kabo Banabasi ni Pɔɔlu sukan kere bu fa kɔ alekutura sa barasu barasum bo Nyɛmɛ ma bu koro yo maari minɛm bo bu ti má Yuda­fɔm ni. ");
INSERT INTO cko_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Saŋga bo bu jɔjɔ wieeri ni, na Yakobo gusu ayasu ajɔjɔ. I ŋa, “M ninbaam, am ti fɛn. ");
INSERT INTO cko_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simon ateŋge ya su kabo Nyɛmɛ ni i tii adu mɔ akere ka i cɛcɛ wo minɛm bo bu ti má Yuda­fɔm nu ni, ni kabo wɔ yi bu nbem afa bu ayo i dɛɛ minɛm ni. ");
INSERT INTO cko_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Nyɛmɛ nɔaniɛ kan­fɔm dɛɛ nɔaniɛ n bo bu yo seeri n ni ahinm n kɛrɛ ti kun wɔ, dama bu kɛrɛɛri ka, ");
INSERT INTO cko_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Micɛra n ŋa, ‘Nyini sin, m káaki ba yɛ Fɛmɛ Davidi awuru n bo wɔ tɔ n su, na m tá i bɔnfɔ ni, na m yó i dɔŋgu. ");
INSERT INTO cko_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Adena daanfiɛm n bo ba ka n kɛrɛ bá kpini Mibiɛ busu, bɛrɛ la minɛm bo bu ti má Yuda­fɔm na ma fere bu ka bu ti m dɛɛm ni. Micɛra ni seeri sɔ a, ");
INSERT INTO cko_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","yiri bo i yo seeri dada kɛrɛ ka i yó i ni.’” ");
INSERT INTO cko_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Na Yakobo akaaki ase bu ka, “Mini dɛɛ sunsunni la ka, minɛm bo bu ti má Yuda­fɔm na bu suba Nyɛmɛ dɔ ni, wɔ yo má daka ka ya miɛ bu. ");
INSERT INTO cko_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ama, i ti ye ni ka ya kɛrɛ kadasi ma bu, na ya se bu ka, má bu di tiɛ niɛ, na má bu yo sakaraya, na má bu di niɛ bo ba kpiɛ má i kɔm, na má bu di niɛ mbunja. ");
INSERT INTO cko_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Dama ba du mɔ akan Moyisi nɔaniɛ kpamaa­wa n jɔrɛ ya nam saŋga, haari ni nyuma bu toko kan i kadasi miɛ n kɛrɛ su wɔ, na bu sukan i na sɔnɔ kɛrɛ ti bu tiɛntiɛn­bunɔɔ sɔɔm nu Ŋumi­yi cɛɛn kɛrɛ.” ");
INSERT INTO cko_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Dɔ na Yesu jaramasam ni, ni nkpiɛn­kpiɛnm ni, ni Kristo jama n kɛrɛ afa sɛsɛ­su asoro su ka bu yi bu nu nbem, na bu sunma bu ni Pɔɔlu, ni Banabasi Antiyoki miɛ kpiri n nu, bɛrɛ la Yudasi bo bu fere i ka Basabasi ni, ni Silasi. Nyini minɛ nnyɔm kɛrɛ ti Kristo jama n mɔ­fɔm wɔ. ");
INSERT INTO cko_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Na ba kɛrɛ kadasi ama bu ka bu fa kɔ. Kɛrɛɛ­wa n la ka, “Yɛrɛ am ninbaam, ni Kristo jaramasam, ni nkpiɛn­kpiɛnm ni subisa am dɔŋgu, ambɛrɛ bo am ti má Yuda­fɔm na am wo Antiyoki ni, ni bo bu wo Siriya ni Silisiya dɛɛ awɔrɛm nu ni. ");
INSERT INTO cko_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Ya ti ka ya nbem afite ya nu fɛn aba am dɔ, aba akan jɔrɛ nbem akere am bo wɔ miɛ am, na wɔ yo am sunsunni agaya. Yɛrɛ ni ya tii asunma má bu. ");
INSERT INTO cko_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Nyini ti, ye ya kɛrɛ atana asɛsɛ su, asoro su ayi minɛm asunma bu ni ya danfo kpam Banabasi ni Pɔɔlu am dɔ. ");
INSERT INTO cko_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Bɛrɛ ye ba fa bu ŋgɔɔ ama ya Mibiɛ Yesu Kristo dɛɛ ti n a. ");
INSERT INTO cko_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Nyini ti, ya súsunma Yudasi ni Silasi am dɔ, na bɛrɛ ni bu tii bá teke bu nɔɔ, na bu kán jɔrɛ kɛrɛ bo i wo kadasi n nu kere am. ");
INSERT INTO cko_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Kabo ya ni Awiɛwiɛ Casi n dɛɛ ayo kun, na ya soro su lɛɛ, ka ya sɔ má am sɔɔri nɔnɔɔri be, sin ahin dekem bo wɔ yo daka ka am yo bu ni. ");
INSERT INTO cko_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Má am di tiɛ niɛ, má am di niɛ mbunja, má am di niɛ bo ba kpiɛ má i kɔm, na má am yo sakaraya. Nzɛn am tara am ŋu na am ayo má ahin sam ni, i yó kpa ma am. Tɔ, ya ka saŋga lɛɛ.” ");
INSERT INTO cko_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Na minɛm bo bu sunmaari bu n akɔ aju Antiyoki. Bu kɔ juuri ni, na ba nya atiɛn yarada­yo­fɔm kɛrɛ nɔɔ, na ba fa kadasi n ama bu. ");
INSERT INTO cko_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Saŋga bo bu kaanri kadasi n wieeri ni, na bu ahore ajɔ, na wɔ kaaki ama bu ahoresi. ");
INSERT INTO cko_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Na Yudasi, ni Silasi bo bɛrɛ ni bu tii ti Nyɛmɛ nɔaniɛ kan­fɔm ni, akan Nyɛmɛ jɔrɛ beberebe akere bu, na bu ahore asi, na wɔ buka bu faŋga. ");
INSERT INTO cko_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Na ba wo dɔ acɛ, na yarada­yo­fɔm n akaari bu ni ahoreda, na ba kpie bu nyi akɔ bɛrɛ n bo bu sunmaari bu n dɔ.  ");
INSERT INTO cko_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Ama, Silasi ase ka i ka bu dɔ. ");
INSERT INTO cko_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Ama, na Pɔɔlu ni Banabasi aka Antiyoki, na bu ni bu beŋgu dɔŋgu akan na ba kere minɛm Mibiɛ n nɔaniɛ ni. ");
INSERT INTO cko_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Tɔ, fa kɔ saŋga su, na Pɔɔlu ase Banabasi ka, “Ma ya kpie ya nyi kɔ miɛm kɛrɛ bo ya kaanri Mibiɛ n jɔrɛ kereeri bu n su, na ya kɔ niɛ kabo ya ninbaam ti barasu.” ");
INSERT INTO cko_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Má Banabasi koro ka bu fa Yohane bo bu kaaki fere i ka Marako n na bu kɛrɛ kɔ ɔ, ");
INSERT INTO cko_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","ama, na Pɔɔlu akete ka i sú má bu su, dama saŋga bo bu wo Pamfiliya awɔrɛ n nu ni, i ŋmati yakiiri bu wɔ, wɔ su má bu su abuka má bu ni juma ni. ");
INSERT INTO cko_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Dɔ na akuruwa bambaka aba bu afiɛn, na ba kpaaki ayaki bu beŋgu, na Banabasi afa Marako abuka i ŋu su, na ba fa lee bambaka akɔ Sipurusi asiɛn n su, ");
INSERT INTO cko_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","na Pɔɔlu gusu afa Silasi ka i su i su, na yarada­yo­fɔm n atiɛn bu nɔɔ asere Nyɛmɛ ama bu, ka bu di Mibiɛ n ahɔrɔma. ");
INSERT INTO cko_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Na wɔ kɔ abara ayɛ Siriya, ni Silisiya awɔrɛm n nu, na wɔ ma Kristo jama n ahoresi. ");
INSERT INTO cko_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Na Pɔɔlu anati haari na wɔ kɔ aju Dɛrɛbi, ni Lisitira miɛ kpirim n nu, sɔnɔ be woori dɔ, i ti Kristo susu­fɔ ɔ, bu fere i ka Timoti. I ni ti Yuda­fɔ bara bo wɔ yo Kristo yarada wɔ, ama, na i si ti Giriki­fɔ. ");
INSERT INTO cko_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Na yarada­yo­fɔm bo bu woori Lisitira ni Ikoniyom miɛ kpirim n nu n kɛrɛ ase ka Timoti ti sɔnɔ kpa a. ");
INSERT INTO cko_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pɔɔlu koroori ka i fa Timoti buka i ŋu su wɔ, na bu sunati, na wɔ wura i kɛnkɛnnɛ. Má deke be dɛɛ ti a, ama, Yuda­fɔm bo bu woori dɔ n dɛɛ ti, dama bu kɛrɛ si ka Timoti si ti Giriki­fɔ ɔ. ");
INSERT INTO cko_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Na ba nati miɛ miɛm su, na ba kan akere yarada­yo­fɔm fa kɔ jɔrɛ n kɛrɛ bo Yesu jaramasam, ni nkpiɛn­kpiɛnm bo bu wo Yɛrusalem miɛ kpiri n nu n asɛsɛ su asoro su ka bu yo i n su. Na ba se bu ka bu su nyini atinm su nyunyumi. ");
INSERT INTO cko_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Nyini ti, na Kristo jamam n anya faŋga, na bu yarada ayo bii­wa abuka su, na bu sunya minɛm subuka su ale kɛrɛ bo i cin. ");
INSERT INTO cko_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Na ba fa Firigiya, ni Galatiya dɛɛ awɔrɛ n nu asin, dama Awiɛwiɛ Casi n ama má bu atin na bu kan Nyɛmɛ jɔrɛ n Esiya dɛɛ awɔrɛ n nu. ");
INSERT INTO cko_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Saŋga bo bu kɔ juuri Masiya dɛɛ awɔrɛ awieeri ni, má bu koroori ka bu wura Bitiniya dɛɛ awɔrɛ n nu wɔ, ama, Yesu dɛɛ Awiɛwiɛ n asoro má bu su ka bu wura dɔ. ");
INSERT INTO cko_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Nyini ti, na ba fa Masiya awɔrɛ n nu, na ba sin akɔ miɛ kpiri be bo bu fere i ka Tɔrasi n nu. ");
INSERT INTO cko_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Nyini cɛɛn n kɔŋguɛ, na Pɔɔlu aŋu deke be ka alɛlɛ nu dɛɛ su, ka sɔnɔ be wo Makɛdoniya awɔrɛ n nu, jina susere i, i ŋa, “Jande, bra Makɛdoniya fɛn na a ba buka ya.” ");
INSERT INTO cko_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pɔɔlu ŋuuri nyini deke n ka alɛlɛ nu n dɛɛ ti, ya kaba yoori siriya a, na ya kɔ Makɛdoniya, dama ya si ka Nyɛmɛ ye wɔ se ka ya kɔ dɔ na ya kɔ kan i labari kpa n jɔrɛ kere minɛm n bo bu wo dɔ n a. ");
INSERT INTO cko_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Na ya fa lee bambaka afite Tɔrasi miɛ kpiri n nu akpiɛ akɔ aju miɛ be bo i wo lui bambaka be su, bu fere nyini lui n ka Samotarase. I alecin fɔfɔrɛ na ya kɔ aju miɛ kpiri n bo bu fere i ka Nɛpolisi n su. ");
INSERT INTO cko_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Na ya fite bɛrɛ akɔ miɛ kpiri be bo bu fere i ka Filipiya n su, yiri ti Makɛdoniya awɔrɛ n nyini bue n miɛm kɛrɛ tii a. Roma­fɔm niɛ i su a. Na ya yo le­nnyɔ dɔ. ");
INSERT INTO cko_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Na Ŋumi­yi cɛɛn ni, na ya fite miɛ n nu akɔ kunma nu, dɔ ye ya sunsun ka ya kɔ ŋu ka deke bo Yuda­fɔm n tiɛn bu nɔɔ sere Nyɛmɛ a. Na ya tana, na ya ni nbaram bo ba tiɛn bu nɔɔ n abo anzama. ");
INSERT INTO cko_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Bara be woori bu nu, bu fere i ka Lidiya, i fite miɛ kpiri be bo bu fere i ka Tiyatira n su wɔ, i tɔ sanvuin kpakpam bo i la gɔ, i ti bara bo i su Nyɛmɛ wɔ, na Nyɛmɛ ateke i sunsunni, na wɔ so i sui nyunyumi, na wɔ ti kabo Pɔɔlu suse ni. ");
INSERT INTO cko_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Na ba biɛ i ni i dika­fɔm kɛrɛ Nyɛmɛ nzue, na wɔ sere ya jande ka, “Nzɛn am asoro su ka ma yo Mibiɛ n yarada nahɔrɛ su, am ba wo m dika.” I yoori ya awaraye n dɛɛ ti, na ya soro su. ");
INSERT INTO cko_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Cɛɛn n be sɔ ɔ, ya sukɔ deke bo Yuda­fɔm n tiɛn bu nɔɔ sere Nyɛmɛ ni, na ya ni suŋguru be ayɛ, i ti afani wɔ, ajini wo i ŋu, na i nati yi munzue. Nyini dɛɛ ti, na i to­fɔm anya ŋwaa beberebe afite i munzue yi n nu. ");
INSERT INTO cko_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Na i nati susu ya ni Pɔɔlu su, na i sutiɛn suse ka, “Ahin minɛm ti Nyɛmɛ Kpiri n dɛɛ amusui­su­fɔm wɔ. Bɛrɛ kere am kabo am yo na am nya tii­de a.” ");
INSERT INTO cko_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","I nati yoori sɔ ɔ, cɛɛn n kɛrɛ cɛɛn, haari na yaa aba ati Pɔɔlu, na wɔ kaaki aniɛ i, na wɔ tiɛn ajini n bo i wo suŋguru n ŋu n na wɔ se i ka, “Yesu Kristo dɛɛ duma n dɛɛ yiko nu, fite yaki i.” Kpeŋga, na ajini n afite ayaki i. ");
INSERT INTO cko_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Tɔ, saŋga bo afani n to­fɔm ŋuuri ka bu koro nya má ŋwaa fite má i n dɔ kun ni, na ba tara Pɔɔlu ni Silasi, na ba cin bu akɔ miɛ n kunnu afa bu awura yiko­fɔm saa nu. ");
INSERT INTO cko_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Bu faari bu kɔ juuri jɔrɛ­di­fɔm nkpiɛn­kpiɛnm dɔ, na ba se ka, “Ahin minɛm ni ti Yuda­fɔm wɔ, na bu nati sukpini jɔrɛ ya miɛ n nu. ");
INSERT INTO cko_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Bu nati sukere sa­yoo­wam bo ya dɛɛ nɔaniɛ kpamaa­wa atin n su, wɔ yo má daka ka ya de bu, wara ya su bu su, dama ya ti Roma­fɔm wɔ.” ");
INSERT INTO cko_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Na jama n kɛrɛ atɔ Pɔɔlu ni Silasi ŋu ni jɔrɛ ŋgbɛɛn­ŋgbɛɛn. Na jɔrɛ­di­fɔ nkpiɛn­kpiɛnm ama ba yi Pɔɔlu ni Silasi suturam, na ba ma nɔɔ ka bu fin bu ŋgbere. ");
INSERT INTO cko_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Nyini dɛɛ ti, na ba bo bu nyunyumi, na ba kɔ anyi bu dan­saraka, na ba ma dan­saraka niɛ­fɔ n nɔɔ ka i tu anɔ n na i niɛ bu dika nyunyumi. ");
INSERT INTO cko_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Dan­saraka niɛ­fɔ n deeri nyini nɔaniɛ n wieeri sɔ ni, na wɔ fa bu akɔ awura dan­saraka n sɔɔ n bo i wo mɔ n nu, na wɔ bo bu tobarim. ");
INSERT INTO cko_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Na fa kɔ kɔŋguɛ jinanjin saŋga, na Pɔɔlu ni Silasi susere Nyɛmɛ, na bu sudi jue kansi i, na bu beŋgu dan­sarakam ni suso bu sui suti. ");
INSERT INTO cko_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Jina n nu bɛrɛ, na asiɛn n akpisi agaya, haari na dan­saraka sɔɔ n jaafa bo bu fa boori i bu n kɛrɛ akpisi, na anɔm n kɛrɛ ateke, na tobari n kɛrɛ n bo bu fa boori bu n akporo atɔtɔ. ");
INSERT INTO cko_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Na dan­saraka niɛ­fɔ n abo nu ayasu, na wɔ ŋu ka dan­saraka sɔɔ anɔm n kɛrɛ ateke, i sunsun ka dan­sarakam kɛrɛ aŋmati asandi wɔ, nyini ti, na wɔ cin awɔrɔ i takobe ka i kun i ŋu wɔ. ");
INSERT INTO cko_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ama, na Pɔɔlu atiɛn kpa ase ka, “Má a ma u ŋu mandim. Ya kɛrɛ wo fɛn.” ");
INSERT INTO cko_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Na dan­saraka niɛ­fɔ n afere ka bu fa sin bra, na wɔ bereki awura Pɔɔlu ni Silasi sɔɔ n nu, na sɛrɛ ati i, na i ŋuniɛ subobo i, na wɔ kɔ akutu bu jaa bu. ");
INSERT INTO cko_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Dɔ na wɔ fa bu afite, na wɔ bisa bu ka, “M mibiɛm, m yo sɛ ye m nya tii­de a?” ");
INSERT INTO cko_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Na ba bɔ i nu ka, “Yo Mibiɛ Yesu yarada, na a nyá tii­de, wɔrɔ ni u dika­fɔm kɛrɛ.” ");
INSERT INTO cko_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Na ba kan Mibiɛ n nɔaniɛ n akere i, i ni bo bu wo i dika n kɛrɛ. ");
INSERT INTO cko_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Nyini cɛɛn n kɔŋguɛ n kɛrɛ, na dan­saraka niɛ­fɔ n afa Pɔɔlu ni Silasi akɔ, na wɔ kɔ aŋmisi bu kani n kɛrɛ, na ba kaba abiɛ yiri ni i dika­fɔm kɛrɛ Nyɛmɛ nzue. ");
INSERT INTO cko_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Dɔ na wɔ fa bu akɔ i dika, na wɔ ma bu diire, na ba di. Na yiri ni i dika­fɔm kɛrɛ ahore ajɔ agaya ka ba yo Nyɛmɛ yarada n dɛɛ ti. ");
INSERT INTO cko_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Alecin ŋgarama, na jɔrɛ­di­fɔm n asunma npulisim ka bu kɔ se dan­saraka niɛ­fɔ n ka i yaki nyini minɛm nu ji na bu kɔ. ");
INSERT INTO cko_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Nyini ti, na dan­saraka niɛ­fɔ n asere Pɔɔlu ka, “Jɔrɛ­di­fɔm n ama nɔɔ ka ya yaki am na am kɔ. Nyini ti, am kɔ ni ahoreda.” ");
INSERT INTO cko_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ama, na Pɔɔlu ase npulisim ni ka, “Haari ni bo ya ti Roma­fɔm ni, ba di má ya jɔrɛ aŋu má ya ŋgasi be, na ba bo ya jama n kɛrɛ nyunu, na ba nyi ya dan­saraka. Ye kisa bu sukoro ka bu fiɛ yi ya ji bɛnlɛ, nzɛn sɛ? Nyini koro yo má, má ka bɛrɛ ni bu tii aba na bu ba yi ya ji.” ");
INSERT INTO cko_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Na npulisim n akɔ ase jɔrɛ­di­fɔm ni. Bu tiiri ka Pɔɔlu ni Silasi ti Roma­fɔm ni, na sɛrɛ ati bu. ");
INSERT INTO cko_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Nyini ti, na ba ba atara Pɔɔlu ni Silasi jaa, na ba nya ayi bu afite dan­saraka n nu, na ba sere bu jande ka bu fite miɛ n nu. ");
INSERT INTO cko_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Na ba fite dan­saraka sɔɔ n nu, na ba kaaki akɔ Lidiya dika, na ba kɔ aŋu yarada­yo­fɔm ni, na ba ma bu ahoresi, na ba nya afite miɛ n nu akɔ. ");
INSERT INTO cko_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Na Pɔɔlu ni Silasi afa asin Amfipolisi, ni Apoloniya miɛ kpirim su, na ba kɔ aju Tɛsalonika miɛ kpiri n nu. Yuda­fɔm tiɛntiɛn­bunɔɔ sɔɔ wo dɔ. ");
INSERT INTO cko_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Nyini ti, kabo i nati yo ni, na Pɔɔlu awura bu tiɛntiɛn­bunɔɔ sɔɔ n nu akɔ aju Ŋumi­yi cɛɛn nsan, na i ni bɛrɛ subo anzama fa kɔ Nyɛmɛ Jɔrɛ Kadasi n su, ");
INSERT INTO cko_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","na i sukan, na i suyi i bu kere bu, kabo wɔ yo daka ka Kristo Tii­de­fɔ n ba di wahara na i teŋge i yiwee nu ni. Na wɔ se bu ka, “Yiri Kristo Tii­de­fɔ n la Yesu n bo m kan i jɔrɛ kere am ni.” ");
INSERT INTO cko_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Na Yuda­fɔm nbem ade jɔrɛ n bo Pɔɔlu kaanri i ni, ni Giriki­fɔm beberebe bo bu su Nyɛmɛ ni, ni nbaram beberebe bo bu la anyunuyi ni, na bu kɛrɛ afa bu ŋu amata Pɔɔlu ni Silasi. ");
INSERT INTO cko_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ama, na Yuda­fɔm n asi bu kɔrɛ agaya, na ba fere minɛm ŋgbɛɛn­ŋgbɛɛn nbem bo bu la má kpɛrɛ na bu nati tana gɔɔsu ni, na ba tiɛn jama dɔŋgu nɔɔ. Na ba kpisi miɛ ni, na ba kɔ sɔnɔ be bo bu fere i ka Jason n dika, akɔ ajina i dika anɔ nu, deke bo Pɔɔlu ni Silasi wo ni, na bu sutiɛntiɛn ka i yi bu ma bu na bu fa bu kɔ jama n nu. ");
INSERT INTO cko_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ama, bu kɔ niɛniɛɛri na ba ŋu má bu ni, na ba tara Jason ni yarada­yo­fɔ nbem acin bu afa bu akɔ miɛ n nu yiko­fɔm dɔ, na bu sutiɛn suse ka, “Ahin minɛm n bo ba saaki durunya n abara ayɛ ni, aba ya miɛ n nu fɛn, ");
INSERT INTO cko_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","haari Jason ade bu awura i dika. Ba kete Roma­fɔm fɛmɛ kpiri n nɔaniɛ n bo wɔ fa ama ka ya su i su ni, bu ŋa fɛmɛ be wo bɛrɛ bekun, bo bu fere i ka Yesu.” ");
INSERT INTO cko_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Bu seeri sɔ ni, na wɔ yɛ yiko­fɔm ni jama n ahore su. ");
INSERT INTO cko_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Na yiko­fɔm n akpiɛ Jason ni i beŋgum kɔbuka, na ba tɔ kaari, na ba nya ayaki bu aji. ");
INSERT INTO cko_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Nyini cɛɛn n kɔŋguɛ n kɛrɛ, na yarada­yo­fɔm n ase Pɔɔlu ni Silasi atin nu akɔ aju miɛ kpiri be bo bu fere i ka Bɛriya n su. Bu kɔ juuri dɔ n na ba kɔ awura Yuda­fɔm tiɛntiɛn­bunɔɔ sɔɔ n nu. ");
INSERT INTO cko_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Dɔ dɛɛ Yuda­fɔm joko n ti kpa tara bɛrɛ n bo bu wo Tɛsalonika miɛ kpiri n nu ni. Bu soori bu sui wɔ ni nahɔrɛ su, na ba ti keree­wa n bo bu kere bu ni, na ale kɛrɛ bo i cin, bɛrɛ ni bu tii kan Nyɛmɛ Jɔrɛ Kadasi n wɔ, na bu niɛ ka, deke n bo Pɔɔlu sukere bu n ti nahɔrɛ wɔ, nzɛn i ti má nahɔrɛ. ");
INSERT INTO cko_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Na Yuda­fɔm ni dɔŋgu ayo yarada, fa saŋga ni Giriki­fɔm beberebe, nbaram bo bu la anyunuyi n ni nbiɛsɔm. ");
INSERT INTO cko_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ama, saŋga bo Yuda­fɔm bo bu wo Tɛsalonika n tiiri ka Pɔɔlu akɔ akan Nyɛmɛ jɔrɛ Bɛriya dɔ gusu ni, na ba ba dɔ aba awura minɛm bu sin, na ba yɛ bu yaa su. ");
INSERT INTO cko_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Kpeŋga na yarada­yo­fɔm n ayo ndende afa Pɔɔlu akɔ ase haari tieku n nɔɔ su, ama, na Silasi ni Timoti yiri aka Bɛriya dɔ. ");
INSERT INTO cko_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Na minɛm n bo bu seeri Pɔɔlu atin nu ni, afa i akɔ aju haari miɛ kpiri be bo bu fere i ka Atensi n su. Bu kpieeri bu nyi sukɔ ni, na Pɔɔlu akaari bu ka bu kɔ se Silasi ni Timoti ka bu bra na bu ba tu i dɔ ndende. ");
INSERT INTO cko_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Saŋga bo Pɔɔlu wo Atensi miɛ kpiri n nu suŋminda Silasi ni Timoti ni, na i ahore asaaki agaya kabo i ŋuuri ka amɔɛm asunnu miɛ n nu ni. ");
INSERT INTO cko_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Nyini dɛɛ ti, na wɔ kɔ awura Yuda­fɔm tiɛntiɛn­bunɔɔ sɔɔ n nu, na i ni bɛrɛ, ni minɛm bo bu ti má Yuda­fɔm na bu su Nyɛmɛ ni, subo anzama. Na i sukɔ gɔɔsu cɛɛn n kɛrɛ cɛɛn, na i sukan kere minɛm bo bu wo dɔ ni. ");
INSERT INTO cko_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Sifɔm asɛsɛ nbem wo miɛ n nu, bu fere bu kun ka Epikurifɔm, na bu fere nyiŋga n ka Sitɔwa­fɔm, na bu suse akuruwa ni Pɔɔlu, na bu nbem abisa ka, “Ye ahin jɔrɛ beberebe­fɔ n ŋa sɛ wɔ lɛɛ?” Na bu nbem abɔ nu ka, “I jɔjɔ fa kɔ amɔɛ fɔfɔrɛ nbem jɔrɛ wɔ.” Deke bo i ti na bu seeri sɔ n la ka, Pɔɔlu sukan Yesu ni yiwee teŋge n su jɔrɛ wɔ. ");
INSERT INTO cko_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Na ba fa Pɔɔlu akɔ awɔrɛ be bo bu fere i ka Aropagɔsi na bu tiɛn bu nɔɔ di jɔrɛ n nu. Na ba se i ka, “A koro kere ya na ya ti ahin keree­wa fɔfɔrɛ n bo a sufa kere n bu? ");
INSERT INTO cko_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ahin keree­wa n bo a sukere i ni, ya si má i, ya koro ka a ma ya ti i bu wɔ.” ");
INSERT INTO cko_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Dama Atensi­fɔm ni wɔfɔm bo bu wo miɛ n nu n dɛɛ la ka, saŋga kɛrɛ bu sukan na bu suti keree­wa fɔfɔrɛm wɔ. ");
INSERT INTO cko_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Na Pɔɔlu ayasu ajina miɛ n nu tere­tere­fɔm n afiɛn, na wɔ se ka, “Ma ŋu kabo ambɛrɛ Atensi­fɔm su amɔɛm na am yo munzue sam ni anyum­boro. ");
INSERT INTO cko_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Dama kabo m nati bara yɛ niɛ yi kɔrɛsi ni, ma ŋu dekem bo am su bu ni, na ma ŋu bimbindi be bo am akɛrɛ su ka, ‘Nyɛmɛ n bo ya si má i n dɛɛ woo­biri lɛɛ.’ Tɔ, yiri n bo am su i na am si má i ni, yiri ye m kan i jɔrɛ kere am a. ");
INSERT INTO cko_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Nyɛmɛ bo i yiiri durunya n ni deke n kɛrɛ bo i wo nu ni, yiri ti aŋgoro ni asiɛŋgu kɛrɛ Mibiɛ a, i wura má amɔɛ sɔɔm bo adamande afa i saa ata bu n nu na i da. ");
INSERT INTO cko_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Sasu bekun, i fun má deke be bo i se adamande ka i yo ma i, dama yiri ni i tii ma adamande ŋgɔɔ ni ŋumi a, ni deke n kɛrɛ a. ");
INSERT INTO cko_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Yiri ma adamande n kɛrɛ fite sɔnɔ kun busu n nu wɔ, na wɔ ma ba tɛrɛ ade durunya n kɛrɛ. Na wɔ nya akpama saŋga saŋga ama bu kɛrɛ, na wɔ kaaki akere bu kabo bu asiɛn nyaari ti. ");
INSERT INTO cko_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Deke n bo i ti na i yoori sɔ n la ka, bu bá turiŋgi niɛniɛ i busu na beni bu ŋú i. Ama, haari ni nyini mmɔɔ ni, i wo má dede ni yɛrɛ kɛrɛ be. ");
INSERT INTO cko_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Dama yiri dɛɛ ti ye ya la ŋgɔɔ ye ya wo bɛrɛ ye ya nati a. Kabo am jue­di­fɔ nbem gusu ase ni, ka, ‘Yɛrɛ mmɔɔ ti i nbaam wɔ.’ ");
INSERT INTO cko_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Nyini dɛɛ ti, kabo ya nya ti Nyɛmɛ nbaam ni, má ya sunsun ka i woo­wa ti ka sika, wara jɛtɛ, wara yabuɛ nyunyumi, wara deke be bo juma si­fɔm afa bu alecira ayo i. ");
INSERT INTO cko_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Dawa saŋga ni, Nyɛmɛ ayo aniɛ má minɛm fa kɔ bu sa­yoo­wam su, dama bu yo si má. Ama, kisa, wɔ ma nɔɔ ka sɔnɔ kɛrɛ bo i wo deke kɛrɛ kaaki i wo na i yaki i satiɛ. ");
INSERT INTO cko_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Dama wɔ du mɔ akpama cɛɛn na wɔ yi sɔnɔ be ka i bá di durunya n nu­fɔm jɔrɛ ni nahɔrɛ. Deke bo i kere ya kɛrɛ ka i bá yo sɔ n la bo i teŋgeeri i yiwee n nu ni.” ");
INSERT INTO cko_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Saŋga bo bu tiiri ka Pɔɔlu sukan fa kɔ yiwee teŋge n su n jɔrɛ ni, na bu nbem ayo i anzasi. Ama, na bu nbem ase ka, “Ya koro ka a kaaki ba kan ahin jɔrɛ n bekun na ya ti.” ");
INSERT INTO cko_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Dɔ na Pɔɔlu akɔ ayaki bu. ");
INSERT INTO cko_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Na bu nbem asu i su na ba yo yarada. Bɛrɛ la Diyonusiyɔsi, i ti Aropagɔsi­fɔm n nu kun wɔ, ni bara be bo bu fere i ka Damarisi ni, ni minɛm nbem. ");
INSERT INTO cko_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Nyini sin, na Pɔɔlu afite Atensi miɛ kpiri n nu, na wɔ kɔ Kɔrinto miɛ kpiri n nu. ");
INSERT INTO cko_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Na wɔ kɔ atu Yuda­fɔ sɔnɔ be dɔ, bu fere i ka Akuyila, i ti Pontusi asiɛn su fɔ ɔ, i ni i yi, bu fere i ka Pirisila, bu fiteeri Itali asiɛn su baari a, wɔ nya cɛ má ye Pɔɔlu ŋuuri bu n a, dama Roma­fɔm fɛmɛ kpiri n bo bu fere i ka Kalodisi n ama nɔɔ ka Yuda­fɔm kɛrɛ fite i asiɛn n su. Nyini dɛɛ ti, na Pɔɔlu akɔ ka i kɔ niɛ bu busu, ");
INSERT INTO cko_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","na wɔ kɔ aseke bu wɔfɔ, na i ni bɛrɛ asaŋga ayo juma, dama bu kɛrɛ ti jɛrɛkɛm ni tani wu­fɔm wɔ. ");
INSERT INTO cko_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Na Ŋumi­yi cɛɛn kɛrɛ, i suwura bu tiɛntiɛn­bunɔɔ sɔɔ n nu, na i subo anzama ni bɛrɛ, ni Giriki­fɔm kɛrɛ, adena i kaaki bu sunsunni na bu yo yarada. ");
INSERT INTO cko_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Saŋga bo Silasi ni Timoti fiteeri Makɛdoniya awɔrɛ n nu ba juuri ni, Pɔɔlu nyunu aboro ni labari kpa n jɔrɛ kan su ŋgumi wɔ. Na i sukere Yuda­fɔm n ka, Yesu ti Kristo n a, Tii­de­fɔ n bo Nyɛmɛ ase ka i súnma i ni. ");
INSERT INTO cko_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ama, Yuda­fɔm n keteeri i nɔaniɛ n wɔ, na ba kpiɛ i nzukɔ. Nyini dɛɛ ti, na wɔ kpɔnkpɔn i sutura wuraa­wa tuturi agɔ bu ŋu, na wɔ se bu ka, “Ambɛrɛ, nzɛn am nya má tii­de, i ti am dɛɛ jɔrɛ wɔ, má m dɛɛ. Fite kisa fa kɔ, m kɔ́ minɛm bo bu ti má Yuda­fɔm n dɔ ɔ lɛɛ.” ");
INSERT INTO cko_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Dɔ na Pɔɔlu afite tiɛntiɛn­bunɔɔ sɔɔ n nu ayaki bu, na wɔ kɔ sɔnɔ be dika, i ti má Yuda­fɔ, ama, i su Nyɛmɛ wɔ, bu fere i ka, Titosi Jusitosi, i dika n mata tiɛntiɛn­bunɔɔ sɔɔ n wɔ. ");
INSERT INTO cko_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Na sɔnɔ n be bo bu fere i ka Kirisipusi na i ti bu tiɛntiɛn­bunɔɔ sɔɔ n kpiɛn n ayo Mibiɛ n yarada, i ni i dika­fɔm kɛrɛ, na Kɔrinto­fɔm dɔŋgu bo bu tiiri labari n bo Pɔɔlu kaanri i ni, na bu kɛrɛ ayo yarada, na ba biɛ bu Nyɛmɛ nzue. ");
INSERT INTO cko_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Cɛɛn n be kɔŋguɛ sɔ ɔ, na Mibiɛ n ajɔjɔ Pɔɔlu dɔ ka alɛlɛ nu dɛɛ su, i ŋa, “Má a soro sɛrɛ, ama, kɔ su na a sukan labari kpa n kere bu, má a mɔ u nɔɔ, ");
INSERT INTO cko_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","dama m wo u dɔ. Be koro fa má i saa kan má u na i yo u pui. Niɛ fɛn, m la minɛ beberebe miɛ n nu fɛn bo bu ti m dɛɛ.” ");
INSERT INTO cko_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Na wɔ wo bu dɔ akɔ aju afɔ kun ni kpaaki nu, na i sukere bu Nyɛmɛ nɔaniɛ ni. ");
INSERT INTO cko_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Tɔ, bu wo bɛrɛ na sɔnɔ n be bo bu fere i ka Galiyo n aba adi Akaya awɔrɛ n nu gomina. Nyini saŋga n na Yuda­fɔm kɛrɛ nɔɔ ayo kun, na ba kete Pɔɔlu ŋu na ba fa i akɔ jɔrɛ dii­biri. ");
INSERT INTO cko_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Na ba se ka, “Ahin sɔnɔ ni suboro i nyi sukere minɛm keree­wa bo i wo i ŋgumi ni Nyɛmɛ nɔaniɛ kpamaa­wa ni.” ");
INSERT INTO cko_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Saŋga bo Pɔɔlu tekeeri i nɔɔ ka i jɔjɔ ni, na Gomina Galiyo ase Yuda­fɔm ka, “Nzɛn má i ti ka wɔ yo satiɛ be, wara wɔ do ŋgasi be, ye am sujaraki i a, má m ti i bu ma am. ");
INSERT INTO cko_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ama, kabo i nya ti bisaa­wam fa kɔ nɔaniɛm, ni dumam, ni am dɛɛ nɔaniɛ kpamaa­wam n su ni, ambɛrɛ ni am tii kɔ yo i dɔŋgu. Mini, m koro di má nyini jɔrɛ ni.” ");
INSERT INTO cko_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Na wɔ ma ba fɔn ayi bu afite jɔrɛ dii­biri sɔɔ n nu. ");
INSERT INTO cko_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Na bu kɛrɛ akaba atɔ sɔnɔ n bo bu fere i ka Sositeni n ŋu na bu subo i wɔ, jɔrɛ dii­biri n nyunu bɛrɛ, yiri ti tiɛntiɛn­bunɔɔ sɔɔ nkpiɛn a. Ama, Gomina Galiyo cɛcɛ awo má nyini n be nu. ");
INSERT INTO cko_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Na Pɔɔlu awo Kɔrinto miɛ kpiri n nu acɛ, nyini sin na wɔ kaari yarada­yo­fɔm ni na i ni Pirisila ni Akuyila akɔ. Bu kɔ juuri miɛ kpiri n bo bu fere i ka Kenciriya n su ni, na Pɔɔlu ayi i tii dɔ, dama wɔ du mɔ atan ndiɛ n dɛɛ ti. Na ba wura lee bambaka be nu dɔ, i sukɔ Siriya awɔrɛ n nu. ");
INSERT INTO cko_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Bu kɔ juuri Ɛfɛso miɛ kpiri n nu ni, na wɔ yaki Pirisila ni Akuyila dɔ, ama, na yiri akɔ awura Yuda­fɔm tiɛntiɛn­bunɔɔ sɔɔ n nu, na i ni bɛrɛ abo anzama fa kɔ labari kpa n su. ");
INSERT INTO cko_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Na ba sere i ka i wo bu dɔ le­nnyɔ, ama, wɔ soro má su. ");
INSERT INTO cko_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Na wɔ sere bu atin na wɔ kaari bu, na wɔ se bu ka, “Nzɛn Nyɛmɛ maari m atin, m kpíe m nyi ba am dɔ.” Na wɔ yasu Ɛfɛso dɔ, na wɔ fa lee bambaka akɔ. ");
INSERT INTO cko_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Saŋga bo i kɔ juuri Sizariya miɛ kpiri n nu ni, na wɔ sin akɔ Yɛrusalem miɛ kpiri n nu akɔ ayo Kristo jama n ansɛ, na wɔ nya kɔ Antiyoki miɛ kpiri n nu. ");
INSERT INTO cko_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Na wɔ yo le­nnyɔ dɔ, na wɔ nya akaaki ayasu dɔ, abara ayɛ miɛ miɛm bo bu wo Galatiya, ni Firigiya dɛɛ awɔrɛm n nu n kɛrɛ, na wɔ ma yarada­yo­fɔm n kɛrɛ ahoresi. ");
INSERT INTO cko_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Nyini saŋga ni, Yuda­fɔ sɔnɔ be aba Ɛfɛso miɛ kpiri n nu, bu fere i ka Apolosi, bu wuuri i Alɛkizanderiya miɛ kpiri n nu wɔ. I yo la si fa kɔ Nyɛmɛ Jɔrɛ Kadasi n su, na i koro jɔjɔ nahɔrɛ su. ");
INSERT INTO cko_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Ba du mɔ akere i keree­wam fa kɔ Mibiɛ n dɛɛ atin su, na i ahore abi na i ŋuniɛ ti nyakanyaka, na i sukan na i kere minɛm Yesu jɔrɛ nahɔrɛ su. Ama, i si má nzue biɛɛ­wa be, má ka Yohane dɛɛ Nyɛmɛ nzue biɛɛ­wa ni ŋgumi. ");
INSERT INTO cko_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Na wɔ bo i bu na i sukan i ni ahoresi Yuda­fɔm tiɛntiɛn­bunɔɔ sɔɔ n nu. Saŋga bo Pirisila ni Akuyila tiiri i keree­wam n sɔ ni, na ba fa i akɔ awuru, na ba kere i Nyɛmɛ atin n su jɔrɛ nyunyumi abuka su. ");
INSERT INTO cko_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Nyini sin, na Apolosi akoro ka i kɔ Akaya awɔrɛ n nu, na yarada­yo­fɔm ni bo bu wo Ɛfɛso n ama i ahoresi, na ba kɛrɛ kadasi ama bu ninbaam bo bu wo Akaya n ka bu de i wɔfɔ nyunyumi. Saŋga bo i kɔ juuri dɔ ni, na wɔ buka minɛm bo Nyɛmɛ dɛɛ ahɔrɔma n nu na ba yo yarada ni. ");
INSERT INTO cko_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Na Yuda­fɔm seeri akuruwa n dɛɛ ti, na wɔ fa Nyɛmɛ Jɔrɛ Kadasi n na wɔ kan ayi bu fieo fieo jama n kɛrɛ nyunu, ka, Yesu ti Kristo n a, Tii­de­fɔ n bo Nyɛmɛ ase ka i súnma i ni. ");
INSERT INTO cko_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Saŋga bo Apolosi toko wo Kɔrinto miɛ kpiri n nu ni, na Pɔɔlu anati abara ayɛ dɔ dɛɛ ahɛmɛ miɛ miɛm n kɛrɛ su, haari na wɔ kɔ aju Ɛfɛso miɛ kpiri n nu. Dɔ na wɔ kɔ atu Yesu susu­fɔ nbem, ");
INSERT INTO cko_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","na wɔ bisa bu ka, “Saŋga bo am yoori yarada ni, Awiɛwiɛ Casi n awura am ŋu?” Na ba bɔ i nu ka, “Ai, ya nya ti má ka Awiɛwiɛ Casi wo bɛrɛ mmɔɔ.” ");
INSERT INTO cko_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Dɔ na Pɔɔlu abisa bu ka, “Ye nzu Nyɛmɛ nzue ye bu biɛɛri am a?” Na ba bɔ i nu ka, “Bu biɛɛri ya Yohane dɛɛ nzue biɛɛ­wa n wɔ.” ");
INSERT INTO cko_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Na Pɔɔlu ase bu ka, “Yohane nzue biɛɛ­wa n bu la ka, minɛ kaaki bu wo na bu yaki bu satiɛ wɔ. Na wɔ se minɛm n ka bu yo sɔnɔ n bo i wo i sin suba n yarada, yiri la Yesu.” ");
INSERT INTO cko_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Bu tiiri nyini n sɔ wieeri ni, na ba biɛ bu Nyɛmɛ nzue ya Mibiɛ Yesu n dɛɛ duma nu. ");
INSERT INTO cko_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Na Pɔɔlu afa i saa anana bu ŋu, na Awiɛwiɛ Casi n awura bu ŋu. Na ba jɔjɔ aniɛ barasu barasu nbem, na ba kan Nyɛmɛ nɔaniɛ akere minɛm. ");
INSERT INTO cko_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Bu kɛrɛ kɔ yasuuri nbiɛsɔm buru ni nnyɔ ɔ. ");
INSERT INTO cko_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Na wɔ wo dɔ haari sara nsan, na Ŋumi­yi cɛɛn kɛrɛ, na i suwura bu tiɛntiɛn­bunɔɔ sɔɔ n nu, na i sukan kere bu fa kɔ Nyɛmɛ fɛmɛya n su ni ahoresi, na i ni bɛrɛ subo anzama, na wɔ boro i nyi akere bu ka, kabo i kan n ti nahɔrɛ wɔ. ");
INSERT INTO cko_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ama, na bu nbem afa ahore­mbaa kekereke, na ba kete ka bu yo má yarada. Na ba jɔjɔ jɔrɛ tiɛ fa kɔ Mibiɛ n dɛɛ atin n su, jama n kɛrɛ nyunu. Nyini ti, na Pɔɔlu ayaki bu, na wɔ fa yarada­yo­fɔm n afite akɔ Tiranusi tiɛntiɛn­bunɔɔ sɔɔ bambaka n nu, na i ni bɛrɛ sutiɛn bu nɔɔ subo anzama, fa kɔ Yesu dɛɛ atin n su cɛɛn n kɛrɛ cɛɛn. ");
INSERT INTO cko_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Pɔɔlu bitaari i sɔ ɔ, haari afɔ nnyɔ, na minɛm kɛrɛ bo bu wo Esiya dɛɛ awɔrɛ n nu n ati Mibiɛ n nɔaniɛ ni, bo bu ti Yuda­fɔm, ni bo bu ti má Yuda­fɔm n kɛrɛ. ");
INSERT INTO cko_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Na Nyɛmɛ ama Pɔɔlu ayo alekutura sam bo bu la má ŋusu. ");
INSERT INTO cko_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Haari na sanvuinm ni suturam kɛrɛ bo ba kan i ŋuniɛ, na bu fa kɔ nana tukpaki­fɔm ŋu, bu nya laifiɛ wɔ, na ajinim fite yaki minɛm bo bu wo bu ŋu ni. ");
INSERT INTO cko_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Na Yuda­fɔm nbem bo bɛrɛ gusu nati jeŋgbe fɔn yi ajinim fite minɛm ŋu ni, aboro bu nyi ka bu fa Yesu duma n fɔn yi ajinim. Bu ŋa, “Yesu n bo Pɔɔlu kan i jɔrɛ n dɛɛ duma nu, ye m se am ka am fite yaki sɔnɔ n a.” ");
INSERT INTO cko_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Yuda­fɔm minɛ nso nbem nati yo nyini sam n a. Bɛrɛ la Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm n kɛrɛ kpiɛn be bo bu fere i ka Sikeva n dɛɛ nbaa­biɛsɔm ni. ");
INSERT INTO cko_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ama, na ajini n ase bu ka, “M si Yesu, na m kaaki si Pɔɔlu, ama, ye ambɛrɛ la ŋma n wɔ?” ");
INSERT INTO cko_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Na sɔnɔ n bo ajini n wo i ŋu ni, atɔ bu ŋu na wɔ kunma bu kɛrɛ faŋga, na wɔ bo bu na wɔ ma bu mandim, na ba ŋmati afite i dika n nu bu bu ŋgbɛɛn. ");
INSERT INTO cko_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Saŋga bo Yuda­fɔm ni minɛm bo bu ti má Yuda­fɔm na bu wo Ɛfɛso miɛ kpiri n nu n kɛrɛ tiiri nyini sa n sɔ ni, na sɛrɛ ati bu, na ba kansi Mibiɛ Yesu n duma agaya. ");
INSERT INTO cko_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Na minɛ dɔŋgu bo ba yo yarada n afite ajina, na ba kan bu ŋgasim ni bu satiɛm kɛrɛ bo ba yo bu n akere jama ni. ");
INSERT INTO cko_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Na minɛ dɔŋgu bo bu nati yo boboyaya juma n afa bu boboyaya kadasim ni, na ba tiɛn bu nɔɔ jama n kɛrɛ nyunu, na ba yara bu kɛrɛ. Kadasim n kɛrɛ bo bu yaraari bu ni, i ŋwaa sunnu agaya, bu buuri i akunta, i kɛrɛ kɔ yasuuri bu dɛɛ jɛtɛ ŋwaa akpii aburu­nu wɔ. ");
INSERT INTO cko_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Nyini n dɛɛ ti, na minɛ beberebe ati Mibiɛ n nɔaniɛ ni, na wɔ sandi abara yɛ ni faŋga. ");
INSERT INTO cko_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Nyini n kɛrɛ sin, na Pɔɔlu afa sunsunni ka i kɔ Makɛdoniya ni Akaya dɛɛ awɔrɛm n nu, na i nya sin kɔ Yɛrusalem miɛ kpiri n nu. Na wɔ se ka, “Nzɛn m nya ŋuuri m natiiri n kɛrɛ nyaari, wɔ yo daka ka m kɔ́ Roma miɛ kpiri n nu gusu.” ");
INSERT INTO cko_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Na wɔ sunma i buka­fɔ nnyɔm ni, bɛrɛ la Timoti ni Irasitusi ka bu kɔ Makɛdoniya, na yiri aka Esiya dɛɛ awɔrɛ n nu, ayo le­nnyɔ. ");
INSERT INTO cko_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Nyini saŋga n ye Mibiɛ n atin n su su n ayo jɔrɛ agaya Ɛfɛso miɛ kpiri n nu n a. ");
INSERT INTO cko_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Jɛtɛ tunmi be yo wo dɔ, bu fere i ka Demetirɔsi, i fa jɛtɛ wɔ, na i fa yo sɔɔ kan kanm, bu ti ka amɔɛ n bo bu fere i ka Atɛmisi n wɔ, na i sufa tɔ ma minɛm. Na minɛm bo bu yo nyini juma n anya kpɛrɛ beberebe afite nu. ");
INSERT INTO cko_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Tɔ, na yiri Demetirɔsi afere minɛm bo bu yo nyini juma atiɛn bu nɔɔ, na wɔ se bu ka, “Njam, am si ka ya nya ya dɛɛ ajɛkɛ kɛrɛ fite ahin juma n bo ya yo i n nu wɔ e. ");
INSERT INTO cko_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Yiri Pɔɔlu ni, kisa, am aŋu i e, am ati kabo wɔ koro akan ateke minɛ beberebe nyi ni, má bo bu wo Ɛfɛso fɛn ŋgumi, ama, ni bo bu wo Esiya dɛɛ awɔrɛ n nu kɛrɛ, i ŋa amɔɛm bo adamandem yo bu n ti má nyɛmɛ ni. ");
INSERT INTO cko_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Nyini n bo i wo su ni, nzɛn ya yakiiri na i yó sɔ ɔ, ya juma n bo ya yo i ni, i ká ŋgbɛɛn wɔ. Má nyini ŋgumi, ama, minɛm fá má ya amɔɛ kpiri Atɛmisi sɔɔ n yo má pui, dama yiri Atɛmisi n ye minɛm bo bu wo Esiya awɔrɛ n nu ni durunya n nu­fɔm kɛrɛ su yiri wɔ. I nya yoori sɔ, Atɛmisi fún nyini jirima n wɔ lɛɛ.” ");
INSERT INTO cko_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Jama n tiiri ahin jɔjɔɔ­wa n sɔ ni, na yaa ati bu, na ba tiɛn kpa, bu ŋa, “Yɛrɛ Ɛfɛso­fɔm dɛɛ amɔɛ Atɛmisi ni, yiri ti yiko­fɔ a.” ");
INSERT INTO cko_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Na miɛ n abo nu, na minɛm suyo naŋmiɛ. Na jama n akaba akɔ atara Gayosi ni Arisitakusi, bɛrɛ bo bu suuri Pɔɔlu su fiteeri Makɛdoniya baari ni. Na ba cin bu akɔ tiɛntiɛn­bunɔɔ fofoe paa n nu. ");
INSERT INTO cko_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Má Pɔɔlu ni i tii koroori ka i kɔ deke bo jama n atiɛn bu nɔɔ n wɔ, na i jɔjɔ bu dɔ, ama, yarada­yo­fɔm n asoro má i su. ");
INSERT INTO cko_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Haari na nyini awɔrɛ n nu yiko­fɔm bo bu ti i danfom n asunma asere i jande ka má i kɔ tiɛntiɛn­bunɔɔ fofoe n nu. ");
INSERT INTO cko_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Nyini saŋga n kɛrɛ ni, bu nyunu ata, na jama n sutiɛntiɛn, suyo naŋmiɛ, nbem ŋa sɔ, nbem gusu ŋa ahin, ama, bu dɔŋgu asi má deke n bo i ti na ba ba atiɛn bu nɔɔ ni. ");
INSERT INTO cko_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Na Yuda­fɔm asun sɔnɔ be bo bu fere i ka Alɛkizanda n adu jama n nyunu, nyini dɛɛ ti, minɛ nbem sunsun ka yiri faari nyini sam n kɛrɛ baari a. Dɔ na wɔ yɛ i saa su ka jama n yaki naŋmiɛ, na i sukan na minɛm si deke bo i wo nu. ");
INSERT INTO cko_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ama, saŋga bo bu faari nu ka i ti Yuda­fɔ ni, na bu kɛrɛ atiɛn kungere­kun, bu ŋa, “Yɛrɛ Ɛfɛso­fɔm dɛɛ amɔɛ Atɛmisi ni, yiri ti yiko­fɔ a.” Ba tiɛntiɛn sɔ ɔ acɛ haari saŋga su. ");
INSERT INTO cko_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Na sɔnɔ be bo i ti bu miɛ n nu kadasi kɛrɛ­fɔ n aba bu dɔ, na wɔ se bu ka, “Am yaki naŋmiɛ.” Dɔ na wɔ nya se bu ka, “Ambɛrɛ Ɛfɛso­fɔm, am ti fɛn, ŋma wo bɛrɛ bo i si má ka Ɛfɛso­fɔm niɛ Atɛmisi amɔɛ kpiri sɔɔ n ni yabuɛ n bo i fiteeri aŋgoro tɔɔri n su a?” ");
INSERT INTO cko_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Sɔnɔ be wo má bɛrɛ bo i koro se ka ahin jɔrɛ n ti má nahɔrɛ. Nyini ti, wɔ yo daka ka am tara am ŋu, má am koro nde yo sa be bo i kunma am. ");
INSERT INTO cko_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Ahin minɛm bo am afa bu aba fɛn ni, ba wɔ má puitiri­pui afite má amɔɛ sɔɔ n nu, ba kaaki akpiɛ má nzukɔ be ajaraki má ya amɔɛ ni. ");
INSERT INTO cko_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Nzɛn Demetirɔsi ni i beŋgu juma­yo­fɔm ni, la jaraki fa kɔ bu be dɔ, jɔrɛ­di­fɔm ni gomina nkpiɛn­kpiɛnm wo bɛrɛ, bu koro jaraki nyini minɛm bu dɔ. ");
INSERT INTO cko_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ama, nzɛn sa be wo bɛrɛ buka su na am koro ka ya yo i dɔŋgu a, am fa bra saŋga bo miɛ n nu jama n kɛrɛ la bu tiɛntiɛn­bunɔɔ ni. ");
INSERT INTO cko_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Naŋmiɛ n bo am ayo i nyuma ni, i la má kpɛrɛ, i koro fa ya wura jɔrɛ nu, dama ya koro kan má deke n bo i ti na am ayo sɔ ni. ");
INSERT INTO cko_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","I jɔjɔɔri sɔ wieeri ni, na wɔ ma jama n asandi. ");
INSERT INTO cko_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Minɛm ni yoori naŋmiɛ n wieeri ni, na Pɔɔlu afere yarada­yo­fɔm n atiɛn bu nɔɔ, na wɔ ma bu ahoresi, na wɔ kaari bu, na wɔ kɔ Makɛdoniya awɔrɛ n nu. ");
INSERT INTO cko_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Na wɔ fa nyini awɔrɛ n kɛrɛ nu, na wɔ jɔjɔ yarada­yo­fɔm kɛrɛ dɔ, na wɔ ma bu ahoresi, na wɔ fa dɔ akɔ aju Giriki­fɔm dɛɛ awɔrɛ n nu, ");
INSERT INTO cko_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","na wɔ wo dɔ haari sara nsan. Na saŋga bo i wo sɛsɛ­su su ka i kɔ Siriya awɔrɛ n nu ni, na wɔ ti ka Yuda­fɔm akpa bu ŋu akɔ aŋminda i atin nu, nyini dɛɛ ti, na wɔ yo i sunsunni ka i kpie i nyi fa Makɛdoniya a. ");
INSERT INTO cko_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Na minɛ nbem asu i su akɔ, bɛrɛ la Sopateri bo bu fere i si ka Pirihusi na i fite Bɛriya miɛ kpiri n nu ni, ni Arisitakusi, ni Sekundosi bo bu fite Tɛsalonika miɛ kpiri n nu ni, ni Gayosi bo i fite Dɛrɛbi miɛ kpiri n nu ni, ni Tikikusi, ni Torofimosi bo bu fite Esiya dɛɛ awɔrɛ n nu ni, ni Timoti. ");
INSERT INTO cko_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Na bɛrɛ kɛrɛ adu mɔ akɔ aŋminda ya Tɔrasi miɛ kpiri n nu. ");
INSERT INTO cko_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Na yɛrɛ aka Filipiya miɛ kpiri n nu, haari na Yuda­fɔm aba adi bu cɛɛn­kpiri n asin, bo bu di i ni kpɔnɔ na bu gɔ má ayiri nu na i yasu ni, na ya nya afa lee bambaka, na i le­nnu cɛɛn na ya kɔ atu bu Tɔrasi, na ya wo dɔ akɔ aju le­so. ");
INSERT INTO cko_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Na Yuda­fɔm bakuɛ n bumboori, mɔnɛ cɛɛn, na ya kɛrɛ atiɛn ya nɔɔ ka ya saŋga di diire. Na Pɔɔlu ajɔjɔ minɛm dɔ, haari kɔŋguɛ jinanjin, dama i koroori ka nyini cɛɛn alecin i kaari bu wɔ, na i kɔ yaki bu. ");
INSERT INTO cko_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ya tiɛɛnri ya nɔɔ aŋgoro sɔɔ be nu wɔ, fitanam sunnu nu dɔ. ");
INSERT INTO cko_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Na gbɛfɛnɛ be, bu fere i ka Itikusi, na wɔ fun atana sɔɔ aŋgoro nsan n tukoro n su, na daafiri ati i. Pɔɔlu jɔjɔ cɛɛri na wɔ daafi, na wɔ fite aŋgoro aba atɔ asiɛŋgu. Bu jura kɔ maari i su ni, nyini saŋga wɔ wu. ");
INSERT INTO cko_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Na Pɔɔlu ajura akɔ asiɛŋgu, na wɔ fun abutu i ŋu, na wɔ fa i saa abara ayɛ i, na wɔ se bu ka, “Má am ma sɛrɛ ti am, dama i la ŋgɔɔ.” ");
INSERT INTO cko_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Dɔ na Pɔɔlu akpie i nyi afun akɔ aŋgoro sɔɔ n nu dɔ, na i ni bɛrɛ kɛrɛ asaŋga adi diire, na ba bo anzama, haari ale akɔ acin, na wɔ kaari bu na wɔ kɔ. ");
INSERT INTO cko_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Na ba nya afa gbɛfɛnɛ n akɔ awuru ni laifiɛ, na bu ahore ajɔ akɔ asin su. ");
INSERT INTO cko_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Na Pɔɔlu afa sɛsɛ­su ka yɛrɛ fa lee bambaka du mɔ ɔ, na yiri nati na ya ni yiri kɔ saa nu Asosi miɛ kpiri n nu. ");
INSERT INTO cko_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Saŋga bo i ba tuuri ya dɔ ni, na wɔ wura lee n nu, na ya ni yiri kɛrɛ akɔ miɛ kpiri n bo bu fere i ka Mitulene n su. ");
INSERT INTO cko_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Na ya yasu dɔ, i alecin, na ya kɔ dodo lui bambaka n bo bu fere i ka Kiyɔsi n su. Na i alecin bekun, na ya kɔ aju lui bambaka nyiŋga n bo bu fere i ka Samosi, na i alecin fɔfɔrɛ, na ya kɔ aju miɛ kpiri n bo bu fere i ka Miletosi n su. ");
INSERT INTO cko_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Na Pɔɔlu aboro i nyi ka i ju Yɛrusalem miɛ kpiri n nu ka, na bu di Pɛntɛkoti cɛɛn­kpiri ni, nyini ti, wɔ koro má ka i cɛ Esiya dɛɛ awɔrɛ nu, na wɔ san asin Ɛfɛso miɛ kpiri n dɛɛ bue ni. ");
INSERT INTO cko_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Saŋga bo Pɔɔlu wo Miletosi miɛ kpiri n nu ni, na wɔ sunma afere Kristo jama nkpiɛn­kpiɛnm bo bu wo Ɛfɛso miɛ kpiri n nu n ka bu ma bu ni yiri yɛ. ");
INSERT INTO cko_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Saŋga bo bu ba juuri i dɔ ni, na wɔ se bu ka, “Ambɛrɛ ni am tii si kabo m woo­wa ti barasu, saŋga kɛrɛ bo m woori am dɔ ni, fite cɛɛn gbingbin n bo m ba juuri Esiya awɔrɛ n nu ni. ");
INSERT INTO cko_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","M yoori m ŋu kaan wɔ, na ma yo Mibiɛ n juma n ni nyunvuin. Haari ni bo Yuda­fɔm sɛsɛɛri su ka bu kere m wuwuruwa barasu n kɛrɛ ni, m mindi deeri i wɔ. ");
INSERT INTO cko_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Am si ka deke kɛrɛ bo i ti kpa na i buka am ni, m kaanri i kereeri am wɔ jama n kɛrɛ nyunu, ma fa afiɛ má am su, na m sunati awuru awurum n kɛrɛ nu na m sukere am. ");
INSERT INTO cko_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","M kan kereeri Yuda­fɔm ni bo bu ti má Yuda­fɔm n kɛrɛ wɔ, ka bu kaaki bu wo fa kɔ Nyɛmɛ dɔ, na bu yo ya Mibiɛ Yesu n yarada. ");
INSERT INTO cko_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Tɔ, kisa Awiɛwiɛ Casi ni ma m sukɔ Yɛrusalem miɛ kpiri n nu n a, ama, m gusu si má deke bo i kɔ́ yo m dɔ. ");
INSERT INTO cko_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Deke bo m si i n la ka, miɛ kɛrɛ bo m kɔ su ni, Awiɛwiɛ Casi n se m ka bu kére m wuwuruwa, na bu nyí m dan­saraka. ");
INSERT INTO cko_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Ama, m fa má m tiɛŋgu ŋgɔɔ yo má pui. Deke bo i kpiɛ m daafiri n kɛrɛ la ka, má ka ma yo juma n bo Mibiɛ Yesu n afa ama m n awie. Yiri la ka, m kan labari kpa n fa kɔ Nyɛmɛ ahɔrɔma n bo wɔ fa ama minɛm ni. ");
INSERT INTO cko_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Kisa m si ka am be mmɔɔ ŋú má m kun, ambɛrɛ bo m yo nati am nu kan Nyɛmɛ jɔrɛ fa kɔ i fɛmɛya n su kere am ni. ");
INSERT INTO cko_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Nyini dɛɛ ti, m suse am wɔ lɛɛ nyuma, ka wɔrɔ kɛrɛ bo a kaari ŋgbɛɛn, i ti má m jɔrɛ. ");
INSERT INTO cko_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Dama deke kɛrɛ bo Nyɛmɛ koroori ka am yo i ni, ma fa afiɛ má am su, ma kan i akere am. ");
INSERT INTO cko_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Nyini ti, am bita am ŋu nyunyumi, na am kaaki niɛ Kristo jama minɛm kɛrɛ su, bɛrɛ bo Awiɛwiɛ Casi n afa ama am ka am niɛ bu dika ni, kabo bɔɛ­sasa­fɔ niɛ i nbɔɛm su ni. Nyini minɛm ye Nyɛmɛ faari i tiɛŋgu Wa mbunja deeri bu jiiri n a. ");
INSERT INTO cko_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","M si tenle su ka m kɔ yakiiri am, minɛ tiɛm ba wura am nu, kabo bedi wura nbɔɛm nu sandi bu n wɔ. ");
INSERT INTO cko_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Haari na am dɛɛ minɛm nbem bo bu wo am nu fɛn ni, bu bá kaaki nahɔrɛ ni, na bu dádaka yarada­yo­fɔm nbem na bu su bu dɛɛ atin n su. ");
INSERT INTO cko_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Nyini dɛɛ ti, am kpa am ŋu, na am teŋge su ka afɔ nsan lɛɛ bo m nati bɔbɔ am ni nyunvuin, kɔŋguɛ ni wiɛsu. ");
INSERT INTO cko_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Kisa, m sufa am wura Nyɛmɛ saa nu wɔ lɛɛ, na i niɛ am dika, na m kaaki fa am wura i dɛɛ nɔaniɛ n bo i ma am ahɔrɔma nu, na i buka am na i má am nya deke n bo Nyɛmɛ ase ka i fá ma i tiɛŋgu minɛm kɛrɛ ni. ");
INSERT INTO cko_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","M konviki awo má be ŋwaa, wara sutura nu. ");
INSERT INTO cko_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Ambɛrɛ mmɔɔ ni am tii si ka m yo faari m saa yoori m juma a, ye m fa bukaari m ŋu ni m lamɔkɔm n kɛrɛ a. ");
INSERT INTO cko_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Kabo ma yo juma n sɔ ni, m sukere am ka am gusu yo i sɔ ɔ lɛɛ, na am buka yaari­fɔm, na am teŋge su kabo ya Mibiɛ Yesu n ni i tii seeri ni. I ŋa, ‘Tere­fiɛ wo sɔnɔ bo i ce aceeri n dɔ tara sɔnɔ bo i de aceeri ni.’” ");
INSERT INTO cko_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Saŋga bo Pɔɔlu jɔjɔ wieeri ni, na i ni bɛrɛ kɛrɛ akutu bu jaa naŋgoroma su, na wɔ sere Nyɛmɛ. ");
INSERT INTO cko_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Na bu kɛrɛ asun, na ba fa bu saa abara ayɛ i, na ba biti i. ");
INSERT INTO cko_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Na bu ahore asaaki agaya, dama i seeri bu ka bu ŋú má i kun. Na ba se i atin nu, na wɔ kɔ awura lee bambaka n nu. ");
INSERT INTO cko_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Na ya kaari bu, na ya fa lee bambaka, na ya wɔ ya tii cein akɔ aju miɛ n bo i wo lui bambaka n su na bu fere i ka Kosi ni. Na i alecin na ya kɔ aju awɔrɛ n bo bu fere i ka Rodesi ni, na ya fite dɔ, na ya kɔ Patara miɛ kpiri n nu. ");
INSERT INTO cko_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Dɔ na ya ŋu lee bambaka be ka i sukɔ Fonisiya dɛɛ awɔrɛ n nu, na ya wura i akɔ. ");
INSERT INTO cko_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Ya sukɔ ni, na ya ŋu Sipurusi lui bambaka ni, na ya yaki ya saa biɛ su, na ya sin akɔ Siriya awɔrɛ n nu. Na ya nya akɔ ajina Tiro miɛ kpiri n nu, dɔ ye bu yi bu sɔɔri n lee n nu a. ");
INSERT INTO cko_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Na ya kɔ aniɛniɛ Yesu susu­fɔm busu, na ya wo bu dɔ le­so. Na Awiɛwiɛ Casi n ama ba se Pɔɔlu ka má i kɔ Yɛrusalem miɛ kpiri n nu. ");
INSERT INTO cko_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Ama, ya yasu cɛɛn n ba juuri ni, na ya fite ka ya kɔ, na bu ni bu yim, ni bu nbaam ase ya atin nu afite miɛ n nu akɔ tieku n nɔɔ su. Dɔ na ya ni bɛrɛ kɛrɛ akutu ya jaa naŋgoroma su, na ya sere Nyɛmɛ. ");
INSERT INTO cko_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Nyini sin, na ya kaari ya beŋgu, na yɛrɛ awura lee bambaka n nu, na bɛrɛ gusu akpie bu nyi akɔ awuru. ");
INSERT INTO cko_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Na ya fite Tiro akɔ aju miɛ kpiri n nu, na ya kɔ aniɛ yarada­yo­fɔm ni busu, na ya da bu dɔ le­kun. ");
INSERT INTO cko_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","I alecin fɔfɔrɛ na ya fite bɛrɛ akɔ aju Sizariya miɛ kpiri n nu. Dɔ na ya kɔ awo sɔnɔ be dika, bu fere i ka Filipu, i ti Nyɛmɛ jɔrɛ kan­fɔ ɔ. Yiri bukaari minɛ nsom bo bu yo yiiri bu ka bu buka Kristo jama n bo bu wo Yɛrusalem n a. ");
INSERT INTO cko_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","I yo la nbaa­baram nna a, bu be nya ja má. Bɛrɛ nati yo Nyɛmɛ nɔaniɛ kan­fɔ juma n a. ");
INSERT INTO cko_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Ya woori dɔ yoori le­nnyɔ, na Nyɛmɛ nɔaniɛ kan­fɔ be aba dɔ, bu fere i ka Agabusi, i fite Yudiya awɔrɛ n nu wɔ. ");
INSERT INTO cko_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Na wɔ ba ya dɔ, na wɔ fa Pɔɔlu dambara, acici i dɛɛ jaam ni i saam. Na wɔ nya ase ka, “Awiɛwiɛ Casi n ŋa o, kabo Yuda­fɔm bo bu wo Yɛrusalem ni cíci ahin dambara n fɔ lɛɛ, na bu nyá fa i ma minɛm bo bu ti má Yuda­fɔm ni.” ");
INSERT INTO cko_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Saŋga bo ya tiiri nyini jɔrɛ n sɔ ni, na ya ni minɛm n bo bu wo dɔ n asere Pɔɔlu jande ka má i kɔ Yɛrusalem. ");
INSERT INTO cko_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Ama, na wɔ bisa, “Nzu ti ye am suyo sɔ na am saaki m ahore a? Mini, ma yo siriya na m kɔ Yɛrusalem, na bu kɔ́ cici m nyama, má nyini ŋgumi, ama, haari na bu kún m, ya Mibiɛ Yesu n dɛɛ ti.” ");
INSERT INTO cko_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","I seeri sɔ ni, ya koro akanda má i ka má i kɔ, na ya mɔ ya nɔɔ, na ya se i ka, “Tɔ, ma Mibiɛ n dɛɛ koroo­wa yo.” ");
INSERT INTO cko_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Ya diiri le­nnyɔ dɔ ni, nyini sin, na ya sɛsɛ ya ŋu su, na ya nya akɔ Yɛrusalem. ");
INSERT INTO cko_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Na Yesu susu­fɔm nbem bo bu fite Sizariya n asu ya su, na ba fa ya akɔ ka ya kɔ wo sɔnɔ be dika, bu fere i ka Manesoni, i ti Sipurusi­fɔ ɔ, wɔ su Yesu dɛɛ atin n su acɛ. ");
INSERT INTO cko_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Saŋga bo ya kɔ juuri Yɛrusalem miɛ kpiri n nu ni, na ya ninbaam n ade ya ni ahorejɔ nyunyumi. ");
INSERT INTO cko_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","I alecin na Pɔɔlu afa ya akɔ Yakobo dɔ, na ya kɔ atu Kristo jama nkpiɛn­kpiɛnm kɛrɛ ka bu wo i dɔ. ");
INSERT INTO cko_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Ya bisaari ahin n wieeri ni, na Pɔɔlu akan deke n kɛrɛ kun kun fa kɔ kabo Nyɛmɛ ma wɔ yo i juma ama minɛm bo bu ti má Yuda­fɔm ni. ");
INSERT INTO cko_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Bu tiiri nyini nɔaniɛ n sɔ ni, na ba kansi Nyɛmɛ. Ama, na ba se i ka, “Ya niwa Pɔɔlu, m ŋa a ŋu Yuda­fɔm akpii beberebe bo bu wo ya nu fɛn na ba yo Yesu yarada, ye bu gusu nyunu aboro ka bu su Nyɛmɛ nɔaniɛ kpamaa­wa n su. ");
INSERT INTO cko_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ba ti ka a kere Yuda­fɔm bo bu tana minɛm bo bu ti má Yuda­fɔm n nu ni, ka má bu su Nyɛmɛ nɔaniɛ kpamaa­wa n bo Moyisi fa maari n su, ye a se bu ka má bu wura bu nbaam kɛnkɛnnɛ, na má bu kaaki su Yuda­fɔm nana sa­yoo­wam su. ");
INSERT INTO cko_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Nahɔrɛ, bu tí ka a ba. Ye ya yo sɛ wɔ? ");
INSERT INTO cko_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Ti fɛn, kabo ya yo n la ka, minɛ nna nbem wo ya nu fɛn bo ba tan ndiɛ. ");
INSERT INTO cko_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Su bu su na a kɔ biɛ fin kabo bu yoo­wa kere ni, na a tɔ bu tii su kaari, adena bu koro yi bu tii. Nyini ni má sɔnɔ kɛrɛ si ka jɔrɛ n kɛrɛ bo bu kan i fa kɔ u dɔ n ti kɔrɛ wɔ, na bu si ka wɔrɔ mmɔɔ ni u tii su Nyɛmɛ nɔaniɛ kpamaa­wa n su wɔ. ");
INSERT INTO cko_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Ama, minɛm bo bu ti má Yuda­fɔm na ba yo yarada n yiri, ya kɛrɛ kadasi ama bu, ka má bu se ka bu di tiɛ niɛ, wara mbunja, wara deke bo wɔ wu i ŋgumi na ba kpiɛ má i kɔm, na má bu yo sakaraya.” ");
INSERT INTO cko_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","I alecin, na Pɔɔlu afa minɛm n akɔ na ba kɔ ayo fin biɛɛ­wa yoo­wa ni, na wɔ nya awura Nyɛmɛ Seree­biri Awuru n nu, na wɔ jɔjɔ akere Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm ni, cɛɛn n bo bu ba biɛ fin n wie, na bu kun kun n kɛrɛ yo bu tii su sa­yoo­wa ni. ");
INSERT INTO cko_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Saŋga bo wɔ ka kaan na le­so cɛɛn n wie ni, na Yuda­fɔ nbem afite Esiya dɛɛ awɔrɛ n nu aba dɔ, na ba ŋu Pɔɔlu Nyɛmɛ Seree­biri Awuru n nu. Na ba yɛ jama n kɛrɛ ahore su, na ba tara Pɔɔlu. ");
INSERT INTO cko_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Na ba tiɛn, bu ŋa, “Yisareli­fɔm, am buka ya. Ahin sɔnɔ ni nati jeŋgbe deke n kɛrɛ kere minɛm kɛrɛ ɔ, ka má bu bu Yisareli­fɔm, ni Nyɛmɛ nɔaniɛ kpamaa­wa ni, ni Nyɛmɛ Seree­biri Awuru ni. Ye wɔ kaaki afa minɛm bo bu ti má Yuda­fɔm aba awura Nyɛmɛ Seree­biri Awuru n nu, na wɔ yo ahin woo­biri casi n fin.” ");
INSERT INTO cko_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Deke n bo i ti na bu seeri sɔ n la ka, ba du mɔ aŋu Torofimosi bo i fite Ɛfɛso miɛ kpiri n nu ni, ni Pɔɔlu miɛ kunnu, nyini dɛɛ ti ye bu sunsuunri ka Pɔɔlu afa i awura Nyɛmɛ Seree­biri Awuru n nu n a. ");
INSERT INTO cko_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Na miɛ n abo nu, na minɛm kɛrɛ aŋmati atiɛn bu nɔɔ, na ba tara Pɔɔlu acin ayi i afite Nyɛmɛ Seree­biri Awuru n nu. Na ba kaba anyi Nyɛmɛ Seree­biri Awuru n anɔ ni ndende. ");
INSERT INTO cko_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Má bu koroori ka bu kun Pɔɔlu wɔ. Dɔ na labari n atu Roma­fɔm sojam kɛrɛ kpiɛn n ka Yɛrusalem miɛ kpiri n abo nu. ");
INSERT INTO cko_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Kpeŋga na wɔ yasu ndende, na wɔ fa sojam ni bu nkpiɛn­kpiɛnm, na ba ŋmati aju dɔ. Saŋga bo jama n ŋuuri soja kpiɛn n ni i sojam ni, na ba yaki Pɔɔlu, ba bo má i kun. ");
INSERT INTO cko_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Na sojam kpiɛn n akɔ atara Pɔɔlu, na wɔ ma nɔɔ ka bu wura i jɔrɔkɔ nnyɔ. Na wɔ bisa ka, “Ahin sɔnɔ ti nzu sɔnɔ ɔ? Ye wɔ yo nzu wɔ?” ");
INSERT INTO cko_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Na jama ni nbem sutiɛntiɛn sujɔjɔ, bu jɔjɔɔ­wa n woori i ŋgumi ŋgumi wɔ, ba jɔjɔ má jɔrɛ kun. Bu naŋmiɛ dɛɛ ti, wɔ koro asi má jɔrɛ n bu. Na wɔ ma nɔɔ ka bu fa Pɔɔlu kɔ bɛrɛ sojam dika bambaka n nu. ");
INSERT INTO cko_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Bu faari Pɔɔlu kɔ juuri bimbindi bo bu tiɛntiɛn su fun na bu wura gisan nu ni, na i boori i bu ka i fun kɔ sɔɔ n aŋgoro ni, sojam n kukuuri i wɔ, dama jama n biɛkpa n dɛɛ ti. ");
INSERT INTO cko_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Na bu suŋmati su i su, sutiɛn kpa, bu ŋa, “Am kun i, am kun i.” ");
INSERT INTO cko_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Saŋga bo bu sukoro ka bu fa Pɔɔlu wura sojam dika bambaka n nu ni, na Pɔɔlu ase sojam kɛrɛ kpiɛn n ka, “Ma m kan jɔrɛ be na a ti.” Na sojam kɛrɛ kpiɛn n abisa i ka, “A ti Giriki aniɛ? ");
INSERT INTO cko_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Nyini yiri, a ti má Ijipiti sɔnɔ n bo i yo duuri minɛ akpii nna mɔ ka bu tu gomina n ni, na i faari nyini minɛ akpii nna n kɛrɛ kɔɔri boro kpantain n nu ni.” ");
INSERT INTO cko_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Na Pɔɔlu abɔ i nu ka, “Ai, mini, m ti Yuda­fɔ ɔ, m ti miɛbaa a, m fite Tarasu wɔ, miɛ kpiri n bo i la duma na i wo Silisiya awɔrɛ n nu ni. Jande, ma m jɔjɔ minɛm ni dɔ.” ");
INSERT INTO cko_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Na sojam kɛrɛ kpiɛn n ama i atin ka i jɔjɔ, na Pɔɔlu ajina bimbindi n bo bu tiɛntiɛn su fun na bu wura gisan nu ni, na wɔ fa i saa ayo minɛm n ka bu yaki naŋmiɛ. Na ba tɔ amuna, na Pɔɔlu ajɔjɔ bu dɔ Hiburu aniɛ nu. ");
INSERT INTO cko_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","I ŋa, “M sim ni m ninbaam, am ti fɛn, m koro ka m kan m jɔrɛ n na am ti.” ");
INSERT INTO cko_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Saŋga bo bu tiiri ka i sujɔjɔ bu dɔ Hiburu aniɛ nu ni, na ba yaki naŋmiɛ na ba mɔ bu nɔɔ surum. Na Pɔɔlu ase ka, ");
INSERT INTO cko_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“M ti Yuda­fɔ ɔ, bu wuuri m Tarasu miɛ kpiri n nu wɔ bo i wo Silisiya awɔrɛ n nu ni, ama, bu taari m Yɛrusalem miɛ kpiri n nu fɛn wɔ, Gamɛli kereeri m kara a, ye m sɔnsɔɔnri ya nam sa­yoo­wa atin n kɛrɛ ni anyum­boro. Na ma fa m ŋu kɛrɛ ama Nyɛmɛ, kabo ambɛrɛ bo am jina fɛn nyuma n afa am ŋu ama i ni. ");
INSERT INTO cko_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Na ma kere minɛm bo bu su ahin atin n su n wuwuruwa, haari na ma kun bu nbem. Na ma tara bu nbiɛsɔm ni nbaram anyi bu dan­saraka. ");
INSERT INTO cko_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Nzɛn am bisaari Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm n kɛrɛ kpiɛn ni, ni tere­tere­fɔm ni, bu sé am ka nɔaniɛ n bo m sujɔjɔ i n ti nahɔrɛ wɔ. Haari na ba ma m kadasi ka m fa kɔ ma ya minɛm bo bu wo Damasiko miɛ kpiri n nu ni, adena m koro tara Yesu minɛm ni, na m wura bu jɔrɔkɔ fa bu ba Yɛrusalem na bu bá cin bu sui.” ");
INSERT INTO cko_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Na Pɔɔlu asa su ase bu ka, “Saŋga bo m wo kɔ su n na m kɔ dodoori Damasiko miɛ kpiri n ni, wiɛ kekete saŋga lɛɛ, na sin be akaba afite aŋgoro ata abara ayɛ m. ");
INSERT INTO cko_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Na ma kpaasi haari asiɛŋgu, na ma ti akonvi be ŋga, i ŋa, ‘Sɔɔlu, Sɔɔlu e, nzu ti ye a kere m wuwuruwa sɔ a?’ ");
INSERT INTO cko_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Na ma bisa i ka, ‘M Mibiɛ, wɔrɔ ŋma a?’ Na wɔ bɔ m nu ka, ‘Mini Yesu Nazarɛti­fɔ n a, mini ye a kere m wuwuruwa n a.’ ");
INSERT INTO cko_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Na minɛm bo bu su m su n aŋu sin ni, ama, ba ti má akonvi n yiri ŋga. ");
INSERT INTO cko_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Na ma bisa i ka, ‘M Mibiɛ, ye a ŋa m yo nzu wɔ?’ Na wɔ se m ka, ‘Yasu na a kɔ Damasiko, dɔ ye bu sé u deke n kɛrɛ bo Nyɛmɛ koro ka a yo i ni.’ ");
INSERT INTO cko_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Sin n bo i ta wuraari m nyu­mbaa nu agaya n dɛɛ ti, na ma yo anyinsin, na minɛm ni bo bu su m su n aso m saa nu afa m awura Damasiko. ");
INSERT INTO cko_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Tɔ, sɔnɔ be woori miɛ n nu, bu fere i ka Ananiyasi, i su Nyɛmɛ wɔ, na i su i nɔaniɛ kpamaa­wa n su, i ti sɔnɔ n bo Yuda­fɔm bo bu wo miɛ n nu n kɛrɛ ma i jirima agaya a. ");
INSERT INTO cko_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Na wɔ ba m dɔ ajina adodo m, na wɔ se m ka, ‘M niwa Sɔɔlu, niɛ, a ŋú asi.’ Jina n nu bɛrɛ na ma ŋu asi bekun, na ma niɛ aŋu i. ");
INSERT INTO cko_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Na wɔ se m ka, ‘Nyɛmɛ n bo ya nam su i ni, yiri ye wɔ yi u a, na a si i sa koroo­wam, ye wɔ yi Sɔnɔ n bo i yo sa bo i kɔ atin su n akere u, na a ti yiri ni i tii nɔaniɛ jɔjɔɔ­wa. ");
INSERT INTO cko_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Dama deke bo a ŋu i na a ti i ni, wɔrɔ kán kere minɛm kɛrɛ. ");
INSERT INTO cko_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ye kisa, a ŋminda nzu wɔ? Yasu na bu biɛ u Nyɛmɛ nzue. Bo fere i duma na i ŋmisi yi u satiɛ kɛrɛ.’” ");
INSERT INTO cko_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Na Pɔɔlu asa su ase bu ka, “Nyini ti, na ma kpie m nyi akɔ Yɛrusalem miɛ kpiri n nu, saŋga bo m wo Nyɛmɛ Seree­biri Awuru n nu wo nyɛmɛsere su ni, na wɔ yo m ka alɛlɛ dɛɛ su wɔ, ");
INSERT INTO cko_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","na ma ŋu Yesu ka i sujɔjɔ m dɔ, i ŋa, ‘Yasu na a fite Yɛrusalem ndende, dama minɛm bo bu wo fɛn ni dé má m jɔrɛ n bo a kan kere bu ni.’ ");
INSERT INTO cko_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Na ma bɔ i nu ka, ‘M Mibiɛ, bɛrɛ ni bu tii si tenle su ka m yo wuraari bu tiɛntiɛn­bunɔɔ sɔɔm nu wɔ, na ma tara minɛm bo bu yo u yarada ni, na ma nyi bu dan­saraka, na ma bo bu. ");
INSERT INTO cko_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Sasu bekun, saŋga bo bu sukun Satɛfano bo i diiri u ŋusu daani kereeri minɛm ni, m yo jinaari bɛrɛ, na ma soro su, mini niɛɛri minɛm bo bu kuunri i n suturam su a.’ ");
INSERT INTO cko_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Na Mibiɛ n ase m ka, ‘Wɔrɔ kɔ, m súnma u dede minɛm bo bu ti má Yuda­fɔm ni dɔ.’” ");
INSERT INTO cko_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Nyini saŋga n kɛrɛ ni, minɛm ni soori bu sui wɔ, na ba ti jɔrɛ n kɛrɛ bo Pɔɔlu kaanri i ni, ama, i ba kaanri sɔ ni, na ba tiɛn kpa, bu ŋa, “Am yi i fite fɛn. Am mini i mmɔɔ. Wɔ ti má ye ni ka i wo ni ŋgɔɔ.” ");
INSERT INTO cko_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Na bu sutiɛntiɛn, yaa ati bu n dɛɛ ti, na bu sufikindi bu suturam tu, na bu susa fa sutu sandi aŋgoro. ");
INSERT INTO cko_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Na Roma­fɔm soja kɛrɛ kpiɛn n ama nɔɔ ka bu fa Pɔɔlu wura bu dika bambaka n nu, na bu bisa i bisaa­wam na bu fin i ŋgbere na bu si deke bo i ti na Yuda­fɔm ni tiɛntiɛn sɔ ni. ");
INSERT INTO cko_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Ama, saŋga bo bu ciciiri Pɔɔlu nyama n ka bu bo i ni, na wɔ bisa soja kpiɛn n bo i jina dodo i ka, “Atin wo nu ka am bo Roma miɛbaa na am asi má satiɛ bo wɔ yo i?” ");
INSERT INTO cko_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Saŋga bo soja kpiɛn n tiiri nyini jɔrɛ n sɔ ni, na wɔ kɔ sojam kɛrɛ kpiɛn n dɔ, akɔ abisa i ka, “A koro ka a yo ahin sɔnɔ n sɛ wɔ? I ti Roma miɛbaa a.” ");
INSERT INTO cko_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Nyini ti, na sojam kpiɛn n akɔ Pɔɔlu dɔ, akɔ abisa i ka, “A ti Roma miɛbaa a, nahɔrɛ su?” Na wɔ bɔ i nu ka, “Ɛɛn.” ");
INSERT INTO cko_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Na sojam kpiɛn n ase i ka, “Mini, m tɔɔri ŋwaa beberebe wɔ ye m nya kaakiiri Roma miɛbaa a.” Na Pɔɔlu ase i ka, “Ama, mini yiri, bu wuuri m miɛbaa a.” ");
INSERT INTO cko_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","I seeri sɔ ni, kpeŋga na sɛrɛ ati sojam bo ba yi bu ka bu bisa i bisaa­wa ni, na ba kɔ bu sin. Na sɛrɛ ati soja kpiɛn ni mmɔɔ, dama wɔ du mɔ abo Pɔɔlu jɔrɔkɔ ka, ye i nya siiri ka i ti Roma miɛbaa a. ");
INSERT INTO cko_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Na i alecin, sojam kpiɛn n akoro ka i si sa bo Pɔɔlu ayo i na Yuda­fɔm jaraki i ni, na wɔ yi Pɔɔlu jɔrɔkɔ ni, na wɔ ma nɔɔ ka Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ nkpiɛn­kpiɛnm ni, ni Yuda­fɔ tere­tere­fɔm n kɛrɛ tiɛn bu nɔɔ. Na wɔ ma Pɔɔlu aba ajina bu nyunu. ");
INSERT INTO cko_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Na Pɔɔlu afa i nyu­mbaa akpama Yuda­fɔ tere­tere­fɔm n ŋu, na wɔ se ka, “M ninbaam, m sunsunni ti kpa wɔ Nyɛmɛ dɔ, fite m kaan nu haari ni nyuma.” ");
INSERT INTO cko_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Na Ananiyasi bo i ti Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm n kɛrɛ kpiɛn n ama minɛm bo bu jina dodo Pɔɔlu n nɔɔ, ka bu bo i nɔɔ dika, fa kɔ i nɔaniɛ jɔjɔɔ­wa n dɛɛ ti. ");
INSERT INTO cko_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Na Pɔɔlu ase i ka, “Nyɛmɛ bó wɔrɔ mmɔɔ, wɔrɔ bo a tana dɔ ka kobe dawa bo ba bo i ŋgoro fofoe ni. A tana na a di m jɔrɛ, fa kɔ Nyɛmɛ nɔaniɛ kpamaa­wa n dɛɛ atin su, ama, wɔrɔ ni u tii asu má i nɔaniɛ kpamaa­wa n su na a tana ma nɔɔ ka bu bo m.” ");
INSERT INTO cko_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Na minɛm bo bu jina dodo Pɔɔlu n ase i ka, “Wɔrɔ la ŋma na a kpiɛ i nzukɔ a, yiri Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔm n kɛrɛ kpiɛn ni?” ");
INSERT INTO cko_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Na Pɔɔlu abɔ bu nu ka, “M ninbaam, ma si má ka yiri ti Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ n kɛrɛ kpiɛn n a. Dama ba kɛrɛ i Nyɛmɛ Jɔrɛ Kadasi n nu ka, ‘Má a jɔjɔ sɔnɔ bo i niɛ u minɛm su jɔrɛ tiɛ.’” ");
INSERT INTO cko_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Saŋga bo Pɔɔlu faari nu ka, minɛm ni nbem ti Sadusi­fɔm, na bu nbem gusu ti Farasi­fɔm ni, na wɔ tiɛn kpa jama n nu, i ŋa, “M ninbaam, m ti Farasi­fɔ ɔ. M sim mmɔɔ suuri nyini atin ni su a. Deke n bo i ti na ya tiɛn ya nɔɔ n la ka, m la tama ka minɛm wu, bu téŋge bu yiwee nu wɔ.” ");
INSERT INTO cko_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Pɔɔlu seeri sɔ wieeri na akuruwa aba Sadusi­fɔm ni Farasi­fɔm n afiɛn, na bu tiɛntiɛn­bunɔɔ n akpaaki nu nnyɔ. ");
INSERT INTO cko_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Sadusi­fɔm n ŋa, sɔnɔ wu, i téŋge má i yiwee nu kun, ye bu kaaki ŋa, Nyɛmɛ mɛrɛkɛm, wara awiɛwiɛm wo má bɛrɛ. Ama, Farasi­fɔm bɛrɛ yo nyinim n kɛrɛ yarada a. ");
INSERT INTO cko_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Na jama ni sutiɛntiɛn suyo naŋmiɛ agaya buka su. Na Nyɛmɛ nɔaniɛ kere­fɔ nbem bo bu wo Farasi­fɔm asɛsɛ n nu n ayasu ajina atiɛn faŋga su, bu ŋa, “Yɛrɛ aŋu má ahin sɔnɔ ni ŋgasi bo wɔ do i. Beni, awiɛwiɛ be, wara Nyɛmɛ mɛrɛkɛ ajɔjɔ i dɔ a.” ");
INSERT INTO cko_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Saŋga bo akuruwa n ba bi boroori agaya ni, na sɛrɛ ati soja kpiɛn ni, ka minɛm ni bá cincin titi Pɔɔlu nu. Nyini ti, na wɔ ma sojam nɔɔ ka bu wura jama n nu na bu yi Pɔɔlu fite bu nu, na bu fa i ba wura bu dɛɛ dika bambaka n nu. ");
INSERT INTO cko_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Nyini cɛɛn n kɔŋguɛ, na Mibiɛ n ayi i ŋu akere Pɔɔlu, na wɔ se i ka, “Ma u ahore si, na má a soro sɛrɛ. Kabo a di m ŋu daani Yɛrusalem miɛ kpiri n nu fɛn ni, sɔ ye i ti ye ni ka a kɔ di i Roma miɛ kpiri n nu gusu a.” ");
INSERT INTO cko_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","I alecin fɔfɔrɛ, na Yuda­fɔ nbem atiɛn bu nɔɔ, na ba fa sɛsɛ­su na ba tan ndiɛ ka bu di má, bu nu má, má ka ba kun Pɔɔlu. ");
INSERT INTO cko_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Bɛrɛ n bo bu tana faari nyini sɛsɛ­su ni, bu taraari minɛ abura­na. ");
INSERT INTO cko_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Na ba kɔ Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ nkpiɛn­kpiɛnm ni, ni Yuda­fɔ tere­tere­fɔm ni dɔ, akɔ ase bu ka, “Yɛrɛ, ya tiɛn ya nɔɔ atan ndiɛ ka ya dí má pui, má ka ya kun Pɔɔlu. ");
INSERT INTO cko_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Nyini ti, ambɛrɛ ni tere­tere­fɔm ni, am sunma Roma­fɔm soja kpiɛn n dɔ kɔ se i ka, i fa Pɔɔlu bra am dɔ ka am koro ka am niɛ i jɔrɛ n nu nyunyumi bekun wɔ. Ama, na ya yó siriya ŋminda i, na ya kún i atin nu na i nya ba ju fɛn.” ");
INSERT INTO cko_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Ama, na Pɔɔlu niwa bara be wa ati sɛsɛ­su n bo ba fa i ni, na wɔ kɔ awura sojam sɔɔ bambaka n nu, na wɔ se Pɔɔlu. ");
INSERT INTO cko_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Dɔ na Pɔɔlu afere sojam n kun, na wɔ se i ka, “Fa ahin gbɛfɛnɛ n kɔ am kpiɛn n dɔ, i la jɔrɛ be bo i kán kere i.” ");
INSERT INTO cko_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Na soja n afa i akɔ bu kpiɛn n dɔ, na wɔ se i ka, “Pɔɔlu bo ba nyi i dan­saraka ni fereeri m a, na wɔ se m ka m fa ahin gbɛfɛnɛ n ba u dɔ, dama i la jɔrɛ bo i kán kere u.” ");
INSERT INTO cko_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Na sojam kɛrɛ kpiɛn n aso i saa nu, na i ni yiri ŋgumi afite ahɛmɛ, na wɔ bisa i ka, “A koro ka a kan nzu jɔrɛ kere m a?” ");
INSERT INTO cko_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Na wɔ se sojam kpiɛn n ka, “Yuda­fɔm n asɛsɛ su ye ba soro su ka ahunma bu bá sere u na a fa Pɔɔlu ma bu na bu fa i kɔ bu tere­tere­fɔm ni dɔ, na bu yó bu ŋu ka bu koro ka bu niɛ i jɔrɛ n nu nyunyumi wɔ. ");
INSERT INTO cko_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Ama, má a soro bu su, dama bu nbem ŋa bu kɔ ŋminda i atin nu wɔ, bu tara minɛm abura­na. Ba tan ndiɛ ka bu dí má, bu nú má, má ka ba kun Pɔɔlu. Kisa ba yo siriya su aŋminda na bu ti kabo a sé.” ");
INSERT INTO cko_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Na sojam kɛrɛ kpiɛn n abɔbɔ i ka, “Má a ma be si ka a kan ahin jɔrɛ n akere m.” Na wɔ ma gbɛfɛnɛ n atin na wɔ kɔ. ");
INSERT INTO cko_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Na sojam kɛrɛ kpiɛn ni, afere soja nkpiɛn­kpiɛnm ni nnyɔ, na wɔ ma bu nɔɔ ka, “Am fa sojam yaa nnyɔ, ni soja kpɔŋgɔ­fun­fɔm abura­so, ni soja kpiɛ­bita­fɔm yaa nnyɔ, na am yo siriya kɔŋguɛ n nu, kerefi ŋgɔna saŋga, na am kɔ Sizariya miɛ kpiri n nu. ");
INSERT INTO cko_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Na am nya kpɔŋgɔ ma Pɔɔlu gusu, na am fa i haari na am kɔ ju Gomina Felika dɔ, na má pui yo i.” ");
INSERT INTO cko_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Na sojam kpiɛn n akɛrɛ kadasi ama gomina n ka, ");
INSERT INTO cko_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Mini Kalodisi Lisiyasi sukɛrɛ ahin kadasi n bisa wɔrɔ, m si Gomina Jirima­fɔ Felika dɔŋgu a. ");
INSERT INTO cko_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Yuda­fɔm taraari ahin sɔnɔ n a, má bu koro ka bu kun i wɔ. Ama, na ma ti ka i ti Roma miɛbaa a, nyini ti, na ma fa m sojam, na ya kɔ ade i aji. ");
INSERT INTO cko_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Na ma koro ka m si deke n bo i ti na bu jarakiiri i ni, nyini ti, na ma fa i akɔ Yuda­fɔ tere­tere­fɔm dɔ. ");
INSERT INTO cko_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Na ma ŋu ka fa kɔ bu nɔaniɛ kpamaa­wa n dɛɛ atin su ye bu jarakiiri i a, ama, wɔ yo má sa be bo i ti ye ni ka bu kun i, wara bu nyi i dan­saraka. ");
INSERT INTO cko_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","M tiiri ka Yuda­fɔm asɛsɛ su akɔ ada aŋminda atin nu ka bu kun i, nyini dɛɛ ti, ye m ma ba kaba afa i aba u dɔ n a. Ma se minɛm bo bu jarakiiri i n ka bu fá jɔrɛ n bra u dɔ.” ");
INSERT INTO cko_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Na sojam n ayo kabo i kereeri bu ka bu yo ni, na ba fa Pɔɔlu nyini kɔŋguɛ n kɛrɛ, na ba fa i akɔ aju miɛ kpiri n bo bu fere i ka Antipatiriso n su. ");
INSERT INTO cko_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Na i alecin fɔfɔrɛ na sojam bo bu nati bu jaa su n akpie bu nyi akɔ sojam sɔɔ bambaka n nu, na ba ma soja kpɔŋgɔ­fun­fɔm n afa i akɔ aju deke bo bu sukɔ ni. ");
INSERT INTO cko_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Bu kɔ juuri Sizariya ni, na ba fa kadasi n ama gomina ni, na ba nya afa Pɔɔlu awura i saa nu. ");
INSERT INTO cko_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Gomina n kaanri kadasi n wieeri ni, na wɔ bisa Pɔɔlu awɔrɛ bo i fite nu. I faari nu ka i fite Silisiya awɔrɛ n nu wɔ, ");
INSERT INTO cko_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","na wɔ se i ka, “Minɛm bo bu jarakiiri u n ba juuri, m tí u nɔaniɛ.” Na wɔ ma nɔɔ ka bu fa Pɔɔlu wura Fɛmɛ Herode dika n nu, na bu niɛ i dika nyunyumi. ");
INSERT INTO cko_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Na i le­nnu cɛɛn sin, na Ananiyasi bo i ti Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ n kɛrɛ kpiɛn n aba aju Sizariya miɛ kpiri n nu, i ni Yuda­fɔ tere­tere­fɔ nbem, na ba fa jɔrɛ­si­fɔ be bo bu fere i ka Tɛtulɔsi n abuka bu ŋu su. Na ba jaraki Pɔɔlu gomina n nyunu. ");
INSERT INTO cko_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","3","Bu faari Pɔɔlu ba juuri n na Tɛtulɔsi abo i bu na i kan ŋgasi bo Pɔɔlu ado i. I ŋa, “Ya si Felika jirima­fɔ, u ŋgɔnlɛ kpa n bo a la i n dɛɛ ti, nyini ma ya nya tana­laifiɛ acɛ a, ye kaaki aba ya asiɛn n su a, fa kɔ nyini sunsunni n bo a la i ni. Deke kɛrɛ bo ya wo ni saŋga kɛrɛ, ya nyunu ayi u fa kɔ deke n kɛrɛ bo a yo ama ya ni, nyini dɛɛ ti, ya da u asi beberebe. ");
INSERT INTO cko_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Tɔ, m koro má ka m jɔjɔ saaki u saŋga, ama, m sere u wɔ, sawɔrɛ n bo a la i n dɛɛ ti, ti ya ahin jɔrɛ kaan ni. ");
INSERT INTO cko_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Ya ŋu ka ahin sɔnɔ n ti miɛbo­fɔ ɔ, na i nati sukpukpura Yuda­fɔm tii durunya n kɛrɛ nu, na bu sudi aluwa ni bu beŋgu. I ti mɔ­fɔ ɔ, fa kɔ minɛm bo bu su Nazarɛti­fɔ n atin n su ni. ");
INSERT INTO cko_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Haari i yo koroori ka i wura Nyɛmɛ Seree­biri Awuru n nu wɔ na i saaki i na i yo i fin, ye ya taraari i a. Má ya koroori ka ya fa ya nɔaniɛ kpamaa­wa n atin su di i jɔrɛ wɔ, ");
INSERT INTO cko_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","ama, na sojam kpiɛn Lisiyasi n ade i ya dɔ ni faŋga, ");
INSERT INTO cko_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","na wɔ ma nɔɔ ka, bo bu ni yiri la jɔrɛ n kɛrɛ bra u dɔ. Na nzɛn wɔrɔ mmɔɔ ni u tii niɛɛri jɔrɛ n nu, a sí deke n bo i ti na ya jaraki i ni.” ");
INSERT INTO cko_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Na Yuda­fɔm n kɛrɛ ajina su ka, jɔrɛ n kɛrɛ bo bu jɔjɔ i n ti nahɔrɛ wɔ. ");
INSERT INTO cko_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Na Gomina Felika ama Pɔɔlu atin ka i jɔjɔ, na Pɔɔlu ase ka, “M si ka a di jɔrɛ ahin asiɛn n su acɛ, nyini ti, m ahore ti sii­wa ka ma ba u dɔ na m kan de m tii. ");
INSERT INTO cko_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Wɔrɔ mmɔɔ ni u tii koro bisa na a ti, ka i nyuma le­buru le­nnyɔ lɛɛ, bo m kɔɔri Yɛrusalem miɛ kpiri n nu ka m kɔ su Nyɛmɛ. ");
INSERT INTO cko_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Bɛrɛ n aŋu má ka m ni be suse akuruwa Nyɛmɛ Seree­biri Awuru n nu, ba kaaki aŋu má ka m ni be suwura minɛm bu sin na bu yo sa be tiɛntiɛn­bunɔɔ sɔɔm n nu, wara miɛ n nu. ");
INSERT INTO cko_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Bɛrɛ gusu koro kan kere má u deke n bo i ti na kisa bu sujaraki m ni. ");
INSERT INTO cko_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ama, deke bo m soro i su ka i ti nahɔrɛ n la ka, m su Nyɛmɛ wɔ, kabo ya nam su i ni, nyini atin n gusu ye bu ŋa i ti má nahɔrɛ n a. Ama, m yo deke bo ba kɛrɛ i nɔaniɛ kpamaa­wa n nu n yarada, na m kaaki yo deke bo ba kɛrɛ i Nyɛmɛ nɔaniɛ kan­fɔm dɛɛ kadasi n nu n yarada. ");
INSERT INTO cko_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","M la tama Nyɛmɛ dɔ ka minɛm bo bu yo sa bo i kɔ atin su, ni bo bu yo sa bo i kɔ má atin su n kɛrɛ bá teŋge bu yiwee n nu, kabo bɛrɛ n bo bu jaraki m n gusu la nyini tama ni. ");
INSERT INTO cko_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Nyini dɛɛ ti, saŋga kɛrɛ m boro m nyi wɔ, na m sunsunni ti casi fa kɔ Nyɛmɛ ni adamandem dɔ. ");
INSERT INTO cko_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","M fiteeri Yɛrusalem, wɔ cɛ, nyini sin, na ma kpie m nyi akɔ dɔ ka m kɔ fa ŋwaa ce m minɛm bo bu ti yaari­fɔm n na m yo m dɛɛ yoo­wa ma Nyɛmɛ. ");
INSERT INTO cko_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","M wo nyini yoo­wa n yo su ye bu ŋuuri m Nyɛmɛ Seree­biri Awuru n nu a. Nyini saŋga ni, ma yo fin biɛ yoo­wa n awie mmɔɔ. Jama be awo má m dɔ, be gusu ayo má naŋmiɛ be. ");
INSERT INTO cko_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Ama, Yuda­fɔm nbem bo bu fite Esiya awɔrɛ n nu ni, yo woori dɔ a. Wɔ yo daka ka má bɛrɛ mmɔɔ ni bu tii wo fɛn, na bu kan m ŋgasi bo ma do i n kere u. ");
INSERT INTO cko_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Nzɛn má nyini, yaki na ahin minɛm bo bu jina fɛn n kan ŋgasi bo m doori, saŋga bo m jinaari bu tere­tere­fɔm nyunu na bu diiri m jɔrɛ ni. ");
INSERT INTO cko_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Má ka deke kun n kpein be bo bu yo sudi m jɔrɛ na m jinaari bu nyunu ni. Yiri la bo m seeri ka minɛm wu, bu káaki teŋge bu yiwee nu ni, nyini dɛɛ ti, ye a sudi m jɔrɛ nyuma n a.” ");
INSERT INTO cko_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Na Gomina Felika si Mibiɛ n atin n sereya n kɛrɛ nyunyumi n dɛɛ ti, na wɔ se bu ka, “Am kɔ ka, na sojam kpiɛn Lisiyasi ba baari, na m nyá di jɔrɛ ni.” ");
INSERT INTO cko_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Na wɔ ma nɔɔ ka soja kpiɛn n niɛ Pɔɔlu dika nyunyumi, ama, i ma i atin na i nati i koroya­nu, na i ma i danfom gusu atin na bu koro ba buka i. ");
INSERT INTO cko_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","I yoori le­nnyɔ, na Gomina Felika akaaki aba, i ni i yi Durusila, i ti Yuda­fɔ baa a. Na wɔ sunma afere Pɔɔlu na i ba kan kabo sɔnɔ yo Yesu Kristo yarada barasu ni. Na wɔ so i sui ati. ");
INSERT INTO cko_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Ama, saŋga bo Pɔɔlu wo jɔjɔ su fa kɔ sa bo i kɔ atin su, ni tara­buŋu, ni kabo Nyɛmɛ bá di minɛm n jɔrɛ ni, na sɛrɛ ati Gomina Felika na wɔ se ka, “Tɔ, kisa, wɔ sɛ su. A koro kɔ, na m ba nya saŋga na m fére u.” ");
INSERT INTO cko_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Nyini saŋga n kɛrɛ ni, i sunsunni la ka Pɔɔlu má i ŋwaa a, nyini ti ye saŋga saŋga i fere Pɔɔlu, na bu subo anzama n a. ");
INSERT INTO cko_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Na afɔ nnyɔ aba asin, na sɔnɔ be bo bu fere i ka Pɔkiyɔsi Fɛsitosi ade Felika jinaa­biri ni. Na Gomina Felika akoro ka i jɔ Yuda­fɔm n ahore, nyini dɛɛ ti, na wɔ yaki Pɔɔlu dan­saraka n nu, i ma ba yi má i. ");
INSERT INTO cko_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Gomina Fɛsitosi ba juuri nyini awɔrɛ n nu ni, i le­san, na wɔ fite Sizariya miɛ kpiri n nu, na wɔ fun akɔ Yɛrusalem miɛ kpiri n nu. ");
INSERT INTO cko_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Na Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ nkpiɛn­kpiɛnm, ni Yuda­fɔ tere­tere­fɔm n aba akan ŋgasi bo Pɔɔlu ado i n akere Gomina Fɛsitosi. Na ba sere i jande ");
INSERT INTO cko_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","ka i boro i nyi na i ma bu fa Pɔɔlu ba Yɛrusalem. Deke n bo i ti na bu seeri sɔ n la ka, ba sɛsɛ su ka bu kɔ ŋminda i atin nu wɔ na bu kun i. ");
INSERT INTO cko_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Na Gomina Fɛsitosi abɔ bu nu ka, “Pɔɔlu wo dan­saraka nu Sizariya, mini ni m tii, m kpie m nyi kɔ dɔ kisa. ");
INSERT INTO cko_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Am ma am nu nbem bo bu la yiko n su m su, na ya kɔ Sizariya, na nzɛn wɔ do ŋgasi be a, na bu koro kan i na bu jaraki i.” ");
INSERT INTO cko_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Na Gomina Fɛsitosi awo bu dɔ, le­mɔcuɛ ni le­buru afiɛn, na wɔ nya aba Sizariya. I alecin na wɔ kɔ atana jɔrɛ dii­biri ni, na wɔ ma nɔɔ ka bu fa Pɔɔlu bra. ");
INSERT INTO cko_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Saŋga bo bu faari Pɔɔlu ba juuri n ni, na Yuda­fɔm bo bu fiteeri Yɛrusalem baari n atiɛn bu nɔɔ abara ayɛ i. Na ba kan i ŋgasi tiɛtiɛ beberebe bo bu ŋa wɔ do i, bu gusu akoro akere má ŋgasi n bo bu ŋa wɔ do i n tenle su. ");
INSERT INTO cko_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Na Pɔɔlu ase ka, “Ma do má ŋgasi be fa kɔ Yuda­fɔm dɛɛ nɔaniɛ kpamaa­wa n su, ma do má ŋgasi be fa kɔ Nyɛmɛ Seree­biri Awuru n su, ma kaaki ado má ŋgasi be fa kɔ Roma­fɔm Fɛmɛ Kpiri Siza n dɔ.” ");
INSERT INTO cko_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Ama, na Gomina Fɛsitosi akoro ka i buka Yuda­fɔm ni, na i da bu ahore, nyini dɛɛ ti, na wɔ bisa Pɔɔlu ka, “A soro su ka ya kɔ Yɛrusalem na bu kɔ di u jɔrɛ n dɔ m nyunu, fa kɔ ahin sereyam kɛrɛ su?” ");
INSERT INTO cko_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Ama, na Pɔɔlu abɔ i nu ka, “M jina Roma­fɔm fɛmɛ kpiri n jɔrɛ dii­biri wɔ lɛɛ, fɛn ye wɔ yo daka ka bu di m jɔrɛ a. Wɔrɔ mmɔɔ ni u tii si tenle su ka ma do má Yuda­fɔm ŋgasi be. ");
INSERT INTO cko_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Nzɛn ma do ŋgasi be bo wɔ yo daka ka bu kun m, ma kete má ka má bu kun m. Ama, nzɛn jɔrɛ n kɛrɛ bo ba kan i n be ti má nahɔrɛ, be la má atin bo i koro fa m wura bu saa nu. Nyini ti, m sere ka a fa m jɔrɛ n kɔ Roma­fɔm fɛmɛ kpiri n dɔ.” ");
INSERT INTO cko_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Na Gomina Fɛsitosi ni i nkpiɛn­kpiɛnm n atana aŋu bu ŋu, na ba soro su, na wɔ se Pɔɔlu ka, “A sere ka ya fa u jɔrɛ n kɔ Roma­fɔm fɛmɛ kpiri n dɔ. Tɔ, ya fá u kɔ i dɔ.” ");
INSERT INTO cko_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Na wɔ yo le­nnyɔ, na Fɛmɛ Agiripa ni i siwa baa­bara Bɛrɛnisi aba Sizariya miɛ kpiri n nu, ka bu ba niɛ Gomina Fɛsitosi busu. ");
INSERT INTO cko_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Bu woori dɔ cɛɛri kaan n dɛɛ ti, na Gomina Fɛsitosi akan Pɔɔlu jɔrɛ n kɛrɛ n akere fɛmɛ ni. I ŋa, “Felika yo yakiiri sɔnɔ be dan­saraka n nu fɛn. ");
INSERT INTO cko_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Saŋga bo m kɔɔri Yɛrusalem miɛ kpiri n nu ni, na Yuda­fɔ Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ nkpiɛn­kpiɛnm, ni Yuda­fɔ tere­tere­fɔm n aba m dɔ, na ba kan nyini sɔnɔ n jɔrɛ, ka m boro m nyi di i jɔrɛ n na m se ka wɔ do ŋgasi. ");
INSERT INTO cko_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Ama, na ma se bu ka yɛrɛ Roma­fɔm, ya yo má sɔ, nzɛn minɛm ajaraki sɔnɔ, ya ma bu kɛrɛ tiɛn bu nɔɔ ɔ, na i mi si deke n bo i ti na bu jaraki i ni, na i gusu nya kan i dɛɛ bo i la i ni. ");
INSERT INTO cko_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Saŋga bo bu suuri m su ba juuri fɛn ni, ma wura má nnyɔ nu, i alecin m kaba kɔ tanaari jɔrɛ dii­biri n wɔ, na ma ma nɔɔ ka bu fa sɔnɔ n bra. ");
INSERT INTO cko_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Saŋga bo bu yasu jinaari na bu jaraki i ni, ba kan má satiɛ bo má m sunsun ka wɔ yo i na bu fa jaraki i ni. ");
INSERT INTO cko_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Ama, i ti akuruwa ye bu seeri a, fa kɔ bu nyɛmɛsu atin su, ni sɔnɔ be bo bu fere i ka Yesu n busu, bu ŋa wɔ wu, ama, Pɔɔlu ŋa i toko la ŋgɔɔ. ");
INSERT INTO cko_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Ma si má kabo m tara ahin jɔrɛ n tii ni i jaa barasu, na ma bisa Pɔɔlu ka, i koro ka ya fa i kɔ Yɛrusalem na bu kɔ di i jɔrɛ n dɔ, nzɛn sɛ? ");
INSERT INTO cko_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Ama, na Pɔɔlu asere ka, i koro ka i ka dan­saraka n nu haari i ba kɔ Roma­fɔm fɛmɛ kpiri n dɔ. Nyini ti, na ma ma nɔɔ ka bu subita i haari m ba nya atin na m ma bu fa i kɔ fɛmɛ kpiri n dɔ.” ");
INSERT INTO cko_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Na Fɛmɛ Agiripa ase Gomina Fɛsitosi ka, “M koro ka mini ni m tii ti ahin sɔnɔ n jɔrɛ ni.” Na Gomina Fɛsitosi ase i ka, “Ahunma a tí i jɔrɛ ni.” ");
INSERT INTO cko_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Tɔ, na i alecin, na Fɛmɛ Agiripa, ni Bɛrɛnisi afite ni bu fɛmɛya jirima bambaka, na bu ba wura tiɛntiɛn­bunɔɔ sɔɔ bambaka n nu, bu ni soja nkpiɛn­kpiɛnm, ni miɛ n nu minɛ anyunuyi­fɔm. Na Gomina Fɛsitosi ama nɔɔ, na ba fa Pɔɔlu awura. ");
INSERT INTO cko_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Na Gomina Fɛsitosi ase ka, “Ya si Fɛmɛ Agiripa, ni ambɛrɛ kɛrɛ bo am atiɛn am nɔɔ fɛn ni, am niɛ ahin sɔnɔ ni. Yiri dɛɛ ti ma Yuda­fɔm kɛrɛ bo bu wo Yɛrusalem, ni bo bu wo fɛn n yo baari m dɔ a, na bu sutiɛntiɛn ka i ti má ye ni ka i wo ni ŋgɔɔ. ");
INSERT INTO cko_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ama, m gusu afiiti i jɔrɛ n nu, ma ŋu má i ŋgasi bo wɔ do i na i ti ye ni ka i wu. Nyini ti, kabo yiri ni i tii asere ka m fa i jɔrɛ n kɔ Roma­fɔm fɛmɛ kpiri n dɔ ni, m fá i kɔ dɔ ɔ. ");
INSERT INTO cko_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Ama, m la má deke be tenle su bo m kɛrɛ fa ma fɛmɛ kpiri ni, fa kɔ ahin n jɔrɛ n su. Nyini ti ye ma fa i aba wɔrɔ Fɛmɛ Agiripa dɔ a, adena m ni ambɛrɛ kɛrɛ niɛ i jɔrɛ n nu, na m si deke bo m kɛrɛ kɔ ma fɛmɛ kpiri ni. ");
INSERT INTO cko_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Dama mini dɔ, wɔ kɔ má atin su ka m fa sɔnɔ bo ba nyi i dan­saraka kɔ ma fɛmɛ kpiri n na m la má jɔrɛ bo m kan kere i fa kɔ deke n bo i ti na bu jaraki i n su.” ");
INSERT INTO cko_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Na Fɛmɛ Agiripa ase Pɔɔlu ka, “Atin wo nu ka wɔrɔ ni u tii jɔjɔ.” Na Pɔɔlu ayɛ i saa su, na wɔ bo i jɔrɛ n bu, i ŋa, ");
INSERT INTO cko_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Fɛmɛ Agiripa, wɔ yo m fiɛ nyuma ka m jina u nyunu, na m kan m jɔrɛ n nahɔrɛ su fa kɔ deke n kɛrɛ bo Yuda­fɔm jaraki m n su. ");
INSERT INTO cko_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Dama wɔrɔ ni u tii asi kabo Yuda­fɔm nana sa­yoo­wam n ti, ni kabo ya se bu akuruwam barasu ni. Nyini dɛɛ ti, m sere u wɔ, ka a fa sawɔrɛ na a ti m jɔrɛ ni. ");
INSERT INTO cko_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Yuda­fɔm kɛrɛ si kabo m woo­wa yo ti barasu fite m gbɛfɛnɛya nu, saŋga bo m wo m bɔsu­fɔm nu ni, haari ni bo m kɔ woori Yɛrusalem miɛ kpiri n nu ni. ");
INSERT INTO cko_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Bu si m sa kabo m woo­wa yo ti, má nyuma. Nzɛn bu ŋa bu kan nahɔrɛ, bu se u ka m yo ti Farasi­fɔm be wɔ, na ma su ya dɛɛ nyini atin n bo i su ti kekereke n su ni anyum­boro. ");
INSERT INTO cko_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Kisa, deke bo i ti na m jina am nu nyuma na am sudi m jɔrɛ ni, yiri la tama n bo m la i fa kɔ deke n bo Nyɛmɛ seeri ka i yó ma ya nam ni. ");
INSERT INTO cko_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Nyini n ye ya anɔ buru ni nnyɔ n bo ya su Nyɛmɛ ni anyum­boro wiɛsu ni kɔŋguɛ n ŋminda ka ya nya i n a. Fɛmɛ, ti fɛn, nyini tama n bo m la i n dɛɛ ti, ye Yuda­fɔm jaraki m n a. ");
INSERT INTO cko_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Nzu ti ye am de má ka Nyɛmɛ koro teŋge minɛm bu yiwee nu a? ");
INSERT INTO cko_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Nahɔrɛ mini ni m tii yo sunsuunri ka wɔ yo daka ka m yo sam dɔŋgu na m saaki Yesu Nazarɛti­fɔ n duma. ");
INSERT INTO cko_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Kabo m yo yoori Yɛrusalem lɛɛ. Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ nkpiɛn­kpiɛnm yo maari m yiko, na ma tara Nyɛmɛ minɛm beberebe anyi bu dan­saraka, na saŋga bo bu diiri bu jɔrɛ na bu ŋa bu kun bu ni, mini mmɔɔ jina bu sin wɔ. ");
INSERT INTO cko_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Saŋga kɛrɛ saŋga, m nati wura ya tiɛntiɛn­bunɔɔ sɔɔm nu wɔ, na m sucin bu sui, na m sumiɛ bu ka bu kete Yesu. Na ma fa yaa bu ŋu agaya, haari na m sukɔ miɛ nyiŋgam su, kɔ sukere bu wuwuruwa.” ");
INSERT INTO cko_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Na Pɔɔlu asa su ase ka, “Nyini dɛɛ ti, na ma sere atin Nyɛmɛ sa­yoo­wa dɔŋgu­yo­fɔ nkpiɛn­kpiɛnm n dɔ, na ba ma m yiko ka m kɔ Damasiko miɛ kpiri n nu. ");
INSERT INTO cko_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Fɛmɛ, ti fɛn, m wo atin n nu wo kɔ su ni, fa kɔ wiɛ kekete saŋga, na ma ŋu sin be ka i fite aŋgoro, i ta tara wiɛ, na i wein ata abara ayɛ m ni minɛm kɛrɛ bo bu su m su ni. ");
INSERT INTO cko_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Na yɛrɛ kɛrɛ akpaasi haari asiɛŋgu, na ma ti akonvi be ŋga, ka i sujɔjɔ m dɔ Hiburu dɛɛ aniɛ n nu, i ŋa, ‘Sɔɔlu, Sɔɔlu e, nzu ti ye a kere m wuwuruwa sɔ a? A sukere u ŋu yaari ŋgbɛɛn wɔ, kabo bu fa toora dɔdɔɔri­fɔ sudɔ na i kete, na bu fin i baka n wɔ.’ ");
INSERT INTO cko_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Na ma bisa ka, ‘M Mibiɛ, wɔrɔ ŋma a?’ Na Mibiɛ n abɔ nu ka, ‘Mini Yesu ye a sukere m wuwuruwa n a. ");
INSERT INTO cko_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Ama, yasu jina. Deke n bo i ti na ma yi m ŋu akere u n la ka, m fa u yo m amusui­su­fɔ, na a di m daani kere minɛm fa kɔ deke bo a ŋu i nyuma n su, ni dekem bo m bá yi m ŋu kere u bekun n su. ");
INSERT INTO cko_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Na m dé u tii fite minɛm saa nu, Yuda­fɔm ni bo bu ti má Yuda­fɔm ni, dama m susunma u bɛrɛ dɔ a, ");
INSERT INTO cko_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","na a teke bu nyi, na a yi bu fite awosin nu ba wein nu, na a yi bu fite Sitana saa nu, na a fa bu wura Nyɛmɛ saa nu, adena bu yo m yarada na m fa bu satiɛ ce bu, na bu nya jinaa­biri Nyɛmɛ minɛ n nu, na bu kɛrɛ saŋga wo.’” ");
INSERT INTO cko_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Na Pɔɔlu asa su ase ka, “Fɛmɛ Agiripa, nyini dɛɛ ti ni, ma kete má deke n bo Nyɛmɛ yi kereeri m ka alɛlɛ nu dɛɛ su ni. ");
INSERT INTO cko_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Nyini ti, m du mɔ boori i bu Damasiko miɛ kpiri n nu wɔ, na ma kan akere bu ka bu kaaki bu wo na bu su Nyɛmɛ, na bu yo sakpa bo i kere ka ba kaaki bu wo. Na ma kɔ akan akere Yɛrusalem­fɔm n gusu, na ma nya akɔ akan akere Yudiya dɛɛ awɔrɛ n nu fɔm kɛrɛ. Nyini sin, na ma kɔ akan akere minɛm bo bu ti má Yuda­fɔm n gusu. ");
INSERT INTO cko_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Nyini dɛɛ ti, ye Yuda­fɔm taraari m Nyɛmɛ Seree­biri Awuru n nu, ka bu kun m n a. ");
INSERT INTO cko_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Ama, Nyɛmɛ abuka m dɛɛ ti, ye m toko wo bɛrɛ haari ni nyuma n a, adena m jina fɛn di daani kere nfaŋga­fɔm ni tarakam kɛrɛ, ni minɛ barasum kɛrɛ. M sukan má jɔrɛ fɔfɔrɛ be wɔ, má ka sam bo Nyɛmɛ nɔaniɛ kan­fɔm ni Moyisi yo seeri ka bu yó ni, ");
INSERT INTO cko_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","ka, wɔ yo daka ka Kristo, Tii­de­fɔ n bo Nyɛmɛ ase ka i súnma i ni bá di wahara. Yiri ti sɔnɔ bo i wú na i dú mɔ teŋge i yiwee n nu a. Na i kán wein n jɔrɛ kere Yuda­fɔm, ni minɛm bo bu ti má Yuda­fɔm n kɛrɛ.” ");
INSERT INTO cko_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Pɔɔlu wo nyini jɔjɔɔri n su na i kan i nahɔrɛ ni, na Gomina Fɛsitosi atiɛn i ŋu kpa, i ŋa, “Pɔɔlu, a bo fiɛ wɔ. U kara sɔnsɔn ni u si agaya n ma u tii yo má juma.” ");
INSERT INTO cko_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Na Pɔɔlu abɔ i nu ka, “Gomina Fɛsitosi jirima­fɔ, ma bo má fiɛ, ama, m jɔjɔ anyuŋkoro ni nahɔrɛ jɔrɛ wɔ. ");
INSERT INTO cko_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Fɛmɛ Agiripa si ahin jɔrɛm kɛrɛ, nyini dɛɛ ti, ye m la ahoresi jɔjɔ i nyunu n a. M si tenle su ka i si ahin sam n kɛrɛ bo m sukan kere am ni, dama i be mmɔɔ ayo má fiɛɛ­wa nu. ");
INSERT INTO cko_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Fɛmɛ Agiripa, a yo Nyɛmɛ nɔaniɛ kan­fɔm jɔrɛ n yarada a? M si tenle su ka a yo yarada.” ");
INSERT INTO cko_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Na Fɛmɛ Agiripa ase Pɔɔlu ka, “Ahin saŋga kaan nu, a sunsun ka a koro jɔjɔ na a ma m kaaki Kristo susu­fɔ ɔ, nzɛn sɛ?” ");
INSERT INTO cko_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Na Pɔɔlu abɔ i nu ka, “Nzɛn i cɛ o, i cɛ má o, mini yiri, m nyɛmɛsere la ka, wɔrɔ ni minɛm n kɛrɛ bo m sujɔjɔ am dɔ nyuma ni, am ba kaaki na am yo kabo m ti barasu ni, ama, bu wura má am jɔrɔkɔ kabo ba wura m ni.” ");
INSERT INTO cko_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","I seeri sɔ ni, na fɛmɛ n ayasu ajina, yiri ni gomina ni, ni Bɛrɛnisi, ni nyiŋgam n kɛrɛ bo bu tana bɛrɛ ni. ");
INSERT INTO cko_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Bu yasuuri na bu wo kɔ su ni, na ba se bu ŋuŋu nu ka, “Ahin sɔnɔ n ayo má sa be bo i ti ye ni ka bu kun i, wara bu nyi i dan­saraka nu.” ");
INSERT INTO cko_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Na Fɛmɛ Agiripa ase Gomina Fɛsitosi ka, “Nzɛn má ahin sɔnɔ n asere má ka bu fa i jɔrɛ n kɔ Roma­fɔm fɛmɛ kpiri n dɔ, má ya koro yaki i nu ji.” ");
INSERT INTO cko_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Tɔ, saŋga bo bu faari sɛsɛ­su ka ya fa lee bambaka kɔ Roma miɛ kpiri n bo i wo Itali n asiɛn n su ni, na ba fa Pɔɔlu ni dan­saraka nyiŋga nbem ama soja kpiɛn be bo bu fere i ka Juliyosi ni, yiri niɛ soja asɛsɛ be su a, bu fere i ka Roma­fɔm Fɛmɛ Kpiri Agusito dɛɛm. ");
INSERT INTO cko_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Na ya kɔ awura lee bambaka be, i fite miɛ n bo bu fere i ka Adaramuteno n wɔ. Lee n ayo siriya sukɔ Esiya awɔrɛ n nu dɛɛ miɛ nbem su, na ya wura i akɔ. Yɛrɛ ni sɔnɔ be bo bu fere i ka Arisitakusi n kɔɔri a, i fite Tɛsalonika miɛ kpiri n bo i wo Makɛdoniya awɔrɛ n nu wɔ. ");
INSERT INTO cko_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Na i alecin, na ya kɔ aju Sidon miɛ kpiri n nu, na Juliyosi ayo Pɔɔlu sakpa, i maari i atin wɔ, na wɔ kɔ aniɛ i danfom busu, adena i kɔ nya deke bo i koro. ");
INSERT INTO cko_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Ya yasuuri Sidon ka ya kɔ ni, ya faari Sipurusi lui bambaka n dɛɛ bue n wɔ, ya koro fa má deke bo má ya sukoro ka ya fa ni, dama aŋuma n cin ya kɔ ya sin wɔ. ");
INSERT INTO cko_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Ya yasu bɛrɛ ni, na ya kpiɛ tieku n bo i wo Silisiya, ni Pamfiliya dɛɛ awɔrɛm n nu ni, na ya nya akɔ aju miɛ kpiri n bo bu fere i ka Mira na i wo Lisiya dɛɛ awɔrɛ n nu ni. ");
INSERT INTO cko_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Dɔ na soja kpiɛn n aŋu lee bambaka be ka i fite Alɛkizanderiya miɛ kpiri n nu sukɔ Itali, na wɔ fa ya awura nu. ");
INSERT INTO cko_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Ya yasuuri bɛrɛ ka ya kɔ ni, aŋuma n kpa ya atin wɔ, ya koro akɔ má ndende. I yoori kekereke ye ya nya kɔ dodoori miɛ n bo bu fere i ka Kinidosi n a. Aŋuma n dɛɛ ti, ya koro akɔ má deke bo má ya sukɔ ni. Nyini dɛɛ ti, na ya fa lui bambaka n bo bu fere i ka Kereti dɛɛ bue ni, akpiɛ akɔ adodo miɛ n bo bu fere i ka Salamone ni. ");
INSERT INTO cko_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Ya faari bɛrɛ ni, i yoori ya kekereke ye ya nya kɔ juuri miɛ kpiri n bo bu fere i ka Dika Nyunyumi n a, lee ŋgbiŋgbirim jinaa­biri ni, i mata miɛ kpiri n bo bu fere i ka Lasiya n wɔ. ");
INSERT INTO cko_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Na ya wo dɔ acɛ, haari na Yuda­fɔm nɔɔ cici n aba asin, bu ŋa nyini saŋga ni, tieku n su natiiri ti tiɛ. Nyini dɛɛ ti, na Pɔɔlu abɔbɔ bu, i ŋa, ");
INSERT INTO cko_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Njam, ma ŋu ka nzɛn ya ŋa ya kɔ ya nyunu, i yó kekereke, na deke dɔŋgu sáaki, má lee bambaka n ni neŋgem ŋgumi, ama, ya ŋgɔɔ mmɔɔ wo nu.” ");
INSERT INTO cko_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Ama, haari ni nyini mmɔɔ, soja kpiɛn n keteeri Pɔɔlu nɔaniɛ n wɔ, na wɔ de lee­kan­fɔ n ni lee n fɔ n dɛɛ nɔaniɛ ni. ");
INSERT INTO cko_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Deke bo ya wo ni, i ti má kpa ka ya wo dɔ haari fufuku ba tu ya, nyini dɛɛ ti, na ya dɔŋgu asoro su ka ya yasu dɔ, na ya niɛ, beni, ya koro kɔ ju miɛ kpiri n bo bu fere i ka Foniki n su na i wo Kereti lui bambaka n su ni. Lee ŋgbiŋgbirim jinaa­biri wo dɔ ɔ, i nɔɔ wɔ wiɛ atɔɔri dɛɛ bue n wɔ, ya koro kɔ wo dɔ, haari na fufuku n ba sin. ");
INSERT INTO cko_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Na aŋuma fafari be sukpiɛ fite ya nyunu ndiɛma biɛ su. Na ba sunsun ka bu koro kɔ deke bo ba fa bu tii awɔ ni. Nyini dɛɛ ti, na ba cin atu bulaari n bo bu fa kpamaari lee ni, na ya san tieku n ahɛmɛ akɔ adodo Kereti lui bambaka n dɛɛ bue ni. ");
INSERT INTO cko_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Ama, wɔ cɛ má, na sɔɔ sin aŋuma be bo i nati kpiɛ fite wiɛ afiiri saa fɔmbɔrɔ su n akpiɛ faŋga su afite Kereti dɔ. ");
INSERT INTO cko_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Ya kpa aŋuma n atin wɔ, ya koro akɔ má deke bo ya fa ya tii awɔ ni. Nyini dɛɛ ti, na ya yaki lee bambaka ni, na wɔ su aŋuma n su. ");
INSERT INTO cko_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Na ya kɔ adodo lui be bo bu fere i ka Kawuda ni, na ya fa i sin. Lee kaan be sa lee bambaka n su, i yoori kekereke ye ya nya koro taraari i jinaari a. ");
INSERT INTO cko_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Na ba nya acin i afun awura lee bambaka n nu. Na ba fa nyama awura lee bambaka n bu, na ba cici i kenken, na i bu n ayo faŋga. Bu soro sɛrɛ ka lee ni kpama tɛtɛkɛ n dika wɔ, miɛ kaan be wo bɛrɛ, bu fere i ka Siritisi. Nyini dɛɛ ti, na ba jura lee tani n bo i bo aŋuma na lee n kɔ ni, na ba nyanya i, na lee n asu aŋuma n su. ");
INSERT INTO cko_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Kabo aŋuma n kereeri ya wahara sɔ ni, i alecin, na ba yiyi neŋgem bo bu wo lee n nu ni nbem ajiji nzue n nu. ");
INSERT INTO cko_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","I le­san cɛɛn, na bu kɛrɛ afa bu saa ayi lee n dɛɛ neŋge kɛrɛ aji nzue n nu. ");
INSERT INTO cko_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Na wɔ cɛ bo ya ŋu má wiɛ, wara asara­mbaam, na aŋuma n sukpiɛ agaya sɔ, haari na ya ba ayi tama ka ya fite má nu. ");
INSERT INTO cko_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Tɔ, wɔ cɛ bo minɛm n adi má diire n dɛɛ ti, na Pɔɔlu ayasu ajina bu afiɛn, na wɔ se bu ka, “Njam, nzɛn má am tiiri m nɔaniɛ ni, má ya yasu má Kereti, má ya neŋgem ni saaki má, na bu ka ŋgbɛɛn sɔ. ");
INSERT INTO cko_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Ama, kisa, m sutu am fɔ ɔ, am ma am ahoresi. Am be mmɔɔ ŋgɔɔ ká má nu, má ka lee bambaka ni ŋgumi saaki a. ");
INSERT INTO cko_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Dama anuma kɔŋguɛ, Nyɛmɛ n bo m su i na i dɛɛ la m ni, i mɛrɛkɛ be ba jinaari m bi, ");
INSERT INTO cko_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","na wɔ se m ka, ‘Pɔɔlu, má a ma sɛrɛ ti u. Wɔ yo daka ka a kɔ́ jina Roma­fɔm fɛmɛ kpiri n nyunu wɔ, na i dí u jɔrɛ. Ti fɛn, Nyɛmɛ afa minɛm kɛrɛ bo u ni bɛrɛ saŋga wo lee n nu n ama u.’ ");
INSERT INTO cko_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Nyini ti, njam, am fa ahoresi. Dama m daafi Nyɛmɛ ŋu ka i yó kabo i seeri m n wɔ. ");
INSERT INTO cko_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Haari ni nyini mmɔɔ, aŋuma ni sún ya kɔ jina lui bambaka be su wɔ.” ");
INSERT INTO cko_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Tɔ, i bita ya fikindi Adiriya tieku n nu sɔ ɔ, haari i le­buru le­nna cɛɛn kɔŋguɛ fa kɔ i jinanjin saŋga, na lee juma­yo­fɔm n afa nu ka bu sudodo asiɛn. ");
INSERT INTO cko_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Nyini ti, na ba fa nyama bo bu bita sunsun niɛ kabo nzue ŋgoŋgo ti barasu. Na ba ŋu ka i toko wo ŋgo. Na ba kɔ mɔ kaan abuka su, na ba sunsun bekun, na ba ŋu ka i wo má ŋgo kun. ");
INSERT INTO cko_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Na sɛrɛ ati bu, bu sunsun ka lee bambaka ni kɔ́ si yabuɛm wɔ, na i sandi nu, nyini dɛɛ ti, na ba cɔɔndi lee n sin bulaari nɔnɔɔri nna asiɛŋgu. Na bu susere Nyɛmɛ ka ale cin bu. ");
INSERT INTO cko_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Na lee juma­yo­fɔm n akoro ka bu wɔ ŋmati, na ba yi lee kaan n afa ase nzue n su, na ba kpiɛ mbɛnlɛ ka bu suyi bulaari nɔnɔɔri nbem lee bambaka n tii dika a. ");
INSERT INTO cko_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Ama, na Pɔɔlu ase soja kpiɛn n ni i sojam ni ka, “Má ka ahin minɛm n aka lee n nu, am be mmɔɔ fíte má nu.” ");
INSERT INTO cko_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Na sojam n akpiɛ nyamam bo bu bita lee kaan n aji, na wɔ kɔ. ");
INSERT INTO cko_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Saŋga bo ale ba sukoro cin ni, na Pɔɔlu asere minɛm kɛrɛ ka, bu nya diire be di. I ŋa, “I nyuma le­buru le­nna lɛɛ, bo am wo ahoresaaki nu, na am adi má pui. ");
INSERT INTO cko_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Nyini ti, m sere am wɔ, am di diire, adena i buka am na am nya ŋgɔɔ. Haari am be mmɔɔ tii­ŋmiɛ kun n kpein ká má ŋgbɛɛn.” ");
INSERT INTO cko_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Pɔɔlu seeri sɔ wieeri ni, na wɔ fa kpɔnɔ, na wɔ da Nyɛmɛ asi bu kɛrɛ nyunu, na wɔ bu i nu, na wɔ di. ");
INSERT INTO cko_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Na bu kɛrɛ afa ahoresi, na bɛrɛ gusu adi diire. ");
INSERT INTO cko_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Yɛrɛ bo ya yo woori lee bambaka n nu ni, ya ti minɛ yaa nnyɔ ni minɛ abura­so ni nsɛn wɔ. ");
INSERT INTO cko_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Bɛrɛ kɛrɛ diiri na bu kunnu yiiri ni, na ba sasa diire mbaa n bo wɔ ka n agɔ nzue n nu, adena lee bambaka n ka fafaki. ");
INSERT INTO cko_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Saŋga bo ale ba ciinri ni, lee juma­yo­fɔm ŋuuri asiɛn be, ba si má i, ama, na ba ŋu ka nzue be ati ada bɛrɛ, ŋmiɛ abara ayɛ i. Na ba fa sunsunni ka nzɛn má bu koro yo, na ba boro bu nyi na bu fa lee bambaka n kɔ wura ŋmiɛ n nu na i kpama. ");
INSERT INTO cko_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Na ba nyaŋgi lee bambaka n bulaari nɔnɔɔrim n aji nzue n nu, na ba nyaŋgi bakam bo bu fa kan lee n dɛɛ nyamam ni, na ba yɛ tani n bo i wo lee n tii su n aŋgoro ka aŋuma n fa lee n kɔ, na bu sukan sukɔ ahɛmɛ. ");
INSERT INTO cko_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Ama, na ba kɔ aju kunma kpiri saŋgaa­biri, na ba wura ŋmiɛ be nu, na lee bambaka n tii dika n aka akpama, wɔ koro akɔ má. Na nzue nyama ni subo lee ni, na wɔ paparaki i sin dika ni. ");
INSERT INTO cko_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Na sojam n asɛsɛ su ka bu kun dan­sarakam n kɛrɛ wɔ, adena má be wiɛ kpiɛ na i ŋmati kɔ. ");
INSERT INTO cko_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Ama, soja kpiɛn n koroori ka i de Pɔɔlu tii ji n dɛɛ ti, na wɔ kete bu ŋu ka má bu yo sɔ. Na wɔ ma nɔɔ ka, bo bu si nzue wiɛ n kɛrɛ, bu du mɔ ti to nu na bu wiɛ kpiɛ kpɛrɛ su, ");
INSERT INTO cko_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","na minɛm bo bu kaari n kɛrɛ nya so baka sinsinm, ni lee buebuem n nu, na bu wiɛ kɔ ju ahɛmɛ. Kabo i yoori na ya kɛrɛ koro fiteeri nu, na pui ayo má be n lɛɛ. ");
INSERT INTO cko_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Saŋga bo ya fiteeri nzue n nu wieeri ni, na ba se ya ka bu fere lui bambaka n ka Malite. ");
INSERT INTO cko_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Na miɛ n nu­fɔm ade ya na ba yo ya sakpa agaya. Nzue sutɔ na ayɛrɛ wo bɛrɛ n dɛɛ ti, na ba tɔrɔ sin ama ya, na ya kɛrɛ atun. ");
INSERT INTO cko_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Na Pɔɔlu atiɛntiɛn yee nɔɔ agɔ sin n nu, jaa pumpuni wo yee n nu, na sin n waraŋgu awura i, na wɔ fite akan i saa aka asense su. ");
INSERT INTO cko_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Miɛ n nu­fɔm ni ŋuuri ka woo n akan asense Pɔɔlu saa su sɔ ni, na ba se bu ŋuŋu nu ka, “Ahin sɔnɔ n ti sɔnɔ kun­fɔ ɔ nahɔrɛ su, haari ni bo wɔ koro afite n nzue n nu ni, i nyɛmɛ atin su, wɔ yo má daka ka i nyá ŋgɔɔ.” ");
INSERT INTO cko_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Ama, na Pɔɔlu akpisi woo n aji sin n nu, wɔ ŋu má yaari be. ");
INSERT INTO cko_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Na minɛm n asunsun ka i cɛ́ má, i ŋuniɛ wúra a, wara i kába kpaasi wu. Ama, bu ŋminda cɛɛri na bu ŋu má ka deke be ayo i ni, na ba kaaki bu sunsunni, na ba se ka, “I ti nyɛmɛ be wɔ.” ");
INSERT INTO cko_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Deke bo ya sekeeri ni, fie be wo dodo dɔ, i fɔ n ti lui bambaka n su sɔnɔ anyumbaa­fɔ ɔ, bu fere i ka Pubiliyosi. Na wɔ de ya wɔfɔ nyunyumi, na ya ka ada i dika haari le­san. ");
INSERT INTO cko_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Nyini saŋga Pubiliyosi si gusu la má laifiɛ, i da sɔrɔ, i ŋuniɛ ado, na i suje tɔtɔkɔ. Na Pɔɔlu awura sɔɔ n bo i da nu ni, na wɔ fa i saa anana i ŋu, na wɔ sere Nyɛmɛ ama i, na wɔ nya laifiɛ. ");
INSERT INTO cko_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","I yoori sɔ n dɛɛ sin, na tukpaki­fɔm kɛrɛ bo bu wo lui bambaka n su n gusu aba Pɔɔlu dɔ, na wɔ tuntun bu, na ba nya laifiɛ. ");
INSERT INTO cko_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Na ba wura ya kpiri, na ba ce ya aceerim beberebe. Na saŋga bo ya ba suyasu ka ya fa lee na ya kɔ ni, na ba fa deke kɛrɛ bo i ti ya miɛɛ­wa awura lee bambaka n nu ama ya. ");
INSERT INTO cko_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Ya woori dɔ haari sara nsan, na ya nya fa lee bambaka be bo i fite Alɛkizanderiya dɛɛ miɛ kpiri n nu wɔ. Amɔɛ ndaam anyaari see­wa mata i. Fufuku saŋga n dɛɛ ti, wɔ jina dɔ acɛ. ");
INSERT INTO cko_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Na ya kɔ aju miɛ kpiri n bo bu fere i ka Sarakusasi n su, na ya wo dɔ le­san. ");
INSERT INTO cko_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Na ya nya akaaki ayasu bɛrɛ bekun, akɔ aju miɛ kpiri n bo bu fere i ka Regiyoni n su. Na i alecin, na aŋuma abo i bu sukpiɛ fite ya nyunu ndiɛma saa biɛ su. Na i le­nnyɔ cɛɛn n na ya kɔ aju miɛ kpiri n bo bu fere i ka Potiyoli n su. ");
INSERT INTO cko_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Na ya ŋu yarada­yo­fɔ nbem dɔ, na ba sere ya ka ya wo bu dɔ le­so. Na ya nya yasu aba Roma miɛ kpiri n nu. ");
INSERT INTO cko_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Saŋga bo yarada­yo­fɔm n bo bu wo Roma n tiiri ya ŋga ka ya suba ni, na ba fite akpa ya atin, na ya ni bu nbem akɔ ayɛ miɛ n bue bo bu fere i ka Apiyɔsi Gɔɔ n su, na ya ni bu nbem gusu akɔ ayɛ Wɔfɔm Daa­biri Awuru Nsan miɛ n nu. Saŋga bo Pɔɔlu ŋuuri bu ni, na wɔ da Nyɛmɛ asi, na wɔ nya ahoresi. ");
INSERT INTO cko_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Saŋga bo ya kɔ juuri Roma miɛ kpiri n nu ni, na ba ma Pɔɔlu atin ka i nya awuru be na yiri ni i tii suwo nu, na ba ma i soja kun ka i suniɛ i dika. ");
INSERT INTO cko_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","I woori dɔ i le­san, nyini sin, na Pɔɔlu afere Yuda­fɔm bo bu la anyunuyi na bu wo miɛ n nu ni, ka bu tiɛn bu nɔɔ. Bu tiɛn bu nɔɔ wieeri ni, na wɔ se bu ka, “M ninbaam, ma yo má ya minɛm n sa be, ma bu má ya nana sa­yoo­wa n be ŋgbɛɛn, ama, haari ni nyini mmɔɔ, bu taraari m Yɛrusalem miɛ kpiri n nu wɔ, na ba nya afa m awura Roma­fɔm saa nu. ");
INSERT INTO cko_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Bɛrɛ gusu bisaari m bisaa­wam wieeri ni, má bu ŋa bu fa m ji wɔ, dama ba ŋu má satiɛ bo ma yo i na i ti ye ni ka bu kun m. ");
INSERT INTO cko_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Ama, na Yuda­fɔm n akete ka má Roma­fɔm n yaki m nu ji, na wɔ yo daka ka m sere ka bu fa m jɔrɛ n kɔ Roma­fɔm fɛmɛ kpiri n dɔ, haari ni bo m la má jɔrɛ be bo m fa jaraki m tiɛŋgu minɛm ni. ");
INSERT INTO cko_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Nyini dɛɛ ti, ye m fere am a, na m jɔjɔ am dɔ na am si bo i wo bɛrɛ, ka, sɔnɔ n bo Yisareli­fɔm yo i tama n dɛɛ ti, ye m wo ahin jɔrɔkɔ n nu a.” ");
INSERT INTO cko_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Na ba se ka, “Ya nya de má kadasi be Yudiya­fɔm dɔ fa kɔ u jɔrɛ su. Ya minɛm bo bu fiteeri dɔ baari n gusu, be nya kan má, wara i jɔjɔ jɔrɛ tiɛ be fa kɔ u dɔ. ");
INSERT INTO cko_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Ama, ya koro ka ya ti fite u dɔ kabo u sunsunni ti, dama ya si ka nyini atin n bo a bita i ni, deke kɛrɛ bo a kɔ, minɛ jaraki i wɔ.” ");
INSERT INTO cko_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Na ba kpama cɛɛn ka bu tiɛn bu nɔɔ. Nyini cɛɛn n na minɛ beberebe aba atiɛn bu nɔɔ deke bo Pɔɔlu da ni. Na wɔ kan akere bu kabo Nyɛmɛ fɛmɛya n atin ti barasu. Fite ŋgarama haari kɔŋguɛ, na wɔ boro i nyi na i ma bu si kabo Yesu ti barasu, fite kabo ba kɛrɛ i Moyisi dɛɛ nɔaniɛ kpamaa­wa kadasi n nu ni, ni kabo ba kɛrɛ i Nyɛmɛ nɔaniɛ kan­fɔm dɛɛ kadasi n nu ni. ");
INSERT INTO cko_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Na bu nbem ade i nɔaniɛ ni, ama, na nbem akete, ba yo má yarada. ");
INSERT INTO cko_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Nyini ti, bu nɔɔ ayo má kun, na ba yasu ka bu kɔ awuru, na Pɔɔlu ase bu jɔrɛ kun be abuka su, i ŋa, “Nahɔrɛ ye Nyɛmɛ Awiɛwiɛ Casi n jɔjɔɔri am jɔrɛ n a. I yo maari Nyɛmɛ nɔaniɛ kan­fɔ Esaya seeri am nam ka, ");
INSERT INTO cko_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‘Kɔ na a kɔ se nyini minɛm ka, Nyɛmɛ ŋa o, Am só am sui ni nahɔrɛ su, ama, am tí má deke bo am so am sui ka am ti i n bu. Am káaki niɛ ni nahɔrɛ su, ama, am ŋú má pui. ");
INSERT INTO cko_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Dama ahin minɛm tii ti kekereke, ba tɔ bu sui na má bu ti, ba kata bu nyu­mbaa na má bu ŋu. Má nyini, bu nyu­mbaa ŋú i wɔ, na bu sui tí, na bu sí bu ahore su, na bu káaki bu wo, na m má bu nya laifiɛ.’” ");
INSERT INTO cko_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Na Pɔɔlu akun i jɔjɔɔ­wa n nɔɔ, na wɔ se bu ka, “Nyini ti, m koro ka am si ka Nyɛmɛ asunma ya ka ya fa tii­de labari kpa n kɔ ma minɛm bo bu ti má Yuda­fɔm ni. Bɛrɛ dé i a.”  ");
INSERT INTO cko_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Na Pɔɔlu kaanri sɔ wieeri ni, na Yuda­fɔm n ayasu afite akɔ ase akuruwa nyannyan bu ŋuŋu nu. ");
INSERT INTO cko_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Na Pɔɔlu ade sɔɔ, na i sutɔ kaari, na wɔ wo nu haari afɔ nnyɔ, na i sude minɛm kɛrɛ bo bu ba i dɔ ni, ");
INSERT INTO cko_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","na i sukan Nyɛmɛ fɛmɛya n ŋusu jɔrɛ, na i sukere minɛm ya Mibiɛ Yesu Kristo jɔrɛ ni ahoresi, be akanda má i.");
INSERT INTO cko_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Mini Pɔɔlu sukɛrɛ ahin kadasi n fa ma am a. M ti Yesu Kristo akɔɔ ɔ, ye wɔ fere m ka m kaaki i jaramasa, na wɔ yi m ka m kan labari kpa n bo i fite Nyɛmɛ dɔ n jɔrɛ. ");
INSERT INTO cko_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Nyini labari kpa n ye Nyɛmɛ yo seeri ka i fá ma ya n a, na wɔ ma i nɔaniɛ kan­fɔm akɛrɛ i ŋusu jɔrɛ ase i jɔrɛ kadasi n nu. ");
INSERT INTO cko_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Nyini labari kpa n kere ya i Wa n jɔrɛ wɔ, nzɛn ya niɛ i fa kɔ i adamande dɛɛ woo­wa su, bu yo wuuri i fiteeri Fɛmɛ Davidi dɛɛ busu n nu n wɔ. ");
INSERT INTO cko_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Ama, kabo Nyɛmɛ faari i yiko teŋgeeri i yiwee nu ni, nyini ma Awiɛwiɛ Casi n kere ka i ti Nyɛmɛ Wa a, yiri la ya Mibiɛ Yesu Kristo ni. ");
INSERT INTO cko_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Yiri dɛɛ ti, ma di Nyɛmɛ ahɔrɔma, ye wɔ ma ma yo i jaramasa, adena i duma n dɛɛ ti, na m ma daanfiɛ barasu kɛrɛ de i nɔaniɛ ni, na bu yo i yarada. ");
INSERT INTO cko_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Ambɛrɛ Roma­fɔm gusu, am wo nyini minɛm bo Nyɛmɛ afere bu n nu wɔ, ka am kaaki Yesu Kristo dɛɛ minɛm. ");
INSERT INTO cko_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Tɔ, ambɛrɛ bo am wo Roma miɛ kpiri n nu ni, ye m sukɛrɛ ahin kadasi n ma am a. Ambɛrɛ bo Nyɛmɛ koro am na wɔ fere am na am ayo i dɛɛ minɛm ni, ya Si Nyɛmɛ ni ya Mibiɛ Yesu Kristo ma am wura bu ahɔrɔma nu na am nya ahoreda. ");
INSERT INTO cko_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Ciciri su, Yesu Kristo dɛɛ ti, m da m Nyɛmɛ asi ma am kɛrɛ, dama durunya n nu­fɔm kɛrɛ ati kabo am ayo Yesu Kristo yarada ni. ");
INSERT INTO cko_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Nyɛmɛ bo m su i ni m ahore­mbaa kun ni, na m kan i Wa n labari kpa n jɔrɛ ni, yiri di m daani a, kabo m nati sere Nyɛmɛ ma am ni. ");
INSERT INTO cko_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Saŋga kɛrɛ m sere i wɔ, ka nzɛn i ti i dɛɛ koroya­nu, i teke atin ma m kisa, na i awieeri su na m koro ba niɛ am busu. ");
INSERT INTO cko_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Dama m nyunu aboro ka m bá ŋu am wɔ, adena m fa aceeri n bo i fite Awiɛwiɛ Casi n dɔ ba ma am na am koro jina faŋga kenken ni nyɛmɛsu ni. ");
INSERT INTO cko_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Nahɔrɛ, i ti deke bo ya fa ma ya beŋgu na ya nya ahoresi wɔ, m ni ambɛrɛ kɛrɛ, kabo ya yo Yesu yarada n dɛɛ ti. ");
INSERT INTO cko_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","M ninbaam, m koro ka am si ka saŋga kɛrɛ, má m koro ka m bá niɛ am busu wɔ, ama, m nya má atin. Má m koro ka m ba nya minɛ am nu ma Nyɛmɛ wɔ, kabo ma nya am beŋgu nbem bo bu ti má Yuda­fɔm ni. ");
INSERT INTO cko_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Dama wɔ yo daka ka m yo sɔ ma minɛ barasu kɛrɛ, bo bu nyunu ateke, ni bo bu nyunu ateke má, ni bo ba sɔnsɔn kara, ni bo ba sɔnsɔn má kara. ");
INSERT INTO cko_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Nyini dɛɛ ti, ye m ahore abi ka m ba kan labari kpa n jɔrɛ kere ambɛrɛ gusu bo am wo Roma miɛ kpiri n nu n a. ");
INSERT INTO cko_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Nyinsɛ ti má m fa kɔ labari kpa n su, dama yiri ti Nyɛmɛ yiko bo i ma sɔnɔ kɛrɛ bo i yo yarada n nya tii­de a, bo bu ti Yuda­fɔm ni du mɔ a, na bo bu ti má Yuda­fɔm n nya tɔ su. ");
INSERT INTO cko_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Labari kpa n kere kabo Nyɛmɛ de sɔnɔ ka i yo sa bo i kɔ atin su i dɔ a. Sɔnɔ kɛrɛ bo i yo yarada, i fite i yarada­yo n dɛɛ ti ye Nyɛmɛ de i mi ka i yo sa bo i kɔ atin su i dɔ a, na nyini ma i yarada n yo bii­wa. Kabo ba kɛrɛ i Nyɛmɛ Jɔrɛ Kadasi n nu ka, Nyɛmɛ ŋa, “Sɔnɔ bo i yo sa bo i kɔ atin su m dɔ, i nyá ŋgɔɔ, i yarada n dɛɛ ti.” ");
INSERT INTO cko_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Nyɛmɛ wo aŋgoro akere kabo wɔ fa yaa acin minɛm sui ni, bɛrɛ bo bu sunsunni ti tiɛ na bu yo satiɛ ni, bu satiɛ n dɛɛ ti, ba kete ka má minɛm si Nyɛmɛ nahɔrɛ su. ");
INSERT INTO cko_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Deke bo i ti na wɔ fa yaa n la ka, ba ŋu deke n kɛrɛ bo i ma bu si Nyɛmɛ ni, dama yiri ni i tii ayi i kpain afite fofoe nu. ");
INSERT INTO cko_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Fite saŋga bo Nyɛmɛ yiiri durunya n ba juuri ni kisa, minɛ aŋu i woo­wa, i ti má ka bu nyu­mbaa aŋu i kabo i ti barasu wɔ, ama, ba ŋu dekem bo wɔ yi bu ni. Nyini dekem ni kere ka i ti Nyɛmɛ nahɔrɛ su a, ni kabo i la yiko bo i la má awieeri ni. Nyini ti, be wo má bɛrɛ bo i koro se ka i si má i. ");
INSERT INTO cko_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Haari ni bo bu si i n kɛrɛ, ba kete ka bu ma má i jirima ka i ti Nyɛmɛ, na bu kaaki da má i asi. Nyini dɛɛ ti, ye bu sunsunni kɛrɛ aka ŋgbɛɛn ye ŋgɔnlɛ akpiɛ bu su, ye bu ahore­mbaa ayo biri n a. ");
INSERT INTO cko_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Bu bu bu ŋu ka bu ti ŋgɔnlɛ­fɔm wɔ, ama, bu ti sinnzinm wɔ. ");
INSERT INTO cko_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Jirima bo má bu fa ma Nyɛmɛ bo i wo bɛrɛ saŋga kɛrɛ ni, ba fa ama amɔɛm bo ba yo bu na bu ferema ni adamandem, ni laŋkpɛtɛ­fɔm, ni ajaa­nnam, ni cin­bukunnu­su­fɔm wɔ. ");
INSERT INTO cko_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Nyini dɛɛ ti, ye Nyɛmɛ ayaki bu ye bu yo bu kunnu koroo­wa n a, na bu suyo daŋgba sam bu ŋuŋu nu suwura bu ŋu nyinsɛ. ");
INSERT INTO cko_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Dama ba kete Nyɛmɛ nahɔrɛ­fɔ ni, na bu nya susu kɔrɛ su. Na bu su dekem bo Nyɛmɛ ayi bu ni, bu su má yiri bo i yiiri deke n kɛrɛ ni. Yiri dɛɛ la kansi saŋga kɛrɛ a. Ami. ");
INSERT INTO cko_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Ba kete Nyɛmɛ n dɛɛ ti, ye wɔ yaki bu a, na bu suyo nyinsɛ sam kabo bu kunnu koro n a, haari na nbaram yaki nbiɛsɔm dɔ daari, na bu sufa bu beŋgu nbaram da, na bu yo kabo má wɔ yo má daka ka bu yo ni. ");
INSERT INTO cko_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Na nbiɛsɔm n gusu yaki nbaram dɔ daari, na bu la konviki agaya fa kɔ bu beŋgu nbiɛsɔm dɔ, na bu ni bɛrɛ saŋga da ka bara ni biɛsɔ dɛɛ su. Nyini nyinsɛ sam dɛɛ ti, ye ba nya sui­cin kabo wɔ yo daka ka bu nya i n a. ");
INSERT INTO cko_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Kabo ba kete ka bu si má Nyɛmɛ ni, nyini ma wɔ yaki bu, ye bu sunsunni tiɛ n ma bu yo sa bo má wɔ yo má daka ka bu yo i n a. ");
INSERT INTO cko_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Bu ahore­mbaa ayi ni satiɛ barasu kɛrɛ ŋgumi wɔ, bu konviki wur