﻿USE sofia;
DROP TABLE IF EXISTS sofia.ckb_vpl;
CREATE TABLE ckb_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ckb_vpl WRITE;
INSERT INTO ckb_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","لە سەرەتادا خودا ئاسمان و زەویی بەدیهێنا. ");
INSERT INTO ckb_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","زەویش بێ شێوە و بەتاڵ بوو، تاریکیش لەسەر ڕووی قووڵاییەکان بوو. ڕۆحی خوداش لەسەر ڕووی ئاوەکان دەجوڵایەوە. ");
INSERT INTO ckb_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","خودا فەرمووی: «با ڕووناکی ببێت.» ئینجا ڕووناکی بوو. ");
INSERT INTO ckb_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","خوداش بینی کە ڕووناکییەکە باش بوو. ئیتر خودا ڕووناکییەکەی لە تاریکی جیا کردەوە. ");
INSERT INTO ckb_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","خودا ڕووناکییەکەی ناو نا «ڕۆژ» و تاریکییەکەی ناو نا «شەو.» ئێوارە بوو، بووە بەیانی، ئەمە ڕۆژی یەکەم بوو. ");
INSERT INTO ckb_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","خودا فەرمووی: «با بۆشاییەک لەنێوان ئاوەکاندا ببێت، بۆ جیابوونەوەی ئاو لە ئاو.» ");
INSERT INTO ckb_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","جا ئاوا بوو. خودا بۆشاییەکەی دروستکرد و ئاوەکەی ژێر بۆشاییەکەی لە ئاوەکەی سەر بۆشاییە کراوەکە جیا کردەوە. ");
INSERT INTO ckb_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","خودا بۆشاییەکەی ناو نا «ئاسمان.» جا ئێوارە بوو، بووە بەیانی، ئەمە ڕۆژی دووەم بوو. ");
INSERT INTO ckb_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","خودا فەرمووی: «با ئاوەکانی ژێر ئاسمان لە یەک شوێن کۆببنەوە و وشکانی دەربکەوێت.» جا ئاوا بوو. ");
INSERT INTO ckb_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","خودا وشکانییەکەی ناو نا «زەوی». ئاوە کۆبووەوەکەشی ناو نا «دەریا». خوداش بینی کە ئەمە باش بوو. ");
INSERT INTO ckb_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","ئینجا خودا فەرمووی: «با زەوی سەوزایی بەرهەم بهێنێت: ڕووەکی تۆودار و داری بەردار لەسەر زەوی، ئەوەی تۆوەکەی لەناو خۆیەتی، لە جۆری خۆی.» جا ئاوا بوو. ");
INSERT INTO ckb_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","زەوی سەوزایی بەرهەم هێنا: ڕووەکی تۆودار لە جۆری خۆی و دار کە بەر دروستبکات و تۆوەکەی تێدابێت لە جۆری خۆی. خوداش بینی کە ئەمە باش بوو. ");
INSERT INTO ckb_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","جا ئێوارە بوو، بووە بەیانی، ئەمە ڕۆژی سێیەم بوو. ");
INSERT INTO ckb_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","ئینجا خودا فەرمووی: «با لە بۆشایی ئاسماندا ڕووناکییەکان هەبن بۆ جیاکردنەوەی ڕۆژ لە شەو، هەروەها بۆ نیشانکردنی وەرز و ڕۆژ و ساڵ. ");
INSERT INTO ckb_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","با ڕووناکییەکان لە بۆشایی ئاسماندا ببن، تاکو سەر زەوی ڕووناک بکەنەوە.» جا ئاوا بوو. ");
INSERT INTO ckb_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","هەروەها خودا دوو ڕووناکییە مەزنەکەی دروستکرد، ڕووناکییە گەورەکەیان بۆ فەرمانڕەوایەتی ڕۆژ، ڕووناکییە بچووکەکەشیان بۆ فەرمانڕەوایەتی شەو، هەروەها ئەستێرەکانیش. ");
INSERT INTO ckb_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","خودا لە بۆشایی ئاسماندا بۆ ڕووناککردنەوەی سەر زەوی داینان، ");
INSERT INTO ckb_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","بۆ فەرمانڕەوایەتی ڕۆژ و شەو و جیاکردنەوەی ڕووناکی لە تاریکی. خوداش بینی کە ئەمە باش بوو. ");
INSERT INTO ckb_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","جا ئێوارە بوو، بووە بەیانی، ئەمە ڕۆژی چوارەم بوو. ");
INSERT INTO ckb_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","ئینجا خودا فەرمووی: «با ئاوەکان پڕ ببن لە ئاپۆرەی بوونەوەری زیندوو، با باڵندەش لە بۆشایی ئاسماندا بەسەر زەویدا بفڕێت.» ");
INSERT INTO ckb_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","ئیتر خودا بوونەوەرە مەزنەکانی دەریای بەدیهێنا، لەگەڵ هەموو زیندەوەرە جوڵاوەکانی ناو ئاوەکان کە لێی پڕبوون، بەپێی جۆرەکانیان، لەگەڵ هەموو باڵندەیەکی باڵداریش بەپێی جۆرەکانیان. خوداش بینی کە ئەمە باش بوو. ");
INSERT INTO ckb_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","خودا بەرەکەتداری کردن و فەرمووی: «بەردار بن و زۆر بن و ئاوی دەریاکان پڕ بکەن، با باڵندەکانیش لەسەر زەوی زۆر ببن.» ");
INSERT INTO ckb_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","جا ئێوارە بوو، بووە بەیانی، ئەمە ڕۆژی پێنجەم بوو. ");
INSERT INTO ckb_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","خودا فەرمووی: «با زەوی بوونەوەرە زیندووەکان لە جۆری خۆیان بەرهەم بهێنێت. ئاژەڵی ماڵی و خشۆکی زەوی و ئاژەڵی کێوی، هەریەکەیان لە جۆری خۆی.» جا ئاوا بوو. ");
INSERT INTO ckb_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","خودا ئاژەڵی کێوی بەپێی جۆری خۆیان دروستکرد، ئاژەڵی ماڵیش بەپێی جۆری خۆیان و هەموو خشۆکێکیش لەسەر زەوی بەپێی جۆری خۆیان. خوداش بینی کە ئەمە باش بوو. ");
INSERT INTO ckb_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","ئینجا خودا فەرمووی: «با مرۆڤ لەسەر وێنەی خۆمان دروستبکەین و لە خۆمان بچێت. با دەسەڵاتدار بن بەسەر ماسی دەریا و باڵندەی ئاسمان و ئاژەڵی ماڵی و بەسەر هەموو زەویدا، هەروەها بەسەر هەموو ئەو بوونەوەرە خشۆکانەی بەسەر زەویدا دەخشێن.» ");
INSERT INTO ckb_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","خودا مرۆڤی لەسەر وێنەی خۆی بەدیهێنا، لەسەر وێنەی خودی خۆی بەدیهێنا، بە نێر و مێ بەدیهێنان. ");
INSERT INTO ckb_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","خودا بەرەکەتداری کردن و پێی فەرموون: «بەردار بن و زۆر بن و زەوی پڕ بکەن و بیخەنە ژێر ڕکێفتانەوە. دەسەڵاتدار بن بەسەر ماسی دەریا و باڵندەی ئاسمان و بەسەر هەموو بوونەوەرێکی زیندوودا کە لەسەر زەوی دەجوڵێتەوە.» ");
INSERT INTO ckb_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","ئینجا خودا فەرمووی: «هەموو ڕووەکی تۆودار کە لە سەرتاسەری ڕووی زەوییە داومە بە ئێوە، لەگەڵ هەموو دارێکیش کە بەری هەیە و تۆوی خۆی تێدایە. بۆ ئێوە دەبنە خۆراک. ");
INSERT INTO ckb_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","بۆ هەموو گیانلەبەرانی زەوی و هەموو باڵندەکانی ئاسمان و هەموو بوونەوەرێکی خشۆکی سەر زەوی، هەموو بوونەوەرێک کە هەناسەی ژیانی تێدایە، هەموو ڕووەکی سەوزم بۆ خۆراک پێداون.» جا ئاوا بوو. ");
INSERT INTO ckb_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","خودا بینی هەموو ئەوەی کە دروستی کردبوو زۆر باش بوو. جا ئێوارە بوو، بووە بەیانی، ئەمە ڕۆژی شەشەم بوو. ");
INSERT INTO ckb_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","بەم شێوەیە ئاسمان و زەوی و هەرچی تێیاندا ڕێکخرابوو تەواو کران. ");
INSERT INTO ckb_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","ئیتر خودا لە ڕۆژی حەوتەم لەو کارەی کە کردبووی تەواو ببوو. خودا لە ڕۆژی حەوتەم لە هەموو کارەکانی پشووی دا. ");
INSERT INTO ckb_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","خودا ڕۆژی حەوتەمی بەرەکەتدار و پیرۆز کرد، چونکە تێیدا کۆتایی بە هەموو کارێکی بەدیهێنان هێنا. ");
INSERT INTO ckb_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","ئەمانەش ڕێکخستنەکانی ئاسمان و زەوین کاتێک بەدی هێنران، لەو ڕۆژەی یەزدانی پەروەردگار زەوی و ئاسمانی دروستکرد. ");
INSERT INTO ckb_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","هیچ دەوەنێکی کێڵگە لەسەر زەوی نەبوو، هەروەها هیچ ڕووەکێکی کێڵگەش سەری دەرنەکردبوو، چونکە هێشتا یەزدانی پەروەردگار بارانی بەسەر زەویدا نەباراندبوو. هیچ مرۆڤێکیش نەبوو ئیشی جوتیاری بکات. ");
INSERT INTO ckb_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","بەڵام تەم لە زەوییەوە سەردەکەوت و هەموو ڕووی زەوی ئاو دەدا. ");
INSERT INTO ckb_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","جا یەزدانی پەروەردگار پیاوی لە خۆڵی زەوی دروستکرد و هەناسەی ژیانی فووکردە کونە لووتی. بەمەش پیاوەکە بووە گیانێکی زیندوو. ");
INSERT INTO ckb_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","ئینجا یەزدانی پەروەردگار باخچەیەکی لە عەدەن، لە ڕۆژهەڵاتدا چاند. لەوێش پیاوەکەی دانا کە دروستی کردبوو. ");
INSERT INTO ckb_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","یەزدانی پەروەردگار هەموو ئەو جۆرە درەختانەی کە لەبەرچاو جوان بوون و بۆ خواردن خۆش بوون لە زەویدا گەشەی پێکرد. درەختی ژیانیش لە ناوەڕاستی باخچەکەدا بوو، هەروەها درەختی زانینی چاکە و خراپە. ");
INSERT INTO ckb_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","ڕووبارێک لە عەدەنەوە سەرچاوە دەگرێت و لەبەری دەڕوات بۆ ئاودانی باخچەکە، لەوێوە دەبێت بە چوار لقەوە: ");
INSERT INTO ckb_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","ناوی یەکەمیان پیشۆنە کە بە هەر چوار لای هەموو زەوی حەڤیلادایە، کە زێڕی لێیە. ");
INSERT INTO ckb_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","زێڕی ئەو زەوییە چاکە، هەروەها سرێشی داری بۆن خۆش و بەردی عاشقبەندیشی لێیە. ");
INSERT INTO ckb_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","ناوی ڕووباری دووەمیان گیحۆنە، کە بە شێوەی پێچاوپێچ بە هەموو خاکی کوشدا دەڕوات. ");
INSERT INTO ckb_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","ناوی ڕووباری سێیەم دجلەیە، ئەمیش بە ڕۆژهەڵاتی شاری ئەشووردا دەڕوات. ڕووباری چوارەمیش فوراتە. ");
INSERT INTO ckb_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","یەزدانی پەروەردگار پیاوەکەی هێنا و لە باخچەی عەدەن داینا، بۆ ئیشی جوتیاری و بایەخ پێدانی. ");
INSERT INTO ckb_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","یەزدانی پەروەردگار فەرمانی بە پیاوەکە دا و فەرمووی: «تۆ ئازادیت لە هەموو درەختەکانی باخچەکە بخۆیت، ");
INSERT INTO ckb_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","بەڵام بۆت نییە لە درەختی زانینی چاکە و خراپە بخۆیت، چونکە ئەو ڕۆژەی لێی بخۆیت بێگومان دەمریت.» ");
INSERT INTO ckb_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","یەزدانی پەروەردگار فەرمووی: «باش نییە بۆ پیاو بە تەنها بێت. یاریدەرێکی هاوشانی بۆ دروستدەکەم.» ");
INSERT INTO ckb_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","یەزدانی پەروەردگار هەر لە خۆڵی زەوی هەموو ئاژەڵی کێوی و هەموو باڵندەکانی ئاسمانی دروستکرد. ئینجا بۆ پیاوەکەی هێنا بۆ ئەوەی ببینێت چ ناوێکیان لێ دەنێت، هەر ناوێک کە پیاوەکە لە هەریەک لەم بوونەوەرە زیندووانەی نا، ئەوە ناوەکەی بوو. ");
INSERT INTO ckb_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","پیاوەکە ناوی لە هەموو ئاژەڵی ماڵی و باڵندەی ئاسمان و ئاژەڵی کێوی نا. بەڵام بۆ پیاوەکە هیچ یاریدەرێکی هاوشان نەدۆزرایەوە. ");
INSERT INTO ckb_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","لە ئەنجامدا یەزدانی پەروەردگار پیاوەکەی خستە خەوێکی قووڵەوە. کاتێک خەوتبوو، یەکێک لە پەراسووەکانی دەرهێنا و شوێنەکەی بە گۆشت بۆ پڕکردەوە. ");
INSERT INTO ckb_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","ئینجا یەزدانی پەروەردگار ئافرەتێکی لەو پەراسووە دروستکرد کە لە پیاوەکەی وەرگرتبوو، جا هێنای بۆ لای پیاوەکە. ");
INSERT INTO ckb_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","پیاوەکە گوتی: «ئێستا ئەمە ئێسکێکە لە ئێسقانەکانم و گۆشتە لە گۆشتم. ئەمە ناودەبردرێت بە ”ئافرەت“ چونکە لە پیاوەوە وەرگیراوە.» ");
INSERT INTO ckb_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","لەبەر ئەوە پیاو دایک و باوکی خۆی بەجێدەهێڵێت و بە ژنەکەیەوە دەنووسێت، ئیتر دەبنە یەک جەستە. ");
INSERT INTO ckb_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","پیاوەکە و ژنەکەی هەردووکیان ڕووت بوون، شەرمیشیان نەدەکرد. ");
INSERT INTO ckb_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","مار لە هەموو ئاژەڵی کێوی سەر زەوی، ئەوانەی یەزدانی پەروەردگار دروستی کردبوون زۆرزانتر و تەڵەکەبازتر بوو. بە ئافرەتەکەی گوت: «ئایا ڕاستە خودا فەرموویەتی: ”بۆتان نییە لە هیچ درەختێکی باخچەکە بخۆن؟“» ");
INSERT INTO ckb_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","ئافرەتەکەش بە مارەکەی گوت: «بۆمان هەیە لە بەری درەختەکانی باخچەکە بخۆین، ");
INSERT INTO ckb_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","بەڵام خودا فەرمووی: ”بۆتان نییە لە بەری ئەو درەختە بخۆن، کە لە ناوەڕاستی باخچەکەیە، هەروەها بۆتان نییە دەستی لێ بدەن، ئەگینا دەمرن.“» ");
INSERT INTO ckb_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","مارەکە بە ئافرەتەکەی گوت: «نا بەڕاستی نامرن، ");
INSERT INTO ckb_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","چونکە خودا دەزانێت ئەو ڕۆژەی کە دەیخۆن چاوتان دەکرێتەوە و ئیتر وەک خوداتان لێدێت و چاکە و خراپە دەزانن.» ");
INSERT INTO ckb_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","کاتێک ئافرەتەکە بینی بەری درەختەکە بۆ خواردن باشە، چاو ئارەزووی دەکات و وای لێ دەکات دانا بێت، لە بەرەکەی کردەوە و خواردی، دایە مێردەکەشی کە لەگەڵی بوو، ئەویش خواردی. ");
INSERT INTO ckb_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","پاشان هەردووکیان چاویان کرایەوە و زانییان کە ڕووتن، ئیتر گەڵای هەنجیریان لێک دووری و پۆشاکیان بۆ خۆیان دروستکرد. ");
INSERT INTO ckb_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","ئینجا پیاوەکە و ژنەکەی گوێیان لە دەنگی یەزدانی پەروەردگار بوو کە لە کاتی هەڵکردنی شنەبای ڕۆژدا لە باخچەکەدا هاتوچۆی دەکرد، ئەوانیش لەنێو درەختەکانی باخچەکە خۆیان لە یەزدانی پەروەردگاریان شاردەوە. ");
INSERT INTO ckb_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","بەڵام یەزدانی پەروەردگاریش پیاوەکەی بانگ کرد و فەرمووی: «لەکوێیت؟» ");
INSERT INTO ckb_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","ئەویش وەڵامی دایەوە: «لە باخچەکە گوێم لە دەنگت بوو، بەڵام لەبەر ئەوەی کە ڕووت بووم، ترسام؛ ئیتر خۆمم شاردەوە.» ");
INSERT INTO ckb_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","ئەویش فەرمووی: «کێ بە تۆی گوت کە ڕووتیت؟ لەو درەختەت نەخواردبێت کە فەرمانم پێ کردبوویت لێی نەخۆیت؟» ");
INSERT INTO ckb_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","پیاوەکەش گوتی: «ئەو ئافرەتەی پێت دام لەگەڵم بێت، ئەو لە بەری ئەو درەختەی پێدام، منیش خواردم.» ");
INSERT INTO ckb_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","ئینجا یەزدانی پەروەردگار بە ئافرەتەکەی فەرموو: «ئەمە چییە تۆ کردووتە؟» ئافرەتەکەش گوتی: «مارەکە فریوی دام و منیش خواردم.» ");
INSERT INTO ckb_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","یەزدانی پەروەردگار بە مارەکەی فەرموو: «لەبەر ئەوەی ئەمەت کرد، «تۆ لە هەموو ئاژەڵێکی ماڵی و کێوی نەفرەتلێکراوتر دەبیت. هەموو تەمەنیشت لەسەر سکت دەخشێیت و خۆڵ دەخۆیت. ");
INSERT INTO ckb_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","دوژمنایەتیش دەخەمە نێوان تۆ و ئافرەتەکە، نێوان نەوەی تۆ و نەوەی ئەوەوە. نەوەی ئەو سەرت پان دەکاتەوە و تۆش پاژنەی پێی دەکوتیت.» ");
INSERT INTO ckb_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","بە ئافرەتەکەشی فەرموو: «ئازاری سکپڕیت زۆر زیاتر دەکەم، بە ژانەوە منداڵت دەبێت. ئارەزووت بۆ پیاوەکەت دەبێت و ئەویش بەسەرتدا زاڵ دەبێت.» ");
INSERT INTO ckb_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","ئینجا بە پیاوەکەشی فەرموو: «لەبەر ئەوەی تۆش گوێت لە ژنەکەت گرت و لەو درەختەت خوارد کە فەرمانم پێ کردبوویت، ”نابێت لێی بخۆیت،“ «ئەوا زەویش بەهۆی تۆوە نەفرەت لێکراوە. بە ڕەنجکێشانیش هەموو ڕۆژانی ژیانت لێی دەخۆیت. ");
INSERT INTO ckb_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","دڕکوداڵت بۆ بەرهەم دێنێت و ڕووەکی کێڵگە دەخۆیت. ");
INSERT INTO ckb_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","بە ئارەقەی ناوچەوانت نان دەخۆیت، هەتا دەگەڕێیتەوە بۆ زەوی، کە لێیەوە وەرگیراویت، لەبەر ئەوەی تۆ خۆڵیت و بۆ خۆڵیش دەگەڕێیتەوە.» ");
INSERT INTO ckb_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","ئادەم ناوی ژنەکەی نا حەوا، چونکە دەبێتە دایکی هەموو زیندووان. ");
INSERT INTO ckb_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","یەزدانی پەروەردگار بۆ ئادەم و ژنەکەی جلی لە پێست دروستکرد و لەبەری کردن. ");
INSERT INTO ckb_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","ئینجا یەزدانی پەروەردگار فەرمووی: «ئێستا مرۆڤ بووە بە یەکێکی وەک خۆمان، چاکە و خراپە دەزانێت، ئێستاش ڕێگەی پێ نادرێت دەستی درێژ بکات و لە درەختی ژیانیش بکاتەوە و بیخوات و بۆ هەتاهەتایە بژیێت.» ");
INSERT INTO ckb_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","ئیتر یەزدانی پەروەردگار لە باخچەی عەدەن دەریکرد، بۆ ئەوەی لەو زەوییە ئیش بکات کە لێوەی وەرگیراوە. ");
INSERT INTO ckb_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","دوای ئەوەی مرۆڤی دەرکرد، بۆ پاسەوانی ڕێگای درەختی ژیان لە دیوی ڕۆژهەڵاتی باخچەی عەدەن کەڕوبەکانی دانا، لەگەڵ شمشێری گڕدار کە بە هەموو لایەکدا دەسووڕایەوە. ");
INSERT INTO ckb_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","ئادەم لەگەڵ حەوای ژنی جووت بوو، ئەویش سکی پڕ بوو، قایینی بوو. گوتی: «لەلایەن یەزدانەوە پیاوێک بووە بەرهەمم.» ");
INSERT INTO ckb_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","پاشان هابیلی برای بوو. ئیتر هابیل بووە شوانی مێگەل و قایینیش جوتیار بوو. ");
INSERT INTO ckb_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","دوای ماوەیەک قایین هەندێک بەروبوومی زەوی پێشکەش بە یەزدان کرد. ");
INSERT INTO ckb_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","هەروەها هابیل لە چەوری باشترین نۆبەرەی مێگەلەکەی پێشکەش کرد. جا هابیل و قوربانییەکەی جێی ڕەزامەندی یەزدان بوون، ");
INSERT INTO ckb_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","بەڵام قایین و پێشکەشکراوەکەی جێی ڕەزامەندی یەزدان نەبوون، بۆیە قایین زۆر تووڕە بوو و ڕووی خۆی گرژ کرد. ");
INSERT INTO ckb_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","یەزدان بە قایینی فەرموو: «بۆ تووڕە بوویت و ڕووی خۆتت گرژ کردووە؟ ");
INSERT INTO ckb_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","ئایا ئەگەر ئەوەی چاکە ئەنجامی بدەیت، قبوڵ ناکرێیت؟ خۆ ئەگەر ئەوەی چاکە ئەنجامی نەدەیت ئەوا گوناه لە بەردەرگا خۆی مات کردووە و ئارەزووت دەکات، بەڵام تۆ دەبێت بەسەریدا زاڵ ببیت.» ");
INSERT INTO ckb_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","جا قایین بە هابیلی برای گوت: «با بچینە کێڵگەکە.» کاتێک هەردووکیان لە کێڵگە بوون، قایین پەلاماری هابیلی برای دا و کوشتی. ");
INSERT INTO ckb_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","یەزدان بە قایینی فەرموو: «کوا هابیلی برات؟» ئەویش گوتی: «نازانم، ئایا من پاسەوانی براکەمم؟» ");
INSERT INTO ckb_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","جا یەزدان فەرمووی: «چیت کردووە؟ گوێ بگرە! دەنگی خوێنی براکەت لە زەوییەوە هاوارم بۆ دەکات. ");
INSERT INTO ckb_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","ئێستاش تۆ نەفرەتلێکراویت لەو زەوییەی کە دەمی بۆ وەرگرتنی خوێنی براکەت کردەوە لە دەستی تۆ. ");
INSERT INTO ckb_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","کاتێک ئیش لە زەوییەکەدا دەکەیت، چیتر بەری خۆیت ناداتێ. لەسەر زەوی دەربەدەر و بێ ئۆقرە دەبیت.» ");
INSERT INTO ckb_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","قایین بە یەزدانی گوت: «سزاکەم لەوە گەورەترە کە بتوانم بەرگەی بگرم. ");
INSERT INTO ckb_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","ئەمڕۆ لەسەر زەوی دەرتکردم، لەبەر ئامادەبوونی تۆ ون دەبم و دەربەدەر و بێ ئۆقرە دەبم لەسەر زەوی. هەرکەسێکیش تووشم بێت دەمکوژێت.» ");
INSERT INTO ckb_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","بەڵام یەزدان پێی فەرموو: «ناکرێت وابێت، هەرکەسێک قایین بکوژێت ئەوا حەوت ئەوەندە تۆڵەی لێ دەستێنرێتەوە.» ئینجا یەزدان نیشانەیەکی بە قایینەوە کرد تاکو هەرکەسێک تووشی بێت نەیکوژێت. ");
INSERT INTO ckb_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","ئیتر قایین لەبەردەمی یەزدان چووە دەرەوە و لە خاکی نۆد لە ڕۆژهەڵاتی عەدەن نیشتەجێ بوو. ");
INSERT INTO ckb_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","قایین لەگەڵ ژنەکەی جووت بوو، ئەویش سکی پڕ بوو و حەنۆخی بوو. ئەو کاتە شارێکی بنیاد دەنا، شارەکەی بە ناوی کوڕەکەیەوە ناو نا حەنۆخ. ");
INSERT INTO ckb_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","حەنۆخ عیرادی بوو، عیرادیش مەحویائێلی بوو، مەحویائێلیش مەتوشائێلی بوو، مەتوشائێلیش لامەخی بوو. ");
INSERT INTO ckb_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","لامەخ دوو ژنی هێنا، یەکێکیان ناوی عادا بوو، ئەوی دیکەشیان ناوی چیلا بوو. ");
INSERT INTO ckb_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","لە عاداوە یابال بوو کە باوکی چادرنشینان و خاوەن مەڕوماڵاتەکان بوون. ");
INSERT INTO ckb_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","براکەشی ناوی یوبال بوو کە باوکی هەموو ئەوانە بوو کە قیسارەیان دەژەند و شمشاڵیان لێدەدا. ");
INSERT INTO ckb_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","چیلاش کوڕێکی بوو بە ناوی توبەل قەین، کە وەستای هەموو ئەو جۆرە ئامێرانە بوو کە لە بڕۆنز و ئاسن دروست دەکران. نەعماش خوشکی توبەل قەین بوو. ");
INSERT INTO ckb_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","لامەخ بە هەردوو ژنەکەی گوت: «عادا و چیلا، گوێتان لێم بێت، ئەی هەردوو ژنەکەی لامەخ، گوێ بۆ قسەکانم شل بکەن. پیاوێکم کوشتووە لەسەر ئەوەی برینداری کردم، لاوێکیش لەسەر ئەوەی زامداری کردم. ");
INSERT INTO ckb_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","ئەو بۆ قایین حەوت جار تۆڵە دەستێنێتەوە، بەڵام بۆ لامەخ، حەفتا و حەوت جار.» ");
INSERT INTO ckb_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","جارێکی دیکە ئادەم لەگەڵ ژنەکەی جووت بوو، کوڕێکی بوو و ناوی لێنا شیت. ئینجا گوتی: «لە جیاتی هابیل کە قایین کوشتی، خودا کوڕێکی دیکەی پێ بەخشیم.» ");
INSERT INTO ckb_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","هەروەها شیت کوڕێکی بوو ناوی لێنا ئەنۆش. لەو کاتەدا بوو کە خەڵکی دەستیان کرد بە نزاکردن بە ناوی یەزدانەوە. ");
INSERT INTO ckb_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","ئەمە تۆماری نەوەکانی ئادەمە. ئەو ڕۆژەی خودا مرۆڤی بەدیهێنا، لەسەر شێوەی خودا دروستی کرد. ");
INSERT INTO ckb_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","بە نێر و مێ بەدیهێنان و بەرەکەتداری کردن. ئەو ڕۆژەی بەدیهێنان ناوی لێنان «مرۆڤ». ");
INSERT INTO ckb_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","کاتێک ئادەم تەمەنی سەد و سی ساڵ بوو، کوڕێکی بوو لە وێنەی خۆی و لە خۆی دەچوو، ناوی لێنا شیت. ");
INSERT INTO ckb_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","دوای لەدایکبوونی شیت، ئادەم هەشت سەد ساڵ ژیا، کوڕ و کچی دیکەشی بوو. ");
INSERT INTO ckb_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","هەموو تەمەنی ئادەم نۆ سەد و سی ساڵ بوو، ئیتر مرد. ");
INSERT INTO ckb_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","کاتێک شیت تەمەنی سەد و پێنج ساڵ بوو، ئەنۆش لە نەوەی ئەو لەدایکبوو. ");
INSERT INTO ckb_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","دوای لەدایکبوونی ئەنۆش، شیت هەشت سەد و حەوت ساڵ ژیا، کوڕ و کچی دیکەشی بوو. ");
INSERT INTO ckb_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","هەموو تەمەنی شیت نۆ سەد و دوازدە ساڵ بوو، ئیتر مرد. ");
INSERT INTO ckb_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","کاتێک ئەنۆش تەمەنی نەوەد ساڵ بوو، قێنان لەدایکبوو. ");
INSERT INTO ckb_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","دوای لەدایکبوونی قێنان، ئەنۆش هەشت سەد و پازدە ساڵ ژیا، کوڕ و کچی دیکەشی بوو. ");
INSERT INTO ckb_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","هەموو تەمەنی ئەنۆش نۆ سەد و پێنج ساڵ بوو، ئیتر مرد. ");
INSERT INTO ckb_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","کاتێک قێنان تەمەنی حەفتا ساڵ بوو، مەهلەلئێل لە نەوەی ئەو لەدایکبوو. ");
INSERT INTO ckb_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","دوای لەدایکبوونی مەهلەلئێل، قێنان هەشت سەد و چل ساڵ ژیا، کوڕ و کچی دیکەشی بوو. ");
INSERT INTO ckb_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","هەموو تەمەنی قێنان نۆ سەد و دە ساڵ بوو، ئیتر مرد. ");
INSERT INTO ckb_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","کاتێک مەهلەلئێل تەمەنی شەست و پێنج ساڵ بوو، یارەد لە نەوەی ئەو لەدایکبوو. ");
INSERT INTO ckb_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","دوای لەدایکبوونی یارەد، مەهلەلئێل هەشت سەد و سی ساڵ ژیا، کوڕ و کچی دیکەشی بوو. ");
INSERT INTO ckb_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","هەموو تەمەنی مەهلەلئێل هەشت سەد و نەوەد و پێنج ساڵ بوو، ئیتر مرد. ");
INSERT INTO ckb_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","کاتێک یارەد تەمەنی سەد و شەست و دوو ساڵ بوو، حەنۆخ لە نەوەی ئەو لەدایکبوو. ");
INSERT INTO ckb_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","دوای لەدایکبوونی حەنۆخ، یارەد هەشت سەد ساڵ ژیا، کوڕ و کچی دیکەشی بوو. ");
INSERT INTO ckb_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","هەموو تەمەنی یارەد نۆ سەد و شەست و دوو ساڵ بوو، ئیتر مرد. ");
INSERT INTO ckb_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","کاتێک حەنۆخ تەمەنی شەست و پێنج ساڵ بوو، مەتوشالح لە نەوەی ئەو لەدایکبوو. ");
INSERT INTO ckb_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","دوای ئەوەی حەنۆخ مەتوشالحی بوو، سێ سەد ساڵ دۆستایەتی خودای کرد، هەروەها کوڕ و کچی دیکەشی بوو. ");
INSERT INTO ckb_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","ئیتر هەموو ماوەی ژیانی حەنۆخ سێ سەد و شەست و پێنج ساڵ بوو. ");
INSERT INTO ckb_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","حەنۆخ دۆستی خودا بوو، ئیتر کەس نەیبینییەوە، چونکە خودا بردی بۆ لای خۆی. ");
INSERT INTO ckb_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","کاتێک مەتوشالح تەمەنی سەد و هەشتا و حەوت ساڵ بوو، لامەخ لە نەوەی ئەو لەدایکبوو. ");
INSERT INTO ckb_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","دوای لەدایکبوونی لامەخ، مەتوشالح حەوت سەد و هەشتا و دوو ساڵ ژیا، کوڕ و کچی دیکەشی بوو. ");
INSERT INTO ckb_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","هەموو تەمەنی مەتوشالح نۆ سەد و شەست و نۆ ساڵ بوو، ئیتر مرد. ");
INSERT INTO ckb_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","کاتێک لامەخ تەمەنی سەد و هەشتا و دوو ساڵ بوو، کوڕێکی بوو. ");
INSERT INTO ckb_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","ناوی لێنا نوح و گوتی: «ئەمە لە کار و ماندووبوونی دەستمان دڵنەواییمان دەکات، کە لەو زەوییە دەیچێژین یەزدان نەفرەتی لێ کردووە.» ");
INSERT INTO ckb_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","دوای لەدایکبوونی نوح، لامەخ پێنج سەد و نەوەد و پێنج ساڵ ژیا، کوڕ و کچی دیکەشی بوو. ");
INSERT INTO ckb_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","هەموو تەمەنی لامەخ حەوت سەد و حەفتا و حەوت ساڵ بوو، ئیتر مرد. ");
INSERT INTO ckb_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","دوای ئەوەی نوح تەمەنی پێنج سەد ساڵ بوو، سام و حام و یافەتی بوو. ");
INSERT INTO ckb_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","کاتێک مرۆڤەکان لەسەر زەوی دەستیان بە زۆربوون کرد و کچیان بوو، ");
INSERT INTO ckb_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","کوڕانی خودا بینییان کچانی مرۆڤ جوانن. جا لە هەموو ئەوانەی هەڵیانبژاردن ژنیان هێنا. ");
INSERT INTO ckb_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","ئینجا یەزدان فەرمووی: «ڕۆحی من هەتاسەر ململانێ لەگەڵ مرۆڤ ناکات، چونکە مەرگدارن؛ ڕۆژانی ژیانیان دەبێتە سەد و بیست ساڵ.» ");
INSERT INTO ckb_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","لەو ڕۆژانەدا لەسەر زەوی نەفیلیم هەبوون. لەدوای ئەوەی کوڕانی خودا چوونە لای کچانی مرۆڤ منداڵیان لێیان بوو، منداڵەکان بوونە ئەو پاڵەوانانەی کە لە کۆنەوە ناوبانگیان هەیە. ");
INSERT INTO ckb_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","یەزدان بینی کە خراپەکاری مرۆڤ لەسەر زەوی زۆر بووە، هەروەها هەموو بیروبۆچوونەکانی دڵیشی بە درێژایی ڕۆژ تەنها لەلای خراپەیە. ");
INSERT INTO ckb_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","یەزدان خەفەتبار بوو کە مرۆڤی لەسەر زەوی دروستکردبوو، هەروەها دڵگرانیش بوو. ");
INSERT INTO ckb_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","ئیتر یەزدان فەرمووی: «مرۆڤ دەسڕمەوە، ئەوەی لەسەر ڕووی زەوی دروستم کرد، مرۆڤ و ئاژەڵ و بوونەوەری خشۆک و باڵندەی ئاسمان، چونکە خەفەت دەخۆم لەوانەی کە دروستم کردوون.» ");
INSERT INTO ckb_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","بەڵام نوح لەبەرچاوی یەزدان ڕەزامەندی بەدەستهێنابوو. ");
INSERT INTO ckb_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","ئەمانەش نەوەکانی نوحن. نوح پیاوچاک و بێ کەموکوڕی نێو خەڵکانی سەردەمی خۆی بوو، دۆستی خودا بوو. ");
INSERT INTO ckb_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","نوح سێ کوڕی بوو: سام و حام و یافەت. ");
INSERT INTO ckb_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","زەویش لەبەردەم خودا گەندەڵ بوو و پڕیش بوو لە توندوتیژی. ");
INSERT INTO ckb_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","خودا بینی زەوی چەند گەندەڵ بووە، چونکە هەموو مرۆڤێک ژیانی خۆی لەسەر زەوی گەندەڵ کردبوو. ");
INSERT INTO ckb_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","ئیتر خودا بە نوحی فەرموو: «من کۆتایی بە بوونی هەموو ئادەمیزاد دەهێنم، چونکە بەهۆی ئەوانەوە زەوی پڕ بووە لە توندوتیژی. وا لەگەڵ زەوی لەناویان دەبەم. ");
INSERT INTO ckb_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","کەشتییەک بۆ خۆت لە تەختەی دار سەروو دروستبکە و بیکە بە لانە و بە قیر دیوی ناوەوە و دەرەوەی سواخ بدە. ");
INSERT INTO ckb_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","بەم شێوەیەش دروستی بکە: درێژییەکەی سێ سەد باڵ و پانییەکەی پەنجا باڵ و بەرزییەکەی سی باڵ بێت. ");
INSERT INTO ckb_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","لە بەشی سەرەوەی کەشتییەکە بە ئەندازەی باڵێک بۆشایی بەجێ بهێڵە، ئینجا سەربانێکی بۆ دروست بکە. دەرگای کەشتییەکەش لەتەنیشتەوە دابنێ. با سێ نهۆم بێت، خوارەوە و ناوەڕاست و سەرەوە. ");
INSERT INTO ckb_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","من وا ئاوی لافاو بەسەر زەویدا دەهێنم، بۆ لەناوبردنی هەموو ژیانێک لەژێر ئاسمان، هەروەها هەموو زیندەوەرێک کە هەناسەی ژیانی تێدایە. هەرچییەک لەسەر زەوییە لەناودەچێت. ");
INSERT INTO ckb_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","بەڵام من پەیمانی خۆم لەگەڵ تۆ دەچەسپێنم. تۆ دەچیتە ناو کەشتییەکەوە، خۆت و کوڕەکانت و ژنەکەت و بووکەکانیشت لەگەڵت. ");
INSERT INTO ckb_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","لە هەموو بوونەوەرێکی زیندوو، نێر و مێ، جووتێک لەگەڵ خۆت دەهێنیتە ناو کەشتییەکەوە، بۆ هێشتنەوەیان بە زیندووێتی. ");
INSERT INTO ckb_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","جووتێک لە هەموو جۆرەکانی باڵندە و ئاژەڵ و بوونەوەرە خشۆکەکانی زەوی دێنە لات، بۆ ئەوەی بە زیندوویی بمێننەوە. ");
INSERT INTO ckb_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","تۆش بۆ خۆت لە هەموو جۆرە خواردنێکی گونجاو ببە و لەلای خۆت کۆی بکەرەوە، تاکو ببێتە خواردنی خۆت و ئەوان.» ");
INSERT INTO ckb_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","جا نوح هەموو ئەوەی خودا فەرمانی پێ کردبوو، ئەنجامی دا. ");
INSERT INTO ckb_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","ئینجا یەزدان بە نوحی فەرموو: «خۆت و خاووخێزانەکەت بڕۆنە ناو کەشتییەکەوە، چونکە لەم نەوەیەدا تەنها تۆم بە ڕاستودروست بینیوە لەبەردەمم. ");
INSERT INTO ckb_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","لە هەموو جۆرێکی ئاژەڵە پاکەکان، نێر و مێ، حەوت جووت لەگەڵ خۆت دەبەیت، لەو ئاژەڵانەی پاک نین، نێر و مێ، جووتێک دەبەیت. ");
INSERT INTO ckb_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","لە باڵندەکانی ئاسمانیش حەوت جووت، لە نێر و مێیان، بۆ هێشتنەوەی ڕەگەزەکانیان لەسەرتاسەری ڕووی زەوی. ");
INSERT INTO ckb_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","دوای حەوت ڕۆژی دیکە، چل شەو و چل ڕۆژ باران بەسەر زەویدا دەبارێنم. هەموو ئەو بوونەوەرە زیندووانە لەسەر ڕووی زەوی دەسڕمەوە کە دروستم کردوون.» ");
INSERT INTO ckb_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","نوح هەموو شتێکی بەپێی فەرمانی یەزدان ئەنجام دا. ");
INSERT INTO ckb_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","نوح تەمەنی شەش سەد ساڵ بوو کە لافاو لەسەر زەوی هەستا. ");
INSERT INTO ckb_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","نوح خۆی و کوڕەکانی و ژنەکەی و بووکەکانی پێش ئاوی لافاوەکە چوونە ناو کەشتییەکە. ");
INSERT INTO ckb_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","لە ئاژەڵە پاک و ئاژەڵە ناپاکەکان، لە باڵندە و هەموو ئەو بوونەوەرانەی لەسەر زەوی دەخشێن، ");
INSERT INTO ckb_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","جووت جووت لە نێر و مێ، هاتنە لای نوح و چوونە ناو کەشتییەکە، هەروەک چۆن خودا فەرمانی بە نوح دابوو. ");
INSERT INTO ckb_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","دوای حەوت ڕۆژەکە ئاوی لافاوەکە هاتە سەر زەوی. ");
INSERT INTO ckb_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","کاتێک نوح تەمەنی شەش سەد ساڵ بوو، لە حەڤدەمین ڕۆژی مانگی دووەم، لەو ڕۆژەدا هەموو سەرچاوەکانی دەریا گەورەکەی ژێر زەوی تەقینەوە و دەروازەکانی ئاسمانیش کرانەوە. ");
INSERT INTO ckb_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","چل شەو و چل ڕۆژیش لەسەر زەوی باران باری. ");
INSERT INTO ckb_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","هەر لە هەمان ڕۆژدا نوح و کوڕەکانی، سام و حام و یافەت، پێکەوە لەگەڵ ژنەکەی و هەر سێ بووکەکەی چوونە ناو کەشتییەکەوە. ");
INSERT INTO ckb_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","لەگەڵیان هەموو ئاژەڵە کێوییەکان بەپێی جۆریان، هەموو ئاژەڵە ماڵییەکان بەپێی جۆریان، هەموو بوونەوەرە خشۆکەکان بەپێی جۆریان، هەموو باڵندەیەک بەپێی جۆریان و هەموو باڵدارێک. ");
INSERT INTO ckb_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","جووت جووت لە هەموو بوونەوەرێک کە هەناسەی ژیانیان تێدابوو، چوونە ناو کەشتییەکە بۆ لای نوح. ");
INSERT INTO ckb_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","ئەوانەی دەهاتنە ناوەوە لە نێر و مێی هەموو گیاندارێکی زیندوو بوون، وەک چۆن خودا فەرمانی بە نوح دابوو. ئینجا یەزدان لەدوایەوە دەرگای کەشتییەکەی داخست. ");
INSERT INTO ckb_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","لافاوەکە بۆ ماوەی چل ڕۆژ لەسەر زەوی بەردەوام بوو. کاتێک ئاو زۆر بوو کەشتییەکەی هەڵگرت، ئیتر کەشتییەکە لە زەوی بەرزبووەوە. ");
INSERT INTO ckb_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","ئاو لەسەر زەوی بەرزبووەوە و گەلێک زۆر بوو، کەشتییەکەش لەسەر ڕووی ئاوەکە دەڕۆیشت. ");
INSERT INTO ckb_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","ئاو لەسەر زەوی زۆر بەرزبووەوە هەتا هەموو شاخە بەرزەکانی ژێر هەموو ئاسمان داپۆشران. ");
INSERT INTO ckb_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","بە بەرزی پازدە باڵ ئاو لەسەر شاخەکان بەرزبووەوە، شاخەکانیش داپۆشران. ");
INSERT INTO ckb_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","ئیتر هەموو شتێکی زیندوو کە لەسەر زەوی دەجوڵایەوە لەناوچوو، لە باڵندە و ئاژەڵی ماڵی و ئاژەڵی کێوی و هەموو ئەو کۆمەڵە زیندەوەرانەی لەسەر زەوی دەجوڵانەوە، هەموو ئادەمیزادیش. ");
INSERT INTO ckb_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","هەر شتێک لەسەر وشکانی کە هەناسەی ژیان لە لووتیدا بوو، مرد. ");
INSERT INTO ckb_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","هەموو شتێکی زیندوو لەسەر ڕووی زەوی سڕایەوە، مرۆڤ و ئاژەڵ و بوونەوەرە خشۆکەکان و هەموو باڵندەکانی ئاسمانیش، لەسەر زەوی سڕانەوە. تەنها نوح و ئەوانە مانەوە کە لە کەشتییەکە لەگەڵی بوون. ");
INSERT INTO ckb_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","ئاوی لافاویش سەد و پەنجا ڕۆژ لەسەر زەوی بوو. ");
INSERT INTO ckb_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","ئینجا خودا نوحی بەسەرکردەوە، لەگەڵ هەموو ئاژەڵە کێوییەکان و هەموو ئاژەڵە ماڵییەکان کە لە کەشتییەکەدا لەگەڵی بوون. ئیتر خودا بایەکی بەسەر زەویدا هەڵکرد و ئاو کەم بووەوە. ");
INSERT INTO ckb_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","سەرچاوەکانی قووڵایی و دەروازەکانی ئاسمان داخران. بارانیش لە ئاسمانەوە وەستا. ");
INSERT INTO ckb_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","ئاو بەرەبەرە لە زەوی بەرەو دواوە گەڕایەوە. دوای سەد و پەنجا ڕۆژ ئاو کەم بووەوە. ");
INSERT INTO ckb_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","لە حەڤدەمین ڕۆژی مانگی حەوتەم کەشتییەکە لەسەر چیاکانی ئارارات گیرسایەوە. ");
INSERT INTO ckb_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","هەتا مانگی دەیەم هەتا دەهات ئاو کەمی دەکرد. لە یەکەم ڕۆژی مانگی دەیەم لووتکەی شاخەکان دەرکەوتن. ");
INSERT INTO ckb_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","دوای چل ڕۆژ، نوح ئەو پەنجەرە بچووکەی کردەوە کە لە کەشتییەکەدا دروستی کردبوو. ");
INSERT INTO ckb_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","ئینجا قەلەڕەشێکی نارد. ئەویش دەهات و دەچوو هەتا ئاو لەسەر ڕووی زەوی وشک بووەوە. ");
INSERT INTO ckb_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","پاشان کۆترێکی نارد بۆ ئەوەی ببینێت ئایا ئاوەکە لەسەر ڕووی زەوی کەمی کردووە. ");
INSERT INTO ckb_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","بەڵام کۆترەکە شوێن پێیەکی بۆ خۆی نەدۆزییەوە، چونکە ئاو لەسەر هەموو ڕووی زەوی بوو، ئیتر گەڕایەوە لای نوح بۆ ناو کەشتییەکە. ئەویش دەستی بۆ ڕاگرت و گرتی، بردییەوە لای خۆی، بۆ ناو کەشتییەکە. ");
INSERT INTO ckb_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","حەوت ڕۆژی دیکە چاوەڕێی کرد و دیسان کۆترەکەی لە کەشتییەکەوە ڕەوانە کرد. ");
INSERT INTO ckb_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","کۆترەکە ئێوارە گەڕایەوە بۆ لای، ئەم جارە گەڵایەکی تەڕ و تازەی زەیتوونی بە دەنووکەوە بوو. نوح زانی کە ئاو لەسەر ڕووی زەوی کەمی کردووە. ");
INSERT INTO ckb_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","حەوت ڕۆژی دیکە چاوەڕێی کرد و جارێکی دیکە کۆترەکەی ناردەوە، بەڵام ئەم جارەیان کۆترەکە نەگەڕایەوە لای. ");
INSERT INTO ckb_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","نوح لە یەکی مانگی یەکەمی شەش سەد و یەکەمین ساڵیدا بوو، کە ئاو لە زەوی وشک بووەوە. نوح پۆشەری سەر کەشتییەکەی لابرد و بینی وا ڕووی زەوی وشک بووەتەوە. ");
INSERT INTO ckb_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","لە بیست و حەوتی مانگی دووەم، زەوی بە تەواوی وشک بووەوە. ");
INSERT INTO ckb_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","ئینجا خودا بە نوحی فەرموو: ");
INSERT INTO ckb_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","«خۆت و ژنەکەت و کوڕ و بووکەکانت، لە کەشتییەکە وەرنە دەرەوە. ");
INSERT INTO ckb_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","هەموو ئەو گیاندارانەی لەگەڵتن، لە باڵندە و ئاژەڵ و هەموو ئەو بوونەوەرە خشۆکانەی لەسەر زەوی دەخشێن، لەگەڵ خۆت بهێنە دەرەوە، تاکو زەوی پڕ بکەنەوە و بەردار ببن و لەسەر زەوی زۆر ببن.» ");
INSERT INTO ckb_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","جا نوح خۆی و کوڕەکانی و ژنەکەی و بووکەکانی لەگەڵی هاتنە دەرەوە. ");
INSERT INTO ckb_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","هەموو گیاندارەکانیش بە هەموو بوونەوەرە خشۆکەکان و هەموو باڵندەکان و هەموو ئەوانەی لەسەر زەوی دەبزوێن، بەپێی جۆرەکانیان لە کەشتییەکە هاتنە دەرەوە. ");
INSERT INTO ckb_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","نوح قوربانگایەکی بۆ یەزدان دروستکرد، لە هەموو ئاژەڵە پاکەکان و لە هەموو باڵندە پاکەکانی هێنا و لەسەر قوربانگاکە کردنی بە قوربانی سووتاندن. ");
INSERT INTO ckb_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","جا یەزدان کە بۆنەکەی بەلاوە خۆش بوو، لە دڵی خۆیدا فەرمووی: «جارێکی دیکە بەهۆی مرۆڤەوە نەفرەت لە زەوی ناکەم، چونکە مرۆڤ هەر لە منداڵییەوە دڵی مەیلی خراپەکاری هەیە. جارێکی دیکە نایەم هەرچی بوونەوەری زیندوو هەیە لەناوی ببەم، وەک چۆن کردم. ");
INSERT INTO ckb_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","«هەتا زەوی بمێنێت، چاندن و دروێنە، ساردی و گەرمی، هاوین و زستان، شەو و ڕۆژ، هەرگیز ناوەستێت.» ");
INSERT INTO ckb_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","ئیتر خودا نوح و کوڕەکانی بەرەکەتدار کرد و پێی فەرموون: «بەردار بن و زۆر بن و زەوی پڕ بکەن. ");
INSERT INTO ckb_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","با ترس و سامتان هەبێت لەسەر هەموو گیانلەبەرانی زەوی و هەموو باڵندەکانی ئاسمان و هەموو ئەو بوونەوەرانەی کە لەسەر زەوی دەجوڵێنەوە، هەروەها لەسەر هەموو ماسییەکانی دەریاش؛ ئەوان خراونەتە بەردەستی ئێوە. ");
INSERT INTO ckb_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","هەموو ئەوانەی گیاندارن و دەبزوێن دەبنە خۆراک بۆتان. هەروەک چۆن ڕووەکی سەوزم پێداون، ئێستا هەموو شتێکتان دەدەمێ. ");
INSERT INTO ckb_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","«بەڵام نابێت گۆشتێک بخۆن کە هێشتا خوێنەکەی گەرمە. ");
INSERT INTO ckb_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","بێگومان داوای خوێنی ئەو کەسە دەکەم کە خوێنی کەسێکی دیکەی ڕشتووە. ئەگەر گیاندارێک کەسێک بکوژێت، دەبێت بکوژرێتەوە. هەروەها ئەگەر کەسێک کەسێکی دیکە بکوژێت، ئەوا ئەویش دەکوژرێتەوە. ");
INSERT INTO ckb_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","«هەرکەسێک خوێنی مرۆڤ بڕێژێت، بە دەستی مرۆڤ خوێنی دەڕێژرێتەوە، چونکە خودا لەسەر وێنەی خۆی مرۆڤی دروستکردووە. ");
INSERT INTO ckb_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","ئێوەش بەردار بن و زۆر بن، زەوی پڕ بکەن و تێیدا زۆر بن.» ");
INSERT INTO ckb_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","خودا بە نوح و کوڕەکانی فەرموو کە لەگەڵیدا بوون: ");
INSERT INTO ckb_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","«من پەیمانی خۆم لەگەڵ ئێوە و نەوەی دوای ئێوەدا دەچەسپێنم، ");
INSERT INTO ckb_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","لەگەڵ هەموو ئەو گیاندارانەی کە لەگەڵ ئێوەن، باڵندە و ئاژەڵە ماڵییەکان و هەموو ئاژەڵە کێوییەکان، هەموو ئەو گیاندارانەی لەگەڵتاندان و لە کەشتییەکە هاتوونەتە دەرەوە، هەروەها هەرچی گیانداری سەر زەویش هەیە. ");
INSERT INTO ckb_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","من پەیمانی خۆم لەگەڵ ئێوە دەچەسپێنم: هەرگیز جارێکی دیکە، هەموو گیانلەبەران بە ئاوی لافاو لەناو ناچن، هەرگیز جارێکی دیکە لافاو وا نابێت زەوی بە تەواوی وێران بکات.» ");
INSERT INTO ckb_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","ئینجا خودا فەرمووی: «ئەمە نیشانەی ئەو پەیمانەیە لەنێوان خۆم و ئێوە و هەموو ئەو گیاندارانەی لەگەڵتاندان دەیبەستم، پەیمانێکە بۆ هەموو نەوەکانی داهاتوو. ");
INSERT INTO ckb_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","وا پەلکەزێڕینەی خۆمم لەناو هەورەکاندا داناوە، کە دەبێتە نیشانەی پەیمانەکەی نێوان من و زەوی. ");
INSERT INTO ckb_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","ئینجا هەرکاتێک هەورم بەسەر زەویدا هێنا و پەلکەزێڕینە لە هەورەکاندا دەرکەوت، ");
INSERT INTO ckb_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","من پەیوەست دەبم بە پەیمانەکەم لەنێوان خۆم و ئێوە و هەموو گیانێکی زیندوو لە هەموو جۆرێک. هەرگیز جارێکی دیکە ئاو لافاوێکی وا دروستناکات کە هەموو ژیانێک لەناو ببات. ");
INSERT INTO ckb_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","هەرکاتێک پەلکەزێڕینە لە هەورەکاندا بێت، دەیبینم و پەیوەست دەبم بە پەیمانە هەتاهەتاییەکەوە، کە لەنێوان خودا و هەموو جۆرە گیانێکی زیندووی سەر زەوییە.» ");
INSERT INTO ckb_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","ئینجا خودا بە نوحی فەرموو: «ئەمە نیشانەی ئەو پەیمانەیە کە لەنێوان خۆم و هەموو ژیانێکی لەسەر زەویدا بەستوومە.» ");
INSERT INTO ckb_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","جا کوڕانی نوح کە سام و حام و یافەت بوون، لە کەشتییەکە هاتنە دەرەوە. حام باوکی کەنعان بوو. ");
INSERT INTO ckb_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","ئەمانە سێ کوڕەکەی نوح بوون کە لەمانەوە خەڵکی لە سەرتاسەری زەویدا بڵاو بوونەوە. ");
INSERT INTO ckb_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","نوح دەستی بە ئیشی جوتیاری کرد و ڕەزە مێوێکی چاند. ");
INSERT INTO ckb_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","ئینجا کە لە شەرابی مێوەکەی خواردەوە، سەرخۆش بوو و لەناو چادرەکەیدا بە ڕووتی ڕاکشا. ");
INSERT INTO ckb_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","حامی باوکی کەنعان، باوکی بە ڕووتی بینی و لە دەرەوە بە هەردوو براکەی ڕاگەیاند. ");
INSERT INTO ckb_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","بەڵام سام و یافەت پۆشاکێکیان هێنا و خستیانە سەر شانیان، ئینجا پشتاوپشت چوون و ڕووتییەکەی باوکیان داپۆشی، ڕووشیان بەرەو دواوە بوو، ئیتر ڕووتییەکەی باوکیان نەبینی. ");
INSERT INTO ckb_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","کاتێک نوح لە سەرخۆشییەکەی بەئاگا هاتەوە، زانی کوڕە بچووکەکەی چی پێکردووە. ");
INSERT INTO ckb_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","ئینجا گوتی: «نەفرەت لێکراو بێت کەنعان! دەبێتە کۆیلەی کۆیلەکان، بۆ براکانی.» ");
INSERT INTO ckb_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","هەروەها گوتی: «ستایش بۆ یەزدان، پەروەردگاری سام! با کەنعان ببێتە کۆیلەی سام. ");
INSERT INTO ckb_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","با خودا دەرگا بۆ یافەت بکاتەوە و لە چادرەکانی سام جێنشین بێت. با کەنعان ببێتە کۆیلەی ئەو.» ");
INSERT INTO ckb_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","دوای لافاوەکە نوح سێ سەد و پەنجا ساڵ ژیا. ");
INSERT INTO ckb_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","هەموو تەمەنی نوح نۆ سەد و پەنجا ساڵ بوو، ئیتر مرد. ");
INSERT INTO ckb_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","ئەمانەش نەوەکانی نوحن، سام و حام و یافەت کە دوای لافاوەکە ئەوانیش کوڕیان بوو. ");
INSERT INTO ckb_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","کوڕەکانی یافەت: گۆمەر، ماگۆگ، مادەی، یاڤان، توبال، مەشەک و تیراس. ");
INSERT INTO ckb_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","کوڕەکانی گۆمەر: ئەشکەنەز، ڕیفەت و تۆگەرما. ");
INSERT INTO ckb_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","کوڕەکانی یاڤان: ئەلیشا، تەرشیش، کیتیم و ڕۆدانیم. ");
INSERT INTO ckb_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","لەمانەوە نەتەوەکانی کەنار ئاوەکان بەنێو خاکەکانیاندا بڵاو بوونەوە، هەریەکەیان بەپێی زمان و هۆز و نەتەوەی خۆی. ");
INSERT INTO ckb_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","کوڕەکانی حام: کوش، میسر، پووت و کەنعان. ");
INSERT INTO ckb_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","کوڕەکانی کوش: سەبا، حەڤیلا، سەڤتا، ڕەعما و سەبتەکا. کوڕەکانی ڕەعما: شەبا و دیدان. ");
INSERT INTO ckb_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","نەمرود لە نەوەی کوش لەدایکبوو، کە بووە جەنگاوەرێکی مەزن لەسەر زەوی. ");
INSERT INTO ckb_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","ئەو لەبەردەم یەزدان بووە ڕاوچییەکی بەتوانا. لەبەر ئەمەیە دەگوترێت: «وەک نەمرودیت، ڕاوچییەکی بەتوانا لەبەردەم یەزدان.» ");
INSERT INTO ckb_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","سەرەتای شانشینەکەی بابل، ئەرەک، ئەکەد و کەلنێ بوو لە خاکی شینعار. ");
INSERT INTO ckb_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","لەو خاکەوە چوو بۆ ئاشور، لەوێ نەینەوا، ڕەحۆبۆت عیر و کەلەحی بنیاد نا، ");
INSERT INTO ckb_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","هەروەها ڕەسەن کە شارە گەورەکەیە دەکەوێتە نێوان نەینەوا و کەلەح. ");
INSERT INTO ckb_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","میسر باوکی لوودی، عەنامی، لەهابی، نەفتوحی، ");
INSERT INTO ckb_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","پاتروسی و کەفتۆری بوو، هەروەها باوکی کەسلوحییەکانیش بوو کە فەلەستییەکانیان لێ کەوتنەوە. ");
INSERT INTO ckb_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","کەنعان باوکی سەیدا بوو، کە نۆبەرەکەی بوو، لەگەڵ حیتییەکان، ");
INSERT INTO ckb_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","هەروەها یەبوسی، ئەمۆری، گرگاشی، ");
INSERT INTO ckb_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","حیڤی، عەرقی، سینی، ");
INSERT INTO ckb_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","ئەرڤادی، چیماری و حەماتییەکانیشی بوو. لەدوای ئەوە هۆزەکانی کەنعانییەکان بڵاو بوونەوە. ");
INSERT INTO ckb_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","سنووری کەنعانییەکان لە سەیداوە بە گراردا دەڕۆیشت هەتا دەگەیشتە غەزە، پاشان بە سەدۆم، عەمۆرا، ئەدما و چەبۆئیمدا دەڕۆیشت هەتا لەشەع. ");
INSERT INTO ckb_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","ئەمانە نەوەی حامن، بەپێی هۆز و زمانیان، لە خاک و نەتەوەکانیان. ");
INSERT INTO ckb_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","سامیش کوڕی بوو کە یافەت برای گەورەی بوو. سام باپیرە گەورەی هەموو کوڕانی عێبەر بوو. ");
INSERT INTO ckb_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","کوڕەکانی سام: ئیلام، ئەشوور، ئەرپەکشاد، لوود و ئارام. ");
INSERT INTO ckb_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","کوڕەکانی ئارام: عوچ، حوول، گەتەر و مەشەک. ");
INSERT INTO ckb_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","ئەرپەکشاد باوکی شالەح بوو، شالەحیش باوکی عێبەر بوو. ");
INSERT INTO ckb_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","عێبەریش دوو کوڕی بوو، یەکێکیان ناوی پەلەگ بوو، چونکە لە سەردەمی ئەودا زەوی دابەش کرا. براکەشی ناوی یۆقتان بوو. ");
INSERT INTO ckb_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","یۆقتان ئەم کوڕانەی هەبوو: ئەلمۆداد، شەلەف، حەچەرماڤەت، یارەح، ");
INSERT INTO ckb_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","هەدۆرام، ئوزال، دیقلە، ");
INSERT INTO ckb_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","عۆبال، ئەبیمائێل، شەبا، ");
INSERT INTO ckb_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ئۆفیر، حەڤیلا و یۆڤاڤ. هەموو ئەمانە کوڕانی یۆقتان بوون. ");
INSERT INTO ckb_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","نشینگەکانیان لە مێشاوە دەستی پێدەکرد هەتا دەگەیشتە سفاری ناوچە شاخاوییەکانی ڕۆژهەڵات. ");
INSERT INTO ckb_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","ئەمانەن نەوەی سام، بەپێی هۆزیان و زمانیان، لە خاکیان و بەپێی نەتەوەکانیان. ");
INSERT INTO ckb_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","ئەمانەن هۆزەکانی نەوەی نوح بەپێی نەوەکانیان لەنێو نەتەوەکانیان. لە ئەوانیشەوە لەدوای لافاوەکە نەتەوەکان بەسەر زەویدا بڵاو بوونەوە. ");
INSERT INTO ckb_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","هەموو جیهان یەک زمان و یەک جۆر قسەکردنیان هەبوو. ");
INSERT INTO ckb_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","ئینجا کاتێک بۆ ڕۆژهەڵات کۆچیان کرد، دەشتاییەکیان لە خاکی شینعار دۆزییەوە و لەوێ نیشتەجێ بوون. ");
INSERT INTO ckb_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","ئینجا بە یەکتریان گوت: «وەرن، با خشت دروستبکەین و تەواو سووری بکەینەوە.» ئیتر لە جیاتی بەرد خشتیان بەکارهێنا، قیریش لە جیاتی قوڕ. ");
INSERT INTO ckb_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","هەروەها گوتیان: «وەرن، با شارێک بۆ خۆمان دروستبکەین لەگەڵ قوللەیەک کە سەری لە ئاسمان بدات. ناوێکیش بۆ خۆمان دروستدەکەین، تاکو بەسەر هەموو ڕووی زەویدا پەرت نەبین.» ");
INSERT INTO ckb_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","بەڵام یەزدان بۆ بینینی ئەو شار و قوللەیەی کە ئادەمیزاد دروستی دەکرد هاتە خوارەوە. ");
INSERT INTO ckb_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","یەزدان فەرمووی: «ئەگەر هەموویان یەک گەل و یەک زمان بن، ئەوە سەرەتای دەستپێکردنیانە، هیچ شتێک لەلایان مەحاڵ نابێت، لەوەی مەبەستیانە بیکەن. ");
INSERT INTO ckb_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","وەرن با بچینە خوارەوە و لەوێ زمانیان بشێوێنین، بۆ ئەوەی کەسیان لە زمانی ئەوی دیکەیان نەگات.» ");
INSERT INTO ckb_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","ئینجا یەزدان لەوێوە بەسەر هەموو زەویدا پەرتی کردن. ئیتر وازیان لە بنیادنانی شارەکە هێنا. ");
INSERT INTO ckb_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","لەبەر ئەمە ناونرا بابل، چونکە لەوێدا یەزدان زمانی هەموو زەوی شێواند. هەر لەوێشەوە یەزدان بەسەر هەموو ڕووی زەویدا پەرتی کردن. ");
INSERT INTO ckb_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","ئەمانەش نەوەکانی سامن. دوو ساڵ لەدوای لافاوەکە، کاتێک سام تەمەنی سەد ساڵ بوو، ئەرپەکشاد لە نەوەی ئەو لەدایکبوو. ");
INSERT INTO ckb_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","دوای لەدایکبوونی ئەرپەکشاد، سام پێنج سەد ساڵ ژیا، کوڕ و کچی دیکەشی بوو. ");
INSERT INTO ckb_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","ئەرپەکشاد لە تەمەنی سی و پێنج ساڵیدا بووە باوکی شالەح. ");
INSERT INTO ckb_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","دوای لەدایکبوونی شالەح، ئەرپەکشاد چوار سەد و سێ ساڵ ژیا، کوڕ و کچی دیکەشی بوو. ");
INSERT INTO ckb_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","شالەح لە تەمەنی سی ساڵیدا بووە باوکی عێبەر. ");
INSERT INTO ckb_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","دوای لەدایکبوونی عێبەر، شالەح چوار سەد و سێ ساڵ ژیا، کوڕ و کچی دیکەشی بوو. ");
INSERT INTO ckb_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","عێبەر لە تەمەنی سی و چوار ساڵیدا بووە باوکی پەلەگ. ");
INSERT INTO ckb_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","لەدوای لەدایکبوونی پەلەگ، عێبەر چوار سەد و سی ساڵ ژیا، کوڕ و کچی دیکەشی بوو. ");
INSERT INTO ckb_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","پەلەگ لە تەمەنی سی ساڵیدا بووە باوکی ڕەعو. ");
INSERT INTO ckb_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","دوای لەدایکبوونی ڕەعو، پەلەگ دوو سەد و نۆ ساڵ ژیا، کوڕ و کچی دیکەشی بوو. ");
INSERT INTO ckb_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","ڕەعو لە تەمەنی سی و دوو ساڵیدا بووە باوکی سەروگ. ");
INSERT INTO ckb_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","دوای لەدایکبوونی سەروگ، ڕەعو دوو سەد و حەوت ساڵ ژیا، کوڕ و کچی دیکەشی بوو. ");
INSERT INTO ckb_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","سەروگ لە تەمەنی سی ساڵیدا بووە باوکی ناحۆر. ");
INSERT INTO ckb_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","دوای لەدایکبوونی ناحۆر، سەروگ دوو سەد ساڵ ژیا، کوڕ و کچی دیکەشی بوو. ");
INSERT INTO ckb_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","ناحۆر لە تەمەنی بیست و نۆ ساڵیدا بووە باوکی تارەح. ");
INSERT INTO ckb_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","دوای لەدایکبوونی تارەح، ناحۆر سەد و نۆزدە ساڵ ژیا، کوڕ و کچی دیکەشی بوو. ");
INSERT INTO ckb_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","تارەح لە تەمەنی حەفتا ساڵیدا بووە باوکی ئەبرام و ناحۆر و هاران. ");
INSERT INTO ckb_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","ئەمانەش نەوەکانی تارەحن. تارەح ئەبرام و ناحۆر و هارانی بوو. هارانیش لوتی بوو. ");
INSERT INTO ckb_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","هاران پێش تارەحی باوکی لە ئووری کلدانییەکان مرد، لەو خاکەی تێیدا لەدایک ببوو. ");
INSERT INTO ckb_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","ئەبرام و ناحۆر هەردووکیان ژنیان هێنا. ژنەکەی ئەبرام ناوی سارای بوو، ژنەکەی ناحۆریش ناوی میلکەی کچی هاران بوو، کە هاران باوکی میلکە و یەسکە بوو. ");
INSERT INTO ckb_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","سارای نەزۆک بوو، منداڵی نەبوو. ");
INSERT INTO ckb_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","تارەح ئەبرامی کوڕی و لوتی کوڕەزای، کە کوڕی هاران بوو، لەگەڵ سارایی بووکی، کە ژنی ئەبرامی کوڕی بوو، برد و پێکەوە لە ئووری کلدانییەکانەوە بەڕێکەوتن تاکو بچنە خاکی کەنعان. بەڵام کاتێک هاتنە حەڕان، لەوێ نیشتەجێ بوون. ");
INSERT INTO ckb_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","ئینجا تارەح لە تەمەنی دوو سەد و پێنج ساڵیدا لە حەڕان مرد. ");
INSERT INTO ckb_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","یەزدان بە ئەبرامی فەرموو: «خاک و کەسوکار و ماڵی باوکت بەجێبهێڵە و بڕۆ بۆ ئەو خاکەی پیشانت دەدەم. ");
INSERT INTO ckb_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","«جا دەتکەمە نەتەوەیەکی مەزن، بەرەکەتدارت دەکەم، ناوت مەزن دەکەم، دەبیتە بەرەکەت. ");
INSERT INTO ckb_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","ئەوانەی داوای بەرەکەتت بۆ دەکەن بەرەکەتداریان دەکەم، نەفرەتیش لە نەفرەتکارانت دەکەم. هەموو نەتەوەکانی سەر زەویش لە ڕێگەی تۆوە بەرەکەتدار دەبن.» ");
INSERT INTO ckb_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","ئیتر ئەبرام ڕۆیشت، هەروەک یەزدان پێی فەرموو، لوتیش لەگەڵی چوو. ئەبرام لە تەمەنی حەفتا و پێنج ساڵیدا بوو کە حەڕانی بەجێهێشت. ");
INSERT INTO ckb_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","ئەبرام سارایی ژنی و لوتی برازای و هەموو ئەو دەستکەوتانەی دەستیان کەوتبوو، لەگەڵ ئەو کەسانەی لە حەڕان بەدەستیان هێنابوو، لەگەڵ خۆیدا بردنی و بەرەو خاکی کەنعان چوون و گەیشتنە ئەوێ. ");
INSERT INTO ckb_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","ئەبرام بە خاکەکەدا تێپەڕی هەتا گەیشتە دار بەڕووەکەی مۆرە لە شەخەم. لەو کاتەدا کەنعانییەکان لە خاکەکەدا بوون. ");
INSERT INTO ckb_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","یەزدان بۆ ئەبرام دەرکەوت و فەرمووی: «ئەم خاکە دەدەمە نەوەی تۆ.» ئەویش لەوێ قوربانگایەکی بۆ یەزدان دروستکرد کە بۆی دەرکەوتبوو. ");
INSERT INTO ckb_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","لەوێشەوە گواستییەوە بۆ چیاکەی ڕۆژهەڵاتی بێت‌ئێل و چادرەکەی خۆی هەڵدا. بێت‌ئێل کەوتبووە ڕۆژئاوایەوە و عای لە ڕۆژهەڵاتییەوە بوو. لەوێ قوربانگایەکی بۆ یەزدان دروستکرد و بە ناوی یەزدانەوە نزای کرد. ");
INSERT INTO ckb_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","پاشان ئەبرام ڕووەو نەقەب بەردەوام بوو لە کۆچکردن. ");
INSERT INTO ckb_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","لەو کاتەدا قاتوقڕی لە خاکەکەدا هەبوو، جا ئەبرام چوو بۆ میسر، تاکو بۆ ماوەیەک لەوێ بژیێت، چونکە قاتوقڕییەکە زۆر بوو. ");
INSERT INTO ckb_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","کاتێکیش نزیک بوو بچێتە ناو میسر، بە سارایی ژنی گوت: «بەڕاستی من دەزانم کە تۆ ژنێکی ڕوخسار جوانیت. ");
INSERT INTO ckb_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","کاتێک میسرییەکان دەتبینن، دەڵێن: ”ئەمە ژنەکەیەتی.“ ئەو کاتە من دەکوژن بەڵام تۆ دەهێڵنەوە. ");
INSERT INTO ckb_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","بڵێ کە تۆ خوشکی منیت، بۆ ئەوەی بەهۆی تۆوە بە چاکی ڕەفتارم لەگەڵ بکەن، لەبەر تۆش گیانم بە زیندوویی دەمێنێتەوە.» ");
INSERT INTO ckb_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","کاتێک ئەبرام هاتە میسر، میسرییەکان بینییان کە سارای زۆر جوانە. ");
INSERT INTO ckb_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","کە کاربەدەستانی فیرعەون بینییان، لەلای فیرعەون ستایشیان کرد، ئیتر ژنەکەیان بردە ماڵی فیرعەون. ");
INSERT INTO ckb_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","ئەویش بەهۆی ژنەکە بە باشی ڕەفتاری لەگەڵ ئەبرام کرد. ئیتر بووە خاوەنی مەڕ و مانگا و نێرەکەر و ماکەر و کۆیلە و کەنیزە و وشتر. ");
INSERT INTO ckb_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","بەڵام یەزدان بەهۆی سارایی ژنی ئەبرامەوە فیرعەون و ماڵەکەی تووشی دەردی گران کرد. ");
INSERT INTO ckb_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","ئیتر فیرعەون بەدوای ئەبرامدا ناردی و گوتی: «ئەمە چییە تۆ بە منت کرد؟ بۆچی پێت ڕانەگەیاندم کە ئەو ژنی تۆیە؟ ");
INSERT INTO ckb_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","بۆچی گوتت ”ئەو خوشکمە،“ تاکو بیبەم بۆ ئەوەی ببێتە ژنم؟ ئێستاش ئەوەتا ژنەکەت. بیبە و بڕۆ!» ");
INSERT INTO ckb_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","ئینجا فیرعەون هەندێک پیاوی ڕاسپارد بۆ بەڕێکردنی ئەبرام و ژنەکەی و هەرچییەکی هەیانبوو. ");
INSERT INTO ckb_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","ئیتر ئەبرام خۆی و ژنەکەی و هەرچییەکی هەبوو، لەگەڵ لوت لە میسرەوە چوونە نەقەب. ");
INSERT INTO ckb_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","ئەبرام لە مەڕوماڵات و لە زیو و زێڕ زۆر دەوڵەمەند بوو. ");
INSERT INTO ckb_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","قۆناغ بە قۆناغ کۆچی کرد، لە نەقەبەوە هەتا بێت‌ئێل، هەتا ئەو شوێنەی یەکەم جار چادرەکەی ئەوی لێبوو، لەنێوان بێت‌ئێل و عای، ");
INSERT INTO ckb_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","بۆ شوێنی قوربانگاکەی کە یەکەم جار دروستی کرد، لەوێدا ئەبرام بە ناوی یەزدانەوە نزای کرد. ");
INSERT INTO ckb_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","هەروەها لوتیش کە لەگەڵ ئەبرام دەڕۆیشت، مەڕ و مانگا و چادری هەبوو. ");
INSERT INTO ckb_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","بەڵام خاکەکە لەوەڕگای پێویستی بۆ مەڕوماڵاتی هەردووکیان نەبوو، لەبەر ئەوەی دەستکەوتەکانیان هێندە زۆر ببوو کە نەتوانن پێکەوە بمێننەوە. ");
INSERT INTO ckb_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","ناکۆکی لەنێوان شوانەکانی مەڕوماڵاتی ئەبرام و شوانەکانی مەڕوماڵاتی لوت ڕوویدا. لەو کاتەشدا کەنعانییەکان و پریزییەکان نیشتەجێی خاکەکە بوون. ");
INSERT INTO ckb_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","ئینجا ئەبرام بە لوتی گوت: «با هیچ ناکۆکییەک نەکەوێتە نێوان من و تۆ و نێوان شوانەکانم و شوانەکانتەوە، چونکە ئێمە مام و برازاین. ");
INSERT INTO ckb_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","ئەوە نییە هەموو خاکەکە لەبەردەمتە؟ کەواتە لە من جیا ببەوە. ئەگەر بەلای چەپدا بڕۆیت، من بەلای ڕاستدا دەڕۆم و ئەگەر بەلای ڕاستدا بڕۆیت، من بەلای چەپدا دەڕۆم.» ");
INSERT INTO ckb_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","لوت چاوی هەڵبڕی و بینی هەموو دەوروبەری ڕووباری ئوردون ئاودارە. وەک بەهەشتی یەزدانە، وەک خاکی میسر کە بەرەو زۆعەر دەڕۆیت. ئەمە پێش ئەوەی یەزدان سەدۆم و عەمۆرا وێران بکات. ");
INSERT INTO ckb_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","لوت هەموو دەوروبەری ڕووباری ئوردونی بۆ خۆی هەڵبژارد و بەرەو ڕۆژهەڵات کۆچی کرد. بەو شێوەیە لە یەکتری جیا بوونەوە. ");
INSERT INTO ckb_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","ئەبرام لە خاکی کەنعان نیشتەجێ بوو، لوتیش لە شارۆچکەکانی دەوروبەر نیشتەجێ بوو و لە نزیک سەدۆم چادرەکانی هەڵدا. ");
INSERT INTO ckb_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","خەڵکی سەدۆم لە ڕادەبەدەر بەدکار بوون و گوناهیان دژی یەزدان دەکرد. ");
INSERT INTO ckb_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","دوای جیابوونەوەی لوت لە ئەبرام، یەزدان بە ئەبرامی فەرموو: «چاوت هەڵبڕە و لەو شوێنەی کە لێیت، سەیری باکوور و باشوور و ڕۆژهەڵات و ڕۆژئاوا بکە، ");
INSERT INTO ckb_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","چونکە هەموو ئەو خاکەی دەیبینیت بۆ هەتاهەتایە دەیدەمە خۆت و نەوەکانت. ");
INSERT INTO ckb_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","نەوەشت وەک خۆڵی زەوی لێ دەکەم، تاکو ئەگەر یەکێک توانی خۆڵی زەوی بژمێرێت، ئەوا نەوەی تۆش بژمێردرێت. ");
INSERT INTO ckb_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","بڕۆ، بە درێژایی و پانی خاکەکەدا هاتوچۆ بکە، چونکە دەیدەمە تۆ.» ");
INSERT INTO ckb_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","ئیتر ئەبرام چادرەکانی گواستەوە و هات لەلای دار بەڕووەکانی مەمرێ لە حەبرۆن نیشتەجێ بوو، لەوێ قوربانگایەکی بۆ یەزدان دروستکرد. ");
INSERT INTO ckb_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","لەو سەردەمەی کە ئەمرافەلی پاشای شینعار و ئەریۆکی پاشای ئەلاسار و کدارلاعۆمەری پاشای ئیلام و تیدعالی پاشای گۆئیم بوو، ");
INSERT INTO ckb_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","ئەم پاشایانە لە دژی بەرەعی پاشای سەدۆم و بیرشەعی پاشای عەمۆرا و شینئابی پاشای ئەدما و شەمێڤەری پاشای چەبۆئیم، لەگەڵ پاشای بەلەع کە شاری زۆعەرە جەنگێکیان بەرپا کرد. ");
INSERT INTO ckb_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","هەموو ئەمانە لە دۆڵی سیدیم هێزەکانیان یەکخست، کە ئێستا پێی دەگوترێت دەریای مردوو. ");
INSERT INTO ckb_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","بۆ ماوەی دوازدە ساڵ ژێردەستەی کدارلاعۆمەر بوون، بەڵام لە ساڵی سێزدەمین لێی یاخی بوون. ");
INSERT INTO ckb_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","لە ساڵی چواردەمین، کدارلاعۆمەر خۆی و پاشا هاوپەیمانەکانی هاتن و لە عەشترۆت قەرنەیم ڕفائییەکان و لە هام زوزییەکان و لە شاڤێ قیریاتەیم ئێمییەکانیان بەزاند. ");
INSERT INTO ckb_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","هەروەها حۆرییەکانیان لە ناوچە شاخاوییەکانی سێعیر بەزاند و هەتا ئێل پاران لە نزیک بیابان ڕۆیشتن. ");
INSERT INTO ckb_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","ئینجا گەڕانەوە و چوونە کانی میشپات کە قادێشە و بەسەر هەموو هەرێمی عەمالێقییەکاندا زاڵ بوون، هەروەها ئەمۆرییەکانیش کە نیشتەجێی حەچەچۆن تامار بوون. ");
INSERT INTO ckb_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","ئینجا پاشاکانی سەدۆم، عەمۆرا، ئەدما، چەبۆئیم و بەلەع کە شاری زۆعەرە، هاتنە دەرەوە و لە دۆڵی سیدیم بۆ جەنگ ڕیزیان بەست، ");
INSERT INTO ckb_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","لە دژی کدارلاعۆمەری پاشای ئیلام و تیدعالی پاشای گۆئیم و ئەمرافەلی پاشای شینعار و ئەریۆکی پاشای ئەلاسار. چوار پاشا بەرامبەر بە پێنج. ");
INSERT INTO ckb_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","دۆڵی سیدیم پڕ بوو لە چاڵە قیر، بۆیە هەردوو پاشای سەدۆم و عەمۆرا لە کاتی هەڵاتندا کەوتنە نێو چاڵەکانەوە، بەڵام پاشاکانی دیکە بۆ چیاکان هەڵاتن. ");
INSERT INTO ckb_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","ئیتر چوار پاشاکە هەموو شتومەک و خۆراکەکانی سەدۆم و عەمۆرایان برد و ڕۆیشتن. ");
INSERT INTO ckb_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","هەروەها لوتی برازای ئەبرامیان لەگەڵ هەموو شتومەکەکەیان برد کە لە سەدۆم نیشتەجێ بوو. ");
INSERT INTO ckb_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","یەکێک لە دەربازبووان هات و بە ئەبرامی عیبرانی ڕاگەیاند. ئەو کاتە لەلای دار بەڕووەکانی مەمرێی ئەمۆری، براکەی ئەشکۆل و عانێر، نیشتەجێ بوو. ئەمانیش لەگەڵ ئەبرام هاوپەیمان بوون. ");
INSERT INTO ckb_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","کاتێک ئەبرام بیستی کە برازاکەی ڕاپێچ کراوە، بانگەوازی بۆ خزمەتکارە مەشقپێکراوەکانی دەرکرد کە لەدایکبووی ماڵەکەی بوون و سێ سەد و هەژدە کەس بوون، ئیتر هەتا شاری دان بەدوایان کەوت. ");
INSERT INTO ckb_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","کە شەو داهات خۆی و پیاوەکانی دابەش بوون و هێرشی بردە سەریان و تەفروتونای کردن و هەتا حۆڤا دەریپەڕاندن، کە لە باکووری دیمەشقە. ");
INSERT INTO ckb_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","جا هەموو شتومەکەکان و هەروەها لوتی برازای و شتومەکەکانی و ژنەکان و خەڵکەکەی هێنایەوە. ");
INSERT INTO ckb_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","دوای گەڕانەوەی ئەبرام لە بەزاندنی کدارلاعۆمەر و پاشاکانی دیکەی هاوپەیمانی، پاشای سەدۆم لە دۆڵی شاڤێ کە دۆڵی پاشایە بۆ پێشوازیکردنی هاتە دەرەوە. ");
INSERT INTO ckb_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","مەلکیسادقی پاشای شالیمیش کە کاهینی خودای هەرەبەرز بوو، نان و شەرابی بۆ ئەبرام هێنا. ");
INSERT INTO ckb_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","ئینجا داوای بەرەکەتی بۆ کرد و گوتی: «با خودای هەرەبەرز، دروستکەری ئاسمان و زەوی، ئەبرام بەرەکەتدار بکات. ");
INSERT INTO ckb_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","ستایش بۆ خودای هەرەبەرز کە دوژمنەکانتی دایە دەستت.» ئەبرامیش دەیەکی هەموو شتێکی پێدا. ");
INSERT INTO ckb_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","ئینجا پاشای سەدۆم بە ئەبرامی گوت: «خەڵکەکە بدە من و شتومەکەکانیش بۆ خۆت ببە.» ");
INSERT INTO ckb_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","بەڵام ئەبرام بە پاشای سەدۆمی گوت: «سوێندم خواردووە بۆ یەزدانی پەروەردگاری هەرەبەرز، دروستکەری ئاسمان و زەوی، ");
INSERT INTO ckb_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","کە لە ماڵ و سامانی تۆ هیچ شتێک نەبەم، تەنانەت تاڵە دەزووێک یان ئاوزەنگێکی پێڵاو، بۆ ئەوەی هەرگیز نەڵێیت: ”من ئەبرامم دەوڵەمەند کرد.“ ");
INSERT INTO ckb_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","تەنها ئەوە نەبێت کە هەرزەکارەکان خواردوویانە، بەشەکەی ئەو پیاوانەش کە لەگەڵم هاتن، عانێر و ئەشکۆل و مەمرێ. با ئەوانیش بەشی خۆیان وەربگرن.» ");
INSERT INTO ckb_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","لەدوای ئەم ڕووداوانە، لە بینینێکدا فەرمایشتی یەزدان بۆ ئەبرام هات و فەرمووی: «مەترسە ئەی ئەبرام، من قەڵغانم بۆت، پاداشتت زۆر گەورەیە.» ");
INSERT INTO ckb_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","بەڵام ئەبرام گوتی: «ئەی یەزدانی باڵادەست، چیم دەدەیتێ کە من هەروا وەجاخکوێر بم و میراتگری ماڵم ئەلیعەزەری دیمەشقییە؟» ");
INSERT INTO ckb_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","هەروەها ئەبرام گوتی: «هیچ وەجاخێکت نەداومەتێ، ئەوەی لە ماڵەکەم لەدایک بووە وا دەبێتە میراتگرم.» ");
INSERT INTO ckb_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","لەو کاتەدا فەرمایشتی یەزدانی بۆ هات و فەرمووی: «ئەمە نابێتە میراتگرت، بەڵکو ئەوەی لە پشتی تۆوە دێت، ئەو دەبێتە میراتگرت.» ");
INSERT INTO ckb_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","ئینجا بردییە دەرەوە و فەرمووی: «سەیری ئاسمان بکە و ئەستێرەکان بژمێرە، ئەگەر دەتوانیت.» هەروەها پێی فەرموو: «نەوەکەت ئاوا دەبێت.» ");
INSERT INTO ckb_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","جا ئەبرام باوەڕی بە یەزدان هێنا و ئەویش ئەمەی بە ڕاستودروستی بۆ دانا. ");
INSERT INTO ckb_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","هەروەها یەزدان پێی فەرموو: «من یەزدانم، ئەوەی لە ئووری کلدانییەکانەوە تۆی هێنایە دەرەوە، تاکو ئەم زەوییەت بە میرات پێ ببەخشێت.» ");
INSERT INTO ckb_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","بەڵام ئەبرام گوتی: «ئەی یەزدانی باڵادەست، چۆن بزانم کە من دەبمە میراتگری ئەم زەوییە؟» ");
INSERT INTO ckb_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","یەزدانیش پێی فەرموو: «گوێرەکەیەکی مێینەی سێ ساڵە و بزنێکی سێ ساڵە و بەرانێکی سێ ساڵە و قومرییەک و کۆترێکم بۆ بهێنە.» ");
INSERT INTO ckb_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","ئەمانەی هەموو بۆ هێنا و لە ناوەڕاستەوە لەتی کردن، لەتی هەریەکەشیانی بەرامبەر ئەوی دیکە دانا، بەڵام باڵندەکانی لەت نەکرد. ");
INSERT INTO ckb_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","ئینجا سیسارکە کەچەڵەکان بۆ سەر کەلاکەکان هاتنە خوارەوە، بەڵام ئەبرام دووری خستنەوە. ");
INSERT INTO ckb_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","کە خۆر بەرەو ئاوابوون دەچوو، ئەبرام کەوتە خەوێکی قووڵەوە و لەناکاو تاریکییەکی ترسناک و سەختی بەسەردا هات. ");
INSERT INTO ckb_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","ئینجا یەزدان بە ئەبرامی فەرموو: «بە دڵنیاییەوە بزانە کە نەوەکانت لە خاکێک نامۆ دەبن کە هی خۆیان نییە، دەبنە کۆیلەیان و چوار سەد ساڵ دەیانچەوسێننەوە. ");
INSERT INTO ckb_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","بەڵام سزای ئەو نەتەوەیەش دەدەم، کە ئەوان وەک کۆیلە خزمەتیان دەکەن. لەدوای ئەوە بە دەستکەوتێکی زۆرەوە دێنە دەرەوە. ");
INSERT INTO ckb_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","بەڵام تۆ بە سەلامەتی دەچیتە لای باوباپیرانت و لە تەمەنێکی باشی پیریدا دەنێژرێیت. ");
INSERT INTO ckb_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","لە نەوەی چوارەمیشدا، نەوەکانت دەگەڕێنەوە ئێرە، چونکە هێشتا تاوانی ئەمۆرییەکان نەگەیشتووەتە ڕادەی خۆی.» ");
INSERT INTO ckb_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","ئینجا کاتێک خۆر ئاوابوو و تاریکی داهات، لەناکاو تەنوورێکی پڕ دووکەڵ و مەشخەڵێکی داگیرساو دەرکەوت و بە نێوان ئاژەڵە دوولەتکراوەکاندا تێپەڕی. ");
INSERT INTO ckb_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","لەو ڕۆژەدا یەزدان پەیمانێکی لەگەڵ ئەبرامدا بەست و پێی فەرموو: «ئەم خاکە دەدەمە نەوەکانی تۆ، لە ڕووباری میسرەوە هەتا ڕووبارە گەورەکە، ڕووباری فورات، ");
INSERT INTO ckb_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","خاکی قێنی و قەنیزی، قەدمۆنی، ");
INSERT INTO ckb_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","حیتی، پریزی، ڕفائی، ");
INSERT INTO ckb_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","ئەمۆری، کەنعانی، گرگاشی و یەبوسییەکان.» ");
INSERT INTO ckb_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","سارایی ژنی ئەبرام هیچ منداڵی بۆ ئەبرام نەبوو، بەڵام کەنیزەیەکی میسری هەبوو ناوی هاجەر بوو. ");
INSERT INTO ckb_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","سارای بە ئەبرامی گوت: «یەزدان ڕێی منداڵبوونی لێ گرتووم. لەگەڵ کەنیزەکەم سەرجێیی بکە، بەڵکو لەوەوە منداڵم بۆ ببێت.» ئەبرامیش بە قسەی سارایی کرد. ");
INSERT INTO ckb_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","ئینجا پاش دە ساڵ لە نیشتەجێبوونی ئەبرام لە خاکی کەنعان، سارایی ژنی ئەبرام هاجەری کەنیزە میسرییەکەی هێنا و دایە ئەبرامی مێردی تاکو ببێتە ژنی. ");
INSERT INTO ckb_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","ئیتر لەگەڵ هاجەر سەرجێیی کرد و ئەویش سکی پڕ بوو. کاتێک کە زانی سکی هەیە، خانمەکەی خۆی لەبەرچاو سووک بوو. ");
INSERT INTO ckb_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","ئینجا سارای بە ئەبرامی گوت: «تۆ بەرپرسی لەو سووکایەتییەی بە من دەکرێت. من کەنیزەکەی خۆمم خستە باوەشی تۆ، ئێستاش کە زانی سکی هەیە، لەبەرچاویدا سووک بووم. با یەزدان دادوەریی نێوان من و تۆ بکات.» ");
INSERT INTO ckb_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","ئەبرامیش بە سارایی گوت: «وا کەنیزەکەت لەبەردەستی خۆتدایە، چیت پێ باشە وای لێ بکە.» ئیتر سارای ئەوەندە بەدڕەفتاری لەگەڵ هاجەر کرد، هەتا لە دەستی هەڵات. ");
INSERT INTO ckb_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","ئینجا فریشتەی یەزدان لە چۆڵەوانی هاجەری لەسەر کانییەک دۆزییەوە؛ ئەو کانییەی کە لەسەر ڕێگای شوورە. ");
INSERT INTO ckb_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","فەرمووی: «ئەی هاجەری کەنیزەی سارای، لەکوێوە هاتوویت و بۆ کوێ دەچیت؟» ئەویش گوتی: «لەدەست سارایی خانمم ڕامکردووە.» ");
INSERT INTO ckb_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","فریشتەکەی یەزدان پێی فەرموو: «بگەڕێوە لای خانمەکەت و ژێردەستەی بە.» ");
INSERT INTO ckb_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","هەروەها پێی فەرموو: «وەچەکانت بێ ئەندازە زۆر دەکەم کە لەبەر زۆرییان لە ژماردن نەیەن.» ");
INSERT INTO ckb_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","دیسان فریشتەکەی یەزدان پێی فەرموو: «ئێستا سکت پڕە، کوڕێکت دەبێت، ناوی دەنێیت ئیسماعیل، چونکە یەزدان گوێی لە زەلیلیی تۆ بوو. ");
INSERT INTO ckb_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","ئەو دەبێتە مرۆڤێک وەک کەرەکێوی لێ دێت. دەستی لە دژی هەموو کەسێک دەبێت و دەستی هەموو کەسێکیش لە دژی ئەو. دەبێتە نەیاری هەموو براکانیشی.» ");
INSERT INTO ckb_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","ئینجا ئەم ناوەی لە یەزدان نا کە لەگەڵیدا دوا، «تۆ ئەو خودایەی کە دەبینیت،» چونکە هاجەر گوتی: «ئا لێرەشدا ئەوم بینی کە دەمبینێت.» ");
INSERT INTO ckb_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","لەبەر ئەمەشە کە ئەو بیرە بە «بیری لەحەی ڕۆئی» ناونراوە، ئێستاش وا لەنێوان قادێش و بەرەدە. ");
INSERT INTO ckb_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","ئیتر هاجەر کوڕێکی بۆ ئەبرام بوو، ئەبرامیش ئەو کوڕەی ناو نا ئیسماعیل. ");
INSERT INTO ckb_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","ئەبرام تەمەنی هەشتا و شەش ساڵ بوو کاتێک هاجەر ئیسماعیلی بۆ ئەبرام بوو. ");
INSERT INTO ckb_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","کاتێک ئەبرام تەمەنی نەوەد و نۆ ساڵ بوو، یەزدان بۆ ئەبرام دەرکەوت و پێی فەرموو: «من خودای هەرە بەتوانام. دۆستایەتی من بکە و بێ کەموکوڕی بە. ");
INSERT INTO ckb_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","پەیمانی خۆم لەنێوان خۆم و تۆدا دەبەستم و زۆر زۆرت دەکەم.» ");
INSERT INTO ckb_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","ئەبرام خۆی بە زەویدا دا، خوداش پێی فەرموو: ");
INSERT INTO ckb_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","«لەلایەن منەوە، ئەمە پەیمانی منە لەگەڵ تۆ: تۆ دەبیتە باوکی چەندین نەتەوە. ");
INSERT INTO ckb_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","ئیتر لەمەودواش ناوت بە ئەبرام ناهێنرێت، بەڵکو ناوت دەبێتە ئیبراهیم، چونکە من تۆم کردووە بە باوکی چەندین نەتەوە. ");
INSERT INTO ckb_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","زۆر زۆریش بەردارت دەکەم و چەندین نەتەوەت لێ دروست دەکەم و پاشایانت لێ دەکەوێتەوە. ");
INSERT INTO ckb_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","پەیمانەکەم کە پەیمانێکی هەتاهەتاییە لەنێوان خۆم و تۆ و نەوەی تۆدا دەچەسپێنم، کە ببمە خودای تۆ و نەوەکانی تۆ. ");
INSERT INTO ckb_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","هەموو خاکی کەنعان، کە ئێستا وەک بێگانەیەک تێیدا نیشتەجێی، بۆ هەتاهەتایە بە موڵکی دەیدەمە تۆ و نەوەکانی تۆ؛ منیش دەبمە خودایان.» ");
INSERT INTO ckb_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","ئینجا خودا بە ئیبراهیمی فەرموو: «تۆش لەلای خۆتەوە دەبێت پەیمانەکەم بەجێبهێنیت، خۆت و نەوە لە دوای نەوەشت. ");
INSERT INTO ckb_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","ئەمەش پەیمانەکەمە کە بەجێی دەهێنن لەنێوان من و ئێوە و نەوەی دوای خۆت: هەموو نێرینەیەکتان خەتەنە دەکەن. ");
INSERT INTO ckb_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","خۆتان خەتەنە دەکەن، کە دەبێتە نیشانەی پەیمانەکەی نێوان من و ئێوە. ");
INSERT INTO ckb_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","هەموو نێرینەیەکی هەشت ڕۆژەش لە ئێوە دەبێت خەتەنە بکرێت، لە نەوەکانتان، ئەوەی لە ماڵەکەت لەدایک بووە، یان ئەوەی بە زیو لە بیانی کڕاوە و نەوەی خۆت نییە. ");
INSERT INTO ckb_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","دەبێت ئەوەی لە ماڵەکەت لەدایک بووە یان بە زیو کڕاوە بە تەواوی خەتەنە بکرێت، جا پەیمانەکەم لە ئێوەدا پەیمانێکی هەتاهەتایی دەبێت. ");
INSERT INTO ckb_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","هەر نێرینەیەکی خەتەنەنەکراویش، کە خەتەنە نەکرابێت، ئەوە لە نەتەوەکەی دادەبڕدرێت، چونکە پەیمانی منی شکاندووە.» ");
INSERT INTO ckb_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","هەروەها خودا بە ئیبراهیمی فەرموو: «سارایی ژنیشت، ئیتر بە سارای ناوی مەهێنە، بەڵکو ناوی دەبێتە سارا. ");
INSERT INTO ckb_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","بەرەکەتداری دەکەم و لەوەوە کوڕێکت پێ دەبەخشم. بەرەکەتداری دەکەم و چەندین نەتەوە و چەندین پاشای نەتەوەکان لەوەوە دەبن.» ");
INSERT INTO ckb_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","ئیبراهیم بەسەر ڕوویدا کەوت و پێکەنی، لە دڵی خۆیدا گوتی: «ئایا پیاوێکی سەد ساڵە منداڵی دەبێت؟ ئایا سارا لە تەمەنی نەوەد ساڵیدا منداڵی دەبێت؟» ");
INSERT INTO ckb_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","ئیبراهیم بە خودای گوت: «خۆزگە ئیسماعیل لەژێر سایەی بەرەکەتی تۆدا ژیانی بەسەر دەبرد.» ");
INSERT INTO ckb_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","خوداش فەرمووی: «بەڵێ، بەڵام لە سارای ژنت کوڕێکت دەبێت، ناوی دەنێیت ئیسحاق. پەیمانی خۆمی لەگەڵدا دەچەسپێنم، پەیمانێکی هەتاهەتایی بۆ نەوەکەی دوای خۆی. ");
INSERT INTO ckb_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","بۆ ئیسماعیلیش، گوێم لێت بوو، بێگومان بەرەکەتداری دەکەم، بەرداری دەکەم و زۆر زۆری دەکەم. دەبێتە باوکی دوازدە سەرۆک، دەیکەمە نەتەوەیەکی مەزن. ");
INSERT INTO ckb_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","بەڵام پەیمانەکەم لەگەڵ ئیسحاقدا دەچەسپێنم، کە ساڵێکی دیکە ئەم کاتە سارا بۆ تۆی دەبێت.» ");
INSERT INTO ckb_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","کاتێک خودا لە قسەکانی بووەوە لەگەڵ ئیبراهیم، لەلای ڕۆیشت و بەرزبووەوە. ");
INSERT INTO ckb_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","لە هەمان ڕۆژدا ئیبراهیم، ئیسماعیلی کوڕی و هەموو ئەوانەی لە ماڵەکەیدا لەدایک ببوون یان بە زیوی خۆی کڕابوون، هەموو نێرینەکانی ماڵەکەی خۆی هێنا و خەتەنەی کردن، وەک چۆن خودا پێی فەرموو بوو. ");
INSERT INTO ckb_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","ئیبراهیم تەمەنی نەوەد و نۆ ساڵ بوو کاتێک خەتەنە کرا، ");
INSERT INTO ckb_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","ئیسماعیلی کوڕیشی تەمەنی سێزدە ساڵ بوو کاتێک خەتەنە کرا. ");
INSERT INTO ckb_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","لە هەمان ڕۆژدا ئیبراهیم و ئیسماعیلی کوڕی خەتەنە کران. ");
INSERT INTO ckb_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","هەموو پیاوەکانی ماڵەکەی، ئەوانەی لە ماڵەکەی لەدایک ببوون و ئەوانەی لە بیانی بە زیو کڕدرابوون لەگەڵ ئەودا خەتەنە کران. ");
INSERT INTO ckb_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","ئینجا یەزدان لەلای دار بەڕووەکانی مەمرێ بۆ ئیبراهیم دەرکەوت، کە لە گەرمای ڕۆژدا لەبەر دەرگای چادرەکەیدا دانیشتبوو. ");
INSERT INTO ckb_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","ئیبراهیم سەری هەڵبڕی و بینی وا سێ پیاو لە نزیکی وەستاون. کاتێک ئەوانی بینی، لە دەرگای چادرەکەیەوە بەرەو ڕوویان ڕایکرد و کڕنۆشی برد و سەری خستە سەر زەوی. ");
INSERT INTO ckb_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","ئینجا گوتی: «گەورەم، ئەگەر جێی ڕەزامەندیتم، بەسەر خزمەتکارەکەتدا تێمەپەڕە. ");
INSERT INTO ckb_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","با تۆزێک ئاو بهێنرێت و پێتان بشۆن، ئینجا لەژێر دارەکە پاڵ بدەنەوە. ");
INSERT INTO ckb_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","پارووە نانێکیشتان بۆ دێنم تاکو بەری دڵتانی پێ بگرن و پاشان تێبپەڕن، چونکە ئێوە بۆ لای خزمەتکارەکەتان هاتوون.» ئەوانیش فەرموویان: «ئەوەی گوتت بیکە.» ");
INSERT INTO ckb_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","ئیتر ئیبراهیم بە پەلە چوو بۆ ناو چادرەکە بۆ لای سارا و پێی گوت: «خێرا سێ پێوانە لە باشترین ئارد بهێنە و بیشێلە و بیکە بە نان.» ");
INSERT INTO ckb_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","هەروەها ئیبراهیم بۆ لای مێگەلەکە ڕایکرد و گوێرەکەیەکی ناسک و چاکی هێنا و دایە دەست خزمەتکارێکەوە، ئەویش خێرا کەوتە ئامادەکردنی. ");
INSERT INTO ckb_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","ئینجا دەڵەمە و شیر و ئەو گوێرەکەیەی ئامادەکرابوو، هێنای و لەبەردەمیان داینا. خۆشی لەژێر دارەکە لەسەریان ڕاوەستا، کاتێک ئەوان نانەکەیان دەخوارد. ");
INSERT INTO ckb_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","پاشان پێیان فەرموو: «کوا سارای ژنت؟» ئەویش گوتی: «ئەوەتا، لەناو چادرەکەیە.» ");
INSERT INTO ckb_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","ئینجا یەزدان فەرمووی: «بێگومان ساڵێکی دیکە ئەم کاتانە دێمەوە لات و سارای ژنیشت کوڕێکی بووە.» ساراش لە پشتەوە و لەبەر دەرگای چادرەکەدا گوێی لەوان گرتبوو. ");
INSERT INTO ckb_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","ئیبراهیم و سارا دوو کەسی پیر و بەساڵداچوو بوون. ساراش تەمەنی منداڵبوونی بەسەرچووبوو. ");
INSERT INTO ckb_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","بۆیە سارا لە دڵی خۆیدا پێکەنی و گوتی: «ئایا ئێستا کە تەواو پیر بووم و مێردەکەشم پیر بووە، خۆشیم بۆ دەبێت؟» ");
INSERT INTO ckb_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","ئینجا یەزدان بە ئیبراهیمی فەرموو: «بۆچی سارا پێکەنی و گوتی: ”ئایا بەڕاستی بەم پیرییەوە منداڵم دەبێت“؟ ");
INSERT INTO ckb_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","هیچ شتێک هەیە بۆ یەزدان ئەستەم بێت؟ ساڵی داهاتوو لە کاتی دیاریکراو دێمەوە لات و ساراش کوڕێکی بووە.» ");
INSERT INTO ckb_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","سارا لە ترسا درۆی کرد و گوتی: «پێنەکەنیم.» بەڵام ئەو فەرمووی: «بەڵێ، پێکەنیت.» ");
INSERT INTO ckb_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","ئینجا پیاوەکان لەوێ هەستان و ڕوویان لە سەدۆم کرد، ئیبراهیمیش لەگەڵیان ڕۆیشت، تاکو بەڕێیان بکات. ");
INSERT INTO ckb_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","یەزدانیش فەرمووی: «ئایا ئەوەی کە بەتەمام ئەنجامی بدەم لە ئیبراهیمی بشارمەوە؟ ");
INSERT INTO ckb_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","بێگومان ئیبراهیم دەبێتە نەتەوەیەکی مەزن و بەهێز و هەموو نەتەوەکانی سەر زەویش لە ڕێگەی ئەوەوە بەرەکەتدار دەبن. ");
INSERT INTO ckb_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","لەبەر ئەوەی هەڵمبژاردووە کە منداڵەکانی و ماڵەکەی لەدوای خۆی ڕابسپێرێت ڕێچکەی یەزدان بگرنەبەر، بۆ ئەوەی ڕاستودروستی و دادپەروەری پەیڕەو بکەن، تاکو یەزدان ئەو بەڵێنە بهێنێتە دی کە بە ئیبراهیمی دابوو.» ");
INSERT INTO ckb_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","ئینجا یەزدان فەرمووی: «هاوار لە دژی سەدۆم و عەمۆرا زۆر بووە و تووشی گوناهی زۆر گەورە هاتوون. ");
INSERT INTO ckb_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","ئەوا دێمە خوارەوە بۆ ئەوەی بزانم ئاخۆ ئەو کارەی کە کردوویانە بەو ڕادەیە خراپە کە بیستوومە. ئەگەر نا، ئەوا دەزانم.» ");
INSERT INTO ckb_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","ئینجا پیاوەکان ڕوویان کردە سەدۆم و ڕۆیشتن، بەڵام ئیبراهیم هێشتا لەبەردەم یەزدان وەستابوو. ");
INSERT INTO ckb_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","ئیبراهیم چووە پێشەوە و گوتی: «ئایا لەگەڵ خراپەکاردا ڕاستودروستیش لەناودەبەیت؟ ");
INSERT INTO ckb_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","ئەی ئەگەر شارەکە پەنجا کەسی ڕاستودروستی تێدابێت، ئایا هەر لەناوی دەبەیت و لە پێناوی ئەو پەنجا ڕاستودروستەی کە تێیدایە نایبەخشیت؟ ");
INSERT INTO ckb_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","حاشا، شتی وا لە تۆ ناوەشێتەوە کە ڕاستودروستیش لەگەڵ خراپەکاردا بکوژیت و وەکو یەک هەڵسوکەوتیان لەگەڵ بکەیت! دوور بێت لە تۆ! ئایا دادوەری هەموو زەوی دادپەروەر نابێت؟» ");
INSERT INTO ckb_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","یەزدانیش فەرمووی: «ئەگەر لە شاری سەدۆم پەنجا کەسی ڕاستودروست ببینمەوە، ئەوا لە پێناوی ئەوان هەموو شارەکە دەبەخشم.» ");
INSERT INTO ckb_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","ئیبراهیم وەڵامی دایەوە: «ئێستا منێک کە خۆڵ و خۆڵەمێشم، بوێری ئەوەم هەبووە لەگەڵ پەروەردگاردا قسە بکەم، ");
INSERT INTO ckb_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","ئەی ئەگەر لەو پەنجا کەسە ڕاستودروستە پێنجی کەم بوو؟ ئایا بۆ پێنج کەس هەموو شارەکە وێران دەکەیت؟» فەرمووی: «وێرانی ناکەم، ئەگەر چل و پێنج لەوێ ببینمەوە.» ");
INSERT INTO ckb_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","دیسان کەوتەوە قسە لەگەڵی و گوتی: «ئەی ئەگەر لەوێ چلی لێبوو؟» فەرمووی: «لەبەر خاتری ئەو چلە، نایکەم.» ");
INSERT INTO ckb_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","ئینجا گوتی: «با پەروەردگار تووڕە نەبێت و قسە بکەم، ئەی ئەگەر هەر سی لێبوو؟» فەرمووی: «نایکەم، ئەگەر لەوێ سی ببینمەوە.» ");
INSERT INTO ckb_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","ئیبراهیم گوتی: «ئیتر وا وێرام قسە لەگەڵ پەروەردگار بکەم، ئەی ئەگەر بیستی لێبوو؟» فەرمووی: «لەبەر ئەو بیستە وێرانی ناکەم.» ");
INSERT INTO ckb_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","ئینجا گوتی: «با پەروەردگار تووڕە نەبێت و هەر ئەم جارە قسە بکەم. ئەی ئەگەر دەی لێبوو؟» فەرمووی: «لەبەر ئەو دەیە وێرانی ناکەم.» ");
INSERT INTO ckb_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","ئینجا دوای ئەوەی یەزدان لەگەڵ ئیبراهیم لە قسەکردن بووەوە، ڕۆیشت، ئیبراهیمیش گەڕایەوە شوێنی خۆی. ");
INSERT INTO ckb_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","هەردوو فریشتەکە کاتی ئێوارە گەیشتنە سەدۆم، لوتیش لە دەروازەکەی سەدۆم دانیشتبوو. کاتێک لوت ئەوانی بینی، هەستا بۆ پێشوازییان و کڕنۆشی برد و سەری خستە سەر زەوی. ");
INSERT INTO ckb_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","ئینجا گوتی: «گەورەکانم، تکایە لابدەنە ماڵی خزمەتکاری خۆتان. شەو بەسەربەرن و پێتان بشۆن، سەر لە بەیانیش بە ڕێی خۆتاندا بڕۆن.» فەرموویان: «نا، بەڵکو لە گۆڕەپانەکە شەو دەبەینەسەر.» ");
INSERT INTO ckb_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","بەڵام ئەم زۆری لێکردن. ئیتر لایاندایە لای و چوونە ماڵەکەی. ئەویش خوان و نانی فەتیرەی بۆ ئامادە کردن و خواردیان. ");
INSERT INTO ckb_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","پێش ئەوەی بخەون، هەموو پیاوانی شاری سەدۆم لە هەموو لایەکەوە، لە گەنجیانەوە هەتا پیرییان، دەوری ماڵەکەیان دا. ");
INSERT INTO ckb_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","ئینجا لوتیان بانگکرد و لێیان پرسی: «کوا ئەو دوو پیاوەی ئەمشەو هاتنە لات؟ بیانهێنە دەرەوە بۆمان تاکو لاقەیان بکەین.» ");
INSERT INTO ckb_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","لوت هاتە دەرەوە بۆ لایان و دەرگاکەی لە پشت خۆیەوە داخست. ");
INSERT INTO ckb_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","گوتی: «نا، براکانم. خراپەی وا مەکەن. ");
INSERT INTO ckb_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","من دوو کچم هەیە کە دەستی پیاویان بەرنەکەوتووە. بۆتان دەهێنمە دەرەوە، ئەوەی پێتان باشە پێیانی بکەن. بەڵام هیچ لەم دوو پیاوە مەکەن، چونکە ئەوان هاتوونەتە ماڵی من.» ");
INSERT INTO ckb_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","ئەوانیش گوتیان: «وەرە ئەم لاوە!» ئینجا گوتیان: «ئەم پیاوە خۆی وەک بێگانەیەک هاتووەتە نێومانەوە، کەچی دەیەوێت ببێتە دادوەر بەسەرمانەوە. ئێستاش لەوان خراپترت بەسەردەهێنین.» ئیتر فشاریان بۆ لوت هێنا و هاتنە پێشەوە تاکو دەرگاکە بشکێنن. ");
INSERT INTO ckb_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","بەڵام دوو پیاوەکە دەستیان درێژکرد و لوتیان ڕاکێشایە لای خۆیان بۆ ناو ماڵەکە و دەرگاکەشیان داخست. ");
INSERT INTO ckb_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","ئەو پیاوانەشیان کوێر کرد کە لە بەردەرگای ماڵەکەدا بوون، لە بچووکیانەوە هەتا گەورەیان، ئیتر پەکیان کەوت و نەیانتوانی دەرگاکە بدۆزنەوە. ");
INSERT INTO ckb_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","ئینجا دوو پیاوەکە بە لوتیان فەرموو: «کێی دیکەت لێرە هەیە؟ زاواکانت و کوڕەکانت و کچەکانت و هەرکەسێکی دیکەت لەم شارەدا هەیە، بیانبە دەرەوە، ");
INSERT INTO ckb_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","چونکە ئێمە ئەم شوێنە وێران دەکەین. لەبەر ئەوەی لەبەردەم یەزدان هاوار لە دژی خەڵکەکەی گەیشتووەتە ئەوپەڕی خۆی، بۆیە ئێمەی ناردووە تاکو وێرانی بکەین.» ");
INSERT INTO ckb_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","ئیتر لوت چووە دەرەوە و قسەی لەگەڵ دەستگیرانی کچەکانی کرد و گوتی: «هەستن و لەم شوێنە بڕۆنە دەرەوە، چونکە هێندەی نەماوە یەزدان شارەکە وێران بکات.» بەڵام وەک گاڵتەچی هاتە بەرچاوی دەستگیرانی کچەکانی. ");
INSERT INTO ckb_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","لە بەرەبەیان، هەردوو فریشتەکە پەلەیان لە لوت کرد و پێیان فەرموو: «خێرا بکە! ژنەکەت و هەردوو کچەکەت کە لێرەن بیانبە، نەوەک تۆش بە گوناهی شارەکە لەناوبچیت.» ");
INSERT INTO ckb_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","بەڵام ئەو خەم ساردی لێکرد، جا هەردوو پیاوەکە لەبەر بەزەیی یەزدان لەسەریان، دەستی خۆی و ژنەکەی و هەردوو کچەکەی ئەویان گرت و لە دەرەوەی شارەکە دایاننان. ");
INSERT INTO ckb_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","هەرکە هێنایاننە دەرەوەی شارەکە، یەکێکیان فەرمووی: «فریای خۆت بکەوە! ئاوڕ لە دواوەت مەدەوە و لەم دەوروبەرە ڕانەوەستیت. ڕابکە بۆ چیاکە بۆ ئەوەی لەناونەچیت!» ");
INSERT INTO ckb_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","بەڵام لوت پێی گوتن: «نا، گەورەم! ");
INSERT INTO ckb_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","خزمەتکارەکەت وا ڕەزامەندی لە چاوەکانت بەدی کردووە، خۆشەویستییەکەت گەورەیە کە بەرامبەرم کردووتە، بە هێشتنەوەی گیانم بە زیندووێتی. بەڵام من ناتوانم ڕابکەم بۆ چیاکە. نەوەک ئەم بەڵایە پێم بگات و بمرم. ");
INSERT INTO ckb_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","تەماشای ئەو شارۆچکە نزیکە بکە، بچووکە، با بۆ ئەوێ هەڵبێم. مەگەر بچووک نییە؟ ئیتر گیانم بە زیندووێتی دەمێنێتەوە.» ");
INSERT INTO ckb_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","ئەویش پێی فەرموو: «باشە، لەم شتەش نائومێدت ناکەم، ئەو شارۆچکەیەی باست کرد سەرەوژێری ناکەم. ");
INSERT INTO ckb_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","بەڵام بە پەلە بەرەو ئەوێ ڕابکە، چونکە هەتا تۆ نەگەیتە ئەوێ، من ناتوانم هیچ شتێک بکەم.» لەبەر ئەوەشە کە شارۆچکەکە ناونرا بە زۆعەر. ");
INSERT INTO ckb_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","کاتێک خۆر بەسەر زەویدا هەڵهات، لوت گەیشتە ناو زۆعەر. ");
INSERT INTO ckb_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","ئینجا یەزدان لە ئاسمانەوە گۆگرد و ئاگری بەسەر سەدۆم و عەمۆرادا باراند. ");
INSERT INTO ckb_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","هەموو ئەو شارانە، دەوروبەرەکەیان و هەموو دانیشتووانی شارۆچکەکان و ڕووەکی زەوییەکەشی لەگەڵدا سەرەوژێر کرد. ");
INSERT INTO ckb_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","بەڵام ژنی لوت سەیری دواوەی کرد، جا بووە ستوونێکی خوێ. ");
INSERT INTO ckb_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","بۆ سبەی ئیبراهیم بەیانی زوو لە خەو هەستا و گەڕایەوە بۆ ئەو شوێنەی کە تێیدا لەبەردەم یەزدان وەستابوو. ");
INSERT INTO ckb_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","تەماشای سەدۆم و عەمۆرا و هەموو دەشتەکەی دەوروبەری کرد و بینی وا دووکەڵی زەوییەکە وەک دووکەڵی کوورە بەرز دەبێتەوە. ");
INSERT INTO ckb_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","کاتێک خودا شارۆچکەکانی دەشتەکەی وێران کرد، ئیبراهیمی هاتەوە یاد و لوتی لەو کارەساتە هێنایە دەرەوە کە بەسەر ئەو شارانەدا هێنای کە ئەوی تێدا دەژیا. ");
INSERT INTO ckb_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","ئینجا لوت و هەردوو کچەکەی زۆعەریان بەجێهێشت و لە چیا نیشتەجێ بوون، چونکە ترسا لە زۆعەر دانیشێت. خۆی و هەردوو کچەکەی لە ئەشکەوت نیشتەجێ بوون. ");
INSERT INTO ckb_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","کچە گەورەکەی لوت بە بچووکەکەی گوت: «باوکمان پیر بووە و هیچ پیاوێکیش لەم ناوەدا نییە کە لەگەڵیدا هاوسەرگیری بکەین و منداڵمان ببێت، وەک چۆن دابونەریتی هەموو زەوییە، ");
INSERT INTO ckb_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","بۆیە وەرە با شەراب دەرخواردی باوکمان بدەین و سەرجێیی لەگەڵ بکەین، لە باوکمانەوە وەچە بخەینەوە.» ");
INSERT INTO ckb_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","ئەو شەوە شەرابیان دەرخواردی باوکیان دا، ئینجا کچە گەورەکە چووە ژوورەوە و لەگەڵ باوکی ڕاکشا. ئەویش نە بە ڕاکشانەکەی زانی و نە بە هەستانەوەکەی. ");
INSERT INTO ckb_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","بۆ ڕۆژی دواتر کچە گەورەکە بە بچووکەکەی گوت: «دوێنێ من شەو لەگەڵ باوکم سەرجێییم کرد. ئەمشەویش شەرابی دەرخوارد دەدەین، ئینجا تۆ بڕۆ ژوورەوە و سەرجێیی لەگەڵ بکە. جا لە باوکی خۆمانەوە وەچە دەخەینەوە.» ");
INSERT INTO ckb_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","ئەو شەوەش شەرابیان دەرخواردی باوکیان دا، ئینجا کچە بچووکەکە هەستا و سەرجێیی لەگەڵ کرد. ئەویش نە بە سەرجێییەکەی زانی و نە بە هەستانەوەکەی. ");
INSERT INTO ckb_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","ئیتر هەردوو کچەکەی لوت سکیان لە باوکیان پڕ بوو. ");
INSERT INTO ckb_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","گەورەکەیان کوڕێکی بوو ناوی لێنا مۆئاب. ئەو باوکی هەموو مۆئابییەکانە هەتا ئەمڕۆ. ");
INSERT INTO ckb_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","هەروەها بچووکەکەشیان کوڕێکی بوو ناوی لێنا بەن‌عەمی. ئەویش باوکی نەوەی عەمۆنە هەتا ئەمڕۆ. ");
INSERT INTO ckb_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","ئیبراهیم لەوێوە بەرەو زەوی نەقەب کۆچی کرد و لەنێوان قادێش و شووردا نیشتەجێ بوو. بۆ ماوەیەک لە گرار مایەوە. ");
INSERT INTO ckb_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","ئیبراهیم سەبارەت بە سارای ژنی گوتی: «ئەو خوشکمە.» ئینجا ئەبیمەلەخی پاشای گرار ناردی و سارای برد. ");
INSERT INTO ckb_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","ئینجا خودا هاتە خەوی ئەبیمەلەخ و پێی فەرموو: «ئەوا تۆ بەهۆی ئەو ژنەی بردووتە دەمریت، چونکە ئەو ژنێکی بە مێردە.» ");
INSERT INTO ckb_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","ئەبیمەلەخ کە هێشتا لە سارای نزیک نەکەوتبووەوە، گوتی: «ئەی پەروەردگار، ئایا نەتەوەیەکی بێتاوان دەکوژیت؟ ");
INSERT INTO ckb_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","ئەی ئیبراهیم پێی نەگوتم ”ئەو خوشکمە،“ ساراش خۆی نەیگوت ”ئەو برامە“؟ من ئەمەم بە دڵسافی و دەستی پاکەوە کردووە.» ");
INSERT INTO ckb_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","خوداش لە خەونەکەدا پێی فەرموو: «منیش دەزانم تۆ ئەمەت بە دڵسافییەوە کردووە، هەر خۆشم ڕێگام لێ گرتیت کە گوناهم بەرامبەر بکەیت. لەبەر ئەوە بوو کە نەمهێشت دەستی بۆ ببەیت. ");
INSERT INTO ckb_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","ئێستاش ژنی پیاوەکە بگەڕێنەوە، ئەو پێغەمبەرە، لە پێناوی تۆ نزا دەکات و دەژیت. بەڵام ئەگەر نەیگەڕێنیتەوە، ئەوا بزانە کە بێگومان خۆت و هەموو ئەوانەی هی تۆن دەمرن.» ");
INSERT INTO ckb_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","ئەبیمەلەخ بەرەبەیانی ڕۆژی دواتر لە خەو هەستا و هەموو خزمەتکارەکانی بانگکرد و هەموو ئەو شتانەی پێ گوتن کە ڕوویاندابوو، ئەوانیش زۆر ترسان. ");
INSERT INTO ckb_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","ئینجا ئەبیمەلەخ ئیبراهیمی بانگکرد و پێی گوت: «ئەمە چییە بە ئێمەت کرد؟ چ گوناهێکم بەرامبەرت کردووە تاکو خۆم و شانشینەکەم تووشی تاوانێکی وا گەورە بکەیت؟ ئەو کارەی کە نابێت بکرێت، بە منت کرد.» ");
INSERT INTO ckb_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","ئەبیمەلەخ بە ئیبراهیمی گوت: «بۆچی ئەم کارەت کرد؟» ");
INSERT INTO ckb_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","ئیبراهیمیش گوتی: «لەبەر ئەوەی بە خۆمم گوت: ”هیچ لەخواترسێک لەم شوێنەدا بوونی نییە و لەبەر ژنەکەم من دەکوژن.“ ");
INSERT INTO ckb_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","لەگەڵ ئەوەشدا لە ڕاستیدا ئەو خوشکمە، کچی باوکمە، بەڵام کچی دایکم نییە. ئیتر بووە ژنم. ");
INSERT INTO ckb_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","کاتێکیش خودا لە ماڵی باوکمەوە ئاوارەی کردم، بە ژنەکەمم گوت: ”بەم شێوەیە دەتوانیت خۆشەویستی خۆتم نیشان بدەیت: چووینە هەر شوێنێک، سەبارەت بە من بڵێ: ئەو برامە.“» ");
INSERT INTO ckb_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","ئیتر ئەبیمەلەخ مەڕ و مانگا و خزمەتکار و کەنیزەی هێنا و دایە ئیبراهیم، سارای ژنیشی بۆ گەڕاندەوە. ");
INSERT INTO ckb_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","ئینجا ئەبیمەلەخ گوتی: «وا زەوییەکەم لەبەردەم تۆیە، کوێت پێ باشە لەوێ دابنیشە.» ");
INSERT INTO ckb_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","بە ساراشی گوت: «من ئێستا هەزار شاقل زیو دەدەمە براکەت. ئەمە بۆ قەرەبووکردنەوەی ئەو ئابڕووبردنەیە کە بەرامبەر تۆ لەبەردەم هەموو ئەوانەی لەگەڵتن ئەنجامم دا؛ ئیتر تۆ تەواو ڕووسپیت.» ");
INSERT INTO ckb_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","ئینجا ئیبراهیم لە خودا پاڕایەوە، خوداش ئەبیمەلەخ و ژنەکەی و کەنیزەکانی چاککردەوە و منداڵیان بوو، ");
INSERT INTO ckb_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","چونکە یەزدان بەهۆی سارای ژنی ئیبراهیمەوە، هەرچی منداڵدانی ماڵی ئەبیمەلەخ هەبوو، بە تەواوی بەستبووی. ");
INSERT INTO ckb_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","یەزدان بەو شێوەیەی فەرمووی سارای بەسەرکردەوە و یەزدان چۆنی فەرموو ئاوای بۆ سارا کرد. ");
INSERT INTO ckb_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","ئینجا سارا سکی پڕ بوو؛ لە تەمەنی پیریی ئیبراهیمدا و لە هەمان ئەو کاتەی کە خودا پێی فەرمووبوو، منداڵێکی بوو. ");
INSERT INTO ckb_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","ئیبراهیم ئەو کوڕەی ناو نا ئیسحاق، کە سارا بۆی ببوو. ");
INSERT INTO ckb_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","کاتێک ئیسحاقی کوڕی بووە هەشت ڕۆژ، ئیبراهیم خەتەنەی کرد، هەروەک چۆن خودا ڕایسپاردبوو. ");
INSERT INTO ckb_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","تەمەنی ئیبراهیم سەد ساڵ بوو کاتێک ئیسحاقی کوڕی لەدایک بوو. ");
INSERT INTO ckb_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","سارا گوتی: «خودا منی خستووەتە پێکەنین، هەرکەسێکیش ئەمە ببیستێت لەگەڵ من پێدەکەنێت.» ");
INSERT INTO ckb_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","هەروەها گوتی: «کێ بە ئیبراهیمی دەگوت سارا شیر دەداتە منداڵان؟ لەگەڵ ئەوەشدا لە پیریی ئەودا کوڕێکم بوو.» ");
INSERT INTO ckb_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","کوڕە گەورە بوو و لە شیر بڕایەوە. لەو ڕۆژەی ئیسحاق لە شیر بڕایەوە، ئیبراهیم خوانێکی گەورەی ساز کرد. ");
INSERT INTO ckb_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","بەڵام سارا کوڕەکەی هاجەری میسری بینی کە لە ئیبراهیم بوو، گاڵتەی دەکرد. ");
INSERT INTO ckb_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","جا بە ئیبراهیمی گوت: «ئەم کەنیزەیە و کوڕەکەی دەربکە، چونکە کوڕی ئەم کەنیزەیە لەگەڵ ئیسحاقی کوڕی من نابێتە میراتگر.» ");
INSERT INTO ckb_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","ئەم بابەتە ئیبراهیمی زۆر ناڕەحەت کرد، چونکە پەیوەندی بە کوڕەکەی ئەوەوە هەبوو. ");
INSERT INTO ckb_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","بەڵام خودا بە ئیبراهیمی فەرموو: «ناڕەحەتی کوڕەکە و کەنیزەکەت مەبە. هەرچی سارا پێت دەڵێت بە قسەی بکە، چونکە نەوەی تۆ لە ڕێگەی ئیسحاقەوە ناودەبردرێت. ");
INSERT INTO ckb_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","هەروەها لە کوڕی کەنیزەکەشەوە نەتەوەیەک دروست دەکەم، چونکە وەچەی تۆیە.» ");
INSERT INTO ckb_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","ئیبراهیم بەیانی زوو لە خەو هەستا و نان و مەشکەیەک ئاوی هێنا و خستییە سەر شانی هاجەر و لەگەڵ کوڕەکە بەڕێی کرد. ئەویش ڕۆیشت و لە چۆڵەوانی بیری شابەع سەرگەردان بوو. ");
INSERT INTO ckb_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","کە مەشکەکە ئاوی تێدا نەما، کوڕەکەی لەژێر دەوەنێک دانا. ");
INSERT INTO ckb_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","ئینجا ڕۆیشت و لە دوورەوە لە دووری تیرهاوێژێک بەرامبەری دانیشت، چونکە گوتی: «ناتوانم بە چاوی خۆم مەرگی کوڕەکەم ببینم.» ئیتر بەرامبەری دانیشت و بە دەنگی بەرز دەستی کرد بە گریان. ");
INSERT INTO ckb_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","خودا دەنگی کوڕەکەی بیست و فریشتەی خودا لە ئاسمانەوە هاجەری بانگکرد و پێی فەرموو: «چیتە هاجەر؟ مەترسە، خودا دەنگی کوڕەکەی بیست لەو شوێنەی لێی دانراوە. ");
INSERT INTO ckb_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","هەستە، کوڕەکە هەڵبگرە و دەستی بگرە، چونکە دەیکەمە نەتەوەیەکی مەزن.» ");
INSERT INTO ckb_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","ئینجا خودا هەردوو چاوی هاجەری کردەوە، ئەویش بیرێکی ئاوی بەدی کرد. ئیتر چوو مەشکەکەی پڕکرد لە ئاو و ئاوی دایە کوڕەکە. ");
INSERT INTO ckb_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","خودا لە کاتی گەورەبوونی کوڕەکەدا، لەگەڵی بوو. لە چۆڵەوانیدا ژیا و بووە تیرهاوێژ. ");
INSERT INTO ckb_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","کاتێک کە ئیسماعیل لە چۆڵەوانی پاران دەژیا، دایکی ژنێکی میسریی بۆ هێنا. ");
INSERT INTO ckb_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","لەو سەردەمەدا ئەبیمەلەخ لەگەڵ فیکۆل کە فەرماندەی گشتی سوپاکەی بوو، بە ئیبراهیمیان گوت: «لە هەموو ئەوەی دەیکەیت خودات لەگەڵدایە. ");
INSERT INTO ckb_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","ئێستاش لێرەدا سوێندم بۆ بخۆ بە خودا کە ناپاکی لە خۆم و منداڵ و نەوەکانم ناکەیت. من چ چاکەیەکم لەگەڵ تۆدا کرد، تۆش هەمان چاکە لەگەڵ من و لەگەڵ ئەو خاکەدا دەکەیت کە تێیدا ئاوارە بوویت.» ");
INSERT INTO ckb_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","ئیبراهیمیش گوتی: «سوێند دەخۆم.» ");
INSERT INTO ckb_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","ئینجا ئیبراهیم گلەیی لە ئەبیمەلەخ کرد سەبارەت بەو بیرە ئاوەی کە خزمەتکارەکانی ئەبیمەلەخ داگیریان کردبوو. ");
INSERT INTO ckb_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","بەڵام ئەبیمەلەخ گوتی: «ئاگادار نیم کێ ئەم شتەی کردووە. هەروەها تۆ پێت ڕانەگەیاندووم، منیش ئەمڕۆ نەبێت نەمبیستووە.» ");
INSERT INTO ckb_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","ئیتر ئیبراهیم مەڕ و مانگای هێنا و دایە ئەبیمەلەخ، ئیتر هەردووکیان پەیمانیان بەست. ");
INSERT INTO ckb_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","ئیبراهیم لە مێگەلەکە حەوت کاوڕەمێی بە تەنها ڕاگرت. ");
INSERT INTO ckb_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","ئەبیمەلەخیش بە ئیبراهیمی گوت: «ئەم حەوت کاوڕەمێیە چییە کە بە تەنها ڕاتگرتوون؟» ");
INSERT INTO ckb_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","ئەویش گوتی: «ئەم حەوت کاوڕەمێیە لە دەستی من وەردەگریت بۆ ئەوەی ببێتە شایەتییەک بۆم کە من ئەم بیرەم هەڵکەندووە.» ");
INSERT INTO ckb_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","لەبەر ئەوە ئەو شوێنەی ناو نا بە بیری شابەع، چونکە هەردووکیان لەوێ سوێندیان خوارد. ");
INSERT INTO ckb_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","لەدوای ئەوەی لە بیری شابەع پەیمانیان بەست، ئەبیمەلەخ و فیکۆلی فەرماندەی گشتی سوپاکەی هەستان و گەڕانەوە خاکی فەلەستییەکان. ");
INSERT INTO ckb_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","ئینجا ئیبراهیم داری گەزی لە بیری شابەع چاند، لەوێش بە ناوی یەزدانی پەروەردگاری هەتاهەتاییەوە نزای کرد. ");
INSERT INTO ckb_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","ئیتر ئیبراهیم لە خاکی فەلەستییەکان ماوەیەکی زۆری بە ئاوارەیی بەسەربرد. ");
INSERT INTO ckb_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","لەدوای ماوەیەک خودا ئیبراهیمی تاقیکردەوە. پێی فەرموو: «ئیبراهیم!» ئەویش گوتی: «ئەوەتام.» ");
INSERT INTO ckb_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","ئینجا خودا فەرمووی: «ئیسحاقی کوڕە تاقانەت، ئەوەی کە خۆشت دەوێت، ببە و بڕۆ بۆ خاکی مۆریا. لەوێ لەسەر یەکێک لە کێوەکان کە خۆم پێت دەڵێم، بیکە بە قوربانی سووتاندن.» ");
INSERT INTO ckb_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","بۆ بەیانی ئیبراهیم زوو لە خەو هەستا و گوێدرێژەکەی کورتان کرد. لەگەڵ خۆیدا دووان لە خزمەتکارەکانی و ئیسحاقی کوڕی برد. دوای بڕینەوەی دار بۆ قوربانی سووتاندن، هەستا و بەرەو ئەو شوێنە چوو کە خودا پێی فەرمووبوو. ");
INSERT INTO ckb_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","لە ڕۆژی سێیەم ئیبراهیم چاوی هەڵبڕی و لە دوورەوە شوێنەکەی بەدی کرد. ");
INSERT INTO ckb_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","ئیتر بە دوو خزمەتکارەکەی گوت: «ئێوە لێرە لەگەڵ گوێدرێژەکە دانیشن، من و کوڕەکەش هەتا ئەوێ دەچین، کڕنۆش دەبەین و دەگەڕێینەوە لاتان.» ");
INSERT INTO ckb_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","ئیبراهیم داری قوربانی سووتاندنەکەی هەڵگرت و خستییە سەر پشتی ئیسحاقی کوڕی، خۆشی ئاگر و چەقۆکەی هەڵگرت. کاتێک هەردووکیان پێکەوە ڕۆیشتن، ");
INSERT INTO ckb_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","ئیسحاق بە ئیبراهیمی باوکی گوت: «باوکە!» ئەویش وەڵامی دایەوە: «ها کوڕم؟» ئیسحاق گوتی: «ئەوەتا ئاگرەکە و داری سووتاندنەکە، ئەی کوا بەرخەکە کە بۆ قوربانی سووتاندنەکەیە؟» ");
INSERT INTO ckb_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","ئیبراهیم وەڵامی دایەوە: «خودا خۆی بەرخی قوربانی سووتاندنەکە دابین دەکات، کوڕم.» ئیتر هەردووکیان پێکەوە ڕۆیشتن. ");
INSERT INTO ckb_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","کاتێک گەیشتنە ئەو شوێنەی کە خودا پێی فەرمووبوو، ئیبراهیم قوربانگایەکی دروستکرد و دارەکانی لەسەر ڕێکخست. ئینجا ئیسحاقی کوڕی بەستەوە و خستییە سەر دارەکانی سەر قوربانگاکە. ");
INSERT INTO ckb_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","ئیتر ئیبراهیم دەستی درێژکرد و چەقۆکەی هەڵگرت تاکو کوڕەکەی خۆی سەرببڕێت. ");
INSERT INTO ckb_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","بەڵام فریشتەی یەزدان لە ئاسمانەوە بانگی کرد و گوتی: «ئیبراهیم! ئیبراهیم!» ئەویش وەڵامی دایەوە: «ئەوەتام.» ");
INSERT INTO ckb_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","پێی گوت: «دەست بۆ کوڕەکە مەبە و هیچی لێ مەکە. ئێستا دەزانم تۆ لە خودا دەترسیت، چونکە لە پێناوی من دەستت بە کوڕە تاقانەکەتەوە نەگرت.» ");
INSERT INTO ckb_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","ئیبراهیم چاوی هەڵبڕی و بینی وا بەرانێک لەدوایەوە لەناو دەوەنەکە بە هەردوو قۆچی گیربووە. ئیبراهیم چوو و بەرانەکەی گرت و لە جیاتی کوڕەکەی کردییە قوربانی سووتاندن. ");
INSERT INTO ckb_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","ئیتر ئیبراهیم ئەو شوێنەی ناو نا، «یەزدان دابینی دەکات». هەتا ئەمڕۆش دەگوترێت، «لەسەر کێوی یەزدان، دابین دەکرێت.» ");
INSERT INTO ckb_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","فریشتەکەی یەزدان جارێکی دیکە لە ئاسمانەوە ئیبراهیمی بانگکرد و ");
INSERT INTO ckb_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","گوتی: «یەزدان دەفەرموێت سوێندبێت بە خۆم، لەبەر ئەوەی تۆ ئەمەت کرد و دەستت بە کوڕە تاقانەکەتەوە نەگرت، ");
INSERT INTO ckb_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","بێگومان بەرەکەتدارت دەکەم و نەوەکەت وەک ژمارەی ئەستێرەکانی ئاسمان و وەک لمی سەر کەناری دەریا زۆر دەکەم. نەوەت دەبێتە میراتگری دەرگای دوژمنەکانی. ");
INSERT INTO ckb_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","لە ڕێگەی نەوەی تۆشەوە هەموو نەتەوەکانی سەر زەوی بەرەکەتدار دەبن، چونکە تۆ گوێڕایەڵی فەرمایشتەکەی من بوویت.» ");
INSERT INTO ckb_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","ئینجا ئیبراهیم گەڕایەوە لای دوو خزمەتکارەکەی. ئیتر هەستان و پێکەوە چوونە بیری شابەع. ئیبراهیم لە بیری شابەع نیشتەجێ بوو. ");
INSERT INTO ckb_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","دوای ماوەیەک بە ئیبراهیم گوترا: «وا میلکەی براژنیشت چەند کوڕێکی بۆ ناحۆری برات بووە، ");
INSERT INTO ckb_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","عوچ کە نۆبەرەکەیەتی و بووزی برای، هەروەها قەموئێلیش کە باوکی ئارامە. ");
INSERT INTO ckb_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","هەروەها کەسەد و حەزۆ و پیلداش و یدلاف و بتوئێل.» ");
INSERT INTO ckb_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","بتوئێلیش ڕڤقەی بوو. میلکە ئەم هەشت کوڕەی بۆ ناحۆری برای ئیبراهیم بوو. ");
INSERT INTO ckb_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","کەنیزەکەشی کە ناوی ڕەئوومە بوو، ئەویش تەڤەح و گەحەم و تەحەش و مەعکای بوو. ");
INSERT INTO ckb_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","هەموو تەمەنی سارا سەد و بیست و حەوت ساڵ بوو. ");
INSERT INTO ckb_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","ئینجا سارا لە قیریەت ئەربەع مرد، کە حەبرۆنە لە خاکی کەنعان. ئیبراهیمیش هات بۆ ئەوەی بۆ سارا بلاوێتەوە و بەسەریدا بگریێت. ");
INSERT INTO ckb_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","ئیبراهیم لەبەردەم مردووەکەی هەستا و لەگەڵ حیتییەکان قسەی کرد و گوتی: ");
INSERT INTO ckb_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","«من لەنێو ئێوە نامۆ و میوانم. لەلای خۆتان گۆڕێکم بە موڵک بدەنێ، تاکو بتوانم مردووەکەم بنێژم.» ");
INSERT INTO ckb_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","حیتییەکان وەڵامی ئیبراهیمیان دایەوە و پێیان گوت: ");
INSERT INTO ckb_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","«گەورەم، گوێمان لێ بگرە، تۆ لەنێوانمان میرێکی بە توانایت. مردووەکەی خۆت لە باشترین گۆڕی ئێمە بنێژە. هیچ پیاوێکیش لە ئێمە دەست بەو گۆڕەوە ناگرێت کە تۆ مردووەکەتی تێدا دەنێژیت.» ");
INSERT INTO ckb_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","ئیبراهیمیش هەستا و کڕنۆشی بۆ حیتییەکان برد کە خەڵکی خاکەکە بوون. ");
INSERT INTO ckb_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","ئینجا قسەی لەگەڵ کردن و گوتی: «ئەگەر ڕازین بەوەی مردووەکەم بنێژم، ئەوا گوێم لێ بگرن و داوا لە عەفرۆنی کوڕی چۆحەر بکەن کە ");
INSERT INTO ckb_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ئەشکەوتەکەی مەخپێلەم پێ بفرۆشێت کە هی ئەوە و دەکەوێتە کەنار کێڵگەکەی. با بە نرخی تەواوی خۆشی بمداتێ، بۆ ئەوەی لەنێو ئێوەدا بۆ گۆڕ ببێتە موڵکم.» ");
INSERT INTO ckb_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","عەفرۆنی حیتی لەنێو حیتییەکان دانیشتبوو، لەبەرچاوی هەموو حیتییەکان، هەموو ئەوانەی هاتبوونە ناو دەروازەی شارەکەی، وەڵامی ئیبراهیمی دایەوە: ");
INSERT INTO ckb_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","«نا گەورەم، گوێت لێم بێت، کێڵگەکەت پێ دەبەخشم بە ئەشکەوتەکەی ناویشییەوە. لەبەرچاوی گەلەکەم پێم بەخشیت. مردووەکەی خۆت بنێژە.» ");
INSERT INTO ckb_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","ئیبراهیمیش لەبەردەم خەڵکی خاکەکە کڕنۆشی برد و ");
INSERT INTO ckb_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","لەبەرچاوی خەڵکی خاکەکە بە عەفرۆنی گوت: «بەڵام ئەگەر تۆ ڕازیت، ئەوا حەز دەکەم گوێشم لێ بگریت: نرخی کێڵگەکەت دەدەمێ. لە منی وەربگرە، ئینجا مردووەکەی خۆم لەوێ دەنێژم.» ");
INSERT INTO ckb_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","عەفرۆنیش وەڵامی ئیبراهیمی دایەوە: ");
INSERT INTO ckb_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","«گوێم لێ بگرە گەورەم، زەوییەکە بایی چوار سەد شاقل زیوە، بەڵام ئەوە لەنێوان من و تۆ چییە! مردووەکەی خۆت بنێژە.» ");
INSERT INTO ckb_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","ئیبراهیمیش گوێی لە عەفرۆن گرت و لەبەرچاوی حیتییەکان ئەو بڕە زیوەی بۆ عەفرۆن کێشا. چوار سەد شاقل زیو، بەو کێشانەی لەلای بازرگانەکان باوبوو. ");
INSERT INTO ckb_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","ئیتر کێڵگەکەی عەفرۆن، ئەوەی لە مەخپێلەیە، ئەوەی لەبەردەم مەمرێیە، کێڵگەکە و ئەشکەوتەکە کە لەناوییەتی، هەروەها هەموو ئەو دارانەی لەناو کێڵگەکەیە و لە سنووری دەوروبەریەتی، بووە ");
INSERT INTO ckb_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","موڵکی ئیبراهیم، لەبەرچاوی هەموو حیتییەکان، هەموو ئەوانەی هاتبوونە ناو دەروازەی شارەکە. ");
INSERT INTO ckb_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","دوای ئەوە ئیبراهیم سارای ژنی لەناو ئەشکەوتەکەی کێڵگەی مەخپێلە ناشت کە لەبەردەم مەمرێیە، ئەوەش حەبرۆنە لە خاکی کەنعان. ");
INSERT INTO ckb_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","ئیتر حیتییەکان کێڵگەکە و ئەشکەوتەکەی ناویان بە موڵک دا بە ئیبراهیم، بۆ ئەوەی ببێتە گۆڕستان. ");
INSERT INTO ckb_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","ئیبراهیم پیر بوو و چووە ساڵەوە. یەزدانیش ئیبراهیمی لە هەموو شتێکدا بەرەکەتدار کرد. ");
INSERT INTO ckb_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","ئینجا ئیبراهیم بە خزمەتکاری گەورەی ماڵەکەی گوت کە هەموو شتێکی ئەوی لەژێر دەستدا بوو: «دەست بخەرە ژێر ڕانم. ");
INSERT INTO ckb_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","سوێندت دەدەم بە یەزدان، خودای ئاسمان و خودای زەوی، کە هیچ ژنێک لە کچانی کەنعانییەکان بۆ کوڕەکەم ناخوازیت، کە خۆم نیشتەجێی نێوانیانم. ");
INSERT INTO ckb_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","بەڵکو دەچیتە خاکەکەم بۆ لای کەسوکارەکەم و لەوێ ژنێک بۆ ئیسحاقی کوڕم دەهێنیت.» ");
INSERT INTO ckb_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","خزمەتکارەکەش پێی گوت: «ئەی ئەگەر ئافرەتەکە نەیویست دوام بکەوێت بۆ ئەم زەوییە؟ ئایا کوڕەکەت بگەڕێنمەوە ئەو خاکەی لێوەی هاتوویت؟» ");
INSERT INTO ckb_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","ئیبراهیمیش پێی گوت: «ئاگاداربە کوڕەکەم نەگەڕێنێتەوە ئەوێ. ");
INSERT INTO ckb_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","یەزدانی پەروەردگاری ئاسمان، ئەوەی لە ماڵی باوکم و لە خاکی لەدایکبوونمەوە منی هێنایە دەرەوە، ئەوەی قسەی لەگەڵ کردم و سوێندی بۆ خواردم و فەرمووی: ”ئەم زەوییە بە نەوەی تۆ دەبەخشم.“ ئەو فریشتەی خۆی لەپێشتەوە دەنێرێت و لەوێ ژنێک بۆ کوڕەکەم دەهێنیت. ");
INSERT INTO ckb_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","خۆ ئەگەر ئافرەتەکەش نەیویست لەگەڵت بێتەوە، ئەوا گەردنت ئازاد دەبێت لەم سوێندەی من. تەنها نەکەیت کوڕەکەم ببەیتەوە ئەوێ.» ");
INSERT INTO ckb_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","ئینجا خزمەتکارەکە دەستی خستە ژێر ڕانی ئیبراهیمی گەورەی و لەسەر ئەمە سوێندی بۆ خوارد. ");
INSERT INTO ckb_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","ئیتر خزمەتکارەکە دە وشتری لە وشترەکانی گەورەکەی و هەموو شتە باشەکانی ئەوی لەگەڵ خۆی برد و چوو بۆ میسۆپۆتامیا بۆ شارۆچکەکەی ناحۆر. ");
INSERT INTO ckb_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","دەمەو ئێوارە ئەو کاتەی کچەکان دەهاتنە دەرەوە بۆ ئاوکێشان، لە دەرەوەی شارۆچکەکە، لەلای بیرێک وشترەکانی خست. ");
INSERT INTO ckb_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","ئینجا گوتی: «ئەی یەزدان، خودای ئیبراهیمی گەورەم، ئەمڕۆم بۆ ئاسان بکە و چاکە لەگەڵ ئیبراهیمی گەورەم بکە. ");
INSERT INTO ckb_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","من وا لەلای ئەم کانییە ڕاوەستاوم و کچانی خەڵکی شارۆچکەکە دێنە دەرەوە بۆ ئاوکێشان. ");
INSERT INTO ckb_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","با ئەو کچەی کە پێی دەڵێم: ”گۆزەکەتم بۆ لار بکەرەوە با ئاو بخۆمەوە،“ ئەویش بڵێت: ”بخۆرەوە، هەروەها وشترەکانیشت ئاو دەدەم.“ با ئەوت بۆ ئیسحاقی خزمەتکارت هەڵبژاردبێت. بەمەش دەزانم کە چاکەت لەگەڵ گەورەکەم کردووە.» ");
INSERT INTO ckb_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","پێش ئەوەی لە داواکارییەکەی ببێتەوە، ڕڤقە بە گۆزەکەی سەرشانییەوە هاتە دەرەوە. ڕڤقە کچی بتوئێلی کوڕی میلکە بوو، کە ژنی ناحۆری برای ئیبراهیم بوو. ");
INSERT INTO ckb_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","کچێکی زۆر جوان بوو، پاکیزە بوو، دەستی هیچ پیاوێکی بەرنەکەوتبوو. هاتە خوارەوە بۆ لای کانییەکە و گۆزەکەی پڕکرد و سەرکەوتەوە. ");
INSERT INTO ckb_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","خزمەتکارەکەش ڕایکرد بۆ لای و گوتی: «تۆزێک ئاوم لە گۆزەکەت بدەرێ.» ");
INSERT INTO ckb_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","ئەویش گوتی: «بخۆرەوە گەورەم.» ئیتر بە پەلە گۆزەکەی لەسەر دەستی داگرت و ئاوی دایێ. ");
INSERT INTO ckb_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","دوای ئەوەی ئاوی دایێ و گوتی: «هەروەها وشترەکانیشت ئاو دەدەم، هەتا تێر دەخۆنەوە.» ");
INSERT INTO ckb_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","ئینجا بە پەلە گۆزەکەی بەتاڵ کردە ناو ئاخوڕەکە و بە ڕاکردن گەڕایەوە لای بیرەکە تاکو ئاو هەڵبکێشێتەوە، ئیتر ئاوی دایە هەموو وشترەکان. ");
INSERT INTO ckb_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","پیاوەکەش بە بێدەنگی لێی ورد دەبووەوە تاکو بزانێت ئاخۆ یەزدان ڕێگاکەی سەرکەوتوو کردووە یان نا. ");
INSERT INTO ckb_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","کاتێک وشترەکان لە ئاوخواردنەوە بوونەوە، پیاوەکە خەزێمێکی زێڕی هێنا کە کێشەکەی نیو شاقل بوو لەگەڵ دوو بازنی زێڕ کە کێشیان دە شاقل بوو. ");
INSERT INTO ckb_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","ئینجا لێی پرسی: «تۆ کچی کێیت؟ دەتوانیت پێم بڵێی ئایا لە ماڵی باوکت شوێن هەیە بۆمان کە شەو تێیدا بمێنینەوە؟» ");
INSERT INTO ckb_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","ئەویش وەڵامی دایەوە: «من کچی بتوئێلی کوڕی میلکە و ناحۆرم.» ");
INSERT INTO ckb_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","پێشی گوت: «کا و ئالیکی زۆرمان لەلایە، هەروەها شوێنیش بۆ مانەوە.» ");
INSERT INTO ckb_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","ئیتر پیاوەکە چۆکی دادا و کڕنۆشی بۆ یەزدان برد، ");
INSERT INTO ckb_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","ئینجا گوتی: «ستایش بۆ یەزدان، خودای ئیبراهیمی گەورەم کە وازی لە خۆشەویستییە نەگۆڕ و دڵسۆزییەکەی لەگەڵ ئیبراهیمی گەورەم نەهێنا. یەزدان لە گەشتەکەمدا بەرەو ماڵی براکانی گەورەکەم ڕێنمایی کردم.» ");
INSERT INTO ckb_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","کچەش ڕایکرد و ئەم شتانەی بە ماڵی دایکی ڕاگەیاند. ");
INSERT INTO ckb_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","ڕڤقە برایەکی هەبوو بە ناوی لابان، ئیتر لابان ڕایکردە دەرەوە بۆ لای پیاوەکە، کە لە لای کانییەکە بوو. ");
INSERT INTO ckb_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","هەرکە خەزێم و بازنەکانی دەستی خوشکەکەی بینی و گوێی لە قسەکانی ڕڤقەی خوشکی بوو کە گوتی: «پیاوەکە ئاوا قسەی لەگەڵ کردم،» هاتە دەرەوە بۆ لای پیاوەکە، بینی وا لەلای وشترەکان لەسەر کانییەکە ڕاوەستاوە. ");
INSERT INTO ckb_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","ئینجا گوتی: «فەرموو، ئەی ئەوەی یەزدان بەرەکەتداری کردوویت، بۆ لە دەرەوە ڕاوەستاویت؟ من ماڵم بۆ تۆ و شوێنیشم بۆ وشترەکان ئامادە کردووە.» ");
INSERT INTO ckb_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","ئیتر پیاوەکە هاتە ماڵەوە، باری وشترەکانی کردەوە و کا و ئالیکی دایە وشترەکان، ئاو بۆ شوشتنی پێی و پێی ئەو پیاوانەی لەگەڵی بوون. ");
INSERT INTO ckb_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","ئینجا نان خرایە بەردەمی بۆ ئەوەی بیخوات، بەڵام گوتی: «نان ناخۆم هەتا قسەی خۆم نەکەم.» لابانیش گوتی: «قسە بکە.» ");
INSERT INTO ckb_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","ئینجا گوتی: «من خزمەتکاری ئیبراهیمم. ");
INSERT INTO ckb_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","یەزدان گەورەکەمی زۆر بەرەکەتدار کردووە و دەوڵەمەند بووە. ئەو مەڕ و مانگا و زێڕ و زیو و خزمەتکار و کەنیزە و وشتر و گوێدرێژی پێ بەخشیوە. ");
INSERT INTO ckb_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","سارای ژنی گەورەکەم لە کاتی پیریدا کوڕێکی بۆ گەورەم بووە، کە هەرچییەکی هەیە داویەتییە ئەو. ");
INSERT INTO ckb_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","گەورەشم سوێندی دام و گوتی: ”هیچ ژنێک بۆ کوڕەکەم لە کچانی کەنعانییەکان نەخوازیت، کە خۆم نیشتەجێی خاکەکەیانم. ");
INSERT INTO ckb_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","بەڵکو دەچیتە ماڵی باوکم بۆ لای کەسوکارەکەم و ژن بۆ کوڕەکەم دەخوازیت.“ ");
INSERT INTO ckb_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","«منیش بە گەورەمم گوت: ”ئەی ئەگەر ئافرەتەکە لەگەڵ من نەیەتەوە؟“ ");
INSERT INTO ckb_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","«ئەویش پێی گوتم: ”یەزدان، ئەوەی دۆستایەتی دەکەم، فریشتەی خۆیت لەگەڵ دەنێرێت و ڕێگاکەت سەرکەوتوو دەکات، بۆ ئەوەی لە کەسوکارەکەم و ماڵی باوکم ژنێک بۆ کوڕەکەم بخوازیت. ");
INSERT INTO ckb_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","ئەگەر بێتو بچیتە لای کەسوکارەکەم و ئەوان ژنت نەدەنێ، ئەوا سوێندەکەم بەتاڵ دەبێتەوە. ئینجا گەردنت ئازاد دەبێت لە سوێندەکەم.“ ");
INSERT INTO ckb_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","«جا ئەمڕۆ کە هاتمە لای کانییەکە، گوتم: ”ئەی یەزدان، خودای ئیبراهیمی گەورەم، ئەگەر ڕێگاکەم سەرکەوتوو دەکەیت کە لەسەری دەڕۆم، ");
INSERT INTO ckb_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","ئەوەتا من لەسەر ئەم کانیاوە ڕاوەستاوم، با ئەو کچەی کە دێتە دەرەوە بۆ ئاوکێشان و پێی دەڵێم: ’تۆزێک ئاوم لە گۆزەکەت بدەرێ.‘ ");
INSERT INTO ckb_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","ئەویش پێم دەڵێت: ’تۆ بخۆرەوە، هەروەها بۆ وشترەکانیشت ئاو دەکێشم.‘ ئەوە ئەو کچە بێت کە یەزدان بۆ کوڕی گەورەکەمی هەڵبژاردووە.“ ");
INSERT INTO ckb_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","«ئەوە بوو هێشتا قسەکەم لە دڵی خۆمدا تەواو نەکردبوو کە ڕڤقە هاتە دەرێ و گۆزەکەی لەسەر شانی بوو. ئیتر هاتە خوارێ بۆ لای کانییەکە و گۆزەکەی پڕکرد. منیش پێم گوت: ”ئاوم بدەرێ.“ ");
INSERT INTO ckb_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","«ئەویش بە پەلە گۆزەکەی سەر شانی خۆی داگرت و گوتی: ”تۆ بخۆرەوە، هەروەها وشترەکانیشت ئاو دەدەم.“ منیش خواردمەوە، هەروەها وشترەکانیشی ئاو دا. ");
INSERT INTO ckb_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","«پرسیارم لێکرد و گوتم: ”تۆ کچی کێیت؟“ «ئەویش گوتی: ”کچی بتوئێلی کوڕی ناحۆرم، ئەوەی لە میلکەیە.“ «خەزێمەکەم لە لووتی کرد و بازنەکانیشم لە دەستی کرد. ");
INSERT INTO ckb_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","منیش چۆکم دادا و کڕنۆشم بۆ یەزدان برد. ستایشی یەزدانم کرد، خودای ئیبراهیمی گەورەم، کە ڕێنمایی کردم بۆ سەر ڕێگای ڕاست بۆ ئەوەی کچەزای براکەی گەورەکەم بۆ کوڕەکەی بهێنم. ");
INSERT INTO ckb_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","ئێستاش ئەگەر چاکە و وەفاداری لەگەڵ گەورەکەم دەکەن، ئەوا پێم بڵێن، ئەگەر ناشیکەن، هەر پێم بڵێن، بۆ ئەوەی بزانم ڕوو لە ڕاست یان لە چەپ بکەم.» ");
INSERT INTO ckb_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","لابان و بتوئێل وەڵامیان دایەوە: «ئەم کارە لە یەزدانەوەیە، ناتوانین نە بە خراپ و نە بە چاک هیچت پێ بڵێین. ");
INSERT INTO ckb_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","ئەوە ڕڤقە لەبەردەمتە، بیبە و بڕۆ، با ببێتە ژنی کوڕی گەورەکەت، هەروەک یەزدان فەرمووی.» ");
INSERT INTO ckb_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","ئیتر کە خزمەتکارەکەی ئیبراهیم گوێی لە قسەکانیان بوو، کڕنۆشی بۆ یەزدان برد. ");
INSERT INTO ckb_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","ئینجا خزمەتکارەکە قاپی زیو و قاپی زێڕ و جلوبەرگی دەرهێنا و پێشکەشی ڕڤقەی کرد، هەروەها دیاری گرانبەهای پێشکەشی دایک و براکەی کرد. ");
INSERT INTO ckb_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","ئیتر خۆی و ئەو پیاوانەی کە لەگەڵی بوون خواردیان و خواردیانەوە و شەو لەوێ مانەوە. کە بەیانی لە خەو هەستان، خزمەتکارەکە گوتی: «بمنێرنەوە بۆ لای گەورەکەم.» ");
INSERT INTO ckb_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","بەڵام دایک و برای ڕڤقە گوتیان: «با کچەکە بە لایەنی کەمەوە دە ڕۆژ لەلامان بمێنێتەوە، پاشان بەڕێ بکەوێت.» ");
INSERT INTO ckb_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","ئەویش پێی گوتن: «دوام مەخەن کە یەزدان ڕێگای بۆ سەرکەوتوو کردووم. بمنێرنەوە و دەچمەوە لای گەورەکەم.» ");
INSERT INTO ckb_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","ئەوانیش گوتیان: «کچەکە بانگ دەکەین و پرسیاری لێ دەکەین.» ");
INSERT INTO ckb_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","ئیتر ڕڤقەیان بانگکرد و لێیان پرسی: «لەگەڵ ئەم پیاوە دەڕۆیت؟» ئەویش گوتی: «دەڕۆم.» ");
INSERT INTO ckb_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","ئیتر ڕڤقەی خوشکیان و دایەنەکەی و خزمەتکارەکەی ئیبراهیم و پیاوەکانییان بەڕێکرد. ");
INSERT INTO ckb_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","داوای بەرەکەتیان بۆ ڕڤقەش کرد و پێیان گوت: «خوشکمان، پتر بن هەزار لەسەر هەزار، با نەوەکانیشت ببنە میراتگری دەروازەی ناحەزانیان.» ");
INSERT INTO ckb_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","ئینجا ڕڤقە و کەنیزەکانی هەستان و سواری وشترەکان بوون و دوای پیاوەکە کەوتن. ئیتر خزمەتکارەکە ڕڤقەی برد و ڕۆیشت. ");
INSERT INTO ckb_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","ئیسحاق کە لە خاکی نەقەب نیشتەجێ بوو، لە ڕێگای بیری لەحەی ڕۆئییەوە هاتبووەوە. ");
INSERT INTO ckb_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","ئیسحاق دەمەو ئێوارە چووە دەرەوە بۆ ناو کێڵگەکە و نوقومی بیرکردنەوە بوو، کە چاوی هەڵبڕی، بینی وا هەندێک وشتر بەرەو ڕووی دێن. ");
INSERT INTO ckb_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","ڕڤقەش چاوی هەڵبڕی و ئیسحاقی بینی. ئیتر لە وشترەکە دابەزی. ");
INSERT INTO ckb_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","بە خزمەتکارەکەی گوت: «ئەم پیاوە کێیە وا لە کێڵگەکەدا بۆ لامان دێت؟» خزمەتکارەکەش گوتی: «ئەوە گەورەکەمە.» ئەویش بە ڕووپۆشەکەی خۆی داپۆشی. ");
INSERT INTO ckb_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","ئیتر خزمەتکارەکە هەرچی کردبوو بۆ ئیسحاقی گێڕایەوە. ");
INSERT INTO ckb_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","ئیسحاقیش ڕڤقەی بردە ناو چادرەکەی سارای دایکی و هاوسەرگیری لەگەڵ کرد. ئیتر بوو بە ژنی و خۆشیویست و بووە مایەی دڵنەوایی ئیسحاق لەدوای مردنی دایکی. ");
INSERT INTO ckb_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","ئیبراهیم ژنێکی دیکەی هێنا کە ناوی قەتورە بوو. ");
INSERT INTO ckb_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","لەویش زیمران، یۆقشان، مەدان، میدیان، یەشباق و شوەحی بوو. ");
INSERT INTO ckb_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","یۆقشان باوکی شەبا و دیدان بوو. وەچەکانی دیدانیش، ئەشووری و لەتوشی و لەئومییەکان بوون. ");
INSERT INTO ckb_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","کوڕەکانی میدیانیش عێفا، عێفەر، حەنۆک، ئەبیداع و ئەلداعە بوون. هەموو ئەمانە نەوەی قەتورە بوون. ");
INSERT INTO ckb_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","ئیبراهیم هەرچی ماڵوموڵکی هەبوو دایە ئیسحاق، ");
INSERT INTO ckb_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","بەڵام کاتێک هێشتا لە ژیاندا بوو، دیاری بەو کوڕانەی دا کە لە کەنیزەکانی بوون و بەرەو خاکی ڕۆژهەڵات ناردنی، دوور لە ئیسحاقی کوڕی. ");
INSERT INTO ckb_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","ئیبراهیم سەد و حەفتا و پێنج ساڵ ژیا. ");
INSERT INTO ckb_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","ئینجا ئیبراهیم لە تەمەنێکی باشی پیریدا، دواهەناسەی دا و مرد، پیرەمێردێکی تێر لە ژیان خواردوو، ئیتر چووەوە پاڵ گەلەکەی خۆی. ");
INSERT INTO ckb_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","هەردوو کوڕەکەشی، ئیسحاق و ئیسماعیل، باوکیان لە ئەشکەوتەکەی مەخپێلە کە بەرامبەر مەمرێیە و لە کێڵگەکەی عەفرۆنی کوڕی چۆحەری حیتیدایە، بە خاک سپارد. ");
INSERT INTO ckb_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","ئیبراهیم ئەو کێڵگەیەی لە حیتییەکان کڕیبوو. لەوێ ئیبراهیم لەگەڵ سارای ژنی بە خاک سپێردرا. ");
INSERT INTO ckb_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","دوای مردنی ئیبراهیم، خودا ئیسحاقی کوڕی بەرەکەتدار کرد. ئیسحاقیش لەلای بیری لەحەی ڕۆئییەوە نیشتەجێ بوو. ");
INSERT INTO ckb_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","ئەمانەش نەوەکانی ئیسماعیلی کوڕی ئیبراهیمن کە هاجەری میسری، کەنیزەکەی سارا، بۆ ئیبراهیمی بوو. ");
INSERT INTO ckb_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","ئەمانەش ناوی کوڕەکانی ئیسماعیلن، ناویان بەپێی لەدایکبوونیان: نەبایۆت کە نۆبەرەی ئیسماعیل بوو، هەروەها قێدار، ئەدبەئێل، میبسام، ");
INSERT INTO ckb_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","میشماع، دوما، مەسسا، ");
INSERT INTO ckb_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","حەدەد، تێما، یەتور، نافیش و قێدما. ");
INSERT INTO ckb_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","ئەمانە کوڕەکانی ئیسماعیل بوون، هەروەها ناوی دوازدە میرە خێڵەکییەکەن بەپێی هەوار و خێوەتگاکانیان. ");
INSERT INTO ckb_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","ئیسماعیل سەد و سی و حەوت ساڵ ژیا، ئینجا دواهەناسەی دا و مرد و چووەوە پاڵ گەلەکەی خۆی. ");
INSERT INTO ckb_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","نەوەکانی ئیسماعیل لە حەڤیلاوە هەتا شوور نیشتەجێ بوون، لە نزیک سنووری میسر لەسەر ڕێگای ئەشوور. ئەوان دژی هەموو براکانیان بوون. ");
INSERT INTO ckb_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","ئەمانەش نەوەکانی ئیسحاقی کوڕی ئیبراهیمن. ئیبراهیم ئیسحاقی بوو. ");
INSERT INTO ckb_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","ئیسحاق تەمەنی چل ساڵ بوو کاتێک ڕڤقەی کچی بتوئێلی ئارامی کە خوشکی لابانی ئارامی بوو لە پەدان ئارامەوە هێنای تاکو ببێتە ژنی. ");
INSERT INTO ckb_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","ئیسحاق لە پێناو ژنەکەی لە یەزدان پاڕایەوە، چونکە نەزۆک بوو. یەزدانیش وەڵامی دایەوە و ڕڤقەی ژنی سکپڕ بوو. ");
INSERT INTO ckb_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","هەردوو کوڕەکە لە سکیدا ململانێی یەکتریان دەکرد، ئەویش گوتی: «بۆچی ئەمە لە من ڕوودەدات؟» ئیتر چوو هەتا پرسیار لە یەزدان بکات. ");
INSERT INTO ckb_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","یەزدانیش پێی فەرموو: «دوو نەتەوە لە منداڵدانتن، دوو گەل لە هەناوتەوە لە یەک جیا دەبنەوە، گەلێکیان لە گەلەکەی دیکە بەهێزتر دەبێت، گەورەکە خزمەتی بچووکەکە دەکات.» ");
INSERT INTO ckb_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","کە ڕۆژانی خۆی تەواو کرد و هاتە سەر منداڵبوون، بێگومان دووانەیەک لە منداڵدانی بوو. ");
INSERT INTO ckb_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","ئەوەیان کە یەکەم جار لەدایک بوو سوور بوو، هەموو لەشی وەک کەوڵێکی تووکن وابوو، بۆیە ناویان لێنا عیسۆ. ");
INSERT INTO ckb_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","دوای ئەم براکەی لەدایک بوو، کە بە دەستی پاژنە پێی عیسۆی گرتبوو، بۆیە ناویان لێنا یاقوب. ئیسحاق لە تەمەنی شەست ساڵیدا بوو کاتێک ڕڤقە ئەمانی بوو. ");
INSERT INTO ckb_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","هەردوو کوڕەکە گەورە بوون. عیسۆ بووە ڕاوکەرێکی شارەزا و پیاوی دەشتودەر، بەڵام یاقوب پیاوێکی لەسەرخۆ و چادرنشین بوو. ");
INSERT INTO ckb_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","ئیسحاق عیسۆی زیاتر خۆشدەویست، چونکە حەزی لە گۆشتی نێچیر بوو، بەڵام ڕڤقە یاقوبی زیاتر خۆشدەویست. ");
INSERT INTO ckb_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","ڕۆژێک یاقوب چێشتی لێدەنا، عیسۆ لە دەشتودەر هاتەوە و پەکی کەوتبوو. ");
INSERT INTO ckb_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","عیسۆ بە یاقوبی گوت: «هەندێکم لەو چێشتە سوورە بدەرێ! پەکم کەوتووە.» لەبەر ئەمەیە ناوی لێنرا ئەدۆم. ");
INSERT INTO ckb_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","یاقوبیش گوتی: «تۆش ئەمڕۆ نۆبەرایەتییەکەی خۆتم پێ بفرۆشە.» ");
INSERT INTO ckb_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","عیسۆ گوتی: «من وا خەریکە دەمرم، ئیتر نۆبەرایەتیم بۆ چییە؟» ");
INSERT INTO ckb_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","بەڵام یاقوب گوتی: «ئادەی ئەمڕۆ سوێندم بۆ بخۆ.» ئەویش سوێندی بۆ خوارد و نۆبەرایەتییەکەی خۆی فرۆشتە یاقوب. ");
INSERT INTO ckb_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","ئینجا یاقوب نان و نیسکی دایە عیسۆ. ئیتر عیسۆ خواردی و خواردیەوە، پاشان هەستا و ڕۆیشت. بەو شێوەیە عیسۆ سووکایەتی بە نۆبەرایەتی کرد. ");
INSERT INTO ckb_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","ئینجا جیا لەو قاتوقڕییەی کە یەکەم جار لە سەردەمی ئیبراهیمدا ڕوویدا، قاتوقڕییەکی دیکە لە خاکەکە سەریهەڵدا. ئیسحاقیش چوو بۆ لای ئەبیمەلەخی پاشای فەلەستییەکان لە گرار. ");
INSERT INTO ckb_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","یەزدان بۆ ئیسحاق دەرکەوت و فەرمووی: «مەچووە میسر، بەڵام لەو خاکە نیشتەجێ بە کە خۆم پێت دەڵێم. ");
INSERT INTO ckb_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","بۆ ماوەیەک لەم خاکە بمێنەوە، خۆم لەگەڵت دەبم و بەرەکەتدارت دەکەم، چونکە هەموو ئەم خاکانە دەدەمە خۆت و نەوەکەت، ئەو سوێندەش دەچەسپێنم کە بۆ ئیبراهیمی باوکتم خواردووە. ");
INSERT INTO ckb_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","نەوەشت زۆر دەکەم، وەک ئەستێرەکانی ئاسمان، هەموو ئەم خاکەشم داوەتە نەوەکەت، لە ڕێگەی نەوەی تۆوە هەموو نەتەوەکانی سەر زەوی بەرەکەتدار دەبن. ");
INSERT INTO ckb_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","لەبەر ئەوەی ئیبراهیم گوێڕایەڵی فەرمایشتەکەم بوو، داواکاری و فەرمان و فەرز و فێرکردنی منی بەجێهێنا.» ");
INSERT INTO ckb_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","ئیتر ئیسحاق لە گرار نیشتەجێ بوو. ");
INSERT INTO ckb_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","پیاوانی ئەو شوێنە دەربارەی ژنەکەی پرسیاریان لێکرد، ئەویش گوتی: «ئەو خوشکمە.» ئیسحاق ترسا لەوەی پێیان بڵێت «ژنمە،» چونکە گوتی، «نەوەک پیاوانی شوێنەکە لەبەر ڕڤقە بمکوژن، چونکە جوانە.» ");
INSERT INTO ckb_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","کاتێک ماوەیەکی زۆر لەوێ مایەوە، ئەبیمەلەخی پاشای فەلەستییەکان لە پەنجەرەکەوە سەیری خوارەوەی دەکرد، بینی وا ئیسحاق لەگەڵ ڕڤقەی ژنی خەریکی دەستبازییە. ");
INSERT INTO ckb_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","ئینجا ئەبیمەلەخ بەدوای ئیسحاقدا ناردی و گوتی: «کەواتە ئەو ژنتە! ئەی چۆن گوتت: ”ئەو خوشکمە“؟» ئیسحاقیش پێی گوت: «چونکە پێم وابوو کە لەوانەیە بەهۆی ئەوەوە بمرم.» ");
INSERT INTO ckb_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","ئەبیمەلەخیش گوتی: «ئەمە چییە بە ئێمەت کرد؟ لەوانەیە یەکێک لەم پیاوانە لەگەڵ ژنەکەت سەرجێیی بکردبا، ئەو کاتە ئێمەت تووشی تاوان دەکرد.» ");
INSERT INTO ckb_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","ئیتر ئەبیمەلەخ فەرمانی بە هەموو خەڵکەکە کرد و گوتی: «هەرکەسێک دەست ببات بۆ ئەم پیاوە یان ژنەکەی بێگومان دەکوژرێت.» ");
INSERT INTO ckb_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","ئیسحاق لەو زەوییەدا کشتوکاڵی کرد و هەر ئەو ساڵە سەد ئەوەندەی دەست کەوت، چونکە یەزدان بەرەکەتداری کرد. ");
INSERT INTO ckb_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","ئیتر ئیسحاق دەوڵەمەند بوو، بەردەوام سامانەکەی زیادی دەکرد، هەتا وای لێهات زۆر دەوڵەمەند بوو. ");
INSERT INTO ckb_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","ئینجا بەهۆی ئەوەی کە بووە خاوەن مەڕ و مانگا و خزمەتکارێکی زۆریش، فەلەستییەکانیش بەغیلییان پێ برد. ");
INSERT INTO ckb_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","هەموو ئەو بیرانەش کە خزمەتکارەکانی باوکی لە سەردەمی ئیبراهیمی باوکی هەڵیانکەندبوو، فەلەستییەکان بە خۆڵ پڕیان کردبووەوە و دایانخستبوو. ");
INSERT INTO ckb_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","ئینجا ئەبیمەلەخ بە ئیسحاقی گوت: «لەلای ئێمە بڕۆ، چونکە زۆر لە ئێمە بەهێزتر بوویت.» ");
INSERT INTO ckb_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","ئیتر ئیسحاق لەوێ ڕۆیشت و لە دۆڵی گرار چادری هەڵدا و لەوێ نیشتەجێ بوو. ");
INSERT INTO ckb_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","ئیسحاق جارێکی دیکە ئەو بیرانەی هەڵدایەوە کە لە سەردەمی ئیبراهیمی باوکی هەڵکەنرابوون و فەلەستییەکان دوای مردنی ئیبراهیم دایانخستبوو، هەر هەمان ناویشی لێنان کە باوکی لێینابوون. ");
INSERT INTO ckb_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","خزمەتکارەکانی ئیسحاق لە دۆڵەکە کەوتنە هەڵکەندن و کارێزێکی ئاوی سازگاریان لەوێ دۆزییەوە. ");
INSERT INTO ckb_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","بەڵام شوانەکانی گرار لەگەڵ شوانەکانی ئیسحاق بوو بە ناکۆکییان و گوتیان: «ئاوەکە هی ئێمەیە.» ئیتر بیرەکەی ناو نا عێسەق، چونکە لەسەری کردیانە ناکۆکی. ");
INSERT INTO ckb_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","ئینجا بیرێکی دیکەیان هەڵکەند، بەڵام دیسان لەسەر ئەمەش بوو بە ناکۆکییان، لەبەر ئەوە ناوی لەمەش نا سیتنا. ");
INSERT INTO ckb_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","ئیتر لەوێ گواستییەوە و بیرێکی دیکەی هەڵکەند، کە ناکۆک نەبوون لەسەری. بۆیە ناوی لەمە نا ڕەحۆبۆت و گوتی: «ئێستا یەزدان شوێنێکی فراوانی پێ بەخشیوین و لە زەوییەکەدا بە بەروبووم دەبین.» ");
INSERT INTO ckb_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","ئینجا لەوێوە بۆ بیری شابەع چوو. ");
INSERT INTO ckb_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","جا لەو شەوەدا یەزدان بۆی دەرکەوت و فەرمووی: «من خودای ئیبراهیمی باوکتم. مەترسە، چونکە لەگەڵتم. لەبەر ئیبراهیمی بەندەم، بەرەکەتدارت دەکەم و نەوەت زۆر دەکەم.» ");
INSERT INTO ckb_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","ئیتر ئیسحاق لەوێ قوربانگایەکی بنیاد نا، بە ناوی یەزدانەوە نزای کرد. لەوێ چادرەکەی هەڵدا، خزمەتکارەکانیشی لەوێ بیرێکیان هەڵکەند. ");
INSERT INTO ckb_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","هەر لەو کاتەدا ئەبیمەلەخ لەگەڵ ئەحوزەتی ڕاوێژکاری و فیکۆلی فەرماندەی گشتی لە گرارەوە هاتنە لای. ");
INSERT INTO ckb_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","ئیسحاقیش لێی پرسین: «بۆچی هاتوون بۆ لام، لە کاتێکدا ڕقتان لێم بوو و لەلای خۆتان دەرتانکردم؟» ");
INSERT INTO ckb_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","ئەوانیش گوتیان: «ئێمە بە تەواوی بینیمان کە یەزدان لەگەڵ تۆ بوو، ئیتر گوتمان: ”با لەنێوانمان سوێند هەبێت،“ لەنێوان ئێمە و تۆ. با پەیمانت لەگەڵ ببەستین، ");
INSERT INTO ckb_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","کە خراپەمان لەگەڵ نەکەیت، وەک چۆن ئێمە دەستمان بۆت نەبرد و لە چاکە بەولاوە هیچی دیکەمان لەگەڵ نەکردیت و بە سەلامەتی بەڕێمان کردیت. ئێستاش تۆ بەرەکەتداری یەزدانیت.» ");
INSERT INTO ckb_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","ئینجا ئیسحاق خوانی بۆ ساز کردن، ئیتر خواردیان و خواردیانەوە. ");
INSERT INTO ckb_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","بۆ سبەی بەیانی زوو لە خەو هەستان و هەریەکە و سوێندی بۆ ئەوی دیکەیان خوارد. ئینجا ئیسحاق بەڕێی کردن، ئەوانیش بە سەلامەتی لەلای ڕۆیشتن. ");
INSERT INTO ckb_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","ئەوە بوو هەر لەو ڕۆژەدا خزمەتکارەکانی ئیسحاق هاتن و دەربارەی ئەو بیرەی کە هەڵیانکەندبوو پێیان ڕاگەیاند و گوتیان: «ئاومان دۆزییەوە.» ");
INSERT INTO ckb_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","ئەویش ناوی لێنا شیبعا، لەبەر ئەوەیە هەتا ئەمڕۆش ناوی شارۆچکەکە بیری شابەعە. ");
INSERT INTO ckb_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","کاتێک عیسۆ تەمەنی بووە چل ساڵ، یەهودیتی کچی بئێریی حیتی و باسمەتی کچی ئێلۆنی حیتی هێنا. ");
INSERT INTO ckb_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","ئەوان ببوونە مایەی خەم و خەفەتی ئیسحاق و ڕڤقە. ");
INSERT INTO ckb_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","کاتێک ئیسحاق پیر بوو و چاوەکانی نەیدەبینی، عیسۆی کوڕە گەورەی خۆی بانگکرد و پێی گوت: «کوڕی خۆم.» ئەویش وەڵامی دایەوە: «ئەوەتام.» ");
INSERT INTO ckb_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","ئیسحاق گوتی: «ئەوا پیر بووم و ڕۆژی مردنی خۆم نازانم. ");
INSERT INTO ckb_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","ئێستاش چەکەکەت و تیردانەکەت و کەوانەکەت هەڵبگرە و بڕۆ لە دەشتودەر نێچیرێکم بۆ ڕاو بکە. ");
INSERT INTO ckb_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","ئەو خواردنەی حەزم لێیەتی بۆم ئامادە بکە و بیهێنە تاکو بیخۆم، بۆ ئەوەی بەر لەوەی بمرم داوای بەرەکەتت بۆ بکەم.» ");
INSERT INTO ckb_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","ڕڤقە گوێی لێبوو کاتێک ئیسحاق قسەی لەگەڵ عیسۆ دەکرد. ئینجا عیسۆ چوو بۆ دەشتودەر تاکو نێچیرێک ڕاو بکات و بیهێنێتەوە. ");
INSERT INTO ckb_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","ڕڤقە لەگەڵ یاقوبی کوڕی قسەی کرد و گوتی: «گوێم لە باوکت بوو قسەی لەگەڵ عیسۆی برات دەکرد و گوتی: ");
INSERT INTO ckb_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","”نێچیرێکم بۆ بهێنە و خواردنم بۆ ئامادە بکە، بەر لە مردنم دەیخۆم و لەبەردەم یەزدان داوای بەرەکەتت بۆ دەکەم.“ ");
INSERT INTO ckb_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","ئێستاش، کوڕی خۆم، باش گوێم لێ بگرە و ئەوە بکە کە پێت دەڵێم: ");
INSERT INTO ckb_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","بڕۆ لەلای مێگەلەکە دوو گیسکی ناسکم بۆ بهێنە، تاکو بەو جۆرە بۆ باوکتی ئامادە بکەم کە حەزی لێیەتی. ");
INSERT INTO ckb_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","ئینجا بۆ باوکتی دەبەیت و دەیخوات، بۆ ئەوەی بەر لە مردنی داوای بەرەکەتت بۆ بکات.» ");
INSERT INTO ckb_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","یاقوبیش بە ڕڤقەی دایکی گوت: «بەڵام عیسۆی برام پیاوێکی تووکنە و منیش پیاوێکی کۆسەم. ");
INSERT INTO ckb_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","ئەی ئەگەر باوکم دەستم لێ بدات؟ ئەو کاتە لەبەرچاوی دەبمە فێڵباز و ئیتر لە جێگەی بەرەکەت، نەفرەت بەسەر خۆمدا دەهێنم.» ");
INSERT INTO ckb_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","دایکیشی پێی گوت: «کوڕی خۆم، با نەفرەتەکەت لە من بکەوێت. تەنها گوێ لە من بگرە و بڕۆ بیانهێنە بۆم.» ");
INSERT INTO ckb_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","ئیتر ئەویش چوو کاریلەکانی گرت و هێنانی بۆ دایکی. دایکیشی خواردنی دروستکرد، بەو جۆرەی کە باوکی حەزی لێ دەکرد. ");
INSERT INTO ckb_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","ئینجا ڕڤقە جلوبەرگە باشەکەی عیسۆی کوڕە گەورەی هێنا، کە لە ماڵەوە لەلای خۆی بوو، لەبەر یاقوبی کوڕە بچووکی کرد. ");
INSERT INTO ckb_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","دەستەکانی و ئەو بەشەی ملی کە لووسە بە پێستی گیسکەکان دایپۆشی. ");
INSERT INTO ckb_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","ئینجا ئەو نان و خواردنەی کە دروستی کردبوون، دایە دەست یاقوبی کوڕی. ");
INSERT INTO ckb_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","یاقوب هاتە لای باوکی و گوتی: «باوکە.» ئەویش گوتی: «ئەوەتام، تۆ کیێت کوڕم؟» ");
INSERT INTO ckb_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","یاقوبیش بە باوکی گوت: «من عیسۆی نۆبەرەتم. ئەوەی پێت گوتم کردم. هەستە، دابنیشە و لە ڕاوەکەم بخۆ، بۆ ئەوەی داوای بەرەکەتم بۆ بکەیت.» ");
INSERT INTO ckb_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","ئیسحاقیش بە کوڕەکەی گوت: «ئەوە چۆن وا خێرا پەیدات کرد، کوڕی خۆم؟» ئەویش گوتی: «یەزدانی پەروەردگارت بۆی هێنام.» ");
INSERT INTO ckb_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","ئینجا ئیسحاق بە یاقوبی گوت: «وەرە پێشەوە با دەستت لێ بدەم، کوڕی خۆم، بۆ ئەوەی بزانم ئایا تۆ عیسۆی کوڕی منیت یان نا.» ");
INSERT INTO ckb_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","یاقوبیش لە ئیسحاقی باوکی چووە پێشەوە، ئەویش دەستی لێدا و گوتی: «دەنگەکە دەنگی یاقوبە، بەڵام دەستەکان دەستی عیسۆن.» ");
INSERT INTO ckb_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","ئیتر نەیناسییەوە، چونکە دەستەکانی وەک دەستەکانی عیسۆی برای تووکن بوون، کاتێک کە ویستی داوای بەرەکەتی بۆ بکات، ");
INSERT INTO ckb_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","پێی گوت: «ئایا تۆ عیسۆی کوڕی منی؟» ئەویش گوتی: «منم.» ");
INSERT INTO ckb_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","ئینجا گوتی: «بیهێنە پێشم با لە ڕاوی کوڕەکەم بخۆم، بۆ ئەوەی داوای بەرەکەتت بۆ بکەم.» ئیتر یاقوب هێنایە پێشی و خواردی، ئینجا شەرابی بۆ هێنا و خواردیەوە. ");
INSERT INTO ckb_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","ئیسحاقی باوکی پێی گوت: «وەرە پێشەوە و ماچم بکە، کوڕی خۆم.» ");
INSERT INTO ckb_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","ئەویش چووە پێشەوە و ماچی کرد. ئیتر ئیسحاق بۆنی جلەکانی کرد، داوای بەرەکەتی بۆ کرد و گوتی: «بڕوانە، بۆنی کوڕەکەم وەک بۆنی دەشتودەرە کە یەزدان بەرەکەتداری کردووە. ");
INSERT INTO ckb_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","با خودا لە شەونمی ئاسمان و لە چەوری زەویت بداتێ، هەروەها دانەوێڵەی زۆر و شەرابی نوێ. ");
INSERT INTO ckb_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","با گەلان ببنە خزمەتکارت، نەتەوەکانیش کڕنۆشت بۆ ببەن. ببە بە سەروەری براکانت، کوڕانی دایکت کڕنۆشت بۆ ببەن. با ئەوانەی نەفرەتت لێ دەکەن نەفرەت لێکراو بن و ئەوانەی داوای بەرەکەتت بۆ دەکەن بەرەکەتدار دەبن.» ");
INSERT INTO ckb_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","پاش ئەوەی ئیسحاق لە داواکردنی بەرەکەت بووەوە بۆ یاقوب، یاقوب لەلای ئیسحاقی باوکی چووە دەرەوە، عیسۆی برای لە ڕاوەکەی هاتەوە. ");
INSERT INTO ckb_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","ئەویش خواردنی ئامادە کرد و بردیە ژوورەوە بۆ باوکی و پێی گوت: «باوکە، هەستە لە ڕاوی کوڕەکەت بخۆ، تاکو داوای بەرەکەتم بۆ بکەیت.» ");
INSERT INTO ckb_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","ئیسحاقی باوکیشی پێی گوت: «تۆ کێیت؟» ئەویش گوتی: «من کوڕە نۆبەرەکەی خۆتم، عیسۆ.» ");
INSERT INTO ckb_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","ئیتر ئیسحاق زۆر توند لەرزی و گوتی: «ئەی کێ بوو ئەوەی کە نێچیرێکی ڕاوکردبوو و بۆی هێنام؟ منیش لە هەموویم خوارد، پێش ئەوەی تۆ بێیت داوای بەرەکەتیشم بۆ کرد، هەروەها بەرەکەتداریش دەبێت.» ");
INSERT INTO ckb_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","عیسۆ کە قسەکانی باوکی بیست، بە دەنگێکی زۆر بەرز و بە خەمبارییەوە هاواری کرد و بە باوکی گوت: «باوکە، دە داوای بەرەکەت بۆ منیش بکە!» ");
INSERT INTO ckb_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","بەڵام ئیسحاق گوتی: «ئاخر براکەت بە فێڵبازی هات و بەرەکەتی تۆی برد.» ");
INSERT INTO ckb_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","عیسۆ گوتی: «ئایا لە جێی خۆیدا نییە کە ناونراوە ”یاقوب“؟ ئەوە دوو جارە فێڵم لێ دەکات، نۆبەرایەتییەکەی منی برد، وا ئێستاش بەرەکەتەکەی منی برد.» ئینجا گوتی: «ئەی هیچ بەرەکەتێکت بۆ من نەهێشتووەتەوە؟» ");
INSERT INTO ckb_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","ئیسحاق وەڵامی دایەوە و بە عیسۆی گوت: «وا ئەوم کردووە بە سەروەری تۆ و هەموو کەسوکاریشیم داوەتێ بۆ ئەوەی ببنە خزمەتکاری ئەو، بە دانەوێڵە و شەرابی نوێ پشتگیریم کردووە. ئیتر بۆ تۆ چی بکەم، کوڕم؟» ");
INSERT INTO ckb_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","عیسۆش بە باوکی گوت: «ئایا تەنها یەک بەرەکەتت هەیە؟ باوکە، داوای بەرەکەت بۆ منیش بکە.» ئیتر عیسۆ دەنگی هەڵبڕی و گریا. ");
INSERT INTO ckb_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","ئیسحاقی باوکی وەڵامی دایەوە: «نشینگەکەت دوور لە دەوڵەمەندی زەوییەوە دەبێت، دوور لە شەونمی ئاسمان لە سەرەوە. ");
INSERT INTO ckb_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","لەسەر شمشێرەکەت دەژیت و دەبیتە خزمەتکاری براکەت. بەڵام کاتێک سەرکێش بوویت، نیرەکەی دەشکێنیت کە بە ملتەوەیە.» ");
INSERT INTO ckb_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","ئیتر عیسۆ ڕقی لە یاقوب هەڵگرت، بەهۆی ئەو بەرەکەتدارییەی کە باوکی داوای بەرەکەتی بۆ کردبوو. عیسۆ لە دڵی خۆیدا گوتی: «ڕۆژانی پرسەی باوکم نزیکە، ئینجا یاقوبی برام دەکوژم.» ");
INSERT INTO ckb_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","ڕڤقەش لەم قسانەی عیسۆی کوڕە گەورەی ئاگادار کرایەوە، ئیتر ناردی بەدوای یاقوبی کوڕە بچووکیدا و پێی گوت: «عیسۆی برات وا دڵخۆشی خۆی بەوە دەداتەوە کە تۆ دەکوژێت. ");
INSERT INTO ckb_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","ئێستاش کوڕی خۆم، گوێ لە قسەی من بگرە و ڕابکە بۆ لای لابانی برام لە حەڕان. ");
INSERT INTO ckb_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","بۆ ماوەیەک لەلای ئەو بمێنەوە هەتا ڕقی براکەت هێور دەبێتەوە. ");
INSERT INTO ckb_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","کاتێکیش تووڕەیی براکەت بەرامبەر بە تۆ هێور دەبێتەوە و ئەوەی لەبیر کرد کە پێت کردووە، ئەوا دەنێرم و لەوێ دەتهێنمەوە. ئیتر بۆ بە یەک ڕۆژ هەردووکتان لەدەست بدەم؟» ");
INSERT INTO ckb_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","ئینجا ڕڤقە بە ئیسحاقی گوت: «لەبەر کچانی حیتییەکان لە ژیانی خۆم بێزارم، خۆ ئەگەر یاقوبیش ژنێکی وەک ئەمانە لە کچانی حیتییەکانی ئەم خاکە بهێنێت، ئیتر ژیانم بۆ چییە؟» ");
INSERT INTO ckb_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","ئیسحاق یاقوبی بانگکرد و داوای بەرەکەتی بۆ کرد. ئینجا فەرمانی پێدا و پێی گوت: «لەگەڵ کچی کەنعانییەکان هاوسەرگیری مەکە. ");
INSERT INTO ckb_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","هەستە بڕۆ بۆ پەدان ئارام بۆ ماڵی بتوئێلی باوکی دایکت، لەوێ لە کچەکانی لابانی برای دایکت ژنێک بۆ خۆت بخوازە. ");
INSERT INTO ckb_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","با خودای هەرە بەتوانا بەرەکەتدار و بەردار و زۆرت بکات، هەتا دەبیتە کۆمەڵێک گەل. ");
INSERT INTO ckb_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","با خودا بەرەکەتی ئیبراهیم بە خۆت و نەوەکانت بدات، تاکو ببیتە میراتگری ئەو خاکەی کە خودا دابوویە ئیبراهیم و ئێستا تۆ وەکو بێگانە لەسەری دەژیت.» ");
INSERT INTO ckb_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","ئیتر ئیسحاق یاقوبی نارد، ئەویش چوو بۆ پەدان ئارام بۆ لای لابانی کوڕی بتوئێلی ئارامی، برای ڕڤقەی دایکی یاقوب و عیسۆ. ");
INSERT INTO ckb_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","عیسۆ بۆی دەرکەوت کە ئیسحاق داوای بەرەکەتی بۆ یاقوب کردووە و ناردوویەتی بۆ پەدان ئارام تاکو لەوێ ژن بهێنێت، ئینجا کاتێک داوای بەرەکەتی بۆ کردووە، فەرمانی پێداوە و گوتوویەتی: «لە کچانی کەنعان ژن نەخوازیت،» ");
INSERT INTO ckb_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","ئیتر یاقوبیش گوێڕایەڵی دایک و باوکی بووە و چووە بۆ پەدان ئارام. ");
INSERT INTO ckb_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","کاتێک کە عیسۆ زانی کچە کەنعانییەکان جێی پەسەندی ئیسحاقی باوکی نین و لەلای ئەو خراپن، ");
INSERT INTO ckb_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","چوو بۆ لای ئیسماعیل و ماحەلەتی خوشکی نەبایۆت و کچی ئیسماعیلی کوڕی ئیبراهیمی بەسەر ژنەکانی دیکەیدا خواست. ");
INSERT INTO ckb_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","یاقوب بیری شابەعی بەجێهێشت و بەرەو حەڕان ڕۆیشت. ");
INSERT INTO ckb_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","ئیتر ڕێی کەوتە شوێنێک و لەبەر خۆرئاوابوون لەوێ مایەوە. ئینجا بەردێکی لە بەردەکانی ئەو شوێنە هێنا و خستییە ژێر سەری و ڕاکشا. ");
INSERT INTO ckb_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","یاقوب خەونێکی بینی کە تێیدا پێپلیکانەیەک لەسەر زەوی ڕاگیراوە کە سەری لە ئاسمان دەدات و فریشتەکانی خودا پێیدا سەردەکەون و دێنە خوارەوە. ");
INSERT INTO ckb_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","وا یەزدان وەستاوە و دەفەرموێت: «من یەزدانم، خودای ئیبراهیمی باوکت و خودای ئیسحاق. ئەو خاکەی لەسەری ڕاکشاویت دەیدەمە خۆت و نەوەکانت. ");
INSERT INTO ckb_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","نەوەکەت وەک خۆڵی زەوی دەبێت، بەرەو ڕۆژئاوا و ڕۆژهەڵات و باکوور و باشوور بڵاو دەبیتەوە. هەموو هۆزەکانی زەویش لە ڕێگەی تۆ و نەوەی تۆوە بەرەکەتدار دەبن. ");
INSERT INTO ckb_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","من لەگەڵتدام و بۆ هەر لایەک بچیت دەتپارێزم، دەشتگەڕێنمەوە بۆ ئەم خاکە، چونکە وازت لێ ناهێنم هەتا ئەوە ئەنجام نەدەم کە پێم فەرموویت.» ");
INSERT INTO ckb_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","کاتێک یاقوب خەبەری بووەوە، گوتی: «بێگومان یەزدان لەم شوێنەیە، منیش نەمزانی!» ");
INSERT INTO ckb_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","ترسیش دایگرت و گوتی: «ئەم شوێنە چەند ترسناکە! ئەمە هیچی دیکە نییە ماڵی خودا نەبێت، ئێرەش دەروازەی ئاسمانە.» ");
INSERT INTO ckb_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","یاقوب بەیانی زوو لە خەو هەستا و ئەو بەردەی هێنا کە لەژێر سەری خۆی داینابوو بە ستوونی ڕاگیری کرد و زەیتی بەسەردا کرد. ");
INSERT INTO ckb_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","ئەو شوێنەشی ناو نا بێت‌ئێل، هەرچەندە پێشتر شارەکە ناوی لوز بوو. ");
INSERT INTO ckb_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","یاقوب نەزرێکی کرد و گوتی: «ئەگەر خودا لەگەڵ من بێت و لەم ڕێگایە بمپارێزێت کە پێیدا دەڕۆم و نانی دامێ بیخۆم و جلوبەرگیش بیپۆشم، ");
INSERT INTO ckb_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","بە سەلامەتیش گەڕامەوە لای ماڵی باوکم، ئەوا یەزدان دەبێتە خودای من. ");
INSERT INTO ckb_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","ئەم بەردەش کە بە ستوونی ڕاگیرم کردووە، دەبێتە ماڵی خودا و هەرچییەکیشم پێ ببەخشیت ئەوا دەیەکی لێ دەبەخشم.» ");
INSERT INTO ckb_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","ئینجا یاقوب پێی هەڵگرت و بەرەو خاکی گەلانی ڕۆژهەڵات ڕۆیشت. ");
INSERT INTO ckb_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","بینی وا بیرێک لە دەشتودەرەکە هەیە و سێ ڕانە مەڕ لەوێ ڕاکشاون، چونکە شوانەکان لەو بیرەوە مەڕەکانیان ئاو دەدا. بەردێکی گەورەش لەسەر دەمی بیرەکە بوو. ");
INSERT INTO ckb_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","کاتێک هەموو مێگەلەکان لەوێ کۆدەبوونەوە، شوانەکان بەردی سەر دەمی بیرەکەیان گلۆر دەکردەوە و مەڕەکانیان ئاو دەدا. پاشان بەردەکەیان دەگەڕاندەوە سەر دەمی بیرەکە، بۆ شوێنی خۆی. ");
INSERT INTO ckb_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","یاقوب بانگی کردن: «برایان، ئێوە خەڵکی کوێن؟» ئەوانیش گوتیان: «ئێمە خەڵکی حەڕانین.» ");
INSERT INTO ckb_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","پێی گوتن: «لابانی کوڕەزای ناحۆر دەناسن؟» گوتیان: «دەیناسین.» ");
INSERT INTO ckb_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","ئینجا یاقوب گوتی: «خۆ سەلامەتە؟» گوتیان: «بەڵێ سەلامەتە، ئەوەش ڕاحێلی کچیەتی کە مەڕەکان بەرەو ئێرە دێنێت.» ");
INSERT INTO ckb_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","گوتی: «وا هێشتا ڕۆژ زۆری ماوە، کاتی کۆکردنەوەی مەڕەکان نییە. مەڕەکان ئاو بدەن و بڕۆنەوە بیانلەوەڕێنن.» ");
INSERT INTO ckb_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","ئەوانیش گوتیان: «ناتوانین، هەتا هەموو مەڕەکان کۆنەبنەوە و بەردی سەر دەمی بیرەکە تل نەدرێت. ئەو کاتە مەڕەکان ئاو دەدرێن.» ");
INSERT INTO ckb_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","هێشتا خەریکی قسەکردن بوو لەگەڵیان، ڕاحێل هات و مەڕەکانی باوکیشی لەگەڵ بوو، چونکە ڕاحێل شوان بوو. ");
INSERT INTO ckb_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","کاتێک یاقوب ڕاحێلی کچی لابانی خاڵی و مەڕەکانی لابانی خاڵی بینی، چووە پێشەوە و بەردی سەر بیرەکەی تل دا و مەڕەکانی ئاو دا. ");
INSERT INTO ckb_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","یاقوب ڕاحێلی ماچ کرد و دەنگی بەرز کردەوە و گریا. ");
INSERT INTO ckb_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","ئیتر یاقوب بە ڕاحێلی گوت کە ئەو خزمی باوکیەتی و کوڕی ڕڤقەیە. ئەویش ڕایکرد و بە باوکی ڕاگەیاند. ");
INSERT INTO ckb_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","هەرکە لابان ئەم هەواڵەی یاقوبی خوشکەزای بیست، بە ڕاکردن چوو بۆ دیدەنی. باوەشی پێدا کرد و ماچی کرد و هێنایە ماڵەکەی خۆی. ئینجا یاقوب باسی هەموو ئەو شتانەی بۆ لابان کرد کە ڕوویان دابوو. ");
INSERT INTO ckb_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","لابانیش پێی گوت: «تۆ لە گۆشت و خوێنی منیت.» لەدوای ئەوەی یاقوب مانگێک لەلای مایەوە، ");
INSERT INTO ckb_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","لابان پێی گوت: «هەر لەبەر ئەوەی کەسی خۆمیت، ئایا ئیتر دەبێت بەخۆڕایی کارم بۆ بکەیت؟ پێم بڵێ دەبێت کرێیەکەت چی بێت؟» ");
INSERT INTO ckb_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","لابان دوو کچی هەبوو، گەورەکەیان ناوی لێئە بوو، بچووکەکەشیان ناوی ڕاحێل بوو. ");
INSERT INTO ckb_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","چاوەکانی لێئە کز بوون، بەڵام ڕاحێل ناسک و جوان بوو. ");
INSERT INTO ckb_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","یاقوب کە ڕاحێلی خۆشدەویست، گوتی: «حەوت ساڵ کارت بۆ دەکەم بەرامبەر ڕاحێلی کچە بچووکت.» ");
INSERT INTO ckb_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","لابانیش گوتی: «بیدەمە تۆ باشترە لەوەی بیدەمە پیاوێکی دیکە. لێرە لەلای خۆم بمێنەوە.» ");
INSERT INTO ckb_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","ئیتر یاقوب لەبەر ڕاحێل حەوت ساڵ کاری کرد، بەڵام لەبەر خۆشەویستییەکەی بەرامبەر بە ڕاحێل، لەلای ئەو وەک چەند ڕۆژێکی کەم وابوو. ");
INSERT INTO ckb_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","ئینجا یاقوب بە لابانی گوت: «ژنەکەم بدەرێ، چونکە ماوەکەم تەواو کرد، دەشمەوێت بیگوازمەوە.» ");
INSERT INTO ckb_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","لابانیش خەڵکی شوێنەکەی کۆکردەوە و ئاهەنگێکی ساز کرد. ");
INSERT INTO ckb_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","بەڵام کاتێک ئێوارە داهات، پەلی لێئەی کچی گرت و هێنای بۆ یاقوب. ئەویش سەرجێیی لەگەڵی کرد. ");
INSERT INTO ckb_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","هەروەها لابان زیلپەی کەنیزەی خۆی کردە کەنیزەی لێئەی کچی. ");
INSERT INTO ckb_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","کە ڕۆژ بووەوە، لێئە لەوێ بوو! یاقوبیش بە لابانی گوت: «ئەمە چییە بە منت کرد؟ مەگەر بۆ ڕاحێل نەبوو کە کارم بۆ کردیت؟ ئەی بۆچی فێڵت لێکردم؟» ");
INSERT INTO ckb_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","لابانیش گوتی: «ئەوە دابونەریتی ئێمە نییە کە کچە بچووکەکە پێش گەورەکە بە شوو بدەین. ");
INSERT INTO ckb_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","هەفتەی بووکێنی ئەم تەواو بکە، ئەوی دیکەشیانت بەرامبەر بە حەوت ساڵی دیکەی کارکردن دەدەینێ.» ");
INSERT INTO ckb_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","یاقوبیش بەم جۆرەی کرد. حەوت ڕۆژەکەی لەگەڵ لێئە تەواو کرد، لابانیش ڕاحێلی کچی پێدا هەتا ببێتە ژنی. ");
INSERT INTO ckb_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","هەروەها لابان بیلهەی کەنیزەی خۆی کردە کەنیزەی ڕاحێلی کچی. ");
INSERT INTO ckb_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","یاقوب لەگەڵ ڕاحێلیش سەرجێیی کرد، ئەو ڕاحێلی لە لێئە زیاتر خۆشدەویست. حەوت ساڵی دیکەش کاری بۆ لابان کرد. ");
INSERT INTO ckb_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","کاتێک یەزدان بینی کە لێئە خۆشەویست نییە، توانای منداڵبوونی پێ بەخشی، بەڵام ڕاحێل نەزۆک بوو. ");
INSERT INTO ckb_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","لێئە سکی پڕ بوو، کوڕێکی بوو ناوی لێنا ڕەئوبێن، لەبەر ئەوەی گوتی: «یەزدان نەگبەتی منی بەدی کردووە، بێگومان ئێستا مێردەکەم منی خۆشدەوێ.» ");
INSERT INTO ckb_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","دیسان سکی پڕ بوو، کوڕێکی دیکەی بوو و گوتی: «یەزدان بیستوویەتی خۆشەویست نیم، بۆیە ئەمەشی پێدام.» ناوی لێنا شیمۆن. ");
INSERT INTO ckb_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","جارێکی دیکەش سکی پڕ بوو، کوڕێکی بوو و گوتی: «وا ئەم جارە ئیتر مێردەکەم پێمەوە پەیوەست دەبێت، چونکە سێ کوڕم بۆی بووە.» لەبەر ئەوە ناوی لێنا لێڤی. ");
INSERT INTO ckb_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","دیسان سکی پڕ بوو، کوڕێکی بوو و گوتی: «ئەم جارە ستایشی یەزدان دەکەم.» لەبەر ئەوە ناوی لێنا یەهودا. ئیتر لە سککردن وەستا. ");
INSERT INTO ckb_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","کاتێک ڕاحێل بینی هیچ منداڵێکی بۆ یاقوب نەبوو، بەغیلی بە خوشکەکەی خۆی برد، بە یاقوبی گوت: «منداڵم پێبدە، ئەگینا دەمرم!» ");
INSERT INTO ckb_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","یاقوب لە ڕاحێل تووڕە بوو و گوتی: «ئایا من لە جێی خودام کە لە بەرهەمی سک بێبەشی کردوویت؟» ");
INSERT INTO ckb_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","ئەویش گوتی: «ئەوەتا بیلهەی کەنیزەم. سەرجێیی لەگەڵ بکە هەتا لەسەر چۆکم منداڵی ببێت، ئیتر لەوەوە منیش کوڕم دەبێت.» ");
INSERT INTO ckb_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","جا بیلهەی کەنیزەی خۆی دایێ تاکو ببێتە ژنی. یاقوبیش سەرجێیی لەگەڵی کرد. ");
INSERT INTO ckb_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","بیلهەش سکی پڕ بوو، کوڕێکی بۆ یاقوب بوو. ");
INSERT INTO ckb_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","ڕاحێل گوتی: «خودا پشتگیری کردم و گوێی لە داواکەم گرت، هەروەها گوێی لە دەنگم بوو و کوڕێکی پێدام.» لەبەر ئەوە ناوی لێنا دان. ");
INSERT INTO ckb_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","دیسان بیلهە، کەنیزەکەی ڕاحێل سکی کرد و کوڕی دووەمی بۆ یاقوب بوو. ");
INSERT INTO ckb_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","ئینجا ڕاحێل گوتی: «بە زۆرانبازی خودا، زۆرانبازیم لەگەڵ خوشکەکەم کرد و بردیشمەوە.» لەبەر ئەوە ناوی لێنا نەفتالی. ");
INSERT INTO ckb_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","کاتێک لێئە بینی وا لە سککردن وەستاوە، پەلی زیلپەی کەنیزەکەی خۆی گرت و دایە یاقوب هەتا ببێتە ژنی. ");
INSERT INTO ckb_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","زیلپەی کەنیزەی لێئە کوڕێکی بۆ یاقوب بوو. ");
INSERT INTO ckb_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","لێئە گوتی: «بەختێکی باش!» ئیتر ناوی لێنا گاد. ");
INSERT INTO ckb_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","زیلپەی کەنیزەی لێئە کوڕی دووەمی بۆ یاقوب بوو. ");
INSERT INTO ckb_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","لێئەش گوتی: «خۆزگە بە من دەخوازرێت! لەبەر ئەوەی کچان خۆزگەم پێ دەخوازن.» ئیتر ناوی لێنا ئاشێر. ");
INSERT INTO ckb_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","لە ڕۆژانی دروێنەی گەنمدا، ڕەئوبێن چوو هەندێک گیائادەمەی لە کێڵگە بینییەوە و بۆ لێئەی دایکی هێنایەوە. ڕاحێلیش بە لێئەی گوت: «هەندێک لە گیائادەمەی کوڕەکەتم بدەرێ.» ");
INSERT INTO ckb_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","بەڵام لێئە گوتی: «ئایا بە لاتەوە کەمە مێردەکەت بردووم؟ ئایا گیائادەمەی کوڕەکەشم دەبەیت؟» ڕاحێلیش گوتی: «دەی باشە با لە جیاتی گیائادەمەی کوڕەکەت ئەمشەو لەلای تۆ بێت.» ");
INSERT INTO ckb_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","کاتێک یاقوب دەمەو ئێوارە لە کێڵگە گەڕایەوە، لێئە بۆ پێشوازیکردنی چووە دەرەوە و گوتی: «دەبێت ئەمشەو بێیتە لای من، چونکە بە گیائادەمەی کوڕەکەم بە کرێم گرتوویت.» ئەویش ئەو شەوە سەرجێیی لەگەڵی کرد. ");
INSERT INTO ckb_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","خودا گوێی لە لێئە بوو، ئیتر سکی پڕ بوو، کوڕی پێنجەمی بۆ یاقوب بوو. ");
INSERT INTO ckb_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","ئینجا لێئە گوتی: «خودا پاداشتی ئەوەی دامەوە کە کەنیزەکەی خۆمم دایە پیاوەکەم.» ئیتر ناوی لێنا یەساخار. ");
INSERT INTO ckb_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","دیسان لێئە سکی کرد و کوڕی شەشەمینی بۆ یاقوب بوو. ");
INSERT INTO ckb_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","ئینجا لێئە گوتی: «خودا خەڵاتێکی باشی کردم. ئێستا مێردەکەم ڕێزم لێ دەگرێت، چونکە شەش کوڕم بۆی بوو.» ناوی لە کوڕەکەش نا زەبولون. ");
INSERT INTO ckb_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","دوای ئەمە کچێکیشی بوو، ناوی لێنا دینە. ");
INSERT INTO ckb_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","خودا ڕاحێلی هاتەوە یاد؛ گوێی لێ گرت و منداڵدانی کردەوە. ");
INSERT INTO ckb_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","ئیتر سکی پڕ بوو، کوڕێکی بوو و گوتی: «خودا سووکایەتییەکەی لەسەر لابردم.» ");
INSERT INTO ckb_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","ناوی لێنا یوسف، چونکە گوتی: «یەزدان کوڕێکی دیکەشم بۆ زیاد دەکات.» ");
INSERT INTO ckb_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","لەدوای ئەوەی ڕاحێل یوسفی بوو، یاقوب بە لابانی گوت: «بمنێرەوە و دەگەڕێمەوە شوێن و زەوی خۆم. ");
INSERT INTO ckb_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","ژنەکانم و منداڵەکانیشم بدە دەستم کە لە پێناویاندا خزمەتم کردوویت، ئیتر دەڕۆم. خۆشت دەزانیت چەندە خزمەتم کردوویت.» ");
INSERT INTO ckb_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","بەڵام لابان پێی گوت: «خۆزگە پەسەند دەبووم لەبەرچاوت. فاڵم گرتووەتەوە کە یەزدان لەبەر تۆ بەرەکەتداری کردووم.» ");
INSERT INTO ckb_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","ئینجا گوتی: «کرێی خۆتم بۆ دیاری بکە تاکو پێت بدەم.» ");
INSERT INTO ckb_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","یاقوبیش پێی گوت: «تۆ خۆت دەزانیت چۆن خزمەتم کردوویت و مەڕوماڵاتەکەت لەلای من چۆن بووە، ");
INSERT INTO ckb_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","چونکە پێش هاتنی من ئەوەی هەتبوو کەم بوو، بەڵام دوای هاتنم زۆر زیادی کرد و یەزدانیش بەرەکەتداری کردیت. بەڵام ئێستا کەی کار بۆ ماڵەکەی خۆشم بکەم؟» ");
INSERT INTO ckb_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","ئەویش گوتی: «چیت بدەمێ؟» یاقوبیش گوتی: «هیچم مەدەرێ، بەڵام ئەگەر تەنها ئەم کارەم لەگەڵ بکەیت، ئەوا سەرلەنوێ شوانی و پاسەوانی مەڕەکانت دەکەم. ");
INSERT INTO ckb_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","ئەمڕۆ لێمگەڕێ بەناو هەموو مێگەلەکانتدا تێپەڕم، هەرچی مەڕ و بزنی خاڵدار و بەڵەک و هەرچی بەرخی ڕەش لەناویاندا هەیە جیای دەکەمەوە. ئەوانە کرێیەکەی من دەبن. ");
INSERT INTO ckb_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","سبەینێش ڕاستودروستی من دەسەلمێنێت، کاتێک بۆ کرێیەکەم دێمە پێشت، هەرچی خاڵدار و بەڵەک نەبێت لەناو بزنەکان و ڕەش نەبێت لەناو بەرخەکان، لەلای من بە دزراو دادەنرێت.» ");
INSERT INTO ckb_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","لابانیش گوتی: «باشە، تۆ چۆن دەڵێیت، با وابێت.» ");
INSERT INTO ckb_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","هەر هەمان ڕۆژ هەموو تەگە خەتدار و بەڵەکەکان و هەموو بزنە خاڵدار و بەڵەکەکانی جیا کردەوە، هەموو ئەوانەی سپیێتییان تێدا هەبوو، لەگەڵ هەموو ڕەشەکان لەنێوان بەرخەکان دایە دەست کوڕەکانی. ");
INSERT INTO ckb_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","ئینجا ماوەی سێ ڕۆژە ڕێی خستە نێوان خۆی و یاقوبەوە، لە کاتێکدا یاقوب چاودێری مەڕەکانی دیکەی لابانی دەکرد. ");
INSERT INTO ckb_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","یاقوب چڵی سەوزی لە دار بی و بادەم و چنار هێنا و لە شوێنی هێڵەکان توێکڵەکانیانی پاک کرد و سپیێتییەکەی ژێریانی دەرخست و خەتی سپی لەسەر کێشان. ");
INSERT INTO ckb_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","ئینجا چڵە دارە پاککراوەکانی لەناو ئاخوڕەکانی ئاو خواردنەوە دانا، بە جۆرێک کە کاتێک مەڕەکان بۆ ئاو خواردنەوە دەهاتن، ڕێک لەبەردەمیدا بوو، ئەمەش بۆ ئەوە بوو هەتا لە کاتی هاتنیان بۆ ئاو خواردنەوە بە بەران بێن، ");
INSERT INTO ckb_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","مەڕەکان لەلای چڵەکان بەرانیان گرت و بەرخی خەتدار و خاڵدار و بەڵەکیان بوو. ");
INSERT INTO ckb_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","ئینجا یاقوب بەرخەکانی جیا کردەوە، بەڵام ڕووی مەڕەکانی خۆی لە مەڕە خەتدار و ڕەشەکانی لابان کرد. بەم شێوە بۆ خۆی مێگەلی دانا و لەگەڵ مەڕەکانی لابان داینەنان. ");
INSERT INTO ckb_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","هەر کاتێک مەڕە بەهێزەکان دەهاتنە ئەوەی بەران بگرن، یاقوب لەپێش چاویان چڵە دارەکانی لەناو حەوزەکان دادەنا بۆ ئەوەی لەناو چڵە دارەکاندا بەران بگرن. ");
INSERT INTO ckb_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","بەڵام کاتێک مەڕەکان لاواز دەبوون چڵە دارەکانی دانەدەنا. بەو شێوەیە لاوازەکان بۆ لابان بوون و بەهێزەکانیش بۆ یاقوب. ");
INSERT INTO ckb_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","ئینجا پیاوەکە تەواو دەوڵەمەند بوو. بووە خاوەنی مەڕێکی زۆر، لەگەڵ کەنیزە و خزمەتکار و وشتر و گوێدرێژ. ");
INSERT INTO ckb_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","یاقوب گوێی لە کوڕەکانی لابان بوو کە دەیانگوت: «هەموو ئەوەی هی باوکمان بوو یاقوب بردی و لە ڕێگەی ماڵ و سامانی باوکمانەوە ئەم هەموو سامانەی پێکەوە نا.» ");
INSERT INTO ckb_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","هەروەها یاقوب بینی کە هەڵسوکەوتی لابان بەرامبەری گۆڕاوە و وەک جاران نەماوە. ");
INSERT INTO ckb_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","یەزدان بە یاقوبی فەرموو: «بگەڕێوە بۆ خاکی باوکانت و بۆ لای کەسوکارەکەت، منیش لەگەڵت دەبم.» ");
INSERT INTO ckb_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","یاقوبیش بەدوای ڕاحێل و لێئەدا ناردی کە بێن بۆ لای بۆ ئەو لەوەڕگایەی مەڕوماڵاتەکەی لێیە. ");
INSERT INTO ckb_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","پێی گوتن: «دەبینم باوکتان بەرامبەر بە من گۆڕاوە و وەک جاران نەماوە، بەڵام خودای باوکم لەگەڵ من بووە. ");
INSERT INTO ckb_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","خۆتان دەزانن کە من بە هەموو توانامەوە خزمەتی باوکتانم کردووە، ");
INSERT INTO ckb_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","کەچی باوکتان هەڵیخەڵەتاندم و دە جار کرێیەکەی منی گۆڕی. بەڵام خودا ڕێی پێنەدا کە خراپەم لەگەڵ بکات. ");
INSERT INTO ckb_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","کاتێک دەیگوت: ”بزنە خاڵدارەکان کرێی تۆ دەبن،“ ئەوا هەموو بزنەکان کاریلەی خاڵداریان دەبوو. بەڵام کاتێک ڕای خۆی دەگۆڕی و دەیگوت: ”بزنە خەتدارەکان کرێی تۆ دەبن،“ ئەوا هەموو بزنەکان کاریلەی خەتداریان دەبوو. ");
INSERT INTO ckb_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","خودا مەڕوماڵاتی باوکتانی برد و دایە من. ");
INSERT INTO ckb_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","«لە کاتی پەڕینی ئاژەڵەکاندا خەونێکم دیت کە تێیدا چاوم هەڵبڕی و بینیم کە ئەو تەگانەی کە لە بزنەکان دەپەڕن خەتدار و خاڵدار و بەڵەکن. ");
INSERT INTO ckb_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","فریشتەی خوداش لە خەونەکە پێی فەرمووم: ”یاقوب.“ منیش گوتم: ”ئەوەتام.“ ");
INSERT INTO ckb_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","ئەویش فەرمووی: ”چاو هەڵبڕە و بڕوانە، وا هەموو ئەو تەگانەی لەگەڵ بزنەکان جووت دەبن خەتدار و خاڵدار و بەڵەکن. هەموو ئەوەم بینیوە کە لابان بە تۆی کردووە. ");
INSERT INTO ckb_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","من خودای بێت‌ئێلم، ئەو شوێنەی تێیدا بەردێکت بە ستوونی ڕاگیر کرد و زەیتت بەسەریدا کرد، لەوێ نەزرت بۆ کردم. ئێستاش هەستە و لەم خاکە بڕۆ دەرەوە و بگەڕێوە بۆ خاکی لەدایکبوونەکەت.“» ");
INSERT INTO ckb_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","ئینجا ڕاحێل و لێئە وەڵامیان دایەوە و پێیان گوت: «ئایا لە ماڵی باوکمان بەش و میراتمان هەیە؟ ");
INSERT INTO ckb_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","مەگەر لای ئەو بە بێگانە دانەنراوین؟ نە تەنها ئێمەی فرۆشت، بەڵکو ئەو پارەیەشی خوارد کە پێمان درابوو. ");
INSERT INTO ckb_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","هەموو ئەو سامانەی خودا لە باوکمانی برد بۆ ئێمە و منداڵەکانمانە. ئێستاش هەرچی خودا پێی فەرموویت بیکە.» ");
INSERT INTO ckb_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","ئیتر یاقوب هەستا و منداڵەکانی و ژنەکانی سواری وشترەکان کرد. ");
INSERT INTO ckb_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","هەموو مەڕوماڵات و ئەو شتانەی لە پەدان ئارام دەستی کەوتبوو دایە پێش خۆی و بەرەو خاکی کەنعان بۆ لای ئیسحاقی باوکی کەوتە ڕێ. ");
INSERT INTO ckb_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","کاتێک لابان بۆ بڕینەوەی مەڕەکانی چووبوو، ڕاحێل بتەکانی باوکی دزی. ");
INSERT INTO ckb_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","هەروەها یاقوبیش لابانی ئارامی هەڵخەڵەتاند، چونکە پێی ڕانەگەیاند کە ڕادەکات. ");
INSERT INTO ckb_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","ئیتر بە هەموو ئەو شتانەوە کە هەیبوو هەڵات، لە ڕووباری فورات پەڕییەوە و ڕووی کردە ناوچە شاخاوییەکانی گلعاد. ");
INSERT INTO ckb_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","ڕۆژی سێیەم بە لابان ڕاگەیەنرا کە یاقوب هەڵاتووە. ");
INSERT INTO ckb_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","ئەویش پیاوەکانی لەگەڵ خۆی برد و بۆ ماوەی حەوت ڕۆژ دوای کەوت، هەتا لە ناوچە شاخاوییەکانی گلعاد پێی گەیشتەوە. ");
INSERT INTO ckb_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","خودا لە شەودا هاتە خەونی لابانی ئارامی و پێی گوت: «وریا بە! نە بە چاک و نە بە خراپ هیچ بە یاقوب نەڵێیت.» ");
INSERT INTO ckb_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","کاتێک لابان گەیشتە یاقوب، یاقوب لە چیاکە چادرەکەی هەڵدابوو، لابانیش لەگەڵ پیاوەکانی لە ناوچە شاخاوییەکانی گلعاد چادریان هەڵدا. ");
INSERT INTO ckb_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","لابان بە یاقوبی گوت: «ئەمە چییە کردووتە؟ هەڵتخەڵەتاندووم و کچەکانی منیشت وەک ڕاپێچکراو داوەتە پێش خۆت. ");
INSERT INTO ckb_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","بۆچی بەدزییەوە ڕاتکرد و هەڵتخەڵەتاندم؟ بۆچی ئاگادارت نەکردمەوە بۆ ئەوەی بە شادی و گۆرانییەوە، بە دەف و بە قیسارەوە بەڕێت بکەم؟ ");
INSERT INTO ckb_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","تەنانەت ڕێگات پێنەدام کە نەوە و کچەکانم ماچ بکەم. تۆ ڕەفتارێکی گێلانەت کرد. ");
INSERT INTO ckb_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","لە دەسەڵاتمدایە خراپتان پێ بکەم، بەڵام خودای باوکتان دوێنێ پێی گوتم: ”وریابە! نە بە چاک و نە بە خراپ هیچ بە یاقوب نەڵێیت.“ ");
INSERT INTO ckb_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","ئێستاش وا ڕۆیشتی، چونکە تامەزرۆی ماڵی باوکتی، بەڵام بۆچی بتەکانی منت دزی؟» ");
INSERT INTO ckb_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","یاقوبیش وەڵامی دایەوە و بە لابانی گوت: «ترسام نەوەک بە زۆرەملێ کچەکانتم لێ بستێنیتەوە. ");
INSERT INTO ckb_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","بەڵام ئەوەی کە بتەکانتی لەلا دەبینیتەوە، نابێت بژیێت. لەبەردەم کەسوکاریشماندا ببینە چی تۆم لەلایە، بیبە بۆ خۆت.» بەڵام یاقوب نەیدەزانی کە ڕاحێل بتەکانی دزیوە. ");
INSERT INTO ckb_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","ئیتر لابان چووە ناو هەر یەک لە چادرەکانی یاقوب و لێئە و هەردوو کەنیزەکەوە، بەڵام هیچی نەدۆزییەوە. ئینجا لە چادرەکەی لێئە هاتە دەرەوە و چووە ناو چادرەکەی ڕاحێل. ");
INSERT INTO ckb_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","ڕاحێل بتەکانی بردبوو و خستبوویە ناو کورتانی وشترەکەوە و لەسەریان دانیشتبوو. لابان بە تەواوی ناو چادرەکەی پشکنی، بەڵام هیچی نەدۆزییەوە. ");
INSERT INTO ckb_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","ڕاحێل بە باوکی گوت: «گەورەم، تووڕە مەبە کە ناتوانم لەبەردەمت هەستم، چونکە خوێنلێچوونی ژنان و سووڕی مانگانەم هەیە.» ئەویش پشکنینی خۆی کرد، بەڵام بتەکانی نەدۆزییەوە. ");
INSERT INTO ckb_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","یاقوب تووڕە بوو، بۆیە بەگژ لاباندا چوو و پێی گوت: «تاوانم چییە؟ چ گوناهێکم کردووە کە ئاوا گڕت گرت و بەدوامدا هاتیت؟ ");
INSERT INTO ckb_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","ئەوا هەموو شتەکانم گەڕایت، چ شتێکی ماڵەکەی خۆتت تێدا دۆزییەوە؟ ئا لێرە بیخەرە بەردەم پیاوەکانم و پیاوەکانت، با ئەوان دادوەری نێوان هەردووکمان بکەن. ");
INSERT INTO ckb_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","«ئەوە بیست ساڵە من لەگەڵ تۆم، نە مەڕەکانت بەریان خست، نە بزنەکانیشت، نە منیش لە بەرانی مێگەلەکەی تۆم خوارد. ");
INSERT INTO ckb_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","ئەوانەی دەبوونە نێچیری ئاژەڵ بۆم نەدەهێنایتەوە، بەڵکو لەسەر من دەکەوتن. لە منت داوا دەکردەوە، ئەگەر بە ڕۆژ بدزرابوونایە یان بە شەو. ");
INSERT INTO ckb_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","بە ڕۆژ گەرما دەیخواردم و بە شەویش سەرما. خەویش لە چاوم بڕابوو. ");
INSERT INTO ckb_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","ئەوا بیست ساڵە لە ماڵەکەی تۆم، چواردە ساڵ لەبری دوو کچەکەت خزمەتم بۆ کردیت و شەش ساڵیش لەبری مەڕەکانت، دە جاریش کرێیەکەی منت گۆڕی. ");
INSERT INTO ckb_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","ئەگەر خوداکەی باوکم، خودای ئیبراهیم و ئەوەی ئیسحاق لێی دەترسا لەگەڵ من نەبووایە، ئەوا بە دڵنیاییەوە بە دەستی بەتاڵ بەڕێت دەکردم. بەڵام خودا ڕوانییە ڕەنجکێشیم و ماندووبوونی دەستم، دوێنێ شەو سەرزەنشتی کردیت.» ");
INSERT INTO ckb_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","لابانیش وەڵامی یاقوبی دایەوە و گوتی: «کچەکان کچی خۆمن و منداڵەکانیشیان منداڵی خۆمن، مەڕەکانیش مەڕی خۆمن، هەرچییەکیش تۆ دەیبینیت هی منە. بەڵام ئەمڕۆ چی بکەم لە کچەکانم و لەو منداڵانەی بوویانە؟ ");
INSERT INTO ckb_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","ئێستاش وەرە با من و تۆ پەیمانێک ببەستین تاکو ببێتە شایەتییەک لەنێوانماندا.» ");
INSERT INTO ckb_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","یاقوبیش بەردێکی هێنا و بە ستوونی داینا. ");
INSERT INTO ckb_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","ئینجا یاقوب بە پیاوەکانی خۆی گوت: «بەرد کۆبکەنەوە.» ئەوانیش بەردیان هێنا و کەڵەکەیان کرد و لە تەنیشت کەڵەکە بەردەکە نانیان خوارد. ");
INSERT INTO ckb_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","لابان ئەوێی ناو نا «یەگەر ساهەدوتا»، یاقوبیش ناوی لێنا گەلعید. ");
INSERT INTO ckb_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","لابان گوتی: «ئەمڕۆ ئەم کۆمەڵە بەردە شایەتی نێوان من و تۆن.» بۆیە ناونرا گەلعید. ");
INSERT INTO ckb_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","هەروەها ناویش نرا میچپا، چونکە لابان گوتی: «با یەزدان چاودێری نێوان من و تۆ بکات، کاتێک لەبەرچاوی یەکتر ون دەبین. ");
INSERT INTO ckb_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","ئەگەر بەدڕەفتاری لەگەڵ کچەکانم بکەیت یان ژنیان بەسەربهێنیت، هەرچەندە کەسمان لەگەڵ نییە، بەڵام خودا شایەتی نێوان من و تۆیە.» ");
INSERT INTO ckb_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","هەروەها لابان بە یاقوبی گوت: «تەماشای ئەم کۆمەڵە بەرد و ستوونە بکە کە لەنێوان خۆم و خۆت دامنا. ");
INSERT INTO ckb_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","ئەم کەڵەکە بەرد و ستوونە شایەتن کە من لەم کەڵەکە بەردە تێناپەڕم بۆ ئەوەی خراپەت لەگەڵ بکەم، تۆش لەم کەڵەکە بەرد و ستوونە تێناپەڕیت بۆ ئەوەی خراپەم لەگەڵ بکەیت. ");
INSERT INTO ckb_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","با خودای ئیبراهیم و ناحۆر و باوکیان دادوەری لەنێوانمان بکات.» ئیتر یاقوب بە ناوی ئەو خودایە سوێندی خوارد کە ئیسحاقی باوکی لێی دەترسا. ");
INSERT INTO ckb_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","ئینجا یاقوب لەو ناوچە شاخاوییەدا قوربانی سەربڕی و کەسوکاری بانگهێشتی نانخواردن کرد. ئەوانیش نانیان خوارد و لە کێوەکە شەویان بەسەربرد. ");
INSERT INTO ckb_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","لابان بەرەبەیان لە خەو هەستا و کچەزاکانی و کچەکانی ماچکرد و داوای بەرەکەتی بۆ کردن. ئیتر لابان بەرەو شوێنی خۆی گەڕایەوە. ");
INSERT INTO ckb_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","یاقوبیش بە ڕێگای خۆیدا ڕۆیشت و فریشتەکانی خودا بەرەوپیری هاتن. ");
INSERT INTO ckb_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","کاتێک یاقوب ئەوانی بینی، گوتی: «ئەمە لەشکری خودایە.» ئیتر ئەو شوێنەی ناو نا مەحەنەیم. ");
INSERT INTO ckb_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","یاقوب لەپێش خۆیەوە نێردراوی ناردە لای عیسۆی برای بۆ خاکی سێعیر لە وڵاتی ئەدۆم. ");
INSERT INTO ckb_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","فەرمانی پێدان و گوتی: «ئاوا بە عیسۆی گەورەم ڕادەگەیەنن: ”یاقوبی خزمەتکارت دەڵێت ئاوارەی لای لابان بووم و هەتا ئێستاش لەلای ئەو نیشتەجێ بووم. ");
INSERT INTO ckb_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","بووشم بە خاوەنی گا و گوێدرێژ، مەڕ و بزن، خزمەتکار و کەنیزە. ئەوا ناردیشمە لای گەورەی خۆم هەتا پێی ڕابگەیەنم، بۆ ئەوەی لەبەرچاوی تۆ پەسەند بم.“» ");
INSERT INTO ckb_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","نێردراوەکان گەڕانەوە لای یاقوب و گوتیان: «چووینە لای عیسۆی برات. وا بە چوار سەد پیاوەوە دێت بۆ لات.» ");
INSERT INTO ckb_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","بەمە یاقوب ترسێکی گەورەی لێ نیشت و پەرێشان بوو. ئەو کەسانەی لەگەڵی بوون لەگەڵ مەڕ و مانگا و وشترەکان دابەشی کردن بۆ دوو لەشکر. ");
INSERT INTO ckb_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","گوتی: «ئەگەر عیسۆ هاتە سەر لەشکرێکیان و لێیدا، ئەوا لەشکرەکەی دیکە دەمێنێتەوە بۆ دەربازبوون.» ");
INSERT INTO ckb_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","ئینجا یاقوب لە خودا پاڕایەوە و گوتی: «ئەی خودای ئیبراهیم و ئیسحاقی باوکم، ئەو یەزدانەی کە پێی فەرمووم: ”بگەڕێوە خاکی خۆت و بۆ لای کەسوکارەکەت، باش دەبم لەگەڵت.“ ");
INSERT INTO ckb_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","من شایستەی ئەو هەمووە خۆشەویستییە نەگۆڕ و دڵسۆزییە نیم کە لەگەڵ خزمەتکارەکەی خۆتدا کردووتە. بە خۆم و گۆچانەکەمەوە لەم ڕووباری ئوردونە پەڕیمەوە، بەڵام ئێستا بوومەتە دوو لەشکر. ");
INSERT INTO ckb_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","لە چنگی عیسۆی برام فریام بکەوە، چونکە دەترسم بێت و هێرش بکاتە سەر من و دایک و منداڵەکان. ");
INSERT INTO ckb_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","بەڵام تۆ خۆت فەرمووت: ”باش دەبم لەگەڵت و نەوەکەت وەک لمی دەریا لێ دەکەم، کە لەبەر زۆری لە ژماردن نەیێت.“» ");
INSERT INTO ckb_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","ئیتر ئەو شەوەی لەوێ بەسەربرد، لەوەشی لەگەڵ دەستی خۆیدا هێنابووی، ئەم دیارییانەی بۆ عیسۆی برای هەڵبژارد: ");
INSERT INTO ckb_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","دوو سەد بزن و بیست تەگە، دوو سەد مەڕ و بیست بەران، ");
INSERT INTO ckb_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","سی وشتری مێی شیردەر بە بەچکەکانیانەوە، چل مانگا و دە گا لەگەڵ بیست ماکەر و دە نێرەکەر. ");
INSERT INTO ckb_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","هەموو ئەمانەی مێگەل مێگەل بە جیا دایە دەست خزمەتکارەکانی و پێی گوتن: «پێشم بکەون و بواریش بخەنە نێوان مێگەلەکانەوە.» ");
INSERT INTO ckb_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","فەرمانیشی بەوەی یەکەمیان دا و گوتی: «ئەگەر عیسۆی برام پێت گەیشت و لێی پرسیت: ”سەر بە کێیت و بۆ کوێ دەچیت، ئەوەی لەپێشتەوەیە هی کێیە؟“ ");
INSERT INTO ckb_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","دەڵێیت: ”هی یاقوبی خزمەتکارتن. دیارییە و نێردراوە بۆ عیسۆی گەورەم، خۆی لەدوای ئێمەوە دێت.“» ");
INSERT INTO ckb_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","هەروەها فەرمانی دا بە دووەمیان و سێیەمیان و هەموو ئەوانەی بەدوای مێگەل و گاگەلەکاندا دەڕۆیشتن، پێی گوتن: «ئێوەش کاتێک عیسۆتان بینی، هەمان شتی پێ بڵێن. ");
INSERT INTO ckb_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","هەروەها بیرتان نەچێت بڵێن: ”یاقوبی خزمەتکارت لەدوای ئێمە دێت.“» یاقوب بیری کردەوە و گوتی: «بەم دیارییەی کە لەپێش خۆمەوە دەینێرم ئاشتی دەکەمەوە، دوای ئەمە ڕووبەڕووی دەبمەوە، بەڵکو قبوڵم بکات.» ");
INSERT INTO ckb_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","ئیتر دیارییەکان پێش خۆی کەوتن، بەڵام خۆی ئەو شەوەی لە ئۆردوگاکە بەسەربرد. ");
INSERT INTO ckb_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","یاقوب ئەو شەوە هەستا و هەردوو ژنەکەی و هەردوو کەنیزەکەی و هەر یازدە کوڕەکەی هەڵگرت و لە تەنکاییەکەی ڕووباری یەبۆق پەڕییەوە. ");
INSERT INTO ckb_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","دوای ئەوەی کە ئەوانی لە جۆگەکە پەڕاندەوە، هەموو ئەوەشی کە هەیبوو ناردە ئەوبەرەوە. ");
INSERT INTO ckb_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","ئیتر یاقوب هەر خۆی مایەوە، پیاوێکیش هەتا بەرەبەیان زۆرانبازی لەگەڵ کرد. ");
INSERT INTO ckb_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","کە بینی دەرەقەتی نایەت، لەلای سەرەوەی ئێسکی ڕانی دا و ڕانی یاقوب لە زۆرانبازیەکەدا لەجێ چوو. ");
INSERT INTO ckb_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","ئینجا فەرمووی: «بەرمدە، وا بەرەبەیان دەرکەوت.» بەڵام یاقوب گوتی: «ئەگەر بەرەکەتدارم نەکەیت بەرت نادەم.» ");
INSERT INTO ckb_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","پیاوەکە لێی پرسی: «ناوت چییە؟» یاقوب وەڵامی دایەوە: «یاقوب.» ");
INSERT INTO ckb_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","ئینجا پیاوەکە پێی فەرموو: «لەمەودوا ئیتر ناوت بە یاقوب ناهێنرێت، بەڵکو بە ئیسرائیل، چونکە لەگەڵ خودا و مرۆڤدا تێکۆشایت و سەرکەوتیت.» ");
INSERT INTO ckb_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","یاقوبیش پێی گوت: «تکایە، ناوی خۆتم پێ بڵێ.» بەڵام ئەو فەرمووی: «بۆچی پرسیار لە ناوم دەکەیت؟» ئیتر لەوێ بەرەکەتداری کرد. ");
INSERT INTO ckb_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","ئیتر یاقوب ناوی لەو شوێنە نا پەنیێل، چونکە گوتی: «ڕوو بە ڕوو خودام بینی و گیانیشم دەرباز بوو.» ");
INSERT INTO ckb_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","کاتێک لە پەنیێل دەپەڕییەوە خۆری لێ هەڵهات، لەبەر ڕانی دەشەلی. ");
INSERT INTO ckb_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","هەر لەبەر ئەوەشە کە نەوەی ئیسرائیل هەتا ئەمڕۆش ئەو ماسوولکە ژێیە ناخۆن کە لەلای سەرەوەی ئێسکی ڕانە و گرژ دەبێتەوە، چونکە سەرەوەی ئێسکی ڕانی یاقوب، نزیک لەو ماسوولکە ژێیەی گرژ دەبێتەوە ئازاری پێ گەیشت. ");
INSERT INTO ckb_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","یاقوب چاوی هەڵبڕی و بینی وا عیسۆ و چوار سەد پیاو دێن، ئیتر منداڵەکانی بەسەر لێئە و ڕاحێل و هەردوو کەنیزەکەیدا دابەش کرد. ");
INSERT INTO ckb_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","هەردوو کەنیزەکەی و منداڵەکانیانی خستە پێشەوە، ئینجا لێئە و منداڵەکانی لە پشتیانەوە، ڕاحێل و یوسفیشی خستە دواوە. ");
INSERT INTO ckb_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","خۆیشی پێشیان کەوت و هەتا لە براکەی نزیک بووەوە حەوت جار کڕنۆشی برد. ");
INSERT INTO ckb_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","بەڵام عیسۆ بە ڕاکردن بەرەو ڕووی یاقوب هات و باوەشی پێداکرد، ماچی کرد و پێکەوە گریان. ");
INSERT INTO ckb_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","ئینجا عیسۆ سەری هەڵبڕی و چاوی بە ژن و منداڵەکان کەوت، پرسی: «ئەمانە چی تۆن؟» یاقوبیش گوتی: «ئەو منداڵانەن کە نیعمەتی خودان بۆ خزمەتکارەکەت.» ");
INSERT INTO ckb_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","ئیتر هەردوو کەنیزەکە و منداڵەکانیان هاتنە پێشەوە و کڕنۆشیان برد، ");
INSERT INTO ckb_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","دوای ئەوان لێئە و منداڵەکانی هاتنە پێشەوە و کڕنۆشیان برد، پاشان یوسف و ڕاحێلیش هاتنە پێشەوە و کڕنۆشیان برد. ");
INSERT INTO ckb_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","عیسۆ لە یاقوبی پرسی: «ئەو هەموو مەڕوماڵاتەی پێم گەیشتن بۆ چیت بوو؟» ئەویش گوتی: «بۆ ئەوەی لەبەرچاوت پەسەند بم، گەورەم.» ");
INSERT INTO ckb_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","بەڵام عیسۆ گوتی: «برام من زۆرم هەیە، ئەوەی هەتە بۆ خۆتی هەڵبگرە.» ");
INSERT INTO ckb_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","یاقوب گوتی: «نەخێر، ئەگەر جێی ڕەزامەندیتم، ئەوا دیارییەکەم لێ وەربگرە. ئێستا کە لێم ڕازیت، بینینی ڕووی تۆ وەک بینینی ڕووی خودا وایە. ");
INSERT INTO ckb_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","دیارییەکەشم وەربگرە کە بۆت هێنراوە، خودا لەگەڵم میهرەبان بووە و هەموو شتێکم هەیە.» لەبەر ئەوەی یاقوب پێداگریی کرد، عیسۆ دیارییەکانی قبوڵ کرد. ");
INSERT INTO ckb_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","ئینجا عیسۆ گوتی: «با بکەوینە ڕێ و بڕۆین، خۆشم پێشت دەکەوم.» ");
INSERT INTO ckb_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","بەڵام یاقوب پێی گوت: «گەورەی خۆم دەزانێت کە منداڵەکان ناسکن، ئەو مەڕ و مانگایانەشم کە پێیە شیر دەدەنە بەچکەکانیان. ئەگەر بۆ یەک ڕۆژیش ئاژەڵەکان ماندوو بکەم، ئەوا هەموویان دەمرن. ");
INSERT INTO ckb_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","بۆیە با گەورەم پێش خزمەتکارەکەی بپەڕێتەوە، منیش بەپێی مەڕوماڵاتەکە و منداڵەکان لەسەرخۆ دەکەومە ڕێ، هەتا دەگەمە لای گەورەم لە سێعیر.» ");
INSERT INTO ckb_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","عیسۆش گوتی: «کەوابێت هەندێک لەو خەڵکەی لەگەڵمن لەلات بەجێدەهێڵم.» یاقوبیش گوتی: «ئاخر چ پێویست دەکات؟ هەر ئەوەندەم بەسە جێی ڕەزامەندی گەورەم بم.» ");
INSERT INTO ckb_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","ئیتر هەر ئەو ڕۆژە عیسۆ بە ڕێی خۆیدا گەڕایەوە بۆ سێعیر. ");
INSERT INTO ckb_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","یاقوبیش کەوتە ڕێ بۆ سوکۆت. لەوێ خانووێکی بۆ خۆی بنیاد نا و سایەبانیشی بۆ مەڕوماڵات دروستکرد. هەر لەبەر ئەوەش ئەو شوێنە ناونرا سوکۆت. ");
INSERT INTO ckb_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","دوای هاتنی لە پەدان ئارامەوە، یاقوب بە سەلامەتی گەیشتە شاری شەخەم کە لە خاکی کەنعانە. ئیتر لەبەردەم شارەکە چادری هەڵدا. ");
INSERT INTO ckb_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","ئەو پارچە زەوییەشی کە چادرەکەی تێدا هەڵدا، بە سەد پارچە زیو لە کوڕانی حەمۆری باوکی شەخەمی کڕی. ");
INSERT INTO ckb_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","هەر لەوێش قوربانگایەکی بنیاد نا و ناوی لێنا «ئێل ئێلۆهی ئیسرائیل». ");
INSERT INTO ckb_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","دینەی کچی یاقوب کە لە لێئە بوو، چووە دەرەوە بۆ ئەوەی چاوی بە کچانی ئەو ناوچەیە بکەوێت. ");
INSERT INTO ckb_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","کاتێک شەخەمی کوڕی حەمۆری حیڤی، کە میری ئەو ناوچەیە بوو، چاوی پێی کەوت، گرتی و لاقەی کرد. ");
INSERT INTO ckb_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","دڵیشی چووە سەر دینەی کچی یاقوب، ئەو کچەی خۆشویست و بە نەرمی قسەی لەگەڵ کرد. ");
INSERT INTO ckb_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","شەخەم لەگەڵ حەمۆری باوکی قسەی کرد و پێی گوت: «ئەم کچەم بۆ بخوازە تاکو ببێتە ژنم.» ");
INSERT INTO ckb_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","یاقوب بیستی کە داوێنی دینەی کچی پیسکراوە، لەو کاتەدا کوڕەکانی لەگەڵ مەڕوماڵاتەکەی لە دەشتودەر بوون. ئیتر یاقوبیش هەتا هاتنەوە دەنگی نەکرد. ");
INSERT INTO ckb_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","حەمۆری باوکی شەخەم چووە دەرەوە بۆ لای یاقوب بۆ ئەوەی قسەی لەگەڵ بکات. ");
INSERT INTO ckb_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","کاتێک کوڕەکانی یاقوب بیستیانەوە چی ڕوویداوە، یەکسەر لە دەشتودەر هاتنەوە. زۆر ناڕەحەت و تووڕە بوون، چونکە شەخەم بە لاقەکردنی کچی یاقوب، کارێکی ئابڕووبەرانەی لەگەڵ ئیسرائیل کردبوو؛ کارێکی نەشیاو بوو. ");
INSERT INTO ckb_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","بەڵام حەمۆر قسەی لەگەڵ کردن و گوتی: «شەخەمی کوڕم دڵی بە کچەکەتانەوەیە. تکایە بیدەنێ ببێتە ژنی. ");
INSERT INTO ckb_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","ژن و ژنخوازیمان لەگەڵ بکەن، کچەکانی خۆتانمان بدەنێ و کچەکانی ئێمە بۆ خۆتان ببەن. ");
INSERT INTO ckb_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","دەتوانن لەناومان نیشتەجێ بن؛ خاکەکەمان لەبەردەمتانە. تێیدا نیشتەجێ بن و کڕین و فرۆشتنی تێدا بکەن و موڵکتان تێیدا هەبێت.» ");
INSERT INTO ckb_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","ئینجا شەخەم بە باوک و براکانی دینەی گوت: «لێم ڕازی بن، ئەوەی پێم دەڵێن دەیدەم. ");
INSERT INTO ckb_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","مارەیی و دیارییەکان هەرچەند بێت، ئەوەی داوای بکەن دەیدەم. تەنها کچەکەم بدەنێ با ببێتە ژنم.» ");
INSERT INTO ckb_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","کوڕانی یاقوب بە فێڵبازی وەڵامی شەخەم و حەمۆری باوکیان دایەوە و قسەیان کرد، چونکە داوێنی دینەی خوشکیان پیسکرابوو. ");
INSERT INTO ckb_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","پێیان گوتن: «ئێمە ناتوانین کاری وا بکەین، خوشکەکەی خۆمان بدەینە پیاوێکی خەتەنەنەکراو، چونکە بۆ ئێمە ڕیسواییە. ");
INSERT INTO ckb_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","تەنها بەم مەرجە لەگەڵتان ڕێک دەکەوین: دەبێت وەک ئێمەتان لێبێت، ئەوەش بە خەتەنەکردنی هەموو نێرینەکانتان. ");
INSERT INTO ckb_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","ئیتر کچی خۆمان دەدەینە ئێوە و کچی ئێوەش دەبەین. لەنێویشتان نیشتەجێ دەبین و پێکەوە دەبینە یەک گەل. ");
INSERT INTO ckb_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","بەڵام ئەگەر ئێوە بە قسەتان نەکردین و خۆتان خەتەنە نەکرد، ئەوا کچەکەی خۆمان دەبەین و دەڕۆین.» ");
INSERT INTO ckb_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","قسەکانیان جێگەی پەسەندی حەمۆر و شەخەمی کوڕی بوو. ");
INSERT INTO ckb_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","کوڕە لاوەکە کە لە ماڵی باوکی لە هەمووان ڕێزدارتر بوو، لە ئەنجامدانی کارەکە دوا نەکەوت، چونکە کچەکەی یاقوبی خۆشدەویست. ");
INSERT INTO ckb_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","ئیتر حەمۆر و شەخەمی کوڕی هاتنە بەر دەروازەی شارەکەیان و قسەیان بۆ خەڵکی شارەکەی خۆیان کرد و گوتیان: ");
INSERT INTO ckb_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","«ئەم پیاوانە ئاشتیخوازن لەگەڵمان، با لە خاکەکەمان نیشتەجێ بن و کڕین و فرۆشتنی تێدا بکەن، زەوییەکی پانوبەرین لەبەردەمیانە. کچیان ببنە ژنمان و کچی خۆمانیان دەدەینێ. ");
INSERT INTO ckb_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","بەڵام ئەم پیاوانە تەنها بەو مەرجە لەگەڵمان ڕێک دەکەون کە لەناومان نیشتەجێ بن و وەکو یەک گەل پێکەوە بژین، ئەگەر بێتو هەموو نێرینەکانمان خەتەنە بکرێن، هەروەک چۆن خۆیان خەتەنە کراون. ");
INSERT INTO ckb_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","ئایا ئەگەر لەگەڵیان ڕێک بکەوین و لەنێومان نیشتەجێ بن، ماڵ و سامان و هەموو ئاژەڵ و ماڵاتەکانیان نابن بە هی ئێمە؟» ");
INSERT INTO ckb_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","هەموو ئەوانەی لە دەروازەی شارەکەی هاتنە دەرەوە بە گوێی حەمۆر و شەخەمی کوڕیان کرد. ئیتر هەموو نێرینەیەک لە شارەکە خەتەنە کرا. ");
INSERT INTO ckb_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","لە ڕۆژی سێیەمدا، لە کاتێکدا ئەوان هێشتا ئازاریان مابوو، هەردوو کوڕەکەی یاقوب، شیمۆن و لێڤی، دوو براکەی دینە، دەستیان دایە شمشێرەکانیان و بە نهێنی هێرشیان کردە سەر شارەکە و هەرچی نێرینە هەبوو، کوشتیان. ");
INSERT INTO ckb_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","بە شمشێرەکەیان حەمۆر و شەخەمی کوڕیان کوشت. دینەی خوشکیشیان لە ماڵی شەخەم هەڵگرت و ڕۆیشتن. ");
INSERT INTO ckb_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","ئیتر کوڕانی یاقوب هاتنە سەر کوژراوەکان و شارەکەیان تاڵان کرد، چونکە داوێنی خوشکەکەیانیان پیس کردبوو. ");
INSERT INTO ckb_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","هەرچی مەڕ و مانگا و گوێدرێژیان هەبوو لەگەڵ هەموو ئەو شتانەی لە شار و دەشتودەر هەیانبوو، هەموویان برد. ");
INSERT INTO ckb_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","هەرچی سامانیان هەبوو بە تاڵان بردیان، تێکڕای ژن و منداڵیان ڕاپێچ کرد، هەرچیش لە ماڵەکان بوو بردیان. ");
INSERT INTO ckb_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","ئینجا یاقوب بە شیمۆن و لێڤی گوت: «ئێوە تووشی گۆبەندتان کردم بەوەی کە منتان لەلای کەنعانییەکان و پریزییەکان ناحەز کرد کە خەڵکی ئەم خاکەن. ئێمە ژمارەیەکی کەمین، ئەگەر گەلەکۆمەم لێ بکەن و لێم بدەن، خۆم و ماڵەکەم لەناودەچین.» ");
INSERT INTO ckb_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","بەڵام ئەوان گوتیان: «ئەی دەبێت خوشکەکەمان وەک لەشفرۆشێک هەڵسوکەوتی لەگەڵ بکرێ؟» ");
INSERT INTO ckb_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","ئینجا خودا بە یاقوبی فەرموو: «هەستە و بڕۆ بۆ بێت‌ئێل و لەوێ نیشتەجێ بە. هەر لەوێش قوربانگایەک بۆ خودا دروستبکە، کە بۆت دەرکەوت کاتێک کە لە دەست عیسۆی برات هەڵدەهاتی.» ");
INSERT INTO ckb_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","ئیتر یاقوب بە خاووخێزانەکەی و هەموو ئەوانەی لەگەڵی بوون گوت: «هەموو ئەو خوداوەندە بێگانانە لە خۆتان دابماڵن کە پێتانە، ئینجا خۆتان پاک بکەنەوە و جلەکانیشتان بگۆڕن. ");
INSERT INTO ckb_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","با هەستین و بەرەو بێت‌ئێل سەربکەوین، لەوێ قوربانگایەک بۆ خودا دروستدەکەم کە لە ڕۆژی تەنگانەمدا بە دەنگمەوە هات و لەو ڕێگایەی گرتبوومە بەر لەگەڵم بوو.» ");
INSERT INTO ckb_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","ئەوانیش هەموو ئەو خوداوەندە بێگانانەی کە پێیان بوو لەگەڵ گوارەکانی گوێچکەیان دایانە یاقوب، یاقوبیش لەژێر دار بەڕووەکە کە لەلای شەخەمە لەژێر گڵ شاردییەوە. ");
INSERT INTO ckb_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","ئینجا بەڕێکەوتن و ترسی خوداش باڵی کێشا بەسەر شارۆچکەکانی دەوروبەریان، ئیتر کەس دوای کوڕانی یاقوب نەکەوت. ");
INSERT INTO ckb_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","یاقوب خۆی و هەموو ئەو خەڵکەی لەگەڵی بوو هاتنە لوز کە بێت‌ئێلە لە خاکی کەنعان. ");
INSERT INTO ckb_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","لەوێ قوربانگایەکی بنیاد نا، شوێنەکەشی ناو نا ئێل بێت‌ئێل، چونکە لەو شوێنەدا و لە کاتی هەڵاتنی لەدەست براکەی، خودای بۆ دەرکەوت. ");
INSERT INTO ckb_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","دەڤۆرای دایەنی ڕڤقە مرد، لەژێر دار بەڕووەکەی خوار بێت‌ئێل نێژرا. ئەو شوێنەش ناونرا ئەلۆن باکوت. ");
INSERT INTO ckb_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","کاتێک لە پەدان ئارام گەڕایەوە، دیسان خودا بۆ یاقوب دەرکەوت و بەرەکەتداری کرد. ");
INSERT INTO ckb_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","خودا پێی فەرموو: «ناوت یاقوبە، بەڵام لە ئێستا بەدواوە بە یاقوب ناو نابرێیت، بەڵکو ناوت دەبێتە ئیسرائیل.» ئیتر ناوی لێنا ئیسرائیل. ");
INSERT INTO ckb_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","ئینجا خودا پێی فەرموو: «من خودای هەرە بەتوانام، بەردار بە و زۆر بە. نەتەوەیەک و کۆمەڵێک نەتەوە لە تۆوە دەبن، پاشایانیش لە پشتی تۆوە دەردەچن. ");
INSERT INTO ckb_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","ئەو خاکەش کە دام بە ئیبراهیم و ئیسحاق، هەروەها دەیدەمە تۆ و نەوەکەت لەدوای خۆت.» ");
INSERT INTO ckb_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","ئیتر خودا لەو شوێنە بەرزبووەوە کە قسەی لەگەڵ یاقوب کرد. ");
INSERT INTO ckb_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","یاقوبیش ستوونێکی بەردینی لەو شوێنە ڕاگیر کرد کە خودا قسەی لەگەڵ کردبوو، ئینجا شەرابی پێشکەشکراو و زەیتی بەسەردا کرد. ");
INSERT INTO ckb_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","یاقوب ئەو شوێنەی ناو نا بێت‌ئێل کە تێیدا خودا قسەی لەگەڵدا کرد. ");
INSERT INTO ckb_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","ئینجا هەموویان لە بێت‌ئێلەوە بەڕێکەوتن. کاتێک ماوەیەکی کەمیان مابوو بگەنە ئەفرات، ڕاحێل کەوتە سەر منداڵبوون، منداڵبوونێکی دژوار. ");
INSERT INTO ckb_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","لەبەر ئەوەی منداڵبوونەکەی دژوار بوو، مامانەکە پێی گوت: «مەترسە، چونکە ئەم منداڵەشت کوڕە.» ");
INSERT INTO ckb_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","ئەوە بوو لەگەڵ دواهەناسەی، لەبەر ئەوەی دەمرد، کوڕەکەی ناو نا بەن‌ئۆنی. بەڵام باوکی ناوی لێنا بنیامین. ");
INSERT INTO ckb_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","ئیتر ڕاحێل مرد و لە ڕێی ئەفرات نێژرا کە بێت‌لەحمە. ");
INSERT INTO ckb_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","یاقوب ستوونێکی لەسەر گۆڕەکەی ڕاگیر کرد، کە هەتا ئەمڕۆش ئەوە ستوونی گۆڕەکەی ڕاحێلە. ");
INSERT INTO ckb_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","ئیسرائیل بەڕێکەوتەوە و چادرەکەی لە پشت مگدەل عێدەرەوە هەڵدا. ");
INSERT INTO ckb_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","کاتێک ئیسرائیل لەو ناوچەیەدا دەژیا، ڕەئوبێن چوو لەگەڵ بیلهەی کەنیزەی باوکی سەرجێیی کرد. ئەمەش بەرگوێی ئیسرائیل کەوتەوە. یاقوب دوازدە کوڕی هەبوو: ");
INSERT INTO ckb_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","کوڕەکانی لێئە: ڕەئوبێن، نۆبەرەکەی یاقوب. شیمۆن، لێڤی، یەهودا، یەساخار و زەبولون. ");
INSERT INTO ckb_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","کوڕەکانی ڕاحێل: یوسف و بنیامین ");
INSERT INTO ckb_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","کوڕەکانی بیلهەی کەنیزەی ڕاحێل: دان و نەفتالی. ");
INSERT INTO ckb_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","کوڕەکانی زیلپەی کەنیزەی لێئە: گاد و ئاشێر. ئەمانە کوڕەکانی یاقوبن، کە لە پەدان ئارام لەدایک بوون. ");
INSERT INTO ckb_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","یاقوب هاتە مەمرێ بۆ لای ئیسحاقی باوکی لە نزیک قیریەت ئەربەع، کە حەبرۆنە، ئەو شوێنەی کە ئیبراهیم و ئیسحاق تێیدا ئاوارە بوون. ");
INSERT INTO ckb_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","ئیسحاق سەد و هەشتا ساڵ ژیا. ");
INSERT INTO ckb_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","ئینجا دواهەناسەی دا و مرد، بە پیری و تێر لە ژیان خواردوو چووەوە پاڵ گەلەکەی خۆی. عیسۆ و یاقوبی کوڕی ناشتیان. ");
INSERT INTO ckb_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","ئەمانەش نەوەکانی عیسۆن کە ئەدۆمە. ");
INSERT INTO ckb_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","ئەمانە ژنەکانی عیسۆن کە لە کەنعانییەکانی خواست: عادای کچی ئێلۆنی حیتی و ئۆهۆلیبامەی کە کچی عەنای و کچەزای چیبعۆنی حیڤی بوو، ");
INSERT INTO ckb_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","هەروەها باسمەت کە کچی ئیسماعیل و خوشکی نەبایۆت بوو. ");
INSERT INTO ckb_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","عادا ئەلیفازی بۆ عیسۆ بوو. باسمەتیش ڕەعوئێلی بوو. ");
INSERT INTO ckb_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","ئۆهۆلیبامەش یەعوش و یەعلام و قۆرەحی بوو. ئەمانەن کوڕانی عیسۆ کە لە خاکی کەنعان لەدایک بوون. ");
INSERT INTO ckb_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","ئینجا عیسۆ ژن و کوڕ و کچەکانی هەڵگرت لەگەڵ هەموو کەسانی ماڵەکەی و ئاژەڵی ماڵی و هەموو ئاژەڵەکانی دیکە و هەرچییەکی هەبوو، ئەوەی لە خاکی کەنعان دەستی کەوتبوو، چووە زەوییەکی دیکە، دوور لە یاقوبی برای. ");
INSERT INTO ckb_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","سامانەکەیان ئەوەندە زۆر بوو کە نەتوانن پێکەوە نیشتەجێ بن؛ لەبەر زۆری مەڕوماڵاتیان، ئەو خاکەی تێیدا ئاوارە بوون نەیدەتوانی بیانگرێتە خۆی. ");
INSERT INTO ckb_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","ئیتر عیسۆ کە ئەدۆمە، لە ناوچە شاخاوییەکانی سێعیر نیشتەجێ بوو. ");
INSERT INTO ckb_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","ئەمانە نەوەکانی عیسۆن لە ناوچە شاخاوییەکانی سێعیر کە باوکی ئەدۆمییەکانە: ");
INSERT INTO ckb_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","ئەمانەش ناوی کوڕەکانی عیسۆن: ئەلیفازی کوڕی عادای ژنی عیسۆ و ڕەعوئێلی کوڕی باسمەتی ژنی عیسۆ. ");
INSERT INTO ckb_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","کوڕەکانی ئەلیفاز: تێمان، ئۆمار، چەفۆ، گەعتام و قەنەز. ");
INSERT INTO ckb_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","تیمنەع کەنیزەی ئەلیفازی کوڕی عیسۆ بوو، لە ئەلیفازەوە عەمالێقی بوو. ئەوانە کوڕەزای عادای ژنی عیسۆ بوون. ");
INSERT INTO ckb_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","کوڕەکانی ڕەعوئێل: نەحەت، زەرەح، شەمما و میزا. ئەمانە کوڕەزای باسمەتی ژنی عیسۆ بوون. ");
INSERT INTO ckb_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","ئەمانەش کوڕەکانی ئۆهۆلیبامەی ژنی عیسۆن کە کچی عەنای کوڕی چیبعۆنە و بۆ عیسۆی ببوون: یەعوش، یەعلام و قۆرەح. ");
INSERT INTO ckb_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","ئەمانەش میرانی نەوەی عیسۆن: کوڕانی ئەلیفازی نۆبەرەی عیسۆ: میر تێمان، میر ئۆمار، میر چەفۆ، میر قەنەز، ");
INSERT INTO ckb_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","میر قۆرەح، میر گەعتام و میر عەمالێق. ئەوانە میرانی نەوەی ئەلیفاز لە خاکی ئەدۆم و کوڕەزای عادا بوون. ");
INSERT INTO ckb_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","کوڕەکانی ڕەعوئێلی کوڕی عیسۆ: میر نەحەت، میر زەرەح، میر شەمما و میر میزا. ئەوانە میرانی نەوەی ڕەعوئێل لە خاکی ئەدۆم و کوڕەزای باسمەتی ژنی عیسۆ بوون. ");
INSERT INTO ckb_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","کوڕەکانی ئۆهۆلیبامەی ژنی عیسۆ: میر یەعوش، میر یەعلام و میر قۆرەح. ئەوانە میرانی نەوەی ئۆهۆلیبامەی ژنی عیسۆی کچی عەنا بوون. ");
INSERT INTO ckb_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","ئەوانە بوون کوڕانی عیسۆ کە خۆی ئەدۆمە، ئەوانەش میرەکانیان بوون. ");
INSERT INTO ckb_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","ئەمانەش کوڕەکانی سێعیری حۆرین کە خەڵکی ناوچەکە بوون: لۆتان، شۆڤاڵ، چیبعۆن، عەنا، ");
INSERT INTO ckb_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","دیشۆن، ئێچەر و دیشان. ئەمانەش میرانی حۆرییەکانن، کوڕانی سێعیر لە خاکی ئەدۆم. ");
INSERT INTO ckb_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","کوڕەکانی لۆتان: حۆری و هۆمام. تیمنەعیش خوشکی لۆتان بوو. ");
INSERT INTO ckb_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","کوڕەکانی شۆڤاڵ: عەلڤان، مانەحەت، عێبال، شەفۆ و ئۆنام. ");
INSERT INTO ckb_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","کوڕەکانی چیبعۆن: ئەییا و عەنا. ئەمە ئەو عەنایەیە کە لە چۆڵەوانیدا کانیاوی گەرمی دۆزییەوە، کاتێک خەریکی لەوەڕاندنی گوێدرێژەکانی چیبعۆنی باوکی بوو. ");
INSERT INTO ckb_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","نەوەکانی عەنا: دیشۆن لەگەڵ ئۆهۆلیبامەی کچی عەنا. ");
INSERT INTO ckb_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","کوڕەکانی دیشۆن: حەمدان، ئەشبان، یەتران و کران. ");
INSERT INTO ckb_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","کوڕەکانی ئێچەر: بلهان، زەعەڤان و عەقان. ");
INSERT INTO ckb_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","کوڕەکانی دیشان: عوچ و ئەران. ");
INSERT INTO ckb_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","ئەمانەش میرەکانی حۆرییەکانن: میر لۆتان، میر شۆڤاڵ، میر چیبعۆن، میر عەنا، ");
INSERT INTO ckb_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","میر دیشۆن، میر ئێچەر و میر دیشان. ئەوانە بوون میرانی حۆرییەکان، بەگوێرەی خێڵەکانیان، لە خاکی سێعیر. ");
INSERT INTO ckb_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","ئەمانەش ئەو پاشایانەن کە لە خاکی ئەدۆم پاشایەتییان دەکرد، پێش ئەوەی هیچ پاشایەکی ئیسرائیلی پاشایەتی بکات. ");
INSERT INTO ckb_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","بەلەعی کوڕی بەعۆر بوو بە پاشای ئەدۆم. ناوی شارەکەشی دینهابە بوو. ");
INSERT INTO ckb_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","کە بەلەع مرد، یۆڤاڤی کوڕی زەرەحی خەڵکی بۆزرا وەک پاشا جێگەی گرتەوە. ");
INSERT INTO ckb_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","کە یۆڤاڤ مرد، حوشامی خەڵکی خاکی تێمانییەکان وەک پاشا جێگەی گرتەوە. ");
INSERT INTO ckb_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","کە حوشام مرد، هەدەدی کوڕی بەدەد کە لە وڵاتی مۆئاب شکستی بە میدیان هێنا، وەک پاشا جێگەی گرتەوە. ناوی شارەکەشی عەڤیت بوو. ");
INSERT INTO ckb_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","کە هەدەد مرد، سەمڵەی خەڵکی مەسرێقە وەک پاشا جێگەی گرتەوە. ");
INSERT INTO ckb_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","کە سەمڵە مرد، شائوولی خەڵکی ڕەحۆبۆت، ئەو شارەی لە کەناری ڕووبار بوو، وەک پاشا جێگەی گرتەوە. ");
INSERT INTO ckb_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","کە شائوول مرد، بەعل‌حانانی کوڕی عەکبۆر وەک پاشا جێگەی گرتەوە. ");
INSERT INTO ckb_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","کە بەعل‌حانانی کوڕی عەکبۆر مرد، هەدەد وەک پاشا جێگەی گرتەوە. ناوی شارەکەشی پاعوو بوو، ژنەکەشی ناوی میهێتەبێل بوو، کچی مەترێدی کچی مێزاهاب بوو. ");
INSERT INTO ckb_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","ئەمانەش ناوی میرەکانی نەوەی عیسۆن، بەپێی خێڵ و ناوچە و ناوەکانیان: تیمنەع، عەلڤا، یەتێت، ");
INSERT INTO ckb_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","ئۆهۆلیبامە، ئێلە، پینۆن، ");
INSERT INTO ckb_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","قەنەز، تێمان، میبسار، ");
INSERT INTO ckb_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","مەگدئێل و عیرام. ئەمانە میرەکانی ئەدۆم بوون، بەپێی نشینگەکانیان لە خاکی موڵکی خۆیان. ئەوە عیسۆی باوکی ئەدۆمییەکان بوو. ");
INSERT INTO ckb_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","یاقوب لە خاکی ئاوارەیی باوکی، لە خاکی کەنعان نیشتەجێ بوو. ");
INSERT INTO ckb_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","ئەمە چیرۆکی نەوەکانی یاقوبە. یوسف کە هەرزەکارێکی تەمەن حەڤدە ساڵان بوو، لەگەڵ براکانی کە دەکاتە کوڕەکانی بیلهە و زیلپەی دوو ژنەکەی باوکی، شوانایەتی مەڕەکانی دەکرد. یوسف هەڵسوکەوتە خراپەکانی ئەمانی بە باوکی ڕاگەیاند. ");
INSERT INTO ckb_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","ئیسرائیلیش یوسفی لە هەموو کوڕەکانی دیکەی خۆشتر دەویست، چونکە ئەو منداڵەی لە پیریدا ببوو، کەوایەکی درێژی ڕەنگاوڕەنگیشی بۆ دروستکرد. ");
INSERT INTO ckb_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","کە براکانی بینییان باوکیان ئەوی لە هەموویان خۆشتر دەوێت، ڕقیان لێی دەبووەوە و سڵاویان لێی نەدەکرد. ");
INSERT INTO ckb_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","یوسف خەونێکی بینی و بۆ براکانی گێڕایەوە، ئیتر زیاتر ڕقیان لێی بووەوە. ");
INSERT INTO ckb_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","پێی گوتن: «گوێ لەم خەونە بگرن کە بینیومە: ");
INSERT INTO ckb_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","لە خەونەکەم لەناو کێڵگە خەریکی مەڵۆ کۆکردنەوە بووین، لەناکاو مەڵۆیەکەی من ڕاست بووەوە و وەستا، مەڵۆیەکانی ئێوەش دەوریان دا و کڕنۆشیان بۆ برد.» ");
INSERT INTO ckb_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","براکانی پێیان گوت: «ئایا حەز دەکەیت ببیتە پاشامان؟ ئایا فەرمانڕەوایەتیمان دەکەیت؟» ئیتر لەبەر قسە و خەونەکانی، زیاتر ڕقیان لێ بووەوە. ");
INSERT INTO ckb_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","ئینجا خەونێکی دیکەی بینی و بۆ براکانی گێڕایەوە و گوتی: «گوێ بگرن، خەونێکی دیکەم بینیوە، بینیم خۆر و مانگ و یازدە ئەستێرە کڕنۆشیان بۆم بردووە.» ");
INSERT INTO ckb_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","کە ئەمەی بۆ باوکی و براکانی گێڕایەوە، باوکی سەرزەنشتی کرد و پێی گوت: «ئەمە چ خەونێکە کە تۆ بینیوتە؟ ئایا من و دایکت و براکانت بێین و کڕنۆشت بۆ ببەین؟» ");
INSERT INTO ckb_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","براکانیشی بەغیلییان پێ برد، بەڵام باوکی ئەم شتەی لە دڵی خۆیدا هێشتەوە. ");
INSERT INTO ckb_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","براکانی یوسف بۆ لەوەڕاندنی مەڕەکانی باوکیان، چوون بۆ دەوروبەری شەخەم. ");
INSERT INTO ckb_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","ئیسرائیلیش بە یوسفی گوت: «تۆ دەزانیت کە براکانت لە دەوروبەری شەخەم خەریکی لەوەڕاندنن. وەرە با بتنێرمە لایان.» ئەویش گوتی: «باشە.» ");
INSERT INTO ckb_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","ئینجا پێی گوت: «بڕۆ و بزانە براکانت سەلامەتن و مەڕەکانیش سەلامەتن، ئینجا وەرەوە و هەواڵم بدەرێ.» ئیتر یوسفی لە دۆڵی حەبرۆنەوە نارد. کە یوسف چوو بۆ شەخەم، ");
INSERT INTO ckb_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","پیاوێک بینییەوە و بینی وا لە چۆڵەوانی ون بووە، پرسیاری لێکرد: «ئەوە بەدوای چیدا دەگەڕێیت؟» ");
INSERT INTO ckb_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","ئەویش گوتی: «بەدوای براکانمدا دەگەڕێم. پێم بڵێ لەکوێ خەریکی لەوەڕاندنی مەڕەکانن؟» ");
INSERT INTO ckb_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","پیاوەکەش گوتی: «لێرە ڕۆیشتن، چونکە گوێم لێیان بوو گوتیان: ”با بچینە دوسان.“» یوسفیش بەدوای براکانیدا چوو، ئەوانی لە دوسان بینییەوە. ");
INSERT INTO ckb_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","بەڵام لە دوورەوە بینییان و پێش ئەوەی لێیان نزیک بێتەوە، پیلانیان بۆی دانا بۆ ئەوەی بیکوژن. ");
INSERT INTO ckb_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","ئیتر بە یەکتریان گوت: «وا خاوەنی خەونەکان دێت! ");
INSERT INTO ckb_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","دەی با ئێستا بیکوژین و فڕێیبدەینە یەکێک لەم ئەمباراوانە و دەڵێین گیاندارێکی دڕندە خواردی. ئینجا با ببینین خەونەکانی چییان لێدێت.» ");
INSERT INTO ckb_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","کە ڕەئوبێن گوێی لەمە بوو، هەوڵی دا لە دەستیان ڕزگاری بکات. بۆیە گوتی: «با نەیکوژین!» ");
INSERT INTO ckb_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","ئینجا ڕەئوبێن پێی گوتن: «خوێن مەڕێژن. فڕێیبدەنە ناو ئەم ئەمباراوە کە لە چۆڵەوانییە بەڵام دەستی لێ مەدەن.» ڕەئوبێن ئەمەی گوت بۆ ئەوەی لە دەستیان فریای بکەوێت و بیگەڕێنێتەوە لای باوکی. ");
INSERT INTO ckb_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","ئیتر کە یوسف هاتە لای براکانی، کەوا درێژە ڕەنگینەکەیان لەبەری دادڕاند، ");
INSERT INTO ckb_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","ئینجا بردیان و فڕێیاندایە ناو ئەمباراوەکە، کە بەتاڵ بوو و ئاوی تێدا نەبوو. ");
INSERT INTO ckb_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","دوای ئەوەی کە دانیشتن بۆ نانخواردن، چاویان هەڵبڕی و بینییان وا کاروانی ئیسماعیلییەکان لە گلعادەوە دێت، کە وشترەکانیان باری بەهارات و هەتووان و موڕیان پێیە و بەرەو میسر دەڕۆن. ");
INSERT INTO ckb_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","ئینجا یەهودا بە براکانی گوت: «چ سوودێکی هەیە براکەی خۆمان بکوژین و خوێنەکەی بشارینەوە؟ ");
INSERT INTO ckb_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","وەرن با بە ئیسماعیلییەکانی بفرۆشین و دەستی لێ نەدەین، چونکە برامانە و لە گۆشت و خوێنمانە.» براکانیشی بە قسەیان کرد. ");
INSERT INTO ckb_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","کاتێک بازرگانە میدیانییەکان گەیشتن، براکانی یوسفیان لە ئەمباراوەکە هێنایە دەرەوە و بە بیست شاقل زیو بە ئیسماعیلییەکانیان فرۆشت. ئەوانیش یوسفیان بۆ میسر برد. ");
INSERT INTO ckb_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","ئینجا ڕەئوبێن گەڕایەوە لای ئەمباراوەکە و سەیری کرد یوسف لە ئەمباراوەکە نەبوو، ئیتر جلەکانی بەری خۆی دادڕی. ");
INSERT INTO ckb_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","گەڕایەوە لای براکانی و گوتی: «کوڕەکە لەوێ نەماوە! من بۆ کوێ بچم؟» ");
INSERT INTO ckb_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","ئەوانیش گیسکێکیان سەربڕی و کەواکەی یوسفیان هێنا و لە خوێنیان هەڵکێشا. ");
INSERT INTO ckb_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","ئینجا کەوا ڕەنگینەکەیان بۆ باوکیان هێنایەوە و گوتیان: «ئەمەمان دۆزیوەتەوە، لێی وردبەرەوە و بزانە کەوای کوڕەکەتە یان نا؟» ");
INSERT INTO ckb_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","ئەویش لێی ورد بووەوە و گوتی: «کەوای کوڕەکەمە! گیاندارێکی دڕندە خواردوویەتی، یوسفی پارچەپارچە کردووە.» ");
INSERT INTO ckb_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","ئیتر یاقوب جلەکانی بەری خۆی دادڕی و جلوبەرگی گوشی پۆشی و ماوەیەکی زۆر شیوەنی بۆ کوڕەکەی گێڕا. ");
INSERT INTO ckb_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","ئینجا هەموو کوڕ و کچەکانی هەستان چوونە لای بۆ دڵدانەوەی، بەڵام ئەو ڕەتی کردەوە دڵی بدرێتەوە و گوتی: «بە لاواندنەوە دادەبەزمە لای کوڕەکەم بۆ ناو جیهانی مردووان.» ئیتر باوکی دایە پڕمەی گریان بۆی. ");
INSERT INTO ckb_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","هەر لەو ماوەیەدا میدیانییەکان لە میسر یوسفیان فرۆشت بە پۆتی‌فەر، کە کاربەدەستی فیرعەون و سەرۆکی پاسەوانەکان بوو. ");
INSERT INTO ckb_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","یەهودا لەو سەردەمەدا براکانی بەجێهێشت و چوو بۆ لای پیاوێکی عەدولامی کە ناوی حیرە بوو. ");
INSERT INTO ckb_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","لەوێ یەهودا چاوی بە کچی پیاوێکی کەنعانی کەوت بە ناوی شوەع. ئیتر ئەو کچەی خواست و لەگەڵی نوست. ");
INSERT INTO ckb_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","ئەویش سکی پڕ بوو، کوڕێکی بوو ناوی لێنا ئێر. ");
INSERT INTO ckb_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","جارێکی دیکە سکی پڕ بووەوە، کوڕێکی دیکەی بوو ناوی لێنا ئۆنان. ");
INSERT INTO ckb_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","دیسان سکی پڕ بووەوە، کوڕێکی دیکەی بوو ناوی لێنا شالەح. کاتێک یەهودا لە کەزیب بوو، ئەم کوڕەی بوو. ");
INSERT INTO ckb_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","یەهودا ژنێکی بۆ ئێری کوڕە نۆبەرەی خۆی هێنا، ناوی تامار بوو. ");
INSERT INTO ckb_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","بەڵام ئێری کوڕە نۆبەرەی یەهودا لەبەردەم یەزدان بەدکار بوو، یەزدانیش لەناوی برد. ");
INSERT INTO ckb_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","ئینجا یەهودا بە ئۆنانی گوت: «ژنی براکەت بخوازەوە و سەرجێیی لەگەڵ بکە، بە ئەرکی برایەتی هەستە و نەوە بۆ براکەت بخەرەوە.» ");
INSERT INTO ckb_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","بەڵام ئۆنان دەیزانی کە منداڵەکە نابێتە هی خۆی، بۆیە هەر کاتێک سەرجێیی لەگەڵ ژنی براکەی دەکرد، تۆوەکەی خۆی دەڕژاندە سەر زەوی، بۆ ئەوەی نەوە بۆ براکەی نەخاتەوە. ");
INSERT INTO ckb_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","ئەم کردارەی ئەو بەلای یەزدانەوە کارێکی خراپ بوو، ئیتر ئەویشی مراند. ");
INSERT INTO ckb_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","یەهودا بە تاماری بووکی خۆی گوت: «لە ماڵی باوکت بە بێوەژنی دابنیشە، هەتا شالەحی کوڕم گەورە دەبێت.» لەبەر ئەوەی بیری کردەوە و گوتی: «نەوەک ئەمیشیان وەک دوو براکەی بمرێت.» تاماریش چوو لە ماڵی باوکی دانیشت. ");
INSERT INTO ckb_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","دوای ماوەیەکی زۆر کچەکەی شوەع کە ژنی یەهودا بوو مرد. پاش ئەوەی خەم و پەژارەیی لە دڵی یەهودا ڕەوییەوە، لەگەڵ حیرەی عەدولامی چوو بۆ تیمنا، بۆ لای ئەوانەی خوری مەڕەکانیان بۆ دەبڕییەوە. ");
INSERT INTO ckb_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","کاتێک بە تاماریان ڕاگەیاند: «وا خەزوورت هاتووە بۆ تیمنا، بۆ بڕینەوەی خوری مەڕەکانی،» ");
INSERT INTO ckb_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","ئەویش جلوبەرگی بێوەژنیی داکەند و ڕووی خۆی داپۆشی و خۆی پێچایەوە. پاشان لەبەر دەروازەی عێینەیم دانیشت، کە لەسەر ڕێگای تیمنایە، چونکە بینی وا شالەح گەورە بووە، کەچی ئەمیان نەدایێ ببێتە ژنی. ");
INSERT INTO ckb_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","کە یەهودا تاماری بینی، وایزانی لەشفرۆشە، چونکە ڕووی خۆی داپۆشیبوو. ");
INSERT INTO ckb_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","ئیتر لەسەر ڕێگاکە لایدا بەلای ئەودا و پێی گوت: «وەرە با سەرجێییت لەگەڵ بکەم،» چونکە نەیزانی ئەوە بووکەکەیەتی. ئەویش پێی گوت: «چیم پێدەدەیت بۆ ئەوەی سەرجێییم لەگەڵ بکەیت؟» ");
INSERT INTO ckb_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","ئەویش گوتی: «لە ماڵاتەکەم گیسکێکت بۆ دەنێرم.» ئەمیش گوتی: «ئەی شتێکم وەک بارمتە دەدەیتێ هەتا دەینێریت؟» ");
INSERT INTO ckb_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","ئەویش گوتی: «چ بارمتەیەکت بدەمێ؟» ئەمیش گوتی: «مۆر و قەیتان و گۆچانەکەی دەستت.» ئەویش ئەمانەی دایێ و سەرجێیی لەگەڵی کرد، ئیتر سکی لێی پڕبوو. ");
INSERT INTO ckb_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","ئینجا هەستا و ڕۆیشت، ڕووپۆشەکەی لە خۆی کردەوە و جلوبەرگی بێوەژنی لەبەرکردەوە. ");
INSERT INTO ckb_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","هەر لەو ماوەیەدا یەهودا گیسکەکەی بە هاوڕێ عەدولامییەکەیدا نارد بۆ ئەوەی بارمتەکە لە دەست ژنەکە وەربگرێتەوە. بەڵام ئەو نەیبینییەوە. ");
INSERT INTO ckb_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","ئیتر پرسیاری لە خەڵکی ئەو ناوە کرد و گوتی: «ئەرێ ئەو ئافرەتە لەشفرۆشەی لە نزرگە لە کەناری ڕێی عێینەیم بوو لەکوێیە؟» ئەوانیش گوتیان: «ئەم ناوە هیچ ئافرەتێکی لەشفرۆشی لێ نەبووە.» ");
INSERT INTO ckb_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","ئەویش گەڕایەوە لای یەهودا و پێی گوت: «نەمبینییەوە. خەڵکەکەی ئەو ناوەش گوتیان: ”هیچ ئافرەتی لەشفرۆش لەو ناوەدا نییە.“» ");
INSERT INTO ckb_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","یەهوداش گوتی: «با بۆ خۆی هەڵیانبگرێت نەوەک ڕیسوا بین. ئەوەتا ئەم گیسکەم بۆ ناردووە، بەڵام تۆ ئەوت نەبینییەوە.» ");
INSERT INTO ckb_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","نزیکەی سێ مانگ دوای ئەوە بە یەهودا ڕاگەیەنرا و گوترا: «تاماری بووکت لەشفرۆشی کردووە، بەهۆی ئەو لەشفرۆشییەوە سکیشی پڕە.» یەهوداش گوتی: «بیهێننە دەرەوە بۆ ئەوەی بسووتێنرێت!» ");
INSERT INTO ckb_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","ئەوە بوو کە هێنرایە دەرەوە، ناردییە لای خەزووری و گوتی: «سکم لەو پیاوە پڕە کە خاوەنی ئەمانەیە.» هەروەها گوتی: «وردبەرەوە و بزانە ئەم مۆر و قەیتان و گۆچانە هی کێیە؟» ");
INSERT INTO ckb_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","یەهوداش ئەوانی ناسییەوە و گوتی: «ئەو لە من ڕاستودروستترە، لەبەر ئەوەی نەمداوە بە شالەحی کوڕم.» دوای ئەمە ئیتر سەرجێیی لەگەڵی نەکردەوە. ");
INSERT INTO ckb_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","کە هاتە سەر منداڵبوون، دووانەیەک لە سکی بوو. ");
INSERT INTO ckb_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","لە کاتی منداڵبوونی یەکێکیان دەستی هێنایە دەرەوە، مامانەکەش دەزووێکی سووری لە دەستی بەست و گوتی: «ئەمەیان یەکەم جار هاتە دەرەوە.» ");
INSERT INTO ckb_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","بەڵام کە دەستی کێشایەوە دواوە، براکەی هاتە دەرەوە، مامانەکەش گوتی: «ئەوە بۆ هەڵتکوتا، دەک هەڵبکوترێتە سەرت!» ئەمەیان ناونرا پێرێز. ");
INSERT INTO ckb_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","لەدوای براکەی، کە دەزووە سوورەکە بە دەستییەوە بوو، هاتە دەرەوە. ئەمەشیان ناونرا زەرەح. ");
INSERT INTO ckb_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","یوسف بەرەو خوار بردرا بۆ میسر. لەوێ پیاوێکی میسری بە ناوی پۆتی‌فەر کە کاربەدەستی فیرعەون و سەرۆکی پاسەوانەکانی بوو، لە ئیسماعیلییەکانی کڕی کە هێنابوویان بۆ میسر. ");
INSERT INTO ckb_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","یەزدان لەگەڵ یوسف بوو، بۆیە بووە پیاوێکی سەرکەوتوو. ئەو لە ماڵی گەورە میسرییەکەیدا دەژیا. ");
INSERT INTO ckb_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","کاتێک گەورەکەی بینی کە یەزدانی لەگەڵدایە و دەست بداتە هەر کارێکیش یەزدان سەرکەوتووی دەکات، ");
INSERT INTO ckb_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","یوسف لەبەرچاوی پەسەند بوو و خزمەتی کرد. پۆتی‌فەریش کردی بە گەورە لێپرسراوی ماڵەکەی و هەرچییەکی هەبوو دایە دەست ئەم. ");
INSERT INTO ckb_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","ئیتر لەو کاتەوە کە ئەمی کرد بە گەورە لێپرسراوی ماڵەکەی و هەرچی کە هەیبوو، یەزدان لەبەر یوسف ماڵی ئەو میسرییەی بەرەکەتدار کرد. بەرەکەتەکەی یەزدانیش بۆ هەموو ئەو شتانە بوو کە هی پۆتی‌فەر بوو، چ لەناو ماڵەکەی و چ لە دەشتودەر. ");
INSERT INTO ckb_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","ئیتر هەرچییەکی هەبوو بۆ یوسفی بەجێهێشت، ئاگاداری هیچی خۆشی نەبوو، تەنها ئەو نانە نەبێت کە دەیخوارد. یوسفیش ڕوخسار جوان و بەژن ڕێک بوو. ");
INSERT INTO ckb_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","دوای ماوەیەک ژنی گەورەکەی چاوی بڕییە یوسف و پێی گوت: «وەرە سەرجێییم لەگەڵ بکە.» ");
INSERT INTO ckb_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","بەڵام ئەو ڕەتی کردەوە و بە ژنی گەورەکەی گوت: «تەماشا بکە، گەورەم ئاگای لە هیچ شتێکی ماڵەکەی نییە، هەرچییەکیشی هەیە بە منی سپاردووە. ");
INSERT INTO ckb_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","کەسیش لە ماڵەکەدا لە من گەورەتر نییە. هیچیشی لێ قەدەغە نەکردووم، تەنها تۆ نەبێت، چونکە تۆ ژنی ئەویت. ئیتر چۆن دەبێت بەدکارییەکی ئاوا گەورە بکەم و گوناه بەرامبەر بە خودا بکەم؟» ");
INSERT INTO ckb_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","هەرچەندە ڕۆژانە ئەم داوایەی لە یوسف دەکرد، بەڵام ئەو ڕەتی دەکردەوە کە لەگەڵی سەرجێیی بکات یان لەگەڵی بێت. ");
INSERT INTO ckb_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","ڕۆژێکیان یوسف بۆ ئەنجامدانی کارەکانی هاتە ناو ماڵەکە، لەکاتێکدا هیچ کام لە خزمەتکاران لە ماڵ نەبوون. ");
INSERT INTO ckb_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","ژنەکە کەواکەی یوسفی گرت و گوتی: «سەرجێییم لەگەڵ بکە!» بەڵام یوسف کەواکەی لە دەستی ئەو بەجێهێشت و هەڵات و چووە دەرەوە. ");
INSERT INTO ckb_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","کە بینی وا کەواکەی لە دەستی ئەم بەجێهێشت و هەڵاتە دەرەوە، ");
INSERT INTO ckb_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","بانگی کەسانی ماڵەکەی کرد و پێی گوتن: «سەیر بکەن، پیاوێکی عیبرانی بۆ هێناوین دەستبازیمان لەگەڵ بکات. بۆم هاتووەتە ژوورەوە هەتا لاقەم بکات، بەڵام من بە دەنگی بەرز قیژاندم. ");
INSERT INTO ckb_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","ئیتر کە گوێی لێبوو دەنگم هەڵبڕی و قیژاندم، کەواکەی لەلام بەجێهێشت و هەڵات و چووە دەرەوە.» ");
INSERT INTO ckb_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","کەواکەی ئەوی لەلای خۆی دانا هەتا گەورەکەی گەڕایەوە ماڵەوە. ");
INSERT INTO ckb_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","ئیتر هەمان قسەی بۆ ئەویش گێڕایەوە و پێی گوت: «ئەو خزمەتکارە عیبرانییەی کە تۆ بۆت هێناین، بۆم هاتە ژوورەوە بۆ ئەوەی دەستبازیم لەگەڵ بکات. ");
INSERT INTO ckb_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","بەڵام کە دەنگم هەڵبڕی و قیژاندم، کەواکەی لەلام بەجێهێشت و هەڵاتە دەرەوە.» ");
INSERT INTO ckb_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","کاتێک گەورەکەی ئەو قسەیەی لە ژنەکەی خۆی بیست کە پێی گوت: «خزمەتکارەکەت ئاوای پێکردم،» تووڕەیی جۆشا. ");
INSERT INTO ckb_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","ئینجا گەورەکەی یوسفی هێنا و خستییە زیندانەوە، ئەو شوێنەی زیندانییەکانی پاشای لێ بەند کرابوون. ئیتر لەوێ لە زیندان مایەوە. ");
INSERT INTO ckb_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","بەڵام یەزدان لەگەڵ یوسف بوو و خۆشەویستییە نەگۆڕەکەی خۆی بەسەردا کێشا و لەبەرچاو کارگێڕی زیندانەکە پەسەندی کرد. ");
INSERT INTO ckb_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","ئیتر کارگێڕی زیندانەکە هەموو ئەو زیندانییانەی خستە ژێر دەستی یوسف کە لە زیندانەکەدا بوون، کردیشی بە لێپرسراوی هەموو کارەکانی ئەوێ. ");
INSERT INTO ckb_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","کارگێڕی زیندانەکەش سەیری هیچ شتێکی نەدەکرد کە بە دەست یوسف بووایە، چونکە یەزدان لەگەڵ یوسف بوو و هەموو کارەکانیشی سەردەخست. ");
INSERT INTO ckb_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","دوای ماوەیەک ساقیی پاشای میسر و نانەواکەی هەڵەیان بەرامبەر بە پاشای میسری گەورەیان کرد. ");
INSERT INTO ckb_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","جا فیرعەون لە دوو کاربەدەستەکەی، واتا لە سەرۆکی ساقییەکان و سەرۆکی نانەواکان تووڕە بوو. ");
INSERT INTO ckb_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","ئیتر هەردووکیانی خستە ئەو زیندانەی کە لەناو ماڵی سەرۆکی پاسەوانەکان بوو، هەمان ئەو شوێنەی کە یوسفی تێدا زیندانی کرابوو. ");
INSERT INTO ckb_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","سەرۆکی پاسەوانەکانیش کاروباری ئەوانی بە یوسف سپارد، ئەویش خزمەتی کردن. ئیتر ماوەیەک لە زیندانەکەدا مانەوە. ");
INSERT INTO ckb_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","ئینجا ساقیی پاشای میسر و نانەواکەی کە زیندانی کرابوون، هەردووکیان لە یەک شەودا خەونیان بینی. خەوی هەریەکەیان لێکدانەوەیەکی تایبەت بە خۆی هەبوو. ");
INSERT INTO ckb_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","کاتێک بەیانی یوسف هاتە لایان، هەردووکیانی بە ماتومەلوولی بینی. ");
INSERT INTO ckb_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","ئەویش پرسیاری لە هەردوو کاربەدەستەکەی فیرعەون کرد کە لەگەڵ خۆی لە زیندانی ماڵی گەورەکەیدان، گوتی: «بۆچی ئەمڕۆ ڕووتان خەمگینە؟» ");
INSERT INTO ckb_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","وەڵامیان دایەوە: «هەردووکمان خەونمان بینیوە، بەڵام کەس نییە بۆمان لێکبداتەوە.» یوسفیش پێی گوتن: «ئایا لێکدانەوە هی خودا نییە؟ خەونەکانتانم بۆ بگێڕنەوە.» ");
INSERT INTO ckb_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","سەرۆکی ساقییەکان خەونەکەی بۆ یوسف گێڕایەوە و گوتی: «لە خەونمدا دار مێوێک لەبەردەمم بوو. ");
INSERT INTO ckb_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","سێ چڵ بە دار مێوەکەوە بوو، هەرکە چرۆیان کرد، گوڵیان گرت و هێشووەکانیان پێگەیشتن و بوونە ترێ. ");
INSERT INTO ckb_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","جامەکەی فیرعەونیشم بەدەستەوە بوو، ترێیەکەم هێنا و گوشیمە ناو جامەکەی فیرعەون و جامەکەم دایە دەستی.» ");
INSERT INTO ckb_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","یوسفیش پێی گوت: «ئەمە لێکدانەوەکەیەتی: سێ چڵەکە سێ ڕۆژن. ");
INSERT INTO ckb_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","لە ماوەی سێ ڕۆژیشدا، فیرعەون سەرت بەرز دەکات و دەتگەڕێنێتەوە شوێنەکەی خۆت. جامەکەی فیرعەونیش دەدەیتەوە دەست خۆی، هەروەک جاری جاران کە ساقی بوویت. ");
INSERT INTO ckb_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","بەڵام کاتێک هەموو شتێکت بە باشی بەرەو پێش چوو، منت بێتەوە یاد، چاکەیەکم لەگەڵ بکە و لەلای فیرعەون ناوم بهێنە و لەم زیندانە دەرمبهێنە. ");
INSERT INTO ckb_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","من لە خاکی عیبرانییەکانەوە دزراوم و لێرەش بێ ئەوەی هیچم کردبێت خراومەتە زیندانەوە.» ");
INSERT INTO ckb_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","کە سەرۆکی نانەواکان بینی باشی لێکدایەوە، بە یوسفی گوت: «منیش لە خەونمدا سێ سەبەتە نانی سپی لەسەر سەرم بوو. ");
INSERT INTO ckb_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","سەبەتەکەی سەرەوەیان هەموو جۆرە خواردنێکی فیرعەونی تێدابوو لەوانەی نانەوا دروستیان دەکات، بەڵام باڵندەکان لەسەر سەبەتەکەی سەر سەرمەوە دەیانخوارد.» ");
INSERT INTO ckb_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","یوسفیش وەڵامی دایەوە: «ئەمە لێکدانەوەکەیەتی: سێ سەبەتەکە سێ ڕۆژن. ");
INSERT INTO ckb_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","لە ماوەی سێ ڕۆژیشدا، فیرعەون سەرت لێدەکاتەوە و تەرمەکەت لە داردا دەدات و باڵندەش گۆشتەکەت دەخۆن.» ");
INSERT INTO ckb_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","ئەوە بوو لە ڕۆژی سێیەم کە ڕۆژی لەدایکبوونی فیرعەون بوو، فیرعەون خوانێکی بۆ هەموو دەستوپێوەندەکانی سازکرد. سەری سەرۆکی ساقییەکان و سەری سەرۆکی نانەواکانی لەنێو دەستوپێوەندەکانی بڵند کرد. ");
INSERT INTO ckb_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","سەرۆکی ساقییەکانی گەڕاندەوە بۆ مەیگێڕییەکەی خۆی، ئەویش جامی دایەوە دەستی فیرعەون. ");
INSERT INTO ckb_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","بەڵام سەرۆکی نانەواکانی لە دار دا، وەک چۆن یوسف بۆی لێکدابوونەوە. ");
INSERT INTO ckb_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","سەرۆکی ساقییەکانیش یوسفی بیر نەکەوتەوە، بەڵکو لە یادی کرد. ");
INSERT INTO ckb_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","ئەوە بوو لەدوای دوو ساڵ، فیرعەون خەونی بینی، کە لەلای ڕووباری نیل ڕاوەستاوە، ");
INSERT INTO ckb_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","لە ڕووبارەکەوە حەوت مانگای جوان و گۆشتن هاتنە دەرەوە و لە مێرگەکەدا کەوتنە لەوەڕان. ");
INSERT INTO ckb_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","لەدوای ئەوان حەوت مانگای دیکەی لەڕولاواز و ناشیرین لە ڕووبارەکە هاتنە دەرەوە و لەلای ئەو مانگایانە لە کەناری ڕووبارەکە ڕاوەستان. ");
INSERT INTO ckb_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","ئینجا مانگا لەڕولاواز و ناشیرینەکان حەوت مانگا جوان و گۆشتنەکانیان خوارد. فیرعەون بە ئاگا هاتەوە. ");
INSERT INTO ckb_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","لەدوای ئەوە نوستەوە و دیسان خەونی بینییەوە. لە خەونیدا حەوت گوڵەگەنمی قەڵەو و جوانی بینی کە لە لاسکێکەوە دەرهاتوون. ");
INSERT INTO ckb_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","لەدوای ئەمانەوە حەوت گوڵەگەنمی باریک و سووتاو بە بای ڕۆژهەڵات ڕواون. ");
INSERT INTO ckb_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","ئینجا گوڵەگەنمە باریکەکان حەوت گوڵەگەنمە قەڵەو و پڕەکانیان قووت دا. ئیتر فیرعەون بەئاگا هاتەوە و زانی کە خەونە. ");
INSERT INTO ckb_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","بۆ بەیانییەکەی فیرعەون دڵگران بوو، ئیتر ناردی بەدوای هەموو جادووگەران و دانایانی میسردا و خەونەکەی خۆی بۆ گێڕانەوە، بەڵام هیچیان نەیانتوانی بۆی لێکبدەنەوە. ");
INSERT INTO ckb_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","ئینجا سەرۆکی ساقییەکان قسەی لەگەڵ فیرعەون کرد و گوتی: «من ئەمڕۆ هەڵەکانی خۆم دێتەوە یاد. ");
INSERT INTO ckb_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","جارێک فیرعەون لە دوو خزمەتکارەکەی خۆی تووڕە بوو، من و سەرۆکی نانەواکانی خستە زیندانی ماڵی سەرۆکی پاسەوانەکان. ");
INSERT INTO ckb_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","من و ئەو لە یەک شەودا خەونمان بینی، خەونی هەریەکەمان لێکدانەوەیەکی جیاوازی هەبوو لەگەڵ ئەوی دیکەمان. ");
INSERT INTO ckb_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","لەوێش کوڕێکی عیبرانیمان لەگەڵ بوو کە خزمەتکاری سەرۆکی پاسەوانەکان بوو. خەونەکانمان بۆ ئەو گێڕایەوە، ئەویش هەردوو خەونەکەی بۆ لێکداینەوە. ");
INSERT INTO ckb_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","ئیتر ئەو چۆنی بۆ لێکداینەوە ئاوا ڕوویدا. ئەوە بوو من گەڕامەوە شوێنەکەی خۆم و ئەویش کوژرا.» ");
INSERT INTO ckb_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","بۆیە فیرعەون ناردی بەدوای یوسفدا و خێرا لە زیندانەوە هێنایان. لەدوای ئەوەی تراشی کرد و جلەکانی گۆڕی، هاتە بەردەم فیرعەون. ");
INSERT INTO ckb_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","فیرعەون بە یوسفی گوت: «خەونێکم بینیوە و کەس نییە لێکی بداتەوە. هەروەها دەربارەی تۆ بیستوومە کە کاتێک خەونێکت بۆ دەگێڕنەوە، دەتوانیت لێکی بدەیتەوە.» ");
INSERT INTO ckb_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","یوسف لە وەڵامی فیرعەوندا گوتی: «ئەوە من نیم، بەڵکو خودایە کە وەڵامی دڵنیاکەرەوە دەداتە فیرعەون.» ");
INSERT INTO ckb_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","ئینجا فیرعەون بە یوسفی گوت: «لە خەونمدا لەسەر کەناری ڕووباری نیل ڕاوەستابووم، ");
INSERT INTO ckb_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","بینیم لە ڕووبارەکەوە حەوت مانگای گۆشتن و جوان هاتنە دەرەوە و لە مێرگەکەدا کەوتنە لەوەڕان. ");
INSERT INTO ckb_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","لەدوای ئەوان حەوت مانگای دیکە هاتنە دەرەوە کە زۆر لەڕولاواز و ناشیرین بوون. لە هەموو خاکی میسر مانگای ناشیرینی وەک ئەوانم نەبینیبوو. ");
INSERT INTO ckb_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","ئینجا مانگا لەڕولاواز و ناشیرینەکان، حەوت مانگا قەڵەوەکەی یەکەم جاریان خوارد. ");
INSERT INTO ckb_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","بەڵام تەنانەت دوای ئەوەی ئەوانیان خوارد، پێیانەوە دیار نەبوو کە شتی وایان خواردووە، بەڵکو هەروەک یەکەم جار ڕوخساریان ناشیرین بوو. ئیتر بە ئاگا هاتم. ");
INSERT INTO ckb_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","«دیسان لە خەونمدا بینیم حەوت گوڵەگەنمی پڕ و جوان لە لاسکێکەوە دەرهاتوون. ");
INSERT INTO ckb_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","لەدوای ئەوان حەوت گوڵەگەنمی وشک و باریک و سووتاو بە بای ڕۆژهەڵات ڕواون. ");
INSERT INTO ckb_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","گوڵەگەنمە باریکەکان حەوت گوڵەگەنمە جوانەکەیان قووت دا. ئەمەم بە جادووگەرەکان گوت، بەڵام کەسیان نەیانتوانی بۆم لێکبدەنەوە.» ");
INSERT INTO ckb_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","یوسفیش بە فیرعەونی گوت: «خەونەکانی فیرعەون یەکە و لە یەک دەچن. ئەوەی خودا بە تەمایە بیکات بە فیرعەونی ڕاگەیاند. ");
INSERT INTO ckb_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","حەوت مانگا جوانەکە حەوت ساڵن. حەوت گوڵەگەنمە جوانەکەش هەر حەوت ساڵن. یەک خەونە. ");
INSERT INTO ckb_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","حەوت مانگا لەڕولاواز و ناشیرینەکان کە دووەم جار هاتنە دەرەوە، ئەوە حەوت ساڵن. حەوت گوڵەگەنمە باریک و سووتاوەکە بە بای ڕۆژهەڵات، دەبنە حەوت ساڵی قاتوقڕی. ");
INSERT INTO ckb_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","«ئەمەش ئەوەیە کە بە فیرعەونم گوت: خودا بە فیرعەونی نیشان داوە کە بە تەمایە چی بکات. ");
INSERT INTO ckb_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","حەوت ساڵ تێروتەسەلییەکی مەزن لە هەموو خاکی میسر دەبێت. ");
INSERT INTO ckb_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","بەڵام بەدوای ئەودا حەوت ساڵی قاتوقڕی دێت کە هەموو ئەو تێروتەسەلییە لەبیر دەباتەوە کە لە خاکی میسر بووە. قاتوقڕی خاکەکە دەفەوتێنێت. ");
INSERT INTO ckb_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","ئیتر تێروتەسەلی خاکەکە لەبیر دەچێتەوە، چونکە ئەو قاتوقڕییەی بەدوایدا دێت زۆر سەخت دەبێت. ");
INSERT INTO ckb_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","هۆکاری ئەوەش کە خەونەکە بە دوو شێوە بۆ فیرعەون دووبارە کراوەتەوە، ئەوەیە کە ئەو کارە لەلای خوداوە بڕیاری لەسەر دراوە و بە زوویی ئەنجامی دەدات. ");
INSERT INTO ckb_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","«ئێستاش با فیرعەون پیاوێکی وردبین و دانا بدۆزێتەوە و بەسەر خاکی میسرەوە دایبنێت. ");
INSERT INTO ckb_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","با فیرعەون چەند سەرپەرشتیارێک لەسەر زەوی دابنێت بۆ وەرگرتنی پێنج یەکی دانەوێڵەی خاکی میسر لە هەر حەوت ساڵی تێروتەسەلییەکە. ");
INSERT INTO ckb_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","پێویستە هەموو خواردنی ئەو ساڵە باشانەی کە دێن کۆبکەنەوە و لەژێر دەسەڵاتی فیرعەوندا گەنم لە ئەمبار بکەن و بۆ مەبەستی خواردن لە شارۆچکەکان هەڵیانبگرن. ");
INSERT INTO ckb_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","ئەم خۆراکە دەبێتە ئازووقەی خاکەکە بۆ ئەو حەوت ساڵە قاتوقڕییەی کە لە خاکی میسردا دەبێت. بەو شێوەیە خاکەکە بە قاتوقڕی لەناو ناچێت.» ");
INSERT INTO ckb_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","فیرعەون و هەموو دەستوپێوەندەکەی ئەم قسانەیان پێ باش بوو. ");
INSERT INTO ckb_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","فیرعەون بە دەستوپێوەندەکەی گوت: «ئایا کەسێکی وەک ئەم پیاوەمان دەست دەکەوێت کە ڕۆحی خودای تێدابێت؟» ");
INSERT INTO ckb_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","ئینجا فیرعەون بە یوسفی گوت: «لەبەر ئەوەی خودا هەموو ئەمانەی بۆ تۆ ئاشکرا کردووە، لە تۆ وردبینتر و داناتر بوونی نییە. ");
INSERT INTO ckb_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","تۆ دەبیتە لێپرسراوی کۆشکەکەی من، هەروەها هەموو گەلەکەشم لە دەمی تۆوە ڕاسپاردە وەردەگرن. من تەنها لە تەختی پاشایەتی لە تۆ گەورەتر دەبم.» ");
INSERT INTO ckb_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","ئیتر فیرعەون بە یوسفی گوت: «ئەوا تۆم کردە لێپرسراوی هەموو خاکی میسر.» ");
INSERT INTO ckb_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","ئینجا فیرعەون ئەو ئەنگوستیلەیەی لە دەستی خۆی داکەند کە مۆری شاهانەی پێوە بوو و لە دەستی یوسفی کرد، هەروەها جلوبەرگی کەتانی ناسکی لەبەری کرد و تەوقێکی زێڕیشی لە ملی کرد. ");
INSERT INTO ckb_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","پاشان سواری گالیسکەی جێگرەکەی کرد و لەپێشیەوە بانگەوازیان کرد: «بە چۆکدا بێن!» ئیتر کردییە لێپرسراوی هەموو خاکی میسر. ");
INSERT INTO ckb_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","ئینجا فیرعەون بە یوسفی گوت: «من فیرعەونم، بەڵام بەبێ قسەی تۆ کەس لە هەموو خاکی میسر، نە دەستی و نە پێی بەرز ناکاتەوە.» ");
INSERT INTO ckb_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","فیرعەون ناوی لە یوسف نا سافنەت پەعنێح، هەروەها ئاسنەتی کچی پۆتی‌فەرەعی کاهینی ئۆنی کچی پێدا هەتا ببێتە ژنی. ئیتر یوسف چووە دەرەوە بۆ سەر خاکی میسر. ");
INSERT INTO ckb_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","یوسف تەمەنی سی ساڵ بوو کاتێک دەستی کرد بە خزمەتکردنی فیرعەونی پاشای میسر. یوسف لەلای فیرعەون چووە دەرەوە و بە هەموو خاکی میسردا تێپەڕی. ");
INSERT INTO ckb_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","زەوی لە حەوت ساڵی تێروتەسەلییەکەدا، بەروبوومێکی زۆری دا. ");
INSERT INTO ckb_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","یوسف هەموو خۆراکی ئەو حەوت ساڵەی خاکی میسری کۆکردەوە. لە هەموو شارێکدا ئەو خۆراکانەی دانا کە لە کێڵگەکانی دەوروبەری کۆ دەکردەوە. ");
INSERT INTO ckb_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","یوسف وەک لمی دەریا گەنمی کۆکردەوە، ئەوەندە زۆر بوو کە ئیتر وازی لە هەژماردکردنیان هێنا، چونکە لە ژماردن نەدەهاتن. ");
INSERT INTO ckb_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","پێش هاتنی ساڵانی قاتوقڕییەکە، یوسف لە ئاسنەتی کچی پۆتی‌فەرەعی کاهینی ئۆن دوو کوڕی بوو. ");
INSERT INTO ckb_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","یوسف کوڕە نۆبەرەکەی ناو نا مەنەشە و گوتی: «ئەم ناوەم لێنا، چونکە خودا هەموو ماندووبوونم و هەموو ماڵی باوکمی لەبیر بردمەوە.» ");
INSERT INTO ckb_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","دووەمیشیانی ناو نا ئەفرایم و گوتی: «ئەم ناوەم لێنا، چونکە خودا لە خاکی زەلیلیمدا بەرداری کردم.» ");
INSERT INTO ckb_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","حەوت ساڵە تێروتەسەلییەکەی خاکی میسر، کۆتایی پێهات. ");
INSERT INTO ckb_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","ئینجا هەروەک یوسف گوتبووی، حەوت ساڵی قاتوقڕییەکە دەستی پێکرد. قاتوقڕی هەموو زەوی گرتبووەوە، بەڵام لە هەموو خاکی میسردا نان هەبوو. ");
INSERT INTO ckb_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","کاتێک قاتوقڕییەکە کاریگەری لە هەموو میسر کرد، خەڵکەکە هاواریان بۆ فیرعەون برد بۆ نان. فیرعەونیش بە هەموو میسرییەکانی گوت: «بڕۆنە لای یوسف، ئەوەی ئەو پێتان دەڵێت بیکەن.» ");
INSERT INTO ckb_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","قاتوقڕییەکە تەواوی ڕووی خاکەکەی گرتەوە، ئینجا یوسف هەموو ئەمبارەکانی کردەوە و بە میسرییەکانی فرۆشت. قاتوقڕییەکە لە خاکی میسردا توندتر بوو. ");
INSERT INTO ckb_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","خەڵکی لە هەموو لایەکی جیهانەوە هاتن بۆ میسر تاکو گەنم لە یوسف بکڕن، چونکە قاتوقڕییەکە لە هەموو شوێنێکدا توند بوو. ");
INSERT INTO ckb_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","کاتێک یاقوب زانی کە لە میسر گەنم هەیە، بە کوڕەکانی خۆی گوت: «بۆ سەیری یەکتری دەکەن؟» ");
INSERT INTO ckb_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","گوتی: «بیستوومە لە میسر گەنم هەیە. بڕۆن و لەوێ بۆمان بکڕن، بۆ ئەوەی بژین و نەمرین.» ");
INSERT INTO ckb_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","ئیتر دە برای یوسف بەرەو خوار چوون بۆ کڕینی گەنم لە میسر. ");
INSERT INTO ckb_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","بەڵام یاقوب بنیامینی برای یوسفی لەگەڵ براکانی نەنارد، چونکە گوتی نەوەک تووشی بەڵایەک بێت. ");
INSERT INTO ckb_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","ئیتر کوڕانی ئیسرائیل هاتن بۆ کڕینی گەنم لەگەڵ ئەو خەڵکەی کە دەهاتن، چونکە لە خاکی کەنعان قاتوقڕی هەبوو. ");
INSERT INTO ckb_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","یوسف خۆی دەسەڵاتداری خاکی میسر بوو، هەر خۆشی گەنمی بە هەموو گەل دەفرۆشت. بۆیە کاتێک براکانی یوسف گەیشتنە میسر، کڕنۆشیان بۆ برد و سەریان خستە سەر زەوی. ");
INSERT INTO ckb_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","هەرکە یوسف تەماشای براکانی کرد، یەکسەر ئەوانی ناسییەوە، بەڵام خۆی لێ گۆڕین و بە ڕەقی قسەی لەگەڵ کردن و لێی پرسین: «لەکوێوە هاتوون؟» ئەوانیش وەڵامیان دایەوە: «لە خاکی کەنعانەوە بۆ خۆراک کڕین.» ");
INSERT INTO ckb_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","هەرچەندە یوسف براکانی خۆی ناسییەوە، بەڵام ئەوان ئەمیان نەناسییەوە. ");
INSERT INTO ckb_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","ئینجا یوسف ئەو خەونانەی هاتەوە یاد کە بە ئەوانییەوەی بینیبوو، پێی گوتن: «ئێوە سیخوڕن! بۆ ئەوە هاتوون تاکو خاڵی لاوازی خاکەکە ببینن.» ");
INSERT INTO ckb_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","ئەوانیش وەڵامیان دایەوە: «نەخێر گەورەم، بەڵکو خزمەتکارەکانت بۆ ئەوە هاتوون خۆراک بکڕن. ");
INSERT INTO ckb_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","ئێمە هەموومان کوڕی پیاوێکین، کەسانێکی سەرڕاستین، خزمەتکارەکانت سیخوڕ نین.» ");
INSERT INTO ckb_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","ئەویش پێی گوتن: «نەخێر، بەڵکو هاتوون تاکو خاڵی لاوازی خاکەکە ببینن.» ");
INSERT INTO ckb_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","بەڵام ئەوان گوتیان: «خزمەتکارەکانت دوازدە بران. ئێمە کوڕی پیاوێکین لە خاکی کەنعان. ئەمڕۆ بچووکەکەمان لەلای باوکمانە، یەکێکیشمان بێ سەروشوێنە.» ");
INSERT INTO ckb_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","یوسفیش پێی گوتن: «ئەوەیە کە پێم گوتن، ئێوە سیخوڕن. ");
INSERT INTO ckb_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","بەمە تاقی دەکرێنەوە: بە گیانی فیرعەون، لێرە ناچنە دەرەوە هەتا برا بچووکەکەتان نەیەت بۆ ئێرە. ");
INSERT INTO ckb_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","یەکێک لە خۆتان بنێرن تاکو براکەتان بهێنێت. ئێوەش لێرە بەند دەکرێن بۆ ئەوەی قسەکەتان تاقی بکرێتەوە و بزانرێت ئاخۆ ڕاستتان گوتووە. ئەگەر نا، ئەوا بە گیانی فیرعەون ئێوە سیخوڕن.» ");
INSERT INTO ckb_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","ئیتر هەموویانی بۆ ماوەی سێ ڕۆژ زیندانی کرد. ");
INSERT INTO ckb_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","لە ڕۆژی سێیەم یوسف پێی گوتن: «ئەمە بکەن و بژین، من کەسێکی لەخواترسم. ");
INSERT INTO ckb_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","ئەگەر ئێوە سەرڕاستن، با یەکێک لە براکانتان لێرە زیندانی بکرێت و ئەوانی دیکەشتان بڕۆن و گەنم ببەنەوە بۆ ماڵ و خێزانە برسییەکانتان. ");
INSERT INTO ckb_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","بەڵام دەبێت برا بچووکەکەتانم بۆ بهێنن، ئینجا ڕاستی قسەکانتان دەردەکەوێت و نامرن.» ئەوانیش بەم جۆرەیان کرد. ");
INSERT INTO ckb_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","بە یەکتریشیان گوت: «بەڕاستی ئێمە بەهۆی براکەمانەوەیە وا ئێستا سزا دەدرێین. کاتێک لێمان پاڕایەوە بینیمان چەند پەرێشان بوو، بەڵام گوێمان لێی نەگرت، لەبەر ئەوەشە ئەم تەنگانەیەمان بەسەرهاتووە.» ");
INSERT INTO ckb_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","ڕەئوبێنیش وەڵامی دانەوە: «ئەی پێم نەگوتن گوناه بەرامبەر بەو کوڕە مەکەن؟ بەڵام ئێوە گوێتان نەگرت! ئێستا داوای خوێنەکەی دەکرێت.» ");
INSERT INTO ckb_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","ئەوان نەیاندەزانی کە یوسف لە قسەکانیان تێدەگات، چونکە لە ڕێگەی وەرگێڕەوە قسەی لەگەڵ دەکردن. ");
INSERT INTO ckb_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","ئیتر لێیان جیا بووەوە و دەستی بە گریان کرد، بەڵام دوای ئەوە گەڕایەوە لایان و کەوتەوە قسەکردن لەگەڵیان. ئینجا شیمۆنی لێسەندن و لەپێش چاویان بەستییەوە. ");
INSERT INTO ckb_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","دوای ئەوە یوسف فەرمانی دا جەواڵەکانیان پڕ بکرێت لە گەنم و زیوی هەریەکەشیان بخرێتەوە هەگبەکەی خۆی و ئازووقەشیان پێبدرێت بۆ ڕێگا. ئیتر وایان بۆ کرا. ");
INSERT INTO ckb_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","گەنمەکەیان لە گوێدرێژەکانیان بارکرد و لەوێ ڕۆیشتن. ");
INSERT INTO ckb_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","لەو شوێنەی بۆ مانەوەی شەو لێی ڕاوەستان، یەکێکیان هەگبەکەی خۆی کردەوە بۆ ئەوەی ئالیک بداتە گوێدرێژەکەی، بینی زیوەکەی وا لە دەمی هەگبەکەیەتی. ");
INSERT INTO ckb_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","بە براکانی خۆی گوت: «زیوەکەم بۆ گەڕێنراوەتەوە، وا لە هەگبەکەمدایە.» ئەوانیش دڵەکوتێیان تێکەوت و بە ترس و لەرزەوە بە یەکتریان گوت: «ئەمە چییە خودا بە ئێمەی کردووە؟» ");
INSERT INTO ckb_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","ئینجا هاتنە لای یاقوبی باوکیان لە خاکی کەنعان، هەرچییەکیان بەسەرهاتبوو بۆیان گێڕایەوە و گوتیان: ");
INSERT INTO ckb_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","«ئەو پیاوەی گەورەی خاکەکەیە بە ڕەقییەوە قسەی لەگەڵ کردین و وای دەزانی ئێمە سیخوڕیی بەسەر خاکەکەوە دەکەین. ");
INSERT INTO ckb_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","بەڵام ئێمە پێمان گوت: ”ئێمە سەرڕاستین و سیخوڕ نین. ");
INSERT INTO ckb_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","ئێمە دوازدە برای کوڕی باوکێکین. یەکێکمان نەماوە و بچووکەکەشمان ئەمڕۆ لەلای باوکمانە لە خاکی کەنعان.“ ");
INSERT INTO ckb_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","«ئەو پیاوەش کە گەورەی خاکەکەیە پێی گوتین: ”بەمەدا دەزانم ئێوە سەرڕاستن: با یەکێک لە براکانتان لەلای من بمێنێتەوە و ئەوەی بۆ ماڵ و خێزانە برسییەکانتان پێویستە بیبەن و بڕۆن. ");
INSERT INTO ckb_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","ئینجا برا بچووکەکەتانم بۆ بهێنن. ئیتر بەوەدا دەزانم کە ئێوە سیخوڕ نین و کەسانێکی سەرڕاستن. ئەو کات براکەتان پێدەدەمەوە و دەشتوانن لە خاکەکەدا بازرگانی بکەن.“» ");
INSERT INTO ckb_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","کاتێک هەگبەکانیان بەتاڵ دەکرد، کیسەی زیوی هەریەکەیان لە هەگبەکەی خۆیدا بوو! ئیتر خۆیان و باوکیان کە کیسەی زیوەکانیان بینی، ترسیان لێ نیشت. ");
INSERT INTO ckb_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","یاقوبی باوکیشیان پێی گوتن: «منتان لە منداڵەکانم بێبەش کرد. یوسف نەما و شیمۆنیش نەما، ئێستاش بنیامین دەبەن. هەمووی بەسەر مندا شکاوەتەوە.» ");
INSERT INTO ckb_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","ڕەئوبێن بە باوکی گوت: «ئەگەر بۆم نەهێنایتەوە هەردوو کوڕەکەم بکوژە. بیدە دەستی من، خۆم بۆتی دەهێنمەوە.» ");
INSERT INTO ckb_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","بەڵام یاقوب گوتی: «کوڕی من لەگەڵ ئێوە نایەت، چونکە براکەی مردووە و ئەویش بە تەنها ماوەتەوە. ئەگەر لەو ڕێگایەی پێیدا دەڕۆن تووشی شتێک بێت، ئەوا سەری سپیم بە خەمەوە دەنێنە ناو جیهانی مردووانەوە.» ");
INSERT INTO ckb_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","قاتوقڕی لە خاکەکە درێژەی کێشا و هەر سەخت بوو. ");
INSERT INTO ckb_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","کاتێک لە خواردنی گەنمەکە بوونەوە کە لە میسرەوە هێنابوویان، باوکیان پێی گوتن: «بگەڕێنەوە و هەندێک خۆراکمان بۆ بکڕن.» ");
INSERT INTO ckb_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","بەڵام یەهودا پێی گوت: «ئەو پیاوە بە تەواوی ئاگاداری کردینەوە و گوتی: ”ئەگەر براکەتان لەگەڵ نەبێت، چاوتان بە چاوم ناکەوێت.“ ");
INSERT INTO ckb_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","ئەگەر براکەمان لەگەڵ بنێریت ئەوا بەرەو خوار دەچین و خۆراکت بۆ دەکڕین. ");
INSERT INTO ckb_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","بەڵام ئەگەر ناینێریت ئەوا بەرەو خوار ناچین، چونکە پیاوەکە پێی گوتین: ”چاوتان بە چاوم ناکەوێت، ئەگەر براکەتان لەگەڵ نەبێت.“» ");
INSERT INTO ckb_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","ئیسرائیلیش لێی پرسین: «بۆچی خراپەتان لەگەڵ کردم بەوەی بە پیاوەکەتان ڕاگەیاند برایەکی دیکەشتان هەیە؟» ");
INSERT INTO ckb_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","ئەوانیش وەڵامیان دایەوە: «پیاوەکە دەربارەی خۆمان و کەسوکارمان پرسیاری لێکردین و گوتی: ”ئایا باوکتان ماوە؟ برای دیکەتان هەیە؟“ ئێمەش بەپێی ئەم قسانە پێمان ڕاگەیاند. ئایا دەمانزانی کە پێمان دەڵێت: ”براکەتان بۆ ئێرە بهێنن“؟» ");
INSERT INTO ckb_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","یەهودا بە ئیسرائیلی باوکی گوت: «کوڕەکە لەگەڵ من بنێرە، هەڵدەستین و دەڕۆین، ئیتر ئێمە و تۆ و منداڵەکانمان دەژین و نامرین. ");
INSERT INTO ckb_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","خۆم دەستەبەری سەلامەتی دەبم، لە دەستی من داوای دەکەیتەوە. ئەگەر بۆم نەهێنایتەوە و لەبەردەمت ڕام نەگرت ئەوا هەتاهەتایە بەرامبەر بە تۆ تاوانبارم، ");
INSERT INTO ckb_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","چونکە ئەگەر ئاوا دوانەکەوتباین، ئێستا ئەمە دووەم جار بوو هاتبووینەوە.» ");
INSERT INTO ckb_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","ئیسرائیلی باوکیشیان پێی گوتن: «ئەگەر وایە، ئەوا ئەمە بکەن: لە باشترین بەرهەمی زەوی بخەنە ناو جەواڵەکانتان و بە دیاری بۆ پیاوەکەی ببەن، وەک هەندێک هەتووان، هەنگوین، بەهارات، موڕ، بستە و بادەم. ");
INSERT INTO ckb_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","دوو هێندەش زیو لەگەڵ دەستتان ببەن، ئەو زیوەش کە لە دەمی هەگبەکانتان گەڕێنرابووەوە لەگەڵ دەستی خۆتان بیبەنەوە، لەوانەیە هەڵەیان کردبێت. ");
INSERT INTO ckb_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","براکەتان ببەن و هەستن بگەڕێنەوە لای پیاوەکە. ");
INSERT INTO ckb_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","خودای هەرە بەتوانا وا بکات ئەو پیاوە بەزەیی هەبێت بەرامبەرتان، تاکو واز لە براکەی دیکەتان و بنیامین بهێنێت. منیش ئەگەر لە منداڵان بێبەش بووم، ئەوا لێیان بێبەشم.» ");
INSERT INTO ckb_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","پیاوەکانیش ئەو دیارییانە و دوو هێندە زیویشیان لەگەڵ دەستی خۆیان هەڵگرت و بنیامینیان برد و بەرەو خوار چوون بۆ میسر و لەبەردەم یوسف ڕاوەستان. ");
INSERT INTO ckb_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","کاتێک یوسف بنیامینی لەگەڵیان بینی، بە سەرکاری ماڵەکەی گوت: «ئەم پیاوانە ببە ماڵەوە و ئاژەڵێکیش سەر ببڕە و ئامادەی بکە، چونکە بۆ نیوەڕۆ لەگەڵ خۆم نان دەخۆن.» ");
INSERT INTO ckb_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","ئیتر سەرکارەکە بەو جۆرەی کە یوسف فەرمانی پێ کردبوو، پیاوەکانی بردەوە بۆ ماڵی یوسف. ");
INSERT INTO ckb_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","پیاوەکان ترسان کاتێک برانە ماڵی یوسف و گوتیان: «ئێمەیان بەهۆی ئەو زیوەی جاری یەکەم خرابووەوە ناو هەگبەکانمان هێناوەتە ژوورەوە. دەیەوێت پەلامارمان بدات و بکەوێتە سەرمان و بمانکاتە کۆیلە و گوێدرێژەکانمان ببات.» ");
INSERT INTO ckb_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","ئیتر لە سەرکاری ماڵەکەی یوسف چوونە پێشەوە و لەناو دەرگای ماڵەکە قسەیان لەگەڵ کرد. ");
INSERT INTO ckb_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","پێیان گوت: «ئەی گەورەم، تکایە، ئێمە یەکەم جار بۆ کڕینی خۆراک هاتینە ئێرە. ");
INSERT INTO ckb_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","بەڵام کە لە شوێنی شەومانەوەکەمان ڕاوەستاین، هەگبەکانمان کردەوە، بینیمان زیوی هەریەکەمان لە دەمی هەگبەکەی بوو، بە کێشی تەواوی خۆی، ئێمەش لەگەڵ دەستی خۆمان هێنامانەوە. ");
INSERT INTO ckb_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","هەروەها زیوی دیکەشمان لەگەڵ دەستی خۆمان هێناوە بۆ ئەوەی خۆراک بکڕین. ناشزانین کێ زیوەکانمانی خستبووە ناو هەگبەکانمان.» ");
INSERT INTO ckb_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","ئەویش پێی گوتن: «نیگەران مەبن، مەترسن. خوداکەی ئێوە و خوداکەی باوکتان هەگبەکانتانی کردە گەنجینە، من زیوەکانی ئێوەم وەرگرتووە.» ئینجا شیمۆنی بۆ هێنانە دەرەوە. ");
INSERT INTO ckb_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","پیاوەکە ئەوانی هێنایە ژوورەوە بۆ ماڵەکەی یوسف و ئاوی دانێ هەتا پێیان بشۆن و ئالیکی دایە گوێدرێژەکانیان. ");
INSERT INTO ckb_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","ئەوانیش دیارییەکەیان ئامادە کرد بۆ کاتی گەیشتنی یوسف لە دەمەو نیوەڕۆ، چونکە بیستبوویان ئەوان لەوێ نان دەخۆن. ");
INSERT INTO ckb_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","کە یوسف گەڕایەوە ماڵ، کڕنۆشیان بۆ برد و ئەو دیارییانەیان پێشکەش کرد کە لەگەڵ دەستی خۆیان هێنابوویان بۆ ماڵەکە. ");
INSERT INTO ckb_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","ئەویش هەواڵی پرسین و گوتی: «باوکە پیرەکەتان چۆنە کە بۆتان باسکردم؟ ئایا هێشتا ماوە؟» ");
INSERT INTO ckb_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","ئەوانیش وەڵامیان دایەوە: «خزمەتکاری خۆت باوکی ئێمە باشە و هێشتاش زیندووە.» ئیتر بۆی نوشتانەوە و کڕنۆشیان بۆی برد. ");
INSERT INTO ckb_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","ئەویش چاوی هەڵبڕی و سەیری بنیامینی برای کوڕی دایکی خۆی کرد و گوتی: «ئەمەیە برا بچووکەکەتان کە بۆتان باسکردم؟» ئینجا گوتی: «کوڕم، خودا میهرەبان بێت لەگەڵت.» ");
INSERT INTO ckb_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","ئیتر یوسف بە پەلە ئەوێی بەجێهێشت، چونکە هەناوی گڕی گرت بۆ براکەی و داوای شوێنێکی کرد کە تێیدا بگریێت. ئینجا چووە ژوورەکەی خۆی و لەوێ گریا. ");
INSERT INTO ckb_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","پاشان دەموچاوی شوشت و هاتە دەرەوە، دانی بەخۆیدا گرت و گوتی: «نان بهێنن.» ");
INSERT INTO ckb_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","ئەوانیش بە جیا خواردنیان بۆ ئەم هێنا و بۆ براکانیشی بە جیا، هەروەها بۆ میسرییەکانیشیان بە جیا هێنا کە لای ئەو نانیان دەخوارد. میسرییەکان نەیاندەتوانی لەگەڵ عیبرانییەکان پێکەوە نان بخۆن، چونکە لەلای میسرییەکان کارێکی قێزەون بوو. ");
INSERT INTO ckb_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","پیاوەکان بەپێی تەمەنیان لەبەردەمی دانیشتبوون، لە نۆبەرەکەیانەوە هەتا بچووکەکەیان، بە سەرسامیشەوە دەیانڕوانییە یەکتری. ");
INSERT INTO ckb_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","کاتێک لە سەر خوانەکەی یوسف خواردن دابەش کرا، بەشەکەی بنیامین پێنج ئەوەندەی بەشی هەر یەکێکی دیکەیان بوو. ئیتر لەگەڵی خواردیانەوە و کەیف خۆش بوون. ");
INSERT INTO ckb_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","ئینجا یوسف فەرمانی دا بە سەرکاری ماڵەکەی خۆی و گوتی: «هەگبەی پیاوەکان پڕ بکەن لە خۆراک، ئەوەندەی لە توانایاندایە هەڵیبگرن، زیوی هەریەکەشیان بخەوە دەمی هەگبەکەی. ");
INSERT INTO ckb_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","جامەکەی خۆشم، جامە زیوەکە، لە دەمی هەگبەی بچووکەکەیان دابنێ لەگەڵ نرخی گەنمەکەی.» ئەویش بەپێی قسەکەی یوسف کارەکەی ئەنجام دا. ");
INSERT INTO ckb_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","کە ڕۆژ بووەوە، پیاوەکان خۆیان و گوێدرێژەکانیان ڕۆیشتن. ");
INSERT INTO ckb_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","هێشتا زۆر لە شار دوور نەکەوتبوونەوە، کە یوسف بە سەرکاری ماڵەکەی خۆی گوت: «هەستە و دوای ئەو پیاوانە بکەوە، کە پێیان گەیشتیت، پێیان بڵێ: ”بۆچی بە خراپە پاداشتی چاکەتان دایەوە؟ ");
INSERT INTO ckb_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","ئایا ئەمە ئەو جامە نییە کە گەورەکەم تێیدا دەخواتەوە و فاڵی پێ دەگرێتەوە؟ کارێکی خراپتان کردووە.“» ");
INSERT INTO ckb_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","ئەویش پێیان گەیشتەوە و ئەم قسانەی پێ گوتن. ");
INSERT INTO ckb_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","بەڵام ئەوان پێیان گوت: «بۆچی گەورەمان قسەی وا دەکات؟ دوور بێت لە خزمەتکارەکانت شتی وا بکەن. ");
INSERT INTO ckb_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","ئێمە تەنانەت ئەو زیوەی لە دەمی هەگبەکانمان دۆزیبوومانەوە، لە خاکی کەنعانەوە بۆمان هێنایتەوە. ئیتر چۆن لە ماڵی گەورەکەت زیو یان زێڕ دەدزین؟ ");
INSERT INTO ckb_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","لەلای هەرکام لە خزمەتکارەکانت دۆزرایەوە، ئەوە دەمرێت. ئێمەش دەبینە کۆیلەی گەورەی خۆمان.» ");
INSERT INTO ckb_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","ئەویش گوتی: «باشە، ئێستا بەپێی قسەکەی خۆتان دەبێت. ئەوەی لەلای دەدۆزرێتەوە دەبێتە کۆیلەی من. ئێوەش بێتاوان دەبن.» ");
INSERT INTO ckb_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","ئیتر هەریەکەیان خێرا هەگبەکەی خۆی داگرتە سەر زەوی و هەریەکەیان هەگبەکەی خۆی کردەوە. ");
INSERT INTO ckb_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","ئەویش کەوتە پشکنین، لە گەورەکەیانەوە دەستی پێکرد و لە بچووکەکەیان تەواو بوو. ئیتر جامەکەی لە هەگبەکەی بنیامین دۆزییەوە! ");
INSERT INTO ckb_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","ئەوانیش جلەکانی بەری خۆیان دادڕی و گوێدرێژەکانیان بارکردەوە و گەڕانەوە بۆ شارەکە. ");
INSERT INTO ckb_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","کاتێک یەهودا و براکانی هاتنە ناو ماڵەکەی یوسف، هێشتا یوسف لەوێ بوو، ئیتر کڕنۆشیان بۆ برد. ");
INSERT INTO ckb_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","یوسفیش پێی گوتن: «ئەم کارە چییە ئێوە کردووتانە؟ ئایا نەتاندەزانی پیاوێکی وەک من فاڵ دەگرێتەوە؟» ");
INSERT INTO ckb_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","یەهوداش وەڵامی دایەوە: «چی بە گەورەی خۆم بڵێین؟ قسەی چی بکەین و بە چی پاکانەی خۆمان بکەین؟ خودا تاوانی خزمەتکارەکانتی دەرخستووە. ئێستاش ئێمە کۆیلەی گەورەی خۆمانین، ئێمە و ئەوەی جامەکەش لە دەستی گیراوە.» ");
INSERT INTO ckb_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","بەڵام یوسف گوتی: «لە من دوور بێت شتی وا بکەم! ئەو پیاوەی جامەکەی لە دەست گیراوە ئەو دەبێتە کۆیلەم. ئێوەش بە سەلامەتی سەربکەونەوە بۆ لای باوکتان.» ");
INSERT INTO ckb_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","ئینجا یەهودا لێی چووە پێشەوە و گوتی: «گەورەم، تکایە، با خزمەتکاری خۆت قسەیەک بۆ گەورەکەی بکات. لە خزمەتکاری خۆت تووڕە مەبە، هەرچەندە تۆ وەک خودی فیرعەونیت. ");
INSERT INTO ckb_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","گەورەم لە خزمەتکارانی خۆی پرسی: ”ئایا باوک یان براتان هەیە؟“ ");
INSERT INTO ckb_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","ئێمەش بە گەورەمان گوت: ”باوکێکی پیرمان هەیە لەگەڵ کوڕە بچووکەکەی کە لە تەمەنی پیریدا بۆی بووە. برای ئەو کوڕە مردووە و ئێستا خۆی بە تەنها بۆ دایکی ماوەتەوە. باوکیشی خۆشی دەوێت.“ ");
INSERT INTO ckb_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","«تۆش بە خزمەتکارانی خۆتت گوت: ”بۆم بهێنن تاکو بە چاوی خۆم بیبینم.“ ");
INSERT INTO ckb_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","ئێمەش بە گەورەمان گوت: ”کوڕەکە ناتوانێت باوکی بەجێبهێڵێت، چونکە ئەگەر باوکی بەجێبهێڵێت باوکی دەمرێت.“ ");
INSERT INTO ckb_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","بەڵام تۆ بە خزمەتکارەکانی خۆتت گوت: ”ئەگەر برا بچووکەکەتان لەگەڵتان بەرەو خوار نەیەت، ئەوا چاوتان بە چاوم ناکەوێتەوە.“ ");
INSERT INTO ckb_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","ئەوە بوو کاتێک گەڕاینەوە لای باوکمان کە خزمەتکاری ئێوەیە، قسەکانی گەورەی خۆممان پێی ڕاگەیاند. ");
INSERT INTO ckb_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","«پاشان باوکمان پێی گوتین: ”بگەڕێنەوە و هەندێک خواردنمان بۆ بکڕن.“ ");
INSERT INTO ckb_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","بەڵام ئێمە گوتمان: ”ناتوانین بەرەو خوار بچین. تەنها مەگەر ئەو کاتەی برا بچووکەکەمان لەگەڵ بێت، ئینجا بەرەو خوار دەچین، چونکە ناتوانین چاومان بە پیاوەکە بکەوێت ئەگەر برا بچووکەکەمان لەگەڵ نەبێت.“ ");
INSERT INTO ckb_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","«خزمەتکارەکەت، باوکمان پێی گوتین: ”ئێوە دەزانن ژنەکەم دوو کوڕی بۆم بووە، ");
INSERT INTO ckb_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","یەکێکیان لەلای من ڕۆیشت، گوتم، ’هەبێت و نەبێت پارچەپارچە کراوە.‘ هەتا ئێستاش چاوم پێ نەکەوتووەتەوە. ");
INSERT INTO ckb_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","خۆ ئەگەر ئەمەشیان لەبەردەمم ببەن و بەڵایەکی بەسەربێت، ئەوا مووە سپییەکانم بە خەم و پەژارەوە دەنێنە ناو جیهانی مردووانەوە.“ ");
INSERT INTO ckb_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","«ئێستاش ئەگەر بەبێ کوڕەکە بچمەوە بۆ لای باوکم کە خزمەتکاری ئێوەیە و گیانی پەیوەستە بە گیانی ئەمەوە، ");
INSERT INTO ckb_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","ببینێت کوڕەکە دیار نییە، بۆ خۆی دەمرێت. ئێمەی خزمەتکارانیشت سەری سپی باوکمان کە خزمەتکاری ئێوەیە بە خەم و پەژارەوە دادەگرینە ناو جیهانی مردووانەوە، ");
INSERT INTO ckb_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","چونکە خزمەتکارەکەی ئێوە دەستەبەری سەلامەتی کوڕەکەی کردووە لەلای باوکم. گوتوومە: ”ئەگەر بۆم نەهێنایتەوە ئەوا هەتاهەتایە تاوانبارم بەرامبەر بە باوکم!“ ");
INSERT INTO ckb_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","«ئێستاش با خزمەتکاری خۆت لە جیاتی کوڕەکە بمێنێتەوە و ببێتە کۆیلەی گەورەی خۆم، کوڕەکەش لەگەڵ براکانی بگەڕێتەوە. ");
INSERT INTO ckb_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","چۆن بگەڕێمەوە لای باوکم ئەگەر کوڕەکەم لەگەڵ نەبێت؟ تکایە مەهێڵە ئەم مەینەتییە ببینم کە بەسەر باوکمدا دێت.» ");
INSERT INTO ckb_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","ئیتر یوسف نەیتوانی خۆی ڕابگرێت لەبەردەم هەموو ئەوانەی لەلای ڕاوەستابوون، هاواری کرد: «هەمووان لەلام بڕۆنە دەرەوە!» ئیتر کەسی لێ نەمابوو کاتێک خۆی بە براکانی ناساند. ");
INSERT INTO ckb_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","بە دەنگێکی وا بەرز گریا کە میسرییەکان گوێیان لێبوو، ماڵی فیرعەونیش ئەمەی بیست. ");
INSERT INTO ckb_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","یوسف بە براکانی گوت: «من یوسفم. ئایا باوکم هێشتا ماوە؟» بەڵام براکانی نەیانتوانی وەڵامی بدەنەوە، چونکە لە یوسف تۆقیبوون. ");
INSERT INTO ckb_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","ئینجا یوسف بە براکانی گوت: «لێم وەرنە پێشەوە.» ئەوانیش هاتنە پێشەوە، ئەمیش گوتی: «من یوسفی براتانم کە بە میسرتان فرۆشت. ");
INSERT INTO ckb_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","ئێستاش نە نیگەران بن و نە لۆمەی خۆتان بکەن کە منتان بە ئێرە فرۆشتووە، چونکە بۆ ڕزگارکردنی ژیانی خەڵکی بوو کە خودا منی پێش ئێوە نارد. ");
INSERT INTO ckb_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","ئەمە دوو ساڵە لە خاکەکە قاتوقڕی هەیە، بۆ پێنج ساڵی دیکەش نە کێڵان دەبێت و نە دروێنە. ");
INSERT INTO ckb_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","بەڵام خودا منی پێش ئێوە نارد بۆ دابینکردنی پاشەڕۆژتان لە زەوی، بۆ ژیان بۆتان، بۆ دەربازبوونێکی مەزن. ");
INSERT INTO ckb_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","«ئێستاش ئێوە نین کە منتان بۆ ئێرە نارد، بەڵکو خودایە منی کردووەتە باوک بۆ فیرعەون و گەورەی هەموو ماڵەکەی و فەرمانڕەوای هەموو خاکی میسر. ");
INSERT INTO ckb_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","پەلە بکەن و بڕۆنە لای باوکم و پێی بڵێن: ”یوسفی کوڕت دەڵێت خودا منی کردووە بە گەورەی هەموو میسر. بەرەو خوار وەرە بۆ لام و ڕامەوەستە. ");
INSERT INTO ckb_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","لە ناوچەی گۆشەن نیشتەجێ دەبیت و لە من نزیک دەبیت، خۆت و کوڕەکانت و کوڕی کوڕەکانت و ڕانە مەڕەکەت و گاگەلەکەت و هەرچییەکت هەیە. ");
INSERT INTO ckb_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","لەوێ خۆم بەخێوت دەکەم، چونکە قاتوقڕییەکە هێشتا پێنج ساڵی ماوە. ئەگینا خۆت و ماڵەکەت و هەرچیشت هەیە هەژار دەبن.“ ");
INSERT INTO ckb_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","«وا بە چاوی خۆتان دەبینن و بنیامینی براشم دەمبینێت کە بەڕاستی ئەوە منم قسەتان لەگەڵ دەکەم. ");
INSERT INTO ckb_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","بە باوکم ڕابگەیەنن کە من لە میسر خاوەنی چ شکۆ و دەسەڵاتێکم، هەروەها باسی هەموو ئەو شتانەشی بۆ بکەن کە بینیوتانە. بە پەلەش باوکم بۆ ئێرە بهێنن.» ");
INSERT INTO ckb_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","ئینجا باوەشی بە بنیامیندا کرد و گریا. بنیامینیش ئەوی لە ئامێز گرت و گریا. ");
INSERT INTO ckb_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","ئینجا هەموو براکانی ماچکرد و لەگەڵیان گریا. لەدوای ئەوە براکانی قسەیان لەگەڵی کرد. ");
INSERT INTO ckb_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","کاتێک ماڵی فیرعەون هەواڵی هاتنی براکانی یوسفیان بیست، فیرعەون و دەستوپێوەندەکەی دڵخۆش بوون. ");
INSERT INTO ckb_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","فیرعەون بە یوسفی گوت: «بە براکانت بڵێ: ”ئەمە بکەن: وڵاخەکانتان بار بکەن و بڕۆن بۆ خاکی کەنعان. ");
INSERT INTO ckb_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","باوکتان و خانەوادەکانتان هەڵبگرن و وەرن بۆ لای من. منیش باشترین خاکی میسرتان دەدەمێ و دەتوانن لە پیت و فەڕی زەوییەکە بخۆن.“ ");
INSERT INTO ckb_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","«هەروەها فەرمانت پێکراوە کە پێیان بڵێی، ”ئەمە بکەن: لە خاکی میسرەوە عەرەبانە ببەن بۆ ژن و منداڵەکانتان، باوکیشتان سەربخەن و وەرن. ");
INSERT INTO ckb_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","با چاویشتان لەدوای کەلوپەلەکانتان نەبێت، چونکە چاکی هەموو خاکی میسر بۆ ئێوە دەبێت.“» ");
INSERT INTO ckb_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","کوڕەکانی ئیسرائیلیش بەم جۆرەیان کرد. یوسفیش لەسەر فەرمانی فیرعەون، عەرەبانەی پێ دان، هەروەها ئازووقەشی بۆ ڕێگا پێ دان. ");
INSERT INTO ckb_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","قاتێک جلی بە هەریەکەیان دا، بەڵام سێ سەد شاقل زیو و پێنج قات جلی بە بنیامین دا. ");
INSERT INTO ckb_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","ئەمانەشی بۆ باوکی نارد: دە گوێدرێژی بارکراو لە خێروبێری میسر، لەگەڵ دە ماکەری بارکراو لە گەنم و نان و خۆراک بۆ گەشتەکەی باوکی. ");
INSERT INTO ckb_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","ئینجا براکانی بەڕێ کرد و پێش ڕۆیشتنیان پێی گوتن: «لە ڕێگا بەگژ یەکدا مەچن!» ");
INSERT INTO ckb_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","ئەوانیش لە میسرەوە چوون و هاتنەوە خاکی کەنعان بۆ لای یاقوبی باوکیان. ");
INSERT INTO ckb_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","پێیان ڕاگەیاند و گوتیان: «یوسف هێشتا زیندووە، خۆی فەرمانڕەوای هەموو خاکی میسرە!» یاقوبیش بوورایەوە، چونکە بڕوای پێ نەکردن. ");
INSERT INTO ckb_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","بەڵام کاتێک هەموو ئەو قسانەی یوسفیان پێ گوت کە پێی گوتبوون، هەروەها چاویشی بەو عەرەبانانە کەوت کە یوسف ناردبوونی بۆ ئەوەی بیهێننە میسر، ڕۆحی یاقوبی باوکیان ژیایەوە. ");
INSERT INTO ckb_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","ئیسرائیل گوتی: «بەسە! یوسفی کوڕم هێشتا ماوە، دەچم و پێش ئەوەی بمرم دەیبینم.» ");
INSERT INTO ckb_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","ئیتر ئیسرائیل بە هەرچییەکەوە کە هەیبوو کۆچی کرد، هاتە بیری شابەع و قوربانی بۆ خودای ئیسحاقی باوکی سەربڕی. ");
INSERT INTO ckb_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","خودا بە شەو لە بینینێکدا بە ئیسرائیلی فەرموو: «یاقوب! یاقوب!» ئەویش گوتی: «ئەوەتام.» ");
INSERT INTO ckb_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","فەرمووی: «من خودام، خودای باوکتم. مەترسە لە چوونت بۆ میسر، چونکە لەوێ دەتکەمە نەتەوەیەکی مەزن. ");
INSERT INTO ckb_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","من لەگەڵ تۆ دێمە میسر، بێگومان خۆشم دەتگەڕێنمەوە. یوسفیش دەستی خۆی دەنێتە سەر چاوەکانت.» ");
INSERT INTO ckb_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","ئیتر یاقوب بیری شابەعی بەجێهێشت، کوڕەکانی ئیسرائیلیش یاقوبی باوکیان و منداڵەکانیان و ژنەکانیان هەڵگرت و سواری ئەو عەرەبانانەیان کردن کە فیرعەون بۆ هەڵگرتنی ئەو ناردبووی. ");
INSERT INTO ckb_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","هەروەها یاقوب و هەموو نەوەکانی، لەگەڵ خۆیان مەڕوماڵاتەکەیان و ئەو کەلوپەلانەی لە خاکی کەنعان دەستیان کەوتبوو، هەڵگرت و هاتنە میسر. ");
INSERT INTO ckb_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","کوڕ و کوڕەزا و کچ و کچەزاکانی، هەموو نەوەکەی لەگەڵ خۆی هێنایە میسر. ");
INSERT INTO ckb_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","ئەمانەش ناوی کوڕەکانی ئیسرائیلن کە هاتنە میسر، واتا یاقوب و نەوەکانی: ڕەئوبێن کوڕە نۆبەرەی یاقوب. ");
INSERT INTO ckb_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","کوڕەکانی ڕەئوبێن: حەنۆک، پەڵو، حەسرۆن و کەرمی. ");
INSERT INTO ckb_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","کوڕەکانی شیمۆن: یەموئێل، یامین، ئۆهەد، یاکین و چۆحەر، هەروەها شائوول کە لە ژنێکی کەنعانی بوو. ");
INSERT INTO ckb_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","کوڕەکانی لێڤی: گێرشۆن، قەهات و مەراری. ");
INSERT INTO ckb_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","کوڕەکانی یەهودا: ئێر، ئۆنان، شالەح، پێرێز و زەرەح، بەڵام ئێر و ئۆنان لە خاکی کەنعان مردن. کوڕەکانی پێرێزیش ئەمانە بوون: حەسرۆن و حامول. ");
INSERT INTO ckb_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","کوڕەکانی یەساخار: تۆلاع، پوڤە، یاشوڤ و شیمرۆن. ");
INSERT INTO ckb_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","کوڕەکانی زەبولون: سەرەد، ئێلۆن و یەحلئێل. ");
INSERT INTO ckb_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","ئەمانە کوڕەکانی لێئەن کە بۆ یاقوبی بوون لە پەدان ئارام، لەگەڵ دینەی کچیشی. هەموو کوڕ و کچەکانی سی و سێ کەس بوون. ");
INSERT INTO ckb_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","کوڕەکانی گاد: چیفۆن، حەگی، شونی، ئەچبۆن، عێری، ئەرۆدی و ئەرئێلی. ");
INSERT INTO ckb_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","کوڕەکانی ئاشێر: یمنە، یەشڤە، یەشڤی و بەریعە لەگەڵ سەرەحی خوشکیان. کوڕەکانی بەریعە: حەڤەر و مەلکیێل. ");
INSERT INTO ckb_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","ئەمانەش کوڕەکانی زیلپە بوون کە لابان دابووی بە لێئەی کچی. ئەویش ئەمانەی بۆ یاقوب خستەوە کە شازدە کەس بوون. ");
INSERT INTO ckb_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","دوو کوڕەکەی ڕاحێلی ژنی یاقوب: یوسف و بنیامین. ");
INSERT INTO ckb_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","لە خاکی میسریش، مەنەشە و ئەفرایم بۆ یوسف لەدایک بوون لە ئاسنەتی کچی پۆتی‌فەرەعی کاهینی ئۆن. ");
INSERT INTO ckb_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","کوڕەکانی بنیامین: بەلەع، بەکەر، ئەشبێل، گێرا، نەعمان، ئێحی، ڕۆش، موپیم، حوپیم و ئەرد. ");
INSERT INTO ckb_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","ئەمانە کوڕەکانی ڕاحێلن کە بۆ یاقوبی بوون. هەموویان چواردە کەس بوون. ");
INSERT INTO ckb_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","کوڕەکەی دان: حوشیم. ");
INSERT INTO ckb_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","کوڕەکانی نەفتالی: یەحزئێل، گۆنی، یێچەر و شلێم. ");
INSERT INTO ckb_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","ئەمانە کوڕەکانی بیلهە بوون کە لابان دابووی بە ڕاحێلی کچی. ئەویش ئەمانەی بۆ یاقوب بوو. هەموویان حەوت کەس بوون. ");
INSERT INTO ckb_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","هەموو ئەوانەی لەگەڵ یاقوب هاتنە میسر و لە پشتی ئەوەوە دەرچووبوون، جگە لە ژنانی کوڕەکانی، شەست و شەش کەس بوون. ");
INSERT INTO ckb_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","بە هەردوو کوڕەکەی یوسفەوە کە لە میسر لەدایک ببوون، سەرجەمی کەسانی ماڵی یاقوب کە هاتنە میسر، حەفتا کەس بوون. ");
INSERT INTO ckb_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","یاقوب یەهودای لەپێش خۆیەوە نارد بۆ لای یوسف هەتا بەرەو گۆشەن ڕێنمایی بکات. ئینجا هاتنە ناوچەی گۆشەن. ");
INSERT INTO ckb_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","یوسف گالیسکەکەی خۆی بەستەوە و بەرەو گۆشەن هەڵکشا بۆ پێشوازیکردنی ئیسرائیلی باوکی. کە بینی دەستی لە ملی کرد و بۆ ماوەیەک گریا. ");
INSERT INTO ckb_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","ئیسرائیل بە یوسفی گوت: «ئێستا با بمرم، لەدوای ئەوەی ڕووی تۆم بینی و زانیم هێشتا زیندوویت.» ");
INSERT INTO ckb_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","ئینجا یوسف بە براکانی و ماڵی باوکی گوت: «دەچم و بە فیرعەون ڕادەگەیەنم، پێی دەڵێم: ”براکانم و ماڵی باوکم کە لە خاکی کەنعان بوون، هاتنە لام. ");
INSERT INTO ckb_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","پیاوەکانیش شوانی مەڕن، چونکە خاوەن ماڵاتن، جا مەڕ و مانگاکانیان و هەرچییان هەیە هێناویانە.“ ");
INSERT INTO ckb_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","ئینجا ئەگەر فیرعەون بانگی کردن و گوتی: ”کارتان چییە؟“ ");
INSERT INTO ckb_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","دەڵێن: ”خزمەتکارانت خاوەن ماڵاتن، لە منداڵیمانەوە هەتا ئێستا، خۆمان و باوباپیرانمان،“ بۆ ئەوەی لە ناوچەی گۆشەن نیشتەجێ ببن، چونکە میسرییەکان قێزیان لە هەموو شوانێکی مەڕ دەبێتەوە.» ");
INSERT INTO ckb_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","یوسف چوو و بە فیرعەونی گوت: «باوکم و براکانم، بە ڕانە مەڕ و مانگایان و هەرچی هەیانە، لە خاکی کەنعانەوە هاتوون، ئێستا ئەوان لە خاکی گۆشەنن.» ");
INSERT INTO ckb_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","لەنێو براکانی پێنج پیاوی برد و لەبەردەم فیرعەون ڕایگرتن. ");
INSERT INTO ckb_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","فیرعەونیش لە براکانی پرسی: «کارتان چییە؟» ئەوانیش بە فیرعەونیان گوت: «خزمەتکارانت شوانی مەڕن، خۆشمان و باوباپیرانیشمان.» ");
INSERT INTO ckb_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","هەروەها بە فیرعەونیان گوت: «هاتووین بۆ ئەوەی ماوەیەک لەم خاکە نیشتەجێ بین، چونکە لەوەڕگا نەماوە بۆ مەڕەکانی خزمەتکارانت، لەبەر ئەوەی قاتوقڕییەکە لە خاکی کەنعان سەختە، ئێستاش ڕێگا بدە با خزمەتکارانت لە خاکی گۆشەن نیشتەجێ بن.» ");
INSERT INTO ckb_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","فیرعەون لەگەڵ یوسف قسەی کرد و پێی گوت: «باوکت و براکانت هاتوون بۆ لای تۆ. ");
INSERT INTO ckb_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","خاکی میسر لەبەردەمتە، باوکت و براکانت لە باشترین خاک نیشتەجێ بکە. با لە خاکی گۆشەن نیشتەجێ بن. ئەگەر زانیشت لەنێویان کەسانی بە توانا هەیە، ئەوا بیانکە بە سەرکاری ئەو ماڵاتەی هی خۆمن.» ");
INSERT INTO ckb_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","ئینجا یوسف یاقوبی باوکی هێنایە ژوورەوە و بە فیرعەونی ناساند. یاقوبیش داوای بەرەکەتی بۆ فیرعەون کرد. ");
INSERT INTO ckb_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","فیرعەون بە یاقوبی گوت: «تەمەنت چەند ساڵە؟» ");
INSERT INTO ckb_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","یاقوبیش بە فیرعەونی گوت: «سەد و سی ساڵە گەڕۆکم. تەمەنم کەم و سەخت بووە، هێشتا تەمەنم تەمەنی گەڕۆکی باوباپیرانمی تێنەپەڕاندووە.» ");
INSERT INTO ckb_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","ئیتر یاقوب داوای بەرەکەتی بۆ فیرعەون کرد و لەلای فیرعەون هاتە دەرەوە. ");
INSERT INTO ckb_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","ئینجا یوسف بەپێی فەرمانی فیرعەون باوکی و براکانی لە خاکی میسر نیشتەجێ کرد و لە باشترین زەوی لە خاکی میسر، کە دەکاتە خاکی ڕەعمسێس، موڵکی پێدان. ");
INSERT INTO ckb_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","هەروەها یوسف خۆراکی بۆ باوک و براکانی و هەموو ماڵی باوکیشی بەپێی ژمارەی منداڵەکانیان دابین کرد. ");
INSERT INTO ckb_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","لە هەموو خاکەکەدا نان نەبوو، چونکە قاتوقڕییەکە زۆر سەخت بوو. خاکی میسر و کەنعان بەهۆی قاتوقڕییەکەوە لە کەڵک کەوتبوون. ");
INSERT INTO ckb_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","یوسف هەموو ئەو زیوەی کۆکردەوە کە خەڵکی میسر و کەنعان گەنمیان پێ دەکڕی. ئینجا زیوەکەی هێنایە ماڵی فیرعەون. ");
INSERT INTO ckb_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","کاتێک کە زیو لە خاکی میسر و لە خاکی کەنعان نەما، هەموو میسرییەکان هاتنە لای یوسف و گوتیان: «نانمان بۆ پێبدە! بۆچی لەبەردەمت بمرین؟ زیوەکان تەواو بوو.» ");
INSERT INTO ckb_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","یوسفیش پێی گوتن: «ئەگەر زیو تەواو بووە، ماڵاتەکانتان بهێنن. لە جیاتی ماڵاتەکانتان، نانتان دەدەمێ.» ");
INSERT INTO ckb_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","ئینجا ماڵاتەکانیان بۆ یوسف هێنا. ئەویش لە بەرامبەر ئەسپ، مەڕ، بزن، چێڵ و گوێدرێژەکانیان نانی پێدان. ئیتر بە درێژایی ئەو ساڵە لە بەرامبەر هەموو ماڵاتەکانیان نانی دان. ");
INSERT INTO ckb_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","کە ئەو ساڵە تەواو بوو، بۆ ساڵی دووەم هاتنەوە بۆ لای و پێیان گوت: «لە گەورەمانی ناشارینەوە زیوەکانمان تەواو بوون، ماڵاتەکانیشمان لەلای گەورەمانە، ئیتر هیچ لەپێش گەورەمان نەماوە تەنها لەشمان و زەوییەکەمان نەبێت. ");
INSERT INTO ckb_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","بۆچی خۆمان و زەوییەکەشمان لەپێش چاوت بمرین؟ بە نان خۆمان و زەوییەکەمان بکڕە، ئیتر خۆمان و زەوییەکەشمان دەبینە کۆیلەی فیرعەون. تۆویشمان بدەرێ بۆ ئەوەی بژین و نەمرین، با زەوییەکەشمان نەبێتە چۆڵەوانی.» ");
INSERT INTO ckb_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","یوسفیش هەموو خاکی میسری بۆ فیرعەون کڕی. خەڵکی میسر تەواوی کێڵگەکانیان فرۆشت، لەبەر ئەوەی قاتوقڕییەکە زۆر سەخت بوو لەسەریان. ئیتر خاکەکە بووە هی فیرعەون. ");
INSERT INTO ckb_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","یوسف خەڵکەکەشی لەم سەری میسرەوە هەتا ئەو سەری کردە کۆیلە. ");
INSERT INTO ckb_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","تەنها زەوی کاهینەکانی نەکڕی، چونکە کاهینەکان لەلایەن فیرعەونەوە بەشە خۆراکیان هەبوو، ئیتر بەشە خۆراکەکەی خۆیان دەخوارد کە فیرعەون دەیدانێ. لەبەر ئەوە زەوییەکەی خۆیان نەفرۆشت. ");
INSERT INTO ckb_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","ئینجا یوسف بە خەڵکەکەی گوت: «ئێستا کە خۆتان و زەوییەکەتانم بۆ فیرعەون کڕیوە، ئەوە تۆو، بڕۆن و لە زەوی بیچێنن. ");
INSERT INTO ckb_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","بەڵام لە کاتی خەرماندا پێنج یەکی خەرمانەکەتان دەدەنە فیرعەون. چوار بەشەکەی دیکە بۆ خۆتان دەبێت، بۆ بنەتۆ و بۆ خۆراکی خۆتان و ئەوانەی لە ماڵەکانتانن و بۆ خۆراکی منداڵەکانتان.» ");
INSERT INTO ckb_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","ئەوانیش گوتیان: «تۆ ئێمەت بە زیندوویی هێشتەوە. ئەگەر گەورەمان لێمان ڕازی بێت، ئێمە کۆیلەی فیرعەونین.» ");
INSERT INTO ckb_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","ئیتر یوسف ئەمەی لەسەر خاکی میسر کردە یاسا، کە هەتا ئەمڕۆش پێنج یەکی بەرهەمی کشتوکاڵ بۆ فیرعەونە. ئەم یاسایە تەنها زەوی کاهینەکانی نەگرتەوە، چونکە نەبووە هی فیرعەون. ");
INSERT INTO ckb_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","نەوەی ئیسرائیل لە خاکی میسر لە ناوچەی گۆشەن نیشتەجێ بوون. لەوێ بوونە خاوەن موڵک و گەشەیان کرد، زۆریش زیادیان کرد. ");
INSERT INTO ckb_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","یاقوب حەڤدە ساڵ لە خاکی میسر ژیانی بردە سەر. هەموو تەمەنی یاقوب بووە سەد و چل و حەوت ساڵ. ");
INSERT INTO ckb_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","کە کاتی مردنی ئیسرائیل نزیک بووەوە، یوسفی کوڕی بانگکرد و پێی گوت: «ئەگەر جێی ڕەزامەندیتم ئەوا دەستت بخەرە ژێر ڕانمەوە و چاکە و وەفاداریم لەگەڵ بکە، لە میسر مەمنێژە، ");
INSERT INTO ckb_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","بەڵکو کاتێک لەگەڵ باوباپیرانم ڕادەکشێم، لە میسرەوە هەڵمبگرە و لە گۆڕستانی ئەواندا بمنێژە.» ئەمیش گوتی: «داواکارییەکەت جێبەجێ دەکەم.» ");
INSERT INTO ckb_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","ئەویش پێی گوت: «سوێندم بۆ بخۆ.» یوسفیش سوێندی بۆ خوارد. ئیسرائیلیش لەسەر قەرەوێڵەکەی کڕنۆشی برد. ");
INSERT INTO ckb_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","ئەوە بوو دوای ئەمانە بە یوسف گوترا: «باوکت نەخۆشە.» ئەویش مەنەشە و ئەفرایمی کوڕی لەگەڵ خۆی برد. ");
INSERT INTO ckb_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","بە یاقوب ڕاگەیەنرا و گوترا: «وا یوسفی کوڕت هاتووە بۆ لات.» ئیسرائیلیش هێزی دایە بەرخۆی و لەسەر قەرەوێڵەکە دانیشت. ");
INSERT INTO ckb_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","ئینجا یاقوب بە یوسفی گوت: «خودای هەرە بەتوانام لە لوزی خاکی کەنعان بۆ دەرکەوت و بەرەکەتداری کردم. ");
INSERT INTO ckb_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","پێی فەرمووم: ”وا من بەردارت دەکەم و ژمارەت زۆر دەکەم و دەتکەمە چەندین نەتەوە. ئەم خاکەش بە موڵکی هەتاهەتایی لەدوای خۆت دەدەمە نەوەکەت.“ ");
INSERT INTO ckb_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","«ئێستاش دوو کوڕەکەت کە پێش هاتنی من بۆ لات بۆ خاکی میسر بۆت لەدایک بوون، بۆ من دەبن. واتا ئەفرایم و مەنەشە وەک ڕەئوبێن و شیمۆن دەبن بۆم. ");
INSERT INTO ckb_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","بەڵام منداڵەکانی دیکەت کە لەدوای ئەمانەوە لەدایک دەبن، دەبنە هی تۆ و لەژێر ناوی دوو براکەیان بەشە میراتیان دەبێت. ");
INSERT INTO ckb_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","کاتێک لە پەدان دەگەڕامەوە، لە ڕێگا لە خاکی کەنعان کە هێندەم نەمابوو بگەمە ئەفرات، ڕاحێل مرد، هەر لەوێ لەسەر ڕێگای ئەفرات ناشتم،» واتا لە بێت‌لەحم. ");
INSERT INTO ckb_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","ئینجا ئیسرائیل دوو کوڕەکەی یوسفی بینی و گوتی: «ئەمانە کێن؟» ");
INSERT INTO ckb_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","یوسفیش بە باوکی گوت: «ئەوانە دوو کوڕەکەی منن کە خودا لێرە پێی بەخشیوم.» ئەمیش گوتی: «بیانهێنە لام تاکو داوای بەرەکەتیان بۆ بکەم.» ");
INSERT INTO ckb_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","هەردوو چاوی ئیسرائیل بەهۆی پیرییەوە کز ببوون و پەکی بینینیان کەوتبوو. بۆیە یوسف هەردووکیانی هێنایە لای، ئەویش ماچی کردن و باوەشی پێدا کردن. ");
INSERT INTO ckb_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","ئینجا ئیسرائیل بە یوسفی گوت: «چاوەڕوان نەبووم ڕووی تۆ ببینم، کەچی ئێستا خودا نەوەکەی تۆشی نیشان دام.» ");
INSERT INTO ckb_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","یوسف هەردووکیانی لەنێوان ئەژنۆی دەرهێنا و لەبەردەمی کڕنۆشی برد و سەری خستە سەر زەوی. ");
INSERT INTO ckb_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","ئینجا یوسف دەستی دایە هەردووکیان، ئەفرایمی لەلای ڕاستی خۆی بەرامبەر دەستی چەپی ئیسرائیل و مەنەشەشی لەلای چەپی خۆی بەرامبەر دەستی ڕاستی ئیسرائیل و لێ نزیک کردنەوە. ");
INSERT INTO ckb_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","بەڵام ئیسرائیل دەستی ڕاستی خۆی درێژکرد و خستییە سەر سەری ئەفرایم، کە بچووکەکەیان بوو، دەستی چەپیشی خستە سەر سەری مەنەشە، دەستەکانی ژیرانە دانا، چونکە مەنەشە نۆبەرەکە بوو. ");
INSERT INTO ckb_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","ئینجا داوای بەرەکەتی بۆ یوسف کرد و گوتی: «ئەو خودایەی کە باوانم دۆستایەتییان لەگەڵی کرد، ئیبراهیم و ئیسحاق، ئەو خودایەی کە شوانایەتی کردووم لە بوونمەوە هەتا ئەمڕۆ، ");
INSERT INTO ckb_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","ئەو فریشتەیەی لە هەموو خراپەیەک منی کڕییەوە، ئەم دوو کوڕە بەرەکەتدار بکات. با بە ناوی خۆم و بە ناوی باوانم ئیبراهیم و ئیسحاقەوە ناوببرێن، با لەناو خاکەکەش زۆر زیاد بن.» ");
INSERT INTO ckb_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","کە یوسف بینی باوکی دەستی ڕاستی خستووەتە سەر سەری ئەفرایم، ئەوەی پێ ناخۆش بوو، ئیتر دەستی باوکی گرت تاکو لەسەر سەری ئەفرایمەوە بیخاتە سەر سەری مەنەشە. ");
INSERT INTO ckb_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","یوسف بە باوکی گوت: «ئاوا نا، باوکە، چونکە ئەمە نۆبەرەکەیە، دەستی ڕاستی خۆت بخەرە سەر سەری.» ");
INSERT INTO ckb_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","بەڵام باوکی ڕازی نەبوو و گوتی: «دەزانم کوڕی خۆم، دەزانم. هەروەها ئەویش دەبێتە نەتەوەیەک و مەزنیش دەبێت. بەڵام برا بچووکەکەی لەو مەزنتر دەبێت و نەوەشی دەبێتە چەندین نەتەوە.» ");
INSERT INTO ckb_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","ئیتر لەو ڕۆژەدا داوای بەرەکەتی بۆ کردن و گوتی: «بە ناوی تۆوە نەوەی ئیسرائیل داوای ئەم بەرەکەتە دەکات: ”خودا وەک ئەفرایم و مەنەشەت لێ بکات.“» بەو شێوەیە ئەفرایمی خستە پێش مەنەشە. ");
INSERT INTO ckb_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","ئیسرائیل بە یوسفی گوت: «ئەوا دەمرم، بەڵام خودا لەگەڵتان دەبێت و دەتانگەڕێنێتەوە خاکی باوباپیرانتان. ");
INSERT INTO ckb_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","منیش بەشێک زیاتر لە بەشی براکانت دەدەمە تۆ، ئەوەی بە شمشێرەکەم و کەوانەکەم لە چنگی ئەمۆرییەکان وەرمگرت.» ");
INSERT INTO ckb_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","ئینجا یاقوب کوڕەکانی خۆی بانگکرد و گوتی: «کۆببنەوە تاکو پێتان بڵێم کە لە ڕۆژانی داهاتوودا چیتان بەسەردێت. ");
INSERT INTO ckb_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","«ئەی کوڕانی یاقوب، کۆببنەوە و گوێ بگرن، گوێ لە ئیسرائیلی باوکتان بگرن. ");
INSERT INTO ckb_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","«ڕەئوبێن، تۆ نۆبەرەکەی منیت، هێزی منیت و یەکەم توانامیت، سەری شانازی و سەری هێزی. ");
INSERT INTO ckb_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","هەڵچوو وەک ئاو، باڵادەست نابیت، چونکە چوویتە سەر پێخەفەکەی باوکت، گڵاوت کرد، سەرکەوتیتە سەر نوێنەکەم. ");
INSERT INTO ckb_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","«شیمۆن و لێڤی بران، بە چەکی توندوتیژی چەکدارن. ");
INSERT INTO ckb_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","من ناچمە ناو کۆڕی ڕاوێژیان، سەنگینی من یەک ناگرێتەوە لەگەڵ کۆمەڵەکەیان، چونکە لە کاتی تووڕەبوونیاندا مرۆڤیان کوشت و لە خۆشیشیاندا گایان لە پێ خست. ");
INSERT INTO ckb_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","نەفرەت لە تووڕەییان کەوا توندە، لە هەڵچوونیان کەوا سەختە. لەناو یاقوب بەشیان دەکەم و لەناو ئیسرائیل بڵاوەیان پێ دەکەم. ");
INSERT INTO ckb_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","«یەهودا، براکانت ستایشی تۆ دەکەن، دەستت لەسەر پشتەملی دوژمنانت دەبێت، کوڕانی باوکیشت کڕنۆشت بۆ دەبەن. ");
INSERT INTO ckb_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","بەچکە شێرە یەهودا، لەسەر نێچیر گەڕایتەوە، کوڕی خۆم. خۆی نوشتاندەوە، خۆی مات دا، وەک شێر، وەک شێرە مێ، کێ هەڵیدەستێنێت؟ ");
INSERT INTO ckb_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","داردەستەکە لە یەهودا دانابڕێت، گۆچانی فەرمانکردنیش لەنێوان قاچەکانی، هەتا ئەو کەسە دێت کە خاوەنیەتی، گەلان هەر بۆ ئەو ملکەچ دەبن. ");
INSERT INTO ckb_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","نێرەکەرەکەی بە دار مێو دەبەستێتەوە و ماکەرەکەی بە باشترین لقە مێوەوە. جلەکانی لەناو شەراب دەشوات و پۆشاکەکەی لەناو خوێنی ترێ. ");
INSERT INTO ckb_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","چاوەکانی لە شەراب تۆخترن و ددانەکانی لە شیر سپیترن. ");
INSERT INTO ckb_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","«زەبولون لە کەناری دەریا نیشتەجێ دەبێت، دەبێتە بەندەری کەشتییەکان، سنووریشی هەتا سەیدا دەبێت. ");
INSERT INTO ckb_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","«یەساخار نێرەکەرێکی زەبەلاحە و لەنێوان دوو هەگبە مات بووە. ");
INSERT INTO ckb_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","بینی شوێنێکی باشە بۆ پشوودان و زەوییەکەی دڵگیرە، شانی دەچەمێتەوە بۆ بار و دەبێتە کۆیلەی کاری زۆرەملێ. ");
INSERT INTO ckb_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","«دان دادوەری گەلەکەی خۆی دەکات، وەک یەکێک لە هۆزەکانی ئیسرائیل. ");
INSERT INTO ckb_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","دان مارێک دەبێت لەسەر ڕێگا، مارێکی ژەهراوی لەسەر ڕێڕەو، بە پاژنەی ئەسپەوە دەدات و سوارەکەی بەرەو دواوە بەردەبێتەوە. ");
INSERT INTO ckb_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","«ئەی یەزدان، چاوەڕێی ڕزگاریی تۆم. ");
INSERT INTO ckb_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","«چەتە پەلاماری گاد دەدەن، بەڵام ئەو دەگاتە پاژنەی پێیان و پەلاماریان دەدات. ");
INSERT INTO ckb_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","«لە ئاشێر نانی چەور دەبێت، ئەو خواردنی چەور و بەتام دەداتە پاشایان. ");
INSERT INTO ckb_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","«نەفتالی ئاسکێکی دەرپەڕیوە و بەچکەی جوانی دەبێت. ");
INSERT INTO ckb_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","«یوسف مێوێکی بەردارە، مێوێکی بەردارە لەسەر کانیاو، چڵەکانی بەسەر دیوارێکدا هەڵگەڕاون. ");
INSERT INTO ckb_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","تیرئەندازان دڕندانە پەلاماریان دا و ڕمیان تێگرت و هەراسانیان کرد. ");
INSERT INTO ckb_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","بەڵام کەوانەکەی بە توندوتۆڵی مایەوە، بازووەکانی دەستی لێزان بوون، بە دەستی توانادارەکەی یاقوب، بە ناوی شوانەکە، تاشەبەردەکەی ئیسرائیل، ");
INSERT INTO ckb_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","بەهۆی خوداکەی باوکتەوە کە یارمەتیت دەدات، بەهۆی هەرە بەتواناوە کە بەرەکەتدارت دەکات، بە بەرەکەتەکانی ئاسمان لە سەرەوە و بەرەکەتەکانی ئەو قووڵاییەی ماتە لە ژێرەوە، بەرەکەتەکانی هەردوو مەمک و منداڵدان. ");
INSERT INTO ckb_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","بەرەکەتەکانی باوکت مەزنترن لە بەرەکەتەکانی چیای هەتاهەتایی، لە بەخشندەیی گردە دێرینەکان. با بەسەر سەری یوسفەوە بن، بەسەر ناوچەوانی جیاکراوە لە براکانی. ");
INSERT INTO ckb_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","«بنیامین گورگێکی دڕندەیە، بەیانییان نێچیر دەخوات و ئێوارانیش دەستکەوت دابەش دەکات.» ");
INSERT INTO ckb_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","هەموو ئەمانە دوازدە هۆزەکەی ئیسرائیلن. ئەمەش ئەوە بوو کە باوکیان پێی گوتن و داوای بەرەکەتی بۆ کردن، هەریەکەیان بەپێی بەرەکەتەکەی خۆی داوای بەرەکەتی بۆ کردن. ");
INSERT INTO ckb_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","ئینجا فەرمانی پێدان و پێی گوتن: «من دەچمە پاڵ گەلەکەی خۆم. لەلای باوباپیرانم بمنێژن، لەو ئەشکەوتەی لەناو کێڵگەکەی عەفرۆنی حیتییە، ");
INSERT INTO ckb_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","کە لە کێڵگەکەی مەخپێلەیە و ڕووەو مەمرێیە لە خاکی کەنعان، ئەوەی ئیبراهیم لەگەڵ کێڵگەکەدا لە عەفرۆنی حیتی کڕی تاکو بیکات بە گۆڕستان. ");
INSERT INTO ckb_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","ئیبراهیم و سارای ژنی لەوێ نێژراون، ئیسحاق و ڕڤقەی ژنیشی لەوێ نێژراون، هەر لەوێش لێئەم ناشت. ");
INSERT INTO ckb_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","کێڵگەکە و ئەشکەوتەکەی ناوی لە حیتییەکان کڕدرابوون.» ");
INSERT INTO ckb_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","کاتێک یاقوب لە ڕاسپاردنی کوڕەکانی تەواو بوو، هەردوو پێی خۆی خستەوە سەر قەرەوێڵەکە و دواهەناسەی دا و چووەوە پاڵ گەلەکەی خۆی. ");
INSERT INTO ckb_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","یوسف خۆی دا بەسەر ڕووی باوکیدا و بەسەریدا گریا و ماچی کرد. ");
INSERT INTO ckb_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","ئینجا یوسف فەرمانی دا بە خزمەتکارە پزیشکەکانی کە باوکی مۆمیا بکەن. پزیشکەکانیش ئیسرائیلیان مۆمیا کرد. ");
INSERT INTO ckb_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","مۆمیاکردنەکە چل ڕۆژی پێچوو، چونکە بەوەندە ڕۆژە کارەکە تەواو دەبوو. میسرییەکانیش حەفتا ڕۆژ بۆی گریان. ");
INSERT INTO ckb_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","کە ڕۆژانی گریان بەسەرچوو، یوسف لەگەڵ ماڵی فیرعەون قسەی کرد و گوتی: «ئەگەر جێی ڕەزامەندیتانم، ئەوا قسە لەگەڵ فیرعەون بکەن و پێی بڵێن، ");
INSERT INTO ckb_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","کە باوکم سوێندی داوم و گوتوویەتی: ”وا من دەمرم، لەو گۆڕەدا بمنێژن کە لە خاکی کەنعان بۆ خۆمم هەڵکەندووە.“ ئێستاش ڕێگام بدە کە بچم باوکم بنێژم و بگەڕێمەوە.» ");
INSERT INTO ckb_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","فیرعەونیش پێی گوت: «بڕۆ و بەو جۆرەی سوێندی داویت، باوکت بنێژە.» ");
INSERT INTO ckb_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","ئیتر یوسف بۆ ناشتنی باوکی چوو. لەگەڵی هەموو خزمەتکارانی فیرعەون، پیرانی ماڵەکەی و هەموو پیرانی خاکی میسر چوون، ");
INSERT INTO ckb_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","لەگەڵ تێکڕای ماڵی یوسف و براکانی و ماڵی باوکی. تەنها منداڵەکان و ڕانە مەڕ و گاگەلیان لە خاکی گۆشەن بەجێهێشت. ");
INSERT INTO ckb_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","کۆمەڵێکی زۆر گالیسکە و ئەسپ سواریش لەگەڵی چوون. ");
INSERT INTO ckb_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","ئینجا گەیشتنە سەر جۆخینەکەی ئاتاد، کە لەوبەری ڕووباری ئوردونە، لەوێ شیوەنێکی زۆر گەورە و توندیان گێڕا. یوسف حەوت ڕۆژ ماتەمی بۆ باوکی دانا. ");
INSERT INTO ckb_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","کاتێک کەنعانییەکانی دانیشتووی ئەو خاکە ئەم ماتەمەیان لەسەر جۆخینەکەی ئاتاد بینی، گوتیان: «ئەمە ماتەمێکی گەورەی میسرییەکانە.» لەبەر ئەوە ناونرا ئابێل میسرایم کە لەوبەری ڕووباری ئوردونە. ");
INSERT INTO ckb_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","کوڕەکانی یاقوبیش چۆنی ڕاسپاردبوون ئاوایان بۆ کرد. ");
INSERT INTO ckb_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","جا کوڕەکانی هەڵیانگرت و بردیان بۆ خاکی کەنعان و لە ئەشکەوتەکەی ئەو کێڵگەیەی لە مەخپێلە ناشتیان، ئەوەی کە ڕووەو مەمرێیە و ئیبراهیم لەگەڵ کێڵگەکە لە عەفرۆنی حیتی کڕی تاکو بیکات بە گۆڕستان. ");
INSERT INTO ckb_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","ئیتر یوسف و براکانی و هەموو ئەوانەی لەگەڵی بۆ ناشتنی باوکی چوون، دوای ناشتنی باوکی گەڕانەوە بۆ میسر. ");
INSERT INTO ckb_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","کاتێک براکانی یوسف بینییان باوکیان مرد، گوتیان: «نەکات یوسف قینمان لێ هەڵبگرێت و هەموو ئەو خراپەیەی بەرامبەری کردوومانە بەسەرمانی بهێنێتەوە.» ");
INSERT INTO ckb_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","ئیتر پەیامیان بۆ یوسف نارد و گوتیان: «باوکت پێش مردنی ڕایسپاردووین و گوتوویەتی: ");
INSERT INTO ckb_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","”ئاوا بە یوسف دەڵێن: داواکارم لێت لە تاوانی براکانت و گوناهەکەیان ببوریت، چونکە خراپەیان لەگەڵت کرد.“ ئێستاش لە تاوانی بەندەکانی خودای باوکت خۆشبە.» کاتێک پەیامەکەیان گەیشت، یوسف دەستی بە گریان کرد. ");
INSERT INTO ckb_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","دوای ئەوە براکانی هاتن و لەبەردەمیدا کەوتن و گوتیان: «ئەوەتاین، ئێمە کۆیلەی تۆین.» ");
INSERT INTO ckb_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","بەڵام یوسف پێی گوتن: «مەترسن. ئایا من لە جێی خودام؟ ");
INSERT INTO ckb_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","مەبەستی ئێوە خراپە بوو بۆم، بەڵام خودا کردی بە چاکە تاکو وەک ئەمڕۆ بکات، بۆ بە زیندوو هێشتنەوەی خەڵکێکی زۆر. ");
INSERT INTO ckb_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","ئێستاش مەترسن. من خۆتان و منداڵەکانتان بەخێو دەکەم.» ئیتر دڵنەوایی کردن و قسەی دڵخۆشکەرەی بۆ کردن. ");
INSERT INTO ckb_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","یوسف خۆی و ماڵی باوکی لە میسر نیشتەجێ بوون. یوسف سەد و دە ساڵ ژیا ");
INSERT INTO ckb_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","و منداڵەکانی ئەفرایمیشی بینی، کە دەکاتە نەوەی سێیەم. هەروەها ئەوەندە ژیا کە منداڵەکانی ماکیری کوڕی مەنەشەی بینی ناوی ئەویان وەرگرتووە. ");
INSERT INTO ckb_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","ئینجا یوسف بە براکانی گوت: «من دەمرم، بەڵام خودا خۆی بەسەرتان دەکاتەوە و لەم خاکەوە دەتانباتەوە ئەو خاکەی کە بە سوێند بەڵێنی داوە بیداتە ئیبراهیم و ئیسحاق و یاقوب.» ");
INSERT INTO ckb_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","ئیتر یوسف نەوەی ئیسرائیلی سوێند دا و گوتی: «بێگومان خودا بەسەرتان دەکاتەوە، دەبێت ئێوەش لێرەوە ئێسقانەکانم ببەنەوە.» ");
INSERT INTO ckb_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","دوای ئەوە یوسف لە تەمەنی سەد و دە ساڵیدا مرد. ئیتر مۆمیایان کرد و لە میسر خرایە تابووتەوە.");
INSERT INTO ckb_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","ئەمانە ناوی کوڕەکانی ئیسرائیلن کە لەگەڵ یاقوب چوونە میسر، هەریەک لەگەڵ خێزانەکەی: ");
INSERT INTO ckb_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","ڕەئوبێن، شیمۆن، لێڤی و یەهودا، ");
INSERT INTO ckb_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","یەساخار، زەبولون و بنیامین، ");
INSERT INTO ckb_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","دان و نەفتالی، گاد و ئاشێر. ");
INSERT INTO ckb_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","هەموو وەچەکانی یاقوب حەفتا کەس بوون، بێجگە لە یوسف کە لە میسر بوو. ");
INSERT INTO ckb_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","یوسف و هەموو براکانی و هەموو ئەو نەوەیە مردن، ");
INSERT INTO ckb_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","بەڵام نەوەی ئیسرائیل بەردار بوون، زۆر زیاد بوون و زۆر و توانادارتر بوون، خاکەکە پڕ بوو لەوان. ");
INSERT INTO ckb_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","ئینجا لە میسر پاشایەکی نوێ هاتە سەر تەخت کە یوسفی نەدەناسی. ");
INSERT INTO ckb_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","بە گەلەکەی گوت: «تەماشا بکەن، نەوەی ئیسرائیل گەلێکن لە ئێمە زۆرتر و بەتواناترن. ");
INSERT INTO ckb_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","وەرن با دانا بین، نەوەک زۆرتریش ببن، کاتێک بکەوینە جەنگەوە، ئەوان بچنە پاڵ دوژمنەکانمان و لە دژمان بجەنگن و ئەم خاکە بەجێبهێڵن.» ");
INSERT INTO ckb_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","بۆیە سەرکاری بێگارییان لەسەر دانان، بۆ ئەوەی بە بارگرانییەکەیان زەلیلیان بکەن، ئیتر شارەکانی پیتۆم و ڕەعمسێسیان بۆ ئەمبارکردن بۆ فیرعەون بنیاد نا. ");
INSERT INTO ckb_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","بەڵام هەرچەندە زەلیلیان دەکردن ئەوەندە گەشەیان دەکرد و بەربڵاو دەبوون، ئیتر لەبەر ئەوە میسرییەکان بەرامبەر بە نەوەی ئیسرائیل ترسیان لێ نیشت. ");
INSERT INTO ckb_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","میسرییەکان بە زەبرەوە کۆیلایەتییان بە نەوەی ئیسرائیل دەکرد. ");
INSERT INTO ckb_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","ژیانیان تاڵ کردن بە کۆیلایەتییەکی سەخت، بە قوڕکاری و خشت دروستکردن و هەموو جۆرە کارێکی کێڵگە، هەموو کارێک کە پێیان دەکردن بە زەبرەوە بوو. ");
INSERT INTO ckb_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","پاشای میسر بە دوو مامانی ژنە عیبرانییەکانی گوت، کە ناوی یەکێکیان شیفرە و ئەوی دیکەیان پوعە بوو، ");
INSERT INTO ckb_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","گوتی: «کاتێک مامانی بۆ ژنە عیبرانییەکان دەکەن لە شوێنی منداڵبوون، تەماشایان بکەن، ئەگەر کوڕ بێت بیکوژن، بەڵام ئەگەر کچ بێت با بژیێت.» ");
INSERT INTO ckb_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","بەڵام مامانەکان لە خودا ترسان و ئەوەیان نەکرد کە پاشای میسر پێی گوتبوون، هێشتیان کوڕەکان بژین. ");
INSERT INTO ckb_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","دواتر پاشای میسر مامانەکانی بانگکرد و لێی پرسین: «بۆچی ئەمەتان کردووە؟ بۆ هێشتتان کوڕەکان بژین؟» ");
INSERT INTO ckb_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","مامانەکانیش وەڵامی فیرعەونیان دایەوە: «لەبەر ئەوەی ژنە عیبرانییەکان وەک ژنە میسرییەکان نین، ئەوان گورجوگۆڵن و پێش گەیشتنی مامان منداڵیان دەبێت.» ");
INSERT INTO ckb_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","ئیتر خودا لەگەڵ مامانەکان باش بوو، گەلیش زۆر و بە توانا بوون. ");
INSERT INTO ckb_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","ئەوە بوو کە مامانەکان لە خودا ترسان، خوداش خێزانی پێ بەخشین. ");
INSERT INTO ckb_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","ئینجا فیرعەون فەرمانی بە هەموو گەلەکەی دا و گوتی: «هەر کوڕێکی عیبرانی کە لە دایک دەبێت، فڕێیبدەنە ناو ڕووباری نیل، بەڵام با هەموو کچەکان بژین.» ");
INSERT INTO ckb_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","پیاوێک لە بنەماڵەی لێڤی کچێکی لێڤی هێنا. ");
INSERT INTO ckb_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","ژنەکە سکی پڕ بوو و کوڕێکی بوو، کە بینی منداڵەکە جوانە، سێ مانگ شاردییەوە. ");
INSERT INTO ckb_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","بەڵام کاتێک نەیتوانی لەوە زیاتر بیشارێتەوە، سەبەتەیەکی لە زەل دروستکراوی هێنا و بە قیر و زفت سواخی دا و کوڕەکەی لەناو دانا، ئینجا لە کەناری نیل لەناو قامیشەڵان داینا. ");
INSERT INTO ckb_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","خوشکی منداڵەکەش لە دوورەوە وەستا بۆ ئەوەی بزانێت چی لێدێت. ");
INSERT INTO ckb_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","کچی فیرعەونیش کە بۆ خۆشوشتن هاتە خوارەوە بۆ سەر ڕووباری نیل و کەنیزەکانیشی لەسەر کەناری نیل هاتوچۆیان دەکرد، سەبەتەکەی لەناو قامیشەڵانەکە بینی و کچە خزمەتکارەکەی نارد تاکو بیهێنێت. ");
INSERT INTO ckb_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","ئەویش کردییەوە و تەماشای منداڵەکەی کرد، بینی کوڕێکە و دەگریێ، بەزەیی پێدا هاتەوە و گوتی: «ئەمە یەکێکە لە منداڵی عیبرانییەکان.» ");
INSERT INTO ckb_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","خوشکی منداڵەکەش لە کچی فیرعەونی پرسی: «ئایا بچم ژنێکی شیردەری عیبرانیت بۆ بانگ بکەم بۆ ئەوەی شیر بە منداڵەکە بدات؟» ");
INSERT INTO ckb_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","کچی فیرعەونیش وەڵامی دایەوە: «بڕۆ.» کچە عازەبەکەش چوو دایکی منداڵەکەی بانگکرد. ");
INSERT INTO ckb_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","کچی فیرعەونیش پێی گوت: «ئەم منداڵە ببە و شیری بدە بۆم، منیش کرێیەکەت دەدەمێ.» ژنەش منداڵەکەی برد و شیری دایێ. ");
INSERT INTO ckb_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","کاتێک منداڵەکە گەورە بوو، بۆ کچی فیرعەونی هێنایەوە، ئیتر بوو بە کوڕی ئەو و ناوی لێنا «موسا» و گوتی: «لەبەر ئەوەی لەناو ئاو هەڵمگرتووەتەوە.» ");
INSERT INTO ckb_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","کاتێک موسا گەورە بوو، ڕۆژێکیان چووە دەرەوە بۆ لای براکانی و سەیری بارگرانییەکانی کرد و بینی پیاوێکی میسری لە پیاوێکی عیبرانیی برای دەدات. ");
INSERT INTO ckb_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","ئەویش تەماشای ئەم لا و ئەو لای کرد و بینی کەسی لێ نییە، ئیتر میسرییەکەی کوشت و لەناو لم شاردییەوە. ");
INSERT INTO ckb_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","بۆ ڕۆژی دووەم چووە دەرەوە و بینی دوو پیاوی عیبرانی شەڕ دەکەن. لە خەتابارەکەی پرسی: «بۆچی لە هاوەڵەکەت دەدەیت؟» ");
INSERT INTO ckb_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","ئەویش گوتی: «کێ تۆی کردووە بە گەورە و دادوەر بەسەرمانەوە؟ ئایا دەتەوێ بمکوژیت هەروەک میسرییەکەت کوشت؟» جا موسا ترسا و گوتی: «بێگومان ئەم کارە زانراوە!» ");
INSERT INTO ckb_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","کاتێک فیرعەون گوێی لەمە بوو، هەوڵی دا موسا بکوژێت، بەڵام موسا لە دەست فیرعەون هەڵات و لە خاکی میدیان جێگیر بوو، لەلای بیرێک دانیشت. ");
INSERT INTO ckb_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","کاهینی میدیانیش حەوت کچی هەبوو، هاتن و ئاویان هەڵکێشا، ئاخوڕەکانیان پڕکرد بۆ ئاودانی مەڕەکانی باوکیان. ");
INSERT INTO ckb_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","لەو کاتەدا شوان هاتن و دەریانکردن، بەڵام موسا هەستا و فریایان کەوت و مەڕەکانی ئاودان. ");
INSERT INTO ckb_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","کچەکانیش هاتنە لای ڕەعوئێلی باوکیان، ئەویش لێی پرسین: «بۆچی ئەمڕۆ زوو هاتنەوە؟» ");
INSERT INTO ckb_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","ئەوانیش وەڵامیان دایەوە: «پیاوێکی میسری فریامان کەوت لە دەست شوانەکان، هەروەها ئاوی بۆ کێشاین و مەڕەکانیشی ئاو دا.» ");
INSERT INTO ckb_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","ئەویش بە کچەکانی گوت: «ئەی لەکوێیە؟ بۆ پیاوەکەتان بەجێهێشت؟ بانگهێشتی بکەن با نان بخوات.» ");
INSERT INTO ckb_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","موسا ڕازی بوو لەگەڵ ئەو پیاوە بمێنێتەوە. ئەویش چیپۆرەی کچی دایە موسا. ");
INSERT INTO ckb_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","چیپۆرەش کوڕێکی بوو، موساش ناوی لێنا گێرشۆم، چونکە گوتی: «نامۆ بووم لە خاکی بێگانە.» ");
INSERT INTO ckb_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","ئەوە بوو لەو ماوە درێژە، پاشای میسر مرد. نەوەی ئیسرائیلیش ئاهیان هەڵکێشا لە دەست کۆیلایەتی و هاواریان کرد بۆ یارمەتی، گریانەکەیان بەهۆی کۆیلایەتییەوە بۆ خودا بەرزبووەوە. ");
INSERT INTO ckb_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","خوداش گوێی لە ناڵەیان بوو و پەیمانەکەی خۆی لەیاد بوو لەگەڵ ئیبراهیم و ئیسحاق و یاقوب. ");
INSERT INTO ckb_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","ئیتر خودا ڕوانییە نەوەی ئیسرائیل و بایەخی پێدان. ");
INSERT INTO ckb_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","موسا بووە شوانی مەڕەکانی یەترۆی خەزووری، کە کاهینی میدیان بوو. مەڕەکانی بردە ئەوپەڕی دەشتودەرەکە هەتا گەیشتە کێوی خودا، حۆرێڤ. ");
INSERT INTO ckb_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","لەوێ لەناو گڕی ئاگرێک لە دەوەنێک فریشتەی یەزدانی بۆ دەرکەوت. کە موسا تەماشای کرد بینی وا دەوەنەکە گڕی گرتووە، کەچی ناسووتێت. ");
INSERT INTO ckb_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","موسا گوتی: «لادەدەم و تەماشای ئەو دیمەنە مەزنە دەکەم. بۆچی دەوەنەکە ناسووتێت؟» ");
INSERT INTO ckb_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","کاتێک یەزدان بینی کە موسا لایدا بۆ ئەوەی تەماشا بکات، خودا لەناو دەوەنەکەوە بانگی کرد و فەرمووی: «موسا. موسا.» ئەویش گوتی: «ئەوەتام.» ");
INSERT INTO ckb_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","فەرمووی: «نزیکی ئێرە مەکەوە. پێڵاوەکانت لە پێت دابکەنە، چونکە ئەو شوێنەی تۆ لەسەری وەستاویت خاکێکی پیرۆزە.» ");
INSERT INTO ckb_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","ئینجا فەرمووی: «من خودای باوکتم، خودای ئیبراهیم و خودای ئیسحاق و خودای یاقوبم.» موسا ڕووی خۆی داپۆشی، چونکە دەترسا تەماشای خودا بکات. ");
INSERT INTO ckb_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","یەزدان فەرمووی: «بەڕاستی من زەلیلی گەلەکەمم لە میسر بینی، هەروەها گوێم لە هاواریان بوو لەبەر سەرکارەکانیان، چونکە بە ئازارەکانیانم زانی. ");
INSERT INTO ckb_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","ئەوا هاتمە خوارەوە بۆ ئەوەی فریایان بکەوم لە دەست میسرییەکان و لەو خاکەوە بیانبەم بۆ خاکێکی باش و فراوان، بۆ خاکێک شیر و هەنگوینی لێ دەڕژێت، بۆ شوێنی کەنعانی، حیتی، ئەمۆری، پریزی، حیڤی و یەبوسییەکان. ");
INSERT INTO ckb_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","ئێستا هاواری نەوەی ئیسرائیل گەیشتە لام و هەروەها ئەو چەوسانەوەیەم بینی کە بە دەست میسرییەکان دەیچێژن. ");
INSERT INTO ckb_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","ئێستاش بڕۆ و دەتنێرم بۆ لای فیرعەون و گەلەکەی خۆم، نەوەی ئیسرائیل لە میسر بهێنە دەرەوە.» ");
INSERT INTO ckb_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","بەڵام موسا بە خودای گوت: «من کێم هەتا بچمە لای فیرعەون و نەوەی ئیسرائیل لە میسر بهێنمە دەرەوە؟» ");
INSERT INTO ckb_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","ئەویش فەرمووی: «من لەگەڵت دەبم، ئەمەش دەبێتە نیشانە بۆت کە من تۆم ناردووە، کاتێک گەل لە میسرەوە دەردەهێنیت، ئێوە لەسەر ئەم کێوە خودا دەپەرستن.» ");
INSERT INTO ckb_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","موساش بە خودای گوت: «من وا دەچمە لای نەوەی ئیسرائیل و پێیان دەڵێم ”خودای باپیرانتان منی بۆ ئێوە ناردووە.“ ئەگەر پێم بڵێن: ”ناوی چییە،“ بڵێم چی؟» ");
INSERT INTO ckb_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","خوداش بە موسای فەرموو: «من هەم ئەوەی کە هەم.» هەروەها فەرمووی: «ئاوا بە نەوەی ئیسرائیل دەڵێیت: ” ’هەم‘ منی بۆ ئێوە ناردووە.“» ");
INSERT INTO ckb_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","هەروەها خودا بە موسای فەرموو: «ئاوا بە نەوەی ئیسرائیل دەڵێیت: ”یەزدان، پەروەردگاری باوکانتان، خودای ئیبراهیم و خودای ئیسحاق و خودای یاقوب منی بۆ ئێوە ناردووە.“ «هەتاهەتایە ئەمە ناومە و ئەمەش دێتەوە یادتان، نەوە دوای نەوە. ");
INSERT INTO ckb_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","«بڕۆ و پیرانی ئیسرائیل کۆبکەرەوە و پێیان بڵێ: ”یەزدان، پەروەردگاری باوکانتان، خودای ئیبراهیم و ئیسحاق و یاقوب بۆم دەرکەوت، فەرمووی، بەڕاستی ئێوە و ئەوەی لە میسردا بەسەرتان هاتووە بەسەرم کردووەتەوە. ");
INSERT INTO ckb_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","هەروەها بەڵێنم داوە، لە زەلیلی میسر سەرتان بخەم و بتانبەم بۆ خاکی کەنعانی، حیتی، ئەمۆری، پریزی، حیڤی و یەبوسییەکان، بۆ خاکێک شیر و هەنگوینی لێ دەڕژێت.“ ");
INSERT INTO ckb_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","«پیرانی ئیسرائیل گوێ لە قسەکانت دەگرن. ئەو کاتە تۆ و پیرانی ئیسرائیل دەچنە لای پاشای میسر و پێی دەڵێن: ”یەزدان، پەروەردگاری عیبرانییەکان بەسەریکردینەوە، ئێستاش سێ ڕۆژەڕێ دەڕۆین لە دەشتودەر قوربانی بۆ یەزدانی پەروەردگارمان سەردەبڕین.“ ");
INSERT INTO ckb_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","بەڵام دەزانم پاشای میسر ناهێڵێت بڕۆن، تاوەکو بە دەستێکی بەهێز ناچار نەکرێت. ");
INSERT INTO ckb_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","ئیتر من دەستم درێژ دەکەم و بە هەموو کارە سەرسوڕهێنەرەکانم کە لەناویاندا دەیکەم، لە میسر دەدەم، دوای ئەوە دەهێڵێت بڕۆن. ");
INSERT INTO ckb_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","«ئەم گەلەش لەبەرچاوی میسرییەکان ڕێزدار دەکەم، هەتا کاتی ڕۆیشتن بە دەستبەتاڵی نەڕۆن. ");
INSERT INTO ckb_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","بەڵکو هەر ژنێک لە دراوسێکەی یاخود لەوەی لە ماڵەکەیدا دەژیێت، داوای کەلوپەلی زێڕ و زیو و جلوبەرگ دەکات و لەبەر کوڕ و کچەکانتانی دەکەن و میسرییەکان تاڵان دەکەن.» ");
INSERT INTO ckb_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","موسا وەڵامی دایەوە و گوتی: «ئەی ئەگەر بڕوایان پێ نەکردم و گوێیان لە قسەکانم نەگرت و گوتیان ”یەزدان بۆت دەرنەکەوتووە“؟» ");
INSERT INTO ckb_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","یەزدانیش پێی فەرموو: «ئەوە چییە لە دەستت؟» ئەویش گوتی: «گۆچان.» ");
INSERT INTO ckb_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","فەرمووی: «فڕێیبدە سەر زەوی.» ئەویش فڕێیدایە سەر زەوی و بوو بە مار. ئیتر موسا لەبەری هەڵات. ");
INSERT INTO ckb_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","ئینجا یەزدان بە موسای فەرموو: «دەست درێژبکە و کلکی بگرە.» جا دەستی درێژکرد و گرتی و بووەوە بە گۆچان لە دەستیدا. ");
INSERT INTO ckb_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","«بۆ ئەوەی بڕوا بکەن کە یەزدان بۆت دەرکەوتووە، خودای باوکانیان، خودای ئیبراهیم و خودای ئیسحاق و خودای یاقوب.» ");
INSERT INTO ckb_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","هەروەها یەزدان پێی فەرموو: «دەستت بخەرە ناو باخەڵت.» ئەویش دەستی خستە ناو باخەڵی و دەریهێنایەوە، بینی دەستی گول بووە و وەک بەفری لێهاتووە. ");
INSERT INTO ckb_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","ئینجا فەرمووی: «دەستت بخەرەوە ناو باخەڵت.» ئەویش دەستی خستەوە ناو باخەڵی، ئینجا لەناو باخەڵی دەریهێنایەوە، بینی وەک هەموو بەشەکانی لەشی لێهاتووەتەوە. ");
INSERT INTO ckb_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","«بەم شێوەیە ئەگەر بڕوایان پێ نەکردیت و گرنگی بە نیشانەی یەکەم نەدا، ئەوا گرنگی بە نیشانەی دووەم دەدەن. ");
INSERT INTO ckb_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","بەڵام ئەگەر بڕوایان بەو دوو نیشانەیە نەکرد و گوێیان لە قسەکانت نەگرت، ئەوا تۆ هەندێک لە ئاوی نیل دەبەیت و لەسەر وشکانی دەیڕێژیت، ئیتر ئەو ئاوەی لە نیلەوە دەیبەیت، لەسەر وشکانی دەبێتە خوێن.» ");
INSERT INTO ckb_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","موسا بە یەزدانی گوت: «ئەی پەروەردگار، من پیاوی قسە نیم، نە لە ڕابردوو و نە لەو کاتەوەی لەگەڵ خزمەتکارەکەت دوایت. بەڵکو من دەم گران و زمان گرانم.» ");
INSERT INTO ckb_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","یەزدانیش پێی فەرموو: «کێ دەمی بۆ مرۆڤ دروستکردووە، یان کێ لاڵ یان کەڕ، بینا یان نابینای دروستکردووە، ئایا منی یەزدان نیم؟ ");
INSERT INTO ckb_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","ئێستا بڕۆ، منیش لەگەڵ زمانت دەبم و ئەوەت فێر دەکەم کە پێی دەدوێیت.» ");
INSERT INTO ckb_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","بەڵام ئەو گوتی: «ئەی پەروەردگار ببورە، کەسێکی دیکە بنێرە.» ");
INSERT INTO ckb_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","تووڕەیی یەزدان بەسەر موسادا جۆشا و فەرمووی: «ئایا هارونی لێڤی برات نییە، دەزانم ئەو قسەزانە، هەروەها ئەو ئێستا وا لە ڕێگایە بۆ پێشوازیت، کاتێک دەتبینێت دڵخۆش دەبێت. ");
INSERT INTO ckb_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","لەگەڵی دەدوێیت و وتەکان دەخەیتە سەر زمانی، منیش لەگەڵ زمانی تۆ و زمانی ئەو دەبم و فێرتان دەکەم چی بکەن. ");
INSERT INTO ckb_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","ئەو لە جیاتی تۆ لەگەڵ گەل دەدوێت، ئەو بۆ تۆ وەک دەم دەبێت و تۆش بۆ ئەو وەک خودا. ");
INSERT INTO ckb_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","ئەم گۆچانەش کە نیشانەکانی پێدەکەیت، لە دەستت دەیگریت.» ");
INSERT INTO ckb_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","ئینجا موسا چوو و گەڕایەوە لای یەترۆی خەزووری، پێی گوت: «من دەڕۆم و دەگەڕێمەوە لای براکانی خۆم کە لە میسرن، بۆ ئەوەی ببینم ئایا هێشتا زیندوون.» یەترۆش بە موسای گوت: «بڕۆ بە سەلامەتی.» ");
INSERT INTO ckb_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","یەزدان لە میدیان بە موسای فەرمووبوو: «بڕۆ و بگەڕێوە بۆ میسر، چونکە هەموو ئەوانەی بەدوای کوشتنتدا دەگەڕان مردن.» ");
INSERT INTO ckb_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","ئیتر موسا ژنەکەی و منداڵەکانی هەڵگرت و سواری گوێدرێژی کردن و بردنی و گەڕایەوە بۆ خاکی میسر. موسا گۆچانەکەی خوداشی لە دەستی گرت. ");
INSERT INTO ckb_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","یەزدان بە موسای فەرموو: «کاتێک دەگەڕێیتەوە میسر، سەرنجی هەموو ئەو پەرجووانە بدە کە لەسەر دەستی تۆ لەبەردەم فیرعەوندا دەکرێن، بەڵام من دڵی ڕەق دەکەم بۆ ئەوەی نەهێڵێت گەلەکە بڕۆن. ");
INSERT INTO ckb_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","بە فیرعەون دەڵێیت: ”یەزدان ئەمە دەفەرموێت: نەوەی ئیسرائیل کوڕە نۆبەرەمە، ");
INSERT INTO ckb_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","پێم فەرمووی، ’بهێڵە کوڕەکەم بچێت بۆ ئەوەی بمپەرستێت.‘ بەڵام تۆ ڕازی نەبوویت بهێڵیت بڕوات، من وا کوڕەکەت، نۆبەرەکەت دەکوژم.“» ");
INSERT INTO ckb_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","ئەوە بوو لە ڕێگا، لەو شوێنەی بۆ شەومانەوە لێی وەستان، یەزدان تووشی هات و ویستی بیکوژێت. ");
INSERT INTO ckb_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","بەڵام چیپۆرە بەردەئەستێیەکی هەڵگرت و کوڕەکەی خەتەنە کرد و پارچە گۆشتەکەی لە پێیەکانی دا و گوتی: «بێگومان تۆ زاوای خوێنی بۆ من.» ");
INSERT INTO ckb_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","ئیتر یەزدان وازی لێ هێنا، لەو کاتەش چیپۆرە گوتی، «زاوای خوێن،» لەبەر خەتەنەکردنەکە. ");
INSERT INTO ckb_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","یەزدان بە هارونی فەرموو: «بڕۆ چۆڵەوانی بۆ پێشوازی موسا.» ئەویش چوو و لە کێوی خودا تووشی بوو و ماچی کرد. ");
INSERT INTO ckb_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","ئیتر موسا هەموو فەرمایشتەکانی یەزدانی بە هارون ڕاگەیاند کە موسای ناردبوو بۆی، هەروەها هەموو ئەو نیشانانەی فەرمانی ئەنجامدانی پێدابوو. ");
INSERT INTO ckb_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","موسا و هارون چوون و هەموو پیرانی نەوەی ئیسرائیلیان کۆکردەوە. ");
INSERT INTO ckb_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","هارون هەموو فەرمایشتەکانی یەزدان کە بە موسای فەرمووبوو پێی ڕاگەیاندن و لەبەرچاوی گەل نیشانەکانی کرد. ");
INSERT INTO ckb_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","ئیتر گەل باوەڕیان هێنا، کاتێک گوێیان لێبوو یەزدان نەوەی ئیسرائیلی بەسەرکردووەتەوە و تەماشای زەلیلییەکەیانی کردووە، دانەوینەوە و کڕنۆشیان برد. ");
INSERT INTO ckb_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","دواتر موسا و هارون هاتن و بە فیرعەونیان گوت: «یەزدانی پەروەردگاری ئیسرائیل وا دەفەرموێت: ”بهێڵە گەلەکەم بڕۆن، بۆ ئەوەی لە چۆڵەوانی جەژنم بۆ بگێڕن.“» ");
INSERT INTO ckb_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","فیرعەونیش گوتی: «یەزدان کێیە هەتا گوێ لە قسەی بگرم و بهێڵم ئیسرائیل بڕۆن؟ یەزدان ناناسم و هەروەها ناهێڵم نەوەی ئیسرائیل بڕۆن.» ");
INSERT INTO ckb_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","ئەوانیش گوتیان: «خودای عیبرانییەکان بەسەری کردینەوە، سێ ڕۆژەڕێ لە چۆڵەوانی دەڕۆین و قوربانی بۆ یەزدانی پەروەردگارمان سەردەبڕین، نەوەک تووشی دەرد یان شمشێرمان بکات.» ");
INSERT INTO ckb_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","بەڵام پاشای میسر پێی گوتن: «موسا و هارون، بۆچی گەل لە ئیش دەکەن؟ بڕۆن بەلای بارگرانییەکەتانەوە.» ");
INSERT INTO ckb_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","هەروەها فیرعەون گوتی: «ئەوەتا ئێستا گەلی خاکەکە زۆرن و ئێوە لە بارگرانییەکەیان دەیانحەسێننەوە.» ");
INSERT INTO ckb_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","هەر لەو ڕۆژە فیرعەون فەرمانی دا بەوانەی بێگاری بە گەل دەکەن و بەوانەش کە سەرکارن و گوتی: ");
INSERT INTO ckb_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","«ئیتر وەک پێشتر کا مەدەنە گەل بۆ خشت دروستکردن، با خۆیان بچن و کا بۆ خۆیان کۆبکەنەوە. ");
INSERT INTO ckb_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","بەڵام ئەوەندە خشتەی کە پێشتر دروستیان دەکرد با هەر لەسەریان بێت، کەمی مەکەنەوە، چونکە ئەوانە تەمبەڵن، لەبەر ئەوەیە هاوار دەکەن: ”بهێڵە با بڕۆین و قوربانی بۆ خودامان سەرببڕین.“ ");
INSERT INTO ckb_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","با کارەکە قورستر بێت لەسەر خەڵکەکە، هەتا پێی سەرقاڵ بن و ئاوڕ لە قسەی درۆ نەدەنەوە.» ");
INSERT INTO ckb_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","ئیتر ئەوانەی بێگارییان پێ دەکردن و سەرکارەکانی خەڵک چوونە دەرەوە و بە گەلیان گوت: «فیرعەون ئاوا دەڵێت: ”ئیتر کاتان نادەمێ، ");
INSERT INTO ckb_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","بڕۆن بۆ خۆتان لەکوێ کا پەیدا دەکەن پەیدای بکەن، بەڵام هیچ لە کارەکانیشتان کەم ناکرێتەوە.“» ");
INSERT INTO ckb_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","ئیتر خەڵکەکە لە هەموو خاکی میسر بڵاو بوونەوە بۆ پووش کۆکردنەوە لە جیاتی کا. ");
INSERT INTO ckb_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","سەرکارانیش پەلەیان لێ دەکردن و دەیانگوت: «کاری ڕۆژانەکەتان تەواو بکەن، هەر ڕۆژە بەشی خۆی، هەروەک پێشتر کاتێک کا هەبوو.» ");
INSERT INTO ckb_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","ئیتر سەرکارەکانی نەوەی ئیسرائیل لێیان درا، ئەوانەی کە سەرکارەکانی فیرعەون لەسەریان دایاننابوون، لێیان پرسین: «بۆچی ئەرکی خۆتان لە خشت دروستکردن تەواو نەکردووە وەک پێشتر، دوێنێ و هەروەها ئەمڕۆش؟» ");
INSERT INTO ckb_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","سەرکارەکانی نەوەی ئیسرائیلیش هاتن هاواریان بۆ فیرعەون هێنا و گوتیان: «بۆچی وا لە خزمەتکارەکانت دەکەیت؟ ");
INSERT INTO ckb_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","کا نادرێتە خزمەتکارەکانت و لەگەڵ ئەوەشدا پێمان دەگوترێت ”خشت دروستبکەن!“ ئەوەتا خزمەتکارەکانت لێیان دراوە، بەڵام هەڵەکە لە گەلی خۆتەوەیە.» ");
INSERT INTO ckb_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","ئەویش گوتی: «تەمبەڵن! ئێوە تەمبەڵن، لەبەر ئەوەیە دەڵێن: ”دەچین و قوربانی بۆ یەزدان سەردەبڕین.“ ");
INSERT INTO ckb_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","ئێستاش بڕۆن کار بکەن، کاشتان نادرێتێ و لەگەڵ ئەوەشدا پێویستە ژمارەی خشتە قوڕەکان وەک جاران بێت.» ");
INSERT INTO ckb_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","سەرکارەکانی نەوەی ئیسرائیل بینییان تێکەوتوون، چونکە پێیان گوترا: «لە خشتەکەتان کەم ناکرێتەوە، هەر ڕۆژە و بەشی خۆی.» ");
INSERT INTO ckb_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","کە لەلای فیرعەون هاتنە دەرەوە تووشی موسا و هارون بوون چاوەڕێیان دەکردن. ");
INSERT INTO ckb_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","پێیان گوتن: «حەواڵەی یەزدانتان دەکەین با خۆی حوکم بدات، چونکە ئێوە ئێسک گرانتان کردین لەبەرچاوی فیرعەون و خزمەتکارەکانی، شمشێرتان دایە دەستی بۆ کوشتنمان.» ");
INSERT INTO ckb_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","موسا گەڕایەوە لای یەزدان و گوتی: «پەروەردگار بۆ خراپەت لەگەڵ ئەم گەلە کرد؟ بۆچی منت نارد؟ ");
INSERT INTO ckb_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","لەو کاتەوەی چوومە لای فیرعەون بە ناوی تۆوە بدوێم، ئەو خراپەی لەگەڵ ئەم گەلە کرد، تۆش فریای گەلەکەت نەکەوتیت.» ");
INSERT INTO ckb_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","یەزدانیش بە موسای فەرموو: «ئێستا دەبینیت چی بە فیرعەون دەکەم، بە دەستێکی بەهێز ناچاری دەکەم بەڕەڵایان بکات، ناچاری دەکەم لە خاکی خۆی دەریانبکات.» ");
INSERT INTO ckb_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","هەروەها خودا لەگەڵ موسا دوا و پێی فەرموو: «من یەزدانم، ");
INSERT INTO ckb_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","بۆ ئیبراهیم و ئیسحاق و یاقوب وەک ”خودای هەرە بەتوانا“ دەرکەوتم، بەڵام بە ناوی خۆم کە ”یەزدان“ە لەلای ئەوان خۆمم نەناساند. ");
INSERT INTO ckb_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","هەروەها پەیمانی خۆمم لەگەڵیان چەسپاند، کە خاکی کەنعانیان بدەمێ، خاکی نامۆییان کە تێیدا نامۆ بوون. ");
INSERT INTO ckb_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","هەروەها گوێم لە ناڵەی نەوەی ئیسرائیل بوو، ئەوانەی میسرییەکان کۆیلایەتییان پێ دەکەن، منیش پەیوەستم بە پەیمانەکەی خۆم. ");
INSERT INTO ckb_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","«بۆیە بە نەوەی ئیسرائیل بڵێ: ”من یەزدانم، لەژێر بارگرانی میسرییەکان دەرتاندەهێنم، لە کۆیلایەتی ئەوان فریاتان دەکەوم و بە دەستێکی بەهێز و دادپەروەرییەکی مەزن دەتانکڕمەوە. ");
INSERT INTO ckb_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","هەروەها دەتانکەم بە گەلی خۆم و دەبمە خودای ئێوە، ئیتر ئێوە دەزانن کە من یەزدانی پەروەردگارتانم ئەوەی لەژێر بارگرانی میسرییەکان دەرتاندەهێنێت. ");
INSERT INTO ckb_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","دەشتانبەم بۆ ئەو خاکەی سوێندم خوارد بیدەمە ئیبراهیم و ئیسحاق و یاقوب، وەک میرات دەیدەمە ئێوە، من یەزدانم.“» ");
INSERT INTO ckb_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","موسا بەم شێوەیە لەگەڵ نەوەی ئیسرائیل قسەی کرد، بەڵام گوێیان لێ نەگرت، لەبەر بێ ورەیی و کۆیلایەتی سەخت. ");
INSERT INTO ckb_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","ئینجا یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","«بڕۆ و بە فیرعەونی پاشای میسر بڵێ، با ڕێ بە نەوەی ئیسرائیل بدات خاکەکەی بەجێبهێڵن.» ");
INSERT INTO ckb_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","بەڵام موسا بە یەزدانی گوت: «ئەگەر نەوەی ئیسرائیل گوێم لێ نەگرن، ئیتر چۆن فیرعەون گوێم لێ دەگرێت، کە من زمانم بەستراوە؟» ");
INSERT INTO ckb_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","یەزدان سەبارەت بە نەوەی ئیسرائیل و فیرعەونی پاشای میسر لەگەڵ موسا و هارون دوا و فەرمانی پێدان نەوەی ئیسرائیل لە خاکی میسر ببەنە دەرەوە. ");
INSERT INTO ckb_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","ئەمانەش گەورەی بنەماڵەکانیانن: نەوەی ڕەئوبێن کە نۆبەرەی ئیسرائیلە، حەنۆک و پەڵو و حەسرۆن و کەرمی، لەمانیشەوە خێڵەکانی ڕەئوبێن دروستبوون. ");
INSERT INTO ckb_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","نەوەی شیمۆنیش یەموئێل و یامین و ئۆهەد و یاکین چۆحەر، هەروەها شائوول کە لە ژنێکی کەنعانی بوو، لەمانیشەوە خێڵەکانی شیمۆن دروستبوون. ");
INSERT INTO ckb_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","ئەمانەش ناوەکانی نەوەی لێڤین بەگوێرەی لەدایکبوونیان: گێرشۆن و قەهات و مەراری. تەمەنی لێڤیش سەد و سی و حەوت ساڵ بوو. ");
INSERT INTO ckb_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","کوڕانی گێرشۆن، لیبنی و شیمعی بەگوێرەی خێڵەکانیان. ");
INSERT INTO ckb_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","نەوەی قەهاتیش، عەمرام و یەسهار و حەبرۆن و عوزیێل. تەمەنی قەهاتیش سەد و سی و سێ ساڵ بوو. ");
INSERT INTO ckb_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","کوڕانی مەراریش، مەحلی و موشی. ئەمانەش خێڵەکانی لێڤییەکانن بەگوێرەی نەوەکانیان. ");
INSERT INTO ckb_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","عەمرام یۆخەڤەدی خوشکی باوکی بۆ خۆی خواست. ئەویش هارون و موسای لێ بوو. تەمەنی عەمرامیش سەد و سی و حەوت ساڵ بوو. ");
INSERT INTO ckb_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","نەوەی یەسهاریش: قۆرەح و نەفەگ و زکری. ");
INSERT INTO ckb_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","نەوەی عوزیێلیش: میشائیل و ئەلسافان و سیتری. ");
INSERT INTO ckb_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","هارونیش ئەلیشەڤەعی کچی عەمینادابی خوشکی نەحشۆنی خواست، ئەویش ناداب و ئەبیهو و ئەلعازار و ئیتاماری بوو. ");
INSERT INTO ckb_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","نەوەی قۆرەحیش: ئەسسیر و ئەلقانە و ئەبیئاساف. ئەمانەش خێڵەکانی قۆرەحییەکانە. ");
INSERT INTO ckb_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","ئەلعازاری کوڕی هارونیش یەکێکی لە کچانی پووتیێل خواست، ئەویش فینەحاسی بوو. ئەمانە گەورەی بنەماڵەکانی لێڤییەکانن بەگوێرەی خێڵەکانیان. ");
INSERT INTO ckb_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","ئەمانە هارون و موسان کە یەزدان پێی فەرموون: «نەوەی ئیسرائیل لەسەر شێوەی لەشکرەکانیان لە خاکی میسر دەربهێنن.» ");
INSERT INTO ckb_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","ئەوان بوون لەگەڵ فیرعەونی پاشای میسر دوان بۆ دەرهێنانی نەوەی ئیسرائیل لە میسر، موسا و هارون بوون. ");
INSERT INTO ckb_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","ئەوە بوو ئەو ڕۆژەی یەزدان لە خاکی میسر لەگەڵ موسا دوا، ");
INSERT INTO ckb_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","یەزدان پێی فەرموو: «من یەزدانم، لەگەڵ فیرعەونی پاشای میسر بدوێ سەبارەت بە هەموو ئەوەی پێت دەڵێم.» ");
INSERT INTO ckb_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","بەڵام موسا بە یەزدانی گوت: «ئەوەتا من زمانم بەستراوە، چۆن فیرعەون گوێم لێ دەگرێت؟» ");
INSERT INTO ckb_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","یەزدان بە موسای فەرموو: «بڕوانە، تۆم وەک خودای فیرعەون لێکردووە و هارونی براشت وەک پێغەمبەری تۆ دەبێت. ");
INSERT INTO ckb_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","تۆ دەدوێیت بە هەموو ئەوەی فەرمانت پێ دەکەم، هارونی براشت لەگەڵ فیرعەون دەدوێت بۆ ئەوەی ڕێگا بە نەوەی ئیسرائیل بدات خاکەکەی بەجێبهێڵن. ");
INSERT INTO ckb_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","بەڵام من دڵی فیرعەون ڕەق دەکەم و نیشانە و پەرجووەکانم زیاتر دەکەم لە خاکی میسر. ");
INSERT INTO ckb_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","فیرعەون گوێتان لێ ناگرێت، منیش دەستم دەخەمە سەر میسر، لەشکرەکانیشم کە نەوەی ئیسرائیلی گەلەکەمن بە چەند حوکمێکی دادپەروەرانەی مەزن لە خاکی میسر دەردەهێنم. ");
INSERT INTO ckb_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","ئیتر میسرییەکانیش دەزانن کە من یەزدانم، کاتێک دەست بۆ میسر درێژ دەکەم و نەوەی ئیسرائیل لەنێویان دەردەهێنم.» ");
INSERT INTO ckb_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","موسا و هارونیش هەروەک یەزدان فەرمانی پێ کردبوون، ئاوایان کرد. ");
INSERT INTO ckb_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","موسا تەمەنی هەشتا ساڵ بوو، هارونیش هەشتا و سێ ساڵ بوو، کاتێک لەگەڵ فیرعەون قسەیان کرد. ");
INSERT INTO ckb_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","یەزدان بە موسا و هارونی فەرموو: ");
INSERT INTO ckb_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","«کاتێک فیرعەون لەگەڵتان دەدوێت و دەڵێت: ”پەرجوو بکەن،“ تۆ بە هارون دەڵێیت: ”گۆچانەکەت بگرە بە دەستەوە و فڕێیبدە پێش فیرعەون،“ ئیتر دەبێتە مارێکی شاخدار.» ");
INSERT INTO ckb_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","ئیتر موسا و هارون هاتنە لای فیرعەون، چۆن یەزدان فەرمانی پێ کردبوون ئاوایان کرد، هارون گۆچانەکەی فڕێدایە بەردەم فیرعەون و خزمەتکاران، بووە مارێکی شاخدار. ");
INSERT INTO ckb_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","فیرعەونیش بانگی دانایان و سیحربازانی کرد، ئیتر جادووگەرانی میسریش بە ئەفسونەکانیان هەمان شتیان کرد. ");
INSERT INTO ckb_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","هەریەکە گۆچانی خۆی فڕێدا و گۆچانەکانیان بوونە ماری شاخدار، بەڵام گۆچانەکەی هارون گۆچانەکانی ئەوانی هەڵلووشی. ");
INSERT INTO ckb_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","ئیتر فیرعەون دڵی ڕەق بوو و گوێی لێ نەگرتن، هەروەک یەزدان فەرمووی. ");
INSERT INTO ckb_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","دواتر یەزدان بە موسای فەرموو: «دڵی فیرعەون ڕەقە، ڕازی نییە ڕێ بە گەلەکە بدات. ");
INSERT INTO ckb_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","بەیانی بڕۆ لای فیرعەون، ئەو دەچێتە لای ئاوەکە، لە کەناری نیل بۆی ڕاوەستە و ئەو گۆچانەش کە بووە ماری شاخدار لە دەستت بگرە. ");
INSERT INTO ckb_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","پێی دەڵێیت: ”یەزدانی پەروەردگاری عیبرانییەکان منی بۆ لای تۆ نارد و فەرمووی، ڕێ بە گەلەکەم بدە با بڕۆن و لە چۆڵەوانی بمپەرستن، بەڵام هەتا ئێستا گوێ ناگریت. ");
INSERT INTO ckb_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","یەزدان ئەمە دەفەرموێت: بەمە دەزانیت کە من یەزدانم، ئەوەتا من بەو گۆچانەی بە دەستمەوەیە لە ئاوی نیل دەدەم و دەیگۆڕێت بۆ خوێن. ");
INSERT INTO ckb_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","ئەو ماسیانەش کە لەناو نیلن دەمرن و نیل بۆگەن دەبێت، میسرییەکان قێزیان دەبێتەوە لە ئاوی نیل بخۆنەوە.“» ");
INSERT INTO ckb_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","یەزدان بە موسای فەرموو: «بە هارون بڵێ: ”گۆچانەکەت لە دەست بگرە و دەستت بۆ سەر ئاوی میسرییەکان درێژ بکە، بۆ سەر جۆگە و نۆکەند و گۆماو و هەموو حەوزەکانیان“ بۆ ئەوەی ببنە خوێن. ئیتر خوێن لە هەموو خاکی میسر دەبێت، تەنانەت لە سەتڵی دارین و لە گۆزەی بەردین.» ");
INSERT INTO ckb_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","موسا و هارونیش ئاوایان کرد، وەک ئەوەی یەزدان فەرمانی پێ کردن. گۆچانەکەی بەرزکردەوە و ئاوی نیلی گۆڕی، لەبەرچاوی فیرعەون و خزمەتکارەکانی. هەموو ئاوی نیل گۆڕا و بوو بە خوێن. ");
INSERT INTO ckb_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","ماسییەکانی ناو نیلیش مردن و نیل بۆگەن بوو، میسرییەکانیش نەیانتوانی لە ئاوی نیل بخۆنەوە، خوێنیش هەموو خاکی میسری گرتەوە. ");
INSERT INTO ckb_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","جادووگەرە میسرییەکانیش بە ئەفسونەکانیان هەمان شتیان کرد، دڵی فیرعەونیش ڕەق بوو و گوێی لە موسا و هارون نەگرت، هەروەک یەزدان فەرمووی. ");
INSERT INTO ckb_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","ئینجا فیرعەون ڕووی وەرگێڕا و چووەوە ماڵەکەی خۆی و ئەمەی لە دڵ نەگرت. ");
INSERT INTO ckb_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","هەموو میسرییەکانیش دەوروبەری نیلیان هەڵدڕی بۆ ئاو هەتا بیخۆنەوە، چونکە نەیانتوانی لە ئاوی نیل بخۆنەوە. ");
INSERT INTO ckb_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","حەوت ڕۆژ تەواو بوو دوای ئەوەی یەزدان ئاوی نیلی گۆڕی. ");
INSERT INTO ckb_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","یەزدان بە موسای فەرموو: «بڕۆ لای فیرعەون و پێی بڵێ: ”یەزدان ئەمە دەفەرموێت: ڕێ بە گەلەکەم بدە بڕۆن بۆ ئەوەی بمپەرستن. ");
INSERT INTO ckb_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","ئەگەر ڕازی نەبیت و ڕێیان نەدەیت، هەموو خاکەکەت پڕدەبێت لە بۆق. ");
INSERT INTO ckb_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","ڕووباری نیل پڕدەبێت لە بۆق، سەردەکەون و دێنە ناو ماڵەکەت و ژووری نوستنەکەت و سەر قەرەوێڵەکەت، هەروەها دەچنە ماڵی خزمەتکارەکانت و سەر گەلەکەت و ناو تەنوورەکانت و تەشتە هەویرەکانت. ");
INSERT INTO ckb_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","بۆق دێتە سەر خۆت و گەلەکەت و خزمەتکارەکانت.“» ");
INSERT INTO ckb_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","ئینجا یەزدان بە موسای فەرموو: «بە هارون بڵێ: ”بە گۆچانەکەت دەست درێژبکە بۆ سەر جۆگە و نۆکەند و گۆماوەکان، بۆق سەربخە بۆ سەر خاکی میسر.“» ");
INSERT INTO ckb_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","هارونیش دەستی درێژکردە سەر ئاوی میسر، بۆق سەرکەوتن و خاکی میسریان داپۆشی. ");
INSERT INTO ckb_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","جادووگەرەکانیش بە ئەفسونەکانیان هەمان شتیان کرد، بۆقیان هێنایە سەر خاکی میسر. ");
INSERT INTO ckb_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","فیرعەون بانگی موسا و هارونی کرد و گوتی: «لە یەزدان بپاڕێنەوە بۆ ئەوەی بۆق لە خۆم و گەلەکەم دووربخاتەوە، منیش ڕێ بە گەلەکە دەدەم بڕۆن قوربانی بۆ یەزدان سەرببڕن.» ");
INSERT INTO ckb_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","موساش بە فیرعەونی گوت: «کاتێکم پێ بفەرموو کە بپاڕێمەوە لە پێناوی خۆت و خزمەتکارەکانت و گەلەکەت، بۆ بڕانەوەی بۆق لە تۆ و لە ماڵەکانت، بەڵام بۆق لە ڕووباری نیل دەمێننەوە.» ");
INSERT INTO ckb_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","ئەویش گوتی: «بەیانی.» موساش گوتی: «وەک ئەوە دەبێت کە گوتت، بۆ ئەوەی بزانیت کە هیچ خودایەک نییە وەک یەزدانی پەروەردگارمان. ");
INSERT INTO ckb_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","بۆقەکانیش لە خۆت و ماڵەکانت و خزمەتکارەکانت و گەلەکەت دوور دەکەونەوە، بەڵام لە ڕووباری نیل دەمێننەوە.» ");
INSERT INTO ckb_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","لەدوای ئەوەی موسا و هارون لەلای فیرعەون هاتنە دەرەوە، موسا هاواری بۆ یەزدان کرد لەبەر ئەو بۆقانەی کە وەک بەڵا بەسەر فیرعەونی هێنابوو. ");
INSERT INTO ckb_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","یەزدانیش بە قسەی موسای کرد، بۆقەکان لە ماڵ و حەوشە و کێڵگەکان مردن. ");
INSERT INTO ckb_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","کۆمەڵ کۆمەڵ کۆیان کردنەوە و خاکەکە گەندەڵ بوو. ");
INSERT INTO ckb_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","بەڵام کاتێک فیرعەون بینی خامۆشی هاتە کایەوە، دڵی ڕەق کردەوە و گوێی لە موسا و هارون نەگرت، هەروەک یەزدان فەرمووی. ");
INSERT INTO ckb_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","ئینجا یەزدان بە موسای فەرموو: «بە هارون بڵێ: ”گۆچانەکەت درێژ بکە و لە خۆڵی زەوی بدە،“ جا خۆلی زەوی لە هەموو خاکی میسر دەبێتە مێشوولە.» ");
INSERT INTO ckb_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","ئیتر ئاوایان کرد، هارون بە گۆچانەکەی دەستی درێژکرد و لە خۆڵی زەوییەکەی دا، مێشوولە هاتە سەر خەڵک و سەر ئاژەڵەکان، لە هەموو خاکی میسر هەموو خۆڵی زەوییەکە بوو بە مێشوولە. ");
INSERT INTO ckb_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","جادووگەرەکانیش بە ئەفسونەکانیان هەمان شتیان کرد بۆ پەیدابوونی مێشوولە، بەڵام نەیانتوانی. لەبەر ئەوەی مێشوولە لەسەر خەڵک و لەسەر ئاژەڵ مایەوە، ");
INSERT INTO ckb_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","جادووگەرەکان بە فیرعەونیان گوت: «ئەمە پەنجەی خودایە.» بەڵام فیرعەون دڵی ڕەق بوو و گوێی لێ نەگرتن، هەروەک یەزدان فەرمووی. ");
INSERT INTO ckb_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","ئینجا یەزدان بە موسای فەرموو: «بەیانی زوو هەستە و کە فیرعەون بەرەو ئاوەکە دەچێت لەبەردەمی ڕابوەستە و پێی بڵێ: ”یەزدان ئەمە دەفەرموێت: ڕێ بە گەلەکەم بدە با بڕۆن بمپەرستن. ");
INSERT INTO ckb_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","ئەگەر ڕێ بە گەلەکەم نەدەیت بڕۆن، ئەوا منیش مێشومەگەزێکی زۆر دەنێرمە سەر خۆت و خزمەتکارەکانت و گەلەکەت و ماڵەکانت، ئیتر ماڵی میسرییەکان پڕ دەبێت لە مێش، تەنانەت زەوییەکەش بە مێش دادەپۆشرێت. ");
INSERT INTO ckb_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","«”بەڵام لەو ڕۆژەدا خاکی گۆشەن جیا دەکەمەوە کە گەلەکەمی لەسەر دەژین، بۆ ئەوەی مێش لەوێدا نەبێت، هەتا بزانیت من یەزدانم لە ناوەڕاستی خاکەکەدا. ");
INSERT INTO ckb_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","جیاوازییەک لەنێوان گەلەکەم و گەلەکەت دادەنێم، بەیانی ئەم نیشانەیە دەبێت.“» ");
INSERT INTO ckb_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","یەزدانیش ئاوای کرد و مێشومەگەزێکی زۆر هاتنە ناو ماڵی فیرعەون و ماڵی خزمەتکارانی، لە هەموو خاکی میسریش زەوییەکە لەبەر مێش وێران بوو. ");
INSERT INTO ckb_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","ئینجا فیرعەون بانگی موسا و هارونی کرد و گوتی: «بڕۆن لەم خاکە قوربانی بۆ خوداتان سەرببڕن.» ");
INSERT INTO ckb_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","بەڵام موسا گوتی: «ڕاست نییە ئێمە وا بکەین، چونکە ئەو ئاژەڵانەی کە ئێمە بۆ یەزدانی پەروەردگارمان سەری دەبڕین لەلای میسرییەکان قێزەونە، ئەگەر ئەوەی لەلای میسرییەکان قێزەونە لەبەرچاویان سەری ببڕین، ئایا بەردبارانمان ناکەن؟ ");
INSERT INTO ckb_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","سێ ڕۆژەڕێ لە چۆڵەوانی دەڕۆین و قوربانی بۆ یەزدانی پەروەردگارمان سەردەبڕین، وەک پێمان دەڵێت.» ");
INSERT INTO ckb_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","فیرعەونیش گوتی: «من ڕێتان دەدەم بڕۆن و لە چۆڵەوانی قوربانی بۆ یەزدانی پەروەردگارتان سەرببڕن، بەڵام دوور مەڕۆن و بۆم بپاڕێنەوە.» ");
INSERT INTO ckb_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","موساش وەڵامی دایەوە: «من لەلای تۆ دەچمە دەرەوە و لە یەزدان دەپاڕێمەوە، ئیتر بۆ بەیانی مێش لە فیرعەون و لە خزمەتکارەکانی و لە گەلەکەی دوور دەکەونەوە، بەڵام ئیتر نابێت فیرعەون فێڵ بکات، هەتا ڕێ بە گەلەکە نەدات بڕۆن بۆ قوربانی سەربڕین بۆ یەزدان.» ");
INSERT INTO ckb_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","جا موسا لەلای فیرعەون هاتە دەرەوە و لە یەزدان پاڕایەوە. ");
INSERT INTO ckb_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","یەزدانیش بە قسەی موسای کرد، ئیتر مێش لە فیرعەون و لە خزمەتکارەکانی و لە گەلەکەی دوور کەوتنەوە و هیچیان نەما. ");
INSERT INTO ckb_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","بەڵام فیرعەون ئەم جارەش دڵی ڕەقکرد و ڕێی بە گەلەکە نەدا بڕۆن. ");
INSERT INTO ckb_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","یەزدان بە موسای فەرموو: «بڕۆ لای فیرعەون و پێی بڵێ کە یەزدانی پەروەردگاری عیبرانییەکان ئەمە دەفەرموێت: ”ڕێ بە گەلەکەم بدە با بڕۆن بمپەرستن.“ ");
INSERT INTO ckb_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","ئەگەر ڕێیان نەدەیت و بەردەوام نەهێڵیت بڕۆن، ");
INSERT INTO ckb_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","ئەوا یەزدان دەردێکی زۆر گران دەهێنێتە سەر مەڕوماڵاتەکانت کە لە کێڵگەن، بۆ سەر ئەسپ و گوێدرێژ و وشتر و گا و مانگا و مەڕ و بزن. ");
INSERT INTO ckb_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","بەڵام یەزدان جیاوازی دەکات لەنێوان مەڕوماڵاتی نەوەی ئیسرائیل و مەڕوماڵاتی میسرییەکان، هیچ ئاژەڵێکی نەوەی ئیسرائیل نامرێت.» ");
INSERT INTO ckb_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","یەزدان کاتێکی دیاری کرد و فەرمووی، «بەیانی یەزدان ئەم کارە لە زەوییەکەدا دەکات.» ");
INSERT INTO ckb_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","بۆ بەیانی یەزدان ئەم کارەی کرد و هەموو مەڕوماڵاتی میسرییەکان مردن، بەڵام لە ئاژەڵی نەوەی ئیسرائیل یەکێکیشیان نەمرد. ");
INSERT INTO ckb_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","فیرعەونیش ناردی و بینییان تەنانەت یەک ئاژەڵی نەوەی ئیسرائیل نەمردووە، بەڵام هێشتا دڵی فیرعەون ڕەق بوو و ڕێی بە گەلەکە نەدا بڕۆن. ");
INSERT INTO ckb_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","ئینجا یەزدان بە موسا و هارونی فەرموو: «بە پڕی دەستەکانتان خوڵەمێشی تەنوور بۆ خۆتان ببەن و با موسا لەبەرچاوی فیرعەون بەرەو ئاسمان بەبای بکات. ");
INSERT INTO ckb_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","دەبێتە تۆزوبا لە هەموو خاکی میسر، دەبێتە دومەڵی کێم دەرپەڕیو لە هەموو خاکی میسر بۆ مرۆڤ و ئاژەڵ.» ");
INSERT INTO ckb_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","ئیتر خوڵەمێشی تەنووریان برد و لە بەرامبەر فیرعەون وەستان، موسا بەرەو ئاسمان بەبای کرد و بووە دومەڵی کێمی دەرپەڕیو لە مرۆڤ و لە ئاژەڵ. ");
INSERT INTO ckb_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","جادووگەرەکانیش نەیانتوانی لە بەرامبەر موسا بوەستن لەبەر دومەڵەکان، چونکە دومەڵەکان لە جادووگەرەکان و لە هەموو میسرییەکانی دا. ");
INSERT INTO ckb_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","بەڵام یەزدان دڵی فیرعەونی ڕەقکرد و گوێی لە موسا و هارون نەگرت، هەروەک یەزدان بە موسای فەرموو. ");
INSERT INTO ckb_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","یەزدان بە موسای فەرموو: «بەیانی زوو هەستە و لە بەرامبەر فیرعەون بوەستە و پێی بڵێ: ”یەزدانی پەروەردگاری عیبرانییەکان ئەمە دەفەرموێت: ڕێ بە گەلەکەم بدە بچن بمپەرستن. ");
INSERT INTO ckb_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","ئەگینا ئەم جارە هەموو گورزەکانم بۆ دڵت و بۆ سەر خزمەتکارەکانت و بۆ سەر گەلەکەت دەنێرم، بۆ ئەوەی بزانیت لە هەموو زەوی هیچ کەسێک وەک من نییە. ");
INSERT INTO ckb_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","دەمتوانی دەستم درێژ بکەم و خۆت و گەلەکەت تووشی دەرد بکەم و لەسەر ڕووی زەوی بتانسڕمەوە. ");
INSERT INTO ckb_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","بەڵام لەبەر ئەوە تۆم هێشتووەتەوە بۆ ئەوەی توانای خۆمت پیشان بدەم تاکو لە هەموو زەویدا ناوم ڕابگەیەنرێت. ");
INSERT INTO ckb_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","تۆ هێشتا خۆت بە زل دەزانیت لەسەر گەلەکەم و ڕێیان نادەیت بڕۆن. ");
INSERT INTO ckb_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","لەبەر ئەوە بەیانی ئەم کاتە تەرزەیەکی زۆر مەزن دەبارێنم کە لە میسر هاوتای نەبووبێت، لە ڕۆژی دامەزراندنییەوە هەتا ئێستا. ");
INSERT INTO ckb_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","ئێستاش بنێرە و مەڕوماڵاتەکەت و هەموو ئەو شتانەی کە هەتە و لە کێڵگەیە بیانپارێزە، هەموو خەڵک و ئاژەڵێک کە لە کێڵگە دەمێننەوە ئەگەر لە ماڵەوە کۆنەکرێنەوە ئەوا تەرزەکە بە سەریان دەکەوێت و دەمرن.“» ");
INSERT INTO ckb_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","ئیتر دەستوپێوەندەکانی فیرعەون، ئەوانەی کە لە فەرمایشتی یەزدان ترسان، بە کۆیلە و ئاژەڵە ماڵییەکانیانەوە بەرەو ماڵەکان هەڵاتن. ");
INSERT INTO ckb_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","بەڵام ئەوەی فەرمایشتی یەزدانی پشتگوێ خست، ئەوا خزمەتکاران و ئاژەڵە ماڵییەکەی لە کێڵگە بەجێهێشت. ");
INSERT INTO ckb_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","ئینجا یەزدان بە موسای فەرموو: «دەستت بەرەو ئاسمان درێژ بکە و لە هەموو خاکی میسر تەرزە بەسەر خەڵک و ئاژەڵ و هەموو شتێکدا دەبارێت کە لە کێڵگەکانی خاکی میسر گەشە دەکات.» ");
INSERT INTO ckb_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","ئیتر موسا گۆچانەکەی بەرەو ئاسمان درێژکرد، یەزدانیش هەورەتریشقەی لێدا و ئاگر بەرەو زەوی هات، یەزدان تەرزەی باراندە سەر خاکی میسر. ");
INSERT INTO ckb_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","بووە تەرزە و ئاگریش لەناو تەرزەکە بریسکەی دەدایەوە. تەرزەکە ئەوەندە مەزن بوو کە لە هەموو خاکی میسر وەک ئەوە نەبووە، لەو کاتەوەی بوونەتە نەتەوە. ");
INSERT INTO ckb_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","تەرزە لە هەموو خاکی میسری دا، لە هەموو ئەوەی لە کێڵگەدا بوو لە مرۆڤەوە هەتا ئاژەڵ، تەرزە هەموو سەوزایی و ڕووەکی کێڵگەی کوتایەوە و هەموو داری کێڵگەشی شکاند. ");
INSERT INTO ckb_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","تەنها لە خاکی گۆشەن کە نەوەی ئیسرائیلی لێبوو، تەرزە نەبوو. ");
INSERT INTO ckb_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","فیرعەون ناردی و بانگی موسا و هارونی کرد، پێی گوتن: «ئەم جارە گوناهم کرد، یەزدان ڕاستودروستە و من و گەلەکەم تاوانبارین. ");
INSERT INTO ckb_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","لە یەزدان بپاڕێنەوە، چونکە لە هەورەتریشقە و تەرزە تێر بووین، منیش ڕێتان دەدەم بڕۆن، ئیتر ڕاناگیرێن.» ");
INSERT INTO ckb_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","موساش وەڵامی دایەوە: «بە چوونەدەرەوەم لە شارەکە دەستم بەرەو یەزدان بەرز دەکەمەوە و نزا دەکەم، ئیتر هەورەتریشقە دەوەستێت و تەرزە نابێت، بۆ ئەوەی بزانیت زەوی هی یەزدانە. ");
INSERT INTO ckb_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","بەڵام سەبارەت بە خۆت و خزمەتکارەکانت، من دەزانم هێشتا لە یەزدانی پەروەردگار نەترساون.» ");
INSERT INTO ckb_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","کەتان و جۆ تووشی ئافات هاتن، چونکە جۆ لە گوڵکردن و کەتانیش لە تۆوکردن بوو. ");
INSERT INTO ckb_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","بەڵام گەنم و ماش تووشی ئافات نەبوون، چونکە درەنگ پێدەگەن. ");
INSERT INTO ckb_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","موسا فیرعەونی بەجێهێشت و لە شارەکەش ڕۆیشت، دەستی بەرەو یەزدان بەرز کردەوە و نزای کرد، ئیتر هەورەتریشقە و تەرزە وەستان و باران نەبارییە سەر زەوی. ");
INSERT INTO ckb_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","کاتێک فیرعەون بینی باران و تەرزە و هەورەتریشقە وەستاوە، گەڕایەوە سەر گوناه و خۆی و خزمەتکارانی دڵیان ڕەقکرد. ");
INSERT INTO ckb_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","ئیتر دڵی فیرعەون ڕەق بوو و ڕێی بە نەوەی ئیسرائیل نەدا بڕۆن، هەروەک یەزدان لە ڕێگەی موساوە فەرمووی. ");
INSERT INTO ckb_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","یەزدان بە موسای فەرموو: «بڕۆ لای فیرعەون، چونکە من دڵی ئەو و دڵی خزمەتکارانی ئەوم ڕەق کردووە، بۆ ئەوەی ئەم نیشانانەم لەنێویان ئەنجام بدەم. ");
INSERT INTO ckb_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","هەروەها بۆ ئەوەی بۆ منداڵ و نەوەکانت باسی ئەوە بکەیت چۆن میسرم کردە گاڵتەجار بەو نیشانانەی لەنێویاندا ئەنجامم داوە، ئیتر ئێوە دەزانن کە من یەزدانم.» ");
INSERT INTO ckb_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","جا موسا و هارون چوونە لای فیرعەون و پێیان گوت: «یەزدانی پەروەردگاری عیبرانییەکان ئەمە دەفەرموێت: ”هەتا کەی مل نادەیت و لەبەردەمم ملکەچ نابیت؟ ڕێ بە گەلەکەم بدە با بڕۆن و بمپەرستن، ");
INSERT INTO ckb_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","چونکە ئەگەر ڕێ بە گەلەکەم نەدەیت، ئەوا من بەیانی کوللە دەهێنمە سەر خاکەکەت. ");
INSERT INTO ckb_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","ڕووی زەوی دادەپۆشرێت و ناتوانرێت تەماشای زەوی بکرێت، ئەوەی لە تەرزەکە بۆتان ماوەتەوە و دەرباز بووە دەیخوات، هەروەها هەموو دارێکیش کە لە کێڵگەکانتان گەشە بکات دەیخوات. ");
INSERT INTO ckb_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","ماڵەکانت و ماڵی هەموو خزمەتکارەکانت و هەموو میسرییەکان پڕ دەکات، ئەو شتەی کە نە باوک و نە باپیرانت بینیویانە، لەو ڕۆژەی لەسەر ئەم خاکە نیشتەجێ بوون هەتا ئەمڕۆ.“» ئینجا ڕووی وەرگێڕا و لەلای فیرعەون هاتە دەرەوە. ");
INSERT INTO ckb_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","خزمەتکارانی فیرعەونیش پێیان گوت: «هەتا کەی ئەمە ببێتە تەڵە بۆمان؟ ڕێ بەو پیاوانە بدە با بڕۆن و یەزدانی پەروەردگاریان بپەرستن، ئایا هێشتا نازانیت کە میسر وێران بووە؟» ");
INSERT INTO ckb_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","ئینجا موسا و هارونیان بردەوە لای فیرعەون، ئەویش پێی گوتن: «بڕۆن یەزدانی پەروەردگارتان بپەرستن، بەڵام کێ و کێ دەچن؟» ");
INSERT INTO ckb_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","موساش وەڵامی دایەوە: «بە گەنج و پیرمانەوە دەچین، بە کوڕ و کچ و مەڕوماڵات و ڕەشەوڵاخمانەوە دەچین، چونکە پێویستە جەژن بۆ یەزدان بگێڕین.» ");
INSERT INTO ckb_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","فیرعەونیش پێی گوتن: «یەزدان لەگەڵتان بێت! ئەگەر بهێڵم لەگەڵ ژن و منداڵەکانتان بڕۆن! دیارە ئێوە نیازتان خراپە. ");
INSERT INTO ckb_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","نەخێر! تەنها پیاوان بڕۆن یەزدان بپەرستن، هەروەک خۆتان داواتان کردووە.» ئیتر موسا و هارون لەبەردەم فیرعەون دەرکران. ");
INSERT INTO ckb_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","یەزدان بە موسای فەرموو: «دەستت بۆ سەر خاکی میسر درێژ بکە بۆ کوللە، بۆ ئەوەی بێتە سەر خاکی میسر و هەموو سەوزایی زەوییەکە بخوات، ئەوەی لە تەرزەکە ماوەتەوە.» ");
INSERT INTO ckb_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","ئیتر موسا گۆچانەکەی بەسەر خاکی میسردا درێژکرد، بە درێژایی ئەو ڕۆژ و شەوە یەزدان بایەکی ڕۆژهەڵاتی هێنا، کاتێک بووە بەیانی بایەکەی ڕۆژهەڵات کوللەی هەڵگرت. ");
INSERT INTO ckb_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","کوللە هاتە سەر هەموو خاکی میسر و لەسەر هەموو سنوورەکانی میسر نیشتەوە، ئەوەندە گران بوو کە لەوەوپێش کوللەی وا نەبووە و ناشبێت. ");
INSERT INTO ckb_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","ڕووی هەموو خاکەکەی داپۆشی و خاکەکە تاریک بوو، هەموو سەوزاییەکی زەوی و هەموو بەروبوومی دارەکان کە تەرزە لێی نەدابوو خواردی، هیچ سەوزایی لە خاکی میسر نەهێشتەوە، بە دار و ڕووەکی کێڵگەوە. ");
INSERT INTO ckb_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","فیرعەون بە خێرایی بانگی موسا و هارونی کرد و گوتی: «گوناهم سەبارەت بە یەزدانی پەروەردگارتان و سەبارەت بە ئێوەش کرد. ");
INSERT INTO ckb_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","ئێستاش تەنها ئەم جارە لەم گوناهەم خۆشبن، لە یەزدانی پەروەردگارتان بپاڕێنەوە با تەنها ئەم کارەساتە کوشندەیەم لەسەر لابدات.» ");
INSERT INTO ckb_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","موساش لەلای فیرعەون هاتە دەرەوە و لە یەزدان پاڕایەوە. ");
INSERT INTO ckb_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","یەزدانیش بایە ڕۆژهەڵاتییەکەی گۆڕی بە بایەکی ڕۆژئاوایی زۆر بەهێز و کوللەکەی هەڵگرت و فڕێیدایە ناو دەریای سوور و یەک کوللە نەما لە هەموو خاکی میسردا. ");
INSERT INTO ckb_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","بەڵام یەزدان دڵی فیرعەونی ڕەقکرد و ڕێی نەدا بە نەوەی ئیسرائیل بڕۆن. ");
INSERT INTO ckb_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","ئینجا یەزدان بە موسای فەرموو: «دەستت بۆ ئاسمان درێژ بکە با تاریکی باڵ بەسەر خاکی میسردا بکێشێت، کە چاو چاو نەبینێت.» ");
INSERT INTO ckb_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","ئیتر موسا دەستی بۆ ئاسمان درێژکرد و تاریکاییەکی سەخت بۆ ماوەی سێ ڕۆژ باڵی بەسەر خاکی میسردا کێشا. ");
INSERT INTO ckb_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","بۆ ماوەی سێ ڕۆژ کەس کەسی نەبینی و کەس لە شوێنی خۆی هەڵنەستا، بەڵام هەموو نەوەی ئیسرائیل لە نشینگەکانیان ڕووناکییان هەبوو. ");
INSERT INTO ckb_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","ئینجا فیرعەون بانگی موسای کرد و گوتی: «بڕۆن یەزدان بپەرستن، تەنها مەڕوماڵات و ڕەشەوڵاخەکانتان بمێنێت، هەروەها ژن و منداڵەکانیشتان با لەگەڵتان بڕۆن.» ");
INSERT INTO ckb_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","بەڵام موساش گوتی: «پێویستە ڕێگامان پێبدەیت بۆ ئەوەی قوربانی و قوربانی سووتاندن پێشکەش بکەین بۆ یەزدانی پەروەردگارمان. ");
INSERT INTO ckb_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","بەڵکو مەڕوماڵاتیشمان لەگەڵمان دەڕۆن تەنها سمێکیش بەجێنامێنێت، چونکە لەوان هەڵدەگرین بۆ پەرستنی یەزدانی پەروەردگارمان، ئێمە نازانین بە چی یەزدان بپەرستین، هەتا نەگەینە ئەوێ.» ");
INSERT INTO ckb_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","بەڵام یەزدان دڵی فیرعەونی ڕەقکرد و ڕێی نەدا بڕۆن. ");
INSERT INTO ckb_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","فیرعەونیش پێی گوت: «لەلام بڕۆ، ئاگاداری خۆت بە نەیەیتەوە بەرچاوم، چونکە ئەو ڕۆژەی ڕووم ببینیت دەمریت.» ");
INSERT INTO ckb_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","موساش وەڵامی دایەوە: «هەروەک گوتت! جارێکی دیکە ناتبینمەوە.» ");
INSERT INTO ckb_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","یەزدان بە موسای فەرموو: «کارەساتێکی دیکە بەسەر فیرعەون و میسردا دەهێنم، دوای ئەمە ڕێتان دەدات بڕۆن، کاتێک ڕێتان دەدات بڕۆن هەمووان لێرە بە تەواوی دەردەکات. ");
INSERT INTO ckb_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","بە گەل بڵێ با هەر پیاوێک یان ژنێک داوای خشڵی زێڕ و زیو لە دراوسێ میسرییەکەی بکات.» ");
INSERT INTO ckb_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","یەزدانیش گەلی لەبەرچاوی میسرییەکان ڕێزدار کرد، هەروەها کاربەدەستانی فیرعەون و گەلی میسر بە چاوی ڕێزەوە سەیری موسایان دەکرد. ");
INSERT INTO ckb_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","موسا گوتی: «یەزدان ئەمە دەفەرموێت: ”من لە دەوروبەری نیوەشەودا دێمە ناو میسر. ");
INSERT INTO ckb_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","هەموو کوڕە نۆبەرەیەک لە خاکی میسر دەمرێت، لە نۆبەرەی فیرعەونەوە کە لەسەر تەختەکەی دانیشتووە هەتا نۆبەرەی ئەو کەنیزەیەی لە پشت دەستاڕە، نۆبەرەی هەموو ئاژەڵێکی ماڵیش. ");
INSERT INTO ckb_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","هاوارێکی مەزنیش لە هەموو خاکی میسردا دەبێت کە وەک ئەوە نەبووە و جارێکی دیکەش نابێت. ");
INSERT INTO ckb_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","بەڵام بۆ هەموو نەوەی ئیسرائیل تەنانەت سەگیش پێیان ناوەڕێت، نە بە خەڵک و نە بە ئاژەڵ،“ بۆ ئەوەی بزانن یەزدان جیاوازی لەنێوان گەلی میسری و ئیسرائیلی دەکات. ");
INSERT INTO ckb_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","ئیتر هەموو خزمەتکارانت دێنە لام و کڕنۆشم بۆ دەبەن و دەڵێن ”بڕۆن، خۆت و هەموو ئەو گەلەی لەدوای تۆن،“ ئیتر لەپاش ئەوە ئێرە بەجێدەهێڵم و دەڕۆم.» ئینجا موسا بە تووڕەییەوە لەلای فیرعەون هاتە دەرەوە. ");
INSERT INTO ckb_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","یەزدان بە موسای فەرموو: «فیرعەون گوێتان لێ ناگرێت، بۆ ئەوەی پەرجووەکانم لە خاکی میسردا زیاد بێت.» ");
INSERT INTO ckb_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","موسا و هارون هەموو ئەم پەرجووانەیان لەبەردەم فیرعەون کرد، بەڵام یەزدان دڵی فیرعەونی ڕەقکرد و ڕێی بە نەوەی ئیسرائیل نەدا لە خاکەکەی بڕۆن. ");
INSERT INTO ckb_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","یەزدان لە خاکی میسر بە موسا و هارونی فەرموو: ");
INSERT INTO ckb_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","«ئەم مانگە بۆتان دەبێتە سەری مانگەکان، بۆ ئێوە یەکەمی مانگەکانی ساڵە. ");
INSERT INTO ckb_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","لەگەڵ هەموو کۆمەڵی ئیسرائیل بدوێن و بڵێن، لە دەی ئەم مانگە با هەر پیاوێک لەبری بنەماڵەکەی بەرخێک ببات، بەرخێک بۆ هەر ماڵێک. ");
INSERT INTO ckb_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","ئەگەر ماڵێک بچووک بوو و توانای خواردنی بەرخێکی نەبوو، ئەوا با لەگەڵ نزیکترین دراوسێیدا بەشی بکات بەگوێرەی ژمارەی کەسەکان؛ بەگوێرەی ئەو بڕەی کە هەرکەسێک دەتوانێت لە بەرخەکە بخوات. ");
INSERT INTO ckb_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","دەبێت ئاژەڵێکی نێرینەی ساغی یەک ساڵە بۆ خۆتان دانێن و لە بەرخ یان گیسک هەڵیاندەبژێرن. ");
INSERT INTO ckb_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","هەتا ڕۆژی چواردەی ئەم مانگە لەلای خۆتان چاودێرییان دەکەن، ئینجا هەموو کۆڕی کۆمەڵی ئیسرائیل لە کاتی خۆرئاوابوون سەریان دەبڕن. ");
INSERT INTO ckb_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","لە خوێنەکەش هەڵدەگرن و لە هەردوو لای دەرگاکان و سەری دەرگاکانی ئەو ماڵانەشی دەدەن کە تێیدا دەیخۆن. ");
INSERT INTO ckb_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","گۆشتەکەش لەو شەوەدا بە ئاگر دەبرژێنرێت و لەگەڵ نانی فەتیرە و گیای تاڵ دەیخۆن. ");
INSERT INTO ckb_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","نەکەن بە خاوی یان کوڵاوی بیخۆن، بەڵکو دەبێت برژاو بێت، لەگەڵ سەر و پێ و هەناوی. ");
INSERT INTO ckb_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","لێشی مەهیڵنەوە بۆ بەیانی، ئەوەی لێی دەمێنێتەوە هەتا بەیانی، بە ئاگر بیسووتێنن. ");
INSERT INTO ckb_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","ئاواش دەیخۆن: ناوقەدتان بەسترا بێت و پێڵاوەکانتان لە پێتان بێت و گۆچانەکانتان بە دەستەوە بێت. بە پەلە دەیخۆن؛ ئەوە پەسخەیە بۆ یەزدان. ");
INSERT INTO ckb_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","«من ئەمشەو بە خاکی میسردا تێدەپەڕم و هەموو نۆبەرەیەک لە خاکی میسر دەکوژم، لە مرۆڤەوە هەتا ئاژەڵ، حوکمیش بەسەر هەموو خوداوەندەکانی میسردا دەدەم، من یەزدانم. ");
INSERT INTO ckb_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","خوێنەکەش بۆتان دەبێتە نیشانە لەسەر ئەو ماڵانەی ئێوە تێیدان، کاتێک خوێنەکە دەبینم، بەسەرتاندا تێدەپەڕم. ئیتر کارەساتی لەناوچوون ئێوە ناگرێتەوە کاتێک لە خاکی میسر دەدەم. ");
INSERT INTO ckb_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","«ئەو ڕۆژەش دەبێتە یادگاری بۆتان و دەیکەنە جەژن بۆ یەزدان، فەرزێکی هەتاهەتاییە و نەوە دوای نەوە بەردەوام دەبێت. ");
INSERT INTO ckb_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","حەوت ڕۆژ نانی فەتیرە دەخۆن. لە ڕۆژی یەکەمەوە هەویرترش لە ماڵەکانتان ناهێڵن، چونکە هەر یەکێک شتێکی بە هەویرترش بخوات لە ڕۆژی یەکەمەوە هەتا ڕۆژی حەوتەم، ئەوا ئەو کەسە لە ئیسرائیل دادەبڕدرێت. ");
INSERT INTO ckb_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","لە ڕۆژی یەکەم کۆبوونەوەی پیرۆزبوون ببەستن، هەروەها لە ڕۆژی حەوتەمیش. هیچ کارێک لەو ڕۆژانەدا مەکەن، تەنها خواردن ئامادەکردن نەبێت کە هەموو کەسێک دەیخوات. تەنها ئەوە دەکەن. ");
INSERT INTO ckb_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","«ئەم جەژنی فەتیرەش بگێڕن، چونکە لە هەمان ئەم ڕۆژەدا لەشکرەکانتانم لە خاکی میسر دەرهێنا. نەوە دوای نەوە ئەم جەژنە بگێڕن و با وەک فەرزێکی هەتاهەتایی بەردەوام بێت. ");
INSERT INTO ckb_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","لە چواردەی مانگی یەکدا، لە ئێوارە نانی فەتیرە بخۆن هەتا ئێوارەی ڕۆژی بیست و یەکی مانگ. ");
INSERT INTO ckb_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","حەوت ڕۆژ نابێت هەویرترش لە ماڵەکانتان هەبێت. هەرکەسێک بە نامۆ و هاوڵاتیشەوە شتێک بخوات کە هەویرترشی تێدابێت، لە کۆمەڵی ئیسرائیل دادەبڕدرێت. ");
INSERT INTO ckb_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","شتی بە هەویرترش مەخۆن، دەبێت لە هەموو نشینگەکانتان نانی فەتیرە بخۆن.» ");
INSERT INTO ckb_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","ئینجا موسا هەموو پیرانی ئیسرائیلی بانگکرد و پێی گوتن: «بڕۆن بۆ خۆتان مەڕوماڵات ببەن، بەگوێرەی هۆزەکانتان بەرخی پەسخە سەرببڕن. ");
INSERT INTO ckb_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","دەسکێک زوفا هەڵبگرن و لەو خوێنەی وەربدەن کە لە تەشتدایە و سەرەوەی دەرگا و هەردوو لایەکەی پێ خوێناوی بکەن، ئێوەش هەتا بەیانی کەستان لە دەرگای ماڵەکەی ناچێتە دەرەوە. ");
INSERT INTO ckb_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","یەزدان تێدەپەڕێت بۆ ئەوەی لە میسرییەکان بدات، کاتێک خوێنەکە دەبینێت کە لەسەر دەرگا و هەردوو لایەکەی دراوە ئیتر یەزدان بەسەر دەرگاکە تێدەپەڕێت و ناهێڵێت لەناوبەر بێتە ماڵەکانتان بۆ لێدانتان. ");
INSERT INTO ckb_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","«ئەم ڕێوەڕەسمە بۆ هەتاهەتایە وەک فەرزێک بۆ خۆتان و نەوەکانتان بەجێدەهێنن. ");
INSERT INTO ckb_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","ئەوە دەبێت کاتێک دێنە ناو ئەو خاکەی یەزدان دەتانداتێ هەروەک فەرمووی، ئەم ئەرکە دەپارێزن. ");
INSERT INTO ckb_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","ئیتر کاتێک منداڵانتان پێتان دەڵێن: ”ئەم ئەرکە چییە بۆ ئێوە؟“ ");
INSERT INTO ckb_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","ئێوەش دەڵێن: ”ئەوە قوربانی پەسخەیە بۆ یەزدان، کە لە میسر بەسەر ماڵەکانی نەوەی ئیسرائیلدا تێپەڕی، کاتێک لە میسرییەکانی دا و ماڵەکانی ئێمەی پاراست.“» ئیتر گەل دانەوین و کڕنۆشیان برد. ");
INSERT INTO ckb_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","نەوەی ئیسرائیل چوون و بەم جۆرەیان کرد، وەک ئەوەی یەزدان فەرمانی بە موسا و هارون کرد. ");
INSERT INTO ckb_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","ئەوە بوو یەزدان لە نیوەشەودا لە هەموو نۆبەرەیەکی خاکی میسری دا، لە نۆبەرەی فیرعەونەوە کە لەسەر تەخت دانیشتووە هەتا نۆبەرەی ئەو دیلەی لە بەندیخانەیە و هەموو نۆبەرەکانی مەڕوماڵاتیش. ");
INSERT INTO ckb_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","فیرعەون شەو هەستا، خۆی و هەموو خزمەتکارەکانی و هەموو میسرییەکان، هاوارێکی مەزن لە میسر پەیدا بوو، چونکە هیچ ماڵێک نەبوو مردووی نەبێت. ");
INSERT INTO ckb_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","بەو شەوە فیرعەون موسا و هارونی بانگکرد و گوتی: «هەستن! لەنێو گەلەکەم بڕۆنە دەرەوە، ئێوە و هەموو نەوەی ئیسرائیل، بڕۆن یەزدان بپەرستن وەک خۆتان داواتان کرد. ");
INSERT INTO ckb_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","مەڕوماڵات و گاڕانەکەشتان ببەن وەک گوتتان، بڕۆن و هەروەها بۆ منیش داوای بەرەکەت بکەن.» ");
INSERT INTO ckb_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","میسرییەکانیش زۆریان لە گەلەکە کرد تاکو پەلە بکەن لە ڕۆیشتنیان لە خاکەکە، چونکە گوتیان: «ئەگینا ئێمە هەموومان دەمرین.» ");
INSERT INTO ckb_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","گەلیش هەویرەکانیان هەڵگرت پێش ئەوەی هەویرترشی تێ بکەن، تەشتە هەویرە شێلراوەکانیان لە جلەکانیان پێچایەوە و لەسەر شانیان دانا. ");
INSERT INTO ckb_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","هەروەها نەوەی ئیسرائیل بەو جۆرەیان کرد کە موسا پێی گوتن و داوای خشڵی زیو و زێڕ و جلوبەرگیان لە میسرییەکان کرد. ");
INSERT INTO ckb_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","یەزدانیش گەلی لەبەرچاوی میسرییەکان ڕێزدار کرد، ئیتر ئەوەی داوایان کردبوو پێیان دان و بەم شێوەیە میسرییەکانیان تاڵان کرد. ");
INSERT INTO ckb_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","نەوەی ئیسرائیل کە نزیکەی شەش سەد هەزار پیادەی پیاو دەبوون بێجگە لە ئافرەت و منداڵ، لە ڕەعمسێسەوە کۆچیان کرد بەرەو سوکۆت. ");
INSERT INTO ckb_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","هەروەها کۆمەڵە خەڵکێکی زۆر لەگەڵیان سەرکەوتن، هەروەها ئاژەڵێکی زۆریش کە لە مەڕوماڵات و گاوگۆتاڵ پێکهاتبوون. ");
INSERT INTO ckb_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","ئەو هەویرەی لە میسرەوە هێنابوویان کردیانە کولێرەی فەتیرە. هەویرەکە بێ هەویرترش بوو، لەبەر ئەوەی لە میسر دەرکران و نەدەکرا دوا بکەون، هەروەها خواردنیان بۆ خۆیان دروستنەکردبوو. ");
INSERT INTO ckb_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","نەوەی ئیسرائیلیش چوار سەد و سی ساڵ لە میسردا نیشتەجێ بوون. ");
INSERT INTO ckb_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","ئەوە بوو لە کۆتایی چوار سەد و سی ساڵەکە، لە هەمان ئەو ڕۆژەدا، هەموو لەشکری یەزدان لە خاکی میسر چوونە دەرەوە. ");
INSERT INTO ckb_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","لەبەر ئەوەی ئەو شەوە یەزدان ئێشکی گرت بۆ دەرهێنانی گەلی ئیسرائیل لە خاکی میسر، لەم شەوەدا هەموو نەوەی ئیسرائیل وەک ڕێزلێنانێک بۆ یەزدان ئێشک دەگرن بۆ نەوەکانیان. ");
INSERT INTO ckb_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","یەزدان بە موسا و هارونی فەرموو: «ئەمە فەرزی پەسخەیە: «هیچ بیانییەک لێی ناخوات. ");
INSERT INTO ckb_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","هەر کۆیلەیەکی پیاوی بە زیو کڕاو دوای ئەوەی خەتەنە دەکرێت ئینجا لێی دەخوات. ");
INSERT INTO ckb_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","بەڵام نیشتەجێی کاتی و کرێگرتە لێی ناخۆن. ");
INSERT INTO ckb_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","«لە یەک ماڵدا لە گۆشتەکە دەخورێت و لە ماڵەکە ناچێتە دەرەوە، هیچ ئێسکێکی لێ ناشکێنرێت. ");
INSERT INTO ckb_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","هەموو کۆمەڵی ئیسرائیل پێویستە یادی بکەنەوە. ");
INSERT INTO ckb_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","«ئەگەر نامۆیەک لەنێوتاندا بژیێت و بیەوێت پەسخە بۆ یەزدان بکات، پێویستە هەموو نێرینەیەکی ماڵەکەی خەتەنە بکرێت. ئینجا وەک لەدایکبووێکی خاکەکەی لێدێت، بەڵام خەتەنەنەکراو لێی ناخوات. ");
INSERT INTO ckb_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","یەک یاسا پەیڕەو دەکرێت بۆ هاوڵاتی و بۆ ئەو نامۆیەی کە لەنێوتان دەژیێت.» ");
INSERT INTO ckb_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","ئیتر هەموو نەوەی ئیسرائیل بەم جۆرەیان کرد وەک ئەوەی یەزدان فەرمانی بە موسا و هارون کرد. ");
INSERT INTO ckb_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","ئەوە بوو لە هەمان ئەو ڕۆژەدا یەزدان نەوەی ئیسرائیلی لە شێوەی لەشکر لە خاکی میسر هێنایە دەرەوە. ");
INSERT INTO ckb_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","«هەموو نێرینەیەکی نۆبەرە بۆ من تەرخان بکەن. یەکەم بەری سک لە نەوەی ئیسرائیل لە مرۆڤ و لە ئاژەڵ، ئەوە بۆ منە.» ");
INSERT INTO ckb_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","موسا بە گەلی گوت: «یادی ئەم ڕۆژە بکەنەوە کە لە میسر هاتنە دەرەوە، لە خاکی کۆیلایەتی، کە بە دەستێکی بەهێز یەزدان لێرە دەریهێنان، هیچ شتێکی بە هەویرترش مەخۆن. ");
INSERT INTO ckb_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","ئێستا، کە مانگی ئاڤیڤە، ئێوە میسر بەجێدەهێڵن. ");
INSERT INTO ckb_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","کاتێک یەزدان دەتانهێنێتە خاکی کەنعانی و حیتی و ئەمۆری و حیڤی و یەبوسییەکان، ئەو خاکەی کە سوێندی بۆ باوباپیرانتان خوارد بتانداتێ کە شیر و هەنگوینی لێ دەڕژێت، ئەوا لەو مانگەدا ئێوە ئەو ئەرکە بەجێدەگەیەنن. ");
INSERT INTO ckb_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","حەوت ڕۆژ نانی فەتیرە دەخۆن و لە ڕۆژی حەوتەم جەژنە بۆ یەزدان. ");
INSERT INTO ckb_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","لەو حەوت ڕۆژەدا نانی فەتیرە دەخورێت و هیچ شتێکی بە هەویرترش لەلاتان نەبینرێت، هیچ هەویرترشێک لە هەموو سنوورەکانتان نەبینرێت. ");
INSERT INTO ckb_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","لەو ڕۆژەدا بە کوڕەکەت ڕادەگەیەنیت و دەڵێیت: ”من ئەمە دەکەم لەبەر ئەو کارەی کە یەزدان بۆ منی کرد کاتێک لە میسر هاتمە دەرەوە.“ ");
INSERT INTO ckb_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","بۆت دەبێتە نیشانەیەک لەسەر دەستت و یادگارییەک لە نێوچەوانت، بۆ ئەوەی فێرکردنی یەزدان لە دەمت بێت، چونکە بە دەستێکی بەهێز یەزدان لە میسر دەریهێنایت. ");
INSERT INTO ckb_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","ئەو فەرزەش ساڵ لەدوای ساڵ لە کاتی خۆیدا بەجێدەهێنیت. ");
INSERT INTO ckb_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","«کاتێک یەزدان دەتانهێنێتە خاکی کەنعانییەکان و دەیداتە ئێوە، هەروەک سوێندی خوارد بۆ ئێوە و بۆ باوکانتان، ");
INSERT INTO ckb_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","ئەوا ئێوە هەموو بەری یەکەمی سک و هەموو نۆبەرەیەکی نێرینە لە بەری ماڵاتەکەتان کە بۆتان دەبێت، دەبێت پێشکەشی یەزدانی بکەن، ئەوانە بۆ یەزدانن. ");
INSERT INTO ckb_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","هەموو نۆبەرەیەکی گوێدرێژیش بە بەرخێک دەکڕنەوە، ئەگەر نەیکڕنەوە، ملی دەشکێنن. هەموو نۆبەرەیەکیش لە کوڕانتان دەکڕنەوە. ");
INSERT INTO ckb_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","«لە ڕۆژانی داهاتوو کە کوڕەکەت لێت دەپرسێت و دەڵێت: ”ئەمە چییە؟“ پێی دەڵێیت: ”بە دەستێکی بەهێز یەزدان لە میسر دەریهێناین، لە خاکی کۆیلایەتی. ");
INSERT INTO ckb_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","ئەوە بوو کاتێک فیرعەون کەللەڕەق بوو لە ڕێپێدانمان بۆ ئەوەی بڕۆین، یەزدان هەموو نۆبەرەیەکی لە خاکی میسر کوشت، لە نۆبەرەی مرۆڤەوە هەتا نۆبەرەی ئاژەڵ. لەبەر ئەمەیە من هەموو نێرێکی نۆبەرەی سک بۆ یەزدان سەردەبڕم و هەر نۆبەرەیەک لە منداڵەکانم دەکڕمەوە.“ ");
INSERT INTO ckb_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","ئەمەش دەبێتە نیشانە لەسەر دەستت و هێما لەسەر نێوچەوانت، چونکە بە دەستێکی بەهێز یەزدان لە میسر دەریهێناین.» ");
INSERT INTO ckb_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","ئەوە بوو کە فیرعەون ڕێی دا گەلەکە بڕۆن، خودا ڕێنمایی نەکردن بۆ ڕێگای خاکی فەلەستییەکان، لەگەڵ ئەوەی نزیکیش بوو، چونکە خودا فەرمووی: «نەوەک گەل پەشیمان ببنەوە کاتێک شەڕ ببینن و بگەڕێنەوە بۆ میسر.» ");
INSERT INTO ckb_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","ئیتر خودا گەلی سووڕاندەوە بۆ ڕێگای چۆڵەوانی دەریای سوور. نەوەی ئیسرائیل بە ڕیز چەکداربوون بۆ جەنگ و لە خاکی میسرەوە سەرکەوتن. ");
INSERT INTO ckb_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","موساش ئێسقانەکانی یوسفی لەگەڵ خۆی برد، چونکە یوسف نەوەی ئیسرائیلی سوێند دابوو و گوتبووی: «بێگومان خودا بەسەرتان دەکاتەوە، دەبێت ئێوەش لێرەوە ئێسقانەکانم لەگەڵ خۆتان ببەنەوە.» ");
INSERT INTO ckb_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","دوای ئەوەی لە سوکۆتەوە کۆچیان کرد، لە ئێتام لە قەراغی چۆڵەوانی چادریان هەڵدا. ");
INSERT INTO ckb_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","یەزدانیش لەپێشیانەوە دەڕۆیشت، بە ڕۆژ لە ستوونێکی هەوردا لە ڕێگا ڕابەرایەتی دەکردن، بە شەویش لە ستوونێکی ئاگر هەتا ڕووناکییان بۆ ببێت، بۆ ئەوەی بە شەو و ڕۆژ بڕۆن. ");
INSERT INTO ckb_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","ستوونە هەورەکە بە ڕۆژ و ستوونە ئاگرەکە بە شەو لەبەردەم گەلدا لا نەدەچوون. ");
INSERT INTO ckb_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","«بە نەوەی ئیسرائیل بڵێ: ”با بگەڕێنەوە و بەرامبەر پی‌هەحیرۆت چادر هەڵبدەن، لەنێوان مگدۆل و دەریا. لەلای دەریاوە چادر هەڵبدەن، بەرامبەر بە بەعل‌چیفۆن. ");
INSERT INTO ckb_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","فیرعەون دەربارەی نەوەی ئیسرائیل دەڵێت: ’سەرلێشێواون لە خاکەکە، لەنێوان دەریا و چۆڵەوانی گیریان خواردووە.‘ ");
INSERT INTO ckb_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","دڵی فیرعەونیش ڕەق دەکەم بۆ ئەوەی بەدوایان بکەوێت. بەڵام بەهۆی فیرعەون و هەموو سوپاکەیەوە شکۆمەند دەبم، میسرییەکانیش دەزانن کە من یەزدانم.“» ئیتر بەم جۆرەیان کرد. ");
INSERT INTO ckb_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","کاتێک بە پاشای میسر ڕاگەیەنرا کە گەلەکە لە دەستی هەڵاتن، دڵی فیرعەون و خزمەتکارانی سەبارەت بە گەلی ئیسرائیل گۆڕا و گوتیان، «ئەمە چی بوو کردمان، کە وا ڕێمان دا بە نەوەی ئیسرائیل لە خزمەتکردنمان بڕۆن؟» ");
INSERT INTO ckb_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","ئیتر گالیسکەکەی پێ ئامادەکردن و سوپایەکەشی لەگەڵ خۆی برد، ");
INSERT INTO ckb_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","شەش سەد گالیسکەی هەڵبژێردراو و هەموو گالیسکەکانی میسر و هەموو ئەفسەرە سواربووەکانیانی برد. ");
INSERT INTO ckb_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","یەزدان دڵی فیرعەونی پاشای میسری ڕەقکرد، ئیتر بەدوای نەوەی ئیسرائیل کەوت، نەوەی ئیسرائیلیش ئازایانە بەرەو پێش دەچوون. ");
INSERT INTO ckb_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","میسرییەکان دوایان کەوتن. هەموو ئەسپ و گالیسکەکانی فیرعەون و سوارەکانی و سوپاکەی دوایان کەوتن و پێیان گەیشتن، کاتێک لەلای دەریا چادریان هەڵدابوو، لەلای پی‌هەحیرۆت بەرامبەر بەعل‌چیفۆن. ");
INSERT INTO ckb_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","کاتێک فیرعەون نزیک بووەوە، نەوەی ئیسرائیل چاویان هەڵبڕی و بینییان میسرییەکان بەدوایانەوەن، ئیتر زۆر ترسان و هاواریان بۆ یەزدان کرد. ");
INSERT INTO ckb_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","بە موسایان گوت: «ئایا لەبەر ئەوەی لە میسر گۆڕ نییە وا ئێمەت هێنایە چۆڵەوانی بۆ ئەوەی بمرین؟ ئەمە چی بوو پێت کردین کە ئێمەت لە میسر هێنایە دەرەوە؟ ");
INSERT INTO ckb_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","ئەمە ئەو قسەیە نییە کە لە میسر پێمان گوتی: ”لێمانگەڕێ با خزمەتی میسرییەکان بکەین،“ چونکە بۆ ئێمە باشترە خزمەتی میسرییەکان بکەین وەک لەوەی لە چۆڵەوانی بمرین؟» ");
INSERT INTO ckb_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","موساش وەڵامی گەلی دایەوە: «مەترسن، چەسپاو بن و بڕواننە ڕزگاریی یەزدان کە ئەمڕۆ بۆ ئێوەی دەکات، چونکە ئەو میسریانەی کە ئەمڕۆ دەیانبینن، ئیتر بۆ هەتاهەتایە نایانبیننەوە. ");
INSERT INTO ckb_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","یەزدان بۆتان دەجەنگێت و ئێوەش بێدەنگ دەبن.» ");
INSERT INTO ckb_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","یەزدان بە موسای فەرموو: «چییە هاوارم بۆ دەکەیت؟ بە نەوەی ئیسرائیل بڵێ با کۆچ بکەن. ");
INSERT INTO ckb_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","تۆش گۆچانەکەت بەرز بکەرەوە و دەستت بۆ سەر دەریاکە درێژ بکە و لێکی بکەرەوە، بۆ ئەوەی نەوەی ئیسرائیل بە ناوەڕاستی دەریاکەدا و بەسەر زەوییەکی وشکدا بپەڕنەوە. ");
INSERT INTO ckb_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","ئەوەتا منیش دڵی میسرییەکان ڕەق دەکەم، ئەوانیش بەدوایاندا دێن، منیش شکۆمەند دەبم بۆ فیرعەون و بۆ هەموو سوپاکەی و گالیسکە و سوارەکانی. ");
INSERT INTO ckb_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","میسرییەکانیش دەزانن کە من یەزدانم، کاتێک شکۆمەند دەبم بۆ فیرعەون و گالیسکە و سوارەکانی.» ");
INSERT INTO ckb_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","ئینجا فریشتەکەی خودا کە لەپێش سوپای ئیسرائیلییەکانەوە دەڕۆیشت شوێنەکەی گواستەوە و لە دوایانەوە ڕۆیشت، ستوونە هەورەکەش لەپێشیانەوە گواستییەوە و لە دواوەیان وەستا. ");
INSERT INTO ckb_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","هاتە نێوان لەشکری میسرییەکان و سوپای ئیسرائیلییەکان، ئیتر هەورەکە بە درێژایی شەو تاریکی بۆ لایەک هێنا و ڕووناکی بۆ لایەکی دیکە. بۆیە بە درێژایی شەو هیچیان نزیکی یەکتر نەبوونەوە. ");
INSERT INTO ckb_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","موساش دەستی بۆ سەر دەریاکە درێژکرد، یەزدان بە درێژایی شەو بە بایەکی ڕۆژهەڵاتی توند دەریاکەی ڕاماڵی، دەریاکەی کردە زەوی وشک و ئاوەکە شەق بوو. ");
INSERT INTO ckb_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","ئیتر نەوەی ئیسرائیل چوونە ناو دەریاکە بۆ سەر وشکانی ژێرەوەی، ئاو بووە دیوار بۆیان لە ڕاست و چەپیانەوە. ");
INSERT INTO ckb_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","میسرییەکانیش دوایان کەوتن، هەموو ئەسپەکانی فیرعەون و گالیسکە و سوارەکانی لە دوایان هاتنە ناوەندی دەریاکە. ");
INSERT INTO ckb_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","ئەوە بوو لە چاوەڕوانی بەرەبەیان، یەزدان لە ستوونی ئاگر و هەورەوە بەرەو خوار تەماشای لەشکری میسرییەکانی کرد و سەری لە لەشکری میسرییەکان شێواند. ");
INSERT INTO ckb_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","چەرخەی گالیسکەکانیانی لێک ترازاند لەبەر ئەوە بە قورسی لێیاندەخوڕی. میسرییەکان گوتیان: «با لەبەردەم نەوەی ئیسرائیل هەڵبێین، چونکە یەزدان بۆیان دەجەنگێت لە دژی میسرییەکان.» ");
INSERT INTO ckb_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","یەزدان بە موسای فەرموو: «دەستت بۆ سەر دەریا درێژ بکە و ئاوەکە بۆ سەر میسرییەکان و گالیسکە و سوارەکان دەگەڕێتەوە.» ");
INSERT INTO ckb_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","موساش دەستی بۆ سەر دەریاکە درێژکرد و دەمەو بەیان دەریاکە گەڕایەوە باری جاران، میسرییەکانیش لێی هەڵدەهاتن، یەزدان میسرییەکانی داتەکاندە ناو دەریاکە. ");
INSERT INTO ckb_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","ئیتر ئاوەکە گەڕایەوە سەر گالیسکە و سوارەکانی و هەموو سوپاکەی فیرعەون و دایپۆشین. ئەوانەی بەدوایاندا هاتبوونە ناو دەریاکە، کەسیان لێ نەما. ");
INSERT INTO ckb_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","بەڵام نەوەی ئیسرائیل بەسەر زەوییەکی وشکدا بە ناوەڕاستی دەریاکەدا ڕۆیشتن و ئاویش لە ڕاست و چەپیانەوە بوو بە دیوار بۆیان. ");
INSERT INTO ckb_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","یەزدان لەو ڕۆژەدا ئیسرائیلی لە دەستی میسرییەکان ڕزگار کرد، ئیسرائیلیش میسرییەکانیان بینی لە کەناری دەریاکە مردوون. ");
INSERT INTO ckb_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","ئیسرائیل ئەو کارە مەزنەی بینی کە یەزدان لە دژی میسرییەکان بەکاریهێنا، ئیتر گەل لە یەزدان ترسان و باوەڕیان بە یەزدان و بە موسای بەندەی هێنا. ");
INSERT INTO ckb_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","ئینجا موسا و نەوەی ئیسرائیل ئەم سروودەیان بۆ یەزدان گوت: «سروود بۆ یەزدان دەڵێم، چونکە شکۆمەندانە سەرکەوت، ئەسپ و سوارەکەی فڕێدایە ناو دەریا. ");
INSERT INTO ckb_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","«هێز و سروودم یەزدانە، بووە بە ڕزگاری بۆم. ئەمە خودامە و شکۆداری دەکەم، خودای باوکمە و بە گەورەی دەزانم. ");
INSERT INTO ckb_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","یەزدان پاڵەوانە، ناوی یەزدانە. ");
INSERT INTO ckb_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","گالیسکەکانی فیرعەون و سوپاکەی فڕێدایە ناو دەریا، هەڵبژاردەی ئەفسەرەکانی لە دەریای سوور نوقوم بوون، ");
INSERT INTO ckb_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","قووڵایی دایپۆشین، کەوتنە بنەوە وەک بەرد. ");
INSERT INTO ckb_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","دەستی ڕاستت، ئەی یەزدان، بەتوانایە بۆ شکۆمەندیت. دەستی ڕاستت، ئەی یەزدان، دوژمن تێکدەشکێنێت. ");
INSERT INTO ckb_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","«بە مەزنی و پایەبەرزیت بەرهەڵستەکانت پێشێل دەکەیت، جۆشی تووڕەییت دەبارێنیت وەک پووش دەیانخوات. ");
INSERT INTO ckb_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","بە بای لووتت ئاوەکان گرد بوونەوە، ئاوەڕۆکان وەک گرد وەستان، قووڵاییەکان لەناو دەریا بەستیان. ");
INSERT INTO ckb_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","دوژمن گوتی: ”دوایان دەکەوم، پێیان دەگەم، تاڵان دابەش دەکەم، گیانم لێیان تێر دەبێت، شمشێرەکەم ڕادەکێشم، دەستم لەناویان دەبات.“ ");
INSERT INTO ckb_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","بەڵام بە بای خۆت فووت کرد، دەریا دایپۆشین، ڕۆچوون وەک قورقوشم، لە ئاوێکی مەزن. ");
INSERT INTO ckb_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","ئەی یەزدان، کێ لەنێو خوداوەندەکان وەک تۆیە؟ کێ وەک تۆ پایەبەرزە لە پیرۆزی، سامناک لە شکۆمەندی، دروستکەری کاری سەرسوڕهێنەر؟ ");
INSERT INTO ckb_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","«دەستی ڕاستت درێژکرد، زەوی قووتی دان. ");
INSERT INTO ckb_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","ئەو گەلەی کڕیتەوە، بە خۆشەویستییە نەگۆڕەکەت ڕابەرایەتی دەکەیت، بە هێزی خۆت ڕێنمایی دەکەیت، بۆ نشینگەی پیرۆزت. ");
INSERT INTO ckb_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","گەلان گوێیان لێ دەبێت و دەلەرزن، دانیشتووانی فەلەستیە ژان دەیانگرێت. ");
INSERT INTO ckb_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","سەرکردەکانی ئەدۆم سەرسام دەبن، ڕابەرەکانی مۆئاب لەرز دەیانگرێت، هەموو دانیشتووانی کەنعان دەتوێنەوە. ");
INSERT INTO ckb_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","سامناکی و تۆقین دێتە سەریان. ئەی یەزدان، بە هێزی بازووت وەک بەرد لە شوێنی خۆیان دەچەقن، هەتا ئەوەی گەلەکەت دەپەڕێتەوە، هەتا ئەو گەلەی کڕیوتە دەپەڕێتەوە. ");
INSERT INTO ckb_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","ئەی یەزدان، دەیانهێنیت و دەیانچێنیت لە کێوی میراتت، ئەو شوێنەی بۆ نیشتەجێی خۆت دروستت کرد، ئەی پەروەردگار، ئەو پیرۆزگایەی کە دەستەکانت دایمەزراند. ");
INSERT INTO ckb_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","«یەزدان پاشایەتی دەکات بۆ هەتاهەتایە.» ");
INSERT INTO ckb_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","کاتێک ئەسپی فیرعەون بە گالیسکە و سوارەکانیەوە بۆ ناو دەریا هات، یەزدانیش ئاوی دەریای هێنایەوە سەریان، بەڵام نەوەی ئیسرائیل بەسەر وشکانیدا بە ناوەندی دەریادا ڕۆیشتن. ");
INSERT INTO ckb_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","ئینجا مریەمی پێغەمبەر کە خوشکی هارون بوو، دەستی دایە دەف و هەموو ئافرەتەکانیش بە دەف و سەماوە بەدوایەوە ڕۆیشتن. ");
INSERT INTO ckb_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","مریەمیش سروودی بۆ گوتن: «سروود بۆ یەزدان بڵێ، چونکە شکۆمەندانە سەرکەوت، ئەسپ و سوارەکانی فڕێدایە ناو دەریا.» ");
INSERT INTO ckb_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","ئینجا موسا کۆچی بە نەوەی ئیسرائیل کرد و لە دەریای سوورەوە پەڕینەوە بۆ چۆڵەوانی شوور، سێ ڕۆژ بە چۆڵەوانیدا ڕۆیشتن و ئاویان نەدۆزییەوە. ");
INSERT INTO ckb_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","کاتێک هاتنە مارا، نەیانتوانی ئاوەکەی ئەوێ بخۆنەوە، چونکە تاڵ بوو، هەر لەبەر ئەم هۆیەشە ناونراوە مارا. ");
INSERT INTO ckb_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","جا گەل بۆڵەبۆڵیان لەسەر موسا کرد و گوتیان: «چی بخۆینەوە؟» ");
INSERT INTO ckb_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","موساش هاواری بۆ یەزدان کرد، یەزدانیش دارێکی پیشان دا و ئەویش فڕێیدایە ناو ئاوەکە، ئیتر ئاوەکە سازگار بوو. لەوێ یەزدان فەرز و یاسای بۆ دانان و لەوێش تاقی کردنەوە. ");
INSERT INTO ckb_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","فەرمووی: «ئەگەر بە باشی گوێ لە دەنگی یەزدانی پەروەردگارت بگریت و ئەوەی ڕاستە لەبەرچاوی بیکەیت و گوێ بۆ فەرمانەکانی شل بکەیت و هەموو فەرزەکانی بەجێبهێنیت، هیچ نەخۆشییەک لەوانەی خستمە سەر میسرییەکان نایخەمە سەر تۆ، چونکە من یەزدانم، ئەوەی چاکت دەکاتەوە.» ");
INSERT INTO ckb_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","ئینجا هاتنە ئێلیم، لەوێ دوازدە کانیاو و حەفتا دار خورمای لێبوو، ئیتر لەوێ لەلای ئاوەکان لایاندا. ");
INSERT INTO ckb_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","لەدوای ئەوە لە ئێلیم کۆچیان کرد و هەموو کۆمەڵی نەوەی ئیسرائیل هاتنە چۆڵەوانی سین کە لەنێوان ئێلیم و سینایە، لە ڕۆژی پازدەی مانگی دووەم لەدوای کۆچکردنیان لە خاکی میسر. ");
INSERT INTO ckb_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","هەموو کۆمەڵی نەوەی ئیسرائیل لە چۆڵەوانیدا بۆڵەبۆڵیان لەسەر موسا و هارون کرد. ");
INSERT INTO ckb_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","نەوەی ئیسرائیل پێیان گوتن: «خۆزگە بە دەستی یەزدان لە خاکی میسردا بمردبووینایە، بۆ خۆمان لای مەنجەڵی گۆشت دانیشتبووین و بە تێری نانمان دەخوارد، بەڵام ئێمەتان دەرهێنا بۆ ئەم چۆڵەوانییە هەتا هەموو ئەم کۆمەڵە بە برسیێتی بکوژن.» ");
INSERT INTO ckb_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","یەزدانیش بە موسای فەرموو: «من لە ئاسمانەوە نانتان بۆ دەبارێنم، گەلیش دەبێت بچنە دەرەوە و هەر ڕۆژە و پێویستی ئەو ڕۆژە هەڵبگرنەوە. بەم شێوەیە تاقییان دەکەمەوە ئاخۆ بەگوێرەی فێرکردنەکەم دەڕۆن یان نا. ");
INSERT INTO ckb_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","ئەوە دەبێت لە ڕۆژی شەشەم ئەوەی دەیهێنن ئامادەی بکەن، ئیتر دەبێتە دوو ئەوەندەی ئەوەی ڕۆژانە هەڵیدەگرنەوە.» ");
INSERT INTO ckb_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","جا موسا و هارون بە هەموو نەوەی ئیسرائیلیان گوت: «ئێوارە دەزانن کە یەزدان ئێوەی لە خاکی میسر دەرهێنا. ");
INSERT INTO ckb_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","بەیانیش شکۆی یەزدان دەبینن لە گوێگرتنی لە بۆڵەبۆڵتان لە دژی یەزدان، بەڵام ئێمە چین تاکو لە دژمان بۆڵەبۆڵ بکەن؟» ");
INSERT INTO ckb_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","موسا گوتی: «ئێوە بەوە دەزانن کە یەزدانە کاتێک ئێواران گۆشتتان دەداتێ و بەیانیان نانتان دەداتێ بیخۆن، چونکە گوێی لە بۆڵەبۆڵتان بوو لە دژی. بەڵام ئێمە کێین؟ بۆڵەبۆڵتان لە دژی ئێمە نییە، بەڵکو لە دژی یەزدانە.» ");
INSERT INTO ckb_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","موسا بە هارونی گوت: «بە هەموو کۆمەڵی نەوەی ئیسرائیل بڵێ: ”نزیک ببنەوە بۆ بەردەم یەزدان، چونکە گوێی لە بۆڵەبۆڵتان بوو.“» ");
INSERT INTO ckb_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","ئەوە بوو لەو کاتەی هارون لەگەڵ هەموو کۆمەڵی نەوەی ئیسرائیل دەدوا، ئاوڕیان دایەوە بەرەو چۆڵەوانی و بینییان شکۆمەندی یەزدان لەناو هەور دەبینرێت. ");
INSERT INTO ckb_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","یەزدانیش بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","«گوێم لە بۆڵەبۆڵی نەوەی ئیسرائیل بوو، لەگەڵیان بدوێ و بڵێ: ”ئێواران گۆشت دەخۆن و بەیانی تێر نان دەبن، ئیتر ئێوە دەزانن کە من یەزدانی پەروەردگارتانم.“» ");
INSERT INTO ckb_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","ئەوە بوو لە ئێوارە سوێسکە بەرز بوونەوە و ئۆردوگاکەیان داپۆشی، بەیانیش شەونم لە دەوروبەری ئۆردوگا کەوتبوو. ");
INSERT INTO ckb_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","کاتێک شەونمە کەوتووەکەش بەرزبووەوە، بینییان وا لەسەر ڕووی چۆڵەوانییەکە شتێکی وردی وەک توێکڵ، ورد وەک زوقم لەسەر زەوییەکەیە. ");
INSERT INTO ckb_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","کاتێک نەوەی ئیسرائیل ئەمەیان بینی بە یەکتریان گوت: «ئەوە چییە؟» چونکە نەیاندەزانی چییە. موساش پێی گوتن: «ئەوە ئەو نانەیە کە یەزدان بە ئێوەی داوە بۆ ئەوەی بیخۆن. ");
INSERT INTO ckb_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","ئەمە ئەو شتەیە کە یەزدان فەرمانی کردووە: ”با هەریەکە و بەگوێرەی خواردنی لێی هەڵبگرێتەوە، ئۆمرێک بۆ هەر یەکێک بەگوێرەی ژمارەی کەسەکان هەریەکە بۆ ئەوانەی لە چادرەکەی ئەون دەیباتەوە.“» ");
INSERT INTO ckb_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","نەوەی ئیسرائیلیش بەم جۆرەیان کرد و زۆر و کەم هەڵیانگرتەوە. ");
INSERT INTO ckb_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","بەڵام کاتێک بە ئۆمر پێوایان، نە ئەوەی زۆری کۆکردووەتەوە زیادی کردووە و نە ئەوەی کەمی کۆکردووەتەوە کەمی کردووە، هەریەکە و بەگوێرەی خواردنی هەڵیگرتەوە. ");
INSERT INTO ckb_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","موسا پێی گوتن: «هیچ کەس لێی نەمێنێتەوە بۆ بەیانی.» ");
INSERT INTO ckb_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","بەڵام گوێیان لە موسا نەگرت، بەڵکو هەندێک خەڵک لێیان هێشتەوە بۆ بەیانی، جا کرم لێیدا و کەڕووی کرد، موساش لێیان تووڕە بوو. ");
INSERT INTO ckb_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","ئیتر هەموو بەیانییەک هەڵیاندەگرتەوە، هەرکەسە بەگوێرەی خواردنی، کە خۆریش گەرم دادەهات دەتوایەوە. ");
INSERT INTO ckb_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","ئەوە بوو لە ڕۆژی شەشەمدا دوو ئەوەندە نانیان هەڵگرتەوە، دوو ئۆمر بۆ هەر یەکێک، ئیتر هەموو ڕابەرەکانی کۆمەڵ هاتن و بە موسایان ڕاگەیاند. ");
INSERT INTO ckb_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","ئەویش پێی گوتن: «ئەمە ئەوەیە کە یەزدان فەرموویەتی: ”بەیانی پشوودانە، شەممەی پیرۆزە بۆ یەزدان، ئەوەی دەیکەن بە نان بیکەن و ئەوەی لێی دەنێن لێی بنێن، هەرچی دەمێنێتەوەش لەلای خۆتانی دابنێن هەتا بۆ بەیانی هەڵبگیردرێت.“» ");
INSERT INTO ckb_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","جا دایاننا بۆ بەیانی هەروەک موسا فەرمانی دا، ئیتر نە کەڕووی کرد و نە کرم لێی دا. ");
INSERT INTO ckb_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","موسا گوتی: «ئەمڕۆ بیخۆن، چونکە ئەمڕۆ شەممەیە بۆ یەزدان، لە دەشتودەر نایدۆزنەوە. ");
INSERT INTO ckb_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","شەش ڕۆژ هەڵیدەگرنەوە، بەڵام لە ڕۆژی حەوتەم شەممەیە و تێیدا نییە.» ");
INSERT INTO ckb_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","ئەوە بوو لە ڕۆژی حەوتەم هەندێک لە خەڵکەکە چوونە دەرەوە بۆ ئەوەی هەڵیبگرنەوە، بەڵام نەیاندۆزییەوە. ");
INSERT INTO ckb_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","یەزدانیش بە موسای فەرموو: «هەتا کەی ئێوە ڕەتی دەکەنەوە فەرمان و فێرکردنەکەم بپارێزن؟ ");
INSERT INTO ckb_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","بڕوانن، یەزدان شەممەی پێداون، بۆیە لە ڕۆژی شەشەمدا نانی دوو ڕۆژتان پێدەدات، با هەریەکە لە شوێنی خۆی دابنیشێت، با کەس لە ڕۆژی حەوتەم شوێنی خۆی بەجێنەهێڵێت.» ");
INSERT INTO ckb_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","ئیتر گەل لە ڕۆژی حەوتەم پشوویان دا. ");
INSERT INTO ckb_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","بنەماڵەی ئیسرائیلیش ناویان لە نانەکە نا مەن. وەک تۆوی گژنیژ سپییە و تامیشی وەک ناسکە نانی بە هەنگوینە. ");
INSERT INTO ckb_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","موسا گوتی: «ئەمە ئەو شتەیە کە یەزدان فەرمانی کردووە: ”ئۆمرێکی لێ پڕ بکەن و با بۆ نەوەکانتان بپارێزرێت، بۆ ئەوەی ئەو نانە ببینن کە لە چۆڵەوانی دەرخواردم دان کاتێک لە خاکی میسر دەرمهێنان.“» ");
INSERT INTO ckb_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","ئینجا موسا بە هارونی گوت: «گۆزە ببە و پڕ بە ئۆمرێک مەنی تێبکە. ئینجا لەبەردەم یەزدانی دابنێ تاکو بۆ نەوەکانتان بپارێزرێت.» ");
INSERT INTO ckb_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","هەروەک یەزدان فەرمانی بە موسا دا، لە دواییدا هارون مەنەکەی لەناو سندوقەکەی پەیمان دانا بۆ پاراستنی. ");
INSERT INTO ckb_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","نەوەی ئیسرائیل چل ساڵ مەنیان خوارد هەتا هاتنە خاکی ئاوەدانی، مەنیان خوارد هەتا هاتنە سنووری خاکی کەنعان. ");
INSERT INTO ckb_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","ئۆمریش دەیەکی ئێفەیە. ");
INSERT INTO ckb_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","هەموو کۆمەڵی نەوەی ئیسرائیل لە چۆڵەوانی سینەوە کۆچیان کرد، بەگوێرەی کۆچەکانیان کاتێک یەزدان فەرمانی پێ دەکردن، لە ڕەفیدیم لایاندا، بەڵام ئاو نەبوو بۆ خواردنەوە بۆ گەل. ");
INSERT INTO ckb_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","جا گەل کردیان بە دەمەقاڵێ لەگەڵ موسا و گوتیان: «ئاومان بدەنێ بیخۆینەوە.» موساش وەڵامی دانەوە: «بۆچی دەمەقاڵێم لەگەڵ دەکەن؟ بۆچی یەزدان تاقی دەکەنەوە؟» ");
INSERT INTO ckb_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","بەڵام گەل لەوێ تینوویان بوو و کەوتنە بۆڵەبۆڵ لەسەر موسا. گوتیان: «بۆچی ئێمەت لە میسرەوە هێنایە دەرەوە، هەتا خۆمان و منداڵ و مەڕوماڵاتمان بە تینووێتی بمرین؟» ");
INSERT INTO ckb_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","ئیتر موسا هاواری بۆ یەزدان کرد و گوتی: «چی لەم گەلە بکەم؟ پاش کەمێکی دیکە بەردبارانم دەکەن.» ");
INSERT INTO ckb_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","یەزدانیش بە موسای فەرموو: «لەپێش گەلدا بڕۆ و هەندێک پیری ئیسرائیل لەگەڵ خۆت ببە و ئەو گۆچانەش کە پێی لە ڕووباری نیلت دا لەگەڵ دەستت بیبە و بڕۆ. ");
INSERT INTO ckb_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","من لەپێشت لەوێ لەسەر ئەو تاشەبەردە لە حۆرێڤ وەستاوم. لە تاشەبەردەکە دەدەیت، ئاوی لێ هەڵدەقوڵێت و گەل دەیخۆنەوە.» موساش بەم جۆرەی کرد لەبەرچاوی پیرانی ئیسرائیل. ");
INSERT INTO ckb_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","ئەو شوێنەیان ناو نا مەسا و مەریبا، لەبەر دەمەقاڵێی نەوەی ئیسرائیل و لەبەر ئەوەی یەزدانیان تاقی کردەوە و گوتیان «ئایا یەزدان لەنێوانمانە یان نا؟» ");
INSERT INTO ckb_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","عەمالێقییەکان هاتن و شەڕیان لەگەڵ ئیسرائیل کرد لە ڕەفیدیم. ");
INSERT INTO ckb_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","موساش بە یەشوعی گوت: «چەند پیاوێکمان بۆ هەڵبژێرە و بڕۆ لە دژی عەمالێقییەکان شەڕ بکە، من بەیانی لەسەر سەری گردەکە دەوەستم و گۆچانەکەی خوداش لە دەستم دەبێت.» ");
INSERT INTO ckb_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","یەشوعیش بە قسەی موسای کرد، لە دژی عەمالێقییەکان جەنگا، موسا و هارون و حووریش سەرکەوتنە سەر گردەکە. ");
INSERT INTO ckb_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","ئەوە بوو کاتێک موسا دەستی بەرز دەکردەوە، نەوەی ئیسرائیل سەردەکەوتن، بەڵام کاتێک دەستی دەهێنایە خوارەوە، عەمالێقییەکان سەردەکەوتن. ");
INSERT INTO ckb_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","کاتێک دەستەکانی موسا قورس بوون، بەردێکیان هێنا و خستیانە ژێری و ئەویش لەسەری دانیشت. ئینجا هارون و حوور یەکێکیان لەم لاوە و ئەوی دیکە لەو لاوە دەستیان گرت، ئیتر هەتا ئاوابوونی خۆر دەستەکانی بە بەرزکراوەیی مایەوە. ");
INSERT INTO ckb_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","یەشوعیش بە شمشێر عەمالێق و لەشکرەکەی بەزاند. ");
INSERT INTO ckb_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","یەزدانیش بە موسای فەرموو: «ئەمە وەک یاداشتێک لە پەڕەیەک بنووسە و بۆ یەشوعی بخوێنەوە، چونکە بە تەواوی یادگاری عەمالێق لەژێر ئاسمان دەسڕمەوە.» ");
INSERT INTO ckb_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","موساش قوربانگایەکی دروستکرد و ناوی لێنا «یەزدان ئاڵای منە» و ");
INSERT INTO ckb_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","گوتی: «لەبەر ئەوەی عەمالێق دەستی بەرزکردووەتەوە لە دژی تەختی یەزدان، یەزدان نەوە لەدوای نەوە لە دژی عەمالێق لە جەنگدا دەبێت.» ");
INSERT INTO ckb_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","یەترۆی خەزووری موسا کە کاهینی میدیان بوو، هەموو ئەو شتانەی بیستەوە کە خودا لەگەڵ موسا و ئیسرائیلی گەلەکەی کردبووی، کە یەزدان ئیسرائیلی لە میسرەوە دەرهێناوە. ");
INSERT INTO ckb_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","لەدوای ئەوەی موسا چیپۆرەی ژنی ناردبووەوە یەترۆی خەزووری هێنایەوە، ");
INSERT INTO ckb_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","لەگەڵ هەردوو کوڕەکەی. ناوی یەکێکیان گێرشۆمە، چونکە موسا گوتی: «نامۆ بووم لە خاکی بێگانە.» ");
INSERT INTO ckb_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","ناوی ئەوەی دیکەشیان ئەلیعەزەر بوو، چونکە گوتی: «خودای باوکم یارمەتیدەرم بوو و فریام کەوت لە شمشێری فیرعەون.» ");
INSERT INTO ckb_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","یەترۆی خەزووری موسا و کوڕەکانی و ژنەکەی هاتنە لای موسا بۆ ئەو چۆڵەوانییەی ئەو لەوێ لەلای کێوی خودا لایدابوو. ");
INSERT INTO ckb_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","یەترۆ هەواڵی بۆ موسا نارد: «من یەترۆم، لەگەڵ ژنەکەت و دوو کوڕەکەی بۆ لای تۆ هاتووم.» ");
INSERT INTO ckb_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","موساش هاتە دەرەوە بۆ پێشوازی خەزووری، کڕنۆشی برد و ماچی کرد، لە هەواڵی یەکتریان پرسی و چوونە ناو چادرەکە. ");
INSERT INTO ckb_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","موساش هەموو ئەو شتانەی بۆ خەزووری گێڕایەوە کە یەزدان بە فیرعەون و میسرییەکانی کرد لە پێناوی گەلی ئیسرائیل و هەموو ئەو ناخۆشییانەی لە ڕێگا تووشیان هات و یەزدان فریایان کەوت. ");
INSERT INTO ckb_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","یەترۆش دڵخۆش بوو بەو هەموو چاکەیەی کە یەزدان لەگەڵ نەوەی ئیسرائیل کردی، کە فریایان کەوتبوو لە دەستی میسرییەکان. ");
INSERT INTO ckb_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","یەترۆ گوتی: «ستایش بۆ یەزدان ئەوەی لە دەستی میسرییەکان و لە دەستی فیرعەون فریاتان کەوت، ئەوەی فریای گەل کەوت لەژێر دەستی میسرییەکان. ");
INSERT INTO ckb_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","کاتێک بەو شتانە لووتبەرز بوون لەسەر ئیسرائیلییەکان، ئێستا زانیم کە یەزدان لە هەموو خوداوەندەکان مەزنترە.» ");
INSERT INTO ckb_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","جا یەترۆی خەزووری موسا قوربانی سووتاندن و چەند قوربانییەکی دیکەی بۆ خودا هێنا، هارون و هەموو پیرانی ئیسرائیلیش هاتن بۆ ئەوەی لەگەڵ خەزووری موسا بە ئامادەبوونی خودا نان بخۆن. ");
INSERT INTO ckb_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","ئەوە بوو بەیانی موسا دانیشت بۆ ئەوەی دادوەری بۆ گەل بکات، ئیتر گەل لە بەیانییەوە هەتا ئێوارە لەلای موسا ڕاوەستان. ");
INSERT INTO ckb_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","کاتێک خەزووری موسا هەموو ئەو شتانەی بینی کە موسا بۆ گەل دەیکات، لێی پرسی: «ئەم شتە چییە تۆ بۆ گەل دەکەیت؟ لەبەرچی بە تەنها دانیشتوویت و لە بەیانییەوە هەتا ئێوارە هەموو گەل لەلات ڕاوەستاون؟» ");
INSERT INTO ckb_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","موساش وەڵامی خەزووری دایەوە: «لەبەر ئەوەی گەل دێنە لام هەتا خواستی خودا بزانن. ");
INSERT INTO ckb_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","هەروەها کاتێک کێشەیەکیان هەبێت دێنە لام، منیش دادوەری نێوان پیاو و برادەرەکەی دەکەم و فەرز و فێرکردنی خودایان پێ دەناسێنم.» ");
INSERT INTO ckb_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","خەزووری موساش پێی گوت: «ئەوەی تۆ دەیکەیت باش نییە. ");
INSERT INTO ckb_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","خۆت و ئەم گەلەش ماندوو دەکەیت کە لەگەڵتن، چونکە کارەکە لە تۆ مەزنترە، ناتوانیت بە تەنها بیکەیت. ");
INSERT INTO ckb_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","ئێستاش گوێم لێ بگرە و ئامۆژگاریت دەکەم، با خودات لەگەڵ بێت، تۆ نوێنەری گەل بە لە بەرامبەر خودا و داواکارییەکانیان پێشکەش بە خودا بکە. ");
INSERT INTO ckb_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","فێری فەرز و فێرکردنیان بکە و ئەو ڕێگایەیان پێ بناسێنە کە دەبێت بیگرنەبەر و ئەو ئەرکانەی کە دەبێت بیانکەن. ");
INSERT INTO ckb_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","بەڵام لەناو هەموو گەلدا پیاوی بە توانا و لەخواترس هەڵدەبژێریت، پیاوانی دڵسۆز کە ڕقیان لە دەستکەوتی ناڕەوایە، دەیانکەیتە کاربەدەست بەسەر هەزاران و سەدان و پەنجایان و دەیان. ");
INSERT INTO ckb_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","هەموو کاتێک دادوەری بۆ گەل دەکەن و هەر داوایەکی گەورە هەبێت دەیهێننە لای تۆ، هەر داوایەکیش بچووک بێت خۆیان بڕیاری لەسەر دەدەن. ئەوە بارت سووک دەکات، چونکە ئەوان لەگەڵت هەڵدەگرن. ");
INSERT INTO ckb_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","ئەگەر ئەم کارەت کرد و خوداش فەرمانی پێ کردیت، ئەوا دەتوانیت خۆت ڕابگریت و هەروەها هەموو ئەم گەلەش بە ڕەزامەندی دەگەنە شوێنی خۆیان.» ");
INSERT INTO ckb_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","موساش گوێی لە قسەکانی خەزووری گرت و هەموو ئەو شتانەشی کرد کە گوتی. ");
INSERT INTO ckb_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","موسا پیاوی بە توانای لە هەموو ئیسرائیل هەڵبژارد و کردنی بە ڕابەر بۆ گەل، کاربەدەست بەسەر هەزاران و سەدان و پەنجایان و دەیان. ");
INSERT INTO ckb_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","ئیتر هەموو کاتێک دادوەریان بۆ گەل دەکرد و داوای گرانیشیان دەهێنایە لای موسا. بەڵام هەموو داوایەکی بچووک خۆیان دادوەریان تێدا دەکرد. ");
INSERT INTO ckb_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","ئینجا موسا خەزووری بەڕێکرد و یەترۆش گەڕایەوە خاکی خۆی. ");
INSERT INTO ckb_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","دوای ئەوەی نەوەی ئیسرائیل میسریان بەجێهێشت، ڕێک لە سەرەتای مانگی سێیەمدا گەیشتنە چۆڵەوانی سینا. ");
INSERT INTO ckb_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","لە ڕەفیدیمەوە کۆچیان کرد و هاتنە چۆڵەوانی سینا و لەوێ لەبەردەم کێوەکە لایاندا. ");
INSERT INTO ckb_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","موساش سەرکەوت بۆ لای خودا، یەزدان لە کێوەکەوە بانگی کرد و فەرمووی: «ئاوا بە بنەماڵەی یاقوب دەڵێیت و ئاوا بە نەوەی ئیسرائیل ڕادەگەیەنیت: ");
INSERT INTO ckb_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","”خۆتان ئەوەتان بینی کە بە میسرییەکانم کرد، ئێوەشم لەسەر باڵی هەڵۆکان هەڵگرت و ئێوەم بۆ لای خۆم هێنا. ");
INSERT INTO ckb_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","ئێستاش ئەگەر ئێوە بە تەواوی گوێم لێ بگرن و پەیمانەکەم بپارێزن، ئەوا گەنجینەیەکی تایبەت دەبن بۆ من لەنێو هەموو گەلان. هەرچەندە هەموو زەوی هی منە، ");
INSERT INTO ckb_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","بەڵام ئێوە بۆم دەبنە پاشایەتی کاهینان و نەتەوەیەکی پیرۆز.“ ئەمانە ئەو وشانەن کە بە نەوەی ئیسرائیلی دەڵێیت.» ");
INSERT INTO ckb_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","موساش هات و هەموو پیرانی گەلی بانگکرد و هەموو ئەو وشانەی لەبەردەمیان دانا کە یەزدان فەرمانی پێ کردبوو. ");
INSERT INTO ckb_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","هەموو گەلیش پێکەوە وەڵامیان دایەوە و گوتیان: «هەموو ئەوەی یەزدان فەرموویەتی دەیکەین.» موساش قسەکانی گەلی بۆ یەزدان گێڕایەوە. ");
INSERT INTO ckb_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","یەزدانیش بە موسای فەرموو: «من لە چڕی هەوردا دێمە لات، بۆ ئەوەی گەل گوێی لێبێت کاتێک لەگەڵت دەدوێم و هەتاهەتایە باوەڕت پێ بکەن.» موساش وتەکانی گەلی بە یەزدان ڕاگەیاند. ");
INSERT INTO ckb_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","هەروەها یەزدان بە موسای فەرمووی: «بڕۆ لای گەل و ئەمڕۆ و بەیانی تەرخانیان بکە. با جلەکانیان بشۆن و ");
INSERT INTO ckb_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","ئامادە بن بۆ ڕۆژی سێیەم، چونکە لە ڕۆژی سێیەم یەزدان لەبەرچاوی هەموو گەل دێتە خوارەوە بۆ سەر شاخی سینا. ");
INSERT INTO ckb_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","بە چواردەوری کێوەکەدا سنوور بۆ گەل دادەنێیت و دەڵێیت: ”ئاگاداری خۆتان بن، نە نزیک کێوەکە بکەونەوە، نە دەست لە بنارەکەی بدەن، چونکە هەرکەسێک دەست لە کێوەکە بدات دەبێت بکوژرێت. ");
INSERT INTO ckb_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","ئاژەڵ بێت یان مرۆڤ، نابێت بژیێت، دەبێت بەردباران یان تیرباران بکرێت، بەبێ ئەوەی کەس دەستی پێی بکەوێت.“ بەڵام لە کاتی فووکردنێکی بەهێز بە کەڕەنادا، ئەوان لە کێوەکە نزیک دەبنەوە.» ");
INSERT INTO ckb_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","موساش لە کێوەکە هاتە خوارەوە بۆ لای گەل و تەرخانی کردن، ئەوانیش جلەکانیان شوشت. ");
INSERT INTO ckb_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","بە گەلی گوت: «ئامادە بن بۆ ڕۆژی سێیەم، لە ئافرەت نزیک مەکەونەوە.» ");
INSERT INTO ckb_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","ئەوە بوو سەر لە بەیانی ڕۆژی سێیەم، بووە هەورەتریشقە و بروسک و تەمێکی چڕ لەسەر کێوەکە، دەنگی کەڕەنا زۆر بەرزبووەوە، هەموو گەل ئەوانەی لە ئۆردوگاکە بوون کەوتنە لەرزین. ");
INSERT INTO ckb_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","ئینجا موسا گەلی لە ئۆردوگاکەوە دەرهێنا بۆ دیداری خودا، جا لە بناری کێوەکە ڕاوەستان. ");
INSERT INTO ckb_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","هەموو شاخی سیناش دووکەڵی دەکرد لەبەر ئەوەی یەزدان بە ئاگرەوە هاتە خوارەوە بۆ سەری و دووکەڵیش وەک دووکەڵی کوورە بەرزبووەوە و هەموو کێوەکەش بە توندی لەرزی. ");
INSERT INTO ckb_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","دەنگی کەڕەناش جار لەدوای جار بەرزتر دەبوو. موسا دەدوا و خوداش بە دەنگ وەڵامی دەدایەوە. ");
INSERT INTO ckb_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","یەزدان هاتە خوارەوە بۆ سەر شاخی سینا و موسای بۆ سەر کێوەکە بانگکرد. موساش سەرکەوت. ");
INSERT INTO ckb_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","یەزدان بە موسای فەرموو: «بڕۆ خوارەوە و گەل ئاگادار بکەرەوە، نەوەک پێشێلی بکەن بۆ بینینی یەزدان و زۆریان لەناوبچن. ");
INSERT INTO ckb_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","هەروەها ئەو کاهینانەش کە لە یەزدان نزیک دەبنەوە، با خۆیان تەرخان بکەن، نەوەک یەزدان بە ڕوویاندا هەڵبشاخێت.» ");
INSERT INTO ckb_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","موساش بە یەزدانی گوت: «گەل ناتوانێت بۆ شاخی سینا سەربکەوێت، چونکە تۆ ئاگادارت کردینەوە و فەرمووت: ”سنوور بۆ کێو دابنێ و تەرخانی بکە.“» ");
INSERT INTO ckb_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","یەزدانیش پێی فەرموو: «بڕۆ خوارەوە، پاشان لەگەڵ هارون سەربکەوە، بەڵام با کاهینەکان و گەل هەوڵی سەرکەوتن نەدەن بۆ لای یەزدان، نەوەک بە ڕوویاندا هەڵبشاخێت.» ");
INSERT INTO ckb_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","ئیتر موسا بۆ لای گەل چووە خوارەوە و پێی گوتن. ");
INSERT INTO ckb_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","خودا هەموو ئەم فەرمایشتانەی بە گەل فەرموو: ");
INSERT INTO ckb_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","«من یەزدانی پەروەردگارتانم کە لە خاکی میسرەوە دەرمهێنان، لە خاکی کۆیلایەتییەوە. ");
INSERT INTO ckb_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","«هیچ کەسێکتان خودای دیکەی بێجگە لە منتان نەبێت. ");
INSERT INTO ckb_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","پەیکەر بۆ خۆتان دروستمەکەن، نە لە هیچ شێوەیەکی ئەوانەی لە ئاسمانن لە سەرەوە، نە ئەوانەی لەسەر زەوین لە خوارەوە، نە ئەوانەی لەناو ئاون لەژێر زەوییەوە. ");
INSERT INTO ckb_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","کڕنۆشیان بۆ مەبەن و مەیانپەرستن، چونکە منی یەزدانی پەروەردگارتان خودایەکی ئیرەدارم، سزای گوناهی باوکان لەسەر نەوەکانیشان جێبەجێ دەکەم هەتا نەوەی سێیەم و چوارەمی ناحەزەکانم، ");
INSERT INTO ckb_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","بەڵام خۆشەویستی نەگۆڕ بۆ هەزاران لە خۆشەویستانم دەردەخەم، ئەوانەی گوێڕایەڵی ڕاسپاردەکانم دەبن. ");
INSERT INTO ckb_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","ناوی یەزدانی پەروەردگارتان بۆ شتی پووچ مەهێنن، چونکە ئەو کەسانە لەلای یەزدان ئەستۆپاک نابن کە بۆ شتی پوچەڵ ناوی دەهێنن. ");
INSERT INTO ckb_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","ڕۆژی شەممەتان لە یاد بێت، تاکو بە پیرۆزی ڕایبگرن. ");
INSERT INTO ckb_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","شەش ڕۆژ ئیش دەکەن و هەموو کارەکەتان دەکەن، ");
INSERT INTO ckb_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","بەڵام ڕۆژی حەوتەم شەممەیە بۆ یەزدانی پەروەردگارتان، هیچ کارێک مەکەن. خۆتان و کوڕ و کچ و خزمەتکار و کارەکەر و ئاژەڵەکانتان و ئەو نامۆیەی لەناو دەروازەی شارەکەتانە هیچ کارێک مەکەن، ");
INSERT INTO ckb_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","چونکە یەزدان لە شەش ڕۆژدا ئاسمان و زەوی و دەریا و هەموو ئەو شتانەی تێیاندایە دروستی کردن، بەڵام لە ڕۆژی حەوتەمدا پشووی دا، لەبەر ئەمە یەزدان ڕۆژی شەممەی بەرەکەتدار و پیرۆز کرد. ");
INSERT INTO ckb_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","ڕێزی دایک و باوکتان بگرن، بۆ ئەوەی تەمەن درێژ بن لەو خاکەی یەزدانی پەروەردگارتان پێتان دەدات. ");
INSERT INTO ckb_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","مەکوژن. ");
INSERT INTO ckb_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","داوێنپیسی مەکەن. ");
INSERT INTO ckb_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","دزی مەکەن. ");
INSERT INTO ckb_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","بە درۆ شایەتی لەسەر کەس مەدەن. ");
INSERT INTO ckb_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","چاو مەبڕنە ژنی کەس. چاو مەبڕنە ماڵ و خزمەتکار و کارەکەر و گا و مانگا و گوێدرێژی هیچ کەسێک و هەر شتێک کە هی کەسێکی دیکە بێت.» ");
INSERT INTO ckb_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","کاتێک هەموو گەل بروسک و کێوەکەیان بینی دووکەڵی دەکرد، گوێیان لە هەورەتریشقە و دەنگی کەڕەنا بوو، لەرزین و لە دوورەوە وەستان. ");
INSERT INTO ckb_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","بە موساشیان گوت: «تۆ لەگەڵمان بدوێ و گوێ دەگرین. با خودا لەگەڵمان نەدوێت، نەوەک بمرین.» ");
INSERT INTO ckb_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","موساش بە گەلی گوت: «مەترسن. خودا هاتووە بۆ ئەوەی تاقیتان بکاتەوە، تاکو ترسی ئەوتان لەبەرچاو بێت و گوناه نەکەن.» ");
INSERT INTO ckb_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","گەل لە دوورەوە وەستان و موساش لە تەمە چڕەکە نزیک بووەوە، کە خودای لێ بوو. ");
INSERT INTO ckb_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","یەزدان بە موسای فەرموو: «ئاوا بە نەوەی ئیسرائیل دەڵێیت: ”ئێوە بینیتان کە لە ئاسمانەوە لەگەڵتان دوام. ");
INSERT INTO ckb_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","هیچ خوداوەندێک دروستمەکەن لەتەنیشت من بێت، بتی زیو و بتی زێڕ بۆ خۆتان دروستمەکەن. ");
INSERT INTO ckb_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","«”بە خۆڵ قوربانگام بۆ دروستدەکەیت و قوربانی سووتاندنەکان و قوربانییەکانی هاوبەشیت لە مەڕ و بزن و گاگەلەکەت لەسەری سەردەبڕیت، لە هەموو ئەو شوێنانە وا دەکەم ناوم بێتەوە یاد، دێمە لات و بەرەکەتدارت دەکەم. ");
INSERT INTO ckb_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","ئەگەر بە بەرد قوربانگات بۆ دروستکردم، با بەردەکان تاشراو نەبن، چونکە هەر قەڵەم و چەکوشێکی بخەیتە سەر ئەوا گڵاوی دەکەیت. ");
INSERT INTO ckb_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","بە پەیژە سەرمەکەوە سەر قوربانگاکەم نەوەک ڕووتیت لەسەری دەربکەوێت.“ ");
INSERT INTO ckb_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","«ئەمانەش ئەو یاسایانەیە کە لەبەردەمیان دایدەنێیت: ");
INSERT INTO ckb_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","«ئەگەر کۆیلەیەکی عیبرانیتان کڕی ئەوا شەش ساڵ خزمەت دەکات و ساڵی حەوتەم بەخۆڕایی ئازاد دەبێت. ");
INSERT INTO ckb_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","ئەگەر بە تەنها هاتبوو ئەوا بە تەنها ئازاد دەبێت، بەڵام ئەگەر مێردی ژنێک بوو ئەوا ژنەکەشی لەگەڵی ئازاد دەبێت. ");
INSERT INTO ckb_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","ئەگەر گەورەکەی ژنێکی پێدابێت و ژنەکە کوڕ یان کچی بۆی بووبێت، ئەوا ژن و منداڵەکان بۆ گەورەکەی دەبن و ئەو بە تەنها ئازاد دەبێت. ");
INSERT INTO ckb_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","«بەڵام ئەگەر کۆیلەکە بە ڕاستی بڵێت: ”گەورەکەم و ژنەکەم و منداڵەکانم خۆشدەوێت و ئازاد نابم،“ ");
INSERT INTO ckb_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","ئەوا گەورەکەی پێویستە بیباتە پێش خودا. ئینجا نزیکی دەکاتەوە لە دەرگاکە یان لەلایەکی چوارچێوەی دەرگاکە، گەورەکەی بە درێشە گوێی کون دەکات، ئەویش هەتاهەتایە خزمەتی دەکات. ");
INSERT INTO ckb_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","«ئەگەر پیاوێک کچەکەی خۆی فرۆشت وەک کۆیلە، ئەوا وەک پیاوێکی کۆیلە ئازاد نابێت. ");
INSERT INTO ckb_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","ئەگەر کچەکە نەبێتە جێی ڕەزامەندی گەورەکەی، کە نیشانی کردووە بۆ خۆی، ئەوا دەبێت ڕێ بە کچەکە بدات بکڕدرێتەوە. ئیتر مافی فرۆشتنی نییە بە خەڵکێکی بێگانە، چونکە لەگەڵ کچەکە بێوەفا بووە. ");
INSERT INTO ckb_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","ئەگەر کچەکەی نیشان کرد بۆ کوڕەکەی ئەوا پێویستە وەک کچی خۆی هەڵسوکەوتی لەگەڵ بکات. ");
INSERT INTO ckb_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","ئەگەر ژنێکی دیکەی هێنا، ئەوا پێویستە خواردن و بەرگ و جووتبوونی لەگەڵ ئەو کەم نەکاتەوە. ");
INSERT INTO ckb_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","ئەگەر یەکێک لەو سێیانەی بۆ نەکرد، ئەوا کەنیزەکە بەخۆڕایی ئازاد دەبێت. ");
INSERT INTO ckb_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","«ئەوەی لە کەسێک بدات و بمرێت، ئەوا دەبێت بکوژرێت. ");
INSERT INTO ckb_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","بەڵام ئەوەی مەبەستی نەبوو، بەڵکو خودا هێشتی ڕوو بدات، ئەوا من شوێنێکت بۆ دیاری دەکەم هەتا هەڵبێت بۆ ئەوێ. ");
INSERT INTO ckb_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","بەڵام ئەگەر یەکێک فێڵ لە برادەرەکەی بکات و بە ئەنقەست بیکوژێت، ئەوا لەلای قوربانگاکەمەوە دەیبەیت بۆ کوشتن. ");
INSERT INTO ckb_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","«ئەوەی لە دایک و باوکی بدات، ئەوا دەبێت بکوژرێت. ");
INSERT INTO ckb_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","«ئەوەی کەسێک بڕفێنێت و بیفرۆشێت یان لەلای بیبیننەوە، ئەوا دەبێت بکوژرێت. ");
INSERT INTO ckb_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","«ئەوەی نەفرەت لە باوکی یان دایکی بکات، دەبێت بکوژرێت. ");
INSERT INTO ckb_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","«کاتێک دوو پیاو ناکۆکییان دەبێت و یەکێکیان بە بەرد یان بە مست لە برادەرەکەی بدات و نەمرد بەڵکو لە جێگا کەوت، ");
INSERT INTO ckb_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","ئەگەر هەستایەوە و لە دەرەوە بە گۆچانەکەی ڕۆیشت، ئەوا ئەوەی لێیداوە بێتاوان دەبێت، تەنها قەرەبووی ئەو کاتەی بۆ بکاتەوە و خەرجی چارەسەرییەکەی بدات، هەتا بە تەواوی چاک دەبێتەوە. ");
INSERT INTO ckb_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","«ئەگەر کەسێک بە دار لە کۆیلەکەی یان کارەکەرەکەی بدات و لەژێر دەستیدا بمرێت، ئەوا سزا دەدرێت، ");
INSERT INTO ckb_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","بەڵام ئەگەر لەدوای ڕۆژێک یان دووان چاک بووەوە، ئەوا سزا نادرێت، چونکە موڵکی خۆیەتی. ");
INSERT INTO ckb_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","«ئەگەر چەند پیاوێک شەڕیان کرد و بە ڕێککەوت لە ژنێکی سکپڕیان دا و بەهۆیەوە منداڵەکەی پێش کاتی خۆی لەدایک بوو، بەڵام زیانی کوشندەی نەبوو، ئەوا بێگومان بەگوێرەی دادگا سزای ماددی دەدرێن، بەپێی ئەوەی مێردی ژنەکە لەسەریان دادەنێت. ");
INSERT INTO ckb_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","بەڵام ئەگەر زیانی کوشندەی هەبێت، ئەوا گیان لە جێی گیان دەبێت، ");
INSERT INTO ckb_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","چاو بە چاو، ددان بە ددان، دەست بە دەست، پێ بە پێ، ");
INSERT INTO ckb_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","سووتان لە جێی سووتان، برین لە جێی برین و لێدان لە جێی لێدان. ");
INSERT INTO ckb_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","«کاتێک یەکێک لە چاوی کۆیلەکەی یان چاوی کارەکەرەکەی دا و کوێری کرد، ئەوا ئازادی دەکات لە جیاتی چاوی. ");
INSERT INTO ckb_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","ئەگەر ددانی کۆیلەکەی یان کارەکەرەکەی کەوت، ئەوا ئازادی دەکات لە جیاتی ددانی. ");
INSERT INTO ckb_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","«ئەگەر گایەک قۆچی لە پیاوێک یان لە ژنێک دا و مرد، ئەوا گایەکە بەردباران دەکرێت و گۆشتەکەشی ناخورێت، بەڵام خاوەنی گایەکە بێتاوان دەبێت. ");
INSERT INTO ckb_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","بەڵام ئەگەر گایەکە پێشتر قۆچوەشێن بێت، خاوەنەکەی ئاگادار کرابێتەوە بەڵام لە پشتیرەکە بەندی نەکردبێت، پیاوێک یان ژنێکی کوشت، ئەوا گایەکە بەردباران دەکرێت و خاوەنەکەشی دەکوژرێت. ");
INSERT INTO ckb_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","ئەگەر نرخ بخرێتە سەری، ئەوا بۆ کڕینەوەی ژیانی خۆی هەرچی بکەوێتە سەر دەبێت بیدات. ");
INSERT INTO ckb_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","ئەگەر قۆچ لە کوڕێک یان لە کچێک بدات، ئەوا هەمان ئەو حوکمەی لەسەر جێبەجێ دەکرێت. ");
INSERT INTO ckb_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","ئەگەر گایەکە قۆچ لە کۆیلەیەک یان کارەکەرێک بدات، ئەوا گەورەکەی سی شاقل زیو دەدات و گایەکەش بەردباران دەکرێت. ");
INSERT INTO ckb_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","«کاتێک کەسێک سەری بیرێک دەکاتەوە یان بیرێک لێدەدات و سەرەکەی دانەپۆشێت، گایەک یان گوێدرێژێک بکەوێتە ناوی، ");
INSERT INTO ckb_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","ئەوا خاوەن بیرەکە قەرەبوو دەداتەوە و زیو دەداتە خاوەنەکەی، ئاژەڵە مردارەوەبووەکەش یان تۆپیوەکە بۆ ئەو دەبێت. ");
INSERT INTO ckb_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","«ئەگەر گای کەسێک لە گای برادەرەکەی دا و کوشتی، ئەوا گایە زیندووەکە دەفرۆشن و نرخەکەی بەش دەکەن، هەروەها گایە مردارەوەبووەکەش دابەش دەکەن. ");
INSERT INTO ckb_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","ئەگەر زانراش کە گایەکە پێشتر قۆچوەشێن بووە و خاوەنەکەی لە پشتیرەکە بەندی نەکردووە، ئەوا خاوەن گا قۆچوەشێنەکە دەبێت گایەک لە جێی گایەک بدات و تەنها گایە مردارەوەبووەکەش وەربگرێت. ");
INSERT INTO ckb_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","«کاتێک کەسێک گایەک یان بەرخێک دەدزێت، سەری بڕی یان فرۆشتی، ئەوا پێنج مانگا لە جێی گایەکە و چوار مەڕیش لە جێی بەرخەکە دەداتەوە. ");
INSERT INTO ckb_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","«ئەگەر دزەکە بە شەو بینرا خەریکی بڕین بوو و لێی درا و مرد، ئەوا مافی خوێنی نییە، ");
INSERT INTO ckb_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","بەڵام ئەگەر دوای خۆر هەڵاتن بوو ئەوا مافی خوێنی هەیە. «دزێک دەبێت قەرەبوو بداتەوە، ئەگەر نەبوونیش بوو ئەوا دەفرۆشرێت. ");
INSERT INTO ckb_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","ئەگەر ئاژەڵە دزراوەکەی بە زیندوویی لە دەستی گیرا، لە گایەکەوە هەتا گوێدرێژێک و بەرخێک، ئەوا دووان لە جێیان دەداتەوە. ");
INSERT INTO ckb_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","«ئەگەر کەسێک ماڵاتی خۆی لەناو کێڵگە یان ڕەزەمێوێکدا بلەوەڕێنێت و ڕێگا بدات بچنە ناو کێڵگەی کەسێکی دیکە بلەوەڕێن، ئەوا لە باشترینی بەری کێڵگەکەی یان ڕەزەمێوەکەی قەرەبوو دەداتەوە. ");
INSERT INTO ckb_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","«ئەگەر ئاگر دەربپەڕێت و دەوەن بگرێتەوە و خەرمانکراو یان دەغڵ یان کێڵگە بسووتێنێت، ئەوا ئەوەی ئاگرەکەی کردووەتەوە دەبێت قەرەبوو بدات. ");
INSERT INTO ckb_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","«ئەگەر یەکێک زیو یان شتومەک لەلای کەسێک دابنێت بۆ ئەوەی چاوی لێی بێت و لە ماڵی ئەو کەسە دزرا کە ئاماناتەکەی لەلایە، ئەگەر دزەکە گیرا ئەوا دوو ئەوەندە قەرەبوو دەداتەوە. ");
INSERT INTO ckb_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","بەڵام ئەگەر دزەکە نەگیرا ئەوا خاوەن ماڵ دەهێنرێتە بەردەم دادوەرەکان، هەتا بزانرێت ئاخۆ دەستی بۆ موڵکی برادەرەکەی درێژ نەکردووە. ");
INSERT INTO ckb_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","لە هەموو داوایەکی تاوان لەسەر گا، گوێدرێژ، بەرخ، جلوبەرگ یان هەر شتێکی ونبوو کە بگوترێت: ”ئەمە هی منە،“ ئەوا داوای هەردووکیان دەهێنرێتە لای دادوەرەکان، ئەوەی دادوەر تاوانباری بکات، ئەوا دوو ئەوەندە قەرەبوو بۆ نزیکەکەی دەداتەوە. ");
INSERT INTO ckb_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","«ئەگەر یەکێک گوێدرێژێک یان گایەک یان بەرخێک یان هەر ئاژەڵێکی بداتە دراوسێکەی بۆ ئەوەی چاوی لێی بێت، مردار بووەوە یان بریندار بوو یان تاڵان کرا و کەس نەیبینی، ");
INSERT INTO ckb_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","ئەوا سوێندخواردن بە یەزدان لەنێوانیان دەبێت، ئاخۆ دراوسێکە دەستی بۆ ماڵی کەسەکەی دیکە درێژ نەکردووە، خاوەنەکەشی دەبێت ڕازی بێت، ئیتر قەرەبوو نادات. ");
INSERT INTO ckb_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","بەڵام ئەگەر ئاژەڵەکە لەلای دراوسێکەی دزرا، ئەوا قەرەبووی خاوەنەکەی دەداتەوە. ");
INSERT INTO ckb_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","ئەگەر بووە نێچیری ئاژەڵ وەک شایەتی دەیهێنێتەوە، ئیتر قەرەبووی نێچیر ناداتەوە. ");
INSERT INTO ckb_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","«ئەگەر کەسێک داوای ئاژەڵێک لە دراوسێکەی بکات و لەلای بریندار بێت یان بمرێت و خاوەنەکەی لەگەڵی نەبێت، ئەوا دەبێت قەرەبوو بداتەوە، ");
INSERT INTO ckb_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","بەڵام ئەگەر خاوەنەکەی لەگەڵی بوو، ئەوا قەرەبوو ناداتەوە، ئەگەر بە کرێ بووبێت ئەوا کرێیەکەی دەدات. ");
INSERT INTO ckb_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","«ئەگەر پیاوێک کچێکی نیشان نەکراو هەڵبخەڵەتێنێت و لەگەڵی جووت بێت، ئەوا بۆ خۆی مارەی دەکات و مارەییش دەدات. ");
INSERT INTO ckb_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","ئەگەر باوکیشی ڕازی نەبوو بیداتێ، ئەوا زیوی بۆ دەکێشێت وەک مارەیی کچ. ");
INSERT INTO ckb_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","«ناهێڵیت جادووگەری ئافرەت بژیێت. ");
INSERT INTO ckb_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","«ئەوەی لەگەڵ ئاژەڵێک جووت بێت دەبێت بکوژرێت. ");
INSERT INTO ckb_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","«ئەوەی قوربانی بۆ هەر خودایەکی جیا لە یەزدان سەرببڕێت، ئەوا پێویستە قڕ بکرێت. ");
INSERT INTO ckb_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","«ستەم لە نامۆ مەکە و مەیچەوسێنەوە، چونکە خۆشتان لە خاکی میسر نامۆ بوون. ");
INSERT INTO ckb_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","«هیچ بێوەژن و هەتیوێک زەلیل مەکە. ");
INSERT INTO ckb_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","ئەگەر بە هەر شێوەیەک زەلیلت کردن و ئەگەر تەنها هاوارێکم بۆ بکەن، ئەوا بێگومان گوێ لە هاواریان دەگرم. ");
INSERT INTO ckb_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","تووڕەییم هەڵدەستێت و بە شمشێر دەتانکوژم و ژنەکانتان دەبنە بێوەژن و منداڵەکانتان دەبنە هەتیو. ");
INSERT INTO ckb_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","«ئەگەر پارەت بە قەرز دا بە هەر هەژارێک لە گەلەکەم ئەوانەی لەلاتن، بۆی مەبە بە سووخۆر، سوودی مەخەرە سەر. ");
INSERT INTO ckb_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","ئەگەر کەوای دراوسێکەت بە بارمتە گرت، هەتا ئاوابوونی خۆر، بۆی دەگەڕێنیتەوە، ");
INSERT INTO ckb_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","چونکە ئەوە تاکە پۆشاکە کە دراوسێکەت هەیەتی. چی دیکەی هەیە بۆ نوستن؟ ئیتر کاتێک هاوارم بۆ دەکات، گوێدەگرم، چونکە من میهرەبانم. ");
INSERT INTO ckb_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","«سووکایەتی بە خودا مەکە و نەفرەت لە هیچ سەرکردەیەکی گەلەکەت مەکە. ");
INSERT INTO ckb_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","«پێشکەشکردنی پڕی خەرمانەکەت و دڵۆپی گوشەرەکەت دوا مەخە. «نۆبەرەی کوڕەکانت دەدەیتە من. ");
INSERT INTO ckb_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","هەمان شت دەکەیت بە گا و بەرخەکانت، حەوت ڕۆژ لەگەڵ دایکی دەبێت، بەڵام لە ڕۆژی هەشتەم دەیدەیتە من. ");
INSERT INTO ckb_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","«ئێوە دەبنە گەلێکی پیرۆز بۆ من، بۆیە گۆشتێک لە دەشتودەر بووبێت بە نێچیر مەیخۆن، بۆ سەگی فڕێبدەن. ");
INSERT INTO ckb_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","«هەواڵی درۆ بڵاو مەکەرەوە، دەست لەگەڵ بەدکار تێکەڵ مەکە بۆ ئەوەی ببیتە شایەتی زۆرداری. ");
INSERT INTO ckb_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","«دوای کۆمەڵ مەکەوە بۆ کاری خراپ و لە سکاڵاکردندا بە خواری شایەتی مەدە. ");
INSERT INTO ckb_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","لایەنگری بۆ هەژار دەرمەخە لە سکاڵاکەی. ");
INSERT INTO ckb_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","«ئەگەر تووشی گا یان گوێدرێژی دوژمنەکەت بووی کە بەڕەڵا بووبێت، بۆی بگەڕێنەرەوە. ");
INSERT INTO ckb_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","ئەگەر گوێدرێژی ناحەزەکەتت بینی لەژێر بارەکەیدا کەوتووە، بەجێی مەهێڵە، بەڵکو پەلە بکە بۆ یارمەتیدانی. ");
INSERT INTO ckb_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","«مافی هەژار ڕەت مەکەرەوە لە سکاڵاکەی. ");
INSERT INTO ckb_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","لە قسەی درۆ دوور بکەوە. بێتاوان و ڕاستودروست مەکوژە، چونکە تاوانبار بێتاوان ناکەم. ");
INSERT INTO ckb_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","«بەرتیل وەرمەگرە، چونکە بەرتیل چاوساغان کوێر دەکات و قسەی ڕاستودروستان خوار دەکات. ");
INSERT INTO ckb_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","«نامۆ مەچەوسێنەوە، ئێوە خۆتان دەزانن نامۆ چۆن هەست دەکات، چونکە خۆشتان لە خاکی میسر نامۆ بوون. ");
INSERT INTO ckb_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","«شەش ساڵ زەوییەکەت دەچێنیت و بەرەکەی هەڵدەگریتەوە، ");
INSERT INTO ckb_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","بەڵام لە حەوتەمیندا دەیحەسێنیتەوە و لێی دەگەڕێیت، هەژارانی گەلەکەت لێی دەخۆن و بەرماوەکەشیان ئاژەڵی کێوی دەیخوات. هەمان شت دەکەیت لە ڕەزە مێوەکەت و لە زەیتوونەکەت. ");
INSERT INTO ckb_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","«شەش ڕۆژ کارەکەت دەکەیت، بەڵام ڕۆژی حەوتەم پشوو دەدەیت بۆ ئەوەی گا و گوێدرێژەکەشت بحەسێنەوە و کوڕی کارەکەرەکەت و ئەوەی لەلاشت نامۆیە هەناسەیەک بدەن. ");
INSERT INTO ckb_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","«ئاگاداربن لەوەی ڕێک ئەوە بکەن کە پێم فەرموون و ناوی خودایەکی دیکە مەهێنن، لە دەمتانەوە نەبیسترێت. ");
INSERT INTO ckb_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","«سێ جار لە ساڵێکدا جەژنم بۆ دەگێڕیت. ");
INSERT INTO ckb_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","«هەروەک فەرمانم پێکردن جەژنی فەتیرە بگێڕن، حەوت ڕۆژ نانی فەتیرە بخۆن. ئەم جەژنە لە کاتی خۆیدا بگێڕن، لە مانگی ئاڤیڤ، چونکە ئێوە لەو مانگەدا لە میسر هاتنە دەرەوە. «نابێت بە دەستبەتاڵی لەبەردەمم ئامادە بن. ");
INSERT INTO ckb_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","«هەروەها جەژنی دروێنە، یەکەمین بەرهەمی ڕەنجتان، ئەوەی لە کێڵگە دەیچێنن. «هەروەها جەژنی کۆکردنەوە لە کۆتایی ساڵدا کاتێک ڕەنجەکەتان لە کێڵگە کۆدەکەنەوە. ");
INSERT INTO ckb_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","«سێ جار لە ساڵێکدا هەموو نێرینەکانتان لەبەردەم یەزدانی باڵادەست ئامادە دەبن. ");
INSERT INTO ckb_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","«خوێنی قوربانیم لەگەڵ شتی بە هەویرترش پێشکەش مەکەن. «پیوی قوربانی جەژنم هەتا بەیانی نەمێنێتەوە. ");
INSERT INTO ckb_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","«باشترینی یەکەمین بەرهەمی زەوییەکەتان بۆ ماڵی یەزدانی پەروەردگارتان بهێنن. «هیچ کاریلەیەک بە شیری دایکی لێمەنێن. ");
INSERT INTO ckb_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","«ببینن، من فریشتەیەک لەپێشتانەوە دەنێرم بۆ ئەوەی لە ڕێگا بتانپارێزێت و بتانهێنێتە ئەو شوێنەی ئامادەم کردووە. ");
INSERT INTO ckb_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","لێی ئاگاداربن و گوێ لە فەرمایشتی بگرن و تووڕەی مەکەن، چونکە لە یاخیبوونتان نابوورێت، لەبەر ئەوەی ناوی منی تێدایە. ");
INSERT INTO ckb_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","بەڵام ئەگەر گوێتان لە فەرمایشتی گرت و هەموو ئەوانەی دەیڵێم جێبەجێی بکەن، ئەوا دژایەتی دوژمنەکانتان دەکەم و تەنگ هەڵدەچنم بە تەنگ پێهەڵچنانتان. ");
INSERT INTO ckb_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","فریشتەکەم لەپێشتانەوە دەڕوات و دەتانباتە خاکی ئەمۆری و حیتی و پریزی و کەنعانی و حیڤی و یەبوسییەکان، ئەوان لەناودەبەم. ");
INSERT INTO ckb_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","کڕنۆش بۆ خوداوەندەکانیان مەبەن و مەیانپەرستن و وەک نەریتەکانی ئەوان مەکەن، بەڵکو بە تەواوی وردوخاشیان بکەن و بەردە تەرخانکراوەکانیان بە تەواوی بشکێنن. ");
INSERT INTO ckb_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","یەزدانی پەروەردگارتان دەپەرستن، ئەویش نان و ئاوتان بەرەکەتدار دەکات. دەرد لەنێوتان ناهێڵم. ");
INSERT INTO ckb_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","لەبارچوو و نەزۆک لە خاکەکەتان نابێت، هەروەها تەمەنتان درێژ دەکەم. ");
INSERT INTO ckb_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","«سامناکی خۆم لەپێشتانەوە دەنێرم و هەموو ئەو نەتەوانەی دەچنە سەریان، سەریان لێ دەشێوێنم و وا دەکەم هەموو دوژمنەکانتان هەڵبێن. ");
INSERT INTO ckb_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","زەردەواڵەش لەپێشتانەوە دەنێرم و حیڤی و کەنعانی و حیتییەکان لەپێشتان ڕابماڵن. ");
INSERT INTO ckb_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","بەڵام لە ماوەی یەک ساڵ لەپێشتان ڕایانناماڵم، نەوەک خاکەکە وێران بێت و ئاژەڵی کێوی لەسەرتان زیاد بکات. ");
INSERT INTO ckb_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","هێواش هێواش لەپێشتان ڕایاندەماڵم، هەتا ئەوەی بەردار دەبن و دەست بەسەر خاکەکەدا دەگرن. ");
INSERT INTO ckb_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","«سنوورەکەشتان دادەنێم، لە دەریای سوورەوە هەتا دەریای سپی ناوەڕاست و لە چۆڵەوانییەوە هەتا ڕووباری فورات، چونکە دانیشتووانی خاکەکە دەدەمە دەستتان و ئێوەش لەپێش خۆتان ڕایاندەماڵن. ");
INSERT INTO ckb_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","نە لەگەڵ ئەوان نە لەگەڵ خوداوەندەکانیان پەیمان مەبەستن. ");
INSERT INTO ckb_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","با لە خاکەکەتاندا نیشتەجێ نەبن، نەوەک واتان لێ بکەن گوناه سەبارەت بە من بکەن، چونکە ئەگەر خوداوەندی ئەوان بپەرستن ئەوا دەبێتە تەڵە بۆتان.» ");
INSERT INTO ckb_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","ئینجا بە موسای فەرموو: «سەربکەوە بۆ لای یەزدان، خۆت و هارون و ناداب و ئەبیهو و حەفتا لە پیرانی ئیسرائیل، لە دوورەوە کڕنۆشی بۆ ببەن. ");
INSERT INTO ckb_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","بەڵام تەنها موسا لە یەزدان نزیک دەبێتەوە و ئەوانی دیکە نزیک ناکەونەوە، خەڵکەکەش لەگەڵی سەر ناکەون.» ");
INSERT INTO ckb_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","موساش هات و هەموو وشەکانی یەزدان و هەموو یاساکانی بۆ خەڵکەکە گێڕایەوە، هەموو گەلیش بە یەک دەنگ وەڵامیان دایەوە و گوتیان: «هەموو ئەو وشانەی یەزدان فەرموویەتی دەیکەین.» ");
INSERT INTO ckb_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","موساش هەموو وشەکانی یەزدانی نووسی. بەیانی زوو هەستا و قوربانگایەکی لەبن کێوەکە بنیاد نا لەگەڵ دوازدە ستوون بۆ دوازدە هۆزەکەی ئیسرائیل. ");
INSERT INTO ckb_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","لاوانی نەوەی ئیسرائیلیشی نارد و قوربانی سووتاندن و قوربانی هاوبەشییان لە جوانەگاکان بۆ یەزدان پێشکەش کرد. ");
INSERT INTO ckb_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","موسا نیوەی خوێنەکەی لەناو جامێک کرد و نیوەکەی دیکەشی بەسەر قوربانگاکەدا پرژاند. ");
INSERT INTO ckb_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","ئینجا پەڕتووکی پەیمانەکەی هەڵگرت و بۆ گەلی خوێندەوە، ئەوانیش گوتیان: «هەموو ئەوەی یەزدان فەرموویەتی دەیکەین و گوێی لێ دەگرین.» ");
INSERT INTO ckb_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","ئینجا موسا خوێنەکەی هەڵگرت و بەسەر گەلدا پرژاندی و گوتی: «ئەمە خوێنی ئەو پەیمانەیە کە یەزدان لەگەڵتانی بەستووە بەگوێرەی ئەم وشانە.» ");
INSERT INTO ckb_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","دواتر موسا و هارون و ناداب و ئەبیهو و حەفتا لە پیرانی ئیسرائیل سەرکەوتن و ");
INSERT INTO ckb_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","خودای ئیسرائیلیان بینی، لەژێر پێیەکانی شتێکی وەک بەردڕێژکراویان بینی بە بەردی یاقووتی شین و وەک ئاسمانی ساماڵ لە بێگەردی. ");
INSERT INTO ckb_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","بەڵام دەستی بۆ پیاوماقوڵانی نەوەی ئیسرائیل درێژ نەکرد. خودایان بینی، ئینجا خواردیان و خواردیانەوە. ");
INSERT INTO ckb_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","یەزدان بە موسای فەرموو: «سەربکەوە بۆ لام بۆ کێوەکە و لەوێ بە، دوو تەختە بەردت دەدەمێ، ڕاسپاردەکانی تەورات و فەرمانەکانی تێدایە کە بۆ فێرکردنیان نووسیومە.» ");
INSERT INTO ckb_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","ئینجا موسا و یەشوعی یاریدەدەری هەستان، موسا بۆ کێوی خودا سەرکەوت. ");
INSERT INTO ckb_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","بە پیرانیشی گوت: «لێرە چاوەڕێمان بکەن هەتا دەگەڕێینەوە لاتان، ئەوەتا هارون و حووریش لەگەڵتانن، ئەگەر یەکێک داواکاری یاخود ناکۆکی هەبوو با بچێتە لایان.» ");
INSERT INTO ckb_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","ئیتر موسا بەسەر کێوەکە کەوت و هەور کێوەکەی داپۆشی. ");
INSERT INTO ckb_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","شکۆمەندی یەزدانیش لەسەر شاخی سینا نیشتەوە. بۆ ماوەی شەش ڕۆژ هەور کێوەکەی داپۆشی، لە ڕۆژی حەوتەم لەنێو هەورەوە موسای بانگکرد. ");
INSERT INTO ckb_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","دیمەنی شکۆمەندی یەزدانیش وەک ئاگرێکی بێ ئامان بوو لەسەر کێو، لەبەرچاوی نەوەی ئیسرائیل. ");
INSERT INTO ckb_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","ئینجا موسا هاتە ناو هەورەکەوە و بۆ سەر کێوەکە سەرکەوت. موسا چل شەو و چل ڕۆژی پێچوو لە کێوەکە. ");
INSERT INTO ckb_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","«بە نەوەی ئیسرائیل بڵێ با بەخشینم پێشکەش بکەن، هەر یەکێک کە لەسەر دڵی بێت ببەخشێت. ");
INSERT INTO ckb_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","«ئەمانەش ئەو پێشکەشکراوانەن کە لێیان وەردەگرن: «زێڕ و زیو و بڕۆنز؛ ");
INSERT INTO ckb_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","ڕیسی جوان و باریک بە ڕەنگی مۆر و ئەرخەوانی و سووری ئاڵ، کەتانی ناسک و مووی بزن؛ ");
INSERT INTO ckb_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","پێستی بەران کە بە ڕەنگی سوور ڕەنگکرابوو و پێستی مانگای دەریا و داری ئەکاسیا؛ ");
INSERT INTO ckb_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","زەیتی زەیتوون بۆ چرا؛ بۆنوبەرام بۆ زەیتی دەستنیشانکردن و بۆ بخووری بۆنخۆش؛ ");
INSERT INTO ckb_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","بەردی عاشقبەند و بەردی گرانبەهای دیکە بۆ ئێفۆد و بۆ بەرسینە. ");
INSERT INTO ckb_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","«پیرۆزگایەکیشم بۆ دروستدەکەن بۆ ئەوەی لەنێویاندا نیشتەجێ بم، ");
INSERT INTO ckb_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","وەک هەموو ئەوەی پیشانت دەدەم لە نموونەی چادری پەرستن و نموونەی هەموو کەلوپەلەکانی، بەم شێوە دروستی بکەن. ");
INSERT INTO ckb_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","«سندوقێکیش لە داری ئەکاسیا دروستبکرێت، درێژییەکەی دوو باڵ و نیو و پانییەکەی باڵ و نیوێک و بەرزییەکەی باڵ و نیوێک بێت، ");
INSERT INTO ckb_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","ڕووی ناوەوە و دەرەوەی بە تەواوی بە زێڕی بێگەرد ڕووکەش بکرێت و بە چواردەوریشیدا چوارچێوەی زێڕینی بۆ دروستبکرێت. ");
INSERT INTO ckb_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","چوار بازنەی زێڕینیشی بۆ دابڕێژرێت و لەسەر چوار پایەکەی دابنرێت، دوو بازنە لەلایەک و دوو بازنەش لەلایەکەی دیکەی. ");
INSERT INTO ckb_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","دوو داریش لە داری ئەکاسیا دروستبکرێت و بە زێڕ ڕووکەش بکرێن. ");
INSERT INTO ckb_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","دارەکانیش بخرێتە ناو بازنەکانی سەر هەردوو لای سندوقەکە، بۆ هەڵگرتنی سندوقەکە پێیان. ");
INSERT INTO ckb_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","دارەکان لەناو بازنەکانی سندوقەکە دەبن، لێیان دەرناهێنرێن. ");
INSERT INTO ckb_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","لەناو سندوقەکەش ئەو دوو تەختەی پەیمان دادەنێیت کە پێت دەدەم. ");
INSERT INTO ckb_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","«قەپاغی کەفارەتیش لە زێڕی بێگەرد دروستبکرێت کە دوو باڵ و نیو درێژییەکەی و باڵ و نیوێک پانییەکەی بێت. ");
INSERT INTO ckb_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","دوو کەڕوب لە زێڕی کوتراو دروستبکرێت، بە هەردوو لای قەپاغی کەفارەتەکەوە بکرێت. ");
INSERT INTO ckb_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","کەڕوبێک لەلایەک دروستبکرێت و کەڕوبەکەی دیکەش لەلایەکەی دیکە، هەردوو کەڕوبەکان لەگەڵ قەپاغەکەی کەفارەت یەک پارچە بن. ");
INSERT INTO ckb_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","دەبێت کەڕوبەکانیش باڵیان بۆ سەرەوە لێک کردبێتەوە و بە باڵەکانیان سێبەریان بەسەر قەپاغی کەفارەتەکە کردبێت. کەڕوبەکان ڕووبەڕوو بن و ڕوویان لە قەپاغی کەفارەتەکە بێت. ");
INSERT INTO ckb_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","قەپاغی کەفارەتەکە لەسەر سندوقەکە و لەلای سەرەوە دابنرێت، لەناو سندوقەکەش ئەو دوو تەختەی پەیمان دادەنێیت کە من پێت دەدەم. ");
INSERT INTO ckb_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","لەوێ لەگەڵت کۆدەبمەوە و لەگەڵت دەدوێم، لەسەر قەپاغی کەفارەتەکە لەنێوان دوو کەڕوبەکەی سەر سندوقی پەیمان، سەبارەت بە هەموو ئەو شتانەی فەرمانت پێدەدەم بۆ نەوەی ئیسرائیل. ");
INSERT INTO ckb_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","«هەروەها مێزێک لە داری ئەکاسیا دروستبکرێت، کە درێژییەکەی دوو باڵ و پانییەکەی باڵێک و بەرزییەکەی باڵ و نیوێک بێت. ");
INSERT INTO ckb_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","بە زێڕی بێگەردیش ڕووکەش بکرێت و چوارچێوەیەکی زێڕینیشی لە چواردەوری بۆ دروستبکرێت. ");
INSERT INTO ckb_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","لێوارێکیشی بە پانی چوار پەنجە لە چواردەوری دروستبکرێت و چوارچێوەیەکی زێڕینیش بۆ لێوارەکە لە دەوری دابنرێت. ");
INSERT INTO ckb_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","چوار بازنەی زێڕینیشی بۆ دروستبکرێت، بازنەکان لەسەر هەر چوار گۆشەکەی چوار پایەکەی دابنرێت. ");
INSERT INTO ckb_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","بازنەکان لەلای لێوارەکەوە دەبن بە گیرە بۆ دوو دار بۆ هەڵگرتنی مێزەکە. ");
INSERT INTO ckb_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","دوو دارەکەش لە داری ئەکاسیا دروستبکرێن، بە زێڕ ڕووکەش بکرێن، بەوان مێزەکە هەڵدەگرێت. ");
INSERT INTO ckb_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","لەگەن و قاپەکانی لە زێڕی بێگەرد دروستبکرێت، هەروەها دۆلکە و تاسەکانیش کە پێشکەشکراوەکانی پێ دەڕژێنرێت. ");
INSERT INTO ckb_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","لەسەر مێزەکەش نانی تەرخانکراو بەردەوام لەپێشم دادەنرێت. ");
INSERT INTO ckb_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","«هەروەها چرادانێک لە زێڕی بێگەرد دروستبکرێت، ژێر چرادانەکە و قەدەکەی لە زێڕی کوتراو دروستبکرێت، کاسەکانی و گرێیەکانی و خونچەکانی لە خۆی دەبێت. ");
INSERT INTO ckb_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","شەش لقیش لە هەردوو لایەوە دەردەچێت، سێ لق چرادان لەلایەک و سێ لق چرادان لەلایەکەی دیکە. ");
INSERT INTO ckb_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","سێ کاسەی بادەمی لە لقێک بە گرێ و خونچەوە و سێ کاسەی بادەمی لە لقێکی دیکە بە گرێ و خونچەوە، ئاوا هەتا لقی شەشەم کە لە چرادانەکەوە دەردەچن. ");
INSERT INTO ckb_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","هەروەها لە چرادانەکە چوار کاسەی بادەمی بە گرێ و خونچەکانیانەوە هەیە. ");
INSERT INTO ckb_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","هەر جووتێک لق لە شەش لقەکە گرێیەکیان لەژێر بوو، هەتا شەشەم لق کە لە چرادانەکە دەردەچن. ");
INSERT INTO ckb_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","گرێ و لقەکان لە خۆی دەبن، هەمووشیان لە زێڕی بێگەردی کوتراو دەبێت. ");
INSERT INTO ckb_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","«حەوت چراشی بۆ دروستبکرێت و چراکانی بەرز دەکەیتەوە هەتا پێشی ڕووناک بکاتەوە. ");
INSERT INTO ckb_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","مەقاش و مەقەڵییەکانیشی لە زێڕی بێگەرد دەبن. ");
INSERT INTO ckb_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","چرادانەکە و هەموو کەلوپەلەکانی لە تالنتێک زێڕی بێگەرد دروستبکرێت. ");
INSERT INTO ckb_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","بڕوانە ئەو شتانە لەسەر ئەو نموونەیە دروستبکەی کە لەسەر کێوەکە پیشانت دراوە. ");
INSERT INTO ckb_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","«چادری پەرستنیش لە پڵاسی کەتانی ڕستراو دروستبکە، هەروەها بە ڕیسی مۆر و ئەرخەوانی و سووری ئاڵ و بە دەستکردی جۆڵایەکی شارەزا وێنەی کەڕوبەکانی لەسەر بکە. ");
INSERT INTO ckb_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","درێژایی هەر پڵاسێک بیست و هەشت باڵ و پانییەکەی چوار باڵ بێت، یەک ئەندازەش بۆ هەموو پڵاسەکان. ");
INSERT INTO ckb_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","پێنج پڵاس پێکەوە ببەستە و پێنجەکەی دیکەش پێکەوە. ");
INSERT INTO ckb_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","ئەڵقە لە ڕیسی مۆر لەسەر لێواری پڵاسە لاوەکییەکانی پارچەی یەکەم دروستبکە، هەمان شت بۆ لێواری پڵاسە لاوەکییەکانی پارچەی دووەم بکە. ");
INSERT INTO ckb_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","پەنجا ئەڵقە بۆ پڵاسی یەکەم دروستدەکەیت و پەنجا ئەڵقەی دیکەش بۆ لای ئەو پڵاسەی کە لە پارچەکەی دووەمە، ئەڵقەکانیش بەرامبەر یەکتری بن. ");
INSERT INTO ckb_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","پەنجا فاقی زێڕیش دروستبکە. بە فاقەکان پڵاسەکان هەریەکە و لەوەی تەنیشتی ببەستەوە. ئیتر چادری پەرستن دەبێتە یەک پارچە. ");
INSERT INTO ckb_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","«ڕەشماڵێک لە یازدە پڵاس لە مووی بزن دروستبکە و سەری چادری پەرستنی پێ بگرە، ");
INSERT INTO ckb_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","درێژایی هەر پڵاسێک سی باڵ و پانی چوار باڵ بێت، یەک ئەندازەش بۆ هەر یازدە پڵاسەکە. ");
INSERT INTO ckb_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","پێنج لە پڵاسەکان پێکەوە ببەستەوە و شەشەکەی دیکەش پێکەوە، پڵاسی شەشەمیش بەڕووی چادرەکەدا بنووشتێنەوە. ");
INSERT INTO ckb_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","پەنجا ئەڵقە لەسەر لێواری پڵاسی کۆتایی پارچەی یەکەم دروستبکە، پەنجا ئەڵقەش لەسەر لێواری پڵاسی کۆتایی پارچەی دووەم. ");
INSERT INTO ckb_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","پەنجا فاقی بڕۆنزیش دروستبکە و فاقەکان بخە ناو ئەڵقەکان، چادرەکە پێکەوە ببەستەوە و دەبێتە یەک پارچە. ");
INSERT INTO ckb_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","ئەوەش کە شۆڕدەبێتەوە و لە پڵاسەکانی چادرەکە دەمێنێتەوە، نیوەی ئەو پڵاسەی دەمێنێتەوە بەسەر کۆتایی چادرەکەی پەرستندا شۆڕی بکەوە. ");
INSERT INTO ckb_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","باڵێک لەم لا، باڵێک لەو لا لەوەی دەمێنێتەوە لە درێژایی پڵاسی چادرەکە شۆڕ بکرێنەوە بەسەر دوو لای چادرەکەی پەرستندا، لەم لاو لەو لاوە بۆ داپۆشینی. ");
INSERT INTO ckb_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","پۆشەرێکیش لە پێستی بەرانی ڕەنگکراو بە ڕەنگی سوور بۆ چادرەکە دروستبکە، پۆشەرێکیش لە پێستی مانگای دەریا لە سەرەوە. ");
INSERT INTO ckb_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","«چوارچێوەش لە داری ئەکاسیا بە ستوونی بۆ چادرەکەی پەرستن دروستبکە. ");
INSERT INTO ckb_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","درێژایی هەر چوارچێوەیەک دە باڵ و پانی باڵ و نیوێک بێت. ");
INSERT INTO ckb_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","دوو زمانەش بۆ هەر چوارچێوەیەک دروستبکە بۆ جووتکردنی لەگەڵ چوارچێوەکەی تەنیشتی، بۆ هەریەک لە چوارچێوەکانی چادرەکەی پەرستن ئاوا بکە. ");
INSERT INTO ckb_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","چوارچێوەکانی چادرەکەی پەرستنیش، بیستیان لەلای باشوور دروستبکە، ");
INSERT INTO ckb_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","چل بنکەی زیویش لەژێر بیست چوارچێوەکە دروستبکە، دوو بنکە لەژێر هەر چوارچێوەیەک بۆ دوو پێچکەکەی. ");
INSERT INTO ckb_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","بیست چوارچێوە بۆ لای باکووری چادرەکەی پەرستن دروستبکە. ");
INSERT INTO ckb_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","چل بنکەی زیویشی هەبێت، دوو بنکە لەژێر چوارچێوەیەک و دوو بنکە لەژێر چوارچێوەیەکی دیکە. ");
INSERT INTO ckb_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","بۆ پشتی چادرەکەی پەرستنیش بەرەو ڕۆژئاوا شەش چوارچێوە، ");
INSERT INTO ckb_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","دوو چوارچێوەش بۆ گۆشەکانی دواوەی چادرەکەی پەرستن دروستبکە. ");
INSERT INTO ckb_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","دەبێت لە خوارەوە جووت بن و هەتا سەرەوە یەک بن، هەتا بازنەکەی سەرەوە، بۆ هەردوو گۆشەکە ئاوا بن. ");
INSERT INTO ckb_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","ئینجا دەبێتە هەشت چوارچێوە و بنکە زیوەکانیشیان شازدە دەبێت، هەردوو بنکە لەژێر چوارچێوەیەک و دوو بنکەی دیکەش لەژێر چوارچێوەیەکی دیکە. ");
INSERT INTO ckb_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","«هەروەها پێنج کاریتە لە داری ئەکاسیا بۆ چوارچێوەکانی لایەکی چادرەکەی پەرستن دروستبکە، ");
INSERT INTO ckb_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","پێنج کاریتەش بۆ چوارچێوەکانی لایەکەی دیکەی چادرەکەی پەرستن، پێنج کاریتەش بۆ چوارچێوەکانی لای دواوەی چادرەکەی پەرستن لەلای ڕۆژئاوا. ");
INSERT INTO ckb_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","کاریتەکەی ناوەڕاستیش بەنێو چوارچێوەکاندا تێبپەڕێت لەم سەرەوە بۆ ئەو سەر. ");
INSERT INTO ckb_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","چوارچێوەکانیش بە زێڕ ڕووکەش بکە و بازنەکانیشی کە کاریتەکانی دەچنە ناو لە زێڕ دروستبکە، کاریتەکانیش بە زێڕ ڕووکەش بکە. ");
INSERT INTO ckb_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","«چادرەکەی پەرستنیش لەسەر ئەو نەخشەیە هەڵبدە کە لە کێوەکە پیشانت دراوە. ");
INSERT INTO ckb_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","«پەردەیەکیش لە ڕیسی مۆر و ئەرخەوانی و سووری ئاڵ و کەتانی ڕستراو دروستبکە، بە دەستکردی جۆڵایەکی شارەزاش وێنەی کەڕوبەکانی لەسەر دروستبکە. ");
INSERT INTO ckb_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","بیخە سەر چوار کۆڵەکەی لە داری ئەکاسیا دروستکراو و بە زێڕ ڕووکەشکراو، قولاپەکانیشیان لە زێڕ بێت، لەسەر چوار بنکەی زیو بن. ");
INSERT INTO ckb_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","چەند فاقێکیش بەلای سەرەوەی پەردەکەوە بکە و سندوقی پەیمانیش بهێنە ئەوێ بۆ دیوی ژوورەوەی پەردەکە. پەردەکە شوێنی پیرۆز و شوێنی هەرەپیرۆز لە یەکتری جیا دەکاتەوە بۆتان. ");
INSERT INTO ckb_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","قەپاغی کەفارەتیش لەسەر سندوقی پەیمان لە شوێنی هەرەپیرۆز دابنێ. ");
INSERT INTO ckb_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","مێزەکەش لە دەرەوەی پەردەکە دابنێ و چرادانەکەش بەرامبەر مێزەکە لەلایەکی چادرەکەی پەرستن لەلای باشوور دابنێ و مێزەکەش لەلای باکوور. ");
INSERT INTO ckb_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","«پەردەی دەروازەش بۆ دەرگای چادرەکە لە ڕیسی مۆر و ئەرخەوانی و سووری ئاڵ و کەتانی ڕستراو دروستبکە، چنراو بە دەستکردی جۆڵایەک. ");
INSERT INTO ckb_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","بۆ پەردەی دەروازەکەش پێنج ستوونی لە داری ئەکاسیا و بە زێڕ ڕووکەشکراو دروستبکە، قولاپەکانیشیان لە زێڕ بن و پێنج بنکەی بڕۆنزیشیان بۆ دابڕێژە. ");
INSERT INTO ckb_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","«قوربانگاش لە داری ئەکاسیا دروستبکە، درێژییەکەی پێنج باڵ و پانییەکەی پێنج باڵ بێت، قوربانگاکە چوارگۆشە بێت، بەرزاییەکەشی سێ باڵ بێت. ");
INSERT INTO ckb_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","قۆچەکانیشی لەسەر هەر چوار گۆشەکەی بێت، قۆچەکان لە خۆی بێت و بە بڕۆنز ڕووکەشی بکە. ");
INSERT INTO ckb_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","تەشتەکانی کە بۆ هەڵگرتنی خۆڵەمێشەکەی و هەروەها خاکەناز، تاس، چەنگاڵ، مەقەڵی و هەموو قاپوقاچاغەکەی لە بڕۆنز دروستبکە. ");
INSERT INTO ckb_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","کەتیبەیەکی وەک تۆڕیشی بۆ دروستبکە لە بڕۆنز، لەسەر تۆڕەکەش چوار ئەڵقەی بڕۆنز لەسەر هەر چوار لایەکەی دروستبکە. ");
INSERT INTO ckb_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","بیخە ژێر لێواری قوربانگاکە و تۆڕەکەش هەتا ناوەڕاستی قوربانگاکە بێت. ");
INSERT INTO ckb_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","دوو داریش بۆ قوربانگاکە لە داری ئەکاسیا دروستبکە و بە بڕۆنز ڕووکەشیان بکە. ");
INSERT INTO ckb_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","دوو دارەکەش بخەرە ناو ئەڵقەکانەوە، ئیتر دارەکان بە هەردوو لای قوربانگاکەوە دەبن لە کاتی هەڵگرتنی. ");
INSERT INTO ckb_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","قوربانگاکەش لە تەختە دروستبکە و ناوەکەی بۆش بێت. هەروەک لە کێوەکە پیشانت درا ئاوای دروستبکە. ");
INSERT INTO ckb_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","«حەوشەی چادرەکەی پەرستنیش لەلای باشوور دروستبکە، بۆ حەوشەکە چەند پەردەیەک دەبێت لە کەتانی ڕستراو بە درێژی سەد باڵ بۆ یەک لا، ");
INSERT INTO ckb_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","کۆڵەکەکانیشی بیست دانە و بیست بنکەی بڕۆنزیشی هەبێت. قولاپی کۆڵەکەکان و ئەڵقەکانیشی لە زیو بن. ");
INSERT INTO ckb_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","ئاواش بۆ لای باکوور لە درێژیدا پەردەکان سەد باڵ درێژ بن، کۆڵەکەکانیشی بیست دانە بن و بیست بنکەی بڕۆنزیشی هەبێت. قولاپی کۆڵەکەکان و ئەڵقەکانیشی لە زیو بن. ");
INSERT INTO ckb_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","«لە پانی حەوشەکەش بەرەو ڕۆژئاوا چەند پەردەیەک بە درێژایی پەنجا باڵ و کۆڵەکەکانی دە دانە و بنکەکانیشی دە. ");
INSERT INTO ckb_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","لە پانی حەوشەکەش لەلای ڕۆژهەڵات و ڕووەو خۆر هەڵاتن پەنجا باڵ. ");
INSERT INTO ckb_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","چەند پەردەیەکیش بۆ لایەکی بە درێژی پازدە باڵ، کۆڵەکەکانی سێ و بنکەکانیشی سێ بن. ");
INSERT INTO ckb_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","بۆ لایەکەی دیکەش چەند پەردەیەک بە درێژایی پازدە باڵ، کۆڵەکەکانی سێ و بنکەکانیشی سێ بن. ");
INSERT INTO ckb_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","«بۆ دەروازەی حەوشەکەش پەردەیەک کە بیست باڵ درێژ و لە ڕیسی مۆر و ئەرخەوانی و سووری ئاڵ و کەتانی ڕستراو، چنراو بە دەستکردی جۆڵایەک و کۆڵەکەکانی چوار و بنکەکانیشی چوار بن. ");
INSERT INTO ckb_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","هەموو کۆڵەکەکانی حەوشەکەش ئەڵقەی زیویان هەبێت بە دەوریان و قولاپەکانی لە زیو و بنکەکانی لە بڕۆنز بن. ");
INSERT INTO ckb_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","درێژایی حەوشەکە سەد باڵ بێت و پانییەکەی پەنجا بە پەنجایە و بەرزاییەکەشی پێنج باڵ و لە کەتانی ڕستراو و بنکەکانیشی لە بڕۆنز بن. ");
INSERT INTO ckb_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","هەموو ئەو قاپوقاچاغانەی دیکە کە لە خزمەتی چادرەکەی پەرستن بەکاردەهێنرێن، بە هەر شێوەیەک بەکاردێت، لەگەڵ هەموو سنگەکانی چادرەکەی پەرستن و حەوشەکە، دەبێت لە بڕۆنز دروستکرابن. ");
INSERT INTO ckb_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","«تۆش فەرمان بە نەوەی ئیسرائیل بکە با زەیتی زەیتوونی سادە و گوشراوت بۆ ڕووناکی بۆ بهێنن، هەتا چرا بەردەوام داگیرساو بێت. ");
INSERT INTO ckb_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","لەناو چادری چاوپێکەوتن لە دەرەوەی پەردەکە ئەوەی لەبەردەم سندوقی پەیمانە، هارون و کوڕەکانی لە ئێوارەوە هەتا بەیانی لەبەردەم یەزدان ڕێکی بخەن، فەرزێکی هەتاهەتاییە بۆ نەوەکانیان لەنێو نەوەی ئیسرائیل. ");
INSERT INTO ckb_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","«تۆش لەنێو نەوەی ئیسرائیل هارونی برات لە خۆت نزیک بکەوە، لەگەڵ ناداب و ئەبیهو و ئەلعازار و ئیتامار، کوڕانی هارون، بۆ ئەوەی کاهینیێتیم بۆ بکەن. ");
INSERT INTO ckb_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","جلوبەرگی پیرۆزیش بۆ هارونی برات دروستبکە بۆ شکۆمەندی و ڕێزگرتن. ");
INSERT INTO ckb_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","تۆش لەگەڵ بەهرەمەندەکان قسە بکە، ئەوانەی پڕمکردوون لە ڕۆحی دانایی، بۆ ئەوەی جلوبەرگەکەی هارون دروستبکەن بۆ تەرخانکردنی هەتا کاهینیێتیم بۆ بکات. ");
INSERT INTO ckb_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","ئەمانەش ئەو جلوبەرگەن کە دروستی دەکەن، بەرسینە و ئێفۆد و کەوا و کراسی دامێن درێژی چنراو و مێزەر و کەمەربەند. ئینجا جلوبەرگی پیرۆز بۆ هارونی برات و کوڕەکانی دروستبکەن، هەتا کاهینیێتیم بۆ بکەن. ");
INSERT INTO ckb_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","ئەوانیش زێڕ و ڕیسی مۆر و ئەرخەوانی و سووری ئاڵ و کەتانی ناسک وەردەگرن. ");
INSERT INTO ckb_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","«ئێفۆدەکەش لە زێڕ و ڕیسی مۆر و ئەرخەوانی و سووری ئاڵ و کەتانی ڕستراو بە جۆڵایەکی شارەزا دروستبکەن. ");
INSERT INTO ckb_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","دوو شانیشی هەبێت بە هەردوو لایەوە پێوەی بەسترابن. ");
INSERT INTO ckb_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","پشتبەستی ئێفۆدەکە کە لەسەریەتی، دەبێت لە هەمان پارچە و هەمان دەستکرد بێت، لە زێڕ و ڕیسی مۆر و ئەرخەوانی و سووری ئاڵ و کەتانی ڕستراو بێت. ");
INSERT INTO ckb_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","«دوو بەردی عاشقبەندیش بهێنە و ناوی کوڕەکانی ئیسرائیلیان لەسەر هەڵبکەنە. ");
INSERT INTO ckb_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","ناوی شەشیان لەسەر بەردێک و ناوی شەشەکەی ماوەتەوە لەسەر بەردی دووەم هەڵبکەنە بەگوێرەی لەدایکبوونیان. ");
INSERT INTO ckb_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","ناوی کوڕەکانی ئیسرائیل لەسەر هەردوو بەردەکە هەڵبکەنە، وەک چۆن نەقاڕێک مۆر هەڵدەکەنێت. ئینجا بە چوارچێوەی زێڕینی دەوردراو بیانچەسپێنە. ");
INSERT INTO ckb_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","دوو بەردەکەش بخەرە سەر دوو شانی ئێفۆدەکە، دوو بەردی یادگاری بۆ نەوەی ئیسرائیل. هارون لەبەردەم یەزدان وەک یادەوەری ناوەکانیان لەسەر هەردوو شانی هەڵدەگرێت. ");
INSERT INTO ckb_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","چوارچێوەی زێڕینیش دروستبکە و ");
INSERT INTO ckb_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","دوو زنجیری هۆنراوە لە زێڕی بێگەرد، وەک گوریس، لەسەر چوارچێوەکان دابنێ. ");
INSERT INTO ckb_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","«هەروەها بەرسینەی دادوەری دروستبکە، وەک ئێفۆدەکە بە دەستکردی جۆڵایەکی شارەزا، لە زێڕ و ڕیسی مۆر و ئەرخەوانی و سووری ئاڵ و کەتانی ڕستراو. ");
INSERT INTO ckb_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","بەرسینەکەش چوارگۆشە و دووبەر بێت، درێژییەکەی بستێک و پانییەکەی بستێک. ");
INSERT INTO ckb_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","بە چوار ڕیز بەرد بیڕازێنەوە، لە ڕیزی یەکەم یاقووت لەگەڵ یاقووتی زەرد و زمروودی سەوز؛ ");
INSERT INTO ckb_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","ڕیزی دووەم بەردە پیرۆزە و یاقووتی شین و زمروود؛ ");
INSERT INTO ckb_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","ڕیزی سێیەم یاقووتی زەعفەرانی و کریستاڵی هەورین و جەمشت؛ ");
INSERT INTO ckb_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","ڕیزی چوارەمیش زەبەرجەد و بەردی عاشقبەند و یەشب. لە ڕازانەوەیاندا بە زێڕ دەور بدرێن. ");
INSERT INTO ckb_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","بەردەکانیش دوازدە بن وەک ناوی کوڕەکانی ئیسرائیل بەپێی ناوەکانیان، وەک نەخشی ئەنگوستیلە هەریەکە بەپێی ناوەکەی بۆی دەبێت بۆ دوازدە هۆز. ");
INSERT INTO ckb_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","«بۆ بەرسینەکەش زنجیرەی هۆنراوە لە زێڕی بێگەرد دروستبکە، وەک گوریس. ");
INSERT INTO ckb_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","لەسەر بەرسینەکەش دوو ئەڵقەی زێڕین دروستبکە، دوو ئەڵقەکە لەسەر هەردوو لای بەرسینەکە دابنێ. ");
INSERT INTO ckb_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","دوو زنجیرە زێڕینەکەش بخە ناو دوو ئەڵقەکەی سەر هەردوو لای بەرسینەکە. ");
INSERT INTO ckb_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","هەردوو سەرەکەی دیکەی دوو زنجیرەکەش بخە ناو دوو چوارچێوەکە و لەسەر شانەکانی ئێفۆدەکەی دابنێ بۆ پێشەوەی. ");
INSERT INTO ckb_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","دوو ئەڵقەی زێڕینیش دروستبکە و لەسەر هەردوو لای بەرسینەکە دایانبنێ، لەسەر لێوارەکەی کە بە دیوی ئێفۆدەکەیە بۆ ژوورەوە. ");
INSERT INTO ckb_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","هەروەها دوو ئەڵقەی زێڕین دروستبکە و لەسەر هەردوو شانی ئێفۆدەکە دایانبنێ، لە خوارەوە بە دیوی ڕووەکەی، لە نزیک بەیەکبەستنەوەکەی لە سەرووی پشتبەستی ئێفۆدەکە. ");
INSERT INTO ckb_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","بەرسینەکەش بە دوو ئەڵقەکەیەوە لە دوو ئەڵقەی ئێفۆدەکە بە داوێک دەبەسترێت لە ڕیسی مۆر، بۆ ئەوەی لەسەر پشتبەستی ئێفۆدەکە بێت، تاوەکو بەرسینەکەش لە ئێفۆدەکە نەکرێتەوە. ");
INSERT INTO ckb_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","«ئیتر هارون ناوی نەوەکانی ئیسرائیل لە بەرسینەکەی دادوەری لەسەر دڵی خۆی هەڵدەگرێت کاتێک دێتە ژوورەوە بۆ شوێنە پیرۆزەکە وەک یادکردنەوە بە بەردەوامی لەبەردەم یەزدان. ");
INSERT INTO ckb_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","هەروەها لەسەر بەرسینەکەی دادوەری ئوریم و تومیم دابنێ و لەسەر دڵی هارون دەبن کاتێک دێتە ژوورەوە بۆ بەردەم یەزدان، هارونی دادوەری نەوەی ئیسرائیل بە بەردەوامی لەبەردەم یەزدان لەسەر دڵی هەڵیدەگرێت. ");
INSERT INTO ckb_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","«کەوای ئێفۆدەکەش هەمووی لە ڕیسی مۆر دروستبکە. ");
INSERT INTO ckb_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","کونی سەریشی لە ناوەڕاستی دەبێت و لێواریش دەبێت بۆ کونەکەی بەدەوریدا بە دەستکردی جۆڵا، وەک کونی زرێ یەخەی هەبێت بۆ ئەوەی نەدڕێت. ");
INSERT INTO ckb_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","لەسەر دامێنی کەواکە گوڵینگی مۆر و ئەرخەوانی و سووری ئاڵ دروستبکە، لەگەڵ زەنگوڵەی زێڕین لەنێوانیان. ");
INSERT INTO ckb_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","لەنێو هەردوو گوڵینگێک زەنگوڵەیەکی زێڕ لەسەر دامێنی کەواکە بە دەوریدا بێت. ");
INSERT INTO ckb_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","دەبێت هارون بۆ خزمەتکردن لەبەری بکات بۆ ئەوەی کاتێک دەچێتە ژوورەوەی شوێنە پیرۆزەکە بۆ لای یەزدان و کاتێک دێتە دەرەوە دەنگی زەنگوڵەکان ببیسترێت، نەوەک بمرێت. ");
INSERT INTO ckb_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","«پلێتێکیش لە زێڕی بێگەرد دروستبکە و وەک نەخشی ئەنگوستیلە لەسەری هەڵبکەنە، ”پیرۆزی بۆ یەزدان“. ");
INSERT INTO ckb_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","بیخە سەر داوێکی مۆر بۆ ئەوەی لەسەر مێزەرەکە بێت، لەلای پێشەوەی مێزەرەکە بێت. ");
INSERT INTO ckb_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","لەسەر ناوچەوانی هارون بێت، بەم شێوەیە هارون ئۆباڵی هەر گوناهێکی نەوەی ئیسرائیل هەڵدەگرێت کە پەیوەندی هەبێت بەو قوربانییانەی بۆ یەزدانیان تەرخان کردووە، بەردەوامیش لەسەر ناوچەوانی دەبێت بۆ ئەوەی قوربانییەکان لەبەردەم یەزدان پەسەند بن. ");
INSERT INTO ckb_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","«کراسە دامێن درێژە چنراوەکەش لە کەتانی ناسک بێت و مێزەرەکەش لە کەتانی ناسک دروستبکە. کەمەربەندەکەش بە دەستکردی جۆڵایەک بچنە. ");
INSERT INTO ckb_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","بۆ کوڕانی هارونیش کراسی دامێن درێژ دروستبکە، هەروەها کەمەربەند و سەرپێچیان بۆ دروستبکە، بۆ شکۆمەندی و ڕێزگرتن. ");
INSERT INTO ckb_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","دوای ئەوەی ئەو جلوبەرگانەت لەبەر هارونی برات و کوڕەکانی کرد، دەستنیشانیان بکە و ئەرکیان پێ بسپێرە و تەرخانیان بکە بۆ ئەوەی خزمەتی کاهینیێتیم بۆ بکەن. ");
INSERT INTO ckb_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","«هەروەها دەرپێی کەتانیان بۆ دروستبکە بۆ پۆشینی ڕووتییان، لە ناوقەدەوە هەتا هەردوو ڕان بێت. ");
INSERT INTO ckb_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","هارون و کوڕەکانی لەبەری بکەن لە هاتنە ژوورەوەیان بۆ چادری چاوپێکەوتن، یان لە نزیکبوونەوەیان لە قوربانگا بۆ خزمەتکردن لە شوێنی پیرۆز، نەوەک تاوان هەڵبگرن و بمرن. «ئەمە فەرزێکی هەتاهەتاییە بۆ هارون و بۆ نەوەکەی دوای خۆی. ");
INSERT INTO ckb_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","«بۆ تەرخانکردنیان هەتا کاهینیێتیم بۆ بکەن ئەمەیان بۆ بکە: یەک جوانەگا و دوو بەرانی ساغ ببە. ");
INSERT INTO ckb_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","هەروەها لە ئاردی گەنمی باش نانی بێ هەویرترش و کولێرەی بە زەیت شێلراو و ناسکە نانی بە زەیت چەورکراو دروستبکە. ");
INSERT INTO ckb_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","بیانخە ناو سەبەتەیەک و بە سەبەتەکەوە لەگەڵ جوانەگاکە و دوو بەرانەکە پێشکەشیان بکە. ");
INSERT INTO ckb_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","هارون و کوڕەکانیشی بهێنە پێش دەروازەی چادری چاوپێکەوتن و بە ئاو بیانشۆ. ");
INSERT INTO ckb_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","ئینجا جلەکان ببە و لەبەر هارونی بکە، کراسە دامێن درێژەکە، کەوای ئێفۆدەکە، ئێفۆد و بەرسینەکە، ئینجا بە پشتبەستی ئێفۆدەکە بۆی ببەستەوە. ");
INSERT INTO ckb_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","پاشان مێزەرەکە بخە سەری و تاجەگوڵینەی پیرۆزیش بخە سەر مێزەرەکە. ");
INSERT INTO ckb_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","زەیتی دەستنیشانکردن بهێنە و بەسەریدا بکە، بەوە دەستنیشانی بکە. ");
INSERT INTO ckb_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","کوڕەکانیشی بهێنە پێشەوە و کراسی دامێن درێژیان لەبەر بکە و ");
INSERT INTO ckb_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","کەمەربەندیان لە ناوقەد ببەستە. سەرپێچەکان بۆ هارون و کوڕەکانی توند بکە. «کاهینیێتی دەبێتە فەرزێکی هەتاهەتایی بۆیان و ئەرک بە هارون و کوڕەکانی دەسپێریت. ");
INSERT INTO ckb_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","«جوانەگاکە بهێنە پێش چادری چاوپێکەوتن و هارون و کوڕەکانی دەستیان لەسەر سەری جوانەگاکە دابنێن. ");
INSERT INTO ckb_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","تۆش لەلای دەروازەی چادری چاوپێکەوتن جوانەگاکە لەبەردەم یەزدان سەرببڕە. ");
INSERT INTO ckb_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","لە خوێنی جوانەگاکە هەڵبگرە و بە پەنجەت لەسەر قۆچەکانی قوربانگاکەی بدە، هەموو خوێنەکەی دیکەش بڕژێنە بنکەی قوربانگاکە. ");
INSERT INTO ckb_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","هەموو ئەو پیوەش کە هەناوی داپۆشیوە لەگەڵ ئەوەی لەسەر جگەر و گورچیلەکانە و هەردوو گورچیلەکە بهێنە و لەسەر قوربانگاکە بیانسووتێنە، ");
INSERT INTO ckb_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","بەڵام گۆشتی جوانەگاکە و پێستەکەی و ڕیخۆڵەکەی لە دەرەوەی ئۆردوگاکە بە ئاگر بسووتێنە، ئەوە قوربانی گوناهە. ");
INSERT INTO ckb_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","«یەکێکیش لە بەرانەکان بهێنە و هارون و کوڕەکانی دەستیان لەسەر سەری بەرانەکە دابنێن. ");
INSERT INTO ckb_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","بەرانەکە سەرببڕە و خوێنەکەی هەڵبگرە و بەسەر هەموو لایەکی قوربانگاکەدا بیپرژێنە. ");
INSERT INTO ckb_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","بەرانەکەش پارچەپارچە بکە و هەناو و قاچەکانی بشۆ و بیخە سەر پارچەکانی و سەرەکەی. ");
INSERT INTO ckb_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","هەموو بەرانەکە لەسەر قوربانگاکە بسووتێنە، ئەمە قوربانی سووتاندنە بۆ یەزدان، بۆنی خۆشییە، قوربانی بە ئاگرە بۆ یەزدان. ");
INSERT INTO ckb_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","«بەرانەکەی دیکە بهێنە و هارون و کوڕەکانی دەستیان لەسەر سەری بەرانەکە دابنێن. ");
INSERT INTO ckb_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","بەرانەکە سەرببڕە و لە خوێنەکەی ببە و لە شلکەی گوێی ڕاستی هارون و کوڕەکانی بدە، هەروەها لە پەنجە گەورەی دەستی ڕاست و پەنجە گەورەی پێی ڕاستیان بدە، پاشان خوێن بەسەر هەموو لایەکی قوربانگاکەدا بپرژێنە. ");
INSERT INTO ckb_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","ئینجا لە خوێنی سەر قوربانگاکە و لە زەیتی دەستنیشانکردنەکە هەڵبگرە و بیپرژێنە بەسەر هارون و جلەکانی و بەسەر کوڕەکانی و جلی کوڕەکانی. ئینجا خۆی و جلەکانی و کوڕەکانی و جلی کوڕەکانی پیرۆز دەبن. ");
INSERT INTO ckb_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","«لە بەرانەکە ئەمانە ببە، پیو و دوگ و پیوەکەی هەناوی و سەر جگەر و گورچیلەکان و هەردوو گورچیلە و ڕانی ڕاستی، چونکە ئەمە بەرانی ئەرک پێ سپاردنەکەیە. ");
INSERT INTO ckb_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","هەروەها لە سەبەتەی فەتیرەکە، ئەوەی لەبەردەم یەزدانە، نانێک و کولێرەیەک لەوەی بە زەیتە و ناسکە نانێک ببە. ");
INSERT INTO ckb_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","هەمووی بخە سەر دەستی هارون و کوڕەکانی و لەبەردەم یەزدان وەک قوربانی بەرزکردنەوە بەرزی بکەنەوە. ");
INSERT INTO ckb_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","دواتر لە دەستیان وەریبگرەوە و لەگەڵ قوربانی سووتاندنەکە لەسەر قوربانگاکە بیسووتێنە، بۆنی خۆشییە لەبەردەم یەزدان، قوربانی بە ئاگرە بۆ یەزدان. ");
INSERT INTO ckb_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","لەدوای ئەوەی سنگی بەرانەکەی دیکە بۆ ئەرک پێ سپاردنی کاهینیێتی هارون ببە، وەک قوربانی بەرزکردنەوە لەبەردەم یەزدان بەرزی بکەوە، ئەمەش دەبێتە بەش بۆ تۆ. ");
INSERT INTO ckb_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","«بەشەکانی بەرانی ئەرک پێ سپاردنەکە کە هی هارون و کوڕەکانییەتی، سنگە بەرزکراوەکە و ڕانە پێشکەشکراوەکە، تەرخان بکە. ");
INSERT INTO ckb_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","ئەمەش دەبێتە بەشێکی چەسپاو بۆ هارون و کوڕەکانی لەلایەن نەوەی ئیسرائیلەوە، چونکە پێویستە نەوەی ئیسرائیل ئەم بەشە پیتاکە لە قوربانی هاوبەشییانەوە بدەنە یەزدان. ");
INSERT INTO ckb_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","«جلوبەرگە پیرۆزەکانی هارونیش لەدوای مردنی خۆی بۆ نەوەکانی دەبێت، تاکو بەو جلانەوە دەستنیشان بکرێن و ئەرکیان پێ بسپێردرێت. ");
INSERT INTO ckb_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","کوڕەکەی، ئەوەی وەک کاهین جێی دەگرێتەوە حەوت ڕۆژ لەبەری دەکات، کاتێک دێتە ناو چادری چاوپێکەوتن بۆ ئەوەی لە شوێنی پیرۆز خزمەت بکات. ");
INSERT INTO ckb_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","«بەرانی ئەرک پێ سپاردنەکەش ببە و گۆشتەکەی لە شوێنێکی پیرۆز لێبنێ. ");
INSERT INTO ckb_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","هارون و کوڕەکانی گۆشتی بەرانەکە و نانی ناو سەبەتەکە لەلای دەروازەکەی چادری چاوپێکەوتن بخۆن. ");
INSERT INTO ckb_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","ئەوانە ئەم قوربانییانە دەخۆن کە بۆ کەفارەتیان کراون بۆ ئەرک پێ سپاردنیان و بۆ تەرخانکردنیان، بەڵام هیچ کەسێکی دیکە لێیان ناخوات، چونکە پیرۆزن. ");
INSERT INTO ckb_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","ئەگەر لە گۆشتی بەرانی ئەرک پێ سپاردنەکەش یان لە نانەکە هەتا بەیانی مایەوە، ئەوا ئەوەی ماوەتەوە بە ئاگر بیسووتێنە و ناخورێت، چونکە پیرۆزە. ");
INSERT INTO ckb_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","«ئاوا بۆ هارون و کوڕەکانی بکە، وەکو هەموو ئەوەی فەرمانم پێکردیت، حەوت ڕۆژ ئەرکیان پێ بسپێرە. ");
INSERT INTO ckb_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","هەموو ڕۆژێک جوانەگایەک پێشکەش بکە وەک قوربانی گوناه بۆ کەفارەت، هەروەها قوربانگاکەش پاک بکەرەوە بەوەی کەفارەتی بۆ دەکەیت، هەروەها بە زەیت تەرخانی بکە. ");
INSERT INTO ckb_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","حەوت ڕۆژ لەسەر قوربانگاکە کەفارەتی بۆ بکە و تەرخانی بکە، جا قوربانگاکە دەبێتە هەرەپیرۆز، هەموو ئەوەی بەر قوربانگاکە بکەوێت پیرۆز دەبێت. ");
INSERT INTO ckb_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","«ئەمەش ئەوەیە کە لەسەر قوربانگاکە پێشکەشی دەکەیت، هەموو ڕۆژێک بە بەردەوامی دوو بەرخی نێری یەک ساڵە. ");
INSERT INTO ckb_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","یەکێک لە بەرخەکان لە بەیانی پێشکەش بکە و بەرخی دووەمیش لە کاتی خۆرئاوابوون. ");
INSERT INTO ckb_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","لەگەڵ دەیەکی ئێفەیەک لە باشترین ئارد بە چارەکە هەینێک زەیتی زەیتوونی گوشراو شێلرابێت و لە شەرابی پێشکەشکراویش چارەکە هەینێک شەراب، ئەمە بۆ بەرخی یەکەم. ");
INSERT INTO ckb_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","هەروەها بەرخی دووەمیش لە کاتی خۆرئاوابووندا پێشکەش بکە، لەگەڵ پێشکەشەکراوی دانەوێڵەکەی و شەرابە پێشکەشکراوەکەی، وەک ئەوەی لە بەیانیدا کردووتە، بۆنێکی خۆشە و قوربانی بە ئاگرە بۆ یەزدان. ");
INSERT INTO ckb_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","«قوربانی سووتاندنی بەردەوامە بۆ نەوەکانتان لەلای دەروازەی چادری چاوپێکەوتن لەبەردەم یەزدان، کە لەوێ لەگەڵتان ژوان دەبەستم بۆ ئەوەی لەگەڵت بدوێم. ");
INSERT INTO ckb_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","هەروەها ژوان لەگەڵ نەوەی ئیسرائیلیش دەبەستم، جا بە شکۆی من شوێنەکە پیرۆز دەبێت. ");
INSERT INTO ckb_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","«هەروەها چادری چاوپێکەوتن و قوربانگاکە تەرخان دەکەم، هارون و کوڕەکانیشی تەرخان دەکەم بۆ ئەوەی کاهینیێتیم بۆ بکەن. ");
INSERT INTO ckb_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","لەنێو نەوەی ئیسرائیلدا نیشتەجێ دەبم و بۆیان دەبمە خودا. ");
INSERT INTO ckb_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","جا دەزانن کە من یەزدانی پەروەردگاری خۆیانم، کە لە خاکی میسرەوە دەرمهێنان هەتا لەنێویان نیشتەجێ بم. من یەزدانی پەروەردگاری خۆیانم. ");
INSERT INTO ckb_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","«قوربانگای بخوور سووتاندنیش لە داری ئەکاسیا دروستبکە. ");
INSERT INTO ckb_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","درێژییەکەی باڵێک و پانییەکەی باڵێک، چوار گۆشە بێت، بەرزاییەکەشی دوو باڵ، قۆچەکانیش لە خۆی بێت. ");
INSERT INTO ckb_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","بە زێڕی بێگەردیش ڕووکەشی بکە، سەرەوەی و دیوارەکانی بە چواردەوریدا لەگەڵ قۆچەکانی، هەروەها چوارچێوەیەکی زێڕینیشی بە چواردەوردا بۆ دروستبکە. ");
INSERT INTO ckb_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","دوو ئەڵقەی زێڕینیشی بۆ دروستبکە، لەژێر چوارچێوەکەیەوە، لەسەر هەردوو لایەکەی دروستی بکە، بۆ ئەوەی ببنە گیرە بۆ دوو دار بۆ ئەوەی پێیان هەڵبگیرێت. ");
INSERT INTO ckb_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","دوو دارەکەش لە داری ئەکاسیا دروستبکە و بە زێڕ ڕووکەشیان بکە. ");
INSERT INTO ckb_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","قوربانگاکە لەپێش ئەو پەردەیە دادەنێیت کە لەبەردەم سندوقی پەیمانە، لەبەردەم قەپاغی کەفارەت کە لەسەر ئەو دوو تەختەی پەیمانە، ئەوەی لەوێ چاوپێکەوتنت لەگەڵ دەکەم. ");
INSERT INTO ckb_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","«هارون هەموو بەیانییەک بخووری بۆنخۆشی لەسەر بسووتێنێت، کاتێک چراکان ئامادە دەکات بیسووتێنێت. ");
INSERT INTO ckb_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","هەروەها کاتێک هارون ئێواران چراکان سەردەخات بیسووتێنێت، بخوورێکی بەردەوامە لەبەردەم یەزدان بۆ نەوەکانتان. ");
INSERT INTO ckb_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","هیچ بخووری دیکەی مەخەنە سەر، هەروەها قوربانی سووتاندن و دانەوێڵەی پێشکەشکراو، هیچ شەرابێکی پێشکەشکراویشی بەسەردا مەڕێژن. ");
INSERT INTO ckb_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","هارونیش ساڵی جارێک کەفارەت لەسەر قۆچەکانی بکات، لە خوێنی قوربانی گوناه کە بۆ کەفارەتە، ساڵی جارێک کەفارەتی لەسەر دەکرێت بۆ نەوەکانتان، هەرەپیرۆزە بۆ یەزدان.» ");
INSERT INTO ckb_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","«کاتێک سەرژمێری نەوەی ئیسرائیل دەکەیت، لە کاتی تۆمارکردنیان هەریەکە و نرخی ژیانی خۆی دەداتە یەزدان، ئیتر کارەساتیان تێناکەوێت کاتێک دەیانژمێریت. ");
INSERT INTO ckb_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","هەرکەسێک لە سەرژمێریکراوەکان پێویستە نیو شاقلە بە شاقلی پیرۆزگا بدات، کە هەر شاقلێکیش بیست گێرایە. ئەم نیو شاقلە بە پێشکەشکراو بۆ یەزدان دادەنرێت. ");
INSERT INTO ckb_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","هەموو ئەوانەی دەژمێردرێن لە گەنجی بیست ساڵ بەرەو سەرەوە، پێشکەشکراو دەدەنە یەزدان. ");
INSERT INTO ckb_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","دەوڵەمەند زیاتر نادات و هەژاریش لە نیو شاقل کەمتر نادات، کاتێک پێشکەشکراوەکەی یەزدان بۆ کەفارەتی خۆتان دەدەن. ");
INSERT INTO ckb_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","زیوی کەفارەتەکەش لە نەوەی ئیسرائیل وەردەگریت و بۆ خزمەتی چادری چاوپێکەوتن دایدەنێیت. بۆ نەوەی ئیسرائیل دەبێتە یادەوەری لەبەردەم یەزدان بۆ کەفارەتی گیانتان.» ");
INSERT INTO ckb_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","هەروەها یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","«حەوزێک لە بڕۆنز دروستبکە و ژێرەکەشی لە بڕۆنز بێت بۆ شوشتن، لەنێوان چادری چاوپێکەوتن و قوربانگاکەی دابنێ و ئاوی تێبکە. ");
INSERT INTO ckb_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","هارون و کوڕەکانی دەست و پێیانی لێ بشۆن، ");
INSERT INTO ckb_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","لە کاتی چوونە ژوورەوەیان بۆ چادری چاوپێکەوتن بە ئاو بیشۆن نەوەک بمرن. هەروەها کاتێک لە قوربانگاکە نزیک دەبنەوە بۆ خزمەت بۆ سووتاندنی قوربانی بە ئاگر بۆ یەزدان، ");
INSERT INTO ckb_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","دەست و پێیان بشۆن نەوەک بمرن. ئەمەش دەبێتە فەرزێکی هەتاهەتایی بۆ هارون و بۆ وەچەکەی لە نەوەکانیان.» ");
INSERT INTO ckb_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","هەروەها یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","«تۆش بۆ خۆت باشترین بۆن ببە، پێنج سەد شاقل ئاوی موڕ و نیوەی ئەوە دوو سەد و پەنجا شاقل دارچینی بۆنخۆش و دوو سەد و پەنجا شاقل قامیشی بۆنخۆش، ");
INSERT INTO ckb_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","کاسیاش پێنج سەد شاقل، هەمووی بەگوێرەی شاقلی پیرۆزگا بێت، هەروەها لە زەیتی زەیتوونیش هەینێک. ");
INSERT INTO ckb_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","بەمانە زەیتی پیرۆز بۆ دەستنیشانکردن دروستبکە، تێکەڵ وەک دەستکردی عەتار، دەبێتە زەیتی پیرۆز بۆ دەستنیشانکردن. ");
INSERT INTO ckb_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","ئینجا چادری چاوپێکەوتن و سندوقی پەیمان، ");
INSERT INTO ckb_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","لەگەڵ مێزەکە و هەموو قاپوقاچاغەکانی و چرادانەکە و قاپوقاچاغەکانی و قوربانگاکەی بخوور و ");
INSERT INTO ckb_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","قوربانگاکەی قوربانی سووتاندن و هەموو قاپوقاچاغەکانی و حەوزەکە و ژێرەکەی پێ چەور دەکەیت. ");
INSERT INTO ckb_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","تەرخانیان بکە و دەبنە هەرەپیرۆز، هەر شتێک پێیان بکەوێت پیرۆز دەبێت. ");
INSERT INTO ckb_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","«هارون و کوڕەکانیشی دەستنیشان بکە و تەرخانیان بکە بۆ ئەوەی کاهینیێتیم بۆ بکەن. ");
INSERT INTO ckb_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","لەگەڵ نەوەی ئیسرائیلیش قسە بکە و بڵێ: ”ئەمە بۆ من دەبێتە زەیتێکی پیرۆز بۆ دەستنیشانکردنی کەسانێک لە نەوەکانتان. ");
INSERT INTO ckb_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","نابێت بەسەر لەشی کەسدا بکرێت و نابێت بە پێوانەکانی وەک ئەو دروستبکرێت. ئەم زەیتە پیرۆزە، دەبێت لەلاتان پیرۆز بێت. ");
INSERT INTO ckb_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","هەرکەسێک وەک ئەوە عەتاری بکات و ئەو زەیتە لە کەسانی دیکە بدات، لەنێو گەلەکەیدا دادەبڕدرێت.“» ");
INSERT INTO ckb_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","هەروەها یەزدان بە موسای فەرموو: «بۆنوبەرام بۆ خۆت ببە، مەستەکی و بۆنی گوێچکە ماسی و موڕی بۆنخۆش و بخووری سادە، بەشی یەکسان بن، ");
INSERT INTO ckb_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","بیانکە بە بخووری بۆنخۆش، دەستکردی عەتار، سوێرکراوی بێگەرد و پیرۆز. ");
INSERT INTO ckb_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","هەندێکی لێ ورد بکە وەک تۆز و لەبەردەم سندوقی پەیمان دایبنێ لەناو چادری چاوپێکەوتن، ئەوەی لەوێ چاوپێکەوتنت لەگەڵ دەکەم، دەبێتە هەرەپیرۆز بۆتان. ");
INSERT INTO ckb_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","ئەو بخوورەی بە پێوانەی ئەو دروستی دەکەن نابێت بۆ خۆتانی دروستبکەن، لەلاتان پیرۆز دەبێت بۆ یەزدان، ");
INSERT INTO ckb_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","هەرکەسێک وەک ئەوە دروستبکات هەتا بۆنی بکات، لەنێو گەلەکەیدا دادەبڕدرێت.» ");
INSERT INTO ckb_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","هەروەها یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","«بڕوانە، ئەوا من بەسەلئێلی کوڕی ئوری کوڕی حوورم لە هۆزی یەهودا هەڵبژاردووە، ");
INSERT INTO ckb_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","لە ڕۆحی خوداشەوە پڕم کردووە لە دانایی و تێگەیشتن و زانیاری لە هەموو جۆرە پیشەگەرییەک. ");
INSERT INTO ckb_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","بۆ داهێنانی داهێنانەکان، بۆ کارکردن لە زێڕ و زیو و بڕۆنز، ");
INSERT INTO ckb_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","بۆ تاشین و ڕازاندنەوەی بەرد، بۆ دارتاشی و بۆ کارکردن لە هەموو پیشەیەک. ");
INSERT INTO ckb_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","من ئۆهۆلیئابی کوڕی ئەحیساماک کە لە هۆزی دانە، لەگەڵ ئەوم داناوە. «توانام داوە بە هەموو پیاوێکی پیشەوەر تاکو هەموو ئەو کارانە بکەن کە فەرمانم پێکردیت: ");
INSERT INTO ckb_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","«چادری چاوپێکەوتن، سندوقی پەیمان، قەپاغەکەی کەفارەت کە لەسەریەتی، هەموو کەلوپەلەکانی چادرەکە کە پێکهاتووە لە ");
INSERT INTO ckb_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","مێزەکە، قاپوقاچاغەکانی، چرادانەکە کە لە زێڕی بێگەردە و هەموو قاپوقاچاغەکانی، قوربانگاکەی بخوور، ");
INSERT INTO ckb_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","قوربانگاکەی قوربانی سووتاندن و هەموو قاپوقاچاغەکانی، حەوزەکە و ژێرەکەی، ");
INSERT INTO ckb_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","هەروەها جلوبەرگە چنراوەکان، جلوبەرگە پیرۆزەکان بۆ هارونی کاهین و جلوبەرگی کوڕەکانی بۆ ئەنجامدانی کاهینیێتی، ");
INSERT INTO ckb_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","زەیتەکەی دەستنیشانکردن، بخووری بۆنخۆش بۆ شوێنی پیرۆز. «هەروەک هەموو ئەوەی فەرمانم پێکردیت، دەیکەن.» ");
INSERT INTO ckb_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","هەروەها یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","«تۆ لەگەڵ نەوەی ئیسرائیل بدوێ و بڵێ: ”دەبێت شەممەکانی من بپارێزن، چونکە نیشانەیە لەنێوان من و ئێوە بۆ نەوەکانتان هەتا بزانن کە من یەزدانم ئەوەی پیرۆزتان دەکەم. ");
INSERT INTO ckb_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","«”شەممە بپارێزن، چونکە پیرۆزە بۆتان، ئەوەی گڵاوی بکات دەبێت بکوژرێت، چونکە هەرکەسێک لەو پشووەدا کارێک بکات ئەوا لەنێو گەلەکەیدا دادەبڕدرێت. ");
INSERT INTO ckb_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","شەش ڕۆژ کار دەکرێت، بەڵام لە ڕۆژی حەوتەم پشوودانی شەممەیە، پیرۆزە بۆ یەزدان، هەرکەسێک لە ڕۆژی شەممە کار بکات دەبێت بکوژرێت. ");
INSERT INTO ckb_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","نەوەی ئیسرائیل شەممە بپارێزن، بۆ ئەوەی نەوەکانیان وەک پەیمانێکی هەتاهەتایی پەیوەست بن بە شەممەوە. ");
INSERT INTO ckb_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","لەنێوان من و نەوەی ئیسرائیل نیشانەیەکە بۆ هەتاهەتایە، چونکە لە شەش ڕۆژدا یەزدان ئاسمان و زەویی دروستکرد و لە ڕۆژی حەوتەم لە کارکردن وەستا و پشووی دا.“» ");
INSERT INTO ckb_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","کاتێک کە لە شاخی سینا لە قسەکانی بووەوە لەگەڵ موسا، دوو تەختەکەی پەیمانی دایە موسا، تەختەی بەرد بوون و بە پەنجەی خودا نووسرا بوون. ");
INSERT INTO ckb_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","کاتێک گەل بینی موسا دواکەوت لە هاتنە خوارەوە لە کێوەکە، لەسەر هارون کۆبوونەوە و پێیان گوت: «وەرە! چەند خوداوەندێکمان بۆ دروستبکە لەپێشمانەوە بڕۆن، چونکە ئەم موسایە، ئەو پیاوەی ئێمەی لە خاکی میسرەوە دەرهێنا نازانین چی لێهات.» ");
INSERT INTO ckb_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","هارونیش وەڵامی دانەوە: «ئەو گوارە زێڕانەی لە گوێی ژن و کوڕ و کچەکانتانە لێی بکەنەوە و بۆ منی بهێنن.» ");
INSERT INTO ckb_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","جا هەموو گەل ئەو گوارانەی لە گوێیان بوون لێیان کردنەوە و بۆ هارونیان هێنا. ");
INSERT INTO ckb_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","ئەویش لە دەستیانی وەرگرت و بە قاڵب شێوەی گوێرەکەیەکی داڕشت و بە قەڵەم و چەکوش ڕێکیخست، ئینجا گوتیان: «ئەی ئیسرائیل، ئەمە خوداوەندەکەتانە، ئەوەی ئێوەی لە خاکی میسر دەرهێنا.» ");
INSERT INTO ckb_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","کاتێک هارون ئەمەی بینی، قوربانگایەکی لەپێش گوێرەکەکە دروستکرد، بانگەوازی دا و گوتی: «بەیانی جەژنە بۆ یەزدان.» ");
INSERT INTO ckb_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","ئینجا بەیانی زوو هەستان و قوربانی سووتاندنیان سەرخست و قوربانی هاوبەشییان پێشکەش کرد، ئینجا گەل بۆ خواردن و خواردنەوە دانیشتن، پاشان بۆ ڕابواردن هەستانەوە. ");
INSERT INTO ckb_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","جا یەزدان بە موسای فەرموو: «بڕۆ خوارەوە، چونکە گەلەکەت گەندەڵ بوو، ئەوەی لە خاکی میسرەوە هێناتە دەرەوە. ");
INSERT INTO ckb_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","زوو لایاندا لەو ڕێگایەی کە فەرمانم پێکردن، گوێرەکەیەکی لەقاڵبدراویان بۆ خۆیان دروستکردووە و کڕنۆشی بۆ دەبەن و قوربانی بۆ سەر دەبڕن و دەڵێن: ”ئەی ئیسرائیل، ئەمە خوداوەندەکەتانە، ئەوەی ئێوەی لە خاکی میسر دەرهێنا.“» ");
INSERT INTO ckb_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","هەروەها یەزدان بە موسای فەرموو: «تەماشای ئەم گەلەم کرد، ئەوان گەلێکی کەللەڕەقن. ");
INSERT INTO ckb_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","ئێستاش لێمگەڕێ با تووڕەییم بەسەریاندا بێتە جۆش و کۆتاییان پێ بهێنم، تۆش دەکەمە گەلێکی مەزن.» ");
INSERT INTO ckb_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","بەڵام موسا لە یەزدانی پەروەردگاری خۆی پاڕایەوە و گوتی: «یەزدان، بۆچی تووڕەییت بەسەر گەلەکەتدا دێتە جۆش، کە لە خاکی میسرەوە بە توانایەکی مەزن و دەستێکی بەهێزەوە دەرتهێنا؟ ");
INSERT INTO ckb_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","بۆچی میسرییەکان بڵێن: ”بە نیازخراپی دەریهێنان هەتا لە کێوەکان بیانکوژێت و لەسەر ڕووی زەوی نەیانهێڵێت؟“ جۆشی تووڕەییت دابمرکێنەوە و ئەو سزایە ڕەت بکەرەوە کە فەرمووت بەسەر گەلەکەتدا دەیسەپێنیت. ");
INSERT INTO ckb_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","ئیبراهیم و ئیسحاق و ئیسرائیلی خزمەتکارانت بەبیر بێتەوە کە بە گیانی خۆت سوێندت بۆیان خوارد و پێت فەرموون، ”نەوەکانتان زۆر دەکەم وەک ئەستێرەکانی ئاسمان و هەموو ئەم خاکەش کە باسم کرد، دەیدەمە نەوەکانتان و دەبێتە موڵکیان بۆ هەتاهەتایە.“» ");
INSERT INTO ckb_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","ئینجا یەزدان پاشگەز بووەوە لەو کارەساتەی فەرمووی، کە ویستی بە گەلەکەی بکات. ");
INSERT INTO ckb_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","موسا ڕووی وەرگێڕا و لە کێوەکە هاتە خوارەوە، دوو تەختەکەی پەیمانیشی لە دەست بوو، ئەو تەختانەی لە هەردوو ڕووەکەی نووسرابوون، لەم لاو لەو لاوە نووسرابوون. ");
INSERT INTO ckb_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","تەختەکان دەستکردی خودان و نووسینەکەش نووسینی خودایە لەسەر تەختەکان نەخشێنراوە. ");
INSERT INTO ckb_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","کاتێک یەشوع گوێی لە دەنگی گەل بوو کە هاواریان دەکرد، بە موسای گوت: «دەنگی جەنگە لە ئۆردوگاکە!» ");
INSERT INTO ckb_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","ئەویش گوتی: «نە دەنگی هاواری سەرکەوتنە، نە دەنگی هاواری دۆڕاندنە، بەڵکو دەنگی گۆرانییە، ئەوەی گوێم لێیە.» ");
INSERT INTO ckb_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","ئەوە بوو کاتێک لە ئۆردوگاکە نزیک کەوتەوە، چاوی بە گوێرەکە و سەما کەوت، تووڕەیی موسا جۆشا و هەردوو تەختەکەی لە دەستیەوە فڕێدا و لە خوار کێوەکە شکاندنی. ");
INSERT INTO ckb_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","هەروەها ئەو گوێرەکەیەی دروستیان کردبوو بردی و سووتاندی، هاڕی هەتا بووە تۆز، بەسەر ئاوەکەدا بەبای کرد و ئاوەکەی بە نەوەی ئیسرائیل خواردەوە. ");
INSERT INTO ckb_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","موسا بە هارونی گوت: «ئەم گەلە چییان لێکردوویت هەتا ئەو گوناهە گەورەیەیان بەسەربهێنیت؟» ");
INSERT INTO ckb_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","هارونیش گوتی: «با تووڕەیی گەورەم نەجۆشێت، خۆت دەزانیت چۆن دڵی ئەم گەلە مەیلی خراپەکاری هەیە. ");
INSERT INTO ckb_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","پێیان گوتم: ”چەند خوداوەندێکمان بۆ دروستبکە لەپێشمانەوە بڕۆن، چونکە ئەم موسایە، ئەو پیاوەی ئێمەی لە خاکی میسرەوە دەرهێنا، نازانین چی لێهات.“ ");
INSERT INTO ckb_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","منیش پێم گوتن: ”کێ زێڕی پێوەیە با لێی بکاتەوە و بمداتێ.“ ئینجا فڕێمدایە ناو ئاگر و ئەم گوێرەکەیەی لێ دەرچوو!» ");
INSERT INTO ckb_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","موسا بینی گەل بەڕەڵا کراوە، چونکە هارون بەڕەڵای کردبوون هەتا ببنە گاڵتەجاڕ لەنێو بەرهەڵستکارانیان. ");
INSERT INTO ckb_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","ئینجا موسا لە دەروازەی ئۆردوگاکە وەستا و گوتی: «کێ بۆ یەزدانە با بێتە لام.» ئیتر هەموو نەوەی لێڤی لێی کۆبوونەوە. ");
INSERT INTO ckb_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","ئەویش پێی گوتن: «یەزدانی پەروەردگاری ئیسرائیل ئەمە دەفەرموێت: ”با هەریەکە شمشێرەکەی لە لاڕانییەوە ببەستێت، دەروازە بە دەروازە بە ئۆردوگاکەدا تێبپەڕن و بگەڕێنەوە، با هەریەکە بکوژێت، جا برای بێت یان هاوڕێ یان دراوسێ.“» ");
INSERT INTO ckb_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","نەوەی لێڤیش بەم جۆرەیان کرد، هەروەک موسا گوتی، ئەو ڕۆژە نزیکەی سێ هەزار پیاو لە گەل کەوتن. ");
INSERT INTO ckb_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","موسا گوتی: «ئەمڕۆ ئێوە تەرخان کراون بۆ یەزدان، لەبەر ئەوەی ئێوە لە دژی کوڕ و براکانتان بوون، ئیتر ئەمڕۆ بەرەکەتداری کردن.» ");
INSERT INTO ckb_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","ئەوە بوو بۆ بەیانی موسا بە گەلی گوت: «ئێوە گوناهێکی گەورەتان کردووە، بەڵام ئێستا سەردەکەوم بۆ لای یەزدان، بەڵکو کەفارەتی گوناهەکەتان بکەم.» ");
INSERT INTO ckb_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","ئیتر موسا گەڕایەوە لای یەزدان و گوتی: «ئای کە ئەم گەلە گوناهێکی گەورەی کرد و خوداوەندی زێڕینیان بۆ خۆیان دروستکرد، ");
INSERT INTO ckb_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","بەڵام ئێستا لە گوناهیان خۆشبە، ئەگەر نا، لە پەڕتووکەکەی خۆت بمسڕەوە کە نووسیوتە.» ");
INSERT INTO ckb_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","یەزدانیش بە موسای فەرموو: «ئەوەی گوناهی سەبارەت بە من کردبێت لە پەڕتووکی خۆم دەیسڕمەوە. ");
INSERT INTO ckb_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","ئێستاش بڕۆ پێشڕەوی گەل بکە بۆ ئەو شوێنەی پێم گوتیت، فریشتەکەم وا لەپێشت دەڕوات، بەڵام کاتێک ڕۆژی سزادان هات، لەسەر گوناهەکانیان سزایان دەدەم.» ");
INSERT INTO ckb_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","ئیتر یەزدان گەلی تووشی دەرد کرد لەسەر ئەوەی لەگەڵ گوێرەکەکە کردیان کە هارون دروستی کردبوو. ");
INSERT INTO ckb_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","یەزدان بە موسای فەرموو: «لێرە بڕۆ، خۆت و ئەو گەلەی لە خاکی میسرەوە هێناتە دەرەوە، بڕۆنە ئەو خاکەی سوێندم بۆ ئیبراهیم و ئیسحاق و یاقوب خوارد و فەرمووم: ”دەیدەمە نەوەکەت.“ ");
INSERT INTO ckb_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","فریشتەیەکیش لەپێشتەوە دەنێرم و کەنعانی و ئەمۆری و حیتی و پریزی و حیڤی و یەبوسییەکان ڕادەماڵم. ");
INSERT INTO ckb_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","بۆ خاکێک کە شیر و هەنگوینی لێ دەڕژێت، بەڵام من لەناوەندت سەرناکەوم، چونکە تۆ گەلێکی کەللەڕەقیت و نەوەک لە ڕێگا کۆتاییت پێ بهێنم.» ");
INSERT INTO ckb_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","کاتێک گەل گوێیان لەم هەواڵە ناخۆشانە بوو، شینیان گێڕا و کەس خۆی نەڕازاندەوە. ");
INSERT INTO ckb_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","یەزدانیش بە موسای فەرمووبوو: «بە نەوەی ئیسرائیل بڵێ: ”ئێوە گەلێکی کەللەڕەقن، ئەگەر تەنها بۆ ساتێک سەرکەومە ناوتان، کۆتاییتان پێ دەهێنم. ئێستاش جوانکارییەکەت دابکەنە و دەزانم چیت پێ دەکەم.“» ");
INSERT INTO ckb_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","ئینجا نەوەی ئیسرائیل لە کێوی حۆرێڤ بابەتەکانی جوانکارییان لە خۆیان کردەوە. ");
INSERT INTO ckb_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","موساش چادرێکی دەهێنا و لە دەرەوەی ئۆردوگاکە، دوور لە ئۆردوگاکە هەڵیدەدا و ناوی لێنابوو «چادری چاوپێکەوتن». هەرکەسێک داوای ڕاوێژی لە یەزدان دەکرد، دەچوو بۆ ئەم چادرەی چاوپێکەوتن، ئەوەی لە دەرەوەی ئۆردوگاکە بوو. ");
INSERT INTO ckb_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","هەروەها هەر کاتێک موسا بۆ چادرەکە دەڕۆیشت، هەموو گەل هەڵدەستان و هەریەکە لە دەروازەی چادرەکەی خۆی ڕادەوەستا، دەیڕوانییە دوای موسا هەتا دەچووە ناو چادرەکەوە. ");
INSERT INTO ckb_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","کاتێک موسا دەچووە ناو چادرەکە ستوونێکی هەور دادەبەزی و لەبەر دەروازەی چادرەکە ڕادەوەستا، ئینجا یەزدان لەگەڵ موسا دەدوا. ");
INSERT INTO ckb_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","گەلیش هەموویان ستوونی هەورەکەیان دەبینی لەبەر دەروازەی چادرەکە ڕاوەستاوە، هەموو گەل هەڵدەستان و کڕنۆشیان دەبرد، هەریەکە و لەبەر دەروازەی چادرەکەی خۆی. ");
INSERT INTO ckb_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","یەزدانیش ڕووبەڕوو لەگەڵ موسا دەدوا، هەروەک یەکێک لەگەڵ برادەرەکەی بدوێت. کاتێکیش موسا دەگەڕایەوە ئۆردوگاکە، گەنجە خزمەتکارەکەی کە یەشوعی کوڕی نون بوو لەناو چادرەکە دەرنەدەچوو. ");
INSERT INTO ckb_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","موسا بە یەزدانی گوت: «بڕوانە، تۆ بە منت فەرموو: ”ئەم گەلە سەربخە،“ بەڵام تۆ پێت نەناساندم کە کێ لەگەڵم دەنێریت، هەروەها تۆ فەرمووت: ”دەتناسم و ناویشت دەزانم و پەسەندیت لەبەرچاوم.“ ");
INSERT INTO ckb_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","ئێستاش ئەگەر لەبەرچاوت پەسەندم، ڕێگای خۆتم فێر بکە، بۆ ئەوەی بتناسم، هەتا لەبەرچاوت پەسەند بم. هەروەها لە بیرت بێت کە ئەم نەتەوەیە گەلی خۆتە.» ");
INSERT INTO ckb_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","یەزدان فەرمووی: «من خۆم لەگەڵت دەبم و دەتحەسێنمەوە.» ");
INSERT INTO ckb_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","موساش پێی گوت: «ئەگەر تۆ لەگەڵمان نەبیت و لەگەڵمان نەڕۆیت، لێرەوە سەرمان مەخە. ");
INSERT INTO ckb_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","بە چیش دەزانرێت کە من و گەلەکەت لەبەرچاوت پەسەندین، ئەگەر تۆ لەگەڵمان نەڕۆیشتبیت؟ بەمە لە هەموو گەلانی سەر ڕووی زەوی جیا دەکرێینەوە.» ");
INSERT INTO ckb_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","یەزدانیش بە موسای فەرموو: «هەروەها ئەم شتەش دەکەم کە باست کرد، چونکە لەبەرچاوم پەسەند بوویت و بە ناوت تۆم ناسی.» ");
INSERT INTO ckb_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","ئینجا موسا گوتی: «شکۆمەندی خۆتم پیشان بدە.» ");
INSERT INTO ckb_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","ئەویش فەرمووی: «هەموو چاکیم لەپێشت تێدەپەڕێنم. من کە ناوم یەزدانە، لەبەردەمی تۆ ناوی خۆم ڕادەگەیەنم. میهرەبان دەبم لەگەڵ ئەوەی میهرەبان دەبم و بە بەزەیی دەبم لەگەڵ ئەوەی بەزەییم پێیدا دێتەوە.» ");
INSERT INTO ckb_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","هەروەها فەرمووی: «ناتوانیت ڕووم ببینیت، چونکە هیچ مرۆڤێک نییە بمبینێت و بژیێت.» ");
INSERT INTO ckb_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","هەروەها یەزدان فەرمووی: «ئەوەتا شوێنێکم هەیە و لەسەر ئەو تاشەبەردە بوەستە. ");
INSERT INTO ckb_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","کاتێک شکۆمەندیم تێدەپەڕێت، ئەوا دەتخەمە کەلێنێکی بەردەکە و هەتا تێدەپەڕم بە دەستم داتدەپۆشم، ");
INSERT INTO ckb_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","دواتر دەستم هەڵدەگرم و تۆ لە دواوە دەمبینیت، بەڵام ڕووم نابینرێت.» ");
INSERT INTO ckb_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","یەزدان بە موسای فەرموو: «دوو تەختە بەردی وەک ئەوانەی یەکەم بۆ خۆت بتاشە، منیش لەسەر دوو تەختەکە ئەو وشانە دەنووسمەوە کە لەسەر دوو تەختەکەی یەکەم جار بوون و تۆ شکاندت. ");
INSERT INTO ckb_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","بۆ بەیانیش ئامادە بە و لە بەیانیدا سەربکەوە بۆ سەر شاخی سینا. لەوێ لەسەر لووتکەی کێوەکە بۆم ڕاوەستە. ");
INSERT INTO ckb_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","کەس لەگەڵت سەرنەکەوێت و لە هەموو کێوەکە کەس نەبینرێت، هەروەها مەڕوماڵاتیش لەلای کێوەکە نەلەوەڕێنرێت.» ");
INSERT INTO ckb_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","ئینجا موسا دوو تەختە بەردی وەک ئەوانەی یەکەم جاری تاشی و بەیانی زوو هەستا و بۆ شاخی سینا سەرکەوت، هەروەک یەزدان فەرمانی پێ کرد، لەگەڵ دەستیشی دوو تەختە بەردەکەی هەڵگرت. ");
INSERT INTO ckb_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","یەزدان لە هەورەوە دابەزی و لەوێ لەلای ڕاوەستا و ناوی خۆی ڕاگەیاند کە یەزدانە. ");
INSERT INTO ckb_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","ئینجا یەزدان لەبەردەمی تێپەڕی و ڕایگەیاند: «یەزدان، یەزدان، خودایەکی بە بەزەیی و میهرەبانە، پشوودرێژە و خۆشەویستی نەگۆڕ و دڵسۆزی زۆرە. ");
INSERT INTO ckb_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","خۆشەویستی نەگۆڕ دەپارێزێت بۆ هەزاران، لە تاوان و یاخیبوون و گوناه خۆشدەبێت، بەڵام تاوانباران ئەستۆپاک ناکات، بەڵکو لەسەر تاوانی باوکان سزای نەوەکان دەدات هەتا نەوەی سێیەم و چوارەم.» ");
INSERT INTO ckb_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","موسا خێرا سەری دانەواند و کڕنۆشی برد، ");
INSERT INTO ckb_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","گوتی: «ئەی پەروەردگار، ئەگەر لەبەرچاوت پەسەندم، با پەروەردگار لەگەڵمان بڕوات، چونکە گەلێکی کەللەڕەقە، تۆش لە تاوان و گوناهمان خۆشبە و بمانکە بە موڵکی خۆت.» ");
INSERT INTO ckb_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","ئەویش فەرمووی: «گوێ بگرن، پەیمانێکتان لەگەڵ دەبەستم. لە بەرامبەر هەموو گەلەکەتان کاری سەرسوڕهێنەری وا دەکەم کە لە هەموو زەویدا و لەناو هەموو نەتەوەکاندا نەکرابێت، هەموو ئەو گەلەش کە ئێوە لەنێویاندان کرداری یەزدان دەبینن، چونکە ئەوەی من لەگەڵ ئێوە دەیکەم سامناکە. ");
INSERT INTO ckb_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","ئەوەی ئەمڕۆ فەرمانتان پێدەدەم بەجێی بهێنن. من ئەمۆری و کەنعانی و حیتی و پریزی و حیڤی و یەبوسییەکان لەپێشتان دەردەکەم. ");
INSERT INTO ckb_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","ئاگاداربن هیچ پەیمانێک لەگەڵ دانیشتووانی ئەو خاکە مەبەستن کە دێنە سەری، نەوەک ببنە تەڵە لەناوەندتان. ");
INSERT INTO ckb_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","بەڵکو دەبێت ئێوە قوربانگاکانیان بڕووخێنن و بەردە تەرخانکراوەکانیان بشکێنن و ستوونە ئەشێراکانیان ببڕنەوە. ");
INSERT INTO ckb_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","کڕنۆش بۆ خودایەکی دیکە نەبەن، چونکە یەزدان ناوی ئیرەدارە، خودایەکی ئیرەدارە. ");
INSERT INTO ckb_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","«ئاگادار بن لەوەی پەیمان لەگەڵ دانیشتووانی خاکەکە ببەستن، چونکە هەروەک لەشفرۆش لەگەڵ چەندین کەس ڕادەبوێرێت، خەڵکی خاکەکەش لە جیاتی پەرستنی من، بت دەپەرستن، قوربانی بۆ خوداوەندەکانیان سەردەبڕن، داوەتتان دەکەن و ئێوەش لە قوربانییەکەیان دەخۆن. ");
INSERT INTO ckb_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","کاتێک کچیان بۆ کوڕتان دەخوازن و ئەو کچانەی وەک لەشفرۆش بەدوای خوداوەندەکانی خۆیان دەکەون، وا دەکەن کوڕی ئێوەش وەک لەشفرۆش بەدوای خوداوەندەکانی ئەوان بکەون. ");
INSERT INTO ckb_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","«خوداوەندی لەقاڵبدراو دروستمەکەن. ");
INSERT INTO ckb_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","«وەک فەرمانم پێکردوون، جەژنی فەتیرە بگێڕن، لە مانگی ئاڤیڤ حەوت ڕۆژ نانی فەتیرە بخۆن، چونکە ئێوە لە مانگی ئاڤیڤ لە میسر هاتنە دەرەوە. ");
INSERT INTO ckb_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","«هەموو نۆبەرەی سکێک بۆ منە، هەروەها هەر نۆبەرەیەکی نێر لە ئاژەڵە ماڵییەکەشت لە گا و بەران، ");
INSERT INTO ckb_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","نۆبەرەی گوێدرێژ بە بەرخێک بکڕنەوە، بەڵام ئەگەر نەیکڕنەوە، دەبێت ملی بشکێنن، هەموو نۆبەرەیەک لە کوڕەکانتان بکڕنەوە. «بە بەتاڵی لەبەردەمم ئامادە نابن. ");
INSERT INTO ckb_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","«شەش ڕۆژ کار بکەن، بەڵام لە ڕۆژی حەوتەم شەممەیە، لە کاتی وەرزی کێڵان و لە کاتی دروێنەش پشوو بدەن. ");
INSERT INTO ckb_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","«جەژنی هەفتەکان بۆ خۆتان بگێڕن، یەکەم بەرهەمی دروێنەی گەنم و جەژنی کۆکردنەوە لە کۆتایی ساڵ. ");
INSERT INTO ckb_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","سێ جار لە ساڵێکدا هەموو نێرینەکانتان لەبەردەم یەزدانی باڵادەستی خودای ئیسرائیل ئامادە دەبن. ");
INSERT INTO ckb_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","گەلان لەبەردەمتان دەردەکەم و سنوورەکانتان فراوان دەکەم، کەسیش چاونابڕێتە خاکەکەتان، کاتێک لە ساڵێکدا سێ جار دێن بۆ ئەوەی لەبەردەم یەزدانی پەروەردگارتان ئامادە بن. ");
INSERT INTO ckb_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","«خوێنی قوربانیم لەگەڵ شتی بە هەویرترش پێشکەش مەکەن، قوربانی جەژنی پەسخە بۆ بەیانی نەمێنێتەوە. ");
INSERT INTO ckb_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","«باشترینی یەکەمین بەرهەمی زەوییەکەتان بۆ ماڵی یەزدانی پەروەردگارتان بهێنن. «هیچ کاریلەیەک بە شیری دایکی لێمەنێن.» ");
INSERT INTO ckb_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","هەروەها یەزدان بە موسای فەرموو: «ئەم وتانە بنووسەوە، چونکە بەگوێرەی ئەو وتانە پەیمانم لەگەڵ تۆ و لەگەڵ نەوەی ئیسرائیل بەستووە.» ");
INSERT INTO ckb_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","موسا چل شەو و چل ڕۆژ لەوێ بوو لەلای یەزدان، نانی نەخوارد و ئاوی نەخواردەوە، لەسەر دوو تەختەکەش وتەکانی پەیمانی نووسی، دە ڕاسپاردەکە. ");
INSERT INTO ckb_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","کاتێک موسا لە شاخی سینا دەهاتە خوارەوە، هەردوو تەختەکەی پەیمانی لەدەست بوو، لە هاتنە خوارەوەی لە کێوەکە موسا نەیزانی کە پێستی دەموچاوی دەدرەوشێتەوە، لەبەر قسەکردنی لەگەڵ یەزدان. ");
INSERT INTO ckb_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","کاتێک هارون و هەموو نەوەی ئیسرائیل بینییان موسا وا دەموچاوی دەدرەوشێتەوە، ئیتر ترسان لێی نزیک ببنەوە. ");
INSERT INTO ckb_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","بەڵام موسا بانگی کردن، ئیتر هارون و هەموو ڕابەرەکانی کۆمەڵ گەڕانەوە لای، موساش لەگەڵیان دوا. ");
INSERT INTO ckb_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","دواتر هەموو نەوەی ئیسرائیل نزیک کەوتنەوە، ئەویش فەرمانی پێدان بە هەموو ئەوەی کە یەزدان لە شاخی سینا لەگەڵی دوابوو. ");
INSERT INTO ckb_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","کاتێک موسا لە قسەکانی بووەوە لەگەڵیان، ڕووپۆشێکی لەسەر دەموچاوی دانا. ");
INSERT INTO ckb_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","بەڵام موسا لە کاتی چوونە ژوورەوەی بۆ بەردەم یەزدان بۆ قسەکردن لەگەڵی، هەتا دەهاتە دەرەوە ڕووپۆشەکەی لا دەدا، کاتێکیش دەهاتە دەرەوە، سەبارەت بەوەی فەرمانی پێکرابوو لەگەڵ نەوەی ئیسرائیل دەدوا. ");
INSERT INTO ckb_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","هەر کاتێک نەوەی ئیسرائیل دەموچاوی موسایان دەبینی کە دەدرەوشایەوە، موسا ڕووپۆشەکەی دەخستەوە سەر دەموچاوی هەتا دەچووە ژوورەوە بۆ ئەوەی لەگەڵ یەزدان بدوێت. ");
INSERT INTO ckb_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","موسا هەموو کۆمەڵی نەوەی ئیسرائیلی کۆکردەوە و پێی گوتن: «ئەمانە ئەو وشانەن کە یەزدان فەرمانی کردووە بکرێن، ");
INSERT INTO ckb_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","شەش ڕۆژ کار دەکرێت، بەڵام لە ڕۆژی حەوتەم بۆتان دەبێتە پیرۆز، پشوودانی شەممەیە بۆ یەزدان، ئەوەی کاری تێدا بکات دەبێت بکوژرێت. ");
INSERT INTO ckb_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","لە هەموو نشینگەکانتان نابێت لە ڕۆژی شەممە ئاگر بکرێتەوە.» ");
INSERT INTO ckb_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","هەروەها موسا بە هەموو کۆمەڵی نەوەی ئیسرائیلی گوت: «ئەمە ئەو شتەیە کە یەزدان فەرمانی پێ کردووە: ");
INSERT INTO ckb_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","لەلای خۆتانەوە پێشکەشکراو بۆ یەزدان ببەن، هەرکەسێک بە خواستی دڵی خۆی با پێشکەشکراو بۆ یەزدان بهێنێت: «لە زێڕ و زیو و بڕۆنز؛ ");
INSERT INTO ckb_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","ڕیسی مۆر و ئەرخەوانی و سووری ئاڵ، کەتانی ناسک و مووی بزن؛ ");
INSERT INTO ckb_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","پێستی بەران کە بە ڕەنگی سوور ڕەنگکرابوو و پێستی مانگای دەریا و داری ئەکاسیا؛ ");
INSERT INTO ckb_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","زەیتی زەیتوون بۆ چرا؛ بۆنوبەرام بۆ زەیتی دەستنیشانکردن و بۆ بخووری بۆنخۆش؛ ");
INSERT INTO ckb_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","بەردی عاشقبەند و بەردی گرانبەهای دیکە بۆ ئێفۆد و بۆ بەرسینە. ");
INSERT INTO ckb_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","«با هەموو بەهرەمەندێکیش لەنێوتان بێت و ئەوە بکات کە یەزدان فەرمانی پێ کردووە: ");
INSERT INTO ckb_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","«چادری پەرستن و ڕەشماڵەکەی و پۆشەر و فاق و چوارچێوە و کاریتە و کۆڵەکە و بنکەکانی؛ ");
INSERT INTO ckb_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","سندوقەکە و دارەکانی و قەپاغی کەفارەت و پەردەکەی شوێنی هەرەپیرۆز؛ ");
INSERT INTO ckb_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","مێزەکە و دارەکانی و هەموو قاپوقاچاغەکانی و نانی تەرخانکراو بۆ خودا؛ ");
INSERT INTO ckb_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","چرادانەکەی ڕووناکی و قاپوقاچاغ و چراکانی و زەیت بۆ ڕووناکی؛ ");
INSERT INTO ckb_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","قوربانگاکەی بخوور و دوو دارەکەی و زەیتی دەستنیشانکردن و بخووری بۆنخۆش؛ پەردەکەی دەروازە بۆ دەروازەی چادرەکەی پەرستن؛ ");
INSERT INTO ckb_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","قوربانگاکەی قوربانی سووتاندن و کەتیبە بڕۆنزییەکەی، دوو دارەکەی و هەموو قاپوقاچاغەکەی و حەوزەکە و ژێرەکەی؛ ");
INSERT INTO ckb_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","پەردەکانی حەوشە و کۆڵەکە و بنکەکانی و پەردەی دەروازەی حەوشەکە؛ ");
INSERT INTO ckb_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","سنگەکانی چادرەکەی پەرستن و سنگەکانی حەوشەکە و گوریسەکانیان؛ ");
INSERT INTO ckb_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","جلوبەرگە چنراوەکانی خزمەتکردن لە پیرۆزگا، جلوبەرگە پیرۆزەکەی هارونی کاهین و جلوبەرگی کوڕەکانی بۆ کاهینیێتی.» ");
INSERT INTO ckb_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","ئینجا هەموو کۆمەڵی نەوەی ئیسرائیل لەبەردەم موسا کشانەوە. ");
INSERT INTO ckb_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","دواتر هەموو ئەوانەی لە دڵیاندا بوو و ڕۆحیان خواستی، هاتن و پیتاکی یەزدانیان هێنا بۆ دروستکردنی چادری چاوپێکەوتن بۆ هەموو خزمەتەکە و بۆ جلوبەرگە پیرۆزەکان. ");
INSERT INTO ckb_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","هەموو پیاوان و ژنان هاتن، هەموو بە خواستی دڵیان خەزێم و گوارە و ئەنگوستیلە و ملوانکە و هەموو خشڵێکی زێڕیان هێنا، هەرکەسێک زێڕی خۆی وەک قوربانی بەرزکردنەوە بۆ یەزدان بەرزکردەوە. ");
INSERT INTO ckb_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","هەرکەسێکیش کە ڕیسی مۆر و ئەرخەوانی و سووری ئاڵ، کەتانی ناسک، مووی بزن، پێستی بەران کە بە ڕەنگی سوور ڕەنگکرابوو، یان پێستی مانگای دەریای هەبوو هێنای. ");
INSERT INTO ckb_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","کەسانێک هەبوون پیتاکی زیو و بڕۆنزیان پێشکەشی یەزدان کرد، کەسانێکیش هەبوون داری ئەکاسیایان هێنا بۆ بەکارهێنانی لە هەر خزمەتێکدا. ");
INSERT INTO ckb_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","هەموو ژنێکی بەهرەمەندیش ڕیسی بەدەست ڕست و ڕیسەکەی هێنا، ڕیسی مۆر و ئەرخەوانی و سووری ئاڵ و کەتانی ناسک. ");
INSERT INTO ckb_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","هەموو ئەو ئافرەتانەش کە لەسەر دڵیان بوو بە داناییەوە مووی بزنیان ڕست. ");
INSERT INTO ckb_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","سەرکردەکانیش بەردی عاشقبەند و بەردەکانی ڕازاندنەوەی ئێفۆد و بەرسینەکەیان هێنا. ");
INSERT INTO ckb_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","هەروەها بۆن و زەیت بۆ ڕووناکی و بۆ زەیتی دەستنیشانکردن و بخووری بۆنخۆش. ");
INSERT INTO ckb_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","هەموو ئەو پیاو و ئافرەتانەی ئیسرائیلیش کە لەسەر دڵیان بوو دیارییەک پێشکەش بکەن، هاتن و بەخشینیان هێنا بۆ ڕاپەڕاندنی هەموو ئەو کارانەی یەزدان کە لە ڕێگەی موسا فەرمانی پێکردبوون. ");
INSERT INTO ckb_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","موساش بە نەوەی ئیسرائیلی گوت: «بڕوانن، یەزدان بەسەلئێلی کوڕی ئوری کوڕی حووری لە هۆزی یەهودا هەڵبژاردووە، ");
INSERT INTO ckb_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","لە ڕۆحی خوداشەوە پڕی کردووە لە دانایی و تێگەیشتن و زانیاری لە هەموو جۆرە پیشەگەرییەک، ");
INSERT INTO ckb_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","بۆ داهێنانی داهێنانەکان، بۆ کارکردن لە زێڕ و زیو و بڕۆنز، ");
INSERT INTO ckb_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","بۆ تاشین و ڕازاندنەوەی بەرد، بۆ دارتاشی و بۆ کارکردن لە هەموو جۆرە پیشە و داهێنانێک. ");
INSERT INTO ckb_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","فێرکردنیشی لە دڵی داناوە، ئەو و ئۆهۆلیئابی کوڕی ئەحیساماک کە لە هۆزی دانە. ");
INSERT INTO ckb_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","پڕی کردوون لە بەهرەمەندی بۆ ئەنجامدانی هەموو جۆرە کارێک، تاشین و داهێنان، چنین لە ڕیسی مۆر و ئەرخەوانی و سووری ئاڵ، کەتانی ناسک و هەموو کارێکی ڕستن، وەستای هەموو کارێک و داهێنەری داهێنانەکان. ");
INSERT INTO ckb_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","ئیتر بەسەلئێل و ئۆهۆلیئاب و هەموو پیاوێکی بەهرەمەند کە یەزدان دانایی و تێگەیشتنی پێدابن هەتا بزانن چۆن کار بکەن لە هەموو کاری خزمەتکردنەکە لە پیرۆزگا، دەبێت بەگوێرەی هەموو ئەوەی یەزدان فەرمانی پێ کردوون بیکەن.» ");
INSERT INTO ckb_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","ئینجا موسا بەسەلئێل و ئۆهۆلیئاب و هەموو کەسێکی کارامە کە یەزدان توانای پێدابوو و خواستی ئەوەی هەبوو بێت بۆ کارکردن بانگی کردن. ");
INSERT INTO ckb_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","هەموو ئەو پیتاکەیان لە موسا وەرگرت، ئەوەی نەوەی ئیسرائیل هێنابوویان بۆ کاری خزمەتکردن لە بنیادنانی پیرۆزگا، ئەوانیش بە خواستی خۆیان هەموو بەیانییەک بەخشینیان بۆی دەهێنا. ");
INSERT INTO ckb_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","ئینجا هەموو ئەو پیشەوەرە کارامانەی کە لە پیرۆزگادا کاریان دەکرد، کارەکەیان بەجێهێشت و هاتنە لای موسا ");
INSERT INTO ckb_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","و پێیان گوت: «گەل زیاد لە پێویست دەهێنن بۆ ئەو کارەی کە یەزدان فەرمانی بە کردنی کردووە.» ");
INSERT INTO ckb_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","ئیتر موسا فەرمانی دا و لە ئۆردوگاکە بانگەواز کرا و گوترا: «با هیچ پیاوێک یان ژنێک ئیتر شت بۆ پیتاکی پیرۆزگا دروست نەکات.» جا گەل لە هێنان وەستان، ");
INSERT INTO ckb_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","چونکە ئەو کەرەستانەی کە پێشتر هێنرابوون بەشی هەموو کارەکانی دەکرد و زیاتریش بوو. ");
INSERT INTO ckb_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","هەموو بەهرەمەندێک لەوانەی کاریان لە دروستکردنی چادرەکەی پەرستن دەکرد، دە پڵاسیان لە کەتانی ڕستراو و ڕیسی مۆر و ئەرخەوانی و سووری ئاڵ دروستکرد، لەگەڵ وێنەی کەڕوبەکان بە دەستکردی جۆڵایەکی شارەزا دروستیان کردن. ");
INSERT INTO ckb_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","درێژایی هەر پڵاسێک بیست و هەشت باڵ و پانییەکەی چوار باڵ بوو، یەک ئەندازەش بۆ هەموو پڵاسەکان. ");
INSERT INTO ckb_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","پێنج پڵاس پێکەوە بەستران و پێنجەکەی دیکەش پێکەوە. ");
INSERT INTO ckb_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","ئەڵقەشیان لە ڕیسی مۆر لەسەر لێواری پڵاسە لاوەکییەکانی پارچەی یەکەم دروستکرد، هەمان شتیان بۆ لێواری پڵاسە لاوەکییەکانی پارچەی دووەم کرد. ");
INSERT INTO ckb_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","پەنجا ئەڵقەیان بۆ پڵاسی یەکەم دروستکرد و پەنجا ئەڵقەی دیکەش بۆ لای ئەو پڵاسەی کە لە پارچەکەی دووەمە، ئەڵقەکانیش بەرامبەر یەکتری بوون. ");
INSERT INTO ckb_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","پەنجا فاقی زێڕیشیان دروستکرد. بە فاقەکان پڵاسەکانی هەریەکە و لەوەی تەنیشتی بەستەوە، ئیتر چادری پەرستن بووە یەک پارچە. ");
INSERT INTO ckb_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","هەروەها ڕەشماڵێکیان لە یازدە پڵاس لە مووی بزن دروستکرد و سەری چادری پەرستنیان پێ گرت. ");
INSERT INTO ckb_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","درێژایی هەر پڵاسێک سی باڵ و پانی چوار باڵ بوو، یەک ئەندازەش بۆ هەر یازدە پڵاسەکە. ");
INSERT INTO ckb_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","پێنجیان لە پڵاسەکان پێکەوە بەستەوە و شەشەکەی دیکەش پێکەوە. ");
INSERT INTO ckb_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","پەنجا ئەڵقەیان لەسەر لێواری پڵاسی کۆتایی پارچەی یەکەم دروستکرد، پەنجا ئەڵقەش لەسەر لێواری پڵاسی کۆتایی پارچەی دووەم. ");
INSERT INTO ckb_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","پەنجا فاقی بڕۆنزیشیان دروستکرد بۆ بەیەکەوە بەستنەوەی چادرەکە هەتا ببێتە یەک پارچە. ");
INSERT INTO ckb_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","پۆشەرێکیشیان لە پێستی بەرانی ڕەنگکراو بە ڕەنگی سوور بۆ چادرەکە دروستکرد، پۆشەرێکیش لە پێستی مانگای دەریا لە سەرەوە. ");
INSERT INTO ckb_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","چوارچێوەشیان لە داری ئەکاسیا بە ستوونی بۆ چادرەکەی پەرستن دروستکرد. ");
INSERT INTO ckb_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","درێژایی هەر چوارچێوەیەک دە باڵ و پانی باڵ و نیوێک بوو. ");
INSERT INTO ckb_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","دوو زمانەشیان بۆ هەر چوارچێوەیەک دروستکرد بۆ جووتکردنی لەگەڵ چوارچێوەکەی تەنیشتی، بۆ هەریەک لە چوارچێوەکانی چادرەکەی پەرستن ئاوایان کرد. ");
INSERT INTO ckb_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","چوارچێوەکانی چادرەکەی پەرستنیش، بیستیان لەلای باشوور دروستکرد، ");
INSERT INTO ckb_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","چل بنکەی زیویشیان لەژێر بیست چوارچێوەکە دروستکرد، دوو بنکە لەژێر هەر چوارچێوەیەک بۆ دوو پێچکەکەی. ");
INSERT INTO ckb_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","بیست چوارچێوەیان بۆ لای باکووری چادرەکەی پەرستن دروستکرد. ");
INSERT INTO ckb_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","چل بنکەی زیویشیان هەبوو، دوو بنکە لەژێر چوارچێوەیەک و دوو بنکە لەژێر چوارچێوەیەکی دیکە. ");
INSERT INTO ckb_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","بۆ پشتی چادرەکەی پەرستنیش بەرەو ڕۆژئاوا شەش چوارچێوە، ");
INSERT INTO ckb_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","دوو چوارچێوەشیان بۆ گۆشەکانی دواوەی چادرەکەی پەرستن دروستکرد. ");
INSERT INTO ckb_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","لە خوارەوە جووت بوون و هەتا سەرەوە یەک بوون، هەتا بازنەکەی سەرەوە، بۆ هەردوو گۆشەکە ئاوایان کرد. ");
INSERT INTO ckb_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","ئینجا هەشت چوارچێوە بوون و بنکە زیوەکانیشیان شازدە، هەر دوو بنکە لەژێر چوارچێوەیەک. ");
INSERT INTO ckb_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","پێنج کاریتەشیان لە داری ئەکاسیا بۆ چوارچێوەکانی لایەکی چادرەکەی پەرستن دروستکرد، ");
INSERT INTO ckb_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","پێنج کاریتەش بۆ چوارچێوەکانی لایەکەی دیکەی چادرەکەی پەرستن، پێنج کاریتەش بۆ چوارچێوەکانی لای دواوەی چادرەکەی پەرستن لەلای ڕۆژئاوا. ");
INSERT INTO ckb_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","کاریتەکەی ناوەڕاستیشیان وا دروستکرد بەنێو چوارچێوەکاندا تێبپەڕێت، لەم سەرەوە بۆ ئەو سەر. ");
INSERT INTO ckb_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","چوارچێوەکانیشیان بە زێڕ ڕووکەش کرد و بازنەکانیشیان لە زێڕ دروست کرد کە کاریتەکانی دەچنە ناو، کاریتەکانیشیان بە زێڕ ڕووکەش کرد. ");
INSERT INTO ckb_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","پەردەیەکیشیان لە ڕیسی مۆر و ئەرخەوانی و سووری ئاڵ و کەتانی ڕستراو دروستکرد، بە دەستکردی جۆڵایەکی شارەزاش وێنەی کەڕوبەکانیان لەسەر دروستکرد. ");
INSERT INTO ckb_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","چوار کۆڵەکەشیان لە داری ئەکاسیا دروستکرد و بە زێڕ ڕووکەشیان کردن، قولاپەکانیشیان لە زێڕ بوون. چوار بنکەی زیویشیان بۆ داڕشتن. ");
INSERT INTO ckb_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","پەردەی دەروازەشیان بۆ دەرگای چادرەکە لە ڕیسی مۆر و ئەرخەوانی و سووری ئاڵ و کەتانی ڕستراو دروستکرد، چنراو بە دەستکردی جۆڵایەک، ");
INSERT INTO ckb_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","پێنج کۆڵەکەکەی و قولاپەکانیشیان، سەرەکانی و ئەڵقەکانیشیان بە زێڕ ڕووکەش کرد، پێنج بنکەکەشی لە بڕۆنز بوون. ");
INSERT INTO ckb_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","بەسەلئێلیش لە داری ئەکاسیا سندوقەکەی دروستکرد، درێژییەکەی دوو باڵ و نیو و پانییەکەی باڵ و نیوێک و بەرزییەکەی باڵ و نیوێک. ");
INSERT INTO ckb_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","ڕووی ناوەوە و دەرەوەی بە تەواوی بە زێڕی بێگەرد ڕووکەش کرد و بە چواردەوریشیدا چوارچێوەی زێڕینی بۆ دروستکرد. ");
INSERT INTO ckb_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","چوار بازنەی زێڕینیشی بۆ داڕشت و لەسەر چوار پایەکەی دانا، دوو بازنە لەلایەک و دوو بازنەش لەلایەکەی دیکەی. ");
INSERT INTO ckb_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","دوو داریشی لە داری ئەکاسیا دروستکرد و بە زێڕ ڕووکەشی کردن. ");
INSERT INTO ckb_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","دوو دارەکەشی خستە ناو بازنەکانی سەر هەردوو لای سندوقەکە، بۆ هەڵگرتنی سندوقەکە. ");
INSERT INTO ckb_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","قەپاغی کەفارەتیشی لە زێڕی بێگەرد دروستکرد کە دوو باڵ و نیو درێژییەکەی و باڵ و نیوێک پانییەکەی بوو. ");
INSERT INTO ckb_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","دوو کەڕوبی لە زێڕی کوتراو دروستکرد و کردی بە هەردوو لای قەپاغی کەفارەتەوە. ");
INSERT INTO ckb_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","کەڕوبێکی لەلایەک دروستکرد و کەڕوبەکەی دیکەش لەلایەکەی دیکە، لەگەڵ قەپاغەکەی کەفارەت یەک پارچە بوون. ");
INSERT INTO ckb_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","کەڕوبەکانیش باڵیان بۆ سەرەوە لێک کردبووەوە، بە باڵەکانیان سێبەریان بەسەر قەپاغی کەفارەتەکەوە کردبوو. کەڕوبەکان ڕووبەڕوو بوون و ڕوویان لە قەپاغی کەفارەتەکە بوو. ");
INSERT INTO ckb_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","مێزەکەیان لە داری ئەکاسیا دروستکرد، درێژییەکەی دوو باڵ و پانییەکەی باڵێک و بەرزییەکەی باڵ و نیوێک بوو. ");
INSERT INTO ckb_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","بە زێڕی بێگەردیش ڕووکەشیان کرد و چوارچێوەیەکی زێڕینیشیان لە چواردەوری دروستکرد. ");
INSERT INTO ckb_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","لێوارێکیشیان بە پانی چوار پەنجە لە چواردەوری دروستکرد و چوارچێوەیەکی زێڕینیشیان بۆ لێوارەکە لە دەوری دانا. ");
INSERT INTO ckb_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","چوار بازنەی زێڕینیشیان بۆ داڕشت، بازنەکانیان لەسەر هەر چوار گۆشەکەی چوار پایەکەی دانا. ");
INSERT INTO ckb_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","بازنەکان لەلای لێوارەکە بوونە گیرە بۆ دوو دار بۆ هەڵگرتنی مێزەکە. ");
INSERT INTO ckb_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","دوو دارەکەشیان لە داری ئەکاسیا دروستکرد و بە زێڕ ڕووکەشیان کردن بۆ هەڵگرتنی مێزەکە. ");
INSERT INTO ckb_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","قاپوقاچاغەکانی سەر مێزەکەش، لەگەن و قاپەکانی، هەروەها تاس و دۆلکەکانی کە شەرابی پێشکەشکراویان پێ دەڕژێنرێت لە زێڕی بێگەرد دروستیان کردن. ");
INSERT INTO ckb_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","چرادانەکەشیان لە زێڕی بێگەرد دروستکرد، ژێر چرادانەکە و قەدەکەیان لە زێڕی کوتراو دروستکرد، کاسەکانی و گرێیەکانی و خونچەکانی لە خۆی بوون. ");
INSERT INTO ckb_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","شەش لقیش لە هەردوو لایەوە دەرچووبوو، سێ لق چرادان لەلایەک و سێ لق چرادان لەلایەکەی دیکە. ");
INSERT INTO ckb_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","سێ کاسەی بادەمی لە لقێک بە گرێ و خونچەوە و سێ کاسەی بادەمی لە لقێکی دیکە بە گرێ و خونچەوە، ئاوا هەتا لقی شەشەم کە لە چرادانەکەوە دەرچووبوون. ");
INSERT INTO ckb_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","هەروەها لە چرادانەکە چوار کاسەی بادەمی بە گرێ و خونچەکانیانەوە هەبوو. ");
INSERT INTO ckb_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","هەر جووتێک لق لە شەش لقەکە گرێیەکیان لەژێر بوو، هەتا شەشەم لق کە لە چرادانەکە دەرچووبوو. ");
INSERT INTO ckb_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","گرێ و لقەکان لە خۆی بوون، هەمووشیان لە زێڕی بێگەردی کوتراو بوون. ");
INSERT INTO ckb_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","حەوت چراشیان بۆ دروستکرد، مەقاش و مەقەڵییەکانیشیان لە زێڕی بێگەرد بوون. ");
INSERT INTO ckb_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","چرادانەکە و هەموو کەلوپەلەکانیان لە تالنتێک زێڕی بێگەرد دروستکرد. ");
INSERT INTO ckb_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","قوربانگاکەی بخووریشیان لە داری ئەکاسیا دروستکرد، درێژییەکەی باڵێک و پانییەکەی باڵێک، چوار گۆشە بوو، بەرزاییەکەشی دوو باڵ بوو، قۆچەکانیش لە خۆی بوون. ");
INSERT INTO ckb_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","بە زێڕی بێگەردیش ڕووکەشیان کرد، سەرەوەی و دیوارەکانی بە چواردەوریدا لەگەڵ قۆچەکانی، هەروەها چوارچێوەیەکی زێڕینیشیان بە چواردەوردا بۆ دروستکرد. ");
INSERT INTO ckb_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","دوو ئەڵقەی زێڕینیشیان بۆ دروستکرد، لەژێر چوارچێوەکەیەوە، لەسەر هەردوو لایەکەی، بوونە گیرە بۆ دوو دار بۆ ئەوەی پێیان هەڵبگیرێت. ");
INSERT INTO ckb_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","دوو دارەکەشیان لە داری ئەکاسیا دروستکرد و بە زێڕ ڕووکەشیان کردن. ");
INSERT INTO ckb_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","زەیتی پیرۆزیان بۆ دەستنیشانکردن دروستکرد، بخوورەکەشیان بۆنخۆش و بێگەرد دروستکرد، کە دەستکردی عەتار بوون. ");
INSERT INTO ckb_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","قوربانگاکەی قوربانی سووتاندنیشیان لە داری ئەکاسیا دروستکرد، درێژییەکەی پێنج باڵ و پانییەکەی پێنج باڵ بوو، قوربانگاکە چوارگۆشە بوو، بەرزییەکەشی سێ باڵ بوو. ");
INSERT INTO ckb_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","قۆچەکانیشی لەسەر هەر چوار گۆشەکەی بوون، قۆچەکان لە خۆی بوون و بە بڕۆنز ڕووکەشیان کرد. ");
INSERT INTO ckb_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","هەموو قاپوقاچاغی قوربانگاکەشیان دروستکرد، تەشت و خاکەناز و تاس و چەنگاڵ و مەقەڵییەکان، هەموو قاپوقاچاغەکەیان لە بڕۆنز دروستکرد. ");
INSERT INTO ckb_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","کەتیبەیەکیشیان بۆ قوربانگاکە دروستکرد، وەک تۆڕێکی بڕۆنز، لەژێر لێوارەکە دایاننا، لە خوارەوە هەتا ناوەڕاست. ");
INSERT INTO ckb_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","چوار ئەڵقەشیان لە هەر چوار لای کەتیبە بڕۆنزییەکە داڕشت، وەک گیرە بۆ دوو دار. ");
INSERT INTO ckb_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","دوو دارەکەشیان لە داری ئەکاسیا دروستکرد و بە بڕۆنز ڕووکەشیان کردن. ");
INSERT INTO ckb_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","دوو دارەکەیان خستە ناو ئەڵقەکانەوە، لە هەردوو لای قوربانگاکەوە، بۆ ئەوەی بەوان هەڵیبگرن، قوربانگاکەشیان لە تەختە دروستکرد و ناوەکەی بۆش بوو. ");
INSERT INTO ckb_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","حەوزەکەشیان لە بڕۆنز دروستکرد و ژێرەکەشی لە بڕۆنز بوو، لە ئاوێنە بڕۆنزییەکانی ئەو ئافرەتە خزمەتکارانەی لەلای دەروازەکەی چادری چاوپێکەوتن خزمەتیان دەکرد. ");
INSERT INTO ckb_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","حەوشەی چادرەکەی پەرستنیشیان لەلای باشوور دروستکرد، پەردەکانی حەوشەکەش لە کەتانی ڕستراو بوون بە درێژی سەد باڵ. ");
INSERT INTO ckb_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","کۆڵەکەکانیشی بیست دانە و بیست بنکەی بڕۆنزیشی هەبوو. قولاپی کۆڵەکەکان و ئەڵقەکانیشی لە زیو بوون. ");
INSERT INTO ckb_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","بەلای باکووریش سەد باڵ، کۆڵەکەکانیشی بیست دانە و بیست بنکەی بڕۆنزیشی هەبوو. قولاپی کۆڵەکەکان و ئەڵقەکانیشی لە زیو بوون. ");
INSERT INTO ckb_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","بەلای ڕۆژئاواش پەردەکان پەنجا باڵ بوون، کۆڵەکەکانیش دە دانە و بنکەکانیش دە، قولاپی کۆڵەکەکان و ئەڵقەکانی لە زیو بوون. ");
INSERT INTO ckb_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","لەلای ڕۆژهەڵاتیش ڕووەو خۆر هەڵات پەنجا باڵ. ");
INSERT INTO ckb_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","چەند پەردەیەکیش بۆ لایەکی جێگای چوونە ژوورەوەی حەوشەکە بە درێژی پازدە باڵ، کۆڵەکەکانی سێ و بنکەکانیش سێ بوون. ");
INSERT INTO ckb_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","بۆ لایەکەی دیکەی چوونە ژوورەوەی حەوشەکەش چەند پەردەیەک بە درێژایی پازدە باڵ، کۆڵەکەکانی سێ و بنکەکانیشی سێ بوون. ");
INSERT INTO ckb_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","هەموو پەردەکانی حەوشەکەش بە چواردەوریدا لە کەتانی ڕستراو بوون. ");
INSERT INTO ckb_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","هەموو بنکەکانی کۆڵەکەکانیش لە بڕۆنز بوون، قولاپی کۆڵەکە و ئەڵقەکانیان لە زیو بوون، سەرەکانیان بە زیو ڕووکەش کرابوون، هەموو کۆڵەکەکانی حەوشەکە بە ئەڵقەی زیو پێکەوە بەسترابوون. ");
INSERT INTO ckb_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","پەردەی دەروازەش بۆ دەرگای حەوشەکە، لە ڕیسی مۆر و ئەرخەوانی و سووری ئاڵ و کەتانی ڕستراو بە دەستکردی جۆڵایەک چنرابوو، درێژییەکەی بیست باڵ و بەرزییەکەی بە پانی پێنج باڵ هەروەک پەردەکانی حەوشەکە. ");
INSERT INTO ckb_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","کۆڵەکەکانیشی چوار و بنکەکانیشی چوار بوون کە ئەوانیش لە بڕۆنز بوون، قولاپەکانی لە زیو بوون، سەرەکانی ڕووکەش کرابوون، ئەڵقەکانی لە زیو بوون. ");
INSERT INTO ckb_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","هەموو سنگەکانی چادرەکەی پەرستن و حەوشەکە بە چواردەوریدا لە بڕۆنز بوون. ");
INSERT INTO ckb_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","ئەمەش بڕی کانزاکانی چادرەکەی پەرستنە، چادری پەیمان، بەپێی فەرمانی موسا لەلایەن لێڤییەکان تۆمارکرا، بە سەرپەرشتی ئیتاماری کوڕی هارونی کاهین. ");
INSERT INTO ckb_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","بەسەلئێلی کوڕی ئوری کوڕی حووریش کە لە هۆزی یەهودایە، هەموو ئەو شتانەی یەزدان فەرمانی بە موسا کرد جێبەجێی کرد، ");
INSERT INTO ckb_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","ئۆهۆلیئابی کوڕی ئەحیساماکی لەگەڵ بوو کە لە هۆزی دانە، نەخشێنەر و داهێنەر و جۆڵا لە ڕیسی مۆر و ئەرخەوانی و سووری ئاڵ و کەتانی ناسک. ");
INSERT INTO ckb_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","هەموو ئەو زێڕەی بەکارهێنرا بۆ هەموو کارەکانی پیرۆزگا، زێڕی بەخشراو بوو وەک قوربانی بەرزکردنەوە، بیست و نۆ تالنت و حەوت سەد و سی شاقل بە شاقلی پیرۆزگا. ");
INSERT INTO ckb_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","زیوی سەرژمێرکراوەکانی کۆمەڵەکەش، سەد تالنت و هەزار و حەوت سەد و حەفتا و پێنج شاقل بە شاقلی پیرۆزگا. ");
INSERT INTO ckb_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","نیوە بۆ هەر سەرێک، نیو شاقل بە شاقلی پیرۆزگا بۆ هەرکەسێک لە گەنجی بیست ساڵ بەرەو سەرەوە سەرژمێر کرابێت، بۆ شەش سەد و سێ هەزار و پێنج سەد و پەنجا کەس. ");
INSERT INTO ckb_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","سەد تالنتیش لە زیوەکە بۆ داڕشتنی بنکەکانی پیرۆزگا و بنکەکانی پەردەکە بەکارهات، سەد بنکە بۆ سەد کێش، کێشێک بۆ بنکەیەک. ");
INSERT INTO ckb_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","هەزار و حەوت سەد و حەفتا و پێنج شاقلەکەش قولاپی لێ دروستکرا و سەری کۆڵەکەکانی پێ ڕووکەش کرا، هەروەها ئەڵقەی پێکەوە بەستنی لێ دروستکرا. ");
INSERT INTO ckb_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","بڕۆنزە بەخشراوەکەش وەک قوربانی بەرزکردنەوە، حەفتا تالنت و دوو هەزار و چوار سەد شاقل بوو، ");
INSERT INTO ckb_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","بەویش بنکەکانی دەروازەی چادری چاوپێکەوتن و قوربانگا بڕۆنزییەکە و کەتیبە بڕۆنزییەکەی و هەموو قاپوقاچاغەکانی قوربانگاکە دروستکران، ");
INSERT INTO ckb_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","هەروەها بنکەکانی حەوشەکە بە چواردەوریدا و بنکەکانی دەروازەی حەوشەکە و هەموو سنگەکانی چادرەکەی پەرستن و هەموو سنگەکانی حەوشەکە بە چواردەوریدا. ");
INSERT INTO ckb_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","لە ڕیسی مۆر و ئەرخەوانی و سووری ئاڵ جلوبەرگی چنراویان دروستکرد بۆ خزمەت لە پیرۆزگا، جلوبەرگە پیرۆزەکەشیان بۆ هارون دروستکرد، هەروەک یەزدان فەرمانی بە موسا کرد. ");
INSERT INTO ckb_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","ئێفۆدەکەیان لە زێڕ و ڕیسی مۆر و ئەرخەوانی و سووری ئاڵ و کەتانی ڕستراو دروستکرد. ");
INSERT INTO ckb_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","پارچە زێڕیشیان کوتی هەتا باریکیان کردەوە و وەک داو بڕییان بۆ ئەوەی لەناو ڕیسی مۆر و ئەرخەوانی و سووری ئاڵ و کەتانی ناسک بە دەستکردی داهێنەر بەکاریبهێنن. ");
INSERT INTO ckb_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","دوو شانی لە یەک بەستراویشیان بۆ دروستکرد، بە هەردوو لایەوە بەسترابوون. ");
INSERT INTO ckb_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","پشتبەستی ئێفۆدەکە کە لەسەریەتی، لە هەمان پارچە و هەمان دەستکرد بوو، لە زێڕ و ڕیسی مۆر و ئەرخەوانی و سووری ئاڵ و کەتانی ڕستراو بوو، هەروەک یەزدان فەرمانی بە موسا کرد. ");
INSERT INTO ckb_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","دوو بەردی عاشقبەندیشیان چەسپ کرد، دەوردراو بە چوارچێوەی زێڕین، نەخشێنراو وەک نەخشی ئەنگوستیلە بەپێی ناوی کوڕەکانی ئیسرائیل. ");
INSERT INTO ckb_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","دوو بەردەکەشیان خستە سەر دوو شانی ئێفۆدەکە، دوو بەردی یادگاری بۆ نەوەی ئیسرائیل، هەروەک یەزدان فەرمانی بە موسا کرد. ");
INSERT INTO ckb_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","بەرسینەکەشیان وەک دەستکردی ئێفۆدەکە بە دەستی وەستای کارامە دروستکرد، لە زێڕ و ڕیسی مۆر و ئەرخەوانی و سووری ئاڵ و کەتانی ڕستراو. ");
INSERT INTO ckb_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","بەرسینەکەیان چوارگۆشە و دووبەر دروستکرد، درێژییەکەی بستێک و پانییەکەی بستێک. ");
INSERT INTO ckb_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","بە چوار ڕیز بەرد ڕازاندیانەوە، لە ڕیزی یەکەم یاقووت لەگەڵ یاقووتی زەرد و زمروودی سەوز؛ ");
INSERT INTO ckb_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","ڕیزی دووەم بەردە پیرۆزە و یاقووتی شین و زمروود؛ ");
INSERT INTO ckb_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","ڕیزی سێیەم یاقووتی زەعفەرانی و کریستاڵی هەورین و جەمشت؛ ");
INSERT INTO ckb_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","ڕیزی چوارەمیش زەبەرجەد و بەردی عاشقبەند و یەشب. بە چوارچێوەی زێڕینیش ڕازاندبوویانەوە. ");
INSERT INTO ckb_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","بەردەکانیش دوازدە بوون وەک ناوی کوڕەکانی ئیسرائیل بەپێی ناوەکانیان، وەک نەخشی ئەنگوستیلە هەریەکە بەپێی ناوەکەی بوو بۆ دوازدە هۆز. ");
INSERT INTO ckb_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","بۆ بەرسینەکەش زنجیرەی هۆنراوەیان لە زێڕی بێگەرد دروستکرد، وەک گوریس. ");
INSERT INTO ckb_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","دوو چوارچێوەی زێڕین و دوو ئەڵقەی زێڕینیشیان دروستکرد، ئەڵقەکانیان لەسەر هەردوو لای بەرسینەکە دانا. ");
INSERT INTO ckb_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","دوو زنجیرە زێڕینەکەشیان خستە ناو دوو ئەڵقەکەی سەر هەردوو لای بەرسینەکە. ");
INSERT INTO ckb_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","هەردوو سەرەکەی دیکەی دوو زنجیرەکەشیان خستە ناو دوو چوارچێوەکە و لەسەر شانەکانی ئێفۆدەکەیان دانا بۆ پێشەوەی. ");
INSERT INTO ckb_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","دوو ئەڵقەی زێڕینیشیان دروستکرد و لەسەر هەردوو لای بەرسینەکەیان دانا، لەسەر لێوارەکەی کە بە دیوی ئێفۆدەکەیە بۆ ژوورەوە. ");
INSERT INTO ckb_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","دوو ئەڵقەی زێڕینیشیان دروستکرد و لەسەر هەردوو شانی ئێفۆدەکە دایاننان، لە خوارەوە بە دیوی ڕووەکەی، لە نزیک بەیەکبەستنەوەکەی لە سەرووی پشتبەستی ئێفۆدەکە. ");
INSERT INTO ckb_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","بەرسینەکەشیان بە دوو ئەڵقەکەیەوە لە دوو ئەڵقەی ئێفۆدەکە بەست، بە داوێک لە ڕیسی مۆر، بۆ ئەوەی لەسەر پشتبەستی ئێفۆدەکە بێت تاوەکو بەرسینەکەش لە ئێفۆدەکە نەکرێتەوە، هەروەک یەزدان فەرمانی بە موسا کرد. ");
INSERT INTO ckb_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","کەوای ئێفۆدەکەش دەستکردی چنراو بوو، هەموویان لە ڕیسی مۆر دروستکرد. ");
INSERT INTO ckb_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","کونی سەریشی لە ناوەڕاستی کەواکەدا بوو وەک کونی یەخەی کراس، بەنێکیش بە دەوروپشتی کونەکەدا بۆ ئەوەی نەدڕێت. ");
INSERT INTO ckb_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","لەسەر دامێنی کەواکەش گوڵینگی مۆر و ئەرخەوانی و سووری ئاڵ و کەتانی ڕستراویان دروستکرد، ");
INSERT INTO ckb_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","زەنگوڵەشیان لە زێڕی بێگەرد دروستکرد. زەنگوڵەکانیان خستە نێوان گوڵینگەکانی سەر دامێنی کەواکە. ");
INSERT INTO ckb_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","لەنێو هەردوو گوڵینگێک زەنگوڵەیەک لەسەر دامێنی کەواکە بە دەوریدا بوو کە بۆ خزمەتکردن لەبەر دەکرێت، هەروەک یەزدان فەرمانی بە موسا کرد. ");
INSERT INTO ckb_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","هەروەها کراسیان لە کەتانی ناسک بۆ هارون و کوڕەکانی دروستکرد، بە دەستکردی چنراو. ");
INSERT INTO ckb_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","مێزەرەکەش لە کەتانی ناسک بوو، گوڵینگەکانی سەرپێچەکانیش لە کەتان ناسک، دەرپێکانیشیان لە کەتانی ناسکی ڕستراو بوون. ");
INSERT INTO ckb_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","کەمەربەندەکەش لە کەتانی ڕستراو و ڕیسی مۆر و ئەرخەوانی و سووری ئاڵ بە دەستکردی جۆڵا چنرابوو، هەروەک یەزدان فەرمانی بە موسا کرد. ");
INSERT INTO ckb_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","پلێتی تاجەگوڵینە پیرۆزەکەشیان لە زێڕی بێگەرد دروستکرد و وەک نەخشی ئەنگوستیلە لەسەری هەڵیانکەند: «پیرۆزی بۆ یەزدان.» ");
INSERT INTO ckb_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","هەروەها خستیانە سەر داوێکی مۆر بۆ ئەوەی لەسەر مێزەرەکە دابنرێت، هەروەک یەزدان فەرمانی بە موسا کرد. ");
INSERT INTO ckb_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","ئیتر هەموو کاری چادری پەرستن کە چادری چاوپێکەوتنە تەواو بوو، نەوەی ئیسرائیل بەو شێوەیەیان کرد کە یەزدان فەرمانی بە موسا کردبوو. ");
INSERT INTO ckb_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","ئینجا چادرەکەی پەرستنیان هێنایە لای موسا کە پێکهاتبوو لە: چادرەکە و هەموو کەلوپەلەکانی و فاق و چوارچێوە و کاریتە و کۆڵەکە و بنکەکانی؛ ");
INSERT INTO ckb_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","پۆشەرێک لە پێستی بەران کە بە ڕەنگی سوور ڕەنگکرابوو و پۆشەرێکی دیکە لە پێستی مانگای دەریا، لەگەڵ پەردەکەی شوێنی هەرەپیرۆز؛ ");
INSERT INTO ckb_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","سندوقی پەیمان و دارەکانی و قەپاغی کەفارەت؛ ");
INSERT INTO ckb_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","مێزەکە و هەموو قاپوقاچاغەکانی و نانی تەرخانکراو بۆ خودا؛ ");
INSERT INTO ckb_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","چرادانەکەش کە لە زێڕی بێگەرد بوو لەگەڵ چراکانی کە لەسەری بوون و هەموو قاپوقاچاغەکانی و زەیت بۆ ڕووناکی؛ ");
INSERT INTO ckb_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","قوربانگا زێڕینەکە و زەیتی دەستنیشانکردن و بخووری بۆنخۆش و پەردەی دەروازەی چادرەکە؛ ");
INSERT INTO ckb_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","قوربانگا بڕۆنزییەکە و کەتیبە بڕۆنزییەکەی، دوو دارەکەی و هەموو قاپوقاچاغەکەی و حەوزەکە و ژێرەکەی؛ ");
INSERT INTO ckb_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","پەردەکانی حەوشە و کۆڵەکە و بنکەکانی و پەردەی دەروازەی حەوشەکە و گوریس و سنگەکانی و هەموو کەلوپەلی خزمەتی چادری پەرستن کە چادری چاوپێکەوتنە؛ ");
INSERT INTO ckb_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","جلوبەرگە چنراوەکانی خزمەتکردن لە پیرۆزگا، جلوبەرگە پیرۆزەکەی هارونی کاهین و جلوبەرگی کوڕەکانی بۆ کاهینیێتی. ");
INSERT INTO ckb_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","وەک هەموو ئەوەی یەزدان فەرمانی بە موسا کرد، نەوەی ئیسرائیل ئاوا هەموو کارەکەیان کرد. ");
INSERT INTO ckb_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","موسا تەماشای هەموو کارەکەی کرد و بینی وا وەک ئەوەی یەزدان فەرمانی دا ئاوایان کردووە، ئیتر موسا داوای بەرەکەتی بۆ کردن. ");
INSERT INTO ckb_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","«لە یەکی مانگی یەکەم، چادری پەرستن کە چادری چاوپێکەوتنە هەڵبدە. ");
INSERT INTO ckb_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","سندوقی پەیمانی تێدا دابنێ، سندوقەکە بە پەردەکە داپۆشە. ");
INSERT INTO ckb_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","مێزەکەش ببە ژوورەوە و بە جوانی ڕێکی بخە، هەروەها چرادانەکەش ببە ژوورەوە و چراکانی بەرز بکەوە. ");
INSERT INTO ckb_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","قوربانگا زێڕینەکەش کە بۆ بخوورە لەبەردەم سندوقی پەیمان دایبنێ، پەردەی دەروازە بۆ چادرەکەی پەرستن دابنێ. ");
INSERT INTO ckb_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","«قوربانگاکەی قوربانی سووتاندنیش لەبەردەم دەروازەی چادری چاوپێکەوتن دابنێ لەناو چادری پەرستن. ");
INSERT INTO ckb_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","حەوزەکەش لەنێوان چادری چاوپێکەوتن و قوربانگاکە دابنێ و ئاوی تێبکە. ");
INSERT INTO ckb_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","حەوشەکە لە چواردەوری دابنێ و پەردەی دەروازەی حەوشەکەش دابنێ. ");
INSERT INTO ckb_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","«زەیتی دەستنیشانکردنەکە ببە و چادرەکەی پەرستن و هەموو ئەوەی تێیدایە پێی دەستنیشان بکە، خۆی و هەموو کەلوپەلەکانی تەرخان بکە و پیرۆز دەبێت. ");
INSERT INTO ckb_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","پاشان قوربانگاکەی قوربانی سووتاندن و هەموو قاپوقاچاغەکەی دەستنیشان بکە، قوربانگاکە تەرخان بکە و دەبێتە هەرەپیرۆز. ");
INSERT INTO ckb_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","حەوزەکەش لەگەڵ ژێرەکەی دەستنیشان بکە و تەرخانی بکە. ");
INSERT INTO ckb_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","«هارون و کوڕەکانیشی بهێنە پێشەوە بۆ دەروازەی چادری چاوپێکەوتن و بە ئاو بیانشۆ. ");
INSERT INTO ckb_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","ئینجا جلوبەرگە پیرۆزەکە لەبەر هارون بکە، دەستنیشانی بکە و تەرخانی بکە بۆ ئەوەی کاهینیێتیم بۆ بکات. ");
INSERT INTO ckb_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","کوڕەکانیشی بهێنە پێشەوە و کراسەکانیان لەبەر بکە، ");
INSERT INTO ckb_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","دەستنیشانیان بکە هەروەک چۆن باوکیانت دەستنیشان کرد بۆ ئەوەی کاهینیێتیم بۆ بکەن، ئەمەش بۆ ئەوە دەبێت هەتا دەستنیشانکردنەکەیان بۆیان ببێتە کاهینیێتی هەتاهەتایی لە نەوەکانیان.» ");
INSERT INTO ckb_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","موساش بەم جۆرەی کرد هەروەک هەموو ئەوەی یەزدان فەرمانی پێ کرد، ئاوای کرد. ");
INSERT INTO ckb_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","لە یەکی مانگی یەکەمینی ساڵی دووەم چادرەکەی پەرستن هەڵدرا. ");
INSERT INTO ckb_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","موسا چادرەکەی پەرستنی هەڵدا، بنکەکانی دانا و چوارچێوەکانی دانا، کاریتەکانی دانا و کۆڵەکەکانی ڕاگرت. ");
INSERT INTO ckb_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","ڕەشماڵەکەی بەسەر چادری پەرستندا هەڵدا و لە سەرەوە پۆشەری چادرەکەی بەسەریدا دا، هەروەک یەزدان فەرمانی پێ کرد. ");
INSERT INTO ckb_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","تەختەکانی پەیمانی برد و خستییە ناو سندوقەکە، دارەکانی خستە سەر سندوقەکە و قەپاغی کەفارەتی لەسەر سندوقەکە دانا. ");
INSERT INTO ckb_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","ئینجا سندوقەکەی هێنایە ناو چادرەکەی پەرستن و پەردەکەی شوێنی هەرەپیرۆزی دانا و سندوقی پەیمانی داپۆشی، هەروەک یەزدان فەرمانی بە موسا کرد. ");
INSERT INTO ckb_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","مێزەکەی لەناو چادری چاوپێکەوتن دانا، لەلای باکووری چادرەکەی پەرستن لە دەرەوەی پەردەکە. ");
INSERT INTO ckb_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","نانی بەردەم یەزدانیشی بە ڕێکی لەسەری ڕێکخست، هەروەک یەزدان فەرمانی بە موسا کرد. ");
INSERT INTO ckb_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","چرادانەکەشی لەناو چادری چاوپێکەوتن دانا لە بەرامبەر مێزەکە لەلای باشووری چادرەکەی پەرستن. ");
INSERT INTO ckb_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","چراکانی بەرزکردەوە بۆ بەردەم یەزدان، هەروەک یەزدان فەرمانی بە موسا کرد. ");
INSERT INTO ckb_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","قوربانگا زێڕینەکەشی لەناو چادری چاوپێکەوتن لەبەردەم پەردەکە دانا و ");
INSERT INTO ckb_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","بخووری بۆنخۆشی لەسەر سووتاند، هەروەک یەزدان فەرمانی بە موسا کرد. ");
INSERT INTO ckb_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","پەردەی دەروازەشی بۆ چادرەکەی پەرستن دانا. ");
INSERT INTO ckb_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","قوربانگاکەی قوربانی سووتاندنیشی لەلای دەرگای چادری چاوپێکەوتن دانا، کە دەکاتە چادری پەرستن، قوربانی سووتاندن و پێشکەشکراوی دانەوێڵەی سەرخستە سەری، هەروەک یەزدان فەرمانی بە موسا کرد. ");
INSERT INTO ckb_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","حەوزەکەشی لەنێوان چادری چاوپێکەوتن و قوربانگاکەدا دانا و ئاوی تێکرد بۆ شوشتن، ");
INSERT INTO ckb_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","بۆ ئەوەی موسا و هارون و کوڕەکانی دەست و پێیانی لێ بشۆن. ");
INSERT INTO ckb_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","لە کاتی چوونە ژوورەوەیان بۆ ناو چادری چاوپێکەوتن و لە نزیکبوونەوەیان لە قوربانگاکە دەیشۆن، هەروەک یەزدان فەرمانی بە موسا کرد. ");
INSERT INTO ckb_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","حەوشەکەشی لە دەوری چادرەکەی پەرستن و قوربانگاکە دامەزراند و پەردەی دەروازەی حەوشەکەی دانا. ئیتر موسا کارەکەی تەواو کرد. ");
INSERT INTO ckb_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","ئینجا هەورێک چادری چاوپێکەوتنی داپۆشی و شکۆمەندی یەزدان چادرەکەی پەرستنی پڕکرد. ");
INSERT INTO ckb_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","لەبەر ئەوە موسا نەیتوانی بچێتە ژوورەوە بۆ ناو چادری چاوپێکەوتن، چونکە هەور هاتە سەری و شکۆمەندی یەزدان چادرەکەی پەرستنی پڕکرد. ");
INSERT INTO ckb_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","بە درێژایی ماوەی کۆچەکەیان، هەر کاتێک هەورەکە لەسەر چادرەکە بەرز دەبووەوە، نەوەی ئیسرائیل بەڕێ دەکەوتن. ");
INSERT INTO ckb_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","بەڵام ئەگەر هەورەکە بەرزنەبووایەوە، کۆچیان نەدەکرد هەتا ڕۆژی بەرزبوونەوەی، ");
INSERT INTO ckb_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","چونکە هەوری یەزدان بە ڕۆژ لەسەر چادرەکەی پەرستن بوو، بە شەویش ئاگری تێدابوو، لەبەرچاوی هەموو بنەماڵەی ئیسرائیل لە هەموو کۆچەکانیان.");
INSERT INTO ckb_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","یەزدان موسای بانگکرد و لە چادری چاوپێکەوتن قسەی لەگەڵ کرد و فەرمووی: ");
INSERT INTO ckb_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","«لەگەڵ نەوەی ئیسرائیل بدوێ و پێیان بڵێ: ”کاتێک یەکێک لە ئێوە قوربانییەکی لە ئاژەڵ بۆ یەزدان پێشکەش کرد، لە گاگەل و لە مێگەل قوربانییەکانتان پێشکەش بکەن. ");
INSERT INTO ckb_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","«”ئەگەر قوربانییەکەی قوربانی سووتاندن لە گاگەل بێت، ئەوا نێری ساغ پێشکەش دەکات و دەیهێنێتە لای دەروازەی چادری چاوپێکەوتن، بۆ ئەوەی مایەی ڕەزامەندی یەزدان بێت، ");
INSERT INTO ckb_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","دەستی لەسەر سەری قوربانی سووتاندنەکە دادەنێت و بۆ کەفارەتی لێی وەردەگیرێت. ");
INSERT INTO ckb_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","جوانەگاکەش لەبەردەم یەزدان سەردەبڕێت، نەوەی هارون کە کاهینەکانن، خوێنەکە دەهێنن و بەسەر هەموو لایەکی ئەو قوربانگایەدا دەیپرژێنن کە لەلای دەروازەکەی چادری چاوپێکەوتنە. ");
INSERT INTO ckb_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","قوربانی سووتاندنەکە کەوڵ دەکات و پارچەپارچەی دەکات، ");
INSERT INTO ckb_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","نەوەی هارونی کاهین ئاگرێک لەسەر قوربانگاکە دەکەنەوە و دار لەسەر ئاگرەکە ڕێک دەخەن. ");
INSERT INTO ckb_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","نەوەی هارونیش کە کاهینەکانن پارچەکانی لەگەڵ سەرەکەی و ئەو پیوەی لەسەر دارەکانی سەر ئاگری سەر قوربانگاکەیە ڕێکی دەخەن. ");
INSERT INTO ckb_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","هەناو و قاچەکانی بە ئاو دەشۆن و کاهینەکە هەموویان لەسەر قوربانگاکە دەسووتێنێت. قوربانی سووتاندنە، قوربانی بە ئاگرە، ئەو بۆنەی یەزدان پێی خۆشە. ");
INSERT INTO ckb_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","«”ئەگەر قوربانییەکەی لە ماڵات بوو، بەران یان گیسک، قوربانی سووتاندن بوو، ئەوا نێر و ساغ پێشکەش دەکات. ");
INSERT INTO ckb_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","لەلای قوربانگاکە ئەوەی بەلای باکوورە لەبەردەم یەزدان سەری دەبڕێت. نەوەی هارونیش کە کاهینەکانن خوێنەکەی بەسەر هەموو لایەکی قوربانگاکەدا دەپرژێنن. ");
INSERT INTO ckb_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","پارچەپارچەی دەکات و لەگەڵ سەرەکەی و پیوەکەی، کاهینەکەش لەسەر دارەکانی سەر ئاگری سەر قوربانگاکە ڕێکی دەخات. ");
INSERT INTO ckb_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","هەناو و قاچەکانی بە ئاو دەشوات و کاهینەکە هەموویان پێشکەش دەکات و لەسەر قوربانگاکە ئاگریان تێبەردەدات. ئەوەش قوربانی سووتاندنە، قوربانی بە ئاگرە، ئەو بۆنەی یەزدان پێی خۆشە. ");
INSERT INTO ckb_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","«”ئەگەر قوربانییەکەشی بۆ یەزدان لە باڵندە بێت و قوربانی سووتاندن بێت، ئەوا قوربانییەکەی لە کوکوختی یان لە بێچووە کۆتر پێشکەش دەکات. ");
INSERT INTO ckb_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","کاهینەکەش بۆ قوربانگاکەی دەهێنێت و سەری دەقرتێنێت، لەسەر قوربانگاکە ئاگر دەکاتەوە، خوێنەکەی لەسەر لێواری قوربانگاکە دەگوشێت. ");
INSERT INTO ckb_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","چیکڵدانەکەی بەوەش کە لەناویەتی لێیدەکاتەوە و فڕێیدەداتە لای ڕۆژهەڵاتی قوربانگاکە بۆ شوێنی خۆڵەمێشەکە. ");
INSERT INTO ckb_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","لەنێوان باڵەکانیەوە کەرتی دەکات، تەواو لێکی ناکاتەوە، ئینجا کاهینەکە لەسەر قوربانگا لەسەر ئەو دارانەی لەسەر ئاگرەکەیە دەیسووتێنێت، قوربانی سووتاندنە، قوربانی بە ئاگرە، ئەو بۆنەی یەزدان پێی خۆشە. ");
INSERT INTO ckb_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","«”ئەگەر یەکێک پێشکەشکراوی دانەوێڵەی بۆ یەزدان هێنا، دەبێت پێشکەشکراوەکەی لە باشترین ئارد بێت و زەیتی بەسەردا دەکات و بخووری سادەشی دەخاتە سەر و ");
INSERT INTO ckb_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","بۆ نەوەی هارون دەیهێنێت کە کاهینەکانن. کاهینەکەش پڕ بە مستی خۆی مستێک لە ئاردەکە و زەیتەکەی لەگەڵ هەموو بخوورەکەی دەبات. کاهینەکە وەک یادەوەری لەسەر قوربانگاکە دەیسووتێنێت، قوربانی بە ئاگرە، ئەو بۆنەی یەزدان پێی خۆشە، ");
INSERT INTO ckb_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","ئەوەی لە دانەوێڵەکەش دەمێنێتەوە بۆ هارون و کوڕەکانییەتی، ئەوە بەشی هەرەپیرۆزە لە قوربانی بە ئاگر بۆ یەزدان. ");
INSERT INTO ckb_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","«”ئەگەر پێشکەشکراوێکی دانەوێڵەی بە تەنوور برژاوت هێنا، دەبێت کولێرەی فەتیرەی بە زەیت شێلراو و ناسکە نانی فەتیرەی بە زەیت چەورکراو بێت. ");
INSERT INTO ckb_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","ئەگەر پێشکەشکراوەکەت دانەوێڵەی سەر ساج بێت، دەبێت لە باشترین ئاردی بە زەیت شێلراوی فەتیرە بێت، ");
INSERT INTO ckb_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","پارچەپارچەی دەکەیت و زەیتی بەسەردا دەکەیت، ئەوە پێشکەشکراوی دانەوێڵەیە. ");
INSERT INTO ckb_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","ئەگەر پێشکەشکراوەکەت دانەوێڵەی ناو تاوە بێت، لە باشترین ئاردی بە زەیت شێلراو دەیکەیت. ");
INSERT INTO ckb_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","پێشکەشکراوی دانەوێڵەکەت لەمانە دروستدەکرێت و بۆ یەزدان دەیهێنیت، دەیدەیتە کاهینەکە و ئەویش بۆ لای قوربانگاکەی دەهێنێت. ");
INSERT INTO ckb_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","کاهینەکەش لە پێشکەشکراوە دانەوێڵەکە بەشی یادەوەرییەکەی دەبات و لەسەر قوربانگاکە دەیسووتێنێت، قوربانی بە ئاگرە، ئەو بۆنەی یەزدان پێی خۆشە. ");
INSERT INTO ckb_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","ئەوەی لە دانەوێڵەکەش دەمێنێتەوە بۆ هارون و کوڕەکانییەتی، ئەوە بەشی هەرەپیرۆزە لە قوربانی بە ئاگر بۆ یەزدان. ");
INSERT INTO ckb_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","«”هەموو ئەو دانەوێڵە پێشکەشکراوانەی بۆ یەزدانی دەبەن، نابێت بە هەویرترش بێت، چونکە هیچ شتێکی بە هەویرترش و هیچ هەنگوینێک وەک قوربانی بە ئاگر بۆ یەزدان نابێت بسووتێنن. ");
INSERT INTO ckb_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","دەتوانن وەک یەکەمین بەرهەمتان پێشکەش بە یەزدانی بکەن، بەڵام لەسەر قوربانگاکە پێشکەش ناکرێت وەک بۆنی خۆشی. ");
INSERT INTO ckb_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","هەموو پێشکەشکراوەکانت لە دانەوێڵە بە خوێ سوێری دەکەیت و با هیچ دانەوێڵەیەکت بەبێ خوێی پەیمانی خودات نەبێت. بۆ هەموو قوربانییەکانت خوێی پێوە دەکەیت. ");
INSERT INTO ckb_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","«”ئەگەر دانەوێڵەت بۆ یەزدان پێشکەش کرد، دانەوێڵەی یەکەمین بەرهەمەکانت پێشکەش دەکەیت، دەبێت گوڵەکەی بێت و برژا بێت، کوتراوە و پاککراوە بێت. ");
INSERT INTO ckb_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","زەیتی بەسەردا دەکەیت و بخووری سادەی لەسەر دادەنێیت، ئەوە پێشکەشکراوی دانەوێڵەیە. ");
INSERT INTO ckb_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","کاهینیش بەشی یادەوەرییەکەی لە کوتراوەکەی و زەیتەکەی و هەموو بخوورەکەی دەسووتێنێت وەک قوربانی بە ئاگر بۆ یەزدان. ");
INSERT INTO ckb_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","«”ئەگەر قوربانییەکەی قوربانی هاوبەشی بوو، لە گاگەل پێشکەشی کرد، نێر یان مێ دەبێت ساغ بێت و بیهێنێتە بەردەم یەزدان. ");
INSERT INTO ckb_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","دەستی لەسەر سەری قوربانییەکەی دادەنێت و لەلای دەروازەی چادری چاوپێکەوتن سەری دەبڕێت. نەوەی هارون کە کاهینەکانن، خوێنەکەی بەسەر هەموو لایەکی قوربانگاکەدا دەپرژێنن. ");
INSERT INTO ckb_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","لە قوربانی هاوبەشیش، بەم جۆرە قوربانی بە ئاگر پێشکەشی یەزدان دەکرێت: هەموو هەناوی و ئەو پیوەی هەناوی داپۆشیوە، ");
INSERT INTO ckb_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","لەگەڵ دوو گورچیلەکە و ئەو پیوەی لەسەریانە، ئەوەی لەسەر ناوقەدە، هەروەها ئەو پیوەی لەسەر جگەر و گورچیلەکانە لێی دەکرێتەوە. ");
INSERT INTO ckb_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","نەوەی هارونیش لەسەر قوربانگاکە دەیسووتێنن، لەسەر ئەو قوربانی سووتاندنەی لەسەر دارەکانی سەر ئاگرەکەیە، قوربانی بە ئاگرە، ئەو بۆنەی یەزدان پێی خۆشە. ");
INSERT INTO ckb_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","«”ئەگەر قوربانییەکەی لە مەڕوماڵات بوو، قوربانی هاوبەشی بۆ یەزدان، نێر یان مێی ساغ پێشکەش دەکات. ");
INSERT INTO ckb_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","ئەگەر قوربانییەکەی بەرخ بوو، لەبەردەم یەزدان پێشکەشی دەکات. ");
INSERT INTO ckb_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","دەستی لەسەر سەری قوربانییەکەی دادەنێت و لەبەردەم چادری چاوپێکەوتن سەری دەبڕێت و نەوەی هارون خوێنەکەی بەسەر هەموو لایەکی قوربانگاکەدا دەپرژێنن. ");
INSERT INTO ckb_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","لە قوربانی هاوبەشییەکەش پیوەکەی وەک قوربانی بە ئاگر بۆ یەزدان پێشکەش دەکرێت. دوگەکەی بە تەواوی لەلای دوا بڕبڕەی پشتەوە لێ دەکاتەوە لەگەڵ ئەو پیوەی هەناوی داپۆشیوە و هەموو ئەو پیوەی بەسەر هەناویەوەیە، ");
INSERT INTO ckb_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","لەگەڵ دوو گورچیلەکە و ئەو پیوەی لەسەریانە، ئەوەی لەسەر ناوقەدە و ئەو پیوەی لەسەر جگەر و گورچیلەکانە لێی دەکاتەوە. ");
INSERT INTO ckb_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","کاهینەکەش وەک خواردن لەسەر قوربانگا دەیانسووتێنێت، قوربانی بە ئاگرە بۆ یەزدان. ");
INSERT INTO ckb_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","«”ئەگەر قوربانییەکەشی گیسک بوو، نێر یان مێ، لەبەردەم یەزدان پێشکەشی دەکات، ");
INSERT INTO ckb_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","دەستی لەسەر سەری دادەنێت و لەبەردەم چادری چاوپێکەوتن سەری دەبڕێت. نەوەی هارون خوێنەکەی بەسەر هەموو لایەکی قوربانگاکەدا دەپرژێنن، ");
INSERT INTO ckb_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","لەوەوە قوربانی بە ئاگرەکەی بۆ یەزدان پێشکەش دەکرێت. ئەو پیوەی هەناوی داپۆشیوە و هەموو ئەو پیوەی لەسەر هەناوەکەیە، ");
INSERT INTO ckb_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","لەگەڵ دوو گورچیلەکە و ئەو پیوەی لەسەریانە، ئەوەی لەسەر ناوقەدە و ئەو پیوەی لەسەر جگەر و گورچیلەکانە لێی دەکاتەوە، ");
INSERT INTO ckb_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","کاهینەکەش وەک خواردن لەسەر قوربانگا دەیانسووتێنێت. قوربانی بە ئاگرە، بۆنی خۆشییە، هەموو پیوەکە هی یەزدانە. ");
INSERT INTO ckb_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","«”ئەمە فەرزێکی هەتاهەتاییە نەوە دوای نەوە لە هەموو نشینگەکانتاندا، نە پیو و نە خوێن مەخۆن.“» ");
INSERT INTO ckb_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","هەروەها یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","«لەگەڵ نەوەی ئیسرائیل بدوێ و بڵێ: ”ئەگەر یەکێک بەبێ ئەنقەست گوناهی کرد لە یەکێک لەو فەرمانانەی یەزدان کە نابێت بکرێت و یەکێکی لەوانە کرد، ئەمە دەبێت: ");
INSERT INTO ckb_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","«”ئەگەر کاهینی دەستنیشانکراو گوناهی کرد و گەلی تووشی تاوان کرد، دەبێت جوانەگایەکی ساغ بۆ یەزدان پێشکەش بکات لەبەر ئەو گوناهەی کە کردوویەتی، قوربانی گوناهە. ");
INSERT INTO ckb_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","جوانەگاکە دەباتە لای دەروازەی چادری چاوپێکەوتن لەبەردەم یەزدان و دەستی لەسەر جوانەگاکە دادەنێت و جوانەگاکە لەبەردەم یەزدان سەردەبڕێت. ");
INSERT INTO ckb_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","ئینجا کاهینە دەستنیشانکراوەکە لە خوێنی جوانەگاکە دەبات و دەیباتە ناو چادری چاوپێکەوتن. ");
INSERT INTO ckb_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","کاهینەکە پەنجەی دەکاتە ناو خوێنەکە و حەوت جار لەبەردەم یەزدان لێی دەپرژێنێت لەلای پەردەی پیرۆزگا. ");
INSERT INTO ckb_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","کاهینەکە هەندێکیش لە خوێنەکە لە قۆچەکانی قوربانگای بخوورە بۆنخۆشەکە دەدات، ئەوەی لە چادری چاوپێکەوتنە لەبەردەم یەزدان، پاشماوەی خوێنی جوانەگاکەش دەڕژێنێتە بنکەی قوربانگای قوربانی سووتاندن کە لەلای دەروازەی چادری چاوپێکەوتنە. ");
INSERT INTO ckb_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","هەموو پیوی جوانەگای قوربانی بۆ گوناهەکە دەردەهێنێت، ئەو پیوەی هەناوی داپۆشیوە و هەموو ئەو پیوەی لەسەر هەناوەکەیە، ");
INSERT INTO ckb_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","لەگەڵ دوو گورچیلەکە و ئەو پیوەی لەسەریانە، ئەوەی لەسەر ناوقەدە و ئەو پیوەی لەسەر جگەر و گورچیلەکانە لێی دەکاتەوە. ");
INSERT INTO ckb_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","هەروەک ئەو پیوەی لە گای قوربانی هاوبەشی دەکرێتەوە و کاهینەکە لەسەر قوربانگاکەی قوربانی سووتاندن دەیانسووتێنێت. ");
INSERT INTO ckb_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","بەڵام پێستی جوانەگاکە و هەموو گۆشتەکەی و سەر و قاچەکەی و هەناوی و ڕیخۆڵەکەی، ");
INSERT INTO ckb_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","هەموو پاشماوەی جوانەگاکە دەباتە دەرەوەی ئۆردوگاکە بۆ شوێنێکی پاک بەپێی ڕێوڕەسم، کە بۆ شوێنی فڕێدانی خۆڵەمێش بێت و لەسەر دار دەیانسووتێنێت، لەسەر شوێنی فڕێدانی خۆڵەمێش دەسووتێنرێ. ");
INSERT INTO ckb_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","«”ئەگەر هەموو کۆمەڵی ئیسرائیل بەبێ ئەنقەست گوناهێکیان کرد و یەکێک لەو شتانەیان کرد کە یەزدان فەرمانی داوە نەکرێت، تەنانەت ئەگەر گوناهەکە لەبەرچاوی ئەنجومەن شاردراوە بوو، ئەوا کاتێک درکیان کرد بەو تاوان و ");
INSERT INTO ckb_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","دواتر گوناهەکە زانرا کە کردوویانە، دەبێت ئەنجومەن جوانەگایەک وەک قوربانی گوناه پێشکەش بکات و دەیهێننە بەردەم چادری چاوپێکەوتن. ");
INSERT INTO ckb_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","پیرانی کۆمەڵەکە لەبەردەم یەزدان دەستیان لەسەر سەری جوانەگاکە دادەنێن و جوانەگاکە لەبەردەم یەزدان سەردەبڕدرێت. ");
INSERT INTO ckb_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","ئینجا کاهینی دەستنیشانکراو لە خوێنی جوانەگاکە دەباتە ناو چادری چاوپێکەوتن، ");
INSERT INTO ckb_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","پەنجەی دەخاتە ناو خوێنەکە و حەوت جار لەلای پەردەکە لەبەردەم یەزدان دەیپرژێنێت. ");
INSERT INTO ckb_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","هەندێک لە خوێنەکە لە قۆچەکانی قوربانگاکە دەدات کە لەبەردەم یەزدانە لە چادری چاوپێکەوتن و پاشماوەی خوێنەکەش لە بنکەی قوربانگاکەی قوربانی سووتاندن دەڕێژێت کە لەلای دەروازەی چادری چاوپێکەوتنە. ");
INSERT INTO ckb_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","هەموو پیوەکەی لێ دەکاتەوە و لەسەر قوربانگاکە دەیسووتێنێت. ");
INSERT INTO ckb_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","چی لە جوانەگای قوربانی گوناه کرد ئاواش لەو جوانەگایە دەکات. کاهینەکە کەفارەتیان بۆ دەکات و لێخۆشبوونیان بۆ دەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","پاشان جوانەگاکە دەباتە دەرەوەی ئۆردوگاکە و دەیسووتێنێت هەروەک جوانەگای یەکەمی سووتاند، ئەوە قوربانی گوناهی کۆمەڵە. ");
INSERT INTO ckb_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","«”ئەگەر دەسەڵاتدارێک گوناهی کرد و بەبێ ئەنقەست یەکێک لەوانەی کرد کە یەزدانی پەروەردگاری فەرمانی داوە نەکرێت و تاوانبار بوو، ");
INSERT INTO ckb_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","پاشان لە گوناهەکەی ئاگادار کرایەوە کە کردوویەتی، دەبێت قوربانییەکەی بهێنێت کە گیسکێکی نێری ساغ بێت. ");
INSERT INTO ckb_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","دەستی لەسەر سەری گیسکەکە دابنێت و سەری ببڕێت لەو شوێنەی کە قوربانی سووتاندنی لێ سەردەبڕدرێت لەبەردەم یەزدان. ئەوە قوربانی گوناهە، ");
INSERT INTO ckb_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","کاهینەکەش بە پەنجەی لە خوێنی قوربانییەکەی گوناه دەبات و لە قۆچەکانی قوربانگاکەی قوربانی سووتاندنی دەدات، پاشماوەی خوێنەکەی دەڕێژێتە بنکەی قوربانگاکەی قوربانی سووتاندن. ");
INSERT INTO ckb_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","هەموو پیوەکەشی لەسەر قوربانگاکە دەسووتێنێت وەک پیوی قوربانی هاوبەشی. کاهینەکە لە گوناهەکەی کەفارەتی بۆ دەکات و لێخۆشبوونی بۆ دەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","«”ئەگەر یەکێک لە کۆمەڵگا بەبێ ئەنقەست گوناهی کرد، بەوەی یەکێک لەوانەی کرد کە یەزدان فەرمانی داوە نەکرێت و تاوانبار بوو، ");
INSERT INTO ckb_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","پاشان لە گوناهەکەی ئاگادار کرایەوە کە کردوویەتی، دەبێت قوربانییەکەی بهێنێت کە بزنێکی ساغ بێت، لەبەر گوناهەکەی کە کردوویەتی. ");
INSERT INTO ckb_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","لە شوێنی قوربانی سووتاندن دەستی لەسەر سەری قوربانییەکەی گوناه دادەنێت و سەری دەبڕێت. ");
INSERT INTO ckb_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","کاهینەکەش بە پەنجەی لە خوێنەکەی دەبات و لەسەر قۆچەکانی قوربانگاکەی قوربانی سووتاندنی دەدات، پاشماوەی خوێنەکەشی دەڕێژێتە بنکەی قوربانگاکە. ");
INSERT INTO ckb_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","هەموو پیوەکەشی لێ دەکاتەوە، وەک چۆن ئەو پیوەی لە قوربانی هاوبەشی کردەوە و کاهینەکە لەسەر قوربانگاکە دەیسووتێنێت. ئەو بۆنەی یەزدان پێی خۆشە. کاهینەکە کەفارەتی بۆ دەکات و لێخۆشبوونی بۆ دەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","«”ئەگەر قوربانییەکەی بەرخ بوو بۆ قوربانی گوناه، دەبێت مێینە و ساغ بێت. ");
INSERT INTO ckb_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","دەستی لەسەر سەری قوربانییەکەی گوناه دادەنێت و وەک قوربانی گوناه سەری دەبڕێت، لەو شوێنەی قوربانی سووتاندنی تێدا سەردەبڕدرێت. ");
INSERT INTO ckb_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","کاهینەکە بە پەنجەی لە خوێنی قوربانییەکەی گوناه دەبات و لەسەری قۆچەکانی قوربانگاکەی قوربانی سووتاندنی دەدات و هەموو خوێنەکەش دەڕێژێتە بنکەی قوربانگاکە. ");
INSERT INTO ckb_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","هەموو پیوەکەشی لێ دەکاتەوە هەروەک ئەو پیوەی لە بەرخی قوربانی هاوبەشی دەکرێتەوە، کاهینەکە لەسەر قوربانگاکە لەسەر قوربانییە بە ئاگرەکانی بۆ یەزدان دەیسووتێنێت. بەم شێوەیە کاهینەکە کەفارەتی بۆ دەکات لە گوناهەکەی کە کردوویەتی و لێخۆشبوونی بۆ دەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","«”کاتێک کەسێک گوێی لە بانگەوازی ئاشکرا دەبێت بۆ شایەتیدان کە شایەتی بدات، بێدەنگ بوو لەوەی بینیبووی یان زانیبووی، ئەوا ئەو کەسە گوناهی کردووە و تاوانی خۆی لە ئەستۆ دەگرێت. ");
INSERT INTO ckb_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","«”یان ئەگەر یەکێک بەر شتێکی گڵاو کەوت، وەک کەلاکی ئاژەڵێکی کێوی گڵاو یان کەلاکی ئاژەڵێکی ماڵی گڵاو یان کەلاکی خشۆکێکی گڵاو، ئەگەر ئاگای لێ نەبوو و پاشان زانی، ئەوا تاوانبارە. ");
INSERT INTO ckb_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","یان ئەگەر دەستی لە شتە گڵاوەکانی کەسێک دا لە هەموو گڵاوییەکانی کە پێی گڵاو دەبێت، ئاگای لێ نەبوو و پاشان زانی، ئەوا تاوانبارە. ");
INSERT INTO ckb_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","یان یەکێک هەڵەشە بوو لە سوێندخواردن، بۆ خراپە یان چاکە، لە هەموو ئەوەی مرۆڤ لە کاتی سوێندخواردن پەلەی لێ دەکات، بێ ئەوەی بزانێت و پاشان زانی، ئەوا ئەو کەسە لەو شتە تاوانبارە. ");
INSERT INTO ckb_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","ئەگەر یەکێک تاوانبار بوو بە شکاندنی بڕگەیەکی ئەو یاسایانەی کە ئاماژەی پێکرا، ئەوا دان بە گوناهەکەی دەنێت و ");
INSERT INTO ckb_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","بە قوربانییەکەیەوە کە مێ بێت، بەرخ یان گیسک، بۆ تاوانەکەی دێتە لای یەزدان لەبەر ئەو گوناهەی کە کردوویەتی، قوربانی گوناه، کاهینەکەش کەفارەت بۆ گوناهەکەی دەکات. ");
INSERT INTO ckb_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","«”ئەگەر دەستکورت بوو بۆ بەرخێک، با دوو کوکوختی یان دوو بێچووە کۆتر وەک قوربانی بۆ یەزدان بهێنێت لەبەر تاوانەکەی کە گوناهی پێکردووە، یەکێکیان قوربانی گوناهە و ئەوەی دیکە قوربانی سووتاندن. ");
INSERT INTO ckb_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","دەیانهێنێت بۆ کاهینەکە و ئەویش یەکەم جار ئەوەی بۆ گوناهە پێشکەشی دەکات، سەری لەلای پشتەوە دەقرتێنێت بەڵام بە تەواوی لێی ناکاتەوە. ");
INSERT INTO ckb_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","لە خوێنی قوربانی گوناهەکە بە لاتەنیشتی قوربانگاکەدا دەکات، ئەوەشی لە خوێنەکە دەمێنێتەوە، دەگوشرێتە بنکەی قوربانگاکە، ئەوە قوربانی گوناهە. ");
INSERT INTO ckb_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","ئەوەی دیکە بەپێی ڕێوڕەسم دەکاتە قوربانی سووتاندن، ئینجا کاهینەکە کەفارەتی بۆ دەکات لە گوناهەکەی کە کردوویەتی و لێخۆشبوونی بۆ دەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","«”ئەگەر دەستکورت بوو دوو کوکوختی یان دوو بێچووە کۆتر بهێنێت، قوربانییەکەی لەبەر ئەو گوناهەی کە کردوویەتی دەیەکی ئێفەیەک لە باشترین ئارد دەبێتە قوربانی گوناه. زەیتی بەسەردا ناکات و بخووری سادەی لەسەر دانانێت، چونکە قوربانی گوناهە. ");
INSERT INTO ckb_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","دەیهێنێتە لای کاهینەکە و ئەویش پڕ بە مستی لێی دەبات، بەشی یادەوەرییەکەی و لەسەر قوربانگاکە لەسەر قوربانییە بە ئاگرەکانی بۆ یەزدان دەیسووتێنێت، ئەوە قوربانی گوناهە. ");
INSERT INTO ckb_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","بەم شێوەیە کاهینەکە کەفارەتی بۆ دەکات لە گوناهەکەی کە کردوویەتی لە هەر یەکێک لەوانە و لێخۆشبوونی بۆ دەبێت، ئەوەی دەشمێنێتەوە بۆ کاهینەکە دەبێت، وەک چۆن پاشماوەی پێشکەشکراوی دانەوێڵە بە کاهینەکە دەدرێت.“» ");
INSERT INTO ckb_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","هەروەها یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","«ئەگەر یەکێک سەرپێچییەکی کرد و سەبارەت بە شتە پیرۆزکراوەکانی یەزدان بەبێ ئەنقەست گوناهی کرد، دەبێت لەبەر تاوانەکەی قوربانییەک بۆ یەزدان بهێنێت، بەرانێکی ساغی مێگەل بێت و بەو نرخەی بۆی دادەنێیت بە شاقلی زیو بەپێی شاقلی پیرۆزگا، ئەوە قوربانی تاوانە. ");
INSERT INTO ckb_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","هەروەها قەرەبووی ئەو گوناهەش دەکاتەوە کە سەبارەت بە شتە پیرۆزکراوەکان کردوویەتی و پێنج یەکیشی لەسەر دادەنێت و دەیداتە کاهینەکە. کاهینەکە بە بەرانەکەی قوربانی تاوان کەفارەتی بۆ دەکات و لێخۆشبوونی بۆ دەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","«ئەگەر یەکێک گوناهی کرد و یەکێک لەوانەی کرد کە یەزدان فەرمانی داوە نەکرێن و نەیزانی، ئەوا تاوانبارە و تاوانی خۆی لە ئەستۆ دەگرێت. ");
INSERT INTO ckb_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","بە بەرانێکی ساغی مێگەل و بەو نرخەی بۆی دادەنێیت، بە قوربانی تاوانەوە بۆ لای کاهینەکە دێت، کاهینەکەش لەو هەڵەیەی کە بەبێ ئەنقەست کردوویەتی کەفارەتی بۆ دەکات و لێخۆشبوونی بۆ دەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","ئەوە قوربانی تاوانە، چونکە تاوانێکی سەبارەت بە یەزدان کردووە.» ");
INSERT INTO ckb_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","هەروەها یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","«ئەگەر یەکێک گوناهی کرد و ناپاکی لە یەزدان کرد، بەوەی فێڵی لە کەسێک کرد، لە شتێک کە لەلای دانرابێت یان ئەمانەتێک یان دزینێک یان دەست بەسەرداگرتنی شتێکی نزیکەکەی، ");
INSERT INTO ckb_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","یان شتێکی بزربووی دۆزییەوە و سەبارەت بەوە نکۆڵی کرد، یان بە درۆ سوێندی لەسەر ئەمانە خوارد یان هەر شتێک کە مرۆڤ گوناهی تێدا بکات، ");
INSERT INTO ckb_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","ئەگەر گوناهی کرد و تاوانبار بوو، پێویستە شتەکان بگەڕێنێتەوە، ئەوا ئەوەی دزیویەتی یان ئەوەی دەستی بەسەردا گرتووە یان ئەوەی لەلای دانراوە یان ئەوەی بزر ببوو و دۆزییەوە، ");
INSERT INTO ckb_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","یان هەر شتێک کە بە درۆ سوێندی لەسەر خواردبێت. سەر بەسەر قەرەبووی دەکاتەوە و پێنج یەکیشی بۆ زیاد دەکات. لە ڕۆژی قوربانی تاوانەکەی دەیداتەوە دەست خاوەنەکەی. ");
INSERT INTO ckb_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","لەبری تاوانەکە دەبێت قوربانییەک بۆ کاهین بهێنێت، ئەمە بۆ یەزدانە، قوربانی تاوانەکە بەرانێکی ساغی مێگەل بێت، بەو نرخەی بۆی دادەنێیت، ");
INSERT INTO ckb_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","کاهینەکە لەبەردەم یەزدان کەفارەتی بۆ دەکات و لێخۆشبوونی بۆ دەبێت لە هەر شتێک کە کردوویەتی و پێی تاوانبارە.» ");
INSERT INTO ckb_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","هەروەها یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","«ئەم فەرمانە بە هارون و کوڕەکانی ڕابگەیەنە: ”ئەمانە ڕێنماییەکانن دەربارەی قوربانی سووتاندن. قوربانی سووتاندن دەبێت بە درێژایی شەو هەتا بەیانی لەسەر ئاگردانەکە بێت لەسەر قوربانگاکە. پێویستە ئاگری قوربانگاکەش بە داگیرساوی بمێنێتەوە. ");
INSERT INTO ckb_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","کاهینەکە جلەکانی و دەرپێکەی کە لە کەتانن لەبەر دەکات و خۆڵەمێشی ئەو قوربانی سووتاندنەی کە ئاگرەکە هەڵیلووشی هەڵدەگرێت و لەتەنیشت قوربانگاکە دایدەنێت. ");
INSERT INTO ckb_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","ئینجا جلەکانی دادەکەنێت و جلی دیکە لەبەر دەکات و خۆڵەمێشەکە دەباتە دەرەوەی ئۆردوگاکە بۆ شوێنێک بەپێی ڕێوڕەسم پاک بێت. ");
INSERT INTO ckb_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","پێویستە ئاگری سەر قوربانگاکەش بە داگیرساوی بمێنێتەوە و نەکوژێتەوە. کاهینەکەش هەموو بەیانییەک داری لەسەر دەسووتێنێت و قوربانی سووتاندنی لەسەر ڕێک دەخات و پیوی قوربانییەکانی هاوبەشی لەسەر دەسووتێنێت. ");
INSERT INTO ckb_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","ئاگرێکی بەردەوامە لەسەر قوربانگاکە کراوەتەوە و ناکوژێتەوە. ");
INSERT INTO ckb_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","«”ئەمانەش ڕێنماییەکانن دەربارەی پێشکەشکراوی دانەوێڵە، کوڕانی هارون لەبەردەم یەزدان پێشکەشی دەکەن بۆ پێش قوربانگاکە. ");
INSERT INTO ckb_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","بە مستی هەندێک ئاردی پێشکەشکراوی دانەوێڵەکە و زەیتەکەی و هەموو بخوورە سادەکەی کە لەسەر پێشکەشکراوە خۆراکەکەیە لێ دەبات و بەشی یادەوەرییەکە لەسەر قوربانگاکە دەسووتێنێت، ئەمەش وەک بۆنی خۆشییە بۆ یەزدان. ");
INSERT INTO ckb_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","ئەوەی لێشی دەمێنێتەوە هارون و کوڕانی دەیخۆن. بەڵام بەبێ هەویرترش لە شوێنێکی پیرۆز دەخورێت. لە حەوشەی چادری چاوپێکەوتن دەیخۆن. ");
INSERT INTO ckb_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","بە هەویرترش ناکرێت بە نان. کردوومە بە بەشی ئەوان لە قوربانییە بە ئاگرەکانم، ئەوە هەرەپیرۆزە وەک قوربانی گوناه و قوربانی تاوان. ");
INSERT INTO ckb_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","هەموو نێرینەیەک لە نەوەی هارون لێی دەخوات، بەشێکی چەسپاوە بۆ نەوەکانتان لە قوربانییە بە ئاگرەکان بۆ یەزدان، هەر شتێکی بەر بکەوێت پیرۆز دەبێت.“» ");
INSERT INTO ckb_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","هەروەها یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","«ئەمە قوربانی هارون و کوڕەکانییەتی کە لە ڕۆژی دەستنیشانکردن بۆ یەزدانی دەهێنن: دەیەکی ئێفەیەک لە باشترین ئارد لە پێشکەشکراوی دانەوێڵە، بە بەردەوامی نیوەی لە بەیانییان و نیوەی لە ئێواران. ");
INSERT INTO ckb_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","لەسەر ساج دروستکراو و بە زەیت شێلراو ساز دەکەیت و دەیهێنیت، بە پارچەپارچەکراوی پێشکەشکراوە دانەوێڵەکە پێشکەش دەکەیت، ئەو بۆنەی یەزدان پێی خۆشە. ");
INSERT INTO ckb_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","ئەو کوڕەی جێگەی دەگرێتەوە وەک کاهینی دەستنیشانکراو هەڵدەستێت بەو کارە، بەشێکی چەسپاوە بۆ یەزدان، بە تەواوی دەسووتێنرێ. ");
INSERT INTO ckb_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","هەموو پێشکەشکراوێکی دانەوێڵەی کاهین بە تەواوی دەسووتێنرێت و ناخورێت.» ");
INSERT INTO ckb_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","هەروەها یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","«لەگەڵ هارون و کوڕەکانی بدوێ و بڵێ: ”ئەمانە ڕێنماییەکانن دەربارەی قوربانی گوناه، لەو شوێنەی قوربانی سووتاندن سەردەبڕدرێت لەوێش قوربانی گوناه لەبەردەم یەزدان سەردەبڕیت، ئەوە هەرەپیرۆزە. ");
INSERT INTO ckb_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","ئەو کاهینەی قوربانییەکە بۆ کەفارەتی گوناه دەکات لێی دەخوات، لە شوێنێکی پیرۆز دەخورێت، لە حەوشەی چادری چاوپێکەوتن. ");
INSERT INTO ckb_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","هەر شتێک بەر کەلاکەکە بکەوێت ئەوا پیرۆز دەبێت، ئەگەر پرژەیەک لە خوێنەکە بەر جلێک کەوت، ئەوا پێویستە جلەکە لە شوێنێکی پیرۆز بشۆیت. ");
INSERT INTO ckb_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","بەڵام ئەو مەنجەڵە گڵینەی تێیدا لێنراوە، ئەوا دەشکێنرێت، ئەگەر لە مەنجەڵێکی بڕۆنز لێنرا، ئەوا سپی دەکرێتەوە و ئاوی پێدا دەکرێت. ");
INSERT INTO ckb_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","هەموو نێرینەیەک لە کاهینەکان لێی دەخوات، ئەوە هەرەپیرۆزە. ");
INSERT INTO ckb_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","بەڵام هەموو قوربانییەکی گوناه لە خوێنەکەی دەبردرێتە ناو چادری چاوپێکەوتن و بۆ کەفارەتکردن لە شوێنی پیرۆز، ناخورێت بەڵکو بە ئاگر دەسووتێنرێ. ");
INSERT INTO ckb_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","«”ئەمانەش ڕێنماییەکانن دەربارەی قوربانی تاوان. ئەمە هەرەپیرۆزە. ");
INSERT INTO ckb_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","لەو شوێنەی قوربانی سووتاندن سەردەبڕدرێت هەر لەوێ قوربانی تاوانیش سەردەبڕدرێت. خوێنەکەشی بەسەر هەموو لایەکی قوربانگاکەدا دەڕژێنرێت. ");
INSERT INTO ckb_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","هەموو پیوەکەشی پێشکەش دەکرێت، دوگەکەی و ئەو پیوەی هەناوی داپۆشیوە، ");
INSERT INTO ckb_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","لەگەڵ دوو گورچیلەکە و ئەو پیوەی لەسەریانە، ئەوەی لەسەر ناوقەدە، هەروەها ئەو پیوەی لەسەر جگەر و گورچیلەکانە لێی دەکرێتەوە. ");
INSERT INTO ckb_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","کاهینەکە لەسەر قوربانگاکە دەیانسووتێنێت. قوربانی بە ئاگرە بۆ یەزدان، ئەمە قوربانی تاوانە. ");
INSERT INTO ckb_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","هەموو نێرینەیەک لە کاهینەکان لێی دەخوات، بەڵام لە شوێنێکی پیرۆز دەخورێت، ئەمە هەرەپیرۆزە. ");
INSERT INTO ckb_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","«”قوربانی تاوان وەک قوربانی گوناهە، یەک فێرکردن هەیە دەربارەیان، ئەو کاهینەی کەفارەتیان پێ دەکات بۆ ئەو دەبێت، ");
INSERT INTO ckb_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","ئەو کاهینەش کە قوربانییەکی سووتاندن بۆ کەسێک دەکات، ئەوا پێستی ئەو قوربانییەی سووتاندن کە دەیکات بۆ ئەو دەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","هەموو پێشکەشکراوێکی دانەوێڵەش بە تەنوور کرابێتە نان و هەموو ئەوەی لەناو تاوە دروستکرابێت یان لەسەر ساج بۆ ئەو کاهینە دەبێت کە پێشکەشی دەکات، ");
INSERT INTO ckb_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","هەروەها هەموو پێشکەشکراوێکی دانەوێڵەی بە زەیت شێلراو یان وشک، بۆ هەموو کوڕانی هارون دەبێت، هەریەکە وەک براکەی. ");
INSERT INTO ckb_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","«”ئەمانەش ڕێنماییەکانن دەربارەی قوربانی هاوبەشی، ئەوەی کەسێک دەتوانێت بۆ یەزدانی بهێنێت. ");
INSERT INTO ckb_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","«”ئەگەر بۆ سوپاسکردن هێنای، ئەوا بۆ قوربانی سوپاسگوزاری کولێرەی فەتیرەی بە زەیت شێلراو و ناسکە نانی فەتیرەی بە زەیت چەورکراو و باشترین ئاردی شێلراو، کرابێتە کولێرەی بە زەیت شێلراو. ");
INSERT INTO ckb_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","لەگەڵ کولێرەی بە هەویرترش، قوربانییەکەی لەسەر قوربانی سوپاسگوزاری بۆ ژیانە هاوبەشییەکەی پێشکەش دەکات. ");
INSERT INTO ckb_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","لە هەر جۆرێکیان یەکێک وەک پێشکەشکراوێک دەهێنێت، وەک بەخشینێک بۆ یەزدان، بۆ ئەو کاهینە دەبێت کە خوێنی قوربانی هاوبەشی دەپرژێنێت. ");
INSERT INTO ckb_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","گۆشتی قوربانی سوپاسگوزاری بۆ ژیانی هاوبەشییەکەی لە ڕۆژی قوربانییەکەی دەخورێت، هیچی لێ ناهێڵێتەوە بۆ بەیانی. ");
INSERT INTO ckb_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","«”ئەگەر قوربانییەکەی نەزر بوو یان بە خواستی خۆی بوو، ئەوا ڕۆژی پێشکەشکردنی قوربانییەکە دەخورێت و بۆ سبەینێش ئەوەی لێی ماوەتەوە دەخورێت. ");
INSERT INTO ckb_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","بەڵام بەرماوەی گۆشتی قوربانییەکە لە ڕۆژی سێیەم دەسووتێنرێ. ");
INSERT INTO ckb_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","ئەگەر لە ڕۆژی سێیەم لە گۆشتی قوربانی هاوبەشییەکە خواردرا، ئەوا قوربانییەکە قبوڵ نییە، ئەوەی پێشکەشی کرد بە چاک بۆی دانانرێت، چونکە قوربانییەکە گڵاو بووە. ئەوەی لێی بخوات ئەوا تاوانی خۆی لە ئەستۆ دەگرێت. ");
INSERT INTO ckb_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","«”ئەو گۆشتەش کە بەر شتێکی گڵاو بکەوێت ئەوا بەپێی ڕێوڕەسم ناخورێت، بە ئاگر دەسووتێنرێت. بەڵام ئەو گۆشتەی کە گڵاو نییە، هەموو کەسێکی پاک بەپێی ڕێوڕەسم دەتوانێت لێی بخوات. ");
INSERT INTO ckb_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","هەروەها ئەگەر کەسێک بە شتێک گڵاو بووبێت و لە گۆشتی قوربانی هاوبەشی یەزدان بخوات، ئەوا دەبێت ئەو کەسە لە گەلەکەی داببڕدرێت. ");
INSERT INTO ckb_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","ئەگەر هەرکەسێک دەست لە شتێکی گڵاو بدات یان بەر شتێکی گڵاو بکەوێت، گڵاویی مرۆڤێک یان ئاژەڵێکی گڵاو یان هەر شتێکی قێزەونی گڵاو، ئینجا لە گۆشتی قوربانی هاوبەشی یەزدان بخوات، ئەوا ئەو کەسە لە گەلەکەی دادەبڕدرێت.“» ");
INSERT INTO ckb_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","هەروەها یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","«لەگەڵ نەوەی ئیسرائیل بدوێ و بڵێ: ”پیوی ئاژەڵی مێگەل و گاوگۆتاڵ مەخۆن. ");
INSERT INTO ckb_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","پیوی ئاژەڵی مردارەوەبوو و پیوی ئەو ئاژەڵەی بووە بە نێچیر ئەوا بۆ هەموو کارێک بەکاردێت، بەڵام ناخورێت. ");
INSERT INTO ckb_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","هەر یەکێک لە پیوی ئەو ئاژەڵانەی خوارد کە بۆ یەزدان وەک قوربانی بە ئاگر لێیان پێشکەش دەکرێت، ئەوا ئەو کەسە لە گەلەکەی دادەبڕدرێت. ");
INSERT INTO ckb_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","هیچ خوێنێکیش مەخۆن لە هەموو نشینگەکانتان، ئەگەر هی باڵندە بێت یان ئاژەڵ. ");
INSERT INTO ckb_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","هەرکەسێک خوێن بخوات، ئەوا ئەو کەسە لە گەلەکەی دادەبڕدرێت.“» ");
INSERT INTO ckb_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","هەروەها یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","«لەگەڵ نەوەی ئیسرائیل بدوێ و بڵێ: ”ئەوەی قوربانی هاوبەشی بۆ یەزدان پێشکەش دەکات، لە قوربانی هاوبەشییە پێشکەشکراوەکەی بۆ یەزدان دەهێنێت. ");
INSERT INTO ckb_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","کەسەکە بە دەستی خۆی قوربانییە بە ئاگرەکانی بۆ یەزدان دەهێنێت. پیوەکە لەگەڵ سنگەکە دەهێنێت. لەبەردەم یەزدان سنگەکە وەک قوربانی بەرزکردنەوە بەرز دەکاتەوە. ");
INSERT INTO ckb_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","کاهینەکە پیوەکە لەسەر قوربانگاکە دەسووتێنێت، بەڵام سنگەکە بۆ هارون و کوڕەکانی دەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","ڕانی ڕاستەش لە قوربانییەکانی هاوبەشیتان وەک پیتاک دەدەنە کاهینەکە. ");
INSERT INTO ckb_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","ئەوەی خوێنی قوربانی هاوبەشی و پیوەکە پێشکەش دەکات لە کوڕانی هارون، ڕانە ڕاستەکە دەبێتە بەشی ئەو، ");
INSERT INTO ckb_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","چونکە من لە قوربانییەکانی هاوبەشییان سنگی بەرزکراوە و ڕانە پێشکەشکراوەکەم لە نەوەی ئیسرائیل وەرگرتووە، بە هارونی کاهین و بە کوڕەکانیم داوە. بەشێکی چەسپاوە بۆ نەوەی ئیسرائیل.“» ");
INSERT INTO ckb_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","ئەوە پشکی هارون و کوڕەکانییەتی لە قوربانییە بە ئاگرەکانی بۆ یەزدان، ڕۆژی پێشکەشکردنیان هەتا کاهینیێتی بۆ یەزدان بکەن، ");
INSERT INTO ckb_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","لەو ڕۆژەی دەستنیشان کران یەزدان فەرمانی بە نەوەی ئیسرائیل دا بیاندەنێ، وەک بەشێکی چەسپاو بۆ نەوەکانیان. ");
INSERT INTO ckb_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","ئەوە ڕێنماییە بۆ قوربانی سووتاندن و پێشکەشکراوی دانەوێڵە و قوربانی گوناه و قوربانی تاوان و قوربانی ئەرک پێ سپاردن و قوربانی هاوبەشی، ");
INSERT INTO ckb_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","کە یەزدان لە شاخی سینا دایە موسا، بۆ ئەوەی فەرمان بە نەوەی ئیسرائیل بکات هەتا لە چۆڵەوانی سینا قوربانییەکانیان بۆ یەزدان پێشکەش بکەن. ");
INSERT INTO ckb_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","هەروەها یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","«هارون و کوڕەکانی ببە، لەگەڵ جلەکان و زەیتی دەستنیشانکردنەکە و جوانەگاکەی قوربانی گوناه و دوو بەرانەکە و سەبەتە نانە فەتیرەکە. ");
INSERT INTO ckb_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","هەموو کۆمەڵیش لەلای دەروازەی چادری چاوپێکەوتن کۆبکەرەوە.» ");
INSERT INTO ckb_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","موساش وەک یەزدان فەرمانی پێ کرد، ئاوای کرد، ئیتر کۆمەڵەکە لەلای دەروازەی چادری چاوپێکەوتن کۆبوونەوە. ");
INSERT INTO ckb_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","موسا بە کۆمەڵەکەی گوت: «یەزدان فەرمانی داوە ئەمە بکرێت.» ");
INSERT INTO ckb_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","ئینجا موسا هارون و کوڕەکانی هێنایە پێشەوە و بە ئاو شوشتنی. ");
INSERT INTO ckb_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","کراسەکەی لەبەر هارون کرد و کەمەربەندەکەی بۆ بەست، کەواکەی لەبەری کرد، ئێفۆدەکەی خستە سەر و بە پشتبەستی ئێفۆدەکە بەستی و توندی کرد. ");
INSERT INTO ckb_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","بەرسینەکەی لەبەری کرد و ئوریم و تومیمەکەی خستە ناو بەرسینەکە. ");
INSERT INTO ckb_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","مێزەرەکەشی خستە سەر سەری هارون. لەسەر مێزەرەکە بەلای پێشەوە پلێتە زێڕەکەی دانا کە تاجەگوڵینەی پیرۆزە، هەروەک یەزدان فەرمانی بە موسا کرد. ");
INSERT INTO ckb_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","ئینجا موسا زەیتی دەستنیشانکردنەکەی هێنا و چادرەکەی پەرستن و هەرچی تێیدا بوو دەستنیشانی کرد و تەرخانی کرد. ");
INSERT INTO ckb_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","حەوت جاریش بەسەر قوربانگاکەدا پرژاندی و قوربانگاکە و هەموو قاپوقاچاغەکانی و حەوزەکە و بنکەکەی دەستنیشان کرد بۆ تەرخانکردنیان. ");
INSERT INTO ckb_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","هەندێک لە زەیتی دەستنیشانکردنەکەشی لە سەری هارون دا و دەستنیشانی کرد بۆ تەرخانکردنی. ");
INSERT INTO ckb_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","موسا کوڕەکانی هارونی هێنایە پێشەوە و کراسی لەبەرکردن و کەمەربەندی بۆ بەستن و سەرپێچەکانی بۆ توند کردنەوە، هەروەک یەزدان فەرمانی بە موسا کرد. ");
INSERT INTO ckb_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","ئینجا جوانەگاکەی قوربانی گوناهی هێنایە پێشەوە و هارون و کوڕەکانی دەستیان لەسەر سەری جوانەگاکەی گوناه دانا. ");
INSERT INTO ckb_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","موسا سەری بڕی و هەندێک لە خوێنەکەی برد و بە پەنجەی دەستی خوێنەکەی لە هەموو قۆچەکانی قوربانگاکە دا بۆ ئەوەی قوربانگاکە پاک بکاتەوە. ئینجا پاشماوەی خوێنەکەی ڕشتە بنکەی قوربانگاکە. ئیتر تەرخانی کرد بۆ کەفارەتکردن بۆی. ");
INSERT INTO ckb_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","موسا هەموو ئەو پیوەی کە هەناوی داپۆشیوە لەگەڵ ئەوەی لەسەر جگەر و گورچیلەکانە و هەردوو گورچیلەکەی برد و لەسەر قوربانگاکە سووتاندنی. ");
INSERT INTO ckb_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","بەڵام جوانەگاکەی بە پێست و گۆشت و ڕیخۆڵەکەیەوە لە دەرەوەی ئۆردوگاکە بە ئاگر سووتاند، هەروەک یەزدان فەرمانی بە موسا کرد. ");
INSERT INTO ckb_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","ئینجا بەرانەکەی قوربانی سووتاندنی هێنایە پێشەوە و هارون و کوڕەکانی دەستیان لەسەر سەری بەرانەکە دانا. ");
INSERT INTO ckb_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","دوای ئەوە موسا سەری بڕی و خوێنەکەی بەسەر هەموو لایەکی قوربانگاکەدا پرژاند. ");
INSERT INTO ckb_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","بەرانەکەی پارچەپارچە کرد و موسا سەرەکە و پارچەکان و پیوەکەی سووتاند. ");
INSERT INTO ckb_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","بەڵام هەناو و قاچەکانی بە ئاو شوشت، موسا هەموو بەرانەکەی لەسەر قوربانگاکەدا سووتاند، وەک قوربانی بە ئاگر، بۆنی خۆشی، قوربانی بە ئاگر بۆ یەزدان، هەروەک یەزدان فەرمانی بە موسا کرد. ");
INSERT INTO ckb_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","ئینجا بەرانی دووەم، بەرانی ئەرک پێ سپاردنەکەی هێنایە پێشەوە، هارون و کوڕەکانی دەستیان لەسەر سەری بەرانەکە دانا. ");
INSERT INTO ckb_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","موسا سەری بڕی و لە خوێنەکەی برد و لە شلکەی گوێی ڕاستی هارونی دا، هەروەها لە پەنجە گەورەی دەستی ڕاست و پەنجە گەورەی پێی ڕاستی. ");
INSERT INTO ckb_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","هەروەها کوڕەکانی هارونی هێنایە پێشەوە و لە خوێنەکەی هەڵگرت و لە شلکەی گوێی ڕاستیان و پەنجە گەورەی دەستی ڕاستیان و پەنجە گەورەی پێی ڕاستیانی دا، پاشان خوێنی بەسەر هەموو لایەکی قوربانگاکەدا پرژاند. ");
INSERT INTO ckb_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","لەدوای ئەوە پیو و دوگ و هەموو پیوەکەی هەناوی و سەر جگەر و گورچیلەکان و هەردوو گورچیلە و ڕانی ڕاستی برد. ");
INSERT INTO ckb_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","هەروەها لە سەبەتەی فەتیرەکە، ئەوەی لەبەردەم یەزدانە، نانێک و کولێرەیەک لەوەی بە زەیتە و ناسکە نانێکی برد و لەسەر پیوەکە و لەسەر ڕانە ڕاستەکەی دانا. ");
INSERT INTO ckb_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","هەمووی خستنە سەر دەستی هارون و کوڕەکانی و لەبەردەم یەزدان وەک قوربانی بەرزکردنەوە بەرزیان کردەوە. ");
INSERT INTO ckb_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","ئینجا موسا لە دەستیانی وەرگرت و لەگەڵ قوربانی سووتاندنەکە لەسەر قوربانگاکە سووتاندی، ئەوە قوربانی ئەرک پێ سپاردنە، بۆنی خۆشییە، قوربانی بە ئاگرە بۆ یەزدان. ");
INSERT INTO ckb_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","هەروەها موسا سنگی بەرانی ئەرکسپاردنەکەی برد کە بەشی خۆی بوو، وەک قوربانی بەرزکردنەوە لەبەردەم یەزدان بەرزی کردەوە، هەروەک یەزدان فەرمانی بە موسا کرد. ");
INSERT INTO ckb_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","پاشان موسا لە زەیتی دەستنیشانکردنەکە و لە خوێنەکەی سەر قوربانگاکەی برد و بەسەر هارون و جلەکانی و بەسەر کوڕەکانی و جلی کوڕەکانی پرژاند. هارون و جلەکانی و کوڕەکانی و جلی کوڕەکانی پێ تەرخان کردن. ");
INSERT INTO ckb_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","ئینجا موسا بە هارون و کوڕەکانی گوت: «گۆشتەکە لەبەردەم دەروازەی چادری چاوپێکەوتن لێبنێن و هەر لەوێش بیخۆن، لەگەڵ ئەو نانەی ناو سەبەتەکەش، قوربانی ئەرکسپاردن، وەک فەرمانم کرد و گوتم: ”هارون و کوڕەکانی بیخۆن.“ ");
INSERT INTO ckb_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","ئەوەی لە گۆشت و نانەکەش دەمێنێتەوە بە ئاگر بیسووتێنن، ");
INSERT INTO ckb_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","لەلای دەروازەی چادری چاوپێکەوتنیش دوور نەکەونەوە، حەوت ڕۆژ هەتا تەواوی ڕۆژەکانی ئەرکسپاردنتان، چونکە حەوت ڕۆژ ئەرکتان پێ دەسپێردرێت. ");
INSERT INTO ckb_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","هەروەک لەم ڕۆژەدا کرا، یەزدان فەرمانی داوە کە بکرێت بۆ کەفارەتکردن بۆتان. ");
INSERT INTO ckb_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","حەوت شەو و حەوت ڕۆژ لەلای دەروازەی چادری چاوپێکەوتن دەمێننەوە و وریابن بۆ پارێزگاری لە ئەرکەکانی یەزدان، ئیتر نامرن، چونکە ئاوا فەرمانم پێکراوە.» ");
INSERT INTO ckb_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","جا هارون و کوڕەکانی هەموو ئەو شتانەی یەزدان لە ڕێگەی موسا فەرمانی پێ کردبوو، کردیان. ");
INSERT INTO ckb_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","لە ڕۆژی هەشتەم، موسا هارون و کوڕەکانی و پیرانی ئیسرائیلی بانگکرد و ");
INSERT INTO ckb_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","بە هارونی گوت: «جوانەگایەک بۆ خۆت، بۆ قوربانی گوناه و بەرانێک بۆ قوربانی سووتاندن ببە، هەردووکیان ساغ بن و لەبەردەم یەزدان پێشکەشیان بکە. ");
INSERT INTO ckb_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","لەگەڵ نەوەی ئیسرائیلیش بدوێ و بڵێ: ”گیسکێکی نێرینە بۆ قوربانی گوناه و جوانەگایەک و بەرخێکی یەک ساڵەی ساغ بۆ قوربانی سووتاندن و ");
INSERT INTO ckb_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","گایەک و بەرانێک بۆ قوربانی هاوبەشی بۆ سەربڕین لەبەردەم یەزدان ببەن، هەروەها پێشکەشکراوی دانەوێڵەی بە زەیت شێلراو، چونکە ئەمڕۆ یەزدان بۆتان دەردەکەوێت.“» ");
INSERT INTO ckb_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","ئەوەی موسا فەرمانی پێ کردبوو بردیانە پێش چادری چاوپێکەوتن و هەموو کۆمەڵەکە چوونە پێشەوە و لەبەردەم یەزدان وەستان. ");
INSERT INTO ckb_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","موسا گوتی: «یەزدان فەرمانی ئەمەی داوە، دەیکەن، ئینجا شکۆمەندی یەزدانتان بۆ دەردەکەوێت.» ");
INSERT INTO ckb_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","پاشان موسا بە هارونی گوت: «بڕۆ پێشەوە بۆ لای قوربانگاکە و قوربانی گوناهت و قوربانی سووتاندنەکەت بکە و کەفارەت بۆ خۆت و گەل بکە و قوربانی گەل بکە و کەفارەتیان بۆ بکە، هەروەک یەزدان فەرمانی دا.» ");
INSERT INTO ckb_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","ئیتر هارون چووە پێشەوە بۆ لای قوربانگەکە و جوانەگاکەی قوربانی گوناهی سەربڕی کە بۆ خۆی بوو. ");
INSERT INTO ckb_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","کوڕەکانی هارونیش خوێنەکەیان بۆ هێنا و ئەویش پەنجەی کردە ناو خوێنەکە و لەسەری قۆچەکانی قوربانگاکەی دا و خوێنەکەی ڕشتە بنکەی قوربانگاکە. ");
INSERT INTO ckb_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","پیوەکە و گورچیلەکان و ئەو پیوەی لەسەر جگەری قوربانییەکەی گوناه بوو لەسەر قوربانگاکە سووتاندی، هەروەک یەزدان فەرمانی بە موسا کرد، ");
INSERT INTO ckb_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","بەڵام کەلاک و پێستەکەی لە دەرەوەی ئۆردوگاکە سووتاند. ");
INSERT INTO ckb_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","ئینجا قوربانی سووتاندنەکەی سەربڕی و کوڕەکانی هارون خوێنەکەیان دایێ، ئەویش بەسەر هەموو لایەکی قوربانگاکەدا پرژاندی. ");
INSERT INTO ckb_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","پاشان قوربانی سووتاندنەکەی ئەوانی دایێ بە پارچەکانی و سەرەکەیەوە، ئەویش لەسەر قوربانگاکە سووتاندی. ");
INSERT INTO ckb_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","هەناو و قاچەکانیشی شوشت و لەسەر قوربانی سووتاندنەکە لەسەر قوربانگاکە سووتاندی. ");
INSERT INTO ckb_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","ئینجا هارون قوربانییەکەی گەلی پێشکەش کرد، گیسکەکەی برد کە قوربانی بوو بۆ گوناهی گەل، سەری بڕی و بۆ گوناه کردی وەک ئەوەی یەکەم. ");
INSERT INTO ckb_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","هارون بەپێی ڕێوڕەسم قوربانی سووتاندنەکەی پێشکەش کرد. ");
INSERT INTO ckb_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","هەروەها پێشکەشکراوەکەی دانەوێڵەی هێنا و مستی لێ پڕکرد و لەسەر قوربانگاکە سووتاندی، بێجگە لە قوربانی سووتاندنی بەیانی. ");
INSERT INTO ckb_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","گایەکە و بەرانەکەی سەربڕی، قوربانی هاوبەشی کە بۆ گەلە و کوڕەکانی هارون خوێنەکەیان پێیدا، ئەویش بەسەر هەموو لایەکی قوربانگاکەدا پرژاندی. ");
INSERT INTO ckb_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","هەروەها پیوەکە لە گایەکە و دوگەکە لە بەرانەکە، ئەو پیوەش کە هەناو دادەپۆشێت و گورچیلەکان و ئەو پیوەی لەسەر جگەرە، ");
INSERT INTO ckb_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","ئەم پیوانەیان خستە سەر دوو سنگەکە. ئینجا هارون پیوەکەی لەسەر قوربانگاکە سووتاند، ");
INSERT INTO ckb_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","بەڵام هەروەک موسا فەرمانی دا، بۆ قوربانی بەرزکردنەوە لەبەردەم یەزدان، دوو سنگەکە و ڕانی ڕاستی بەرز کردەوە. ");
INSERT INTO ckb_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","ئینجا هارون دەستی بەرەو گەل بەرزکردەوە و داوای بەرەکەتی بۆ کردن و لە پێشکەشکردنی قوربانی گوناه و قوربانی سووتاندن و قوربانی هاوبەشی، هاتە خوارەوە. ");
INSERT INTO ckb_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","ئینجا موسا و هارون چوونە ناو چادری چاوپێکەوتن و پاشان هاتنە دەرەوە و داوای بەرەکەتیان بۆ گەل کرد. ئیتر شکۆمەندی یەزدان بۆ هەموو گەل دەرکەوت. ");
INSERT INTO ckb_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","ئاگرێک لەلایەن یەزدانەوە کڵپەی کرد، هات و لەسەر قوربانگاکە قوربانی سووتاندنەکە و پیوەکەی سووتاند. هەموو گەلیش بینییان و هاواریان کرد و بەسەر ڕوویاندا کەوتن. ");
INSERT INTO ckb_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","دوو کوڕی هارون، ناداب و ئەبیهو، هەریەکە و بخووردانەکەی خۆی برد و ئاگریان تێدا کردەوە و بخووریان بەسەردا کرد. لەبەردەم یەزدان ئاگرێکی نامۆیان پێشکەش کرد، کە ئەو فەرمانی پێیان نەدابوو. ");
INSERT INTO ckb_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","ئیتر ئاگرێک لەلایەن یەزدانەوە کڵپەی کرد، هات و ئەوانی هەڵلووشی و لەبەردەم یەزدان مردن. ");
INSERT INTO ckb_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","موساش بە هارونی گوت: «ئەمە بوو مەبەستی یەزدان کاتێک فەرمووی: «”لەنێو ئەوانەی لێم نزیک دەبنەوە پیرۆزی خۆم دەردەخەم و لەبەردەم هەموو گەل شکۆدار دەبم.“» هارون بێدەنگ بوو. ");
INSERT INTO ckb_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","موسا بانگی میشائیل و ئەلسافانی کرد، دوو کوڕەکەی عوزیێلی مامی هارون و پێی گوتن: «وەرنە پێش، ئامۆزاکانتان لەبەردەم پیرۆزگا هەڵبگرن بۆ دەرەوەی ئۆردوگاکە.» ");
INSERT INTO ckb_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","ئەوانیش هاتنە پێش و بە کراسەکانیان هەڵیانگرتن بۆ دەرەوەی ئۆردوگاکە، هەروەک موسا گوتی. ");
INSERT INTO ckb_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","هەروەها موسا بە هارون و ئەلعازار و ئیتاماری کوڕەکانی هارونی گوت: «سەرتان ڕووت مەکەن و جلەکانتان مەدڕێنن، نەوەک بمرن و تووڕەیی یەزدان بێتە سەر هەموو کۆمەڵ. بەڵام کەسوکارتان، هەموو بنەماڵەی ئیسرائیل بۆ ئەوانە بگریێنن کە یەزدان بە ئاگر لەناوی بردوون. ");
INSERT INTO ckb_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","لە دەروازەی چادری چاوپێکەوتنیش دەرمەچن، نەوەک بمرن، چونکە زەیتی دەستنیشانکردنی یەزدان لەسەرتانە.» ئەوانیش بەگوێرەی قسەکەی موسایان کرد. ");
INSERT INTO ckb_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","هەروەها یەزدان بە هارونی فەرموو: ");
INSERT INTO ckb_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","«شەراب و مەی مەخۆرەوە، خۆت و کوڕەکانیشت، لە کاتی چوونە ژوورەوەتان بۆ ناو چادری چاوپێکەوتن، نەوەک بمرن. ئەمە فەرزێکی هەتاهەتاییە نەوە دوای نەوە، ");
INSERT INTO ckb_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","بۆ ئەوەی بتوانن لەنێوان پیرۆز و پیرۆزنەکراو و لەنێوان پاک و گڵاو جیاکاری بکەن، ");
INSERT INTO ckb_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","هەروەها بۆ ئەوەی نەوەی ئیسرائیل دەربارەی هەموو فەرزەکان فێر بکەن کە یەزدان لە ڕێگەی موساوە لەگەڵیاندا دوا.» ");
INSERT INTO ckb_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","موساش بە هارونی برای و دوو کوڕەکەی هارون، ئەلعازار و ئیتامار کە مابوونەوە گوتی: «ئەو پێشکەشکراوە دانەوێڵەیەی لە قوربانییە بە ئاگرەکانی بۆ یەزدان ماوەتەوە، بیبەن و لەتەنیشت قوربانگاکە بەبێ هەویرترش بیخۆن، چونکە هەرەپیرۆزە. ");
INSERT INTO ckb_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","لە شوێنێکی پیرۆز بیخۆن، چونکە بەشی تۆ و بەشی کوڕەکانتە لە قوربانییە بە ئاگرەکانی بۆ یەزدان، چونکە من بەو شێوەیە فەرمانم داوە. ");
INSERT INTO ckb_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","بەڵام سنگی بەرزکراوە و ڕانی پێشکەشکراو لە شوێنێکی پاک دەخۆن، خۆت و کوڕەکانت و کچەکانت، چونکە کراون بە بەشی تۆ و بەشی کوڕەکانت لە قوربانییەکانی هاوبەشی نەوەی ئیسرائیل. ");
INSERT INTO ckb_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","ڕانی پێشکەشکراو و سنگی بەرزکراوە لەگەڵ پیوەکانی قوربانی بە ئاگر دەهێنن، هەتا لەبەردەم یەزدان وەک قوربانی بەرزکردنەوە بەرز بکرێنەوە. ئەمانە بۆ تۆ و بۆ کوڕەکانت دەبن کە لەگەڵتدان، بەشێکی چەسپاوە، هەروەک یەزدان فەرمانی دا.» ");
INSERT INTO ckb_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","کاتێک موسا داوای گیسکەکەی قوربانی گوناهی کرد و بۆی دەرکەوت کە سووتێنراوە، لە ئەلعازار و ئیتامار کە دوو کوڕەکەی هارون بوون و مابوونەوە، تووڕە بوو و گوتی: ");
INSERT INTO ckb_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","«بۆچی قوربانییەکەی گوناهتان لە پیرۆزگادا نەخوارد؟ بێگومان کە هەرەپیرۆزە و پێتان دراوە بۆ ئەوەی تاوانی کۆمەڵەکە هەڵبگرن بۆ کەفارەت بۆیان لەبەردەم یەزدان، ");
INSERT INTO ckb_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","لەو کاتەوە خوێنەکەی بۆ ژوورەوەی شوێنی پیرۆز نەهێنرا، بێگومان دەبووایە لە پیرۆزگا بیخۆن، هەروەک فەرمانم داوە.» ");
INSERT INTO ckb_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","هارون وەڵامی موسای دایەوە: «ئەوان ئەمڕۆ قوربانی گوناهە و قوربانی سووتاندنیان لەبەردەم یەزدان پێشکەش کرد و شتێکی وام تووش بوو. ئەگەر ئەمڕۆ من لە قوربانی گوناهم بخواردایە، ئایا لەبەرچاوی یەزدان ئەمە پەسەند دەبوو؟» ");
INSERT INTO ckb_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","کە موسا گوێی لەمە بوو، لەبەرچاوی پەسەند بوو. ");
INSERT INTO ckb_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","هەروەها یەزدان لەگەڵ موسا و هارون دوا و پێی فەرموون: ");
INSERT INTO ckb_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","«لەگەڵ نەوەی ئیسرائیل بدوێن و بڵێن: ”ئەوانە ئەو گیانلەبەرانەن کە دەیانخۆن، لە هەموو ئاژەڵەکانی سەر زەوی: ");
INSERT INTO ckb_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","هەر ئاژەڵێک کە سمی دوو کەرت بێت و کاوێژ بکات، ئەوە دەخۆن. ");
INSERT INTO ckb_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","«”لەوانەی تەنها کاوێژ دەکەن یان تەنها سمیان دوو کەرتە، ئەمانە ناخۆن: وشتر، چونکە کاوێژ دەکات بەڵام سمی دوو کەرت نییە، بۆیە گڵاوە بۆتان؛ ");
INSERT INTO ckb_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","هەروەها گۆڕهەڵکەنە، چونکە کاوێژ دەکات، بەڵام سمی کەرت نییە، گڵاوە بۆتان؛ ");
INSERT INTO ckb_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","کەروێشک، چونکە کاوێژ دەکات بەڵام سمی دوو کەرت نییە، بۆیە گڵاوە بۆتان؛ ");
INSERT INTO ckb_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","بەراز، چونکە سمی کەرت کراوە، بەڵام کاوێژ ناکات، بۆیە گڵاوە بۆتان. ");
INSERT INTO ckb_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","نە گۆشتیان بخۆن و نە دەست لە کەلاکیان بدەن، چونکە گڵاوە بۆتان. ");
INSERT INTO ckb_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","«”لە هەموو ئەوانەی لەناو ئاوەکانیشن ئەمانە دەخۆن، هەموو ئەوانەی باڵ و پوولەکەیان هەبێت لەناو ئاوەکان، لەناو دەریاکان و لەناو ڕووبارەکان، ئەوانە دەخۆن. ");
INSERT INTO ckb_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","بەڵام هەموو ئەوەی باڵ و پوولەکەی نەبێت لەناو دەریاکان و ڕووبارەکان، لە هەموو خشۆکەکانی ناو ئاوەکان و هەموو زیندەوەرێکی ناو ئاوەکان، قێزەونە بۆتان. ");
INSERT INTO ckb_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","بۆتان قێزەون دەبێت، لە گۆشتەکەی ناخۆن و قێزتان لە کەلاکەکەی دەبێتەوە. ");
INSERT INTO ckb_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","هەموو ئەوەی باڵ و پوولەکەی نەبێت لەناو ئاوەکان، بۆتان قێزەونە. ");
INSERT INTO ckb_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","«”لە باڵندەکانیش، قێزتان لەمانە دەبێتەوە، ناخورێن، قێزەونن، هەڵۆ و سیسارکە کەچەڵ و داڵاش، ");
INSERT INTO ckb_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","واشەی سوور و هەموو جۆرەکانی واشەی ڕەش، ");
INSERT INTO ckb_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","هەموو جۆرەکانی قەلەڕەش، ");
INSERT INTO ckb_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","کوندەپەپووی شاخدار و بایەقووش، مەلی دەریا، هەموو جۆرەکانی باز، ");
INSERT INTO ckb_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","کوندەپەپووی بچووک، مەلی ماسیگرە، کوندەپەپووی گەورە، ");
INSERT INTO ckb_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","کوندەپەپووی سپی و کوندەپەپووی بیابان، واشەی ماسیگر، ");
INSERT INTO ckb_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","لەقلەق و هەموو جۆرەکانی شاهۆ و پەپوسڵێمانکە و شەمشەمەکوێرە. ");
INSERT INTO ckb_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","«”هەموو مێرووێکی باڵدار کە لەسەر چوار پێ بڕوات بۆ ئێوە قێزەونە. ");
INSERT INTO ckb_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","لەنێو هەموو مێرووێکی باڵدار کە لەسەر چوار پێ دەڕوات تەنها ئەمانە دەخۆن، ئەوەی دوو لاقی نوشتاوەی هەیە لەسەر قاچەکانی و پێیان هەڵدەبەزێتەوە لەسەر زەوی، ");
INSERT INTO ckb_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","ئەمە بە هەموو جۆرەکانییەوە دەخۆن: کوللە و سۆلام و بێوکە و پێکوڕە. ");
INSERT INTO ckb_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","بەڵام ئەوانی دیکە هەر مێرووێکی باڵدار کە چوارپێی هەبێت قێزەونە بۆتان. ");
INSERT INTO ckb_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","«”بەمانە گڵاو دەبن، هەرکەسێک دەست لە کەلاکیان بدات یان بەر کەلاکیان بکەوێت، ئەوا هەتا ئێوارە گڵاو دەبێت، ");
INSERT INTO ckb_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","هەر یەکێک کەلاکیان هەڵبگرێت، دەبێت جلەکانی بشوات و هەتا ئێوارە گڵاو دەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","«”هەموو ئەو ئاژەڵانەش کە سمیان بە تەواوی شەق نەبێت، یان کاوێژ نەکات، ئەوا گڵاوە بۆتان و هەرکەسێک دەست لە کەلاکی هەر یەکێکیان بدات یان بەر کەلاکی هەر یەکێکیان بکەوێت ئەوا گڵاو دەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","هەر ئاژەڵێکیش لە چوار پێیەکان کە لەسەر ناولەپی بڕوات، گڵاوە بۆتان و هەرکەسێک دەست لە کەلاکیان بدات یان بەر کەلاکیان بکەوێت، هەتا ئێوارە گڵاو دەبێت، ");
INSERT INTO ckb_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","هەرکەسێک کەلاکیان هەڵبگرێت، دەبێت جلەکانی بشوات و هەتا ئێوارە گڵاو دەبێت، ئەوە گڵاوە بۆتان. ");
INSERT INTO ckb_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","«”ئەمەش گڵاوە بۆتان لەوانەی لەسەر زەوی دەخشێن، ڕاسۆ، جرج، مارمێلکە بە هەموو جۆرەکانییەوە، ");
INSERT INTO ckb_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","قومقمۆکە، بزنمژ، شەوگەرد، مارمێلکەی خشۆک و کامیلۆن. ");
INSERT INTO ckb_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","ئەمانە گڵاوەکانن بۆتان لە هەموو خشۆکەکان، هەرکەسێک دەستیان لێ بدات یان بەریان بکەوێت دوای مرداربوونیان، ئەوا هەتا ئێوارە گڵاو دەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","هەر شتێکیش یەکێک لەوانەی کەوتە سەری کە مردبوو، ئەو شتە گڵاو دەبێت، لە هەر شتێک، دار بێت یان قوماش یان پێست یان گوش، هەر شتێک کە کاری پێ بکرێت، دەخرێتە ناو ئاوەوە و هەتا ئێوارە گڵاو دەبێت و پاشان پاک دەبێتەوە. ");
INSERT INTO ckb_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","هەر دەفرێکی گڵینیش ئەمانەی بکەوێتە ناوی، هەرچی تێیدایە گڵاو دەبێت و دەفرەکەش دەشکێنن. ");
INSERT INTO ckb_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","هەر خواردنێکیش کە بخورێت، لەو دەفرەیە ئاوی بەسەردا بکرێت، گڵاو دەبێت. هەر خواردنەوەیەکیش کە لەو دەفرەیە بخورێتەوە، گڵاو دەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","هەر شتێک کەلاکی یەکێک لەوانەی تێبکەوێت، گڵاو دەبێت، ئەگەر تەنوور بێت یان ئاگردان، دەبێت تێکبدرێت، ئەوە گڵاوە و بۆ ئێوە گڵاو دەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","تەنها کانی و ئەمباراو کە ئاویان تێدا کۆدەبێتەوە، ئەوان پاک دەبن، بەڵام هەرکەسێک دەست لە کەلاکی هەر یەکێکیان بدات یان بەر کەلاکی هەر یەکێکیان بکەوێت، ئەوا گڵاو دەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","ئەگەر کەلاکی یەکێکیان کەوتە سەر هەر تۆوێک کە بچێنرێت، ئەوا تۆوەکە پاکە، ");
INSERT INTO ckb_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","بەڵام ئەگەر ئاو لەسەر تۆوەکە هەبوو و کەلاکی یەکێکیانی کەوتە سەر، گڵاوە بۆتان. ");
INSERT INTO ckb_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","«”ئەگەر یەکێک لەو ئاژەڵانەی کە خواردنە بۆتان مرد، هەرکەسێک دەست لە کەلاکی بدات یان بەر کەلاکی بکەوێت، ئەوا هەتا ئێوارە گڵاو دەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","هەر یەکێکیش لە کەلاکەکەی بخوات، ئەوا جلەکانی دەشوات و هەتا ئێوارە گڵاو دەبێت، هەر یەکێکیش کەلاکەکەی هەڵبگرێت، ئەوا جلەکانی دەشوات و هەتا ئێوارە گڵاو دەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","«”هەموو خشۆکێکیش کە لەسەر زەوی دەخشێت، ئەوە قێزەونە و ناخورێت. ");
INSERT INTO ckb_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","هەرچی لەسەر سکی بڕوات و هەرچی لەسەر چوارپێ بڕوات لەگەڵ هەموو ئەوەی پێی زیاترە، لە هەموو خشۆکەکان کە لەسەر زەوی دەخشێن مەیخۆن، چونکە قێزەونە بۆتان. ");
INSERT INTO ckb_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","خۆتان پیس مەکەن بە خشۆکێک کە دەخشێت، خۆتانی پێ گڵاو مەکەن و پێی گڵاو مەبن. ");
INSERT INTO ckb_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","من یەزدانی پەروەردگارتانم، خۆتان تەرخان بکەن و پیرۆز بن، چونکە من پیرۆزم. خۆتان بە خشۆکێک کە لەسەر زەوی دەخشێت گڵاو مەکەن. ");
INSERT INTO ckb_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","من یەزدانم ئەوەی کە لە خاکی میسرەوە دەریهێنان بۆ ئەوەی ببێتە خوداتان، کەواتە پیرۆز بن، چونکە من پیرۆزم. ");
INSERT INTO ckb_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","«”ئەمانە ڕێنماییەکانن دەربارەی ئاژەڵ و باڵندەکان و هەموو گیانلەبەرێک کە لەناو ئاو دەجوڵێت و هەموو گیانێک کە لەسەر زەوی دەخشێت. ");
INSERT INTO ckb_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","پێویستە گڵاو و پاک و ئەو زیندەوەرانەی دەخورێن و ئەو زیندەوەرانەی ناخورێن لێک جیا بکەنەوە.“» ");
INSERT INTO ckb_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","هەروەها یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","«لەگەڵ نەوەی ئیسرائیل بدوێ و بڵێ: ”ئەگەر ژنێک سکی پڕ بوو و کوڕێکی بوو، ئەوا بەپێی ڕێوڕەسم بۆ حەوت ڕۆژ گڵاو دەبێت، هەروەک لە ڕۆژانی خوێنلێچوونی مانگانەی گڵاو دەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","لە ڕۆژی هەشتەمدا کۆرپەکە خەتەنە دەکرێت، ");
INSERT INTO ckb_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","ئینجا دایکەکە سی و سێ ڕۆژی دیکە دەمێنێتەوە هەتا لە خوێن لێچوونەکەی پاک ببێتەوە، بەر هیچ شتێکی پیرۆز ناکەوێت و بۆ پیرۆزگا ناچێت، هەتا ڕۆژانی پاکبوونەوەی تەواو دەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","ئەگەر کچی بوو، ئەوا دوو هەفتە پاک نابێت، هەروەک لە خوێنلێچوونی بێت، ئینجا شەست و شەش ڕۆژی دیکە دەمێنێتەوە، هەتا لە زەیستانییەکەی پاک ببێتەوە. ");
INSERT INTO ckb_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","«”کاتێک ڕۆژانی پاکبوونەوەی تەواو بوو، ئەگەر کوڕی بووبێت یان کچ، ئەوا بەرخێکی یەک ساڵە وەک قوربانی سووتاندن و بێچووە کۆترێک یان کوکوختییەک وەک قوربانی گوناه دەهێنێتە بەر دەروازەی چادری چاوپێکەوتن بۆ کاهینەکە. ");
INSERT INTO ckb_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","ئەویش لەبەردەم یەزدان پێشکەشی دەکات و کەفارەتی بۆ دەکات، ئینجا بەپێی ڕێوڕەسم لە خوێن لێچوونەکەی پاک دەبێتەوە. «”ئەوە ڕێنماییە بۆ ئەو ژنەی کوڕ یان کچی دەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","بەڵام ئەگەر دەستکورت بوو بەرخێک بهێنێت، ئەوا دوو کوکوختی یان دوو بێچووە کۆتر، یەکێکیان بۆ قوربانی سووتاندن و ئەوی دیکە بۆ قوربانی گوناه، بەم شێوەیە کاهینەکە کەفارەتی بۆ دەکات و پاک دەبێتەوە.“» ");
INSERT INTO ckb_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","هەروەها یەزدان بە موسا و هارونی فەرموو: ");
INSERT INTO ckb_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","«ئەگەر کەسێک ئاوسانێک، یان لیرێک یان لەکەیەکی بریقەدار لەسەر پێستی لەشی هەبوو، کە گومانی نەخۆشی گواستراوەی پێستی لێ بکرێت، ئەوا ئەو کەسە دەهێنرێتە لای هارونی کاهین، یان یەکێک لە کوڕە کاهینەکانی. ");
INSERT INTO ckb_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","ئەگەر کاهینەکە پشکنی زامەکە لە پێستی لەشە و ئەو مووانەی لەناو زامەکەن سپین و زامەکە لە پێستی لەش قووڵترە، ئەوە نەخۆشی گواستراوەی پێستە. کاتێک کاهینەکە پشکنی، بەپێی ڕێوڕەسم ڕایدەگەیەنێت کە گڵاوە. ");
INSERT INTO ckb_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","بەڵام ئەگەر لەکەیەکی بریقەداری سپی بوو لە پێستی لەش و لە پێست قووڵتر نەبوو و ئەو مووانەی لەناو لەکەکەن سپی نەببوون، ئەوا کاهینەکە کەسی تووشبوو حەوت ڕۆژ لە خەڵک جیا دەکاتەوە. ");
INSERT INTO ckb_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","ئەگەر کاهینەکە لە ڕۆژی حەوتەم پشکنینی بۆ ئەنجام دا و بینی زامەکە وەک خۆیەتی و لە پێستی تەشەنەی نەکردووە، ئەوا کاهینەکە حەوت ڕۆژی دیکەش جیای دەکاتەوە. ");
INSERT INTO ckb_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","ئەگەر کاهینەکە دووبارە لە ڕۆژی حەوتەم پشکنینی بۆ ئەنجام دا و بینییەوە زامەکە کاڵ بووەتەوە و لە پێستی تەشەنەی نەکردووە، ئەوا کاهینەکە ڕایدەگەیەنێت کە پاکە، واتا ئەوە لیرە. ئەو کەسە جلەکانی دەشوات و پاک دەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","بەڵام ئەگەر لیرەکە لە پێستی تەشەنەی کرد لەدوای ئەوەی پیشانی کاهینەکە درا بۆ پاککردنەوەی، دەبێت دیسان پیشانی کاهینەکە بدرێتەوە. ");
INSERT INTO ckb_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","ئەگەر کاهینەکە پشکنی لیرەکە لە پێستی تەشەنەی کردووە، ئەوا کاهینەکە ڕایدەگەیەنێت کە ئەو کەسە گڵاو بووە، ئەوە نەخۆشییەکی گواستراوەیە. ");
INSERT INTO ckb_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","«ئەگەر کەسێک نەخۆشی گواستراوەی پێستی هەبێت، ئەوا دەهێنرێتە لای کاهین. ");
INSERT INTO ckb_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","ئەگەر کاهینەکە پشکنینی بۆ ئەنجام دا و بینی ئاوسانێکی سپی لە پێست هەیە و مووی سپی کردووە و لە شوێنی ئاوسانەکە گۆشتی ڕووت بە دەرەوەیە، ");
INSERT INTO ckb_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","ئەوا نەخۆشی پێستی درێژخایەنە لە پێستی لەشی، ئیتر کاهینەکە ڕایدەگەیەنێت کە گڵاوە، دوورەپەرێزی ناکات، چونکە گڵاوە. ");
INSERT INTO ckb_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","«بەڵام ئەگەر نەخۆشییەکە تەشەنەی کردبێت و هەموو پێستی داگرتبوو، لە سەرییەوە هەتا پێیەکانی، بەگوێرەی هەموو ئەوەی چاوی کاهینەکە دەیبینێت، ");
INSERT INTO ckb_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","کاهینەکە پشکنینی بۆ ئەنجام دا و بینی وا نەخۆشییەکە هەموو لەشی داگرتووە، ئەوا ڕایدەگەیەنێت کە تووشبووەکە پاکە، لەو کاتەوە هەمووی سپی بووە، ئەوە پاکە. ");
INSERT INTO ckb_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","بەڵام هەر کاتێک گۆشتی ڕووتی تێدا بینی، ئەوا گڵاو دەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","کاتێک کاهینەکە گۆشتە ڕووتەکەی بینی، ڕایدەگەیەنێت کە گڵاوە. گۆشتی ڕووت گڵاوە، ئەوا کەسەکە نەخۆشییەکی گواستراوەی هەیە. ");
INSERT INTO ckb_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","ئەگەر گۆشتە ڕووتەکە جارێکی دیکە سپی بووبێتەوە، ئەوا دێتەوە لای کاهینەکە. ");
INSERT INTO ckb_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","ئینجا کە کاهینەکە پشکنی وا شوێنە تووشبووەکە سپی بووە، کاهینەکە ڕایدەگەیەنێت کە تووشبووەکە پاکە، ئەوا کەسەکە پاکە. ");
INSERT INTO ckb_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","«ئەگەر کەسێک لە پێستەکەی دومەڵێک بووبێت و چاک بووبێتەوە، ");
INSERT INTO ckb_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","لە شوێنی دومەڵەکەش ئاوسانێکی سپی یان لەکەیەکی بریقەداری سپی سوورباو هەبێت، ئەوا پیشانی کاهینەکە دەدرێت. ");
INSERT INTO ckb_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","ئەگەر کاهینەکە پشکنی لە پێست قووڵترە و مووەکانی سپی بووە، ئەوا کاهینەکە ڕایدەگەیەنێت کە گڵاوە. ئەوە نەخۆشی گواستراوەی پێستە کە لە دومەڵەکە بڵاوبووەتەوە. ");
INSERT INTO ckb_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","بەڵام ئەگەر کاهینەکە پشکنی مووی سپی تێدا نییە و لە پێست قووڵتر نییە و ڕەنگی ئاساییە، ئەوا کاهینەکە حەوت ڕۆژ جیای دەکاتەوە، ");
INSERT INTO ckb_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","بەڵام ئەگەر لە پێست تەشەنەی کردبێت، ئەوا کاهینەکە ڕایدەگەیەنێت کە گڵاوە، ئەوە گواستراوەیە. ");
INSERT INTO ckb_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","بەڵام ئەگەر لەکە بریقەدارەکە لە شوێنی خۆی مایەوە و تەشەنەی نەکردووە، ئەوە شوێنەواری دومەڵەکەیە و کاهینەکە ڕایدەگەیەنێت کە پاکە. ");
INSERT INTO ckb_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","«ئەگەر کەسێک لە پێستیدا شوێنێکی سووتاوی بە ئاگر هەبێت، گۆشتە ڕووتەکەی شوێنە سووتاوەکە لەکەیەکی بریقەداری سپی سوورباو یان سپی هەبێت، ");
INSERT INTO ckb_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","کاهینەکە پشکنی وا مووی لەکە بریقەدارەکە سپی بووە و لە پێست قووڵترە، ئەوە نەخۆشییەکی گواستراوەیە و لە شوێنە سووتاوەکە بڵاوبووەتەوە. کاهینەکە ڕایدەگەیەنێت کە گڵاوە، ئەوە نەخۆشی گواستراوەی پێستە. ");
INSERT INTO ckb_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","بەڵام ئەگەر کاهینەکە پشکنی لە لەکە بریقەدارەکە مووی سپی نییە و لە پێست قووڵتر نییە و ڕەنگی ئاساییە، ئەوا کاهینەکە حەوت ڕۆژ جیای دەکاتەوە. ");
INSERT INTO ckb_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","کاهینەکە لە ڕۆژی حەوتەم دەیبینێت، ئەگەر بە پێستدا تەشەنەی کردبێت، ئەوا کاهینەکە ڕایدەگەیەنێت کە گڵاوە، ئەوە نەخۆشی گواستراوەی پێستە. ");
INSERT INTO ckb_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","بەڵام ئەگەر لەکە بریقەدارەکە لە شوێنی خۆی مایەوە و لە پێست تەشەنەی نەکردبێت و ڕەنگی ئاسایی بوو، ئەوا ئاوسانی سووتانەکەیە، کاهینەکە ڕایدەگەیەنێت کە پاکە، چونکە شوێنەواری سووتانەکەیە. ");
INSERT INTO ckb_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","«هەروەها ئەگەر ئافرەتێک یان پیاوێک زامێک لە سەری یان لە چەناگەی هەبێت، ");
INSERT INTO ckb_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","کاهینەکە زامەکەی پشکنی وا لە پێست قووڵترە و مووی زەردی وردی تێدایە، ئەوا کاهینەکە ڕایدەگەیەنێت کە گڵاوە، ئەوە کەچەڵییە، ئەوە نەخۆشی گواستراوەی سەر یان چەناگەیە. ");
INSERT INTO ckb_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","بەڵام ئەگەر کاهینەکە پشکنی تووشبوون بە کەچەڵییەکە لە پێست قووڵتر نییە، بەڵام مووی ڕەشی تێدا نییە، ئەوا کاهینەکە حەوت ڕۆژ کەسی تووشبوو جیا دەکاتەوە. ");
INSERT INTO ckb_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","ئەگەر کاهینەکە لە ڕۆژی حەوتەم کەچەڵییەکەی پشکنی، وا تەشەنەی نەکردووە و مووی زەردی تێدا نییە و کەچەڵییەکە لە پێست قووڵتر نییە، ");
INSERT INTO ckb_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","با بتاشرێت، بەڵام کەچەڵییەکە نا، کاهینەکەش حەوت ڕۆژی دیکە کەسی تووشبوو جیا دەکاتەوە. ");
INSERT INTO ckb_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","ئەگەر کاهینەکە لە ڕۆژی حەوتەم کەچەڵییەکەی پشکنی، وا کەچەڵییەکە لە پێستدا تەشەنەی نەکردووە و لە پێست قووڵتر نییە، ئەوا کاهینەکە ڕایدەگەیەنێت کە کەسی تووشبوو پاکە، جا جلەکانی دەشوات و پاک دەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","بەڵام ئەگەر کەچەڵییەکە لە پێستدا تەشەنەی کردبێت لەدوای ئەوەی ڕاگەیەنرا کە پاکە، ");
INSERT INTO ckb_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","کاهینەکەش پشکنی وا کەچەڵییەکە لە پێست تەشەنەی کردووە، ئەوا کاهینەکە لەدوای مووی زەرد ناگەڕێت، ئەوە گڵاوە. ");
INSERT INTO ckb_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","بەڵام ئەگەر وەک خۆی مایەوە و مووی ڕەشی تێدا ڕوا، ئەوا کەچەڵییەکە چاک بووەتەوە، ئەوە پاکە و کاهینەکە ڕایدەگەیەنێت کە پاکە. ");
INSERT INTO ckb_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","«ئەگەر پیاوێک یان ئافرەتێک لە پێستیدا لەکەی سپی هەبوو، ");
INSERT INTO ckb_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","کاهینەکەش پشکنی ئەوا لە پێستی لەشی لەکەی ڕەنگ ئاسایی سپی هەیە، ئەوە لیری بێ زیانە، لە پێستدا تەشەنەی کردووە، ئەوا کەسەکە پاکە. ");
INSERT INTO ckb_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","«ئەگەر کەسێک مووی سەری ڕووتایەوە، ئەوە کەچەڵە، ئەو پاکە. ");
INSERT INTO ckb_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","ئەگەر مووی سەری لەلای پێشەوە ڕووتایەوە، ئەوە سەر ڕووتاوە، ئەو پاکە. ");
INSERT INTO ckb_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","بەڵام ئەگەر لە کەچەڵییەکە یان ڕووتاوییەکە لەکەی سپی سوورباو هەبوو، ئەوا نەخۆشی گواستراوەیە و لە کەچەڵییەکەی یان ڕووتاوییەکەی تەشەنەی کردووە. ");
INSERT INTO ckb_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","ئەگەر کاهینەکە ئەوەی پشکنی و بینی وا ئاوساوی تووشبوونەکە سپی سوورباوە لە کەچەڵییەکەی یان لە ڕووتاوییەکەی وەک نەخۆشی گواستراوەی پێست، ");
INSERT INTO ckb_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","ئەوە کەسێکی نەخۆش و گڵاوە. کاهینەکەش ڕایدەگەیەنێت کە گڵاوە، سەری تووش بووە. ");
INSERT INTO ckb_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","«ئەو کەسە تووش بووە، جلی دڕاو لەبەر دەکات و سەری دانەپۆشراو دەبێت و سمێڵی دادەپۆشێت و هاوار دەکات: ”گڵاو! گڵاو!“ ");
INSERT INTO ckb_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","هەموو ئەو ڕۆژانەی نەخۆشییەکەی پێوەیە گڵاو دەبێت، گڵاوە و بە تەنها دەژیێت، دەرەوەی ئۆردوگا دەبێتە جێی مانەوەی. ");
INSERT INTO ckb_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","«بەڵام ئەگەر جلوبەرگێک کەڕوو لێی دابوو، جلوبەرگی خوری یان کەتان، ");
INSERT INTO ckb_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","ئەوەی ڕستراو بێت یان چنراو، لە کەتان و لە خوری، یان لە چەرم، یان لە هەر دروستکراوێک لە چەرم، ");
INSERT INTO ckb_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","لێدانەکەش سەوزباو یان سوورباو بوو، لە جلەکە یان لە چەرمەکە، لە ڕستراو یان لە چنراو یان لە هەر شتێک لە چەرم بێت، ئەوە لێدانی کەڕووە، جا پیشانی کاهین دەدرێت. ");
INSERT INTO ckb_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","کاهینەکەش کەڕووەکە دەپشکنێت و لێدراوە تووشبووەکە حەوت ڕۆژ جیا دەکاتەوە. ");
INSERT INTO ckb_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","جا کە لە ڕۆژی حەوتەم لێدانەکەی پشکنی وا لە جلەکە بڵاوبووەتەوە، لە ڕستراو یان لە چنراو یان لە چەرم، لە هەموو ئەوانەی لە چەرم دروستدەکرێت بۆ بەکارهێنان، ئەوا لێدانەکە کەڕووە و زیان بەخشە، گڵاوە. ");
INSERT INTO ckb_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","جا جلەکە یان ڕستراوەکە یان چنراوەکە لە خوری بێت یان کەتان یان لە هەر شتێکی چەرم دەیسووتێنێت، ئەوەی لێدانەکەی تێدایە، چونکە کەڕووی زیان بەخشە بە ئاگر دەسووتێنرێ. ");
INSERT INTO ckb_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","«بەڵام ئەگەر کاهینەکە پشکنی وا کەڕووەکە لە جلەکە یان ڕستراوەکە یان چنراوەکە یان شتە چەرمەکە بڵاونەبووەتەوە، ");
INSERT INTO ckb_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","ئەوا کاهینەکە فەرمان دەدات ئەوەی لێدانەکەی تێدایە بشۆن و حەوت ڕۆژی دیکە جیای دەکاتەوە. ");
INSERT INTO ckb_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","ئەگەر کاهینەکە دوای شوشتنی لێدانەکە پشکنی کەڕووەکە دیمەنی نەگۆڕاوە و بڵاونەبووەتەوە، ئەوا گڵاوە. دەبێت بە ئاگر بیسووتێنیت، جا لەناوەوەی بێت یان لە دەرەوەی. ");
INSERT INTO ckb_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","بەڵام ئەگەر کاهینەکە پشکنی شوێنی کەڕووەکە ڕەنگی ئاساییە پاش شوشتنی، ئەوا لە جلەکە یان چەرمەکە، ڕستراوەکە یان چنراوەکە دەیدڕێنێت. ");
INSERT INTO ckb_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","بەڵام ئەگەر لە جلەکە، لە ڕستراوەکە یان چنراوەکە یان لە شتە چەرمەکە دەرکەوتەوە، ئەوا بڵاوبووەتەوە، ئەوەی کەڕووەکەی تێدایە بە ئاگر دەیسووتێنێت. ");
INSERT INTO ckb_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","بەڵام هەر جلێک، ڕستراو یان چنراو، یان شتێکی چەرم، ئەوەی دەیشۆیت و کەڕووەکەی تێدا نامێنێت، ئەوا دووبارە دەشۆردرێتەوە و پاک دەبێتەوە.» ");
INSERT INTO ckb_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","ئەوانە ڕێنماییەکان بوون دەربارەی کەڕوولێدان، لە جلی خوری یان لە کەتان، لە ڕستراو یان لە چنراو یان هەر شتێکی چەرم، بۆ ڕاگەیاندن کە پاکە یان گڵاوە. ");
INSERT INTO ckb_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","هەروەها یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","«ئەمانە ڕێنماییەکانن دەربارەی ڕێوڕەسمی پاکبوونەوە. کاتێک نەخۆشەکە دەهێنرێتە لای کاهین، ");
INSERT INTO ckb_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","کاهینەکەش دەچێتە دەرەوەی ئۆردوگاکە، جا ئەگەر کاهینەکە پشکنی کەسەکە چاک بووەتەوە لە نەخۆشی گواستراوەی پێست، ");
INSERT INTO ckb_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","کاهینەکە فەرمان دەدات کە دوو چۆلەکەی زیندووی پاک بۆ ئەو کەسەی کە پاک دەبێتەوە ببەن لەگەڵ پارچە دارێکی ئورز و بەنی سووری ئاڵ و زوفا. ");
INSERT INTO ckb_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","ئینجا کاهینەکە فەرمان دەدات کە یەکێک لە چۆلەکەکان لە گۆزەیەکی گڵین لەسەر ئاوێکی سازگار سەرببڕدرێت. ");
INSERT INTO ckb_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","بەڵام چۆلەکە زیندووەکە لەگەڵ پارچە دارە ئورزەکە و بەنە سوورە ئاڵەکە و زوفاکە دەبات و دەیانخاتە ناو خوێنی چۆلەکە سەربڕدراوەکەی سەر ئاوە سازگارەکە. ");
INSERT INTO ckb_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","حەوت جار بەسەر ئەو کەسەدا دەیپرژێنێت کە لە نەخۆشییە گواستراوەکە پاک دەبێتەوە و پاکی دەکاتەوە، ئینجا چۆلەکە زیندووەکە ڕووەو دەشتودەر بەڕەڵا دەکات. ");
INSERT INTO ckb_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","«جا ئەو کەسەی کە پاک دەبێتەوە پێویستە جلەکانی بشوات و هەموو مووی لەشی بتاشێت و بە ئاو خۆی بشوات. ئەو کاتە بەپێی ڕێوڕەسم پاک دەبێتەوە، ئینجا دێتە ناو ئۆردوگاکەوە، بەڵام حەوت ڕۆژ لە دەرەوەی چادرەکەی نیشتەجێ دەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","لە ڕۆژی حەوتەم سەری و ڕیشی و برۆکانی و هەموو مووەکانی دەتاشێت، پێویستە جلەکانیشی بشوات و خۆی بە ئاو بشوات، جا پاک دەبێتەوە. ");
INSERT INTO ckb_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","«ئینجا لە ڕۆژی هەشتەمدا دوو بەرخی نێری ساغ و بەرخێکی مێیەی یەک ساڵەی ساغ دەهێنێت، لەگەڵ سێ لە دەی ئێفەیەک لە باشترین ئاردی پێشکەشکراوی دانەوێڵە کە بە زەیت شێلرابێت و هەروەها لۆگێک زەیت. ");
INSERT INTO ckb_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","جا ئەو کاهینەی بە پاککردنەوەکە هەڵدەستێت، کەسە پاکبووەوەکە لەگەڵ قوربانی و پێشکەشکراوەکانی لەبەردەم یەزدان، لەلای دەروازەی چادری چاوپێکەوتن ڕادەگرێت. ");
INSERT INTO ckb_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","«ئینجا کاهینەکە یەکێک لە بەرخە نێرەکان دەبات و وەک قوربانی تاوان پێشکەشی دەکات لەگەڵ لۆگە زەیتەکە، لەبەردەم یەزدان بەرزی دەکاتەوە، وەک قوربانی بەرزکردنەوە. ");
INSERT INTO ckb_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","بەرخەکەش لەو شوێنە سەردەبڕێت کە قوربانی گوناه و قوربانی سووتاندنی تێدا سەردەبڕدرێت، لە پیرۆزگا، چونکە قوربانی تاوان وەک قوربانی گوناه بۆ کاهینە و هەرەپیرۆزە. ");
INSERT INTO ckb_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","ئینجا کاهینەکە لە خوێنی قوربانییەکەی تاوان دەبات و لە شلکەی گوێی ڕاستە و پەنجە گەورەی دەستی ڕاست و پەنجە گەورەی پێی ڕاستەی ئەو کەسەی دەدات کە پاک دەبێتەوە. ");
INSERT INTO ckb_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","پاشان کاهینەکە لە لۆگە زەیتەکە هەندێک دەبات و دەیکاتە ناو لەپی دەستی چەپی خۆی، ");
INSERT INTO ckb_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","ئینجا کاهینەکە پەنجەیەکی دەستی ڕاستی دەکاتە ناو ئەو زەیتەی ناو لەپی دەستی چەپییەتی و حەوت جار بە پەنجەی زەیتەکە لەبەردەم یەزدان دەپرژێنێت. ");
INSERT INTO ckb_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","ئەوەی دەمێنێتەوە لەو زەیتەی ناو لەپی دەستی، کاهینەکە لە شلکەی گوێی ڕاستە و پەنجە گەورەی دەستی ڕاست و پەنجە گەورەی پێی ڕاستی ئەو کەسەی دەدات کە پاک دەبێتەوە، لەسەر خوێنەکەی قوربانی تاوان. ");
INSERT INTO ckb_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","ئەوەی دەشمێنێتەوە لەو زەیتەی ناو لەپی دەستی، دەیکات بەسەر سەری ئەو کەسەی کە پاک دەبێتەوە و کاهینەکە لەبەردەم یەزدان کەفارەتی بۆ دەکات. ");
INSERT INTO ckb_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","«ئینجا کاهینەکە قوربانی گوناه دەکات و بۆ ئەو کەسەی کە لە گڵاوییەکەی پاک دەبێتەوە کەفارەت دەکات و پاشان قوربانی سووتاندنەکە سەردەبڕێت. ");
INSERT INTO ckb_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","دواتر کاهینەکە قوربانی سووتاندنەکە و پێشکەشکراوی دانەوێڵە بۆ سەر قوربانگاکە سەردەخات و کەفارەتی بۆ دەکات، جا پاک دەبێتەوە. ");
INSERT INTO ckb_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","«بەڵام ئەگەر هەژار و دەستکورت بوو، ئەوا یەک بەرخی نێر دەبات وەک قوربانی تاوان ڕادەوەشێنرێت، بۆ کەفارەتکردن بۆی، لەگەڵ دەیەکێکی ئێفەیەک لە باشترین ئاردی بە زەیت شێلراو بۆ پێشکەشکراوی دانەوێڵە و لۆگێک زەیت، ");
INSERT INTO ckb_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","هەروەها دوو کوکوختی یان دوو بێچووە کۆتر، بەپێی توانای دەستی، جا یەکێکیان دەبێتە قوربانی گوناه و ئەوەی دیکە قوربانی سووتاندن. ");
INSERT INTO ckb_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","«لە ڕۆژی هەشتەمدا دەیهێنێتە لای کاهینەکە بۆ پاکبوونەوەی، بۆ لای دەروازەی چادری چاوپێکەوتن لەبەردەم یەزدان. ");
INSERT INTO ckb_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","جا کاهینەکە بەرخەکەی بۆ قوربانی تاوان و لۆگە زەیتەکە دەبات و لەبەردەم یەزدان بەرزی دەکاتەوە وەک قوربانی بەرزکردنەوە. ");
INSERT INTO ckb_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","ئینجا بەرخەکە بۆ قوربانی تاوان سەردەبڕێت و کاهینەکە لە خوێنی قوربانییەکەی تاوان لە شلکەی گوێی ڕاستە و پەنجە گەورەی دەستی ڕاست و پەنجە گەورەی پێی ڕاستی ئەو کەسەی دەدات کە پاک دەبێتەوە. ");
INSERT INTO ckb_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","ئینجا کاهینەکە هەندێک لە زەیتەکە لەناو لەپی دەستی چەپی خۆی دەکات، ");
INSERT INTO ckb_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","کاهینەکە بە پەنجەیەکی دەستی ڕاستی لەو زەیتەی لە لەپی دەستی چەپیدایە حەوت جار لەبەردەم یەزدان دەیپرژێنێت. ");
INSERT INTO ckb_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","هەروەها کاهینەکە لەو زەیتەی لەناو لەپیەتی، لە شلکەی گوێی ڕاست و پەنجە گەورەی دەستی ڕاست و پەنجە گەورەی پێی ڕاستی ئەو کەسەی دەدات کە پاک دەبێتەوە، لە شوێنی خوێنەکەی قوربانی تاوان. ");
INSERT INTO ckb_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","ئەوەی دەمێنێتەوە لەو زەیتەی ناو لەپی کاهینەکە، بەسەر سەری ئەو کەسەی دادەکات کە پاک دەبێتەوە بۆ کەفارەتکردن بۆی لەبەردەم یەزدان. ");
INSERT INTO ckb_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","ئینجا یەکێک لە دوو کوکوختییەکە یان یەکێک لە دوو بێچووە کۆترەکان، ئەوەی لە توانای دەستییەتی، ");
INSERT INTO ckb_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","یەکێکیان دەکاتە قوربانی گوناه و ئەوی دیکە قوربانی سووتاندن لەگەڵ پێشکەشکراوەکەی دانەوێڵە، کاهینەکە لەبەردەم یەزدان کەفارەت بۆ ئەو کەسە دەکات کە پاک دەبێتەوە.» ");
INSERT INTO ckb_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","ئەوە ڕێنماییە بۆ ئەو کەسەی نەخۆشی گواستراوەی پێستی هەبێت، ئەوەی دەستکورت بێت بۆ پاکبوونەوەکەی. ");
INSERT INTO ckb_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","هەروەها یەزدان بە موسا و هارونی فەرموو: ");
INSERT INTO ckb_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","«لەو کاتەی کە دەچنە خاکی کەنعان، کە من دەتاندەمێ وەک موڵکی خۆتان، وام کرد ماڵێک لەو خاکە تووشی کەڕوو بێت، ");
INSERT INTO ckb_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","ئەوەی خاوەنی ماڵەکەیە دەچێت و بە کاهینەکە دەڵێت: ”وابزانم کەڕوو لە ماڵەکەی داوم.“ ");
INSERT INTO ckb_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","کاهینەکەش فەرمان دەدات ماڵەکە چۆڵ بکرێت، پێش چوونە ژوورەوەی کاهینەکە بۆ پشکنینی لێدانەکە، نەوەک هەموو شتەکانی ماڵەکە گڵاو بێت، پاش ئەوە کاهینەکە بۆ پشکنینی ماڵەکە دەچێتە ژوورەوە. ");
INSERT INTO ckb_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","جا ئەگەر پشکنی لێدانەکە لە دیوارەکانی ماڵەکەیە و هەڵکراوێکی سەوزباو یان سوورباوە، لە دیوارەکەش قووڵترە، ");
INSERT INTO ckb_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","ئەوا کاهینەکە لە ماڵەکە دێتە دەرەوە و بۆ حەوت ڕۆژ ماڵەکە دادەخات. ");
INSERT INTO ckb_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","ئەگەر کاهینەکە لە ڕۆژی حەوتەم گەڕایەوە و پشکنی وا لێدانەکە لە دیوارەکانی ماڵەکە بڵاوبووەتەوە، ");
INSERT INTO ckb_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","کاهینەکە فەرمان دەدات، ئەو بەردانە دەربهێنن کە لێدانەکەی تێدایە و فڕێیانبدەنە دەرەوەی شارۆچکەکە لە شوێنێکی گڵاو. ");
INSERT INTO ckb_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","ماڵەکەش لە هەر چواردەوری دیوی ژوورەوە دەڕنن، ئەو خۆڵەش کە دەیڕننەوە، فڕێیدەدەنە دەرەوەی شارۆچکەکە لە شوێنێکی گڵاو. ");
INSERT INTO ckb_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","بەردی دیکە دەهێنن و لە شوێنی بەردەکان دایاندەنێن و خۆڵی دیکە دێنن و ماڵەکەی پێ سواخ دەدەنەوە. ");
INSERT INTO ckb_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","«جا ئەگەر لێدانەکە گەڕایەوە و لە ماڵەکە بڵاو بووەوە، لەدوای دەرهێنانی بەردەکان و ڕنینی ماڵەکە و سواخدانەوەی، ");
INSERT INTO ckb_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","کاهینەکە هات و پشکنی وا لێدانەکە لە ماڵەکەدا بڵاوبووەتەوە، ئەوا کەڕووێکی گەندەڵە لە ماڵەکە، ئەوە گڵاوە. ");
INSERT INTO ckb_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","جا ماڵەکە تێکدەدات، بەرد و دارەکانی و هەموو خۆڵی ماڵەکە دەباتە دەرەوەی شارۆچکەکە بۆ شوێنێکی گڵاو. ");
INSERT INTO ckb_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","«ئەوەی لە هەموو ڕۆژانی داخستنی ماڵەکە بچێتە ناوی، ئەوا هەتا ئێوارە گڵاو دەبێت، ");
INSERT INTO ckb_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","ئەوەی لە ماڵەکە خەوتبێت، ئەوا دەبێت جلەکانی بشوات و ئەوەی لە ماڵەکە نانی خواردبێت ئەوا دەبێت جلەکانی بشوات. ");
INSERT INTO ckb_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","«بەڵام ئەگەر کاهینەکە هات و پشکنی لێدانەکە لە ماڵەکە بڵاو نەبووەتەوە دوای سواخدانەوەکەی، ئەوا کاهینەکە ڕایدەگەیەنێت ماڵەکە پاکە، چونکە لێدانەکە نەماوە. ");
INSERT INTO ckb_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","بۆ پاکبوونەوەی ماڵەکە دوو چۆلەکە لەگەڵ پارچە دارێکی ئورز و بەنی سووری ئاڵ و زوفا دەبات. ");
INSERT INTO ckb_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","یەکێک لە چۆلەکەکان لە گۆزەیەکی گڵین سەر دەبڕێت، لەسەر ئاوێکی سازگار. ");
INSERT INTO ckb_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","ئینجا پارچە دارە ئورزەکە و زوفاکە و بەنە سوورە ئاڵەکە و چۆلەکە زیندووەکە دەبات و دەیخاتە ناو خوێنی چۆلەکە سەربڕدراوەکە و ئاوە سازگارەکە، حەوت جار بەسەر ماڵەکەدا دەیپرژێنێت. ");
INSERT INTO ckb_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","بەم شێوەیە بە خوێنی چۆلەکەکە، ئاوە سازگارەکە، چۆلەکە زیندووەکە، پارچە دارە ئورزەکە، زوفاکە و بەنە سوورە ئاڵەکە ماڵەکە پاک دەکاتەوە. ");
INSERT INTO ckb_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","ئینجا چۆلەکە زیندووەکە بۆ دەرەوەی شارۆچکەکە ڕووەو دەشتودەر بەڕەڵای دەکات و کەفارەت بۆ ماڵەکە دەکات، ئیتر پاک دەبێتەوە.» ");
INSERT INTO ckb_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","ئەوە ڕێنماییە بۆ هەموو جۆرە نەخۆشییەکی گواستراوەی پێست و کەچەڵی، ");
INSERT INTO ckb_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","کەڕووی جلوبەرگ و ماڵ، ");
INSERT INTO ckb_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","ئاوسان و لیر و لەکەی بریقەدار، ");
INSERT INTO ckb_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","بۆ یەکلاییکردنەوەی شتێک کە پاک بێت یان گڵاو. ئەوە ڕێنماییە بۆ نەخۆشی گواستراوەی پێست و کەڕوو. ");
INSERT INTO ckb_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","هەروەها یەزدان بە موسا و هارونی فەرموو: ");
INSERT INTO ckb_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","«لەگەڵ نەوەی ئیسرائیل بدوێن و پێیان بڵێن: ”هەر پیاوێک لێچوونی هەبێت لە ئەندامی نێرینەی، ئەوا لێچوونەکەی گڵاوە، ");
INSERT INTO ckb_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","ئەم لێچوونەشی دەبێتە هۆی گڵاوبوونی. ئەگەر ئەندامی نێرینەی لێچوونەکەی بەردەوام بێت یان ڕایگرتبوو، ئەوا گڵاوە. ");
INSERT INTO ckb_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","«”ئەوەی لێچوونەکەی هەیە لەسەر هەر نوێنێک ڕابکشێت، گڵاو دەبێت، لەسەر هەر شتێکیش دانیشێت، گڵاو دەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","ئەوەی دەست لە نوێنەکەی بدات، دەبێت جلەکانی بشوات و بە ئاو خۆی بشوات و هەتا ئێوارە گڵاو دەبێت، ");
INSERT INTO ckb_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","هەرکەسێک لەسەر شتێک دابنیشێت کە کابرای لێچوو لەسەری دانیشتبوو، دەبێت جلەکانی بشوات و بە ئاو خۆی بشوات، هەتا ئێوارەش گڵاو دەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","«”هەرکەسێک دەستی بەر لەشی کابرای لێچوو بکەوێت، دەبێت جلەکانی بشوات و خۆی بە ئاو بشوات و هەتا ئێوارە گڵاو دەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","«”ئەگەر کابرای لێچوو تفی لە یەکێکی پاک کرد، دەبێت ئەو کەسەی کە پێشتر پاک بووە جلەکانی بشوات و بە ئاو خۆی بشوات و هەتا ئێوارەش گڵاو دەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","«”لە کاتی سواریدا زینەکەی ژێری گڵاو دەبێت، ");
INSERT INTO ckb_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","هەرکەسێکیش دەستی لێ بدات، هەتا ئێوارە گڵاو دەبێت، ئەوەی هەڵیانبگرێت، دەبێت جلەکانی بشوات و بە ئاو خۆی بشوات و هەتا ئێوارەش گڵاو دەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","«”هەرکەسێکیش کابرای لێچوو دەستی لێ بدات، بێ ئەوەی دەستی بە ئاو بشوات، دەبێت جلەکانی بشوات و بە ئاو خۆی بشوات و هەتا ئێوارەش گڵاو دەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","«”هەر دەفرێکی گڵین کابرای لێچوو دەستی لێ بدات دەشکێنرێت، هەروەها هەر ئامرازێکی داریش بە ئاو دەشۆردرێت. ");
INSERT INTO ckb_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","«”ئەگەر کابرای لێچوو لە لێچوونەکەی پاک بووەوە، ئەوا حەوت ڕۆژی بۆ دادەنرێت بۆ پاکبوونەوەی و جلەکانی دەشوات و بە ئاوی سازگار خۆی دەشوات، جا پاک دەبێتەوە. ");
INSERT INTO ckb_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","جا لە ڕۆژی هەشتەمدا دوو کوکوختی یان دوو بێچووە کۆتر دەهێنێت بۆ بەردەم یەزدان بۆ لای دەروازەی چادری چاوپێکەوتن و دەیاندات بە کاهینەکە. ");
INSERT INTO ckb_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","کاهینەکە یەکێکیان دەکاتە قوربانی گوناه و ئەوی دیکەش قوربانی سووتاندن، کاهینەکە لەبەردەم یەزدان کەفارەتی بۆ دەکات لە لێچوونەکەی. ");
INSERT INTO ckb_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","«”ئەگەر پیاوێک تۆوی لێ هاتە دەرەوە، ئەوا هەموو لەشی بە ئاو دەشوات و هەتا ئێوارە گڵاو دەبێت، ");
INSERT INTO ckb_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","هەر جلێک یان چەرمێک تۆوی بکەوێتە سەر، دەبێت بە ئاو بشۆردرێت و هەتا ئێوارە گڵاو دەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","هەروەها ئەو پیاوەی کە لەگەڵ ژنەکەی ڕابکشێت و پیاوەکە تۆوی لێچوو، ئەوا دەبێت هەردووکیان خۆیان بە ئاو بشۆن و هەتا ئێوارەش گڵاو دەبن. ");
INSERT INTO ckb_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","«”ئەگەر ژنێک خوێنلێچوونی هەبوو، ئەوا حەوت ڕۆژ لە خوێنلێچوونی مانگانەی دەمێنێتەوە و هەرکەسێک دەستی لێ بدات هەتا ئێوارە گڵاو دەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","«”هەموو ئەو شتەی لەسەری ڕادەکشێت یان دادەنیشێت لە کاتی خوێنلێچوونی مانگانەی، گڵاو دەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","هەرکەسێکیش دەست لە نوێنەکەی بدات، دەبێت جلەکانی بشوات و بە ئاو خۆی بشوات و هەتا ئێوارە گڵاو دەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","هەرکەسێکیش دەست لە شتێک بدات کە ئەو لەسەری دانیشتبێت، دەبێت جلەکانی بشوات و بە ئاو خۆی بشوات و هەتا ئێوارە گڵاو دەبێت؛ ");
INSERT INTO ckb_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","ئەگەر نوێن بێت یان هەر شتێک کە لەسەری دانیشتووە، هەر کاتێک کەسێکیش دەستی لێ بدات، ئەوا هەتا ئێوارە گڵاو دەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","«”ئەگەر پیاوێکیش لەگەڵی ڕابکشێت، جا لە خوێن لێچوونەکە بەر پیاوەکە بکەوێت، ئەوا پیاوەکە حەوت ڕۆژ گڵاو دەبێت و لەسەر هەر نوێنێکیش ڕابکشێت، گڵاو دەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","«”ئەگەر ئافرەتێک ماوەیەکی درێژ خوێنی لێچوو، بێجگە لە کاتی خوێنلێچوونی مانگانەی، یان ئەگەر دوای کاتی خوێن لێچوونەکەی هەر بەردەوام بوو، ئەوا هەموو ڕۆژانی خوێن لێچوونەکەی وەک کاتی خوێنلێچوونی مانگانەی، گڵاو دەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","هەموو نوێنەکەش کە لەسەری ڕادەکشێت لە ڕۆژانی خوێنلێچوونی وەک نوێنی ڕۆژانی خوێنلێچوونی مانگانەیەتی، هەموو ئەو شتانەش کە لەسەری دادەنیشێت، ئەوا گڵاوە وەک گڵاوی خوێنلێچوونی مانگانەی. ");
INSERT INTO ckb_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","هەرکەسێکیش دەستیان لێ بدات، گڵاو دەبێت و پێویستە جلەکانی بشوات و بە ئاو خۆی بشوات و هەتا ئێوارە گڵاو دەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","«”ئەگەر لە خوێن لێچوونەکەی پاک بووەوە، ئەوا حەوت ڕۆژ دەژمێرێت، ئینجا بەپێی ڕێوڕەسم پاک دەبێتەوە، ");
INSERT INTO ckb_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","لە ڕۆژی هەشتەم دوو کوکوختی یان دوو بێچووە کۆتر دەبات و دەیانهێنێتە لای کاهینەکە، بۆ لای دەروازەی چادری چاوپێکەوتن. ");
INSERT INTO ckb_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","ئینجا کاهینەکەش یەکێکیان دەکاتە قوربانی گوناه و ئەوی دیکەش قوربانی سووتاندن. کاهینەکە لەبەردەم یەزدان کەفارەتی بۆ دەکات لە گڵاوی خوێن لێچوونەکەی. ");
INSERT INTO ckb_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","«”جا نەوەی ئیسرائیل جیا بکەنەوە لەو شتانەی گڵاویان دەکات، با لە گڵاویدا نەمرن و نشینگەکەم کە لەنێویاندایە گڵاوی نەکەن.“» ");
INSERT INTO ckb_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","ئەوە ڕێنماییە بۆ ئەمانە: ئەو پیاوەی کە لێچوونی هەبێت، ئەوەی تۆوی لێ دێتە دەرەوە و پێی گڵاو دەبێت، ");
INSERT INTO ckb_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","ئەو ئافرەتەی خوێنلێچوونی مانگانەی هەیە، ئەو پیاوەی یان ئەو ئافرەتەی لێچوونێکی هەیە، ئەو پیاوەش کە لەگەڵ ژنێک کە گڵاو بووبێت ڕابکشێت. ");
INSERT INTO ckb_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","لەدوای مردنی دوو کوڕەکەی هارون، کاتێک لەبەردەم یەزدان نزیک ببوونەوە و مردبوون، یەزدان لەگەڵ موسا دوا و ");
INSERT INTO ckb_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","پێی فەرموو: «بە هارونی برات بڵێ با هەموو کاتێک نەیەتە ناو شوێنی هەرەپیرۆز لە پشت پەردەکەی پێش قەپاغی کەفارەتەکە کە لەسەر سندوقەکەیە، نەوەک بمرێت، چونکە من لە هەوردا لەسەر قەپاغی کەفارەتەکە دەبینرێم. ");
INSERT INTO ckb_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","«هارون بەم شێوەیە بچێتە ناو پیرۆزگاکە: جوانەگایەک بۆ قوربانی گوناه و بەرانێک بۆ قوربانی سووتاندن بهێنێت. ");
INSERT INTO ckb_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","کراسێکی کەتان و پیرۆز لەبەر بکات و دەرپێی کەتانی لەبەربێت و بە کەمەربەندی کەتان پشتی ببەستێت و مێزەری کەتانی لەسەر بێت، ئەوە جلوبەرگێکی پیرۆزە، خۆی بە ئاو بشوات و جلەکان لەبەر بکات. ");
INSERT INTO ckb_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","لە کۆمەڵی ئیسرائیلیش دوو گیسکی نێرینە ببات بۆ قوربانی گوناه و بەرانێک بۆ قوربانی سووتاندن. ");
INSERT INTO ckb_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","«هارون جوانەگاکە پێشکەش بکات بۆ قوربانی گوناهی خۆی و کەفارەت بۆ خۆی و بۆ ماڵەکەی بکات، ");
INSERT INTO ckb_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","ئینجا دوو گیسکە نێرینەکەش ببات و لەبەردەم یەزدان لەلای دەروازەی چادری چاوپێکەوتن ڕایانبگرێت. ");
INSERT INTO ckb_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","هارون تیروپشک بۆ دوو گیسکەکە بکات، یەکێکیان بۆ یەزدان و ئەوی دیکە بۆ لابردنی گوناه لەسەر کۆمەڵگا. ");
INSERT INTO ckb_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","ئەو گیسکەی لە تیروپشک بۆ یەزدان دەرچوو، ئەوا هارون پێشکەشی بکات و بیکاتە قوربانی گوناه. ");
INSERT INTO ckb_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","بەڵام ئەو گیسکەی بە تیروپشک بۆ لابردنی گوناه لەسەر کۆمەڵگا دەرچوو، ئەوا بە زیندوویی لەبەردەم یەزدان ڕایبگرێت بۆ کەفارەتکردن لەسەری، بۆ ئەوەی بۆ عەزازێلی بنێرێتە چۆڵەوانی. ");
INSERT INTO ckb_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","«پێویستە هارون جوانەگاکەی قوربانی گوناه بهێنێت و سەری ببڕێت، کەفارەت بۆ خۆی و ماڵەکەی بکات. ");
INSERT INTO ckb_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","هارون بە پڕی بخووردانەکە پشکۆی ئاگر لەسەر قوربانگاکە لەبەردەم یەزدان ببات، بە پڕی دەستەکانیشی بخووری بۆنخۆشی باش کوتراوە ببات و بیانباتە پشت پەردەکە. ");
INSERT INTO ckb_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","ئەو لەبەردەم یەزدان بخوورەکە بەسەر ئاگرەکەدا بکات، هەروەها دووکەڵی بخوورەکە قەپاغەکەی کەفارەت داپۆشێت کە لەسەر سندوقی پەیمانە، ئیتر نامرێت. ");
INSERT INTO ckb_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","ئینجا لە خوێنی جوانەگاکە ببات و بە پەنجەی بەسەر ڕووی قەپاغەکەی کەفارەت، بەلای ڕۆژهەڵات بیپرژێنێت، لەلای پێشەوەی قەپاغەکەی کەفارەتیش، حەوت جار بە پەنجەی خوێنەکە بپرژێنێت. ");
INSERT INTO ckb_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","«ئینجا گیسکەکەی قوربانی گوناه کە بۆ گەل سەری ببڕێت و بە خوێنەکەیەوە بچێتە پشت پەردەکە، چی بە خوێنی جوانەگاکە کرد، ئاواش بە خوێنەکەی ئەم بکات و بەسەر قەپاغەکەی کەفارەت و لای پێشەوەی بیپرژێنێت. ");
INSERT INTO ckb_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","بەم شێوەیە کەفارەت بۆ شوێنی هەرەپیرۆز بکات لە گڵاوییەکانی نەوەی ئیسرائیل و لە یاخیبوون و هەموو گوناهەکانیان. بۆ چادری چاوپێکەوتنیش کە لەنێویانە ئاوا بکات، لەناوەندی گڵاوییەکانیان. ");
INSERT INTO ckb_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","نابێت هیچ کەسێکیش لە چادری چاوپێکەوتن بێت، لە کاتی چوونە ژوورەوەی هارون بۆ کەفارەتکردن لە شوێنی هەرەپیرۆز هەتا کاتی هاتنە دەرەوەی، کەفارەت بۆ خۆی و ماڵەکەی و هەموو کۆمەڵی ئیسرائیل بکات. ");
INSERT INTO ckb_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","«ئینجا بچێتە دەرەوە بۆ لای قوربانگاکەی بەردەم یەزدان و کەفارەتی بۆ بکات، لە خوێنی جوانەگاکە و خوێنی گیسکەکە ببات و بەسەر قۆچەکانی قوربانگاکەیدا بکات. ");
INSERT INTO ckb_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","بە پەنجەی حەوت جار لە خوێنەکە بەسەریدا بپرژێنێت و لە گڵاوییەکانی نەوەی ئیسرائیل پاکی بکاتەوە و تەرخانی بکات. ");
INSERT INTO ckb_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","«کاتێک هارون لە کەفارەتکردن بۆ شوێنی هەرەپیرۆز و چادری چاوپێکەوتن و قوربانگاکە تەواو بوو، گیسکە زیندووەکە پێشکەش بکات. ");
INSERT INTO ckb_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","هارون هەردوو دەستی لەسەر سەری گیسکە زیندووەکە دابنێت و لەسەری دان بە هەموو تاوان و هەموو یاخیبوونەکان و هەموو گوناهەکانی نەوەی ئیسرائیلدا بنێت، بەمە گوناهەکان دەخاتە سەر گیسکەکە. هارون لەژێر چاودێری ئەو کەسەی هەڵبژێردراوە بۆ ئەم ئیشە گیسکەکە بنێرێتە چۆڵەوانی. ");
INSERT INTO ckb_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","گیسکەکە هەموو تاوانەکانیان هەڵدەگرێت بۆ خاکێکی چۆڵ، ئینجا کەسەکە گیسکەکە لە چۆڵەوانی بەڕەڵا بکات. ");
INSERT INTO ckb_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","«ئینجا هارون بچێتە ناو چادری چاوپێکەوتن و جلە کەتانەکانی دابکەنێت کە لە چوونە ژوورەوەی بۆ شوێنی هەرەپیرۆز لەبەری کردبوو، لەوێ دایبنێت. ");
INSERT INTO ckb_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","لە شوێنێکی پیرۆز بە ئاو خۆی بشوات. ئینجا جلەکانی لەبەر بکات و بچێتە دەرەوە و قوربانی سووتاندن بۆ خۆی و قوربانی سووتاندن بۆ گەل بکات، کەفارەت بۆ خۆی و بۆ گەل بکات. ");
INSERT INTO ckb_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","پیوی قوربانییەکەی گوناهیش لەسەر قوربانگاکە بسووتێنێت. ");
INSERT INTO ckb_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","«ئەو کەسەی گیسکەکەشی بەرەو عەزازێل بەڕەڵا کرد، جلەکانی بشوات و خۆی بە ئاو بشوات، پاشان بچێتە ناو ئۆردوگاکە. ");
INSERT INTO ckb_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","جوانەگاکەی قوربانی گوناه و گیسکەکەی قوربانی گوناهیش، ئەوانەی خوێنەکەیان بردرا بۆ کەفارەتکردن لە شوێنی هەرەپیرۆز، ئەوا بیانباتە دەرەوەی ئۆردوگاکە و پێست و گۆشت و ڕیخۆڵەکەیان بە ئاگر بسووتێنن. ");
INSERT INTO ckb_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","ئەوەی دەشیانسووتێنێت، جلەکانی بشوات و خۆی بە ئاو بشوات، پاشان بچێتە ناو ئۆردوگاکە. ");
INSERT INTO ckb_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","«ئەمەش دەبێتە فەرزێکی هەتاهەتایی بۆتان، کە ئێوە لە دەی مانگی حەوت گیانی خۆتان زەلیل دەکەن و هیچ کارێک ناکەن، نە هاوڵاتی و نە ئەو نامۆیەی لەنێوتانە، ");
INSERT INTO ckb_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","چونکە لەم ڕۆژەدا کەفارەتتان بۆ دەکرێت بۆ پاکبوونەوەتان، لە هەموو گوناهەکانتان لەبەردەم یەزدان پاک دەبنەوە. ");
INSERT INTO ckb_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","ئەمە شەممەیە، پشوودانە بۆتان، فەرزێکی هەتاهەتاییشە کە گیانی خۆتان زەلیل بکەن. ");
INSERT INTO ckb_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","ئەو کاهینەش کە بە زەیت دەستنیشان دەکرێت و ئەرکی پێ دەسپێردرێت بۆ ئەوەی لە جیاتی باوکی ببێتە سەرۆک کاهین کەفارەت بکات، جلە کەتانەکان لەبەر بکات، جلە پیرۆزەکان، ");
INSERT INTO ckb_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","کەفارەت بۆ شوێنی هەرەپیرۆز و چادری چاوپێکەوتن و قوربانگاکە بکات. هەروەها کەفارەت بۆ کاهینەکان و هەموو کۆمەڵی گەل بکات. ");
INSERT INTO ckb_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","«ئەمەش دەبێتە فەرزێکی هەتاهەتایی بۆتان بۆ کەفارەتکردن بۆ نەوەی ئیسرائیل لە هەموو گوناهەکانیان، ساڵی جارێک.» ئیتر ئاوا کرا، وەک یەزدان فەرمانی بە موسا کرد. ");
INSERT INTO ckb_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","هەروەها یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","«لەگەڵ هارون و کوڕەکانی و هەموو نەوەی ئیسرائیل بدوێ و پێیان بڵێ: ”ئەمە ئەو فەرمانەیە کە یەزدان فەرمانی پێدەدات و دەفەرموێت، ");
INSERT INTO ckb_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","هەرکەسێک لە گەلی ئیسرائیل گایەک یان بەرخێک یان گیسکێک لە ئۆردوگاکە یان لە دەرەوەی ئۆردوگاکە سەرببڕێت و ");
INSERT INTO ckb_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","نەیهێنێتە لای دەروازەی چادری چاوپێکەوتن هەتا لەبەردەم چادری پەرستنی یەزدان قوربانی بۆ یەزدان پێشکەش بکات، ئەوا ئەو کەسە تاوانبارە لە خوێنڕشتن، خوێنی ڕشتووە، جا دەبێت ئەو کەسە لە گەلەکەی داببڕدرێت. ");
INSERT INTO ckb_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","ئەمەش بۆ ئەوەی نەوەی ئیسرائیل چیتر قوربانییەکانیان لە دەشتودەر سەر نەبڕن و بیانهێنن بۆ بەردەم دەروازەی چادری چاوپێکەوتن و لەلای کاهین پێشکەشی یەزدان بکەن، وەک قوربانی هاوبەشی بۆ یەزدانیان سەرببڕن. ");
INSERT INTO ckb_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","کاهینەکەش خوێنەکە بەسەر قوربانگاکەی یەزداندا دەکات لەلای دەروازەی چادری چاوپێکەوتن و پیوەکەی بۆ ئەو بۆنەی یەزدان پێی خۆشە دەیسووتێنێت. ");
INSERT INTO ckb_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","پێویستە لەمەودوا قوربانییەکان بۆ ئەو بتانە پێشکەش نەکەن کە لە شێوەی تەگە دروستکراون و لەشفرۆشیی ڕۆحییان بۆ دەکەن. ئەمە دەبێتە فەرزێکی هەتاهەتایی بۆیان لە نەوەکانیان.“ ");
INSERT INTO ckb_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","«هەروەها پێیان دەڵێیت: ”هەرکەسێک لە گەلی ئیسرائیل و ئەو نامۆیانەی لەنێوتاندان ئەگەر قوربانی سووتاندن یان قوربانی بکات و ");
INSERT INTO ckb_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","نەیهێنێتە لای دەروازەی چادری چاوپێکەوتن، بۆ ئەوەی بۆ یەزدانی بکات، ئەوا ئەو کەسە لە گەلەکەی دادەبڕدرێت. ");
INSERT INTO ckb_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","«”هەروەها هەرکەسێک لە گەلی ئیسرائیل و ئەو نامۆیانەی لەنێوتاندان، ئەگەر خوێن بخوات، ئەوا ڕووم لەو کەسە وەردەگێڕم کە خوێن دەخوات و لە گەلەکەی ڕیشەکێشی دەکەم، ");
INSERT INTO ckb_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","چونکە ژیانی بوونەوەر لە خوێندایە و من لەسەر قوربانگا بە ئێوەی دەدەم بۆ کەفارەتکردن بۆ گیانتان، چونکە خوێن کەفارەت بۆ ژیان دەکات، ");
INSERT INTO ckb_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","بۆیە بە نەوەی ئیسرائیل دەڵێم: ’کەس لە ئێوە خوێن نەخوات و ئەو نامۆیەش کە لەنێوتاندایە خوێن نەخوات.‘ ");
INSERT INTO ckb_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","«”هەرکەسێک لە نەوەی ئیسرائیل و ئەو نامۆیانەی لەنێوتاندان، کە نێچیرێکی ڕاوکرد، ئاژەڵێکی کێوی یان باڵندەیەک لەوانەی دەخورێن، خوێنەکەی دەڕێژێت و بە خۆڵ دایدەپۆشێت، ");
INSERT INTO ckb_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","چونکە ژیانی هەر بوونەوەرێک خوێنەکەیەتی، جا بە نەوەی ئیسرائیلم گوت: ’خوێنی هیچ بوونەوەرێک مەخۆنەوە، چونکە ژیانی هەر بوونەوەرێک خوێنەکەیەتی، هەرکەسێک بیخوات لە گەل دادەبڕدرێت.‘ ");
INSERT INTO ckb_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","«”هەرکەسێکیش ئاژەڵێکی مرداربووەوە یان نێچیرێک بخوات، هاوڵاتی بێت یان نامۆ، دەبێت جلەکانی بشوات و خۆی بە ئاو بشوات و هەتا ئێوارە گڵاو دەبێت، ئینجا پاک دەبێتەوە. ");
INSERT INTO ckb_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","بەڵام ئەگەر جلەکانی نەشوات و خۆی نەشوات، تاوانی خۆی لە ئەستۆ دەگرێت.“» ");
INSERT INTO ckb_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","هەروەها یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","«لەگەڵ نەوەی ئیسرائیل بدوێ و پێیان بڵێ: ”من یەزدانی پەروەردگارتانم. ");
INSERT INTO ckb_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","وەک نەریتی خاکی میسر مەکەن کە تێیدا نیشتەجێ بوون و وەک نەریتی خاکی کەنعان مەکەن کە ئێوە دەهێنم بۆی و نەریتەکانیان بەجێمەهێنن. ");
INSERT INTO ckb_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","پێویستە ملکەچی یاساکانی من بن و فەرزەکانم بەجێبهێنن بۆ ئەوەی پەیڕەویان بکەن، من یەزدانی پەروەردگارتانم. ");
INSERT INTO ckb_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","فەرز و یاساکانم پەیڕەو بکەن، چونکە ئەو کەسەی پەیڕەویان بکات، بە هۆیانەوە دەژیێت، من یەزدانم. ");
INSERT INTO ckb_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","«”هیچ کەسێک لە کەسوکاری خۆی نزیک نەبێتەوە، بۆ جووت بوون لەگەڵی، من یەزدانم. ");
INSERT INTO ckb_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","«”ناموسی باوکت مەبە و ناموسی دایکت مەبە، لەگەڵ دایکت جووت مەبە، چونکە دایکتە. ");
INSERT INTO ckb_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","«”لەگەڵ باوەژنت جووت مەبە، ئەوە ناموسی باوکتە. ");
INSERT INTO ckb_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","«”لەگەڵ خوشکت، کچی باوکت یان کچی دایکت جووت مەبە، ئەگەر لە ماڵتان لەدایک بووبێت یان لە دەرەوە. ");
INSERT INTO ckb_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","«”لەگەڵ کچی کوڕەکەت یان کچی کچەکەت جووت مەبە، ئەوە ناموسی تۆیە. ");
INSERT INTO ckb_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","«”لەگەڵ کچی ژنی باوکت کە لە باوکتەوە بووە، جووت مەبە، چونکە خوشکتە. ");
INSERT INTO ckb_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","«”لەگەڵ خوشکی باوکت جووت مەبە، چونکە پوورتە. ");
INSERT INTO ckb_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","«”لەگەڵ خوشکی دایکت جووت مەبە، چونکە پوورتە. ");
INSERT INTO ckb_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","«”ناموسی مامت مەبە، لە ژنەکەی نزیک مەکەوە و لەگەڵی جووت مەبە، چونکە مامۆژنتە. ");
INSERT INTO ckb_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","«”لەگەڵ بووکەکەت جووت مەبە، ژنی کوڕتە، لەگەڵی جووت مەبە. ");
INSERT INTO ckb_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","«”لەگەڵ براژنەکەت جووت مەبە، ئەوە ناموسی براتە. ");
INSERT INTO ckb_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","«”لەگەڵ ژنێک و کچەکەی جووت مەبە، لەگەڵ کچی کوڕەکەی یان کچی کچەکەی جووت مەبە، ئەوان نزیکی ژنەکەن و ئەوە ئەوپەڕی بەدڕەوشتییە. ");
INSERT INTO ckb_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","«”هیچ ژنێکیش بەسەر خوشکەکەی مەخوازە هەتا ببێت بە هەوێی، هەتا لەگەڵی جووت بیت، کاتێک ژنەکەت لە ژیاندایە. ");
INSERT INTO ckb_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","«”لە هیچ ژنێکیش نزیک مەکەوە لە ماوەی گڵاوی خوێنلێچوونی مانگانەی بۆ ئەوەی لەگەڵی جووت بیت. ");
INSERT INTO ckb_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","«”لەگەڵ ژنی کەسێکی دیکە جووت مەبە، پێی گڵاو دەبیت. ");
INSERT INTO ckb_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","«”منداڵەکانت وەک قوربانی مەسووتێنە بۆ ’مۆلەخ‘، نەوەک ناوی خودای خۆت بزڕێنیت، من یەزدانم. ");
INSERT INTO ckb_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","«”لەگەڵ نێرێک جووت مەبە وەک جووتبوونت لەگەڵ ژن، ئەوە قێزەونە. ");
INSERT INTO ckb_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","«”لەگەڵ هیچ ئاژەڵێکیش جووت مەبە، پێی گڵاو دەبیت، هیچ ئافرەتێک لەبەردەم ئاژەڵ ئامادە نەبێت بۆ جووتبوون، ئەوە ئەوپەڕی بەدڕەوشتییە. ");
INSERT INTO ckb_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","«”بە هیچ یەکێک لەو ڕەفتارانە خۆتان گڵاو مەکەن، چونکە ئەو نەتەوانەی وا من ڕاویان دەنێم لەبەردەمتان بە هەموو ئەمانە گڵاو بوون. ");
INSERT INTO ckb_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","تەنانەت خاکەکە گڵاو بوو، منیش سزای تاوانەکەی دەدەم و خاکەکەش دانیشتووانەکەی دەڕشێنێتەوە. ");
INSERT INTO ckb_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","بەڵام ئێوە فەرزەکان بەجێدەهێنن و یاساکانم پەیڕەو دەکەن. هیچ کارێک لە هەموو ئەو کردەوە قێزەونانە ناکەن، نە هاوڵاتی و نە ئەو نامۆیەی لەنێوتاندایە. ");
INSERT INTO ckb_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","پێش ئێوە خەڵکی خاکەکە هەموو ئەو کردەوە قێزەونانەیان کردووە، هەر بۆیە خاکەکە گڵاو بوو. ");
INSERT INTO ckb_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","ئەگەر خاکەکە گڵاو بکەن، ئەوا ئێوەش دەڕشێنێتەوە، وەک چۆن ئەو نەتەوانەی پێش ئێوەی ڕشاندەوە. ");
INSERT INTO ckb_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","«”بەڵکو هەرکەسێک کارێک لە هەموو ئەو کردەوە قێزەونانە ئەنجام بدات، ئەو کەسەی ئەوە دەکات لە گەلەکەی دادەبڕدرێت. ");
INSERT INTO ckb_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","جا فەرزەکانم بەجێبهێنن هەتا هیچ لەو نەریتە قێزەونانە نەکەن و پێی گڵاو نەبن کە پێش ئێوە کراون، من یەزدانی پەروەردگارتانم.“» ");
INSERT INTO ckb_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","هەروەها یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","«لەگەڵ هەموو کۆمەڵی نەوەی ئیسرائیل بدوێ و پێیان بڵێ: ”دەبێت پیرۆز بن، چونکە من پیرۆزم، یەزدانی پەروەردگارتانم. ");
INSERT INTO ckb_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","«”هەر یەکێک لە ئێوە، دەبێت ڕێزی دایک و باوکی خۆی بگرێت و شەممەکانم بپارێزن، من یەزدانی پەروەردگارتانم. ");
INSERT INTO ckb_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","«”ئاوڕ لە بت مەدەنەوە و خوداوەندی لەقاڵبدراو بۆ خۆتان دروستمەکەن، من یەزدانی پەروەردگارتانم. ");
INSERT INTO ckb_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","«”کاتێک قوربانییەکی هاوبەشی بۆ یەزدان سەردەبڕن، با بە شێوەیەک بێت لەبەردەم یەزدان قبوڵ بێت، ");
INSERT INTO ckb_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","ئەو ڕۆژەی سەری دەبڕن دەیخۆن لەگەڵ ڕۆژی پاشتر. ئەوەی لێی دەمێنێتەوە بۆ ڕۆژی سێیەم، دەبێت بە ئاگر بسووتێنرێت. ");
INSERT INTO ckb_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","ئەگەر لە ڕۆژی سێیەمدا بخورێت، ئەوە گڵاوە و قبوڵ نییە. ");
INSERT INTO ckb_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","ئەوەی لێی بخوات ئەوا تاوانی خۆی لە ئەستۆ دەگرێت، چونکە شتێکی پیرۆزی یەزدانی گڵاو کردووە، جا ئەو کەسە لە گەلەکەی دادەبڕدرێت. ");
INSERT INTO ckb_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","«”کاتێک دروێنەی زەوییەکانتان دەکەن، لێوارەکانی کێڵگەکەت مەدورەوە، ئەوەی لە دروێنەکە دەکەوێت، هەڵیمەگرەوە، ");
INSERT INTO ckb_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","پاشماوەی هێشووە ترێیەکان لە مێوەکەت مەکەرەوە و ئەوەی دەکەوێت هەڵیمەگرەوە، بۆ هەژار و نامۆی بەجێبهێڵە. من یەزدانی پەروەردگارتانم. ");
INSERT INTO ckb_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","«”مەدزن. «”درۆ مەکەن. «”فێڵ لە یەکتری مەکەن. ");
INSERT INTO ckb_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","«”بە درۆ سوێند بە ناوی من مەخۆن، چونکە ناوی خوداکەت دەزڕێنیت، من یەزدانم. ");
INSERT INTO ckb_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","«”نزیکەکەت فریومەدە و تاڵانی مەکە. «”کرێی کرێگرتەش لەلای خۆت بۆ بەیانی مەهێڵەوە. ");
INSERT INTO ckb_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","«”نەفرەت لە کەڕ مەکە و کۆسپ مەخەرە بەردەم نابینا، بەڵکو لە خودات بترسە، من یەزدانم. ");
INSERT INTO ckb_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","«”لە دادوەریدا ستەم مەکەن، نە لایەنگری هەژار بکەن و نە پشتی کەسی مەزن بگرن، بەڵکو بە دادپەروەری حوکمی بەرامبەرەکەت بدە. ");
INSERT INTO ckb_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","«”لەنێوان خەڵکی قسە مەهێنە و مەبە. «”مەبە هۆی گیان لەدەستدانی نزیکەکەت، من یەزدانم. ");
INSERT INTO ckb_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","«”لە دڵەوە ڕقت لە براکەت نەبێتەوە، ڕاشکاوانە دراوسێکەت سەرزەنشت بکە، بۆ ئەوەی بەشداری لە گوناهی نەکەیت. ");
INSERT INTO ckb_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","«”تۆڵە مەستێنەوە و قین لە دڵ مەبە بەرامبەر کوڕی گەلەکەت، بەڵکو نزیکەکەت وەک خۆت خۆشبوێت. من یەزدانم. ");
INSERT INTO ckb_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","«”فەرزەکانم بەجێبهێنن. «”دوو جۆری جیا لە ئاژەڵەکانت پێکەوە جووت مەکە. «”دوو جۆر تۆو لە کێڵگەکەت مەڕوێنە. «”با جلێکت لەبەر نەبێت کە دوو جۆر بێت. ");
INSERT INTO ckb_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","«”ئەگەر پیاوێک لەگەڵ ئافرەتێک جووت بوو، ئەویش کەنیزەیەکی مارەبڕ بوو بۆ پیاوێکی دیکە، بەڵام نەکڕابووەوە و ئازاد نەکرابوو، پێویستە سزایەکی گونجاو بدرێت. کەسیان ناکوژرێت، چونکە ئافرەتەکە ئازاد نەکراوە. ");
INSERT INTO ckb_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","دەبێت پیاوەکە قوربانییەک بۆ تاوانەکەی بۆ لای یەزدان بهێنێتە دەروازەی چادری چاوپێکەوتن، بەرانێک وەک قوربانی تاوان. ");
INSERT INTO ckb_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","جا کاهینەکە بە بەرانی قوربانی تاوانەکە لەبەردەم یەزدان کەفارەتی بۆ دەکات لە گوناهەکەی کە کردوویەتی، جا لەو گوناهەی کردوویەتی لێخۆشبوونی بۆ دەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","«”کاتێک چوونە ناو خاکەکە و هەر دارێکتان بۆ خواردن ڕواند، ئەوا بەرەکەی بە قەدەغەکراو بزانن. سێ ساڵ بۆتان قەدەغەکراوە و لێی ناخورێت، ");
INSERT INTO ckb_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","لە ساڵی چوارەمیش هەموو بەروبوومەکەی تەرخانکراو دەبێت بۆ شکۆدارکردنی یەزدان، ");
INSERT INTO ckb_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","بەڵام لە ساڵی پێنجەمدا بەرەکەی بخۆن، هەتا داهاتی بۆتان زیاد بکات، من یەزدانی پەروەردگارتانم. ");
INSERT INTO ckb_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","«”هەر گۆشتێک بە خوێنەوە بوو مەیخۆن. «”فاڵ مەگرنەوە و جادووگەری مەکەن. ");
INSERT INTO ckb_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","«”لاتەنیشتەکانی سەرتان مەتاشن و دەستکاری دوو لای ڕیشتان مەکەن. ");
INSERT INTO ckb_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","«”بۆ مردوو خۆتان بریندار مەکەن، نەخش لە لەشی خۆتان مەکوتن، من یەزدانم. ");
INSERT INTO ckb_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","«”کچەکەت سووک مەکە، بەوەی بیکەیت بە لەشفرۆش، نەوەک خاکەکە پڕ بێت لە لەشفرۆشی و بەدڕەوشتی. ");
INSERT INTO ckb_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","«”شەممەکانم بپارێزن و ڕێز لە پیرۆزگاکەم بگرن، من یەزدانم. ");
INSERT INTO ckb_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","«”مەگەڕێنەوە بۆ لای نێوانگر و بەدوای ڕۆح ئامادەکاردا مەگەڕێن، پێیان گڵاو دەبن، من یەزدانی پەروەردگارتانم. ");
INSERT INTO ckb_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","«”لەبەر ڕیش سپی هەستە و ڕێزی پیر بگرە و لە خودات بترسە، من یەزدانم. ");
INSERT INTO ckb_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","«”ئەگەر نامۆیەک هاتە خاکەکەتان، ستەمی لێ مەکەن، ");
INSERT INTO ckb_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","وەک هاوڵاتییەک ڕەفتاری لەگەڵ بکەن، وەک خۆتت خۆشبوێت، چونکە ئێوەش لە خاکی میسر نامۆ بوون، من یەزدانی پەروەردگارتانم. ");
INSERT INTO ckb_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","«”ساختەکاری مەکەن، نە لە ئەندازەی پێوانە و نە لە کێش و نە لە بڕ، ");
INSERT INTO ckb_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","دەبێت تەرازووی ڕاست و کێشانەی ڕاست و ئێفەی ڕاست و هەینی ڕاستتان هەبێت، من یەزدانی پەروەردگارتانم کە لە خاکی میسر دەریهێنان. ");
INSERT INTO ckb_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","«”هەموو فەرزەکانم بەجێبهێنن و یاساکانم پەیڕەو بکەن و جێبەجێیان بکەن، من یەزدانم.“» ");
INSERT INTO ckb_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","هەروەها یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","«بە نەوەی ئیسرائیل بڵێ: ”هەرکەسێک لە نەوەی ئیسرائیل و لەو نامۆیانەی لە ئیسرائیلن، ئەگەر لە منداڵەکانی بە مۆلەخی بەخشی، دەبێت بکوژرێت. دەبێت خەڵکی ناوچەکە بەردبارانی بکەن. ");
INSERT INTO ckb_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","منیش ڕووم لەو کەسە وەردەگێڕم و لە گەلەکەی ڕیشەکێشی دەکەم، چونکە لە منداڵەکانی خۆی بە مۆلەخی بەخشی، بۆ ئەوەی پیرۆزگاکەم گڵاو بکات و ناوی پیرۆزم بزڕێنێت. ");
INSERT INTO ckb_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","ئەگەر خەڵکی ناوچەکە چاوپۆشییان لەو کەسە کرد، کاتێک یەکێک لە منداڵەکانی خۆی بە مۆلەخ بەخشی، ئینجا نەیانکوشت، ");
INSERT INTO ckb_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","ئەوا من ڕووی خۆم لەو کەسە و لە ماڵەکەی وەردەگێڕم و لەنێو گەلەکەیان دەیانبڕمەوە. هەمان شت بەوانەش دەکەم کە لە ڕێگەی پەرستنی مۆلەخەوە، لەشفرۆشیی ڕۆحی دەکەن. ");
INSERT INTO ckb_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","«”من ڕووم لەو کەسە وەردەگێڕم کە دەگەڕێتەوە بۆ لای نێوانگر و ڕۆح ئامادەکار تاکو بە شوێنکەوتنیان لەشفرۆشیی ڕۆحی بکات، ئەوا من ئەو کەسە لە گەلەکەی ڕیشەکێش دەکەم. ");
INSERT INTO ckb_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","«”خۆتان تەرخان بکەن و پیرۆز بن، چونکە من یەزدانی پەروەردگارتانم، ");
INSERT INTO ckb_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","فەرزەکانم بەجێبهێنن و جێبەجێیان بکەن، من یەزدانم کە پیرۆزتان دەکات. ");
INSERT INTO ckb_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","«”هەرکەسێک نەفرەت لە باوکی یان دایکی بکات، دەبێت بکوژرێت، نەفرەتی لە باوکی یان دایکی کردووە، خوێنی لە ئەستۆی خۆیەتی. ");
INSERT INTO ckb_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","«”ئەگەر پیاوێک داوێنپیسی لەگەڵ ژنی کەسێکی دیکەدا کرد، کە ژنی نزیکەکەیەتی، ئەوا پیاوەکە و ژنەکەش دەبێت بکوژرێن. ");
INSERT INTO ckb_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","«”ئەگەر پیاوێک لەگەڵ باوەژنی خۆی جووت بوو، ئەوا ناموسی باوکی بردووە، هەردووکیان دەبێت بکوژرێن، خوێنیان لە ئەستۆی خۆیانە. ");
INSERT INTO ckb_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","«”ئەگەر پیاوێک لەگەڵ ژنی کوڕەکەی جووت بوو، ئەوا هەردووکیان دەبێت بکوژرێن، ئەوپەڕی بەدڕەوشتییان کردووە، خوێنیان لە ئەستۆی خۆیانە. ");
INSERT INTO ckb_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","«”ئەگەر پیاوێک وەک ژن لەگەڵ نێرێک ڕاکشا بوو، ئەوا هەردووکیان شتێکی قێزەونیان کردووە و دەبێت بکوژرێن، خوێنیان لە ئەستۆی خۆیانە. ");
INSERT INTO ckb_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","«”ئەگەر پیاوێک ئافرەتێک لەگەڵ دایکەکەی بخوازێت، ئەوە بەدکارییە، پیاوەکە و هەردوو ژنەکە دەبێت بە ئاگر بسووتێنرێن، هەتا بەدکاری لەنێوتاندا نەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","«”ئەگەر پیاوێک لەگەڵ ئاژەڵێکدا جووت بوو، دەبێت پیاوەکە بکوژرێت و ئاژەڵەکەش بکوژرێت. ");
INSERT INTO ckb_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","«”ئەگەر ئافرەتێک لە ئاژەڵێک نزیک بووەوە بۆ جووتبوون، ئەوا ئافرەتەکە و ئاژەڵەکەش بکوژن، خوێنیان لە ئەستۆی خۆیانە. ");
INSERT INTO ckb_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","«”ئەگەر پیاوێک خوشکی خۆی هێنا، کچی باوکی یان کچی دایکی و لەگەڵ یەک جووت بوون، ئەوا ڕیسواییە، دەبێت لەبەرچاوی گەلەکەیان ببڕدرێتەوە، ناموسی خوشکی خۆی بردووە، تاوانی خۆی لە ئەستۆ دەگرێت. ");
INSERT INTO ckb_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","«”ئەگەر پیاوێک لەگەڵ ژنێک جووت بوو لە ڕۆژانی خوێنلێچوونی مانگانەی، ئەوا دەبێت هەردووکیان لە گەلەکەیان داببڕدرێن، چونکە پیاوەکە خوێنلێچوونی ئافرەتەکەی ئاشکرا کردووە و ئافرەتەکەش خوێنلێچوونی خۆی ئاشکرا کردووە. ");
INSERT INTO ckb_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","«”لەگەڵ خوشکی باوکت یان خوشکی دایکت جووت مەبە، ئەوەی وا بکات، ئەوا هەردووکیان تاوانی خۆیان لە ئەستۆ دەگرن، چونکە ناموسی کەسوکاری خۆی بردووە. ");
INSERT INTO ckb_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","«”ئەگەر پیاوێک لەگەڵ مامۆژنی خۆی جووت بوو، ئەوا ناموسی مامی خۆی بردووە، هەردووکیان تاوانیان لە ئەستۆ دەبێت، دەبێت بە وەجاخکوێری بمرن. ");
INSERT INTO ckb_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","«”ئەگەر پیاوێک براژنی خۆی هێنا ئەوا گڵاوییە، ناموسی براکەی بردووە، دەبێت هەردووکیان وەجاخکوێر بن. ");
INSERT INTO ckb_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","«”هەموو فەرزەکانم بەجێبهێنن و یاساکانم پەیڕەو بکەن و جێبەجێیان بکەن، بۆ ئەوەی ئەو خاکە نەتانڕشێنێتەوە کە بۆ نیشتەجێبوون دەتانهێنمە ناوی. ");
INSERT INTO ckb_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","بە ڕێی نەریتی ئەو نەتەوانەدا مەڕۆن کە من لەپێشتانەوە دەریاندەکەم، چونکە هەموو ئەم شتانەیان کرد، جا ڕقم لێیان بووەوە. ");
INSERT INTO ckb_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","بەڵام بە ئێوەم فەرموو کە دەبنە خاوەنی خاکەکەیان، من دەیدەمە ئێوە هەتا ببنە میراتگری، خاکێک شیر و هەنگوینی لێ بڕژێت، من یەزدانی پەروەردگارتانم کە لەنێو گەلان جیای کردنەوە. ");
INSERT INTO ckb_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","«”لەبەر ئەوە ئێوەش ئاژەڵی پاک و گڵاو لە یەکتر جیا بکەنەوە، هەروەها باڵندەی گڵاو و پاکیش، جا خۆتان گڵاو مەکەن بە ئاژەڵ و باڵندە و هەموو ئەوەی لەسەر زەوی دەخشێت، لەوانەی بۆم جیا کردنەوە، گوتم، گڵاون. ");
INSERT INTO ckb_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","دەبێت بۆ من پیرۆز بن، چونکە من پیرۆزم، من یەزدانم، ئێوەم لەنێو گەلان جیا کردەوە هەتا بۆ من بن. ");
INSERT INTO ckb_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","«”ئەگەر پیاوێک یان ئافرەتێک نێوانگر یان ڕۆح ئامادەکار بوو، دەبێت بکوژرێت، بەردبارانیان بکەن، خوێنیان لە ئەستۆی خۆیانە.“» ");
INSERT INTO ckb_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","هەروەها یەزدان بە موسای فەرموو: «لەگەڵ کاهینەکان بدوێ کە نەوەی هارونن و پێیان بڵێ: ”نابێت بەپێی ڕێوڕەسم کەستان بە مردووێکی هۆزەکەی خۆی گڵاو بکات، ");
INSERT INTO ckb_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","تەنها بۆ ئەوانە نەبێت کە زۆر نزیکن لێی، دایکی و باوکی و کوڕی و کچی و برای و ");
INSERT INTO ckb_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","خوشکە پاکیزەکەی کە لێی نزیکە، ئەوەی شووی نەکردووە، دەشێت لە پێناویدا گڵاو بێت. ");
INSERT INTO ckb_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","نابێت خۆی گڵاو بکات بەوانەی لە ڕێگەی ژنهێنانەوە بوونەتە خزمی ئەو. ");
INSERT INTO ckb_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","«”کاهینەکان نابێت سەریان سفر بکەن و هەردوو لای ڕیشیان بتاشن و خۆیان بریندار بکەن. ");
INSERT INTO ckb_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","دەبێت بۆ خوداکەیان پیرۆز بن و ناوی خودایان نەزڕێنن، چونکە قوربانییە بە ئاگرەکان وەک نانی خودایان بۆ یەزدان پێشکەش دەکەن، جا دەبێت پیرۆز بن. ");
INSERT INTO ckb_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","«”نابێت کاهینەکان ئافرەتی لەشفرۆشی بێ ئابڕوو و تەڵاقدراو بخوازن، چونکە کاهین پیرۆزکراوە بۆ خوداکەی، ");
INSERT INTO ckb_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","جا بە پیرۆزی دابنێن، چونکە نانی خوداتان پێشکەش دەکات، پیرۆزکراو دەبێت لەلاتان، چونکە من پیرۆزم. من یەزدانم ئەوەی پیرۆزتان دەکات. ");
INSERT INTO ckb_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","«”ئەگەر کچی کاهین بە لەشفرۆشی گڵاو بوو، ئەوا باوکی گڵاو کردووە، دەبێت کچەکە بە ئاگر بسووتێنرێت. ");
INSERT INTO ckb_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","«”سەرۆکی کاهینان، ئەوەی لەنێو براکانی زەیتی دەستنیشانکردنی بە سەریدا کراوە و ئەرک پێ سپێردراوە بۆ لەبەرکردنی جلەکانی کاهینیێتی، پێویستە سەری ڕووت نەکات و جلەکانی لەبەر خۆی دانەدڕێت. ");
INSERT INTO ckb_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","پێویستە نەیەتە ئەو شوێنەی لاشەی مردووی لێیە، نابێت خۆی بۆ دایک و باوکیشی گڵاو بکات. ");
INSERT INTO ckb_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","نابێت لە پیرۆزگا دەربچێت، نەوەک پیرۆزگای خوداکەی گڵاو بکات، چونکە بە زەیتی دەستنیشانکردنی خودا نەزرکراوە، من یەزدانم. ");
INSERT INTO ckb_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","«”ئەم دەبێت کچێکی پاکیزە بخوازێت. ");
INSERT INTO ckb_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","نابێت بێوەژن و تەڵاقدراو و بێ ئابڕووی لەشفرۆش بخوازێت، بەڵکو دەبێت کچێکی پاکیزە لە خزمەکانی بخوازێت، ");
INSERT INTO ckb_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","بۆ ئەوەی وەچەکەی لەنێو گەلەکەی گڵاو نەکات. من یەزدانم، ئەوم پیرۆز کردووە.“» ");
INSERT INTO ckb_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","هەروەها یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","«لەگەڵ هارون بدوێ و بڵێ: ”ئەگەر پیاوێک لە وەچەی تۆ لە نەوەکانیان کەموکوڕییەکی تێدابوو، با نەیەتە پێشەوە بۆ پێشکەشکردنی نانی خوداکەی. ");
INSERT INTO ckb_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","هەر پیاوێک کەموکوڕی تێدابێت، نابێت بێتە پێشەوە، نە پیاوی نابینا و نە شەل و نە دەموچاو خوار و نە شێوە تێکچوو، ");
INSERT INTO ckb_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","نە پیاوی دەست یان پێ گۆج، ");
INSERT INTO ckb_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","نە قەمبوور، نە کورتەباڵا، نە ئەوەی کە کەموکوڕی لە چاویدا هەیە یان زام و برینێکی بەردەوامی هەیە و نە قۆڕ. ");
INSERT INTO ckb_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","هەر پیاوێک لە نەوەی هارونی کاهین کەموکوڕی تێدابێت، نابێت بێتە پێشەوە بۆ پێشکەشکردنی قوربانییە بە ئاگرەکان بۆ یەزدان؛ لەبەر ئەوەی کەموکوڕی تێدایە، پێویستە نەیەتە پێشەوە بۆ پێشکەشکردنی نانی خوداکەی. ");
INSERT INTO ckb_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","دەتوانێت لە نانی خوداکەی بخوات، لە پێشکەشکراوە پیرۆزەکە و لە خواردنە هەرەپیرۆزەکانیش؛ ");
INSERT INTO ckb_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","بەڵام نابێت بێتە لای پەردەکە و لە قوربانگاکەش نزیک بکەوێتەوە، چونکە کەموکوڕی تێدایە، نەوەک پیرۆزگام گڵاو بکات، چونکە من یەزدانم، کە پیرۆزیان دەکەم.“» ");
INSERT INTO ckb_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","ئینجا موسا لەگەڵ هارون و کوڕەکانی و هەموو نەوەی ئیسرائیلدا دوا. ");
INSERT INTO ckb_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","هەروەها یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","«بە هارون و کوڕەکانی بڵێ: ”با ئاگاداری خۆیان بن لە قوربانییە پیرۆزەکانی نەوەی ئیسرائیل و ناوی پیرۆزی من نەزڕێنن، ئەوانەی بۆ منی تەرخان دەکەن، من یەزدانم.“ ");
INSERT INTO ckb_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","«پێیان بڵێ: ”نەوە لەدوای نەوە، ئەگەر هەرکەسێک لە نەوەکانتان بەپێی ڕێوڕەسم گڵاو بێت و لە قوربانییە پیرۆزەکان نزیک بووەوە کە نەوەی ئیسرائیل بۆ یەزدانی تەرخان دەکەن، ئەوا ئەو کەسە لەبەردەمم دوور دەخرێتەوە. من یەزدانم. ");
INSERT INTO ckb_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","«”هەرکەسێک لە نەوەی هارون کە نەخۆشی گواستراوەی پێست یان لێچوونی هەبێت، هەتا پاک دەبێتەوە لە قوربانییە پیرۆزەکان نەخوات. هەر یەکێکیش دەست لە شتێکی گڵاوی مردووێک بدات، یان کەسێک تۆوی لێچووبوو، ");
INSERT INTO ckb_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","یان دەستی لە خشۆکێک دابێت کە پێی گڵاو بێت، یان لە مرۆڤێک کە پێی گڵاو بێت لەبەر هەر گڵاوییەک کە هەیەتی، ");
INSERT INTO ckb_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","ئەوەی دەست لە هەریەک لەو شتانە بدات ئەوا هەتا ئێوارە گڵاو دەبێت و نابێت لە قوربانییە پیرۆزەکان بخوات هەتا خۆی بە ئاو نەشوات. ");
INSERT INTO ckb_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","کاتێک خۆر ئاوا دەبێت، پاک دەبێتەوە و پاشان لە قوربانییە پیرۆزەکان بخوات، چونکە خۆراکی ئەوە. ");
INSERT INTO ckb_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","نابێت ئاژەڵی مردارەوەبوو و نێچیر بخوات، چونکە پێی گڵاو دەبێت. من یەزدانم. ");
INSERT INTO ckb_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","«”کاهینەکان دەبێت خواستەکانم بپارێزن، نەوەک گوناهێک هەڵبگرن کە پێی بمرن، ئەگەر بە سووکی ڕەفتاری لەگەڵ بکەن. من یەزدانم کە پیرۆزیان دەکەم. ");
INSERT INTO ckb_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","«”نابێت کەس لە قوربانی پیرۆزکراو بخوات جگە لە کەسوکاری کاهینەکە. میوان و کرێگرتەی کاهینیش نابێت لە قوربانی پیرۆزکراو بخۆن، ");
INSERT INTO ckb_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","بەڵام ئەگەر کاهین کۆیلەیەکی بە زیو کڕی، یان کۆیلەیەک لە ماڵەکەی لە دایک بێت، ئەوا ئەو کۆیلەیە دەتوانێت لێی بخوات، ئەوان لە خۆراکەکەی دەخۆن. ");
INSERT INTO ckb_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","ئەگەر کچی کاهین شووی بە پیاوێکی جگە لە کاهین کرد، ئەوا نابێت لە بەخشینە پیرۆزەکان بخوات. ");
INSERT INTO ckb_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","بەڵام ئەگەر کچی کاهین بوو بە بێوەژن یان تەڵاق درا و هیچ وەچەی نەبوو و هاتەوە ماڵی باوکی، وەک کاتی کچێنی، ئەوا دەتوانێت لە خۆراکی باوکی بخوات. بەڵام نابێت کەسێکی دیکە لێی بخوات، جگە لە کەسوکاری کاهینەکە. ");
INSERT INTO ckb_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","«”ئەگەر کەسێک بە هەڵە قوربانییەکی پێشکەشکراوی خوارد، ئەوا دەبێت پێنجیەکی زیاد بخاتە سەر و قوربانییە پیرۆزەکە بداتە کاهینەکە. ");
INSERT INTO ckb_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","کاهینەکان نابێت قوربانییە پیرۆزەکانی نەوەی ئیسرائیل گڵاو بکەن کە لەبەردەم یەزدان دایدەنێن، ");
INSERT INTO ckb_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","ئەگەر ڕێیان پێبدەن قوربانییە پیرۆزەکانیان بخۆن ئەوا گوناهیان دەخەنە ئەستۆ، چونکە من یەزدانم کە پیرۆزیان دەکەم.“» ");
INSERT INTO ckb_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","هەروەها یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","«لەگەڵ هارون و کوڕەکانی و هەموو نەوەی ئیسرائیل بدوێ و پێیان بڵێ: ”ئەگەر هەر یەکێکتان، ئیسرائیلی بێت یان بیانییەک کە لە ئیسرائیل نیشتەجێیە، بەخشینێک پێشکەش بە یەزدان بکات وەک قوربانی سووتاندن بۆ ئەنجامدانی نەزر یان بەخشینێک کە بە خواستی خۆی بێت، ");
INSERT INTO ckb_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","بۆ ئەوەی لێتان وەربگیرێت، دەبێت نێرێکی ساغ بێت، لە گاگەل یان ماڵات. ");
INSERT INTO ckb_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","هەرچییەک کەموکوڕی تێدابێت پێشکەشی مەکەن، چونکە لێتان وەرناگیرێت. ");
INSERT INTO ckb_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","ئەگەر کەسێک قوربانی هاوبەشی پێشکەشی یەزدان کرد، بۆ بەجێهێنانی نەزرێکی تایبەت یان بەخشینێکی بە خواستی خۆی، لە گاگەل یان لە مێگەل، دەبێت ساغ بێت بۆ ئەوەی قبوڵ بکرێت. نابێت هیچ کەموکوڕییەکی تێدابێت. ");
INSERT INTO ckb_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","کوێر و بریندار و پەلشکاو و بالوکەدار و گەڕ و زامداری بەردەوام، ئەمانە پێشکەش بە یەزدان مەکەن و لێیان مەکەن بە قوربانی بە ئاگر لەسەر قوربانگاکەی یەزدان. ");
INSERT INTO ckb_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","بەڵام گا و بەرانی شێوە تێکچوو و کورتەباڵا دەتوانیت بکەیت بە بەخشینێک بە خواستی خۆت، بەڵام بۆ تەواوبوونی نەزر قبوڵ نابێت. ");
INSERT INTO ckb_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","پێویستە ئاژەڵێک نەکەنە قوربانی بۆ یەزدان کە گونی قۆڕ بێت یان خەسابێت یان گونی لێکرابێتەوە یانیش بڕا بێت، لە خاکەکەشتان مەیکەن. ");
INSERT INTO ckb_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","لە هەموو ئەمانەش پێویست ناکات بە هەر ئاژەڵێکی دەستی بیانی ڕازی ببن و پێشکەشیان بکەن وەک خواردنی خوداتان. لێتان وەرناگیرێت، چونکە ئەو ئاژەڵانە ناتەواون و کەموکوڕییان تێدایە.“» ");
INSERT INTO ckb_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","هەروەها یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","«کاتێک گوێرەکەیەک یان بەرخێک یان گیسکێک لەدایک دەبێت، ئەوا حەوت ڕۆژ لەژێر دایکی دەبێت و لە ڕۆژی هەشتەم بەدواوە، وەک قوربانی بە ئاگر بۆ یەزدان قبوڵ دەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","مانگا و مەڕیش لە یەک ڕۆژدا لەگەڵ بەچکەکەی سەرمەبڕن. ");
INSERT INTO ckb_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","«کاتێک قوربانی سوپاسگوزاریتان بۆ یەزدان سەربڕی، بە شێوەیەک سەری ببڕن کە لێتان وەربگیرێت، ");
INSERT INTO ckb_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","دەبێت لەو ڕۆژەدا بخورێت، بۆ بەیانی لێی مەهێڵنەوە، من یەزدانم. ");
INSERT INTO ckb_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","«”فەرمانەکانم بپارێزن و جێبەجێیان بکەن، من یەزدانم. ");
INSERT INTO ckb_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","ناوی پیرۆزیشم مەزڕێنن، دەبێت نەوەی ئیسرائیل دان بە پیرۆزی مندا بنێن. من یەزدانم کە پیرۆزیان دەکەم، ");
INSERT INTO ckb_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","ئەوەی لە خاکی میسر دەریهێنان، تاکو ببێتە خوداتان، من یەزدانم.“» ");
INSERT INTO ckb_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","هەروەها یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","«لەگەڵ نەوەی ئیسرائیل بدوێ و پێیان بڵێ: ”ئەمانە جەژنەکانی منن، جەژنەکانی یەزدان کە تێیدا بانگەوازی کۆبوونەوەی پیرۆزبوون دەکەن. ");
INSERT INTO ckb_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","«”شەش ڕۆژ کار بکەن بەڵام ڕۆژی حەوتەم شەممەیە، پشوودانە و کۆبوونەوەی پیرۆزبوونە، هیچ کارێک مەکەن، لە هەموو نشینگەکانتان شەممەیە بۆ یەزدان. ");
INSERT INTO ckb_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","«”ئەمانە جەژنەکانی یەزدانن، کۆبوونەوەی پیرۆزبوونەکان کە دەبێت لە کاتی خۆیدا بانگەوازی بۆ بکەن. ");
INSERT INTO ckb_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","لە ئێوارەوە لە چواردەی مانگی یەک، جەژنی پەسخە بۆ یەزدان دەستپێدەکات. ");
INSERT INTO ckb_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","لە ڕۆژی پازدەی ئەم مانگەدا جەژنی فەتیرە بۆ یەزدان دەستپێدەکات، دەبێت حەوت ڕۆژ نانی فەتیرە بخۆن. ");
INSERT INTO ckb_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","لە ڕۆژی یەکەم کۆبوونەوەی پیرۆزبوون ببەستن، هیچ کارێکی ئاسایی مەکەن. ");
INSERT INTO ckb_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","حەوت ڕۆژ قوربانی بە ئاگر بۆ یەزدان پێشکەش بکەن، لە ڕۆژی حەوتەمیشدا کۆبوونەوەی پیرۆزبوون ببەستن، هیچ کارێکی ئاسایی مەکەن.“» ");
INSERT INTO ckb_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","هەروەها یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","«لەگەڵ نەوەی ئیسرائیل بدوێ و پێیان بڵێ: ”کاتێک هاتنە ئەو خاکەی من پێتانی دەدەم و دەغڵتان دورییەوە، ئەوا یەکەم مەڵۆی دروێنەتان بۆ کاهین بهێنن. ");
INSERT INTO ckb_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","ئەویش دەبێت مەڵۆیەکە لەبەردەم یەزدان بەرز بکاتەوە، بۆ ئەوەی لێتان وەربگیرێت، ڕۆژی پاش شەممە کاهین دەبێت بەرزی بکاتەوە. ");
INSERT INTO ckb_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","لە ڕۆژی بەرزکردنەوەی مەڵۆیەکە، بەرخێکی ساغی یەک ساڵە بکەنە قوربانی سووتاندن بۆ یەزدان، ");
INSERT INTO ckb_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","پێشکەشکراوی دانەوێڵەشی دوو دەیەکی ئێفەیەک لە باشترین ئاردی بە زەیت شێلراو بکە بە قوربانی بە ئاگر بۆ یەزدان، ئەو بۆنەی یەزدان پێی خۆشە، شەرابە پێشکەشکراوەکەشی، چارەکە هەینێک شەرابە. ");
INSERT INTO ckb_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","نان و قەرەخەرمان و گەنمی تازە مەخۆن، هەتا ئەو ڕۆژەی قوربانییەکەی خوداتان دەهێنن، فەرزێکی هەتاهەتاییە لە نەوەکانی ئێوە لە هەموو نشینگەکانتان. ");
INSERT INTO ckb_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","«”ئینجا لە ڕۆژی دوای شەممەوە، لەو ڕۆژەوەی کە مەڵۆیەکە وەک قوربانی بەرزکردنەوە دەهێنن، حەوت هەفتەی تەواو بژمێرن، ");
INSERT INTO ckb_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","هەتا ڕۆژی دوای شەممەی حەوتەم بژمێرن کە پەنجا ڕۆژە، ئینجا پێشکەشکراوێکی دانەوێڵەی نوێ بۆ یەزدان پێشکەش بکەن. ");
INSERT INTO ckb_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","لە نشینگەکانتانەوە دوو نانی وەک قوربانی بەرزکردنەوە بهێنن، لە دوو دەیەکی ئێفەیەک لە باشترین ئارد بێت و بە هەویرترشەوە کرابنە نان، یەکەمین بەرهەمە بۆ یەزدان. ");
INSERT INTO ckb_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","لەگەڵ نانەکان حەوت بەرخی نێری یەک ساڵەی ساغ و جوانەگایەک و دوو بەران بکەنە قوربانی سووتاندن بۆ یەزدان. لەگەڵ پێشکەشکراوە دانەوێڵەکەیان و شەرابە پێشکەشکراوەکەیان، قوربانی بە ئاگرە، ئەو بۆنەی یەزدان پێی خۆشە. ");
INSERT INTO ckb_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","گیسکێکی نێرینەش بکەنە قوربانی گوناه و دوو بەرخی یەک ساڵەش بکەنە قوربانی هاوبەشی. ");
INSERT INTO ckb_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","جا کاهینەکە دەبێت دوو بەرخەکە لەگەڵ نانی یەکەمین بەرهەمەکە لەبەردەم یەزدان بەرز بکاتەوە. ئەمانە پێشکەشکراوێکی پیرۆزن بۆ یەزدان، جا دەبێت بۆ کاهینەکە بن. ");
INSERT INTO ckb_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","لە هەمان ئەو ڕۆژەدا بانگەواز بکەن و کۆبوونەوەی پیرۆزبوونە بۆتان، هیچ کارێکی ئاسایی مەکەن، فەرزێکی هەتاهەتاییە لە هەموو نشینگەکانتان لە نەوەکانتان. ");
INSERT INTO ckb_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","«”کاتێک دروێنەی زەوییەکانتان دەکەن، لێوارەکانی کێڵگەکەت مەدورەوە، ئەوەی لە دروێنەکە دەکەوێت، هەڵیمەگرەوە، بۆ هەژار و نامۆ بەجێی بهێڵە، من یەزدانی پەروەردگارتانم.“» ");
INSERT INTO ckb_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","هەروەها یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","«لەگەڵ نەوەی ئیسرائیل بدوێ و بڵێ: ”یەکەم ڕۆژی مانگی حەوت دەبێت پشوو بێت بۆتان، یادی دەنگی کەڕەنایە، کۆبوونەوەی پیرۆزبوونە. ");
INSERT INTO ckb_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","هیچ کارێکی ئاسایی مەکەن، بەڵام قوربانی بە ئاگر بۆ یەزدان پێشکەش بکەن.“» ");
INSERT INTO ckb_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","هەروەها یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","«بەڵام ڕۆژی دەیەمی ئەم مانگی حەوتە، ڕۆژی کەفارەتە، کۆبوونەوەی پیرۆزبوون ببەستن، گیانی خۆتان زەلیل بکەن و قوربانی بە ئاگر بۆ یەزدان پێشکەش بکەن. ");
INSERT INTO ckb_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","لەو ڕۆژەدا هیچ کارێک مەکەن، چونکە ڕۆژی کەفارەتە بۆ کەفارەتکردن بۆتان لەبەردەم یەزدانی پەروەردگارتان. ");
INSERT INTO ckb_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","هەرکەسێک لەم ڕۆژەدا خۆی زەلیل نەکات لە گەلەکەی دادەبڕدرێت، ");
INSERT INTO ckb_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","هەرکەسێکیش لەم ڕۆژەدا هەر کارێک بکات، ئەوا ئەو کەسە لەنێو گەلەکەی لەناودەبەم. ");
INSERT INTO ckb_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","هیچ کارێک مەکەن، فەرزێکی هەتاهەتاییە بۆ نەوەکانتان لە هەموو نشینگەکانتان. ");
INSERT INTO ckb_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","شەممەیە، پشووە بۆتان، دەبێت گیانی خۆتان زەلیل بکەن. دەبێت لە کاتی ئێوارەی نۆی مانگدا هەتا ئێوارەی دواتر پشوودانی شەممەتان بێت.» ");
INSERT INTO ckb_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","هەروەها یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","«لەگەڵ نەوەی ئیسرائیل بدوێ و بڵێ: ”لە ڕۆژی پازدەیەمی ئەم مانگی حەوتە، حەوت ڕۆژ جەژنی کەپرەشینەیە بۆ یەزدان. ");
INSERT INTO ckb_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","لە ڕۆژی یەکەمدا کۆبوونەوەی پیرۆزبوونە، هیچ کارێکی ئاسایی مەکەن، ");
INSERT INTO ckb_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","حەوت ڕۆژ قوربانی بە ئاگر بۆ یەزدان پێشکەش بکەن. لە ڕۆژی هەشتەمدا کۆبوونەوەی پیرۆزبوون ببەستن و قوربانی بە ئاگر بۆ یەزدان پێشکەش بکەن، ئاهەنگی کۆتایی پێهێنانە، هیچ کارێکی ئاسایی مەکەن. ");
INSERT INTO ckb_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","«”دەبێت لە جەژنەکانتان ئەمانە پێشکەشی یەزدان بکەن کە تێیدا بانگەوازی کۆبوونەوەی پیرۆزبوون دەکەن، بۆ پێشکەشکردنی قوربانی بە ئاگر بۆ یەزدان، قوربانی سووتاندن و پێشکەشکراوی دانەوێڵە و قوربانی سەربڕاو و شەرابی پێشکەشکراو، هەر ڕۆژەو هی خۆی. ");
INSERT INTO ckb_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","جیا لە شەممەکانی یەزدان و جیا لە دیارییەکانتان و هەموو نەزرەکانتان و هەموو بەخشینە ئازادەکانتان کە بە یەزدانی دەدەن. ");
INSERT INTO ckb_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","«”ڕۆژی پازدەی مانگی حەوت، پاش ئەوەی بەروبوومی زەوییەکەتان کۆکردەوە، حەوت ڕۆژ جەژن بۆ یەزدان بگێڕن، لە ڕۆژی یەکەمدا شەممەیە و لە ڕۆژی هەشتەمیشدا شەممەیە. ");
INSERT INTO ckb_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","لە ڕۆژی یەکەمدا بەروبوومی دارەکانی میوە و پەلکی دار خورما و لقەداری پڕ گەڵا و شۆڕەبی ناو چەمەکان بۆ خۆتان ببەن و حەوت ڕۆژ لەبەردەم یەزدانی پەروەردگارتان خۆشی بگێڕن. ");
INSERT INTO ckb_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","حەوت ڕۆژ لە ساڵێکدا بۆ یەزدان بکەن بە جەژن، فەرزێکی هەتاهەتاییە بۆ نەوەکانتان، لە مانگی حەوت بیکەن بە جەژن. ");
INSERT INTO ckb_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","حەوت ڕۆژ لە کەپردا نیشتەجێ بن، هەموو هاوڵاتییەکانی ئیسرائیل دەبێت لە کەپردا نیشتەجێ بن، ");
INSERT INTO ckb_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","بۆ ئەوەی نەوەکانتان بزانن کە من نەوەی ئیسرائیلم لە کەپردا نیشتەجێ کرد، کاتێک لە خاکی میسرم دەرهێنان، من یەزدانی پەروەردگارتانم.“» ");
INSERT INTO ckb_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","جا موسا سەبارەت بە جەژنەکانی یەزدان بە نەوەی ئیسرائیلی ڕاگەیاند. ");
INSERT INTO ckb_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","هەروەها یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","«فەرمان بە نەوەی ئیسرائیل بکە با زەیتی زەیتوونی سادە و گوشراوت بۆ ڕووناکی بۆ بهێنن، هەتا چرا بەردەوام داگیرساو بێت. ");
INSERT INTO ckb_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","لەناو چادری چاوپێکەوتن، لە دەرەوەی پەردەی شوێنی هەرەپیرۆز، هارون لە ئێوارەوە هەتا بەیانی بە بەردەوامی چرادانەکە لەبەردەم یەزدان ڕێک دەخات. فەرزێکی هەتاهەتاییە بۆ نەوەکانتان. ");
INSERT INTO ckb_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","چراکە لەسەر چرادانەکەی کە لە زێڕی بێگەردە پێویستە بە بەردەوامی لەبەردەم یەزدان ڕێکبخرێت. ");
INSERT INTO ckb_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","«باشترین ئاردیش دەبەیت و دەیکەیتە دوازدە کولێرە، بۆ هەر کولێرەیەک دوو دەیەکی ئێفەیەک بەکاردەهێنیت، ");
INSERT INTO ckb_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","دەیانکەیت بە دوو ڕیز، هەر ڕیزە و شەش کولێرە، لەسەر مێزە زێڕینە بێگەردەکە لەبەردەم یەزدان. ");
INSERT INTO ckb_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","لەسەر هەر ڕیزێکیش بخووری سادەی بێگەرد دادەنێیت، جا لەگەڵ کولێرەکە دەبێتە یادەوەری قوربانی بە ئاگر بۆ یەزدان. ");
INSERT INTO ckb_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","ئەم کولێرەیەش بە بەردەوامی هەموو ڕۆژێکی شەممە لەبەردەم یەزدان ڕێکدەخرێت، پەیمانێکی هەتاهەتاییە لە پێناو نەوەی ئیسرائیل. ");
INSERT INTO ckb_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","ئەمە بۆ هارون و کوڕەکانی دەبێت و لە شوێنێکی پیرۆز دەیخۆن، چونکە هەرەپیرۆزە لە قوربانییە بە ئاگرەکان بۆ یەزدان، بەشێکی چەسپاوە.» ");
INSERT INTO ckb_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","کوڕێک کە دایکی ئیسرائیلی و باوکی میسری بوو چووە نێو نەوەی ئیسرائیل و لە ئۆردوگاکە لەگەڵ پیاوێکی ئیسرائیلی بووە شەڕیان. ");
INSERT INTO ckb_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","کوڕی ژنە ئیسرائیلییەکە کفر و نەفرەتی سەبارەت بە ناوی یەزدان کرد، هێنایانە لای موسا، دایکیشی ناوی شەلۆمیتی کچی دبری بوو، لە هۆزی دان. ");
INSERT INTO ckb_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","لە شوێنێکیان دانا لەژێر چاودێری پاسەوان، هەتا بڕیاری یەزدانیان پێ ڕابگەیەنرێت. ");
INSERT INTO ckb_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","جا یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","«ئەوەی نەفرەتی کردووە، بیبە دەرەوەی ئۆردوگاکە، هەموو ئەوانەی گوێیان لێی بوو دەستیان لەسەر سەری دادەنێن و هەموو کۆمەڵەکە بەردبارانی دەکەن. ");
INSERT INTO ckb_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","لەگەڵ نەوەی ئیسرائیلیش بدوێ و بڵێ: ”ئەوەی نەفرەت لە خودای خۆی بکات، ئەوا تاوانی لە ئەستۆی خۆی دەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","ئەوەی کفر سەبارەت بە ناوی یەزدان بکات، ئەوا دەکوژرێت، هەموو کۆمەڵەکە بەردبارانی دەکەن، بیانی و هاوڵاتی وەک یەک، کاتێک کفر سەبارەت بە ناوی یەزدان بکات، دەکوژرێت. ");
INSERT INTO ckb_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","«”ئەگەر کەسێک کەسێکی کوشت ئەوا دەکوژرێت. ");
INSERT INTO ckb_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","ئەوەی ئاژەڵی کەسێکی دیکە بکوژێت، ئەوا قەرەبووی دەکاتەوە، گیان بە گیان. ");
INSERT INTO ckb_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","ئەگەر یەکێک شتێکی لە کەسێک کرد، چی کردووە ئاوای لێ دەکرێتەوە، ");
INSERT INTO ckb_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","شکان بە شکان و چاو بە چاو و ددان بە ددان، چی لەو کەسە کردووە ئاوای لێ دەکرێتەوە. ");
INSERT INTO ckb_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","ئەوەی ئاژەڵێک بکوژێت، قەرەبووی دەکاتەوە، بەڵام ئەوەی کەسێک بکوژێت دەکوژرێتەوە. ");
INSERT INTO ckb_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","یەک یاساتان دەبێت، بیانی وەک هاوڵاتی دەبێت، من یەزدانی پەروەردگارتانم.“» ");
INSERT INTO ckb_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","جا موسا بە نەوەی ئیسرائیلی گوت، ئەوەی نەفرەتی کردووە، بیبەنە دەرەوەی ئۆردوگاکە و بەردبارانی بکەن. نەوەی ئیسرائیلیش ئاوایان کرد، هەروەک یەزدان فەرمانی بە موسا کرد. ");
INSERT INTO ckb_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","هەروەها یەزدان لە شاخی سینا بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","«لەگەڵ نەوەی ئیسرائیل بدوێ و پێیان بڵێ: ”کاتێک هاتنە ئەو خاکەی من پێتان دەدەم، با خاکەکە شەممە بۆ یەزدان بپارێزێت. ");
INSERT INTO ckb_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","شەش ساڵ کێڵگەکەت دەڕوێنیت و شەش ساڵ ڕەزەکەت پەرچ دەکەیت و بەروبوومی کۆدەکەیتەوە. ");
INSERT INTO ckb_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","بەڵام لە ساڵی حەوتەم دەبێتە پشووی خاک، شەممەیە بۆ یەزدان، کێڵگەکەت مەڕوێنە و ڕەزەکەت پەرچ مەکە. ");
INSERT INTO ckb_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","ئەوەی لە دروێنە لێت کەوتووە و ئێستا ڕواوەتەوە، دروێنەی مەکە، ترێی ڕەزەکەشت، هی ئەو لقانەی پەرچ نەکراون، لێ مەکەرەوە. ساڵی پشوودان دەبێت بۆ خاکەکە. ");
INSERT INTO ckb_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","هەر شتێک خاکەکە لە ساڵی پشوودا بە خۆڕستی بەرهەمی دەهێنێت، ئەوا دەبێتە خۆراکتان، بۆ تۆ و کۆیلەکەت و کەنیزەکەت یان کرێگرتەکەت و نیشتەجێی کاتی کە لەلای تۆ دەژیێت، ");
INSERT INTO ckb_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","هەروەها بۆ ئاژەڵە ماڵییەکانت و بۆ ئەو ئاژەڵە کێوییە دەبێت کە لە خاکەکەتە. هەموو بەروبوومی خاکەکە دەبێتە خۆراک. ");
INSERT INTO ckb_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","«”حەوت پشووی ساڵانە بۆ خۆت دەژمێریت، حەوت جار حەوت ساڵ، جا ڕۆژانی حەوت پشووە ساڵانەکە بۆ تۆ دەبێتە چل و نۆ ساڵ، ");
INSERT INTO ckb_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","ئینجا لە ڕۆژی دەی مانگی حەوت، کەڕەنا لێ دەدەیت لە ڕۆژی کەفارەت، کەڕەنا بە هەموو خاکەکەتان دەگێڕن. ");
INSERT INTO ckb_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","ساڵی پەنجایەمین تەرخان دەکەن و بانگەوازی ئازادکردن لە زەوییەکەدا ڕادەگەیەنن بۆ هەموو دانیشتووانەکەی، بۆتان دەبێتە یۆبیل و هەریەکە و بۆ موڵکی خۆی دەگەڕێتەوە و هەریەکە و بۆ خێڵەکەی خۆی دەگەڕێتەوە. ");
INSERT INTO ckb_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","ساڵی پەنجایەمین یۆبیل، ناڕوێنن و ئەوەی خۆڕسکە نایدروونەوە و ڕەزی پەرچ نەکراو ناڕنن. ");
INSERT INTO ckb_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","ئەوە یۆبیلە و پیرۆز دەبێت بۆتان، ئەو ساڵە تەنها ئەوە بخۆن کە ڕاستەوخۆ لە کێڵگەوە دەستتان دەکەوێت. ");
INSERT INTO ckb_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","«”لەم ساڵی یۆبیلە هەرکەسە دەگەڕێتەوە سەر موڵکی خۆی. ");
INSERT INTO ckb_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","«”جا کاتێک زەوی و زارت بە هاونیشتیمانیت فرۆشت یان لێت کڕی، با کەستان ستەم لەوی دیکەتان نەکات. ");
INSERT INTO ckb_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","بەگوێرەی ژمارەی ساڵەکانی دوای یۆبیل لە هاونیشتیمانییەکەت دەکڕیت و بەگوێرەی ساڵەکانی کە ماوەتەوە بۆ خەرمانان پێت دەفرۆشێت. ");
INSERT INTO ckb_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","بەگوێرەی زۆری ساڵەکان نرخی زیاد دەکەیت و بەگوێرەی کەمی ساڵەکان نرخی کەم دەکەیتەوە، چونکە ژمارەی بەروبوومەکەت پێ دەفرۆشێت. ");
INSERT INTO ckb_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","جا ستەم لە یەکتری مەکەن، بەڵکو لە خوداتان بترسن، من یەزدانی پەروەردگارتانم. ");
INSERT INTO ckb_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","«”فەرزەکانم بەجێبهێنن و ئاگاداری ئەوە بن کە گوێڕایەڵی یاساکانم بن و کاریان پێ بکەن، بۆ ئەوەی بە ئاسوودەیی لە خاکەکە نیشتەجێ بن. ");
INSERT INTO ckb_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","زەوییەکەش بەروبوومەکەی دەدات، جا هەتا تێر دەبن لێی دەخۆن و بە ئاسوودەیی تێیدا نیشتەجێ دەبن. ");
INSERT INTO ckb_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","ئەگەر بڵێن: ’لە ساڵی حەوتەم چی بخۆین، ئەگەر نەچێنین و بەروبووممان کۆنەکەینەوە؟‘ ");
INSERT INTO ckb_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","ئەوا من فەرمانی بەرەکەتی خۆم دەدەم بۆتان لە ساڵی شەشەمدا، جا بەروبوومی سێ ساڵ دەدات. ");
INSERT INTO ckb_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","ساڵی هەشتەم دەچێنن و لە بەروبوومە کۆنەکە دەخۆن، هەتا ساڵی نۆیەم بەروبوومەکەی دەدات لە کۆنەکە دەخۆن. ");
INSERT INTO ckb_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","«”زەوییەکەش هەمیشە هەتاسەر نافرۆشرێت، چونکە زەوییەکە هی منە و ئێوە نامۆ و کرێگرتەی منن، ");
INSERT INTO ckb_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","بەڵکو لە هەموو ئەو خاکەی ئەو زەوییەی موڵکتان بووە، پێویستە کڕینەوە بۆ زەوییەکە دابنێن. ");
INSERT INTO ckb_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","«”ئەگەر هاونیشتیمانیێکت هەژار بوو و لە موڵکەکەی خۆی فرۆشت، ئەوا نزیکترین خزمی دێت و فرۆشراوی هاوڵاتییەکەی دەکڕێتەوە. ");
INSERT INTO ckb_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","ئەگەر کەسێکیش خزمی نەبێت زەوییەکەی بۆ بکڕێتەوە، بەڵام ئەگەر خۆی توانی و ئەوەندەی دەستکەوتەوە کە بەشی کڕینەوەکە بکات، ");
INSERT INTO ckb_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","ئەوا نرخی ئەو ساڵانە دەژمێرێت لە کاتی فرۆشتنەکەوە و ئەوەندەی دەمێنێتەوە بۆ هاوسەنگکردنی نرخەکە دەداتەوە ئەو کەسە کە پێی فرۆشتووە، ئینجا دەگەڕێتەوە بۆ موڵکەکەی. ");
INSERT INTO ckb_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","بەڵام ئەگەر ئەوەندەی لە دەست نەبێت کە بۆی بگەڕێنێتەوە، ئەوا لە دەستی کڕیار دەبێت هەتا ساڵی یۆبیل. ئینجا لە یۆبیلدا دەگەڕێتەوە، ئەو کاتە خاوەنەکەی دەتوانێت بگەڕێتەوە بۆ موڵکەکەی. ");
INSERT INTO ckb_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","«”ئەگەر لە شارێکی شوورابەند یەکێک خانووی نیشتەجێبوونی فرۆشت، ئەوا مافی کڕینەوەکەی هەتا تەواوی ساڵێک دەبێت لە کاتی فرۆشتنەوە، لە ماوەی ئەو کاتەدا دەتوانێت بیکڕێتەوە. ");
INSERT INTO ckb_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","ئەگەر هەتا تەواوبوونی ئەو ساڵە نەیکڕێتەوە، ئەوا ئەو خانووەی لە شارە شوورابەندەکەیە بە هەمیشەیی هەتاسەر بۆ کڕیارەکە دەبێت، بۆ نەوەکانی و لە یۆبیلدا ناگەڕێتەوە. ");
INSERT INTO ckb_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","بەڵام خانوو لە لادێی شوورابەند نەبێت، ئەوا وەک کێڵگە هەژمارد دەکرێت، کڕینەوەی هەیە و لە یۆبیلدا دەگەڕێتەوە. ");
INSERT INTO ckb_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","«”لە شارۆچکەکانی لێڤییەکان، لێڤییەکان هەمیشە مافی کڕینەوەی ماڵەکانیان هەیە، کە موڵکی خۆیانە. ");
INSERT INTO ckb_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","ماڵەکانی لێڤییەکان مافی کڕینەوە و گەڕانەوەی هەیە، لە ساڵی یۆبیل، چونکە خانووی شارۆچکەکانی لێڤییەکان موڵکی ئەوانە لەنێو نەوەی ئیسرائیل. ");
INSERT INTO ckb_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","بەڵام لەوەڕگای دەوروبەری شارۆچکەکانیان نافرۆشرێت، چونکە موڵکێکی هەتاهەتاییە بۆیان. ");
INSERT INTO ckb_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","«”ئەگەر یەکێک لە هاوڵاتیانت هەژار و دەستکورت بوو لەنێوتان، پشتگیری بکە، هەروەک چۆن پشتگیری نامۆ یان نیشتەجێی کاتی دەکەیت، با لەنێوتان بژیێت. ");
INSERT INTO ckb_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","نە سووی لێ وەربگرە و نە قازانج، بەڵکو لە خوداکەت بترسە و با هاونیشتیمانیت لەنێوتان بژیێت، ");
INSERT INTO ckb_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","نە پارەکەتی بە سوو پێبدە و نە خۆراکەکەتی بە قازانج پێبدە. ");
INSERT INTO ckb_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","من یەزدانی پەروەردگارتانم کە لە خاکی میسر دەریهێنان هەتا خاکی کەنعانتان بداتێ و ببێت بە خوداتان. ");
INSERT INTO ckb_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","«”ئەگەر هاوڵاتییەکت لەنێوتان هەژار بوو و خۆی فرۆشتە تۆ، وەک کۆیلە کۆیلایەتی پێ مەکە، ");
INSERT INTO ckb_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","بەڵکو وەک کرێگرتە و نیشتەجێی کاتی لەنێوتان دەبێت، هەتا ساڵی یۆبیل لەلات کار دەکات. ");
INSERT INTO ckb_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","ئینجا خۆی و کوڕەکانی لەلات ئازاد دەبن و بۆ خێڵەکەی خۆی و بۆ موڵکی باوباپیرانی دەگەڕێتەوە. ");
INSERT INTO ckb_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","لەبەر ئەوەی گەلی ئیسرائیل بەندەی منن، ئەوانەی لە خاکی میسرەوە دەرمهێنان، بۆیە نابێت وەک کۆیلە بفرۆشرێن. ");
INSERT INTO ckb_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","بە توندوتیژی بەسەریاندا زاڵ مەبە، بەڵکو لە خودات بترسە. ");
INSERT INTO ckb_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","«”بەڵام کۆیلەکانت و کەنیزەکانت ئەوانەی دەبنە هی تۆ، ئەوا لەو گەلانەی دەوروبەرتان دەبن، لەوان کۆیلە و کەنیزە بۆ خۆتان پەیدا دەکەن. ");
INSERT INTO ckb_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","هەروەها لە نەوەی ئەوانەی لای ئێوە نیشتەجێی کاتین و لە خێڵەکانیان کە لەنێوتانن پەیدای دەکەن، ئەوانەی لە خاکی ئێوە لەدایک دەبن، ئەوان دەبنە موڵکی ئێوە. ");
INSERT INTO ckb_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","دەیانکەنە موڵکی کوڕانتان لەدوای خۆتان وەک میرات بۆیان، هەتاسەر دەیانکەنە کۆیلە، بەڵام براکانتان لە نەوەی ئیسرائیل، ئەوا هیچ کەسێک بە توندوتیژی بەسەر براکەیدا زاڵ نابێت. ");
INSERT INTO ckb_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","«”ئەگەر نامۆیەک یان نیشتەجێیەکی کاتی لەنێوتان دەوڵەمەند بوو، یەکێک لە هاوڵاتیانتان هەژار بوو و خۆی بەو نامۆیە فرۆشت کە لەنێوتان دەژی، یان بە ئەندامی خێڵی نامۆکە، ");
INSERT INTO ckb_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","ئەوا دوای فرۆشتنەکەی کڕینەوەی بۆ دەبێت، یەکێک لە خزمەکانی دەیکڕێتەوە. ");
INSERT INTO ckb_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","مامی یان ئامۆزای دەیکڕێتەوە، یەکێک لە خزمەکانی لە خێڵەکەی دەیکڕێتەوە، یان ئەگەر توانای ماددی هەبوو ئەوا خۆی دەکڕێتەوە. ");
INSERT INTO ckb_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","لەگەڵ کڕیارەکەی لە ساڵی فرۆشتنییەوە هەتا ساڵی یۆبیل دەژمێرێت و نرخی ئازادبوونی بەپێی نرخی پێدانی کرێگرتەیەک دەبێت لە ماوەی ئەو چەند ساڵەدا. ");
INSERT INTO ckb_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","ئەگەر ساڵانێکی زۆر مابێت، ئەوا پێویستە ئەو پارەیە بگەڕێنێتەوە لە نرخی کڕینەکەی بەپێی ژمارەی ئەو ساڵانەی کە ماوەتەوە. ");
INSERT INTO ckb_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","ئەگەر ساڵانێکی کەم مابێتەوە هەتا ساڵی یۆبیل، ئەوا پێویستە ئەو پارەیە بگەڕێنێتەوە لە نرخی کڕینەکەی بەپێی ژمارەی ئەو ساڵانەی کە ماوەتەوە، ");
INSERT INTO ckb_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","وەک کرێگرتەیەک هەڵسوکەوتی لەگەڵ دەکرێت، لە ساڵێکەوە بۆ ساڵێکی دیکە. پێویستە ئاگاداربن خاوەنەکەی بە توندوتیژی بەسەریدا زاڵ نەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","«”ئەگەر بەو شێوازانەی پێشوو نەکڕدرێتەوە، ئەوا لە ساڵی یۆبیل خۆی و منداڵەکانی ئازاد دەکرێن، ");
INSERT INTO ckb_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","چونکە نەوەی ئیسرائیل بەندەن بۆ من، ئەوان بەندەی منن، ئەوانەی لە خاکی میسرەوە دەرمهێنان، من یەزدانی پەروەردگارتانم. ");
INSERT INTO ckb_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","«”بت بۆ خۆتان دروستمەکەن و پەیکەری تاشراو و بەردی تەرخانکراو دامەمەزرێنن، لە خاکەکەتان بەردی وێنە لەسەر کێشراو دامەنێن، هەتا کڕنۆشی بۆ ببەن، چونکە من یەزدانی پەروەردگارتانم. ");
INSERT INTO ckb_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","«”شەممەکانم بپارێزن و ڕێز لە پیرۆزگاکەم بگرن، من یەزدانم. ");
INSERT INTO ckb_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","«”ئەگەر فەرزەکانم بەجێبهێنن و فەرمانەکانم بەجێبگەیەنن و کاری پێ بکەن، ");
INSERT INTO ckb_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","ئەوا لە کاتی خۆی بارانتان دەدەمێ و زەویش بەری خۆی دەدات و درەختەکانی کێڵگەش بەروبووم دەدات. ");
INSERT INTO ckb_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","گێرەکردنتان بەردەوام دەبێت هەتا چنینەوەی ترێ و چنینەوەی ترێ بەردەوام دەبێت هەتا چاندن، جا هەر خواردنێکتان حەز لێبوو، دەیخۆن و بە ئاسوودەیی لە خاکەکەتان نیشتەجێ دەبن. ");
INSERT INTO ckb_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","«”ئاشتیش لە خاکەکەدا دەنێمەوە، جا دەخەون و کەس ناتانترسێنێت، گیانلەبەرە دڕندەکانیش لە خاکەکەدا لادەبەم و شمشێر بە خاکەکەتاندا تێناپەرێت. ");
INSERT INTO ckb_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","دوژمنەکانتان ڕاودەنێن و لەبەردەمتان بە شمشێر دەکوژرێن. ");
INSERT INTO ckb_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","پێنج لە ئێوە سەد ڕاودەنێن و سەد لە ئێوە ڕاوی دە هەزار دەنێن و دوژمنەکانتان لەبەردەمتان بە شمشێر دەکوژرێن. ");
INSERT INTO ckb_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","«”ئاوڕتان لێ دەدەمەوە و بە بەروبوومتان دەکەم و زیادتان دەکەم و پەیمانم لەگەڵتان دەبەمەسەر، ");
INSERT INTO ckb_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","جا لە بەروبوومی دروێنەی ساڵی پێشوو دەخۆن و بۆ ئەمبارکردنی بەروبوومی نوێ، کۆنەکە دەردەهێنن. ");
INSERT INTO ckb_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","نشینگەکەم لەنێوتان دادەنێم و قێزتان لێ ناکەمەوە، ");
INSERT INTO ckb_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","لەنێوتان هاتوچۆ دەکەم و دەبم بە خودای ئێوە و ئێوەش دەبن بە گەلی من. ");
INSERT INTO ckb_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","من یەزدانی پەروەردگارتانم کە لە خاکی میسر دەریهێنان، لەوەی کە کۆیلەی ئەوان بوون و کۆتی نیری ئێوەی شکاند و بە سەربەرزییەوە بەڕێی کردن. ");
INSERT INTO ckb_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","«”بەڵام ئەگەر گوێم لێ نەگرن و هەموو ئەم فەرمانانە جێبەجێ نەکەن، ");
INSERT INTO ckb_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","ئەگەر فەرزەکانم ڕەت بکەنەوە و قێزتان لە یاساکانم ببێتەوە و فەرمانەکانم بەجێنەهێنن، بەڵکو پەیمانەکەم بشکێنن، ");
INSERT INTO ckb_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","ئەوا من ئەمەتان پێ دەکەم، ترس و تۆقین و نەخۆشی سیل و تایەکتان دەهێنمە سەر کە چاوتان کوێر بکات و گیانتان بشێوێنێت، بێهوودە کشتوکاڵەکەتان دەچێنن، چونکە دوژمنەکانتان دەیخۆن. ");
INSERT INTO ckb_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","من ڕووتان لێ وەردەگێڕم، جا دوژمنەکانتان دەتانشکێنن و ناحەزەکانتان بەسەرتاندا زاڵ دەبن و کەسیش بەدواتانەوە نەبێت هەر هەڵدێن. ");
INSERT INTO ckb_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","«”ئەگەر لەگەڵ ئەوەش هەر گوێم لێ نەگرن، ئەوا حەوت قات بۆ گوناهەکانتان سزاتان دەدەم. ");
INSERT INTO ckb_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","جا لەخۆبایی کەللەڕەقیتان دەشکێنم و ئاسمانتان وەک ئاسن لێ دەکەم و زەویتان وەک بڕۆنز، ");
INSERT INTO ckb_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","بێهوودە ماندوو دەبن و زەویتان بەری خۆی نادات و درەختی زەوی بەروبوومی نادات. ");
INSERT INTO ckb_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","«”ئەگەر بە پێچەوانە لەگەڵم جوڵانەوە و نەتانویست گوێم لێ بگرن، ئەوا جارێکی دیکە حەوت قات کارەساتەکەتان لەسەر زیاد دەکەم، بەگوێرەی گوناهەکانتان. ");
INSERT INTO ckb_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","دڕندەی کێویتان بۆ بەڕەڵا دەکەم و بێ منداڵتان دەکات و مەڕوماڵاتتان قڕ دەکات و کەمتان دەکاتەوە، جا ڕێگاتان چۆڵ دەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","«”ئەگەر بەوەش تەمبێ نەبوون و بەڵکو بە پێچەوانەوە لەگەڵم جوڵانەوە، ");
INSERT INTO ckb_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","ئینجا منیش بە پێچەوانەوە لەگەڵتان دەجوڵێمەوە و حەوت قات بۆ گوناهەکانتان ئازارتان دەدەم. ");
INSERT INTO ckb_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","شمشێرێکتان دەهێنمە سەر، تۆڵەی تووڕەیی پەیمانەکەتان لێ دەکاتەوە، جا لە شارۆچکەکانتان کۆدەبنەوە و دەرد دەنێرمە نێوانتان و دەدرێنە دەست دوژمن. ");
INSERT INTO ckb_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","کە نان بڕاوتان دەکەم، هەموو نانەکەتان بە دە ژن و لە یەک تەنوور دەکرێت، بە پێوانەش بەشی دەکەن و دەیخۆن، بەڵام تێر نابن. ");
INSERT INTO ckb_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","«”ئەگەر بەوەش گوێم لێ نەگرن، بەڵکو بە پێچەوانەوە لەگەڵم جوڵانەوە، ");
INSERT INTO ckb_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","ئەوا بە پێچەوانەوە لەگەڵتان دەجوڵێمەوە بە تووڕەییم و حەوت قات بۆ گوناهەکانتان سزاتان دەدەم. ");
INSERT INTO ckb_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","جا گۆشتی کوڕ و کچەکانتان دەخۆن. ");
INSERT INTO ckb_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","نزرگەکانی سەر بەرزاییتان وێران دەکەم و قوربانگاکانی بخوورتان تەخت دەکەم، لاشەکانتان فڕێدەدەمە سەر لاشەی بتەکانتان و قێزتان لێ دەکەمەوە. ");
INSERT INTO ckb_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","شارۆچکەکانتان وێران دەکەم و شوێنە پیرۆزەکانتان دەکەمە چۆڵەوانی، بۆنەکانی خۆشی قوربانی ئێوە دڵخۆشم ناکات. ");
INSERT INTO ckb_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","خاکەکە دەکەمە چۆڵەوانی و دوژمنەکانتان کە تێیدا نیشتەجێ دەبن، سەرسام دەبن. ");
INSERT INTO ckb_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","بەناو نەتەوەکاندا پەرشوبڵاوتان دەکەمەوە و شمشێرەکەم هەڵدەکێشم و ڕاوتان دەنێم. جا خاکەکەتان دەبێتە چۆڵەوانی و شارۆچکەکانتان وێران دەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","پاشان هەموو ڕۆژانی چۆڵبوونی، زەوییەکە پشووی ساڵەکانی خۆی وەردەگرێت، ئێوەش لە خاکی دوژمنەکانتان دەبن؛ ئەوسا زەوییەکە پشوو دەدات و سوود لە پشووەکانی وەردەگرێت. ");
INSERT INTO ckb_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","هەموو ڕۆژانی چۆڵبوونی پشوو دەدات، ئەو پشووانەی کە ئێوە پێتان نەدەدا، کاتێک تێیدا نیشتەجێ بوون. ");
INSERT INTO ckb_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","«”ئەوانەی لێتان دەمێنێتەوە، ئەوا ترسنۆکی دەخەمە دڵیان لە خاکی دوژمنانیان و دەنگی گەڵایەکی هەڵوەریو دەیانبەزێنێت، جا وەک لە شمشێر هەڵبێن ئاوا هەڵدێن و بێ ئەوەی کەس ڕاویان بنێت دەکەون. ");
INSERT INTO ckb_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","بەسەر یەکتردا دەکەون هەروەک لە شمشێر هەڵبێن و بێ ئەوەی کەس ڕاویان بنێت، لەبەردەم دوژمنەکانتان هەستانەوەتان نابێت، ");
INSERT INTO ckb_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","جا لەنێو گەلان لەناودەچن و خاکی دوژمنانتان دەتانخوات. ");
INSERT INTO ckb_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","ئەوانەی لێتان دەمێنێتەوە ئەوا لە خاکی دوژمنانتان بە گوناهەکانیانەوە لەناودەچن، هەروەها بە گوناهی باوکانیشیانەوە لەناودەچن. ");
INSERT INTO ckb_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","«”بەڵام ئەگەر دانیان بە گوناهەکانی خۆیان و باوک و باپیرانیاندا نا، لەو ناپاکییەی لەگەڵ من کردیان کە بە پێچەوانەوە لەگەڵم جوڵانەوە، ");
INSERT INTO ckb_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","لەبەر ئەوە منیش بە پێچەوانەوە لەگەڵیاندا جوڵامەوە و ئەوانم بردە خاکی دوژمنانیان هەتا دڵە خەتەنەنەکراوەکانیان بێفیز بێت و باجی گوناهەکانیان بدەنەوە، ");
INSERT INTO ckb_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","ئەوا پەیمانەکەم لەگەڵ یاقوب بەبیر دێتەوە. هەروەها پەیمانەکەم لەگەڵ ئیسحاق و پەیمانەکەم لەگەڵ ئیبراهیم و خاکەکەشم بەبیر دێتەوە. ");
INSERT INTO ckb_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","خاکەکەش لەلایەن ئەوانەوە چۆڵ دەکرێت و سوود لە پشووەکانی وەردەگرێت کاتێک بەبێ ئەوان چۆڵەوانییە. ئەوانیش باجی گوناهەکانیان دەدەنەوە، چونکە یاساکانی منیان ڕەتکردەوە و لە ناخەوە قێزیان لە فەرزەکانم بووەوە. ");
INSERT INTO ckb_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","بەڵام لەگەڵ ئەوەشدا کاتێک لە خاکی دوژمنانیان بوون، ڕەتم نەکردنەوە و قێزم لێیان نەکردەوە، هەتا بە تەواوی لەناویان ببەم و پەیمانم لەگەڵیان بشکێنم، چونکە من یەزدانی پەروەردگاریانم. ");
INSERT INTO ckb_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","بەڵکو لە پێناویان یادی ئەو پەیمانەیان بۆ دەکەمەوە کە لەگەڵ باوباپیرانیان بەستم، ئەوانەی لەبەرچاوی نەتەوەکان لە خاکی میسرەوە دەرمهێنان هەتا ببمە خودای خۆیان. من یەزدانم.“» ");
INSERT INTO ckb_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","ئەوانە فەرز و یاسا و ڕێنماییەکانن کە یەزدان لەنێوان خۆی و نەوەی ئیسرائیلدا داینا، لە شاخی سینا لەسەر دەستی موسا. ");
INSERT INTO ckb_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","هەروەها یەزدان بە موسای فەرموو ");
INSERT INTO ckb_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","«لەگەڵ نەوەی ئیسرائیل بدوێ و پێیان بڵێ: ”ئەگەر کەسێک کەسێکی بۆ یەزدان نەزر کرد، ئەوا ئاوای دەخەمڵێنێت، ");
INSERT INTO ckb_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","ئەگەر خەمڵاندنەکەت بۆ نێرێکی تەمەن بیست هەتا شەست ساڵ بوو، ئەوا خەمڵاندنەکەت پەنجا شاقل زیو بەگوێرەی شاقلی پیرۆزگا دەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","ئەگەر مێینەش بوو، ئەوا خەمڵاندنەکەت سی شاقل دەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","ئەگەر تەمەنی پێنج هەتا بیست ساڵ بوو، ئەوا خەمڵاندنەکەت بیست شاقل بۆ نێر و دە شاقل بۆ مێ دەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","ئەگەر تەمەنی مانگێک هەتا پێنج ساڵ بوو، ئەوا خەمڵاندنەکەت پێنج شاقل زیو بۆ نێر و سێ شاقل زیو بۆ مێ دەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","ئەگەر تەمەنی شەست ساڵ و بەرەو سەرەوە بوو، ئەوا خەمڵاندنەکەت پازدە شاقل بۆ نێر و دە شاقل بۆ مێ دەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","ئەگەر کەسێک نەزری کرد و ئەو کەسە هەژار بوو و ئەو خەمڵاندنەی لە توانادا نەبوو، ئەوا نەزرەکە دەهێنێتە بەردەم کاهین و کاهینەکەش بۆی دەخەمڵێنێت. بەگوێرەی توانای ئەو کەسەی نەزرەکەی کردووە کاهینەکە بۆی دەخەمڵێنێت. ");
INSERT INTO ckb_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","«”ئەگەر نەزرەکە ئاژەڵ بێت، لەوانەی پەسەندە وەک قوربانی بۆ یەزدان، ئەوا هەموو ئەوەی لێی دەدرێت بە یەزدان، پیرۆز دەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","پێویستە نەیگۆڕێت و ئاڵوگۆڕی پێ نەکات، باش بە خراپ یان خراپ بە باش، ئەگەر ئاژەڵێکی بە ئاژەڵێکی دیکە ئاڵوگۆڕ کرد، ئەوا هەردوو ئاژەڵەکە پیرۆز دەبن. ");
INSERT INTO ckb_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","ئەگەر نەزرەکە بەپێی ڕێوڕەسم ئاژەڵێکی گڵاو بوو، لەوانەی کە قبوڵ نییە وەک قوربانی بۆ یەزدان، ئەوا پێویستە ئاژەڵەکە بهێنرێتە بەردەم کاهین. ");
INSERT INTO ckb_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","جا نرخەکەی دەخەمڵێنێت، هەر چۆنێک بێت باش یان خراپ، ئەو نرخەی کاهین دەیخەمڵێنێت، هەر ئەوە دەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","جا ئەگەر خاوەنەکەی ویستی ئاژەڵەکە بکڕێتەوە، ئەوا پێویستە پێنج یەک بخاتە سەر خەمڵاندنەکە. ");
INSERT INTO ckb_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","«”ئەگەر یەکێک ماڵەکەی تەرخان کرد هەتا بۆ یەزدان پیرۆزکراو بێت، ئەوا کاهینەکە دەیخەمڵێنێت باش بێت یان خراپ، کاهینەکە چۆنی بخەمڵێنێت ئاوا دەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","ئەگەر ئەو کەسە ویستی ماڵە تەرخانکراوەکەی بکڕێتەوە ئەوا پێنج یەکی نرخی خەمڵاندنەکە دەخاتە سەری و دەبێتەوە هی خۆی. ");
INSERT INTO ckb_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","«”ئەگەر کەسێک بەشێکی لە کێڵگەکەی موڵکی خێزانی خۆی بۆ یەزدان تەرخان کرد، ئەوا خەمڵاندنەکە بەگوێرەی تۆوکردن تێیدا دەبێت، جێی حۆمەرێک تۆوی جۆ بە پەنجا شاقل زیو دەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","ئەگەر لە ساڵی یۆبیلدا کێڵگەکەی تەرخان کرد، ئەوا بەگوێرەی ئەو خەمڵاندنەی کە دانراوە دەمێنێتەوە. ");
INSERT INTO ckb_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","بەڵام ئەگەر لەدوای ساڵی یۆبیل کێڵگەکەی تەرخان کرد، ئەوا کاهینەکە بەگوێرەی ئەو ساڵانەی ماوەتەوە بۆ ساڵی ئاییندەی یۆبیل، نرخەکەی بۆ دەژمێرێت. لە خەمڵاندنەکە کەم دەکاتەوە. ");
INSERT INTO ckb_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","ئەگەر ئەو کەسەی کێڵگەکەی تەرخان کردووە ویستی کێڵگەکە بکڕێتەوە، ئەوا پێنج یەکی نرخی خەمڵاندنەکە دەخاتە سەری و کێڵگەکە بۆ ئەو دەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","بەڵام ئەگەر کێڵگەکەی نەکڕییەوە یان کێڵگەکەی بە کەسێکی دیکە فرۆشت، ئەوا ئیتر ناکڕدرێتەوە، ");
INSERT INTO ckb_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","بەڵکو کێڵگەکە لە ساڵی یۆبیل ئازاد دەکرێت، پیرۆز دەبێت، وەک کێڵگەی ڕاگیراو بۆ یەزدان. ئەو کاتە دەبێتە موڵکی کاهینەکان. ");
INSERT INTO ckb_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","«”ئەگەر کێڵگەیەکی کڕاوی بۆ یەزدان تەرخان کرد، کە لە کێڵگەکانی موڵکی خێزانی نەبوو، ");
INSERT INTO ckb_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","ئەوا کاهینەکە بڕی خەمڵاندنەکەی بۆ دەژمێرێت هەتا ساڵی یۆبیل، جا کەسەکە لەو ڕۆژە نرخی خەمڵاندنەکە دەدات، وەک تەرخانکراوی پیرۆز بۆ یەزدان. ");
INSERT INTO ckb_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","لە ساڵی یۆبیلیش کێڵگەکە دەگەڕێتەوە بۆ ئەوەی لێی کڕیوە، بۆ خاوەنی ڕەسەنی زەوییەکە. ");
INSERT INTO ckb_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","هەموو خەمڵاندنەکەش بەپێی شاقلی پیرۆزگا دەبێت، هەر شاقلێک بیست گیرە دەبێت. ");
INSERT INTO ckb_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","«”بەڵام هەر نۆبەرەیەکی ئاژەڵ کە وەک نۆبەرە بۆ یەزدان جیا دەکرێتەوە، با کەس تەرخانی نەکات، گا بێت یان بەران ئەوا بۆ یەزدانە؛ ");
INSERT INTO ckb_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","ئەگەر لە ئاژەڵە گڵاوەکان بوو، ئەوا بەگوێرەی خەمڵاندنەکە دەیکڕێتەوە و پێنج یەکیشی دەخاتە سەر. ئەگەر نەیکڕییەوە ئەوا بەگوێرەی خەمڵاندنەکە دەفرۆشرێت. ");
INSERT INTO ckb_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","«”بەڵام هەموو ڕاگیراوێک کە مرۆڤ بۆ یەزدانی تەرخان دەکات لە هەموو ئەوانەی هەیەتی، لە خەڵک و ئاژەڵ و کێڵگەکانی موڵکی خۆی، ئەوا نافرۆشرێت و ناکڕدرێتەوە، هەموو ڕاگیراوێک هەرەپیرۆزە بۆ یەزدان. ");
INSERT INTO ckb_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","«”هەرکەسێک تەرخانکراو بێت بۆ قڕکردن بە بارمتە ناکڕدرێتەوە، دەبێت بکوژرێت. ");
INSERT INTO ckb_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","«”هەموو دەیەکی زەوی لە دانەوێڵەی زەوی و بەروبوومی درەختەکان بۆ یەزدانە، پیرۆزە بۆ یەزدان. ");
INSERT INTO ckb_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","ئەگەر کەسێک هەندێک لە دەیەکەکەی خۆی کڕییەوە، ئەوا پێنجیەکی دەخاتە سەر، ");
INSERT INTO ckb_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","بەڵام گاگەل و مێگەل دەیەمی هەر ئاژەڵێک بەژێر گۆچانی شواندا تێبپەڕێت، ئەوا پیرۆز دەبێت بۆ یەزدان. ");
INSERT INTO ckb_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","نابێت تەماشا بکرێت ئاخۆ باشە یان خراپ و ئاڵوگۆڕی پێ ناکات، ئەگەر ئاڵوگۆڕی پێکرد، ئەوا هەردوو ئاژەڵەکە و ئالۆگۆڕکراوەکە پیرۆز دەبن بۆ یەزدان، ناکڕدرێنەوە.“» ");
INSERT INTO ckb_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","ئەمانە ئەو فەرمانانەن کە یەزدان فەرمانی بە موسا کرد بۆ نەوەی ئیسرائیل لە شاخی سینا.");
INSERT INTO ckb_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","لە یەکی مانگی دووی ساڵی دووەمی هاتنەدەرەوەی گەلی ئیسرائیل لە خاکی میسر، لە چادری چاوپێکەوتندا لە چۆڵەوانی سینا، یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","«سەرژمێری هەموو کۆمەڵی نەوەی ئیسرائیل بکەن، بە خێڵەکانیان و بنەماڵەکانیانەوە، بە لیستی ناوی نێرینەکان یەک بە یەک. ");
INSERT INTO ckb_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","لە گەنجی بیست ساڵ بەرەو سەرەوە، هەموو ئەوانەی دەتوانن لە ئیسرائیل خزمەت بکەن لە سوپا، تۆ و هارون بەگوێرەی لەشکرەکانیان تۆماریان بکەن. ");
INSERT INTO ckb_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","بۆ هەر هۆزێک پیاوێکتان لەگەڵدا بێت، پیاوێک گەورەی بنەماڵەکەی بێت. ");
INSERT INTO ckb_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","«ئەمەش ناوی ئەو پیاوانەیە کە یارمەتیتان دەدەن: «لە هۆزی ڕەئوبێن، ئەلیسوری کوڕی شەدیئور؛ ");
INSERT INTO ckb_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","لە هۆزی شیمۆن، شەلومیێلی کوڕی چووریشەدای؛ ");
INSERT INTO ckb_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","لە هۆزی یەهودا، نەحشۆنی کوڕی عەمیناداب؛ ");
INSERT INTO ckb_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","لە هۆزی یەساخار، نەتەنێلی کوڕی چوعەر؛ ");
INSERT INTO ckb_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","لە هۆزی زەبولون، ئەلیابی کوڕی حێلۆن؛ ");
INSERT INTO ckb_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","لە کوڕەکانی یوسف: لە هۆزی ئەفرایم، ئەلیشاماعی کوڕی عەمیهود؛ لە هۆزی مەنەشە، گەمالائیلی کوڕی پەداهچوور؛ ");
INSERT INTO ckb_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","لە هۆزی بنیامین، ئەبیدانی کوڕی گدعۆنی، ");
INSERT INTO ckb_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","لە هۆزی دان، ئەحیعەزەری کوڕی عەمیشەدای؛ ");
INSERT INTO ckb_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","لە هۆزی ئاشێر، پەگعیێلی کوڕی عۆخران؛ ");
INSERT INTO ckb_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","لە هۆزی گاد، ئەلیاسافی کوڕی دەعوئێل؛ ");
INSERT INTO ckb_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","لە هۆزی نەفتالی، ئەحیڕەعی کوڕی عێینان.» ");
INSERT INTO ckb_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","ئەوانە هەڵبژێردراوانی کۆمەڵەکەن، سەرکردەی هۆزی باوکانیانن، سەرۆک خێڵەکانی ئیسرائیلن. ");
INSERT INTO ckb_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","جا موسا و هارون هەموو ئەو پیاوانەیان برد کە باس کران، ");
INSERT INTO ckb_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","هەموو کۆمەڵیان لە یەکی مانگی دوو کۆکردەوە. لە گەنجانی بیست ساڵە بەرەو سەرەوە بەگوێرەی ڕەچەڵەکیان خرانەوە سەر خێڵ و بنەماڵەکانیان، یەک بە یەک ناوەکانیان تۆمار کرا، ");
INSERT INTO ckb_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","هەروەک یەزدان فەرمانی بە موسا کرد. ئینجا لە چۆڵەوانی سینادا تۆماری کردن. ");
INSERT INTO ckb_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","لە نەوەی ڕەئوبێن کە نۆبەرەی ئیسرائیلە، هەموو نێرینەیەک لە گەنجی بیست ساڵ بەرەو سەرەوە، هەموو ئەوانەی دەتوانن خزمەت بکەن لە سوپادا، یەکە بە یەکە بەپێی ناوەکان ڕێکخران، بەگوێرەی تۆمارکردنی خێڵەکانیان و بنەماڵەکانیان. ");
INSERT INTO ckb_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","تۆمارکراوان لە هۆزی ڕەئوبێن چل و شەش هەزار و پێنج سەد کەس بوون. ");
INSERT INTO ckb_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","لە نەوەی شیمۆن، هەموو نێرینەیەک لە گەنجی بیست ساڵ بەرەو سەرەوە، هەموو ئەوانەی دەتوانن خزمەت بکەن لە سوپادا، یەکە بە یەکە ژمێردران و بەپێی ناوەکان ڕێکخران، بەگوێرەی تۆمارکردنی خێڵەکانیان و بنەماڵەکانیان. ");
INSERT INTO ckb_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","تۆمارکراوان لە هۆزی شیمۆن پەنجا و نۆ هەزار و سێ سەد کەس بوون. ");
INSERT INTO ckb_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","لە نەوەی گاد، هەموو نێرینەیەک لە گەنجی بیست ساڵ بەرەو سەرەوە، هەموو ئەوانەی دەتوانن خزمەت بکەن لە سوپادا، بەپێی ناوەکان ڕێکخران، بەگوێرەی تۆمارکردنی خێڵەکانیان و بنەماڵەکانیان. ");
INSERT INTO ckb_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","تۆمارکراوان لە هۆزی گاد چل و پێنج هەزار و شەش سەد و پەنجا کەس بوون. ");
INSERT INTO ckb_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","لە نەوەی یەهودا، هەموو نێرینەیەک لە گەنجی بیست ساڵ بەرەو سەرەوە، هەموو ئەوانەی دەتوانن خزمەت بکەن لە سوپادا، بەپێی ناوەکان ڕێکخران، بەگوێرەی تۆمارکردنی خێڵەکانیان و بنەماڵەکانیان. ");
INSERT INTO ckb_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","تۆمارکراوان لە هۆزی یەهودا حەفتا و چوار هەزار و شەش سەد کەس بوون. ");
INSERT INTO ckb_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","لە نەوەی یەساخار، هەموو نێرینەیەک لە گەنجی بیست ساڵ بەرەو سەرەوە، هەموو ئەوانەی دەتوانن خزمەت بکەن لە سوپادا، بەپێی ناوەکان ڕێکخران، بەگوێرەی تۆمارکردنی خێڵەکانیان و بنەماڵەکانیان. ");
INSERT INTO ckb_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","تۆمارکراوان لە هۆزی یەساخار پەنجا و چوار هەزار و چوار سەد کەس بوون. ");
INSERT INTO ckb_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","لە نەوەی زەبولون، هەموو نێرینەیەک لە گەنجی بیست ساڵ بەرەو سەرەوە، هەموو ئەوانەی دەتوانن خزمەت بکەن لە سوپادا، بەپێی ناوەکان ڕێکخران، بەگوێرەی تۆمارکردنی خێڵەکانیان و بنەماڵەکانیان. ");
INSERT INTO ckb_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","تۆمارکراوان لە هۆزی زەبولون پەنجا و حەوت هەزار و چوار سەد کەس بوون. ");
INSERT INTO ckb_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","لە نەوەی یوسف، لە نەوەی ئەفرایم، هەموو نێرینەیەک لە گەنجی بیست ساڵ بەرەو سەرەوە، هەموو ئەوانەی دەتوانن خزمەت بکەن لە سوپادا، بەپێی ناوەکان ڕێکخران، بەگوێرەی تۆمارکردنی خێڵەکانیان و بنەماڵەکانیان. ");
INSERT INTO ckb_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","تۆمارکراوان لە هۆزی ئەفرایم چل هەزار و پێنج سەد کەس بوون. ");
INSERT INTO ckb_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","لە نەوەی مەنەشە، هەموو نێرینەیەک لە گەنجی بیست ساڵ بەرەو سەرەوە، هەموو ئەوانەی دەتوانن خزمەت بکەن لە سوپادا، بەپێی ناوەکان ڕێکخران، بەگوێرەی تۆمارکردنی خێڵەکانیان و بنەماڵەکانیان. ");
INSERT INTO ckb_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","تۆمارکراوان لە هۆزی مەنەشە سی و دوو هەزار و دوو سەد کەس بوون. ");
INSERT INTO ckb_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","لە نەوەی بنیامین، هەموو نێرینەیەک لە گەنجی بیست ساڵ بەرەو سەرەوە، هەموو ئەوانەی دەتوانن خزمەت بکەن لە سوپادا، بەپێی ناوەکان ڕێکخران، بەگوێرەی تۆمارکردنی خێڵەکانیان و بنەماڵەکانیان. ");
INSERT INTO ckb_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","تۆمارکراوان لە هۆزی بنیامین سی و پێنج هەزار و چوار سەد کەس بوون. ");
INSERT INTO ckb_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","لە نەوەی دان، هەموو نێرینەیەک لە گەنجی بیست ساڵ بەرەو سەرەوە، هەموو ئەوانەی دەتوانن خزمەت بکەن لە سوپادا، بەپێی ناوەکان ڕێکخران، بەگوێرەی تۆمارکردنی خێڵەکانیان و بنەماڵەکانیان. ");
INSERT INTO ckb_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","تۆمارکراوان لە هۆزی دان شەست و دوو هەزار و حەوت سەد کەس بوون. ");
INSERT INTO ckb_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","لە نەوەی ئاشێر، هەموو نێرینەیەک لە گەنجی بیست ساڵ بەرەو سەرەوە، هەموو ئەوانەی دەتوانن خزمەت بکەن لە سوپادا، بەپێی ناوەکان ڕێکخران، بەگوێرەی تۆمارکردنی خێڵەکانیان و بنەماڵەکانیان. ");
INSERT INTO ckb_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","تۆمارکراوان لە هۆزی ئاشێر چل و یەک هەزار و پێنج سەد کەس بوون. ");
INSERT INTO ckb_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","لە نەوەی نەفتالی، هەموو نێرینەیەک لە گەنجی بیست ساڵ بەرەو سەرەوە، هەموو ئەوانەی دەتوانن خزمەت بکەن لە سوپادا، بەپێی ناوەکان ڕێکخران، بەگوێرەی تۆمارکردنی خێڵەکانیان و بنەماڵەکانیان. ");
INSERT INTO ckb_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","تۆمارکراوان لە هۆزی نەفتالی پەنجا و سێ هەزار و چوار سەد کەس بوون. ");
INSERT INTO ckb_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","ئەوانە تۆمارکراوەکانن، ئەوانەی موسا و هارون و دوازدە سەرۆک هۆزەکانی ئیسرائیل تۆماریان کردن، هەر پیاوێک لە تۆمارکراوەکان نوێنەر بوو بۆ بنەماڵەکەی. ");
INSERT INTO ckb_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","جا هەموو نەوەی ئیسرائیل، بەگوێرەی بنەماڵەکانیان لە گەنجی بیست ساڵ بەرەو سەرەوە، هەموو ئەوانەی دەتوانن خزمەت بکەن لە سوپای ئیسرائیلدا تۆمار کران، ");
INSERT INTO ckb_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","هەموو تۆمارکراوەکان شەش سەد و سێ هەزار و پێنج سەد و پەنجا کەس بوون. ");
INSERT INTO ckb_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","بەڵام هۆزی لێڤی بنەماڵەکانیان لەگەڵ ئەوان تۆمار نەکران، ");
INSERT INTO ckb_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","چونکە یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","«هۆزی لێڤی تۆمار مەکە و لەنێوان نەوەی ئیسرائیلدا سەرژمێریان مەکە. ");
INSERT INTO ckb_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","بەڵکو لێڤییەکان لەسەر چادری پەیمان و هەموو قاپوقاچاغەکەی و هەموو ئەوەی هەیەتی دابنێ، ئەوان چادرەکەی پەرستن بە هەموو قاپوقاچاغەکانییەوە هەڵدەگرن و ئەوان خزمەتی دەکەن، لە چواردەوری چادرەکەی پەرستنیش چادر هەڵدەدەن. ");
INSERT INTO ckb_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","لە کاتی گواستنەوەی چادرەکەی پەرستن لێڤییەکان هەڵیدەگرنەوە و لە کاتی هەڵدانی چادرەکەی پەرستنیش لێڤییەکان دایدەمەزرێننەوە. هەرکەسێکی دیکە جگە لە لێڤییەکان لێی نزیک بێتەوە دەکوژرێت. ");
INSERT INTO ckb_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","نەوەی ئیسرائیل هەریەکە لە ئۆردوگای خۆی لەژێر بەیداخەکەی خۆی بەپێی لەشکرەکانیان چادر هەڵدەدەن. ");
INSERT INTO ckb_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","بەڵام لێڤییەکان لە چواردەوری چادرەکەی پەیمان چادر هەڵدەدەن، هەتا تووڕەیی نەیەتە سەر کۆمەڵی نەوەی ئیسرائیل، جا لێڤییەکان بەرپرسیار دەبن لە پارێزگاری چادری پەیمان.» ");
INSERT INTO ckb_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","نەوەی ئیسرائیلیش ئاوایان کرد، بەگوێرەی هەموو ئەوەی یەزدان فەرمانی بە موسا کرد. ");
INSERT INTO ckb_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","هەروەها یەزدان بە موسا و هارونی فەرموو: ");
INSERT INTO ckb_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","«با نەوەی ئیسرائیل، هەریەکە لەژێر بەیداخەکەی خۆی، بە لافیتەکانی بنەماڵەکانیانەوە چادر هەڵبدەن، ڕووەو چادری چاوپێکەوتن و دەوروبەری.» ");
INSERT INTO ckb_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","لەلای ڕۆژهەڵات، هۆزی یەهودا ڕووەو خۆر هەڵاتن لەژێر بەیداخی ئۆردوگاکەیان بەگوێرەی لەشکرەکانیان چادر هەڵدەدەن، سەرۆکی نەوەی یەهوداش نەحشۆنی کوڕی عەمینادابە. ");
INSERT INTO ckb_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","ژمارەی سەربازە تۆمارکراوەکانیش حەفتا و چوار هەزار و شەش سەد کەسە. ");
INSERT INTO ckb_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","پاشان هۆزی یەساخار لەتەنیشتیانەوە چادر هەڵدەدەن، سەرۆکی نەوەی یەساخاریش نەتەنێلی کوڕی چوعەر. ");
INSERT INTO ckb_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","ژمارەی سەربازە تۆمارکراوەکانیش پەنجا و چوار هەزار و چوار سەد کەسە. ");
INSERT INTO ckb_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","پاشان هۆزی زەبولون دێت، سەرۆکی نەوەی زەبولونیش ئەلیابی کوڕی حێلۆنە. ");
INSERT INTO ckb_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","ژمارەی سەربازە تۆمارکراوەکانیش پەنجا و حەوت هەزار و چوار سەد کەسە. ");
INSERT INTO ckb_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","هەموو پیاوانی دانراویش لە ئۆردوگای یەهودا، بەگوێرەی لەشکرەکانیان سەد و هەشتا و شەش هەزار و چوار سەد کەسن، یەکەمن لە بەڕێکەوتندا. ");
INSERT INTO ckb_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","لەلای باشوور، هۆزی ڕەئوبێن لەژێر بەیداخی ئۆردوگاکەیان بەگوێرەی لەشکرەکانیان چادر هەڵدەدەن، سەرۆکی نەوەی ڕەئوبێنیش ئەلیسوری کوڕی شەدیئورە. ");
INSERT INTO ckb_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","ژمارەی سەربازە تۆمارکراوەکانیش چل و شەش هەزار و پێنج سەد کەسە. ");
INSERT INTO ckb_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","پاشان هۆزی شیمۆن لەتەنیشتیانەوە چادر هەڵدەدەن، سەرۆکی نەوەی شیمۆنیش شەلومیێلی کوڕی چووریشەدایە. ");
INSERT INTO ckb_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","ژمارەی سەربازە تۆمارکراوەکانی پەنجا و نۆ هەزار و سێ سەد کەسە. ");
INSERT INTO ckb_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","پاشان هۆزی گاد دێت، سەرۆکی نەوەی گادیش ئەلیاسافی کوڕی دەعوئێلە. ");
INSERT INTO ckb_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","ژمارەی سەربازە تۆمارکراوەکانیش چل و پێنج هەزار و شەش سەد و پەنجا کەسە. ");
INSERT INTO ckb_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","هەموو پیاوانی دانراویش لە ئۆردوگای ڕەئوبێن، بەگوێرەی لەشکرەکانیان سەد و پەنجا و یەک هەزار و چوار سەد و پەنجا کەسن، دووەمن لە بەڕێکەوتندا. ");
INSERT INTO ckb_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","ئینجا چادری چاوپێکەوتن، ئۆردوگای لێڤییەکان لەناوەندی ئۆردوگاکان بەڕێ دەکەوێت، چۆن چادر هەڵدەدەن بە هەمان شێوە بەڕێ دەکەون، هەریەکە و لە شوێنی خۆی لەژێر بەیداخەکەی. ");
INSERT INTO ckb_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","لەلای ڕۆژئاوا، هۆزی ئەفرایم لەژێر بەیداخی ئۆردوگاکەیان بەگوێرەی لەشکرەکانیان چادر هەڵدەدەن، سەرۆکی نەوەی ئەفرایمیش ئەلیشاماعی کوڕی عەمیهودە. ");
INSERT INTO ckb_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","ژمارەی سەربازە تۆمارکراوەکانی چل هەزار و پێنج سەد کەسە. ");
INSERT INTO ckb_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","پاشان هۆزی مەنەشە لەتەنیشتیانەوە دێت، سەرۆکی نەوەی مەنەشەش گەمالائیلی کوڕی پەداهچوورە. ");
INSERT INTO ckb_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","ژمارەی سەربازە تۆمارکراوەکانی سی و دوو هەزار و دوو سەد کەسە. ");
INSERT INTO ckb_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","پاشان هۆزی بنیامین دێت، سەرۆک بۆ نەوەی بنیامینیش ئەبیدانی کوڕی گدعۆنییە. ");
INSERT INTO ckb_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","ژمارەی سەربازە تۆمارکراوەکانیش سی و پێنج هەزار و چوار سەد کەسە. ");
INSERT INTO ckb_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","هەموو پیاوانی دانراویش لە ئۆردوگای ئەفرایم، بەگوێرەی لەشکرەکانیان سەد و هەشت هەزار و سەد کەسن، سێیەمن لە بەڕێکەوتندا. ");
INSERT INTO ckb_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","لەلای باکوور، هۆزی دان لەژێر بەیداخی ئۆردوگاکەیان بەگوێرەی لەشکرەکانیان چادر هەڵدەدەن، سەرۆکی نەوەی دانیش ئەحیعەزەری کوڕی عەمیشەدایە. ");
INSERT INTO ckb_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","ژمارەی سەربازە تۆمارکراوەکانیش شەست و دوو هەزار و حەوت سەد کەسە. ");
INSERT INTO ckb_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","پاشان هۆزی ئاشێر دێت، لەتەنیشتیانەوە چادر هەڵدەدەن، سەرۆکی نەوەی ئاشێریش پەگعیێلی کوڕی عۆخرانە. ");
INSERT INTO ckb_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","ژمارەی سەربازە تۆمارکراوەکانیش چل و یەک هەزار و پێنج سەد کەسە. ");
INSERT INTO ckb_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","پاشان هۆزی نەفتالیش دێت، سەرۆکی نەوەی نەفتالیش ئەحیڕەعی کوڕی عێینانە. ");
INSERT INTO ckb_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","ژمارەی سەربازە تۆمارکراوەکانیش پەنجا و سێ هەزار و چوار سەد کەسە. ");
INSERT INTO ckb_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","هەموو پیاوانی دانراویش لە ئۆردوگای دان سەد و پەنجا و حەوت هەزار و شەش سەد کەسن، لەژێر بەیداخەکانیان لە کۆتاییدا بەڕێ دەکەون. ");
INSERT INTO ckb_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","ئەوانە تۆمارکراوەکانی نەوەی ئیسرائیلن بەگوێرەی بنەماڵەکانیان. هەموو تۆمارکراوان لە ئۆردوگاکان بە لەشکرەکانیانەوە شەش سەد و سێ هەزار و پێنج سەد و پەنجا کەسن. ");
INSERT INTO ckb_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","بەڵام لێڤییەکان لەنێوان نەوەی ئیسرائیلدا تۆمار نەکران، هەروەک یەزدان فەرمانی بە موسا کرد. ");
INSERT INTO ckb_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","جا نەوەی ئیسرائیل بەگوێرەی هەموو ئەوەی یەزدان فەرمانی بە موسا کرد، ئاوایان کرد، ئاوا لەژێر بەیداخەکانیان چادریان هەڵدا و ئاوا بەڕێکەوتن، هەریەکە بەگوێرەی خێڵەکەی خۆی لە بنەماڵەکەی. ");
INSERT INTO ckb_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","ئەمەش نەوەی هارون و موسایە، ئەو ڕۆژەی یەزدان لەگەڵ موسادا لە شاخی سینا دوا. ");
INSERT INTO ckb_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","ئەمەش ناوی کوڕەکانی هارونە، نادابی نۆبەرە و ئەبیهو و ئەلعازار و ئیتامار. ");
INSERT INTO ckb_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","ئەمەش ناوی نەوەکانی هارونە، کاهینە دەستنیشانکراوەکان ئەوانەی ئەرکی کاهینیێتییان پێ سپێردراوە. ");
INSERT INTO ckb_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","ناداب و ئەبیهو لەبەردەم یەزدان مردن، کاتێک لە چۆڵەوانی سینا ئاگرێکی نامۆیان لەبەردەم یەزدان پێشکەش کرد. لەبەر ئەوەی هیچ کوڕیان نەبوو، ئەلعازار و ئیتامار لەبەردەم هارونی باوکیان خزمەتی کاهینیێتییان کرد. ");
INSERT INTO ckb_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","هەروەها یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","«هۆزی لێڤی بهێنە پێش و لەبەردەم هارونی کاهین ڕایانبگرە و با یاریدەدەری بن، ");
INSERT INTO ckb_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","جا هەڵدەستن بە پارێزگاری بۆ ئەو و لە جیاتی هەموو کۆمەڵ لەبەردەم چادری چاوپێکەوتن، بەهۆی کارکردنیان لە چادرەکەی پەرستن. ");
INSERT INTO ckb_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","پارێزگاری لە هەموو قاپوقاچاغەکانی چادری چاوپێکەوتن دەکەن و بە کارکردنیان لە چادرەکەی پەرستن کار بۆ نەوەی ئیسرائیل دەکەن. ");
INSERT INTO ckb_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","لێڤییەکان دەدەیتە هارون و کوڕەکانی، لەنێو نەوەی ئیسرائیلدا ئەوان بە تەواوەتی پێشکەشکراون بەو. ");
INSERT INTO ckb_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","هارون و کوڕەکانی دادەمەزرێنیت و کاهینیێتییەکەیان دەپارێزن و هەرکەسێکی دیکە لە پیرۆزگا نزیک ببێتەوە دەکوژرێت.» ");
INSERT INTO ckb_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","«ئێستا من لێڤییەکان دەبەم، لەنێو نەوەی ئیسرائیل لە جیاتی هەر نۆبەرەیەکی نێر لە سکی ئافرەت کە لە نەوەی ئیسرائیل بێت. ئیتر لێڤییەکان دەبنە هی من، ");
INSERT INTO ckb_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","چونکە هەموو نۆبەرەیەک بۆ منە، ئەو ڕۆژەی لە خاکی میسردا لە هەموو نۆبەرەیەکم دا، ئەوا هەموو نۆبەرەیەک لە ئیسرائیلدا لە خەڵک و لە ئاژەڵ بۆ خۆمم تەرخان کرد، بۆ من دەبن، من یەزدانم.» ");
INSERT INTO ckb_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","هەروەها یەزدان لە چۆڵەوانی سینادا بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","«نەوەی لێڤی بەگوێرەی بنەماڵەکانیان و خێڵەکانیان تۆمار بکە، هەموو نێرینەیەک لە کۆرپەی یەک مانگ بەرەو سەرەوە تۆمار دەکەیت.» ");
INSERT INTO ckb_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","موساش بەگوێرەی فەرمایشتی یەزدان هەروەک فەرمانی کردبوو، تۆماری کردن. ");
INSERT INTO ckb_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","ئەمانە ناوی نەوەکانی لێڤی بوو: گێرشۆن و قەهات و مەراری. ");
INSERT INTO ckb_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","ئەوەش ناوی دوو کوڕەکەی گێرشۆنە بەگوێرەی خێڵەکانیان: لیبنی و شیمعی. ");
INSERT INTO ckb_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","نەوەی قەهاتیش بەگوێرەی خێڵەکانیان: عەمرام و یەسهار و حەبرۆن و عوزیێل. ");
INSERT INTO ckb_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","دوو کوڕەکەی مەراریش بەگوێرەی خێڵەکانیان: مەحلی و موشی. ئەمە خێڵی لێڤییەکانە بەگوێرەی بنەماڵەکانیان. ");
INSERT INTO ckb_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","بۆ گێرشۆن خێڵی لیبنییەکان و خێڵی شیمعییەکان. ئەمە خێڵەکانی گێرشۆنییەکانە، ");
INSERT INTO ckb_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","ژمارەی هەموو نێرینەیەکی کوڕی یەک مانگ بەرەو سەرەوە، تۆمارکراوان لێیان حەوت هەزار و پێنج سەد کەس بوون. ");
INSERT INTO ckb_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","خێڵەکانی گێرشۆنییەکان لە پشت چادری پەرستنەوە بەلای ڕۆژئاوا چادر هەڵدەدەن، ");
INSERT INTO ckb_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","گەورەی بنەماڵەی گێرشۆنییەکانیش ئەلیاسافی کوڕی لائێل بوو. ");
INSERT INTO ckb_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","نەوەی گێرشۆن لە چادری چاوپێکەوتن بەرپرسیار بوون لە پارێزگاری چادرەکەی پەرستن و چادرەکە و پۆشەرەکەی، پەردەی دەروازەی چادری چاوپێکەوتن، ");
INSERT INTO ckb_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","پەردەکانی حەوشەکە و پەردەی دەروازەی حەوشەکە کە لە دەوری چادرەکەی پەرستنە و لە دەوری قوربانگاکەن بە چواردەوری و گوریسەکانی، لەگەڵ هەموو ئەو خزمەتەی پەیوەست بوو پێیانەوە. ");
INSERT INTO ckb_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","بۆ قەهاتیش خێڵی عەمرامییەکان، خێڵی یەسهارییەکان، خێڵی حەبرۆنییەکان و خێڵی عوزیێلییەکان بوون. ئەمە خێڵەکانی قەهاتییەکانە ");
INSERT INTO ckb_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","ژمارەی هەموو نێرینەیەکی کوڕی یەک مانگ بەرەو سەرەوە هەشت هەزار و شەش سەد کەس بوون. قەهاتییەکان بەرپرسیار بوون لە پارێزگاری پیرۆزگا. ");
INSERT INTO ckb_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","خێڵەکانی نەوەی قەهات لەلای باشووری چادرەکەی پەرستن چادر هەڵدەدەن. ");
INSERT INTO ckb_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","گەورەی بنەماڵەکانی خێڵەکانی قەهاتییەکانیش ئەلیچافانی کوڕی عوزیێل بوو. ");
INSERT INTO ckb_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","بەرپرسیار بوون لە پارێزگاری سندوقەکە، مێزەکە، چرادانەکە، قوربانگاکان، قاپوقاچاغی پیرۆزگاکە کە خزمەتی پێ دەکەن، پەردەی شوێنی هەرەپیرۆز و هەموو ئەوەی لەگەڵی بەکاردەهێنرێت. ");
INSERT INTO ckb_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","بۆ سەرۆکی سەرکردەکانی لێڤییەکانیش ئەلعازاری کوڕی هارونی کاهین، سەرپەرشتیار بوو بەسەر ئەو کەسانەی کە بەرپرسیار بوون لە پارێزگاری پیرۆزگا. ");
INSERT INTO ckb_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","بۆ مەراری، خێڵی مەحلییەکان و خێڵی موشییەکان، ئەمە خێڵەکانی مەرارییە. ");
INSERT INTO ckb_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","تۆمارکراوان لێیان بەپێی ژمارەی هەموو نێرینەیەکی کوڕی یەک مانگ بەرەو سەرەوە شەش هەزار و دوو سەد کەس بوون. ");
INSERT INTO ckb_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","گەورەی بنەماڵەی خێڵەکانی مەراریش چووریێلی کوڕی ئەبیحەیلە، لەلای باکووری چادرەکەی پەرستن چادر هەڵدەدەن. ");
INSERT INTO ckb_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","نەوەی مەراریش سەرپەرشتیاری پارێزگاریکردن بوون لە چوارچێوەکانی چادرەکەی پەرستن، هەروەها کاریتە، کۆڵەکە، بناغە، هەموو کەلوپەلەکانی و هەموو ئەوەی لەگەڵیدا بەکاردەهێنرێت، ");
INSERT INTO ckb_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","هەروەها کۆڵەکەکانی حەوشەکە لە چواردەوری و بنکە و سنگ و گوریسەکانی. ");
INSERT INTO ckb_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","موسا و هارون و کوڕەکانی لەلای ڕۆژهەڵاتی چادرەکەی پەرستن، ڕووەو ڕۆژهەڵات لەبەردەم چادری چاوپێکەوتن چادر هەڵدەدەن. بەرپرسیار بوون لە پارێزگاری پیرۆزگا لە جیاتی نەوەی ئیسرائیل، هەرکەسێکی دیکەش کە لە پیرۆزگا نزیک بکەوتبایەوە دەکوژرا. ");
INSERT INTO ckb_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","هەموو تۆمارکراوانی لێڤییەکان ئەوانەی موسا و هارون بەپێی فەرمایشتی یەزدان بەگوێرەی خێڵەکانیان تۆماریان کردن، هەموو نێرینەیەکی کوڕی یەک مانگ بەرەو سەرەوە بیست و دوو هەزار کەس بوون. ");
INSERT INTO ckb_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","هەروەها یەزدان بە موسای فەرموو: «هەموو نێرینەیەکی نۆبەرە لە نەوەی ئیسرائیل لە کۆرپەی یەک مانگ بەرەو سەرەوە تۆمار بکە و لیستی ناوەکانیان وەربگرە. ");
INSERT INTO ckb_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","من یەزدانم، لێڤییەکان لە جیاتی هەموو نۆبەرەیەکی نەوەی ئیسرائیل و مەڕوماڵاتی لێڤییەکانیش لە جیاتی هەموو نۆبەرەیەک لە مەڕوماڵاتی نەوەی ئیسرائیل بۆ من دادەنێیت.» ");
INSERT INTO ckb_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","جا موسا وەک یەزدان فەرمانی پێ کرد هەموو نۆبەرەیەکی لە نەوەی ئیسرائیل تۆمار کرد، ");
INSERT INTO ckb_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","هەموو کۆرپەیەکی نۆبەرەی نێرینە لە تەمەنی یەک مانگ بەرەو سەرەوە لە لیستی ناوەکان تۆمارکران، بیست و دوو هەزار و دوو سەد و حەفتا و سێ کەس بوون. ");
INSERT INTO ckb_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","«لێڤییەکان لە جیاتی هەموو نۆبەرەیەک لە نەوەی ئیسرائیل دابنێ و مەڕوماڵاتی لێڤییەکانیش لە جیاتی مەڕوماڵاتەکانیان، جا لێڤییەکان بۆ من دەبن. من یەزدانم. ");
INSERT INTO ckb_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","بۆ کڕینەوەی ئەو دوو سەد و حەفتا و سێیەش لە نۆبەرەکانی نەوەی ئیسرائیل کە لە لێڤییەکان زیاترن، ");
INSERT INTO ckb_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","پێنج شاقل بۆ هەر سەرێک وەردەگریت، بەگوێرەی شاقلی پیرۆزگا وەریدەگریت. هەر شاقلێک بیست گێرایە. ");
INSERT INTO ckb_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","زیوەکەش دەدەیتە هارون و کوڕەکانی، کڕینەوەی ئەوانەیە کە لێیان زیادن.» ");
INSERT INTO ckb_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","جا موسا زیوی کڕینەوەیانی وەرگرت، لەوانەی لە کڕینەوەی لێڤییەکان زیاد بوون، ");
INSERT INTO ckb_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","لە نۆبەرەکانی نەوەی ئیسرائیل هەزار و سێ سەد و شەست و پێنج زیوی بەگوێرەی شاقلی پیرۆزگا وەرگرت. ");
INSERT INTO ckb_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","موساش زیوی کڕینەوەکەی بە هارون و کوڕەکانی دا بەگوێرەی فەرمایشتی یەزدان، هەروەک یەزدان فەرمانی بە موسا کردبوو. ");
INSERT INTO ckb_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","یەزدان بە موسا و هارونی فەرموو: ");
INSERT INTO ckb_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","«سەرژمێری نەوەی قەهات لەنێو نەوەی لێڤییەکان بکەن، بەگوێرەی خێڵەکانیان و بنەماڵەکانیان، ");
INSERT INTO ckb_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","لە پیاوی سی ساڵ بەرەو سەرەوە هەتا پەنجا ساڵ، هەموو ئەوانەی دەتوانن بچن بۆ خزمەت هەتا لە چادری چاوپێکەوتن کار بکەن. ");
INSERT INTO ckb_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","«نەوەی قەهات خزمەتی شتە هەرەپیرۆزەکانی ناو چادری چاوپێکەوتن دەکەن. ");
INSERT INTO ckb_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","هارون و کوڕەکانی لە کاتی کۆچکردنی ئۆردوگا دێن و پەردەکەی شوێنی هەرەپیرۆز هەڵدەگرنەوە و سندوقی شایەتی پێ دادەپۆشن. ");
INSERT INTO ckb_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","ئینجا پۆشەرەکەی لە پێستی مانگای دەریا بەسەردا دەدەن و لەسەر ئەوەشەوە قوماشێک هەمووی ڕیسی مۆر بێت ڕایدەخەن و دارەکانیشی دەخەنە شوێنی خۆی. ");
INSERT INTO ckb_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","«لەسەر مێزی نانی تەرخانکراو بۆ خودا قوماشێکی لە ڕیسی مۆر ڕادەخەن و لەگەن و قاپ و تاس و دۆلکەکانی شەرابی پێشکەشکراوی لەسەری دادەنێن و بەردەوام نانەکەی لەسەر دەبێت. ");
INSERT INTO ckb_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","قوماشێکی سووری ئاڵیشی لەسەر ڕادەخەن و بە پۆشەرێک لە پێستی مانگای دەریا دای دەپۆشن و دارەکانی دەخەنە شوێنی خۆی. ");
INSERT INTO ckb_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","«قوماشێک لە ڕیسی مۆر دەبەن و چرادانەکەی ڕووناکی و چراکانی و مەقاش و مەقەڵی و هەموو قاپوقاچاغەکانی زەیتەکەی کە خزمەتی پێ دەکەن دادەپۆشن. ");
INSERT INTO ckb_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","لەگەڵ هەموو قاپوقاچاغەکەی دەیخەنە ناو پۆشەرێک لە پێستی مانگای دەریا و دەیخەنە سەر هەڵگرێک. ");
INSERT INTO ckb_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","«لەسەر قوربانگا زێڕینەکەش قوماشێکی ڕیسی مۆر ڕادەخەن و بە پۆشەرێک لە پێستی مانگای دەریا دایدەپۆشن و دارەکانی دەخەنە شوێنی خۆی. ");
INSERT INTO ckb_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","«هەموو قاپوقاچاغەکانی خزمەتکردن کە خزمەتی پێ دەکەن لە پیرۆزگا دەیبەن و لەناو قوماشێکی ڕیسی مۆر دایدەنێن و بە پۆشەرێک لە پێستی مانگای دەریا دای دەپۆشن و دەیخەنە سەر هەڵگرێک. ");
INSERT INTO ckb_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","«خۆڵەمێشی قوربانگا بڕۆنزییەکەش هەڵدەگرن و قوماشێکی ئەرخەوانی لەسەر ڕادەخەن. ");
INSERT INTO ckb_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","هەموو قاپوقاچاغەکانی کە لە قوربانگاکە بۆ خزمەت بەکاریدەهێنن دەیخەنە سەری، مەقەڵییەکان، چەنگاڵەکان، خاکەنازەکان و تاسەکان، هەموو قاپوقاچاغی قوربانگاکە، پۆشەرێک لە پێستی مانگای دەریاشی بەسەردا ڕادەخەن و دارەکانی دەخەنە شوێنی خۆی. ");
INSERT INTO ckb_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","«کاتێک هارون و کوڕەکانی لە پۆشینی پیرۆزگاکە و هەموو قاپوقاچاغی پیرۆزگاکە دەبنەوە، لە کاتی کۆچکردنی ئۆردوگاکە، ئینجا نەوەی قەهات بۆ هەڵگرتن دێن، بەڵام دەست لە شتە پیرۆزکراوەکان نادەن نەوەک بمرن، ئەوە بارهەڵگرتنی نەوەی قەهاتە لە چادری چاوپێکەوتن. ");
INSERT INTO ckb_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","«ئەلعازاری کوڕی هارونی کاهینیش سەرپەرشتی زەیتی ڕووناکی، بخوورە بۆنخۆشەکە، پێشکەشکراوی دانەوێڵەی بەردەوام و زەیتی دەستنیشانکردن دەکات. هەروەها سەرپەرشتی هەموو چادرەکەی پەرستن دەکات، هەموو ئەوەی تێیدایە، بە شتومەکە پیرۆزەکانی و قاپوقاچاغەکانییەوە.» ");
INSERT INTO ckb_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","هەروەها یەزدان بە موسا و هارونی فەرموو: ");
INSERT INTO ckb_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","«خێڵەکانی قەهاتییەکان لەنێو لێڤییەکان دامەبڕن، ");
INSERT INTO ckb_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","بەڵکو ئەمەیان بۆ بکەن، جا دەژین و لە کاتی نزیککەوتنەوەیان لە شتە هەرەپیرۆزەکان نامرن، هارون و کوڕەکانی دەچنە ژوورەوەی پیرۆزگاکە و هەرکەسێک لەسەر خزمەتەکەی و بارەکەی دادەنێن. ");
INSERT INTO ckb_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","بەڵام بۆ ساتێک قەهاتییەکان ناچنە ژوورەوە بۆ ئەوەی شتە پیرۆزکراوەکان ببینن نەوەک بمرن.» ");
INSERT INTO ckb_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","«سەرژمێری نەوەی گێرشۆنیش بکە بەگوێرەی بنەماڵە و خێڵەکانیان. ");
INSERT INTO ckb_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","لە پیاوی سی ساڵ بەرەو سەرەوە هەتا پەنجا ساڵ تۆمار بکە، هەموو ئەوانەی کە دێن بۆ ئەوەی لە چادری چاوپێکەوتندا خزمەت بکەن. ");
INSERT INTO ckb_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","«ئەمەش خزمەتی خێڵەکانی گێرشۆنییەکانە لە خزمەت و لە بارهەڵگرتن، ");
INSERT INTO ckb_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","پڵاسەکانی چادرەکەی پەرستن و چادری چاوپێکەوتن و پۆشەرەکەی و پۆشەرە پێست مانگای دەریاکە کە لە سەرەوە لەسەریەتی و پەردەکەی دەروازەی چادری چاوپێکەوتن هەڵدەگرن. ");
INSERT INTO ckb_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","هەروەها پەردەکانی حەوشەکە، ئەوانەی لە دەوری چادری پەرستن و لە دەوری قوربانگاکەن بە چواردەوریدا، پەردەی دەروازەی حەوشەکە، لەگەڵ گوریسەکانی و هەموو ئەوەی لەگەڵیدا بۆ خزمەت بەکاردەهێنرێت، هەموو ئەوەی بۆیان دیاری دەکرێت، گێرشۆنییەکان دەیکەن. ");
INSERT INTO ckb_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","هەموو خزمەتی نەوەی گێرشۆنییەکان چ لە بارهەڵگرتن یان هەر کارێکی دیکە بە سەرپەرشتی هارون و کوڕەکانی دەبێت، تۆش دیاریکردنی بەرپرسیاریێتی هەموو بارەکانی خۆیان پێ دەسپێریت، ");
INSERT INTO ckb_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","ئەمە خزمەتی خێڵەکانی نەوەی گێرشۆنییەکانە لە چادری چاوپێکەوتن و ئیتاماری کوڕی هارونی کاهین سەرپەرشتییان دەکات. ");
INSERT INTO ckb_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","«نەوەی مەراری بەگوێرەی خێڵ و بنەماڵەکانیان تۆمار بکە. ");
INSERT INTO ckb_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","لە پیاوی سی ساڵ بەرەو سەرەوە هەتا پەنجا ساڵ تۆمار بکە، هەموو ئەوانەی دەچنە خزمەت هەتا خزمەتەکەی چادری چاوپێکەوتن بکەن. ");
INSERT INTO ckb_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","بەرپرسیاریێتی خزمەتەکەشیان لە چادری چاوپێکەوتن، بریتییە لە هەڵگرتنی چوارچێوەکانی چادرەکەی پەرستن و کاریتەکانی، کۆڵەکەکانی، بناغەکانی، ");
INSERT INTO ckb_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","کۆڵەکەکانی حەوشەکە بە چواردەوریدا، بناغەکانی، سنگەکانی و گوریسەکانی لەگەڵ هەموو قاپوقاچاغ و هەموو ئەوەی لەگەڵیدا بەکاردەهێنرێت. بە ناویش هەر پیاوێک دیاری بکە بۆ ئەو شتەی پێویستە هەڵیبگرێت. ");
INSERT INTO ckb_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","ئەمە خزمەتی خێڵەکانی نەوەی مەرارییە، هەموو خزمەتەکەیان لە چادری چاوپێکەوتن بە سەرپەرشتی ئیتامار کوڕی هارونی کاهینە.» ");
INSERT INTO ckb_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","جا موسا و هارون و ڕابەرەکانی کۆمەڵ نەوەی قەهاتییەکانیان تۆمار کرد، بەگوێرەی خێڵەکانیان و بنەماڵەکانیان، ");
INSERT INTO ckb_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","لە پیاوی سی ساڵ بەرەو سەرەوە هەتا پەنجا ساڵ، هەموو ئەوانەی دەچنە خزمەتەوە بۆ خزمەتکردن لە چادری چاوپێکەوتن. ");
INSERT INTO ckb_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","جا تۆمارکراوەکانیان بەگوێرەی خێڵەکانیان دوو هەزار و حەوت سەد و پەنجا کەس بوون. ");
INSERT INTO ckb_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","ئەوانە تۆمارکراوەکانن لە خێڵەکانی قەهاتییەکان، هەموو ئەوانەی لە چادری چاوپێکەوتندا خزمەت دەکەن، ئەوانەی موسا و هارون بەگوێرەی فەرمایشتی یەزدان لەسەر دەستی موسا تۆماریان کردن. ");
INSERT INTO ckb_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","تۆمارکراوەکانی نەوەی گێرشۆنیش بەگوێرەی خێڵەکانیان و بنەماڵەکانیان، ");
INSERT INTO ckb_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","لە پیاوی سی ساڵ بەرەو سەرەوە هەتا پەنجا ساڵ، هەموو ئەوانەی دەچنە خزمەتەوە بۆ خزمەتکردن لە چادری چاوپێکەوتن، ");
INSERT INTO ckb_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","تۆمارکراوەکانیان بەگوێرەی خێڵەکانیان و بنەماڵەکانیان دوو هەزار و شەش سەد و سی کەس بوون. ");
INSERT INTO ckb_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","ئەوانە تۆمارکراوەکانن لە خێڵەکانی نەوەی گێرشۆن، هەموو ئەوانەی لە چادری چاوپێکەوتندا خزمەت دەکەن، ئەوانەی موسا و هارون بەگوێرەی فەرمایشتی یەزدان تۆماریان کردن. ");
INSERT INTO ckb_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","تۆمارکراوان لە خێڵەکانی نەوەی مەراریش بەگوێرەی خێڵەکانیان و بنەماڵەکانیان ");
INSERT INTO ckb_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","لە پیاوی سی ساڵ بەرەو سەرەوە هەتا پەنجا ساڵ، هەموو ئەوانەی دەچنە خزمەتەوە بۆ خزمەتکردن لە چادری چاوپێکەوتندا، ");
INSERT INTO ckb_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","تۆمارکراوەکانیان بەگوێرەی خێڵەکانیان سێ هەزار و دوو سەد کەس بوون. ");
INSERT INTO ckb_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","ئەوانە تۆمارکراوەکانن لە خێڵەکانی نەوەی مەراری کە موسا و هارون بەگوێرەی فەرمایشتی یەزدان لەسەر دەستی موسا تۆماریان کردن. ");
INSERT INTO ckb_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","هەموو تۆمارکراوەکانی لێڤییەکان کە موسا و هارون و سەرکردەکانی ئیسرائیل تۆماریان کردن بەگوێرەی خێڵەکانیان و بنەماڵەکانیان، ");
INSERT INTO ckb_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","لە پیاوی سی ساڵ بەرەو سەرەوە هەتا پەنجا ساڵ، هەموو ئەوانەی دەچنە خزمەتەوە بۆ کاری خزمەت و کاری بارهەڵگرتن لە چادری چاوپێکەوتندا، ");
INSERT INTO ckb_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","تۆمارکراوان لێیان هەشت هەزار و پێنج سەد و هەشتا کەس بوون. ");
INSERT INTO ckb_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","بەپێی فەرمایشتی یەزدان لەسەر دەستی موسا، هەرکەسێک بەگوێرەی خزمەتەکەی و بارهەڵگرتنەکەی تۆمارکرا. بەم شێوەیە موسا تۆماری کردن وەک چۆن یەزدان فەرمانی پێ کرد. ");
INSERT INTO ckb_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","«فەرمان بە نەوەی ئیسرائیل بکە کە هەرکەسێک نەخۆشی گواستراوەی پێست یان ئەوەی لێچوونی گڵاوی هەبێت، یان ئەوەی بە مردوو گڵاو بووبێت، لە ئۆردوگاکە دووریان بخەنەوە. ");
INSERT INTO ckb_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","نێر و مێ دوور دەخەنەوە، بۆ دەرەوەی ئۆردوگا دووریان دەخەنەوە هەتا ئۆردوگاکانیان گڵاو نەکەن کە من لەنێویاندا نیشتەجێم.» ");
INSERT INTO ckb_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","جا نەوەی ئیسرائیل ئاوایان کرد و بۆ دەرەوەی ئۆردوگاکە دووریان خستنەوە، هەروەک چۆن یەزدان لەگەڵ موسادا دوا، نەوەی ئیسرائیل ئاوایان کرد. ");
INSERT INTO ckb_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","«بە نەوەی ئیسرائیل بڵێ: ”ئەگەر پیاوێک یان ئافرەتێک گوناهێک لە گوناهەکانی مرۆڤ بکات، واتا ناپاکی لەگەڵ یەزدان کرد، ئەوا ئەو کەسە تاوانی کردووە، ");
INSERT INTO ckb_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","با دان بە گوناهەکەیدا بنێت کە کردوویەتی و ئەوەی پێی تاوانبار بووە بە تەواوی بیگەڕێنێتەوە، پێنج یەکیشی بۆ زیاد بکات و بیداتە ئەوەی تاوانەکەی لە دژی کردووە. ");
INSERT INTO ckb_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","بەڵام ئەگەر ئەو کەسە مردوو بوو و خزمی نزیکی نەبوو هەتا وەریبگرێتەوە، ئەوا ئەوەی پێی تاوانبار بووە دەگەڕێتەوە بۆ یەزدان و بۆ کاهین دەبێت، لەگەڵ بەرانێک کە کەفارەتی پێ دەکات بۆی. ");
INSERT INTO ckb_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","هەموو پیتاکێک و دیارییەکی پیرۆزی نەوەی ئیسرائیل کە پێشکەشی کاهینی دەکەن بۆ ئەو دەبێت. ");
INSERT INTO ckb_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","هەموو دیارییە پیرۆزکراوەکانی مرۆڤیش بۆ خۆی دەبێت، بەڵام ئەگەر کەسێک شتێکی دا بە کاهین ئەوا بۆ کاهین دەبێت.“» ");
INSERT INTO ckb_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","«لەگەڵ نەوەی ئیسرائیل بدوێ و پێیان بڵێ: ”ئەگەر ژنی پیاوێک لەڕێ لایدا و ناپاکی لەگەڵ کرد، ");
INSERT INTO ckb_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","لەگەڵ پیاوێک جووت بوو، ئەوەش لە چاوانی پیاوەکەی شاردراوە بوو و داوێنپیسییەکەی ئاشکرا نەبوو، هیچ شایەتێکیشی بەسەرەوە نەبوو، چونکە لەسەر کردارەکە نەگیرا بوو، ");
INSERT INTO ckb_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","کابراش ڕۆحی دڵپیسی دایگرت و لە ژنەکەی بە گومان بوو کە داوێنپیسە، یان ڕۆحی دڵپیسی دایگرت و لە ژنەکەی بە گومان بوو کە داوێنپیس نییە، ");
INSERT INTO ckb_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","ئەوا پیاوەکە ژنەکەی دەهێنێتە لای کاهین و پێشکەشکراوەکەشی لەگەڵدا دەهێنێت، دەیەکی ئێفەیەک ئاردی جۆ نە زەیتی بەسەردا دەکات و نە بخوور، چونکە پێشکەشکراوی دانەوێڵەی دڵپیسییە و قوربانی یادگارییە، یادی تاوان دەکاتەوە. ");
INSERT INTO ckb_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","«”کاهینەکە ژنەکە دەهێنێتە پێش و لەبەردەم یەزدان ڕایدەگرێت. ");
INSERT INTO ckb_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","کاهینەکە لە گۆزەیەکی گڵین ئاوێکی پیرۆز دەبات و لە تۆزی سەر زەوی چادرەکەی پەرستن هەڵدەگرێت و لەناو ئاوەکەی دەکات. ");
INSERT INTO ckb_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","کاهینەکە ژنەکە لەبەردەم یەزدان ڕادەگرێت و سەری ڕووت دەکاتەوە، پێشکەشکراوی دانەوێڵەی یادەوەرییەکە کە پێشکەشکراوی دانەوێڵەی دڵپیسییە دەکاتە ناو دەستی ژنەکە و ئاوە تاڵەکەی نەفرەتیش لە دەستی کاهینەکە دەبێت. ");
INSERT INTO ckb_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","ئینجا کاهینەکە ژنەکە سوێند دەدات و پێی دەڵێت: ’ئەگەر هیچ پیاوێک لەگەڵت جووت نەبووە و بە دزی پیاوەکەت بەرەو داوێنپیسی لەڕێ لات نەداوە، لە کاتێکدا ژنی پیاوەکەتی ئەوا بێتاوان بە لەم ئاوەی نەفرەت کە تاڵە. ");
INSERT INTO ckb_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","بەڵام ئەگەر بە دزی پیاوەکەت لەڕێ لاتداوە و گڵاو بوویت و پیاوێکی دیکە جیا لە مێردەکەت لەگەڵت جووت بووە،‘ ");
INSERT INTO ckb_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","لێرە کاهینەکە ژنەکە بە سوێندی نەفرەت سوێند دەدات، کاهینەکە بە ژنەکە دەڵێت، ’یەزدان دەتخاتە بەر نەفرەت و سوێند لەنێو گەلەکەت بەوەی کە یەزدان ڕانت لاواز دەکات و سکت دەئاوسێنێت. ");
INSERT INTO ckb_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","ئەم ئاوەی نەفرەت دەچێتە ناو هەناوت بۆ ئاوسانی سک و لاوازی ڕان.‘ «”ژنەش دەڵێت، ’ئامین، ئامین.‘ ");
INSERT INTO ckb_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","«”کاهینیش ئەم نەفرەتانە لە پەڕەیەک دەنووسێت، ئینجا لەناو ئاوە تاڵەکە دەیشواتەوە. ");
INSERT INTO ckb_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","ئاوە تاڵەکەی نەفرەتیش دەرخواردی ژنەکە دەدات، ئاوەکەی نەفرەتیش دەچێتە ناوی و دەبێتە ئازاری تاڵی. ");
INSERT INTO ckb_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","کاهینەکە پێشکەشکراوی دانەوێڵەی دڵپیسییەکە لە دەستی ژنەکە وەردەگرێت و پێشکەشکراوەکە لەبەردەم یەزدان بەرز دەکاتەوە، ئینجا دەیباتە لای قوربانگاکە. ");
INSERT INTO ckb_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","کاهینەکە چنگێک بۆ یادەوەری لە دانەوێڵە پێشکەشکراوەکە دەبات و لەسەر قوربانگاکە دەیسووتێنێت، لەدوای ئەوە ئاوەکە دەرخواردی ژنەکە دەدات. ");
INSERT INTO ckb_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","ئەگەر ژنەکە گڵاو بووبێت و ناپاکی لە پیاوەکەی کردبێت، کاتێک ئاوەکەی دەرخوارد دا، ئەوا ئاوە نەفرەتەکە دەبێتە ئازاری تاڵی، دەچێتە ناوی، سکی دەئاوسێت و ڕانی دەکەوێت، ژنەکە لەنێو گەلەکەی دەبێتە نەفرەت. ");
INSERT INTO ckb_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","ئەگەر ژنەکەش گڵاو نەببوو بەڵکو پاک بوو، ئەوا بێتاوان دەبێت و سکی پڕ دەبێت. ");
INSERT INTO ckb_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","«”ئەمە فێرکردنەکەیە سەبارەت بە دڵپیسی، ئەگەر ژنێک بە دزی پیاوەکەی لەڕێ لایدا و گڵاو بوو، لە کاتێکدا ژنی پیاوەکەیەتی، ");
INSERT INTO ckb_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","یان ئەگەر پیاوێک ڕۆحی دڵپیسی دایگرت، جا دڵی لە ژنەکەی پیس کرد، ژنەکە لەبەردەم یەزدان ڕادەگیرێت و کاهینەکە هەموو ئەم فێرکردنەی بۆ دەکات. ");
INSERT INTO ckb_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","جا پیاوەکە لە هەر هەڵەیەک بێتاوان دەبێت، بەڵام ئەو ژنە تاوانی گوناهی لە ئەستۆی خۆی هەڵدەگرێت.“» ");
INSERT INTO ckb_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","«لەگەڵ نەوەی ئیسرائیل بدوێ و پێیان بڵێ: ”ئەگەر پیاوێک یان ژنێک سوێندێکی تایبەتی خوارد بەوەی نەزر بکات، خۆی بۆ یەزدان تەرخان بکات. ");
INSERT INTO ckb_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","لە شەراب و مەی خۆی دوور دەخاتەوە و سرکەی شەراب و سرکەی مەی ناخواتەوە و خۆشاوی ترێ ناخواتەوە و ترێ و کشمیش ناخوات. ");
INSERT INTO ckb_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","هەموو ڕۆژانی خۆتەرخانکردنەکەی هیچ شتێک لە هەموو ئەوەی لە بەری مێو دروستدەکرێت ناخوات، تەنانەت تۆو و توێکڵیش. ");
INSERT INTO ckb_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","«”هەموو ڕۆژانی نەزر و خۆتەرخانکردنەکەی گوێزان بە سەریدا ناهێنرێت، پێویستە هەتا تەواوی ئەو ڕۆژانەی خۆی تەرخان کردووە بۆ یەزدان، پیرۆز بێت و قژی بهێڵێتەوە. ");
INSERT INTO ckb_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","«”هەموو ڕۆژانی خۆتەرخانکردنەکەی بۆ یەزدان لە لاشەی مردوو نزیک ناکەوێتەوە، ");
INSERT INTO ckb_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","بۆ دایک و باوک و برا و خوشکیشی، خۆی گڵاو ناکات لە کاتی مردنیان، چونکە خۆتەرخانکردنی بۆ خودای خۆی بەسەر سەرەوەیە. ");
INSERT INTO ckb_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","هەموو ڕۆژانی خۆتەرخانکردنەکەی بۆ یەزدان پیرۆز دەبێت. ");
INSERT INTO ckb_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","«”ئەگەر یەکێکیش کتوپڕ لەلای مرد و قژە تەرخانکراوەکەی گڵاوکرد، ئەوا لە ڕۆژی پاکبوونەوەکەی سەری دەتاشێت، لە ڕۆژی حەوتەم دەیتاشێت. ");
INSERT INTO ckb_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","لە ڕۆژی هەشتەمیش دوو کوکوختی یان دوو بێچووە کۆتر دەهێنێتە لای کاهین بۆ دەروازەی چادری چاوپێکەوتن. ");
INSERT INTO ckb_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","کاهینیش یەکێکیان دەکاتە قوربانی گوناه و ئەوەی دیکە قوربانی سووتاندن و کەفارەتی بۆ دەکات لەو گوناهەی بەهۆی ئەو مردووەوە کردوویەتی و لەو ڕۆژەدا سەری تەرخان دەکاتەوە. ");
INSERT INTO ckb_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","کاتێک ڕۆژانی خۆتەرخانکردنەکەی بۆ یەزدان تەرخان کردەوە، ئەوا بەرخێکی نێری یەک ساڵە وەک قوربانی تاوان دەهێنێت، بەڵام ڕۆژەکانی پێشتری هەژمارد ناکرێت، چونکە خۆتەرخانکردنەکەی گڵاو کردووە. ");
INSERT INTO ckb_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","«”ئەمەش فێرکردنەکەیە دەربارەی ئەوەی خۆی تەرخان دەکات، ئەو ڕۆژەی ڕۆژانی خۆتەرخانکردنەکەی تەواو دەبێت دەهێنرێتە لای دەروازەی چادری چاوپێکەوتن. ");
INSERT INTO ckb_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","جا قوربانییەکەی بۆ یەزدان پێشکەش دەکات، بەرخێکی نێری یەک ساڵەی ساغ بۆ قوربانی سووتاندن، بەرخێکی مێیەی یەک ساڵەی ساغ بۆ قوربانی گوناه، بەرانێکی بێ کەموکوڕی بۆ قوربانی هاوبەشی، ");
INSERT INTO ckb_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","سەبەتەیەک نان بەبێ هەویرترش، کولێرە بە باشترین ئارد، زەیت شێلراو و ناسکە نانی بە زەیت چەورکراو، لەگەڵ پێشکەشکراوی دانەوێڵەیان و شەرابی پێشکەشکراویان. ");
INSERT INTO ckb_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","«”جا کاهین لەبەردەم یەزدان پێشکەشی دەکات، قوربانی گوناهەکە و قوربانی سووتاندنەکەی دەکات، ");
INSERT INTO ckb_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","کاهینەکە سەبەتە نانە فەتیرەکە و بەرانەکەش دەکاتە قوربانی هاوبەشی بۆ یەزدان، لەگەڵ پێشکەشکراوی دانەوێڵە و شەرابی پێشکەشکراو. ");
INSERT INTO ckb_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","«”لەدوای ئەوە لەلای دەروازەی چادری چاوپێکەوتن خۆتەرخانکەرەکە سەرە تەرخانکراوەکەی دەتاشێت و مووی سەرە تەرخانکراوەکەی دەبات و دەیکاتە سەر ئەو ئاگرەی لەژێر قوربانییەکەی هاوبەشییە. ");
INSERT INTO ckb_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","«”پاش ئەوەی خۆتەرخانکەرەکە قژی خۆتەرخانکردنەکەی دەتاشێت، کاهینەکە شانی بەرانەکە بە کوڵاوی و کولێرەیەکی فەتیرە لە سەبەتەکە لەگەڵ ناسکە نانێکی فەتیرە دەبات و دەیانخاتە ناو دەستی خۆتەرخانکەرەکە. ");
INSERT INTO ckb_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","کاهینیش لەبەردەم یەزدان وەک قوربانی بەرزکردنەوە بەرزیان دەکاتەوە، ئەو بەشە بۆ کاهین پیرۆزکراوە لەگەڵ سنگی بەرزکراوە و ڕانەکەی کە پێشکەشکراوە، ئینجا ئەوەی خۆی تەرخان کردووە شەراب دەخواتەوە. ");
INSERT INTO ckb_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","«”ئەمە فێرکردنەکەیە دەربارەی خۆتەرخانکەر کە نەزر دەکات، قوربانییەکەی بۆ یەزدانە سەرباری خۆتەرخانکردنەکەی، بەگوێرەی ئەو نەزرەی کە کردی، ئاوا دەکات بەگوێرەی فێرکردنی خۆتەرخانکردنەکەی.“» ");
INSERT INTO ckb_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","«لەگەڵ هارون و کوڕەکانی بدوێ و بڵێ: ”بەم شێوەیە داوای بەرەکەت دەکەن بۆ نەوەی ئیسرائیل. پێیان دەڵێن: ");
INSERT INTO ckb_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","«” ’با یەزدان بەرەکەتدارت بکات و بتپارێزێت. ");
INSERT INTO ckb_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","با ڕووی یەزدان بەسەرتدا بدرەوشێتەوە و لەگەڵت میهرەبان بێت. ");
INSERT INTO ckb_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","با یەزدان ئاوڕت لێ بداتەوە و ئاشتیت پێ ببەخشێت.‘ “ ");
INSERT INTO ckb_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","«جا ناوم لەسەر نەوەی ئیسرائیل دادەنێن و منیش بەرەکەتداریان دەکەم.» ");
INSERT INTO ckb_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","ئەو ڕۆژەی کە موسا لە دانانی چادرەکەی پەرستن تەواو بوو، دەستنیشانی کرد و تەرخانی کرد لەگەڵ هەموو کەلوپەلەکانی، هەروەها قوربانگاکەش و هەموو قاپوقاچاغەکانی دەستنیشان کرد و تەرخانی کرد. ");
INSERT INTO ckb_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","ئینجا سەرۆکەکانی ئیسرائیل، گەورەی بنەماڵەکانیان کە سەرۆکی هۆزەکان بوون، بەرپرسیار بوون لەسەر تۆمارکراوەکان، پێشکەشکراوەکانیان بەخشی. ");
INSERT INTO ckb_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","دیارییەکانیان هێنایە بەردەم یەزدان، شەش عەرەبانەی داپۆشراو و دوازدە گای خەساو، هەر عەرەبانەیەک بۆ دوو سەرۆک و بۆ هەر یەکێکیان گایەکی خەساو، کە هێنایان بۆ بەردەم چادرەکەی پەرستن. ");
INSERT INTO ckb_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","جا یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","«لێیان وەربگرە بۆ کاری خزمەتی چادری چاوپێکەوتن دەبن و بیدە بە لێڤییەکان، بۆ هەر یەکێک بەگوێرەی خزمەتەکەی.» ");
INSERT INTO ckb_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","موساش عەرەبانەکان و گایە خەساوەکانی وەرگرت و بە لێڤییەکانی دا. ");
INSERT INTO ckb_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","دووان لە عەرەبانەکان و چوار گای خەساوی بە نەوەی گێرشۆن دا بەگوێرەی خزمەتیان، ");
INSERT INTO ckb_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","چوار لە عەرەبانەکان و هەشت گای خەساوی بە نەوەی مەراری دا بەگوێرەی خزمەتیان لەژێر سەرپەرشتی ئیتاماری کوڕی هارونی کاهین. ");
INSERT INTO ckb_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","بەڵام موسا هیچی نەدا بە نەوەی قەهات، چونکە خزمەتی شتە پیرۆزکراوەکان لە ئەستۆی ئەوان بوو، لەسەر شانەکانیان هەڵیاندەگرت. ");
INSERT INTO ckb_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","سەرۆکەکانیش بۆ تەرخانکردنی قوربانگاکە لە ڕۆژانی دەستنیشانکردنی دیارییان دەهێنا و لەبەردەم قوربانگاکە پێشکەشیان دەکرد. ");
INSERT INTO ckb_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","یەزدانیش بە موسای فەرمووبوو: «هەموو ڕۆژێک یەکێک لە سەرۆکەکان پێشکەشکراوەکەی دەهێنێت بۆ تەرخانکردنی قوربانگاکە.» ");
INSERT INTO ckb_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","ئەوەی ڕۆژی یەکەم پێشکەشکراوەکەی هێنا نەحشۆنی کوڕی عەمیناداب بوو لە هۆزی یەهودا. ");
INSERT INTO ckb_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","پێشکەشکراوەکەشی لەگەنێک بوو لە زیو کە کێشەکەی سەد و سی شاقل بوو، تاسێک لە زیو کێشەکەی حەفتا شاقل بوو بە شاقلی پیرۆزگا، هەردووکیان پڕ بوون لە باشترین ئاردی بە زەیت شێلراو وەک پێشکەشکراوی دانەوێڵە؛ ");
INSERT INTO ckb_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","قاپێکی زێڕ کێشەکەی دە شاقل و پڕ لە بخوور؛ ");
INSERT INTO ckb_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","یەک جوانەگا و بەرانێک و بەرخێکی نێری یەک ساڵە بۆ قوربانی سووتاندن؛ ");
INSERT INTO ckb_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","گیسکێکی نێرینە بۆ قوربانی گوناه؛ ");
INSERT INTO ckb_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","بۆ قوربانی هاوبەشیش دوو گا و پێنج بەران و پێنج تەگە و پێنج بەرخی نێری یەک ساڵە. ئەمە پێشکەشکراوی نەحشۆنی کوڕی عەمینادابە. ");
INSERT INTO ckb_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","لە ڕۆژی دووەمدا نەتەنێلی کوڕی چوعەر سەرۆکی یەساخار پێشکەشکراوەکەی هێنا. ");
INSERT INTO ckb_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","پێشکەشکراوەکەی کە هێنابووی لەگەنێک بوو لە زیو کە کێشەکەی سەد و سی شاقل بوو، تاسێک لە زیو کێشەکەی حەفتا شاقل بوو بە شاقلی پیرۆزگا، هەردووکیان پڕ بوون لە باشترین ئاردی بە زەیت شێلراو وەک پێشکەشکراوی دانەوێڵە؛ ");
INSERT INTO ckb_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","قاپێکی زێڕ کێشەکەی دە شاقل و پڕ لە بخوور؛ ");
INSERT INTO ckb_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","یەک جوانەگا و بەرانێک و بەرخێکی نێری یەک ساڵە بۆ قوربانی سووتاندن؛ ");
INSERT INTO ckb_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","گیسکێکی نێرینە بۆ قوربانی گوناه؛ ");
INSERT INTO ckb_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","بۆ قوربانی هاوبەشیش دوو گا و پێنج بەران و پێنج تەگە و پێنج بەرخی نێری یەک ساڵە. ئەمە پێشکەشکراوی نەتەنێلی کوڕی چوعەرە. ");
INSERT INTO ckb_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","لە ڕۆژی سێیەمدا سەرۆکی نەوەی زەبولون، ئەلیابی کوڕی حێلۆن، پێشکەشکراوەکەی هێنا. ");
INSERT INTO ckb_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","پێشکەشکراوەکەشی لەگەنێک بوو لە زیو کە کێشەکەی سەد و سی شاقل بوو، تاسێک لە زیو کێشەکەی حەفتا شاقل بوو بە شاقلی پیرۆزگا، هەردووکیان پڕ بوون لە باشترین ئاردی بە زەیت شێلراو وەک پێشکەشکراوی دانەوێڵە؛ ");
INSERT INTO ckb_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","قاپێکی زێڕ کێشەکەی دە شاقل و پڕ لە بخوور؛ ");
INSERT INTO ckb_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","یەک جوانەگا و بەرانێک و بەرخێکی نێری یەک ساڵە بۆ قوربانی سووتاندن؛ ");
INSERT INTO ckb_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","گیسکێکی نێرینە بۆ قوربانی گوناه؛ ");
INSERT INTO ckb_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","بۆ قوربانی هاوبەشیش دوو گا و پێنج بەران و پێنج تەگە و پێنج بەرخی نێری یەک ساڵە. ئەمە پێشکەشکراوی ئەلیابی کوڕی حێلۆنە. ");
INSERT INTO ckb_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","لە ڕۆژی چوارەمدا سەرۆکی نەوەی ڕەئوبێن، ئەلیسوری کوڕی شەدیئور، پێشکەشکراوەکەی هێنا. ");
INSERT INTO ckb_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","پێشکەشکراوەکەشی لەگەنێک بوو لە زیو کە کێشەکەی سەد و سی شاقل بوو، تاسێک لە زیو کێشەکەی حەفتا شاقل بوو بە شاقلی پیرۆزگا، هەردووکیان پڕ بوون لە باشترین ئاردی بە زەیت شێلراو وەک پێشکەشکراوی دانەوێڵە؛ ");
INSERT INTO ckb_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","قاپێکی زێڕ کێشەکەی دە شاقل و پڕ لە بخوور؛ ");
INSERT INTO ckb_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","یەک جوانەگا و بەرانێک و بەرخێکی نێری یەک ساڵە بۆ قوربانی سووتاندن؛ ");
INSERT INTO ckb_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","گیسکێکی نێرینە بۆ قوربانی گوناه؛ ");
INSERT INTO ckb_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","بۆ قوربانی هاوبەشیش دوو گا و پێنج بەران و پێنج تەگە و پێنج بەرخی نێری یەک ساڵە. ئەمە پێشکەشکراوی ئەلیسوری کوڕی شەدیئورە. ");
INSERT INTO ckb_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","لە ڕۆژی پێنجەمدا سەرۆکی نەوەی شیمۆن، شەلومیێلی کوڕی چووریشەدای، پێشکەشکراوەکەی هێنا. ");
INSERT INTO ckb_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","پێشکەشکراوەکەشی لەگەنێک بوو لە زیو کە کێشەکەی سەد و سی شاقل بوو، تاسێک لە زیو کێشەکەی حەفتا شاقل بوو بە شاقلی پیرۆزگا، هەردووکیان پڕ بوون لە باشترین ئاردی بە زەیت شێلراو وەک پێشکەشکراوی دانەوێڵە؛ ");
INSERT INTO ckb_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","قاپێکی زێڕ کێشەکەی دە شاقل و پڕ لە بخوور؛ ");
INSERT INTO ckb_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","یەک جوانەگا و بەرانێک و بەرخێکی نێری یەک ساڵە بۆ قوربانی سووتاندن؛ ");
INSERT INTO ckb_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","گیسکێکی نێرینە بۆ قوربانی گوناه؛ ");
INSERT INTO ckb_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","بۆ قوربانی هاوبەشیش دوو گا و پێنج بەران و پێنج تەگە و پێنج بەرخی نێری یەک ساڵە. ئەمە پێشکەشکراوی شەلومیێلی کوڕی چووریشەدایە. ");
INSERT INTO ckb_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","لە ڕۆژی شەشەمدا سەرۆکی نەوەی گاد، ئەلیاسافی کوڕی دەعوئێل، پێشکەشکراوەکەی هێنا. ");
INSERT INTO ckb_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","پێشکەشکراوەکەشی لەگەنێک بوو لە زیو کە کێشەکەی سەد و سی شاقل بوو، تاسێک لە زیو کێشەکەی حەفتا شاقل بوو بە شاقلی پیرۆزگا، هەردووکیان پڕ بوون لە باشترین ئاردی بە زەیت شێلراو وەک پێشکەشکراوی دانەوێڵە؛ ");
INSERT INTO ckb_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","قاپێکی زێڕ کێشەکەی دە شاقل و پڕ لە بخوور؛ ");
INSERT INTO ckb_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","یەک جوانەگا و بەرانێک و بەرخێکی نێری یەک ساڵە بۆ قوربانی سووتاندن؛ ");
INSERT INTO ckb_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","گیسکێکی نێرینە بۆ قوربانی گوناه؛ ");
INSERT INTO ckb_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","بۆ قوربانی هاوبەشیش دوو گا و پێنج بەران و پێنج تەگە و پێنج بەرخی نێری یەک ساڵە. ئەمە پێشکەشکراوی ئەلیاسافی کوڕی دەعوئێلە. ");
INSERT INTO ckb_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","لە ڕۆژی حەوتەم سەرۆکی نەوەی ئەفرایم، ئەلیشاماعی کوڕی عەمیهود، پێشکەشکراوەکەی هێنا. ");
INSERT INTO ckb_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","پێشکەشکراوەکەشی لەگەنێک بوو لە زیو کە کێشەکەی سەد و سی شاقل بوو، تاسێک لە زیو کێشەکەی حەفتا شاقل بوو بە شاقلی پیرۆزگا، هەردووکیان پڕ بوون لە باشترین ئاردی بە زەیت شێلراو وەک پێشکەشکراوی دانەوێڵە؛ ");
INSERT INTO ckb_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","قاپێکی زێڕ کێشەکەی دە شاقل و پڕ لە بخوور؛ ");
INSERT INTO ckb_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","یەک جوانەگا و بەرانێک و بەرخێکی نێری یەک ساڵە بۆ قوربانی سووتاندن؛ ");
INSERT INTO ckb_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","گیسکێکی نێرینە بۆ قوربانی گوناه؛ ");
INSERT INTO ckb_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","بۆ قوربانی هاوبەشیش دوو گا و پێنج بەران و پێنج تەگە و پێنج بەرخی نێری یەک ساڵە. ئەمە پێشکەشکراوی ئەلیشاماع کوڕی عەمیهودە. ");
INSERT INTO ckb_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","لە ڕۆژی هەشتەمدا سەرۆکی نەوەی مەنەشە، گەمالائیلی کوڕی پەداهچوور، پێشکەشکراوەکەی هێنا. ");
INSERT INTO ckb_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","پێشکەشکراوەکەشی لەگەنێک بوو لە زیو کە کێشەکەی سەد و سی شاقل بوو، تاسێک لە زیو کێشەکەی حەفتا شاقل بوو بە شاقلی پیرۆزگا، هەردووکیان پڕ بوون لە باشترین ئاردی بە زەیت شێلراو وەک پێشکەشکراوی دانەوێڵە؛ ");
INSERT INTO ckb_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","قاپێکی زێڕ کێشەکەی دە شاقل و پڕ لە بخوور؛ ");
INSERT INTO ckb_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","یەک جوانەگا و بەرانێک و بەرخێکی نێری یەک ساڵە بۆ قوربانی سووتاندن؛ ");
INSERT INTO ckb_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","گیسکێکی نێرینە بۆ قوربانی گوناه؛ ");
INSERT INTO ckb_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","بۆ قوربانی هاوبەشیش دوو گا و پێنج بەران و پێنج تەگە و پێنج بەرخی نێری یەک ساڵە. ئەمە پێشکەشکراوی گەمالائیلی کوڕی پەداهچوورە. ");
INSERT INTO ckb_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","لە ڕۆژی نۆیەم سەرۆکی نەوەی بنیامین، ئەبیدانی کوڕی گدعۆنی، پێشکەشکراوەکەی هێنا. ");
INSERT INTO ckb_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","پێشکەشکراوەکەشی لەگەنێک بوو لە زیو کە کێشەکەی سەد و سی شاقل بوو، تاسێک لە زیو کێشەکەی حەفتا شاقل بوو بە شاقلی پیرۆزگا، هەردووکیان پڕ بوون لە باشترین ئاردی بە زەیت شێلراو وەک پێشکەشکراوی دانەوێڵە؛ ");
INSERT INTO ckb_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","قاپێکی زێڕ کێشەکەی دە شاقل و پڕ لە بخوور؛ ");
INSERT INTO ckb_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","یەک جوانەگا و بەرانێک و بەرخێکی نێری یەک ساڵە بۆ قوربانی سووتاندن؛ ");
INSERT INTO ckb_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","گیسکێکی نێرینە بۆ قوربانی گوناه؛ ");
INSERT INTO ckb_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","بۆ قوربانی هاوبەشیش دوو گا و پێنج بەران و پێنج تەگە و پێنج بەرخی نێری یەک ساڵە. ئەمە پێشکەشکراوی ئەبیدانی کوڕی گدعۆنییە. ");
INSERT INTO ckb_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","لە ڕۆژی دەیەمدا سەرۆکی نەوەی دان، ئەحیعەزەری کوڕی عەمیشەدای، پێشکەشکراوەکەی هێنا. ");
INSERT INTO ckb_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","پێشکەشکراوەکەشی لەگەنێک بوو لە زیو کە کێشەکەی سەد و سی شاقل بوو، تاسێک لە زیو کێشەکەی حەفتا شاقل بوو بە شاقلی پیرۆزگا، هەردووکیان پڕ بوون لە باشترین ئاردی بە زەیت شێلراو وەک پێشکەشکراوی دانەوێڵە؛ ");
INSERT INTO ckb_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","قاپێکی زێڕ کێشەکەی دە شاقل و پڕ لە بخوور؛ ");
INSERT INTO ckb_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","یەک جوانەگا و بەرانێک و بەرخێکی نێری یەک ساڵە بۆ قوربانی سووتاندن؛ ");
INSERT INTO ckb_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","گیسکێکی نێرینە بۆ قوربانی گوناه؛ ");
INSERT INTO ckb_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","بۆ قوربانی هاوبەشیش دوو گا و پێنج بەران و پێنج تەگە و پێنج بەرخی نێری یەک ساڵە. ئەمە پێشکەشکراوی ئەحیعەزەری کوڕی عەمیشەدایە. ");
INSERT INTO ckb_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","لە ڕۆژی یازدەیەم سەرۆکی نەوەی ئاشێر، پەگعیێلی کوڕی عۆخران، پێشکەشکراوەکەی هێنا. ");
INSERT INTO ckb_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","پێشکەشکراوەکەشی لەگەنێک بوو لە زیو کە کێشەکەی سەد و سی شاقل بوو، تاسێک لە زیو کێشەکەی حەفتا شاقل بوو بە شاقلی پیرۆزگا، هەردووکیان پڕ بوون لە باشترین ئاردی بە زەیت شێلراو وەک پێشکەشکراوی دانەوێڵە؛ ");
INSERT INTO ckb_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","قاپێکی زێڕ کێشەکەی دە شاقل و پڕ لە بخوور؛ ");
INSERT INTO ckb_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","یەک جوانەگا و بەرانێک و بەرخێکی نێری یەک ساڵە بۆ قوربانی سووتاندن؛ ");
INSERT INTO ckb_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","گیسکێکی نێرینە بۆ قوربانی گوناه؛ ");
INSERT INTO ckb_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","بۆ قوربانی هاوبەشیش دوو گا و پێنج بەران و پێنج تەگە و پێنج بەرخی نێری یەک ساڵە. ئەمە پێشکەشکراوی پەگعیێلی کوڕی عۆخرانە. ");
INSERT INTO ckb_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","لە ڕۆژی دوازدەیەمدا سەرۆکی نەوەی نەفتالی، ئەحیڕەعی کوڕی عێینان، پێشکەشکراوەکەی هێنا. ");
INSERT INTO ckb_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","پێشکەشکراوەکەشی لەگەنێک بوو لە زیو کە کێشەکەی سەد و سی شاقل بوو، تاسێک لە زیو کێشەکەی حەفتا شاقل بوو بە شاقلی پیرۆزگا، هەردووکیان پڕ بوون لە باشترین ئاردی بە زەیت شێلراو وەک پێشکەشکراوی دانەوێڵە؛ ");
INSERT INTO ckb_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","قاپێکی زێڕ کێشەکەی دە شاقل و پڕ لە بخوور؛ ");
INSERT INTO ckb_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","یەک جوانەگا و بەرانێک و بەرخێکی نێری یەک ساڵە بۆ قوربانی سووتاندن؛ ");
INSERT INTO ckb_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","گیسکێکی نێرینە بۆ قوربانی گوناه؛ ");
INSERT INTO ckb_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","بۆ قوربانی هاوبەشیش دوو گا و پێنج بەران و پێنج تەگە و پێنج بەرخی نێری یەک ساڵە. ئەمە پێشکەشکراوی ئەحیڕەعی کوڕی عێینانە. ");
INSERT INTO ckb_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","ئەمە پێشکەشکراوی سەرۆکەکانی ئیسرائیل بوو، بۆ تەرخانکردنی قوربانگاکە لە کاتی دەستنیشانکردنی: دوازدە لەگەنی زیو و دوازدە تاسی زیو و دوازدە قاپی زێڕ. ");
INSERT INTO ckb_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","هەر لەگەنێک سەد و سی شاقل زیو و هەر تاسێک حەفتا شاقل بوو، هەموو زیوی قاپوقاچاغەکان دوو هەزار و چوار سەد بوون بە شاقلی پیرۆزگا. ");
INSERT INTO ckb_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","قاپە زێڕەکانیش دوازدەی پڕ لە بخوور، هەر قاپێک دە شاقل بوو بە شاقلی پیرۆزگا، هەموو زێڕی قاپەکان سەد و بیست شاقل بوو. ");
INSERT INTO ckb_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","هەموو گایەکانی قوربانی سووتاندن دوازدە جوانەگا بوو، بەرانەکانیش دوازدە و بەرخە نێرە یەک ساڵەکانیش دوازدە لەگەڵ پێشکەشکراوی دانەوێڵەیان، گیسکە نێرەکانیش دوازدە بوون بۆ قوربانی گوناه، ");
INSERT INTO ckb_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","هەموو گایەکانی قوربانی هاوبەشیش بیست و چوار گا بوون، بەرانەکانیش شەست و تەگەکانیش شەست و بەرخە نێرە یەک ساڵەکانیش شەست. ئەمە پێشکەشکراوەکان بوو بۆ تەرخانکردنی قوربانگاکە لەدوای دەستنیشانکردنی. ");
INSERT INTO ckb_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","جا کاتێک موسا چووە ناو چادری چاوپێکەوتنەوە تاکو قسە لەگەڵ یەزدان بکات، گوێی لە دەنگەکە دەبوو کە لەگەڵی دەدوا لە قەپاغی کەفارەتەوە کە لەسەر سندوقی شایەتی بوو، لەنێوان دوو کەڕوبەکەوە، بەم شێوەیە خودا قسەی لەگەڵ کرد. ");
INSERT INTO ckb_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","«لەگەڵ هارون بدوێ و پێی بڵێ: ”کاتێک چراکانت بەرزکردەوە، با ڕووناکی حەوت چراکە بۆ پێش چرادانەکە بێت.“» ");
INSERT INTO ckb_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","هارون چراکانی وا بەرزکردەوە هەتا ڕووناکی بە پێشی چرادانەکە بدات وەک یەزدان فەرمانی بە موسا کرد. ");
INSERT INTO ckb_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","ئەمەش دروستکردنی چرادانەکەیە، لە زێڕی کوتراو، لە قەدەکەیەوە هەتا خونچەکانی کوتران، چرادانەکەی بەگوێرەی ئەو شێوەیە دروستکرد کە یەزدان پیشانی موسای دا. ");
INSERT INTO ckb_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","یەزدان قسەی بۆ موسا کرد و فەرمووی: ");
INSERT INTO ckb_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","«لێڤییەکان لەنێو نەوەی ئیسرائیلدا ببە و بەپێی ڕێوڕەسم پاکیان بکەرەوە. ");
INSERT INTO ckb_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","ئاواش دەکەیت بۆ پاککردنەوەیان: ئاوی پاککردنەوەیان بەسەردا بپرژێنە، با هەموو لەشیان بتاشن و جلەکانیان بشۆن. بەم شێوەیە خۆیان پاک بکەنەوە. ");
INSERT INTO ckb_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","ئینجا جوانەگایەک لەگەڵ پێشکەشکراوی دانەوێڵەکەی کە باشترین ئاردی بە زەیت شێلراوە ببەن و جوانەگایەکی دیکەش بۆ قوربانی گوناه ببە. ");
INSERT INTO ckb_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","جا لێڤییەکان دەبەیتە پێش چادری چاوپێکەوتن و هەموو کۆمەڵی ئیسرائیل کۆدەکەیتەوە، ");
INSERT INTO ckb_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","لێڤییەکان دەبەیتە بەردەم یەزدان و نەوەی ئیسرائیل دەستیان دەخەنە سەر. ");
INSERT INTO ckb_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","جا هارون لێڤییەکان لەبەردەم یەزدان پێشکەش دەکات وەک قوربانی بەرزکردنەوە لەلایەن نەوەی ئیسرائیلەوە بۆ ئەوەی ئامادەبن بۆ پەرستنی یەزدان. ");
INSERT INTO ckb_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","«ئینجا لێڤییەکان دەستیان دەخەنە سەر دوو جوانەگاکە، یەکێکیان وەک قوربانی گوناه پێشکەش دەکرێت و ئەوەی دیکە قوربانی سووتاندن بۆ یەزدان، بۆ کەفارەتکردن بۆ لێڤییەکان. ");
INSERT INTO ckb_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","جا لێڤییەکان لەبەردەم هارون و کوڕەکانی ڕادەگریت و وەک قوربانی بەرزکردنەوە بۆ یەزدان پێشکەشیان دەکەیت. ");
INSERT INTO ckb_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","بەم شێوەیە لێڤییەکان لەنێو نەوەی ئیسرائیل جیا دەکەیتەوە، لێڤییەکان بۆ من دەبن. ");
INSERT INTO ckb_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","«لەدوای ئەوەی لێڤییەکانت پاک کردەوە و وەک قوربانی بەرزکردنەوە پێشکەشت کردن، دێن بۆ ئەوەی خزمەتی چادری چاوپێکەوتن بکەن، ");
INSERT INTO ckb_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","چونکە ئەوان لەنێو نەوەی ئیسرائیلەوە بە تەواوی بە من دراون، لە جیاتی هەموو نۆبەرەیەکی نێری سک لە نەوەی ئیسرائیلدا من بۆ خۆمم داناون. ");
INSERT INTO ckb_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","هەموو نۆبەرەیەکی نێر، خەڵک یان ئاژەڵ لە نەوەی ئیسرائیلدا بۆ منە. ئەو ڕۆژەی لە هەموو نۆبەرەیەکم دا لە خاکی میسر، بۆ خۆمم تەرخان کردن. ");
INSERT INTO ckb_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","ئینجا لێڤییەکانم بۆ خۆم دانا لە جیاتی هەموو نۆبەرەیەک لە نەوەی ئیسرائیل. ");
INSERT INTO ckb_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","لێڤییەکانم بە تەواوی بە هارون و کوڕەکانی بەخشیوە لەنێو نەوەی ئیسرائیل، هەتا لە چادری چاوپێکەوتندا لە جیاتی نەوەی ئیسرائیل خزمەت بکەن، هەروەها بۆ کەفارەتکردن بۆ نەوەی ئیسرائیل تاکو نەوەی ئیسرائیل تووشی هیچ دەردێک نەبێت لە کاتی نزیککەوتنەوەیان لە پیرۆزگا.» ");
INSERT INTO ckb_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","موسا و هارون و هەموو کۆمەڵی نەوەی ئیسرائیل ئاوایان بۆ لێڤییەکان کرد، بەگوێرەی هەموو ئەوەی یەزدان فەرمانی بە موسا کرد سەبارەت بە لێڤییەکان. ");
INSERT INTO ckb_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","جا لێڤییەکان خۆیان پاککردەوە و جلەکانیان شوشت، هارون لەبەردەم یەزدان وەک قوربانی بەرزکردنەوە پێشکەشی کردن، هارون کەفارەتی بۆ کردن بۆ پاکبوونەوەیان. ");
INSERT INTO ckb_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","لەدوای ئەوە لێڤییەکان هاتن هەتا لە چادری چاوپێکەوتندا لەبەردەم هارون و لەبەردەم کوڕەکانی خزمەتەکەیان بکەن، وەک چۆن یەزدان فەرمانی بە موسا کرد سەبارەت بە لێڤییەکان، ئاوایان لەگەڵدا کردن. ");
INSERT INTO ckb_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","«ئەمە بۆ لێڤییەکانە، لە گەنجی بیست و پێنج ساڵ بەرەو سەرەوە دێنە ناو خزمەتەوە بۆ خزمەتی چادری چاوپێکەوتن. ");
INSERT INTO ckb_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","لە تەمەنی پەنجا ساڵەشەوە دەست لە خزمەت هەڵدەگرن و ئیتر خزمەت ناکەن. ");
INSERT INTO ckb_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","یارمەتی براکانیان دەدەن لە چادری چاوپێکەوتن لە پارێزگاری، بەڵام هیچ خزمەتێک ناکەن. ئاوا بۆ لێڤییەکان دەکەیت لە پارێزگارییەکانیان.» ");
INSERT INTO ckb_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","لە ساڵی دووەمی هاتنەدەرەوەیان لە خاکی میسر لە مانگی یەک لە چۆڵەوانی سینا یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","«با نەوەی ئیسرائیل جەژنی پەسخە لە کاتی خۆیدا بکەن، ");
INSERT INTO ckb_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","لە ڕۆژی چواردەی ئەم مانگە لە زەردەپەڕدا، لە کاتی خۆیدا دەیکەن، بەگوێرەی هەموو فەرز و ڕاسپاردەکان.» ");
INSERT INTO ckb_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","موساش لەگەڵ نەوەی ئیسرائیل دوا بۆ ئەوەی جەژنی پەسخە بکەن، ");
INSERT INTO ckb_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","جا لە چواردەی مانگی یەک لە زەردەپەڕدا لە چۆڵەوانی سینا جەژنی پەسخەیان کرد، بەگوێرەی هەموو ئەوەی یەزدان فەرمانی بە موسا کرد، نەوەی ئیسرائیل ئاوایان کرد. ");
INSERT INTO ckb_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","بەڵام هەندێک کەس بەهۆی مردووێکەوە بەپێی ڕێوڕەسم گڵاو ببوون و دروست نەبوو بۆیان لەو ڕۆژەدا جەژنی پەسخە بکەن، جا لەو ڕۆژەدا هاتنە بەردەم موسا و هارون. ");
INSERT INTO ckb_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","ئەو خەڵکە پێیان گوت: «ئێمە بەهۆی کەسێکی مردووەوە گڵاوین، بۆچی لە کاتی خۆیدا لەنێو نەوەی ئیسرائیلدا وەلابنرێین و قوربانی بۆ یەزدان پێشکەش نەکەین؟» ");
INSERT INTO ckb_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","موساش وەڵامی دانەوە: «بوەستن با گوێم لێ بێت یەزدان سەبارەت بە ئێوە چی فەرمان دەکات.» ");
INSERT INTO ckb_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","جا یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","«لەگەڵ نەوەی ئیسرائیل بدوێ و پێیان بڵێ: ”هەرکەسێک لە ئێوە یان لە نەوەکانتان، ئەگەر بە مردووێک گڵاو ببوو یان لە گەشتێکی دوور بوو، با جەژنی پەسخە بۆ یەزدان بکات. ");
INSERT INTO ckb_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","لە ڕۆژی چواردەی مانگی دوو لە زەردەپەڕدا دەیکەن، بەرخەکە بە نانی فەتیرە و بە گیای تاڵەوە دەخۆن. ");
INSERT INTO ckb_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","هیچی بۆ بەیانی ناهێڵنەوە و هیچ ئێسقانێکی لێ ناشکێنرێت. بەگوێرەی هەموو فەرزەکانی جەژنی پەسخە دەیکەن. ");
INSERT INTO ckb_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","بەڵام ئەگەر یەکێک پاک بوو و لە گەشت نەبوو، جەژنی پەسخەی نەکرد، ئەو گیانە لە گەلەکەی دادەبڕدرێت، چونکە لە کاتی خۆیدا قوربانی یەزدانی پێشکەش نەکردووە، ئەو کەسە ئۆباڵی گوناهەکەی خۆی هەڵدەگرێت. ");
INSERT INTO ckb_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","«”ئەگەر نامۆیەک لەنێو ئێوەدا بژیێت و ویستی جەژنی پەسخە بۆ یەزدان بگێڕێت، بەگوێرەی فەرزی پەسخە و یاساکانی ئاوا دەکات، یەک فەرز دەبێت بۆتان، بۆ نامۆ و بۆ هاوڵاتی خاکەکە.“» ");
INSERT INTO ckb_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","لە ڕۆژی دامەزراندنی چادرەکەی پەرستن کە بە چادری پەیمان ناسراوە، هەورێک چادرەکەی پەرستنی داپۆشی. هەر لە ئێوارەوە هەتا بەیانی هەورەکە لەسەر چادرەکەی پەرستن وەک دیمەنی ئاگر بوو. ");
INSERT INTO ckb_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","بە بەردەوامی ئاوا بوو، هەور دایدەپۆشی و بە شەویش هەورەکە دیمەنی ئاگری هەبوو. ");
INSERT INTO ckb_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","هەر کاتێکیش هەورەکە لەسەر چادرەکە بەرز دەبووەوە، ئەوا نەوەی ئیسرائیل لەدوای ئەوە بەڕێ دەکەوتن. لەو شوێنەی هەورەکە بنیشتبایەوە ئەوا نەوەی ئیسرائیل لەوێ چادریان هەڵدەدا. ");
INSERT INTO ckb_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","بە فەرمانی یەزدان نەوەی ئیسرائیل بەڕێ دەکەوتن و بە فەرمانی یەزدان چادریان هەڵدەدا، هەموو ڕۆژانی نیشتنی هەورەکە بەسەر چادرەکەی پەرستندا ئەوان لە چادرەکانی خۆیان دەمانەوە. ");
INSERT INTO ckb_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","هەر کاتێک هەورەکە چەند ڕۆژێکی زۆر لەسەر چادرەکەی پەرستن دەمایەوە، ئەوا نەوەی ئیسرائیل گوێڕایەڵی یەزدان دەبوون و بەڕێ نەدەکەوتن. ");
INSERT INTO ckb_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","هەر کاتێک هەورەکە چەند ڕۆژێکی کەم لەسەر چادری پەرستن دەمایەوە، ئەوا بەگوێرەی فەرمانی یەزدان چادریان هەڵدەدا و بەگوێرەی فەرمانی یەزدان بەڕێ دەکەوتن. ");
INSERT INTO ckb_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","هەندێک جار هەورەکە لە ئێوارەوە هەتا بەیانی دەمایەوە و لە بەیانیدا بەرز دەبووەوە، ئەو کاتە بەڕێ دەکەوتن. یان شەو و ڕۆژێک بمابایەوە و بەرز بووایەوە، ئەوا بەڕێ دەکەوتن. ");
INSERT INTO ckb_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","بەم جۆرە هەورەکە دوو ڕۆژ یان مانگێک یان ساڵێک، هەرچەندێک لەسەر چادرەکەی پەرستن بمابایەوە و بنیشتبایەوە، ئەوا نەوەی ئیسرائیل لە چادرەکانیان دەمانەوە و بەڕێ نەدەکەوتن، هەر کاتێکیش بەرز بووایەوە ئەوا بەڕێ دەکەوتن. ");
INSERT INTO ckb_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","بە فەرمانی یەزدان چادریان هەڵدەدا و بە فەرمانی یەزدان بەڕێ دەکەوتن و ئەرکی یەزدانیان دەپاراست، بەگوێرەی فەرمانی یەزدان لەسەر دەستی موسا. ");
INSERT INTO ckb_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","«دوو کەڕەنا لە زیوی کوتراو بۆ خۆت دروستبکە، بۆ بانگکردنی کۆمەڵ و بۆ بەڕێکەوتنی ئۆردوگاکان. ");
INSERT INTO ckb_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","ئەگەر هەردووکیان لێدران ئەوا هەموو کۆمەڵ بۆ لای دەروازەی چادری چاوپێکەوتن لەلات کۆدەبنەوە، ");
INSERT INTO ckb_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","ئەگەر تەنها یەکێکیان لێدرا ئەوا سەرکردەکان لەلات کۆدەبنەوە، کە سەرۆک خێڵەکانی ئیسرائیلن. ");
INSERT INTO ckb_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","ئەگەر وەک نیشانەی ئاگادارکردنەوە لێتاندا ئەوا ئەو ئۆردوگایانەی لەلای ڕۆژهەڵات چادریان هەڵداوە بەڕێ دەکەون، ");
INSERT INTO ckb_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","ئەگەر دووبارە وەک نیشانەی ئاگادارکردنەوە لێتاندا ئەوا ئەو ئۆردوگایانەی لەلای باشوور چادریان هەڵداوە بەڕێ دەکەون، بۆ بەڕێکەوتنەکانیان وەک نیشانەی ئاگادارکردنەوە لێدەدەن. ");
INSERT INTO ckb_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","کاتێک کۆمەڵ کۆدەکەنەوە ئەوا کەڕەنا لێدەدەن، بەڵام وەک نیشانەی ئاگادارکردنەوە ناکەن. ");
INSERT INTO ckb_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","«کوڕانی هارونی کاهین کەڕەناکان لێدەدەن، جا بۆتان دەبێتە فەرزێکی هەتاهەتایی بۆ نەوەکانتان. ");
INSERT INTO ckb_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","ئەگەر لە خاکی خۆتان بۆ جەنگ چوونە سەر دوژمنێک کە ستەمتان لێدەکات، ئەوا کەڕەناکان وەک نیشانەی ئاگادارکردنەوە لێدەدەن و لەبەردەم یەزدانی پەروەردگارتان یاد دەکرێنەوە و لە دوژمنەکانتان ڕزگارتان دەبێت. ");
INSERT INTO ckb_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","هەروەها لە ڕۆژی خۆشیتان و لە جەژن و لە دەستپێکی مانگی نوێتان کەڕەناکان لێدەدەن، لەسەر قوربانی سووتاندنەکانتان و قوربانییەکانی هاوبەشیتان، جا دەبێتە یادەوەریتان لەبەردەم خوداکەتان. من یەزدانی پەروەردگارتانم.» ");
INSERT INTO ckb_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","لە بیستی مانگی دووی ساڵی دووەمدا هەورەکە لەسەر چادری پەیمان بەرزبووەوە. ");
INSERT INTO ckb_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","جا نەوەی ئیسرائیل لە قۆناغەکەیان لە چۆڵەوانی سیناوە بەڕێکەوتن و هەورەکە لە چۆڵەوانی پاران نیشتەوە. ");
INSERT INTO ckb_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","بەپێی فەرمانی یەزدان و لە ڕێگەی موساوە بۆ یەکەمین جار دەستیان بە کۆچەکەیان کرد. ");
INSERT INTO ckb_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","لەژێر بەیداخەکەیان ئۆردوگای نەوەی یەهودا بەگوێرەی لەشکرەکانیان یەکەم جار بەڕێکەوتن و نەحشۆنی کوڕی عەمیناداب سوپاسالاریان بوو. ");
INSERT INTO ckb_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","سەرلەشکری هۆزی نەوەی یەساخاریش نەتەنێلی کوڕی چوعەر بوو، ");
INSERT INTO ckb_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","سەرلەشکری هۆزی نەوەی زەبولونیش ئەلیابی کوڕی حێلۆن بوو. ");
INSERT INTO ckb_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","ئینجا چادرەکەی پەرستن هەڵگیرایەوە و نەوەی گێرشۆن و نەوەی مەراری چادرەکەی پەرستنیان هەڵگرت و بەڕێکەوتن. ");
INSERT INTO ckb_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","لەدوای ئەوان لەژێر بەیداخەکەیان ئۆردوگای ڕەئوبێن بەگوێرەی لەشکرەکانیان بەڕێکەوتن، ئەلیسوری کوڕی شەدیئور سوپاسالاریان بوو. ");
INSERT INTO ckb_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","سەرلەشکری هۆزی نەوەی شیمۆنیش شەلومیێلی کوڕی چووریشەدای بوو، ");
INSERT INTO ckb_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","سەرلەشکری هۆزی نەوەی گادیش ئەلیاسافی کوڕی دەعوئێل بوو. ");
INSERT INTO ckb_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","ئینجا قەهاتییەکان شتە پیرۆزکراوەکانیان هەڵگرت و بەڕێکەوتن، هەتا گەیشتن چادرەکەی پەرستن هەڵدرابوو. ");
INSERT INTO ckb_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","ئینجا لەژێر بەیداخەکەیان نەوەی ئەفرایم بەگوێرەی لەشکرەکانیان بەڕێکەوتن و ئەلیشاماعی کوڕی عەمیهود سوپاسالاریان بوو، ");
INSERT INTO ckb_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","سەرلەشکری هۆزی نەوەی مەنەشەش گەمالائیلی کوڕی پەداهچوور بوو، ");
INSERT INTO ckb_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","سەرلەشکری هۆزی نەوەی بنیامینیش ئەبیدانی کوڕی گدعۆنی بوو. ");
INSERT INTO ckb_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","لە کۆتاییدا لەژێر بەیداخەکەیان ئۆردوگای نەوەی دان بەڕێکەوت و پاشڕەو و پاسەوانی هەموو ئۆردوگاکان بوو، بەگوێرەی لەشکرەکانیان، ئەحیعەزەری کوڕی عەمیشەدای سوپاسالاریان بوو. ");
INSERT INTO ckb_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","سەرلەشکری هۆزی نەوەی ئاشێریش پەگعیێلی کوڕی عۆخران بوو. ");
INSERT INTO ckb_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","سەرلەشکری هۆزی نەوەی نەفتالیش ئەحیڕەعی کوڕی عێینان بوو. ");
INSERT INTO ckb_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","ئەمە ڕێکخستنی نەوەی ئیسرائیلە بە لەشکرەکانیانەوە کاتێک بەڕێکەوتن. ");
INSERT INTO ckb_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","موسا بە حۆڤاڤی کوڕی ڕەعوئێلی میدیانی گوت، کە ڕەعوئێل خەزووری موسا بوو: «ئێمە دەچین بۆ ئەو شوێنەی یەزدان فەرمووی: ”پێتانی دەدەم.“ لەگەڵمان وەرە و بۆت باش دەبین، چونکە یەزدان بەڵێنی داوە بۆ ئیسرائیل چاک دەبێت.» ");
INSERT INTO ckb_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","ئەویش پێی گوت: «ناڕۆم، بەڵکو بۆ لای خاکی خۆم و گەلی خۆم دەچم.» ");
INSERT INTO ckb_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","جا موسا گوتی: «تکایە بەجێمان مەهێڵە، لەبەر ئەوەی شارەزایت لە چۆڵەوانی لەکوێ چادر هەڵبدەین، ببە بە چاو بۆمان. ");
INSERT INTO ckb_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","ئەگەر لەگەڵمان بێیت، ئەوا بەو چاکەیەی یەزدان لەگەڵ ئێمەی دەکات، ئێمەش چاکەت لەگەڵدا دەکەین.» ");
INSERT INTO ckb_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","جا لە کێوی یەزدانەوە بۆ سێ ڕۆژە ڕێ بەڕێکەوتن و سندوقی پەیمانی یەزدانیش سێ ڕۆژە ڕێ پێشیان کەوتبوو، هەتا بۆ پشوودان نشینگەیەکیان بۆ بدۆزێتەوە. ");
INSERT INTO ckb_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","هەوری یەزدانیش بە ڕۆژ بەسەریانەوە بوو، کاتێک لە ئۆردوگاوە بەڕێکەوتن. ");
INSERT INTO ckb_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","لە کاتی بەڕێکەوتنی سندوقەکەش موسا دەیگوت: «هەستە یەزدان! با دوژمنانت پەرتەوازە بن و ناحەزانت لەبەردەمت هەڵبێن.» ");
INSERT INTO ckb_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","لە کاتی چادرهەڵدانیش دەیگوت: «ئەی یەزدان، بگەڕێوە بۆ لای هەزاران هەزارانی ئیسرائیل.» ");
INSERT INTO ckb_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","گەل دەربارەی ناخۆشییان بۆڵەبۆڵیان کرد، گەیشتە لای یەزدان. یەزدان کە ئەمەی بیست پێی خراپ بوو، تووڕەیی جۆشا، ئیتر ئاگری یەزدان تێیاندا گڕی گرت و قەراغی ئۆردوگاکەی سووتاند. ");
INSERT INTO ckb_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","لەبەر ئەوە گەل هاواریان بۆ موسا کرد، موساش لە یەزدان پاڕایەوە و ئاگرەکە کوژایەوە. ");
INSERT INTO ckb_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","ئەو شوێنەش ناونرا تەبعیرە، چونکە ئاگری یەزدان تێیاندا گڕی گرت. ");
INSERT INTO ckb_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","ئەو ئاژاوەگێڕانەی لەنێویان دەژیان ئارەزووی گۆشتیان دەکرد، جا نەوەی ئیسرائیلیش گەڕانەوە و گریان و گوتیان: «کێ گۆشتمان دەرخوارد دەدات. ");
INSERT INTO ckb_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","ئەو ماسیەی لە میسر بەخۆڕایی دەمانخوارد بەبیرمان هاتەوە، لەگەڵ خەیار و شووتی و کەوەر و پیاز و سیر. ");
INSERT INTO ckb_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","ئێستاش وا گیانمان وشک بوو، هیچ شتێک نییە و هەر چاومان لەسەر ئەو مەنەیە!» ");
INSERT INTO ckb_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","مەنیش وەک تۆوی گژنیژ وابوو، دیمەنی وەک دیمەنی سرێشی دار درەوشاوە بوو. ");
INSERT INTO ckb_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","گەلیش دەسووڕانەوە هەتا هەڵیبگرنەوە، ئینجا بە دەستاڕ دەیانهاڕی یان لە هاون دەیانکوتایەوە و لە مەنجەڵ لێیان دەنا و دەیانکردە کولێرە، تامەکەشی وەک تامی کولێرە برژاوی بە زەیت بوو. ");
INSERT INTO ckb_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","هەر کاتێک بە شەو شەونم بەسەر ئۆردوگاکەدا دەهاتە خوارەوە، ئەوا مەنیش لەگەڵیدا دەهاتە خوارەوە. ");
INSERT INTO ckb_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","کاتێک موسا گوێی لێبوو هەموو گەل دەگریێن، هەریەکە بەخۆی و بنەماڵەکەیەوە لەبەر دەروازەی چادرەکەی ڕاوەستاوە، تووڕەیی یەزدان زۆر زیادی کرد، موسا بەمە دڵگران بوو. ");
INSERT INTO ckb_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","جا موسا بە یەزدانی گوت: «بۆچی لەگەڵ خزمەتکارەکەت خراپ بوویت؟ بۆچی لەلات پەسەند نەبووم، تەنانەت باری هەموو ئەم گەلەت خستە سەر من؟ ");
INSERT INTO ckb_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","ئایا سکم بەم هەموو خەڵکە پڕ بووە یان لە منەوە لەدایک بوونە؟ بۆچی پێم دەڵێی بە باوەش هەڵیانبگرە، هەروەک چۆن دایەن منداڵی ساوا هەڵدەگرێت، بیانبە ئەو خاکەی سوێندت بۆ باوانیان خوارد؟ ");
INSERT INTO ckb_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","گۆشتم لەکوێ بوو تاکو بە هەموو ئەم گەلەی بدەم؟ بەسەرمەوە دەگرین و دەڵێن: ”گۆشتمان بدەرێ بیخۆین!“ ");
INSERT INTO ckb_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","من بە تەنها ناتوانم هەموو ئەم گەلە هەڵبگرم، چونکە بۆ من گرانە. ");
INSERT INTO ckb_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","جا ئەگەر وام پێدەکەیت، بمکوژە ئەگەر لەلات پەسەندم، با تووشی بەڵای خۆم نەبم.» ");
INSERT INTO ckb_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","یەزدانیش بە موسای فەرموو: «لە پیرانی ئیسرائیل حەفتا پیاوم بۆ کۆبکەرەوە، ئەوانەی دەزانیت کە ڕیش سپی و کوێخای گەلن و بیانهێنە لای چادری چاوپێکەوتن و با لەوێ لەگەڵتدا ڕاوەستن. ");
INSERT INTO ckb_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","جا من دێمە خوارەوە و لەوێ لەگەڵتدا دەدوێم و لەو ڕۆحەی بەسەرتەوەیە دەبەم و دەیخەمە سەریان، جا لەگەڵتدا بارگرانی گەلەکە هەڵدەگرن، ئیتر تۆ بە تەنها هەڵیناگریت. ");
INSERT INTO ckb_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","«بە گەلیش دەڵێیت: ”بۆ بەیانی خۆتان تەرخان بکەن ئینجا گۆشت دەخۆن، چونکە یەزدان گوێی لێبوو کە گریان و گوتتان، ’کێ گۆشتمان دەرخوارد دەدات؟ لە میسر حاڵمان خۆشتر بوو!‘ ئێستا یەزدان گۆشتتان دەداتێ و دەیخۆن. ");
INSERT INTO ckb_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","نە ڕۆژێک، نە دوو ڕۆژ، نە پێنج ڕۆژ، نە دە ڕۆژ و نە بیست ڕۆژ، ");
INSERT INTO ckb_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","بەڵکو ماوەی مانگێکی تەواو دەیخۆن، هەتا لە کونی لووتتان دێتە دەرەوە و ڕقتان لێی دەبێتەوە، چونکە یەزدانتان ڕەتکردەوە کە لەنێوتاندایە و لەبەردەمیدا گریان و گوتتان: ’بۆچی ئەمەمان کرد و لە میسر هاتینە دەرەوە؟‘ “» ");
INSERT INTO ckb_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","بەڵام موسا گوتی: «ئەو گەلەی من لەنێویانم شەش سەد هەزار پیادەیە، تۆش فەرمووت: ”گۆشتیان دەدەمێ لێی بخۆن بۆ ماوەی مانگێک!“ ");
INSERT INTO ckb_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","ئایا مەڕ و مانگایان بۆ سەردەبڕدرێت هەتا بەشیان بکات، یان هەموو ماسی دەریایان بۆ کۆدەکرێتەوە هەتا بەشیان بکات؟» ");
INSERT INTO ckb_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","یەزدانیش بە موسای فەرموو: «ئایا یەزدان بێ دەسەڵاتە؟ ئێستا دەبینیت ئاخۆ قسەکانم دێتە دی یان نا.» ");
INSERT INTO ckb_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","موساش چووە دەرەوە و بە فەرموودەی یەزدان لەگەڵ گەلدا دوا. حەفتا پیاوی لە پیرانی گەل کۆکردەوە، لە دەوروبەری چادرەکە ڕایگرتن. ");
INSERT INTO ckb_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","یەزدانیش لە هەوردا هاتە خوارەوە و لەگەڵیدا دوا و لەو ڕۆحە پیرۆزەی کە لەسەری بوو بردی و خستییە سەر حەفتا ڕیش سپییەکە. کاتێک ڕۆحەکە هاتە سەریان ئیتر پەیامی خودایان ڕاگەیاند، بەڵام یەک جار و زیاتر نا. ");
INSERT INTO ckb_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","دوو پیاویش لە ئۆردوگاکە مانەوە، ناوی یەکێکیان ئەلداد و ناوی ئەوەی دیکە میداد بوو، ڕۆحی خودا لەسەریان نیشتەوە، ئەوانیش لە ڕیش سپییەکان بوون، بەڵام نەچووبوونە لای چادرەکە، جا لە ئۆردوگاکە پەیامی خودایان ڕاگەیاند، ");
INSERT INTO ckb_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","لاوێکیش ڕایکرد و هەواڵی دایە موسا و گوتی: «ئەلداد و میداد لە ئۆردوگاکە پەیامی خودا ڕادەگەیەنن!» ");
INSERT INTO ckb_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","یەشوعی کوڕی نونیش کە لە گەنجیێتیەوە خزمەتکاری موسا بوو وەڵامی دایەوە و گوتی: «موسای گەورەم ڕێیان لێ بگرە!» ");
INSERT INTO ckb_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","موساش پێی گوت: «ئایا لە جیاتی من ئیرەیی دەبەیت؟ خۆزگە هەموو گەلی یەزدان پێغەمبەر بوونایە، کە یەزدان ڕۆحی خۆی دەخستە سەریان!» ");
INSERT INTO ckb_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","ئینجا موسا و پیرانی ئیسرائیل گەڕانەوە بۆ ئۆردوگاکە. ");
INSERT INTO ckb_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","بایەکیش لەلایەن یەزدانەوە هەڵیکرد و سوێسکەی لە دەریاوە هێنا بۆ ئۆردوگاکە. بۆ ماوەی ڕۆژە ڕێیەک لەم لا و ڕۆژە ڕێیەک لەو لا لە چواردەوری ئۆردوگاکە و بە بەرزی دوو باڵ لەسەر ڕووی زەوییەوە بڵاوی کردنەوە. ");
INSERT INTO ckb_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","گەلیش هەستان و بە درێژایی ئەو ڕۆژە و بە درێژایی شەو و ڕۆژی دواتریش سوێسکەیان کۆکردەوە، کەمترینیان دە حۆمەری کۆکردەوە و بۆ خۆیان بە چواردەوری ئۆردوگاکە ڕایانخست. ");
INSERT INTO ckb_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","لەو کاتەشدا کە هێشتا گۆشت لەژێر ددانەکانیان بوو پێش ئەوەی بیجوون، تووڕەیی یەزدان بەسەر گەلدا جۆشا و یەزدان گەلی تووشی دەردێکی گران کرد، ");
INSERT INTO ckb_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","جا ئەو شوێنە ناونرا قیبرۆت هەتەڤا، چونکە لەوێ ئەو خەڵکانەیان ناشت کە نەوسیان هەستا. ");
INSERT INTO ckb_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","لە قیبرۆت هەتەڤاشەوە گەل بۆ حەچێرۆت بەڕێکەوتن، جا لەوێ چادریان هەڵدا. ");
INSERT INTO ckb_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","مریەم و هارون لە دژی موسا قسەیان کرد، لەبەر ئەو ژنە کوشییەی کە خواستی، چونکە ژنێکی کوشی خواستبوو. ");
INSERT INTO ckb_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","جا گوتیان: «ئایا یەزدان تەنها لەگەڵ موسادا دواوە، باشە لەگەڵ ئێمەش قسەی نەکرد؟» یەزدانیش گوێی لێبوو. ");
INSERT INTO ckb_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","(موساش لە هەموو خەڵکی سەر ڕووی زەوی بێفیزتر بوو.) ");
INSERT INTO ckb_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","جا یەزدان دەستبەجێ بە موسا و هارون و مریەمی فەرموو: «ئەو سێیەتان وەرنە دەرەوە بۆ لای چادری چاوپێکەوتن.» ئینجا هەرسێکیان هاتنە دەرەوە. ");
INSERT INTO ckb_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","یەزدانیش لە ستوونی هەوردا دابەزی و لە دەروازەی چادرەکە وەستا، بانگی هارون و مریەمی کرد، هەردووکیان بەرەو پێشەوە چوون. ");
INSERT INTO ckb_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","جا فەرمووی: «باش گوێ لە قسەم بگرن: «کاتێک پێغەمبەری یەزدان لەنێوتانە، ئەوا بە بینین خۆمی بۆ ئاشکرا دەکەم، لە خەوندا لەگەڵی دەدوێم. ");
INSERT INTO ckb_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","بەڵام موسای بەندەم ئاوا نییە، بەڵکو بەوەفایە لە هەموو ماڵەکەم، ");
INSERT INTO ckb_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","ڕوو بە ڕوو لەگەڵی دەدوێم، بە ڕوونی نەک بە مەتەڵ، شێوەی یەزدان دەبینێت. ئیتر بۆچی نەترسان کە لە دژی موسای بەندەم دوان؟» ");
INSERT INTO ckb_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","جا تووڕەیی یەزدان لێیان جۆشا و ڕۆیشت. ");
INSERT INTO ckb_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","کاتێک هەورەکە لەسەر چادرەکە بەرزبووەوە مریەم گەڕوگول بوو، وەک بەفر سپی هەڵگەڕا، جا هارون ئاوڕی لە مریەم دایەوە و بینی گەڕوگول بووە. ");
INSERT INTO ckb_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","هارون بە موسای گوت: «گەورەم داوات لێدەکەم ئەو سزایەمان نەخەیتە سەر کە گێلایەتیمان کرد و گوناهمان پێی کرد، ");
INSERT INTO ckb_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","تکایە با وەک ئەو کۆرپە لەبارچووە نەبێت کە پووکاوەتەوە.» ");
INSERT INTO ckb_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","موساش هاواری بۆ یەزدان کرد و گوتی: «خودایە، تکایە چاکی بکەوە.» ");
INSERT INTO ckb_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","یەزدانیش بە موسای فەرموو: «ئەگەر باوکی تفی لە چارەی دەکرد، ئایا حەوت ڕۆژ شەرمەزار نەدەبوو؟ با حەوت ڕۆژ لە دەرەوەی ئۆردوگاکە دەستبەسەر بێت و ئینجا بێتەوە.» ");
INSERT INTO ckb_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","جا مریەم حەوت ڕۆژ لە دەرەوەی ئۆردوگاکە دەستبەسەر بوو و گەلیش بەڕێ نەکەوتن هەتا مریەم نەهاتەوە. ");
INSERT INTO ckb_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","پاش ئەمە گەل لە حەچێرۆتەوە بەڕێکەوتن و لە چۆڵەوانی پاران چادریان هەڵدا. ");
INSERT INTO ckb_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","ئینجا یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","«چەند پیاوێک بنێرە بۆ سیخوڕیکردن لە خاکی کەنعان کە من بە نەوەی ئیسرائیلم داوە، لە هەر هۆزێک لە باوکانیان پیاوێک دەنێرن، هەر یەکێکیان سەرکردە بێت لەناویاندا.» ");
INSERT INTO ckb_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","بەپێی فەرمانی یەزدان موسا لە چۆڵەوانی پارانەوە ئەوانی نارد. هەموویان لە نەوەی ئیسرائیل ڕابەر بوون. ");
INSERT INTO ckb_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","ئەمەش ناوەکانیانە: لە هۆزی ڕەئوبێن شەموعی کوڕی زەکور، ");
INSERT INTO ckb_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","لە هۆزی شیمۆن شافاتی کوڕی حۆری، ");
INSERT INTO ckb_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","لە هۆزی یەهودا کالێبی کوڕی یەفونە، ");
INSERT INTO ckb_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","لە هۆزی یەساخار یەگالی کوڕی یوسف، ");
INSERT INTO ckb_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","لە هۆزی ئەفرایم هۆشێیەعی کوڕی نون، ");
INSERT INTO ckb_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","لە هۆزی بنیامین پەلتیی کوڕی ڕافو، ");
INSERT INTO ckb_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","لە هۆزی زەبولون گەدیێلی کوڕی سۆدی، ");
INSERT INTO ckb_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","لە هۆزی یوسف، لە هۆزی مەنەشە گەدیی کوڕی سوسی، ");
INSERT INTO ckb_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","لە هۆزی دان عەمیێلی کوڕی گەمەلی، ");
INSERT INTO ckb_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","لە هۆزی ئاشێر سەتوری کوڕی میکائیل، ");
INSERT INTO ckb_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","لە هۆزی نەفتالی نەحبیی کوڕی ڤۆفسی، ");
INSERT INTO ckb_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","لە هۆزی گاد گوئێلی کوڕی ماکی. ");
INSERT INTO ckb_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","ئەوە ناوی ئەو پیاوانە بوو کە موسا ناردنی بۆ سیخوڕی خاکەکە. موساش هۆشێیەعی کوڕی نونی ناو نا یەشوع. ");
INSERT INTO ckb_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","جا موسا ناردنی بۆ سیخوڕی خاکی کەنعان و پێی گوتن: «لێرەوە بەناو نەقەبدا بڕۆن و بۆ ناوچە شاخاوییەکە سەربکەون و ");
INSERT INTO ckb_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","بڕوانن خاکەکە چۆنە، ئەو گەلەش تێیدا دەژیێت بە هێزە یان لاوازە؟ کەمن یان زۆرن؟ ");
INSERT INTO ckb_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","ئەو خاکەی تێیدا نیشتەجێن چۆنە، باشە یان خراپە؟ ئەو شارۆچکانە چین کە تێیدا نیشتەجێن، خێوەتگان یان قەڵابەندن؟ ");
INSERT INTO ckb_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","هەروەها ئەو خاکە چۆنە، بەپیتە یان بێپیتە؟ داری لێیە یان نا؟ چاونەترس بن و هەندێک لە بەروبوومی خاکەکە بهێنن.» ئەو ڕۆژانەش ڕۆژانی یەکەم بەری ترێ بوو. ");
INSERT INTO ckb_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","ئەوانیش سەرکەوتن و سیخوڕی خاکەکەیان کرد، لە چۆڵەوانی چنەوە هەتا ڕەحۆڤ لە نزیک دەروازەی حەمات. ");
INSERT INTO ckb_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","بەناو نەقەبدا سەرکەوتن و هاتنە حەبرۆن. لەوێش ئەحیمەن و شێشەی و تەلمەی نەوەی عەناقی لێبوو، حەبرۆنیش پێش چۆعەنی میسر بە حەوت ساڵ بنیاد نرابوو. ");
INSERT INTO ckb_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","ئیتر هاتنە دۆڵی ئەشکۆل و لەوێ لقێکیان بە هێشووە ترێیەکەوە لێکردەوە و بە دارێک هەڵیانگرت لەنێوان دووانیان و لەگەڵ هەندێک هەنار و هەنجیر. ");
INSERT INTO ckb_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","جا ئەو شوێنە ناونرا دۆڵی ئەشکۆل بەهۆی ئەو هێشووەی نەوەی ئیسرائیل لەوێ لێیان کردەوە. ");
INSERT INTO ckb_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","ئینجا لەدوای چل ڕۆژ لە سیخوڕیەتی خاکەکە هاتنەوە. ");
INSERT INTO ckb_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","سیخوڕەکان هاتنە لای موسا و هارون و هەموو کۆمەڵی نەوەی ئیسرائیل لە چۆڵەوانی پاران، لە قادێش، هەواڵیان بۆ ئەوان و بۆ هەموو کۆمەڵ هێنایەوە و بەروبوومی خاکەکەیان پیشاندان. ");
INSERT INTO ckb_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","هەواڵیان پێیدا و گوتیان: «بۆ ئەو خاکە چووین کە تۆ ئێمەت بۆی نارد و بە ڕاستی شیر و هەنگوینی لێ دەڕژێت! ئەمەش بەرەکەیەتی. ");
INSERT INTO ckb_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","بەڵام ئەو گەلەی لە خاکەکەدا نیشتەجێن بە هێزن و شارەکان قەڵابەند و زۆر مەزنن، هەروەها نەوەی عەناقیشمان لەوێ بینی. ");
INSERT INTO ckb_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","عەمالێقییەکان لە خاکی نەقەبدا نیشتەجێن، حیتی و یەبوسی و ئەمۆرییەکان لە ناوچە شاخاوییەکەدا نیشتەجێن، کەنعانییەکانیش لەلای دەریا و لەسەر کەناری ڕووباری ئوردون نیشتەجێن.» ");
INSERT INTO ckb_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","بەڵام کالێب گەلی بۆ موسا بێدەنگ کرد و گوتی: «با سەربکەوین و دەستی بەسەردا بگرین، چونکە توانامان بەسەریدا هەیە.» ");
INSERT INTO ckb_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","بەڵام ئەو پیاوانەی لەگەڵیدا چووبوون، گوتیان: «ناتوانین سەربکەوین و دژایەتی ئەو گەلە بکەین، چونکە لە ئێمە بەهێزترن.» ");
INSERT INTO ckb_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","جا هەواڵێکی خراپیان لەنێو نەوەی ئیسرائیلدا بڵاوکردەوە سەبارەت بەو خاکەی سیخوڕیان تێدا کردبوو و گوتیان: «ئەو خاکەی پێیدا چووین هەتا سیخوڕی بکەین، خاکێکە کە دانیشتووانەکەی قووت دەدات. هەموو ئەو گەلەی تێیدا بینیمان باڵا بەرز بوون. ");
INSERT INTO ckb_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","هەروەها لەوێ نەفیلیممان بینی، نەوەی عەناق کە لە ڕەگەزی نەفیلیمن، لە چاوی خۆماندا وەک پێکوڕە وابووین، بە هەمان شێوەش لەچاو ئەوان.» ");
INSERT INTO ckb_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","کۆمەڵ هەموو دەنگیان بەرزکردەوە و هاواریان کرد و ئەو شەوە گەل گریان. ");
INSERT INTO ckb_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","هەموو نەوەی ئیسرائیل دەستیان بە بۆڵەبۆڵ کرد بەسەر موسا و هارون و هەموو کۆمەڵ، پێیان گوتن: «خۆزگە لە میسر دەمردین! خۆزگە لە چۆڵەوانیدا دەمردین! ");
INSERT INTO ckb_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","بۆچی یەزدان ئێمە دەهێنێتە ئەم خاکە بۆ ئەوەی بە شمشێر بکوژرێین و ژن و منداڵمان بە تاڵان ببردرێن؟ ئایا باشتر نییە بگەڕێینەوە میسر؟» ");
INSERT INTO ckb_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","جا بە یەکتریان گوت، «سەرۆکێک بۆ خۆمان دادەنێین و دەگەڕێینەوە میسر.» ");
INSERT INTO ckb_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","ئینجا موسا و هارون بەسەر ڕوویاندا کەوتن لەبەردەم هەموو کۆمەڵی نەوەی ئیسرائیل کە لەوێ کۆببوونەوە. ");
INSERT INTO ckb_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","یەشوعی کوڕی نون و کالێبی کوڕی یەفونەش لەوانە بوون کە سیخوڕی خاکەکەیان کردبوو، جلەکانی خۆیان دڕاند و ");
INSERT INTO ckb_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","لەگەڵ هەموو کۆمەڵی نەوەی ئیسرائیلدا دوان و گوتیان: «ئەو خاکەی پێیدا چووین هەتا سیخوڕی بکەین خاکێکی زۆر زۆر باشە، ");
INSERT INTO ckb_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","ئەگەر یەزدان پێمان دڵشاد بێت ئەوا دەمانباتە ناو ئەو خاکەی پێمان دەدات، خاکێک کە شیر و هەنگوینی لێ دەڕژێت. ");
INSERT INTO ckb_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","بەڵام لە یەزدان یاخی مەبن و لە گەلی ئەو خاکە مەترسن، چونکە نێچیری ئێمەن، ئەوەتا سێبەریان نەماوە و یەزدان لەگەڵمانە، لێیان مەترسن.» ");
INSERT INTO ckb_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","بەڵام هەموو کۆمەڵ گوتیان، «با ئەو دووانە بەردباران بکرێن.» ئینجا شکۆمەندی یەزدان لە چادری چاوپێکەوتندا بۆ هەموو نەوەی ئیسرائیل دەرکەوت. ");
INSERT INTO ckb_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","یەزدانیش بە موسای فەرموو: «هەتا کەی ئەم گەلە سووکایەتیم پێ دەکەن و هەتا کەی باوەڕم پێ ناکەن، سەرباری ئەو هەموو نیشانانەی لەنێویاندا کردم؟ ");
INSERT INTO ckb_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","من تووشی دەردیان دەکەم و لەناویان دەبەم، بەڵام تۆ دەکەمە گەلێکی گەورەتر و مەزنتر لەوان.» ");
INSERT INTO ckb_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","موساش بە یەزدانی گوت: «ئینجا میسرییەکان کە تۆ بە دەسەڵاتی خۆت ئەم گەلەت لەنێویان دەرهێنا گوێیان لێ دەبێت و ");
INSERT INTO ckb_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","بە دانیشتووانی ئەم خاکەی دەڵێن. ئەی یەزدان، ئەوانەی گوێیان لێبووە تۆ لەنێو ئەم گەلە دایت. ئەی یەزدان، تۆ ڕوو بە ڕوو بۆیان دەرکەوتیت و هەورەکەت لەسەریان وەستاوە و تۆش بە ستوونی هەور بە ڕۆژ و بە ستوونی ئاگر بە شەو پێشیان دەکەویت. ");
INSERT INTO ckb_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","ئەگەر ئەم گەلە لە هەمان کاتدا بکوژیت، ئەوا نەتەوەکان کە گوێیان لە هەواڵت بووە، دەڵێن، ");
INSERT INTO ckb_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","”چونکە یەزدان نەیتوانی بیانباتە ئەو خاکەی کە سوێندی بۆیان خواردبوو، ئیتر لە چۆڵەوانی کوشتنی.“ ");
INSERT INTO ckb_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","«ئێستاش با توانای پەروەردگار مەزن بێت هەروەک فەرمووت: ");
INSERT INTO ckb_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","”یەزدان پشوودرێژە و خۆشەویستی نەگۆڕی زۆرە، لە گوناه و یاخیبوون خۆشدەبێت، بەڵام تاوانبار ئەستۆپاک ناکات، بەڵکو لەسەر تاوانی باوکان سزای نەوەکان دەدات هەتا نەوەی سێیەم و چوارەم.“ ");
INSERT INTO ckb_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","تکایە لە گوناهی ئەم گەلە خۆشبە، ئەوەندەی مەزنی خۆشەویستییە نەگۆڕەکەت، وەک چۆن لەم گەلە خۆشبوویت لە میسرەوە هەتا ئێرە.» ");
INSERT INTO ckb_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","یەزدانیش فەرمووی: «لەسەر داواکەت لێیان خۆشبووم. ");
INSERT INTO ckb_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","بەڵام بە گیانی خۆم و بەو شکۆمەندییەی یەزدانیش کە هەموو جیهان پڕ دەکاتەوە، ");
INSERT INTO ckb_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","تەنها یەکێکیش لەو پیاوانەی شکۆمەندی من و ئەو نیشانانەی بینیبێت کە لە میسر و لە چۆڵەوانی کردم و هەتا ئێستا دە جار تاقییان کردمەوە و گوێیان لە قسەکانم نەگرت، ");
INSERT INTO ckb_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","تەنها یەکێکیش لەوانە ئەو خاکە نابینێت کە سوێندم بۆ باوکانیان خوارد. هەموو ئەوانەی سووکایەتییان پێ کردووم نایبینن. ");
INSERT INTO ckb_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","بەڵام کالێبی بەندەم لەبەر ئەوەی ڕۆحێکی دیکەی لەگەڵدا بوو و بە تەواوی دوام کەوت، ئەوا دەیبەمە ناو ئەو خاکەی بۆی چوو و دەبێتە میرات بۆ نەوەکەی. ");
INSERT INTO ckb_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","لەبەر ئەوەی عەمالێقییەکان و کەنعانییەکان لە دۆڵ نیشتەجێن، ئێوە بەیانی لە ڕێگای دەریای سوورەوە بڕۆن و بەرەو چۆڵەوانی بەڕێ بکەون.» ");
INSERT INTO ckb_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","هەروەها یەزدان بە موسا و هارونی فەرموو: ");
INSERT INTO ckb_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","«هەتا کەی ئەم کۆمەڵە بەدکارە بۆڵەبۆڵەکەرە لە دژم دەوەستن؟ من گوێم لە بۆڵەبۆڵی نەوەی ئیسرائیل بوو کە لەسەر من دەیکەن. ");
INSERT INTO ckb_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","پێیان بڵێ: ”یەزدان دەفەرموێت: بە گیانی خۆم، وەک ئەوەی کە لە ئێوەوە گوێم لێ بوو، ئاواتان لێدەکەم. ");
INSERT INTO ckb_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","لەم چۆڵەوانییە لاشەکانتان دەکەوێت، هەموو تۆمارکراوەکانتان بەگوێرەی سەرژمێریتان لە گەنجی بیست ساڵ بەرەو سەرەوە لەوانەی بۆڵەبۆڵیان لە دژم کرد، ");
INSERT INTO ckb_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","ناچنە ناو ئەو خاکەی کە سوێندم خوارد تێیدا نیشتەجێتان بکەم، تەنها کالێبی کوڕی یەفونە و یەشوعی کوڕی نون نەبێت. ");
INSERT INTO ckb_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","بەڵام منداڵەکانتان کە گوتتان دەبنە نێچیر، ئەوا من دەیانبەمە ناوی و شارەزای ئەو خاکە دەبن کە ئێوە ڕەتتان کردەوە. ");
INSERT INTO ckb_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","جا لاشەکانی ئێوە لەم چۆڵەوانییە دەکەوێت. ");
INSERT INTO ckb_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","منداڵەکانیشتان بۆ ماوەی چل ساڵ لە چۆڵەوانی دەبنە شوان و ئازار دەچێژن بۆ بێوەفاییتان هەتا دواهەمین لاشەکانتان لە چۆڵەوانیدا کۆتایی پێدێت. ");
INSERT INTO ckb_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","وەک ژمارەی ئەو ڕۆژانەی سیخوڕی خاکەکەتان کرد کە چل ڕۆژ بوو، بۆ هەر ڕۆژێک ساڵێک، چل ساڵ گوناهەکانتان هەڵدەگرن و تێدەگەن دژایەتیکردنی من چۆنە.“ ");
INSERT INTO ckb_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","من یەزدانم و فەرمانم کرد، دەبێت ئاوا لە هەموو ئەم کۆمەڵە بەدکارە ڕێککەوتووەی لە دژی خۆم بکەم، لەم چۆڵەوانییە لەناودەچن و دەمرن.» ");
INSERT INTO ckb_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","بەڵام ئەو پیاوانەی موسا ناردنی بۆ سیخوڕی خاکەکە، هاتنەوە و هەموو کۆمەڵیان لێ هاندا بەوەی هەواڵی خراپیان لەسەر خاکەکە بڵاوکردەوە، ");
INSERT INTO ckb_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","ئەو پیاوانە لەبەردەم یەزدان بە دەرد مردن، لەبەر بڵاوکردنەوەی هەواڵێکی خراپ لەسەر خاکەکە. ");
INSERT INTO ckb_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","بەڵام یەشوعی کوڕی نون و کالێبی کوڕی یەفونە لەو پیاوانە بوون کە بۆ سیخوڕی خاکەکە چووبوون و ژیان. ");
INSERT INTO ckb_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","کاتێک موسا باسی ئەم قسانەی بۆ هەموو نەوەی ئیسرائیل کرد، گەل دەستیان بە شیوەن کرد. ");
INSERT INTO ckb_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","ئینجا بەیانی زوو هەستان و چوونە سەرەوە بەرەو بەرزاییەکانی ناوچە شاخاوییەکە و گوتیان: «ئەوەتا ئێمە دەچینە ئەو شوێنەی یەزدان بەڵێنی داوە، چونکە ئێمە گوناهمان کرد.» ");
INSERT INTO ckb_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","موساش گوتی: «بۆچی لە فەرمانی یەزدان دەردەچن، ئەمە سەر ناگرێت! ");
INSERT INTO ckb_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","مەڕۆن، چونکە یەزدان لەنێوتاندا نییە، نەوەک لەبەردەم دوژمنتان ببەزن، ");
INSERT INTO ckb_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","چونکە عەمالێقییەکان و کەنعانییەکان لەوێن، لەپێشتانن و بە شمشێر دەکوژرێن، ئێوە لە یەزدان هەڵگەڕانەوە و یەزدان لەگەڵتاندا نابێت.» ");
INSERT INTO ckb_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","بەڵام ئەوان خۆیان هەڵکێشا و بەرەو بەرزاییەکانی ناوچە شاخاوییەکە سەرکەوتن، نە سندوقی پەیمانی یەزدان و نە موساش لە ناوەڕاستی ئۆردوگاکە دەرنەچوون. ");
INSERT INTO ckb_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","جا عەمالێقییەکان و کەنعانییەکانی دانیشتووی ئەو ناوچە شاخاوییانە هاتنە خوارەوە و هەتا حۆرما لێیاندان و تێکیان شکاندن. ");
INSERT INTO ckb_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","«لەگەڵ نەوەی ئیسرائیل بدوێ و پێیان بڵێ: ”کاتێک هاتنە ناو خاکی نیشتەجێبوونتان کە من پێتانی دەدەم و ");
INSERT INTO ckb_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","قوربانی بە ئاگرتان بۆ یەزدان کرد لە گا یان بەران، جا قوربانی سووتاندن یان قوربانی سەربڕاو بۆ بەجێهێنانی نەزرێکی تایبەت یان بەخشینی ئازاد یان لە جەژنەکانتان بۆ ئەو بۆنەی کە یەزدان پێی خۆشە، ");
INSERT INTO ckb_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","ئەوەی قوربانییەکەی بۆ یەزدان پێشکەش کرد، پێشکەشکراوی دانەوێڵەش لە باشترین ئارد دەیەکی ئێفەیەک شێلراو بە چارەکە هەینێک لە زەیت پێشکەش دەکات. ");
INSERT INTO ckb_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","شەرابیش بۆ شەرابی پێشکەشکراو چارەکە هەینێک ئامادە بکە، لەسەر قوربانی سووتاندنەکە یان قوربانییە سەربڕدراوەکە بۆ یەک بەرخ. ");
INSERT INTO ckb_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","«”بەڵام لەگەڵ بەران، پێشکەشکراوی دانەوێڵە لە باشترین ئارد دوو دەیەکی ئێفەیەک شێلراو بە سێیەکی هەینێک لە زەیت دەکەیت و ");
INSERT INTO ckb_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","شەرابیش بۆ شەرابی پێشکەشکراو سێیەکی هەینێک، وەک ئەو بۆنەی یەزدان پێی خۆشە پێشکەش دەکرێت. ");
INSERT INTO ckb_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","«”ئەگەر جوانەگایەکت کردە قوربانی سووتاندن یان قوربانی سەربڕاو بۆ بەجێهێنانی نەزر یان قوربانی هاوبەشی بۆ یەزدان، ");
INSERT INTO ckb_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","ئەوا لەگەڵ جوانەگاکە پێشکەشکراوی دانەوێڵە سێ دەیەکی ئێفەیەک لە باشترین ئاردی شێلراو بە نیو هەین زەیت پێشکەش دەکەیت و ");
INSERT INTO ckb_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","نیو هەین شەرابیش بۆ شەرابی پێشکەشکراو پێشکەش دەکەیت، قوربانی بە ئاگرە، ئەو بۆنەی یەزدان پێی خۆشە. ");
INSERT INTO ckb_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","ئاوا بۆ گایەک یان بەرانێک یان بەرخ یان کارەبزن دەکرێت، ");
INSERT INTO ckb_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","ئاوا دەکەن بەگوێرەی ژمارەیان، بۆ هەر یەکێک بەگوێرەی ژمارەیان. ");
INSERT INTO ckb_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","«”هەر هاوڵاتییەک بۆ پێشکەشکردنی قوربانی بە ئاگر ئەو بۆنەی یەزدان پێی خۆشە ئاوا دەکات. ");
INSERT INTO ckb_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","ئەگەر نامۆیەک لەنێوتان نیشتەجێ بوو، یان هەرکەسێکی دیکە لەنێوتان نیشتەجێیە، نەوە دوای نەوە ویستی قوربانی بە ئاگر بکات، ئەو بۆنەی یەزدان پێی خۆشە، دەبێت وەک ئێوە بیکات. ");
INSERT INTO ckb_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","کۆمەڵ بۆ ئێوە و بۆ ئەو نامۆیەی لەنێوتاندا بژیێت، یەک فەرزی هەتاهەتاییە نەوە دوای نەوە. نامۆکەش وەک ئێوە دەبێت لەبەردەم یەزدان، ");
INSERT INTO ckb_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","یەک فێرکردن و یەک یاسا دەبێت بۆ ئێوە و بۆ ئەو نامۆیەی لەنێوتاندا دەژیێت.“» ");
INSERT INTO ckb_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","هەروەها یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","«لەگەڵ نەوەی ئیسرائیل بدوێ و پێیان بڵێ: ”کاتێک چوونە ناو ئەو خاکەی کە من ئێوەی بۆ دەبەم، ");
INSERT INTO ckb_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","جا کاتێک لە نانی خاکەکە دەخۆن ئەوا پێشکەشکراو بۆ یەزدان دەبەخشن. ");
INSERT INTO ckb_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","لە یەکەم ئاردی هاڕاوتان کولێرەیەک دەکەنە پیتاک وەک پێشکەشکراوی جۆخین دەیبەخشن. ");
INSERT INTO ckb_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","نەوە لەدوای نەوە لە یەکەم ئاردی هاڕاوتان بەخشین بۆ یەزدان پێشکەش دەکەن. ");
INSERT INTO ckb_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","«”ئەگەر بەبێ ئەنقەست هەموو ئەم فەرمانانەتان بەجێنەهێنا کە یەزدان بە موسای سپارد، ");
INSERT INTO ckb_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","هەموو ئەوەی یەزدان لەسەر دەستی موسا فەرمانی پێ کردوون، لەو ڕۆژەوەی یەزدان فەرمانی پێ کردووە و بەردەوام نەوە دوای نەوە، ");
INSERT INTO ckb_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","ئەگەر بەبێ ئەنقەست و بێ بوونی زانیاری کۆمەڵ ئەمە ئەنجام درا، ئەوا بەپێی فەرزەکان هەموو کۆمەڵ جوانەگایەک لەگەڵ پێشکەشکراوی دانەوێڵە و شەرابی پێشکەشکراو دەکەنە قوربانی سووتاندن، وەک ئەو بۆنەی یەزدان پێی خۆشە، لەگەڵ گیسکێکی نێرینە وەک قوربانی گوناه. ");
INSERT INTO ckb_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","جا کاهین کەفارەت بۆ هەموو کۆمەڵی ئیسرائیل دەکات و لێخۆشبوونیان بۆ دەبێت، چونکە بەبێ ئەنقەست بووە. جا ئەگەر قوربانییەکەیان وەک قوربانی بە ئاگر بۆ یەزدان هێنا و قوربانییەکەی گوناهیان بۆ بەردەم یەزدان هێنا لەبەر بێئاگاییەکەیان، ");
INSERT INTO ckb_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","ئەوا هەموو کۆمەڵی نەوەی ئیسرائیل و ئەو نامۆیەش کە لەنێویان دەژیێت لێخۆشبوونی بۆ دەبێت، چونکە هەموو گەل بەبێ ئەنقەست تێوەگلاون. ");
INSERT INTO ckb_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","«”ئەگەر یەک کەس بەبێ ئەنقەست گوناهی کرد، ئەوا بزنێکی یەک ساڵە پێشکەش دەکات وەک قوربانی گوناه. ");
INSERT INTO ckb_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","کاهین لەبەردەم یەزدان کەفارەت بۆ ئەو کەسە دەکات کە بێئاگا بوو کاتێک گوناهی بەبێ ئەنقەست کرد، کەفارەتی بۆ دەکات و لێخۆشبوونی بۆ دەبێت. ");
INSERT INTO ckb_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","بۆ هاوڵاتی لە نەوەی ئیسرائیل و بۆ ئەو نامۆیەش کە لەنێویان دەژیێت، یەک یاسا دەبێت بۆ ئەوەی بەبێ ئەنقەست گوناهی کردبێت. ");
INSERT INTO ckb_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","«”بەڵام ئەو کەسەی هاوڵاتی بێت یان نامۆ بە دەستی ئەنقەست گوناه بکات، ئەو کەسە کفری بەرامبەر بە یەزدان کردووە، ئەو کەسە لەنێو گەلەکەی دادەبڕدرێت، ");
INSERT INTO ckb_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","چونکە سووکایەتی بە فەرمایشتی یەزدان کردووە و فەرمانی ئەوی شکاندووە، بێگومان ئەو کەسە دادەبڕدرێت و ئۆباڵی خۆی لە ملی خۆی.“» ");
INSERT INTO ckb_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","کاتێک نەوەی ئیسرائیل لە چۆڵەوانی بوون پیاوێکیان بینی لە ڕۆژی شەممەدا داری کۆدەکردەوە، ");
INSERT INTO ckb_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","جا ئەوانەی بینییان دار کۆدەکاتەوە بردیانە بەردەم موسا و هارون و هەموو کۆمەڵ. ");
INSERT INTO ckb_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","ئینجا لە بەندیخانەیان دانا، چونکە ئاشکرا نەبوو بوو چی لێ دەکرێت. ");
INSERT INTO ckb_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","جا یەزدان بە موسای فەرموو: «ئەو پیاوە دەبێت بکوژرێت، لە دەرەوەی ئۆردوگا هەموو کۆمەڵ بەردبارانی دەکەن.» ");
INSERT INTO ckb_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","جا هەموو کۆمەڵ بردیانە دەرەوەی ئۆردوگا و بەردبارانیان کرد و مرد، وەک یەزدان فەرمانی بە موسا کرد. ");
INSERT INTO ckb_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","هەروەها یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","«لەگەڵ نەوەی ئیسرائیل بدوێ و پێیان بڵێ: ”با گوڵنگ لە لچکی جلەکانتان دروستبکەن، نەوە دوای نەوە و لەسەر لچکەکانی خوارەوە گوڵنگی مۆر دابنێن. ");
INSERT INTO ckb_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","کاتێک ئەم گوڵنگانە دەبینن هەموو فەرمانەکانی یەزدانتان بەبیر دێتەوە و جێبەجێی دەکەن و بەدوای ئارەزووی دڵ و چاوتان ناکەون هەتا بەدوایاندا بەدڕەوشتی بکەن، ");
INSERT INTO ckb_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","هەتا بەبیرتان بێتەوە و هەموو فەرمانەکانی یەزدان جێبەجێ بکەن و بۆ خوداتان پیرۆز بن. ");
INSERT INTO ckb_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","من یەزدانی پەروەردگارتانم کە لە خاکی میسر دەریهێنان هەتا ببێت بە خوداتان، من یەزدانی پەروەردگارتانم.“» ");
INSERT INTO ckb_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","قۆرەحی کوڕی یەسهار کوڕی قەهات کوڕی لێڤی و داتان و ئەبیرامی کوڕانی ئەلیاب و ئۆنی کوڕی پەلەت لە نەوەی ڕەئوبێن ");
INSERT INTO ckb_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","لە دژی موسا هەستانەوە. چەند کەسێکیش لە نەوەی ئیسرائیل لەگەڵیان بوون، دوو سەد و پەنجا کەس لە ڕابەرەکانی کۆمەڵ لە ئەنجومەن هەڵبژێردرابوون، کە زۆر ناسراو بوون، ");
INSERT INTO ckb_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","جا لەسەر موسا و هارون کۆبوونەوە و پێیان گوتن: «ئێوە زیادەڕۆییتان کردووە! هەموو کۆمەڵ پیرۆزن و یەزدانیش لەنێوانیاندایە، ئیتر بۆچی خۆتان لەسەر کۆمەڵی یەزدان بەرز دەکەنەوە؟» ");
INSERT INTO ckb_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","جا موسا گوێی لێبوو و بەسەر ڕوودا کەوت. ");
INSERT INTO ckb_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","ئینجا بە قۆرەح و هەموو کۆمەڵەکەی گوت: «بەیانی یەزدان پیشانی دەدات کێ بۆ ئەوە و کێ پیرۆزە تاکو لە خۆی نزیکی بکاتەوە، جا هەرکەسێک هەڵبژێرێت ئەو لە خۆی نزیک دەکاتەوە. ");
INSERT INTO ckb_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","ئەمە بکەن، بخووردان بۆ خۆتان ببەن، قۆرەح و هەموو کۆمەڵەکەی، ");
INSERT INTO ckb_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","بەیانی ئاگری لەناو دابنێن و لەبەردەم یەزدان بخووری بەسەردا بکەن، جا ئەو پیاوەی یەزدان هەڵیدەبژێرێت ئەو پیرۆزە، ئیتر ئەی نەوەی لێڤی ئەمەتان بەس بێت!» ");
INSERT INTO ckb_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","هەروەها موسا بە قۆرەحی گوت: «ئەی نەوەی لێڤی گوێ بگرن، ");
INSERT INTO ckb_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","ئایا بە کەمی دەزانن کە خودای ئیسرائیل لەنێو کۆمەڵی ئیسرائیل جیای کردنەوە بۆ ئەوەی لە خۆی نزیکتان بکاتەوە، تاکو خزمەتی چادری پەرستنی یەزدان بکەن و لەبەردەم کۆمەڵ بوەستن بۆ خزمەتکردنی؟ ");
INSERT INTO ckb_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","جا تۆ و هەموو براکانت لە نەوەی لێڤی لە خۆی نزیک کردەوە و داوای کاهینیێتیش دەکەن؟ ");
INSERT INTO ckb_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","کەواتە تۆ و هەموو کۆمەڵەکەت لەسەر دژایەتیکردنی یەزدان ڕێک کەوتوون، بەڵام هارون کێیە هەتا بۆڵەبۆڵی لەسەر بکەن؟» ");
INSERT INTO ckb_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","جا موسا ناردی هەتا بانگی داتان و ئەبیرامی کوڕانی ئەلیاب بکەن، بەڵام ئەوان گوتیان: «نایەین! ");
INSERT INTO ckb_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","ئایا ئەمە بەس نییە کە تۆ لە خاکێک دەرتهێناین کە شیر و هەنگوینی لێ دەڕژێت هەتا لە چۆڵەوانی بمانمرێنیت و ئێستاش خۆت بکەیت بە میر بەسەرمانەوە، ");
INSERT INTO ckb_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","هەروەها ئێمەت نەهێناوەتە خاکێک شیر و هەنگوینی لێ بڕژێت و کێڵگە و ڕەزت بە میرات پێنەداین. ئایا چاوی ئەو کەسانە دەردەهێنیت؟ ئێمە نایەین!» ");
INSERT INTO ckb_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","جا موسا زۆر تووڕە بوو و بە یەزدانی گوت: «ئاوڕ لە قوربانییەکەیان مەدەوە. نە گوێدرێژێکم لێ بردوون و نە خراپەم لەگەڵ کەسیان کردووە.» ");
INSERT INTO ckb_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","ئینجا موسا بە قۆرەحی گوت: «بەیانی تۆ و هەموو کۆمەڵەکەت لەبەردەم یەزدان بن، تۆ و ئەوان و هارونیش. ");
INSERT INTO ckb_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","هەریەکە بخووردانەکەی ببات و بخووری تێبکات و لەبەردەم یەزدان بخووردانەکەی پێشکەش بکات، دوو سەد و پەنجا بخووردان، تۆ و هارونیش هەریەکە و بخووردانی خۆتان.» ");
INSERT INTO ckb_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","جا هەریەکە بخووردانەکەی خۆی برد و ئاگریان تێکرد و بخووریان بەسەردا کرد و لەگەڵ موسا و هارون لەلای دەروازەی چادری چاوپێکەوتن ڕاوەستان. ");
INSERT INTO ckb_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","قۆرەحیش هەموو کۆمەڵی لە دژی ئەوان لەلای دەروازەی چادری چاوپێکەوتن کۆکردەوە، جا شکۆمەندی یەزدان بۆ هەموو کۆمەڵ دەرکەوت. ");
INSERT INTO ckb_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","ئینجا یەزدان بە موسا و هارونی فەرموو: ");
INSERT INTO ckb_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","«خۆتان لەم کۆمەڵە جیا بکەنەوە، وا من دەستبەجێ لەناویان دەبەم.» ");
INSERT INTO ckb_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","بەڵام موسا و هارون بەسەر ڕوویاندا کەوتن و گوتیان: «خودایە، ئەی ئەو خودایەی ژیان بە ئادەمیزاد دەبەخشیت، ئایا یەک پیاو گوناه بکات، تۆ لە هەموو کۆمەڵ تووڕە دەبیت؟» ");
INSERT INTO ckb_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","جا یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","«لەگەڵ کۆمەڵ بدوێ و بڵێ: ”لە دەوروبەری چادرەکانی قۆرەح و داتان و ئەبیرام دوور بکەونەوە.“» ");
INSERT INTO ckb_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","موسا هەستا و چوو بۆ لای داتان و ئەبیرام، پیرەکانی ئیسرائیلیش دوای کەوتن، ");
INSERT INTO ckb_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","ئینجا موسا بە کۆمەڵەکەی گوت: «لە چادرەکانی ئەو کەسە بەدکارانە دوور بکەونەوە و دەست لە هیچ شتێکی ئەوان مەدەن، نەوەک بە هەموو گوناهەکانی ئەوانەوە لەناوبچن.» ");
INSERT INTO ckb_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","ئیتر ئەوانیش لە دەوروبەری چادرەکانی قۆرەح و داتان و ئەبیرام دوورکەوتنەوە و داتان و ئەبیرامیش هاتنە دەرەوە و لەگەڵ ژن و کوڕ و منداڵەکانیان لە دەرگای چادرەکانیان وەستان. ");
INSERT INTO ckb_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","ئینجا موسا گوتی: «بەمە دەزانن کە یەزدان ناردوومی بۆ ئەوەی ئەم هەموو کارانە بکەم و ئەمەش لە خۆمەوە نییە. ");
INSERT INTO ckb_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","ئەگەر ئەم پیاوانە وەک مردنێکی سروشتی بمرن و وەک هەموو مرۆڤێک بە مەرگی ئاسایی مردن، ئەوا یەزدان منی نەناردووە. ");
INSERT INTO ckb_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","بەڵام ئەگەر یەزدان شتێکی نوێی داهێنا و زەوی دەمی کردەوە و قووتی دان لەگەڵ هەموو ئەوەی هەیانە و بە زیندوویی چوونە خوارەوە بۆ ناو جیهانی مردووان، ئەوا دەزانن کە ئەو کۆمەڵە سووکایەتییان بە یەزدان کردووە.» ");
INSERT INTO ckb_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","کاتێک لە هەموو ئەم قسانە بووەوە، زەوییەکەی ژێریان شەق بوو و ");
INSERT INTO ckb_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","زەوی دەمی کردەوە و قووتی دان لەگەڵ ماڵەکانیان و هەموو پیاوەکانی قۆرەح و لەگەڵ هەموو سامانەکانیان. ");
INSERT INTO ckb_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","جا خۆیان و هەموو ئەوەی هەیان بوو بە زیندوویی چوونە خوارەوە بۆ ناو جیهانی مردووان و زەوی بەسەریاندا هاتەوە یەک و لەنێو کۆمەڵدا لەناوچوون. ");
INSERT INTO ckb_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","هەموو ئیسرائیلیش کە لە چواردەوریان بوون لە هاواریان هەڵاتن و گوتیان: «نەوەک زەوی قووتمان بدات!» ");
INSERT INTO ckb_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","ئاگرێکیش لەلایەن یەزدانەوە هات و دوو سەد و پەنجا پیاوەکەی هەڵلووشی کە بخووریان پێشکەش کرد. ");
INSERT INTO ckb_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","ئینجا یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","«بە ئەلعازاری کوڕی هارونی کاهین بڵێ، با بخووردانەکان لەناو ئاگرەکە هەڵبگرێت و پاشماوەی ئاگرەکە لە دوور و بە فراوانی بڵاو بکاتەوە، ");
INSERT INTO ckb_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","چونکە بخووردانەکانی ئەوانەی لە دژی نرخی ژیانی خۆیان گوناهبارن پیرۆزکراون. با بخووردانەکان بکوتن و بیکەنە چەند پلێتێک و قوربانگاکەی پێ دابپۆشرێت، چونکە لەبەردەم یەزدان پێشکەشیان کرد و پیرۆز بوو. با نەوەی ئیسرائیل پەند لەمە وەربگرن.» ");
INSERT INTO ckb_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","ئینجا ئەلعازاری کاهین بخووردانە بڕۆنزییەکانی برد کە ئەوانەی سووتێنرابوون پێشکەشیان کردبوو و کوتایان و کردیانە پۆشەر بۆ قوربانگاکە، ");
INSERT INTO ckb_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","وەک یەزدان پێی فەرموو لەسەر دەستی موسا. ئەمە وەک بەبیرهێنانەوەیەک بوو بۆ نەوەی ئیسرائیل، ئەگەر پیاوێکی بێگانە کە لە نەوەی هارون نەبێت لەبەردەم یەزدان بۆ بخوور سووتاندن نزیک بکەوێتەوە، ئەوا وەک قۆرەح و کۆمەڵەکەی لێدێت. ");
INSERT INTO ckb_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","جا هەموو کۆمەڵی نەوەی ئیسرائیل بۆ بەیانی دەستیان بە بۆڵەبۆڵ کرد لەسەر موسا و هارون و گوتیان: «ئێوە گەلی یەزدانتان کوشت.» ");
INSERT INTO ckb_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","کاتێک کۆمەڵ لە دژی موسا و هارون کۆبوونەوە ئەوان چوونە لای چادری چاوپێکەوتن، لەپڕ هەورێک دایپۆشی و شکۆمەندی یەزدان دەرکەوت. ");
INSERT INTO ckb_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","جا موسا و هارون هاتنە بەردەم چادری چاوپێکەوتن. ");
INSERT INTO ckb_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","یەزدانیش بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","«لەنێو ئەم کۆمەڵە بچنە دەرەوە، من بە ساتێک لەناویان دەبەم.» جا بەسەر ڕوویاندا کەوتن. ");
INSERT INTO ckb_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","ئینجا موسا بە هارونی گوت: «بخووردانەکە ببە و لەسەر قوربانگاکەوە ئاگری تێبکە، بخووری لەسەر دابنێ، بە خێرایی بیبە لای کۆمەڵ و کەفارەتیان بۆ بکە. لەبەر ئەوەی تووڕەیی یەزدان جۆشاوە، وا دەردەکە دەستی پێکرد.» ");
INSERT INTO ckb_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","ئیتر هارون لەسەر قسەی موسا ڕایکرد بۆ ناو کۆمەڵ، بەڵام دەردەکە لەنێو گەلدا دەستی پێکردبوو، ئەویش بخوورەکەی پێشکەش کرد و کەفارەتی بۆ گەل کرد. ");
INSERT INTO ckb_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","هارون لەناوەندی مردووان و زیندوواندا ڕاوەستا، دەردەکەش وەستا، ");
INSERT INTO ckb_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","جا ئەوانەی بە دەردەکە مردن چواردە هەزار و حەوت سەد بوون، بێجگە لەوانەی بەهۆی قۆرەحەوە مردن. ");
INSERT INTO ckb_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","ئینجا هارون گەڕایەوە لای موسا بۆ لای دەروازەی چادری چاوپێکەوتن، لەبەر ئەوەی دەردەکە وەستابوو. ");
INSERT INTO ckb_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","«لەگەڵ نەوەی ئیسرائیل بدوێ و گۆچانیان لێ وەربگرە، بۆ هەر هۆزێک گۆچانێک، لە هەموو سەرۆکەکانیان بەگوێرەی هۆزەکانیان دوازدە گۆچان و ناوی هەریەکەیان لەسەر گۆچانەکەی دەنووسیت و ");
INSERT INTO ckb_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","ناوی هارونیش لەسەر گۆچانی لێڤی دەنووسیت، چونکە بۆ هەر سەرۆک هۆزێک یەک گۆچانە. ");
INSERT INTO ckb_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","لە چادری چاوپێکەوتن لەبەردەم سندوقی پەیمان دایبنێ، لەو شوێنەی لەگەڵتان کۆ دەبمەوە. ");
INSERT INTO ckb_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","جا ئەو پیاوەی هەڵیدەبژێرم گۆچانەکەی چەکەرە دەکات، ئەوسا ئەو بۆڵەبۆڵەی نەوەی ئیسرائیل لەسەر خۆم کپ دەکەم کە لە دژی ئێوە دەیکەن.» ");
INSERT INTO ckb_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","ئینجا موسا قسەی لەگەڵ نەوەی ئیسرائیل کرد، هەموو سەرکردەکان هەریەکە گۆچانێکیان دایێ، دوازدە گۆچان بەگوێرەی ژمارەی سەرۆک هۆزەکان، گۆچانەکەی هارونیش لەنێو گۆچانەکانی ئەوان بوو. ");
INSERT INTO ckb_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","جا موسا گۆچانەکانی لەناو چادری پەیمان لەبەردەم یەزدان دانا. ");
INSERT INTO ckb_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","بۆ بەیانیش موسا چووە ناو چادری شایەتی و بینی گۆچانەکەی هارون کە سەر بە بنەماڵەی لێڤییە چەکەرەی کردووە، خونچەی کردووە و گوڵی کردووە و بادەمی گرتووە و پێگەیشتووە. ");
INSERT INTO ckb_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","جا موسا هەموو گۆچانەکانی لەبەردەم یەزدان بردە دەرەوە بۆ هەموو نەوەی ئیسرائیل، تەماشایان کرد و هەریەکە گۆچانی خۆی بردەوە. ");
INSERT INTO ckb_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","یەزدانیش بە موسای فەرموو: «گۆچانەکەی هارون بگەڕێنەوە بەردەم سندوقی پەیمان، بۆ ئەوەی بپارێزرێت و یاخیبووان پەندی لێ وەربگرن. بەو شێوەیە چیتر بۆڵەبۆڵم بەسەردا ناکەن، تاکو نەمرن.» ");
INSERT INTO ckb_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","موساش ئاوای کرد، هەروەک یەزدان فەرمانی پێ کرد. ");
INSERT INTO ckb_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","ئینجا نەوەی ئیسرائیل بە موسایان گوت: «ئێمە لەناوچووین و ون بووین، هەموومان ون بووین! ");
INSERT INTO ckb_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","هەموو ئەوانەی لە چادری پەرستنی یەزدان نزیک دەبنەوە دەمرن، ئایا هەموومان لەناودەچین؟» ");
INSERT INTO ckb_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","یەزدان بە هارونی فەرموو: «تۆ و کوڕەکانت و بنەماڵەکەت ئۆباڵی ئەو گوناهانە هەڵدەگرن کە لە پیرۆزگا دەکرێت، تۆ و کوڕەکانت ئۆباڵی ئەو گوناهانە هەڵدەگرن کە لە کاهینیێتییەکەتان دەکرێت. ");
INSERT INTO ckb_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","هەروەها براکانت، هۆزی لێڤی، هۆزی باوکت، لە خۆت نزیک بکەوە، ئینجا بە تۆوە پابەند دەبن و پاڵپشتی تۆ و کوڕەکانت دەکەن لەبەردەم چادری پەیمان. ");
INSERT INTO ckb_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","ئەوان بەردەستی خۆت و هەموو کاروباری چادرەکە دەکەن، بەڵام لە قاپوقاچاغی پیرۆزگاکە و لە قوربانگاکە نزیک ناکەونەوە، نەوەک ئەوان و ئێوەش، هەمووتان بمرن. ");
INSERT INTO ckb_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","پابەندت دەبن و بەرپرسیاریش دەبن لە پارێزگاری چادری چاوپێکەوتن لەگەڵ هەموو خزمەتی چادرەکە، هیچ کەسێکی دیکەش لێتان نزیک ناکەوێتەوە. ");
INSERT INTO ckb_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","«بەڵکو ئێوە بەرپرسیار دەبن لە پارێزگاری پیرۆزگاکە و قوربانگاکە، تاکو جارێکی دیکە تووڕەیی نەیەتە سەر نەوەی ئیسرائیل. ");
INSERT INTO ckb_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","من خۆم لێڤییەکانی براتانم لەنێو نەوەی ئیسرائیل هەڵبژارد و دامەوە ئێوە، بۆ یەزدان تەرخانکراون تاکو خزمەتەکەی چادری چاوپێکەوتن بەجێبگەیەنن. ");
INSERT INTO ckb_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","تەنها تۆ و کوڕەکانت لەگەڵت خزمەتی کاهینیێتی دەکەن، لەگەڵ هەموو ئەوەی پەیوەندی بە قوربانگاکە هەیە و ئەوەی لەناو پەردەکەیە دەپارێزن. کاهینیێتی پێدراوێکی تایبەت بە ئێوەیە و پێمداون و هەرکەسێکی دیکە ئەوەی لە پیرۆزگا نزیک بکەوێتەوە دەکوژرێت.» ");
INSERT INTO ckb_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","یەزدان بە هارونی فەرموو: «ئێستا من بەرپرسیاریێتی پێشکەشکراوەکان کە بۆ منی بەرز دەکەنەوە داومەتە تۆ، هەموو پێشکەشکراوە پیرۆزەکانی نەوەی ئیسرائیل، دەیدەمە خۆت و کوڕەکانت وەک بەشە کاهینیێتیتان و بەشێکی چەسپاوە. ");
INSERT INTO ckb_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","ئەم بەشە بۆ تۆ دەبێت لە پێشکەشکراوە هەرەپیرۆزەکان ئەوەی لە ئاگر دەپارێزرێت. لە هەموو قوربانییەکانیان و هەموو پێشکەشکراوەکانی دانەوێڵەیان و هەموو قوربانییەکانی گوناهیان و هەموو قوربانییەکانی تاوانیان کە بۆ منی دەهێنن، ئەو بەشە هەرەپیرۆزە بۆ تۆ و بۆ کوڕەکانتە. ");
INSERT INTO ckb_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","وەک شتێکی هەرەپیرۆز دەیخۆیت، هەموو نێرینەیەک لێی دەخوات، بۆ تۆ پیرۆز دەبێت. ");
INSERT INTO ckb_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","«ئەوەی لە بەخشین و قوربانی بەرزکردنەوەی ئیسرائیلییەکان بەلاوەدەنرێت، بۆ تۆیە. بەشێکی چەسپاوە داومەتە تۆ و کوڕ و کچەکانت. ئیتر هەموو کەسێک لە ماڵەکەت کە بەپێی ڕێوڕەسم پاکە لێی دەخوات. ");
INSERT INTO ckb_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","«باشترین زەیت و باشترین شەراب و باشترین دانەوێڵە، یەکەمین بەرهەمەکانیان کە بە یەزدانی دەدەن، من هەموویم داوەتە تۆ، ");
INSERT INTO ckb_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","یەکەمین بەرهەمی هەموو شتێکی زەوییەکەیان کە بۆ یەزدانی پێشکەش دەکەن بۆ تۆ دەبێت، هەموو کەسێک لە ماڵەکەت ئەوەی بەپێی ڕێوڕەسم پاکە لێی دەخوات. ");
INSERT INTO ckb_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","«هەموو تەرخانکراوێک بۆ یەزدان لە ئیسرائیل بۆ تۆ دەبێت، ");
INSERT INTO ckb_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","هەر نۆبەرەیەکی سک کە پێشکەشی یەزدانی دەکەن لە مرۆڤ و لە ئاژەڵ، بۆ تۆ دەبێت، بەڵام پێویستە کوڕە نۆبەرەی مرۆڤ و نۆبەرە نێرینەی ئاژەڵی گڵاویش بکڕیتەوە. ");
INSERT INTO ckb_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","پێویستە لە تەمەنی یەک مانگییەوە بیانکڕیتەوە، نرخی کڕینەوەش پێنج شاقل لە زیو بەگوێرەی خەمڵاندنی شاقلی پیرۆزگا، کە بیست گێرایە. ");
INSERT INTO ckb_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","«بەڵام پێویستە نۆبەرەی مانگا و مەڕ و بزن نەکڕیتەوە، ئەوان پیرۆزن و خوێنەکەیان بەسەر قوربانگاکەدا دەڕژێنیت و پیوەکەیان دەسووتێنیت، قوربانی بە ئاگرە، ئەو بۆنەی یەزدان پێی خۆشە. ");
INSERT INTO ckb_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","گۆشتەکەشی بۆ تۆ دەبێت وەک سنگی قوربانی بەرزکردنەوە و ڕانی ڕاستە. ");
INSERT INTO ckb_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","هەرچییەک کە بەلاوە دەنرێت لە پێشکەشکراوە پیرۆزەکانی نەوەی ئیسرائیل کە بۆ یەزدانی پێشکەش دەکەن وەک بەشێکی چەسپاو داومە بە تۆ و کوڕ و کچەکانت، دەبێتە پەیمانی نمەک بۆ تۆ و نەوەکەت کە هەتاهەتایە لەبەردەم یەزدان دەچەسپێت.» ");
INSERT INTO ckb_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","هەروەها یەزدان بە هارونی فەرموو: «لە زەوییەکەیان هیچ میراتت بەرناکەوێت و لەنێویان بەشت نابێت، لەنێو نەوەی ئیسرائیل من بەش و میراتی تۆم. ");
INSERT INTO ckb_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","«بەڵام نەوەی لێڤی لەبری ئەو خزمەتەی دەیکەن، خزمەتی چادری چاوپێکەوتن، ئەوا من لە ئیسرائیل وەک میرات هەموو دەیەکێکم پێداون. ");
INSERT INTO ckb_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","لە ئێستا بەدواوە نەوەی ئیسرائیل لە چادری چاوپێکەوتن نزیک ناکەونەوە، هەتا گوناهێک هەڵبگرن کە بۆ مردن بێت، ");
INSERT INTO ckb_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","بەڵکو لێڤییەکان خزمەتی چادری چاوپێکەوتن دەکەن، ئەوان بەرپرسیاریێتی هەڵدەگرن وەک فەرزێکی هەتاهەتایی نەوە دوای نەوە، لەنێو نەوەی ئیسرائیلدا هیچ میراتیان بەرناکەوێت. ");
INSERT INTO ckb_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","دەیەکەکانی نەوەی ئیسرائیل کە بۆ یەزدانی پێشکەش دەکەن وەک بەخشینی بەرزکراوە، من داومە بە لێڤییەکان، میراتی ئەوانە، بۆیە پێیانم فەرموو کە لەنێو نەوەی ئیسرائیلدا هیچ میراتیان بەرناکەوێت.» ");
INSERT INTO ckb_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","«لەگەڵ لێڤییەکان دەدوێیت و پێیان دەڵێیت: ”کاتێک دەیەکەکە وەردەگرن لە نەوەی ئیسرائیل کە من وەک میرات بە ئێوەم داوە، بەخشینی بەرزکراوەی یەزدانی لێ پێشکەش دەکەن، دەیەک لە دەیەک. ");
INSERT INTO ckb_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","جا بە بەخشینی بەرزکراوەتان دادەنرێت، وەک دانەوێڵەی جۆخین و پڕی بەرهەمی گوشەرەکە. ");
INSERT INTO ckb_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","بەم شێوەیە ئێوەش بەخشینی بەرزکراوەی یەزدان لە هەموو دەیەکەکانتان پێشکەش دەکەن کە لە نەوەی ئیسرائیلی وەردەگرن، لەوە بەخشینی بەرزکراوەی یەزدان بە هارونی کاهین دەدەن. ");
INSERT INTO ckb_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","لە هەموو بەخشینەکانتان هەموو بەرزکراوەیەک بۆ یەزدان پێشکەش دەکەن کە لە هەرە باشترین و پیرۆزترین بێت.“ ");
INSERT INTO ckb_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","«پێیان دەڵێیت: ”کاتێک باشترینەکەی پێشکەش دەکەن، وەک بەرهەمی جۆخین و گوشەر بۆ لێڤییەکان هەژمارد دەکرێت. ");
INSERT INTO ckb_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","ئێوە و ماڵەکانتان لە هەموو شوێنێک دەیخۆن، چونکە کرێی ئێوەیە لەبری خزمەتتان لە چادری چاوپێکەوتن. ");
INSERT INTO ckb_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","بەهۆیەوە گوناهباریش نابن ئەگەر لە باشترینەکەی پێشکەش بکەن، بەڵام پێشکەشکراوە پیرۆزەکانی نەوەی ئیسرائیل گڵاو مەکەن نەوەک بمرن.“» ");
INSERT INTO ckb_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","یەزدان بە موسا و هارونی فەرموو: ");
INSERT INTO ckb_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","«ئەمە فەرزی فێرکردنەکەیە کە یەزدان فەرمانی پێ کردووە و دەفەرموێت، بە نەوەی ئیسرائیل بڵێ با نوێنگینێکی سووری ساغت بۆ بهێنن کە کەموکوڕی تێدا نەبێت و نیری نەخرابێتە سەر. ");
INSERT INTO ckb_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","بدرێتە ئەلعازاری کاهین و دەبردرێتە دەرەوەی ئۆردوگا و لەبەردەمی سەردەبڕدرێت. ");
INSERT INTO ckb_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","ئەلعازاری کاهینیش بە پەنجەی لە خوێنەکەی دەبات و بەرەو ڕووی چادری چاوپێکەوتن حەوت جار دەیپرژێنێت. ");
INSERT INTO ckb_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","نوێنگینەکەش لەبەرچاوی دەسووتێنرێت، پێستی و گۆشتی و خوێنی و ڕیخۆڵەکەی دەسووتێنرێت. ");
INSERT INTO ckb_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","کاهینیش پارچە دارێکی ئورز و بەنی سووری ئاڵ و زوفا دەبات و هەڵیاندەداتە ناو ئاگری نوێنگینەکە. ");
INSERT INTO ckb_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","ئینجا کاهین جلەکانی دەشوات و خۆی بە ئاو دەشوات و لەدوای ئەوە دێتە ناو ئۆردوگاکەوە، هەتا ئێوارەش گڵاو دەبێت. ");
INSERT INTO ckb_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","ئەوەش کە سووتاندی جلەکانی بە ئاو دەشوات و خۆی بە ئاو دەشوات و هەتا ئێوارەش گڵاو دەبێت. ");
INSERT INTO ckb_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","«پیاوێکی پاکیش خۆڵەمێشی نوێنگینەکە کۆدەکاتەوە و لە دەرەوەی ئۆردوگاکە لە شوێنێکی پاک بەپێی ڕێوڕەسم دایدەنێت. پێویستە کۆمەڵی نەوەی ئیسرائیل بیپارێزن و بۆ ئاوی پاککردنەوە بەکاریبهێنن؛ بۆ پاکبوونەوە لە گوناه. ");
INSERT INTO ckb_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","ئەوەی خۆڵەمێشی نوێنگینەکەشی کۆکردەوە جلەکانی دەشوات و هەتا ئێوارە گڵاو دەبێت، جا بۆ نەوەی ئیسرائیل و ئەو نامۆیەش کە لەنێویانە، دەبێت بە فەرزێکی هەتاهەتایی. ");
INSERT INTO ckb_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","«ئەوەی دەست لە لاشەی کەسێکی مردوو بدات ئەوا حەوت ڕۆژ گڵاو دەبێت. ");
INSERT INTO ckb_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","پێویستە لە ڕۆژی سێیەمدا خۆی پێ پاک بکاتەوە و لە ڕۆژی حەوتەم پاک دەبێت، بەڵام ئەگەر لە ڕۆژی سێیەمدا خۆی پاک نەکاتەوە ئەوا لە ڕۆژی حەوتەم پاک نابێت. ");
INSERT INTO ckb_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","هەرکەسێک دەست لە لاشەی کەسێکی مردوو بدات و خۆی پاک نەکاتەوە ئەوا چادری پەرستنی یەزدان گڵاو دەکات، ئەو کەسە لە ئیسرائیل دادەبڕدرێت، چونکە ئاوی پاککردنەوەی بەسەردا نەپرژێنراوە و گڵاوە، گڵاوییەکەی هێشتا تێدا ماوە. ");
INSERT INTO ckb_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","«ئەمە فێرکردنەکەیە، ئەگەر کەسێک لەناو چادرێکدا مرد ئەوا هەر یەکێک بێتە ناو چادرەکە و هەموو ئەوانەی لەناو چادرەکە بوون حەوت ڕۆژ گڵاو دەبن، ");
INSERT INTO ckb_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","هەموو دەفرێکی کراوەش کە بە باشی سەری دانەخرابێت ئەوا گڵاوە. ");
INSERT INTO ckb_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","«هەرکەسێک لە دەشتودەر دەست لە کوژراوێکی بە شمشێر یان مردووێک یان ئێسکی مرۆڤێک یان گۆڕێک بدات، ئەوا حەوت ڕۆژ گڵاو دەبێت. ");
INSERT INTO ckb_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","«جا بۆ گڵاو لە خۆڵەمێشی ئاگری قوربانی پاکبوونەوە دەبەن و لە گۆزەیەکدا ئاوێکی سازگاری بەسەردا دەکەن. ");
INSERT INTO ckb_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","پیاوێکی پاکیش بەپێی ڕێوڕەسم زوفایەک دەبات و نوقومی ناو ئاوەکەی دەکات و بەسەر چادر و هەموو شتومەکەکانیدا دەپرژێنێت، بەسەر ئەو کەسانەشدا دەپرژێنێت کە لەوێ بوون، هەروەها ئەوەش کە دەستی لە ئێسک یان کوژراو یان مردوو یان گۆڕ داوە. ");
INSERT INTO ckb_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","کەسە پاکەکەش لە ڕۆژی سێیەم و ڕۆژی حەوتەم ئاوەکە بەسەر کەسە گڵاوەکەدا دەپرژێنێت، لە ڕۆژی حەوتەم پاکی دەکاتەوە. ئەویش جلەکانی دەشوات و خۆی بە ئاو دەشوات و بۆ ئێوارە پاک دەبێت. ");
INSERT INTO ckb_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","بەڵام ئەو کەسەی گڵاو دەبێت و خۆی پاک ناکاتەوە، ئەوا ئەو گیانە لەنێو کۆمەڵدا دادەبڕدرێت، چونکە پیرۆزگای یەزدانی گڵاو کردووە، ئاوی پاککردنەوەی بەسەردا نەپرژێنراوە، گڵاوە. ");
INSERT INTO ckb_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","جا بۆیان دەبێتە فەرزێکی هەتاهەتایی. «ئەوەی ئاوی پاککردنەوەی پرژاندووە جلەکانی دەشوات، ئەوەی دەستی لە ئاوی پاککردنەوە داوە، هەتا ئێوارە گڵاو دەبێت، ");
INSERT INTO ckb_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","هەرچییەک ئەو گڵاوە دەستی لێ بدات گڵاو دەبێت و ئەو کەسەش کە دەستی لێ بدات هەتا ئێوارە گڵاو دەبێت.» ");
INSERT INTO ckb_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","ئینجا نەوەی ئیسرائیل، هەموو کۆمەڵەکە هاتنە چۆڵەوانی چن لە مانگی یەکدا و گەل لە قادێش چادریان هەڵدا و لەوێدا مریەم مرد و لەوێش نێژرا. ");
INSERT INTO ckb_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","ئاو نەبوو بۆ کۆمەڵ، جا لە دژی موسا و هارون کۆبوونەوە و ");
INSERT INTO ckb_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","گەل کردیان بە دەمەقاڵێ لەگەڵ موسا و گوتیان: «خۆزگە وەک براکانمان لەبەردەم یەزدان لەناوبچووینایە! ");
INSERT INTO ckb_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","بۆچی کۆمەڵی یەزدانتان هێنایە ئەم چۆڵەوانییە هەتا تێیدا خۆمان و مەڕوماڵاتمان بمرین؟ ");
INSERT INTO ckb_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","بۆچی ئێمەتان لە میسرەوە هێنایە دەرەوە تاکو بمانهێنن بۆ ئەم شوێنە خراپە؟ ئەم شوێنە دانەوێڵە و هەنجیر و مێو و هەناری لێ نییە، ئاوی خواردنەوەشی لێ نییە!» ");
INSERT INTO ckb_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","جا موسا و هارون لەبەردەم کۆمەڵەوە هاتنە لای دەروازەی چادری چاوپێکەوتن و بەسەر ڕوویاندا کەوتن و شکۆمەندی یەزدانیان بۆ دەرکەوت. ");
INSERT INTO ckb_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","یەزدانیش بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","«گۆچانەکە ببە و کۆمەڵ کۆبکەرەوە، تۆ و هارونی برات لەبەرچاویاندا بەو تاشەبەردە بڵێن هەتا ئاوەکەی بدات، جا لە تاشەبەردەکەوە ئاویان بۆ هەڵدەقوڵێت و کۆمەڵ و مەڕوماڵاتەکانیان ئاو دەدەیت.» ");
INSERT INTO ckb_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","موساش گۆچانەکەی لەبەردەم یەزدانەوە برد وەک فەرمانی پێ کرد. ");
INSERT INTO ckb_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","موسا و هارون جەماوەریان لەپێش تاشەبەردەکە کۆکردەوە، موسا پێی گوتن: «ئەی یاخیبووان گوێ بگرن، ئایا لەم بەردەوە ئاوتان بۆ دەربهێنین؟» ");
INSERT INTO ckb_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","موسا دەستی بەرزکردەوە و بە گۆچانەکەی دوو جار لە تاشەبەردەکەی دا، جا ئاوێکی زۆر هەڵقوڵا و کۆمەڵ و مەڕوماڵاتەکانیشیان لێیان خواردەوە. ");
INSERT INTO ckb_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","بەڵام یەزدان بە موسا و هارونی فەرموو: «لەبەر ئەوەی متمانەتان پێ نەکردم، تاکو لەبەرچاوی گەلی ئیسرائیل من بە پیرۆز نیشان بدەن، هەر لەبەر ئەوە ئەم کۆمەڵە نابەنە ناو ئەو خاکەی پێم داون.» ");
INSERT INTO ckb_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","ئەمە مێرگی مەریبایە کە نەوەی ئیسرائیل لەگەڵ یەزداندا دەمەقاڵێیان کرد و ئەویش لەنێویاندا پیرۆزی خۆی نیشان دان. ");
INSERT INTO ckb_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","ئینجا موسا لە قادێشەوە چەند نێردراوێکی بۆ لای پاشای ئەدۆم نارد: «ئیسرائیلی برات ئاوا دەڵێت: تۆ بە هەموو ناخۆشییەکانت زانی کە تووشمان هات. ");
INSERT INTO ckb_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","باوکانمان چوونە میسر و ڕۆژانێکی زۆر لە میسر ماینەوە. میسرییەکان ئێمە و باوکانی ئێمەیان زەلیل کرد، ");
INSERT INTO ckb_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","بەڵام هاوارمان بۆ یەزدان کرد و گوێی لە دەنگمان بوو، فریشتەیەکی نارد و لە میسر دەریهێناین. «ئێستا ئێمە لە قادێشین کە شارۆچکەیەکە لە نزیکی سنووری خاکەکەت. ");
INSERT INTO ckb_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","تکایە ڕێمان بدە بە خاکەکەتدا تێبپەڕین، نە بە کێڵگەیەکدا دەڕۆین و نە بە ڕەزێکدا و نە ئاوی بیرێک دەخۆینەوە، لە شاڕێگای پاشاوە دەڕۆین، نە بەلای ڕاست لادەدەین و نە بەلای چەپ هەتا لە خاکەکەت دەچینە دەرەوە.» ");
INSERT INTO ckb_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","بەڵام ئەدۆم وەڵامی دانەوە: «بە خاکەکەماندا ناڕۆن، ئەگینا بە شمشێرەوە پەلامارتان دەدەم.» ");
INSERT INTO ckb_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","نەوەی ئیسرائیلیش گوتیان: «بە ڕاستەڕێدا دەڕۆین، ئەگەر خۆمان و مەڕوماڵاتەکانمان لە ئاوی تۆمان خواردەوە ئەوا نرخەکەی دەدەین، هیچی دیکە ناکەین تەنها بە پێیەکانمان تێدەپەڕین.» ");
INSERT INTO ckb_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","دیسان ئەدۆم وەڵامی دانەوە: «تێناپەڕن.» ئینجا ئەدۆم بە سوپایەکی گەورە و دەستێکی توندەوە بۆ بەرەنگاربوونەوەی دەرچوو. ");
INSERT INTO ckb_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","ئەدۆم ڕازی نەبوو ئیسرائیل بە خاکی ئەودا تێبپەڕێت، ئیسرائیلیش لێی لادا. ");
INSERT INTO ckb_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","هەموو کۆمەڵی نەوەی ئیسرائیل لە قادێشەوە کۆچیان کرد و هاتنە کێوی هۆر، ");
INSERT INTO ckb_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","یەزدانیش لە کێوی هۆر لەسەر سنووری خاکی ئەدۆم بە موسا و هارونی فەرموو: ");
INSERT INTO ckb_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","«هارون دەچێتە پاڵ گەلەکەی، چونکە ناچێتە ناو ئەو خاکەی بە نەوەی ئیسرائیلم داوە، چونکە ئێوە لەلای مێرگی مەریبا لە فەرمانم یاخی بوون. ");
INSERT INTO ckb_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","هارون و ئەلعازاری کوڕی ببە سەر کێوی هۆر و ");
INSERT INTO ckb_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","جلەکان لەبەر هارون دابکەنە و لەبەر ئەلعازاری کوڕی بکە، جا هارونیش دەچێتە پاڵ گەلەکەی و لەوێ دەمرێت.» ");
INSERT INTO ckb_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","موساش ئاوای کرد وەک یەزدان فەرمانی دا و لەبەرچاوی هەموو کۆمەڵ بەسەر کێوی هۆر کەوتن. ");
INSERT INTO ckb_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","ئینجا موسا جلەکانی لەبەر هارون داکەند و لەبەر ئەلعازاری کوڕی کرد، هارونیش لەوێ لەسەر لووتکەی کێوەکە مرد. ئینجا موسا و ئەلعازار لە کێوەکە هاتنە خوارەوە. ");
INSERT INTO ckb_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","کاتێک هەموو کۆمەڵ بینییان هارون مرد، هەموو بنەماڵەی ئیسرائیل سی ڕۆژ بۆ هارون گریان. ");
INSERT INTO ckb_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","کاتێک کەنعانییەکەی پاشای عەراد کە لە نەقەب نیشتەجێ بوو بیستی نەوەی ئیسرائیل لە ڕێگای ئەتاریمەوە هاتووە، شەڕی لەگەڵ ئیسرائیلییەکاندا کرد و هەندێکی لێیان بە دیل گرت. ");
INSERT INTO ckb_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","نەوەی ئیسرائیلیش نەزرێکیان بۆ یەزدان کرد و گوتیان، «ئەگەر ئەو نەتەوەیە بخەیتە ژێر دەستمان، ئەوا شارەکانی بە تەواوی وێران دەکەین.» ");
INSERT INTO ckb_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","یەزدانیش گوێی لە هاواری ئیسرائیل گرت و کەنعانییەکانی دایە دەست و خۆیان و شارۆچکەکانیان بە تەواوی وێران کردن، ئیتر ئەو شوێنە ناونرا حۆرما. ");
INSERT INTO ckb_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","ئینجا لە کێوی هۆرەوە بە ڕێگای دەریای سوور کۆچیان کرد هەتا بە خاکی ئەدۆمدا بسوڕێنەوە، جا گەل لە ڕێگادا ئارامییان لێ بڕا. ");
INSERT INTO ckb_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","گەل لە دژی خودا و موسا قسەیان کرد و گوتیان: «بۆچی لە میسر دەرتانهێناین هەتا لە چۆڵەوانی بمرین؟ نە نان هەیە و نە ئاو! ئەم خواردنە بێ تامەمان لەبەرچاو کەوتووە.» ");
INSERT INTO ckb_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","یەزدانیش ماری ژەهراوی بۆ سەر گەل نارد و بە گەلیانەوە دا و خەڵکێکی زۆر لە ئیسرائیل مردن. ");
INSERT INTO ckb_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","ئینجا گەل هاتنە لای موسا و گوتیان: «گوناهمان کرد لە دژی یەزدان و لە دژی تۆش قسەمان کرد. لەبەر ئەوە نزا بۆ یەزدان بکە هەتا ئەو مارانەمان لەسەر هەڵبگرێت.» موساش لە پێناوی گەل نزای کرد. ");
INSERT INTO ckb_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","یەزدانیش بە موسای فەرموو: «مارێکی ژەهراوی دروستبکە و لەسەر ستوونێک هەڵیبواسە، جا هەر یەکێک پێیەوەدرا و تەماشای کرد دەژیێت.» ");
INSERT INTO ckb_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","موساش مارێکی لە بڕۆنز دروستکرد و لەسەر ستوونێک هەڵیواسی، ئەوە بوو هەر کاتێک کەسێک مار پێوەی دەدا و تەماشای مارە بڕۆنزییەکەی دەکرد، دەژیا. ");
INSERT INTO ckb_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","ئینجا نەوەی ئیسرائیل کۆچیان کرد و لە ئۆڤۆت چادریان هەڵدا، ");
INSERT INTO ckb_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","لە ئۆڤۆتەوەش کۆچیان کرد و لە عییی عەڤاریم لە چۆڵەوانی بەرامبەر مۆئاب ڕووەو خۆر هەڵاتن چادریان هەڵدا. ");
INSERT INTO ckb_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","لەوێشەوە کۆچیان کرد و لە دۆڵی زەرەد چادریان هەڵدا، ");
INSERT INTO ckb_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","لەوێشەوە کۆچیان کرد و لە قەراغی باکووری ڕووباری ئەرنۆن چادریان هەڵدا کە لە چۆڵەوانییە لە دەرەوەی سنووری ئەمۆرییەکانە، چونکە ئەرنۆن سنووری مۆئابە لەنێوان مۆئاب و ئەمۆرییەکان، ");
INSERT INTO ckb_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","لەبەر ئەوە پەڕتووکی جەنگەکانی یەزدان دەڵێت: «شاری واهێڤ لە سوفە و شیوەکانی، ئەرنۆن و ");
INSERT INTO ckb_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","نشێوی شیوەکان، ئەوەی هەتا نشینگەی عار شۆڕ بووەتەوە، پشتی بە سنووری مۆئابەوە داوە.» ");
INSERT INTO ckb_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","لەوێشەوە بۆ بئێر بەردەوام بوون، ئەوەش ئەو بیرەیە کە لەوێ یەزدان بە موسای فەرموو، «گەل کۆبکەرەوە ئاویان دەدەمێ.» ");
INSERT INTO ckb_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","ئەوسا ئیسرائیل ئەم گۆرانییەیان چڕی: «ئەی بیر هەڵبقوڵێ، گۆرانی لە بارەوە بڵێن، ");
INSERT INTO ckb_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","بیرێک میرەکان لێیان داوە، پیاوماقوڵانی گەل هەڵیانکەندووە، ئەو پیاوماقوڵانە بە داردەست و گۆچانەکانیان.» لە چۆڵەوانییەوە هەتا مەتانە چوون، ");
INSERT INTO ckb_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","لە مەتانەوە هەتا نەحەلیێل و لە نەحەلیێلەوە هەتا بامۆت، ");
INSERT INTO ckb_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","لە بامۆتەوە هەتا دۆڵێک کە لە مۆئابە و لە لووتکەی چیای پسگە کە دەڕوانێتە سەر ڕووی چۆڵەوانی. ");
INSERT INTO ckb_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","ئینجا ئیسرائیل نێردراوی بۆ سیحۆنی پاشای ئەمۆرییەکان نارد و گوتی: ");
INSERT INTO ckb_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","«ڕێمان بدە بە خاکەکەتدا تێپەڕین، نە بەلای کێڵگەیەک و نە بەلای ڕەزە مێوێک لانادەین و ئاو لە بیر ناخۆینەوە، هەتا لە خاکەکەت دەچینە دەرەوە بە شاڕێگادا دەڕۆین.» ");
INSERT INTO ckb_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","بەڵام سیحۆن نەیهێشت ئیسرائیل بە خاکەکەیدا تێبپەڕێت، بەڵکو هەموو سوپاکەی کۆکردەوە و بۆ بەرەنگاربوونەوەی ئیسرائیل بۆ چۆڵەوانی دەرچوو، هاتە یەهەچ و شەڕی لەگەڵ ئیسرائیل کرد. ");
INSERT INTO ckb_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","ئیسرائیلیش بە شمشێر لێیدا و دەستی بەسەر خاکەکەیدا گرت، لە ئەرنۆنەوە هەتا یەبۆق و هەتا نەوەی عەمۆن، چونکە سنووری عەمۆنییەکان بەهێز بوو. ");
INSERT INTO ckb_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","ئیسرائیل هەموو ئەم شارانەی گرت، ئیسرائیل لە هەموو شارەکانی ئەمۆرییەکان نیشتەجێ بوو، لە حەشبۆن و لە هەموو گوندەکانی. ");
INSERT INTO ckb_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","لەبەر ئەوەی حەشبۆن شاری سیحۆنی پاشای ئەمۆرییەکان بوو، شەڕی لەگەڵ پاشای پێشووی مۆئاب کردبوو و هەموو خاکەکەی لە دەستی سەندبوو هەتا ئەرنۆن. ");
INSERT INTO ckb_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","لەبەر ئەوە شیعرەکان دەڵێن: «وەرنە حەشبۆن بنیاد دەنرێتەوە، شاری سیحۆن نۆژەن دەکرێتەوە. ");
INSERT INTO ckb_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","«ئاگرێک لە حەشبۆنەوە کڵپەی کرد، گڕێک لە شاری سیحۆنەوە، عاری مۆئابی هەڵلووشی، پیاوانی بەرزاییەکانی ئەرنۆن. ");
INSERT INTO ckb_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","قوڕبەسەرت مۆئاب! ئەی گەلی کەمۆش لەناوچوویت! کوڕەکانی ئاوارە کرد و کچەکانی ڕاپێچ کرد بۆ سیحۆنی پاشای ئەمۆرییەکان. ");
INSERT INTO ckb_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","«بەڵام وا ئەوانمان ڕووخاند، حەشبۆن لەناوچوو هەتا دیڤۆن، تێکمان دا هەتا نۆفە کە هەتا مادەبا درێژ دەبێتەوە.» ");
INSERT INTO ckb_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","جا ئیسرائیل لە خاکی ئەمۆرییەکاندا مایەوە. ");
INSERT INTO ckb_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","ئینجا موسا هەندێک کەسی نارد بۆ سیخوڕیکردن لە یەعزێر، ئیتر گوندەکانیان گرت و ئەو ئەمۆرییانەیان دەرکرد کە لەوێ بوون. ");
INSERT INTO ckb_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","ئینجا ڕوویان وەرگێڕا و بە ڕێگای باشاندا سەرکەوتن، جا عۆگی پاشای باشان لەگەڵ هەموو سوپاکەی بۆ بەرەنگاربوونەوەیان گەیشتە ئەدرەعی. ");
INSERT INTO ckb_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","یەزدانیش بە موسای فەرموو: «لێی مەترسە، چونکە خۆی و هەموو سوپاکەی و خاکەکەیم داوەتە دەستت، ئەوەی پێ دەکەیت کە بە سیحۆنی پاشای ئەمۆرییەکانت کرد کە لە حەشبۆن فەرمانڕەوا بوو.» ");
INSERT INTO ckb_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","جا لە خۆی و کوڕەکانی و هەموو سوپایەکەیان دا و کەس دەرباز نەبوو، بوونە خاوەنی خاکەکەی. ");
INSERT INTO ckb_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","ئینجا نەوەی ئیسرائیل کۆچیان کرد و لە دەشتاییەکانی مۆئاب لەلای کەناری ڕووباری ئوردون بەرامبەر ئەریحا چادریان هەڵدا. ");
INSERT INTO ckb_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","کاتێک بالاقی کوڕی چیپور هەموو ئەو شتانەی بینی کە ئیسرائیل بە ئەمۆرییەکانی کرد، ");
INSERT INTO ckb_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","مۆئاب لە گەلەکە تۆقی، چونکە زۆر بوون، مۆئاب بەهۆی نەوەی ئیسرائیل ترسی لێ نیشت. ");
INSERT INTO ckb_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","مۆئابییەکان بە پیرەکانی میدیانیان گوت: «ئێستا ئەم ئاپۆرەی خەڵکە هەموو چواردەورمان دەلێسنەوە وەک چۆن گا سەوزایی کێڵگە دەلێسێتەوە.» لەو سەردەمە بالاقی کوڕی چیپور پاشای مۆئاب بوو. ");
INSERT INTO ckb_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","چەند نێردراوێکی بۆ لای بەلعامی کوڕی بەعۆر نارد بۆ پەتور کە نزیک ڕووباری فوراتە لە خاکی نەوەی گەلەکەی، بۆ ئەوەی بانگی بکات و بڵێت: «وا گەلێک لە میسر هاتووە و ڕووی زەوی داپۆشیوە و لەتەنیشتم نیشتەجێیە. ");
INSERT INTO ckb_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","ئێستاش وەرە و نەفرەت لەم گەلە بکە بۆم، چونکە لە من مەزنترن. بەڵکو بتوانم بیانشکێنم و لە خاکەکە دەریانبکەم، چونکە زانیومە ئەوەی داوای بەرەکەتی بۆ بکەیت بەرەکەتدار کراوە و ئەوەی نەفرەتی لێ بکەیت نەفرەت لێکراوە.» ");
INSERT INTO ckb_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","پیرانی مۆئاب و پیرانی میدیان بە کرێی فاڵگرتنەوە بەڕێکەوتن و هاتنە لای بەلعام و بە وتەکانی بالاق لەگەڵیدا دوان. ");
INSERT INTO ckb_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","ئەویش پێی گوتن: «ئەمشەو لێرە بمێننەوە، یەزدان چیم پێ بڵێت، ئاوا وەڵامتان دەدەمەوە.» ئینجا پیاوە گەورەکانی مۆئاب لەلای بەلعام مانەوە. ");
INSERT INTO ckb_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","ئینجا خودا هاتە لای بەلعام و فەرمووی: «ئەو پیاوانە کێن کە لەلاتن؟» ");
INSERT INTO ckb_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","بەلعامیش بە خودای گوت: «بالاقی کوڕی چیپوری پاشای مۆئاب بەدوامدا ناردوویەتی و دەڵێت، ");
INSERT INTO ckb_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","”ئەو گەلەی لە میسرەوە هاتووە ڕووی زەوی داپۆشیوە. ئێستا وەرە و نەفرەتیان لێ بکە بۆم، تاکو بتوانم لەگەڵیاندا بجەنگم و دەریانبکەم.“» ");
INSERT INTO ckb_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","بەڵام خودا بە بەلعامی فەرموو: «لەگەڵیاندا مەڕۆ و نەفرەت لە گەلەکە مەکە، چونکە بەرەکەتدارن.» ");
INSERT INTO ckb_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","بەلعام بەیانی هەستا و بە پیاوە گەورەکانی بالاقی گوت: «بۆ خاکەکەتان بگەڕێنەوە، چونکە یەزدان ڕازی نەبوو ڕێم بدات لەگەڵتان بێم.» ");
INSERT INTO ckb_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","پیاوە گەورەکانی مۆئابیش هەستان و هاتنە لای بالاق و گوتیان: «بەلعام ڕازی نەبوو لەگەڵماندا بێت.» ");
INSERT INTO ckb_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","ئینجا بالاق دووبارە پیاوی گەورەی زۆرتر و بەڕێزتری لەوانەی پێشووتر نارد. ");
INSERT INTO ckb_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","ئەوانیش هاتنە لای بەلعام و پێیان گوت: «بالاقی کوڕی چیپور ئاوا دەڵێت: با هیچ شتێک ڕێت لێ نەگرێت بێیت بۆ لام، ");
INSERT INTO ckb_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","چونکە پاداشتێکی گەورەت دەکەم، ئەوەی پێم بڵێی دەیکەم، ئێستا وەرە و نەفرەت لەم گەلە بکە بۆم.» ");
INSERT INTO ckb_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","بەڵام بەلعام وەڵامی دایەوە و بە خزمەتکارانی بالاقی گوت: «ئەگەر بالاق بە پڕی کۆشکەکەی زێڕ و زیوم پێبدات ناتوانم لە فەرمانی یەزدانی پەروەردگارم دەربچم، بۆ ئەوەی شتێکی بچووک یان گەورە بکەم. ");
INSERT INTO ckb_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","ئێوەش ئێستا ئەمشەو لێرە بمێننەوە، هەتا بزانم یەزدان ئەم جارە چیم پێ دەڵێت.» ");
INSERT INTO ckb_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","خودا لە شەودا هاتە لای بەلعام و پێی فەرموو: «لەبەر ئەوەی ئەو پیاوانە هاتوون هەتا بانگت بکەن، هەستە و لەگەڵیاندا بڕۆ، بەڵام تەنها ئەو قسەیەی کە من پێت دەڵێم ئەوە دەکەیت.» ");
INSERT INTO ckb_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","بەلعامیش بەیانی هەستا و ماکەرەکەی کورتان کرد و لەگەڵ پیاوە گەورەکانی مۆئاب بەڕێکەوت. ");
INSERT INTO ckb_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","بەڵام کاتێک بەڕێکەوت تووڕەیی خودا جۆشا، ئینجا فریشتەی یەزدان لەسەر ڕێگا بۆی وەستا، هەتا بەربەرەکانێی بکات. لەو کاتەی بەلعام سواری ماکەرەکەی ببوو و هەردوو خزمەتکارەکەشی لەگەڵی بوون. ");
INSERT INTO ckb_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","کە ماکەرەکە فریشتەی یەزدانی بینی لەسەر ڕێگاکە وەستاوە و شمشێرەکەی هەڵکێشاوە و بە دەستیەوەیە، ماکەرەکە لە ڕێگاکە لایدا و دایەوە ناو کێڵگە، بەلعامیش لە ماکەرەکەی دا هەتا بیگەڕێنێتەوە سەر ڕێگاکە. ");
INSERT INTO ckb_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","ئینجا فریشتەی یەزدان لە ڕێچکەیەکی باریکدا لەنێوان دوو ڕەزدا وەستا کە لەملا و ئەولا دیواری هەبوو، ");
INSERT INTO ckb_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","کاتێک ماکەرەکە فریشتەی یەزدانی بینی ملی دا بە دیوارەکە و پێی بەلعام بەر دیوارەکە کەوت. ئینجا دیسان لە ماکەرەکەی دایەوە. ");
INSERT INTO ckb_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","دواتر فریشتەی یەزدان پێشیان کەوتەوە و لە شوێنێکی تەنگەبەر وەستا کە هیچ ڕێگا نەبوو بۆ سووڕانەوە، نە بەلای ڕاست و نە بەلای چەپدا. ");
INSERT INTO ckb_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","کە ماکەرەکە فریشتەی یەزدانی بینی، لەژێر بەلعامدا خۆی کێشایەوە، تووڕەیی بەلعام جۆشا و بە گۆچانەکەی لە ماکەرەکەی دا، ");
INSERT INTO ckb_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","ئینجا یەزدان دەمی ماکەرەکەی کردەوە و بە بەلعامی گوت: «چیم لێکردوویت کە سێ جار لێت دام؟» ");
INSERT INTO ckb_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","بەلعامیش بە ماکەرەکەی گوت: «لەبەر ئەوەی سووکایەتیم پێ دەکەیت، ئەگەر شمشێرم لە دەست بووایە ئێستا دەمکوشتیت.» ");
INSERT INTO ckb_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","ماکەرەکەش بە بەلعامی گوت: «باشە من ماکەرەکەی تۆ نیم کە لەو کاتەوەی هەی سوارم دەبیت هەتا ئەمڕۆ، ئایا من لێڕاهاتووم وات لێ بکەم؟» ئەویش گوتی: «نا.» ");
INSERT INTO ckb_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","ئینجا یەزدان چاوی بەلعامی کردەوە و فریشتەی یەزدانی بینی لەسەر ڕێگاکە وەستاوە و شمشێری هەڵکێشاوە و بە دەستیەوەیە، جا بەسەر ڕوویدا کەوت و کڕنۆشی برد. ");
INSERT INTO ckb_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","فریشتەی یەزدانیش پێی فەرموو: «بۆچی هەتا ئێستا سێ جار لە ماکەرەکەی خۆتت داوە؟ ئەوەتا من بۆ بەربەرەکانێت هاتووم، چونکە لەبەرچاوی من ڕێگاکەت لاساریکردنە. ");
INSERT INTO ckb_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","ماکەرەکە منی بینی هەتا ئێستا سێ جار لە بەرامبەرم خۆی لادا، ئەگەر لە بەرامبەرم خۆی لانەدەدا، ئێستا من تۆم دەکوشت و ئەوم دەهێشتەوە.» ");
INSERT INTO ckb_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","بەلعام بە فریشتەی یەزدانی گوت: «گوناهم کرد، من نەمزانی کە تۆ بوویت ئەوەی لەسەر ڕێگا لەپێشم وەستاویت بۆ بەربەرەکانێم، ئێستاش ئەگەر پێت ناخۆشە من دەگەڕێمەوە.» ");
INSERT INTO ckb_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","فریشتەی یەزدانیش بە بەلعامی فەرموو: «لەگەڵ پیاوەکاندا بڕۆ، بەڵام تەنها ئەو قسەیەی کە من پێت دەڵێم ئەوە دەکەیت.» ئیتر بەلعام لەگەڵ پیاوە گەورەکانی بالاق بەڕێکەوت. ");
INSERT INTO ckb_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","کاتێک بالاق بیستی کە بەلعام هاتووە، چوو بۆ پێشوازیکردنی بۆ ئەو شارۆچکەیەی مۆئاب کە لەسەر سنووری ئەرنۆنە، لەوپەڕی خاکەکەی. ");
INSERT INTO ckb_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","بالاق بە بەلعامی گوت: «ئایا بەدوای تۆمدا نەنارد، هەتا بانگت بکەم، ئیتر بۆ نەهاتی؟ ئایا بەڕاستی من ناتوانم پاداشتت بکەم؟» ");
INSERT INTO ckb_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","بەلعامیش بە بالاقی گوت: «ئەوەتا ئێستا هاتم بۆ لات، ئایا ئێستا هیچ توانایەکم هەیە کە خۆم شتێک بڵێم؟ ئەو وشەیەی خودا دەیخاتە دەمم ئەوە دەڵێم.» ");
INSERT INTO ckb_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","بەلعام و بالاق بەڕێکەوتن و هاتنە قیریەت حوچۆت، ");
INSERT INTO ckb_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","ئینجا بالاق مەڕ و مانگای سەربڕی و بەدوای بەلعام و ئەو پیاوە گەورانەی نارد کە لەگەڵی بوون. ");
INSERT INTO ckb_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","بۆ بەیانی بالاق بەلعامی بردە سەرەوە بۆ بامۆت‌بەعل و لەوێوە ئەوپەڕی گەلی بینی. ");
INSERT INTO ckb_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","بەلعام بە بالاقی گوت: «لێرە حەوت قوربانگام بۆ دروستبکە و هەر لێرە حەوت گا و حەوت بەرانم بۆ ئامادە بکە.» ");
INSERT INTO ckb_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","بالاقیش بەم جۆرەی کرد، وەک بەلعام گوتی. ئیتر بالاق و بەلعام بۆ سەر هەر قوربانگایەک گایەک و بەرانێکیان سەرخست. ");
INSERT INTO ckb_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","ئینجا بەلعام بە بالاقی گوت: «تۆ لەلای قوربانی سووتاندنەکەت بوەستە و من دەڕۆم، لەوانەیە یەزدان بۆ بینینم بێت و هەرچی پیشانم بدات پێت دەڵێم.» ئینجا بۆ شوێنێکی بەرز و چۆڵ چوو. ");
INSERT INTO ckb_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","خودا هاتە لای بەلعام، بەلعامیش پێی گوت: «حەوت قوربانگام ئامادە کرد و گایەک و بەرانێکم خستە سەر هەر قوربانگایەک.» ");
INSERT INTO ckb_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","یەزدان وشەی خستە دەمی بەلعام و فەرمووی: «بۆ لای بالاق بگەڕێوە و ئاوا بڵێ.» ");
INSERT INTO ckb_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","ئەویش گەڕایەوە لای و بینی وا لەگەڵ هەموو پیاوە گەورەکانی مۆئاب لەلای قوربانی سووتاندنەکەی وەستاوە. ");
INSERT INTO ckb_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","ئیتر بەلعام پەیامەکەی ڕاگەیاند و گوتی: «لە ئارامەوە بالاقی پاشای مۆئاب منی هێنا، لە چیاکانی ڕۆژهەڵاتەوە، گوتی ”وەرە نەفرەت لە یاقوب بکە بۆم، وەرە جنێو بە ئیسرائیل بدە.“ ");
INSERT INTO ckb_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","چۆن نەفرەت بکەم کە خودا نەفرەتی لێیان نەکردبێت، چۆن جنێو بدەم کە یەزدان جنێوی پێیان نەدابێت؟ ");
INSERT INTO ckb_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","لەسەر تاوێرەکانەوە دەیبینم، لە گردەکانەوە تەماشای دەکەم، گەلێک وا بە تەنها نیشتەجێ بووە، خۆی بە یەکێک لە نەتەوەکان دانانێت. ");
INSERT INTO ckb_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","کێ خۆڵی یاقوبی هەژمار کردووە، کێ چارەکی ئیسرائیلی ژماردووە؟ با وەک مردنی سەرڕاستان بمرم و کۆتاییم وەک ئەوان بێت!» ");
INSERT INTO ckb_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","بالاق بە بەلعامی گوت: «چیت پێکردم! بۆ نەفرەتکردن لە دوژمنانم تۆم هێنا، کەچی وا داوای بەرەکەتیان بۆ دەکەیت!» ");
INSERT INTO ckb_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","ئەویش وەڵامی دایەوە و گوتی: «ئایا ئەوە نەڵێم، ئەوەی کە یەزدان دەیخاتە سەر زارم تاکو بیڵێم؟» ");
INSERT INTO ckb_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","ئینجا بالاق پێی گوت: «لەگەڵم وەرە بۆ شوێنێکی دیکە هەتا بیانبینیت، بەڵام تەنها بەشێکی دەبینیت و هەمووی نابینیت، لەوێوە نەفرەتیان لێ بکە.» ");
INSERT INTO ckb_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","جا بردیە کێڵگەی چۆفیم بۆ سەری پسگە و حەوت قوربانگای بنیاد نا و هەر قوربانگایەک گایەک و بەرانێکی سەرخستە سەری. ");
INSERT INTO ckb_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","بەلعام بە بالاقی گوت: «لێرە لەلای قوربانی سووتاندنەکەت بوەستە و من دەچمە ئەوێ بۆ گەیشتن بە یەزدان.» ");
INSERT INTO ckb_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","یەزدان بە بەلعام گەیشت و وشەی خستە دەمی و فەرمووی: «بگەڕێوە لای بالاق و ئاوا بڵێ.» ");
INSERT INTO ckb_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","ئەویش هاتە لای و بینی وا لەگەڵ پیاوە گەورەکانی مۆئاب لەلای قوربانی سووتاندنەکەی وەستاوە. بالاق لێی پرسی: «یەزدان چی فەرموو؟» ");
INSERT INTO ckb_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","ئیتر پەیامەکەی ڕاگەیاند و گوتی: «ئەی بالاق، هەستە و گوێ بگرە، ئەی کوڕی چیپور، گوێم بۆ شل بکە، ");
INSERT INTO ckb_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","خودا مرۆڤ نییە کە درۆ بکات، کوڕی مرۆڤیش نییە کە بڕیاری بگۆڕێت. ئایا قسە دەکات و ئەنجامی نەدات؟ یان بەڵێن دەدات و نایباتە سەر؟ ");
INSERT INTO ckb_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","فەرمانم پێدراوە داوای بەرەکەت بکەم، ئەو بەرەکەتداری کردووە و من ناتوانم بیگۆڕم. ");
INSERT INTO ckb_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","«لە یاقوبدا بەدبەختی بەرچاو نەکەوتووە، لە ئیسرائیلدا مەراقی نەبینیوە، یەزدانی پەروەردگاریان لەگەڵیاندایە، هوتافی پاشا لەنێویاندایە. ");
INSERT INTO ckb_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","خودا لە میسر دەریهێنان، ئەوانە هێزی گای کێوییان هەیە. ");
INSERT INTO ckb_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","جادووگەری لە دژی یاقوب بە کەڵک نایەت، فاڵگرتنەوەش لە دژی ئیسرائیل بێ سوودە. ئێستا دەربارەی یاقوب و ئیسرائیل دەگوترێت، ”سەیر بکە خودا چی کردووە!“ ");
INSERT INTO ckb_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","گەلێک وەک شێرە مێ هەڵدەستێت، وەک نەڕەشێر بەرز دەبێتەوە، ناخەوێت هەتا نێچیرێک نەخوات و خوێنی کوژراوان نەخواتەوە.» ");
INSERT INTO ckb_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","ئینجا بالاق بە بەلعامی گوت: «نە نەفرەتی لێ بکە و نە داوای بەرەکەتی بۆ بکە.» ");
INSERT INTO ckb_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","بەلعامیش وەڵامی دایەوە: «پێم نەگوتیت ئەوەی یەزدان بیڵێت، ئەوە دەکەم؟» ");
INSERT INTO ckb_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","بالاقیش بە بەلعامی گوت: «وەرە بتبەمە شوێنێکی دیکە، بەڵکو لەبەرچاوی خودا باش بێت و لەوێوە بۆ من نەفرەتیان لێ بکە.» ");
INSERT INTO ckb_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","ئینجا بالاق بەلعامی بردە سەر لووتکەی پەعۆر کە دەڕوانێتە سەر چۆڵەوانی. ");
INSERT INTO ckb_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","بەلعامیش بە بالاقی گوت: «لێرە حەوت قوربانگام بۆ دروستبکە و هەر لێرە حەوت گا و حەوت بەرانم بۆ ئامادە بکە.» ");
INSERT INTO ckb_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","بالاقیش وەک بەلعام چی گوت ئاوای کرد، بۆ سەر هەر قوربانگایەک گایەک و بەرانێکی خستە سەری. ");
INSERT INTO ckb_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","کاتێک بەلعام بینی لەبەرچاوی یەزدان پەسەندە کە ئیسرائیل بەرەکەتدار بکات، وەک جاری یەکەم و دووەم بەڕێ نەکەوت بۆ جادووگەری، بەڵکو ڕووی لە چۆڵەوانی کرد. ");
INSERT INTO ckb_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","کاتێک بەلعام چاوی هەڵبڕی نەوەی ئیسرائیلی بینی هۆز لەتەنیشت هۆز چادریان هەڵداوە، ڕۆحی خوداش هاتە سەری، ");
INSERT INTO ckb_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","ئیتر پەیامەکەی ڕاگەیاند و گوتی: «پەیامەکەی بەلعامی کوڕی بەعۆر، پەیامەکەی ئەو پیاوەی چاوی کراوەیە، ");
INSERT INTO ckb_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","پەیامی ئەوەی گوێی لە وشەکانی خودایە، ئەوەی خودای هەرە بەتوانا بینینی بۆ ئاشکرا دەکات، ئەوەی بەسەر ڕوودا دەکەوێت، بەڵام چاو کراوەیە: ");
INSERT INTO ckb_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","«ئەی یاقوب، چادرەکانت چەند جوانن، ئەی ئیسرائیل، نشینگەکانت چەند خۆشن! ");
INSERT INTO ckb_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","«وەک ئەو دۆڵانەی درێژ بوونەتەوە، وەک باخچەی کەناری ڕووبار، وەک ئەو درەختە ئەلوایانەی کە یەزدان چاندبێتی، وەک ئورزی قەراغی ئاو، ");
INSERT INTO ckb_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","گۆزەکانی ئاویان لێ دەڕژێت و تۆوی ئەوان لەسەر ئاوی زۆر دەبێت. «پاشای لە ئەگاگ باڵاتر دەبێت و شانشینەکەی پایەدار دەبێت. ");
INSERT INTO ckb_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","«خودا لە میسر دەریهێنان، وەک شاخی گای کێوییە بۆیان، ئەو نەتەوانەی ناحەزی دەکەن دەیانخۆن و ئێسکیان تێکدەشکێنن و بە تیرەکانیان دەیانبڕن. ");
INSERT INTO ckb_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","خۆیان وەک شێر ماتداوە و ڕاکشاون، وەک شێرە مێ، کێ هەڵیاندەستێنێت؟ «بەرەکەتدار بن ئەوانەی بەرەکەتدارتان دەکەن، نەفرەت لێکراو بن ئەوانەی نەفرەتتان لێ دەکەن.» ");
INSERT INTO ckb_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","ئینجا تووڕەیی بالاق بەسەر بەلعامەوە گڕی گرت، چەپڵەی لێدا و بە بەلعامی گوت: «بۆ نەفرەتکردن لە دوژمنەکانم بانگم کردوویت، کەچی تۆ سێ جار داوای بەرەکەتت بۆ کردن، ");
INSERT INTO ckb_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","ئێستاش بگەڕێوە شوێنی خۆت، گوتم پاداشتێکی گەورەت دەکەم، بەڵام یەزدان ڕێگری لێ کردیت کە پاداشتەکەت وەربگریت.» ");
INSERT INTO ckb_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","بەلعامیش بە بالاقی گوت: «ئەی من بە نێردراوەکانتم نەگوت کە بۆ لای منت ناردبوون، ");
INSERT INTO ckb_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","”ئەگەر بالاق بە پڕی خانووەکەی زێڕ و زیوم پێبدات ناتوانم لە فەرمانی یەزدان دەربچم، بۆ ئەوەی لە خۆمەوە چاکەیەک یان خراپەیەک بکەم، ئەوەی یەزدان بیڵێت ئەوە دەڵێم؟“ ");
INSERT INTO ckb_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","ئێستاش وا من بۆ لای گەلەکەم بەڕێ دەکەوم، بەڵام وەرە با پێت بڵێم کە ئەم گەلە لە دوارۆژدا چی لە گەلەکەت دەکات.» ");
INSERT INTO ckb_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","ئیتر پەیامەکەی ڕاگەیاند و گوتی: «پەیامی بەلعامی کوڕی بەعۆر، پەیامی ئەو پیاوەی چاوی کراوەیە، ");
INSERT INTO ckb_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","پەیامی ئەوەی گوێی لە وشەکانی خودایە، کە زانینی هەیە لە هەرەبەرزەوە، ئەوەی خودای هەرە بەتوانا بینینی بۆ ئاشکرا دەکات، ئەوەی بەسەر ڕوودا دەکەوێت، بەڵام چاوی کراوەیە: ");
INSERT INTO ckb_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","«دەیبینم، بەڵام ئێستا نا، چاوم پێی دەکەوێت، بەڵام بەم نزیکانە نا. ئەستێرەیەک لە یاقوب دەردەکەوێت و داردەستێک لە ئیسرائیل هەڵدەستێت. ناوچەوانی مۆئاب دەشکێنێت، کاسەسەری هەموو نەوەی شیت تێکدەشکێنێت. ");
INSERT INTO ckb_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","ئەدۆم داگیر دەکرێت، سێعیری دوژمنیشی دەبێتە خاوەندار، بەڵام ئیسرائیل قارەمانیێتی دەنوێنێت. ");
INSERT INTO ckb_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","ئەوەی لە یاقوبەوەیە دەسەڵاتدار دەبێت، بەجێماوەکان لە شار لەناودەبات.» ");
INSERT INTO ckb_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","ئینجا بەلعام عەمالێقی بینی و پەیامەکەی ڕاگەیاند و گوتی: «عەمالێق یەکەمی نەتەوەکان بوو، بەڵام کۆتاییەکەی لەناوچوونە.» ");
INSERT INTO ckb_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","ئینجا قێنییەکانی بینی و پەیامەکەی پێ ڕاگەیاندن و گوتی: «نشینگەکەتان پتەوە و هێلانەکەتان لەناو تاشەبەردە، ");
INSERT INTO ckb_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","بەڵام ئەی قێنییەکان، ئێوە وێران دەبن، کاتێک ئەشوورییەکان بە دیلتان دەگرن.» ");
INSERT INTO ckb_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","ئیتر پەیامەکەی ڕاگەیاند و گوتی: «ئای کێ دەژیێت کاتێک خودا ئاوا دەکات، ");
INSERT INTO ckb_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","لەلای کەنارەکانی کیتیمەوە کەشتییەکان دێن و ئەشوور و عێبەر ژێردەستە دەکات، بەڵام ئەوانیش بۆ لەناوچوونن.» ");
INSERT INTO ckb_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","ئینجا بەلعام هەستا و بەڕێکەوت و گەڕایەوە شوێنی خۆی، بالاقیش بە ڕێگای خۆیدا ڕۆیشت. ");
INSERT INTO ckb_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","کاتێک ئیسرائیل لە شەتیم چادریان هەڵدا و گەل دەستیان بە بەدڕەوشتی کرد لەگەڵ کچانی مۆئاب، ");
INSERT INTO ckb_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","ئەوانیش گەلیان بانگهێشت کرد بۆ قوربانییە سەربڕدراوەکانی خوداوەندەکانیان. گەلیش خواردی و کڕنۆشی بۆ خوداوەندەکانیان برد. ");
INSERT INTO ckb_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","ئیسرائیل پەیوەست بوو بە بەعلی پەعۆرەوە، تووڕەیی یەزدانیش بەسەر ئیسرائیلدا جۆشا. ");
INSERT INTO ckb_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","یەزدان بە موسای فەرموو: «هەموو ڕابەرانی گەل ببە و بۆ یەزدان بەرامبەر بە خۆر هەڵیانبواسە، ئەوسا کوڵی تووڕەیی یەزدان لەسەر ئیسرائیل دادەمرکێتەوە.» ");
INSERT INTO ckb_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","موساش بە دادوەرانی ئیسرائیلی گوت: «هەر یەک لە ئێوە ئەو پیاوانەی خۆی بکوژێت کە پەیوەست بوونە بە بەعلی پەعۆرەوە.» ");
INSERT INTO ckb_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","لەو کاتەدا پیاوێک هات کە لە نەوەی ئیسرائیل بوو و کچێکی میدیانی هێنایە ناو کەسوکارەکەی، لەبەرچاوی موسا و هەموو کۆمەڵی نەوەی ئیسرائیل کە لەلای دەروازەی چادری چاوپێکەوتن دەگریان. ");
INSERT INTO ckb_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","کاتێک فینەحاسی کوڕی ئەلعازاری کوڕی هارونی کاهین ئەمەی بینی، لەنێو کۆمەڵەکە هەستا و دەستی دایە ڕمێک، ");
INSERT INTO ckb_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","بەدوای پیاوە ئیسرائیلییەکەدا چووە ناو چادرەکە، بە ڕمەکەی بە یەک جار سکی پیاوە ئیسرائیلییەکە و کچەکەشی بڕی. ئینجا دەردەکە لە نەوەی ئیسرائیل بڕایەوە. ");
INSERT INTO ckb_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","بەڵام ئەوانەی بە دەردەکە مردن بیست و چوار هەزار بوون. ");
INSERT INTO ckb_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","هەروەها یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","«فینەحاسی کوڕی ئەلعازاری کوڕی هارونی کاهین، تووڕەیی منی لەسەر نەوەی ئیسرائیل ڕەواندەوە. لەبەر ئەوەی دڵگەرم بوو بۆ شکۆمەندی من لەنێویان بەو جۆرەی کە من بۆ شکۆمەندی خۆم دڵگەرمم، نەوەی ئیسرائیلم بە دڵگەرمی خۆم لەناو نەبرد. ");
INSERT INTO ckb_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","لەبەر ئەوە پێی بڵێ ئەوەتا من پەیمانی ئاشتی خۆمی لەگەڵ دەبەستم. ");
INSERT INTO ckb_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","بۆ خۆی و بۆ نەوەکەی دوای خۆی دەبێتە پەیمانی کاهینیێتی هەتاهەتایی، لەبەر ئەوەی دڵگەرم بوو بۆ خودا و کەفارەتی بۆ نەوەی ئیسرائیل کرد.» ");
INSERT INTO ckb_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","ناوی ئەو پیاوە ئیسرائیلییەش کە لەگەڵ کچە میدیانییەکە کوژرا زیمریی کوڕی سالو بوو، گەورەی بنەماڵەیەک بوو لە شیمۆنییەکان، ");
INSERT INTO ckb_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","ناوی کچە میدیانییە کوژراوەکەش کۆزبیی کچی چوور بوو، ئەویش سەرۆکی هۆزێک بوو لە بنەماڵەیەکی میدیانی. ");
INSERT INTO ckb_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","«تەنگ بە میدیانییەکان هەڵبچنن و لێیان بدەن، ");
INSERT INTO ckb_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","چونکە ئەوان بە فریودانەکانیان تەنگیان پێ هەڵچنین، سەبارەت بە پەعۆر و کۆزبی خوشکیان، کچی سەرۆکێکی میدیان کە لە ڕۆژی دەردەکە بەهۆی پەعۆرەوە کوژرا.» ");
INSERT INTO ckb_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","لەدوای دەردەکە، یەزدان بە موسا و ئەلعازاری کوڕی هارونی کاهینی فەرموو: ");
INSERT INTO ckb_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","«ژمارەی هەموو کۆمەڵی نەوەی ئیسرائیل وەربگرە، لە گەنجی بیست ساڵ بەرەو سەرەوە، بەگوێرەی بنەماڵەکانیان، هەموو ئەوانەی لە ئیسرائیلدا دەتوانن بجەنگن.» ");
INSERT INTO ckb_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","ئینجا موسا و ئەلعازاری کاهین لە دەشتی مۆئاب لەسەر ڕووباری ئوردون بەرامبەر ئەریحا لەگەڵیاندا دوان و گوتیان: ");
INSERT INTO ckb_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","«سەرژمێری لە گەنجی بیست ساڵ بەرەو سەرەوە بکەن، وەک چۆن یەزدان فەرمانی بە موسا کرد.» نەوەی ئیسرائیلیش ئەوانەی لە خاکی میسر هاتنە دەرەوە ئەمانەن: ");
INSERT INTO ckb_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","نەوەی ڕەئوبێنی نۆبەرەی ئیسرائیل: بۆ حەنۆک خێڵی حەنۆکییەکان، بۆ پەڵو خێڵی پەڵووییەکان، ");
INSERT INTO ckb_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","بۆ حەسرۆن خێڵی حەسرۆنییەکان، بۆ کەرمی خێڵی کەرمییەکان. ");
INSERT INTO ckb_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","ئەمانە خێڵەکانی ڕەئوبێنییەکانن، تۆمارکراوەکانیان چل و سێ هەزار و حەوت سەد و سی کەس بوون. ");
INSERT INTO ckb_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","ئەلیابیش کوڕی پەڵو بوو، ");
INSERT INTO ckb_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","نەوەی ئەلیابیش نەموئێل و داتان و ئەبیرام، داتان و ئەبیرامیش ئەوانەن کە کۆمەڵەکەیان بانگکرد بۆ بەربەرەکانێی موسا و هارون، لە کۆمەڵی قۆرەح کاتێک بەربەرەکانێی یەزدانیان کرد. ");
INSERT INTO ckb_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","زەوی دەمی کردەوە و لەگەڵ قۆرەح هەڵیلووشین، کاتێک ئەو کۆمەڵە مردن، دوو سەد و پەنجا پیاو سووتان، ئەوان بوون بە پەند. ");
INSERT INTO ckb_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","بەڵام نەوەی قۆرەح نەفەوتان. ");
INSERT INTO ckb_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","نەوەی شیمۆن بەگوێرەی خێڵەکانیان: لە نەموئێل خێڵی نەموئێلییەکان، لە یامین خێڵی یامینییەکان، لە یاکین خێڵی یاکینییەکان، ");
INSERT INTO ckb_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","لە زەرەح خێڵی زەرەحییەکان، لە شائوول خێڵی شائوولییەکان. ");
INSERT INTO ckb_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","ئەمانە خێڵەکانی شیمۆنییەکانن، بیست و دوو هەزار و دوو سەد کەس بوون. ");
INSERT INTO ckb_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","نەوەی گاد بەگوێرەی خێڵەکانیان: لە چیفۆن خێڵی چیفۆنییەکان، لە حەگی خێڵی حەگییەکان، لە شونی خێڵی شونییەکان، ");
INSERT INTO ckb_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","لە ئۆزنی خێڵی ئۆزنییەکان، لە عێری خێڵی عێرییەکان، ");
INSERT INTO ckb_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","لە ئەرۆدی خێڵی ئەرۆدییەکان، لە ئەرئێلی خێڵی ئەرئێلییەکان. ");
INSERT INTO ckb_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","ئەمانە خێڵەکانی نەوەی گادن، بەگوێرەی ژمارەیان چل هەزار و پێنج سەد کەس بوون. ");
INSERT INTO ckb_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","ئێر و ئۆنان کوڕانی یەهودا بوون، بەڵام لە خاکی کەنعان مردن. ");
INSERT INTO ckb_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","نەوەی یەهودا بەگوێرەی خێڵەکانیان: لە شالەح خێڵی شالەحییەکان، لە پێرێز خێڵی پێرێزییەکان، لە زەرەح خێڵی زەرەحییەکان، ");
INSERT INTO ckb_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","نەوەکانی پێرێزیش: لە حەسرۆن خێڵی حەسرۆنییەکان، لە حامول خێڵی حامولییەکان. ");
INSERT INTO ckb_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","ئەمانە خێڵەکانی یەهودان، بەگوێرەی ژمارەیان حەفتا و شەش هەزار و پێنج سەد کەس بوون. ");
INSERT INTO ckb_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","نەوەی یەساخار بەگوێرەی خێڵەکانیان: لە تۆلاع خێڵی تۆلاعییەکان، لە پوڤە خێڵی پوڤەییەکان، ");
INSERT INTO ckb_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","لە یاشوڤ خێڵی یاشوڤییەکان، لە شیمرۆن خێڵی شیمرۆنییەکان. ");
INSERT INTO ckb_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","ئەمانە خێڵەکانی یەساخارن، بەگوێرەی ژمارەیان شەست و چوار هەزار و سێ سەد کەس بوون. ");
INSERT INTO ckb_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","نەوەی زەبولون بەگوێرەی خێڵەکانیان: لە سەرەد خێڵی سەرەدییەکان، لە ئێلۆن خێڵی ئێلۆنییەکان، لە یەحلئێل خێڵی یەحلئێلییەکان. ");
INSERT INTO ckb_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","ئەمانە خێڵەکانی زەبولونییەکانن، بەگوێرەی ژمارەیان شەست هەزار و پێنج سەد کەس بوون. ");
INSERT INTO ckb_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","نەوەی یوسف بەگوێرەی خێڵەکانی مەنەشە و ئەفرایم: ");
INSERT INTO ckb_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","نەوەی مەنەشە: لە ماکیر خێڵی ماکیرییەکان، ماکیر باوکی گلعاد بوو، لە گلعاد خێڵی گلعادییەکان. ");
INSERT INTO ckb_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","ئەمانە نەوەی گلعادن: لە ئیعەزەر خێڵی ئیعەزەرییەکان؛ لە حێلەق خێڵی حێلەقییەکان؛ ");
INSERT INTO ckb_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","لە ئەسریێل خێڵی ئەسریێلییەکان؛ لە شەخەم خێڵی شەخەمییەکان؛ ");
INSERT INTO ckb_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","لە شەمیداع خێڵی شەمیداعییەکان؛ لە حێفەر خێڵی حێفەرییەکان. ");
INSERT INTO ckb_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","بەڵام سەلۆفحادی کوڕی حێفەر کوڕی نەبوو، تەنها کچ و ناوی کچەکانی سەلۆفحاد مەحلە و نۆعا و حۆگلە و میلکە و تیرزە بوو. ");
INSERT INTO ckb_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","ئەمانە خێڵەکانی مەنەشەن و تۆمارکراوەکانیان پەنجا و دوو هەزار و حەوت سەد کەس بوون. ");
INSERT INTO ckb_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","ئەمانەش نەوەی ئەفرایمن بەگوێرەی خێڵەکانیان: لە شوتەلەح خێڵی شوتەلەحییەکان، لە بەکەر خێڵی بەکەرییەکان، لە تەحەن خێڵی تەحەنییەکان، ");
INSERT INTO ckb_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","ئەمانەش نەوەی شوتەلەحن: لە عیران خێڵی عیرانییەکان. ");
INSERT INTO ckb_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","ئەمانە خێڵەکانی نەوەی ئەفرایمن، بەگوێرەی ژمارەیان سی و دوو هەزار و پێنج سەد کەس بوون. ئەمانە نەوەی یوسفن بەگوێرەی خێڵەکانیان. ");
INSERT INTO ckb_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","نەوەی بنیامین بەگوێرەی خێڵەکانیان: لە بەلەع خێڵی بەلەعییەکان، لە ئەشبێل خێڵی ئەشبێلییەکان، لە ئەحیرام خێڵی ئەحیرامییەکان. ");
INSERT INTO ckb_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","لە شوفام خێڵی شوفامییەکان، لە حوفام خێڵی حوفامییەکان. ");
INSERT INTO ckb_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","نەوەی بەلەعیش ئەرد و نەعمان بوون: لە ئەرد خێڵی ئەردییەکان و لە نەعمان خێڵی نەعمانییەکان. ");
INSERT INTO ckb_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","ئەمانە نەوەی بنیامینن بەگوێرەی خێڵەکانیان و تۆمارکراوەکانیان چل و پێنج هەزار و شەش سەد کەس بوون. ");
INSERT INTO ckb_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","ئەمانە نەوەی دانن بەگوێرەی خێڵەکانیان: لە شوحام خێڵی شوحامییەکان. ئەمە خێڵەکانی دانە بەگوێرەی خێڵەکانیان، ");
INSERT INTO ckb_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","هەموو خێڵەکانی شوحامییەکان بەگوێرەی ژمارەیان شەست و چوار هەزار و چوار سەد کەس بوون. ");
INSERT INTO ckb_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","نەوەی ئاشێر بەگوێرەی خێڵەکانیان: لە یمنە خێڵی یمنییەکان، لە یەشڤی خێڵی یەشڤییەکان، لە بەریعە خێڵی بریعییەکان، ");
INSERT INTO ckb_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","لە نەوەی بەریعە: لە حەڤەر خێڵی حەڤەرییەکان، لە مەلکیێل خێڵی مەلکیێلییەکان، ");
INSERT INTO ckb_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","کچەکەی ئاشێریش ناوی سەرەح بوو. ");
INSERT INTO ckb_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","ئەمانە خێڵەکانی نەوەی ئاشێرن، بەگوێرەی ژمارەیان پەنجا و سێ هەزار و چوار سەد کەس بوون. ");
INSERT INTO ckb_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","نەوەی نەفتالی بەگوێرەی خێڵەکانیان: لە یەحزئێل خێڵی یەحزئێلییەکان، لە گۆنی خێڵی گۆنییەکان، ");
INSERT INTO ckb_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","لە یێچەر خێڵی یێچەرییەکان، لە شلێم خێڵی شلێمییەکان. ");
INSERT INTO ckb_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","ئەمانە خێڵەکانی نەفتالین بەگوێرەی خێڵەکانیان و تۆمارکراوەکانیان چل و پێنج هەزار و چوار سەد کەس بوون. ");
INSERT INTO ckb_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","ئەمانە تۆمارکراوەکانن لە نەوەی ئیسرائیل، شەش سەد و یەک هەزار و حەوت سەد و سی. ");
INSERT INTO ckb_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","«خاکەکە بۆ ئەمانە بەگوێرەی ژمارەی ناوەکان بە میرات دابەش دەکەیت. ");
INSERT INTO ckb_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","بۆ هۆزە گەورەکان میراتیان زۆر دەکەیت و بۆ هۆزە بچووکەکان میراتیان کەم دەکەیت، هەریەکە بەگوێرەی تۆمارکراوەکانی میراتی دەدرێتێ، ");
INSERT INTO ckb_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","بەڵام خاکەکە بە تیروپشک دابەش دەکەیت، بەگوێرەی ناوی هۆزەکانی باوکانیان بە میراتی دەگرن، ");
INSERT INTO ckb_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","لەنێو کۆمەڵەی گەورە و بچووک بەگوێرەی تیروپشک میراتەکەیان بۆ دابەش دەکرێت.» ");
INSERT INTO ckb_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","ئەمانەش تۆمارکراوەکانن لە لێڤییەکان، بەگوێرەی خێڵەکانیان: بۆ گێرشۆن خێڵی گێرشۆنییەکان، بۆ قەهات خێڵی قەهاتییەکان، بۆ مەراری خێڵی مەرارییەکان. ");
INSERT INTO ckb_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","ئەمە خێڵەکانی لێڤییە: خێڵی لیبنییەکان، خێڵی حەبرۆنییەکان، خێڵی مەحلییەکان، خێڵی موشییەکان، خێڵی قۆرەحییەکان. عەمرام لە ڕەچەڵەکی قەهات بوو. ");
INSERT INTO ckb_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","ژنەکەی عەمرامیش ناوی یۆخەڤەد بوو، لە نەوەی لێڤی بوو، لە خێزانی لێڤییەکیش لە میسر لەدایک بوو. لە عەمرام هارون و موسا و مریەمی خوشکیانی بوو. ");
INSERT INTO ckb_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","هارونیش باوکی ناداب و ئەبیهو و ئەلعازار و ئیتامار بوو. ");
INSERT INTO ckb_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","بەڵام ناداب و ئەبیهو کاتێک ئاگرێکی نامۆیان لەبەردەم یەزدان پێشکەش کرد مردن. ");
INSERT INTO ckb_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","تۆمارکراوەکانی لێڤییەکان بیست و سێ هەزار کەس بوون، هەموو نێرینەیەک لە کۆرپەی یەک مانگی بەرەو سەرەوە، چونکە لەگەڵ نەوەی ئیسرائیلدا تۆمار نەکران، لەبەر ئەوەی لەنێو نەوەی ئیسرائیلدا میراتیان پێنەدرا. ");
INSERT INTO ckb_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","ئەمانە بوون کە موسا و ئەلعازاری کاهین تۆماریان کردن، کاتێک نەوەی ئیسرائیلیان لە دەشتی مۆئاب لەسەر ڕووباری ئوردون بەرامبەر ئەریحا تۆمار کرد. ");
INSERT INTO ckb_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","ئەمانەش کەسیان تێدا نەبوو لەوانەی موسا و هارونی کاهین تۆماریان کردن، کاتێک نەوەی ئیسرائیلیان لە چۆڵەوانی سینادا تۆمار کرد. ");
INSERT INTO ckb_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","لەبەر ئەوەی یەزدان پێی فەرموون، «لە چۆڵەوانیدا دەمرن،» ئیتر کەسیان لێ نەمایەوە، تەنها کالێبی کوڕی یەفونە و یەشوعی کوڕی نون نەبێت. ");
INSERT INTO ckb_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","کچانی سەلۆفحادی کوڕی حێفەر کوڕی گلعاد کوڕی ماکیر کوڕی مەنەشە لە خێڵەکانی مەنەشەی کوڕی یوسف هاتنە پێش. ئەمەش ناوی کچەکانییەتی: مەحلە و نۆعا و حۆگلە و میلکە و تیرزە، ");
INSERT INTO ckb_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","لەبەردەم موسا و ئەلعازاری کاهین و سەرۆکەکان و هەموو کۆمەڵ لەلای دەروازەی چادری چاوپێکەوتن وەستان و گوتیان: ");
INSERT INTO ckb_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","«باوکمان لە بیابان مرد و لەو کۆمەڵەدا نەبوو کە لەگەڵ قۆرەح لە دژی یەزدان کۆبوونەوە، بەڵکو بە گوناهی خۆی مرد و هیچ کوڕی نەبوو. ");
INSERT INTO ckb_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","بۆچی ناوی باوکمان لەنێو خێڵەکەی بسڕێتەوە لەبەر ئەوەی کوڕی نییە؟ لەنێو برایانی باوکمان موڵکمان بدەرێ.» ");
INSERT INTO ckb_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","موساش داواکارییەکەی ئەوانی بردە بەردەم یەزدان. ");
INSERT INTO ckb_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","جا یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","«کچانی سەلۆفحاد ڕاست دەڵێن. تۆش لەنێو برایانی باوکیان موڵکی میراتیان دەدەیتێ و میراتی باوکیان دەدرێتە ئەوان. ");
INSERT INTO ckb_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","«بە نەوەی ئیسرائیلیش دەڵێیت: ”هەر پیاوێک مرد و کوڕی نەبوو میراتەکەی بۆ کچی دەبێت، ");
INSERT INTO ckb_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","ئەگەر کچیشی نەبوو، میراتەکەی دەدەنە براکانی، ");
INSERT INTO ckb_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","ئەگەر براشی نەبوو ئەوا میراتەکەی دەدەنە برایانی باوکی، ");
INSERT INTO ckb_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","ئەگەر باوکیشی برای نەبوو ئەوا میراتەکەی دەدەنە نزیکترین کەسی لە خێڵەکەی و ئەو دەبێتە میراتگری. ئەمە بۆ نەوەی ئیسرائیل بووە فەرزێکی یاسایی، هەروەک یەزدان فەرمانی بە موسا کرد.“» ");
INSERT INTO ckb_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","ئینجا یەزدان بە موسای فەرموو: «بڕۆ سەر ئەم چیایە لە زنجیرە چیای عەڤاریم و تەماشای ئەو خاکە بکە کە بە نەوەی ئیسرائیلم داوە. ");
INSERT INTO ckb_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","کاتێک تەماشات کرد تۆش دەچیتە ڕیزی گەلەکەت، وەک هارونی برات چووە ڕیزەوە، ");
INSERT INTO ckb_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","چونکە لە چۆڵەوانی چن کاتێک کۆمەڵەکە یاخی بوون، ئێوە هەردووکتان قسەتان شکاندم و منتان لەلای ئەوان پیرۆز نیشان نەدا.» (ئەو شوێنە ئاوی مەریبای قادێشە لە چۆڵەوانی چن بوو.) ");
INSERT INTO ckb_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","موسا بە یەزدانی گوت: ");
INSERT INTO ckb_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","«ئەی یەزدان، ئەی ئەو خودایەی ژیان بە ئادەمیزاد دەبەخشیت، پیاوێک لەسەر کۆمەڵەکە دابنێ ");
INSERT INTO ckb_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","بەڕێوەیان ببات و لە شەڕدا ڕابەرایەتییان بکات، هەتا کۆمەڵی یەزدان وەک مەڕی بێ شوانیان لێ نەیێت.» ");
INSERT INTO ckb_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","یەزدانیش بە موسای فەرموو: «یەشوعی کوڕی نون ببە، پیاوێکە ڕۆحی تێدایە و دەستی لەسەر دابنێ. ");
INSERT INTO ckb_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","لەبەردەم ئەلعازاری کاهین و هەموو کۆمەڵەکە ڕای بگرە و لەبەرچاویان ئەرکی پێ بسپێرە. ");
INSERT INTO ckb_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","هەندێک لە دەسەڵاتی خۆتی بدەرێ هەتا هەموو کۆمەڵی ئیسرائیل گوێڕایەڵی بن. ");
INSERT INTO ckb_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","ئەو لەبەردەم ئەلعازاری کاهین ڕادەوەستێت، لەبەردەم یەزدان بەپێی حوکمی ئوریم بۆی دەپرسێت. بە قسەی ئەو دەردەچن و بە قسەی ئەو دێنە ژوورەوە، ئەو و هەموو کۆمەڵی ئیسرائیل لەگەڵی.» ");
INSERT INTO ckb_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","موسا هەروەک یەزدان فەرمانی پێ کرد، ئاوای کرد. یەشوعی برد و لەبەردەم ئەلعازاری کاهین و لەبەردەم هەموو کۆمەڵەکە ڕایگرت، ");
INSERT INTO ckb_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","دەستی لەسەر دانا و ئەرکی پێ سپارد، هەروەک یەزدان لە ڕێگەی موساوە فەرمانی دا. ");
INSERT INTO ckb_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","هەروەها یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","«فەرمان بە نەوەی ئیسرائیل بکە و پێیان بڵێ: ”قوربانی من، ئەو بۆنەی پێم خۆشە، ئاگاداربن کە لە کاتی خۆی خۆراکم بە قوربانی بە ئاگر پێشکەش بکەن.“ ");
INSERT INTO ckb_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","پێشیان بڵێ: ”ئەمە ئەو قوربانی بە ئاگرەیە کە ڕۆژانە بۆ یەزدان پێشکەشی دەکەن: دوو بەرخی نێری یەک ساڵەی ساغ، قوربانی سووتاندنی بەردەوام. ");
INSERT INTO ckb_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","یەکێک لە بەرخەکان لە بەیانی پێشکەش بکە و بەرخی دووەمیش لە کاتی خۆرئاوابوون. ");
INSERT INTO ckb_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","لەگەڵ دەیەکی ئێفەیەک لە باشترین ئارد بۆ پێشکەشکراوی دانەوێڵە بە چارەکە هەینێک زەیتی زەیتوونی گوشراو شێلرابێت، ");
INSERT INTO ckb_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","قوربانی سووتاندنی بەردەوام، ئەوەی لە شاخی سینا کراوە، بۆنێکی خۆشە و قوربانی بە ئاگرە بۆ یەزدان، ");
INSERT INTO ckb_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","لەگەڵ شەرابە پێشکەشکراوەکەشی، چارەکە هەینێک مەی بۆ بەرخی یەکەم، لە پیرۆزگا بۆ یەزدان پێشکەشی بکە. ");
INSERT INTO ckb_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","هەروەها بەرخی دووەمیش لە کاتی خۆرئاوابووندا پێشکەش بکە، لەگەڵ پێشکەشەکراوی دانەوێڵەکەی و شەرابە پێشکەشکراوەکەی، وەک ئەوەی لە بەیانیدا کردووتە، قوربانی بە ئاگرە، ئەو بۆنەی یەزدان پێی خۆشە. ");
INSERT INTO ckb_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","«”لە ڕۆژی شەممە دوو بەرخی یەک ساڵەی ساغ پێشکەش بکەن لەگەڵ دوو دەیەکی ئێفەیەک لە باشترین ئاردی بە زەیت شێلراو وەک پێشکەشکراوێکی دانەوێڵە لەگەڵ شەرابە پێشکەشکراوەکەی، کە ئەمەش ");
INSERT INTO ckb_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","قوربانی سووتاندنی هەموو ڕۆژێکی شەممەیە، سەرەڕای قوربانی سووتاندنی بەردەوام و شەرابە پێشکەشکراوەکەی. ");
INSERT INTO ckb_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","«”لە دەستپێکی هەموو مانگێکدا قوربانی سووتاندن بۆ یەزدان بکەن، دوو جوانەگا و بەرانێک و حەوت بەرخی نێری یەک ساڵەی ساغ، ");
INSERT INTO ckb_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","لەگەڵ سێ دەیەکی ئێفەیەک لە باشترین ئاردی بە زەیت شێلراو، پێشکەشکراوێکی دانەوێڵەیە بۆ هەر جوانەگایەک و دوو دەیەکی ئێفەیەک لە باشترین ئاردی بە زەیت شێلراو، پێشکەشکراوێکی دانەوێڵەیە بۆ هەر بەرانێک. ");
INSERT INTO ckb_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","یەک دەیەکی ئێفەیەک لە باشترین ئاردی بە زەیت شێلراو، پێشکەشکراوێکی دانەوێڵەیە بۆ هەر بەرخێک، قوربانی سووتاندنە، ئەو بۆنەی یەزدان پێی خۆشە، قوربانی بە ئاگرە بۆ یەزدان. ");
INSERT INTO ckb_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","شەرابە پێشکەشکراوەکەشیان نیو هەین بۆ جوانەگا و سێیەکی هەین بۆ بەران و چارەکە هەینێک بۆ بەرخ. ئەمە قوربانی سووتاندنە لە دەستپێکی هەموو مانگەکانی ساڵ. ");
INSERT INTO ckb_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","سەرەڕای قوربانی سووتاندنی بەردەوام لەگەڵ شەرابە پێشکەشکراوەکەی، هەروەها گیسکێکی نێریش بۆ قوربانی گوناه بۆ یەزدان پێشکەش بکرێت. ");
INSERT INTO ckb_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","«”لە چواردەی مانگی یەک، جەژنی پەسخەیە بۆ یەزدان، ");
INSERT INTO ckb_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","لە ڕۆژی پازدەی ئەم مانگەدا جەژنە، حەوت ڕۆژ نانی فەتیرە بخۆن. ");
INSERT INTO ckb_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","لە ڕۆژی یەکەم کۆبوونەوەی پیرۆزبوون ببەستن، هیچ کارێکی ئاسایی مەکەن. ");
INSERT INTO ckb_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","قوربانی بە ئاگر، قوربانی سووتاندن بۆ یەزدان پێشکەش بکەن، دوو جوانەگا و بەرانێک و حەوت بەرخی نێری یەک ساڵەی ساغ لەلایەن ئێوەوە بێت. ");
INSERT INTO ckb_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","پێشکەشکراوی دانەوێڵەشیان لە باشترین ئاردی بە زەیت شێلراو، سێ دەیەکی ئێفەیەک بۆ هەر جوانەگایەک، دوو دەیەک بۆ هەر بەرانێک، ");
INSERT INTO ckb_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","دەیەکێک بۆ هەر بەرخێک لە حەوت بەرخەکە بکە. ");
INSERT INTO ckb_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","گیسکێکی نێریش قوربانی گوناه بێت بۆ کەفارەتکردن بۆتان، ");
INSERT INTO ckb_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","سەرەڕای قوربانی سووتاندنی بەیانییان کە بۆ قوربانی سووتاندنی بەردەوام دەیکەن. ");
INSERT INTO ckb_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","بە هەمان شێواز بۆ ماوەی حەوت ڕۆژ هەموو ڕۆژێک ئاوا بکەن، خۆراک پێشکەش بکەن، قوربانی بە ئاگرە، ئەو بۆنەی یەزدان پێی خۆشە، سەرەڕای قوربانی سووتاندنی بەردەوام لەگەڵ شەرابە پێشکەشکراوەکەی. ");
INSERT INTO ckb_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","لە ڕۆژی حەوتەمیش کۆبوونەوەی پیرۆزبوون ببەستن، هیچ کارێکی ئاسایی مەکەن. ");
INSERT INTO ckb_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","«”لە ڕۆژی یەکەمین بەرهەم، کاتێک پێشکەشکراوێکی دانەوێڵەیی نوێ بۆ یەزدان پێشکەش دەکەن، لە جەژنی هەفتەکانتان کۆبوونەوەی پیرۆزبوون ببەستن، هیچ کارێکی ئاسایی مەکەن. ");
INSERT INTO ckb_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","قوربانی سووتاندن پێشکەش بکەن، بۆ ئەو بۆنەی یەزدان پێی خۆشە، دوو جوانەگا و بەرانێک و حەوت بەرخی نێری یەک ساڵە، ");
INSERT INTO ckb_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","هەروەها پێشکەشکراوی دانەوێڵەشیان لە باشترین ئاردی بە زەیت شێلراو، سێ دەیەکی ئێفەیەک بۆ جوانەگا، دوو دەیەک بۆ بەران، ");
INSERT INTO ckb_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","دەیەکێک بۆ هەر بەرخێک لە حەوت بەرخەکە. ");
INSERT INTO ckb_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","گیسکێکی نێریش بۆ کەفارەتکردن بۆتان. ");
INSERT INTO ckb_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","سەرەڕای قوربانی سووتاندنی بەردەوام و پێشکەشکراوی دانەوێڵەکە بیکەن، دڵنیا بن لەوەی ئاژەڵەکان ساغن و لەگەڵ شەرابە پێشکەشکراوەکەیان بیکەن. ");
INSERT INTO ckb_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","«”لە یەکی مانگی حەوت، کۆبوونەوەی پیرۆزبوون دەبەستن، هیچ کارێکی ئاسایی ناکەن، بۆتان دەبێتە ڕۆژی دەنگی کەڕەنا. ");
INSERT INTO ckb_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","قوربانی سووتاندنێک دەکەن بۆ ئەو بۆنەی یەزدان پێی خۆشە، یەک جوانەگا و یەک بەران و حەوت بەرخی نێری یەک ساڵەی ساغ، ");
INSERT INTO ckb_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","هەروەها پێشکەشکراوی دانەوێڵەشیان لە باشترین ئاردی بە زەیت شێلراو، سێ دەیەکی ئێفەیەک بۆ جوانەگاکە و دوو دەیەک بۆ بەرانەکە و ");
INSERT INTO ckb_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","دەیەکێک بۆ هەر بەرخێک لە حەوت بەرخەکە. ");
INSERT INTO ckb_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","گیسکێکی نێریش بۆ قوربانی گوناه بۆ کەفارەتکردن بۆتان، ");
INSERT INTO ckb_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","سەرەڕای قوربانی سووتاندنی سەرەمانگان و ڕۆژانە، لەگەڵ پێشکەشکراوی دانەوێڵەکەیان و شەرابە پێشکەشکراوەکەیان وەک نەریتەکەیان، قوربانی بە ئاگرن بۆ یەزدان، ئەو بۆنەیە کە یەزدان پێی خۆشە. ");
INSERT INTO ckb_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","«”لە ڕۆژی دەیەمی ئەم مانگی حەوتەدا کۆبوونەوەی پیرۆزبوون دەبەستن و گیانی خۆتان زەلیل دەکەن، هیچ کارێک ناکەن. ");
INSERT INTO ckb_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","قوربانی سووتاندن بۆ یەزدان پێشکەش دەکەن، ئەو بۆنەی پێی خۆشە، یەک جوانەگا و یەک بەران و حەوت بەرخی نێری یەک ساڵەی ساغ بن، لەلایەن ئێوەوە دەبێت. ");
INSERT INTO ckb_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","پێشکەشکراوی دانەوێڵەشیان لە باشترین ئاردی بە زەیت شێلراو، سێ دەیەکی ئێفەیەک بۆ جوانەگا و دوو دەیەک بۆ بەران و ");
INSERT INTO ckb_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","دەیەکێک بۆ هەر بەرخێک لە حەوت بەرخەکە. ");
INSERT INTO ckb_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","گیسکێکی نێریش بۆ قوربانی گوناه، سەرەڕای قوربانی گوناه بۆ کەفارەتکردن و قوربانی سووتاندنی بەردەوام و پێشکەشکراوی دانەوێڵەکەی لەگەڵ شەرابە پێشکەشکراوەکەیان. ");
INSERT INTO ckb_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","«”لە ڕۆژی پازدەی مانگی حەوتیش کۆبوونەوەی پیرۆزبوون دەبەستن، هیچ کارێکی ئاسایی ناکەن و حەوت ڕۆژ بۆ یەزدان دەیکەن بە جەژن. ");
INSERT INTO ckb_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","قوربانی سووتاندنیش پێشکەش دەکەن، قوربانی بە ئاگر، ئەو بۆنەی یەزدان پێی خۆشە، سێزدە جوانەگا و دوو بەران و چواردە بەرخی نێری یەک ساڵەی ساغ لەلایەن ئێوەوە دەبێت. ");
INSERT INTO ckb_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","پێشکەشکراوی دانەوێڵەشیان لە باشترین ئاردی بە زەیت شێلراو، سێ دەیەکی ئێفەیەک بۆ هەریەک لە سێزدە جوانەگاکە و دوو دەیەک بۆ هەریەک لە دوو بەرانەکە. ");
INSERT INTO ckb_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","دەیەکێک بۆ هەریەک لە چواردە بەرخەکە. ");
INSERT INTO ckb_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","هەروەها گیسکێکی نێر بۆ قوربانی گوناه، سەرەڕای قوربانی سووتاندنی بەردەوام لەگەڵ پێشکەشکراوی دانەوێڵەکەی و شەرابە پێشکەشکراوەکەی. ");
INSERT INTO ckb_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","«”لە ڕۆژی دووەم دوازدە جوانەگا و دوو بەران و چواردە بەرخی نێری یەک ساڵەی ساغ ئامادە بکەن. ");
INSERT INTO ckb_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","لەگەڵ جوانەگاکان و بەرانەکان و بەرخەکان، پێشکەشکراوی دانەوێڵەیان و شەرابی پێشکەشکراویان ئامادە بکەن، بەگوێرەی ژمارەیان وەک نەریتەکەیان. ");
INSERT INTO ckb_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","گیسکێکی نێریش بۆ قوربانی گوناه، سەرەڕای قوربانی سووتاندنی بەردەوام و پێشکەشکراوی دانەوێڵەکەی لەگەڵ شەرابە پێشکەشکراوەکەیان. ");
INSERT INTO ckb_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","«”لە ڕۆژی سێیەم یازدە جوانەگا و دوو بەران و چواردە بەرخی نێری یەک ساڵەی ساغ ئامادە بکەن. ");
INSERT INTO ckb_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","لەگەڵ جوانەگاکان و بەرانەکان و بەرخەکان، پێشکەشکراوی دانەوێڵەیان و شەرابی پێشکەشکراویان ئامادە بکەن، بەگوێرەی ژمارەیان وەک نەریتەکەیان. ");
INSERT INTO ckb_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","هەروەها گیسکێکی نێریش بۆ قوربانی گوناه، سەرەڕای قوربانی سووتاندنی بەردەوام لەگەڵ پێشکەشکراوی دانەوێڵەکەی و شەرابە پێشکەشکراوەکەی. ");
INSERT INTO ckb_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","«”لە ڕۆژی چوارەم دە جوانەگا و دوو بەران و چواردە بەرخی نێری یەک ساڵەی ساغ ئامادە بکەن. ");
INSERT INTO ckb_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","لەگەڵ جوانەگاکان و بەرانەکان و بەرخەکان، پێشکەشکراوی دانەوێڵەیان و شەرابی پێشکەشکراویان ئامادە بکەن، بەگوێرەی ژمارەیان وەک نەریتەکەیان. ");
INSERT INTO ckb_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","هەروەها گیسکێکی نێریش بۆ قوربانی گوناه، سەرەڕای قوربانی سووتاندنی بەردەوام لەگەڵ پێشکەشکراوی دانەوێڵەکەی و شەرابە پێشکەشکراوەکەی. ");
INSERT INTO ckb_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","«”لە ڕۆژی پێنجەم نۆ جوانەگا و دوو بەران و چواردە بەرخی نێری یەک ساڵەی ساغ ئامادە بکەن. ");
INSERT INTO ckb_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","لەگەڵ جوانەگاکان و بەرانەکان و بەرخەکان، پێشکەشکراوی دانەوێڵەیان و شەرابی پێشکەشکراویان ئامادە بکەن، بەگوێرەی ژمارەیان هەروەک نەریتەکەیان. ");
INSERT INTO ckb_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","گیسکێکی نێریش بۆ قوربانی گوناه، سەرەڕای قوربانی سووتاندنی بەردەوام لەگەڵ پێشکەشکراوی دانەوێڵەکەی و شەرابە پێشکەشکراوەکەی. ");
INSERT INTO ckb_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","«”لە ڕۆژی شەشەم هەشت جوانەگا و دوو بەران و چواردە بەرخی نێری یەک ساڵەی ساغ ئامادە بکەن. ");
INSERT INTO ckb_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","لەگەڵ جوانەگاکان و بەرانەکان و بەرخەکان، پێشکەشکراوی دانەوێڵەیان و شەرابی پێشکەشکراویان ئامادە بکەن، بەگوێرەی ژمارەیان وەک نەریتەکەیان. ");
INSERT INTO ckb_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","هەروەها گیسکێکی نێریش بۆ قوربانی گوناه، سەرەڕای قوربانی سووتاندنی بەردەوام لەگەڵ پێشکەشکراوی دانەوێڵەکەی و شەرابە پێشکەشکراوەکەی. ");
INSERT INTO ckb_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","«”لە ڕۆژی حەوتەم حەوت جوانەگا و دوو بەران و چواردە بەرخی نێری یەک ساڵەی ساغ ئامادە بکەن. ");
INSERT INTO ckb_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","لەگەڵ جوانەگاکان و بەرانەکان و بەرخەکان، پێشکەشکراوی دانەوێڵەیان و شەرابی پێشکەشکراویان ئامادە بکەن، بەگوێرەی ژمارەیان وەک نەریتەکەیان. ");
INSERT INTO ckb_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","هەروەها گیسکێکی نێریش بۆ قوربانی گوناه، سەرەڕای قوربانی سووتاندنی بەردەوام لەگەڵ پێشکەشکراوی دانەوێڵەکەی و شەرابە پێشکەشکراوەکەی. ");
INSERT INTO ckb_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","«”لە ڕۆژی هەشتەم ئاهەنگی کۆتایی دەگێڕن، هیچ کارێکی ئاسایی ناکەن. ");
INSERT INTO ckb_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","قوربانی سووتاندن پێشکەش دەکەن، قوربانی بە ئاگر، ئەو بۆنەی یەزدان پێی خۆشە، یەک جوانەگا و یەک بەران و حەوت بەرخی نێری یەک ساڵەی ساغ، ");
INSERT INTO ckb_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","پێشکەشکراوی دانەوێڵەشیان و شەرابی پێشکەشکراویان بۆ جوانەگا و بەران و بەرخەکان بەگوێرەی ژمارەیان وەک نەریتەکەیان، ");
INSERT INTO ckb_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","گیسکێکی نێریش بۆ قوربانی گوناه، سەرەڕای قوربانی سووتاندنی بەردەوام لەگەڵ پێشکەشکراوی دانەوێڵەکەی و شەرابە پێشکەشکراوەکەی. ");
INSERT INTO ckb_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","«”لە جەژنەکانتان، سەرەڕای نەزر و بەخشینە ئازادەکانتان، ئەمانە بۆ یەزدان پێشکەش دەکەن: قوربانی سووتاندن و پێشکەشکراوی دانەوێڵە و شەرابی پێشکەشکراو و قوربانی هاوبەشی.“» ");
INSERT INTO ckb_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","موسا بەگوێرەی هەموو ئەوەی یەزدان فەرمانی پێ کرد، لەگەڵ نەوەی ئیسرائیلدا دوا. ");
INSERT INTO ckb_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","هەروەها موسا بە سەرۆک هۆزەکانی نەوەی ئیسرائیلی گوت: «ئەمە ئەو شتەیە کە یەزدان فەرمانی پێی کردووە، ");
INSERT INTO ckb_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","ئەگەر پیاوێک نەزرێکی بۆ یەزدان کرد یان سوێندی خوارد بۆ پابەندبوون بە شتێک، با قسەی خۆی نەشکێنێت و بەگوێرەی هەموو ئەوەی گوتوویەتی ئاوا بکات. ");
INSERT INTO ckb_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","«بەڵام ئافرەت ئەگەر نەزرێکی بۆ یەزدان کرد و بە شتێک خۆی پابەند کرد، لە ماڵی باوکی، لە کاتی کچێنی و ");
INSERT INTO ckb_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","باوکی گوێی لە نەزرەکەی و ئەو شتە بوو کە خۆی پێ پابەند کردووە، ئەگەر خۆی لێ بێدەنگ کرد، ئەوا هەموو نەزرەکانی و هەموو ئەو شتانەی خۆی پێ پابەند کردووە دەچەسپێت. ");
INSERT INTO ckb_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","بەڵام ئەگەر باوکی لە ڕۆژی بیستنی نەیهێشت، ئەوا هەموو نەزر و ئەو شتانەی خۆی پێ پابەند کردووە ناچەسپێت، یەزدانیش لێی خۆشدەبێت، چونکە باوکی نەیهێشتووە. ");
INSERT INTO ckb_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","«ئەگەر شووی کرد دوای ئەوەی نەزرێکی کرد یان شتێکی بە دەمدا هات کە خۆی پێ پابەند دەکات و ");
INSERT INTO ckb_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","مێردەکەی بیستی و لە ڕۆژی بیستنەکەی بێدەنگ بوو، ئەوا نەزرەکانی دەچەسپێت و ئەو شتانەش کە خۆی پێ پابەند کردووە دەچەسپێت. ");
INSERT INTO ckb_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","بەڵام ئەگەر مێردەکەی لە کاتی بیستنی ئەوەدا ڕێگەی نەدا، ئەوا نەزرەکەی بەتاڵ دەبێتەوە، هەروەها ئەو شتەش بەتاڵ دەبێتەوە کە بە دەمیدا هاتووە و خۆی پێ پابەند کردبوو، یەزدانیش لێی خۆشدەبێت. ");
INSERT INTO ckb_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","«بەڵام نەزری بێوەژن یان تەڵاقدراو، ئەوا هەموو ئەوەی خۆی پێ پابەند دەکات لەسەری دەچەسپێت. ");
INSERT INTO ckb_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","«بەڵام ئەگەر ژنێک لە ماڵی مێردی نەزری کرد و خۆی بە سوێند بە شتێکەوە پابەند کرد، ");
INSERT INTO ckb_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","مێردەکەی بیستی و بێدەنگ بوو، ڕێی لێ نەگرت، ئەوا هەموو نەزرەکانی دەچەسپێن و هەموو ئەو شتانەی خۆی پێ پابەند کردووە دەچەسپێت. ");
INSERT INTO ckb_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","بەڵام ئەگەر مێردەکەی لە ڕۆژی بیستنی بەتاڵی کردەوە، ئەوا هەرچی گوتوویەتی لە نەزر و پابەندبوونەکانی ناچەسپێن، چونکە مێردەکەی بەتاڵی کردووەتەوە، یەزدانیش لێی خۆشدەبێت. ");
INSERT INTO ckb_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","هەموو نەزرێک و هەموو سوێندێکی پابەندبوون بۆ زەلیلکردنی گیان، مێردەکەی دەیچەسپێنێت و مێردەکەی بەتاڵی دەکاتەوە. ");
INSERT INTO ckb_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","ئەگەر مێردەکەی ڕۆژ لەدوای ڕۆژ لێی بێدەنگ بوو، ئەوا هەموو نەزرەکانی یان هەموو ئەو پابەندبوونانەی لەسەریەتی دەچەسپێن، چەسپاندوویەتی چونکە لەو ڕۆژەی بیستوویەتی لێی بێدەنگ بوو، ");
INSERT INTO ckb_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","جا ئەگەر لەدوای بیستنی بەتاڵی کردەوە، ئەوا تاوانەکەی دەکەوێتە ئەستۆی ئەو.» ");
INSERT INTO ckb_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","ئەمە ئەو فەرزانەیە کە یەزدان فەرمانی بە موسا کرد لەنێوان مێرد و ژنەکەی و لەنێوان باوک و کچەکەی لە کاتی کچێنیدا لە ماڵی باوکی. ");
INSERT INTO ckb_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","هەروەها یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","«بە تەواوی تۆڵە بۆ نەوەی ئیسرائیل لە میدیانییەکان بکەرەوە، ئینجا دەچیتە پاڵ گەلەکەت.» ");
INSERT INTO ckb_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","موساش بە گەلی گوت: «لەنێو خۆتان هەندێک پیاو چەکدار بکەن بۆ جەنگ، هەتا بچنە سەر میدیان و تۆڵەی یەزدان لە میدیان بکەنەوە، ");
INSERT INTO ckb_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","لە هەر هۆزێک هەزار کەس لە هەموو هۆزەکانی ئیسرائیل بۆ جەنگ دەنێرن.» ");
INSERT INTO ckb_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","ئینجا لە خێڵەکانی ئیسرائیلدا لە هەر هۆزێک هەزار کەس هەڵبژێردرا، دوازدە هەزار کەس بۆ جەنگ چەکدار کران. ");
INSERT INTO ckb_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","ئینجا موسا ناردنی بۆ جەنگ، لە هەر هۆزێک هەزار، لەگەڵ فینەحاسی کوڕی ئەلعازاری کاهین، قاپوقاچاغی پیرۆزگا و کەڕەناکانی هوتافیشی بەدەستەوە بوو. ");
INSERT INTO ckb_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","ئەوان لە دژی میدیانییەکان جەنگان، وەک یەزدان فەرمانی بە موسا کرد، هەموو نێرینەیەکیان کوشت. ");
INSERT INTO ckb_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","پاشاکانی میدیانیشیان لەگەڵ کوژراوەکانیاندا کوشت، ئاڤی و ڕاقەم و چوور و حوور و ڕێڤەع، پێنج پاشای میدیان، بەلعامی کوڕی بەعۆریشیان بە شمشێر کوشت. ");
INSERT INTO ckb_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","هەروەها نەوەی ئیسرائیل ژن و منداڵی میدیانیان ڕاپێچ کرد و هەموو ئاژەڵ و مەڕ و مانگا و هەموو موڵکیانیان تاڵان کردن. ");
INSERT INTO ckb_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","هەموو ئەو شارۆچکانەش کە میدیانییەکان تێیدا نیشتەجێ بوون و خێوەتگاکانیان سووتاند. ");
INSERT INTO ckb_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","لە دەستکەوت و تاڵانییەکەش لە مرۆڤ و ئاژەڵ هەموویان برد. ");
INSERT INTO ckb_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","ئینجا بە ڕاپێچکراوان و تاڵان و دەستکەوتەوە هاتنە لای موسا و ئەلعازاری کاهین، کۆمەڵی نەوەی ئیسرائیل لە ئۆردوگاکە لە دەشتی مۆئاب کە لەسەر ڕووباری ئوردون بوو بەرامبەر ئەریحا. ");
INSERT INTO ckb_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","موسا و ئەلعازاری کاهین و هەموو ڕابەرانی کۆمەڵ بۆ پێشوازییان چوونە دەرەوەی ئۆردوگاکە. ");
INSERT INTO ckb_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","بەڵام موسا لە سەرکردەکانی سوپا تووڕە بوو، کە فەرماندەکانی هەزاران و سەدان بوون و لە جەنگەوە هاتبوونەوە. ");
INSERT INTO ckb_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","موسا لێی پرسین: «ئایا هەموو ئافرەتێکتان بە زیندوویی هێشتووەتەوە؟ ");
INSERT INTO ckb_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","ئەوانە بوون بە قسەی بەلعامیان کرد و بوونە هۆی ناپاکی نەوەی ئیسرائیل لەگەڵ یەزدان لە کێشەکەی پەعۆر، جا دەرد لەناو کۆمەڵی یەزدان بڵاو بووەوە. ");
INSERT INTO ckb_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","ئێستاش هەموو منداڵە نێرینەکان بکوژن لەگەڵ هەر ژنێک کە لەگەڵ نێر سەرجێیی کردووە، ");
INSERT INTO ckb_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","بەڵام هەموو ئەو کچانەی لەگەڵ پیاو سەرجێییان نەکردووە بۆ خۆتان بە زیندوویی بیانهێڵنەوە. ");
INSERT INTO ckb_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","«ئێوەش حەوت ڕۆژ لە دەرەوەی ئۆردوگاکە چادر هەڵبدەن و خۆتان پاک بکەنەوە، هەرکەسێک یەکێکی کوشتووە یان دەستی لە کوژراوێک داوە، با لە ڕۆژی سێیەم و حەوتەم خۆی پاک بکاتەوە، ئێوە و ڕاپێچکراوانتان. ");
INSERT INTO ckb_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","هەروەها هەر بەرگێک یان شتێک لە پێست یان لە مووی بزن دروستکرابێت و هەر شتێک لە دار دروستکرابێت، پاکی دەکەنەوە.» ");
INSERT INTO ckb_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","ئەلعازاری کاهینیش بە پیاوانی سوپاکەی گوت کە چووبوون بۆ جەنگ: «ئەمە فەرزی فێرکردنەکەیە کە یەزدان فەرمانی بە موسا کرد، ");
INSERT INTO ckb_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","زێڕ و زیو و بڕۆنز و ئاسن و تەنەکە و قورقوشم، ");
INSERT INTO ckb_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","هەموو ئەو شتانەی بەرگەی ئاگر دەگرێت، بەناو ئاگردا تێپەڕی دەکەن و پاشان بە ئاوی پاککردنەوە خاوێن دەبێتەوە. هەموو ئەو شتانەش کە بەرگەی ئاگر ناگرێت، ئەوا بەناو ئاودا تێپەڕی دەکەن. ");
INSERT INTO ckb_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","لە ڕۆژی حەوتەمیش جلەکانتان دەشۆن و ئێوە پاک دەبنەوە، ئینجا دێنەوە ناو ئۆردوگاکە.» ");
INSERT INTO ckb_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","هەروەها یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","«تۆ و ئەلعازاری کاهین و گەورەی بنەماڵەکانی کۆمەڵ تاڵانە ڕاپێچکراوەکە لە خەڵک و لە ئاژەڵ بژمێرن. ");
INSERT INTO ckb_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","تاڵانییەکە بە یەکسانی دابەش بکە لەنێوان ئەو سەربازانەی کە لە جەنگ بەشداریان کرد و هەروەها هەموو کۆمەڵ. ");
INSERT INTO ckb_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","بەشی یەزدانیش دەربهێنە لە بەشی ئەوانەی بەشدارییان لە جەنگ کردووە، یەک لە پێنج سەدی خەڵک و گاوگۆتاڵ و گوێدرێژ. ");
INSERT INTO ckb_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","لە نیوەکەی ئەوان وەریدەگرن و دەیدەنە ئەلعازاری کاهین، بەخشینی بەرزکراوەیە بۆ یەزدان. ");
INSERT INTO ckb_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","لە نیوەکەی نەوەی ئیسرائیلیش یەک لە پەنجا لە خەڵک و گاوگۆتاڵ و گوێدرێژ و مەڕ یان لە هەر ئاژەڵێکی دیکە دەبەیت و دەیدەیتە لێڤییەکان کە بەرپرسیارن لە بایەخدان بە چادری پەرستنی یەزدان.» ");
INSERT INTO ckb_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","جا موسا و ئەلعازاری کاهین وەک یەزدان فەرمانی بە موسا کرد، ئاوایان کرد. ");
INSERT INTO ckb_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","کۆی تاڵانییەکەش کە دەستکەوتی پیاوانی سوپاکە بوو، شەش سەد و حەفتا و پێنج هەزار مەڕ و ");
INSERT INTO ckb_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","حەفتا و دوو هەزار مانگا و ");
INSERT INTO ckb_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","شەست و یەک هەزار گوێدرێژ بوون، ");
INSERT INTO ckb_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","لە مرۆڤیش لەو ئافرەتانەی کە لەگەڵ پیاو سەرجێییان نەکردبوو سی و دوو هەزار کەس بوون. ");
INSERT INTO ckb_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","جا نیوەکەی کە بەشی ئەوانە بوو بۆ جەنگ چووبوون: سێ سەد و سی و حەوت هەزار و پێنج سەد مەڕ بوو، ");
INSERT INTO ckb_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","بەشی یەزدانیش لە مەڕەکان شەش سەد و حەفتا و پێنج بوو، ");
INSERT INTO ckb_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","مانگاکانیش سی و شەش هەزار بوو و بەشی یەزدانیش حەفتا و دوو بوو، ");
INSERT INTO ckb_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","گوێدرێژیش سی هەزار و پێنج سەد بوو، بەشی یەزدانیش شەست و یەک بوو. ");
INSERT INTO ckb_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","مرۆڤیش شازدە هەزار بوو، بەشی یەزدانیش سی و دوو بوو. ");
INSERT INTO ckb_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","جا بەشەکە کە بەخشینی بەرزکراوە بوو بۆ یەزدان، موسا دایە ئەلعازاری کاهین، وەک یەزدان فەرمانی بە موسا کرد. ");
INSERT INTO ckb_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","بەڵام نیوەکەی ئیسرائیل کە موسا لە پیاوانی سوپاکەی جیا کردبووەوە، ");
INSERT INTO ckb_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","نیوەکەی کۆمەڵ سێ سەد و سی و حەوت هەزار و پێنج سەد مەڕ بوو، ");
INSERT INTO ckb_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","مانگاش سی و شەش هەزار بوو، ");
INSERT INTO ckb_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","گوێدرێژیش سی هەزار و پێنج سەد بوو، ");
INSERT INTO ckb_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","لە مرۆڤیش شازدە هەزار بوو. ");
INSERT INTO ckb_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","جا موسا لە نیوەکەی نەوەی ئیسرائیل یەک لە پەنجای خەڵک و ئاژەڵی برد و دایە لێڤییەکان کە بەرپرسیار بوون لە بایەخدان بە چادری پەرستنی یەزدان، وەک یەزدان فەرمانی بە موسا کرد. ");
INSERT INTO ckb_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","ئینجا سەرکردەی یەکەکانی سوپاکە هاتنە پێش بۆ لای موسا، فەرماندەکانی هەزاران و سەدان، ");
INSERT INTO ckb_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","بە موسایان گوت: «ئێمەی خزمەتکارانت ژمارەی ئەو پیاوانەی جەنگمان وەرگرت کە لەژێر فەرمانمان بوون و کەسمان لەدەست نەداوە. ");
INSERT INTO ckb_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","ئەوەتا قوربانی یەزدانمان پێشکەش کرد، هەریەکە هەرچی کەلوپەلی زێڕی دەست کەوتووە لە خڕخاڵ و بازن و ئەنگوستیلە و گوارە و ملوانکە، بۆ کەفارەتکردن بۆمان لەبەردەم یەزدان.» ");
INSERT INTO ckb_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","جا موسا و ئەلعازاری کاهین هەموو کەلوپەلێکی لە زێڕ دروستکراویان لێ وەرگرتن. ");
INSERT INTO ckb_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","هەموو زێڕەکەی بەخشینی بەرزکراوە کە لەلایەن فەرماندەکانی هەزاران و سەدان بۆ یەزدان بەرز کرایەوە، شازدە هەزار و حەوت سەد و پەنجا شاقل بوو. ");
INSERT INTO ckb_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","بەڵام پیاوانی سوپاکە ئەوەی دەستیان کەوتبوو بۆ خۆیان بوو. ");
INSERT INTO ckb_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","جا موسا و ئەلعازاری کاهین زێڕەکەیان لە فەرماندەکانی هەزاران و سەدان وەرگرت و هێنایانە ناو چادری چاوپێکەوتنەوە، وەک یادگاری بۆ نەوەی ئیسرائیل لەبەردەم یەزدان. ");
INSERT INTO ckb_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","بەڵام نەوەی ڕەئوبێن و نەوەی گاد گاوگۆتاڵی زۆریان هەبوو، کاتێک بینییان خاکی یەعزێر و خاکی گلعاد شوێنی مەڕوماڵاتە، ");
INSERT INTO ckb_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","ئیتر نەوەی گاد و نەوەی ڕەئوبێن هاتن و بە موسا و ئەلعازاری کاهین و ڕابەرەکانی کۆمەڵیان گوت: ");
INSERT INTO ckb_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","«عەتەرۆت و دیڤۆن و یەعزێر و نیمرا و حەشبۆن و ئەلعالێ و سەڤام و نیبۆ و بەعۆن، ");
INSERT INTO ckb_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","ئەو خاکەی یەزدان لەبەردەم کۆمەڵی ئیسرائیل بەزاندی، ئەوە خاکی مەڕوماڵاتە و خزمەتکارەکانیشت مەڕوماڵاتیان هەیە.» ");
INSERT INTO ckb_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","هەروەها گوتیان: «ئەگەر لەبەرچاوت پەسەندین، با ئەو خاکە بدرێت بە خزمەتکارەکانت و ببێت بە موڵکمان و لە ڕووباری ئوردون مەمانپەڕێنەوە.» ");
INSERT INTO ckb_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","موساش بە نەوەی گاد و ڕەئوبێنی گوت: «ئایا دەبێت براکانتان بۆ جەنگ بڕۆن و ئێوەش لێرە دانیشن؟ ");
INSERT INTO ckb_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","بۆچی دڵی نەوەی ئیسرائیل سارد دەکەنەوە لە پەڕینەوەیان بۆ ئەو خاکەی یەزدان پێیداون؟ ");
INSERT INTO ckb_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","باوکانتان ئاوایان کرد کاتێک لە قادێش بەرنێعەوە ئەوانم نارد بۆ ئەوەی تەماشای خاکەکە بکەن، ");
INSERT INTO ckb_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","بە دۆڵی ئەشکۆلدا سەرکەوتن و تەماشای خاکەکەیان کرد و دڵی نەوەی ئیسرائیلیان سارد کردەوە لە چوونە ناو ئەو خاکەی یەزدان پێیداون. ");
INSERT INTO ckb_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","لەو ڕۆژەدا تووڕەیی یەزدان جۆشا و سوێندی خوارد و فەرمووی: ");
INSERT INTO ckb_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","”ئەو خەڵکەی کە لە میسر هاتنە دەرەوە، لە گەنجی بیست ساڵ بەرەو سەرەوە، ناچنە ناو ئەو خاکەی سوێندم لەسەری خوارد بۆ ئیبراهیم و ئیسحاق و یاقوب، چونکە بە هەموو دڵیانەوە دوام نەکەوتن، ");
INSERT INTO ckb_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","تەنها کالێبی کوڕی یەفونەی قەنیزی و یەشوعی کوڕی نون نەبێت، چونکە بە هەموو دڵیانەوە دوای یەزدان کەوتن.“ ");
INSERT INTO ckb_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","تووڕەیی یەزدان بەسەر ئیسرائیلدا جۆشا و چل ساڵ لە چۆڵەوانی وێڵی کردن، هەتا هەموو ئەو نەوەیە لەناوچوون کە لەبەرچاوی یەزدان خراپەیان کرد. ");
INSERT INTO ckb_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","«ئەوەتا ئێوەش لە جیاتی باوکانتان هەستاون، کۆمەڵە خەڵکێکی گوناهبارن، تاکو کوڵی تووڕەیی یەزدان لەسەر ئیسرائیل زیاتر بکەن. ");
INSERT INTO ckb_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","ئەگەر لێی هەڵگەڕێنەوە، ئەوا دیسان لەم چۆڵەوانییە وازیان لێ دەهێنێت، ئیتر دەبنە هۆی لەناوچوونی هەموو ئەم گەلە.» ");
INSERT INTO ckb_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","ئەوانیش لێی هاتنە پێش و گوتیان: «لێرە پشتیر بۆ ماڵاتەکانمان و چەند شارێک بۆ ژن و منداڵەکانمان بنیاد دەنێین، ");
INSERT INTO ckb_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","بەڵام خۆمان چەک هەڵدەگرین و بە خێرایی پێش نەوەی ئیسرائیل دەکەوین هەتا دەیانبەینە شوێنەکەیان. هەروەها ژن و منداڵەکانیشمان لەبەر دانیشتووانی ئەم خاکە لە شاری قەڵابەند دەبن. ");
INSERT INTO ckb_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","ناگەڕێینەوە ماڵەکانمان هەتا نەوەی ئیسرائیل هەریەکە میراتگری میراتەکەی خۆی نەبێت، ");
INSERT INTO ckb_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","ئێمە لە پشتی ڕووباری ئوردون و بەو لاوە میراتمان لەگەڵیان نابێت، چونکە میراتی خۆمان لە بەری ڕۆژهەڵاتی ڕووباری ئوردون وەرگرت.» ");
INSERT INTO ckb_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","موساش پێی گوتن: «ئەگەر ئەمەتان کرد، ئەگەر لەبەردەم یەزدان چەکتان بۆ جەنگ هەڵگرت و ");
INSERT INTO ckb_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","هەموو چەکدارەکانتان لە ڕووباری ئوردون پەڕینەوە، هەتا هەموو دوژمنەکانی لەبەردەمی خۆی دەرکرد و ");
INSERT INTO ckb_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","خاکەکە لەبەردەم یەزدان ژێردەستە کرا و لەدوای ئەمە گەڕانەوە، ئەوا سەبارەت بە یەزدان و بە ئیسرائیل ئازاد دەبن لە پابەندییەکەتان و لەبەردەم یەزدان ئەم خاکە دەبێتە موڵکتان. ");
INSERT INTO ckb_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","«بەڵام ئەگەر وا نەکەن، ئەوا گوناه لە دژی یەزدان دەکەن و باش دەزانن کە گوناهەکەتان چیتان بەسەردەهێنێت. ");
INSERT INTO ckb_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","بۆ خۆتان چەند شارێک بۆ ژن و منداڵەکانتان و پشتیر بۆ ماڵاتەکانتان بنیاد بنێن، ئەوەی بەڵێنتان دا بیکەن.» ");
INSERT INTO ckb_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","نەوەی گاد و نەوەی ڕەئوبێن بە موسایان گوت: «خزمەتکارەکانت ئاوا دەکەن، وەک گەورەم فەرمانی دا، ");
INSERT INTO ckb_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","ژن و منداڵ و گاوگۆتاڵەکانمان لەوێ لە شارەکانی گلعاد دەبن. ");
INSERT INTO ckb_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","بەڵام خزمەتکارەکانت، هەموو چەک هەڵگرەکان لەبەردەم یەزدان بۆ جەنگ دەپەڕنەوە، وەک گەورەمان گوتی.» ");
INSERT INTO ckb_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","موساش لەبارەی ئەوانەوە فەرمانی بە ئەلعازاری کاهین و یەشوعی کوڕی نون و گەورەی بنەماڵەکانی هۆزەکانی نەوەی ئیسرائیل کرد و ");
INSERT INTO ckb_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","پێی گوتن: «ئەگەر نەوەی گاد و نەوەی ڕەئوبێن، هەموو چەک هەڵگرەکان بۆ جەنگ، لەبەردەم یەزدان لەگەڵتان لە ڕووباری ئوردون پەڕینەوە، کاتێک خاکەکە کەوتە ژێر دەستتان، ئەوا دەبێت خاکی گلعادیان وەک موڵک پێبدەن. ");
INSERT INTO ckb_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","بەڵام ئەگەر بە چەکەوە لەگەڵتان نەپەڕینەوە، ئەوا لەنێوتان لە خاکی کەنعان موڵکیان دەبێت.» ");
INSERT INTO ckb_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","نەوەی گاد و نەوەی ڕەئوبێن وەڵامیان دایەوە و گوتیان: «ئەوەی یەزدان سەبارەت بە خزمەتکارەکانت فەرمووی، ئاوا دەکەین. ");
INSERT INTO ckb_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","ئێمە بە چەکەوە لەبەردەم یەزدان بۆ خاکی کەنعان دەپەڕینەوە، بەڵام لە ڕۆژهەڵاتی ڕووباری ئوردون بەشە میراتمان دەدرێتێ.» ");
INSERT INTO ckb_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","ئینجا موسا پاشایەتییەکەی سیحۆنی پاشای ئەمۆرییەکان و پاشایەتییەکەی عۆگی پاشای باشان، تەواوی خاکەکە لەگەڵ شارەکانی و بە سنوورەکانی دەوروبەریەوە دایە نەوەی گاد و نەوەی ڕەئوبێن و نیوەی هۆزی مەنەشەی کوڕی یوسف. ");
INSERT INTO ckb_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","نەوەی گاد دیڤۆن و عەتەرۆت، عەرۆعێر، ");
INSERT INTO ckb_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","عەترۆت شۆفان، یەعزێر، یۆگبەها، ");
INSERT INTO ckb_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","بێت‌نیمرا و بێت‌هارانیان کردە شاری قەڵابەند، پشتیری مەڕیشیان بنیاد نا، ");
INSERT INTO ckb_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","نەوەی ڕەئوبێنیش حەشبۆن و ئەلعالێ و قیریاتەیم و ");
INSERT INTO ckb_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","نیبۆ و بەعل‌مەعۆن کە ناوەکەیان گۆڕیوە و هەروەها سیڤما، ناویشیان لەو شارانە نا کە بنیادیان ناوە. ");
INSERT INTO ckb_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","نەوەی ماکیری کوڕی مەنەشەش چوونە گلعاد و گرتیان، ئەو ئەمۆرییانەیان دەرکرد کە تێیدا بوون. ");
INSERT INTO ckb_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","ئینجا موساش گلعادی دا بە ماکیرییەکان، کە نەوەی مەنەشەن، ئەوانیش تێیدا نیشتەجێ بوون. ");
INSERT INTO ckb_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","یائیری نەوەی مەنەشەش چوو و دەستی بەسەر ئاوەدانییەکانیاندا گرت و ناوی لێنان حەڤۆت یائیر. ");
INSERT INTO ckb_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","نۆڤەحیش چوو و دەستی بەسەر قەنات و ئاوەدانییەکانیدا گرت و بە ناوی خۆیەوە ناوی لێنا نۆڤەح. ");
INSERT INTO ckb_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","ئەمانە قۆناغەکانی کۆچی نەوەی ئیسرائیلن کە بە لەشکرەکانیانەوە لەسەر دەستی موسا و هارون لە خاکی میسرەوە هاتنە دەرەوە. ");
INSERT INTO ckb_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","موساش بەپێی فەرمانی یەزدان قۆناغی کۆچەکانیانی تۆمار کرد. ئەمەش کۆچەکانیانە، قۆناغ بە قۆناغ: ");
INSERT INTO ckb_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","لە ڕۆژی پازدەی مانگی یەک، لە ڕۆژی دوای جەژنی پەسخە لە ڕەعمسێسەوە کۆچیان کرد. نەوەی ئیسرائیل بوێرانە لەبەرچاوی هەموو میسرییەکان چوونە دەرەوە. ");
INSERT INTO ckb_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","لەو کاتەدا میسرییەکان هەموو نۆبەرەکانی خۆیانیان دەناشت کە یەزدان لێیدابوون، چونکە یەزدان حوکمی خوداوەندەکانی ئەوانی دابوو. ");
INSERT INTO ckb_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","نەوەی ئیسرائیل لە ڕەعمسێسەوە کۆچیان کرد و لە سوکۆت چادریان هەڵدا. ");
INSERT INTO ckb_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","ئینجا لە سوکۆتەوە کۆچیان کرد و لە ئێتام چادریان هەڵدا کە لە قەراغی چۆڵەوانییە. ");
INSERT INTO ckb_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","پاشان لە ئێتامەوە کۆچیان کرد و گەڕانەوە لای پی‌هەحیرۆت، کە لە ڕۆژهەڵاتی بەعل‌چیفۆنە و بەرامبەر مگدۆل چادریان هەڵدا. ");
INSERT INTO ckb_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","پاشان لە پی‌هەحیرۆتەوە کۆچیان کرد و بەناو دەریادا پەڕینەوە بۆ چۆڵەوانی و سێ ڕۆژە ڕێ لە چۆڵەوانی ئێتامدا ڕۆیشتن، لە مارا چادریان هەڵدا. ");
INSERT INTO ckb_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","پاشان لە ماراوە کۆچیان کرد و هاتنە ئێلیم، لە ئێلیمیش دوازدە کانیاو و حەفتا دار خورمای لێبوو، لەوێ چادریان هەڵدا. ");
INSERT INTO ckb_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","پاشان لە ئێلیمەوە کۆچیان کرد و لەلای دەریای سوور چادریان هەڵدا. ");
INSERT INTO ckb_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","پاشان لەلای دەریای سوورەوە کۆچیان کرد و لە چۆڵەوانی سین چادریان هەڵدا. ");
INSERT INTO ckb_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","پاشان لە چۆڵەوانی سینەوە کۆچیان کرد و لە دۆفقە چادریان هەڵدا. ");
INSERT INTO ckb_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","پاشان لە دۆفقەوە کۆچیان کرد و لە ئالوش چادریان هەڵدا. ");
INSERT INTO ckb_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","پاشان لە ئالوشەوە کۆچیان کرد و لە ڕەفیدیم چادریان هەڵدا، لەوێ هیچ ئاو نەبوو تاکو گەل بیخۆنەوە. ");
INSERT INTO ckb_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","پاشان لە ڕەفیدیمەوە کۆچیان کرد و لە چۆڵەوانی سینا چادریان هەڵدا. ");
INSERT INTO ckb_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","پاشان لە چۆڵەوانی سیناوە کۆچیان کرد و لە قیبرۆت هەتەڤا چادریان هەڵدا. ");
INSERT INTO ckb_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","پاشان لە قیبرۆت هەتەڤایەوە کۆچیان کرد و لە حەچێرۆت چادریان هەڵدا. ");
INSERT INTO ckb_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","پاشان لە حەچێرۆتەوە کۆچیان کرد و لە ڕیتمە چادریان هەڵدا. ");
INSERT INTO ckb_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","پاشان لە ڕیتمەوە کۆچیان کرد و لە ڕیمۆن پێرێز چادریان هەڵدا. ");
INSERT INTO ckb_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","پاشان لە ڕیمۆن پێرێزەوە کۆچیان کرد و لە لیڤنا چادریان هەڵدا. ");
INSERT INTO ckb_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","پاشان لە لیڤناوە کۆچیان کرد و لە ڕیسە چادریان هەڵدا. ");
INSERT INTO ckb_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","پاشان لە ڕیسەوە کۆچیان کرد و لە قەهێلاتە چادریان هەڵدا. ");
INSERT INTO ckb_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","پاشان لە قەهێلاتەیەوە کۆچیان کرد و لە کێوی شافەر چادریان هەڵدا. ");
INSERT INTO ckb_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","پاشان لە کێوی شافەرەوە کۆچیان کرد و لە حەرادە چادریان هەڵدا. ");
INSERT INTO ckb_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","پاشان لە حەرادەوە کۆچیان کرد و لە مەقهێلۆت چادریان هەڵدا. ");
INSERT INTO ckb_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","پاشان لە مەقهێلۆتەوە کۆچیان کرد و لە تاحەت چادریان هەڵدا. ");
INSERT INTO ckb_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","پاشان لە تاحەتەوە کۆچیان کرد و لە تارەح چادریان هەڵدا. ");
INSERT INTO ckb_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","پاشان لە تارەحەوە کۆچیان کرد و لە میتقە چادریان هەڵدا. ");
INSERT INTO ckb_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","پاشان لە میتقەوە کۆچیان کرد و لە حەشمۆنە چادریان هەڵدا. ");
INSERT INTO ckb_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","پاشان لە حەشمۆنەوە کۆچیان کرد و لە مۆسێرۆت چادریان هەڵدا. ");
INSERT INTO ckb_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","پاشان لە مۆسێرۆتەوە کۆچیان کرد و لە بەنێ یەعقان چادریان هەڵدا. ");
INSERT INTO ckb_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","پاشان لە بەنێ یەعقانەوە کۆچیان کرد و لە حۆر هەگیدگاد چادریان هەڵدا. ");
INSERT INTO ckb_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","پاشان لە حۆر هەگیدگادەوە کۆچیان کرد و لە یۆتباتە چادریان هەڵدا. ");
INSERT INTO ckb_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","پاشان لە یۆتباتەیەوە کۆچیان کرد و لە عەڤرۆنە چادریان هەڵدا. ");
INSERT INTO ckb_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","پاشان لە عەڤرۆنەیەوە کۆچیان کرد و لە عەچیۆن گەڤەر چادریان هەڵدا. ");
INSERT INTO ckb_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","پاشان لە عەچیۆن گەڤەرەوە کۆچیان کرد و لە چۆڵەوانی چن کە قادێشە چادریان هەڵدا. ");
INSERT INTO ckb_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","پاشان لە قادێشەوە کۆچیان کرد و لە کێوی هۆر چادریان هەڵدا کە لە نزیکی سنووری خاکی ئەدۆمە. ");
INSERT INTO ckb_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","لە یەکی مانگی پێنجی چلەمین ساڵی هاتنەدەرەوەی نەوەی ئیسرائیل لە خاکی میسر، هارونی کاهین بەپێی فەرمانی یەزدان بۆ سەر کێوی هۆر سەرکەوت و لەوێ مرد. ");
INSERT INTO ckb_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","هارون تەمەنی سەد و بیست و سێ ساڵ بوو کاتێک لە کێوی هۆر مرد. ");
INSERT INTO ckb_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","پاشای عەرادیش کە کەنعانی بوو و لە نەقەب لە خاکی کەنعان نیشتەجێ بوو، هاتنی نەوەی ئیسرائیلی بیست. ");
INSERT INTO ckb_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","ئینجا لە کێوی هۆرەوە کۆچیان کرد و لە چەلمۆنا چادریان هەڵدا. ");
INSERT INTO ckb_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","پاشان لە چەلمۆنایەوە کۆچیان کرد و لە پونۆن چادریان هەڵدا. ");
INSERT INTO ckb_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","پاشان لە پونۆنەوە کۆچیان کرد و لە ئۆڤۆت چادریان هەڵدا. ");
INSERT INTO ckb_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","پاشان لە ئۆڤۆتەوە کۆچیان کرد و لە عییی عەڤاریم چادریان هەڵدا، کە لە سنووری مۆئابە. ");
INSERT INTO ckb_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","پاشان لە عییی عەڤاریم کۆچیان کرد و لە دیڤۆن گاد چادریان هەڵدا. ");
INSERT INTO ckb_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","پاشان لە دیڤۆن گادەوە کۆچیان کرد و لە عەلمۆن دیڤلاتایم چادریان هەڵدا. ");
INSERT INTO ckb_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","پاشان لە عەلمۆن دیڤلاتایمەوە کۆچیان کرد و لە زنجیرە چیای عەڤاریم ڕووبەڕووی نیبۆ چادریان هەڵدا. ");
INSERT INTO ckb_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","پاشان لە زنجیرە چیای عەڤاریمەوە کۆچیان کرد و لە دەشتی مۆئاب لەسەر کەناری ڕووباری ئوردون بەرامبەر ئەریحا چادریان هەڵدا، ");
INSERT INTO ckb_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","لە کەناری ڕووباری ئوردون لە بێت‌یەشیمۆتەوە هەتا ئابێل شیتیم لە دەشتی مۆئاب چادریان هەڵدا. ");
INSERT INTO ckb_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","یەزدان لە دەشتی مۆئاب لەسەر کەناری ڕووباری ئوردون بەرامبەر ئەریحا بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","«لەگەڵ نەوەی ئیسرائیل بدوێ و پێیان بڵێ: ”کاتێک ئێوە لە ڕووباری ئوردون دەپەڕنەوە بۆ خاکی کەنعان، ");
INSERT INTO ckb_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","هەموو دانیشتووانی خاکەکە لەپێش خۆتان دەربکەن. هەموو پەیکەرە تاشراو و بتە داڕێژراوەکانیان لەناوببەن، هەموو نزرگەکانی سەر بەرزاییان تێکبدەن. ");
INSERT INTO ckb_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","خاکەکە داگیر بکەن و تێیدا نیشتەجێ بن، چونکە من خاکەکەم پێداون بۆ ئەوەی ببنە خاوەنی و ");
INSERT INTO ckb_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","خاکەکەش بەگوێرەی خێڵەکانتان بە تیروپشک دابەش بکەن، میراتی زۆر بدەنە زۆرەکان و میراتی کەم بدەنە کەمەکان، لەکوێ تیروپشکی بۆ دەرچوو ئەوێ بۆ ئەو بێت، بەگوێرەی هۆزەکانی باوکانتان میراتگری بکەن. ");
INSERT INTO ckb_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","«”ئەگەر دانیشتووانی خاکەکەش لەپێش خۆتان دەرنەکەن، ئەوا ئەوانەی دەیانهێڵنەوە دەبنە چقڵ لە چاوتان و دڕک لە کەلەکەتان و لەو خاکەی تێیدا نیشتەجێن تەنگتان پێ هەڵدەچنن، ");
INSERT INTO ckb_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","ئینجا بە ئێوەی دەکەم، ئەوەی بەتەمام بەوانی بکەم.“» ");
INSERT INTO ckb_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","هەروەها یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","«فەرمان بە نەوەی ئیسرائیل بکە و پێیان بڵێ: ”کاتێک ئێوە دەچنە ناو خاکی کەنعانەوە، ئەمە ئەو خاکەیە کە دەبێتە میراتتان، خاکی کەنعان بە سنوورەکانییەوە: ");
INSERT INTO ckb_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","«”لەلای باشووری ئێوە لە چۆڵەوانی چنەوە لەلای ئەدۆم دەبێت، سنووری باشوورتان لە ڕۆژهەڵات لە کۆتایی دەریای مردووەوە دەستپێدەکات. ");
INSERT INTO ckb_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","هەروەها سنوورەکە لە باشووری هەورازی دووپشکەوە بۆتان دەسووڕێتەوە و بەردەوام دەبێت هەتا چن و لە باشووری قادێش بەرنێعەوە هەتا حەچەر ئەدار دەچێت و تێدەپەڕێت بۆ عەچمۆن، ");
INSERT INTO ckb_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","لە عەچمۆنیش دەسووڕێتەوە و دەگاتە دۆڵی میسر، کۆتاییەکەی لەلای دەریای سپی ناوەڕاست دەبێت. ");
INSERT INTO ckb_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","بەڵام سنووری ڕۆژئاوا، ئەوا دەریای سپی ناوەڕاست دەبێت. ئەمەیە سنووری ڕۆژئاواتان. ");
INSERT INTO ckb_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","بۆ دیاریکردنی سنووری باکوورتان، هێڵێک بکێشن لە دەریای سپی ناوەڕاستەوە هەتا کێوی هۆر، ");
INSERT INTO ckb_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","هەروەها لە کێوی هۆرەوە هەتا دەروازەی حەمات. پاشان سنوورەکە دەچێت بۆ چەداد، ");
INSERT INTO ckb_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","بەردەوام دەبێت بۆ زیفرۆن و کۆتاییەکەی لە حەچەر عێینان دەبێت. ئەمە دەبێتە سنووری باکوورتان. ");
INSERT INTO ckb_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","هەروەها سنوور بۆ خۆتان دەکێشن بۆ ڕۆژهەڵات، لە حەچەر عێینانەوە هەتا شەفام. ");
INSERT INTO ckb_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","لە شەفامەوە بەرەو خوارەوە دەچێت هەتا ڕیڤلە لە ڕۆژهەڵاتی عەین. ئینجا سنوورەکە بەرەو خوارەوە دەچێت لە بناری کێوەکانی دەریاچەی جەلیل دەدات بەلای ڕۆژهەڵاتدا، ");
INSERT INTO ckb_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","پاشان سنوورەکە بە درێژایی کەناری ڕووباری ئوردون بەرەو خوارەوە دەچێت و کۆتاییەکەی لەلای دەریای مردوو دەبێت. «”ئەم خاکە بە سنوورەکانی و چواردەوریشییەوە بۆ ئێوە دەبێت.“» ");
INSERT INTO ckb_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","موساش فەرمانی بە نەوەی ئیسرائیل کرد و گوتی: «ئەمە ئەو خاکەیە کە بە تیروپشک میراتگری دەکەن، کە یەزدان فەرمانی دا بە نۆ هۆز و نیوەکە بدرێت، ");
INSERT INTO ckb_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","چونکە هۆزی نەوەی ڕەئوبێن بەگوێرەی بنەماڵەکانیان و هۆزی نەوەی گاد بەگوێرەی بنەماڵەکانیان و نیوەی هۆزی مەنەشە میراتی خۆیان وەرگرت. ");
INSERT INTO ckb_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","دوو هۆز و نیوەکە میراتی خۆیان لە ڕۆژهەڵاتی ڕووباری ئوردون لەلای ئەریحا بەرەو ڕۆژهەڵات وەرگرت.» ");
INSERT INTO ckb_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","هەروەها یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","«ئەمە ناوی ئەو دوو پیاوەیە کە خاکەکەتان بۆ دابەش دەکەن، ئەلعازاری کاهین و یەشوعی کوڕی نون، ");
INSERT INTO ckb_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","لە هەر هۆزێکیش ڕابەرێک دەبەن بۆ بەمیراتکردنی خاکەکە. ");
INSERT INTO ckb_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","«ئەمەش ناوی پیاوەکانە: «کالێبی کوڕی یەفونە لە هۆزی یەهودا؛ ");
INSERT INTO ckb_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","شەموئێلی کوڕی عەمیهود لە هۆزی نەوەی شیمۆن؛ ");
INSERT INTO ckb_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","ئەلیدادی کوڕی کیسلۆن لە هۆزی بنیامین؛ ");
INSERT INTO ckb_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","بوقی کوڕی یۆگلی، ڕابەر لە هۆزی نەوەی دان؛ ");
INSERT INTO ckb_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","حەنیێلی کوڕی ئێفۆد، ڕابەر لە هۆزی نەوەی مەنەشە، کوڕی یوسف؛ ");
INSERT INTO ckb_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","قەموئێلی کوڕی شیفتان، ڕابەر لە هۆزی نەوەی ئەفرایم، کوڕی یوسف؛ ");
INSERT INTO ckb_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","ئەلیچافانی کوڕی پەرناخ، ڕابەر لە هۆزی نەوەی زەبولون؛ ");
INSERT INTO ckb_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","پەلتیێلی کوڕی عەزان، ڕابەر لە هۆزی نەوەی یەساخار؛ ");
INSERT INTO ckb_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","ئەحیهودی کوڕی شەلۆمی، ڕابەر لە هۆزی نەوەی ئاشێر؛ ");
INSERT INTO ckb_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","پەدەهەئێلی کوڕی عەمیهود، ڕابەر لە هۆزی نەوەی نەفتالی.» ");
INSERT INTO ckb_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","ئەمانە ئەو کەسانەن کە یەزدان فەرمانی پێ کردن، هەتا میراتگیری خاکی کەنعان بۆ نەوەی ئیسرائیل دابەش بکەن. ");
INSERT INTO ckb_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","ئینجا یەزدان لە دەشتی مۆئاب لەسەر ڕووباری ئوردون بەرامبەر ئەریحا بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","«فەرمان بە نەوەی ئیسرائیل بکە، با لە موڵکی میراتیان چەند شارۆچکەیەک بۆ نیشتەجێبوون و لەوەڕگاش لە چواردەوری شارۆچکەکان بە لێڤییەکان بدەن. ");
INSERT INTO ckb_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","ئینجا شارۆچکەکان بۆ نیشتەجێبوونیان دەبێت و لەوەڕگاکانیش بۆ گاوگۆتاڵ و هەموو مەڕوماڵاتێکی دیکەیان دەبێت. ");
INSERT INTO ckb_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","«ئەو لەوەڕگایانەش کە دەیدەنە لێڤییەکان، لە شوورای شارۆچکەکانەوە بەلای دەرەوە، هەزار باڵ بە چواردەوریدا دەبێت. ");
INSERT INTO ckb_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","لە دەرەوەی شار بەلای ڕۆژهەڵاتدا دوو هەزار باڵ دەژمێرن، بەلای باشووردا دوو هەزار باڵ، بەلای ڕۆژئاوادا دوو هەزار باڵ، بەلای باکووردا دوو هەزار باڵ و شارۆچکەکەش لە ناوەڕاست دەبێت. ئەمە دەبێتە لەوەڕگای شارۆچکەکان بۆیان. ");
INSERT INTO ckb_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","«شەش لەو شارۆچکانەش کە بە لێڤییەکانی دەدەن دەبنە شاری پەناگا، بۆ ئەوەی هەرکەسێک کەسێکی دیکە بکوژێت بۆ ئەوێ هەڵبێت. سەرباری ئەمانەش چل و دوو شارۆچکەی دیکە دەدەنە لێڤییەکان. ");
INSERT INTO ckb_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","هەموو ئەو شارۆچکانەی دەیاندەنە لێڤییەکان، چل و هەشت شارۆچکەن بە لەوەڕگاکانیانەوە. ");
INSERT INTO ckb_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","ئەو شارۆچکانەش کە لە موڵکی نەوەی ئیسرائیل دەیدەنە لێڤییەکان، هەریەکە بەگوێرەی میراتی هەر هۆزێک. لەو هۆزانەی کە شارۆچکەیان زۆرە، زۆر وەردەگرن و لەو هۆزانەش کە کەمە، کەم وەردەگرن.» ");
INSERT INTO ckb_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","هەروەها یەزدان بە موسای فەرموو: ");
INSERT INTO ckb_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","«لەگەڵ نەوەی ئیسرائیل بدوێ و پێیان بڵێ: ”کاتێک ئێوە لە ڕووباری ئوردون دەپەڕنەوە بۆ خاکی کەنعان، ");
INSERT INTO ckb_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","چەند شارۆچکەیەک بۆ خۆتان دەستنیشان دەکەن و دەبنە شاری پەناگا، تاکو ئەو کەسەی کە بەبێ ئەنقەست کەسێک بکوژێت بۆ ئەوێ هەڵبێت. ");
INSERT INTO ckb_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","ئەو شارانە بۆتان دەبنە پەناگا لە دەست خوێنگر، بۆ ئەوەی تۆمەتبارکراو بە کوشتن، نەکوژرێت هەتا لەبەردەم ئەنجومەن دەوەستێت بۆ دادوەری. ");
INSERT INTO ckb_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","ئەو شەش شارۆچکانەش کە ئێوە دەیدەن دەبنە شاری پەناگا بۆتان. ");
INSERT INTO ckb_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","سێ لە شارۆچکەکان لەوبەری ڕووباری ئوردون دەدەن و سێ شارۆچکەش لە خاکی کەنعان دەدەن، دەبنە شاری پەناگا، ");
INSERT INTO ckb_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","بۆ نەوەی ئیسرائیل و نامۆ و ئەوەی لەنێویاندا نیشتەجێیە. ئەم شەش شارە بۆ پەناگا دەبن، هەتا هەرکەسێک کە بەبێ ئەنقەست کەسێک بکوژێت بۆ ئەوێ هەڵبێت. ");
INSERT INTO ckb_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","«”ئەگەر یەکێک بە ئامرازێکی ئاسن لە کەسێکی دا و مرد، ئەوا بە بکوژ دادەنرێت، دەبێت بکوژ بکوژرێتەوە. ");
INSERT INTO ckb_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","ئەگەر کەسێک بەردێکی بە دەستەوە بوو کە بکوژێت و بەو بەردە لە کەسێکی دا و مرد، ئەوا بە بکوژ دادەنرێت، دەبێت بکوژ بکوژرێتەوە. ");
INSERT INTO ckb_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","یان ئەگەر کەسێک هەر شتێکی لە دار دروستکراوی بە دەستەوە بوو کە بکوژێت، لە کەسێکی دیکەی دا، ئەوا بە بکوژ دادەنرێت، دەبێت بکوژ بکوژرێتەوە. ");
INSERT INTO ckb_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","خوێنگرەکە بکوژ دەکوژێت، هەر کاتێک تووشی بێت دەیکوژێتەوە. ");
INSERT INTO ckb_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","یان ئەگەر کەسێک بە ڕقەوە پاڵی بە کەسێکی دیکەوە نا یان بە ئەنقەست شتێکی بۆ هاویشت و مرد، ");
INSERT INTO ckb_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","یان ئەگەر بە دوژمنایەتییەوە بە مستەکۆڵە لێیدا و مرد، ئەوا دەستدرێژیکەر دەبێت بکوژرێتەوە، چونکە بکوژە، خوێنگرە تۆڵەسێنەرەکە هەر کاتێک تووشی بکوژ بێت دەیکوژێتەوە. ");
INSERT INTO ckb_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","«”بەڵام ئەگەر کەسێک لەناکاو پاڵی بە کەسێکی دیکەوە نا بەبێ دوژمنایەتی یان بەبێ ئەنقەست شتێکی بۆ هاویشت، ");
INSERT INTO ckb_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","یان بێ ئەوەی بیبینێت، بەردێکی گەورەی بەسەریدا بەردایەوە و مرد، ئەگەر چی دوژمنیشی نییە و خراپەی ئەوی ناوێت، ");
INSERT INTO ckb_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","ئەوا ئەنجومەن بەگوێرەی ئەم یاسایانە دادوەری لەنێوان تۆمەتبارکراوەکە و خوێنگرە تۆڵەسێنەرەکە دەکات. ");
INSERT INTO ckb_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","ئەنجومەن فریای تۆمەتبارکراوەکە دەکەوێت لە دەست خوێنگرە تۆڵەسێنەرەکە و دەیگەڕێنێتەوە بۆ ئەو شارەی پەناگا کە بۆی هەڵاتبوو. لەوێ دەمێنێتەوە هەتا سەرۆکی کاهین دەمرێت کە بە زەیتی پیرۆز دەستنیشان کراوە. ");
INSERT INTO ckb_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","«”بەڵام ئەگەر تۆمەتبارکراوەکە لە سنووری شاری پەناگای کە بۆی هەڵاتووە، چووە دەرەوە و ");
INSERT INTO ckb_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","خوێنگری تۆڵەسێنەر ئەوی لە دەرەوەی سنووری شاری پەناگا بینییەوە و خوێنگرە تۆڵەسێنەرەکە تۆمەتبارکراوەکەی کوشت، ئەوا مافی تاوانبارکردنی خوێنی نییە، ");
INSERT INTO ckb_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","چونکە دەبێت هەتا مردنی سەرۆکی کاهین ئەو کەسە لە شاری پەناگا بێت، بەڵام لەدوای مردنی سەرۆکی کاهین، دەگەڕێتەوە موڵکەکەی خۆی. ");
INSERT INTO ckb_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","«”ئەمە بۆتان دەبێتە فەرزێکی یاسایی بۆ نەوەکانتان لە هەموو نشینگەکانتان. ");
INSERT INTO ckb_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","«”هەرکەسێک کەسێکی دیکە بکوژێت، ئەوا لەسەر دەمی چەند شایەتێک بە بکوژ دادەنرێت و دەبێت بکوژرێتەوە، یەک شایەت بەس نییە بۆ شایەتیدان لەسەر کەسێک بۆ مردن. ");
INSERT INTO ckb_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","«”خوێنبایی وەرمەگرە بۆ بکوژێک کە شایانی سزای مردنە، بەڵکو دەبێت بکوژرێتەوە. ");
INSERT INTO ckb_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","«”هەروەها خوێنبایی وەرمەگرن بۆ ئەو کەسەی بۆ شاری پەناگا هەڵبێت، تاوەکو پێش مردنی سەرۆکی کاهین بگەڕێتەوە و لە زەوی خۆی نیشتەجێ بێت. ");
INSERT INTO ckb_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","«”ئەو خاکەی ئێوە تێیدان گڵاوی مەکەن، چونکە خوێن خاک گڵاو دەکات، هیچ شتێک کەفارەتی ئەو خوێنە ناکات کە لە خاکەکە ڕژاوە، تەنها خوێنی خوێنڕێژەکە نەبێت. ");
INSERT INTO ckb_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","کەواتە ئەو خاکەی کە ئێوە تێیدا نیشتەجێن و من لە ناوەڕاستیدا نیشتەجێم گڵاوی مەکەن، چونکە من کە یەزدانم لەنێو نەوەی ئیسرائیلدا نیشتەجێم.“» ");
INSERT INTO ckb_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","گەورەی بنەماڵەکانی خێڵی نەوەی گلعادی کوڕی ماکیر کوڕی مەنەشە کە لە خێڵەکانی نەوەی یوسفن، هاتنە پێش و لەبەردەم موسا و بەردەم گەورەی بنەماڵەکانی نەوەی ئیسرائیل دوان و ");
INSERT INTO ckb_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","گوتیان: «کاتێک یەزدان فەرمانی بە گەورەم کرد، کە خاکەکە بە میرات بە تیروپشک بداتە نەوەی ئیسرائیل، هەروەها فەرمانی پێ کردیت کە میراتەکەی سەلۆفحادی برامان بدەیتە کچەکانی. ");
INSERT INTO ckb_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","جا ئەگەر گریمان بوونە ژنی پیاوێک لە هۆزەکانی نەوەی ئیسرائیل، ئەوا میراتەکەیان لە میراتی باوکانمان دەبردرێت و دەخرێتە سەر میراتی ئەو هۆزە کە بۆ ئەوان بوون، جا بەشێک لە تیروپشکی میراتەکەمان دەبردرێت. ");
INSERT INTO ckb_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","کاتێک بووە ساڵی یۆبیل بۆ نەوەی ئیسرائیل، ئەوا میراتەکەیان دەچێتە سەر میراتی ئەو هۆزەی کە بۆیان بوون و لە میراتی هۆزی باوکانمان میراتیان دەبردرێت.» ");
INSERT INTO ckb_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","جا موسا بەگوێرەی فەرمایشتی یەزدان فەرمانی بە نەوەی ئیسرائیل کرد و گوتی: «هۆزی نەوەی یوسف ڕاستیان گوت. ");
INSERT INTO ckb_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","یەزدان فەرمانی ئەمەی کرد سەبارەت بە کچانی سەلۆفحاد و فەرمووی، ئەوەی ئەوان پێیان خۆشە با شووی پێ بکەن، بە مەرجێک لە خێڵی هۆزی باوکانیان بێت. ");
INSERT INTO ckb_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","میراتی نەوەی ئیسرائیل لە هۆزێکەوە بۆ هۆزێکی دیکە ناگوازرێتەوە، بەڵکو نەوەی ئیسرائیل هەریەکە پابەندی میراتی هۆزی باوکانی دەبێت. ");
INSERT INTO ckb_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","هەر کچێکیش لە هۆزەکانی نەوەی ئیسرائیل میراتی وەرگرت، ئەوا دەبێتە ژنی یەکێک لە خێڵی هۆزی باوکی، هەتا نەوەی ئیسرائیل هەریەکە ببێتە میراتگری میراتی باوکانی. ");
INSERT INTO ckb_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","هیچ میراتێک لە هۆزێکەوە بۆ هۆزێکی دیکە ناگوازرێتەوە، بەڵکو هۆزەکانی نەوەی ئیسرائیل هەریەکە پابەندی میراتی خۆی دەبێت.» ");
INSERT INTO ckb_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","وەک یەزدان فەرمانی بە موسا کرد، کچانی سەلۆفحاد ئاوایان کرد. ");
INSERT INTO ckb_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","مەحلە و تیرزە و حۆگلە و میلکە و نۆعا کە کچانی سەلۆفحادن بوونە ژنی ئامۆزاکانیان؛ ");
INSERT INTO ckb_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","بوونە ژن لە خێڵەکانی نەوەی مەنەشەی کوڕی یوسف، ئیتر میراتەکەیان لە خێڵ و هۆزی باوکانیان مایەوە. ");
INSERT INTO ckb_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","ئەمە ئەو فەرمان و ڕێسایانەیە کە یەزدان فەرمانی بە نەوەی ئیسرائیل کرد، بە دەستی موسا لە دەشتی مۆئاب لەسەر ڕووباری ئوردون بەرامبەر ئەریحا.");
INSERT INTO ckb_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","ئەمە ئەو وتانەیە کە موسا بە نەوەی ئیسرائیلی گوت، لە بەری ڕۆژهەڵاتی ڕووباری ئوردون، لە دەشتودەر لە عەراڤا، بەرامبەر بە سوف لەنێوان پاران و تۆفەل و لاڤان و حەچێرۆت و دی زاهاڤ. ");
INSERT INTO ckb_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","(لە حۆرێڤەوە لەسەر ڕێگای کێوی سێعیر بۆ قادێش بەرنێعە گەشتێکی یازدە ڕۆژەیە.) ");
INSERT INTO ckb_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","لە یەکی مانگی یازدەی ساڵی چلەمین، موسا وەک هەموو ئەوەی یەزدان فەرمانی پێ کردبوو لەگەڵ نەوەی ئیسرائیلدا دوا. ");
INSERT INTO ckb_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","ئەمە دوای ئەوە بوو کە سیحۆنی پاشای ئەمۆرییەکانی بەزاند کە لە حەشبۆن فەرمانڕەوا بوو، عۆگی پاشای باشانی شکاند کە لە عەشتارۆت فەرمانڕەوا بوو لە ئەدرەعی. ");
INSERT INTO ckb_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","موسا لە بەری ڕۆژهەڵاتی ڕووباری ئوردون لە خاکی مۆئابدا دەستی بە ڕوونکردنەوەی ئەم فێرکردنە کرد و گوتی: ");
INSERT INTO ckb_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","یەزدانی پەروەردگارمان لە حۆرێڤ پێی فەرمووین: «ئیتر بەسە! ماوەیەکی زۆرە لەم کێوە دانیشتوون، ");
INSERT INTO ckb_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","ڕووتان وەربگێڕن و کۆچ بکەن و بڕۆن بۆ ناوچە شاخاوییەکانی ئەمۆرییەکان و دەرودراوسێکانی لە عەراڤا و چیا و زوورگەکانی خۆرئاوا و نەقەب و کەناری دەریای خاکی کەنعان و لوبنان هەتا ڕووباری گەورە، واتا ڕووباری فورات. ");
INSERT INTO ckb_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","بڕوانن ئەوا خاکەکەم لەپێش داناون، بڕۆنە ناوی و دەست بەسەر ئەو خاکەدا بگرن کە یەزدان سوێندی بۆ ئیبراهیم و ئیسحاق و یاقوبی باوباپیرانتان خوارد کە بەوان و نەوەکانی دواتریان بدات.» ");
INSERT INTO ckb_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","لەو کاتەدا لەگەڵتاندا دوام و گوتم، «ناتوانم بە تەنها بارتان هەڵبگرم، ");
INSERT INTO ckb_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","یەزدانی پەروەردگارتان زۆری کردوون و ئەوەتا ئەمڕۆ ئێوە وەک ئەستێرەی ئاسمانن لە زۆریدا. ");
INSERT INTO ckb_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","با یەزدانی پەروەردگاری باوباپیرانتان هەزار قات زیاترتان بکات و بەرەکەتدارتان بکات، هەروەک بەڵێنی پێدان، ");
INSERT INTO ckb_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","بەڵام چۆن بە تەنها قورسایی و بارگرانی و ناکۆکییەکانتان هەڵبگرم؟ ");
INSERT INTO ckb_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","لە هۆزەکانتان پیاوی دانا و تێگەیشتوو و ڕێزدار هەڵبژێرن و لەسەرتان دایاندەنێم.» ");
INSERT INTO ckb_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","ئێوەش وەڵامتان دامەوە و گوتتان، «ئەوەی گوتت باشە، با بیکەین.» ");
INSERT INTO ckb_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","جا پیاوە گەورەکانی هۆزەکانی ئێوەم برد، پیاوانی دانا و ڕێزدار، ئەوانم کرد بە سەرۆک بەسەرتانەوە، کاربەدەست بەسەر هەزاران و سەدان و پەنجایان و دەیان و کوێخاکان بۆ هۆزەکانتان. ");
INSERT INTO ckb_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","لەو کاتەشدا فەرمانم بە دادوەرەکانتان کرد و گوتم: «گوێ لە داوا و سکاڵای گەلەکەتان بگرن و بە ڕاستودروستی دادوەرییان بکەن، جا چ داواکە لەنێوان دوو ئیسرائیلیدا بێت یان لەنێوان ئیسرائیلییەک و نامۆیەکدا بێت. ");
INSERT INTO ckb_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","لە دادوەریدا لایەنگری مەکەن، وەک یەک گوێ لە گەورە و بچووک بگرن، لە کەس مەترسن، دادوەریکردن هی خودایە و ئەو داوایانەی بۆتان زەحمەت بێت، ئەوا بۆ منی دەهێنن هەتا گوێم لێی بێت.» ");
INSERT INTO ckb_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","لەو کاتەشدا فەرمانم پێکردن سەبارەت بە هەموو ئەو شتانەی کە دەیکەن. ");
INSERT INTO ckb_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","ئینجا لە حۆرێڤ کۆچمان کرد و ئەو چۆڵەوانییە مەزنە ترسناکەمان گرتەبەر کە لە ڕێگای ناوچە شاخاوییەکانی ئەمۆرییەکان بینیتان، هەروەک یەزدانی پەروەردگارمان فەرمانی پێ کردین و هاتین هەتا قادێش بەرنێعە. ");
INSERT INTO ckb_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","پێم گوتن: «ئەوا هاتنە ناوچە شاخاوییەکانی ئەمۆرییەکان کە یەزدانی پەروەردگارمان پێمان دەدات. ");
INSERT INTO ckb_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","بڕوانن! یەزدانی پەروەردگارتان خاکەکەی لەبەردەمتان داناوە، سەربکەون و دەستی بەسەردا بگرن، هەروەک یەزدانی پەروەردگاری باوباپیرانتان پێی فەرموون. مەترسن و ورە بەرمەدەن.» ");
INSERT INTO ckb_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","جا هەمووتان هاتنە لای من و گوتتان: «با چەند پیاوێک لەپێش خۆمان بنێرین بۆ ئەوەی سیخوڕیەتی خاکەکەمان بۆ بکەن و هەواڵی ئەو ڕێگایەمان بۆ بهێننەوە کە پێیدا دەڕۆین و ئەو شارۆچکانەی بۆی دەچین.» ");
INSERT INTO ckb_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","ئەو قسەیەم بەلاوە باش بوو، دوازدە پیاوم لێ دەرهێنان، لە هەر هۆزێک پیاوێک. ");
INSERT INTO ckb_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","جا چوون و سەرکەوتنە سەر ناوچە شاخاوییەکە و هاتنە دۆڵی ئەشکۆل و سیخوڕییان کرد و ");
INSERT INTO ckb_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","لەگەڵ دەستیان لە بەروبوومی خاکەکەیان بۆ هێناینەوە و هەواڵیان پێ ڕاگەیاندینەوە و گوتیان: «ئەو خاکەی یەزدانی پەروەردگارمان پێمان دەدات، باشە.» ");
INSERT INTO ckb_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","بەڵام ئێوە ڕازی نەبوون سەربکەون و لە فەرمانی یەزدانی پەروەردگارتان یاخی بوون و ");
INSERT INTO ckb_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","لەناو چادرەکانتان کەوتنە بۆڵەبۆڵ و گوتتان: «یەزدان ڕقی لە ئێمەیە لەبەر ئەوە ئێمەی لە خاکی میسر دەرهێنا هەتا بمانداتە دەستی ئەمۆرییەکان و لەناومان ببەن. ");
INSERT INTO ckb_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","بۆ کوێ سەردەکەوین؟ براکانمان ورەیان ڕووخاندین و گوتیان: ”گەلێکی لە ئێمە مەزنتر و باڵا بەرزترن، شارەکان مەزن و شوورادارن هەتا ئاسمان، هەروەها لەوێ نەوەی عەناقمان بینی.“» ");
INSERT INTO ckb_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","منیش پێم گوتن: «مەتۆقن و لێیان مەترسن. ");
INSERT INTO ckb_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","یەزدانی پەروەردگارتان کە لەپێشتانەوە دەڕوات، ئەو بۆتان دەجەنگێت، بەگوێرەی هەموو ئەوەی لەپێش چاوتان لە میسر بۆی کردن، ");
INSERT INTO ckb_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","هەروەها لە دەشتودەر کە بینیتان چۆن یەزدانی پەروەردگارتان هەڵیگرتن هەروەک باوک کوڕەکەی هەڵدەگرێت، لە هەموو ئەو ڕێگایەی گرتتانەبەر هەتا هاتنە ئەم شوێنە.» ");
INSERT INTO ckb_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","لەگەڵ ئەوەشدا بڕواتان بە یەزدانی پەروەردگارتان نەبوو، ");
INSERT INTO ckb_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","ئەوەی لە ڕێگا لەپێشتانەوە چوو هەتا شوێنێکتان بۆ بدۆزێتەوە بۆ چادرهەڵدانتان، لە شەودا لەناو ئاگردا بۆ ئەوەی ئەو ڕێگایەتان پیشان بدات کە پێیدا دەڕۆن و لە ڕۆژیشدا لەناو هەور. ");
INSERT INTO ckb_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","جا یەزدان گوێی لە دەنگی قسەکانتان بوو، تووڕە بوو و سوێندی خوارد و فەرمووی: ");
INSERT INTO ckb_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","«هیچ کەسێک لەم خەڵکە لەم نەوە بەدکارە ئەو خاکە چاکە نابینێت کە سوێندم خوارد بیدەم بە باوباپیرانتان، ");
INSERT INTO ckb_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","تەنها کالێبی کوڕی یەفونە نەبێت، ئەو دەیبینێت و ئەو خاکە دەدەمە ئەو کە پێی لێناوە و دەیدەمە کوڕەکانیشی، چونکە بە هەموو دڵییەوە بەدوای یەزدان کەوت.» ");
INSERT INTO ckb_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","بەهۆی ئێوەوە یەزدان لە منیش تووڕە بوو و فەرمووی: «تۆش بۆ ئەوێ ناچیت. ");
INSERT INTO ckb_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","یەشوعی کوڕی نون کە لەبەردەمت وەستاوە دەچێتە ئەوێ، هانی بدە، چونکە خاکەکە وەک میرات بۆ ئیسرائیل دابەش دەکات، ");
INSERT INTO ckb_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","بەڵام منداڵەکانتان کە گوتتان دەبنە دیل و کوڕەکانتان ئەوانەی هەتا ئەمڕۆ چاکە و خراپەیان نەزانیوە، ئەوان دەچنە ئەوێ و دەیدەمە ئەوان و ئەوان دەستی بەسەردا دەگرن، ");
INSERT INTO ckb_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","بەڵام ئێوە ڕووتان وەربگێڕن و کۆچ بکەن بۆ دەشتودەر، لەسەر ڕێگای دەریای سوور.» ");
INSERT INTO ckb_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","جا وەڵامتان دایەوە و بە منتان گوت: «گوناهمان سەبارەت بە یەزدان کرد، ئێمە دەچین و دەجەنگین هەروەک یەزدانی پەروەردگارمان فەرمانی بە ئێمە کردووە.» بۆیە هەریەکەتان خۆی بە چەک و تفاقی جەنگ بەست، واتانزانی سەرکەوتن بۆ ناوچەی شاخاوییەکە ئاسانە! ");
INSERT INTO ckb_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","بەڵام یەزدان پێی فەرمووم، «پێیان بڵێ: ”مەڕۆن و مەجەنگن، چونکە من لەگەڵتان نابم، نەوەک لەبەردەم دوژمنتان ببەزن.“» ");
INSERT INTO ckb_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","جا قسەم لەگەڵ کردن و گوێتان نەگرت، بەڵکو لە فەرمانی یەزدان یاخی بوون و لووت بەرز بوون و بۆ ناوچەی شاخاوییەکە سەرکەوتن. ");
INSERT INTO ckb_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","جا ئەمۆرییەکانی دانیشتووی ئەو شاخانە پەلاماریان دان و دەریانپەڕاندن، هەروەک پوورە هەنگی کێوی دەیکات و لە سێعیرەوە تێکیان شکاندن هەتا حۆرما. ");
INSERT INTO ckb_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","ئینجا گەڕانەوە و گریان لەبەردەم یەزدان، بەڵام یەزدان گوێی لە دەنگتان نەگرت و گوێی بۆ شل نەکردن. ");
INSERT INTO ckb_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","ماوەیەکی درێژ لە قادێش دانیشتن بە قەد ئەو ڕۆژانەی تێیدا مانەوە. ");
INSERT INTO ckb_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","ئینجا ڕوومان وەرگێڕا و کۆچمان کرد بۆ دەشتودەر لەسەر ڕێگای دەریای سوور، هەروەک یەزدان پێی گوتم، ڕۆژانێکی زۆر بە دەوری ناوچە شاخاوییەکانی سێعیردا سووڕاینەوە. ");
INSERT INTO ckb_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","ئینجا یەزدان پێی فەرمووم: ");
INSERT INTO ckb_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","«بەسە ئیتر بەدەوری ئەم ناوچە شاخاوییانە مەسووڕێنەوە، بەرەو باکوور ڕووتان وەربگێڕن و ");
INSERT INTO ckb_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","فەرمان بە گەل بدە و بڵێ: ”ئێوە خەریکن بە سنووری نەوەی عیسۆی برایانتان تێدەپەڕن کە لە سێعیر نیشتەجێن و لێتان دەترسن، بەڵام زۆر ئاگاداربن، ");
INSERT INTO ckb_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","هێرشیان مەکەنە سەر، چونکە شوێن پێیەکتان لە خاکی ئەوان نادەمێ، چونکە ناوچە شاخاوییەکانی سێعیرم بە میرات بە عیسۆ داوە. ");
INSERT INTO ckb_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","خۆراکیان بە زیو لێ دەکڕن هەتا بیخۆن و ئاویان بە زیو لێ وەردەگرن هەتا بیخۆنەوە.“» ");
INSERT INTO ckb_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","یەزدانی پەروەردگارتان بەرەکەتداری کردوون لە هەموو کارێکی دەستەکانتان، ڕێ و شوێنتان دەزانێت لەم چۆڵەوانییە مەزنە، ئەم چل ساڵە یەزدانی پەروەردگارتان لەگەڵتاندا بووە و لە هیچ شتێکتان کەم نەبووە. ");
INSERT INTO ckb_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","ئینجا بەسەر نەوەی عیسۆی برایانمان تێپەڕین کە لە چیای سێعیر نیشتەجێن. ڕێگای عەراڤامان بەجێهێشت کە لە ئێلەت و عەچیۆن گەڤەرەوە دێت، ئینجا سووڕاینەوە و بە ڕێگای چۆڵەوانی مۆئابدا ڕۆیشتین. ");
INSERT INTO ckb_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","یەزدان پێی فەرمووم: «مۆئاب هەراسان مەکە و جەنگ لە دژیان بەرپا مەکە، چونکە هیچ بەشێک لە خاکەکەیان بە میرات بە تۆ نادەم، چونکە عارم بە میرات بە نەوەی لوت داوە.» ");
INSERT INTO ckb_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","(پێشتر ئێمییەکان تێیدا نیشتەجێ بوون، گەلێکی بەهێز و زۆر بوون، وەک عەناقییەکان باڵا بەرز بوون. ");
INSERT INTO ckb_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","وەک عەناقییەکان، ئەوانیش بە ڕفائییەکان ناسراو بوون، بەڵام مۆئابییەکان هەر بە ئێمییەکان بانگیان دەکردن. ");
INSERT INTO ckb_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","پێشتر حۆرییەکان لە سێعیر نیشتەجێ بوون، بەڵام نەوەی عیسۆ لەبەردەم خۆیان دەریانپەڕاندن و لەناویانبردن و لە شوێنیان نیشتەجێ بوون، وەک ئەوەی ئیسرائیل کردیان بە خاکی میراتیان کە یەزدان پێیدابوون.) ");
INSERT INTO ckb_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","یەزدانیش پێی فەرمووم: «ئێستا هەستن و لە دۆڵی زەرەد بپەڕنەوە،» ئێمەش لە دۆڵی زەرەد پەڕینەوە. ");
INSERT INTO ckb_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","لەو کاتەوە کە قادێش بەرنێعمان بەجێهێشت هەتا لە دۆڵی زەرەد پەڕینەوە سی و هەشت ساڵ بوو، هەتا هیچ لەو نەوەیە لە پیاوانی جەنگ لەناو ئۆردوگاکە نەمان، هەروەک یەزدان سوێندی بۆ خواردن، ");
INSERT INTO ckb_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","یەزدانیش لە دژیان بوو، بۆ لەناوبردنیان لەناو ئۆردوگاکە هەتا لەناوچوون. ");
INSERT INTO ckb_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","جا کاتێک هەموو پیاوانی جەنگ لەنێو گەل بە مردن لەناوچوون، ");
INSERT INTO ckb_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","یەزدان پێی فەرمووم: ");
INSERT INTO ckb_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","«تۆ ئەمڕۆ تێدەپەڕیت لە عار کە لە سنووری مۆئابە، ");
INSERT INTO ckb_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","کاتێک لەلای عەمۆنییەکان نزیک کەوتیتەوە هەراسانیان مەکە و هێرشیان مەکە سەر، چونکە هیچت لە خاکی عەمۆنییەکان بە میرات نادەمێ، چونکە بە میرات بە نەوەی لوتم داوە.» ");
INSERT INTO ckb_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","(ئەویش بە خاکی ڕفائییەکان دادەنرێت، پێشتر ڕفائییەکان تێیدا نیشتەجێ بوون، بەڵام عەمۆنییەکان بە زەمزومییەکان ناویان دەبردن، ");
INSERT INTO ckb_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","گەلێکی بەهێز و زۆر بوون و وەک عەناقییەکان باڵا بەرز بوون، بەڵام یەزدان لەبەردەم عەمۆنییەکاندا لەناوی بردن، جا دەریانکردن و لە شوێنیان نیشتەجێ بوون. ");
INSERT INTO ckb_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","یەزدان وەک ئەوەی بۆ نەوەی عیسۆی کرد کە لە سێعیردا نیشتەجێن، کاتێک حۆرییەکانی لە بەرامبەریان تێکشکاند، جا دەریانکردن و هەتا ئەمڕۆ لە شوێنیان نیشتەجێن. ");
INSERT INTO ckb_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","هەروەها عەڤییەکان کە لە گوندەکان نیشتەجێ بوون هەتا غەزە، کەفتۆرییەکان کە لە کەفتۆرەوە هاتبوون لەناویانبردن و لە شوێنیان نیشتەجێ بوون.) ");
INSERT INTO ckb_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","«هەستن، کۆچ بکەن و لە دەربەندی ئەرنۆن بپەڕنەوە. بڕوانە، ئەوا سیحۆنی پاشای حەشبۆنی ئەمۆری و خاکەکەیم بە دەستتانەوە داوە، دەستی بەسەردا بگرن و لە دژی ئەو جەنگ بەرپا بکەن. ");
INSERT INTO ckb_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","ئەمڕۆ دەستپێدەکەم، ترس و سامتان دەخەمە بەرچاوی ئەو گەلانەی لەژێر هەموو ئاسمانن، ئەوانە گوێیان لە هەواڵتان دەبێت لێتان دەترسن و لەبەر ئێوە دەلەرزن.» ");
INSERT INTO ckb_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","جا نێردراوانم لە چۆڵەوانی قەدێمۆتەوە بۆ لای سیحۆنی پاشای حەشبۆن نارد بە وشەی ئاشتیەوە و گوتم: ");
INSERT INTO ckb_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","«ڕێمان بدە بە خاکەکەتدا تێپەڕین و تەنها بە ڕێگای سەرەکیدا دەڕۆین، لانادەین نە بەلای ڕاست و نە بەلای چەپدا، ");
INSERT INTO ckb_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","بە زیو خۆراکمان پێ دەفرۆشیت هەتا بیخۆین و بە زیو ئاومان دەدەیتێ هەتا بیخۆینەوە، تەنها بە پێیەکانمان تێدەپەڕین، ");
INSERT INTO ckb_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","هەروەک ئەوەی نەوەی عیسۆ کە لە سێعیردا نیشتەجێن و مۆئابییەکان کە لە عاردا نیشتەجێن بۆیان کردووین، هەتا لە ڕووباری ئوردون دەپەڕینەوە بۆ ئەو خاکەی یەزدانی پەروەردگارمان پێی بەخشیوین.» ");
INSERT INTO ckb_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","بەڵام سیحۆنی پاشای حەشبۆن ڕازی نەبوو ڕێگامان بدات پێیدا بڕۆین، چونکە یەزدانی پەروەردگارتان وای لێکرد کەللەڕەق بێت و دڵی توند کرد تاکو بیداتە دەستتان، هەروەک چۆن ئەمڕۆ بووە. ");
INSERT INTO ckb_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","یەزدان پێی فەرمووم: «بڕوانە، ئەوا دەستم پێکرد سیحۆن و خاکەکەی بدەمە دەستت، ئێستا دەستپێبکە و دەست بەسەر خاکەکەیدا بگرە.» ");
INSERT INTO ckb_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","کاتێک سیحۆن و هەموو سوپاکەی لە یەهەچ بۆ جەنگ لە دژمان هاتنە دەرەوە، ");
INSERT INTO ckb_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","یەزدانی پەروەردگارمان ئەوانی دا بە دەستمان و ئێمەش لێمان دان لەگەڵ کوڕەکانی و هەموو سوپاکەی. ");
INSERT INTO ckb_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","لەو کاتەدا هەموو شارۆچکەکانیمان گرت و لە هەموو شارۆچکەیەک پیاو و ژن و منداڵمان بە تەواوی قڕکرد، نەمانهێشت کەس دەرباز بێت، ");
INSERT INTO ckb_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","بەڵام ئاژەڵە ماڵییەکانمان بۆ خۆمان تاڵان کرد و دەستکەوتی شارۆچکەکانمان برد. ");
INSERT INTO ckb_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","لە عەرۆعێرەوە کە لەسەر لێواری دەربەندی ئەرنۆنە و ئەو شارۆچکەیەی لە دۆڵەکەیە هەتا گلعاد، هیچ شارێک نەبوو لەپێشمان بوەستێت، یەزدانی پەروەردگارمان هەمووی دا بە دەستمان، ");
INSERT INTO ckb_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","بەڵام لە خاکی عەمۆنییەکان نزیک نەکەوتینەوە، هەموو لایەکی دۆڵی یەبۆق و شارۆچکەکانی ناوچە شاخاوییەکە و هەموو ئەوەی یەزدانی پەروەردگارمان فەرمانی پێدا. ");
INSERT INTO ckb_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","ئینجا ڕوومان وەرگێڕا و بە ڕێگای باشاندا سەرکەوتین، جا عۆگی پاشای باشان لەگەڵ هەموو سوپاکەی هاتنە دەرەوە بۆ بەرەنگاربوونەوەمان لە ئەدرەعی. ");
INSERT INTO ckb_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","یەزدانیش پێی فەرمووم، «لێی مەترسە، چونکە خۆی و هەموو سوپاکەی و خاکەکەیم داوەتە دەستت، ئەوەی پێ دەکەیت کە بە سیحۆنی پاشای ئەمۆرییەکانت کرد کە لە حەشبۆن فەرمانڕەوا بوو.» ");
INSERT INTO ckb_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","جا یەزدانی پەروەردگارمان، عۆگی پاشای باشان و هەموو سوپاکەی دایە دەستمان و لێماندا و نەمانهێشت کەس دەرباز بێت. ");
INSERT INTO ckb_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","لەو کاتەشدا دەستمان بەسەر هەموو شارەکانیدا گرت. هیچ شارێک لەو شەست شارە نەمایەوە کە لێیان نەستێنین، واتا هەموو هەرێمی ئەرگۆڤ شانشینی عۆگ لە باشان. ");
INSERT INTO ckb_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","هەموو ئەو شارانە شوورابەند بوون بە شوورای بەرز و دەروازە و شمشیرەیان هەبوو، لەگەڵ ئەوەشدا چەند گوندێکی زۆر شوورایان نەبوو. ");
INSERT INTO ckb_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","جا بە تەواوی قڕمان کرد، وەک ئەوەی بە سیحۆنی پاشای حەشبۆنمان کرد، لە هەموو شارێکدا پیاو و ژن و منداڵەکانمان بە تەواوی قڕکرد. ");
INSERT INTO ckb_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","بەڵام هەموو ئاژەڵە ماڵییەکان و دەستکەوتی شارەکانیان بۆ خۆمان تاڵان کرد. ");
INSERT INTO ckb_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","لەو کاتەدا ئەو خاکەی کە لە بەری ڕۆژهەڵاتی ڕووباری ئوردون لە دەربەندی ئەرنۆنەوە هەتا چیای حەرمۆنمان لە دەستی ئەم دوو پاشایەی ئەمۆرییەکان دەرهێنا. ");
INSERT INTO ckb_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","(سەیدائییەکان بە حەرمۆن دەڵێن سیریۆن و ئەمۆرییەکانیش پێی دەڵێن سنیر.) ");
INSERT INTO ckb_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","هەموو شارۆچکەکانی دەشت و هەموو گلعاد و هەموو باشان هەتا سەلخە و ئەدرەعی، دوو شارەکەی شانشینی عۆگ لە باشاندا دەستمان بەسەردا گرت. ");
INSERT INTO ckb_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","(عۆگی پاشای باشان بە تەنها مابووەوە لە پاشماوەی ڕفائییەکان، قەرەوێڵەکەی لە ئاسن دروستکرابوو، هەتا ئێستا لە شاری ڕەبەی عەمۆنییەکانە، درێژییەکەی نۆ باڵ و پانییەکەی چوار باڵە بە باڵی پیاو.) ");
INSERT INTO ckb_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","لەو کاتەی دەستمان بەسەر ئەو خاکەدا گرت، هەرێمێکم دایە ڕەئوبێنییەکان و گادییەکان، لە سەرووی عەرۆعێرەوە کە لەسەر دەربەندی ئەرنۆنە و نیوەی ناوچە شاخاوییەکانی گلعاد و شارۆچکەکانی لە هەرێمەکەدا بوو. ");
INSERT INTO ckb_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","ئەوەشی لە گلعاد مایەوە و هەموو باشانی شانشینی عۆگ دامە نیوەی هۆزی مەنەشە. (هەموو هەرێمی ئەرگۆڤ لەگەڵ هەموو باشان بوو، کە بە خاکی ڕفائییەکان ناودەبردرا. ");
INSERT INTO ckb_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","یائیری نەوەی مەنەشە دەستی بەسەر هەموو هەرێمی ئەرگۆڤدا گرت هەتا سنووری گەشوورییەکان و مەعکاتییەکان و بە ناوی خۆیەوە ناوی لێنا، هەتا ئەمڕۆش باشان بە حەڤۆت یائیر ناودەبردرێت.) ");
INSERT INTO ckb_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","گلعادیشم دا بە ماکیر. ");
INSERT INTO ckb_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","لە گلعادیشەوە هەتا دەربەندی ئەرنۆن، ناوەڕاستی دۆڵەکە سنوور بوو، هەتا ڕووباری یەبۆق سنووری عەمۆنییەکان دامە ڕەئوبێنییەکان و گادییەکان. ");
INSERT INTO ckb_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","عەراڤا و ڕووباری ئوردونیش سنووری ڕۆژئاواییەکەی بوو، لە کینەرەتەوە هەتا دەریای عەراڤا، دەریای مردوو، لەژێر بنارەکانی پسگە. ");
INSERT INTO ckb_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","ئەو کاتە فەرمانم پێکردن و گوتم، «یەزدانی پەروەردگارتان ئەم خاکەی پێداون بۆ ئەوەی دەستی بەسەردا بگرن. هەموو پاڵەوانەکان بە چەکەوە لەپێش نەوەی ئیسرائیلی برایانتان دەپەڕنەوە، ");
INSERT INTO ckb_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","بەڵام ژن و منداڵ و ئاژەڵە ماڵییەکانتان، (زانیومە ئاژەڵی ماڵی زۆرتان هەیە،) ئەوا لە شارۆچکەکانتان دەمێننەوە کە پێم داون، ");
INSERT INTO ckb_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","هەتا یەزدان براکانیشتان وەک ئێوە بحەسێنێتەوە، ئەوانیش دەست بەسەر ئەو خاکەی پشتی ڕووباری ئوردوندا بگرن کە یەزدانی پەروەردگارتان دەیانداتێ. ئینجا هەرکەسە دەگەڕێتەوە لای موڵکی خۆی کە پێم داوە.» ");
INSERT INTO ckb_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","لەو کاتەشدا فەرمانم بە یەشوع کرد و گوتم، «چاوەکانت هەموو ئەوەیان بینی کە یەزدانی پەروەردگارتان بەم دوو پاشایەی کرد، یەزدان هەمان شت دەکات بە هەموو ئەو پاشایەتییانەی تۆ بۆیان دەپەڕیتەوە. ");
INSERT INTO ckb_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","لێیان مەترسن، چونکە یەزدانی پەروەردگارتان بۆتان دەجەنگێت.» ");
INSERT INTO ckb_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","لەو کاتەدا لە یەزدان پاڕامەوە و گوتم: ");
INSERT INTO ckb_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","«ئەی یەزدانی باڵادەست، تۆ دەستت پێ کرد مەزنی و دەستی بەهێزت بە خزمەتکارەکەت پیشان بدەیت، چونکە چ خودایەک لە ئاسمان و لەسەر زەوی وەک کردەوەکان و تواناکانی تۆ دەکات؟ ");
INSERT INTO ckb_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","تکایە لێمگەڕێ با بپەڕمەوە و ئەو خاکە چاکەی لە بەری ڕۆژئاوای ڕووباری ئوردونە، ئەو ناوچە شاخاوییە جوانە و لوبنان، ببینم.» ");
INSERT INTO ckb_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","بەڵام یەزدان بەهۆی ئێوەوە لێم هەڵچوو و گوێی لێ نەگرتم، بەڵکو یەزدان پێی فەرمووم: «بەسە! ئیتر لەبارەی ئەم بابەتەوە لەگەڵم مەدوێ. ");
INSERT INTO ckb_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","سەربکەوە بۆ لووتکەی پسگە و بەرەو ڕۆژئاوا و باکوور و باشوور و ڕۆژهەڵات سەر بڵند بکە و بە چاوەکانت خاکەکە ببینە، بەڵام لەم ڕووباری ئوردونە مەپەڕەوە. ");
INSERT INTO ckb_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","ئەرکی ڕابەرایەتی بە یەشوع بسپێرە و بەهێزی بکە و هانی بدە، چونکە ئەو لەپێش ئەم گەلە دەپەڕێتەوە و ئەو خاکەکەیان بۆ دابەش دەکات کە تۆ دەیبینیت.» ");
INSERT INTO ckb_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","جا لە دۆڵەکە بەرامبەر بێت‌پەعۆر ماینەوە. ");
INSERT INTO ckb_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","ئێستاش ئەی ئیسرائیل، گوێ لەم فەرز و یاسایانە بگرە کە من فێرتان دەکەم هەتا بەجێی بهێنن و بژین و بچنە ناو ئەو خاکە و دەستی بەسەردا بگرن کە یەزدانی پەروەردگاری باوباپیرانتان دەتانداتێ. ");
INSERT INTO ckb_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","ئەو قسانەی من فەرمانتان پێ دەکەم هیچی لێ زیاد و کەم مەکەن، هەتا فەرمانەکانی یەزدانی پەروەردگارتان بپارێزن کە من فەرمانتان پێ دەکەم. ");
INSERT INTO ckb_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","چاوەکانتان بینییان یەزدان چی لە بەعل‌پەعۆردا کرد، هەرچی دوای بەعلی پەعۆر کەوت یەزدانی پەروەردگارتان لەنێوتاندا بە تەواوی لەناوی برد، ");
INSERT INTO ckb_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","بەڵام ئێوە کە خۆتان بە یەزدانی پەروەردگارتانەوە گرتووە ئەوا هەمووتان ئەمڕۆ زیندوون. ");
INSERT INTO ckb_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","بڕوانە، فەرز و یاساکانم فێرکردن هەروەک یەزدانی پەروەردگارم فەرمانی پێ کردم بۆ ئەوەی ئاوا بکەن لەو خاکەی کە دەچنە ناوی هەتا دەستی بەسەردا بگرن، ");
INSERT INTO ckb_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","ئیتر بیانپارێزن و جێبەجێیان بکەن، چونکە ئەوە دانایی و تێگەیشتوویی ئێوەیە لەبەرچاوی ئەو گەلانەی کە گوێیان لەو هەموو فەرزانە دەبێت و دەڵێن، «ئەم گەلە مەزنە گەلێکی دانا و تێگەیشتوون.» ");
INSERT INTO ckb_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","چ گەلێکی مەزن هەیە، خوداوەندێکی نزیکی هەبێت وەک یەزدانی پەروەردگارمان لە هەموو داواکارییەکانمان؟ ");
INSERT INTO ckb_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","هەروەها چ گەلێک مەزنە و ئەو فەرز و یاسا ڕاستودروستانەی هەیە وەک ئەو هەموو فێرکردنەی من ئەمڕۆ لەبەردەمتان دایدەنێم؟ ");
INSERT INTO ckb_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","بەڵام ئاگاداربە و باش خۆت بپارێزە هەتا ئەو شتانە لەبیر نەکەیت کە بە چاوەکانت بینیت، بۆ ئەوەی هەموو ڕۆژانی ژیانت لە دڵت دەرنەچێت و منداڵەکانت و منداڵی منداڵەکانتی پێ فێر بکە. ");
INSERT INTO ckb_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","ئەو ڕۆژەت لە یاد بێت کە لە بەرامبەر یەزدانی پەروەردگارت ڕاوەستایت لە حۆرێڤ، کە یەزدان پێی فەرمووم: «گەلم بۆ کۆبکەرەوە و وشەکانی منیان بخەرە بەر گوێ، بۆ ئەوەی فێر بن هەموو ئەو ڕۆژانەی کە لەسەر زەوی زیندوون لێم بترسن و منداڵەکانیان فێر بکەن.» ");
INSERT INTO ckb_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","ئێوەش هاتنە پێش و لە خوارەوەی کێوەکە ڕاوەستان و کێوەکە هەتا ناو جەرگەی ئاسمان بە ئاگر داگیرسا بوو، بە تاریکی و تەمی چڕ، ");
INSERT INTO ckb_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","جا یەزدان لەنێو ئاگرەکەوە لەگەڵتاندا دوا و ئێوە گوێتان لە دەنگی وشەکان دەگرت، بەڵام هیچ شێوەیەکی ئەوتان نەبینی، تەنها دەنگ نەبێت. ");
INSERT INTO ckb_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","ئەویش پەیمانەکەی خۆی پێ ڕاگەیاندن کە فەرمانی پێ کردن کاری پێ بکەن، دە ڕاسپاردەکە کە لەسەر دوو تەختەی بەردی نووسی. ");
INSERT INTO ckb_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","لەو کاتەدا یەزدان فەرمانی بە منیش کرد، بۆ ئەوەی فەرز و یاساکانتان فێر بکەم هەتا لەو خاکەدا کاری پێ بکەن کە لە ڕووباری ئوردون بۆی دەپەڕنەوە هەتا دەستی بەسەردا بگرن. ");
INSERT INTO ckb_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","ئەو ڕۆژەی یەزدان لە حۆرێڤ لەنێو ئاگرەکەوە لەگەڵتاندا دوا، ئێوە هیچ وێنەیەکتان نەبینی، بۆیە باش خۆتان بپارێزن ");
INSERT INTO ckb_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","نەوەک گەندەڵ بن و پەیکەرێکی تاشراو بۆ خۆتان دروستبکەن، وێنەی نموونەیەک لە شێوەی نێرینەیەک یان مێینەیەک، ");
INSERT INTO ckb_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","یان لە شێوەی ئاژەڵێک لەوانەی لەسەر زەوین یان لە شێوەی باڵندەیەکی باڵدار لەوانەی لە ئاسمان دەفڕن، ");
INSERT INTO ckb_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","یان لە شێوەی خشۆکێک لەوانەی لەسەر زەوییە، یان لە شێوەی ماسییەک لەوانەی لەناو ئاو لەژێر زەوی. ");
INSERT INTO ckb_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","هەروەها نەوەک چاو بۆ ئاسمان بەرز بکەیتەوە و تەماشای خۆر و مانگ و ئەستێرەکان و هەموو ئەو شتانەی کە لە ئاسماندا ڕێکخراون بکەیت، کە یەزدانی پەروەردگارت بە هەموو گەلانی داوە کە لەژێر هەموو ئاسمانن و هەڵبخەڵەتێی و کڕنۆشی بۆ ببەیت و بیپەرستیت. ");
INSERT INTO ckb_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","یەزدان ئێوەی برد و لە کوورەی ئاسنەوە لە میسرەوە دەریهێنان هەتا وەک ئەمڕۆ ببنە گەلی میراتی ئەو. ");
INSERT INTO ckb_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","بەهۆی ئێوەشەوە یەزدان لێم تووڕە بوو و سوێندی خوارد کە من لە ڕووباری ئوردون ناپەڕمەوە و ناچمە ناو خاکە باشەکەی کە یەزدانی پەروەردگارتان وەک میرات پێتان دەدات، ");
INSERT INTO ckb_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","جا من لەم خاکەدا دەمرم و لە ڕووباری ئوردون ناپەڕمەوە، بەڵام ئێوە دەپەڕنەوە و دەست بەسەر ئەو زەوییە باشەدا دەگرن. ");
INSERT INTO ckb_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","ئاگاداربن، نەوەک پەیمانی یەزدانی پەروەردگارتان لەبیر بکەن کە لەگەڵ ئێوەی بەست و پەیکەرێکی تاشراو بۆ خۆتان دروستبکەن لە وێنەی هەر شتێک لەوانەی یەزدانی پەروەردگارتان لێی قەدەغە کردن، ");
INSERT INTO ckb_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","چونکە یەزدانی پەروەردگارتان ئاگرێکی بەتینە، خودایەکی ئیرەدارە. ");
INSERT INTO ckb_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","ئەگەر منداڵ و منداڵی منداڵتان بوو و کاتتان درێژەی کێشا لە خاکەکەدا و گەندەڵ بوون و پەیکەری تاشراوتان دروستکرد، وێنەی هەر شتێک و خراپەتان کرد لەبەرچاوی یەزدانی پەروەردگارتان و پەستتان کرد، ");
INSERT INTO ckb_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","ئەمڕۆ ئاسمان و زەوی دەکەم بە شایەت بەسەرتانەوە کە ئێوە بە خێرایی لەناودەچن لەو خاکەی لە ڕووباری ئوردونەوە بۆی دەپەڕنەوە هەتا دەستی بەسەردا بگرن، درێژە بە ڕۆژانتان نادەن لەسەری و بێگومان لەناودەچن. ");
INSERT INTO ckb_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","یەزدان پەرشوبڵاوتان دەکاتەوە لەنێو گەلاندا، جا ژمارەیەکی کەمتان لێ دەمێنێتەوە لەنێو ئەو نەتەوانەی یەزدان دەتانباتە ناویان، ");
INSERT INTO ckb_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","لەوێ بت دەپەرستن دروستکراوی دەستی خەڵکە لە دار و لە بەرد کە نابینن و نابیستن و ناخۆن و بۆن ناکەن. ");
INSERT INTO ckb_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","بەڵام ئەگەر لەوێوە ڕووتان لە یەزدان کرد، خودای خۆتان، ئەوا بۆتان دەردەکەوێت، ئەگەر بە هەموو دڵ و لە ناخەوە بەدوایدا گەڕان. ");
INSERT INTO ckb_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","کاتێک تەنگانەتان هاتە سەر و لە ڕۆژانی دواتر کە هەموو ئەو شتانەتان بەسەرهات، ئەوا بۆ لای یەزدانی پەروەردگارتان دەگەڕێنەوە و گوێڕایەڵی ئەو دەبن، ");
INSERT INTO ckb_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","چونکە یەزدانی پەروەردگارتان خودایەکی بە بەزەییە، بەجێتان ناهێڵێت و لەناوتان نابات و پەیمانی باوباپیرانتان لەبیر ناکات کە سوێندی بۆیان خوارد. ");
INSERT INTO ckb_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","جا سەبارەت بە ڕۆژانی پێشوو پرسیار بکە کە پێش تۆ بووە، لەو ڕۆژەوەی خودا مرۆڤی لەسەر زەوی بەدیهێنا و لەمپەڕی ئاسمان هەتا ئەوپەڕی، ئایا وەک ئەم شتە مەزنە یان هاوتای بیستراوە؟ ");
INSERT INTO ckb_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","ئایا هیچ گەلێک گوێیان لە دەنگی خودا بووە لەنێو ئاگرەوە قسە بکات، وەک تۆ گوێت لێ بوو و ژیابێت؟ ");
INSERT INTO ckb_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","ئایا هیچ خودایەک هەیە کە هەوڵی دابێت بە تاقیکردنەوە و بە نیشانە و پەرجوو، بە جەنگ و دەستێکی پۆڵایین، بە بازووێکی بەهێز و بە کاری مەزن و سامناک، نەتەوەیەک لەنێو نەتەوەیەکی دیکەدا بۆ خۆی تەرخان بکات، وەک هەموو ئەوەی یەزدانی پەروەردگارتان لەبەرچاوتان لە میسر بۆ ئێوەی کرد؟ ");
INSERT INTO ckb_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","ئەم شتانەت پیشان درا بۆ ئەوەی بزانیت کە یەزدان خۆی خودایە، بێجگە لەو یەکێکی دیکە نییە. ");
INSERT INTO ckb_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","لە ئاسمانەوە بەم جۆرەی کرد گوێبیستی بن، تاکو تەمبێت بکات، لەسەر زەویش ئاگری مەزنی خۆی پیشان دایت و لەنێو ئاگرەوە گوێت لە وشەکانی بوو، ");
INSERT INTO ckb_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","هەروەها لەبەر ئەوەی باوباپیرانی تۆی خۆشویست و نەوەی ئەوانی هەڵبژارد لە دوایان، بە ئامادەبوونی خۆی و بە هێزە مەزنەکەی خۆی تۆی لە میسرەوە دەرهێنا، ");
INSERT INTO ckb_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","بۆ ئەوەی گەلی مەزنتر و بەهێزتر لە خۆت لەبەردەمت دەربکات و بتهێنێت و وەک ئەمڕۆ خاکەکەیانت وەک میرات بداتێ. ");
INSERT INTO ckb_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","جا ئەمڕۆ بزانە و لە دڵەوە لێی وردببنەوە، یەزدان خۆی خودایە لە ئاسمان لە سەرەوە و لەسەر زەوی لە خوارەوە و هیچ خودایەکی دیکە نییە. ");
INSERT INTO ckb_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","فەرزەکان و فەرمانەکانی بەجێبهێنە کە من ئەمڕۆ فەرمانت پێدەدەم، هەتا چاکە لەگەڵ خۆت و منداڵەکانت بکات لەدوای خۆت و تەمەن درێژ بیت لەسەر ئەو خاکەی یەزدانی پەروەردگارت بۆ هەتاهەتایە پێت دەدات. ");
INSERT INTO ckb_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","ئیتر موسا لە بەری ڕۆژهەڵاتی ڕووباری ئوردون سێ شاری جیا کردەوە، ");
INSERT INTO ckb_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","بۆ ئەوەی ئەو کەسەی کە بەبێ ئەنقەست دراوسێکەی خۆی دەکوژێت بۆ ئەوێ ڕابکات، کە پێشتر ڕقی لێی نەبووەتەوە، جا بۆ یەکێک لەو شارانە هەڵدێت و دەژیێت. ");
INSERT INTO ckb_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","ئەمە ئەو شارانە بوون: شاری بەچەر لە دەشتودەر لە زەوی دەشتایی بۆ ڕەئوبێنییەکان و ڕامۆت لە گلعاد بۆ گادییەکان و گۆلان لە باشان بۆ مەنەشەییەکان. ");
INSERT INTO ckb_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","ئەمەش ئەو فێرکردنەیە کە موسا لەبەردەم نەوەی ئیسرائیلدا داینا. ");
INSERT INTO ckb_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","ئەمە ئەو یاسا و فەرز و حوکمانەیە کە موسا بە نەوەی ئیسرائیلی گوت کاتێک لە میسر هاتنە دەرەوە، ");
INSERT INTO ckb_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","لە بەری ڕۆژهەڵاتی ڕووباری ئوردون لە دۆڵەکە بەرامبەر بێت‌پەعۆر لە خاکی سیحۆنی پاشای ئەمۆرییەکان کە لە حەشبۆن فەرمانڕەوا بوو، ئەوەی موسا و نەوەی ئیسرائیل شکاندیان لە کاتی هاتنەدەرەوەیان لە میسر. ");
INSERT INTO ckb_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","دەستیان بەسەر خاکەکەیدا گرت لەگەڵ خاکی عۆگی پاشای باشان، هەردوو پاشاکەی ئەمۆرییەکان کە لە بەری ڕۆژهەڵاتی ڕووباری ئوردون بوون. ");
INSERT INTO ckb_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","لە عەرۆعێرەوە کە لەسەر لێواری دەربەندی ئەرنۆنە هەتا چیای سیریۆن کە حەرمۆنە، ");
INSERT INTO ckb_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","هەروەها هەموو عەراڤا لە بەری ڕۆژهەڵاتی ڕووباری ئوردونەوە هەتا دەریای مردوو لەژێر بنارەکانی پسگە. ");
INSERT INTO ckb_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","موسا هەموو ئیسرائیلی بانگکرد و پێی گوتن: ئەی نەوەی ئیسرائیل، گوێ لەو فەرز و یاسایانە بگرن کە ئەمڕۆ دەیخوێنمەوە و گوێتان لێیە و فێری بن و ئاگاداربن هەتا کاری پێ بکەن. ");
INSERT INTO ckb_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","یەزدانی پەروەردگارمان پەیمانێکی لە حۆرێڤ لەگەڵ بەستین، ");
INSERT INTO ckb_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","ئەو پەیمانەی لەگەڵ باوباپیرانمان نەبەست، بەڵکو لەگەڵ ئێمە کە ئەمڕۆ لێرەین و هەموومان زیندووین. ");
INSERT INTO ckb_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","یەزدان ڕووبەڕوو لە کێوەکە لەنێو ئاگرەوە لەگەڵتاندا دوا، ");
INSERT INTO ckb_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","لەو کاتەدا من لەنێوان یەزدان و ئێوەدا ڕاوەستا بووم هەتا فەرمایشتی یەزدانتان پێ ڕابگەیەنم، چونکە لەبەر ئاگرەکە ترسان و سەرنەکەوتن بۆ کێوەکە. فەرمووی: ");
INSERT INTO ckb_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","«من یەزدانی پەروەردگارتانم کە لە خاکی میسرەوە دەرمهێنان، لە خاکی کۆیلایەتییەوە. ");
INSERT INTO ckb_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","«هیچ کەسێکتان خودای دیکەی بێجگە لە منتان نەبێت. ");
INSERT INTO ckb_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","پەیکەر بۆ خۆتان دروستمەکەن، نە لە هیچ شێوەیەکی ئەوانەی لە ئاسمانن لە سەرەوە، نە ئەوانەی لەسەر زەوین لە خوارەوە، نە ئەوانەی لەناو ئاون لەژێر زەوییەوە. ");
INSERT INTO ckb_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","کڕنۆشیان بۆ مەبەن و مەیانپەرستن، چونکە منی یەزدانی پەروەردگارتان خودایەکی ئیرەدارم، سزای گوناهی باوکان لەسەر نەوەکانیشان جێبەجێ دەکەم هەتا نەوەی سێیەم و چوارەمی ناحەزەکانم، ");
INSERT INTO ckb_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","بەڵام خۆشەویستی نەگۆڕ بۆ هەزاران لە خۆشەویستانم دەردەخەم، ئەوانەی گوێڕایەڵی ڕاسپاردەکانم دەبن. ");
INSERT INTO ckb_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","ناوی یەزدانی پەروەردگارتان بۆ شتی پووچ مەهێنن، چونکە ئەو کەسانە لەلای یەزدان ئەستۆپاک نابن کە بۆ شتی پوچەڵ ناوی دەهێنن. ");
INSERT INTO ckb_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","ڕۆژی شەممە بپارێزن، تاکو بە پیرۆزی ڕایبگرن، هەروەک یەزدانی پەروەردگارتان فەرمانی پێ کردن. ");
INSERT INTO ckb_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","شەش ڕۆژ ئیش دەکەن و هەموو کارەکەتان دەکەن، ");
INSERT INTO ckb_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","بەڵام ڕۆژی حەوتەم شەممەیە بۆ یەزدانی پەروەردگارتان، هیچ کارێک مەکەن، خۆتان و کوڕ و کچ و خزمەتکار و کارەکەر و گا و مانگا و گوێدرێژ و هەر ئاژەڵێکتان و ئەو نامۆیەی لەناو دەروازەی شارەکەتانە هیچ کارێک مەکەن، بۆ ئەوەی خزمەتکار و کارەکەرەکەشتان وەک ئێوە بحەسێنەوە. ");
INSERT INTO ckb_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","لە یادتان بێت کە ئێوەش کۆیلە بوون لە خاکی میسر و یەزدانی پەروەردگارتان بە دەستێکی پۆڵایین و بازووێکی بەهێز لەوێ دەریهێنان، لەبەر ئەوە یەزدانی پەروەردگارتان فەرمانی پێ کردن ڕۆژی شەممە بپارێزن. ");
INSERT INTO ckb_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","ڕێزی دایک و باوکتان بگرن هەروەک یەزدانی پەروەردگارتان فەرمانی پێ کردن، بۆ ئەوەی تەمەن درێژ بن و چاکە بێتە ڕێتان لەو خاکەی یەزدانی پەروەردگارتان پێتان دەدات. ");
INSERT INTO ckb_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","مەکوژن. ");
INSERT INTO ckb_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","داوێنپیسی مەکەن. ");
INSERT INTO ckb_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","دزی مەکەن. ");
INSERT INTO ckb_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","بە درۆ شایەتی لەسەر کەس مەدەن. ");
INSERT INTO ckb_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","چاو مەبڕنە ژنی کەس. چاو مەبڕنە ماڵ و کێڵگە و خزمەتکار و کارەکەر و گا و مانگا و گوێدرێژی هیچ کەسێک و هەر شتێک کە هی کەسێکی دیکە بێت.» ");
INSERT INTO ckb_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","یەزدان بەم ڕاسپاردانە لەگەڵ هەموو کۆمەڵەکەتاندا دوا، لە کێوەکە لەناو ئاگر و هەور و تاریکی چڕ و دەنگێکی بەزر، هیچی زیاد نەکرد و لەسەر دوو تەختەی بەرد نووسی و پێیدام. ");
INSERT INTO ckb_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","کاتێک گوێتان لە دەنگەکە بوو لەناو تاریکییەوە و کێوەکە بە ئاگر گڕی گرتبوو، هەموو سەرۆک هۆزەکانتان و پیرەکانتان هاتن بۆ لام. لێم هاتنە پێش و ");
INSERT INTO ckb_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","گوتتان، «ئەوەتا یەزدانی پەروەردگارمان شکۆمەندی و مەزنی خۆی پیشان داین و گوێمان لە دەنگی بوو لەناو ئاگرەوە، ئەمڕۆ بینیمان خودا لەگەڵ مرۆڤ دەدوێت و مرۆڤەکەش دەژیێت، ");
INSERT INTO ckb_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","بەڵام ئێستا بۆچی بمرین؟ ئەو ئاگرە مەزنە دەمانخوات. ئەگەر لەوە زیاتر گوێمان لە دەنگی یەزدانی پەروەردگارمان بوو ئەوا دەمرین، ");
INSERT INTO ckb_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","چونکە کێ وەک ئێمە لە هەموو ئادەمیزاد گوێی لە دەنگی خودای زیندوو بووە لەناو ئاگرەوە بدوێت و ژیابێت؟ ");
INSERT INTO ckb_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","تۆ بڕۆ پێشەوە و گوێ لە هەموو ئەوە بگرە کە یەزدانی پەروەردگارمان دەیڵێت و هەموو ئەوەی یەزدانی پەروەردگارمان پێت دەڵێت، پێمانی بڵێ، جا گوێ دەگرین و کاری پێدەکەین.» ");
INSERT INTO ckb_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","یەزدانیش گوێی لە قسەکانتان بوو کاتێک قسەتان لەگەڵ کردم و یەزدان پێی فەرمووم، «گوێم لە دەنگی قسەی ئەم گەلە بوو کە لەگەڵتدا دوان. لە هەموو ئەوەی گوتیان باش بوو، ");
INSERT INTO ckb_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","خۆزگە هەمیشە دڵیان ئاوا دەبوو هەتا لێم بترسن و هەموو فەرمانەکانم بپارێزن، تاکو بۆ هەتاهەتایە چاکە بێتە سەر ڕێگای خۆیان و کوڕەکانیان. ");
INSERT INTO ckb_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","«بڕۆ پێیان بڵێ: ”بگەڕێنەوە چادرەکانی خۆتان،“ ");
INSERT INTO ckb_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","بەڵام تۆ لێرە لەگەڵم بوەستە، باسی هەموو فەرمان و فەرز و یاساکانت بۆ دەکەم کە فێریان دەکەیت و ئەوان لەو خاکەدا پەیڕەوی دەکەن کە من پێیان دەدەم هەتا دەستی بەسەردا بگرن.» ");
INSERT INTO ckb_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","ئیتر ئاگاداربن بۆ ئەوەی هەموو ئەوە بکەن هەروەک یەزدانی پەروەردگارتان فەرمانی پێ کردن، بەلای ڕاست و چەپدا لامەدەن، ");
INSERT INTO ckb_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","هەموو ئەو ڕێگایەی یەزدانی پەروەردگارتان فەرمانی پێ کردن دەیگرنەبەر، هەتا بژین و چاکە بێتە ڕێگاتان و درێژە بە ڕۆژانتان بدەن لەو خاکەی دەستی بەسەردا دەگرن. ");
INSERT INTO ckb_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","ئەمە ئەو فەرمان و فەرز و یاسایانەیە کە یەزدانی پەروەردگارتان فەرمانی دا فێرتانی بکەم، هەتا لەو خاکەدا پەیڕەوی بکەن کە لە ڕووباری ئوردونەوە بۆی دەپەڕنەوە هەتا دەستی بەسەردا بگرن، ");
INSERT INTO ckb_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","هەتا لە یەزدانی پەروەردگارتان بترسن و هەموو فەرز و فەرمانەکانی بەجێبهێنن کە من بە ئێوە و منداڵ و نەوەکانتان فەرمانیان پێدەدەم هەموو ڕۆژانی ژیانتان، هەتا ڕۆژانتان درێژ بێت. ");
INSERT INTO ckb_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","جا ئەی ئیسرائیل، گوێ بگرن و ئاگاداربن بە گوێڕایەڵیتان، هەتا چاکە بێتە ڕێگاتان و زۆر زۆرتر ببن، هەروەک یەزدانی پەروەردگاری باوباپیرانتان بەڵێنی پێدان لەو خاکەی شیر و هەنگوینی لێ دەڕژێت. ");
INSERT INTO ckb_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","ئەی ئیسرائیل گوێ بگرن، یەزدانی پەروەردگارمان یەک یەزدانە، ");
INSERT INTO ckb_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","جا بە هەموو دڵ و بە هەموو گیان و بە هەموو تواناتانەوە یەزدانی پەروەردگارتان خۆشبوێ. ");
INSERT INTO ckb_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","با ئەم ڕاسپاردانەی من ئەمڕۆ فەرمانتان پێ دەکەم لەسەر دڵتان بێت و ");
INSERT INTO ckb_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","بۆ منداڵەکانتانی بگێڕنەوە و باسی بکەن کاتێک لە ماڵ دادەنیشن و کاتێک بە ڕێگادا دەڕۆن و کاتێک دەخەون و کاتێک هەڵدەستن، ");
INSERT INTO ckb_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","وەک نیشانەیەکیش لەسەر دەستتان بیبەستن و با گوڵنگ بێت بە ناوچەوانتانەوە و ");
INSERT INTO ckb_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","لەسەر چوارچێوەی دەرگای ماڵ و حەوشەکانتان بینووسن. ");
INSERT INTO ckb_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","کاتێکیش یەزدانی پەروەردگارتان ئێوەی هێنا بۆ ئەو خاکەی کە سوێندی بۆ ئیبراهیم و ئیسحاق و یاقوبی باوباپیرانتان خوارد کە بتانداتێ، بۆ شاری مەزن و چاک کە ئێوە بنیادتان نەناوە، ");
INSERT INTO ckb_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","ماڵی پڕ لە خێروبێر کە ئێوە پڕتان نەکردووە، بیری لێدراو کە ئێوە لێتان نەداوە، مێو و زەیتوون کە ئێوە نەتانڕواندووە، کە کاتێک خواردتان تێر بوون، ");
INSERT INTO ckb_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","جا ئاگاداربن نەوەک یەزدان لەبیر بکەن کە لە خاکی میسر لە ماڵی کۆیلەیی دەریهێنان. ");
INSERT INTO ckb_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","لە یەزدانی پەروەردگارتان دەترسن و تەنها ئەو دەپەرستن و بە ناوی ئەوەوە سوێند دەخۆن. ");
INSERT INTO ckb_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","بەدوای خودای دیکەدا مەڕۆن، لە خوداوەندەکانی ئەو نەتەوانەی لە دەوروبەرتانن، ");
INSERT INTO ckb_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","چونکە یەزدانی پەروەردگارتان کە لەنێوتاندایە، خودایەکی ئیرەدارە، نەوەک تووڕەیی یەزدانی پەروەردگارتان بجۆشێت بەسەرتان و لەسەر ڕووی ئەم خاکە لەناوتان ببات. ");
INSERT INTO ckb_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","یەزدانی پەروەردگارتان تاقی مەکەنەوە وەک لە مەسا تاقیتان کردەوە. ");
INSERT INTO ckb_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","بە تەواوی فەرمان و یاسا و فەرزەکانی یەزدانی پەروەردگارتان بەجێبهێنن کە فەرمانی پێ کردوون. ");
INSERT INTO ckb_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","ئەوەی ڕاستە و باشە لەبەرچاوی یەزدانی پەروەردگارتان بیکەن، هەتا چاکە بێتە ڕێگاتان و بچنە ناوەوە و دەست بەسەر ئەو خاکە چاکەدا بگرن کە یەزدان سوێندی بۆ باوباپیرانتان خوارد، ");
INSERT INTO ckb_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","کە هەموو دوژمنانتان لەبەردەم ڕابماڵێت، وەک یەزدان فەرمووی. ");
INSERT INTO ckb_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","لە داهاتوودا، کاتێک منداڵەکانتان لێیان پرسین و گوتیان: «ئەو یاسا و فەرز و حوکمانە چین کە یەزدانی پەروەردگارمان فەرمانی پێ کردن؟» ");
INSERT INTO ckb_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","بە منداڵەکانتان دەڵێن: «لە میسر کۆیلەی فیرعەون بووین و یەزدان بە دەستێکی بەهێز لە میسرەوە دەریهێناین و ");
INSERT INTO ckb_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","یەزدان لەبەرچاومان نیشانە و پەرجووی مەزن و سامناکی بەسەر میسر و فیرعەون و هەموو ماڵەکەی نارد و ");
INSERT INTO ckb_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","لەوێوە دەریهێناین هەتا بمانهێنێت و ئەو خاکەمان بداتێ کە بۆ باوباپیرانمان سوێندی خواردبوو. ");
INSERT INTO ckb_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","جا یەزدان فەرمانی پێ کردین هەموو ئەو فەرزانە بەجێبهێنین و لە یەزدانی پەروەردگارمان بترسین، هەتا هەموو ڕۆژان چاکەمان بێتە ڕێ و بمانهێڵێتەوە وەک ئەمڕۆ، ");
INSERT INTO ckb_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","ڕاستودروستیشمان بۆ دەبێت ئەگەر هەموو ئەو فەرمانانەمان پاراست هەتا لەبەردەم یەزدانی پەروەردگارمان بیکەین، هەروەک فەرمانی پێ کردین.» ");
INSERT INTO ckb_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","کاتێک یەزدانی پەروەردگارتان ئێوەی هێنایە ئەو خاکەی کە دەچنە ناوی هەتا دەستی بەسەردا بگرن و گەلانی زۆری لەبەردەمتان دەرکرد، حیتی و گرگاشی و ئەمۆری و کەنعانی و پریزی و حیڤی و یەبوسییەکان، حەوت گەلی لە خۆتان مەزنتر و بەهێزتر، ");
INSERT INTO ckb_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","کاتێک یەزدانی پەروەردگارتان ئەوانی دایە دەستتان و ئێوەش لێتان دان، دەبێت بە تەواوی قڕیان بکەن، پەیمانیان لەگەڵ مەبەستن و بەزەییتان پێیاندا نەیەتەوە. ");
INSERT INTO ckb_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","ژن و ژنخوازییان لەگەڵ مەکەن، کچتان مەدەنە کوڕیان و کچیان بۆ کوڕتان مەهێنن، ");
INSERT INTO ckb_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","چونکە کوڕەکانتان لە من هەڵدەگێڕنەوە و خودای دیکە دەپەرستن، جا تووڕەیی یەزدان لێتان دەجۆشێت و خێرا لەناوتان دەبات. ");
INSERT INTO ckb_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","بەڵام دەبێت ئاوایان پێ بکەن، قوربانگاکانیان بڕووخێنن و بەردە تەرخانکراوەکانیان بشکێنن و ستوونە ئەشێراکانیان ببڕنەوە و بتەکانیان بە ئاگر بسووتێنن، ");
INSERT INTO ckb_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","چونکە ئێوە گەلێکی پیرۆزن بۆ یەزدانی پەروەردگارتان. لەنێو هەموو گەلانی سەر ڕووی زەوی یەزدانی پەروەردگارتان ئێوەی هەڵبژارد تاکو بۆی ببن بە گەلی ئەو، ببنە گەنجینەیەکی تایبەت. ");
INSERT INTO ckb_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","یەزدان دڵی پێتانەوە بەند بوو و هەڵیبژاردن، نەک لەبەر ئەوەی لە هەموو گەلان زۆرترن، چونکە لە ڕاستیدا ئێوە لە هەموو گەلان کەمترن. ");
INSERT INTO ckb_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","بەڵام لە خۆشەویستی یەزدان بوو بۆتان و پاراستنی ئەو سوێندەی بۆ باوباپیرانی ئێوەی خوارد، یەزدان بە دەستێکی بەهێز دەریهێنان و ئێوەی لە خاکی کۆیلایەتی کڕییەوە، لە دەستی فیرعەونی پاشای میسر. ");
INSERT INTO ckb_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","جا بزانن کە یەزدانی پەروەردگارتان خۆی خودایە، خودای وەفادارییە، ئەوەی پەیمانی خۆشەویستییەکەی هەتا هەزار نەوە دەباتەسەر، بۆ ئەوانەی خۆشیان دەوێت و فەرمانەکانی دەپارێزن. ");
INSERT INTO ckb_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","بەڵام سزای ئەوانە دەدات کە ڕقیان لێی دەبێتەوە و دەستبەجێ لەناویان دەبات، ئەوەی ڕقی لێی بێتەوە لەسەری ناوەستێت و تۆڵەی لێ دەکاتەوە. ");
INSERT INTO ckb_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","جا فەرمان و فەرز و یاساکان بەجێبهێنن کە من ئەمڕۆ فەرمانتان پێدەدەم بۆ ئەوەی جێبەجێی بکەن. ");
INSERT INTO ckb_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","ئەگەر ئێوە گوێ لەو یاسایانە بگرن و بیپارێزن و جێبەجێ بکەن، ئەوا یەزدانی پەروەردگارتان پەیمانی خۆشەویستییەکەی بۆ ئێوە دەباتەسەر، وەک چۆن سوێندی بۆ باوباپیرانتان خوارد. ");
INSERT INTO ckb_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","ئێوەی خۆشدەوێت، بەرەکەتدارتان دەکات و زۆرتان دەکات و بەروبوومی سکتان و بەروبوومی زەوییەکەتان، دانەوێڵە و شەرابی نوێ و زەیتتان، بەروبوومی گوێرەکەی گاگەلەکەتان و مەڕ و بزنەکانتان بەرەکەتدار دەکات لەسەر ئەو خاکەی کە سوێندی بۆ باوباپیرانتان خوارد کە بە ئێوەی دەدات. ");
INSERT INTO ckb_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","ئێوە بەرەکەتدار دەبن لە سەرووی هەموو گەلان، وەجاخکوێر و نەزۆک نە لە ئێوە و نە لەناو ئاژەڵە ماڵییەکانتاندا نابێت، ");
INSERT INTO ckb_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","یەزدان هەموو نەخۆشییەکتان لێ دوور دەخاتەوە و هەموو دەردە خراپەکانی میسر کە ئێوە زانیتان نایخاتە سەرتان، بەڵکو دەیخاتە سەر هەموو ناحەزانتان، ");
INSERT INTO ckb_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","هەموو ئەو گەلانەش لەناودەبەن کە یەزدانی پەروەردگارتان دەیانداتە دەستتان، بەزەییتان پێیان نایەتەوە و خوداوەندەکەیان ناپەرستن، چونکە ئەوە تەڵەیە بۆ ئێوە. ");
INSERT INTO ckb_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","ئەگەر لە دڵی خۆتاندا گوتتان، «ئەو گەلانە لە ئێمە بەهێزترن، چۆن دەتوانین دەریانبکەین؟» ");
INSERT INTO ckb_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","لێیان مەترسن، ئەوەتان بەبیر بێتەوە یەزدانی پەروەردگارتان چی بە فیرعەون و بە هەموو میسرییەکان کرد، ");
INSERT INTO ckb_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","ئەو ئەزموونە مەزنانەی چاوەکانتان بینییان و ئەو نیشانە و پەرجووانە، هەروەها ئەو دەستە پۆڵایین و بازووە بەهێزەی کە یەزدانی پەروەردگارتان ئێوەی پێ دەرهێنا. یەزدانی پەروەردگارتان ئاوا لە هەموو ئەو گەلانە دەکات کە ئێوە لێیان دەترسن. ");
INSERT INTO ckb_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","هەروەها یەزدانی پەروەردگارتان زەردەواڵە دەنێرێتە سەر ئەو گەلانە تاوەکو تەنانەت ئەو بەجێماوانەش لەناو ببات کە خۆیان لە ئێوە شاردووەتەوە. ");
INSERT INTO ckb_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","لێیان مەترسن، چونکە یەزدانی پەروەردگارتان لەنێوتانە و خودایەکی مەزن و سامناکە. ");
INSERT INTO ckb_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","یەزدانی پەروەردگارتان کەمە کەمە ئەو گەلانە لەبەردەمتان دەردەکات، ناتوانن دەستبەجێ لەناویان ببەن نەوەک دڕندەی کێویتان بەسەرەوە زۆر بێت. ");
INSERT INTO ckb_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","بەڵام یەزدانی پەروەردگارتان دەیانداتە دەست و سەرلێشێوانێکی مەزنیان دەکەوێتە ناو، هەتا لەناودەچن. ");
INSERT INTO ckb_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","پاشاکانیشیان دەخاتە ناو دەستتان، جا لەژێر ئاسمان ناویان دەسڕنەوە، کەس نابێت بتوانێت لە دژتان بوەستێت هەتا لەناویان دەبەن. ");
INSERT INTO ckb_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","وێنەی خوداوەندەکانیان بە ئاگر دەسووتێنن، چاو مەبڕنە ئەو زێڕ و زیوەی کە لەسەریانە هەتا بۆ خۆتانی ببەن، نەوەک پێی بکەونە داوەوە، چونکە لەلای یەزدانی پەروەردگارتان قێزەونە. ");
INSERT INTO ckb_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","هیچ قێزەونێکیش مەهێننە ناو ماڵەکانتانەوە نەوەک ئێوەش وەک ئەو بۆ قڕکردن تەرخان بکرێن، بەڵکو وەکو شتێکی قێزەون تەماشای بکەن و ڕقتان لێ ببێتەوە، چونکە بۆ قڕکردن تەرخان کراوە. ");
INSERT INTO ckb_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","ئاگاداربن بە جێبەجێکردنی هەموو ئەو فەرمانانەی من ئەمڕۆ فەرمانتان پێ دەکەم هەتا بژین و زۆر بن و ئەو خاکەی یەزدان سوێندی خواردووە بۆ باوباپیرانتان بچنە ناوی و دەستی بەسەردا بگرن. ");
INSERT INTO ckb_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","هەموو ئەو ڕێگایانەشتان لە یاد بێت، کە یەزدانی پەروەردگارتان لە ماوەی ئەم چل ساڵە لە چۆڵەوانیدا ئێوەی پێدا برد هەتا بێفیزتان بکات و هەڵتانبسەنگێنێت تاکو ئەوەی لەناو دڵتانە بیزانێت، ئاخۆ فەرمانەکانی پەیڕەو دەکەن یان نا. ");
INSERT INTO ckb_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","جا بێفیزی کردن و برسی کردن و مەنی دەرخوارد دان، کە پێشتر نەتاندەزانی و باوباپیرانتیشتان نەیاندەزانی تاکو فێرتان بکات کە مرۆڤ تەنها بە نان ناژیێت، بەڵکو بە هەر وشەیەک کە لە دەمی یەزدانەوە دێتە دەرەوە. ");
INSERT INTO ckb_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","جلەکانتان بەبەرتانەوە کۆن نەبوون و پێتان نەئاوسا لەم چل ساڵەدا، ");
INSERT INTO ckb_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","جا لە دڵتانەوە بزانن وەک چۆن مرۆڤ کوڕەکەی تەمبێ دەکات، ئاوا یەزدانی پەروەردگارتان تەمبێی کردن. ");
INSERT INTO ckb_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","فەرمانەکانی یەزدانی پەروەردگاریشتان پەیڕەو بکەن هەتا ڕێگاکانی بگرنەبەر و لێی بترسن، ");
INSERT INTO ckb_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","چونکە یەزدانی پەروەردگارتان دەتانهێنێتە خاکێکی باش، خاکێک کە جۆگەکان و گۆماوەکان و سەرچاوەی کانیاوەکان هەڵدەقوڵێنە نێو دۆڵ و چیاکان، ");
INSERT INTO ckb_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","خاکی گەنم و جۆ و مێو و هەنجیر و هەنار، خاکی زەیتی زەیتوون و هەنگوین. ");
INSERT INTO ckb_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","خاکێکە نانی کەمی تێدا ناخۆن و تێیدا پێویستیتان بە هیچ شتێک نابێت، خاکێک بەردەکانی ئاسنە و لە چیاکانی مس هەڵدەکۆڵن. ");
INSERT INTO ckb_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","جا کاتێک خواردتان و تێر بوون، ستایشی یەزدانی پەروەردگارتان دەکەن لەبەر ئەو خاکە باشەی پێیدان. ");
INSERT INTO ckb_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","ئاگاداربن نەوەک یەزدانی پەروەردگارتان لەبیر بکەن و فەرمان و یاسا و فەرزەکانی بەجێنەهێنن، ئەوەی من ئەمڕۆ فەرمانتان پێدەدەم، ");
INSERT INTO ckb_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","نەوەک کاتێک خواردتان و تێر بوون و خانووی خۆشتان دروستکرد و نیشتەجێ بوون و ");
INSERT INTO ckb_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","مانگا و مەڕتان زیادی کرد و زێڕ و زیوتان بۆ زیاد بوو، هەموو ئەوەی هەتانە زیاد بوو، ");
INSERT INTO ckb_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","لووتتان بەرز بێت و یەزدانی پەروەردگارتان لەبیر بچێت کە لە خاکی میسر لە ماڵی کۆیلەیی دەریهێنان. ");
INSERT INTO ckb_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","ئەوەی بە چۆڵەوانی مەزن و ترسناکدا ئێوەی برد، شوێنی ماری ژەهراوی و دووپشک و خاکی تینووێتی و بێ ئاو، ئەوەی لە بەردەئەستێ ئاوی بۆ دەرهێنان. ");
INSERT INTO ckb_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","ئەوەی لە چۆڵەوانی مەنی دەرخوارد دان کە باوباپیرانتان نەیاندەزانی، هەتا بێفیزتان بکات و هەڵتانبسەنگێنێت بۆ ئەوەی لە کۆتاییدا چاکەتان لەگەڵدا بکات. ");
INSERT INTO ckb_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","هەروەها نەوەک لە دڵی خۆتاندا بڵێن، «هێزی خۆمان و توانای دەستمان ئەم سامانەی بۆ دروستکردین،» ");
INSERT INTO ckb_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","بەڵکو یەزدانی پەروەردگارتان لە یاد بێت، ئەو هێزتان دەداتێ بۆ سامان دروستکردن، هەتا ئەو پەیمانەی خۆی بەجێبگەیەنێت کە سوێندی بۆ باوباپیرانتان خوارد وەک ئەمڕۆ. ");
INSERT INTO ckb_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","ئەگەر یەزدانی پەروەردگارتان لەبیر کرد و بەدوای خوداوەندانی دیکە کەوتن و پەرستتان و کڕنۆشتان بۆ بردن، ئەوا ئەمڕۆ شایەتیتان لەسەر دەدەم کە بێگومان لەناودەچن، ");
INSERT INTO ckb_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","وەک ئەو گەلانەی یەزدان لەبەردەمتان لەناویان دەبات، ئێوەش لەناو دەبردرێن لەبەر ئەوەی ئێوە گوێڕایەڵی یەزدانی پەروەردگارتان نەبوون. ");
INSERT INTO ckb_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","ئەی ئیسرائیل گوێ بگرن، ئەمڕۆ ئێوە خەریکن لە ڕووباری ئوردون دەپەڕنەوە هەتا بچنە ناوەوە و گەلەکانی ناوی دەربکەن، ئەوان لە ئێوە مەزنتر و بەهێزترن، شارەکانیان گەورە و شوورادارن هەتا ئاسمان. ");
INSERT INTO ckb_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","نەتەوەیەکی مەزن و باڵا بەرز، نەوەی عەناق، کە بەوانتان زانیوە و بیستووتانە کە گوتراوە: «کێ لە ڕووی نەوەی عەناق دەوەستێت؟» ");
INSERT INTO ckb_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","جا ئەمڕۆ بزانن کە یەزدانی پەروەردگارتان لەپێشتانەوە دەپەڕێتەوە وەک ئاگرێکی سووتێنەر، ئەو لەبەردەمتاندا لەناویان دەبات و زەلیلیان دەکات و ئێوەش دەریاندەکەن و بە خێرایی لەناویان دەبەن، هەروەک یەزدان بەڵێنی پێدان. ");
INSERT INTO ckb_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","کاتێک یەزدانی پەروەردگارتان لەبەردەمتاندا لایان دەبات، لە دڵی خۆتاندا مەڵێن، «لەبەر ڕاستودروستیمان یەزدان ئێمەی هێنایە ئێرە هەتا دەست بەسەر ئەم خاکەدا بگرین،» بەڵکو لەبەر بەدکاری ئەو گەلانەیە، یەزدان لەبەردەمتاندا دەریاندەکات. ");
INSERT INTO ckb_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","لەبەر ڕاستودروستی و دڵپاکیتان نییە کە دەچنە ناوەوە تاکو دەست بەسەر زەوییەکەیاندا بگرن، بەڵکو لەبەر بەدکاری ئەو گەلانەیە کە یەزدانی پەروەردگارتان لەبەردەمتان دەریاندەکات و هەتا ئەو بەڵێنەش جێبەجێ بکات کە یەزدان سوێندی لەسەر خوارد بۆ باوباپیرانتان، ئیبراهیم و ئیسحاق و یاقوب. ");
INSERT INTO ckb_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","جا بزانن لەبەر ڕاستودروستیتان نییە یەزدانی پەروەردگارتان ئەو خاکە باشەتان پێدەدات هەتا دەستی بەسەردا بگرن، چونکە ئێوە گەلێکی کەللەڕەقن. ");
INSERT INTO ckb_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","لە یادتان بێت و لەبیری مەکەن چۆن لە دەشتودەر یەزدانی پەروەردگارتان تووڕە کرد. لەو ڕۆژەوەی لە خاکی میسرەوە هاتنە دەرەوە و هەتا هاتنە ئەم شوێنە ئێوە لە یەزدان یاخین. ");
INSERT INTO ckb_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","تەنانەت لە حۆرێڤیش یەزدانتان تووڕە کرد و جا یەزدان لێتان تووڕە بوو هەتا ڕادەیەک ئامادە بوو لەناوتان ببات. ");
INSERT INTO ckb_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","کاتێک بۆ کێوەکە سەرکەوتم بۆ ئەوەی دوو تەختە بەردەکە، دوو تەختەکەی پەیمان کە یەزدان لەگەڵتانی بەست وەربگرم، چل شەو و چل ڕۆژ لە کێوەکە مامەوە و نانم نەخوارد و ئاوم نەخواردەوە. ");
INSERT INTO ckb_vpl VALUES ("DT9_10","006_9_10","DEU","9","10","10","یەزدانیش دوو تەختە بەردەکەی پێدام کە بە پەنجەی خودا نووسرا بوون و هەموو ئەو ڕاسپاردانەی لەسەر بوو کە یەزدان لە کێوەکە لەناو ئاگرەوە لە ڕۆژی کۆبوونەوەکە لەگەڵتاندا پێی دوا. ");
INSERT INTO ckb_vpl VALUES ("DT9_11","006_9_11","DEU","9","11","11","لە کۆتایی چل شەو و چل ڕۆژەکە، یەزدان دوو تەختە بەردەکە، دوو تەختەکەی پەیمانی دامێ. ");
INSERT INTO ckb_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","پاشان یەزدان پێی فەرمووم: «هەستە بە خێرایی لێرە بڕۆ خوارەوە، چونکە گەلەکەت ئەوەی تۆ لە میسرەوە دەرتهێنان گەندەڵ بوون، بە زوویی لەو ڕێگایە لایاندا کە فەرمانم پێکردن، بتێکی لەقاڵبدراویان بۆ خۆیان دروستکرد.» ");
INSERT INTO ckb_vpl VALUES ("DT9_13","006_9_13","DEU","9","13","13","هەروەها یەزدان پێی فەرمووم: «ئەم گەلەم بینی، بە ڕاستی گەلێکی کەللەڕەقن، ");
INSERT INTO ckb_vpl VALUES ("DT9_14","006_9_14","DEU","9","14","14","لێمگەڕێ لەناویان دەبەم و ناویان لەژێر ئاسمان دەسڕمەوە و دەتکەمە گەلێکی بەهێزتر و زۆرتر لەوان.» ");
INSERT INTO ckb_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","منیش ڕووم وەرگێڕا و لە کێوەکە هاتمە خوارەوە، کێوەکە بە ئاگر گڕی گرتبوو، دوو تەختەکەی پەیمانیشم بەدەستەوە بوو. ");
INSERT INTO ckb_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","جا ڕوانیم ئێوە سەبارەت بە یەزدانی پەروەردگارتان گوناهتان کردبوو، بتێکی داڕێژراوتان لە شێوەی گوێرەکەیەک بۆ خۆتان دروستکردبوو، بە زوویی لەو ڕێگایە لاتان دابوو کە یەزدان فەرمانی پێ کردبوون. ");
INSERT INTO ckb_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","منیش دوو تەختەکەم گرت و لە دەستم فڕێمدان و لەبەرچاوتان شکاندم. ");
INSERT INTO ckb_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","پاشان وەک یەکەم جار چل شەو و چل ڕۆژ لەبەردەم یەزدان کەوتم و نانم نەخوارد و ئاوم نەخواردەوە لەبەر هەموو ئەو گوناهانەی ئەنجامتان داوە، بەوەی لەبەردەم یەزدان خراپەتان کرد و پەستتان کرد. ");
INSERT INTO ckb_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","لەو تووڕەیی و جۆشانە ترسام کە یەزدان لێتان پەست ببوو بە ڕادەیەک کە ئامادە بوو لەناوتان ببات، بەڵام یەزدان ئەو جارەش گوێی لێ گرتم. ");
INSERT INTO ckb_vpl VALUES ("DT9_20","006_9_20","DEU","9","20","20","یەزدان لە هارونیش زۆر تووڕە بوو هەتا لەناوی ببات، جا لەو کاتەدا لە پێناوی هارونیش نزام کرد. ");
INSERT INTO ckb_vpl VALUES ("DT9_21","006_9_21","DEU","9","21","21","هەروەها گوناهەکەتان، واتا ئەو گوێرەکەیەی کە دروستتان کردبوو، من بردم و سووتاندم و کوتام و باش هاڕیم هەتا وەک تۆز نەرم بوو، ئینجا تۆزەکەیم هەڵدایە ناو ئەو جۆگەیەی لە کێوەکەوە دێتە خوارەوە. ");
INSERT INTO ckb_vpl VALUES ("DT9_22","006_9_22","DEU","9","22","22","هەروەها لە تەبعیرە و مەسا و قیبرۆت هەتەڤا یەزدانتان تووڕە کرد. ");
INSERT INTO ckb_vpl VALUES ("DT9_23","006_9_23","DEU","9","23","23","کاتێکیش یەزدان لە قادێش بەرنێعەوە ئێوەی نارد، فەرمووی: «سەربکەون و دەست بەسەر ئەو خاکەدا بگرن کە پێم داون.» بەڵام ئێوە لە فەرمانی یەزدانی پەروەردگارتان یاخی بوون و بڕواتان پێی نەکرد و گوێڕایەڵی ئەو نەبوون، ");
INSERT INTO ckb_vpl VALUES ("DT9_24","006_9_24","DEU","9","24","24","لەو ڕۆژەوەی ئێوەم ناسیوە، ئێوە لە دژی یەزدان یاخین. ");
INSERT INTO ckb_vpl VALUES ("DT9_25","006_9_25","DEU","9","25","25","ئەو چل شەو و چل ڕۆژە لەبەردەم یەزدان کەوتم، چونکە یەزدان فەرمووبووی لەناوتان دەبات. ");
INSERT INTO ckb_vpl VALUES ("DT9_26","006_9_26","DEU","9","26","26","نوێژم بۆ یەزدان کرد و گوتم، «ئەی یەزدانی باڵادەست، گەلەکەت و میراتەکەت لەناو مەبە کە بە توانای خۆت کڕیتەوە، ئەوەی بە دەستێکی بەهێز لە میسر دەرتهێنا. ");
INSERT INTO ckb_vpl VALUES ("DT9_27","006_9_27","DEU","9","27","27","خزمەتکارەکانت بەبیر بێتەوە، ئیبراهیم و ئیسحاق و یاقوب، ئاوڕ لە کەللەڕەقی ئەم گەلە مەدەوە یان لە بەدکارییەکەیان یان لە گوناهەکەیان، ");
INSERT INTO ckb_vpl VALUES ("DT9_28","006_9_28","DEU","9","28","28","نەوەک خەڵکی ئەو وڵاتەی لێت دەرهێناین بڵێت: ”لەبەر ئەوەی یەزدان نەیتوانی بیانباتە ناو ئەو خاکەی کە بەڵێنی پێدابوون و لەبەر ئەوەی ڕقی لێیان بوو، دەریهێنان هەتا لە چۆڵەوانیدا بیانمرێنێت.“ ");
INSERT INTO ckb_vpl VALUES ("DT9_29","006_9_29","DEU","9","29","29","بەڵام ئەوان گەلی تۆن و میراتی تۆن کە بە توانا مەزنەکەت و دەستە بەهێزەکەت دەرتهێنان.» ");
INSERT INTO ckb_vpl VALUES ("DT10_1","006_10_1","DEU","10","1","1","لەو کاتەدا یەزدان پێی فەرمووم: «دوو تەختە بەردی وەک ئەوانەی یەکەم بۆ خۆت بتاشە و سەربکەوە سەر کێوەکە بۆ لای من، سندوقێکیش لە دار بۆ خۆت دروستبکە، ");
INSERT INTO ckb_vpl VALUES ("DT10_2","006_10_2","DEU","10","2","2","جا لەسەر دوو تەختەکە ئەو وشانە دەنووسمەوە کە لەسەر دوو تەختەکەی یەکەم جار بوون و تۆ شکاندت و بیانخە ناو سندوقەکە.» ");
INSERT INTO ckb_vpl VALUES ("DT10_3","006_10_3","DEU","10","3","3","منیش سندوقێکم لە داری ئەکاسیا دروستکرد، دوو تەختە بەردی وەک ئەوانەی یەکەم جارم تاشی و بۆ شاخەکە سەرکەوتم و دوو تەختەکەشم لە دەست بوو. ");
INSERT INTO ckb_vpl VALUES ("DT10_4","006_10_4","DEU","10","4","4","ئەویش لەسەر دوو تەختەکە وەک نووسراوی یەکەم جاری نووسییەوە، دە ڕاسپاردەکە کە یەزدان لەگەڵتاندا پێی دوا لە کێوەکە لەناو ئاگرەوە لە ڕۆژی کۆبوونەوەکە و ئینجا پێیدام. ");
INSERT INTO ckb_vpl VALUES ("DT10_5","006_10_5","DEU","10","5","5","ئیتر گەڕامەوە و لە کێوەکە هاتمە خوارەوە و دوو تەختە بەردەکەم لەناو سندوقەکە دانا کە دروستم کردبوو، جا هێشتا لەوێن وەک یەزدان فەرمانی پێ کردم. ");
INSERT INTO ckb_vpl VALUES ("DT10_6","006_10_6","DEU","10","6","6","(نەوەی ئیسرائیلیش لە بیرەکانی نەوەی یەعقانەوە کۆچیان کرد بۆ مۆسێرە. لەوێ هارون مرد و هەر لەوێش نێژرا. ئیتر ئەلعازاری کوڕی لە جێی ئەو بوو بە کاهین. ");
INSERT INTO ckb_vpl VALUES ("DT10_7","006_10_7","DEU","10","7","7","لەوێشەوە کۆچیان کرد بۆ گودگۆدە، لە گودگۆدەشەوە بۆ یۆتباتە کە خاکی جۆگە ئاوەکانە. ");
INSERT INTO ckb_vpl VALUES ("DT10_8","006_10_8","DEU","10","8","8","لەو کاتەدا یەزدان هۆزی نەوەی لێڤی جیا کردەوە بۆ ئەوەی سندوقی پەیمانی یەزدان هەڵبگرن و لەبەردەم یەزدان بوەستن بۆ ئەوەی خزمەتی بکەن و بە ناوی ئەوەوە داوای بەرەکەت بکەن هەتا ئەمڕۆ، ");
INSERT INTO ckb_vpl VALUES ("DT10_9","006_10_9","DEU","10","9","9","لەبەر ئەوە لێڤییەکان لەگەڵ براکانیان بەش و میراتیان نەبوو، یەزدان میراتی ئەوانە، هەروەک یەزدانی پەروەردگارتان لەگەڵیاندا دوا.) ");
INSERT INTO ckb_vpl VALUES ("DT10_10","006_10_10","DEU","10","10","10","منیش وەک ڕۆژانی یەکەم جار چل شەو و چل ڕۆژ لە کێوەکە مامەوە و یەزدان ئەو جارەش گوێی لێ گرتم و یەزدان نەیویست لەناوتان ببات. ");
INSERT INTO ckb_vpl VALUES ("DT10_11","006_10_11","DEU","10","11","11","دواتر یەزدان پێی فەرمووم، «هەستە بڕۆ پێشڕەوی گەل بکە، جا دەچنە ناو ئەو خاکەی دەست بەسەریدا دەگرن کە سوێندم بۆ باوباپیرانیان خوارد بیاندەمێ.» ");
INSERT INTO ckb_vpl VALUES ("DT10_12","006_10_12","DEU","10","12","12","ئێستاش ئەی ئیسرائیل یەزدانی پەروەردگارتان چی لێتان دەوێت، تەنها ئەوەندە کە لە یەزدانی پەروەردگارتان بترسن تاکو هەموو ڕێگاکانی بگرنەبەر و خۆشتان بوێ، پڕ بە دڵ و لە ناخەوە یەزدانی پەروەردگارتان بپەرستن، ");
INSERT INTO ckb_vpl VALUES ("DT10_13","006_10_13","DEU","10","13","13","فەرمانەکانی یەزدان و فەرزەکانی بەجێبهێنن کە من ئەمڕۆ بۆ باشی خۆتان فەرمانتان پێ دەکەم. ");
INSERT INTO ckb_vpl VALUES ("DT10_14","006_10_14","DEU","10","14","14","ئەوەتا ئاسمان و ئاسمانی ئاسمانەکان و زەوی و هەرچی تێیدایە بۆ یەزدانی پەروەردگارتانە، ");
INSERT INTO ckb_vpl VALUES ("DT10_15","006_10_15","DEU","10","15","15","لەگەڵ ئەوەشدا یەزدان دڵی بە باوباپیرانتانەوە بەند بوو و خۆشیویستن، جا لەپاش خۆیان نەوەکەی ئەوانی هەڵبژارد کە ئێوەن، لە سەرووی هەموو گەلانەوە وەک ئەمڕۆ. ");
INSERT INTO ckb_vpl VALUES ("DT10_16","006_10_16","DEU","10","16","16","کەواتە دڵتان خەتەنە بکەن و ئیتر کەللەڕەق مەبن، ");
INSERT INTO ckb_vpl VALUES ("DT10_17","006_10_17","DEU","10","17","17","چونکە یەزدانی پەروەردگارتان خۆی خودای خودایانە و گەورەی گەورەیانە، ئەو خودا مەزنە بە توانا بە سامەی لایەنگری ناکات و بەرتیل وەرناگرێت، ");
INSERT INTO ckb_vpl VALUES ("DT10_18","006_10_18","DEU","10","18","18","دادپەروەری هەتیو و بێوەژن دەکات و دۆستی نامۆیە هەتا خۆراک و بەرگی بداتێ. ");
INSERT INTO ckb_vpl VALUES ("DT10_19","006_10_19","DEU","10","19","19","جا نامۆتان خۆشبوێت، چونکە لە خاکی میسردا نامۆ بوون. ");
INSERT INTO ckb_vpl VALUES ("DT10_20","006_10_20","DEU","10","20","20","لە یەزدانی پەروەردگارتان دەترسن، ئەو دەپەرستن و دەست بەوەوە دەگرن و بە ناوی ئەوەوە سوێند دەخۆن، ");
INSERT INTO ckb_vpl VALUES ("DT10_21","006_10_21","DEU","10","21","21","ئەو ستایشتانە و ئەو خوداتانە کە ئەو هەموو کارە مەزن و ترسناکەی بۆ کردن کە چاوەکانتان بینییان. ");
INSERT INTO ckb_vpl VALUES ("DT10_22","006_10_22","DEU","10","22","22","باوباپیرانتان حەفتا کەس بوون کە چوونە میسر و ئێستاش یەزدانی پەروەردگارتان لە زۆریدا وەک ئەستێرەی ئاسمانی لێکردوون. ");
INSERT INTO ckb_vpl VALUES ("DT11_1","006_11_1","DEU","11","1","1","یەزدانی پەروەردگارتان خۆشبوێت و داواکاری و فەرز و یاسا و فەرمانەکانی هەمیشە بەجێبهێنن. ");
INSERT INTO ckb_vpl VALUES ("DT11_2","006_11_2","DEU","11","2","2","بزانن کە پەیامەکەم بۆ ئێوەیە، نەک بۆ منداڵەکانتان کە ئەزموونی تەمبێکردنی یەزدانی پەروەردگاریان نییە. ئێوە کە مەزنێتی و دەستی پۆڵایین و بازووە بەهێزەکەی ئەوتان بینیوە؛ ");
INSERT INTO ckb_vpl VALUES ("DT11_3","006_11_3","DEU","11","3","3","نیشانە و کارەکانی کە لە میسر بە فیرعەونی پاشای میسر و بە هەموو خاکەکەی کرد، ");
INSERT INTO ckb_vpl VALUES ("DT11_4","006_11_4","DEU","11","4","4","ئەوەی بە ئەسپ و گالیسکەکانی سوپای میسری کرد کاتێک بەدواتان کەوتن، بە شەپۆلەکانی دەریای سووری پێچایەوە و بە تەواوی لەناوی بردن. ");
INSERT INTO ckb_vpl VALUES ("DT11_5","006_11_5","DEU","11","5","5","هەروەها منداڵەکانی ئێوە نەبوون، بەڵکو ئێوە بوون کە بە چاوی خۆتان ئەوەتان بینی کە لە دەشتودەر بۆی کردن هەتا هاتنە ئەم شوێنە و ");
INSERT INTO ckb_vpl VALUES ("DT11_6","006_11_6","DEU","11","6","6","ئەوەی بە داتان و ئەبیرامی کرد، دوو کوڕەکەی ئەلیابی ڕەئوبێنی، کاتێک لەناوەندی هەموو ئیسرائیلدا زەوی دەمی کردەوە و بە ماڵەکانیان و چادرەکانیان و هەموو ئەو شتە زیندووانەی هی ئەوان بوون هەڵیلووشی. ");
INSERT INTO ckb_vpl VALUES ("DT11_7","006_11_7","DEU","11","7","7","ئێوە بە چاوی خۆتان هەموو کردارە مەزنەکانی یەزدانتان بینی کە کردی. ");
INSERT INTO ckb_vpl VALUES ("DT11_8","006_11_8","DEU","11","8","8","هەموو ئەو فەرمانانە بپارێزن کە ئەمڕۆ فەرمانتان پێ دەکەم، بۆ ئەوەی بەهێز بن و بچنە ناوەوە و دەست بەسەر ئەو خاکەدا بگرن کە ئێوە لە ڕووباری ئوردونەوە بۆی دەپەڕنەوە هەتا ببنە خاوەنی، ");
INSERT INTO ckb_vpl VALUES ("DT11_9","006_11_9","DEU","11","9","9","هەروەها بۆ ئەوەی تەمەن درێژ بن لەسەر ئەو خاکەی یەزدان سوێندی بۆ باوباپیرانتان خوارد بیانداتێ، بۆ خۆیان و نەوەکانیان، خاکێک شیر و هەنگوینی لێ دەڕژێت. ");
INSERT INTO ckb_vpl VALUES ("DT11_10","006_11_10","DEU","11","10","10","ئەو خاکەی کە ئێوە دەچنە ناوی هەتا دەستی بەسەردا بگرن، وەک خاکی میسر نییە کەوا بەجێتان هێشت، ئەو شوێنەی تۆوتان لێ دەچاند و بە پێیەکانتان ئاوتان دەدا وەک باخی سەوزەوات. ");
INSERT INTO ckb_vpl VALUES ("DT11_11","006_11_11","DEU","11","11","11","بەڵکو ئەو خاکەی ئێوە لە ڕووباری ئوردونەوە بۆی دەپەڕنەوە هەتا دەستی بەسەردا بگرن، خاکی چیا و دۆڵە، لە بارانی ئاسمان ئاو دەخواتەوە. ");
INSERT INTO ckb_vpl VALUES ("DT11_12","006_11_12","DEU","11","12","12","خاکێک یەزدانی پەروەردگارتان بایەخی پێدەدات؛ چاوەکانی یەزدانی پەروەردگارتان لە سەرەتای ساڵ هەتا کۆتایی بە بەردەوامی لەسەریەتی. ");
INSERT INTO ckb_vpl VALUES ("DT11_13","006_11_13","DEU","11","13","13","جا ئەگەر گوێڕایەڵی فەرمانەکانم بوون کە من ئەمڕۆ فەرمانتان پێ دەکەم هەتا یەزدانی پەروەردگارتان خۆشبوێت، پڕ بە دڵ و لە ناخەوە بیپەرستن، ");
INSERT INTO ckb_vpl VALUES ("DT11_14","006_11_14","DEU","11","14","14","ئەوا بارانی زەوییەکەتان، پاییزە باران و بەهارە باران لە وەرزی خۆیدا دەدەم، ئێوەش دانەوێڵە و شەرابی نوێ و زەیتەکەتان کۆدەکەنەوە. ");
INSERT INTO ckb_vpl VALUES ("DT11_15","006_11_15","DEU","11","15","15","لە کێڵگەکانتان گیا بۆ ئاژەڵەکانتان دابین دەکەم، ئێوەش هەمیشە خۆراکی پێویستتان دەبێت و تێر دەبن. ");
INSERT INTO ckb_vpl VALUES ("DT11_16","006_11_16","DEU","11","16","16","بۆیە ئاگاداربن نەوەک دڵتان بخەڵەتێت و لابدەن و خودای دیکە بپەرستن و کڕنۆشی بۆ ببەن. ");
INSERT INTO ckb_vpl VALUES ("DT11_17","006_11_17","DEU","11","17","17","جا تووڕەیی یەزدان لێتان دەجۆشێت و ئاسمان دادەخرێت و باران نابارێت و زەوی بەروبووم نادات، ئێوەش بە خێرایی لەو خاکە چاکەی یەزدان پێتانی دەدات لەناودەچن. ");
INSERT INTO ckb_vpl VALUES ("DT11_18","006_11_18","DEU","11","18","18","جا ئەم وشانەم لەسەر دڵ و گیانتان دابنێن و وەک نیشانە لەسەر دەستتانی ببەستن و با گوڵنگ بن بە ناوچەوانتانەوە. ");
INSERT INTO ckb_vpl VALUES ("DT11_19","006_11_19","DEU","11","19","19","منداڵەکانیشتان فێر بکەن و پێی بدوێن کاتێک لە ماڵەکانتان دادەنیشن و کاتێک بە ڕێگادا دەڕۆن و کاتێک دەخەون و کاتێک هەڵدەستن، ");
INSERT INTO ckb_vpl VALUES ("DT11_20","006_11_20","DEU","11","20","20","لەسەر چوارچێوەی دەرگاکانی ماڵەکەت و لەسەر دەرگاکانی حەوشەکەت بینووسە، ");
INSERT INTO ckb_vpl VALUES ("DT11_21","006_11_21","DEU","11","21","21","بۆ ئەوەی ڕۆژانی خۆت و منداڵەکانت زیاد بکات لەسەر ئەو خاکەی یەزدان سوێندی بۆ باوباپیرانت خوارد بیانداتێ هەروەک بەردەوامی ئاسمان بەسەر ڕووی زەویدا. ");
INSERT INTO ckb_vpl VALUES ("DT11_22","006_11_22","DEU","11","22","22","ئەگەر هۆشیار بوون و هەموو ئەو فەرمانانە بپارێزن کە من فەرمانتان پێ دەکەم هەتا بیکەن، بۆ ئەوەی یەزدانی پەروەردگارتان خۆشبوێت و هەموو ڕێگاکانی بگرنەبەر و دەستی پێوە بگرن، ");
INSERT INTO ckb_vpl VALUES ("DT11_23","006_11_23","DEU","11","23","23","ئەوا یەزدان هەموو ئەو گەلانە لەبەردەمتان دەردەکات و ئێوە دەبنە میراتگری گەلانی لە خۆتان گەورەتر و بەهێزتر. ");
INSERT INTO ckb_vpl VALUES ("DT11_24","006_11_24","DEU","11","24","24","هەر شوێنێک لەپی پێتان لێ دانا دەبێتە هی ئێوە، سنوورتان لە دەشتودەر و لوبنانەوە، لە ڕووبارەکەوە، ڕووباری فورات هەتا دەریای ڕۆژئاوا دەبێت. ");
INSERT INTO ckb_vpl VALUES ("DT11_25","006_11_25","DEU","11","25","25","هیچ کەس ناتوانێت لە دژتان بوەستێت، یەزدانی پەروەردگارتان ترس و سامتان دەخاتە سەر هەموو ئەو زەوییەی پێی لێ دەنێن، هەروەک بەڵێنی پێدان. ");
INSERT INTO ckb_vpl VALUES ("DT11_26","006_11_26","DEU","11","26","26","بڕوانە، من ئەمڕۆ بەرەکەت و نەفرەت لەبەردەمتان دادەنێم: ");
INSERT INTO ckb_vpl VALUES ("DT11_27","006_11_27","DEU","11","27","27","بەرەکەتە، ئەگەر گوێڕایەڵی فەرمانەکانی یەزدانی پەروەردگاری خۆتان بن کە من ئەمڕۆ فەرمانتان پێ دەکەم؛ ");
INSERT INTO ckb_vpl VALUES ("DT11_28","006_11_28","DEU","11","28","28","نەفرەتە، ئەگەر گوێڕایەڵی فەرمانەکانی یەزدانی پەروەردگاری خۆتان نەبن و لەو ڕێگایەی کە من ئەمڕۆ فەرمانتان پێ دەکەم لاتان دا هەتا بەدوای خودای دیکە بکەون کە نەتانناسیوە. ");
INSERT INTO ckb_vpl VALUES ("DT11_29","006_11_29","DEU","11","29","29","جا کاتێک یەزدانی پەروەردگارت تۆی هێنایە ئەو خاکەی کە تۆ دەچیتە ناوی هەتا دەستی بەسەردا بگریت، ئەوا بەرەکەتەکان لەسەر کێوی گەریزیم ڕابگەیەنە و نەفرەتەکانیش لەسەر کێوی عێبال. ");
INSERT INTO ckb_vpl VALUES ("DT11_30","006_11_30","DEU","11","30","30","وەک دەزانن ئەم کێوانە لەوبەری ڕووباری ئوردونەوەن، لە ڕۆژئاوای ڕێگاکە بەرەو خۆرئاوابوون، لە خاکی کەنعانییەکانی کە لە عەراڤادا نیشتەجێن، بەرامبەر گلگال لەتەنیشت دار بەڕووەکانی مۆرە، ");
INSERT INTO ckb_vpl VALUES ("DT11_31","006_11_31","DEU","11","31","31","چونکە ئێوە خەریکن لە ڕووباری ئوردون دەپەڕنەوە هەتا بچنە ناو ئەو خاکەی یەزدانی پەروەردگارتان پێتان دەدات و دەستی بەسەردا بگرن. کاتێک دەستتان بەسەردا گرت و تێیدا نیشتەجێ بوون، ");
INSERT INTO ckb_vpl VALUES ("DT11_32","006_11_32","DEU","11","32","32","ملکەچی هەموو ئەو فەرز و یاسایانە بن کە من ئەمڕۆ لەبەردەمتانی دادەنێم هەتا بیکەن. ");
INSERT INTO ckb_vpl VALUES ("DT12_1","006_12_1","DEU","12","1","1","ئەمە ئەو فەرز و یاسایانەیە کە بەجێی دەهێنن هەتا لەو خاکەدا بیکەن کە یەزدانی پەروەردگاری باوباپیرانتان پێیداون هەتا دەستی بەسەردا بگرن بە درێژایی ڕۆژانی ژیانتان لەسەر زەوی. ");
INSERT INTO ckb_vpl VALUES ("DT12_2","006_12_2","DEU","12","2","2","هەموو ئەو شوێنانە بە تەواوی تێکدەدەن، کە تێیدا ئەو نەتەوانەی ئێوە دەریاندەکەن، خوداوەندەکانیان دەپەرست لەسەر چیا سەرکەشەکان و لەسەر گردەکان و لەژێر هەموو دارێکی سەوز، ");
INSERT INTO ckb_vpl VALUES ("DT12_3","006_12_3","DEU","12","3","3","قوربانگاکانیشیان تێکدەدەن، بەردە تەرخانکراوەکانیان دەشکێنن، ستوونە ئەشێراکانیان بە ئاگر دەسووتێنن، پەیکەرەکانی خوداوەندەکانیان دەبڕنەوە و لەو شوێنانەدا ناویان دەسڕنەوە. ");
INSERT INTO ckb_vpl VALUES ("DT12_4","006_12_4","DEU","12","4","4","بەو شێوەیەی ئەوان یەزدانی پەروەردگارتان ناپەرستن، ");
INSERT INTO ckb_vpl VALUES ("DT12_5","006_12_5","DEU","12","5","5","بەڵکو ئەو شوێنەی یەزدانی پەروەردگارتان هەڵیدەبژێرێت لەنێو هەموو هۆزەکانتان هەتا ناوی خۆی تێدا دابنێت بۆ نیشتەجێبوونی، ڕووتان لەو شوێنە دەکەن و بۆ ئەوێ دەچن. ");
INSERT INTO ckb_vpl VALUES ("DT12_6","006_12_6","DEU","12","6","6","بۆ ئەوێ قوربانی سووتاندن و سەربڕاو و دەیەکەکان و بەخشینی بەرزکراوە و نەزر و بەخشینی ئازاد و نۆبەرەی مانگا و مەڕەکانتان پێشکەش دەکەن. ");
INSERT INTO ckb_vpl VALUES ("DT12_7","006_12_7","DEU","12","7","7","لەوێ لەبەردەم یەزدانی پەروەردگارتان ئێوە و خێزانەکانتان دەخۆن و دڵخۆش دەبن بە هەموو ئەوانەی دەستتان پێی دەگات، وەک یەزدانی پەروەردگارتان بەرەکەتداری کردن. ");
INSERT INTO ckb_vpl VALUES ("DT12_8","006_12_8","DEU","12","8","8","ئێوە ئاوا مەکەن، وەک ئەوەی ئێمە ئەمڕۆ لێرە دەیکەین، کە هەرکەسە بەو شێوەیەی خۆی دەکات کە ڕاستە لەپێش چاوی، ");
INSERT INTO ckb_vpl VALUES ("DT12_9","006_12_9","DEU","12","9","9","چونکە هێشتا نەچوونەتە ناو شوێنی حەسانەوە و میرات کە یەزدانی پەروەردگارتان دەتانداتێ. ");
INSERT INTO ckb_vpl VALUES ("DT12_10","006_12_10","DEU","12","10","10","بەڵام لە ڕووباری ئوردون دەپەڕنەوە و لەو خاکە نیشتەجێ دەبن کە یەزدانی پەروەردگارتان دەتانداتێ بە میرات و ئێوە دەحەسێنێتەوە لە هەموو دوژمنەکانتان کە لە دەوروبەرتانن و ئینجا بە ئاسوودەیی نیشتەجێ دەبن، ");
INSERT INTO ckb_vpl VALUES ("DT12_11","006_12_11","DEU","12","11","11","ئەوا ئەو شوێنەی خوداتان هەڵیدەبژێرێت هەتا ناوی لەوێ بێت، بۆ ئەوێ هەموو ئەو شتانە هەڵدەگرن کە من فەرمانتان پێ دەکەم، قوربانی سووتاندن و سەربڕاو و دەیەکەکان و بەخشینی بەرزکراوە و هەموو هەڵبژێردراوی نەزرەکانتان کە بۆ یەزدانی دەکەن. ");
INSERT INTO ckb_vpl VALUES ("DT12_12","006_12_12","DEU","12","12","12","لەوێ لەبەردەم یەزدانی پەروەردگارتان دڵخۆش دەبن، ئێوە و کوڕ و کچ و خزمەتکار و کارەکەرەکانتان، هەروەها ئەو لێڤییانەش کە لە دەروازەی شارۆچکەکانتانن، چونکە نە بەش و نە میراتیان لەگەڵتاندا نییە. ");
INSERT INTO ckb_vpl VALUES ("DT12_13","006_12_13","DEU","12","13","13","ئاگاداربن قوربانی سووتاندنەکانتان پێشکەش مەکەن لە هەر شوێنێک کە دەیبینن، ");
INSERT INTO ckb_vpl VALUES ("DT12_14","006_12_14","DEU","12","14","14","بەڵکو لەو شوێنەی یەزدان هەڵیدەبژێرێت لە یەکێک لە هۆزەکانتان، لەوێ قوربانی سووتاندنەکانتان پێشکەش دەکەن و لەوێ هەموو ئەوانە دەکەن کە من فەرمانتان پێدەدەم. ");
INSERT INTO ckb_vpl VALUES ("DT12_15","006_12_15","DEU","12","15","15","بەڵام لە هەموو ئەوانەی حەزتان بۆی دەچێت سەردەبڕن و گۆشت دەخۆن لە هەموو شارۆچکەکانتان بەگوێرەی ئەو بەرەکەتەی یەزدانی پەروەردگارتان کە پێیداون، کەسی گڵاو و پاک بەپێی ڕێوڕەسم لێی دەخۆن وەک مامز و ئاسک. ");
INSERT INTO ckb_vpl VALUES ("DT12_16","006_12_16","DEU","12","16","16","بەڵام خوێن ناخۆن، وەک ئاو دەیڕێژنە سەر زەوی. ");
INSERT INTO ckb_vpl VALUES ("DT12_17","006_12_17","DEU","12","17","17","بۆتان نییە لە شارۆچکەکانتاندا دەیەکی دانەوێڵە و شەرابی نوێ و زەیتەکەتان بخۆن، هەروەها لە نۆبەرەی مانگا و مەڕتان و نە هیچ شتێک لە نەزرەکانتان کە نەزریان دەکەن و لە بەخشینە ئازاد و بەرزکراوەکانتان، ");
INSERT INTO ckb_vpl VALUES ("DT12_18","006_12_18","DEU","12","18","18","بەڵکو لەبەردەم یەزدانی پەروەردگارتان دەیخۆن لەو شوێنەی یەزدانی پەروەردگارتان هەڵیدەبژێرێت، خۆتان و کوڕ و کچ و خزمەتکار و کارەکەرەکانتان، هەروەها لێڤییەکانی شارۆچکەکانتان، لەبەردەم یەزدانی پەروەردگاریشتان بە هەموو ئەوانەی دەستتان پێی دەگات دڵخۆش دەبن. ");
INSERT INTO ckb_vpl VALUES ("DT12_19","006_12_19","DEU","12","19","19","ئاگاداربن لەوەی لێڤی پشت گوێ بخەن بە درێژایی ڕۆژانی ژیانتان لەسەر خاکەکەتان. ");
INSERT INTO ckb_vpl VALUES ("DT12_20","006_12_20","DEU","12","20","20","کاتێک یەزدانی پەروەردگاری خۆتان سنووری فراوان کردن وەک لەگەڵتاندا دوا و ئێوەش گوتتان «گۆشت دەخۆین،» چونکە حەزتان بۆ گۆشت خواردن چوو، ئەوا چەند حەزتان بۆی دەچێت لە گۆشت دەخۆن. ");
INSERT INTO ckb_vpl VALUES ("DT12_21","006_12_21","DEU","12","21","21","ئەگەر ئەو شوێنەی یەزدانی پەروەردگارتان هەڵیدەبژێرێت هەتا ناوی خۆی لێ دابنێت لێتانەوە دوور بوو، ئەوە لەو مانگا و مەڕانەی یەزدان پێتانی داوە سەری ببڕن وەک فەرمانم پێکردن و لە شارۆچکەکانتاندا لە هەموو ئەوانەی حەزتان بۆی چوو بخۆن. ");
INSERT INTO ckb_vpl VALUES ("DT12_22","006_12_22","DEU","12","22","22","وەک چۆن مامز و ئاسک دەخورێت ئاوا دەیخۆن، کەسی گڵاو و پاک بەپێی ڕێوڕەسم وەک یەک لێی دەخۆن، ");
INSERT INTO ckb_vpl VALUES ("DT12_23","006_12_23","DEU","12","23","23","بەڵام ئاگاداربن خوێن نەخۆن، چونکە خوێن ژیانەکەیە، جا ژیانەکە لەگەڵ گۆشتەکە مەخۆن، ");
INSERT INTO ckb_vpl VALUES ("DT12_24","006_12_24","DEU","12","24","24","نایخۆن، وەک ئاو لەسەر زەوی دەیڕێژن، ");
INSERT INTO ckb_vpl VALUES ("DT12_25","006_12_25","DEU","12","25","25","نایخۆن هەتا چاکە بێتە ڕێی خۆتان و منداڵەکانتان لەدوای خۆتان، چونکە ئەوەی لەبەرچاوی یەزدان ڕاستە، ئەوە دەکەن. ");
INSERT INTO ckb_vpl VALUES ("DT12_26","006_12_26","DEU","12","26","26","بەڵام شتە تەرخانکراوەکانتان کە هی ئێوەن و نەزرەکانتان هەڵدەگرن و دەچنە ئەو شوێنەی یەزدان هەڵیدەبژێرێت، ");
INSERT INTO ckb_vpl VALUES ("DT12_27","006_12_27","DEU","12","27","27","جا قوربانی سووتاندنەکانتان، گۆشتەکە و خوێنەکە لەسەر قوربانگای یەزدانی پەروەردگارتان دەکەن، بەڵام قوربانییە سەربڕدراوەکانتان، خوێنەکەی لەتەنیشتی قوربانگای یەزدانی پەروەردگارتان دەڕژێنرێن و گۆشتەکەش دەخۆن، ");
INSERT INTO ckb_vpl VALUES ("DT12_28","006_12_28","DEU","12","28","28","هۆشیار بن هەموو ئەو وشانەی من فەرمانتان پێدەدەم گوێڕایەڵی بن، هەتا بۆ خۆتان و منداڵەکانتان لەدوای خۆتان چاکە بێتە ڕێتان هەتاهەتایە، کاتێک ئەوەی لەبەرچاوی یەزدانی پەروەردگارتان چاکە و ڕاستە دەیکەن. ");
INSERT INTO ckb_vpl VALUES ("DT12_29","006_12_29","DEU","12","29","29","یەزدانی پەروەردگارتان لەبەردەمتاندا ئەو نەتەوانە لەناو دەبات کە ئێوە خەریکن بۆیان دەچن هەتا دەریانبکەن. بەڵام کاتێک ئێوە دەریاندەکەن و لە خاکەکەیان نیشتەجێ دەبن، ");
INSERT INTO ckb_vpl VALUES ("DT12_30","006_12_30","DEU","12","30","30","دوای ئەوەی لەبەردەمتان لەناودەبردرێن، ئاگاداربن لەوەی نەکەونە داوەوە و سەبارەت بە خوداوەندەکانیان پرسیار مەکەن: «ئەو نەتەوانە چۆن خوداوەندەکانیان دەپەرست؟ ئێمەش ئاوا دەکەین.» ");
INSERT INTO ckb_vpl VALUES ("DT12_31","006_12_31","DEU","12","31","31","بۆ یەزدانی پەروەردگارتان ئاوا مەکەن، چونکە ئەوان هەموو ئەو شتانەی قێزەونە لەلای یەزدان لەوەی ڕقی لێیەتی بۆ خوداوەندەکانیان کردووە، چونکە تەنانەت کوڕان و کچانی خۆشیان بە ئاگر سووتاندووە بۆ خوداوەندەکانیان. ");
INSERT INTO ckb_vpl VALUES ("DT12_32","006_12_32","DEU","12","32","32","هەموو ئەو قسانەی کە فەرمانم پێکردن، ئاگاداربن بیکەن، نە بۆی زیاد بکەن و نە لێی کەم بکەنەوە. ");
INSERT INTO ckb_vpl VALUES ("DT13_1","006_13_1","DEU","13","1","1","ئەگەر لەنێوتاندا پێغەمبەرێک یان خەونبینێک کە خەونێکی بینیبێت دەرکەوت و نیشانەیەک یان پەرجووێکی پێدان، ");
INSERT INTO ckb_vpl VALUES ("DT13_2","006_13_2","DEU","13","2","2","جا ئەگەر ئەو نیشانەیە یان ئەو پەرجووە کە بۆ ئێوەی باسکرد ڕوویدا و گوتی، «با بەدوای خودای دیکە بکەوین و بیانپەرستین،» ئەو خوداوەندانەی کە نەتانناسیوە، ");
INSERT INTO ckb_vpl VALUES ("DT13_3","006_13_3","DEU","13","3","3","ئەوا گوێ لە قسەی ئەو پێغەمبەرە یان ئەو خەونبینە مەگرە کە ئەو خەونەی بینیوە، چونکە یەزدانی پەروەردگارتان تاقیتان دەکاتەوە تاکو بزانێت ئایا ئێوە پڕ بە دڵ و لە ناخەوە یەزدانی پەروەردگاری خۆتان خۆشدەوێت یان نا. ");
INSERT INTO ckb_vpl VALUES ("DT13_4","006_13_4","DEU","13","4","4","بەدوای یەزدانی پەروەردگارتان دەڕۆن و لەو دەترسن و فەرمانەکانی دەپارێزن و گوێڕایەڵی دەبن و ئەو دەپەرستن و دەستی پێوە دەگرن. ");
INSERT INTO ckb_vpl VALUES ("DT13_5","006_13_5","DEU","13","5","5","ئەو پێغەمبەرەش یان ئەو خەونبینەی ئەو خەونەی بینیوە دەکوژرێت، چونکە بە چەواشەکاری قسەی کرد لە دژی یەزدانی پەروەردگارتانەوە کە لە خاکی میسرەوە دەریهێنان و لە ماڵی کۆیلەیی کڕینیەوە، بۆ ئەوەی لەو ڕێگایە لات بدات کە یەزدانی پەروەردگارتان فەرمانی پێ کردوون لەسەری بڕۆن. جا خراپەکە لەنێو خۆتان دادەماڵن. ");
INSERT INTO ckb_vpl VALUES ("DT13_6","006_13_6","DEU","13","6","6","ئەگەر براکەت، کوڕی دایکت، یان کوڕەکەت یان کچەکەت، یان ژنەکەی باوەشت، یان هاوڕێکەت کە وەک خۆتە بە نهێنی لەبن گوێت خوێندی و گوتی، «دەڕۆین و خودای دیکە دەپەرستین،» ئەو خوداوەندانەی کە نە تۆ و نە باوباپیرانت نەیانناسیوە، ");
INSERT INTO ckb_vpl VALUES ("DT13_7","006_13_7","DEU","13","7","7","لە خوداوەندەکانی ئەو گەلانەی دەوروبەرت، ئەوانەی لێتەوە نزیکن یاخود دوورن، لەمپەڕی زەوی هەتا ئەوپەڕی، ");
INSERT INTO ckb_vpl VALUES ("DT13_8","006_13_8","DEU","13","8","8","لەگەڵی ڕەزامەند مەبە و گوێی لێ مەگرە. دڵت پێی نەسووتێت و دەستی لێ مەپارێزە و بۆی دامەپۆشە، ");
INSERT INTO ckb_vpl VALUES ("DT13_9","006_13_9","DEU","13","9","9","بەڵکو بە دڵنیاییەوە بیکوژە، یەکەم جار دەستی تۆ لەسەری بێت بۆ کوشتنی ئینجا لە کۆتاییدا دەستی هەموو گەل. ");
INSERT INTO ckb_vpl VALUES ("DT13_10","006_13_10","DEU","13","10","10","بەردبارانی دەکەیت هەتا دەمرێت، چونکە ویستی لە یەزدانی پەروەردگارت تۆ لابدات کە لە خاکی میسر لە ماڵی کۆیلەیی دەریهێنایت. ");
INSERT INTO ckb_vpl VALUES ("DT13_11","006_13_11","DEU","13","11","11","ئەوسا هەموو ئیسرائیل دەیبیستن و دەترسن و جارێکی دیکە هیچ کەسێک لەنێوتان وەک ئەم بەدکارییە ئەنجام نادات. ");
INSERT INTO ckb_vpl VALUES ("DT13_12","006_13_12","DEU","13","12","12","ئەگەر سەبارەت بە یەکێک لەو شارۆچکانەی یەزدانی پەروەردگارتان پێتان دەدات هەتا تێیدا نیشتەجێ بن وتەیەکتان بیست، ");
INSERT INTO ckb_vpl VALUES ("DT13_13","006_13_13","DEU","13","13","13","کە خەڵکانێکی بەدکار لەنێوتاندا سەریان هەڵداوە و دانیشتووانی شارۆچکەیان گومڕا کردووە و دەڵێن، «دەچین و خودای دیکە دەپەرستین،» ئەو خوداوەندانەی کە نەتانناسیون، ");
INSERT INTO ckb_vpl VALUES ("DT13_14","006_13_14","DEU","13","14","14","ئێوە لێی بکۆڵنەوە و بگەڕێن و باش پرسیار بکەن. ئەگەر زانیتان بابەتەکە ڕاستە و بێگومانە کە ئەو کارە قێزەونە لەنێوتاندا کراوە، ");
INSERT INTO ckb_vpl VALUES ("DT13_15","006_13_15","DEU","13","15","15","ئەوا بە شمشێر تەواوی دانیشتووانی ئەو شارۆچکەیە بکوژن و قڕیان بکەن، بە هەموو ئەو شتانەوەش کە تێیدایە و بە ئاژەڵە ماڵییەکانیشییەوە. ");
INSERT INTO ckb_vpl VALUES ("DT13_16","006_13_16","DEU","13","16","16","هەموو شتومەکەکانی لە گۆڕەپانی شارۆچکەکەدا کۆدەکەنەوە و هەموو شارۆچکەکە و شتومەکەکانی وەک قوربانی سووتاندنێکی تەواو بۆ یەزدانی پەروەردگارتان دەسووتێنن، جا بۆ هەتاهەتایە دەبێتە گردێکی وێران و جارێکی دیکە بنیاد نانرێتەوە. ");
INSERT INTO ckb_vpl VALUES ("DT13_17","006_13_17","DEU","13","17","17","نابێت هیچ شتێکی تەرخانکراو بۆ قڕکردن لەلای ئێوە ببینرێتەوە، هەتا گڕی تووڕەییەکەی یەزدان دابمرکێتەوە، بەزەیی پێتان دێتەوە و لەگەڵتان میهرەبان دەبێت و زۆرتان دەکات هەروەک سوێندی بۆ باوباپیرانتان خوارد، ");
INSERT INTO ckb_vpl VALUES ("DT13_18","006_13_18","DEU","13","18","18","ئەگەر گوێڕایەڵی دەنگی یەزدانی پەروەردگارتان بوون بۆ پاراستنی هەموو فەرمانەکانی کە من ئەمڕۆ فەرمانتان پێدەدەم هەتا ئەوەی لەبەرچاوی یەزدانی پەروەردگارتان ڕاستە بیکەن. ");
INSERT INTO ckb_vpl VALUES ("DT14_1","006_14_1","DEU","14","1","1","ئێوە ڕۆڵەی یەزدانی پەروەردگارتانن، لەشی خۆتان بریندار مەکەن و ناوچەوانتان مەتاشن لەبەر مردوو، ");
INSERT INTO ckb_vpl VALUES ("DT14_2","006_14_2","DEU","14","2","2","چونکە ئێوە گەلێکی پیرۆزن بۆ یەزدانی پەروەردگارتان و یەزدانیش ئێوەی هەڵبژارد بۆ ئەوەی ببنە گەنجینەیەکی تایبەت بۆ ئەو لە سەرووی هەموو ئەو گەلانەی لەسەر ڕووی زەویدان. ");
INSERT INTO ckb_vpl VALUES ("DT14_3","006_14_3","DEU","14","3","3","هیچ شتێکی قێزەون مەخۆن. ");
INSERT INTO ckb_vpl VALUES ("DT14_4","006_14_4","DEU","14","4","4","ئەمە ئەو ئاژەڵانەن کە دەیخۆن: گا و مەڕ و بزن، ");
INSERT INTO ckb_vpl VALUES ("DT14_5","006_14_5","DEU","14","5","5","ئاسک، مامز، ئاسکە سوورە، بزنەکێوی، کەڵەکێوی، ئاسکەکێوی و مەڕەکێوی. ");
INSERT INTO ckb_vpl VALUES ("DT14_6","006_14_6","DEU","14","6","6","هەر ئاژەڵێک کە سمی دوو کەرتە و کاوێژ دەکات، ئەوە دەخۆن. ");
INSERT INTO ckb_vpl VALUES ("DT14_7","006_14_7","DEU","14","7","7","بەڵام لەوانەی کاوێژ دەکەن یان سمیان دوو کەرتە، ئەمانە مەخۆن: وشتر و کەروێشک و گۆڕهەڵکەنە، چونکە کاوێژ دەکەن، بەڵام سمیان کەرت نییە، لەبەر ئەوە بۆتان گڵاوە. ");
INSERT INTO ckb_vpl VALUES ("DT14_8","006_14_8","DEU","14","8","8","هەروەها بەرازیش بۆتان گڵاوە، چونکە سمی کەرت کراوە، بەڵام کاوێژ ناکات، لەبەر ئەوە نە گۆشتیان بخۆن و نە دەست لە کەلاکیان بدەن. ");
INSERT INTO ckb_vpl VALUES ("DT14_9","006_14_9","DEU","14","9","9","لە هەموو ئەوانەی لە ئاوەکاندا دەژین، ئەوانە بخۆن کە باڵ و پوولەکەیان هەیە، ");
INSERT INTO ckb_vpl VALUES ("DT14_10","006_14_10","DEU","14","10","10","بەڵام هەموو ئەوەی باڵ و پوولەکەی نەبێت نەیخۆن، بۆ ئێوە گڵاوە. ");
INSERT INTO ckb_vpl VALUES ("DT14_11","006_14_11","DEU","14","11","11","هەموو باڵندەیەکی پاک دەخۆن، ");
INSERT INTO ckb_vpl VALUES ("DT14_12","006_14_12","DEU","14","12","12","بەڵام ئەمانەیان لێ ناخۆن، هەڵۆ و سیسارکە کەچەڵ و داڵاش، ");
INSERT INTO ckb_vpl VALUES ("DT14_13","006_14_13","DEU","14","13","13","واشەی سوور و واشەی ڕەش، هەموو جۆرەکانی شاهین و شمقاڕ، ");
INSERT INTO ckb_vpl VALUES ("DT14_14","006_14_14","DEU","14","14","14","هەموو جۆرەکانی قەلەڕەش، ");
INSERT INTO ckb_vpl VALUES ("DT14_15","006_14_15","DEU","14","15","15","کوندەپەپووی شاخدار و بایەقووش، مەلی دەریا، هەموو جۆرەکانی باز، ");
INSERT INTO ckb_vpl VALUES ("DT14_16","006_14_16","DEU","14","16","16","کوندەپەپووی بچووک و کوندەپەپووی گەورە و کوندەپەپووی سپی و ");
INSERT INTO ckb_vpl VALUES ("DT14_17","006_14_17","DEU","14","17","17","کوندەپەپووی بیابان، واشەی ماسیگر، مەلی ماسیگرە، ");
INSERT INTO ckb_vpl VALUES ("DT14_18","006_14_18","DEU","14","18","18","لەقلەق و هەموو جۆرەکانی شاهۆ و پەپوسڵێمانکە و شەمشەمەکوێرە. ");
INSERT INTO ckb_vpl VALUES ("DT14_19","006_14_19","DEU","14","19","19","هەموو مێرووێکی باڵدار بۆ ئێوە گڵاوە و ناخورێت. ");
INSERT INTO ckb_vpl VALUES ("DT14_20","006_14_20","DEU","14","20","20","هەموو باڵندەیەکی پاک دەخۆن. ");
INSERT INTO ckb_vpl VALUES ("DT14_21","006_14_21","DEU","14","21","21","هیچ ئاژەڵێکی مرداربووەوە مەخۆن، بیدەن بەو نامۆیانەی لە شارۆچکەکانتان دەژیێن، ئەوان دەیخۆن، یان بیفرۆشنە بیانییەکان، چونکە ئێوە گەلێکی پیرۆزن بۆ یەزدانی پەروەردگارتان. هیچ کاریلەیەک بە شیری دایکی لێمەنێن. ");
INSERT INTO ckb_vpl VALUES ("DT14_22","006_14_22","DEU","14","22","22","هەموو بەروبوومی کشتوکاڵتان کە ساڵ بە ساڵ لە کێڵگەکانتان وەبەردێت، بە تەواوی دەیەکی لێ دەخەنەلاوە. ");
INSERT INTO ckb_vpl VALUES ("DT14_23","006_14_23","DEU","14","23","23","لەبەردەم یەزدانی پەروەردگارتان لەو شوێنەی هەڵیدەبژێرێت بۆ ئەوەی ناوی لەوێ بێت، دەیەکی دانەوێڵە و شەرابی نوێ و زەیتەکەتان و نۆبەرەکانی مانگا و مەڕەکانتان دەخۆن، تاکو فێر بن هەردەم لە یەزدانی پەروەردگارتان بترسن. ");
INSERT INTO ckb_vpl VALUES ("DT14_24","006_14_24","DEU","14","24","24","بەڵام ئەگەر ڕێگاکە بۆتان دوور بوو و یەزدانی پەروەردگارتان بەرەکەتداری کردبوون و نەتانتوانی دەیەکەکەتان بهێنن، چونکە ئەو شوێنەی یەزدانی پەروەردگارتان هەڵیدەبژێرێت بۆ ئەوەی ناوی لەوێ بێت لێتان دوور بوو، ");
INSERT INTO ckb_vpl VALUES ("DT14_25","006_14_25","DEU","14","25","25","ئەوا بە زیو بیفرۆشن و زیوەکە بپێچنەوە لە دەستتان و بڕۆن بۆ ئەو شوێنەی یەزدانی پەروەردگارتان هەڵیدەبژێرێت. ");
INSERT INTO ckb_vpl VALUES ("DT14_26","006_14_26","DEU","14","26","26","جا زیوەکە خەرج بکەن لە هەموو ئەوەی حەزتان بۆی دەچێت، لە مانگا و مەڕ و شەراب و مەی و هەموو ئەوەی گیانتان لێتان داوا دەکات و لەوێ لەبەردەم یەزدانی پەروەردگارتان بیخۆن و ئێوە و ماڵەکانتان دڵخۆش بن. ");
INSERT INTO ckb_vpl VALUES ("DT14_27","006_14_27","DEU","14","27","27","ئەو لێڤییانەش کە لە شارۆچکەکانتانن بەجێیان مەهێڵن، چونکە بەش و میراتیان لەگەڵ ئێوەدا نییە. ");
INSERT INTO ckb_vpl VALUES ("DT14_28","006_14_28","DEU","14","28","28","لە کۆتایی هەر سێ ساڵێکدا هەموو دەیەکی بەروبوومی ئەو ساڵەتان دەربهێنن و لەناو شارۆچکەکانتان دایبنێن، ");
INSERT INTO ckb_vpl VALUES ("DT14_29","006_14_29","DEU","14","29","29","لێڤییەکانیش کە هیچ بەش و میراتیان لەگەڵ ئێوەدا نییە، لەگەڵ ئەو نامۆ و هەتیو و بێوەژنانەی کە لە شارۆچکەکانتانن بێن و بخۆن و تێر ببن، بۆ ئەوەی یەزدانی پەروەردگارتان لە هەموو کردارێکی دەستتان کە دەیکەن بەرەکەتدارتان بکات. ");
INSERT INTO ckb_vpl VALUES ("DT15_1","006_15_1","DEU","15","1","1","هەر حەوت ساڵ جارێک، لە قەرزەکانتان خۆش بن. ");
INSERT INTO ckb_vpl VALUES ("DT15_2","006_15_2","DEU","15","2","2","ئەمەش چۆنیەتی بەتاڵکردنەوەیە، هەموو خاوەن قەرزەکان پێویستە لەو قەرزەی بە نزیکەکەی داوە بەتاڵی بکاتەوە. لە نزیکەکەی یان براکەی داوا ناکاتەوە، چونکە کاتی یەزدان بۆ بەتاڵکردنەوەی قەرزەکان بانگەواز کراوە. ");
INSERT INTO ckb_vpl VALUES ("DT15_3","006_15_3","DEU","15","3","3","لە بیانی داوا دەکرێت، بەڵام ئەو قەرزەی لەلای براکەت هەتبوو، ئەوا پێویستە بەتاڵی بکەیتەوە. ");
INSERT INTO ckb_vpl VALUES ("DT15_4","006_15_4","DEU","15","4","4","هەرچەندە پێویستە لەنێوتان کەس هەژار نەبێت، چونکە بێگومان یەزدان بەرەکەتدارتان دەکات لەو خاکەی یەزدانی پەروەردگارتان پێتانی دەدات هەتا وەک میرات دەستی بەسەردا بگرن، ");
INSERT INTO ckb_vpl VALUES ("DT15_5","006_15_5","DEU","15","5","5","ئەگەر گوێڕایەڵی یەزدانی پەروەردگارتان بوون، هەتا هەموو ئەو فەرمانانەی من ئەمڕۆ فەرمانتان پێ دەکەم، بپارێزن و کاریان پێ بکەن. ");
INSERT INTO ckb_vpl VALUES ("DT15_6","006_15_6","DEU","15","6","6","یەزدانی پەروەردگارتان بەرەکەتدارتان دەکات وەک بەڵێنی پێدان، جا قەرز بە زۆربەی نەتەوەکان دەدەن و ئێوە قەرز ناکەن، بەسەر زۆربەی نەتەوەکاندا دەسەڵاتتان دەبێت و ئەوان بەسەرتانەوە دەسەڵاتدار نابن. ");
INSERT INTO ckb_vpl VALUES ("DT15_7","006_15_7","DEU","15","7","7","ئەگەر هەژارێک لەنێوتان بوو، یەکێک لە برایانتان لە شارۆچکەیەکی خاکەکەتان کە یەزدانی پەروەردگارتان پێتانی دەدات، ئەوا دڵتان ڕەق مەکەن و لە ئاست برا هەژارەکانتان دەستتان دامەخەن، ");
INSERT INTO ckb_vpl VALUES ("DT15_8","006_15_8","DEU","15","8","8","بەڵکو دەستتانی بۆ بکەنەوە و ئەوەی پێویستی بە قەرزە بیدەنێ. ");
INSERT INTO ckb_vpl VALUES ("DT15_9","006_15_9","DEU","15","9","9","ئاگاداربن لەوەی بیرێکی خراپتان لە دڵدا بێت و بڵێن، «ئەوا ساڵی حەوتەم نزیک بووەتەوە، ساڵی بەتاڵکردنەوەی قەرزەکانە،» ئیتر بە خراپی ڕەفتار لەگەڵ هەژار بکەن و نەیدەنێ، جا ئەویش بۆ یەزدان هاوار دەکات سەبارەت بە ئێوە و دەبێتە گوناه بەسەرتانەوە. ");
INSERT INTO ckb_vpl VALUES ("DT15_10","006_15_10","DEU","15","10","10","بە دڵفراوانییەوە پێی ببەخشن و با بە نابەدڵی نەبێت کاتێک دەیدەنێ، چونکە بەهۆی ئەم شتەوە یەزدانی پەروەردگارتان بەرەکەتدارتان دەکات لە هەموو کارەکانتان و لە هەموو ئەوەی دەستی بۆ دەبەن. ");
INSERT INTO ckb_vpl VALUES ("DT15_11","006_15_11","DEU","15","11","11","لەبەر ئەوەی هەژار لە خاکەکەدا کۆتایی نایەت، بۆیە من فەرمانتان پێدەدەم و دەڵێم: «دەستی یارمەتیتان بکەنەوە بۆ برای نەدارتان و بۆ هەژاران لە خاکەکەتان.» ");
INSERT INTO ckb_vpl VALUES ("DT15_12","006_15_12","DEU","15","12","12","ئەگەر برایەک یان خوشکێکی عیبرانیت پێ فرۆشرا و شەش ساڵ خزمەتی کردیت، ئەوا لە ساڵی حەوتەم لەلای خۆت ئازادی دەکەیت. ");
INSERT INTO ckb_vpl VALUES ("DT15_13","006_15_13","DEU","15","13","13","کاتێک ئازادیشی دەکەیت، بە دەستبەتاڵی ئازادی ناکەیت. ");
INSERT INTO ckb_vpl VALUES ("DT15_14","006_15_14","DEU","15","14","14","بەڵکو بە دڵفراوانییەوە لە مێگەلەکەت و جۆخینەکەت و گوشەرەکەتی پێدەدەیت، بەو شێوەیەی یەزدانی پەروەردگارت بەرەکەتداری کردوویت، پێی دەدەیت. ");
INSERT INTO ckb_vpl VALUES ("DT15_15","006_15_15","DEU","15","15","15","لە یادت بێت تۆش لە خاکی میسر کۆیلە بوویت، جا یەزدانی پەروەردگارت تۆی کڕییەوە، بۆیە من ئەمڕۆ فەرمانی ئەمەت پێ دەکەم. ");
INSERT INTO ckb_vpl VALUES ("DT15_16","006_15_16","DEU","15","16","16","بەڵام ئەگەر گوتی، «واز لە تۆ ناهێنم،» چونکە خۆت و ماڵەکەتی خۆشدەوێت، لەبەر ئەوەی لەلای تۆ لە خۆشیدا بووە، ");
INSERT INTO ckb_vpl VALUES ("DT15_17","006_15_17","DEU","15","17","17","ئەوا درێشە ببە و لەلای دەرگاکە گوێی کون بکە، جا بۆ هەتاهەتایە دەبێتە کۆیلەت، ئاواش بۆ کارەکەرەکەت دەکەیت. ");
INSERT INTO ckb_vpl VALUES ("DT15_18","006_15_18","DEU","15","18","18","بە لاتەوە گران نەبێت خزمەتکارەکەت ئازاد بکەیت، چونکە شەش ساڵ خزمەتی کردوویت، دوو هێندەی کرێگرتەیەک، جا یەزدانی پەروەردگارت بەرەکەتدارت دەکات لە هەموو ئەوەی کە دەیکەیت. ");
INSERT INTO ckb_vpl VALUES ("DT15_19","006_15_19","DEU","15","19","19","هەموو نۆبەرەیەکی نێرینەی مانگا و مەڕەکانت بۆ یەزدانی پەروەردگارت تەرخان دەکەیت، کار بە نۆبەرەی مانگاکەت مەکە و خوری نۆبەرەی مەڕەکانت مەبڕەوە. ");
INSERT INTO ckb_vpl VALUES ("DT15_20","006_15_20","DEU","15","20","20","ساڵ بە ساڵ لەبەردەم یەزدانی پەروەردگارت دەیخۆیت لەو شوێنەی یەزدان هەڵیدەبژێرێت، خۆت و ماڵەکەت. ");
INSERT INTO ckb_vpl VALUES ("DT15_21","006_15_21","DEU","15","21","21","بەڵام ئەگەر ئاژەڵێک کەموکوڕییەکی تێدابێت، وەک شەلی یان کوێری، هەر کەموکوڕییەکی خراپ، ئەوا بۆ یەزدانی پەروەردگارت سەری مەبڕە، ");
INSERT INTO ckb_vpl VALUES ("DT15_22","006_15_22","DEU","15","22","22","لە شارۆچکەی خۆتدا دەیخۆیت، کەسی گڵاو و پاک بەپێی ڕێوڕەسم وەک یەک، وەک چۆن مامز و ئاسک دەخۆن. ");
INSERT INTO ckb_vpl VALUES ("DT15_23","006_15_23","DEU","15","23","23","بەڵام خوێنەکەی نەخۆیت، وەک ئاو دەیڕێژیتە سەر زەوی. ");
INSERT INTO ckb_vpl VALUES ("DT16_1","006_16_1","DEU","16","1","1","مانگی ئاڤیڤ بپارێزن و جەژنی پەسخە بۆ یەزدانی پەروەردگارتان بکەن، چونکە لە مانگی ئاڤیڤدا یەزدانی پەروەردگارتان بە شەو لە میسر دەریهێنان. ");
INSERT INTO ckb_vpl VALUES ("DT16_2","006_16_2","DEU","16","2","2","جا لە جەژنی پەسخە مانگا و مەڕ بۆ یەزدانی پەروەردگارتان سەردەبڕن، لەو شوێنەی یەزدان هەڵیدەبژێرێت بۆ ئەوەی ناوی لەوێ بێت. ");
INSERT INTO ckb_vpl VALUES ("DT16_3","006_16_3","DEU","16","3","3","هیچ نانێکی بە هەویرترشی لەگەڵ نەخۆن، حەوت ڕۆژ نانی فەتیرە دەخۆن، نانی تەنگانە، چونکە بە پەلە لە خاکی میسر هاتنە دەرەوە، هەتا هەموو ڕۆژانی ژیانتان، ڕۆژی هاتنەدەرەوەتان لە خاکی میسر لە یاد بێت. ");
INSERT INTO ckb_vpl VALUES ("DT16_4","006_16_4","DEU","16","4","4","لە هەموو سنوورەکانتان نابێت هەویرترش ببینرێت بۆ حەوت ڕۆژ و نابێت هیچ لەو گۆشتەی ئێوارە کە ڕۆژی یەکەم سەری دەبڕن بۆ بەیانی بمێنێتەوە. ");
INSERT INTO ckb_vpl VALUES ("DT16_5","006_16_5","DEU","16","5","5","بۆتان نییە قوربانی جەژنی پەسخە لە یەکێک لە شارۆچکەکانتان سەرببڕن کە یەزدانی پەروەردگارتان دەتانداتێ، ");
INSERT INTO ckb_vpl VALUES ("DT16_6","006_16_6","DEU","16","6","6","بەڵکو لەو شوێنەی یەزدانی پەروەردگارتان هەڵیدەبژێرێت هەتا ناوی لەوێ بێت، لەوێ قوربانی پەسخە سەردەبڕن لە ئێوارە، دەمەو خۆر ئاوابوون، لە کاتی یادکردنەوەی ساڵانەی هاتنەدەرەوەتان لە میسر. ");
INSERT INTO ckb_vpl VALUES ("DT16_7","006_16_7","DEU","16","7","7","لەو شوێنەی یەزدانی پەروەردگارتان هەڵیدەبژێرێت، لێی دەنێن و دەیخۆن و ئینجا بۆ بەیانی دەگەڕێنەوە چادرەکانتان. ");
INSERT INTO ckb_vpl VALUES ("DT16_8","006_16_8","DEU","16","8","8","شەش ڕۆژ نانی فەتیرە دەخۆن و ڕۆژی حەوتەمیش ئاهەنگی کۆتایی دەگێڕن بۆ یەزدانی پەروەردگارتان، هیچ کارێکی تێدا ناکەن. ");
INSERT INTO ckb_vpl VALUES ("DT16_9","006_16_9","DEU","16","9","9","حەوت هەفتە دەژمێرن بۆ خۆتان، لە دەستپێکردنی دروێنەی دەغڵ دەستپێدەکەن. ");
INSERT INTO ckb_vpl VALUES ("DT16_10","006_16_10","DEU","16","10","10","جەژنی هەفتەکان بۆ یەزدانی پەروەردگارتان دەگێڕن، بەگوێرەی ئەوەی لە دەستتان دێتەدەر بەخشینێکی ئازاد دەبەخشن، وەک ئەوەندەی یەزدانی پەروەردگارتان بەرەکەتداری کردوون. ");
INSERT INTO ckb_vpl VALUES ("DT16_11","006_16_11","DEU","16","11","11","جا خۆتان و کوڕ و کچ و خزمەتکار و کارەکەرەکانتان، هەروەها ئەو لێڤییانەی کە لە شارۆچکەکانتانن و ئەو نامۆ و هەتیو و بێوەژنانەی کە لەنێوتانن لەبەردەم یەزدانی پەروەردگارتان دڵخۆش دەبن، لەو شوێنەی یەزدانی پەروەردگارتان هەڵیدەبژێرێت هەتا ناوی لەوێ بێت. ");
INSERT INTO ckb_vpl VALUES ("DT16_12","006_16_12","DEU","16","12","12","لە یادتان بێت ئێوەش لە میسر کۆیلە بوون، بۆیە ئەو فەرزانە بەجێدەهێنن و پەیڕەویان دەکەن. ");
INSERT INTO ckb_vpl VALUES ("DT16_13","006_16_13","DEU","16","13","13","حەوت ڕۆژان جەژنی کەپرەشینە بۆ خۆتان دەکەن، کاتێک بەرهەم لە جۆخین و گوشەرەکەتان کۆدەکەنەوە. ");
INSERT INTO ckb_vpl VALUES ("DT16_14","006_16_14","DEU","16","14","14","جا بە جەژنەکەتان خۆتان و کوڕ و کچ و خزمەتکار و کارەکەرەکانتان، هەروەها ئەو لێڤی و نامۆ و هەتیو و بێوەژنانەی لە شارۆچکەکانتاندان دڵخۆش دەبن. ");
INSERT INTO ckb_vpl VALUES ("DT16_15","006_16_15","DEU","16","15","15","حەوت ڕۆژان بۆ یەزدانی پەروەردگارتان جەژن دەگێڕن لەو شوێنەی یەزدان هەڵیدەبژێرێت، چونکە یەزدانی پەروەردگارتان بەرەکەتدارتان دەکات لە هەموو بەروبوومێک و لە هەموو کردارێکی دەستتان، جا بێگومان دڵخۆش دەبن. ");
INSERT INTO ckb_vpl VALUES ("DT16_16","006_16_16","DEU","16","16","16","سێ جار لە ساڵێکدا هەموو نێرینەکانتان لەبەردەم یەزدانی پەروەردگارتان ئامادە دەبن، لەو شوێنەی کە خۆی هەڵیدەبژێرێت: لە جەژنی فەتیرە و جەژنی هەفتەکان و جەژنی کەپرەشینە. نابێت بە دەستبەتاڵی لەبەردەم یەزدان ئامادە بن، ");
INSERT INTO ckb_vpl VALUES ("DT16_17","006_16_17","DEU","16","17","17","بەپێی ئەو بەرەکەتەی یەزدانی پەروەردگارت پێت دەبەخشێت، هەریەکە بەگوێرەی ئەوەی لە دەستی دێتەدەر. ");
INSERT INTO ckb_vpl VALUES ("DT16_18","006_16_18","DEU","16","18","18","دادوەران و کوێخاکان بۆ خۆتان دادەنێن لە هەموو شارۆچکەکانتان کە یەزدانی پەروەردگارتان پێتانی دەدات بەگوێرەی هۆزەکانتان، جا ئەوانیش دادوەرییەکی ڕاستودروست بۆ گەل دەکەن. ");
INSERT INTO ckb_vpl VALUES ("DT16_19","006_16_19","DEU","16","19","19","دادوەری خوار مەکەنەوە و لایەنگری کەس مەکەن و بەرتیل وەرمەگرن، چونکە بەرتیل چاوی داناکان کوێر دەکات و قسەی ڕاستودروستان خوار دەکات. ");
INSERT INTO ckb_vpl VALUES ("DT16_20","006_16_20","DEU","16","20","20","دادوەری پەیڕەو دەکەن و تەنها دادوەری، هەتا بژین و دەست بەسەر ئەو خاکەدا بگرن کە یەزدانی پەروەردگارتان پێتانی دەدات. ");
INSERT INTO ckb_vpl VALUES ("DT16_21","006_16_21","DEU","16","21","21","هیچ ستوونە ئەشێرایەک لە هیچ دارێک بۆ خۆتان ناچێنن لەتەنیشت قوربانگاکەی یەزدانی پەروەردگارتانەوە کە بۆ خۆتان دروستی دەکەن، ");
INSERT INTO ckb_vpl VALUES ("DT16_22","006_16_22","DEU","16","22","22","هیچ بەردێکی تەرخانکراو بۆ خۆتان ڕامەگرن، ئەوەی یەزدانی پەروەردگارتان ڕقی لێیەتی. ");
INSERT INTO ckb_vpl VALUES ("DT17_1","006_17_1","DEU","17","1","1","بۆ یەزدانی پەروەردگارتان گایەک یان بەرخێک سەرمەبڕن کە کەموکوڕییەک یان شتێکی خراپی تێدابێت، چونکە ئەوە قێزەونە لەلای یەزدانی پەروەردگارتان. ");
INSERT INTO ckb_vpl VALUES ("DT17_2","006_17_2","DEU","17","2","2","ئەگەر لەنێوتان، لە یەکێک لە شارۆچکەکانتان کە یەزدانی پەروەردگارتان پێتانی دەدات، پیاوێک یان ئافرەتێک بینرا کارێک دەکات کە لەلای یەزدانی پەروەردگارتان خراپە و پەیمانەکەی دەشکێنێت و ");
INSERT INTO ckb_vpl VALUES ("DT17_3","006_17_3","DEU","17","3","3","بە پێچەوانەی فەرمانی منەوە، خوداوەندی دیکە، خۆر، مانگ یان هەر یەکێک لە ئەستێرەکانی ئاسمان دەپەرستێت و کڕنۆشی بۆ دەبات، ");
INSERT INTO ckb_vpl VALUES ("DT17_4","006_17_4","DEU","17","4","4","جا پێتان ڕاگەیەنرا و بیستتان، دەبێت ئێوە باش لێی بکۆڵنەوە. ئەگەر تاوانبارکردنەکە ڕاست بوو و بێگومان ئەو کارە قێزەونە لە ئیسرائیل کرابوو، ");
INSERT INTO ckb_vpl VALUES ("DT17_5","006_17_5","DEU","17","5","5","ئەوا ئەو پیاوە یان ئەو ئافرەتەی ئەو بەدکارییەی کردووە، دەریبکەن بۆ لای دەروازەی شارەکەتان و بەردبارانی بکەن هەتا دەمرێت. ");
INSERT INTO ckb_vpl VALUES ("DT17_6","006_17_6","DEU","17","6","6","ئەوەی بکوژرێت لەسەر زاری دوو شایەت یان سێ شایەت دەکوژرێت، نابێت لەسەر زاری یەک شایەت بکوژرێت. ");
INSERT INTO ckb_vpl VALUES ("DT17_7","006_17_7","DEU","17","7","7","یەکەم جار دەستی شایەتەکانی بەسەرەوە دەبێت بۆ کوشتنی پاشان دەستی هەموو گەل، جا خراپەکە لەنێو خۆتان دادەماڵن. ");
INSERT INTO ckb_vpl VALUES ("DT17_8","006_17_8","DEU","17","8","8","ئەگەر داوایەکتان بەلاوە سەخت بوو لە بڕیاردان، چ لە تاوانی ڕووداوی کوشتن یان داواکاری ماف یان پەلاماردان، لە کاروباری ناکۆکی لە دادگاکانتان، ئەوا هەستن و بڕۆن بۆ ئەو شوێنەی یەزدانی پەروەردگارتان هەڵیدەبژێرێت. ");
INSERT INTO ckb_vpl VALUES ("DT17_9","006_17_9","DEU","17","9","9","بڕۆنە لای کاهینە لێڤییەکان و لای ئەو دادوەرەی لەو ڕۆژانەدایە و بپرسن، جا حوکمی بڕیارەکەتان پێ ڕادەگەیەنن. ");
INSERT INTO ckb_vpl VALUES ("DT17_10","006_17_10","DEU","17","10","10","دەبێت ئەو بڕیارەی کە پێتانی ڕادەگەیەنن جێبەجێی بکەن، لەو شوێنەی یەزدان هەڵیدەبژێرێت. ئاگاداربن لەوەی ڕێک ئەوە بکەن کە فێرتان دەکەن. ");
INSERT INTO ckb_vpl VALUES ("DT17_11","006_17_11","DEU","17","11","11","بەپێی ئەو ڕێنماییە فێرتان دەکەن و ئەو حوکمەی پێتانی دەڵێن، وا دەکەن، لەو شتانە لامەدەن کە پێتانی ڕادەگەیەنن، نە بەلای ڕاست و نە بەلای چەپ. ");
INSERT INTO ckb_vpl VALUES ("DT17_12","006_17_12","DEU","17","12","12","هەرکەسێکیش کە بە لووتبەرزییەوە دەجوڵێتەوە و گوێ لەو کاهینە ناگرێت کە لەوێ ڕاوەستاوە بۆ ئەوەی یەزدانی پەروەردگارتان بپەرستێت، یان گوێ لە دادوەرەکە ناگرێت، ئەوا دەبێت بکوژرێت و ئەو خراپەیە لە ئیسرائیلدا دابماڵرێت. ");
INSERT INTO ckb_vpl VALUES ("DT17_13","006_17_13","DEU","17","13","13","جا هەموو گەل دەبیستن و دەترسن و لەپاش ئەوە لووتبەرزانە ناجوڵێنەوە. ");
INSERT INTO ckb_vpl VALUES ("DT17_14","006_17_14","DEU","17","14","14","کاتێک هاتنە ئەو خاکەی کە یەزدانی پەروەردگارتان دەتانداتێ و دەستتان بەسەردا گرت و تێیدا نیشتەجێ بوون، جا ئەگەر بڵێن، «پاشایەک بۆ خۆمان دادەنێین وەک هەموو ئەو نەتەوانەی دەوروبەرمان،» ");
INSERT INTO ckb_vpl VALUES ("DT17_15","006_17_15","DEU","17","15","15","ئەوا ئەو پاشایە بۆ خۆتان دادەنێن کە یەزدانی پەروەردگارتان هەڵیدەبژێرێت، یەکێک لە براکانتان بۆ خۆتان دەکەنە پاشا، بۆتان نییە یەکێکی بێگانە دابنێن کە ئیسرائیلییەکی براتان نییە. ");
INSERT INTO ckb_vpl VALUES ("DT17_16","006_17_16","DEU","17","16","16","بەڵام با ئەو پاشایە ئەسپ بۆ خۆی زۆر نەکات و گەل نەنێرێتەوە بۆ میسر، بۆ ئەوەی ئەسپی زۆرتر بەدەستبهێنێت، چونکە یەزدان پێی فەرموون: «نەکەن جارێکی دیکە بەو ڕێگایەدا بگەڕێنەوە.» ");
INSERT INTO ckb_vpl VALUES ("DT17_17","006_17_17","DEU","17","17","17","هەروەها با ژن بۆ خۆی زۆر نەکات، نەوەک دڵی لابدات. با زێڕ و زیویش بۆ خۆی گەلێک زۆر نەکات. ");
INSERT INTO ckb_vpl VALUES ("DT17_18","006_17_18","DEU","17","18","18","کاتێک لەسەر تەختی پاشایەتییەکەشی دادەنیشێت، با وێنەیەک لەم فێرکردنە لە پەڕتووکێک لەلای کاهینە لێڤییەکان بۆ خۆی بنووسێتەوە. ");
INSERT INTO ckb_vpl VALUES ("DT17_19","006_17_19","DEU","17","19","19","جا بە درێژایی ژیانی لەلای دەبێت و لێی دەخوێنێتەوە، بۆ ئەوەی فێر بێت لە یەزدانی پەروەردگاری خۆی بترسێت و هەموو وشەکانی ئەم فێرکردنە و ئەم فەرزانە بەجێبهێنێت هەتا پەیڕەویان بکات. ");
INSERT INTO ckb_vpl VALUES ("DT17_20","006_17_20","DEU","17","20","20","نەوەک بەسەر براکانیدا لووتبەرز بێت، نەوەک لە فەرمانەکان بەلای ڕاست یان بەلای چەپدا لابدات، بۆ ئەوەی درێژە بە ماوەی پاشایەتییەکەی بدات، خۆی و نەوەکانی لەنێو ئیسرائیل. ");
INSERT INTO ckb_vpl VALUES ("DT18_1","006_18_1","DEU","18","1","1","کاهینە لێڤییەکان و هەموو هۆزی لێڤی بەش و میراتیان لەگەڵ ئیسرائیل نابێت، بەڵکو قوربانییە بە ئاگرەکان بۆ یەزدان بەشی ئەوانە، چونکە ئەمە میراتە بۆیان. ");
INSERT INTO ckb_vpl VALUES ("DT18_2","006_18_2","DEU","18","2","2","جا لەناو براکانیان میراتیان نابێت، یەزدان میراتی ئەوانە وەک بەڵێنی پێدان. ");
INSERT INTO ckb_vpl VALUES ("DT18_3","006_18_3","DEU","18","3","3","ئەمەش مافی کاهین دەبێت لەسەر گەل، لەوانەی قوربانی سەردەبڕن، جا گا بێت یان مەڕ، شان و شەویلاکی خوارەوە و گۆشتی لاملی و ناوسکەکەی بە کاهین دەدرێن. ");
INSERT INTO ckb_vpl VALUES ("DT18_4","006_18_4","DEU","18","4","4","هەروەها یەکەمین بەرهەمی دانەوێڵە و شەرابی تازە و زەیت و یەکەم بڕینەوەی خوری مەڕەکانتانی پێدەدەن، ");
INSERT INTO ckb_vpl VALUES ("DT18_5","006_18_5","DEU","18","5","5","چونکە یەزدانی پەروەردگارتان لەناو هەموو هۆزەکانتان هەڵیبژاردن هەتا بوەستن بۆ خزمەتکردن بە ناوی یەزدانەوە، خۆیان و کوڕەکانیان هەتاهەتایە. ");
INSERT INTO ckb_vpl VALUES ("DT18_6","006_18_6","DEU","18","6","6","ئەگەر لێڤییەک لە هەر یەکێک لە شارۆچکەکانی ئیسرائیل، لەو شوێنەی دەژیێت و پڕ بە دڵی خۆی هات بۆ ئەو شوێنەی کە یەزدان هەڵیدەبژێرێت و ");
INSERT INTO ckb_vpl VALUES ("DT18_7","006_18_7","DEU","18","7","7","بە ناوی یەزدانی پەروەردگارییەوە خزمەتی کرد، وەک هەموو برا لێڤییەکانی کە لەوێ لەبەردەم یەزدان وەستاون، ");
INSERT INTO ckb_vpl VALUES ("DT18_8","006_18_8","DEU","18","8","8","ئەوا بەشیان یەکسان دەبێت لە خواردن، بێجگە لەوەی لە میراتی خێزانەکەی دەفرۆشرێت. ");
INSERT INTO ckb_vpl VALUES ("DT18_9","006_18_9","DEU","18","9","9","کاتێک چوونە ناو ئەو خاکەی کە یەزدانی پەروەردگارتان پێتان دەدات، فێر مەبن وەک نەریتە قێزەونەکانی ئەو نەتەوانە بکەن. ");
INSERT INTO ckb_vpl VALUES ("DT18_10","006_18_10","DEU","18","10","10","ئەوانەتان تێدا نەبێت کە کوڕەکەی یان کچەکەی وەک قوربانی بسووتێنێت، هەروەها نە ئەوانەی فاڵگرتنەوە دەکەن و نە بەخت خوێندنەوە و نە جادووگەری و نە سیحربازی، ");
INSERT INTO ckb_vpl VALUES ("DT18_11","006_18_11","DEU","18","11","11","نە ئەوانەی نوشتە دەکەن و نە ئەوانەی نێوانگرن و نە ئەوانەی ڕۆح ئامادەکارن و نە ئەوانەی ڕاوێژ بە مردووان دەکەن، ");
INSERT INTO ckb_vpl VALUES ("DT18_12","006_18_12","DEU","18","12","12","چونکە هەرکەسێک ئەم نەریتانە پەیڕەو بکات لەلای یەزدان قێزەونە، هەر بەهۆی ئەم نەریتە قێزەونانەیە یەزدانی پەروەردگارتان نەتەوەکان لەبەردەمتان ڕاو دەنێت. ");
INSERT INTO ckb_vpl VALUES ("DT18_13","006_18_13","DEU","18","13","13","لەلای یەزدانی پەروەردگارتان بێ کەموکوڕی دەبن. ");
INSERT INTO ckb_vpl VALUES ("DT18_14","006_18_14","DEU","18","14","14","ئەو نەتەوانەی ئێوە جێیان دەگرنەوە گوێ لە بەخت خوێنەر و فاڵگرەوان دەگرن، بەڵام بۆ ئێوە یەزدانی پەروەردگارتان بەم شێوەیە ڕێی نەداوە. ");
INSERT INTO ckb_vpl VALUES ("DT18_15","006_18_15","DEU","18","15","15","یەزدانی پەروەردگارتان لەنێوتان لە براکانتان پێغەمبەرێکی وەک منتان بۆ دەستنیشان دەکات، دەبێت گوێی لێ بگرن. ");
INSERT INTO ckb_vpl VALUES ("DT18_16","006_18_16","DEU","18","16","16","بەگوێرەی هەموو ئەو شتانەی لە یەزدانی پەروەردگارتان داوا کرد لە حۆرێڤ لە ڕۆژی کۆبوونەوە و گوتتان: «با ئیتر گوێمان لە دەنگی یەزدانی پەروەردگارمان نەبێت و ئەم ئاگرە مەزنەش نەبینینەوە، نەوەک بمرین.» ");
INSERT INTO ckb_vpl VALUES ("DT18_17","006_18_17","DEU","18","17","17","یەزدانیش پێی فەرمووم: «چاکیان کرد لەوەی گوتیان، ");
INSERT INTO ckb_vpl VALUES ("DT18_18","006_18_18","DEU","18","18","18","لەنێو براکانیان پێغەمبەرێکی وەک تۆیان بۆ دادەنێم و وتەکانم دەخەمە دەمی و ئەوەی فەرمانی پێدەدەم ئەو بۆیان پێی دەدوێت. ");
INSERT INTO ckb_vpl