﻿USE sofia;
DROP TABLE IF EXISTS sofia.cjoNT_vpl;
CREATE TABLE cjoNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cjoNT_vpl WRITE;
INSERT INTO cjoNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Paerani ijeekawitani Jesokirishito jaka kipatsikika. Tekirani ijeekini jaka, ijeekini itakaantaworini ichariniiteni Iraviirini eejatzi Awaraamani. Iroñaaka nojankinateeyemironi iwaeropaeni riraga ichariniiteni riraga Jesokirishito. ");
INSERT INTO cjoNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Eenironi ijeekini paerani rirori Awaraama, iinani otzimiri itomini iitachari Ijaaka. Itomini irira rirotaki Jakoowo. Itomipaenini rirotaki Joraa eejatzi rirentzipaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Itomini riraga Joraa rirotaki riraga Paareshi eejatzi Shaari. Rinironi irirapaeni owaero Tamaara. Itomini riraga Paareshi iwaero Eshiroomo. Itomini irira rirotaki Araami. ");
INSERT INTO cjoNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Itomini irira rirotaki Aminagaawa. Irira rirotaki ashitaririni Naashoni. Itomini riraga Naashoni rirotaki Sharimoo. ");
INSERT INTO cjoNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Riraga Sharimoo rirotaki ashitaririni Woosho. Rinironi rootaki Raawa: rootaki paashinijatotatsiri atziri. Itomini riraga Woosho iwaero Oweeri. Rinironi rootaki Roota: rootaki paashinijatotatsiri atziri eejatzi. Itomini riraga Oweeri rirotaki Isayii. ");
INSERT INTO cjoNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Itomini irira rirotaki Iraviiri, riraga jewawentziririni joriiyopaenini paerani. Ari ikaataki irinta shiramparipaenini 14. Roojatzi ikoñaatapaaki itomini riraga Iraviiri iitachari Sharamoo. Rinironi rowaga iinani Oriiyashi tekira ikami. ");
INSERT INTO cjoNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Itomini rirori Sharamoo riraga Rorowaama. Itomini irira rirotaki Awiiyashi. Itomini riraga Awiiyashi rirotaki Aasha. ");
INSERT INTO cjoNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Itomini irira rirotaki Joshepaata. Itomini riraga Joshepaata iwaero Joraama. Itomini irira rirotaki Oshiiyashi. ");
INSERT INTO cjoNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Itomini riraga Oshiiyashi rirotaki Jotaama. Itomini irira rirotaki Akaashi. Itomini riraga Akaashi iwaero Eshikiiyashi. ");
INSERT INTO cjoNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Irira rirotaki ashitaririni Manasheeshi. Itomini irira rirotaki Amoo. Itomini riraga Amoo rirotaki Joshiiyashi. ");
INSERT INTO cjoNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Riraga Joshiiyashi rirotaki ashitaririni Jekoniiyashi, eejatzi rirentzipaeni. Ari ikaataki jaka eejatzi paashini shiramparipaenini 14. Ijeekantari riraga Jekoniiyashi eejatzi rirentzipaeni ipokapaaki joraaropaeni poñaachari inteenanta kipatsi iitachari Wawirooniya. Ranaakotakiri joraaro joriiyopaeni roojatzi ragaeyakirini osheki irirapaeni roojotakiri raanakiri inampikinta rantawaeteniri. Raanakiri maawaeni joriiyopaenini janta inampikinta. ");
INSERT INTO cjoNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Roojatzi ikoñaatapaaki itomini riraga Jekoniiyashi iitachari Jaratyeeri. Itomini rirotaki iwaero Jorowaweeri. ");
INSERT INTO cjoNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Itomini riraga Jorowaweeri rirotaki Awyoori. Irira rirotaki ashitaririni Eryakiimi. Itomini irira iwaero Ajooro. ");
INSERT INTO cjoNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Itomini riraga Ajooro rirotaki Sherooko. Itomini irira iwaero Akiimi. Ro itomini irira rirotaki Eryooro. ");
INSERT INTO cjoNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Irira rirotaki ashitaririni Eryaari. Itomini irira iwaero Mataa. Itomini riraga Mataa rirotaki Jakoowo. ");
INSERT INTO cjoNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Riraga Jakoowo rirotaki ashitaririni Josee. Irira ikashiyakawo rayero Mariiya, rowaga riniro Jesoshi, iitachari eejatzi Rotyaantanewo Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ari ikaataki maawaeni rirori shiramparipaenini eejatzi 14. ");
INSERT INTO cjoNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Iroñaaka nokamantemi tsikarika ikanta ikoñaatantapaakari paerani Jesokirishito. Rinirontapaakyaawo irira rowaga tsinani oetachari Mariiya. Eejatzi ikashiyakawo rayero Josee, omaanta tekiraata imatziro, tekiraata rayiro. Roojatzi omotzitashitaka, tema otajonkapaakiro Ishire Tajorentsi omotzitakaapaakiro. ");
INSERT INTO cjoNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Riraga Josee tema iñaakirowa omotzitaki; roojatzi ikenkithashiryaantawitaka, ikantzi: “Tee okameethatzi iroka tsinani. Tema oshinetakari paashini shirampari. Iroñaaka eero nayiro”. Omaanta irira ikameethataki, rootaki ikowantakari ikamintheero. Tee ikoyi rowashiwentayero. Ikenkithashiryaawitaka: “Eero nokantziri atziripaeni ishirontawentawokari. Apaniroeni nokamantathatero, nokantero: ‘Eero nayimi’ ”. ");
INSERT INTO cjoNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Omaanta eenirorika ikenkithashiryaawitaka, imaanaki roojatzi romapokapaakiri ronampiri Tajorentsi romishimpyaakiri, ikantapaakiri: —Josee, tema eeroka icharineetenipero Iraviirini. Eero pikenkithashiryaakotawo pookero Mariiya. Tekatsi oshinetaya paashini shirampari. Omotzitakirira tema otajonkakitziiro Ishire Tajorentsi, rootaki ikoñaatantyaari. ");
INSERT INTO cjoNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Aririka otzimaki otomi, piiteri Jesoshi. Rowawijaakoteri anteeyirorini kaari kameethatatsi, rootaki piitantyaariri iwaero Jesoshi. —Jee, aritaki. Roojatzi ipiyanaka riraga ronampiri Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Roojatzi otzimantakariri otomi omonkaatantyaari rojankinatakotzitakarini paerani kamanantzirorini iñaani Tajorentsi iitachari Iseeyashini. Rootaki Ishire Tajorentsi ojankinatakaakiriri. Ajaa, iroka ikantziri: ");
INSERT INTO cjoNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Iinja omotzitashitanakya apaani kaari shinetariri shirampari, otzimeri otomi, iiteeteri Emanoeri”. Okantakotziri Emanoeri: “Itsipatakae Tajorentsi”. Rootaki iroka ikantakiriri rirori ronampiri Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ipiriinantanaka Josee, ikemijantaperotanakiro ikantakiriri ronampiri Tajorentsi. Riyaatashitakiro Mariiya, ikantakiro: —Aritaki iinja naaperotemi. Omaanta iroñaaka thame nopankoki. ");
INSERT INTO cjoNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Omaanta tekira imatziro Josee rowaga Mariiya, roojatzi otzimantakari otomi. Ikoñaatantapaakari, riraga Josee iitakiri itominthori Jesoshi. Roojatzikya raantaperotanakawo. ");
INSERT INTO cjoNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ikoñaatapaaki Jesoshi janta nampitsiki owaero Weri. Ojeeki Weri janta Joreeyaki. Ikoñaatantapaakari eeniro ijeeki Erooreshi Jerojareeki. Irintapaeni kaari joriiyotatsiri, omaanta ipinkathariwenteeyakirini maawaeni joreeyajatzi. Roojatzi rareetapaenta apaanipaeni yotanitzinkaripaeni poñaachari paashinikinta kipatsi, ipoñaaka janta inteenanta. Ikinapaaki riyowapiintzinta oorya. Riyotapiintawitari ompokiropaeni iitarikamakya. ");
INSERT INTO cjoNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ipokantapaentari janta rojampitapaakiri jerojareejatzi, ikantapaakiri: —¿Tee piñiiri tsika ijeekakika riraga jewaperowenterini ijoriiyotzinkaritepaeni, riraga owakira koñaateentsiri? Janta nonampikinta noñaawakiri ikontetapaaki jenoki ompokiro, rootaki niyotantanakari koñaatapaaki. Nopokantapaakari iroñaaka, nopinkathateri, nokimoshirewenteri. ");
INSERT INTO cjoNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ikemantawakariri riraga pinkathari Erooreshi, tee inimotanakiri, ikenkithashiryaanaka: “Tee nokoyi paashini jewawenantatsini, naaka apaniroeni”. Eejatzi maawaeni jerojareejatzi ikemantawakariri, ikenkithashireeyanakani. ");
INSERT INTO cjoNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Roojatzi ikaemakaantakiri riraga Erooreshi maawaeni jewatatsiripaeni ñaanakowenantatsiripaeni janta Tajorentsipankoki. Eejatzi ikaemakaantakiri maawaeni jewatakayitziririni iyotaantzirori Iwaperite Tajorentsi. Rojampitawakiri maawaeni, ikantawakiri: —¿Oetaka okantziri Iwaperite Tajorentsi? ¿Tsika ikoñaatekapa Rotyaantanewo Tajorentsi? ");
INSERT INTO cjoNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ikantanakiri: —Ari okantzi: ikoñaate janta Weriki jaka Joreeyakika. Tema paerani aritaki rojankinatakotzitakarini kamanantzirori iñaani Tajorentsi iitachari Mikiiyashini, ikantaki: ");
INSERT INTO cjoNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Janta Joreeyaki ari ojeeki nampichaaniki oetachari Weri. Tee ikemakotawitawo maawaeni atziri omaanta anaakotero maawaeni nampitsi antawo Joreeyaki ikemakotero maawaeni atziri. Rooma ikoñaatzimoteri jeekatsiri janta Jewatatsini, ikempoyeeyerini maawaeni joriiyopaeni”. ");
INSERT INTO cjoNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Riraga Erooreshi imanakiro maawaeni okaatzi ikemawakiri, ikaemakaanteeyakirini riraga yotakopiintawitariri ompokiropaeni. Ipokantapaakari, ikantawakiri: —¿Tsika okaatzika piñaantakariri ompokiro ikontetapaaki piyotantakari ikoñaatapaaki jewatatsini? ");
INSERT INTO cjoNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ikemawakiri ikamantapaakiri, roojatzi rotyaantawakiri ikantawitawakari: —Kameetha piyaate Weriki paminakiteri tsikarika ijeekaperotzi eentsi. Aririka piñaapaakiri pipokaate jaka pikamantaatena, kameetha nareetakityaari naari nopinkathatantakityaariri nokimoshirewenteri eejatzi. —Jee, ari. ");
INSERT INTO cjoNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Ikemantapaakariri ikantawakiriri, rowaaganaka riraga yotakotziriri ompokiropaeni. Roojatzi janta niyanki awotsi iñaawaatziiri eejatzi ompokiro jenokira iñaakiri chapinki janta ipoñaakanta. Iñaantawaariri ikimoshireperotanaki. Reewatanakiri apatziro rowakaanakiri janta ijeekakinta eenchaaniki; ari ikatziyapaaka janta jenoki ipankokira. ");
INSERT INTO cjoNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Roojatzi rareetantapaaka janta, ikyaapaaki pankotsiki, iñaapaakiri Jesoshi, eejatzi riniro. Rotziwerowashitapaakari, riwethatantapaakari, eejatzi ipinkathatapaakiri ikimoshirewentapaakiri. Roojatzi itaaparyaantapaakawo itsiwoote, raakiro inowikyaakiro iraata oorotatsiri kameethaperotatsiri, pinaperotachari. Eejatzi raakiro apite kajankaritatsiri eejatzi kameethatatsiri. Roojatzi ipashitantapaakari Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Roojatzi imaapaaki. Imishiwaetakaakiri Tajorentsi. Ikantakiri: —Eero pipiyanaa janta Erooreshiki. Ikemawakiri roojatzi ikinapithatantanaari paashiniki awotsi, riyaatapithateeri iipatsiteki. ");
INSERT INTO cjoNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Roojatzi ipiyeeyanaani inampiki rirori yotakotziriri ompokiropaeni, roojatzi rapiitakiro Josee romishimpyaantakariri ronampiri Tajorentsi, ikantapaakiri: —¡Pipiriinte! Ikowaki pinkathari riraga Erooreshi rowamaakaanteri eentsi. Paanakiri janta Ejiipitoki, eejatzi pitsipatanakyaawo piina. Ari pijeekapaaki janta, eero pipiyaa. Paata nokantemi pipiyee. —Jee, aritaki. ");
INSERT INTO cjoNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Roojatzi ipiriintanaka ikantanaka riyaatapithatanakiri niyankipaeteni tsiteniri. Ishiyakaapithatanakari eentsi janta Ejiipitoki, itsipatanakawo iina. ");
INSERT INTO cjoNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ijeekawitapaaka janta, ijeeki, ijeeki, ojamanitanaki janta, roojatzi ikamanaki riraga Erooreshini. Riraga Tajorentsi ikamantakiri Josee roojatzi ipiyantari iipatsiteki. Rootaki omonkaatantakawori rojankinatakotzitakarini paerani kamanantzirorini iñaani Tajorentsi iitachari Oseeyashini. Rirotaki Awinkatharite jankinatakayiriri. Rojankinatzi: “Ikantakini Tajorentsi: ‘Ijeekawitakya notyomi janta Ejiipitoki, roojatzi nokamanteeri ipiyee’ ”. ");
INSERT INTO cjoNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Rootaki riyotantanakari riraga Erooreshi teera ipiyaa yotakotziriri ompokiropaeni, ikantaki: —Irintapaeni ramatawitakinakya. Ikijanaka roojatzi rotyaantanakiri joraaropaeni, ikantakiri: —Piyaate janta Weriki, eejatzi piyaate janta paashinipaenikira pankotsikira okaakini. Powamaakiteriroña eentsipaeni janta. Pithonkeri maawaeni shirampari owakira yowatsiri roojatzi irintapaeni monkaateenchari apite rojarentsite, powamaakiteriroña maawaeni. —Jee, ari. Rootaki ikanantakawori iroka, rooma ikantziri chapinki riraganki yotakotziriri ompokiropaeni ikantzi tekira imonkaatziro Jesoshi rojarentsite apite. Ikenkithashiryaawitaka iita eeniro ijeeki Jesoshi Weriki. ");
INSERT INTO cjoNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ari omonkaataka iroka rojankinatzitakarini paerani kamanantzirori iñaani Tajorentsi iitachari Jeremiiyashini. Rojankinatakotakironi paashini nampitsi okaakini Weri, ikantzi: ");
INSERT INTO cjoNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Iinja ikemakoetero janta Ramaaki ari iraakoeyakarini ramaajatopaeni otomipaeni, osheki okoetyagaeyakirini. Rowaga ojawaenini Rakeeri eejatzi tsinanipaeni iraakotyaari otomipaeni eero okaatzimotziro iraakotyaari. Rootaki iraanteeyakaririni okoetyagaeyanakirini rowamagaetakiri otomipaeni, maawaeni”. ");
INSERT INTO cjoNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Tee ojamanitzi ikamantakari Erooreshini, eeniro ijeeki riraga Josee janta Ejiipitoki. Roojatzi romishimpyaantaari ronampiri Tajorentsi, ikantapaeri: ");
INSERT INTO cjoNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Iroñaaka okameethatzi pipiyeerakya janta piipatsiteki, tema kamaki kowawitachari rowamayerimi Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ikemawakirira roojatzi ipiyantaa iipatsiteki oetachari Ishirayeeri. Riyaatawitanaka Weriki raanakiri eentsi eejatzi itsipatanakawo iina. ");
INSERT INTO cjoNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Omaanta niyanki awotsi ikemakotakiri Arekiraawo, itomini Erooreshini, iroñaaka ipinkatharitzi ipoyaatakari ashitaririni. Ari ithaawanaki rirori Josee, tee ikoyi riyaatanee janta. Roojatzi rapiitakiro romishimpyaagaeri ronampiri Tajorentsi, ikantapaakiri: —Eero piyaatzi pinampiki paerani, riraga Arekiraawo rowamaakaantawakirikari eentsi. Rootaki riyaatantanakari iroñaaka janta Karireeyaki. ");
INSERT INTO cjoNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ikanta rareetapaaka janta ijeekapaaki nampitsiki tsikarika ijeekawita paerani oetachari Najareete, aritaki rantaritapaaki Jesoshi janta. Rootaki omonkaatantakari iroñaaka ikantakirini kamanantzirorini iñaani Tajorentsi paerani, ikantzi: “Ipoñaakya riraga Rotyaantanewo Tajorentsi Najareeteki”. ");
INSERT INTO cjoNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ikanta riyaataki Jowa, riraga kaawoshitakotziriri Tajorentsi janta Joreeyaki okaankiityeenta. Aritaki ritanakawo ikenkithatakaapiinteeyakirini atziripaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ikantapiinteeyirini: —Pikenkithashiryaawakyaata, eero pikimitaa paerani. Pipakagaero kaari kameethatatsi panteeyakirini. Pameenteeyari Tajorentsi iroñaaka. Rooteentsi reewawentemi, eejatzi raminakowiritantemi. ");
INSERT INTO cjoNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Paerani ikenkithatakotzitakarini Jowa riraga kamanantzirorini iñaani Tajorentsi iitachari Iseeyashini. Iroka rojankinatakotzitakaririni, ikantzi: “Eenitatsi iinja atziri kenkithatakayerini atziripaeni janta okaankiityeenta, ikanteri: ‘Paamayarirapa Awinkatharite, pikameethatanaki pineshironkatawakaeya’ ”. ");
INSERT INTO cjoNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Eejatzi Jowa, tee ikithaatawo kithaarentsi kameethari. Omaanta ikithaatawo ontyaantsi iwitzi kameeyo. Eejatzi ishirikathakitari mashitsimashi ikimitakari riraga Iriiyashi kamanantzirori iñaani Tajorentsi. Rowapiintari kimitariri tsitsiri. Eejatzi ithotziri iyaa pitsi eenitatsirika. ");
INSERT INTO cjoNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ipokashitapaakiri maawaeni jerojareejatzi. Eejatzi ikemijantapaakiri maawaeni joreeyajatzi. Eejatzi maawaeni jeekatsiri okaakini iñaa oetachari Joriraani, eejatzi ipokashitapaakiri ikemijantapaakiri. ");
INSERT INTO cjoNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ikantapaakiri kemaperotapaakiriri: —Niyotzi eenitatsi kaari kameethatatsi nantziri. Nokowaperotzi ineshironkaperotena Tajorentsi rowawijaakotena. Roojatzi ikaawoshitakotantawakariri Tajorentsi riraga Jowa iñaakira oetachari Joriraani. ");
INSERT INTO cjoNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Eejatzi ipokaeyawitakani warijeeyopaeni eejatzi saroseeyopaeni. Ikowawitaka ikaawoshitakotawakirimi rirori eejatzi. Omaanta ikijathatawakiri Jowa ikantawakiri: —¡Eerokateeyakini maankipaeni! Pikimiteeyakaarini kamaaripaeni. Tema pitheeyawaetashita eejatzi pamatawitashitari maawaeni. Tee okameethatzi pantziri. Tee pikowaeyawitani piyaate paamariki kaari tsiwakanitatsini, rootaki pikowantawitakari pikaawoshitakotyaarimi Tajorentsi. Eero pikenkithashiryaashiwita eero rowashironkaemi Tajorentsi tema pikaawoshitakotashitatyaari. ");
INSERT INTO cjoNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Pikowakirika nokaawoshitakotawakimiri Tajorentsi pityaawo pikenkithashireeya pijeekanteeyari kameetha, pookaero kaari kameethatatsi pantapiinteeyakirini niyotantyaari tee pikimita paerani. ");
INSERT INTO cjoNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Eero pikantawaetashita: “Nocharinetakari Awaraamani, rootaki niyotantakari aritaki nawijakotee”. Pamatawitashitaka eeroka apaniroeni. Tee paapatziyaperotari. Ikowakirikami riraga Tajorentsi, imatero ipeyeromi atziri iroka mapika osheninkateeyaarinimi Awaraamani, aritaki rantakiromi. ");
INSERT INTO cjoNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Maawaeni inchato kaari kithokitatsi tema ari atowakiro apiyotero atagaeyeroni paamariki. Eejatzi eerori pikimiteeyakawoni inchato kaari kithokitatsi. Kyaaryoowa rookimikari eerori Tajorentsi paamariki kaari tsiwakanitatsini. ");
INSERT INTO cjoNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Niyotakiririka rookaero atziri kaari kameethatatsi rantziri, nokaawoshitakotawakiri Tajorentsi iñaakira. Omaanta kaakitaki impaetapaakinani, riraga Rotyaantanewo Tajorentsi. Ranaakotakina, tema rirotaki jewaperowenantatsiri. Aritaki ikithaatakaapaakaero Ishire Tajorentsi maawaeni aapatziyakariri amitakotantyaariri. ");
INSERT INTO cjoNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Owiitakirorika arooso aakiro otzinkayitakiro. Rowaga otaki ataakiro paamaariki. Rooma rowaga owatha otetakiro akempoyaantapiintaworiki. Eejatzi ikimiteri riraga impaetakinari. Tema rinashityaari atziripaeni. Retakotyaari aapatziyeeyakaririni ijeekimotantyaariri janta okameethatzinta omaantakya kaari kameethatatsi rookaerini paamariki kaari tsiwakanitatsini. ");
INSERT INTO cjoNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ikantaka ipoñaanaka Karireeyaki Jesoshi, riyaataki iñaaki oetachari Joriraani. Riyaatashitakiri Jowa ikaawoshitakotantawakyaariri Tajorentsi, ");
INSERT INTO cjoNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","omaanta tee ikowawita riraga Jowa. Ikantawitawakari: —Eero nokaawoshitakotzimiri Tajorentsi eerori. Rooma eeroka kaawoshitakotanakinarinikya Tajorentsi naari. ¿Iitaka pikowantari nokaawoshitakotawakimiri eeroka? Rooma eerokataki pinkatharitatsiri. ");
INSERT INTO cjoNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ikantapaakiri: —Rootaki okameethatantari iroñaaka pikaawoshitakotenari Tajorentsi naaka amonkaatantyaawori ikowakaakaeri. Roojatzi ikantawakiri: —Jee ari, pipokeeta jaka. ");
INSERT INTO cjoNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Roojatzi ikaawoshitakotantawakari rirori. Roojatzi ishitowaataneera iñaaki, iñaawakitziiro Ishire Tajorentsi opoñaaka jenokinta Tajorentsikinta ayiitashitapaakiri okimiwitapaakari jamomo ookantapaakari. ");
INSERT INTO cjoNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Roojatzi ikemayitawakirini Tajorentsi janta jenokinta, ikantanaki: —Rirotaki notyomi nonintashireperotanewo. Osheki niweshiryaawentakari. ");
INSERT INTO cjoNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Roojatzi riyaataki Jesoshi tekatsinta atziri ipanko: okaankiityeenta janta. Tema iyaatakaakiri Ishire Tajorentsi. Rootaki iyaatakaantakariri iñaanantyaariri iwinkatharite kamaaripaeni. Ikowawitaka irira rantakayerimi Jesoshi kaari kameethatatsi ranaakotantyaaririmi. ");
INSERT INTO cjoNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Eeniro ijeekapaaki riraga Jesoshi janta okaataki 40 kitejiri tee rowa, ayimaperotakiri itashe. ");
INSERT INTO cjoNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Roojatzi ipokashitapaakiri riraga iwinkatharite kamaaripaeni. Iñaantawitapaakari, ikantawitapaakari: —Eerokarika Itomipero Tajorentsi, pipeyero mapika opeyanakya owanawontsi poyaari. ");
INSERT INTO cjoNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Omaanta ikantawakiri: —Eero nantziro. Okantzi Iwaperite Tajorentsi: “Tee apatziro akoyiro owanawontsi ashintsiwathatantyaari, inta kowaperotachari akemijantaperotero maawaeni ikowakaakaeri Tajorentsi ashintsitantyaari ashireki”. ");
INSERT INTO cjoNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Roojatzi raanakiri janta Jerojareeki ikatziyakaakari janta okaapankatapaakinta Tajorentsipankoki. ");
INSERT INTO cjoNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Iroñaaka ikantawitanakari: —Eerokarika Itomi Tajorentsi, pomyaanakyaatya jaawiki, ñaa, eero pikamapaaki. Pikenkithashireerotya okaatzi okantzimiri Iwaperite Tajorentsi: “Ari rotyaantakimiri Tajorentsi ronampiripaeni ikempoyeemi. Ari raawakimi rakokira eero pikagaantapaaka jaawikinta mapiki”. Ñaakiro, ¿iitaka pithaawantakari? ");
INSERT INTO cjoNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Rapiitziri ikantawakiri: —Eero nomyaa. ¿Iitaka noñaanantyaariri Pawa? Eejatzi paashini okantzi Iwaperite: “Tee okameethatzi añaantawityaari riraga Tajorentsi, rowashironkaekari”. ");
INSERT INTO cjoNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Roojatzi riweyaantanakari raanakiri antawoki ochempi. Roñaagakiri Jesoshi maawaeni kipatsipaeni rashi jewawenantatsiripaeni, iñaakiro maawaeni nampitsi owaneenkataka eejatzi maawaeni rowaagawo jeekayitatsirini, ");
INSERT INTO cjoNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","ikantawitanakari: —Naapatziyakagaeyemirini maawaeni jeekatsiri kipatsikipaeni, aririka pipinkathatena naaka. ");
INSERT INTO cjoNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Omaanta ikantanakiri: —Eero naapatziyimi. Piyaatekya inteenanta, kamaari, eerokakya Jatanaashi. Rooma okantzi Iwaperite Tajorentsi: “Pipinkathateri Awinkatharite, tema rirotaki Tajorentsi. Apatzirokya irira paapatziyari, pipinkathateri, eejatzi pikimoshirewenteri”. ");
INSERT INTO cjoNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Roojatzi riyaatantanaka inteenanta riraga iwinkatharite kamaaripaeni. Rimpaetaki ipokapaaki ronampiripaeni Tajorentsi, ramitakotapaakiri, ipapaakiri rowanawo. ");
INSERT INTO cjoNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ikantaka ikemawaki riraga Jesoshi ragaetakiri Jowa romonkyaanteetakariri omonkyaagamentotsiki. Roojatzi ipiyantanaa Karireeyaki, areetapaa inampiki Najareeteki. ");
INSERT INTO cjoNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Roojatzi roshirinkantakawo ipanko, riyaatanaki Kaperinawooki ari ijeekapae. Rootaki Kaperinawootatsiri Karireeyawero ojeeki ochereeteki antawo inkaare. Ijeekaki shaporoonijatzi eejatzi nejatariijatzi janta paerani. ");
INSERT INTO cjoNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Awijantakari iroka omonkaatantyaari rojankinatakotzitakaririni paerani riraga Iseeyashini: ");
INSERT INTO cjoNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Ijeeki shaporoonijatzi eejatzi nejatariijatzi janta ochereetekinta inkaareki intatsikeronta Joriraaniki, janta Karireeyaki. Ijeekaeyininta kaari yotziri Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Okimitzimotawitakari eeniro otsitenitzi, okimiwitaka tee riyotawitarini riroripaeni Tajorentsi. Riyaatantyaarimi paamarikinta omaanta iroñaaka eero. Okimitzimotantyaariri okitejitakotapaakiri, okimiwita riyotakaakiri riraga Tajorentsi. Riraga iyotziriri rirori eero riyaatzi paamariki”. ");
INSERT INTO cjoNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Aripaete Jesoshi ikenkithatakaanakiri maawaeni atziri janta, ikanteeyakirini: —Pikenkithashiryaawakyaata, eero pikimita paerani inta pipakaero kaari kameethatatsi pantziri. Pameentyaari iroñaaka Tajorentsi. Rooteentsi kameetha ipinkathariwenantemiri. ");
INSERT INTO cjoNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ikinanaki janta ochereetekira rowaga inkaare iitachari Karireeya. Ikinanaki iñaapaakitziiri riraga Shimo iiteetziri eejatzi Peetero, eejatzi rirentzi riraga Antereeshi. Irira apite ishiryaatapiintzi shima. ");
INSERT INTO cjoNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ikanta Jesoshi ikaemapaakiri, ikantapaakiri: —¿Eeroka shiryaawaetapiintatsiri? Pipoke, thame poyaatanakina aritaki niyotaakimi paapatziyakaapiintyaari atziripaeni Pawa Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Roojatzi rookantanakawo ishiryaamento royaatanakiri riyotaantyaariri. ");
INSERT INTO cjoNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ro ijanthaneentawitanaka iñaapaakitziiri Jantyaako eejatzi rirentzi Jowa, rirotaki itomi apite Sewereeyo. Ijeekaki ipitoki ishirikawaetzi ishiryaamento. Itsipatari ashitariri. Ikaemapaakiri ikantapaakiri: —Thame poyaatanakina. ");
INSERT INTO cjoNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Roojatzi royaatantanakariri. Rookanakiri ashitariri ijeekanaki janta ipitoki. ");
INSERT INTO cjoNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ikanta ikinakinawaetzi ikenkithatakaantzi riraga Jesoshi. Ithotyeeyakironi maawaeni Karireeyaki. Janta ikenkithatakaakiri maawaeni atziri nampitsikipaeni ojeekira pankotsi ipiyotantapiintarira joriiyopaeni. Ikamantapaakiri atziripaeni tsikarika ikanta Tajorentsi reewawenanteeyerini maawaeni. Eejatzi retsiyatakoeyawakirini maawaeni mantsiyatzinkaripaeni paashinijatopaeni matakiriri mantsiyarentsitayitatsirinipaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Riraga jeekaeyatsirini inteenanta janta Shiiryaki ithotyaanaka ikemakoeyakirini Jesoshi. Roojatzi ramanteeyanakaririni maawaeni mantsiyari, kyaantariri kamaari, kijopookitatsiri, katsiwaetatsiri, maawaeni. Retsiyatakotawaeri Jesoshi maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Royaatanakiri osheki karireeyajatzi, tekaaporishijatzi, jerojareejatzi, joreeyajatzi eejatzi poñaaneenchari intatsikeronta Joriraaniki. Royaatanakiri maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Paashiniki kitejiriki iñaawakiri piyotawentariri ikaataki oshekini atziri. Rootaki itonkaantanakari eechonkiini tyonkaarikiini. Ari ijeekapaaki jaga. Roojatzi ipokanaki riyotaanewopaeni okaakini, eejatzi ipiyotawentapaakari riraga atziripaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Roojatzi riyotagaeyawakirini, ikantawakiri: —Aririka pikowaperote pikimityaari Tajorentsi rootaki reentsitetantemiri, pikemijantena iroñaaka. ");
INSERT INTO cjoNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Eerokarika yotakotachari tee pikameethatzi, aritaki riweshiryaakaakimi riraga Tajorentsi, kameetha ipinkathariwentakimi. ");
INSERT INTO cjoNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Eerokarika owashiretzinkari, aritaki riweshiryaakaakimi Tajorentsi roemoshirenkakimi. ");
INSERT INTO cjoNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Eerokarika maerishiretatsiri aritaki riweshiryaakaakimi Tajorentsi ineshironkatakimi reentsitetakimi. ");
INSERT INTO cjoNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Eerokarika kowaperotzirori ikoyiri Tajorentsi, aritaki riweshiryaakaakimi irira ramitakotakimi. ");
INSERT INTO cjoNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Eerokarika neshironkatantaniri maawaeni atziri, aritaki riweshiryaakaakimi Tajorentsi tema ari ineshironkaperotakimi eeroka. ");
INSERT INTO cjoNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Eerokarika kameethatzinkari pajankaneki, aritaki riweshiryaakaakimi Tajorentsi aritaki piñagaeri. ");
INSERT INTO cjoNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Eerokarika omaeryaantatsiri paashinipaeni atziri ijeeki kameetha, aritaki riweshiryaakaakimi riraga Tajorentsi. Rootaki kameetha ikananteetemiri: “Eerokataki reentsite Tajorentsi”. ");
INSERT INTO cjoNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Eerokarika antaperotzirori kameethaperotatsiri, rootaki ikijantemiri atziripaeni, aritaki riweshiryaakaakimi Tajorentsi. Rooma reentsitetakimi eejatzi piyotzi reewawentakimi. ");
INSERT INTO cjoNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Riyotakirorika atziri paapatziyakina, rootaki ikantzimatantemiri, rowashironkaantemiri, eejatzi itheeyakotantemiri, itheenkemi, omaanta eero pikantashiryaa, eero. Aritaki riweshiryaakaakimi riraga Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Omaanta pikantyaani piweshiryaaperotanakya, rooma ipinataperotawaemi iinja riraga Tajorentsi janta okameethaperotzinta. Eero pimaejantziri: tema paerani ikijeetakirini rirori kamanantzirorini iñaani Tajorentsi eejatzi. ");
INSERT INTO cjoNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Eekiro riyaatatyee Jesoshi riyotaaperoteri, ikanteri: —¡Pamine sha! Noshiyakaawentemiro tziwi. Tema aaka akatyokapiintziri iwatha tziwiki, eero ishitzitanta. Rooma teerika okatyotzi okaanteekaata. Tema ari ookakiro, tekatsi koyeroni. Ari poshiyeeyawitakawoni eerokapaeni tziwi: eerokateeyakini iyotagaeyakiririni atziri tsika ikantya ikameethatantyaari. ");
INSERT INTO cjoNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Eejatzi ari pikimiwitakawo eeroka oorentamentotsi. Pikenkithashiryaakoterotya. Aririka ojeeki nampitsi tsikarika otonkagaetya, eero omana maawaeni iñeetawakiro otamorekanakyaarika tsiteniriki. Tee otzikaa tema ojeekinta tonkaariki. Eejatzi pikimiteeyawitakawoni, eerokapaeni iyotagaeyiririni maawaeni atziripaeni: eero pimaniro piyotayitziririni, inta kameetha piyotaantayiteroni kameethatayitatsirini. ");
INSERT INTO cjoNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Eejatzi, okimitaka aririka poonthoteri pootamento pipankoki, eero pitankimotakotziri kantziriki, inta powakiri janta jeñokiinira ootaperotantyaari okoñeetye maawaeni pankotsiki pikini paminawaete. ");
INSERT INTO cjoNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ari pikimiwitawo iroka eerokapaeni iroñaaka, apatziro pantero maawaeni kameethatatsiri, riyotantyaari pinampijatzipaeni paapatziyapiintari Tajorentsi, ikimoshiretantyaari riroripaeni, ikanantyaari: “Osheki ikameethaperotzi Pawa Tajorentsi”. ");
INSERT INTO cjoNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Eejatzi riraga Jesoshi ikantziri atziripaeni: —Eero piitakaashiwitawo nopokantari jaka nopakaakayemiro paapatziyawo rojankinarini Moeseeshi, eero. Eejatzi eero piitashiwitakawo nokantemi tee okameethatzi oetarika rojankinatakiro kamanantayitzirorini iñaani Tajorentsi paerani, eero. Omaanta nopokantari niyotaaperoeyemironi ikantaperoeyakirini, piyoperotantyaari kameetha oetarika okantakotziri. ");
INSERT INTO cjoNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Othonkyaarika kipatsi eejatzi jenoki inta eero othonkimaeta rojankinarini Moeseeshi eejatzi kamanantayitzirorini iñaani Tajorentsi. Kyaaryo omonkaatyaawo maawaeni ikantakirini paerani. ");
INSERT INTO cjoNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Eerorika pikemijantaperotziro kaminagaantsi, eejatzi eerorika piyoteeri paashinipaeni atziri ikemijantaperotziro roori, tema pijeekashita janta ipinkatharitzinta Tajorentsi. Omaanta aririka pikemijantaperotero maawaeni rojankinateeyinirini, eejatzi aririka piyotagaeyerini paashini atziri ikemijantaperoeyeroni, ari pipinkathariwenantapae janta ipinkatharitzinta riraga Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","¿Piitakaashiwitakawoma ikameethataki irintapaeni iyotaantawitawori Iwaperite Tajorentsi eejatzi riraga warijeeyopaeni? Iroñaaka nokantemi: tee imonkaatziro ikowakaawitariri Tajorentsi. Eerorika panaakotziri pikameethaperote, eero piyaatzi eerori janta ipinkatharitzinta. ");
INSERT INTO cjoNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Eejatzi ikantzi riraga Jesoshi: —Piyotakiro ikantziri achariniitenipaeni paerani: “Eero powamayiri paashini atziri. Ninkarika owamaantatsiri eejatzi rirori rowamagaeteri”. ");
INSERT INTO cjoNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Omaanta nokantemi naaka: eero pikijiri paashinipaeni: rowashironkaemikari Tajorentsi. Eejatzi eero pikantziri atziri: “Tee piyotzi. Tee añiiro piipatha”. Pikantakiririka ayotaki tema pikijakiri rootaki okameethatantari rowamaakaanantemiri pinkatharipaeni. Eejatzi okimita aririka pikaweyeri atziri pikanteri: “Eeroka majontzi”, tema pikijakiri rootaki okameethatantari rotyaantemi Tajorentsi paamarikinta kaari tsiwakanitatsini. ");
INSERT INTO cjoNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Pamine, piyaatantyaari janta Tajorentsipankoki pikanteri riraga Tajorentsi ipeyakotemiro kaari kameethatatsi pantziri, rootaki pipashitantariri pipira riyotantyaari rirori kyaaryo pookakiro kaari kameethatatsi pantakiro, omaanta eenirorika ikijawentzimiri paashini atziri, ");
INSERT INTO cjoNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","pityaawo piyaatashiteri riraga kijakimiri pikanteri: “Pipeyakotenawo okaatzi nantziri, eero napiitziro kaari kameethatatsi. Eero amaerineentawakaana. Pineshironkatena, kameetha aakameethatawakagaeya”. Pipeyakotantawakagaeyaawoni, pipiyanaki iroñaakakya Tajorentsipankoki, roojatzi pipashitantapaakyaari Tajorentsi oetarika pikowashityaari pipashityaariri. ");
INSERT INTO cjoNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Eenitatsirika kijakimiri ikowaki raanakimi janta pinkathariki ikantakotantemiri, eero pikijiri inta pishintsite pikanteri: “Eero akijawakaa, thame aakameethatawakagaeya”. Aririka rareetakaapaakimi pinkathariki, ikanteri joraaro: “Paanakiri irika”, roojatzi romonkyaakaantawakimi janta omonkyaagamentotsiki. ");
INSERT INTO cjoNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Rooma eerorika pipaperotziri maawaeni pireewitziriri, eerowa roeyowitzimi roojatzi pipinatanteeyariri. ");
INSERT INTO cjoNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Eejatzi ikantziri: —Piyotakiro ikantziri achariniiteni paerani: “Eero pishirontzimotawo piina paashini tsinani, eero pishirontzimotari piimi paashini shirampari”. ");
INSERT INTO cjoNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Nokamantemi naaka: “Aririka piñaawenashireeyaawo tsinani eejatzi pikenkithashiryaakotyaaworika pishirontyaawo, ari eenitatsi pantani, kimitaka piñaathatzimotakawo piina”. ");
INSERT INTO cjoNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Noshiyakaawentemiro: aririka antakayemiro poki kaari kameethatatsi, pikithokireero, pookero. Tema tee pikoyi iyaatakayemi paamariki kaari tsiwakanitatsini. Tema okameethatzi piyaatashiteeya kashetaakini poki janta jenokinta. ");
INSERT INTO cjoNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Aririka antakayemiro pako kaari kameethatatsi, pithatyeero pako pookero. Tema tee pikoyi iyaatakayemi paamariki kaari tsiwakanitatsini. Tema okameethatzi piyaaponthotziitashiteya janta jenokinta. Ñaakiro, tee okameethaperotzi papiitapiintero kaari kameethatatsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Eejatzi ikantzini riraga achariniiteni paerani: “Aririka pikowaki pookaero piina, pojankinateniro paperi pookanteeyaawori, ari okaatapaaki”. ");
INSERT INTO cjoNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Omaanta nokantemi naaka: “Eerowa pookaero piina. Aririka pookaero piina eejatzi pagaerika paashini, tema piñaathatzimotaawo piinaperoni. Agaerika eejatzi paashini oemi piina, eeniro antani: oñaathatzimotaari oemiperoni. Eejatzi riraga agaeroni, eeniro rantani. Omaanta apatziro okameethawita pookaero aririka oñaathatzimotakimiririka paashini shirampari”. ");
INSERT INTO cjoNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Eekiro riyaatatzi ikantziri riraga Jesoshi: —Piyoteeyakini okantziri Iwaperite Tajorentsi, rootaki ikantzirini yotaantatsirini: “Eero pitheeya, eero pikantawaetashita”. Eejatzi ikantakini: “Aririka pikante: ‘Riyotaki Awinkatharite ari nomonkaatemiro maawaeni nokantakimiri. Namatawitakimirika ari rowashironkaakina’. Pikanterorika: ‘Riyotzi Awinkatharite aritaki nomonkaatakimiro maawaeni nokantakimiri’, ari okameethatzi pimonkaataperotero okaatzi pikantakiri”. Rootaki okantakiri rojankinatakirini paerani riraga Moeseeshini. ");
INSERT INTO cjoNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Omaanta nokantemi naari: eero pitheeyawaeta. Aririka pothataakiro pikantziri, ¿iitaka pikowantyaari pikante: “Riyotakiro Awinkatharite nothataakiro nokantzimiri”? Okameethataki pimonkaataperotero maawaeni pikantakiri. Eero eejatzi pikantashita oetarika. Apaanipaeni ikantashita: “Tee notheeya. Ñaakiro, okantani eeniro jenokinta, eejatzi okantani nothataakiro nokantziri”, omaanta ikantashita. Nokantemi eero pikimitari irinta; rooma Tajorentsi rirotaki jeekatsiri jenokinta. Riyotzi pothataakirorika pikantziri. Eenitatsi paashini ikantashita: “Okantani ojeeki jenokinta jeekamentotsi rashi Tajorentsi eejatzi nokimita naari, nokantani kameetha noñaawaetzi”, omaanta ikantashita. Nokamantemi naaka: tema tee okameethatzi pikantawaetashitya oetarikapaeni tema riyotzitakimiro Tajorentsi okaatzi pikantakiri. ");
INSERT INTO cjoNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Eejatzi apaanipaeni ikantashita: “Tee notheeya. Ñaakiro, okantani eeniro kipatsi, eejatzi nokantani nothataakiro nokantziri”, omaanta ikantashita. Nokantemi naaka eero pikimitari irinta, rooma Tajorentsi rirotaki ashitawori kipatsi. Ikantakowentziri maawaeni. Riyotzi pothataakirorika pikantziri. Eejatzi paashinipaeni ikantashita: “Tee notheeya. Ñaakiro, okantani eeniro ojeeki Jerojaree, eejatzi nokantani nothataakiro nokantziri”, omaanta ikantashita. Eejatzi nokantemi naaka, eero oshiyari irinta; rooma Tajorentsi rirotaki otyaantziriri jewawenantatsiri ijeekantari janta. ");
INSERT INTO cjoNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Eejatzi eero pikimitari paashinipaeni kantatsiri: “Tee notheeya. Ñaakiro, kyaaryo eenitatsi noeto, eejatzi kyaaryo tee notheeya”. Eero poshekiiro pikantziri. Eero pimatziro pitajonkero pikitamaatakaantyaawori piishi. ");
INSERT INTO cjoNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Eero pitheeya. Kyaaryoorika pantero oetarikapaeni, kameetha pikante: “Jee, nantakiro”. Eerorika pikoyi pantero, pikante: “Eero nantziro”. Monkaataka. Tee okameethatzi poshekeero piñaani pamatawitantyaariri paashinipaeni. Rowashironkaemikari Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Eekiro riyaatatzi ikanteeyakirini riraga Jesoshi: —Eejatzi ikantakini achariniiteni paerani: “Aririka pikithokiriiteri roki paashini atziri eejatzi ipiyatemi ikithokiriitemiro pashi poki. Aririka pitzinkeryaakoteri raeki paashini atziri, kameetha ipiyatemi eejatzi itzinkeryaakotemi pashi paeki”. ");
INSERT INTO cjoNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Omaanta nokantemi naaka: eero pipiyatari kijakimiri omaanta aririka ipajawootemi rakokira, pishinetayaari jantakironta ipajawootemi eejatzi, eero pipiyatari. ");
INSERT INTO cjoNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Aririka atziri raakaantemi pinkathariki okaatzi pireewitziriri raapithatemirorika piithaari, pipawakiri eejatzi paashini pipewiryaakotarira, eero pikijiri omaanta pineshironkatawakiri. ");
INSERT INTO cjoNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Aririka romperateetemi payeniri rowaagawo apaani kiroometero powawijaaneenteniri apaani paashini kiroometero eejatzi. Eero pikijashita inta pineshironkateri. ");
INSERT INTO cjoNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ikowakotemirika owashironkaachari koetyeemotziriri, pipawakiri. Eejatzi aririka ikantemi: “Pipashitawakinawo iroka eejatzi noepiyeemi osheninka iinja”, ari pipashitawakyaari, eero pithañaapithatari. ");
INSERT INTO cjoNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Eekiro riyaatatzi ikantziri Jesoshi: —Eejatzi ikantaki achariniiteni paerani: “Pineshironkateri neshironkatzimiri eerori. Omaantakya kijakimiri, pikijaperoteri rirori”. ");
INSERT INTO cjoNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Omaanta nokantemi naaka: pineshironkaperoteri kijawitakimiri, owashironkaawitakimiri, maawaeni. Pamanakotyaari, pikanteri Tajorentsi ineshironkateri maawaeni rirori. ");
INSERT INTO cjoNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Rootaki ikowakaakiriri Tajorentsi maawaeni aapatziyariripaeni reentsitetayitakarini. Rirotaki wetsikakiriri oorya: rooryaakoteeyakirini maawaeni atziri, aapatziyariri eejatzi kaari aapatziyari. Eejatzi rowariyaakiniri inkani kameetha oshookantari maawaeni owanawontsi. Eejatzi rowawo maawaeni atziri: riraga aapatziyariri eejatzi kaari aapatziyari, eejatzi kaari yotziri Tajorentsi, maawaeni rowawo. Rootaki ayotantawori ineshironkatziri Tajorentsi maawaeni riraga aapatziyariri eejatzi riraga kaari yotziri. Eejatzi eerori rootaki pineshironkateeyantyaaririni maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Apatzirorika pineshironkatawakiri neshironkatzimiri eerori, eero ijeekakayimi Tajorentsi jenokinta. Riroma riyotzi theenkantatsiri eejatzi ineshironkatawakiri neshironkatziriri. Omaanta panaakoteri eerori, pineshironkateeyirini maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Apatzirorika piwethatashityaari wethatzimiri, eero piyaatzi pijeeki janta jenokinta. Riroma riyotzi maawaeni kaari yotziri Tajorentsi riwethatari wethatariri rirori. Panaakoteri: piwethateeyarini maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Pikameethaperotanaki, pikimitakotyaari Piri jenokinta, riroma osheki ikameethaperotaki irira. ");
INSERT INTO cjoNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Eejatzi ikanteeyakirini Jesoshi: —Paamawentyaawo, pipankinatakotarikari Tajorentsi iñaantemiri atziri rootaki iñaaperotantemiri pikameethatzi eeroka. Aririka pantero iroka tekatsi okantya ipinatemi rirori iinja. ");
INSERT INTO cjoNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Aririka pipashityaari owashironkaenkari koetyeemotariri, eero pithotyeero pikamantziri paashinipaeni. Eero pikimitari riraga oshiyakaawaerintzi raapatziyarimi Tajorentsi. Aririka iperi irira owashironkaenkari oetarika, ikamanteeyakirini maawaeni atziripaeni janta nampitsiki. Ikamanantayitaririni atziripaeni iñaaperotantyaariri ikameethatzi. Aririka iñaaperotawityaari atziri, monkaataka; omaanta eerowa iñaaperotziri riraga Tajorentsi, tekatsi riweshiryaawenantyaari. ");
INSERT INTO cjoNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","4","Eero pikimitari riraga oshiyakaawaetawitachari raapatziyarimi Tajorentsi. Rootaki, aririka pineshironkateri owashironkaenkari, pimaniro, roojatzi riweshiryaawenantemiri Tajorentsi. Rooma riyotakiro irira oetarika pantziniriri, roojatzi okimitakya, aritaki ramitakotakimi eenitatsirika koetyeemotemini. ");
INSERT INTO cjoNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Eejatzi ikantzi Jesoshi: —Aririka pikenkithatakayeri Tajorentsi, eero pikimitari oshiyakaawaetawitachari raapatziyarimi rirori. Ikowaperotziro ikatziya ikenkithatakayeri janta pankotsi ipiyotantapiintarira joriiyopaeni eejatzi janta niyanki nampitsi iñaantyaariri atziripaeni, rootaki iñaaperotantyaariri ikameethatzi. Kyaaryo nokantemiri iroka: monkaataka. Iñaaperotantariri atziripaeni, omaanta tee iñaaperotziri Tajorentsi ikameethatzi. ");
INSERT INTO cjoNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Aririka pikenkithatakayeri Tajorentsi, piyaate apaniroeni pipankoki, pashitakotanakya inthomaenta roojatzi pikenkithatakayeri ashitzimiri riraga Tajorentsi. Riro ñeemini apaniroeni pijeekakira ari iñaaperotemi pikameethatzi, riweshiryaawenantemiri. ");
INSERT INTO cjoNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Aririka pikenkithatakaakiri, eero poshekiiro ñaagantsi anik, anik, anik. Eero pikenkithashiriiro aririka poshekiiro ñaagantsi osheki rootaki ikemijanantemirimi. Rootaki rametari rirori kaari yotziri Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Kyaaryoowa, pikimitarikari riroripaeni. Riyoperotziro Tajorentsi maawaeni koetyeemotakimiri. Tekirani pikanteri, riyotzitakawo. ");
INSERT INTO cjoNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Aririka pikenkithatakayeri Tajorentsi, ari pikimiteero eeroka iroka: “Pawa, niyotzi pijeeki jenokinta eejatzi jaawikika eejatzi pikemijanteeyanani. Osheki pikameethaperotaki. ");
INSERT INTO cjoNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Kameethapero pipinkathawenteeyanani. Nokowaki nantemiro kipatsikika pikowakaakinari, nokimityaari rantziri ponampiripaeni janta jenokinta. Rooma imatakimiro maawaeni pikowakaakiriri. ");
INSERT INTO cjoNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Maawaeni kitejiri pamitakoeyenani nantawaete, eero okoetyeemotantana noyaari. ");
INSERT INTO cjoNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Niyotzi eenitatsi kaari kameethatatsi nantziri, omaanta eero pikijawentanawo, inta pipeyakotenawo. Rooma nopeyakotziniri antakaanawori naari oetarikapaeni, tee nokijiri. ");
INSERT INTO cjoNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Eero pishinetziri kamaari rantakayenawo kaari kameethatatsi. Pikanteetatyeeyaani peewawenteeyenani. Ashi powantyaawo pitajonkawentena. Eejatzi naari, ashi nowantyaawo noñaaperotemi. Rootaki nokantakimiri, ari okaatzi”. ");
INSERT INTO cjoNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Eejatzi ikantzi riraga Jesoshi: —Aririka pipeyakoteniri kijakimiri, eejatzi ipeyakotzitemiro Piri jenokinta eeroka kaari kameethatatsi pantziri. ");
INSERT INTO cjoNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Omaanta eerorika pipeyakoteeniri maawaeni rantakaawitakimiri, eero ipeyakotzimiro riraga ashitzimiri jenokinta okaatzi kaari kameethatatsi pantakiri. ");
INSERT INTO cjoNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Eejatzi ikanteeyakirini: —Aririka pitzitawentyaari Tajorentsi pikenkithatakaantakyaariri irira, eero piyotakaakiri paashinipaeni. Eero pikimitari riraga oshiyakaawaetawitachari raapatziyarimi rirori. Aririka itzitawentyaarimi Tajorentsi, rowashirepootashitaka riyotantyaari maawaeni itzitawentawo. Roojatzi atziripaeni ikenkithatakotziri ikameethaperotzi omaanta kyaaryo tee riweshiryaawentari riraga Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Eero pikimitari riroripaeni. Aririka pitzitakotyaari Tajorentsi kameetha pikishitya eejatzi kameetha pikantya pikiwapootya poshepootya, ");
INSERT INTO cjoNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","eero riyotantzimi riraga atziri pitzitawentatyaari Tajorentsi omaanta apaniroeni yotemini Tajorentsi rirotaki weshiryaawentemini eejatzi ñaaperotemini pikameethatzi. Rootaki riweshiryaakaantemiri iinja. ");
INSERT INTO cjoNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Eejatzi ikantzi: —Eero pikenkithashiryaapiintziro pipiyotero powaagawo jaka jaawikika: opathaagaantzikari eejatzi rapeyagaanteetzitzimirokari eejatzi ikoshiteetzimikari. ");
INSERT INTO cjoNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Omaanta pikantya pikenkithashiryaakopiintyaari Tajorentsi eejatzi pantero ikowakaakimiri rootaki iñaaperotantemiri pikameethatzi. ");
INSERT INTO cjoNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ñaakiro, aririka pikowaki pipiyotero powaagawo jaka kipatsikika rootaki pipeyakotantapiintariri Tajorentsi, omaanta aririka pikowaki piweshiryaakayaari rirori pikenkithashiryaakopiintyaari. ");
INSERT INTO cjoNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Eenitatsi poki paminantari kitejiriki. Okimitaka eenitatsi oorentamentotsi pitsiwootapiinantari tsiteniriki piñaantyaawori. Aririka okameethataki oki, kameetha paminawaetantyaari. ");
INSERT INTO cjoNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Omaanta eerorika okameethatzi poki, eero piñiiro, kimitaka tsiteniriki. Eejatzi okimitaka, aririka pikenkithashiryaapiintero kaari kameethatatsi, eero piyotziri Tajorentsi, eero piñiiri, kimitaka tsiteniriki. ");
INSERT INTO cjoNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Eekiro riyaatatyee ikantakiri: —Tekatsi pikantya pithamaeteniri apite piwaatorote. Aririka pithamaeteniri apite, pikenkithashiryaakotakiri apaani kameetha rirori, pineshironkateri, omaanta pikenkithashiryaakoteri paashini tee ikameethatzi, pitheenkiri. Eejatzi okimitakya aririka panteniri Tajorentsi ikowakaakimiri, pikenkithashiryaakopiinteri kameetha irinta, pinintaperotantyaariri, eero pikoyi pipiyotero powaagawo osheki. Omaanta aririka pikowaki pipiyotero osheki powaagawo, aritaki pantawaetawentero eeroka paantyaawori, eero pikowae paapatziyari riraga Tajorentsi. Eero pimatziro papitetziri piwaatorote. ");
INSERT INTO cjoNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Eejatzi ikantziri: —Ari nokantemi: eero pikenkithashiryaakotashitapiintawo oetarikapaeni poyaari, pimiri, pikithaatapiintyaari, oetarikapaeni. ¿Rootakima pijeekantari powapiintyaawo? Tee rootaki pijeekanta, inta rootaki pijeekantari pikenkithashireeri Tajorentsi riraga wetsikakimiri, eejatzi pipinkathateri. ¿Rootakima piwatha otzimantari powaneenkatantyaawori? Tee rootaki otzimantari. Omaanta eeniro pijeekantari piyoteri Tajorentsi piweshiryaakayaari rootaki okameethatantari panteniri ikowakaakimiri. ");
INSERT INTO cjoNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Pamineri riraga tsimeripaeni jenokiweri. Tee ipankiwaetzi, tee rowiitzi, eejatzi tee rantzi ipanko ojeekantari rowanawo. Omaanta maawaeni kitejiri eenitatsi royaari: tema ramitakotziri rirori Tajorentsi. Maawaeni kitejiri ineshironkatziri, tema eeroka osheki inintaperotakimi, rootaki ipantakimirori eejatzi. ");
INSERT INTO cjoNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Aririka pikenkithashiryaapiintero ¿arima pimatakiro pojanthaya apaniroeni? Eero. Patsipetashita pikenkithashiryaakotashita. ");
INSERT INTO cjoNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","¿Iitaka pikenkithashiryaapiinantawori piithaari, oetarika pikithaatyaari? Paminero oteyakipaeni ampee, tee okenkithashiryaapiintziro ironta: “¿Oetarikapaeni nokithaatyaawo?” Tee okirikawaetzi, eejatzi tee ontyaawaetzi, ");
INSERT INTO cjoNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","omaanta osheki owaneenkataka. Pamine, paerani osheki rowaneenkawaetani riraga jewawenantatsiri iiteetziri Sharamooni, ojeekini oshekini rowaagawo, omaanta tee ikimitaperotawo oteyakipaeni, osheki owaneenkaperotaka irowapaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Riroma rirotaki Tajorentsi owaneenkatzirori oteyakipaeni inchashi, omaanta intsipaete okamateyatzi, intsipaete opariteyatzi, eejatzi rootakoetziro. Rooma eerori, pijeekini. Riroma ineshironkaperotzimi eeroka rootaki piyotantaperotari itzimakayemiro oetarika koetyeemotzimiri kameethatatsiri. Pameentyaari, eero pitheenkiri, aritaki itzimimotakaakimiro riraga Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Rootaki eero pikenkithashiryaakotapiinantashitawo oetarika, eero pikantzi: “¿Iitaka noyaari? ¿Oetaka nomiriteri? ¿Oetaka nokithaatyaari?” ");
INSERT INTO cjoNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ikowakowaeyironiroña irokapaeni riraga kaari yotziri Tajorentsi. Eero pikimitari irirapaeni. Riroma riyotzimi riraga piri jenokinta, riyotziro koetyeemotakimiri. ");
INSERT INTO cjoNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Rootakikya pikantyaani pityaawo pipinkathatantyaaririni Tajorentsi eejatzi pikanteri rowameethashiretemi, roojatzikya ramitakotemi eenitatsi koetyeemotakimiri. ");
INSERT INTO cjoNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Rootaki eero pikenkithashiryaakopiintawo inkaamani oetarika panteri. Rooma tekatsirika tzimimotzimiri, omaanta ramitakotemi riweshiryaakayemi riraga Tajorentsi inkaamani, eejatzi maawaeni kitejiri riweshiryaakayemi. ");
INSERT INTO cjoNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Eejatzi ikantzi riraga Jesoshi: —Eero pikantakotashitari paashini atziri. Aririka pikantakotashityaari, ikantzimikari Tajorentsi: “Pantakiro eerori kaari kameethatatsi”. ");
INSERT INTO cjoNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Aririka pikijeri paashinipaeni, aritaki ikijawaemi eerori Tajorentsi. Eejatzi okimitaka, aririka pineshironkateri paashinipaeni, ari ineshironkatawaemi rirori. ");
INSERT INTO cjoNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Eenitatsirika kaari kameethatatsi pantziri, tee okameethatzi pikanteri paashini atziri eerori: “Eenitatsi kaari kameethatatsi pantziri”. Noshiyakaawentemiro iroka: aririka otyaakyaatakimi antawo inchapanki pokikira, ¿arima piñiitakiri ityaakyaawo owaanini inchapetoki rokikira paashini atziri? ");
INSERT INTO cjoNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ñaakiro, tee okameethatzi pikanteri: “Ajaakya, nagaemiro pityaakyaawo pokikira”. ");
INSERT INTO cjoNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Poshiyakaawaetashita paapatziyarimi Tajorentsi! ¡Pamatawitantashita! Pikowawitaka pikimitakotyaarimi kameethaperotzinkari. Ñaakiro, pityaawo pookero eerori antawowa inchapanki konompyaatoteencharira roojatzi pikokichaatanteeyaari ari pimatero pagaeniri ityaakiro paashinira atziri. Eejatzi okimitaka pikowakirika pikanteri pisheninka ipakayero kaari kameethatatsi rantziri, pityaawo pipakayero pantziri eerori roojatzi pimatero pikanteri. ");
INSERT INTO cjoNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Tee pipapiintziri otsitzi kameethaperotatsiri iwatha. Eejatzi tee pipapiintziri chaancho poreryaanikitatsiri mapi pinaperotachari royaawo, tee ikoyi royaawo. Tema ratsikawitawakawo eejatzi ikijakotyaawo rowitsintakiro mapi. Eejatzi okimitaka kameetharoña oetarika okantziri Iwaperite Tajorentsi. Kameetha pikenkithatakayeri paashinipaeni atziri okantziri. Omaanta aririka ikijantemiro, tee ikoyi ikemijantemi, eero poñaashirenkiri inta piyotaapiinteri koyirori. ");
INSERT INTO cjoNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Eejatzi ikantzi riraga Jesoshi: —Aririka pikanteri atziri ipawakimiro oetarika pikowakowateri, aritaki piñaakiro. Aririka pareetya pankotsiki, pikantapaakiri jeekatsiri: “Pashitareenawo”, roojatzi rashitaryaantakimiro. Ari okimitaka iroka, pikanteririka Tajorentsi pikoyiri, aritaki imatakimiro oetarika kameethatatsiri pikowakowatziri. ");
INSERT INTO cjoNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Aritaki ramitakotakiri maawaeni amaniriri. Eejatzi kowakowatakotziriri rirori koetyeemotariri, aritaki imatakiro. Aririka pikenkithatakaapiinteri, ari ikemijantemi, imatemiro oetarika kameethatatsiri pikanteriri. ");
INSERT INTO cjoNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Pamine, aririka ikantemi pitomi: “Pawa, pipena kaniri noyaari”, ¿arima pipashitawakyaari mapi? ");
INSERT INTO cjoNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Eejatzi ikantemirika: “Pipawakina shima noyaari”, ¿arima pipashitawakyaari maanki? ");
INSERT INTO cjoNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ñaakiro, tee pikameethaperotzi omaanta piyotzi pineshironkapiinteri peentsitepaeni. Owanaaperotaka riraga Piri jeekatsiri jenokinta osheki ikameethaperotaki. Tema riyoperotziro ineshironkaperotziri maawaeni kenkithatakaakiriri. ");
INSERT INTO cjoNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Eejatzi ikantaki riraga Jesoshi: —Pikowakirika raakameethateeyimini paashini atziri eejatzi pikimitzityaari eerori kameetha paakameethateri raakameethatantemirikya eerori. Tema rootaki okantakirini rojankinarini Moeseeshi eejatzi rojankinatakiro kamanantayitzirorini iñaani Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Eejatzi ikenkithatakotakiro riraga Jesoshi tsikarika akantya akyaantyaari janta jenokinta roshiyakaawentakiro awotsi, ikantzi: —Pikowakirika pikye ijeekinta Tajorentsi, pikinantapaakyaawo okaamanchakitziini awotsi, pikyaantapaakyaawo okaatzini omoo. Eenitatsi paashini awotsi jaawokipetatziiri. Tee opomeentsita ikinanteetyaawo roori; eenitatsi oshekini kinantawori, eejatzi janta ikyaanteetyaawo antawo omoo. Omaanta maawaeni kinayitaneentsini janta eero rareeta jenokinta inta ikemaatsitapiintyaawo paamari kaari tsiwakanitatsini. Osheki kyaantawori. ");
INSERT INTO cjoNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Omaanta rowaga paashini awotsi okaamanchakitziini osheki opomeentsitaka ikinanteetyaawo. Eenitatsi apaanipaeni kinantawori, omaanta kameetha rareetyaawo rirori okaatzini omoo ikyaantapaakyaari Tajorentsikinta, eero rapiiteero ikamae. ");
INSERT INTO cjoNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Eejatzi ikantzi riraga Jesoshi: —Kyaaryoowa, ramatawitzimikari oshiyaawitariripaeni iyotaantzirori Iwaperite Tajorentsi. Kyaaryoowa, piitakaashitarikari maawaeni iyotaantatsiri riyotaatziimi Iwaperite Tajorentsi kameetha. Kyaaryo riyotaawitzimi apaanipaeni, tee riyotaaperotzimiro kyaaryooperotatsiri. ");
INSERT INTO cjoNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Paminaperoteri rantayitzirini, riraga iyotaantzirori, rootaki piyotantyaariri ikameethatzirika. Pamine, ¿okithokitziroma oowa kitochee? Teewee. ¿Okithokitziroma iyeera kawana? Teewee. Tee omatziro. Eejatzi ikimita riraga amatawitantatsiri, tekatsi ikantya rantero ikowaperotziri Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Inchato kameethari okithokitziro okithoki kameethari, ari athotero. Omaanta teerika okameethatzi inchato, tee okithokitziro okithoki kameethari. ");
INSERT INTO cjoNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Rowaga inchato kameethari, tekatsi okantya okithokitero okithoki kaari kameethatatsi. Eejatzi kaari kameethatatsi inchato, tekatsi okantya okithokitero kameethatatsiri okithoki. ");
INSERT INTO cjoNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Tema achekapiintziro chochoki kaari kithokitatsini, oejapiintziro paamariki. ");
INSERT INTO cjoNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Eejatzi okimitaka, potsikanataperotyaari maawaeni kowatsiri riyoteemi. Piyote okameethatzirika rantziri, ari kameetha eejatzi riyotaantziro Iwaperite Tajorentsi. Rooma teerika okameethatzi rantziri, eejatzi tee okameethatzi riyotaantziri. ");
INSERT INTO cjoNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Eejatzi ikantzi riraga Jesoshi: —Eeniro ñaawaetashitachari osheki ikantashita: “Eeroka Nowinkatharite, osheki nopinkathatzimi”. Omaanta eero riyaateeyini irira janta notsipatyaari jenokinta, inta jataperotatsini janta maawaeni riraga antaperotziniriri Pawa ikowakaakiriri. ");
INSERT INTO cjoNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Aririka nopinkatharentsiperotanaki nopiyoteeyerini maawaeni atziri nokantakowenantyaariri. Eenitatsi oshekini atziri kantashitenani: “Nowinkatharite, osheki nokenkithatakotzimi. Nokantziri kyaantariri kamaari: ‘Pameentyaari Jesoshi pawijakotanteeyaari’. Eejatzi nokantziri atziripaeni: ‘Rirotaki Jesoshi matakaanawori notajonkantzi’ ”. ");
INSERT INTO cjoNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Omaanta nokanteri irirapaeni: “Tee niyotzimi, tee reentsitetzimi Pawa. Piyaate inteenanta, osheki pantziro kaari kameethatatsi. Tee nokoyi pijeekimotena jaka”. ");
INSERT INTO cjoNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Pamine, aririka paapatziyawo maawaeni okaatzi nokantzimiri eejatzi aririka pantakinawo maawaeni nokowakaakimiri, okameethataki, eeroka yotaniri, pikimitakotakari atziri wetsikirori ipanko okijopathatzira kipatsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Roojatzi opariyantapaaka inkani, oonkanaka. Opokawitapaaka antawo tampyaa otatsinkawitapaakawo, omaanta tee ataanakiro. Rootaki kaari ataantawo, tema riwetsikakitziiro okijopathaperotzira kipatsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Eejatzi okimitya eerori, eerorika pikenkithashireero maawaeni okaatzika nokantakimiri eejatzi eerorika pantanawo maawaeni nokowakaawitzimiri, tee okameethatzi. Eeroka kimitariri kaari yotatsi. Pikimitakotyaari wetsikirori ipanko janta impanekiiteki ochereeteki iñaa. ");
INSERT INTO cjoNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Okanta opariyapaaki inkani, oonkanaka. Opokapaaki antawo tampyaa otatsinkanakiro pankotsi, aanakiro iñaa. Ñaakiro, ratsipetashitakawo riraga wetsikawitawori. Eero patsipetashitawo eerori pikemijantana, omaanta pantaperotero kameetha nokowakaakimiri. ");
INSERT INTO cjoNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Rootaki ikanteeyakiririni piyotawenteeyakaririni janta tonkaariki. Ari rotsikanateeyanakarini maawaeni, ikantzi: ");
INSERT INTO cjoNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","—Osheki riyotanitzi irira, ikenkithatakaakae kimitaaka pinkathari, kameetha riyotaakae; tee ikimitari riraga iyotaantawitawori rojankinarini Moeseeshi. ");
INSERT INTO cjoNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ithonkapaakiro riraga Jesoshi riyotagaeyakirini atziri janta tonkaariki. Roojatzi roerinkantapaa, eejatzi royaateeyakirini oshekini atziri. ");
INSERT INTO cjoNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Roojatzi ipokashitapaakiri apaani shirampari patheenkari, itonkiyotawakari rotziwerowashitapaakari, ikantapaakiri: —Nowinkatharite, tema eenitatsi pitajorenka, pikowakirika petsiyatakotena, niyotzi aritaki pimatakiro. ");
INSERT INTO cjoNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Roojatzi rowaankantawakawo rako rirori, ipampitawakiri ikantziri: —Jee, nokowaki. Petsiyatakotanee iroñaaka. Intsipaete opeyanaka ipathaawo. ");
INSERT INTO cjoNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Roojatzi ikantziri: —Eerowa pikamantziri paashinipaeni netsiyatakotakaakimi, inta pantero ikantzitarini paerani Moeseeshini: piyaatashiteri riraga ñaanakowenantatsiri Tajorentsipankokinta pikanteri irira: “Paerani nopathaawitani, omaanta iroñaaka, etsiyatakotaana. Paminena tee añagaero iroñaaka, nopathaawo”. Aririka raminawakimi, roojatzi pipantapaakyaari pitsimerite jenokiweri itaantyaanariri Tajorentsi, riyoteeyantyaarini atziripaeni etsiyakotatakimi. Roojatzi riyaatantanaka. ");
INSERT INTO cjoNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ikantaka itharyaanaka Jesoshi, eejatzi riraga oyaateeyakiririni, roojatzi rareetanteeyapaakani Kaperinawooki. Itonkiyotawakari apaani iwinkatharite oshekini joraaro. Kaari riro joriiyo. ");
INSERT INTO cjoNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Ikantapaakiri: —Nowinkatharite, eenitatsi nonampiri janta nopankokinta, tee imatziro ishewata, eejatzi osheki ikatsitaki; katsitaperotanaki. Nokowaki petsiyatakotakayeri. ");
INSERT INTO cjoNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Roojatzi ikantawakiri: —Aritaki niyaate netsiyatakotakayemiri. ");
INSERT INTO cjoNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Omaanta ikantanakiri: —Osheki nopinkathatzimi. Tee nokameethatzi naari; tee naaka joriiyo, eero notsipatapaakimi janta nopankoki. Apatzirorika pikante etsiyatakotanee rirori, niyotaki aritaki etsiyatakotanaki. Patsipetawokari piyaate nopankoki, osheki pipinkathariwenantzi. ");
INSERT INTO cjoNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Eejatzi naari eenitatsi kantanari oetarika nanteri, eejatzi nokimitzita naari nojoraarote eenitatsi nomperateeyakarini. Nokanteririka apaani joraaro: “Piyaate”, ari riyaatanaki. Nokanteririka paashini: “Pipoke”, ari ipokanaki. Eejatzi nokimitziri nonampiri rirori, aririka nokanteri: “Iroka panteri”, ari rantakiro. ");
INSERT INTO cjoNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ikanta ikemantawakariri, ari rotsikanatanakari, roojatzi ipithokashitantanakari oyaateeyakiririni, ikantanakiri: —Kyaaryootaki iroka nokantemiri, maawaeni jaka anampipathakika tekatsi apaani noñaaneente kimitakotyaarini irika paashinijatzitatsiri atziri: osheki rameentaperotakari Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Iinja janta ipinkatharitzinta, aritaki ipiyoteeyaani oshekini paashinijatzitatsiri atziri ipoñaayitapaakyaani paashinipaenikinta kipatsi. Itsipatapaeyaari Awaraama, Ijaaka, Jakoowo, riweshiryaawaetya maawaeni janta. ");
INSERT INTO cjoNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Omaanta oshekini joriiyo jeekatsinimi janta, aritaki ikenkithashirya irirapaeni: “Naaka joriiyo, rootaki niyaatantyaari jenokinta”, omaanta eero riyaatzi, tee raapatziyaperotari Tajorentsi. Ikowakaawitakari itsipatyaarimi janta ipankokinta, omaanta osheki itheenkakiri, rootaki rotyaanantyaariri janta otsitenikaakiperotzikinta. Tema ijeeki janta paamariki kaari tsiwakanitatsini. Janta riraaperotanakya eejatzi ratsikaekiteeyanakyaani, tyakiririri. Osheki rowashironkaanakya janta, osheki ikemaatsityaawo paamari owatsinka. ");
INSERT INTO cjoNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Roojatzi ikantawakiri riraga iwinkatharite joraaro: —Kameetha iroñaaka piyaate pipankoki. Paapatziyaperotakina, rootaki retsiyatakotantaneeyari ponampiri. Intsipaete retsiyatakotanee. ");
INSERT INTO cjoNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Riyaatanaki iroñaaka riraga Jesoshi ipankoki Peetero. Ikyaantapaakari iñaapaakitziiro riyote omantsiyataki, omaryaaka omaamentokira, ojaawamerikitzi. ");
INSERT INTO cjoNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ipampitapaakiro akokira, roojatzi awijakotantanaa ojaawamerikiwitaga etsiyatakoperotanee. Roojatzi opiriinantanaka mantsiyawitachari opantawakari rowanawo. ");
INSERT INTO cjoNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Okantaka otsitenitanaki, ramaetapaakiri oshekini kyaantakariri kamaari. Roojatzi ikenkithatakaantawakari roojatzi rowawijaakotantawakariri. Eejatzi retsiyatakotawakiri oshekini mantsiyatzinkari. ");
INSERT INTO cjoNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Tema imonkaatakiro riraga Jesoshi maawaeni ikenkithatakotzitakaririni paerani Iseeyashini. Ikantakotzitakaririni: “Iinja retsiyatakoteri Rotyaantanewo Tajorentsi oshekini mantsiyatzinkari, eejatzi osheki ineshironkateeyirini”. ");
INSERT INTO cjoNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Paashiniki kitejiri iñaantakariri riraga Jesoshi oshekiniroña piyotawenteeyakaririni, ari ikantanakiri riyotaanewopaeni: —Thame aate intatsikeronta inkaare. ");
INSERT INTO cjoNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ikanta ipokashitapaakiri iyotaantzirori Iwaperite Tajorentsi, ikantapaakiri: —Iyotaanari, nokowaki naari noyaatemi tsikarika piyaate. ");
INSERT INTO cjoNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Rakanakiri Jesoshi, ikantanakiri: —Riraga piratsi eenitatsi imoo imaantari. Eejatzi ikimita riraga tsimeri jenokiweri, eenitatsi rookantari, imaantari. Kyaaryo naaka poñaachari jenokinta, nokoñaatapaaki jaka kipatsikika, omaanta tekatsi naaka nopanko nomaantyaari. Patsipetashitawokari poyaatena, powashironkaakari. ");
INSERT INTO cjoNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ikantapaaki paashini riyotaanewo: —Nowinkatharite, nokowawitaka noyaatemimi omaanta tekiraata ikami pawa. Ikamakirika nokitatanakiri roojatzikya noyaatantanakimi kijokiro nowanakimi. ");
INSERT INTO cjoNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Omaanta ikantawakiri: —Poyaatanakina. Paata ikitateri ikaateeyinira kaari yotziri Tajorentsi, eejatzi ikaateeyinira theenkantatsiri. ");
INSERT INTO cjoNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Roojatzi rotetantanaka riraga Jesoshi pitotsiki, itsipatanakari riyotaanewopaeni. Ikowaki imontyeero inkaare. ");
INSERT INTO cjoNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Roojatzi imaanaki rirori pitotsiki. Niyankyaani omapokashitapaakari riyotaanewopaeni antawo tampyaa, omaetonkaapaaki otetaagapaaka. ");
INSERT INTO cjoNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Roojatzi riyaatashitantanakari riyotaanewo, ikaakapaakiri, ikantapaakiri: —¡Nowinkatharite! ¡Aritaki pimaaki! ¡Rooteentsi apiinkiwee! ¡Powawijaakotena, eejatzi eerori, powawijaakotya! ");
INSERT INTO cjoNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Roojatzi ipiriintanaka, ikantawakiri: —¿Iitaka pithaawantari? ¿Iitaka kaari pameentaperotantana? Roojatzi ichereemotantakawo tampyaa eejatzi otamakaari. Ikantakiro: —¡Pimaerite! Roojatzi okaatantanaka tampyaa, eejatzi omaeritzitanaa iñaa: tee añaawaero otamakaari. ");
INSERT INTO cjoNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ari rotsikanateeyanakarini riroripaeni, roojatzi ikantawakaaka: —¿Tsikama iitatyaarika atziritatsiri irika? Pamineritya okemijanantakariri tampyaa eejatzi omaetonkaa: romaeryaantakawori. ");
INSERT INTO cjoNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ikantaka Jesoshi rareetapaaka intatsikeronta, raatakotapaaka janta. Tema owaero rowaga kipatsi Karaara. Ikanta apite atziri kyaantariri kamaaripaeni, ipoñaaka kaminkarimashiki, itonkiyotawakari riraga Jesoshi. Riraga kyaantariri kamaari osheki ikijakaakari iyamaaritepaeni, rootaki ithaawanantakariri atziripaeni. Tee ikinantanaawo awotsi ikinapiintawitaga. ");
INSERT INTO cjoNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Roojatzi icheraacheraatakaantakari kamaaripaeni, ikantziri: —¿Iitaka poñaashirenkantanari, Jesoshi? Niyotakimi, eeroka Itomi Tajorentsipero. ¿Rootakima pipokashitantanari powashironkaena? Tekiraataga omonkaata kitejiri powashironkaantenari. ");
INSERT INTO cjoNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ari ipiyotziteeyakani chaanchopaeni janta, osheki rowawaeteeyani. ");
INSERT INTO cjoNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ikantaka kamaari ikantakiri riraga Jesoshi: —Aririka pookakagaenari irika nokyaantawitarika, pishinetena niyaatashiteri chaancho nokyaantapaeyaari irirapaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Roojatzi ikantawakiri: —Piyaate, pikyaantapaakyaari irinta. Roojatzi riyaatantanaka ishirinkashitanakari chaancho, roojatzi ishiyanaka maawaeni impeetaki, ipiinkapaaki inkaareki, motoririri, motoririri. Itsitsiyeeyapaakini iñaakira, motoririri. ");
INSERT INTO cjoNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ikantaka shentawitariri chaancho ishiyanaka, tema ithaawanakitzi rootaki riyaatantanakari ojeekinta nampitsi ikamantapaakiri maawaeni atziri oetaka awijimotakiriri eejatzi ikamantakotapaakiri kyaantawitariri kamaari awijakotee. ");
INSERT INTO cjoNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Roojatzi ikijaka maawaeni jeekatsiri janta, eejatzi ithaawantari rootaki ipokashitantapaakari ikantapaakiri riraga Jesoshi: —¡Thame piyaate! ¡Tee nokoyi pipokimotena jaka nonampikika! ");
INSERT INTO cjoNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Roojatzi rotetantanaa riraga Jesoshi pitotsiki, ikaateeyaneerini riyotaanewopaeni. Ipiyanaka inampiperokinta intatsikeronta inkaare. ");
INSERT INTO cjoNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Roojatzi ramaetapaakiniri rirori apaani kijopookitatsiri, ramakotakiri imaamentoki. Riyotaki riraga Jesoshi osheki raapatziyari riraga amiriri, rootaki ikanantawakariri riraga kijopookitatsiri: —Piweshiryaanakya, niyompari, tema ari nopeyakotakaemiro kaari kameethatatsi pantawitari, aritaki nowawijaakoteemi. ");
INSERT INTO cjoNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ikanta apaanipaeni iyotaantzirori Iwaperite Tajorentsi ikemawakiri. Roojatzi ikantawakagaeyantanakarini: —Irika shiramparika iitajorentsitashityaami. Itheenkakiri Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Riyotakiri irirapaeni Jesoshi oeta ikenkithashiryaari rajankaneki, rootaki ikanantanakari: —¿Iitaka pitheenkantanari? ¿Iitaka pikijashiryaantanari? ");
INSERT INTO cjoNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Aririka nokanteri irika: “Iroñaaka netsiyatakoteemi, pipiriintee, panashiteeya”, tema ari potsikanatanakyaari. Eerorika imatziro ipiriinta, ari pishirontawentanakina naaka. Omaanta kameetha pikantanaki tekatsi shirampari materoni rowawijaakoteri atziri kaari kameethatatsi rantziri. Kameetha pikantzi. Tema piitashiwitaka nokantashitari: “Nowawijaakotemi, eero nokijawentzimiro kaari kameethatatsi pantziri”. ");
INSERT INTO cjoNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Nokowaki piyote tee nokantawaetashita. Naaka poñaachari jenokinta, nokoñaatapaaki jaka kipatsikika. Ikantakina paeraniperoroña Pawa janta: “Powawijaakotenari antzirori kaari kameethatatsi eero akijantari paata”. Nokowaki iroñaaka piyote eenitatsi notajorenka, rootaki nomatantariri nokamintheeri antzirori kaari kameethatatsi, nowawijaakoeyerini. Rootaki ikanantakariri kijopookitatsiri: —Pikatziyanaki, paaneero pimaamento, piyaatee pipankoki. ");
INSERT INTO cjoNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Roojatzi ipiriintantanaka riraga kijopookiri katziyanaa, jatanee ipankoki. ");
INSERT INTO cjoNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Iñaantawakariri maawaeni piyoteenchari oetarika awijaneentsiri, rotsikanatawakari, thaawanaki, ikanteeyanakini: —Tema ikameethatzi Tajorentsi, imatakaakiri irika retsiyatakotakaakiri mantsiyatzinkari. ");
INSERT INTO cjoNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Roojatzi rowaaganaka riraga Jesoshi roojatzi nojeekakinta naari. Naaka Mateeyo. Iñaapaakina jaka pankotsikika nopiyotayitzinirininta iyorikitepaeni atziri eekiro noperi pinkatharitatsiri Oroomaki. Ikantapaakina: —Thame poyaatanakina. Roojatzi nokatziyantanaka noyaatanakiri. ");
INSERT INTO cjoNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Roojatzi naanakiri janta nopankoki nokantziri: “Thame nakiyotemi”. Eejatzi naanakiri riyotaanewopaeni. Eejatzi nakiyotawakiri. Eejatzi nokaemakiri riraga notsipatayitarini nopiyoteeyinirini oroomajatzi iyorikite, eejatzi nokaemakiri paashinipaeni antzirori kaari kameethatatsi. Ari nokaateeyakirini maawaeni; nowaeyakani. ");
INSERT INTO cjoNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ikantaka iñaakinaga ipokashiteeyakinani warijeeyopaeni, ikaemapaakiri apaani riyotaanewo Jesoshi, ikantziri: —¿Iitaka rantziri riraga iyoteemiri? Rakiyoteeyakirini piyotziriri iyorikite oroomajatzi, eejatzi ikaateeyakirini paashini kaari kameethatzinkari. Tee okameethatzi iroka. ");
INSERT INTO cjoNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Omaanta ikemakiri riraga Jesoshi, rootaki ikanantanakariri: —Riraga kaari mantsiyatatsini tee ikoyi aawinantatsiri raawinteri intakya mantsiyatatsiri rirotaki kowatsiri. Okimitaka iroka, riraga kenkithashiryaawitachari ikameethatzi, tee ikoyi ipokashitena nowawijaakotantyaariri inta apatziro riraga iyotakotachari eeniro rantani rirotaki pokashitanari nowawijaakotanteeyaariri. ");
INSERT INTO cjoNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Thame piyaate piyotakoeyawakironi iroka okantakotziri Iwaperite Tajorentsi, okantzi: “Tee apatziro nokoyi powamaashitapiintenari powishate inta eejatzi nokowakaaperotakimiri paapatziyaperotena. Eejatzi nokowakaaperotakimi kameetha pineshironkaperoteri maawaeni”. Tee apatziro nopokashitziri nowawijaakoteri riraga kameethatzinkari omaantakya nopokashitaperotzi riraga kaari kameethatatsi, riyotanteeyariri Tajorentsi. Rootaki ikantziriri riraga Jesoshi warijeeyopaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Roojatzi ipokaeyapaakini riyotaanewo Jowa kaawoshitakotziriri Tajorentsi ikantapaakiri riraga Jesoshi: —Pamine, notzitawentapiintari Tajorentsi, eejatzi ikimitaka riraga warijeeyopaeni; omaantakya pashi piyotaanewopaeni tee itzitawentapiinteeyarini rirori, inta rowapiinteeyani maawaeni kitejiri. ¿Iitakakya? ");
INSERT INTO cjoNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ikantawakiri: —Piyotaki rametakawo riraga aatsiri iina ikaemiri inampijatzipaeni rowakaakari riweshiryaawentakawo roori. Eero retakotanakawo kaemakaantziriripaeni. Omaanta aririka raapithateetaneeri inteenanta, roojatzikya retakotanakyaari, eero rowa. Eejatzi nokimitya naari paata, aririka niyaate. Niyaaterika roojatzi retakoeyantanakyaani rirori niyotaanewopaeni, eejatzi itzitawenteeyanakyaarini Tajorentsi tema retakoeyanakityaanani. Rooma eeniroka nojeeki jaka, eero itzitawentari Pawa, tema riweshiryaawentana. ");
INSERT INTO cjoNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Tee pimaejantziri iyotaantatsiri, tee. Eejatzi eenitatsirika pimaathapooki antyashipawo rooteentsi oshipaaye, aririka powawatatero owakirari maathaantsi, roojatzi aririka pikiwero aminthatanaka owakirari, eero omonkaatanawo, roojatzi otzijagaantanakya antyashipawotatsiri, patsipetashitakawo powawatatziro. Eejatzi okimitakya, patsipetashityaawo paapatziyawo maawaeni okaatzi iyoteetakimiri. Okameethatzi pipakayero paashini paapatziyawitarira roojatzi kameethatanaki paapatziyana naari. ");
INSERT INTO cjoNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Rapiitakiro Jesoshi roshiyakaawenteniri okaatzi riyotaakiriri, ikantzi: —Piyotzi aakapaeni joriiyopaeni shirikiriri imashi piratsi apiyaatantyaawori awishoowaantsi oowa. Omaanta eero apiitantari apiyaatantari awishoowaantsi oowa owakirari inthomaenta itaworimashi inta apiyaatantya owakira mashiri. Apiitantyaaririka tema ari ijagaanaki. Okimitaka iroka, oetarika niyotagaemiri naari eejatzi owakirari. Tee okameethatzi pipiyotero ikemijantakayimiri paashini iyotaantsi. Pipakayero pikemijantziro ikantawitzimiri irintapaeni roojatzi kameethatanaki paapatziyena naari. Rootaki ikantakiriri riraga Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Roojatzi ipokashitantapaakari jewawentzirori ipiyotapiinteeyaninta joriiyopaeni, rotziwerowashitapaakari ipinkathatantapaakari riraga Jesoshi, ikantapaakiri: —Kamaki nishintyo, nokowaki piyaatakite nopankoki pipampitakitenawo roojatzi añaantaneeyaari eejatzi. ");
INSERT INTO cjoNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Roojatzi ikatziyantanaka Jesoshi royaatanakiri janta, nokaateeyanakirini naaka maawaeni riyotaanewo. ");
INSERT INTO cjoNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Ari janta niyanki awotsi oyaatapaakiri Jesoshi apaani tsinani, okaataki 12 ojarentsite owashironkaaka, omantsiyataki, ari okantatyaani ojokaatziro iraa. Okanta okenkithashiryaaka, okantzi: “Aririka nopampitzitakiri iithaari Jesoshi aritaki netsiyatakotanee”. Roojatzi okinashitantapaakari itapiiki, opampitzitapaakiri opatziyaakiki iithaari. ");
INSERT INTO cjoNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Roojatzi ipithokanaka iñaawakiro, roojatzi ikantawakiro: —Piweshiryaanakya, choeni, pameentakina, rootaki petsiyatakotantaari. Aripaete etsiyatakotanee. ");
INSERT INTO cjoNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Roojatzi nowaaganaka areeteeyapaakinani ipankoki jewatatsiri. Noñaapaakiri jonkatakoeyawitaworini kamaentsiri eejatzi oshekini atziri iraakoeyawitaworini icheragaeyakini riraaka. ");
INSERT INTO cjoNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Roojatzi ikanantapaakari riraga Jesoshi: —Thame piyaatanee. Tee okami irowa piraakowitakarira, omaashita. Roojatzi ishirontawentakari injii, injii, injii. ");
INSERT INTO cjoNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Roojatzi riyowantanaka nekokironta roojatzi ikyaantapaaka riraga Jesoshi. Roerikawakotapaakiro roojatzi opiriintantanaka añaanee. ");
INSERT INTO cjoNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Othotyaanaka ikemakoetawakiri Jesoshi janta maawaeni nampitsikipaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Roojatzi nowaagaeyanakani, tema royaatakiri Jesoshi apite kaari kokichaatatsini ichereemotakiri, ikantakiri: —Tema eeroka icharineeteni Iraviirini. Rotyaantakimi Tajorentsi rootaki nokowantari pineshironkatena. ");
INSERT INTO cjoNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Roojatzi nokyaanteeyapaakani eejatzi riraga kaari kokichaatatsini ipokashitapaakiri rirori roojatzi ikanantawakari: —¿Pikenkithashiryaakama aritaki nomatakiro nokokichaatakagaemi? Ikantawakiri: —Jee, Nowinkatharite, niyotzi aritaki pimatakina pikokichaatakagaena. ");
INSERT INTO cjoNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Roojatzi ipampitantakari rokiki, ikantanakiri: —Paapatziyakina rootaki netsiyatakotanteemiri. ");
INSERT INTO cjoNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Roojatzi raminantanaa. Ikantakiri rirori: —Eerowa pikamantziri paashinipaeni: “Ikokichaatakagaana Jesoshi”. ");
INSERT INTO cjoNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Omaanta riyaatantanakari ikantakiri maawaeni iñaapaakiri: —Ikokichaatakagaana Awinkatharite. ");
INSERT INTO cjoNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Nokantaka riyaateeyakaawitanakinanira riraga Jesoshi, roojatzi noonthaantawakari atziri ramakiri kyaantariri kamaari. Tee imateeya iñaawaete. ");
INSERT INTO cjoNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Roojatzi rookantawakanari Jesoshi riraga majontzitakaawitakariri, roojatzi iñaawaetantanaa. Ari rotsikanateeyawakariniroña maawaeni ñaawakiriri, ikantawakaaka: —Pamine, paerani tee añaapiintziro kimitaworika iroka jaka aepatsitekika. ");
INSERT INTO cjoNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Omaanta ikanteeyakini riraga warijeeyopaeni: —Irika shiramparitatsirika ramitakotakitziiri iwinkatharite kamaaripaeni. Rootaki imatantariri rookakiniri ikaateeyinira ikamaaritzi rotyaantziri. ");
INSERT INTO cjoNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Osheki ikinakinayitanakini riraga Jesoshi ithotyaakiro maawaeni nampitsipaeni, riyotaantaki janta pankotsi ipiyotantapiintarira joriiyopaeni. Ikenkithatakotapiintziri Tajorentsi, tsika ikanta ipinkathariwenantzi. Eejatzi retsiyatakotakaakiri maawaeni mantsiyaripaeni, tekatsi pomeentsitzimotyaarini. ");
INSERT INTO cjoNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ikanta iñaawakirira oshekini atziri ipiyotawentakari, osheki retakoeyakarini. Ikantzi: —Osheki rowashironkagaeyakani irirapaeni, tekatsi iyotaantatsiri riyotaaperoteri oetarika okantaperotziri Iwaperite Tajorentsi. Ikimiwitari owisha riraga kaari ishenteetzi, rootaki rowashironkagaeyantakarini. ");
INSERT INTO cjoNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Roojatzi ikanteeyanani: —Okimitakawo iroka oshekitziranki okithoki pankiwaerontsi. Omaanta tekatsipero antawaetatsini owiiteroni okithoki. Eejatzi okimitaka roori eenitatsi iroñaaka osheki atziri kowawitachari raapatziyaperotyaarimi riraga Tajorentsi omaanta tekatsi osheki aapatziyakagaeyaaririni. ");
INSERT INTO cjoNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Pamaneri Awinkatharite Pawa Tajorentsi rotyaanantyaariri oshekini kenkithatakayeririni anampijatzi, raapatziyanteeyaririni. ");
INSERT INTO cjoNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Roojatzi ikaemaeyanakinani Jesoshi maawaeni nokaateeyinira 12 riyotaanewo. Imatakagaeyakinawoni nowawijaakoteri kyaantawitariri kamaari nookiniri iyamaarite. Eejatzi netsiyatakotantayityaaririni omatayitzirini paashinijatopaeni mantsiyarentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Iroka nowaeropaenika naakapaeni rotyaantanewo: Shimo, (riraga iiteetziri eejatzi Peetero), eejatzi rirentzi Antereeshi; Jantyaako, (riraga itomi Sewereeyo), eejatzi rirentzi Jowa; ");
INSERT INTO cjoNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Jiripi eejatzi Waritoromee; Tomashi eejatzi naaka, nowaero Mateeyo (riraga piyotawitanariri paerani iyorikite oroomajatzi); Jantyaako (riraga itomi Arijeeyo); Tareeyo; ");
INSERT INTO cjoNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Shimo, (riraga kathaaperotzinkari antayitzirorini oetarikapaeni); eejatzi riraga Joorashi (riraga karyootejatzi, rirotaki aakaanteririni iinja Jesoshi). ");
INSERT INTO cjoNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Rotyaanteeyantenarini riraga Jesoshi, omaanta rityaawo eenitatsi iroka ikantawakinari: —Eerowa piyaatashitziri riraga kaari joriiyotatsi, eejatzi riraga jamaaryajatzi. ");
INSERT INTO cjoNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Intakya piyaatashiteri maawaeni ajoriiyotzinkarite. Nokimitakaantakiri owisha, riraga kaari ishenteetzi. ");
INSERT INTO cjoNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Tsikarika pikineeyanakini pikenkithatakayeri atziripaeni. Pikanteri: “Rooteentsi ipinkathariwentee Tajorentsi”. ");
INSERT INTO cjoNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Petsiyatakotakayeri mantsiyatzinkari, pañaakagaeri kamatsiri, petsiyatakotakayeri patheenkari, eejatzi powawijaakoteri kyaantawitariri kamaari. Osheki ineshironkatakimi Tajorentsi ramitakotashitakimi eerori, omaanta tee ikowantzimotzimiro. Eejatzi pikimitzitya eerori, pineshironkateri paashinipaeni pamitakoteri. Eero pikowantzimotari. ");
INSERT INTO cjoNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Eero paanaki piyorikite, ");
INSERT INTO cjoNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","piwoorijate, paashini pimaatha, paashini pijapatote, paashini pikotzi, oetarika paashinipaeni: piyaatashitanakya. Ninkarika pineshironkatakiri okameethatzi ineshironkatemi eerori ipashitemi koetyeemoyitakimirini. ");
INSERT INTO cjoNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Aririka pareetapaakya nampitsiki pikowakowatapaakiri apaani atziri kameethatatsiri rajankaneki. Aririka raakameethatawakimi, ari pijeekapaaki janta, roojatzi paata powaagantaneeya paashiniki nampitsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Aririka pareetapaakya, piwethatapaakyaari ashitawori inampi. ");
INSERT INTO cjoNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Aririka raakameethatawakimi irinta, pikanteri Tajorentsi: “Pawa, pineshironkaperoteri”. Omaanta teerika raakameethatawakimi, eero pikantziri rirori ijeekakaeri kameetha. ");
INSERT INTO cjoNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Eerorika raakameethatawakimi jeekatsiripaeni janta nampitsiki, eejatzi eerorika raapatziyeeyawakimini, ari powaaganakya. Eejatzi potekakontatanakya piitzikira riyotantyaari eero pipiyashitari eejatzi. Pikanteeyanakirini: “Iroñaaka tee paapatziyana, ari rowashironkaemi Tajorentsi iinja”. ");
INSERT INTO cjoNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Kyaaryootaki iroka nokantemiri: aririka othonkaeya iinja kipatsi, ikantakowenanteeyaaririni Tajorentsi maawaeni atziri, roojatzi rowashironkaantakyaari maawaeni joroomajatzini eejatzi maawaeni komoorajatzini, rooma oshekini ranteeyakironira kaari kameethatatsi. Omaanta riraga kaari aapatziyeeyawakimini rirotaki iinja kemaatsitaperotyaawoni osheki katsiri. Tema rowashironkaaperotantakyaariri riraga Tajorentsi riroripaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Pamine, notyaantatziimira iroñaaka pikenkithatakotena janta maawaeni anampijatzikinta, omaanta nokimitakaantawitakimi eeroka owisha pojatekantyaari koweenkatatsiri. Kyaaryoowa, rowashironkaemikari theenkantatsiri. Rootaki nokowantakimiri pikenkithashiryaaperotya kameetha eejatzi piyothaniperote kameetha. Pikimitakotyaari maanki. Osheki ikenkithashiryaaperota aririka raminaminate royaari; omaanta eejatzi kameetha paakameethatante pikimitakotyaari jamomo. Tee riyotzi ikijanita paashinipaeni, kameetha ijeeki. Ari pikimitakotyaari eerori: pijeeki kameetha eero powashironkaeri paashinipaeni. Rootaki ikantawakinari riraga Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ikanteeyakinani riraga Jesoshi: —Kyaaryoowa, rowashironkayitziminikari atziri. Aritaki raaneemi janta riyotaawakaakanta jewatatsiripaeni rowashironkaantemiri. Eejatzi raaneemi janta pankotsiki ipiyotantapiintarira joriiyo ipajapajaapiintemi. ");
INSERT INTO cjoNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Riyotakimirika paapatziyakina, raaneemi atziripaeni janta ijeekinta jewaperowenantatsiripaeninta paashinijatzitatsiri atziri, roojatzi eeroka pikenkithatakagaeyerini riyoteeyantanakyaarini atziripaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Aririka raakaantakimi eero pikantashiryaashita: “¿Oetaka nokantapaakiriri?” Tema naaka yotakaakimiri oetarika pikantapaakiriri. ");
INSERT INTO cjoNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Eero piyotashita eerori pikenkithatakayeri, omaanta Ishire Tajorentsi iyotaaperotemini pikenkithatakayeri. ");
INSERT INTO cjoNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Iinja osheki ari ikijaperowentakinani atziripaeni. Apaani aririka raakaanteri rirentzi, ari rowamagaetakiri; paashini raakaanteri itomi, eejatzi paashinipaeni raakaantayiterini ashitariri. ");
INSERT INTO cjoNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Paapatziyakina, rootaki ikijantemiri atziripaeni, omaanta eero pipakaero paapatziyana. Roojatzirika pikantyaani kijokiro poyena paapatziyena, aritaki nowawijaakotakimi kameetha pijeekimotantenari janta jenokinta. ");
INSERT INTO cjoNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Aririka ikijimi jeekatsiripaeni nampitsiki, ari pishiyanaki, pitharyaanaki paashiniki nampitsiki. Kyaaryo, tekira pithotziiro maawaeni nampitsi jaka Ishirayeeriki, tekira piyotagaeri maawaeni, roojatzi nopiyantapaeya naari. Tema naaka poñaachari jenokinta, nokoñaatapaaki jaka kipatsikika. ");
INSERT INTO cjoNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","25","Osheki ikijanakina iroñaaka atziripaeni. Paapatziyakina rootaki ikijantemiri eerori. Pamine, aririka imonkaawityaari riyotaanewo iyoteeriri riyote ari kameetha, omaanta eero imatziro ranaakotziri. Eejatzi aririka imonkaawityaari onampirentsi riraga omperatariri ari kameetha, omaanta eero imatziro ranaakotziri. Osheki ikijakina, iitashitakina naaka Wereshewoo riraga iwinkatharite kamaaripaeni. Iinja rowanaaperotemi eeroka osheki ikijaperotanakimi. ");
INSERT INTO cjoNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Omaanta eero pithaawanteeyarini. Iinja ari piyotakiro maawaeni kaari piyotziri iroñaaka. Tema ari piyotakiri ninkarika kijakiriri Tajorentsi eejatzi ninkarika kijakimiri eerokapaeni aapatziyanari naari. Piyotero oetaka rantayitakirini eejatzi tsika ikanteeteri rowashironkagaeteri. Iroñaaka tee riyotzi irirapaeni nopinkatharitaki, omaanta iinja riyoperoeyeni maawaeni; iñaawakinaka nopinkathariperotapaaki naari, eejatzi pikaatena eerori. ");
INSERT INTO cjoNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Apaniroeni nokamantakimi eerori iroñaaka, omaanta tekira riyotzi theenkantatsiri, nomanawitakawo. Iinja nokowaki pikamanteri maawaeni riyotantyaari irirapaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Imatawityaawo rirori theenkantatsiri rowamaemi omaanta eero pithaawantari. Tekatsi ikantemi rotyaantemi paamari kaari tsiwakanitatsini. Omaanta riraga Tajorentsi pipinkathaperoteri; ikowakirika irira imatero rowamaemi eejatzi rotyaantemi janta paamari kaari tsiwakanitatsini. Rirotaki pithaawantyaari irira. ");
INSERT INTO cjoNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Pamine, tee ipinaperowita tsimeri iryaanini, riraga jenokiweripaeni, omaanta teerika ikowakayiri Tajorentsi ikame, eero ikami. Eejatzi riyotzi tsikarika okaate ikamantyaari apaani. Eejatzi okimitakya eerori, eerorika ikowakayimi pikame, eerokya ishinetziri atziri rowamaemi. ");
INSERT INTO cjoNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Riyotziro tsikarika okaatzi piishi, tema eejatzi riyotziro maawaeni okaatzi awijimotemini. ");
INSERT INTO cjoNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ñaakiro, osheki panaakotziri tsimeripaeni jenokiweri, osheki ikenkithashiryaakimi riraga Tajorentsi. Iroñaaka eero pithaawantari. Ikantzimatemirika atziri, omaanta eero pithaawantari. ");
INSERT INTO cjoNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Pikanteririka atziri: “Naapatziyari Jesoshi”, eejatzi naari nokimitzityaawo janta jenokinta nokanteri Pawa: “Raapatziyakina rirori, nosheninkatakari”. ");
INSERT INTO cjoNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Omaanta pikanteririka atziri: “Tee naapatziyari Jesoshi”, eejatzi nokimitzityaawo naari janta jenokinta nokanteri Pawa: “Tee raapatziyana rirori, tee niyotziri naari”. ");
INSERT INTO cjoNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Eejatzi ikantana riraga Jesoshi: —Eero piitakaashita nopokakika jaka ari raakameethatawakagaeyanakyaani atziri. Tee rootaki nopokanta raakameethatawakaanteeyarini inta ikijawakaeyantyaarini. ");
INSERT INTO cjoNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","36","Aririka raapatziyena apaani shirampari omaanta rirentzi tee raapatziyana. Rootaki ikijawakaantari. Ikimitaaganki shirampari aririka raapatziyena naaka tema ari ikijawakiri ashitariri. Tsinani aririka aapatziyena roori ari okijawakiro iniro; eejatzi okijitanakyaawo ewatyeero rowaga ayiro kaari aapatziyana. ");
INSERT INTO cjoNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Rooma okameethatzi pinintaperoteri piri eejatzi piniro, omaanta nokowaki kameethapero pinintashireperotena naari. Eerorika pinintaperotana, eero noñaaperotzimi eerori pikameethatzi. Eejatzi, okameethatzi pinintashireteri pitomi eejatzi pishinto, omaanta nokowaki kameethapero pinintashireperotena naari. Eerorika pinintashireperotana, eero noñaaperotzimi eerori pikameethatzi. ");
INSERT INTO cjoNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Nokowaki pikyaaryoowentenawo maawaeni nokowakaakimiri. Aririka ikijanteetemiro, omaanta nokowaki eekiro piyaatatyee pikyaaryoowentenawo oetarika nokowakaakimiri. Eerorika pikyaaryoowentanawo maawaeni, eero noñaaperotzimi naari pikameethaperotzi. ");
INSERT INTO cjoNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Aririka pikaminthaaperotya eerori apaniroeni iroñaaka, ari powashironkaaperotanakya iinja. Omaanta paapatziyaperotenarika iroñaaka, omawitya rowashironkawitemi atziri, tema eero patsipetashitawo paapatziyana; aritaki iinja pañaagae janta okameethaperotzinta. ");
INSERT INTO cjoNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Piyaatantari, ninkarika aakameethatemini eeroka, tema raakameethatzitakina naari eejatzi. Eejatzi maawaeni aapatziyanari, tema rirotaki aapatziyaariri Pawa, riraga otyaantakinari. ");
INSERT INTO cjoNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Maawaeni aririka raapatziyari eejatzi raakameethateri kamanantayitzirorini iñaani Tajorentsi imonkaatawakaantyaari iñaaperotawakiri rirori. Tema ari ipinatakiri iinja. Eejatzi okimitaka maawaeni aririka raakameethateri kameethatzinkari riraga aapatziyanari eejatzi ikimitakari, imonkaatawakaatya iñaaperotawakiri riraga Tajorentsi ikameethatzi. Eejatzi ipinatzityaari iinja. ");
INSERT INTO cjoNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ninkarika pantashitachari atziri oetarika omawitya apatziro tajokira iñaa tema rirotaki aapatziyanari nonintanewo, kyaaryootaki nokantzimiri: “Eero patsipetashitawo panteri, ari ipinatakimi Pawa iinja”. ");
INSERT INTO cjoNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Rootaki ikanteeyanarini riraga Jesoshi, ari okaatapaaki riyotaakinari. Roojatzi niyaateeyanakini. Eejatzi rowaaganaka Jesoshi janta paashinipaenikinta nampitsi, riyotaakiri jeekatsiripaeni, ikenkithatakaakiri. Niyaatanaki naaka apitepaeni, eejatzi paashinipaeni riyaateeyanakini apitepaeni riyotaanewopaeni, nokaateeyini 12. ");
INSERT INTO cjoNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Riraga Jowa kaawoshitakowentziriri Tajorentsi ijeekaki iroñaaka omonkyaagamentotsiki. Ikantaka ikemakotakiro rantakiri Jesoshi, riraga iiteetziri Rotyaantanewo Tajorentsi, rootaki rotyaanantakari apite riyotaanewo raminakiteri Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ikantawakiri: —Piyaatashitakiririka Jesoshi pojampitapaakiri: “¿Eerokama Rotyaantanewo Tajorentsi naamagaeyakarini? ¿Eenitatsima paashini naamagaeyarini?” ");
INSERT INTO cjoNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Roojatzi ipokantapaaka rirori apite rareetapaakari Jesoshi. Rojampitantapaakari, ikantawakiri: —Iroñaaka pipiyanee, pikamantapaeri Jowa okaatzi maawaeni pikemakinari eejatzi maawaeni piñaakotakinari. ");
INSERT INTO cjoNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Pikamantapaeri naminakagaeyakirini riraga kaari kokichaawitacharini, nokatziyatziyatakagaeyakarini riraga kijopookiwitacharipaeni, netsiyatakotakagaeyakirini riraga pathaawitacharipaeni, nokemakagaeyakirini riraga kaari kemawitachanipaeni, eejatzi nopiriintayitaneerini kamawiteencharipaeni. Niyotakagaeyakirini owashironkaawitacharipaeni tsika ikantya rowawijaakotanteeyaariri riraga Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Riweshiryaakaanakimi maawaeni kaari theenkanari naaka. Rootaki pikantapaeriri Jowa. ");
INSERT INTO cjoNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Roojatzi ipiyantanaa janta riraga apite, ikanantapaariri riraga Jowa okaatzira iñaakotakiriri janta. Omaanta eeniro ijeekaki riraga Jesoshi ikenkithatakagaeyakirini piyotawentakariripaeni, ikantanakiri: —Paerani piyaatapiintzi janta tekatsinta atziri ipanko pikemijantapiintziri Jowa. ¿Iitaka piyaatashiteeyantakitaririni? ¿Rootakima piyaatashitantariri pikemijanteri ñaawaetashitachari? Teewee. ");
INSERT INTO cjoNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Piyaatashitantakitariri piñaakitzirima atziri kithaatachari kameetha? Teewee. Riraga kithaatawori iithaari kameethatatsiri ijeekaeyini janta ipankoki jewawenantatsiri. ");
INSERT INTO cjoNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ajaatya, pikamantena: ¿iitaka piyaatashitakitziri? ¿Riroma piitziri kamanantzirori iñaani Tajorentsi piyaatashitantakitariri? Tema kyaaryo ikamantziro, omaanta ranaakoperoeyakirini paashinipaeni kamanantayitzirorini iñaani Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ikenkithatakotzitakarini paerani Tajorentsi, ikantzitakinani: “Notyomi, notyaanteri iinja jewatemini ikenkithatakaapaakiri joriiyopaeni, ikanteri: ‘Pikenkithashireeyaanitya, okameethatzi pijeeki kameetha, paamayari Awinkatharite, kaakitaki’ ”. Rirotaki riraga Jowa kaawoshitakotziriri Tajorentsi rojankinatakotziteetakariri paerani. ");
INSERT INTO cjoNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Kyaaryo nokamantemiri, tema oshekini naawita kamanantatsiri omaanta tekatsi kimityaarini Jowa riraga kaawoshitakotziriri Tajorentsi. Tema ranaakoeyakirini maawaeni paashinipaeni riyoperotakiri Tajorentsi. Omaanta riraga atziri kaariroña yoperotatsi omaanta iñaakiririka Jesoshi itajonkantzi rootaki ranaakoperotantanakariri iroñaaka Jowa; tema iñaakiri tsika ikanta Tajorentsi reewawenantzimatzi. ");
INSERT INTO cjoNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Paerani ikenkithatakotanani naari riraga Jowa kaawoshitakotantatsiri Tajorentsi, eejatzi raapatziyakawo osheki atziri okaatzi ikenkithatakotanari. Iroñaaka nokenkithatakotziri Tajorentsi piyotanteeyakarini. Eejatzi paapatziyakaanteeyaririni. ");
INSERT INTO cjoNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Tema paeraninki ikenkithatakotanani maawaeni kamanantayitzirorini iñaani Tajorentsi, riyotanteeyaworini maawaeni nopokaerika iinja. Eejatzi ikimitani Moeseeshini ikenkithatakotana. Maawaeni ikantzini: “Aritaki ipokaki Rotyaantanewo Tajorentsi, omaanta rityaawo ipoke kimiwityaarini Iriiyashini, eentsikiro rimpaetapaaki Rotyaantanewo Tajorentsi”. ");
INSERT INTO cjoNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Aririka paapatziyawo nokantzimiri, rirotaki irira kimiwitariri Iriiyashini ipokapaaki. Tema reewatakina Jowa. ");
INSERT INTO cjoNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Iroñaaka pikemaperotakina pikempitakira. Rootaki ikanteeyiririni maawaeni piyotawentariri. ");
INSERT INTO cjoNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Eejatzi ikanteeyirini riraga Jesoshi: —Tee piyotzi iitarika pikoyiri pikemijanteri. Pikimitakari eentsipaeni jeekatsiri awotsiki, kantziriri paashinipaeni: ");
INSERT INTO cjoNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Nojonkawaetantawitari omaanta tee inimotakimi, tee piweshiryaanaka. Niraawitanaka, omaanta tee piraaga. Tee nomatziro niweshiryaakayemi”. ");
INSERT INTO cjoNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ñaakiro, pikowawita ranteeyeronimi pinampijatzi oetarika pikowakaawitakariri. Piñaawitakari Jowa rametakawo tee rowa kameethatatsiri eejatzi rametakawo tee rirapiintziro shinchaaripaeni ikenkithashiryaakotari Tajorentsi. Roojatzi pikantashitari: “Oo, eenitatsi iyamaarite pinkakaakiriri, rootaki kaari rowaperotanta eejatzi kaari rirantawo shinchaari”. ");
INSERT INTO cjoNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Naaka poñaachari janta jenokinta, nokoñaatapaaki jaka kipatsikika. Nowa maawaeni eejatzi niriro shinchaari. Roojatzi pikantzimatakina: “Pamine sha, irinta owashitachari, shinkitachari. Itsipaminthatakari ayitakaeriri ayorikite eejatzi paashinipaeni kaari kameethatzinkari”. Omaanta nokantemi riyotzi Tajorentsi ari okameethataki maawaeni ikowakaakinari; eejatzi maawaeni aapatziyanari, riyotaki okameethataki ikowakaakinari Pawa. Rootaki ikantziriri. ");
INSERT INTO cjoNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Roojatzi riraga Jesoshi ikantakotziri jeekatsiri nampitsipaeni tsikarika itajonkantzi osheki. Iñaawitawakari osheki riroripaeni omaanta tee ikenkithashiryaa, tee ikoyi ipakaero kaari kameethatatsi rantziri: tema itheenkakiri riraga Tajorentsi. Rootaki ikananteeyaririni: ");
INSERT INTO cjoNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—Ashironkaamatsitemiini eerokapaeni korashiinijatzi, eejatzi eeroka wetheerajatzi. Powashironkaanakya maawaeni. Osheki piñaawitawakina notajonkantzi, omaanta tee pikenkithashiryaawaka, tee paapatziyana. Iñaawakinami notajonkantzi riraga tziirojatzini paerani, eejatzi riraga shiroojatzini, ari ikenkithashiryaanakyaami, ipakaakiromi kaari kameethatatsi rantzirini paerani, raapatziyenami. ");
INSERT INTO cjoNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Iinja aririka ikantakowenteri maawaeni Pawa, rowashironkayeri riraga tziirojatzini eejatzi riraga shiroojatzini, osheki tee ikameethatzini. Omaanta rowashironkaaperotemiroña eerori. Tema piñaakotawitakinawo notajonkantzi omaanta tee paapatziyana. ");
INSERT INTO cjoNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Eejatzi eerori kaperinawoojatzi, piitashiwitakawo piyotakiri Tajorentsi piyaatantyaari jenokinta, omaanta pitheenkawaetana, rootaki piyaatantyaari owashironkagaantsikinta, ari pikemaatsityaaworoña paamari jaawiki. Iñaawakiromi riraga joroomajatzini maawaeni piñaawakiri eerori, ari ikenkithashiryaanakyaami, eero ithonkirimi paerani Tajorentsi, roojatzi okantyaani iroñaaka inampi. ");
INSERT INTO cjoNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Iinja eejatzi rowashironkayerini riraga Tajorentsi joroomajatzini, tee rameentari riraga Tajorentsi, omaanta rowashironkaaperotemiroña eerori kaperinawoojatzi, tee paapatziyana, omawitya piñaawitakinaga notajonkantzi. Rootaki ikantziriri riraga Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Paashini kitejiri ikenkithatakaakiri riraga Jesoshi Iriri, ikantziri: —Noñaaperotzimi, Pawa, eeroka jewaperowentziriri maawaeni janta jenokinta eejatzi jaka kipatsikika. Eenitatsi kantashitacharipaeni ikantashita: “Niyoperotzi naari”, omaanta pimanapithateeyakirini piyotantari. Ariwee. Omaanta piyotakaanteeyakirini paashinipaeni, riraga atziri kimitariri eentsipaeni: tema irirapaeni kaari kantakaaperotachari inta raapatziyeeyimini. ");
INSERT INTO cjoNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Pineshironkateeyakirini irirapaeni, pikowakaakiri riyote. Ariwee, pantziro pikoyiri. ");
INSERT INTO cjoNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Rootaki ikantziriri ashitariri, roojatzi ikananteeyakaririni piyotawenteeyaririni: —Rirotaki Pawa iyotakaakinari maawaeni, eejatzi riyoyaakina nopinkathariwenante maawaeni. Tekatsi paashini atziri yotakoperotziriri Itomi: apatziro Pawa rirori riyoperotana. Eejatzi tekatsi yotakoperotziriri riraga Pawa, apatziro naari niyoperotakotziri. Eejatzi riyotziri rirori, riraga atziri niyoyaakiri niyotakaantyaariri. ");
INSERT INTO cjoNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Eeroka maawaeni, aririka patsipetyaawo kameethatanakimi, aririka powashironkaeya, pameentena pikantena, aritaki nowawijaakotakimi niweshiryaakayemi. ");
INSERT INTO cjoNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Paapatziyena pikowakirika niyoteemi; tema naaka amatsinkakayemini eejatzi osheki noneshironkatantzi. Eero nopomeentsitawentzimi. Aririka paapatziyena, niweshiryaakayemi. ");
INSERT INTO cjoNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Pikowakirika naakarika piwinkatharite, eero nowashironkaantzimi, inta namitakotapiintemi. Pikowakirika naakarika piwinkatharite, eero opomeentsitzimotantzimi paapatziyena, tema nokimoshiryaakaakimi. ");
INSERT INTO cjoNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Paashiniki saawaro noyaateeyakirini Jesoshi janta pankiwaerentsimashikinta, maawaeni nokaateeyakirini riyotaanewopaeni. Rooteentsi ojampate teriiko. Eejatzi ayimateeyakinani notashe janta, rootaki notzimpejanteeyanakaworini nowaeyakawoni. ");
INSERT INTO cjoNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Iñaawakina warijeeyopaeni, roojatzi ikanantakari Jesoshi: —Pamineriita piyotaanewopaeni. Iroñaaka kitejitatsiri kaari antawaetantapiinta; iroñaaka tee okameethatzi rowiitantyaawori; tee ikemijantaperotziri okaatzi ikantziri Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Rakanakiri: —Tema tee piñaananeentziro Iwaperite Tajorentsi okenkithatakotakirini Iraviirini. Ayimatantawitakarini paerani itashe, eejatzi ayimatantawiteeyakaririni itashe maawaeni oyaatziriri. ");
INSERT INTO cjoNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Roojatzi ikyaantapaaka okaankiitzi ipankomawoki Tajorentsi. Eenitatsi jewatatsiri janta, riraga ñaanakowenantatsiri. Ari ikantapaakiri: “Ayimatakina notashe”. Eeniro ojeekaki paa janta rashi Tajorentsi. Tee ishineteetziro royaawo maawaeni joriiyopaeni, apatziro riraga ñaanakowenantatsiripaeni rirotaki oyaawoni. Omaanta tee ikoyi rowashironkayeeri, rootaki ipantawakariri Iraviirini, eejatzi tsipatariripaeni. Rowaeyakawoni. Iroñaaka tee pikantzi: “Tee okameethatzi rantzirini Iraviirini”. ¿Iitaka pikanantari: “Tee okameethatzi iroka rantziri piyotaanewopaeni?” ");
INSERT INTO cjoNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Eejatzi piyotakiro rojankinatakirini paerani Moeseeshi: “Okaate 6 kitejiri pantawaete omaanta apaani kitejiri eero pantawaetantawo”. Maawaeni saawaroki tee antawaetapiintzi aakapaeni. Omaanta maawaeni saawaroki riyaatapiintzi ñaanakowenantatsiri rantawaetapiintzi janta Tajorentsipankoki. Tee pikijantari, tema inimotakimi rantziri. ");
INSERT INTO cjoNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Kyaaryo iroka nokantemiri: okaatzi niyotaantziri naari anaakoperotakiro oetarikapaeni riyotagaetziriri atziri janta Tajorentsipankoki. ");
INSERT INTO cjoNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ñaakiro, rojankinateetakini paerani: “Ikantzi Tajorentsi: ‘Tee nokoyi apatziro powamashitapiintenari pipira, inta nokowakaaperotakimiri paapatziyaperotena; nokowaki pineshironkatante kameetha maawaeni atziri’ ”. Piyotakoperotakirorikami iroka ikantziri Tajorentsi, tema eeromi pikanantarimi irika owiitakirorika teriiko: “Tema eenitatsi kaari kameethatatsi pantziri”. ");
INSERT INTO cjoNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Nopoñaaka naaka jenokinta, nokoñaatapaaki jaka kipatsikika: tema naaka kantatsini oetarika anteri saawaroki. Rootaki ikantziri Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ikanta itharyaakagaeyanakinani riraga Jesoshi roojatzi ikyaakaanteeyapaakinani pankotsiki apiyotantapiintarira aaka joriiyopaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Eenitatsi janta warijeeyopaeni eejatzi eenitatsi atziri kijopookitatsiri rako. Riraga warijeeyopaeni ikantawakiri riraga Jesoshi: —¿Okameethatzima petsiyatakoteri atziri kitejitatsiriki kaari rantawaetantapiinteetari? Ikowaki retsiyatakoteri Jesoshi atziri kitejiriki kaari rantawaetantapiinteetari, rootaki ikantakotashitantakariri jewayitatsiriniki ikante: “Rantawaetzi Jesoshi kitejitatsiriki kaari rantawaetanteetari, tee ikameethatzi irika”. ");
INSERT INTO cjoNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Rakanaki: —Pamine, aririka ipariye powishate omookira kitejitatsiriki kaari rantawaetanteetari, ¿eeroma pagaatziri pariyawiteenchari omooki? ");
INSERT INTO cjoNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Tema ranaakotziri atziri owisha, ikameethaperotaki. Okameethatzi aneshironkateri atziri kitejitatsiriki kaari rantawaetanteetari. ");
INSERT INTO cjoNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Roojatzi ikanantawakari riraga kijopookitatsiri rako: —Powankaero pako. Roojatzi rowankantanakawo, kameethatanee rako, omonkaatanaawo paashini rako. ");
INSERT INTO cjoNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ikanta warijeeyopaeni ikijeeyanakani, riyaatanaki rajaryagaeyanakarini, ikantzi: —¿Tsika akanterika owamaakaanantyaariri Jesoshi? ");
INSERT INTO cjoNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Riyotakotanaka riraga Jesoshi ikowatzi warijeeyopaeni rowamaakaanteri, rootaki ishitowapithatantanakariri, rowaagakaantanakinari, royaateeyakinani osheki atziri. Ikanta Jesoshi retsiyatakotakiri oshekini mantsiyatzinkari, maawaeni pokashitziriri. ");
INSERT INTO cjoNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Roojatzi ikanteeyantakaririni: —Eerowa pikamantziri paashinipaeni: “Retsiyatakotakaakina Jesoshi”. ");
INSERT INTO cjoNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Imonkaatakiro Jesoshi maawaeni rojankinatakotzitakarini paerani Iseeyashi. Ikantzitakarini Tajorentsi: ");
INSERT INTO cjoNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“¡Pamine sha! Irika notyaantanewoka. Nokowakaakiri rantenawo maawaeni oetarika nokowakaakiriri. Osheki nonintaperotziri, osheki noñaaperotziri ikameethatzi. Notyaanteniri noshire, okithaatakayaari, amitakopiinteri. Ikanteri paashinijatzitatsiri atziri, raapatziyeena, nookirikari paamariki kaari tsiwakanitatsini, rowaga kitejitatsiri iinja nokantakowenterini maawaeni atziri ikameethatzirika. ");
INSERT INTO cjoNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Eero ipiyawaantetanta, eero ishintsitziro ipaante. Eero akemiri icherayi. ");
INSERT INTO cjoNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Eero rowashironkaeri owashiretachari. Eero ramatawitziri kowatsiri riyotena. Ikantyaani ineshironkatante, roojatzi kitejitatsiri iinja nokantakowenantyaaririni maawaeni atziri. ");
INSERT INTO cjoNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Rirotaki owawijaakoteerini paashinijatzitatsiri atziri, tekatsi paashini owawijaakoteerini”. Rootaki maawaeni aapatziyariri raamaantakariri rirori. Rootaki ikantakirini Tajorentsi paerani. ");
INSERT INTO cjoNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ikanta ramaetakiniri Jesoshi kyaantariri kamaari. Tee imateeya iñee, eejatzi tee iñaawaetzi. Roojatzi rowawijaakotantawakari: iñaakagaeri eejatzi iñaawaetakagaeri. ");
INSERT INTO cjoNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ari rotsikanateeyanakarini maawaeni ñaakoeyakiririni ikantawakaeyanakani: —¿Rirotakima irika Owawijaakotanteentsirika aamagaeyakarini riraga icharineeteni Iraviirini? ");
INSERT INTO cjoNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Omaanta riraga warijeeyopaeni ikantawakaaka: —Rirotaki Wereshewoo, riraga iwinkatharite kamaaripaeni amitakotakiriri imatantakariri rotyaantakiri iyamaarite. ");
INSERT INTO cjoNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Omaanta Jesoshi riyotakotakiri okaatzi ikenkithashireeyakirini rootaki ikanantakariri: —Aririkami romanatawakaeyaami atziripaeni kipatsikitzirika tema ari ithonkawakagaeyakyaanimi. Eejatzi okimita riraga jeekatsiripaeni nampitsiki aririka rantawakaakya, rinteenaryaawakaeyanakyaanimi eero kijokiro rowawakaanami rookawakaanakya, itsiparyaawakaanakya. ");
INSERT INTO cjoNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Pamine, aririkami ramitakotenami Jatanaashi notyaanteri iyamaarite, tema ari ithonkaeyawakaakyaanimi. ");
INSERT INTO cjoNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Eejatzi pikantzi eeroka rirotaki Wereshewoo rirorikami amitakotenanimi notyaantziri kamaari, nojampitemi eerori, ¿rirojatzima eejatzi kamaari amitakotziriri pisheninkapaeni eerori rotyaanantariri kamaari? Kaariwee. Pojampiteri piyotaanewopaeni riro kantemini okaatzika pikantakiri kameethatakirika. ");
INSERT INTO cjoNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Omaanta rootakirika Ishire Tajorentsi amitakotanari notyaanantakariri kamaari, tema rootaki piyotantyaarimi monkaataka kitejiri ikowantawitari Tajorentsi ipinkathariwenteeyeminimi pajankaneki. ");
INSERT INTO cjoNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Eenitatsirika kowatsiri ikoshiteri shintsiperotatsiri, rooma rityaawo roteyiri, shepik, ranaakoteri roojoteri. Impaetzi ikoshiteri rowaagawo, eero imatziro ipiyatawakari ashitawitawori rowaagawo. Eejatzi ikimitaka, Jatanaashi ikimiwitakari shintsitatsiri, omaanta otajonkakina roori Ishire Tajorentsi, nanaakotziri rirori, nomatantawori notyaanteri iyamaarite. ");
INSERT INTO cjoNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Riraga kaari aapatziyana rirotaki kijantanariri. Eejatzi okimiwita iroka maawaeni kaari amitakotana niyotaakoteri Tajorentsi, ari riyotaakiri atziri kaari raapatziyantyaari rirori. ");
INSERT INTO cjoNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","32","Eejatzi ikantakiri Jesoshi riraga warijeeyopaeni: —Rootaki nokamantemiri: “Kyaaryoowa, pitheenkimatzirokarira Ishire Tajorentsi. Riraga Tajorentsi ineshironkatziri maawaeni kaari kameethatawitacha, eejatzi maawaeni kantzimatawitariri eero ikijantari rantziri aririka raapatziyeeyari. Eejatzi ineshironkatziri Pawa maawaeni kantzimatawitanari. Omaanta eero ineshironkatziri riraga kantzimatakirori Ishire. Eero ineshironkatziri iroñaaka eejatzi iinja, inta rowashironkaeri kameetha”. ");
INSERT INTO cjoNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Rooma inchato kameethari okithokitanaki kameetha okithoki. Rooma teerika okameethatzi inchato, tee okithokitziro okithoki kameethari. Piñeerorika okithoki okameethataki piyotanakiro roori owaato kameethataki. Eejatzi nokimita naari, aririka nantero kameethatatsiri, tema kameethatakina, omaanta aririkami nanteromi kaari kameethatatsi eero nokameethatzimi. Iñaanteeri atziri okaatzi antziri riyotanteeri akameethatzirika, rooma teerika akameethatzi. ");
INSERT INTO cjoNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Amatawitantaniri eerori maawaeni, poshiyakari maanki. Osheki pitheeya. Tekatsi pikantya piyotaante kameetha. Tee okameethatzi pikenkithashiryaari pajankaneki, rootaki kaari okameethatanta pikantziri. ");
INSERT INTO cjoNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Riraga kameethatatsiri atziri ikenkithashiryaapiintawo kameethatatsiri, rootaki okameethatantari rantziri. Rooma riraga kaari kameethatzinkari ikenkithashiryaapiintawo rantero kaari kameethatatsi, rootaki kaari okameethatanta rantziri. ");
INSERT INTO cjoNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Pamine, oetarika pikantziri jaka jaawikika riyotaki Tajorentsi. Iinja kitejitatsiri othonkantapaakyaarini kipatsi, arimache ikantakowenteeyemini: ikenkithashiryaakayemiro maawaeni tee okameethatzi pikantziri iroñaaka. ");
INSERT INTO cjoNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Okameethatzirika pikantziri, aritaki iñaaperotemi pikameethatzi, omaanta teerika okameethatzi pikantzi, ikantemi: “Eenitatsi kaari kameethatatsi pantziri, tema tee paapatziyana kameetha. Rootaki piyaatantyaari paamariki kaari tsiwakanitatsini, osheki pikemaatsityaawo”. Rootaki ikantakiriri riraga Jesoshi warijeeyopaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Roojatzi ikanantawitanakari warijeeyopaeni eejatzi iyotaantayitzirorini Iwaperite Tajorentsi: —Iyotaanari, nokowaki noñeemi pitajonkero oetarikapaeni, niyotantemiri eerokarika riraga Owawijaakotantatsiri. ");
INSERT INTO cjoNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ikantawakiri riraga Jesoshi: —Tee pikameethateeyini, osheki pitheenkakiri Tajorentsi, rootaki pikanantawitakinari. Eero noñaayimiro notajonkantzi. Omaanta apatziro nokenkithashiryaakagaemiri rantakiri paeraniperoroña Jonaashini riraga kamanantzirorini iñaani Tajorentsi. Pikenkithashiryaakotatyeeromi tema ari paapatziyakinami. ");
INSERT INTO cjoNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Paerani iniyakirini antari omani, okaataki 3 kitejiri ijeekaki isheetomawokinta inthomaenta. Eejatzi nokimitya naari paata, okaate 3 kitejiri nojeeki inthomaenta omooki kipatsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Aririka ipiriinte niniweejatzi ikantakowenteeyakimironi oetarika pantziri. Iinja Tajorentsi, ikantemi: “Eenitatsi kaari kameethatatsi pantakiri eerori”. Paerani riraga niniweejatzini raapatziyawakarini Jonaashi ikenkithatakotantariri Tajorentsi. Iroñaaka eeroka, piñeeyawitakinani naari. Tema osheki nanaakoperotakirini riraga Jonaashini, omaanta tee paapatziyawakina. ");
INSERT INTO cjoNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Kyaaryo ikantakoeyemini eerori iinja riraga Tajorentsi: “Eenitatsi panteeyakirini kaari kameethatatsi”. Paerani iwinkathawoteni sheewajatzinipaeni okemakotantakaririni Sharamoo riyothanitzi osheki, rootaki opokashitantakariri okemijanteri. Atsipewentakari opoñaanaka inteena. Omaanta naaka nanaakoperotakiri rirori. Piñeeyawitakinani omaanta tee paapatziyeeyanani. ");
INSERT INTO cjoNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Eejatzi noshiyakaawentemiro: aririka apaani atziri rookaeri kamaari ikinanaki janta opiryaapathatzinta ikowakowatzi tsika imakoryaantyaari. Omaanta tee iñi imakoryaantyaari. ");
INSERT INTO cjoNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Roojatzi ikantzi: “Nopiyeeta nopoñaakanta ishireki shirampari”. Roojatzi ipiyantaa, iñaapaatziiri shirampari ikimiwitakawo pankotsi pishiityaaka tekatsi jeekantyaarini. Tema tee raapatziyaperotari Tajorentsi. Rootaki ikyaanantapaariri kamaari. ");
INSERT INTO cjoNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Roojatzi riyaatantanaka raakitziri paashini kamaari, ikaatzi 7. Maperori osheki tee ikameethatzi. Ikantakiri: “Thame aate ajeekaeyini nojeekira chapinki”. Irika atzirika paerani rowashironkaawitakani eechonkiini. Omaanta iroñaaka rapiiteerira imaperotakiri, osheki rowashironkaaperotanakya. Eejatzi pikimiteeyakani eerori iroñaaka tee pikameethatzi, rootaki osheki powashironkaanteeyaarini iinja. Rootaki ikanteeyakiririni riraga Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Eeniro ikenkithawaetakagaeyanani riraga Jesoshi naakapaeni maawaeni piyotawentakariri, okantaka riniro areetapaaka eejatzi rirentzipaeni, ikatziyeeyapaakani janta inkokironta. Tema okowaki okenkithatakayeri. ");
INSERT INTO cjoNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Eenitatsi kamantakiriri: —Areetapaaka piniro eejatzi pirentzipaeni, okowapaakimi. Okowaki okenkithawaetakaemi. ");
INSERT INTO cjoNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Omaanta ikantawakiri: —¿Ninkama nanatatsiri? ¿Ninkama yeeyitatsiripaeni? ");
INSERT INTO cjoNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Roojatzi rookotanteeyanakarini riyotaanewopaeni ikantanakiri: —Irika niyotaanewopaeni, sha, nokashiyakaakari rirotaki yeeyipaeni, eejatzi noñaakiro kimitaka nana. ");
INSERT INTO cjoNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Rirotaki nonampijatziperoeyakarini maawaeni antziniriri Pawa jenokinta ikowakaakiriri; rirotaki nokanteeyirini yeeyi, choeni, eejatzi nana. ");
INSERT INTO cjoNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Roojatzi riyowantanaka riraga Jesoshi pankotsiki jataki inkaareki. Ari ijeekapaaki. ");
INSERT INTO cjoNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Eejatzi ipiyotawentakari oshekini atziri. Iñaapaakiro rirori pitotsi othataka othapyaakiinira, roojatzi rotetantapaaka, ijeekapaaki. Ari ikatziyeeyapaakani piyotawentariripaeni impanekiiteki. ");
INSERT INTO cjoNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Roojatzi osheki ikenkithatakagaeyakinani. Roshiyakaawentakinari pankiwaetatsiri, ikantzi: —Riyaatzi pankiwaetatsiri rookayitzironi okithoki teriiko rowaneki. ");
INSERT INTO cjoNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Pariyagaantapaentsiri apaanipaeni okithoki awotsiki ikantaka konthawo ipokapaaki rowapaakawo. ");
INSERT INTO cjoNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Paashini apaanipaeni okithoki opariyagaantapaaki mapipookiki. Tekatsiperowa kipatsi: eechonkiini janta. Intsipaete oshookawitanaka. Eejatzi intsipaete antawotapaaki. ");
INSERT INTO cjoNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ishintsiityaapaaki oorya intsipaete ojampiyanaki. Roojatzi okamantaka, tema tekatsi osheki oparitha. ");
INSERT INTO cjoNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Paashini okithoki pariyapaentsiri kitocheemashiki. Oshookawitanaka pankirentsi anaanakiro kitochee roojatzi okamantanaka. ");
INSERT INTO cjoNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Paashinipaeni okithoki opariyapaaki kipatsiperoki kameethari. Oshookanaki, okithokitanaki. Apaanipaeni okithokitanaki okaatzi 30. Paashinipaeni okithokitanaki okaatzi 60. Eejatzi paashinipaeni okithokiperotanaki okaatzi 100. ");
INSERT INTO cjoNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Eenitatsirika pikempita pikemantari, aritaki powakempitatyaawo nokantakimiri. ");
INSERT INTO cjoNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Notsipatanakari paashinipaeni riyotaanewo nojampitapaakiri riraga Jesoshi: —¿Iitaka poshiyakaawenantakariri paashinipaeni? Tee imateeyironi riyotakotziro oeta pikantawitariri. ");
INSERT INTO cjoNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ikantawakina: —Ishinetzimi Tajorentsi piyotakotero kaari riyotzi paashinipaeni. Ikowaki piyote tsika ikanta rirori ipinkathariwenantzi. Omaanta tee ikoyi riraga paashinipaeni riyotakotero tsika ikanta reewawenantzi. ");
INSERT INTO cjoNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Eenirorika yowitachari ikoyirika riyoperote, aritaki niyotakaaperotakiri. Omaantakya paashinipaeni kaari kowatsini riyote, rootaki kaari riyotantyaari. Eero niyoteeri eejatzi ari nopeyapithatakiri riyowitari eechonkiini. ");
INSERT INTO cjoNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Rootaki noshiyakaawenantakanariri riroripaeni, rooma tee ikoyi riyote. Ramineeyawityaani omaanta riyotakoeyironi iñeeyawitakarini. Ikemaeyawityaani nokantziri omaanta tee riyotakotawakiro nokantawitariri. ");
INSERT INTO cjoNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Omaanta imonkaatapaakiro ikenkithatakotzitakarini paerani Iseeyashi, ikantakotzitakarini: “Pikemaeyawityaani omaanta eero piyotakotawakiro okantakotziri. Pamineeyawityaani omaanta eero pikenkithashiryaakoeyawoni piñeeyawitakarini. ");
INSERT INTO cjoNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Tee pikoyi piyote, rootaki kaari pikenkithashiryaantawaka. Tee pikoyi pikemi, rootaki piwitantawakawori pikempita. Tee pikoyi paminaperote, rootaki pimachookantawakari. Aririkami pikowakimi piyotemi aritaki pikemawakiromi, eejatzi piñaakimi eejatzi piyotakotenami pajankanekira. Rooma tee pikoyi paapatziyana nowawijaakotantemiri”. Rootaki ikenkithatakotakiririni paerani Iseeyashi. ");
INSERT INTO cjoNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Omaanta eerori amineeyeemini, pikokichaatantawo poki rootaki paapatziyantakinari, tema rootaki pikimoshireeyantarini. ");
INSERT INTO cjoNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Kyaaryo, ikowaeyawitakani paerani maawaeni kamanantayitzirorini iñaani Tajorentsi eejatzi maawaeni kameethatzinkarini iñeeyeronimi iroka piñaakirika iroñaaka eerokapaeni. Ikowaeyawitakani ikemaeyenanimi okimitaka iroñaaka eeroka pikemanari. Omaanta tee iñeeyanani, tee ikemaeyanani. Rootaki ikanteeyakinarini Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Roojatzi ikanteeyantakinani riraga Jesoshi: —Iroñaaka niyotagaeyemironi oeta okantakotziri noshiyakaawentakimiri inkaaganki. ");
INSERT INTO cjoNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Arimachee nokantapiintziri paashinipaeni tsika ikanta Tajorentsi reewawenantzi, omaanta teerika ikemiro rirori, ikimiwitawo awotsi tsikarika opariyagaantapaaki apaanipaeni okithoki. Ikanta ipokapaaki konthawo rowapaakawo okithoki awotsiki, ari oshiyawori ipoki kamaari raapithatakiri rajankaneki ikenkithashiryaawitawakawo nokantziri. ");
INSERT INTO cjoNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","Rooma mapipooki opariyapaakira paashini okithoki oshiyakaawentakiri atziri kemawitawakawori noñaani ariwitanaka owakirani ikimoshirewentanakiro. Omaanta tekiraata riyotakoperotziro kameetha noñaani opomeentsitzimotakari oetarikapaeni, ikijaneentayitanakirini atziripaeni roojatzi ipakaantanaawo raapatziyawitawo noñaani. ");
INSERT INTO cjoNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Kitocheemashiki opariyantapaakari paashini okithoki oshiyakaawentakiri atziri kemawitawakawori noñaani omaanta osheki ikenkithashiryaaperotakawo oetarikapaeni jeekatsiri jaka kipatsiki eejatzi riweshiryaawentashitakawo rowaagawo. Rootaki kaari ikenkithashiryaantawo nokantawitariri. Tee raapatziyana kameetha. ");
INSERT INTO cjoNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Kipatsipatha kameethari opariyantapaakari paashinipaeni okithoki oshiyakaawentakiri atziri kemaperotawakirori noñaani raaperotawakiro kameetha okaatzi okantziri. Raapatziyaperotanakawo. Raapatziyakaanakari paashinipaeni atziri oshekiperotanaki iroñaaka iyemijantzinkaritepaeni. Apaanipaeni raapatziyakaakari 30 atziri, paashinipaeni raapatziyakaakari 60, eejatzi paashinipaeni raapatziyakaakari 100. Rootaki ikantakinari. ");
INSERT INTO cjoNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Eejatzi paashini roshiyakaawentakina riraga Jesoshi, ikantzi: —Aritaki ikantari Tajorentsi ipinkathariwenantzi, reentsitetari atziripaeni. Ikimitakari pankitzirori okithoki teriiko. Riyoshiiwitakawo ipankitakiro kameethari okithoki. ");
INSERT INTO cjoNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ikantaka tsiteniriki imaanaki, eejatzi ratziritepaeni. Ikantaka ipokapaaki kijapaakiriri ramakiro okithoki oshiyawitawori teriiko omaanta kaari owaetawo. Ipankitapaakiniri janta rowanekinta, itsipataapaakiro teriiko. Roojatzi riyaatantanaa ithonkanakirowa ipankitanakiniri. ");
INSERT INTO cjoNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Okanta oshookanaki teriiko, okithokitanaki. Eejatzi oshookitanaka roori oshiyawitawori teriiko. Ari ojatzinkanakawo. ");
INSERT INTO cjoNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Iñaawakiro ratziritepaeni oshookanaki, roojatzi riyaatashitantanakari ashitawori irinta, ikantapaakiri: “Tema otsiyakotanaki okithokipaeni rooperori pipankitakiri janta powaneki. Omaanta ¿iitakakya oshookantateetanakari oshiyawitawori teriiko?” ");
INSERT INTO cjoNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ikantawakiri: “Rirotakirika pankitakirori kijanari”. Roojatzi ikantapaakiri: “¿Pikowakima niyaate iroñaaka nothokakitero oshiyawitawori teriiko?” ");
INSERT INTO cjoNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ikantanakiri: “Eero. Aririka pithokawitakyaawo ari pithokakotakiro roori teriikopero”. ");
INSERT INTO cjoNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ari okaantawakaata. Otsipatawakyaawoota oshooki. Iinjakya aminawakiroota ojampatawakiita owiitantyaawori. Roojatzikya nokanteeyemini: “Pithokero oshiyaawitawori teriiko, otayaata janta paamariki. Eekiro pimpaetanakiro powiitanakiro teriikopero. Pikempoyeenawo janta nokempoyaapiintzironta”. Rootaki roshiyakaawentakinari riraga Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Eejatzi paashini roshiyakaawenteeyakinawoni riraga Jesoshi, ikantzi: —Aritaki ikanta Tajorentsi ipinkathariwenantzi, roshiyawitakawo okithoki moshitaaja ipankiitziri owantsiki. ");
INSERT INTO cjoNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Okaatzini okithoki naawita omaanta oshookanakirika, antawotanaki. Anaakotanakiro paashinipaeni pankirentsi aritaki raampeyantayitakyaawoni tsimeripaeni jenokiweripaeni eejatzi ari imaashitantakyaawo. Kimitaka iroka iroñaaka eenitatsi apaanipaeni aapatziyanari ipinkathatziri Tajorentsi. Omaanta eekiro, eekiro ayotakaeri paashinipaeni raapatziyari rirori roojatzi iinja ari roshekitero aapatziyanari. ");
INSERT INTO cjoNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Eejatzi paashini roshiyakaawentanari, ikantzi: —Aritaki ikantari riraga Tajorentsi reewawenantzi eekiro eekiro riyoteeri maawaeni ikowakaakiriri. Roshiyakawo tsinani owetsikiro paa. Aakiro osheki opane teriiko, eejatzi otsipataakiro eechonkiini tapiyakaawori eejatzi eechonkiini iñaa. Roojatzi otapiyantanakya maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Aritaki ikantapiintatyaani roshiyakaawentapiinteeyakinirini maawaeni piyotawentakariri. Tee riyotaaperoneentziri kameetha iñaani, inta roshiyakaawentashitanari iñaani. ");
INSERT INTO cjoNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Imonkaatakiro rojankinatzitakarini paerani kamanantzirorini iñaani Tajorentsi: “Ikantzi riraga Tajorentsi: ‘Osheki noshiyakaawenteeyenirini atziripaeni nokamanteeyerini kaari riyoteeyawityaani rirori paerani, tema omanimotawitakari’ ”. ");
INSERT INTO cjoNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Roojatzi riwethatantanaari riraga Jesoshi piyotawentakariripaeni. Roojatzi riyaatantanaa rirori janta pankotsiki. Naaka maawaeni riyotaanewo noyaatanakiri. Nokantziri: —Piyotaaperotenawo poshiyakaawentakiniriri maawaeni piyotawentzimiri inkaaganki. ¿Oetaka oshiyakawori oshiyawitawori teriiko ipankiitziri teriikomashiki? ");
INSERT INTO cjoNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ikantanakina: —Arimache nopoñaanaka naaka jenokinta, natziriperotapaaki jaka kipatsikika. Naaka kimiwitawori ipankiitziri teriiko kameethari. Naapatziyakagaeyakarini atziripaeni raapatziyari Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Rowaga owantsitatsiri rootaki kantakotachari maawaeni kipatsika ajeekantarika. Rowaga teriikopero oshiyakaawentakiri maawaeni reentsite Tajorentsi. Omaanta oshiyawitawori teriiko oshiyakaawentakiri oyaatziriri iwinkatharite kamaari. ");
INSERT INTO cjoNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Riraga kijantatsiri pankitakirori oshiyawitawori teriiko rirotaki iwinkatharite kamaaripaeni. Rowaga owiitachari okithoki oshiyakaawentakiro kipatsi othonkaeyarika iinja, ikantakowenantyaariri Tajorentsi maawaeni atziri okaatzi rantziri. Riraga owiitzirori pankiwaerentsi okantakotziri ronampiripaeni Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ñaakiro, ipiyotakaantakiro oshiyawitawori teriiko itaantyaawori. Ari okimitya iinja areetapaakya nokantakowenantyaariri atziri okaatzi rantziri. ");
INSERT INTO cjoNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Notyaanteeyirini oshekini nonampiripaeni, ipiyotantyaaririni maawaeni kaari kameethatzinkari, eejatzi maawaeni antakayiriri paashini atziri kaari kameethatatsi, ");
INSERT INTO cjoNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","roojatzi nookakaanterini janta paamarikinta kaari tsiwakanitatsini. Osheki rowashironkagaeya janta, osheki ikemaatsityaawo paamari. ");
INSERT INTO cjoNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ikimoshiretakaaperoteri Pawa maawaeni kameethatzinkari, rajankaneki, irirapaeni ari ishipakiryaanaki ikimitanakyaari oorya; itsipatyaari rirori janta ipankoperokinta. Powakempitaperotawakyaaworika nokantakimirika ari paawakiro. ");
INSERT INTO cjoNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Aritaki ikantari riraga Tajorentsi ipinkathariwenantzi, reentsitetyaaririka atziripaeni. Ikimitakari shirampari ñaakiriri oshekini koriki imaneetziri kipatsikira. Osheki ikowakotakiri rootaki ikenkithashiryaantanakari: “Namananteroota kipatsi naakotantyaariri koriki”. Ityaawentakotaneeri jatanaki ipimanteeyakironi rashitayitarini ramanantakotantyaariri kipatsi ijeekakira koriki. Roojatzi ramananantakawo kipatsi. Ikimoshirewentanakiri osheki iyorikite riraga amanantakirorira. ");
INSERT INTO cjoNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Eejatzi ikantari riraga Tajorentsi reewawenantzi, reentsitetari kowatsiri raapatziyaari. Irintakya ikimitakari kowatsiri ramanantero poreryaanikitatsiri mapi kitamaari, pinaperotachari. ");
INSERT INTO cjoNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Iñaawakiro apaani okameethaperotaki, opinaperotaka. Ikowaperotakiro, rootaki ipimanantawori maawaeni tzimimotziriri raantariri koriki. Roojatzi ithonkakiri iyorikite ramananantakawori rowaga poreryaanikitatsiri mapi kitamaari, pinaperotachari. ");
INSERT INTO cjoNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Rapiitakiro riraga Jesoshi roshiyakaawentakinari tsika ikantari Tajorentsi reewawenante, ikantakina: —Aririka reewawenante riraga Tajorentsi, ari ikimitari shiryaatatsiri, rowiinkakiro ishiryaamento niyankyaani inkaareki roojatzi inoshikakotakiri raaki osheki shima inashitzinkaripaeni rotetakiri pitotsikira. ");
INSERT INTO cjoNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ojamanitanaki aririka riyeekitanaki pitotsikira roojatzi ipokanta othapyaakiini. Riyoyaawaetapaaki kameethatatsiri rotetakiri kantziriki. Riraga kaari kameethatatsiri rookayitakirini. ");
INSERT INTO cjoNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Aritaki okimiteeya iinja aririka nopokae jaka kipatsikika notyaanterikya nonampiripaeni, ipokapaaki jaka jaawikika riyoyaayitapaakirini ikaatzi kameethatzinkari rajankaneki, omaanta riraga kaari kameethatatsi rajankaneki, rinashitapaakyaari rirori ");
INSERT INTO cjoNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","rookaeyirini janta paamarikinta kaari tsiwakanitatsini. Ari riraakoeyaani eejatzi ratsikaekitya antawaete rirori: ikemaatsiteeyaawoni katsiri. ");
INSERT INTO cjoNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","¿Pikemaperotakiroma nokantakimiri? Nokanteeyakirini: —Jee, nokemakimi. ");
INSERT INTO cjoNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Roojatzi ikanteeyanani: —Aririka ikemijantena riraga iyotaantzirori Iwaperite Tajorentsi, riyotanakiro osheki. Tema iroñaaka riyotziro maawaeni rojankinateetzirini paerani, eejatzi raapatziyanarika, riyotziro owakiratatsiri niyoteeriri iroñaaka. Riyotanakiro tsikarika ikantari riraga Tajorentsi reewawenantzi. Okimitaka, riyotziri koetyeemotziriri ratziritepaeni irintapaeni ashaagantachari kameethari, roojatzi ipantariri apaanipaeni itaworitatsiri rowaagawo eejatzi apaanipaeni owakiratatsiri rowaagawo, oetarika koetyeemotariri. Eejatzi okimitaka iroñaaka eerori, kameetha piyotagaeri paashinipaeni itakaantaworini Iwaperiteki Tajorentsi eejatzi piyoteetyaari owakirari niyotaakimirika iroñaaka. ");
INSERT INTO cjoNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ari okaatapaaki roshiyakaawentakinari riraga Jesoshi, thonkapaaka, roojatzi riyaatantanaa. ");
INSERT INTO cjoNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Iroñaaka ipiyanaa riraga Jesoshi janta iipatsiteki ipoñaakanta. Noyaateeyanakirini naaka. Roojatzi riyotaantapaakari janta pankotsiki ipiyotantapiintarira joriiyopaeni. Ari rotsikanateeyanakarini maawaeni kemawakiriri, ikanteeyanakini: —¿Iitakakya iyotaakiriri riyothanitantakari? ¿Ninkakya matakaakiririka itajonkantzi? ");
INSERT INTO cjoNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Tema rirotaki itomini riraga wetsikirori jeekamentotsipaeni. Paminerotya rinirowa Mariiya. Pamineritya rirentzipaeni Jantyaako, Josee, Shimo eejatzi Joorashi. ");
INSERT INTO cjoNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Eejatzi akaateeyakironi ritsiropaeni jaka. ¿Tsika opoñaaka maawaeni iroka riyothanitantari? ");
INSERT INTO cjoNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Rootaki itheenkantakariri riraga Jesoshi, ikantzimatziri, rootaki ikanantakariri irira: —Atziripaeni iñeeririka paashinijatzi kamanantzirori Iwaperite Tajorentsi kameetha raapatziyaperotawakyaari. Riroma rirorika jeekariko inampiki ikamanantawityaaworika Iwaperite Tajorentsi eero ikowaperotzi raapatziyaperotyaari, inta itheenkiri rirori. ");
INSERT INTO cjoNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Osheki itheenkaeyakirini ikaateeyini ijeeki. Tee raapatziyaperoeyarini rootaki kaari osheki itajonkananta janta. ");
INSERT INTO cjoNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Apaani kitejiri ikemakotawakiri Jesoshi riraga Erooreshi. Tema irira rirotaki pinkathariwentziriri maawaeni karireeyajatzi iroñaaka. ");
INSERT INTO cjoNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ikemakotantawakariri, ikanteeyanakirini ronampiripaeni: “Aamaaka rirotaki Jesoshitatsiri riraga Jowa kaawoshitakotziriri Tajorentsi. Nowamaakaantawitakari omaanta aamaaka piriintarika añagae eejatzi, rootaki imatantakawori itajonkantapae iroñaaka”. ");
INSERT INTO cjoNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Chapinki riraga Erooreshi raapithatakiri rirentzi Jiripi iina, oetachari Eroriiyashi. Roojatzi ikanantakari riraga Jowa kaawoshitakotantatsiri Tajorentsi: —Tee okameethatzi okaatzi pantakiri. Rootaki raakaanantanakariri Jowa romonkyaakaantakiri omonkyaagamentotsiki. Roojatzi roojotakaantakiri karenathaki. ");
INSERT INTO cjoNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Chapinki ikowawitaka rowamaakaanterimi, omaanta ithaawantakari atziripaeni. Osheki raapatziyeeyakarini Jowa, tema ikenkithashiryaakotziri rirotaki kamanantzirori iñaani Tajorentsi rootaki ikenkithashiryaantanakari riraga Erooreshi: “Aririka nowamaakaantakiri ari ikijakowentakyaari atziripaeni”. Rootaki ithaawantakari rowamaakaanterimi chapinki. ");
INSERT INTO cjoNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Roojatzi omonkaatantaka kitejitatsiri paerani ikoñaatantapaakari riraga Erooreshi. Ipiyotawentari oshekini inampijatzi ikimoshirewentziri, ishinkitawaeta. Eejatzi okantaka opirantakotziri ishinto Eroriiyashi, osheki iñaawenaperotakawo, ");
INSERT INTO cjoNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","rootaki ikanantakawori: —Oetarika pikowakotenari, aritaki nopakimiro. Riyotzi Tajorentsi, eero namatawitzimi. Roojatzi iyaatashitantanakawori ojampitantawori iniro. ");
INSERT INTO cjoNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Okantawakiro ishinto: —Pikanteri rowamaakaanteri riraga Jowa. Roojatzi okanantakariri roori: —Nokowaki powamaakaanteri riraga Jowa, pipakotenawo piratoki iitoni, iyotantyaari nana kyaaryo kamaperotaki. ");
INSERT INTO cjoNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Roojatzi rowashiretantanaka rirori tee ikowawita rowamaakaanterimi omaanta inkaaganki ikemaeyawakirini maawaeni atziripaeni okaatzi ikantakiri. Tekatsi ikantaneeya roepiyaneero. ");
INSERT INTO cjoNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Rootaki ithatyaakaanantakariri iitoki riraga Jowa. ");
INSERT INTO cjoNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Roojatzi ramanteetakawo iitoni thatyaaka. Aawakiro, roojatzi aantanakanawori iniro. ");
INSERT INTO cjoNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ikantaka riraga riyotaanewoni roojatzi ipokantapaaka raanakiro iwatha ikitatakiro. Roojatzi riyaatashitantanakari riraga Jesoshi ikamantapaakiri: —Rowamagaetakirirakya Jova. ");
INSERT INTO cjoNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ikemantawakari rirori kamaki irira, roojatzi riyaatantanaka apaniroeni janta tekatsinta atziri. Itsipateeyanakinani. Itenteeyanakinani, rootaki nokinantakoeyanakarini pitotsi. Omaanta ikemakotakiri oshekini atziri, ipoñeeyanakani nampitsikipaeni, ikinanaki onomateeteki iñaa, royaatakina. ");
INSERT INTO cjoNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Roojatzi naatakoeyantapaakani, notonkagaeyanakini kipatsiki. Eejatzi noñaapaakiri oshekini oyaakiriri Jesoshi. Osheki retakoshiryaapaakari irira maawaeni, retsiyatakoeyakirini mantsiyatzinkaripaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Tsiteniityaaki oorya. Nokaateeyakirini paashini riyotaanewo Jesoshi, nokanteeyawitakarini: —Pamine, tekatsi atziri ipanko jaka, rooteentsi otsitenite. Potyaanteri atziripaeni riyaateeyini pankotsikipaeni ramananteeta royaari. ");
INSERT INTO cjoNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ikantawakina: —Eero. ¿Iitaka ratsipetashitantyaari riyaate? Piperi eerori royaari. ");
INSERT INTO cjoNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Nokantanakiri: —O, tekatsi noperiri. Paminetya sha, tee oshekitzi paa okaatzi apawakooni. Eejatzi mereto ikaatzi apite. ");
INSERT INTO cjoNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ikantawakina: —Pamakinawo maawaeni eejatzi mereto. Roojatzi nopantakari. ");
INSERT INTO cjoNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ari ikanteeyanakirini maawaeni: —Pijeeki jaawiki katawomashiki. Jeekaeyanakini. Roojatzi raantakawo paa eejatzi mereto. Raminanaki jenokinta, ikantanakiri Ashitariri: —Ariwee, Pawa, pipakinawo iroka nowanawo noyaari. Ari ikagaakiro paapaeni, shimapaeni, ipaeyakinarini maawaeni. Eekiro nopanakiri paashinipaeni atziri. Roojatzi nowaeyakawoni maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ari rowaeyakawoni maawaeni piyotawentakariripaeni, reshitanakiro owanawontsi. Roojatzi nopiyotayiteeroni tzimagaantapaentsiri niyeekitakiro kantzirikira okaatzi 12. ");
INSERT INTO cjoNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Naamaashita ikaateeyakini riraga owaeyakaworini shirampari 5.000, eejatzi tsinanipaeni eejatzi eentsipaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Roojatzi rotyaanteeyakinani riraga Jesoshi, ikanteeyakinani: —Niyotaanewopaeni, potetanakya pitotsiki, peewatena intatsikeronta. Roojatzi eejatzi rotyaantakiri maawaeni piyotawentakariri, ikantakiri rirori: —Piyaaterapa janta pipankokipaeni. —Jee, ari. ");
INSERT INTO cjoNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Roojatzi itonkaantanaka tonkaariki apaniroeni, ikenkithatakaeri Ashitariri. Otsitenitantanaka, eeniro ijeeki apaniroeni janta. ");
INSERT INTO cjoNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Nokanteeyanakani nokinakoeyanakini niyankyaani inkaareki. Roojatzi antawo omaetonkaaki, eejatzi oepiyapiyatakotakina antawo tampyaa. ");
INSERT INTO cjoNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Okantaka rootzimateentsi okitejite, noñagaatziiri Jesoshi ranashaatapaawo iñaa. Tee itsitsiyi. Eejatzi tee niyotawaeri. ");
INSERT INTO cjoNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Tema rominthaagapaakina, nokaemaeyantanakani: —¡Eeeee! ¡Kaakitaki peyariwee! Osheki nothaawantaperotawakari. ");
INSERT INTO cjoNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Omaanta ikanteeyapaakinani: —Naakakya pokatsiri, piweshiryaawentawakina, eero pithaawantashitana. ");
INSERT INTO cjoNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Roojatzi ikanantanakari Peetero: —Eerokarika Nowinkatharite pikaemena nanashaatyaata naari iñaaki, niyaatashitemiita pikatziyakaga eerori. ");
INSERT INTO cjoNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ari ikantakiri: —Pipokanaki. Roojatzi imitaanaki inkaareki, ranashaatantawitanakawo, riyaatemi janta Jesoshiki. ");
INSERT INTO cjoNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Omaanta roojatzi ikenkithashiryaanakiro tampyaa, eejatzi ithaawanaki, itsitsiyimawitanaka. Ikaemanaki: —Nowinkatharite, paawaena. ");
INSERT INTO cjoNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Roojatzi rakotashitawakiri, rakathawakotawaeri. Ikantanakiri: —Eechonkiini paapatziyana. ¿Iitaka kaari pameentaperotantana? ");
INSERT INTO cjoNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Roojatzi rotetantapaa pitotsiki, notsipateeyanaarini, roojatzi kaatanee tampyaa. ");
INSERT INTO cjoNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Osheki nopinkatheeyanakirini, nokanteeyanakirini: —Kyaaryootaki, eeroka Itomi Tajorentsipero. ");
INSERT INTO cjoNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Roojatzi nomontyaanteeyanaawoni, naatakoeyapaani intatsikeronta. Tema nareeteeyapaakani janta Jenejareeteki. ");
INSERT INTO cjoNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ikantaka jeekayitatsirini riyotawaerira areetapaa Jesoshi roojatzi ikamantawakaanteeyanakani maawaeni ikaateeyinira ijeekaeyini. Ramaeyakirini maawaeni mantsiyatzinkaripaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Royiikiiyakarini ipampitziteeyakirini imaatha. Ikantaka roojatzi ipampitziteeyantakarini imaatha opatziyaakikira. Etsiyatakoeyaneeni maawaeni okaatzi owawijaakotzitakiriri imaatha. ");
INSERT INTO cjoNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Paashini kitejiri ipokashitapaakiri riraga Jesoshi apaanipaeni warijeeyo eejatzi iyotaantzirori Iwaperite Tajorentsi. Ipoñeeyakani Jerojareeki, ikantapaakiri: ");
INSERT INTO cjoNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—Tema aakaeyakini joriiyo. Ameteeyakawoni rootzimateentsirika oyaa itakyaawo akiwero ako, roojatzi owantanakya. Tema tee akimitari kaari yotziri Tajorentsi rootaki riyotaakaerini itakaantaworini paerani. ¿Iitakakya kaari imonkaatantawo piyotaanewopaeni? Tee okameethatzi rowashitya, tekiraata ikiwawakota. ");
INSERT INTO cjoNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ikantawakiri: —¿Iitakakya kaari pimonkaatantawo eeroripaeni ikaminaawitzimirira Tajorentsi? Osheki pimonkaatashitakawo ikantashitayitarini itakaantaworinipaeni rootaki kaari paapatziyaperotantawo ikaminaawitzimirira. ");
INSERT INTO cjoNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Tema ikantziri Moeseeshini: “Pipinkathateri piri eejatzi piniro”. Eejatzi ikantzi: “Riraga Tajorentsi ikantakotziri akawaantetziriri ashitariri eejatzi riniro: ‘Okameethatzi rowamagaeteri’ ”. ");
INSERT INTO cjoNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Omaanta eerokapaeni pikanteeyakirini atziri: “Pimatero pikanteri ashitzimiripaeni: ‘Eero nomatziro namitakotzimi, nopemi koriki tzimimowitanarika namitakotantemirimi, irika nashi koriki: tema nokashiyakaatziiri Tajorentsi noperi’ ”. ");
INSERT INTO cjoNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ñaakiro, pantashiteeyakawoni eerori pikowakaeyakarini, tee panteeyironi ikowawitari rirori. Pookaeyanakironi Iwaperite Tajorentsi panantyaawori okimitaka ranteeyakirini pichariniitenipaeni paerani. Tee pishinetziri atziri ramitakotziri ashitariri eejatzi riniro. ");
INSERT INTO cjoNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Amatawitantaniripaeni! Poshiyakaawaetashita paapatziyakari rirori, omaanta tee paapatziyari. Kyaaryo ikenkithatakotziteeyakimirini paerani Iseeyashi. Iroka rojankinatzitakarini: ");
INSERT INTO cjoNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ikantzi Tajorentsi: “Irika atzirika ikantashiteeyakinani ipaanteki: ‘Nopinkathatzimi’, omaanta rajankanekira tee raapatziyaperotana, okimitzimotakina inteena ijeekaeyakini. ");
INSERT INTO cjoNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ratsipetashitakawo ipiyotawentashitana, tee riyotaantziro nokaminaantariri, inta riyotaantashitawo ikantayitzirini ichariniitenipaeni paerani”. ");
INSERT INTO cjoNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Roojatzi ikaemantakari riraga Jesoshi piyotawentariripaeni. Ikaemanakiri ikanteeyawakirini: —Pikemaperoeyenani, piyotawakiro nokamantemiri: ");
INSERT INTO cjoNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","okaatzi powayitarini, tee iñaakotzimiro Tajorentsi owaariperotero pishire. Omaantakya okaatzi piñaawaetziri kaariperotatsiri eejatzi okaatzi pikenkithashiryaayitarini rootaki owaariperotzirori pishire. ");
INSERT INTO cjoNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Nokantanaka niyaatashiiyakirini riraga Jesoshi, naakapaeni riyotaanewo, nokanteeyapaakirini: —¿Piyotakima eeroka ikijantakimiro warijeeyopaeni pikantakiriri inkaaganki? ");
INSERT INTO cjoNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Rakanakina: —Okimitaka atziri inothokero maawaeni kaari ipankitzi, arimache iinja rowashironkayeri riraga Pawa jenokinta maawaeni atziri kaari reentsitetari. ");
INSERT INTO cjoNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Eero pikenkithashiryaakotapiintawo ikantziri riroripaeni. Tee ikoyi riyotero ikowakiri rirori. Ikimitakari kaari kokichaatatsi. Noshiyakaawentemiri: rakathateririka kaari kokichaatatsi paashini kaari kokichaatatsi, eenitatsirika omoo janta, tema aritaki ipariyeeyakini irira apite omooki. Okimiwitaka iroka, riraga warijeeyopaeni riyotaakiri paashini atziri kimitariri kaari kokichaatatsi. Tema tee ikoyi riyoteri oetarika ikowakaakiriri Tajorentsi. Tema kimitaka kaari kokichaatatsi, tee riyotziri rirori. Rootaki iinja irira rowashironkaantyaariri. ");
INSERT INTO cjoNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ikantziri riraga Peetero: —Tee nokemimi. Piyoteenawo oetaka okantaperotziri: “Oetarika oyaari, tekatsi okantero owaariperotero ashire. Omaanta oetarika akenkithashiryaari, rootaki owaariperoteeni”. ");
INSERT INTO cjoNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ikantawakiri: —Eejatzi eeroka, ¿tema pikemaperotana? ");
INSERT INTO cjoNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Tema piyotzi oetarika oyaari iyaatzi asheetoki roojatzi ashitanteeyaawo? Tekatsi okantziro ashire. ");
INSERT INTO cjoNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Maawaeni pikenkithashiryaari opoña pajankaneki rootaki piñaawaetantawori. Piñaawaeterorika kaari kameethatatsi tema rootaki owaariperotzirori pishire. Omaanta owaariperotziro pishire okaatzi piñaawaetayitzirini pipaanteki kaari kameethatatsi eejatzi okaatzi pikenkithashiryaayitarini. Rooma pajankaneki tee pikameethatzi. ");
INSERT INTO cjoNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Rooma piyotziro tee pikameethatzirika pajankaneki ari pantziro kaari kameethatatsiri, powamaantzi, pishirontzimotawo tsinani kaari piina, paapithatziri paashini atziri iina, maenari piñaathatawo tsinani kaari payi, pikoshitzi, pitheeya, pikantzimatziri paashini atziri. ");
INSERT INTO cjoNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Rootaki eeroka powaariperotantawori. Omaanta teerika pikiwawakota rootentsirika poya, tekatsi okantero pishire. Eero ikijantzimiro Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Roojatzi jatanaki rirori Jesoshi, naaka, maawaeni. Riyaatakaanakina riraga Jesoshi janta Tziiroki eejatzi Shirooki. ");
INSERT INTO cjoNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Opokashitapaakiri janta kanaanajato, rowaga kaari joriiyotatsi. Okantapaakiri: —Nowinkatharite, rooma eeroka ichariniiteni jewatatsirini riraga Iraviiri. Nokowaki pineshironkatena, eejatzi nishintyo pineshironkatero. Ikyaantapaakawo kamaari, shiyashiyataka. ");
INSERT INTO cjoNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Omaanta imaeritanaki, tee rakawakiro. Nokantawitari naari: —Pikantero iyaateeta, atama oñaashirenkakae. Tema osheki okaemakaemataki. ");
INSERT INTO cjoNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Roojatzi ikantzi: —Rootaki rotyaanantakinari Pawa, apatziro nowawijaakoteri nojoriiyotzinkaritepaeni. Rirotaki kimitariri owishapaeni kaari ishenteetzi. ");
INSERT INTO cjoNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Omaanta otziwerowashitapaakari, apiitakiri okantakiri: —Nowinkatharite, pineshironkatena. ");
INSERT INTO cjoNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ikantawakiro, roshiyakaawentakiro: —Tee okameethatzi aapithateri atomi owanawontsi apantyaariri otsitzite. Eeroka kaari joriiyotatsi. ¿Iitaka noneshironkatantemiri? ");
INSERT INTO cjoNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Tee okantzimoneentanakyaawo ikantawitakaworira, inta okantziri: —Kyaaryo, Nowinkatharite, kameetha iroka pikantanarika. Omaanta, riraga otsitzite rowawo opetokeeriki pariyayitatsirini jaawiki royaarika ashitariri rotsitzite. ");
INSERT INTO cjoNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ikantawakiro: —Tsinani, kameetha paapatziyaperotakina. Aritaki nomatakimiro pikowakotakinarika. Aripaete awijakotanee ishinto. ");
INSERT INTO cjoNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Roojatzi riyaatantanaa riraga Jesoshi, eejatzi maawaeni nokaateeyaneerini. Ikinakaanakina riraga Jesoshi janta othapyaakiini inkaare janta Karireeyaki. Itonkaakaanakina tonkaariki, ijeekakaapaakina janta. ");
INSERT INTO cjoNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ipokashiteeyakirini osheki atziri ramakiri osheki mantsiyari: aashetawitachari, kamampowaakiwitachari, majontziwitacharipaeni, thatyaaponthowitacharipaeni, eejatzi paashinipaeni mantsiyawitachari roojeekaeyakirini iitzikeroki rirori. Retsiyatakoeyakirini maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Roojatzi rotsikanatantanakari atziri iñaakirira aashetawitacharini anashitaa kameetha, riraga kaari kokichaawitachani kokichaate, majontziwitachari ñaawaetanee, kaari shewawitachani rako shewatanaa eejatzi paashinipaeni mantsiyari etsiyatakotee. Ari rotsikanateeyakarini tee riyotzi oeta ikanteeyanakirini roojatzi iñaaperoeyantanakarini riraga Tajorentsi. Ikanteeyanakini: —Tema ikameethaperotaki Tajorentsi riraga pinkathariwentziriri maawaeni joriiyopaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Roojatzi ikaemaeyantakinani riraga Jesoshi naakapaeni maawaeni riyotaanewo. Ikanteeyakinani: —Osheki netakoeyakarini maawaeni piyotawentanari, tema okaataki kitejiri 3 itsipateeyakinani jaka. Tekatsi roya. Tasheyamoonthataki. Tee nokoyi notyaantashiteeyaari inampiki tekirarika rowa. Rooma notyaantashiteeyaririka, ari ishipetatanaki awotsiki. Eero imatziro rareeta inampiki. ");
INSERT INTO cjoNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Nokantapaakiri: —Pamine, tekatsi atziri ipanko jaka. ¿Tsika ayenirika owanawontsi aperiri? Oshekini ikaateeyiniroña. ");
INSERT INTO cjoNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ikantawakina: —¿Tsika okaatzika owanawontsi jeekaentsiri? Nokantanakiri: —Okaataki 7 paa, eejatzi mereto apaanipaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Roojatzi ikanantawakariri riraga piyotawentariri: —Pijeekaeyini maawaeni katawomashiki. ");
INSERT INTO cjoNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Jeekaeyanakini. Roojatzi raantakawo paa eejatzi mereto. Ikantziri ashitariri: —Ariwee Pawa, eenitatsi noyaari. Roojatzi ikagaantakawo paa eejatzi mereto. Ipakinawo eejatzi maawaeni riyotaanewo. Naawakiro, noshirinkakiniri rirori piyotawentakariripaeni. Itajonkakiniri oshekitanaki paa, roshekitanaki eejatzi mereto. ");
INSERT INTO cjoNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nowaeyakawoni, kemaeyanakinani maawaeni. Roojatzi nopiyoteeyakironi tzimagaantapaentsiri niyeekiteero kantzirikira, okaatzi 7. ");
INSERT INTO cjoNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Tee ayoperotzi tsika ikaatzi maawaeni owaenchari. Owaka osheki tsinani eejatzi eentsipaeni. Omaanta aamaashitya 4.000 shirampari owaenchari. ");
INSERT INTO cjoNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Roojatzi rotyaanantaari, ikantakiri: —Piyaateerakya iroñaaka pipankokipaeni. Roojatzi riyaatantanaa. Noteteeyantanakani pitotsiki, montyaakotanakina janta Makataaki. ");
INSERT INTO cjoNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ikanta ipokashiteeyapaakirini warijeeyopaeni eejatzi saroseeyopaeni ikowaeyawitakani rantakaantyaaririmi riraga Jesoshi kaari kameethatatsi ikijantanakyaaririmi. Ikantawitapaakari: —Nokowaki noñeemimi pitajonkante, niyotantanakyaari kyaaryo pipoñaaka jenokinta. ");
INSERT INTO cjoNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Rakanakiri rirori: —Pamine, aririka itsiteniityaanaki oorya piñaakirorika okiraawayeetyaanaki, tema pikantanaki: “Paminetya jenoki kiraawayeetyaaki. Eero opariyi inkani”. ");
INSERT INTO cjoNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Omaanta, amaetyaakakya piñaakirorika aaninkaki, ari pikantanaki: “Rooteentsi opariye inkani. Paminetya aaninkakinta”. Amatawitantaniri, piyotakoeyakironi opariyerika inkani. Omaanta tee piyotakotzimaetawo maawaeni okaatzi piñeeyawitakarini jaka kipatsikika. ");
INSERT INTO cjoNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Tee pikameethateeyini, osheki pitheenkakiri riraga Tajorentsi. Iroka tee okameethatzi. Pikowawita piñeena notajonkante, omaanta eero noñaayimiro. Apatziro iinja, piñaakironi roshiyakaawentakinarini paerani Jonaashini. Rootaki ikantakiriri riraga Jesoshi, roojatzi riyaatantanaa. ");
INSERT INTO cjoNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Rareetakaeyapaakinani intatsikeronta inkaare irira. Tema nopeyakotanakiro paa: tee naanakiro. ");
INSERT INTO cjoNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ikanteeyakinani rirori: —Paamayaawowa rowaga tapiyakaawori paa rashi warijeeyopaeni eejatzi rashi saroseeyopaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Roojatzi nokantawakaeyantanakani: —¿Iitaka ikanantakaeri: “Paamayaawowa tapiyakaawori paa rashi warijeeyopaeni eejatzi rashi saroseeyopaeni”? Rooma ikanantakaeri teera amaneero paa. Aamashitya rootakirika ikanantakaeri. ");
INSERT INTO cjoNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ikantaka riyotakotakina oetarika nokantawakaakari, rootaki ikanantanakinari: —¿Tekirama pameentaperotana? ¿Iitaka pikanantari: “Tekatsi paa”? ");
INSERT INTO cjoNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Tekirama piyotana? ¿Tema pikenkithashiryaawakiro chapinki okaatakotawitakagaanki paa apawakooni, omaanta ikemaeyakawoni osheki atziri rowantakawori? Ikaatakiranki 5.000 shirampari okaatzi tzimagaantapaentsiri 12 kantziriki yeekitapaatsiri. —Jee. Kyaaryo. ");
INSERT INTO cjoNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Tema pikenkithashiryaawakiro kaatatsiriranki paa 7, eejatzi nowakaakari 4.000 shirampari omaanta ikemaeyakawoni maawaeni eejatzi tzimagaantapaentsiri poteteero kantziriki okaatzi yeekitatsiri 7? —Kyaaritaamakya. ");
INSERT INTO cjoNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ikantanakina: —¿Iitaka kaari piyotantawakawo nokanantawitakimiri: “Paamayawowa tapiyakaawori paa rashi riraga warijeeyopaeni eejatzi riraga saroseeyopaeni? Tee ro nokantakoperote rowaga paa pipeyakotanakiri inkaaganki”. ");
INSERT INTO cjoNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Roojatzi niyotakotantakawo oeta okantakotziri ikenkithatakotakiri tee ro ikenkithatakoperotzi tapiyakawori paa omaanta ikenkithatakotziri maawaeni riyotantayitzirini warijeeyopaeni eejatzi saroseeyopaeni. Tema riyotaashitakari kaari rooperotatsiri. Tee ikoyi riraga Jesoshi ramatawitantenawo riroripaeni okaatzi riyotaantayitzirini. ");
INSERT INTO cjoNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Roojatzi niyaateeyantanakani intatsikeronta Joriraani paashiniki Sesareeya rowaga nampitsi riwetsikakaantapaakiri Jiripi riraga pinkathari. Ari nokinakitzi janta. Roojatzi ikanteeyanakinani riraga Jesoshi: —Nopoñaaka naaka jenokinta natziriperotapaaki jaka jaawikika. ¿Oetaka ikenkithashiryaakoeyanarini naaka atziripaeni? ¿Tsikama iitakinaka naaka? ");
INSERT INTO cjoNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Nokantawakiri: —Ikantzi apaanipaeni: “Jesoshi rirotaki Jowani, riraga kaawoshitakowitariri Tajorentsi, piriintaa”. Ikantzi paashinipaeni: “Irira rirotaki Iriiyashini, riraga kamanantzirorini iñaani Tajorentsi, añagaatsiri”. Ikantziri paashinipaeni: “Jesoshi rirotaki Jeremiiyashini, añagaatsiri”. Eejatzi paashinipaeni ikantzi: “Rirotaki paashini kamanantzirorini iñaani Tajorentsi, piriintaachari”. ");
INSERT INTO cjoNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Roojatzi ikanteeyantanakinani: —Eerokapaeni, ¿oetaka pikenkithashiryaakoeyanarini naaka? ");
INSERT INTO cjoNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Riraga Shimo, iiteetziri eejatzi Peetero ikantawakiri: —Eerokataki riraga Rotyaantanewo Tajorentsi naamaakari. Eeroka Itomi Tajorentsi, riraga Añaaperotatsiri. ");
INSERT INTO cjoNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ikantziri: —Piweshiryaawaetya, Shimo itomi Jonaashi. Riyotaakimiro iroka riraga Tajorentsi. Tee riro yoteemironi atziri. ");
INSERT INTO cjoNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Noetzimi Peetero, tema okantziri piwaero apaanteki aari: mapi. Tema paapatziyana naaka riraga Rotyaantanewo Tajorentsi. Rootaki nokowakaantakimiri piyoteeri atziri iroka niyotagaeyakimirini eerori. Paapatziyakaakari osheki atziri. Rowashironkaawitakimirika iwinkatharite maawaeni kamaari omaanta eero imatziro ranaakotemi. ");
INSERT INTO cjoNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Niyoteemi oetarika ranteeyerini atziri riyaatanteeyaari Tajorentsikinta jenokinta. Eerorika paapatziyakagaeyaarini atziri jaka kipatsikika, eero riyaatzi jenokinta; omaanta maawaeni atziri paapatziyakagaeyakinarini rirotaki jeekaeyatsini iinja janta jenokinta. ");
INSERT INTO cjoNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Roojatzi ikanteeyantakinani: —Eerowa pathawayitawo pikamanantawaetzi, pikante: “Jesoshi rirotaki Rotyaantanewo Tajorentsi, riraga Owawijaakotantatsini”. ");
INSERT INTO cjoNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Aripaete ritanakawo ikamanteeyanani ikame. Ikanteeyanani: —Rooteentsi niyaate janta Jerojareeki. Osheki rowashironkayena janta riraga aataperoteenchari, riraga jewawentayitziririni ñaanakowenantatsiri Tajorentsi, eejatzi riraga iyotaantayitzirorini Iwaperite Tajorentsi, maawaeni. Aritaki okantyaari rowamagaetena, omaanta okaate kitejiri 3, ari nopiriintanee nañagae. ");
INSERT INTO cjoNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Tee inimotziri Peetero okaatzi ikantakiriri. Rootaki raantanakariri eekitziroeni jaga ikantapaakiri: —Nowinkatharite, ¡tee okameethatzi pikantakirika! ¡Eero powashironka! ¡Eero pikami! ");
INSERT INTO cjoNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Roojatzi ipithokashitantanakari rirori, ikantanakiri: —¿Iitaka pikanantakari? Pikimitakari Jatanaashi, riraga iwinkatharite kamaaripaeni. ¿Iitaka pookakaantanawori? Pikantakirika pikenkithashiryaashitakawo ikenkithashiryaari atziri; tee piyotziro ikowakaakinari Tajorentsi. Eero pookakaanawo ikowakaakinari Pawa. Nomonkaateniriita. ");
INSERT INTO cjoNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Roojatzi ikanteeyanani: —Pikowaperotzirika paapatziyaperotena, okameethatzi pikyaaryoowentenawo oetarika nokowakaakimiri naari, eero pantashitawo pikowakaari eerori. Pipomeentsiwentena: aririka rowashironkaawitemi, omaanta eekiro piyaatanakitye paapatziyaperotanakina. Tema iroka kimitaka pinatanakitziiro piyoroshite. ");
INSERT INTO cjoNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Riraga kowawitachari ikaminthayaami ari rowashironkaantyaari iinja Tajorentsi, omaanta riraga kemaatsitawentenani, iñeenaroña janta Tajorentsikinta. ");
INSERT INTO cjoNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Omawitya pipiyotaperotawityaaworika osheki owaagawontsi jaka kipatsikika, omaanta pipeyakotakiririka Tajorentsi, eero piyaatzi jenokinta ijeekinta rirori. Tema patsipetashiteeyawitakawoni maawaeni pashiteeyawitakarini. Ñaakiro, tekatsi pikantya pipinateri Tajorentsi ijeekakaantemiri janta inampikinta. ");
INSERT INTO cjoNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nopoñaaka naari jenokinta, nokoñaatapaaki kipatsikika. Eejatzi niyaatawitaatya jenokinta. Tema eejatzi nopiyaate iinja jaka, notsipatapaakyaari nonampiripaeni, nopinkathariperotapaaki, nokimitapaakyaari Ashitanari. Roojatzi nokantakowenantapaakyaari maawaeni atziri okaatzi rantayitzirini. ");
INSERT INTO cjoNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Kyaaryo, iroka nokantzimirika, eenitatsi apaanipaeni iroñaaka pikaateeyakinika jaka, eerotzitarika pikami, ari piñaawaena nopinkathariperotapaaki. Rootaki ikantakinari Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ikanta itsipatakina naaka maawaeni riyotaanewo, nomaaki 6. Roojatzi rookanakina, raanakiri apatziro Peetero, Jantyaako eejatzi Jowa, riraga rirentzi Jantyaako, raanakiri janta antawoki tonkaari. ");
INSERT INTO cjoNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Roojatzi ishipakiriimotantanakari. Iñaawakiri ishipakiryaapootanaki ikimitanakari oorya, eejatzi iithaari okitamaaperotanakiroña. ");
INSERT INTO cjoNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Romapokapaakiri Moeseeshi, eejatzi Iriiyashi, rirotaki kamanantzirorini iñaani Tajorentsi paerani. Ikenkithatakaapaakiri Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Roojatzi riraga Peetero, ikantziri: —Nowinkatharite, kameethataki apokaeyakinika jaka noñaantakimiri. Pikowakirika, niwetsikemi pankoshintsi 3: apaani pashi, apaani rashi Moeseeshi, eejatzi paashini rashi Iriiyashi. ");
INSERT INTO cjoNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Eenirowa iñaawaetzi omapokapaaka menkori, otzikaapaakiri maawaeni, osheki oshipakiryaapaaki roori. Ari ijeekaki Tajorentsi menkoriki iñaawaetanaki, ikantzi: —Irika rirotaki notyomi nonintaperotanewo, osheki niweshiryaawentaperotakari. Pikemijanteri. ");
INSERT INTO cjoNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ikemantawakaworira riraga riyotaanewopaeni ikantziri rirori, ithaawantanakari osheki, itankimotapithatanakari. ");
INSERT INTO cjoNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Omaanta ipokashitapaakiri Jesoshi, ipampitapaakiri. Ikanteeyakirini: —Pikatziyanee, eero pithaawantari. ");
INSERT INTO cjoNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Roojatzi raminawitanaa tekatsitanee, apaniroeni Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Roojatzi roerinkantanaa. Ari niyanki awotsi ikantakiri: —Eerowa pikamantakotzitana piñaakinaka iroñaaka. Omaanta naaka riraga atziriperotapaentsiri nokamawitakya arika eejatzi nañagae, aripaeterakya pikamanteeyanakirini paashinipaeni atziri okaatzika piñaawakiri iroñaaka. ");
INSERT INTO cjoNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Roojatzi ikanteeyantakarini riroripaeni: —Riraga iyotaantzirori Iwaperite Tajorentsi ikanteeyini: “Rirotaki itapaakyaawoni ipoke Iriiyashini, eentsikiro rimpaetapaaki ipokapaaki rirori Rotyaantanewo Tajorentsi”. ¿Iitakakya ikanantawaetakari iroka? ");
INSERT INTO cjoNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Rakanakiri: —Kyaaryo okaatzi ikantakirini: “Rirotaki itapaakyaawoni ipoke riraga Iriiyashi, rowameethateeyapaakirini maawaeni”. ");
INSERT INTO cjoNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Omaanta nokamantemi: kyaaryo ipokapaentzi Iriiyashini omaanta tee riyotawakiri atziripaeni, osheki rowashironkashiteeyawakarini. Eejatzi ikimitawakina naari iinja, osheki rowashironkaeyawakinani. ");
INSERT INTO cjoNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Roojatzi niyotakoperoeyantanakawoni ikenkithatakotatziiri Jowani, riraga kaawoshitakotziriri Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Roojatzi rareeteeyantapaanani rookaeyanakinanira chapinki. Osheki atziri oyaakiriri. Roojatzi ipokashitapaakiri Jesoshi apaani shirampari. Rotziwerowashitapaakari, ikantapaakiri: ");
INSERT INTO cjoNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Nowinkatharite, pineshironkateri notyomi. Osheki ikamanapiintzi, osheki rashironkaapiinta. Ipariyapiintzi itaapiinta paamarikira, pokiree; eejatzi ipiinkaatapiintzi iñaakira, chomoog. ");
INSERT INTO cjoNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Naawitanakanari piyotaanewo, nokantawitapaakari: “Powawijaakotenari notyomi”, omaanta tee imatziri. ");
INSERT INTO cjoNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Rakanakiri rirori Jesoshi: —¡Atziri theenkantatsiri! ¿Tekiraatama piyotzi? ¿Tsika okaateka notsipatemi piyotantyaari imatakaantemirori Tajorentsi petsiyatakotante? Osheki pitheenkakina. Roojatzi ikantawakiri ashitariri: —Pamakinari jaka pitomi. ");
INSERT INTO cjoNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Roojatzi ikantakiri Jesoshi kamaari: —Eero poñaashirenkiri rirori, inta pookaneeri. Roojatzi rawijakotantanaa riraga eentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Roojatzi nojampitantapaakari: —¿Iitakakya kaari nomatantawo nowawijaakoteri naari? ");
INSERT INTO cjoNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ikanteeyanakinani: —Ñaakiro, okantakaakimira tee paapatziyaperotawo okaatzi nokantawitakimiri rootaki kaari pimatantawo powawijaakoteri. Kyaaryo, aririkami paapatziyaperotakyaawo nokantzimiri, tema aritaki pimatakiro tonkaari pikanterorika: “Pishirinke janta”. Roojatzi oshirinkantanakya janta. Ñaakiro, tekatsi pomeentsitzimotemini pameentaperotyaaworika nokantzimiri. ");
INSERT INTO cjoNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Pookantyaariri kamaari kimitakaaririka aakiriri eentsika okameethatzi pityaawo pamaneri osheki Tajorentsi eejatzi pitzitakotyaari irira. Roojatzi itharyaanaka rirori Jesoshi, itsipatanakina naaka maawaeni riyotaanewo. ");
INSERT INTO cjoNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","23","Apaani kitejiri janta Karireeyaki, rapiitaana riraga Jesoshi ikanteeyaanani naaka maawaeni riyotaanewo, ikantzi: —Nopoñaanaka naari janta jenokinta natziriperotapaaki jaka. Rooteentsi ragaetena, rowamagaetena naari. Okaate kitejiri 3 ipiriintaneena Pawa nañagae. Nokemantawakari, nowashireeyanakani. Roojatzi notharyaanteeyanakani. ");
INSERT INTO cjoNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Roojatzi riyaatakagaeyantanakinani riraga Jesoshi janta Kaperinawooki, areeteeyapaakinani. Eeniro ijeeki janta riraga piyotziriri koriki rowameethatanteetyaawori Tajorentsipanko. Ikanta ipokashitapaakiri Peetero riroripaeni, ikantapaakiri: —¿Ipinatapiintzirima riraga iyoteemiri rowameethatanteetyaawori Tajorentsipanko? ");
INSERT INTO cjoNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Rakanakiri rirori: —Jee, ipinatziro. Roojatzi ipiyanaka pankotsiki ijeekinta Jesoshi. Ipiyanaka, ikyaapaaki, ikowawitaka rirori Peetero rojampiterimi aririka ipakiri koriki rowameethatanteetyaawori Tajorentsipanko. Omaanta riyotaki riraga Jesoshi ikenkithashiryaakari Peetero rootaki rathawaakotantanakariri, ikantanakiri: —Shimo, ¿oetaka pikenkithashiryaari eerori? Riraga jewawenantatsiri, ¿tsika itzimika ikowakotapiintziri iyorikite? ¿Ikowakotzirima inampijatzipero? ¿Riroma ikowakotziri paashinijatzitatsiripaeni atziri? ");
INSERT INTO cjoNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ikantawakiri: —Riroma ikowakotziri paashinijatzipaeninta atziri. Roojatzi ikantanakiri rirori: —Kyaaryo, tekatsi ikowakotziri inampijatzipero. Eejatzi okimitaka naari, tekatsi ikowakotena Pawa, tema nosheninkatakari. ");
INSERT INTO cjoNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Omaanta tee nokoyi eeniro ikijawentenari riraga kempoyiiriri koriki. Piyaate iroñaaka pakachaatakite inkaarekinta. Aririka paaki shima, poerikeri, paminawaanteteri ipaanteki, aritaki piñiitakiri koriki. Roojatzi paaneeri kempoyiiririkinta koriki, pipapaakiri. Rirotaki apinatakari aaka. ");
INSERT INTO cjoNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ojamanineentanentsi nopokashitapaakiri riraga Jesoshi, naaka maawaeni riyotaanewopaeni, nokantapaakiri: —Maawaeni naaka piyotaanewo, nokowaki pikantena ¿ninkama jewaperoterinika atziripaeni janta ipinkathariperotzinta Tajorentsi? ");
INSERT INTO cjoNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Roojatzi ikaemantakari eentsi, ikatziyakaakari niyanki, ");
INSERT INTO cjoNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ikanteeyawakinani: —Kyaaryo nokamantemiri pikenkithashiryagaeyaari pameentari Tajorentsi, eejatzi pipakaero pajagaaga. Nokowaki pikimitakotyaari irika eentsika, paapatziyaperotena. Eerorika paapatziyaperotana, eero pimatziro piyaate janta ipinkatharitzinta Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Irika eentsika tee ikantakaaperota, tee itheenkana inta raapatziyaperotana. Maawaeni kimitakotyaarini irira rirotaki tsipateeyeenarini neewawenantzi. ");
INSERT INTO cjoNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Aririka pineshironkateri aapatziyanari, kimitaririka irika eentsi, eejatzi pikimitzitakina naari: pinintashiretakina. ");
INSERT INTO cjoNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Omaanta aririka pantakayeri eentsi aapatziyanari kaari kameethatatsi, ari rowashironkaaperotakimi eerori Tajorentsi. Okameethawitami pityaawomi pikamemi eero pantakaantarikya kaari kameethatatsi aapatziyanari, rootaki kaari nowashironkaantemimi. ");
INSERT INTO cjoNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ikantziri eejatzi: —Netakotari maawaeni atziri. Kyaaryo, tee ikowawita ranteromi kaari kameethatatsi, omaanta rantakagaetakiri. Arimache rowashironkaaperotakirikya Tajorentsi iinja irintapaeni antakaakiriri. ");
INSERT INTO cjoNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Noshiyakaawentemiro antakayemirorika pako kaari kameethatatsi pichekero, pookero. Eejatzi pikimitzityaawo roori piitzi antakayemirorika kaari kameethatatsi. Piyaatyookakitashiteeya janta jenokinta rooma otzimawityaarika apite pako eejatzi apite piitzi iyaatakaashitzimikari janta paamariki kaari tsiwakanitatsini. ");
INSERT INTO cjoNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Eejatzi poki, aririka aminakayemiro kaari inimotziri Tajorentsi pikithokireero, pookero. Kashetaakini pikyaapae janta jenokinta. Rooma otzimaawityaarika apite poki iyaatakaashiteemikari paamariki kaari tsiwakanitatsini. ");
INSERT INTO cjoNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Eejatzi ikantzi riraga Jesoshi: —Eero pimanintziri kimitakariri irika eentsika aapatziyanari. Eenitatsi ronampiri Tajorentsi kempoyaakowentapiinteeyakiririni maawaeni riroripaeni. Eejatzi eerori pikimityaari, pikantani pikempoyaawenteri eentsipaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Nopoñaanaka naaka jenokinta, natziritapaaki. Nopokashiteeyakirini jatatsinimi paamariki kaari tsiwakanitatsini, nowawijaakoteeyerini. ");
INSERT INTO cjoNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Noshiyakaawentemiro eejatzi. Eenitatsirika ashitachari 100 rowishate, ipeyakyaarika apaani, ¿tsika ikantanakyaarika? Tema ari rookanakiri riraga jeekagaantaneentsiri 99 rowishate keshiiki jataki iroñaaka ikowakowataateri riraga peyeenchari. ");
INSERT INTO cjoNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Omaanta iñagaeririka eejatzi, ¿riroma riweshiryaawentyaari riraga piyoteenchari kaari peyachani? Kaari. Omaanta riweshiryaawentyaari riraga peyawiteenchari. ");
INSERT INTO cjoNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ikimitakaga riraga ashitariri rowishate tee ikoyi ipeya apaani, eejatzi ikimita riraga Pawa jeekatsiri jenokinta, tee ikowakaaneentziri ipeya apaani atziri aapatziyanari. ");
INSERT INTO cjoNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Eejatzi ikantakina Jesoshi: —Aririka rantzimotakimiro piyemijantzinkarite kaari kameethatatsi okameethatzi piyaatashiteri pikenkithatakayeri apaniroeni. Omaanta eero pikijiri; eero pikamantziri paashinipaeni. Aririka ikemijantemi inetheemi eeroka eejatzi Tajorentsi pipeyakoteniri okaatzi rantzimotakimiri roojatzi pineshironkatanteeyaari, aritaki pineshironkatawakagaeya paakameethatawakagaeya, eejatzi ineshironkatzityaari rirori. ");
INSERT INTO cjoNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Omaanta eerorika ikemijantawakimi, apawo piyaatashiteri. Iroñaaka paaneeri paashini apaani eerorika apite piyemijantzinkarite. Paaneeri ikenkithatakayeri, riyotantyaari rirori kyaaryo pikantziri, eejatzi riyotantyaari kyaaryo pikowaki pineshironkateri. ");
INSERT INTO cjoNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Eerorika ikemijantawakimi, pipiyoteri maawaeni piyemijantzinkarite jaga, pikanteri maawaeni ikantawakayaari rirori. Eerorika ikemijanteeyawakirini okaatzi ikantawitakariri, rootaki piyotantyaari ikimitakari kaari yotziri Tajorentsi, eejatzi paashini antzirori kaari kameethatatsi. Iroñaaka pikimitakayaari kaari yotziri Tajorentsi, riraga antzirori kaari kameethatatsi, eero pikantakotziri aapatziyariri Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Kyaaryootaki iroka nokantemiri: eeroka, riraga aapatziyaperotanari, oetarika pithañaari kipatsiki, ari ithañaakyaawo Pawa jenokinta; eejatzi oetarika pishinetziriri kameethatatsiri eejatzi ikanteri Tajorentsi ishinetziri. Pikanteririka eenitatsi kaari kameethatatsi rantziri, eejatzi ikanteri rirori. Pikanteririka tee añiiro kaari kameethatatsi rantziri, eejatzi ikimitya riraga Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Eejatzi nokantemi, aririka eerokapaeni pikanteri Pawa jenokinta ramitakotemi oetarikapaeni, omawitya pikaaterika apite, aritaki ikemijantakimi, ramitakotakimi. ");
INSERT INTO cjoNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Tsikarika pipiyotawentena aririka apite aapatziyanari, eerorika 3, aririka osheki, eejatzi naari nokaatemi. Eejatzi ari iyotakayemi Ishire Tajorentsi oetarika kameetha pikanteriri Tajorentsi. Rootaki ikantakiri Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ikantaka Peetero, riyaatashitakiri Jesoshi, rojampitapaakiri, ikantakiri: —Nowinkatharite, ¿tsika okaateka noneshironkatapiinteri riraga kijapiintanari nopeyakopiinteniri? ¿Arima okaate 7 nopeyakopiinteniri? ");
INSERT INTO cjoNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ikantawakiri: —Pikanteetatyeeyaani pineshironkateri, pipeyakoteniri rantziri. Eero pipiyatakotari kijapiintzimiri. ");
INSERT INTO cjoNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Noshiyakaawentemiro tsika ikanta Tajorentsi ineshironkatziri aapatziyariri. Ikimitakari pinkathari rireewiteetziri ronampiripaeni. Tema iroñaaka ikowakiri irira ipinateeri ireewitakiriri. ");
INSERT INTO cjoNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ikaemakiri apaani ireewitziriri oshekipero koriki. Ikantawitawaari: “Pipinatawaena pireewitanaga”. ");
INSERT INTO cjoNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ikantawakiri: “Tekatsi naye nopinatemiri”. Roojatzi ikanantakari paashini ronampiripaeni: “Paanakiri irika pipimanteri, eejatzi iina, itomipaeni, rowaagawo, maawaeni, roojatzi ipinatanteena koriki rireewitaanaga”. ");
INSERT INTO cjoNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ikanta riraga ireewitziriri rotziwerowashitanakari ipinkathatanakiri, ikantanakiri: “Eero pipimantana poyaawentawakyaata aritaki nopinateemi”. ");
INSERT INTO cjoNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Roojatzi osheki retakotatari iwaatorote, ishinetziri riyowanee, ikantawakiri: “Aritaama, monkaataka pireewitana, eero nokowakotaneemi”. ");
INSERT INTO cjoNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ikanta ireewitantawitacharira riyaawitanaaga. Ari janta niyanki awotsi itonkiyotawakari ireewitziriri rirori. Tee rireewiperotziri osheki: inta eechonkiini. Roojatzi roerikakentsitantakari ikentsiki, ikantakiri: “Intsipaete pipinatena pireewitana”. ");
INSERT INTO cjoNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Roojatzi rotziwerowashitantawitakari, ikantawitakari: “Poyaakowentawakyaata, aritaki nopinateemi iinja maawaeni nireewitzimiri”. ");
INSERT INTO cjoNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Omaanta tee ikoyi ineshironkateri eejatzi royaakowentya omaanta romonkyaagakaantashitakari ikantakiri: “Pipinateenarika maawaeni pireewitanaga, roojatzi noemishitowakaananteemi”. ");
INSERT INTO cjoNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ikantaka iñaakowenantakariri paashinipaeni ratzirite riraga iwaatorote, okantzimoneentanakari roojatzi riyaatashitantanakari iwaatorote, ikantapaakiri: “Noñaateekiri iriranki petakotaariranki eerori. Teera retakotantateeta rirorita inta romonkyaagakaantateekiri ireewitawitariri rirori eechonkiini”. ");
INSERT INTO cjoNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Roojatzi ikaemakaanantakari riraga iwaatorote, ikantawakiri: “Ñaakiro, pikantakina inkaaganki: ‘Eero pipimantana’, rootaki noneshironkaperotantakimiri, nokanantawitakimiri: ‘Iroñaaka eero pipinataana pireewiwitanaga’. Omaanta eeroka, tee pikameethatzi. Tee pineshironkatziri riraga ireewitawitzimiri eerori eechonkiini. ");
INSERT INTO cjoNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Tema okameethawita pineshironkaterimi eerori ireewitzimiri eechonkiini. Nokimitakimira naari noneshironkatakimi: tee nowashironkaemi”. ");
INSERT INTO cjoNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Roojatzi ikijantaperotanaka iwaatorote romonkyaagakaantakiri, ikantakiri: “Nokowaki iroñaaka pipinatena maawaeni pireewitanaga; pipinatenarika maawaeni roojatzi noemishitowakaananteemi”. ");
INSERT INTO cjoNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ikaatakaapaakawo Jesoshi, roojatzi ikanantanaka: —Okimitaka iroka noshiyakaawenteeyakinirini, eejatzi ikimitemi iinja eerori Ashitanari jeekatsiri jenokinta, eerorika pineshironkatziri atziri, eerorika kyaaryoopero pipeyakotziniri oetarikapaeni rantzimotzimiri, ari rowashironkaaperotakimi Pawa iinja, eero ipeyakotzimiro eerori pantani. ");
INSERT INTO cjoNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ithonkantanakawori riyotaantzi riraga Jesoshi, ishitowakaanakina Karireeyaki, jatanakina iroñaaka janta intatsikeronta Joriraani janta okaakintawo Joreeya. ");
INSERT INTO cjoNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Eejatzi royaatanakiri oshekini paashinipaeni atziri. Eejatzi rirori retsiyatakotawakiri maawaeni mantsiyatzinkari. ");
INSERT INTO cjoNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Eejatzi ipokashitapaakiri warijeeyopaeni. Ikowawitaka ikompitakayaarimi, rootaki ikanantawitapaakariri: —¿Tsikama okantzika Iwaperite Tajorentsi? ¿Okameethatzima ninkarika kowashitachari rookero iina? ");
INSERT INTO cjoNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ikantawakiri: —Tema piñaanatapiintawitawo okantziri Iwaperite Tajorentsi. Paerani riwetsikakiri Tajorentsi shirampari eejatzi tsinani. ");
INSERT INTO cjoNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","6","Eejatzi ikantzi: “Aririka rayero shirampari iina, rinteenaryaanakiri ashitariri eejatzi riniro, omaanta tee nokowakayiri rookero iina, eero. Inta nokowaki kijokiro rowanakiro irowa. Rinashitawitani paerani shirampari eejatzi tsinani, omaanta aririka raaki iina, kimitanaa apaani ikantaka, kijokiro rowawakaanakya”. Iñaakiri Tajorentsi apaani ikantaka; eero iroñaaka rookakagaeri atziri. ");
INSERT INTO cjoNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Roojatzi rojampitanakiri, ikantakiri: —¿Iitakakya ishinetantariri riraga Moeseeshi shirampari rookero iina? Tema ikamineeri shiramparipaeni: “Tekirarika pookiro piina pityaawo pojankinateniro paperi pikantero iroñaaka ookawakaatyeeya. Roojatzi pimatanteeyawo pookaero piina”. ");
INSERT INTO cjoNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ikantawakiri: —Tema pikijoshiretakitzi pajankaneki rootaki ishinetantakimiri. Omaanta tee ikoyiro Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nokantemi naari, aririka pookero piina roojatzi paye paashini, aritaki panteero kaari kameethatatsi. Tema pishirontzimotakawo piina paashini tsinani. Apatziro aririka oshirontyaari paashini shirampari, okameethawita pookeromi. ");
INSERT INTO cjoNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Eejatzi nokanteeyanakirini naaka riyotaanewopaeni: —¿Kyaaryootaki pikantakinari? ¿Aririka naaki noena eero nomatziro nookero? Okameethatzi eero nayi noena. ");
INSERT INTO cjoNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ikantawakina: —Kyaaryo iroka pikantziri. Jee, apaanipaeni atziri tekatsirika iina imaterorika riweshiryaanakya, omaanta kaari maawaeni atziri. ");
INSERT INTO cjoNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Eenitatsi apaanipaeni kaari matachani rayi iina, tema ashi royiro ikoñaatantakari ipiryaakitzi, rootaki kaari imatantawo itsipatantyaawori tsinani, rootaki kaari raanta iina. Eenitatsi apaanipaeni rayiteetziri iyatharekitho, rootaki kaari raanta iina. Eenitatsi paashini kaari kowatsini raye. Ikowakiri ijeekashitya ikyaaryoowenteniri Tajorentsi oetarikapaeni ikowakiri ranteniriri. Eerorika pikoyi pishirontyaawo tsinani tekatsirika piina, omaanta pimatero piweshiryaanakya, aritaki kameetha eero payi piina. ");
INSERT INTO cjoNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Eejatzi ramaetakiniri riraga Jesoshi eentsipaeni. Ikantapaakiri ashitariri: —Pineeronkawakiri neentsitepaeni, pamaneri Tajorentsi ineshironkatenari. Nokantawiteeyawakarini: —Eero pashiiriiri Awinkatharite. ");
INSERT INTO cjoNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Omaanta ikantana irira: —Eero pikatziyakaari. Pishinetenari ipokashitenaata eentsipaeni. Riyotzi irira rameentana. Maawaeni aapatziyanari, ikimityaari irika eentsipaeni rameentana, tema ari reentsitetakyaari Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Roojatzi ipampitantawakari iitokira maawaeni, ikantziri Tajorentsi: —Pawa, nokowaki pineshironkateri irika eentsipaenika. Roojatzi riyaatantanaka riraga Jesoshi, itsipateeyanaanani maawaeni riyotaanewo. ");
INSERT INTO cjoNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Paashini kitejiri ipokashitapaakiri shirampari, ikantapaakiri: —Iyotaantatsiri kameethari. Pikamantena, ¿iitaka kameethatatsiri nanteri iroñaaka naari jaka nojeekanteeyaripa janta jenokinta? Nokanteetapaatyeeyaani. ");
INSERT INTO cjoNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ikantawakiri: —¿Iitaka pikanantanari: “Kameethari”? Tekatsi kameethatzinkari, apatziro ikameethatzi Tajorentsi. Omaanta pikowakirika piyaate jenokinta, pantero maawaeni ikaminaakimiri Tajorentsi rojankinatakirini Moeseeshi. ");
INSERT INTO cjoNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Rakanakiri ikantanakiri: —¿Tsika okantyaaka nanteri? Ikantawakiri Jesoshi: —Eero powamaeri atziri, eero pishirontawo tsinani kaari payi, eero pikoshitzi, eero pitheeyakotari paashinipaeni, ");
INSERT INTO cjoNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","pipinkathateri piri eejatzi piniro. Pineshironkateri paashinipaeni atziri: pikimitaaga eerori osheki pineshironkata, ari pikimitzityaari paashinipaeni atziri pineshironkateri. ");
INSERT INTO cjoNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ikantanaki: —Nomonkaatakiro maawaeni iroka eenironi neentsitapaakini roojatzi iroñaaka. ¿Oetaka paashini nanteri? ");
INSERT INTO cjoNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Rakanakiri: —Pikowakirika pikameethaperotantaneeyaari pithotyeero maawaeni iroka, piyaate pipimantero maawaeni tzimimotzimiri, piperi owashironkaenkari, rootakirakya kaari pikenkithashiryaantaneeyawo pipiyotaneero powaagawo, inta pikenkithashiryaaneeyaari Tajorentsi, roojatzi pipiyashitanteena, thamerakya poyaataneena naari. ");
INSERT INTO cjoNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ikanta rirori ikemantawakari osheki rowashiretanaka. Riyotakotanaka osheki rowaagawo, tee ikowaki ipimantero. ");
INSERT INTO cjoNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Roojatzi ikanantanakina Jesoshi: —Kyaaryo nokantzi, osheki opomeentsitzimotari ashaagantzinkari ikowaki Tajorentsi ipinkathariwenante. ");
INSERT INTO cjoNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Napiitemiro noshiyakaawentemiro: riraga kameeyo opomeentsitzimotakari roshinthateri imooki kithapi. Rowanaaperotaka riraga ashaagantzinkari opomeentsitzimotaperotakari rirori ikowaki Tajorentsi ipinkathariwenteri. ");
INSERT INTO cjoNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Nokemaeyantawakaaworini ikantakinari Jesoshi, ari notsikanateeyanakarini. Roojatzi nojampitantanakari: —¿Ninkama awijakotatsinika? ");
INSERT INTO cjoNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Roojatzi ramineeyakinani maawaeni, ikanteeyakinani: —Riraga atziri eero imatziro rowawijaakotya apaniroeni, omaanta Tajorentsi aritaki imatakiro rowawijaakoteri atziri. Kaari imatawita atziri omaanta rirori imatziro oetarika pomeentsiwitachari. ");
INSERT INTO cjoNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ikantanakiri Peetero: —Pamine Nowinkatharite, nookaeyanakironi naaka maawaeni tzimimoteeyawitanarini, noyaateeyantanakimirini. ¿Oetaka nayeri iinja owinawo? ");
INSERT INTO cjoNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ikanteeyawakinani: —Kyaaryo iroka nokamanteeyemirini, “Nopoñaaka naaka jenokinta, natziriperotapaaki kipatsikika, Iinja ari otzimae owakirari kipatsi. Naaka nojeeki iinja janta nowinkatharimentoki, nopinkatharitaperote. Eejatzi eeroripaeni pitsipateeyenani pipinkathariteeyeni. Okaate 12 piwinkatharimentopaeni pijeekanteeyarini eerori. Pipinkathariwenteeyerini maawaeni joriiyopaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Maawaeni ikaatzi ookayitanakirorini ipankopaeni, rirentzipaeni, ritsiropaeni, iriripaeni, riniropaeni, reentsitepaeni, iinapaeni, iipatsitepaeni royaatantenari, eero ratsipetashiteeyawoni. Riraga Tajorentsi ari roepiyayiteenirini rookaeyawitanakarini. Rookanakirika apaani roepiyayiteenirini Tajorentsi osheki. Eejatzi ikanteetatyeeyaani itsipateeyenani janta rañaaperoeyapaeni jenokinta. ");
INSERT INTO cjoNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Eenitatsi iroñaaka osheki pinkatharitatsiri jaka kipatsiki, omaanta eero ipinkathariteeyini maawaeni janta jenokinta: rooma aamashitya apaanipaeni pinkatharitagaantatsini. Eejatzi eenitatsi iroñaaka osheki owashironkaenkaripaeni, omaanta iinja janta jenokinta ipinkatharitagaantapae rirori”. ");
INSERT INTO cjoNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Eekiro riyaatatyee ikamantziri riraga Jesoshi: —Noshiyakaawentemiro tsikarika ikanta Tajorentsi ipinkathariwenantzi. Ikimitakari ashitawori roowamashite. Riyaatanaki irira amaetyaaka janta nampitsiki ramineri owiitziniriri roowate. ");
INSERT INTO cjoNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Iñaapaakiri apaanipaeni kowatsiri rowiiteniri, ikantapaakiri: “Aririka pamitakotena iroñaaka, aririka itziroryaanaki oorya, aritaki nopinatakimi apaani koriki, riraga iitachari tenaaryo”. Ikantawakiri: “Ari kameetha”. Roojatzi ikanantakari: “Piyaate iroñaaka powiitenawo”. Roojatzi riyaatantanaka rowiitziro. ");
INSERT INTO cjoNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Roojatzi ijenokiityaantapaaka oorya, riyaatanaki janta ramineri owiitziniriri roowate. Iñaapaakitziiri janta apaanipaeni jeekashitachari kaari antawaetatsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ikantapaakiri: “¿Tee pikowaeyini eerori powiitena noowate? Aritaki nopinatakimi kameetha”. Rakanakiri: “Jee, aritaki nowiitakimiro”. Roojatzi riyaatantanaka rowiiteniri. ");
INSERT INTO cjoNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Tampatsika oorya riyaatanaki eejatzi janta ramine paashini owiitakoterini roowate. Ragaatzi paashini rotyaantakiri rantawaete. Eejatzi tsiteniiteni piyanaa raminaatzi paashini amitakoterini. Iñaakitzi apaanipaeni kaari owiitatsi; rotyaantakiri rantawaete eejatzi. ");
INSERT INTO cjoNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Tsiteniityaaperotanaki, riweyaantapanaatawo raminapanaatzi paashini, roojatzi iñaantapaaka jeekashitzinkari tekatsi rante. Roojatzi ikanantapaakari: “¿Iitaka pithotyaakotziri jaka, tekatsima pantawaero?” ");
INSERT INTO cjoNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Rakanakiri: “Tekatsi antawaetakaenani”. Roojatzi ikanantanakari: “Thame pamitakotena, powiitakotena noowate. Aritaki nopinatakimi kameetha”. Jatanaki. ");
INSERT INTO cjoNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Rootzimateentsi itziroriimate oorya, roojatzi ikanantanaka ashitawori roowamashite. Ikantakiri jewatakaantzirori antawaerontsi: “Pikaemeri antawaeteeyatsirini pipinateeyerini. Pitanakyaari pipinateri riraga impaetaperotapaentsiri rantawaetzi roojatzi pithonkanteeyaari pipinateri maawaeni iriranki roojatzi ikaatzi antawaeteentsiri amaetyaaka”. ");
INSERT INTO cjoNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Roojatzi ipokantapaaka riraga impaetapaentsiri rowiitziro. Eechonkiini rantawaetaki irirapaeni omaanta ipinatawakiri maawaeni apaani tenaaryo. ");
INSERT INTO cjoNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Roojatzikya ipokantapaaka rirori itakawori rantawaetapaaki amaetyaaka. Iitakaashiwitaka ari ipinataperoetakiri osheki omaanta ipinatawakiri tenaaryo eejatzi. ");
INSERT INTO cjoNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Iñaatziiri raawakirira iyorikite roojatzi ikiñaanikowenantanakariri owiitakaakiriri, ");
INSERT INTO cjoNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ikantanakiri: “¿Iitaka nomonkaatantakariri owakira pokapaentsiri rantawaetzi? Pipinatakina okaatzira pipinatakiriri rirori. Tema naaka nantawaetaki amaetyaaka roojatzi tsiteniiteni eejatzi osheki natsipetakari ijaawanka oorya. Okameethawita pipinaperotenami oshekyaajeeni koriki”. ");
INSERT INTO cjoNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ikantawakiri: “Niyompari, tee namatawitzimi; nopinaperotakimi kameetha. Eejatzi tema nokantakimi amaetyaaka: ‘Nopinatemi apaani tenaaryo’. Eejatzi pakakina: ‘Jee, aritaki, kameethataki’. ");
INSERT INTO cjoNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Irika piyorikiteka paanakiri, piyaate pipankoki. Nopantakariri irika impaetapaentsiri rantawaetzi ikaatzira nopakimiri eerori. Aritaki nokowakaawo naari rootaki nopantakariri. ");
INSERT INTO cjoNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Tema okameethatzi nopashitakari noorikite. ¿Iitaka kaari pikowakaantana noneshironkateri? Rootaki ikantakiriri riraga ashitawori roowamashite. ");
INSERT INTO cjoNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ñaakiro, riraga Tajorentsi iñaaperoeyakirini aapatziyakariri osheki ojarentsi ikameethataki; eejatzi iñaaperoeyakirini riraga aapatziyakariri iroñaaka ikameethatzi. Tema imonkaatawakaeyakani maawaeni, rowawijaakoeyakirini, omawitya raapatziyari osheki ojarentsi, rooma eechonkiinirika”. Rootaki ikantziri riraga Jesoshi, roojatzi itharyaakaanakina. ");
INSERT INTO cjoNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ikantaka Jesoshi itonkaakagaeyakinani janta Jerojareeki. Ari niyanki awotsi roojatzi riyoshiitanakina naakapaeni riyotaanewopero 12 ragaeyanakinani intyañaampiini. Ikamanteeyakinani: ");
INSERT INTO cjoNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Iroñaaka piyoteeyakini atonkagaeyatyeeni janta Jerojareeki. Nopoñaaka naaka jenokinta, natziriperotapaaki jaka, omaanta rooteentsi omonkaatya raanteetenari ragaeyenani jewawentayitziririni ñaanakowenantatsiri eejatzi iyotaantayitzirorini Iwaperite Tajorentsi. Ikanteeyenani: “Osheki tee pikameethaperotzi, rootaki pikamantyaari”. ");
INSERT INTO cjoNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Roojatzi raantena janta kaari yotziri Tajorentsi ikantapaakiri: “Irika Jesoshi payeri, powamaeri”. Ari ishirontawenteeyawakinani rirori. Ipajapajaatawakina, ikentakotakaantawakina inchapankeki ikanteetziri koroshi, roojatzi nokamantakya. Okaatapaakirika kitejiri 3 roojatzi ipiriinanteena Pawa añagaana eejatzi. Rootaki ikanteeyakinarini. ");
INSERT INTO cjoNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Roojatzi opokashitantapaakari riraga Jesoshi iina Sewereeyo. Otsipatapaakari otomi apite, iitachari Jantyaako eejatzi Jowa, riraga apite riyotaanewo, otziwerowashitapaakari, okantapaakiri: —Nokowaki pineshironkatena. ");
INSERT INTO cjoNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ikantawakiro: —¿Oetaka pikoyiri? Okantziri: —Aririka iinja pipinkatharitaperotapae nokowakaakiri apiteka notyomi itsipatemi: apaani jeekatsini pakoperoki, paashini pampateki. Ikaatemi itsipateeyemini pipinkathariteeyini. ");
INSERT INTO cjoNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Rakanakiro Jesoshi: —Tee piyotzi oetarika pikowakotanari. Pamine, rooteentsi nokemaatsityaawo osheki katsiri naari. Rooma patsipetashitakawo eerori teerika imatziro ikimitana naaka nokemaatsityaawoka osheki katsiri. Ikantanakiri otomipaeni: —Aritaki nomatakimiro naari. ");
INSERT INTO cjoNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Roojatzi ikanantakari: —Kyaaryo aritaki pikemaatsiteeyakyaawoni, omaanta naaka eero nomatziro nokantzimi ninkarika jeekimotenani iinja nakoperoki, nampateki; apatziro yotatsiri Pawa jeekatsiri jenokinta ninkarika ikashiyakayitakarini paerani jeekatsini. ");
INSERT INTO cjoNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Nokemaeyantakaworini naaka riyotaanewopaeni iroka ikantakiri roojatzi nokijanteeyanakarini riraga Jantyaako eejatzi Jowa. Nokijanteeyanakaririni ikowaeyawitakityaani ipinkathariteeyenimi. ");
INSERT INTO cjoNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Roojatzi ikaemanteeyakinani Jesoshi naakapaeni riyotaanewo, ikanteeyakinani: —Piyoteeyakini eeroka riraga iwinkatharitepaeni kaari yotziri Tajorentsi rameteeyawoni romperateeyarini isheninkapaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","27","Omaanta eerokapaeni eero pikimitakoeyarini. Eero pomperatanteeyani eerori. Pikowakirika peewawenante, pamitakoeyerini kameetha atziripaeni: petakotyaari, eero pomperatashiteeyarini. Panteniri kameetha maawaeni oetarika ikowakoeyemirini. ");
INSERT INTO cjoNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Pikimitakotena naaka. Tee ro nopokantyaari naaka jaka kipatsikika nomperatayitapaakimini, inta nopokantari jaka namitakoeyemini, noneshironkateeyemini, nokamawenteeyemini nopinawenanteeyemirorini kaari kameethatatsi pantziri eerokapaeni maawaeni pawijakotanteeyaari, eero rowashironkaanteemi Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Rookaeyakaanaanawoni Jesoshi nampitsi owaero Jerikoo. Ikineeyanakini janta awotsiki itonkaakaantyaariri Jerojareeki. Royaateeyakirini osheki atziri. ");
INSERT INTO cjoNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Eeniro ijeekaki jaga othapikira awotsi irira kaari kokichaatatsi ikaatzi apite. Ikamanteetakiri: —Kaakitaki Jesoshi. Roojatzi ikaemantawakari, ikantziri: —¡Pineshironkatena! ¡Rooma eeroka icharineeteni Iraviirini! ");
INSERT INTO cjoNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Roojatzi ikijathatakiri piyotaneenchari, ikanteeyawakirini: —¡Pimaerite! Eekiro ikaematziiri, ishintsithatakiri ikaemakiri: —Nowinkatharite, pineshironkatena. Rooma eeroka naamagaeyakarini, eerokataki icharineeteni Iraviirini. ");
INSERT INTO cjoNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ikatziyapaaka riraga Jesoshi, ikantapaakiri: —¿Oetaka pikoyiri namitakotemiri? ");
INSERT INTO cjoNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ikantawakiri: —Nowinkatharite, nokoyi pikokichaatakagaena. ");
INSERT INTO cjoNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Roojatzi ineshironkatapaakiri, ipampyaakitapaakiri rokikira. Kokichaatanee, roojatzi royaatantakari osheki riweshiryaawentanakari. ");
INSERT INTO cjoNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Rootzimatapaentsi nareetya Jerojareeki, ari nareetapaakyaawo Wetejajee jeekatsiri janta tonkaariki owaero Oriiwomashi. Roojatzi rotyaanantakari riraga Jesoshi apite riyotaanewo, ");
INSERT INTO cjoNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ikantakiri: —Thame peewate jaga nampitsiki, aririka piñaapaakiri wooro tsinani othatakotaka otsipatakari otomi ewonkiri poojoryaakotapaakiri. Pamakinari jaka. ");
INSERT INTO cjoNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Aririka ikanteetawakimi: “¿Iitaka poojoryaakotantawori?” pikanteri: “Ikowatziiro Awinkatharite”. Ari roepiyeemiri intsipaete. Roojatzi ikanantanakimi: “Paanakiniri”. ");
INSERT INTO cjoNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ranantakawori iroka, imonkaatziro rojankinatakotzitakaririni paerani kamanantzirorini iñaani Tajorentsi iitachari Jakariiyashi. Ikantzitakani: ");
INSERT INTO cjoNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Pikanteeyerini jeekaeyatsirini janta Jerojareeki: ‘Paamayari iinja Piwinkatharite, kaakitaki. Osheki ikameethaperotaki. Tee riyotzi ikantakaaperota, ikyaakotapaakyaari ewonkiri wooro’ ”. ");
INSERT INTO cjoNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Roojatzi riyaatanaki riyotaanewo apite iñaapaakitziiro wooro tsinani otsipatari otomi ewonkiri, roojoryaakotapaakiro, ramakiniri. ");
INSERT INTO cjoNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ramakiri apite. Nowankitakiniri imitzikaakira kithaarentsi, roojatzi ikyaakotantakari Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Osheki atziri kinantanakawori janta awotsiki iñaawakiri, eejatzi iñaaperoeyawakirini maawaeni: ishitashitaantakiri awotsiki imaathaapaeni ikinapaakirapa wooro. Paashinipaeni ichoonkayitakironi kompiroshi ishitashitakiri awotsiki ikinapaakinta wooro. ");
INSERT INTO cjoNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Osheki atziri jewateeyakiririni awotsikira. Osheki paashini impaeteentsiri eejatzi. Osheki ikimoshirewenteeyanakirini. Roojatzi ikaemaeyanakini, ikanteeyanakini: —¡Pamineri irika, rirotaki icharineeteni Iraviirini aamagaeyakarini! ¡Thame apinkathateeyerini! ¡Rotyaantakiri Awinkatharite! ¡Thame añaaperoeyerini! ¡Tema iñaaperotakiri riraga Tajorentsi, tema ikameethaperotzi! ");
INSERT INTO cjoNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Roojatzi rareetakaantapaakina Jerojareeki. Ikemakoeyawakirini maawaeni jerojareejatzi, rojampitawakagaeyanakani: —¿Ninkama irika pokapaentsirika? ");
INSERT INTO cjoNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Rakaeyapaakirini paashinipaeni pokaentsiri: —Rirotaki Jesoshi, riraga kamanantzirorini iñaani Tajorentsi jeekawitachari paerani Najareeteki, rowaga nampitsi janta Karireeyaki. ");
INSERT INTO cjoNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ikantaka Jesoshi ikyaakaapaakina janta Tajorentsipankoki. Iñaapaakitziiri janta inthomaenta osheki amanantatsiri eejatzi pimantatsiri, rootaki opoñaantanakari rookaeyapaakirini maawaeni irirapaeni. Tema rotatsinkitawaetapaakiri maawaeni imeejate riraga kaampiyawakaayitanaririni iyorikite. Eejatzi ikimitzitakari rirori pimantatsiri jamomo rotatsinkitayitapaakirini maawaeni imeejatepaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Roojatzi ikanteeyanakirini: —Okantzi Iwaperite Tajorentsi: “Ikantzi Tajorentsi: ‘Iroka Tajorentsipankoka okameethatzi pikenkithatakaapiinteeyenani, omaanta eerokapaeni pikoshitashiteeyakarini atziri pokaeyawitacharini jaka Tajorentsipankokika’ ”. Tee okameethatzi iroka panteeyakirini. ");
INSERT INTO cjoNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Eejatzi janta ipokashitapaakiri oshekini kaari kokichaatatsi, eejatzi kijopookitatsiripaeni. Retsiyatakoeyawakirini. ");
INSERT INTO cjoNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Riraga jewawentayitziririni ñaanakowenantatsiripaeni eejatzi riraga iyotaantayitzirorini Iwaperite Tajorentsi iñaakirira okaatzi rantakiri. Eejatzi ikemakiri osheki eentsipaeni ikaemaeyakini: —¡Osheki okameethaperotaki rantayitakirini Jesoshi! ¡Thame añaaperoeyerini! ¡Tema rirotaki icharineeteni Iraviirini! Omaanta tee inimotanakiri riraga jewawentayitziririni ñaanakowenantatsiripaeni iroka iñaakiri eejatzi ikemakiri. Rootaki ikijantaperotanakari osheki. ");
INSERT INTO cjoNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Roojatzi ipokashiiyantapaakarini Jesoshi, ikantapaakiri: —¿Pikemaeyakirini inkaaganki ikantakimiri riraga eentsipaeni? Tee okameethatzi iroka ikantakimirika. Tee okameethatzi ipinkathateeyemini. Rakanakiri: —Jee, nokemaeyakirini. Tekirama piñaanatziro Iwaperite Tajorentsi kantakotzirori: “Iñaaperoeyerini eentsipaeni owawijaakotantatsiri iinja”. ");
INSERT INTO cjoNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Roojatzi riyaateeyakaantanakinani janta Wetaaniyaki. Ari nomaapaaki. ");
INSERT INTO cjoNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Okitejitanaki ipiyeeyakaanakinani janta Jerojareeki. Ari niyanki awotsi itasheyapaaki Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Iñaapaakiro awotsinampiki chochoki iitachari iyeera, oshiyawitawo potooki. Ikowawitapaaka ithotemi okithoki, omaanta tekatsi; apatziro iyotashitaka oshi. Teera iñaapaakiro okithoki roojatzi ikanantanakawo: —Eero iroñaaka papiitero pikithokite ithotanteemiri atziri. Okantaka rowaga iyeera jampiyashitanaki intsipaete. ");
INSERT INTO cjoNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Inkaamani aririka rawijakagaeyanakinawoni rowaga iyeera, noñaawakirowa ojampishitanaki intsipaete roojatzi nokenkithashiryaakoeyanakironi. Rojampiteetakiri riraga Jesoshi: —¿Tsika okantanakaka ojampirinkashitantanakari intsipaete rowaga iyeera? ");
INSERT INTO cjoNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ikantawakina: —Kyaaryo, aririka eekiro piyaatatye pameentaperotyaari Tajorentsi, aritaki imatakaakimiro pantero kimitaworika piñaakirika iroñaaka. Eejatzi pikanteririka Tajorentsi: “Poshirinkero iroka tonkaari janta inkaarekinta, aritaki imatakaakimiro”. ");
INSERT INTO cjoNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Pameentaperotyaaririka, aririka pamaneri, aritaki imatakaakimiro oetarikapaeni pikowakoteriri. Roojatzi itharyaakagaeyanakinani Jerojareeki. ");
INSERT INTO cjoNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ikantaka Jesoshi ipiyakagaeyakinani Tajorentsipankoki, ikyaaki riyotaantapaaki. Roojatzi ipokashitantapaakariri riraga jewawentayitziririni ñaanakowenantatsiri eejatzi riraga aataperoteenchari, ikantapaakiri: —¿Ninkama otyaantaperotzimirika piyotaantariri joriiyopaeni eejatzi petsiyatakoeyantakaririni? ¿Ninkama otyaantzimirika pookantapaakariri pimantatsiri chapinki? ");
INSERT INTO cjoNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ikantawakiri: —Eejatzi naari, nojampitemi apaani. Aririka pakawakina, aritaki nokamantanakimi ninkarika otyaantakinari. ");
INSERT INTO cjoNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Ninkama otyaantakiriri Jowa ikaawoshitakotantariri Tajorentsi joriiyopaeni? ¿Rirotakima Tajorentsi otyaantziriri? ¿Atzirima otyaantziriri? Roojatzi ikantathatawakagaeyantanakani: —Akanteririka: “Tajorentsi otyaantakiri”, ikantanakaekari: “¿Iitaka kaari paapatziyantarikya?” ");
INSERT INTO cjoNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Omaanta akantakiririka: “Atziri otyaantakiri”, ikijanakaekari atziripaeni. Tema maawaeni iitashitari Tajorentsi otyaantakiriri Jowa riyotaanantari. ");
INSERT INTO cjoNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Roojatzi ikantapaakiri: —Tee niyotzi ninkarika otyaantziriri. Rakanakiri rirori: —Eejatzi nokimitzitaka naari, eero nokamantzimi ninkarika otyaantakinari nanantawori piñaakotakinarika. ");
INSERT INTO cjoNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Eejatzi ikanteeyakirini riraga Jesoshi: —Noshiyakaawentemiri ashitachari itomi apite; ¿iitaka pikenkithashiryaakotakariri eeroka? Ikantakiri itawori ikoñaatzi: “Notyomi, piyaate iroñaaka pantawaete janta noowamashiteki”. ");
INSERT INTO cjoNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Rakanakiri, ikantawakiri: “Eerowa niyaatzi”. Ikantaka paata ikenkithashiryaanaa, roojatzi riyaatantaa rantawaetzi. ");
INSERT INTO cjoNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Eejatzi ikantziri paashini itomi: “Notyomi, piyaate iroñaaka, pantawaete janta noowamashiteki”. Ikantanakiri: “Ari, pawa, niyaate”. Omaanta tee riyaatzi. ");
INSERT INTO cjoNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ari, iroñaaka nojampitemi: ¿Ninka kemijantaperotziririka ashitariri ikowakaakiriri? Ikantakiri: —Irinta itakawori ikoñaatapaaki, jatatsiri rantawaetzi. Ikantakiri: —Kyaaryo iroka nokantemirika: ranaakoeyemini riraga piyotziriri koriki ipantyaariri oroomajatzi eejatzi rowaga tsinani ñaathapiinteeyawitaririni shirampari kaari oemi. Tema raapatziyakina rootaki imatantakawori Tajorentsi reewawentakiri rajankaneki. ");
INSERT INTO cjoNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Pamine, paerani ipokawitapaentaga riraga Jowani kaawoshitantatsiri jaga riyoteeyawitapaakimini tsika pikantya pijeekanteeyari kameetha; omaanta eerokapaeni tee pikowaeyini paapatziyeeyawakyaarini. Omaanta aapatziyeeyawakaririni riraga piyotziriri koriki ipantyaariri oroomajatzi eejatzi rowaga tsinani ñaathawitaririni shiramparipaeni kaari oemi. Piñeeyawitakarini raapatziyeeyakawoni okaatzi riyotaakiriri Jowa rootaki ikameethatantari. Omaanta eerokapaeni tee pikenkithashiryaaneenta, tee paapatziyimaetawakari Jowani. ");
INSERT INTO cjoNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Iroka paashini roshiyakaawenteeyakiniririni riraga jewateeyatsirini ñaanakowenantatsiri eejatzi riraga iyotaantayitzirorini Iwaperite Tajorentsi. Ikantakiri: —Pikemaeyawakinani paashini nokantemiri. Eenitatsi apaani pankitzirori roowamashite. Eejatzi rotantotakotakiro maawaeni othapiki. Eejatzi riwetsikashitakiro tsikarika rawishoowero oowa rowantyaawori owaaga. Riwetsikakiro eejatzi pankotsi jenokitatsiri, ijeekashitantyaawori aminawiritanteroni oowamashi. Roojatzi riraga ashitawori roowamashite ikantanakiri antawaetziniriripaeni: “Iroñaaka paminenawo noowamashite eejatzi pithamaetakotenawowa. Iinja pipashitena kashetani”. Rakaeyanakirini: “Jee, aritaki, nomatakimiro”. Roojatzi riyaatantanaka rirori paashiniki kipatsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ojamanitakotanaki roojatzi omonkaatantapaaka irakanaki oowapaeni. Roojatzi rotyaanantawitaka ronampiripaeni ashitawori roowate, ikantawitawakari: “Piyaate iroñaaka janta pikanteri riraga aminanawori noowamashite ipakaantawakina nashi naari”. Roojatzi riyaateeyawitanakani, areeteeyapaakani janta. ");
INSERT INTO cjoNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Iñaawakiririka riraga aminayitzirorini oowamashi, rompojawakiri apaani, tok; eejatzi paashini rowamaawakiri, shemi; omaanta paashini rompojantawakari mapiki, shemi. ");
INSERT INTO cjoNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ikanta riraga ashitawori roowamashite eekiro rotyaantanakitzi ronampiripaeni. Ikantaka aminirorira oowamashi ithonkawakiri, rowamaakiri ikimitaakirira paashini jewatapaentsiri. ");
INSERT INTO cjoNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Roojatzi ikenkithashiryaanaka ashitawori roowamashite ikantzi: “Iroñaaka notyaanteri notyomi. Aamaaka eero rowamaawakiri irira. Rirotaama ipinkathatawakiri”. Roojatzi rotyaanantawitanakari itomi. ");
INSERT INTO cjoNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ikantaka iñaawakirira roojatzi ikantawakaantanaka: “Kaakitakira riraga itomi ashitawori roowamashite. Aririka ikamaki paata ashitariri, rirotaki poyaateeyaarini iriri; tema rirotaki ashiteeyawoni. Iroñaaka thame owamaawakiri. Aakoteeroota aaka roowamashite”. ");
INSERT INTO cjoNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Roojatzi roerikawakiri shepik, raanakiri janta othapiki, rowamaakiri, shemi. ");
INSERT INTO cjoNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","¿Oetaka pikenkithashiryaari eeroka? ¿Ipokaerika ashitawori roowamashite tsika ikanteeyapaakirinika riraga antawaeteeyawitanaririni roowamashiteki? ");
INSERT INTO cjoNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Rakaeyanakirini: —Ari rowamaeyapaakirini maawaeni, roojatzi raminanteeya paashini riroperotatsiri amineenirini eejatzi pakaantapiintenirini irakapaetetaneerika rotyaanteeniri rirori rashityaari. ");
INSERT INTO cjoNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Roojatzi ikantawakiri rirori Jesoshi: —Tekirama piñiiro okantziri Iwaperite Tajorentsi: “Itheenkakiro mapi riraga wetsikirori pankotsi, omaanta iñaaperotakiro Tajorentsi okameethatzi: tema okijotakaakiro maawaeni pankotsi. Rooma ikameethataki Awinkatharite, tema otsikanatakaworoña maawaeni rantziri”. ");
INSERT INTO cjoNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Rootaki nokanantakimiri: eero piñeeyirini Tajorentsi eerori ipinkathariwenteeyeminimi. Omaantakya reewawenteeyerini paashinijatzitatsiri atziri: riraga pinkathataperoeyakiririni eejatzi aapatziyaperoeyakaririni. ");
INSERT INTO cjoNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Naaka oshiyakawori rowaga mapi: tema nokenkithatakotziro kameethaperotatsiri. Ninkarika kaari aapatziyawakyaawoni kyaaryooperotatsiri, aritaki rowashironkaakya: riyaate janta ikemaatsityaawonta, ashi rowaero. ");
INSERT INTO cjoNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Riraga jewawentayitziririni ñaanakowenantatsiripaeni eejatzi riraga warijeeyopaeni ikemaeyantawakaworini roshiyakaawentayitakinirini Jesoshi roojatzi riyotakoeyantawakawoni rirotaki irirapaeni roshiyakaawenteeyakirini. Tema tee raapatziyari rirori. ");
INSERT INTO cjoNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ikowaeyawitanakani raakaanterimi Jesoshi omaanta ithaawanteeyakarini atziripaeni. Riyotaki atziripaeni riraga Jesoshi rirotaki kenkithatakotziriri Tajorentsi, rootaki kaari raantari. ");
INSERT INTO cjoNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Rapiitakiniri eejatzi Jesoshi roshiyakaawentakiniri piyotawenteeyakaririni, ikanteeyakirini: ");
INSERT INTO cjoNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Noshiyakaawentemiro tsika ikanta Tajorentsi ipinkathariwenantzi. Ikimitakari riraga pinkathari. Eenitatsi itomi owakira aatsiri iina. Ikantaka riraga ashitariri ikowaki riweshiryaawentyaari itomi, rootaki ikaemakaananteeyakaririni inampijatzi rakiyoteri rowakayaari. ");
INSERT INTO cjoNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Rotyaantakiri apaanipaeni ronampiri romiñaawitakitari atziripaeni ipokeeta rowaeyaani, omaanta tee ikowaeyini ipoke. ");
INSERT INTO cjoNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Rapiitakiri rotyaantawitanakari paashini ronampiripaeni, ikantawitakari: “Piyaataate pikamantaateriita riraga ikamantakitzirira inkaaganki itawitakitariri: ‘Pojataki kaniri eejatzi iwatha, oyiitaka maawaeni’. Thame powakitya”. ");
INSERT INTO cjoNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Omaanta riraga romiñaawitakitari tee ikowaeyini ipoke. Jateeyakini tsikarikapaeni: riyaatzi apaani janta rowaneki, paashini ikinanaki riyomparita. ");
INSERT INTO cjoNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Omaanta paashinipaeni ragaeyawakirini rotyaantawitakari, ranteetawakiri pok, pok; ipajapajaateeyakirini osheki rowashironkaeyakirini roojatzi rowamaantakari. ");
INSERT INTO cjoNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ari ikemaki riraga jewatatsiri, antawo ikijanaka. Roojatzi rotyaanantanakari joraaropaeni riyaate rowamaeri owamaantatsiripaeni. Riraga joraaropaeni ithonkakitziri maawaeni, eejatzi ipankopaeni rootakiro maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Roojatzi ikanantanakari paashinipaeni ronampiri. “Mataka maawaeni owanawontsi oyiitaka. Omaanta rirori ikanteeyawitakitarini inkaaganki: ‘Tee ikameethatzi’, tekatsi okantya ipokanteeyaarini, rooma tee ikameethatzi. ");
INSERT INTO cjoNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Piyaatanaki iroñaaka janta awotsikipaeni antawopetatziiki, pomiñaanakiri maawaeni piñaanakirira. Pikanteri: ‘Thame nakiyotemi kaniri: rooma aaki notyomi iina’ ”. ");
INSERT INTO cjoNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ikantaka ronampiripaeni jateeyanakini, ramayitapaakirini ikaatzi iñaayitakitzirini janta, kameethatzinkaripaeni eejatzi kaari kameethatzinkaripaeni. Rareetakagaeyakarini ipaeyapaakirini kithaarentsi rooperori. ");
INSERT INTO cjoNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Roojatzi ikyaantapaaka rirori jewawenantatsiri riwethatantawakari pokayiteentsirinipaeni, raminapaaki jaga; roojatzi iñaapaakiri apaani shirampari kaari kithaatacha kameetha. ");
INSERT INTO cjoNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Itonkiyotapaakari, ikantapaakiri: “Niyompari, nopawitanakimi inkaaganki kithaarentsi kameethari pikithaawentyaarimi notyomi oemoshiryaantyaariri. ¿Iitaka kaari pikithaatantawo?” Omaanta imaeritashitaka. ");
INSERT INTO cjoNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Roojatzi riraga pinkathari ikanantakari ronampiripaeni: “Payeri irika poojoteri rakoki eejatzi iitziki, pookeri inteena otsiteniperotzinta rowaga paamariki kaari tsiwakanitatsini, ashi royero rirori janta, riraya eejatzi ratsikaekitya tyakiririri, osheki ikemaatsityaawo”. ");
INSERT INTO cjoNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ñaakiro, eejatzi ikimiwitaka Tajorentsi, ikaemakaantawitakari maawaeni atziri rawijakotanteeyaarimi, omaanta eero roshekitzi kyaatsini, apatziro apaanipaeni owawijaakotaachani. ");
INSERT INTO cjoNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ikanta ikijeeyanakani riraga warijeeyopaeni roojatzi ishitowantanaa ikenkithatakaawakagaeyakani, ikanteeyini: —¿Tsika akanterika Jesoshi akompitakaantyaariri, akijakaantyaariri? ");
INSERT INTO cjoNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Roojatzi rotyaanteeyantakarini irirapaeni riyotaanewopaeni itsipateeyakarini riraga oyaateeyiririni Erooreshi. Ipokashitakiri Jesoshi, ikantakiri: —Iyotaantatsiri, niyotzi piñaawaetziro rooperotatsiri: tee pitheeya. Eejatzi kameetha piyotaantziro Iwaperite Tajorentsi eejatzi eero pikemijantaperotziri atziripaeni oetarika ikantawitemiri rirorika pinkathari kaaririka pinkathari. Eekiro piñaawaetatziiro kameethatatsiri. ");
INSERT INTO cjoNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Iroñaaka pikantena oetarika pikenkithashiryaari. ¿Okameethatzima aperi pinkathari, riraga Seesari ayorikite? Tema irira kaari joriiyo. ¿Terikama okameethatzi? ");
INSERT INTO cjoNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Riraga Jesoshi riyotakotakiri ikowaeyawitakani ramatawiterimi ikompitakaantyaaririmi. Rootaki ikanantanakariri: —¡Eerokapaeni oshiyakaawaetashitachari paapatziyarimi Tajorentsi! ¿Iitaka pamatawitantenarimi? ");
INSERT INTO cjoNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Poñaayenari koriki pipapiintziriri oroomajatzi. Roojatzi ramantakanari apaani ikithoki koriki iitachari tenaaryo. ");
INSERT INTO cjoNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Roojatzi ikanantawakari: —¿Ninkama ashitawori ipoo owakoteencharika? ¿Tsikama itzimika ashitawori iwaero jankinateencharika? ");
INSERT INTO cjoNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Rakanakiri: —Kaarima riraga Seesari. Roojatzi ikanantanakari: —Panteniri irinta ikowakaakimiri; eejatzi pantzityaanari riraga Tajorentsi ikowakaakimiri. ");
INSERT INTO cjoNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ikemaeyantawakaworini maawaeni iroka, ari rotsikanateeyanakarini, tekatsi paashini ikantaneeriri. Roojatzi rookantanaari: jateeyaneeni. ");
INSERT INTO cjoNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Roojatzi ipokapaaki saroseeyopaeni. Iitashiwitakawo eero apiriinta añagae eejatzi, eero aatzi jenokinta. Ipokashitapaakiri, ikantapaakiri riraga Jesoshi: ");
INSERT INTO cjoNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Iyotaantatsiri, ikantzini Moeseeshi: “Eenitatsirika shirampari iina, omaanta tekatsirika itomi, aririka ikamaki, okameethatzi ragaero iinani rirentzi itzimakaanteeyaawori otomi. Itzimapaakirika otomi kimiwitanaka rirotaki ashityaarini rirentzini itomi”. ");
INSERT INTO cjoNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Paerani eenitatsi atziri ikaateeyini 6 rirentzi. Itanakawori rantaritzi raawitaka iina, omaanta tee itzimakaero eentsite. Ikamashitaka. Ikantaka paashini rirentzi roojatzi raantawitaawo rirori. ");
INSERT INTO cjoNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Eejatzi rirori tee itzimakaero eentsite. Ikamashitaka rirori. Eejatzi ikimiteeyakani maawaeni rirentzipaeni, aawitawori iinani rirentzini. Tee itzimakagaeyironi eentsite. Ikamashiteeyakani maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Impaete okamae roori. ");
INSERT INTO cjoNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Aririka ipiriinteeyaneeni iinja, ¿ninkama iinanteeyaawoni? Tema iinanteeyakawonika paerani maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Roojatzi ikanantanakari rirori: —Osheki pikompitakawo. Tee pikemaperotziro okantziri Iwaperite Tajorentsi, eejatzi tee piyotakoperotziri itajorentsiperotaki. ");
INSERT INTO cjoNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Aririka ipiriinteeyaneeni rañagae eejatzi, tekatsi agaeroni iinja. Maawaeni piriintaachani eero ragae iinapaeni. Omaanta ikimitakoeyaarini ronampiripaeni Tajorentsi jenokinta. ");
INSERT INTO cjoNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Riraga kamaawitachari ari ipiriintee iinja, tema piñaanatziro ikantziri Tajorentsi iwaperiteki: ");
INSERT INTO cjoNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Naaka Tajorentsi, raapatziyanewo Awaraama, Ijaaka, Jakoowo”. Ñaakiro, tee ikantzi: “Raapatziyawitanaga paerani”. Omaanta eeniro añi ishire janta jenokinta, roojatzi ikanta raapatziyari iroñaaka rootaki ipinkathariwenantariri Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ikemantawakawori iroka riraga piyotawenteeyakaririni ari imaeriiyanakini, rotsikanateeyanakarini, ikanteeyanakini: —Kameetha riyotaantzi Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ikemaeyantakaririni warijeeyopaeni kameetha rakakiri riraga Jesoshi saroseeyopaeni, romaeryaakiri ipiyoteeyakani ipokashiteeyapaakirini rirori. ");
INSERT INTO cjoNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ikowawitaka ikompitakayaarimi warijeeyopaeni. Ikaatziri apaani iyotaantzirori Iwaperite Tajorentsi, riyoperotziro okantziri. Ikantawitapaakari: ");
INSERT INTO cjoNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Iyotaanari, eenitatsi osheki iyotaakaeri Iwaperite Tajorentsi: ¿tsika otzimika kameethaperotatsiri kaminagaantsi akemijantaperoteri? ");
INSERT INTO cjoNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ikantawakiri rirori: —Rootaki iroka kameethaperotatsiri: “Pinintashireperoteriroña kameetha Tajorentsi, riraga Awinkatharite. Pikyaaryoowentero pinintashireperoteri maawaeni pajankaneki, eejatzi maawaeni pishireki, eejatzi pikantyaani pikenkithashiryaapiintyaari”. ");
INSERT INTO cjoNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Rootaki anaakotantaperotatsiri maawaeni kaminagaantsi Iwaperiteki Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Eenitatsi paashini, kimitawori: “Okimita osheki pinintaperotaka eerori, pikimiteerira paashinipaeni atziri, pinintaperoteri maawaeni”. ");
INSERT INTO cjoNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Aririka pantero iroka, aritaki pimonkaatero maawaeni rojankinatzirini paerani Moeseeshi, eejatzi rojankinatzirini riraga kamanantayitzirorini iñaani Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Eenirowa ipiyoteeyakani warijeeyopaeni, ");
INSERT INTO cjoNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","rojampiteeyakirini Jesoshi: —¿Iitaka pikenkithashiryaakotziriri Rotyaantanewo Tajorentsi, riraga Owawijaakotantatsini? ¿Ninka tomintaririka? Ikanteeyanakirini: —Rirotaki icharineeteni Iraviiri. ");
INSERT INTO cjoNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","44","Ikantakiri: —Paerani ojankinatakaakirini Ishire Tajorentsi Iraviirini, ikanantariri Rotyaantanewo Tajorentsi: “Nowinkatharite”. Rooma piyotziro Iwaperite Tajorentsi okantzi: “Riraga Pawa Tajorentsi ikantakiri Nowinkatharite: ‘Pijeekimotena nakoperoki, pitsipatena eewawenteri atziripaeni. Pijeekanaki roojatzi nothonkantakyaari maawaeni kijakimiri’ ”. ¿Iitakakya ikanantariri riraga Iraviirini paerani: “Nowinkatharite”? ");
INSERT INTO cjoNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Tema ikenkithatakotzitarini Iraviirini Rotyaantanewo Tajorentsi, ikantziri: “Nowinkatharite”. ¿Tsika ikantyaari Iraviirini ipinkathateeri icharineeteni impaetatsiri ijeeki? Rooma ametakawo apinkathatziri jewateeri. ");
INSERT INTO cjoNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Imaeritashiteeyanakani maawaeni. Tekatsi akaneentsini eechonkiini. Eejatzi paashiniki kitejiri tee rapiiteeri rojampitaneeri: ithaawantanakari rapiiterimi rojampiterimi eejatzi. ");
INSERT INTO cjoNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ikanteeyakirini riraga Jesoshi piyotawenteeyakaririni eejatzi naaka maawaeni riyotaanewo: ");
INSERT INTO cjoNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Irira iyotaantzirori Iwaperite Tajorentsi eejatzi irira warijeeyopaeni rirotaki poyaatariri Moeseeshini riyotaantziro Iwaperite Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Okameethatzi pikemijantaperotero oetarikapaeni ikantzimiri omaanta eerokya pantziro rantziri. Ikantawitzimi: “Ari pikantya, kameetha pijeeki”, omaanta tee ijeeki rirori kameetha. ");
INSERT INTO cjoNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Osheki opomeentsitzimotzimi pantero maawaeni riyotagaeyakimirini, omaanta tee riyoteemi maawaeni okaatzi okantziri Iwaperite Tajorentsi, eejatzi tee ipomeentsiwentzimaetawo rantero rirori oetarika ikantawitakimiri. ");
INSERT INTO cjoNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Rantashitawo oetarikapaeni piñaantyaariri, piñaaperotantyaariri ikameethatzi. Tema romaawakotakawo eechonkiini Iwaperite Tajorentsi rakoki eejatzi roojoyinatakotzitakawo ipankaki, pikanantyaari kameetha raapatziyaperotakari Tajorentsi. Eejatzi rowaneentashitaka ikithaashitetziitakawo ikantakaaperotashitaka. ");
INSERT INTO cjoNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Aririka rowaeyani, ikowaperotzi itsipatapiintyaari jewatatsiri. Eejatzi ikimitzitaka janta pankotsiki ipiyotantapiintarira joriiyopaeni ikowaperotaki itsipatapiintyaari jewatatsiri janta. ");
INSERT INTO cjoNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ikantakaaperotashitaka rootaki ikowantakari kameetha piwethateeyaarini janta aririka pitonkiyotyaari, eejatzi ikowaki pikanteeyerini: “Iyotaanari”. ");
INSERT INTO cjoNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Omaanta eeroka, eerokya pikimitakotari. Eero pikowanaki ikanteetemi paashinipaeni: “Iyotaanari” iñaaperotantemiri. Maawaeni eerokapaeni pimonkaatawakagaeyakani: eerokataki yeeyipaeni. Apatziro Rotyaantanewo Tajorentsi rirotaki pikanteri: “Iyotaanari”. Okameethatzi apatziro piñaaperoteri irira. ");
INSERT INTO cjoNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Jaka kipatsikika, eero pikantashitari paashinipaeni atziri: “Pawa”. Omaanta apatziro pikante Pawa riraga jeekatsiri janta jenokinta, eejatzi piripero eejatzi pirithori jaka kipatsiki. Tekatsi paashini pikanteri. ");
INSERT INTO cjoNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Eejatzi eero pishinetziri ikanteetashiyitzimini: “Neewatzinkarite”. Eenitatsi peewatzinkarite papintzite apaani, naaka riraga Rotyaantanewo Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Pikowakirika peewawenante, pityaawo pamitakotapiinteri paashinipaeni, pineshironkateeyerini. ");
INSERT INTO cjoNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Aririka pikante: “Naaka Neewawentemi, osheki nokameethatanaki”, aritaki ipashiwentakagaeyakimini Tajorentsi. Aririka pikante: “Tee nomatziro apaniroeni, Pawa Tajorentsi, pamitakotenari”, roojatzi ramitakotemi, imatakayemiro, kameetha peewawenantyaariri atziri. Rootaki ikanteeyanarini rirori. ");
INSERT INTO cjoNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Roojatzi ikantakiri Jesoshi iyotaantayitzirorini Iwaperite Tajorentsi eejatzi warijeeyopaeni: —¡Ashironkaamatsitemiini! Poshiyakaawaetashita paapatziyari Tajorentsi, omaanta osheki pamatawitakiri atziripaeni. Kaari rooperori piyotaakiriri oetarika ikowakaawitariri Tajorentsi riyoteeririmi. Ashironkaamatsitemiini iinja powashironkaeyaani osheki. Eero paapatziyari Tajorentsi ipinkatharitakaantemiri pajankaneki, eejatzi eero pishinetziri paashinipaeni atziri raapatziyari ipinkatharitakaantyaariri rajankaneki. ");
INSERT INTO cjoNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Eeroka oshiyakaawaerintzi pikoyi paapatziyaarimi Tajorentsi. Osheki netakotakimi rooma paata ari powashironkaaperoeyakyaani. Osheki paapithatakiro opankopaeni kamaentsiripaeni oemi. Tema osheki pojanthaashitawo pamanaawaetashitari Tajorentsi. Omaanta tee paapatziyawo iñaani, rootaki rowashironkaantaperotemiri osheki iinja. ");
INSERT INTO cjoNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Eeroka poshiyakaawaetashita paapatziyarimi Tajorentsi. ¡Ashironkamatsitemiini! Pamatawitantaki osheki rootaki powashironkaanteeyaarini iinja. Piyaate tsikarika piyotaantawityaaririni paashinijatzitatsiri atziri ipeyanteeyari joriiyo roshiyantemirimi eerori rootaki riyaatanteeyaarini rirori janta paamariki kaari tsiwakanitatsini. ");
INSERT INTO cjoNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Osheki rowashironkaaperoeyemini Tajorentsi. Pikimitakoeyakarini kaari kokichaatatsini ikathatziri paashini kaari kokichaatatsini. Rooma tee piyotziri Tajorentsi rootaki kaari pimatantawo piyoteeri kameetha paashinipaeni atziri. Pikantashita: “Aririka akante: ‘Tema ojeeki Tajorentsipanko jaga, piyotantyaari eero namatawitzimi’, pikenkithashiryaashita okameethatzi pamatawitante. Omaanta aririka pikante: ‘Tema ijeeki oorotatsiri pinatachari osheki janta Tajorentsipankokinta, piyotantyaari tee namatawitzimi’, tema kyaaryoopero piñaawaetziro kameethatatsiri. Kaari pamatawitantzi”. Teemaeta piyotziri Tajorentsi oetarika ikowakaakimiri. ");
INSERT INTO cjoNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Eeroka majontzi! Osheki piñaawaetashitaka. ¿Oetaka kameethaperotatsiri? ¿Ooroma kameethaperotatsiri? ¿Tajorentsipankoma kameethaperotatsiri? Tema rashi Tajorentsi Tajorentsipanko. Rootaki Tajorentsipanko kameethatakaanakiriri ooro ojeekakira. ");
INSERT INTO cjoNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Eejatzi tee okameethatzi pikantashita: “Aririka akante: ‘Tema ari ojeekaki aritaari ataantapiintanariri Tajorentsi apira, piyotantyaari eero namatawitzimi’, aritaki ayotzi kameetha amatawitante. Omaanta aririka akante: ‘Tema ari eenitatsi apira owamaakiniri Tajorentsi ataakiniri janta aritaariki, piyotantyaari eero namatawitzimi’, ari piyotzi eero amatawitantziroña. ");
INSERT INTO cjoNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Eeroka kaari kokichaagantzi! ¿Iitaka kameethaperotatsiri? ¿Rirotakima pipira? ¿Rootakima aritaari pitaantanariri Tajorentsi pipira kameethatatsiri? Tema rashi Tajorentsi aritaari rootaki ikameethatakaantanakawori pipira pitaakiniri Tajorentsi”. ");
INSERT INTO cjoNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","22","Paminetya, osheki pikantzi: “Tema eenitatsi aritaari ataantapiintanariri Tajorentsi apira”, “Tema eenitatsi Tajorentsipanko”, “Tema eenitatsi jenokinta”, oetarikapaeni. Tee okameethatziroña pikantashitawo, tema piitashiwitaka okameethatzi pamatawitantzi. ¿Piitashitama tee ijeeki Tajorentsi? Tema ijeeki, eejatzi ari rowashironkaawentakimiro maawaeni pamatawitantzira. ");
INSERT INTO cjoNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","¡Ashironkaamatsitemiini eerokapaeni warijeeyopaeni eejatzi iyotaantziroripaeni Iwaperite Tajorentsi! Poshiyakaawaetashita paapatziyari Tajorentsi, aritaki rowashironkaaperoeyakimini Tajorentsi iinja. Pamine, eenitatsi eechonkiini panteeyawitakarini. Paakirika piyorikite 10, apaani pipakiri Tajorentsi. Paakirorika piwankiri 10 meentashi, koraanteroshi, eejatzi tsirikana 10, apaani maawaeni irowa pipakiriri Tajorentsi. Rootaki panteeyawitakarini eechonkiini; omaanta eenitatsi kameethaperotatsiri ikowakaaperotawitakimiri Tajorentsi, omaanta iroka tee pantziro. Ikowakaawitakimiri kameetha pijeeki, eejatzi pineshironkateeyerini paashinipaeni atziri, eejatzi pikyaaryoowenteniri okaatzi ikowakaakimiri rirori. Maawaeni iroka roowitaka kameethaperotawitachari panteeyerinimi. Eekirokya impaetanaki pipashityaari apaani oshi, maawaeni paakiri. ");
INSERT INTO cjoNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Tee piyoteeyini! Pikyaaryoowentawitakawo kaari ikowakaaperotzimi Tajorentsi. Omaanta tee pikenkithashiryaaperotzimaetawo rowaga ikowakaaperowitakimiri. ");
INSERT INTO cjoNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","¡Ashironkaamatsitemiini eerokapaeni! Poshiyakaawaetashita paapatziyarimi Tajorentsi, omaanta ari pashironkaperoteeyaani iinja. Pamine, pameteeyawitawoni pikiwaeyironi pimirimento eejatzi piwiratote otapiikira, omaanta tee pikiwimaetawo inthomaenta. Rootaki oshitzinatantayitakarini rooma tee pikiwiro. Eejatzi pikimiwitakawo eerori pimirimento. Ñaakiro, osheki pikiwayitzironi pakopaeni, pikameethatantyaarimi, omaanta tee paapatziyaari Tajorentsi pikameethatantyaarimi. Tema eejatzi piñaawenashiryagaero oetarika pashitantawori apatziro eeroka, osheki paapithatatziiri okaatzi rashitari paashinipaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Eeroka warijeeyopaeni kaari kokichaatatsi: tee piyotziroña pantero kameethaperotatsiri! Aririkami pityaawomi pikameethatanakimi pajankaneki, roojatzimi okameethatzimi iñaaperotantemirimi Tajorentsi, eejatzi atziripaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Ashironkaamatsitemiini eerokapaeni iyotaantawitawori Iwaperite Tajorentsi eejatzi warijeeyopaeni. Osheki pamatawitantaki rootaki rowashironkaanteeyemirini osheki iinja. Pikimiwitakawo omoo impeeta romonkyaantapiinteetariri kaminkari. Kameetha owaneenkawitaka jeñokiini kitamaawitaka omaanta janta inthomaenta shitzitanaki. Tema yeekitaki itonkipaeni kaminkari. ");
INSERT INTO cjoNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ari pikimitzimotakari atziri pikameethatemi, iñaaperoeyantawitakimirini riroripaeni okaatzi pantziri. Omaanta tee pikameethatzimaeta pajankaneki, osheki pamatawitantzi eejatzi osheki pantapiintakiro kaari kameethatatsi. Tema pitheeyashita. ");
INSERT INTO cjoNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","30","Ashironkaamatsitemiini eerokapaeni oshiyakaawaerintzi paapatziyari Tajorentsi: osheki powashironkaaperoeyaani iinja. Iroñaaka pimoontashiyitakirini kaminkari powantyaanariri itonkipaeni. Eejatzi poshirinkantayiteeyaaririni itakaantaworini kamaentsiri paerani, riraga rowamaayitakirini pichariniiteni riraga kamanantayitzirorini iñaani Tajorentsi. Powaneenkayitakironi rowaga tonkitsipankopaeni kameetha. Pikitayitantaririni kameethatzinkaripaeni rajankaneki eejatzi pikantayitzini: “Aririkami nokoñaatzitakyaami paerani ikoñaatantakari nochariniiteni, eero nokempiyarimi naari nowamaeri rirori, riraga rowamaakirini nochariniiteni”. ");
INSERT INTO cjoNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Tema pikantakotashita eeroka apaniroeni aririka pikanteeyeni: “Nochariniiteni riraga owamaakiririni kamanantayitzirorini iñaani Tajorentsi”. Pikantashita: “Eero nakawentziri riroripaeni”. Pamatawitashitaka eeroka apaniroeni. ");
INSERT INTO cjoNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Eejatzi eerori iroñaaka pikimitakoeyakarini. Eerokateeyakini owamaantatsiri. Aritaki pimonkaatakiro ritakarini rantakiri pichariniiteni. ");
INSERT INTO cjoNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","¡Kimiteeyakimini maankipaeni! ¡Tee pikameethaperoeyini! ¿Piitashitama eero rotyaantzimi Tajorentsi paamarikinta kaari tsiwakanitatsini? ");
INSERT INTO cjoNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Eekiro riyaatatyee ikanteeyirini riraga Jesoshi: —Notyaantemiri iinja paashinipaeni kamanantayiterorini iñaani Tajorentsi, rirotaki iyothaniperotatsiri eejatzi iyotaantatsiri. Notyaantemiri riyoteemi kameethaperotatsiri. Niyotakotakimi eero paapatziyawakari, inta powamaagaantashiteeyawakyaarini apaanipaeni eejatzi apaanipaeni pikentakotakaantawakiri, riraga paashinipaeni pipajapajaatakaantawakiri janta pankotsiki pipiyotantapiintarira eejatzi paashinipaeni pikijagaantawakiri tsikarika ikinayitakini. ");
INSERT INTO cjoNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Eenitatsi kaari kameethatatsiri pantakiri eerori, rooma inimotakimi eerori ikameeta maawaeni kameethatzinkari: ritanakawo rowamaakiri riraga Aweerini eejatzi ikantanaka paashinipaeni maawaeni riro oweyaantapaakawori riraga Jakariiyashi, riraga itomini Perekiiyashini. Rowamagaeyakirini pichariniiteni janta Tajorentsipankoki okaakiniki aritaari. Aririkami pikoñaatzitakyaami eeroka, arimache pakawentakirimi eerori. Ashi poyiro powamaantzi. ");
INSERT INTO cjoNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Kyaaryootaki iroka nokantemiri. Ari pimonkaatakiro paata iroka nokantakimiri. Ashi poyiro powashironkaeri paashinipaeni atziri kameethari. Rootaki ikanantemiri Tajorentsi: “Eenitatsi pantani”. ");
INSERT INTO cjoNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","¡Ashironkaamatsitemiini jerojareejatzipaeni! Eerokapaeni powamaakiri rotyaantanewopaeni Tajorentsi: tema pompojantakari mapi kamanantayitzirorini iñaani Tajorentsi. Okimitziriranki tyaapa ojatewirinikitziri iyeerikini eejatzi nokimiwitaka naari, osheki netakoeyawitakimini. Nokowaperowitaka nowawijaakoeyemini omaanta eerokapaeni tee pikowaeyini namitakoeyemini. ");
INSERT INTO cjoNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","¡Pamine sha! ¡Iroka pinampika! Eero roojatzi okanteetatyeeyaani ojeeki. Tekatsi jeekatsini iinja. ");
INSERT INTO cjoNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Eero papiitaana piñagaana. Apatziro piñagaena iinja, pikanteerika: “Kameethaperotaki Jesoshi, rirotaki Awinkatharite, riraga Rotyaantanewo Tajorentsi”. Osheki pikimoshirewenteeyanakinani. Rootaki ikantakiriri riraga Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Roojatzi riraga Jesoshi riyowantanaa Tajorentsipankoki roowiteenchami riyaate. Nopokashiteeyapaakirini naakapaeni riyotaanewo naminakagaeyapaakirini notsikanateeyapaakawoni maawaeni Tajorentsipanko. ");
INSERT INTO cjoNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Roojatzi ikanteeyantanakarini: —Piñaakiro maawaeni iroka pankotsika. Piñaawitakawoka iroka pankotsi iroñaaka. Iinja eero piñagaero eejatzi. Ari ishekiroryaagaeteero maawaeni okaatzi piñaawitakarika. ");
INSERT INTO cjoNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Roojatzi niyaateeyanakini tonkaariki oetachari Oriiwomashi, notonkaanaki, tonka, tonka. Areeteeyapaakinani tonkaariki, ari imakoryaapaaki Jesoshi, roojatzi niyaatashitapaakiri nokantapaakiri: —Pikamanteeyenani: ¿tsika okaateka ishekiroryaanteetyaawori ironta pankotsipaeninta? ¿Iitaka iyotakayenani iinja tsika okaateka pipokantyaari, othonkanteeyari kipatsi? ");
INSERT INTO cjoNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ikantanakiri riraga Jesoshi: —Kyaaryoowa, ramatawiteetzimikari iinja. ");
INSERT INTO cjoNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Eenitatsi oshekini pokatsinipa kantapaentsini: “Naaka Rotyaantanewo Tajorentsi”. Kyaaryoowa, ramatawitashitzimikari rirori. ");
INSERT INTO cjoNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Pikemakopiinteeyeroni omanataantsi. Pikemaeyerini atziri ikanteeyeni: “Romanatawakaeyatyaani paashinikipaeni nampitsi eejatzi paashiniki kipatsipaeni”. Omaanta eero pithaayi. Aritaki okantyaari romanatawakagaeyaani. Omaanta tekira omonkaatya maawaeni nokantakimiri, okaatzi nopokanteeyari. Tekira othonkanteeyari kipatsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Atziri jeekatsiri paashinikipaeni kipatsi ari ikijawakayitanakyaani jeekatsiri paashini kipatsi, romanatawakagaeyani. Itasheyeeyanakini, tekatsi ragae rowaeyaarini. Opokaeyeni antawo mantsiyarentsi. Omoyekapiintya kipatsi, othonkayiteroni tsikarikapaeni omoyekya. ");
INSERT INTO cjoNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Omaanta tekiraata omaperota ikemaatsitaperotyaawo katsiri. ");
INSERT INTO cjoNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Eekiro riyaatatyee ikamantawakina: —Riyotakimirika atziri paapatziyakina, rowashironkaeyemini ikemaatsitakagaeyemironi osheki katsiri, rowamaakaantemi, ikijeeyemini maawaeni atziri. ");
INSERT INTO cjoNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Osheki atziri piyakoteeyaworini ranteero kaari kameethatatsi, roojatzi rookanteeyawo raapatziyari Tajorentsi. Ikijayitanakirini paashinipaeni kemijantzinkari raakaantayitanakirini. ");
INSERT INTO cjoNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Iinja osheki pokatsini theeyashitachani ikantapaaki: —Naaka iyotaantzirori Iwaperite Tajorentsi. Tema ramatawiteeyashitakarini osheki aapatziyawitakariri Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Eekiro riyaatanakityee atziri rantaperotanakiro kaari kameethatatsi rootaki rookantanakyaawori inintashiretawakagaeyani eejatzi ipeyakotantanakyaariri Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Omaanta ninkarika kijokiro owaperotenani ikanteetatyaani raapatziyana rirotaki nowawijaakoteeyerini. ");
INSERT INTO cjoNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Piyaatakayero noñaani eerokapaeni maawaeni aapatziyanari. Piyaate maawaeniki kipatsi, pikanteri maawaeni atziri nokowaki nowawijaakoteri. Omonkaatapaakyaarika maawaeni iroka, roojatzikya omonkaatantapaakya maawaeni nokantzitakimiri. ");
INSERT INTO cjoNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Eekiro riyaatatyee ikamanteeyanani: —Paerani rojankinatzini Intañeeri, riraga kamanantzirorini iñaani Tajorentsi, ikantzini: “Aritaki ipokaki iinja jaga Tajorentsipankonakiki osheki kaari kameethatatsini, reewanaperoeyashiteeyakawoni okaatzi jeekayitatsirini jaga maawaeni”. Tema piyotziro iroka nokenkithatakotziri. Aririka piñaakiripa atziri rantapaakirorika okaatzi rojankinatzitakarini riraga Intañeeri rootaki piyotantanakyaari irika nokamantakotziri. ");
INSERT INTO cjoNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Roojatzi pijeekirika Joreeyaki, pishintsite pishiyeeyanakini tonkaariki. ");
INSERT INTO cjoNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Aririka pijeeki inkokironta, eero pikyaapanaatzi inthomaeki pipankoki paantapanaatyaawori powaagawo, inta pishiyaperotanaki. ");
INSERT INTO cjoNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Eejatzi aririka pijeeki owantsiki, eero pipiyashitapanaatawo paashini piithaari. ");
INSERT INTO cjoNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ashironkaamatsiteroeni paata tsinani motzitatsiri eejatzi thotatsiri eentsite eero omatziro oshiyaperota kameetha. ");
INSERT INTO cjoNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Kaakitaki iinja pishiyapithatyaari omaanta pamaneri Tajorentsi okantya eero pishiyanta inkanipaeteki, eejatzi eero pishiyanta kitejiriki pimakoryaantapiintari. ");
INSERT INTO cjoNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Eejatzi ikantzi riraga Jesoshi: —Osheki piñeero iinja opomeentsitzimoteeyemini. Pashironkaaperotanakyaaroña, panaakoteri maawaeni itakaantaworini atziri paerani pashironkaeya. Eejatzi eero iñiiro maawaeni impaetatsiri ijeeki okimitaka iroka. ");
INSERT INTO cjoNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Aririkami ojamanitemi rowashironkaeyeminimi, ari pithonkaeyakyaanimi, omaanta riraga Tajorentsi ikaminthaakiri maawaeni aapatziyariri riyoyeeyakirini, rootaki kaari ojamanitantya rowashironkaemi. ");
INSERT INTO cjoNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Eejatzi iitarika kantakimini: “Areetapaaka Rotyaantanewo Tajorentsi riraga Owawijaakotantatsini; pamineri irika”. Paashini kantatsini: “Irinta areetapaaka janta”. Omaanta eero paapatziyari. ");
INSERT INTO cjoNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kaakitaki iinja osheki amatawitantatsiri ikantapaaki: “Naaka Jesokirishito riraga owawijaakotantatsiri”. Omaanta kaari. Paashinipaeni ikante: “Naaka iyotaantzirori Iwaperite Tajorentsi”. Ramatawitantayitapaakyaaririni atziripaeni tema itajorentsijeempiyaashitapaakya. Eejatzi aritaki ikowakowawitakya tsika ikantya ramatawitantyaaririmi riyoyaaperotayitakirini Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ñaakiro, nokamantzitakimiro tsikarika okantyaari iinja. ");
INSERT INTO cjoNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Rootaki piyotantyaari aririka ikanteetemi: “¡Pamine! Irinta Jesokirishito janta okaankiteronkiitziinta”. Eero patsipetawo piyaatzi. Eejatzi ikanteetemirika: “Irika jaka Jesokirishito inthomaekika pankotsi. Eero pakiri”. ");
INSERT INTO cjoNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kyaaryo, nopoñaaka naaka jenokinta, natziriperotapaaki kipatsikika. Eejatzi nopiyee paata janta jenokinta. Tema romapokimi tariito rookathatyaarika, tyaaooo, ithotyaapaentziro janta jenokinta. Ari nokimiteeya iinja naari aririka nopokae: nomapokaeyapaemini omaanta ari piñeeyawaenani maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Tsikarika ijeeki kaminkari, eejatzi rewoteenkatzita riroripaeni tzijo. Eejatzi okimitaka, tsikarika ijeeki kemijantawitanari, eejatzi tsikarika ijeeki kaari yotana, rootaki ipokashitantyaariri oshekini amatawiterini. ");
INSERT INTO cjoNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Eekiro riyaataatyee ikantzi riraga Jesoshi: —Ari osheki opomeentsitzimoeyanakyaarini atziri, maawaeni: osheki rowashironkagaeyanakyaaniroña. Roojatzi intsipaete itsiwakanaki oorya, eejatzi riraga kashiri, eejatzi ipariyanaki ompokiro maawaeni: tema shewatanaka maawaeni jenokijatzi. ");
INSERT INTO cjoNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Roojatzi nokontetantapaakya janta jenoki. Roojatzi retakotanteeyanakyaani maawaeni theenkaeyanarini. Ari iñeeyawaenani maawaeni atziri nokinapae menkoriki nopinkatharitaperotapaaki, noshipakiryaaperotapaaki. ");
INSERT INTO cjoNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Itziwootanakiri nonampiri tziwoorentsi. Maawaeni nonampiri ipokaeyapaakini ipiyoteeyerini maawaeni aapatziyanari. Maawaeni ikaatzi niyoyeeyakirini. Ithotyeeyerini ipiyoteeyerini riroripaeni maawaeni paashinikipaeni kipatsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Paashini ikamanteeyanarini riraga Jesoshi: —Iroñaaka noshiyakaawentemiro iyeera. Pikemijantena. Rooteentsirika oshookaempekitanaki, eejatzi oshitanee, ari piyotanaki rooteentsi okithokitee. ");
INSERT INTO cjoNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Eejatzi okimitakya, aririka piñaawakiro iroka nokantzitakimirika piyotantyaari rooteentsi nopokae. ");
INSERT INTO cjoNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Eerorika pikamita, aritaki piñaawakiro maawaeni iroka nokantzitakimirika. ");
INSERT INTO cjoNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Othonkaeya jenokijatopaeni eejatzi kipatsi omaanta noñaani eero othonka. Omonkaataperoteeya kameetha maawaeni nokantakimiri. ");
INSERT INTO cjoNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Omaanta tekatsi yotatsini tsikarika okaate; tee riyotzi ronampiri Pawa, eejatzi naari tee niyotzi. Apatziro Pawa apaniroeni yotatsiri. ");
INSERT INTO cjoNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","39","Paerani eenironi ijeekini riraga Noe, rowapiinteeyani atziripaeni, ishinkiteeyani, raapiinteeyini iina, maawaeni. Tee ikenkithashiryaakotanaawo ikantawitakariri Noeni: “Kaakitaki oonkawo”. Roojatzi iinja rotetantanaka riraga Noeni ipitoki, rashitakotanaka, jaae tok. Omapokapaakiri antawo inkaani, oonkanaka. Ithonkaeyakani, maawaeni theenkakiriri, itsitsiyeeyakini. Eejatzi ikimitakya iinja maawaeni theenkaeyanarini, aririka omonkaatapaakya nopokanteeyari, eero ikenkithashireeyani nomapokaeyapaakirini. Rootaki nowashironkaanteeyapaakyaaririni, eero nowawijaakotapaeri. ");
INSERT INTO cjoNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Roojatzi itsipatawakayaarika apite shirampari thamaetatsiri janta owantsiki, apatzirorika apaani rirotaki aapatziyanari. Tema rirotaki irira naaneeri notsipatanakyaari, omaanta paashini, eero naaneeri. ");
INSERT INTO cjoNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Okimitakya, eenitatsi apite tsinani tonkayitzirorini shinki, apatzirorika apaani aapatziyanari tema rootaki irowa naaneeri notsipatanakyaawo, omaanta paashini eero naaneero. ");
INSERT INTO cjoNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Rootaki paamagaeyantanarini, pikenkithashiryaapiintena. Tee piyotzi tsika okaateka nopokantyaari. Nomapokapaakimikari. ");
INSERT INTO cjoNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Okimitaka riraga ashitawori ipanko ikoshiteetziri. Riyoteemi rooteentsi ipoke koshitantatsini, ikakitemi, eero ishinetzirimi ikoshiteri, inta roepiyawaerimi. ");
INSERT INTO cjoNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Eejatzi naari, paamagaeyantanarini, nomapokaemikari. Paapatziyaperoteena, tee piyotzi tsika okaateka nopokantyaari. ");
INSERT INTO cjoNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Pikimityaari onampirentsi kameethari, ikyaaryoowentziniri maawaeni ikantziriri iwaatorote. Ikanteririka irira: “Eeroka wetsikapiinterorini rowanawo notyomi, pipapiinteri kameetha”. Tema imonkaatakiniri. ");
INSERT INTO cjoNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","47","Aririka iñeeri kameetha riwetsikapiintziro rowanawo, ari ikanteri: “Kameetha pantziro nokowakaakimiri. Iroñaaka eeroka kempoyeenawoni maawaeni tzimimotanari. Kameetha nopinatemi, niyotzi eero pamatawitana”. Tema ari ikimoshiryaanaki ronampiri. ");
INSERT INTO cjoNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Omaanta eenitatsirika paashini ronampiri, kaari aapatziyarini riraga iwaatorote. Ikantashitya irinta: “Iroñaaka jatanaki nowaatorote, eero ipiyita”. ");
INSERT INTO cjoNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Roojatzi irinta kaari aapatziyariri ikijiri paashinipaeni onampirentsi, ikapojapiintziri, ishinkitapiinta. ");
INSERT INTO cjoNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Roojatzi romapokapaakiri riraga iwaatorote, tee raamayari riraga kaari aapatziyarini. ");
INSERT INTO cjoNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Roojatzi rowashironkaapaakiri, rotyaanteri janta inteenanta, itsipatantyaariri amatawitantatsiri. Roojatzi janta riraaperotanakya eejatzi osheki ikemaatsityaawo katsiri. Eero pikimitari eeroka, inta irintakya pikimityaari riraga aapatziyaperotariri iwaatorote. Rootaki ikantziri riraga Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Eekiro riyaatatyee ikamanteeyakinani riraga Jesoshi: —Iroñaaka noshiyakaawentemiro tsika ikanta Tajorentsi reewawenantzi. Eenitatsi ewankawo 10, kowatsiri aminakowentero rayi iina apaani shirampari. Okanta otsitenitanaki roojatzi aantayitakani oorentamento ootanakyaari iinja aririka ipokaki. ");
INSERT INTO cjoNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Okaataki ewankawo iyoperotaneentsiri apawakooni eejatzi okaataki kaari yotatsini apawakooni. ");
INSERT INTO cjoNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Aawiteeyanakawoni irowa ootamento, omaanta tee ayiro oyeenka oriiwo ootantyaari roori. ");
INSERT INTO cjoNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Omaanta roori yotatsiri, aakotanakiro oyeenka oriiwo ootantyaari awotsikira. ");
INSERT INTO cjoNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ikantaka rojamanitaki aatsini iina, tekiraata ipokeeta. Agaeyakironi owochokini, roojatzi omaanteeyanakani maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Okantaka niyankipaeteki tsiteniri, okemataatzi kaemaantsi: “Kaakitaki aatsini iina, piyaate paminawakiri”. ");
INSERT INTO cjoNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Roojatzi opiriinteeyantawitanakani maawaeni, owetsikawitanakari ootamento. ");
INSERT INTO cjoNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Okantawitakawo kaari yotatsini: “Pipena naari eechonkiini pashi oyeenka oriiwo rooteentsi nothaatakotya nashi naari”. ");
INSERT INTO cjoNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Akanakiro rowaga yotanitzinkawo: “Eero nopimi. Iyotaka nashi naari. Tekatsi nopemiri eerori. Nopakimirika tekatsi nootaneeya naari. Piyaate pamananantapaentya eerori ipimantapiinanta”. ");
INSERT INTO cjoNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Roojatzi iyaatantanaka amananantapaenta. Aritaki areetzimatapaaka riraga aatsini iina kyaanaki janta ithomaenta pankotsiki. Itsipaeyanakawoni wetsikaenchari inkaaganki. Ashitakotanaka pankotsiki, tog. ");
INSERT INTO cjoNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Roojatzi opiyawitapaaka kaari kenkithashiryaacha, okantawitapaakari: “Pashitareenawo naaka jaga”. ");
INSERT INTO cjoNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Omaanta ikantawakiro: “Tee niyotzimi, ninkarika. Tee nokoyi pipokashitena jaka”. ");
INSERT INTO cjoNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Pikenkithashiryaakoperotawakiro iroka noshiyakaawentakimirika. Okimitakaga yotaniperotatsiri aamaaperotakari aatsiri iina, eejatzi pikimitya eerori: paamayena tee piyotzi tsikarika okaatzi nopokanteeyaari. Yotaniperotatsiri kijokiro owakotziro oyeenka oriiwo. Eejatzi pikimitya eerori, kijokiro powanakiro Ishire Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Eekiro ikantatzi riraga Jesoshi: —Eejatzi noshiyakaawentemiro paashini tsika ikanta Tajorentsi ipinkathariwenantzi. Kimitaka riyaatziranki ashaagantachari paashinikinta nampitsi. Ritakawo ikaemaeyakirini ronampiri maawaeni, ikanteeyakirini: “Nokowaki poshekeenari noorikite”. ");
INSERT INTO cjoNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Roojatzi ipantakari apaani ronampiri koriki 5.000. Ikantakiri: “Ajaa, poshekeenarira noorikite”. Rakanakiri: “Jee, aritaki”. Eejatzi paashini ipakiri rirori: ipakiri ikaatzi 2.000, osheki ipinataka. Ikantakiri: “Ajaa, poshekeenarira”. Rakanakiri: “Jee, aritaki”. Eejatzi paashini ipawitakari rirori ikaatzi 1.000. Ikowawitaka roshekeenirimi. Eejatzi ipinataka rirori osheki. Riro ipaperoetakiri osheki yotaniperotatsiri. Omaanta riraga yotatsiri eechonkiini tee ipaperoetziri osheki. Ipaeyakirini maawaeni roojatzi riyaatantanaka ashitariri iyorikite paashiniki nampitsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Riraga aaperoteentsiri koriki 5.000 riyaatanaki, roshekyaaperotantyaanariri iyorikite iwaatorote. Ikantaka riyomparitaka; roojatzi raantaka paashini koriki 5.000. ");
INSERT INTO cjoNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Eejatzi riyomparitaka rirori agaentsiri 2.000. Eejatzi roshekitakiniri: raaki rirori paashini 2.000. ");
INSERT INTO cjoNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Omaanta riraga aawiteenchari 1.000 raanakiri rotetashitanakari omooki kipatsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Ojamanitakotaki iwaatorote. Ikantaka iinja roojatzi ipiyantapaa ipankoki. Ikantapaakiri: “Iroñaaka pamaenari maawaeni noorikite. Nokoyi niyote tsika ikaataki”. ");
INSERT INTO cjoNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Roojatzi ipokantapaaka ipaetanakirira paerani 5.000, ikantapaakiri iwaatorote: “Irika piyorikite pipanakinariranki eejatzi irika paashinika piyorikite 5.000 rirotaki naakiri niyomparitantakari”. ");
INSERT INTO cjoNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Roojatzi ikanantawakari iwaatorote: “¡Kameethataki! Pimataperotakiro nokowakaakimiri. Pikyaaryoowentakiro eechonkiini piyomparitaka rootaki iroñaaka nopantemiri paashini osheki. Eeroka aminakaanteroni. Iroñaaka pipokanaki jaka, pikye pitsipatena akimoshireeyeni”. ");
INSERT INTO cjoNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Roojatzi ipokantapaaka riraga ipaetanakirira paerani 2.000, ikantapaakiri iwaatorote: “Ajaa, irika piyorikiteka pipakinari. Niyomparitaka osheki, noshekyaantakimiriri. Naakimini paashini 2.000”. ");
INSERT INTO cjoNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ikantawakiri iwaatorote: “Kameethataki, pimatakinawo nokowakaakimiri. Pikyaaryoowentakiro eejatzi piyomparitaka, rootaki nopantemiri paashini osheki. Eeroka aminakaanteroni. Iroñaaka pikyee jaka pitsipatena akimoshireeyeni”. ");
INSERT INTO cjoNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","25","Rimpaetapaaki riraga aawiteenchari 1.000, ikantawitapaakari: “Niyotakimi eeroka, tee pineshironkatantzi, osheki nothaawantakimi. Noetakaamintheetzi noshekyaakimiririka piyorikite, ari paapithateenarimi maawaeni, rootaki kaari niyomparitanta. Rootaki nokitatantakariri piyorikite inthomaeki kipatsi. Irika piyorikiteka, pagaeri”. ");
INSERT INTO cjoNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Roojatzi ikantawakiri: “Tee okameethatzi pantziri, osheki piperataka. Piyowitaka nokowawitaka naari roshekitanakimi noorikite. ");
INSERT INTO cjoNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","¿Iitaka kaari pipantari riraga kempoyaapiintziriri koriki? Ari pipakirimi iriranki, ipinatawaenami, apawo naantakyaarimi. Eejatzi ipitawaenarimi maawaeni nashipero naari”. ");
INSERT INTO cjoNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Roojatzi ikantawakiri riraga paashini ronampiri: “Paapithateri noorikite, piperi riraga oshekyaakinariri iroñaaka 10.000. ");
INSERT INTO cjoNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Nopaperoteri osheki riraga ashaagantaperotachari, omaanta riraga kaari ashaagantaperowitacha otzimimowityaaririka eechonkiini aritaki naapithatakiri tekatsi jeekimotaneerini. ");
INSERT INTO cjoNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Iroñaaka irika paanakiri janta pookeri otsiteniperotzinta rowaga paamariki kaari tsiwakanitatsini, tee ikameethatzi. Nokowaki ikaateri maawaeni riraga riraaperotya eejatzi kemaatsitakawori katsiri. Janta riraawaetyaanta, ratsikaekityaanta. Tyakiririri, tyakiririri”. ");
INSERT INTO cjoNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Ikamanteeyanani riraga Jesoshi: —Naaka poñaachari jenokinta, nokoñaatapaaki jaka kipatsikika. Rooteentsi niyaatanee, roojatzi ari nopiye, notsipatyaari maawaeni nonampiri. Nopokantyaari, arimache nopinkatharentsitapaaki, notsipatapaakyaari maawaeni nonampiri. Nopinkatharentsiperotapaaki, ipinkathaperoeyawakinani maawaeni jeekatsiri. ");
INSERT INTO cjoNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Nopiyoteeyapaakirini iinja maawaeni atziri, poñeeyapaencharini paashinikipaeni kipatsi. Nokimitakotyaari ashitachari ipirapaeni rinashityaaririka: rinashitakari owisha, rinashitzitakari riraga kaawira, maawaeni. Eejatzi nokimitakaantapaakiri iinja naari maawaeni atziri: ninashityaari aapatziyakinari, eejatzi ninashityaari riraga theenkanari. ");
INSERT INTO cjoNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Nokanteeyerini maawaeni aapatziyanari: “Pipoke jaka nakoperokika”. Eejatzi nokanteeyerini paashinipaeni: “Pipoke eerori jaka nampatekika”. ");
INSERT INTO cjoNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Roojatzi nokanteeyantakyaarini maawaeni nakoperokitziri: “Pipokaeyanakini maawaeni eerokapaeni ikimoshiretakaaperotemi osheki Pawa. Paerani riwetsikitakimironi pijeekantyaari janta inampikinta. Iroñaaka piyaate pitsipatyaari. Kameetha ipinkathariwenteeyemini. ");
INSERT INTO cjoNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ayimawitakinani notashe, pipawakinani noyaari. Ayimawitakinani nomiri, pipawakinani nomiri. Tee piyowitanani omaanta pineshironkatantakinarini janta pipankokipaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Tekatsiwitani noethaari, roojatzi pipakinawo. Nomantsiyawitani, roojatzi pipokashitakina pineshironkatakitana. Romonkyaagaetakinani omonkyaagamentotsiki roojatzi pipokashitanakina pineshironkatakinani”. ");
INSERT INTO cjoNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ari pikaateeyerini maawaeni paashini kameethatzinkari rajankaneki pikanteeyinipa: “Nowinkatharite, tsika okaatzika ayimatantawitakimiri pitashe nopantakimiri powanawo. Tee nokenkithashiryaaneero. ¿Tsika okaatzika ayimatantawitakimiri pimiri, nopantakimiri? ");
INSERT INTO cjoNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Tsika okaatzika noneshironkatantakimiri noemaakimi nopankoki? ¿Tsika okaatzika nopantakimiri piithaari? ");
INSERT INTO cjoNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Tsika okaatzika noñaantakimiri pimantsiyatzi niyaatashitantakimiri noneshironkatantakimiri?” ¿Tsika okaatzika omonkyagaetakimi nareetantakitzimiri? ");
INSERT INTO cjoNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Roojatzi nokanantanakyaari: “Kyaaryo nokantemi: ‘Pineshironkatakiririka apaani aapatziyanari eejatzi pikimitzitakina naari, pineshironkatakina’ ”. ");
INSERT INTO cjoNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Roojatzi nokanteeyantakyaarini maawaeni katziyeenchari nampateki: “Piyaateeyeni iroñaaka janta paamarikinta kaari tsiwakanitatsini, pikemaatsityaawo paamari riwetsikakiri paerani Tajorentsi. Riwetsikashitziriri iwinkatharite kamaaripaeni eejatzi maawaeni ikaatzi oyaatziriri. Iroñaaka ari pikaateri pitsipatyaari janta, osheki powashironkaaperoeyaani. ");
INSERT INTO cjoNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Paerani ayimatakina notashe, omaanta tee pipawakina noyaari. Ayimatakina nomiri, omaanta tee pipawakina. ");
INSERT INTO cjoNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Niyaatashitawitzimini noñeemi, omaanta tee pineshironkatawakina, tee poejeekawakina pipankoki. Tekatsini noethari, omaanta tee pipawakina nokithaatyaari. Nomantsiyatzini eejatzi romonkeetakina omonkyaagamentotsiki, omaanta tee pipokashitana pareetena”. ");
INSERT INTO cjoNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Roojatzi ikanteeyantanakinani eejatzi: “Nowinkatharite, ¿tsikapaetenika okaatzi noñaantakimiri pashironkaawaetaka kaari noneshironkatantzimi?” ");
INSERT INTO cjoNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Roojatzi nokanteri: “Kyaaryo, tee pineshironkatziri irintapaeni aapatziyanari, rootaki kaari pineshironkatantana naari”. ");
INSERT INTO cjoNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Rowashironkaeyerini riraga Tajorentsi janta paamari kaari tsiwakanitatsini. Ikanteetatyeeyaani ashi royiro ijeeki janta; omaantakya riraga kameethatzinkari ijeekaeyini rirori janta jenokinta, ikanteetatyeeyaani rañaaperotapae. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ithonkantakawori riraga Jesoshi ikamanteeyakinani maawaeni iroka, ari ikanteeyanani naaka maawaeni riyotaanewo: ");
INSERT INTO cjoNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Piyoteeyakini rooteentsi areetya kitejiri akenkithashiryaakotapiinantariri rawijantakarini paerani ronampiri Tajorentsi janta Ejiipitoki. Okaataki apite kitejiri areetantyaari. Roojatzi raakaananteetenari ikentakoetena. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Roojatzi ipiyotaka riraga jewayitziririni ñaanakowenantatsiripaeni eejatzi riraga aataperoteenchari. Ipiyotaka janta ipankoki iwinkathariteki ñaanakowenantatsiripaeni. Iwaero irira rirotaki Kaejashi. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Rajaryaakari Jesoshi rowamaakaanteri: —¿Tsika akanterika Jesoshi aantyaariri eejatzi owamaakaanantyaariri? Omaanta tee akoyi riyote atziripaeni, ikijakowentarikari. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ikantanaki paashinipaeni: —Pamine, rooteentsi areetya kitejiri rawijantanakarini paerani ronampiri Tajorentsi Ejiipitoki, rooteentsi ikimoshireeyanakini atziri maawaeni. Eero amatziri aaneeri rirori iroñaaka, ikijakowentarikari maawaeni atziri. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ikantaka riraga Jesoshi itharyaanaka roojatzi rareetantapaaka Wetaaniyaki. Itsipateeyakinani naakapaeni maawaeni riyotaanewo. Nareeteeyapaakani ipankoki Shimo, riraga pathaawitacharini paerani. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Nowaeyapaakani, roojatzi opokashitapaakiri roori tsinani, amakotakiro kajankaari poteeryaki kameethari. Oshekini owinawo iroka kajankaari. Roojatzi ojeetapaakiri iitoki Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Noñeeyawakironi irowa, nokijeeyanakironi, nokantzi: —¿Iitaka apaatantawori? ");
INSERT INTO cjoNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Opimanteromi kajankaari, aantyaatami oshekini koriki, oneshironkaterimi oshekini owashironkaenkari. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ikantanaki Jesoshi: —¿Iitaka pikantawenantawori iroka tsinanika? Kameethataki okaatzi antakirika. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Rooma riraga owashironkaenkaripaeni ikanteetatyeeyaani itsipateeyemini jaka pineshironkatapiinantyaariri, omaanta naaka eero nokanteetatyeeyaani nojeekimoteeyimini naari. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Iyotakotakina iroka tsinanika rooteentsi nokame, rootaki ojeetantakinari. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Kyaaryo iroka nokamantemirika, tsikarika ikenkithatakoteetero noñaani, aririka othotyaanakya maawaeni kipatsiki eejatzi ikenkithatakotzityaawo iroka tsinanika okaatzi antakiri ikenkithashiryaakotantapiinteetyaawori roori oneshironkatakina. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ikantaka riyaatashitakiri Joorashi karyootejatzi riraga jewatayitziririni ñaanakowenantatsiri ikenkithatakaeri. Rirowitaka naawita riyotaanewo Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ikantapaakiri: —Aririka nokamantemi tsika pikanteriri Jesoshi paantyaariri, ¿iitaka pipinatenari? Ikantawakiri: —Nopinatemi koriki ikaate 30 ikithoki riwetsikaetziri piraata. Roojatzi ipantawakari. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Roojatzi ipiyantapaa riraga Joorashi. Aripaete raminaperotziri riyotantyaari tsika ikanteriri raakaanantyaariri. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Monkaatapaaka kitejiri nowaeyawoni paa kaari tapiyacha. Roojatzi riyaatashitantakari apaanipaeni riyotaanewo riraga Jesoshi, ikantapaakiri: —¿Tsika pikoyika nowojantemiro owaeyaarini akenkithashiryaantyaawori rawijantanakarini ronampiri Tajorentsi janta Ejiipitoki paerani? ");
INSERT INTO cjoNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ikantawakiri: —Piyaate Jerojareekinta, pikantapaakiri shirampari piñaapaakirinta janta: “Ari ikantzi iyotaantatsiri: ‘Rooteentsi nomonkaatero maawaeni ikowakaakinari Pawa. Nokoyi noya pipankoki, notsipateeyarini maawaeni niyotaanewo’ ”. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Roojatzi riyaatantanaka, imonkaatakiro maawaeni okaatzi ikantakiriri riwetsikaeyapaakini royaari. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Otsitenitantanakari, itsipateeyakinani Jesoshi naakapaeni riyotaanewo, riyaateeyapaakini janta rakiyoteeyakinani maawaeni janta. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Eenirowa nowaeyanakani maawaeni, roojatzi ikanteeyantanakinani rirori Jesoshi: —Kyaaryo nokantemi: iroñaaka jaka pikaatzika, eenitatsi aakaantenani. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Roojatzi osheki nowashiretanteeyanakani, ikanteeyanakini apaanipaeni: —¿Naakama, Nowinkatharite, aakaantemini? Eejatzi paashinipaeni ikantziri: —¿Nowinkatharite, naakama aakaantemini? ");
INSERT INTO cjoNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ikanteeyanakinani: —Rirotaki irika ochaantakotakinari iroñaaka nowiratoteki rirotaki aakaantenani. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Okenkithatakotzitakinani Iwaperite Tajorentsi paerani, aritaki nomonkaatakiro maawaeni okenkithatakotanari. Omaanta osheki rowashironkaaperotanakya riraga aakaantenani. Eero ikoñaatzimi paerani irira, eeromi rowashironkashitarimi Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Roojatzi rojampitantari Joorashi rirori: —¿Naakama, iyotaanari, aakaantemini? Ikantawakiri: —Jee, eerokakya. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Rooteentsi nothonkimatero noya, raakiro riraga Jesoshi paa, ipaasonkiwentakawo. Roojatzi ikagaakiro, ipaeyakinani naakapaeni, ikantana: —Ajaa, payero, poyaawo. Okimitaka nokagaakimiro paa, tema naakataki oshiyakaawenteenchari, paata nokamawenteeyemini. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Roojatzi raakotantakawo awishoowaantsi oowa pajoki, ipaasonkiwentakawo. Ipakoteeyakinani, ikanteeyakinani: —Ajaa, pimiriteeyeni maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Rooma iroka oshiyawitawo niraa. Paata aririka nokamawentakimi, napaatawentemi niraa, ineshironkatantemiri Tajorentsi. Aririka pameentena, eero ikenkithashireero kaari kameethatatsi pantziri. Owakirari inimotaakina iroka nokantakimiri, piyotantyaari tsikarika pikantya pawijakotanteeyari eerori eejatzi maawaeni atziri. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Iroñaaka eero napiitziro nomiritziro awishoowaantsi oowa. Iinja aririka napiitero nomiritero, aritaki nokaateeyemini amiritero owakiratatsiri awishoowaantsi oowa janta Tajorentsikinta. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Nomampaawenteeyakarini Tajorentsi, roojatzi riyaatakaanteeyanakinani janta tonkaariki oetachari Oriiwomashi, notonkaaneentanaki maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Roojatzi ikanteeyanani riraga Jesoshi: —Iroka tsitenirika, aritaki pookaeyanakinani eerokapaeni, maawaeni. Rooma paeraniperoroña ikantakotzitana Tajorentsi Iwaperiteki ikantzini: “Noshineteririka rowamaeri riraga kempoyiiriri rowishatepaeni, ishiyeeyanakyaani, rotsipareeyawakaanakyaani”. Iroka rojankinatziro Jakariiyashi riraga kamanantzirorini iñaani Tajorentsi paeraniperoroña. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Omaanta aririka nopiriintanee nañagae, neewataneemi janta Karireeyaki, ari piñeena janta. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Roojatzi ikantziri Peetero: —Aririka rookemi irikapaeni maawaeni, omaanta naari, eero nookimi. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ikantawakiri: —Kyaaryo, iroka tsitenirika, tekirarika iñee tyaapa, ari okaate 3 pikante: “Tee niyotziri Jesoshi”. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ikantawitari: —Aririka notsipatemi akame, omaanta eero nokantzi: “Tee niyotziri Jesoshi”. Eejatzi nokanteeyawitakani maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ikantaka rareetakagaeyapaakinani riraga Jesoshi janta oriiwomashiki owaero Jethemaniiki, ojeeki janta tonkaari owaero Oriiwomashi. Ikanteeyapaakinani rirori: —Pijeekawakiita jaka. Niyaatakiteeta janta nokenkithatakaakiteriita Pawa. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Raanakiri riraga Peetero, eejatzi itomi Sewereeyo apite. Osheki retakotanaka riraga Jesoshi, antawo ikenkithashiryaanakiro okaatzi awijimoterini. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Roojatzi ikantziri: —Osheki netakotanakaroña. Pijeekawakiita jaka, pikakiterapa. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Roojatzi ijanthawitanaka eechonkiini, romaryaapaaka tankimotapaaka kipatsiki, ikenkithatakaakiri Ashitariri, ikantziri: —Pawa, tee nokowawita nokemaatsityaawomi katsiri, omaanta eero nantashitawo nokowawitari naari, inta nantemiro pikowakaakinari eerori. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Roojatzi ipiyashitapaari riyotaanewo 3, iñaapaatziiri imagaeyakini maawaeni. Ikantapaakiri riraga Peetero: —Tema pamaweneentziro piwochokini, ¿tee pimatziro pikakineentzi eechonkiini? ");
INSERT INTO cjoNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Pikakite, pamaneri Tajorentsi ramitakotantemiri eero panantawo kaari kameethatatsi. Kyaaryo, pikowawitaka pantaperoteromi maawaeni nokowakaakimiri, omaanta tee pimatziro. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ikantaka rapiitakiro ipiyanaka jaga, ikantziri: —Pawa, pikowakaaperotakinaworika nokemaatsityaawo katsiri, kameethataki. Aritaki nomatakiro, nomonkaatero maawaeni pikowakaakinari. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ari ipiyapaa iñaapaeri riyotaanewo 3 imagaeyakini. Osheki ayimaperotakiri iwochokini. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Roojatzi riweyaantapaentawo ipiyanaka, ikenkithatakaayiri Iriri. Roojatziita rapiitapae ikantakiriri inkaaganki. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Roojatzi ipiyashitakari riraga riyotaanewo, ikantapaakiri: —¿Pimaatzi? Iroñaaka monkaatapaaka. Iroñaaka ikantakowentenakya kaari kameethatzinkari, iroñaaka raaneena. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Pipiriinte, thame aate. ¡Pamine sha! Kaakitapaaki irinta aakaantenani. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Iroñaaka ipokashitantapaakari Joorashi, riraga riyotaanewo naawita Jesoshi. Ipokashitapaakiri, reewatapaakiri rirori oshekini atziri. Maawaeni ramaeyakironi antawo rowejamento eejatzi ipajamento wetsikachari inchato. Ipoñaanaka janta jewatayitatsirini ñaanakowenantatsiripaeniki eejatzi aataperoteenchari. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ari, ikamantanakiri inkaaganki riraga Joorashi irirapaeni: —Nonintapootapaakiri Jesoshi, piyotantyaariri. Rirotaki paerikapaakiri eerori. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Roojatzi ipokashitantapaakari, ikantapaakiri: —¿Eeniromi, iyotaanari? Roojatzi inintapootapaakiri. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ikantawakiri rirori Jesoshi: —Notsipatanewo, ¿iitaka pipokashitziri jaka? Pantero iroñaaka. Roojatzi ipokashitantapaakariri maawaeni roerikapaakiri, shepik. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Roojatzi inojokiryaakiro paashini riyotaanewo Jesoshi rashi rowejamento. Ikowawitaka ichekawakirimi iitoki riraga ronampiri iwinkatharite ñaanakowenantatsirini, omaanta apatziro ichekawitawakari ikempita. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ikantziri riraga Jesoshi: —Powaero powejamento ipiyatzimikari. Rooma ichekaetawakiri rirotaki chekantapiintatsiri. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Rooma piyotzi nokowakirikami, nokanterimi Pawa, roojatzi rotyaantenarimi oshekiniroña ronampiri ikijakowentenami. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Omaanta ikijakowentenarikami, rowawijaakotenarikami, eero nomonkaatziromi okantakotanarini Iwaperite Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Roojatzi ikanteeyawakirini riraga maawaeni pokashitapaakiriri: —¿Iitaka pamantawori powejamentopaeni eejatzi pipajamentopaeni kimitaka naaka koshintzi? Piñaapiintana maawaeni kitejiri janta Tajorentsipankoki, niyotaapiintziri atziri, tee payitanakya chapinki. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Omaanta rootaki paantanari iroñaaka omonkaatantyaari rojankinatakotzitanarini riraga kamanantayitzirorini iñaani Tajorentsi Iwaperiteki. Roojatzi nothaawantanaka naaka riyotaanewopaeni, noshiyanaka maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ari, ragaetanakiri riraga Jesoshi janta ipankoki Kaejashi, riraga iwinkatharite ñaanakowenantatsiripaeni Tajorentsipankoki. Ipiyotakanta janta riraga iyotaantzirori Iwaperite Tajorentsi eejatzi aataperoteenchari. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Roojatzi rimpaetanaki Peetero janta inteenaneente roojatzi rareetantyaari ipankoki Kaejashi riraga iwinkatharite ñaanakowenantatsiri. Ikyaapaaki otaamapetaataga mapi, ijeekapaaki okaankiityeera. Itsipatapaakari waariryaapaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Roojatzi riraga iwinkatharite ñaanakowenantatsiri, riraga paashini jewawentayitziririni irirapaeni eejatzi paashinipaeni jewatayitziririni ikowanaki atziri itheeyakotashityaarini Jesoshi rootaki, ari rowamaakaananteetyaariri rirori. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Roojatzi eenitatsi oshekini theeyakotawitakariri, omaanta tekatsi ikanteri rowamaakaanantyaariri. Roojatzi ipokapaaki paashini apite theeyakotapaakariri, ");
INSERT INTO cjoNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ikantapaaki: —Ikantzi irika: “Noshekiroreero Tajorentsipanko; okaate kitejiri 3 aritaki nowetsikaero”. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ikatziyanaka iwinkatharite ñaanakowenantatsiri, ikantanakiri: —¿Tekatsima pikanteri eerori? ¿Oetaka pikantziriri iroka ikantakotzimiri? ");
INSERT INTO cjoNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Omaanta imaeritashitaka riraga Jesoshi. Rapiitakiri rirori ikantanakiri: —Tema iñaakimi Tajorentsi, riraga Añaaperotatsiri. Pikantaperotena: ¿eerokama Itomi Tajorentsi riraga Rotyaantanewo? ");
INSERT INTO cjoNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ikantziri: —Naakataki. Naaka poñaachari jenokinta, natziritapaaki jaka kipatsikika. Iinja piñeenani nojeeki rakoperoki Tajorentsipero, eejatzi iinja piñaawakinani nokinapaakini menkoriki, nopiyapae jaka kipatsikika. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Roojatzi ikijantanakari rirori maawaeni, rootaki itzijagaakotantanaka iithaariki. Ikantzi: —¿Pikemakirikya ikantziri? Tee okameethatziroña, iitajorentsitakimiwee. ¿Iitakama akowantari paashini kantakoterini? ");
INSERT INTO cjoNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Iitaka pikenkithashireeyirini eerori? ¿Tsikama akanterika? Ikanteeyirini: —Eenitatsi rantani. Okameethatzi ikame. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Roojatzi ipokapaaki rirori maawaeni reewapootakiri ipookira. Eejatzi ikapojayitakirini. Rontajawootakiri tak, tak, tak. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Ikantziri: —Rotyaantanewo Tajorentsi, pikantena: ¿ninka kapojakimirika? ");
INSERT INTO cjoNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Riraga Peetero eenirokya ijeeki janta inkokironta. Oñaawakiri onampirentsi okantawakiri: —Eeroka tsipatariri Jesoshi, riraga karireeyajatzi. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Rakanakiro: —Tee niyotzi oetarika pikantanari. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Roojatzi rawijanaki janta ikyaawitapaakaga, eenitatsi paashini onampirentsi oñaawakiri roori, okantziri: —Pamine sha, irika tsipatariri Jesoshi, riraga najareetejatzi. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ikantanakiro: —Tee niyotziri irika pikantakinari. Teerika okyaaryootaki iroka nokantakimiri, nokowaki rowashironkayenaata Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ro ojamaniwitanaka eechonkiini, ipokapaaki paashini ñaawakiriri, ikantapaakiri: —Kyaaryo, eerokakya tsipatariri. Nokemakiro piñaawaetaki, eerokakya karireeyajatzi. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ikantanakiri: —Teewee, tee niyotzirikya irika shirampari pikantakiri. Riyotzi Tajorentsi kyaaryo nokantakimiri. Teerika okameethatzi nokantakimiri, nokowaki rowashironkayenaata Tajorentsi. Roojatzi iñaantanaka tyaapa. ");
INSERT INTO cjoNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Roojatzi ikenkithashiryaawakiro ikantziriri Jesoshi: “Tekiraata iñee tyaapa, okaate 3 pikante: ‘Tee niyotziri Jesoshi’ ”. Roojatzi riyowanaki, riraapaaka jmmm, jmmm. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Owakira okitejitanaki, ikenkithawaetakaawaka riraga jewatayitziririni ñaanakowenantatsiri eejatzi aataperoteenchari ikantawakaaka: —¿Tsikama akanterika iroñaaka Jesoshi owamaakaanantyaariri? ");
INSERT INTO cjoNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Roojatzi roojotakiri, raanakiri janta ijeekinta pinkathari iitachari Peraato. Irinta kaari joriiyo inta rirotaki oroomajatzi. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ipoñaashitanaka Joorashi riraga aakaantakiriri Jesoshi riyotaki rowamaakaantashityaari irinta, omaanta tekatsi rantawita kaari kameethatatsi. Riyotakotanaka, osheki ikenkithashiryaanaka, roojatzi ipiyantanaka Tajorentsipankoki roepiyapaeniri 30 ikithoki koriki ipinawitakariri chapinki raakaanantakariri. Raminapaakiri jewawentayitziririni ñaanakowenantatsiripaeni eejatzi aataperoteenchari. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","—Ajaa, piyorikite. Tee okameethatzi iroka nantakiri: tema naakaantashitakari Jesoshi. Tekatsi rantawita: ikamashitya iroñaaka. Omaanta ikanteeyawakirini irintapaeni: —Omawitya, eerokaritya. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Roojatzi rookanakiri iyorikite, romanatanakiri, patareei, janta Tajorentsipankoki, ishiyanaka roojatzi ishirikantapaaka. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ari, riraga jewawentziriri ñaanakowenantatsiri ragaatziri koriki, ikantzi: —Tee okameethatzi jaka akempoyeeri irika korikika. Rooma rirotaki apinatakiriri Jesoshi raakaanantyaariri. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Roojatzi ikenkithatakaawaka: —¿Tsikama akanterika korikika? Ikantzi: —Thame amanantero kipatsi akitatantyaariri kamatsiri riraga poñaachari paashiniki kipatsipaeni. Rootaki ramanantakawori kipatsi oetachari ragaetapiintziri kipatsi kowitzipitha. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Paerani roojatzi iroñaaka iiteetziro rowaga kipatsi: “Iwinawo Jesoshi raakaanantakariri”. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Imonkaatakiro rojankinatzitakarini paerani Jeremiiyashi: “Raaneeri 30 ikithoki koriki riwetsikanteetariri iraata oetachari piraata. Rirotaki iwinawo raakaanantyaariri Rotyaantanewo Tajorentsi. Eero roshekitzi koriki ipinatantawityaariri. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Rirotaki ramananantyaawori kipatsi janta ragaetapiintziri kowitzipitha. Rirotaki Awinkatharite kanterini ramanantero kipatsi”. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ari, ragaetanakiri riraga Jesoshi janta ijeekinta pinkathari iitachari Peraato, ikatziyimotapaakari. Ikantawakiri irira: —¿Eerokama iwinkatharite joriiyopaeni? Ikantapaakiri: —Jee, naakakya. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Roojatzi ikijakiri riraga jewawentayitziririni ñaanakowenantatsiripaeni eejatzi riraga aataperoteenchari ithawetakotakiri, omaanta imaeritashitaka rirori, tekatsi ikantzi. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ikantawakiri riraga Peraato: —¿Tema pikemakiri ikantakotzimiri? ¿Iitaka kaari pikananta eerori? ");
INSERT INTO cjoNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Tekatsi ikantzi Jesoshi, tee rakiri. Roojatzi rotsikanatanakariroña riraga ikenkithashiryaanaka. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ari maawaeni ojarentsi, aririka omonkaataka kitejitatsiri rawijantanakarini paerani ronampiri Tajorentsi Ejiipitoki, riraga Peraato ikantapiintawakiri maawaeni jeekatsiri: —Eeniro ijeeki oshekini pinampijatzi janta omonkyaagamentotsiki. ¿Pikowakima noemishitowaemiri apaani omonkyaagaarewo? Rootaki ikantapiintziri maawaeni ojarentsi roemishitowapiintziri omonkyaagaarewo, ninkarika ikoyiri joriiyopaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Eeniro ijeeki omonkyaagamentotsiki shirampari ikemakotakiri joriiyopaeni, iitachari Warawaashi. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Roojatzi iroñaaka kitejiri ipiyotaka oshekini atziri, rootaki ikanantawakariri: —Piyotzi nametakawo noemishitowaemiri apaani jeekatsiri omonkyaagamentotsiki. ¿Ninkama pikowakiri noemishitowaemiri iroñaaka? ¿Rirotakima Warawaashi? Teerika pikoyiri irira, ¿rirotakima pikowaki irika Jesoshika, riraga piitziri Rotyaantanewo Tajorentsi? ");
INSERT INTO cjoNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Riraga Peraato riyotakotziri jewatatsiripaeni joriiyopaeni osheki ikijashitari riraga Jesoshi; tema tee ikowakayaari riraga joriiyopaeni royaateri rirori raapatziyari. Rirowitaka ikanterimi maawaeni joriiyo: “Nokowaki poemishitowaenari riraga Jesoshi”. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Eejatzi inkaaganki otyaantakiri iina riraga Peraato kantziriri: “Okantzi piina: ‘Eero powamaakaantziri riraganki, ikameethaperotaki. Nomishitawakiri inkaaganki, osheki nokenkithashiryaakotawakiri’ ”. Rootaki kaari ikowantawita rowamaakaanterimi. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Omaanta riraga jewatayitziririni ñaanakowenantatsiripaeni eejatzi aataperoteenchari ikantziri riraga atziripaeni: —Pikanteri: “Poemishitowaeri Warawaashi. Riraga Jesoshi, pikentakotakaanteri”. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Roojatzi rapiitawakiri, ikantawakiri riraga Peraato: —Pamine sha, ikaataki apite. ¿Ninkama pikowakiri noemishitowaemiri? Ikantzi maawaeni: —¡Warawaashi! ");
INSERT INTO cjoNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ikantawakiri: —¿Tsika akanterika irika Jesoshika, riraga iiteetziri Rotyaantanewo Tajorentsi? Ikantakiri maawaeni: —¡Pikentakotakaanteri! ");
INSERT INTO cjoNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ikantawitari rirori: —¿Iitama rantakiri nokentakotakaanantyaariri? Eekiro ikaemapaakitzi: —¡Pikentakotakaanteri! ¡Pikentakotakaanteri! ");
INSERT INTO cjoNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Osheki ikijanaka maawaeni. Riyotanaki riraga Peraato ratsipetashitaka rojampitawitakari. Ikanantakariri riraga ronampiri: —Pamakotenawoota iñaa. Ramakotakiniri, roojatzi ikiwawakotaka rako riyotantyaari atziri tee ikowawita rowamaakaanteri riraga Jesoshi. Tee ikowawita, roojatzi ikantawakiri: —Kaari naari kowatsini nowamaakaanteri, kaari. Pikowakirika eerori, eerokamacheetaka kentakotakaanterini. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ikantakiri: —Nokowaperotaki, rooma naakakya kantakimiri. Kameetha ikijenaata naari Tajorentsi, eejatzi kameetha ikijeri maawaeni notyomi nashi. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Roojatzi roemishitowakiri riraga Warawaashi. Roemishitowakiri, ikantawakiri riraga joraaro: —Paaneeri Jesoshi, powajankiteri, roojatzi pikentakoteri. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ikantaka joraaropaeni raanakiri irira janta ipankokira pinkatharentsi, roojatzi ikaemapaakiri paashinipaeni joraaro. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Roojatzi raatonkoryaakiri iithaari. Ikithaatziri paashini kithaarentsi kityonkamawoneentatsiri. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Roojatzi riwetsikantakanari amantheerentsi kitocheetatsiri ramantheetakaakiri. Eejatzi ipakiri kotzitsi, ikantziri: —Poerikiro pikotzi. Riraga jewawenantatsiri paerani rametakawo ikithaatapiintawo kityonkari, ramantheetawo ramantheeri pinaperotachari, eejatzi roerikapiintziro ikotzi pinatachari. Roojatzi rotziwerowashitapaakari, roshiyakaawaetashitaka ipinkathajeempiyaakari, ikantziri: —Eeroka, nowinkatharite. ¿Peewatanakimi, peewawenterimi maawaeni joriiyopaeni? Ishirontawentakari: —Injii, injii, injii. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Reewapootakiri maawaeni. Roojatzi raapithatanakiri ikotzi. Rompojantanakari iitokira. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Osheki ishirontawentanakari injii, injii, injii. Roojatzi raatonkoryaagaeri kityonkamawoneentatsiri, ikithaatakagaari iithaaripero, roojatzi raantanakari ikentakotantyaariri. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ikanta raanakiri joraaro riraga Jesoshi koroshiki. Romperatakari irira raaneero antawo inchato oetachari koroshi. Osheki otenatzi, ipomeentsiperotawo raaneero. Janta awotsiki itonkiyotawakari shireenejatzi iitachari Shimo. Romperatawakari joraaro ikantziri: —Ajaa, koroshi, paaneeniri irika. Roojatzi itsipatanakari, raanakiniri koroshi. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Roojatzi rareetapaaka maawaeni tonkaariki oetachari Koorikota. Ari aetziro aari apaanteki: iitonakintsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Areetapaaka, ipawiteetapaakari riraga Jesoshi awishoowaantsi oowa otsipatakawo kepishiyanto. Ikemijantawitawakawo, tee ikoyi rirero. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Roojatzi ikentakotakiri joraaropaeni koroshiki. Roojatzi rowatzikakotakiri. Eejatzi iñaathawaetaka irirapaeni riyotantyaari ninkarika aakironipa iithaari. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Roojatzi ijeekantanaka jaga, raminakowenteri riraga Jesoshi. Ro ijeekantakari, raminakowenteriita, rowawijaakotzirikari paashini atziri. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Eejatzi inkaaganki rojankinatakoetakiro owaanini inchakotaki: “Irika rirotaki Jesoshi iwinkatharite joriiyopaeni”. Roojatzi ikentakoetakiro jeñokiiniki iitoki Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Eejatzi ikentakotakiri apite koshitantatsiri; apaani rowatzikakotakiri rakoperoki riraga Jesoshi, eejatzi paashini rowatzikakotakiri rampateki. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Eenitatsi oshekini atziri awijayitatsirini awotsiki ininatakiri riraga Jesoshi. Rotekayinatapaaka irinta. Ishirontawentapaakari, injii, injii, injii. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Ikantapaakiri: —Pishekiroreeromi Tajorentsipanko, okaate kitejiri 3, piwetsikaeromi. Ajaatya, powawijaakotya eeroka. Eerokarika Itomi Tajorentsi, ari payiite jaawiki. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Eejatzi ikimitaka riraga jewatayitziririni ñaanakowenantatsiri eejatzi riraga iyotaantayitzirorini Iwaperite Tajorentsi, eejatzi riraga warijeeyopaeni, eejatzi riraga aataperoteencharipaeni ishirontawentakari. Ikantzi: ");
INSERT INTO cjoNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Rowawijaakotakiri apaanipaeni anampijatzi, omaanta iroñaaka tee imatziro rowawijaakotya rirori. Thame aminawakiriita, rirotakirika awinkatharite kimitaka pikantzi, kameetha rayiite jaawiki iroñaaka. Rayiiterika jaawikika, ari aapatziyanakyaari aaka. Injii, injii, injii. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Tema ipinkathatawitarira Tajorentsi rirori: rowawijaakoteriita iroñaaka. Aamaashitya aritaki rowawijaakoterimi itomi, rooma ikantzi: “Naakakya Itomi Tajorentsi”. Injii, injii. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Eejatzi ikimitaka riraga koshintzi ikentakoteetakiri, ishirontzitaka rirori. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ikaataki oorya tampatsika, omapokapaaka otsitenitanaki maawaeni kipatsi, roojatzi shaawiteni. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Rooteentsi okitejitanee, antawo ikaemanaki Jesoshi, ikantzi: —Erii, Erii, ¿raama jawaatani? Rootaki akantziri apaanteki: “Notajorentsite, Notajorentsite, ¿iitaka pookantanari?” ");
INSERT INTO cjoNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ikemantawakariri riraga jeekaneentsiri, ikantzi: —Pikemiri, ikaemiri Iriiyashi. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Roojatzi ishiyanaka atziri, rowiinkakiro piyonkashinkanari awishoowaantsi oowa kepishaari. Rojataakiro chekopikira rowaankakotanakiniri riraga Jesoshi, rajookawakiromi. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Omaanta ikantziri paashinipaeni: —Eero pantziro. Thame aminawakiriita aririka ipokashitapaakiririka Iriiyashi rowawijaakoteriita. Injii, injii. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Roojatzi rapiitziro ikaemi. Antawo ikaemi. Roojatzi ikamantanaka. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ikamantaka Jesoshi, omapokanaka otzijagaanaka antawoni otzikaakiro janta Tajorentsipankoki inthomaenta. Tontari ironta, otzikaakiro omookira. Omapokanaka itanaka jenoki otzijagaanaka owaag, roojatzi jaawiki, apitemankitanaka. Eejatzi omoyekanaka kipatsi, moye, moye. Okotaanaki antawo mapi maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Eejatzi rashitaryaakotanaka ijeekira kaminkari, ipiriintanaka oshekini aapatziyariri Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Rimpaetaki ipiriintanaa Jesoshi, riyaateeyanakini Jerojareeki. Iñeeyawakirini oshekini atziri. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Eejatzi riraga omperatariri joraaro eejatzi joraaropaeni riraga kempoyaakiriri riraga Jesoshi iñaawakiro omoyeka kipatsi eejatzi iñaawakiri riraga piriintayitaneencharini, iñaawakiro otsitenitanaki, maawaeni. Roojatzi ithaawantanakariroña, ikantzi: —Kyaaryo, rirotaki Itomi Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Eejatzi jaga, eeniro oshekini tsinani aminawaetawakiri riraga Jesoshi. Rootaki oyaawaetanakirini, opoñeeyakani Karireeyaki. Kijokiro owapiintanakirini, oneshironkatzirini, opapiintzirini rowanawo. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Okaatakiro Mariiya rowaga makaraarajato; paashini Mariiya rowaga riniro Jantyaako eejatzi Josee; eejatzi paashini rowaga riniro Jantyaako eejatzi Jowa, rirojatzi itomi Sewereeyo apite. Roojatzi oñaawakiri rirori, ikamanaki. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Rooteentsi otsitenityaanaki. Eeniro riyaatanaki apaani riyotaanewoni Jesoshi iitachari Josee. Ipoñaaka irinta Arimateeyaki; rirotaki ashaagantzinkari. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Riyaatashitanakiri riraga Peraato, ikantapaakiri: —Kamaki Jesoshi. Nokowaki pishinetena naaneeri nomonkeeri omooki janta, riwetsikaetzinirinta kamatsiri. —Jee, ari. Roojatzi ikaemiri joraaro, ikantawakiri: —Pishineteri irika raaneeri. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Roojatzi riyaataki rirori Josee, raakitziri, raanakiri, roojatzi rapineetakotanakiri tokoyakira kitetatsiri. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Roojatzi romonkyaanakiri omooki, rowaga owakira imokaetziro mapi impeetaki. Ipineero, rotzitakiro antawo mapi omookira, rashitakotantakariri. Roojatzi riyaatapithatantanaari. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Eenitatsi eejatzi janta Mariiya, rowaga makaraarajato, eejatzi ojameto otsipatakawo. Opokaki, roojatzi ojeekaki okaakinira omoo. Aminakowenantawakariri rirori romonkyaanakiri. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Rawijantanakawo kitejiri ikentakotantariri Jesoshi oetachari Kitejitatsini rawijantanakarini Ronampiri Tajorentsi paerani Ejiipitoki. Okitejitanaki riyaatashitapaakiri jewatayitziririni ñaanakowenantatsiri eejatzi warijeeyopaeni janta Peraatoki. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ikantapaakiri: —Nowinkatharite, nokemawakiri ikantzi chapinki riraga amatawitantatsiri: “Nokame, roojatzi okaate kitejiri 3, ari nopiriintanee nañagae”. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Nokowaki potyaanteri joraaro iroñaaka ishentaperotero omoo janta romonkyaagaetakirinta. Raminaperotero roojatzi omonkaatantyaari kitejiri 3. Riyaatashitzirikari riyotaanewoni raanakirikari, roojatzi ikantzirikari atziripaeni: “Piriintanaa Jesoshi, rañagae”. Paerani osheki ramatawitantzini irinta Jesoshini, omaanta aririka raaneeri riyotaanewo rirori, ramatawitaperotzirikari irintapaeni anampijatzi, ikantzirikari: “Piriintanaa Jesoshi añagae”. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ikantawakiri rirori Peraato: —¡Ajaa, joraaropaeni! Paanakiri janta raminaperoteroota omoo. ");
INSERT INTO cjoNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Roojatzi riyaatantanaka, rashitakoperotakiri, roojatzi ishenteeyakironi riraga joraaro. ");
INSERT INTO cjoNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Awijanaki kitejiri imakoryaantari, iroñaaka otominkotapaaki. Eeniro otsitenineentzi, opiyaka janta Mariiya makaraarajato, eejatzi otsipatakawo ojameto. Iyaatantari aminashityaawo omoo omonkyaagaetakirinta riraga Jesoshini. ");
INSERT INTO cjoNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Omapokanaka antawo omoyekanaka kipatsi rareetapaakaga ronampiri Awinkatharite, poñaaneenchari jenokinta. Ipokantapaakari ipinaapithatapaakiri mapi, roojatzi ijeekantapaakawo. ");
INSERT INTO cjoNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Osheki ishipakiryaapaaki. Ikimitakawo raamorenkiranki tariito osheki ishipakiryaaki. Kitamaaperori iithaari. ");
INSERT INTO cjoNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Oshekiroña ithaawantawakari rirori maawaeni joraaro. Tee imatziro ishewata, kimiwitaka kamanaki. ");
INSERT INTO cjoNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Roojatzi opokapaaki tsinanipaeni, othaawantapaakari eejatzi, omaanta ikantziro rirori: —Eero pithaayi eerori. Niyotaki pipokashitawitari pamineri Jesoshi, riraga ikentakoteetakiri. ");
INSERT INTO cjoNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Tee añiiri iroñaaka, piriinta, añagae. Rooma ikantakiminikya paerani, monkaataka. Paminerotya romaryaanteetawitakaririka, tekatsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Iroñaaka intsipaete piyaate pikanteriita maawaeni riyotaanewo: “Ipiriintanakiri Tajorentsi Awinkatharite, añagae eejatzi. Reewatemi Karireeyaki. Iroñaaka piyaate eeroka, aritaki piñeeri janta”. Rootaki nopokantari nokantemi. ");
INSERT INTO cjoNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Roojatzi owaperotanakiroroña, eejatzi osheki okimoshiretanakiroña; iyaatanaki oshiyashitanakina naakapaeni riyotaanewo okantena. ");
INSERT INTO cjoNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Niyanki romapokapaakiro riraga Jesoshi, riwethatapaakawo, ikantziro: —¿Eeroka? Roojatzi iyotawakiri, iyaatashitapaakiri, otziwerowashitapaakari, roojatzi oerikapaakiri iitzikira. Osheki opinkathatapaakiri. ");
INSERT INTO cjoNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Roojatzi ikantawakiro: —Eero pithaayi. Piyaateeyini iroñaaka, pikanteri maawaeni niyotaanewo riyaate janta Karireeyaki. Aritaki iñaapaakina janta. —Jee, ari. ");
INSERT INTO cjoNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Rootaki opokashitantanari okantapaakina, eejatzi irinta joraaropaeni riraga aminawitawori omoo ipiyanakawo nampitsikinta riyaatashitanakiri jewatayitziririni ñaanakowenantatsiri ikamantapaakiri maawaeni oetarika awijaneentsiri. Ikemawakiri rirori. ");
INSERT INTO cjoNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Roojatzi ipiyoteeyakirini jewatayitziririni joriiyopaeni eejatzi aataperoteencharipaeni riyotaawakaaka, ikanteeyakini: —¿Iroñaaka tsika akantyaaka amanakotantyaariri? Roojatzi ikaemakaantakiri maawaeni joraaropaeni, ikantawakiri: —Ajaa, koriki, osheki nopinatemi. ");
INSERT INTO cjoNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Rootaki pikanantyaariri atziripaeni: “Ragaetaatziri Jesoshini, rooma nomaanakitzi eechonkiini niyankiiteni tsiteniri. Okimitaka ipokapaaki riyotaanewopaeni Jesoshini raapaentziri”. ");
INSERT INTO cjoNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Aririka ikemakowentawakimi pinkathari, aritaki niyaataki naari janta nokamantakowentemi eero rowajankitantzimi. ");
INSERT INTO cjoNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Roojatzi raakiri koriki ipinateeyakirini jewatayitziririni joriiyopaeni, riyaatanaki itheeyawaetaka, imonkaatakiro maawaeni ikamantakiri. Rootaki ikantakiri maawaeni joriiyopaeni roojatzi iroñaaka, tee riyotzi kyaaryooperorika rañagae Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Paashini kitejiri niyaatanaki naaka riyotaanewopaeni Jesoshi 11 tonkaariki janta Karireeyaki ikenkithatakotakiri chapinki Jesoshi tekira ikamini. Tekatsi itsipatanewoni iroñaaka Joorashini, rooma kamaki. ");
INSERT INTO cjoNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Iñaanteeyapaakaririni, ipinkathaperotapaakiri, ikimoshirewentakiri. Omaanta apaanipaeni ikantashiretzi: —¿Rirotakima Jesoshi? ");
INSERT INTO cjoNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Roojatzi Jesoshi romapokapaakina ikanteeyapaakinani maawaeni: —Iroñaaka Pawa iitakina itzinkami jenokinta eejatzi kipatsika. ");
INSERT INTO cjoNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Rootaki notyaanantemiri piyaate maawaeniki nampitsi, piyoteeri maawaeni atziri raapatziyena, eekiro riyaatatyee rameentena, pithotyeeyanakironi maawaeni kipatsi. Aririka raapatziyakimi atziri riyotanakirorika naaka owawijaakotakiriri, kameetha pikaawoshitakoteniri Tajorentsi. Rootaki ikowakaakiriri Pawa, eejatzi nokowakagaeyakiririni naari, eejatzi okowakagaeyakiririni Ishire Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Eejatzi pikamanteeyerini maawaeni imonkaatero maawaeni kameethatatsiri nokamantakimiri eerori. Naari kijokiro nowanakimi, nokempoyeemi, eejatzi maawaeni aapatziyanari; roojatzi nopiyanteeyari nopinkatharitantapaakyaari kipatsikika. Ari okaatzi. Naaka jankinatzirori: Mateeyo");
INSERT INTO cjoNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Iroñaaka nokamantemiro kameethatatsiri. Nokamantemi rowawijaakotantzi Jesokirishito. Tema rirotaki Itomi Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Paerani eenironi ijeekini kamanantzirorini iñaani Tajorentsi iitachari Iseeyashi. Rojankinatakotzitakarini Tajorentsi ikantziriri itomi: “Pikemina, notyomi. Notyaanteri kenkithatakotemini, reewatanakimi. Tema ari ikanteri maawaeni atziri: ‘Paamayarirapa Awinkatharite, pikameethashiretanaki’. ");
INSERT INTO cjoNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Eenitatsi iinja atziri kenkithatakayerini atziripaeni janta okaankiityeenta, ikanteri: ‘Paamayarirapa Awinkatharite. Pikameethatanaki iñaaperotantapaakimiri pikameethatzi. Aririka pikameethatanaki pikimityaawo awotsi kameethatatsiri ikinantapaakyaari Jewaperowenantatsiri: powameethatero iñaaperotanteeyapaakyaaworini’ ”. ");
INSERT INTO cjoNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Aritaki monkaatapaaka ikantzitakarini paerani Iseeyashini. Jowa riraga kaawoshitakotziriri Tajorentsi ijeekaki janta tekatsinta atziri ipanko, ikimitakiro rojankinatakotzitakaririni Iseeyashi paeraniperoroña. Ikantakiri maawaeni pokashitziriri: —Pikenkithashiryagaeyakya, eero pikimita paerani. Aririka pookaperoteero pantawitari, aritaki nokaawoshitakotakimiri Tajorentsi, roojatzi riyoteeyantanakyaani atziri ikaminthaaperotatziimi rirori, eero ikenkithashiryaakoteemiro pantayiwitakarini. ");
INSERT INTO cjoNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ikanta ipokashitapaakiri maawaeni jeekatsiri kipatsiki owaero Joreeya, eejatzi maawaeni jerojareejatzi, ikantapaakiri: —Eenitatsi kaari kameethatatsi nantziri. Nokowaki nawijakote, tema naapatziyaperotari Tajorentsi. Roojatzi ikaawoshitakotawakiniri riraga Jowa maawaeni romitsitsiyaakotawakiri iñaakira iitachari Joriraani. ");
INSERT INTO cjoNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Tee ikithaatawo Jowa kameethatatsiri, inta ikithaatawo ontyagaantsi iwitzi kameeyo. Ishirikathakitakari mashitsimashi. Rowapiintari kimitariri tsitsiri. Eejatzi ithotziri eechonkiini iyaa pitsi. ");
INSERT INTO cjoNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ikenkithatakaapiintziri maawaeni atziri ikantapiintziri: —Kaakitaki impaetakinari, riraga Rotyaantanewo Tajorentsi; tema ranaakotakina, ipinkathariperotzi irinta. Osheki noñaakoweenkatziri irira, omaanta naaka tee noñaakoweenkata. ");
INSERT INTO cjoNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nokaawoshitakotzimiri Tajorentsi iñaaki, omaanta riraga impaetakinari ikithaatakaapaakaero Ishire, amitakotanteeri. ");
INSERT INTO cjoNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Paashini kitejiri rareetapaaka Jesoshi janta ijeekinta Jowa. Ipoñaaka Najareeteki, jeekatsiri kipatsi iitachari Karireeyaki. Riraga Jowa ikaawoshitakotawakiniri Tajorentsi rirori iñaakira iitachari Joriraani. ");
INSERT INTO cjoNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Eenirowa othapyaaki iñaa, raminanaki jenokinta, roojatzi omapokapaaka iñaawakiro Ishire Tajorentsi, ayiitashitapaakiri Jesoshi, oshiyapaakari jamomo. ");
INSERT INTO cjoNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ikematziiri Tajorentsi ikantziri: —Eeroka notyomi nonintashireperotzimi. Osheki nokimoshirewentaperotakimi. ");
INSERT INTO cjoNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Roojatzi aanakiri Ishire Tajorentsi tekatsinta atziri ipanko, okaankiityeenta. ");
INSERT INTO cjoNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ijeekaki janta okaataki 40 kitejiri. Riraga Jatanaashi ipokashiwitakari iñaantawitapaakari, ikoyi rantakayerimi kaari kameethatatsi. Eejatzi tekatsi atziri itsipatyaari janta, omaanta rojatekaakari koweenkayitatsirini piratsi, omaanta ineshironkatakiri ronampiripaeni Tajorentsi, ipakiri rowanawo. ");
INSERT INTO cjoNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Paashini kitejiri ragaetanakiri riraga Jowa omonkyaagamentotsiki janta Jerojareeki. Roojatzi ipiyanaka Jesoshi Karireeyaki. Ikamanteeyakirini atziripaeni tsikarika ikanta Tajorentsi rowawijaakotantzi. ");
INSERT INTO cjoNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ikanteeyakirini: —Rooteentsi ipinkathariwentayiteeni Tajorentsi. Pikenkithashiryagaeya, pookaero panteeyirini eero pikimita paerani: tee pikameethawitani. Omaanta paapatziyeeyaarini Tajorentsi, pawijakotanteeyarini. ");
INSERT INTO cjoNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Paashini kitejiri ikinanaki Jesoshi ochereeteki inkaare jeekatsiri Karireeyaki. Iñaapaakiri Shimo, eejatzi rirentzi Antereeshi. Ishiryaatzi inkaareki: aritaki ikantapiinta, ishiryaatapiintziri shima. ");
INSERT INTO cjoNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ikanta Jesoshi ikaemapaakiri, ikantapaakiri: —Pipoke, thame poyaatanakina aritaki niyotaakimi paapatziyakaapiintyaari atziripaeni Pawa Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Roojatzi rookantanakawo ishiryaamento, royaatanakiri riyotaantyaariri. ");
INSERT INTO cjoNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ro ijanthawitanaka eechonkiini, iñaapaakiri Jantyaako itsipatari rirentzi Jowa. Rirotaki itomipaeni Sewereeyo. Ari ijeekaeyini ipitoki ishirikiro ishiryaamento. ");
INSERT INTO cjoNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ikantapaaka Jesoshi, ikaemakotzitapaakari, ikantziri: —Thame poyaatanakina. Roojatzi royaatanteeyakarini rirori iroñaaka. Intsipaete rookanakiri iriri ipitoki, itsipatayitanakarini ikaatzi amitakotayitziririni ishiryaatzi. Ikantzi: —Jatakinagapa, pawa. Noyaatatyeeri Jesoshi. —Jee, piyaate. ");
INSERT INTO cjoNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Roojatzi rareetapaa Jesoshi Kaperinawooki, ikaateeyirini riyotaanewopaeni. Rootaki saawaro, kitejitatsiri imakoreeyantarini joriiyopaeni, ikyaapaaki pankotsiki ipiyotantapiintarira irira. Riyotaapaakiri atziri. ");
INSERT INTO cjoNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Riraga atziripaeni, rotsikanateeyanakarini, ikantawakagaeyanakani: —Piñaakiri, kameetha riyotaantaperotaki, riyoperotzi irira. Tee ikimitari riraga iyotaapiinteeyawiteerorini Iwaperite Tajorentsi: tee riyoperotzi irirapaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Eenitatsi janta shirampari kyaantariri kamaari. Ikaemakotawakiri Jesoshi, ikantawakiri: ");
INSERT INTO cjoNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—Niyotakimi: eeroka riraga Jesoshi najareetejatzi, eejatzi eeroka Itomipero Tajorentsi riraga kameethaperotatsiri. ¿Iitaka pipokashitantanari? ¿Areetakama pithonkaeyantenarini? ");
INSERT INTO cjoNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Iñaashintsithatakiri rirori kamaari: —¡Pimaeritewee! Pishitowantaneeyari irira shiramparira. ");
INSERT INTO cjoNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ari rompetawathatakaakari shirampari, ishintsitanaki ikaemanaki, roojatzi rookantanaari kamaari. ");
INSERT INTO cjoNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Eejatzi rotsikanateeyakarini atziripaeni maawaeni. Rojampitawakaanaka: —¿Piñaakiroma imatakiri rantakiri? Owakira akemakiro iroka riyotaakaeri. Eejatzi imatakiri kamaari, rotyaantakiri: ithaawantaperotakari, jatanee. ");
INSERT INTO cjoNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Roojatzi intsipaete ikenkithatakotanteeyakarini maawaeni karireeyajatzi. ");
INSERT INTO cjoNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ipoñagaeyaani pankotsiki ipiyotapiinanta joriiyopaeni riyaateeyanakini ipankoki Shimo, eejatzi Antereeshi. Royaateeyanakirini Jantyaako eejatzi Jowa. ");
INSERT INTO cjoNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ikamanteetawakiri Jesoshi: —Ojaawamerikitatzi riyote Shimo. Eeniro jaga omaamentoki omaryaaka. ");
INSERT INTO cjoNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ari riyaatashitanakiro, ikathawakotapaakiro, piriintanaka. Roojatzi opeyantanaa ojaawamerikitzira, roojatzi opaeyantakarini rowanawo. ");
INSERT INTO cjoNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Rooteentsi itziroree oorya, ramayitakinirini Jesoshi maawaeni mantsiyari, eejatzi maawaeni kyaantariri kamaari. ");
INSERT INTO cjoNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Maawaeni nampitsiweri ipiyoteeyapaakani omooki pankotsi. ");
INSERT INTO cjoNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ijeekaeyapaakini maawaeni mantsiyari, inashitachari imantsiyaripaeni. Retsiyatakoeyeerini. Eejatzi ikantakiri kamaaripaeni: —Pookaeyaneerini riraga pikyaantanewo, eejatzi pimaeriteeyeni. Riraga kamaaripaeni, riyoteeyakirini Jesoshi rirotaki Tajorentsi, rootaki kaari ikowakaantari kamaaripaeni ikamanteri atziri. ");
INSERT INTO cjoNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Rootzimateentsi okitejite, ipiriintanaka Jesoshi. Riyaatanaki janta tekatsi jeekatsini, ikenkithatakaeri Iriri. ");
INSERT INTO cjoNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ikowakowateeri Shimo eejatzi ikaateeyinira itsipateeyarini. ");
INSERT INTO cjoNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Iñaantapaariri, ikantapaakiri: —Ikowakowaeyakimini maawaeni atziri. ");
INSERT INTO cjoNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ari ikantawakiri rirori: —Ari ikantawakaata. Thame aate paashinikipaeni nampitsi. Aritaki janta nokenkithatakagaeyerini paashinipaeni atziri, rootaki nopokantakari kipatsikika. ");
INSERT INTO cjoNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ikinakinayitanakini, ithotyaagaeyanakironi nampitsipaeni janta Karireeyaki. Ikenkithatakaapiintakiri atziri janta pankotsiki ipiyotantapiintarira joriiyopaeni, rowawijaakoeyakirini maawaeni kyaantariri kamaari. ");
INSERT INTO cjoNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Paashini kitejiri riyaatashitakiri patheenkari Jesoshiki. Patheenkari tee imatziro itsipatari paashini atziri. Tee oshinetziri Iwaperite Tajorentsi. Ari riyaatashitakiri rirori, rotziwerowashitapaakari ipinkathatantapaakariri, ikantapaakiri: —Tema eeroka pinkathari, pikaminthayena. Eenitatsi pitajorenka: pikoyirika petsiyatakoteena, ari pimatakiro. ");
INSERT INTO cjoNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Osheki retakotaperotawakari. Ari rakotashitawakiri, ipampitawakiri. Ikantawakiri: —Jee, nokoyi: aritaki petsiyatakotee. ");
INSERT INTO cjoNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Roojatzi opeyantanaa iwathaawo, etsiyatakotanee. ");
INSERT INTO cjoNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Rotyaanteeri, ikantaperotakiri: ");
INSERT INTO cjoNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Nokantemi: eerowa pikamantayitzirini paashini atziri, inta piyaatashiteri ñaanakowenantatsiri, poñaagapaeyaari etsiyatakoteemi, roojatzi ishineteemi pipiyashiteri atziripaeni. Pimonkaatero ikantzirini Moeseeshi: powamaeniri Tajorentsi pipira riyotantyaari atziripaeni etsiyatakoteemi. ");
INSERT INTO cjoNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ari riyaatanaki, omaanta ikamantakotayitakironi, maawaeni awijimotayitakiririni. Riyotakoeyakirini atziri Jesoshi, rootaki kaari riyaatantanaka nampitsiki. Ijeekakitzi janta okaankiityeenta. Ipokashiiyakirini atziri poñaayitacharini paashinipaeniki nampitsi. ");
INSERT INTO cjoNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Paashini kitejiri ipiyanaa Jesoshi Kaperinawooki. Ikemakoeyeerini areetapaaka rirori ijeekapaaki pankotsinentsiki. ");
INSERT INTO cjoNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ipiyoteeyakani osheki atziri, yeekitaki pankotsiki. Tekatsi ikinapaaki paashini atziri rotzikaapaakiro omoo. Ikenkithatakagaeyakirini Jesoshi iñaani Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ari inatakotapaakiri kijopookitatsiri. Ikaatzi 4 amiriri. ");
INSERT INTO cjoNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Tekatsi ikantya rontsirokyaari Jesoshi, rotzikaakiri atziripaeni. Roojatzi rateetakaantanakari jenoki pankotsi. Imoontapaakiro kameetha, apatziro rothataakotakiri ijeekakira Jesoshi. Royiitakotakiri imaamentoki. ");
INSERT INTO cjoNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Riyotawakiri Jesoshi rameenteeyakarini riraga 4 amakiriri, rootaki ikanantakariri riraga kijopookitatsiri: —Niyompari, ari nopeyakotakaemiro kaari kameethatatsi pantawitari, aritaki nowawijaakoteemi. ");
INSERT INTO cjoNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Eeniro jaga ijeekaki iyotaantzirori Iwaperite Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Ikenkithashireeyakani rajankaneki rirori: —¿Iitaka ikantashiwaetantari irika? Iitajorentsitashitaka. ¿Tsika ikanterika rowawijaakotantyaariri? Tema apatziro rowawijaakotantzi riraga Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Riyoshiryaakotakiri Jesoshi ikenkithashiryaari, ikantziri: —¿Iitaka pikenkithashiryaantari? ");
INSERT INTO cjoNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Iitaka pomeentsitaperotachani? ¿Opomeentsitama nokanteri irika kijopookitzinkari: “Eero nowashironkaemi, inta nowawijaakoteemi”? ¿Opomeentsitaperotama nokanteri irika kijopookitzinkari: “Pikatziyanee, paaneero pimaamento, pikatziyatziyawaetaneeya”? Eerorika imatziro, tema aritaki pishirontawentakina. ");
INSERT INTO cjoNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Nokowaki piyoteeyeni eenitatsi notajorenka nowawijaakotantyaariri. ");
INSERT INTO cjoNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Rootaki ikantakiriri kijopookitatsiri: —Nokantzimi, pikatziyanaki, paaneero pimaamento, piyaatee pipankoki. ");
INSERT INTO cjoNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Roojatzi ikatziyantanaka, raaneero imaamento, ishitowanee. Iñeeyawaerini ijoriiyotzinkaritepaeni, ari rotsikanateeyanakarini. Ikanteeyanakini: —Tema ikameethaperotzi Tajorentsi, tee añiiro paerani kimitawori iroka. ");
INSERT INTO cjoNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Paashini kitejiri piyanaa Jesoshi othapyaaki inkaare. Ipiyotashiteeyapaarini eejatzi osheki atziri, riyotagaeyerini. ");
INSERT INTO cjoNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Roojatzi rowaaganaa eejatzi. Iñaapaakiri Rewii, riraga itomi Arijeeyo, ijeeki pankotsiki ipiyotapiintziri koriki: ipiyotapiinteeyinirini oroomajatzi. Riraga joriiyopaeni roonakari piyotapiintziriri koriki. Omaanta ikantapaakiri riraga Jesoshi: —Thame poyaatanakina. —Jee, thametaatyaami. Ari ikatziyanaka, royaatanakiri. ");
INSERT INTO cjoNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","16","Ari riyaateeyanakini ipankoki Rewii. Rowakagaeyapaakarini osheki oyaateeyiririni Jesoshi, riyotaanewopaeni, osheki piyotapiintziriri koriki, maawaeni. Eejatzi rakiyoteeyakirini osheki paashinipaeni kaari kameethatzinkaripaeni. Rareeteeyapaakani iyotaantzirori Iwaperite Tajorentsi, rirotaki warijeeyo. Iñaakotapaakiri Jesoshi ikempiyeeyakarini rakiyoteeyirini kaari kameethatzinkaripaeni. Rojampitapaakiri riyotaanewopaeni: —¿Iitaka itsipateeyantaririni irikapaeni, rowaeyani? Tee ikameethateeyini. ");
INSERT INTO cjoNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ari ikemawakiri rirori Jesoshi, ikantziri: —Riraga kaari mantsiyatatsini tee ikoyi aawinantatsiri raawinteri, intakya mantsiyatatsiri rirotaki kowatsiri. Tee ro nopokantya nokaemeri kenkithashiryaachari kameethatatsiri, inta riraga kaari kameethatatsi. ");
INSERT INTO cjoNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ikantaka itziteeyani riyotaanewopaeni Jowa eejatzi riyotaanewopaeni warijeeyo. Apaanipaeni atziri ipokashitziri Jesoshi, ikantapaakiri: —Iroñaaka itziteeyani riyotaanewopaeni Jowa, eejatzi ikimiteeyani riyotaanewopaeni warijeeyo. ¿Iitaka kaari itzitanta piyotaanewopaeni eerori? ");
INSERT INTO cjoNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ari ikantawakiri Jesoshi: —Okimitaka aririka raye shirampari iina, ikaemaeyerini isheninka ikimoshirewenteeyerini. Rareetapaakyaarika, ¿arima itziteeyapaakyaani rirori? Eero. Tema riweshiryaawentapaakyaari. Ñaakiro, iroñaaka nokaateeyirini naari niyotaanewopaeni: ¿Iitaka notzitakaantyaariri? ");
INSERT INTO cjoNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Omaanta aririka rookaeyaneerini isheninka aatsiri iina, aripaetekya itziteeyanakyaani. Eejatzi iinja naari, nookaeyaneerini niyotaanewopaeni, rowashiretakoeyanakinani, roojatzi itziteeyantanakyaani. ");
INSERT INTO cjoNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Tee pimaejantziri iyotaantatsiri, tee. Eejatzi eenitatsirika pimaathapooki antyashipawo rooteentsi oshipaaye, aririka powawatatero owakirari maathaantsi, roojatzi aririka pikiwero aminthatanaka owakirari, eero omonkaagaakitanaa, roojatzi otzijagaantanakya antyashipawotatsiri, patsipetashitawo powawatatziro. Eejatzi okimitakya, patsipetashityaawo paapatziyawo maawaeni okaatzi iyoteetakimiri. Kameetha pipakaakiro paashini paapatziyawitariri roojatzi kameethatanaki paapatziyena naari. ");
INSERT INTO cjoNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Napiitakiro noshiyakaawentemiro okaatzi niyoteemiri. Piyotzi aakapaeni joriiyopaeni awetsikiri imashi piratsi apiyaatantyaawori awishoowaantsi oowa. Omaanta eero apiitantari apiyaatantari awishoowaantsi oowa owakirari inthomaenta itaworimashi inta apiyaatantya owakira mashiri. Apiitantyaaririka tema ari ijagaanaki. Okimitaka iroka, oetarika niyotagaemiri naari eejatzi owakirari. Tee okameethatzi pipiyotero ikemijantakayimiri paashini iyotaantsi. Pipakayero pikemijantziro ikantawitzimiri irintapaeni roojatzi kameethatanaki paapatziyena naari. ");
INSERT INTO cjoNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Paashini saawaro ikinanaki Jesoshi pankirentsimashiki, itsipateeyarini riyotaanewopaeni. Ari niyanki rowiitanaki riyotaanewo okithoki teriiko, itayaakiro otaki, rowaeyawoni okithoki. ");
INSERT INTO cjoNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ari ikantziri warijeeyo: —¿Iitaka rowiitantawori okithoki, itayaawaetantakawo iroka kitejirika amakoryaantari? Tee okameethatzi. ¿Iitaka ranantawori? ");
INSERT INTO cjoNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Rakanakiri Jesoshi: —¿Tema tee pikenkithashiryaaneentziro Iwaperite Tajorentsi kenkithatakotziriri paerani Iraviirini, riraga jewawenantatsiri maawaeni joriiyopaeni? Tekatsi raye royaari, ayimatakiri itashe, eejatzi itsipateeyarini. ");
INSERT INTO cjoNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Eeniro janta ipankomawoki Tajorentsi paa riwetsikaetziniriri irira: tee ishineteeyerini rowaeyaawoni maawaeni atziri, apatziro rowaeyaawoni ñaanakowenantatsiripaeni. Omaanta ayimawitakari itashe Iraviirini. Riyaatashitakiri Awyataari, riraga iwinkatharite ñaanakowenantatsiripaeni, ikantziri: “Notasheyeeyakini. Tekatsi nowaeyaarini”. Ari ipawakiri paa: “Eenitatsi iroka, powapaeya”. Ari rowakawo, eejatzi rowakagaeyakarini itsipateeyarini. Kaari riroripaeni ñaanakowenantatsiri, omaanta tee ikoyi Tajorentsi rowashironkagaeyerini. ");
INSERT INTO cjoNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Pamine, riraga Tajorentsi riwetsikakiniri atziri kitejiri imakoreeyantyaarini. Tee ro riwetsikantyaanariri atziri iñaapinkathatero kitejiri. ");
INSERT INTO cjoNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Nopoñaaka naaka jenokinta, natziriperotapaaki jaka kipatsiki: tema naaka kantatsini oetarika anteri saawaroki. ");
INSERT INTO cjoNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Riraga Jesoshi riyaatanee eejatzi pankotsiki ipiyotantapiintari joriiyopaeni. Aritaki ijeekiri jaga: shirampari kijopookitatsiri rakoki. ");
INSERT INTO cjoNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Raminashiiyawakarini atziri riraga iijanewo, joreririri: ikowaki riyote aririka retsiyatakoteeri saawaroki. Tee ishineteetziro retsiyatakoteetziri atziri saawaroki. Ikowaeyakini riroripaeni ikantakoeyerini: “Tee okameethatzi iroka rantakiri Jesoshi”. ");
INSERT INTO cjoNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Riraga Jesoshi ikantziri kijopookitatsiri rako: —Pikatziyee, pipoke jaka niyanki. Roojatzi riyaatantanaka niyanki, ikatziyantapaaka. ");
INSERT INTO cjoNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Roojatzi rojampiteeyakirini maawaeni amineentsiri: —¿Kameethama aneshironkateri atziri kitejiriki amakoreeyantarini? ¿Arima owashironkayeri? ¿Okameethatzima owawijaakoteri? Teerikama, ¿pikowakima owamaeyerini? Omaanta imaeriiyanakini. ");
INSERT INTO cjoNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ikijanaka Jesoshi, ramineeyanakirini, eejatzi retakoeyanakarini riroripaeni. Tema ikijoshiryaanakitzi rajankaneki tee ikaminthaanteeyini atziri. Ikantziri shirampari: —Powaankaero pako. Ari rakotanee, roojatzi retsiyatakotantanaa. ");
INSERT INTO cjoNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ishitowaeyanakini warijeeyopaeni, riyaatashiiyanakirini itsipamintharipaeni Erooreshi. Ikantawakagaeyakani: —¿Tsikatya akanterika Jesoshi, owamaantyaariri? ");
INSERT INTO cjoNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Riraga Jesoshi eejatzi riyotaanewopaeni riyaatapitheeyanakirini warijeeyopaeni inkaareki ijeekapaaki apaniroeni, omaanta royaateeyanakirini osheki karireeyajatzi, eejatzi joreeyajatzi, ");
INSERT INTO cjoNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","jerojareejatzi, iroomyajatzi, jeekatsiri intatsikeronta iñaaki Joriraani, maawaeni jeekatsiripaeni Tziiroki, Shirooki, maawaeni. Ikemakoeyakirini itajonkantzi, rootaki riyaatashiiyantakaririni osheki atziri. ");
INSERT INTO cjoNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ikantziri riyotaanewo: —Pamakinawoota pitotsi, notetawakyaata: rawitsineeyapaakinanikari atziri. Rooteentsimi rowamayenami. ");
INSERT INTO cjoNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ikanta Jesoshi rotetantakawo pitotsi ari ikenkithatakagaeyakirini atziripaeni kipatsiki, roojatzi rayiitantapaaka eejatzi kipatsiki. Osheki retsiyatakoeyawakirini mantsiyatzinkaripaeni. Riraga paashini mantsiyari rinteenaryaayitakirini atziripaeni, ikowaki ipampitantapaeyaariri Jesoshi awijakotanee imantsiyari. ");
INSERT INTO cjoNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Riraga atziri kyaantariri kamaari rotziwerowashitapaakari ipinkatheeyakirini. Icheraanaki iñaawaetakaakiri ikantziri: —Jesoshi, eerokataki Itomi Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ikantaperotziri Jesoshi: —Pimaerite, eero pikamantakotana. ");
INSERT INTO cjoNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Paashini kitejiri itonkaanaki Jesoshi tonkaariki. Ikaemakaantakiri ikaatzi riyoyaakiri, ari ipokashiteeyakirini. ");
INSERT INTO cjoNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Riyoyagaeyakirini 12 shirampari, itsipaperoeyaarini. Iinja iiteri rotyaantanewo, tema rotyaanteeyerini ikenkithatakagaeyerini maawaeni atziripaeni iñaani Pawa Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Eejatzi ipakiri itajorenka, rookakaakowiritanantyaariri kamaaripaeni atziri. ");
INSERT INTO cjoNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Rirotaki riyoyaakiri riyotaanewo 12. Riyoyaakiri Shimo (iitakiri Peetero), ");
INSERT INTO cjoNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","eejatzi Jantyaako itsipatakari rirentzi Jowa, (rirotaki itomipaeni Sewereeyo. Iitakiri riroripaeni iroñaaka Wowaneerejeshi). (Akantziri aaka apaanteki: “Oshiyawori oñaawaepookitzi”.) ");
INSERT INTO cjoNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Eejatzi riyoyaakiri Antereeshi, Jiripi, Waritoromee, Mateeyo, Tomashi, Jantyaako (itomira Arijeeyo), Tareeyo, paashini Shimo (riraga kathaaperotzinkari antayitzirorini oetarikapaeni). ");
INSERT INTO cjoNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Eejatzi riyoyaakiri Joorashi (riraga karyootejatzi, aakaanterini iinja Jesoshi). ");
INSERT INTO cjoNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Roojatzi ipiyanaa Jesoshi pankotsinentsiki. Ipiyoteeyaani eejatzi osheki atziri. Tekatsi ikantya rowaeya eejatzi riyotaanewo. ");
INSERT INTO cjoNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ikemakotakiri Jesoshi isheninkapero, riyaatashitawitaari raaneerimi ipankoperoki. Ikantawakaanaka: —Osheki ishinkiwentaka Jesoshi, tee iñaakota, thame aaneeri. ");
INSERT INTO cjoNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ipokashitapaakiri eejatzi jerojareejatzipaeni, iyotaantzirori rojankinarini Moeseeshi. Ikantashitapaakari: —Rirotaki Wereshewoo kyaantapaakariri ishireki Jesoshi. Tema rirotaki iwinkatharite maawaeni kamaari: rirotaki amitakotziriri rirori rotyaantziri iyamaarite, rootaki imatantakariri. ");
INSERT INTO cjoNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ikaemaeyawakirini Jesoshi, roshiyaakaawenteeyawakirini: —¿Kyaaryooma ikyaantapaakina iwinkatharite kamaari? Pamine: ¿tsika ikantyaaka Jatanaashi rookaeya rirojatzi? Eero imatziro. ");
INSERT INTO cjoNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Okimitaka aririka ikijawakagaeyani jeekatsiri nampitsiki, rookawakagaeyaarinika, ¿arima ijeekaeyaneeni kameetha? Eero. ");
INSERT INTO cjoNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Eejatzi okimitaka aririka ikijawakagaeyani jeekatsiri pankotsiki, ¿arima kijokiro rowawakaaneeya? Eero. ");
INSERT INTO cjoNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Eejatzi ikimitaka, aririka Jatanaashi ikijerimi iyamaaritzinkarite, rookawakagaeyanimi, eeromi ijeekimi, inta aritaki ithonkawakaeyakyaanimi. Rootaki. ");
INSERT INTO cjoNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Eejatzi ikimita rirori koshitantatsiri: ithaawantari shintsiperotatsiri ikyaapankoteri ikoshitantyaariri rowaagawo. Aririka ipokashiteri, reewatapaakiri roerikapaakiri, roojotapaakiri shintsitatsiri, roojatzikya raantakyaawo oetarikapaeni rowayitzirini ipankoki. ");
INSERT INTO cjoNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Kyaaryootaki iroka nokamantaperotemiri: ineshironkateeyirini Tajorentsi maawaeni antzirori kaari kameethatatsi. Tema ipeyakoteniri okaatzi rantziri. Eejatzi, aririka ikantzimateeyawityaarini, ineshironkateeri eejatzi. ");
INSERT INTO cjoNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Omaanta eero ineshironkateeri riraga kantzimatzirori Ishire Tajorentsi: ikanteetatyeeyaani ijeeki rirori paamariki kaari tsiwakanitatsini. Eerowa rawijakotee. ");
INSERT INTO cjoNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Rootaki ikantakiriri Jesoshi. Ñaakiro, ikantashiiyawitakani inkaaganki: “Rirotaki iwinkatharite kamaari amitakotziriri Jesoshi”. Tema rootaki Ishire Tajorentsi amitakotziriri, kaari iwinkatharite kamaari. ");
INSERT INTO cjoNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","32","Ikantaka ijeeki Jesoshi pankotsiki, ijeekimoeyapaakirini areeteeyapaakaririni. Roojatzi areetapaaka riniro, otsipateeyapaakarini rirentzipaeni eejatzi ritsiropaeni. Okatziyapaaka inkokironta, okantziri oñaapaakiri: —Pikantenari notyomi. Ari ikyaashitanakiri, ikantapaakiri: —Areetapaaka piniro, pirentzipaeni, eejatzi pitsiropaeni. Ojeekapaaki inkokironta, okowapaakimi. ");
INSERT INTO cjoNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Rakawakiri: —¿Ninka nanatatsiri? ¿Ninka yeeyitatsiripaeni? ");
INSERT INTO cjoNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Roojatzi rookotantanakari jeekimoeyakiririni. Ikantanaki: —Iroka nanaka. Irika yeeyika. ");
INSERT INTO cjoNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ninkarika antapiintzirori ikowakaeriri Tajorentsi: riroteeyakini yeeyi, choeni, nana. Nosheninkateeyakarini maawaeni aapatziyeeyanarini. ");
INSERT INTO cjoNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Paashini kitejiri, rapiitakiri Jesoshi riyotagaeri janta othapyaakiininta inkaare. Ari ipiyotawentapaakari oshekini atziri. Ikanta Jesoshi iñaawakirira roshekitapaaki atziri, rotetanaka pitotsiki, rotatsinkakiro eechonkiini niyankyaani inkaare, ijeekanaki iroñaaka rirori. Tema oshekyaantzi atziri ikatziyashitakari othapyaaki. ");
INSERT INTO cjoNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ari riyotaayitakirini oetarikapaeni, eejatzi roshiyakaawentayitakironi okaatzi ikenkithatakotayitzirini. Ikantakiri iroñaaka: ");
INSERT INTO cjoNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—¡Pikemena! Riyaatanaki pankiwaetatsiri janta rowaneki rookakitero okithoki teriiko. ");
INSERT INTO cjoNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ari rookakitapaakiro okithoki teriiko. Eenitatsi apaanipaeni ookakitapaenchari awotsiki. Ikanta ipokapaaki jenokiweripaeni, rowapaakawo okaatzi rookakitawitakari irika shirampari janta awotsiki. ");
INSERT INTO cjoNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Eenitatsi paashini pariyapaentsiri okithoki janta mapipookiki, tee oshenkaawitapaaka, intsipaete oshookawitanaka. ");
INSERT INTO cjoNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ari ijenokitapaaki oorya, roojatzi ojampiyashitantanaka. Tee oparithaperotzi, rootaki okamantanakari. ");
INSERT INTO cjoNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Opariyapaaki paashini okithoki kitocheemashiki. Okanta oshookawitanaka, okimotatawitanaka. Omaanta anaanakiro oshookanaki kitochee rootaki kaari okithokitantanaka. ");
INSERT INTO cjoNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Paashinipaeni okithoki opariyapaaki kipatsiperoki kameethari. Oshookanaki, okithokitanaki. Apaanipaeni okithokitanaki okaatzi 30. Paashinipaeni okithokitanaki okaatzi 60. Eejatzi paashinipaeni okithokiperotanaki okaatzi 100. ");
INSERT INTO cjoNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Pikoyirika piyotakotero okaatzi nokenkithatakaakimiri paapatziyena iroñaaka. ");
INSERT INTO cjoNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Jateeyaneeni atziripaeni ikaatzi piyotawentakariri Jesoshi, eeniro itsipateeyanaarini Jesoshi apaanipaeni aapatziyariri eejatzi riyotaanewopaeni, riyaatee pankotsiki. Ikanta rojampiteeyakirini rirori, ikanteeyakirini: —Iyotaantatsiri, ¿oetaka poshiyakaawentakiri inkaaganki okaatzi pikenkithatakiri? ");
INSERT INTO cjoNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ikantakiri Jesoshi: —Pamine, iroñaaka nokamantemiro eerori kaari piyotawita: aritaki piyotakiro tsika ikantari Pawa reewawenantzi. Riroma paashinipaeni atziri, eerowa nokantziri rirori inta noshiyakaawentashitayityaanarini. ");
INSERT INTO cjoNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Irintapaeni atziri rirotaki aminawitachari, tee iñeemaetawo okaatzi nantziri. Eejatzi rirotaki kemijantawitanari, teemaeta ikemathatziro oetarika nokantawitakariri. Rootaki kaari rookantawo okaatzi rantayitzirinira kaari kameethatatsi, eero ipeyakotzimaetanari Pawa rantziri. ");
INSERT INTO cjoNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Eejatzi ikantakiri: —¿Tema pikemathatawakiro eeroka okaatzi noshiyakaawentakiri inkaaganki? Aririka napiitakimiro noshiyakaawentayitemironi, eerowa piyotakotawakiro eejatzi. ");
INSERT INTO cjoNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Riraga pankiwaetatsiri okithoki rirotaki oshiyakariri iyotaantzirori iñaani Tajorentsi. Rowaga okithoki oshiyakawo iñaani. ");
INSERT INTO cjoNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Rowaga awotsi opariyantapaakari apaanipaeni okithoki oshiyakari atziri kemawitawakawori iñaani Tajorentsi, omaanta riraga Jatanaashi ipokapaaki imanimotakaapaakiri: tee raapatziyanaana. ");
INSERT INTO cjoNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Eejatzi iroka pariyapaentsiri mapipookiki, rootaki oshiyakaawentachari apaanipaeni atziri kemawitawakawori iñaani Pawa, intsipaete iroñaaka ikimoshirewentawitanakawo. ");
INSERT INTO cjoNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Pankirentsi okaatzi kaari tzimaperotatsi oparitha, intsipaete okamanaki. Iroka roshiyakawo riraga atziri ikemijantawitaka roojatzi rowashironkagaetakiri, aririka ikijeetakiri. Rootaki intsipaete rookantanaawori ikemijantawita. ");
INSERT INTO cjoNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Rowaga kipatsi kitocheemashiteentsiri oshiyakaawentziri kemathatawitawakawori iñaani Pawa Tajorentsi, ");
INSERT INTO cjoNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","omaanta ikenkithashiryaapiintziro jeekayitatsirini jaka kipatsikika, ikimoshirewenteeyironi rashitayitarini. Eekiro ikowanakitzi rashaagawotya, oetarikapaeni, rootaki rookantaawori ikemijantawita. ");
INSERT INTO cjoNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Omaanta iroka kameethari kipatsi oshiyakaawentziri kemaperotawakirori iñaani Tajorentsi. Aritaki raapatziyaperotakawo, eejatzi raapatziyakaaperotakari paashinipaeni atziri. Apaani raapatziyakaakari 30, paashini raapatziyakaakari 60, paashinipaeni raapatziyaperotakaakari 100. ");
INSERT INTO cjoNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Eekiro riyaatatzi ikantakiri Jesoshi: —Akowakirika ootakotya ¿arima owakiri ootamentotsi kowitziki inthomaenta? ¿Arima amanakiri ootamentotsi? ¡Eero! Tema akowatzi oyeri ootamentotsi jeñokiini okoñeetyaantyaari aminanteeyaarini maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Okimitaka iroka iinja okoñaatanaki maawaeni amanayitawitarini iroñaaka riyoteeyanakironi maawaeni okaatzi anteeyakirini. ");
INSERT INTO cjoNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Pikoyirika piyotero kameetha, ari pikemaperotawakiro iroka nokamantakimiri. ");
INSERT INTO cjoNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Paashini ikantakiri eejatzi: —Pikenkithashireeyawo iroka pikemakiri. Aririka eechonkiini paapatziyawakyaawo nokamantzimiri, ari eechonkiini piyotawakiro. Aririka osheki paapatziyaperotawakyaawo, ari osheki piyotawakiro, niyotaaperotakimiri. ");
INSERT INTO cjoNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Riraga aapatziyawakawori niyotaakiriri, eekiro niyaatatye niyotaaperoteri. Riraga kaari aapatziyawakawori nokamantawitakariri, eero riyotzi oetarika, tema ipeyakotakiro eechonkiini riyowitari. ");
INSERT INTO cjoNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Eejatzi ikantzi: —Tema ipinkathariwenteeyakaeni Tajorentsi. Roshiyakari atziri jatatsiri rowaneki ipankitziro okithoki. ");
INSERT INTO cjoNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Imaapiintzi tsiteniriki, ikakitapiintzi kitejiriki. Shitowathowatanaki iwankiri, okimotatanaki. Tee riyotakotzimaetawo tsika okanta oshookantakari. ");
INSERT INTO cjoNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Oshookaki kipatsiki: eewatanaki othowaki, roojatzi owaatotantanaka, roojatzi owathatantanaka. ");
INSERT INTO cjoNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Aririka ojampatanaki okithoki, ichekakoetero, tema monkaatapaaka rowiitanteetyaawori. ");
INSERT INTO cjoNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Eejatzi ikantzi Jesoshi: —¿Tsika nokantemirorika noshiyakaawentemiroka tsika ikanta Tajorentsi ipinkathariwenantzi? ¿Tsika akanteroka akenkithatakotantyaawori? ");
INSERT INTO cjoNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Oshiyakawo okithoki moshitaaja. Omaanta rowaga okithoki, tee okimitawo paashinipaeni kithokitatsiripaeni: okaerikitziini kameetha. ");
INSERT INTO cjoNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Aririka apankitero, oshookanaki. Okimotatanaki, anaayitanakironi paashinipaeni pankirentsitayitatsirini. Antawotayitanakini owaempekipaeni, aritaki raampeyakyaawo shiwankitayitatsirini. ");
INSERT INTO cjoNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Aritaki ikantapiinta Jesoshi, roshiyakaawentapiintziniri atziri riyotaantyaariri iñaani Tajorentsi. Aririka eechonkiini ikemakiro, ari eechonkiini riyotakiri: oshekirika ikemawakiro, ari osheki riyotakiri. ");
INSERT INTO cjoNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Riyotaantariri tema roshiyakaawentapiintziniri. Omaantakya riyotaanewo, ithotyaagaeyakinirini riyotaaperoeyakirini. ");
INSERT INTO cjoNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Itziroryaanaki oorya, ikantziri Jesoshi riyotaanewopaeni: —Thame amontyaanee intatsikeronta inkaare. ");
INSERT INTO cjoNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Roojatzi riyaatapithatantanakari ikaatzi piyotawentakariri. Ari ijeekaki Jesoshi rirori pitotsiki. Roteteeyapaakani riyotaanewopaeni roojatzi imontyaakotantanaka. Eejatzi imontyaakotanaka apaanipaeni atziri ikaatzi piyotawenteeyakaririni, ikinakoeyanakini paashiniki pitotsi. ");
INSERT INTO cjoNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Imontyaakomintheeyani ari omapokashitakari niyankyaani inkaare antawo tampyaa. Antawo otamakaari, otetaatapaaka pitotsiki roowiteenchami itsitsiyakotemi. ");
INSERT INTO cjoNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Omaanta imaatzi Jesoshi rirori janta opataki pitotsi, rotziitotaka. Ikaemanakiri iroñaaka riyotaanewo, ikantziri: —¡Iyotaanari! ¡Aritaki pimaaki! ¡Rooteentsi apiinke! ");
INSERT INTO cjoNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ari ikaakakiri Jesoshi, ipiriintanaka, ikaemakotakiro tampyaa, ikantziro: —¡Aritaki pitampyaataki! Ikantziro eejatzi inkaare: —¡Pimaerite! Okanta iroñaaka tampyaa awijanaki, maeritanee inkaare. ");
INSERT INTO cjoNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Roojatzi ipithokashitantanakari Jesoshi ikantanakiri riyotaanewopaeni: —¿Iitaka pithaawantari? ¿Tekirama pameentaperotana naaka? ");
INSERT INTO cjoNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Tema antawo ithaawaeyanakini riyotaanewopaeni, tekatsi ikanteeyanakini. Okanta ojamaniityaaki, rojampitawakagaa, ikantawakaeyani: —¿Ninkama irika, romaeryaantakawori tampyaa, eejatzi romaeryaantakawori inkaare? ¿Rirotakima Tajorentsi? ");
INSERT INTO cjoNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","2","Rareetakaakari Jesoshi intatsikeronta inkaare, ari rareetakaapaakari iipatsiteki karaarajatzi. Ro raatakoeyapaakani kipatsiki. Intsipaete iñaawakiri Jesoshi shirampari kyaantashiretariri kamaari. Ishiyashitawakari Jesoshi ipoñaaka janta kitataarewontsimashiki, ");
INSERT INTO cjoNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ari ijeekawaetzi rirori. Tema tekatsi aaweerini oojoterini karenathakira. ");
INSERT INTO cjoNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Okantawitaka roojotantawitapiinteetariri kijothari rakoki, eejatzi iitziki, omaanta itzimpejakopiintayitakini. Tekatsi monkaatzityaarini ishintsini. ");
INSERT INTO cjoNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ikantatyaani, riyaatapiintzi tonkaariki. Ikaemakaematapiintzi, itowaetapiinta mapikipaeni. Tema ishinkiwentakaakari iyamaarite. ");
INSERT INTO cjoNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Riraga shirampari iñiitawakarira inteena ipokaki Jesoshi, ishiyashitakari rareetapaakari, rotziwerowashitapaakari, ipinkathatapaakiri. ");
INSERT INTO cjoNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Ikanta Jesoshi, iñaawakirira shirampari ikyaantashiretariri kamaari, icheraakotawakiri, ikantziri: —¡Kamaari, pookaneeri shiramparira! Irika shirampari, antawo icheraanaki ikantakaakarira iyamaarite, ikantanaki: —¿Iitaka poñaashirenkantanari? Eeroka Jesoshi, itomi Tajorentsipero. Nokantemi iroñaaka eero powashironkaana. ");
INSERT INTO cjoNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Roojatzi Jesoshi rojampitakiri irika kamaari, ikantakiri: —¿Tsika piitaka? Rakanakiri kamaari, ikantzi: —Nowaero Oshekyaantzi. Rootaki noetantari, tema osheki nokanta nojeekantari irika shirampari. ");
INSERT INTO cjoNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Teera nokoyi potyaantena naakapaeni paashiniki kipatsi. ");
INSERT INTO cjoNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ari ijeekaki eejatzi janta oshekyaantzi chaancho tonkaariki, ikaatzi 2.000, rowawaeteeyani. ");
INSERT INTO cjoNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ikantanaki kamaari, ikantziri Jesoshi: —Ari nokoyi potyaantena janta chaanchoki, nojeekanteeyapaakyaarini inthomaenta. ");
INSERT INTO cjoNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ari ishinetakiri. Rookaeyaneerini shirampari, ishirinkashiteeyanakarini chaancho, ikyaanteeyapaakarini. Roojatzi ishiyeeyanakani riraga chaanchopaeni impeetaki, ari ithonkaeyakani: ipiinkaeyapaakini inkaareki pooo, pooo, pooo. ");
INSERT INTO cjoNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ikanta irikapaeni shentziriri chaancho, iñaakirowa okaatzi awijeentsiri, antawo ithaawaeyanakini iroñaaka. Shiyeeyanakani, ikantapaakiri ikaatzi jeekaeyatsirinipaeni okaakinira. Intsipaete antetanaka ñaagantsi. Pokaeyanakini atziripaeni ramineri iitarika awijimotakiriri chaancho. ");
INSERT INTO cjoNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Riyaatashiteetakiri Jesoshi, iñeetapaakiri riraga shirampari ijeekantawitari kamaaripaeni. Ijeekaki ikithaataawo iithaari, kameethatanee. Tema iñeetapaakirira, antawo ithaawanteeyapaakarini. ");
INSERT INTO cjoNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ikanta irikapaeni ñaakiriri inkaaganki Jesoshi okaatzi rantakiri, ikanteeyawakirini paashinipaeni atziri owakira pokapaentsiri okaatzi awijeentsiri inkaaganki. Ari okaatzi ikantawakiriri tsika ikanta iñaakiri ipiinkantakari chaanchopaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ikanta ikemaeyawakinira atziripaeni, ikanteeyakirini: —Jesoshi, iroñaaka tee nokoyi pipokimotena nonampiki, pipiyanaki. ");
INSERT INTO cjoNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ikanta ikemawakira Jesoshi, roojatzi rotetanaa pitotsiki. Ikantawitawaari iroñaaka irika shirampari rookakiniri iyamaaritepaeni, ikantziri: —Jesoshi, nokoyi noyaataneemi. ");
INSERT INTO cjoNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Rakanakiri Jesoshi, ikantanakiri: —Eero poyaatana, piyaate pinampiki tsikarika ijeeki pinampijatzipaeni. Pikantapaeri maawaeni okaatzira awijimotakimiri. Pikantapaeri eejatzi: “Ineshironkatakina Nowinkatharite”. ");
INSERT INTO cjoNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ikemawakirira irika shirampari, roojatzi riyaatanee janta inampiki. Ikantakiri inampijatzi eejatzi riyaataki maawaeni paashiniki nampitsi janta iipatsiteki oetachari Tekaaporishi. Ikantapaeri osheki atziri okaatzi awijimotakiriri. Ikanta ikemaeyawaerini ikenkithawaetapae, osheki itzimaetyaashiiyanakani. ");
INSERT INTO cjoNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ikantanaka imontyaanaka Jesoshi intatsikeronta inkaare. Ipiyoeyakaninta osheki atziri janta othapyaakiini. ");
INSERT INTO cjoNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Rareetapaaka shirampari iwaero Jaero, riraga jewatakaayitziririni ijoriiyotzinkaritepaeni janta pankotsiki ipiyotantapiintarira. Iñaapaakiri, rotziwerowashitapaakari Jesoshi riwethatantapaakariri Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ikantaperotapaakiri: —Rooteentsi okame nishintyo. Pipoke pipampitakitero awijakotantaneeyaari roori, eero okamanta. ");
INSERT INTO cjoNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ari royaatanakiri, roojatzi royaatayitanakirini osheki piyotawentariri, rawitsinaawakaanaka. ");
INSERT INTO cjoNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ari okaataki tsinani jokaatzirori iraa, okaatakotaki 12 ojarentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Osheki raawinteetawitakawo, thonkapaaka oorikite omaanta eekiro iyaatatzi ojokaatziro iraa. ");
INSERT INTO cjoNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Okemaki ikantakoeyirini Jesoshi: “Osheki retsiyatakotantzi”. Ojatekanakari oyaateeyiririni okinapaaki itapiiki. Okenkithashiryaanaka: “Aririka nopampitziteri imaatha, aritaki netsiyatakotee”. Ari opampitzitawakiri imaatha, kaatakotanee ojokaatziro iraa. ");
INSERT INTO cjoNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Okemawakitya tsinkaririri, awijakotanee. ");
INSERT INTO cjoNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Eejatzi rirori intsipaete ikemashitawakawo itajorenka. Ari ipithokashitanakari oyaatziriri, ikantziri: —¿Ninkama pampitzitakinawori nomaatha? ");
INSERT INTO cjoNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Rakanakiri riyotaanewo, ikantanakiri: —Tema piñiiri roshekitaki oyaatayitzimirini. Rawitsinaayitakimini. Eekiro pikantatzi: “¿Ninkama pampitzitanawori nomaatha?” ");
INSERT INTO cjoNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Raminaminayitanakini ikoyi iñeeri pampitzitakiriri imaatha. ");
INSERT INTO cjoNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Roori tsinani, osheki othaawanaki ompetatanaka, tonki, tonki, tonki. Iyotaki awijakotanaki. Otziwerowashitapaakari, oñaaperotantariri. Othotyaakiro okantaperotakiri maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ikantziro: —Tsinani, pameentakina, rootaki petsiyatakotantaari. Iroñaaka piyaate, pikimoshiretee. Tema etsiyatakoteemi. ");
INSERT INTO cjoNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Tekiraata ithonkiromi ikenkithawaetakayiro, ipokaeyapaakini ronampiripaeni riraga Jaero. Ikantapaakiri: —Kamanaki pishinto. ¿Iitaka poñaashirenkantariri irika iyotaantatsiri? ");
INSERT INTO cjoNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ikemawakiro Jesoshi iroka ikantapaakiriri. Ikantziri: —Jaero, eero pikantashiryaashita, inta pameentena naaka. ");
INSERT INTO cjoNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Tekatsi ishinete oyaatanakirini, inta ishinetakiri riraga Peetero, Jantyaako itsipatanakari rirentzi Jowa. ");
INSERT INTO cjoNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Roojatzi rareeteeyapaakani ipankoki Jaero. Iñaapaakiri atziripaeni: ikaemaeyakini, rowashiretakoeyakawoni, riraakoeyakawoni. ");
INSERT INTO cjoNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ikyaapaaki, ikantapaakiri: —¿Iitaka pikaemakotantawori? ¿Iitaka piraakotayitantaworini? Tee okamaperotzi ewankawo, omaashita. ");
INSERT INTO cjoNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ishirontawenteeyawakarini, roojatzi roemishitowaeyapaakirini. Raanakiri iri eejatzi iniro, eejatzi riyotaanewopaeni, ikyaashitapaakiro janta omaryaakanta ewankawonta kamawiteencharira. ");
INSERT INTO cjoNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Roerikawakotapaakiro. Ikantziro rashi ipaanteki: —Tarita komi. (Akantziri aaka apaanteki: “Ewankawo, pañaagae”.) ");
INSERT INTO cjoNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Roojatzi añaantanaa, opiriintanaa, sherok, anashitanaa. Okaataki ojarentsite 12, rootaki omatantaari anashiwaeta. Rotsikanateeyanakawoni osheninkapaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ikantaperotziri rirori: —Eerowa pikamantayitzirini atziri okaatzi piñaakiri nantakiri. Ari iroñaaka pipero owanawo. ");
INSERT INTO cjoNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Roojatzi riyaatantanaa Jesoshi, areetapaa inampiki rirori. Royaateeyeerini riyotaanewo. ");
INSERT INTO cjoNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","3","Roojatzi kitejiri imakoryaantapiintari, riyotaantapae janta pankotsiki ipiyotantapiintarira joriiyopaeni. Rotsikanatawakari osheki kemawakiriri. Itheenkaeyakirini Jesoshi, ikanteeyini: —Tema rirotaki asheninkapero aari. ¿Tsika ipoñaakaakawoka iroka riyotaantziri? ¿Tsika ikantakari itajonkantayitantakarini? ¿Kaarima irika wetsikapiintzirori jeekamentotsi? Rirotaki otomi Mariiya, tema rirotaki rirentzipaeni Jantyaako, Josee, Joorashi, eejatzi Shimo. Eejatzi ritsiropaeni, tema ojeekimoteeyakaeni jaka. ");
INSERT INTO cjoNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ikantzi Jesoshi: —Iñaaperoeyakirini atziri kamanantzirorini iñaani Tajorentsi. Omaanta rirorika kamanantawityaawoni inampijatzi osheki itheenkiri. ");
INSERT INTO cjoNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Kyaaryo inampiweri itheenkaeyakirini riraga Jesoshi, rootaki kaari itajonkantapiinanta janta inampiperoki. Apatziro ipampitayitzirini apaanipaeni mantsiyatzinkari, retsiyatakotayitzirini. ");
INSERT INTO cjoNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Omaanta tee raapatziyeeyarini inampijatzi, rootaki rotsikanatantanakari riraga Jesoshi, ikenkithashiryaaka: “¿Iitaka kaari raapatziyeeyantanani?” Ikinakinayitanakini Jesoshi nampitsikipaeni, riyotaantayitanakini. ");
INSERT INTO cjoNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Eejatzi riyoyaakiri riyotaanewo 12. Imatakaakiri rowawijaakotantyaariri kyaantawitariripaeni kamaari. Roojatzi rotyaanteeyakirini; itsipatawakaanteeyanakarini, apitepaeni riyaatayitanakini nampitsikipaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ikantaperotawakiri: —Aririka piyaatanaki, tekatsikya paanaki. Eero payi poyaari, eero payiro pithaate. Eejatzi eero payi piyorikite. Omaantakya paanaki pikotzi. ");
INSERT INTO cjoNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Eejatzi pijapatotanakya, omaanta eero paanaki paashini pimaatha. ");
INSERT INTO cjoNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Eejatzi ikantawakiri: —Tsikarika pijeekapaaki, aritaki pijeekaarikotapaaki, roojatzi piyaatantakya paashiniki nampitsi. ");
INSERT INTO cjoNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Eerorika raakameethateeyawakimini janta nampitsiki, eejatzi eerorika ikemijanteeyawakimini, ari pishirinkanaki potekakontatanakya piitzikira riyotantyaari eero pipiyashitari eejatzi. Omaanta ari rowashironkaakiripa Tajorentsi iinja. ");
INSERT INTO cjoNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ari riyaateeyanakini riyotaanewopaeni. Ikamanteeyakirini atziripaeni: —Pikenkithashiryagaeya, eero pantapiintziro eejatzi kaari kameethatatsi, inta pookaero. ");
INSERT INTO cjoNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Rowawijaakoeyakirini osheki kyaantawitariri kamaari. Ijeetantayitakarini oyeenka oriiwo osheki mantsiyaripaeni, retsiyatakoeyakirini. ");
INSERT INTO cjoNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Osheki kemakoeyiririni Jesoshi, rootaki ikemakotantakariri eejatzi pinkathari iitachari Erooreshi. Ikantayitzini atziripaeni: —Rirotaki Jowa kaawoshitantatsiri, kamawiteenchari: piriintanaa. Rootaki ipiriinantari itajorentsitzira. ");
INSERT INTO cjoNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Eenitatsi paashini kantayitawitacharini: —Rirotakirika Iriiyashini: piriintaachari. Paashini kantayitatsirini eejatzi: —Rirotaki kamanantzirorini iñaani Tajorentsi. Roshiyaari kamanantayitzirorini iñaani Tajorentsi paerani. ");
INSERT INTO cjoNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ikemakotantariri riraga Jesoshi, ikantzi Erooreshi: —Rirotateekityaami Jowa. Nochekakaantawitakari ikentsiki omaanta piriintanaa eejatzi. ");
INSERT INTO cjoNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","19","Ari paerani Erooreshi raapithatakiri rirentzi iina. Iita rirentzi Jiripi, ro iinantawitarini, Eroriiyashi. Riraga Jowa ikantapiintawitakari Erooreshi: —Tee okameethatzi paapithateri pirentzi iina. Okijanakiri Eroriiyashi, okowaperotaki owamaakaanteri, omaanta tee ikoyi riraga oemi. Osheki oñaashirenkapiintakiri, rootaki raakaanantakariri Jowa, romonkyaakaantakiri omonkyaagamentotsiki. ");
INSERT INTO cjoNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ipinkathatawitakari riraga Jowa, riyotziri ikameethaperotzi, raapatziyaperotari Tajorentsi. Rootaki kaari ikowanta rowamaakaanteri. Tema ithaawakaawitatyaari Jowa, ikenkithatakaapiintziri. Raapatziyawitawo ikantziriri Jowa, omaanta tee riyotzi tsika ikantya. ");
INSERT INTO cjoNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Monkaataka kitejiri ikoñaatantakari paerani Erooreshi. Rowakagaeyakarini osheki inashitayitacharini jewatatsiripaeni karireeyajatzi. Rootaki kitejiri owamaakaanantakyaariri rowaga Eroriiyashi Jowa. ");
INSERT INTO cjoNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Okyaapaaki ishinto roori janta rowaeyaninta opirantakotapaakiri. Iñaaperotawakiro kameetha riraga Erooreshi eejatzi itsipateeyarini. Ikantziro ewankawo: —Pikowakotena iitarika pikoyiri. Aritaki nopakimi. ");
INSERT INTO cjoNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Iñaakina Tajorentsi, riyotzi eero namatawitzimi. Oetarikapaeni pikowakotakinari, aritaki nopakimi. Pikowakirika nopagaantemi noepatsite, aritaki nopakimi kashetani. ");
INSERT INTO cjoNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Shitowanee roori, ojampitapaakiro iniro: —¿Oetaka nokowakoteriri? Akawakiro roori: —Ro pikowakoteriri iito Jowa kaawoshitakotziriri Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Intsipaete opiyashitanaari pinkathari. Okowakotapaakiri, okantziri: —Nokoyi iroñaaka pipakotenawo piratoki iito riraga Jowa. ");
INSERT INTO cjoNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Osheki rowashiretanaka. Tema aritaki ikantakiro inkaaganki: “Eero namatawitzimi”. Eejatzi ikemaeyawakirini maawaeni itsipateeyakarini. Tee iroñaaka ikowae ramatawitero. ");
INSERT INTO cjoNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ari rotyaantakiri owamaantatsiri, ikantawakiri: —Pamakinawo iito Jowa. Ari riyaatanaki janta romonkyaakirinta, ichekapaakiri ikentsiki. ");
INSERT INTO cjoNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ramakotakiro piratoki iito, ipapaakiro ewankawo. Roori, owaakiniro iniro. ");
INSERT INTO cjoNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ikemakotakiri riyotaanewoni Jowa, ari riyaatashiiyakirini. Raaneero iwatha ikitatero. ");
INSERT INTO cjoNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Paashini kitejiri ipiyayitaani riraga rotyaantanewo Jesoshi. Ikanteeyapaakirini maawaeni rantayitakirini. Eejatzi ikantakoeyapaeroni maawaeni riyotaanteeyakirini. ");
INSERT INTO cjoNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Osheki atziri piyotawenteeyapaakaririni Jesoshi. Apaanipaeni jatayiteeni, eekiro ipokatzi paashini, rootaki kaari imatanta rowaeyaani rirori eejatzi riyotaanewo. Ikanteeyakirini irirapaeni: —Thame ayowaeyanakini, aate janta tekatsinta atziri amakoryaawakiita eechonkiini. ");
INSERT INTO cjoNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Roojatzi riyaateeyanakini, ikinakotanaki pitotsiki. ");
INSERT INTO cjoNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Omaanta iñeeyawakirini oshekini atziri, riyoteeyanakirini tsikarika riyaate. Ipoñaayitanakani ipankokipaeni, ishiyashitanakari, ishirethapyaatanakawo othapyaakini. Ranaakoeyakirini rirori, royaapaakiri. ");
INSERT INTO cjoNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Imitaanaki riraga Jesoshi eejatzi riyotaanewopaeni, iñaapaakiri osheki oyaakiriri. Roojatzi osheki retakoshiryaaperotapaakari roshiyakaantapaakiri owisha kaari ishenteetzi. Osheki riyotagaeyapaakirini oetarikapaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Roojatzi itsiteniityaanaki oorya. Ipokashitapaakiri riyotaanewopaeni, ikantapaakiri: —Iroñaaka ajeekaki jaka tekatsi pankotsi, tekatsi owanawontsi. Eejatzi itsiteniityaanaki oorya. ");
INSERT INTO cjoNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Okameethatzi potyaanteeyerini atziri riyaateeta owantsiki, nampitsikipaeni. Ramanantapaente rowanawo. ");
INSERT INTO cjoNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Rakanakiri Jesoshi, ikantziri riraga riyotaanewopaeni: —Piperiita eeroka owanawontsi. Ikantawakiri riroripaeni: —¿Pikoyima niyaate namanantakite owakagaeyaaririni atziripaeni? Osheki opinata: eero imonkaata koriki. ");
INSERT INTO cjoNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ikantawakiri: —¿Tsikama okaatzika owanawontsi? Piyaate, paminakitero. Ari iñaakitziro, ikantapaeri: —Apatziro apawakooni okaatzi paa, eejatzi apite mereto. ");
INSERT INTO cjoNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ikantawakiri: —Poejeekiri atziripaeni jaga katawomashiki. Pipiyoteeyerini, eejatzi pinashiteeyakyaarini. ");
INSERT INTO cjoNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ari ipiyoteeyakirini, ijeekaeyanakini. Apaanipaeni piyoteenchari ikaatzi 100 atziri, rinashitaka paashinipaeni piyoteenchari ikaateeyini 50. Eenitatsi osheki paashinipaeni piyoteenchari. ");
INSERT INTO cjoNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ari raakiro riraga Jesoshi paa eejatzi mereto, raminanaki jenokinta, ikantziri Iriri: —Ariwee, Pawa, eerokataki pakinawori iroka noyaarika. Ikagaakiro paa. Ipayitakirini riyotaanewopaeni roshirinkakiniri piyoteenchari. Eejatzi mereto, royiitakiniri maawaeni atziri, ");
INSERT INTO cjoNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","ari rowaeyakani. Ikemaeyanakani, tee ithonkanakiro owanawontsi. ");
INSERT INTO cjoNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Raayiteeroni tzimagaantapaentsiri, riyeekiteeyironi kantziriki okaatzi 12. ");
INSERT INTO cjoNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ikaateeyini owaenchari 5.000 shirampari, eejatzi tsinanipaeni, eejatzi eentsipaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Roojatzi rotyaantakiri riraga Jesoshi riyotaanewo, ikantziri: —Thame potetanakya pitotsiki. Peewateeyenani intatsikeronta inkaareki, janta Wetheeraki: notyaanteeyeriniita ipankokipaeni irika piyoteenchari. —Jee, ari. ");
INSERT INTO cjoNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ikanta riyaatanaki atziripaeni roojatzi riyaatanaki riraga Jesoshi tonkaariki, ikenkithatakayiri Tajorentsi ");
INSERT INTO cjoNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Tsiteniriki eekiro oepiyakotziri tampyaa. Ari iniyankitakotanaki inkaareki riyotaanewo, omaanta eeniro ijeekaki rirori apaniroeni tonkaariki. ");
INSERT INTO cjoNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ikanta iñaakiri riyotaanewo, ikomakomateeyawitanaawoni riyotakiri makoempekitapaaki. Ari riyaatashitanakiri rirori. Ranashaatanakawo inkaare, tee itsitsiyi. Roowiteenchami rawijanakirimi ");
INSERT INTO cjoNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","roojatzi iñeeyantawaarini, ranashaatapaakawo inkaare. Iiteeyawitawakarini peyari. Ari ikaemaeyanakini: —¡Eeeee! ¡Kaakitaki peyariwee! ");
INSERT INTO cjoNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ari iñeeyawakirini maawaeni. Ithaawaeyanakini. Intsipaete iñaanatapaakiri rirori: —Piweshireeyanakyaani. Naaka pokatsi. Eero pithaawantana. ");
INSERT INTO cjoNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Rotetapaaka pitotsiki itsipateeyapaakarini roojatzi opeyantanaa tampyaa. Riweshiryaawentari eejatzi osheki rotsikanateeyanakarini. ");
INSERT INTO cjoNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Iñeeyawitakarini inkaaganki itajonkiro paa omaanta tekira ikenkithashiryaakoperotari irira rirotaki Tajorentsi. Tema eeniro okijotzimoneentakiri rajankane. ");
INSERT INTO cjoNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Imontyaantanakawori, rareeteeyapaakani Jenejareeteki. Raatakoeyapaakani. ");
INSERT INTO cjoNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Rayiiteeyapaakini, intsipaete riyoteeyawakirini atziri. ");
INSERT INTO cjoNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ishiyashiteeyawakarini. Ramakoeyakinirini mantsiyatzinkaripaeni ishitashiki, janta ijeekapaakira Jesoshi, aritaki janta raakotanakiniri. ");
INSERT INTO cjoNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ikinakinayitzini owaaninikipaeni nampitsi, nampitsikipaeni antawo, eejatzi owantsikipaeni. Tsikarika ikinayitzini Jesoshi ipiyotayitakinirini mantsiyaripaeni. Royiitakinirini niyanki nampitsiki, ikanteeyawakirini: —Pishineteenawo nopampitzitawakimiro opatziyaakiki piithaari. Ari rawijakoeyaneeni maawaeni pampitzitawakiriri iithaari. ");
INSERT INTO cjoNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ikanta ipokapaaki warijeeyopaeni, eejatzi apaanipaeni iyotaantzirori Iwaperite Tajorentsi, ipoñaaka Jerojareeki. Ipiyotawentapaakari Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Iñagaeyapaerini riyotaanewo, rowaeyani tee ikiwawakota: tema tee ikiteshiretzi. Ikanteeyini: “Aririka oyaa, ityaawo akiwawakotya akameethashiretantyaari”. ");
INSERT INTO cjoNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Riraga warijeeyo rameteeyawoni rootzimateentsirika roya ikiwawakoperota. Tema rameteeyawoni maawaeni joriiyopaeni. Rooma eerorika ikiwawakota eero royiita. Imonkaatayitzironi riyotaantapiintzirini itakaantaworini. ");
INSERT INTO cjoNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Aririka ipoñagaeya janta nampitsiki niyanki, eerorika ikiwawakoperotapaa eero rowa paa. Eejatzi imonkaatashitayitakawoni osheki oetarika riyotaayitziririni atziripaeni. Ikiwapiinteeyironi iwajoni, iwachakate, iyotsironakite; maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ari rojampiteeyapaakirini Jesoshi: —¿Iitaka kaari imonkaatantawo piyotaanewo riyotaantayitzirini itakaantaworini? Irika iroñaaka owaencharika tee ikiwawakota ipeyakotakiro okantziri kaminagaantsi: eeniro rantani. ");
INSERT INTO cjoNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ikantanakiri Jesoshi: —Osheki pamatawitantayitzini, tema poshiyakaawaetashita paapatziyari Tajorentsi. Aritaki ikamantakotzitakimini paerani Iseeyashi. Rojankinatakini, ikantzi: “Irika atzirika ikantawaetashiteeyakinani: ‘Nopinkathatzimi’, omaanta rajankanekira tee raapatziyaperotana, okimitzimotakina inteena ijeekaeyakini. ");
INSERT INTO cjoNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ratsipetashitakawo rotziwerowashitana; roshiyakaawaetashita iñaaperotana. Ramatawitashitayitakarini ijoriiyotzinkaritepaeni: ikantawitari iroka riyotaawitariri kimiwitaka rootaki Iwaperite Tajorentsi”. Kyaaryootaki iroka ikantzitakarini Iseeyashi. ");
INSERT INTO cjoNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Eejatzi ikantziri Jesoshi: —Pookanakiro ikaminaawitzimiri Tajorentsi, inta paapatziyashitanakawo riyotaanteeyirini atziri. ");
INSERT INTO cjoNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Aritaki pitheenkakiro ikaminaawitzimiri Tajorentsi, inta pikowashitaka pimonkaatero riyotaantayitzirini itakaantaworini. ");
INSERT INTO cjoNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Tema ikantziri Moeseeshini: “Otzimatye pipinkathateri piri eejatzi piniro”. Eejatzi ikantzi: “Riraga Tajorentsi ikantakotziri akawaantetziriri ashitariri eejatzi riniro: ‘Okameethatzi rowamagaeteri’ ”. ");
INSERT INTO cjoNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Omaanta pikantashitapiinteeyawitarini atziri: “Aririka pikashiyakayeri Tajorentsi piyorikite, ari pipaperoteri. Rashironkaawaetyaarika piri, piniro, pikanteri: ‘Eero nomatziro nopemiri koriki: irika koriwaka, tema nokashiyakaakiri Tajorentsi noorikite noperiri’ ”. ");
INSERT INTO cjoNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Aritaki iroñaaka tee pishinetziri ajoriiyotzinkaritepaeni retakotaneeyaari iriri, riniro. ");
INSERT INTO cjoNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Pikowakaakiri raapatziyawo piyotaapiintziriri, omaanta piyotaakiri itheenkakiro ikantziri Tajorentsi. Aritaki pikantapiintari: pookakaayitzirini ajoriiyotzinkaritepaeni raapatziyawowa Iwaperite Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Rapiitakiro ikaemaeri riraga Jesoshi piyoteeyeencharini ikanteeyirini: —Pikemaperoeyenani maawaeni. Nokoyi pikemaperotena nokantemiri. ");
INSERT INTO cjoNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Okameethatzi owaeyaawoni oetarikapaeni, eero añiiro antani: tekatsi okantero owanawontsi ashire. Omaanta aririka pikenkithashiryaakotyaawo kaari kameethatatsi, eejatzi piñaawaeterorika kaari kameethatatsi, rootaki owaariperoteroni pishire. ");
INSERT INTO cjoNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Eerokapaeni kemayitakirorini okaatzi nokantakimiri, pikenkithashiryaakotyaawo. ");
INSERT INTO cjoNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ithonkakiro riyotaakiri eejatzi rookaneeri piyotawentariri, roojatzi ikyaapae pankotsiki Jesoshi eejatzi riyotaanewopaeni. Rojampitapaeri irira: —¿Oetaka poshiyakaawentziniriri inkaaganki? ");
INSERT INTO cjoNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ikantawakiri: —Eejatzi eeroka, ¿tee pikemawakina inkaaganki? Oetarikapaeni owayityaarini okameethatzi, eero añiiro antani. Tema piyotawakiro. ");
INSERT INTO cjoNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Rooma eero omatziro owaariperotziro ashire, inta iyaataki asheetoki, roojatzi ashitanteeyawori. Rootaki riyotaayitziririni okameethataki oetarika rowaetari. ");
INSERT INTO cjoNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Eejatzi ikantziri: —Omaanta pikenkithashireerorika kaari kameethatatsi, eenitatsi pantani. ");
INSERT INTO cjoNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Rooma pikenkithashiryaakaworika pajankaneki pantero kaari kameethatatsi, rootaki panantyaawori maawaeni: pishirontyaawo tsinani kaari payi, pishirontyaari shirampari kaari payi, pikoshite, powamaante, ");
INSERT INTO cjoNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","osheki pikowaperotero oetarikapaeni rashitayitarini paashinipaeni atziri, pantero kaariperoripaeni, pamatawitante, piñaathatantya, piñaawenawaetya pikowaperote pikimityaari ashaagantzinkari, pikantzimateri atziri, pikantakaaperotya, tee piyoteeyironi pantero kameetha. ");
INSERT INTO cjoNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Kyaaryo, pikenkithashiryaawo pantero kaari kameethatatsi, rootaki panantawori: rootaki powariperotantakari. ");
INSERT INTO cjoNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Roojatzi riyaatanee Jesoshi Tziiroki. Ijeekapaaki pankotsinentsiki, tee ikowawita riyoteeterimi. Omaanta tekatsi ikantya imanapithatyaari atziri. ");
INSERT INTO cjoNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ojeeki janta tsinani, ikyaantawitakawo ishinto kamaari. Okemakotawakiri roori Jesoshi, iyaatashitanakiri, otziwerowashitapaakari. ");
INSERT INTO cjoNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Kaari joriiyo, opoñaaka Shirojeniishiyaki. Okantapaakiri: —Ikyaantakawo nishintyo kamaari, petsiyatakoteenawo. ");
INSERT INTO cjoNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Roshiyakaawentashitanawo, ikantawakiro: —Nitawakyaariita nojoriiyotzinkarite netakotyaari. Tee okameethatzi aapithateeri rowanawo eentsite aperi otsitzi. ");
INSERT INTO cjoNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Roori akanakiri: —Jee, kyaaryo. Ari ijeekita rirori otsitzi otapinaki raperotayitzironi rowanawopetokipaeni eentsite. ");
INSERT INTO cjoNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ikantaneero: —Jee, kameetha; kyaaryo pikantakiri. Kameetha piyaatee iroñaaka, awijakotanee pishinto. ");
INSERT INTO cjoNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Opiyanaaga opankoki. Oñaapaero ishinto, omaryaaka omaamentoki, awijakotanee, tema yowanee owamaarite. ");
INSERT INTO cjoNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Roojatzi rowaagakaantanaari Jesoshi riyotaanewo, ikinanee Shirooki, roojatzi kirinkanta Joriraaniki, roojatzi rareetapaa inkaareki owaero Karireeya. Ikinanaki ochereeteki intatsikeronta Karireeya janta Tekaaporishiki. ");
INSERT INTO cjoNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ramaetapaakiniri shirampari amashitzinkari inthomaenta ikempita, kaari kematsi eejatzi imajontzitzi. Ikantapaakiri amiriri: —Pipampitawakiri, petsiyatakoteeri. ");
INSERT INTO cjoNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Riraga Jesoshi rookaneeri piyotawentariri, apaniroeni itsipatanakari matakempitari. Romonkyaakiniri rakoempeki ikempitaki. Reewatakiro rakoempeki, ipampitakiri ineniki. ");
INSERT INTO cjoNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Raminanaki jenokinta, ikenkithatakaakiri Tajorentsi roojatzi ikantziri ipaante rashi: —¡Epeta! Akantziri aari añaaneki: “Piwitaryaaneeya”. ");
INSERT INTO cjoNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Iwitaryaanaa ikemantari. Opeyanaa imajontziwita, kameetheenkatanee iñaawaetanee. ");
INSERT INTO cjoNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Rapiitapiintawitari ikantziri: —Eerowa pikamantakotana. Omaanta tee ikemijantaperotziri, eekiro ikamantakotanakitziiri. ");
INSERT INTO cjoNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Eekiro rotsikanateeyanakityaarini Jesoshi. Ikanteeyini atziripaeni: —¿Iitakakya? Okameethaperotantari rantayitzirini. Imataperotakiro Jesoshi maawaeni rantayitzirini. Kemanee amashitzinkari inthomaenta ikempita, eejatzi riraga majontziwitachari, iñaawaetakagaeri. ");
INSERT INTO cjoNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Paashini kitejiri ipiyoteeyakani eejatzi osheki atziri, tekatsi rowaeyaarini. Riraga Jesoshi ikaemiri riyotaanewo, ikantawakiri: ");
INSERT INTO cjoNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Netakoeyakarini irikapaeni. Ro netakoeyantakaririni 3 kitejiri itsipateeyakinani, tee rowa. ");
INSERT INTO cjoNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Agaeyakirini itashe. Eenitatsi apaanipaeni poñeenchari inteena: aririka notyaanteeyawiteeyarini iroñaaka ipankoki, ari ishipetawathatanaki niyanki awotsiki. ");
INSERT INTO cjoNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Rakanakiri riraga riyotaanewo: —¿Tsika akantyaaka akemakagaeyantyaaririni paa? Jaka tekatsi atziri jeekatsini. ");
INSERT INTO cjoNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Rojampitakiri: —¿Tsika okaatzika jeekaentsiri paa? Ikantzi: —Okaatzi 7. ");
INSERT INTO cjoNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ikanteeyakirini piyotawenteeyaririni: —Pijeekaeyeni katawomashiki. Raakiro paa, ipaasonkitziri Iriri. Ikagaakiro, ipaeyakinani naaka riyotaanewopaeni, noshirinkaeyakinirini piyoteenchari. ");
INSERT INTO cjoNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Eenitatsi eejatzi mereto apaanipaeni. Ipaasonkiwentakiri eejatzi. Roojatzi ikantziri riraga riyotaanewo: —Pipaeyerini eejatzi mereto. ");
INSERT INTO cjoNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Roojatzi nowaeyakani, nokemaeyanakani. Naayiteeroni tzimagaantapaentsiri, nowaero kantziriki. Okaatzi yeekitaatsiri 7. ");
INSERT INTO cjoNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ikaateeyini owaenchari 4.000 shirampari. Roojatzi rotyaanteeyeerini: —Piyaateeyeeni pipankokipaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Itsipateeyanaarini riyotaanewo, roteteeyanaani pitotsiki. Niyaateeyaneeni janta Tarimanootaki. ");
INSERT INTO cjoNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ari ipokapaaki warijeeyopaeni. Ikijathatapaakiri, ikantziri: —Ajaatya, pitajonkantayiteni niyotantemiri eerokatakirika Tajorentsi, roojatzikya aririka nomatero naapatziyemi. ");
INSERT INTO cjoNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Osheki okantzimoneentanakari Jesoshi. Ikantzi: —¿Iitaka ikowaeyantarini maawaeni atziri noñaayeri notajonkante? Kyaaryootaki iroka nokamantaperotemiri, eero noñaayimiro notajonkantayiteni. ");
INSERT INTO cjoNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Roojatzi riyaatakaantanaari riyotanewo, rotetanaa eejatzi pitotsiki. Riyaatanee, imontyaanaa intatsikeronta. ");
INSERT INTO cjoNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ipeyakoeyanakironi riyotaanewo raanakiromi rowanawo pitotsiki, inta apaani paa raanaki. ");
INSERT INTO cjoNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ikantziri Jesoshi: —Paamawentyaawo tapiyakaawori paa, rashitari warijeeyopaeni, eejatzi rashitari Erooreshi. ");
INSERT INTO cjoNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Roojatzi ikantawakaanaka, ikanteeyini: —Tekatsi paa ashi, rootaki ikanantakaeri: “Paamawentyaawo tapiyakaawori paa”. ");
INSERT INTO cjoNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Riyotakotakiri Jesoshi ikenkithashiryaari, ikantziri: —¿Iitaka pikantawakaantari: “Tekatsi paa ashi”? ¿Iitaka kaari pikemaperotanta? ¿Iitaka kaari piyotanta? ¿Pikijoshiryaakitzi pajankaneki? ");
INSERT INTO cjoNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Otzimawita poki, ¿iitaka kaari piñaanta? Otzimawita pikemantari, ¿iitaka kaari pikemanta? ¿Iitaka kaari pikenkithashiryaantaawo ");
INSERT INTO cjoNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","noshekyaantakawori paa? Okaatawita apawakooni paa, ikaatzi owakawori 5.000 shirampari. Ari pagaero tzimagaantapaentsiri. ¿Tsikama okaatzi yeekitatsiri kantziriki? Ikanteeyawakirini: —Okaatzi 12. ");
INSERT INTO cjoNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ikantzi Jesoshi: —Eejatzi paashini, okaatzi paa 7, ikaatzi eejatzi owakawori 4.000. Pagaero eejatzi tzimagaantapaentsiri. ¿Tsika okaatzika kantziri piyeekitakiri? Ikanteeyirini: —Okaatzi 7. ");
INSERT INTO cjoNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ikantziri: —¿Tekirama iroñaaka piyotawakiro? Tee ro nokenkithatakoteri paa inkaaganki, omaanta nokenkithatakotzi riyotaantziri warijeeyo eejatzi Erooreshi. ");
INSERT INTO cjoNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ikantaka rareeteeyanakani Wetheeraki. Ramaetapaakiniri Jesoshi kaari kokichaatatsini. Ikantapaakiri amiriri: —Pipampitawakiri ikokichaatantaneeyaari. ");
INSERT INTO cjoNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ari ikathatanakiri kaari kokichaatatsini, raanakiri othonkapaakanta nampitsi. Reewakitapaakiri rokiki, ipampitakiri rokiki. Rojampitakiri: —¿Kokichaateemi? ");
INSERT INTO cjoNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Raminanee, ikantzi: —Jee, kokichaawitaana noñaawitaari shiramparipaeninta, omaanta tee ikoñaataperotzi, ikimitzimotashitakina inchatopaeni ranashiteeyani. ");
INSERT INTO cjoNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Rapiiteeri eejatzi, ipampiteeri rokiki. Roojatzi ikokichaaperotanee, etsiyatakotaperotanee. Raminanee, koñaaperotanee maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ikantziri Jesoshi: —Eerowa pikinanee nampitsiki pikamantzirikari atziri oetarika awijimotakimiri. Apatzirokya powaneero pipankoki. ");
INSERT INTO cjoNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ikantaka rowaaganaa Jesoshi, itsipatanaari riyotaanewopaeni. Riyaateeyanakini janta Sesareeyaki riwetsikakaantakiri Jiripi. Niyankitanaki awotsiki, rojampitayitakirini riyotaanewo: —¿Iitaka ikenkithashiryaakotanari atziripaeni? ¿Ninkama naaka? ");
INSERT INTO cjoNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Rakanakiri, ikantanakiri: —Apaanipaeni aamaayiteencharini eeroka Jowani kaawoshitakotziriri Tajorentsi. Irira paashinipaeni raamaakimi eeroka riraga kamanantzirorini iñaani Tajorentsi iwaero Iriiyashi. Paashinipaeni ikantzi eeroka inashitachari kamanantzirorini iñaani Tajorentsi piriintaachari. ");
INSERT INTO cjoNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Rojampiteeyakirini: —Eerokakya, ¿iitaka pikenkithashiryaakoeyanarini? Rakanakiri Peetero, ikantakiri: —Eerokataki naamagaeyakarini paerani: eeroka Rotyaantanewo Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Roojatzi ikanantanakari: —Eerowa iroñaaka pikamantakoperotzitanaata, pikante: “Jesoshi rirotaki Rotyaantanewo Tajorentsi, riraga Owawijaakotantatsini”. ");
INSERT INTO cjoNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Roojatzi riraga Jesoshi riyotagaeri eejatzi: —Naaka poñaachari jenokinta, nokoñaatapaaki jaka kipatsikika. Iinja osheki nokemaatsitawenteeyemini. Kyaaryo, itheenkakina aataperoteenchari atziri, eejatzi jewatayitziririni ñaanakowenantatsiri, eejatzi iyotaantzirori Iwaperite Tajorentsi: itheenkaeyenani, rootaki rowamaakaanantenari iinja. Nokamawitakya, omaanta okaate 3 kitejiri, roojatzi nopiriinanteeya. ");
INSERT INTO cjoNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Aritaki ikantaperoeyawitakarini. Riraga Peetero raanakiri inteeneeni, ikantakiri: —¿Iitaka pikanantawori iroka? Tee okameethatzi pikame. ");
INSERT INTO cjoNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Roojatzi ipithokashiiyakarini Jesoshi riyotaanewopaeni, ramineeyanakirini. Roojatzi ishintsithatakiri Peetero, ikantziri: —Pikimitakari Jatanaashi. Piyaate. Eeroka pikenkithashiryaashitakawo ikenkithashiryaari atziripaeni. Tee piyotziro ikowakaakinari Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Roojatzi ikaemakiri Jesoshi piyoteencharipaeni eejatzi riyotaanewopaeni. Ikantakiri: —Aririka pikowaki poyaateeyenani, eero pantziro kaari kameethatatsi pikowashitayitarini eerori. Poyaateeyanakinani, pikyaaryoowenteeyenawoni maawaeni nokowakaakimiri: omawitya aririka pikamakotena. ");
INSERT INTO cjoNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Tekirarika piwetsika pikamakotena, patsipetashita pijeeki, ari piyaataki paamariki kaari tsiwakanitatsini. Omaanta aririka piwetsikakya pikamakotena, eejatzi aririka paapatziyakaayitenarini paashinipaeni atziri eero patsipetashitawo: pikanteetatyeeyaani pañe janta jenokinta. ");
INSERT INTO cjoNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Aririka pashiteeyawoni maawaeni jeekayitatsirini jaka kipatsiki, omaanta piyaate paamariki kaari tsiwakanitatsini, tema patsipetashitakawo pashitayityaawoni oetarikapaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ñaakiro, tekatsi pikantya pipinateri Tajorentsi ijeekakaantemiri janta inampikinta. ");
INSERT INTO cjoNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Tema naaka poñaachari jenokinta, natziritapaaki jaka kipatsikika. Eejatzi nopiyanee janta. Roojatzi iinja nopiyanteeya eejatzi jaka kipatsikika notsipatapaakyaari maawaeni ronampiri Pawa riraga kameethatatsiripaeni, notajorentsiperotapaaki: nokimityaari Pawa. Rootaki okameethatanteeyaari pikenkithashireeyaani: aririka pipashiwentzimotakaakyaari kaariperotatsiri naaka iroñaaka, eejatzi aririka pipashiwentakayaawo noñaani, ari iinja nopashiwentakaapaemi eeroka aririka nopiyee. ");
INSERT INTO cjoNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","—Kyaaryootaki iroka nokamantaperotemiri. Pamine, akaateeyakini iroñaaka jaka. Eerotzitarika pikamiteeyani, aritaki piñaawaena nopinkathariperotapaaki, notajorentsitapaaki. ");
INSERT INTO cjoNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Awijanaki 6 kitejiri. Raanakiri Jesoshi riraga Peetero, Jantyaako, eejatzi Jowa, reewatanakiri janta antawo tonkaari. Ari ijeekapaaki irirapaeni. Ipaashinitanaki Jesoshi, ipaashinitzimotanakiri oyaatziriri. ");
INSERT INTO cjoNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Oshipakiryaanaki imaatha okitamaamawoperotanaki osheki. Jaka kipatsiki tee añiiro kitamaari kimityaawoni iroka. ");
INSERT INTO cjoNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Romapokapaakiri ikoñaatzimotapaakiri Iriiyashini eejatzi Moeseeshini, ikenkithatakaapaakiri Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Iñaawaetashiwaetanaka Peetero: —Iyotaanari, tema okameethataperotzi pamakinaka jaka noñaantakimiri. Iroñaaka nokowaki niwetsikaeyenimi 3 pankoshintsipaeni: apaani pashi, apaani rashi Moeseeshi, eejatzi paashini rashi rirori Iriiyashi. ");
INSERT INTO cjoNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ithaawaperotayitanakini osheki, rootaki kaari riyotanta Peetero iitarika ikanterimi. ");
INSERT INTO cjoNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Otzikaapaakiri menkori. Omapokanaka iñaani Tajorentsi menkoriki, ikantakiri: —Rirotaki notyomi nonintaperotziri, paapatziyaperotyaari. ");
INSERT INTO cjoNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Intsipaete raminawitanaari riyotaanewo, tekatsi riroripaeni, inta apaniroeni Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Roojatzi ipiyanteeyanaani, roerinkaeyanaani. Ikantaperotziri Jesoshi: —Eerowa pikantakotzirokya iroka piñaakiri iroñaaka. Aririka piñaakina nañagae eejatzi, ari pikenkithatakotero okaatzi piñaakina. Naaka poñaachari jenokinta nokoñaatapaaki jaka kipatsiki. ");
INSERT INTO cjoNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ari ikemaeyawitakarini, roojatzi rojampitawakaantanaka iitaka iroka ikantziri Jesoshi: “Nañagae eejatzi”. ");
INSERT INTO cjoNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Roojatzi ikanteeyantakarini riroripaeni: —Riraga iyotaantzirori Iwaperite Tajorentsi ikanteeyini: “Rirotaki itapaakyaawoni ipoke Iriiyashini, eentsikiro rimpaetapaaki ipokapaaki rirori Rotyaantanewo Tajorentsi”. ¿Iitakakya ikanantawaetakari iroka? ");
INSERT INTO cjoNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Riraga Jesoshi rakanakiri, ikantanakiri: —Kyaaryo ikanteetzi: “Riro itapaakyaawoni ipoke Iriiyashini, rowameethateeyapaakirini maawaeni”. Tema naaka rojankinatakotzitakarini paerani: “Osheki ikemaatsityaawo, eejatzi osheki itheenkaetawakiri”. ¿Iitaka rojankinatantawori iroka? ");
INSERT INTO cjoNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Iroñaaka nokantemi: aritaki ipokapaentzi paerani paashini Iriiyashini. Ikantaminthatziri atziri osheki rowashironkaakiri, imonkaatakiro rojankinatakotziteetakaririni paerani. Eejatzi ikimitena naari. ");
INSERT INTO cjoNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Roojatzi ipiyanteeyanaani janta ijeekaeyakininta riyotaanewopaeni paashini. Iñeeyapaakirini itsipateeyapaakarini osheki piyotawentakariri. Ijeeki iyotaantzirori Iwaperite Tajorentsi, iñaanatziri ipiyapiyawaanteteeyakarini riraga riyotaanewopaeni Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ari iñeeyawakirini Jesoshi ipokae, rotsikanataperotawakari. Ishiyashiteeyanakarini, riwethateeyawakarini. ");
INSERT INTO cjoNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Rojampitapaakiri: —¿Iitaka piñaanatawakaanteeyarini? ");
INSERT INTO cjoNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Rakanakiri apaani shirampari, ikantzi: —Iyotaanari, namakimiri notyomi. Ikyaantakari kamaari, romajontziitakinari. ");
INSERT INTO cjoNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Aririka ishinkiwentakaapaeyaari, rowariyaakiri kipatsiki, ishimoretakaanakiri, ratsikaekitakaanakari, ikijopookitakaanakiri. Nokantawitari piyotaanewo: “Petsiyatakoteeri”. Teewee, tee imatziro. ");
INSERT INTO cjoNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Rakanakiri Jesoshi: —Atziri theenkantaniri. Tee paapatziyimaetana. ¿Tsika okaateka piyoteeyantyaarini? Niyotaapiintawitakimiri, omaanta tee paapatziyeeyawakawoni. Intsipaete, pamakinaritya pitomi. ");
INSERT INTO cjoNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ari ramakiniri. Riraga kamaari, iñaapaakiri Jesoshi. Rapitziwitakaanakari eentsi, ipariyakaanakiri kipatsiki, pok. Ipinaapinaatakaanakari, ishinkanawatzitakaanakiri ipaanteki. ");
INSERT INTO cjoNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Riraga Jesoshi rojampitakiri iriri eentsi: —¿Tsika okaatzika itantanakariri? Rakanakiri: —Eeniro reentsitapaaki. ");
INSERT INTO cjoNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Osheki itaakaapiintari paamariki, eejatzi ipiinkakayitapiintakirini iñaaki. Ikowawita rowamaerimi. Pitajonkantzirika, pineshironkateena, petsiyatakoteenari. ");
INSERT INTO cjoNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ikantziri Jesoshi: —¿Iitaka pikanantanari: “Pitajonkantzirika”? Pameentanarika, aritaki imatakimiro eeroka Tajorentsi oetarikapaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ishintsitanaki ikantziri iriri eentsi: —Nameentawitzimi. Teerikama nameentaperotzimi, pamitakotena nameentaperotantemiri. ");
INSERT INTO cjoNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Riraga Jesoshi iñaawakiri ishiyashiteeyapaakarini osheki atziri. Ishintsithatakiri kamaari, ikantziri: —Eerokataki kamaari. Pimajontzitakaantzi, eejatzi pamashikempitatakaantzi. Iroñaaka nokantaperotemi: “Pipakagaeri, eero pipiyantari eejatzi”. ");
INSERT INTO cjoNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Riraga kamaari ikaemakaanakiri eentsi, rapitziwitakaanakari roojatzi rookaneeri. Riraga eentsi ikimiwitakari kamatsiri. Osheki kantayitatsirini: —Kamaperotaki. ");
INSERT INTO cjoNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Omaanta ikathawakoteeri Jesoshi, ipiriinteeri, ikatziyanaa rirori, sherok. ");
INSERT INTO cjoNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Roojatzi ikyagaeyapaeni pankotsiki. Riyoteeyanakani riyotaanewo, rojampiteeyirini: —¿Iitakakya kaari nomatantawo naari netsiyatakoteri? ");
INSERT INTO cjoNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Rakanakiri: —Osheki ishintsitzi riraga kamaari, rootaki kaari pimatantari petsiyatakoteeri riraga shinkiwentawitachari. Eejatzi maawaeni kimiteeyaririni, eero pimateeyirini apaniroeni. Apatzirorika pitzitawentyaari Tajorentsi eejatzi pamanaperoteri, ari ramitakotakimi rirori powawijaakoteri kyaantawitariri kamaari. ");
INSERT INTO cjoNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Roojatzi rowaaganaka Jesoshi eejatzi riyotaanewopaeni janta, ikinanee Karireeyaki. Ari ikowaki rirori riyoteeri riyotaanewopaeni apaniroeni, rootaki imanantanakari riyaatayitaneeni. Ikantanakiri irirapaeni: —Naaka poñaachari jenokinta, nokoñaatapaaki jaka kipatsikika: rooteentsi raakaanteetena. Rayena atziri rowamaena. Ari nokamaperotawitakya, ari okaate 3 kitejiri, eejatzi nañagae. ");
INSERT INTO cjoNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Omaanta tee riyoteeyawakironi ikantawitakariri. Ithaawanteeyanakarini rojampiterimi oetarika ikantawitariri. ");
INSERT INTO cjoNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ikantaka rareeteeyapaakani Kaperinawooki, ijeekaeyapaakini pankotsiki. Rojampitziri Jesoshi riyotaanewo: —¿Iitaka pikantawakaari awotsiki? ");
INSERT INTO cjoNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Imaeriteeyanakini rirori, ipashiwenteeyanakani; rooma ikantawakaanaka janta awotsiki, ikantzi: —Iroñaaka akaateeyinika, ¿ninkama anagaenika apinkatharite? ");
INSERT INTO cjoNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Roojatzi ijeekantapaakawo Jesoshi jeekamentotsi. Ikaemakiri riyotaanewo, ikantziri: —Aririka pikoye pipinkathariwenante, petakoeyaarini maawaeni atziri, eejatzi pamitakoeyerini, pineshironkaeyerini. ");
INSERT INTO cjoNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ramakiniri apaani eentsi. Rojatekapaakiniri niyanki, rawithakitawakiri. Ikantziri: ");
INSERT INTO cjoNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Aririka pineshironkateri aapatziyanari, kimitaririka irika eentsi, eejatzi pikimitzitakina naari: pinintashiretakina naari. Eejatzi okimitaka, aririka pinintashiretena, tee apatziro naaka pinintashireperotena, omaantakya eejatzi Pawa otyaantakinari. ");
INSERT INTO cjoNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Roojatzi riraga Jowa ikantanakiri: —Iyotaanari, noñeeyakirini shirampari, ikantzi: “Naapatziyakari Jesoshi, rootaki nookantakariri kamaari”. Tee iroñaaka akaateeyerini rirori jaka, rootaki nothañaakotantariri. ");
INSERT INTO cjoNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ikantziri Jesoshi: —Eero pithañaakotari. Tema naaka nomatakaakiri itajonkantzi. Irira tee ikijeeyeeni, tema rantakinawo nokowakaakiriri. ");
INSERT INTO cjoNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ninkarika kaari kijaneenteeni rirotaki atsipateeyarini. ");
INSERT INTO cjoNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Aririka riyotawakimi atziri eeroka aapatziyanari, rootaki ikaminthaantawakimiri ipawakimi pimiri, omawitya aririka okaate eechonkiini, aritaki ipinatakiri Pawa. Kyaaryootaki iroka nokamantzimiri. ");
INSERT INTO cjoNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Eejatzi irika eentsi, aapatziyanari: aririka pantakayeri kaari kameethatatsi, aritaki rowashironkaaperotakimi Tajorentsi. Okameethatawitami pikamityaami paerani, eero pantakaantarikya kaari kameethatatsi aapatziyanari; rootaki kaari nowashironkaantemimi. ");
INSERT INTO cjoNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Eenitatsi iroka noshiyakaawentemiri: iroñaaka piyotantyaari tee okameethatziroña pantero kaari kameethatatsi. Aririka antakayemiro pako kaari kameethatatsi, pithatyeero. Aritaki okameethatziri piyaaponthotziitashitya jenokinta, okantyaata janta pañaantaperotapaeyaari. Tee okameethatziroña otzime apite pako eerorika pithatyeero, rootaki piyaatantyaari paamariki kaari tsiwakanitatsini. Tema okanteetatyeeyaani amoreki. ");
INSERT INTO cjoNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Eero janta ikami chowitsi, eejatzi eero otsiwakanitzi paamari roori. ");
INSERT INTO cjoNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Eejatzi aririka antakayemiro piitzi kaari kameethatatsi, pithatyeero. Aritaki okameethatzi piyaaponthotziitashitya jenokinta, okantyaata janta pañaantaperotapaeyaari. Tee okameethatzi eenitatsi apite piitzi: eerorika pithatyeero, rootaki piyaatantyaari paamariki kaari tsiwakanitatsini. ");
INSERT INTO cjoNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Eero janta ikami chowitsi. Eejatzi eero otsiwakanitzi paamari roori. ");
INSERT INTO cjoNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Eejatzi aririka aminakayemiro poki kaari inimotziri Tajorentsi, pikithokireero, pookero. Ari okameethatziri kashetaakini pikyaapae janta ipinkatharitzinta Tajorentsi. Rooma otzimaawityaarika apite poki: iyaatakaashiteemikari paamariki kaari tsiwakanitatsini. ");
INSERT INTO cjoNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Eero janta ikami chowitsi. Eejatzi eero otsiwakanitzi paamari roori. ");
INSERT INTO cjoNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Eeroka aapatziyeeyakinarini, rootaki ikijanteeyantemirini kaari aapatziyeeyanarini. Aririka paapatziyeeyenani, ari piñeero opomeentsitzimotemi. ");
INSERT INTO cjoNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Okameethatzi tziwi. Omaanta aririka opeyanakya owatyorite, tekatsi okantya okatyotanee eejatzi. Ari pikimitya eerori: pikempoyeero iñaani Tajorentsi pajankaneki paakameethatawakaanteeyaarini. Tema okameethatzi: pikantyaani paakameethatawakagaeyaani, maawaeni. Tema pikimitakotakawo tziwi. ");
INSERT INTO cjoNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ikantaka rowaaganaa Jesoshi, ikinakaaneeri riyotaanewopaeni Joreeyaki. Eejatzi riyaatee intatsikeronta Joriraani. Ipiyotawentapaari eejatzi osheki atziri, riyotagaeyapaerini. Tema aritaki rameteeyawoni riyotaantapiintzi. ");
INSERT INTO cjoNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ipokashitapaakiri warijeeyopaeni. Ikowawita ikompitakayaarimi Jesoshi, rootaki rojampitanteeyapaakaririni: —¿Tsikama okantzika Iwaperite Tajorentsi? ¿Oshinetama rookaero shirampari iina? ");
INSERT INTO cjoNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Rakanakiri riraga Jesoshi: —¿Oetakama rojankinatakirini Moeseeshi pikemijantaperotantyaawori? ");
INSERT INTO cjoNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Rakaeyanakirini rirori: —Rojankinarini Moeseeshi oshinetziri atziri rookaero iina. Tema okantzi: “Aririka pikoyi pookaero piina, pityaawo, pojankinateniro paperi pikanteero: ‘Iroñaaka nookaemi’. Roojatzikya pimatantyaawo pookaero”. ");
INSERT INTO cjoNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ikantanakiri Jesoshi: —Tee ikowakaantziro Tajorentsi pookaero piina, omaanta eerokapaeni tee añiiro pikenkithashiryaantari, rootaki rojankinatantakimirori Moeseeshi paerani iroka. ");
INSERT INTO cjoNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Paeraniperoroña ritantakawori riwetsikantaki Tajorentsi, riwetsikakiri shirampari eejatzi tsinani. ");
INSERT INTO cjoNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Rootaki rotsiparyaantyaariri shirampari iriri, eejatzi riniro, kijokiro rowantanakyaawori iina. ");
INSERT INTO cjoNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Rinashitawitani paerani shirampari eejatzi tsinani. Omaanta aririka raaki iina kimitanaa apaani ikantaka: kijokiro rowawakaanakya. ");
INSERT INTO cjoNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Iñaakiri Tajorentsi apaani ikantaka; eero iroñaaka rookakagaeri atziri. ");
INSERT INTO cjoNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Roojatzi ijeekantapaa pankotsiki. Rojampitapaeri eejatzi riyotaanewo: —¿Tsika okantaka iroka pikantakiri? ");
INSERT INTO cjoNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ikantziri: —Ninkarika ookeroni iina aririka ragae paashini tsinani, tema iñaathatzimotaawo iinaperoni. ");
INSERT INTO cjoNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Eejatzi okimitya roori tsinani, aririka ookaeri oemi, agaerika paashini shirampari, tema oñaathatzimotaari oemiperoni. ");
INSERT INTO cjoNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ikanta ramaetapaakiniri eentsipaeni, ikantapaakiri Jesoshi: —Pipampiteri eejatzi pikanteri Tajorentsi kameetha ijeekakagaeyerini irika eentsipaeni. Omaanta ikantawakiri riyotaanewopaeni: —Eero pamiri eentsipaeni jaka, rocheempitaririkari iyotaanari. ");
INSERT INTO cjoNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Tee inimotanakiri Jesoshi rantakiri. Ikantanakiri: —Pishinetenari ipokashitenaata eentsipaeni. Eerowa pikatziyakari. Piñeeyakirini irikapaeni eentsika, tee itheenkaeyanani, inta rameenteeyakinani. Tema reewawenteeyirini Tajorentsi maawaeni kimiteeyaririni rirori. ");
INSERT INTO cjoNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Kyaaryootaki iroka nokamantaperotzimiri, irika eentsipaeni rameenteeyakarini Tajorentsi. Riroma riraga kaari oshiyarini eentsi, riraga kaari ameentari Tajorentsi, eero imatziri reentsitetari. ");
INSERT INTO cjoNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Inataperoeyawakirini eentsi, rowaeyakinirini rako iitoki. Ikanteeyirini: —Kameetha ineshironkatemi Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ikanta riyaatee Jesoshi, ikinanee awotsiki. Ishiyapaaka apaani shirampari, rotziwerowashitapaakari. Ikantziri: —Iyotaantatsiri kameethari. ¿Oetakama nanteri nañaantyaari, nokanteetatyeeyaani? ");
INSERT INTO cjoNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ikantziri: —¿Iitaka pikanantanari: “Kameethari”? Tekatsi kameethatatsini, inta apatziro Tajorentsi ikameethatzi. ");
INSERT INTO cjoNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Piyomacheetawo iroka ikaminagaetakiriri Moeseeshini: “Eero powamaantzi. Eero pishirontawo kaari piina. Eero pikoshitzi. Eero pitheeyakotari atziri. Eero pamatawitantzi payitantyaariri rashitayitarini paashini atziri. Pipinkathateri piri eejatzi piniro”. ");
INSERT INTO cjoNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ikantanakiri rirori: —Pamine, eenironi newankaritapaakini, nothotyaakiro maawaeni irokapaeni, roojatzi iroñaaka. ");
INSERT INTO cjoNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Riraga Jesoshi, raminanakiri, inintashireperotakiri. Ikantakiri: —Eenitatsi apaani kaari pantzi. Piyaate iroñaaka pipimantayiteroni maawaeni pashaagawo. Pipashiteeyaarini kaari tzimatsi rashaagawo, rooma eeniro ikashiyakaaperotakimiri Tajorentsi kaari thonkanitachani jenokinta. Roojatzi poyaatantanakina. ");
INSERT INTO cjoNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ikemawakirira ikantakiriri, ookantzimotapaakari rajankaneki rowashiretakotanakawo. Ro rowashiretantanakari tema oshekini tzimimotziriri rowaagawo. Roeyomaetanaka, riyaatanee. ");
INSERT INTO cjoNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ari ipithokashitanakari Jesoshi riyotaanewo, ikantziri: —Riraga ashaagantzinkari opomeentsitzimotari ikowaki Tajorentsi ipinkathariwenteri. ");
INSERT INTO cjoNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ikemanteeyawakaririni riyotaanewo, rotsikanatanakari. Rapiiteeri eejatzi Jesoshi, ikantziri: —Notyomipaeni, kyaaryo opomeentsitzimotari atziri ikowaki Tajorentsi ipinkathariwenteri aririka rameentyaawo rowaagawo. ");
INSERT INTO cjoNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Noshiyakaawentemiri kameeyo. Tema opomeentsitaka roshinthateri kameeyo imooki kithapi. Omaanta pomeentsiperotachari ashaagantzinkari ikowaki Tajorentsi ipinkathariwenteri. ");
INSERT INTO cjoNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Tema osheki iroñaaka rotsikanateeyanakarini rirori. Ikantawakaanaka: —¿Ninkama iroñaaka awijakotaatsini? Pomeentsiritaani. ");
INSERT INTO cjoNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Raminanakiri Jesoshi, ikantziri: —Eero imatashitawo atziri rowawijaakoteeya rirori, omaanta rirotaki Tajorentsi materini rowawijaakoteeri. Tekatsi pomeentsitzimotyaarini rirori. ");
INSERT INTO cjoNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Roojatzi Peetero ikantanakiri rirori: —Omaantakya naaka, nookayitakironi maawaeni, oetarika nashiteeyawitarini, noyaatanakimi eerori. ");
INSERT INTO cjoNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ikantzi Jesoshi: —Kyaaryootaki iroka nokantemiri. Aririka pikowaki poyaatanakina, eero patsipetashitawo pookayiteroni pinampi, pirentzipaeni, pitsiropaeni, piniro, piina, piri, peentsitepaeni, powanepaeni. Eejatzi aririka pikowaki pikamanantero noñaani raapatziyanteenari atziri, eero patsipetashitawo. ");
INSERT INTO cjoNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Kyaaryo, ikijawentemiro paapatziyana opomeentsitzimotawitemi, omaanta eero patsipetashitawo. Aririka pookanakiro apaani oetarika, ipaemi Tajorentsi 100: pipankopaeni, pirentzipaeni, pitsiropaeni, piniropaeni, peentsitepaeni, powanepaeni, maawaeni. Aritaki iinja otzimimoteeyeemini osheki janta pañaaperoeyapaeninta, pikanteetatyeeyaani. ");
INSERT INTO cjoNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Eenitatsi iroñaaka osheki pinkatharitatsiri jaka kipatsikika, omaanta eero ipinkathariteeyini maawaeni janta jenokinta: rooma aamashitya apaanipaeni pinkatharitagaantatsini. Eejatzi eenitatsi iroñaaka osheki owashironkaenkaripaeni, omaanta iinja janta jenokinta ipinkatharitagaantapae rirori. ");
INSERT INTO cjoNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","33","Ikanta ikineeyanakini awotsiki, rooteentsi rareeteeyaani Jerojareeki, reewatanaki Jesoshi. Rotsikanatanakari oyaateeyiririni, eejatzi ithaawaeyanakini. Ari ipiyotziri eejatzi riraga 12 riyotaanewo, ikantziri: —Pikemijantena. Iroñaaka piyoteeyakini atonkagaeyatyeeni janta Jerojareeki. Tema naaka poñaachari jenokinta, nokoñaatapaaki jaka kipatsikika. Rooteentsi omonkaatya raanteetenari ragaeyenani jewatayitziririni ñaanakowenantatsiri eejatzi iyotaantayitzirorini Iwaperite Tajorentsi, rowamaakaantakina. Raakaanteena eejatzi, raantenari kaari yotziri Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ishirontawenteeyakinani, reewapootena, ipajapajaatena, rowamaena. Okaatapaaki 3 kitejiri, roojatzi nopiriinantaneeya. ");
INSERT INTO cjoNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ipokashitakiri okaakini Jantyaako, eejatzi Jowa, riraga itomipaeni Sewereeyo. Ikantziri: —Iyotaanari. Nokowaki pishinetenawo iitarika nokowakotemiri. ");
INSERT INTO cjoNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ikantawakiri Jesoshi: —¿Iitaka pikoyiri noshinetemiri? ");
INSERT INTO cjoNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ikantziri: —Iinja pipinkatharitaperote, pishinetena nojeekimotemi pakoperoki. Irika yeeyika ijeekimotemi pampateki, nokimiteeyemini eerori pipinkatharitzi. ");
INSERT INTO cjoNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ikantziri Jesoshi: —Tee piyotzi iitarika pikantakinari. Pamine, osheki nokemaatsityaawo naari, ¿arima pimatakiro osheki pikemaatsityaawo eerori? ");
INSERT INTO cjoNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ikantaki riyotaanewo: —Jee, ari nomatakiro. Ikantawakiri: —Iinja piñeero pikemaatsityaari. ");
INSERT INTO cjoNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Omaanta tekatsi nokantya noshinetemi pijeeki nakoperoki, eejatzi nampateki. Inta kantatsine Pawa ninkarika jeekimotenani: riyotzitakarini paerani riraga jeekimotenani. ");
INSERT INTO cjoNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ikemaeyantakaworini riraga paashinipaeni riyotaanewo iroka ikantakiri, ikijanteeyanakarini riraga Jantyaako eejatzi Jowa. Nokijanteeyanakaririni ikowaeyawitakityaani ipinkathariteeyenimi. ");
INSERT INTO cjoNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ikanteeyirini Jesoshi: —Pipokaeyeni. Piyotzi ijeeki iwinkatharitepaeni kaari yotziri Tajorentsi. Romperatayitakarini atziripaeni rirori. Eejatzi riraga jewatatsiripaeni, romperateeyakarini isheninkapaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Eero pikimitari eeroripaeni. Omaantakya aririka pikowaki pipinkathariwenteeyerini atziri, petakoeyaarini maawaeni pitsipateeyarini. ");
INSERT INTO cjoNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Eejatzi aririka pikowaki peewawenante, otzimatye petakoeyaarini maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Naaka poñaachari jenokinta, nokoñaatapaaki jaka kipatsikika. Tee ro nopokantyaari nomperatemi eerokapaeni, intakya nopokantari namitakoeyemini, eejatzi nokamawenteeyemini eerokapaeni atziri nopinawenantemirori kaari kameethatatsi pantziri, nowawijaakotantemiri. ");
INSERT INTO cjoNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ikanta rareetaka Jesoshi janta nampitsiki owaero Jerikoo. Rowaaganaa eejatzi, itsipateeyanakarini riyotaanewopaeni eejatzi osheki piyoteenchari. Ari ijeekaetzini awotsinampiki shirampari iitachari Waritemeeyo, rirotaki itomi Temeeyo. Kaari kokichaatatsi Waritemeeyo, inethaakopiintziri atziri ipashityaari koriki. ");
INSERT INTO cjoNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ikemakotawakiri kaakitaki Jesoshi, riraga najareetejatzi. Owakira ikemakotawakiri, ikaemawakiri, ikantziri: —¡Jesoshi! Tema eeroka icharineeteni Iraviiri, pineshironkatapaena naari. ");
INSERT INTO cjoNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Osheki atziri ishintsitheeyakirini: —¡Pimaerite! Eekiro ikaemaperotanakitzi, ikantzi: —¡Jesoshi! ¡Icharineeteni Iraviiri! ¡Pineshironkataneena! ");
INSERT INTO cjoNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ikatziyapaaka Jesoshi, ikantzi: —Pikaemeri. Ikaemaetziri kaari kokichaatatsi, ikanteetziri: —Piweshiryaanakya, pikatziyanee. Ikaemimi irinta. ");
INSERT INTO cjoNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Roojatzi rookantanakawo ipewiryaakotari, ikatziyanaka, sherok. Riyaatashitanakiri Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ikantawakiri: —¿Iitaka pikowakotanari? ¿Tsika nokantemika? Rakanakiri riraga kaari kokichaatatsi. —Pawa, nokowaki naminee. ");
INSERT INTO cjoNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ikantziri Jesoshi: —Iroñaaka piyaatee. Pameentakina, rootaki petsiyatakotantaari. Roojatzi ikokichaatantanaa, royaatanakiri rirori. ");
INSERT INTO cjoNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Paashini kitejiri rareetzimatakaapaakari Jesoshi Jerojareeki eejatzi Wetejajeeki, okaakiniki Wetaaniyaki: itonkaanakiro tonkaari oetachari Oriiwomashi. Riraga Jesoshi rotyaantakiri riyotaanewo apite, ");
INSERT INTO cjoNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ikantakiri: —Piyaate janta nampitsiki. Aririka pareetakya janta piñaapaakiri apaani wooro ewankari, tekira ikyaakotaa. Eeniro ithatakotaka; pithataryaakotashitapaakyaari pamakinari. ");
INSERT INTO cjoNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Aririka ikanteetawakimi: “¿Iitaka pithataryaakotantariri wooro?” pikantanakiri: “Ikaemakaantziri Awinkatharite. Iinja roepiyeemiri”. Aritaki ishinetawakimiri iwoorote. ");
INSERT INTO cjoNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Roojatzi riyaatanaki riyotaanewo. Iñaapaakiri wooro janta awotsiki. Ithatakotaka okaakini ashitakontsi pankotsi. Ithataryaakotapaakiri. ");
INSERT INTO cjoNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Eeniro ijeeki atziripaeni, rojampitawakiri: —¿Oetaka pantziri? ¿Iitaka pithataryaakotantariri wooro? ");
INSERT INTO cjoNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Rakanakiri, ikantziri okaatzi ikantawakiriri inkaaganki Jesoshi. Ari ishinetawakiri iroñaaka raanakiri wooro. ");
INSERT INTO cjoNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ari ikathatakotanakiniri Jesoshi. Rowankitakiniri imitzikaaki iithaaripaeni, roojatzi ikyaakotantanakari rirori. ");
INSERT INTO cjoNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ari ranashitakaanakari awotsiki, iñaaperoeyawakirini maawaeni atziri, romaankaeyakironi kithaarentsipaeni awotsiki. Paashinipaeni ichekakiro oshi kompiroshi, eejatzi rowakiniri awotsiki. ");
INSERT INTO cjoNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Riraga jewateeyakiririni eejatzi impaeteeyatsirini, ikaemaeyanakini: —¡Irikatapaaki owawijaakoteeni! ¡Thame añaaperotawakiri! ¡Rirotaki rotyaantakaeniri Tajorentsi! ");
INSERT INTO cjoNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Paerani Iraviirini ipinkathariwentzirini nojoriiyotzinkarite: omaanta iroñaaka, ipinkathariwentakae irika añaawakirika. Rirotaki icharineetenipero Iraviirini. Thame añaaperoteri Tajorentsi jenokijatzi. ");
INSERT INTO cjoNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Roojatzi rareeteeyapaakani Jerojareeki, ikyaapaaki Tajorentsipankoki. Ithotyaapaakiro raminayitapaakironi. Ari itsiteniityaanaki oorya. Roojatzi ishitowantanakari, ipiyanaka Wetaaniyaki. Itsipateeyanakarini 12 riyotaanewo. ");
INSERT INTO cjoNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ari okitejitanaki eejatzi rookaneero Wetaaniya, riyaate Jerojareeki. Ari niyanki awotsi aawitakari itashe Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Iñaakiro inteena inchato iitachari iyeera. Otzimawita oshi. Ari riyaatashitziro, ikowawitapaakawo okithoki. Tee iñiiro, inta apatziro oshi. Tekiraata iyopaeteta okithokitanteeyaari. ");
INSERT INTO cjoNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ikantanakiro Jesoshi: —Tekatsi owaeyaawoni pikithoki iinja. Ikemakiri riyotaanewopaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Roojatzi rareeteeyaani eejatzi Jerojareeki. Ikyaapae Tajorentsipankoki. Rookaeyapaakirini maawaeni pimanteeyawitacharini eejatzi maawaeni amananteeyawitacharini. Rotatsinkitayitapaakirini imeejatepaeni riraga pimantayitatsirini iyorikite. Eejatzi rotatsinkitayitapaakirini ijeekamentopaeni pimanteeyawitaririni jamomo. ");
INSERT INTO cjoNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ithañaanakawo ipimantero owaagawontsi janta Tajorentsipankoki. ");
INSERT INTO cjoNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ari riyotaantaki, ikanteeyirini: —Paerani rojankinateetzironi Iwaperite Tajorentsi, ikantzini: “Ikantzi Tajorentsi: ‘Iroka Tajorentsipankoka okameethatzi pikenkithatakaapiinteeyenani eerokapaeni maawaeni inashitzinkaripaeni atziri, omaanta eerokapaeni pikoshitashiteeyakarini atziri pokaeyawitacharini jaka Tajorentsipankokika’ ”. Tee okameethatzi iroka panteeyakirini. ");
INSERT INTO cjoNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ari ikemaeyawakirini maawaeni riraga piyotawentariri, rootaki rotsikanateeyantanakaririni. Eejatzi ikemakotakiri jewatayitziririni ñaanakowenantatsiripaeni, iyotaantzirori Iwaperite Tajorentsi, maawaeni. Ikanteeyawitakani: —¿Tsika akanterika Jesoshi owamaantyaariri? Omaanta tekatsi ikanteri, ithaawanteeyakarini. Tema ipinkatheeyakirini atziri Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Itziroryaanaki oorya, ari rookaneero Jesoshi nampitsi. ");
INSERT INTO cjoNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Okitejitanaki eejatzi, ipiyanaa Jesoshi eejatzi riyotaanewopaeni janta Jerojareeki. Ikineetaneero iyeera. Iñaapaakiro, okamanaki, roojatzi janta oparithaki. ");
INSERT INTO cjoNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ikenkithashiryaakiro Peetero ikantanakiri Jesoshi chapinki. Ikantziri: —Iyotaanari, paminero iyeeraka powamayimatakiri chapinki. Kamanaki. ");
INSERT INTO cjoNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Rakanakiri Jesoshi: —Pameentyaari Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Kyaaryootaki iroka nokamanteeyemirini. Aririka pikanteri Tajorentsi: “Poshirinkero otzishinta, pookero janta inkaareki”, eerorika pitheenkashiretzi, inta piyotaperotaki roshirinkero, aritaki imatakimiro. ");
INSERT INTO cjoNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Rootaki nokamanantzimirori iroka: aririka pikenkithatakayeri Tajorentsi, oetarika pikanteriri, pikenkithashirya: “Aritaki imatakinawo nokantakiriri”. Pameentaperotyaaririka, aritaki imatakimiro. ");
INSERT INTO cjoNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Aririka pikenkithatakayeri Tajorentsi, aririka eekiro piyaatatyee pikijiri paashini atziri ari pityaawo piyaate pikaminthayeri irira: oetarikapaeni rantzimotakimiri eero pameñaawo pikijiri inta pipeyakoteniri. Roojatzi eerori, eero ikijimi Pawa Tajorentsi pantayitzirini eerori, inta ipeyakotemiro. ");
INSERT INTO cjoNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Eerorika pipeyakotziniri atziri, kijakimiri, eero ipeyakotzimiro eerori Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ipiyakagaeyaarini eejatzi Jerojareeki, ikatziyatziyawaeta janta Tajorentsipankoki. Riraga jewawentayitziririni ñaanakowenantatsiripaeni, iyotaantziroripaeni rojankinarini Moeseeshi, eejatzi aataperoteenchari ipokashiteeyakirini. ");
INSERT INTO cjoNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ikanteeyapaakiri: —¿Ninka iyotaakimirorika pipinkatharitantari pimatayitantaworini pantayitzirini? ¿Ninkama iitakimirika pinkathari, pantantyaawori iroka? ");
INSERT INTO cjoNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ikantawakiri Jesoshi: —Iroñaaka apaani nojampiteeyemini eerori. Aririka pakakina eerori, roojatzi nokamanantemiri naaka ninkarika otyaantakinari. ");
INSERT INTO cjoNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Riraga Jowa ikaawoshitakotayitzinirini Tajorentsi atziri. ¿Ninkama otyaantziriri ikaawoshitakotayitzinirini? ¿Riroma Tajorentsi otyaantziriri? Teerikama, ¿riroma atziri otyaantziriri? Pakenatya. ");
INSERT INTO cjoNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ari ikantawakaanaka ñaanakowenantatsiripaeni: —Aririka akanteri: “Rirotaki Tajorentsi otyaantziriri”, ikanteekari: “¿Iitaka kaari paapatziyantari Jowa?” ");
INSERT INTO cjoNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Eejatzi eero akantziri: “Rirotaki atziri otyaantziriri”. Ikijanakaekari maawaeni atziri. Ñaakiro, riraga ñaanakowenantatsiri ithaawanteeyakarini atziripaeni; maawaeni irira iñaaperoeyakirini kameetha Jowa, ikanteeyini: “Tema irira Tajorentsi otyaantziriri Jowa ikamanantzi iñaani”. ");
INSERT INTO cjoNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Rootaki ikanantariri ñaanakowenantatsiripaeni: —Tee niyotzi ninkarika otyaantziriri. Ikantzi Jesoshi: —Eejatzi naari, eero nokantzimi ninkarika otyaantanari nopinkatharitantari nomatantawori iroka. ");
INSERT INTO cjoNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Roojatzi roshiyakaawentziniri Jesoshi iroka, ikantziri: —Ipankitziro shirampari roowamashite. Eejatzi rotantotakotakiro maawaeni othapiki. Eejatzi riwetsikashitakiro tsikarika rawishoowero oowa rowantyaawori owaaga. Riwetsikakiro eejatzi pankochaaniki ijeekantyaari jenoki raminakowenantyaawori maawaeni. Roojatzi ikantziri thamaetakoteroni: “Paminawiritantenawo maawaeni: iinja pipashitena kashetani”. Roojatzi riyaatantanaka paashiniki kipatsi. ");
INSERT INTO cjoNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ojamanitapaentzi iraakanaki okithoki oowa. Ari riraga ashitawori rotyaantawitari ronampiri apaani, raagaantakitemi oowa. ");
INSERT INTO cjoNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Tee ipawakiri, omaanta raawakiri, shepik; ipajatashitawakari, tak, tak, tak. Roepiyawaeri, tekatsi raanaki. ");
INSERT INTO cjoNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ari rotyaantawitaka eejatzi paashini ronampiri. Rompojawakiri iitoki, pok, pok, rowashironkaawakiri. ");
INSERT INTO cjoNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Rotyaantawitaka paashini eejatzi. Rowamaawakiri, shemi. Eejatzi rotyaantawitakari osheki paashinipaeni: apaanipaeni ipajapajaatawakiri; irira paashinipaeni rowamaawakiri. ");
INSERT INTO cjoNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Apatziro apaani yotapaencha itomi rirori, inintaperotziri. Ikenkithashiryaanaka rirori: “Rirorika notyomi irira ipinkathatawakiri”. Rotyaantawitakari rirori. ");
INSERT INTO cjoNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Omaanta ikantawakaanaka thamaetakotzirori: “Kaakitakira itomi ashitawori, aririka ikamaki iriri, rirotaki irika ashitaperoteeyaawoni. Thame owamaawakiri, roojatzikya aakotanteeyaawo aaka roowamashite”. ");
INSERT INTO cjoNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ari raawakiri, rowamaawakiri, shemi. Rookakiri othapikinta oowamashi. ");
INSERT INTO cjoNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","¿Iitaka pikenkithashireeyarini? ¿Tsika ikanterika ashitawori rowamaashite? Tema ari ipokaki irira, ithonkapaakiri ratziritepaeni. Paashini raminee aminawiritantenirini. ");
INSERT INTO cjoNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","Tema piñaanatziro Iwaperite Tajorentsi, tsikarika okantakotana naaka, noshiyakawo mapi. Okantzi: “Riraga wetsikaeyirorini pankotsi itheenkakiro apaani mapi ikantzi: ‘Tee okameethatzi’, omaanta iinja rowaga mapi itheenkawitakari, iñaakiro riraga Tajorentsi okameethatzi, tema rirotaki yoyaakirori kijotakaaperoteroni pankotsi. Tema rootaki otsikanatantanakawori aakapaeni”. ");
INSERT INTO cjoNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Riyotakoeyawakironi ikantakiri Jesoshi, rirotaki roshiyakaawentakiri irirapaeni. Rootaki ikowaeyantawitakarini ragaeyanakirinimi, omaanta ithaawanteeyakarini riraga piyotawenteeyakaririni. Rootaki rookaeyantanaarini, riyaateeyaneeni. ");
INSERT INTO cjoNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Rotyaanteetziri warijeeyopaeni eejatzi oyaatziriri Erooreshi. Ikowawitaka ikompitakayaarimi Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Rareetapaaka, ikantapaakiri: —Iyotaantatsiri, niyoteeyakimini eerokataki kameethatatsiri. Tee okantzimoneentzimi oetarikapaeni ikantayitzirini atziri, tee pithaawantari. Kameetha piyotaantziro ikowakagaeyeerini Tajorentsi. ¿Okameethatzima aaka joriiyopaeni noperi iwinkatharite oroomajatzi koriki? ¿Teerikama okameethatzi? ¿Noperima? ¿Eeroma nopiri? ");
INSERT INTO cjoNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Riyotakotakiri Jesoshi, ikowashita ramatawiterimi irika jampitakiriri. Ikantziri: —¿Iitaka pikowantakari pikompitakayenami? Pamakinari koriki, poñaayenari. ");
INSERT INTO cjoNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ari apaani ramakiniri. Rojampiteeyirini: —¿Ninkama oshiyakaawentachari ipooka? ¿Ninkama ashitawori iwaero jankinateencharika? Rakaeyanakirini rirori, ikantziri: —Irira ashitawori Seesari, riraga iwinkatharite oroomajatzi. ");
INSERT INTO cjoNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ikantziri: —Panteniri pinkathari ikowakaemiri, eejatzi panteniri Tajorentsi ikowakaemiri rirori. Rotsikanateeyanakarini riraga jampiteeyiririni. ");
INSERT INTO cjoNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ikantapiintzi saroseeyo: “Eero ipiriintaa kamatsiri”. Ari ipokashitziri rirori Jesoshi, rojampitapaakiri: ");
INSERT INTO cjoNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Iyotaantatsiri, ikantzini Moeseeshi: “Eenitatsirika shirampari iina, omaanta tekatsirika itomi, aririka ikamaki, okameethatzi ragaero iinani rirentzi itzimakaanteeyaawori otomi. Itzimapaakirika otomi kimiwitanaka rirotaki ashityaarini rirentzini itomi”. ");
INSERT INTO cjoNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ari. Eeniro shirampari rirentzi 6. Raawita iina, roojatzi ikamaki. Tekira itzimakayiro itomi. ");
INSERT INTO cjoNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Raawitaawo rirentzini apitetapaentsiri. Ikamaki rirori, eejatzi tee itzimakayiro itomi. Eejatzi ikimitaa rirori riraga tres-tapaentsiri. ");
INSERT INTO cjoNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Eejatzi rirori ikimiteeyakani maawaeni rirentzini. Tekatsi tzimakayeroni itomi. Roojatzi okamantaka roori tsinani. ");
INSERT INTO cjoNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Iinja aririka ipiriinteeyaneeni kamaeyeentsirini, ¿ninkama agaeroni? Tema iinanteeyawitawoni maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ikantziri Jesoshi: —Tee piyotziro Iwaperite Tajorentsi, eejatzi tee piyotakotziri Tajorentsi, itajorentsiperotaki, tema rootaki pikompitantakawori iroka. ");
INSERT INTO cjoNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ikamaeyakini. Iinja ipiriinteeyaneeni eejatzi. Omaanta eero ragae eejatzi iina. Eero itzimae aakagaerini eejatzi. Aritaki roshiyapaeyaari ronampiri Tajorentsi jeekatsiri jenokinta. ");
INSERT INTO cjoNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Iroñaaka nokamantemi: aritaki ipiriinteeyaneeni kamatsiripaeni. Tema piñaanatakiro rojankinarini Moeseeshi. Okenkithatakotziro inchashimpoki, oponthowitaka omaanta tee othonka. Janta ikemakiro paerani Moeseeshi ikantziriri Tajorentsi: “Naaka Tajorentsi, ikantani ipinkatheeyakinani Awaraama, Ijaaka, eejatzi Jakoowo”. ");
INSERT INTO cjoNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ñaakiro, eeniro rañi riroripaeni ishireki, roojatzi ikantani raapatziyari Tajorentsi. Rootaki pikompitantakawori pikenkithashiryaashitaka kamaki. Ñaakiro, eero athonkaperoeyaani. Osheki pikompitaperotakawo eerori. ");
INSERT INTO cjoNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Eeniro jaga apaani iyotaantzirori Iwaperite Tajorentsi. Tema ikemakiri rirori. Riyotawakiri Jesoshi kameetha riyotaakiri saroseeyopaeni. Roojatzi rontsirokantapaakari rojampitapaakiri: —¿Iitaka ikowakaaperoteeri Tajorentsi? ");
INSERT INTO cjoNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Rakanakiri Jesoshi: —Tema rojankinatakaeniro Moeseeshi paerani ikowakaaperoteeri Tajorentsi. Eenitatsi iroka rojankinatzirini: “Nojoriiyotzinkaritepaeni, pikemijanteeyenani. Riraga Tajorentsi, rirotaki Awinkatharite, apaniroeni ipinkatharitzi irira. ");
INSERT INTO cjoNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Oshekipero pinintashireperoteri, maawaeni pajankaneki, pikantyaani. Eejatzi pikenkithashiryaapiinteri”. ");
INSERT INTO cjoNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Eekiro rojankinatatziini kaminagaantsi, ikantziri: “Pikimita eeroka osheki pininta apaniroeni, eejatzi pikimiteeyerini maawaeni atziri osheki pinintaperoeyerini”. Rootaki ikowakaaperoeyakaerini. ");
INSERT INTO cjoNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ikantanakiri iyotaantzirori Iwaperite Tajorentsi: —Jee, aritaki. Kyaaryootaperotaki iroka pikantakiri. Apaniroeni ikanta Tajorentsi, tekatsi paashini. ");
INSERT INTO cjoNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Okameethataperotzi anintashireperoteri maawaeni ajankaneki, akenkithashiryaapiinteri. Eejatzi akimita aaka aninta, eejatzi akimiteri maawaeni akaateeyinira, anintaperoeyerini rirori. Rootaki ikowakaaperotakaeri Tajorentsi. Tee ro ikowaperote atayeniri tsimeripaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ikemakiri Jesoshi, kameetha ikantakiri, ikantziri: —Rooteentsi pipinkathateri Tajorentsi, ipinkathariwenantemiri rirori. Roojatzi ithaawantanaka atziripaeni rojampitaneerimi eejatzi. ");
INSERT INTO cjoNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Riyotaantzi Jesoshi janta Tajorentsipankoki: —Ikantzi iyotaantzirori Iwaperite Tajorentsi: “Riraga Rotyaantanewo Tajorentsi, icharineeteni Iraviiri”. ¿Iitaka ikanantari? ");
INSERT INTO cjoNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Tema ro Ishire Tajorentsi jankinatakaeririni Iraviiri. Rojankinatakironi iroka: “Riraga Tajorentsi ikantziri Nowinkatharite: ‘Pijeeki jaka nakoperoki, pikaatena apinkathariteeyeni. Aritaki nowashironkagaeyerini maawaeni kijeeyawitakimirini’ ”. ");
INSERT INTO cjoNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Tema ikenkithatakotzitarini Iraviiri Rotyaantanewo Tajorentsi, ikantziri: “Nowinkatharite”. ¿Tsika ikantyaari Iraviirini ipinkathateeri icharineeteni impaetatsiri ijeeki? Ari ikemaeyawakirini, ikimoshireeyanakini osheki piyotawentakariri. Ikanantakari iroka riyotakaakiri atziri riyote riraga Rotyaantanewo Tajorentsi kaari apatziro icharineni Iraviiri omaanta eejatzi rirotaki itajorentsite paeraniperoroña tekira ipokapaaki kipatsiki. ");
INSERT INTO cjoNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Eejatzi ikantziri: —Paamayaarira iyotaanteeyawitaworini Iwaperite Tajorentsi. Ikowashita rowaneenkatya, ikantakaaperotyaawo iithaari, ikinakinathanthanatziitakayero. Ikowaki iñaaperotashityaari atziri jaga nampitsiki. ");
INSERT INTO cjoNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Eejatzi aririka riyaatapiinte janta pankotsiki ipiyotantapiintarira joriiyopaeni, riyoyaapiintziro jeekamentotsi kameethaperotatsiri. Eejatzi aririka ipiyoteeyani atziri rowaeyani ikowaki rirori rojatekapaeya niyanki itsipatanteeyaaririni pinkatharipaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Rowashironkayiro kamatsiri oemi raapithatapiintziro maawaeni tzimimotawitawori. Rojamanitziro ikenkithatakayiri Tajorentsi, wero, wero. Osheki ramatawitantzi, omaanta iinja rookeri Tajorentsi paamariki kaari tsiwakanitatsini. ");
INSERT INTO cjoNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ari ijeekaki Jesoshi, imontetakawo rotetantapiintariri korikika riwetsikantyaawori kameetha Tajorentsipanko. Raminaminthatziri osheki pokatsiripaeni, rotetziri iyorikite roteteeyapiintzinirira. Ipoki osheki ashaagantzinkari, rotetapaaki oshekipero iyorikite. ");
INSERT INTO cjoNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Opokapaaki roori kamatsiri oemi ashironkaenkawo. Otetapaakiri roori apimerontakite oorikyaanikite, tee ipinaperowitya irika. ");
INSERT INTO cjoNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","44","Ikaemiri riyotaanewo, ikantziri: —Kyaaryootaki iroka nokamantemiri: eechonkiini otetawitaka iroka ashironkaenkawo, omaanta iñaaperotakiro Tajorentsi okameethatzi. Tema opakiri maawaeni tzimimotawitakawori: tekatsi iroñaaka amananantaneeya owanawo. Omaanta riraga ashaagantzinkari, osheki roteteeyawitakani, omaanta tee iñaaperotziri Tajorentsi ikameethatzi: tema oshekini iyorikite ikempoyaashitari. ");
INSERT INTO cjoNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Roojatzi ishitowakaantanakari Jesoshi Tajorentsipankoki. Ikantziri apaani riyotaanewo: —Iyotaanari. Paminero mapika riwetsikanteetawori Tajorentsipanko kameethataki. ");
INSERT INTO cjoNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ikantziri Jesoshi: —Piñaakiro tsika okantari iroka mapipanko. Antawo naawita, omaanta iinja ishekiroryagaeteero, ookayitanakyaani jantapaeni mapi. Othonkaperotanakya pankotsi. ");
INSERT INTO cjoNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Roojatzi rareetapaaka tonkaariki owaero Oriiwomashi. Imontenampitapaakawo Tajorentsipanko. Riyaatakaaneentanakiri jantyaajeeni Jesoshi, Peetero, Jantyaako, Jowa eejatzi Antereeshi. Ari ijeekapaaki. ");
INSERT INTO cjoNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Rojampitapaakiri: —Pikamanteeyenani. ¿Tsika okaateka ishekiroryaanteetyaawori maawaeni Tajorentsipankonta? Arima iinja omonkaatapaeyaarika ishekiroryaantyaawori, ¿tsika nokantyaaka niyotantyaari? ");
INSERT INTO cjoNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ikantziri Jesoshi: —Kyaaryoowa, ramatawiteetzimikari. ");
INSERT INTO cjoNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Eenitatsi osheki pokatsini, ikante: “Naaka Rotyaantanewo Tajorentsi”. Ramatawitapaakiri osheki atziri. ");
INSERT INTO cjoNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Aririka pikemakoteri romanatawakaaka atziri, eejatzi pikemiri paashini kantatsini: “Romanatawakagaeyaani atziri”. Omaanta eero pithaayi. Aritaki okantyaari iinja, romanatawakaapiintya, omaanta tekiraata omonkaata nopinkatharitantapaeyaari. ");
INSERT INTO cjoNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Riraga atziri jeekatsiri paashinijatoki kipatsi romanatapiintanakiri atziripaeni jeekayitatsirini paashinikipaeni kipatsi. Eejatzi apaani jewawenantatsiri ragaeyanakirini inampijatzipaeni romanatakayaari. Omoyekapiintayitanakyaani kipatsi, eejatzi itasheyapiinteeyanakini osheki atziripaeni. Eekiro riyaatatyee ikemaatsiteeyaawoni oetarikapaeni, rashironkaaperoeyanakyaani. ");
INSERT INTO cjoNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Eejatzi ikantakiri Jesoshi: —Paamawentya eerokapaeni. Paapatziyakina rootaki raanteetemiri iyotaawakaenchariki ikantakowentemi. Aririka piyaate janta pankotsiki ipiyotantapiintarira joriiyopaeni, aritaki ipajapajeetawakimi, tak, tak, tak. Raanakimi janta ijeekinta jewawenantatsiri, eejatzi janta ijeekinta pinkathariperotatsiri. Aririka rayemi, roojatzi pikemijantakayeri rirori, rawijakotanteeyaari. ");
INSERT INTO cjoNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Okameethatzi rityaawo ikemakoeyenani maawaeni atziri jeekatsiri kipatsiki nowawijaakotantzi, roojatzi nopokanteeya nopinkathariperotapaaki. ");
INSERT INTO cjoNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Aririka ragaetanakimi janta, aririka ikantakowenteetemi, eero pikenkithashiryaa: “¿Oetaka nokanteriri?” Aritaki iyotaakimi Ishire Tajorentsi oetarika pikanteriri. Rootaki ñaawaetakaemini, tee eeroka ñaawaetashitachani apaniroeni. ");
INSERT INTO cjoNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Iinja apaani shirampari kaari aapatziyana raakaanteri rirentzi aapatziyanari, rowamaakaanantyaariri. Paashini raakaanteri itomi aapatziyanari. Eejatzi paashini atziri ikijanakiri ashitariri, rowamaakaanteri. ");
INSERT INTO cjoNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Paapatziyakina, rootaki ikijanteetemiri maawaeni. Kyaaryo, opomeentsitzimoeyemini, omaanta aririka pikantyaani pameentaperotena, aritaki nowawijaakoteemi. ");
INSERT INTO cjoNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Eejatzi ikantziri Jesoshi: —Aririka piñaanatero rojankinarini Intañeeri, piyotawakiro ikantzirini: rashironkagaeyanakyaani atziri. Ikantzi eejatzi eenitatsi Tajorentsipankoki oonariri Tajorentsi, rootaki maawaeni atziri rookantanakawori Tajorentsipankoki. Aririka pijeeki Joreeyaki, eejatzi piñeeririka riraganki, pithaakyaate, pishiyeeyanakini janta tonkaariki. ");
INSERT INTO cjoNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Aririka pijeeki pankotsiki inkokironta, eero pikyaapanaatzi paantayitapanaatyaaworini oetarikapaeni, inta pishiyanaki. ");
INSERT INTO cjoNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Eejatzi piyaaterika owantsiki, eero pipiyapanaata paapanaatero piithaari. ");
INSERT INTO cjoNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Aririka omonkaatapaakya maawaeni iroka, ooo, osheki ashironkayitanakyaani motzitayitatsirini, eejatzi ashironkaakya thotayiriri eentsite: opomeentsitzimoeyaawoni oshiye. ");
INSERT INTO cjoNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Pamaneri Tajorentsi areetya iroka owashironkagaantsika ojarentsipaeteki kameetha pishiyaperoeyantanakyaarini eero opariyi inkani raawakimikari kijeeyemirini. ");
INSERT INTO cjoNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Eenitatsi eejatzi ikantziri Jesoshi: —Aritaki iinja rashironkaaperoeyanakyaani osheki atziri. Paerani tee añaapiintzironi kimityaawoni iroka, eejatzi riraga maawaeni itakaantaworini, tee iñiironi. Eejatzi maawaeni impaetayitatsini, iinja eero iñiiro eejatzi kimityaawoni iroka. ");
INSERT INTO cjoNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Tee ishinetziro Tajorentsi ojamanite iroka owashironkagaantsi: rooma aririkami ishineteromi, ari ithonkawakaeyakyaanimi. Rooma romaerintakiro, tema ikamintheeyakaeni aakapaeni aapatziyeeyaririni, riraga riyoyaayitakirini rirori. ");
INSERT INTO cjoNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Aririka ikamanteetemi: “Pamine, irira rotyaantanewo Tajorentsi”, eero paapatziyari. Eejatzi aririka ikanteete: “Irira”, eero paapatziyaperotari, itheeyashita. ");
INSERT INTO cjoNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ipokapaaki amatawitantatsini, ikantapaaki: “Naaka Jesokirishito, naaka kamanantzirorini iñaani Tajorentsi”. Itajorentsijeempiyaashitapaakya, ikoyi paapatziyawakyaari, rantayitemironi kaari piñaapiintzi. Ikowawita ramatawiterimi aapatziyeeyaririni Tajorentsi, omaanta tekatsi ikanteri. ");
INSERT INTO cjoNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Paamawentya. Neewatzitakimiro nokamantaperoeyakimironi maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Eejatzi ikantziri: —Aririka ipakaakiro ikijawakagaeyani, roojatzikya itsiteniityaantanakya oorya, eero ikimitanaa ikimitaaka iroñaaka. Eejatzi eero ikitamashitanee kashiri. ");
INSERT INTO cjoNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Eejatzi ipariyagaantanaki ompokiropaeni, ipoñaakya jenoki, ishewashewatashitanakya paashinipaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Naaka poñaachari jenokinta, nokoñaatapaaki jaka kipatsikika: iinja iñeeyawaenani atziri nokinapae menkoriki. Notajorentsiperotapaaki, nopinkatharitapaaki. ");
INSERT INTO cjoNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Eejatzi notyaanteeyerini nonampiripaeni ipiyoteeyerini maawaeni aapatziyeeyanarini. Ipoñaayitanakyaani maawaeni kipatsikipaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Eekiro riyaatatyee ikantziri: —Eenitatsi iroka piyotantyaawori oshiyakaawentaantsika iyeera. Owakirarika oshookaempekitanee, aririka otzimanee oshi, piyotaki rootaatsi ojarentsitee. ");
INSERT INTO cjoNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Eejatzi, okimita, aririka piñeeyawakironi maawaeni iroka nokamantayitakimirini, piyotanaki okaakitapaana, rooteentsi nopokashitaatemi. ");
INSERT INTO cjoNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Kyaaryootaki iroka nokamantzimiri. Tekira pikamaeyeni eerokapaeni, omonkaatapaakya maawaeni iroka nokamantzimiri. ");
INSERT INTO cjoNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Aritaki othonkaeya maawaeni kipatsi eejatzi ithonkaeya maawaeni jenokijatzi: kashiri, oorya, ompokiropaeni, maawaeni. Omaanta noñaani, eero othonkanita. ");
INSERT INTO cjoNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Eenitatsi eejatzi ikantziri riraga Jesoshi: —Tekatsi yotatsini tsikarika okaate kitejiri eejatzi tsikarika ikaate oorya; tee riyotzi ronampiri Pawa, eejatzi naari tee niyotzi. Apatziro Pawa yotatsiri. ");
INSERT INTO cjoNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Paamawentya, eejatzi paamagaeyenani. Tee piyotzi tsika okaate nopokanteeyaari. ");
INSERT INTO cjoNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Noshiyakaawentemiri atziri, jatatsiri inteena. Aririka rookanakiro ipanko, ikanteeyanakirini maawaeni ronampiripaeni iitarika ranteeyeniririni. Eejatzi rirori riraga jeekakaeyiniriri ipanko ikantanakiri rirori: “Paamagaenaga”. ");
INSERT INTO cjoNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Rootaki nokanteeyantzimirini: paamagaeyenani eerori. Tee piyotzi tsika okaate nopokanteeyaari: aririka itziroryaanee oorya, aririka niyankiite tsiteniri, aririka iñee tyaapa, aririka okitejiityaanaki nopokae. ");
INSERT INTO cjoNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Kyaaryoowa, paamaaperoeyenani. Aririka nopokae, nomapokapaemikari. Noñaapaemikari, maashiretakimi. ");
INSERT INTO cjoNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Iroka nokantzimirika, rootaki nokanteeyakiririni maawaeni atziri. Paamaaperoeyenani, maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Okaatapaaki apite kitejiri omonkaatantyaari kitejitatsiri rawijantari ronampiri Tajorentsi janta Ejiipitoki paerani. Iroka kitejiri tee rowapiintawo tapiyachari paa, inta kaari tapiyacha. Ari ikowaki jewatayitziririni ñaanakowenantatsiri eejatzi iyotaantzirori Iwaperite Tajorentsi tsika ikanteriri ramatawiteri Jesoshi raantyaariri. Aritaki ikowaperotawita rowamaerimi Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ikantzi: —Eero aantari kitejiri rawijantarini ronampiri Tajorentsi: ikijakowenteeyarinikari atziripaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ikantaka Jesoshi ijeekaki Wetaaniyaki, janta ipankoki Shimo pathaawitacharini. Osheki owaeyacharini janta. Opokapaaki tsinani, amakotapaakiro kajankaari. Iyoshaaka owaa naariwo osheki owinawo. Okameethaperotzi ojeekantari, ro riwetsikaetziri mapi iitachari arawaashitoro. Okagaakotapaakiniri, ojeetantapaakari iitoki. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ijeekaeyini apaanipaeni kijaperoeyakirorini. Ikantawakaanaka rirori: —¿Iitaka iroñaaka eewanatantakawori iroka kajankaarika? ");
INSERT INTO cjoNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Arimi opimanteromi, aantakyaawomi osheki koriki, roojatzikya opayiterinimi ashironkayitacharini. Tee inimoeyanakirini okaatzi antakiri, ");
INSERT INTO cjoNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","omaanta ikantziri Jesoshi: —Eero pithañaakotawo. ¿Iitaka pikijantawori? Okameethaperotzi ojeetakina. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Aritaki ikantani ikaatzimikya osheki ashironkaenkari. Aririka pikowaki petakotyaari, aritaki pimatakiro pipakiri. Omaanta naaka, eero nokantani notsipateeyemini. Eero oshekitzi kitejiri pineshironkatantanakinari jaka kipatsiki. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Tee omatayitzironi oetarikapaeni, omaanta ojeetakina naaka. Tema ajeetapiintziri kamatsiri, omaanta tee riyotakotya. Omaanta iroka tsinanika itakina ojeetakina, eeniroka nañi. Iyotakina nokame paata. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Kyaaryootaki iroka nokamantemiri: tsikarika ikamananteeyeroni atziri noñaani, eejatzi ikamantakoetero iroka tsinanika oetarika antakiri, ikenkithashiryaakoeyantyaaworini. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Eeniro irira Joorashi karyootejatzi, rirotaki riyotaanewo naawita Jesoshi. Ikantanaka riyaatanaki apaniroeni janta ijeekinta jewatayitziririni ñaanakowenantatsiri, ikantakotziri Jesoshi raakaanantyaariri. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ari ikemaeyawakirini riroripaeni ikantapaakiriri, ikimoshireeyanakini, ikantawakiri: “Kameethataki: osheki nopinatemi koriki iroñaaka”. Roojatzi ikenkithashiryaanaka Joorashi: “¿Tsika nokanterika naakaanantyaariri Jesoshi? ¿Tsika okaateka?” ");
INSERT INTO cjoNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Monkaatapaaka kitejiri rowaeyantaworini paa kaari tapiyacha. Eejatzi rowamaakiri owisha rowaeyaarini kitejiriki ikenkithashiryaapiintziro rawijantariri ronampiri Tajorentsi paerani. Ikanta riyotaanewo rojampitziri Jesoshi: —¿Tsika pikoyika nowojanteri owisha? ");
INSERT INTO cjoNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ari rotyaantziri riyotaanewo apite, ikantziri: —Piyaate Jerojareeki. Aritaki pitonkiyotawakyaari shirampari, aatsiri iñaa chomoki. Poyaatanakiri rirori. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Tsikarika janta ikyaapae, aritaki piñaapaakiri ashitawori ipanko; rirotaki piñaanatapaakiri. Pikantapaakiri: “Ikantzi iyotaantatsiri: ‘¿Tsikama nojeekantapaakyaari nowakaantapaeyaariri niyotaanewopaeni owisha?’ ” ");
INSERT INTO cjoNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Roojatzi roñaagantawakimiro janta jenoki oshitamenkotanta antawo. Ari piwetsikero janta owanawontsi. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Roojatzi riyaatanaki riyotaanewo janta, iñaapaakiro iroka ikantakiriri, roojatzi rowojantapaakiro rowanawo. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Roojatzi itsiteniityaanaki oorya. Rareetapaaka rirori Jesoshi, itsipateeyapaakarini riyotaanewopaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ijeekaeyapaakini, rowaeyapaakani, ikantziri Jesoshi: —Kyaaryootaki iroka nokamantemiri. Apaani akiyotanari iroñaaka rirotaki aakaantenani paata. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Rowashireeyanakani riraga riyotaanewopaeni, ikantaki apaanipaeni: —¿Naakama aakaantemini? Eejatzi paashini: —¿Naakama? Eejatzi paashinipaeni rojampiteeyanakirini. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ikantzi Jesoshi: —Tema rirotaki aakaantenani ochaantakotakinarika iroñaaka nowajoneki. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Naaka poñaachari jenokinta, nokoñaatapaaki jaka kipatsikika. Rooteentsi nokame. Aritaki omonkaatakya rojankinatakotziteetakinari. Omaanta ari rowashironkaakya riraga aakaantenani. Eerorikami ikoñaatzimi rirori, eeromi raakaantanami, eejatzi eeromi ikemaatsitawomi katsiri. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Eeniro rowaeyakani, raakiro Jesoshi paa. Ipaasonkitziri Iriri Tajorentsi, ikagaakiro, ipaeyakirini riyotaanewo. Ikantziri: —Powaeyawoni iroka paa, oshiyakaawentzirori nowatha. Tema naaka kamawenteeyakimirini. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Eejatzi raakiro pajoki awishoowaantsi oowa. Ipaasonkitakiri Tajorentsi, ipakoeyakirini, rireeyawakironi. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ikanteeyakirini: —Iroka oshiyakaawentzirori niraa. Napaatawenteri osheki atziri. Aririka nokamawentemi, piyoteeyakironi kyaaryo ikantakimiri Tajorentsi, rowawijaakoeyemini. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Kyaaryootaki nokanteeyimirini. Eero iroñaaka napiiteero jaka kipatsiki nireero awishoowaantsi oowa. Aririka nojeekapae janta ipinkatharitzinta Tajorentsi, ari nirapaero eejatzi. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ari ithonkakiro rowaka, romampaawenteeyanakarini Tajorentsi, roojatzi riyaatanteeyanakani janta tonkaariki, oetachari Oriiwomashi. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ikanteeyakirini Jesoshi: —Iinja pookaeyaneenani. Aritaki rojankinatakotziteetakimini: “Rowamagaeteri riraga shentziriri owisha, roojatzi ikinashiwaetanakya rowishate”. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Omaanta, iinja nopiriinteerika nañaaga neewateeyanakimini janta Karireeyaki, ari piñeena. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ikantziri Peetero: —Aririka rookaeyemini maawaeni paashini, inta naaka, eero nookimi. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ikantawakiri rirori: —Kyaaryootaki iroka nokantemiri: iroñaaka tsiteniriki, tekiraatarika rapiitakiroota iñi tyaapa, osheki pithaawanaki. Okaate 3 pikante: “Tee niyotziri Jesoshi”. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Omaanta ikantaperotzi Peetero: —Eero nookimi. Atsipatawakagaeyaniroña akamaeyeni, eero nokantzi: “Tee niyotziri”. Eejatzi imonkaatawakaaka ikanteeyakirini maawaeni paashinipaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Roojatzi rareeteeyapaakani janta Jethemaniiki. Ikanteeyirini riyotaanewo: —Pijeekaeyawakiniita jaka, nokenkithatakaawakiriita Pawa. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Rirotakikya raanakiri Peetero, Jantyaako, eejatzi Jowa. Areetzimotapaakari ikenkithashiryaanaka, eejatzi osheki rowashiretanaka. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ikantziri: —Osheki netakotanaka. Pijeekawakiita jaka, pikakiterapa. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Ari ishirinkaneentanaka eechonkiini jaga. Rotziwerowanaka kipatsiki, ikenkithatakaeri Iriri. Ikantziri: —Pawa, eeroka matzirori maawaeni oetarikapaeni. Nokowawitaka powawijaakotenami iroka nokemaatsityaari, omaanta eero nantziro nokowawitari nanteri naari, inta nokowaki nantemiro pikowakaakinari eerori. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Roojatzi ipiyanaa jaga ijeekakira riyotaanewo. Iñaapaatziiri, imagaeyakini. Ikantapaakiri Peetero: —Shimo, ¿maakimima? ¿Eeroma pamawetziro pikakite eechonkiini? ");
INSERT INTO cjoNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Pikakite. Pamaneri Tajorentsi okantyaatakya aririka ikowaki iwinkatharite kamaari rantakayitemironi kaari kameethatatsi, eerokya panantawo. Kyaaryo pikowaperowitaka pantenirimi Tajorentsi ikowakaakimiri, omaanta tee pimatziro. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ipiyanaka eejatzi, ikenkithatakaapaeri Iriri roojatzi ikanteeri ikantakiriri inkaaganki. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ipiyapaa, iñeeyapaerini magaeyakini eejatzi. Osheki agaeyakirini iwochokini. Osheki ipashiwenteeyakani, tee riyotzi oetarika ikanteeyirini. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ipiyapiyataka riraga Jesoshi, okaatzi 3 ipiyanaka. Roojatzi ipiyantapaaka ikantapaakiri: —Eekiroma pimaatzi. Iroñaaka monkaatapaaka, rooteentsi ikentakotakaanteetena: rooteentsi rayena kaari aapatziyanari. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Iroñaaka pipiriinte, thame aate. Oo, okaakitapaaki aakaantenani. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Eeniro iñaawaetzi Jesoshi, ipokapaaki riraga Joorashi, rirowitaka riyotaanewo. Itsipateeyapaakarini iroñaaka osheki atziri. Ramaeyapaakironi ichekamentopaeni eejatzi rompojamentopaeni wetsikachari inchato. Riroteeyakini rotyaantanewo jewatayitziririni ñaanakowenantatsiri, riraga rotyaantanewo iyotaantzirori Iwaperite Tajorentsi, riraga aataperoteenchari. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ikantziteeyakarini riraga Joorashi irirapaeni: —Iroñaaka nokamantaperotemi piyotantapaakyaariri Jesoshi: piñaakinarika nothowootapaakiri, rirotaki poerikapaakiri. Paanakiri. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ari ipokapaaki rokaakintapaakari. Ikantapaakiri: —Iyotaanari. Ithowootapaakiri. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Roerikaeyapaakirini, shepik, ishirikaperotapaakiriroña ragaeyanakirini. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Apaani riyotaanewo raanakiro ichekamento. Ithatziitakiri ikempita ronampiri iwinkatharite ñaanakowenantatsiri, thatzik. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ikanta Jesoshi iñaakiri okaatzi rantakiri riyotaanewo, ikantziri: —¡Eero! Okanteekaata, poyaankaero pichekamento, ipiyatzimikari. Tema piyotzi maawaeni antawakaantawori ijawirite eejatzi rowamaanteetakari jawiri. ¿Tee piyotzi nokowakirikami, nokanterimi Ashitanari rotyaantenarimi oshekinipero ronampiri piyakowentenanimi? Roojatzi ipampitakiri ikempita, retsiyatakotakiri. Ari ikanteeyawakirini Jesoshi: —¿Naakama koshintzi? ¿Iitaka pamashitantanari pichekamento eejatzi pompojamentopaeni? Paashitanakina, eero noshiyapithatzimi. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Aritaki maawaeni kitejiri notsipateeyawitzimini janta Tajorentsipankoki, niyotaantzimiri. Pikoyirika payena, paanakina. Iroñaaka omonkaataka okantzitakarini Iwaperite Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Riraga riyotaanewopaeni rookaeyanakirini, shiyeeyanakani maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Apaanikya ewankari oyaatawitanakariri Jesoshi. Tee ikithaatanakya, omaanta rapineetashitakawo iwashikawo. Roerikaetawitawakari, ");
INSERT INTO cjoNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ithañaanaka rirori, rookanakiro iwashikawo, ishiyamerikitanaka. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ari ragaeyanakirini Jesoshi iwinkathariteki ñaanakowenantatsiri. Ipiyotawenteeyapaakarini maawaeni jewatayitziririni ñaanakowenantatsiri, aataperoteenchari eejatzi iyotaantzirori Iwaperite Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Riraga Peetero royaatakowentawitanakari Jesoshi, omaanta rookaneentanakiri inteenanta, roojatzi rareetantapaaka janta ipankoki iwinkatharite ñaanakowenantatsiri. Tee ikyaapaaki rirori pankotsiki; ijeekimotapaakiri onampirentsipaeni rakitsitapaakawo paamari. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ari inthomaenta ipiyotawentakari Jesoshi riraga jewatayitziririni joriiyopaeni. Rojampiteeyirini atziri: —¿Piñaakotakirima rantziri Jesoshi kaari kameethatatsi nowamaakaanantyaariri? Omaanta tekatsi iñaakoteri. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ipokapaaki osheki theeyakotakariri, tee omonkaatawaka ikantayitakirini. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Apaanipaeni katziyaneencha, itheeyakotashitakari, ikantzi: ");
INSERT INTO cjoNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Nokemaeyakirini Jesoshi ikantzi: “Iinja noshekiroreero Tajorentsipanko iroka riwetsikani atziri. Ari okaate 3 kitejiri niwetsikae naaka paashini Tajorentsipanko, kaari riwetsiki rirori atziri”. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Omaanta tee omonkaatawakakya ikantayitawitakarini. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ikatziyanaka niyanki riraga iwinkatharite ñaanakowenantatsiri. Rojampitakiri Jesoshi, ikantakiri: —¿Iitaka kaari pakantana? ¿Oetaka iroka ikantakotayitakimirini irika? ");
INSERT INTO cjoNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Omaanta imaeritaki, tee raki. Rapiitakiri riraga iwinkatharite ñaanakowenantatsiri: —¿Eerokama Rotyaantanewo Tajorentsi naamagaeyarini, riraga Itomi Tajorentsi noñaaperotziri? ");
INSERT INTO cjoNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Rakanakiri: —Naaka. Kyaaryo pikantakiri. Iinja piñeena nojeeki janta rakoperoki Pawa Tajorentsi, nokaateeyirini neewawenanteeyapaeni. Eejatzi piñaawaena nokinantapaeyaawo janta menkori, aririka nopiyee paata. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Riraga iwinkatharite ñaanakowenantatsiri ikijanaka. Ikenkithashiryaakotanakari Jesoshi ikantzimatakiri Tajorentsi, rootaki itzijagaantanakawori iithaari. Ikantanaki: —¿Iroñaaka iitaka akowantyaari paashini kantakoterini? ");
INSERT INTO cjoNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Pikemaeyawakirini iroñaaka okaatzi ikantakiri, tema itheenkakiri Tajorentsi. ¿Tsika pikanteeyinika eeroka? Ikanteeyanakini: —Kyaaryo, eenitatsi rantani. Okameethatzi ikame. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Eenitatsi apaanipaeni eewatayitziririni. Roojatzi ipashikapootakiri, eejatzi ikapojapootakiri. Ikantziri: —Pikamantena iroñaaka ninkarika kapojapootakimiri. Eejatzi riraga waariryaapaeni ipajapooteeyakirini. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Eeniro ijeeki rirori Peetero janta inkokironta pankotsiki rakitsita. Opokapaaki apaani ronampiri iwinkatharite ñaanakowenantatsiri. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Oñaapaakiri Peetero, rakitsita paamariki. Otsikanatapaakari, joreririri, okantapaakiri: —Eeroka tsipatariri riraga Jesoshi najareetejatzi. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ithaawanaki, ikantanaki: —Tee, tee niyotzi oetarika pikantziri. Tee nokemimi eejatzi. Roojatzi riyaatanaki ashitakontsiki shiirikoki. Iñaanaki tyaapa. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Apiiteeri oñaagaeri onampirentsi. Okanteeyirini maawaeni okaateeyakinira: —Rirotaki irika tsipatariri Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Eejatzi rapiiteero Peetero, ikantzi: —Tee niyotziri. Ari ojamanitapaentzi eechonkiini. Roojatzi ikantziri irikapaeni katziyayiteencharini: —Kyaaryooperotaki. Eerokataki tsipatariri Jesoshi, eerokataki karireeyajatzi. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ikantaperotanaki: —Tee niyotziri riraga shirampari pikantakinari. Riyotzi Tajorentsi kyaaryo nokantaki: notheeyakyaarika, nokowaki rowashironkayenaata Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Rapiitakiro iñaanaki tyaapa. Ikenkithashiryaaneero Peetero ikantakiriri Jesoshi: “Tekiraatarika rapiitanakiroota iñaanaki tyaapa, okaate 3 pikante: ‘Tee niyotziri Jesoshi’ ”. Ari rowashiretanaka Peetero, roojatzi riraantanaka, jmmm, jmmm. ");
INSERT INTO cjoNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Rooteentsi okitejiityaanaki, rapiitakiro ipiyotawenteeyarini Jesoshi riraga jewatayitziririni ñaanakowenantatsiripaeni, eejatzi aataperoteenchari eejatzi iyotaantzirori Iwaperite Tajorentsi. Ikantakowenteeyakirini Jesoshi. Roojatzi roojoteeyakirini irira, raanakiri janta, ipapaakiri Peraato. ");
INSERT INTO cjoNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Rojampitawakiri: —¿Eerokama iwinkatharite joriiyopaeni? Riraga Jesoshi rakanakiri: —Pikantakiri eeroka kyaaryoopero. ");
INSERT INTO cjoNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ikanteeyini jewatayitziririni ñaanakowenantatsiri: —Osheki rantayitakirini irika, tee ikameethatzi. ");
INSERT INTO cjoNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Rapiiteeri Peraato, rojampitziri: —¿Iitaka kaari pakanta? Pikemawakiri osheki kantakotashiteeyakimirini. ");
INSERT INTO cjoNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Tee raki Jesoshi. Riraga Peraato tee riyotzi oetarika ikenkithashireeyarini. ");
INSERT INTO cjoNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ari eenitatsi rametari: maawaeni ojarentsi, aririka omonkaatapaeya kitejitatsiri rawijantakariri ronampiri Tajorentsi achariniiteni paeranipero Ejiipitoki. Roeyowapiintziri omonkyaagaarewo apaani ikowakagaeyirini atziripaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Eeniro iroñaaka rashitakotaka janta atziripaeni kowayitawitacharini rookerimi pinkathari: iwaero apaani Warawaashi rirotaki owamaantaneri. ");
INSERT INTO cjoNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ari riyaatashiiyakirini riraga piyoteenchari, ikanteeyapaakirini Peraato: —Nokoyi panteeyenawoni iroka pametari: poeyowaenari apaani pomonkyaaganewo. ");
INSERT INTO cjoNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Rakawakiri Peraato, ikantawakiri: —¿Riroma pikowakiri noeyoyemiri riraga Jesoshi piwinkatharite? ");
INSERT INTO cjoNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Riyotaki Peraato osheki iñaaperoeyirini atziripaeni Jesoshi, rootaki ikijeeyantanakaririni ñaanakowenantatsiripaeni raakaanantakariri. ");
INSERT INTO cjoNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ari riraga jewatayitziririni ñaanakowenantatsiri ikenkithayitanakini, ikanteeyakirini atziripaeni: —Pikante: “Kaari Jesoshi”. Pikanteeyirini: “Riraga poeyowaeri Warawaashi”. ");
INSERT INTO cjoNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Rapiiteeri eejatzi Peraato, ikantziri: —¿Tsikama nokanterika iroñaaka irika pipinkatheeyawitakarini? ");
INSERT INTO cjoNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ikaemaeyanakini paashinipaeni: —Pikentakotakaanteri koroshiki. ");
INSERT INTO cjoNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Rojampitziri: —¿Iitaka rantakiri nokentakotakaanantyaariri? Eekiro rapiitanaatziiro ikaemaeyanakini: —¡Pikentakotakaanteri, pikentakotakaanteri! ");
INSERT INTO cjoNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ikowanaki Peraato ikimoshiretakagaeyeerini riraga atziripaeni, rootaki roemishitowantaariri Warawaashi. Omaanta Jesoshi ipajatakaantakiri, roojatzi raakaantakiri ikentakotakaantakiri. ");
INSERT INTO cjoNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Roojatzi irira joraaropaeni raanakiri Jesoshi inthomaenta ipankoki Peraato, ari okaankiityaaneentzi eechonkiini. Owaeronta rowaga pankotsi peretooryo. Riraga joraaropaeni ikaemaeyakirini maawaeni paashinipaeni. ");
INSERT INTO cjoNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","18","Itheenkaeyakirini, ishirontawenteeyakarini, ikantziri: —¿Eerokatakima iwinkatharite joriiyopaeni? Iroñaaka naari noñaaperotemi. Ari ikanteetakiriri iroñaaka Jesoshi, tema rantaminthatakiri rootaki roshiyakaawenantakariri apaani jewawenantatsiri. Raatonkoryaagaetakiri Jesoshi, ikithaateetakiri kityonkamawoneentatsiri. Ragaetakiniri kitochee, riwetsikaetakiniri ikimitakaanteetakiniri amantheerentsi roojatzi ramantheetakaantakari. ");
INSERT INTO cjoNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Rotziwerowashitakari, iñaaperojeempiyaakari, roojatzi rompojantakari chonkopishitonki iitoki eejatzi reewapooteeyakirini. ");
INSERT INTO cjoNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ari osheki rantaminthatakiri, roojatzi reshitapaakiri. Roojatzi raatonkoryaakiri ikithaawitakariri kityonkamawoneentatsiri, ikithaateeri iithaaripero rirori. Roojatzi raantanakari ikentakoteetantyaariri antawokotaki koroshi. ");
INSERT INTO cjoNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Roojatzi joraaropaeni raanakiri Jesoshi. Niyanki awotsi iñaakiri shirampari iwaero Shimo rirotaki iriri Arejaantero eejatzi Roojo. Owakira ijeekapaaki Jerojareeki ipoñaakawo paashiniki nampitsi iitachari Shireene. Romperatawakari iroñaaka, ikantakiri: —Pinatanakiniri Jesoshi iroka koroshi. Ikanta Shimo inatanakiro, raanakiro. ");
INSERT INTO cjoNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ari ragaeyanakirini Jesoshi janta tonkaariki oetanta Koorikota. Rootaki iitantawori tonkaari oshiyakawo iitonaki atziri. ");
INSERT INTO cjoNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ari ipakowitakari kepishaari, eero ikemaatsiperotantawo katsiri, inta tee rirawakiro Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Roojatzi ikentakoteetakiri Jesoshi rakokira eejatzi iitzikira, rowatzikakoteetakiri kipatsiki. Ikanta irikapaeni joraaro, raakiro iithaari. Roojatzi rookayitzironi mapyaaniki. Ro riyotantyaari ninkarika ayeroni iithaari. Eejatzi rapiitakiro riyotakoeyeroni mapi roojatzi raantanakyaawo maawaeni okaatzi ikithaayitarini rirori. ");
INSERT INTO cjoNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Jenokiityaapaaki oorya, ikentakoteetantakariri. ");
INSERT INTO cjoNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Roojatzi raaki paashini inchakota owaanini, rojankinateetakiro jankinarentsi okantzi: “Rirotaki jewawentziriri joriiyopaeni”. Rootaki rojankinatantakawori, riyoteetantyaari iitarika rowamaanteetakariri. Ikentakoetakiniri jeñokiini ipatziitoki Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Iroñaaka eeniro ikaatzi apite koshintzi ikentakoteetakiri eejatzi, ari itsipatakari Jesoshi. Apaani rowatzikakoteetakiniri rakoperoki, irira paashini rowatzikakoetakiniri rampateki. ");
INSERT INTO cjoNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Rootaki omonkaatantakari jankinarentsi Iwaperiteki Tajorentsi kantatsiri: “Ikimitakaanteetyaari kaari kameethatatsi”. ");
INSERT INTO cjoNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ari rawijayitzini iroñaaka osheki atziri, osheki itheenkimawaetakiri Jesoshi, osheki ishirontawentari, ikanteeyirini: —¡Oo! Eeroka shekiroreeronimi Tajorentsipanko, ro awijawitakya 3 kitejiri ari piwetsikaeromi eejatzi. ");
INSERT INTO cjoNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","¿Arima pitajonkantashiwaeta? Intsipaete, pitajonkakowentya eeroka: payiitee iroñaaka ikentakoetakimira koroshiki. ");
INSERT INTO cjoNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Roojatzi ipokantapaaka eejatzi irikapaeni jewatayitziririni ñaanakowenantatsiripaeni eejatzi iyotaantawitawori Iwaperite Tajorentsi. Ishirontawenteeyakarini, ikantawakaeyanakani: —Pamineri irikakya, rirowitaka owawijaakotziriri paashini atziri, tee imatziro rowawijaakotya rirori. ");
INSERT INTO cjoNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Eerokawitaka Rotyaantanewo Tajorentsi, jewawenantawitariri ajoriiyotzinkaritepaeni. Aminamatsitawakiriita aririka rayiitee koroshiki. Aririka añaakiri, thame aapatziyari. Eejatzi ikimitakari rirori tsipatakariri Jesoshi ikentakotaka, itheenkakiri eejatzi. ");
INSERT INTO cjoNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ikaataki oorya tampatsika, omapokashitapaaka otsitenitanaki maawaeni kipatsi. Tee añaaneeri oorya. Okaatzi ojamanitapaentzi 3 oora. Roojatzi rooryaantanaa. ");
INSERT INTO cjoNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Roojatzi ikaemantanaka antawo Jesoshi ikantzi ipaanteki rashi: —Eroe, Eroe, ¿raama jawaatani? Rootaki akantziri aaka apaanteki: “Notajorentsite, Notajorentsite, ¿iitaka pookantanari”? ");
INSERT INTO cjoNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ikemantawakariri apaanipaeni jeekaneentsiri ikantzi: —Pikemiri, ikaemiri Iriiyashi. ");
INSERT INTO cjoNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ari ishiyanaka atziri, rowiinkapaakiniri kepishaatatsiri piyonkashinkanari. Rojataakiniri jawookiikira. Ipawitari ratsimiyawakiromi. Ikantziri katziyayiteencharinipaeni jaga: —Ari ikantawakaata: aminawakiriita aririka ipokashitapaakiri Iriiyashi rayiitashitapaakiri. ");
INSERT INTO cjoNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Antawopero ikaemanaki Jesoshi, kamanaki. ");
INSERT INTO cjoNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Eenitatsi janta Tajorentsipankoki antawo tokoya, tontarini, ashitako omooki. Itanakawo jenoki, otzijagaanaki waaaag, roojatzi jaawiki. Thatzii. Apitemankitanaka. ");
INSERT INTO cjoNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Eeniro imontetakari itzinkami joraaro. Iñaawakiri tsika ikantanakari Jesoshi ikamantanakari. Roojatzi ikanantanaka: —Kyaaryoopero: riroperotaki irika shirampari Itomi Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Eeniro apaanipaeni tsinani ojeeki inteenapaeni aminayitzini. Okaateeyakironi Mariiya makaraarajato, eejatzi ojameto, Mariiya rootaki riniro Jantyaako eejatzi paashini Josee. Jantyaako impaerintzi ikoñaatzi. Eejatzi okaateeyironi Jaromee. ");
INSERT INTO cjoNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Eeniro ijeekawitani janta Karireeyaki oyaateeyirini maawaeni irokapaeni tsinani amitakotziriri. Iroñaaka ojeeki jaka osheki paashinipaeni tsinani. Itonkaantanakari Jesoshi janta Jerojareeki, oyaateeyanakirini. ");
INSERT INTO cjoNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Itsiteniityaanaki oorya. Ro kitejitatsini inkaamani imakoryaanteeyarini, tema iroñaaka riwetsikaeyironi oetarika ashi inkaamani. ");
INSERT INTO cjoNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Eeniro Josee, riraga poñaachari Arimateeyaki. Aritaki ikaateeyirini riraga iyotaawakagaeyacharini. Iñaaperoteeyirini atziripaeni rirori. Raamaari Tajorentsi rirori ikowaki reewawenteri. Iroñaaka ishirampariperotanaki Josee, riyaatashitanakiri Peraato, ikantapaakiri: —Nokoyi pishinetenari naaneeri Jesoshini. ");
INSERT INTO cjoNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Itzimaetyaashitanaka riraga Peraato. Ikenkithashiryaanaka: ¿Okyaaryootzitanakyaama, intsipaete ikamanaki Jesoshi? Ari ikaemakaantakiri iwinkatharite joraaro. Rojampitawakiri: —¿Kyaaryooma? ¿Kamaperotanakima Jesoshi? ");
INSERT INTO cjoNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ikantziri: —Jee, kamaperotaki. Roojatzi rotyaanantakari Josee royiitakoteeri jaawikira Jesoshini. ");
INSERT INTO cjoNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ramanantaki Josee tokoya. Royiitakiri Jesoshini rapineetakotakiri. Romaryaakiri omooki, janta imoonteetzironta impeeta. Ipinaashitakiri antawo mapi omooki. ");
INSERT INTO cjoNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Oñaakoperotakiri Mariiya makaraarajato tsika rowakiri. Otsipatawo ojameto, rowaga riniro paashini Josee. ");
INSERT INTO cjoNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Awijanaki kitejiri imakoryaanteeyarini. Roojatzi amananantanakari tsinani kajankapaneri, otziritanteeyaririmi Jesoshini. Ro owaeropaeni roori tziriterinimi Mariiya makaraarajato, eejatzi roori okaatziro ojameto riniro Jantyaako, eejatzi roori Jaromee. ");
INSERT INTO cjoNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ari okitejiityaanaki iyaatzi janta omooki rotetawitakarinta Jesoshini. Rootaki tominko iyaatantakari. Ari ijenokitapaaki oorya, roojatzi areetantapaaka. ");
INSERT INTO cjoNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Okantawakaeyanakani: —¿Ninka pinagaenironika rowaga mapi ashitantari? Antawoni, eero aawiro aaka. ");
INSERT INTO cjoNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Aminapaaki, oñaapaakiro rowaga mapi antawo, pinaanaka ashitaryaanaka. ");
INSERT INTO cjoNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Okyaapaaki omooki janta rowawitakarinta. Tee oñaapaeri Jesoshini, omaanta irira oñaapaaki apaani shirampari jaga. Ikithaatawo kithaarentsi kitamaaripero. Otsinkashiryaanakiro irowapaeni oñaapaakirira ijeeki. ");
INSERT INTO cjoNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ikantawakiro: —Eero pithaayi. Riro paminawitari riraga Jesoshi najareetejatzi, riraga ikentakoetakiri. Piriintanaa, tee añaagaeri jaka. Jatee. Paminerotya rowawiitakarika. ");
INSERT INTO cjoNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Piyaatee iroñaaka pikamantapaeri Peetero eejatzi paashini riyotaanewopaeni. Pikantapaakiri: “Reewatanakimi janta Karireeyaki, aritaki piñaapaeri janta. Tema aritaki ikamantzitakimini paerani”. ");
INSERT INTO cjoNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ari intsipaete iyowanee, oshiyanaka. Ompetatanaka, osheki otsinkashiryaanakiro. Othaawanaki, rootaki kaari okamanantari atziri otonkiyotakari janta awotsiki. ");
INSERT INTO cjoNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Rootaki ipiriinantaari Jesoshi tominko. Ro ritaperotaari roñaagaawo Mariiya makaraarajato. Rootaki paerani ikyaantawitakawo 7 kamaari, omaanta retsiyatakotakironi. ");
INSERT INTO cjoNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Roojatzikya iyaatantanaka roori okamantapaakiri riraga itsipateeyawitarini Jesoshi. Roojatzi rowashiretakoeyawitarini, eejatzi eeniro riraakoeyawitarini. ");
INSERT INTO cjoNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Roojatzi okamantawitapaakari: —Piriintanaa Jesoshi, noñaagaeri. Tee raapatziyawakawo. ");
INSERT INTO cjoNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Roojatzi ipaashinipootanaki ipookira Jesoshi, roñaagapaari apite riyotanewoni ranashiiyani janta awotsiki. ");
INSERT INTO cjoNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ari ipiyanaa irika ñaakiriri, ikamantapaakiri paashinipaeni. Eejatzi ikimitawakiri, tee raapatziyawakari. ");
INSERT INTO cjoNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ari rowaeyani riyotaanewopaeni, ikaateeyini 11. Roojatzi roñaagaeyantapaaririni Jesoshi. Ikanteeyapaakirini: —Tema nokamantzitakimini ari nopiriintee: ¿iitaka kaari paapatziyantana? Tema tee añiiro pikenkithashiryaantari. ¿Iitaka kaari paapatziyantari ñaakinari inkaaganki? ");
INSERT INTO cjoNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Piyaateeyeni pithotyaanakiro maawaeni kipatsi. Pikamanteeyerini maawaeni atziri tsika ikanteeya rawijakotanteeyaari rirori. ");
INSERT INTO cjoNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ninkarika aapatziyawakyaawoni rowaga pikamantakiriri, roojatzi raapatziyantawakyaari Tajorentsi ari ikaawoshitawentanakyaari irira tema aritaki rawijakotee. Rooma riraga kaari aapatziyawakyaawoni ari rowashironkaaperoteri Tajorentsi rirori. ");
INSERT INTO cjoNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Tsikarika piyaateeyeni, itajonkakowentemi Tajorentsi, riyoteeyantyaarini atziri kyaaryootaki iroka pikantakiriri. Nomatakayemiro petsiyatakotantyaariri kyaantariri kamaari. Piyotayiteroni paashinipaeni ñaagantsi pikenkithatakotantenari. ");
INSERT INTO cjoNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Aririka poerikawityaari maanki, aririka ratsikawitemi, omaanta eero rowamaemi. Eejatzi, aririka piraakowityaawo piyantatsiri, eero owamaemi. Eejatzi, aririka pipampiteri mantsiyatatsiri eejatzi pikantakowenteri, ari rawijakoeyeeni. ");
INSERT INTO cjoNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Rootaki ikanteeyakiririni Awinkatharite Jesoshi, roojatzi roenokantanaa jenokinta, ijeekapae janta rakoperoki Tajorentsi, ikaatapaeri ipinkatharitapae rirori. ");
INSERT INTO cjoNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ari riyaateeyanakini riyotaanewopaeni. Ikinakinayitanakini, ikamanantayitanakini tsikarika ikinayitanakini. Kijokiro rowakiri Awinkatharite, ramitakoeyirini. Eejatzi itajonkantayitakini, riyoteeyantakarini atziripaeni kyaaryooperotaki ikamanteeyakiririni. Aritaki okantaperotari. Ari okaatzi. Naaka jankinatzirori: Marikoshi");
INSERT INTO cjoNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","4","Naaka Rookashi nokoyi niwethatemi eeroka Teyoojiro tsikarika pikanta pijeeki. Iroñaaka nokoyi nokenkithatakoteri Jesokirishito. Ikaateeyakini osheki jankinatakoeyakiririni, ikamantakotayitakironi okaatzi rantayitakirini. Iñeeyakirini, eejatzi ikemakoeyakirini, rootaki rojankinatakotantariri. Noñaanatakiro naari okaatzi rojankinatakiri, eejatzi nojampitakowentayitakironi rantayitakirini niyotakoperotantakawori, nothotyaakiro maawaeni. Iroñaaka nokamantemiro naari, nokowaki piyoperotero kameetha rantayitzirini Jesoshi, rootaki nojankinatantakimirori piyoperotantyaaworini kyaaryo rooperori okaatzi riyotagaetakimiri. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Paerani, ipinkatharitantari Erooreshi janta Joreeyaki, eenitatsi eejatzi ñaanakowenantatsiri Tajorentsi iitachari Jakariiyashi. Rirotaki icharineeteni Awiiyashini: aririka areetapaeya kitejiri rantawaetantyaanariri Tajorentsi janta Tajorentsipankoki ikaateeyirini isheninkathoripaeni rashi rirori riraga icharineetenipaeni Awiiyashini. Owaero iina Erijaweera, rirotaki ojariitepaenini Aawooni eejatzi. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Riraga Jakariiyashi rirotaki aapatziyariri Tajorentsi, eejatzi iina rootaki aapatziyariri. Ikantani rantayitakironi okaatzi ikaminaakiriri rirori, rootaki riyoteeyantakaririni atziri ikameethataki. Tekatsi okantya ikantakowenantyaariri. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Omaanta tee itzimi reentsite: amashithakitakitya iina, eejatzi imonkaatawakagaeyakani rantyashipariteeyakini. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Okantaka omonkaatapaaka kitejiri rantawaetakaanteeyaririni isheninkathoripaeni, eejatzi riraga Jakariiyashi. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Rameteeyawoni riyoyaapiintzi apaani ñaanakowenantatsiri rotyaanteri inthomaenta Tajorentsipankoki itaantyaanariri Awinkatharite kajankapaneri. Ikanteeyakirini isheninkathori rirori: —Iroñaaka eeroka niyoyaakimi piyaate inthomaenta janta, pitayeniri Awinkatharite kajankapaneri. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ikanta ikyaanaki inthomaenta, omaanta paashini piyoteeyeencharini oyaakiriri inkokironta, ikenkithatakagaeyirini riraga Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Janta inthomaenta, romapokakiri ronampiri Awinkatharite, ikatziyimotapaakari rakoperoki okaakini aritaari itaakirowa kajankapaneri. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Iñaantawakariri rotsikanatanakari, tee riyotzi oeta ikantanakiri, eejatzi osheki ithaawanaki. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Omaanta ikantakiri: —Jakariiyashi, eero pithaayi. Eenitatsi pamanakotakiriri Tajorentsi; tema ikemakimi, rootaki otzimantyaari iinja piina pitomi. Piiteri Jowa. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Osheki pikimoshirewenteri, eejatzi ikimoshirewenteeyerini osheki atziri aririka ikoñaatapaaki. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Eejatzi iñaaperoteri Tajorentsi ikameethataki. Eero ririro awishoowaantsi oowa eejatzi inashitachari shinchaari. Ojeekantyaari Ishire Tajorentsi rajankanekira; tekiraata okoñaatziri riniro roojatzi ojeekantzitari. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Osheki raapatziyakagaeyaarini pijoriiyotzinkaritepaeni, ipinkathateeyantyaaririni Tajorentsi, tema rirotaki irira Awinkatharite maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ikimityaari Iriiyashini, osheki iyotaakiri Ishire Tajorentsi, eejatzi oshintsitakaakiri. Reewatakiri Awinkatharite, ikamanteeyerini isheninkapaeni raamagaeyaarini rirori, eejatzi inintaperoeyerini reentsitepaeni. Riyotagaeyerini rirori raapatziyanteeyaariri Tajorentsi, ikimityaari riraga itakaantaworini raapatziyarini. Riyotagaeyerini theenkantatsiri kameetha raapatziyaari rirori. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ikantakiri Jakariiyashi: —¿Tsika nokantyaaka niyoperotantyaari kyaaryootakirika iroka pikantakinari? Antyashiparitakina, eejatzi noena, antyashipawotaki roori. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Rakanakiri: —Naaka Kawiriyeeri, kijokiro noyiri Tajorentsi. Rirotaki otyaantakinari nokamanantzimirorika iroka kameethatatsiri. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Aritaki omonkaatakya iroka nokamantakimiri, omaanta tee paapatziyawo nokantawitakimirika, pitheenkakina. Iroñaaka pimajontzite, eero piñaawaetanee roojatzi paata ikoñaatantakya pitomi. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Eeniro janta inkokironta piyoteeyeencharini royaawitaari Jakariiyashi, ikanteeyakini: —Ojamanitateekityaami ipeyaka. ¿Iitaka kaari ishitowantaa? ");
INSERT INTO cjoNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Roojatzi iñaawaeri ishitowapae, tee imataneeya iñaawaetanee, omaanta rookorookotashiwaetaka. Roojatzi riyoteeyantanakani, ikanteeyanakini: —Eenitatsi iñaakiri janta inthomaenta. Tee iñaawaetaantsiperotanee. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Okaatzi 7 kitejiri rantawaetaki Tajorentsipankoki. Roojatzi ipiyanaa ipankoki rirori. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Roojatzi omotzitantaka iina, okempoyaaka opankoki. Ikaatzi 5 kashiri tee oshitowae. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Okantzi: —Paerani tee itzimawityaani notyomi, rootaki nopashiwenantakari, omaanta iroñaaka eero napiiteero nopashiwentaa. Ineshironkatakina Awinkatharite, tema ikameethaperotaki. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Okaatakotaki 6 owashirite omotzitaki Erijaweera. Roojatzi rotyaanantakari eejatzi riraga Tajorentsi Kawiriyeeri: —Piyaate Najareeteki: jeekatsiri Karireeyaki. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Pareetakityaawo tsinani owaero Mariiya, okashiyakari ayeri Josee, riraga icharineeteni Iraviiri. Omaanta tekira oshinetari shirampari. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ikantaka riyaatashitakiro riraga Kawiriyeeri. Romapokapaakiro ikantapaakiro: —¿Eeniromi, Mariiya? Nopokantari nokamantemi: piweshiryaanakya. Osheki inintashireperotakimi Tajorentsi, kijokiro rowakimi. Panaakotakiro maawaeni tsinani ikaminthaaperotzimi rirori. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Omaanta othaawantawakari, okenkithashiryaanaka: “¿Iitaka ikanantanari?” ");
INSERT INTO cjoNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ikantapaakiro: —Eero pithaawantana. Kyaaryo, ikaminthaaperotakimi riraga Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Rooteentsi pimotzite. Iinja pitzimeri pitomi, piiteri Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ipinkathariperote. Riyoteeyakirini atziri rirotaki Itomi Tajorentsi, riraga jeekatsiri jenokinta. Tema rirotaki Awinkatharite. Paerani riraga Iraviirini ipinkathariwentawitarini ijoriiyotzinkariteni. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Iinja ipinkatharite rirori eejatzi. Tema ikantziri Tajorentsi itomi: “Notyomi, eeroka pipinkathariwenteeyeririni maawaeni, pikanteetatyeeyaani”. Aritaki ikantyaari ipinkathariwenante, eero ipakagaero. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Okantawakiri: —¿Tsika nokantyaaka itzimantyaari notyomi? Tekatsikya noemi. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Rakanakiro: —Irowa tzimakayemini Ishire Tajorentsi. Rootaki tajonkawentemini. Iinja ikantakoeteri pitomi: “Ikameethaperotaki, tee añiiro kaari kameethatatsi rantziri. Rirotaki Itomi Tajorentsi”. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Eejatzi nokamantemi: antyashipawoperowitaka roori pinatsito Erijaweera, tema ikanteetziro roori tee iyotziri otzimeri eentsite, omaanta okaatakotaki 6 owashirite iroñaaka omotzitaki. Iinja otzimeri otomi. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ñaakiro, tekatsi pomeentsitzimotyaarini Tajorentsi, imateeyironi oetarika ikoyiri. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Okantanakiri: —Tema rirotaki Nowinkatharite. Inimotakina oetarika ikowakaakinari. Ikowakaakinarika itzimashitya notyomi, ari kameethataki. Roojatzi ipiyantanaka riraga ronampiri Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Awijanaki apaanipaeni kitejiri roojatzi iyaatantanaka rowaga Mariiya Joreeyaki. Oshintsitanaki iyaatanaki otonkaanaki tonkaariki. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Areetapaaka janta ipankoki riraga Jakariiyashi. Oñaapaakiro Erijaweera, okantapaakiro: —¿Eeniromi? ");
INSERT INTO cjoNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Rowaga Erijaweera okemantawakawori Mariiya okaemapaaki, okematziiri ishewatanaka eentsite omotzikira, mitzi. Eejatzi okyaantapaakawo Ishire Tajorentsi iyotaaperotakiro, ");
INSERT INTO cjoNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","roojatzi ocheraantanaka, okantziro: —Tema ineshironkatakimi Tajorentsi, eejatzi ikimiteeyironi maawaeni tsinani; omaanta eeroka, panaakoeyakinani: ineshironkaperotakimi rirori. Tema eejatzi iñaaperotziri peentsite ikameethatzi. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Eeroka ashityaarini Awinkatharite. ¿Iitaka pikenkithashiryaantanari pareetantanari? ");
INSERT INTO cjoNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Pamine, nokemantawakimiri piwethatapaakina, ikimoshiryaanaki neentsite, ishewatanaka nomotziki, mitzi. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Paapatziyaperotawakawo maawaeni ikamantakimiri Awinkatharite, rootaki ineshironkatantakimiri. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Okantzi Mariiya: —Tema ikameethaperotaki Awinkatharite, ");
INSERT INTO cjoNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","rirotaki Atajorentsite eejatzi owawijaakoeyeerini. Osheki nokimoshirewentakiri. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","¿Iitaka ineshironkatantakinari naari? Naaka ashironkaenkawo, tekatsi niyotzi naari. Omaanta iroñaaka aripaete ikimoshirewentena maawaeni atziri. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Osheki itajonkakowentakina, tema itajorentsiperotaki, ikameethaperotaki. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ikantatyeeyaani ineshironkaeyakirini maawaeni pinkatheeyiririni. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Osheki itajonkantayitakini. Ithonkaeyeroni okaatzi ikenkithashiryaari maawaeni kantakaaperotzinkari. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Imateeyakirini pinkatharitawitachari rookakaakiri ipinkathariwenantawita. Omaantakya ashironkaenkari ipeyakiri pinkathari. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Kimitaka ipakiri osheki oetarika riraga koetyeemotakariri, ari rotyaantakiro Ishire iyoteeri atziri kowatsiri riyoteri Tajorentsi eejatzi raapatziyantyaariri. Omaanta riraga kenkithashiryaakotawori tekatsi koetyeemotyaarini, eero rotyaantziniri Ishire riyotaantyaari. Eero rowawijaakotziri. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ikantani riraga Tajorentsi ramitakoeyakirini ajoriiyotzinkarite, tee ipeyakotee aari inta ineshironkaeyakaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Aritaki rantakiro maawaeni ikantakiriri itakaantaworini paerani: Awaraama eejatzi maawaeni icharineeteni ikanteetatyeeyaani. Rootaki okantakirori rowaga Mariiya. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ojeekakitzi 3 kashiri, roojatzi opiyantanaa onampiki. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Monkaatapaaka kitejiri okoñaawaanitantyaariri Erijaweera. Tema koñaatapaaki otomi. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ikemakoeyakironi osheninkapaeni, ikimoshirewenteeyanakironi. Ikanteeyanakini: —Tema ineshironkaperotakiro Awinkatharite. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ari okaataki imaakotaki 7, roojatzi okitejitanaki omonkaataka itotonatantyaariri ishiramparitantarira. Rameteeyawoni joriiyopaeni iitakotyaari jewatatsiri itomi ikoñaatapaaki iwaero iriri, rootaki ikananteeyarini isheninka: —Tema iitya Jakariiyashi, iitakotyaari iriri. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Omaanta okantzi riniro: —Eero iita Jakariiyashi, omaanta iitya Jowa. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ikanteeyanakironi: —¿Iitarikya pikowantari piiteri Jowa? Tee añiiri pisheninka iitachani Jowa. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Roojatzi rookorookotantanakariri rojampitantakari riraga Jakariiyashi: —¿Oetaka pikoyiri eeroka? ");
INSERT INTO cjoNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Rookotanakiniri paperi, rojankinatakiniriri: “Aritaki iitya Jowa”. Ari rotsikanateeyanakarini riroripaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Roojatzi imapokashitanaa riraga Jakariiyashi iñaawaetanee eejatzi, ikantzi: —Tema ikameethaperotaki Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Roojatzi rotsikanateeyantanakarini maawaeni isheninka. Ikemakoeyakirini maawaeni jeekatsiripaeni tonkaarikipaeni: rowaga jeekatsiri Joreeyaki. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ikenkithashireeyanakani rajankaneki maawaeni kemakoeyakiririni ikantzi: “¿Tsikama ikantatyaarika riraga eentsi? ¿Oetakama ranteri paata? Tema ineshironkaperotakiri Awinkatharite itajonkawentakiri”. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Roojatzi rowaga Ishire Tajorentsi iyotaakiri riraga Jakariiyashi, ikanantakawori iroka: ");
INSERT INTO cjoNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","—Tema ikameethaperotzi Awinkatharite, rirotaki tajonkawenteeyakaerini. Ipokashiteeyakaeni ikamawenanteeyeerini ipinawenanteeyeerorini kaari kameethatatsi antziri rowawijaakoeyanteerini. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Paerani Iraviirini rantakiniri Tajorentsi ikowakaakiriri. Iroñaaka rotyaantakiri Tajorentsi icharineeteni Iraviirini, itajorentsitaki, rowawijaakotante. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Tema paeraniperoroña riraga kamanantayitzirorini iñaani Tajorentsi, riraga kameethaperotatsiri, ikantakirini atziripaeni: “Ikantzimi Tajorentsi: ");
INSERT INTO cjoNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","‘Notyaantemiri owawijaakoeyemirini, eenitatsirika kijeeyemirini, oonawaetzimiri, aritaki rowawijaakoeyakimini’. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Tema noneshironkateeyakirini ichariniiteni Awaraama, maawaeni. Eero nopeyakotziro nokashiyakagaeyakarini. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Paerani nokantaperotakiri pichariniiteni Awaraama: ");
INSERT INTO cjoNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","‘Iinja nowawijaakoeyerini picharineetenipaeni, nokijakowenteeyaarini kijeeyawitakaririni, eero ithaawaeyini aapatziyeeyenarini. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ninkarika aapatziyenani rirotaki nashipaeni. Nowameethateeyerini, nokantyaani noñaaperoeyerini ikameethatzi’ ”. Rootaki ikantakiriri Tajorentsi itakaantaworini. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Iroñaaka notyomi, nokantemi: “Iiteetemi: ‘Eerokataki kamanantzirori iñaani Tajorentsi jenokijatzi’ ”. Tema ari pikamanteeyeerini atziri okameethatzi ijeeki kameetha, raamagaeyaarini Awinkatharite. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","78","Piyotagaeyerini atziripaeni riyoteeyantyaarini tsika ikantya rawijakotanteeyaari. Pikamanteeyerini ikaminthaaperoeyakirini Tajorentsi, eero ikenkithashiriiro eejatzi kaari kameethatatsi rantayitzirini. Aririka riyowapaaki oorya, eero otsitenitanee, inta okitejitanaki. Eejatzi okimitakya, aririka ipoñaakya Awinkatharite jenokinta, ayoperoeyanakini ");
INSERT INTO cjoNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","rowawijaakoeyeerini maawaeni aapatziyariri riraga kaari yotawitariri Tajorentsi, riraga thaawantawitawori ikame. Riyotakagaeyapaakirini tsika ikantyaari iñaaperotantyaariri Tajorentsi ikameethatzi. Rootaki ikantakirini Jakariiyashi. ");
INSERT INTO cjoNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Okanta awijaki osheki ojarentsi, antaritanaki Jowa, osheki raapatziyakari Tajorentsi. Roojatzi riyaatantaka apaniroeni tekatsinta atziri ipanko, roojatzi paata ikenkithatakaapiinteeyakirini atziripaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Eenitatsi oroomajatzi iwaero Seesari Awoshito, rirotaki pinkathariwentzirori maawaeni kipatsipaeni. Owakira ikoñaatantakari Jowa, otomi Erijaweera, ikaminaakiri Seesari: —Nokowaki rojankinatakoeyaani maawaeni atziripaeni, niyotantyaari tsikarika ikaatzi. ");
INSERT INTO cjoNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Irira Shiriiño rirotaki jewawentziriri shiiryajatzi, rojankinatanteetakawori iwaeropaeni atziri. ");
INSERT INTO cjoNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Rootaki riyaateeyantanakarini maawaeni atziri janta nampitsikinta tsikarika ikoñaatapaaki ichariniiteni paerani, rojankinatakotakaantya iwaeropaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Eeniro ijeekaki riraga Josee janta Najareeteki. Rirotaki icharineeteni Iraviiri riraga pinkatharitawitacharini. Aritaki inampitawoni irira Weriki, ojeeki janta Joreeyaki. Rootaki riyaatantanakari Josee janta, rojankinatakotakaantya. ");
INSERT INTO cjoNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Itsipatanakawo Mariiya rowaga ikashiyakarira rayero. Tekira oshinetari shirampari, omaanta omotzitashitaka rooteentsi otzimeri otomi. ");
INSERT INTO cjoNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Rareetapaaka rirori janta Weriki roojatzi okemantakari ratsikaneentakiro thowiwiwiwiwi. ");
INSERT INTO cjoNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ikowakowawitapaaka rirori pankotsi imaantapaakyaarimi omaanta ithotyaakowitapaakawo ijeekantapaakyaarimi, inta iñaapaaki apaani ipanko piratsi. Aritaki okoñaatakiri otomi jewatatsiri itzimi. Oponatakiri, owakiri jaga royiitantapiinteetantanariri piratsi rowanawo. ");
INSERT INTO cjoNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Tsitenitanaki, eeniro ijeekayitzini shentziriri rowishate janta keshiiki. Tee imayi, ikakiwentziri rowishate. ");
INSERT INTO cjoNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Romapokapaakiri Awinkatharite, ishipakiryaakoeyapaakirini, kimitaka okitejite, eejatzi iñagaeyawakirini ronampiri Awinkatharite. Ithaawantawakari oshekipero, ikantaka rompetateeyanakani, tonki, tonki. ");
INSERT INTO cjoNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Roojatzi ikantapaakiri: —Eero pithaawantana, eenitatsi nokamantemiri okameethaperotaki. Osheki pikimoshirewentero, eejatzi osheki ikimoshirewentero maawaeni atziri. ");
INSERT INTO cjoNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Owakira ikoñaatapaaki Weriki owawijaakotemini: rirotaki Awinkatharite riraga Rotyaantanewo Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Piyaate janta ipankoki piratsi, paminakiteri rirori owakira koñaatapaentsiri. Piñaapaakiri iponataka janta romaryaaka royiitantapiinteetantanariri piratsi rowanawo. Nokamantakimiro iroka iroñaaka piyotantyaari kyaaryo tee namatawitzimi. ");
INSERT INTO cjoNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Roojatzi romapokantapaakariri jenoki oshekini ronampiri Tajorentsi iñaaperoeyapaakirini, ikanteeyapaakini: ");
INSERT INTO cjoNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","—Rooma ikameethaperotaki Tajorentsi, nopinkathateeyirini janta jenokinta. Eejatzi jaka kipatsikika ijeekakagaeyerini kameetha maawaeni antzirori ikoyiri Tajorentsi riraga pinkathatziriri. ");
INSERT INTO cjoNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Roojatzi ipiyeeyantanaani maawaeni jenokinta, roojatzi ikantawakaeyanakani rirori shentziriri rowishate: —Ikamantakae ronampiri Tajorentsi koñaatapaaki Weriki owawijaakoteeni. Thametya aminakiteri. ");
INSERT INTO cjoNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Roojatzi ishintsiperotantanakari riyaatanaki, iñaapaakitziiri janta ipankokinta piratsi. Iñaapaakiri Josee, eejatzi rowaga Mariiya, omaryaakiri otomi royiitantapiinteetanariri piratsi rowanawo. ");
INSERT INTO cjoNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Iñaantapaakariri, roojatzi ikamanteeyantapaakarini jeekatsiripaeni jaga okaatzi ikantakiriri ronampiri Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ikantaka maawaeni kemakiriri ikantawakaanaka: —¿Pikemakiro ikantziri? ¿Oetaka ikantziri? ");
INSERT INTO cjoNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Omaanta roori Mariiya osheki okenkithashiryaanakawo ikanteeyakiririni, okenkithashiryaakopiintakawo ajankaneki. ");
INSERT INTO cjoNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Roojatzi ipiyeeyantanaani rirori shentziriri rowishate keshiiki. Ikimoshirewenteeyanakirini Tajorentsi ikanteeyanakini: —Tema ikameethataki Tajorentsi. Okameethataki maawaeni roñaagakaeri eejatzi maawaeni ikantakaeri. ¡Kameethari Tajorentsi! ");
INSERT INTO cjoNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Okaataki 7 imaakotaki Jesoshi roojatzi kitejitatsiri 8 itotonatanteetakariri ishiramparitantarira. Eejatzi iitakiri iwaero Jesoshi: imonkaatakiro ikantzitakawori Mariiya chapinki ronampiri Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Paerani rojankinatakaakirini Awinkatharite Moeseeshi: “Aririka okoñaawaanite tsinani otomi, okempoyeeya opankoki okaate 40 kitejiri: eero iyaatzita apiyoteeyaninta apinkathaperotzirinta Tajorentsi. Omonkaatakyaarika 40 kitejiri, okameethatzi iyaate Tajorentsipankoki aanaeri ñaanakowenantatsiriki apite jamomo eerorika apite jampakitzi”. Eenitatsi paashini rojankinatziniri okantzi: “Rirorika shirampari riraga jewatatsiri otzimiri tsinani, ikowakaakiri Awinkatharite raapatziyaperotyaari, ranaakoteri impaetatsini ikoñaatzi”. Ari ikaatakotaki 40 kitejiri itzimantakari Jesoshi, roojatzi riyaateeyantanaani Jerojareeki: Josee, Mariiya, eejatzi kijokiro owanakiri eentsite. Imonkaateeyakironi maawaeni rojankinatzirini Moeseeshi iroka okyaantapiinteeyaari Mariiya Tajorentsipankoki. Eejatzi okantakiri Tajorentsi: —Irika notyomika, nokowaki rantaperotemiro oetarika pikowakaakiriri. ");
INSERT INTO cjoNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ari ijeeki janta Jerojareeki shirampari iitachari Shimiyo. Rirotaki aapatziyaperotariri Tajorentsi, kameetha ijeeki, raapatziyaperotawo roori Ishire. Eejatzi raamaari Rotyaantanewo Tajorentsi: riraga weshiryaakagaeyaaririni maawaeni joriiyopaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Okamantakiri Ishire Tajorentsi: “Eerotzitarika pikami, ari piñaawakiri Rotyaantanewo Tajorentsi”. ");
INSERT INTO cjoNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Roojatzi otyaanantakari Ishire Tajorentsi rirori janta Tajorentsipankoki; eekiro rimpaetapaaki Josee, Mariiya, othomaakiri Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Riraga Shimiyo iñaawakirira Jesoshi, riyaatashitakiri ithomaawakiri; roojatzi ikanantakari Tajorentsi: —Nowinkatharite, tema pikameethaperotaki, ");
INSERT INTO cjoNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","noñaakiri owawijaakoteenani, riraga pikantakinari noyeeri. Iroñaaka monkaataka, tekatsi noyaanee eejatzi. Nokimoshiretaki, wetsikakina nokame. ");
INSERT INTO cjoNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Kyaaryo, potyaantakiri rowawijaakoeyerini maawaeni atziri: ");
INSERT INTO cjoNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","rirotaki riyotakagaeyerini paashinijatzitatsiri atziri, riweshiryaawenteeyaarini maawaeni joriiyopaeni aapatziyeeyemirini. ");
INSERT INTO cjoNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Roojatzi raminantanaka Josee, eejatzi Mariiya, rotsikanatanakari rirori; ikenkithashiryaakoperotanakawo ikantakiri. ");
INSERT INTO cjoNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Eekiro ikanteeyanakirini: —Nokowaki ineshironkaeyemini Tajorentsi. Eejatzi ikantakiro rinirowa eentsi: —Pamine, iinja osheki piraakotyaari pitomi: ipokantakari jaka ayoteeyantyaarini tsika akantya awijakoeyanteeyaarini omaanta ikaate osheki atziri theenkaeyeririni: rowashironkagaeyaani riroripaeni. Omaantakya paashini atziripaeni, riweshiryaawentaperoeyaarini pitomi. Apaani theenkaeyeririni, paashini weshiryaawenteeyaaririni, okoñaatzimotantyaariri ikenkithashireeyarini. Rootaki ikantakirori Shimiyo. ");
INSERT INTO cjoNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Ari ojeeki eejatzi Tajorentsipankoki tsinani oetachari Aana: ojeekantawo pankotsi imaantapiintari atziripaeni aapatziyaperotariri Tajorentsi jaga okaankiitzi Tajorentsipankoki. Tema roori rootaki kamanantakotatsiri, osheki okamantapiintakiri osheninka iñaani Tajorentsi. Irini iita Janoeri: rirotaki isheninkani Asheeri. Antyashipawoperotaki Aana: okaataki ojarentsite 84. Eejatzi roori ayitaka oemi eenironi ewankawotapaaki. Okaatzi otsipatawitakari oemi 7 ojarentsi, tekiraata otsipaperotyaariitami roojatzi ikamapithatantakawo. Rootaki ojeekantakari iroñaaka ipankoki Tajorentsi. Otzitawentari rirori, eejatzi okantani: kitejiriki, tsiteniriki amanapiintari Tajorentsi; osheki opinkathatakiri. Tee okenkithashiryaaperotaawo owayitarini. ");
INSERT INTO cjoNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Okanta iyaatashitakiri Jesoshi roori. Okantakiri Tajorentsi: —Ariwee, noñaakiri naari. Roojatzi okanteeyakirini osheninkathoripaeni: —Eeniroka irika, rirotaki owawijaakoeyeririni atziripaeni: maawaeni aamagaeyaririni. ");
INSERT INTO cjoNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Imonkaatakiro Josee eejatzi Mariiya maawaeni rojankinatakirini Moeseeshi: tema rirotaki ojankinatakaakiriri Awinkatharite. Roojatzi ipiyanteeyanaani Najareeteki: jeekatsiri Karireeyaki. ");
INSERT INTO cjoNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ikanta ikimotatanaki Jesoshi, eekiro riyaatatzi ithaamentanakitya eejatzi riyothanitaki ikenkithashiryaaperota kameetha, eejatzi eekiro ikimitakotanakityaari Tajorentsi. Eejatzi irira osheki inintaperotakiri rirori. ");
INSERT INTO cjoNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Rametapiinteeyawoni maawaeni ojarentsi riyaatapiintzi riraga Josee eejatzi rowaga Mariiya janta Jerojareeki, aririka omonkaatapaeya kitejitatsiri iitachari Rawijantakarini Ronampiri Tajorentsi joriiyopaeni janta Ejiipitoki. ");
INSERT INTO cjoNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ari iroñaaka okaataki rojarentsite riraga Jesoshi 12. Rapiitantaawori riyaatee eejatzi janta Jerojareeki. Itsipatanakawo riniro, ashitariri eejatzi paashinipaeni inampijatzi. ");
INSERT INTO cjoNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Riyaatanaki ikimoshirewentero rantakiri Tajorentsi. Rojamanitakitzi apaanipaeni kitejiri ikimoshirewentanakiri janta, roojatzi ipiyeeyawitaani riraga Josee eejatzi Mariiya itsipatawitanaari inampijatzi. Tee riyotzi jeekanakira riraga Jesoshi Jerojareeki. ");
INSERT INTO cjoNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Apaani kitejiri ikinanaki Josee eejatzi iina. Raamaashitawitakari itsipatanakari Jesoshi paashinipaeni inampijatzi. Tsitenini raminaminawitakari roojatzi otsitenitantanaka. Ikowakowawitanakari ikaateeyeenira ipokae, ");
INSERT INTO cjoNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","omaanta tee iñagaeri. Roojatzi ipiyantanaka janta raminaminatziri. ");
INSERT INTO cjoNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Okaataki kitejiri 3 roojatzi iñaantapaari rirori Tajorentsipankoki: ikaateeyirini iyotaantayitatsirini. Ikemijantziri irintapaeni riyotaantzi eejatzi rojampitayitakirini rirori oetarikapaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ari rotsikanatakari maawaeni kemakiriri, ikantzi: —¿Pikemawakiri ewankarika? ¡Riyothaniperotzi! Kameetha rakawakiri ikantziriri iyotaantatsiri, tee ikompitawo. ");
INSERT INTO cjoNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ari rotsikanatapaakari Josee, eejatzi iina. Okantakiri irowa: —Notyomi, ¿tsika pijeekakika? Pamine, nokowakowawitakimi nokaatziri pirithori. Osheki nokoetyaakimi. ");
INSERT INTO cjoNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Rakanakiro: —¿Iitaka pikowakowatantanari? Tema piyotzi nokowaperotaki nokemijantaperotero ikoyiri Pawapero. Rootaki nojeekantari jaka. ");
INSERT INTO cjoNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Omaanta tee riyotakotawakiri riroripaeni ikantawitakariri. ");
INSERT INTO cjoNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Roojatzi riraga Jesoshi royaatantanaawo, roerinkanaka ipiyeeyanaani Najareeteki. Ipiyanaaga ikantani ikemijantaperotapiintziri maawaeni okaatzi ikantziriri riraga Josee eejatzi riniro. Tekatsi rante: tee iperanita, tee ipiyathanita. Omaanta roori Mariiya osheki okenkithashiryaakawo ajankaneki maawaeni iroka oñaakiri eejatzi okemakiri. ");
INSERT INTO cjoNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Eekiro, eekiro, riyaatanakitzi riyothaniperotanakitzi, oemonkanaka kameetha. Eejatzi Tajorentsi iñaaperotakiri rirori Itomi ikameethatzi, eejatzi maawaeni atziripaeni iñaakiri ikameethatzi. ");
INSERT INTO cjoNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Iroñaaka okaatzi 15 ojarentsi ipinkathariwenteeyakirini maawaeni jeekayitatsirini kipatsikipaeni riraga oroomajatzi iwaero Teweeryo Seesari. Ari rotyaantakiri riraga Poonshiyo Peraato ipinkathariwentziri joreeyajatzi. Eejatzi rotyaantakiri riraga Erooreshi ipinkathariwentziri riraga karireeyajatzi; omaanta rirentzi Erooreshi, iwaero Jiripi, ipinkathariwentziri riraga itooryajatzi eejatzi tarakoniitejatzi. Eejatzi riraga Rijaañashi ipinkathariwentziri awireeñajatzi. ");
INSERT INTO cjoNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Eejatzi iroñaaka ipinkathariwenteeyirini ñaanakowenantatsiripaeni Aanashi eejatzi Kaejashi. Roojatzi ijeekantapaaka Jowa, itomi Jakariiyashi, janta okaankiityeenta. Ikantakiri Tajorentsi: —Nokowaki iroñaaka pikenkithatakaeri atziripaeni, eenitatsi nokowakiri pikamanteeyeririni. ");
INSERT INTO cjoNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ikanta ikinakinayitanakini rirori othapyaakiini iñaa iitachari Joriraani, ikanteeyakirini atziripaeni: —Pikenkithashiryagaeya, eero pikimitagaa paerani, pookaero kaari kameethatatsi panteeyakirini, roojatzi ikamintheeyantemirini Tajorentsi: eero ikenkithashiryaakoteemiro pantawitarini. Roojatzi nokaawoshitakotanteeyakimirini Tajorentsi riyotantyaari atziri awijakoteemi. ");
INSERT INTO cjoNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Paerani ikenkithatakotzitakarini Jowa riraga kamanantzirorini iñaani Tajorentsi iitachari Iseeyashi. Iroka rojankinatakotzitakaririni, ikantzi: “Eenitatsi iinja atziri kenkithatakayerini atziripaeni janta okaankiityeenta, ikanteri: ‘Paamayarirapa Awinkatharite. Pikameethatanaki iñaaperotantapaakimiri pikameethatzi. Aririka pikameethatanaki pikimityaawo awotsi kameethatatsiri ikinantapaakyaari Jewaperowenantatsiri: powameethatero iñaaperotanteeyapaakyaaworini. ");
INSERT INTO cjoNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Pikiyagaanteero opompaetopaeni, pityaakiyiteroni otenkanaapaeni, powameethatero maawaeni. Eejatzi powameethatero awotsi tzipitayitatsirini, otampatsikatantyaari kameetha, okameethapankaatanee. Noshiyakaawentashitakawo iroka. ");
INSERT INTO cjoNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Roojatzikya maawaeni atziripaeni iñeeyantawakyaarini owawijaakoeyeririni, riraga Rotyaantanewo Tajorentsi’ ”. ");
INSERT INTO cjoNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ikantaka ipokashiteeyawitakarini osheki atziri ikowawitaka ikaawoshitakoeyaarinimi Tajorentsi. Omaanta riraga Jowa eenitatsi ikanteeyawakiririni: —Eerokateeyakini maankipaeni: pikimiteeyakarini kamaaripaeni. Tema osheki pamatawitanteeyini, eejatzi pitheeyawaetashita. Tee okameethatzi pantziri. Tee pikowaeyawitani piyaate paamariki kaari tsiwakanitatsini, rootaki pikowantawitakari pikaawoshitakotyaarimi Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Pikowakirika nokaawoshitakotawakimiri Tajorentsi, pityaawo pikenkithashireeya, pijeekanteeyaari kameetha, pookaero kaari kameethatatsi pantapiinteeyakirini niyotantyaari tee pikimiwita paerani. Eero pikantawaetashita: “Nosheninkatakari Awaraamani, rootaki niyotantakari aritaki nawijakotee”. Pamatawitashitaka eeroka apaniroeni. Ikowakirikami riraga Tajorentsi, imatero ipeyiromi atziri iroka mapika, osheninkatanteeyaaririmi rirori aritaki rantakiromi. Omaanta eerokapaeni eerokawitaka icharineeteni Awaraama, eerorika paapatziyari rirori patsipetashitakawo pisheninkawitakari: rooma pajankanekira kimitakimi mapi: pikijotzira. ");
INSERT INTO cjoNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Maawaeni inchato kaari kithokitatsi tema ari atowaeyakironi apiyoteeyeroni atagaeyeroni paamariki. Eejatzi eerori pikimiteeyakawoni inchato kaari kithokitatsi. Kyaaryoowa rookimikari eerori Tajorentsi paamariki kaari tsiwakanitatsini. ");
INSERT INTO cjoNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Rojampiteeyakirini riraga atziripaeni: —¿Iitaka pikoyiri nanteeyerini? ");
INSERT INTO cjoNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Rakanakiri: —Otzimirika apite piithaari, pipagaanteri ashironkaenkari apaani. Otzimimotzimirika osheki powanawo, pipagaanteri eejatzi ashironkaenkari. Pikaminthaantapiinte. ");
INSERT INTO cjoNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Eejatzi ipokashitakiri Jowa aayitziririni koriki: rayiniri riraga oroomajatzi, osheki ramatawitziri eejatzi atziripaeni. Tema raagaantzitapiintakiri. Ipokashiiyakirini ikowaki ikaawoshitakoeyawakirini Tajorentsi, rojampitapaakiri: —¿Oetarika nanteri naari piyotantenari kyaaryo naapatziyakari rirori? ");
INSERT INTO cjoNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ikantawakiri: —Eero powanaashitawo eeroka apaniroeni paashitzitantyaariri iyorikite atziri, omaanta pimonkaataperotero kameetha ikantakimiri oroomajatzi. ");
INSERT INTO cjoNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Eejatzi ipokashiiyakirini apaanipaeni joraaro, rojampitakiri: —¿Oetaka nanteri naari? Ikantawakiri: —Eero pikijashitari atziri pikowantyaari pominthaayeri paapithatantyaariri iyorikite, eejatzi eero pikowantari payitantyaariri iyorikite. Pikimoshirewenteri ipinatzimirira piwinkatharite, eero pikoyi ipaetemi paashini. ");
INSERT INTO cjoNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ikanta raamagaeyarini Jesokirishito, iitashiteeyawitani rooteentsi rareetya. Ikenkithashiryaakoeyirini ikantzi: “¿Rirotakima Jowa Rotyaantanewo Tajorentsi?” ");
INSERT INTO cjoNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Omaanta ikanteeyakirini Jowa: —Nokaawoshitakoeyakimirini Tajorentsi iñaaki: kaari pomeentsitachani. Iinja ipokapaakirika Awinkatharite, osheki nopinkathaperotakiri, rooma naaka tee nomonkaatari naari. Rotyaanteeyeeni rirori Ishire Tajorentsi ojeekantanakimi pajankaneki, owameethateeyemini. ");
INSERT INTO cjoNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Iinja rinashitakagaeyaarini irira kameethatatsiri eejatzi kaari kameethatatsi. Akimitzirowanki aari anashitawo okithoki pankirentsi, kitekiyiteentsirini eejatzi anashitakawo roori jampipentakitatsiri. Akempoyeero okithoki, inta atayero jampipentakiri. Eejatzi ikimiteeyeeni rirori impaetakinari, riraga Rotyaantanewo Tajorentsi: ikamintheeyerini aapatziyeeyaririni, irira iñaaperotakiri ikameethatzi. Omaanta riraga theenkiriripaeni ari rowashironkagaeyakirini. Tema iñaaperotakiri tee ikameethatzi. ");
INSERT INTO cjoNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Aritaki ikenkithatakaapiintziri Jowa: ikamantapiinteeyakirini atziri tsika ikanteeyaa ikameethatanteeyaari, eejatzi ikamantziri tsika ikanteeyaa rawijakotanteeyaarini. ");
INSERT INTO cjoNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","20","Eejatzi ikantakiri riraga Erooreshi: —Tee okameethatzi pantayitzirini. Paapithatakiri pirentzi iina rowaga Eroriiyashi. Eeniro osheki paashini kaari kameethatatsi pantayitzirini. Roojatzi ikijanakiri Erooreshi. Ipinkathariwenteeyirini karireeyajatzi, rootaki imatantakawori raakaantakiri Jowa, shepik, romonkyaagakaantakiri. Eekiro riyaatatzi rantaperotanakiro kaari kameethatatsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","22","Tekirani romonkyaagakaanteetziri Jowa, eejatzi tekirani ikenkithatakotakiri Tajorentsi riraga Jesoshi, tema riraga Jowa ikaawoshitawenteeyakarini Tajorentsi osheki atziri. Eejatzi riraga Jesoshi ikaawoshitawentakari ashitariri, roojatzi ikenkithatakaantakariri irira. Omapokapaaka ayiitashitapaakiri Ishire Tajorentsi, opoñaaka jenokinta. Oshiyawitapaakari jamomo. Eejatzi ikemaeyawakironi ikantakiriri Tajorentsi: —Eeroka notyomi nonintashireperotzimi. Osheki nokimoshirewentakimi. ");
INSERT INTO cjoNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Okaataki rojarentsite Jesoshi 30, ritantanakawori ikenkithatakagaeyirini ijoriiyotzinkaritepaeni. Omawitya ikenkithashiryaaka maawaeni atziri rirotaki itomi Josee, rirotaki itominthori, riraga jewatatsiri ikoñaatzi. Eekiro rimpaetapaaki reentsiteperopaeni Josee. Iriri riraga Josee iwaero Erii. ");
INSERT INTO cjoNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Iriri riraga Erii iwaero Mataani. Iriri riraga Mataani iwaero Rewii. Iriri riraga Rewii iwaero Meeriki. Iriri riraga Meeriki iwaero Jaanani. Iriri riraga Jaanani iwaero Josee. ");
INSERT INTO cjoNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Iriri riraga Josee iwaero Matateyashi. Iriri riraga Matateyashi iwaero Amooshi. Iriri riraga Amooshi iwaero Nawooni. Iriri riraga Nawooni iwaero Eeshiri. Iriri riraga Eeshiri iwaero Nagae. ");
INSERT INTO cjoNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Iriri riraga Nagae iwaero Maatari. Iriri riraga Maatari iwaero Matateyashi. Iriri riraga Matateyashi iwaero Shemee. Iriri riraga Shemee iwaero Joseeki. Iriri riraga Joseeki iwaero Joraa. ");
INSERT INTO cjoNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Iriri riraga Joraa iwaero Jowanaani. Iriri riraga Jowanaani iwaero Reeja. Iriri riraga Reeja iwaero Jorowaweeri. Iriri riraga Jorowaweeri iwaero Jaratyeeri. Iriri riraga Jaratyeeri iwaero Neeri. ");
INSERT INTO cjoNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Iriri riraga Neeri iwaero Meeriki. Iriri riraga Meeriki iwaero Ariitzi. Iriri riraga Ariitzi iwaero Kojaami. Iriri riraga Kojaami iwaero Eremoraami. Iriri riraga Eremoraami iwaero Eere. ");
INSERT INTO cjoNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Iriri riraga Eere iwaero Joshoe. Iriri riraga Joshoe iwaero Eriyeshaari. Iriri riraga Eriyeshaari iwaero Joriimi. Iriri riraga Joriimi iwaero Mataa. Iriri riraga Mataa iwaero Rewii. ");
INSERT INTO cjoNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Iriri riraga Rewii iwaero Shimiyo. Iriri riraga Shimiyo iwaero Joraa. Iriri riraga Joraa iwaero Josee. Iriri riraga Josee iwaero Jonaani. Iriri riraga Jonaani iwaero Eryakiimi. ");
INSERT INTO cjoNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Iriri riraga Eryakiimi iwaero Mereeya. Iriri riraga Mereeya iwaero Maenaani. Iriri riraga Maenaani iwaero Mataata. Iriri riraga Mataata iwaero Nataani. ");
INSERT INTO cjoNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Iriri riraga Nataani iwaero Iraviiri. Iriri riraga Iraviiri iwaero Isayii. Iriri riraga Isayii iwaero Oweeri. Iriri riraga Oweeri iwaero Woosho. Iriri riraga Woosho iwaero Sharimoo. Iriri riraga Sharimoo iwaero Naashoni. ");
INSERT INTO cjoNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Iriri riraga Naashoni iwaero Aminagaawa. Iriri riraga Aminagaawa iwaero Araami. Iriri riraga Araami iwaero Aarani. Iriri riraga Aarani iwaero Eshiromi. Iriri riraga Eshiromi iwaero Paareshi. Iriri riraga Paareshi iwaero Joraa. ");
INSERT INTO cjoNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Iriri riraga Joraa iwaero Jakoowo. Iriri riraga Jakoowo iwaero Ijaaka. Iriri riraga Ijaaka iwaero Awaraama. Iriri riraga Awaraama iwaero Taree. Iriri riraga Taree iwaero Nakoori. ");
INSERT INTO cjoNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Iriri riraga Nakoori iwaero Sherooko. Iriri riraga Sherooko iwaero Ragaawo. Iriri riraga Ragaawo iwaero Pereeki. Iriri riraga Pereeki iwaero Eeweri. Iriri riraga Eeweri iwaero Jaari. ");
INSERT INTO cjoNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Iriri riraga Jaari iwaero Kaenaani. Iriri riraga Kaenaani iwaero Aratajaari. Iriri riraga Aratajaari iwaero Sheeme. Iriri riraga Sheeme iwaero Noe. Iriri riraga Noe iwaero Rameeki. ");
INSERT INTO cjoNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Iriri riraga Rameeki iwaero Matojareeni. Iriri riraga Matojareeni iwaero Enoko. Iriri riraga Enoko iwaero Jareeri. Iriri riraga Jareeri iwaero Maarareeri. Iriri riraga Maarareeri iwaero Kaenaani. ");
INSERT INTO cjoNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Iriri riraga Kaenaani iwaero Enooshi. Iriri riraga Enooshi iwaero Seete. Iriri riraga Seete iwaero Araani. Paerani riwetsikantakariri Tajorentsi riraga Araani. ");
INSERT INTO cjoNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ikanta Jesoshi itonkaantanaari tema ipoñaakaga Joriraanikira. Ikithaatakotakawo Ishire Tajorentsi, aanakiri janta okaankiityeenta. ");
INSERT INTO cjoNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Okaatzi 40 kitejiri ijeekaki janta, tee rowaneenta eechonkiini: aaperotakiri itashe. Ikanta riyaatashitakiri Jatanaashi riraga iwinkatharite kamaaripaeni iñaantari, ikowawitaka rantakayerimi kaari kameethatatsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ikantawitapaakari: —Eerokarika Itomipero Tajorentsi, ajaatya: pitajonkero iroka mapika, opeyanakya paa, poyaari. ");
INSERT INTO cjoNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Rakanakiri Jesoshi: —Eero nantziro. Okantzi Iwaperite Tajorentsi: “Tee apatziro akoyiro owanawo ashintsiwathatantyaari, inta kowaperotacha akemijantaperotero maawaeni ikowakaakaeri Tajorentsi ashintsitantyaari ashireki”. ");
INSERT INTO cjoNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Roojatzi raanakiri antawoki ochempi, rookotapaakiniri maawaeni kipatsi, ");
INSERT INTO cjoNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ikantakiri: —Pikowakirika nokanteeyerini maawaeni jeekatsiripaeni ipinkathateeyemini, raakameethateeyemini. Aritaki nomatakiro noperi ninkarika nokoyiri. Tema naaka pinkathariwenteeyiririni maawaeni, ");
INSERT INTO cjoNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","aririka nokanteri ipinkathateeyemini eerori, aritaki ipinkathateeyakimini. Apatzirokya nokowaki potziwerowashitena, pipinkathatena naari. ");
INSERT INTO cjoNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Rakanakiri: —Rooma okantzi Iwaperite Tajorentsi: “Pipinkathateri Awinkatharite, tema rirotaki Tajorentsi. Apatzirokya irira paapatziyari, piñaaperoteri, eejatzi pikimoshirewenteri”. ");
INSERT INTO cjoNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Roojatzi raantanakari janta Jerojareeki, okaapankatapaakinta Tajorentsipankoki, jantoo jenoki. Ikantapaakiri: —Eerokarika Itomi Tajorentsi, ajaatya: pomyaanakyaatya jaawiki, eero pikamantapaaka. ");
INSERT INTO cjoNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Pikenkithashireerotya okaatzi okantzimiri Iwaperite Tajorentsi: “Ari rotyaantakimiri Tajorentsi ronampiripaeni, ikempoyeemi”. ");
INSERT INTO cjoNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Eeniro eejatzi paashini rojankinatzirini: “Aritaki raawakimi rakokira, eero pikagaantapaaka jaawiki mapiki”. Ñaakiro, ¿iitaka pithaawantakari? ");
INSERT INTO cjoNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Rakanakiri: —Eero nomyaa. ¿Iitaka noñaanantyaariri Pawa? Rooma eenitatsi paashini okantzi Iwaperite Tajorentsi: “Tee okameethatzi añaantawityaari Tajorentsi: rowashironkaemikari”. ");
INSERT INTO cjoNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ikanta iwinkatharite kamaari teera imatziro rantakayiri Jesoshi kaari kameethatatsi, roojatzi rookantanaari. Omaanta iinja rapiiteeri. ");
INSERT INTO cjoNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Roojatzi ipiyantanaa Jesoshi Karireeyaki, osheki omatakaakiri Ishire Tajorentsi: tema okithaatakaakari roori. Tee ojamanitzi ikemakoeyakirini maawaeni jeekatsiripaeni janta. ");
INSERT INTO cjoNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Riyotaantapiintaki pankotsiki ipiyotantapiintarira joriiyopaeni. Ikanteeyanakini: —Tema ikameethataperotaki Jesoshi; tema kameetha riyotagaeyakaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Roojatzi riyaatantanaa Jesoshi Najareeteki, rootaki inampi rantaritakira paerani. Ikantanaka saawaroki riyaatanaki janta pankotsiki ipiyotantapiintarira joriiyopaeni, tema rametapiinteeyawoni riyaatzi saawaroki. Inthomaenta ikatziyapaaka, iñaanateniri atziripaeni Iwaperite Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ipaetawakiri rojankinarini Iseeyashi. Rapineeryaakiro, raminakiro iñaanateniriri. Okantzi: ");
INSERT INTO cjoNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Okithaatakaapaakina Ishire Awinkatharite, otyaantakina nokamanteri maawaeni ashironkaayitacharini tsika ikantyaari rawijakotanteeyaari. Nokamanteri maawaeni romperatanewopaeni kamaari noemishitowaeyeerini. Noñaakagaeri eejatzi kaari kokichaatatsi. Eejatzi nopakaakowenteeri maawaeni rowashironkagaetziri. ");
INSERT INTO cjoNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Eejatzi nokamanteeyerini atziri rooteentsi notajonkakowenteri”. ");
INSERT INTO cjoNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Roojatzi rapineetantawo Iwaperite Tajorentsi, roepiyeeniri ipaeri, roojatzi ijeekantanaa. Ari rotsikanateeyanakarini joreririri. ");
INSERT INTO cjoNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ikanteeyakirini: —Kyaaryo iroñaaka nomonkaatakiro iroka noñaanatakimirika, naaka okenkithatakotzi. ");
INSERT INTO cjoNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ikanta iñaaperoeyawitakarini kameetha Jesoshi, eejatzi iñaaperoeyakironi okaatzi ikantakiriri. Roojatzi rojampitawakaeyakani: —¿Kaarima itomiranki Josee? ");
INSERT INTO cjoNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ikantakiri: —¿Pitheenkatyaanama? Naamaashita pikantenami: “Ajaatya, powawijaakoteritya pinampijatzipero eerori. Nokemakotakimi pitajonkantaki janta Kaperinawooki, iroñaakakya pitajonkantetya eejatzi jaka anampikika”. ");
INSERT INTO cjoNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Omaanta nokamantemi pameteeyaawoni eerokapaeni pitheenkaeyirini pisheninkapero: tee piyotzi pipinkathatziri rirori, omaantakya paashinijatzi rirotaki pikoyiri pipinkathateri. ");
INSERT INTO cjoNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","Kyaaryo iroka nokamantemiri: paerani eenironi ijeekini Iriiyashini, piyoteeyakini tee opariyini inkani. Tema paerani osheki ojarentsitakini. Okaatzi 3 ojarentsi eejatzi 6 kashiri, tee opariyanee inkani. Itasheyeeyanakini maawaeni jeekatsiripaeni kipatsiki. Eejatzi ojeeki osheki kamayiteentsirini oemi jaka, omaanta rotyaantakiri Tajorentsi Iriiyashi paashiniki kipatsi owaero Jeniishiya. Rotyaantziri riyaatashitero kamatsiri oemini jeekatsiri janta Jareepetaki, okaakintawo Shiroo. Itajonkawentapiintakiniro owanawo. Omaanta jeekatsiri jaka inampiki, tee itajonkawentziniro. ");
INSERT INTO cjoNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Eejatzi, paerani ijeekantakari Eriseeyoni riraga kamanantzirorini iñaani Tajorentsi, ijeekini jaka osheki patheenkari, omaanta tekatsi retsiyatakote. Apatziro retsiyatakotakiri shiiryajatzi iitachari Naamaani. Tema raapatziyari Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ikemaeyantawakarini piyoteeyeencharini, ikijeeyaperotanakani. ");
INSERT INTO cjoNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Roojatzi ikatziyeeyantanakani, ragaeyakirini, shepik. Raanakiri janta othapiiteki nampitsi, ojeekinta impeeta. Rotatsinkantyaaririmi, ");
INSERT INTO cjoNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","omaanta tee imatziri, tee iñaawakiri tsikarika ikinanawo. ");
INSERT INTO cjoNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ari ipiyanaa Jesoshi Kaperinawooki karireeyawero. Saawaroki riyotagaeyakirini atziri. ");
INSERT INTO cjoNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Riraga atziripaeni rotsikanateeyanakarini, ikantawakagaeyanakani: —Tema okameethataki iroka riyotaakaeri. Ikimiwitakari pinkathari: rooma riyotaaperotakae kameetha. ");
INSERT INTO cjoNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ari ijeekaki pankotsiki janta ipiyotantapiintarira joriiyopaeni shirampari kyaantariri kamaari. Icherayimotawakiri, ikaemakotawakiri: ");
INSERT INTO cjoNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Eeroka Jesoshi poñaachari Najareeteki. Niyotakimi: eeroka Itomipero Tajorentsi riraga kameethaperotatsiri. ¿Iitaka pipokashitantanari? ¿Pikowawitama pookena janta otsiteniperotzinta? ");
INSERT INTO cjoNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Iñaashintsithatakiri Jesoshi, ikantakiri: —¡Pimaerite! Pishitowantaneeyari irira shiramparira. Roojatzi rotyaantanakari shirampari kipatsiki, tereei, roojatzi rookantanaari. Tekatsi ikantanakiri shirampari, riroperotanee. ");
INSERT INTO cjoNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Rotsikanateeyanakarini eejatzi ikanteeyanakini: —Piñaakiri: apatziro iñaanatakiri kamaari, roojatzi ishitowantanaka. Osheki ipinkatharentsitaki, osheki itajonkantzi. ");
INSERT INTO cjoNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ikanta ikemakoeyakirini Jesoshi maawaeni jeekatsiripaeni jaga. ");
INSERT INTO cjoNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Roojatzi ishitowantana Jesoshi pankotsiki ipiyotantapiintarira joriiyopaeni riyaatanaki ipankoki Shimo. Ikanteetawakiri: —Omantsiyatatziira riyote Shimo, osheki ojaawamerikitaki. Petsiyatakoteero. ");
INSERT INTO cjoNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Roeyotashitapaakawo, ikantapaakiro: —Ari opeyaneeya pijaawamerikiri, petsiyatakotanee. Roojatzi opeyantanaa, tekatsitanee; okatziyanaka, opaeyawakirini rowanawo. ");
INSERT INTO cjoNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ikanta itziryaanee oorya. Ramaetapaakiniri Jesoshi osheki mantsiyari inashitachari imantsiyarentsite. Ipampiteeyawakirini, retsiyatakoeyawakirini. ");
INSERT INTO cjoNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Eejatzi rowawijaakoyitakirini osheki kyaantariri kamaari. Riraga kamaaripaeni riyotawakirira Jesoshi rirotaki Rotyaantanewo Tajorentsi rootaki ikaemaeyantanakani, ikanteeyini: —Eeroka Itomi Tajorentsi. Omaanta riraga Jesoshi ro romaeryaantakariri, tema ikantanakitziiri: —Pimaerite, eero pikamantakotana. Roojatzi rookantanaari rirori atziripaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Okantaka okitejitanaki riyaatanaki Jesoshi janta tekatsinta jeekatsini. Omaanta ikowakowaeyanakirini atziripaeni. Iñaantaariri, ikanteeyawitapaarini: —Eero piyaatee, pijeeki jaka Kaperinawooki. ");
INSERT INTO cjoNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Omaanta ikantanakiri Jesoshi: —Eero nojeeki. Nokowaki nokamanteri paashinipaeni atziri ipinkathariwenteeyerini Tajorentsi, tema okameethatzi riyoteeyeroni riroripaeni. Rootaki rotyaanantakinari Pawa. ");
INSERT INTO cjoNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ikantaka ikinakinayitanakini Jesoshi janta Karireeyaki, ikenkithatakagaeyakirini atziri janta pankotsikipaeni ipiyotantapiintarira joriiyopaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Paashini kitejiri ikenkithatzi Jesoshi janta othapyaaki inkaare iitachari Jenejareete. Iiteetziro eejatzi Karireeya. Itsitachonchoeteeyapaakani atziripaeni, ikowaeyakini ikemero iñaani Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ikanta Jesoshi iñaakiro apite pitotsi janta othapyaaki. Tekatsi otetantyaawoni: riraga shiryaatatsiri ikiwatziiro ishiryaamento iñaaki. ");
INSERT INTO cjoNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Rotetaka Jesoshi ipitoki Shimo, ikantakiri: —Shimo, potyaantero eechonkiini niyankyaani pitotsi. Ari ijeekakotaki, riyotagaeyakirini piyoteencharipaeni othapyaakininta. ");
INSERT INTO cjoNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ithonkantakawori riyotagaeyakirini, ikantakiri Shimo: —Piyaate janta ojaanaatakinta, pishiryaate. ");
INSERT INTO cjoNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Rakanakiri: —Iyotaanari, nokitejitakowitaka noshiryaatzi inkaaganki, tekatsi naaneente eechonkiiniroña. Iroñaakakya pikantakinaka, aritaki niyaataki noshiryaataate eejatzi. ");
INSERT INTO cjoNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ikantaka ishiryaataatzi: raaperotaki osheki shima monki, monki. Yeekitaki ishiryaamentoki, rooteentsi otzijagaanakimi. ");
INSERT INTO cjoNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ikaemawakotakiri iyempiyaminthari jeekatsiri paashiniki pitotsi ikantziri: “Pipoke pamitakoteeyenani”. Roojatzi ipokakotanteeyapaakani, rotetakotakiri terori, terori; yeekitapaaki apite pitotsiki, roowiteenchami otsitsiyanakimi. ");
INSERT INTO cjoNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Ikaatzi osheki shima raaki, antawo ikenkithashiryaakotanakawo okaatzika iñaakiri; Peetero eejatzi ikimiteeyakani iyempiyaminthari: riraga Jantyaako eejatzi Jowa. Rirotaki itomi Sewereeyo. Itsipatapiintari Shimo ishiryaatapiintziri shima. Rotziwerowashitanakari Peetero Jesoshi, ikantanakiri: —Nowinkatharite, potsipareena. Tee nokameethaperotzi naaka, eero pitsipatana. Rakanakiri Jesoshi: —Eero pithaawantana. Eenitatsi nokamantemiri: eerokataki shiryaawitariri shima, omaanta iroñaaka eero pishiryaataneeri shima, inta paapatziyakaapiinteeyaarini atziripaeni Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ikanta raatakoeyapaani, roojatzi rookaeyantanakawoni ipitopaeni, ishiryaamentopaeni, maawaeni. Royaateeyanakirini Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Paashiniki kitejiri janta nampitsiki ari ijeeki Jesoshi roojatzi ipokantapaaka shirampari pathaaperotatsiri: othonkakiri ipathaawo. Iñaantapaakariri Jesoshi, rotziwerowashitapaakari, ikantziri: —Nowinkatharite, tema eeniro pitajorenka: pikowakirika petsiyatakotena, aritaki pimatakiro. ");
INSERT INTO cjoNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Roojatzi rowaankantawakawo rako rirori, ipampitawakiri. Ikantziri: —Nokowaki. Petsiyatakotee. Intsipaete opeyanaka ipathaawo. ");
INSERT INTO cjoNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Roojatzi ikantanakiri: —Eerowa pikamantakotana. Apatziro piyaatanaki janta ñaanakowenantatsiriki, poñaagapaeyaari riyotantyaari etsiyatakoteemi. Pimonkaatero ikantakirini Moeseeshi: “Paanakiniri ñaanakowenantatsiri pipira itayeniri Tajorentsi riyoteeyantyaarini atziripaeni etsiyatakoteemi”. ");
INSERT INTO cjoNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Omaanta eekiro riyaatatyee ikamantakoeyakirini Jesoshi. Oshekiniroña atziri riyaatashiteeyawitakarini raapatziyarimi, eejatzi osheki ikowaeyawitani retsiyatakotantyaaririmi. ");
INSERT INTO cjoNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Omaanta riyaatanaki rirori janta tekatsinta atziri ipanko, ikenkithatakayeri Iriri. ");
INSERT INTO cjoNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Paashini kitejiri riyotaantee Jesoshi pankotsiki. Ari ijeekayitakini okaakini warijeeyopaeni eejatzi iyotaantzirori Iwaperite Tajorentsi: ipoñaayitanakani osheki nampitsikipaeni, janta Karireeyaki, Joreeyaki, eejatzi poñaayitaneencharini Jerojareeki. Tema eenitatsi itajorenka Awinkatharite imatantawori retsiyatakotantzi. ");
INSERT INTO cjoNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Okaakitapaaki shiramparipaeni, ramakoeyakirini kijopookitatsiri. Ikowaeyawitakani raanakirimi janta ijeekakinta Jesoshi, omaanta tekatsi ikinakaanakiri, rotzikagaeyakirini atziripaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Tekatsi ikini ikyaapaaki, rootaki rateetakaantanakariri opatziitoki pankotsi. Rothataakotakiri imoontakiro ijeekakira Jesoshi, roojatzi royiitakotakiri kijopookitatsiri. ");
INSERT INTO cjoNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Riyotawakiri amakiriripaeni raapatziyeeyakarini, rootaki ikanantawakariri: —Niyompari, ari nopeyakotemiro kaari kameethatatsi pantawitari, aritaki nowawijaakotemi. ");
INSERT INTO cjoNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ikantaka ikenkithashireeyanakani warijeeyopaeni eejatzi iyotaantzirori Iwaperite Tajorentsi: “Tee okameethatzi iroka: iitajorentsitashitaka. Apaniroeni Tajorentsi rowawijaakotantzi”. ");
INSERT INTO cjoNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Omaanta riyotakotakiri Jesoshi ikenkithashireeyarini riroripaeni, roojatzi ikanantanakari: —¿Iitaka pikenkithashiryaantari pajankaneki: “Iitajorentsitashitaka”? ");
INSERT INTO cjoNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Aririka nokanteri irika: “Netsiyatakoteemi iroñaaka, pikatziyatziyawaetanaki”, tema ari potsikanatanakyaari. Eerorika imatziro ipiriinta, ari pishirontawentanakina naaka. Omaanta ari kameetha pikantanaki tekatsi shirampari materoni rowawijaakoteri atziri kaari kameethatatsi rantziri. Kameetha pikante. Tema piitashiwitaka nokantashitari: “Nowawijaakotemi, eero nokijawentzimiro kaari kameethatatsi pantziri”. ");
INSERT INTO cjoNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Nopoñaaka naaka jenokinta, nokoñaatapaaki jaka kipatsikika. Nokowaki piyoteeyeni eenitatsi notajorenka, eejatzi nomatakiro nokamintheeri antzirori kaari kameethatatsi, nowawijaakoeyerini. Roojatzi ikanantanakari kijopookitatsiri: —Iroñaaka nokantemi: pikatziyanaki, paaneero pimaamento, piyaatee pipankoki. ");
INSERT INTO cjoNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Iñeeyawakirini ikatziyanaa, raaneero imaamento, jatanee ipankoki. Ikantanaki: —Ariwee, tema ikameethaperotaki Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ari rotsikanateeyanakarini atziripaeni, ikanteeyanakini: —Tema ikameethaperotaki Tajorentsi, ipinkatharitaperotzi. Tee añaapiintziro iroka añaakirika iroñaaka. ");
INSERT INTO cjoNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Roojatzi ishitowantanaa Jesoshi, roojatzi iñaantapaakari Rewii, riraga piyotayitziniriri atziri iyorikite, ipantyaariri pinkathari. Ijeeki janta pankotsiki ipiyotapiintzirira koriki, rojankinatapiintzinta. Ikantapaakiri: —Thame poyaatanakina. ");
INSERT INTO cjoNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ipakaanakiro rojankinatakotayitzirini koriki, rookanakiro maawaeni, ikatziyanaka, royaatanakiri Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Riraga Rewii raanakiri irira eejatzi riyotaanewo janta ipankoki. Roojatzi ikaemakaantakiri paashinipaeni piyotziniriri pinkathari iyorikite, eejatzi paashinipaeni atziri, rowakagaeyakarini. ");
INSERT INTO cjoNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ipokapaaki warijeeyopaeni eejatzi riraga iyotaantzirori Iwaperite Tajorentsi ikiñaanikowentakiri rirori: ikantakiri riyotaanewo: —Pamineritya Jesoshi: itsipateeyakarini piyotziriri iyorikite oroomajatzi, rowaeyani, imiriiyini. Eeniro eejatzi paashinipaeni kaari kameethatatsini. Tee okameethatzi itsipateeyaarini rowakagaeyaarini. ");
INSERT INTO cjoNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ikantawakiri riraga Jesoshi: —Riraga kaari mantsiyatatsini tee ikoyi aawinantatsiri raawinteri. Intakya mantsiyatatsiri rirotaki kowatsiri. ");
INSERT INTO cjoNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Tee riro nopokashitziri kameethatzinkari omaantakya nopokashitziri riraga kaari kameethatatsi, riyotanteeyariri Tajorentsi eejatzi raapatziyari. Rootaki ikantziriri rirori warijeeyopaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ikantakiri warijeeyopaeni Jesoshi: —Pamine, itzitapiinta riyotaanewo Jowa, eejatzi ikenkithatakaapiintziri Tajorentsi: eejatzi ikimiteeyakarini riyotaanewo warijeeyo. Omaanta riraga piyotaanewopaeni pashi tee itzitawo; inta rowapiinteeyani, rirapiinteeyini. ");
INSERT INTO cjoNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Rakanakiri: —Aririka raye shirampari iina, ikaemaeyerini isheninkapaeni ikimoshirewenteeyantyaaririni. Aririka rareeteeyakyaani, ¿arima itziteeyapaakyaani? Eero. Eejatzi naari, nokaateeyirini iroñaaka niyotaanewopaeni: ¿Iitaka notzitakaantyaariri? ");
INSERT INTO cjoNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Rooma rookaeyaneerini isheninka aatsiri iina, roojatzikya itziteeyantanakyaani. Eejatzi nokimiwitaka naari: aririka iinja nokame, ari rowashiretakoeyanakinani niyotaanewo, roojatzikya itziteeyantanakyaawoni rirori. ");
INSERT INTO cjoNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Eejatzi roshiyakaawentziri iroka; ikantziri: “Eejatzi, eenitatsirika atziri iithaari owakirari, eero itzijagaero owawatawo eechonkiini rowawatatantyaawori antyashipawopooki imaatha. Aririka powawatatero, eero omonkaatawakaana. Eejatzi pikiwerorika aminthamawotanakyaarika owakirari, eejatzi eekiro iyaatanakitye oshipaanaki itaworipooki. ");
INSERT INTO cjoNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","38","Tema apyaaganantawo owakirari pyaarentsi imashiki owakirari, roojatzi ashirikakotantakyaawo eero apaatanta. Aririka oshimowanaki oshinchaatanakirika, otapiyaperotakiri imashi. Rirorika owakirari, eero ipejakotzi, eejatzi eero apaata oowaa. Roorikami apyaaganantyaawomi pyaarentsi itawori imashi, tema itapiyamootzitanakirika itonkanaki: pooo. Tzijaanaki, eejatzi apaatanakya pyaarentsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Tema aririka ireeyeroni itaworyaateentsiri pyaarentsi, eero akoyiro irero owakirari”. ");
INSERT INTO cjoNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Apaani saawaro, ikinanaki Jesoshi teriikomashiki, itsipatanakari riyotaanewopaeni. Irirapaeni ithatyaayitakini apaanipaeni okithoki teriiko, ramirokakitakiro, okaankikitanaki okithoki, rowaeyakawoni. ");
INSERT INTO cjoNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Iñeeyakirini warijeeyopaeni, ikantakiri: —Tee okameethatzi iroka pantziri. Tema iroka saawaro, kitejitatsiri amakoreeyantarini, eero atayaantawo iroñaaka. ¿Iitaka panantakawori? ");
INSERT INTO cjoNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","4","Rakanakiri Jesoshi: —Tema tee piñaananeentziro rojankinatakoteetakiririni Iraviiri. Aantakariri itasheni eejatzi itsipateeyarini. Eenitatsi janta ipankomawoki Tajorentsi paa riwetsikaetziniriri irira. Apaniroeni rowaeyawoni ñaanakowenantatsiripaeni, tee oshinetziri Iwaperite Tajorentsi paashinipaeni royaawo. Omaanta rashironkaantawitakari, aantawitakariri itashe Iraviiri, rootaki ipantakariri paa riraga iwinkatharite ñaanakowenantatsiri, eejatzi ipaeyakirini maawaeni oyaateeyiririni. Ñaakiro, tema tee ikowakayiri rowashironkaeya itasheyi. ");
INSERT INTO cjoNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Nopoñaaka jenokinta, nopokapaaki jaka kipatsikika, nokoñaatapaaki: tema naaka kantatsini oetarika anteri saawaroki. ");
INSERT INTO cjoNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Paashini saawaro riyaatanee janta pankotsiki ipiyotantapiintarira joriiyopaeni, ikyaapaaki riyotaantapaaki irirapaeni. Ari ijeekaki janta shirampari kijopookitatsiri rakopero. ");
INSERT INTO cjoNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Rotsikanaperotakari iyotaantzirori Iwaperite Tajorentsi eejatzi warijeeyopaeni, ikowaki riyoteri aririka retsiyatakotante saawaroki, ikantakotantyaariri iwinkathariteki: “Noñaakiri Jesoshi rantakiro kaari kameethatatsi”. ");
INSERT INTO cjoNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Omaanta riyotakiri Jesoshi ikenkithashireeyakarini. Ikantanakiri kijopookiri rako: —Pipoke, pikatziyapae jaka niyankika. Roojatzi ikatziyantanaka, riyaatashitakiri. ");
INSERT INTO cjoNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ikanteeyakirini rirori: —Iroñaaka nojampiteeyemini. ¿Oetaka kameethatatsiri anteeyerini saawaroki? ¿Kameetharinima akaminthayeri atziri? Teerika okameethatzi, ¿pikowatziima owashironkaeri? ¿Kameetharinima owawijaakoteri atziri? Teerikama okameethatzi, ¿pikowatziima owamaeri? ");
INSERT INTO cjoNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ramineeyakirini Jesoshi, imaeriiyakini. Roojatzi ikanantanakari: —Powaankaero pako. Roojatzi rowaankantanakawo, kameethatanee rako. ");
INSERT INTO cjoNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Omaanta ikijaperoeyanakani ñaanakowenantatsiripaeni. Ikantawakaeyanakani: —¿Tsika akanterika owamaakaanantyaariri? ");
INSERT INTO cjoNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Paashini kitejiri riyaataki Jesoshi tonkaariki, ikenkithatakaantyaariri Iriri. Ari ikitejitakotakaakiri ikenkithatakayiri. ");
INSERT INTO cjoNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ikaemaeyakirini oyaateeyakiririni, riyoyaanteeyakaririni 12 riyotaanewopero. Ikowaki rotyaanteri iinja ikenkithatakotantyaawori iñaani Tajorentsi, rootaki iitantariri rotyaantanewo Jesoshi. Iroka iwaeropaeni: ");
INSERT INTO cjoNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","16","Shimo (eejatzi iitziri Jesoshi Peetero), Antereeshi (riraga rirentzi Shimo), Jantyaako, Jowa, Jiripi, Waritoromee, Mateeyo, Tomashi, Jantyaako (riraga itomi Arijeeyo), Shimo (riraga kathaaperotzinkari antayitzirorini oetarikapaeni), Joorashi (riraga rirentzi Jantyaako) eejatzi Joorashi karyootejatzi (riraga aakaanterini iinja Jesoshi). Rootaki iwaeropaeni riyotaanewo riyoyaakiri Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Roojatzi roerinkapaa janta okameethapatheetyeenta. Ipiyotakanta osheki riyotaanewopaeni, eejatzi osheki paashinipaeni atziri: ipoñeeyakani Joreeyaki, Jerojareeki, Tziiroki, eejatzi Shirooki. Ojeeki Tziiro eejatzi Shiroo inteena, janta othapyaaki antaworoña inkaare. Riyaatashiiyakirini Jesoshi ikemijanteeyawakirini, eejatzi ikowaeyakini retsiyatakoeyeni maawaeni mantsiyaripaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Rowawijaakoeyakirini kyaantariripaeni kamaari. ");
INSERT INTO cjoNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ikowaeyakini maawaeni ipampiteeyapaakirini, itajonkakowenantyaariri retsiyatakotantaneeyaari imantsiyatakira. ");
INSERT INTO cjoNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Riraga Jesoshi ramineeyanakirini riyotaanewopaeni, ikantakiri: —Aririka pashironkaawitakya iroñaaka, pikimoshirete: aritaki ipinkathariwenteeyeemini Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Aririka pikoyi pantero oetarika ikowakaakimiri irira, pikimoshirete: aritaki ramitakotakimi pantero. Aririka powashiretawitakya iroñaaka, pikimoshirete: aritaki ikimoshiryaakagaemi rirori iinja. ");
INSERT INTO cjoNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Aririka ikijeeyemini atziripaeni panantawori okaatzi ikowakaakimiri Tajorentsi, eerorika ikowaeyimini itsipateeyimini, imaninteeyeminirika ikantemi: “Tee pikameethatzi”. Eejatzi ikijanteeyemironirika paapatziyanaka, omaanta ikimoshiryaakayemi Pawa. Tema nopoñaaka naaka jenokinta, nokoñaatapaaki jaka kipatsikika. ");
INSERT INTO cjoNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Aririka ikijeeyemini, pikimoshireperote, pikanteeyeni: “Kameethawee”. Tema aritaki kameetha ipinaperotemi Pawa jenokinta. Kyaaryo riraga itakaantaworini ikijeeyakirini riraga kamanantayitzirorini iñaani Tajorentsi paeraniperoroña. ");
INSERT INTO cjoNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Eenitatsi paashini eejatzi ikantakiriri Jesoshi: —Omaanta riraga ashaagantachari, ikimoshirewentziro rowaagawo iroñaaka: monkaataka, rowashironkaeya rirori iinja. ");
INSERT INTO cjoNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Eejatzi rowashironkaeyani iinja riraga kimoshirewenteeyawitaworini iroñaaka rowanawopaeni, tema ari iñaakiro iinja itashe. Rowashironkaya iinja shironteeyacharini iroñaaka: iinja rowashireteeyanakyaani eejatzi riragaeyaani. ");
INSERT INTO cjoNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Aririka iroñaaka iñaaperoeyemini maawaeni atziri, iinja osheki pashironkaeya: tema riraga itakaantaworini paerani iñaaperoeyashitarini riraga amatawiteeyiririni. ");
INSERT INTO cjoNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Eejatzi ikanteeyakirini riraga Jesoshi: —Pikemijanteeyawakinani nokantemiri: pinintaperoteri eeroka kijeeyimirini, pikaminthayeri. ");
INSERT INTO cjoNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Pamaneri Tajorentsi ramitakoeyerini maawaeni kantzimateeyakimirini, eejatzi maawaeni kijeeyimirini. ");
INSERT INTO cjoNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Aririka ipajawootemi, pishineteeyaari ipajawootemi eejatzi jakakiroka. Aririka raapithatemiro pipewiryaakogo, piperi paashini piithaari eejatzi. ");
INSERT INTO cjoNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Aririka ramanakotemiro oetarikapaeni, piperi. Aririka raapithatemiro powaagawo, eero pikowakoteeri eejatzi. ");
INSERT INTO cjoNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Aririka pikowaki ikaminthayemi paashinipaeni, eejatzi eerori pikaminthayeri irirapaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Apatzirorika pinintaperotashiteeyarini maawaeni nintaperoeyimirini eerori, tema monkaataka okaatzika pantakiri: tekatsi ikantya ipinatemi Tajorentsi. Tema riyotzitari riraga kaari aapatziyariri rirori inintaperoeyakirini riraga nintaperoeyiririni rirori. ");
INSERT INTO cjoNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Eejatzi okimitaka roori: apatzirorika pineshironkatashityaari neshironkapiintzimiri eerori, tema eejatzi monkaataka okaatzika pantakiri. ¿Iitaka pikoyiri ipinatemiri Tajorentsi? Eejatzi riraga kaari aapatziyari Tajorentsi ikamintheeyirini kamintheeyiririni rirori. ");
INSERT INTO cjoNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Aririka pikowaki roepiyeemi pipakiriri atziri, tema monkaataka: ¿pikenkithashiryaakama ipaemi eejatzi Tajorentsi? Tema eejatzi ipakiriri riraga kaari aapatziyari irira oetarikapaeni, eejatzi ikowaki roepiyeeniri okaatzi ipawitariri. ");
INSERT INTO cjoNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Rootaki nokanantakimiri pineshironkaeyerini eeroka kijeeyakimirini, pikaminthaante, pipashitayityaarini ashironkaenkari: eero pikenkithashirya aririka imatero roepiyeemi. Aririka pantero iroka, aritaki ipinataperotakimi Tajorentsi kameetha, eejatzi itomintaperoeyemini. Tema kameetha ipinkathariwenantzi rirori janta jenokinta. Kyaaryo ikamintheeyakirini piyaathateeyawitaririni, riraga kaari kameethateeyatsini. ");
INSERT INTO cjoNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ineshironkataperotantzi Tajorentsi: eejatzi pikimitakoeyaarini eerori pineshironkatante. ");
INSERT INTO cjoNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Eekiro riyaatatyee ikantakiri Jesoshi: —Eero pikantakowentashitari atziri, eejatzi eero pikantashitari: “Eeniro rantani”, ikantzimikari Tajorentsi: “Eeniro pantani eerori”. Eero pikijawentziri atziri rantayitzirini inta pikaminthayeri: panterorika iroka eero ikijawentzimiro riraga Tajorentsi pantayitzirini eerori, inta ikaminthayemi. ");
INSERT INTO cjoNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Aririka pipayiterini ashironkaenkari koetyeemotayitaririni, eejatzi ikimiteemi rirori Tajorentsi: ipayitemironi maawaeni koetyeemotayitakimirini eerori. Noshiyakaawentemiro: tee ithañaaneentawo ipaperotemi; inta kameetha rotenakero, ipatzitakotero, rowintaaperotero, ranonkayitakaaneentakawo ipashitemiri. Omaanta aririka eechonkiini pikaminthaante, eejatzi eechonkiini ikaminthayemi eerori. Aririka pikaminthaantaperote osheki, eejatzi osheki ikaminthaaperoetemi eerori. ");
INSERT INTO cjoNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Roojatzi roshiyakaawentakiniriri Jesoshi, ikantakiri: —¿Arima imatakiro kaari kokichaatatsi rakathateri ikaateeyinira paashini kaari kokichaatatsi itentawakaya? Eero imatziro: eenitatsirika omoo jaga, tema ari ipariyeeyakini. ");
INSERT INTO cjoNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Apaani riyotaanewo tee ranaakotziri iyoteeriri riyoperote. Omaanta aririka ithonkakiro rishitooryataperotaki, aritaki ikimitakotanakyaari iyoteeriri. ");
INSERT INTO cjoNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","¿Iitaka pikijawenantariri pisheninka rantayitzirini? Piyotakotawakyaata eerori aamaashitya eerokarika maperotakirori kaari kameethatatsi, eeniro osheki pantani. Okimitaka pikantawitakaririra pisheninka: “Otyaakyaatakimi opaneki kipatsi”, omaanta eerori, eeniro tyaakyaatakimiri antawo inchapanki, konompyaatoteencharira pokiki. ");
INSERT INTO cjoNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Okameethatzima pikanteri: “Ajaatya, nosheninka, nagaemiro pityaakyaawo”. Tema piyotakotya eenitatsi inchapanki otzikaakimiri eerori pokikira. ¿Tsika pikantyaaka paanteeyaanariri ityaakyaawo pisheninka? ¡Pamatawitantaki! Pikowawitaka pikimitakotyaarimi kameethaperotzinkari. Ñaakiro, pityaawo pookiro eerori antawowa inchapanki konompyaatoteencharira pokikira, roojatzi paminaperotaneerika, ari pamitakoteri pagaeniri ityaakyaawowa pisheninka rokikira rirori. ");
INSERT INTO cjoNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Eenitatsi paashini roshiyakaawentakiniriri Jesoshi, ikantakiri: —Aririka okameethate inchato, eejatzi okimitzitaka okithoki roori okameethataki. Rooma teerika okameethatzi inchato, eejatzi okimitzitaka okithoki roori tee okameethatzi. ");
INSERT INTO cjoNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Aririka añeero okithoki inchato ayotzi tsika okantari inchato roori. Tema rootaki ayoteeyantaworini inchato rooperori, aririka okameethate okithoki. Aririka pikowaki pithote chochoki, ¿arima piyaataki janta kawanaki? Eero piyaatzi, tema piyotakiro tee okithokitantawo komashiki kawana; eejatzi okimitzita tsikontochee eero okithokitziro oowa. ");
INSERT INTO cjoNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Aririka akenkithashireero kameethatatsiri, akenkithatayiteroni kameethatayitatsirini. Aririka akenkithashireero kaari kameethatatsi, akenkithatakotayiteroni kaari kameethatatsi. Tema añaawaetantakityaawo akenkithashiryaayitarini. ");
INSERT INTO cjoNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Eekiro riyaatatyee ikantakiri Jesoshi: —¿Iitaka pikantashiwaetantanari: “Nowinkatharite”? Tee pikemijantaperotana. ");
INSERT INTO cjoNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Iroñaaka noshiyakaawentemiri tsika ikantari aapatziyanari. Ikemawakiro noñaani, ikemijantaperotanakiro: ranteeyakironi maawaeni nokantakiriri. ");
INSERT INTO cjoNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ikimitakarini atziri wetsikirori ipanko. Ikiyashiperotakiro inthomaenta, royaankakiro tzinkamintsipanke ityaakitakotakiro kameetha, kijoperotanaki. Okantaka opariyaperotaki inkani roojatzi amaanitantapaaka iñaa. Otatsinkawitapaakawo antawo amaani, omaanta tee aawiyiro: rooma kijoperotaki kameetha tzinkamintsipanke. ");
INSERT INTO cjoNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Omaanta riraga kaari kemijantaperotanari ikimitakari shirampari wetsikawitachari ipanko, tee ikiyashitaperotziro inthomaenta, eejatzi tee ityaakitakoperotziro kameetha. Okantaka osheki amaanitapaaki iñaa roojatzi otyaantanakawo ipanko ayitanakiri, tee añagaero. Rootaki ikanteeyakiririni Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Eejatzi ipiyanaa Jesoshi janta Kaperinawooki. ");
INSERT INTO cjoNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Janta nampitsiki ari ijeeki kapitaano. Rirotaki oroomajatzi, kaari joriiyo. Ikantaka imantsiyataki ronampiri, roowiteencha ikamemi. Riraga kapitaano osheki inintaperotziri ronampiri. ");
INSERT INTO cjoNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ikemakotakiri Jesoshi itajonkantaki, roojatzi rotyaanantakariri aataperoteenchari joriiyopaeni ikantakiri: —Pikamantakiteri Jesoshi ipokanakiita jaka retsiyatakotakitenari nonampiri. ");
INSERT INTO cjoNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Ikantaka rareeteeyapaakarini, ikantaperoeyapaakirini: —Piyaatashiteri. Ikameethaperotzi riraga kapitaanonta, osheki ininteeyakaeni aaka joriiyopaeni. Riwetsikakaantakaeniro pankotsi apiyotantapiintyaari. Okameethatzi petsiyatakoteniri ronampiri. ");
INSERT INTO cjoNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","7","Roojatzi royaateeyanakirini. Okaakitapaaki inampi, itonkiyotawakari paashini rotyaantanewo kapitaano. Ikamantapaakiri, ikantziri: —Eenitatsi iroka ikantakiri nowapitaanote: “Nopinkathataperotakimi, rootaki kaari niyaatanta notonkiyotemi. Rooma naaka tee nokameethatzi, rootaki kaari nokowanta pipoke nopankokika. Niyotaki pikowakirika petsiyatakoteri nonampiri, aritaki retsiyatakotee. ");
INSERT INTO cjoNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Eejatzi naari eenitatsi kantanari oetarika nanteri, eejatzi nokimitzita naari nojoraarote eenitatsi nomperateeyakarini. Nokanteririka joraaro: ‘Piyaate’, ari riyaatanaki. Nokanteririka: ‘Pipoke’, ari ipokanaki. Eejatzi nokimitziri nonampiri rirori, aririka nokanteri: ‘Iroka panteri’, ari rantakiro”. ");
INSERT INTO cjoNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ikemantawakawori Jesoshi okaatzi ikantakaantawakiriri, ari rotsikanatanakari. Roojatzi ipithokashiteeyantanakarini oyaateeyakiririni, ikanteeyanakirini: —¿Pikemakiroma iroka ikantakirika riraga oroomajatzi? Tekatsi noñe nojoriiyotzinkarite apaani kimitakotyaarini rirori: osheki rameentakina. ");
INSERT INTO cjoNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Roojatzi ipiyanteeyanaani rotyaantanewo kapitaano ipankoki. Iñaapaatziiri ronampiri, etsiyatakotanee. ");
INSERT INTO cjoNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Paashini kitejiri riyaatanaki riraga Jesoshi janta Nayiiki, itsipateeyakarini ronampiripaeni eejatzi osheki paashini oyaateeyiririni. ");
INSERT INTO cjoNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Rokaakinteeyapaakawoni nampitsi, roonthaakowentakari inatakoetapaakiri kaminkari, ikitateeterimi. Rinirowa kamaki roori oemi, eejatzi apintzite otomi tekatsi paashini. Oyaatakowentakiri otomini, otsipateeyarini osheki onampijatzi. ");
INSERT INTO cjoNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Iñaantawakawori Awinkatharite, osheki retakotawakawo, ikantawakiro: —Eero piraakotari pitomi. ");
INSERT INTO cjoNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Riyaatashitakiro kajo inatakotanteetakariri, ipampitapaakiro. Ikatziyakaapaakari natakotziriri. Ikantakiri Jesoshi kamaentsiri: —Ewankari, pipiriintee. ");
INSERT INTO cjoNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Roojatzi ipiriinantanaa, ikotyaatanaka; ñaawaetanee. Roojatzi ikanantawo riniro: —Irika pitomika añaanee. ");
INSERT INTO cjoNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Rotsikanateeyanakawoni atziripaeni iñaanteeyawakawoni, ithaawaeyanakini, ikanteeyanakini: —Tema ikameethaperotaki Tajorentsi. Rotyaantakaeniri kamanantzirorini iñaani. Kyaaryo, itajonkawentakae, ikaminthagaeyirini aapatziyeeyaririni. ");
INSERT INTO cjoNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Roojatzi ikemakoeyantakaririni maawaeni joreeyajatzi, eejatzi othotyaanaka ñaagantsi paashinikipaeni nampitsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ikanta ikemakotakiri riraga Jesoshi riyotaanewopaeni Jowa, riraga kaawoshitakotziniriri Tajorentsi. Riyaatashiiyakirini, ikamantapaakiri rantayitakirini rirori. Riraga Jowa, ikaemakiri riyotaanewo apite. ");
INSERT INTO cjoNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Roojatzi rotyaantakiri Awinkathariteki, ikantawakiri: —Piyaatakite Jesoshiki, pojampitakiteri pikanteri: “¿Eerokama Rotyaantanewo Tajorentsi naamagaeyakarini? ¿Eeniroma paashini naamagaeyaarini?” ");
INSERT INTO cjoNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ikanta rareeteeyapaakarini rirori, ikantapaakiri: —Rotyaantakina riraga Jowa, ikantana: “Pojampitakiteri Jesoshi: ‘¿Eerokama Rotyaantanewo Tajorentsi naamagaeyakarini? ¿Eeniroma paashini naamagaeyaarini?’ ” ");
INSERT INTO cjoNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Omaanta tee rakawakiri rirori, inta rantzi retsiyatakotayitzirini osheki mantsiyatayitatsirini, eejatzi rowawijaakotayitakirini osheki kyaantariri kamaari rajankaneki. Eejatzi raminakaayiteerini osheki kaari kokichaatatsini. ");
INSERT INTO cjoNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Roojatzi ikantakiri riroripaeni: —Iroñaaka pipiyanee pikamantapaeri Jowa okaatzira pikemakinari eejatzi piñaakotakinari nantziri. Pikamantapaeri naminakagaeyakirini riraga kaari kokichaawitacharini, nokatziyatziyatakagaeyakarini riraga kijopookiwitacharipaeni, netsiyatakotakagaeyakirini riraga pathaawitacharipaeni, nokemakagaeyakirini riraga amashitachari inthomaenta ikempita eejatzi nopiriintayitaneerini kamawiteencharipaeni. Eejatzi niyotakagaeyakirini owashironkaawitacharipaeni tsika ikantya rowawijaakotanteeyaariri riraga Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Riweshiryaakaanakimi maawaeni kaari theenkanari naaka. ");
INSERT INTO cjoNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ikanta ipiyeeyanaani riraga rotyaantanewo Jowa, omaanta eeniro ijeekanaki Jesoshi ikenkithatakagaeyanakirini piyotawentakariri. Ikenkithatakotanakiri riraga Jowa, ikanteeyanakirini: —Paerani piyaatapiintzi janta tekatsinta atziri ipanko pikemijantapiintziri rirori. ¿Iitaka piyaatashiteeyantakitaririni? ¿Rootakima piyaatashitantariri pikemijanteri ñaawaetashitachari? Tee iñaawaetashita. ");
INSERT INTO cjoNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Iitaka piyaatashitantaperotariri piñeeri? ¿Piyaatashitantakitariri piñaakitzirima atziri kithaatawori owaneenkatachari kithaarentsi pinaperotachari? Teewee. Pamine, riraga kithaatawori owaneenkatachari isheninkatakari pinkathari, riweshiryaawentawo rowaagawo jeekatsiri ipankoki pinkathari. Omaanta riraga Jowa tee ikimitakotari rirori. ");
INSERT INTO cjoNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ajaatya, pikamantena: ¿iitaka piyaatashitakitziri? ¿Riroma piitziri kamanantzirori iñaani Tajorentsi piyaatashitantakitariri? Tema kyaaryo ikamanantziro, omaanta ranaakoperoeyakirini paashinipaeni kamanantzirori iñaani Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Tema piyoteeyironi riraga Tajorentsi ikenkithatakotzitakarini rirori Iwaperiteki paerani, ikantzitakinari: “Notyomi, notyaanteri iinja jewatemini ikenkithatakaapaakiri joriiyopaeni, ikanteri: ‘Pikenkithashireeyaani, pijeeki kameetha, eero pantziro paashini kaari kameethatatsi, paamayari Awinkatharite, kaakitaki’ ”. Kyaaryo, rirotaki riraga Jowa Kaawoshitantatsiri ojankinatakotziteetakariri paerani. ");
INSERT INTO cjoNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Tema ranaakoeyakirini irira maawaeni paashinipaeni kamanantatsiri: imatakiro maawaeni ikowakaakiriri Tajorentsi, rootaki iñaaperotantakariri irira ikameethatzi. Omaanta iñaaperotaperotakiri kameetha Tajorentsi maawaeni ipinkathariwentaperoeyirini. ");
INSERT INTO cjoNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ikanta ikemaeyakirini osheki atziri ikantakiriri Jesoshi. Ikemantakariri, ikanteeyanakini: —Kyaaryo, tema ikameethaperotaki Tajorentsi. Eejatzi ikaateeyakirini kemaeyakiririni riraga piyotayitziririni iyorikite eekiro iperi oroomajatzi, tema ikaawoshitakotayitawakinirini Tajorentsi Jowa chapinki. ");
INSERT INTO cjoNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Omaantakya riraga warijeeyopaeni eejatzi riraga iyotaantayitzirorini Iwaperite Tajorentsi tee ikowaeyini ranteniri rirori ikowakaawitariri: tema tee riyaatashitziri Jowa ikaawoshitakotantyaariri rirori. Eejatzi tee inimotziri ikantawitariri Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ikantzi eejatzi: —¿Iitaka noshiyakaawenteniriri irikapaeni kaari raapatziyantana? Tee ikoyi ikenkithashiryaaneentya. ¿Iitaka ikimitakari? ");
INSERT INTO cjoNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Irira noshiyakaawenteeyerini eentsi, ñaathawaeteeyacharini pankotsiki okaankiityeera. Ipoñaanaka apaani ikantanakiri: “Apaniroeni nojonkawaetawita omaanta tee poyaatana, tee pomampaawaeta. Nowashiretakotawitari kamaentsiri, omaanta eeroka tee pitsipateeyanani powashiretakoeyaarini”. ");
INSERT INTO cjoNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ñaakiro, riraga Jowa itzitapiintaka, tee ririro kachaja eejatzi paashini shinchaari, eekiro pikanteeyatziini: “Eenitatsi iyamaarite pinkakaakiriri, rootaki kaari rowaperotanta, eejatzi kaari rirantawo shinchaari”. ");
INSERT INTO cjoNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Omaanta naaka nopoñaaka janta jenokinta, nokoñaatapaaki jaka kipatsikika, roojatzi nowapiintawita eejatzi nirapiintawita. Omaanta eekiro pikanteeyatziini: “Irinta owaagatzinkari, shinkitzinkari. Itsipatapiinteeyakarini piyotapiintziniriri oroomajatzi iyorikite, eejatzi itsipatapiinteeyakarini paashinipaeni kaari kameethatatsini”. ");
INSERT INTO cjoNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Omaanta nokantemi: “Riyotzi Tajorentsi ari okameethataki maawaeni ikowakaakinari; eejatzi maawaeni aapatziyanari, riyotaki okameethataki ikowakaakinari Pawa”. ");
INSERT INTO cjoNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ikanta apaani warijeeyo iwaero Shimo, ikantakiri Jesoshi: —Pipoke nopankoki, owaeyaani. Rakanakiri: —Jee, kaakitakina. Ikanta riyaateeyanakini, ijeekapaaki jeekamentotsiki. ");
INSERT INTO cjoNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ari ojeeki tsinani jaka nampitsiki antapiintawitawori kaari kameethatatsi. Okemakotakiri Jesoshi, rowatya jaga ipankokinta warijeeyo, iyaatashitakiri oñaakiteri. Aakotanakiniri kajankaari. Ro aakotantanakanari mapi kitamaari imokaetziri. ");
INSERT INTO cjoNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ojeekimotapaakiri okaakini iitziki Jesoshi. Iraaperotapaaka, opitenkantakari oyaaki iitzikira, oshetantanaari oeshi. Roojatzi othoyitzitanakiri iitzi, eejatzi ojeetantakari kajankaari iitziki. ");
INSERT INTO cjoNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Iñaantawakawori riraga warijeeyo, ikenkithashiryaanaka: “Rirotakima Rotyaantanewo Tajorentsi, ari riyotawakiromi iroka tsinanika opampitakiri, eejatzi eeromi ishinetawomi opampiterimi iitziki”. Tema osheki antapiintziro kaari kameethatatsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Omaanta riyotakiri Jesoshi okaatzi ikenkithashiryaakari, ikantakiri: —Shimo, eenitatsi nokantemiri. Rakanakiri: —Ajaatya, iyotaanari, pikantenatya. ");
INSERT INTO cjoNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","—Noshiyakaawentemiri. Eenitatsi shirampari ikaatzi apite ireewitziriri. Apaani rireewitziri 500 tenaaryo, paashini rireewitziri 50 tenaaryo. ");
INSERT INTO cjoNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Irika apiteka atziri ireewitantatsiri tee imatziro ipinakowenteeya ireewitantatsiri. Ikantaka riraga rireewiteetziri iñaakirira tee imatziro ipinateeri, rootaki ikanantakariri: “Iroñaaka nokoyi netakotemi, eero pipinataana pireewiwitanaga, ikaanteekaata. Apaani rireewitawitakari eechonkiini, omaanta riraga paashini rireewitaperotawitakari. Pikantena: ¿ninka inintaperoetanakirika ashitariri iyorikite?” ");
INSERT INTO cjoNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Rakanakiri: —Naamaashitya riraga ireewitaperotawitakariri, tema rirotaki ikaminthaaperotakiri kameetha. Ikantanakiri: —Kyaaryo okaatzi pikantakinari. ");
INSERT INTO cjoNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Roojatzi raminantanakawo Jesoshi tsinani, ikantziri Shimo: —Ñaakiro, inkaaganki nokyaapaaki jaka pipankokika, omaanta tee paakameethatawakina: tema tee pipawakina iñaa nokiwantapaakyaaworimi noetzi. Omaanta tsinanika, okiwantapaakinawo oyaaki noetziki, eejatzi oshetantakinawo oeshi. ");
INSERT INTO cjoNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Piwethatantanari, tee pithowootana, omaanta roori, onintanintaatakiro noetzi. ");
INSERT INTO cjoNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Tee pijeetantanawo noetoki iyeenka, omaanta iroka, ojeetantakinawo noetziki kajankaari. ");
INSERT INTO cjoNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Pamine, eeniro antayitawitakarini osheki kaari kameethatatsi omaanta nokaminthaakiro, eero nokenkithashiryaakoteero antayitzirini: tema rootaki onintaperotantakinari. Aririka nokaminthayeri antayitawitaworini eechonkiini, eechonkiini inintashiretakina rirori. Omaanta nokaminthaaperoteririka osheki eejatzi inintaperotzitena osheki rirori. ");
INSERT INTO cjoNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Roojatzi ikantawakiro tsinani: —Eeniro pantayitawitakarini, omaanta eero nokijantzimiro, eero nokenkithashiryaakoteemiro eejatzi. ");
INSERT INTO cjoNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Eeniro ijeekaeyakini owaeyeencharini, rojampitawakagaeyanakani: —¿Tsikama iitatyaarika irika, ipeyakotakaantakanawori antzirori kaari kameethatatsi? ");
INSERT INTO cjoNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Omaanta Jesoshi eekiro riyaatatzi ikantziro roori: —Pameentakina, rootaki pawijakotantaari. Piyaatee kameetha, piweshiryaaperotaneeya. ");
INSERT INTO cjoNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Roojatzi Jesoshi ikinakinayitanakini nampitsikipaeni. Ikenkithatakagaeyakirini atziri, ikamanteeyakirini: —Rooteentsi ipinkathariwenteeyemini Tajorentsi. Kijokiro rowakiri riyotaanewopaeni, ikaatzira 12, ");
INSERT INTO cjoNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","eejatzi oyaateeyakirini tsinanipaeni. Tema apaanipaeni roori ikyaantawitakawo kamaari, eejatzi paashinipaeni omantsiyatashitawitaka omaanta retsiyatakoeyeeroni Jesoshi. Owaero apaani tsinani Mariiya makaraarajato. Ikaatawita kamaari jeekantawitawori 7. ");
INSERT INTO cjoNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Eejatzi paashini oyaatziriri, owaero Jowaana, iina Kooja. Riraga Kooja, rirotaki amitakotziriri pinkathari Erooreshi. Eejatzi oyaatakiri Sosaana, eejatzi paashinipaeni tsinani. Iroka tsinanipaeni amitakopiinteeyakirini Jesoshi, opapiinteeyakirini koetyeemotakariri. ");
INSERT INTO cjoNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ipiyotawenteeyakarini Jesoshi oshekini atziri, roojatzi roshiyakaawenteeyakinirini ookayitzirorini okithoki teriiko, ikanteeyakirini: ");
INSERT INTO cjoNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Riyaataki shirampari rookakitziro okithoki teriiko owantsiki. Apaanipaeni pariyapaentsiri awotsiki: raatzikayitakironi anashitayitacharini, ikanta ipokaeyapaakini konthawopaeni rowaeyapaakawoni, ithonkapaakiro pariyapaentsiri. ");
INSERT INTO cjoNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Paashinipaeni pariyapaentsiri mapimashiki. Oparithawitanaka eechonkiini, omaanta tee ashepathatakoperotzi, rootaki ojampishitantanakari, intsipaete okamaeyanakini. ");
INSERT INTO cjoNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Paashini okithoki opariyapaaki kitocheemashiki: oshookawitanaka, omaanta anaanakiro kitocheepaeni, rootaki okamantanakari. ");
INSERT INTO cjoNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Omaanta paashini opariyapaaki kameethariki kipatsi: oshookanaki kameetha, okithokitaperotanaki osheki. Rootaki roshiyakaawenteeyakiniririni. Roojatzi ishintsithatanakiro ipaante, ikanteeyanakirini: —Eenitatsirika pikempita pikemantari, powayempitaperotyaawo iroka nokantakimirika. ");
INSERT INTO cjoNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Rojampiteeyakirini riyotaanewopaeni: —¿Oetaka kantakotachari poshiyakaawentziri inkaaganki? ");
INSERT INTO cjoNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Rakanakiri: —Eerokataki aapatziyariri Tajorentsi, rootaki ikowakaantakimiri irira piyoteeyeroni eeroka kaari riyoteeyini paashinipaeni atziri kaari aapatziyariri. Eeroka niyotakaakimi tsika ikanta Pawa ipinkathariwenteeyakimini. Omaanta noshiyakaawenteeyakinirini paashinipaeni: ramineeyawityaani irirapaeni, omaanta eero riyotakoperotziro oetarika iñaawityaari; ikemaeyawityaani, omaanta eero riyotakotziro ikemaeyawitakarini. ");
INSERT INTO cjoNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Rootaki iroka noshiyakaawentzimiri: rowaga okithoki oshiyakaawentzirori iñaani Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Iroka awotsi opariyantawitapaakari okithoki oshiyakaawentziri kemaeyawitawakaworini iñaani Tajorentsi: ipokapaaki kamaari, rookakagaeri ikenkithashiryaawitakawowa iñaani Tajorentsi. Tee ikowakayiri raapatziyari eejatzi rawijakote. ");
INSERT INTO cjoNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Rowaga mapipookiteentsiri opariyantawitapaakari okithoki, oshiyakaawentakiri atziri weshiryaawentawitanakawori iñaani Tajorentsi, inimotawitakari. Omaanta tee ikyaaryoowentziro: aririka opomeentsitzimotakari raapatziyari, roojatzi rookantaneeyawo. ");
INSERT INTO cjoNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Iroka kitocheemashi opariyantawitapaakari, oshiyakaawentakiri kemaeyawitakaworini iñaani Tajorentsi, omaanta ikenkithashiryaapiintziro rantapiintziri, iweshiryaawentawo owaagawontsipaeni, eejatzi ikowaki ikimoshirewentashityaawo oetarikapaeni kaari kameethatatsi. Ratsipetashitakawo ikemawitawo iñaani Tajorentsi: tee raapatziyawo kameetha, tee rantaperotziniri rirori ikowakaawitariri. ");
INSERT INTO cjoNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Omaanta iroka okameethatzi kipatsi oshiyakaawentziri atziri kemaperotawakirori iñaani Tajorentsi. Ikyaaryoowentaperotanakiro kameetha raapatziyaperotanakawo, ikameethashiryaanaki rajankaneki. Rirotaki antaperotzirori maawaeni ikowakaakiriri Tajorentsi. Tema riyotaakiri paashinipaeni iñaani Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Eenitatsi paashini roshiyakaawentakiniriri Jesoshi riyotaanewo, ikanteeyakirini: —Aririka oonthoteri ootamentotsi amineeyantyaarini, ¿arima ataapatakotakiri kantziriki? ¿Arima amanakiri tsikarika? Okameethatzi owakoteri jeñokiini okoñaatantyaari oetarikapaeni. Rootaki imatantapaakyaawori kyaapaentsirira iñaapaakiro oetarikapaeni jeekatsiri inthomaenta. ");
INSERT INTO cjoNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Okimitaka iroka iinja okoñaatanaki maawaeni amanayitawitarini iroñaaka riyoteeyanakironi maawaeni okaatzi anteeyakirini. ");
INSERT INTO cjoNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Paamayawowa okameethatzi pikemaperoeyawakinani piyoteeyanteeyarini. Eechonkiini piyotaki iroñaaka, omaanta aririka pikemaperotena, nothotyeeyemironi niyotakaaperoeyemini. Aririka piitakaashiwita piyotzi, eero pimatziro paapatziyawo niyotaawitakimirika, eejatzi ari pipeyakotakiro okaatzi piyotawitari eechonkiini: tekatsi piyotzimaetaneeya. ");
INSERT INTO cjoNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Okantaka iyaatashitantanakari Jesoshi riniro, otsipateeyanakarini rirentzipaeni. Rareeteeyapaakani pankotsiki janta ijeekakinta rirori, omaanta tekatsi ikantapaakya rontsirokaeyapaakyaarini: rookagaeyakirini oshekipaeni atziri. ");
INSERT INTO cjoNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ikamanteetakiri Jesoshi: —Okowapaakimi piniro, eejatzi pirentzipaeni. Ojeekapaaki janta inkokironta. ");
INSERT INTO cjoNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Omaanta rakanakiri: —Ninirontakawo maawaeni aapatziyaperoeyakaririni Tajorentsi, maawaeni antaperotziniriri ikowakaakirori. Eejatzi maawaeni aapatziyariri riroteeyakini yeeyipaeni, choenipaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Paashini kitejiri rotetanaka Jesoshi pitotsiki, itsipateeyakarini riyotaanewopaeni. Ikantakiri: —Thame amontyagaeyaneeni intatsikeronta inkaare. ");
INSERT INTO cjoNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ikantaka riyaatakoeyawitanakani, aakotanakiri tampyaa. Jatakotaki niyankyaani, ari janta opataki pitotsi imaanaki Jesoshi. Roojatzi omapokaeyakirini antawo tampyaa, otetaatapaakawo iñaa pitotsiki, rooteentsi itsitsiyakoeyenimi. ");
INSERT INTO cjoNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Roojatzi ikaakantanakari riyotaanewopaeni ikantakiri: —¡Iyotaanari! ¡Pipiriinte! ¡Rooteentsiwee atsitsiyakoteeyeni! Ari itzinaanaka, roojatzi rojantzikaantakawo tampyaa, ipeyeero omoetonkaari: opeyaperotanaa kameetha. ");
INSERT INTO cjoNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ikantziri riyotaanewo: —¿Iitaka kaari pameenteeyantanani? Ithaawanteeyanakarini, eejatzi rotsikanateeyanakarini. Ikantawakagaeyanakani: —¿Ninkama irika? Omaerintakirori tampyaa, eejatzi omoetonkaari: ipeyeero. Tee añaapiintziri kimityaarini irika. ");
INSERT INTO cjoNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ipoñaanaka Jesoshi Karireeyaki, roojatzi rareetapaaka intatsikeronta: janta Karaaraki. ");
INSERT INTO cjoNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Raatakotapaaka, rayiiteeyapaakini kipatsiki. Iñaapaakiri atziri kyaantawitariri kamaari: ojamanitaki ijeekamerikitzi tee ikithataawo iithaari. Tee ijeeki pankotsiki, inta ikinakinamerikitzi janta kaminkarimashiki. ");
INSERT INTO cjoNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Iñaantawakariri Jesoshi, rotziwerowashitawakari, roojatzi icheraakaantanakari iyamaarite ipaantekira shirampari, ikantakiri: —¿Iitaka poñaashirenkantanari? Niyotawakimi: eerokataki Itomi Tajorentsipero jeekatsiri jenokinta. Eero powashironkaana. ");
INSERT INTO cjoNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Rootaki ikaemantanakari, ithaawantawakari Jesoshi, riyotaki kamaari rotyaantatyeeri. Riraga shirampari ojamanitaki ijeekantakari kamaari, ikinakaapiintziri tsikarikapaeni. Roojotapiinteetawitari rakoki eejatzi iitziki karenathaki, omaanta osheki ishintsitakaakiri kamaari, ithatyaakiro karenatha roojotanteetayitaririni. Aririka ithatyaanakiro, ishiyakaanakari kamaari janta teenta ijeeki atziri. ");
INSERT INTO cjoNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Rojampitakiri Jesoshi: —¿Oetaka piwaero? Rakanakiri: —Nowaero Oshekyaantzi. Rootaki iitantakari Oshekyaantzi ijeekantakari inthomaenta oshekini kamaari. ");
INSERT INTO cjoNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","32","Ari ijeeki janta tyonkaarikiini osheki chaancho rowaeyani. Riraga kamaari ikanteeyakirini Jesoshi: —Eero potyaanteeyanani jaawikinta otsitenikaakitzinta inta nokowaki potyaanteeyenani janta chaanchoki, nokyaantapaakyaari rirori. Ikantanakiri: —Piyaateeyeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Roojatzi rookaeyantanaarini shirampari, ishirinkashitanakari chaanchopaeni, roojatzi ishiyeeyantanakani riroripaeni ipariyeeyanakini impeetaki, ipiinkaeyapaakini inkaareki, motoririri, motoririri. Tsitsiyeeyapaakini maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Riraga shentawitariri chaancho iñaantawakariri, ishiyeeyanakani janta nampitsiki ikamanteeyerini isheninka eejatzi jeekaeyatsirini owantsiki. ");
INSERT INTO cjoNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Roojatzi ipokaeyantanakani atziri ramineri riraga kyaantawitakariri kamaari, oetarika awijimotakiriri. Iñaapaatziiri, tekatsitanee, tee ishinkiwentanaa, ijeekae kameetha Jesoshiki. Ikithaataawo imaatha, kenkithashiryaaperotanaa kameetha iroñaaka. Ithaawanteeyapaakarini. ");
INSERT INTO cjoNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Riraga ñaaperotakiriri ikamanteeyawakirini maawaeni inampijatzi okaatzi rantakiri Jesoshi, ithotyaawakiniri. ");
INSERT INTO cjoNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Osheki ithaawaeyanakini maawaeni nampitawori jaga. Rotyaanteeyeerini Jesoshi, ikantziri: —Piyaatee, eero pipokae eejatzi. ");
INSERT INTO cjoNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Omaantakya riraga kyaantawitakariri kamaari ikantawitakari Jesoshi: —Nokowaki noyaataneemi. Omaanta ikantziri: ");
INSERT INTO cjoNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Eero poyaatana. Aritaki pijeeki, piyaatee pipankoki. Pikamanteeyapaerini pinampijatzipaeni ikaminthaakimiri Tajorentsi. Roojatzi riyaatantanaa, ikinakinayitanakini nampitsiki, ikamanteeyakirini inampijatzipaeni: —Piñaakina: osheki ikaminthagaana Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Roojatzi ipiyantanaa Jesoshi, imontyaanaawo inkaare. Royagaeyakirini osheki atziri, raakameethateeyawaerini. ");
INSERT INTO cjoNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Itonkiyotawakari shirampari iitachari Jaero: rirotaki jewatakaantatsiri janta pankotsiki ipiyotantapiintarira joriiyopaeni. Rotziwerowashitapaakari iitziki Jesoshi ipinkathatantapaakariri, ikantapaakiri: —Thame nopankoki, rooteentsi okame nishintyo. Apinto rishinto, okaataki ojarentsite 12. Roojatzi royaatanakiri, rawitsinagaeyanakirini oyaateeyanakiririni. ");
INSERT INTO cjoNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Oyaatanakiri eejatzi tsinani ojokaatzirori iraa, okaatakotaki 12 ojarentsite ojokaatakiro. Osheki raawintawitakawo; othonkakiri oorikite aawintakaanantari. Omaanta tekatsi materoni etsiyatakoteroni. ");
INSERT INTO cjoNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Okinashitapaakiri itapiiki opampitzitakiri iithaari okaatapaakira, roojatzi opeyantanaa iraa. ");
INSERT INTO cjoNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Roojatzi ikantanaki Jesoshi: —¿Ninka pampitzitakinawori noethaari? Ikanteeyanakini paashinipaeni: —Tee nopampitzitzimiro piithaari. Roojatzi ikantanakiri Peetero: —Iyotaanari, pamine, ikaateeyini atziri osheki rinkiteeyakimini, rawitsineeyakimini. Eekiro pikantanakitzi: “¿Ninka pampitzitakinawori noethaari?” ");
INSERT INTO cjoNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Omaanta royiikiitakari rirori: —Eenitatsi pampitzitakinawori. Okamantakina notajorenka: eenitatsi notajonkakowenteri. ");
INSERT INTO cjoNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Iyotanaki tsinani tekatsi okantya omanapithateri opampitzitakirira iithaari. Ompetatanaka, iyaatashitanakiri, otziwerowashitapaakari, okantapaakiri: —Naakataki antzitakimirori piithaari, rootaki netsiyatakotantaari nojokaawitawoni niraa. Ikemaeyawakironi maawaeni atziripaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ikantakiro Jesoshi: —Tsinani, pameentakina, rootaki petsiyatakotantaari. Piyaatanee kameetha pipankoki, pikimoshiretanee. ");
INSERT INTO cjoNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Eenirowa ikenkithawaetakayiro tsinani, areetapaaka paashini ikaateeyinira ijeeki Jaero ikamantapaakiri: —Kamanaki pishinto. Eero poñaashirenkantari iroñaaka iyotaantatsiri riyaate apankoki. ");
INSERT INTO cjoNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ikemawakiri Jesoshi, roojatzi ikanantanakari: —Eero pikantashiryaa. Aririka pameentena, ari añaagae pishinto. ");
INSERT INTO cjoNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ari rareeteeyapaakani pankotsiki. Ikantzi Jesoshi: —Eero eeroka pikyeeyapaeni: intakya rirori kyaatsini Peetero, Jowa, Jantyaako, iri, eejatzi iniro, ari ikaate. ");
INSERT INTO cjoNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Eeniro riraakoeyakawoni osheninkapaeni, rowashiretakoeyakawoni. Ikanteeyakirini Jesoshi: —Eero piraakoeyawoni: tee okamaperotzi, inta omaatzi. ");
INSERT INTO cjoNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ishirontawenteeyanakarini, tema riyoteeyakini kamaperotaki. ");
INSERT INTO cjoNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Roojatzi roerikawakotapaakiro, ishintsithatapaakiro ipaante, ikantzi: —¡Ewankawo, pipiriintanee! ");
INSERT INTO cjoNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Roojatzi opiriinantanaa. Ikantakiro iniro: —Pipero owanawo oyaata. ");
INSERT INTO cjoNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ashitaanitachari ari rotsikanatanakari ikantanaki: —¡Pamine! ¡Imatakiro ipiriintziro kaminkawo! Omaanta ikantakiri Jesoshi: —Eerowa pikamantakowaetana iroñaaka okaatzika piñaakiri. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ipiyoteeyakirini Jesoshi riyotaanewo 12, imatakagaeyakirini itajorenkaki, itajonkakowenantyaariri paashinipaeni, ikanteeyakirini: —Nokowaki pookakaakowenteeyerini atziri kyaantawitariri iyamaarite, pimateri pookeri maawaeni kamaaripaeni, eejatzi petsiyatakoeyerini maawaeni mantsiyatayitatsirini. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Iroñaaka piyaateeyeni. Pikinakinayitanakini, pikamanteeyerini atziri: “Rooteentsi ipinkathariwenteeyemini Tajorentsi”. Eejatzi petsiyatakotayiterini mantsiyayitatsirinipaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Nokantemi, tekatsi paanaki: eero payi paashini pimaatha, pikotzi, pithaate, powanawo, piyorikite, pipewiryaakogo, apatziro pikithaatakarika. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ninkarika aakameethatawakimini ari pijeekapaaki. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Eerorika raakameethateeyawakimini jeekatsiripaeni, powaaganakya, eejatzi potekakontatanakya piitzikira riyotantyaari eero pipiyashitari eejatzi. Pikanteeyanakirini: “Iroñaaka tee pikemijantana, ari rowashironkaemi Tajorentsi iinja”. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Roojatzi riyaatanteeyanakani, ikinayitanakini nampitsikipaeni. Ikamanteeyakirini atziri tsika ikanteeyaka rawijakotanteeyaari. Eejatzi retsiyatakotayiteerini mantsiyatayitatsirini. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ikanta riraga pinkathari Erooreshi ikemakotakiri rantayitakirini Jesoshi, itajonkantayitakini. Tee riyotzi oetarika ikenkithashireeyaari. Ikanteetayitzini: “Irira Jesoshitatsiri rirotaki Jowani: piriintaachari”. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ikantayitzini paashinipaeni: “Roñaagantapaa eejatzi Iriiyashi”. Paashini kantayitatsirini: “Piriintaa paashini kamanantzirorini iñaani Tajorentsi”. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Omaanta ikantzi Erooreshi: —Nothatyaakaantakiri Jowani: kamataaki. Omaanta, ¿ninka irika akemakoeyakirini itajonkakowenteeyakirini atziripaeni? Nokowaki noñeeri. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ikanta ipiyeeyanaani rotyaantanewo Jesoshi, ikamanteeyapaerini rantayitakirini. Rothatagaeyaneerini ragaeyaneerini riyotaanewopaeni janta Wetheeraki. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Omaanta riyoteeyakini atziri jatanaki, roojatzi royaateeyantanakarini. Riraga Jesoshi riwethateeyawakarini riyotagaeyakirini tsika ikanta Tajorentsi ipinkathariwenteeyakirini. Eejatzi retsiyatakoeyakirini mantsiyaripaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Okantaka otsiteniityaanaki, ipokashitapaakiri riyotaanewopaeni, ikanteeyapaakirini: —Paminerotya, kaankiityaaki jaka. Potyaanteeyerini atziri iroñaaka nampitsikipaeni: raminantyaari imagaeyantyaarini eejatzi rowaeyantyaarini. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Omaanta ikantawakiri: —Pipaeyerini eeroka rowaeyaarini. Ikantanaki: —Tekatsi nopaeyeririni. Pamine, okaataki jaka paa apawakooni, eejatzi apite mereto. ¿Pikowakima niyaateeyeni namanantakiteniri rowaeyaarini maawaeni irikapaeni? Eenitatsi oshekini atziri. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Aamaashitya ikaateeyini shirampari 5.000 ipiyoteeyakani. Ikantziri Jesoshi: —Poejeekaeyerini maawaeni: pinashitayityaarini ikaatayiteni 50 piyotachani, eejatzi paashinipaeni ikaate 50. Eejatzi ikimiteeyakyaani maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ari ikanteeyakirini, roejeekaeyakirini. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Roojatzi roerikantakawo Jesoshi paa, eejatzi mereto. Raminanaki jenokinta, ikantziri Iriri: “Ariwee, Pawa, pipakinawo nowanawo”. Roojatzi ipantakari riyotaanewo, ikantakiri: —Ajaa, poshirinkeniri riraga piyoteeyeencharinira. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Rowaeyakani maawaeni, ikemaeyapaakani. Roojatzi raantayitaawoni tzimagaantapaentsiri, roteteero kantziriki. Okaatzi riyeekiteeri 12. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Paashini kitejiri riyaatanaki apaniroeni Jesoshi ikenkithatakaeri Iriri. Riyoshiitanakiri raanakiri riyotaanewoperopaeni 12. Roojatzi rojampitantakari: —¿Iitaka ikenkithashiryaakoperotanari ajoriiyotzinkaritepaeni? ¿Tsikama noetaperotaka naari? ");
INSERT INTO cjoNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Rakanakiri: —Ikantayitzini apaanipaeni: “Rirojatziita Jowani kaawoshitantawitacharini, piriintaacha”. Irira paashini ikantzi: “Rirojatziita Iriiyashini, oñaagantapaacha eejatzi”. Irira paashini ikantzi: “Rirojatziita paashini kamanantzirorini iñaani Tajorentsi, piriintaachari”. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Roojatzi rojampitantanakari rirori ikantanakiri: —Omaanta eeroka, ¿tsika pikanteeyinika? Rakanakiri Peetero: —Eerokataki Rotyaantanewo Tajorentsi naamagaeyakarini. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Omaanta ikantaperoeyirini: —Eerowa pathawayitawo pikamanantawaetzi, pikante: “Jesoshi rirotaki Rotyaantanewo Tajorentsi, riraga Owawijaakotantatsini”. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Kyaaryo, nopoñaanaka jenokinta, nokoñaatapaaki jaka kipatsikika omaanta osheki nokemaatsitya paata. Itheenkaeyenani aataperoteenchari, jewatayitziririni, ñaanakowenantatsiripaeni, iyotaantzirori Iwaperite Tajorentsi, maawaeni. Ikanteeyenani: “Kaari irira Jesokirishito”. Rowamaakaantena, okaate kitejiri 3, nopiriintanee eejatzi. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Roojatzi ikanteeyantakarini Jesoshi maawaeni: —Pikowaeyakinirika poyaataperoeyanakinani, otzimatye pookaperoeyanakironi oetarikapaeni inimoteeyawitzimirini eerokapaeni pantziri, inta maawaeni kitejiriki pipomeentsiwenteeyaawoni nokowakagaeyakimirini naari, omawitya rowamaanteetemiro, omawitya ikijanteetemiro. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Aririka pantawaetawentashitya eeroka iroñaaka, eero piyotaperotziri Tajorentsi, eejatzi eero pijeekimoteeri iinja. Rooma aririka pinintaperotena naari, eejatzi pipomeentsiwentayitenawoni nokowakagaeyimirini naaka, eero patsipetashitawo, inta piweshiryaawentyaari iroñaaka Tajorentsi, eejatzi pijeekimotapaeri iinja. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Omawitya pipiyotaperotawityaaworika osheki owaagawontsi jaka kipatsiki, omaanta pipeyakotakiririka Tajorentsi, eero piyaatzi jenokinta ijeekinta rirori. Tema patsipetashiteeyawitakawoni maawaeni pashiteeyawitakarini. Ñaakiro, tekatsi pikantya pipinateri Tajorentsi ijeekakaantemiri janta inampikinta. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Tema naaka poñaachari jenokinta, natziritapaaki jaka kipatsikika. Eejatzi nopiyanee janta. Roojatzi iinja nopiyanteeya eejatzi jaka kipatsikika, notajorentsiperotapaaki: nokimityaari Pawa eejatzi maawaeni ronampiri, riraga kameethaperotatsiripaeni. Rootaki okameethatanteeyaari pikenkithashireeyaani: aririka pipashiwentakayena naaka iroñaaka, eejatzi aririka pipashiwentakayaawo noñaani, ari iinja nopashiwentakaapaemi eeroka aririka nopiyee. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Omaanta kyaaryo iroka nokamantemiri, eero namatawitzimi: eerorika pikamita, piñaayitawakironi tsika ikanta Tajorentsi ipinkathariwenantzi. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Rootzimateentsi awijanaki apaani tominko riyaatantakari Jesoshi tonkaariki, ikenkithatakayiri Iriri. Raanakiri Peetero, Jantyaako, eejatzi Jowa. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Eenirowa ikenkithatakaakiri Iriri, ari omapokashitapaaka ipaashinipootanaki, eejatzi oshipakiryaaperotanaki iithaari, ochookyaakiri riraga amineeyakiririni. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Romapokashitapaakari eejatzi apite shirampari, ikenkithatakaapaakiri Jesoshi. Riraga ayiitapaentsiri rirotaki Moeseeshini eejatzi Iriiyashini; ");
INSERT INTO cjoNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","tee ikimitee akimiteeyanika aaka, ikameethaperotaki: ikimiteeyakarini jenokijatzi. Ikenkithatakaawakagaeyakani 3: ikenkithatakotakiro ikame iinja Jesoshi janta Jerojareeki. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Osheki ipochokyaayitawitanaka Peetero eejatzi itsipateeyarini, omaanta tee imagaeyini. Ramineeyakirini Jesoshi, ishipakiryaaki, ikimitanakawo kitejiri. Eejatzi ramineeyakirini riraga itsipateeyakarini. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Rooteentsi ipiyanee riraga apiteteentsiri, ikantziri Peetero: —Iyotaanari, kameethataki pamakinaka jaka, noñeeyakimini. Iroñaaka nokowaki niwetsikemi 3 pankoshintsi: apaani pashi, apaani rashi rirori Moeseeshi, eejatzi apaani rashi rirori Iriiyashi. Ikanta Peetero iñaawaetashitanaka, tee ikenkithashireeya oetarika iñaawaeteri. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Omapokashitapaakari eenirowa ikenkithawaeteeyini menkori, otzikagaeyapaakirini, roojatzi ithaawaeyantanakani. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Roojatzi ikemaeyakirini Tajorentsi, iñaawaetaki menkorikira, ikantanaki: —Rirotaki irika notyomi nonintaperotanewo: pikemijanteeyawakirini. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Roojatzi ramineeyantawitanaarini: tekatsi iñaanee, apatziro Jesoshi apaniroeni ikatziya. Ikanta imaneeyakironi okaatzi iñaakiri, ojamanitakotaki, tee ikamantawaetzi. Paatakya ikamantakoteeripa okaatzi iñaakiri. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Okitejitanaki, roerinkaeyanakani, itonkiyoteeyawakarini osheki atziri. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ikantawakiri apaani: —Iyotaanari, pikaminthaaneenari notyomi napintzite, tekatsi paashini. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Rowariyaapiintziri kamaari, ikaemakaapiintziri. Rompetatakaapiintari, ishimoretakaapiintari. Rowashironkaapiintakiri: tee rotsiparyaaneentari. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nokantawitakari piyotaanewopaeni retsiyatakoterimi, omaanta tee imatziri. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Rakanakiri Jesoshi: —Eero imatziri: tema ari pikaateeyini pitheenkanteeyini, rootaki kaari imatantari kamaari; tema pikenkithashiryaaneenta. Osheki neshiwentakimi notsipatakimi niyotagaeyawitakimironi iñaani Tajorentsi. ¿Tekiraatama piyotakoperoeyironi itajorenka Tajorentsi? Pamakinari pitomi jaka. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Rootaki iniyankitakaawitapaakari itomi, romapokashitanaka kamaari iparyaakaakiri kipatsiki, tereei, rompetatakaakari tonki, tonki. Roojatzi rotyaanantaari Jesoshi kamaari, rowawijaakoteeri eentsi. Ikanteeri Iriri: —Irika pitomi: awijakotee iroñaaka. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Rotsikanateeyanakarini kameetha maawaeni atziripaeni, ikantawakagaeyanakani: —Tema itajorentsiperotaki kameetha Tajorentsi. Eenirowa rotsikanateeyakarini, ikanteeyakirini Jesoshi riyotaanewo: ");
INSERT INTO cjoNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Pikenkithashiryaaperotero iroka nokamantemirika. Eero pipeyakotziro. Nopoñaaka naaka janta jenokinta, nokoñaatapaaki jaka kipatsikika, omaanta iinja aritaki raakaanteetakina. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Omaanta tee riyoteeyawakironi ikantawitakariri. Tee ishinetziri Tajorentsi riyotakoeyawakironi. Ithaawanteeyakarini rojampiterimi oetarika ikantawitariri. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Roojatzi ikantawakagaeyanakani riyotaanewopaeni Jesoshi, raamagaeyakani, ikantzi: —Jaka akaateeyinika: ¿ninka anaakotantaatsini ipinkatharitee? ¿Naakama pipinkathateeyeni? ");
INSERT INTO cjoNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Riyotakotakiri Jesoshi oetaka ikenkithashireeyakarini. Ikaemakiri eentsi: —Pipokanaki jaka okaakini. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Roojatzi ikanteeyantanakarini riyotaanewopaeni: —Pamineri irika eentsi, aapatziyanari. Aririka petakotyaari irika eentsika, eejatzi petakotakina naari. Aririka petakotakina naari, eejatzi petakotakari otyaantakinari. Aririka petakotyaari paashinipaeni atziri, aritaki pipinkatharitaki iinja. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Roojatzi ikanantakari Jowa: —Iyotaanari, chapinki noñaakiri shirampari janta rowawijaakotayitakirini kyaantawitariri kamaari. Ikamantawitakina raapatziyimi, rootaki imatantariri rowawijaakotziri. Omaanta tee kijokiro rowaeyeeni aaka rootaki nookakaantakariri rowawijaakoteri kyaantawitariri kamaari. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Rakanakiri Jesoshi, ikantziri: —Eero pithañaakotari. Irira tee ikijeeyeeni, tema rantakinawo nokowakaakiriri. Rootaki atsipateeyantakaririni. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Rooteentsi areetya kitejiri riyaatee Jesoshi jenokinta. Apatziro ipoñaanaka riyaatanaki Jerojareeki. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Rotyaantakiri riyotaanewo, ikantakiri: —Thame pityaawo janta Jamaaryaki, pamine ajeekanteeyapaakyaarini. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ikanta riyaatawitanaka, omaanta riyoteeyakirini jamaaryajatzi riyaatatye Jesoshi janta Jerojareeki, rootaki kaari ishinetantawakari roojeekawakiri inampiki. Roojatzi ipiyantanaa, ikamantapaeri Jesoshi, ikantziri: —Eero ishinetee amaye inampiki. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ikemantawakari Jantyaako eejatzi Jowa, ikantakiri: —Nowinkatharite, ¿pikowakima nokanteri Tajorentsi itagaeyerini maawaeni jamaaryajatzi? Nokimityaari Iriiyashini paerani: itaakaantakirini joraaropaeni kijeeyakiririni. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Rookathatanakiri Jesoshi, ikantanakiri: —Tee okameethatzi akijeri. Tee piyoteeyini eeroka tsika pikantakari: tee pikameethashiretzi. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Naaka poñaachari jenokinta, natziritapaaki jaka kipatsikika. Tee ro nopokantya nowamaayiterini atziri, inta nopokantari nowawijaakoeyerini. Roojatzi rowagaeyantanaani paashiniki nampitsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ikanta ikineeyanakini awotsiki, itonkiyotawakari shirampari, ikantawakiri Jesoshi: —Nowinkatharite, nokowaki noyaataperotanakimi, tsikarika piyaate. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ikantanakiri: —Naaka poñaachari janta jenokinta nokoñaatapaaki jaka kipatsikika nowawijaakotantyaariri atziri. Pikemijantawakiro iroka nokamantemiri: riraga otsitziniro eenitatsi imoo imaapiinantari, riraga jenokiweripaeni eenitatsi imaashi; omaanta naaka, tekatsi nopanko nomaantyaari. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Roojatzi ikantakiri paashini atziri: —Poyaatanakina eeroka. Rakanakiri ikantzi: —Nowinkatharite, nokowawitaka, omaanta ikamawakiita pawa. Aririka nokitatanakiri roojatzikya noyaatantanakimi. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Rakanakiri Jesoshi: —Eeniro ikaateeyini theenkantatsiripaeni, rirotaki kitaterini aririka ikamaki. Omaantakya eeroka, thame poyaatena pikamanteeyeriniita atziri tsika ikanta Tajorentsi ipinkathariwenanteeyeerini. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ikantziri paashini shirampari: —Aritaki, nowinkatharite, noyaataperotanakimi: omaanta niteeyapaentyaariniita niwethateeyapaentyaariniita nosheninkapaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Omaanta rakanakiri Jesoshi: —Pithapaterorika kipatsi pipankiwaetantyaari piwankiri, eero paminaminawaetzi tsikarikapaeni, eero otzipitzipiwaetantanaka pithapatakiri. Eejatzi okimitaka roori: pikowakirika ipinkathariwentemi Tajorentsi, poyaataperotena, eero pikenkithashiryaapiintziro panteero eejatzi pantapiintawitarini paerani. ");
INSERT INTO cjoNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Roojatzi rotyaanteeyakirini Awinkatharite osheki riyotaanewopaeni reewateeyanakini, ikaateeyini 72. Ikantawakiri: —Piyaateeyini nampitsikipaeni nokanteeyakimirini, apite pikantawakaayitanakyaani. Eekiro nimpaeteemi iinja naari. ");
INSERT INTO cjoNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Okimitaaka pankirentsi oshekiterika okithoki tekatsiperorika owiiteroni apaatanakya okithoki rooma tee roshekitzi owiiteroni. Eejatzi okimitaka iroñaaka eeniro oshekipero atziri kaari aapatziyana. Pamanapiinteri Awinkatharite rotyaanteeyantyaaririni osheki amitakotemini pikenkithatakagaeyerini atziri, riyaatanteeyaarini rirori jenokinta. ");
INSERT INTO cjoNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Pamine, osheki opomeentsitzimoeyemini, osheki rowashironkaeyemini theenkantatsiri: pikimityaari owisha, rojatekakari manitzipaeni. Iroñaakakya, piyaateeyini pikenkithateeyeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Eero paanaki pithaate, piyorikite, pijapatote. Aririka pitonkiyotawakyaari atziri niyanki, eero pikatziyakaari pikenkithawaetakayiri, omaanta pawijanakiri: apatziro powaanakiro janta nokantakiminta. ");
INSERT INTO cjoNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Tsikarika pijeekapaaki, pikanteri Tajorentsi ramitakoteri ashitawori ipanko raapatziyantenari ijeekantyaari kameetha. ");
INSERT INTO cjoNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Aririka raapatziyena, ari rawijakotee, ijeekantyaari kameetha. Rooma eerorika raapatziyana tee patsipetashitawo pikenkithatakayiri iñaani Tajorentsi: tema pantakiniri iroka nokantakimiri. ");
INSERT INTO cjoNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Tsikarika janta pijeekapaaki, aritaki pijeekaeyapaakini. Eero pikinakinayitzini pankotsikipaeni. Poyaawo oetarika ipawakimiri, eejatzi pirero, maawaeni. Okameethatzi ipawakimi oetarikapaeni koetyeemotakimiri: riraga atziri antawaetatsiri ikameethatzi ipineeteri. ");
INSERT INTO cjoNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Tsikarika pareetapaakya, aririka raakameethatawakimi, powapaakyaawo oetarika ipawakimiri. ");
INSERT INTO cjoNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Eenitatsirika mantsiyaripaeni, petsiyatakoeyerini. Pikamanteeyerini maawaeni: “Rooteentsi ipinkathariwenteeyemini Tajorentsi”. ");
INSERT INTO cjoNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Omaanta eerorika raakameethatawakimi paashinipaeni atziri, pikanteeyanakirini: ");
INSERT INTO cjoNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Pikemaeyawakinani: ikowawita Tajorentsi ipinkathariwentemimi, omaanta tee pikoyi. Tee paakameethateeyawakinani, eejatzi okimitaka, tee paakameethatawakiri Tajorentsi. Iroñaaka pashironkagaeyaani”. ");
INSERT INTO cjoNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Rootaki nokowakiri pikamanteriri. Ñaakiro, paerani riraga joroomajatzini imaninteeyakirini Tajorentsi rootaki ithonkanteeyakaririni. Omaanta eerorika raapatziyeeyawakimini atziri iroñaaka, ari iinja ranaakotaperoteri joroomajatzini ikemaatsitaperoteeyaawoni osheki. ");
INSERT INTO cjoNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Eejatzi ikantzi Jesoshi: —Ashironkaamatsiterini korashiinijatzi eejatzi wetheerajatzi: osheki iñaakoeyawitakinawoni notajonkantapiintaki, omaanta tee raapatziyeeyawakinani. Rirorikami ñeeyakinanimi tziirojatzi eejatzi shiroojatzi, tema ari ikenkithashireeyaneeyaanimi, rookaeyeeronimi kaari kameethatatsi ranteeyirini. ");
INSERT INTO cjoNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Kyaaryootaki rowashironkaeyakirini Tajorentsi iinja tziirojatzi eejatzi shiroojatzi, rowashironkagaeyerini, omaanta rowashironkaaperoeyerini osheki korashiinijatzi eejatzi wetheerajatzi. ");
INSERT INTO cjoNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Eejatzi ikenkithashireeyawitakani kaperinawoojatzi riyaateeyenimi janta jenokinta, omaanta eero riyaateeyini inta riyaateeyeni janta paamariki jeekatsiri inthomaenta kipatsi ikemaatsityaawo. ");
INSERT INTO cjoNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Niyotaanewo, pikemaeyenani. Aririka raapatziyeeyawakimini atziripaeni, eejatzi naari raapatziyeeyakinani. Aririka itheenkaeyawakimini eerori, eejatzi ikimitzitakina naari itheenkaeyakinani. Eejatzi okimitaka, aririka itheenkaeyenani naari, tema itheenkaeyerini eejatzi riraga otyaantakinari. Iroñaakakya, piyaateeyeni. Ari ikanteeyakani. ");
INSERT INTO cjoNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ikantaka ipiyeeyapaani rotyaantanewopaeni Jesoshi, ikimoshireeyapaakini. Ikamanteeyapaakirini: —Nowinkatharite, riyotakina kamaari naapatziyakimi, ikemijantaperotakina. Nomatakirikya notyaanteeyakirini. ");
INSERT INTO cjoNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Rakanakiri: —Kyaaryo riraga Jatanaashi ipinkathariwentawitakari iyamaaritzinkarite, omaanta noñeeyakimini pimateeyakirini potyaantakiri kamaari eerori: iroñaaka niyotaki eero ipinkatharitaperotzi Jatanaashi, tema ramitakotakimi Tajorentsi panaakotantakariri kamaaripaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Iroñaaka osheki notajonkawentakimi: okimiwitaka aririka paatzikawityaari maanki, eero rowamaemi; eejatzi riraga kitoniro, tekatsi ikantemi. Eejatzi ikijawitemi riraga iwinkatharite kamaari, omaanta tekatsi ikantemi, tema notajonkakowentakimi. ");
INSERT INTO cjoNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Kyaaryo potyaantayitakirini kamaari, omaanta eero piweshiryaawentawo iroka, inta pikimoshirewentaperoeyeroni piyaateeyeni jenokinta, tema rojankinateetakiro piwaero janta. ");
INSERT INTO cjoNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Roojatzi riraga Jesoshi okimoshiretakaaperotakiri Ishire Tajorentsi, ikantziri Iriri: —Pawa, osheki pikameethataki. Pipinkathariwenteeyirini maawaeni jenokijatzi eejatzi maawaeni kipatsijatzi. Eeniwitacha atziri iyotawitachari, riyotayitawitawoni oetarikapaeni, omaanta pimanapithatakiri piñaani: tee riyoteeyironi tsika ikantyaari rawijakotanteeyaari. Omaantakya piyotaaperoeyakirini riraga kaari iyoperowitachari: itheenkaeyawitakarini ijoriiyotzinkarite omaanta pikowakaaperoeyakirini rirori riyote. ");
INSERT INTO cjoNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Roojatzi ikanteeyakirini piyotawenteeyakaririni: —Rirotaki Pawa matakaakinawori maawaeni. Apaniroeni riyoperotana Pawa, tekatsi paashini iyoperotenani. Eejatzi nokimita naari, apaniroeni niyoperotziri, tekatsi paashini iyoperoterini: omaantakya ninkarika nokowakaakari noñaayeri, rirotaki yoterini Pawa eejatzi. ");
INSERT INTO cjoNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ipithokashitanakari rirori riyotaanewopaeni, apaniroeni irira ikanteeyakirini: —Piñeeyakinani eeroka nomatakiro kaari iñaapiinteeyini paashinipaeni atziri. Okameethatzi pikimoshirewentena, eejatzi ikimoshirewentena paashini ñaayitanarini. ");
INSERT INTO cjoNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ikowaeyawitakani paerani riraga kamanantzirorini iñaani Tajorentsi iñeenami notajonkantayiteni, omaanta tee iñaana notajonkantayitzini. Eejatzi ikowaeyawitani iñeenami riragapaeni pinkatharitayitawitacharini. Eejatzi ikowaeyawitani ikemaeyenanimi, omaanta tee ikemaeyanani. Intakya eerokapaeni piñeeyakinani, pikemaeyakinani. ");
INSERT INTO cjoNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Paashini kitejiri ipokashitakiri iyotaantzirori Iwaperite Tajorentsi rowaga rojankinarini Moeseeshi. Ikowawitaka ikompitakayaarimi Jesoshi, ikantawitapaakari: —Iyotaanari, ¿tsika nokantyaaka nojeekantyaari jenokinta, nokanteetatyeeyaani? ");
INSERT INTO cjoNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ikantawakiri: —¿Oetaka okantziri rojankinarini Moeseeshi? ¿Oetaka okantzimiri? ");
INSERT INTO cjoNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Rakanakiri: —Okantana: “Okameethatzi anintashireperoteriroña Tajorentsi maawaeni ajankaneki. Rirotaki Awinkatharite. Eejatzi kameetha akyaaryoowenteri aapatziyaari. Eejatzi kameetha akenkithashiryaaperotyaari tema ikameethaperotaki. Eejatzi paashini ikowaki Tajorentsi: akimitaaka anintaa aaka, eejatzi akimiteri paashinipaeni atziri, anintaperoteriroña”. ");
INSERT INTO cjoNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ikantanakiri: —Kyaaryooperotaki iroka pikantakirika. Aririka pimonkaatero iroka eerori, aritaki pijeekae jenokinta pikanteetatyeeyaani. ");
INSERT INTO cjoNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Omaanta riraga iyoperowitawori rojankinarini Moeseeshi tee inintashireperotziri maawaeni atziri, rooma ikowawita imaniromi. Rootaki rojampitantanakariri Jesoshi: —¿Ninkama atziri nonintaperoeyerini? ");
INSERT INTO cjoNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ikantawakiri: —Noshiyakaawentemiro. Ikinanaki apaani joriiyo awotsiki. Ipoñaanaka Jerojareeki roerinkawitanaka taapiki rareetantyaami nampitsiki iitachari Jerikoo. Ikantaka niyanki awotsi romapokapaakiri apaanipaeni koshintzi roerikapaakiri, shepik. Roojatzi raatonkoryaapaakiri, raapithatapaakiri iithaari, osheki ipajapajaatakiri tag, tag, tag. Roojatzi rookamerikitanakiri awotsiki, rawijanakiri. Rooteentsi ikamemi riraga owashironkaenkari. ");
INSERT INTO cjoNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ikantapaaka ikinapaaki awotsiki ñaanakowenantatsiri, rirowitaka joriiyo eejatzi. Iñaawitapaakari rirori rowashironkagaetakiri, roshinampitapithatanakiri, tee retakotanakari. ");
INSERT INTO cjoNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Eejatzi ikimitaka irira paashini shirampari riraga icharineeteni Rewiini. Tema maawaeni irirapaeni ramitakotziri ñaanakowenantatsiri janta Tajorentsipankoki. Ikinapaaki awotsiki, iñaawitapaakari rirori, eejatzi roshinampitapithatanakiri, tee retakotanakari rirori eejatzi. ");
INSERT INTO cjoNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Omaanta ikinapaaki paashinijatzitatsiri atziri rirotaki jamaaryajatzi, roonanewo joriiyopaeni. Ikinapaaki iñaapaakitziiri rirori, roojatzi retakotantapaakari. ");
INSERT INTO cjoNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Riyaatashitapaakiri raawintapaakiri, eejatzi roojotakotapaakiri rompojeetakirira. Eejatzi eeniro ramakiri iwoorote riraga jamaaryajatzi. Roojatzi raakiri rirori rowankitakiri iwooroteki, raanakiri janta ojeekinta pankotsi. Eejatzi janta kameetha inintashireperotanakiri raawintapaakiri. ");
INSERT INTO cjoNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Okitejitanaki ikowaki riraga jamaaryajatzi riyaate. Ikantanakiri ashitawori ipanko: “Ajaa, irika korikika. Nokowaki pikamintheeri irika shirampari. Tekirarika imonkaata koriki, paata nopinatapaemi paashini aririka nopiyee”. ");
INSERT INTO cjoNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ari ikaataki 3 ñaakiriri owashironkaenkari awotsiki. ¿Ninka atziri nintaperotakiriri? Rootaki rojampitakiriri riraga Jesoshi iyoperowitawori rojankinarini Moeseeshi. ");
INSERT INTO cjoNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Rakanakiri: —Tema rirotaki riraga etakotakariri. Ikantanakiri riraga Jesoshi: —Eejatzi eerori, pikimityaari: pinintashireperoteri maawaeni atziri. ");
INSERT INTO cjoNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ari ikinanaki awotsiki Jesoshi, itsipateeyarini riyotaanewopaeni. Rareeteeyapaakawoni owaanini nampitsi. Roojatzi janta oñaantawaari tsinani owaero Maarita, okantawakiri: —Thame pijeekaeyeni nopankoki. ");
INSERT INTO cjoNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Otsipatawo irento janta opankoki owaero Mariiya. Ojeekimotakiri Awinkatharite iitziki, okemijantawakiri, riyotaapaakirori. ");
INSERT INTO cjoNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Rowaga Maarita, oshintsiwaetawakiniri onkotsitayitzinirini rowanawopaeni. Roojatzi iyaatashitakiri, okantapaakiri: —Nowinkatharite, pamine, apaniroeni nonkotsitayitzimironi poyaari. Rooma rowaga eentyo, tee amitakotana. Potyaantero amitakotenaata jaka. ");
INSERT INTO cjoNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Rakanakiro: —Maarita, osheki pikenkithashiryaaperotakawo eeroka ponkotsiwaete owanawontsi, eejatzi powameethayiteroni oetarikapaeni. Osheki pikenkithashiryaakawo. Okameethatawita maawaeni iroka, ");
INSERT INTO cjoNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","omaanta eenitatsi apaani kameethaperotatsiri: rootaki iyoyagaanantakari pirento roori, tekatsi kantawenteroni. ");
INSERT INTO cjoNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Paashiniki kitejiri riyaataki Jesoshi ikenkithatakayeri Ashitariri. Ithonkatapaakiro ikenkithatakayiri Iriri, roojatzi ikantapaakiri apaani riyotaanewo: —Nowinkatharite, paerani riraga Jowani riyotaakiri riyotaanewopaeni tsika ikantya ikenkithatakayeri Tajorentsi. Eejatzi eeroka iroñaaka nokowaki piyoteena naari tsika nokantya namaneri. ");
INSERT INTO cjoNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ikantawakiri: —Aririka pikenkithatakayeri, ari pikimitero iroka pikanteri: Pawa, jeekatsiri jenokinta, osheki pikameethaperotaki, nokowaki pipinkathariwenteeyenani, maawaeni. Okameethatzi nanteeyemironi maawaeni pikowakaakinari: nokoyi nokimityaari ponampiripaeni jenokijatzinta ranteeyimironi maawaeni pikowakaakiriri. ");
INSERT INTO cjoNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Pamitakotena maawaeni kitejiriki eero okoetyeemotantana noyaari. ");
INSERT INTO cjoNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Eero pikijawentanawo kaari kameethatatsi nantziri inta pikaminthayena: tema naari nokamintheeyirini maawaeni atziri. Eero pishinetziri kamaari rantakayenawo kaari kameethatatsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Eejatzi ikantakiri Jesoshi: —Pamine, niyotaanewopaeni, noshiyakaawentemiro. Aririka piyaatashiteri pitsipaminthari tsiteniriki pinetheeri rowanawo. Pikantapaakiri: ");
INSERT INTO cjoNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","“Tekatsi nopawakiriri niyompari owakira rareetapaaka. Nokoyi pipawakina nowakayaariri”. ");
INSERT INTO cjoNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Aamashitya ari ikantawakimimi: “Eero poñaashirenkana, osheki nowochokini. Maawitakina naaka, eejatzi neentsitepaeni, maawaeni. Ashitaka ashitakontsi. Tekatsi nokantya nopiriinte nopantemirori poyaari”. ");
INSERT INTO cjoNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ñaakiro, pitsipaminthari powawitari. Tee ikowawita ipiriinte ipantemirori poyaari. Omaanta eekirowa poñaashirenkiri roojatzi ipiriinantanakya, ipawakimiro poyaari pikowakotakiriri. Rooma tee ikoyi poñaashirenkapiinteri. ");
INSERT INTO cjoNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Eejatzi okimita, aririka pamanapiinteri Tajorentsi, ari ramitakotapiintakimi ipakimi koetyeemotzimiri. Pikowakotapiinteri aritaki piñaakiro koetyeemotzimiri. Pikenkithatakaapiinteri aritaki ikemakimi, imatakayemiro kameethatatsiri. ");
INSERT INTO cjoNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kyaaryo, maawaeni amanapiintziriri Tajorentsi ari ramitakotakiri iñaantyaawori koetyeemotariri. Maawaeni kowakowapiintatsiri riyotaapiinteri iñaantyaawori koetyeemotariri. Maawaeni kenkithatakaapiintziriri ari ikemakiri kameetha imatantyaawori kameethatatsiri. ");
INSERT INTO cjoNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ñaakiro, ikowakotemirika pitomi owanawontsi royaari, ¿arima pipawakiri mapi? Ikowakotemirika shima royaari, ¿arima pipawakiri maanki? ");
INSERT INTO cjoNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Aririka ikowakotemi iithoki tyaapa, ¿arima pipawakiri kitoniro? Eero pipawakiri, inta pipaperotawakiri kameethatatsiri royaari. ");
INSERT INTO cjoNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ñaakiro, tee pikameethawitya eerokapaeni, omaanta piyotzi pineshironkatziri peentsitepaeni. Rooma irintapaeni Ashitakaeri jenokinta riyotaperotzi rirori ineshironkaperotee aakapaeni. Aririka pikowakoperoteri, rotyaantemiro Ishire amitakotemini. ");
INSERT INTO cjoNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Paashini kitejiri iñaakiri Jesoshi shirampari imajontzitakaakiri kamaari, ikyaantawitakari rajankaneki. Itajonkakowenteeri Jesoshi, rowawijaakoteeri, roojatzi iñaawaetantanaa eejatzi. Rotsikanateeyanakarini maawaeni ñeeyakiririni. ");
INSERT INTO cjoNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Omaanta ikantayitzini apaanipaeni: —Ramitakotashitakari Jesoshi Wereshewoo: riraga iwinkatharite kamaari, rootaki imatantawori rowawijaakoteeri imajontzitakaakirira kamaari. ");
INSERT INTO cjoNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ijeekaki paashini theenkiriri Jesoshi, ikantziri: —Ajaatya, pitajonkante, niyotantemiri kyaaryorika pipoñaaka jenokinta. ");
INSERT INTO cjoNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Omaanta riyotakiri rirori ikenkithashireeyakarini. Ikantziri: —Aririka romanatawakagaeyaani atziri, tema aritaki ithonkawakagaeyakyaani. Eejatzi aririka ikijawakagaeyaani asheninka, tema ari itsipareeyawakaanakyaani. ");
INSERT INTO cjoNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","19","Eejatzi okimita, aririka ikijeeyerinimi Jatanaashi iyamaaritzinkarite, ¿tsika ikantyaari ipinkathariwenantyaariri? Eerori pikanteeyakini iroñaaka: “Rirotaki Wereshewoo amitakotziriri Jesoshi rowawijaakotantariri imajontzitakaeri kamaari”. Rirorika amitakotenanimi nowawijaakotziri imajontzitakaeri kamaari, ¿ninka amitakotziriri pisheninkapaeni rowawijaakotantariri atziri kyaantawitakariri kamaari? ¿Rirojatzima pisheninka eerori kamaari? ");
INSERT INTO cjoNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Omaanta imatakaakinawo Tajorentsi nowawijaakotantakariri imajontzitakaeri kamaari, piyoteeyantyaarini iroñaaka kijokiro rowaeyakimini riraga Tajorentsi, ikowaki ipinkathariwenteeyemini. ");
INSERT INTO cjoNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Paashini roshiyakaawentakiniriri Jesoshi, ikantaki: —Pamine, eenitatsirika shirampari shintsitatsiri ithatyaamento, ichekopite, maawaeni, tema ishentaperotziro ipanko. Eero ishinetziro ikoshiteeteri rowaagawo. ");
INSERT INTO cjoNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Omaanta ipokapaakirika anaakotapaakirini shintsitaperotatsiri, eero imatziro rotsinampaawakiri rirori oetarika ranantapaakyaariri. Tema ari raapithatapaakiri rowamaamentopaeni. Roojatzi ikoshitantanakyaari rowaagawo, ipaeyanakirini isheninkapaeni rirori. ");
INSERT INTO cjoNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ikijeeyakinani maawaeni kaari inimoteeyirini nantero, rootaki rantawakaantanakari osheki atziri kaari raapatziyantaneena. ");
INSERT INTO cjoNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Aririka ipakagaeri atziri kamaari, okameethatzi ipinkanakiri: rapiiteerikari eejatzi. Okimitaka iroka: ikinakinayitakini riraga kamaari janta ochempiki, ikowakowawita tsika ijeekantyaari. Omaanta teerika iñee ijeekantyaari, roojatzi ikenkithashiryaantanaawori ipoñaanakanta, ikante: “Nopiyaneeta janta nopoñaakanta”. ");
INSERT INTO cjoNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Aririka ipiyapae, iñaapaeri shirampari kimitaka pankotsi, opishitaka eejatzi kameetha okaankiityaaki. ");
INSERT INTO cjoNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Roojatzi riyaatantaka ikaemeri paashinipaeni iyamaaritzinkarite, ikaatzi 7. Maperori tee ikameethatzi riroripaeni. Ñaakiro, iroka pankotsi roshiyakawo kyaantawitariri kamaari. Aririka rapiiteeri ikyaanteeyari, roojatzi imaperotanteeya eero ijeekanee kameetha. ");
INSERT INTO cjoNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ijeekaeyakini janta osheki kemaeyakiririni Jesoshi. Ocheraanaki apaani tsinani, okantzi: —¡Tema okimoshirewentakimi piniro koñaatakimiri! ");
INSERT INTO cjoNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Omaanta ikantawakiro: —Jee, kyaaryo, omaanta ikimoshireperoeyakini maawaeni kemaeyirorini iñaani Tajorentsi, eejatzi raapatziyeeyari. ");
INSERT INTO cjoNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Eekiro ipiyotawenteeyatyaarini Jesoshi paashinipaeni atziri. Roojatzi riyotagaeyantakarini, ikantziri: —Tee pikameethateeyini. Pikowaeyawitani piñeeyenanimi notajonkanteemi eejatzi, omaanta eero notajonkantzi. Apatziro pikenkithashireeyaari Jonaashini piyotantyaari: ");
INSERT INTO cjoNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","paerani iniyakiri antari omani. Okaatzi 3 imaakotaki inthomaenta, roojatzi ishitowantanaa ipaanteki, riyaatantanaka riyoteeri niniweejatzi. Tema rotyaantakiri Tajorentsi. Ari nokimiteeya iinja naari piyoteeyantyaarini rotyaantakina Tajorentsi: tema nopoñaaka janta jenokinta natziritapaaki jaka kipatsiki. ");
INSERT INTO cjoNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Eejatzi rowaga iwinkathawoteni sheewajatzi, opoñaaka inteena kameetha, paashiniki kipatsi. Paerani opoñaaka inteena okemijanantariri Sharamooni. Okowaki riyotakaaperotero riyotaantziri. Pamine, nanaakoperotakiri naaka Sharamooni niyotzi, omaanta eeroka pitheenkaeyakinani. Iinja, aririka ipiyoteeyerini Tajorentsi maawaeni kamatsiripaeni, ikanteeyemini: “Eenitatsi pantani: pitheenkakiri Notyaantanewo. Rooma roori rowaga iwinkathawoteni sheewajatzi, tema riro aapatziyakaakaworini okaatzi riyotaakirori Sharamooni”. ");
INSERT INTO cjoNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Eejatzi ikimitaka riraga niniweejatzini: raapatziyakari Jonaashini. Ikenkithashireeyanaani, ipakagaeyeeroni kaari kameethatatsi ranteeyawitarini. Nanaakotziri naaka Jonaashini, omaanta eeroka tee paapatziyeeyanani. Iinja ikantemi Tajorentsi: “Raapatziyakarini niniweejatzini Jonaashini: omaanta eeroka, ¿iitaka kaari paapatziyantari Notyaantanewo?” ");
INSERT INTO cjoNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Eejatzi ikanteeyakirini Jesoshi: —Aririka poonthoteri ootamentotsi, ¿arima pimanakiri tsikarika? ¿Arima potetakiri kantziriki? Tema powapiintziri jeñokiini ijeekapiintzira, pikoñaatakotantyaari. ");
INSERT INTO cjoNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Iroka oki okimitawitawo ootamentotsi ashi awatha. Okameethatzirika oki, ari añeeyakironi oetarikapaeni. Omaanta teerika okameethatzi, eero añiiro oetarikapaeni, okimitaka akinaki tsiteniriki, tee ayoteeyini tsikarika akinaki. Eejatzi okimita aririka akenkithashireero kameethatatsiri ari antero kameethatatsiri. Omaanta akenkithashireerorika kaari kameethatatsi rootaki anantyaawori kaari kameethatatsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","36","Okameethatzi piyotakotya eeroka paapatziyaperotakaririka Tajorentsi. Pimonkaaterorika iroka, ari piyoperotanaki iroñaaka eero pitheenkimatantee. Tema pikimitakotakari ootamentotsi ootaperotachari. Rootaki ikanteeyakiririni Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Roojatzi ikantanakiri warijeeyo Jesoshi: —Thame aate nopankoki, oya. Roojatzi royaatantanakari, rowakaapaakari. ");
INSERT INTO cjoNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Tee ikiwawakota Jesoshi, rootaki rotsikanatantanakariri kameetha warijeeyo. ");
INSERT INTO cjoNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ikantanakiri rirori: “Eerokapaeni pikenkithashiryaakopiinteeyironi okaatzi piñaayitzirini. Omaanta tee pikenkithashiryaakopiinteeyironi oetarika jeekayitatsirini pajankaneki. Pametawo pikiwiro pako, piwatha, piithaari, maawaeni. Omaanta tee pookimaetawo kaari kameethatatsi jeekatsiri pajankanekira. Pikimitakari atziri kiwawitawori iwajoni ikiwashitakawo jeñokiini, omaanta inthomaekira eeniro ojeeki owanawontsi opathayitakawoni. Omaanta tee pithonkiro pikiwiro. ");
INSERT INTO cjoNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Tee pikenkithashiryaaneenta. ¿Apatziroma riwetsikakiro Tajorentsi pako? Tema eejatzi riwetsikiro pikenkithashiryaantari. ");
INSERT INTO cjoNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Pipashitayitawitarini ashironkaenkari koetyeemowitariri, omaanta tee pikaminthaaperotziri, patsiwakashitakawo pipakiri. Omaanta aririka pikaminthaaperoteri paashinipaeni atziri, tema ari pikameethataki. ");
INSERT INTO cjoNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Pashironkagaeyani eerokapaeni. Kyaaryo pipagaantapiintawitari Tajorentsi eechonkiini pashi meenta, koraantero, kachaarikishi, omaanta tekira omonkaata ikowakayimiri Tajorentsi. Eeniro pantawitakari kameetha, eejatzi eeniro kaari pantzi. Tee pinintashireperotziri irira eejatzi tee pikaminthaaperotziri paashinipaeni atziri. Okameethatzi piperi Tajorentsi eechonkiini piwankiri, omaanta eero pipeyakotziro pinintashireperoteri eejatzi pantaperoteniri ikowakaakimiri. ");
INSERT INTO cjoNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","¡Ashironkaamatsitemiini eerokapaeni! Aririka ipiyoteeyaani ajoriiyotzinkarite iñaaperotantyaariri Tajorentsi, pikowaeyini ipinkathateeyemini eeroka eejatzi. Aririka pikinayitanakini pankotsikipaeni, pikowaki kameetha raakameethateeyaperotemini atziripaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Kyaaryo, rowashironkagaeyemini Tajorentsi. Pikimitakari kaminkari kitatachari kipatsiki, imanaka; tekatsi yotatsini ari ikineeyini atziripaeni, tee riyoteeyini rootentsimi raatzikakoterimi kaminkari pathagaentsiri. Eejatzi pikimitaka eerori, pimanayitawitawoni kaari kameethatatsi pantayitzirini”. Rootaki ikantakiriri Jesoshi warijeeyopaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Roojatzi ikanantanaka iyotaantzirori rojankinarini Moeseeshi: —Iyotaantatsiri, okaatzika pikantakiri eejatzi naaripaeni pikijakaakina. ");
INSERT INTO cjoNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Rakanakiri Jesoshi: —Jee, eejatzi eerori rowashironkagaeyemini Tajorentsi. Osheki powanaayitakinirini atziripaeni pikowakaaperotakiri imonkaatero, omaanta tee imatziro. Eejatzi pikimitaka eerori: tee pimonkaateeyironi. Eejatzi tee petakotari riroripaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Kyaaryo, pashironkagaeyaani. Pimonkaateeyakarini pichariniiteni rowamagaeyakirini kamanantayitzirorini iñaani Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Tema riyotakotakina naaka irirapaeni. Eejatzi eerokapaeni owamaantatsiri. Tee pikoyi eeroka paapatziyena. Ari pitzimitakyaarikami paerani eerori, ari powamagaeyakirinimi eerori eejatzi riraga kamanantatsirini. ");
INSERT INTO cjoNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Riyotakoeyakimini Tajorentsi, ikantzimi: “Notyaanteniri atziri kenkithatakayerini, omaanta rowamaayitawakirini apaanipaeni, irira paashinipaeni ikijawakiri, ikemaatsitakaawakyaari”. ");
INSERT INTO cjoNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Eenitatsi panteeyakirini maawaeni: pashi powaeyironi powamaantzi. Riraga itakaantaworini powamagaeyerinimi, roojatzi pikanta iroñaaka eerori pikowaki powamagaeyerini aapatziyeeyakaririni Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Pisheninkateeyakarini owamaakiririni Aweeri. Eejatzi pisheninkateeyakarini owamaakiririni riraga Jakariiyashi: rowamagaetakiri rirori janta Tajorentsipankoki. Eeniro panteeyakirini maawaeni, rootaki rowashironkaawentemiri Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Pashironkagaeyani eerokapaeni. Piyotaantawitawo rojankinarini Moeseeshi, omaanta pashironkagaeyaani: tema pamatawiteeyakirini ajoriiyotzinkaritepaeni. Tee pikowaeyini piyotakoteri Tajorentsi eerokapaeni, eejatzi tee pikowakagaeyirini riyoteeyerini riroripaeni riyoteri irira. ");
INSERT INTO cjoNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Rootaki ikanteeyakiririni maawaeni, roojatzi ishitowantanaa. Ikijeeyanakirini riraga warijeeyopaeni eejatzi riraga iyotaantzirori Iwaperite Tajorentsi, eejatzi eekiro roñaashirenkanakitziiri, rojampijampitanakiri oetarikapaeni, ");
INSERT INTO cjoNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ikowaeyawitakani ikompitakayaarimi, ipoñaakaantyaariri, raakaanantyaaririmi. ");
INSERT INTO cjoNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ipiyotawenteeyakarini Jesoshi oshekiperoroña atziri, rawitsinaawakagaeyakani. Roojatzi ikanantakari riyotaanewopaeni: —Paamayaarira warijeeyopaeni, ramatawiteeyiminikari. Roshiyakaawaetashita raapatziyari Tajorentsi, omaanta osheki ramatawitantzi. ");
INSERT INTO cjoNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Iiteeyawitakani tekatsi yotatsini ramatawiteeyawitakarini, omaanta iinja aritaki riyotakoeyerini maawaeni atziri rashi rowaeyironi ramatawitantzi. ");
INSERT INTO cjoNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Eejatzi eeroripaeni, oetarika pomanawitari pikantziri iroñaaka, ari ikemakoeyeemini iinja. Oetarika pikamantathatantawitariri apaani atziri janta pipankoki, ari itacheronkawaantetanaki ikaemanaki janta ipiyoteeyaninta atziripaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Iroñaaka, notsipaminthari, nokamantemi: eero pithaawantari riraga atziri kowatsiri rowamaemi. Aririka rowamaemi, omaanta apatziro rowamaawityaawo piwatha, omaanta eero rowamaero pishire. ");
INSERT INTO cjoNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Omaanta riraga Tajorentsi pithaawantyaari: ikowakirika, rowamaemi ari imatakiro. Omaanta eejatzi ikowakirika rotyaantemi paamariki kaari tsiwakanitatsini, ari imatakiro. Rirotakikya pithaawantya rotyaantzimikari paamariki. ");
INSERT INTO cjoNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","¿Ipinaperotama iyaanini shiwankitzinkari? Tee ipinataperota, omaanta riyoteeyirini Tajorentsi: tee ipeyakoeyirini apaani. ");
INSERT INTO cjoNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Eejatzi okimitaka, riyoperoeyakimini eerori: riyotziro eejatzi tsika okaatzi piishipaeni. Ikempoyeeyakirini shiwankitzinkari iyaanini, tema eerokapaeni ikempoyaaperoeyakimini. Eero pikantashiryaashita, omaanta piweshiryaawentyaari Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Eejatzi piyoteeyakironi iroka nokantemiri: eero pipashiwentakaana, aririka pikamanteeyerini paashinipaeni atziri paapatziyakina, aritaki nokamantakiri Pawa eejatzi ronampiripaeni janta jenokinta pisheninkatakina. Tema naaka poñaachari jenokinta, nokoñaatapaaki jaka kipatsikika. ");
INSERT INTO cjoNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Omaanta pipashiwentakayenarika jaka kipatsiki, eejatzi eerori nopashiwentakayemi naari janta jenokinta iinja. ");
INSERT INTO cjoNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Aririka ikantzimatena atziri, ari imatero Tajorentsi ikaminthayeri, aririka raapatziyeena iinja, eero ikenkithashireero ranteeyirini. Omaanta aririka ikantzimateeyeroni Ishire Tajorentsi, eero ikaminthayimaetari Tajorentsi. Tema tee ikoyi rirori raapatziyena. ");
INSERT INTO cjoNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Aririka ragaetemi janta pankotsiki ipiyotantapiintarira joriiyopaeni, eejatzi janta kantakowenantatsiriki, eejatzi janta jewatatsiriki, eero pithaawanteeyarini. Eero pikenkithashiryaashitapiintawo: “¿Iitaka nokanteriri?” ");
INSERT INTO cjoNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Aririka ragaetemi, ro iyoteemini Ishire Tajorentsi oetarika pikanteriri. ");
INSERT INTO cjoNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Roojatzi ikantakiri apaani shirampari Jesoshi: —Iyotaanari, ipanakirini pawani yeeyika maawaeni tzimimoeyawitaririni. Tekatsi ipena naari. Pikanteri yeeyi ipagaanteena naari rowaagawo. ");
INSERT INTO cjoNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Rakanakiri: —Eero nokantziri. ¿Naakama kantakowenantatsiri, nokanantyaariri pirentzi? ");
INSERT INTO cjoNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Roojatzi ikanteeyirini maawaeni piyotawenteeyakaririni: —Kyaaryoowa: piñaawenaperotawokari rashitayitarini paashinipaeni, eero oweshiryaaperotakayimi. ");
INSERT INTO cjoNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Roojatzi roshiyakaawenantakanari, ikantziri: —Eenitatsi iipatsite ashaagantzinkari. Osheki onintzi pankirentsi kameetha oshookayitanakini iwankiripaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Monkaatapaaka rowiitantyaawori okithokipaeni, ikempoyaantyaaworimi opankokipaeni roori, omaanta iroñaaka yeekitapaaki. Tee omonkaatapaakawo paashini. ");
INSERT INTO cjoNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ikenkithashiryaaka ikantzi: “¿Tsika nokanteroka? Tekatsi nowantyaawori maawaeni. Jaa, niyotaki iroñaaka tsika nokantero: noshiryaakaantero pankochaanikira, nantakaantee antawopero pankotsi nowantyaawori maawaeni nowankiripaeni, eejatzi maawaeni nowaagawo. ");
INSERT INTO cjoNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Oshekitaki iroñaaka maawaeni, tekatsi koetyeemoteenani. Ojamani okantya, eeroota othonkitaa nowanawo; iroñaaka nomakoree osheki ojarentsi, eero nantawaetzitaa. Iroñaaka nowapiintya, noshinkitapiintya, niweshiryaawentyaawo maawaeni tzimimotanari”. Rootaki ikenkithashiryaakari ashaagantzinkari. ");
INSERT INTO cjoNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Omaanta ikantzi Tajorentsi: “Tee piyotakota. Iroñaaka tsiteniriki pikame, roojatzi ¿ninkarika ashiteeyawoni maawaeni tzimimoeyawitzimirini?” ");
INSERT INTO cjoNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ñaakiro, tee riyotzi maawaeni kowawitachari roshekeero rowaagawo jaka kipatsiki. Okameethawita ijeekimi kameetha ijeekanteeyaarimi iinja janta jenokinta. Tema rootaki ikowakiri Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Eejatzi ikantakiri Jesoshi riyotaanewo: —Eero pikenkithashiryaakoperotapiintawo tsika paye poyaari eejatzi pikithaatyaari. ");
INSERT INTO cjoNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Tema rirotaki Tajorentsi owañaakimiri. ¿Opomeentsitzimotarima iroñaaka ipemi poyaari eejatzi pikithaatyaari? ");
INSERT INTO cjoNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Pikenkithashiryaakotyaari tsika ikantari tsimeri jenokiweripaeni: tee ipankitaanta eejatzi tee ikempoyaanta rowanawo pankotsiki, omaanta ipapiintziri Tajorentsi royaari. Pamine, ikempoyaawenteeyakirini irira tsimeripaeni jenokiweri tema eejatzi eerori ari ikimitemi. ");
INSERT INTO cjoNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Iitaka patsipetashitantawori pikenkithashiryaapiintawo oetarikapaeni? ¿Piitzima aririka pikenkithashiryaapiintawo eekiro piyaatatyee pantaripenthakiitanaki? Eerotaatyaami. Eejatzi ¿arima pimatakiro pojanthayero pañaantari? Eero pimatziro. ");
INSERT INTO cjoNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ñaakiro, patsipetashitakawo pikenkithashiryaapiintawo. Tekatsi paye. ");
INSERT INTO cjoNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Pikenkithashiryaakotyaawo tsika okanta oteyakipaeni. Tee othamaetaanta, eejatzi tee ontyaanta oethaari, omaanta okameethaperotaki. Paerani osheki rowaneenkatani Sharamooni, omaanta tee ikimiperotawo oteyakipaeni: anaakotakiri, okameethaperotaki irowa. ");
INSERT INTO cjoNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ñaakiro, rowaneenkatakiro Tajorentsi oteyakipaeni inchashi. Eechonkiini ojeekawita, omaanta intsipaete ojampiyanee. Omaanta eerokapaeni ojamani pijeeki: tema piyotzi ikenkithashiryaaperotakimi eerori. ¿Iitakakya pitheenkantakariri? ");
INSERT INTO cjoNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Eero pikenkithashiryaapiintawo oetarika poyaari, eejatzi oetarika pireri: ikemakayemi Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Tema rootaki rantapiinteeyirini kaari yotziri Tajorentsi ikenkithashiryaapiintawo oetarika rowapiinteeyaarini. Omaanta eeroka, riyotzitakimiro Pawa Tajorentsi maawaeni koetyeemotakimiri. ");
INSERT INTO cjoNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Eerokapaeni pityaawo pikenkithashiryaakoperoteri Tajorentsi eejatzi pipinkathataperoteri irira, aritaki ipakimiro maawaeni koetyeemotakimiri. ");
INSERT INTO cjoNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Niyotaanewo, osheki inintaperotakimi Pawa Tajorentsi: ikowaperotaki ipinkathariwenteeyemini, ikaminthaaperoeyemini. ");
INSERT INTO cjoNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Pipimantero pashitayitarini, pipayiterini ashironkaenkari owinawo. Aritaki ipinatakimi Tajorentsi janta jenokinta. Ojeekaperote powaagawo janta: eero opathagae, eero opitsitee, eero ikoshiteeteemi, eero rapeyeero kaero. ");
INSERT INTO cjoNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Aririka ojeeki powaagawo jaka kipatsiki, osheki pikenkithashiryaakiro jeekayitatsirini kipatsikika. Omaanta aririka ojeeki powaagawo janta jenokinta, aritaki pikenkithashiryaakopiintakiri Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Eekiro riyaatatzi ikanteeyakirini Jesoshi riyotaanewo: —Paamagaeyaarini piwinkatharite, piwetsikashireeyaani. Pikimitakotyaari riraga ronampiri ashitawori ipanko. Riyaataki riraga ashitawori iñeeri isheninka raye iina. Raamagaeyaarini ronampiripaeni janta ipankoki. Aririka rareetapaeya ikowapae rashitaryaawaeniri, eejatzi ikowapae iñaapaero owetsikayitakani kameetha. Aririka otsitenitanee, ikowaki oorentya ipanko. Eejatzi ikowaki ikakite ronampiripaeni, ramitakotantawaeyaariri onampitariri. ");
INSERT INTO cjoNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Aririka iñaapaeri riwetsikaeyakani, ikimoshireeyanakini maawaeni. Riraga ashitawori ipanko ijeekakagaeyerini maawaeni ronampiripaeni, rowakagaeyapaeyaarini. ");
INSERT INTO cjoNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Omawitya tee riyoteeyawityaani tsika okaatzi ipokanteeyaari: aririka niyanki tsiteniri, rooma rootzimateentsirika okitejite. Omaanta roojatzi iñeeyapaerini ronampiri riwetsikaeyakani maawaeni, ari ikimoshireeyanakini irirapaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Piyotakoteeyakironi iroka nokamantemiri: aririkami riyotemi ashitawori ipanko rooteentsi ipoke tsiteniriki koshitantatsiri, tema aritaki ikakitakimi, eero imatziromi ikoshiterimi. Omaanta tee riyotzi tsikarika okaate ipokantyaari koshintzi. ");
INSERT INTO cjoNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Eejatzi nokimitawitari koshintzi, tee nokamantzimi tsikarika okaate nopokanteeyari. Paerani nopoñaaka jenokinta, nokoñaatapaaki jaka kipatsikika. Iinja nopiyaate eejatzi. Pikenkithashireeyenani, paamagaeyeenani: nomapokapaemikari. ");
INSERT INTO cjoNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ikanta rojampitakiri Peetero: —Nowinkatharite, ¿apatziroma poshiyakaawenteeyanawoni naakapaeni kameetha? Eejatzima rirori, ¿pikowakima poshiyakaawenteeyerini maawaeni atziri kameetha? ");
INSERT INTO cjoNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Rakanakiri: —Nokenkithatakagaeyatziirini maawaeni kyaaryoowentzirori nokowakagaeyakiririni. Ikimitaka iwaatorote atziripaeni, ikowakaakiri apaani ronampiri ikyaaryoowenteniri rowakaapiintyaari paashinipaeni ronampiripaeni. Roojatzi riyaatantaka iwaatorote tsikarika. ");
INSERT INTO cjoNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Aririka rowakaapiintakyaari kameetha, ipokaerika iwaatorote, riweshiryaawentapaakyaari. ");
INSERT INTO cjoNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ikantapaakiri: “Kameetha pimonkaatakinawo. Iroñaaka eeroka amineeyenaworini maawaeni tzimimotanari”. ");
INSERT INTO cjoNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Omaanta, ikantatyeerimi riraga ratzirite: “Eero ipokitaa nowaatorote”. Apatziro ipoñaanaka ikijakijaatanakiri onampirentsipaeni, ipajapajaatakiri: shirampari, tsinani, maawaeni. Iperataka osheki, ishinkishinkitashitaka. Omaanta tee imonkaatziniri ikowakaawitanakariri iwaatorote retakotyaarimi paashinipaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Paashiniki kitejiri ipokae iwaatorote, romapokapaeri. Rowajankitaapaakiri ronampiri, ikimitakaanteri paashinipaeni kaari monkaateroni ikantawitanakariri. ");
INSERT INTO cjoNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ñaakiro, riyotawitakawo ronampiri ikowakaayitawitakaririni iwaatorote, omaanta tee ikemijantaperotziri, tema rootaki ipajatakaanantyaariri, tema osheki ipajapajaatakaantaperoteri. ");
INSERT INTO cjoNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Omaanta eero rowajankitaaperotziri kaari yotzinkari. Tekirarika riyoteeri iwaatorote oetaka kameethatatsiri ranteri eero ipajatashitari osheki. Omaantakya riraga yoperowiteenchari rirotaki ipajeeteri kameetha. ");
INSERT INTO cjoNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Eejatzi ikantzi Jesoshi: —Atayerorika owantsi, taanaka maawaeni. Okimiwitaka iroka, nopokakika jaka kipatsikika nokenkithatakagaeyakirini maawaeni atziri iñaani Pawa, eejatzi nokamawenteri. Apaanipaeni raapatziyawakawo omaanta paashinipaeni tee raapatziyawo inta ikijashitawakina roojatzi rowamaantakinapa iinja. Nokowakaawitakari ranteromi iroñaaka. ");
INSERT INTO cjoNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Osheki nokenkithashiryaakotaka iroñaaka: rooteentsi nokemaatsiperotyaawo katsiri. ");
INSERT INTO cjoNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Piitashiteeyawitanima nopokashiteeyakirini atziri nomaerinteeyerini, kameetha raakameethatawakaantyaari? Teewee, omaanta ikijawakaanteeyenani. ");
INSERT INTO cjoNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Apaani pankotsi ijeekantyaaworika apawakooni atziri, riraga 3 ipoñaashitanakya ikijanakiri riraga paashini apitera. Riraga apitera ipiyatakotzitanakyaari rirori. ");
INSERT INTO cjoNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Apaani atziri ikijanakiri itomi, eejatzi itomi ipiyatzitanakyaari iriri. Tsinani okijanakiro ishinto, eejatzi rowaga ishinto opiyaatzitanakyaawo iniro. Tsinani okijitanakawo ewatyeero opiyatakotzitanakyaawo ayiiro. ");
INSERT INTO cjoNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Roojatzi ikanteeyirini piyotawenteeyaririni: —Aririka piñaakiro antawo tampyaa amakiro menkori otsitenipithatanaki, pikanteeyini: “Kaakitaki inkaniwee”. Tema piyoteeyakini opariyatye inkani. ");
INSERT INTO cjoNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Aririka piñaakiro opiteyaryaanaki piyogo, pikanteeyeni: “Rooteentsi oniyankite ojarentsite”. Tema eejatzi piyoteeyakini. ");
INSERT INTO cjoNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Amatawitantaniri! Piyotakoeyawitawoni tsikarika okantya jenoki, eejatzi kipatsi. Tema piyoteeyakini opariyatyeerika inkani. Omaanta tee pikowaeyini piyoteeyeni opomeentsitzimoteeyemini iinja. ");
INSERT INTO cjoNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","¿Iitaka kaari pikantakotantari okaatzi kyaaryooperotatsiri? ");
INSERT INTO cjoNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Aririka raakaanantemiri atziri koriki pireewitziriri, aririka raanakimi kantakotantatsiriki. Tekiraatarika rareetakayemi, piwetsikaeri pikanteri: “Eero pikijana, ari nopinateemi iinja”. Rooma eerorika pikantziri rootaki romonkyaagakaanantemiri omonkyaagamentotsiki. ");
INSERT INTO cjoNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Aririka romonkyaakimi, ipinatakaaperotakimiri maawaeni koriki okaatzi pireewitziriri. Eerorika pipiri, eero roemishitowiteemi. ");
INSERT INTO cjoNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Roojatzi ipokaki paashini atziripaeni, ikamantapaakiri Jesoshi: —Riyaateeyawitakani karireeyajatzipaeni janta Jerojareeki rowamaenirimi Tajorentsi ipira. Riraga kaaripero Peraato rowamaakaanteeyakirini karireeyajatzipaeni janta okaankiitziira ipankoki Tajorentsi, tsikarika rowamaapiintzinirinta ipirapaeni. Ari rowamaakiri itsipatakari eejatzi ipirapaeni. Riraa atziri otsipateeyanakawoni rashira ipira. ");
INSERT INTO cjoNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Rakanakiri Jesoshi: —¿Piitakaakirima riraga karireeyajatzi rirotaki antaperoeyakirorini kaari kameethatatsi ishinetantakariri Tajorentsi rowamaakaanantakariri Peraato? ");
INSERT INTO cjoNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nokamantemi: tee ro ikamantari. Omaanta eerokapaeni, kyaaryoowa: eerorika pikenkithashiryaa, eejatzi eerorika pookaero kaari kameethatatsi pantapiinteeyirini, aritaki pikimiteeyakyaarini riroripaeni pithonkakya. ");
INSERT INTO cjoNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Eejatzi paerani otziroryaantakari antawo mapipanko janta Shiroeki, atsinakaeyakirini 18 shirampari, ikamaeyakini. ¿Iitaka ikamaeyantakarini? ¿Rantaperotakitziiroma kaari kameethatatsi ikamaeyantakarini? ");
INSERT INTO cjoNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nokantzimi: “Tee”. Tema ikimiteeyakarini maawaeni paashini atziri. Eejatzi nokantzimi eerori, pikimityaari riroripaeni eeromi pikenkithashireeyaani, pookaero kaari kameethatatsi pantapiinteeyirini. Eerorika pantziro iroka eerokapaeni, aritaki rotyaantakimi paamariki kaari tsiwakanitatsini. ");
INSERT INTO cjoNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Roojatzi roshiyakaawenteeyantakanarini iroka, ikantzi: —Ipankitakiro atziri iyeera janta roowamashiteki. Ojamanitaki ojeekaki, tee okithokitzi. Riyaatapiintawita raminee okithoki, rowiitemi: omaanta tee okithokitzi. ");
INSERT INTO cjoNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Roojatzi ikantziri riraga thamaetziniriri: “Pamine, okaataki 3 ojarentsi nopokapiintawitaka nowiitemi okithokipaeni, omaanta tee okithokitzimaeta eechonkiini. Aminashita okatziya. Pichekero, nopankiteeta oetarikapaeni kameethatatsiri”. ");
INSERT INTO cjoNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Rakanakiri thamaetziniriri: “Ari okantawakaata iroñaaka iroka ojarentsika. Noshewatawakiroota kipatsi amethopanetantanakyaari, eejatzi nowapiinteniro itziya pipira, kameetha otzimantyaari okithoki. ");
INSERT INTO cjoNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Rooma okithokitakirika paashini ojarentsi, tema kameetha eerokya achekiro. Rooma eerorika okithokitzi, roojatzi nochekantakyaawo”. ");
INSERT INTO cjoNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Paashiniki saawaro riyotaantaki Jesoshi janta pankotsiki ipiyotantapiintarira joriiyopaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Eenitatsi janta pankotsiki apaani tsinani kyaantawitawori paerani kamaari itsiyajoemitzitakaakiro. Okaatakotaki 18 ojarentsi otsiyajoemitziwitaka, ashi owakiro otsiyajoemitzitaki: tekatsi okanteeya otampatsikatanteeyaari. ");
INSERT INTO cjoNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Iñaantakawori Jesoshi, ikaemakiro: —Pipokanaki, iroñaaka netsiyatakoteemi. ");
INSERT INTO cjoNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ipampitawakiro, roojatzi awijakotantanaa. Kameethatanee, okatziyanaa. Okantanaki: —Retsiyatakotaana Tajorentsi, tema ikameethaperotaki. ");
INSERT INTO cjoNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Riraga jewawentzirori janta pankotsiki ipiyotantapiintarira joriiyopaeni ikijanakiri Jesoshi. Ikanteeyanakirini piyoteeyeencharini: —Okameethatzi antawaeteeyeni 6 kitejiri, omaanta aririka omonkaatapaakya kitejiri 7 okameethatzi amakoryaaperoeyanakini. Eero antawaetzimaetantawo. Aririka pikowaki petsiyatakoeyeeni, pipoke paashiniki kitejiri, eerokya pipoki saawaroki. ");
INSERT INTO cjoNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ipiyawaantetanakari Awinkatharite, ikantanakiri: —¡Amatawitantaniri! Osheki pamatawitantashitaka. Tema pantawaeteeyini eeroka saawaroki. Pamine, aririka imiritaki piwaakate saawaroki, tema ari pithatakoryaakoteri paanakiri janta ojeekinta iñaa. Eejatzi pikimitziri piwoorote, maawaeni. Kyaaryo, pineshironkateeyirini pipirapaeni saawaroki. ");
INSERT INTO cjoNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Omaanta kaari pipira iroka tsinanika, inta pijoriiyotzinkawote. Paeranitaki ikyaantawitakawo kamaari kimitaka othatakotaka roori: tema okameethataki akaminthayero saawaroki, etsiyatakoteero. ");
INSERT INTO cjoNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ikemantawakawori iroka, ipashiwenteeyanakani maawaeni kijeeyakiririni Jesoshi. Omaanta riroripaeni paashini atziri riweshiryaawenteeyanakarini Jesoshi, ikanteeyanakini: —Okameethateeyakini rantayitakirini Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Roojatzi ikantzi Jesoshi: —¿Piyoteeyinima tsika ikanta Tajorentsi ipinkathariwenantzi? ¿Tsika nokanteroka noshiyakaawenantemirori? ");
INSERT INTO cjoNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Oshiyakawo okithoki moshitaaja ipankitziri shirampari rowaneki. Oshookanaki, okimotatanaki, oshiyawitakawo inchato. Rookantapiintakawo tsimeri jenokiweri imakoryaantapiintawo owaempekikipaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Rapiitakiro, ikantzi: —¿Tsika nokanteroka noshiyakaawenantemirori tsika ikanta Tajorentsi ipinkathariwenantzi? ");
INSERT INTO cjoNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Okimitakawo tsinani aakiro tapiyakaawori paa eechonkiini. Otsipataakiro osheki teriikopane otapiyantanakari. Oshineeyakaanakiro maawaeni, roojatzi antawotantanaka. Eejatzi ikimita riraga atziri. Eenitatsirika apaani antzirori kaari kameethatatsi, rantakagaeyerini paashinipaeni atziri rantero kaari kameethatatsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ikantaka ikinakinayitakini Jesoshi nampitsikipaeni, riyotaantayitzini. Roshiretakawo riyaate Jerojareeki. ");
INSERT INTO cjoNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Rojampitakiri apaani: —Nowinkatharite, ¿tsika ikaateeyinika awijakoeyaatsini? ¿Arima ikaate apaanipaeni? Rakanakiri: ");
INSERT INTO cjoNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Noshiyakaawentemiro. Okimiwitakawo okaatzini omoo akyaantyaari jenokinta. Eenitatsi osheki kowawitachani riyaatemi jenokinta, omaanta eero imatziro rareeta. Pipomeentsiwentyaawo pareetantyaari janta. ");
INSERT INTO cjoNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Eejatzi okimiwitakawo rantziri ashitawori ipanko. Ijeekaki inthomaenta rirori, rashitakotaka, riyaawitakiro ashitakontsi. Roojatzi pipokaeyantawitakyaani eerokapaeni, pikantawitapaakyaari: “Nowinkatharite, pashitareenawo, nokyaantyaari”. Omaanta ikantawakimi: “Tee niyoteeyimini tsikarika pipoñaa”. ");
INSERT INTO cjoNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Roojatzi pikanteeyawitanakyaarini: “Paerani pitsipateeyakinani nonampiki owaeyakani, eejatzi piyotagaeyakinani”. ");
INSERT INTO cjoNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Aritaki ikantemi: “Tee niyotzimi. Piyaatee, pipiyanee tsikarika pipoñaaka. Osheki pantayitzironi kaari kameethatatsi. Tee pikameethatzi”. ");
INSERT INTO cjoNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Piñaantakariri Awaraama, Ijaaka, Jakoowo, maawaeni riraga kamanantzirorini iñaani Tajorentsi ijeekaki jenokinta, omaanta eerokapaeni, roepiyawaemi Tajorentsi, eero pimateeyironi pikyaapae. Roojatzi osheki powashiretaperotanakya, piraaperotanakya eejatzi patsikaekiteeyanakyaani, tyakiririri. ");
INSERT INTO cjoNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ipoñeeyapaakyaani aapatziyariri Tajorentsi intatsikeronta, jakakiroka, katonko, kirinka, maawaeni kipatsikipaeni. Ijeekaeyapaakini janta ipinkatharentsitzinta rirori. ");
INSERT INTO cjoNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Rareetaperoteeya riraga pitheenkaeyakirini. Omaanta riraga pipinkathateeyawitakarini eero rareeteeyaani rirori: ashi rowaeyeroni ijeekaeyanakini jaka. ");
INSERT INTO cjoNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Roojatzi ipokantaka apaanipaeni warijeeyo. Ikantapaakiri Jesoshi: —Piyaate paashiniki kipatsi. Ikowaki Erooreshi rowamaakaantemi. ");
INSERT INTO cjoNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Rakanakiri: —Pikamantakiteri riraga amatawitantatsiri: “Ikantzi Jesoshi: ‘Eero noshiya. Nokantyaani nowawijaakoeyeriniita kyaantawitariri kamaari eejatzi mantsiyaripaeni: iroñaaka, inkaamani, eejatzi paashini kitejiri. Roojatzi nomonkaatakiro maawaeni’ ”. Rootaki pikanteriri. ");
INSERT INTO cjoNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Rootaki nokinakinayitantyaarini iroñaaka, inkaamani, eejatzi paashiniki kitejiri. Eejatzi okameethatzi nokame Jerojareeki: tema janta aritaki ikamapiintzi kamanantayitzirorini iñaani Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Eejatzi ikantakiri Jesoshi: —Riraga jerojareejatzi osheki rowamaayitakirini kamanantzirorini iñaani Tajorentsi. Roshemyaapiinteeyakirini mapiki paashinipaeni rotyaantanewo Tajorentsi. Okimitziriranki tyaapa ojatewirinikitziri iryaanipaeni, eejatzi nokimiwitaka naaka osheki nokowawitaka nopiyoteeyerinimi jerojareejatzi: naapatziyakagaeyaarinimi iñaani Tajorentsi omaanta tee ikowaeyini. ");
INSERT INTO cjoNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Pamine, tekatsi amitakoterini iroñaaka, rookaeyirini Tajorentsi, ikantzi: “Ari ikantakaata”. Eero iñagaana eejatzi iroñaaka. Iinja, aririka nopiyee, ari iñaawaena, eejatzi ikanteeyeeni: “Tema ikameethaperotaki Rotyaantanewo Tajorentsi”. ");
INSERT INTO cjoNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Paashiniki saawaro riyaatanaki Jesoshi janta ipankoki jewatakagaeyiririni warijeeyopaeni rowakayaari. Paashini warijeeyopaeni inetapitakiri Jesoshi, ikowakowataki tsika ikantya ipoñaakaantyaariri ikantakowenantyaariri. ");
INSERT INTO cjoNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ijeeki janta apaani mantsiyari, ari inewootakiri riraga Jesoshi. Tema aawaayitakini maawaeni iwatha. ");
INSERT INTO cjoNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Rojampitziri riraga iyotaantziroripaeni Iwaperite Tajorentsi eejatzi warijeeyopaeni: —¿Okameethatzima etsiyatakoteri mantsiyaripaeni kitejiriki amakoreeyantarini? ");
INSERT INTO cjoNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Omaanta ari imaeriteeyanakini, tee rakaneentzi eechonkiini. Ipoñaanaka Jesoshi ikathatakiri mantsiyari, retsiyatakoteeri, roojatzi rotyaanantaari ipankoki. ");
INSERT INTO cjoNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Roojatzi ikanantakari riraga aminaperoeyakiririni: —Tema pantawaeteeyini eerokapaeni saawaroki. Aririka ipariyaki piwaakate omooki, tema ari pagaeri eejatzi. ");
INSERT INTO cjoNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Eejatzi imaeriiyanakini. ");
INSERT INTO cjoNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ikanta rotsikanateeyakarini Jesoshi riraga owaeyacharini riyoyagaeyakironi rooperori jeekamentotsi. Ikowaki ijeekimoteri okaakini riraga pinkathari iñaaperotantyaaririmi. Roojatzi roshiyakaawenteeyakirini Jesoshi: ");
INSERT INTO cjoNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Aririka rakiyotemi pijoriiyotzinkarite, eero pijeekantashitawo jeekamentotsi ijeekakerotzira pinkathari. Ari aamaashitya, rareetapaakyaarika paashini owakotyaarini pinkathariperotatsiri, ");
INSERT INTO cjoNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","roshirinkimikari paashiniki jeekamentotsi riraga kaemakaantakimiri, ikantzimikari: “Eero pijeeki jaka. Ijeekapaakiita rirori pinkathariperotatsiri”. Roojeekaemikari janta othapiki, tema ari pipashiwentanakya. ");
INSERT INTO cjoNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Omaantakya okameethatzi pijeekapaaki janta othapiki. Roojatzi aririka iñaakimi riraga kaemakaantzimiri, roojatzi ikanantakimi: “Pipokanaki jaka, niyompari, pijeekimoteri okaakini pinkathari”. Iñagaeyemini maawaeni owaeyeencharini itsipateeyakimini pinkathari. ");
INSERT INTO cjoNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Pikantakaaperotashityaarika eeroka apaniroeni pikowaki iñaaperotanteetemiri, ari ipashiwentakaakimi Tajorentsi: tekatsi ñaaperotaneemini. Omaanta riraga kaari kantakaaperotachani rirotaki iñaaperoteri Tajorentsi kameetha, itsipatantyaariri ipinkathariwenante. ");
INSERT INTO cjoNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Eejatzi ikantakiri Jesoshi riraga kaemakaantakiriri roya: —Aririka pikaemakaanteri atziri powakaanteeyaaririni, eero pikaemapiinteeyirini pisheninkaperopaeni eejatzi riraga ashaagantzinkaripaeni. Aririka powakaakyaari, ari rirori ipiyateemi, rowakagaemi iinja. ");
INSERT INTO cjoNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Omaanta okameethaperotzi pikaemakaantaperoterira riraga kaari ashaagantayitachani, riraga kijopookitatsiri, riraga kaari kokichaatatsi, maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Rooma paata rirori tekatsi ikanteemi ipiyateemi rowakagaeyeemini. Omaanta iinja ipiriinteeyeerini Tajorentsi maawaeni aapatziyeeyaririni. Roojatzi ipinaperoteemi rirori Tajorentsi. Eero patsipetashitawo pikaminthaantzi. ");
INSERT INTO cjoNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ikemantakariri apaani owaenchari, ikantanaki: —Tema okameethaperotaki ajeekae janta ipinkatharitzinta Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ikantawakiri Jesoshi: —Ikimitaka apaani shirampari ronkotsitakaantakiro osheki owanawontsi, roojatzi ikaemakaantakiri osheki atziri roya. ");
INSERT INTO cjoNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Onkotsiteeyakani maawaeni. Roojatzi rotyaantakiri ronampiri: “Piyaate, pikamanteeyerini: ‘Monkaataka, onkotsiteeyakani maawaeni, pipoke iroñaaka’ ”. ");
INSERT INTO cjoNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Omaanta tee ikowaeyini riyaateeyeni. Ikantzi apaani: “Owakira namanantakotaki noepatsite. Niyaate iroñaaka naminakitero, kameethatakirika. Pikamanteeri: ‘Eero ipoki rirori’ ”. ");
INSERT INTO cjoNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ikantzi paashini: “Owakira namanantakiri 10 waaka. Nokowaki naminakiteri kameethatakirika. Pikamantapaeri: ‘Eero ipoki rirori roya’ ”. ");
INSERT INTO cjoNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ikantziri paashini: “Owakira naaki noena. Tekatsi nokantya niyaate”. ");
INSERT INTO cjoNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ikantaka ipiyanaa riraga ronampiri rotyaantawitari. Ikamantapaeri: “Ikanteeyini: ‘Eero niyaatzi nowa’ ”. Roojatzi ikijantanaka riraga iwaatorote, ikantanakiri ronampiri: “Ikantakaata nosheninkapaeni. Iroñaaka piyaate janta pankotsikipaeni nampitsi, pikinayitanakini pikowakowayitakiterini riraga kaari ashaagantachani, riraga kijopookitatsiri, riraga aashetatzinkari, riraga kaari kokichaatatsi, maawaeni”. Roojatzi riyaatantanaka, ikaemaeyakitzirini, pokaeyapaakini. ");
INSERT INTO cjoNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ikantaka rareetapaa eejatzi, ikantapaeri iwaatorote: “Niyaatakitzi, nokamanteeyakirini. Areeteeyapaakani, omaanta tekiraata imonkaata”. ");
INSERT INTO cjoNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ikantakiri eejatzi: “Piyaatakite eejatzi janta, pikinayitanakini awotsikipaeni, pikaemaeyakiterini paashinipaeni ipokanakiita, nokowatzi riyeekitantaperoeyapaakyaawoni nopanko. ");
INSERT INTO cjoNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Omaanta riraga nosheninka nitawitakari nokaemakaantawitakari, eero royimaetawo iroka nonkotsitakaantawitakanariri”. Rootaki ikenkithatakagaeyiririni Jesoshi janta ipankoki warijeeyo. ");
INSERT INTO cjoNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ikantaka paashiniki kitejiri ikinanaki Jesoshi awotsiki eejatzi royaateeyanakirini osheki atziri. Ipithokashiteeyakarini, ikanteeyakirini: ");
INSERT INTO cjoNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Niyotaki pininteeyirini piripaeni, piniropaeni, piinapaeni, pitomipaeni, pirentzipaeni, pitsiropaeni, maawaeni. Eejatzi eeroka ninteeyachani apaniroeni. Omaanta pikowaeyakinirika poyaateeyenani, okameethatzi naaka pinintaperoeyenani kameetha. Eerorika pinintaperotana, tekatsi pikantya pipeyeeya niyotaanewo. ");
INSERT INTO cjoNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Eejatzi eerorika pipomeentsiwentaperotanawo nokowakagaeyakimirini, eejatzi eerorika poyaataperotana, tekatsi pikantya pipeyeeya niyotaanewo. Pikenkithashireeyaani tsikarika pikantyaari. ");
INSERT INTO cjoNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Okimitaka aririka ikowaki rantakaantero shirampari ipanko, rityaawo rojampiteri riraga wetsikenirini tsika okaate opinatya. Roojatzi raminantakyaari iyorikite monkaatakarika. ");
INSERT INTO cjoNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Eerorika ritawo raminiri tsika ikaatzi iyorikite imonkaatyaarika, aamaashitya aririka ikompitakyaawo. Apatzirorika imonkaatakawo otzinkamipankepaeni ari ikaatapaaki iyorikite rootaki kaari imatantawo ithonkakaantero. Roojatzi ishirontawentyaari atziri. ");
INSERT INTO cjoNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ikanteeyeni: “Pamineri, riwetsikakaantawitaka ipanko, omaanta tee ithonkakaantziro. Tee itzimaperotzi iyorikite, injii, injii”. ");
INSERT INTO cjoNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Eejatzi riraga pinkathari, aririka ikemakotakiri paashini pinkathari rotyaantakiri 20.000 joraaro rowayiritantyaariri. Aririka ikaate ijoraarote 10.000, tee riyoperotzi okameethatzirika romanatawakiri riraga pokatsini. Tema rityaawo ikaemaeyerini isheninkapaeni ikenkithawaetakagaeyerini riyotantyaari okameethatzirika romanatya roepiyantyaariri riraga pokashiterini. ");
INSERT INTO cjoNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Aririka ikanteeyakini isheninka: “Ari ranaakoeyakaeni, oshekiperotaki. Eero amatziro apiyatari”. Ikanteeyanakini: “Tekira rareeteeyaani, thame otyaante apaanipaeni asheninka rojampiteri oetarika ikowakoteeri eerokya rowayiritantee”. ");
INSERT INTO cjoNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Eejatzi pikimitya eeroripaeni: aririka pikowaki poyaatena, pityaawo pikenkithashireeya tsika okanteeyarini maawaeni tzimimoeyimirini. Pikenkithashiryaaperoeyakyaarinika: roojatzi pookaeyeeroni, poyaataperoeyanakinani naari. ");
INSERT INTO cjoNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","35","Nokowaki riraga aapatziyanari riyoteeri paashinipaeni atziri ijeekae kameetha, rooma eerorika riyoteeri, tee imatziro rantero nokowakaayitawitakaririni, ratsipetashitakawo ijeeki. Ikimitakawo tziwi kaari katyotatsini: tema tee okameethatzi, ookapiintziro. Pikenkithashiryaaperotero iroka nokanteeyakimirini piyotakoperotantyaawori. Rootaki ikanteeyakiririni Jesoshi oyaateeyiririni. ");
INSERT INTO cjoNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ijeekaeyini janta osheki joriiyo piyotziriri iyorikite ijoriiyotzinkarite eekiro ipiri riraga oroomajatzi. Ikaateeyakirini paashinipaeni antapiintzirori kaari kameethatatsi. Ikemijantapiinteeyakirini Jesoshi ikenkithatzi. ");
INSERT INTO cjoNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ikiñaanikowenteeyakirini riraga warijeeyopaeni eejatzi riraga iyotaantzirori Iwaperite Tajorentsi: —Tee okameethatzi iroka rantakirika Jesoshi: itsipatapiinteeyakarini kaari kameethatayitatsini, rowaeyani. ");
INSERT INTO cjoNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Roojatzi roshiyakaawenantakanari iroka Jesoshi, ikantakiri: ");
INSERT INTO cjoNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Pamine, ikaaterika powishate 100, ipeyakyaarika apaani, tema ari pookanakiri riraga 99 janta keshiiki, roojatzi piyaatantanakya janta teenta ijeeki atziri, pikowakowataateri peyeenchari. Pikowakowateeririka roojatzi piñaanteeyaari. ");
INSERT INTO cjoNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Aririka piñaapaeri, tema osheki pikimoshirewentapaeri. Tema ari pamaeri pinateeri, powapaeri janta ijeekaeyininta paashinipaeni owisha. ");
INSERT INTO cjoNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Eejatzi, aririka pareetapaeya pinampiki, tema ari pikaemaeyapaakirini pisheninka, pikanteeyerini: “Thame akimoshireeyeni: ipeyawitaka nowishate, noñaagaeri eejatzi”. ");
INSERT INTO cjoNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Eejatzi ikimita rirori Tajorentsi. Aririka ikenkithashiryagaeya apaani antzirori kaari kameethatatsi, rookaerorika rantziri, iroñaaka Tajorentsi ikanteri maawaeni jeekatsiripaeni jenokinta: “Thame akimoshirewenteeyerini”. Tema tee riro ikantakotziri riraga paashinipaeni kameethateeyatsirini. ");
INSERT INTO cjoNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Eenitatsi paashini ikantakiriri Jesoshi: —Paashini eejatzi noshiyakaawentemiro: eenitatsi tsinani oorikite, ikaatzi ikithoki 10. Aririka ipeyakya apaani, okowakowayiteerini. Aririka otsitenitanaki, oonthoteri ootamento, oñaantyaariri, eejatzi opishitaperotero pankotsi aminayiteerini otyaakitakiririka kipatsi. Okanta okowakowateeri roojatzi oñaanteeyaari. ");
INSERT INTO cjoNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Aririka oñaagaeri, okaemaeyerini osheninkapaeni, okanteri: “Thame pitsipateeyenani, akimoshireeyini. Noñagaeri eejatzi noorikite peyawiteenchari”. ");
INSERT INTO cjoNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Eejatzi nokamanteeyemini: eejatzi ikimitaka riraga Tajorentsi. Aririka ikenkithashiryagaeya apaani antzirori kaari kameethatatsi rookaerorika rantayitzirini, kimoshiretanaki Tajorentsi, eejatzi ronampiripaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Paashini eejatzi roshiyakaawentakiniriri Jesoshi, ikantzi: —Eenitatsi shirampari ikaatzi itomi apite. ");
INSERT INTO cjoNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Riraga impaetatsiri ikoñaatzi ikantakiri Iriri: “Pawa, nokowaki pipena iroñaaka kashetani powaagawo eejatzi piyorikite pipanakinari paata aririka pikamae”. Roojatzi ipakiri. ");
INSERT INTO cjoNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Paashini kitejiri ipimantanakiro rowaagawo ipawitakariri Iriri. Roojatzi riyaatanaki inteena, paashiniki kipatsi, raanakiro maawaeni jeekimotziriri. Janta riyaatakinta, tee ijeekapaaki kameetha, rootaki rapaatantakawori maawaeni rowaagawo eejatzi iyorikite. ");
INSERT INTO cjoNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Roojatzi ithonkatakotantapaaka, tekatsi jeekimotaneerini, eejatzi tee añaagaero rowaeyaarini. Osheki rashironkaawaetaka ewankarika, aaperotakiri itashe. ");
INSERT INTO cjoNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Rootaki ikinakinatantanakari ramini antawaerontsi. Ari iñaapaakiri ashitachari osheki ichaanchote. Ikantapaakiri: “¿Pikowakima nantawaetemi?” Ikantawakiri: “Jee, nokowaki paminenari nochaanchote”. ");
INSERT INTO cjoNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ikantaka raminawitanari ichaanchote, ipapiintziri rowanawo: rowaga oshiyawitawori otaki intsipa. Omaanta riraga ewankari tekatsi perini rowanawo, ikowawitaka rakiyoterimi chaancho, omaanta riraga ashitariri tee ishinetziri. ");
INSERT INTO cjoNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Roojatzi ikenkithashiryaanaka ikantzi: “Janta pawakinta ikaateeyini osheki ratzirite. Eeniro rowaeyarini maawaeni. Ikemapiinteeyani kameetha, eejatzi otzimagaantzi owanawontsi. Omaanta naaka jaka aaperotakina notashe, rooteentsi nokame. ");
INSERT INTO cjoNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Iroñaaka nopiyee janta pawaki, nokantapaeri: ‘Pawa, tema nopiyathatakimi tee nokemijantaperotziro okaatzi pikantawitakinari, eejatzi tee naapatziyari riraga Tajorentsi. Eenitatsi nantzimotakimiri. ");
INSERT INTO cjoNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Eero iroñaaka pitomintaana inta pikimitakayeena ponampiri, naaka thamaeteemironi powanipaeni’ ”. ");
INSERT INTO cjoNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Roojatzi ipiyanta, ikinanee awotsiki. Ikantanaa, rootaatsi rareeteeya ipankoki iriri. Ikanta irira iñiitawaari janta inteena, ikinapae. Osheki ikimoshiretanee, retakoshiryaawaari. Ishiyashitawaari, rawithakitawaeri, ithowootawaeri, ikaminthaaperotawaeri. ");
INSERT INTO cjoNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Roojatzi ikanantapaari itomi: “Pawa, tema nopiyathatakimi tee nokemijantaperotziro pikantawitakinari eejatzi nopiyathatakari Tajorentsi. Eeniro osheki nantani. Tee okameethatzi pitominteena iroñaaka, inta pikimitena ponampiri”. ");
INSERT INTO cjoNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Omaanta iriri ikaemakiri ronampiripaeni, ikanteeyirini: “Pishintsiteeyini paakitero kithaarentsi kameethari, pikithaateri notyomika. Eejatzi paakiteniri aniiyo, poyaankeniri rakoki. Paakiteniri ijapatote, pijapatotapaeri. ");
INSERT INTO cjoNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Eejatzi paakiteniri waaka ewonkiri, tzimaperotatsiri iyeenka, powamayeniri. Thame maawaeni akimoshirewentawaeri notyomi, owaeyaani maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Noetakaawitaka eero noñaagaeri, ikimitzimotakina kamawitaka. Omaanta iroñaaka kimitaka añaagae eejatzi, noñaagaeri. Ipeyawitaka, iroñaaka ipokae, añaayiteerini eejatzi”. Osheki ikimoshireeyanakini rowakagaeyakarini. ");
INSERT INTO cjoNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Eeniro paashini itomi, riraga jewataneentsiri rantaritzi, ikantanakawo, riyaatzi ithamaetzi janta owantsiki: tee iñaawaeri rirentzi rareetantapaari rirori. Ikanta ipokae, rokaakintapaawo pankotsi, ikemapaatziiri ijonkateeyini eejatzi iwaerateeyini. ");
INSERT INTO cjoNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ikaemapaakiri apaani onampirentsi, rojampitakiri: “¿Oetaka piwaeratawenteeyirini?” ");
INSERT INTO cjoNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Rakanakiri: “Areetapaa pirentzi. Rowamaakaantawakiniri piri waaka ewonkiri riraga wathantzi, rowakagaeyakarini maawaeni atziri. Osheki riweshiryaawentawaari pirentzi ipokae, kameetha rareetaa tekatsi oyerini”. ");
INSERT INTO cjoNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Roojatzi ikijantanaka rirentzi, tee ikoyi ikyaapae pankotsiki. Riyowanaki iriri, ikantawitawaari: “Pipokanaki, notyomi, pikyaapae. Piweshiryaawentawaeyaari pirentzi”. ");
INSERT INTO cjoNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Omaanta rakanakiri itomi: “Eerowa, pawa, nokoyi nokantemi. Paerani nantakimiro oetarikapaeni pikaminaakinari, tee nopiyathaneentzimi eechonkiini. Omaanta tekatsi pipaneentena naaka eechonkiini nowakaayityaaririni notsipamintharipaeni. Tee pipaneentana apaani chiiwo. ");
INSERT INTO cjoNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Inta riro pikowateekikya yeeyira piperi, riyaatapithawitakimi inteena ithonkitakimiri piyorikite; ipinayitakirorini tsinanipaeni imayempitziro. Iroñaaka ipiyapaaga powamaakiniri waaka wathantzi”. ");
INSERT INTO cjoNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Rakanakiri iriri, ikantanakiri: “Notyomi, akantatyaani kijokiro owawakaa. Eerokataki ashiteeyaawoni maawaeni owaagawontsika aririka nokamae. ");
INSERT INTO cjoNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Omaanta okameethaperotzi aweshiryaawentawaeyaari pirentzi. Okimiwitaka ikamaki, aetakawitaka eero añaagaeri eejatzi. Iroñaaka kimitaka añaagae eejatzi añagaeyeerini. Ipeyawitaka, iroñaaka añaagaeri eejatzi. Thame aweshiryaawenteeyaarini. Okimitaka iroka, ari ikimitee Tajorentsi aari inintaperotakae, ajeekimoteririka kameetha eejatzi eerorika ajeekimotziri kameetha”. ");
INSERT INTO cjoNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Eejatzi ikantakiri Jesoshi riyotaanewo: —Eenitatsi eejatzi ashaagantzinkari apaani kempoyaawitanariri iyorikite, maawaeni. Roojatzi ikamananteetakari ashaagantzinkari: “Ikoshitakimira riraga kempoyaawitzimiriri piyorikite”. ");
INSERT INTO cjoNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Roojatzi ikaemakiri, rojampitakiri: “¿Kyaaryooma iroka ikanteetakinari? ¿Pikoshitakina noorikite? ¿Iitaka pikoshitantanari? Iroñaaka poepiyeenari maawaeni noorikite, nokowaki pojankinatenawo iwaeropaeni maawaeni ireewitanari. Iroñaaka eero noshinetaneemiri eejatzi noorikite”. ");
INSERT INTO cjoNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ikantaka ikenkithashiryaanaka rirori: “Eero iroñaaka ishinetanaana nowaatorote nokempoyagaeniri iyorikite. ¿Tsika nokantyaaka iroñaaka? Tee noshintsiwathatzi nothamaetantyaari. Eejatzi nopashiwentaka nonethaakoteri atziri ipashitena koriki. ");
INSERT INTO cjoNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","¡Jaaa! Niyotaki iroñaaka oetaka nanteri. Iroñaaka nokaminthagaeyerini maawaeni ireewiteeyiririni nowaatorote, raakameethatanteeyenarini naari janta ipankoki: eero ishinetantana nowashironkaawaetya”. ");
INSERT INTO cjoNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ikanta ikaemaeyakirini maawaeni ireewiteeyiririni iwaatorote. Rojampitakiri riraga jewatapaentsiri ipokapaaki, ikantziri: “¿Tsika ikaatzika pireewitziriri nowaatorote?” ");
INSERT INTO cjoNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Rakanakiri: “Nireewitziri osheki oyeenka oriiwo. Okaatzi nireewitziriri yeekitachani 100 wiroo owaanini”. Ikantawakiri: “Jee, kyaaryo. Eeniro iroka paperi ojankinataka pireewitziriri. Payero paperika, pojankinateniri paashini, pikante: ‘Nireewitzimi 50 wiroo owaanini yeekitatsini oyeenka oriiwo’. Amatawiteriita nowaatorote”. Rakanakiri ireewitziriri “Jee, kameethataki”. ");
INSERT INTO cjoNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Roojatzi ishitowanee jewatapaentsiri, ipokapaaki paashini. Rojampitawakiri: “¿Tsika okaatzika pireewitziri nowaatorote?” Rakanakiri: “Osheki nireewitziri teriiko, okaatzi yeekitatsini koshitaariki 100”. Roojatzi ikantanakiri: “Eeniro paperika pojankinatakiniriri paerani nowaatorote. Kyaaryo, ari okaatzi pireewitziri 100. Thame amatawiteriita. Pookaero iroka paperika; pojankinateniri paashini, pikanteri: ‘Ari okaatzi nireewitzimi 80 koshitaari, yeekitatsini teriiko’ ”. Roojatzi rojankinatakiniri. ");
INSERT INTO cjoNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ikanta riraga iwaatorote riyotantanaka ramatawitakiri. Ikantanaki: “Tee okameethatzi ramatawitakina, omaanta osheki riyothanitzi tsika ikantya rayero koetyeemotakariri”. Kyaaryo riraga theenkantatsiri riyothanitzi ikenkithashireeya tsika ikantya rantero kaari kameethatatsi. Ari ikimityaami rirori riraga aapatziyariri Tajorentsi ikenkithashiryaaperotyaawomi rantero okaatzi kameethatatsiri ikoyiri Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Iroñaaka nokamanteeyemini: eenitatsirika piyorikite, pikaminthagaeyerini paashinipaeni, pipaeyerini koetyeemotariri rirori. Ari ipinaperoteemi eerori Tajorentsi iinja. Aririka pikamaeyakini, ari pookanakiro tzimimoeyimirini, omaanta raakameethateeyawaemini rirori janta jenokinta. Tema eenitatsi janta pijeekantyaari kaari thonkanitachani. ");
INSERT INTO cjoNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Eerorika pikoshitzi eechonkiini eero eejatzi pikoshitzi osheki. Omaanta pikoshiterika eechonkiini, eejatzi aritaki pikoshitaki osheki. ");
INSERT INTO cjoNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Aririka pikoshitayiteni oetarikapaeni, riyotaki Tajorentsi tee paapatziyari rirori: eejatzi eero isheninkatzimi, eero pimatziro piñiiro inampi. ");
INSERT INTO cjoNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Eerorika pamitakotantari atziri piyorikite itajonkawentawitakimiri Tajorentsi, ¿tsika ikantyaaka ipinatantawaemiri iinja janta jenokinta? ");
INSERT INTO cjoNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Eero pimatziro pantawaetziniri kameetha eenitatsirika piwaatorote apite. Omaanta apaani pinintaperotanaki, inta paashini poonanakyaari. Piweshiryaawentyaari apaani, omaanta riraga paashini, eero piweshiryaawentari. Eejatzi okimita iroka, aririka pikenkithashiryaakopiintyaari koriki, eero pimatziro poyaataperotziri kameetha Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ikanta ikemaeyantawakaririni warijeeyopaeni ikantakiriri Jesoshi, roojatzi ishirontawenteeyantanakaririni. Ikowaperotakiita rashaagantya osheki, rootaki ishirontawenantanakariri Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Roojatzi ikanantakari: —Pikowaeyawitakani iiteeyemini atziri pikameethateeyakini, omaanta riyoteeyakimini Tajorentsi. Iñaaperoeyawitakimini atziri, omaanta riyotaki Tajorentsi tee pikameethateeyini pajankaneki. ");
INSERT INTO cjoNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Paerani okameethatzini paapatziyakawoni rojankinarini Moeseeshi eejatzi riraga kamanantayitzirorini iñaani Tajorentsi. Omaanta areetapaaka iroñaaka Jowa, riraga kaawoshitakotziriri Tajorentsi. Paashini iroñaaka ikowakagaeyakimirini Tajorentsi. Riraga Jowa ritanakawo ikamanteeyakimini kameethatatsiri: rooteentsi ipinkathariwenteeyemini rirori. Ikowaperoeyawitakani atziri iñeeri. ");
INSERT INTO cjoNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Iinja opeyaneeya kipatsi eejatzi jenoki, omaanta eero opeyaa roori rojankinarini Moeseeshi: ikowaki Tajorentsi pikantyaani pikemijantero piyotantyaari pijeeki kameetha. ");
INSERT INTO cjoNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Tema okantzi: “Eero piñaathatzimotawo piina paashini tsinani”. Aririka pookaero piinapero pagaerika paashini tsinani, piñaathatzimotakawo piinaperoni. Eejatzi tee okameethatzi payero tsinani ookiriri oemi. ");
INSERT INTO cjoNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ikanta ikanteeyakirini Jesoshi: —Eeniwitacha shirampari ashaagantzinkari, osheki iithaari kameethamawotatsiri, osheki rowaneenkataka. Maawaeni kitejiriki rowakagaeyakarini isheninka owanawontsi pinaperotachari. ");
INSERT INTO cjoNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Eenitatsi eejatzi ashironkaaperotachari iitachari Raajawo. Ojonkayitakini ijoepaeni opathaakayitakirini. Ari ijeekapiintawita janta ikyaapiintzinta riraga ashaagantzinkari ipankoki. ");
INSERT INTO cjoNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Osheki rowashironkaawaetaka, aaperotakiri itashe. Ikowawita raperotayiteronimi rowanawo rowariyaayitzirini ashaagantzinkari jaawiki. Eejatzi riraga otsitzipaeni ithoyitapaakirini ipathaawokipaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Roojatzi ikamaki rirori. Riyaatashitakiri ronampiripaeni Tajorentsi, raawaeri, roojatzi raantanaari janta ijeekinta Awaraamani. Okameetheetyeenta osheki. Eejatzi ikamaki riraga ashaagantzinkari. Ikitateetakiri kipatsiki. ");
INSERT INTO cjoNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Osheki rashironkaaperotaka iroñaaka riraga ashaagantawitacharini janta jaawiki paamariki, osheki ikemaatsitakawo. Raminanaki janta ijeekinta Awaraama, iñaataatziiri eejatzi riraga Raajawo. ");
INSERT INTO cjoNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ikaemakotakiri: “Pawa Awaraama, petakotena. Pikanteri riraga Raajawo rowiinkeroota rakoempeki iñaaki, ipokeeta jaka ipitenkaatenaata nopaanteki iñaa. Oshekipero nashironkaaka jaka paamariki”. ");
INSERT INTO cjoNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Omaanta ikantakiri Awaraama: “Notyomi, pikenkithashireeya tsika pikanta paerani pijeekini kipatsiki. Kameetha pijeekawitani, omaantakya riraga Raajawoka osheki rashironkaawitakani. Tema iroñaaka kameetha ijeekapae rirori jaka, rooma eeroka osheki pikemaatsitakawo janta. ");
INSERT INTO cjoNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Eejatzi pijeekakotaki intatsikeronta impeeta, tekatsi ikinashitemi Raajawo. Eejatzi eerori, tekatsi pikinashiteri pipokantyaari jaka”. ");
INSERT INTO cjoNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Roojatzi ikanantakari: “Eerorika pimatziro pikaminthayena, nokowaki potyaanteeri Raajawo kipatsiki: janta ipankoki pawani. ");
INSERT INTO cjoNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Ijeekinta janta yeeyipaeni, ikaatzi apawakooni. Nokowaki ikamantapaeri, ipokikari rirori jaka. Paminena naari iroñaaka, osheki nokemaatsitakawo jaka”. ");
INSERT INTO cjoNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Roojatzi ikantziri Awaraama: “Eenitatsi rojankinarini Moeseeshi eejatzi rojankinarini paashini kamanantayitzirorini iñaani Tajorentsi. Rootaki raapatziyeeyaarini”. ");
INSERT INTO cjoNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ikanta rakanakiri: “Jee, eeniro naawita. Omaanta aririka iñagaeri kamaentsiri ipiriinteeya, aritaki ikenkithashireeyaneeyaani, rookaero kaari kameethatatsi ranteeyirini”. ");
INSERT INTO cjoNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ikantanakiri Awaraama: “Teerika raapatziyawo Iwaperite Tajorentsi, eero eejatzi raapatziyari kaminkari ipiriintawiteeyarika”. ");
INSERT INTO cjoNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ikanteeyakirini Jesoshi riyotaanewopaeni: —Nokamantemi: ikantyaani eenitatsi atziri antakagaeyeririni paashinipaeni atziri kaari kameethatatsi. Omaanta rowashironkagaeyerini Tajorentsi riraga antakayiriri paashinipaeni kaari kameethatatsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Aritaki rowashironkaaperoeyerini antakagaeyiririni eentsipaeni kaari kameethatatsi. Okameethawitami riteetyaarimi roojoteetenirimi mapi antawo ikentsiki rowiinkaeterimi. Rowiinkaetatyeeririkami tekatsi antakaaneerinimi eentsi kaari kameethatatsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Kyaaryoowa, pantakaerikari atziri kaari kameethatatsi. Eejatzi ikantakiri: —Aririka piñaakotakiri pisheninka rantero kaari kameethatatsi, pikenkithatakayeri. Aririka rookaero rantziri, pikaminthayeri, paakameethateeri. ");
INSERT INTO cjoNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Aririka ikijemi atziri, ikoshitemirika, ikantzimatemirika, oetarika. Omaanta aririka ikanteetemi: “Tee okameethatzi nantzimotakimiri, osheki nowashiretakota, eero napiiteero, pikaminthagaena pipeyakotenawo nantzimotakimiri”, ari nokowaki pikaminthayeri. Aririka osheki rapiiteero rantzimoteemiro, eejatzi osheki ikantemi: “Pikaminthayena pipeyakotenawo nantakiri”. Tema nokowakaakimi eejatzi osheki pikaminthayeri: eero pikijawentziri. ");
INSERT INTO cjoNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Riraga rotyaantanewopaeni ikantakiri Awinkatharite: —Nameentawitzimi, omaanta nokowaperotaki piyoteena nameentaperotantemiri. ");
INSERT INTO cjoNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Rakanakiri: —Pameentenarikami eechonkiini, pikowakirikami, pikanteri Tajorentsi iponchakireero inchatowa, rowiinkero janta inkaareki. Tema ari imatakimiromi, rowiinkaatemiromi. ");
INSERT INTO cjoNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Eejatzi ikanteeyakirini Jesoshi: —Okimitaka eenitatsi shirampari ratzirite. Ithamaetapiintziniri eejatzi raminapiintziniri ipira. Aririka ipokae ratzirite pankotsiki, ¿iitaka ikantawaeriri iwaatorote? ¿Arima ikantawaeri: “Pipoke, pijeekapae, powapaeya”? Eero ikantziri. ");
INSERT INTO cjoNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Tema ikantashitawaeyaari iwaatorote: “Iroñaaka ponkotsiwentapaena noyaari; eejatzi nomiriteri, pamakinawo. Aririka nokemapaakya, ari powanakya eerori”. ");
INSERT INTO cjoNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Eejatzi tee ikantziri: “Ariwee, pantakinawo”; tema rametakawo apatziro rantawaetapiintziniri iwaatorote. ");
INSERT INTO cjoNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Eejatzi eeroripaeni, okameethatzi pantapiinteeyinirini maawaeni ikowakagaeyakimirini Tajorentsi. Roojatzi okameethatzi pikante: “Apatziro nantakiniri ikowakaakinari. ¿Iitaka nokantakaaperotantyaari? Tekatsi okantya Tajorentsi ipinatantenari”. ");
INSERT INTO cjoNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ikanta rowaaganaa Jesoshi, ikinayitanakini okaakini oweyaantawonta Jamaaryaki eejatzi Karireeyaki. Roshiretakawo rareetya Jerojareeki. ");
INSERT INTO cjoNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Roojatzi rareetapaaka paashiniki nampitsi, iñeeyawakirini patheenkaripaeni, ikaateeyini 10. Ikatziyeeyakani eekitziroeni jaga. ");
INSERT INTO cjoNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ikaemakoeyawakirini: —Jesoshi, eeroka nopinkathateeyirini, petakoeyenani, petsiyatakoeyenani. ");
INSERT INTO cjoNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Iñaantakariri riraga Jesoshi, ikanteeyakirini: —Piyaateeyeni janta ijeekinta ñaanakowenantatsiri, poñaagapaeyaari. Ari ikemijantaperoeyakirini, riyaateeyanakini. Janta niyanki awotsi ari retsiyatakoeyaneeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Iñeeyantawaani etsiyatakoeyaneeni, ipiyanaa apaani janta Jesoshiki. Icheraaperotaki, ikantzi: —Tema ikameethataki Tajorentsi, retsiyatakotakina. ");
INSERT INTO cjoNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Rotziwerowashitapaakari Jesoshi, roeyotashitaperotakari, ipinkathataperotakiri, ipaasonkitaperotapaakiri. ¡Ipoñaa irika shirampari Jamaaryaki! ");
INSERT INTO cjoNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Roojatzi ikantakiri Jesoshi: —Tema ikaateeyini netsiyatakoeyakirini 10. ¿Tsikama paashinipaeni? ");
INSERT INTO cjoNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Apatziro irika paashinijatzitatsiri atziri ipiyashitapanaatana, ipaasonkitakina, eejatzi iñaaperotakiri Tajorentsi. Riroma asheninkaperopaeni naawita, tee ipiyapanaataa ipaasonkitantyaariri rirori. ");
INSERT INTO cjoNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Roojatzi ikantziri otziwerowashitakariri: —Iroñaaka pikatziyee, okameethatzi piyaatee. Pameentakari Tajorentsi, rootaki pawijakotantaari. ");
INSERT INTO cjoNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Riraga warijeeyopaeni rojampiteeyakirini Jesoshi, ikantziri: —¿Tsika okaate ipoke Tajorentsi ipinkathariwenteeyanteerini? Rakanakiri: —Aririka ipinkathariwenante Tajorentsi, omaanta eero piñaaperotziri. ");
INSERT INTO cjoNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Eero pimatziro pikante: “Eeniro jaka”, eejatzi: “Eeniro janta”. Kyaaryo, eero ikoñaataperotzi: okameethataki pipinkathashireeyerini maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Eejatzi ikanteeyakirini riyotaanewopaeni: —Tema naaka poñaachari jenokinta, nokoñaatapaaki jaka kipatsikika, omaanta eero nokantatyeeyaani kijokiro nowaeyeemini. Iinja pikowaeyawitaneeyaani piñagaenami eejatzi, omaanta eero piñagaana. ");
INSERT INTO cjoNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Eejatzi aririka ikanteetemi: “Piyapaa Jesoshi, ari ijeekapaaki janta”. Paashini ikanteetemi: “Ari ijeekapaaki jaga”. Omaanta kaarina naaka. Eero patsipetashitawo piyaatashitana. ");
INSERT INTO cjoNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Aririka omonkaataperotapaakya nopokanteeyari, ari piyotaperotawaena. Okimitaaganki aririka aamorenkiranki maawaeni jenoki morek, morek, eejatzi nokimitapaeya naari aririka nopiyee eero nomanapaa, eero pikompitawaana. ");
INSERT INTO cjoNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Omaanta nityaawo nokemaatsitayityaawoni osheki katsiri, eejatzi itheenkaeyenani atziripaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ikimitaka paerani ijeekantakari Noeni tema maawaeni paashinipaeni atziri itheenkaeyakirini Tajorentsi, eejatzi rantakiro osheki kaari kameethatatsi. Eejatzi ikimiteeya iinja atziripaeni aririka nopiyee naari riraga atziriperotapaentsiri, osheki itheenkaeyeenani rirori. ");
INSERT INTO cjoNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Rowapiinteeyani paerani, rirapiinteeyini, raapiinteeyironi iinapaeni, raakaayitakironi rishintopaeni oemi, paashini oetarikapaeni. Ari ikanteeyani, roojatzi rotetantanaka Noe ipitoki. Roojatzi opokapaaki antawo inkani, oonkanaka maawaeni kipatsi. Ikamaeyanakini maawaeni theenkantatsiri. ");
INSERT INTO cjoNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Eejatzi ikimiteeyakani isheninka riraga Roote, jeekaeyatsirini Joroomaki: rowapiinteeyani, rirapiinteeyini, ikinayitanakini riyomparitayitanakani, ipankitayitzironi rowayitarinipaeni, riwetsikayitzironi ipankopaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Omaanta ishitowantanakari Roote, rotyaantakiro Tajorentsi osheki paamari poñaachari jenokinta, itagaeyakirini maawaeni joroomajatzini. Theenkaeyatsirini rootaki ithonkanteeyakaririni Tajorentsi maawaeni, thoperee. ");
INSERT INTO cjoNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Aritaki okantyaari aririka nopiyee. Ijeeki osheki theenkantatsirini, eero ikenkithashiryaari Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Pamine, aririka omonkaatapaakya nopokanteeyaari, pijeekerika okaankiityeera pankotsi, eero pikyaapanaatzi pankotsiki paantapanaatyaawori powaagawo. Eejatzi, pantawaeterika powaneki, eero pipiyapanaata pipankoki paantapanaatyaawori powaagawo. ");
INSERT INTO cjoNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Kyaaryoowa pikimitawokari iinani Roote, pipithokakari eerori pitapiiki. ");
INSERT INTO cjoNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ninkarika kaari kowatsini ratsipewentena naaka omawitya ikamawentena eero riyaatzi janta ijeekinta Tajorentsi. Omaanta kowatsiri ratsipewentena naaka omawitya ikamawentena naari, ikanteetatyeeyaani ijeekimotena jenokinta. ");
INSERT INTO cjoNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Aririka nopokae, eenitatsirika apite atziri imayi imaamentoki. Apaani aapatziyanari rootaki naantaneeyariri notsipatanakyaari, omaanta paashini, eero naaneeri. ");
INSERT INTO cjoNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Otsipatawakayaarika apite tsinani otoonkiro shinki. Apatziro apaani aapatziyanari rootaki naantaneeyawori notsipatanakyaawo, omaanta paashini, eero naaneero. ");
INSERT INTO cjoNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Itsipatawakayaarika apite shirampari janta owantsiki, ithamaetzi. Apatziro apaani aapatziyanari rootaki naantaneeyariri notsipatanakyaari, omaanta paashini, eero naaneeri. ");
INSERT INTO cjoNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ikemaeyantakaririni riyotaanewopaeni, rojampitanakiri: —Nowinkatharite, ¿tsikama oñaaganteeyaaka iinja iroka pikantakinari? Rakanakiri: —Tsikarika ijeeki kaminkari, aritaki ipiyotawenteeyari tzijopaeni. Oshiyakaawentachari tzijo, tema iinja maawaeni aapatziyeeyanarini naaka aritaki ipiyotawenteeyenani. ");
INSERT INTO cjoNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Paashiniki kitejiri roshiyakaawenteeyakinirini eejatzi Jesoshi riyotaanewo. Ikowaki riyoteeri ikenkithatakaapiinteri Tajorentsi, ikyaaryoowenteeyeroni, eero ipakagaero. ");
INSERT INTO cjoNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ikanteeyakirini: —Eenitatsi janta nampitsiki riraga kantakotantatsiri, kaari pinkathatziri Tajorentsi. Eejatzi tee riyotzi ikaminthayeri atziripaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ari ojeeki janta nampitsiki apaani tsinani, kamaentsiri oemi. Iyaatashitapiintawitari riraga kantakotantatsiri, okantapiintawitari: “Pamitakotena, tee okameethatzi ikijapiintena riraga paashini shirampari”. ");
INSERT INTO cjoNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Tee ikowawita riraganki ramitakoteromi, omaanta ikenkithashiryaanaka, ikantzi: “Tee nopinkathawitari Tajorentsi, eejatzi tee nokoyi nokaminthayeri paashinipaeni atziri. ");
INSERT INTO cjoNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Omaanta osheki ashiiryaakina iroka tsinanika. Namitakoteroota, eerokya opokashitantanaana, eero ashiiryaanaana eejatzi”. ");
INSERT INTO cjoNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ikantanaki Awinkatharite: —Pamine, tee ikameethatzi riraga kantakotantatsiri nokenkithatakotakirika, omaanta ramitakotakiro iroka tsinani oñaashirenkapiintziriri. ");
INSERT INTO cjoNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Omaantakya riraga Tajorentsi, ikameethaperotaki. Aririka ikantyaani ramanapiinteri aapatziyanari ikenkithatakaapiinteri rirori, tema aritaki ramitakotakiri. ");
INSERT INTO cjoNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Kyaaryootaki iroka nokamantemiri: intsipaete ramitakoeyerini Tajorentsi maawaeni kenkithatakagaeyeririni. Omaanta aririka nopiyee jaka kipatsikika ¿arima roojatzi noñeeyapaemini pikantyaani pameenteeyenani, pikenkithatakagaeyirini Tajorentsi? ");
INSERT INTO cjoNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Paashini eejatzi roshiyakaawentakiri Jesoshi. Ikenkithatakotziri riraga kantakaaperotzinkari, riraga theenkaeyiririni paashinipaeni atziri. Ikantziri: ");
INSERT INTO cjoNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Riyaataki apite shirampari Tajorentsipankoki ikenkithatakayeri Tajorentsi. Apaani rirotaki warijeeyo, omaanta paashini piyotziniriri iyorikite joriiyopaeni eekiro iperikya oroomajatzi. ");
INSERT INTO cjoNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ikantaka ikatziyapaaka riraga warijeeyo, ikantawitapaakari: “Tajorentsi, ariwee, osheki nokameethataki naaka. Tekatsi nante, tee nokimitari riraga koshitantatsiri, riraga amatawitantatsiri, shirontayitaworini osheki tsinani. Eejatzi tee nokimitari irika ayitziriri atziri iyorikite. ");
INSERT INTO cjoNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nametakawo maawaeni tominko notzitapiinta apite kitejiri, eejatzi nopagaantapiintayitzimironi maawaeni naayitzirini. Naakirika 10 oetarika, apaani nopakimi”. ");
INSERT INTO cjoNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Omaanta riraga piyotapiintziniriri oroomajatzi iyorikite ikatziyaneentapaaka inteena. Tee ikantakaaperota rirori, omaanta osheki ipashiwentakaakawo rantayitzirini, rootaki kaari raminanta jenokinta, apatziro rompojashipaneetaka. Ikantzi: “Tajorentsi, pineshironkatena naari, tee nokameethaperotzi, eeniro osheki nantani”. ");
INSERT INTO cjoNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Nokamantemi, oshekini naawita rantani riraga shirampari, omaanta ikaminthaakiri Tajorentsi. Aririka ipiyee ipankoki riyotanaki iñaaperotakiri rirori ikameethatzi. Omaantakya riraga warijeeyo, tee ikimitari. Eero iñaaperotziri riraga Tajorentsi kantakaaperotachari. Omaanta riraga kaari kantakaaperotachani ipeyeeri pinkathariwenantatsini. ");
INSERT INTO cjoNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Okantaka tsinanipaeni amaeyakinirini Jesoshi eentsipaeni, okowaki ipampiteeyerini eejatzi ikanteri Tajorentsi ramitakotantyaariri. Omaanta iñaantawakawori riyotaanewo, ithañaakowitakawo eero amiri eentsitepaeni: tee ikowakaawityaari ipokashiteri. ");
INSERT INTO cjoNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Omaanta ikaemiri Jesoshi eentsipaeni, ikantakiri riyotaanewo: —Pishinetenari ipokashitenaata eentsipaeni. Eerowa pikatziyakari. Nokowaki ipokashiteenaata. Piñeeyakirini irikapaeni eentsika: tee itheenkaeyanani, inta rameenteeyakinani. Tema reewawenteeyirini Tajorentsi maawaeni kimiteeyaririni rirori. ");
INSERT INTO cjoNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Eejatzi, kyaaryootaki iroka nokamantemiri: maawaeni kaari oshiyarini eentsi riraga aapatziyanari kameetha, eero imatziri reentsitetari Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Paashini kitejiri riyaatashitakiri Jesoshi apaani iwinkatharite joriiyo. Ikantapaakiri: —Iyotaanari kameethari. Pikamantena: ¿oetakama nanteri nañaantyaari, nokanteetatyeeyaani? ");
INSERT INTO cjoNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ikantawakiri Jesoshi: —¿Iitaka pikanantanari: “Kameethari”? Tekatsi kameethatatsini, inta apatziro Tajorentsi ikameethatzi. ");
INSERT INTO cjoNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Piyotakoeyironi maawaeni ikaminaakaeri Tajorentsi: “Eero piñaathatzimotawo piina paashini tsinani, eero powamaantzi, eero pikoshitzi, eero pitheeyakotari paashini atziri, pipinkathateri piri eejatzi piniro”. ");
INSERT INTO cjoNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Rakanakiri: —Tema maawaeni iroka nomonkaatakiro: eenironi newankaritapaakini, roojatzi iroñaaka. ");
INSERT INTO cjoNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ikemantawakawori iroka, ikantanakiri Jesoshi: —Eenitatsi apaani koetyeemotakimiri eejatzi: pipimanteeyeroni maawaeni tzimimotayitzimirini, pipaeyerini ashironkaenkari owinawo. Aririka pimatakiro iroka, ojeeke osheki tzimimoeyeemirini janta jenokinta. Pipimantakirorika powaagawo, pipokanaki poyaataperotanakina. ");
INSERT INTO cjoNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ikemantawakawori iroka, osheki rowashiretanaka. Rooma ashaagantzinkaripero, tee ikoyi ipimantero rowaagawo, omaanta rompetakawo. ");
INSERT INTO cjoNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Iñaakirira Jesoshi rowashiretanaka, roojatzi ikantaki: —Opomeentsitzimotakari ashaagantzinkari ikowaki Tajorentsi ipinkathariwenteri. ");
INSERT INTO cjoNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Napiitemiro noshiyakaawentemiro: tema opomeentsitzimotakari riraga kameeyo roshinthateri imooki kithapi. Omaanta ashaagantzinkari opomeentsitzimotaperotyaari ikowaki Tajorentsi ipinkathariwenteri. ");
INSERT INTO cjoNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ikanta rojampitanakiri riraga kemawakiriri: —¿Arima? ¿Pomeentsitakama? ¿Ninkama materoni awijakotaatsini? ");
INSERT INTO cjoNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Rakanakiri Jesoshi: —Iroka kaari imatapiintzi atziri, omaanta imatakiro Tajorentsi rirori. ");
INSERT INTO cjoNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Roojatzi ikantakiri Peetero: —Iyotaanari, nookaeyakironi maawaeni tzimimoeyanarini noyaateeyantakimirini iroñaaka. ");
INSERT INTO cjoNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Rakanakiri: —Kyaaryootaki iroka nokamantemiri: tee patsipetashitawo. Aririka pookaeyeroni pipankopaeni, piinapaeni, pirentzipaeni, pitsiropaeni, piripaeni, piniropaeni, pitomipaeni, pishintopaeni: omaanta rootaki pookaeyantyaaririni pikowaperotaki ipinkathariwentemi Tajorentsi, eero patsipetashitawo. ");
INSERT INTO cjoNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Aritaki ipinatakimi Tajorentsi iroñaaka jaka kipatsikika, eejatzi ipinatawaemi iinja janta jenokinta: pikanteetatyeeyaani pañaaperotapae janta. ");
INSERT INTO cjoNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Riyoshiiteeyanakirini roojatzi ikaemantakari Jesoshi riyotaanewo 12, ikantakiri: —Pamine, iroñaaka aateeyeni Jerojareeki. Eenitatsi rojankinatakotzitakinarini paerani riraga kamanantayitzirorini iñaani Tajorentsi. Naaka poñaachari jenokinta, nokoñaatapaaki jaka kipatsikika. Iroñaaka janta Jerojareeki ari omonkaatya maawaeni rojankinatakotzitakinarini. ");
INSERT INTO cjoNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Raakaantena asheninka aari, rayena kaari yotziri Tajorentsi. Ishirontawenteeyenani, rowashironkagaeyenani, reewapootayitenani, ");
INSERT INTO cjoNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ipajapajaatena, rowamaena. Okaatapaakirika 3 kitejiri, nopiriintanee eejatzi. ");
INSERT INTO cjoNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Omaanta tee riyotakoeyawakironi oetarika ikanteeyawitakaririni, ikompiteeyawakawoni. ");
INSERT INTO cjoNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ikantanaka Jesoshi, ikinanaki awotsiki, rootzimateentsi rareetya nampitsiki iitachari Jerikoo. Ari ijeeki janta awotsinampiki shirampari kaari ñaantatsi, inethaakotapiintziri koriki awijayitatsirini. ");
INSERT INTO cjoNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ikemantawakari rirori ipokaeyapaakini osheki atziri, rojampitakiri paashini atziri: —¿Ninka pokatsiripaeni? ");
INSERT INTO cjoNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Rakanakiri: —Kaakitaki Jesoshi, riraga Najareetejatzi, royaateeyakirini osheki atziri. Ari ikinapaakawo jaka. ");
INSERT INTO cjoNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Roojatzi ikaemakotantawakari: —Jesoshi, eeroka icharineeteni Iraviirini. ¡Pamitakaajeetenatya naaka! ");
INSERT INTO cjoNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ikanteeyanakirini jewateeyiririni Jesoshi: —¡Pimaerite! Omaanta, eekiro ikaemanakitzi: —¡Jesoshi! ¡Pamitakaajeetenatya! ");
INSERT INTO cjoNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Roojatzi ikatziyantapaaka Jesoshi, ikantanaki: —Pamakinari. Ikanta ramaetakiri. Roojatzi rojampitawakiri: ");
INSERT INTO cjoNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Iitaka pikoyiri? Rakanakiri: —Nowinkatharite, nokowaki noñaantee naari. ");
INSERT INTO cjoNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ikantanakiri: —Aritaki piñaantee iroñaaka. Pameentakina, rootaki petsiyatakotantaari. ");
INSERT INTO cjoNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Aripaete iroñaaka iñaantanee. Roojatzi royaatantanakari Jesoshi, ikantanaki: —Iñaakagaana Tajorentsi, tema ikameethataki. Eejatzi ikimiteeyakarini maawaeni ñeeyakiririni, ikanteeyakini: —Tema ikameethataki Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Roojatzi ikinanaki riraga Jesoshi janta nampitsikinta iitachari Jerikoo. ");
INSERT INTO cjoNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ari ijeeki janta ashaagantzinkari iitachari Jakeeyo. Rirotaki riraga jewatakayitziririni maawaeni piyotapiintziniriri oroomajatzi iyorikite ijoriiyotzinkaritepaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ikowawita rirori Jakeeyo iñeerimi riraga Jesoshi, omaanta tee rantaripenthakiitzi: ikaamokokitziini. Oshekini atziri rotzikaakiri rootaki kaari imatanta iñeeri rirori. ");
INSERT INTO cjoNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Roojatzi ishiyantanaka, ranaanakiri maawaeni atziri reewatanaki janta awotsiki. ");
INSERT INTO cjoNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Roojatzi rateetantapaakawo inchato janta othapiki ikinanakinta paata Jesoshi. Rateetapaakiro inchato roojatzi raminakotawakiri riraga Jesoshi ikinapaaki jaawiki. Rareetantapaakariri, raminapaaki jenoki, roojatzi iñaantapaakari, ikantapaakiri: —Jakeeyo, intsipaete pojoonki. Ari noshiretakawo iroñaaka pipankoki. ");
INSERT INTO cjoNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Roojatzi intsipaete rojoonkanaka, ikantawakiri: —Jee, thameeta nopankoki. Osheki ikimoshirewentawakiri riraga Jakeeyo. ");
INSERT INTO cjoNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Omaanta ikijanaka amineeyakiririni, ikantzi: —Irira teera ikameethatzi. ¿Iitarikya riyaatashitantariri Jesoshi janta ipankokinta? ");
INSERT INTO cjoNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Niyanki awotsi riraga Jakeeyo raapatziyari Jesoshi, roojatzi ikantakiri: —Nowinkatharite, iroñaaka nopagaanteeyerini owashironkaenkari kashetani tzimimotanari. Eenitatsirika atziri namatawitakiri nokoshitakiri, noepiyeeniri maawaeni, eejatzi nopaeri paashini osheki. Okaatzirika apaani nokoshitakiri, nopaeri 4. ");
INSERT INTO cjoNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","10","Roojatzi ikantawakiri: —Iroñaaka kitejiri pawijakotaki. Iroñaaka pikimiperotari achariniiteni paerani Awaraamani, paapatziyakari Tajorentsi. Naaka poñaachari jenokinta nokoñaatapaaki jaka kipatsikika. Rootaki nopoñaantari jenokinta: naminaminatziri owashironkaenkari, riraga kaari yoperotziriri Tajorentsi, nokowaki nowawijaakoteri maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ikemaeyakironi atziripaeni ikantakiri Jesoshi. Eejatzi riyoteeyakini rooteentsi rareetya Jerojareeki. Iitashiteeyakani rooteentsi ipoke Tajorentsi ipinkathariwenante jaka kipatsiki, ");
INSERT INTO cjoNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","roojatzi roshiyakaawenantakanariri iroka, ikantziri: —Ijeeki apaani shirampari, pinkatharitawitachari. Tema ikaemakaantakiri paashini pinkathari janta paashiniki kipatsi. Ikantaka riyaatanaki, ipeyawakiri pinkatharipero ipinkathariwenantyaariri inampijatzipaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ikanta rootzimateentsi riyaate, ikaemakiri ronampiripaeni ikaatzi 10, ipaeyanakirini osheki koriki. Ikantakiri: “Irika korikika, osheki iwinawo. Nokowaki piyompariteeyantyaarini. Aririka nopiyee, naminapaeri tsika ikaatzi koriki paakiri”. ");
INSERT INTO cjoNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ikantaka riyaatanaki iitantyaariri pinkathari. Omaanta tee ikowaeyirini inampijatzipaeni ipinkatharite, osheki ikijeeyakirini. Rotyaanteeyawitakani apaanipaeni inampijatzi, ikantawitari riraga paashini pinkathari: “Tee nokowakagaeyirini ipinkathariwenteeyenani riraganki, tee ikameethatzi”. ");
INSERT INTO cjoNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Omaanta iitawakiri pinkathari, roojatzi ipiyantanaa ipinkathariwenantyaariri. Ikaemakaanteeyakirini ronampiripaeni: riraga ipaeyawitanakarini iyorikite. Rojampiteeyakirini: “¿Poshekyaakinarima noorikite?” ");
INSERT INTO cjoNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ari ikantapaakiri riraga jewatatsiri: “Pamine, iroñaaka noshekyaaperotakiri piyorikite. Apaani pipakinari, noshekyaaperotakiri, iroñaaka naaki 10”. ");
INSERT INTO cjoNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ari ikantanakiri pinkathari: “Kameethatakimi. Osheki piyotaki. Pikyaaryoowentakinawo eechonkiini okaatzi nokantakimiri. Iroñaaka noetemi pinkathariwenteroni osheki nampitsi, okaate 10. Pikyaaryoowentenawo pipinkathariwentero”. ");
INSERT INTO cjoNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ikantaka ipokapaaki paashini, ikantapaakiri: “Irika piyorikiteka. Pipakinari apaani, iroñaaka naaki apawakooni”. ");
INSERT INTO cjoNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Eejatzi ikantawakiri: “Iroñaaka pipinkathariwentero eeroka apawakooni nampitsi”. ");
INSERT INTO cjoNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Roojatzi ipokantapaaka paashini, ikantapaakiri: “Nowinkatharite, eeniro piyorikiteka pipawitakinari chapinki. Nokempoyaakimiri nowaañoerateki. ");
INSERT INTO cjoNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Osheki nothaawantakimi, niyotaki osheki pipinkatharitaki. Paapithatziri paashinipaeni rashitayitarini, eejatzi payitantziro okithoki kaari pipankitzi”. ");
INSERT INTO cjoNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Roojatzi ikanantanakari: “Tee pikameethatzi, tee pantanawo nokowakaawitakimiri. Pikantawitana: ‘Osheki pipinkatharitzi, paapithatziri paashinipaeni rashitayitawitarini, paayitzironi okithoki kaari pipankitzi’. Piyotawitakaga, rootaki nokijantakimiri iroñaaka. ");
INSERT INTO cjoNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿Iitaka kaari powantanari noorikite waankoki? Powakirimi janta, ari roshekyaanakyaami iroñaaka noorikite”. ");
INSERT INTO cjoNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Roojatzi ikanantakari riraga katziyayiteencharini: “Paapithateri noorikite. Piperi riraga agaentsiri 10”. ");
INSERT INTO cjoNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ikanteeyawitanakarini: “Nowinkatharite, eenitatsi oshekini iyorikite iroñaaka. ¿Iitakakya pipashitantyaariri paashini eejatzi?” ");
INSERT INTO cjoNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Rakanakiri: “Nokamantemi, itzimerika ashaagantachani, nopaeri paashini eejatzi. Omaanta riraga kaari ashaagantacha, naapithateeri rowaga tzimimotawitariri eechonkiini. ");
INSERT INTO cjoNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Eejatzi riraga kijakinari kaari kowakaawitenani nowinkatharite, pamaeyakinarini, naminakoeyemiriniita powamaeyerini”. Rootaki ikenkithatakagaeyakiririni Jesoshi atziripaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Roojatzi rowaaganaka eejatzi Jesoshi, riyaate Jerojareeki. ");
INSERT INTO cjoNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Rootapaentsi rareetyaawo nampitsi iitachari Wetejajee eejatzi Wetaaniya. Ari ojeeki janta tonkaari iitachari Oriiwomashi. Roojatzi rotyaanantaka riyotaanewo apite, ");
INSERT INTO cjoNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ikantakiri: —Piyaate janta nampitsiki, ari piñaapaakiri wooro ithatakotaka janta. Tekira ikyaakoetari. Pithataryaakotapaakiri, pamakinari. ");
INSERT INTO cjoNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Aririka rojampiteetemi: “¿Iitaka pithataryaakotantariri?” Pikanteri: “Ikowakiri Awinkatharite”. ");
INSERT INTO cjoNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Roojatzi riyaateeyantanakani apite, iñaapaakitziiri ikantakiriri Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ikanta ithataryaakotapaakiri. Roojatzi rojampitantanakari ashitariri: —¿Iitaka pithataryaakotantariri nowoorote? ");
INSERT INTO cjoNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Rakanakiri: —Ikowakiri Awinkatharite. —Ari, paanakiniri. ");
INSERT INTO cjoNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Roojatzi raantanakari janta Jesoshiki. Rowankitakiniri imitzikaaki iithaaripaeni ijeekantyaari Jesoshi, roojatzi ikyaakotantakari. ");
INSERT INTO cjoNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ikanta rowaagakotanaka janta awotsiki, ishitashiteeyakinirini atziripaeni iithaaripaeni awotsiki, ranashitantanakyaari wooro. ");
INSERT INTO cjoNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ari ritanakawo iroñaaka roerinkakotanaka. Royaateeyanakirini osheki aapatziyeeyakaririni, iweshiryaawenteeyanakarini, ikaemaeyanakini. Ikanteeyanakini: ");
INSERT INTO cjoNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","—Tema ikameethataki Tajorentsi. Añeeyakirini itajonkawentapiinteeyakaeni. Ikameethataki Awinkatharite rotyaantakaeniri Tajorentsi. Kameetha ijeekaeyakini maawaeni jenokijatzi, iñaaperoeyakirini Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ari ijeekitaka riraga warijeeyopaeni, ikaateeyakirini atziripaeni. Ikantawitakari Jesoshi: —Iyotaantatsiri, pojantzikagaeyerini riraga oyaateeyimirini. ");
INSERT INTO cjoNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Rakanakiri: —¿Iitaka nojantzikaantyaariri? Okameethataki ranteeyakirini. Ijantzikaeyanakinirikami irikapaeni, tema ari iñaawaetakaakiromi Tajorentsi mapipaenika oñaaperotantenarimi. ");
INSERT INTO cjoNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ikanta rokaakiteeyapaakawoni, iroñaaka raminakotapaakiro Jerojaree. Riraakoeyapaakarini Jesoshi jeekatsiripaeni, ");
INSERT INTO cjoNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ikantzi: —Nokowawitaka nojeekakagaeyeminimi kameetha, omaanta tee pikowaeyini. Pitheenkaeyakinani, iroñaaka eero piñagaana nopinkathariwenteeyemini. ");
INSERT INTO cjoNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Iinja ipoke powayiritepaeni rotzikaperoeyapaakimini, itapoteeyapaakimini joraaropaeni, eero ishineteeyimini tsikarika pikini pishiyantyaari. Romanateeyapaakimini, ");
INSERT INTO cjoNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ijoweyaperoeyapaakironi pipanko kameetha. Rowamaagaantapaakimi. Nopokashiteeyawitakimini, nopinkathariwenteeyeminimi, omaanta tee pipinkathateeyawakinani, inta pitheenkaeyawakinani. Rootaki awijatsini iinja maawaeni iroka. ");
INSERT INTO cjoNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Rareetantapaakari Jesoshi Tajorentsipankoki iñeeyapaakirini pimantayitatsirini eejatzi amanantayitatsirini. Roojatzi rookatheeyantapaakarini rookakiri inkokironta. Ithonkaeyakirini maawaeni, ");
INSERT INTO cjoNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ikantakiri: —Tema rojankinatziteetakawo Iwaperiteki Tajorentsi: “Ikantzi Tajorentsi: ‘Iroka Nopankoka okameethatzi pikenkithatakaapiinteeyenani eerokapaeni maawaeni atziri’, rootaki niwetsikakaanantawori”. Omaanta iroñaaka eerokapaeni pikoshitashiteeyakarini atziripaeni pokaeyawitacharini nopankoki. ");
INSERT INTO cjoNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ikantapiintatyaani maawaeni kitejiri riyaatapiintzi Tajorentsipankoki, riyotaantapiintaki. Omaanta ikijeeyanakirini riraga jewatayitziririni ñaanakowenantatsiripaeni, riraga iyotaantzirori rojankinarini Moeseeshi, eejatzi riraga pinkathariwenteeyiririni jeekatsiripaeni. Rojampitawakagaeyakani: —¿Tsika akanterika Jesoshi, owamaakaanantyaariri? ");
INSERT INTO cjoNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Omaanta tee riyoteeyini tsika ikanteriri, tema eeniro osheki atziri piyotawenteeyakaririni, ikemijantziri okaatzi ikantziriri. ");
INSERT INTO cjoNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Apaani kitejiri ijeekaki Jesoshi janta Tajorentsipankoki riyotagaeyakirini atziripaeni, ikamantakiri tsika ikanteeyaarini rawijakotanteeyarini. Ikantaka ipokaeyapaakini riraga jewatayitatsirini ñaanakowenantatsiripaeni, riraga iyotaantzirori Iwaperite Tajorentsi, riraga aataperoteenchari, maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ikanteeyapaakirini: —Pikamanteeyenani ninka owakimirika pinkathari: ¿ninka otyaantakimirika pantayitantaworini iroka? ");
INSERT INTO cjoNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Rakanakiri: —Eejatzi naari, eenitatsi nojampiteeyemirini. Pikamanteeyenani: ");
INSERT INTO cjoNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Ninkama otyaantakiriri Jowa ikaawoshitakotantariri Tajorentsi? ¿Riroma Tajorentsi otyaantakiriri? Kaarima, ¿riroma otyaantziriri atziri? ");
INSERT INTO cjoNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Tee rakaeyirini, inta ikantawakagaeyanakani: —¿Iitaka akanteriri? Akanteririka: “Rirotaki Tajorentsi otyaantakiriri”, ikanteekari: “¿Iitaka kaari paapatziyantari?” ");
INSERT INTO cjoNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Eejatzi akantawitakyaaririka: “Riraga atziripaeni otyaantakiriri”, tema ari ikijeeyanakaeni atziripaeni. Rompojanteerokari mapi. Tema rirori ikenkithashiryaakoperotziri Jowa rirotaki kamanantzirori iñaani Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Rootaki ikananteeyanakaririni: —Tee niyoteeyini ninkarika otyaantakiriri Jowa. ");
INSERT INTO cjoNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Roojatzi ikanantaka rirori Jesoshi: —Eejatzi naari, eero nokamantzimi ninkarika otyaantakinari. ");
INSERT INTO cjoNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Roojatzi ikenkithatakagaeyakirini Jesoshi atziri, roshiyakaawenteeyakinirini, ikantakiri: —Eenitatsi atziri pankitzirori oowamashi. Roojatzi ikanantakari ratzirite: “Paminawiritantenawo, iinja aririka okithokitanaki, paye eerori kashetani okithoki, kashetani pipena naari”. Ikanteeyanakirini: “Ari, kameetha”. Roojatzi riyaatantanaka ashitawori paashiniki kipatsi, ipeyaka ojamani janta. ");
INSERT INTO cjoNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Okanta omonkaatapaaka rowiitakiro okithoki. Riraga ashitawori roowate rotyaantakiri riraga ronampiri, ikantakiri: “Piyaatakite janta ojeekinta noowate, pikowakotakiteri riraga aminanawori rotyaantawakina kashetani”. Ikantaka jatawitanaka omaanta ikijeeyawakirini, ipajapajaatawakiri, roepiyawakiri. Tekatsi ipawakiri. ");
INSERT INTO cjoNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Roojatzi rotyaanantawitakari paashini ronampiri, omaanta ikaweyawaetawakiri, ipajapajaatawakiri, roepiyawakiri. Tekatsi ipawakiri. ");
INSERT INTO cjoNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Roojatzi rotyaanantawitakari paashini eejatzi, omaanta eejatzi ipajatawakiri, tak, tak, osheki riyowakaakiri riraa. Roepiyawakiri eejatzi. ");
INSERT INTO cjoNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ikenkithashiryaaka iroñaaka riraga ashitawori, ikantzi: “¿Iitaka nanteri iroñaaka? Aamaashitya rirorika notyaanteri iroñaaka notyomi nonintaperotziri. Aririka iñeeyawakirini irira, aamaashitya rirorika ipinkathatawakiri”. Roojatzi rotyaanantawitakari rirori. ");
INSERT INTO cjoNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Iñaanteeyawakaririni, ikantawakagaeyanakani: “Pamineritya itomi ashitawori iipatsite. Aririka ikamaki iriri, tema rirotaki aakoteroni. Thame owamaawakiri, agaeroota iinja aaka kipatsi”. ");
INSERT INTO cjoNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Roojatzi roerikantawakari, shepik. Ragaeyanakirini janta okaatapaaki iipatsite, rowamagaeyakirini, shemi. Rootaki ikenkithatakagaeyakiririni Jesoshi. Ikanteeyakirini: —Oetaka pikenkithashiryaari ikanteriri riraga ashitawori iipatsite. ");
INSERT INTO cjoNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Tema ari riyaatakite rirori, ikijaperoeyakiterini thamaetawitanariri rowani, eejatzi rowamaakiteri. Roojatzi raminanteeya paashini thamaeteenirini. Ari ikanteeyanakirini kemaeyawakiririni: —Tema eero imatziro ranteeyeroni iroka, eero ishinetziri Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ramineeyakirini Jesoshi, ikantziri: —¿Piitakaawitakama eero imatziro? ¿Oetakama otzimantakari Iwaperite Tajorentsi? Tema okantzi: “Riraga wetsikaeyirorini pankotsi itheenkakiro apaani mapi, ikantzi: ‘Tee okameethatzi’, omaanta iinja rowaga mapi itheenkawitakari, iñaakiro riraga Tajorentsi okameethatzi, tema rirotaki iyoyaakirori iroka mapi kijotakaaperoteroni pankotsi. Tema rootaki otsikanatantanakawori aakapaeni”. ");
INSERT INTO cjoNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Noshiyakawentemiri atziri aririka ipariyaki antawoki mapi tema ari ikagaapokitapaaki. Eejatzi aririka opariyaki antawo mapi ari atsinakapaakiri, opithoryaapaakiri. Kimitaka iroka, ninkarika kaari aapatziyana naaka eero rawijakote, eejatzi aririka nokantakoteri kaari aapatziyana aritaki notyaanteeyakirini paamari kaari tsiwakanitatsini. ");
INSERT INTO cjoNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Riraga jewatayitziririni ñaanakowenantatsiripaeni, eejatzi riraga iyotaantzirori Iwaperite Tajorentsi ikowaeyawitakani ragaeyerinimi iroñaaka Jesoshi, tema riyotakoeyawakani rirotaki roshiyakaawenteeyakirini. Omaanta tee imatziro rayiri, ithaawanteeyakarini atziripaeni, ikantzi: “Eero ayiri, ikijakotanakarikari atziripaeni”. ");
INSERT INTO cjoNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Roojatzi rotyaanantakari ñaanakowenantatsiri atziri, ikantakiri: —Iroñaaka piyaate pamatawiteri riraga Jesoshi. Pikimitakaantapaakyaari kyaaryo pikowaperotaki paapatziyari; omaanta, pikompitakaeyari iñaani. Aririka ikompitanakyaawo ikanteri, intsipaete pipokanaki pikamantena. Roojatzi aatashitantakyaari pinkathari, akamanteri ikantakiri. ");
INSERT INTO cjoNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ikantaka riyaatashitanakiri Jesoshi, ikantapaakiri: —Iyotaanari, niyoteeyakini kyaaryooperotaki maawaeni pikantakinari eejatzi maawaeni piyotaakinari. Tee paminashitari atziri ipooki piyotantyaariri ikameethatzirika, inta paminaperotzi rajankani ikenkithashiryaantari. Eejatzi kameetha piyotagaeyakinawoni ikowakagaeyakinarini Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Iroñaaka pikamantena: ¿okameethatzima apaeyerini riraga iwinkatharite oroomajatzi ayorikite ikowakotakaeri? ¿Eeroma apiri? ");
INSERT INTO cjoNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ikanta riraga Jesoshi riyotakotakirini ikowaeyawitani ramatawiterimi. Ikantziri: —¿Iitakakya pikowantari pikompitakayenawo noñaani? ");
INSERT INTO cjoNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Poñaayenari ikithoki piyorikite. ¿Ninka roshiyapootakarika irika korikikika? ¿Ninka ashitawori iwaero jankinateencharika? Rakanakiri: —Rootaki ipoo iwinkatharite oroomajatzi, riraga Seesari, eejatzi ojankinataka iwaero. ");
INSERT INTO cjoNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Roojatzi ikanantanakari Jesoshi: —Okameethatzi panteniri irinta ikowakaakimiri, eejatzi pantzityaanari Tajorentsi ikowakaakimiri. ");
INSERT INTO cjoNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Tekatsi ikanteeyaani ikompitakayaari iñaani Jesoshi, kameetha riyotaantaperotaki. Rotsikanateeyanakarini riraga amatawiterinimi, rootaki imaeriteeyantanakarini. Tekatsi ikantaneeri eejatzi. ");
INSERT INTO cjoNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Roojatzi riyaatashitantakari Saroseeyo Jesoshi. Ikenkithashireeyani riraga Saroseeyo, ikantzi: “Eero ipiriinteeyaani riraga kaminkaripaeni, eero riyaateeyini jenokinta”. Rareetapaakaga, ikantapaakiri: ");
INSERT INTO cjoNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Iyotaantatsiri, ikantzini Moeseeshi: “Eenitatsirika shirampari iina, omaanta tekatsirika itomi, aririka ikamaki, okameethatzi ragaero iinani rirentzi itzimakaanteeyaawori otomi. Itzimapaakirika otomi kimiwitanaka rirotaki ashityaarini rirentzini itomi”. ");
INSERT INTO cjoNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Aamashitya eeniro shirampari ikaatzi rirentzi 6 impaetatsiri. Riraga itawitanakawori raawitaka iina, ikamashitaka. Tee itzimi itomi. ");
INSERT INTO cjoNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Roojatzi raantawitaawo rirori rirentzini. Eejatzi tee itzimakayiro itomi, roojatzi ikamantaka rirori. ");
INSERT INTO cjoNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Eejatzi ikimitaka paashini rirentzini. Raawitaawo tsinani, ikamashitaka eejatzi rirori. Eejatzi ikimiteeyakani maawaeni rirentzini. Tekatsi tzimakayeroni otomi. ");
INSERT INTO cjoNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ro impaeteentsi roori tsinani, okamaki. ");
INSERT INTO cjoNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Iroñaaka pikamantena: kyaaryorika ipiriinteeyaneeni maawaeni kamaeyawiteencharini, ¿ninka iinanteeyaawoni iroka tsinani? Tema ikaateeyawitani aawitawori 7. ");
INSERT INTO cjoNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ikanta ikantawakiri Jesoshi: —Kyaaryo, jaka kipatsiki rameteeyakawoni shirampari rayi iina. Eejatzi tsinanipaeni ameteeyawoni ayi oemi. ");
INSERT INTO cjoNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ari ipiriinteeyeerini Tajorentsi maawaeni atziri iñaaperotziri, omaanta janta jenokinta eero ragae iina. Eejatzi tsinani, eero agae oemi. ");
INSERT INTO cjoNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Eejatzi eero janta ikamae eejatzi, ikimiteeyapaeyaarini maawaeni ronampiripaeni Tajorentsi, jeekimoeyiririni: tee ikamaeyini rirori. Ikantani rañagaeyini. Eejatzi itomintaperoeyeeyarini maawaeni atziri riraga ipiriinteeyeerini. ");
INSERT INTO cjoNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Paerani riyotzitakani Moeseeshi ipiriinteeyaneeni kamayitatsirini. Ikenkithatakotantawori inchashimpoki amorekawitachari, ikenkithatakotakiri eejatzi Awinkatharite. Ikantzini: “Raapatziyana Awaraama. Eejatzi Ijaaka raapatziyana, eejatzi Jakoowo”. ");
INSERT INTO cjoNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ñaakiro, tee ikantzi: “Raapatziyawitakinani Awaraamani”. Añaatsi iroñaaka Awaraama eejatzi paashinipaeni, rootaki ikanantakari: “Raapatziyana”. ");
INSERT INTO cjoNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Roojatzi ikantayitantakarini apaanipaeni iyotaantzirori Iwaperite Tajorentsi: —Iyotaanari, kameethataki iroka pikantakiri. ");
INSERT INTO cjoNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ithaawanteeyakarini rojampiteeyaneerinimi eejatzi. ");
INSERT INTO cjoNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Paashini eejatzi ikantakiri Jesoshi: —¿Iitaka pikanteeyantarini: “Rirotaki Rotyaantanewo Tajorentsi icharineeteni Iraviirini”? ");
INSERT INTO cjoNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Tema paerani romampaawentarini Iraviiri Tajorentsi, rojankinatakiro iroka: “Riraga Tajorentsi, ikantakiri Nowinkatharite: ‘Notyomi, pijeeki jaka nakoperoki, pikaatena apinkathariteeyeni, ");
INSERT INTO cjoNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","roojatzi ipinkathateeyantemirini maawaeni kijeeyawitakimirini’ ”. ");
INSERT INTO cjoNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","¿Riroma Jesokirishito icharineeteni Iraviiri? Rirorika icharineeteni ¿iitaka ikanantaririkya paerani: “Nowinkatharite”? Tee pameteeyawitawoni pipinkathateeyirini impaetatsiri ijeeki. ");
INSERT INTO cjoNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Maawaeni atziri ikemaeyakirini Jesoshi, riyotagaeyakirini riyotaanewopaeni, ikantakiri: ");
INSERT INTO cjoNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Paamayaarira riraga iyotaanteeyawitaworini Iwaperite Tajorentsi. Osheki ikowaki ikinakinathanthanatziite. Eejatzi ikowaki kameetha raakameethateeyawakirini atziri janta nampitsiki. Eejatzi janta pankotsiki apiyotantapiintarira, ikowaki ijeekimotapiinteri pinkatharipaeni. Eejatzi aririka ipiyoteeyani atziri rowaeyani, ikowaki kijokiro rowapiinteri pinkatharipaeni. Eero pikimitari riroripaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Kimiperowitaka ikameethatzi. Rojamanitziro ikenkithatakayeri Tajorentsi. Ikowaeyawitakanira atziri raapatziyaperotakayaarimi Tajorentsi. Omaanta osheki ramatawitapiintakiro kamatsiri oemi, ikoshitashitakawoni tzimimotzirori. Kyaaryootaki iroka nokamantemiri: rowashironkaaperoeyerini osheki Tajorentsi paamariki iinja. ");
INSERT INTO cjoNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ari ijeekaki Jesoshi janta Tajorentsipankoki. Raminayitawakirini ashaagantzinkari otetziriri iyorikite janta rotetantapiintaririra. ");
INSERT INTO cjoNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Eejatzi iñaakiro irowa kamaentsiri oemi owashironkaenkawo. Otetapaakiri roori apimerontakite oorikyaanikite, kaari pinatacha. ");
INSERT INTO cjoNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ikantzi: —Kyaaryo iroka nokamantemiri: pitheenkitzirokari irika amakiri iroka kamaentsiri oemi. Omaanta osheki iñaaperotzitakiro Tajorentsi irika amakirika, anaakotakiri ramaeyawitakarini riraga ashaagantzinkari. ");
INSERT INTO cjoNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Osheki iwinawo ramawitakari rirori, omaanta eeniro ikempoyaagaantanaki tzimagaantapaentsiri rirotaki ramakiri rirori. Rooma iroka, amanakiri maawaeni tzimimotawitawori, tee añagaeri tzimagaantanaatsini, tekatsi aantaneya oyaari. ");
INSERT INTO cjoNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ikenkithatakaawakaeyakani riyotaanewopaeni, ikanteeyini: —Tema okameethaperotaki Tajorentsipankoka. Eejatzi maawaeni mapipaeni riwetsikantakawori, okameethateeyakini, eejatzi maawaeni rowaneenkatantakawori janta otantoki. Ikemanteeyakaririni, ikantziri Jesoshi: ");
INSERT INTO cjoNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Iinja ishekiroryagaeteero maawaeni iroka piñaaperoeyirini iroñaaka. Rookaeteero mapipaenika inteena. ");
INSERT INTO cjoNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Roojatzi rojampiteeyakirini: —¿Tsika okaateka omonkaatantyaari iroka pikantakinari? ¿Tsika nokantyaaka niyotantyaari rooteentsi omonkaatya? ");
INSERT INTO cjoNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ikantakiri: —Kyaaryoowa, ramatawiteetzimikari. Ipoke osheki atziri ikantapaakimini: “Naaka Jesokirishito”. Paashini kantapaentsini: “Rotyaantakina Jesokirishito nokamantemi rooteentsi ipokae”. Omaanta eero paapatziyari. ");
INSERT INTO cjoNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Pikematyeeri atziri ikante romanatakagaeyatyaani atziripaeni, eejatzi rookaeyerini iwinkatharitepaeni. Omaanta eero pithaawaeyini. Aritaki okantyaari ikijawakaapiinteeyaani, omaanta tekira omonkaata nopokanteeyaari. ");
INSERT INTO cjoNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Eejatzi eenitatsi paashini ikantakiriri: —Riraga atziripaeni romanaterini inashitapaeni atziri. Eejatzi riraga jewawenantatsiri paashiniki kipatsi ragaeyanakirini inampijatzipaeni romanatakayaari romanateeyirini riraga jeekatsiripaeni paashiniki kipatsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Eejatzi osheki otzimayitanakini antawo omoyeka jaka kipatsiki. Agaeyerini atziripaeni itashe, osheki ikamaeyanakini; eejatzi omateeyirini mantsiyarentsi atziripaeni, ikamagaantayiteni rirori. Eejatzi okimitzitanakya janta jenokinta ari piñaawakiro kaari piñaapiinteeyini, osheki pithaawanteeyanakyaawoni. ");
INSERT INTO cjoNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Eejatzi ikanteeyakirini: —Omaanta reewateetemi ikijeetemi: tema paapatziyakina. Ragaeyanakimini theenkantatsiri janta pankotsiki ipiyotantapiintarira joriiyopaeni, eejatzi romonkyaayitemini omonkyaagamentotsiki. Ragaeyanakimini eejatzi janta pinkatharipaeniki, ikijatheeyemini, ikantemi: “¿Iitaka paapatziyantariri Jesoshi?” ");
INSERT INTO cjoNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Omaanta eero pithaawantari riraga kijawitemini, inta pikamanteeyerini tsikarika nokanta nowawijaakoeyakimini. ");
INSERT INTO cjoNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Eero pikenkithashiryaa: “Aririka ragaetena, ¿oetaka nokanteriri?” ");
INSERT INTO cjoNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Aririka ragaetakimi niyotagaeyemini naaka oetarika pikanteriri. Eero imatantzimi riraga kijemini ipiyawaantetemi, ikantemi: “Pikompitashitawo”. ");
INSERT INTO cjoNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Nokamantemi: tee apatziro raakaantemi paashinijatzi atziri eejatzi raakaantzitemi piripaeni, piniropaeni, pirentzipaeni, pitsiropaeni, pisheninkapaeni, maawaeni. Rowamaagaantemi. ");
INSERT INTO cjoNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Tema riyoteeyakiminirika atziri paapatziyakina, rootaki roonaperotantemiri. ");
INSERT INTO cjoNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","19","Omaanta aririka kijokiro poyena eejatzi pikyaaryoowentenawo maawaeni nokanteeyakimirini, ari nokempoyaaperoeyakimini. Eejatzi piyaaperoeyanteeyaarini janta jenokinta pikanteetatyeeyaani pijeekaperoeyapaeni. Eero imateeyironi riraga kijeeyawitakimirini rookakagaeyemironi piyaateeyini janta jenokinta. ");
INSERT INTO cjoNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Eejatzi ikantaki Jesoshi: —Aririka piñagaeyawakirini joraaro rinkiteeyapaakironi Jerojaree, ari piyoteeyanakini rooteentsi ithonkaeyeeroni pinampi. ");
INSERT INTO cjoNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Roojatzi okameethatzi ishiyeeyanakini tonkaariki maawaeni jeekaeyatsirini nampitsiki. Eejatzi maawaeni jeekatsirini Joreeyaki, ishiyeeyanakini. Eejatzi riraga jatayitatsirini owantsikipaeni, eero ipiyapanaata nampitsiki. ");
INSERT INTO cjoNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Aritaki omonkaatakya maawaeni iroka rojankinatziteetakarini paerani: “Rowajankitaperoeyerini Tajorentsi maawaeni theenkaeyakiririni”. ");
INSERT INTO cjoNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Aririka omonkaatapaakya maawaeni iroka, oo, osheki ashironkayitanakyaani motzitayitatsirini, eejatzi ashironkaakya thotaayitziririni eentsite: opomeentsitzimoeyaawoni oshiye. Osheki ikemaatsitayitanakyaawoni riraga jeekatsiripaeni. Osheki rowashironkagaeyerini Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Romanateeyerini osheki atziri, ikamagaantayitanakini. Paashinipaeni roojotayiterini, ragaetanakiri paashinikipaeni kipatsi. Ijeekapaaki kaari yotziripaeni Tajorentsi ojamani Jerojareeki, roojatzi ikananteeya Tajorentsi: “Aritapaaki, monkaatapaaka”. ");
INSERT INTO cjoNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Eekiro riyaatatyee ikantziri Jesoshi: —Piñeeyawakirini ipaashiniteeyanakini jenokijatzi: riraga oorya, kashiri, ompokiropaeni, maawaeni. Piñeero kaari piñaapiinteeyini. Eejatzi jaka kipatsiki ithaawaeyanakini maawaeni atziri, ikemaeyawakironi opoematanaki antaworoña inkaare, mooo. Eejatzi iñaawakiro antaworoña otamakaari. Ramineeyanakironi, joreririri. ");
INSERT INTO cjoNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Eero riyoteeyini atziri tsikarika ikanteeyanakyaani, rootaki ithaawaperoeyantanakyaarini. Ishewatayitanakyaani ompokiro. ");
INSERT INTO cjoNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Roojatzi piñeeyantawakinani, nopiyee eejatzi. Tema nopoñaaka paerani jenokinta, nokoñaatantapaentari jaka kipatsiki. Aririka nopiyee eejatzi, nokinapae menkoriki, notajorentsitaperotapaaki, nopinkatharitaperotapaaki. ");
INSERT INTO cjoNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Aririka piñagaeyawakironi iroka nokanteeyakimirini, piweshireeyanakyaani, pamineeyawakinani: rooteentsi nowawijaakotaperoeyemini, tema nagaeyaatatyeemini naaneemi jenokinta. ");
INSERT INTO cjoNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Roojatzi roshiyakaawenantakanari iroka, ikantakiri: —Paminero iyeera tsika okantari. Kaaririka iyeera, eejatzi paashini inchato paminero. ");
INSERT INTO cjoNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Aririka eereshitanee oshi, piyoteeyanakironi rootzimataatsi ojarentsitanee. ");
INSERT INTO cjoNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Eejatzi okimitaka, aririka piñaakiro omonkaatakya maawaeni nokamantzitakimirika, piyoteeyanakini rooteentsi ipinkathariwentaperoeyemini Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Aririka piñagaeyawakironi itanakya iroka nokamantakimiri, ari eerotzitarika pikamita, aritaki piñagaeyakironi omonkaatakya maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Aritaki othonkaeya maawaeni kipatsi eejatzi ithonkaeya maawaeni jenokijatzi: kashiri, oorya, ompokiropaeni, maawaeni. Omaanta noñaani, eero othonkanita. ");
INSERT INTO cjoNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Eejatzi ikantakiri: —Paamaaperoeyenani: nomapokapaemikari nokantakowenantemiri. Kyaaryoowa pikenkithashiryaakotawokari kaari kameethatatsi pajankaneki. Pishinkiteeyanikari. Pikenkithashiryaapiintzirokari jeekaeyatsirini jaka kipatsiki. ");
INSERT INTO cjoNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Aritaki nomapokapaakiri maawaeni jeekatsiripaeni kipatsiki. Nowashironkagaeyerini maawaeni kaari aamaawenteeyachani. ");
INSERT INTO cjoNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Eekiro piyaatatyee paamawentya. Eejatzi pamaneri Tajorentsi ramitakotemi kameetha pareeteeyanteeyaarini jenokinta, eerokya pikemaatsitantawo maawaeni iroka nokamantakimiri. ");
INSERT INTO cjoNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Maawaeni kitejiriki riyotaantaki Jesoshi janta Tajorentsipankoki. Maawaeni tsiteniniki riyaatapiintzi janta tonkaariki iiteetziri Oriiwomashi. ");
INSERT INTO cjoNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Eejatzi maawaeni kitejiriki riyaatapiinteeyakini atziripaeni Tajorentsipankoki ikemijanteeyirini. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Rooteentsi areetya kitejitatsiri rowantapiinteeyaworini paa kaari tapiyacha. Tema ikenkithashiryaakopiintawo joriiyopaeni paerani rawijeeyantakaworini ronampiri Tajorentsi ipankopaeni janta Ejiipitoki. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Rowameethatawakagaeyakani riraga jewatayitziririni ñaanakowenantatsiripaeni eejatzi riraga iyotaanteeyirorini Iwaperite Tajorentsi ikantzi: —¿Tsika akanterikakya Jesoshi owamaantyaariri? Aamaashitya ari ikijakotanakyaari atziripaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ikantaka riraga Jatanaashi ikyaantapaakari Joorashi karyootejatzi, riraga riyotaanewo naawita Jesoshi: riyotaakiri raakaanteri iwinkatharite. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ari riyaatashitakiri riraga jewatayitziririni ñaanakowenantatsiripaeni eejatzi waariryaa ashi Tajorentsipanko, ikantapaakiri: —Namitakotemi paakaanantyaariri Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ikemantawakariri, ikimoshireeyanakini, ikanteeyawakirini: —Ari, kameetha. Ari nopinatakimi koriki iroñaaka. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ikantakiri: —Ari, kameethataki. Iroñaaka naminaperoteri, roojatzi nokamantemi tsika pikantyaari pimanakaantyaariri payeri eerokya iñaakowenantawakari atziripaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Areetapaaka kitejitatsiri rowantapiinteeyaworini paa kaari tapiyacha eejatzi rowamaapiinantariri owisha, ikimitzirira ichariniitenipaeni paerani janta Ejiipitoki. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Riraga Jesoshi rotyaantakiri Peetero eejatzi Jowa, ikantawakiri: —Thame peewate powojantero owanawontsi owaeyaarini, akenkithashireeyantyaaworini rawijantanakari paerani owamaantatsiri. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Rojampitanakiri: —¿Tsika pikowakiroka nowojantero? ");
INSERT INTO cjoNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Rakanakiri: —Aririka pareetakya nampitsiki, piñaapaakiri shirampari raakotaneero iñaa. Poyaatanakiri janta pankotsiki, tsikarika ikyaapae. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Pikantapaakiri riraga ashitawori ipanko: “Ikantzi Awinkatharite: ‘¿Tsika nowakayaarika niyotaanewopaeni?’ ” ");
INSERT INTO cjoNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Roñaayimiro janta oshitamenkotakanta jenoki. Owetsikaeyakani ajeekaeyantyaarini. Ari powojanteeyapaakini owaeyaarini. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Roojatzi riyaateeyanakini, iñaapaakiro ikantakiriri Jesoshi. Ronkotsiteeyapaakirini royaari, ikenkithashiryaakotantyaariri ronampiri Tajorentsi rawijantanakariri ichariniitenipaeni paerani janta Ejiipitoki. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Rareeteeyapaakani Jesoshi eejatzi rotyaantanewopaeni rowaeyapaakani. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ikanteeyakirini Jesoshi: —Osheki nokoyitakani nowakagaeyaneemini iroka owanawontsika eeniroka nañi, akenkithashiryaantyaawori rowawijaakotantaki Tajorentsi paerani. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Nokamantemi, naapatziyaperotakari Tajorentsi rootaki nokamantyaari. Eero napiiteero nowawo iroka eejatzi jaka kipatsikika. Kyaaryo, rooteentsi nokame, nomonkaatero maawaeni rojankinatzitakarini riraga kamanantayitzirorinipaeni eejatzi paashini jankinatayitakirorini Iwaperite Tajorentsi paerani. Nomonkaatero maawaeni roojatzi nowapaeyaawo tsikarika ipinkathariwenante Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ikanta raakotakiro pajoki, ipaasonkitakiri Iriri, roojatzi ikantzi: —Paakoeyawakironi iroka, pireeyeroni. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nokamantemi: eero napiiteero nireero awishoowaantsi oowa jaka kipatsikika. Omaantakya nirapaero eejatzi janta ipinkatharitzinta Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Roojatzi raakiro paa, ipaasonkitakiri Iriri. Ikagaakiro, ipaeyakirini riyotaanewo, ikantziri: —Iroka paaka, powaeyaawoni. Naaka kamawenteeyemirini. Nokowaki powapiintyaawo paa pikenkithashiryaakotapiinantenari nokamawenteeyakimini. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Rowaeyakani maawaeni. Roojatzi ipakoeyakirini awishoowaantsi oowa. Ikanteeyakirini: —Aririka pirero iroka, nokowaki piyoteeyeni oñaaganteroni owakirari inimotawakaantsi. Tema rootaki niraa apaatawenteeyemirini, nokamawenteeyemini nowawijaakoeyantemirini. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Roojatzi ikanteeyakirini: —Eenitatsi akaateeyakinika iroñaaka owaeyakani riraga aakaantenani owamaakaantenani. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Naaka riraga atziriperotapaentsiri nokamawenteeyerini maawaeni atziri rootaki ikowakinari Pawa Tajorentsi, omaanta ashironkaamatsiterini riraga aakaantenani. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ikemanteeyawakaririni, rojampitawakagaeyanakani: —¿Ninkama aakaanterini? ");
INSERT INTO cjoNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Roojatzi ikantawakaanteeyakarini riyotaanewopaeni: —¿Ninka iinja jewatakaaperoeyantatsirini? ¿Ninka anaakotantaperotatsini ipinkatharitaperote? ");
INSERT INTO cjoNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ikantanakiri Jesoshi: —Rameteeyawoni riraga jewatatsiripaeni kaari yotziri Tajorentsi ipinkathateeyakirini iwinkatharitepaeni. Ikantashiteeyakani: “Retakoeyakarini atziripaeni”, omaanta eeniro romperataperotapiinteeyarini. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Omaanta eerokapaeni, eero pikimitakoeyarini. Aririka pikowaki pipinkathariwenante, eero pikantakaaperota, inta pamitakotapiinteri kameetha paashinipaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Ninka ipinkathataperotziri atziri? ¿Riragama wetsikapiintziniriri rowanawo? Kaari. Tema riro ipinkathateetziri riraga omperateeyaririni ronampiripaeni. Omaanta naaka tee nomperateeyimini, inta netakoeyakimini. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Kijokiro powaeyakinani paerani roojatzi iroñaaka, piyoteeyakini opomeentsitzimotapiinteeyakaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Rootaki nokanantzimiri iroñaaka eerori pipinkathariwenante, ikimitaakina Pawa ikowakaakinawo nopinkathariwenante. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Pitsipatapiinteeyenani owapiinteeyaani eejatzi irapiinteeyeni janta nopinkatharitapaenta, eejatzi apinkathariwenteeyerini maawaeni joriiyopaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Eejatzi ikantakiri Awinkatharite: —Shimo, pikemina, riraga Jatanaashi ikantakiri Tajorentsi ikowaki iñaantemi, riyotantyaari paapatziyaperotakinarika. Kyaaryoowa, ikowaki rantakayemiro kaari kameethatatsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Omaanta nokantakiri Tajorentsi ramitakotemi eerokya pookaperotantawo paapatziyana. Iinja, aririka pithawetakotya oetarika pantakiri, eejatzi pookero ari poyaatena eejatzi, pikenkithashiryaakagaeyeerini maawaeni piyemijantzinkarite, paapatziyakaaperoeyantyaaririni. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Rakanakiri Shimo: —Tema eeroka Nowinkatharite, kijokiro nowanakimi; aririka romonkeetemi, eero nookimi. Romonkeetenaata naari. Aririka rowamagaetemi, notsipataperotanakimi. Rowamagaetenaata naari. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ikantakiri: —Nokamantemi: iroñaaka tsitenirikika, tekiraata iñee tyaapa, okaate 3 pikante: “Tee niyotziri Jesoshi”. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Roojatzi ikanteeyantakarini Jesoshi riyotaanewopaeni: —Paerani notyaanteeyakimini pikenkithatakagaeyantaririni atziripaeni. Nokanteeyawakimini: “Eero payi pithaate, piyorikite, eejatzi paashini piithaari”. Iroñaaka nojampiteeyemini: “¿Pashironkagaeyakanima? ¿Eenitatsima koetyeemoeyakimirini?” Raanakirini: —Tekatsi koetyeemotenani. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Roojatzi ikanteeyanakirini: —Iroñaaka nokanteeyemini: eenitatsirika pithaate, paanakiro. Eenitatsirika piyorikite, paanakiri. Tekatsirika pijawirite, pipimantero pipewiryaakotari pamananantyaawori apaani pijawirite. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Aritaki omonkaatakya rojankinatakotakinarini paerani Iseeyashi: “Rowamagaeteri, ikimitakaanteetyaari owamaantzinkari”. Kyaaryo, othotyaaperotakya kameetha maawaeni rojankinatakotzitakinari paerani riraga kamanantzirorini iñaani Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Roojatzi ikanteeyirini: —Eenitatsi iroka, Nowinkatharite: apite okaatzi nojawirite. Rakanakiri: —Ari, monkaataka. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Roojatzi ishitowanaki Jesoshi, riyaatanee eejatzi janta riyaatapiintzinta: janta tonkaariki iitachari Oriiwomashi. Itsipateeyanakarini riyotaanewopaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Rareeteeyapaakani, ikanteeyapaakirini: —Iroñaaka pamaneeyaarini Tajorentsi ramitakoeyantemirini: pantzirokari kaari kameethatatsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Roojatzi rowaaganaka Jesoshi apaniroeni eekitziroeni jaga. Rotziwerowapaaka, ikenkithatakaeri Iriri, ikantziri: ");
INSERT INTO cjoNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","—Pawa, pikowakirika, powawijaakotenawo iroka nokemaatsitakyaari. Omaanta eero pantziro nokowakiri naari, inta pantero pikowakaakinari eerori. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Roojatzi ipokapaaki apaani ronampiri Tajorentsi, ramitakotapaakiri Jesoshi, ishintsitantakari. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Osheki ikemaatsitakawo, eekiro ikenkithatakaaperotanakitziiri Iriri. Antawo ikemawakiro imajawitanaki, tema otsipatanakawo iyaaki riraa roojatzi othaatantanaka, pitek, pitek. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ithonkanakiro ikenkithatakaeri Iriri, riyaatanee janta ijeekaeyakininta riyotaanewopaeni, iñeeyapaatziirini magaeyakini. Rooma osheki rowashireeyanakani inkaaganki, rootaki imaantanakari. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ikanteeyapaerini: —¿Iitaka pimagaeyantakarini? Pipiriinteeyaneeni. Pamaneeyaarini Tajorentsi ramitakotemi eerokya panantawo kaari kameethatatsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Eenirowa ikenkithatakagaeyawitarini Jesoshi riyotaanewo, areeteeyapaakani osheki atziri, reewateeyapaakirini Joorashi. Rirowitaka riyotaanewo Jesoshi, omaanta iroñaaka ikowaki raakaanteeri. Ipokashitapaakiri rirori, ithowootapaakiri. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ikantawakiri: —Ro pithowootantanari, paakaananteenari. Tema piyotaki naaka riraga atziriperotapaentsiri riraga poñeenchari jenokinta. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ikanta iñaakowentawakirira okaatzi awijimotakiriri Jesoshi. Rojampiteeyirini: —Nowinkatharite, ¿pikowakima nochekiri? ");
INSERT INTO cjoNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Rootaki ichekaetakiri ikempitapero apaani ronampiri riraga iwinkatharite ñaanakowenantatsiri, thatzik. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ikantakiri Jesoshi: —Ari okantakaata, eero pikoshekari. Roojatzi roepiyeeniri ikempita, rowithagaeniri. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Irira itsipateeyapaakarini Joorashi riraga jewatayiririni ñaanakowenantatsiripaeni, eejatzi riraga jewatakaantatsiri janta ipankokinta Tajorentsi, eejatzi aataperoteenchari. Ikantawakiri Jesoshi: —¿Iitaka pamashitantanari pichekamentopaeni eejatzi pompojamentopaeni? ¿Naakama koshintzi? ");
INSERT INTO cjoNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Tema notsipatapiinteeyawitzimini janta Tajorentsipankoki, omaanta tee pikoshekaeyanani. Omaantakya iroñaaka monkaataka paantakinarika: rooma ipinkathariwenteeyakimini iwinkatharite kamaari. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Roojatzi roteyanteetakari Jesoshi, shepik. Ragaeyanakirini janta ipankoki iwinkatharite ñaanakowenantatsiri. Ikantaka rimpaetanaki Peetero itapiiki Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Janta pankotsiki, okaankiityeera, ari roeshita paamari. Ijeekaeyapaakini, rakitsiteeyapaakani riraga agaeyakiririni Jesoshi. Ari itsipateeyapaakarini Peetero. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Roojatzi opokapaaki ronampiri ñaanakowenantatsiri. Okatziyapaaka, aminapaakiri Peetero, joreririri. Roojatzi okantanaki: —Eejatzi irika rirotaki oyaatziriri Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ikantawakiro: —Tee niyotziri rirori. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Roojatzi paashini aminakiriri, ikantakiri: —Tema eeroka oyaatziriri Jesoshi. Ikantakiri: —Teewee. Tee noyaatziri. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ari ojamanitapaentzi, roojatzi ikantaki paashini: —Kyaaryo, rirotaki oyaatakiriri irika shirampari, tema eejatzi ipoñaaka Karireeyaki. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ikantanakiri riraga Peetero: —Tee niyotzi oetarika pikantakinari. Roojatzi iñaantanaka tyaapa, anterekooo. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Riraga Jesoshi ipithokashitanakari Peetero, raminanakiri. Roojatzi ikenkithashiryaantanakawo ikantzitakariri inkaaganki: “Tekiraatarika iñee tyaapa, okaate 3 pikante: ‘Tee niyotziri Jesoshi’ ”. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ari ishitowanaki Peetero, riraaperotanaka, jmmm, jmmm. Osheki retakoperotanaka. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Riraga shenteeyakiririni Jesoshi ishirontawenteeyakarini, eejatzi ipajapajaatakiri, tak, tak. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Roojatzi ipashikapootantakari eejatzi ipajapootakiri, ikantakiri: —Pikamantenaata ninka pajapootakimiri. Injii, injii. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Osheki rowashironkaeyakirini, tema itheenkakiri, ishirontawenteeyakarini. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Okantaka okitejitanaki ipiyoteeyani riraga aataperoteenchari, riraga jewatayitziririni ñaanakowenantatsiripaeni, riraga iyotaantzirori Iwaperite Tajorentsi, maawaeni. Ragaeyanakirini Jesoshi janta ikantakowentapiinteeyirininta atziri. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Rojampiteeyakirini: —Pikamantenaata: ¿eerokama Rotyaantanewo Tajorentsi naamagaeyakarini? Rakanakiri: —Nokantemirikami: “Jee, naaka Jesokirishito”, eero paapatziyawo nokantemiri. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Eejatzi, nojampitemirikami oetarikapaeni, eero pakana. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Omaanta nokantemi iroñaaka riraga atziriperotapaentsiri ijeekimotapaeriita Pawa rakoperoki, notsipatapaeyaariita notajorentsitaperotapae. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Rojampiteeyakirini: —¿Eerokama Itomi Tajorentsi? Rakanakiri: —Jee, naaka. ");
INSERT INTO cjoNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Roojatzi ikanteeyanakini: —¿Iitaka akowantyaari paashini kamantakoterini? Tema akemaeyakirini aaka ipaanteperoki, iitajorentsitashitaka. Eenitatsi rantani. ");
INSERT INTO cjoNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Riyaateeyanakini maawaeni, raanakiri Jesoshi janta Peraatoki. Rirotaki oroomajatzi, pinkathariwenteeyiririni joriiyopaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ikantapaakiri: —Eenitatsi rantakiri irika. Ramatawiteeyakirini nojoriiyotzinkaritepaeni, ikanteeyawitakarini: “Eero pipiri pinkathari piyorikite”. Eejatzi ikantapiintzi: “Naaka Rotyaantanewo Tajorentsi, naaka jewawentzimiri”. ");
INSERT INTO cjoNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Rojampitakiri Peraato: —¿Kyaaryoma? ¿Eerokama iwinkatharite joriiyo? Rakanakiri: —Jee, naaka. ");
INSERT INTO cjoNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Roojatzi rirori ikanteeyawakirini: —Tee añiiro rantani irika. ");
INSERT INTO cjoNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Omaanta eekiro ikanteeyanakitziini: —Ikijakagaeyakarini atziripaeni, ikanteeyakirini: “Thame ookeri awinkatharite”. Ritanakawo janta Karireeyaki, iroñaaka ikinakinayitzini jaka Joreeyakini, ramatawiteeyakirini maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ikemantakawori Peraato ikanteeyakiririni, rojampitakiri: —¿Rirotakima karireeyajatzi irika? ");
INSERT INTO cjoNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Rakanakiri: —Jee, rirotaki. Ikantawakiri: —Paanakiri janta Erooreshiki. Rirotaki pinkathariwenteeyiririni karireeyajatzi. Ari ijeekaki iroñaaka jaka Jerojareeki. Ipokaki chapinki. ");
INSERT INTO cjoNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ikanta ragaeyaneerini janta. Iñaantawakariri Erooreshi, ikimoshiryaanaki. Osheki ikemakotzitapiintari, itajonkantayitakini, rootaki ikowantawitakariri iñeeri. Ikowawita iñeerimi itajonkantayitenimi. ");
INSERT INTO cjoNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Osheki rojampitayitawitakarini oetarikapaeni, omaanta tee rakiri Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Osheki rapiitapiintakiniri riraga amakiriri, ikantzi: —Tee ikameethatzi. Eeniro rantani. ");
INSERT INTO cjoNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Roojatzi ishirontawenanteeyakaririni Jesoshi riraga Erooreshi eejatzi maawaeni joraaropaeni. Tema ikithaatakaakari kameethari kithaarentsi, ikimitakaantawitakari pinkathari, ishirontawenteeyantyaaririni. Roojatzi rotyaanantaari eejatzi janta Peraatoki. ");
INSERT INTO cjoNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Aripaete raakameethatawakagaa Erooreshi eejatzi Peraato. Omawitya paerani ikijawakaawita. ");
INSERT INTO cjoNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Roojatzi ipiyoteeyantakarini Peraato riraga jewatayitziririni ñaanakowenantatsiripaeni, pinkatharipaeni, eejatzi osheki atziripaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ari ikanteeyakirini: —Pamine, inkaaganki pamawitakinari irika, pikanteeyawitakinani riyotagaeyakirini atziri rookaeyenani naari, eejatzi rirori nowinkatharitzinkaritepaeni. Piñeeyakinani nojampitakiri oetarikapaeni, omaanta noñaaperotakiri ikameethatatzi: tee añiiro rantani. ");
INSERT INTO cjoNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Eejatzi rirori Erooreshi, iñaaperotakiri kameethatatsi, rootaki roepiyantakinariri jaka. Ñaakiro, tekatsi rante nowamaakaanantyaariri. ");
INSERT INTO cjoNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Iroñaaka nopajatakaantashitawakyaari, roojatzi noeyowaanteeyari. ");
INSERT INTO cjoNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Rametapiinteeyawoni rirori maawaeni ojarentsi aririka omonkaatapaeya iroka kitejiri ikimoshiryaanteeyarini roeyowapiintzi apaani omonkyaagaarewo. ");
INSERT INTO cjoNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Omaanta maawaeni piyotawentakariri Jesoshi ikaemaeyanakini: —Powamaakaanteri irika, omaanta riraga Warawaashi poeyowaeri. ");
INSERT INTO cjoNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Paerani irika ikanteeyakirini atziri janta Jerojareeki: “Thame ookeri riraga pinkathari”. Eejatzi rowamayitzirini atziri, rootaki romonkyaanteetariri omonkyaagamentotsiki. ");
INSERT INTO cjoNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ikowawita Peraato roeyowaerimi Jesoshi, rootaki ikowantawitakari rojantzikaerimi atziripaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Omaanta eekiro ikaemaeyanakitziini riroripaeni: —¡Pikentakotakaanteri! ¡Pikentakotakaanteri! ");
INSERT INTO cjoNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Rapiitawitaari eejatzi Peraato: —¿Iitaka nokentakotakaanantyaariri? ¿Iitaka rantakiri? Nojampiteeyawitakimini, omaanta tee pikamantaperotana opoñaantyaari nowamaakaanantyaariri. Nopajatakaantashitawakyaari, roojatzi nopakaanteeyari. ");
INSERT INTO cjoNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Eekiro ikaemaeyanakitziini: —¡Pikentakotakaanteri! ¡Pikentakotakaanteri! Eekiro ikantanakitzi, roojatzi rakakaantakari Peraato, ");
INSERT INTO cjoNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ikantziri: —Ari nomateeyakironi iroka pikowakagaeyakinarini. ");
INSERT INTO cjoNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Roeyowakaanteeri Warawaashi, riraga piyathatachari eejatzi owamaantatsiri, eejatzi ikanteeyakirini: —Paanakiritya Jesoshika, pantero oetarika pikoyiri pantakaeriri. ");
INSERT INTO cjoNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ari ragaeyanakirini Jesoshi janta ikentakoterinta, ikinanaki awotsiki. Itonkiyoteeyawakarini shireenejatzi iitachari Shimo. Ipoñaanaka owantsiki. Ari romperatawakari joraaro inatanakiniri Jesoshi koroshi, rowaga ikentakotantyaarira. Royaatapaeri itapiiki Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Royaateeyanakirini osheki atziri. Eenitatsi eejatzi osheki tsinani ocheragaeyakini iraakoeyakarini. Osheki owashiretakoeyakarini. ");
INSERT INTO cjoNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Omaanta raminanakiro Jesoshi, ikanteeyanakironi: —Jerojareejatopaeni, eero piraakoeyanani, inta eeroka iraakoeyeenchani, eejatzi piraakoeyaarini peentsitepaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Iinja opomeentsitzimoeyemini, pashironkagaeyanakyaani. Iinja ikanteete: “Okimoshiretanaki kaari tzimatsi otomi”. ");
INSERT INTO cjoNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Eejatzi ikowaeyawitanakyaani atziripaeni opariyashiteeyerinimi impeeta atsinakantyaariri eero rañaantana. ");
INSERT INTO cjoNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Pamine, tekatsi nanteni naaka, omaanta rowashironkaawaetashitena. Tema iinja rashironkaaperoeyani osheki maawaeni antzirori kaari kameethatatsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Eejatzi ragaetanakiri apite koshitantatsiri, itsipatantakariri rirori Jesoshi, ikentakoetakiri. ");
INSERT INTO cjoNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Rareetakaanteeyapaakaririni janta tonkaariki iiteetziri Iitonakintsi ikentakoeyapaakirini koroshiki, tyag, tyag. Omaanta apaani koshintzi ikentakoetakiri rirori paashiniki koroshi janta rakoperokira Jesoshi. Irira paashini ikentakoetakiri jakakiroka rampateki. ");
INSERT INTO cjoNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Roojatzi ikenkithatakaantakariri Jesoshi Iriri: —Pawa, pikaminthayeri irikapaeni, eero powajankitawentziri rowamaakinaka. Tee riyowaetzi rirori oetarika rantziri. Riraga joraaropaeni ikowaeyakini ragaeyeroni iithaarini Jesoshi. Ikantawakagaeyakani: —Thame ookero mapyaaniki ayoteeyantyaarini ninkarika ayeroni iithaarini. Ikantanaki paashini: —Jee, thame. ");
INSERT INTO cjoNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ipiyotawenteeyakarini janta osheki atziri, amineeyiririni, eejatzi riraga pinkatharipaeni. Ishirontawenteeyakarini Jesoshi, injii, injii; ikantzi: —Rowawijaakotawitakari paashinipaeni, ajaatya aminawakiriita aririka iroñaaka imateeya rirori rowawijaakoteeya. Riroperotakirika Jesokirishito, riraga Rotyaantanewo Tajorentsi, ari imateeya rowawijaakoteeya. ");
INSERT INTO cjoNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Eejatzi riraga joraaropaeni, ishirontawenteeyakarini. Riyaatashitakiri, iperimi awishoowaantsi oowa kepishaari. ");
INSERT INTO cjoNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ikantakiri: —Eerokarika iwinkatharite joriiyo, ajaatya powawijaakoteeya iroñaaka: injii, injii. ");
INSERT INTO cjoNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Eeniro ikentakoteetakiro janta koroshiki jankinarentsi owaetakiniri jeñokiini ipatziitoki Jesoshi. Ojankinataka iñaaniki kireeshiyajatzi, eejatzi iñaaniki oroomajatzi, eejatzi iñaaniki joriiyo. Ojankinataka, okantzi: “Irika rirotaki jewawentziriri joriiyopaeni”. ");
INSERT INTO cjoNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Apaani koshintzi kentakoteencharira rampateki Jesoshi ishirontawentakari rirori ikantakiri: —Eerokarika Rotyaantanewo Tajorentsi, powawijaakotya eejatzi powawijaakotzitena naari. ");
INSERT INTO cjoNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Omaanta ikijathatanakiri paashini koshintzi, ikantakiri: —¡Pimaerite! ¿Tema pithaawantari Tajorentsi? Eejatzi eeroka rooteentsi pikame. ");
INSERT INTO cjoNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Eeniro antziri aaka, tee akameethatzi rootaki akamantyaari, omaantakya irika tekatsi rante ikamashitakya. Tee ikimitakotee aaka. ");
INSERT INTO cjoNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Roojatzi ikanantanakari: —Jesoshi, aririka pareeteeya janta Tajorentsikinta pikenkithashiryaapaena naari, powawijaakotena. ");
INSERT INTO cjoNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Rakanakiri: —Kyaaryo nokantemiri: iroñaaka kitejirika pitsipatapaakina janta okameethaperotzinta. ");
INSERT INTO cjoNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Ikaataki oorya tampatsika. Omapokashitanaka otsitenikaakiperotapaaki maawaeni kipatsi. Tee añaaneri oorya. Okaatzi ojamanitaki 3 oorapaeni. Roojatzi ooryaantanaa eejatzi. Tema eejatzi eenitatsi janta Tajorentsipankoki otzikayirori niyanki. Okantaka omapokashitanaka otzijagaanaki, waaag, thatzik; apitemankitanaka. ");
INSERT INTO cjoNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Roojatzi ikaemanaki Jesoshi, ikantanaki: —Pawa, iroñaaka nokame. Eeroka pikempoyagaena. Roojatzi ikamantanaka. ");
INSERT INTO cjoNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Iñaantawakariri iyapitaanote joraaropaeni, ikantanaki: —Tema ikameethataki Tajorentsi. Kyaaryo ikameethaperotzini irika shiramparini. Tekatsi rantani. ");
INSERT INTO cjoNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Eejatzi riraga amineeyiririni, ikenkithashireeyanakani maawaeni. Ipiyeeyanaani inampiki, osheki rowashireteeyanakani. ");
INSERT INTO cjoNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Omaantakya riraga yotakiriri Jesoshi, ikatziyeeyakani jantyaajeeni, ramineeyanakini. Okaateeyakirini iroka tsinanipaeni poñaachari Karireeyaki, tsipatapaakariri chapinki Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Ari ijeeki janta kameethari shirampari, iitachari Josee, arimateeyajatzi. Ojeeki Arimateeya janta Joreeyaki. Ari ikaatziri Josee riraga paashinipaeni ikaatzira ipinkathariteeyini joriiyopaeni, rowameethatawakaeyani, omaanta tee ikowawita rirori ikentakotakaanterimi Jesoshi. Ipinkathatziri riraga Tajorentsi, raamagaeyakarini ipokae ipinkathariwenteeyerini maawaeni atziri. ");
INSERT INTO cjoNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ikanta riyaataki rirori Peraatoki, ikantapaakiri: —Nokowaki pishinetenari Jesoshini, naaneeri. Ikantawakiri: —Kameethataki, ari paaneeri. ");
INSERT INTO cjoNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Roojatzi royiitakotantari, rapineetakotakiri tokoyaki, kameethamawotatsiri. Raanakiri janta ojeekinta mapi, rowaga owakira imokaetzi, romonkyaapaakiri inthomaenta. Tekiraata rowanteetawo kaminkari, rirotaki omapokapaakirori Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Tema rootaki weereneshi ikamantakari Jesoshi. Riwetsikaeyakironi atziri oetarikapaeni, tema rooteentsi saawaro imakoryaantapiintari. ");
INSERT INTO cjoNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Rowaga tsinanipaeni oyaatakowenteeyakirini Jesoshini, aminakoeyakirini ragaeyanakirini omooki, janta royaankakoeyakirini inthomaenta. ");
INSERT INTO cjoNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Roojatzi opiyanteeyanaani janta opankoki. Owetsikapaakiro kajankaari eejatzi paashini kajankaatatsiri. Areetantapaakari saawaro omakoryagaeyakini, omonkaatziro ikaminaantziri Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Otominkotapaaki, okanta tsinanipaeni iyaataki amaetyaaka janta rookaetakitzirinta Jesoshi. Aanakiro kajankaari owetsikakiri. Oyaatanakiro paashinipaeni tsinani. ");
INSERT INTO cjoNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Areetapaaka rowaetakirira chapinki omooki antawo mapi, ratsinakakotanteetakariri omooki. Areetantawitapaakawori oñaapaatziiro ashitaryaanaka mapi. ");
INSERT INTO cjoNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Okyaashitawitapaakari Jesoshini omooki, omaanta tee oñaapaeri Awinkatharite. ");
INSERT INTO cjoNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Tee iyoteeyanakini oetarika okenkithashiryaanakyaari. Roojatzi romapokantapaakawo apite shirampari, ikatziyimotapaakawo okaakini. Oshipakiryaamawotaki iithaari. ");
INSERT INTO cjoNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Osheki othaawantawakari, oeyomaetanaka roojatzi kipatsiki. Rojampitapaakiro: —¿Iitaka paminantariri añaatsiri jaka? Jaka rookaetziri kaminkari. ");
INSERT INTO cjoNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Tee añagaeri Jesoshi jaka, tema tzinaanaa. Pikenkithashireero ikamantzitakimirini janta Karireeyaki. ");
INSERT INTO cjoNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Tema ikantzi: “Naaka poñaachari janta jenokinta, nokoñaatapaaki jaka kipatsikika. Iinja rayena kaari aapatziyana, ikentakotena koroshiki. Okaate 3 kitejiri ari nopiriintanee eejatzi”. Monkaataka iroñaaka. ");
INSERT INTO cjoNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Roojatzi okenkithashiryaantanaawo ikamantzitakaworini rirori. ");
INSERT INTO cjoNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Opiyanaa okamantapaakiri riyotaanewopaeni eejatzi paashinipaeni aapatziyariri. ");
INSERT INTO cjoNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Owaero iroka tsinanipaeni: Mariiya rowaga makaraarajato, Jowaana, Mariiya riniro Jantyaako, eejatzi paashinipaeni tsinani. Tema okantawitakari rotyaantanewo Jesoshi iroka. ");
INSERT INTO cjoNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Omaanta tee raapatziyawo riraga riyotaanewopaeni Jesoshi iroka okamantawitapaakariri, iitakaashiteeyakani okantawaetashita. ");
INSERT INTO cjoNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Omaanta riraga Peetero ishiyanaka janta omooki rowaeyawitakarininta chapinki Jesoshi. Raminapaakiro inthomaenta, iñaapaakiro tokoya iponatantawitakariri. Roojatzi ipiyanaa pankotsiki, osheki ikenkithashiryaakotanaka. ");
INSERT INTO cjoNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ikanta riyaatanaki apite riyotaanewo Jesoshi janta nampitsiki owaero Emawooshi. Ipoñaaka Jerojareeki, okaatzi ojamanitzi 11 kiroometero rareetantyaari nampitsikinta. ");
INSERT INTO cjoNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ikinanaki, ikenkithatakaawakaanaka. Ikenkithatakotziri awijimotakiriri Jesoshi, eejatzi maawaeni okaatzi rantakiri. ");
INSERT INTO cjoNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ranashita ikenkithatakaawaka, roojatzi itsipatantapaakari riraga Jesoshi, kijokiro rowanakiri janta awotsiki. ");
INSERT INTO cjoNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Iñaawitawakari, omaanta tee ishinetziri Tajorentsi riyotawakiri. ");
INSERT INTO cjoNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ikantapaakiri: —Inkaaganki pikinantapaakari awotsiki, ¿iitaka piñaanatawakaantari? ¿Iitaka powashiretantakari? ");
INSERT INTO cjoNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ikanta apaani iitachari Kerejowashi, rakanakiri: —Riyoteeyakini maawaeni jerojareejatzi okaatzi awijeentsiri. ¿Apatziroma pikantakaakawo eeroka tee piyotzi oeta awijeentsiri? ");
INSERT INTO cjoNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ikantanakiri: —¿Iitakakya? Ikantawakiri: —¿Tema pikemakotziri Jesoshini, riraga Najareetejatzi? Ikenkithatakaapiinteeyanawoni ikoyiri Tajorentsi eejatzi osheki itajonkantapiintzi. Iñaaperotziri irira eejatzi iñaaperotziri maawaeni atziri ikameethatzi. ");
INSERT INTO cjoNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Raakiri riraga jewawentziriripaeni ñaanakowenantatsiripaeni eejatzi awinkatharitepaeni. Ikanteeyakini tee ikameethatzi, ikentakotakaantakiri kamaki. ");
INSERT INTO cjoNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Noetashitawitaka irira rirotaki owawijaakoeyenarinimi aakapaeni maawaeni joriiyopaeni, pinkathariwenteeyenarinimi. Omaanta iroñaaka okaataki 3 kitejiri ikamantakari. ");
INSERT INTO cjoNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Jataki tsinanipaeni inkaaganki amaetyaaka janta rowawiitakarinta Jesoshi. Opiyantapaakari, ");
INSERT INTO cjoNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","okamantapaakina: “Tee noñagaeri Jesoshini, tekatsi. Omaantakya noñaapaakiri ronampiripaeni Tajorentsi, ikantawakina: ‘Piriintanaa, añaagae Jesoshi’ ”. Rootaki okantapaakinari. ");
INSERT INTO cjoNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Roojatzi ishiyantanaka apaanipaeni riyotaanewo Jesoshi janta, raminakitziro rowawiitakarinta iñaapaakiro okaatzi okantakinari, omaantakya Jesoshini, tee iñiiri. ");
INSERT INTO cjoNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Roojatzi ikantakiri: —Tee añiiro piyotantari, pitheenkakiro ikantziri riraga kamanantayitzirorini iñaani Tajorentsi. Tee paapatziyawo. ");
INSERT INTO cjoNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Tema ikantzitakani rityaawo riraga Rotyaantanewo Tajorentsi ikemaatsityaawo osheki katsiri, roojatzikya ipinkathariperotanaki. ");
INSERT INTO cjoNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Roojatzi riyotaantakoperotanaka rirori apaniroeni Iwaperite Tajorentsi, ithotyaanakiro maawaeni kenkithatakotziriri rirori. Ritanakari rojankinarini Moeseeshi, rimpaetakiro riyotaakiri rojankinarini paashinipaeni kamanantayitzirorini iñaani Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Rareeteeyantapaakarini nampitsiki, rooteentsi rawijanakimi riraga Jesoshi, ");
INSERT INTO cjoNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","omaanta ikanteeyawakirini paashinipaeni: —Eero piyaatziita, pijeekanakiita nopankoki. Tsiteniityaaki, rooteentsi otsitenite. Roojatzi riyaatantapaenta ipankoki. ");
INSERT INTO cjoNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Roojatzi itsipateeyantapaakarini rowa. Raapaakiro paa riraga Jesoshi, ipaasonkitakiri Tajorentsi, roojatzi ipantakari maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Okantaka opokimotapaakiri ikenkithashiryaanaka, riyotataatziiri Jesoshi. Roojatzi ipeyimotantanaari eejatzi, tee iñaawaeri. ");
INSERT INTO cjoNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ikantawakaanaka: —Rootawetsikya rookantzimotakaakinawo kameetha najankaneki ikenkithawaetakaantapaakaeri janta awotsiki. Riyotaantakaerori okantakotziri Iwaperite Tajorentsi. Tema osheki akimoshirewentaperotakiro okaatzi ikantakaeri. ");
INSERT INTO cjoNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Roojatzi ipiyantanaa Jerojareeki. Iñaapaatziiri janta riraga 11 riyotaanewo Jesoshi, itsipatakari paashinipaeni aapatziyariri, ipiyoteeyakani. ");
INSERT INTO cjoNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ikantawakiri maawaeni jeekatsiri janta: —Kyaaryoroña piriintaperotanaa Awinkatharite añaagae. Iñaawakiri Shimo. ");
INSERT INTO cjoNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Roojatzi ikanantapaakari riraga apite: —Eejatzi naari, noñaagaeri janta awotsikinta, kameethapero riyotaakina omaanta tee niyotzitawitari, omanimoshiryaakina janta nopankoki ikagaantakawori paa, ipantakinawori, aripaete niyotanakiri. ");
INSERT INTO cjoNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Eeniro ipiyoteeyakani pankotsiki ikenkithatakaawakagaeyani, roojatzi romapokantapaakari Jesoshi, ikatziyimoeyapaakarini niyanki. Ikantapaeri: —Pikimoshireeyanakini, maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Rotsikanateeyanakarini, tee riyoteeyawakirini, iitashiteeyawitawakarini kamaari. Ithaawanteeyakarini. ");
INSERT INTO cjoNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Rojampitapaakiri: —¿Iitaka pithaawanantanari? ¿Iitaka pitheenkaeyantanarini pajankaneki? ");
INSERT INTO cjoNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Pamineeyeroni nako eejatzi noetzi ikyaantanakinaga kiraawo. Naaka pokaatsiri. Ajaatya, pipampiteeyenani piyoteeyantenarini. Piñaakina, eenitatsi nowatha eejatzi notonki. Tee naaka kamaari. Riroma kamaari tekatsi iwatha eejatzi itonki. ");
INSERT INTO cjoNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Roojatzi roñaaganteeyakarini rako eejatzi iitzi. ");
INSERT INTO cjoNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Omaanta eeniro itheenkaneentayitzini, tee raapatziyaperotari rirotaki piriintaacha. Ikimoshireeyawitakani jeñokiini iwathakira omaanta jaga rajankaneki eeniro ikantashireeyini: “Kyaaryo, rirotakiroña ari aamaashitya kaaririka”. Rootaki ikanantanakariri: —¿Eenitatsima oyaari? ");
INSERT INTO cjoNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ari ipakiri shima tashirentsi. ");
INSERT INTO cjoNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Raawakiri, royimotakari. Ari ramineeyakirini, joreririri. ");
INSERT INTO cjoNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Roojatzi ikanteeyantakarini: —Tema chapinki nokamantzitakimi: “Osheki nokemaatsityaawo, rowamagaetena. Otzimatye omonkaatya maawaeni rojankinatakotzitakinarini Moeseeshi, eejatzi riraga kamanantayitzirorini iñaani Tajorentsi, eejatzi riraga mampaawaetawenteeyaririni irira”. Iroñaaka monkaataka. ");
INSERT INTO cjoNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Roojatzi riyotaaperoeyantakaririni okantayitzirini Iwaperite Tajorentsi, ");
INSERT INTO cjoNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ikanteeyakirini: —Tema okantzi Iwaperite Tajorentsi: “Aritaki ikamaki Rotyaantanewo Tajorentsi, okaate 3 kitejiri ari ipiriintanee eejatzi. ");
INSERT INTO cjoNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ikenkithatakoteeteri maawaeni kipatsikipaeni, ritanakyaawo jaka Jerojareeki: ikemakoeyakirini maawaeni atziri. Ikamanteeyerini irirapaeni: ‘Pikenkithashireeyanakyaani, pookaeyeroni kaari kameethatatsi panteeyirini. Pameentyaari Tajorentsi rowawijaakotantemiri’ ”. ");
INSERT INTO cjoNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ari piñagaeyakironi iroñaaka monkaataka rojankinatakotziteetakinarini paerani. ");
INSERT INTO cjoNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Iroñaaka notyaantemiro ikashiyakaakimiri Pawa: opokashitemi Ishire, okithaatakayemi. Omaanta pijeekawakiita jaka nampitsikika roojatzi opokawakiita. Ari omatakagaeyemini panteeyantyaaworini oetarikapaeni ikowakagaeyemirini Pawa. ");
INSERT INTO cjoNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Paashini kitejiri ragaeyantanakarini riraga Jesoshi riyotaanewopaeni janta Wetaaniyaki. Ari janta niyanki, rowankanakiro rako Jesoshi, ikenkithatakaakiri Iriri, ikantziri: —Pawa, irika niyotaanewopaenika: pitajonkawenteeyerini, piweshiryaakagaeyaarini. ");
INSERT INTO cjoNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ikantzirika iroka, eekiro roenokanaa jenokinta, peyanaa. ");
INSERT INTO cjoNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Osheki ipinkathateeyakirini, roojatzi ipiyanteeyanaani Jerojareeki, ikimoshireeyanakini osheki. ");
INSERT INTO cjoNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Riyaatapiintaki janta Tajorentsipankoki, ikantapiinteeyakini: —Tema ikameethataki Tajorentsi. Ari okaatzi. Naaka jankinatzirori: Rookashi");
INSERT INTO cjoNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Iroñaaka naaka Jowa nojankinatakoteri irira apintzitatsiri rirotaki iyoperotakotakaaneeriri Tajorentsi. Naaka riyotaanewo Jesoshi. Tekirani riwetsikironi kipatsi, eeniro ijeeki riraga iyoperotakotakaaneeriri Tajorentsi. Itsipatarini irira Pawa Tajorentsi. Eejatzi rirotaki Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ikempiyakarini paeraniperoroña ashitariri. ");
INSERT INTO cjoNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Riraga iyoperotakotakaaneeriri Tajorentsi rirotaki wetsikirori maawaeni, oetarikapaeni añaayitzirini. Tekatsi paashini wetsikeroni oetarika. Tekatsimi irira, eeromi riwetsikaeyeronimi okaatzi añaayitzirini, ari tekatsi tzimashitachanimi. ");
INSERT INTO cjoNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Rirotaki owañagaeyakaerini eejatzi roshiyakawo kitejitakotakagaeyeerini: tema riyoperotakaakae tsika ikantari Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Paerani tee ayoteeyawitarini rirori, okimitzimotakae ajeekakitzi tsiteniriki; roojatzi ipokantapaakari riraga iyoperotakotakaaneeriri Pawa Tajorentsi. Iroñaaka okimitzimotakae akitejitakoeyakini. Tema kameetha riyoperotakotakaeri rirori aakapaeni. Iroñaaka riraga theenkiriri rirori okimitzimotari eekiro riyaatatyee ijeeki tsiteniriki; omaanta tee imatziro rantakagaero apiitantyaawori ajeeki tsiteniriki. ");
INSERT INTO cjoNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Riraga Pawa Tajorentsi rotyaantakiri shirampari iitachari Jowa. ");
INSERT INTO cjoNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ikowanteeri rirori maawaeni aaka aapatziyaperotyaari riraga iyoperotakotakaaneeriri Tajorentsi. Rootaki rotyaanantariri riraga Jowa ikantakotayitapaakirini irira. Ari ikinanaki riraga Jowa ikantakotayitapaakirini rirori. ");
INSERT INTO cjoNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Kaari irira rirotaki iyoperotakotakaaneeriri Tajorentsi, inta riraga Tajorentsi rotyaantakaeri rirori ikantakotantapaakyaariri irira impaetatsini. ");
INSERT INTO cjoNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ari impaetzi ipokantapaakari riraga iyoperotakotakaaneeriri Tajorentsi jaka kipatsiki. Roojatzi riyoperotakaantanakaeriri Tajorentsi aakapaeni jeekatsirika kipatsikika. ");
INSERT INTO cjoNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ari ijeekimotapaakiri atziripaeni kipatsikika. Tema riwetsikantakawori kipatsi paeraniperoroña omaanta tee riyoteeyawakirini atziri rirotaki wetsikaeyakirorini. ");
INSERT INTO cjoNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ipokawitapaaka rashiki iipatsiteki: ipokawitapaaka ijoriiyotzinkarite, omaanta tee ipinkathatawakiri. ");
INSERT INTO cjoNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Omaanta reentsitetari Tajorentsi apaanipaeni atziri. Ninkarika aapatziyakariri riraga iyoperotakotakaaneeriri Tajorentsi, riraga ameentariri, tema reentsitetakari riraga Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Eero reentsitetee akowashitari aaka, eejatzi tee ro akoñaatashitee reentsitetee Tajorentsi inta ikowashitanaka irira reentsitetakae. ");
INSERT INTO cjoNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Riraga iyoperotakotakaaneeriri Tajorentsi ipokapaaki jaka kipatsiki ikoñaatapaaki atziri. Iitantakari Jesoshi. Riraga Pawa Tajorentsi rotyaantakiri jaka. Ijeekimoeyapaakaeni aakapaeni itsipatakae. Noñaayitawakirini irira rapintzite Itomi Pawa Tajorentsi ishipakiryaaki. Ikimiperotakari Iriri; rirotaki kyaaryooperotatsiri, eejatzi ineshironkaperotakae aaka. ");
INSERT INTO cjoNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ikanta riraga Jowa riyotaakotakiri riraga Jesoshi ikantakotakiri irira rirotaki iyoperotakotakaaneeriri Tajorentsi. Ikantayitakirini riraga atziri: —Irika Jesoshi nokamantakotakiri chapinki. “Ranaakotena riraga impaetatsini. Tekirani nokoñaatzini naari, eenironi ijeeki rirori itsipatari Ashitariri Tajorentsi”. ");
INSERT INTO cjoNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Irira Jesoshi ashi royiro inintaperotantzi rootaki ineshironkaperotanteeri aaka. Eekiro riyaatatzi ineshironkaperotakae. ");
INSERT INTO cjoNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Paeraniperoroña riraga Tajorentsi rojankinatakaeriri Moeseeshini. Rojankinatziro oetarika ikowakiri anantyaawori aaka ajeekantyaari kameetha. Eejatzi rojankinatakotziri riraga Jesokirishito ineshironkaperotakae. Iroñaaka ipokaki irira tema rirotaki kyaaryooperotatsiri, neshironkaperotantatsiri. ");
INSERT INTO cjoNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Tekatsi atziri ñeerini Tajorentsi, omaanta riraga Jesoshi Itomi rapintzite iñiiri. Ikimitari Iriri, rooma kijokiro royiri. Tema itsipatawakaaka. Apintzi irira iyoperotakotakaaneeriri riraga Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Nityaawo nokantakoteri riraga Jowa okaatzi ikantakotakiri riraga Jesoshi. Riraga jewatatsiripaeni joriiyopaeni jeekatsiri janta Jerojareeki rotyaantakiri apaanipaeni ñaanakowenantatsiri Jowaki rojampikowentakaantakiri irira. Eejatzi rotyaantakiri apaanipaeni amitakotantatsiri ñaanakowenantatsiri itsipatakari: tema rirotaki icharineeteni Rewiini. Rojampitapaakiri, ikantapaakiri: —¿Iitaka pikaawoshitakotantariri Tajorentsi atziri? ¿Ninkamika? ¿Eerokama Rotyaantanewo Tajorentsi naamagaeyawitakarini? ");
INSERT INTO cjoNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ikantaperotawakirikya: —Kaari naaka. ");
INSERT INTO cjoNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Rapiitakiri: —¿Kyaaryo? ¿Eerokama Iriiyashini? —Kaarina. —¿Eerokama riraga kamanantzirori iñaani Tajorentsi naamagaeyakarini? —Kaarina. ");
INSERT INTO cjoNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Rapiitakiri: —¿Ninkamika? ¿Iitaka nokantapaeriri otyaantakinari? ¿Iitaka pantziri? ");
INSERT INTO cjoNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ikantawakiri: —Naaka ikenkithatakotzini paeraniperoroña Iseeyashi riraga kamanantzirorini iñaani Tajorentsi. Rooma rojankinatzini: “Iinja ipokae kaematsini, ikenkithatapiinte janta tekatsinta atziri ipanko, ikante: ‘Pikenkithashireeyakya, paapatziyari Awinkatharite, rowameethatantemiri. Rootaki ipokantyaari riyoteemiro pijeekatyaari kameetha. Ipokantyaaripa’ ”. ");
INSERT INTO cjoNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Irika pokaentsiri riraga ojampitantatsiri rirotaki warijeeyopaeni. ");
INSERT INTO cjoNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ikantapaakiri: —¿Kyaaryo? ¿Kaarimima Rotyaantanewo Tajorentsi? ¿Kaarimima Iriiyashini? ¿Kaarimima riraga kamanantzirorini iñaani Tajorentsi naamagaeyakarini ipokae? ¿Iitaka pikaawoshitakotantawakariri Tajorentsi riraga atziripaeni? ");
INSERT INTO cjoNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ikantawakiri: —Tema naaka nokaawoshitakotantawakariri Tajorentsi apatziro iñaa. Eenitatsi iroñaaka paashini shirampari kaari piyotzi eerokapaeni itsipatakae: tema rirotaki riraga Rotyaantanewo Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Rirotaki impaetanari, tema rirotaki jewaperotatsiri. Osheki noñaakoweenkaperotziri irira. Tee noñaakoweenkaperota naari. ");
INSERT INTO cjoNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Aritaki ikantapiinta riraga Jowa janta Wetaaniyakinta, intatsikeronta Joriraaniki. Janta ikaawoshitakotapiintarinta Tajorentsi atziripaeni iñaaki. ");
INSERT INTO cjoNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Okitejitanaki raminanaki riraga Jowa iñaawakiri Jesoshi ipokapaaki. Ikantziri atziripaenika: —¡Pamine sha! Irikatapaaki Jesoshi riraga Rotyaantanewo Tajorentsi. Iwaero eejatzi rowishate Tajorentsi. Ikamawentee paata aaka maawaeni atziri, iñaaperotanteeri Ashitariri akameethatzi. Raapithateero aakapaeni oetarika kaari kameethatatsi antziri. Oshiyantyaariri rowamagaetantyaariri owisha iñaaperotanteeri riraga Tajorentsi aaka maawaeni joriiyo akameethatzi. ");
INSERT INTO cjoNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Rirotaki irira nokenkithatakotakiri chapinki nokanantakariri: “Ranaakotakina impaetapaenani, rirotaki jewaperotatsiri. Osheki noñaakoweenkaperotakiri irira. Tee noñaakoweenkata naari. Tekirani nokoñaatzini naaka, eenironi ijeeki irira itsipatakari Pawa Tajorentsi”. ");
INSERT INTO cjoNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Paerani tee niyowitarini rirotaki Rotyaantanewo Tajorentsi, omaanta iroñaaka niyoperotziri. Eejatzi ikowaki riraga Tajorentsi riyoteri maawaeni ikaateeyinira nojoriiyotzinkarite. Rootaki nopokantakari naaka nokaawoshitakotawakiri maawaeni nojoriiyotzinkarite nookotantyaariri rirori. ");
INSERT INTO cjoNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Roojatzi ikanantanakari: —Tee niyotawitarini naaka. Omaanta rotyaanantakinari riraga Tajorentsi, ikantakina: “Pikaawoshitapiintawakiri atziri iñaaki, piyoteeri maawaeni riroripaeni ikenkithashiryaakotena. Iinja piñaawakiro ayiitapaaki Noshire. Ninkarika ookantapaakyaari rirotaki riraga kithaatakotawakawori atziripaeni Noshire”. Ari impaetzi noñaawakiro oshawiinkapaaki Ishire Tajorentsi. Opoñaaka jenokinta, ookantapaakari Jesoshi. Oshiyaawitapaakari jamomo. ");
INSERT INTO cjoNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Kyaaryo noñaaperotakiro. Rootaki nokantakotantakariri: “Rirotaki Itomi Tajorentsi”. ");
INSERT INTO cjoNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Okitejitanaki rapiitakiro ikatziya riraga Jowa jaga itsipatana naaka riyotaanewo apite. ");
INSERT INTO cjoNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Raminakiri riraga Jesoshi ikatziyatziyawaetatya janta awotsiki. Ikantzi riraga Jowa: —¡Sha! Pamineri irinta. Rirotaki Rowishate Tajorentsi; riraga Rotyaantanewo. Rotyaanantariri ikamawenteeyerini maawaeni atziri, rowawijaakotanteeri. Roshiyakari owisha rowamaapiintziri ñaanakowenantatsiri iñaaperotanteeri Tajorentsi aakapaeni joriiyo akameethatzi. ");
INSERT INTO cjoNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Nokemantawakariri riraga Jowa naaka riyotanewo apite, rootaki noyaatantanakariri riraga Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ipithokashitakina irira iñaakina noyaatakirira. Ikantakina: —¿Iitaka pikoyiri? Nokantawakiri: —Tekatsi. Iyotaantatsiri, ¿tsika pijeekika? ");
INSERT INTO cjoNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ikantawakina: —Thame poyaatanakina noñaayemiro. Roojatzi noyaatantanakariri rirori, noñaapaakiro pankotsi ashinentsi ijeekantari. Ari jenokitapaaki oorya. Noñaapaakiro pankotsi, nojeekimotapaakiri maawaeni kitejiri. ");
INSERT INTO cjoNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Iwaero paashini areetapaenchari Antereeshi rirotaki rirentzi Shimo iiteeteri paata Peetero. ");
INSERT INTO cjoNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","42","Tsitenini oorya riyaatanaki Antereeshi raminakiteri rirentzi. Iñaantapaakariri irira, ikantapaakiri: —Noñaakiri Rotyaantanewo Tajorentsi. Thame poyaatanakina, piñaapaeri. —Jee, thame. Ari rareetapaakari Jesoshiki. Raminawakiri, ikantawakiri: —Rooma eeroka Shimo, itomi Jonaashi. Iinja iiteetemi: Peetero. ");
INSERT INTO cjoNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","44","Okitejitanaki riraga Jesoshi ikoyi ipiyanee ipankokinta janta paashiniki kipatsi. Oeta kipatsi Karireeya. Naakapaeni riyotaanewopaeni itsipatakina. Omaanta tekirani riyaateni janta, riraga Peetero raminakitziri jaga riyompari Jiripi. Romiñaakiteri. Jiripi, Peetero eejatzi Antereeshi ipoñaaka Wetheeraki: itsipatawakaaka janta. Wetheera rootaki nampitsi jeekatsiri janta Karireeyaki. Raminakitziri, ari iñaakiri rirori, ikantziri: —Thame pamineri Rotyaantanewo Tajorentsi. —Jee, thame. Iñaantawakari Jesoshi riraga Jiripi ikantawakiri: —Thame poyaatanakina. Roojatzi royaatantanakari. Ari jateeyanakini maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ari yowapaakina maawaeni janta okaakini Kanaa, paashini nampitsi jeekatsiri Karireeyaki. Ari irira Jiripi riyaatakitzi ipankoki riyompari Nataneeri. Iñaapaakiri ikantapaakiri: —Noñaakirikya riraganki, rojankinatakotzitakarini paeraniperoroña Moeseeshi. Eejatzi kamanantayitzirorini iñaani Tajorentsi rojankinatzitakoeyarini rirori. Rirotaki Jesoshi, itomini Josee najareetejatzi. ");
INSERT INTO cjoNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ikantawakiri: —Tee ikameethatzi maawaeni najareetejatzi. ¿Kyaaryooperoma ikameethatzi rirori? Rakanakiri Jiripi: —Thame paminakiteri, piyotantyaariri ikameethatzirika. Ari riyaatanaki. ");
INSERT INTO cjoNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ari rokaakinteeyapaakarini riraga Jesoshi iñaawakiri ipokapaaki, ikantziri tsipatayitakaririni: —Pamineriroña riraga Nataneeri. Rirotaki joriiyopero kimiperotariri itakaantawori paerani Ishirayeerini: ikameethataki, tee riyotzi ramatawitantzi. ");
INSERT INTO cjoNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Rojampitapaakiri Nataneeri, ikantapaakiri: —¿Tsika pikantakaka piyotantawakinari nokameethatzi? Ikantawakiri: —Noñaakimi janta pontsiritawo iyeera, tekira ikenkithatakaemi Jiripi. ");
INSERT INTO cjoNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Rakapaakiri riraga Nataneeri: —Tema eeroka Itomi Tajorentsi: pithotyaakiro maawaeni, piyotayitzirini. Eerokataki jewawentziriri joriiyopaeni. ");
INSERT INTO cjoNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ikantawakiri: —Pamine, inkaaganki nokantakimi: “Noñaakimi pontsiritawo iyeera”. ¿Rootakima paapatziyantakinari? Ari piñeena iinja notajonkantaperotanaki osheki, impaetzikya paapatziyantaperotenari. ");
INSERT INTO cjoNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Kyaaryootaki iroka nokantemiri. Aritaki piñaakiro iinja jenokiperonta inthomaenta. Piñaakiri ronampiripaeni Tajorentsi rayiitashitena ipiyaneero eejatzi. Ikanantari nopokantari jaka kipatsiki niyoperotakotakaeriri riraga Tajorentsi maawaeni atziri. Tema naaka poñaachari jenokinta, nokoñaataki jaka kipatsikika. ");
INSERT INTO cjoNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","2","Okaatzi nomaaki apite. Okitejitanaki aritaki ikimoshireeyini maawaeni kanaajatzi. Ojeeki nampitsi owaero Kanaa kipatsi owaero Karireeya. Ikimoshirewenteeyakirini riroripaeni apaani shirampari owakira rayirowa iina. Tema romiñaakiri oshekini atziri rakiyoteri. Eeniro ikaateeyinira kanaajatzi, eejatzi roori riniro Jesoshi, eejatzi notsipateeyakarini naaka, Jesoshi, eejatzi paashinipaeni riyotaanewo, maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ari rowaeyakani maawaeni atziri eejatzi imiritaki awishoowaantsi oowa, rootaki iwyaaritayitarini joriiyopaeni rirori. Rooteentsi ithaatzimatero, rootaki okanantariri rowaga riniro Jesoshi: —Tekatsi paashini awishoowaantsi oowa: ¿tema aritaki pimatakiro pamitakoteri? ");
INSERT INTO cjoNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ikantawakiro: —Nana, ¿iitaka pikanantanari? Tekiraata omonkaata notajonkante. ");
INSERT INTO cjoNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Omaanta okantziri roori onampirentsipaeni jaga: —Pikemijantaperoterira oetarika romperatemiri. ");
INSERT INTO cjoNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Eeniro jaga chomoo antawopero okaatzi 6. Riwetsikaetziro mapi. Rootaki ojeekantari iñaa ikiwantapiintari joriiyopaeni ikiwawakowentari Tajorentsi. Omaanta iroñaaka thaataka. ");
INSERT INTO cjoNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ikantziri rirori maawaeni onampirentsi: —Piyeekitero iñaa chomookipaenira. Ari riyeekiteeyakironi maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Roojatzi ikanantanakari: —Pikitero iroñaaka paakotanakiniri omperatzimiri, pimpaete paakotanakiniri maawaeni atziri. Ari raakotanakiniri. ");
INSERT INTO cjoNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ikemijantawakiro riraga omperatariri, tema opeyanaka awishoowaantsi oowa. Tee riyotzi omperatariri onampirentsi tsikarika opoñaaka iroka, omaanta riyotaki onampirentsi, iyeekitzirori chomookira iñaa. Roojatzi riraga omperatantachari ikaemantakariri aatsiri iina. ");
INSERT INTO cjoNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Ikantziri: —Tema rootaki itapiintari kameethari awishoowaantsi oowa aperi atziri. Aririka ashinkitawitanakyaani apokashitapaero majankaari. Aritaki okantari ameteeyarini. Eerokaritya eeroka kempoyaakirori rowaga kameethari. Owakira iroñaaka pamakaantakiro. Ari maawaeni ririro. ");
INSERT INTO cjoNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ari janta Kanaa jeekatsiri Karireeyaki, ritakawo Jesoshi itajonkantaki. Roñaagakinawo ishintsinka. Noñaakiri naaka eejatzi paashini riyotaanewo, roojatzi ameenantanakariri maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Roojatzi noerinkanteeyanakarini Kaperinawooki. Itsipatanakina Jesoshi naaka, riniro, rirentzipaeni, rirojatzi paashinipaeni riyotanewo. Ari nokaateeyanakirini maawaeni. Nomagaeyanakini janta apaanipaeni tsiteniriki. ");
INSERT INTO cjoNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Rootzimateentsi kitejiri nokimoshiryaantapiintari naakapaeni joriiyo owaero Kitejitatsiri rawijantariri ronampiri Tajorentsi. Nokenkithashiryaakotawo kitejiri paeraniperoroña rawijantakarini irira ipankokipaeni nochariniiteni janta Ejiipitoki. Rootaki oshekini atziri itonkaantanakari Jerojareeki tonka, tonka, tonka, ipinkathatantariri riraga Tajorentsi. Ari itonkaanaki riraga Jesoshi janta. Nokaatanakiri paashinipaeni riyotanewo noyaatanakiri. ");
INSERT INTO cjoNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Nokyaakaapaakiri Tajorentsipankoki noñaapaakiri janta pimantatsiri waaka, owisha, jamomo, maawaeni. Eejatzi ijeekaki jaga kaampiyayitziririni atziri iyorikitepaeni. ");
INSERT INTO cjoNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ari iñaakiro riraga Jesoshi shiwithapaeni riwetsikashitakiri pajamentotsi ipajatantyaariri waaka. Roojatzi romishitowanteeyakaririni owisha, waaka, maawaeni. Ipitamenkakotakiri imeejatekipaeni kaampiyayitziririni iyorikitepaeni, rojokitakiri iyorikite. ");
INSERT INTO cjoNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ikanteeyirini pimantatsiri jamomo: —Pagaeyanakirini irika. Eero pipimantawaetzi jaka nopinkathatapiintzirika Pawa. ");
INSERT INTO cjoNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Roojatzi nokenkithashiryaantanakawo rojankinatakotziteetakaririni irira Jesoshi paeraniperoroña Iwaperiteki Tajorentsi: “Naamaakotzitakari, Pawa, iroka Tajorentsipankoka; rootaki rowamaanteetenari iinja”. ");
INSERT INTO cjoNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ikantanakiri jewatatsiripaeni joriiyopaeni: —¿Iitaka panantawori iroka? ¿Iitaka poñaayenari niyotantemiri eerokarika rotyaantzi irira Tajorentsi? ");
INSERT INTO cjoNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ikantawakiri: —Pishekiroreero iroka Tajorentsipankoka ari okaate 3 kitejiri napiiteero notzinagaero. ");
INSERT INTO cjoNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Roojatzi ikijathatantanakari riraga jewatatsiripaeni joriiyo: —Okaatzi oshekini ojarentsi riwetsikanteetakawori iroka Tajorentsipankoka. ¿Arima okaate 3 kitejiri piwetsikanteeyaawori eerori? Eerowa pimatziro. ");
INSERT INTO cjoNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ñaakiro, rirojatzi oshiyakaawentachari. Riroma rirotaki oshiyakaawentachari iwatha Tajorentsipankoka, rooma kijokiro royiri Ashitariri. ");
INSERT INTO cjoNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ikamantakari, okaataki 3 kitejiri ipiriinantanaari. Roojatzi, aritaki nokenkithashireeyanakironi iroka oshiyakaawentachari. Eejatzi niyotanakiro okenkithatakotakirini paerani Iwaperite Tajorentsi monkaataka iroñaaka maawaeni okenkithatakotakiri. ");
INSERT INTO cjoNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Areetapaaka Kitejitatsiri rawijantari ronampiri Tajorentsi nokimoshiryaantari maawaeni naaka joriiyojatzi. Ijeekapaaki riraga Jesoshi Jerojareeki, osheki itajonkantayitapaakini. Iñaayitakirini atziri, rootaki raapatziyeeyantakaririni. ");
INSERT INTO cjoNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Omaanta riyotzi rirori iitaka ikenkithashiryaari maawaeni atziri, rootaki raamaantanakari: “Ragaetanakinakari”. ");
INSERT INTO cjoNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Riyotakiri riraga atziri iitaka ikenkithashireeyarini. Riyotashitaka, tekatsi kamanterini. ");
INSERT INTO cjoNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Eeniro shirampari jewatziriri joriiyopaeni iwaero Nikoreemo. Rirotaki warijeeyo. ");
INSERT INTO cjoNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ikanta riraga Nikoreemo ipokashitakiri Jesoshi tsiteniriki, ikantapaakiri: —Iyotaanari, niyotakimi pipoñaaka Tajorentsiki. Rootaki pipokantakari, piyoteeyapaenani. Eeromi itsipatzimimi Tajorentsi eeromi pitajonkantzimi. Rootaki nokowantari piyoteena naari. ");
INSERT INTO cjoNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ikantawakiri riraga Jesoshi: —Kyaaryooperotaki iroka nokantemiri: riraga kaari apiitaachani ikoñaatee, eero reentsitetari Tajorentsi, eejatzi eero imatziri iñiiri irira, itsipatantyaariri jenokinta. ");
INSERT INTO cjoNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ikantapaakiri riraga Nikoreemo: —Aririka antyashiparitaki, ¿tsika akantyaaka apiiteero akoñaatanteeyaari? ¿Arima amateero apiyaneero omotziki anironi apiitero akoñaatantapaeyaari? ");
INSERT INTO cjoNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ikantawakiri: —Kyaaryootaki iroka nokantemiri: maawaeni kaari apiitaachani ikoñaatee eero reentsitetari Tajorentsi. Omaanta aririka rityaawo okoñaateri riniro eejatzi impaetzi apawo otzimiri Ishire Tajorentsi, aritaki rashitakyaari riraga Tajorentsi eejatzi raminakowiritantakiri. ");
INSERT INTO cjoNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Tsinani aririka oeyoyeeri otomi, ikimitari ashitariri, ikame. Eejatzi okimiwitaka Ishire Tajorentsi, aririka otzimeri atziri ikimityaari Tajorentsi, eero ikami, inta ikantyaani ijeeki itsipatyaari Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Aririka nokantemi: “Papiiteeya pikoñaatee”, eero pitzimaetyaashitanaka. ");
INSERT INTO cjoNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Tsikarika okoyi otampyaataki tampyaa, pikemawakiro opoematapaaki, mooo. Omaanta tee piyotzi tsikarika okinapaaki eejatzi tee piyotzi tsikarika iyaate. Eejatzi ikimiwitawo maawaeni otzimantari Ishire Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ikantapaakiri riraga Nikoreemo: —¿Oetaka poshiyakaawentanari? ");
INSERT INTO cjoNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ikantawakiri: —¿Kaarimima eerori iyotaayitziririni maawaeni ajoriiyotzinkarite? ¿Iitaka kaari piyotantawakawo iroka nokantzimiri? ");
INSERT INTO cjoNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Kyaaryooperotaki iroka nokantemiri: nokantakotziri iitarika niyotziri eejatzi noñaayitzirini omaanta tee paapatziyawo nokantayitawitzimirini. ");
INSERT INTO cjoNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Iroñaaka nokenkithatakowitzimiro iñeetziri jaka kipatsikika, omaanta tee paapatziyawo. Aririka nokenkithatakotemiro oetarika ikoyiri riraga Tajorentsi, ¿arima paapatziyakina? ");
INSERT INTO cjoNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Tekatsi atziri jatatsini jenokinta eejatzi ipiyee jaka kipatsikika ikantemi oetarika ikoyiri Tajorentsi. Omaanta naaka nopoñaaka jenokinta nokoñaatapaaki kipatsikika. Aririka nokenkithatakotero jenokinta, niyotakiro oeta nokantziri. ");
INSERT INTO cjoNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Paeraniperoroña riyaatantakari achariniiteni paerani janta tekatsinta atziri ipanko, ratsikayitawakirini oshekini maanki. Ikamayitakini osheki. Ari ikantakiri riraga Tajorentsi Moeseeshini: “Piwetsikeri oshiyaarini maanki powatzikakoteri inchapankeki. Raminayiterinirika atziripaeni ari retsiyatakotanee, eero ikami”. Aritaki imatakiri Moeseeshini. Retsiyatakotantariri osheki atziri. Ikimiwitaka ikantana riraga Tajorentsi: “Rowamagaetemi eerori rowamayemi atziri, rowatzikakotemi inchapankeki. ");
INSERT INTO cjoNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Pikamawenteri atziri powawijaakoteri maawaeni aapatziyemini”. Rootaki ikantziriri Jesoshi riraga Nikoreemo. Ithonkapaakiro ikenkithatakaakiri. ");
INSERT INTO cjoNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Inintashireperotanteeriroña riraga Tajorentsi aakapaeni maawaeni atziri kipatsikika, rootaki rotyaanantakariri Itomi rapintzite jaka kipatsikika. Ninkarika aapatziyeeyaaririni rirori, eero riyaatzi paamariki kaari tsiwakanitatsini, inta ikanteetatyeeyaani ijeeki jenokinta itsipatapaeyaari Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Tee ro rotyaanantariri Tajorentsi riraga Itomi jaka rowashironkae aakapaeni atziri, inta rotyaanantakaariri rowawijaakotee. ");
INSERT INTO cjoNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Eero ikantakowenteeyirini Pawa Tajorentsi maawaeni aapatziyariri Jesoshi. Omaanta ikantakowenanteeyakaririni rirori maawaeni kaari aapatziyaarini, rootaki rowashironkaantyaariri iinja. ");
INSERT INTO cjoNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ro rowashironkaantyaariri theenkaeyiririni riraga Jesoshi. Omaanta Irira ipokaki rirori riyotaanteeri aaka tsikarika ikantari riraga Tajorentsi eejatzi riyotaanteeri ajeeki kameetha. Noshiyakaawentemiri: okimiwitaka ikitejitakotakiri atziri jaka kipatsiki tema iñaakiro maawaeni oetarika ranteeyirini. Omaanta riraga kaari aapatziyari rantapiinteeyironi kaari kameethatatsi, tee ikoyiro riyotero iroka riyotaawitakariri; inta okimiwita inintaperotziro tsiteniriki irirapaeni. Tee ikoyi ijeeki kitejiriki, ikantzi: “Iñeeterokari riraga Tajorentsi antziri aaka, rowashironkaanteerokari”. ");
INSERT INTO cjoNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Maawaeni antzirori kaari kameethatatsi ikijakiri Jesoshi. Tee ikoyi ipokashiteri: riyotaki rooñaawontzitzirikari kaari kameethatatsi rantziri, rootaki kaari ipokashitantari raapatziyantyaariri. ");
INSERT INTO cjoNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Omaanta antzirori kyaaryooperotatsiri, rirotaki pokashitziriri riraga Jesoshi. Roñaagayitzirini kameethatatsiri rantziri. Riroma rirotaki Tajorentsi antakayiriri kameethatayitatsirini, rootaki kaari ipashiwenanta rirori ipokashitziri. Kimiwitaka ijeekaki kitejiriki imatziro iñiiri maawaeni atziri eejatzi Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Iinja riyaatakaanakina riraga Jesoshi Joreeyaki. Nojeekapaaki janta, nokaawoshitakotantapaakari Tajorentsi atziri. ");
INSERT INTO cjoNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Eejatzi riraga Jowa ikaawoshitakotawakiri Tajorentsi atziri jaga Aenookira okaakintawo Jariimi; tema oshekitapaaki iñaa jaga. Riyaatashitanakiri oshekini atziri ikaawoshitakotawakiniri riraga Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","25","Tekiraata romonkyaagaetziri riraga Jowa. Riyotaanewopaeni rashi ipiyawaantetakari paashini joriiyo. Ro ipiyapiyawaantetawakagaeyani, ikantzi tsika akanteeyanakyaanika akiteshiretanteeyaarini. ");
INSERT INTO cjoNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Roojatzi riroripaeni ipokashitantapaakariri riraga Jowa ikantapaakiri: —Iyotaanari, ikaawoshitakotawakiri Tajorentsi riraganki pitsipatariranki chapinki jantakironta Joriraaniki. Riraganki pikantakotakiri rirotaki Rotyaantanewo Tajorentsi. Rootaki riyaatashitantanakariri maawaeni atziri, tema iroñaaka rookanakae aaka. ¿Iitakakya? ");
INSERT INTO cjoNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ikantawakiri: —Tekatsi amatashiteeyani aaka apaniroeni, inta Tajorentsi jenokijatzi matakagaeroni maawaeni kameethatatsiri. ");
INSERT INTO cjoNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Pikemakina eerokapaeni nokantakimi chapinki: “Kaarina naaka riraga Rotyaantanewo Tajorentsi. Omaanta rotyaantakina riraga Tajorentsi neewatanakiri rirori”. ");
INSERT INTO cjoNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Noshiyakaawentemiro. Irira owakira aatsiri iina, aaperotzirori. Ikimoshirewentakiro iina. Rootaki riraga isheninkathoripaeni ikimoshirewenantyaariri. Iroñaaka nokimiwitari riraga kimoshirewentziriri aatsiri iina. ");
INSERT INTO cjoNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Kyaaryo chapinki osheki atziri ipokashitapiintana ikemakotziri Rotyaantanewo Tajorentsi; omaanta iroñaaka rookanakina, riyaatashitakiri ipinkathaperotziri rirori. Naaka tee: eero iroñaaka ipinkathatanaana. ");
INSERT INTO cjoNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Riragakya poñaachari jenokinta reewaperowenteeyirini maawaeni. Naaka kipatsijatzi, nomonkaateeyarini maawaeni jeekatsiripaeni kipatsikika, tee apinkathariteeyini ikimitaaga rirori. Tema apatziro akenkithawaetakotashitawo iroka añaayitzirini jaka kipatsikika. ");
INSERT INTO cjoNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Omaanta riraga poñaachari jenokinta ikamantakotziro oetarikapaeni iñaayitzirini eejatzi ikemayitzirini janta. Omaanta tekatsi osheki aapatziyaperotawakyaawoni ikantakiri. ");
INSERT INTO cjoNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Omaanta maawaeni aapatziyawakawori okaatzi ikantziri riyotzi kyaaryooperotaki maawaeni ikantziriri Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Rirotaki Tajorentsi otyaantziriri riraga Jesoshi, iroñaaka riyotaantapaakiro iyenkithari. Riraga Tajorentsi tee ithañaawo Ishire, inta ikithatzitakari Itomi Ishireki. ");
INSERT INTO cjoNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Riraga Pawa jenokijatzi inintaperotziri Itomi, eejatzi rotyaantakaeri reewaperowenteeyeeni aakapaeni maawaeni atziri. ");
INSERT INTO cjoNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Maawaeni aapatziyariri Itomi Tajorentsi ikanteetatyeeyaani rañe jenokinta. Omaanta eero riyaatzi jenokinta riraga kaari aapatziyari rirori, tema ikanteetatyeeyaani ikijantyaari Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Riraga warijeeyopaeni ikemakotakiri Jesoshi. Ikanteeyirini atziri: —Riraga Jesoshi ranaakotziri Jowa riyotaantzi. Osheki raapatziyakaakari atziripaeni, osheki ikaawoshitakotawakari Tajorentsi. Omaanta tee ikaawoshitakotari Tajorentsi riraga Jesoshi inta naakapaeni riyotaanewo kaawoshiteenchari. Riyotaki Awinkatharite ikemakotakiri riraga warijeeyopaeni oetarika rantziri. Rootaki rookakaantanaanawori Joreeya ipiyakaantanaanari Karireeyaki. ");
INSERT INTO cjoNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","5","Ikinakaanaana Jesoshi Jamaaryaki naakapaeni. Rareetakaapaentana okaakini nampitsi iitachari Shikaari. Rootaki iipatsiteni Jakoowoni paeraniperoroña: iroka ipakiriri itomini Joseeni. ");
INSERT INTO cjoNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Eenitatsi jaga iiyakotanewo iñaa Jakoowoni. Makotapaaki riraga Jesoshi, rooma nopoñaaka maawaeni inteena. Ijeekimotashitapaakawo okaakini roori imakoryaantapaaka. Tema tsiteniityaapaaki oorya. ");
INSERT INTO cjoNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Notsipatakari naaka paashinipaeni riyotaanewo niyaatapaentzi jaga nampitsiki namanantapaentzi nowanawo. Roojatzi opokantapaaka tsinani jamaaryajato okitaatzi iñaa. Ikantawakiro rirori: —Pipakotena nomiri. ");
INSERT INTO cjoNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Okantziri: —¿Kaarimima joriiyo? ¿Iitaka pikowakotantanari iñaa? Naaka jamaaryajato. Tema tee raakameethateeyirini joriiyopaeni jamaaryajatzi. Rootaki okanantakariri: “¿Iitaka pikowakotantanari iñaa?” ");
INSERT INTO cjoNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ikantawakiro riraga Jesoshi: —Tee piyotzi oetarika ikowakaakimiri riraga Tajorentsi nomatemiri. Eejatzi tee piyotzi naari ninkarika. Nokantakimi: “Pipakotena nomiri”. Omaanta piyotakinarikami naari, pikantakinami eerori: “Eerokakya pipenaata nomiri”. Roojatzi nopashitantemirorimi iñaa owañaantatsiri. ");
INSERT INTO cjoNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Okantakiri: —Tekatsi pikitaatantyaari. Inthomaeperonta ojeeki iñaa kiteyaaperotatsiri. ¿Ninka payenirika iroka iñaa owañaantatsiri? ");
INSERT INTO cjoNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Panaakotakirika achariniiteni riraga Jakoowoni kiyashitzirori iroka iiyakotanewoni? Imiritzirini iñaaka imiriteeyironi maawaeni rirori itomipaeni eejatzi maawaeni ipira. Roojatzi iroñaaka nomiriteeyirini naaka. Okameethataki iñaa: ¿pikenkithashiryaaka pipena iñaa anaakotzirorini iroka okameethatzi? ");
INSERT INTO cjoNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ikantawakiro: —Ninkarika miriteeyirorini iroka iñaa ari rapiitero maawaeni ikemaero imiri. ");
INSERT INTO cjoNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Omaanta ninkarika miritakironi iñaa nopiriri naaka, eero rapiitziro imiritee. Rowaga iñaa noperiri okimita iyowaatapaakitzi ishireki, rootaki owañaakiriri. Ikantyaani ijeekimotapaakina. ");
INSERT INTO cjoNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Okemakiri. Tee iyotzi ikantakotziro roori Ishire Tajorentsi. Okenkithashireeya ikantakotziro iñaa. Okantakiri: —Pipenawokya iroñaaka iroka iñaa pikantakinari, eerokya nomiritantanaa. Eero natsipetaatawo nopokaate jaka nokitaatanee iñaa. ");
INSERT INTO cjoNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ikantanakiro rirori: —Pityaawo piyaate pikaemakitenari piimi. ");
INSERT INTO cjoNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Okantawakiri: —Tekatsi noemi. Ikantanakiro: —Kyaaryootaki pikantakinari: “Tekatsi noemi”. ");
INSERT INTO cjoNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ikaataki piimi paawitakari apawakooni. Irira pitsipatashitari iroñaaka kaari piimi. Kyaaryo pikantakina. ");
INSERT INTO cjoNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Okantawakiri: —Kyaaryo eerokakya kamanantayitzirorini iñaani Tajorentsi: apaani iroñaaka nojampitemi. ");
INSERT INTO cjoNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Jaka tonkaariki ipinkathapiinteeyirini riraga Tajorentsi maawaeni nochariniitenipaeni. Eerokapaeni joriiyopaeni pikantzi kameetha apinkathateri Jerojareeki. ¿Oetaka kameethatatsiri? ");
INSERT INTO cjoNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ikantawakiro: —Pikemijantero iroka nokantemiri iroñaaka. Paata eero pikenkithashiriiro tsikarika pipinkathateri riraga Tajorentsi. Atsipetashita akenkithashiryaashitawo tsikarika apinkathateri inta okameethaperotzi akenkithashireeri ninka apinkathateri. ");
INSERT INTO cjoNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Eerokapaeni jamaaryajatzi tee piyotziri irira pipinkathawitari. Naakapaeni joriiyo, niyotziri naaka ninka naapatziyeeyarini. Riraga owawijaakotantatsini rirotaki joriiyotatsini paata. ");
INSERT INTO cjoNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Monkaatapaaka pipinkathaperoteri riraga Pawa: pikoyirika, ari amitakoeyemini maawaeni Ishire Tajorentsi, iyoteemiro kyaaryooperotatsiri. Rootaki ikoyiri Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Tekatsi iwatha riraga Pawa Tajorentsi. Riraga kowatsiri raapatziyaari irira, okameethatzi ikemijantaperotero Ishire okaatzi iyotayeeriri kyaaryootatsiri. ");
INSERT INTO cjoNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Okantanakiri: —Niyotaki ipokae Rotyaantanewo Tajorentsi, riraga iiteetziri Kirishito. Rareetapaakaerika riyotakaapaakae oetarikapaeni. ");
INSERT INTO cjoNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ikantawakiro: —Naaka riraga Rotyaantanewo Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Rootaki ikantakirori riraga Jesoshi rowaga tsinani. Roojatzi naaka, nokaatakiri paashinipaeni riyotaanewo nareetapaa. Noñaapaakiri. Omaanta tee nojampitapaeri: “¿Iitaka pikantzirori tsinani? ¿Iitaka pikenkithatakaantawori?” Naminashitapaakari. ");
INSERT INTO cjoNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Naminashitapaakari, ookanakiro oowitzite opiyanaka onampiki. Okantapaakiri onampiweri: —Thame poyaatanakina maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Noñaayemiri shirampari kantakinari maawaeni oetarika nantayitzirini. Riromachee Rotyaantanewo Tajorentsi. Ikemijanantawori okaatzi okantakiri, ");
INSERT INTO cjoNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","roojatzi royaatantanakawo maawaeni raminakiteri riraga Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Rootaki tekira opiya roori iiyakotanewoki, nokantawitanakari Jesoshi: —Iyotaanari, poya. ");
INSERT INTO cjoNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ikantawakina: —Eenitatsi nowari nashi naari kaari piyotzi eeroka. ");
INSERT INTO cjoNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Roojatzi nokantawakaantanaka: —¿Ramaetakinirima rowanawo? ");
INSERT INTO cjoNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ikantanakina: —Nantziniri otyaantakinari ikowakaakinari okimitzimotakina nowaka, oshintsitakaakina eejatzi iweshiryaakaakina. ");
INSERT INTO cjoNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Rooma pikantawakaawita eerokapaeni tekira omonkaata 4 kashiri ari agaeyantyaaworini opiyotapiintaga, pankirentsi. Piitashiwitaka aririka pareetakya janta Karireeyaki roojatzi piyoteeri atziri oetarika ikantziriri Tajorentsi. Omaanta nokantemi: pamineri oshekini atziri pokatsini jaka. ¿Piñaakiri? Kithaatawori kitamaari. Ikoyiri maawaeni riyoteri Tajorentsi. Piyotaantyaariri oetarika ikoyiri rirori raapatziyantyaariri. ");
INSERT INTO cjoNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Aririka piyotaakiri atziri roojatzikya raapatziyari riraga Tajorentsi, ari nokimoshiryaakayemi. Okimiwita aririka powiiteniri piwaatorote ipinatemi. Piyotaashitari eejatzi ikemijantana roojatzi eero ikami inta ikanteetapaatyeeyaani ijeeki jenokinta Tajorentsiki. Rootaki iinja maawaeni rityaawo yotaakotziriri Tajorentsi eejatzi maawaeni impaetatsiri riyotaakotanakiri rirori apiyowentyaari riraga Tajorentsi akimoshireeyantyaarini, maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Kyaaryootaki iroka ikantapiinteetziri: “Irira pankitakirori eero rowiitziro inta paashini owiiteroni”. ");
INSERT INTO cjoNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Notyaanteeyemini piyotagaeyeririni atziri oetarika ranteri reentsitetanteeyakaririni riraga Tajorentsi. Naari eejatzi paashinipaeni atziri niyotaakiri eechonkiini, iroñaaka thame pithonkaeri piyoteeri eeroka. ");
INSERT INTO cjoNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Aririka okantakotapaakiri riraga Jesoshi rowaga tsinani, raapatziyanakari oshekini onampiweri. Tema okantziri: “Noñaayemiri shirampari kantakinari maawaeni oetarika nantayitzirini”. Rootaki royaatantawori jaga. Rareetanteeyakaririni maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ipokashitantakari ikantapaakiri: —Pijeekimotanakinaata. Ari ijeekakaanakina apite kitejiri janta, ");
INSERT INTO cjoNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","nokenkithatakaanakiri irirapaeni Jesoshi eejatzi naaka maawaeni riyotaanewo. Raapatziyaperotanakari osheki riraga shikaarijatzi. ");
INSERT INTO cjoNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ikanteeyakironi riraga shikaarijatzi rowaga tsinani: —Naapatziyakawo eechonkiini pikantakinari omaanta iroñaakakya nokemaperotakiri irira Jesoshi, rootaki niyoteeyantakarini kyaaryokya oetarika pikantakinari. Rirotaki Owawijaakotantatsiri maawaeni jeekatsiri kipatsiki riraga aapatziyariri. Rirotaki irinta Rotyaantanewo Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ari apite imaaki Jesoshi janta. Okitejitanaki tee ikoyi ikijanakiri riraga jewatatsiripaeni joriiyopaeni rootaki riyaatantanakari. Ipiyanee iipatsiteki Karireeyaki. Noyaatanakiri naakapaeni riyotaanewo. ");
INSERT INTO cjoNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Riyaatantari omaanta riyotzi tee raapatziyaperotari osheki atziri janta. Rirotaki Jesoshi kantapiintatsiri: “Tee raapatziyari atziri kamanantzirorini iñaani Tajorentsi iipatsiteki inta itheenkapiintziri inampijatzi”. ");
INSERT INTO cjoNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Omaanta aririka nareetapaeya maawaeni naakapaeni Karireeyaki, raakameethatawakiri riraga Jesoshi maawaeni karireeyajatzi. Riyaatakitzi oshekini irirapaeni chapinki janta Jerojareeki, ikimoshireeyini maawaeni. Aritaki janta iñaayitakironi rantziri Jesoshi. Rootaki iroñaaka raakameethatantakariri maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Rapiitakiro riyaatanee riraga Jesoshi Kanaaki: rowaga karireeyawero. Janta chapinki ipeyakiro iñaa awishoowaantsi oowa. Eeniro ijeeki Kaperinawooki jewatatsiri, imantsiyataki itomi. ");
INSERT INTO cjoNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ikemakotawakiri riraga Jesoshi poñaachari Joreeyaki, areetapaa Karireeyaki. Ari riyaatashitanakiri, ikantapaakiri: —Rooteentsi ikame notyomi. Thame petsiyatakotakitenari. ");
INSERT INTO cjoNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ikantakiri riraga Jesoshi atziripaeni: —Eerorika notajonkantayitzini, ¿arima paapatziyeeyakinani? Aritaki pikanteeyarini eeroka, pitheenkaeyanani. ");
INSERT INTO cjoNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Rapiitziri ikantapaakiri: —¡Nowinkatharite! ¡Intsipaete, pipoke nopankoki! ¡Ikamikari notyomi! ");
INSERT INTO cjoNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ikantawakiri: —Pipiyee iroñaaka. Eero ikami pitomi, aritaki retsiyatakotee. Ikemijantaperotanakiri piyanaa. ");
INSERT INTO cjoNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Niyanki awotsi itonkiyotawakari ronampiripaeni, ikantapaakiri: —Etsiyatakotee pitomi. ");
INSERT INTO cjoNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Roojatzi rojampitantapaakari, ikantapaakiri: —¿Tsika ikaatakika oorya retsiyatakotantakari? Ikantakiri: —Chapinki, itziroryaanaki oorya, aritaki awijanaki ijaawamerikitzi. ");
INSERT INTO cjoNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ikenkithashiryaanakiro aritaki ikaataki oorya ikanantakariri Jesoshi: “Eero ikami pitomi”. Rootaki rameenantanakariri Jesoshi. Eejatzi ikimiiyakani riraga isheninka maawaeni, rameentakari rirori. ");
INSERT INTO cjoNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Iroñaaka apite itajonkantaki riraga Jesoshi janta Karireeyaki ipoñaanakanta Joreeyaki. ");
INSERT INTO cjoNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Iroñaaka monkaatapaaka paashini kitejiri nokimoshiryaantanaari maawaeni joriiyopaeni. Tema ipiyotakiri oshekyaantzi atziri janta Jerojareeki, ipinkathatantyaariri Tajorentsi. Eejatzi itonkaanaki riraga Jesoshi janta tonka, tonka. ");
INSERT INTO cjoNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Eenitatsi oshiirikota riwetsikaetziro mapi inkinagaakitakiro maawaeni pankotsi janta rowakinta Jerojareekinta. Eejatzi eenitatsi ashitakontsipaeni. Apaani owaero ipaanteki ewereeyo, rashitako owisha. Ari inthomaenta oshiirikota okaakini rashitako owisha eenitatsi inkaare iitachari Wetheshita. Eejatzi eenitatsi janta kaapa apawakooni. ");
INSERT INTO cjoNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Rootaki janta romaryaanteeyarini mantsiyari osheki. Ipiyoteeyanira mantsiyaperotatsiripaeni: riraga kaari kokichaatatsi, kijopookitatsiri, matharitonki, maawaeni. Royeeyironi iñaa omaemañaatya. ");
INSERT INTO cjoNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Aririka omaemañaatya iñaa nokantapiintzi naakapaeni joriiyo: “Ipokapaaki inkaareki ronampiri Tajorentsi, imaemañaatakaakawo iñaa, chomok, chomok. Roojatzi ninkarika ityaawoni itsitsiyaatantyaawo ari retsiyatakotee”. Ari oshekini mantsiyatzinkari janta royeeyeroni omaemañaatya iñaa. ");
INSERT INTO cjoNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Eenitatsi jaga shirampari okaatzi 38 rowawijaakiri rojarentsite imantsiyataki. ");
INSERT INTO cjoNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ari ikatziyatziyawaetashita riraga Jesoshi janta iñaapaakiri irira mantsiyatzinkari romaryaaka. Riyotakotapaakiri aritaki okaataki rojarentsite osheki imaryaaka jaka. Ikantziri: —¿Pikoyi petsiyatakotee? ");
INSERT INTO cjoNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ikantawakiri: —Jee. Omaanta tekatsi tsitsiyakayenani aririka omaemañaatya iñaa. Naaka tee nomatziro notsitsiye apaniroeni: tema rootaki ranaakotantanari paashini, itakawori itsitsiyaki rirori. ");
INSERT INTO cjoNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ikantapaakiri: —Pipiriintee, paaneero pishitashi, piyaate pipankoki. ");
INSERT INTO cjoNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Roojatzi etsiyatakotanaki. Ipiriintanaa raaneero ishitashi ipankoki. Rootaki kitejitatsiri nomakoryaantapiintari naakapaeni maawaeni joriiyo. ");
INSERT INTO cjoNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Rootaki ikanteeyantakaririni riraga jewatatsiripaeni joriiyopaeni okaatzi iñaakiri rirori: —Rootaki iroñaaka kitejitatsiri amakoryaantapiintari. Tee oshineta aaneero iroñaaka ashitashi. ¿Iitaka paantanakawori pashi? ");
INSERT INTO cjoNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ikantawakiri: —Riraga etsiyatakotakaanari rirotaki kantanari: “Paaneero pishitashi, piyaatee pipankoki”. ");
INSERT INTO cjoNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Roojatzi ikanantanakari: —¿Ninka kantakimirika iroka? ");
INSERT INTO cjoNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Tee riyotzi rirori ninkarika etsiyatakotziriri. Eenitatsi jaga osheki atziri, ipeyimotanakari riraga Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Iinja irira Jesoshi raminaminatakiri riraga etsiyatakotziriri, eejatzi iñaakiri janta Tajorentsipankoki. Ikantziri: —Ñaakiro. Eeroka etsiyatakoteemi. Eero pantapiintziro eejatzi kaari kameethatatsi. Apiitaneemikari pimantsiyate, pikamaekari. —Jee. Aritaki. ");
INSERT INTO cjoNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Roojatzi riyaatantanaka shirampari. Ikantapaakiri riraga jewatatsiripaeni joriiyopaeni: —Rirotaki etsiyatakotakaakinari Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Rootaki ikijantanakariri irirapaeni jewatatsiripaeni joriiyo riraga Jesoshi. Ikowantakari rowamagaeterimi rirori tema retsiyatakotantakari kitejitatsiriki nomakoryaantapiintari maawaeni naaka joriiyopaeni. Ari ikantziri piyotawentariri: —¿Iitaka pikanantari kitejitatsiriki amakoryaantapiintari? ");
INSERT INTO cjoNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Rootaki ikantawakiriri: —Roojatzi ikantani Pawa rantziro kameethatatsiri. Eejatzi nokimitari naaka. ¿Iitaka nopakaantyaaworikya nantziro kameethatatsiri kitejitatsiri amakoryaantapiintari? ");
INSERT INTO cjoNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Eekiro riyaatatzi ikowaperotziroña rowamaeriroña riraga Jesoshi. Tee apatziro iñaakiri ranantashitawo kitejitatsiriki nomakoryaantapiintari; inta eejatzi ikemakiri riraga Jesoshi ikantzi: “Pawa nashi rirotaki Tajorentsi”. Roojatzi ikanantanaka riroripaeni jewatatsiri joriiyopaeni: —Iitajorentsitashitaka, tee ikameethatzi. ");
INSERT INTO cjoNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ikantawakiri riraga Jesoshi: —Kyaaryootaki iroka nokantemiri. Tee nantashitawo naaka apaniroeni inta nomonkaatakiro oetarika noñaakotziriri rantziri Pawa. ");
INSERT INTO cjoNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Irira inintaperotana naaka Itomi riyotaakinawo maawaeni nantziri. Iinja imatakayena nanaakotero nantakiniririka shiramparika, tema notajonkaperotantyaariri oetarikapaeni, rootaki potsikanaperotantanakinari osheki. ");
INSERT INTO cjoNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Rooma ipiriinteeri Pawa kaminkari rowañaakiri. Eejatzi nokimityaari naaka, nowañaanakiri ninkarika nokowakaari. ");
INSERT INTO cjoNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Eero ikantakowentziri Pawa atziri ikameethatzirika, eero: inta rootaki rotyaanantakinari naaka nokantakowenantyaariri. ");
INSERT INTO cjoNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ikowakiri Pawa maawaeni atziri iñaakoweenkateri rirori. Eejatzi ikowakaakina iñaaperotena naari maawaeni atziri nokameethaperotzi. Riraga kaari ñaaperotanaa naaka nokameethatzika, tee iñaaperotziri Pawa rirori ikameethatzi. Tema rirotaki Pawa otyaantakinari. ");
INSERT INTO cjoNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Kyaaryootaki iroka nokantemiri. Maawaeni kemirori nokantziri, aririka raapatziyakyaari otyaantanari, aritaki ikantyaani ijeekantakyaari janta jenokinta notsipatyaari naaka. Eero ikantakowentziri Pawa. Ikamawitakya, omaanta ari rapiiteeya rañaagae. ");
INSERT INTO cjoNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Kyaaryootaki iroka nokantemiri. Iroñaaka riraga kaari aapatziyari ikemaeyawaeroni noñaani: tema naaka Itomi Tajorentsi. Ikanteetatyeeyaani rañagaeyeni maawaeni aapatziyawori noñaani. Aritakikya iroñaaka omonkaatakya raapatziyeeyantenarini. ");
INSERT INTO cjoNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Irira Pawa ashi royiro rañi eejatzi rowañaakiri atziri. Naaka nomonkaatakari. Ikowakaakinari naaka ashi noyiro nañi eejatzi nowañaakiri atziri. ");
INSERT INTO cjoNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Tema nopoñaaka jenokinta natziritapaaki jaka kipatsikika. Ro rotyaanantanari nokantakowenteri maawaeni atziri ikameethatzirika. ");
INSERT INTO cjoNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Eero potsikanatana. Iinja ikemaeyenani maawaeni riraga kaminkari okaatzi nokantziri. ");
INSERT INTO cjoNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Aritaki ipiriintanakiri antzirori kameethatatsiri, rañeeyanakini ijeeki jenokinta ijeekira Tajorentsi. Eejatzi riraga eekiro riyaatatyee antzirori kaari kameethatatsi ipiriintawitanakyaapa omaanta ikantakowenantyaariripa riraga Tajorentsi maawaeni: rotyaanteri paamariki kaari tsiwakanitatsini. ");
INSERT INTO cjoNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Tekatsi nokantya nantashityaawo. Nokantakowenantyaaririka atziri ikameethatakirika nomonkaatakiro ikantanari Pawa. Kyaaryoopero nokantakowenantariri. Tee nantashitawo oetarika nokoyiri naari inta nanteniri Pawa otyaantakinari ikowakaakinari irira. ");
INSERT INTO cjoNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Eejatzi ikantziri Jesoshi: —Aririka naaka kantakotachanimi apaniroeni, pikantemi: “Tee kyaaryoopero ikantzi”. ");
INSERT INTO cjoNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Omaanta eenitatsi paashini kantakotanari, riraga Pawa. Niyotzi kyaaryootaki ikantakotanari irira. ");
INSERT INTO cjoNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Omaanta eerokapaeni, potyaantayitakirini riraga Jowa, pojampitakaantakiri. Eejatzi irira ari ikantakoperotakiro kyaaryooperotatsiri, ikantakimi: “Rirotaki Jesoshi Owawijaakotantatsiri, rirotaki Itomi Tajorentsi”. ");
INSERT INTO cjoNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Tekatsi okantya ikamantakotena atziri: “Ikameethatzi Jesoshi”, omaanta nokowaki eeroka pawijakote, rootaki nokanantzimirori iroka. ");
INSERT INTO cjoNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Riraga Jowa roshiyawitari ootamentotsi amorekaperotatsiri. Piñaawakiri okoñeetyaapaaki rashi: rooma osheki riyotakaakimi. Pikimoshirewentawitawakari eechonkiini. ");
INSERT INTO cjoNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Eenitatsi eejatzi paashini riyotakaakimiri, rowaga anaakotziriri Jowa, piyoperotantenari. Iroñaaka nothotyaaneeniri Pawa otyaantakinari maawaeni okaatzi ikantakinari. Oetarika nantayitzirini naari, iyotakaakimiri rotyaantakina Pawa. ");
INSERT INTO cjoNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Eejatzi ikamantakotakina naaka Pawa riraga otyaantakinari. Omaanta tee pikemijantaneentziri oetarika ikantziri, eejatzi tee piñaaneentziri tsika ikantari. ");
INSERT INTO cjoNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Eejatzi tee paapatziyana naaka Rotyaantanewo, rootaki kaari paapatziyantawo ikantziri rirori. ");
INSERT INTO cjoNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Piñaanapiintawitakawo Iwaperite Tajorentsi, rootaki pikenkithashiryaantari pawijakotantari, pikantatyeeyaani pañaanaki. Omaanta rootaki roori kantakotanari naaka. ");
INSERT INTO cjoNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Omaanta tee pikoyi pameentena naaka nowañaantemiri. ");
INSERT INTO cjoNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Omawitakya pikantashita piñaaperotana, tee pameentana. ");
INSERT INTO cjoNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Niyotzimi naaka, tee pinintaperotziri Tajorentsi pajankanekira. ");
INSERT INTO cjoNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Rotyaantana Pawa, rootaki nopokantakari. Omaanta tee piñaaperotana eerokapaeni. Aririka ipokashitemi paashini atziri kaari rotyaantanewo Pawa, iñaaperota apaniroeni, rirotakikya piñaaperotawakirikya. ");
INSERT INTO cjoNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Eejatzi eeroka ñaaperotawakaachari. Aritaki pikantari. Omaanta tee pikoyi iñaaperotemi rapintzite Tajorentsi pikameethatantyaari. ¿Tsika pikantyaaka paapatziyaperotantyaariri eeroka? Eero pimatziro. ");
INSERT INTO cjoNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Eero pikenkithashiryaashita naaka thawetakotemini Pawaki: “Eeniro, Pawa, irikapaeni rantziro kaari kameethatatsi”. Eenitatsi paashini thawetakotemini: rirotaki riraga Moeseeshini, ikanteri irira Pawa: “Tee raapatziyawo irokapaeni rowaga pojankinatakaakinari”. ¿Piitakaa ari rowawijaakoteemi? Eerowa. ");
INSERT INTO cjoNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Arimi paapatziyaperotyaarimi riraga Moeseeshini, ari paapatziyaperotakinami naari. Tema rojankinatakotzitakina rirori paerani. ");
INSERT INTO cjoNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Niyotakimi tee paapatziyawo rojankinarini Moeseeshi. ¿Arima paapatziyakyaawo nokantzimiri naari? Eerowa. Rootaki ikantziriri Jesoshi riraga jewatatsiripaeni joriiyopaeni. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Paashini kitejiri riraga Jesoshi imontyaakaanakinawo inkaare naakapaeni maawaeni riyotaanewo. Noetziro inkaare Karireeya naakapaeni joriiyo. Omaanta iitziro Teweeryashi riraga paashinijatzitatsiri atziri. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Imontyaakaanakinawo inkaare, royaatakiri oshekyaantzi atziri. Iñaakotantakariri maawaeni itajonkantzi. Itajonkawentakiri mantsiyatzinkari. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Itonkaakaanakina tonkaariki. Ijeekakaapaakina janta. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Rooteentsi omonkaatya Kitejitatsiri rawijantari ronampiri Tajorentsi. Rootaki nokimoshiryaantanakyaari naakapaeni joriiyo. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ijeekakaapaakina riraga Jesoshi, raminanaki. Iñaawakiri oshekini atziri pokashitakiriri. Ikantziri Jiripi: —¿Tsika amananteeka rowayityaarini atziripaeni? ");
INSERT INTO cjoNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ro ikantashitantariri, ikowaki iñaantyaari riraga Jiripi. Omaanta riyotaki oetarika ranteri. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ari ikantawakiri: —Taanitya. Aririka amanantawityaawo oshekini, aririka ikaate 200 tenaaryo, tekira omonkaata owanawontsi royaari atziripaeni. Itasheni. Aaka tekatsi osheki koriki. Eero amatziro amanantziro osheki owanawontsi. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ari eenitatsi janta paashini riyotaanewo, riraga Antereeshi. Rirotaki rirentzi Peetero. Ikantziri rirori: ");
INSERT INTO cjoNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Iyotaanari, eenitatsi jaka apaani ewankari ipaani apawakooni. Eenitatsi eejatzi mereto apite. Omaanta notheenkakiri: eero riyomaatari, eenitatsi oshekini atziri. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Eenitatsi jaga oshekini katawomashi, roojatzi ikanantawakari riraga Jesoshi: —Aritaki poejeekaeyerini maawaeni atziri katawomashikira. Ikaataki 5.000 shirampari jeekaeyeentsirini. Eejatzi tsinanipaeni eejatzi eentsipaeni ijeekaeyini: maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Roojatzi raantakawo rirori paa eejatzi raantakari mereto. Roojatzi raminanaki jenokinta ikantziri Ashitariri: —Ariwee, Pawa, eenitatsi nowanawo. Ari ikagaakiro paa eejatzi ikagaakiri mereto, ipakiri riyotaanewopaeni, eekiro rowawijeeniri maawaeni atziri ijeekira. Rowaeyani atziripaeni maawaeni ikoyiri. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ikemaeyantapaakarini maawaeni ikantana riraga Jesoshi naakapaeni riyotaanewo: —Pagaatero maawaeni tzimagaantapaentsiri, tee nokoyi eewanatyaawo. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ikemaeyakawoni iroka paa apawakooni. Nagaatziro tzimagaantapaentsiri. Notetakiro kantzirikipaeni: niyeekitakiro okaatzi 12. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Iñeeyakirini itajonkakiro paa, roojatzi ikanteeyantanakarini: —Riroperotaki irika kamanantzirorini iñaani Tajorentsi akemakotziri, aamagaeyarini paerani. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Riyotawakiri Jesoshi ipokashiiyerinimi owaeyeencharini raanakirimi iiterimi jewawenantatsini. Roojatzi ipeyapithatantanakari. Riyaatanaki riraga Jesoshi tonkaariki apaniroeni. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","17","Itziroriimatanaki oorya noerinkaeyanakani naaka maawaeni riyotaanewo inkaareki, noyeri riraga Jesoshi janta. Tsitenitapaaki, omaanta tekira ipoki. Roojatzi notetantanaka pitotsiki nomontyaantyaawori intatsikeronta janta Kaperinawooki. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Opokapaaki antawo tampyaa mooo, mooo, omaemañaata inkaare, rootaki amantapaakawori antawo otamakaari. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Aritaki nokomakomatakiro niyanki. Inteena kipatsi, aamaashitya ari okaatzi 5 kiroometero aririkapa 6 nareetantakyaari. Eekiro nokomaeyawitakani. Roojatzi noñaantawakari riraga Jesoshi ranashaatawo inkaare; rokaakintapaakina. Tee itsitsiyi: kimiwitapaaka rootaki ranashitantapaakari kipatsi. Nothaawaperotanaki maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Omaanta ikantapaakina irira: —Naakataki, eero pithaawantana. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Roojatzi nokimoshiretantanaa naawakiri notetawakiri pitotsiki. Intsipaete naatakoeyapaakani othapyaakiini janta niyaatenta. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Okitejitanaki riraga atziripaeni eeniro ijeekanaki intatsikeronta inkaare raminaminawitanakari Jesoshi. Ikantawakaaka: —¿Tsika ijeekika riraga Jesoshi? Chapinki rotetaa pitotsiki riyotaanewopaeni riyaatanaki. Tee rotetaka riraga Jesoshi. Kaari paashini pitotsi. ¿Tsikarika ijeekaki rirori? ");
INSERT INTO cjoNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Iroñaaka rareetawitapaaka oshekini teweeryashijatzi, ikinakotapaaki ipitoki. Raatakoeyapaakani okaakini nowawaeteeyakaninta paa chapinki. Ikowawitapaakari ikantzi: —¿Tsikama Jesoshi? ¿Tsikama riyotaanewo? ");
INSERT INTO cjoNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Tee iñeeyapaerini; eejatzi naakapaeni, tee iñeeyapaanani. Roojatzi rotetantanaa atziri ipitokipaeni riyaatakotanaki Kaperinawooki, ikowanteeyapaakaririni riraga Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Aritaki iñeeyapaakirini. Ikantapaakiri: —Iyotaanari, naminamineeyakimini. ¿Tsika pikantaka pareetantapaari jaka? ");
INSERT INTO cjoNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ikantawakiri: —¿Iitarikya pikowantanari? Kyaaryootaki iroka nokantemiri: tee ro pikowantana pipinkathatena, inta pikowantana nowakayemi kimitaka nantakiri chapinki. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Iroka oyaarika ari othonkanakya. Eero patsipewentashitawo, inta naaka patsipewentaperotya; naaka materoni nowañaaperotemi rootaki pañaaperotantapaakyaarini janta jenokinta pikantyaani. Nopoñaaka jenokinta, rotyaantakina Pawa jaka kipatsikika, natziritapaaki rootaki nowañeeyantakimirini. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Rojampitakiri: —¿Tsikama nokantyaaka nanantyaawori ikowakaakinari Tajorentsi? ");
INSERT INTO cjoNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ikantawakiri: —Paapatziyeeyenani naaka Rotyaantanewo: rootaki ikowakaemiri Pawa. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Roojatzi rojampiteeyantanaarini, ikantaneeri: —¿Oetaka poñaayenari naapatziyantemiri? Aririka noñaakimi pitajonkante, aritaki niyotaki kyaaryoopero pikantakinari. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Paeraniperoroña riraga achariniitenipaeni rowaeyakawoni manaa janta tekatsinta atziri ipanko. Okantzi Iwaperite Tajorentsi: “Ipaetakiri rowanawo rowaeyantaworini. Opoñaaka jenokinta”. Tema riro Moeseeshini paeyakiririni, rootaki riyoteeyantakyaarini achariniitenipaeni paerani okameethatzi royaateri maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ikantawakiri riraga Jesoshi: —Kyaaryootaki nokantemiri. Tee riro Moeseeshini piriri rowaeyarini poñeenchari jenokinta, inta riraga Pawa pawitakariri. Iroñaaka ikowawita ipemi paashini powaeyaari kameethaperotatsiri, poñaachari jenokinta. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Rowaga paa poñaachari Tajorentsi jenokinta rootaki owañiiriri maawaeni atziri. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Rootaki ikantakiri Jesoshi. Rirotaki kantakotacha apaniroeni. Omaanta tee ikemaperotziri atziri. Ikantziri: —Aritaki pikanta, Nowinkatharite, pikantyaani pipapiintenawo rowaga noyaari pikantakotakinari. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ikantawakiri rirori: —Naaka Rotyaantanewo Tajorentsi. Naaka oshiyawori paa owañaantatsiri. Naaka owañaakiriri atziri. Aririka poyaatanakina eero ayimi pitashe eejatzi paapatziyanarika eero pimiritanee. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Aritaki nokanteeyawitakimini. Piñeeyawitakinani notajonkantzi omaanta tekira paapatziyana. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ikantanari riraga Pawa: “Pikempoyeeyinarini maawaeni ameentakinari”. Riyoteeyakirini ipokashiteeyanakinani raapatziyanteeyanakinarini. Riraga pokashitapaenani, eero noepiyawakiri. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Tee ro nayiitantapaari nanantyaawori nokowashitari naari, inta nantero ikowakaakinari otyaantakinari. Rootaki nayiitantapaakari. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Irintapaeni nokempoyaakiniri irira Pawa, eero nopeyakotzi apaani. Nopiriinteeyirini irirapaeni iwatha omonkaatantapaeya kitejiri othonkantapaeyaari kipatsi. Rootaki ikowakaanari riraga Pawa otyaantakinari. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Maawaeni atziri ñeenani aririka raapatziyena, ari ikanteetatyeeyaani ijeekimotakiri Tajorentsi jenokinta. Nopiriinteeyerini iinja, othonkantapaeyaari kipatsi. Rootaki ikowakaakinari Pawa otyaantakinari. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Roojatzi ikiñaanikowenantanakari riraga jewatatsiripaeni joriiyopaeni. Tema ikemakiri ikantaki: “Naaka oshiyawori owanawontsi, poñaachari jenokinta”, rootaki ikiñaanikowenantanakariri. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ikanteeyini: —Ayotziri rirori. Tema rirotaki Jesoshi, itomi Josee. Ayotziri iriri, rirotaki Joseeni. Eejatzi ayotziro riniro. ¿Iitaka ikanantari: “Nopoñaaka jenokinta”? Ikantashitaka. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Riyotzi riraga Jesoshi oetarika ikantawakaakari. Ikantziri: —Eero pikiñaanikowentana. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Eeromi ikoyimi Pawa otyaantakinari, tekatsi pokashitenanimi raapatziyantenarimi. Omaanta riraga aapatziyanari rirotaki nopiriintaneeri iinja omonkaatapaakyaarika kitejiri nokantakowenantyaariri maawaeni atziri. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Rojankinatakotzitakari paeraniperoroña kamanantayitzirorini iñaani Tajorentsi: “Tajorentsi riyotagaeyakirini maawaeni”. Maawaeni aapatziyakawori ikantziri rirori, riyotawakirorika, aritaki rameentakina nowawijaakotantyaariri. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Nopoñaaka jenokinta, rootaki noñaantariri Pawa. Tekatsi paashini ñeerini. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Kyaaryootaki iroka nokantemiri, riraga aapatziyanari ikantyaani ijeeki iroñaaka eejatzi iinja jenokinta janta Tajorentsiki. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Iroka ikanteeyirini eejatzi: —Naaka oshiyawori owanawontsi owañaakiriri atziri. Kyaaryo naaka owañeerini rirori. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Rañaawitanaka pichariniitenipaeni paeraniperoroña rowaeyawitakawoni manaa janta tekatsinta atziri ipanko. Omaanta ari ikamaki janta. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Omaanta naaka tee nokimitawo iroka. Tee nomatziri noshinetziri aapatziyakinari riyaate paamariki kaari tsiwakanitatsini. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Naaka oshiyawori owanawontsi owañaakiriri atziri, nopoñaaka jenokinta. Ninkarika oyaawoni iroka owanawontsi ikanteetatyeeyaani rañagaeyeeni jenokinta. Noperi maawaeni jeekatsiri kipatsikika rañeeyantyaarini: tema rootaki nowatha. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Roojatzi ikantawakaeyantanakarini riraga jewatatsiripaeni joriiyopaeni. Ikanteeyini: —Tee nokemaperotziri. ¿Tsika ikantyaaka ipanteerori Jesoshi iwatha aari owantyaawori? ");
INSERT INTO cjoNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ikantawakiri rirori: —Kyaaryootaki iroka nokantemiri, rooma nopoñaaka jenokinta, natziritapaaki jaka. Eerorika powawo nowatha, eejatzi eerorika piriro niraa eero pañi. Jee, noshiyakaawentemi nowatha eejatzi niraa. Kyaaryo nokantzimi eejatzi, eerorika paapatziyawo nokamawenteri atziri iñaaperotantariri riraga Tajorentsi, eero pikantani pijeeki jenokinta. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Maawaeni oyaawoni nowatha, eejatzi ireroni niraa, ikanteetatyeeyaani rañee omaanta eerorika pikenkithashiryaakotana nokamawentakimi eejatzi eerorika pikowakaana nowawijaakotemi eero nopiriintzimi iinja omonkaatapaakyaarika kitejiri nokantakotantyaariri maawaeni atziri. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Nowatha rootaki owanawontsipero. Niraa rootaki imiritaperoetziri. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ninkarika oyaawoni nowatha eejatzi miriteroni niraa roojatzi ikantya, kijokiro rowana. Eejatzi nokimitya naaka, kijokiro noyeri. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Añaatsiri rirotaki Pawa otyaantakinari: rirotaki owañaakinari naari. Eejatzi ikimiteeyaani rirori oyaawoni nowatha, nowañeeyerini maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Rootaki iroka owanawontsi ayiitapaentsiri jenokinta. Tee okimitawo rowaga rowaeyarini achariniiteni paeraniperoroña. Irira ikamaki okaankiityeenta. Intakya nowañaakiri maawaeni aapatziyanari. Riraga oyaawoni owanawontsika nokantakimiri ikanteetatyeeyaani rañagaeyeni rirori jenokinta. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Aritaki riyotagaeyakiririni Jesoshi piyotapiintaantsiki rashi joriiyopaeni, janta Kaperinawooki. Tema osheki roshiyakaawentakaero iwatha eejatzi riraa. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Oshekini kemaeyawitawakaworini riyotagaeyawitakaririni, roojatzi ikanantanaka: —Opomeentsitzimotakae antero iroka ikantakaerika aaka, eero amatziro aapatziyawo. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Riyotashitaka riraga Jesoshi ikijimawaetakiri riraga iyotagaeyawitakaririni. Ikantanakiri: —¿Teerika okameethatzimotzimi iroka nokantakimirika? ");
INSERT INTO cjoNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Paerani nopoñaaka naari jenokinta, natziritapaaki jaka kipatsikika. Iinja piñeeyawakinani nopiyanee jenokinta. ¿Roojatzi iitaka pikenkithashireeyantarini? Ikantziro iroka ikenkithashiryaakotziri ikame, ipiriintanee, eejatzi ipiye Iririki. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ishire Tajorentsi rootaki owañagaeyeririni maawaeni jeekaeyatsirini jenokinta. Eero ijeekaeyini maawaeni atziri. Iroka nokamantakimiri oshiyawitawo Ishire Tajorentsi: aririka paapatziyaawo, ari owañaakimi jenokinta. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Niyotakoeyimini: eenitatsi pikaateeyinika kaari aapatziyana. Paerani riyotzitari riraga Jesoshi ninka kaari aapatziyaarini. Eejatzi riyotzitakari aakaanterini iinja. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Eekiro riyaatatzi ikantanakiri: —Niyotaki tee paapatziyeeyanani maawaeni, rootaki nokanantakimiri inkaaganki: “Eeromi ikowakaerimi Pawa, tekatsi materoni pokashitenanimi naaka”. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Rootaki rookantanakariri osheki riraga aapatziyaaririmi. Aripaete tee royaateeyaneerini. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Roojatzi riraga Jesoshi ikanteeyanakinani 12 riyotaanewo: —¿Arima pookaeyanakinani eeroka eejatzi? ");
INSERT INTO cjoNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Rakanakiri Peetero: —Nowinkatharite, eerorika noyaatzimi eeroka, ¿ninkakya noyaatanakirika? Ikantyaani rañeeyanakini jenokinta maawaeni aapatziyeeyakaworini pikantakirika. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Naapatziyeeyimini, niyoteeyanakimini; eeroka Rotyaantanewo Tajorentsi, pikameethaperotaki. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ikantanakiri: —Rooma eeroka niyoyagaeyakimini. Pikaatzi jaka 12, omaanta apaani pikaatzika, rirotaki oyaatziriri iwinkatharite kamaari. ");
INSERT INTO cjoNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ikenkithatakotakiri Joorashi karyootejatzi, itomi riraga Shimo. Eeniro itsipatawitana maawaeni. Omaanta rirotaki aakaanterini riraga Jesoshi iinja. ");
INSERT INTO cjoNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Roojatzi ikinakinatakaanakina riraga Jesoshi Karireeyaki. Ikowawita riraga jewatatsiripaeni joriiyopaeni rowamaerimi, rootaki kaari ikowantari rirori riyaate Joreeyaki. ");
INSERT INTO cjoNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Rooteentsi napiitero nokimoshireeyantyaarini naaka joriiyopaeni. Rooteentsi maawaeni atziri riyaate Jerojareeki riwetsikaeyeroni pankoshintsi ijeekantyaari 7 kitejiri, ikenkithashireeyantyaaworini ikineeyanakini ichariniitenipaeni paerani janta tekatsinta atziri ipanko. ");
INSERT INTO cjoNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Rirentzipaeni riraga Jesoshi ikantziri: —Piyaate iroñaaka Joreeyaki. Poñaagapaeri piyotaanewopaeni janta oetarika pantziri. Tema pitajonkawenteeri osheki atziri. ");
INSERT INTO cjoNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Pikowakirika riyoteeyemini maawaeni atziripaeni pikinakinayitanakini iñeeyantemirini. Eero pimaniro oetarika pantayiterini. Aririka pitajonkantayiteni, poñaayaari maawaeni atziri. ");
INSERT INTO cjoNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Tee raapatziyari rirentzipaeni rirori, ");
INSERT INTO cjoNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","rootaki ikanantakariri rirori: —Tekiraata omonkaatya kitejiri niyaatakaantyaariri osheki atziri janta Jerojareeki. Omaanta eerokapaeni piyaate oetarika kitejiri pikoyiri. ");
INSERT INTO cjoNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Tekatsi ikantya maawaeni atziri ikijemi eeroka, pikimiiyarini. Inta naaka roonakina osheki. Nokananteeyakaririni: “Tee okameethatzi iroka pantayitzirini”, rootaki ikijantanakinari. ");
INSERT INTO cjoNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Pitonkagaeyanakiniita eeroka Jerojareeki. Tekiraata niyaatziita, tekira omonkaatya kitejiri notonkaakaantyaariri osheki atziri. ");
INSERT INTO cjoNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Aritaki ikantawakiri. Ari ijeekanaki Karireeyaki. ");
INSERT INTO cjoNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Omaanta rirentzipaeni rirotaki jateentsiri Joreeyaki, itonkaanaki tonka, tonka. Ikimoshiretapaaki. Rimpaetanaki riraga Jesoshi itonkaakaanakina. Omaanta tee roñaagantapaeroña: tee ikoyi iñaayitawakirini oshekini atziri. ");
INSERT INTO cjoNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Janta Jerojareeki ikanta riraga jewatatsiripaeni joriiyopaeni raminaminawitakari riraga Jesoshi. Ikowantawitakari rayerimi. Ikanteeyini: —¿Tsika riraganki Jesoshi? ");
INSERT INTO cjoNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Piyoteenchari janta ikamantawakaaka rirori. Apaanipaeni ikantzi: —Rirotaki kameethari. Apaanipaeni paashini ikantzi: —Tee ikameethatzi, irira osheki ramatawitziri atziri. ");
INSERT INTO cjoNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Omaanta ithaawantakari atziripaeni riraga jewatatsiripaeni joriiyopaeni, rootaki imanakotantakawori ikantakotziriri rirori. ");
INSERT INTO cjoNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Tee roñaagantapaaroña riraga Jesoshi, imaaki 3. Okitejitanaki itonkaanaki irira Tajorentsipankoki. Riyotaantapaaki. ");
INSERT INTO cjoNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Rotsikanatakari riraga jewatatsiripaeni joriiyopaeni rirori. Ikantawakaaka: —Tee ayotaatziiri aaka. ¿Iitaka riyotantayitaworini oetarikapaeni? ");
INSERT INTO cjoNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ikantawakiri: —Tee naaka yotashitawori iroka niyotaakimirika, inta riyotakaanawo riraga otyaantakinari. ");
INSERT INTO cjoNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Pikowaperoterika panteniri ikowakaakimiri riraga Tajorentsi, aritaki piyotanakiro. Piyotanaki rotyaantanarika rirori. Piyotanaki noñaawaetashitarika. ");
INSERT INTO cjoNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ikowantari ikimoshiryaashitakaakari atziri riraga ñaawaetashitachari, ikantakotziro okaatzira ikoyiri. Aririka itheeyashita, ikowanakiri riraga atziri ikantakoteri: “Kameetharini irika ñaawaetashitachari”. Omaanta eenitatsirika kantakaanantatsiri ikowanakiri otyaantziriri ikantakoteri: “Kameetharini otyaantakiriri”. Tema riyotaantaki kyaaryooperotatsiri, tee itheeyashita. ");
INSERT INTO cjoNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Rooma rootaki ikantzimiri Moeseeshini paeraniperoroña: “Iroka pantayiterini. Rootaki ikowanakiri Tajorentsi”. Omaanta tekatsi jaka mataperoteroni iroka ikantakimiri. ¿Iitarikya pajaryaantanari naaka powamaena? ");
INSERT INTO cjoNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ikantawakiri maawaeni piyoteenchari: —Ikyaantashitakimi kamaari. ¿Ninka ajareemini rowamaemi? ");
INSERT INTO cjoNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Aritaki ikemiri riraga Jesoshi omaanta tee ikantawakiri. Inta ikantziri riraga jewatatsiripaeni joriiyopaeni: —Eerokapaeni pikoyi powamaena. Apaani notajonkantaki saawaroki, rootaki pikowantari powamaena. ");
INSERT INTO cjoNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Omaanta ikantakimiri riraga Moeseeshini Iwaperiteki Tajorentsi: “Pitotonateri pitomi aririka ikaatakotapaaki 8 kitejiri”. Omaantakya kaari Moeseeshini kantaperotatsini, intakya riraga ichariniiteni paerani. Rootaki iroñaaka pitotonatantariri pitomi pitothowapiinta eejatzi saawaroki rowaga kitejitatsiri amakoryaantari. ");
INSERT INTO cjoNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Pitotonatantapiintawo kitejitatsiri amakoryaantapiintari, pimonkaatantawori rojankinatziri Moeseeshini Iwaperiteki Tajorentsi. Rootaki kitejitatsiri amakoryaantapiintari netsiyatakotantariri riraga shirampari. Omaanta eekiro piyaatatzi pikijashitatyaana. ¿Iitarikya? ");
INSERT INTO cjoNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Aririka paminapooteri pisheninka, eero pikantashita: “Kameetharini irinta. Riraga paashini pikante tee ikameethatzi”. Pityaari piyoperoteri, roojatzikya piyotanaki oetarika pikenkithatakoteriri. Eejatzi okimitya pikenkithashiryaaperotero nokantzimiri piyoperotantenari. ");
INSERT INTO cjoNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Roojatzi ikanantawakaaka jerojareejatzi apaanipaeni: —¿Kaarima irika ikowaetziri rowamagaeteri? ");
INSERT INTO cjoNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Pamineri iroñaaka, riyotaantayitzini jaka tee imaniro. Tekatsi kanterini: “Pimaerite”. ¿Raamaatyaarima maawaeni jewatatsiri riyoperotaki irika Rotyaantanewo Tajorentsi? ");
INSERT INTO cjoNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Omaanta ayotakotakiri aaka tsikarika ipoñaaka irika Jesoshi. Irira karireeyajatzi. Ipokaperotapaerika riraga Rotyaantanewo Tajorentsi, tekatsi yotakoterini tsikarika ipoña rirori. ¿Paamaakama irinta rirotaki Rotyaantanewo Tajorentsi? ");
INSERT INTO cjoNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Eekiro riyaatatzi riyotaantzi riraga Jesoshi Tajorentsipankoki, ikantzi: —¿Pikenkithashireeya piyotenami? ¿Piyotzima tsikarika nopoñaakari? Tee piyoperotzi. Tee nopokashita, eenitatsi otyaantakinari: riroperotatsiri. Kaari piyotziri eeroka, ");
INSERT INTO cjoNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","inta naaka niyotziri naari. Riraga otyaantakinari rirotaki nopoñiimotanakari jenokinta. ");
INSERT INTO cjoNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Roojatzi ikowantaperotawitakari rayerimi. Omaanta tekatsi ayerini. Tekiraata omonkaatya raanteetyaariri. ");
INSERT INTO cjoNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Osheki piyotantyaariri raapatziyakari. Ikantayitzini: —¿Aririka ipokapaaki riraga Rotyaantanewo Tajorentsi, ranaakotapaeri riraganki itajonkantapae? Eerowee. ");
INSERT INTO cjoNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Riraga warijeeyopaeni ikemaeyawakirini atziri ikenkithatakotakiri riraga Jesoshi. Ari maawaeni ikijanakiri. Rootaki irirapaeni eejatzi jewatatsiripaeni ñaanakowenantatsiri rotyaanantakariri waariryaapaeni raantyaaririmi. ");
INSERT INTO cjoNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Rootaki ikanantanakariri riraga Jesoshi atziri: —Iroñaaka notsipatanakimi. Rooteentsi nopiyanee otyaantakinarikinta. ");
INSERT INTO cjoNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Pikowakowawitakitenarika omaanta eero piñaana. Tsikarika nojeeki eero pimatziro piyaate eerori. ");
INSERT INTO cjoNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","36","Ikantawakaaka riraga jewatatsiripaeni joriiyopaeni: —¿Iitaka ikanantari? ¿Tsikama riyaateka irika shirampari eero añiiri? ¿Tsikama riyaateka kaari amatantyaawo aate aaka? Arima riyaate riraga atziri jeekayitatsirini paashinikipaeni kipatsiki. ¿Arima riyotaapaeri atziri janta? ");
INSERT INTO cjoNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Rowaga riweyaantanakawo kitejiri niweshiryaawenteeyantyaaririni Tajorentsi rootaki kameethaperotatsiri kitejiri. Ishitowantapaakari oorya maawaeni naaka nopiyotantakari janta Tajorentsipankoki, nopinkathatantariri riraga Tajorentsi, eejatzi nokimoshireperotaki. Tema ikatziyashita riraga Jesoshi janta. Romapokashitanakawo itacheronkawaantetanaki, ikantanaki: —¡Maawaeni ninkarika miritatsiri ishireki ipokashitenaata imiritapaeta! ");
INSERT INTO cjoNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ari otzimantakyaari rajankaneki aapatziyanari iñaa owañaantatsiri oshitowantapaakyaari. Rootaki okantakotziri Iwaperite Tajorentsi iroka iñaa nokantakimirika imiritapaeta. ");
INSERT INTO cjoNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ro roshiyakaawentakiri iñaatatsiri rowaga Ishire Tajorentsi, rootaki iinja kithatakayaarini maawaeni aapatziyariri Jesoshi. Omaanta tekiraata ijenokanaa riraga Jesoshi rootaki tekira opokashitantari roori Ishire Tajorentsi aapatziyariri. ");
INSERT INTO cjoNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Eenitatsi oshekini piyoteeyeencharini jaga ikemawakiri ikantakiriri rirori, roojatzi ikanantanaka apaanipaeni: —Riroperotaki irika kamanantzirorini iñaani Tajorentsi aamaantakariri maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Paashini kantayitatsirini: —Rirotaki Rotyaantanewo Tajorentsi. Paashini kantatsiri: —¿Arima ipoñeeyani riraga Rotyaantanewo Tajorentsi Karireeyaki? Teewee. ");
INSERT INTO cjoNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Rooma okantzi Iwaperite Tajorentsi: “Rotyaantanewo Tajorentsi rirotaki icharineeteni Iraviirini. Ipoñaakya Weriki, janta ijeekawitani irira paerani”. ");
INSERT INTO cjoNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Roojatzi ipiyapiyawaantetakotantakariri maawaeni riraga Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Eenitatsi apaanipaeni kowawiteenchari ragaerimi, omaanta tee imatziro. ");
INSERT INTO cjoNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ipiyeeyanakani maawaeni waariryaapaeni. Rareeteeyapaakarini riraga jewatatsiripaeni ñaanakowenantatsiri eejatzi warijeeyopaeni. Ikantawakiri: —¿Iitakajaga kaari pamantanari jaka? Nokantawitzimi inkaaganki: “Pamakinari”. ");
INSERT INTO cjoNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Rakapaakiri: —Kameetha iñaawaetzi irinta shiramparinta. Kameetha riyotaantzi, tekatsi paashini kimityaarini. Tee ikantziro oetarika kaari kameethatatsi. ");
INSERT INTO cjoNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ikantawakiri: —Ramatawitashitakimi eerokapaeni eejatzi. ");
INSERT INTO cjoNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Naapatziyakari naakapaeni jewatatsiri? Kaari naapatziyari. ¿Raapatziyakaririka warijeeyopaeni? Kaari. ");
INSERT INTO cjoNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Omaanta irintapaeni atzirinta tee riyojeempiyaawo Iwaperite Tajorentsi. Tee okameethatzi iñaaperotziri riraganki. Rowashironkaeri Tajorentsi maawaeni irinta iinja. ");
INSERT INTO cjoNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Eenitatsi jaga Nikoreemo, pokashitakiriri riraga Jesoshi chapinki tsiteniriki. Itsipatawakaeya iwarijeeyotzinkarite, ikantanakiri: ");
INSERT INTO cjoNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“¿Pikantakotashitari: ‘Tee ikameethatzi Jesoshi’?” Eeromi okantakae rojankinarini Moeseeshi okameethatzi ityaawo akemijanteri ikantakiri, eejatzi okameethatzi ityaawo ayotero kameetha oetarika rantakiri. ");
INSERT INTO cjoNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ikantawakiri: —Tema eeroka eejatzi pikimiwitari karireeyajatzi riraga kaari iyotziriri. Paminaminayiteroni Iwaperite Tajorentsi piyotantyaari tee ipoña Karireeyaki riraga Rotyaantanewo Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Roojatzi riyaatanee maawaeni ipankokipaeni. ");
INSERT INTO cjoNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Omaanta irira Jesoshi riyaatakaanakina tonkaariki, iitachari Oriiwomashi. Ari nomaaki janta. ");
INSERT INTO cjoNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Okitejitzimataki ipiyakaapaakina Tajorentsipankoki. Oshekyaantzi atziri riyaatashitanakiri. Ijeekapaaki riraga Jesoshi, riyotaantapaariri. ");
INSERT INTO cjoNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ramaeyapaakinirini apaani tsinani iñeetakiro oshirontakari shirampari kaari oemi. Riraga amirori rirotaki iyotaantziroripaeni Iwaperite Tajorentsi, eejatzi warijeeyopaeni. Rojatekakiro niyanki. ");
INSERT INTO cjoNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ikantapaakiri: —Iyotaantatsiri, iñeetakiro tsinanika oshirontakari shirampari kaari oemi. ");
INSERT INTO cjoNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Paerani rojankinatzini Moeseeshi okameethatzi rompojanteetyaawo mapi tsinani oshirontakari kaari oemi. ¿Tsika pikantzika eerori? ");
INSERT INTO cjoNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Iñaantawitari, ikowaeyawitani ikompitakayaarimi, rootaki ikananteeyawitaririni. Omaanta apatziro roeyotanaka Jesoshi, rojankinatantanakawo rakoempeki kipatsiki. ");
INSERT INTO cjoNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Rapiitawitanakari riroripaeni: —¿Iitaka pikantziri? Ikatziyanaka irira. Ikantawakiri: —Eenitatsirika pikaatzika iroñaaka kaari antziro kaari kameethatatsi, rityaawo rompojero mapiki, ari roojatzi pompojero maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Rapiitziro roeyotanaka, eejatzi rojankinatanee kipatsiki. ");
INSERT INTO cjoNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Omaanta ikemantawori iroka, maawaeni thawetakotzirori riyaatanee. Ritanaawo riraga aatayiteencharini, rimpaetanaki riraga maawaeni ewankaripaeni riyaatanee. Roojatzi ijeekanaki riraga Jesoshi, eejatzi roori tsinani, roojatzi okatziya jaga. Eejatzi nojeekanaki naakapaeni riyotanewo eejatzi paashini atziri. ");
INSERT INTO cjoNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ikatziyanaa riraga Jesoshi. Tekatsi iñaaki thawetakotzirori, inta eenitatsi tsinani. Ikantziro: —¿Tsika iroñaaka riraganki thawetakotakimiriranki? ¿Tekatsima thawetakotemironi pantziri? ");
INSERT INTO cjoNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Okantanakiri roori: —Tee noñaawaeri, nowinkatharite, jateeyaneeni. Roojatzi ikanantawakawo: —Eejatzi naari, eero nokantakowentzimiro pantakiri. Piyaatanee iroñaaka, eero papiitziro panteero kaari kameethatatsi. ");
INSERT INTO cjoNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Impaetzi rapiitantawori iñaanataneeri Jesoshi atziri ikantanakiri: —Naaka oshiyaworiranki ootamentotsiranki koñeetyaakayeroni maawaeni kipatsipaeni. Tema niyoperotakotziri riraga Pawa Tajorentsi eejatzi niyoperotakotzimiro tsika ikanta. Eejatzi nokantakotzimiro oetaka kyaaryooperotatsiri. Ninkarika aapatziyakinari eero rantapiintziro kaari kameethatatsi, tema kimitakotaka ijeekaki kitejiriki ikimitaaga riraga Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Roojatzi ikanantanakari warijeeyopaeni: —Tema pikantakotashita eeroka apaniroeni. Nokemimi omaanta tee nomatziro naapatziyemi, eerorika tekatsi apite ikantana. Tema tee niyotzi kyaaryooperorika okaatzi pikantziri. ");
INSERT INTO cjoNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ikantawakiri: —Jee, naaka kantakotacha. Omaanta kyaaryooperotaki nokantakiri. Ro okameethatantakari niyotzi naaka tsikarika nopoñaakari. Eejatzi niyotzi tsika niyaatee. Omaanta eeroka tee piyotzi tsikarika nopoñaanakari. Eejatzi tee piyotzi tsikarika niyaatee. ");
INSERT INTO cjoNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Pikimitakari oshekini paashini atziri. Tee piyotana omaanta pikantakowentashitakina maawaeni. Pikenkithashiryaashita: “Irika shirampari ikimita maawaeni paashini shirampari”. Omaanta naaka tee nokantakowentzimi iroñaaka. ");
INSERT INTO cjoNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Omaanta nokantakowentemimi pikameethatzirika iroñaaka, kyaaryootaki nokantakowentemimi. Niyotakimi; eejatzi kijokiro royena Pawa riraga otyaantakinari, riyotakimi eejatzi. Nokaataki apite niyoperoeyemini. ");
INSERT INTO cjoNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Rooma okantzi Iwaperite Tajorentsi rowaga piñaanatapiintziri: “Apiterika ikaate kantakoterini atziri ari ayoperotanaki kyaaryooperotaki ikanteri”. ");
INSERT INTO cjoNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ari nokantakota naaka, eejatzi ikantakotana Pawa riraga otyaantakinari; apite nokanta. ");
INSERT INTO cjoNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ikantanakiri riraga warijeeyo: —¿Tsika iroñaaka piri? Ikantawakiri riraga Jesoshi: —Tee piyotana. Tee piyotziri Pawa eejatzi. Aririka piyotakinami eeroka, piyotakirimi riraga Pawa eejatzi. ");
INSERT INTO cjoNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Rootaki ikantakiriri maawaeni Jesoshi janta Tajorentsipankoki. Ijeekanaki okaakini janta ipapiintzirinta Tajorentsi koriki. Ikowawitaka riraga warijeeyopaeni ragaeterimi riraga Jesoshi omaanta tekira omonkaata ikamantyaari maawaeni ikowakaakiriri Ashitariri, rootaki kaari imatanteetari ragaeteri. ");
INSERT INTO cjoNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Eekiro riyaatatzi riraga Jesoshi ikantanaki: —Rootzimateentsi niyaatee. Pikowakowawitanakinami maawaeni piñaanakinami omaanta eero piñaana. Eero pimatziro piyaate niyaateenta naari. Tema roojatzi pikantyaani pantapiintero kaari kameethatatsi roojatzi pikamantakya, rootaki piyaatantyaari paamariki kaari tsiwakanitatsini. ");
INSERT INTO cjoNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ikantawakaaka riraga jewatatsiripaeni joriiyopaeni: —Pikenkithashireeya ishinetatya. Pikemakiriroña ikanantari: “Rooteentsi niyaatee, eero pimatziro piyaate niyaateenta naari”. ");
INSERT INTO cjoNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ikantanakiri riraga Jesoshi: —Eeroka jeekatsiri kipatsikika omaanta naaka nopoñaaka jenokinta. Jaka kipatsikika rootaki pijeekantari eerokapaeni. Tee nojeekaperotzi naaka kipatsikika. ");
INSERT INTO cjoNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Rootaki nokanantakimiri inkaaganki: “Tema roojatzi pikantyaani pantapiintero kaari kameethatatsi roojatzi pikamantakya”. Eerorika paapatziyawo nokantakimiri, aritaki piyaataki paamariki kaari tsiwakanitatsini. ");
INSERT INTO cjoNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Rojampitakiri, ikantakiri: —¿Ninkamika? Ikantawakiri: —Tema nokantaperowitakimi. ");
INSERT INTO cjoNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Eenitatsi osheki nokantemirimi; eenitatsi eejatzi pantayitzirini nokantakowentemirimi. Omaanta riroperotaki otyaantakinari, eenitatsi ikantakinari irira: rootaki iroka nokamanteriri atziripaeni. ");
INSERT INTO cjoNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Tee riyotziri riraga jewatatsiripaeni joriiyopaeni rirotaki ikenkithatakotakiri Ashitariri, riraga Pawa Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Roojatzi ikantziri riraga Jesoshi: —Aririka powatzikakotakina paata koroshiki, aritaki piyotanakina eerokapaeni. Piyotena nopoñaanaka jenokinta, natziritapaaki jaka kipatsikika. Eejatzi ari piyotanakina tekatsi nantawitya naari. Nokantziro iroka riyotaakinari Pawa otyaantakinari, ");
INSERT INTO cjoNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","kijokiro rowanakina rirori. Tema nantziniri naari oetarika ikowakaakinari irira, rootaki kaari rookantana. ");
INSERT INTO cjoNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Eeniro ikanteeyakiririni iroka, ari osheki atziri raapatziyimawitakari. ");
INSERT INTO cjoNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Roojatzi Jesoshi ikanantanakari riroripaeni: —Aririka paapatziyaperotanakyaawo nokantzimiri, tema eeroka niyotaanewopaeni. ");
INSERT INTO cjoNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Aritaki piyotakoperotanakina naaka riraga kyaaryooperotatsiri. Rootaki nookakaakowenantakimiri. Eero omperateeteemi paashini. ");
INSERT INTO cjoNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ikantawakiri riroripaeni: —Naaka icharineetenipaeni Awaraamani. Tekatsi omperatenani paerani roojatzi iroñaaka. ¿Iitakajaga pikanantanari: “Pookakaakowenantakinari”? ");
INSERT INTO cjoNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Rakakiri rirori: —Kyaaryooperotaki iroka nokantemiri. Eenitatsi omperatariri maawaeni antzirori kaari kameethatatsi. Rowaga kaari kameethatatsi rantapiintziri, oshiyawitari omperatariri. ");
INSERT INTO cjoNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Riraga omperarentsi eero ikantani ijeekaperote ipankoki omperatariri. Omaantakya riraga itomi ashitawori ipanko ikantani ijeekaperote irira. ");
INSERT INTO cjoNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Naaka Itomi Tajorentsi. Aririka nookakaakowentakimi, eero rapiiteemi romperateemi. ");
INSERT INTO cjoNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Niyoperotakimi maawaeni, eerokatawitaka icharineetenipaeni Awaraamani. Omaanta tee paapatziyawo nokantzimiri. Rootaki pajaryaantanari powamaena. ");
INSERT INTO cjoNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Naaka nokamantzimiro okaatzi ikantakinari Pawa nashi eejatzi roñaagakinawo janta notsipatarinta. Omaanta eeroka ikantzimi pirintakari pashi rootaki pantapiintziri eerokapaeni okaatzi ikowakaakimiri. ");
INSERT INTO cjoNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ikantawakiri: —Naakapaeni joriiyopero, naaka icharineetenipaeni Awaraamani. Ikantziri riraga Jesoshi: —Kaari. Eerokami maawaenimi icharineeteniperopaenimi Awaraamani aritaki pikimitanakyaarimi. Raapatziyanani paerani rirori, picharineetenitakyaarinimi, pikimityaarimi eeroripaeni, paapatziyakinami. ");
INSERT INTO cjoNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Naaka kantawitawori kyaaryootatsiri nokemiri Tajorentsi. Omaanta pajareeyanani powamaena. Tee pikimitani riraga Awaraamani, tee. Ikimoshiryaantakari rirori raapatziyakawo oetaka ikantziri riraga Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Omaanta pantapiintziro eeroka rantziri piriperotari. Roojatzi ikanantanakari irirapaeni: —¿Paashinika ashitanari? Apaani nirintari naakapaeni. Rirotaki Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ikantakiri riraga Jesoshi maawaeni: —Rirorikami pirintyaarimi Tajorentsi aritaki pinintaperotakinami naaka. Tee nopokashita; aritaki nopoñaakari riroriki, rirotaki otyaantakinari. ");
INSERT INTO cjoNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Iitaka kaari piyotantawakawori nokantzimiri? Tema tee pikoyi paapatziyawo okaatzi nokantzimiri, rootaki kaari pimatantawo paapatziyawo. ");
INSERT INTO cjoNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Rirotaki Jatanaashi pirintakari eerokapaeni. Rootaki pikowantakari pantapiintziniri ikowakayimiri. Owamaantatsirini paerani: irira rirotaki oñaagantzirori rowamaantzi. Tee ikenkithashireeyawo kyaaryootayitatsirini, rootaki kaari ikameethatanta. Theeyachari irira, rootaki itheeyantayitaarini atziri. ");
INSERT INTO cjoNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Omaanta naaka nokamantawitakimiro kyaaryooperotatsiri, omaanta tee paapatziyana; tema poyaatatziiri riraga Jatanaashi. ");
INSERT INTO cjoNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Eenitatsi jaka ñaakinari naari nantziro kaari kameethatatsi? Teewee. Rooma okameethatakirika nokantakimiri, ¿iitaka kaari paapatziyantana? ");
INSERT INTO cjoNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Maawaeni itomintari Tajorentsi, rirotaki aapatziyawori ikantziri. Tee itomintzimi eerokapaeni. Rootaki kaari paapatziyantawo ikantziri rirori. ");
INSERT INTO cjoNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Roojatzi ikantawakiri riraga jewatatsiripaeni joriiyopaeni: —Kyaaryootaki nokantakimiri. Eerokataki jamaaryajatzi, eejatzi ithawirentsitakaashitakimi kamaari. ");
INSERT INTO cjoNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ikantawakiri rirori: —Tee nothawirentsitzi: nopinkathatziri Pawa. Omaanta eeroka tee pipinkathatana; pitheenkakina eeroka. ");
INSERT INTO cjoNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Tee nokowashita iñaaperotena atziri; inta Pawa kowaentsiri iñaaperotena maawaeni atziri. Eejatzi rirotaki kantakowenterini maawaeni theenkanari ikameethatzirika. ");
INSERT INTO cjoNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Kyaaryootaki iroka nokantemiri: raapatziyaperotawakyaaworika nokantziriri, eero ikamaperotzi. ");
INSERT INTO cjoNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Roojatzi ikanantanakari riraga jewatatsiripaeni joriiyopaeni: —Iroñaakaroña niyoperotakimi pithawirentsitaki. Kamaki Awaraamani. Eejatzi kamanantayitzirorini iñaani Tajorentsi, kamaki riroripaeni. Omaanta pikantzi eerori: “Eero ikami aapatziyaworini nokantziri”. ");
INSERT INTO cjoNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Kamaki achariniiteni paerani Awaraamani. Kamaki riroripaeni kamanantayitzirorini iñaani Tajorentsi. ¿Piitashiwitama panaakotziri riraga Awaraamani? ¿Piitashiwitama panaakotziri maawaeni paejatziiteni peewaperotaki eeroka? ");
INSERT INTO cjoNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ikantawakiri Jesoshi: —Aririka nokantashityaami neewawenantzi, rooma natsipetyaawomi. Pawa, riraga pikantziri eerori: “Notajorentsite”, rirotaki jewatakaakinari. ");
INSERT INTO cjoNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Tee piyotziri eeroka rirori, omaanta niyotziri naaka. Aririka nokantakimi: “Tee niyotziri”, aritaki nokimitemimi eerori, notheeyakyaami naaka. Rooma niyotziri riraga Pawa. Nomonkaateniri okaatzi ikantanari. ");
INSERT INTO cjoNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Achariniiteni paerani riraga Awaraamani, riyotakotakina rootaki ikimoshiryaantakari. Riyotzi iinja nopoke jaka kipatsiki, natziritapaaki. Iñaakina roojatzi ikimoshireperotantanaka eejatzi. ");
INSERT INTO cjoNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ikantziri riraga jewatatsiripaeni joriiyopaeni: —Tekiraata pantyashiparitzimaneenteeta. ¿Piñiirima Awaraamani? Teewee. ");
INSERT INTO cjoNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ikantawakiri rirori: —Kyaaryootaki iroka nokantemiri. Tekirani ikoñaatzini riraga Awaraamani, eenirona nojeeki naari. Jee, noñaanakiri. ");
INSERT INTO cjoNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Roojatzi ramantawitanakawori mapi riraga jewatatsiripaeni, rompojerimi riraga Jesoshi. Omaanta romanapithatanakari irira Tajorentsipankoki, raminaminawitapaakari janta. Tee iñiiri. Tema shitowanaki rirori. ");
INSERT INTO cjoNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Iinja ikinakaanakina janta riraga Jesoshi. Noñaapaakiri shirampari kamampowaakitatsiri. Aritaki ikantapaaka owakira ikoñaatapaaki. ");
INSERT INTO cjoNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Nokaatziri riyotaanepaeni nojampiteeyirini, nokanteeyirini: —Iyotaanari, ¿iitaka ikoñaatantakari kamampowaakitatsiri? ¿Rooma rantayitzironi kaari kameethatatsi ashitariri ikamampowaakitantakari itomi? ¿Aririka irika antakirori kaari kameethatatsi ikamampowaakitantakari? ");
INSERT INTO cjoNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ikantawakiri: —Tekatsi rantzi, ikamampowaakitashitaka. Eejatzi ashitariri, tekatsi rantzi. Ro ikamampowaakitantakari irika itajonkakowenantakyaariri riraga Tajorentsi. Ikowakaakiri maawaeni atziri riyotanaki kyaaryo itajorentsitaki. ");
INSERT INTO cjoNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Iroñaakaroña okameethatzi antero oetarika ikowakiri Tajorentsi. Rotyaanantanari nokimitantari irira, notajonkakowenantakyaariri irika. Kaari nojamanitzi. Aririka ojamanitaki aaka aririka itziroryaanaki oorya eero amatziro antero oetarika. ");
INSERT INTO cjoNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Eenirona nojeekika jaka kipatsikika, naaka iyotakotakaakiriri Tajorentsi maawaeni atziri. ");
INSERT INTO cjoNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ikanantakariri iroka, reewatantanakawori kipatsi, ijampowathatakiro, roojatzi itziryaakitantakari rokikira kamampowaakitatsiri. ");
INSERT INTO cjoNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ikantakiri Jesoshi irira: —Piyaate janta Shiroeki, pikiwaakitakitya. Rootaki Shiroe inkaare. Roojatzi riyaatantanaka, ikiwaakitapaaka. Ipiya, aminanee. ");
INSERT INTO cjoNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Eenitatsi jaga inampiweri, eejatzi riraga ñaapiintziriri inethaantapiintzi koriki. Ikanteeyanakini: —¿Kaarima irika riraganki jeekapiintatsiri nethaantapiintatsiri koriki? ");
INSERT INTO cjoNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Apaanipaeni kantayitatsirini: —Rirotaki. Paashini kantayitatsini: —Kaari irira. Roshiyashitari. Ikantawakiri rirori: —Naakataki. ");
INSERT INTO cjoNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Rojampitakiri: —¿Tsika ikanteetakimika pikokichaatantaari? ");
INSERT INTO cjoNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ikantawakiri rirori: —Riraga shiramparinta iitachari Jesoshi reewatakiro kipatsi, ijampowathatakiro, itziryaakitantakinawo nokikira. Ikantakina: “Piyaate Shiroeki, pikiwaakitakitya”. Niyaatanaki, nokiwapaaka, roojatzi nokokichaatantanaa. ");
INSERT INTO cjoNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Roojatzi ikanantanakari: —¿Tsikaroña irira? Ikantawakiri: Tsikarika, taanitya. ");
INSERT INTO cjoNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Rootaki kitejiri nomakoryaantapiintari naakapaeni joriiyo itziryaakitantariri riraga Jesoshi kamampowaakitawitachari ikokichaatakaantaariri. Roojatzi raanteetanakanariri warijeeyopaeni. ");
INSERT INTO cjoNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Rojampitawakiri ikantawakiri: —¿Oetaka raashitakimiri pikokichaatantaari? Ikantziri: —Itziryaakitantakinawo jampowatha nokiki, roojatzi niyaatantanakari nokiwaakitakita. Iroñaaka kokichaataana. ");
INSERT INTO cjoNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Roojatzi ikanantanaka warijeeyo apaanipaeni: —Riraga shirampari rantawaetantawo kitejiri amakoryaantapiintari. Teetsikya ipoñaaka Tajorentsiki. Paashini kantayitatsini: —Rirorikami antzirori kaari kameethatatsi, eero imatziromi itajonkantayitenimi. Tema ipiyapiyawaantetawakaanteeyakarini, anik, anik, anik. ");
INSERT INTO cjoNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Rapiitanakiri ikantanakiri: —¿Iitaka piitzirika eerori riraga kokichaatakaakimiri? Ikantawakiri: —Noetziri naaka rirotaki kamanantzirori iñaani Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Riraga jewatatsiripaeni joriiyopaeni tee raapatziyari: iitakaashitawitaka tee ikamampowaakitzi. Ikaemakaantakiri ashitariri eejatzi riniro ");
INSERT INTO cjoNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","rojampitawakiri, ikantawakiri: —¿Rirotaki irika pitomi pikantziriranki: “Ikoñaatapaaki kamampowaakitatsiri”? ¿Iitaka iroñaaka ikokichaatantaari? ");
INSERT INTO cjoNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Rakapaakiri: —Jee, rirotaki notyomi. Noñaaperotziri ashi royiro ikoñaatakotapaakiro ikamampowaakitapaaki. ");
INSERT INTO cjoNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Omaanta tee noñiiri tsikarika ikantaari ikokichaatantaari, tee niyotzi naaka. Eejatzi tee niyotzi ninkarika kokichaatakaakiriri. Tee reentsitanee iroñaaka. Pojampiteri irira. Rootaki ikantziri ashitariri riraga warijeeyopaeni. Ari jatanee. ");
INSERT INTO cjoNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Riraga ashitariri ithaawanteeyakarini riraga jewatatsiripaeni joriiyopaeni, tema riyotaki aritaki ipiyowenteeyakarini riraga Jesoshi. Ikanteeyitakani: “Eenitatsirika kantatsini: ‘Rirotaki Jesoshi Rotyaantanewo Tajorentsi’, eero ishinetziri irira atsipatyaari akemijanteeyini”. Rootaki ithaawanteeyanakarini ashitariri, ");
INSERT INTO cjoNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","rootaki ikanantanakariri: “Tee reentsitanee iroñaaka notyomi. Pojampiteri irira”. ");
INSERT INTO cjoNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Roojatzi rapiitakiri rirori ikaemakaantakiri riraga kamampowaakiwitachari. Ikantawakiri: —Piñaaperoteri Tajorentsi. Irinta shirampari niyoteeyirini rirori antzirori kaari kameethatatsi. ");
INSERT INTO cjoNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ikantapaakiri riraga kamampowaakiwitachari: —Rirorikama antzirori kaari kameethatatsi, tee niyotzi naaka. Apatziro niyotakikya, nokamampowaakitawitani paerani, iroñaaka kokichaataana. ");
INSERT INTO cjoNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Rapiitakiri ikantawakiri: —¿Tsika ikantapaakimika ikokichaatakaanteemiri? ");
INSERT INTO cjoNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Rakapaakiri: —Rootaki nokantawitakimiri inkaaganki omaanta tee paapatziyawakawo. ¿Iitaka pikowantari papiitero pikemiro? ¿Pikowaeyanakinirika eeroka paapatziyari rirori? ");
INSERT INTO cjoNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Roojatzi ikijathatantanakariri ikantanakiri: —Eerokatajaantaki eerori riyotaanewo. Omaanta naakapaeni riyotaanewopaeni Moeseeshini. ");
INSERT INTO cjoNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Niyoteeyini ikenkithatakaakirini Tajorentsi riraga Moeseeshi paeraniperoroña. Rooma riroriranki shirampari tee niyoteeyirini tsikarika ipoñaakari irira. ");
INSERT INTO cjoNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ikantawakiri: —¡Kyaaritaamakya! Rootaki notsikanatantakimiri. Tee piyotziri eerori tsikarika ipoñaakari, omaanta rirotaki kokichaatakaakinari. ");
INSERT INTO cjoNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ayotakoeyirini Tajorentsi, tee ikemijantziri antayitzirorini kaari kameethatatsi. Omaanta riraga pinkathaperoteriri Tajorentsi, antzirori ikowakaakiriri, rootaki ikemapiintantariri riraga Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Tee akemakotapiintziri kokichaatakayerini koñaatapaentsiri kamampowaakitatsiri. Omaanta naaka nokoñaatapaaki nokamampowaakitapaaki, tema retsiyatakotaana rirori. ");
INSERT INTO cjoNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Eeromi ipoñaami Tajorentsiki tekatsimi matenanimi etsiyatakoteenani. ");
INSERT INTO cjoNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ikantziri riroripaeni: —Paerani pikoñaatantapaakari tee pikameethatapaaki. ¿Arima pikowaki iroñaaka piyoteeyinani? ¡Jantzikoeni! ¡Intsipaete piyaate jaga! Rootaki rookantakariri Tajorentsipankoki. ");
INSERT INTO cjoNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ikemakotakiri riraga Jesoshi rookaeyakirini warijeeyopaeni riraga kamampowaakiwitachari. Roojatzi raminakitziri, ikantapaakiri: —¿Paapatziyarima Itomi Tajorentsi? ");
INSERT INTO cjoNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ari ikantawakiri: —¿Tsika ijeekakika, naapatziyakari? ");
INSERT INTO cjoNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ikantapaakiri: —Naakataki. Piñaakinaroña, nokenkithatakaakimi iroñaaka. ");
INSERT INTO cjoNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ikantawakiri: —Naapatziyawakimi, Nowinkatharite. Eeroka riroperori. ");
INSERT INTO cjoNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ikantapaakiri: —Rootaki nopokantakari kipatsikika, nokantakotantyaariri maawaeni atziri tsika ikanteeyani. Tema noñaakimi eeroka, eerokawitaka kamampowaakitatsiri omaanta iroñaaka nokokichaatakagaemi. Niyotaakotakimiri Tajorentsi. Tema paapatziyana rootaki iinja piñaantyaariri irira. Kimitaka iroka nopokapaaki jaka niyotaakoteeriri Tajorentsi maawaeni atziri. Riraga aapatziyeeyanarini aritaki riyotaakiri paashini atziri iñeeri iinja. Omaanta riraga kaari aapatziyeeyanarini inta ikenkithashiryaawita riyoterimi Tajorentsi, tema tee riyotzimaetari eejatzi eero iñiiri iinja. Iitashiwitaka riyotziri iroñaaka. Omaanta roshiyashitakari kamampowaakitatsiri tee riyoperotziri irira. ");
INSERT INTO cjoNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Riraga warijeeyopaeni itsipateeyakarini, ikemaeyawakironi ikantakiriri. Roojatzi ikanteeyantanakani apaanipaeni: —Iroka poshiyakaawentakiri kamampowaakitatsiri, ¿teetsikya pikenkithashiryaakowitana naaka kamampowaakiwitachari? ");
INSERT INTO cjoNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Rakapaakiri rirori: —Pikamampowaakitzira, eero ojeeki kaari kameethatatsi pantziri; omaanta pikanteeyawitani: “Namineeyini”, rootaki ojeekantari pantani. ");
INSERT INTO cjoNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Eekiro riyaatatzi riyotaantzi riraga Jesoshi, ikantanakiri: —Kyaaryootaki iroka nokantemiri. Rooma tsiteniniki romonkyaapiintziri ashitariri rowishate ishiirikoteki. Eenitatsi apaani omoo eejatzi ashitako kameetha. Romonkyaantariri ikempoyaantari tsiteniriki. Ninkarika pokatsini eerorika ikyaapaaki omooki inta rateetashitapaakya raantyaariri owisha, irira rirotaki koshintzi. Ikoyi ikoshite. ");
INSERT INTO cjoNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","3","Eenitatsirika atziri shentziniriri ashitako, aririka ipokapaaki ashitariri, ari rashitaryaawakiniri ishineteri ikyaanaki. Aririka ikyaashitapaakiri, ikaemapaakiri rowishate iwaeropaeni, ari ipokashiteri maawaeni, eero ithaawantawakari ashitariri. Roojatzi raanakiri janta paashitomashiki, ");
INSERT INTO cjoNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","reewatanakiri. Ari riyowaantetziri iñaani, rootaki royaateeyantaririni. ");
INSERT INTO cjoNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Aririka ikaemawityaari kaari iñaapiintzi rowishate, eero riyowaantetawakiri ipaante. Eero royaatziri inta ishiyaapithatanakyaari maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Rootaki roshiyakaawentawitakanariri riraga Jesoshi omaanta tee riyotakoteeyironi oetarika roshiyakaawentziniriri. ");
INSERT INTO cjoNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","9","Ikanteeyanakirini eejatzi: —Kyaaryootaki iroka nokantemiri. Naaka oshiyawori ashitakontsi ikyaapiintzira owisha. Tema kimitaka iroka, aririka pikowaperotaki piyoteeri Tajorentsi paapatziyakinarika naari. Maawaeni eeroka jewatatsiri joriiyopaeni jaka kaari aapatziyanari kimitakimi koshintzi. Kaari piyotaakoperotakiriri Tajorentsi atziri. Omaanta naaka iyoperotziriri riraga Pawa. Ninkarika aapatziyenani naaka nowañaakiri ikantyaani nojeekakayeri eejatzi nopaperoteri oetarika owañeerini. ");
INSERT INTO cjoNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ipokashitziri koshintzi ikoshite owisha, rowamaeri. Eerokapaeni jewatatsiri pikimiwitakari: rooma tee pikameethatzi. Tee piyotaakotantaperotziri Tajorentsi atziri, rootaki aririka ikame irira, tee riyoperotanakiri Tajorentsi. Rootaki kaari iñaaperotantariri rirori ikameethatzi. Tema rootaki kaari nomatantawo nojeekakayeri naaka eejatzi Pawa. Omaanta naaka nopokaki nowañaantakariri kameetha. ");
INSERT INTO cjoNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Naaka oshiyariri riraga shentziriri rowishate kameethari. Tema naaka ashitariri kameethari aapatziyaperotanari rootaki nokowantakari nokamawenteri. ");
INSERT INTO cjoNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Tee nokimitari shentziniriri owisha ipinatziri ashitariri. Irira kaari ashitariri owisha. Aririka iñaawakiri rirori ipokapaaki manitzi, ithaawantanakari ishiyaapithatanakari; rookanakiri owishapaeni. Roojatzi raantapaakyaarikya riraga manitzi apaanipaeni owisha, rowamayitapaakirini. Maawaeni paashinipaeni owisha itsiparyaayitanakani. ");
INSERT INTO cjoNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Aritaki ikantari rirori. Tee ikenkithashiryaaperotziri owisha, inta ikenkithashiryaashitakari koriki ipineeteriri, rootaki ishiyaapithatantanakariri. Pikimitaka eerokapaeni jewatatsiripaeni pookanakiri irika kamampowaakiwitachari, tee pamitakotziri kameetha. ");
INSERT INTO cjoNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Tema naaka oshiyariri riraga shentziriri rowishate kameethari. Kyaaryo naaka ashitariri kameethari riraga aapatziyanari. Tema maawaeni irirapaeni nokashiyeeyirini nosheninka. Kimitaka niyotziri Pawa eejatzi riyotakina naaka, tema niyotziri riroripaeni, eejatzi naaka riyotzitana. Eejatzi nokamawenteri. ");
INSERT INTO cjoNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Eenitatsi eejatzi paashinijatzitatsiri atziri kaari joriiyotatsiri. Nokowakiri maawaeni irira eejatzi ikemantenari oetarika nokantziri, niyotaakotantariri Pawa Tajorentsi roojatzi raapatziyanteena. Aririka raapatziyena ari nokashiyeeri nosheninka. Tema nokashiyeeri nosheninka maawaeni aapatziyanari, joriiyotatsiri eejatzi paashinijatzitatsiri atziri. ");
INSERT INTO cjoNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Eejatzi ikantzi Jesoshi: —Nokowashitari naaka nokamawenteri atziripaeni, rootaki nokamawenantyaariri iinja eejatzi nopiriintanee. Rootaki inintaperotantanari Pawa. ");
INSERT INTO cjoNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Tekatsi matashityaawonimi rowamaenami, inta nokowaperotaki nokamawenteri maawaeni atziri rootaki nomatantyaawori. Nomatero nokamawenteri atziri, eejatzi nomatero nopiriinte: rootaki ikowakaakinari Pawa. Ari riyaatakaanakina naakapaeni. ");
INSERT INTO cjoNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Aritaki okantari ikantakiriri riraga Jesoshi. Roojatzi ipiyapiyawaantetanteeyapaakaririni maawaeni jewatatsiripaeni joriiyopaeni. ");
INSERT INTO cjoNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Eenitatsi osheki kantayitatsirini: —Ikyaantashitakari kamaari. ¿Iitaka pikemijanantariri? ");
INSERT INTO cjoNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ikantzi paashinipaeni: —Tee ikyaantari kamaari, tema kameetha riyotaantzi. Kaari irinta kamaari: tema ineshironkatakiri kamampowaakitatsiri, rootaki ikokichaatakaantariri. ");
INSERT INTO cjoNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Okanta okyaawontsitapaaki. Monkaatapaaka kitejiri nokenkithashiryaantawori rowameethatanteetawori Tajorentsipanko paerani. Ipiyakaakina Jesoshi Jerojareeki. ");
INSERT INTO cjoNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ari ikatziyatziyawaeta rirori janta owitheenkayitani otzinkamipaeni pankotsi, noetziro pankotsi Rashi Sharamooni. Tema rootaki ikaapanomatantakawori rinkinagaakitero okaatzira. ");
INSERT INTO cjoNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ipiyowentapaakari osheki jewatatsiripaeni joriiyopaeni, rojatekapaakiri Jesoshi. Ikantapaakiri: —Paerani pimanapithatakinawo. Pikantaperotena iroñaaka: ¿eeroka Rotyaantanewo Tajorentsi poemishitowaeri oroomajatzi? ");
INSERT INTO cjoNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ikantawakiri: —Aritaki nokanteeyawitakimini; omaanta tee paapatziyawakina. Oetarika nantayitakirini, rirotaki Pawa otyaantakinari matakaakinawori. Iroka nantayitakirini, rootaki riyotakaemirini naaka Rotyaantanewo Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Aritaki nokantakimi: tee ro kaari pikowanteeyani pikemijantena, inta kaari pimatantawo pikemijantana. ");
INSERT INTO cjoNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Riraga aapatziyanari ikemiro nokantziri. Niyotziri maawaeni eejatzi irirapaeni royaatana. ");
INSERT INTO cjoNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Aritaki naaka nowañaakiri maawaeni. Tema roojatzi ikantyaani nojeekakaakiri naaka. Eero riyaatzi paamariki kaari tsiwakanitatsini. Nokempoyaaperotakiri, okimitzimotawitana noerikawakotakiri. Tekatsi aapithatenarini. ");
INSERT INTO cjoNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Riraga Pawa pakinariri ikantakina: “Pikempoyeenari irirapaeni”. Ranaakotakiri maawaeni itajonkantaperotzi, tekatsi aapithaterini eejatzi Pawa rakoki. ");
INSERT INTO cjoNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nomonkaataperotakari Pawa, eejatzi naaka imonkaatakina. ");
INSERT INTO cjoNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Roojatzi maawaeni riraga jewatatsiripaeni joriiyopaeni ramawitanaka mapi rompojantyaaririmi. ");
INSERT INTO cjoNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Omaanta ikantanakiri rirori: —Rirotaki Pawa tajonkakaakinari. Osheki noñaagayitakimironi. ¿Iitakama nantakiri pikowantari pompojantenari mapiki? ");
INSERT INTO cjoNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ikantawakiri: —Tee ro nompojantemiri mapiki pantzirowa kameethatatsiri. Eeroka shirampari, omaanta piitajorentsitashitaka, rootaki nompojantemiri mapiki. ");
INSERT INTO cjoNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ikantanakiri rirori: —Tema rojankinatakaantakiniri Tajorentsi atziri Iwaperiteki rirori, okantzi: “Nokanteeyemini eeroka maawaeni tajorentsitatsiri”. ");
INSERT INTO cjoNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Riraga ojankinatzirorini Iwaperite Tajorentsi ikantziri: “Tajorentsitatsiri”. Tekatsi akantero inashitakayaawo Iwaperite Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ikowakaakina Pawa, rootaki rotyaanantakinari jaka kipatsikika. Inkaaganki nokantakimi: “Naaka Itomi Tajorentsi”. ¿Iitaka iroñaaka pikanantanari: “Piitajorentsitashitaka”? Itajonkantaki Pawa. ");
INSERT INTO cjoNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Eerorika nokimitari irira eero paapatziyana. ");
INSERT INTO cjoNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Omaanta nokimitaririka, paapatziyeeyanani. Eerorika pikoyi paapatziyashitana naari, okameethatzi paapatziyakotenawo nantziri. Paapatziyawo, roojatzi piyotantyaari ikimitana Pawa. Eejatzi naari nokimitari irira. Piyoperotawakiro. ");
INSERT INTO cjoNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Rapiitziri ikowaperoeyawitanakani rayerimi, omaanta ipeyimotanakari Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ari imontyaakaanakinawo naaka riraga Jesoshi Joriraaniki. Riyaatakaanakina janta intatsikeronta tsikarika paerani Jowani ikaawoshitantzi. Aritaki ijeekakaapaakina janta apite kashiri. ");
INSERT INTO cjoNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Osheki pokashitanakiriri eejatzi. Ikanteeyawakaapaakani: —Tee itajonkantzi Jowani omaanta kyaaryootaki maawaeni ikantakotakiriri Jesoshika. ");
INSERT INTO cjoNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Osheki aapatziyayitawakaririni riraga Jesoshi janta. ");
INSERT INTO cjoNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ijeeki Wetaaniyaki shirampari iwaero Raajawo, imantsiyataki. Ojeeki eejatzi ipankoki ritsiropaeni: rowaga Mariiya, eejatzi rowaga Maarita. ");
INSERT INTO cjoNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Chapinki ojeetziri Mariiya Awinkatharite iitziki. Ro ojeetantari kajankaari. Oshetantari oeshi eejatzi. Tema mantsiyataki iyaariri, ");
INSERT INTO cjoNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","rootaki otyaanantakariri kanterini Jesoshi. Inteenanta riyaatashitakiri. Iñaantapaakariri ikantapaakiri: —Nowinkatharite, riraga Raajawo pinintaperotziri, mantsiyataki. Thame aate. ");
INSERT INTO cjoNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ikemantawakariri Jesoshi ikantawakiri: —Imantsiyatawitawakyaata omaanta eero ikamaperotzi. Ro imantsiyatantakari, ikowaki Pawa Tajorentsi maawaeni atziri ipinkathatena naari eejatzi ipinkathatzityaari irira. ");
INSERT INTO cjoNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesoshi inintaperotziro roori Maarita, irento, eejatzi iyaariri. ");
INSERT INTO cjoNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ari ikemakotzitakari imantsiyataki, tee riyaatzita intsipaete, ijeekanaki apite kitejiri. ");
INSERT INTO cjoNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Roojatzi ikanantanakina maawaeni: —Thame apiyeeyanakini eejatzi Joreeyaki. ");
INSERT INTO cjoNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Nokantanakiri naari: —Iyotaanari, chapinki janta ari rompojakimimi mapiki riraga joreeyajatzi. ¿Eekiroma pipiyashitanaatyeeri janta? Eero aatzi: rowamaemikari. ");
INSERT INTO cjoNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","10","Riyotantari Jesoshi oetarika ikenkithashireeyari Pawa Tajorentsi eejatzi oetaka ikowakaanari naari, ikantana maawaeni: —Tema eeniro okaatzi 12 oorapaeni apaani kitejiri akatziyatziyawaetantyaari eero antziwatanta. Eejatzi eenitatsi 12 oorapaeni tsiteniri akatziyatziyawaetantyaaworika aritaki antziwatakya. Okimiwitakawo iroka, tekiraata omonkaata kitejiri rowamaena. Aritaki amatakiro akatziyatziyawaete janta. Eero rowamagaetana iroñaaka, eero. Pawa ikowakaakae aate aaka. Aririka aapatziyaperotyaari riraga Tajorentsi, eero imatziro paashini atziri ipakaakagaero aapatziyakarira. ");
INSERT INTO cjoNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Aritaki ikantakinari. Roojatzi ikanantanari: —Imaashitaka Raajawo. Niyaate iroñaaka nokaakapaeri rirori. ");
INSERT INTO cjoNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Nokantanakiri: —Maaperotakirika, Nowinkatharite, aritaki retsiyatakotanee. ");
INSERT INTO cjoNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Omaanta ikenkithatakowitakari Raajawo, ikamaki. Naaka, noetakashitawitaka ro ikantanari: “Imaashita, imakoryaantari”. ");
INSERT INTO cjoNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Roojatzi ikantaperotantanakinari: —Kamaperotakiroña Raajawoni. ");
INSERT INTO cjoNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Kameethaperotaki tee noñiiri naaka ikamimotena, pimatantyaawori paapatziyaperoeyanakinani, rootaki nokimoshiryaantanakari. Thame amineeyakiterini maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Riraga Tomashi iiteetziri Tsipantzi, ikanteeyanani: —Thame aateeyanakini maawaeni, rowamagaete aaka. ");
INSERT INTO cjoNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Roojatzi niyaatantanaka. Nomagaeyakini niyanki awotsi. Okitejitanaki roojatzi nowaagantanaka. Tsitenini rootzimateentsi nareetya inampiki Raajawoni. Ikanteetawakina ikaatakotaki 4 kitejiri omonkyaaganteetantakariri Raajawoni omooki impeetaki. ");
INSERT INTO cjoNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Rowaga Wetaaniya okaakintawo Jerojaree, aamaashitya okaatzi 3 kiroometero. ");
INSERT INTO cjoNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ipoñaaka Jerojareeki osheki joreeyajatzi pokashitzirori Maarita eejatzi Mariiya. Eejatzi itsipatawo wetaaniyajatzi. Ikantapaakiro: —Eero petakotashitari piyaaririni. ");
INSERT INTO cjoNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ari ritakawo apaani shirampari, kamanteroni Maarita: —Kaakitakira Jesoshi. Ookanakiro opanko, jatanaki otonkiyotawakari. Omaanta Mariiya, eeniro ojeekanaki pankotsiki. ");
INSERT INTO cjoNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Okantawakiri rowaga Maarita: —Aririkami pijeekimi jaka, Nowinkatharite, eeromi ikamimi aarinini. ");
INSERT INTO cjoNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Niyotaki iroñaaka oetarika pikanteriri riraga Tajorentsi aritaki ipakimi okaatzi pikowakoteriri. ");
INSERT INTO cjoNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ikantapaakiro: —Aritaki rapiiteero rañaagae piyaaririni. ");
INSERT INTO cjoNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Okantawakiri: —Jee, aririka omonkaatapaakya kitejiri ipiriinanteeyariri Tajorentsi maawaeni kamayitatsirini, aritaki ipiriintanee rirori aarinini. Niyotakiro iroka. ");
INSERT INTO cjoNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","26","Ikantapaakiro: —Naaka añaakagaerini maawaeni kamawiteenchari, eejatzi nowañagaeri riraga piyaaririni eejatzi. Ikamawitakyaarika aapatziyanari ari rapiiteero rañaagae eejatzi. Eero noshinetziri apaani atziri aapatziyanari itsipatyaari Jatanaashi janta paamariki kaari tsiwakanitatsini. ¿Paapatziyawoma iroka nokantakimirika? ");
INSERT INTO cjoNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Okantawakiri: —Jee, Nowinkatharite, niyotakimi eerokataki riraga Itomi Tajorentsi riraga Rotyaantanewo naamaakari. ");
INSERT INTO cjoNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ari, piyaate pikaemiro pirento. Roojatzi opiyanaka, okantziro rowaga Mariiya. Okamantathatapaakiro: —Areetapaaka Iyotagaeri, ikaemakaantapaakimi. ");
INSERT INTO cjoNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Okantziro: —Jee, ari. Intsipaete okatziyanaka, iyaatashitanakiri Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Tekiraata rareetya rirori pankotsiki. Eeniro ijeeki janta otonkiyotakitarinta Maarita. Ari royiiro janta Mariiya. ");
INSERT INTO cjoNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ari iñaakiro roori iyaatzi maawaeni tsipataworipaeni pankotsiki ari roemoshirenkaatziiro, roojatzi royaatantanakawo maawaeni. Iitawitaka ari iyaate apiitero iraakotyaari iyaaririni janta omookinta. ");
INSERT INTO cjoNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ari oñaapaakiri Jesoshi, iyaatashitziri otziwerowashitapaakari owethatari. Okantapaakiri: —Poemoshirenkapaena, Nowinkatharite. Aririkami pijeekimi jaka, eero ikamimi aarinini. ");
INSERT INTO cjoNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Iñaawakiro riraga Jesoshi irayimotapaakari, eejatzi riragaeyakani joriiyopaeni riraga tsipatayitaworini. Roojatzi ikantashiretanaki rirori, rowashiretanaka. ");
INSERT INTO cjoNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ikantanaki: —¿Tsika powakirika? Okantawakiri: —Janta, Nowinkatharite, nowakiri omooki. Thame paminakitero. ");
INSERT INTO cjoNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ari riraapaaka riraga Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Rootaki ikanantanakari joreeyajatzi: —Piñaakiri, osheki inintashiretawitarini. ");
INSERT INTO cjoNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Eenitatsi apaanipaeni kantaneentsiri: —¿Kaarima irika kokichaatakagaeriri kamampowaakitatsiri? Eenirorikami jaka, ¿arima retsiyatakoteerimi eejatzi Raajawoni, eero ikamimi? ");
INSERT INTO cjoNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Rapiitziro ikantashireperotanaki rirori. Rokaakiwitapaakawo omoo imoontashitanteetakariri kaminkari impeetaki. Rashitakotanteetakari mapi. ");
INSERT INTO cjoNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ikantapaaki riraga Jesoshi: —Pipinoyaakoteri mapikika. Okantawakiri rowaga Maarita: —Eero, Nowinkatharite, ikaatakotaki imaakotaki 4 kitejiri ikamantakari. Shitzitanaki. ");
INSERT INTO cjoNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ikantanakiro: —Eero pikantzi: “Eero”. Tema nokantakimi: “Paapatziyakinarika aritaki piñaakiro itajonkante Tajorentsi”. ");
INSERT INTO cjoNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Roojatzi ipinoyaanteetakawo mapi. Raminanaki riraga Jesoshi jenoki, ikantanaki: —Ariwee, Pawa, niyotaki pikemakina. ");
INSERT INTO cjoNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Niyotaki pikanta pikemapiintana. Eenitatsi osheki katziyimotanari jaka. Nokowaki riyote maawaeni potyaantakina, rootaki nokenkithatakaantzimiri. ");
INSERT INTO cjoNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Roojatzi ikaemaperotantanaka: —Raajawo, pipiriintee, pipokae. ");
INSERT INTO cjoNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Roojatzi riyowantanaka kamawiteenchari. Chapinki roojotanteetawakariri tokoyatha: rakoki, iitziki, maawaeni. Ipashikapootanteetawakariri paaño. Iroñaaka ikantziri Jesoshi: —Poojoryaakoteeri, potyaanteri riyaatee. ");
INSERT INTO cjoNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Riraga joreeyajatzi, rirotaki tsipateeyakaworini Mariiya, iñaakoeyakirini Jesoshi ipiriintakagaari Raajawo rowañaagaeri. Tema oshekini riraga jewatatsiri raapatziyeeyanakarini Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Paashinipaeni riraga jewatatsiri iñaakiri eejatzi ikijanaka. Roojatzi riyaatashitakiri warijeeyopaeni, ikantakotapaakiri riraga Jesoshi, okaatzi rantakiri. ");
INSERT INTO cjoNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ari ikantakoeyakitzirini riraga warijeeyopaeni. Tema ikaemakaanteeyakirini riraga 70 jewawentziriri joriiyopaeni. Ikantawakaeyakani: —¿Tsika akanterika? Riraganki shirampari osheki itajonkantapiintaki. ");
INSERT INTO cjoNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Aririka ashinetanakiri eekiro riyaatzi itajonkantzi, ari raapatziyeeyanakyaarini maawaeni atziri, ipokashiteekari oroomajatzi, ishekirowakoteekari Tajorentsipankoki. Eejatzi ithonkaekari aaka, maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Itsipatari Kaejashi riroripaeni janta. Iroñaaka ojarentsi rirotaki irira iwinkatharite ñaanakowenantatsiripaeni. Ikantanaki rirori: —Tekatsi piyote eerori. ");
INSERT INTO cjoNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Tee pikenkithashiryaakya. Pamineeyini: okameethatzimoeyeminiita ikameeta apaani shirampari rowawijaakoeyanteerini aakapaeni, eero athonkanta maawaeni aakapaeni. ");
INSERT INTO cjoNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Tee ikantashitari iroka. Rooma rirotaki iwinkatharite maawaeni ñaanakowenantatsiri. Riyotaakiri Tajorentsi, rootaki ikantakotzitantakariri ikamawenteeyerini riraga Jesoshi maawaeni joriiyopaeni. ");
INSERT INTO cjoNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","53","Tee apatziro ikamawenteeyirini joriiyopaeni, inta ikamawenteri maawaeni atziri reentsitetantyaariri Tajorentsi maawaeni aapatziyariri rirori. Inashiteeyawitani, ijeekaeyini maawaeni nampitsikipaeni inteenaki omaanta ikamawenteri ipiyoeyantyaaririni maawaeni. Aripaete riraga jewatatsiripaeni joriiyopaeni rajaryagaeyakarini riraga Jesoshi, rowamaeri. ");
INSERT INTO cjoNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Rootaki kaari iroñaaka ikinapiinantanakari irira janta roshekitzinta joreeyajatzipaeni, tee roñaagapaari. Riyaatakaanakina paashiniki kipatsi. Ari ijeekakaapaakina nampitsiki oetachari Ejerayeemi othapikinta janta tekatsinta atziri ipanko. ");
INSERT INTO cjoNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Rootzimateentsi omonkaatya Kitejitatsiri Rawijantariri Ronampiri Tajorentsi janta Ejiipitoki ikimoshireeyantyaarini maawaeni nojoriiyotzinkarite. Iroñaaka itonkaanaki maawaeni Jerojareeki rowameethatantanakyaariri, ipinkathatantyaariri Tajorentsi. Riyaateeyanakini jeekatsiri tsikarikapaeni, ");
INSERT INTO cjoNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","tema raminaminawitapaakari Jesoshi. Ikyaapaaki maawaeni Tajorentsipankoki ipinkathateri Tajorentsi, ikantawakaapaaka: —¿Oetaka pikenkithashiryaari eeroka, arima ipokaki Jesoshi? —Aamashitya aririka. ");
INSERT INTO cjoNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Tema aritaki ikantakaantakae aaka maawaeni atziri riraga warijeeyopaeni eejatzi jewatatsiripaeni ñaanakowenantatsiripaeni: —Aririka piñaakiri Jesoshi, pipoke pikamantakitena intsipaete. Tema ikowaeyanakini raakaanteri. ");
INSERT INTO cjoNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Tekiraata 6 kitejiri omonkaatantyaari nokimoshirewenantyaawori Kitejitatsiri Rawijantariri Ronampiri Tajorentsi janta Ejiipitoki. Rareetakaaneena riraga Jesoshi Wetaaniyaki janta ijeekinta riraga Raajawo kamawiteenchari: riraga rowañagaeri Jesoshi. Tema itsipateeyakawoni ritsiropaeni, rowaga Maarita eejatzi rowaga Mariiya. ");
INSERT INTO cjoNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ari riwetsikaetakiro owanawontsi iñaaperotantyaariri Jesoshi. Tema eejatzi ikaateeyirini Raajawo, naaka riyotaanewopaeni eejatzi paashinipaeni atziri. Rakiyoteeyirini maawaeni. Maarita rowaga ritsiro riraga Raajawo rootaki kitantatsirini okitziri atziripaeni. ");
INSERT INTO cjoNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Irento Mariiya amapaakiniri Jesoshi kajankapithari yoshaachari naariwo, kameethaperotatsiri. Pinaperotachari. Otziripithatantakari iitziki, roojatzi oshetantanakari oeshi. Kajankaenkatanaki maawaeni pankotsiki. ");
INSERT INTO cjoNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ari eenitatsi jaga Joorashi karyootejatzi rirowitaka riyotaanewo. Riyotaki riraga Jesoshi rirotaki aakaanterini iinja. Ikantawakiro: ");
INSERT INTO cjoNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Iitaka kaari pipimanantawo kajankapitharika? Pinaperowitachari osheki koriki. Apayitanakiririnimi riraga ashironkaenkaripaeni. Omaanta peewanatashitakawo owinawo maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ikantashita: tee ineshironkatziri ashironkaenkari. Ikempoyaawitanari noorikite maawaeni, omaanta rirotaki ayitanariri eechonkiini noorikite. Tema eejatzi ikowaki eechonkiini owinawo kajankapithari, rootaki ikijakotantawori tee opiri owinawo. ");
INSERT INTO cjoNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ikantziri Jesoshi: —Okantyaata. Iyotaki nokame, rootaki otziripithatantanari tekiraata nokame. ");
INSERT INTO cjoNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ikantyaani ikaatemikya maawaeni owashironkaenkari, ari pimatero pineshironkatapiinteeyerini. Omaanta naaka eero nokantani nokaatemi maawaeni kitejiri. Eero oshekitzi kitejiri pineshironkatantanakinari jaka kipatsiki. ");
INSERT INTO cjoNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Osheki joreeyajatzipaeni kemakoeyawakiririni riraga Jesoshi eenitatsi janta, rootaki riyaatashitantanakari maawaeni. Eejatzi riyaatashitanakiri maawaeni ikoyi iñaantyaariri Raajawo, riraga kamawiteenchari ipiriintapaakiri rirori. ");
INSERT INTO cjoNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Rajaryagaeyakarini maawaeni jewatayitatsirini Tajorentsipankoki: tema ikowanaki rowamaeri eejatzi Raajawo. ");
INSERT INTO cjoNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Osheki joreeyajatzipaeni ñaakoeyakiririni riraga Jesoshi rowañaakiri Raajawo, rootaki iroñaaka osheki jewatatsiri joriiyopaeni raapatziyeeyantanakaririni riraga Jesoshi, eejatzi rotsipariitanakari paashinipaeni jewatatsiri riraga kowatsiri rowamaerimi. ");
INSERT INTO cjoNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Okitejitanaki oshekini pokaentsiri ikimoshireeyini maawaeni. Ikemakoeyakirini riraga Jesoshi ari ipoki Jerojareeki. ");
INSERT INTO cjoNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ari ragaeyanakironi oshipaeni kompiroshi eejatzi paashinipaeni oshiyawori raanakiro janta awotsiki itonkiyoteeyawakarininta Jesoshi. Itacheronkawaanteteeyini: —¡Sha! ¡Irika owawijaakotantatsini! ¡Ikameethaperotzi! ¡Rirotaki Rotyaantanewo Tajorentsi! ¡Rirotaki irika reewawenteeyirini nojoriiyotzinkaritepaeni! ");
INSERT INTO cjoNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Iñaapaakiri Jesoshi apaani wooro tekiraata ikyaakotari atziri. Rirotaki omapokaantapaakariri ikyaakotapaakari rirori. Rootaki imonkaatantakawori jankinarentsi Iwaperiteki Tajorentsi. Okantziri: ");
INSERT INTO cjoNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Maawaeni jeekatsiri Jerojareeki, eero pithaayi, pokapaaki jewawentemini ikyaakotapaakari wooraani tekira ikyaakoetari”. ");
INSERT INTO cjoNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Omaanta tee niyotzi naaka maawaeni riyotaanewo imonkaatziro rojankinateetziro paerani Iwaperiteki Tajorentsi. Aritaki ikamawentee riraga Jesoshi, ipiriintaka eejatzi riyaatanee jenokinta, ari okanta nokenkithashiryaakotziro maawaeni noñaakiri atziri rantakiri rirori. Rootaki nokanantari: “Kyaaryo ari okanta. Imonkaatakiro rirori oetaka rojankinateetziri Iwaperiteki Tajorentsi”. ");
INSERT INTO cjoNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ari chapinki ikaemiri Raajawo: “Pishitowae”, ari shitowanee. Kamaperotawiteenchari, omaanta rapiitziro rañee: nokaatzi osheki ñaakoeyiririni, roojatzi nokantakoeyakironi iroka noñeeyakirini. ");
INSERT INTO cjoNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ari ikemakotakiri riraga Jesoshi maawaeni atziri itajonkantzi rirori, rootaki riyaatashiteeyantakaririni itonkiyotawakari maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Roojatzi ikanantawakaantanaka warijeeyopaeni: —Ñaakiro. Maawaeni atziri royaatziri rirori. ¡Tee okameethatzi! ¿Oetakatya anteri? Tekira amatziri apakaeri rirori. Riraga jewatatsiripaeni joriiyopaeni eekiro riyaatatzi iperatanaka royaateri rirori. ");
INSERT INTO cjoNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Itonkaanaki Jerojareeki osheki atziri ikimoshiretantyaari, eejatzi ipinkathatantyaariri Tajorentsi. Ikaatziri kireeshiyajatzi owakira peyacha joriiyo. ");
INSERT INTO cjoNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Riyaatashiteeyapaakirini irirapaeni riraga Jiripi, rirotaki wetheerajatzi. Ojeeki Wetheera Karireeyaki. Ikantapaakiri: —Yeeyi, nokoyi noñeeri Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Jiripi riyaatashitanakiri ikantakiri Antereeshi. Roojatzi riyaatantanaka apite eejatzi riroripaeni ikanantyaariri riraga Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ikantawakiri irira: —Eerokataki paashinijatzitatsiri atziri omaanta pikoyi piyotena naaka. Kameetharini. Okameethatawita maawaeni atziri maawaeni kipatsiki raapatziyenami naaka. Tema rooteentsi nokamawentemi eerokapaeni maawaeni atziri. ");
INSERT INTO cjoNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Kyaaryootaki iroka nokantemiri. Aririka omanakitero teriiko mapipookiki, eerorika opariyapaaki kipatsiki, eero oshooki roojatzi okantya: apaani okithoki ojeekanaki. Omaanta tziroryaapaentsiri kipatsiki, kimiwitaka kamaki okithoki oshookantari owakirari owaatha, roojatzi okithokitantanakya osheki. ");
INSERT INTO cjoNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Eenitatsi atziripaeni kempoyaayiwitacharini, tee ikoyi rowashironkaya, omaanta ratsipetashitakawo ikempoyaaka, tema rootaki riyaatantyaari paamariki kaari tsiwakanitatsini. Omaanta kaari kempoyaacha inta rantakiniri Tajorentsi ikowakaakiriri omawitya ikemaatsiwentyaari kipatsikika, tema roojatzi ikantyaani rañaapae janta jenokinta nojeekakayeri kameetha. ");
INSERT INTO cjoNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Maawaeni kowatsiri rantenawo nokowakaakiriri, okameethatzi royaatenaata; tema ikaatena tsikarika nojeeki naari. Eejatzi iñaakiri Pawa ikameethatzi rirori. ");
INSERT INTO cjoNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Iroñaaka nokenkithashiryaanaka. ¿Oetaka nokanteriri Pawa? ¿Nokanteririka: “Pawa, rooteentsi rowashironkayena atziri, powawijaakotena”? Eero nokantziri. Tema ro noshintsitashitantakawori nopokantakari kipatsiki nokemaatsityaawo eejatzi nokamawenteri maawaeni atziri. ");
INSERT INTO cjoNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Roojatzi ikenkithatakaantakariri Ashitariri. Ikantziri: —Pawa, nokowaki ipinkathateeyeminiita atziripaeni, iñaaperoeyeminiita pikameethatzi. Roojatzi nokemaeyantakaririni Pawa janta jenokinta, ikantzi: —Tema poñaagakotakityaanari notajorenka eeroka, rootaki iñaaperotantakinari atziripaeni nokameethatzi. Iinja papiitero poñaagakaanteroni notajorenka eeroka, rootaki iñaaperotantenari osheki atziri. ");
INSERT INTO cjoNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ari ikemaeyawitawakarini katziyeeyawiteencharini, inta tee riyoperotawakiro. Ikantagaantashitanaka: —Oñaawaepookitatzi. Paashini kantayiteentsini: —Iñaanatatziiri ronampiri Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ikantziri riraga Jesoshi: —Tee naaka opokashitzi ñaagantsi iyotaantenari: inta eeroka riyotakagaeyawitakimini Tajorentsi otyaantakinari. ");
INSERT INTO cjoNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Iroñaakaroña ikantakowenteri maawaeni theenkantatsiri, ikantziri: “Eeniro pantziro kaari kameethatatsi, aritaki nowashironkaemi”. Iroñaaka eejatzi rookakaakiri Pawa riraga iwinkatharite maawaeni kamaaripaeni eejatzi maawaeni kaari aapatziyana. ");
INSERT INTO cjoNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Rooteentsi rowamagaetena rowatzikakoetena koroshiki roojatzikya nokenkithashiryaakaakari maawaeni atziri, ipokashiteeyenani, ikoyi nowawijaakoteri riroripaeni. ");
INSERT INTO cjoNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Rootaki ikantakiri riraga Jesoshi. Ikamantzitakari tsika ikantyaaka ikamantyaari iinja. ");
INSERT INTO cjoNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ikantawakiri atziri: —Iyotagae Iwaperite Tajorentsi: “Roojatzi ikanteetatyeeyaani Rotyaantanewo Tajorentsi rañe”. ¿Iitaka pikantziri? ¿Iitaka pikanantawori eeroka: “Ari rowamagaetakiri atziritapaentsirika”? ¿Ninkakya irika kamatsineka? ");
INSERT INTO cjoNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Rakanakiri: —Notsipatemi naaka riraga iyotakoperotakaaneeriri Tajorentsi paashini eechonkiini. Paapatziyena iroñaaka. Eerorika paapatziyana eero piyotziri riraga Tajorentsi. Rootaki piyaatantyaari paamariki kaari tsiwakanitatsini. ");
INSERT INTO cjoNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Rootaki paapatziyantanari imatantyaawori reentsitetemi. Roojatzi ojeekantapaakimi pajankaneki noñaani. Roojatzi riyaatantanaka imanapithatanakari. ");
INSERT INTO cjoNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Iñaawitakari osheki atziri itajonkantayitakini riraga Jesoshi omaanta tee raapatziyeeyawakarini. ");
INSERT INTO cjoNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Imonkaatakiro rojankinatakotzitakaririni paerani Iseeyashi riraga kamanantayitzirorini iñaani Tajorentsi, ikantzi: “Nowinkatharite, eero roshekiperotzi aapatziyawakimini rowaga akamanteriri. Iñaawitemi pitajonkante. Omaanta eero raapatziyimi”. ");
INSERT INTO cjoNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Rootaki kaari imatantyaawo raapatziyari Jesoshi. Tema ikantzitakani eejatzi: ");
INSERT INTO cjoNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Riraga Tajorentsi tee ishinetziri riyoperoteri kimitaka tee iñiiri rokiki riraga kaari aapatziyaariri Jesoshi eejatzi tee ishinetziri riyotakayeri rajankaneki kimitaka tee ikenkithashiryaa rajankaneki. Ikantzi Tajorentsi: ‘Iñeekari. Riyotzikari. Rameentanakari. Nowawijaakotzirikari’ ”. Rootaki kaari imatantawo maawaeni kaari aapatziyariri Jesoshi ikenkithashiryaaroña. ");
INSERT INTO cjoNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Paerani iñaakiri riraga Iseeyashi ishipakiryaaki Awinkatharite, impaetzi ikenkithatakotziri. ");
INSERT INTO cjoNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Eejatzi osheki jewatatsiripaeni joriiyopaeni raapatziyawitanakari Jesoshi. Omaanta ithaawantari warijeeyopaeni, rootaki kaari ikanantari inampijatzi: “Naapatziyakari Jesoshi”. Ikenkithashiryaa: “Ikijantanarikari naapatziyari irira, eero ishinetanaana notsipataneeyaari atziri janta piyotaantsiki nopinkathateri Tajorentsi”. ");
INSERT INTO cjoNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Riraga warijeeyopaeni ikowapiintzi iñaaperoeyerini atziripaeni ikameethatzi, tee ikenkithashiryaakoperotari Tajorentsi iñaaperoteririka irirapaeni ikameethatzi. ");
INSERT INTO cjoNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Roojatzi itacheronkawaantetantanaka riraga Jesoshi: —Maawaeni aapatziyanari, tee apatziro naaka raapatziyaperotana, inta eejatzi raapatziyitari otyaantakinari. ");
INSERT INTO cjoNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Maawaeni ñaapiintakinari, iñaapiintzityaari eejatzi otyaantakinari. ");
INSERT INTO cjoNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Tema nopokapaaki jaka kipatsiki, nokimitapaakari ootamentotsi niyotakotakaantyaariri riraga Tajorentsi maawaeni atziri eero eekiro riyaatatyee ijeekanaki tsiteniriki; omaanta imatziro raapatziyana, eero rantapiintanakiro kaari kameethatatsi, inta imonkaatakiro ikowakaakiriri Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Omaanta ninkarika kemayitawitakaworini nokantziri: eerorika ikemijantaperotziro, eero nokantakowentziri naaka. Tee ro nopokantari kipatsikika nokantakowentayiterini atziri, inta nopokantari nowawijaakoteri. ");
INSERT INTO cjoNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Maawaeni theenkakinari kaari aapatziyawori noyenkithari, eenitatsi okantakowenteri iinja. Iroka noyenkithari nokantawitakari: iinja omonkaatapaakyaarikaroña othonkantyaari kipatsi, ari okantakowenteri theenkakinari okaatzi nokantziri. ");
INSERT INTO cjoNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Tee noñaawaetashita. Pawa otyaantakinari, rirotaki kantanari: “Rootaki irokakya piñaawaetapaeri. Irokakya pikantapaeriri”. ");
INSERT INTO cjoNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Riraga aapatziyawori kaminagaantsi rashi Pawa okaatzika nokamantakiriri, ari owañaanakiri ikanteetatyeeyaani ijeeki jenokinta. Tema nomonkaatakiro maawaeni okaatzi ikantakinari Pawa. ");
INSERT INTO cjoNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Rooteentsi nokimoshirewenteeyanakironi Kitejitatsiri Rawijantari Ronampiri Tajorentsi janta Ejiipitoki. Aritaki riyotaki riraga Jesoshi omonkaataka rookantanaawori kipatsika, ipiyantanaari Ashitaririki. Ikantatyeeyaani ineshironkaeyakaeni maawaeni rashiteeyakaeni kipatsijatzika. Iroñaaka ineshironkaperotee, tee ithaawanaki ikamawentee. ");
INSERT INTO cjoNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ari nowaeyani maawaeni notsipatakari Joorashi karyootejatzi, riraga itomi Shimo. Ikenkithashiryaakaakari rajankaneki riraga iwinkatharite kamaaripaeni riraga Joorashi raakaantawityaarini Jesoshi iinja. ");
INSERT INTO cjoNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Riraga Jesoshi riyotaki Iriri iitakiri jewawenteroni maawaeni oetarikapaeni kipatsikika eejatzi jenokinta. Riyotaki eejatzi ipoñaaka Tajorentsiki, rooteentsi ipiyashitaneeri eejatzi. ");
INSERT INTO cjoNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ari rowakagaeyakinani irira Jesoshi, roojatzi ikatziyanaka. Raatonkoryaanakawo iithaari. Rapineethakitanakawo roshewootantari. ");
INSERT INTO cjoNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Roojatzi ijantakawo iñaa tajokira antawo, ikiwanteeyakinawoni noetzipaeni: nashi naari eejatzi paashinipaeni riyotaanewo. Ro roshetantakinawori noetzi roshewootantari. ");
INSERT INTO cjoNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Roowiteenchami ikiwayitzitapaakirimi riraga Peetero, ikantziri: —Rooma eerokataki Nowinkatharite, tee okameethatzi pikiwenawo noetzi naari, inta okameethatemi nokiwemiromi piitzi eeroka. ");
INSERT INTO cjoNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ikantawakiri: —Tee piyotakotziro iroñaaka iroka nantakimiri. Aritaki piyotakiro iinja. ");
INSERT INTO cjoNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ikantziri rirori: —Eerokya pikiwanawokya noetzikya. Ikantawakiri: —Eerorikakya nokiwimiro piitzi, eero akimitawakaa iinja. ");
INSERT INTO cjoNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Roojatzi ikanantakariri rirori: —Nowinkatharite, eero apatziro pikiwenawo noetzipaeni, inta eejatzi pikiwenawo nako, nopoo, maawaeni. Nokoyi akimitawakayaaroña. ");
INSERT INTO cjoNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ikantawakiri: —Eero rapiitziro ikiwakya kaawoshiteenchari. Rapiitziro ikiwiro apaniroeni iitziki. Kiteteeyawitakimini eerokapaeni inta apaani kaari kitetatsi. ");
INSERT INTO cjoNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Riyotakiri Joorashi rirotaki aakaanterini. Rootaki ikanantakari: “Apaani kaari kitetatsi”. ");
INSERT INTO cjoNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ithonkaeyakinani ikiwaeyakinawoni noetzi maawaeni. Roojatzi ikithaatantaawo iithaari. Eejatzi ijeekimoteeyakinani, ikantana: —¿Piyoteeyakinima iroñaaka iitaka nanantayitaworini irokapaeni? ");
INSERT INTO cjoNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Rooma pikantapiinteeyanani: “Iyotaantatsiri”, eejatzi “Nowinkatharite”. Kyaaryootaki iroka pikantakinari. Naaka iyotagaeyimirini. Okameethatzi pipinkathatena. ");
INSERT INTO cjoNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Naaka piwinkatharite, omaanta nokiwakimiro piitzi namitakotantzimiri nokimitakari ponampiri. Ari poshiyakotenawo naaka: pamitakoperotawakaya. ");
INSERT INTO cjoNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Noñaagakimiro inkaaganki tsika pikantya eeroka. Aritaki iroñaaka pikimitawakagaeyanakyaani. ");
INSERT INTO cjoNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Kyaaryootaki iroka nokantemiri. Ronampiri tee ranaakotziri omperatariri. Eejatzi riraga rotyaantanewo eero ranaakotziri otyaantakiriri. ");
INSERT INTO cjoNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Iroñaaka piyotakiro iroka niyotaakimiri, tema rootaki pikimoshiretantyaari pimonkaatakirorika nokowakaemiri nokimoshiryaakaantemiri. ");
INSERT INTO cjoNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Eeniro iroñaaka apaani nokantakoperoteri, tee maawaeni nokenkithatakotzimi. Niyoyagaeyakimini maawaeni, tema niyoteeyakimini. Eenitatsi Iwaperite Tajorentsi tekiraajeeni omonkaatyaata, okantzi: “Riraga owakotakinari nopaani, rirotaki piyankashitenani”. ");
INSERT INTO cjoNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Aritaki nokanteeyakimini tekiraata ragaetena. Piyotantari omonkaataka okaatzi nokantakimiri, aritaki paapatziyakotena naaka riraga Rotyaantanewo Tajorentsi riraga Owawijaakotantatsiri. ");
INSERT INTO cjoNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Kyaaryootaki iroka nokantemiri. Aririka raakameethateetawakiri notyaantanewo, eejatzi naari, raakameethatena. Aririka raakameethatawakina naari eejatzi ikimiteri riraga otyaantakinari raakameethateri. ");
INSERT INTO cjoNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Roojatzi rowashiretantanaka Jesoshi, ikamanteeyanani: —Kyaaryootaki iroka nokantemiri. Eenitatsi jaka aakaantenani. ");
INSERT INTO cjoNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ari naminawakaanaka naaka maawaeni riyotaanewo, tee niyotzi ninkarika kantakotakinari. ");
INSERT INTO cjoNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Naaka riyotaanewo inintaperotana Jesoshi, eenirona naari notziintanakari ichopineeki noñaanatantakari. ");
INSERT INTO cjoNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Rookotakina Peetero, ikantana: —Pojampiteri. ¿Ninka ikenkithatakotzirika? ");
INSERT INTO cjoNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Roojatzi apawo notziitotaperotantanakariri ichopineeki riraga Jesoshi. Nokantakiri: —Nowinkatharite, ¿ninka aakaanteminika? ");
INSERT INTO cjoNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ikantakina: —Aririka nochaantero paa, irika nopakiri, rirotaki aakaantenani. Roojatzi rochaanantanakawo paa, ipakiri Joorashi itomi Shimo karyootejatzi. Ari raawakiro. ");
INSERT INTO cjoNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Roojatzi ikenkithashiryaakaantakariri iwinkatharite kamaaripaeni Joorashi raakaanteri rirori. Riraga Jesoshi riyotzi oetaka ikenkithashiryaari rirori. Ikantanakiri: —Oetarika pikenkithashireeyirini pantero, pimateroota intsipaete. ");
INSERT INTO cjoNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","30","Raantawakawori rowaga paa, rowakawo, roojatzi riyaatantanaka raakaanantyaariri. Rirotaki kempoyaakinariri noorikite maawaeni. Naakapaeni owaeyeencharini jaga tee niyotawakiro ikantakiriri: “Pimateroota intsipaete”. Riyaatantakari, raamaanaka apaanipaeni ikantziri Jesoshi: “Pamanante oyaari akimoshirewenantyaawori Rawijantariri Ronampiri Tajorentsi”. Paashini raamaaka ikanteri: “Piyaate pipashitayityaarini ashironkaenkari”. Niyankitaki tsiteniri ipiyashitanakari. ");
INSERT INTO cjoNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Roojatzi ikamantanakina Jesoshi: —Nopoñaanaka naari jenokinta, natziritapaaki jaka kipatsiki. Rooteentsi kijashitanari raantaneenari. Roojatzi nokamawenteri maawaeni atziri, nopiriinantaneeyari, nopiyantari jenokinta. Tema nokamawenantyaariri aapatziyeeyanarini ipinkathateeyanteenarini naari eejatzi Pawa ikanteri: “Tajorentsi riroperori. Rotyaantakaeri Itomi riraga Jesoshi ikamawentee aari”. ");
INSERT INTO cjoNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Eejatzi ikimitya Pawa, riyotakagaeyerini atziri ipinkathateeyinani naari. Eejatzi ikantakotenari rirori: “Rirotaki notyomi. Rantakiro kameetha maawaeni nokowakaantakariri rantero”. Iroñaaka imatero: eero ijamaneentawo. ");
INSERT INTO cjoNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Iroñaaka, niyotaanewopaeni, rooteentsi nookanteeyaneemirini. Pikowakowaperotana omaanta okimitaka nokantakiri jewatatsiripaeni joriiyopaeni chapinki, eejatzi iroñaaka nokanteeyemini eerokapaeni: “Nopiyantari janta, omaanta eero pimatziroota eerori piyaateeta, tekira”. ");
INSERT INTO cjoNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Paashini nokamineeyemirini iroñaaka: “Pineshironkatawakaeyanikya maawaeni. Nokimitaka naaka noneshironkaeyimini, eejatzi pikimitawakaeyani eeroka, pineshironkatawakaeyanikya. ");
INSERT INTO cjoNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Aririka pineshironkatawakagaeyanikya, aritaki riyotakoeyakimini eeroka maawaeni atziri: eerokapaeni niyotaanewopero”. ");
INSERT INTO cjoNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ikantzi riraga Peetero: —¿Tsika piyaateka, Nowinkatharite? Ikantakiri: —Janta niyaatee, eero pimatziroota poyaatanakina iroñaaka. Iinja aritaki poyaatanakina. ");
INSERT INTO cjoNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ikantziri rirori: —Nowinkatharite, ¿iitarikya kaari nomatantyaawo noyaatemi iroñaaka? Omawitya rowamagaeteerika, aritaki okanta. ");
INSERT INTO cjoNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ikantawakiri: —¿Arima pantero? Kyaaryootaki iroka nokantemi. Tekirani iñiini tyaapa, pikante: “Tee niyotziri Jesoshi”. Okaate 3 pikante. ");
INSERT INTO cjoNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Eejatzi ikanteeyanakinani Jesoshi: —Eero pikenkithashiryaashipiintawo inta pameentyaari Tajorentsi. Eejatzi naari, pameentena. ");
INSERT INTO cjoNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Janta inampiki Pawa eenitatsi oshekini pankotsipaeni. Eero oshekitzimi, ari nokantemimi: “Tee oshekitzi”. Niyaate janta niwetsikaeyapaemini pipanko, pijeekanteeyapaeyaarini eeroka iinja. ");
INSERT INTO cjoNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Aririka nomatemiro pijeekantyaari, ari napiitaatero nopiyashiiyakitemini nagaeyaatemini. Aritaki notsipatapaakimi nojeekinta naari. ");
INSERT INTO cjoNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Piyotzi tsikarika niyaatee. Piyotzi eejatzi tsikarika nokinanaki. ");
INSERT INTO cjoNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ikantziri riraga Tomashi: —Tee niyotzi naaka tsikarika piyaatee. ¿Tsika niyotantyaari tsikarika pikinee? ");
INSERT INTO cjoNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ikantakiri: —Tema naaka oñaayemironi pikinantanakyaari pareetantyaari Pawaki, eejatzi naaka yotaapiinteeyakimironi kyaaryooperotatsiri, naaka añaakagaeyakimirini pikanteetatyeeyaani. Tekatsi pikantya piyaatashiteri Pawa, inta naaka aaneemini. ");
INSERT INTO cjoNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Piyoteeyantakinarinimi naaka piyoteeyakirinimi Pawa eejatzi. Paata piñeena nokamawenteri maawaeni atziri ikimitaaka ikantanari Pawa roojatzi piyoperoteri tsika ikantari rirori. ");
INSERT INTO cjoNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ikantziri riraga Jiripi: —Nowinkatharite, poñaagaeyenarini Piri; ari okaatapaaki, eero napiitaneemi nojampikowentaneeri. ");
INSERT INTO cjoNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ikantakiri: —Paerani notsipateeyakimini. ¿Tekirama piyotana? Maawaeni ñaakinari, kimitaka iñaakiri Pawa rirori. ¿Iitaka pikanantanari iroñaaka: “Poñaayenari piri”? ");
INSERT INTO cjoNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Tekirama piyotzimate nokimitari Pawa? Eejatzi ikimitana rirori. Tee nokantashita. Ikimitana irira, rirotaki matakaanawori notajonkantzi. ");
INSERT INTO cjoNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Tema nokantzimi nokimitari irira. Eejatzi ikimitana naari. Paapatziyawo iroka nokantakimiri. Eerorika pikoyi paapatziyashitana, ari piñaaperoeyakinani notajonkantaki, tema rootakikya paapatziyantanakinari. ");
INSERT INTO cjoNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Eejatzi ikanteeyanakinani riraga Jesoshi: —Rootaki kyaaryootaki nokamantemiri. Maawaeni aapatziyenani ikimiteeyanani, eeniroka nantziro naaka eejatzi ikimitya rirori rantaperotero. Tema niyotaakiri atziri rootaki raapatziyantakinari apaanipaeni. Ari niyaateeta Pawaki, eejatzi opoki rowaga Ishire Tajorentsi amitakotemini. Roojatzi pikamanantyaari atziri maawaeni nokantakimiri naaka, rootaki raapatziyantayitenarini oshekini. ");
INSERT INTO cjoNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Aririka paapatziyanakina, aritaki nomatakimiro oetarika pikowakoteriri riraga Pawa. Iroka nokantemiro ikanantyaari maawaeni atziri iñaaperoteri Pawa. ");
INSERT INTO cjoNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Paapatziyaperotakinarika, pimatero pinetheena Naaka oetarikapaeni, aritaki nomatakimiro pikantenari. ");
INSERT INTO cjoNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Pinintaperotanarika, pikemijantaperoeyenani oetarika nokaminagaeyemirini. ");
INSERT INTO cjoNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Naaka amanerini Pawa rotyaanteeyemironi paashini Amitakoeyemirini. Aritaki imatakimiro. Roojatzi okantyaani otsipateeyemini roori: ");
INSERT INTO cjoNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","rootaki rowaga Ishire Tajorentsi iyotayemironi maawaeni kyaaryootakotatsirini Tajorentsi. Omaanta tee riyoteeyironi irowa kaari aapatziyanari, rootaki kaari opokashiteeyantaririni otsipateeyarini. Omaanta aritaki kijokiro owanteeyakimirini eerori. Rootaki piyoteeyantakaworini eeroka. ");
INSERT INTO cjoNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Nopiyaneerika Pawaki, eero nookimi apaniroeni, ari nopiyashiiyemini Noshireki. ");
INSERT INTO cjoNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Rooteentsi niyaate. Eero rapiitana iñeeyanakinani kaari aapatziyanari, inta piñeeyenani eeroka. Ashi noyiro nañi, rootaki pañaanteeyanakarini eerori: pikantyaani pijeeki jenokinta. ");
INSERT INTO cjoNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Aririka nopiriintanee, aritaki piyoteeyanakini nokimitari Pawa. Tema eejatzi pikimiteeyenani eeroka, eejatzi nokimiteeyimini naari: akimitawakaeyani. ");
INSERT INTO cjoNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Maawaeni yotawakirori nokaminaakiriri, ikemijantaperotakirorika eejatzi, rirotaki nintashireperotanari. Pawa aritaki inintashireperotakiri nintashireperotanari. Eejatzi naari aritaki nonintashiretakiri rirori. Niyotakaaperoteri tsika nokanta. ");
INSERT INTO cjoNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Eenitatsi janta paashini Joorashi, kaari karyootejatzi. Rojampitziri irira, ikantziri: —Nowinkatharite, piyotakaaperotakina naaka tsika pikantari. ¿Iitaka kaari piyotakaantari kaari aapatziyemini tsikarika pikantari? ");
INSERT INTO cjoNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ikantakiri: —Pinintaperotana eeroka omaanta tee inintaperotana riraga kaari aapatziyanari. Pinintaperotanarika, pikemijantaperotero nokantzimiri, roojatzi inintaperotantemiri riraga Pawa. Roojatzi nopokashiiyakimini pishireki, kijokiro nowantemiri Naaka eejatzi Pawa. ");
INSERT INTO cjoNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Omaanta kaari nintashiretanari, eero ikemijantaperotziro nokantziri. Iroka nokantakimirika, kaari nashi nokantzimiri naari, inta ikantziri otyaantakinari. ");
INSERT INTO cjoNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Eenironaka notsipateeyimini, aritaki nokamantzitakimiro omaanta tekiraata pikemaperotana. ");
INSERT INTO cjoNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Riyotzi Pawa paapatziyakina, rootaki rotyaanantemirori amitakotantatsiri roori Ishire Tajorentsi. Iyotakaemiro oetarikapaeni. Okenkithashiryaakaapaakimiro maawaeni nokantzimiri. Rootaki kenkithashiryaakayemironi eerokapaeni maawaeni nokantakimiri. ");
INSERT INTO cjoNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Eekiro riyaatatyee ikantanakina riraga Jesoshi: —Rooteentsi niyaate. Nokimoshiryaanaki naaka tee nowashiretakota. Nokowaki pikimitena pikimoshireeyanakini eeroka: tema naaka pikimoshirewente. Eero imatziro atziri roemoshirenkemi. Omaanta naaka oemoshirenkemini. Aririka eekiro piyaatatyee pikenkithashiryaakotena naaka aritaki nojeekakagaeyakimini kameetha. ");
INSERT INTO cjoNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Aritaki pikemakiro nokanteeyakimirini rooteentsi niyaate, eejatzi nopiyee. Aririka pinintaperotena kameetha pikimoshirewentena niyaate Pawakinta. Aritaki riraga Pawa ranaakotakina. ");
INSERT INTO cjoNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Iroñaaka nokamantzitakimiro tekirani niyaatee. Aririka piyotaki omonkaataka nokamantakimiri, paapatziyaperoeyantenarini. ");
INSERT INTO cjoNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Eechonkiini napiitzimi nokenkithatakaakimi. Awotsikitapaaki jewatatsiri maawaeni kaari aapatziyanari: rirotaki iwinkatharite kamaaripaeni. Tekatsi ikantya rirori reewawentena naaka. ");
INSERT INTO cjoNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Omaanta noshinetari rowamaena oyaatziriri rashi. Irira Pawa ikowakaakinari nokamawenteri maawaeni atziri. Rootaki nokanantariri riyoteeyantanakaworini atziri nonintaperotziri riraga Pawa, eejatzi nantapiintziniri oetakarika ikowakaakinari. Pikatziyanaki. Thame aatee. ");
INSERT INTO cjoNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Ikantawitanaana riraga Jesoshi inta eekiro riyaatatzi riyotaana. Iroka paashini roshiyakaawentakinari irira: —Naaka kimitawori owaatotha oowa. Eeroka kimitawori otha. Rirotaki Pawa thamaetakotzirori. ");
INSERT INTO cjoNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Aririka otha kaari kithokitapaentsiri riraga thamaetakotzirori ipejayitzironi, eejatzi rookiro. Omaanta rowaga kithokitatsiri rowameethatakotakiro okithokiperotantanakyaari. Kimitaka iroka, Pawa rantakimiro eerokapaeni aapatziyanari. Raapatziyaperotakaantemiri, ikameethatakaaperotakimi. ");
INSERT INTO cjoNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Iroka niyotagaeyakimirini, rootaki owameethashireeyakimirini Ishire. ");
INSERT INTO cjoNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Kijokiro powaeyenani. Aritaki naari kijokiro nowaeyemini. Otha oowa aririka ochewaryaanaki, eero omataa okithokite, rooma ari okamae. Aritaki pikimiteeyaworini eerori. Eerorika kijokiro powaeyenani, eero pimatziro piyoteeyerini kameetha paashini atziri raapatziyantenari. ");
INSERT INTO cjoNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Naaka kimitawori owaatotha. Eerokapaeni pikimitawo othapaeni. Maawaeni kijokiro oyenani rirotaki mateeyanakirorini oetarika nokowakaakiriri. Tema kijokiro noyeri naari. Omaanta aririka pintareeyanakinani, eero pantzimaetawo nokowakaakimiri. Rootaki okameethatantari kijokiro powanakina naaka. ");
INSERT INTO cjoNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Riraga kaari kijokiro owana, ari ikimitakaanteetakyaari otha oowa ipejeetero, thatzik. Roojatzi aririka ojampishitanaki, rookaetero paamariki, pok, otaya, tzininini. ");
INSERT INTO cjoNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Roojatzirika kijokiro powaeyanakinani eejatzi aririka paapatziyaperotyaawo nokantzimiri, pikantena oetarika pikowayitzirini: aritaki nomatakimiro. ");
INSERT INTO cjoNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Aririka pimatayitakironi oetarika nokowakayemiri, riyoperotemi maawaeni atziri eerokaperotaki niyotaanewopaeni. Aritaki iñaaperoteri atziri riraga Tajorentsi ikameethatzi. ");
INSERT INTO cjoNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Iroka eejatzi ikanteeyanarini riraga Jesoshi: —Kimitaka inintashiretana Pawa osheki, eejatzi naaka nokimiteeyimini, nonintashireeyimini osheki. Kijokiro poyena, rootaki anintaperotawakagaeyantyaarini osheki. ");
INSERT INTO cjoNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Pikemijantaperoterorika nokaminagaeyimirini, aritaki nokantanakimiri nonintaperoeyanakimini naaka. Nokemijantaperotziro ikantakinari riraga Pawa, roojatzi ikantani inintaperotakina. ");
INSERT INTO cjoNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ashi noyiro nokimoshiryaanaki naari. Ro nokamanantzimirori iroka pikimoshirewenantyaawori eeroka. Nokowaki pikimoshireperotanaki maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Iroka nokaminaantemiri: tema nonintashireeyimini naaka. Rootaki nokaminaantakimiri: pikimitaaga eerori, pinintaperotawakagaeyani. ");
INSERT INTO cjoNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Riraga neshironkaperotziriri atziri, ikamawentakiririka, rirotaki nintashireperotziriri kameetha. ");
INSERT INTO cjoNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Aririka pimateeyakironi nokantakimiri, eerokaperotaki notsipamintharipero. ");
INSERT INTO cjoNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Eero noeteeyakimini iroñaaka nonampiri, tee riyotzi onampirentsi oetarika rantziri onampitariri. Omaanta niyotakagaeyakimini okaatzi ikamantakinari riraga Pawa, rootaki atsipaminthatawakaantaperotakari iroñaaka. ");
INSERT INTO cjoNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Tee eerokapaeni yoyeenani; inta naaka yoyayitakimirini eerokapaeni. Notyaantakimi panantyaawori oetarika nokowakaayitemirini. Eero patsipetawo oetarika pantayitenarini. Pikemijantaperotenarika, aritaki imatakaakimiro riraga Pawa oetarika pikanteriri. ");
INSERT INTO cjoNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Napiitanakimiro iroka nokaminagaeyakimini: pinintawakagaeyani maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","19","Eekiro riyaatatzi ikantakina Jesoshi: —Riraga kaari aapatziyanari ineshironkatawakaaka. Aririkami pikimityaarimi eeroka, aritaki ineshironkatakimimi eeroka. Omaanta tee pikimitari. Niyoyeeyakimini maawaeni, rootaki roonantakimiri. Kyaaryo, roonantakimiri riraga kaari aapatziyanari, omaanta nokowanaki piyoperote ritawo roonana naari. ");
INSERT INTO cjoNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Pikenkithashiryaakiro nokantakimiri chapinki: “Riraga ronampiri tee ranaakotziri onampitariri”. Aritaki ikijakina. Eejatzi ikimitemi eeroka, ikijeeyemini. Tee ikemijantaperotziro nokanteeyawitakaririni. Eejatzi eeroka, eero ikemijantaperoeyimini pikamanteeyawityaaririni eerokapaeni. ");
INSERT INTO cjoNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Rirotaki Tajorentsi otyaantakinari. Omaanta tee riyotziri maawani rirori, rootaki ikijantemiri. Tema piyotaakowitakinari riroripaeni. Rootaki ranantawori iroka. ");
INSERT INTO cjoNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ari nopokashitawitakari, nokenkithatakaawitakari. Eeromi nopokashitzirimi eero eenitatsimi iroñaaka rantani. Omaanta iroñaaka tekatsi okantya irirapaeni ikantero: “Tee niyotziro nantziro kaari kameethatatsi”. ");
INSERT INTO cjoNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Riraga oonakinari roonakari Pawa rirori. ");
INSERT INTO cjoNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Eero eeniromi rantani, eeromi iñaawitakina notajonkawentzimotakirimi. Nomatayitakironi kaari imatayitzini atziri. Omaanta iñaawitakina notajonkantzi, eekiro roonatyaana. Eejatzi roonitakari riraga Pawa. ");
INSERT INTO cjoNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Aritaki ikantari maawaeni. Tema monkaatapaaka iroka rojankinakotziteetakaririni rirori Iwaperiteki Tajorentsi: “Roonashiitana maawaeni, tekatsi nantawitya”. ");
INSERT INTO cjoNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ari notyaantakimiro eerokapaeni Amitakotemini, rowaga Ishire Tajorentsi. Opoñaakya Pawaki, kameetha iyotaapaemiro kyaaryooperotatsiri. Aririka opokapaaki okantakotapaakina naaka. ");
INSERT INTO cjoNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Eejatzi eerori, okameethatzi pikantakotakina naari eejatzi. Tema eeroka tsipatapiintakinari paerani nitantakawori niyotaakotakiriri atziripaeni. ");
INSERT INTO cjoNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Eekiro riyaatatzi ikantana riraga Jesoshi: —Nokoyi eero pipakaero paapatziyana, rootaki nokanantzimirori maawaeni iroka. ");
INSERT INTO cjoNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Paata pikowaeyawityaani pikaaterimi ajoriiyotzinkarite janta piyotapiintaantsiki inta roepiyawakimi. Rowamaemi eejatzi. Aritaki riraga kijakimiri ikenkithashireeya rantziniri Tajorentsi ikowakaakiriri. ");
INSERT INTO cjoNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Tee riyotziri riraga Pawa, eejatzi naaka, tee riyotana, rootaki ranantemirori iroka. ");
INSERT INTO cjoNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Aririka omonkaatakya iroka nokantakimiri, aritaki pikenkithashiryaanakiro nokantakimikya rootaki iroñaaka nokanantzimirori. Paerani notsipatzimini, rootaki kaari nokanantzimini, omaanta rooteentsi niyaatee, rootaki nokanantaperotakimiri. ");
INSERT INTO cjoNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ikantanakina riraga Jesoshi: —Iroñaaka niyaate otyaantakinariki. Omaanta tee pojampitana: “¿Tsika piyaateka?” ");
INSERT INTO cjoNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Iroñaakaroña nokantakimi, rootaki petakoperotantanakari maawaeni pajankaneki. ");
INSERT INTO cjoNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Kyaaryooperotaki iroka nokantakimiro. Okameethatzimotzimi niyaatee. Eerorika niyaatee eero opokashitzimi Amitakoperotemini rowaga Ishire Tajorentsi. Aririka niyaatanaki, aritaki notyaanteeyapaakimironi Noshire. ");
INSERT INTO cjoNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Areetapaakimirika, ari oñaanashiretapaakiri maawaeni kaari aapatziyanari okanteri: “Eeroka antayitzirorini kaari kameethatatsi”. Oñaanashiretapaakiri maawaeni ikamawenterira Jesoshi iñaaperotantariri Tajorentsi ikameethatzi, eejatzi rowameethatantyaariri. Eejatzi oñaanashiretapaakiri maawaeni tsika ikantyaari Tajorentsi ikantakowenantyaariri maawaeni kaari aapatziyanari. ");
INSERT INTO cjoNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Tema tee raapatziyana rootaki rowashironkaawentyaari iinja kaari kameethatatsi. Eejatzi rowaga Ishire Tajorentsi okanteri: “¿Iitaka kaari paapatziyantari Jesoshi?” ");
INSERT INTO cjoNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Maawaeni kaari aapatziyanari tee riyotakoperotziri Pawa Tajorentsi iñaaperotakotantanari naaka. Omaanta aririka opokapaaki rowaga Ishire Tajorentsi oñaanashiretapaakiri maawaeni atziri nokamawenteri eejatzi nopiyanteeyari Pawaki, rootaki raapatziyantenaririka iñaaperoteri rirori ikameethatzi. ");
INSERT INTO cjoNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Eejatzi opokashitantapaakari Ishire Tajorentsi iyotakagaeyapaerini maawaeni theenkantatsiri ari ikantakotanteri Tajorentsi, rowashironkagaeyerini. Tema rirotaki rirori rowashironkagaeyerini Jatanaashi riraga iwinkatharite kamaaripaeni, eejatzi rirotaki jewatatsiri maawaeni theenkakinari jaka kipatsiki. ");
INSERT INTO cjoNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Tekira eeniro osheki nokamantemirimi omaanta eero pimatziro piyoteeyawakironi iroñaaka. ");
INSERT INTO cjoNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Kyaaryooperotaki maawaeni iyoteemiri Ishire Tajorentsi. Aririka opokapaaki, iyotakaapaemiro maawaeni kyaaryootatsiri. Eero iyotaashita apaniroeni. Oetarika okemakinari naaka niyotaantziri aritaki iyotaapaemi maawaeni. Iyoteemi oetarika awijatsini iinja. ");
INSERT INTO cjoNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Aawakironi noyenkithari roojatzi iyotaantawakimi eeroka, tema apatziro okamantemiro maawaeni iroka noyenkithari. Tema ari oñaaperoteena. Tema apatziro okamantakotana naaka. ");
INSERT INTO cjoNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Maawaeni ikantayitanarini Pawa, nokantayitakironi naaka, rootaki nokanantakimiri maawaeni: “Iyotaantemiri rowaga Ishire maawaeni iroka nokantziri”. ");
INSERT INTO cjoNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Ikantanakina Jesoshi: —Paata eero piñaana. Paashini paata ari papiitero piñeena. Ikantakota Jesoshi ikamawentee eejatzi ipiriinantaneeyari omaanta tee nokemaperotziri. ");
INSERT INTO cjoNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Roojatzi nokantagaantawakaeyakani: —¿Tsika okantaka iroka ikantakaeri? “Paata eero piñiitana. Paashini paata ari papiitena piñeena”. Ikantzi eejatzi: “Niyaatee Pawaki”. ");
INSERT INTO cjoNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Iitakakya ikanantari: “Paata”? Tee ayotakotawakiri oetarika ikantakaeri. ");
INSERT INTO cjoNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Riyotaki Jesoshi nokamantawakaaka. Riyotaki nokowawitari nojampiterimi. Ikantanakina: —¿Pojampikowentawakaanakawo nokantakimiri? “Paata eero piñaana. Paashini paata papiitena piñeena”. ");
INSERT INTO cjoNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Kyaaryootaki iroka nokantemiri. Ari piraakotanakina maawaeni, powashiretanakya. Omaanta kimoshirewitachari maawaeni kaari aapatziyanari. Powashirewitakya eerokapaeni, omaanta ari papiitero pikimoshiryaanee. ");
INSERT INTO cjoNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Aririka omonkaatakya oeyowantyaariri otomi tsinani, okemaatsitakari. Ikoñaatantakari eentsite, tee okenkithashiryaanaka okemaatsitakari, inta okimoshirewentziri riraga otomi. ");
INSERT INTO cjoNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Aritaki pikimitakari iroñaaka eerokapaeni, powashiretawitaka nokamantari. Omaanta aritaki nopiriintanee napiitero noñaaneemi. Rootaki pikimoshireeyantanakarini, tekatsi owashiretakaaneemini eeroka. ");
INSERT INTO cjoNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Aririka nopiriintanee, roojatzi piñaantawaena eero pikowanaki pojampitena kyaaryootaki nokantemiri. Paerani nojeekawitani janta Pawaki roojatzi nopokantakari jaka kipatsikika eejatzi nopiyimaetaneeya Pawaki. Kyaaryootaki iroka nokantemiri: aririka paapatziyena, ari ramitakotemi Pawa oetarika pikanteriri. ");
INSERT INTO cjoNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Paerani tekira paapatziyanani, pikenkithatakaeyirini Pawa omaanta tee pikenkithatakoeyanani naaka. Iroñaakaroña pamanakotenaata roojatzi ikemantakimiri, ipantemiri okaatzi pikowakotanari pikimoshireeyantanakyaarini kameetha. ");
INSERT INTO cjoNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Eejatzi ikantanakina riraga Jesoshi: —Ari noshiyaakaawentapiintzimironi oetarika, omaanta paata eero napiitziro noshiyaakaawenteemiro. Inta okameethatzi nokamantakoperoteri Pawa, eero nomanapithatzimiro. ");
INSERT INTO cjoNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","27","Iinja eero pikenkithashiryaa pikantena naaka: “Nowinkatharite, pamaneri Pawa nokoyi ramitakotena”. Eeroka nintashiretakinari. Paapatziyena kyaaryo nopoñaaka Pawaki, rootaki inintaperotantakimiri irira Pawa. Ari ineshironkaperoeyakimini, rootaki ramitakotantemiri koetyeemotzimiri maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nojeekawitani riroriki, roojatzi nopokantakari kipatsikika. Iroñaaka nookaneero kipatsika, nopiyashitaneeri Pawa. ");
INSERT INTO cjoNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Nokantziri naakapaeni: —Iroñaakaroña pikamantaperotakinawo. Tee poshiyakaawentanawo. ");
INSERT INTO cjoNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ari tekirani nokantzimini, piyotzi oetaka nokenkithashiryaakari. Iroñaaka niyoteeyakini maawaeni pithotyaakiro piyotziro maawaeni, rootaki nokimoshiryaantakari pipoñaaka Tajorentsiki. Tekatsi iroñaaka nojampiteemiri. ");
INSERT INTO cjoNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ikantawakiri Jesoshi: —¿Kyaaryooma paapatziyaperotakina iroñaaka? ");
INSERT INTO cjoNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Rooteentsi nokemaatsitantyaawori, ari nominthaagakaantakimi, piyaatanaki eeroka pinampikipaeni. Pookaeyanakinani apaniroeni. Aritaki rootzimateentsi omonkaatapaakyaaroña. Inta tee naaka apaniroeni, kijokiro rowana riraga Pawa. ");
INSERT INTO cjoNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ro nokamanantzimirori iroka piweshiryaantyaari. Aritaki piweshiryaawentakina. Jaka kipatsikika rowashironkaetemi, omaanta piweshireeyanakyaanikya. Nanaakotakiri maawaeni jeekatsiri kipatsikika, nopinkathariperotzi naaka, notsipatemi. ");
INSERT INTO cjoNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ari okaatapaaki maawaeni ikanteeyakinarini Jesoshi, roojatzi raminantanaka jenokinta, ramanantanakari Iriri, ikantakiri: —Pawa, monkaatapaaka kitejiri nokamantyaari. Rooma naaka Pitomi. Paerani akashiyeeyakawoni nokamashiteri atziripaeni, pipiriinantaanari nokamawitakaga rootaki piñaaperotantariri maawaeni atziri ikameethatzi raapatziyantenari naaka eejatzi nowañaakiri ikantyaani ijeeki jenokinta atsipatawakaantyaari aaka. Iroñaaka pamitakotena nomonkaatapaakiro maawaeni nokemaatsiwenantyaariri. Ari nowañaakiri maawaeni aapatziyanari ipinkathatanteeyemirini eeroka. ");
INSERT INTO cjoNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Tema ari piitakina riraga pinkathariwenantatsiri maawaeni jeekatsirika kipatsiki, rootaki nomatantawori nañaakagaeyeerini maawaeni piyoyagaeyakinarini nashityaari. Ro piyoyaantakariri ikanteetatyeeyaani rañagaeyeeni itsipateeyeeni. ");
INSERT INTO cjoNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Eeroka Tajorentsi apintzi. Kameetha riyoteeyemini atziri maawaeni. Eejatzi kameetha riyote naaka potyaantanewo: tema naaka Jesokirishito. Maawaeni riyoperotena ikanteetatyeeyaani rañee jenokinta. ");
INSERT INTO cjoNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Jaka kipatsikika nantakimiro maawaeni pikowakaakinari, rootaki nopinkathatakaantakimiriri atziripaeni. ");
INSERT INTO cjoNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Paerani, Pawa, tekirani awetsikironi kipatsi, pitsipatanani janta jenokinta apinkathariiyini. Iroñaaka papiitero pikimitakagaena eejatzi akaate apinkathariiyeni. ");
INSERT INTO cjoNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ari eekiro riyaatatzi ikantziri Ashitariri: —Irika atziripaeni kipatsijatzi maawaeni pashitakari. Pikantakina: “Pikempoyaanakinari”. Ari niyotakaakiri maawaeni tsikarika pikantari. Raapatziyaperotawakawo maawaeni piyoyaakiri. ");
INSERT INTO cjoNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Iroñaaka riyoteeyanakimini eeroka itaperotawori piyotagaeyanakinani maawaeni okaatzi niyotagaeyakiririni. ");
INSERT INTO cjoNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Maawaeni piyotaakinari, nokamantakiri niyotaanewopaeni, niyotaaperotakiri maawaeni. Raapatziyakawo rajankaneki. Rootaki riyotakotantakinawori kyaaryo nopoñaakanta jenokinta eejatzi eeroka otyaantakinari. ");
INSERT INTO cjoNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","10","Namanakoeyakarinika irikapaeni. Tee namanakoeyarini irirapaeni kaari aapatziyanari inta apatziro irika nokempoyaakimiri. Tema eeroka ashitariri maawaeni irika, eejatzi pashitakaakinari naari maawaeni. Tema ashiteeyanakarini maawaeni, rirotaki ashi. Raapatziyana maawaeni, rootaki ipinkathatantanari. ");
INSERT INTO cjoNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Eero eekiro niyaatatyee nojeekanaki kipatsikika, omaanta irikakya jeekaneentsini maawaeni jaka, omaantakya naakakya piyashitaneemini. Pawa, eeroka riroperori. Tema eekiro piyaatatzi pitajonkantzi. Iroñaaka eeroka aminaneerini pitajorenkaki, ikimitanteeri. Nokowaki imonkaatawakaya ikimitakae aaka amonkaatawakaaka. ");
INSERT INTO cjoNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Notsipatanteeyakaririni maawaeni, tema pimatakaakina, rootaki nomatariri nokempoyaantakariri. Naminakowentakiri maawaeni; tekatsi ashironkaachani, inta apaani rashironkaeya riraga Joorashi, rirotaki jatatsini paamariki kaari tsiwakanitatsini. Aritaki omonkaatakya okantakotzirini jankinatacharini Piwaperite paerani. ");
INSERT INTO cjoNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","14","Niyotaakiri riroripaeni pikantanari, rootaki iroñaaka ikijantanakariri maawaeni kaari aapatziyanari. Ro ikijantakariri, tee ikimitarikya. Ikimitana naari riraga niyotaanewopaeni nashi, tee nokimitari naari kaari aapatziyanari. Iroñaaka nopiyashitaneemi. Tekiraata eenirona nojeeki kipatsikika, nokantziri riroripaeni maawaeni piñaani, ro nokimoshireperotakaantyaariri maawaeni, ikimitenaata naari nokimoshiretzi. ");
INSERT INTO cjoNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Tee namanatziimi: “Paapithateri kipatsiki”, inta apatziro nokantzimi: “Pikempoyeeri eero imatantari iwinkatharite kamaari rantakayeeri oetarikapaeni”. ");
INSERT INTO cjoNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Irikapaeni tee ikimitari theenkantatsiri, ikimitaakina naaka: tee nokimitari theenkantatsiri. ");
INSERT INTO cjoNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Pinashityaari riroripaeni, piyotakagaeyerini kyaaryooperotatsiri, ikyaaryoowentemiro maawaeni pikowakagaeyiririni. Piñaani rootaki kyaaryooperotatsiri. ");
INSERT INTO cjoNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Potyaantakina niyaatashitantariri atziripaeni nokenkithatakagaeyirini. Eejatzi naari nokimitakari notyaanteeyerini riyaatashitantyaariri atziri maawaeni kipatsiki ikenkithatakagaeyerini. ");
INSERT INTO cjoNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Nokyaaryoowentemiro maawaeni pikowakaakinari: tema nokamawenteri riroripaeni, riyoteeyantyaaworini ikyaaryoowenanteeyemirorini oetarika pikowakaakiriri. ");
INSERT INTO cjoNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Iroka eejatzi ikantziriri Jesoshi Ashitariri: —Tee riro namanakotari apatziro ayotaanewoka jaka; inta eejatzi namanakotari maawaeni riraga raapatziyakagaeyaaripa: riraga aapatziyeeyanarini iinja. ");
INSERT INTO cjoNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Nokowakikya ikimitawakaanakyaaroña maawaeni. Tema akimitawakaaka, Pawa, atsipatawakaaka aaka. Eejatzi nokowaki ikimitee aaka maawaeni riraga aapatziyanari, roojatzi riyotantyaawori atziri kyaaryo potyaantaperotakina. ");
INSERT INTO cjoNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Pitajonkakowentakina nokimitantakimiri eerori, eejatzi notajonkakowentakirini maawaeni rirori ikimitawakaantyaari. Imonkaateeyakaeni aaka, akimitawakaaka. ");
INSERT INTO cjoNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ikimitana naari. Nokimitzimi eerori. Rootaki ikimitawakaaperotantyaari maawaeni aapatziyanari, roojatzi riyotantyaari maawaeni atziri potyaantakina, eejatzi pimonkaatakagaeyakinarini naaka eejatzi riraga aapatziyanari, pinintaperoeyanani. ");
INSERT INTO cjoNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Tekirani ojeekini kipatsi, tema pinintaperotanani, rootaki piitantakinari naari, nopinkathariwenteri atziri. Iroñaaka, Pawa, nokowaki itsipateeyenani iñaantenari nopinkathaperotanaki. Tema pikantana: “Pikempoyeeyenarini maawaeni”, aritaki nomatakimiro. ");
INSERT INTO cjoNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Pikameethaperotaki, Pawa. Tee riyotzimi maawaeni kaari aapatziyanari, omaanta niyotzimi naari. Eejatzi riyoteeyakimini irikapaeni potyaantakinari, ");
INSERT INTO cjoNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","niyotakagaeyakirini tsikarika pikantari eerori. Aritaki napiitakiniri niyotakaaperoteri, pinintaperotantariri, pikimitakaantenari naari pinintashireperotana. Eejatzi ikimiteeyakinani maawaeni. Ari okaatzi. Rootaki ikantziriri Jesoshi Ashitariri. ");
INSERT INTO cjoNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ipakaanakiro Jesoshi ikenkithatakaeri Ashitariri roojatzi riyaatakaantanakina: Jesoshi, eejatzi naaka maawaeni riyotaanewo. Noerinkanaka nomontyaanakawo piryaajanteniri iitachari Sherooni. Notonkaanaki roojatzi nareetantapaaka Oriiwomashiki. Nokyaapaaki. ");
INSERT INTO cjoNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Aritaki janta riyaatakaapiintanakina Jesoshi, rootaki riyotantari riraga Joorashi, riraga aakaanterinira. ");
INSERT INTO cjoNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","5","Riraga jewatayitatsirini ñaanakowenantatsiri Tajorentsipankoki eejatzi warijeeyopaeni rotyaantawakiri joraaropaeni eejatzi waariryaapaeni. Reewatapaakiri riraga Joorashi. Ramapaaki ootamentotsipaeni, oorenantyaaripaeni, rompojamentopaeni eejatzi; ipokashitapaakiri riraga Jesoshi maawaeni. Riyotaki irira iitaka ikanteriri. Riyaatanaki itonkiyotawakari, ikantawakiri: —¿Ninka paminirika? Rakapaakiri: —Riraga Jesoshi najareetejatzi. Ikantawakiri: —Naakataki. ");
INSERT INTO cjoNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ikanantawakariri riraga Jesoshi: “Naakataki”, roojatzi ipiyantanakawo itapiiki. Ityaapaaki maawaeni kipatsiki, tereei. ");
INSERT INTO cjoNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Rapiitawakiri: —¿Ninka pikowaperotzirika? Ikantawakiri: —Riraga Jesoshi najareetejatzi. ");
INSERT INTO cjoNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ikantziri: —Tema nokantakimi: “Naaka Jesoshi”. Naakarikakya pikoyi, pishineteri riyaateeta irikapaeni notsipatakarika. ");
INSERT INTO cjoNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Omonkaatantapaakawori ikantakiriri Jesoshi Ashitariri: “Irika pikantakinari: ‘Pikempoyeenari’, tekatsi ashironkaachani”. ");
INSERT INTO cjoNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Roojatzi Peetero inojakiryaantanakawo ichekamento. Ithatziitawakiri ronampiri Iwinkatharite ñaanakowenantatsiripaeni, omaanta ithatziitashitawakari ikempita rakojanorikitzirika. Iwaero onampirentsi Maariko. ");
INSERT INTO cjoNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Roojatzi ikanantariri riraga Jesoshi rirori: —Poepiyero pichekamento poyaankaero. Rootaki ikowakaakinari Pawa ragaetena nokemaatsitawenantyaariri atziri. Eero nothañaapithatari. ");
INSERT INTO cjoNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Roojatzi ragaeyantakarini riraga Jesoshi. Rirotaki agaeyanakiririni joraaropaeni, iwinkatharite joraaropaeni, waariryaapaeni. Roojatzi roojotantanakari. ");
INSERT INTO cjoNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ritapaentawo raanakiniri Aanashiki. Rirotaki rikonkiri Kaejashi riraga iwinkatharite ñaanakowenantatsiri iroñaaka. ");
INSERT INTO cjoNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Irika rirotaki kantakiriri jewatatsiripaeni joriiyopaeni: “Okameethatzimotzimi ikameeta shiramparinta apaani, rowawijaakotantyaariri maawaeni atziripaeni eero rowamaeri oroomajatzi”. ");
INSERT INTO cjoNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Peetero rirotaki oyaatakowentawitanakariri riraga Jesoshi, notsipatari naaka. Riraga iwinkatharite ñaanakowenantatsiripaeni riyotana naaka rootaki ishinetantanari naaka nokyaantapaaka niyankiiteki ipankoki, notsipatapaakari riraga Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Omaanta riraga Peetero ikatziyapaaka ashitakontsikira jantakirowa. Niyowanee inkokironta, nokantapaakiro shentzirori ashitakontsi: —Pishineteri irira ikye. Okantana: —Jee, ari. Roojatzi ikyaakaantapaakinari riraga Peetero. ");
INSERT INTO cjoNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Rowaga onampirentsi okantawakiri: —¿Kaarimima eerori riyotaanewo Jesoshi? Ikantziro: —Kaarina. ");
INSERT INTO cjoNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Okatsinkaetyaaki. Roeshitaka paamari onampirentsipaeni, eejatzi waariryaapaeni. Rakitsiiyakani osheki paamariki. Eejatzi riraga Peetero itsipatapaakari maawaeni rakitsiiyapaakani. ");
INSERT INTO cjoNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Riraga iwinkatharite ñaanakowenantatsiripaeni rojampitakiri Jesoshi, ikantakiri: —¿Ninka yotaapiintziririka? ¿Oetaka piyotaapiintziriri maawaeni? ");
INSERT INTO cjoNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ikantawakiri rirori: —Ikemakina maawaeni atziri niyotaantziri. Niyotaantapiintzi janta ipiyotapiintanta joriiyopaeni. Eejatzi niyotaantapiintzi jaga Tajorentsipankoki. Tekatsi nomanapithatziri atziri. ");
INSERT INTO cjoNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Iitaka pojampitantanari naari? Pojampiteri irirapaeni kemakinari oetarika nokantakiriri. Riyotakiro riroripaeni. ");
INSERT INTO cjoNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Roojatzi ipajapootantanakariri apaani waariryaa katziyeenchari jaga. Ikantziri: —¿Arima apiyathatakyaari iwinkatharite ñaanakowenantatsiri? ");
INSERT INTO cjoNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ikantawakiri: —Teerika kyaaryooperotatsiri nokantakiriri, piyotakayenawo. Rooma okyaaryootzirika nokantakiriri, ¿iitaka pipajapootantanakinari? ");
INSERT INTO cjoNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Rootaki riraga Aanashi rotyaanantakariri waariryaa raaneeri Jesoshi oojoteencharira janta Kaejashiki. ");
INSERT INTO cjoNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Riraga Peetero eekiro rakitsitatya. Roojatzi ikananteetakariri: —Tema eeroka riyotaanewo Jesoshi. Roojatzi imanakotashita, ikantanaki: —Kaari naaka. ");
INSERT INTO cjoNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Itsipatari maawaeni janta paamariki apaani ronampiri Kaejashi. Rirotaki isheninka riraga ithatyaakempitawitakari riraga Peetero. Ikantziri: —Eerokama noñaakiri oriiwomashiki itsipatzimi Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Rapiitakiro Peetero imanakotaka. Roojatzi iñaantanaka tyaapa. ");
INSERT INTO cjoNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Okitejiityaanaki rookanakiro maawaeni ipanko Kaejashi. Raanakiri Jesoshi ipankoki Peraato, riraga oroomajatzi rirotaki jewawentziriri joriiyo. Kaari joriiyo, rootaki kaari ikowanta joriiyopaeni ikyaapae ipankoki. Ikantzi riraga jewatatsiri joriiyo: —Rooteentsi owawentakotyaari Tajorentsi aaka akenkithatakoteeri paeraniperoroña aririka rawijanakiri joriiyopaeni ronampiri Tajorentsi janta Ejiipitoki. Aririka aate inthomaenta ipankoki Peraato eero amatziro oya aaka, eero iñaaperotee aaka Tajorentsi akameethatzi. ");
INSERT INTO cjoNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Roojatzi riyowashitantanakariri Peraato. Ikantawakiri riraga amaeyakiririnira: —¿Iitaka rantakiri irika shiramparika pamantakinariri? ");
INSERT INTO cjoNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ikantapaakiri rirori: —Eenitatsi rantayitzirini. Eeromi rantziromi kaari kameethatatsi, eero namimirimi. ");
INSERT INTO cjoNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Roojatzi ikanantawitakari Peraato: —Paaneeri eerori. Tema ojeeki jankinarentsi pashi yotayimiri powashironkaantyaariri. Pimateri eerori powashironkaeri. Ikantapaakiri rirori: —Tee ishineteetanari nowamaeri. ");
INSERT INTO cjoNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Rootaki ikantakiriri omonkaatantakari ikantzitakari Jesoshi. Tema ikantzitani: “Ari ikentakoteetena koroshiki”. ");
INSERT INTO cjoNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Roojatzi ipiyantanaa Peraato ipankoki. Ikaemakaanteeri Jesoshi. Ikantziri: —¿Eerokama jewawentziriri joriiyopaeni? ");
INSERT INTO cjoNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ikantawakiri Jesoshi: —¿Piyowitakinakya? ¿Iitaka pojampitantanari? ¿Eenitatsima paashini kamantakimiri? ");
INSERT INTO cjoNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Rakanakiri: —¿Naakama iroñaaka joriiyo? Rirotaki atziri amakimiri jaka, riraga jewatayitatsirini ñaanakowenantatsiri. ¿Iitaka pantakiri ikijantakimiri maawaeni? ");
INSERT INTO cjoNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ikantawakiri riraga Jesoshi: —Tee nopinkathariwenantzi jaka kipatsiki. Nopinkathariwenanterikami jaka, aritaki ikijakowentakinami maawaeni nonampiri: eeromi ishinetzirimi rirori riraga joriiyopaeni ramakinami. Omaanta tee jaka nopinkathariwenantzi. ");
INSERT INTO cjoNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Roojatzi ikanantakari: —¿Kyaaryooma? ¿Eerokama jewaperotatsiri? Jee, naaka jewaperotatsiri. Kyaaryo pikantakina. Nokantziri maawaeni atziri kyaaryooperotatsiri. Rootaki natziritantapaakari, rootaki nopokantakari kipatsikika. Maawaeni riraga iyotanakirori kyaaryooperotatsiri, rirotaki maawaeni aapatziyanari. ");
INSERT INTO cjoNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ikantziri riraga Peraato: —¿Oetaka iroka pikantziri: “kyaaryooperotatsiri”? Roojatzi riyowashitantanaari irira riraga joriiyopaeni, ikantakiri maawaeni: —Nojampitawitakimi inkaaganki, tee pikantana iitaka rantaperotakiri nowamaantyaariri. ");
INSERT INTO cjoNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Eekiro riyaatatzi ikantzi: —Aririka omonkaatapaeya Kitejitatsiri Rawijantariri Ronampiri Tajorentsi, noeyowapiintzimiri apaani romonkeetziri. Tema aritaki okantari ameteeyarini. ¿Pikoyima noeyowaemiri jewaperotzimiri? ");
INSERT INTO cjoNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Roojatzi ikaemantanaka maawaeni: —Eero poeyowaanari irira, inta poeyowaenari riraga Warawaashi. Tema irira rirotaki koshintzi. ");
INSERT INTO cjoNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Roojatzi raakaanantakariri Peraato riraga Jesoshi, ipajatakaantakiri. ");
INSERT INTO cjoNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Riraga joraaro itapotayitakinirini ramantheeri kitochee okimiwitakawo tsikontochee. Ramantheetakaakariri. Ikithaatakiri kityonkamawori. ");
INSERT INTO cjoNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ipokashitapiintakiri maawaeni riraga joraaro iñaathawaetashitari ipinkathatziri, ikantajeempiyaashitapaakari: —Eeroka jewawentziriri joriiyo nopinkathatemi. Injii, injii, injii. Roojatzi ipajawootantapaakari rakoki. ");
INSERT INTO cjoNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Rapiitziro riyowashitaneeri Peraato jewatatsiripaeni joriiyopaeni. Ikantziri: —Rirotaki irika, napiitzimiri namaemiri. Nojampitawitakimi, omaanta tekatsi pikanteeyinani niyotantyaari iitaka pikijantakariri. Namakaanantariri pamineri eerokapaeni nopajatakaantakiri. Omaanta tee niyotzi iitakakya nowamaakaanantyaariri. ");
INSERT INTO cjoNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Riyowanee Jesoshi rirori. Ramantheetakawo okimiwitakawo tsikontochee, ikithaatakawo kityonkamawori. Ikanteeyirini Peraato: —Rirotaki irika. Ñaakiri, nopajatakaantakiri. ");
INSERT INTO cjoNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Raminawakiri jewatayitatsirini ñaanakowenantatsiripaeni eejatzi waariryaapaeni. Ikaemanaki: —¡Pikentakotakaanteri koroshiki! ¡Pikentakotakaanteri koroshiki! Ikantziri Peraato: —Pagaeyanakirini eeroka, pikentakotakaanteri. Nojampitawitakari, tekatsi nokemakotziri rantzi iitakakya nowamaakaanantyaariri. ");
INSERT INTO cjoNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ikantawakiri jewatatsiri Tajorentsipankoki: —Eenitatsi Iwaperite Tajorentsi iyotaanari okameethatzi ikame iitajorentsitashita. Tema ikantzi rirori: “Naaka Itomi Tajorentsi”, rootaki okameethatantakari ikame. ");
INSERT INTO cjoNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ikemantawakariri Peraato ikanteeyakiririni eekiro riyaatatzi ithaawaperotanaki. ");
INSERT INTO cjoNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ipiyakaanaari, ikyaanee ipankoki eejatzi Jesoshi. Ikantapaeri riraga Peraato: —¿Tsika pipoñaaka eeroka? ¿Ninkami eeroka? Tee rakanakiri rirori. ");
INSERT INTO cjoNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Roojatzi ikanantanakari: —¿Iitaka kaari pakantana? Naaka jewatatsiri atziriki. Nokowakirika, ari nomatero nookakaakowentemi. Eejatzi okimitaka, nokowakirika, nomatero nokentakotakaantemi koroshiki. Tema piyotakiro. ");
INSERT INTO cjoNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ikantawakiri Jesoshi: —Eeromi ishinetzimimi Tajorentsi, tekatsi pikantenami. Riraga amakaantakinari jaka, rirotaki antaperotakirori kaari kameethatatsi. ");
INSERT INTO cjoNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Roojatzi ikowantawitanaka Peraato ipakaerimi. Omaanta rapiitziro ikaemanaki jewatatsiripaeni joriiyopaeni: —¡Aririka pipakaeri irira, tee pitsipaminthatari Seesari! Irika riraga kantashitachari: “Naaka jewatatsiri”. Tema rirotaki kijakiriri peewatzinkarite riraga Seesari janta Oroomaki. ");
INSERT INTO cjoNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ikemantakari Peraato ikanteeyakiririni riyowakaaneeri Jesoshi. Janta riwetsikaetzironta, oenokamentotsi iwetsikaetziri mapi. Janta eenitatsi jeekamentotsi ijeekapiintzira Peraato ikantakowenantapiintzirira atziri. Nokantziro naaka maawaeni joriiyo: “Kawaata”. ");
INSERT INTO cjoNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Okitejitanaki Kitejitatsiri Rawijantariri Ronampiri Tajorentsi janta Ejiipitoki. Roojatzi ikanteeyantakarini Peraato: —Rirotaki irika jewatatsiri pashi eerori. ");
INSERT INTO cjoNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Omaanta ikaemaeyanakini riroripaeni: —¡Payeri! ¡Paanakiri janta! ¡Pikentakotakaanteri koroshiki! Rojampitziri ikantziri: —¿Nokentakotakaanteri piwinkatharite? Ikantawakiri riroripaeni: —Tee nopinkatharitakaayiri, omaanta apaniroeni Seesari nopinkatharitakaayiri. ");
INSERT INTO cjoNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Roojatzi ikantakiri joraaropaeni: —Paaneeri pikentakoteri. Roojatzi raantanakari. ");
INSERT INTO cjoNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Roojatzi raashitantanaka Jesoshi koroshi. Rookanakiro pankotsipaeni riyowakotantanaki owitheenkapaataga inkokironta antawopaeni mapi, rareetantapaakawo tonkaariki oetachari Iitonakintsiki. Iitziro rowaga tonkaari joriiyopaeni: “Koorikota”. ");
INSERT INTO cjoNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Aritaki ikentakotakiri koroshiki. Itsipatakari apite shirampari. Ikentakotakiri riroripaeni paashini koroshiki apite. Rowamagaetakiri Jesoshi rojatekaetakiri niyanki. Apaani rowamagaetakiri rakoperoki Jesoshi, riraga paashini rampateki. ");
INSERT INTO cjoNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Peraato rojankinatakaantaki kantatsiri: “Jesoshi najareetejatzi, rirotaki jewawentziriri joriiyopaeni”. Ipatakakotakaantakiro koroshiki. ");
INSERT INTO cjoNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Okaakintawo nampitsi aritaki ikentakotakiri Jesoshi. Osheki jewatatsiri joriiyopaeni ñaanatakirori rojankinatziri. Ojankinatawitaka ipaante joriiyo, eejatzi oroomajatzi eejatzi ipaanteki kireeshiyajatzi. ");
INSERT INTO cjoNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Riraga jewatayitatsirini ñaanakowenantatsiri joriiyopaeni ikantziri Peraato: —Tee okameethatzi pojankinatziro: “Rirotaki jewawentziriri joriiyopaeni”, inta pojankinate: “Irira kantashitachari: pinkathariwentziriri joriiyo”. ");
INSERT INTO cjoNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ikantawakiri Peraato: —Aritaki, nomatakiro: nojankinatakaantakiro. Eero ninashitawo nojankinari. ");
INSERT INTO cjoNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ari ikentakotakiri joraaro. Ari ikaatzi 4 joraaro: itakariri rayitakiri ipashikari iitoki, paashini ishintoromashite, paashini ijapatote, paashini iithari eejatzi. Omaanta ipewiryaakotari, tee oshirika inta ontyaajaampanatashita maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Rootaki ikanantawakagaeyakarini: —Eero atzijagaero. Thame añaathawaetawentyaawo ninkarika ayiterini. Aritaki ikantari joraaro. Imonkaatakiro kantatsiri Iwaperiteki Tajorentsi, ikantzi: “Ipawakaayitawoni noethaarini. Ipankinatzitenawo nopewiryaakotari”. ");
INSERT INTO cjoNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Rowaga riniro Jesoshi okatziyapaaka okaakini ikentakotakaga. Otsipatawo irentopero, roojatzi owaero Mariiya. Rootaki iina Kerejowashi. Eeniro jaga eejatzi Mariiya makaraarajato. Eejatzi naaka nokatziya okaakini. ");
INSERT INTO cjoNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Iñaanakiro Jesoshi riniro, eejatzi iñaakina naari. Ikantziro: —Nana, ajaa, irikakya Jowa rirotaki pitomintanakyaari. ");
INSERT INTO cjoNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ikantanakina: —Ajaa, rootaki pinironteeyari pitsipataperoteeyawo. Roojatzi naantanaawo nopankoki noshenantawori. Ro ikanantanari tema inintashireperotakina. ");
INSERT INTO cjoNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Riyotanaki Jesoshi aritaki monkaataka maawaeni. Roojatzi ikanantanaka: —Nomiritaatyaami. Ro ikanantari imonkaatakiro okantziri Iwaperite Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Eenitatsi jaga chomokira yeekitaki kepishaari. Ijashiteetakiniri piyonkashinkanarikira. Rojataakiniri jawokiikira. Ipakotakiri ipaantekira riraga Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ratsimiyawakiromi roojatzi ikanantanaka: —Aritaki iroñaaka, nomonkaatakiro ikowakaakinari Pawa. Roojatzi roeyotantanaka, ikamanaki. ");
INSERT INTO cjoNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Iroñaaka riwetsikawenteeyironi joriiyo kitejiri nomakoryaantapiintari. Itziroriimatanakirika oorya, rooteentsi areetya saawaro rootaki kitejitatsiri nomakoryaantapiintari. Tee ikowaeyini joriiyopaeni riraga kentakoeyeencharini rowawijeero koroshiki, rootaki ikanteeyantakaririni Peraato: —Pikagaakaantero iporipaeni, roojatzi pojataakaanantanakyaariri, ikamantyaari intsipaete. ");
INSERT INTO cjoNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Roojatzi riyaatashitanteeyanakaririni joraaro, ikagaaporitakiri iporikira riraga tsipatakariri riraga Jesoshi. Eejatzi ikagaaporitayiteetakarini paashinipaeni. ");
INSERT INTO cjoNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Apatziro rowashiwitapaakari Jesoshi, ikagaerimi iporikira: omaanta iñaapaakitziiri kamaki, rootaki kaari ikagaantari iporiki. ");
INSERT INTO cjoNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Omaanta apaani joraaro rojataapaakiri imerikiki. Iyowaatanaki riraa tyonkinininini. Eejatzi iñaa iyowaatanaki. ");
INSERT INTO cjoNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Naaka ñaakotakiriri, iroñaaka naaka kantakotakiriri paapatziyantyaariri Jesoshi. Niyotzi kyaaryo nokantzimiri. ");
INSERT INTO cjoNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Aritaki ikanteetakiriri, eejatzi omonkaataka Iwaperite Tajorentsi kantatsirini: “Eero ikagaayiteetzirini itonki apaani”. ");
INSERT INTO cjoNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Eenitatsi paashini jankinarentsi Iwaperiteki Tajorentsi okantzi: “Aritaki ramineeteri Rotyaantanewo Tajorentsi, riraga rojatagaetakiri”. ");
INSERT INTO cjoNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Eeniro janta ijeekaki koroshiki Josee arimateeyajatzi. Riyotaanewo Jesoshi naawita, omaanta imanakiro. Ro imanantakawori ithaawantakari jewatatsiripaeni joriiyopaeni. Omaanta ishirampariwentanakiri riyaatashitakiri riraga Peraato ikantapaakiri: —Pishinetayenari Jesoshini, naaneeriita. Ikantawakiri: —Paaneeri. Roojatzi riyaatantanaka ragaateri. ");
INSERT INTO cjoNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Itsipatanakari riraga Nikoreemo. Rirotaki jatashitziriri paerani Jesoshi tsiteniriki. Raakotanakiniri itziritantyaariri. Imaemañaatziro owaa inchato owaero miira, eejatzi opane inchato owaero aaroe. Aamaashita okaatzi otenatzi 30 kiiro. ");
INSERT INTO cjoNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ragaetaatziri Jesoshini. Ro tokoyatha rapineetakotantakariri, itsipatakiro kajankari. Rootaki rametari joriiyopaeni aririka riwetsikeri kamatsiri. ");
INSERT INTO cjoNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ojeekinta pankirentsi okaakini ikentakoeyakirininta koroshiki. Janta pankirentsiki ojeekinta rowanteetyaariri, owakirarika imokaetzirika. ");
INSERT INTO cjoNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Rooteentsi itziroryaanaki oorya, omonkaatantyaari kitejiri amakoryaantapiintari. Iñaakiro Josee okaakinitaki omoo. Rootaki rowantakariri Jesoshini janta. Ari ipinaashitanakiri mapi omooki. Ipiyanaa maawaeni pankotsiki. ");
INSERT INTO cjoNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Otominkotapaaki. Rooteentsi okitejitzimate iyaatakaakiro Mariiya makaraarajato janta omooki rowawiitakarinta Jesoshini. Oñaapaakiro ookanaka mapi rashitakotantawitakariri. ");
INSERT INTO cjoNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Oñaapaakiro inthomaenta omooki. Tee oñiiri Jesoshini. Tekatsi. Oshiyakaanakawo roori. Ari areetapaaka pankotsiki tsikarika nojeeki naaka eejatzi Peetero, okamantapaakina: —Tekatsi Jesoshini omooki. Tema ragaetaneeri. Tee ayotzi tsikarika owaetakiri. ");
INSERT INTO cjoNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Okamantapaakina, niyaatantanakari naaka eejatzi Peetero. Niyaatanaki rowawiteetakarinta. ");
INSERT INTO cjoNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Noshiyanaka apite, omaanta nanaakotakiri Peetero. ");
INSERT INTO cjoNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Niyowapaaki noeyotapaaka naminantapaakari inthomaenta. Noñiiro tokoyatha ookanaka omooki, omaanta tee nokyaapae. Tekatsi iwatha Jesoshini. ");
INSERT INTO cjoNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Rimpaetapaaki ipokapaaki riraga Peetero. Rirotaki kyaapaentsiri inthomaenta. Roojatzi iñaapaakiro tokoyatha. ");
INSERT INTO cjoNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Eejatzi rowaga paaño opashikantawitakariri iitoki, tee otsipatawo tokoyatha. Apitziwita ookashitanaka roori. ");
INSERT INTO cjoNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ari nokyaanaki naaka, noñaakiro, roojatzi niyotantanakari piriintanaa Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Tekiraata nokenkithashireeyironi Iwaperite Tajorentsi kantatsiri: “Ikamakirika Rotyaantanewo Tajorentsi, aritaki ipiriintanee”. ");
INSERT INTO cjoNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Noñaapaakiro, nopiyanaka nopankoki. ");
INSERT INTO cjoNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Omaanta Mariiya makaraarajato opiya omooki eejatzi katziyeencharira inkokiroeni, iraakotakari riraga Jesoshini. Oeyotanaka, aminanaki inthomaenta. ");
INSERT INTO cjoNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Oñaakiri apite ronampiri Tajorentsi, ikithaatawo kitamaari. Ijeekaki rowawiteetakarinta Jesoshini. Ijeekaki apaani iitokira rowawiitakarira Jesoshini, paashini iitziki. ");
INSERT INTO cjoNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ikantziro: —Tsinani, ¿iitaka piraantari? Okantawakiri irowa: —Ragaetanakiri Nowinkathariteni. Tee niyotzi tsikarika rowaetakiri. ");
INSERT INTO cjoNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Roojatzi opithokaantanaka. Oñaamacheetawakari riraga Jesoshi ikatziyapaaka, omaanta tee iyotawakiri. ");
INSERT INTO cjoNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ikantziro: —Tsinani, ¿iitaka piraantari? ¿Ninka pikoyirika? Oetakaashiwitakari irira rirotaki thamaetakotzirori pankirentsipaeni. Okantziri: —¿Eerokama aanakiriri Nowinkathariteni? Pikamantenaata tsikarika powakiri. Aritaki naakiteri naari. ");
INSERT INTO cjoNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ikantziro: —Mariiya. Opithokanaka, okantawakiri: —¡Iyotaanari! ");
INSERT INTO cjoNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Okimoshiryaantari okenkithashireeya ipiyaka. Oerikawakiri. Roojatzi awithakitantawakariri. Ikantziro: —Pipankaena, eero poteyaana. Tekiraata noenokana Pawaki. Iroñaaka nokowaki piyaatashiteri maawaeni aapatziyanari, pikamantapaakiri maawaeni rooteentsi noenokaeya Pawaki. Tema rirotaki Tajorentsi. Tema rirojatzi Piri eeroka, piyotziri rirotaki Tajorentsi, rootaki pipinkathatantariri. ");
INSERT INTO cjoNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Roojatzi opokashitantaanari naaka, eejatzi paashini riyotaanewopaeni, okamantapaakina maawaeni: —Noñagaerikya Awinkatharite. Eejatzi okamantapaakina okaatzi ikantayitakirorini rirori. ");
INSERT INTO cjoNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Itsiteniityaanaki oorya, nopiyoteeyakani, nokaatakiri paashini riyotaanewo. Nothaawantari jewawentziriripaeni joriiyopaeni, riraga owamaakaantakiririni Jesoshini, rootaki noyaawitantakawori ashitakontsi. Romapokashitapaakina riraga Jesoshi ikatziyapaaka niyanki. Ikantapaakina maawaeni: —Pikimoshireeyanakini maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Roojatzi roñaagantapaakinawori maawaeni rako eejatzi imerikiki. Noñaawakiri maawaeni rirotaki Nowinkatharite, roojatzi nokimoshiryaantanaka maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Rapiitakina: —Pikimoshireeyanakini maawaeni. Rirotaki paerani otyaantakinari Pawa, eejatzi eerori iroñaaka nokimitemi eeroka, notyaantemi. ");
INSERT INTO cjoNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Roojatzi itajonkantanakina maawaeni, joo. Ikantzi: —Pagaero Ishire Tajorentsi, kijokiro owaeyanakimini maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Piñaakiri atziri raapatziyaperotakina, roojatzi pikanantyaariri: “Ikamintheemi Tajorentsi eerori, eero ikijawentzimiro pantayitzirini”. Rootaki ikaminthaaperotantyaariri Pawa riraga pikantziri. Pikanteririka paashini atziri: “Tee paapatziyari Jesoshi, rootaki ikijawenantemirori Tajorentsi”, aritaki paata ikijawentakimiro. ");
INSERT INTO cjoNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ipokashitanteeyakinarini, tee añiiri Tomashi, riraga iiteetziri Tsipantzi: apaani peyeenchari. ");
INSERT INTO cjoNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ipokantapaakari irira, nokamanantawakari: —Noñeeyakirinikya Awinkatharite. Omaanta ikantana: —¿Kyaaryo? Tee naapatziyawo. Nokoyi noñeero rako, tsikarika ikyaaki kiraawo, nokoyi nomonkeero nakoempeki. Eejatzi nokoyi nomonkeero nako imerikiki. Eerorika nomonkiiro, eero naapatziyawo. ");
INSERT INTO cjoNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Awijanaki apaani tominko, ari napiitziro nopiyoteeyanakani pankotsiki, itsipatakina maawaeni riraga Tomashi. Oshekini nothaawantakari maawaeni kijanakinari, rootaki napiitantakawori noyaawitantakawori ashitakontsi. Rapiitapaakina romapokapaakina riraga Jesoshi, ikatziyashitapaaka niyanki. Ikantapaakina maawaeni: —Pikimoshiryaanakyaaroña maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Roojatzi ikanantapaakari riraga Tomashi: —Paminero nako. Pakote, pomonkeero pakoempeki jaka. Pakote, eejatzi pomonkeero pako nomerikikika. Eero pitheenkana, inta paapatziyena. ");
INSERT INTO cjoNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Roojatzi ikanantawakari riraga Tomashi: —Eerokaperotaki Nowinkatharite, eerokaperotaki Notajorentsite. ");
INSERT INTO cjoNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ikantapaakiri: —Iroñaaka piñaakina, rootaki paapatziyantakinari. Eenitatsi kaari ñaanari, omaanta raapatziyeeyakinani: nokimoshireperotakaanakiri maawaeni irikapaeni. ");
INSERT INTO cjoNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Oshekini itajonkantayitakini riraga Jesoshi. Naaka maawaeni riyotaanewo, noñeeyakirini, omaanta tee nojankinatziro maawaeni jaka. ");
INSERT INTO cjoNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ro nojankinatantakawori iroka paapatziyantyaariri maawaeni riraga Jesoshi rirotaki Rotyaantanewo Tajorentsi, riraga Itomi. Aririka paapatziyakyaari, aritaki rowañaakimi pikantyaani ijeekakaayemi rirori. ");
INSERT INTO cjoNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Nokanta nopiyeeyanaani naakapaeni riyotaanewo janta Karireeyaki. Roojatzi rapiitana roñaagapaana riraga Jesoshi, eejatzi paashinipaeni riyotaanewo. Noñeeyawaerini othapyaakiini inkaareki Teweeryashiki. Iitziro eejatzi Inkaare Karireeya. Aritaki okantakari. ");
INSERT INTO cjoNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Nopiyoteeyakani, naaka itomi apite Sewereeyo. Nokaateeyirini Peetero, eejatzi riraga Tomashi. Itsipatana Nataneeri, riraga karireeyajatzi poñaachari Kanaaki. Eejatzi eenitatsi apite paashini riyotaanewo Jesoshi. Nopiyotaka maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ikantana Peetero: —Niyaate noshiryaate. Nokanteeyanakirini: —Eejatzi naari. Ari niyaateeyanakini. Noteteeyapaakani maawaeni pitotsiki. Noshiryaatawitaka, roojatzi nokitejitakotantaka. Tekatsi nayi. ");
INSERT INTO cjoNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Okitejitanaki ikatziyapaaka riraga Jesoshi othapyaakiini. Tee niyoteeyawakirini. ");
INSERT INTO cjoNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ikantapaakina: —Notsipaminthari, ¿Paaki shima? Nokantawakiri: —Tekatsi. ");
INSERT INTO cjoNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ikantakina: —Apawo pishiryaate pakoperoki, aritaki paaki. Ari noshiryaatanaki maawaeni. Naaki oshekiniroña shima, tee naawyaakotziri notetakoteri nopitoki. ");
INSERT INTO cjoNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Naaka nokantziri Peetero: —Jaa, rirotakimakya Awinkatharite. Ari ikithaatanakawo rirori iithaari. Ipiinkashitanakiri ramaatanaki othapyaakiinira raatapaaka. ");
INSERT INTO cjoNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Nimpaetakotapae naakapaeni, nonoshikakotziri shima. Okaakitapae othapyaakiini, aamaashitaka okaatzi 100 meetero. ");
INSERT INTO cjoNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Nomitaanaki maawaeni omerikyaataki othapyaakiiniki. Noñaapaaki paamari, itashitziri shima. Eenitatsi eejatzi paa. ");
INSERT INTO cjoNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ikantawakina: —Pamagaantakinari iroñaaka shima pishiryaatakirira. ");
INSERT INTO cjoNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Rapiitziro rotetapaa Peetero pitotsikira inoshikaatakotapaakiri shima ishiryaatamentoki kipatsiki. Yeekiperotaki antaripaeni shima, ikaatzi 153. Oshekiperoroña omaanta tee opejanaki noshiryaatamento. ");
INSERT INTO cjoNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","13","Ikantawakina: —Ajaa, poya. Ikagaakinawo paa eejatzi ikagaakinari shima. Nowaeyakarini maawaeni. Nothaawantakari nokanterimi: “¿Ninkamika”? Maawaeni niyotawakiri rirotaki Awinkatharite. ");
INSERT INTO cjoNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ikamaki chapinki Jesoshi, ipiriintanaa. Rootaki roñaagaana eejatzi maawaeni riyotaanewo. Iroñaaka okaatzi 3 roñaagaana naakapaeni. ");
INSERT INTO cjoNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Nowaeyakani maawaeni. Roojatzi rojampitantakari Jesoshi riraga Shimo, iitziri Peetero: —Peetero, ¿panaakotakiri irikapaeni, pinintashireperotana eeroka? Ikantawakiri rirori: —Eeroka, Nowinkatharite, yotatsiri nonintzimi. Ikantanakiri: —Piyoteeri riraga aapatziyanari: tema ari roshiyakyaari nashi nowishaanite. ");
INSERT INTO cjoNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Rapiitakiri, ikantawakiri: —¿Pinintashiretana? Rapiitawakiri ikantawakiri: —Jee, Nowinkatharite, eeroka yotatsiri nonintashiretzimirika. Ikantziri: —Pikempoyeenari maawaeni ameenteeyakinarini. ");
INSERT INTO cjoNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Rapiitziro rojampitziri, tres-tapaentsiri. Ikantziri: —¿Pineshironkatanama? Roojatzi rowashirewaetantanaka Peetero. Tema ro rowashiretantakari okaatzi 3 rojampitziri Jesoshi okimitaka chapinki riraga Peetero imanakotashitaka okaatzi 3. Ikantawakiri: —Eerokakya, Nowinkatharite, yotzirorikya maawaenikya. Piyotana eeroka nonintashiriimirika eechonkiini. Ikantziri: —Pikempoyeeri kameetharini maawaeni aapatziyanari. Tema roshiyawitakaari nowishate. Piyotakoperotakina. ");
INSERT INTO cjoNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Kyaaryootaki iroka nokantemiri: paerani, eeniro pewankariwaetzini, pikithaatapiintawoni piithaari. Piyaatapiintayitzini tsikarika pikoyiri piyaate: tekatsi atziri kantemini: “Eero piyaatzi”. Omaanta aririka pantyashipariperotapaaki, pakote pakoki, roojoteetemi, ikithaatemi paashinipaeni. Raanakimi janta tsikarika tee pikowawita piyaate. ");
INSERT INTO cjoNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Aritaki ikantakiri. Riyotaakiri tsika ikantyaari rowamagaetantyaariri Peetero iinja. Aririka iñeeteri ikamaki, riyotanaki maawaeni iñaaperotakiri Tajorentsi ikameethatzi. Roojatzi ikanantanakyaari: —Thame, poyaatanakina. ");
INSERT INTO cjoNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ipithokanaka Peetero. Iñaakina noyaatanakiri, rooma naaka riyotaanewo Jesoshi inintaperotziri. Chapinki nowakagaeyantakaririni Jesoshi, naaka ojampitakiriri: “Nowinkatharite, ¿ninka aakaanteminika?” ");
INSERT INTO cjoNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Iñaantakinari Peetero, rookotana, eejatzi ikantziri Jesoshi: —Nowinkatharite, ¿tsika ikanteeterika iinja riraganki? ");
INSERT INTO cjoNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ikantawakiri: —Nokoyirika ijeekanakiita jaka roojatzi nopiyanteeyaari, eero pikenkithashiryaakotari. Omaanta eeroka poyaatenaata. ");
INSERT INTO cjoNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Rowaagaeyakinirini maawaeni paashinipaeni aapatziyariri Jesoshi okaatzi ikantziriri irira. Iitashiwitaka irira eero nokami. Omaanta tee ikantzi Jesoshi: “Eero ikami Jowa”. Inta ikantawitari: “Nokoyirika ijeekanakiita jaka roojatzi nopiyantakyaari, eero pikenkithashiryaakotari”. ");
INSERT INTO cjoNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Naakapero riyotaanewo riraga Jesoshi, jankinatzirori iroka. Noñiiro maawaeni. Niyoteeyakini kyaaryooperotaki maawaeni iroka nojankinatakiri. ");
INSERT INTO cjoNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Teera nothotziiro nojankinatziro maawaeni rantayitakirini Jesoshi. Arimi ojankinatayitakotyaami maawaeni, rantayitakirini, naamaashitya ari iyeekitakiromi maawaeni kipatsi iñaanamentopaeni. Ari okaatzi. Naaka jankinatzirori: Jowa");
INSERT INTO cjoNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Nokoyi niwethatemi, nonintanewo Teyoojiro. ¿Tekatsima oyemini? Naaka kameetha. Paerani nitantakawori nojankinatantakimirori, niyotaantakimirori osheki rantayitzirini Jesoshi. Eejatzi niyotaantakimirori osheki riyotaantayitzirini. ");
INSERT INTO cjoNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","3","Ari iñaashitzimaetakawo ikamakira, ari rañaagae, roojatzi roñaagantapaakariri riyotaanewopaeni. Osheki iñaakotapiinteeyirini rantapaakiri rirori, rootaki riyoperotantariri rañaagae. Okaatzi 40 kitejiri roñaagapiinantariri. Ikenkithatakotziri tsikarika ikanta Tajorentsi reewawenantzi. Rotyaantanakiri riyotaanewopaeni riyoteeri paashini atziri oetarika ikowakaakiriri ranteri. Ro kantziriri Ishire Tajorentsi. Roojatzi riraga Tajorentsi raaneeri Itomi jenokinta, roojatzi noweyaantakawori nokenkithatakotakiri paerani. Iroñaaka eekiro niyaatatzi nowaayemiro nokantemi rantziri riraga rotyaantanewopaeni Jesoshi, riraga otyaantanakiriri paerani. ");
INSERT INTO cjoNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Apaani kitejiri, tekira riyaatee jenokinta, ikaatakagaeyakirini Jesoshi eejatzi riyotaanewopaeni ikantaperotakiri riraga Jesoshi: —Eero pookanakiro Jerojareeki, nokowaki poyaawakiroota ikashiyakaakimiro Ashitanari, rowaga pikemakinari chapinki nokantzitakimiriroña. ");
INSERT INTO cjoNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Riraga Jowani ikaawoshitakotzimiri Tajorentsi iñaaki, riyotantakari atziri paapatziyari Tajorentsi. Omaanta eero ojamanitzi opokashitemi Ishire Tajorentsi, okithaatakaapaakimi, riyotantyaari atziri kyaaryo pikemijantaperotakina naari. ");
INSERT INTO cjoNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Paashini kitejiri ipiyotawenteeyakarini Jesoshi riyotaanewopaeni eejatzi paashinipaeni aapatziyariri janta tonkaariki owaero Oriiwomashi. Rojampiteeyirini. Ikantziri apaani: —Nowinkatharite, aaka isheninkani riraga achariniiteni Ishireeyeerini. Paerani ijeekawitani jewawenantatsiripaeni achariniitenipaeni; omaanta iroñaakaroña tekatsi. ¿Arima iroñaaka pikanteri paashini reewawenteeyenani? Osheki nokowaki. ");
INSERT INTO cjoNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ikantawakiri: —Tee ikowakayimi Ashitanari piyotero tsikarika okaate. Ojamanitatziirika rooma tsikarika okaate. Apatziro Ashitanarikya apaniroeni kantatsini. ");
INSERT INTO cjoNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Iinja itajonkawenteeyeminiita eejatzi opokashiteeyemini Ishire. Omatakayemi, rootaki nokowakaakimiri pikenkithatakotena jaga Jerojareeki, eejatzi pithotyaanakiro Joreeyaki pikenkithatakotena. Eejatzi pikenkithatakotena janta Jamaaryaki, eejatzi pithotyaanakiro maawaeni paashinipaenikinta kipatsikinta, pikenkithatakotena. Tsikarika piyaate nokowaki pikenkithatakotena. ");
INSERT INTO cjoNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Rootaki ikantanakiriri Jesoshi. Ari ramineeyawakirini maawaeni, roojatzi roenokantana jenoki, ipeyimotanakari menkoriki. ");
INSERT INTO cjoNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ari ramineeyanakirini jenoki joreririri, jatanaki. Ari romapokapaakiri apite ronampiri Tajorentsi, ikatziyimoeyapaakarini. Ikimitapaakari shirampari; kitamaamawori imaatha. ");
INSERT INTO cjoNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ikantapaakiri: —¿Eeniromi, karireeyajatzi? ¿Iitaka eekiro paminanta jenoki? Piñaawakiri riraga Jesoshi roenokanaka jenokinta. Eejatzi ipiye paata. Aririka ipiye, ikimitapaeya iroñaaka riyaatantanaari. ");
INSERT INTO cjoNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Roojatzi roerinkantanaa taapiki, ipiyeeyanaani Jerojareeki riraga rotyaantanewo Jesoshi kimitaka apaani kiroometero. Okaakini Jerojaree, tee inteenaperotzi. ");
INSERT INTO cjoNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ari rareeteeyapaakani, rateeteeyapaakini oshitamenkota jenoki. Janta imaapiinteeyininta riraga Peetero, eejatzi Jowa, Jantyaako, Antereeshi, Jiripi, Tomashi, Waritoromee, Mateeyo, Jantyaako (riraga itomi Arijeeyo), Shimo (riraga kathaaperotzinkari antayitzirorini oetarikapaeni), eejatzi Joorashi (riraga itomi paashini Jantyaako), imaapiinteeyini maawaeni. ");
INSERT INTO cjoNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ari rapiitapiinteeyironi ipiyoteeyani eejatzi ikenkithatakagaeyirini Tajorentsi. Itsipateeyarini rirentzipaeni Jesoshi, eejatzi riniro rowaga Mariiya, eejatzi paashinipaeni tsinani. Aritaki ikantani ikenkithatakaapiinteeyirini Tajorentsi. ");
INSERT INTO cjoNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ari paashini kitejiri ikatziyanaka riraga Peetero ikatziyimoteeyanakarini iyemijantzinkaritepaeni. Aamashitya ikaateeyini 120. ");
INSERT INTO cjoNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Ikantzi: —Nojoriiyotzinkaritepaeni, okameethatzi amonkaatero okantzirini Iwaperite Tajorentsi. Paerani iyoteerini Ishire Tajorentsi Iraviirini ikenkithatakotantaririni Joorashini: riraga jewateeyakiririni agaeyakiririni Jesoshi. ");
INSERT INTO cjoNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Aritaki akaateeyawitariniroña. Paerani itsipateeyawiteeni rantawaetakaawitakina. ");
INSERT INTO cjoNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Omaanta raakaantashitaari Awinkatharite, ipinatashiteetawitakari koriki. Raawitakari, roojatzi roepiyeeniri, rirotaki koriki ramanananteetakawori kipatsi. Roojatzi irira ishirikantanaka, shirik; ithatanaka. Roojatzi ithatyaakotantanaka, thatzik; ipityaankanaka; roojatzi ikotaantapaaka imotziki, waag, iyowapaaki isheeto. ");
INSERT INTO cjoNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Riyoteeyakirini maawaeni jerojareejatzi. Rootaki iitanteetawori kipatsi ramananteetziri Asheererama. Akantziro apaanteki aaka: “Iwinawoni Jesoshi rowamaanteetawitakariri”. ");
INSERT INTO cjoNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Aritaki paerani rojankinateetzironi mampaantsi kantatsiri: “Okaankipankotanaki ipankoni aakaanterini Awinkatharite, tekatsi jeekantzityaarini”. Eejatzi okantzini mampaantsi: “Okameethatzi eeniro poyaatyaarini kenkithatakaanantatsini”. ");
INSERT INTO cjoNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Iroñaaka thame akanteri paashini: “Pipoyaatyaari Joorashini”: tema rootaki ikowakaakaeri Tajorentsi. Rirotaki akanteri tsipatapiinteeyeerini paerani: ñaaperotziriri Jowani ikaawoshitantzini, eejatzi ñaapiintziriri Jesoshi. Akowaki ñaakiriri rañaagae eejatzi riyaatanee jenokinta: akanteri ikaateeyeeni akenkithatakoeyerini Jesoshi. ¿Ninka akanterika iroñaaka ipoyaatyaari? ");
INSERT INTO cjoNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ari ikantzi paashini: —Rirorika irika Josee Warajawaashi, iiteetziri eejatzi Jooshito. Teerika irira, rirorika irika Mateeyashika. Ari ikaemiri apite: —Pipokanaki jaka niyanki. ");
INSERT INTO cjoNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Roojatzi ikenkithatakaeri Tajorentsi, ikantziri: —Nowinkatharite, eerokakya iyotzirori tsika ikanteeyarini maawaeni atziri rajankaneki. Eeniro irika apite. Piyotakayenari ninkarika pikowakayaari eeroka poyaatyaarini Joorashini. Tekatsi ikanta iroñaaka rirori ikenkithatee eejatzi ranantee: tema kamaki rirori, jataki janta paamariki kaari ts