﻿USE sofia;
DROP TABLE IF EXISTS sofia.cje_vpl;
CREATE TABLE cje_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cje_vpl WRITE;
INSERT INTO cje_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Du angăn kơi-kŏ pàng-yau Yàng Jêsu Krist, anà-tơc̆o Đabit, anà-tơc̆o Abraham. ");
INSERT INTO cje_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham pơjiơ̆ng Isak; Isak pơjiơ̆ng Jakôp; Jakôp pơjiơ̆ng Juđa sơ̆ng du adơi-ai ñu. ");
INSERT INTO cje_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juđa pơjiơ̆ng Pheres sơ̆ng Sereh (Ame buơl guñu la Tamar). Pheres pơjiơ̆ng Hesrôn; Hesrôn pơjiơ̆ng Aram. ");
INSERT INTO cje_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram pơjiơ̆ng Aminađap; Aminađap pơjiơ̆ng Naasôn; Naasôn pơjiơ̆ng Salmôn. ");
INSERT INTO cje_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmôn khiăng sơ̆ng Rahap pơjiơ̆ng Bôô. Bôô khiăng sơ̆ng Rutơ pơjiơ̆ng Ôbet. Ôbet pơjiơ̆ng Jese; ");
INSERT INTO cje_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jese pơjiơ̆ng pơtau Đabit. Đabit pơjiơ̆ng Salômôn (Ame Salômôn dơlhơu la sơdiŭ Uri). ");
INSERT INTO cje_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salômôn pơjiơ̆ng Rôbôam; Rôbôam pơjiơ̆ng Abija; Abija pơjiơ̆ng Asa; ");
INSERT INTO cje_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa pơjiơ̆ng Jôsaphat; Jôsaphat pơjiơ̆ng Jôram; Jôram pơjiơ̆ng Ôsias. ");
INSERT INTO cje_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ôsias pơjiơ̆ng Jôtam; Jôtam pơjiơ̆ng Ac̆as; Ac̆as pơjiơ̆ng Esec̆ia. ");
INSERT INTO cje_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esec̆ia pơjiơ̆ng Manase; Manase pơjiơ̆ng Amôn; Amôn pơjiơ̆ng Jôsia. ");
INSERT INTO cje_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Jôsia pơjiơ̆ng Jekônia sơ̆ng du adơi-ai ñu, lăm tŭ kơđòng aràng mă ba nau tơ lơgăr 'Babilôn. ");
INSERT INTO cje_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Hơdơi tŭ kơđòng aràng mă ba nau tơ lơgăr 'Babilôn, Jekônia pơjiơ̆ng Salathiel; Salathiel pơjiơ̆ng Sôrôbabel; ");
INSERT INTO cje_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Sôrôbabel pơjiơ̆ng Abiut; Abiut pơjiơ̆ng Aliakim; Aliakim pơjiơ̆ng Asôr. ");
INSERT INTO cje_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asôr pơjiơ̆ng Sadôk; Sadôk pơjiơ̆ng Ac̆im; Ac̆im pơjiơ̆ng Eliut; ");
INSERT INTO cje_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliut pơjiơ̆ng Eleasar; Eleasar pơjiơ̆ng Mathan; Mathan pơjiơ̆ng Jakôp; ");
INSERT INTO cje_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jakôp pơjiơ̆ng Jôsep la pơsàng Mari; Mari la mơnih pơjiơ̆ng Yàng Jêsu, angăn la Pô Krist. ");
INSERT INTO cje_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Yơu nư̆n, mư̆ng Abraham tơ̆l truh tơ Đabit, abih-tih hũ sa-pluh pà rài; mư̆ng Đabit tơ̆l truh tŭ kơđòng aràng mă ba nau tơ lơgăr 'Babilôn, kŭng hũ sa-pluh pà rài; sơ̆ng mư̆ng tŭ kơđòng aràng mă ba nau tơ lơgăr 'Babilôn tơ̆l truh tơ Pô Krist kŭng hũ sa-pluh pà rài. ");
INSERT INTO cje_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Pơnuaĭ tơbiă rài Yàng Jêsu Krist hũ tơbiă truh yơu ni: Mari, ame Pô, hũ c̆ĕ-sơnuai sơ̆ng Jôsep, bloh dơlhơu tŭ dua aràng hơdiŭ dò sơ̆ng gơŭ, nư̆n Mari hũ mơtiàn kơyoa Yàng Bơngă Sơc̆ih-Sri. ");
INSERT INTO cje_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Jôsep, pơsàng ñu, la mơnih rĭng-tơpă, 'buh khiăng luơi ñu kŏng pơnuaĭ pơtiơ̆ng jơhà, nư̆n ngă-nìn khiăng tơrđơŭ iờp pơkloh luơi. ");
INSERT INTO cje_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Bloh lăm tŭ Jôsep dò sơnư̆ng-bơngoàn mư̆ng bruă ni, nư̆n sa aràng mơnih gơdrưh Yàng truh pơ'buh sơ̆ng Jôsep lăm pơnuaĭ lơpơi, bloh đờm lài: “Ơ Jôsep, anà-tơc̆o Đabit, hã juơi huơĭ khiăng sơ̆ng Mari sơdiŭ hã, kơyoa anà bloh ñu mơtiàn nư̆n la kơyoa Yàng Bơngă Sơc̆ih-Sri. ");
INSERT INTO cje_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ñu rơŭ đih apui sa aràng anà lơkơi, hã pơ-angăn bĕ mơta la Jêsu, kơyoa rùp-phŭn anà lơkơi nư̆n rơŭ dŏng buơl làng drơi tơbiă klàh mư̆ng glài-sơnoh.” ");
INSERT INTO cje_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Tơgrơ̆ bruă ni hũ tơbiă truh, tô iơŭ tơpă pơnuaĭ Yàng hũ angui mơnih gơnuăr-hwơ̆r bloh đờm lài: ");
INSERT INTO cje_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Ni, sa aràng kơmơi dra sơc̆ih-sơc̆ăn rơŭ hũ mơtiàn, sơ̆ng đih apui sa aràng anà lơkơi. Bloh nư̆n aràng rơŭ pơ-angăn mơta anà lơkơi nư̆n la Emanuel,” mơblàng la: “Yàng Pô Lơngì dò găm sơ̆ng buơl gudrơi.” ");
INSERT INTO cje_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Tŭ mơdơh tơgồ, Jôsep ngă tui iơŭ yơu pơnuaĭ mơnih gơdrưh Yàng hũ pơto pơđăr, sơ̆ng ba sơdiŭ mơrai wơ̆ sơ̆ng drơi; ");
INSERT INTO cje_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","bloh 'buh đih dò sơ̆ng gơŭ tơ̆l truh tơ tŭ Mari đih apui sa aràng anà lơkơi sơ̆ng Jôsep pơ-angăn mơta la Jêsu. ");
INSERT INTO cje_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Tŭ Yàng Jêsu hũ tơbiă rài tơ 'Betlehem, c̆àr Juđe, lăm rài pơtau Herôt, hũ du mơnih jak-khờh mư̆ng gah ia-hơrơi tơgồ nau truh tơ plơi-prŏng Jerusalem, ");
INSERT INTO cje_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","bloh tơnia lài: “Pơtau buơl làng Juđa pơrpa tơbiă rài tơ anih lơi? Kơyoa buơl dơlhă hũ 'buh ia-pơtŭ Pô gah ia-hơrơi tơgồ, nư̆n truh tô duh-dơlbăt Pô.” ");
INSERT INTO cje_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Mơhư̆ pơnuaĭ nư̆n, pơtau Herôt găm sơ̆ng abih plơi-prŏng Jerusalem kơ-ù dò 'buh suk. ");
INSERT INTO cje_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Nư̆n pơtau iơu tơrgùm abih du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt sơ̆ng du mơnih gơnuăr-pơto pơnuaĭ adăt-adia lăm buơl làng truh, bloh tơnia lài Pô Krist păl tơbiă rài tơ anih lơi. ");
INSERT INTO cje_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Buơl guñu đờm lài: “Tơ plơi-prŏng 'Betlehem, c̆àr Juđe; kơyoa hũ pơnuaĭ mơnih gơnuăr-hwơ̆r wă yơu ni: ");
INSERT INTO cje_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Ơ 'Betlehem, tơnah Juđe! Hã 'buh iơŭ la plơi-prŏng tìt rơlau abih lăm du plơi-prŏng Juđe ơu. Kơyoa mư̆ng hã rơŭ tơbiă sa Pô apăn-akŏ, La Pô rơŭ glăng-c̆ơ buơl làng Israel Kơu.’ ” ");
INSERT INTO cje_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Tŭ nư̆n, pơtau Herôt tơrđơŭ-bơdơŭ iơu du mơnih jak khờh truh, tô tơnia buơl guñu nĭ-nùn mư̆ng tŭ-hơrơi ia-pơtŭ hũ tơbiă. ");
INSERT INTO cje_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Bloh nư̆n pơtau pơđăr buơl guñu nau truh tơ plơi-prŏng 'Betlehem, sơ̆ng kơkơi pơđăr lài: “Nau bĕ sơ̆ng duah tơnia nĭ-nùn mư̆ng anà tìt nư̆n; tŭ duah hũ bơjơ, brơi bĕ tơ kơu thơu, tô kơu kŭng truh bloh duh-dơlbăt Pô.” ");
INSERT INTO cje_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Hơdơi tŭ mơhư̆ pơtau đờm yơu nư̆n, buơl guñu tơbiă nau mư. Dih, ia-pơtŭ bloh buơl guñu hũ 'buh gah ia-hơrơi tơgồ, nau dơlhơu buơl guñu truh tơ anih anà tìt dò, nư̆n ka dò dơ̆ng wơ̆. ");
INSERT INTO cje_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Tŭ 'buh ia-pơtŭ, buơl guñu sờh-sài biă-biài. ");
INSERT INTO cje_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Tơma truh lăm sàng, buơl guñu 'buh anà tìt sơ̆ng Mari, ame Pô, nư̆n pơđih rùp trŭn bloh duh-dơlbăt Pô; bloh nư̆n ràng du phơ̆n c̆ơk-màng tơbiă, pơyă tơ Pô du phơ̆n c̆ĕ-pơyơ̆r duh-dơlbăt, la mừh, gơlhơu, sơ̆ng c̆ài-trŭ. ");
INSERT INTO cje_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Hơdơi mư̆ng nư̆n, lăm pơnuaĭ lơpơi, buơl guñu hũ Yàng Pô Lơngì đờm pơđăr juơi gài wơ̆ anih pơtau Herôt tra, nư̆n buơl guñu nau jơlàn pơkơ̆n bloh mơrai wơ̆ tơ lơgăr phŭn drơi. ");
INSERT INTO cje_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Tŭ du mơnih jak-khờh nau bơjơ, sa aràng mơnih gơdrưh Yàng tơbiă pơ'buh sơ̆ng Jôsep lăm pơnuaĭ lơpơi, bloh đờm pơđăr lài: “Tơgồ bĕ, ba anà tìt sơ̆ng ame Pô pleh dơŭ tơ lơgăr Ejiptơ, sơ̆ng kừ dò tơ anih nư̆n tơ̆l truh tơ tŭ kơu brơi pơthơu wơ̆, kơyoa pơtau Herôt rơŭ duah anà tìt nư̆n tô pơmơtai.” ");
INSERT INTO cje_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Lăm glai mơlăm, Jôsep tơgồ, ba anà tìt sơ̆ng ame Pô nau pleh dơŭ tơ lơgăr Ejiptơ, ");
INSERT INTO cje_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","sơ̆ng dò tơ anih nư̆n tơ̆l truh tơ tŭ pơtau Herôt mơtai. Bruă ni tơbiă truh tô pơnuaĭ Yàng angui mơnih gơnuăr-hwơ̆r đờm hũ tơbiă iơŭ tơpă: “Kơu hũ iơu Anà Kơu tơbiă mư̆ng Ejiptơ.” ");
INSERT INTO cje_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Tŭ 'buh drơi kơđòng du mơnih jak-khờh pơ̆ng-gơla, pơtau Herôt anok hơtai biă, nư̆n pơđăr mơnih nau pơmơtai abih du anà lơkơi tìt lăm plơi-prŏng 'Betlehem sơ̆ng du c̆àr tòmdăr, mư̆ng dua thŭn sơtơŭ trŭn tơ ala, tui iơŭ yơu hơrơi blàn bloh du mơnih jak-khờh hũ brơi pơtau thơu. ");
INSERT INTO cje_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Yơu nư̆n la tơbiă iơŭ tơpă yơu pơnuaĭ mơnih gơnuăr-hwơ̆r Jeremi hũ đờm lài: ");
INSERT INTO cje_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Aràng hũ mơhư̆ tơ Rama, Săp driau-kơmrào, hia-c̆ŏ, să-jua; Nư̆n la Rac̆el hia tơ du anà drơi, Bloh 'buh khiăng aràng pơluơ-pơrơngài, Kơyoa guñu 'buh dò tra.” ");
INSERT INTO cje_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Hơdơi tŭ pơtau Herôt mơtai, sa aràng mơnih gơdrưh Yàng tơbiă pơ'buh sơ̆ng Jôsep lăm pơnuaĭ lơpơi, tơ lơgăr Ejiptơ, bloh đờm pơđăr lài: ");
INSERT INTO cje_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Tơgồ bĕ, ba anà tìt sơ̆ng ame Pô gài mơrai wơ̆ tơ lơgăr Israel, kơyoa du mơnih duah pơmơtai anà tìt hũ mơtai bơjơ.” ");
INSERT INTO cje_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Jôsep tơgồ, ba anà tìt sơ̆ng ame Pô gài mơrai wơ̆ tơ lơgăr Israel. ");
INSERT INTO cje_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Bloh tŭ mơhư̆ thơu Ac̆elau, anà Herôt, đì ngă pơtau apăn-akŏ lơgăr Juđe, nư̆n Jôsep huơĭ 'buh khĭn mơrai wơ̆; sơ̆ng kơyoa hũ Yàng Pô Lơngì akhàn-pơđăr lăm pơnuaĭ lơpơi, nư̆n Jôsep đì tơ c̆àr Galile, ");
INSERT INTO cje_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","sơ̆ng truh dò lăm sa plơi-prŏng angăn la Nasaret. Yơu nư̆n, tơgrơ̆ bruă tơbiă truh iơŭ tơpă yơu pơnuaĭ du mơnih gơnuăr-hwơ̆r hũ đờm: “Aràng rơŭ iơu Pô la mơnih Nasaret.” ");
INSERT INTO cje_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Lăm du hơrơi nư̆n, Jăng 'Baptis truh pơto-akhàn lăm 'blàng-jơhua c̆àr Juđe lài: ");
INSERT INTO cje_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Buơl guhã păl mơbai prah-luơi glài-sơnoh, kơyoa Lơgăr Lơngì hũ truh jĕ bơjơ.” ");
INSERT INTO cje_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jăng 'Baptis la mơnih bloh mơnih gơnuăr-hwơ̆r Êsai hũ đờm truh, tŭ đờm lài: “Hũ săp mơnih iơu driau lăm 'blàng-jơhua: Waìh bĕ jơlàn tơ Yàng, Ngă pơtơpă du jơlàn tìt tơ Pô.” ");
INSERT INTO cje_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jăng c̆ù ào ngă sơ̆ng blơu lakđa, akă tơlơi kơ-iăng sơ̆ng klì, mă kơtòk sơ̆ng ia hơnìng glai ngă phơ̆n 'bơ̆ng. ");
INSERT INTO cje_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Tŭ nư̆n, buơl làng mư̆ng plơi-prŏng Jerusalem, abih c̆àr Juđe, sơ̆ng abih du c̆àr tòmdăr ia-sơdờng Jôđăn, ba gơŭ truh sơ̆ng ñu. ");
INSERT INTO cje_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Hơdơi tŭ buơl guñu akhàn-tơbiă glài-sơnoh drơi, Jăng ngă 'baptem tơ buơl guñu lăm ia-sơdờng Jôđăn. ");
INSERT INTO cje_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Bloh tŭ Jăng 'buh lô mơnih Pharisi sơ̆ng Sađuse truh yòng đồ-mă 'baptem, Jăng đờm sơ̆ng buơl guñu: “Ơ jơi-pơtiàn ala mơsak-jơhà dih, aràng sơi hũ pơto tơ buơl guhã thơu tô pleh klàh mư̆ng pơnuaĭ anok-anoa prŏng kơjĕ truh? ");
INSERT INTO cje_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Yơu nư̆n, buơl guhã tơbiă bĕ bơnga boh iơŭ păl sơ̆ng pơnuaĭ mơbai prah-luơi glài-sơnoh, ");
INSERT INTO cje_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","sơ̆ng juơi đờm yeh-drơi lài: ‘Abraham la kơi-kŏ pàng-yau buơl gudrơi.’ Kơyoa kơu đờm tơ buơl guhã thơu, Yàng Pô Lơngì rơgơi ngă du boh pơtơu ni tơbiă jiơ̆ng anà-tơc̆o tơ Abraham jiơ̆ng. ");
INSERT INTO cje_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Tŭ ni jòng hũ daŭ jĕ tơ phŭn kơyơu; yah kơyơu lơi 'buh tơbiă boh siàm, nư̆n rơŭ păl dròm sơ̆ng prah lăm apui. ");
INSERT INTO cje_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Kơu ngă 'baptem tơ buơl guhã sơ̆ng ia tô mơbai prah-luơi glài-sơnoh; bloh Pô truh hơdơi kơu, hũ gơnăp-gơnuăr rơlau kơu, kơu 'buh sơ̆p păl tô apăn klì-juă tơ Pô. Pô rơŭ ngă 'baptem tơ buơl guhã sơ̆ng Yàng Bơngă Sơc̆ih-Sri sơ̆ng apui. ");
INSERT INTO cje_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Tơngàn Pô apăn kơrnừh, sơ̆ng ngă goh làn bơdai drơi, bloh nư̆n pioh bơdai lăm bŭng, dò apồng sơ̆ng bơdai-bo nư̆n c̆uh lăm apui 'buh tŭ lơi mơtai.” ");
INSERT INTO cje_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Tŭ nư̆n, Yàng Jêsu mư̆ng c̆àr Galile truh sơ̆ng Jăng tơ ia-sơdờng Jôđăn tô Jăng ngă 'baptem tơ Pô. ");
INSERT INTO cje_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Bloh Jăng kơmlah, đờm lài: “Rùp-phŭn dơlhă la mơnih păl yòng Pô ngă 'baptem tơ dơlhă, bloh hơyơu Pô truh sơ̆ng dơlhă wơ̆?” ");
INSERT INTO cje_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yàng Jêsu đờm: “Tŭ ni kừ ngă bĕ, kơyoa buơl gudrơi păl ngă wĭl-tơ̆l tơgrơ̆ bruă rĭng-tơpă.” Yơu nư̆n, Jăng păng-bơbah Pô. ");
INSERT INTO cje_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Hơdơi tŭ hũ 'baptem bơjơ, Yàng Jêsu đì tơbiă mư̆ng ia; dih, tơgrơ̆ tăl lơngì pơh tơbiă, Pô 'buh Bơngă Sơc̆ih-Sri Yàng Pô Lơngì trŭn yơu c̆ĭm kơtrơu, đơ̆m tơ ngŏ Pô, ");
INSERT INTO cje_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","sơ̆ng hũ săp mư̆ng ngŏ lơngì đờm: “Ni la Anà Kơu uơ̆n-rơnăm, siàm hơtai Kơu lăm abih tơgrơ̆ mơta.” ");
INSERT INTO cje_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Bloh nư̆n, Bơngă Sơc̆ih-Sri ba Yàng Jêsu tơma lăm 'blàng-jơhua, tô kŏng kơmlài-jĭnràk pơluơ-ơñiai. ");
INSERT INTO cje_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Hơdơi tŭ 'buh 'bơ̆ng 'buh mơñŭm hơgĕ lăm pà pluh hơrơi, pà pluh mơlăm, nư̆n Pô lơpa. ");
INSERT INTO cje_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Kơmlài pơluơ-ơñiai truh jĕ, đờm sơ̆ng Pô: “Yah Pô la Anà Yàng Pô Lơngì, nư̆n pơđăr bĕ tơgrơ̆ boh pơtơu ni tơbiă jiơ̆ng pah.” ");
INSERT INTO cje_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yàng Jêsu đờm: “'Bồn Bơ-àr Sơc̆ih-Sri wă: ‘Anà mơnih hơdiŭ 'buh iơŭ mĭn gơnừm tơ pah soh, bloh kŭng gơnừm tơgrơ̆ pơnuaĭ đờm tơbiă mư̆ng pơbah Yàng Pô Lơngì.’ ” ");
INSERT INTO cje_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Bloh nư̆n kơmlài-jĭnràk ba Pô truh tơ plơi-prŏng sơc̆ih-sri, daŭ Pô tơ bơbŭng sàng duh-dơlbăt, ");
INSERT INTO cje_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","sơ̆ng đờm: “Yah Pô la Anà Yàng Pô Lơngì, nư̆n plĕ rùp trŭn bĕ tơ ala, kơyoa hũ pơnuaĭ wă: ‘Yàng rơŭ brơi gơnuăr-pơđăr tơ du mơnih gơdrưh Pô, Du pô nư̆n rơŭ đơ̆ng hã lăm tơngàn drơi, Huơĭ tơkai hã sơnĕ iơŭ tơ pơtơu ơu.’ ” ");
INSERT INTO cje_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yàng Jêsu đờm: “'Bồn Bơ-àr Sơc̆ih-Sri kŭng wă: ‘Hã juơi lòng Yàng la Yàng Pô Lơngì hã.’ ” ");
INSERT INTO cje_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Hơdơi mư̆ng nư̆n, kơmlài-jĭnràk ba Pô đì tơ bơbŭng c̆ơ̆ glòng biă, sơc̆ê tơ Pô 'buh abih tơgrơ̆ lơgăr lăm dun-ya, găm sơ̆ng pơnuaĭ màng-kơc̆rà du lơgăr nư̆n, ");
INSERT INTO cje_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","sơ̆ng đờm lài: “Yah hã pơđih rùp tơ ala duh-dơlbăt kơu, kơu rơŭ brơi tơ hã abih tơgrơ̆ pơnuaĭ ni.” ");
INSERT INTO cje_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yàng Jêsu đờm sơ̆ng ñu lài: “Ơ Satăn, kơdŭn bĕ sơmăr! Kơyoa 'Bồn Bơ-àr Sơc̆ih-Sri pơto: ‘Hã păl duh-dơlbăt Yàng la Yàng Pô Lơngì hã, sơ̆ng mĭn duh bruă sa aràng Pô soh.’ ” ");
INSERT INTO cje_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Nư̆n kơmlài-jĭnràk luơi Pô bloh nau, sơ̆ng hũ du mơnih gơdrưh truh duh bruă Pô. ");
INSERT INTO cje_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Tŭ Yàng Jêsu mơhư̆ thơu Jăng hũ kơđòng aràng jàm bơjơ, Pô gài wơ̆ tơ c̆àr Galile. ");
INSERT INTO cje_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Pô luơi plơi-prŏng Nasaret, truh dò tơ plơi-prŏng Kapenaum, sa plơi-prŏng jĕ tơ gah ia-tơsì, lăm c̆àr-tơnah Sabulôn sơ̆ng Neptali. ");
INSERT INTO cje_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Bruă nư̆n tơbiă truh iơŭ yơu pơnuaĭ mơnih gơnuăr-hwơ̆r Êsai hũ đờm: ");
INSERT INTO cje_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Tơnah Sabulôn sơ̆ng Neptali, Jơlàn tơbiă tơ ia-tơsì, gah dih ia-sơdờng Jôđăn, C̆àr Galile buơl làng agàh — ");
INSERT INTO cje_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Buơl làng dò guh lăm anih kơnăm-mơsrư̆, Hũ 'buh pơnuaĭ sơrdah prŏng, Sơ̆ng du mơnih dò guh lăm c̆àr sơ̆ng tơ ala lơhui-bơngă pơnuaĭ mơtai, Hũ 'buh pơnuaĭ sơrdah pơsàng tơma.” ");
INSERT INTO cje_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Mư̆ng tŭ nư̆n, Yàng Jêsu tơma pơto-akhàn lài: “Buơl guhã păl mơbai prah-luơi glài-sơnoh bĕ, kơyoa Lơgăr Lơngì hũ truh jĕ bơjơ.” ");
INSERT INTO cje_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Lăm tŭ Yàng Jêsu nau rò gah ia-tơsì Galile, Pô 'buh dua aràng adơi-ai dih, la Simôn kŭng angăn la Pier, sơ̆ng adơi ñu la Andre. Buơl guñu dò trah jàl lăm ia-tơsì, kơyoa bruă phŭn buơl guñu la trah jàl mă akàn. ");
INSERT INTO cje_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Pô đờm sơ̆ng buơl guñu: “Tui bĕ Kơu, Kơu rơŭ ngă tơ buơl guhã tơbiă jiơ̆ng du mơnih trah jàl mơnih.” ");
INSERT INTO cje_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Buơl guñu luơi jàl mư bloh nau tui Pô. ");
INSERT INTO cje_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Mư̆ng anih nư̆n, nau atàh rơlau sa-sĭt tra, Pô 'buh dua aràng adơi-ai pơkơ̆n, la Jakơ, anà Sebede, sơ̆ng adơi ñu la Jăng. Dua aràng buơl guñu găm sơ̆ng ama drơi la Sebede tŭ nư̆n dò srồt jàl lăm gơlài. Pô iơu buơl guñu. ");
INSERT INTO cje_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Lăm tơk tŭ nư̆n mư, buơl guñu luơi gơlài sơ̆ng ama drơi bloh tui Pô. ");
INSERT INTO cje_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yàng Jêsu nau lăm abih c̆àr Galile, pơto-pơsài lăm du sàng pơtòm, pơto-akhàn Pơnuaĭ-Siàm Lơgăr Lơngì, sơ̆ng pơsồ-pơsaih abih tơgrơ̆ mơta lơ-ơ̆n lơngoh rơwă-sơkì tơ buơl làng. ");
INSERT INTO cje_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Pơnuaĭ tiơ̆ng-dơnài mư̆ng angăn Pô hũ đờm pơtiơ̆ng lăm abih c̆àr Siri. Aràng ba truh tơ Pô du mơnih lơ-ơ̆n lơngoh rơwă-sơkì, halài kơđòng lơ-ơ̆n ni pơđì dih, du mơnih kơđòng kơmlài ngă, mơnih kruă-hơnrui, mơnih mơtai tơkai-tơngàn; Pô pơsồ-pơsaih abih tơ buơl guñu. ");
INSERT INTO cje_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Mư̆ng c̆àr Galile, c̆àr Đekapôl, plơi-prŏng Jerusalem, c̆àr Juđe sơ̆ng c̆àr gah dih ia-sơdờng Jôđăn, buơl làng ŭr-ŭr ba gơŭ truh tui Pô. ");
INSERT INTO cje_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Tŭ 'buh tơrpuơl buơl làng lô, Yàng Jêsu đì tơ ngŏ c̆ơ̆. Tŭ Pô dò guh, du mơnih tui-mơgru truh jĕ. ");
INSERT INTO cje_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Pô pơh săp bloh đờm pơto lài: ");
INSERT INTO cje_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Lơngai-pơtuah tơ du mơnih siơŭ rơ'bah lăm hơtai-bơngă, Kơyoa Lơgăr Lơngì la găm sơ̆ng buơl guñu! ");
INSERT INTO cje_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Lơngai-pơtuah tơ du mơnih hia-c̆ŏ, Kơyoa rơŭ hũ pơluơ-pơrơngài! ");
INSERT INTO cje_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Lơngai-pơtuah tơ du mơnih lơnguh-lơngui, Kơyoa rơŭ hũ đồ-lĕng lơ̆n-tơnah! ");
INSERT INTO cje_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Lơngai-pơtuah tơ du mơnih lơpa-mơhau pơnuaĭ rĭng-tơpă, Kơyoa rơŭ hũ trơi tơ̆l! ");
INSERT INTO cje_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Lơngai-pơtuah tơ du mơnih hũ hơtai-hơtiàn anĭt-anăr, Kơyoa rơŭ hũ anĭt-anăr! ");
INSERT INTO cje_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Lơngai-pơtuah tơ du mơnih hũ hơtai-hơtiàn goh-sơc̆ih, Kơyoa rơŭ 'buh Yàng Pô Lơngì! ");
INSERT INTO cje_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Lơngai-pơtuah tơ du mơnih ngă tơ mơnih pơkơ̆n hơlàr-tămsòr, Kơyoa rơŭ hũ angăn la anà Yàng Pô Lơngì! ");
INSERT INTO cje_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Lơngai-pơtuah tơ du mơnih kŏng mă-pơkơŭ kơyoa pơnuaĭ rĭng-tơpă, Kơyoa Lơgăr Lơngì la găm sơ̆ng buơl guñu! ");
INSERT INTO cje_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Lơngai-pơtuah tơ buơl guhã tŭ kơyoa mư̆ng Kơu bloh kŏng aràng pơtăt-pơmơlơu, mă-pơkơŭ, sơ̆ng mă tơgrơ̆ pơnuaĭ mơsak-jơhà đờm yă-bơdah tơ buơl guhã. ");
INSERT INTO cje_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Sờh-sài bĕ, sơ̆ng abih hơtai-hơtiàn sờh-sờr, kơyoa phơ̆n mơyòm-brơi pioh tơ buơl guhã dò tơ ngŏ lơngì la prŏng biă; kơyoa aràng kŭng hũ mă-pơkơŭ du mơnih gơnuăr-hwơ̆r Yàng dơlhơu tơ buơl guhã yơu nư̆n rơi.” ");
INSERT INTO cje_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Buơl guhã la sra tơ dun-ya, bloh yah sra lơhiă kơya 'bă, nư̆n rơŭ mă hơgĕ ngă tơ ñu 'bă wơ̆ jiơ̆ng? Sra nư̆n 'buh angui hơgĕ jiơ̆ng tra, mĭn păl prah luơi tơ agàh tô aràng juă tơ ala tơkai. ");
INSERT INTO cje_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Buơl guhã la pơnuaĭ sơrdah tơ dun-ya. Sa boh plơi-prŏng dò tơ ngŏ c̆ơ̆ nư̆n 'buh rơgơi kŏng ac̆ĭng-tơrđơŭ jiơ̆ng. ");
INSERT INTO cje_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Kŭng 'buh aràng sơi tuĭ apui-đèng bloh nư̆n daŭ tơ ala thŭng, bloh la daŭ tơ ngŏ tơkai apui-đèng, tô ñu pơsàng sơrdah tơ abih tơgrơ̆ mơnih lăm sàng. ");
INSERT INTO cje_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Pơnuaĭ sơrdah buơl guhã kŭng păl pơsàng sơrdah tơ anaŭ aràng yơu nư̆n rơi, tô buơl guñu 'buh tơgrơ̆ bruă siàm buơl guhã ngă, bloh mơyòm-pơglòng Ama buơl guhã dò tơ ngŏ lơngì.” ");
INSERT INTO cje_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Juơi sơnư̆ng Kơu truh tô ngă pơlơhiă pơnuaĭ adăt-adia halài pơnuaĭ gơnuăr-hwơ̆r. Kơu truh, 'buh iơŭ tô ngă pơlơhiă, bloh tô ngă wĭl-tơ̆l. ");
INSERT INTO cje_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Kơyoa biă, Kơu đờm sơ̆ng buơl guhã, dơlhơu tŭ lơngì-tơsì tơnah-rơya nau rơlau thĭt, nư̆n sa nàl, sa c̆reh lăm pơnuaĭ adăt-adia kŭng 'buh nau rơlau jiơ̆ng, tơ̆l truh tơ tŭ abih tơgrơ̆ bruă hũ wĭl-tơ̆l. ");
INSERT INTO cje_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Yơu nư̆n, yah aràng sơi pơlơhiă sa pơnuaĭ tìt rơlau abih lăm du pơnuaĭ adăt-pơđăr ni, sơ̆ng pơto aràng ngă yơu nư̆n, mơnih nư̆n rơŭ kŏng angăn la mơnih tìt rơlau abih lăm Lơgăr Lơngì. Dò aràng sơi păng-rơmiă ngă tui du pơnuaĭ adăt-pơđăr ni sơ̆ng pơto mơnih pơkơ̆n ngă tui yơu nư̆n rơi, mơnih nư̆n rơŭ hũ angăn la prŏng lăm Lơgăr Lơngì. ");
INSERT INTO cje_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Kơyoa Kơu đờm tơ buơl guhã thơu: Yah pơnuaĭ rĭng-tơpă buơl guhã 'buh rơlau tơ pơnuaĭ rĭng-tơpă du mơnih gơnuăr-pơto pơnuaĭ adăt-adia sơ̆ng mơnih Pharisi, nư̆n buơl guhã 'buh rơgơi tơma lăm Lơgăr Lơngì jiơ̆ng. ");
INSERT INTO cje_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Buơl guhã hũ mơhư̆ pơnuaĭ đờm pơto tơ mơnih rài yau lài: ‘Hã juơi pơmơtai mơnih; sơ̆ng, yah aràng sơi pơmơtai mơnih, nư̆n iơŭ păl kŏng ba tơbiă tơ anih c̆ahrơña.’ ");
INSERT INTO cje_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Bloh Kơu đờm sơ̆ng buơl guhã: Aràng sơi anok hơtai tơ adơi-ai drơi, nư̆n iơŭ păl kŏng ba tơbiă tơ anih c̆ahrơña. Aràng sơi puaĭ c̆ơ-ua adơi-ai drơi la ‘gơla pơtò,’ nư̆n iơŭ păl kŏng ba tơbiă tơ anaŭ Tơrpuơl Gơnuăr Apăn-Akŏ c̆ahrơña. Aràng sơi c̆ơ-ua adơi-ai drơi la ‘mòih-hơnrui,’ nư̆n iơŭ păl kŏng apui rơhồng-ala ngă glài. ");
INSERT INTO cje_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Kơyoa nư̆n, tŭ hã apăn phơ̆n c̆ĕ-pơyơ̆r duh-dơlbăt tô pơyă anih sơbàn duh-dơlbăt, bloh sơdơ̆r wơ̆ drơi hũ pơnuaĭ hơgĕ 'buh hơlàr-siàm sơ̆ng mơnih adơi-ai lơi, ");
INSERT INTO cje_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","nư̆n luơi bĕ phơ̆n c̆ĕ-pơyơ̆r duh-dơlbăt tơ anaŭ sơbàn duh-dơlbăt, gài mơrai wơ̆ ngă pơhơlàr-siàm sơ̆ng adơi-ai drơi dơlhơu ka, bloh nư̆n truh bĕ tô pơyă phơ̆n c̆ĕ-pơyơ̆r duh-dơlbăt. ");
INSERT INTO cje_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Tŭ hã nau jơlàn sơ̆ng mơnih tămdră sơ̆ng drơi, păl sơmăr ngă pơhơlàr-siàm bĕ sơ̆ng mơnih nư̆n; yah 'buh ơu nư̆n, mơnih nư̆n rơŭ jào hã tơ anaŭ kwăng c̆ahrơña, kwăng c̆ahrơña jào hã tơ buơl lĭng dò tơ ala gơnuăr ñu, sơ̆ng hã rơŭ păl kŏng aràng krơ̆ jàm. ");
INSERT INTO cje_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Iơŭ biă, Kơu đờm sơ̆ng hã, hã bơ-yàr dò siơŭ sa xu priă, nư̆n rơŭ 'buh tơbiă klàh mư̆ng anih jàm jiơ̆ng. ");
INSERT INTO cje_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Buơl guhã hũ mơhư̆ pơnuaĭ đờm pơto: ‘Hã juơi ngă glài klĕ sơdiŭ-aràng pơsàng-gơŭ.’ ");
INSERT INTO cje_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Bloh Kơu đờm tơ buơl guhã thơu: Yah aràng sơi c̆ơ tơ mơnih kơmơi bloh hũ hơtai-hơtiàn hàm-ư̆ng, nư̆n lăm hơtai-hơtiàn hũ ngă glài klĕ sơdiŭ-aràng pơsàng-gơŭ sơ̆ng mơnih nư̆n bơjơ. ");
INSERT INTO cje_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Yah mơta gah hơnuă ngă tơ hã sŭng glài, nư̆n lơ-iok bĕ bloh prah ñu atàh mư̆ng hã; kơyoa yah hã lơhiă sa pơ-ơnah rùp-phàp, dò siàm rơlau la abih sa boh rùp-phàp păl kŏng prah tơma lăm brŏng-apui. ");
INSERT INTO cje_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Yah tơngàn gah hơnuă hã ngă tơ hã sŭng glài, nư̆n koh bĕ sơ̆ng prah ñu atàh mư̆ng hã; kơyoa yah hã kŏng lơhiă sa pơ-ơnah rùp-phàp, dò siàm rơlau la abih sa boh rùp-phàp păl kŏng prah lăm brŏng-apui. ");
INSERT INTO cje_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Kŭng hũ pơnuaĭ pơto lài: ‘Aràng sơi pơkloh luơi sơdiŭ, nư̆n păl brơi bĕ tơ sơdiŭ sa blah bơ-àr pơkloh luơi gơŭ.’ ");
INSERT INTO cje_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Bloh Kơu đờm sơ̆ng buơl guhã: Aràng sơi pơkloh luơi sơdiŭ, bloh 'buh iơŭ kơyoa glài klĕ sơdiŭ-aràng pơsàng-gơŭ, nư̆n hũ ngă tơ sơdiŭ tơbiă jiơ̆ng mơnih klĕ sơdiŭ-aràng pơsàng-gơŭ; sơ̆ng aràng sơi khiăng sơ̆ng mơnih kơmơi kŏng aràng pơkloh, nư̆n kŭng sŭng glài klĕ sơdiŭ-aràng pơsàng-gơŭ rơi. ");
INSERT INTO cje_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Buơl guhã hũ mơhư̆ pơnuaĭ đờm pơto tơ mơnih rài yau lài: ‘Hã juơi tơpah-sri lơ̆r, bloh sơ̆ng Yàng, hã păl ngă wĭl-tơ̆l pơnuaĭ tơpah-sri drơi.’ ");
INSERT INTO cje_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Bloh Kơu đờm sơ̆ng buơl guhã: Juơi tơpah-sri hơgĕ jơ. Juơi sơc̆ê tơ lơngì bloh tơpah-sri, kơyoa la sơbàn Yàng Pô Lơngì. ");
INSERT INTO cje_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Juơi sơc̆ê tơ lơ̆n bloh tơpah-sri, kơyoa nư̆n la gơnŭl tơ ala tơkai Yàng Pô Lơngì. Juơi sơc̆ê tơ plơi-prŏng Jerusalem bloh tơpah-sri, kơyoa nư̆n la plơi-prŏng Pơtau prŏng. ");
INSERT INTO cje_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Kŭng juơi sơc̆ê tơ akŏ hã bloh tơpah-sri, kơyoa rùp-phŭn hã 'buh rơgơi ngă tơ sa dĕt 'bù tơbiă kò halài jù jiơ̆ng. ");
INSERT INTO cje_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Bloh iơŭ nư̆n đờm la iơŭ, 'buh iơŭ nư̆n đờm la 'buh iơŭ. Đờm pơtơma-pơtơbiă pơnuaĭ hơgĕ pơkơ̆n la kơyoa mư̆ng kơmlài mơsak-jơhà bloh tơbiă. ");
INSERT INTO cje_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Buơl guhã hũ mơhư̆ pơnuaĭ đờm pơto lài: ‘Mơta bơ-yàr mơta, tơgơi bơ-yàr tơgơi.’ ");
INSERT INTO cje_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Bloh Kơu đờm sơ̆ng buơl guhã: Juơi tămdră sơ̆ng mơnih mơsak-jơhà. Tơrblơ̆ wơ̆, yah aràng sơi pah 'bò gah hơnuă, nư̆n brơi bĕ găm 'bò gah dih tơ mơnih nư̆n. ");
INSERT INTO cje_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Yah aràng sơi khiăng yă hã tô mă ào dơrlăm, nư̆n luơi bĕ buơl guñu mă lơngò găm ào agàh. ");
INSERT INTO cje_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Yah aràng sơi khiăng mă hã nau sa kơsồ, nư̆n nau bĕ sơ̆ng mơnih nư̆n dua kơsồ. ");
INSERT INTO cje_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Aràng sơi yòng, brơi bĕ; aràng sơi khiăng ơñàm phơ̆n hã, nư̆n juơi kơmlah. ");
INSERT INTO cje_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Buơl guhã hũ mơhư̆ pơnuaĭ đờm pơto lài: ‘Rơnăm bĕ tơ mơnih gơŭ sa plơi adơi sa 'băng, sơ̆ng mơbai bĕ tơ mơnih mơbai-tămdră.’ ");
INSERT INTO cje_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Bloh Kơu đờm sơ̆ng buơl guhã: Rơnăm bĕ tơ mơnih mơbai-tămdră sơ̆ng iơu-lài tơ mơnih mă-pơkơŭ buơl guhã, ");
INSERT INTO cje_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","tô buơl guhã hũ tơbiă jiơ̆ng anà Ama buơl guhã dò tơ ngŏ lơngì; kơyoa Pô brơi ia-hơrơi đì tơgồ kơc̆rà sơrdah tơ ngŏ mơnih mơsak-jơhà kŭng yơu mơnih siàm, brơi hơjàn tơ mơnih rĭng-tơpă kŭng yơu mơnih 'buh rĭng-tơpă. ");
INSERT INTO cje_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Kơyoa yah buơl guhã mĭn rơnăm tơgrơ̆ mơnih rơnăm drơi, nư̆n hũ hơgĕ păl mơyòm rơi? Du mơnih rì-mă jia 'buh ngă yơu nư̆n ơu? ");
INSERT INTO cje_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Yah buơl guhã mĭn tơnia c̆uă-rơwăng buơl adơi-ai drơi soh, nư̆n hũ rơlau hơgĕ tơ aràng rơi ơu? Du buơl làng agàh 'buh ngă yơu nư̆n ơu? ");
INSERT INTO cje_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Yơu nư̆n, buơl guhã păl tơbiă jiơ̆ng wĭl-tơ̆l, yơu Ama buơl guhã dò tơ ngŏ lơngì la Pô wĭl-tơ̆l.” ");
INSERT INTO cje_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“C̆ơ-kơrmăp bĕ, tŭ ngă bruă siàm anĭt-dŏng, juơi mĭn tô ràng-pơmơyeh tơ anaŭ tơgrơ̆ mơnih. Yah 'buh ơu nư̆n, buơl guhã rơŭ 'buh hũ phơ̆n mơyòm-brơi hơgĕ mư̆ng Ama buơl guhã dò tơ ngŏ lơngì ơu. ");
INSERT INTO cje_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Yơu nư̆n, tŭ buơl guhã ngă bruă siàm anĭt-dŏng, juơi poh c̆èng pờng sơgơ̆r tơ anaŭ drơi yơu buơl mơnih hơtai-hơtiàn mơthĭ-lơ̆r jiăng ngă lăm sàng pơtòm sơ̆ng tơ agàh jơlàn rơya, tô hũ aràng đờm mơyòm. Iơŭ biă, Kơu đờm sơ̆ng buơl guhã, du mơnih nư̆n hũ đồ-mă phơ̆n mơyòm-brơi buơl guñu bơjơ. ");
INSERT INTO cje_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Bloh tŭ hã ngă bruă siàm anĭt-dŏng, juơi brơi tơngàn gah ơñiau thơu tơngàn gah hơnuă ngă hơgĕ, ");
INSERT INTO cje_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","tô bruă siàm anĭt-dŏng hã ngă hũ tơrđơŭ-tơrđe; sơ̆ng Ama hã, la Pô 'buh lăm anih tơrđơŭ-tơrđe, rơŭ brơi phơ̆n mơyòm-brơi tơ hã.” ");
INSERT INTO cje_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Tŭ buơl guhã iơu-lài, juơi ngă yơu buơl mơnih hơtai-hơtiàn mơthĭ-lơ̆r. Kơyoa buơl guñu khiăng dò dơ̆ng iơu-lài tơkrah sàng pơtòm sơ̆ng tơ du anih akiăng jơlàn rơya, mĭn tô tơgrơ̆ mơnih c̆ơ 'buh. Iơŭ biă, Kơu đờm sơ̆ng buơl guhã, du mơnih nư̆n hũ đồ-mă phơ̆n mơyòm-brơi buơl guñu bơjơ. ");
INSERT INTO cje_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Bloh tŭ hã iơu-lài, tơma bĕ lăm adŭ, krơ̆ bơh 'băng wơ̆, bloh nư̆n iơu-lài sơ̆ng Ama hã, Pô dò lăm anih tơrđơŭ-tơrđe; sơ̆ng Ama hã la Pô 'buh lăm anih tơrđơŭ-tơrđe, rơŭ brơi phơ̆n mơyòm-brơi tơ hã. ");
INSERT INTO cje_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Tŭ buơl guhã iơu-lài, juơi đờm rơlaŭ nau rơlaŭ mơrai 'buh kwơ yơu du buơl làng agàh; kơyoa buơl guñu sơnư̆ng yah đờm lô nư̆n hũ Yàng păng. ");
INSERT INTO cje_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Kơyoa nư̆n buơl guhã juơi ngă yơu buơl guñu; kơyoa Ama buơl guhã hũ thơu buơl guhã păl c̆àng hũ pơnuaĭ hơgĕ, dơlhơu tơ tŭ buơl guhã iơu yòng sơ̆ng Pô bơjơ. ");
INSERT INTO cje_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Yơu nư̆n, buơl guhã iơu-lài bĕ yơu ni: ‘Khoai Ama buơl dơlhă dò tơ ngŏ lơngì; Angăn Ama hũ Sơc̆ih-Sri; ");
INSERT INTO cje_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Lơgăr Ama truh, Hơtai Ama hũ jiơ̆ng, lăm ala lơ̆n kŭng yơu tơ ngŏ lơngì. ");
INSERT INTO cje_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Yòng brơi buơl dơlhă hơrơi ni phơ̆n-kơya 'bơ̆ng tơ̆l hơrơi. ");
INSERT INTO cje_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Yòng anĭt toh-luơi glài-sơnoh tơ buơl dơlhă, Yơu buơl dơlhă kŭng anĭt toh-luơi tơ du mơnih hũ sŭng glài sơ̆ng buơl dơlhă. ");
INSERT INTO cje_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Yòng juơi luơi buơl dơlhă kơđòng pơnuaĭ pơluơ-ơñiai, Bloh dŏng buơl dơlhă klàh mư̆ng pơnuaĭ mơsak-jơhà! (Kơyoa lơgăr, gơnăp-gơnuăr, sơ̆ng màng-kơc̆rà, dò abih găm sơ̆ng Ama rài pơdò rài 'buh luĭ. Amen.)’ ");
INSERT INTO cje_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Kơyoa yah buơl guhã anĭt toh-luơi tơgrơ̆ pơnuaĭ sŭng tơ aràng, nư̆n Ama buơl guhã dò tơ ngŏ lơngì kŭng rơŭ anĭt toh-luơi tơ buơl guhã. ");
INSERT INTO cje_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Bloh yah buơl guhã 'buh anĭt toh-luơi pơnuaĭ sŭng tơ aràng, nư̆n Ama buơl guhã dò tơ ngŏ lơngì kŭng rơŭ 'buh anĭt toh-luơi pơnuaĭ sŭng tơ buơl guhã.” ");
INSERT INTO cje_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Tŭ buơl guhã wèr 'bơ̆ng, juơi ngă 'bò mơta jruh-jrui yơu buơl mơnih hơtai-hơtiàn mơthĭ-lơ̆r, kơyoa buơl guñu khiăng ngă 'bò mơta yơu nư̆n tô tơgrơ̆ mơnih thơu buơl guñu wèr 'bơ̆ng. Iơŭ biă, Kơu đờm sơ̆ng buơl guhã, du mơnih nư̆n hũ đồ-mă phơ̆n mơyòm-brơi buơl guñu bơjơ. ");
INSERT INTO cje_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Bloh tŭ hã wèr 'bơ̆ng, lŭ bĕ mơñà tơ akŏ, sơ̆ng pài goh 'bò mơta, ");
INSERT INTO cje_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","tô aràng 'buh thơu hã dò wèr 'bơ̆ng, bloh mĭn Ama hã, la Pô dò lăm anih tơrđơŭ-tơrđe; sơ̆ng Ama hã, la Pô 'buh lăm anih tơrđơŭ-tơrđe, rơŭ brơi phơ̆n mơyòm-brơi tơ hã.” ");
INSERT INTO cje_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Buơl guhã juơi pơtòm-pioh tơ drơi du phơ̆n-bơna lăm ala lơ̆n, la anih hũ mŏ-koh, tơ̆ng-reh, đĭ 'bơ̆ng ngă lơhiă sơ̆ng mơnih blơ̆ 'bloh dơrñàng bloh mă. ");
INSERT INTO cje_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Bloh păl pơtòm-pioh bĕ tơ drơi du phơ̆n-bơna tơ ngŏ lơngì, la anih 'buh hũ mŏ-koh, tơ̆ng-reh, đĭ 'bơ̆ng ngă lơhiă, sơ̆ng kŭng 'buh hũ mơnih blơ̆ 'bloh dơrñàng bloh mă. ");
INSERT INTO cje_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kơyoa phơ̆n-bơna buơl guhã dò anih lơi, nư̆n hơtai-hơtiàn buơl guhã kŭng dò anih nư̆n.” ");
INSERT INTO cje_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Mơta la apui-đèng rùp-phàp. Yơu nư̆n, yah mơta hã sơrdah, nư̆n abih rùp-phàp hã rơŭ sơrdah. ");
INSERT INTO cje_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Bloh yah mơta hã jơhà, nư̆n abih rùp-phàp hã rơŭ mơsrư̆-kơnăm. Yơu nư̆n, yah pơnuaĭ sơrdah lăm hã mĭn la mơsrư̆-kơnăm, nư̆n pơnuaĭ mơsrư̆-kơnăm ni rơŭ prŏng thơu kàr lơi!” ");
INSERT INTO cje_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“'Buh aràng sơi hũ rơgơi ngă hơlŭn dua aràng pô, kơyoa rơŭ mơbai mơnih ni bloh rơnăm mơnih dih, halài rơŭ c̆ơ prŏng-màng tơ mơnih ni bloh c̆ơ 'buh sơ̆p tơ mơnih dih. Buơl guhã 'buh rơgơi găm duh bruă Yàng Pô Lơngì bloh găm duh bruă jền-priă jiơ̆ng. ");
INSERT INTO cje_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Kơyoa nư̆n, Kơu đờm sơ̆ng buơl guhã: Juơi kơyoa mư̆ng pơnuaĭ hơdiŭ drơi bloh sơnư̆ng kơ-ù păl 'bơ̆ng hơgĕ, mơñŭm hơgĕ; juơi kơyoa mư̆ng rùp-phàp bloh sơnư̆ng kơ-ù păl c̆ù hơgĕ. Pơnuaĭ hơdiŭ 'buh c̆ơk-màng rơlau tơ phơ̆n 'bơ̆ng, rùp-phàp 'buh c̆ơk-màng rơlau tơ khăn-ào c̆ù ơu? ");
INSERT INTO cje_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","C̆ơ bĕ jơi c̆ĭm lơngì. Guñu 'buh drà, 'buh yuă, kŭng 'buh pơtòm-pioh lăm bŭng, nư̆n bloh Ama buơl guhã tơ ngŏ lơngì sơđaŭ ròng guñu. Buơl guhã 'buh c̆ơk-màng rơlau tơ jơi c̆ĭm ơu? ");
INSERT INTO cje_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Hũ aràng sơi lăm buơl guhã, gơnừm tơ sơnư̆ng kơ-ù bloh ngă tơ rài hơdiŭ drơi hũ atàh rơlau sa-sĭt tŭ rơi? ");
INSERT INTO cje_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Mư̆ng pơ-ơnah khăn-ào c̆ù kŭng yơu nư̆n rơi, kơđa hơgĕ buơl guhã sơnư̆ng kơ-ù ngă hơgĕ? C̆ơ sơ'buai bĕ du bơnga-glai lăm 'blàng hơma c̆ă tơgồ hơyơu lơi; guñu 'buh ngă bruă gleh-glăr, kŭng 'buh c̆ăr-tơlơi mơñàm-mơrài, ");
INSERT INTO cje_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","bloh Kơu đờm sơ̆ng buơl guhã, yah pơtau Salômôn màng-mơda truh kàr lơi, kŭng 'buh hũ c̆ù mơkrư yơu sa bơnga lơi lăm du bơnga nư̆n ơu rơi. ");
INSERT INTO cje_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Yơu nư̆n, ơ du mơnih tơkì pơnuaĭ păng-tui dih, yah jơi bơnga-rơ̆ lăm 'blàng hơma, la jơi ni dò hơdiŭ bơgi prah lăm gìng, bloh Yàng Pô Lơngì dò brơi guñu c̆ù mơkrư yơu nư̆n, tơ-ài la buơl guhã! ");
INSERT INTO cje_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Kơyoa nư̆n, buơl guhã juơi sơnư̆ng kơ-ù bloh đờm lài: Buơl gudrơi rơŭ 'bơ̆ng hơgĕ? Mơñŭm hơgĕ? C̆ù hơgĕ? ");
INSERT INTO cje_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Kơyoa abih tơgrơ̆ pơnuaĭ ni, du buơl làng agàh sơđaŭ mĭt tui duah, sơ̆ng Ama buơl guhã tơ ngŏ lơngì hũ thơu buơl guhã păl c̆àng hũ du pơnuaĭ nư̆n bơjơ. ");
INSERT INTO cje_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Bloh dơlhơu biă, tui duah bĕ lơgăr Yàng Pô Lơngì sơ̆ng pơnuaĭ rĭng-tơpă Pô, bloh nư̆n Pô rơŭ brơi pơtơ̆l tơ buơl guhã tơgrơ̆ pơnuaĭ nư̆n rơi. ");
INSERT INTO cje_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Yơu nư̆n, buơl guhã juơi sơnư̆ng kơ-ù mư̆ng hơrơi bơgi; kơyoa hơrơi bơgi rơŭ sơnư̆ng-rơc̆ăng mư̆ng bruă hơrơi bơgi. Pơnuaĭ gleh-glăr hơrơi lơi tơ̆l tơ hơrơi nư̆n.” ");
INSERT INTO cje_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Juơi c̆ahrơña aràng sơi, tô buơl guhã 'buh kơđòng c̆ahrơña. ");
INSERT INTO cje_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Kơyoa buơl guhã c̆ahrơña aràng hơyơu lơi, nư̆n buơl guñu kŭng c̆ahrơña buơl guhã yơu nư̆n rơi. Buơl guhã wăl tơ aràng kàr lơi, nư̆n buơl guñu kŭng rơŭ wăl wơ̆ tơ buơl guhã kàr nư̆n rơi. ");
INSERT INTO cje_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Hơyơu hã c̆ơ 'buh thŭl lăm mơta adơi-ai drơi, bloh 'bu 'buh kơyơu gih lăm mơta drơi? ");
INSERT INTO cje_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Hơyơu hã khĭn đờm sơ̆ng adơi-ai hã lài: ‘Luơi dơlhă mă thŭl tơbiă mư̆ng mơta sơ-ai,’ lăm tŭ kơyơu gih sơđaŭ dò lăm mơta drơi? ");
INSERT INTO cje_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ơ mơnih hơtai-hơtiàn mơthĭ-lơ̆r! Dơlhơu biă mă bĕ kơyơu gih klàh mư̆ng mơta hã, bloh nư̆n ka 'buh loh-làng, tô mă thŭl klàh mư̆ng mơta adơi-ai drơi jiơ̆ng.” ");
INSERT INTO cje_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Juơi brơi tơ asơu du phơ̆n sơc̆ih-sri, kŭng juơi prah pơtơu c̆ŭng c̆ơk-màng drơi tơ anaŭ pơbui, huơĭ guñu rơŭ juă tơ ala tơkai, sơ̆ng gài wơ̆ kĕ-hĕt buơl guhã. ");
INSERT INTO cje_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Yòng bĕ, rơŭ hũ; duah bĕ, rơŭ tòm; teh bĕ, bơh 'băng rơŭ pơh tơ buơl guhã. ");
INSERT INTO cje_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kơyoa yah aràng sơi yòng nư̆n hũ; aràng sơi duah nư̆n tòm; sơ̆ng aràng sơi teh bơh 'băng nư̆n hũ pơh. ");
INSERT INTO cje_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Hũ aràng sơi lăm buơl guhã, tŭ anà drơi yòng pah, bloh brơi tơ ñu pơtơu ơu? ");
INSERT INTO cje_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Halài anà drơi yòng akàn, bloh brơi ala tơ ñu ơu? ");
INSERT INTO cje_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Yơu nư̆n, yah buơl guhã la mơnih jơhà bloh dò thơu brơi tơ anà drơi du phơ̆n siàm, tơ-ài la Ama buơl guhã dò tơ ngŏ lơngì bloh 'buh brơi du phơ̆n siàm tơ du mơnih yòng sơ̆ng Pô ơu? ");
INSERT INTO cje_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Yơu nư̆n, abih tơgrơ̆ pơnuaĭ hơgĕ buơl guhã khiăng aràng ngă tơ drơi, nư̆n kŭng ngă bĕ pơnuaĭ nư̆n tơ buơl guñu, kơyoa nư̆n la pơnuaĭ adăt-adia sơ̆ng pơnuaĭ gơnuăr-hwơ̆r.” ");
INSERT INTO cje_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Tơma bĕ bơh 'băng tìt, kơyoa bơh 'băng lơnàng sơ̆ng jơlàn prŏng nư̆n ba truh pơnuaĭ pơluĭ-pơlơhiă; hũ lô mơnih nau tơma lăm jơlàn nư̆n. ");
INSERT INTO cje_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Bloh bơh 'băng tìt sơ̆ng jơlàn gơniă ba truh pơnuaĭ hơdiŭ, mơnih duah hũ nư̆n tơkì.” ");
INSERT INTO cje_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Păl c̆ơ-kơrhia bĕ mư̆ng du mơnih gơnuăr-hwơ̆r lơ̆r. Buơl guñu truh sơ̆ng buơl guhã c̆ơ gah agàh lơnguh-lơngui siàm yơu abo, bloh gah dơrlăm, buơl guñu la asơu sĭng mơsak-jơhà jiăng kĕ-hĕt. ");
INSERT INTO cje_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Buơl guhã rơŭ kràn-thơu buơl guñu jiơ̆ng kơyoa mư̆ng bruă ngă pơnuaĭ đờm buơl guñu, 'buh krơi yơu c̆ơ boh nư̆n thơu kơyơu. 'Buh aràng sơi pĕ boh ño lăm anih puk druơi, halài pĕ boh hra lăm anih puk druơi kòng-lai. ");
INSERT INTO cje_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Yơu nư̆n, yah kơyơu siàm nư̆n tơbiă boh siàm, kơyơu jơhà nư̆n tơbiă boh jơhà. ");
INSERT INTO cje_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Kơyơu siàm 'buh rơgơi tơbiă boh jơhà, kŭng yơu kơyơu jơhà 'buh rơgơi tơbiă boh siàm. ");
INSERT INTO cje_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Yah kơyơu lơi 'buh tơbiă boh siàm nư̆n păl kŏng dròm sơ̆ng prah lăm apui. ");
INSERT INTO cje_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Yơu nư̆n, c̆ơ mư̆ng bruă ngă pơnuaĭ đờm bloh kràn-thơu jiơ̆ng aràng sơi la mơnih gơnuăr-hwơ̆r lơ̆r, 'buh krơi yơu gơnừm tơ bơnga boh bloh buơl guhã rơŭ kràn-thơu jiơ̆ng buơl guñu. ");
INSERT INTO cje_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","'Buh iơŭ yah aràng sơi đờm sơ̆ng Kơu lài: ‘Khoai Yàng! Khoai Yàng!’ la hũ tơma lăm Lơgăr Lơngì ơu, bloh mĭn mơnih lơi ngă tui hơtai-khiăng Ama Kơu dò tơ ngŏ lơngì soh. ");
INSERT INTO cje_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Lăm hơrơi nư̆n, lô mơnih rơŭ đờm sơ̆ng Kơu lài: ‘Khoai Yàng! khoai Yàng! 'Buh iơŭ buơl dơlhă hũ mă angăn Yàng bloh đờm hwơ̆r, mă angăn Yàng bloh pơtrơh kơmlài, sơ̆ng mă angăn Yàng bloh ngă lô pơnuaĭ c̆rih ơu?’ ");
INSERT INTO cje_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Tŭ nư̆n, Kơu rơŭ đờm loh-làng sơ̆ng buơl guñu lài: ‘Ơ buơl mơnih ngă pơnuaĭ mơsak-jơhà, Kơu 'buh tŭ lơi thơu buơl guhã, nau bĕ mư tô tơrđơŭ mư̆ng mơta Kơu!’” ");
INSERT INTO cje_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Yơu nư̆n, aràng sơi păng sơ̆ng ngă tui du pơnuaĭ Kơu đờm ni, nư̆n mơhiơ̆ yơu sa aràng mơnih jak-khờh, bơ̆ sàng drơi tơ ngŏ pơtơu prŏng. ");
INSERT INTO cje_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Yah hũ hơjàn tuh trŭn, ia soa, sơ̆ng rơbù angĭn wơh khăng, sàng nư̆n sơđaŭ dò dơ̆ng kơjăp, kơyoa hũ bơ̆ tơ ngŏ pơtơu prŏng. ");
INSERT INTO cje_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Aràng sơi păng pơnuaĭ Kơu đờm ni bloh 'buh ngă tui, nư̆n mơhiơ̆ yơu mơnih bơrngư̆l-gơla, bơ̆ sàng drơi tơ ngŏ lơ̆n c̆uah. ");
INSERT INTO cje_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Tŭ hơjàn tuh trŭn, ia soa truh, rơbù angĭn wơh khăng, sàng nư̆n rơŭ jơrlơh-tơrlŭng abih, sơ̆ng jơrlơh-tơrlŭng traŭ biă.” ");
INSERT INTO cje_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Hơdơi tŭ Yàng Jêsu đờm du pơnuaĭ nư̆n bơjơ, buơl làng mă ngă c̆rih-takơtuă mư̆ng pơnuaĭ pơto-pơsài Pô. ");
INSERT INTO cje_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Kơyoa Pô pơto hũ baŭ gơnăp-gơnuăr, bloh 'buh iơŭ yơu du mơnih gơnuăr-pơto pơnuaĭ adăt-adia buơl guñu pơto ơu. ");
INSERT INTO cje_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Tŭ Yàng Jêsu sơtơŭ trŭn mư̆ng c̆ơ̆, hũ tơrpuơl buơl làng lô biă nau tui Pô. ");
INSERT INTO cje_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Dih, hũ sa aràng mơnih dŭn truh c̆ĕ-dơlbăt tơ anaŭ Pô sơ̆ng đờm: “Khoai Yàng, yah Yàng khiăng, Yàng hũ rơgơi pơsồ tơ dơlhă hũ goh.” ");
INSERT INTO cje_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yàng Jêsu yơ̆r tơngàn tŭp mơnih dŭn sơ̆ng đờm: “Kơu khiăng, pơsồ goh bĕ!” Lăm tơk tŭ nư̆n mư, mơnih dŭn hũ goh. ");
INSERT INTO cje_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yàng Jêsu đờm kơkơi-pơđăr mơnih nư̆n: “C̆ơ-kơrhia bĕ, juơi đờm hơgĕ sơ̆ng aràng sơi, bloh nau bĕ truh pơto rùp sơ̆ng mơnih gơnuăr pơyă phơ̆n duh-dơlbăt, sơ̆ng pơyă phơ̆n c̆ĕ-pơyơ̆r duh-dơlbăt tui yơu Môise hũ pơto pơđăr, tô ngă grơh tơ buơl guñu.” ");
INSERT INTO cje_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Tŭ Yàng Jêsu tơma lăm plơi-prŏng Kapenaum, hũ sa aràng mơnih apăn-akŏ sa rơtùh lĭng truh tòm Pô sơ̆ng yòng lơkơu: ");
INSERT INTO cje_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Ơ Yàng, mơnih hơlŭn-hơlă dơlhă kơđòng lơ-ơ̆n mơtai tơkai-tơngàn, dò đih piăm lăm sàng, pơđì-pơđoa biă.” ");
INSERT INTO cje_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yàng Jêsu đờm: “Kơu rơŭ truh, pơsồ-pơsaih tơ ñu.” ");
INSERT INTO cje_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Mơnih apăn-akŏ sa rơtùh lĭng đờm sơđồ lài: “Khoai Yàng, dơlhă 'buh iơŭ păl tô rò Pô tơma lăm sàng dơlhă ơu, bloh mĭn yòng Pô đờm sa pơnuaĭ soh, nư̆n mơnih hơlŭn-hơlă dơlhă rơŭ hũ pơsồ-pơsaih. ");
INSERT INTO cje_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Kơyoa rùp-phŭn dơlhă kŭng dò tơ ala gơnuăr mơnih pơkơ̆n, sơ̆ng dơlhă kŭng hũ lĭng-klàng dò tơ ala gơnuăr dơlhă rơi; dơlhă đờm pơđăr mơnih ni: ‘Nau bĕ’, nư̆n ñu nau; pơđăr mơnih dih: ‘Truh bĕ’, nư̆n ñu truh; halài đờm pơđăr mơnih hơlŭn-hơlă dơlhă lài: ‘Ngă bĕ bruă ni’, nư̆n ñu ngă.” ");
INSERT INTO cje_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Mơhư̆ yơu nư̆n, Yàng Jêsu mă ngă krơi-takơtuă, bloh đờm sơ̆ng du mơnih nau tui Pô lài: “Iơŭ biă, Kơu đờm sơ̆ng buơl guhã, Kơu ka 'buh aràng sơi lăm buơl làng Israel hũ pơnuaĭ păng-tui prŏng yơu nư̆n. ");
INSERT INTO cje_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Kơu đờm tơ buơl guhã thơu: Mư̆ng gah ia-hơrơi tơgồ, mư̆ng gah ia-hơrơi tơma, lô mơnih rơŭ truh dò guh mơñŭm 'bơ̆ng găm sơ̆ng Abraham, Isak, Jakôp, lăm Lơgăr Lơngì. ");
INSERT INTO cje_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Bloh du mơnih hũ angăn la anà lơgăr-phŭn rơŭ kơđòng prah tơ agàh anih kơnăm-mơsrư̆, la anih rơŭ hũ hia-c̆ŏ sơ̆ng kĕ tơgơi.” ");
INSERT INTO cje_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Bloh nư̆n Yàng Jêsu đờm sơ̆ng mơnih apăn-akŏ sa rơtùh lĭng: “Nau wơ̆ bĕ. Hã păng-tui hơyơu lơi, nư̆n rơŭ hũ yơu nư̆n.” Lăm tŭ jơ nư̆n mư, mơnih hơlŭn-hơlă hũ pơsồ-pơsaih. ");
INSERT INTO cje_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Tŭ Yàng Jêsu tơma lăm sàng Pier, Pô 'buh ame-tămhã Pier dò đih lơ-ơ̆n pơrmă-sơc̆ừng lăm c̆ơnừng. ");
INSERT INTO cje_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Pô apăn tơ tơngàn mơnih lơ-ơ̆n, pơnuaĭ pơrmă-sơc̆ừng thĭt mư; bloh nư̆n mò tơgồ dơ̆ng bloh duh bruă Pô. ");
INSERT INTO cje_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Truh glai diơŭ, aràng ba truh tơ Pô lô mơnih kơđòng kơmlài ngă. Pô angui pơnuaĭ đờm bloh prơh kơmlài tơbiă, sơ̆ng pơsồ-pơsaih tơ abih du mơnih lơ-ơ̆n lơngoh rơwă-sơkì. ");
INSERT INTO cje_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Yơu nư̆n la hũ tơbiă iơŭ tơpă yơu pơnuaĭ mơnih gơnuăr-hwơ̆r Êsai hũ đờm: “Rùp-phŭn Pô hũ suă-mă pơnuaĭ lơ-ơ̆n pơđì buơl gudrơi, Sơ̆ng gui-anòng pơnuaĭ lơ-ơ̆n lơngoh rơwă-sơkì buơl gudrơi.” ");
INSERT INTO cje_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Tŭ Yàng Jêsu 'buh tơrpuơl buơl làng lô biă dò dơ̆ng tòmdăr drơi, nư̆n Pô pơđăr du mơnih tui-mơgru tơpa nau tơ gah dih ia. ");
INSERT INTO cje_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Sa aràng mơnih gơnuăr-pơto pơnuaĭ adăt-adia truh jĕ, đờm sơ̆ng Pô: “Ơ Pô-Pơto, Pô-Pơto nau anih lơi dơlhă rơŭ nau tui anih nư̆n.” ");
INSERT INTO cje_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yàng Jêsu đờm: “Mơja hũ lơbàng, c̆ĭm hũ sruh, bloh Anà Mơnih 'buh hũ anih guơ̆l akŏ.” ");
INSERT INTO cje_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Sa aràng mơnih tui-mơgru pơkơ̆n đờm sơ̆ng Pô: “Khoai Yàng, yòng brơi dơlhă nau wơ̆ dơ̆r ama dơlhă dơlhơu ka.” ");
INSERT INTO cje_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Bloh Yàng Jêsu đờm: “Hã nau bĕ tui Kơu, luơi mơnih mơtai dơ̆r mơnih mơtai buơl guñu.” ");
INSERT INTO cje_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Hơdơi mư̆ng nư̆n, Yàng Jêsu trŭn lăm gơlài, du mơnih tui-mơgru nau tui Pô. ");
INSERT INTO cje_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Mơre-mơro ia-tơsì tơgồ tơbiă rơbù-angĭn prŏng, tơ̆l truh rơyà ia prŏng poh tơma lăm gơlài; bloh Pô sơđaŭ dò đih. ");
INSERT INTO cje_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Du mơnih tui-mơgru truh jĕ, blơ̆ Pô tơgồ sơ̆ng đờm: “Khoai Yàng, yòng dŏng buơl dơlhă. Buơl gudrơi kơjĕ mơtai krăm bơjơ!” ");
INSERT INTO cje_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yàng Jêsu đờm: “Ơ du mơnih tơkì pơnuaĭ păng-tui dih, kơđa hơgĕ buơl guhã huơĭ?” Bloh nư̆n Pô tơgồ dơ̆ng, đờm puaĭ tơ rơbù-angĭn sơ̆ng ia-tơsì; nư̆n rơbù-angĭn sơ̆ng ia-tơsì kơđơ̆ng-rik mư. ");
INSERT INTO cje_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Du mơnih tui-mơgru mă ngă c̆rih-takơtuă biă, đờm lài: “Mơnih ni la aràng sơi bloh găm rơbù-angĭn sơ̆ng ia-tơsì kŭng păl păng-bơbah rơi?” ");
INSERT INTO cje_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Tŭ Yàng Jêsu hũ truh tơ gah dih dơnau-prŏng bơjơ, tơma lăm c̆àr-tơnah buơl làng Gađara; hũ dua aràng mơnih kơđòng kơmlài ngă, mư̆ng anih kŭt tơbiă nau tòm Pô. Buơl guñu mơsak-mơja biă, tơ̆l truh 'buh hũ aràng sơi khĭn nau găn jơlàn nư̆n. ");
INSERT INTO cje_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Buơl guñu driau kơmrào prŏng: “Ơ Anà Yàng Pô Lơngì, buơl dơlhă sơ̆ng Pô hũ pơnuaĭ hơgĕ rơi? Hũ iơŭ Pô truh anih ni tô ngă gleh-glăr buơl dơlhă dơlhơu tơ tŭ-hơrơi ơu?” ");
INSERT INTO cje_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Tŭ nư̆n, 'buh atàh hơdùm mư̆ng anih nư̆n, hũ sa kơtàr pơbui lô biă dò 'bơ̆ng. ");
INSERT INTO cje_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Du kơmlài lơkơu yòng sơ̆ng Yàng Jêsu: “Yah Pô prơh buơl dơlhă, nư̆n yòng brơi buơl dơlhă tơma lăm kơtàr pơbui dih.” ");
INSERT INTO cje_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Pô đờm: “Nau bĕ!” Du kơmlài tơbiă mư mư̆ng dua aràng mơnih nư̆n, sơ̆ng tơma lăm kơtàr pơbui. Lăm tơk tŭ nư̆n mư, abih kơtàr pơbui mư̆ng rơnòng c̆ơ̆ kơsĕt trŭn lăm ia-tơsì, sơ̆ng mơtai krăm abih lăm ia. ");
INSERT INTO cje_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Du mơnih glăng pơbui đuaĭ tơma lăm plơi-prŏng, đờm akhàn wơ̆ mư̆ng abih tơgrơ̆ bruă, găm bruă hũ tơbiă truh sơ̆ng dua aràng mơnih kơđòng kơmlài ngă. ");
INSERT INTO cje_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Nư̆n la abih buơl làng lăm plơi-prŏng tơbiă nau tòm Yàng Jêsu, sơ̆ng tŭ 'buh Pô, buơl guñu yòng lơkơu Pô nau klàh mư̆ng c̆àr-tơnah buơl guñu. ");
INSERT INTO cje_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yàng Jêsu trŭn gơlài, tơpa ia-tơsì, sơ̆ng gài nau wơ̆ tơ plơi-prŏng phŭn Pô. ");
INSERT INTO cje_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Aràng sơkồng truh tơ Pô sa aràng mơnih mơtai tơkai-tơngàn, dò đih lăm c̆ơnừng. Yàng Jêsu 'buh pơnuaĭ păng-tui buơl guñu, nư̆n đờm sơ̆ng mơnih mơtai tơkai-tơngàn lài: “Ơ anà, kơjăp hơtai-hơtiàn bĕ, glài-sơnoh anà hũ anĭt toh-luơi bơjơ.” ");
INSERT INTO cje_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Tŭ nư̆n, hũ du mơnih gơnuăr-pơto pơnuaĭ adăt-adia sơnư̆ng iờp lăm hơtai-hơtiàn lài: “Mơnih ni đờm c̆ờ-sơrbĭl biă.” ");
INSERT INTO cje_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Bloh Yàng Jêsu thơu pơnuaĭ lăm hơtai-akŏ buơl guñu sơnư̆ng-bơngoàn, nư̆n Pô đờm: “Kơđa hơgĕ lăm hơtai-hơtiàn buơl guhã sơnư̆ng jơhà yơu nư̆n? ");
INSERT INTO cje_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Tơkrah dua pơnuaĭ ni, sa la đờm: ‘Glài-sơnoh hã hũ anĭt toh-luơi bơjơ,’ dua la đờm: ‘Tơgồ dơ̆ng bloh nau bĕ,’ pơnuaĭ lơi 'buơ̆n đờm rơlau? ");
INSERT INTO cje_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Bloh, tô buơl guhã thơu lài Anà Mơnih dò lăm dun-ya hũ gơnuăr toh-luơi glài-sơnoh.” — bloh nư̆n Pô đờm sơ̆ng mơnih mơtai tơkai-tơngàn: “Tơgồ dơ̆ng bĕ, glăm c̆ơnừng nau wơ̆ tơ sàng!” ");
INSERT INTO cje_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Mơnih mơtai tơkai-tơngàn tơgồ dơ̆ng sơ̆ng nau wơ̆ tơ sàng drơi. ");
INSERT INTO cje_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","'Buh yơu nư̆n, buơl làng huơĭ kơđa sơ̆ng mơyòm-pơglòng Yàng Pô Lơngì, la Pô hũ brơi tơ jơi anà mơnih gơnăp-gơnuăr yơu nư̆n. ");
INSERT INTO cje_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Tơbiă nau mư̆ng anih nư̆n, Yàng Jêsu 'buh sa aràng mơnih angăn la Mathiơ, dò guh tơ anih rì-mă jia, nư̆n đờm sơ̆ng ñu: “Tui bĕ Kơu!” Mathiơ tơgồ dơ̆ng mư sơ̆ng nau tui Pô. ");
INSERT INTO cje_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Lăm tŭ Yàng Jêsu dò guh huă 'bơ̆ng lăm sàng Mathiơ, hũ lô mơnih rì-mă jia sơ̆ng mơnih glài-sơnoh truh dò guh huă 'bơ̆ng sơ̆ng Pô sơ̆ng du mơnih tui-mơgru Pô. ");
INSERT INTO cje_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","'Buh yơu nư̆n, du mơnih Pharisi đờm sơ̆ng du mơnih tui-mơgru Pô: “Kơđa hơgĕ Pô-Pơto buơl guhã dò guh huă 'bơ̆ng găm sơ̆ng du mơnih rì mă-jia sơ̆ng buơl mơnih glài-sơnoh?” ");
INSERT INTO cje_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Tŭ mơhư̆ pơnuaĭ nư̆n, Yàng Jêsu đờm: “Mơnih pràn-khăng 'buh c̆àng duah mơnih gơnuăr-jrào ơu, bloh la mơnih lơ-ơ̆n lơngoh rơwă-sơkì. ");
INSERT INTO cje_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Nau bĕ, sơ̆ng mơgru tô thơu kơtha-pơnuaĭ jơlàn ni: ‘Kơu khiăng hơtai-hơtiàn anĭt-rơnăm, bloh 'buh khiăng phơ̆n c̆ĕ-pơyơ̆r duh-dơlbăt!’ Kơyoa Kơu truh 'buh iơŭ tô iơu mơnih rĭng-tơpă, bloh iơu mơnih hũ glài.” ");
INSERT INTO cje_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Tŭ nư̆n, du mơnih tui-mơgru Jăng 'Baptis truh duah Yàng Jêsu, bloh tơnia lài: “Kơđa hơgĕ buơl dơlhă sơ̆ng du mơnih Pharisi wèr 'bơ̆ng, bloh du mơnih tui-mơgru Pô-Pơto 'buh wèr 'bơ̆ng?” ");
INSERT INTO cje_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yàng Jêsu đờm: “Lăm tŭ mơnih mơrtơu-lơkơi dò sơ̆ng adơi-ai gơŭ truh sờh lăm pơnuaĭ mơñŭm 'bơ̆ng khiăng-gơŭ, nư̆n du mơnih adơi-ai gơŭ nư̆n hũ rơgơi jruh-jrui jiơ̆ng ơu? Bloh truh tŭ-hơrơi mơnih mơrtơu-lơkơi hũ kŏng ba nau klàh mư̆ng buơl guñu, tŭ nư̆n ka buơl guñu wèr 'bơ̆ng. ");
INSERT INTO cje_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","'Buh aràng sơi bàl pĕt bơ-yài bơrhơu lăm ào klă; kơyoa yah ngă yơu nư̆n, pĕt bàl bơrhơu rơŭ kơtŭng tơrhĕt ào klă, ngă tơ anih tĕ 'brŏ jơhà rơlau wơ̆. ");
INSERT INTO cje_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Kŭng 'buh aràng sơi trĭng tơpai bơrhơu lăm gơdoh kơlì klă, yah ngă yơu nư̆n, gơdoh kơlì rơŭ tơrlah tơrhĕt, tơpai hŏ abih tơ agàh, sơ̆ng gơdoh kơlì kŭng 'buh angui jiơ̆ng tra. Bloh aràng trĭng tơpai bơrhơu lăm gơdoh kơlì bơrhơu, sơ̆ng yơu nư̆n la rơmiă jiơ̆ng abih găm dua.” ");
INSERT INTO cje_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Tŭ Yàng Jêsu dò đờm du pơnuaĭ ni, nư̆n hũ mơnih apăn-akŏ sàng pơtòm truh, c̆ĕ-khoai tơ anaŭ Pô bloh yòng lơkơu: “Anà kơmơi dơlhă pơrpa mơtai, yòng Pô truh daŭ tơngàn tơ ngŏ ñu, tô ñu hũ hơdiŭ.” ");
INSERT INTO cje_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yàng Jêsu tơgồ dơ̆ng, găm sơ̆ng du mơnih tui-mơgru Pô, nau tui mơnih nư̆n. ");
INSERT INTO cje_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Tŭ nư̆n, hũ sa aràng mơnih kơmơi kơđòng lơ-ơ̆n lơhiă drah sa-pluh dua thŭn bơjơ, truh jĕ tơ gah rŏng Yàng Jêsu sơ̆ng rơwơ̆ tơ aku ào Pô. ");
INSERT INTO cje_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Kơyoa ñu sơnư̆ng lăm hơtai-hơtiàn ñu lài: “Yah drơi mĭn rơwơ̆ hũ tơ ào Pô soh, nư̆n kŭng rơŭ hũ pơsồ-pơsaih.” ");
INSERT INTO cje_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yàng Jêsu pơtrah wơ̆, 'buh mơnih kơmơi, nư̆n đờm: “Ơ anà, kơjăp kơđơ̆ng hơtai-hơtiàn bĕ, pơnuaĭ păng-tui anà hũ pơsồ-pơsaih tơ anà.” Lăm tŭ jơ nư̆n mư, mơnih kơmơi ni hũ pơsồ-pơsaih. ");
INSERT INTO cje_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yàng Jêsu tơma lăm sàng mơnih apăn-akŏ sàng pơtòm, 'buh buơl mơnih ơyù tơliă tơ sàng atơu, sơ̆ng sa tơrpuơl mơnih lô klùk-klờk biă, ");
INSERT INTO cje_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","nư̆n Pô đờm: “Yòng tơgrơ̆ mơnih nau wơ̆ bĕ, anà kơmơi tìt ni 'buh mơtai ơu, ñu mĭn dò đih soh.” Guñu mơhư̆ nư̆n klau pơtăt Pô. ");
INSERT INTO cje_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Hơdơi tŭ tơrpuơl mơnih lô hũ aràng tơluh tơbiă abih tơ agàh bơjơ, nư̆n Pô nau tơma sơ̆ng apăn tơ tơngàn anà kơmơi tìt, nư̆n ñu tơgồ mư. ");
INSERT INTO cje_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Pơnuaĭ ni hũ ba pơtiơ̆ng lăm abih c̆àr nư̆n. ");
INSERT INTO cje_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Tŭ Yàng Jêsu mư̆ng anih nư̆n tơbiă nau, hũ dua aràng mơnih bồm nau tui Pô, sơ̆ng iơu yòng lài: “Khoai Anà pơtau Đabit, yòng anĭt-anăr buơl dơlhă!” ");
INSERT INTO cje_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Hơdơi tŭ tơma lăm sàng, dua aràng mơnih bồm truh jĕ Pô. Yàng Jêsu đờm sơ̆ng buơl guñu lài: “Buơl guhã hũ păng-tui lài Kơu ngă jiơ̆ng pơnuaĭ buơl guhã lơkơu-khiăng ơu?” Buơl guñu đờm: “Ơ Yàng, buơl dơlhă păng-tui.” ");
INSERT INTO cje_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Pô rơwơ̆ tơ mơta buơl guñu sơ̆ng đờm: “Buơl guhã păng-tui hơyơu lơi nư̆n rơŭ hũ yơu nư̆n.” ");
INSERT INTO cje_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Mơta buơl guñu hũ sơrdah mư. Yàng Jêsu mă pơnuaĭ kơđơ̆ng-mơsak đờm kơkơi pơđăr buơl guñu: “C̆ơ-kơrmăp bĕ, juơi brơi aràng sơi thơu bruă ni.” ");
INSERT INTO cje_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Bloh buơl guñu tơbiă nau sơ̆ng đờm pơtiơ̆ng mư̆ng angăn Pô lăm abih c̆àr nư̆n. ");
INSERT INTO cje_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Hơdơi tŭ buơl guñu tơbiă nau, aràng ba truh tơ Yàng Jêsu sa aràng mơnih kơmlo, kơđòng kơmlài ngă. ");
INSERT INTO cje_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yàng Jêsu prơh kơmlài tơbiă sơ̆ng mơnih kơmlo đờm jiơ̆ng. Buơl làng mă ngă c̆rih-takơtuă biă, sơ̆ng đờm lài: “Ka tŭ lơi hũ 'buh sa bruă yơu ni lăm Israel.” ");
INSERT INTO cje_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Bloh du mơnih Pharisi nư̆n đờm lài: “Mơnih ni gơnừm tơ gơnuăr pơtau kơmlài tô prơh kơmlài.” ");
INSERT INTO cje_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yàng Jêsu nau lăm abih tơgrơ̆ plơi-prŏng, tơgrơ̆ plơi tìt, pơto-mơblàng lăm du sàng pơtòm, pơto-akhàn Pơnuaĭ-Siàm mư̆ng Lơgăr Yàng Pô Lơngì, sơ̆ng pơsồ-pơsaih tơgrơ̆ pơnuaĭ lơ-ơ̆n lơngoh rơwă-sơkì. ");
INSERT INTO cje_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Tŭ Pô 'buh du tơrpuơl buơl làng lô, nư̆n lăm hơtai-hơtiàn Pô anĭt-rơnăm biă, kơyoa buơl guñu gleh-glăr, sơ̆ng c̆ơrlah-c̆ơrlờp yơu abo 'buh hũ mơnih glăng. ");
INSERT INTO cje_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Pô đờm sơ̆ng du mơnih tui-mơgru lài: “Blàn yuă nư̆n hũ biă, bloh mơnih yuă nư̆n tơkì. ");
INSERT INTO cje_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Yơu nư̆n, yòng-lơkơu bĕ Pô-Phŭn blàn yuă pơđăr mơnih yuă tơma lăm blàn yuă Pô.” ");
INSERT INTO cje_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yàng Jêsu iơu sa-pluh dua aràng mơnih tui-mơgru Pô truh, brơi tơ buơl guñu gơnuăr tô pơtrơh du kơmlài-jĭnràk, sơ̆ng pơsồ-pơsaih tơgrơ̆ pơnuaĭ lơ-ơ̆n lơngoh rơwă-sơkì. ");
INSERT INTO cje_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ni la mơta sa-pluh dua aràng mơnih tơdi-tơdài: Dơlhơu biă la Simôn, kŭng angăn la Pier, sơ̆ng Andre, adơi ñu; Jakơ anà Sebede sơ̆ng Jăng, adơi ñu. ");
INSERT INTO cje_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Philip sơ̆ng Bathelemi; Thôma, sơ̆ng Mathiơ la mơnih rì-mă jia; Jakơ anà Alphe, sơ̆ng Thađe; ");
INSERT INTO cje_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simôn mơnih Kanaan, sơ̆ng Juđa Iskariôt, la mơnih pơblơ̆-dră Yàng Jêsu. ");
INSERT INTO cje_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yàng Jêsu pơđăr sa-pluh dua aràng mơnih tơdi-tơdài ni nau, sơ̆ng kơkơi pơđăr lài: “Juơi nau tơma lăm c̆àr buơl làng agàh, kŭng juơi tơma lăm sa plơi-prŏng lơi lăm buơl làng Samari, ");
INSERT INTO cje_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","bloh siàm rơlau, nau truh bĕ sơ̆ng buơl làng Israel, kơyoa buơl guñu mơhiơ̆ yơu abo nau c̆ơrlah lơhiă. ");
INSERT INTO cje_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Tŭ nau jơlàn, đờm pơto-akhàn bĕ lài: ‘Lơgăr Lơngì hũ truh jĕ bơjơ.’ ");
INSERT INTO cje_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Pơsồ-pơsaih bĕ tơ mơnih lơ-ơ̆n lơngoh rơwă-sơkì, ngă tơ mơnih mơtai hơdiŭ wơ̆, pơsồ goh tơ mơnih dŭn, sơ̆ng pơtrơh du kơmlài. Buơl guhã hũ brơi soh, nư̆n kŭng păl brơi soh yơu nư̆n rơi. ");
INSERT INTO cje_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Juơi apăn mừh, priă, halài boh priă lăm tơlơi kơ-iăng. ");
INSERT INTO cje_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Kŭng juơi apăn kơdŭng nau jơlàn, halài dua blah ào, halài tơkhŏ, halài gai kwĕt. Kơyoa mơnih ngă bruă iơŭ păl hũ đồ-lĕng phơ̆n-kơya 'bơ̆ng. ");
INSERT INTO cje_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Tŭ buơl guhã tơma lăm plơi-prŏng halài plơi-tìt lơi, nư̆n duah tơnia bĕ tơ anih nư̆n hũ aràng sơi la mơnih iơŭ păl, sơ̆ng dò bĕ tơ anih nư̆n tơ̆l truh tơ tŭ tơbiă nau. ");
INSERT INTO cje_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Sơ̆ng tŭ tơma lăm sàng lơi, nư̆n lơkơu bĕ pơnuaĭ rĭng-lơngai tơ sàng nư̆n. ");
INSERT INTO cje_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Yah sàng nư̆n iơŭ păl, nư̆n pơnuaĭ rĭng-lơngai buơl guhã rơŭ truh sơ̆ng buơl guñu; yah 'buh iơŭ păl, nư̆n pơnuaĭ rĭng-lơngai buơl guhã rơŭ gài mơrai wơ̆ sơ̆ng buơl guhã. ");
INSERT INTO cje_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Yah aràng sơi 'buh wă-rò, halài 'buh păng pơnuaĭ buơl guhã, nư̆n tŭ nau tơbiă mư̆ng sàng halài plơi-prŏng nư̆n, tơrtuh bĕ thŭl hũ klĕm tơ tơkai buơl guhã. ");
INSERT INTO cje_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Iơŭ biă, Kơu đờm sơ̆ng buơl guhã, truh hơrơi c̆ahrơña, buơl làng du c̆àr Sôđôm sơ̆ng Gômôrơ rơŭ kŏng c̆ahrơña sơ-uơ̆l rơlau tơ buơl làng plơi-prŏng nư̆n.” ");
INSERT INTO cje_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Ni, Kơu pơđăr buơl guhã nau yơu abo tơma tơkrah tơrpuơl asơu sĭng. Yơu nư̆n, buơl guhã păl khờh-rơgơi bĕ yơu ala sơ̆ng lơnguh-siàm yơu c̆ĭm kơtrơu. ");
INSERT INTO cje_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","C̆ơ-kơrhia bĕ mơnih lăm rài, kơyoa buơl guñu rơŭ jào buơl guhã tơ anaŭ anih c̆ahrơña, sơ̆ng glih-pờng buơl guhã lăm du sàng pơtòm. ");
INSERT INTO cje_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Kơyoa mư̆ng Kơu, buơl guhã rơŭ kơđòng ba truh tơ anaŭ du kwăng apăn-akŏ du c̆àr lăm lơgăr sơ̆ng du pơtau, tô ngă grơh tơ anaŭ buơl guñu sơ̆ng tơ du buơl làng agàh. ");
INSERT INTO cje_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Bloh tŭ buơl guñu mă jào buơl guhã, juơi sơnư̆ng kơ-ù păl đờm hơyơu lơi, halài đờm tơgrơ̆ pơnuaĭ hơgĕ; kơyoa lăm jơ nư̆n, tơgrơ̆ pơnuaĭ hơgĕ păl đờm rơŭ hũ brơi tơ buơl guhã. ");
INSERT INTO cje_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Kơyoa 'buh iơŭ rùp-phŭn buơl guhã đờm ơu, bloh la Bơngă Sơc̆ih-Sri mư̆ng Ama buơl guhã, rơŭ mư̆ng hơtai-hơtiàn buơl guhã đờm tơbiă. ");
INSERT INTO cje_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Sơ-ai rơŭ jào adơi tô aràng pơmơtai, ama rơŭ jào anà, du anà rơŭ tơgồ tămdră-wơ̆ sơ̆ng ame ama, sơ̆ng ngă tơ ame ama păl mơtai. ");
INSERT INTO cje_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Buơl guhã rơŭ kŏng tơgrơ̆ buơl làng mơbai-lơmù kơyoa angăn Kơu, bloh aràng sơi kơjăp hơtai-hơtiàn tơ̆l truh luĭ-dŭt, nư̆n rơŭ hũ dŏng-pơklàh. ");
INSERT INTO cje_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Tŭ aràng mă-pơkơŭ buơl guhã lăm plơi-prŏng ni, nư̆n pleh dơŭ bĕ lăm plơi-prŏng dih; kơyoa biă, Kơu đờm sơ̆ng buơl guhã, buơl guhã ka nau abih du plơi-prŏng buơl làng Israel nư̆n Anà Mơnih hũ truh bơjơ. ");
INSERT INTO cje_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Mơnih tui-mơgru 'buh rơlau pô-pơto, mơnih hơlŭn-hơlă 'buh rơlau mơnih pô-phŭn. ");
INSERT INTO cje_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Mơnih tui-mơgru hũ yơu pô-pơto, mơnih hơlŭn-hơlă hũ yơu mơnih pô-phŭn, nư̆n tơ̆l bơjơ. Yah buơl guñu hũ iơu pô sàng la Beelsebul, nư̆n du mơnih lăm sàng buơl guñu rơŭ iơu dò jơhà rơlau truh kàr lơi wơ̆! ");
INSERT INTO cje_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Yơu nư̆n, buơl guhã juơi huơĭ, kơyoa 'buh hũ bruă hơgĕ ac̆ĭng-bơdơŭ bloh 'buh păl ràng-tơbiă, 'buh hũ bruă hơgĕ bơdơŭ-tơrđơŭ bloh rơŭ 'buh hũ thơu truh. ");
INSERT INTO cje_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Kơyoa nư̆n, tơgrơ̆ pơnuaĭ hơgĕ Kơu đờm sơ̆ng buơl guhã lăm anih kơnăm, đờm tơbiă bĕ tơkrah glai hơrơi; tơgrơ̆ pơnuaĭ hơgĕ buơl guhã mơhư̆ đờm sào tơ gah tơnia, nư̆n đì bĕ tơ ngŏ bơbŭng sàng bloh đờm tơbiă. ");
INSERT INTO cje_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Buơl guhã juơi huơĭ tơ du mơnih mĭn pơmơtai jiơ̆ng rùp-phàp bloh 'buh pơmơtai jiơ̆ng bơngă-joa, bloh păl huơĭ bĕ tơ Pô hũ rơgơi pơluĭ-pơlơhiă abih găm rùp-phàp sơ̆ng bơngă-joa lăm brŏng-apui. ");
INSERT INTO cje_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Dua drơi c̆ĭm ñiă 'buh iơŭ mĭn pơblơi hũ sa xu priă ơu? Bloh yah Ama buơl guhã 'buh brơi gơnuăr, nư̆n 'buh sa drơi lơi lĕ trŭn tơ ala lơ̆n. ");
INSERT INTO cje_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","'Bù tơ akŏ buơl guhã kŭng hũ yàu abih bơjơ. ");
INSERT INTO cje_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Yơu nư̆n, juơi huơĭ, kơyoa buơl guhã c̆ơk-màng rơlau lô c̆ĭm ñiă. ");
INSERT INTO cje_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Kơyoa nư̆n, aràng sơi akhàn-tơbiă Kơu tơ anaŭ tơgrơ̆ mơnih pơkơ̆n, Kơu kŭng rơŭ akhàn-tơbiă mơnih nư̆n tơ anaŭ Ama Kơu dò tơ ngŏ lơngì. ");
INSERT INTO cje_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Dò aràng sơi kơmlah-luơi Kơu tơ anaŭ tơgrơ̆ mơnih pơkơ̆n, nư̆n Kơu kŭng rơŭ kơmlah-luơi buơl guñu tơ anaŭ Ama Kơu dò tơ ngŏ lơngì. ");
INSERT INTO cje_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Juơi sơnư̆ng Kơu truh tô apăn pơnuaĭ rĭng-lơngai tơ dun-ya; Kơu truh, 'buh iơŭ tô apăn pơnuaĭ rĭng-lơngai, bloh la apăn đào sơdrà. ");
INSERT INTO cje_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Kơu truh tô pơc̆ơrlah krơi anà lơkơi sơ̆ng ama, anà kơmơi sơ̆ng ame, mơrtơu-kơmơi sơ̆ng ame-tămhã. ");
INSERT INTO cje_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Sơ̆ng aràng rơŭ hũ mơnih mơbai-tămdră, la mơnih phŭn lăm sàng dơnò drơi. ");
INSERT INTO cje_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Aràng sơi rơnăm tơ ame halài ama rơlau tơ Kơu, nư̆n 'buh iơŭ păl tơ Kơu. Aràng sơi rơnăm tơ anà lơkơi halài anà kơmơi rơlau tơ Kơu, kŭng 'buh iơŭ păl tơ Kơu. ");
INSERT INTO cje_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Aràng sơi 'buh glăm kơyơu pơkăl drơi bloh tui Kơu, nư̆n kŭng 'buh iơŭ păl tơ Kơu. ");
INSERT INTO cje_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Aràng sơi gàr-rơmiă pơnuaĭ hơdiŭ drơi, nư̆n rơŭ lơhiă; dò aràng sơi kơyoa mư̆ng Kơu bloh prah luơi pơnuaĭ hơdiŭ drơi, nư̆n rơŭ duah hũ wơ̆. ");
INSERT INTO cje_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Aràng sơi wă-rò buơl guhã, la wă-rò Kơu. Aràng sơi wă-rò Kơu, la wă-rò Pô hũ pơđăr Kơu. ");
INSERT INTO cje_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Aràng sơi wă-rò sa aràng mơnih gơnuăr-hwơ̆r kơyoa mơnih nư̆n la mơnih gơnuăr-hwơ̆r, rơŭ đồ-mă hũ phơ̆n mơyòm-brơi pioh tơ mơnih gơnuăr-hwơ̆r. Aràng sơi wă-rò sa aràng mơnih rĭng-tơpă kơyoa mơnih nư̆n la mơnih rĭng-tơpă, rơŭ đồ-mă hũ phơ̆n mơyòm-brơi pioh tơ mơnih rĭng-tơpă. ");
INSERT INTO cje_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Aràng sơi brơi tơ sa aràng lăm du mơnih tìt ni mơñŭm, yah mĭn sa c̆uàn ia mơrềt soh, kơyoa mơnih nư̆n la mơnih tui-mơgru Kơu; iơŭ biă, Kơu đờm sơ̆ng buơl guhã, mơnih nư̆n rơŭ 'buh lơhiă phơ̆n mơyòm-brơi drơi ơu.” ");
INSERT INTO cje_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Hơdơi tŭ Yàng Jêsu đờm pơto du pơnuaĭ nư̆n tơ sa-pluh dua aràng mơnih tui-mơgru Pô, Pô tơbiă nau mư̆ng anih nư̆n, truh pơto-pơsài sơ̆ng pơto-akhàn lăm du plơi-prŏng c̆àr nư̆n. ");
INSERT INTO cje_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Tŭ Jăng 'Baptis dò lăm sàng jàm hũ mơhư̆ thơu mư̆ng du bruă Pô Krist ngă, nư̆n pơđăr du mơnih tui-mơgru drơi truh tơnia Pô lài: ");
INSERT INTO cje_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Pô-Pơto hũ iơŭ la Pô păl truh, halài buơl dơlhă păl c̆àng Pô pơkơ̆n?” ");
INSERT INTO cje_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yàng Jêsu đờm: “Nau wơ̆ bĕ, đờm akhàn wơ̆ tơ Jăng thơu mư̆ng abih tơgrơ̆ pơnuaĭ hơgĕ buơl guhã hũ mơhư̆ sơ̆ng 'buh: ");
INSERT INTO cje_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Mơnih bồm hũ 'buh, mơnih joh-je hũ nau, mơnih dŭn hũ goh, mơnih tĭ hũ mơhư̆, mơnih mơtai hũ hơdiŭ wơ̆, sơ̆ng mơnih rơ'bah hũ mơhư̆ Pơnuaĭ-Siàm. ");
INSERT INTO cje_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Lơngai-pơtuah tơ mơnih lơi 'buh sơnĕ lơbuh lăm pơnuaĭ sŭng kơyoa Kơu.” ");
INSERT INTO cje_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Hơdơi tŭ du mơnih tui-mơgru Jăng 'Baptis nau wơ̆ bơjơ, Yàng Jêsu đờm sơ̆ng tơrpuơl buơl làng mư̆ng Jăng 'Baptis lài: “Buơl guhã tơbiă nau c̆ơ hơgĕ lăm 'blàng-jơhua? C̆ơ sa phŭn pơrbo kơđòng rơbù pơpuh ngă mơgơi? ");
INSERT INTO cje_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Buơl guhã tơbiă tô c̆ơ pơnuaĭ hơgĕ? Hũ iơŭ tô c̆ơ mơnih c̆ù ào màng-mơkrư ơu? Dih, du mơnih c̆ù ào màng-mơkrư nư̆n dò lăm sàng-glăng pơtau. ");
INSERT INTO cje_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Yơu nư̆n buơl guhã tơbiă nau c̆ơ hơgĕ? Hũ iơŭ tô c̆ơ sa aràng mơnih gơnuăr-hwơ̆r ơu? Biă, Kơu đờm sơ̆ng buơl guhã, hũ sa aràng mơnih tơ anih ni dò prŏng-màng rơlau tơ mơnih gơnuăr-hwơ̆r wơ̆. ");
INSERT INTO cje_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Nư̆n la mư̆ng mơnih ni bloh 'Bồn Bơ-àr Sơc̆ih-Sri hũ wă lài: ‘Ni, Kơu pơđăr mơnih Kơu nau dơlhơu tơ anaŭ Anà, Mơnih nư̆n rơŭ rơc̆ăng jơlàn dơlhơu tơ Anà.’ ");
INSERT INTO cje_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Iơŭ biă, Kơu đờm sơ̆ng buơl guhã, lăm abih tơgrơ̆ mơnih kơyoa mư̆ng mơnih kơmơi đih apui tơbiă, 'buh hũ aràng sơi prŏng-màng rơlau tơ Jăng 'Baptis, bloh mơnih tìt rơlau abih lăm lơgăr glòng lơngì dò prŏng-màng rơlau tơ ñu. ");
INSERT INTO cje_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Mư̆ng hơrơi Jăng 'Baptis pơto-akhàn tơ̆l truh tơ tŭ ni, Lơgăr Lơngì kŏng pơnuaĭ pơkơŭ-kơtơ̆ pràn biă, sơ̆ng du mơnih pràn-mơsak khiăng tămblah-mă lơgăr nư̆n. ");
INSERT INTO cje_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Kơyoa abih tơgrơ̆ mơnih gơnuăr-hwơ̆r sơ̆ng pơnuaĭ adăt-adia hũ đờm dơlhơu tơ̆l truh tơ rài Jăng. ");
INSERT INTO cje_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Yah buơl guhã khiăng păng-tui, nư̆n Jăng la Eli, mơnih păl truh. ");
INSERT INTO cje_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Aràng sơi hũ tơnia, păng bĕ! ");
INSERT INTO cje_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Kơu păl pơmơyơu jơi-pơtiàn ni sơ̆ng aràng sơi? Jơi-pơtiàn ni mơhiơ̆ yơu buơl lơ-ơneh tìt dò guh tơkrah drà, driau iơu du lơ-ơneh tìt pơkơ̆n, sơ̆ng đờm: ");
INSERT INTO cje_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Buơl gukơu hũ ơyù tơliă, bloh buơl guhã 'buh khiăng tăm-ya; Buơl gukơu hũ adoh pơnuaĭ adoh jruh-jrui, bloh buơl guhã 'buh khiăng hia c̆ŏ. ");
INSERT INTO cje_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Kơyoa Jăng truh, 'buh 'bơ̆ng 'buh mơñŭm, nư̆n aràng đờm lài: ‘Jăng 'Baptis kơđòng kơmlài ngă.’ ");
INSERT INTO cje_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Anà Mơnih truh, 'bơ̆ng sơ̆ng mơñŭm, nư̆n buơl guñu đờm lài: ‘C̆ơ dih, sa aràng mơnih hrạ 'bơ̆ng hrạ mơñŭm, ngă adơi-ai gơŭ sơ̆ng mơnih rì-mă jia sơ̆ng mơnih glài-sơnoh!’ Bloh pơnuaĭ jak-khờh rơŭ hũ ngă grơh sơ̆ng phŭn-hơjŭng kơyoa bruă ngă.” ");
INSERT INTO cje_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Kơyoa buơl làng tơgrơ̆ plơi-prŏng anih Yàng Jêsu hũ ngă lô pơnuaĭ c̆rih-krơi sơđaŭ 'buh khiăng mơbai prah-luơi glài-sơnoh, nư̆n Pô đờm puaĭ 'buah lài: ");
INSERT INTO cje_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Gleh-glăr dồn-să tơ hã, ơ plơi-prŏng Kôrasin! Gleh-glăr dồn-să tơ hã, ơ plơi-prŏng 'Betsaiđa! Kơyoa yah du pơnuaĭ c̆rih-krơi hũ ngă tơkrah buơl guhã bloh hũ ngă tơ plơi-prŏng Tirơ sơ̆ng Siđôn, nư̆n buơl guñu hũ c̆ù ào blơu kơtăl, đoa hơbơu gìng, sơ̆ng mơbai prah-luơi glài-sơnoh mư̆ng suơi bơjơ. ");
INSERT INTO cje_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Kơyoa nư̆n Kơu đờm sơ̆ng buơl guhã, truh hơrơi c̆ahrơña, plơi-prŏng Tirơ sơ̆ng plơi-prŏng Siđôn rơŭ kŏng c̆ahrơña sơ-uơ̆l rơlau tơ buơl guhã. ");
INSERT INTO cje_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Dò hã wơ̆, ơ plơi-prŏng Kapenaum, hã sơnư̆ng hã rơŭ hũ pồ-pơđì truh tơ lơngì? 'Buh ơu, hã rơŭ kŏng pơtrŭn truh tơ ala lơgăr-atơu. Kơyoa yah tơgrơ̆ pơnuaĭ c̆rih-krơi hũ ngă tơkrah hã, apăn ngă lăm plơi-prŏng Sôđôm, nư̆n plơi-prŏng nư̆n sơđaŭ dò truh tơ hơrơi ni. ");
INSERT INTO cje_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Kơyoa nư̆n, Kơu đờm sơ̆ng buơl guhã, lăm hơrơi c̆ahrơña, buơl làng plơi-prŏng Sôđôm rơŭ kŏng c̆ahrơña sơ-uơ̆l rơlau tơ buơl guhã.” ");
INSERT INTO cje_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Tŭ nư̆n, Yàng Jêsu đờm lài: “Ơ Ama! La Yàng lơngì-tơsì tơnah-rơya, Anà mơyòm-pơglòng Ama, kơyoa Ama hũ bơdơŭ tơgrơ̆ pơnuaĭ ni sơ̆ng mơnih jak-khờh, mơnih sơrdah-rơgơi, bloh akhàn-tơbiă tơ du lơ-ơneh tìt. ");
INSERT INTO cje_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Biă yơu nư̆n, ơ Ama, kơyoa pơnuaĭ ni siàm hơtai Ama. ");
INSERT INTO cje_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ama Kơu hũ jào tơgrơ̆ bruă tơ Kơu, rơlau tơ Ama, 'buh hũ aràng sơi thơu Anà. Rơlau tơ Anà, sơ̆ng mơnih lơi Anà khiăng akhàn-tơbiă, nư̆n kŭng 'buh hũ aràng sơi thơu Ama. ");
INSERT INTO cje_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ơ du mơnih lơi gleh-glăr sơ̆ng gui-anòng traŭ, truh bĕ sơ̆ng Kơu, Kơu rơŭ brơi buơl guhã hũ lơngai-pơgleh. ");
INSERT INTO cje_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Glăm bĕ yơu Kơu sơ̆ng mơgru tui Kơu, nư̆n bơngă-joa buơl guhã rơŭ hũ lơngai-pơgleh, kơyoa Kơu hũ hơtai-hơtiàn lơnguh-lơngui sơ̆ng pơ-ơneh rùp. ");
INSERT INTO cje_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kơyoa yơu Kơu la 'buơ̆n lơhuai, sơ̆ng anòng Kơu la sơ-uơ̆l biă.” ");
INSERT INTO cje_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Tŭ nư̆n, iơŭ lăm hơrơi sa'bat, Yàng Jêsu nau găn 'blàng hơma bơdai, du mơnih tui-mơgru Pô lơpa tŭng, nư̆n buơl guñu rơhòt du ơmùng bơdai bloh 'bơ̆ng. ");
INSERT INTO cje_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Du mơnih Pharisi 'buh yơu nư̆n, đờm sơ̆ng Pô: “C̆ơ dih, du mơnih tui-mơgru Pô-Pơto ngă pơnuaĭ 'buh hũ gơnuăr ngă lăm hơrơi sa'bat.” ");
INSERT INTO cje_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Bloh Pô đờm sơ̆ng buơl guñu: “Buơl guhã ka pơrpoh-c̆ơ mư̆ng bruă pơtau Đabit hũ ngă, tŭ pơtau găm sơ̆ng du mơnih nau tui pơtau lơpa tŭng ơu? ");
INSERT INTO cje_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Pơtau tơma lăm sàng Yàng Pô Lơngì, 'bơ̆ng pah sơc̆ih-sri ràng tơ ngŏ sơbàn duh-dơlbăt, la pah bloh pơtau sơ̆ng du mơnih nau tui 'buh hũ gơnuăr 'bơ̆ng, mĭn pioh krơi tơ du mơnih gơnuăr pơyă phơ̆n duh-dơlbăt soh. ");
INSERT INTO cje_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Halài buơl guhã ka pơrpoh-c̆ơ lăm bơ-àr pơnuaĭ adăt-adia lài, lăm hơrơi sa'bat, du mơnih gơnuăr pơyă phơ̆n duh-dơlbăt duh bruă lăm sàng duh-dơlbăt, nư̆n 'buh ngă sŭng adăt hơrơi sa'bat sơ̆ng kŭng 'buh kŏng kơđòng glài-sơnoh ơu? ");
INSERT INTO cje_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Bloh Kơu đờm tơ buơl guhã thơu, tơ anih ni, hũ sa Pô prŏng-màng rơlau tơ sàng duh-dơlbăt wơ̆. ");
INSERT INTO cje_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Yah buơl guhã wờng jiơ̆ng kơtha-pơnuaĭ jơlàn ni: ‘Kơu khiăng hơtai-hơtiàn anĭt-rơnăm, bloh 'buh iơŭ phơ̆n sì c̆ĕ-pơyơ̆r duh-dơlbăt,’ nư̆n buơl guhã rơŭ 'buh ngă nìn-glài tơgrơ̆ mơnih 'buh hũ glài. ");
INSERT INTO cje_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Kơyoa Anà Mơnih la Yàng hơrơi sa'bat.” ");
INSERT INTO cje_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yàng Jêsu nau klàh mư̆ng anih nư̆n, sơ̆ng tơma lăm sàng pơtòm. ");
INSERT INTO cje_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Tơ anih nư̆n, hũ sa aràng mơnih srĕt-mơtai sa gah plà tơngàn. Buơl guñu tơnia Pô lài: “Lăm hơrơi sa'bat hũ gơnuăr pơsồ-pơsaih lơ-ơ̆n lơngoh rơwă-sơkì ơu?” Buơl guñu tơnia yơu nư̆n la tô duah pơnuaĭ yă Pô. ");
INSERT INTO cje_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Pô đờm sơ̆ng buơl guñu: “Aràng sơi lăm buơl guhã hũ sa drơi abo, yah lăm hơrơi sa'bat, kơđòng lĕ lăm sơlŭng, nư̆n 'buh kơtŭng ñu đì ơu? ");
INSERT INTO cje_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Đờm hơgĕ anà mơnih la c̆ơk-màng rơlau tơ abo thơu hơdùm! Yơu nư̆n, lăm hơrơi sa'bat hũ gơnuăr ngă bruă siàm.” ");
INSERT INTO cje_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Bloh nư̆n Pô đờm sơ̆ng mơnih srĕt-mơtai tơngàn: “Yơ̆r bĕ tơngàn hã tơbiă!” Mơnih nư̆n yơ̆r tơngàn tơbiă, nư̆n tơngàn hũ pơsồ-pơsaih, jiơ̆ng bơhiàn siàm yơu tơngàn dih. ");
INSERT INTO cje_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Du mơnih Pharisi tơbiă nau, tămbơyai sơ̆ng gơŭ, tô duah pơnuaĭ pơmơtai Yàng Jêsu. ");
INSERT INTO cje_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Bloh Yàng Jêsu thơu pơnuaĭ nư̆n, Pô pleh klàh mư̆ng anih nư̆n. Hũ lô mơnih nau tui Pô, sơ̆ng Pô pơsồ-pơsaih tơ abih tơgrơ̆ mơnih lơ-ơ̆n lơngoh rơwă-sơkì. ");
INSERT INTO cje_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Pô pơkơŭ buơl guñu juơi brơi aràng sơi thơu mư̆ng Pô. ");
INSERT INTO cje_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Pơnuaĭ ni ngă iơŭ tơpă pơnuaĭ mơnih gơnuăr-hwơ̆r Êsai hũ đờm lài: ");
INSERT INTO cje_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ni la mơnih hơlŭn-hơlă Kơu hũ rơwah, Mơnih bloh Kơu uơ̆n-rơnăm, siàm hơtai Kơu lăm abih tơgrơ̆ mơta. Kơu rơŭ brơi Bơngă Sơc̆ih-Sri Kơu dò tơ ngŏ Ñu, Ñu rơŭ pơto-akhàn pơnuaĭ-tơpă tơ buơl làng agàh. ");
INSERT INTO cje_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ñu rơŭ 'buh tăm-mơsau, 'buh kơmrào driau, 'Buh aràng sơi mơhư̆ săp Ñu tơ agàh jơlàn rơya. ");
INSERT INTO cje_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ñu rơŭ 'buh joh gai pơrbo kơjĕ joh, 'Buh pơmơtai apui-đèng kơjĕ luĭ, Tơ̆l truh tŭ Ñu ba pơnuaĭ rĭng-tơpă truh pha-jai rơlau. ");
INSERT INTO cje_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Sơ̆ng tơgrơ̆ buơl làng agàh rơŭ c̆àng-gơnừm tơ angăn Ñu.” ");
INSERT INTO cje_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Tŭ nư̆n, aràng ba truh tơ Yàng Jêsu sa aràng mơnih kơđòng kơmlài ngă; kơmlài ngă tơ mơnih nư̆n jiơ̆ng bồm sơ̆ng kơmlo. Pô pơsồ-pơsaih tơ mơnih nư̆n, ngă tơ mơnih nư̆n đờm jiơ̆ng sơ̆ng 'buh jiơ̆ng. ");
INSERT INTO cje_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Abih buơl làng mă ngă c̆rih-takơtuă biă, sơ̆ng đờm: “Mơnih ni 'buh iơŭ la anà-tơc̆o pơtau Đabit ơu?” ");
INSERT INTO cje_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Bloh tŭ mơhư̆ yơu nư̆n, du mơnih Pharisi đờm lài: “Mơnih ni 'buh tŭ lơi pơtrơh kơmlài jiơ̆ng yah 'buh gơnừm tơ Beelsebul la pơtau kơmlài.” ");
INSERT INTO cje_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yàng Jêsu thơu pơnuaĭ lăm hơtai-akŏ buơl guñu sơnư̆ng, nư̆n đờm: “Sa lơgăr bloh pơc̆ơrlah krơi duă gơŭ drơi wơ̆, nư̆n rơŭ kơđòng pơluĭ-pơlơhiă. Sa plơi-prŏng halài sa boh sàng bloh pơc̆ơrlah krơi duă gơŭ drơi wơ̆, nư̆n rơŭ 'buh dò dơ̆ng kơjăp jiơ̆ng. ");
INSERT INTO cje_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Yah kơmlài Satăn pơtrơh kơmlài Satăn, nư̆n la rùp-phŭn ñu pơc̆ơrlah krơi sơ̆ng rùp-phŭn drơi wơ̆; ngă hơyơu lơgăr ñu dò dơ̆ng kơjăp jiơ̆ng? ");
INSERT INTO cje_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Yah Kơu gơnừm tơ Beelsebul tô pơtrơh kơmlài, nư̆n anà buơl guhã gơnừm tơ aràng sơi tô pơtrơh kơmlài? Kơyoa nư̆n, rùp-phŭn buơl guñu rơŭ la mơnih c̆ahrơña buơl guhã. ");
INSERT INTO cje_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Bloh yah Kơu gơnừm tơ Bơngă Sơc̆ih-Sri Yàng Pô Lơngì tô pơtrơh kơmlài, nư̆n lơgăr Yàng Pô Lơngì hũ truh sơ̆ng buơl guhã bơjơ. ");
INSERT INTO cje_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Halài, ngă hơyơu aràng hũ rơgơi tơma lăm sàng sa aràng mơnih khăng-pràn tô tămblah-mă phơ̆n-bơna ñu jiơ̆ng, yah dơlhơu biă 'buh mă c̆aŭ mơnih pràn-khăng nư̆n wơ̆? Păl c̆aŭ mơnih nư̆n dơlhơu, bloh nư̆n ka tămblah-mă phơ̆n-bơna lăm sàng ñu jiơ̆ng. ");
INSERT INTO cje_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Aràng sơi 'buh dò sơ̆ng Kơu, nư̆n tămdră-wơ̆ sơ̆ng Kơu; aràng sơi 'buh pơgùm-pơtòm sơ̆ng Kơu, nư̆n kơprah-kơprĭng. ");
INSERT INTO cje_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Kơyoa nư̆n, Kơu đờm tơ buơl guhã thơu: Tơgrơ̆ pơnuaĭ glài-sơnoh găm sơ̆ng pơnuaĭ đờm sơk-sơrbĭl khĭn-dơmĭn, kŭng rơŭ hũ anĭt toh-luơi tơ jơi anà mơnih, bloh pơnuaĭ đờm sơk-sơrbĭl khĭn-dơmĭn truh Bơngă Sơc̆ih-Sri, nư̆n rơŭ 'buh hũ anĭt toh-luơi ơu. ");
INSERT INTO cje_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Aràng sơi đờm tămdră-wơ̆ sơ̆ng Anà Mơnih, nư̆n rơŭ hũ anĭt toh-luơi; bloh aràng sơi đờm tămdră-wơ̆ sơ̆ng Yàng Bơngă Sơc̆ih-sri, nư̆n yah rài ni halài rài hơdơi kŭng rơŭ 'buh hũ anĭt toh-luơi.” ");
INSERT INTO cje_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Yah la kơyơu siàm, nư̆n boh kŭng siàm, yah la kơyơu jơhà, nư̆n boh kŭng jơhà; kơyoa c̆ơ boh nư̆n thơu kơyơu. ");
INSERT INTO cje_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ơ jơi-pơtiàn ala mơsak-jơhà dih! Ngă hơyơu buơl guhã hũ rơgơi đờm tơbiă jiơ̆ng pơnuaĭ siàm lăm tŭ hơtai-hơtiàn buơl guhã jơhà? Kơyoa hũ baŭ-bèng lăm hơtai-hơtiàn nư̆n ka bơbah đờm tơbiă. ");
INSERT INTO cje_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Mơnih siàm, kơyoa tơrgùm-pioh pơnuaĭ siàm lăm hơtai-hơtiàn bloh pơtơbiă pơnuaĭ siàm; mơnih jơhà, kơyoa tơrgùm-pioh pơnuaĭ mơsak-jơhà lăm hơtai-hơtiàn bloh pơtơbiă pơnuaĭ mơsak-jơhà. ");
INSERT INTO cje_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Bloh Kơu đờm tơ buơl kơi thơu, truh hơrơi c̆ahrơña, aràng rơŭ păl akhàn-tơbiă abih tơgrơ̆ pơnuaĭ 'buh kwơ-màng bloh drơi hũ đờm tơbiă. ");
INSERT INTO cje_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kơyoa pơnuaĭ đờm bloh hã rơŭ hũ angăn la rĭng-tơpă; kŭng kơyoa pơnuaĭ đờm bloh hã rơŭ kŏng ngă nìn-glài.” ");
INSERT INTO cje_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Tŭ nư̆n hũ du mơnih gơnuăr-pơto pơnuaĭ adăt-adia sơ̆ng du mơnih Pharisi đờm sơ̆ng Yàng Jêsu lài: “Ơ Pô-Pơto, buơl dơlhă khiăng c̆ơ Pô-Pơto ngă sa nàl-c̆rih.” ");
INSERT INTO cje_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yàng Jêsu đờm: “Jơi-pơtiàn mơsak-jơhà sơ̆ng klĕ sơdiŭ-aràng pơsàng-gơŭ ni yòng sa nàl-c̆rih, bloh rơŭ 'buh đồ-mă hũ sa nàl-c̆rih lơi pơkơ̆n, rơlau tơ nàl-c̆rih mơnih gơnuăr-hwơ̆r Jôna. ");
INSERT INTO cje_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Kơyoa yơu Jôna hũ dò lăm tŭng akàn prŏng klơu hơrơi klơu mơlăm, nư̆n Anà Mơnih kŭng rơŭ dò lăm dơrlăm lơ̆n klơu hơrơi klơu mơlăm yơu nư̆n rơi. ");
INSERT INTO cje_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Lăm hơrơi c̆ahrơña, buơl làng Ninibe rơŭ tơgồ dơ̆ng găm sơ̆ng jơi-pơtiàn ni bloh ngă nìn-glài buơl guñu, kơyoa buơl làng nư̆n hũ păng pơnuaĭ Jôna pơto-akhàn sơ̆ng mơbai prah-luơi glài-sơnoh, bloh tơ anih ni, hũ sa Pô prŏng-màng rơlau tơ Jôna! ");
INSERT INTO cje_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Lăm hơrơi c̆ahrơña, mơnih pơtau-kơmơi gah yù rơŭ tơgồ dơ̆ng găm sơ̆ng jơi-pơtiàn ni bloh ngă nìn-glài buơl guñu; kơyoa ñu hũ mư̆ng anih luĭ-dŭt boh tơnah truh păng pơnuaĭ jak-khờh pơtau Salômôn; bloh tơ anih ni, hũ Pô prŏng-màng rơlau Salômôn! ");
INSERT INTO cje_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Tŭ kơmlài sơŭ-sơnoh tơbiă klàh mư̆ng sa aràng mơnih, ñu nau găn du anih thu-thàng tô duah anih dò pơgleh, bloh duah 'buh hũ. ");
INSERT INTO cje_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Bloh nư̆n ñu đờm: ‘Kơu rơŭ gài mơrai wơ̆ tơ sàng bloh kơu pơrpa tơbiă nau.’ Tŭ mơrai wơ̆ truh anih, ñu 'buh sàng nư̆n dò soh, hũ bah uă goh, sơ̆ng pơsăng rơdaŭ siàm. ");
INSERT INTO cje_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Nư̆n ñu nau mư, ba mơrai tơjuh kơmlài pơkơ̆n mơsak-jơhà rơlau tơ ñu wơ̆, tơma dò lăm sàng nư̆n. Yơu nư̆n, rài hơdiŭ mơnih nư̆n hơdơi ni dò jơhà rơlau tơ dơlhơu wơ̆. Jơi-pơtiàn mơsak-jơhà ni kŭng rơŭ yơu nư̆n rơi.” ");
INSERT INTO cje_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Tŭ Yàng Jêsu dò đờm sơ̆ng buơl làng, nư̆n ame sơ̆ng adơi-ai Pô truh, dò dơ̆ng tơ agàh, khiăng đờm glai sơ̆ng Pô. ");
INSERT INTO cje_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Hũ mơnih đờm sơ̆ng Pô lài: “Ơ Pô-Pơto, hũ ame sơ̆ng adơi-ai Pô dò dơ̆ng tơ agàh, khiăng đờm glai sơ̆ng Pô-Pơto.” ");
INSERT INTO cje_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Pô đờm: “Aràng sơi la ame Kơu, aràng sơi la adơi-ai Kơu?” ");
INSERT INTO cje_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Bloh nư̆n Pô yơ̆r tơngàn sơc̆ê tơ du mơnih tui-mơgru Pô sơ̆ng đờm: “Ni la ame Kơu sơ̆ng adơi-ai Kơu! ");
INSERT INTO cje_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Kơyoa yah aràng sơi ngă tui hơtai-khiăng Ama Kơu dò tơ ngŏ lơngì, mơnih nư̆n la adơi-ai, gơŭ kơmơi, sơ̆ng la ame Kơu.” ");
INSERT INTO cje_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Kŭng lăm hơrơi nư̆n, Yàng Jêsu tơbiă mư̆ng sàng, truh dò guh tơ gah ia-tơsì. ");
INSERT INTO cje_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Buơl làng pơtòm-pơgùm gơŭ tòmdăr Pô lô biă, tơ̆l truh Pô păl trŭn lăm gơlài bloh dò guh; abih tơrpuơl buơl làng nư̆n dò dơ̆ng tơ gah ia. ");
INSERT INTO cje_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Pô angui pơnuaĭ pơgăp-pơmơyơu bloh đờm pơto buơl guñu lô pơnuaĭ. Pô đờm: “Hũ sa aràng mơnih tơbiă nau drà găr-pơjeh. ");
INSERT INTO cje_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Lăm tŭ drà, hũ du găr lĕ rò gah jơlàn, c̆ĭm truh 'bơ̆ng abih. ");
INSERT INTO cje_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Du găr pơkơ̆n lĕ iơŭ lăm anih lơ̆n pơtơu, la anih 'buh hũ lô lơ̆n, nư̆n tơmuh tơgồ mư, kơyoa lơ̆n 'buh dơrlăm. ");
INSERT INTO cje_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Bloh tŭ ia-hơrơi tơgồ, kŏng pơđiă gruă, sơ̆ng kơyoa 'buh hũ akha, nư̆n păl mơtai thu. ");
INSERT INTO cje_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Du găr pơkơ̆n lĕ iơŭ lăm puk druơi, druơi đì yùm, ngă tơ ñu mơtai bơrhăt. ");
INSERT INTO cje_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Hũ du găr pơkơ̆n lĕ iơŭ lăm anih lơ̆n siàm, nư̆n tơbiă boh: sa găr tơbiă hũ sa rơtùh, sa găr tơbiă hũ năm pluh, halài sa găr tơbiă hũ klơu pluh. ");
INSERT INTO cje_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Aràng sơi hũ tơnia, nư̆n păng bĕ!” ");
INSERT INTO cje_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Du mơnih tui-mơgru truh jĕ Pô, tơnia lài: “Kơđa hơgĕ Pô-Pơto angui pơnuaĭ pơgăp-pơmơyơu tô đờm sơ̆ng buơl guñu?” ");
INSERT INTO cje_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Pô đờm lài: “Kơyoa buơl guhã nư̆n hũ brơi pơnuaĭ anĭt tô wờng-thơu du pơnuaĭ tơrđơŭ-dơrlăm Lơgăr Lơngì, bloh mư̆ng pơ-ơnah buơl guñu nư̆n 'buh hũ brơi thơu. ");
INSERT INTO cje_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kơyoa aràng sơi hũ, rơŭ hũ brơi pơtơ̆l wơ̆, sơ̆ng buơl guñu rơŭ hũ dơlah-dơlài; bloh mơnih lơi 'buh hũ, nư̆n găm pơnuaĭ buơl guñu hũ, kŭng rơŭ kŏng suă mă rơi. ");
INSERT INTO cje_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Kơyoa nư̆n, Kơu angui pơnuaĭ pơgăp-pơmơyơu tô đờm sơ̆ng buơl guñu, kơyoa buơl guñu c̆ơ bloh 'bu 'buh, pơh tơnia păng bloh 'buh mơhư̆, sơ̆ng 'buh wờng hơgĕ. ");
INSERT INTO cje_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Mư̆ng buơl guñu, nư̆n pơnuaĭ mơnih gơnuăr-hwơ̆r Êsai đờm hũ tơbiă iơŭ tơpă lài: Buơl guhã pơh tơnia păng, bloh 'buh wờng, Mă mơta c̆ơ, bloh 'bu 'buh hơgĕ. ");
INSERT INTO cje_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Kơyoa hơtai-hơtiàn buơl làng ni hũ tơbiă jiơ̆ng kră-khăng; Tơnia buơl guñu traŭ, Mơta buơl guñu pì, Huơĭ lài mơta buơl guñu 'buh jiơ̆ng, Tơnia buơl guñu mơhư̆ jiơ̆ng, Sơ̆ng hơtai-hơtiàn buơl guñu wă-wờng jiơ̆ng, Bloh buơl guñu gài pơsơlih wơ̆, Sơ̆ng Kơu rơŭ pơsồ-pơsaih tơ buơl guñu.” ");
INSERT INTO cje_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Bloh lơngai-pơtuah tơ mơta buơl guhã, kơyoa 'buh jiơ̆ng; lơngai-pơtuah tơ tơnia buơl guhã, kơyoa mơhư̆ jiơ̆ng! ");
INSERT INTO cje_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Iơŭ biă, Kơu đờm sơ̆ng buơl guhã, hũ lô mơnih gơnuăr-hwơ̆r sơ̆ng lô mơnih rĭng-tơpă lơkơu-khiăng 'buh tơgrơ̆ pơnuaĭ buơl guhã 'buh, bloh 'buh hũ 'buh; lơkơu-khiăng mơhư̆ tơgrơ̆ pơnuaĭ buơl guhã mơhư̆, bloh 'buh hũ mơhư̆. ");
INSERT INTO cje_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Yơu nư̆n, buơl guhã păng bĕ pơnuaĭ mơblàng mư̆ng pơnuaĭ pơgăp-pơmơyơu mơnih drà găr-pơjeh. ");
INSERT INTO cje_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Tŭ sa aràng mơnih păng pơto-akhàn mư̆ng Pơnuaĭ Lơgăr Lơngì, bloh 'buh wờng, nư̆n kơmlài mơsak-jơhà truh tămblah-mă thĭt tơgrơ̆ pơnuaĭ hũ drà lăm hơtai-hơtiàn mơnih nư̆n. Ni la găr-pơjeh hũ lĕ rò gah jơlàn. ");
INSERT INTO cje_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Găr-pơjeh lĕ iơŭ lăm anih lơ̆n pơtơu, la mơnih tŭ păng Pơnuaĭ, nư̆n sờh-sài đồ-mă mư, ");
INSERT INTO cje_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","bloh Pơnuaĭ 'buh tơmuh akha lăm hơtai-hơtiàn, mĭn dò sơdăng lăm sa-sĭt tŭ soh; truh tŭ păp bruă gleh-glăr, halài kŏng mă-pơkơŭ kơyoa Pơnuaĭ, nư̆n sơnĕ lơbuh mư. ");
INSERT INTO cje_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Găr-pơjeh lĕ iơŭ lăm puk druơi, nư̆n la mơnih păng Pơnuaĭ, bloh kơyoa pơnuaĭ sơnư̆ng kơ-ù mư̆ng rài ni, sơ̆ng pơnuaĭ hàm-khiăng ngă mơda, hũ ngă tơ Pơnuaĭ kơđòng gơrềt-bơlhăt, nư̆n 'buh tơbiă bơnga boh. ");
INSERT INTO cje_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Bloh găr-pơjeh drà lăm anih lơ̆n siàm, nư̆n la mơnih păng Pơnuaĭ sơ̆ng wờng; mơnih nư̆n rơŭ tơbiă bơnga boh, sa găr tơbiă hũ sa rơtùh, sa găr tơbiă hũ năm pluh, sa găr tơbiă hũ klơu pluh.” ");
INSERT INTO cje_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yàng Jêsu đờm sơ̆ng buơl guñu sa pơnuaĭ pơgăp-pơmơyơu pơkơ̆n: “Lơgăr Lơngì mơhiơ̆ yơu mơnih dih drà găr-pơjeh siàm lăm hơma drơi. ");
INSERT INTO cje_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Bloh tŭ tơgrơ̆ mơnih dò đih, nư̆n mơnih mơbai-tămdră sơ̆ng mơnih nư̆n truh, drà rơ̆ yŭl lăm tơkrah hơma bơdai, bloh nư̆n nau. ");
INSERT INTO cje_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Tŭ bơdai sroh tơgồ sơ̆ng tơbiă bơnga, nư̆n rơ̆ yŭl kŭng tơbiă rơi. ");
INSERT INTO cje_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Du mơnih hơlŭn-hơlă truh đờm sơ̆ng mơnih pô sàng lài: ‘Ơ pô, 'buh iơŭ pô hũ drà găr-pơjeh siàm lăm 'blàng hơma pô ơu? Yơu nư̆n, rơ̆ yŭl kơyoa mư̆ng lơi bloh hũ?’ ");
INSERT INTO cje_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Mơnih pô đờm: ‘Sa aràng mơnih mơbai-tămdră hũ ngă pơnuaĭ nư̆n.’ Du mơnih hơlŭn-hơlă đờm lài: ‘Yơu nư̆n, pô hũ khiăng buơl dơlhă buĭ abih du rơ̆ nư̆n ơu?’ ");
INSERT INTO cje_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Mơnih Pô đờm: ‘Juơi ngă yơu nư̆n, kơyoa huơĭ lài tŭ buĭ rơ̆ yŭl, buơl guhã buĭ asŭ găm phŭn bơdai. ");
INSERT INTO cje_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Kừ luơi abih dua găm sơ̆ng gơŭ tơgồ prŏng tơ̆l truh tơ blàn yuă; tŭ tơma blàn yuă, kơu rơŭ đờm kơkơi du mơnih yuă: Tơrgùm abih rơ̆ yŭl dơlhơu, c̆aŭ wơ̆ jiơ̆ng c̆aŭ, bloh nư̆n c̆uh abih lăm apui; dò bơdai nư̆n tơrgùm-pioh bĕ lăm bŭng tơ kơu.’ ” ");
INSERT INTO cje_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yàng Jêsu đờm sơ̆ng buơl guñu sa pơnuaĭ pơgăp-pơmơyơu pơkơ̆n: “Lơgăr Lơngì mơhiơ̆ yơu sa găr sơmbơi bloh mơnih dih mă dơnih lăm apùh ơñiăm drơi. ");
INSERT INTO cje_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Găr nư̆n la tìt rơlau abih lăm tơgrơ̆ găr-pơjeh, bloh tŭ tơmuh tơgồ, nư̆n prŏng rơlau tơ du jơi ơñiăm sơla, sơ̆ng tơbiă jiơ̆ng yơu phŭn kơyơu, tơ̆l truh c̆ĭm lơngì truh ngă sruh lăm thàn ñu jiơ̆ng.” ");
INSERT INTO cje_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yàng Jêsu kŭng đờm sơ̆ng buơl guñu sa pơnuaĭ pơgăp-pơmơyơu pơkơ̆n: “Lơgăr Lơngì mơhiơ̆ yơu tơpơi bloh mơnih kơmơi dih mă jrơu lăm klơu thŭng tơpŭng, tơ̆l truh tơ tŭ tơpŭng rồ abih.” ");
INSERT INTO cje_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yàng Jêsu angui pơnuaĭ pơgăp-pơmơyơu tô đờm pơto tơgrơ̆ pơnuaĭ nư̆n tơ buơl làng, 'buh sa pơnuaĭ lơi Pô đờm pơto tơ buơl guñu bloh 'buh angui pơnuaĭ pơgăp-pơmơyơu. ");
INSERT INTO cje_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Pơnuaĭ nư̆n hũ ngă iơŭ tơpă yơu pơnuaĭ mơnih gơnuăr-hwơ̆r hũ đờm dơlhơu lài: “Kơu rơŭ pơh kàng tô đờm du pơnuaĭ pơgăp-pơmơyơu, Kơu rơŭ đờm tơbiă tơgrơ̆ pơnuaĭ bơdơŭ-tơrđơŭ mư̆ng tŭ c̆ơmrừp c̆rơ̆ng-tơbiă lơngì-tơsì tơnah-rơya.” ");
INSERT INTO cje_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Hơdơi tŭ brơi buơl làng nau wơ̆, Yàng Jêsu tơma lăm sàng. Du mơnih tui-mơgru truh jĕ, bloh tơnia Pô lài: “Yòng Pô-Pơto mơblàng-tơbiă pơnuaĭ pơgăp-pơmơyơu mư̆ng rơ̆ yŭl lăm 'blàng hơma bơdai tơ buơl dơlhă.” ");
INSERT INTO cje_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Pô đờm: “Mơnih drà găr-pơjeh siàm la Anà Mơnih; ");
INSERT INTO cje_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","'blàng hơma la dun-ya; găr-pơjeh siàm la du anà Lơgăr Lơngì; rơ̆ yŭl la du anà kơmlài mơsak-jơhà; ");
INSERT INTO cje_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","mơnih mơbai-tămdră drà rơ̆ yŭl la kơmlài-jĭnràk; blàn yuă la hơrơi luĭ-dŭt rài dun-ya; mơnih yuă la du mơnih gơdrưh. ");
INSERT INTO cje_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Yơu rơ̆ yŭl kơđòng tơrgùm wơ̆ sơ̆ng c̆uh lăm apui hơyơu lơi, nư̆n hơrơi luĭ-dŭt rài dun-ya ni kŭng yơu nư̆n rơi. ");
INSERT INTO cje_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Anà Mơnih rơŭ pơđăr du mơnih gơdrưh Pô duơ̆n tơrgùm abih tơgrơ̆ mơnih ngă pơnuaĭ glài-sơnoh sơ̆ng tơgrơ̆ mơnih ngă pơnuaĭ mơsak-jơhà klàh mư̆ng lơgăr Pô, ");
INSERT INTO cje_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","bloh nư̆n prah guñu lăm rơhồng-apui, la anih rơŭ hũ hia-c̆ŏ sơ̆ng kĕ tơgơi. ");
INSERT INTO cje_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Tŭ nư̆n, du mơnih rĭng-tơpă rơŭ kơc̆rà-sơrdah yơu ia-hơrơi lăm lơgăr Ama drơi. Aràng sơi hũ tơnia, păng-mơhư̆ bĕ!” ");
INSERT INTO cje_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Lơgăr Lơngì mơhiơ̆ yơu phơ̆n c̆ơk-màng dơ̆r bơdơŭ lăm 'blàng hơma. Hũ sa aràng mơnih dih duah hũ nư̆n bơdơŭ wơ̆, bloh nư̆n sờh-sài gài mơrai wơ̆ pơblơi abih tơgrơ̆ hơgĕ drơi hũ, tô blơi 'blàng hơma nư̆n.” ");
INSERT INTO cje_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Lơgăr Lơngì kŭng mơhiơ̆ yơu sa aràng mơnih akă-bơnia dih nau duah pơtơu c̆ơk-màng, ");
INSERT INTO cje_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","tŭ duah hũ sa găr pơtơu c̆ơk-màng, mơnih nư̆n gài nau wơ̆ pơblơi abih tơgrơ̆ phơ̆n hơgĕ drơi hũ tô blơi găr pơtơu c̆ơk-màng nư̆n.” ");
INSERT INTO cje_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Lơgăr Lơngì kŭng mơhiơ̆ yơu sa boh sơñuăl dăng trŭn lăm ia-tơsì, mă tơ̆l abih tơgrơ̆ mơta akàn. ");
INSERT INTO cje_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Tŭ sơñuăl baŭ, aràng kơtŭng đì tơ gah ia, bloh nư̆n dò guh rơwah akàn siàm pioh lăm bài, dò du akàn jơhà nư̆n prah luơi abih. ");
INSERT INTO cje_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Truh hơrơi luĭ-dŭt rài dun-ya ni kŭng yơu nư̆n rơi. Du mơnih gơdrưh rơŭ truh, pơklah-krơi mơnih mơsak-jơhà klàh mư̆ng mơnih rĭng-tơpă, ");
INSERT INTO cje_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","sơ̆ng prah du mơnih mơsak-jơhà tơma lăm rơhồng-apui, tơ anih nư̆n rơŭ hũ hia c̆ŏ sơ̆ng kĕ tơgơi.” ");
INSERT INTO cje_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“Buơl guhã hũ wờng tơgrơ̆ pơnuaĭ nư̆n ơu?” Du mơnih tui-mơgru đờm: “Buơl dơlhă wờng.” ");
INSERT INTO cje_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Pô đờm lài: “Kơyoa nư̆n, du mơnih gơnuăr-pơto pơnuaĭ adăt-adia hũ mơgru thơu mư̆ng Lơgăr Lơngì, kŭng mơhiơ̆ yơu mơnih pô sàng dih, mă tơbiă mư̆ng anih pioh phơ̆n c̆ơk-màng drơi găm phơ̆n bơrhơu sơ̆ng phơ̆n klă.” ");
INSERT INTO cje_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Hơdơi tŭ Yàng Jêsu đờm pơto du pơnuaĭ pơgăp-pơmơyơu nư̆n, Pô nau klàh mư̆ng anih nư̆n. ");
INSERT INTO cje_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Pô gài nau wơ̆ tơ plơi phŭn, bloh nư̆n pơto-mơblàng lăm sàng pơtòm, buơl làng mă ngă c̆rih-takơtuă đờm lài: “Kơyoa mư̆ng lơi bloh mơnih ni hũ pơnuaĭ jak-khờh sơ̆ng ngă jiơ̆ng du bruă gơnăp-gơnuăr yơu nư̆n? ");
INSERT INTO cje_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ni 'buh iơŭ la anà lơkơi mơnih khờh trah kơyơu ơu? Ame ñu 'buh iơŭ la Mari, sơ̆ng adơi-ai ñu la Jakơ, Jôsep, Simôn, sơ̆ng Juđe ơu? ");
INSERT INTO cje_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Abih du gơŭ kơmơi ñu 'buh iơŭ la dò hơdiŭ tơkrah buơl gudrơi ơu? Yơu nư̆n, kơyoa mư̆ng lơi bloh mơnih ni hũ tơgrơ̆ pơnuaĭ nư̆n?” ");
INSERT INTO cje_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Sơ̆ng buơl guñu sơnĕ lơbuh lăm pơnuaĭ sŭng kơyoa Pô. Bloh Yàng Jêsu đờm sơ̆ng buơl guñu: “Mơnih gơnuăr-hwơ̆r mĭn 'buh hũ aràng c̆ơ prŏng-màng lăm plơi-lơgăr phŭn sơ̆ng sàng dơnò drơi soh.” ");
INSERT INTO cje_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Pô 'buh ngă lô bruă gơnăp-gơnuăr tơ anih nư̆n, kơyoa buơl guñu 'buh păng-tui. ");
INSERT INTO cje_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Tŭ nư̆n, pơtau Herôt Antipa, la pơtau apăn-akŏ c̆àr Galile, hũ mơhư̆ đờm tiơ̆ng mư̆ng angăn Yàng Jêsu, ");
INSERT INTO cje_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","nư̆n đờm sơ̆ng du mơnih duh bruă drơi lài: “Ni la Jăng 'Baptis. Mơnih mư̆ng anih mơtai hơdiŭ wơ̆, nư̆n ka hũ rơgơi ngă jiơ̆ng du bruă gơnăp-gơnuăr yơu nư̆n.” ");
INSERT INTO cje_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Kơyoa Herôt hũ mă, c̆aŭ sơ̆ng krơ̆-jàm Jăng 'Baptis kơyoa bruă Herôdias, sơdiŭ Philip, adơi lơkơi pơtau. ");
INSERT INTO cje_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Kơyoa Jăng hũ đờm khă pơtau lài: “Pơtau khiăng sơ̆ng mơnih kơmơi nư̆n la 'buh iơŭ adăt.” ");
INSERT INTO cje_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Yah Herôt khiăng pơmơtai Jăng, bloh pơtau huơĭ tơ buơl làng, kơyoa buơl guñu c̆ơ Jăng 'Baptis la sa aràng mơnih gơnuăr-hwơ̆r. ");
INSERT INTO cje_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Bloh, tŭ truh pơnuaĭ mơñŭm 'bơ̆ng sơdơ̆r hơrơi đih apui pơtau Herôt, anà kơmơi Herôdias tơbiă tăm-ya tơ anaŭ tơgrơ̆ mơnih thuai truh mơñŭm 'bơ̆ng, ngă sờh-siàm hơtai-hơtiàn Herôt, ");
INSERT INTO cje_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","tơ̆l truh pơtau tơpah-sri đờm pơguăn lài: yah hơgĕ ñu yòng pơtau kŭng rơŭ brơi rơi. ");
INSERT INTO cje_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Păng pơnuaĭ ame ñu pơsŭt-pơđăr, kơmơi dra nư̆n đờm: “Yòng pơtau brơi tơ dơlhă akŏ Jăng 'Baptis daŭ lăm sơlào!” ");
INSERT INTO cje_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Pơtau mă ngă dơnuh-dơnà, bloh kơyoa rơlau đờm tơpah-sri tơ anaŭ lô mơnih thuai truh mơñŭm 'bơ̆ng, nư̆n pơđăr brơi tơ ñu tui pơnuaĭ ñu yòng. ");
INSERT INTO cje_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Pơtau pơđăr mơnih nau koh akŏ Jăng lăm sàng jàm. ");
INSERT INTO cje_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Bloh nư̆n buơl guñu daŭ akŏ Jăng lăm sơlào, apăn truh tơ kơmơi dra, kơmơi dra nư̆n apăn truh tơ ame drơi. ");
INSERT INTO cje_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Hơdơi mư̆ng nư̆n, du mơnih tui-mơgru Jăng truh, mă rùp atơu ñu apăn nau dơ̆r, bloh nư̆n nau akhàn pơthơu tơ Yàng Jêsu. ");
INSERT INTO cje_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Mơhư̆ pơnuaĭ nư̆n, Yàng Jêsu trŭn gơlài, nau klàh mư̆ng anih nư̆n, truh tơ sa anih jơhua-kơđơ̆ng. Thơu yơu nư̆n, buơl làng mư̆ng du plơi-prŏng nau tơkai bloh tui Pô. ");
INSERT INTO cje_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Pơrpa tơbiă mư̆ng gơlài, Yàng Jêsu 'buh sa tơrpuơl buơl làng lô biă, nư̆n mă hơtai-hơtiàn anĭt-anăr, sơ̆ng pơsồ-pơsaih tơ abih du mơnih lơ-ơ̆n lơngoh rơwă-sơkì lăm buơl guñu. ");
INSERT INTO cje_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Truh glai diơŭ, du mơnih tui-mơgru truh jĕ, đờm sơ̆ng Pô: “Anih ni jơhua-kơđơ̆ng biă, sơ̆ng lơngì kŭng mơlăm bơjơ, yòng Pô-Pơto brơi buơl làng nau wơ̆, tô buơl guñu tơma lăm du plơi bloh blơi phơ̆n 'bơ̆ng.” ");
INSERT INTO cje_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yàng Jêsu đờm: “Buơl guñu 'buh c̆àng păl nau anih lơi; rùp-phŭn buơl guhã păl brơi buơl guñu 'bơ̆ng.” ");
INSERT INTO cje_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Du mơnih tui-mơgru đờm lài: “Tơ anih ni, buơl dơlhă mĭn hũ lơma boh pah sơ̆ng dua drơi akàn.” ");
INSERT INTO cje_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Pô đờm: “Apăn bĕ du pah sơ̆ng akàn nư̆n mơrai tơ Kơu.” ");
INSERT INTO cje_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Hơdơi tŭ đờm pơđăr tơrpuơl buơl làng dò guh lăm 'blàng rơ̆, Pô mă lơma boh pah sơ̆ng dua drơi akàn, tơ̆ mơta tơ ngŏ lơngì, ưnjơmừn, bloh nư̆n 'bĕt pah brơi tơ du mơnih tui-mơgru; du mơnih tui-mơgru pơrpha tơ buơl làng. ");
INSERT INTO cje_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Abih tơgrơ̆ mơnih 'bơ̆ng trơi. Du pĕt pah dò dơlah, buơl guñu duơ̆n wơ̆ hũ sa-pluh dua bài baŭ. ");
INSERT INTO cje_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Khà mơnih 'bơ̆ng pơgăp lơma rơbơu aràng, 'buh kơrhia mơnih kơmơi sơ̆ng lơ-ơneh tìt. ");
INSERT INTO cje_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Hơdơi mư̆ng nư̆n, Yàng Jêsu pơjă pơđăr du mơnih tui-mơgru tơma lăm gơlài, nau dơlhơu tơ gah dih ia, lăm tŭ Pô dò brơi buơl làng nau wơ̆. ");
INSERT INTO cje_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Tŭ buơl làng nau wơ̆ abih bơjơ, Pô nau krơi sa aràng Pô, đì tơ ngŏ c̆ơ̆ tô iơu-lài. Mơlăm truh, Pô sơđaŭ dò tơ anih nư̆n sa aràng Pô. ");
INSERT INTO cje_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Lăm tŭ nư̆n, gơlài hũ tơbiă truh tơkrah ia-tơsì bơjơ, kơyoa rơbù blùh tơrblơ̆, nư̆n kơđòng rơyà ia poh. ");
INSERT INTO cje_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Pơgăp pà jơ ờm mơlăm nư̆n, Yàng Jêsu nau tơ ngŏ sơla ia-tơsì bloh truh sơ̆ng du mơnih tui-mơgru. ");
INSERT INTO cje_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Tŭ 'buh Pô nau tơ ngŏ sơla ia-tơsì, du mơnih tui-mơgru huơĭ-kìr biă bloh đờm lài: “Nư̆n la atơu!” Bloh nư̆n buơl guñu kơmrào driau kơyoa huơĭ-kơđa. ");
INSERT INTO cje_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Bloh Yàng Jêsu đờm mư lài: “Kơđơ̆ng-kơjăp hơtai-hơtiàn bĕ! Kơu ni, juơi huơĭ!” ");
INSERT INTO cje_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pier đờm sơ̆ng Pô: “Khoai Yàng, yah iơŭ biă la Pô, yòng brơi dơlhă nau tơ ngŏ sơla ia bloh truh sơ̆ng Yàng.” ");
INSERT INTO cje_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Pô đờm: “Mơrai bĕ tơ ni.” Pier tơbiă mư̆ng gơlài, yàm nau tơ ngŏ sơla ia-tơsì, bloh truh sơ̆ng Yàng Jêsu. ");
INSERT INTO cje_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Bloh tŭ 'buh rơbù blùh, nư̆n Pier huơĭ-kơđa, sơmŏng krăm lăm ia, nư̆n driau prŏng lài: “Ơ Yàng, yòng dŏng dơlhă!” ");
INSERT INTO cje_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Tŭ nư̆n mư, Yàng Jêsu yơ̆r tơngàn apăn mă Pier, sơ̆ng đờm lài: “Ơ mơnih tơkì pơnuaĭ păng-tui, kơđa hơgĕ hã 'buh kơjăp hơtai-hơtiàn păng-tui?” ");
INSERT INTO cje_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Tŭ Pô sơ̆ng Pier tơma lăm gơlài bơjơ, nư̆n rơbù kơđơ̆ng-rik mư. ");
INSERT INTO cje_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Du mơnih lăm gơlài truh pơđih rùp c̆ĕ-khoai Pô, sơ̆ng đờm lài: “Pô-Pơto iơŭ biă la Anà Yàng Pô Lơngì!” ");
INSERT INTO cje_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Tŭ hũ truh tơ gah dih ia-tơsì bơjơ, Yàng Jêsu sơ̆ng du mơnih tui-mơgru truh lăm c̆àr Genesaret. ");
INSERT INTO cje_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Buơl làng tơ anih nư̆n kràn-thơu Pô, nư̆n pơđăr mơnih nau đờm brơi pơthơu lăm abih du c̆àr tòmdăr, sơ̆ng buơl guñu apăn abih du mơnih lơ-ơ̆n lơngoh rơwă-sơkì truh sơ̆ng Pô. ");
INSERT INTO cje_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Buơl guñu yòng lơkơu Pô mĭn brơi buơl guñu rơwơ̆ tơ aku ào Pô soh. Sơ̆ng tơgrơ̆ mơnih lơi rơwơ̆ truh, nư̆n hũ pơsồ-pơsaih abih. ");
INSERT INTO cje_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Tŭ nư̆n, hũ du mơnih Pharisi sơ̆ng du mơnih gơnuăr-pơto pơnuaĭ adăt-adia mư̆ng plơi-prŏng Jerusalem truh sơ̆ng Yàng Jêsu, bloh đờm lài: ");
INSERT INTO cje_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Kơđa hơgĕ du mơnih tui-mơgru Pô-Pơto ngă sŭng pơnuaĭ adăt-lơđăp mơnih yau c̆ĕ luơi? Kơyoa buơl guñu 'buh rào tơngàn dơlhơu tŭ 'bơ̆ng.” ");
INSERT INTO cje_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Pô đờm: “Nư̆n kơđa hơgĕ buơl guhã kŭng kơyoa pơnuaĭ adăt-lơđăp yau drơi bloh ngă sŭng pơnuaĭ adăt-pơđăr Yàng Pô Lơngì? ");
INSERT INTO cje_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kơyoa Yàng Pô Lơngì hũ đờm pơto: ‘Păl thơu-adăt bĕ tơ ame ama hã’ sơ̆ng ‘aràng sơi alĕ-aluah ame ama nư̆n păl kŏng pơmơtai!’ ");
INSERT INTO cje_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Bloh buơl guhã đờm lài: ‘Yah aràng sơi đờm sơ̆ng ame ama lài: Tơgrơ̆ pơnuaĭ hơgĕ anà hũ rơgơi dŏng ame ama, anà hũ pơyă tơ Yàng Pô Lơngì bơjơ,’ nư̆n mơnih nư̆n 'buh c̆àng păl thơu-adăt ame ama tra. ");
INSERT INTO cje_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Yơu nư̆n, kơyoa mư̆ng adăt-lơđăp yau drơi, buơl guhã hũ klà luơi pơnuaĭ Yàng Pô Lơngì. ");
INSERT INTO cje_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ơ du mơnih hơtai-hơtiàn mơthĭ-lơ̆r! Mơnih gơnuăr-hwơ̆r Êsai hũ đờm hwơ̆r mư̆ng buơl guhã la tơpă iơŭ biă, tŭ ñu đờm lài: ");
INSERT INTO cje_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Buơl làng mĭn păng-duh Kơu sơ̆ng kàng-bơbah; Bloh hơtai-hơtiàn buơl guñu atàh tơ Kơu biă. ");
INSERT INTO cje_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Bruă guñu duh-dơlbăt Kơu la 'buh kwơ, Pơnuaĭ guñu pơto mĭn la du adăt-pơđăr kơyoa mư̆ng jơi anà mơnih.’ ” ");
INSERT INTO cje_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Hơdơi mư̆ng nư̆n, Pô iơu tơrpuơl buơl làng truh, bloh đờm lài: “Păng bĕ sơ̆ng wờng tô loh-làng: ");
INSERT INTO cje_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","'Buh iơŭ phơ̆n hơgĕ tơma lăm kàng ngă tơ anà mơnih tơbiă jiơ̆ng sơŭ-sơnoh; bloh pơnuaĭ hơgĕ mư̆ng kàng tơbiă, pơnuaĭ nư̆n ka ngă tơ anà mơnih tơbiă jiơ̆ng sơŭ-sơnoh.” ");
INSERT INTO cje_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Du mơnih tui-mơgru Pô truh jĕ đờm sơ̆ng Pô: “Pô-Pơto hũ thơu lài du mơnih Pharisi anok hơtai biă tŭ mơhư̆ Pô-Pơto đờm yơu nư̆n ơu?” ");
INSERT INTO cje_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Pô đờm: “Kơyơu lơi Ama Kơu tơ ngŏ lơngì 'buh pla, nư̆n păl buĭ prah. ");
INSERT INTO cje_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Kừ luơi mơti buơl guñu. Buơl guñu la du mơnih bồm dùi mơnih bồm. Yah mơnih bồm dùi mơnih bồm, nư̆n abih dua rơŭ lĕ lăm lơbàng.” ");
INSERT INTO cje_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pier đờm lài: “Yòng Pô-Pơto mơblàng tơbiă pơnuaĭ pơgăp-pơmơyơu nư̆n tơ buơl dơlhă.” ");
INSERT INTO cje_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yàng Jêsu tơnia: “Buơl guhã kŭng ka wờng ơu rơi? ");
INSERT INTO cje_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Buơl guhã 'buh thơu lài phơ̆n hơgĕ tơma lăm kàng, rơŭ trŭn lăm tŭng, bloh nư̆n kŏng pơtơbiă tơ agàh ơu? ");
INSERT INTO cje_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Bloh tơgrơ̆ pơnuaĭ hơgĕ mư̆ng kàng tơbiă, la tơbiă mư̆ng hơtai-hơtiàn, tơgrơ̆ pơnuaĭ nư̆n ka ngă sơŭ-sơnoh anà mơnih. ");
INSERT INTO cje_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kơyoa mư̆ng dơrlăm hơtai-hơtiàn bloh tơbiă du pơnuaĭ sơnư̆ng jơhà, du glài pơmơtai mơnih, klĕ sơdiŭ-aràng pơsàng-gơŭ, dri-sơnoh bŭng-pơkăl, klĕ blơ̆, ngă grơh lơ̆r, sơ̆ng pơtăt-bơrlơi mơnih pơkơ̆n. ");
INSERT INTO cje_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Nư̆n ka la tơgrơ̆ pơnuaĭ ngă sơŭ-sơnoh anà mơnih; dò bruă 'bơ̆ng bloh 'buh rào tơngàn, 'buh ngă sơŭ-sơnoh anà mơnih ơu.” ");
INSERT INTO cje_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Mư̆ng nư̆n, Yàng Jêsu nau tơma lăm c̆àr-tơnah plơi-prŏng Tirơ sơ̆ng Siđôn. ");
INSERT INTO cje_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Dih, hũ sa aràng mơnih kơmơi Kanaan mư̆ng c̆àr nư̆n truh, sơ̆ng iơu yòng lài: “Khoai Yàng, Anà pơtau Đabit, yòng anĭt-anăr dơlhă, anà kơmơi dơlhă kơđòng kơmlài ngă, gleh-glăr biă.” ");
INSERT INTO cje_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Bloh Pô 'buh đờm sơđồ sa boh pơnuaĭ. Du mơnih tui-mơgru truh jĕ bloh đờm sơ̆ng Pô lài: “Yòng Pô-Pơto đờm sơ̆ng mơnih kơmơi nư̆n nau wơ̆ bĕ, kơyoa ñu kừ nau tui gah rŏng buơl gudrơi bloh lơkơu-yòng mĭt.” ");
INSERT INTO cje_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Pô đờm: “Kơu hũ pơđăr truh, mĭn kơyoa du abo c̆ơrlah lơhiă sàng Israel soh.” ");
INSERT INTO cje_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Bloh mơnih kơmơi nư̆n truh, c̆ĕ-khoai tơ anaŭ Pô sơ̆ng đờm: “Khoai Yàng, yòng Yàng anĭt-dŏng dơlhă!” ");
INSERT INTO cje_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Pô đờm: “Mă pah du anà bloh prah brơi tơ asơu 'bơ̆ng, la pơnuaĭ 'buh iơŭ adăt.” ");
INSERT INTO cje_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Mơnih kơmơi đờm: “Khoai Yàng, iơŭ biă yơu nư̆n, bloh du asơu kŭng hũ 'bơ̆ng du pĕt pah mơrùi mư̆ng ngŏ c̆ơnừng mơnih pô hŏ trŭn tơ ala.” ");
INSERT INTO cje_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Tŭ nư̆n Yàng Jêsu đờm: “Ơ mơnih kơmơi dih, hã hũ pơnuaĭ păng-tui prŏng! Bruă păl tơbiă truh tui yơu pơnuaĭ hã lơkơu-khiăng.” Kŭng lăm jơ nư̆n, anà kơmơi ñu hũ pơsồ-pơsaih. ");
INSERT INTO cje_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yàng Jêsu mư̆ng anih nư̆n nau truh tơ gah ia-tơsì Galile; Pô đì tơ ngŏ c̆ơ̆ sơ̆ng dò guh tơ anih nư̆n. ");
INSERT INTO cje_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Tŭ nư̆n hũ tơrpuơl mơnih lô biă truh sơ̆ng Pô. Buơl guñu ba tui du mơnih kwĕt-kơlte, mơnih bồm, mơnih kơmlo, mơnih joh-je găm sơ̆ng lô mơnih lơ-ơ̆n lơngoh rơwă-sơkì pơkơ̆n. Buơl guñu daŭ du mơnih nư̆n tơ anih tơkai Pô, sơ̆ng Pô pơsồ-pơsaih tơ buơl guñu. ");
INSERT INTO cje_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Buơl làng mă ngă c̆rih-takơtuă biă tŭ 'buh mơnih kơmlo đờm jiơ̆ng, mơnih joh-je hũ pơsồ-pơsaih, mơnih kwĕt-kơlte nau jiơ̆ng, mơnih bồm 'buh jiơ̆ng. Sơ̆ng buơl guñu mơyòm-pơglòng Yàng Pô Lơngì buơl làng Israel. ");
INSERT INTO cje_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Tŭ nư̆n, Yàng Jêsu iơu du mơnih tui-mơgru truh, sơ̆ng đờm lài: “Kơu anĭt-anăr buơl làng ni, kơyoa buơl guñu hũ dò sơ̆ng Kơu klơu hơrơi bơjơ, sơ̆ng 'buh hũ phơ̆n hơgĕ tô 'bơ̆ng. Kơu 'buh khiăng luơi buơl guñu tŭng lơpa bloh nau wơ̆, huơĭ lài buơl guñu rơŭ lơphuơi-gleh bloh lơbuh rò jơlàn.” ");
INSERT INTO cje_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Du mơnih tui-mơgru đờm: “Tơkrah anih 'blàng-jơhua ni, buơl gudrơi duah anih lơi tơ̆l pah tô brơi tơrpuơl buơl làng lô ni 'bơ̆ng?” ");
INSERT INTO cje_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Pô tơnia du mơnih tui-mơgru: “Buơl guhã hũ hơdùm boh pah?” Buơl guñu đờm: “Hũ tơjuh boh pah sơ̆ng du drơi akàn tìt.” ");
INSERT INTO cje_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Tŭ nư̆n, Pô đờm pơđăr tơrpuơl buơl làng dò guh tơ ala lơ̆n. ");
INSERT INTO cje_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Pô mă tơjuh boh pah sơ̆ng du drơi akàn, ưnjơmừn, bloh nư̆n 'bĕt brơi tơ du mơnih tui-mơgru; du mơnih tui-mơgru pơrpha tơ tơrpuơl buơl làng. ");
INSERT INTO cje_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Abih tơgrơ̆ mơnih 'bơ̆ng trơi. Du pĕt pah dơlah, buơl guñu duơ̆n wơ̆ hũ tơjuh bài baŭ. ");
INSERT INTO cje_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Khà mơnih 'bơ̆ng la pà rơbơu, 'buh kơrhia mơnih kơmơi sơ̆ng lơ-ơneh tìt. ");
INSERT INTO cje_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Hơdơi tŭ brơi tơrpuơl buơl làng nau wơ̆, Pô trŭn lăm gơlài, tô nau tơ c̆àr Magadan. ");
INSERT INTO cje_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Du mơnih Pharisi sơ̆ng Sađuse truh tơnia tô lòng Yàng Jêsu. Buơl guñu yòng Pô brơi buơl guñu 'buh sa nàl-c̆rih mư̆ng lơngì. ");
INSERT INTO cje_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Bloh Pô đờm: “Tŭ glai diơŭ truh, nư̆n buơl guhã đờm lài: ‘Hơrơi pơgi glai-glo rơŭ siàm, kơyoa lơngì mơr-yah.’ ");
INSERT INTO cje_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Lăm glai ờm rìng, buơl guhã đờm: ‘Hơrơi ni rơŭ hũ hơjàn-angĭn, kơyoa lơngì mơr-yah sơ̆ng kơdơ̆r.’ Buơl guhã thơu kràn-kơnăl loh-làng glai-glo pơsơlih, bloh 'buh kràn-kơnăl jiơ̆ng nàl pơto mư̆ng tŭ-hơrơi ơu? ");
INSERT INTO cje_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Jơi-pơtiàn mơsak-jơhà dri-sơnoh ni yòng sa nàl-c̆rih, bloh buơl guñu rơŭ 'buh hũ brơi sa nàl-c̆rih lơi rơlau tơ nàl-c̆rih mơnih gơnuăr-hwơ̆r Jôna.” Bloh nư̆n Pô luơi buơl guñu bloh nau. ");
INSERT INTO cje_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Tŭ nau truh tơ gah dih ia bơjơ, nư̆n ka du mơnih tui-mơgru thơu la buơl guñu wơ̆rglai apăn pah tui. ");
INSERT INTO cje_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yàng Jêsu đờm sơ̆ng buơl guñu: “Kơrmăp rùp bĕ sơ̆ng c̆ơ-kơrhia mư̆ng tơpơi mơnih Pharisi sơ̆ng Sađuse.” ");
INSERT INTO cje_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Du mơnih tui-mơgru đờm tămbơyai sơ̆ng gơŭ: “Pô-Pơto đờm yơu nư̆n la kơyoa buơl gudrơi 'buh apăn pah tui.” ");
INSERT INTO cje_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Bloh Yàng Jêsu thơu pơnuaĭ nư̆n sơ̆ng đờm: “Ơ du mơnih tơkì pơnuaĭ păng-tui! Kơđa hơgĕ buơl guhã đờm tămbơyai sơ̆ng gơŭ mư̆ng bruă buơl guhã 'buh hũ pah? ");
INSERT INTO cje_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Buơl guhã sơđaŭ ka wờng ơu rơi? Buơl guhã dò sơdơ̆r lơma boh pah brơi tơ lơma rơbơu mơnih 'bơ̆ng, sơ̆ng buơl guhã duơ̆n wơ̆ hũ hơdùm bài pah dơlah ơu? ");
INSERT INTO cje_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Halài tơjuh boh pah brơi tơ pà rơbơu mơnih 'bơ̆ng, sơ̆ng buơl guhã duơ̆n wơ̆ hũ hơdùm bài pah dơlah? ");
INSERT INTO cje_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Kơđa hơgĕ buơl guhã 'buh wờng lài Kơu 'buh iơŭ đờm mư̆ng pah? Bloh păl c̆ơ-kơrhia bĕ mư̆ng tơpơi mơnih Pharisi sơ̆ng Sađuse.” ");
INSERT INTO cje_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Tŭ nư̆n ka du mơnih tui-mơgru wờng lài 'buh iơŭ Pô đờm pơđăr buơl guñu c̆ơ-kơrhia mư̆ng tơpơi ngă pah, bloh păl c̆ơ-kơrhia mư̆ng pơnuaĭ mơnih Pharisi sơ̆ng Sađuse pơto-pơsài. ");
INSERT INTO cje_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Tŭ Yàng Jêsu nau tơma lăm c̆àr-tơnah plơi-prŏng Sesare Philip, Pô tơnia du mơnih tui-mơgru: “Tui pơnuaĭ ràng đờm nư̆n Anà Mơnih la aràng sơi?” ");
INSERT INTO cje_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Du mơnih tui-mơgru đờm: “Hũ du mơnih nư̆n đờm la Jăng 'Baptis, du mơnih pơkơ̆n đờm la Eli, du mơnih pơkơ̆n wơ̆ đờm la Jeremi halài sa aràng lăm du mơnih gơnuăr-hwơ̆r.” ");
INSERT INTO cje_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Pô đờm lài: “Dò buơl guhã, buơl guhã đờm Kơu la aràng sơi?” ");
INSERT INTO cje_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simôn Pier đờm lài: “Pô-Pơto la Pô Krist, Anà Yàng Pô Lơngì, Pô hơdiŭ rài pơdò rài.” ");
INSERT INTO cje_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yàng Jêsu đờm sơ̆ng ñu: “Ơ Simôn anà Jôna! Lơngai-pơtuah tơ hã, kơyoa 'buh iơŭ drah sơ̆ng rơlo akhàn-tơbiă pơnuaĭ ni tơ hã, bloh la Ama Kơu dò tơ ngŏ lơngì. ");
INSERT INTO cje_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Dò Kơu, Kơu đờm sơ̆ng hã: Hã la Pier, Kơu rơŭ bơ̆ Tơrpuơl Goh-Sơc̆ih Kơu tơ ngŏ boh pơtơu ni, du bơh 'băng lơgăr-atơu rơŭ 'buh pha-jai jiơ̆ng Tơrpuơl nư̆n. ");
INSERT INTO cje_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Kơu rơŭ jào kai-kăl bơh 'băng Lơgăr Lơngì tơ hã, tơgrơ̆ pơnuaĭ hơgĕ hã akă tơ ala lơ̆n, kŭng rơŭ kơđòng akă tơ ngŏ lơngì, sơ̆ng tơgrơ̆ pơnuaĭ hơgĕ hã tơleh tơ ala lơ̆n, kŭng rơŭ hũ tơleh tơ ngŏ lơngì.” ");
INSERT INTO cje_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Bloh nư̆n Pô pơkơŭ du mơnih tui-mơgru 'buh hũ đờm tơ aràng sơi thơu Pô la Pô Krist. ");
INSERT INTO cje_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Mư̆ng tŭ nư̆n, Yàng Jêsu tơma đờm loh-làng tơ du mơnih tui-mơgru Pô thơu lài Pô păl nau truh tơ plơi-prŏng Jerusalem, păl kŏng lô pơnuaĭ pơđì-pơđoa gleh-glăr kơyoa mư̆ng du mơnih gơnuăr-tha, du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt sơ̆ng du mơnih gơnuăr-pơto pơnuaĭ adăt-adia, sơ̆ng păl kŏng pơmơtai, bloh nư̆n klơu hơrơi hơdơi rơŭ hơdiŭ wơ̆. ");
INSERT INTO cje_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pier ba Pô tơbiă krơi sa gah, sơ̆ng đờm khă 'buah lài: “Khoai Yàng, Yàng Pô Lơngì 'buh tŭ lơi ngă yơu nư̆n ơu. Pơnuaĭ nư̆n rơŭ 'buh tơbiă truh tơ Pô-Pơto ơu!” ");
INSERT INTO cje_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Bloh Pô pơtrah wơ̆ đờm sơ̆ng Pier: “Ơ Satăn, rŭt gơdŭn bĕ gah rŏng Kơu! Hã ngă krơh jơhà tơ Kơu. Kơyoa hã 'buh sơnư̆ng truh bruă Yàng Pô Lơngì, bloh mĭn sơnư̆ng truh bruă jơi anà mơnih.” ");
INSERT INTO cje_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Bloh nư̆n Yàng Jêsu đờm sơ̆ng du mơnih tui-mơgru lài: “Yah aràng sơi khiăng tui Kơu, păl prah luơi rùp-phŭn drơi, glăm kơyơu pơkăl drơi bloh tui Kơu. ");
INSERT INTO cje_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kơyoa aràng sơi khiăng dŏng pơnuaĭ hơdiŭ drơi, nư̆n rơŭ lơhiă, dò aràng sơi kơyoa Kơu bloh lơhiă pơnuaĭ hơdiŭ, nư̆n rơŭ duah hũ wơ̆. ");
INSERT INTO cje_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Yah mơnih lơi hũ abih dun-ya bloh lơhiă bơngă-joa drơi, nư̆n rơŭ hũ kwơ-màng hơgĕ? Mơnih nư̆n rơŭ mă hơgĕ tô pơsơlih bơngă-joa drơi wơ̆? ");
INSERT INTO cje_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Kơyoa Anà Mơnih rơŭ truh lăm pơnuaĭ màng-kơc̆rà Ama drơi, găm sơ̆ng du mơnih gơdrưh. Tŭ nư̆n, Pô rơŭ brơi phơ̆n mơyòm-brơi tơ yàu aràng, tui sơ̆ng bruă buơl guñu ngă. ");
INSERT INTO cje_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Iơŭ biă, Kơu đờm sơ̆ng buơl guhã, lăm du mơnih dò dơ̆ng tơ anih ni, hũ du mơnih rơŭ 'buh mơtai dơlhơu tơ tŭ 'buh Anà Mơnih truh lăm lơgăr Pô.” ");
INSERT INTO cje_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Năm hơrơi hơdơi, Yàng Jêsu ba krơi Pier, Jakơ sơ̆ng Jăng la adơi Jakơ, nau sơ̆ng Pô đì tơ sa boh c̆ơ̆ glòng. ");
INSERT INTO cje_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Pô sơrlơŭ-pơsơlih rùp tơ anaŭ buơl guñu. 'Bò mơta Pô sơrdah kơc̆rà yơu ia-hơrơi, ào Pô tơbiă jiơ̆ng kò yơu sơrdah c̆ơnà. ");
INSERT INTO cje_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Dih, hũ Môise sơ̆ng Eli tơbiă pơ'buh mơta, đờm glai sơ̆ng Pô. ");
INSERT INTO cje_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pier đờm sơ̆ng Yàng Jêsu lài: “Khoai Yàng, buơl gudrơi dò tơ anih ni siàm biă; yah Pô khiăng, dơlhă rơŭ ngă tơ anih ni klơu boh pờ, sa boh tơ Yàng, sa boh tơ Môise sơ̆ng sa boh tơ Eli.” ");
INSERT INTO cje_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Lăm tŭ Pier dò đờm, nư̆n hũ sa puk hwăl sơrdah kơc̆rà truh gòm-ac̆ĭng buơl guñu, sơ̆ng mư̆ng puk hwăl hũ săp đờm lài: “Ni la Anà uơ̆n-rơnăm Kơu, Kơu siàm hơtai biă mư̆ng Ñu. Păng bĕ pơnuaĭ Anà nư̆n!” ");
INSERT INTO cje_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Tŭ du mơnih tui-mơgru mơhư̆ săp nư̆n, buơl guñu lơbuh pơgruă mơta tơ ala lơ̆n, kơyoa huơĭ-kơđa biă. ");
INSERT INTO cje_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Bloh Yàng Jêsu truh jĕ, yơ̆r tơngàn rơwơ̆ tơ rùp buơl guñu sơ̆ng đờm: “Tơgồ dơ̆ng bĕ, juơi huơĭ!” ");
INSERT INTO cje_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Du mơnih tui-mơgru tơ̆ mơta c̆ơ tơ ngŏ, nư̆n 'bu 'buh mơnih lơi pơkơ̆n, mĭn 'buh sa aràng Yàng Jêsu soh. ");
INSERT INTO cje_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Lăm tŭ găm sơ̆ng du mơnih tui-mơgru mư̆ng glòng c̆ơ̆ sơtơŭ trŭn, Yàng Jêsu đờm kơkơi pơkơŭ buơl guñu: “Juơi đờm tơ aràng sơi thơu mư̆ng pơnuaĭ brơi pơ'buh ni tơ̆l truh tơ tŭ Anà Mơnih mư̆ng anih mơtai hơdiŭ wơ̆.” ");
INSERT INTO cje_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Du mơnih tui-mơgru tơnia Pô: “Yơu nư̆n kơđa hơgĕ du mơnih gơnuăr-pơto pơnuaĭ adăt-adia đờm lài Eli păl truh dơlhơu?” ");
INSERT INTO cje_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yàng Jêsu đờm: “Biă, Eli păl truh tô ngă pơsiàm wơ̆ tơgrơ̆ bruă. ");
INSERT INTO cje_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Bloh Kơu đờm sơ̆ng buơl guhã: Eli hũ truh bơjơ bloh aràng 'buh kràn-thơu ñu, sơ̆ng hũ ngă tơ ñu tui hơtai buơl guñu khiăng. Anà Mơnih kŭng rơŭ kŏng pơđì-pơđoa gleh-glăr tơ ala tơngàn buơl guñu yơu nư̆n rơi.” ");
INSERT INTO cje_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Tŭ nư̆n, du mơnih tui-mơgru wờng lài, Pô dò đờm sơ̆ng buơl guñu mư̆ng Jăng 'Baptis. ");
INSERT INTO cje_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Tŭ Yàng Jêsu sơ̆ng du mơnih tui-mơgru gài mơrai sơ̆ng tơrpuơl buơl làng, nư̆n hũ sa aràng mơnih truh, c̆ĕ khoai tơ anaŭ Pô, đờm lài: ");
INSERT INTO cje_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Khoai Yàng, yòng anĭt-anăr tơ anà lơkơi dơlhă, kơyoa ñu kơđòng lơ-ơ̆n kruă-hơnrui, păl kŏng pơđì-pơđoa biă. Ñu jiăng lơbuh lăm apui, sơ̆ng kŭng lô amăng lơbuh lăm ia. ");
INSERT INTO cje_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Dơlhă hũ apăn ñu truh tơ du mơnih tui-mơgru Pô, bloh buơl guñu 'buh pơsồ-pơsaih jiơ̆ng.” ");
INSERT INTO cje_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yàng Jêsu đờm: “Ơ jơi-pơtiàn 'buh păng-tui sơ̆ng mơsak-jơhà dih, Kơu rơŭ dò sơ̆ng buơl guhã tơ̆l truh tơ tŭ lơi? Kơu rơŭ kŏng ă-ư̆n buơl guhã tơ̆l truh tơ tŭ lơi? Ba bĕ anà tìt truh tơ Kơu.” ");
INSERT INTO cje_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yàng Jêsu puaĭ prơh kơmlài, kơmlài tơbiă klàh mư mư̆ng adơi tìt, sơ̆ng adơi tìt hũ pơsồ-pơsaih mư tŭ jơ nư̆n. ");
INSERT INTO cje_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Du mơnih tui-mơgru tòm tòm krơi Yàng Jêsu sơ̆ng tơnia: “Kơđa hơgĕ buơl dơlhă 'buh pơtrơh kơmlài nư̆n jiơ̆ng?” ");
INSERT INTO cje_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Pô đờm: “Kơyoa buơl guhã tơkì pơnuaĭ păng-tui. Iơŭ biă, Kơu đờm sơ̆ng buơl guhã: Yah buơl guhã hũ pơnuaĭ păng-tui prŏng mĭn kàr sa găr sơbơi, nư̆n yah buơl guhã hũ rơgơi đờm pơđăr c̆ơ̆ ni lài: ‘Pơđoh bĕ mư̆ng ni truh tơ anih dih,’ nư̆n ñu rơŭ pơđoh; sơ̆ng 'buh hũ pơnuaĭ hơgĕ bloh buơl guhã 'buh ngă jiơ̆ng!” ");
INSERT INTO cje_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Bloh sơ̆ng jơi kơmlài ni, yah 'buh iơu-lài sơ̆ng wèr 'bơ̆ng, nư̆n 'buh prơh ñu tơbiă jiơ̆ng. ");
INSERT INTO cje_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Lăm tŭ Yàng Jêsu sơ̆ng du mơnih tui-mơgru Pô pơtòm-pơjŭm gơŭ wơ̆ lăm Galile, Pô đờm sơ̆ng buơl guñu: “Anà Mơnih rơŭ kŏng jào lăm tơngàn aràng. ");
INSERT INTO cje_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Buơl guñu rơŭ pơmơtai Pô, bloh klơu hơrơi hơdơi, Pô rơŭ hơdiŭ wơ̆.” Du mơnih tui-mơgru sơnư̆ng kơ-ù sơ̆ng dơnuh-dơnà biă. ");
INSERT INTO cje_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Tŭ Yàng Jêsu sơ̆ng du mơnih tui-mơgru Pô truh tơ plơi-prŏng Kapenaum, du mơnih rì-mă jia sàng duh-dơlbăt truh tơnia Pier: “Pô-Pơto sơ-ai hũ daŭ jia ơu?” ");
INSERT INTO cje_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pier đờm sơđồ: “Hũ.” Tŭ Pier tơma lăm sàng, Yàng Jêsu tơnia ñu dơlhơu: “Ơ Simôn, hã sơnư̆ng hơyơu? Du pơtau lăm dun-ya rì-mă jia sơ̆ng đồ-mă phơ̆n-bơna mư̆ng aràng sơi? Mư̆ng du anà lơkơi drơi halài mơnih agàh?” ");
INSERT INTO cje_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pier đờm: “Mơnih agàh.” Yàng Jêsu đờm: “Yơu nư̆n du anà lơkơi 'buh păl daŭ jia. ");
INSERT INTO cje_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Bloh tô 'buh ngă krơh jơhà tơ buơl guñu, hã nau bĕ tơ ia-tơsì wah akàn, mă bĕ akàn lơi kơđòng wah dơlhơu rơlau abih, pơh kàng ñu tơbiă, rơŭ 'buh sa đŏng priă. Mă bĕ boh priă nư̆n, sơ̆ng apăn daŭ jia tơ Kơu sơ̆ng hã.” ");
INSERT INTO cje_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Tŭ nư̆n, du mơnih tui-mơgru truh tơnia Yàng Jêsu lài: “Aràng sơi la mơnih prŏng rơlau abih lăm Lơgăr Lơngì?” ");
INSERT INTO cje_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Pô iơu sa aràng lơ-ơneh tìt truh, luơi ñu dò dơ̆ng tơkrah du mơnih tui-mơgru, ");
INSERT INTO cje_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","sơ̆ng đờm: “Iơŭ biă, Kơu đờm sơ̆ng buơl guhã, yah buơl guhã 'buh pơsơlih wơ̆ sơ̆ng tơbiă jiơ̆ng yơu lơ-ơneh tìt, nư̆n rơŭ 'buh hũ tơma lăm Lơgăr Lơngì ơu. ");
INSERT INTO cje_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Yơu nư̆n, aràng sơi pơ-ơneh rùp drơi trŭn yơu lơ-ơneh tìt ni, nư̆n la mơnih prŏng rơlau abih lăm Lơgăr Lơngì. ");
INSERT INTO cje_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Aràng sơi kơyoa mư̆ng angăn Kơu bloh wă-rò sa aràng lơ-ơneh tìt yơu lơ-ơneh tìt ni, nư̆n la wă-rò Kơu. ");
INSERT INTO cje_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Bloh, yah aràng sơi ngă tơ sa aràng lăm du lơ-ơneh tìt hũ păng-tui Kơu bơjơ sơnĕ lơbuh lăm pơnuaĭ glài-sơnoh, nư̆n yah akă lơsŭng pơtơu prŏng tơ tơkuai mơnih nư̆n, bloh prah ñu trŭn lăm ia-tơsì dơrlăm la siàm rơlau. ");
INSERT INTO cje_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Gleh-glăr dồn-să tơ dun-ya mư̆ng du pơnuaĭ ngă tơ aràng sơnĕ lơbuh lăm glài-sơnoh! Kơyoa du pơnuaĭ ngă tơ sơnĕ lơbuh lăm glài-sơnoh păl hũ, bloh gleh-glăr dồn-să biă tơ mơnih lơi la mơnih ngă tơ aràng sơnĕ lơbuh lăm glài-sơnoh! ");
INSERT INTO cje_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Yah tơngàn halài tơkai hã ngă tơ hã sơnĕ lơbuh lăm glài-sơnoh, nư̆n koh sơ̆ng prah ñu atàh bĕ mư̆ng hã. Kơyoa yah hã tùt tơngàn halài tùt tơkai bloh tơma lăm pơnuaĭ hơdiŭ, dò siàm rơlau la hũ tơ̆l abih dua gah tơkai dua gah tơngàn bloh kŏng prah lăm apui rài pơdò rài. ");
INSERT INTO cje_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Yah mơta hã ngă tơ hã sơnĕ lơbuh lăm glài-sơnoh, nư̆n lơ-iok bĕ bloh prah ñu atàh mư̆ng hã; kơyoa yah hã mĭn dò sa gah mơta bloh tơma lăm pơnuaĭ hơdiŭ, dò siàm rơlau hũ tơ̆l abih dua gah mơta bloh păl kŏng prah tơma lăm apui rơhồng-ala. ");
INSERT INTO cje_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Păl kơrmăp rùp bĕ, juơi c̆ơ 'buh sơ̆p tơ sa aràng mơnih lơi lăm du lơ-ơneh tìt ni. Kơyoa Kơu đờm sơ̆ng buơl guhã, du mơnih gơdrưh buơl guñu dò tơ ngŏ lơngì jiăng 'buh mơta Ama Kơu, la Pô dò tơ ngŏ lơngì. ");
INSERT INTO cje_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Buơl guhã sơnư̆ng hơyơu? Yah sa aràng mơnih hũ sa rơtùh drơi abo, bloh sa drơi nau asŭ lơhiă, nư̆n mơnih nư̆n 'buh luơi sơlpăn pluh sơlpăn drơi abo dih tơ ngŏ c̆ơ̆, bloh nau duah anà abo kơđòng asŭ lơhiă ơu? ");
INSERT INTO cje_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Iơŭ biă, Kơu đờm sơ̆ng buơl guhã, yah mơnih nư̆n duah hũ, nư̆n rơŭ sờh-sài mư̆ng anà abo nư̆n rơlau tơ sơlpăn pluh sơlpăn drơi abo 'buh asŭ lơhiă. ");
INSERT INTO cje_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Kŭng yơu nư̆n rơi, Ama buơl guhã tơ ngŏ lơngì 'buh khiăng sa aràng mơnih lơi lăm du lơ-ơneh tìt ni păl mơtai-lơhiă.” ");
INSERT INTO cje_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Yah buơl adơi-ai hã hũ ngă pơnuaĭ sŭng sơ̆ng hã, nư̆n truh tòm krơi sơ̆ng ñu, đờm tơ ñu thơu mư̆ng pơnuaĭ nư̆n. Yah mơnih nư̆n khiăng păng, nư̆n hã hũ adơi-ai drơi wơ̆. ");
INSERT INTO cje_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Bloh yah mơnih nư̆n 'buh khiăng păng, nư̆n jà bĕ sa halài dua aràng mơnih tra nau sơ̆ng hã, tô gơnàng tơ pơnuaĭ dua halài klơu aràng mơnih ngă grơh bloh tơgrơ̆ bruă hũ nìn-kơjăp. ");
INSERT INTO cje_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Yah mơnih nư̆n sơđaŭ 'buh khiăng păng du mơnih ni, nư̆n đờm akhàn bĕ sơ̆ng Tơrpuơl Goh-Sơc̆ih. Sơ̆ng yah mơnih nư̆n 'buh khiăng păng Tơrpuơl Goh-Sơc̆ih, nư̆n c̆ơ bĕ mơnih nư̆n yơu mơnih agàh halài mơnih rì-mă jia. ");
INSERT INTO cje_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Iơŭ biă, Kơu đờm sơ̆ng buơl guhã, yah pơnuaĭ hơgĕ buơl guhã akă tơ ala lơ̆n, kŭng rơŭ akă tơ ngŏ lơngì, sơ̆ng pơnuaĭ hơgĕ buơl guhã tơleh tơ ala lơ̆n, kŭng rơŭ hũ tơleh tơ ngŏ lơngì. ");
INSERT INTO cje_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Kơu kŭng đờm sơ̆ng buơl guhã, yah dua aràng lăm buơl guhã rĭng sa hơtai-hơtiàn sơ̆ng gơŭ tơ ala lơ̆n, lơkơu-yòng tơgrơ̆ pơnuaĭ hơgĕ, nư̆n Ama Kơu tơ ngŏ lơngì rơŭ brơi tơ buơl guñu. ");
INSERT INTO cje_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kơyoa anih lơi hũ dua klơu aràng mă angăn Kơu pơgùm gơŭ wơ̆, nư̆n Kơu rơŭ dò tơkrah buơl guñu. ");
INSERT INTO cje_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Tŭ nư̆n Pier truh jĕ Yàng Jêsu sơ̆ng tơnia: “Ơ Yàng, yah buơl adơi-ai dơlhă ngă pơnuaĭ sŭng sơ̆ng dơlhă, nư̆n dơlhă rơŭ anĭt toh-luơi tơ buơl guñu hơdùm amăng? Hũ păl truh tơjuh amăng ơu?” ");
INSERT INTO cje_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yàng Jêsu đờm: “Kơu 'buh đờm sơ̆ng hã la truh tơjuh amăng ơu, bloh la tơjuh pluh amăng tơjuh. ");
INSERT INTO cje_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Kơyoa nư̆n, Lơgăr Lơngì mơhiơ̆ yơu mơnih pơtau dih khiăng khi-kơrhia khà priă sơ̆ng du mơnih hơlŭn-hơlă drơi. ");
INSERT INTO cje_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Tŭ pơtau tơma khi-kơrhia bơ-àr sră, nư̆n aràng ba truh tơ pơtau sa aràng mơnih kơđòng sre sơ̆ng pơtau sa-pluh rơbơu talơ̆ng. ");
INSERT INTO cje_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Kơyoa mơnih nư̆n 'buh hũ hơgĕ tô bơ-yàr sre, nư̆n pơtau pơđăr pơblơi rùp ñu, sơdiŭ anà sơ̆ng abih phơ̆n-bơna ñu, tô bơ-yàr sre. ");
INSERT INTO cje_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Mơnih hơlŭn-hơlă nư̆n pơđih rùp tơ anaŭ mơnih pơtau, khoai sơ̆ng lơkơu-yòng lài: ‘Khoai pơtau, yòng pơtau anĭt luơi rơlĕ tơ dơlhă, nư̆n dơlhă rơŭ bơ-yàr abih!’ ");
INSERT INTO cje_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Pơtau hũ hơtai-hơtiàn anĭt-anăr, brơi mơnih nư̆n nau wơ̆, sơ̆ng luơi abih sre kơđòng tơ ñu. ");
INSERT INTO cje_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Bloh tŭ mơnih hơlŭn-hơlă nư̆n nau wơ̆, ñu păp sa aràng mơnih, la mơnih adơi-ai gơŭ ngă hơlŭn-hơlă găm sơ̆ng drơi, mơnih nư̆n kơđòng sre sơ̆ng ñu sa rơtùh đơnie. Ñu mă mơnih nư̆n, klèn găn tơkuai sơ̆ng đờm: ‘Bơ-yàr bĕ sre tơ kơu!’ ");
INSERT INTO cje_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Mơnih adơi-ai gơŭ pơđih rùp tơ ala tơkai ñu bloh yòng lơkơu: ‘Ơ sơ-ai, yòng sơ-ai anĭt luơi rơlĕ tơ dơlhă, dơlhă rơŭ bơ-yàr c̆iŭ abih tơ sơ-ai.’ ");
INSERT INTO cje_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Bloh ñu 'buh khiăng, kừ mă mơnih nư̆n krơ̆ lăm sàng jàm tơ̆l truh tơ tŭ bơ-yàr abih sre. ");
INSERT INTO cje_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Tŭ du mơnih adơi-ai gơŭ pơkơ̆n 'buh yơu nư̆n, buơl guñu jruh-jrui biă, truh đờm akhàn wơ̆ sơ̆ng mơnih pơtau thơu mư̆ng abih tơgrơ̆ bruă hũ tơbiă truh. ");
INSERT INTO cje_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Pơtau pơđăr iơu mơnih hơlŭn-hơlă nư̆n truh sơ̆ng đờm: ‘Ơ mơnih hơlŭn-hơlă mơsak-jơhà dih, Kơu hũ anĭt luơi abih sre kơđòng tơ hã, kơyoa hã hũ yòng lơkơu sơ̆ng Kơu; ");
INSERT INTO cje_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","nư̆n bloh kơđa hơgĕ hã 'buh anĭt-anăr tơ mơnih adơi-ai gơŭ drơi, yơu kơu hũ anĭt-anăr tơ hã?’ ");
INSERT INTO cje_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Pơtau anok hơtai, jào ñu tơ mơnih apăn-akŏ sàng jàm tô ngă glài tơ̆l truh tơ tŭ ñu bơ-yàr abih sre. ");
INSERT INTO cje_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yah yàu aràng lăm buơl guhã 'buh abih hơtai-hơtiàn anĭt toh-luơi pơnuaĭ sŭng tơ adơi-ai drơi, nư̆n Ama Kơu tơ ngŏ lơngì kŭng rơŭ ngă sơ̆ng buơl guhã yơu nư̆n rơi.” ");
INSERT INTO cje_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Hơdơi tŭ đờm pơto du pơnuaĭ nư̆n, Yàng Jêsu tơbiă mư̆ng c̆àr Galile nau truh tơ c̆àr Juđe, gah dih ia sơdờng Jôđăn. ");
INSERT INTO cje_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Tơrpuơl buơl làng lô biă nau tui Pô; tơ anih nư̆n Pô pơsồ-pơsaih lơ-ơ̆n lơngoh rơwă-sơkì tơ buơl guñu. ");
INSERT INTO cje_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Du mơnih Pharisi truh tô lòng Pô sơ̆ng tơnia lài: “Sa aràng mơnih lơkơi hũ gơnuăr pơkloh sơdiŭ drơi kơyoa mư̆ng abih tơgrơ̆ pơnuaĭ lơi ơu?” ");
INSERT INTO cje_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Pô đờm: “Buơl guhã 'buh pơrpoh-c̆ơ 'Bồn Bơ-àr Sơc̆ih-Sri ơu? 'Bồn Bơ-àr Sơc̆ih-Sri wă: ‘Mư̆ng c̆ơmrừp, Yàng Pô Lơngì hũ c̆rơ̆ng-pơjiơ̆ng sa aràng mơnih lơkơi sơ̆ng sa aràng mơnih kơmơi,’ ");
INSERT INTO cje_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","sơ̆ng đờm: ‘Kơyoa nư̆n, mơnih lơkơi rơŭ luơi ame ama bloh pơc̆uăl-pơtòm sơ̆ng sơdiŭ drơi; dua aràng rơŭ tơbiă jiơ̆ng sa rùp rơlo.’ ");
INSERT INTO cje_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Kơyoa nư̆n sơdiŭ pơsàng 'buh iơŭ la dua tra, bloh mĭn la sa rùp rơlo. Yơu nư̆n, jơi anà mơnih 'buh hũ pơklah-krơi du mơnih bloh Yàng Pô Lơngì hũ pơc̆uăl-pơtòm!” ");
INSERT INTO cje_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Buơl guñu tơnia Pô wơ̆: “Yah yơu nư̆n, kơđa hơgĕ Môise hũ pơto lài brơi bĕ tơ sơdiŭ sa blah bơ-àr pơkloh, bloh nư̆n luơi ñu nau?” ");
INSERT INTO cje_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Pô đờm: “Kơyoa hơtai-hơtiàn buơl guhã kră-khăng, nư̆n Môise brơi gơnuăr pơkloh sơdiŭ; bloh, mư̆ng tŭ c̆ơmrừp 'buh hũ yơu nư̆n ơu. ");
INSERT INTO cje_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Kơu đờm tơ buơl guhã thơu: mơnih lơi pơkloh sơdiŭ, bloh 'buh iơŭ kơyoa sơdiŭ klĕ sơdiŭ-aràng pơsàng-gơŭ, bloh nau khiăng sơ̆ng sa aràng mơnih pơkơ̆n, la sŭng glài klĕ sơdiŭ-aràng pơsàng-gơŭ.” ");
INSERT INTO cje_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Du mơnih tui-mơgru đờm lài: “Yah yơu nư̆n, 'buh khiăng sơdiŭ la siàm drơi.” ");
INSERT INTO cje_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Bloh Pô đờm: “'Buh iơŭ aràng sơi kŭng đồ-mă hũ pơnuaĭ ni, bloh mĭn du mơnih hũ Yàng Pô Lơngì anĭt brơi. ");
INSERT INTO cje_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Kơyoa hũ mơnih kơdời mư̆ng tŭ tơbiă mư̆ng tŭng ame; hũ mơnih kơdời kơyoa tơngàn aràng, sơ̆ng kŭng hũ mơnih mư̆ng rùp-phŭn drơi ngă tơ drơi jiơ̆ng kơdời kơyoa Lơgăr Lơngì. Aràng sơi hũ rơgơi đồ-mă jiơ̆ng pơnuaĭ ni, nư̆n đồ-mă bĕ.” ");
INSERT INTO cje_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Tŭ nư̆n aràng ba du lơ-ơneh tìt truh sơ̆ng Yàng Jêsu, tô Pô daŭ tơngàn tơ ngŏ buơl guñu sơ̆ng iơu-lài tơ buơl guñu, bloh du mơnih tui-mơgru đờm puaĭ du mơnih nư̆n. ");
INSERT INTO cje_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Bloh Yàng Jêsu đờm: “Kừ luơi du lơ-ơneh tìt truh sơ̆ng Kơu, juơi c̆ơkhă-pơkơŭ buơl guñu; kơyoa Lơgăr Lơngì la găm sơ̆ng du mơnih lơi mơhiơ̆ yơu du lơ-ơneh tìt nư̆n.” ");
INSERT INTO cje_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Dơlhơu tŭ nau anih pơkơ̆n, Pô daŭ tơngàn brơi lơngai-pơtuah tơ buơl guñu. ");
INSERT INTO cje_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Tŭ nư̆n, hũ sa aràng mơnih truh tơnia Pô: “Ơ Pô-Pơto, dơlhă păl ngă pơnuaĭ siàm lơi tô hũ pơnuaĭ hơdiŭ rài pơdò rài?” ");
INSERT INTO cje_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yàng Jêsu đờm: “Kơđa hơgĕ hã tơnia Kơu mư̆ng bruă siàm? Mĭn hũ sa Pô siàm soh. Pô nư̆n la rùp-phŭn Yàng Pô Lơngì. Bloh yah hã khiăng hũ pơnuaĭ hơdiŭ rài pơdò rài, nư̆n păl păng-rơmiă tơgrơ̆ pơnuaĭ adăt-pơđăr.” ");
INSERT INTO cje_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Mơnih nư̆n tơnia: “Du pơnuaĭ adăt-pơđăr lơi?” Yàng Jêsu đờm: “Hã juơi pơmơtai mơnih; juơi ngă glài klĕ sơdiŭ-aràng pơsàng-gơŭ; juơi klĕ blơ̆; juơi ngă grơh lơ̆r. ");
INSERT INTO cje_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Hã păl thơu-adăt tơ ame ama, sơ̆ng hã păl rơnăm tơ mơnih gơŭ sa plơi adơi sa 'băng yơu rơnăm rùp-phŭn drơi.” ");
INSERT INTO cje_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Mơnih dăm nư̆n đờm: “Dơlhă hũ păng-rơmiă tơ̆l abih tơgrơ̆ pơnuaĭ ni, dơlhă dò siơŭ pơnuaĭ hơgĕ wơ̆ ơu?” ");
INSERT INTO cje_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yàng Jêsu đờm: “Yah hã khiăng hũ wĭl-tơ̆l, nư̆n nau bĕ, pơblơi abih phơ̆n-bơna drơi hũ, mă priă apăn pơrpha brơi-soh tơ mơnih rơ'bah, nư̆n hã rơŭ hũ phơ̆n-bơna c̆ơk-màng tơ ngŏ lơngì, bloh nư̆n truh bĕ tui Kơu.” ");
INSERT INTO cje_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Hơdơi tŭ mơhư̆ du pơnuaĭ ni, mơnih dăm nư̆n jruh-jrui tơbiă nau, kơyoa ñu hũ lô phơ̆n-bơna biă. ");
INSERT INTO cje_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yàng Jêsu đờm sơ̆ng du mơnih tui-mơgru: “Iơŭ biă Kơu đờm sơ̆ng buơl guhã, mơnih mơda tơma lăm Lơgăr Lơngì la kăn-dơmăn biă. ");
INSERT INTO cje_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Kơu đờm tơ buơl guhã thơu: lakđa rŏ găn lơbàng jrŭm dò 'buơ̆n rơlau mơnih mơda tơma lăm lơgăr Yàng Pô Lơngì.” ");
INSERT INTO cje_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Tŭ du mơnih tui-mơgru mơhư̆ yơu nư̆n, buơl guñu mă ngă c̆rih-takơtuă biă sơ̆ng đờm lài: “Yah yơu nư̆n aràng sơi rơŭ hũ dŏng pơklàh?” ");
INSERT INTO cje_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yàng Jêsu c̆ơ tơpă tơ buơl guñu sơ̆ng đờm: “Jơi anà mơnih 'buh rơgơi ngă jiơ̆ng pơnuaĭ ni, bloh Yàng Pô Lơngì ngă jiơ̆ng abih tơgrơ̆ bruă.” ");
INSERT INTO cje_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pier đờm lài: “Ơ Pô-Pơto, buơl dơlhă hũ luơi abih tơgrơ̆ mơta bloh tui Pô-Pơto. Yơu nư̆n buơl dơlhă rơŭ hũ hơgĕ?” ");
INSERT INTO cje_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yàng Jêsu đờm: “Iơŭ biă, Kơu đờm sơ̆ng buơl guhã, truh tŭ-hơrơi abih tơgrơ̆ jơi-phơ̆n hũ pơsơlih bơrhơu, la tŭ Anà Mơnih rơŭ dò guh tơ ngŏ sơbàn màng-kơc̆rà Pô, nư̆n buơl guhã la du mơnih hũ tui Kơu, kŭng rơŭ dò guh tơ ngŏ sa-pluh dua sơbàn, tô c̆ahrơña sa-pluh dua jơi-pơtiàn Israel. ");
INSERT INTO cje_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Yah aràng sơi kơyoa mư̆ng angăn Kơu bloh klà luơi sàng-dơnò, adơi-ai, gơŭ kơmơi, ame ama, anà tơc̆o, hơma apùh, mơnih nư̆n rơŭ đồ-mă hũ sa rơtùh amăng rơlau wơ̆, sơ̆ng hũ đồ-lĕng pơnuaĭ hơdiŭ rài pơdò rài. ");
INSERT INTO cje_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Bloh hũ lô mơnih dơlhơu rơŭ jiơ̆ng hơdơi luĭ, sơ̆ng lô mơnih hơdơi luĭ rơŭ jiơ̆ng dơlhơu.” ");
INSERT INTO cje_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Lơgăr Lơngì mơhiơ̆ yơu sa aràng mơnih pô sàng dih, mư̆ng ờm rìng tơbiă nau apah mơnih tơma ngă bruă lăm apùh ño drơi. ");
INSERT INTO cje_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Hơdơi tŭ đờm glai tơsă-tơsi sơ̆ng du mơnih ngă tồ-apah, la sa đơnie tơ sa hơrơi ngă bruă, nư̆n pơđăr buơl guñu tơma ngă bruă lăm apùh ño drơi. ");
INSERT INTO cje_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Pơgăp tơlpăn jơ ờm, mơnih pô apùh tơbiă c̆ơ wơ̆, 'buh du mơnih pơkơ̆n lơwah bruă dò dơ̆ng soh lăm drà, ");
INSERT INTO cje_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","nư̆n đờm sơ̆ng buơl guñu: ‘Buơl guhã tơma ngă bruă bĕ lăm apùh ño kơu, kơu rơŭ c̆iŭ priă hơrơi ngă bruă iơŭ păl tơ buơl guhã.’ Buơl guñu nau mư. ");
INSERT INTO cje_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Pơgăp sa-pluh dua jơ hơrơi dơ̆ng sơ̆ng klơu jơ diơŭ, mơnih pô apùh tơbiă nau c̆ơ wơ̆, sơ̆ng kŭng ngă yơu nư̆n rơi. ");
INSERT INTO cje_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Pơgăp lơma jơ diơŭ, mơnih pô apùh nau tơbiă c̆ơ sơ̆ng 'buh du mơnih pơkơ̆n dò dơ̆ng soh tơ anih nư̆n. Mơnih pô apùh đờm sơ̆ng buơl guñu: ‘Kơđa hơgĕ buơl guhã dò dơ̆ng soh tơ anih ni luĭ hơrơi yơu nư̆n?’ ");
INSERT INTO cje_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Buơl guñu đờm: ‘Kơyoa 'buh hũ aràng sơi apah buơl dơlhă ơu.’ Mơnih pô apùh đờm sơ̆ng buơl guñu: ‘Buơl guhã kŭng tơma ngă bruă bĕ lăm apùh ño kơu.’ ");
INSERT INTO cje_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Truh diơŭ, mơnih pô apùh đờm sơ̆ng mơnih c̆ơ-apăn bruă sàng drơi lài: ‘Iơu bĕ du mơnih ngă tồ-apah truh sơ̆ng c̆iŭ priă hơrơi ngă bruă tơ buơl guñu, tơma c̆ơmrừp mư̆ng mơnih tơma ngă hơdơi luĭ truh mơnih tơma ngă dơlhơu rơlau abih.’ ");
INSERT INTO cje_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Du mơnih hũ apah ngă bruă tŭ lơma jơ diơŭ truh, yàu aràng lĕng hũ sa đơnie. ");
INSERT INTO cje_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Tŭ du mơnih hũ apah c̆ơmrừp rơlau abih truh, buơl guñu sơnư̆ng rơŭ lĕng hũ lô rơlau, bloh yàu aràng kŭng mĭn lĕng hũ sa đơnie. ");
INSERT INTO cje_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Tŭ đồ-mă priă hơrơi ngă bruă, buơl guñu đờm yuăm sơ̆ng mơnih pô sàng: ");
INSERT INTO cje_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Du mơnih tơma ngă bruă hơdơi luĭ ni mĭn ngă sa jơ soh, nư̆n bloh mơnih pô kŭng c̆iŭ priă tơ buơl guñu rĭng kàr sơ̆ng buơl dơlhă rơi, la du mơnih păl ngă bruă gleh-glăr luĭ hơrơi lăm pơđiă kluơĭ.’ ");
INSERT INTO cje_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Bloh mơnih pô apùh đờm sơđồ sơ̆ng sa aràng lăm buơl guñu lài: ‘Ơ adơi-ai gơŭ, kơu 'buh ngă hơgĕ jơhà halài 'buh rĭng-tơpă sơ̆ng adơi-ai gơŭ ơu. 'Buh iơŭ adơi-ai gơŭ hũ đờm tơsă-tơsi sơ̆ng kơu la sa đơnie tơ sa hơrơi ngă bruă ơu? ");
INSERT INTO cje_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Apăn bĕ pơ-ơnah priă hã bloh nau wơ̆; kơu khiăng c̆iŭ tơ mơnih tơma ngă hơdơi luĭ ni yơu hũ c̆iŭ tơ hã rơi. ");
INSERT INTO cje_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Kơu 'buh hũ gơnuăr angui phơ̆n-bơna kơu tui hơtai kơu khiăng ơu? Halài hã 'buh kơu hơdiŭ sơrmah-siàm bloh oàn-anok?’ ");
INSERT INTO cje_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yơu nư̆n, mơnih hơdơi luĭ rơŭ jiơ̆ng dơlhơu, sơ̆ng mơnih dơlhơu rơŭ jiơ̆ng hơdơi luĭ.” ");
INSERT INTO cje_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Lăm tŭ đì nau tơ Jerusalem, Yàng Jêsu ba sa-pluh dua aràng mơnih tui-mơgru tơbiă krơi sơ̆ng Pô, sơ̆ng rò jơlàn, Pô đờm sơ̆ng buơl guñu: ");
INSERT INTO cje_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ni, buơl gudrơi đì nau tơ plơi-prŏng Jerusalem, sơ̆ng Anà Mơnih rơŭ kơđòng mă jào lăm tơngàn du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt sơ̆ng du mơnih gơnuăr-pơto pơnuaĭ adăt-adia. Buơl guñu rơŭ ngă nìn-glài pơmơtai Pô. ");
INSERT INTO cje_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Buơl guñu rơŭ jào Pô tơ buơl làng agàh tô klau-pơtăt, glih pờng, sơ̆ng pơ̆ng Pô tơ kơyơu pơkăl; bloh hơdơi klơu hơrơi, Pô rơŭ hơdiŭ wơ̆.” ");
INSERT INTO cje_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Tŭ nư̆n, hũ ame du anà lơkơi Sebede, găm sơ̆ng dua aràng anà drơi truh c̆ĕ tơ-ù dơlbăt tơ anaŭ Yàng Jêsu, bloh yòng lơkơu Pô sa bruă. ");
INSERT INTO cje_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Pô tơnia: “Hã khiăng yòng hơgĕ?” Ñu đờm lài: “Yòng brơi tơ dua aràng anà lơkơi dơlhă, sa aràng dò guh gah hơnuă, sa aràng dò guh gah ơñiau Pô, lăm Lơgăr Pô.” ");
INSERT INTO cje_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yàng Jêsu đờm: “Buơl guhã 'buh thơu pơnuaĭ drơi yòng. Buơl guhã hũ rơgơi mơñŭm c̆uàn pơđì-pơđoa gleh-glăr bloh Kơu kơjĕ mơñŭm ơu?” Buơl guñu đờm: “Buơl dơlhă rơgơi mơñŭm jiơ̆ng.” ");
INSERT INTO cje_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Pô đờm sơ̆ng buơl guñu: “Biă buơl guhã rơŭ mơñŭm c̆uàn Kơu; bloh dò guh gah hơnuă halài gah ơñiau Kơu, nư̆n Kơu 'buh brơi jiơ̆ng. Anih nư̆n pioh tơ du mơnih bloh Ama Kơu hũ rơc̆ăng brơi.” ");
INSERT INTO cje_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Mơhư̆ yơu nư̆n, sa-pluh aràng mơnih tui-mơgru dih anok hơtai sơ̆ng dua aràng adơi-ai nư̆n. ");
INSERT INTO cje_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Bloh Yàng Jêsu iơu buơl guñu truh sơ̆ng đờm lài: “Buơl guhã thơu lài du pơtau buơl làng agàh angui gơnuăr-mơsak bloh apăn-akŏ buơl làng, dò du kwăng-prŏng nư̆n mă gơnuăr bloh pơkơŭ-pơđăr buơl làng. ");
INSERT INTO cje_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Bloh tơkrah buơl guhã nư̆n 'buh iơŭ yơu nư̆n; tơrblơ̆ wơ̆, aràng sơi khiăng ngă prŏng lăm buơl guhã, nư̆n păl ngă hơlŭn-hơlă tơ buơl guhã. ");
INSERT INTO cje_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Aràng sơi khiăng ngă akŏ lăm buơl guhã, nư̆n păl ngă hơlŭn-hơlă tơ buơl guhã. ");
INSERT INTO cje_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Kŭng yơu nư̆n rơi, Anà Mơnih 'buh iơŭ truh tô hũ aràng duh bruă drơi, bloh tô duh bruă tơ aràng, sơ̆ng pơyă pơnuaĭ hơdiŭ drơi ngă phơ̆n tơrbuh tơ lô mơnih.” ");
INSERT INTO cje_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Tŭ Yàng Jêsu sơ̆ng du mơnih tui-mơgru Pô tơbiă mư̆ng plơi-prŏng Jerikô, hũ sa tơrpuơl lô buơl làng nau tui Pô. ");
INSERT INTO cje_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Dih, hũ dua aràng mơnih bồm dò guh tơ gah jơlàn, mơhư̆ đờm lài Yàng Jêsu nau găn nư̆n, buơl guñu pồ săp iơu driau prŏng: “Khoai Yàng, Anà pơtau Đabit, yòng anĭt-anăr buơl dơlhă!” ");
INSERT INTO cje_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Tơrpuơl buơl mơnih lô puaĭ jrăm tơ buơl guñu, pơđăr dò kơđơ̆ng, bloh buơl guñu 'brŏ iơu driau prŏng rơlau wơ̆: “Khoai Yàng, Anà pơtau Đabit, yòng anĭt-anăr buơl dơlhă!” ");
INSERT INTO cje_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yàng Jêsu dò dơ̆ng wơ̆, iơu buơl guñu truh, sơ̆ng đờm: “Buơl guhã khiăng Kơu ngă hơgĕ tơ buơl guhã?” ");
INSERT INTO cje_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Buơl guñu đờm: “Khoai Yàng, yòng pơh mơta tơ buơl dơlhă hũ sơrdah.” ");
INSERT INTO cje_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yàng Jêsu hũ hơtai anĭt-anăr, nư̆n rơwơ̆ tơ mơta buơl guñu. Tŭ nư̆n mư mơta buơl guñu hũ 'buh jiơ̆ng, sơ̆ng buơl guñu nau tui Pô. ");
INSERT INTO cje_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Tŭ Yàng Jêsu sơ̆ng du mơnih tui-mơgru truh jĕ plơi-prŏng Jerusalem, tŭ tơma lăm plơi 'Betphage, gah c̆ơ̆ Ôlibe, Pô pơđăr dua aràng mơnih tui-mơgru nau, ");
INSERT INTO cje_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","sơ̆ng đờm kơkơi pơđăr: “Nau tơma bĕ lăm plơi tơ anaŭ, sơ̆ng buơl guhã rơŭ 'buh mư sa drơi alàng ana aràng akă lờih tơ anih nư̆n, jĕ tơ gah ñu hũ sa drơi alàng anà. Tơleh bĕ tơlơi sơ̆ng dùi guñu mơrai tơ Kơu. ");
INSERT INTO cje_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Yah hũ aràng sơi đờm hơgĕ, buơl guhã đờm sơđồ bĕ lài: ‘Yàng khiăng angui dua drơi alàng ni.’ Mơnih nư̆n rơŭ brơi buơl guhã dùi nau mư.” ");
INSERT INTO cje_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Bruă ni tơbiă truh tô iơŭ yơu pơnuaĭ mơnih gơnuăr-hwơ̆r hũ đờm lài: ");
INSERT INTO cje_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Đờm bĕ sơ̆ng anà kơmơi Siôn lài: Dih, Pơtau hã truh sơ̆ng hã, Lơnguh-lơngui jơnoh-jơnùn, đì alàng, Sơ̆ng dò guh tơ rŏng alàng anà, la anà alàng ana.” ");
INSERT INTO cje_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Dua aràng mơnih tui-mơgru nau sơ̆ng ngă iơŭ yơu pơnuaĭ Yàng Jêsu hũ kơkơi pơđăr. ");
INSERT INTO cje_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Buơl guñu dùi alàng ana sơ̆ng alàng anà mơrai, mă ào drơi làng tơ rŏng alàng, bloh nư̆n đơ̆ng pồ Yàng Jêsu đì. ");
INSERT INTO cje_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Lăm tơrpuơl buơl làng, lô mơnih mă ào drơi làng lăm jơlàn, du mơnih pơkơ̆n nư̆n koh du thàn kơyơu bloh tràh lăm jơlàn nau. ");
INSERT INTO cje_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Buơl làng, mơnih nau dơlhơu, mơnih tui hơdơi, sơgơŭ driau prŏng lài: “Hôsana, Anà pơtau Đabit! Lơngai-pơtuah tơ Pô mă angăn Yàng bloh truh! Hôsana, tơ anih ngŏ glòng rơlau abih.” ");
INSERT INTO cje_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Tŭ Pô tơma lăm Jerusalem, abih plơi-prŏng tơbiă jiơ̆ng klùk-klờk, buơl làng đờm tơnia gơŭ: “Mơnih ni la aràng sơi?” ");
INSERT INTO cje_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Tơrpuơl mơnih lô đờm sơđồ: “Nư̆n la mơnih gơnuăr-hwơ̆r Jêsu mư̆ng Nasaret c̆àr Galile.” ");
INSERT INTO cje_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yàng Jêsu tơma lăm sàng duh-dơlbăt Yàng Pô Lơngì, prơh abih du mơnih dò pơblơi-sơlih lăm sàng duh-dơlbăt. Pô tơlơ̆ c̆ơnừng du mơnih sơlih priă sơ̆ng sŭl lơbuh gơnŭl du mơnih pơblơi c̆ĭm kơtrơu. ");
INSERT INTO cje_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Pô đờm sơ̆ng buơl guñu: “Hũ pơnuaĭ wă: ‘Sàng Kơu rơŭ hũ angăn la sàng iơu-lài,’ Bloh buơl guhã ngă tơ anih nư̆n tơbiă jiơ̆ng gồ-lơbàng buơl klĕ blơ̆.” ");
INSERT INTO cje_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Du mơnih bồm sơ̆ng mơnih joh-je truh sơ̆ng Pô lăm sàng duh-dơlbăt, sơ̆ng Pô pơsồ-pơsaih tơ buơl guñu. ");
INSERT INTO cje_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Bloh tŭ du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt sơ̆ng du mơnih gơnuăr-pơto pơnuaĭ adăt-adia 'buh du bruă c̆rih-krơi Pô ngă, sơ̆ng mơhư̆ du lơ-ơneh tìt driau lăm anih sàng duh-dơlbăt lài: “Hôsana Anà pơtau Đabit!” Nư̆n anok hơtai biă, ");
INSERT INTO cje_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","bloh đờm sơ̆ng Pô lài: “Pô-Pơto hũ mơhư̆ du lơ-ơneh tìt ni đờm hơgĕ rơi?” Yàng Jêsu đờm: “Mơhư̆. Nư̆n buơl guhã ka pơrpoh-c̆ơ pơnuaĭ ni: ‘Yàng hũ mơyòm-pơglòng kơyoa bơbah lơ-ơneh tìt sơ̆ng anà dò mơ̆m ia tơsơu ơu?’ ” ");
INSERT INTO cje_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Bloh nư̆n Pô luơi buơl guñu sơ̆ng tơbiă klàh mư̆ng plơi-prŏng, truh tơ plơi 'Bethani sơ̆ng pơdời gleh mơlăm tơ anih nư̆n. ");
INSERT INTO cje_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ờm hơrơi hơdơi, tŭ gài wơ̆ tơ plơi-prŏng, nư̆n Pô lơpa. ");
INSERT INTO cje_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","'Buh sa phŭn kơyơu hra tơ gah jơlàn, Pô truh jĕ, bloh mĭn 'buh du sơla soh, nư̆n Pô đờm sơ̆ng kơyơu hra: “Hã rơŭ 'buh tŭ lơi tơbiă boh tra!” Kơyơu hra thu mư tŭ nư̆n. ");
INSERT INTO cje_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","'Buh yơu nư̆n, du mơnih tui-mơgru mă ngă krơi-takơtuă biă, đờm lài: “Ngă hơyơu bloh kơyơu hra thu mư yơu nư̆n?” ");
INSERT INTO cje_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yàng Jêsu đờm: “Iơŭ biă, Kơu đờm sơ̆ng buơl guhã, yah buơl guhã hũ pơnuaĭ păng-tui sơ̆ng 'buh sơnư̆ng pah-koh wĭ-wơ̆, nư̆n 'buh iơŭ buơl guhã mĭn ngă jiơ̆ng pơnuaĭ Kơu hũ ngă tơ kơyơu hra, bloh găm yơu bruă đờm pơđăr c̆ơ̆ ni lài: ‘Pồ rùp đì bĕ sơ̆ng prah trŭn lăm ia-tơsì,’ pơnuaĭ nư̆n kŭng rơŭ ngă jiơ̆ng. ");
INSERT INTO cje_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Lăm tŭ iơu-lài, abih tơgrơ̆ pơnuaĭ hơgĕ buơl guhã mă pơnuaĭ păng-tui bloh yòng lơkơu, nư̆n rơŭ đồ-mă hũ.” ");
INSERT INTO cje_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yàng Jêsu tơma lăm sàng duh-dơlbăt, tŭ Pô dò pơto-mơblàng, du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt sơ̆ng du mơnih gơnuăr-tha lăm buơl làng truh bloh tơnia lài: “Pô-Pơto mă gơnuăr lơi bloh ngă du bruă ni? Aràng sơi brơi tơ Pô-Pơto gơnuăr nư̆n?” ");
INSERT INTO cje_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yàng Jêsu đờm: “Kơu kŭng tơnia buơl guhã sa pơnuaĭ, yah buơl guhã đờm sơđồ jiơ̆ng, nư̆n Kơu kŭng rơŭ đờm tơ buơl guhã thơu Kơu ngă tơgrơ̆ bruă ni kơyoa gơnuăr lơi. ");
INSERT INTO cje_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Pơnuaĭ 'baptem Jăng truh mư̆ng lơi? Mư̆ng ngŏ lơngì halài mư̆ng anà mơnih?” Buơl guñu đờm tămbơyai sơ̆ng gơŭ: “Yah buơl gudrơi đờm: ‘Mư̆ng ngŏ lơngì,’ nư̆n ñu rơŭ đờm sơ̆ng buơl gudrơi: ‘Yơu nư̆n, kơđa hơgĕ buơl guhã 'buh păng-tui Jăng?’ ");
INSERT INTO cje_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Sơ̆ng yah buơl gudrơi đờm: ‘Mư̆ng jơi anà mơnih,’ nư̆n buơl gudrơi huơĭ tơ buơl làng. Kơyoa aràng sơi aràng nư̆n kŭng păng-tui lài Jăng la sa aràng mơnih gơnuăr-hwơ̆r.” ");
INSERT INTO cje_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Kơyoa nư̆n, buơl guñu đờm sơđồ sơ̆ng Yàng Jêsu: “Buơl dơlhă 'buh thơu.” Yàng Jêsu đờm: “Kơu kŭng 'buh đờm tơ buơl guhã thơu kơyoa mư̆ng gơnuăr lơi bloh Kơu ngă tơgrơ̆ bruă ni.” ");
INSERT INTO cje_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Buơl guhã sơnư̆ng hơyơu? Sa aràng mơnih dih hũ dua aràng anà lơkơi. Mơnih nư̆n truh đờm sơ̆ng anà lơkơi kơc̆ua: ‘Ơ anà, hơrơi ni anà nau ngă bruă bĕ lăm apùh ño.’ ");
INSERT INTO cje_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Anà nư̆n đờm lài: ‘Anà 'buh khiăng nau!’ Bloh hơdơi, ñu sơnư̆ng pơsơlih wơ̆, sơ̆ng nau. ");
INSERT INTO cje_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Mơnih ama truh sơ̆ng anà lơkơi dua, sơ̆ng kŭng đờm yơu nư̆n rơi. Anà lơkơi ni đờm: ‘Ơ ama, luơi anà nau.’ Bloh nư̆n 'buh nau. ");
INSERT INTO cje_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Lăm dua aràng anà lơkơi nư̆n, aràng sơi ngă tui hơtai-khiăng mơnih ama?” Buơl guñu đờm: “Anà lơkơi kơc̆ua.” Yàng Jêsu đờm sơ̆ng buơl guñu: “Iơŭ biă, Kơu đờm sơ̆ng buơl guhã, du mơnih rì-mă jia sơ̆ng du kơmơi dri rơŭ hũ tơma lăm lơgăr Yàng Pô Lơngì dơlhơu buơl guhã. ");
INSERT INTO cje_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Kơyoa Jăng truh tô pơto tơ buơl guhã jơlàn pơnuaĭ rĭng-tơpă, bloh buơl guhã 'buh păng-tui ñu, dò du mơnih rì-mă jia sơ̆ng du kơmơi dri hũ păng-tui ñu. Pơ-ơnah buơl guhã, tŭ hũ 'buh yơu nư̆n bơjơ, bloh kŭng sơđaŭ 'buh khiăng mơbai prah-luơi glài-sơnoh sơ̆ng păng-tui ñu.” ");
INSERT INTO cje_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Păng bĕ sa pơnuaĭ pơgăp-pơmơyơu pơkơ̆n. Hũ sa aràng mơnih pô sàng dih, pla sa apùh ño, c̆ăng bơga tòmdăr, gah dơrlăm apùh klơi sa boh lơbàng păt ia ño, bơ̆ sa boh sàng glòng khiă c̆ơ; bloh nư̆n brơi tơ du mơnih pla ño apah, sơ̆ng nau tơ lơgăr pơkơ̆n. ");
INSERT INTO cje_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Truh brơñàn-blàn pĕ boh ño, mơnih pô apùh pơđăr du mơnih hơlŭn-hơlă truh sơ̆ng du mơnih pla ño tô rì-mă pơ-ơnah phŭn-hơjŭng drơi. ");
INSERT INTO cje_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Bloh du mơnih pla ño mă du mơnih hơlŭn-hơlă, pờng mơnih ni, pơmơtai mơnih dih, sơ̆ng prah pơtơu mơnih pơkơ̆n. ");
INSERT INTO cje_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Mơnih pô apùh pơđăr wơ̆ du mơnih hơlŭn-hơlă pơkơ̆n, lô rơlau dơlhơu, bloh buơl guñu kŭng sơđaŭ ngă sơ̆ng du mơnih hơlŭn-hơlă ni yơu nư̆n rơi. ");
INSERT INTO cje_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Hơdơi luĭ, mơnih pô apùh pơđăr rùp-phŭn anà lơkơi drơi truh sơ̆ng buơl guñu, kơyoa đờm lài: ‘Guñu rơŭ c̆ơ prŏng-màng tơ anà kơu.’ ");
INSERT INTO cje_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Bloh tŭ du mơnih pla ño 'buh anà lơkơi pô apùh, nư̆n đờm sơ̆ng gơŭ: ‘Ni la anà pơgi-kơdih ama ñu rơŭ jào abih phŭm-kơsai tơ ñu! Ah, buơl gudrơi pơmơtai ñu bĕ, sơ̆ng tămblah mă phŭm-kơsai ñu.’ ");
INSERT INTO cje_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Guñu mă anà lơkơi nư̆n, prah ñu tơ agàh apùh ño sơ̆ng pơmơtai. ");
INSERT INTO cje_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yơu nư̆n, tŭ pô apùh ño truh, nư̆n rơŭ ngă sơ̆ng buơl mơnih pla ño dih hơyơu lơi?” ");
INSERT INTO cje_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Buơl guñu đờm sơđồ: “Pô apùh rơŭ pơluĭ-pơmơtai abih buơl mơnih mơsak-jơhà nư̆n, sơ̆ng brơi tơ du mơnih pla ño pơkơ̆n apah, la du mơnih rơŭ jào phŭn-hơjŭng tơ pô apùh iơŭ brơñàn-blàn.” ");
INSERT INTO cje_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yàng Jêsu đờm sơ̆ng buơl guñu: “Buơl guhã ka tŭ lơi pơrpoh-c̆ơ pơnuaĭ ni lăm 'Bồn Bơ-àr Sơc̆ih-Sri ơu: ‘Boh pơtơu bloh mơnih bơ̆ sàng prah luơi, Hũ tơbiă jiơ̆ng boh pơtơu akiăng sàng. Ni la bruă Yàng ngă, Sơ̆ng nư̆n la pơnuaĭ c̆rih-krơi tơ anaŭ buơl gudrơi.’ ");
INSERT INTO cje_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Kơyoa nư̆n, Kơu đờm sơ̆ng buơl guhã, lơgăr Yàng Pô Lơngì rơŭ hũ suă klàh mư̆ng buơl guhã, sơ̆ng brơi tơ sa buơl làng pơkơ̆n, la buơl làng rơŭ apăn phŭn-hơjŭng mơrai tơ lơgăr nư̆n. ");
INSERT INTO cje_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Aràng sơi lơbuh tơ ngŏ boh pơtơu ni rơŭ lơmuĭ phư̆, dò boh pơtơu nư̆n lĕ gò aràng sơi, rơŭ gì lơmuĭ phư̆ mơnih nư̆n yơu hơbơu.” ");
INSERT INTO cje_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Tŭ du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt sơ̆ng du mơnih Pharisi mơhư̆ du pơnuaĭ pơgăp-pơmơyơu ni, nư̆n kràn thơu la Pô đờm mư̆ng buơl guñu. ");
INSERT INTO cje_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Buơl guñu duah ngă hơyơu tô mă Pô, bloh huơĭ tơ tơrpuơl mơnih lô, kơyoa buơl làng kràn-thơu Pô la sa aràng mơnih gơnuăr-hwơ̆r. ");
INSERT INTO cje_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yàng Jêsu angui pơnuaĭ pơgăp-pơmơyơu bloh đờm wơ̆ sơ̆ng buơl guñu lài: ");
INSERT INTO cje_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Lơgăr Lơngì mơhiơ̆ yơu sa aràng mơnih pơtau dih pồ bruă mơñŭm 'bơ̆ng khiăng-gơŭ tơ anà lơkơi drơi. ");
INSERT INTO cje_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Pơtau pơđăr mơnih hơlŭn-hơlă nau đờm pơsơdơ̆r tơ du mơnih thuai hũ jà truh mơñŭm 'bơ̆ng, bloh buơl guñu 'buh truh. ");
INSERT INTO cje_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Pơtau pơđăr du mơnih hơlŭn-hơlă pơkơ̆n wơ̆ nau, sơ̆ng đờm kơkơi pơđăr lài: ‘Đờm bĕ sơ̆ng du mơnih thuai hũ jà lài: Ni, phơ̆n mơñŭm 'bơ̆ng hũ rơc̆ăng abih bơjơ, lơmo sơ̆ng du phơ̆n pà gah tơkai lơmă hũ sì ngă rơlo bơjơ, tơgrơ̆ bruă hũ rơc̆ăng lờih abih bơjơ. Jà truh mơñŭm 'bơ̆ng bĕ!’ ");
INSERT INTO cje_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Bloh buơl guñu 'buh pioh hơtai-hơtiàn c̆ơ sơnư̆ng hơgĕ truh bruă nư̆n, yàu aràng kừ nau jơlàn drơi. Mơnih ni nau tơ hơma, mơnih dih nau pơblơi-sơlih akă-bơnia, ");
INSERT INTO cje_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","dò du mơnih pơkơ̆n nư̆n mă du mơnih hơlŭn-hơlă pơtau, puaĭ c̆ơ-ua sơ̆ng pơmơtai. ");
INSERT INTO cje_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Pơtau anok hơtai, pơđăr buơl lĭng nau pơluĭ-pơlơhiă abih du mơnih pơmơtai mơnih nư̆n, sơ̆ng c̆uh abih plơi-prŏng buơl guñu. ");
INSERT INTO cje_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Bloh nư̆n, pơtau đờm sơ̆ng du mơnih hơlŭn-hơlă: ‘Pơnuaĭ mơñŭm 'bơ̆ng khiăng-gơŭ hũ pồ abih bơjơ, bloh du mơnih thuai hũ jà 'buh aràng sơi iơŭ păl tô tơma mơñŭm 'bơ̆ng. ");
INSERT INTO cje_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Kơyoa nư̆n, nau tơbiă bĕ tơ du jơlàn prŏng, yah păp aràng sơi, jà bĕ mơnih nư̆n truh tơma mơñŭm 'bơ̆ng.’ ");
INSERT INTO cje_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Du mơnih hơlŭn-hơlă nau lăm abih du jơlàn prŏng, pơgùm-pơtòm abih tơgrơ̆ mơnih lơi buơl guñu păp, 'buh pơklah-krơi mơnih siàm halài jơhà, tơ̆l truh lăm adŭ mơñŭm 'bơ̆ng baŭ abih du mơnih thuai mơñŭm 'bơ̆ng. ");
INSERT INTO cje_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Bloh tŭ pơtau tơma c̆ơ thuai mơñŭm 'bơ̆ng, pơtau 'buh sa aràng mơnih 'buh c̆ù khăn-ào pioh tơ pơnuaĭ mơñŭm 'bơ̆ng khiăng-gơŭ, ");
INSERT INTO cje_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","nư̆n đờm sơ̆ng mơnih nư̆n: ‘Ni adơi-ai gơŭ, hơyơu adơi-ai gơŭ tơma lăm ni bloh 'buh c̆ù khăn-ào pioh tơ pơnuaĭ mơñŭm 'bơ̆ng khiăng-gơŭ?’ Mơnih nư̆n dò kơđơ̆ng 'buh đờm sơđồ jiơ̆ng. ");
INSERT INTO cje_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Nư̆n pơtau pơđăr du mơnih hơlŭn-hơlă: ‘C̆aŭ bĕ tơkai tơngàn ñu wơ̆, sơ̆ng prah ñu tơ anih kơnăm-mơsrư̆ gah agàh, la anih rơŭ hũ hia c̆ŏ sơ̆ng kĕ tơgơi.’ ");
INSERT INTO cje_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Kơyoa lô mơnih hũ iơu, bloh tơkì mơnih hũ rơwah.” ");
INSERT INTO cje_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Tŭ nư̆n, du mơnih Pharisi nau tơbiă, tămbơyai sơ̆ng gơŭ tô duah pơnuaĭ mă pơkăl Yàng Jêsu mư̆ng pơnuaĭ đờm. ");
INSERT INTO cje_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Buơl guñu pơđăr du mơnih tui-mơgru drơi găm sơ̆ng du mơnih lăm tơrpuơl Herôt, truh đờm sơ̆ng Yàng Jêsu lài: “Ơ Pô-Pơto, buơl dơlhă thơu Pô-Pơto la mơnih tơpă-tơpe, sơ̆ng tui pơnuaĭ tơpă bloh pơto jơlàn păng-tui Yàng Pô Lơngì, 'buh kơmlưh huơĭ tơ aràng sơi, kơyoa Pô-Pơto 'buh c̆ơ tui gah agàh anà mơnih ơu. ");
INSERT INTO cje_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Yơu nư̆n, yòng Pô-Pơto brơi buơl dơlhă thơu, Pô-Pơto sơnư̆ng hơyơu lơi: Hũ păl daŭ jia tơ Sesa halài 'buh ơu?” ");
INSERT INTO cje_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Bloh Yàng Jêsu thơu hơtai-hơtiàn jơhà buơl guñu, nư̆n Pô đờm: “Ơ du mơnih hơtai-hơtiàn mơthĭ-lơ̆r, kơđa hơgĕ buơl guhã lòng Kơu? ");
INSERT INTO cje_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Brơi bĕ tơ Kơu c̆ơ priă daŭ jia.” Buơl guñu apăn tơ Pô sa đơnie. ");
INSERT INTO cje_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Pô tơnia: “Rùp sơ̆ng angăn ni la aràng sơi?” ");
INSERT INTO cje_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Buơl guñu đờm sơđồ: “Sesa.” Pô đờm: “Yơu nư̆n, bơ-yàr bĕ tơ Sesa phơ̆n hơgĕ phơ̆n Sesa, sơ̆ng bơ-yàr bĕ tơ Yàng Pô Lơngì phơ̆n hơgĕ phơ̆n Yàng Pô Lơngì.” ");
INSERT INTO cje_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Mơhư̆ Pô đờm yơu nư̆n, buơl guñu mă ngă krơi-takơtuă, sơ̆ng luơi Pô bloh nau. ");
INSERT INTO cje_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Kŭng lăm hơrơi nư̆n rơi, hũ du mơnih Sađuse, la tơrpuơl mơnih đờm lài 'buh hũ pơnuaĭ hơdiŭ wơ̆, truh sơ̆ng Yàng Jêsu bloh tơnia: ");
INSERT INTO cje_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Ơ Pô-Pơto, Môise hũ đờm: ‘Yah sa aràng mơnih mơtai bloh 'buh hũ anà, nư̆n mơnih adơi păl khiăng sơ̆ng kơmơi bơdrau nư̆n tô hũ anà pioh jơi tơ sơ-ai drơi.’ ");
INSERT INTO cje_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Tŭ ni, tơkrah buơl dơlhă hũ tơjuh aràng adơi-ai lơkơi. Mơnih sơ-ai kơc̆ua khiăng kơmơi, bloh nư̆n mơtai, bloh kơyoa 'buh hũ anà, nư̆n luơi sơdiŭ wơ̆ tơ adơi. ");
INSERT INTO cje_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Mơnih dua, bloh nư̆n mơnih klơu, tơ̆l truh tơ mơnih tơjuh, mơnih lơi kŭng yơu nư̆n rơi. ");
INSERT INTO cje_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Hơdơi luĭ, mơnih kơmơi kŭng mơtai. ");
INSERT INTO cje_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Yơu nư̆n, tŭ hơdiŭ wơ̆, mơnih kơmơi nư̆n rơŭ la sơdiŭ aràng sơi lăm tơjuh aràng adơi-ai nư̆n? Kơyoa yàu aràng buơl guñu, aràng sơi kŭng hũ khiăng sơ̆ng kơmơi nư̆n abih.” ");
INSERT INTO cje_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yàng Jêsu đờm: “Buơl guhã asŭ bơjơ, kơyoa buơl guhã 'buh wờng 'Bồn Bơ-àr Sơc̆ih-Sri sơ̆ng kŭng 'buh wờng gơnăp-gơnuăr Yàng Pô Lơngì. ");
INSERT INTO cje_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Kơyoa tŭ hơdiŭ wơ̆, aràng rơŭ 'buh khiăng kơmơi halài khiăng lơkơi, bloh rơŭ yơu du mơnih gơdrưh tơ ngŏ lơngì rơi. ");
INSERT INTO cje_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Dò mư̆ng bruă mơnih mơtai hơdiŭ wơ̆, nư̆n buơl guhã 'buh pơrpoh-c̆ơ pơnuaĭ Yàng Pô Lơngì hũ đờm ơu? ");
INSERT INTO cje_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Kơu la Yàng Pô Lơngì Abraham, Yàng Pô Lơngì Isak, sơ̆ng Yàng Pô Lơngì Jakôp.’ Pô 'buh iơŭ la Yàng Pô Lơngì mơnih mơtai bloh la Yàng Pô Lơngì mơnih hơdiŭ.” ");
INSERT INTO cje_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Tŭ buơl làng mơhư̆ pơnuaĭ nư̆n, buơl guñu mă ngă c̆rih-takơtuă biă mư̆ng pơnuaĭ Pô pơto-pơsài. ");
INSERT INTO cje_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Tŭ mơhư̆ thơu Yàng Jêsu hũ ngă tơ du mơnih Sađuse păl kơđơ̆ng kàng 'buh đờm sơđồ jiơ̆ng, nư̆n du mơnih Pharisi pơgùm-pơtòm gơŭ wơ̆. ");
INSERT INTO cje_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Bloh nư̆n sa aràng mơnih gơnuăr-pơto pơnuaĭ adăt-adia lăm tơrpuơl buơl guñu tơnia Pô pơnuaĭ tô lòng Pô: ");
INSERT INTO cje_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Ơ Pô-Pơto, lăm pơnuaĭ Adăt-Adia, pơnuaĭ adăt-pơđăr lơi la prŏng-màng rơlau abih?” ");
INSERT INTO cje_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yàng Jêsu đờm: “‘Hã păl abih hơtai-hơtiàn, abih bơngă-joa, abih hơtai-akŏ bloh duh-rơnăm Yàng la Yàng Pô Lơngì hã.’ ");
INSERT INTO cje_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Nư̆n la pơnuaĭ adăt-pơđăr dơlhơu rơlau abih sơ̆ng prŏng-màng rơlau abih. ");
INSERT INTO cje_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Dò pơnuaĭ adăt-pơđăr dua kŭng mơhiơ̆ yơu nư̆n rơi: ‘Hã păl rơnăm tơ mơnih gơŭ sa plơi adơi sa 'băng yơu rơnăm rùp-phŭn drơi.’ ");
INSERT INTO cje_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Abih tơgrơ̆ pơnuaĭ adăt-adia sơ̆ng pơnuaĭ gơnuăr-hwơ̆r la kơyoa mư̆ng dua pơnuaĭ adăt-pơđăr nư̆n bloh tơbiă.” ");
INSERT INTO cje_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Lăm tŭ du mơnih Pharisi pơgùm pơtòm sơ̆ng gơŭ, nư̆n Yàng Jêsu tơnia buơl guñu lài: ");
INSERT INTO cje_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Buơl guhã sơnư̆ng hơyơu lơi mư̆ng Pô Krist? Pô la anà aràng sơi?” Buơl guñu đờm: “Anà pơtau Đabit.” ");
INSERT INTO cje_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Pô tơnia: “Yơu nư̆n, kơđa hơgĕ pơtau Đabit tŭ hũ Bơngă Sơc̆ih-Sri pơsàng sơrdah, iơu Pô la Yàng, sơ̆ng đờm lài: ");
INSERT INTO cje_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Yàng đờm sơ̆ng Yàng dơlhă: Dò guh bĕ tơ gah hơnuă Kơu, Tơ̆l truh tơ tŭ Kơu daŭ mơnih mơbai-tămdră sơ̆ng Anà tơ ala tơkai Anà.’ ");
INSERT INTO cje_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Yơu nư̆n, yah pơtau Đabit hũ iơu Pô la ‘Yàng’, nư̆n ngă hơyơu Pô la anà pơtau nư̆n jiơ̆ng?” ");
INSERT INTO cje_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","'Buh aràng sơi hũ rơgơi đờm sơđồ jiơ̆ng sa boh pơnuaĭ. Sơ̆ng kŭng mư̆ng hơrơi nư̆n, 'buh aràng sơi khĭn tơnia Pô tra. ");
INSERT INTO cje_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Tŭ nư̆n, Yàng Jêsu đờm pơto tơrpuơl buơl làng sơ̆ng du mơnih tui-mơgru Pô lài: ");
INSERT INTO cje_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Du mơnih gơnuăr-pơto pơnuaĭ adăt-adia sơ̆ng du mơnih Pharisi dò guh tơ ngŏ sơbàn Môise bloh pơto. ");
INSERT INTO cje_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Yơu nư̆n, ngă tui bĕ sơ̆ng păng-rơmiă tơgrơ̆ pơnuaĭ hơgĕ buơl guñu pơto-pơđăr buơl guhã; bloh juơi đòm tui tơgrơ̆ bruă buơl guñu ngă. Kơyoa buơl guñu mĭn đờm bloh 'buh ngă. ");
INSERT INTO cje_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Buơl guñu akă sơ̆ng pơ-anòng du anòng traŭ 'buh buơ̆n gui-anòng tơ ngŏ bra mơnih pơkơ̆n, bloh rùp-phŭn buơl guñu nư̆n 'buh khiăng tŭp tơngàn ngă. ");
INSERT INTO cje_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Buơl guñu ngă bruă hơgĕ kŭng mĭn tô aràng 'buh, kơyoa nư̆n, buơl guñu akă du kơdŭng-kơlì tô prŏng, c̆ăr du brui ào tô atàh. ");
INSERT INTO cje_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Buơl guñu khiăng dò guh tơ du anih prŏng-màng rơlau abih lăm anih mơñŭm 'bơ̆ng sơ̆ng lăm sàng pơtòm, ");
INSERT INTO cje_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","khiăng hũ aràng kù akŏ tơnia-c̆uă drơi tơkrah drà, sơ̆ng khiăng aràng angăn drơi la pô-pơto! ");
INSERT INTO cje_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Bloh buơl guhã juơi luơi aràng sơi iơu drơi la pô-pơto; kơyoa buơl guhã mĭn hũ sa aràng Pô-Pơto, sơ̆ng abih yàu aràng buơl guhã la adơi-ai sơ̆ng gơŭ. ");
INSERT INTO cje_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Kŭng juơi iơu mơnih lơi lăm dun-ya ni la ama drơi; kơyoa buơl guhã mĭn hũ sa aràng Ama, la Pô dò tơ ngŏ lơngì. ");
INSERT INTO cje_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Kŭng juơi luơi aràng sơi iơu drơi la pô; kơyoa buơl guhã mĭn hũ sa aràng Pô, nư̆n la Pô Krist. ");
INSERT INTO cje_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Aràng sơi la mơnih prŏng rơlau abih tơkrah buơl guhã, rơŭ ngă mơnih duh-bruă tơ buơl guhã. ");
INSERT INTO cje_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Aràng sơi pồ pơglòng rùp-phŭn drơi, rơŭ kŏng pơtrŭn; dò aràng sơi pơ-ơneh rùp-phŭn drơi trŭn, rơŭ hũ pồ pơglòng. ");
INSERT INTO cje_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Gleh-glăr dồn-să tơ buơl guhã, du mơnih gơnuăr-pơto pơnuaĭ adăt-adia sơ̆ng mơnih Pharisi, la du mơnih hơtai-hơtiàn mơthĭ-lơ̆r! Kơyoa buơl guhã kăl kơdrơ̆ bơh 'băng Lơgăr Lơngì tơ anaŭ aràng. Rùp-phŭn buơl guhã 'buh tơma, bloh du mơnih lơi khiăng tơma, buơl guhã pơkơŭ-c̆ơkhă 'buh luơi buơl guñu tơma. ");
INSERT INTO cje_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Gleh-glăr dồn-să tơ buơl guhã, du mơnih gơnuăr-pơto pơnuaĭ adăt-adia sơ̆ng mơnih Pharisi, la du mơnih hơtai-hơtiàn mơthĭ-lơ̆r! Kơyoa buơl guhã nau lăm abih tơgrơ̆ anih, tơ ngŏ ia-tơsì kŭng yơu lăm lơ̆n, tô pơto-jà sa aràng mơnih tơma lăm jơlàn păng-tui; bloh tŭ mơnih nư̆n tơma lăm jơlàn păng-tui bơjơ, buơl guhã ngă tơ mơnih nư̆n tơbiă jiơ̆ng anà brŏng-apui dua amăng rơlau tơ buơl guhã wơ̆. ");
INSERT INTO cje_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Gleh-glăr dồn-să tơ buơl guhã, la du mơnih bồm ba jơlàn! Buơl guhã đờm lài: ‘Yah aràng sơi sơc̆ê tơ sàng duh-dơlbăt bloh tơpah-sri, nư̆n hũ tơpah-sri kŭng yơu 'buh hũ; bloh yah sơc̆ê tơ mừh lăm sàng duh-dơlbăt bloh tơpah-sri, nư̆n păl kơđòng pơc̆uăl-akă lăm pơnuaĭ tơpah-sri nư̆n.’ ");
INSERT INTO cje_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ơ du mơnih bơrngư̆l-gơla sơ̆ng bồm mơsrư̆ dih, mừh halài sàng duh-dơlbăt ngă tơ mừh jiơ̆ng sơc̆ih-sri, phơ̆n lơi prŏng-màng rơlau? ");
INSERT INTO cje_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Buơl guhã đờm lài: ‘Yah aràng sơi sơc̆ê tơ sơbàn duh-dơlbăt bloh tơpah-sri, nư̆n hũ tơpah-sri kŭng yơu 'buh hũ; bloh aràng sơi sơc̆ê tơ phơ̆n pơyă tơ ngŏ sơbàn duh-dơlbăt bloh tơpah-sri, nư̆n păl kơđòng pơc̆uăl-akă lăm pơnuaĭ tơpah-sri nư̆n.’ ");
INSERT INTO cje_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ơ du mơnih bồm mơsrư̆, phơ̆n c̆ĕ-pơyơ̆r duh-dơlbăt halài sơbàn duh-dơlbăt ngă tơ phơ̆n c̆ĕ-pơyơ̆r duh-dơlbăt jiơ̆ng sơc̆ih-sri, hơgĕ prŏng-màng rơlau? ");
INSERT INTO cje_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Kơyoa nư̆n, aràng sơi sơc̆ê tơ sơbàn duh-dơlbăt bloh tơpah-sri, nư̆n la sơc̆ê tơ sơbàn duh-dơlbăt găm sơ̆ng phơ̆n c̆ĕ-pơyơ̆r duh-dơlbăt tơ ngŏ nư̆n bloh tơpah-sri; ");
INSERT INTO cje_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","aràng sơi sơc̆ê tơ sàng duh-dơlbăt bloh tơpah-sri, nư̆n la sơc̆ê tơ sàng duh-dơlbăt găm sơ̆ng Pô dò tơ anih nư̆n bloh tơpah-sri. ");
INSERT INTO cje_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Sơ̆ng aràng sơi sơc̆ê tơ lơngì bloh tơpah-sri, nư̆n la sơc̆ê tơ sơbàn Yàng Pô Lơngì găm sơ̆ng Pô dò guh tơ ngŏ sơbàn nư̆n bloh tơpah-sri. ");
INSERT INTO cje_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Gleh-glăr dồn-să tơ buơl guhã, du mơnih gơnuăr-pơto pơnuaĭ adăt-adia sơ̆ng mơnih Pharisi, la du mơnih hơtai-hơtiàn mơthĭ-lơ̆r! Kơyoa buơl guhã pơyă sa pơ-ơnah sa-pluh ơñiăm lơboa, ơñiăm bŏ sơ̆ng ơñiăm krồng, bloh luơi du pơnuaĭ prŏng-màng rơlau lăm pơnuaĭ adăt-adia la pơnuaĭ rĭng-tơpă, hơtai-hơtiàn anĭt-rơnăm, sơ̆ng pơnuaĭ păng-tui. Buơl guhã păl ngă du pơnuaĭ ni, bloh kŭng 'buh hũ luơi du pơnuaĭ dih. ");
INSERT INTO cje_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ơ du mơnih bồm ba jơlàn, buơl guhã lơhàng mă gơhũ rơwai tìt, bloh luơ̆n lakđa! ");
INSERT INTO cje_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Gleh-glăr dồn-să tơ buơl guhã, du mơnih gơnuăr-pơto pơnuaĭ adăt-adia sơ̆ng mơnih Pharisi, la du mơnih hơtai-hơtiàn mơthĭ-lơ̆r! Kơyoa buơl guhã rào goh gah agàh c̆uàn sơ̆ng sơlào, bloh gah dơrlăm nư̆n baŭ du pơnuaĭ klĕ-blơ̆ sơ̆ng pơnuaĭ hàm-kơrlih 'buh thơu srăp. ");
INSERT INTO cje_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ơ mơnih Pharisi bồm mơsrư̆ dih! Dơlhơu biă, păl rào gah dơrlăm c̆uàn sơ̆ng sơlào, tô gah agàh kŭng hũ goh rơi. ");
INSERT INTO cje_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Gleh-glăr dồn-să tơ buơl guhã, du mơnih gơnuăr-pơto pơnuaĭ adăt-adia sơ̆ng du mơnih Pharisi, la du mơnih hơtai-hơtiàn mơthĭ-lơ̆r! Kơyoa buơl guhã mơhiơ̆ yơu du kŭt-pơsàt aràng bah ñòm ia c̆ùr kò, gah agàh c̆ơ yơu siàm mơkrư, bloh gah dơrlăm nư̆n baŭ du tơlàng mơnih mơtai sơ̆ng tơgrơ̆ pơnuaĭ sơŭ brơŭ. ");
INSERT INTO cje_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Buơl guhã kŭng yơu nư̆n rơi, gah agàh ngă yơu rĭng-tơpă tơ anaŭ aràng, bloh gah dơrlăm nư̆n baŭ du pơnuaĭ mơsak-jơhà sơ̆ng hơtai-hơtiàn mơthĭ-lơ̆r. ");
INSERT INTO cje_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Gleh-glăr dồn-să tơ buơl guhã, du mơnih gơnuăr-pơto pơnuaĭ adăt-adia sơ̆ng du mơnih Pharisi, la du mơnih hơtai-hơtiàn mơthĭ-lơ̆r! Kơyoa buơl guhã bơ̆ kŭt-pơsàt tơ du mơnih gơnuăr-hwơ̆r, sơ̆ng ngă mơkrư kŭt-pơsàt tơ du mơnih rĭng-tơpă, ");
INSERT INTO cje_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","sơ̆ng đờm: ‘Yah hơdiŭ găm sa rài sơ̆ng du kơi-kŏ pàng-yau, nư̆n nìn-kơjăp biă buơl gudrơi 'buh hũ pơ-ơnah sơ̆ng buơl guñu lăm bruă ngă hŏ drah du mơnih gơnuăr-hwơ̆r.’ ");
INSERT INTO cje_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Yơu nư̆n, mư̆ng rùp-phŭn buơl guhã hũ ngă grơh lài drơi la anà-tơc̆o tơgrơ̆ mơnih pơmơtai du mơnih gơnuăr-hwơ̆r. ");
INSERT INTO cje_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Nư̆n buơl guhã ngă bĕ tô baŭ rơnì glài-sơnoh kơi-kŏ pàng-yau buơl guhã! ");
INSERT INTO cje_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ơ jơi ala, jơi-pơtiàn ala mơsak-jơhà dih! Ngă hơyơu buơl guhã pleh klàh pơnuaĭ ngă-glài lăm anih brŏng-apui jiơ̆ng? ");
INSERT INTO cje_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Kơyoa nư̆n, Kơu pơđăr du mơnih gơnuăr-hwơ̆r, du mơnih jak-khờh, du mơnih gơnuăr-pơto pơnuaĭ adăt-adia truh sơ̆ng buơl guhã. Lăm du mơnih nư̆n, hũ mơnih nư̆n buơl guhã rơŭ pơmơtai sơ̆ng pơ̆ng tơ kơyơu pơkăl, hũ mơnih nư̆n buơl guhã rơŭ pờng-ngă lăm sàng pơtòm sơ̆ng pơgui mă buơl guñu mư̆ng plơi-prŏng ni truh plơi-prŏng dih, ");
INSERT INTO cje_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","tô drah abih tơgrơ̆ mơnih rĭng-tơpă hũ hŏ tơbiă lăm lơ̆n, pơtuh abih tơ ngŏ buơl guhã, mư̆ng drah Abel la mơnih rĭng-tơpă, truh tơ drah Sac̆ari, anà lơkơi 'Barac̆i, bloh buơl guhã hũ pơmơtai tơkrah sàng duh-dơlbăt sơ̆ng sơbàn duh-dơlbăt. ");
INSERT INTO cje_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Iơŭ biă, Kơu đờm sơ̆ng buơl guhã, abih tơgrơ̆ pơnuaĭ nư̆n rơŭ tơbiă truh tơ jơi-pơtiàn ni.” ");
INSERT INTO cje_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Ơ Jerusalem, Jerusalem! Hã pơmơtai du mơnih gơnuăr-hwơ̆r sơ̆ng prah pơtơu du mơnih hũ pơđăr truh sơ̆ng hã! Thơu hơdùm amăng bơjơ Kơu khiăng pơgùm-pơtòm du anà-tơc̆o hã wơ̆, yơu mơnŭ ơna pơkruk tơrgùm anà drơi tơ ala sơ-yàu, bloh buơl guhã 'buh khiăng! ");
INSERT INTO cje_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ni, sàng buơl guhã rơŭ luơi jơhua! ");
INSERT INTO cje_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Kơyoa kơu đờm sơ̆ng buơl guhã, mư̆ng ni buơl guhã rơŭ 'bu 'buh Kơu tra, tơ̆l truh tơ tŭ buơl guhã rơŭ đờm: ‘Mơyòm-pơglòng Pô mă angăn Yàng bloh truh!’ ” ");
INSERT INTO cje_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Tŭ Yàng Jêsu mư̆ng sàng duh-dơlbăt nau tơbiă, nư̆n du mơnih tui-mơgru Pô truh jĕ, pơto tơ Pô c̆ơ du sàng găm sơ̆ng sàng duh-dơlbăt. ");
INSERT INTO cje_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Pô đờm: “Buơl guhã hũ 'buh tơgrơ̆ pơnuaĭ nư̆n rơi? Iơŭ biă, Kơu đờm sơ̆ng buơl guhã, anih ni rơŭ 'buh dò sa boh pơtơu lơi rờng tơ ngŏ boh pơtơu pơkơ̆n bloh 'buh kơđòng jơrlơh trŭn.” ");
INSERT INTO cje_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Tŭ Pô dò guh tơ ngŏ c̆ơ̆ Ôlibe, du mơnih tui-mơgru truh tơnia krơi Pô lài: “Yòng Pô-Pơto đờm tơ buơl dơlhă thơu tŭ lơi du bruă nư̆n rơŭ tơbiă truh, sơ̆ng hũ nàl hơgĕ brơi pơthơu dơlhơu mư̆ng bruă Yàng truh sơ̆ng hơrơi luĭ-dŭt rài dun-ya ni?” ");
INSERT INTO cje_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yàng Jêsu đờm: “C̆ơ-kơrmăp bĕ, juơi luơi aràng sơi pơluơ pơ̆ng-gơla buơl guhã. ");
INSERT INTO cje_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kơyoa hũ lô mơnih rơŭ pơ̆ng-gơla mă angăn Kơu truh bloh đờm lài: ‘Kơu la Pô Krist,’ sơ̆ng buơl guñu rơŭ pơluơ pơ̆ng-gơla lô mơnih. ");
INSERT INTO cje_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Buơl guhã rơŭ mơhư̆ đờm mư̆ng klìn-kơtuă sơ̆ng pơnuaĭ pơtiơ̆ng mư̆ng klìn-kơtuă. C̆ơ-kơrmăp bĕ. Juơi huơĭ kơtuă. Kơyoa tơgrơ̆ bruă nư̆n păl tơbiă truh, bloh ka iơŭ la luĭ-dŭt ơu. ");
INSERT INTO cje_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Kơyoa buơl làng ni rơŭ tơgồ tămdră-wơ̆ sơ̆ng buơl làng pơkơ̆n, lơgăr ni tămdră-wơ̆ sơ̆ng lơgăr dih. Lô anih rơŭ hũ ờ-lơpa sơ̆ng tơtuơ̆n-jơrlơh lơ̆n-tơnah. ");
INSERT INTO cje_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Bloh abih tơgrơ̆ bruă nư̆n mĭn la c̆ơmrừp akŏ pơnuaĭ pơđì-pơđoa gleh-glăr. ");
INSERT INTO cje_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Tŭ nư̆n, aràng rơŭ mă jào buơl guhã, ngă tơ buơl guhã păl kŏng pơđì-pơđoa gleh-glăr, sơ̆ng aràng rơŭ pơmơtai buơl guhã. Buơl guhã rơŭ kŏng tơgrơ̆ buơl làng mơbai-lơmù kơyoa mư̆ng angăn Kơu. ");
INSERT INTO cje_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Tŭ nư̆n, lô mơnih rơŭ sơnĕ lơbuh, pơblơ̆-dră gơŭ, sơ̆ng mơbai-lơmù gơŭ. ");
INSERT INTO cje_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Lô mơnih gơnuăr-hwơ̆r lơ̆r rơŭ tơbiă truh sơ̆ng pơluơ pơ̆ng-gơla lô mơnih. ");
INSERT INTO cje_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Sơ̆ng kơyoa glài-sơnoh 'brŏ hơrơi 'brŏ baŭ rơlau, nư̆n hơtai-hơtiàn anĭt-rơnăm lăm lô mơnih rơŭ mơrềt wơ̆. ");
INSERT INTO cje_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Bloh aràng sơi kơjăp hơtai-hơtiàn tơ̆l truh luĭ-dŭt, nư̆n rơŭ hũ dŏng-pơklàh. ");
INSERT INTO cje_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Pơnuaĭ-Siàm mư̆ng lơgăr Yàng Pô Lơngì rơŭ hũ pơto-akhàn lăm abih dun-ya, tô ngă grơh tơ abih tơgrơ̆ buơl làng. Tŭ nư̆n pơnuaĭ luĭ-dŭt rơŭ truh. ");
INSERT INTO cje_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Yơu nư̆n, tŭ buơl guhã 'buh pơnuaĭ ngkòr-sơŭ ngă tơbiă pơnuaĭ kơprah-kơprĭng tơ Anih Sơc̆ih-Sri, yơu pơnuaĭ mơnih gơnuăr-hwơ̆r Daniel hũ đờm, (aràng sơi pơrpoh-c̆ơ păl wờng) ");
INSERT INTO cje_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","nư̆n aràng sơi dò lăm c̆àr Juđe, đuaĭ dơŭ bĕ tơ ngŏ c̆ơ̆; ");
INSERT INTO cje_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","aràng sơi dò tơ ngŏ 'blàng bơbŭng sàng, nư̆n juơi trŭn mă phơ̆n hơgĕ lăm sàng; ");
INSERT INTO cje_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","aràng sơi dò tơ 'blàng hơma, juơi gài mơrai wơ̆ mă ào agàh. ");
INSERT INTO cje_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Lăm du hơrơi nư̆n, gleh-glăr dồn-să biă tơ du mơnih kơmơi hũ mơtiàn, sơ̆ng du mơnih kơmơi hũ anà mơnga dò brơi mơ̆m! ");
INSERT INTO cje_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Iơu-lài bĕ tô buơl guhã 'buh păl đuaĭ dơŭ iơŭ lăm tŭ blàn mơrềt halài lăm hơrơi sa'bat; ");
INSERT INTO cje_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","kơyoa tŭ nư̆n rơŭ hũ pơnuaĭ rŭng-rài mơtai-lơhiă prŏng, tơ̆l truh mư̆ng tŭ c̆rơ̆ng-tơbiă lơngì-tơsì tơnah-rơya truh tơ ară ni ka tŭ lơi hũ yơu nư̆n, sơ̆ng hơdơi ni kŭng 'buh tŭ lơi hũ yơu nư̆n ơu rơi. ");
INSERT INTO cje_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Yah du hơrơi nư̆n 'buh hũ pơgơdŭn ơwĕt wơ̆, nư̆n 'buh sa aràng mơnih lơi hũ dŏng-pơklàh; bloh kơyoa mư̆ng du mơnih hũ pơlih-rơwah, nư̆n du hơrơi nư̆n rơŭ hũ pơgơdŭn ơwĕt. ");
INSERT INTO cje_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Tŭ nư̆n, yah hũ aràng sơi đờm sơ̆ng buơl guhã lài: ‘Dih, Pô Krist dò tơ anih ni,’ halài ‘Pô dò tơ anih dih,’ nư̆n juơi păng-tui. ");
INSERT INTO cje_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kơyoa du pô krist lơ̆r sơ̆ng mơnih gơnuăr-hwơ̆r lơ̆r rơŭ tơbiă truh, ngă du nàl-c̆rih pơnuaĭ-krơi tô pơluơ pơ̆ng-gơla, sơ̆ng yah hũ rơgơi, guñu kŭng truh pơluơ pơ̆ng-gơla găm du mơnih hũ pơlih-rơwah rơi. ");
INSERT INTO cje_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ni, Kơu hũ đờm dơlhơu tơ buơl guhã bơjơ. ");
INSERT INTO cje_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Kơyoa nư̆n, yah aràng đờm sơ̆ng buơl guhã lài: ‘Dih, Pô dò lăm 'blàng-jơhua,’ nư̆n juơi nau truh. ‘Ni, Pô dò lăm sàng,’ nư̆n juơi păng-tui. ");
INSERT INTO cje_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kơyoa mơhiơ̆ yơu c̆ă-kơrla tơbiă mư̆ng gah ia-hơrơi tơgồ, kơc̆rà sơrdah truh tơ gah ia-hơrơi tơma hơyơu lơi, nư̆n pơnuaĭ Anà Mơnih truh kŭng rơŭ yơu nư̆n rơi. ");
INSERT INTO cje_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Anih lơi hũ rùp atơu mơtai, nư̆n du c̆ĭm grơ̆ rơŭ pơgùm gơŭ tơ anih nư̆n. ");
INSERT INTO cje_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Hơdơi mư mư̆ng du hơrơi rŭng-rài nư̆n, ia-hơrơi rơŭ mơsrư̆-kơnăm, ia-blàn rơŭ 'buh pơsàng sơrdah, du ia-pơtŭ rơŭ mư̆ng ngŏ lơngì lĕ trŭn, sơ̆ng du gơnuăr tơ ngŏ lơngì rơŭ tơtuơ̆n-mơgơi. ");
INSERT INTO cje_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Tŭ nư̆n, nàl Anà Mơnih rơŭ tơbiă pơ'buh tơ ngŏ lơngì, tơgrơ̆ jơi-pơtiàn lăm dun-ya rơŭ sơ-anŭ hărda hia-c̆ŏ, sơ̆ng rơŭ 'buh Anà Mơnih mă gơnăp-gơnuăr prŏng sơ̆ng pơnuaĭ màng-kơc̆rà prŏng, mư̆ng ngŏ hwăl lơngì bloh truh. ");
INSERT INTO cje_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Pô rơŭ pơđăr du mơnih gơdrưh drơi angui săp kơlwờk prŏng biă bloh pơgùm-pơtòm tơgrơ̆ mơnih hũ pơlih-rơwah mư̆ng abih tơgrơ̆ anih lăm dun-ya, mư̆ng tơluĭ tơkai lơngì ni truh tơluĭ tơkai lơngì dih. ");
INSERT INTO cje_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Buơl guhã mă bĕ pơnuaĭ pơmơyơu mư̆ng phŭn hra bloh mơgru. Tŭ 'buh thàn ñu tơbiă lơ-o, sơla bơrhơu c̆ă, nư̆n buơl guhã thơu blàn phàng kơjĕ truh. ");
INSERT INTO cje_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Kŭng yơu nư̆n rơi, tŭ buơl guhã 'buh tơgrơ̆ pơnuaĭ ni, nư̆n thơu bĕ lài Anà Mơnih kơjĕ truh, Pô dò tơ anaŭ bơh 'băng bơjơ. ");
INSERT INTO cje_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Iơŭ biă, Kơu đờm sơ̆ng buơl guhã, jơi-pơtiàn rài ni rơŭ 'buh nau rơlau dơlhơu tŭ tơgrơ̆ pơnuaĭ nư̆n tơbiă truh. ");
INSERT INTO cje_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Lơngì-tơsì tơnah-rơya rơŭ lơhiă, bloh tơgrơ̆ pơnuaĭ Kơu đờm rơŭ 'buh tŭ lơi lơhiă ơu.” ");
INSERT INTO cje_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Mư̆ng hơrơi sơ̆ng jơ nư̆n, 'buh hũ aràng sơi thơu jiơ̆ng, găm du mơnih gơdrưh tơ ngŏ lơngì halài Anà kŭng yơu nư̆n rơi, bloh mĭn sa aràng Ama thơu soh. ");
INSERT INTO cje_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Yơu lăm rài Nôe hơyơu lơi, tŭ Anà Mơnih truh kŭng yơu nư̆n rơi. ");
INSERT INTO cje_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Kơyoa lăm du hơrơi dơlhơu tŭ ia-tơsì đì ia tơba, aràng 'bơ̆ng, mơñŭm, puaĭ lơkơi khiăng kơmơi yơu bơhiàn, tơ̆l truh tơ hơrơi Nôe tơma lăm ahò. ");
INSERT INTO cje_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Buơl guñu 'buh thơu hơgĕ tơ̆l truh tŭ ia-tơsì đì ia tơba truh sơ̆ng hua nau abih tơgrơ̆ mơta. Tŭ Anà Mơnih truh kŭng rơŭ yơu nư̆n rơi. ");
INSERT INTO cje_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Tŭ nư̆n, hũ dua aràng mơnih lơkơi dò ngă bruă lăm 'blàng hơma, sa aràng hũ ba nau, sa aràng kơđòng luơi wơ̆. ");
INSERT INTO cje_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Hũ dua aràng mơnih kơmơi dò tơŭ bơdai, sa aràng hũ ba nau, sa aràng kơđòng luơi wơ̆. ");
INSERT INTO cje_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Kơyoa nư̆n, păl mơdơh-kraŭ bĕ, kơyoa buơl guhã 'buh thơu hơrơi lơi Yàng drơi rơŭ truh. ");
INSERT INTO cje_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Bloh păl wờng pơnuaĭ ni, yah mơnih pô sàng thơu tŭ-aguah lơi mơnih klĕ rơŭ truh, nư̆n rơŭ mơdơh-kraŭ, 'buh luơi mơnih klĕ tơma lăm sàng drơi ơu. ");
INSERT INTO cje_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Yơu nư̆n, buơl guhã kŭng păl rơc̆ăng-kraŭ bĕ, kơyoa Anà Mơnih rơŭ truh lăm tŭ jơ buơl guhã 'buh sơnư̆ng thơu jiơ̆ng. ");
INSERT INTO cje_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Aràng sơi la mơnih hơlŭn-hơlă tơpă sa hơtai-hơtiàn sơ̆ng jak-khờh, hũ mơnih pô jào c̆ơ apăn-akŏ abih sàng drơi, tô brơi pơrpha phơ̆n-kơya 'bơ̆ng iơŭ tŭ-jơ? ");
INSERT INTO cje_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Lơngai-pơtuah tơ mơnih hơlŭn-hơlă nư̆n, tŭ mơnih pô truh 'buh ñu ngă yơu nư̆n! ");
INSERT INTO cje_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Iơŭ biă, Kơu đờm sơ̆ng buơl guhã, mơnih pô rơŭ jào tơ mơnih nư̆n c̆ơ apăn-akŏ abih phŭm-kơsai phơ̆n-bơna drơi. ");
INSERT INTO cje_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Bloh yah mơnih hơlŭn-hơlă nư̆n jơhà, sơnư̆ng iờp lăm hơtai-hơtiàn lài: ‘Pô kơu ka mơrai wơ̆ mư ơu,’ ");
INSERT INTO cje_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","bloh nư̆n ngă-pờng du mơnih adơi-ai gơŭ ngă hơlŭn-hơlă yơu drơi, sơ̆ng mơñŭm 'bơ̆ng sơ̆ng buơl mơnih rơmbuh-rơmbèng. ");
INSERT INTO cje_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Pô mơnih hơlŭn-hơlă nư̆n rơŭ truh lăm hơrơi ñu 'buh sơnư̆ng, lăm jơ ñu 'buh thơu. ");
INSERT INTO cje_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Mơnih pô rơŭ pờng tơrhĕt rùp ñu, bloh nư̆n pơtơma ñu lăm sa anih găm sơ̆ng du mơnih hơtai-hơtiàn mơthĭ-lơ̆r. Nư̆n la anih rơŭ hũ hia-c̆ŏ sơ̆ng kĕ tơgơi.” ");
INSERT INTO cje_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Tŭ nư̆n, Lơgăr Lơngì rơŭ mơhiơ̆ yơu sa-pluh aràng kơmơi dra sơc̆ih-sơc̆ăn apăn apui-đèng nau rò mơrtơu-lơkơi. ");
INSERT INTO cje_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Lăm sa-pluh aràng kơmơi nư̆n, hũ lơma aràng kơmơi gơla sơ̆ng lơma aràng kơmơi jak. ");
INSERT INTO cje_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Du kơmơi gơla apăn apui-đèng, bloh 'buh apăn mơñà apui tui. ");
INSERT INTO cje_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Dò du kơmơi jak nư̆n apăn apui-đèng sơ̆ng apăn găm mơñà apui tui. ");
INSERT INTO cje_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Kơyoa mơrtơu-lơkơi suơi truh, nư̆n abih du mơnih kơmơi tơnò mơta sơ̆ng đih wơ̆r. ");
INSERT INTO cje_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Bloh truh mơtưh mơlăm, hũ săp iơu prŏng: ‘Dih, mơrtơu-lơkơi truh bơjơ! Sơmăr tơbiă nau rò bĕ!’ ");
INSERT INTO cje_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Tŭ nư̆n, abih du kơmơi dra sơc̆ih-sơc̆ăn mơdơh tơgồ, sơ̆ng rơc̆ăng apui-đèng drơi. ");
INSERT INTO cje_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Du kơmơi gơla đờm sơ̆ng du kơmơi jak lài: ‘Yòng klah brơi tơ buơl dơlhă sa-sĭt mơñà apui buơl sơ-ai, kơyoa apui-đèng buơl dơlhă kơjĕ mơtai bơjơ.’ ");
INSERT INTO cje_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Bloh du kơmơi jak đờm sơđồ: ‘'Buh jiơ̆ng ơu, huơĭ 'buh tơ̆l mơñà tơ găm buơl dơlhă sơ̆ng buơl sơ-ai; siàm rơlau, buơl sơ-ai nau truh bĕ sơ̆ng mơnih pơblơi mơñà bloh blơi.’ ");
INSERT INTO cje_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Bloh lăm tŭ buơl guñu nau blơi, nư̆n mơrtơu-lơkơi truh. Du mơnih hũ rơc̆ăng-kraŭ lờih nư̆n nau sơ̆ng mơrtơu-lơkơi tơma lăm pơnuaĭ mơñŭm 'bơ̆ng khiăng-gơŭ, sơ̆ng bơh 'băng krơ̆ wơ̆. ");
INSERT INTO cje_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Hơdơi luĭ, du kơmơi sơc̆ih-sơc̆ăn dih kŭng truh, buơl guñu iơu yòng: ‘Ơ Pô, ơ Pô! yòng pơh bơh 'băng tơ buơl dơlhă!’ ");
INSERT INTO cje_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Bloh mơnih pô đờm: ‘Iơŭ biă Kơu đờm sơ̆ng buơl guhã, Kơu 'buh thơu buơl guhã la aràng sơi ơu.’ ");
INSERT INTO cje_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yơu nư̆n, păl mơdơh-kraŭ bĕ, kơyoa buơl guhã 'buh thơu hơrơi, kŭng 'buh thơu jơ.” ");
INSERT INTO cje_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Lơgăr Lơngì kŭng mơhiơ̆ yơu sa aràng mơnih dih kơjĕ nau jơlàn atàh, iơu du mơnih hơlŭn-hơlă truh bloh jào phơ̆n-bơna drơi tơ buơl guñu. ");
INSERT INTO cje_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Mơnih pô jào tơ mơnih ni lơma talơ̆ng, mơnih dih dua talơ̆ng, mơnih pơkơ̆n wơ̆ sa talơ̆ng, tui sơ̆ng pơnuaĭ khờh-rơgơi yàu aràng. Bloh nư̆n mơnih pô nau jơlàn. ");
INSERT INTO cje_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Mơnih hũ đồ-mă lơma talơ̆ng, tơbiă nau kă-bơnia blơi-sơlih, sơ̆ng ngă tơbiă phŭn-hơjŭng hũ lơma talơ̆ng pơkơ̆n wơ̆. ");
INSERT INTO cje_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Mơnih đồ-mă dua talơ̆ng kŭng yơu nư̆n rơi, ngă tơbiă phŭn-hơjŭng hũ dua talơ̆ng tra. ");
INSERT INTO cje_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Bloh mơnih hũ đồ-mă sa talơ̆ng, nư̆n nau klơi lơbàng sơ̆ng dơ̆r bơdơŭ priă mơnih Pô. ");
INSERT INTO cje_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Hơdơi mư̆ng nư̆n lơ-ơh hơrơi, pô du mơnih hơlŭn-hơlă ni gài mơrai wơ̆, sơ̆ng iơu du mơnih hơlŭn-hơlă truh tô c̆ơ yàu aràng duah hũ hơdùm priă tơ ñu. ");
INSERT INTO cje_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Mơnih hũ đồ-mă lơma talơ̆ng truh, apăn tui lơma talơ̆ng tra, sơ̆ng đờm: ‘Ơ pô, pô hũ jào tơ dơlhă lơma talơ̆ng, ni, dơlhă ngă tơbiă phŭn-hơjŭng hũ lơma talơ̆ng tra wơ̆.’ ");
INSERT INTO cje_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Mơnih pô đờm sơ̆ng mơnih nư̆n: ‘Ơ mơnih hơlŭn-hơlă siàm sơ̆ng tơpă sa hơtai-hơtiàn dih, siàm biă! Hã hũ tơpă sa hơtai-hơtiàn lăm bruă tìt, kơu rơŭ jào tơ hã c̆ơ-apăn lô bruă rơlau. Tơma bĕ bloh đồ-lĕng pơnuaĭ sờh-sài sơ̆ng pô hã.’ ");
INSERT INTO cje_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Mơnih hũ đồ-mă dua talơ̆ng kŭng truh sơ̆ng đờm: ‘Ơ pô, pô hũ jào tơ dơlhă dua talơ̆ng, ni, dơlhă ngă tơbiă phŭn-hơjŭng hũ dua talơ̆ng tra.’ ");
INSERT INTO cje_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Mơnih pô đờm sơ̆ng mơnih nư̆n lài: ‘Ơ mơnih hơlŭn-hơlă siàm sơ̆ng tơpă sa hơtai-hơtiàn dih, siàm biă! Hã hũ tơpă sa hơtai-hơtiàn lăm bruă tìt, Kơu rơŭ jào tơ hã c̆ơ-apăn lô bruă rơlau. Truh bĕ bloh đồ-lĕng pơnuaĭ sờh-sài sơ̆ng pô hã.’ ");
INSERT INTO cje_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Mơnih hũ đồ-mă sa talơ̆ng kŭng truh sơ̆ng đờm: ‘Ơ pô, dơlhă thơu pô la mơnih jơnăp-kơđơ̆ng, yuă lăm anih drơi 'buh drà, duơ̆n mă lăm anih drơi 'buh dơnih; ");
INSERT INTO cje_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","nư̆n dơlhă huơĭ bloh apăn bơdơŭ talơ̆ng pô tơ ala lơ̆n. Ni, phơ̆n priă pô yòng bơ-yàr wơ̆ tơ pô.’ ");
INSERT INTO cje_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Bloh mơnih pô đờm lài: ‘Ơ hơlŭn-hơlă mơsak-jơhà sơ̆ng kơ-yàl alah dih! Hã thơu kơu yuă lăm anih kơu 'buh drà, sơ̆ng duơ̆n mă lăm anih kơu 'buh dơnih; ");
INSERT INTO cje_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","yơu nư̆n hã păl jào priă kơu tơ du mơnih kă-bơnia priă, tô tŭ kơu gài mơrai wơ̆, kơu rơŭ đồ-mă hũ găm phŭn sơ̆ng hơjŭng. ");
INSERT INTO cje_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Yơu nư̆n, buơl guhã mă bĕ talơ̆ng mư̆ng ñu bloh brơi tơ mơnih hũ sa-pluh talơ̆ng. ");
INSERT INTO cje_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kơyoa mơnih lơi hũ, rơŭ hũ brơi pơtơ̆l wơ̆, tô buơl guñu hũ dơlah-dơlài; bloh mơnih lơi 'buh hũ, nư̆n găm tơgrơ̆ hơgĕ buơl guñu hũ, kŭng rơŭ kŏng suă mă rơi. ");
INSERT INTO cje_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Dò mơnih hơlŭn-hơlă 'buh kwơ-màng dih, prah bĕ ñu tơbiă tơ agàh anih kơnăm-mơsrư̆; la anih rơŭ hũ hia-c̆ŏ sơ̆ng kĕ tơgơi.’ ” ");
INSERT INTO cje_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Tŭ Anà Mơnih truh lăm pơnuaĭ màng-kơc̆rà drơi, găm sơ̆ng abih du mơnih gơdrưh; tŭ nư̆n Pô rơŭ dò guh tơ ngŏ sơbàn màng-kơc̆rà Pô. ");
INSERT INTO cje_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Abih tơgrơ̆ buơl làng rơŭ pơgùm-pơtòm tơ anaŭ Pô; sơ̆ng Pô rơŭ pơklah krơi buơl guñu, yơu mơnih glăng abo pơklah krơi abo sơ̆ng pơbe, ");
INSERT INTO cje_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","luơi abo dò gah hơnuă, sơ̆ng pơbe dò gah ơñiau. ");
INSERT INTO cje_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Tŭ nư̆n, Pơtau rơŭ đờm sơ̆ng du mơnih dò gah hơnuă lài: ‘Ơ du mơnih hũ Ama Kơu brơi lơngai-pơtuah, truh bĕ đồ-mă Lơgăr hũ rơc̆ăng lờih tơ buơl guhã mư̆ng tŭ c̆rơ̆ng-tơbiă lơngì-tơsì tơnah-rơya. ");
INSERT INTO cje_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kơyoa Kơu lơpa, buơl guhã brơi Kơu 'bơ̆ng; Kơu mơhau, buơl guhã brơi Kơu mơñŭm; Kơu la mơnih thuai-c̆rih, buơl guhã jà-rò Kơu. ");
INSERT INTO cje_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Kơu kŭl-sơlŭn, buơl guhã pơc̆ù tơ Kơu; Kơu lơ-ơ̆n lơngoh rơwă-sơkì, buơl guhã rơwăng-c̆ơ Kơu; Kơu kơđòng jàm-krơ̆, buơl guhã truh c̆uă-rơwăng Kơu.’ ");
INSERT INTO cje_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Tŭ nư̆n, du mơnih rĭng-tơpă đờm sơ̆ng Pô: ‘Khoai Yàng, hũ tŭ lơi buơl dơlhă 'buh Yàng lơpa bloh brơi 'bơ̆ng, halài mơhau bloh brơi mơñŭm? ");
INSERT INTO cje_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Hũ tŭ lơi buơl dơlhă 'buh Yàng la mơnih thuai-c̆rih bloh jà-rò, halài kŭl-sơlŭn bloh pơc̆ù tơ Pô rơi? ");
INSERT INTO cje_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Halài hũ tŭ lơi buơl dơlhă 'buh Yàng lơ-ơ̆n lơngoh rơwă-sơkì, halài kơđòng jàm-krơ̆ bloh nau c̆uă-rơwăng rơi?’ ");
INSERT INTO cje_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Pơtau rơŭ đờm sơđồ lài: ‘Iơŭ biă, Kơu đờm sơ̆ng buơl guhã, tŭ buơl guhã ngă bruă nư̆n tơ sa aràng mơnih tìt rơlau abih lăm du adơi-ai Kơu ni, nư̆n la hũ ngă tơ rùp-phŭn Kơu.’ ");
INSERT INTO cje_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Bloh nư̆n, Pô đờm sơ̆ng du mơnih dò gah ơñiau lài: ‘Ơ du mơnih kơđòng pơc̆ĕ-pơtrah, nau bĕ tô tơrđơŭ mơta Kơu, bloh tơma lăm apui rài pơdò rài hũ pioh lờih tơ Satăn sơ̆ng du kơmlài-jĭnràk ñu. ");
INSERT INTO cje_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Kơyoa Kơu lơpa, buơl guhã 'buh brơi Kơu 'bơ̆ng; Kơu mơhau, buơl guhã 'buh brơi Kơu mơñŭm. ");
INSERT INTO cje_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Kơu la mơnih thuai c̆rih, buơl guhã 'buh rò-jà Kơu; Kơu kŭl-sơlŭn, buơl guhã 'buh pơc̆ù tơ Kơu; Kơu lơ-ơ̆n lơngoh rơwă-sơkì sơ̆ng kơđòng jàm-krơ̆, buơl guhã 'buh c̆uă-rơwăng Kơu.’ ");
INSERT INTO cje_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Tŭ nư̆n, du mơnih ni kŭng đờm sơđồ: ‘Khoai Yàng, hũ tŭ lơi buơl dơlhă 'buh Yàng lơpa, halài mơhau, halài Yàng la mơnih thuai c̆rih, halài kŭl-sơlŭn, halài lơ-ơ̆n lơngoh rơwă-sơkì, halài kơđòng jàm-krơ̆ bloh 'buh duh bruă Pô ơu?’ ");
INSERT INTO cje_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Pô rơŭ đờm sơđồ wơ̆ lài: ‘Iơŭ biă, Kơu đờm sơ̆ng buơl guhã, tŭ buơl guhã 'buh ngă du bruă nư̆n tơ sa aràng mơnih tìt rơlau abih lăm du mơnih ni, nư̆n la buơl guhã kŭng 'buh ngă tơ Kơu rơi.’ ");
INSERT INTO cje_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Bloh nư̆n du mơnih ni rơŭ nau tơma lăm pơnuaĭ ngă-glài rài pơdò rài, dò du mơnih rĭng-tơpă rơŭ tơma lăm pơnuaĭ hơdiŭ rài pơdò rài.” ");
INSERT INTO cje_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Hơdơi tŭ đờm pơto du pơnuaĭ nư̆n bơjơ, Yàng Jêsu đờm sơ̆ng du mơnih tui-mơgru: ");
INSERT INTO cje_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Buơl guhã thơu dò dua hơrơi tra la truh pơnuaĭ pơjŭm 'bơ̆ng Nau-Găn, sơ̆ng Anà Mơnih rơŭ kơđòng jào tô kŏng pơ̆ng tơ kơyơu pơkăl.” ");
INSERT INTO cje_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Tŭ nư̆n, du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt sơ̆ng du mơnih gơnuăr-tha lăm buơl làng pơtòm-pơjŭm gơŭ wơ̆ tơ sàng-glăng mơnih gơnuăr prŏng apăn-akŏ pơyă phơ̆n duh-dơlbăt angăn la Kaiphe, ");
INSERT INTO cje_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","tô sơ̆ng gơŭ duah bơyai pơnuaĭ mă Yàng Jêsu bloh pơmơtai. ");
INSERT INTO cje_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Bloh buơl guñu đờm: “Juơi ngă bruă nư̆n lăm pơnuaĭ pơjŭm 'bơ̆ng, huơĭ ngă kơtuă kơ'bla klùk-klờk lăm buơl làng.” ");
INSERT INTO cje_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Tŭ Yàng Jêsu dò tơ plơi 'Bethani, lăm sàng Simôn la mơnih dŭn, ");
INSERT INTO cje_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","hũ sa aràng mơnih kơmơi apăn sa boh khàr ngă sơ̆ng pơtơu màng, lăm dơrlăm daŭ baŭ mơñà 'bơu bơlhơu c̆ơk-màng biă. Mơnih kơmơi truh jĕ bloh tuh mơñà nư̆n tơ akŏ Pô, tŭ Pô dò guh huă 'bơ̆ng. ");
INSERT INTO cje_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Bloh tŭ du mơnih tui-mơgru 'buh yơu nư̆n, buơl guñu anok hơtai sơ̆ng đờm: “Kơđa hơgĕ pròng-preh phơ̆n-priă yơu nư̆n? ");
INSERT INTO cje_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Kơyoa mơñà ni hũ rơgơi pơblơi jiơ̆ng lô priă, bloh apăn dŏng du mơnih rơ'bah rơ'bừp.” ");
INSERT INTO cje_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Bloh Yàng Jêsu thơu pơnuaĭ ni, nư̆n đờm sơ̆ng du mơnih tui-mơgru: “Kơđa hơgĕ buơl guhã ngă kăn-dơmăn tơ mơnih kơmơi nư̆n? Ñu hũ ngă sa bruă siàm tơ Kơu. ");
INSERT INTO cje_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Kơyoa buơl guhã jiăng hũ mơnih rơ'bah dò sơ̆ng drơi mĭt, bloh 'buh iơŭ tŭ lơi buơl guhã kŭng hũ Kơu mĭt ơu. ");
INSERT INTO cje_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ñu tuh mơñà 'bơu bơlhơu lăm rùp Kơu la tô rơc̆ăng tơ bruă dơ̆r rùp Kơu nư̆n. ");
INSERT INTO cje_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Iơŭ biă, Kơu đờm sơ̆ng buơl guhã, lăm abih dun-ya, anih lơi Pơnuaĭ-Siàm ni hũ pơto-akhàn truh, nư̆n bruă mơnih kơmơi ni hũ ngă tơ Kơu, kŭng rơŭ hũ đờm akhàn wơ̆ tô sơdơ̆r truh ñu.” ");
INSERT INTO cje_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Tŭ nư̆n, hũ sa aràng mơnih lăm sa-pluh dua aràng mơnih tui-mơgru, angăn la Juđa Iskariôt, nau truh sơ̆ng du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt, ");
INSERT INTO cje_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","sơ̆ng đờm lài: “Buơl kơi rơŭ c̆iŭ tơ dơlhă hơdùm yah dơlhă jào Mơnih nư̆n tơ buơl kơi?” Buơl mơnih nư̆n c̆iŭ tơ ñu klơu pluh kleh priă. ");
INSERT INTO cje_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Mư̆ng tŭ nư̆n, Juđa duah tŭ hơnàn-siàm tô jào Yàng Jêsu. ");
INSERT INTO cje_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Lăm hơrơi c̆ơmrừp pơnuaĭ pơjŭm 'bơ̆ng Pah 'Buh Hũ Tơpơi, du mơnih tui-mơgru truh sơ̆ng Yàng Jêsu bloh đờm lài: “Pô-Pơto khiăng buơl dơlhă rơc̆ăng pồ tơ Pô-Pơto 'bơ̆ng pơnuaĭ pơjŭm 'bơ̆ng Nau-Găn tơ anih lơi?” ");
INSERT INTO cje_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Pô đờm: “Tơma bĕ lăm plơi-prŏng, truh sàng sa aràng mơnih dih, bloh đờm sơ̆ng mơnih nư̆n lài: ‘Pô-Pơto đờm: Jơ Kơu kơjĕ truh, Kơu sơ̆ng du mơnih tui-mơgru rơŭ 'bơ̆ng pơnuaĭ pơjŭm 'bơ̆ng Nau-Găn tơ sàng hã.’ ” ");
INSERT INTO cje_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Du mơnih tui-mơgru ngă iơŭ yơu pơnuaĭ Yàng Jêsu hũ đờm pơđăr, bloh rơc̆ăng pồ pơnuaĭ pơjŭm 'bơ̆ng Nau-Găn. ");
INSERT INTO cje_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Truh mơlăm, Pô dò guh 'bơ̆ng sơ̆ng sa-pluh dua aràng mơnih tui-mơgru. ");
INSERT INTO cje_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Tŭ dò 'bơ̆ng, Pô đờm: “Iơŭ biă, Kơu đờm sơ̆ng buơl guhã, sa aràng lăm buơl guhã rơŭ pơblơ̆-dră Kơu.” ");
INSERT INTO cje_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Du mơnih tui-mơgru dơnuh-dơnà biă, sơ̆ng yàu aràng tơnia Pô: “Khoai Yàng, hũ iơŭ dơlhă ơu?” ");
INSERT INTO cje_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Pô đờm: “Mơnih yơ̆r tơngàn c̆ik pah lăm prèng găm sơ̆ng Kơu, nư̆n la mơnih rơŭ pơblơ̆-dră Kơu. ");
INSERT INTO cje_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Anà Mơnih nau, iơŭ yơu pơnuaĭ hũ wă mư̆ng Pô, bloh gleh-glăr dồn-să biă tơ mơnih pơblơ̆-dră Anà Mơnih! Yah ñu 'buh đih apui tơbiă la siàm rơlau!” ");
INSERT INTO cje_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Juđa, la mơnih pơblơ̆-dră Pô tơnia: “Ơ Pô-Pơto, hũ iơŭ dơlhă ơu?” Pô đờm: “Biă yơu hã hũ đờm.” ");
INSERT INTO cje_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Tŭ dò 'bơ̆ng, Yàng Jêsu mă pah, ưnjơmừn, bloh nư̆n 'bĕt brơi tơ du mơnih tui-mơgru, sơ̆ng đờm: “Mă bĕ sơ̆ng 'bơ̆ng. Ni la rùp-phàp Kơu.” ");
INSERT INTO cje_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Pô kŭng mă c̆uàn, ưnjơmừn, bloh nư̆n brơi tơ du mơnih tui-mơgru, sơ̆ng đờm: “Abih yàu aràng mơñŭm bĕ. ");
INSERT INTO cje_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Kơyoa ni la drah Kơu, drah pơnuaĭ pơguăn-pơđoàn, hũ tuh tơbiă tơ lô mơnih hũ anĭt toh-luơi glài-sơnoh. ");
INSERT INTO cje_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Kơu đờm sơ̆ng buơl guhã, mư̆ng ni truh hơdơi, Kơu rơŭ 'buh mơñŭm ia ño ni tra, tơ̆l truh tơ hơrơi Kơu rơŭ găm sơ̆ng buơl guhã mơñŭm ia ño bơrhơu lăm lơgăr Ama Kơu.” ");
INSERT INTO cje_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Hơdơi tŭ adoh kơtha adoh sơc̆ih-sri, Yàng Jêsu sơ̆ng du mơnih tui-mơgru tơbiă nau, đì tơ c̆ơ̆ Ôlibe. ");
INSERT INTO cje_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Tŭ nư̆n, Pô đờm sơ̆ng buơl guñu lài: “Mơlăm ni abih buơl guhã rơŭ sơnĕ-lơbuh kơyoa mư̆ng Kơu, yơu hũ pơnuaĭ wă: ‘Kơu rơŭ pờng mơnih glăng abo, Sơ̆ng tơrpuơl abo rơŭ c̆ơrlah-c̆ơrlờp.’ ");
INSERT INTO cje_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Bloh hơdơi tŭ Kơu hơdiŭ wơ̆, Kơu rơŭ truh tơ Galile dơlhơu buơl guhã.” ");
INSERT INTO cje_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pier đờm sơ̆ng Pô: “Yah abih tơgrơ̆ mơnih klà luơi Pô, dơlhă rơŭ 'buh tŭ lơi klà luơi Pô ơu.” ");
INSERT INTO cje_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yàng Jêsu đờm sơ̆ng ñu: “Iơŭ biă, Kơu đờm sơ̆ng hã, lăm mơlăm ni, dơlhơu tŭ mơnŭ kơ-iòk, hã rơŭ klơu amăng đờm kơmlah la hã 'buh thơu Kơu.” ");
INSERT INTO cje_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pier đờm: “Yah lài dơlhă păl mơtai sơ̆ng Pô-Pơto, dơlhă kŭng rơŭ 'buh kơmlah Pô-Pơto ơu.” Abih du mơnih tui-mơgru pơkơ̆n kŭng đờm yơu nư̆n rơi. ");
INSERT INTO cje_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Hơdơi mư̆ng nư̆n, Yàng Jêsu sơ̆ng du mơnih tui-mơgru nau truh sa anih angăn la Getsemane. Pô đờm sơ̆ng buơl guñu: “Dò guh bĕ tơ anih ni, lăm tŭ Kơu nau iơu-lài tơ gah dih.” ");
INSERT INTO cje_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Pô ba Pier sơ̆ng dua aràng anà lơkơi Sebede nau sơ̆ng drơi. Mư̆ng tŭ nư̆n, lăm hơtai-hơtiàn Pô tơma rơu-ri sơ̆ng dơnuh-dơnà biă. ");
INSERT INTO cje_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Pô đờm sơ̆ng buơl guñu: “Bơngă-joa Kơu dơnuh-dơnà tơ̆l truh mơtai; buơl guhã dò bĕ tơ anih ni sơ̆ng mơdơh-kraŭ sơ̆ng Kơu.” ");
INSERT INTO cje_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Nau đoh rơlau sa-sĭt tra mư̆ng anih nư̆n, Pô pơgruă mơta tơ ala lơ̆n sơ̆ng iơu-lài: “Ơ Ama! Yah hũ rơgơi jiơ̆ng, yòng luơi c̆uàn ni klàh mư̆ng Anà! Bloh 'buh tui hơtai Anà, bloh tui hơtai Ama.” ");
INSERT INTO cje_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Pô gài wơ̆ sơ̆ng du mơnih tui-mơgru, 'buh buơl guñu dò đih, nư̆n Pô đờm sơ̆ng Pier: “Buơl guhã 'buh dò mơdơh jiơ̆ng sơ̆ng Kơu sa jơ ơu? ");
INSERT INTO cje_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Mơdơh-kraŭ bĕ sơ̆ng iơu-lài, tô buơl guhã 'buh lĕ tơma lăm pơnuaĭ pơluơ-ơñiai. Hơtai-bơngă nư̆n khiăng biă, bloh rùp-phàp drah-rơlo nư̆n lơmŭn 'buh pràn.” ");
INSERT INTO cje_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Pô tơbiă nau amăng dua wơ̆ sơ̆ng iơu-lài: “Ơ Ama! Yah c̆uàn ni 'buh rơgơi suă klàh jiơ̆ng, bloh Anà păl mơñŭm, nư̆n yòng hơtai Ama hũ jiơ̆ng.” ");
INSERT INTO cje_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Pô gài mơrai sa amăng tra wơ̆ sơ̆ng 'buh du mơnih tui-mơgru sơđaŭ dò đih, kơyoa mơta buơl guñu traŭ yŭp-yŭp bơjơ. ");
INSERT INTO cje_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Kơyoa nư̆n, Pô luơi buơl guñu, nau iơu-lài amăng klơu, sơ̆ng kŭng iơu-lài yơu amăng dơlhơu rơi. ");
INSERT INTO cje_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Bloh nư̆n Pô nau truh sơ̆ng du mơnih tui-mơgru, sơ̆ng đờm: “Tŭ ni bloh buơl guhã sơđaŭ dò đih sơ̆ng dò pơdời gleh? Dih, jơ hũ truh bơjơ, Anà Mơnih rơŭ kŏng jào lăm tơngàn mơnih glài-sơnoh. ");
INSERT INTO cje_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Tơgồ dơ̆ng bĕ, buơl gudrơi păl nau! Dih, mơnih pơblơ̆-dră Kơu truh bơjơ.” ");
INSERT INTO cje_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Tŭ Yàng Jêsu dò đờm, nư̆n Juđa, sa aràng lăm sa-pluh dua aràng mơnih tui-mơgru, nau truh, ba tui sa tơrpuơl lô mơnih apăn đào sơ̆ng gai, kơyoa mư̆ng du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt sơ̆ng du mơnih gơnuăr-tha lăm buơl làng hũ pơđăr truh. ");
INSERT INTO cje_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Dơlhơu nư̆n, Juđa, mơnih pơblơ̆-dră Pô hũ brơi tơ buơl guñu sa nàl: “Mơnih lơi dơlhă c̆ŭm, nư̆n la mơnih nư̆n, buơl guhã mă bĕ.” ");
INSERT INTO cje_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Tŭ nư̆n mư, Juđa truh jĕ Yàng Jêsu sơ̆ng đờm lài: “Siàm drơi Pô-Pơto!” Bloh nư̆n ñu c̆ŭm Pô. ");
INSERT INTO cje_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yàng Jêsu đờm sơ̆ng ñu: “Ơ adơi-ai gơŭ, adơi-ai gơŭ truh tơ anih ni tô ngă hơgĕ, nư̆n kừ ngă bĕ.” Tŭ nư̆n mư buơl mơnih truh jĕ, yơ̆r tơngàn mă Yàng Jêsu. ");
INSERT INTO cje_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Sơ̆ng ni, sa aràng lăm du mơnih dò sơ̆ng Yàng Jêsu suă đào tơbiă, ngă mơnih hơlŭn-hơlă mơnih gơnuăr prŏng apăn-akŏ pơyă phơ̆n duh-dơlbăt, sơmleh kloh sa gah tơnia ñu. ");
INSERT INTO cje_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yàng Jêsu đờm sơ̆ng mơnih nư̆n lài: “Srŏ bĕ đào tơma lăm srŭm. Kơyoa aràng sơi apăn đào nư̆n rơŭ mơtai kơyoa đào. ");
INSERT INTO cje_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Hã sơnư̆ng lài Kơu 'buh rơgơi yòng sơ̆ng Ama Kơu, sơ̆ng Pô rơŭ lăm tơk pơđăr rơlau sa-pluh dua tơrpuơl mơnih gơdrưh truh ơu? ");
INSERT INTO cje_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Bloh yah yơu nư̆n, ngă hơyơu tơbiă iơŭ pơnuaĭ 'Bồn Bơ-àr Sơc̆ih Sri hũ đờm lài, bruă ni păl tơbiă truh yơu nư̆n?” ");
INSERT INTO cje_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Bloh nư̆n, Yàng Jêsu đờm sơ̆ng tơrpuơl mơnih lô: “Kơđa hơgĕ buơl guhã apăn đào sơ̆ng gai truh mă Kơu yơu mă sa aràng mơnih klĕ blơ̆ yơu nư̆n? Yàu hơrơi, Kơu dò guh pơto-pơsài lăm sàng duh-dơlbăt, kơđa hơgĕ buơl guhã 'buh mă Kơu. ");
INSERT INTO cje_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Bloh abih tơgrơ̆ bruă ni păl tơbiă truh, tô pơnuaĭ du mơnih gơnuăr-hwơ̆r hũ đờm dơlhơu lăm 'Bồn Bơ-àr Sơc̆ih-Sri hũ tơbiă iơŭ tơpă.” Tŭ nư̆n, abih du mơnih tui-mơgru luơi Pô bloh đuaĭ dơŭ. ");
INSERT INTO cje_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Du mơnih mă Yàng Jêsu ba Pô truh tơ sàng Kaiphe, mơnih gơnuăr prŏng apăn-akŏ pơyă phơ̆n duh-dơlbăt. Du mơnih gơnuăr-pơto pơnuaĭ adăt-adia sơ̆ng du mơnih gơnuăr-tha dò pơgùm-pơtòm gơŭ lờih tơ anih nư̆n. ");
INSERT INTO cje_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pier nau tui Pô đoh-đoh, truh tơ 'blàng sàng-glăng mơnih gơnuăr prŏng apăn-akŏ pơyă phơ̆n duh-dơlbăt, sơ̆ng tơma gah dơrlăm dò guh sơ̆ng du mơnih lĭng khiă-gàr, tô c̆ơ luĭ-dŭt bruă nư̆n hơyơu lơi. ");
INSERT INTO cje_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Tŭ nư̆n, du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt sơ̆ng abih Tơrpuơl Gơnuăr Apăn-Akŏ Buơl Làng Juđa duah c̆ơ̆ng-grơh lơ̆r tămdră-wơ̆ sơ̆ng Yàng Jêsu, tô hũ rơgơi ngă nìn-glài pơmơtai Pô. ");
INSERT INTO cje_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Bloh buơl guñu duah 'buh hũ pơnuaĭ lơi ơu, yah lài hũ lô mơnih tơgồ dơ̆ng đờm ngă grơh lơ̆r. Hơdơi luĭ, hũ dua aràng mơnih tơgồ dơ̆ng, ");
INSERT INTO cje_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","đờm yă lài: “Mơnih ni hũ đờm: ‘Kơu hũ rơgơi ngă pơjơrlơh sàng duh-dơlbăt Yàng Pô Lơngì, bloh nư̆n bơ̆ pơdơ̆ng wơ̆ lăm klơu hơrơi.’ ” ");
INSERT INTO cje_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Mơnih gơnuăr prŏng apăn-akŏ pơyă phơ̆n duh-dơlbăt tơgồ dơ̆ng sơ̆ng đờm: “Hã 'buh đờm sơđồ wơ̆ pơnuaĭ du mơnih ni đờm yă hã ơu?” ");
INSERT INTO cje_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Bloh Yàng Jêsu sơđaŭ dò kơđơ̆ng. Mơnih gơnuăr prŏng apăn-akŏ pơyă phơ̆n duh-dơlbăt đờm wơ̆ sơ̆ng Pô lài: “Kơu pơkơŭ hã tơpah-sri tơ anaŭ Yàng Pô Lơngì hơdiŭ rài pơdò rài, păl đờm tơ buơl gukơu thơu: Hã hũ iơŭ la Pô Krist, Anà Yàng Pô Lơngì ơu?” ");
INSERT INTO cje_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yàng Jêsu đờm: “Iơŭ yơu hã hũ đờm. Rơlau wơ̆, Kơu đờm tơ buơl guhã thơu, mư̆ng ni, buơl guhã rơŭ 'buh Anà Mơnih dò guh tơ gah hơnuă Pô Gơnăp-Gơnuăr, sơ̆ng dò tơ ngŏ hwăl lơngì bloh truh.” ");
INSERT INTO cje_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Tŭ nư̆n, mơnih gơnuăr prŏng apăn-akŏ pơyă phơ̆n duh-dơlbăt hĕt ào drơi sơ̆ng đờm: “Ñu hũ đờm sơk-sơrbĭl khĭn-dơmĭn! Buơl gudrơi c̆àng hơgĕ mơnih ngă grơh tra? Buơl kơi pơrpa mơhư̆ pơnuaĭ ñu đờm sơk-sơrbĭl khĭn-dơmĭn truh Yàng Pô Lơngì. Buơl kơi sơnư̆ng hơyơu lơi?” ");
INSERT INTO cje_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Buơl guñu đờm sơđồ: “Ñu iơŭ păl mơtai!” ");
INSERT INTO cje_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Bloh nư̆n buơl guñu c̆uh ia bơbah lăm 'bò mơta Pô sơ̆ng pờng ngă Pô. Hũ du mơnih pah Pô, ");
INSERT INTO cje_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","sơ̆ng đờm: “Ơ Pô Krist, c̆ơ đờm hwơ̆r bĕ brơi buơl kơu thơu: Aràng sơi la mơnih ngă hã?” ");
INSERT INTO cje_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Tŭ nư̆n, Pier sơđaŭ dò guh tơ agàh 'blàng. Hũ sa aràng mơnih hơlŭn-hơlă kơmơi truh jĕ, bloh đờm sơ̆ng ñu lài: “Hã kŭng la mơnih dò sơ̆ng Jêsu, mơnih Galile.” ");
INSERT INTO cje_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Bloh Pier đờm kơmlah mư tơ anaŭ tơgrơ̆ mơnih lài: “Kơu 'buh thơu hã đờm hơgĕ!” ");
INSERT INTO cje_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Tŭ tơbiă truh tơ agàh bơh 'băng prŏng, sa aràng mơnih kơmơi hơlŭn-hơlă pơkơ̆n 'buh Pier, nư̆n đờm sơ̆ng du mơnih dò dơ̆ng jĕ tơ anih nư̆n: “Mơnih ni kŭng dò sơ̆ng Jêsu, mơnih Nasaret.” ");
INSERT INTO cje_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pier kơmlah sa amăng tra wơ̆, sơ̆ng tơpah-sri đờm: “Kơu 'buh thơu mơnih nư̆n!” ");
INSERT INTO cje_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Sa-sĭt tra wơ̆, du mơnih dò dơ̆ng jĕ tơ anih nư̆n đờm sơ̆ng Pier lài: “Iơŭ biă bơjơ, hã kŭng la mơnih lăm tơrpuơl buơl nư̆n rơi. Kừ mơhư̆ săp hã đờm la thơu mư!” ");
INSERT INTO cje_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Bloh Pier pơc̆ĕ-pơtrah sơ̆ng tơpah-sri đờm lài: “Kơu 'buh thơu mơnih nư̆n.” Tŭ nư̆n mư, hũ săp mơnŭ kơ-iòk. ");
INSERT INTO cje_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Pier sơdơ̆r wơ̆ pơnuaĭ Yàng Jêsu hũ đờm: “Dơlhơu tŭ mơnŭ kơ-iòk, hã rơŭ klơu amăng đờm kơmlah la hã 'buh thơu Kơu.” Nư̆n Pier tơbiă nau sơ̆ng hia-c̆ŏ pơđì-pơđoa biă. ");
INSERT INTO cje_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Truh ờm pơgi, abih du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt sơ̆ng du mơnih gơnuăr-tha lăm buơl làng pơgùm-pơtòm sơ̆ng gơŭ, duah bơyai pơnuaĭ tămdră wơ̆ sơ̆ng Yàng Jêsu, tô pơmơtai Pô. ");
INSERT INTO cje_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Buơl guñu c̆aŭ Pô wơ̆, bloh nư̆n ba jào tơ Pilat, la mơnih kwăng apăn-akŏ du c̆àr lăm lơgăr. ");
INSERT INTO cje_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Tŭ nư̆n, Juđa, la mơnih pơblơ̆-dră Pô, 'buh Pô kơđòng aràng ngă nìn-glài, nư̆n ñu mơbai prah-luơi glài-sơnoh, sơ̆ng apăn klơu pluh kleh priă bơ-yàr wơ̆ tơ du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt sơ̆ng du mơnih gơnuăr-tha, ");
INSERT INTO cje_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","bloh đờm lài: “Dơlhă hũ ngă glài kơyoa jào drah mơnih 'buh hũ glài!” Bloh buơl guñu đờm: “Bruă nư̆n hũ tơwă-kơđòng hơgĕ truh buơl dơlhă? Nư̆n la bruă hã.” ");
INSERT INTO cje_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Juđa prah priă lăm sàng duh-dơlbăt, bloh nư̆n tơbiă nau yuăl tơkuai. ");
INSERT INTO cje_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Bloh du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt duơ̆n du kleh priă nư̆n sơ̆ng đờm: “Khà priă ni 'buh rơgơi daŭ lăm anih pioh phơ̆n-priă sàng duh-dơlbăt jiơ̆ng, kơyoa nư̆n la priă drah.” ");
INSERT INTO cje_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Hơdơi tŭ tămbơyai sơ̆ng gơŭ, buơl guñu angui khà priă nư̆n blơi hơma “Mơnih khờh angui lơ̆n kơliă” tô ngă anih pioh dơ̆r du mơnih thuai c̆rih. ");
INSERT INTO cje_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Kơyoa nư̆n bloh 'blàng hơma nư̆n hũ angăn la “Hơma Drah” tơ̆l truh tơ hơrơi ni. ");
INSERT INTO cje_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Bruă tơbiă truh iơŭ tơpă yơu pơnuaĭ mơnih gơnuăr-hwơ̆r Jeremi hũ đờm: “Buơl guñu mă klơu pluh kleh priă, la khà priă bloh anà-tơc̆o Israel hũ ngă-nìn tơ Pô, ");
INSERT INTO cje_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","sơ̆ng mă priă nư̆n blơi 'blàng hơma ‘mơnih khờh angui lơ̆n kơliă,’ yơu pơnuaĭ Yàng hũ đờm pơđăr dơlhă.” ");
INSERT INTO cje_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Tŭ nư̆n, Yàng Jêsu dò dơ̆ng tơ anaŭ kwăng apăn-akŏ du c̆àr lăm lơgăr; mơnih kwăng tơnia: “Hã hũ iơŭ la pơtau buơl làng Juđa ơu?” Yàng Jêsu đờm: “Biă yơu pơnuaĭ đờm.” ");
INSERT INTO cje_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Bloh tŭ du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt sơ̆ng du mơnih gơnuăr-tha đờm yă Pô, Pô 'buh đờm sơđồ wơ̆ pơnuaĭ lơi. ");
INSERT INTO cje_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pilat tơnia Pô: “Buơl guñu hũ lô pơnuaĭ ngă grơh yă hã, hã 'buh mơhư̆ truh ơu?” ");
INSERT INTO cje_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Bloh Yàng Jêsu 'buh đờm sơđồ wơ̆ sa pơnuaĭ lơi, ngă tơ kwăng apăn-akŏ du c̆àr lăm lơgăr mă ngă krơi-takơtuă biă. ");
INSERT INTO cje_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Lăm yàu pơnuaĭ pơjŭm 'bơ̆ng Nau-Găn, mơnih kwăng apăn-akŏ du c̆àr lăm lơgăr jiăng hũ adăt-lơđăp toh tơbiă tơ buơl làng sa aràng mơnih glài kŏng jàm, tui hơtai buơl guñu khiăng. ");
INSERT INTO cje_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Tŭ nư̆n, hũ sa aràng mơnih glài kŏng-jàm tiơ̆ng-dơnài biă, angăn la 'Baraba. ");
INSERT INTO cje_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Kơyoa nư̆n, hơdơi tŭ buơl làng pơgùm-pơtòm wơ̆, Pilat đờm sơ̆ng buơl guñu: “Buơl guhã khiăng kơu toh tơbiă mơnih lơi? 'Baraba halài Jêsu, angăn la Krist?” ");
INSERT INTO cje_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Kơyoa Pilat thơu, mĭn kơyoa mư̆ng hơtai-hơtiàn oàn-mơbai bloh buơl guñu jào Pô tơ ñu. ");
INSERT INTO cje_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Lăm tŭ Pilat dò guh c̆ahrơña, nư̆n sơdiŭ ñu pơđăr mơnih truh đờm sơ̆ng ñu lài: “Yòng juơi tŭp truh mơnih rĭng-tơpă nư̆n. Kơyoa hơrơi ni, lăm pơnuaĭ lơpơi, dơlhă hũ pơđì-pơđoa gleh-glăr lô kơyoa mư̆ng mơnih nư̆n.” ");
INSERT INTO cje_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Bloh du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt sơ̆ng du mơnih gơnuăr-tha pơsŭt-pơđăr buơl làng yòng toh tơbiă 'Baraba sơ̆ng pơmơtai Yàng Jêsu. ");
INSERT INTO cje_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Kwăng apăn-akŏ du c̆àr lăm lơgăr tơnia buơl guñu: “Lăm dua aràng mơnih ni, buơl guhã khiăng kơu toh tơbiă aràng sơi?” Buơl guñu đờm sơđồ: “'Baraba.” ");
INSERT INTO cje_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilat đờm: “Yơu nư̆n kơu păl c̆ahrơña hơyơu lơi sơ̆ng Jêsu angăn la Krist?” Abih buơl guñu sơgơŭ đờm: “Pơ̆ng bĕ ñu tơ kơyơu pơkăl!” ");
INSERT INTO cje_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Kwăng apăn-akŏ du c̆àr lăm lơgăr tơnia: “Mơnih ni hũ ngă pơnuaĭ mơsak-jơhà hơgĕ?” Bloh buơl guñu 'brŏ kơmrào driau prŏng rơlau wơ̆: “Pơ̆ng bĕ ñu tơ kơyơu pơkăl!” ");
INSERT INTO cje_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Kơyoa nư̆n, tŭ Pilat 'buh drơi 'buh rơgơi ngă hơgĕ jiơ̆ng, sơ̆ng tơrpuơl mơnih lô hũ rơgơi tơbiă jiơ̆ng klùk-klờk rơlau wơ̆, nư̆n mă ia rào tơngàn tơ anaŭ buơl làng, bloh đờm: “Kơu 'buh hũ glài mư̆ng drah mơnih ni; nư̆n la bruă buơl guhã, mơti buơl guhã.” ");
INSERT INTO cje_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Abih tơrpuơl buơl làng đờm sơđồ lài: “Yòng drah ñu tuh wơ̆ tơ akŏ buơl dơlhă sơ̆ng anà-tơc̆o buơl dơlhă!” ");
INSERT INTO cje_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Yơu nư̆n, Pilat toh pơtơbiă 'Baraba tơ buơl guñu. Hơdơi tŭ pơđăr gơlih pờng Yàng Jêsu, Pilat jào Pô tơ buơl guñu tô ba nau pơ̆ng tơ kơyơu pơkăl. ");
INSERT INTO cje_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Hơdơi mư̆ng nư̆n, buơl lĭng kwăng apăn-akŏ du c̆àr lăm lơgăr ba Yàng Jêsu tơma lăm anih sàng kwăng ngă bruă, bloh nư̆n pơgùm-pơtòm abih tơrpuơl lĭng gơrwàng tòmdăr Pô. ");
INSERT INTO cje_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Guñu yờh ào Pô, bloh nư̆n pơyùp tơ Pô sa blah ào mơr-yah, ");
INSERT INTO cje_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","pă sa boh dơwàng sơ̆ng druơi bloh pơtruă tơ akŏ Pô. Guñu kŭng mă sa bĕ gai bơrbo daŭ lăm tơngàn gah hơnuă Pô, bloh nư̆n c̆ĕ-khoai tơ anaŭ Pô sơ̆ng đờm klau-pơtăt lài: “Khoai Pơtau buơl làng Juđa!” ");
INSERT INTO cje_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Guñu kơc̆uh ia bơbah lăm Pô, mă gai bơrbo pờng tơ akŏ Pô. ");
INSERT INTO cje_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Hơdơi tŭ klau-pơtăt Pô bơjơ, guñu yờh ào mơr-yah tơbiă sơ̆ng pơc̆ù ào Pô tơ Pô wơ̆, bloh nư̆n ba Pô nau tô pơ̆ng tơ kơyơu pơkăl. ");
INSERT INTO cje_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Tŭ tơbiă nau, guñu păp sa aràng mơnih Siren, angăn la Simôn. Guñu mă mơnih ni glăm kơyơu pơkăl Yàng Jêsu. ");
INSERT INTO cje_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Tŭ truh tơ sa anih angăn la Gôgôtha, mơblàng la Anih Brò-Akŏ, ");
INSERT INTO cje_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","guñu brơi Pô mơñŭm tơpai klài sơ̆ng ia jrào phì. Pô lơ-yah soh bloh 'buh mơñŭm. ");
INSERT INTO cje_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Hơdơi tŭ pơ̆ng Pô lăm kơyơu pơkăl bơjơ, guñu suă-khà tô pơrpha gơŭ khăn-ào Pô. ");
INSERT INTO cje_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Bloh nư̆n guñu dò guh tơ anih nư̆n tô kraŭ-khiă Pô. ");
INSERT INTO cje_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Gah ngŏ akŏ Pô, guñu pơ̆ng sa blơ kơmàn, wă mư̆ng glài Pô lài: “Ni La Jêsu, Pơtau Buơl Làng Juđa.” ");
INSERT INTO cje_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Tŭ nư̆n, hũ dua aràng mơnih klĕ blơ̆ kŭng kơđòng pơ̆ng tơ kơyơu pơkăl sơ̆ng Pô rơi, sa aràng lăm kơyơu pơkăl gah hơnuă, sơ̆ng sa aràng lăm kơyơu pơkăl gah ơñiau. ");
INSERT INTO cje_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Du mơnih nau mơrai găn nư̆n klau pơtăt Pô, rơñah akŏ, ");
INSERT INTO cje_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","bloh đờm lài: “Hã la mơnih hũ rơgơi pơjơrlơh sàng duh-dơlbăt sơ̆ng bơ̆ pơdơ̆ng wơ̆ lăm klơu hơrơi, c̆ơ dŏng bĕ rùp-phŭn drơi! Yah hã la Anà Yàng Pô Lơngì, c̆ơ trŭn bĕ mư̆ng kơyơu pơkăl!” ");
INSERT INTO cje_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt, du mơnih gơnuăr-pơto pơnuaĭ adăt-adia sơ̆ng du mơnih gơnuăr-tha kŭng klau pơtăt Pô lài: ");
INSERT INTO cje_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ñu hũ dŏng mơnih pơkơ̆n jiơ̆ng bloh 'buh rơgơi dŏng rùp-phŭn drơi. Ñu đờm ñu la pơtau buơl làng Israel! Tŭ ni, yah ñu trŭn klàh mư̆ng kơyơu pơkăl jiơ̆ng, nư̆n buơl gudrơi rơŭ păng-tui mư. ");
INSERT INTO cje_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ñu păng-gơnừm Yàng Pô Lơngì. Yah Yàng Pô Lơngì rơnăm ñu, nư̆n tŭ ni Pô păl dŏng ñu, kơyoa ñu hũ đờm lài: ‘Kơu la Anà Yàng Pô Lơngì!’ ” ");
INSERT INTO cje_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Dua aràng mơnih klĕ blơ̆ kơđòng pơ̆ng lăm du kơyơu pơkăl jĕ sơ̆ng Pô kŭng đờm klau pơtăt Pô yơu nư̆n rơi. ");
INSERT INTO cje_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Mư̆ng sa-pluh dua jơ hơrơi dơ̆ng truh tơ klơu jơ diơŭ, abih tơgrơ̆ anih tơbiă jiơ̆ng kơnăm-mơsrư̆ c̆ik-c̆òk. ");
INSERT INTO cje_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Pơgăp klơu jơ diơŭ, Yàng Jêsu iơu prŏng săp lài: “Eli, Eli, lama sabaktani!” Kơtha mơblàng la: “Ơ Yàng Pô Lơngì dơlhă! Ơ Yàng Pô Lơngì dơlhă! Kơđa hơgĕ Pô klà luơi dơlhă?” ");
INSERT INTO cje_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Mơhư̆ yơu nư̆n, du mơnih dò dơ̆ng jĕ tơ anih nư̆n đờm: “Ñu iơu Eli.” ");
INSERT INTO cje_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Sa aràng lăm tơrpuơl buơl guñu tơmbah-tơmbàn đuaĭ nau mă sa kleh phơ̆n kơsồp, ơñrŭ baŭ ia mơsăm, akă tơ hơjŭng gai bơrbo, sơ̆ng pơyơ̆r brơi tơ Pô mơñŭm. ");
INSERT INTO cje_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Bloh du mơnih pơkơ̆n nư̆n đờm: “Kừ luơi yơu nư̆n, c̆ơ Eli hũ truh dŏng ñu ơu.” ");
INSERT INTO cje_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yàng Jêsu iơu prŏng săp sa amăng tra wơ̆, bloh nư̆n kloh suàn. ");
INSERT INTO cje_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Sơ̆ng dih, khăn dơrnìng gah dơrlăm sàng duh-dơlbăt tơrhĕt jiơ̆ng dua mư̆ng ngŏ trŭn tơ ala, tơnah rơya tơtuơ̆n-mơgơi, pơtơu prŏng tơrlah pơc̆ah, ");
INSERT INTO cje_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","du kŭt atơu pơh tơbiă, sơ̆ng lô mơnih sơc̆ih-sri mơtai bơjơ hũ hơdiŭ wơ̆. ");
INSERT INTO cje_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Hơdơi tŭ Yàng Jêsu hơdiŭ wơ̆, du mơnih sơc̆ih-sri nư̆n tơbiă mư̆ng kŭt atơu, nau tơma lăm plơi-prŏng sơc̆ih-sri, sơ̆ng tơbiă pơ'buh tơ lô mơnih 'buh. ");
INSERT INTO cje_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Tŭ mơnih apăn-akŏ sa rơtùh lĭng găm sơ̆ng buơl lĭng kraŭ-khiă Yàng Jêsu, 'buh tơnah rơya tơtuơ̆n-mơgơi sơ̆ng tơgrơ̆ bruă hũ tơbiă truh, nư̆n huơĭ-kơđa biă-biài sơ̆ng đờm: “Mơnih ni iơŭ tơpă biă la anà Yàng Pô Lơngì.” ");
INSERT INTO cje_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Tơ anih nư̆n, kŭng hũ lô mơnih kơmơi dò dơ̆ng c̆ơ mư̆ng atàh. Buơl guñu la du mơnih hũ nau tui Yàng Jêsu mư̆ng c̆àr Galile, tô duh bruă Pô. ");
INSERT INTO cje_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Lăm du mơnih nư̆n hũ Mari Mađơlen, Mari ame Jakơ sơ̆ng Jôsep, sơ̆ng ame dua aràng anà lơkơi Sebeđe. ");
INSERT INTO cje_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Truh glai diơŭ, hũ sa aràng mơnih mơda, dò tơ plơi-prŏng Arimathe, angăn la Jôsep, kŭng la sa aràng mơnih tui-mơgru Yàng Jêsu. ");
INSERT INTO cje_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Jôsep truh tòm Pilat tô yòng mă rùp atơu Yàng Jêsu. Pilat pơđăr jào tơ ñu. ");
INSERT INTO cje_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Jôsep đồ-mă rùp atơu Pô sơ̆ng pơpò lăm bơ-yài goh pơtih, ");
INSERT INTO cje_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","bloh nư̆n daŭ lăm kŭt atơu bơrhơu bloh ñu hũ pơđăr phàt pioh krơi tơ drơi lăm tơli pơtơu. Ñu kŭng pơrlơ̆ng sa boh pơtơu prŏng kơdrơ̆ bơh 'băng kŭt wơ̆, bloh nư̆n nau. ");
INSERT INTO cje_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mari Mađơlen sơ̆ng Mari pơkơ̆n hũ mơta tơ anih nư̆n, dò guh găn tơ anaŭ sơ̆ng kŭt atơu. ");
INSERT INTO cje_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Hơrơi hơdơi, nư̆n la hơdơi Hơrơi-Rơc̆ăng tơ pơnuaĭ pơjŭm 'bơ̆ng, du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt găm sơ̆ng du mơnih Pharisi, ba gơŭ truh tòm Pilat, ");
INSERT INTO cje_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","sơ̆ng đờm: “Ơ pô, buơl dơlhă sơdơ̆r mơnih lơ̆r pơ̆ng-gơla ni tŭ dò hơdiŭ hũ đờm: ‘Hơdơi klơu hơrơi Kơu rơŭ hơdiŭ wơ̆.’ ");
INSERT INTO cje_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Kơyoa nư̆n, yòng kwăng pơđăr mơnih kraŭ-khiă kŭt atơu nĭ-nùn tơ̆l truh tơ hơrơi klơu, huơĭ glai mơlăm du mơnih tui-mơgru ñu truh klĕ mă rùp atơu bloh nư̆n đờm sơ̆ng buơl làng lài ‘Pô hũ mư̆ng mơnih mơtai hơdiŭ wơ̆.’ Sơ̆ng yơu nư̆n, pơnuaĭ lơ̆r pơ̆ng-gơla hơdơi ni rơŭ jơhà rơlau tơ pơnuaĭ lơ̆r pơ̆ng-gơla dơlhơu wơ̆.” ");
INSERT INTO cje_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilat đờm sơ̆ng buơl guñu: “Buơl guhã hũ lĭng kraŭ-khiă, nau bĕ kraŭ-khiă kŭt atơu nĭ-nùn tui hơtai buơl guhã.” ");
INSERT INTO cje_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Yơu nư̆n, buơl guñu nau, tơ̆m 'băng-kì tơ boh pơtơu kơdrơ̆ bơh 'băng kŭt, sơ̆ng c̆ĕ buơl lĭng kraŭ-khiă nĭ-nùn biă. ");
INSERT INTO cje_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Hơdơi hơrơi sa'bat, la hơrơi c̆ơmrừp lăm sa tơjuh, tŭ sơđaŭ dò rìng-rìng ờm, Mari Mađơlen sơ̆ng Mari pơkơ̆n truh rơwăng c̆ơ kŭt. ");
INSERT INTO cje_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Mơre-mơro hũ pơnuaĭ tơtuơ̆n-mơgơi lơ̆n tơnah pràn sơtăng biă; kơyoa sa aràng mơnih gơdrưh Yàng mư̆ng lơngì trŭn, truh plơ̆ boh pơtơu tơbiă, sơ̆ng dò guh tơ ngŏ. ");
INSERT INTO cje_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","'Bò mơta mơnih gơdrưh sơrdah mơhiơ̆ yơu c̆ă-kơrla, sơ̆ng ào pơtih yơu pơlia. ");
INSERT INTO cje_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Du mơnih lĭng kraŭ-khiă huơĭ-kơđa biă, kơtơ̆ drơi sơ̆ng tơbiă jiơ̆ng yơu mơnih mơtai. ");
INSERT INTO cje_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Bloh mơnih gơdrưh đờm sơ̆ng du mơnih kơmơi nư̆n lài: “Juơi huơĭ, kơyoa kơu thơu buơl guhã duah Yàng Jêsu, la Pô hũ kŏng pơ̆ng tơ kơyơu pơkăl. ");
INSERT INTO cje_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Pô 'buh dò tơ anih ni ơu, Pô hơdiŭ wơ̆ bơjơ, yơu pơnuaĭ Pô hũ đờm. Truh bĕ c̆ơ anih Pô hũ đih. ");
INSERT INTO cje_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Sơ̆ng nau sơmăr bĕ, đờm tơ du mơnih tui-mơgru Pô thơu lài Pô hũ mư̆ng mơnih mơtai hơdiŭ wơ̆ bơjơ. Ni, Pô nau tơ c̆àr Galile dơlhơu buơl guhã; tơ anih nư̆n buơl guhã rơŭ 'buh Pô. Nư̆n, kơu hũ đờm tơ buơl guhã bơjơ.” ");
INSERT INTO cje_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Dua aràng mơnih kơmơi nư̆n tơmbah-tơmbàn tơbiă mư̆ng kŭt, găm huơĭ găm sờh-sài biă, đuaĭ nau akhàn pơthơu tơ du mơnih tui-mơgru Pô. ");
INSERT INTO cje_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ni, Yàng Jêsu tòm buơl guñu sơ̆ng đờm: “Siàm drơi buơl anà!” Buơl guñu truh jĕ, kwăr tơkai Pô, sơ̆ng c̆ĕ-dơlbăt Pô. ");
INSERT INTO cje_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yàng Jêsu đờm sơ̆ng buơl guñu: “Juơi huơĭ! Nau đờm bĕ tơ du adơi-ai Kơu thơu, tô buơl guñu truh tơ Galile, tơ anih nư̆n buơl guñu rơŭ 'buh Kơu.” ");
INSERT INTO cje_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Lăm tŭ dua aràng mơnih kơmơi nư̆n nau jơlàn, nư̆n du mơnih lĭng kraŭ-khiă kŭt tơma lăm plơi-prŏng, đờm akhàn wơ̆ sơ̆ng du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt thơu mư̆ng abih tơgrơ̆ bruă hũ tơbiă truh. ");
INSERT INTO cje_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Hơdơi tŭ du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt sơ̆ng du mơnih gơnuăr-tha hũ pơtòm tămbơyai sơ̆ng gơŭ, buơl guñu brơi tơ du mơnih lĭng lô priă, ");
INSERT INTO cje_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","sơ̆ng kơkơi pơđăr: “Buơl guhã păl đờm: ‘Glai mơlăm, lăm tŭ buơl dơlhă dò đih, du mơnih tui-mơgru ñu hũ truh sơ̆ng klĕ mă rùp-atơu ñu nau.’ ");
INSERT INTO cje_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Yah bruă ni mơhư̆ truh tơnia kwăng apăn-akŏ du c̆àr lăm lơgăr, nư̆n buơl gudrơi rơŭ duah pơnuaĭ đờm mơblàng sơ̆ng kwăng, buơl guhã 'buh păl huơĭ kơ-ù pơnuaĭ hơgĕ.” ");
INSERT INTO cje_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Yơu nư̆n, du mơnih lĭng đồ-mă priă sơ̆ng ngă tui iơŭ yơu pơnuaĭ hũ kơkơi pơđăr. Pơnuaĭ nư̆n hũ đờm pơtiơ̆ng lăm buơl làng Juđa tơ̆l truh tơ hơrơi ni. ");
INSERT INTO cje_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Sa-pluh sa aràng mơnih tui-mơgru nau truh tơ Galile, đì tơ ngŏ c̆ơ̆ bloh Yàng Jêsu hũ pơto tơ buơl guñu. ");
INSERT INTO cje_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Tŭ 'buh Pô, buơl guñu c̆ĕ-khoai Pô; bloh hũ sa-sĭt mơnih sơđaŭ dò dră-drơ̆ng, 'buh sơnư̆ng lài nư̆n biă la Yàng Jêsu. ");
INSERT INTO cje_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yàng Jêsu truh jĕ, đờm sơ̆ng du mơnih tui-mơgru: “Abih tơgrơ̆ gơnuăr tơ ngŏ lơngì sơ̆ng tơ ala lơ̆n hũ jào tơ Kơu. ");
INSERT INTO cje_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Yơu nư̆n, nau bĕ sơ̆ng ngă tơ abih tơgrơ̆ buơl làng tơbiă jiơ̆ng mơnih tui-mơgru Kơu; mă bĕ angăn Pô Yàng Ama, Pô Yàng Anà, sơ̆ng Yàng Bơngă Sơc̆ih-Sri bloh ngă 'baptem tơ buơl guñu, ");
INSERT INTO cje_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","sơ̆ng pơto buơl guñu păng-rơmiă ngă tui abih tơgrơ̆ pơnuaĭ Kơu hũ pơto tơ buơl guhã. Sơ̆ng ni, Kơu jiăng dò găm sơ̆ng buơl guhã tơ̆l truh tơ luĭ-dŭt rài.”");
INSERT INTO cje_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Mư̆ng c̆ơmrừp Pơnuaĭ-Siàm Yàng Jêsu Krist, Anà Yàng Pô Lơngì. ");
INSERT INTO cje_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Yơu hũ wă lăm bơ-àr mơnih gơnuăr-hwơ̆r Êsai lài: “Ni, Kơu pơđăr mơnih Kơu nau dơlhơu tơ anaŭ Anà, Mơnih nư̆n rơŭ waìh jơlàn tơ Anà. ");
INSERT INTO cje_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Hũ săp mơnih iơu driau lăm 'blàng-jơhua lài: Waìh bĕ jơlàn tơ Yàng, Ngă pơtơpă-pơrĭng du jơlàn tìt tơ Pô.” ");
INSERT INTO cje_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Jăng 'Baptis hũ truh lăm 'blàng-jơhua, găm pơto-akhàn găm ngă 'baptem mư̆ng pơnuaĭ mơbai prah-luơi glài-sơnoh tô hũ anĭt toh-luơi glài-sơnoh. ");
INSERT INTO cje_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Abih buơl làng dò lăm c̆àr Juđe sơ̆ng plơi-prŏng Jerusalem ba gơŭ truh sơ̆ng ñu. Buơl guñu akhàn-tơbiă abih glài-sơnoh drơi, sơ̆ng Jăng 'Baptis ngă 'baptem tơ buơl guñu lăm ia-sơdờng Jôđăn. ");
INSERT INTO cje_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Tŭ nư̆n, Jăng 'Baptis c̆ù ào sơ̆ng blơu lakđa, akă tơlơi kơ-iăng sơ̆ng kơlì, 'bơ̆ng kơtòk sơ̆ng ia hơnìng glai. ");
INSERT INTO cje_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ñu pơto-akhàn lài: “Hũ sa Pô gơnăp-gơnuăr rơlau dơlhă, truh hơdơi dơlhă, dơlhă 'buh iơŭ păl kù tơ ala tơleh tơlơi kơlì-juă tơ Pô. ");
INSERT INTO cje_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Dơlhă ngă 'baptem tơ buơl adơi-ai sơ̆ng ia, bloh Pô rơŭ ngă 'baptem tơ buơl adơi-ai sơ̆ng Yàng Bơngă Sơc̆ih-Sri.” ");
INSERT INTO cje_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Lăm du hơrơi nư̆n, Yàng Jêsu mư̆ng plơi-prŏng Nasaret c̆àr Galile truh, sơ̆ng Jăng 'Baptis ngă 'baptem tơ Pô lăm ia-sơdờng Jôđăn. ");
INSERT INTO cje_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Tŭ pơrpa đì tơbiă mư̆ng ia, Pô 'buh du tăl lơngì pơh tơbiă, sơ̆ng Bơngă Sơc̆ih-Sri mơhiơ̆ yơu c̆ĭm kơtrơu trŭn đơ̆m tơ ngŏ Pô, ");
INSERT INTO cje_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","sơ̆ng hũ săp mư̆ng ngŏ lơngì đờm lài: “Anà la Anà uơ̆n-rơnăm Kơu, siàm hơtai Kơu lăm abih tơgrơ̆ mơta.” ");
INSERT INTO cje_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Tŭ nư̆n mư, Bơngă Sơc̆ih-Sri ba Pô tơma lăm anih 'blàng-jơhua. ");
INSERT INTO cje_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Pô dò lăm anih 'blàng-jơhua pà pluh hơrơi, kơđòng Satăn pơluơ-ơñiai, hơdiŭ tơkrah du jơi-phơ̆n pà gah tơkai lăm glai, sơ̆ng hũ du mơnih gơdrưh duh bruă Pô. ");
INSERT INTO cje_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Hơdơi tŭ Jăng 'Baptis kơđòng jàm-krơ̆, Yàng Jêsu truh tơ c̆àr Galile, pơto-akhàn mư̆ng Pơnuaĭ-Siàm Yàng Pô Lơngì. ");
INSERT INTO cje_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Pô đờm: “Tŭ-hơrơi hũ tơ̆l bơjơ, lơgăr Yàng Pô Lơngì hũ truh jĕ bơjơ, buơl guhã păl mơbai prah-luơi glài-sơnoh bĕ sơ̆ng păng-tui jơlàn Pơnuaĭ-Siàm.” ");
INSERT INTO cje_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Tŭ nau tui rò gah ia-tơsì Galile, Yàng Jêsu 'buh dua aràng adơi-ai Simôn sơ̆ng Andre, dò dăng sơñuăl lăm ia-tơsì, kơyoa bruă ngă phŭn buơl guñu la mơnih mă akàn. ");
INSERT INTO cje_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yàng Jêsu đờm sơ̆ng buơl guñu: “Tui bĕ Kơu, Kơu rơŭ ngă tơ buơl guhã tơbiă jiơ̆ng du mơnih dăng sơñuăl mơnih yơu dăng sơñuăl mă akàn.” ");
INSERT INTO cje_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Tŭ nư̆n mư, buơl guñu luơi jàl-sơñuăl bloh tui Pô. ");
INSERT INTO cje_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Nau đoh atàh rơlau sa-sĭt tra mư̆ng anih nư̆n, Pô 'buh Jakơ, anà Sebede, sơ̆ng adơi ñu la Jăng, dò srồt sơñuăl lăm gơlài. ");
INSERT INTO cje_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Pô iơu buơl guñu; buơl guñu luơi ama drơi la Sebede dò wơ̆ lăm gơlài sơ̆ng du mơnih ngă tồ-apah, bloh nau tui Pô. ");
INSERT INTO cje_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yàng Jêsu sơ̆ng du mơnih tui-mơgru Pô tơma lăm plơi-prŏng Kapenaum. Iơŭ tơ hơrơi sa'bat, Pô tơma lăm sàng pơtòm sơ̆ng pơto-mơblàng. ");
INSERT INTO cje_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Abih tơgrơ̆ mơnih mă ngă krơi-takơtuă biă mư̆ng pơnuaĭ Pô pơto, kơyoa Pô pơto hũ gơnăp-gơnuăr, bloh 'buh iơŭ yơu du mơnih gơnuăr-pơto pơnuaĭ adăt-adia pơto. ");
INSERT INTO cje_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Kŭng tŭ nư̆n, lăm sàng pơtòm hũ sa aràng mơnih kơđòng kơmlài sơŭ-sơnoh ngă, ");
INSERT INTO cje_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","mơnih nư̆n iơu driau lài: “Ơ Jêsu mơnih Nasaret, buơl dơlhă sơ̆ng Pô hũ bruă hơgĕ rơi? Pô truh tô pơluĭ-pơlơhiă buơl dơlhă? Dơlhă thơu Pô la aràng sơi, Pô la Pô Sơc̆ih-Sri Yàng Pô Lơngì.” ");
INSERT INTO cje_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Bloh Yàng Jêsu puaĭ jrăm ñu: “Dò kơđơ̆ng bĕ, sơ̆ng tơbiă klàh mư̆ng mơnih ni!” ");
INSERT INTO cje_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Kơmlài sơŭ-sơnoh sơboh khăng mơnih nư̆n, kơmrào sa săp prŏng, sơ̆ng tơbiă klàh mư̆ng mơnih nư̆n. ");
INSERT INTO cje_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Abih tơgrơ̆ mơnih mă ngă c̆rih-takơtuă biă sơ̆ng đờm tơnia gơŭ: “Pơnuaĭ hơgĕ ni? Sa pơnuaĭ pơto-pơsài bơrhơu baŭ gơnăp-gơnuăr! Mơnih ni mă gơnăp-gơnuăr đờm pơđăr du kơmlài sơŭ-sơnoh, sơ̆ng guñu kŭng păl păng bơbah ngă tui rơi.” ");
INSERT INTO cje_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Pơnuaĭ tiơ̆ng-dơnài mư̆ng angăn Yàng Jêsu tŭ nư̆n mư hũ đờm tiơ̆ng tơbiă lăm abih c̆àr tòmdăr Galile. ");
INSERT INTO cje_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Krah pơrpa tơbiă mư̆ng sàng pơtòm, Yàng Jêsu găm sơ̆ng Jakơ, Jăng, nau truh tơ sàng Simôn sơ̆ng Andre. ");
INSERT INTO cje_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Tŭ nư̆n ame-tămhã Simôn kơđòng lơ-ơ̆n pơrmă-mơrềt, dò đih lăm c̆ơnừng. Du mơnih tui-mơgru truh đờm mư tơ Pô thơu mư̆ng pơnuaĭ nư̆n. ");
INSERT INTO cje_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Pô truh jĕ, apăn tơngàn đơ̆ng ñu tơgồ. Pơnuaĭ pơrmă-mơrềt thĭt mư, sơ̆ng ñu tơma duh bruă tơgrơ̆ mơnih. ");
INSERT INTO cje_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Truh glai diơŭ, tŭ ia-hơrơi ñŭ, aràng ba abih tơgrơ̆ mơnih lơ-ơ̆n lơngoh rơwă-sơkì sơ̆ng du mơnih kơđòng kơmlài ngă truh sơ̆ng Yàng Jêsu. ");
INSERT INTO cje_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Buơl làng lăm plơi-prŏng pơgùm-pơtòm gơŭ tơ anaŭ bơh 'băng. ");
INSERT INTO cje_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yàng Jêsu pơsồ-pơsaih tơ lô mơnih kơđòng tơ̆l abih tơgrơ̆ pơnuaĭ lơ-ơ̆n lơngoh rơwă-sơkì, sơ̆ng pơtrơh lô kơmlài, bloh 'buh brơi gơnuăr du kơmlài đờm sa pơnuaĭ lơi, kơyoa guñu thơu Pô la aràng sơi. ");
INSERT INTO cje_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ờm hơrơi hơdơi, tŭ lơngì sơđaŭ dò kơnăm, Yàng Jêsu tơgồ, nau tơma lăm anih jơhua-kơđơ̆ng, sơ̆ng iơu-lài tơ anih nư̆n. ");
INSERT INTO cje_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simôn sơ̆ng du mơnih tui-mơgru nau duah Pô. ");
INSERT INTO cje_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Tŭ duah 'buh nư̆n đờm lài: “Abih tơgrơ̆ mơnih dò duah Pô-Pơto.” ");
INSERT INTO cje_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Bloh Pô đờm sơ̆ng buơl guñu: “Buơl gudrơi nau bĕ anih pơkơ̆n, tơma lăm du plơi tòmdăr anih ni, tô Kơu kŭng pơto-akhàn tơ anih nư̆n rơi. Kơyoa nư̆n la bruă phŭn bloh Kơu hũ truh.” ");
INSERT INTO cje_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Pô nau abih lăm c̆àr Galile, pơto-akhàn lăm du sàng pơtòm sơ̆ng pơtrơh kơmlài. ");
INSERT INTO cje_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Tŭ nư̆n hũ sa aràng mơnih dŭn truh pơđih rùp tơ anaŭ Yàng Jêsu sơ̆ng yòng lơkơu: “Yah Pô khiăng, Pô hũ rơgơi ngă tơ dơlhă hũ goh.” ");
INSERT INTO cje_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yàng Jêsu hũ hơtai-hơtiàn anĭt-anăr, yơ̆r tơngàn tŭp tơ mơnih nư̆n sơ̆ng đờm: “Kơu khiăng, pơsồ goh bĕ.” ");
INSERT INTO cje_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Lăm tơk tŭ nư̆n mư, dŭn thĭt abih, mơnih nư̆n hũ goh. ");
INSERT INTO cje_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yàng Jêsu pơđăr ñu nau mư, sơ̆ng mă pơnuaĭ jơnăp-jơni đờm kơkơi-pơđăr: ");
INSERT INTO cje_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Păl c̆ơ-kơrhia bĕ, juơi đờm hơgĕ sơ̆ng aràng sơi, bloh nau bĕ pơto rùp sơ̆ng mơnih gơnuăr pơyă phơ̆n duh-dơlbăt, sơ̆ng pơyă phơ̆n c̆ĕ-pơyơ̆r duh-dơlbăt mư̆ng bruă anà hũ goh tui adăt Môise pơto, tô ngă grơh tơ buơl guñu.” ");
INSERT INTO cje_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Bloh mơnih nư̆n nau, đờm pơtiơ̆ng mư̆ng bruă ni lăm abih tơgrơ̆ anih, đờm akhàn abih mư̆ng tơgrơ̆ pơnuaĭ, tơ̆l truh Yàng Jêsu 'buh rơgơi tơma lăm plơi-prŏng tơ anaŭ tơgrơ̆ mơnih jiơ̆ng, bloh păl dò lăm du anih jơhua tơ agàh plơi-prŏng. Sơ̆ng buơl làng mư̆ng tơgrơ̆ anih ba gơŭ truh sơ̆ng Pô. ");
INSERT INTO cje_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Du hơrơi hơdơi, Yàng Jêsu gài mơrai tơ plơi-prŏng Kapenaum, buơl làng mơhư̆ thơu Pô dò lăm sàng, ");
INSERT INTO cje_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","nư̆n pơgùm-pơtòm gơŭ tơ anih nư̆n lô biă, tơ̆l truh tơ anaŭ bơh 'băng sàng kŭng 'buh hũ anih lơi dò soh. Pô pơto-akhàn pơnuaĭ Yàng tơ buơl guñu. ");
INSERT INTO cje_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Tŭ nư̆n hũ pà aràng mơnih sơkồng ba truh tơ Pô sa aràng mơnih mơtai tơkai-tơngàn. ");
INSERT INTO cje_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Bloh, kơyoa mơnih lô, buơl guñu 'buh rơgơi ba mơnih nư̆n truh jĕ Pô jiơ̆ng, nư̆n buơl guñu toh bơbŭng sàng, rĭng tơ anih Pô dò guh, bloh nư̆n pơtrŭn mơnih mơtai tơkai-tơngàn dò đih lăm c̆ơnừng trŭn tơ ala. ");
INSERT INTO cje_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","'Buh pơnuaĭ păng-tui buơl guñu yơu nư̆n, Yàng Jêsu đờm sơ̆ng mơnih mơtai tơkai-tơngàn: “Ơ anà, glài-sơnoh anà hũ anĭt toh-luơi bơjơ.” ");
INSERT INTO cje_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Bloh hũ du mơnih gơnuăr-pơto pơnuaĭ adăt-adia dò guh tơ anih nư̆n, buơl guñu sơnư̆ng ờm lăm hơtai-hơtiàn lài: ");
INSERT INTO cje_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Kơđa hơgĕ mơnih ni khĭn đờm yơu nư̆n? C̆ờ-sơrbĭl biă! Rơlau tơ Yàng Pô Lơngì, aràng sơi hũ gơnuăr toh-luơi glài-sơnoh jiơ̆ng?” ");
INSERT INTO cje_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Lăm hơtai-akŏ Yàng Jêsu hũ kràn-thơu mư du pơnuaĭ hơgĕ buơl guñu dò đờm sơ̆ng gơŭ, nư̆n Pô đờm: “Kơđa hơgĕ lăm hơtai-hơtiàn buơl guhã sơnư̆ng-bơngoàn yơu nư̆n? ");
INSERT INTO cje_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Tui buơl guhã, nư̆n tơkrah bruă đờm sơ̆ng mơnih mơtai tơkai-tơngàn lài: ‘Glài-sơnoh anà hũ anĭt toh-luơi bơjơ,’ sơ̆ng bruă đờm: ‘Tơgồ dơ̆ng bĕ apăn c̆ơnừng hã bloh nau,’ bruă lơi 'buơ̆n rơlau? ");
INSERT INTO cje_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Bloh tô buơl guhã thơu lài tŭ dò lăm dun-ya, Anà Mơnih hũ gơnuăr toh-luơi glài-sơnoh.” Pô đờm sơ̆ng mơnih mơtai tơkai-tơngàn: ");
INSERT INTO cje_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Kơu pơđăr anà, tơgồ dơ̆ng bĕ, glăm c̆ơnừng sơ̆ng nau wơ̆ tơ sàng!” ");
INSERT INTO cje_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Mơnih mơtai tơkai-tơngàn lăm tơk tơgồ dơ̆ng mư, glăm c̆ơnừng tơbiă nau tơ anaŭ abih tơgrơ̆ mơnih, tơ̆l truh aràng sơi aràng nư̆n kŭng mă ngă c̆rih-takơtuă sơ̆ng mơyòm-pơglòng Yàng Pô Lơngì lài: “Buơl gudrơi ka tŭ lơi 'buh bruă yơu ni!” ");
INSERT INTO cje_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yàng Jêsu tơbiă nau tơ gah ia-tơsì wơ̆, abih tơrpuơl buơl làng truh sơ̆ng Pô, sơ̆ng Pô pơto-pơsài buơl guñu. ");
INSERT INTO cje_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Lăm jơlàn nau Pô 'buh Lebi, anà Alphe, tŭ nư̆n dò guh tơ anih rì-mă jia, nư̆n đờm sơ̆ng ñu: “Tui bĕ kơu!” Lebi tơgồ dơ̆ng, nau tui Pô. ");
INSERT INTO cje_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Hơdơi mư̆ng nư̆n, tŭ Pô dò guh huă 'bơ̆ng mơlăm lăm sàng Lebi, hũ lô mơnih rì-mă jia sơ̆ng mơnih glài-sơnoh dò guh huă 'bơ̆ng găm sơ̆ng Pô sơ̆ng du mơnih tui-mơgru Pô, kơyoa lăm du mơnih nư̆n hũ lô mơnih tui Pô bơjơ. ");
INSERT INTO cje_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Du mơnih gơnuăr-pơto pơnuaĭ adăt-adia lăm tơrpuơl Pharisi 'buh Pô dò guh huă 'bơ̆ng găm sơ̆ng du mơnih rì-mă jia sơ̆ng mơnih glài-sơnoh, nư̆n đờm sơ̆ng du mơnih tui-mơgru Pô lài: “Kơđa hơgĕ Pô-Pơto dò guh huă 'bơ̆ng găm sơ̆ng du mơnih rì-mă jia sơ̆ng mơnih glài-sơnoh?” ");
INSERT INTO cje_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Mơhư̆ yơu nư̆n, Yàng Jêsu đờm sơ̆ng buơl guñu: “Mơnih pràn-khăng 'buh c̆àng truh mơnih gơnuăr-jrào ơu, bloh la mơnih rơwă-sơkì. Kơu truh 'buh iơŭ tô iơu mơnih rĭng-tơpă, bloh iơu mơnih hũ glài-sơnoh.” ");
INSERT INTO cje_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Tŭ nư̆n du mơnih tui-mơgru Jăng 'Baptis sơ̆ng du mơnih Pharisi dò wèr 'bơ̆ng; hũ mơnih truh tơnia Pô: “Kơđa hơgĕ du mơnih tui-mơgru Jăng 'Baptis sơ̆ng du mơnih tui-mơgru lăm tơrpuơl Pharisi wèr 'bơ̆ng, bloh du mơnih tui-mơgru Pô-Pơto 'buh wèr 'bơ̆ng?” ");
INSERT INTO cje_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yàng Jêsu đờm sơđồ: “Mơnih adơi-ai gơŭ sơ̆ng mơnih mơrtơu-lơkơi hũ rơgơi wèr 'bơ̆ng jiơ̆ng lăm tŭ mơnih mơrtơu-lơkơi dò sơ̆ng buơl guñu ơu? Hơdùm suơi mơnih mơrtơu-lơkơi dò sơ̆ng buơl guñu, buơl guñu 'buh rơgơi wèr 'bơ̆ng jiơ̆ng. ");
INSERT INTO cje_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Bloh truh hơrơi mơnih mơrtơu-lơkơi păl kŏng ba nau atàh mư̆ng buơl guñu, lăm hơrơi nư̆n buơl guñu rơŭ wèr 'bơ̆ng. ");
INSERT INTO cje_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","'Buh aràng sơi bàl pĕt bơ-yài bơrhơu lăm ào klă; yah ngă yơu nư̆n, pĕt bàl bơrhơu rơŭ tơrsăng rŭt ngă tơrhĕt ào klă, sơ̆ng anih tơrhĕt rơŭ jơhà rơlau wơ̆. ");
INSERT INTO cje_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Kŭng 'buh aràng sơi trĭng tơpai bơrhơu lăm gơdoh kơlì klă; yah ngă yơu nư̆n, tơpai rơŭ ngă tơrlah gơdoh, tơpai lơhiă sơ̆ng gơdoh kŭng 'buh dò ơu rơi; bloh tơpai bơrhơu păl trĭng lăm gơdoh kơlì bơrhơu.” ");
INSERT INTO cje_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Lăm hơrơi sa'bat, Yàng Jêsu nau găn 'blàng hơma bơdai. Lăm jơlàn nau, du mơnih tui-mơgru Pô rơhòt amùng bơdai. ");
INSERT INTO cje_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Du mơnih Pharisi đờm sơ̆ng Pô: “C̆ơ dih, kơđa hơgĕ du mơnih tui-mơgru Pô-Pơto ngă pơnuaĭ 'buh hũ gơnuăr ngă lăm hơrơi sa'bat?” ");
INSERT INTO cje_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Pô đờm sơ̆ng buơl guñu: “Buơl guhã ka tŭ lơi pơrpoh-c̆ơ lăm 'Bồn Bơ-àr ơu? Pơtau Đabit hũ ngă hơgĕ, tŭ ñu sơ̆ng du mơnih nau tui ñu kŏng siơŭ kơđòng sơ̆ng lơpa tŭng? ");
INSERT INTO cje_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Lăm rài Abiatha ngă mơnih gơnuăr prŏng apăn-akŏ pơyă phơ̆n duh-dơlbăt, Đabit hũ tơma lăm sàng Yàng Pô Lơngì, mă pah sơc̆ih-sri 'bơ̆ng, sơ̆ng kŭng brơi tơ du mơnih nau tui ñu 'bơ̆ng rơi, yah pah nư̆n mĭn du mơnih gơnuăr pơyă phơ̆n duh-dơlbăt nư̆n ka hũ gơnuăr 'bơ̆ng.” ");
INSERT INTO cje_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Bloh nư̆n Pô đờm sơ̆ng buơl guñu: “Hơrơi sa'bat hũ ngă tơbiă kơyoa jơi anà mơnih, 'buh iơŭ jơi anà mơnih hũ pơjiơ̆ng tơbiă kơyoa hơrơi sa'bat. ");
INSERT INTO cje_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Kơyoa nư̆n, Anà Mơnih kŭng la Yàng hơrơi sa'bat.” ");
INSERT INTO cje_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Lăm sa amăng pơkơ̆n, Yàng Jêsu tơma lăm sàng pơtòm, tơ anih nư̆n hũ sa aràng mơnih lơkơi srĕt-mơtai sa gah tơngàn. ");
INSERT INTO cje_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Buơl guñu kraŭ-c̆ơ Pô hũ pơsồ-pơsaih tơ mơnih nư̆n lăm hơrơi sa'bat ơu, tô hũ pơnuaĭ yă Pô. ");
INSERT INTO cje_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Pô đờm sơ̆ng mơnih srĕt-mơtai tơngàn: “Tơgồ dơ̆ng bĕ, truh dò dơ̆ng tơkrah anih ni.” ");
INSERT INTO cje_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Bloh nư̆n Pô tơnia buơl guñu: “Lăm hơrơi sa'bat hũ gơnuăr ngă bruă siàm halài bruă jơhà? Păl dŏng mơnih halài pơmơtai mơnih?” Bloh buơl guñu dò kơđơ̆ng rik. ");
INSERT INTO cje_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Pô pơtrah mơta c̆ơ tơ buơl guñu, găm anok hơtai găm jruh-jrui kơyoa hơtai-hơtiàn buơl guñu kră-khăng. Bloh nư̆n Pô đờm sơ̆ng mơnih srĕt-mơtai tơngàn: “Yơ̆r bĕ tơngàn tơbiă.” Mơnih nư̆n yơ̆r tơngàn tơbiă, nư̆n tơngàn hũ pơsồ-pơsaih mư. ");
INSERT INTO cje_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Du mơnih Pharisi nau tơbiă, lăm tơk tŭ nư̆n mư tămbơyai sơ̆ng du mơnih gah tơrpuơl Herôt tămdră-wơ̆ sơ̆ng Pô, tô duah pơnuaĭ pơmơtai Pô. ");
INSERT INTO cje_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yàng Jêsu sơ̆ng du mơnih tui-mơgru Pô pleh nau tơ gah ia-tơsì. Hũ sa tơrpuơl lô buơl làng mư̆ng c̆àr Galile truh tui Pô. Mư̆ng c̆àr Juđe, ");
INSERT INTO cje_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","plơi-prŏng Jerusalem, c̆àr Iđume, c̆àr gah dih ia-sơdờng Jôđăn, c̆àr tòmdăr plơi-prŏng Tirơ sơ̆ng Siđôn, ŭr-ŭr ba gơŭ truh sơ̆ng Pô, kơyoa mơhư̆ thơu mư̆ng tơgrơ̆ bruă Pô hũ ngă. ");
INSERT INTO cje_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Kơyoa lô mơnih biă, nư̆n Pô đờm pơđăr du mơnih tui-mơgru rơc̆ăng lờih tơ Pô sa boh gơlài, tô klàh kơđòng tơrpuơl mơnih lô sŭl pơjeh. ");
INSERT INTO cje_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Kơyoa Pô hũ pơsồ-pơsaih tơ lô mơnih lơ-ơ̆n lơngoh rơwă-sơkì, nư̆n abih tơgrơ̆ mơnih hũ lơ-ơ̆n lơngoh rơwă-sơkì, aràng sơi aràng nư̆n kŭng ràn truh jĕ tô hũ rơwơ̆ tŭp Pô. ");
INSERT INTO cje_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Yàu tŭ du mơnih kơđòng kơmlài ngă 'buh Pô, guñu pơđih rùp tơ tơkai Pô sơ̆ng iơu driau lài: “Pô-Pơto la Anà Yàng Pô Lơngì.” ");
INSERT INTO cje_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Bloh Pô pơkơŭ guñu, 'buh brơi đờm tơ aràng thơu Pô la aràng sơi. ");
INSERT INTO cje_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yàng Jêsu đì tơ ngŏ c̆ơ̆, iơu du mơnih Pô khiăng truh sơ̆ng Pô. Sơ̆ng buơl guñu truh sơ̆ng Pô. ");
INSERT INTO cje_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Pô rơwah-pồ tơrpuơl sa-pluh dua aràng, angăn la tơdi-tơdài tô dò sơ̆ng Pô, sơ̆ng tô Pô pơđăr buơl guñu nau pơto-akhàn Pơnuaĭ-Siàm, ");
INSERT INTO cje_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","sơ̆ng brơi tơ buơl guñu gơnuăr tô pơtrơh kơmlài. ");
INSERT INTO cje_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ni la sa-pluh dua aràng mơnih tơdi-tơdài bloh Pô hũ rơwah-pồ: Simôn, Pô pơ-angăn la Pier, ");
INSERT INTO cje_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jakơ anà Sebede, sơ̆ng Jăng adơi Jakơ, Pô pơ-angăn dua aràng buơl guñu la Bôanerges, mơblàng la anà lơkơi grơ̆m-kơtàl; ");
INSERT INTO cje_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andre, Philip, 'Bathelemi, Mathiơ, Thôma, Jakơ anà Alphe, Thađe, Simôn mơnih Kanaan, ");
INSERT INTO cje_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","sơ̆ng Juđa Iskariôt la mơnih pơblơ̆-dră Pô. ");
INSERT INTO cje_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yàng Jêsu sơ̆ng du mơnih tui-mơgru tơma lăm sa boh sàng; sa tơrpuơl lô buơl làng ba gơŭ truh pơgùm-pơtòm wơ̆ tơ anih nư̆n, tơ̆l truh Pô sơ̆ng du mơnih tui-mơgru 'buh rơgơi huă 'bơ̆ng jiơ̆ng. ");
INSERT INTO cje_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Du mơnih lăm sàng-dơnò Pô mơhư̆ thơu yơu nư̆n, buơl guñu truh tô mă ba Pô nau wơ̆, kơyoa aràng đờm lài “Pô lơhiă akŏ-sơnư̆ng bơjơ.” ");
INSERT INTO cje_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Bloh du mơnih gơnuăr-pơto pơnuaĭ adăt-adia mư̆ng plơi-prŏng Jerusalem trŭn nư̆n đờm lài: “Mơnih ni kơđòng kơmlài Beelsebul ngă, sơ̆ng gơnừm tơ gơnuăr pơtau-kơmlài bloh pơtrơh kơmlài.” ");
INSERT INTO cje_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yàng Jêsu iơu buơl guñu truh, angui pơnuaĭ pơgăp-pơmơyơu bloh đờm sơ̆ng buơl guñu: “Hơyơu kơmlài Satăn pơtrơh jiơ̆ng kơmlài Satăn? ");
INSERT INTO cje_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Yah sa lơgăr pơc̆ơrlah krơi duă gơŭ drơi wơ̆, lơgăr nư̆n rơŭ 'buh rơgơi dò dơ̆ng kơjăp jiơ̆ng. ");
INSERT INTO cje_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Yah sa boh sàng pơc̆ơrlah krơi duă gơŭ wơ̆, sàng nư̆n rơŭ 'buh dò dơ̆ng kơjăp jiơ̆ng. ");
INSERT INTO cje_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Kŭng yơu nư̆n rơi, yah kơmlài Satăn tămdră-wơ̆ sơ̆ng rùp-phŭn ñu sơ̆ng pơc̆ơrlah krơi duă gơŭ ñu wơ̆, nư̆n ñu 'buh rơgơi dò dơ̆ng kơjăp jiơ̆ng, bloh hũ truh hơrơi luĭ-dŭt ñu bơjơ. ");
INSERT INTO cje_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","'Buh aràng sơi hũ rơgơi tơma lăm sàng sa aràng mơnih pràn-khăng tô tămblah-mă phơ̆n-bơna mơnih nư̆n, bloh dơlhơu biă 'buh mă c̆aŭ mơnih pràn-khăng nư̆n wơ̆. Păl mă c̆aŭ mơnih nư̆n wơ̆, bloh nư̆n ka hũ rơgơi tămblah-mă phơ̆n-bơna lăm sàng ñu jiơ̆ng. ");
INSERT INTO cje_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Iơŭ biă, Kơu đờm sơ̆ng buơl guhã, abih tơgrơ̆ pơnuaĭ glài-sơnoh rơŭ hũ anĭt toh-luơi tơ anà-tơc̆o jơi anà mơnih, găm sơ̆ng abih tơgrơ̆ pơnuaĭ sơk-sơrbĭl khĭn-dơmĭn buơl guñu đờm kŭng yơu nư̆n rơi. ");
INSERT INTO cje_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Bloh aràng sơi đờm sơk-sơrbĭl khĭn-dơmĭn truh tơ Yàng Bơngă Sơc̆ih-Sri, nư̆n rơŭ 'buh tŭ lơi hũ anĭt toh-luơi, păl kơđòng glài-sơnoh rài pơdò rài.” ");
INSERT INTO cje_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Pô đờm yơu nư̆n, kơyoa buơl guñu đờm lài: “Mơnih ni kơđòng kơmlài ngă.” ");
INSERT INTO cje_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ame sơ̆ng adơi-ai Yàng Jêsu truh, dò dơ̆ng tơ agàh, sơ̆ng yòng mơnih tơma iơu Pô. ");
INSERT INTO cje_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Tŭ nư̆n hũ sa tơrpuơl lô buơl làng dò guh tòmdăr Pô, sơ̆ng buơl guñu đờm sơ̆ng Pô: “Ơ Pô-Pơto, hũ ame sơ̆ng adơi-ai Pô dò tơ agàh, buơl guñu tơnia duah Pô.” ");
INSERT INTO cje_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Pô đờm: “Aràng sơi la ame Kơu, aràng sơi la adơi-ai Kơu?” ");
INSERT INTO cje_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Bloh nư̆n Pô pơtrah c̆ơ tơ du mơnih dò guh tòmdăr Pô, sơ̆ng đờm: “Ni la ame Kơu sơ̆ng adơi-ai Kơu! ");
INSERT INTO cje_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Aràng sơi ngă tui hơtai-khiăng Yàng Pô Lơngì, mơnih nư̆n la adơi-ai, la gơŭ kơmơi sơ̆ng la ame Kơu.” ");
INSERT INTO cje_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Sa amăng pơkơ̆n, Yàng Jêsu tơma pơto-mơblàng tơ gah ia-tơsì. Hũ sa tơrpuơl mơnih lô biă pơgùm-pơtòm gơŭ tòmdăr Pô, nư̆n Pô păl trŭn dò guh lăm sa boh gơlài, abih tơrpuơl buơl làng nư̆n dò dơ̆ng tơ gah ia. ");
INSERT INTO cje_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Pô angui pơnuaĭ pơgăp-pơmơyơu đờm pơto buơl guñu lô pơnuaĭ. Lăm tŭ pơto, Pô đờm: ");
INSERT INTO cje_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Păng bĕ ni! Hũ sa aràng mơnih tơbiă nau drà găr-pơjeh. ");
INSERT INTO cje_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Lăm tŭ drà, hũ du găr lĕ rò gah jơlàn, c̆ĭm truh 'bơ̆ng abih. ");
INSERT INTO cje_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Du găr pơkơ̆n lĕ iơŭ lăm anih lơ̆n pơtơu-rơđeh, mĭn hũ sa-sĭt lơ̆n soh, kơyoa lơ̆n bồr 'buh dơrlăm, nư̆n tơmuh tơgồ mư. ");
INSERT INTO cje_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Bloh tŭ ia-hơrơi đì tơgồ, kơđòng pơđiă gruă, nư̆n guñu thu piăp kơyoa 'buh hũ akha. ");
INSERT INTO cje_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Du găr pơkơ̆n lĕ iơŭ tơkrah puk druơi; druơi c̆ă yùm ngă tơ ñu bơlhăt, nư̆n 'buh hũ phŭn-hơjŭng. ");
INSERT INTO cje_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Du găr pơkơ̆n wơ̆ lĕ iơŭ lăm anih lơ̆n siàm nư̆n hũ phŭn-hơjŭng, tơgồ prŏng sơ̆ng tơbiă bơnga boh: sa găr tơbiă klơu pluh, găr pơkơ̆n năm pluh, găr pơkơ̆n wơ̆ sa rơtùh.” ");
INSERT INTO cje_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Bloh nư̆n Pô đờm: “Aràng sơi hũ tơnia tô păng, nư̆n păng-mơhư̆ bĕ!” ");
INSERT INTO cje_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Tŭ Yàng Jêsu dò sa aràng, du mơnih dò tòmdăr Pô găm sơ̆ng sa-pluh dua aràng mơnih tơdi-tơdài truh tơnia Pô mư̆ng du pơnuaĭ pơgăp-pơmơyơu. ");
INSERT INTO cje_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Pô đờm: “Sơ̆ng buơl guhã, pơnuaĭ tơrđơŭ-dơrlăm mư̆ng lơgăr Yàng Pô Lơngì hũ ràng-tơbiă tơ buơl guhã bơjơ; bloh sơ̆ng tơgrơ̆ mơnih agàh, nư̆n abih tơgrơ̆ mơta sơđaŭ păl angui pơnuaĭ pơgăp-pơmơyơu, ");
INSERT INTO cje_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","tô buơl guñu: C̆ơ nư̆n sơđaŭ c̆ơ, bloh 'bu 'buh, Păng nư̆n sơđaŭ păng, bloh 'buh wờng; Huơĭ buơl guñu gài-wơ̆ bloh hũ anĭt toh-luơi glài-sơnoh ơu.” ");
INSERT INTO cje_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Bloh nư̆n Pô đờm: “Buơl guhã 'buh wờng pơnuaĭ pơgăp-pơmơyơu ni ơu? Yơu nư̆n ngă hơyơu buơl guhã wờng jiơ̆ng abih tơgrơ̆ pơnuaĭ pơgăp-pơmơyơu pơkơ̆n? ");
INSERT INTO cje_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Mơnih drà găr-pơjeh, nư̆n la drà Pơnuaĭ Yàng Pô Lơngì. ");
INSERT INTO cje_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Du găr rò gah jơlàn la du mơnih hũ khiăng păng Pơnuaĭ Yàng Pô Lơngì drà tơbiă, bloh tŭ buơl guñu pơrpa păng Pơnuaĭ Yàng Pô Lơngì, nư̆n Satăn truh mư, tămblah mă Pơnuaĭ Yàng Pô Lơngì hũ drà lăm hơtai-hơtiàn buơl guñu. ");
INSERT INTO cje_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Kŭng yơu nư̆n rơi, du găr drà lăm anih lơ̆n pơtơu-rơđeh, la du mơnih tŭ păng Pơnuaĭ Yàng Pô Lơngì nư̆n sờh-sài păng-tui đồ-mă mư; ");
INSERT INTO cje_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","bloh Pơnuaĭ Yàng Pô Lơngì 'buh tơmuh akha lăm dơrlăm hơtai-hơtiàn, mĭn dò sơdăng lăm sa-sĭt tŭ soh; nư̆n tŭ kơyoa mư̆ng Pơnuaĭ Yàng Pô Lơngì bloh păp du pơnuaĭ gleh-glăr mơtai-lơhiă halài kơđòng mă-pơkơŭ, buơl guñu sơnĕ lơbuh mư. ");
INSERT INTO cje_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Du găr lĕ iơŭ tơkrah puk druơi, nư̆n mơhiơ̆ yơu du mơnih păng Pơnuaĭ Yàng Pô Lơngì, ");
INSERT INTO cje_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","bloh bruă sơnư̆ng kơ-ù mư̆ng rài ni, pơnuaĭ pơluơ-pơsờh mư̆ng pơnuaĭ mơda gơn-hư̆p, sơ̆ng tơgrơ̆ pơnuaĭ hàm-khiăng pơkơ̆n tơma baŭ lăm hơtai-hơtiàn buơl guñu, ngă tơ Pơnuaĭ Yàng Pô Lơngì kơđòng gơrèt bơlhăt, 'buh tơbiă boh jiơ̆ng. ");
INSERT INTO cje_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Bloh, du găr drà lăm anih lơ̆n siàm, mơhiơ̆ yơu du mơnih păng Pơnuaĭ Yàng Pô Lơngì nư̆n păng-tui đồ-mă sơ̆ng tơbiă bơnga boh, găr ni tơbiă klơu pluh, găr pơkơ̆n năm pluh, găr pơkơ̆n wơ̆ sa rơtùh.” ");
INSERT INTO cje_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yàng Jêsu đờm sơ̆ng buơl guñu: “Hũ aràng sơi apăn đèng daŭ tơ ala thŭng halài tơ ala jờng c̆ơnừng rơi? 'Buh iơŭ la daŭ tơ ngŏ tơkai đèng ơu? ");
INSERT INTO cje_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kơyoa 'buh hũ pơnuaĭ hơgĕ bơdơŭ-tơrđơŭ bloh 'buh păl ràng-tơbiă, 'buh hũ pơnuaĭ hơgĕ bơdơŭ-tơrđơŭ bloh 'buh păl ba tơbiă tơ pơnuaĭ sơrdah. ");
INSERT INTO cje_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Aràng sơi hũ tơnia tô păng, nư̆n păng-mơhư̆ bĕ!” ");
INSERT INTO cje_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Pô đờm sơ̆ng buơl guñu: “C̆ơ-kơrhia bĕ mư̆ng pơnuaĭ buơl guhã păng. Buơl guhã wăl tơ aràng kàr lơi nư̆n buơl guñu kŭng rơŭ wăl tơ buơl guhã kàr nư̆n rơi, sơ̆ng dò brơi pơtơ̆l rơlau wơ̆. ");
INSERT INTO cje_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Kơyoa mơnih lơi hũ, mơnih nư̆n rơŭ hũ brơi pơtơ̆l wơ̆; bloh mơnih lơi 'buh hũ, nư̆n găm phơ̆n hơgĕ mơnih nư̆n hũ, kŭng rơŭ kŏng mă thĭt rơi.” ");
INSERT INTO cje_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yàng Jêsu kŭng đờm: “Lơgăr Yàng Pô Lơngì kŭng mơhiơ̆ yơu sa aràng mơnih drà găr-pơjeh lăm lơ̆n, ");
INSERT INTO cje_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","mơnih nư̆n đih halài mơdơh, mơlăm halài hơrơi, găr-pơjeh sơđaŭ c̆eh mơta tơmuh sơ̆ng c̆ă tơgồ, bloh mơnih nư̆n 'buh thơu hơyơu lơi. ");
INSERT INTO cje_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Kơyoa lơ̆n tơ ñu tơbiă bơnga boh, tŭ c̆ơmrừp la phŭn mơda, bloh nư̆n sroh bơnga sơ̆ng jiơ̆ng găr. ");
INSERT INTO cje_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Tŭ bơdai asă, mơnih nư̆n apăn wăng nau yuă mư, kơyoa blàn yuă hũ truh bơjơ.” ");
INSERT INTO cje_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yàng Jêsu đờm: “Buơl gudrơi hũ rơgơi mă pơnuaĭ hơgĕ tô pơc̆àu-pơgăp, halài angui pơnuaĭ pơgăp-pơmơyơu lơi tô đờm mư̆ng lơgăr Yàng Pô Lơngì? ");
INSERT INTO cje_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Lơgăr Yàng Pô Lơngì mơhiơ̆ yơu sa găr sơbơi, tŭ dơnih lăm lơ̆n, ñu mĭn la sa agăr tìt rơlau abih lăm tơgrơ̆ agăr pơkơ̆n lăm lơ̆n. ");
INSERT INTO cje_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Bloh tŭ dơnih bơjơ, ñu tơmuh tơgồ sơ̆ng tơbiă jiơ̆ng sa phŭn prŏng rơlau tơ abih tơgrơ̆ jơi phŭn ơñiăm pơkơ̆n, du thàn ñu prŏng tơ̆l truh c̆ĭm lơngì hũ rơgơi ngă sruh tơ ala lơhui ñu jiơ̆ng.” ");
INSERT INTO cje_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Pô angui lô pơnuaĭ pơgăp-pơmơyơu yơu nư̆n bloh pơto-akhàn Pơnuaĭ Yàng Pô Lơngì tơ buơl guñu, tô buơl guñu hũ rơgơi păng jiơ̆ng. ");
INSERT INTO cje_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Pô 'buh đờm pơnuaĭ hơgĕ sơ̆ng buơl guñu bloh 'buh angui pơnuaĭ pơgăp-pơmơyơu; bloh, tŭ dò krơi sơ̆ng du mơnih tui-mơgru, Pô mơblàng tơbiă abih tơgrơ̆ pơnuaĭ nư̆n tơ du mơnih tui-mơgru Pô. ");
INSERT INTO cje_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Truh diơŭ hơrơi nư̆n, Yàng Jêsu đờm sơ̆ng du mơnih tui-mơgru: “Buơl gudrơi nau bĕ truh tơ gah dih ia.” ");
INSERT INTO cje_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Hơdơi tŭ brơi tơrpuơl buơl làng nau wơ̆ abih bơjơ, Yàng Jêsu sơđaŭ dò lăm gơlài, sơ̆ng du mơnih tui-mơgru ba Pô nau. Kŭng hũ du gơlài pơkơ̆n nau găm rơi. ");
INSERT INTO cje_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Tŭ nư̆n hũ rơbù-angĭn prŏng tơgồ, rơyà ia poh tơma lăm gơlài, tơ̆l truh gơlài kơjĕ krăm. ");
INSERT INTO cje_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Lăm tŭ nư̆n, Pô dò tơ gah aku anih yuơ̆ gơlài, gơnàng akŏ lăm pơtăl bloh đih. Du mơnih tui-mơgru blơ̆ Pô tơgồ sơ̆ng đờm: “Ơ Pô-Pơto, buơl gudrơi kơjĕ mơtai bơjơ bloh Pô-Pơto 'buh sơnư̆ng kơ-ù hơgĕ ơu?” ");
INSERT INTO cje_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Pô tơgồ, puaĭ tơ rơbù-angĭn sơ̆ng đờm pơđăr ia-tơsì lài: “Kơđơ̆ng bĕ, thĭt bĕ!” Rơbù-angĭn thĭt mư sơ̆ng ia-tơsì dò kơđơ̆ng-rik. ");
INSERT INTO cje_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Bloh nư̆n Pô đờm sơ̆ng du mơnih tui-mơgru: “Kơđa hơgĕ buơl guhã huơĭ-kơđa yơu nư̆n? Buơl guhã sơđaŭ ka hũ pơnuaĭ păng-tui ơu?” ");
INSERT INTO cje_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Du mơnih tui-mơgru tơgra-tơgrơ̆t biă, buơl guñu đờm sơ̆ng gơŭ: “Mơnih ni la aràng sơi bloh truh rơbù-angĭn sơ̆ng ia-tơsì kŭng păl păng-bơbah rơi?” ");
INSERT INTO cje_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yàng Jêsu sơ̆ng du mơnih tui-mơgru nau truh tơ gah dih ia-tơsì, lăm c̆àr Jerase. ");
INSERT INTO cje_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Tŭ Pô pơrpa yàm tơbiă mư̆ng gơlài, nư̆n mư̆ng anih kŭt atơu, hũ sa aràng mơnih kơđòng kơmlài ngă, đuaĭ truh tơ anaŭ Pô. ");
INSERT INTO cje_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Mơnih nư̆n hơdiŭ tơkrah du kŭt atơu, yah angui tơlơi srĕng kŭng 'buh hũ aràng sơi rơgơi mă-pơkơŭ ñu jiơ̆ng. ");
INSERT INTO cje_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Lô amăng kơđòng c̆rò anuh tơ tơkai sơ̆ng akă sơ̆ng tơlơi srĕng, bloh ñu ngă kloh srĕng sơ̆ng joh abih anuh, 'buh hũ aràng sơi tơ̆l pràn tô apăn-pơkơŭ ñu jiơ̆ng. ");
INSERT INTO cje_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Luĭ hơrơi sơ̆ng mơlăm ñu kừ dò mĭt tơkrah du kŭt atơu sơ̆ng tơ ngŏ c̆ơ̆; ñu jiăng kơmrào driau sơ̆ng mă pơtơu pờng rùp-phŭn drơi brơ̆p lơka abih. ");
INSERT INTO cje_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Tŭ 'buh Yàng Jêsu mư̆ng atàh, ñu đuaĭ mơrai truh, pơđih rùp tơ anaŭ Pô, ");
INSERT INTO cje_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","sơ̆ng đờm prŏng săp lài: “Khoai Yàng Jêsu, Anà Yàng Pô Lơngì Ngŏ Glòng Rơlau Abih, Pô sơmŏng ngă hơgĕ sơ̆ng dơlhă ni? Mă angăn Yàng Pô Lơngì dơlhă yòng lơkơu Pô juơi ngă gleh-glăr dơlhă.” ");
INSERT INTO cje_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Kơyoa Yàng Jêsu pơrpa đờm sơ̆ng ñu lài: “Ơ kơmlài! Tơbiă bĕ mư̆ng mơnih ni.” ");
INSERT INTO cje_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Bloh nư̆n Pô tơnia ñu: “Hã angăn mơta hơgĕ?” Ñu đờm: “Mơta dơlhă angăn la ‘Tơrpuơl Lĭng.’ Kơyoa buơl dơlhă lô biă.” ");
INSERT INTO cje_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ñu yòng lơkơu Pô juơi prơh guñu tơbiă mư̆ng c̆àr nư̆n. ");
INSERT INTO cje_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Tŭ nư̆n, jĕ tơ anih nư̆n, hũ sa kơtàr bơbui lô biă dò 'bơ̆ng tơ gah rơnòng c̆ơ̆. ");
INSERT INTO cje_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Du kơmlài lơkơu yòng: “Yòng Pô brơi buơl dơlhă tơma lăm kơtàr bơbui dih.” Yàng Jêsu brơi gơnuăr. ");
INSERT INTO cje_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Du kơmlài tơbiă mư̆ng mơnih nư̆n sơ̆ng tơma lăm kơtàr bơbui. Abih kơtàr bơbui, pơgăp dua rơbơu drơi, mư̆ng rơnòng c̆ơ̆ đuaĭ sơtơ̆ng trŭn lăm ia-tơsì, sơ̆ng mơtai krăm abih lăm nư̆n. ");
INSERT INTO cje_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Du mơnih glăng bơbui ba gơŭ đuaĭ dơŭ, sơ̆ng đờm akhàn wơ̆ mư̆ng pơnuaĭ ni lăm abih plơi-prŏng, plơi tìt. Buơl làng ba gơŭ truh tô c̆ơ bruă hơgĕ hũ tơbiă truh. ");
INSERT INTO cje_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Tŭ buơl guñu truh tòm Yàng Jêsu, sơ̆ng 'buh mơnih mư̆ng dơlhơu kơđòng kơmlài ngă dò guh tơ anih nư̆n, c̆ù khăn-ào, akŏ-glo saih bơhiàn, nư̆n buơl guñu huơĭ kơđa biă. ");
INSERT INTO cje_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Du mơnih tơ mơta hũ c̆ơ 'buh tơgrơ̆ bruă nư̆n, đờm akhàn wơ̆ tơ buơl guñu păng bruă hơgĕ hũ tơbiă truh tơ mơnih kơđòng kơmlài ngă sơ̆ng tơ kơtàr bơbui. ");
INSERT INTO cje_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Buơl guñu yòng lơkơu Pô tơbiă klàh mư̆ng c̆àr tơnah buơl guñu. ");
INSERT INTO cje_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Tŭ Pô trŭn lăm gơlài, mơnih dơlhơu hũ kơđòng kơmlài ngă, truh yòng lơkơu Pô brơi ñu nau tui Pô. ");
INSERT INTO cje_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Bloh Yàng Jêsu 'buh brơi gơnuăr, Pô đờm sơ̆ng ñu: “Nau wơ̆ bĕ tơ sàng, truh sơ̆ng du mơnih adơi-ai gơŭ-pơtiàn hã, đờm akhàn wơ̆ tơ buơl guñu thơu mư̆ng tơgrơ̆ bruă bloh Yàng hũ ngă tơ hã, sơ̆ng đờm tơ buơl guñu thơu Pô hũ anĭt-rơnăm tơ hã hơyơu lơi.” ");
INSERT INTO cje_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Mơnih nư̆n nau lăm abih c̆àr Đekapôl, đờm akhàn wơ̆ mư̆ng tơgrơ̆ bruă prŏng bloh Yàng Jêsu hũ ngă tơ drơi, sơ̆ng aràng sơi păng kŭng mă ngă c̆rih-takơtuă biă. ");
INSERT INTO cje_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yàng Jêsu trŭn lăm gơlài sơ̆ng gài nau wơ̆ tơ gah dih ia. Sa tơrpuơl mơnih lô biă pơgùm-pơtòm gơŭ tòmdăr Pô. Pô dò dơ̆ng tơ gah ia-tơsì. ");
INSERT INTO cje_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Tŭ nư̆n, hũ sa aràng mơnih lăm du mơnih c̆ơ-apăn sàng pơtòm, angăn mơta ñu la Jeru, nau truh. Pơrpa 'buh Yàng Jêsu, ñu pơđih rùp tơ tơkai Pô, ");
INSERT INTO cje_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","sơ̆ng đờm lơkơu yòng lài: “Anà kơmơi tìt dơlhă sơmŏng mơtai. Yòng Pô truh sơ̆ng daŭ tơngàn tơ ngŏ ñu, tô ñu hũ pơsồ-pơsaih sơ̆ng hơdiŭ.” ");
INSERT INTO cje_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yàng Jêsu nau sơ̆ng Jeru. Sa tơrpuơl lô mơnih nau tui sơ̆ng sŭl-pơjeh gơŭ tòmdăr Pô. ");
INSERT INTO cje_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Lăm tơrpuơl mơnih lô nư̆n hũ sa aràng mơnih kơmơi kơđòng lơ-ơ̆n rơwă tuh-khăn sa-pluh dua thŭn bơjơ. ");
INSERT INTO cje_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Suơi ni bơjơ ñu hũ kŏng gleh-glăr lăm tơngàn lô mơnih gơnuăr jrào, kŏng lơhiă abih phơ̆n-priă, bloh pơnuaĭ lơ-ơ̆n rơwă 'buh hũ dơh-gơdŭn sa-sĭt lơi, 'brŏ hơrơi 'brŏ traŭ rơlau wơ̆. ");
INSERT INTO cje_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ñu hũ mơhư̆ đờm mư̆ng Yàng Jêsu, nư̆n sơrlèt tơma lăm tơkrah tơrpuơl mơnih lô, nau truh mư̆ng gah rŏng Pô sơ̆ng rơwơ̆ tŭp tơ ào Pô. ");
INSERT INTO cje_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Kơyoa ñu đờm lài: “Yah kơu mĭn hũ rơwơ̆ tŭp truh tơ ào Pô soh, nư̆n kơu rơŭ hũ pơsồ-pơsaih.” ");
INSERT INTO cje_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Lăm tơk tŭ nư̆n mư, drah 'buh tuh tra, sơ̆ng ñu kràn-thơu lài drơi hũ pơsồ-pơsaih bơjơ. ");
INSERT INTO cje_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yàng Jêsu thơu mư hũ gơnăp-gơnuăr mư̆ng Pô pơrpa tơbiă, nư̆n Pô pơtrah tơ gah tơrpuơl mơnih lô sơ̆ng tơnia: “Aràng sơi hũ rơwơ̆ tŭp tơ ào Kơu?” ");
INSERT INTO cje_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Du mơnih tui-mơgru đờm sơ̆ng Pô: “Pô-Pơto 'buh bơjơ tơrpuơl mơnih lô sŭl pơjeh gơŭ tòmdăr Pô-Pơto, bloh Pô-Pơto dò tơnia lài: Aràng sơi rơwơ̆ tŭp truh Kơu?” ");
INSERT INTO cje_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Pô c̆ơ tòmdăr tô duah c̆ơ aràng sơi hũ ngă pơnuaĭ nư̆n. ");
INSERT INTO cje_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Mơnih kơmơi thơu pơnuaĭ hơgĕ hũ tơbiă truh sơ̆ng drơi, nư̆n kơtơ̆ drơi huơĭ truh pơđih rùp tơ tơkai Pô bloh đờm akhàn tơpă abih sơ̆ng Pô. ");
INSERT INTO cje_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Pô đờm sơ̆ng mơnih kơmơi: “Ơ anà kơmơi Kơu, pơnuaĭ păng-tui anà hũ pơsồ-pơsaih tơ anà. Nau bĕ rĭng-lơngai sơ̆ng hũ pơsồ-pơsaih lơ-ơ̆n rơwă.” ");
INSERT INTO cje_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Tŭ Pô dò đờm, nư̆n hũ mơnih mư̆ng sàng-dơnò Jeru truh đờm sơ̆ng Jeru lài: “Anà kơmơi kơi mơtai bơjơ, dò ngă pơgleh Pô-Pơto ngă hơgĕ wơ̆?” ");
INSERT INTO cje_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Bloh Yàng Jêsu 'buh sơnư̆ng c̆ơ hơgĕ truh pơnuaĭ nư̆n, Pô đờm sơ̆ng mơnih c̆ơ-apăn sàng pơtòm: “Juơi huơĭ, mĭn păng-tui soh.” ");
INSERT INTO cje_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yàng Jêsu 'buh brơi aràng sơi nau tui Pô, mĭn ba Pier, Jakơ, sơ̆ng Jăng la adơi Jakơ soh. ");
INSERT INTO cje_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Tŭ truh tơ sàng Jeru, Pô 'buh buơl guñu ngă klùk-klờk biă, mơnih hia c̆ŏ, mơnih driau kơmrào srĭ tơnia. ");
INSERT INTO cje_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Tŭ tơma lăm sàng, Pô đờm sơ̆ng buơl guñu: “Kơđa hơgĕ buơl guhã ngă klùk-klờk sơ̆ng hia c̆ŏ yơu nư̆n? Adơi tìt ni 'buh mơtai ơu, bloh ñu mĭn dò đih!” ");
INSERT INTO cje_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Buơl guñu klau-pơtăt Pô. Hơdơi tŭ prơh pơđăr buơl guñu tơbiă abih tơ agàh, Pô ba ame ama adơi tìt sơ̆ng du mơnih tui-mơgru Pô tơma truh tơ anih adơi tìt nư̆n dò đih. ");
INSERT INTO cje_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Pô apăn tơngàn adơi tìt sơ̆ng đờm: “Talitha kumi!” Kơtha mơblàng la: “Ơ anà kơmơi tìt, Kơu pơđăr anà, tơgồ bĕ.” ");
INSERT INTO cje_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Tŭ nư̆n mư, anà kơmơi tìt tơgồ dơ̆ng sơ̆ng yàm nau, kơyoa ñu hũ sa-pluh dua thŭn bơjơ. 'Buh yơu nư̆n, abih tơgrơ̆ mơnih mă ngă c̆rih-takơtuă biă. ");
INSERT INTO cje_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Pô pơkơŭ buơl guñu 'buh hũ đờm tơ aràng sơi thơu mư̆ng bruă ni, sơ̆ng pơđăr buơl guñu brơi anà tìt nư̆n 'bơ̆ng. ");
INSERT INTO cje_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yàng Jêsu luơi anih nư̆n sơ̆ng gài mơrai wơ̆ tơ plơi phŭn Pô, hũ du mơnih tui-mơgru nau găm sơ̆ng Pô. ");
INSERT INTO cje_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Truh hơrơi sa'bat, Pô tơma pơto-akhàn lăm sàng pơtòm. Lô mơnih păng Pô pơto-mơblàng nư̆n mă ngă krơi-takơtuă sơ̆ng đờm: “Kơyoa mư̆ng lơi bloh mơnih ni hũ du pơnuaĭ nư̆n? Pơnuaĭ jak-khờh bloh ñu hũ brơi la hơgĕ? Ngă hơyơu bloh tơngàn mơnih ni hũ rơgơi ngă jiơ̆ng lô bruă gơnăp-gơnuăr yơu nư̆n? ");
INSERT INTO cje_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ni 'buh iơŭ la mơnih khờh trah kơyơu, anà lơkơi Mari, adơi-ai sơ̆ng Jakơ, Jôse, Juđe sơ̆ng Simôn ơu? Du gơŭ kơmơi ñu 'buh iơŭ dò hơdiŭ tơkrah buơl gudrơi tơ anih ni ơu?” Buơl guñu sơnĕ lơbuh lăm pơnuaĭ sŭng kơyoa Pô. ");
INSERT INTO cje_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Bloh Yàng Jêsu đờm sơ̆ng buơl guñu: “Mơnih gơnuăr-hwơ̆r mĭn kŏng plơi-lơgăr phŭn drơi, gơŭ-pơtiàn drơi sơ̆ng lăm sàng-dơnò drơi c̆ơ 'buh sơ̆p ơu soh!” ");
INSERT INTO cje_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Tơ anih nư̆n, Pô 'buh ngă sa bruă gơnăp-gơnuăr lơi, mĭn daŭ tơngàn pơsồ-pơsaih tơ du mơnih lơ-ơ̆n lơngoh rơwă-sơkì. ");
INSERT INTO cje_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Pô mă ngă krơi-takơtuă biă kơyoa buơl guñu 'buh păng-tui. Bloh nư̆n Pô nau tơ du plơi dò jĕ rò anih nư̆n tô pơto-akhàn. ");
INSERT INTO cje_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Pô iơu sa-pluh dua aràng mơnih tơdi-tơdài truh sơ̆ng pơđăr buơl guñu nau tui sa yơu dua aràng. Pô brơi tơ buơl guñu gơnuăr tơ ngŏ du kơmlài-jĭnràk. ");
INSERT INTO cje_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Pô pơđăr buơl guñu tŭ nau jơlàn juơi apăn hơgĕ tui, mĭn apăn sa bĕ gai jra soh; 'buh apăn phơ̆n 'bơ̆ng, 'buh apăn kơdŭng nau jơlàn, 'buh apăn priă lăm tơlơi kơ-iăng, ");
INSERT INTO cje_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","mĭn juă kơlì-juă, sơ̆ng 'buh c̆ù dua blah ào. ");
INSERT INTO cje_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Pô đờm kơkơi buơl guñu: “Tŭ buơl guhã tơma lăm sa sàng lơi, nư̆n kừ dò bĕ tơ anih nư̆n tơ̆l truh tơ tŭ tơbiă nau. ");
INSERT INTO cje_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Yah hũ anih lơi aràng 'buh wă-rò buơl guhã halài kơmlah 'buh khiăng păng pơnuaĭ buơl guhã, nư̆n tơbiă nau bĕ mư̆ng anih nư̆n, sơ̆ng tơrtuh hơbơu lơ̆n klĕm tơ tơkai buơl guhã tô ngă grơh tămdră-wơ̆ sơ̆ng buơl guñu.” ");
INSERT INTO cje_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Yơu nư̆n, du mơnih tui-mơgru tơbiă nau, pơto-akhàn lài abih tơgrơ̆ mơnih păl mơbai prah-luơi glài-sơnoh. ");
INSERT INTO cje_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Buơl guñu hũ pơtrơh lô kơmlài-jĭnràk, lŭ mơñà sơ̆ng pơsồ-pơsaih tơ lô mơnih lơ-ơ̆n lơngoh rơwă-sơkì. ");
INSERT INTO cje_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Pơtau Herôt mơhư̆ đờm mư̆ng Yàng Jêsu, kơyoa angăn Pô hũ lô mơnih thơu truh. Hũ mơnih đờm: “Nư̆n la Jăng 'Baptis mư̆ng mơnih mơtai hơdiŭ wơ̆, kơyoa nư̆n hũ rơgơi ngă jiơ̆ng du pơnuaĭ gơnăp-gơnuăr yơu nư̆n.” ");
INSERT INTO cje_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Du mơnih pơkơ̆n nư̆n đờm: “Nư̆n la Eli.” Du mơnih pơkơ̆n wơ̆ đờm: “Nư̆n la mơnih gơnuăr-hwơ̆r, mơhiơ̆ yơu du mơnih gơnuăr-hwơ̆r rài yau.” ");
INSERT INTO cje_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Bloh tŭ mơhư̆ yơu nư̆n, Herôt đờm: “Ni la rùp-phŭn Jăng, mơnih bloh kơu hũ koh tơkuai, tŭ ni ñu hơdiŭ wơ̆.” ");
INSERT INTO cje_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Bruă la yơu ni, rùp-phŭn Herôt hũ pơđăr mơnih mă Jăng, c̆aŭ wơ̆ sơ̆ng jàm ñu lăm anuh kơyoa mư̆ng bruă Herôdias, sơdiŭ Philip adơi pơtau, bloh pơtau hũ khiăng sơ̆ng ñu. ");
INSERT INTO cje_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Kơyoa Jăng hũ đờm sơ̆ng Herôt lài: “Pơtau 'buh hũ gơnuăr khiăng sơ̆ng sơdiŭ adơi lơkơi pơtau.” ");
INSERT INTO cje_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Nư̆n Herôdias anok-mơbai tơ Jăng sơ̆ng khiăng pơmơtai Jăng. Bloh ñu 'buh rơgơi pơmơtai jiơ̆ng, ");
INSERT INTO cje_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","kơyoa Herôt huơĭ tơ Jăng. Pơtau Herôt thơu Jăng la sa aràng mơnih rĭng-tơpă sơ̆ng sơc̆ih-sri, nư̆n pơtau sơđaŭ c̆ơ-gàr Jăng. Pơtau khiăng păng Jăng đờm, yah hơdơi yàu amăng păng, lăm hơtai-hơtiàn pơtau sơnư̆ng dò 'buh suk. ");
INSERT INTO cje_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Bloh, sa hơrơi hơnàn siàm hũ truh sơ̆ng Herôdias. Lăm hơrơi sơdơ̆r hơrơi đih apui pơtau Herôt, pơtau pồ sa pơnuaĭ mơñŭm 'bơ̆ng jà-rò du mơnih kwăng-prŏng lăm lơgăr, du mơnih kwăng apăn-akŏ lĭng, sơ̆ng du mơnih prŏng-màng lăm c̆àr Galile, truh mơñŭm 'bơ̆ng. ");
INSERT INTO cje_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Anà kơmơi Herôdias tơma, tăm-ya, ngă siàm hơtai pơtau Herôt sơ̆ng du mơnih thuai truh mơñŭm 'bơ̆ng, nư̆n pơtau đờm sơ̆ng kơmơi dra: “Yòng bĕ tơgrơ̆ pơnuaĭ hơgĕ anà khiăng, kơu rơŭ brơi tơ anà.” ");
INSERT INTO cje_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Pơtau kŭng tơpah-sri đờm sơ̆ng ñu: “Abih tơgrơ̆ pơnuaĭ hơgĕ anà yòng, kơu kŭng rơŭ brơi, yah yòng sa mơtưh lơgăr kŭng jiơ̆ng rơi.” ");
INSERT INTO cje_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Kơmơi dra nư̆n tơbiă nau tơnia ame ñu: “Anà păl yòng pơnuaĭ hơgĕ?” Ame ñu đờm: “Akŏ Jăng 'Baptis.” ");
INSERT INTO cje_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Kơmơi dra nư̆n tơmbah-tơmbàn nau tơma tòm pơtau bloh đờm yòng: “Anà khiăng pơtau brơi tơ anà akŏ Jăng Baptis daŭ lăm sơlào, tŭ ni mư.” ");
INSERT INTO cje_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Pơtau mă ngă dơnuh-dơnà biă, bloh kơyoa rơlau hũ đờm tơpah-sri tơ anaŭ abih tơgrơ̆ mơnih thuai truh mơñŭm 'bơ̆ng, nư̆n pơtau 'buh rơgơi đờm pơsơlih kơmlah wơ̆ jiơ̆ng sơ̆ng kơmơi dra nư̆n. ");
INSERT INTO cje_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Nư̆n pơtau pơđăr sa aràng mơnih lĭng nau sơ̆ng pơđăr apăn akŏ Jăng truh. ");
INSERT INTO cje_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Mơnih nư̆n tơma lăm sàng jàm koh akŏ Jăng, bloh nư̆n daŭ lăm sơlào sơ̆ng apăn brơi tơ kơmơi dra. Kơmơi dra apăn brơi tơ ame ñu. ");
INSERT INTO cje_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Du mơnih tui-mơgru Jăng mơhư̆ thơu pơnuaĭ nư̆n, truh mă rùp atơu ñu apăn nau, sơ̆ng dơ̆r lăm sa boh kŭt atơu. ");
INSERT INTO cje_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Du mơnih tơdi-tơdài pơgùm-pơtòm tòmdăr Yàng Jêsu, đờm akhàn wơ̆ sơ̆ng Pô mư̆ng abih tơgrơ̆ bruă buơl guñu hũ ngă sơ̆ng pơto-pơsài. ");
INSERT INTO cje_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Pô đờm sơ̆ng du mơnih tơdi-tơdài: “Buơl gudrơi pleh nau bĕ truh tơ sa anih jơhua-kơđơ̆ng tô pơdời gleh sa-sĭt.” Kơyoa hũ lô mơnih biă truh yòng tòm Yàng, tơ̆l truh Pô sơ̆ng du mơnih tơdi-tơdài 'buh hũ tŭ jơ tô huă 'bơ̆ng. ");
INSERT INTO cje_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Yơu nư̆n, Pô sơ̆ng du mơnih tơdi-tơdài trŭn gơlài tô nau truh tơ sa anih jơhua-kơđơ̆ng. ");
INSERT INTO cje_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Tŭ lô mơnih 'buh Yàng Jêsu sơ̆ng du mơnih tơdi-tơdài wah gơlài nau, sơ̆ng thơu anih lơi Yàng Jêsu sơ̆ng du mơnih tơdi-tơdài Pô rơŭ truh, nư̆n mư̆ng du plơi-prŏng buơl guñu ba gơŭ đuaĭ tơkai tui, sơ̆ng hũ truh tơ anih nư̆n dơlhơu. ");
INSERT INTO cje_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Pơrpa tơbiă mư̆ng gơlài, Yàng Jêsu 'buh sa tơrpuơl buơl làng lô biă dò c̆àng lờih, nư̆n Pô anĭt-rơnăm tơ buơl guñu, kơyoa buơl guñu yơu abo 'buh hũ mơnih glăng. Pô tơma pơto-pơsài lô pơnuaĭ tơ buơl guñu. ");
INSERT INTO cje_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Tŭ glai sùp bơjơ, du mơnih tui-mơgru truh đờm sơ̆ng Pô: “Anih ni jơhua-kơđơ̆ng biă, sơ̆ng glai kŭng kơjĕ sùp bơjơ, ");
INSERT INTO cje_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","yòng Pô-Pơto brơi buơl làng nau wơ̆, tô buơl guñu nau tơma lăm du plơi tìt sơ̆ng du plơi dò jĕ rò anih ni tô blơi phơ̆n-kơya 'bơ̆ng.” ");
INSERT INTO cje_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Bloh Pô đờm sơ̆ng buơl guñu: “Rùp-phŭn buơl guhã păl brơi buơl guñu 'bơ̆ng.” Du mơnih tui-mơgru đờm sơ̆ng Pô: “Buơl dơlhă păl nau blơi truh dua rơtùh đơnie priă pah tô brơi tơ buơl guñu 'bơ̆ng?” ");
INSERT INTO cje_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Pô tơnia du mơnih tui-mơgru: “Nau c̆ơ bĕ, buơl guhã hũ hơdùm boh pah?” Hơdơi tŭ yàu c̆ơ, du mơnih tui-mơgru đờm: “Hũ lơma boh pah sơ̆ng dua drơi akàn.” ");
INSERT INTO cje_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Pô pơđăr du mơnih tui-mơgru brơi buơl làng dò guh tui tơrpuơl lăm blàng rơ̆ mơtah. ");
INSERT INTO cje_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Buơl guñu dò guh tui tơrpuơl, tơrpuơl sa rơtùh, tơrpuơl lơma pluh. ");
INSERT INTO cje_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yàng Jêsu mă lơma boh pah sơ̆ng dua drơi akàn, tơ̆ mơta tơ ngŏ lơngì, ưnjơmừn, bloh nư̆n 'bĕt pah sơ̆ng brơi tơ du mơnih tui-mơgru tô pơrpha tơ buơl làng. Pô kŭng pơrpha dua drơi akàn tơ tơgrơ̆ mơnih. ");
INSERT INTO cje_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Abih yàu aràng 'bơ̆ng trơi. ");
INSERT INTO cje_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Buơl guñu duơ̆n wơ̆ hũ sa-pluh dua bài baŭ du pah sơ̆ng akàn dò dơlah. ");
INSERT INTO cje_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Khà mơnih 'bơ̆ng la lơma rơbơu aràng. ");
INSERT INTO cje_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Tŭ nư̆n mư, Yàng Jêsu pơjă pơđăr du mơnih tui-mơgru trŭn gơlài, nau dơlhơu truh tơ gah dih ia, gah plơi-prŏng 'Betsaiđa, lăm tŭ Pô brơi tơrpuơl buơl làng nau wơ̆. ");
INSERT INTO cje_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Hơdơi tŭ buơl guñu nau wơ̆ bơjơ, Pô đì tơ ngŏ c̆ơ̆ tô iơu-lài. ");
INSERT INTO cje_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Truh mơlăm, gơlài tơbiă truh tơkrah ia-tơsì bơjơ, bloh Yàng Jêsu sơđaŭ dò sa aràng Pô tơ ngŏ lơ̆n gah ia. ");
INSERT INTO cje_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Pô 'buh du mơnih tui-mơgru wah gơlài gleh-glăr biă kơyoa rơbù blùh tơrblơ̆, nư̆n pơgăp pà jơ ờm mơlăm nư̆n, Pô nau tơ ngŏ sơla ia-tơsì bloh truh sơ̆ng du mơnih tui-mơgru. Pô khiăng sơrlèt nau dơlhơu buơl guñu. ");
INSERT INTO cje_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Bloh tŭ 'buh Pô nau tơ ngŏ sơla ia-tơsì, du mơnih tui-mơgru sơnư̆ng la atơu, nư̆n driau prŏng, ");
INSERT INTO cje_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","kơyoa abih buơl guñu aràng sơi kŭng 'buh Pô sơ̆ng huơĭ kơđa biă. Bloh Yàng Jêsu đờm mư sơ̆ng buơl guñu: “Kơjăp-kơđơ̆ng hơtai-hơtiàn bĕ, Kơu ni, juơi huơĭ!” ");
INSERT INTO cje_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Bloh nư̆n Pô yàm tơma lăm gơlài sơ̆ng buơl guñu, sơ̆ng rơbù kơđơ̆ng rik. Du mơnih tui-mơgru mă ngă c̆rih-takơtuă biă. ");
INSERT INTO cje_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Kơyoa buơl guñu 'buh wờng jiơ̆ng pơnuaĭ c̆rih-krơi ngă pah tơbiă jiơ̆ng lô; kơyoa hơtai-hơtiàn buơl guñu sơđaŭ dò kră-khăng. ");
INSERT INTO cje_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Tŭ hũ truh tơ gah dih ia bơjơ, Yàng Jêsu sơ̆ng du mơnih tui-mơgru pleh tơma lăm c̆àr Genesaret, sơ̆ng pơdơh gơlài tơ gah ia. ");
INSERT INTO cje_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Pơrpa tơbiă mư̆ng gơlài, buơl làng sơmăr kràn thơu Pô mư, ");
INSERT INTO cje_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","nư̆n buơl guñu đuaĭ nau brơi pơthơu lăm abih c̆àr nư̆n, sơkồng du mơnih lơ-ơ̆n lơngoh rơwă-sơkì dò đih lăm c̆ơnừng truh sơ̆ng Pô; yah mơhư̆ Pô dò anih lơi nư̆n sơkồng ba truh tơ anih nư̆n. ");
INSERT INTO cje_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Abih tơgrơ̆ anih lơi Yàng Jêsu truh, lăm du plơi, du plơi-prŏng halài du plơi tìt, aràng kŭng ba du mơnih lơ-ơ̆n lơngoh rơwă-sơkì daŭ tơ du anih drà, sơ̆ng yòng lơkơu Pô brơi buơl guñu hũ rơwơ̆ tơ aku ào Pô; sơ̆ng abih tơgrơ̆ mơnih lơi hũ rơwơ̆ truh, nư̆n hũ pơsồ-pơsaih abih. ");
INSERT INTO cje_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Tŭ nư̆n hũ du mơnih Pharisi sơ̆ng du mơnih gơnuăr-pơto pơnuaĭ adăt-adia mư̆ng plơi-prŏng Jerusalem truh, pơtòm-pơgùm gơŭ tòmdăr Yàng Jêsu. ");
INSERT INTO cje_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Buơl guñu 'buh dua klơu aràng mơnih tui-mơgru Pô angui tơngàn 'buh goh-sơc̆ih bloh 'bơ̆ng, nư̆n la ka rào tơngàn dơlhơu tŭ 'bơ̆ng. ");
INSERT INTO cje_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Kơyoa du mơnih Pharisi kŭng yơu tơgrơ̆ mơnih Juđa sơđaŭ păng-rơmiă ngă tui pơnuaĭ adăt-lơđăp mơnih rài yau: buơl guñu rơŭ 'buh 'bơ̆ng hơgĕ yah ka rào tơngàn. ");
INSERT INTO cje_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Tŭ buơl guñu mư̆ng drà mơrai, yah 'buh ngă adăt pơsơc̆ih-goh dơlhơu, nư̆n buơl guñu rơŭ 'buh 'bơ̆ng. Buơl guñu kŭng dò păng-rơmiă ngă tui du pơnuaĭ adăt-lơđăp pơkơ̆n wơ̆, yơu ngă adăt pơsơc̆ih-goh jơlŭ c̆uàn, gơdi ia, sơ̆ng du phơ̆n angui ngă sơ̆ng kòng). ");
INSERT INTO cje_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Kơyoa nư̆n, du mơnih Pharisi sơ̆ng du mơnih gơnuăr-pơto pơnuaĭ adăt-adia tơnia Pô: “Kơđa hơgĕ du mơnih tui-mơgru Pô-Pơto 'buh hơdiŭ tui pơnuaĭ adăt-lơđăp mơnih yau, kừ luơi tơngàn sơŭ bloh 'bơ̆ng huă yơu nư̆n?” ");
INSERT INTO cje_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Pô đờm sơ̆ng buơl guñu: “Êsai hũ đờm hwơ̆r mư̆ng buơl guhã la du mơnih hơtai-hơtiàn mơthĭ-lơ̆r la tơpă iơŭ biă, yơu hũ wă lài: ‘Buơl làng ni mă sơ'buai bơbah duh-huơĭ Kơu, Bloh hơtai-hơtiàn buơl guñu atàh tơ Kơu biă. ");
INSERT INTO cje_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Bruă buơl guñu duh-dơlbăt Kơu la 'buh kwơ-màng, Du pơnuaĭ buơl guñu pơto mĭn la du pơnuaĭ adăt-pơđăr kơyoa mư̆ng jơi anà mơnih pơc̆eh tơbiă soh.’ ");
INSERT INTO cje_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Buơl guhã klà luơi pơnuaĭ adăt-pơđăr Yàng Pô Lơngì, bloh păng-rơmiă pơnuaĭ adăt-lơđăp jơi anà mơnih!” ");
INSERT INTO cje_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Pô kŭng đờm sơ̆ng buơl guñu: “Buơl guhã hũ khờh biă klà luơi pơnuaĭ adăt-pơđăr Yàng Pô Lơngì, tô păng-rơmiă pơnuaĭ adăt-lơđăp drơi! ");
INSERT INTO cje_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Kơyoa Môise hũ đờm: ‘Păng-duh bĕ tơ ame ama hã,’ sơ̆ng: ‘Aràng sơi alĕ-aluah ame ama, nư̆n păl kŏng pơmơtai.’ ");
INSERT INTO cje_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Bloh buơl guhã đờm: ‘Yah sa aràng mơnih đờm sơ̆ng ame ama drơi lài, tơgrơ̆ pơnuaĭ hơgĕ anà hũ rơgơi dŏng ame ama jiơ̆ng, anà hũ “korban” bơjơ’; mơblàng la: hũ apăn pơyă tơ Yàng Pô Lơngì bơjơ. ");
INSERT INTO cje_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Bloh nư̆n buơl guhã 'buh brơi gơnuăr mơnih nư̆n dŏng ame ama drơi pơnuaĭ hơgĕ tra. ");
INSERT INTO cje_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Kơyoa nư̆n, tŭ buơl guhã pơto aràng păng-rơmiă ngă tui du pơnuaĭ adăt-lơđăp drơi, nư̆n buơl guhã hũ prah-luơi pơnuaĭ Yàng Pô Lơngì pơto bơjơ. Buơl guhã dò ngă lô bruă pơkơ̆n mơhiơ̆ yơu nư̆n wơ̆.” ");
INSERT INTO cje_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Hơdơi mư̆ng nư̆n, Pô iơu buơl làng truh sơ̆ng đờm: “Abih buơl guhã păng bĕ Kơu đờm ni, sơ̆ng wờng tô loh-làng: ");
INSERT INTO cje_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","'Buh hũ phơ̆n hơgĕ mư̆ng agàh tơma lăm dơrlăm anà mơnih hũ rơgơi ngă sơŭ-sơnoh anà mơnih jiơ̆ng; bloh tơgrơ̆ hơgĕ tơbiă mư̆ng gah dơrlăm anà mơnih, nư̆n ka ngă sơŭ-sơnoh anà mơnih.” ");
INSERT INTO cje_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Aràng sơi hũ tơnia tô păng nư̆n păng-mơhư̆ bĕ. ");
INSERT INTO cje_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Tŭ Pô hũ tơma lăm sàng sơ̆ng đoh atàh mư̆ng tơrpuơl buơl làng bơjơ, du mơnih tui-mơgru tơnia Pô mư̆ng pơnuaĭ pơgăp-pơmơyơu nư̆n. ");
INSERT INTO cje_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Pô đờm sơ̆ng buơl guñu: “Yơu nư̆n bloh buơl guhã kŭng 'buh wờng ơu rơi? Buơl guhã 'buh thơu lài 'buh hũ phơ̆n hơgĕ mư̆ng agàh tơma bloh hũ rơgơi ngă tơ anà mơnih tơbiă jiơ̆ng sơŭ-sơnoh, ");
INSERT INTO cje_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","kơyoa phơ̆n nư̆n 'buh tơma lăm hơtai-hơtiàn anà mơnih, bloh mĭn tơma lăm tŭng, bloh nư̆n kŏng pơtơbiă tơ anih tơrđơŭ-tơrđe ơu?” Yơu nư̆n Pô khiăng đờm pơto lài abih tơgrơ̆ phơ̆n-kơya 'bơ̆ng la goh-sơc̆ih. ");
INSERT INTO cje_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Pô đờm wơ̆: “Pơnuaĭ hơgĕ mư̆ng dơrlăm anà mơnih tơbiă, pơnuaĭ nư̆n ka ngă tơ anà mơnih tơbiă jiơ̆ng sơŭ-sơnoh. ");
INSERT INTO cje_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Kơyoa mư̆ng gah dơrlăm hơtai-hơtiàn anà mơnih bloh tơbiă du pơnuaĭ sơnư̆ng sơŭ-jơhà, yơu pơnuaĭ dri-sơnoh bŭng-pơkăl, klĕ blơ̆, pơmơtai mơnih, ");
INSERT INTO cje_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","klĕ sơdiŭ-aràng pơsàng-gơŭ, hàm-làm, mơsak-jơhà, lơ̆r pơ̆ng-gơla, dri-hoàng, oàn-mơbai, yă-bơdah, pơglòng-rùp, mòih-hơnrui. ");
INSERT INTO cje_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Abih tơgrơ̆ pơnuaĭ sơŭ-jơhà nư̆n, la mư̆ng gah dơrlăm hơtai-hơtiàn bloh tơbiă, sơ̆ng ngă tơ anà mơnih tơbiă jiơ̆ng sơŭ-sơnoh.” ");
INSERT INTO cje_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yàng Jêsu tơgồ dơ̆ng, luơi anih nư̆n, nau truh tơ plơi-prŏng Tirơ sơ̆ng plơi-prŏng Siđôn. Pô tơma lăm sa boh sàng dih sơ̆ng 'buh khiăng brơi aràng sơi thơu Pô dò tơ anih nư̆n, bloh 'buh rơgơi bơdơŭ jiơ̆ng. ");
INSERT INTO cje_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Sa aràng mơnih kơmơi dih hũ anà kơmơi tìt kơđòng kơmlài ngă, pơrpa hũ mơhư̆ đờm mư̆ng Pô, lăm tơk truh pơđih rùp tơ tơkai Pô. ");
INSERT INTO cje_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Mơnih kơmơi nư̆n la mơnih Grek, lăm jơi mơnih Sirô-Phenisi. Ñu yòng Pô pơtrơh kơmlài tơbiă mư̆ng anà kơmơi ñu. ");
INSERT INTO cje_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yàng Jêsu đờm sơ̆ng ñu: “Păl luơi tơ anà 'bơ̆ng trơi dơlhơu ka, kơyoa mă pah pioh tơ anà bloh prah brơi tơ asơu 'bơ̆ng la pơnuaĭ 'buh iơŭ.” ");
INSERT INTO cje_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Bloh mơnih kơmơi đờm sơ̆ng Pô: “Khoai Yàng, iơŭ biă yơu nư̆n, bloh du asơu kŭng hũ gơnuăr 'bơ̆ng du pĕt pah hơ-mrùi du anà mư̆ng c̆ơnừng 'bơ̆ng hŏ trŭn.” ");
INSERT INTO cje_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Pô đờm sơ̆ng mơnih kơmơi: “Kơyoa hã hũ đờm yơu nư̆n. Nau wơ̆ bĕ. Kơmlài hũ tơbiă klàh mư̆ng anà kơmơi hã bơjơ.” ");
INSERT INTO cje_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Mơrai wơ̆ truh tơ sàng, ñu 'buh anà drơi dò đih lăm c̆ơnừng, sơ̆ng kơmlài hũ kŏng pơtrơh tơbiă bơjơ. ");
INSERT INTO cje_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yàng Jêsu luơi c̆àr Tirơ, nau găn plơi-prŏng Siđôn, truh tơ ia-tơsì Galile, sơ̆ng tơma lăm c̆àr-tơnah Đekapôl. ");
INSERT INTO cje_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Aràng ba truh tơ Pô sa aràng mơnih tĭ sơ̆ng gă, yòng lơkơu Pô daŭ tơngàn tơ ngŏ mơnih nư̆n. ");
INSERT INTO cje_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Pô ba mơnih nư̆n tơbiă krơi, đoh mư̆ng tơrpuơl mơnih lô, daŭ anà tơngàn lăm lơbàng tơnia ñu, sơ̆ng kơc̆uh ia bơbah bloh lŭ lăm dơlah ñu. ");
INSERT INTO cje_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Bloh nư̆n Pô tơ̆ mơta tơ ngŏ lơngì, să joa tơbiă sơ̆ng đờm: “Ephata!” mơblàng la: “Pơh tơbiă bĕ.” ");
INSERT INTO cje_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Lăm tơk tŭ nư̆n mư, tơnia mơnih nư̆n hũ mơhư̆, dơlah yơu 'buh kơđòng akă tra, sơ̆ng mơnih nư̆n đờm glai loh-làng. ");
INSERT INTO cje_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yàng Jêsu pơkơŭ buơl guñu 'buh hũ đờm pơnuaĭ ni sơ̆ng aràng sơi, bloh Pô 'brŏ pơkơŭ, buơl guñu 'brŏ đờm tiơ̆ng lô rơlau wơ̆. ");
INSERT INTO cje_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Buơl guñu mă ngă c̆rih-takơtuă biă, bloh đờm lài: “Pô ngă bruă hơgĕ kŭng siàm mơkrư soh: Pô ngă tơ mơnih tĭ mơhư̆ jiơ̆ng, mơnih kơmlo đờm jiơ̆ng!” ");
INSERT INTO cje_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Lăm du hơrơi nư̆n, hũ sa tơrpuơl lô buơl làng nau tui Yàng Jêsu, sơ̆ng buơl guñu 'buh hũ phơ̆n hơgĕ tô 'bơ̆ng, nư̆n Pô iơu du mơnih tui-mơgru truh sơ̆ng đờm: ");
INSERT INTO cje_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Kơu anĭt-anăr tơ tơrpuơl buơl làng ni. Kơyoa buơl guñu dò mĭt sơ̆ng Kơu klơu hơrơi ni bơjơ, sơ̆ng buơl guñu 'buh hũ phơ̆n hơgĕ tô 'bơ̆ng. ");
INSERT INTO cje_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Yah Kơu luơi buơl guñu tŭng lơpa nau wơ̆, nư̆n hũ rơgơi buơl guñu rơŭ lơphuơi-sơrngă rò jơlàn, kơyoa lăm buơl guñu hũ du mơnih mư̆ng anih atàh truh.” ");
INSERT INTO cje_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Du mơnih tui-mơgru đờm sơ̆ng Pô: “Lăm anih 'blàng-jơhua ni, ngă hơyơu hũ rơgơi duah tơ̆l pah brơi tơ buơl guñu 'bơ̆ng?” ");
INSERT INTO cje_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Pô tơnia buơl guñu: “Buơl guhã hũ hơdùm boh pah?” Buơl guñu đờm: “Hũ tơjuh boh.” ");
INSERT INTO cje_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Pô pơđăr tơrpuơl buơl làng dò guh lăm ala lơ̆n; mă tơjuh boh pah, ưnjơmừn, bloh nư̆n 'bĕt sơ̆ng brơi tơ du mơnih tui-mơgru tô buơl guñu pơrpha tơ buơl làng. ");
INSERT INTO cje_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Du mơnih tui-mơgru kŭng hũ du drơi akàn tìt; Yàng Jêsu ưnjơmừn, bloh nư̆n kŭng pơđăr apăn pơrpha yơu nư̆n rơi. ");
INSERT INTO cje_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Aràng sơi aràng nư̆n 'bơ̆ng trơi, sơ̆ng buơl guñu duơ̆n wơ̆ hũ tơjuh bài baŭ du pĕt pah dơlah. ");
INSERT INTO cje_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Khà mơnih 'bơ̆ng pơgăp pà rơbơu aràng. Yàng Jêsu brơi tơrpuơl buơl làng nau wơ̆. ");
INSERT INTO cje_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Hơdơi tŭ nư̆n mư, Pô sơ̆ng du mơnih tui-mơgru Pô trŭn lăm gơlài, nau truh tơ c̆àr Dalmanutha. ");
INSERT INTO cje_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Hũ du mơnih Pharisi truh sơ̆ng đờm tămpơrjai sơ̆ng Pô, buơl guñu yòng Pô ngă sa nàl-c̆rih mư̆ng ngŏ lơngì tô lòng Pô. ");
INSERT INTO cje_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yàng Jêsu să-joa prŏng lăm hơtai-hơtiàn sơ̆ng đờm: “Kơđa hơgĕ jơi-pơtiàn ni yòng c̆ơ nàl-c̆rih? Iơŭ biă, Kơu đờm sơ̆ng buơl guhã, rơŭ 'buh hũ sa nàl-c̆rih lơi hũ brơi tơ jơi-pơtiàn ni ơu.” ");
INSERT INTO cje_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Bloh nư̆n Pô luơi buơl guñu, tơma wơ̆ lăm gơlài, sơ̆ng nau tơ gah dih ia. ");
INSERT INTO cje_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Du mơnih tui-mơgru wơ̆rglai apăn pah tui, lăm gơlài mĭn hũ sa boh pah soh. ");
INSERT INTO cje_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yàng Jêsu đờm pơto-pơsơdơ̆r buơl guñu: “Buơl guhã păl kơrmăp-rùp sơ̆ng c̆ơ-kơrhia bĕ mư̆ng tơpơi mơnih Pharisi sơ̆ng tơpơi tơrpuơl Herôt.” ");
INSERT INTO cje_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Du mơnih tui-mơgru đờm tămbơyai sơ̆ng gơŭ: “Pô-Pơto đờm yơu nư̆n la kơyoa buơl gudrơi 'buh hũ pah.” ");
INSERT INTO cje_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Thơu pơnuaĭ nư̆n, Pô đờm sơ̆ng buơl guñu: “Kơđa hơgĕ buơl guhã đờm tămbơyai sơ̆ng gơŭ mư̆ng bruă buơl guhã 'buh hũ pah? Buơl guhã sơđaŭ ka thơu ka wờng ơu rơi? Hơtai-hơtiàn buơl guhã sơđaŭ kră-khăng mĭt yơu nư̆n? ");
INSERT INTO cje_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Kơđa hơgĕ buơl guhã hũ mơta bloh 'bu 'buh? Hũ tơnia bloh 'buh mơhư̆? Buơl guhã 'buh sơdơ̆r ơu? ");
INSERT INTO cje_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Tŭ Kơu 'bĕt lơma boh pah tơ lơma rơbơu mơnih 'bơ̆ng, buơl guhã duơ̆n wơ̆ hũ hơdùm bài baŭ pah dơlah?” Buơl guñu đờm: “Sa pluh dua bài.” ");
INSERT INTO cje_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Sơ̆ng tŭ Kơu 'bĕt tơjuh boh pah tơ pà rơbơu mơnih 'bơ̆ng, buơl guhã duơ̆n wơ̆ hũ hơdùm bài baŭ pah dơlah?” Buơl guñu đờm: “Tơjuh bài.” ");
INSERT INTO cje_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Pô đờm sơ̆ng buơl guñu: “Tŭ ni buơl guhã hũ wờng jơ?” ");
INSERT INTO cje_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yàng Jêsu sơ̆ng du mơnih tui-mơgru truh tơ plơi 'Betsaiđa Aràng ba truh tơ Pô sa aràng mơnih bồm sơ̆ng yòng lơkơu Pô tŭp truh mơnih nư̆n. ");
INSERT INTO cje_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Pô apăn tơngàn mơnih bồm, dùi ñu tơbiă tơ agàh plơi, lŭ ia bơbah tơ mơta ñu, bloh nư̆n daŭ tơngàn tơ ngŏ ñu sơ̆ng tơnia: “Hã hũ 'buh hơgĕ ơu?” ");
INSERT INTO cje_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Mơnih bồm c̆ơ tơ ngŏ sơ̆ng đờm: “Dơlhă 'buh aràng, sơ̆ng c̆ơ buơl guñu nau mơhiơ̆ yơu phŭn kơyơu.” ");
INSERT INTO cje_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yàng Jêsu daŭ tơngàn wơ̆ tơ mơta ñu. Ñu pơh mơta c̆ơ, mơta hũ sơrdah siàm, sơ̆ng ñu 'buh loh-làng abih tơgrơ̆ phơ̆n. ");
INSERT INTO cje_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yàng Jêsu pơđăr ñu nau wơ̆ sơ̆ng đờm kơkơi: “Hã juơi tơma wơ̆ lăm plơi.” ");
INSERT INTO cje_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yàng Jêsu sơ̆ng du mơnih tui-mơgru tơbiă nau mư̆ng anih nư̆n, truh lăm du plơi jĕ plơi-prŏng Sesare Philip. Lăm jơlàn nau, Pô tơnia du mơnih tui-mơgru: “Aràng đờm Kơu la aràng sơi?” ");
INSERT INTO cje_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Buơl guñu đờm: “Hũ mơnih đờm Pô-Pơto la Jăng 'Baptis. Mơnih pơkơ̆n đờm la Eli. Kŭng hũ mơnih đờm Pô-Pơto la sa aràng lăm du mơnih gơnuăr-hwơ̆r.” ");
INSERT INTO cje_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Pô tơnia buơl guñu: “Bloh buơl guhã nư̆n đờm Kơu la aràng sơi?” Pier đờm sơđồ: “Pô-Pơto la Pô Krist.” ");
INSERT INTO cje_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yàng Jêsu pơkơŭ buơl guñu 'buh hũ đờm mư̆ng Pô sơ̆ng aràng sơi. ");
INSERT INTO cje_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Tŭ nư̆n, Yàng Jêsu tơma đờm pơto du mơnih tui-mơgru lài Anà Mơnih păl kŏng lô pơnuaĭ pơđì-pơđoa gleh-glăr, păl kŏng du mơnih gơnuăr-tha, du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt sơ̆ng du mơnih gơnuăr-pơto pơnuaĭ adăt-adia kơmlah-luơi, păl kŏng pơmơtai, sơ̆ng hơdơi klơu hơrơi Pô rơŭ hơdiŭ wơ̆. ");
INSERT INTO cje_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Pô đờm loh-làng bruă ni sơ̆ng du mơnih tui-mơgru. Pier ba Pô tơbiă krơi sa-gah, sơ̆ng khă 'buah Pô. ");
INSERT INTO cje_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Bloh Yàng Jêsu pơtrah wơ̆ c̆ơ tơ du mơnih tui-mơgru, sơ̆ng đờm puaĭ tơ Pier lài: “Ơ Satăn, gơdŭn bĕ tơ gah rŏng Kơu! Kơyoa hã 'buh sơnư̆ng truh bruă Yàng Pô Lơngì, bloh mĭn sơnư̆ng truh bruă jơi anà mơnih soh.” ");
INSERT INTO cje_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Hơdơi mư̆ng nư̆n, Pô iơu buơl làng sơ̆ng du mơnih tui-mơgru truh bloh đờm: “Yah aràng sơi khiăng tui Kơu, păl prah luơi rùp-phŭn drơi, glăm kơyơu pơkăl drơi bloh tui Kơu. ");
INSERT INTO cje_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kơyoa aràng sơi khiăng dŏng pơnuaĭ hơdiŭ drơi nư̆n rơŭ lơhiă; dò aràng sơi kơyoa mư̆ng Kơu sơ̆ng Pơnuaĭ-Siàm bloh lơhiă pơnuaĭ hơdiŭ drơi, nư̆n rơŭ dŏng hũ pơnuaĭ hơdiŭ nư̆n. ");
INSERT INTO cje_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Mơnih lơi yah hũ abih dun-ya bloh lơhiă bơngă-joa drơi, nư̆n hũ kwơ-màng hơgĕ? ");
INSERT INTO cje_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Mơnih nư̆n rơŭ mă hơgĕ tô sơlih bơngă-joa drơi wơ̆? ");
INSERT INTO cje_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Kơyoa tơkrah jơi-pơtiàn dri-sơnoh bŭng-pơkăl ni, yah aràng sơi mơlơu alah mư̆ng Kơu sơ̆ng mư̆ng jơlàn păng-tui Kơu, nư̆n Anà Mơnih kŭng rơŭ mơlơu alah mư̆ng mơnih nư̆n, tŭ Pô truh mơrai găm sơ̆ng du mơnih gơdrưh sơc̆ih-sri Pô, lăm pơnuaĭ màng-kơc̆rà Ama Pô.” ");
INSERT INTO cje_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yàng Jêsu đờm sơ̆ng du mơnih tui-mơgru: “Iơŭ biă, Kơu đờm sơ̆ng buơl guhã, lăm du mơnih dò dơ̆ng tơ anih ni, hũ du mơnih rơŭ 'buh mơtai dơlhơu tơ tŭ 'buh lơgăr Yàng Pô Lơngì truh sơ̆ng pơnuaĭ gơnăp-gơnuăr.” ");
INSERT INTO cje_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Năm hơrơi hơdơi, Yàng Jêsu ba Pier, Jakơ sơ̆ng Jăng nau krơi sơ̆ng Pô đì tơ sa boh c̆ơ̆ glòng, sơ̆ng Pô sơrlơŭ-pơsơlih rùp tơ anaŭ buơl guñu. ");
INSERT INTO cje_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Khăn-ào Pô tơbiă jiơ̆ng sơrdah-kơc̆rà sơ̆ng kò-pơtih, tơ̆l truh 'buh hũ mơnih khờh boh lơi lăm dun-ya ni hũ rơgơi boh kò-pơtih jiơ̆ng yơu nư̆n. ");
INSERT INTO cje_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Eli sơ̆ng Môise tơbiă pơ'buh mơta, đờm glai sơ̆ng Yàng Jêsu. ");
INSERT INTO cje_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pier đờm sơ̆ng Yàng Jêsu: “Ơ Pô-Pơto, buơl gudrơi dò tơ anih ni siàm biă! Buơl dơlhă rơŭ ngă klơu boh pờ, sa boh tơ Pô-Pơto, sa boh tơ Môise, sơ̆ng sa boh tơ Eli.” ");
INSERT INTO cje_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pier đờm bloh 'buh thơu drơi đờm hơgĕ, kơyoa abih klơu aràng buơl guñu huơĭ kơđa biă. ");
INSERT INTO cje_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Bloh nư̆n hũ sa puk hwăl jơ̆m ac̆ĭng buơl guñu, sơ̆ng mư̆ng dơrlăm puk hwăl hũ săp đờm lài: “Ni la Anà Kơu uơ̆n-rơnăm, păng bĕ pơnuaĭ Anà nư̆n!” ");
INSERT INTO cje_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Mơre-mơro, du mơnih tui-mơgru c̆ơ tòmdăr, 'bu 'buh aràng sơi tra, mĭn dò sa aràng Yàng Jêsu sơ̆ng buơl guñu soh. ");
INSERT INTO cje_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Tŭ găm sơ̆ng du mơnih tui-mơgru mư̆ng c̆ơ̆ trŭn, Pô đờm kơkơi pơkơŭ buơl guñu 'buh hũ đờm tơ aràng sơi thơu du pơnuaĭ buơl guñu hũ 'buh, tơ̆l truh tơ tŭ Anà Mơnih mư̆ng pơnuaĭ mơtai hơdiŭ wơ̆. ");
INSERT INTO cje_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Du mơnih tui-mơgru pioh-sơdơ̆r pơnuaĭ nư̆n, sơ̆ng đờm tơnia gơŭ “mư̆ng pơnuaĭ mơtai hơdiŭ wơ̆” hũ mơblàng la hơgĕ. ");
INSERT INTO cje_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Bloh nư̆n buơl guñu truh tơnia Pô: “Kơđa hơgĕ du mơnih gơnuăr-pơto pơnuaĭ adăt-adia đờm lài: Eli păl truh dơlhơu ka?” ");
INSERT INTO cje_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Pô đờm: “Biă Eli păl truh dơlhơu tô ngă pơsiàm wơ̆ tơgrơ̆ bruă. Dò pơnuaĭ wă mư̆ng Anà Mơnih lài Pô păl kŏng lô pơnuaĭ pơđì-pơđoa gleh-glăr sơ̆ng kŏng aràng klau-pơtăt c̆ơ 'buh sơ̆p nư̆n hơyơu? ");
INSERT INTO cje_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Bloh Kơu đờm tô buơl guhã thơu, Eli hũ truh bơjơ, sơ̆ng aràng hũ ngă tơ ñu tui hơtai buơl guñu khiăng, iơŭ yơu pơnuaĭ hũ wă mư̆ng ñu rơi.” ");
INSERT INTO cje_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Tŭ Yàng Jêsu sơ̆ng klơu aràng mơnih tui-mơgru truh sơ̆ng du mơnih tui-mơgru pơkơ̆n, nư̆n 'buh sa tơrpuơl lô buơl làng dò pơgùm gơŭ tòmdăr buơl guñu, sơ̆ng hũ du mơnih gơnuăr-pơto pơnuaĭ adăt-adia dò đờm tămpơrjai sơ̆ng du mơnih tui-mơgru nư̆n. ");
INSERT INTO cje_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Pơrpa 'buh Pô, abih tơrpuơl mơnih lô mă ngă c̆rih-takơtuă biă. Buơl guñu đuaĭ truh ràn tơnia Pô. ");
INSERT INTO cje_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Pô tơnia buơl guñu: “Buơl guhã đờm tămpơrjai sơ̆ng du mơnih tui-mơgru mư̆ng bruă hơgĕ nư̆n?” ");
INSERT INTO cje_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Sa aràng lăm tơrpuơl mơnih lô đờm sơđồ: “Ơ Pô-Pơto, dơlhă hũ apăn anà lơkơi dơlhă truh tơ Pô-Pơto. Ñu kơđòng kơmlài kơmlo ngă. ");
INSERT INTO cje_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Yàu amăng kơmlài tơma ngă, nư̆n pơsơboh ñu lơbuh tơ ala, ngă tơbiă ia kơmbuh mư̆ng kàng, kĕ tơgơi, bloh nư̆n lơphuơi kơ̆ng mơnih. Dơlhă hũ yòng du mơnih tui-mơgru Pô-Pơto pơtrơh kơmlài nư̆n, bloh buơl guñu 'buh pơtrơh jiơ̆ng.” ");
INSERT INTO cje_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Pô đờm sơ̆ng buơl guñu: “Ơ jơi-pơtiàn 'buh păng-tui dih, Kơu rơŭ păl dò sơ̆ng buơl guhã tơ̆l truh tơ tŭ lơi? Kơu păl kŏng ă-ư̆n buơl guhã tơ̆l truh tơ tŭ lơi wơ̆? Ba bĕ adơi tìt truh tơ Kơu.” ");
INSERT INTO cje_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Buơl guñu ba adơi tìt truh tơ Pô. Pơrpa 'buh Yàng Jêsu, kơmlài lăm tơk pơsơboh khăng adơi tìt, ñu lơbuh tơ ala lơ̆n, pơrlơ̆ng pơrpơ̆ rùp, sơ̆ng kơmbuh kàng. ");
INSERT INTO cje_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yàng Jêsu tơnia ama adơi tìt: “Ñu kơđòng yơu ni hơdùm suơi bơjơ?” Mơnih ama đờm: “Mư̆ng tŭ ñu dò tìt. ");
INSERT INTO cje_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Kơmlài hũ lô amăng prah ñu tơma lăm apui, lăm ia, tô pơmơtai ñu. Bloh yah Pô-Pơto hũ rơgơi ngă jiơ̆ng hơgĕ, nư̆n yòng anĭt-anăr buơl dơlhă sơ̆ng dŏng mơ-ơna.” ");
INSERT INTO cje_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yàng Jêsu đờm: “Hơyơu hã đờm: yah Pô-Pơto hũ rơgơi ngă jiơ̆ng? Mơnih lơi păng-tui nư̆n tơgrơ̆ bruă hũ jiơ̆ng abih.” ");
INSERT INTO cje_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Lăm tŭ nư̆n mư, ama adơi tìt driau prŏng đờm: “Dơlhă păng-tui. Yòng Yàng dŏng-kờl dơlhă pha-jai rơlau tơ hơtai-hơtiàn 'buh păng-tui dơlhă!” ");
INSERT INTO cje_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Tŭ 'buh tơrpuơl lô buơl làng ba gơŭ truh, Yàng Jêsu puaĭ tơ kơmlài sơ̆ng đờm: “Ơ kơmlài kơmlo sơ̆ng tĭ dih, Kơu pơđăr hã păl tơbiă klàh mư̆ng adơi tìt ni, 'buh hũ tơma ngă ñu tra.” ");
INSERT INTO cje_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Kơmlài kơmrào prŏng, pơsơboh khăng adơi tìt bloh nư̆n tơbiă klàh. Adơi tìt tơbiă jiơ̆ng yơu mơnih mơtai, nư̆n lô mơnih đờm lài: “Ñu mơtai bơjơ.” ");
INSERT INTO cje_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Bloh Yàng Jêsu apăn tơngàn adơi tìt, đơ̆ng ñu tơgồ; sơ̆ng ñu tơgồ dơ̆ng. ");
INSERT INTO cje_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Tŭ Yàng Jêsu tơma lăm sàng bơjơ, du mơnih tui-mơgru truh tơnia krơi Pô: “Kơđa hơgĕ buơl dơlhă 'buh rơgơi pơtrơh jiơ̆ng kơmlài nư̆n?” ");
INSERT INTO cje_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Pô đờm: “Yah 'buh iơu-lài, nư̆n 'buh aràng sơi pơtrơh kơmlài nư̆n tơbiă jiơ̆ng.” ");
INSERT INTO cje_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Mư̆ng anih nư̆n, Yàng Jêsu sơ̆ng du mơnih tui-mơgru Pô nau găn c̆àr Galile, bloh Pô 'buh khiăng brơi aràng sơi thơu, ");
INSERT INTO cje_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","kơyoa Pô khiăng pơto-pơsài du mơnih tui-mơgru Pô. Pô đờm sơ̆ng buơl guñu: “Anà Mơnih rơŭ kŏng jào lăm tơngàn aràng. Buơl guñu rơŭ pơmơtai Pô, sơ̆ng Pô rơŭ mơtai. Hơdơi klơu hơrơi Pô rơŭ hơdiŭ wơ̆.” ");
INSERT INTO cje_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Bloh du mơnih tui-mơgru Pô 'buh wờng du pơnuaĭ nư̆n, sơ̆ng buơl guñu huơĭ bloh 'buh khĭn tơnia Pô. ");
INSERT INTO cje_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Yàng Jêsu sơ̆ng du mơnih tui-mơgru truh tơ plơi-prŏng Kapenaum. Tŭ tơma lăm sàng bơjơ, Pô tơnia du mơnih tui-mơgru: “Tŭ nau jơlàn, buơl guhã đờm tămpơrjai sơ̆ng gơŭ mư̆ng bruă hơgĕ nư̆n?” ");
INSERT INTO cje_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Bloh buơl guñu dò kơđơ̆ng rik, kơyoa lăm jơlàn nau buơl guñu hũ đờm tămpơrjai gơŭ c̆ơ aràng sơi la mơnih prŏng-màng rơlau abih. ");
INSERT INTO cje_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Pô dò guh, iơu sa-pluh dua aràng mơnih tơdi-tơdài sơ̆ng đờm: “Yah aràng sơi khiăng ngă mơnih akŏ, nư̆n păl ngă mơnih tơluĭ sơ̆ng păl ngă hơlŭn-hơlă tơ tơgrơ̆ mơnih.” ");
INSERT INTO cje_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Bloh nư̆n Pô ba sa aràng lơ-ơneh tìt daŭ tơkrah du mơnih tui-mơgru, Pô pồ adơi tìt lăm tơngàn sơ̆ng đờm: ");
INSERT INTO cje_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Aràng sơi kơyoa mư̆ng angăn Kơu bloh wă-rò sa aràng lơ-ơneh tìt yơu lơ-ơneh tìt ni, nư̆n la wă-rò Kơu. Sơ̆ng aràng sơi wă-rò Kơu, nư̆n 'buh iơŭ wă-rò Kơu, bloh wă-rò Pô hũ pơđăr Kơu.” ");
INSERT INTO cje_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jăng đờm sơ̆ng Pô: “Ơ Pô-Pơto, buơl dơlhă hũ 'buh mơnih mă angăn Pô bloh pơtrơh kơmlài, sơ̆ng buơl dơlhă hũ pơkơŭ mơnih nư̆n kơyoa mơnih nư̆n 'buh tui buơl gudrơi.” ");
INSERT INTO cje_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Bloh Yàng Jêsu đờm: “Juơi pơkơŭ buơl guñu, kơyoa 'buh aràng sơi hũ rơgơi mă angăn Kơu ngă bruă c̆rih-krơi, bloh nư̆n gài pơtrah wơ̆ đờm jơhà tơ Kơu jiơ̆ng. ");
INSERT INTO cje_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Aràng sơi 'buh tămdră-wơ̆ sơ̆ng buơl gudrơi la găm sơ̆ng buơl gudrơi. ");
INSERT INTO cje_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Kơyoa iơŭ biă, Kơu đờm sơ̆ng buơl guhã, aràng sơi brơi tơ buơl guhã sa c̆uàn ia mơrềt kơyoa buơl guhã la mơnih Pô Krist, mơnih nư̆n rơŭ 'buh lơhiă phơ̆n mơyòm-brơi drơi ơu. ");
INSERT INTO cje_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Bloh aràng sơi ngă tơ sa aràng lăm du lơ-ơneh tìt ni, la du mơnih hũ păng-tui Kơu bơjơ păl sơnĕ lơbuh lăm glài-sơnoh, nư̆n yah akă lơsŭng pơtơu prŏng lăm tơkuai mơnih nư̆n bloh prah trŭn lăm ia-tơsì dò siàm rơlau.” ");
INSERT INTO cje_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","“Yah tơngàn hã ngă tơ hã sơnĕ lơbuh lăm glài-sơnoh, nư̆n koh ñu bĕ; kơyoa yah tùt sa gah tơngàn bloh hũ tơma lăm pơnuaĭ hơdiŭ, dò siàm rơlau la hũ tơ̆l abih dua gah tơngàn bloh păl kŏng prah tơma lăm brŏng-apui, la anih apui 'buh tŭ lơi mơtai. ");
INSERT INTO cje_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Yah tơkai hã ngă tơ hã sơnĕ lơbuh lăm glài-sơnoh, nư̆n koh ñu bĕ; kơyoa yah tùt sa bĕ tơkai bloh hũ tơma lăm pơnuaĭ hơdiŭ, dò siàm rơlau la hũ tơ̆l abih dua bĕ tơkai bloh păl kŏng prah tơma lăm brŏng-apui. ");
INSERT INTO cje_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Yah mơta hã ngă tơ hã sơnĕ lơbuh lăm glài-sơnoh, nư̆n lơ-iok ñu bĕ; kơyoa yah tơrgloh sa gah mơta bloh hũ tơma lăm lơgăr Yàng Pô Lơngì, dò siàm rơlau la hũ tơ̆l abih dua gah mơta bloh păl kŏng prah tơma lăm brŏng-apui, ");
INSERT INTO cje_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","la anih hơlă-hơlĭng 'buh tŭ lơi mơtai sơ̆ng apui 'buh tŭ lơi mơtai. ");
INSERT INTO cje_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Kơyoa yàu aràng rơŭ kŏng pơđăm sơ̆ng apui. ");
INSERT INTO cje_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Sơra la phơ̆n siàm, bloh yah sơra lơhiă kơya 'bă, nư̆n mă hơgĕ ngă tô 'bă wơ̆ jiơ̆ng? Buơl guhã păl hũ sơra lăm hơtai-hơtiàn drơi, sơ̆ng hơdiŭ hơlàr-siàm sơ̆ng gơŭ.” ");
INSERT INTO cje_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yàng Jêsu luơi anih nư̆n, nau truh tơ c̆àr Juđe sơ̆ng c̆àr gah dih ia sơdờng Jôđăn. Du tơrpuơl buơl làng pơgùm-pơtòm wơ̆ tòmdăr Pô, sơ̆ng yơu lơđăp bơhiàn, Pô pơto-pơsài buơl guñu. ");
INSERT INTO cje_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Hũ du mơnih Pharisi truh tơnia tô lòng Pô: “Mơnih lơkơi hũ gơnuăr pơkloh sơdiŭ ơu?” ");
INSERT INTO cje_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Pô đờm: “Môise hũ pơto-pơđăr buơl guhã pơnuaĭ hơgĕ?” ");
INSERT INTO cje_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Buơl guñu đờm: “Môise hũ brơi gơnuăr mơnih lơkơi wă sa blah bơ-àr pơkloh bloh nư̆n pơkloh sơdiŭ.” ");
INSERT INTO cje_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yàng Jêsu đờm sơ̆ng buơl guñu: “Kơyoa hơtai-hơtiàn buơl guhã kră-khăng, nư̆n Môise hũ wă pơnuaĭ adăt-pơđăr ni tơ buơl guhã. ");
INSERT INTO cje_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Bloh mư̆ng tŭ c̆ơmrừp c̆rơ̆ng-tơbiă lơngì-tơsì tơnah-rơya, Yàng Pô Lơngì mĭn pơjiơ̆ng tơbiă sa aràng mơnih lơkơi sơ̆ng sa aràng mơnih kơmơi. ");
INSERT INTO cje_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Kơyoa nư̆n, mơnih lơkơi păl tơbiă mư̆ng ame ama bloh pơc̆uăl-pơtòm sơ̆ng sơdiŭ, ");
INSERT INTO cje_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","sơ̆ng dua aràng rơŭ tơbiă jiơ̆ng sa rùp-phàp soh. Kơyoa nư̆n, sơdiŭ-pơsàng 'buh iơŭ la dua tra, bloh mĭn la sa. ");
INSERT INTO cje_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Yơu nư̆n, jơi anà mơnih 'buh hũ pơklah-krơi du mơnih bloh Yàng Pô Lơngì hũ pơc̆uăl-pơtòm.” ");
INSERT INTO cje_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Tŭ tơma lăm sàng bơjơ, du mơnih tui-mơgru tơnia Pô wơ̆ mư̆ng bruă nư̆n. ");
INSERT INTO cje_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Pô đờm sơ̆ng buơl guñu: “Aràng sơi pơkloh sơdiŭ bloh khiăng sơ̆ng mơnih pơkơ̆n, la ngă glài klĕ sơdiŭ-aràng pơsàng-gơŭ sơ̆ng sơdiŭ drơi, ");
INSERT INTO cje_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","sơ̆ng aràng sơi pơkloh pơsàng tô khiăng sơ̆ng mơnih pơkơ̆n, nư̆n kŭng ngă glài klĕ sơdiŭ-aràng pơsàng-gơŭ rơi.” ");
INSERT INTO cje_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Aràng ba du lơ-ơneh tìt truh sơ̆ng Yàng Jêsu tô Pô daŭ tơngàn tơ ngŏ guñu, bloh du mơnih tui-mơgru Pô đờm puaĭ 'buah du mơnih ba truh. ");
INSERT INTO cje_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","'Buh yơu nư̆n, Yàng Jêsu anok hơtai bloh đờm sơ̆ng du mơnih tui-mơgru: “Luơi bĕ du lơ-ơneh tìt truh sơ̆ng Kơu, juơi pơkơŭ-c̆ơkhă guñu, kơyoa lơgăr Yàng Pô Lơngì la găm sơ̆ng du mơnih lơi hũ hơtai-hơtiàn mơhiơ̆ yơu du lơ-ơneh tìt nư̆n. ");
INSERT INTO cje_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Iơŭ biă, Kơu đờm sơ̆ng buơl guhã, yah aràng sơi 'buh đồ-mă lơgăr Yàng Pô Lơngì yơu sa aràng lơ-ơneh tìt, nư̆n rơŭ 'buh hũ tơma lăm nư̆n jiơ̆ng.” ");
INSERT INTO cje_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Bloh nư̆n Pô pồ du lơ-ơneh tìt, daŭ tơngàn tơ ngŏ guñu, sơ̆ng brơi lơngai-pơtuah tơ guñu. ");
INSERT INTO cje_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Tŭ Pô pơrpa tơbiă nau, nư̆n hũ sa aràng mơnih đuaĭ truh, c̆ĕ-khoai tơ anaŭ Pô sơ̆ng đờm: “Ơ Pô-Pơto sơc̆ih-siàm, dơlhă păl ngă hơgĕ tô hũ đồ-mă pơnuaĭ hơdiŭ rài pơdò rài?” ");
INSERT INTO cje_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yàng Jêsu đờm: “Kơđa hơgĕ hã iơu Kơu la sơc̆ih-siàm? 'Buh hũ aràng sơi la sơc̆ih-siàm ơu, mĭn hũ sa Pô sơc̆ih-siàm, la Yàng Pô Lơngì. ");
INSERT INTO cje_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Hã hũ thơu du pơnuaĭ adăt-pơđăr: ‘Hã juơi pơmơtai mơnih; hã juơi klĕ sơdiŭ-aràng pơsàng-gơŭ; hã juơi klĕ blơ̆; hã juơi ngă grơh lơ̆r; hã juơi gàt pơ̆ng-gơla; sơ̆ng hã păl păng-duh ame ama.’ ” ");
INSERT INTO cje_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Mơnih nư̆n đờm: “Ơ Pô-Pơto, dơlhă hũ păng-rơmiă ngă tui abih tơgrơ̆ pơnuaĭ nư̆n mư̆ng tŭ dơlhă dò lơ-ơneh.” ");
INSERT INTO cje_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yàng Jêsu anĭt-rơnăm c̆ơ tơ ñu sơ̆ng đờm: “Hã dò siơŭ sa pơnuaĭ. Nau bĕ, pơblơi abih tơgrơ̆ hơgĕ drơi hũ, apăn priă brơi pơrpha tơ mơnih rơ'bah, tô hã rơŭ hũ phơ̆n-bơna c̆ơk-màng tơ ngŏ lơngì; bloh nư̆n truh bĕ tui Kơu.” ");
INSERT INTO cje_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Tŭ păng Yàng Jêsu đờm yơu nư̆n, 'bò mơta ñu tơbiă jiơ̆ng jruh-jrui biă, sơ̆ng dơnuh-dơnà tơbiă nau, kơyoa ñu hũ lô phơ̆n-bơna biă. ");
INSERT INTO cje_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Tŭ nư̆n Yàng Jêsu c̆ơ tòmdăr drơi, bloh đờm sơ̆ng du mơnih tui-mơgru lài: “Mơnih mơda tơma lăm lơgăr Yàng Pô Lơngì la kăn-ke biă!” ");
INSERT INTO cje_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Du mơnih tui-mơgru mă ngă krơi-takơtuă biă mư̆ng du pơnuaĭ nư̆n. Bloh Yàng Jêsu đờm wơ̆: “Ơ buơl anà, du mơnih lơi gơnừm tơ pơnuaĭ mơda gơn-hư̆p tô hũ tơma lăm lơgăr Yàng Pô Lơngì la kăn-ke biă-biài! ");
INSERT INTO cje_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Lakđa rŏ tơma găn lơbàng jrŭm dò 'buơ̆n rơlau tơ mơnih mơda tơma lăm lơgăr Yàng Pô Lơngì.” ");
INSERT INTO cje_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Du mơnih tui-mơgru mă ngă krơi-takơtuă rơlau wơ̆, đờm sơ̆ng gơŭ: “Yơu nư̆n, aràng sơi hũ dŏng-pơklàh?” ");
INSERT INTO cje_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yàng Jêsu c̆ơ tơ buơl guñu sơ̆ng đờm: “Jơi anà mơnih 'buh rơgơi ngă jiơ̆ng bruă ni, bloh sơ̆ng Yàng Pô Lơngì nư̆n krơi; kơyoa Yàng Pô Lơngì rơgơi ngă jiơ̆ng abih tơgrơ̆ mơta.” ");
INSERT INTO cje_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pier pồ-săp đờm: “Ơ Pô-Pơto, buơl dơlhă hũ klà luơi abih tơgrơ̆ mơta bloh tui Pô-Pơto.” ");
INSERT INTO cje_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yàng Jêsu đờm: “Iơŭ biă, Kơu đờm sơ̆ng buơl guhã, 'buh sa aràng mơnih lơi kơyoa Kơu sơ̆ng Pơnuaĭ-Siàm klà luơi sàng-dơnò, adơi-ai, gơŭ kơmơi, ame ama, anà-tơc̆o, hơma tơnah, ");
INSERT INTO cje_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","bloh rơŭ 'buh đồ-mă hũ lăm tŭ ni, lăm rài ni, rơtùh amăng rơlau mư̆ng sàng-dơnò, adơi-ai, gơŭ kơmơi, ame, anà, hơma tơnah, găm sơ̆ng pơnuaĭ mă-pơkơŭ, sơ̆ng pơnuaĭ hơdiŭ rài pơdò rài lăm rài hơdơi. ");
INSERT INTO cje_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Bloh hũ lô mơnih akŏ rơŭ tơbiă jiơ̆ng tơluĭ, sơ̆ng mơnih tơluĭ rơŭ tơbiă jiơ̆ng akŏ.” ");
INSERT INTO cje_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yàng Jêsu sơ̆ng du mơnih tui-mơgru lăm jơlàn đì nau tơ plơi-prŏng Jerusalem, Pô nau dơlhơu buơl guñu. Du mơnih tui-mơgru mă ngă krơi-takơtuă, dò du mơnih nau tui nư̆n huơĭ kơđa biă. Pô ba sa-pluh dua aràng mơnih tơdi-tơdài nau krơi sơ̆ng Pô, sơ̆ng đờm tơ buơl guñu thơu tơgrơ̆ bruă hơgĕ rơŭ tơbiă truh tơ drơi. ");
INSERT INTO cje_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Pô đờm: “Ni, buơl gudrơi đì tơ plơi-prŏng Jerusalem, Anà Mơnih rơŭ kơđòng jào lăm tơngàn du mơnih gơnuăr apăn-akŏ c̆ĕ-pơyơ̆r phơ̆n duh-dơlbăt sơ̆ng du mơnih gơnuăr-pơto pơnuaĭ adăt-adia. Buơl guñu rơŭ ngă nìn-glài pơmơtai Pô, bloh nư̆n jào Pô lăm tơngàn buơl làng agàh. ");
INSERT INTO cje_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Aràng rơŭ klau-pơtăt Pô, kơc̆uh ia bơbah lăm Pô, glih pờng sơ̆ng pơmơtai Pô. Bloh hơdơi klơu hơrơi, Pô rơŭ hơdiŭ wơ̆.” ");
INSERT INTO cje_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Tŭ nư̆n, dua aràng anà lơkơi Sebede la Jakơ sơ̆ng Jăng, truh tòm Yàng Jêsu sơ̆ng đờm: “Ơ Pô-Pơto, buơl dơlhă lơkơu khiăng Pô-Pơto ngă tơ buơl dơlhă du pơnuaĭ buơl dơlhă rơŭ yòng.” ");
INSERT INTO cje_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Pô tơnia: “Buơl guhã khiăng Kơu ngă hơgĕ tơ buơl guhã?” ");
INSERT INTO cje_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Buơl guñu đờm: “Tŭ Pô-Pơto hũ màng-kơc̆rà, yòng brơi dua aràng buơl dơlhă sa aràng dò guh gah hơnuă, sa aràng dò guh gah ơñiau Pô-Pơto.” ");
INSERT INTO cje_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Bloh Yàng Jêsu đờm: “Buơl guhã 'buh thơu pơnuaĭ drơi yòng. Buơl guhã hũ rơgơi mơñŭm jiơ̆ng c̆uàn Kơu mơñŭm, sơ̆ng kŏng pơnuaĭ 'baptem Kơu kŏng ơu?” ");
INSERT INTO cje_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Buơl guñu đờm: “Buơl dơlhă rơgơi.” Yàng Jêsu đờm sơ̆ng buơl guñu: “C̆uàn Kơu mơñŭm, buơl guhã kŭng rơŭ mơñŭm, sơ̆ng 'baptem Kơu kŏng, buơl guhã kŭng rơŭ kŏng. ");
INSERT INTO cje_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Bloh bruă dò guh tơ gah hơnuă halài gah ơñiau Kơu, nư̆n Kơu 'buh hũ gơnuăr brơi, du anih nư̆n pioh tơ du mơnih hũ rơc̆ăng ngă-nìn dơlhơu.” ");
INSERT INTO cje_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Mơhư̆ yơu nư̆n, sa-pluh aràng mơnih tui-mơgru dih anok hơtai tơ Jakơ sơ̆ng Jăng. ");
INSERT INTO cje_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Bloh Yàng Jêsu iơu buơl guñu truh sơ̆ng đờm: “Buơl guhã thơu lài du mơnih hũ c̆ơ la gơnuăr apăn-akŏ lăm buơl làng agàh nư̆n angui gơnuăr-pràn bloh apăn-akŏ buơl làng, du mơnih ngă prŏng nư̆n mă gơnuăr bloh apăn-akŏ buơl làng. ");
INSERT INTO cje_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Bloh tơkrah buơl guhã nư̆n 'buh iơŭ yơu nư̆n. Tơrblơ̆ wơ̆, aràng sơi khiăng ngă prŏng lăm buơl guhã, mơnih nư̆n păl ngă mơnih duh bruă tơ buơl guhã; ");
INSERT INTO cje_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","aràng sơi khiăng ngă mơnih akŏ lăm buơl guhã, nư̆n păl ngă hơlŭn-hơlă tơ tơgrơ̆ mơnih. ");
INSERT INTO cje_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Kơyoa Anà Mơnih hũ truh 'buh iơŭ tô hũ aràng duh bruă, bloh la tô drơi duh bruă, sơ̆ng prah-luơi pơnuaĭ hơdiŭ drơi ngă jiơ̆ng phơ̆n tơrbuh tơ lô mơnih.” ");
INSERT INTO cje_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yàng Jêsu sơ̆ng du mơnih tui-mơgru truh tơ plơi-prŏng Jerikô. Tŭ Pô sơ̆ng du mơnih tui-mơgru găm sơ̆ng tơrpuơl buơl làng lô tơbiă nau mư̆ng plơi-prŏng Jerikô, nư̆n hũ sa aràng mơnih bồm angăn la 'Batime, anà lơkơi Time, dò guh yòng tơ gah jơlàn. ");
INSERT INTO cje_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Tŭ mơhư̆ đờm hũ Yàng Jêsu, mơnih Nasaret kơjĕ nau găn, ñu driau iơu prŏng lài: “Khoai Yàng Jêsu, Anà pơtau Đabit, yòng anĭt-anăr dơlhă!” ");
INSERT INTO cje_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Lô mơnih đờm puaĭ tơ ñu, sơ̆ng pơđăr ñu păl kơđơ̆ng kàng, bloh ñu 'brŏ driau prŏng rơlau wơ̆: “Khoai Anà pơtau Đabit, yòng anĭt-anăr dơlhă!” ");
INSERT INTO cje_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yàng Jêsu dò dơ̆ng wơ̆, sơ̆ng đờm: “Iơu bĕ mơnih nư̆n truh tơ anih ni.” Buơl guñu iơu mơnih bồm sơ̆ng đờm: “Kơđơ̆ng-kơjăp hơtai-hơtiàn bĕ, tơgồ dơ̆ng, Pô iơu hã nư̆n!” ");
INSERT INTO cje_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Mơnih bồm wà prah ào agàh, tơgồ dơ̆ng sừp mư, nau truh sơ̆ng Yàng Jêsu. ");
INSERT INTO cje_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yàng Jêsu tơnia: “Hã khiăng Kơu ngă hơgĕ tơ hã?” Mơnih bồm đờm: “Ơ Pô-Pơto, yòng brơi mơta dơlhă c̆ơ 'buh jiơ̆ng.” ");
INSERT INTO cje_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yàng Jêsu đờm: “Nau bĕ, pơnuaĭ păng-tui hã hũ pơsồ-pơsaih hã.” Lăm tơk tŭ nư̆n mư, mơnih bồm hũ c̆ơ 'buh jiơ̆ng, sơ̆ng nau tui Yàng Jêsu. ");
INSERT INTO cje_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Tŭ Yàng Jêsu sơ̆ng du mơnih tui-mơgru Pô truh jĕ plơi-prŏng Jerusalem, jĕ plơi 'Betphage sơ̆ng 'Bethani, găn c̆ơ̆ Ôlibe, Yàng Jêsu pơđăr dua aràng mơnih tui-mơgru nau, ");
INSERT INTO cje_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","sơ̆ng đờm: “Nau tơma bĕ lăm plơi tơ anaŭ buơl guhã, tŭ pơrpa tơma lăm plơi, buơl guhã rơŭ 'buh mư sa drơi alàng, aràng akă lờih tơ anih nư̆n, alàng nư̆n ka hũ aràng sơi đì. Tơleh bĕ tơlơi sơ̆ng dùi ñu mơrai tơ Kơu. ");
INSERT INTO cje_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Yah hũ aràng sơi tơnia buơl guhã: ‘Kơđa hơgĕ buơl sơ-ai ngă yơu nư̆n?’ nư̆n đờm sơđồ bĕ: ‘Yàng khiăng angui ñu, sơ̆ng Pô rơŭ bơ-yàr wơ̆ mư.’ ” ");
INSERT INTO cje_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Dua aràng buơl guñu nau sơ̆ng 'buh tơ gah jơlàn hũ sa drơi alàng anà aràng akă tơ anaŭ bơh 'băng sàng. Buơl guñu tơleh tơlơi alàng. ");
INSERT INTO cje_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Du mơnih dò dơ̆ng tơ anih nư̆n tơnia: “Buơl sơ-ai tơleh alàng anà nư̆n tô ngă hơgĕ?” ");
INSERT INTO cje_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Dua aràng buơl guñu đờm sơđồ iơŭ yơu Yàng Jêsu hũ kơkơi pơđăr. Sơ̆ng du mơnih nư̆n brơi buơl guñu dùi alàng nau. ");
INSERT INTO cje_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Buơl guñu dùi alàng anà mơrai tơ Yàng Jêsu, làng ào drơi tơ rŏng alàng, bloh nư̆n Yàng Jêsu đì tơ ngŏ. ");
INSERT INTO cje_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Lô mơnih làng ào drơi lăm jơlàn. Du mơnih pơkơ̆n nư̆n koh du thàn sơla mư̆ng 'blàng hơma bloh tràh lăm jơlàn. ");
INSERT INTO cje_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Bloh nư̆n mơnih nau dơlhơu, mơnih tui hơdơi, sơ̆ng gơŭ driau prŏng lài: “Hôsana! Mơyòm-pơglòng tơ Pô mă angăn Yàng bloh truh! ");
INSERT INTO cje_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Lơngai-pơtuah tơ lơgăr kơjĕ truh, la lơgăr pơtau Đabit, kơi-kŏ pàng-yau buơl gudrơi! Hôsana tơ anih glòng rơlau abih.” ");
INSERT INTO cje_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yàng Jêsu truh tơ plơi-prŏng Jerusalem sơ̆ng nau tơma lăm sàng duh-dơlbăt. Hơdơi tŭ c̆ơ sơ'buai abih tơgrơ̆ bruă tòmdăr, Pô găm sơ̆ng sa-pluh dua aràng mơnih tui-mơgru gài mơrai wơ̆ tơ plơi 'Bethani, kơyoa tŭ nư̆n lơngì sùp bơjơ. ");
INSERT INTO cje_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Hơrơi hơdơi, tŭ tơbiă mư̆ng plơi 'Bethani, nư̆n Pô lơpa tŭng. ");
INSERT INTO cje_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Mư̆ng atàh Pô 'buh sa phŭn hra hũ sơla, nư̆n truh c̆ơ hũ hơgĕ lăm phŭn kơyơu ơu. Bloh tŭ truh jĕ, Pô 'bu 'buh hơgĕ pơkơ̆n, mĭn 'buh du sơla soh, kơyoa tŭ nư̆n 'buh iơŭ la blàn boh hra. ");
INSERT INTO cje_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Pô đờm sơ̆ng kơyơu hra: “Mư̆ng ni truh hơdơi, rơŭ 'buh hũ aràng sơi 'bơ̆ng boh hã tra.” Du mơnih tui-mơgru Pô hũ mơhư̆ pơnuaĭ Pô đờm puaĭ nư̆n. ");
INSERT INTO cje_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yàng Jêsu sơ̆ng du mơnih tui-mơgru truh tơ plơi-prŏng Jerusalem. Pô tơma lăm sàng duh-dơlbăt, prơh abih du mơnih pơblơi-sơlih lăm anih sàng duh-dơlbăt. Pô pơlơbuh c̆ơnừng du mơnih sơlih priă, sơ̆ng tơlơ̆ gơnŭl du mơnih pơblơi c̆ĭm kơtrơu. ");
INSERT INTO cje_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Pô 'buh brơi aràng sơi apăn phơ̆n hơgĕ nau găn sàng duh-dơlbăt. ");
INSERT INTO cje_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Bloh nư̆n Pô pơto-pơsài buơl guñu: “'Buh iơŭ hũ pơnuaĭ wă lài: ‘Sàng Kơu rơŭ hũ angăn la sàng iơu-lài tơ abih tơgrơ̆ buơl làng’ ơu? Bloh buơl guhã hũ ngă tơ anih nư̆n tơbiă jiơ̆ng gồ-lơbàng buơl klĕ-blơ̆.” ");
INSERT INTO cje_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Tŭ du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt sơ̆ng du mơnih gơnuăr-pơto pơnuaĭ adăt-adia mơhư̆ yơu nư̆n, buơl guñu duah pơnuaĭ tô pơmơtai Pô. Bloh buơl guñu huơĭ tơ Pô, kơyoa abih tơrpuơl buơl làng mă ngă c̆rih-krơi biă mư̆ng pơnuaĭ Pô pơto-mơblàng. ");
INSERT INTO cje_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Truh diơŭ, Yàng Jêsu sơ̆ng du mơnih tui-mơgru tơbiă mư̆ng plơi-prŏng. ");
INSERT INTO cje_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ờm hơrơi hơdơi, tŭ nau găn kơyơu hra, buơl guñu 'buh kơyơu hra mơtai thu truh tơ akha. ");
INSERT INTO cje_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pier sơdơ̆r wơ̆ pơnuaĭ hơrơi kơbrơi nư̆n đờm sơ̆ng Pô: “Ơ Pô-Pơto, c̆ơ dih! Kơyơu hra bloh Pô-Pơto đờm puaĭ hũ mơtai thu bơjơ.” ");
INSERT INTO cje_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yàng Jêsu đờm: “Buơl guhã păl hũ bĕ pơnuaĭ păng-tui anih Yàng Pô Lơngì. ");
INSERT INTO cje_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Iơŭ biă, Kơu đờm sơ̆ng buơl guhã, aràng sơi đờm sơ̆ng c̆ơ̆ ni lài: ‘Pồ tơgồ bĕ, sơ̆ng prah trŭn lăm ia-tơsì,’ yah lăm hơtai-hơtiàn mơnih nư̆n 'buh sa-sĭt lơi sơnư̆ng pah-koh wĭ-wơ̆, bloh păng-tui pơnuaĭ drơi đờm rơŭ tơbiă truh, nư̆n pơnuaĭ nư̆n rơŭ tơbiă truh tơ mơnih nư̆n. ");
INSERT INTO cje_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kơyoa nư̆n, Kơu đờm sơ̆ng buơl guhã, abih tơgrơ̆ pơnuaĭ hơgĕ buơl guhã yòng lăm tŭ iơu-lài, păng-tui bĕ la drơi hũ đồ-mă bơjơ, nư̆n buơl guhã rơŭ hũ pơnuaĭ nư̆n. ");
INSERT INTO cje_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Tŭ buơl guhã dò dơ̆ng iơu-lài, yah hũ pơnuaĭ hơgĕ 'buh siàm hơtai sơ̆ng aràng sơi, nư̆n păl anĭt toh-luơi bĕ tơ buơl guñu, tô Ama buơl guhã tơ ngŏ lơngì kŭng rơŭ anĭt toh-luơi du pơnuaĭ glài sŭng tơ buơl guhã rơi. ");
INSERT INTO cje_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Bloh yah buơl guhã 'buh anĭt toh-luơi, nư̆n Ama buơl guhã tơ ngŏ lơngì, kŭng rơŭ 'buh anĭt toh-luơi glài sŭng tơ buơl guhã ơu rơi.” ");
INSERT INTO cje_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yàng Jêsu sơ̆ng du mơnih tui-mơgru Pô gài wơ̆ tơ plơi-prŏng Jerusalem. Tŭ Pô dò nau lăm sàng duh-dơlbăt, nư̆n du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt, du mơnih gơnuăr-pơto pơnuaĭ adăt-adia, sơ̆ng du mơnih gơnuăr-tha truh tòm Pô. ");
INSERT INTO cje_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Buơl guñu tơnia: “Pô-Pơto mă gơnuăr lơi bloh ngă du bruă ni? Aràng sơi brơi tơ Pô-Pơto gơnuăr tô ngă du bruă nư̆n?” ");
INSERT INTO cje_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yàng Jêsu đờm: “Kơu kŭng tơnia buơl guhã sa pơnuaĭ, buơl guhã đờm sơđồ bĕ tơ Kơu, nư̆n Kơu rơŭ đờm tơ buơl guhã thơu Kơu ngă du bruă ni kơyoa mư̆ng gơnuăr lơi. ");
INSERT INTO cje_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Pơnuaĭ 'baptem Jăng 'Baptis truh mư̆ng ngŏ lơngì halài mư̆ng jơi anà mơnih? Đờm sơđồ bĕ tơ Kơu.” ");
INSERT INTO cje_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Buơl guñu đờm tămbơyai sơ̆ng gơŭ: “Yah buơl gudrơi đờm: ‘Mư̆ng ngŏ lơngì’ nư̆n ñu rơŭ đờm: ‘Yơu nư̆n, kơđa hơgĕ buơl guhã 'buh păng-tui Jăng?’ ");
INSERT INTO cje_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Bloh yah buơl gudrơi đờm: ‘Mư̆ng jơi anà mơnih’?” — Buơl guñu huơĭ tơ buơl làng. Kơyoa aràng sơi aràng nư̆n kŭng c̆ơ Jăng la sa aràng mơnih gơnuăr-hwơ̆r. ");
INSERT INTO cje_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Kơyoa nư̆n, buơl guñu đờm sơđồ tơ Yàng Jêsu: “Buơl dơlhă 'buh thơu.” Yàng Jêsu đờm sơ̆ng buơl guñu: “Kơu kŭng rơŭ 'buh đờm tơ buơl guhã thơu kơyoa mư̆ng gơnuăr lơi bloh Kơu ngă du bruă ni.” ");
INSERT INTO cje_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yàng Jêsu tơma angui pơnuaĭ pơgăp-pơmơyơu đờm sơ̆ng buơl guñu: “Sa aràng mơnih dih pla sa apùh ño, ac̆ĭng bơga tòmdăr, klơi sa boh lơbàng pioh păt ia ño ngă tơpai, sơ̆ng bơ̆ sa boh sàng glòng tô khiă-c̆ơ, bloh nư̆n brơi tơ du mơnih pla ño apah, sơ̆ng nau tơ sa lơgăr pơkơ̆n. ");
INSERT INTO cje_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Truh blàn pĕ boh ño, pô apùh pơđăr sa aràng mơnih hơlŭn-hơlă truh tòm du mơnih pla ño tô rì-mă sa pơ-ơnah phŭn-hơjŭng mư̆ng apùh ño. ");
INSERT INTO cje_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Bloh du mơnih pla ño mă mơnih hơlŭn-hơlă, pờng ngă ñu, bloh nư̆n prơh nau wơ̆ tơngàn soh. ");
INSERT INTO cje_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Mơnih pô apùh pơđăr sa aràng mơnih hơlŭn-hơlă pơkơ̆n nau truh, buơl guñu pờng tơ akŏ mơnih nư̆n sơ̆ng puaĭ c̆ơ-ua ngă pơmơlơu ñu. ");
INSERT INTO cje_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Mơnih pô apùh pơđăr sa aràng mơnih hơlŭn-hơlă pơkơ̆n wơ̆ nau truh, nư̆n buơl guñu pơmơtai mơnih hơlŭn-hơlă nư̆n. Lô mơnih hơlŭn-hơlă pơkơ̆n kŭng kŏng buơl guñu ngă yơu nư̆n rơi, mơnih nư̆n kŏng buơl guñu pờng ngă, mơnih kŏng buơl guñu pơmơtai. ");
INSERT INTO cje_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Hơdơi luĭ, mơnih pô apùh dò sa aràng anà lơkơi, nư̆n la anà sa ñu uơ̆n-rơnăm biă. Pô apùh pơđăr anà lơkơi drơi nau, sơ̆ng lăm hơtai-hơtiàn sơnư̆ng lài: ‘Buơl guñu rơŭ c̆ơ prŏng-màng tơ anà kơu.’ ");
INSERT INTO cje_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Bloh du mơnih pla ño nư̆n đờm tămbơyai sơ̆ng gơŭ: ‘Ni la anà tui-jơnuă rơŭ hũ đồ-lĕng phŭm apùh ni mư̆ng ama ñu. Ah, buơl gudrơi pơmơtai ñu bĕ, nư̆n phŭm-kơsai ñu rơŭ mơrai abih lăm tơngàn buơl gudrơi.’ ");
INSERT INTO cje_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Buơl guñu mă anà lơkơi nư̆n, pơmơtai sơ̆ng prah tơ agàh apùh ño. ");
INSERT INTO cje_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yơu nư̆n, pô apùh ño rơŭ ngă hơgĕ? Ñu rơŭ truh pơluĭ-pơmơtai abih du mơnih pla ño nư̆n, sơ̆ng jào apùh ño tơ du mơnih pơkơ̆n apah. ");
INSERT INTO cje_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Buơl guhã ka pơrpoh-c̆ơ pơnuaĭ 'Bồn Bơ-àr Sơc̆ih-Sri ni ơu? ‘Boh pơtơu kŏng mơnih khờh bơ̆ sàng prah luơi, Hũ tơbiă jiơ̆ng boh pơtơu akiăng sàng. ");
INSERT INTO cje_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ni la bruă Yàng ngă, Sơ̆ng nư̆n la pơnuaĭ c̆rih-krơi tơ anaŭ buơl gudrơi!’ ” ");
INSERT INTO cje_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Du mơnih apăn-akŏ buơl làng Juđa păng pơnuaĭ pơgăp-pơmơyơu nư̆n, buơl guñu thơu la Pô angui pơnuaĭ nư̆n tô đờm mư̆ng buơl guñu. Buơl guñu khiăng duah ngă hơyơu mă Pô, bloh kơyoa huơĭ tơ buơl làng, nư̆n păl luơi Pô bloh nau. ");
INSERT INTO cje_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Hơdơi mư̆ng nư̆n, buơl guñu pơđăr du mơnih lăm tơrpuơl Pharisi sơ̆ng tơrpuơl Herôt truh tòm Yàng Jêsu, tô tơnia lòng duah pơnuaĭ mă glài Pô lăm pơnuaĭ đờm. ");
INSERT INTO cje_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Buơl guñu truh đờm sơ̆ng Pô: “Ơ Pô-Pơto, buơl dơlhă thơu Pô-Pơto la mơnih tơpă-siàm, 'buh kơmlưh huơĭ tơ aràng sơi; kơyoa Pô-Pơto 'buh c̆ơ mư̆ng gah agàh anà mơnih, bloh tui pơnuaĭ tơpă pơto-pơsài jơlàn duh-dơlbăt Yàng Pô Lơngì. Yơu nư̆n, hũ păl daŭ jia tơ Sesa ơu? Buơl dơlhă păl daŭ jia halài 'buh daŭ?” ");
INSERT INTO cje_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Bloh Pô thơu hơtai-hơtiàn mơthĭ-lơ̆r buơl guñu, nư̆n Pô đờm: “Kơđa hơgĕ buơl guhã khiăng lòng Kơu? Apăn bĕ tơ Kơu c̆ơ sa đơnie priă.” ");
INSERT INTO cje_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Buơl guñu apăn tơ Pô sa boh priă. Pô tơnia: “Rơ̆p sơ̆ng angăn ni la aràng sơi?” Buơl guñu đờm sơđồ: “Sesa.” ");
INSERT INTO cje_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yàng Jêsu đờm sơ̆ng buơl guñu: “Phơ̆n hơgĕ mư̆ng Sesa bơ-yàr wơ̆ bĕ tơ Sesa. Phơ̆n hơgĕ mư̆ng Yàng Pô Lơngì bơ-yàr wơ̆ bĕ tơ Yàng Pô Lơngì.” Buơl guñu mă ngă c̆rih-takơtuă biă mư̆ng pơnuaĭ Pô đờm sơđồ. ");
INSERT INTO cje_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Du mơnih lăm tơrpuơl Sađuse, la du mơnih đờm lài 'buh hũ pơnuaĭ hơdiŭ wơ̆, truh tòm Yàng Jêsu sơ̆ng tơnia Pô, ");
INSERT INTO cje_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Ơ Pô-Pơto, Môise hũ brơi tơ buơl dơlhă pơnuaĭ adăt-adia ni: ‘Yah sa aràng mơnih hũ adơi-ai drơi mơtai, luơi sơdiŭ bơdrau wơ̆, bloh 'buh hũ anà, nư̆n mơnih nư̆n păl khiăng sơ̆ng mơnih kơmơi bơdrau nư̆n, tô hũ anà pơtui-jơi tơ adơi-ai drơi.’ ");
INSERT INTO cje_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Hũ tơjuh aràng adơi-ai dih, mơnih sơ-ai kơc̆oa khiăng kơmơi, bloh nư̆n mơtai, 'buh hũ anà. ");
INSERT INTO cje_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Mơnih adơi dua khiăng sơ̆ng kơmơi bơdrau nư̆n, bloh nư̆n kŭng mơtai 'buh hũ anà. Mơnih adơi klơu kŭng yơu nư̆n rơi. ");
INSERT INTO cje_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Abih tơjuh aràng adơi-ai 'buh hũ aràng sơi luơi wơ̆ sa aràng anà lơi. Hơdơi luĭ, mơnih kơmơi kŭng mơtai. ");
INSERT INTO cje_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Yơu nư̆n tŭ hơdiŭ wơ̆, mơnih kơmơi nư̆n rơŭ la sơdiŭ aràng sơi? Kơyoa abih tơjuh aràng adơi-ai nư̆n, aràng sơi kŭng khiăng sơ̆ng ñu soh.” ");
INSERT INTO cje_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yàng Jêsu đờm: “Hũ iơŭ kơyoa 'buh wờng thơu 'Bồn Bơ-àr Sơc̆ih-Sri sơ̆ng 'buh wờng thơu gơnăp-gơnuăr Yàng Pô Lơngì bloh buơl guhã hũ sŭng asŭ mư̆ng bruă ni ơu? ");
INSERT INTO cje_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Kơyoa tŭ mư̆ng mơnih mơtai hơdiŭ wơ̆, nư̆n aràng rơŭ 'buh khiăng kơmơi kŭng 'buh khiăng lơkơi, bloh rơŭ mơhiơ̆ yơu du mơnih gơdrưh tơ ngŏ lơngì rơi. ");
INSERT INTO cje_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Mư̆ng bruă mơnih mơtai hơdiŭ wơ̆, buơl guhã ka pơrpoh-c̆ơ lăm 'bồn bơ-àr Môise anih đờm mư̆ng puk druơi ơu? Yàng Pô Lơngì đờm sơ̆ng ñu hơyơu lơi? Pô đờm, ‘Kơu la Yàng Pô Lơngì Abraham, Yàng Pô Lơngì Isak, sơ̆ng Yàng Pô Lơngì Jakôp.’ ");
INSERT INTO cje_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Pô 'buh iơŭ la Yàng Pô Lơngì du mơnih mơtai, bloh la mơnih hơdiŭ. Biă, buơl guhã sŭng asŭ prŏng bơjơ!” ");
INSERT INTO cje_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Sa aràng lăm du mơnih gơnuăr-pơto pơnuaĭ adăt-adia truh jĕ, mơhư̆ Yàng Jêsu sơ̆ng mơnih Sađuse đờm tămpơrjai sơ̆ng gơŭ, 'buh Yàng Jêsu đờm sơđồ khờh rơgơi biă, nư̆n tơnia Pô: “Lăm du pơnuaĭ adăt-pơđăr, pơnuaĭ adăt-pơđăr lơi la prŏng-màng rơlau abih?” ");
INSERT INTO cje_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yàng Jêsu đờm: “Pơnuaĭ adăt-pơđăr prŏng-màng rơlau abih la, ‘Ơ Israel, păng bĕ ni! Yàng, Yàng Pô Lơngì buơl gudrơi la Yàng mĭn hũ sa. ");
INSERT INTO cje_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Hã păl abih hơtai-hơtiàn, abih bơngă-joa, abih hơtai-akŏ, sơ̆ng abih pràn joa bloh duh-rơnăm Yàng la Yàng Pô Lơngì hã.’ ");
INSERT INTO cje_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Pơnuaĭ adăt-pơđăr dua la: ‘Hã păl rơnăm tơ mơnih gơŭ sa plơi adơi sa 'băng yơu rơnăm rùp-phŭn drơi.’ 'Buh hũ pơnuaĭ adăt-pơđăr lơi prŏng rơlau tơ dua pơnuaĭ adăt-pơđăr nư̆n.” ");
INSERT INTO cje_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Mơnih gơnuăr-pơto pơnuaĭ adăt-adia đờm: “Ơ Pô-Pơto, biă iơŭ yơu Pô-Pơto đờm, Yàng Pô Lơngì mĭn hũ sa, rơlau tơ Pô 'buh hũ Yàng lơi pơkơ̆n. ");
INSERT INTO cje_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Biă yơu nư̆n, duh-rơnăm Yàng abih hơtai-hơtiàn, abih hơtai-akŏ, abih pràn-joa, sơ̆ng rơnăm tơ mơnih gơŭ sa plơi adơi sa 'băng yơu rùp-phŭn drơi, la pơnuaĭ prŏng-màng rơlau tơ abih tơgrơ̆ phơ̆n c̆uh c̆ĕ-pơyơ̆r duh-dơlbăt sơ̆ng tơgrơ̆ phơ̆n c̆ĕ-pơyơ̆r duh-dơlbăt pơkơ̆n.” ");
INSERT INTO cje_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","'Buh mơnih nư̆n đờm sơđồ jak-khờh, Yàng Jêsu đờm: “Hã 'buh atàh lơgăr Yàng Pô Lơngì ơu.” Hơdơi mư̆ng nư̆n, 'buh hũ aràng sơi khĭn tơnia Pô pơnuaĭ hơgĕ tra. ");
INSERT INTO cje_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Tŭ Yàng Jêsu dò pơto-mơblàng lăm sàng duh-dơlbăt, Pô tơnia: “Ngă hơyơu du mơnih gơnuăr-pơto pơnuaĭ adăt-adia hũ rơgơi đờm Pô Krist la anà pơtau Đabit? ");
INSERT INTO cje_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Kơyoa rùp-phŭn Đabit hũ Yàng Bơngă Sơc̆ih-Sri ngă ba-pơto, hũ đờm lài: ‘Yàng đờm sơ̆ng Yàng dơlhă: Dò guh bĕ tơ gah hơnuă Kơu, Tơ̆l truh tơ tŭ Kơu daŭ du mơnih mơbai-tămdră sơ̆ng Anà tơ ala tơkai Anà.’ ");
INSERT INTO cje_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Yơu nư̆n, yah rùp-phŭn Đabit hũ iơu Pô la Yàng, nư̆n hơyơu Pô la anà pơtau nư̆n jiơ̆ng?” Tơrpuơl buơl làng lô mă ngă sờh hơtai-hơtiàn biă păng mơhư̆ Pô pơto. ");
INSERT INTO cje_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Lăm tŭ pơto-pơsài, Pô đờm: “Păl c̆ơ-kơrhia bĕ mư̆ng du mơnih gơnuăr-pơto pơnuaĭ adăt-adia, la du mơnih khiăng c̆ù ào jruh nau rah mơ-in, khiăng hũ aràng kù akŏ tơnia c̆uă drơi tơkrah drà, ");
INSERT INTO cje_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","khiăng dò guh anih màng-glòng rơlau abih lăm du sàng pơtòm, sơ̆ng anih prŏng-màng lăm du pơnuaĭ mơñŭm 'bơ̆ng. ");
INSERT INTO cje_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Buơl guñu klĕ mă sàng du mơnih kơmơi bơdrau, bloh tŭ lơi kŭng ngă yơu la mơnih tơpă-siàm sơ̆ng du pơnuaĭ iơu-lài atàh sơ̆ng suơi. Buơl guñu rơŭ kŏng pơnuaĭ c̆ahrơña ngă-nìn glài traŭ rơlau.” ");
INSERT INTO cje_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yàng Jêsu dò guh găn tơ anaŭ sơ̆ng thŭng daŭ priă pơyă. Pô khiăng c̆ơ sơ'buai buơl làng daŭ priă lăm nư̆n hơyơu lơi. ");
INSERT INTO cje_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Lô mơnih mơda daŭ lăm nư̆n lô priă biă. Kŭng hũ sa aràng mơnih kơmơi bơdrau rơ'bah truh sơ̆ng daŭ lăm thŭng dua boh priă tìt, mĭn kàr sa pơ-ơnah pà su priă Rôma. ");
INSERT INTO cje_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Pô iơu du mơnih tui-mơgru truh sơ̆ng đờm: “Iơŭ biă Kơu đờm sơ̆ng buơl guhã, mơnih kơmơi bơdrau rơ'bah ni hũ daŭ priă lăm thŭng lô rơlau abih tơ tơgrơ̆ mơnih pơkơ̆n. ");
INSERT INTO cje_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Kơyoa du mơnih pơkơ̆n mă priă dơlah drơi bloh apăn daŭ lăm nư̆n, dò mơnih kơmơi bơdrau ni, rơ'bah rơ'bừp biă, bloh hũ pơyă abih phơ̆n priă drơi hũ, la abih phơ̆n priă tô ròng hơdiŭ drơi.” ");
INSERT INTO cje_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Tŭ Yàng Jêsu pơrpa tơbiă mư̆ng anih sàng duh-dơlbăt, sa aràng mơnih tui-mơgru đờm sơ̆ng Pô: “Ơ Pô-Pơto, Pô-Pơto c̆ơ dih, du boh pơtơu ni prŏng la thơu hơdùm, sơ̆ng du sàng ni màng-mơkrư la thơu hơdùm!” ");
INSERT INTO cje_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yàng Jêsu đờm: “Hã 'buh du sàng prŏng nư̆n ơu? Bloh ni, rơŭ 'buh dò boh pơtơu lơi rờng tơ ngŏ boh pơtơu pơkơ̆n tra. Abih tih rơŭ kŏng jơrlơh trŭn.” ");
INSERT INTO cje_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Tŭ Pô dò guh tơ ngŏ c̆ơ̆ Ôlibe, găn tơ anaŭ sàng duh-dơlbăt, nư̆n Pier, Jakơ, Jăng, sơ̆ng Andre truh tơnia krơi Pô: ");
INSERT INTO cje_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Yòng Pô-Pơto đờm brơi buơl dơlhă thơu tŭ lơi du bruă nư̆n rơŭ tơbiă truh, sơ̆ng tŭ abih tơgrơ̆ bruă nư̆n kơjĕ truh tŭ luĭ-dŭt, nư̆n hũ nàl hơgĕ brơi pơthơu dơlhơu ơu?” ");
INSERT INTO cje_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yàng Jêsu tơma đờm sơ̆ng buơl guñu: “C̆ơ-kơrhia bĕ, juơi luơi aràng sơi pơluơ pơ̆ng-gơla buơl guhã. ");
INSERT INTO cje_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Kơyoa hũ lô mơnih rơŭ mă angăn Kơu bloh truh sơ̆ng đờm lài: ‘Rùp-phŭn Kơu la Pô Krist!’ Sơ̆ng guñu rơŭ pơluơ pơ̆ng-gơla lô mơnih. ");
INSERT INTO cje_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Tŭ buơl guhã mơhư̆ đờm mư̆ng kơlìn-kơtuă sơ̆ng pơnuaĭ tiơ̆ng 'bèk mư̆ng kơlìn-kơtuă, nư̆n juơi sơnư̆ng huơĭ. Du bruă nư̆n păl tơbiă truh, bloh ka iơŭ la luĭ-dŭt ơu. ");
INSERT INTO cje_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Kơyoa buơl làng ni rơŭ tơgồ tămdră-wơ̆ sơ̆ng buơl làng pơkơ̆n, lơgăr ni tămdră-wơ̆ sơ̆ng lơgăr dih. Lô anih rơŭ hũ tơtuơ̆n-jơrlơh lơ̆n-tơnah, sơ̆ng lô anih rơŭ hũ ờ-lơpa. Bloh nư̆n mĭn la c̆ơmrừp pơnuaĭ pơđì-pơđoa gleh-glăr soh. ");
INSERT INTO cje_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Mư̆ng pơ-ơnah buơl guhã, păl c̆ơ-kơrhia bĕ! Kơyoa buơl guñu rơŭ mă jào buơl guhã tơ du tơrpuơl gơnuăr apăn-akŏ; buơl guhã rơŭ kŏng aràng glih-pờng lăm du anih sàng pơtòm. Kơyoa mư̆ng Kơu, buơl guhã rơŭ păl dò dơ̆ng tơ anaŭ du kwăng apăn-akŏ du c̆àr lăm lơgăr sơ̆ng du pơtau, tô ngă grơh tơ buơl guñu. ");
INSERT INTO cje_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Bloh dơlhơu biă, Pơnuaĭ-Siàm păl hũ pơto-akhàn tơ abih tơgrơ̆ buơl làng. ");
INSERT INTO cje_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Tŭ buơl guñu ba buơl guhã nau jào, nư̆n juơi sơnư̆ng kơ-ù dơlhơu mư̆ng pơnuaĭ drơi rơŭ đờm, bloh truh jơ nư̆n, đờm bĕ tui du pơnuaĭ rơŭ hũ brơi tơ buơl guhã. Kơyoa 'buh iơŭ rùp-phŭn buơl guhã đờm ơu, bloh la Yàng Bơngă Sơc̆ih-Sri đờm. ");
INSERT INTO cje_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Adơi-ai rơŭ pơblơ̆ jào gơŭ tô aràng pơmơtai, ama rơŭ jào anà; du anà rơŭ tơgồ tămdră-wơ̆ sơ̆ng ame ama drơi bloh ngă tơ ama ame păl mơtai. ");
INSERT INTO cje_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Buơl guhã rơŭ kŏng tơgrơ̆ mơnih mơbai-lơmù kơyoa angăn Kơu. Bloh aràng sơi kơjăp hơtai-hơtiàn tơ̆l truh luĭ-dŭt, mơnih nư̆n rơŭ hũ dŏng-pơklàh. ");
INSERT INTO cje_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Tŭ buơl guhã 'buh phơ̆n ngkòr-sơŭ ngă tơbiă pơnuaĭ kơprah-kơprĭng tơ Anih Sơc̆ih-Sri, dò dơ̆ng tơ anih ñu 'buh hũ gơnuăr dò dơ̆ng (aràng sơi pơrpoh-c̆ơ păl wờng), nư̆n aràng sơi dò lăm c̆àr Juđe, đuaĭ dơŭ bĕ tơ ngŏ c̆ơ̆; ");
INSERT INTO cje_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","aràng sơi dò tơ ngŏ 'blàng bơbŭng sàng, nư̆n juơi trŭn halài đuaĭ tơma lăm sàng tô mă tơgrơ̆ phơ̆n hơgĕ; ");
INSERT INTO cje_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","aràng sơi dò tơ 'blàng hơma juơi gài mơrai wơ̆ tô mă ào agàh. ");
INSERT INTO cje_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Lăm du hơrơi nư̆n, gleh-glăr dồn-să biă tơ du mơnih kơmơi hũ mơtiàn sơ̆ng du mơnih kơmơi hũ anà mơnga dò mơ̆m! ");
INSERT INTO cje_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Iơu lài bĕ tô pơnuaĭ nư̆n 'buh tơbiă truh lăm blàn mơrềt. ");
INSERT INTO cje_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Kơyoa lăm du hơrơi nư̆n rơŭ hũ pơnuaĭ gleh-glăr rŭng-rài prŏng biă, bloh mư̆ng tŭ Yàng Pô Lơngì pơc̆rơ̆ng tơbiă lơngì-tơsì tơnah-rơya tơ̆l truh tơ tŭ ni kŭng ka tŭ lơi hũ, sơ̆ng hơdơi ni kŭng rơŭ 'buh tŭ lơi hũ yơu nư̆n tra. ");
INSERT INTO cje_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Yah Yàng 'buh suă pơ-ơwĕt du hơrơi nư̆n wơ̆, nư̆n 'buh sa aràng mơnih lơi hũ dŏng-pơklàh. Bloh kơyoa mư̆ng du mơnih Pô hũ pơlih-rơwah, nư̆n Pô rơŭ suă pơ-ơwĕt du hơrơi nư̆n wơ̆. ");
INSERT INTO cje_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Tŭ nư̆n, yah hũ aràng sơi đờm sơ̆ng buơl guhã: ‘Ni, Pô Krist dò tơ anih ni!’ halài: ‘Pô dò tơ anih nư̆n,’ nư̆n juơi păng-tui. ");
INSERT INTO cje_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kơyoa rơŭ hũ du pô krist lơ̆r sơ̆ng du mơnih gơnuăr-hwơ̆r lơ̆r tơbiă truh; guñu rơŭ ngă lô nàl-c̆rih pơnuaĭ-krơi tô pơluơ pơ̆ng-gơla. Yah hũ rơgơi jiơ̆ng, guñu kŭng pơluơ pơ̆ng-gơla găm du mơnih hũ pơlih-rơwah rơi. ");
INSERT INTO cje_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","C̆ơ-kơrhia bĕ. Kơu hũ đờm dơlhơu abih tơgrơ̆ bruă tơ buơl guhã bơjơ. ");
INSERT INTO cje_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Lăm du hơrơi nư̆n, hơdơi pơnuaĭ gleh-glăr rŭng-rài, nư̆n ia-hơrơi rơŭ tơbiă jiơ̆ng kơnăm-mơsrư̆, ia-blàn rơŭ 'buh pơsàng sơrdah tra, ");
INSERT INTO cje_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","du ia-pơtŭ rơŭ mư̆ng ngŏ lơngì lĕ trŭn, sơ̆ng du gơnuăr tơ ngŏ lơngì rơŭ tơtuơ̆n-mơgơi. ");
INSERT INTO cje_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Tŭ nư̆n aràng rơŭ 'buh Anà Mơnih, mă gơnăp-gơnuăr prŏng sơ̆ng pơnuaĭ màng-kơc̆rà prŏng mư̆ng tơkrah hwăl lơngì bloh truh. ");
INSERT INTO cje_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Pô rơŭ pơđăr du mơnih gơdrưh nau pơgùm-pơtòm abih tơgrơ̆ mơnih hũ pơlih-rơwah mư̆ng gùt-dăr lơngì, mư̆ng anih luĭ-dŭt lơ̆n-tơnah tơ̆l truh anih luĭ-dŭt lơngì.” ");
INSERT INTO cje_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Păng bĕ pơnuaĭ pơmơyơu mư̆ng kơyơu hra. Tŭ thàn ñu pơrpa tơbiă sơbŭt c̆ă sơla, nư̆n buơl guhã thơu blàn kluơĭ kơjĕ truh. ");
INSERT INTO cje_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Kŭng yơu nư̆n rơi, tŭ buơl guhã 'buh du pơnuaĭ nư̆n tơbiă truh, nư̆n thơu Anà Mơnih kơjĕ truh bơjơ, dò tơ anaŭ bơh 'băng. ");
INSERT INTO cje_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Iơŭ biă, Kơu đờm sơ̆ng buơl guhã, jơi rài ni rơŭ 'buh nau rơlau dơlhơu tơ tŭ tơgrơ̆ bruă nư̆n tơbiă truh. ");
INSERT INTO cje_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Lơngì sơ̆ng tơnah rơŭ lơhiă, bloh tơgrơ̆ pơnuaĭ Kơu đờm rơŭ 'buh tŭ lơi lơhiă ơu. ");
INSERT INTO cje_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Mư̆ng hơrơi sơ̆ng jơ nư̆n 'buh aràng sơi thơu jiơ̆ng. Du mơnih gơdrưh tơ ngŏ lơngì halài Anà kŭng yơu nư̆n rơi, bloh mĭn Ama thơu soh. ");
INSERT INTO cje_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Păl c̆ơ-kơrhia sơ̆ng mơdơh-kraŭ bĕ, kơyoa buơl guhã 'buh thơu tŭ lơi bruă nư̆n tơbiă truh. ");
INSERT INTO cje_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Kŭng mơhiơ̆ yơu sa aràng mơnih pô dih kơjĕ nau jơlàn atàh, tŭ tơbiă mư̆ng sàng, jào gơnuăr-bruă tơ du mơnih hơlŭn-hơlă, yàu aràng yàu bruă, sơ̆ng kơkơi pơđăr mơnih khiă bơh 'băng păl mơdơh-kraŭ. ");
INSERT INTO cje_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Yơu nư̆n, păl mơdơh-kraŭ bĕ, kơyoa buơl guhã 'buh thơu pô sàng mơrai wơ̆ tŭ lơi: Tŭ glai diơŭ halài mơtưh mơlăm, tŭ mơnŭ kơ-iòk halài glai ờm, ");
INSERT INTO cje_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","huơĭ mơnih pô mơrai wơ̆ ơ̆p-dơrmơ̆p sơ̆ng păp buơl guhã dò đih ơu. ");
INSERT INTO cje_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Tơgrơ̆ pơnuaĭ hơgĕ Kơu đờm sơ̆ng buơl guhã, Kơu kŭng đờm sơ̆ng abih tơgrơ̆ mơnih: Păl mơdơh-kraŭ bĕ!” ");
INSERT INTO cje_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Dua hơrơi dơlhơu tơ pơnuaĭ pơjŭm 'bơ̆ng Nau-Găn sơ̆ng pơjŭm 'bơ̆ng Pah 'Buh Hũ Tơpơi, du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt găm sơ̆ng du mơnih gơnuăr-pơto pơnuaĭ adăt-adia, tămbơyai duah pơnuaĭ tô mă sơ̆ng pơmơtai Yàng Jêsu. ");
INSERT INTO cje_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Buơl guñu tămbơyai lài: “Juơi ngă bruă ni lăm hơrơi pơjŭm 'bơ̆ng, huơĭ ngă sơlŭng-sơlăng klùk-klờk lăm buơl làng.” ");
INSERT INTO cje_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Tŭ Yàng Jêsu dò tơ plơi 'Bethani, lăm sàng Simôn la mơnih dŭn. Tŭ Pô dò guh tơ anih c̆ơnừng huă 'bơ̆ng, hũ sa aràng mơnih kơmơi tơma, apăn tui sa boh blŏ ngă sơ̆ng pơtơu-màng, lăm dơrlăm blŏ hũ mơñà 'bơu bơlhơu c̆ơk-màng biă. Ñu pờng pơc̆ah blŏ mơñà sơ̆ng tuh mơñà 'bơu bơlhơu tơ akŏ Pô. ");
INSERT INTO cje_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Bloh hũ du mơnih dò tơ anih nư̆n anok hơtai đờm sơ̆ng gơŭ: “Kơđa hơgĕ pròng-preh mơñà 'bơu bơlhơu yơu nư̆n? ");
INSERT INTO cje_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Kơyoa mơñà ni hũ rơgơi pơblơi jiơ̆ng rơlau klơu rơtùh đơnie, mă priă nư̆n bloh dŏng mơnih rơ'bah.” Buơl guñu đờm traŭ pơnuaĭ sơ̆ng mơnih kơmơi. ");
INSERT INTO cje_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Bloh Yàng Jêsu đờm: “Kừ luơi kơđơ̆ng tơ ñu ngă. Kơđa hơgĕ buơl guhã khiăng ngă kăn-dơmăn tơ mơnih nư̆n? Ñu hũ ngă sa bruă siàm tơ Kơu. ");
INSERT INTO cje_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Kơyoa buơl guhã hũ mơnih rơ'bah dò găm mĭt sơ̆ng drơi, buơl guhã khiăng ngă bruă siàm anĭt-dŏng tơ buơl guñu tŭ lơi kŭng jiơ̆ng; bloh 'buh iơŭ tŭ lơi buơl guhã kŭng hũ Kơu mĭt ơu. ");
INSERT INTO cje_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ñu hũ ngă pơnuaĭ drơi hũ rơgơi ngă jiơ̆ng. Ñu hũ lŭ mơñà tơ rùp Kơu dơlhơu, tô rơc̆ăng tơ bruă dơ̆r. ");
INSERT INTO cje_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Iơŭ biă, Kơu đờm sơ̆ng buơl guhã, lăm abih dun-ya ni, anih lơi Pơnuaĭ-Siàm ni hũ pơto-akhàn, nư̆n bruă mơnih kơmơi ni hũ ngă kŭng rơŭ hũ đờm pơsơdơ̆r wơ̆ tô sơdơ̆r truh ñu.” ");
INSERT INTO cje_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Juđa Iskariôt, sa aràng lăm sa-pluh dua aràng mơnih tơdi-tơdài, truh tòm du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt, tô pơblơ̆ jào Yàng Jêsu tơ buơl guñu. ");
INSERT INTO cje_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Mơhư̆ yơu nư̆n buơl guñu sờh biă, sơ̆ng đờm pơguăn brơi tơ ñu priă. Nư̆n Juđa duah tŭ hơnàn-siàm tô jào Pô. ");
INSERT INTO cje_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Lăm hơrơi c̆ơmrừp pơjŭm 'bơ̆ng Pah 'Buh Hũ Tơpơi, la hơrơi aràng pơmơtai abo anà pơjŭm 'bơ̆ng Nau-Găn, du mơnih tui-mơgru đờm sơ̆ng Yàng Jêsu: “Pô-Pơto khiăng buơl dơlhă nau rơc̆ăng tơ Pô-Pơto 'bơ̆ng pơjŭm 'bơ̆ng Nau-Găn tơ anih lơi?” ");
INSERT INTO cje_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Pô pơđăr dua aràng mơnih tui-mơgru nau, sơ̆ng đờm kơkơi pơđăr: “Nau tơma bĕ lăm plơi-prŏng, hũ sa aràng mơnih đoa bìng ia rơŭ păp buơl guhã. Nau bĕ tui mơnih nư̆n, ");
INSERT INTO cje_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","mơnih nư̆n tơma sàng lơi, buơl guhã truh bĕ đờm sơ̆ng mơnih pô sàng nư̆n lài: ‘Pô-Pơto tơnia: Adŭ pioh tơ thuai, la anih Kơu rơŭ 'bơ̆ng pơnuaĭ pơjŭm 'bơ̆ng Nau-Găn sơ̆ng du mơnih tui-mơgru Kơu tơ anih lơi?’ ");
INSERT INTO cje_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Mơnih pô sàng rơŭ pơto tơ buơl guhã sa adŭ prŏng tơ ngŏ glòng sàng, hũ rơc̆ăng lờih abih bơjơ. Sơ̆ng tơ anih nư̆n, buơl guhã rơc̆ăng pồ bĕ tơ buơl gudrơi.” ");
INSERT INTO cje_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Dua aràng mơnih tui-mơgru nau tơma lăm plơi-prŏng sơ̆ng păp tơgrơ̆ bruă iơŭ yơu pơnuaĭ Pô hũ đờm. Bloh nư̆n buơl guñu rơc̆ăng pồ pơnuaĭ pơjŭm 'bơ̆ng Nau-Găn tơ anih nư̆n. ");
INSERT INTO cje_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Glai diơŭ, Yàng Jêsu sơ̆ng sa-pluh dua aràng mơnih tui-mơgru truh. ");
INSERT INTO cje_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Lăm tŭ dò guh 'bơ̆ng, Yàng Jêsu đờm: “Iơŭ biă, Kơu đờm sơ̆ng buơl guhã, lăm buơl guhã hũ sa aràng mơnih dò guh 'bơ̆ng găm sơ̆ng Kơu, rơŭ pơblơ̆-dră Kơu.” ");
INSERT INTO cje_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Du mơnih tui-mơgru dơnuh-dơnà biă. Buơl guñu tui gơŭ mư̆ng aràng ni truh aràng dih tơnia Pô: “Hũ iơŭ la dơlhă ơu?” ");
INSERT INTO cje_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Pô đờm: “Nư̆n la sa aràng lăm sa-pluh dua aràng, la mơnih c̆ik pah lăm sa prèng sơ̆ng Kơu. ");
INSERT INTO cje_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Anà Mơnih păl nau tui yơu pơnuaĭ hũ wă mư̆ng Pô, bloh gleh-glăr dồn-să biă tơ mơnih pơblơ̆-dră Anà Mơnih! Yah ñu 'buh hũ đih apui tơbiă la siàm rơlau.” ");
INSERT INTO cje_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Lăm tŭ dò 'bơ̆ng, Yàng Jêsu mă pah, ưnjơmừn, bloh nư̆n 'bĕt brơi tơ du mơnih tui-mơgru, sơ̆ng đờm: “Đồ-mă bĕ, ni la rùp-phàp Kơu.” ");
INSERT INTO cje_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Pô mă c̆uàn, ưnjơmừn, bloh nư̆n brơi tơ du mơnih tui-mơgru, sơ̆ng abih tơgrơ̆ aràng buơl guñu mơñŭm. ");
INSERT INTO cje_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Pô đờm sơ̆ng buơl guñu: “Ni la drah Kơu, drah pơnuaĭ pơguăn-pơđoàn, tuh tơbiă tơ lô mơnih. ");
INSERT INTO cje_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Iơŭ biă, Kơu đờm sơ̆ng buơl guhã, Kơu rơŭ 'buh mơñŭm ia ño ni tra, tơ̆l truh tơ hơrơi Kơu rơŭ mơñŭm ia ño bơrhơu lăm lơgăr Yàng Pô Lơngì.” ");
INSERT INTO cje_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Hơdơi tŭ adoh pơnuaĭ pơđik-adoh sơc̆ih-sri, Yàng Jêsu sơ̆ng du mơnih tui-mơgru tơbiă nau, đì tơ c̆ơ̆ Ôlibe. ");
INSERT INTO cje_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yàng Jêsu đờm sơ̆ng du mơnih tui-mơgru: “Abih buơl guhã rơŭ klà luơi Kơu. Kơyoa hũ pơnuaĭ wă lài: ‘Kơu rơŭ pờng mơnih glăng abo, Nư̆n tơrpuơl abo rơŭ kơprah-kơprĭng.’ ");
INSERT INTO cje_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Bloh hơdơi tŭ Kơu hơdiŭ wơ̆, Kơu rơŭ truh tơ Galile dơlhơu buơl guhã.” ");
INSERT INTO cje_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pier đờm sơ̆ng Pô: “Yah abih tơgrơ̆ mơnih klà luơi Pô, bloh dơlhă rơŭ 'buh tŭ lơi klà luơi Pô ơu.” ");
INSERT INTO cje_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yàng Jêsu đờm sơ̆ng ñu: “Iơŭ biă, Kơu đờm sơ̆ng hã: hơrơi ni, kŭng lăm mơlăm ni, dơlhơu tŭ mơnŭ kơ-iòk dua amăng, hã rơŭ klơu amăng đờm kơmlah lài hã 'buh thơu Kơu.” ");
INSERT INTO cje_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Bloh Pier đờm nìn-kơjăp rơlau wơ̆: “Yah dơlhă păl kŏng mơtai sơ̆ng Pô-Pơto, dơlhă kŭng 'buh kơmlah-luơi Pô-Pơto ơu.” Abih du mơnih tui-mơgru pơkơ̆n kŭng đờm yơu nư̆n rơi. ");
INSERT INTO cje_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Hơdơi mư̆ng nư̆n, Yàng Jêsu sơ̆ng du mơnih tui-mơgru Pô nau truh tơ sa anih, angăn la Getsemane. Pô đờm sơ̆ng du mơnih tui-mơgru: “Dò guh bĕ tơ anih ni lăm tŭ Kơu nau iơu-lài.” ");
INSERT INTO cje_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Pô ba Pier, Jakơ, sơ̆ng Jăng nau tui. Mư̆ng tŭ nư̆n, lăm hơtai-hơtiàn Pô tơma dơnuh-dơnà sơ̆ng rơu-ri biă. ");
INSERT INTO cje_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Pô đờm sơ̆ng buơl guñu: “Bơngă-joa Kơu dơnuh-dơnà pơđì-pơđoa tơ̆l truh mơtai. Buơl guhã dò bĕ tơ anih ni, sơ̆ng mơdơh-kraŭ.” ");
INSERT INTO cje_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Pô nau atàh rơlau sa-sĭt tra, bloh nư̆n pơđih rùp tơ ala lơ̆n sơ̆ng iơu-lài, tô yah hũ rơgơi jiơ̆ng, nư̆n yòng jơ ni nau rơlau klàh mư̆ng Pô. ");
INSERT INTO cje_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Pô đờm: “Aba, khoai Ama, Ama hũ rơgơi ngă jiơ̆ng abih tơgrơ̆ bruă. Yòng Ama suă c̆uàn ni klàh mư̆ng Anà, bloh 'buh tui hơtai Anà khiăng, bloh tui hơtai Ama khiăng.” ");
INSERT INTO cje_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Bloh nư̆n Pô gài mơrai, 'buh klơu aràng buơl guñu dò đih; Pô đờm sơ̆ng Pier: “Simôn, hã dò đih nư̆n? Hã 'buh rơgơi dò mơdơh guah jiơ̆ng sa jơ ơu? ");
INSERT INTO cje_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Păl mơdơh-kraŭ sơ̆ng iơu-lài bĕ, tô buơl guhã 'buh lĕ-tơma lăm pơnuaĭ pơluơ-ơñiai. Hơtai-bơngă nư̆n khiăng biă, bloh rùp-phàp drah-rơlo nư̆n gleh-lơmŭn, 'buh tơ̆l pràn tô ngă jiơ̆ng.” ");
INSERT INTO cje_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Sa amăng tra wơ̆, Yàng Jêsu tơbiă nau iơu-lài mơhiơ̆ yơu dơlhơu. ");
INSERT INTO cje_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Bloh nư̆n Pô gài mơrai sơ̆ng 'buh buơl guñu sơđaŭ dò đih, kơyoa mơta buơl guñu dùi traŭ yŭp-yŭp bơjơ. Buơl guñu 'buh thơu đờm sơđồ hơyơu lơi sơ̆ng Pô. ");
INSERT INTO cje_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Pô gài wơ̆ amăng klơu, đờm sơ̆ng buơl guñu lài: “Tŭ ni bloh buơl guhã sơđaŭ dò đih sơ̆ng dò pơgleh jiơ̆ng? Đih kàr nư̆n tơ̆l bơjơ. Tŭ jơ hũ truh bơjơ! Ni, Anà Mơnih rơŭ kŏng jào lăm tơngàn du mơnih glài-sơnoh. ");
INSERT INTO cje_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Tơgồ dơ̆ng bĕ, buơl gudrơi nau. Dih, mơnih pơblơ̆-dră Kơu hũ truh jĕ bơjơ.” ");
INSERT INTO cje_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Lăm tŭ Yàng Jêsu dò đờm, nư̆n Juđa, sa aràng lăm sa-pluh dua aràng mơnih tơdi-tơdài truh. Nau găm sơ̆ng ñu hũ sa tơrpuơl lô mơnih apăn đào sơ̆ng gai, kơyoa mư̆ng du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt, du mơnih gơnuăr-pơto pơnuaĭ adăt-adia, sơ̆ng du mơnih gơnuăr-tha pơđăr mơrai truh. ");
INSERT INTO cje_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Dơlhơu tơ nư̆n, mơnih pơblơ̆-dră Yàng Jêsu hũ brơi tơ guñu sa nàl ni: “Yah kơu c̆ŭm aràng sơi, nư̆n la mơnih nư̆n; mă bĕ sơ̆ng ba nau tô nĭ-nùn.” ");
INSERT INTO cje_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Kơyoa nư̆n, tŭ truh anih, Juđa mơrai truh jĕ Pô sơ̆ng đờm: “Ơ Pô-Pơto,” bloh nư̆n ñu c̆ŭm Pô. ");
INSERT INTO cje_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Buơl mơnih dih mă Pô mư. ");
INSERT INTO cje_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Bloh sa aràng lăm du mơnih dò dơ̆ng jĕ tơ anih nư̆n suă đào, ngă sa aràng mơnih hơlŭn-hơlă mơnih gơnuăr prŏng apăn-akŏ pơyă phơ̆n duh-dơlbăt, tă kloh tơnia ñu. ");
INSERT INTO cje_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yàng Jêsu đờm sơ̆ng buơl guñu: “Kơđa hơgĕ buơl guhã apăn đào sơ̆ng gai truh mă Kơu yơu mă sa aràng mơnih klĕ-blơ̆ yơu nư̆n? ");
INSERT INTO cje_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Yàu hơrơi Kơu dò tơkrah buơl guhã, pơto-mơblàng lăm sàng duh-dơlbăt, bloh buơl guhã 'buh mă Kơu. Bloh bruă păl tơbiă truh yơu ni tô pơnuaĭ lăm 'Bồn Bơ-àr Sơc̆ih Sri hũ tơbiă iơŭ tơpă biă.” ");
INSERT INTO cje_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Tŭ nư̆n, abih tơgrơ̆ mơnih tui-mơgru luơi Pô bloh đuaĭ dơŭ abih. ");
INSERT INTO cje_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Hũ sa aràng mơnih lơkơi dăm nau tui Pô, lăm rùp mĭn mơsŭm sa blah khăn. Buơl nư̆n mă mơnih lơkơi dăm nư̆n, ");
INSERT INTO cje_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","bloh ñu klà luơi khăn wơ̆, dò kŭl đuaĭ klàh mư̆ng tơngàn buơl mơnih nư̆n. ");
INSERT INTO cje_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Buơl guñu ba Yàng Jêsu truh tơ sàng mơnih gơnuăr prŏng apăn-akŏ pơyă phơ̆n duh-dơlbăt. Abih du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt, du mơnih gơnuăr-tha, sơ̆ng du mơnih gơnuăr-pơto pơnuaĭ adăt-adia, pơgùm-pơtòm gơŭ tơ̆l abih tơ anih nư̆n. ");
INSERT INTO cje_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pier nau tui Pô đoh-đoh, tơma truh gah dơrlăm 'blàng sàng-glăng mơnih gơnuăr prŏng apăn-akŏ pơyă phơ̆n duh-dơlbăt, bloh nư̆n dò guh dò apui găm sơ̆ng buơl lĭng khiă-gàr. ");
INSERT INTO cje_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt sơ̆ng abih Tơrpuơl Gơnuăr Apăn-Akŏ, duah c̆ơ̆ng-grơh tămdră-wơ̆ sơ̆ng Yàng Jêsu tô pơmơtai Pô, bloh 'buh duah hũ pơnuaĭ hơgĕ. ");
INSERT INTO cje_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Kơyoa hũ lô mơnih ngă grơh lơ̆r tămdră-wơ̆ sơ̆ng Pô, bloh du pơnuaĭ buơl guñu đờm ngă grơh nư̆n 'buh hũ rơgăm iơŭ sơ̆ng gơŭ. ");
INSERT INTO cje_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Tŭ nư̆n, hũ du mơnih dò dơ̆ng đờm ngă grơh lơ̆r tămdră-wơ̆ sơ̆ng Pô lài: ");
INSERT INTO cje_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Buơl dơlhă hũ mơhư̆ mơnih ni đờm: ‘Kơu rơŭ ngă jơrlơh-tơrlŭng sàng duh-dơlbăt kơyoa mư̆ng tơngàn anà mơnih bơ̆ pơdơ̆ng ni, bloh nư̆n hơdơi klơu hơrơi Kơu rơŭ bơ̆ pơdơ̆ng wơ̆ sa boh sàng duh-dơlbăt pơkơ̆n, 'buh iơŭ kơyoa tơngàn anà mơnih bơhiàn ngă tơbiă.’ ” ");
INSERT INTO cje_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Bloh mư̆ng pơnuaĭ ni, pơnuaĭ buơl guñu ngă grơh kŭng 'buh rơgăm iơŭ sơ̆ng gơŭ ơu rơi. ");
INSERT INTO cje_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Tŭ nư̆n, mơnih gơnuăr prŏng apăn-akŏ pơyă phơ̆n duh-dơlbăt tơgồ dơ̆ng tơkrah Tơrpuơl Gơnuăr Apăn-Akŏ sơ̆ng tơnia Yàng Jêsu: “Hã 'buh đờm sơđồ hơgĕ mư̆ng tơgrơ̆ pơnuaĭ bloh du mơnih ni đờm yă hã ơu?” ");
INSERT INTO cje_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Bloh Pô sơđaŭ dò kơđơ̆ng, 'buh đờm sơđồ sa boh pơnuaĭ. Mơnih gơnuăr prŏng apăn-akŏ pơyă phơ̆n duh-dơlbăt tơnia wơ̆: “Hã hũ iơŭ la Pô Krist, Anà Yàng Pô Lơngì, Pô iơŭ păl hũ mơyòm-pơglòng ơu?” ");
INSERT INTO cje_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yàng Jêsu đờm: “Biă iơŭ yơu nư̆n. Rùp-phŭn Kơu la Pô Krist. Bloh ni buơl guhã rơŭ 'buh Anà Mơnih dò guh tơ gah hơnuă Pô Gơnăp-Gơnuăr, sơ̆ng rơŭ dò tơkrah hwăl lơngì bloh truh.” ");
INSERT INTO cje_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Tŭ nư̆n, mơnih gơnuăr prŏng apăn-akŏ pơyă phơ̆n duh-dơlbăt hĕt ào drơi sơ̆ng đờm: “Buơl gudrơi c̆àng hơgĕ du mơnih ngă grơh tra? ");
INSERT INTO cje_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Buơl guhã hũ mơhư̆ loh-làng bơjơ pơnuaĭ ñu đờm sơk-sơrbĭl khĭn-dơmĭn truh tơ Yàng Pô Lơngì, buơl guhã sơnư̆ng hơyơu?” Abih Tơrpuơl Gơnuăr Apăn-Akŏ sa hơtai ngă nìn-glài Pô păl mơtai. ");
INSERT INTO cje_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Hũ du mơnih kơc̆uh ia bơbah lăm Pô. Buơl guñu kơbơ̆ mơta Pô wơ̆, bloh nư̆n sơ-ơnŭ Pô sơ̆ng đờm: “C̆ơ đờm hwơ̆r bĕ!” Du mơnih lĭng khiă-gàr kŭng mă Pô sơ̆ng pah ngă Pô. ");
INSERT INTO cje_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Tŭ Pier dò tơ ala anih 'blàng sàng, sa aràng mơnih kơmơi hơlŭn-hơlă mơnih gơnuăr prŏng apăn-akŏ pơyă phơ̆n duh-dơlbăt nau truh, ");
INSERT INTO cje_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","'buh Pier dò guh dò apui tơ anih nư̆n, ñu truh jĕ, c̆ơ tơ 'bò mơta Pier sơ̆ng đờm: “Kơi kŭng la mơnih dò sơ̆ng Jêsu mơnih Nasaret rơi!” ");
INSERT INTO cje_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Bloh Pier đờm kơmlah: “Kơu 'buh thơu, kŭng 'buh wờng hã khiăng đờm hơgĕ.” Bloh nư̆n Pier tơgồ dơ̆ng, nau tơbiă tơ anih 'blàng gah anaŭ sàng, nư̆n mơnŭ kơ-iòk. ");
INSERT INTO cje_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","'Buh Pier truh tơ anih nư̆n, mơnih hơlŭn-hơlă kơmơi nau truh đờm sơ̆ng du mơnih dò dơ̆ng jĕ tơ anih nư̆n: “Mơnih ni kŭng dò lăm tơrpuơl buơl nư̆n rơi.” ");
INSERT INTO cje_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Bloh Pier đờm kơmlah sa amăng tra wơ̆. Hơdơi mư̆ng nư̆n 'buh suơi, du mơnih dò dơ̆ng tơ anih nư̆n đờm sơ̆ng Pier: “Iơŭ tơbiă biă, hã kŭng la mơnih lăm tơrpuơl nư̆n rơi, kơyoa hã la mơnih Galile.” ");
INSERT INTO cje_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Nư̆n Pier pơc̆ĕ bloh đờm tơpah-sri lài: “Kơu 'buh thơu mơnih bloh buơl guhã đờm nư̆n.” ");
INSERT INTO cje_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Lăm tŭ nư̆n mư, mơnŭ kơ-iòk amăng dua. Pier sơdơ̆r wơ̆ pơnuaĭ Yàng Jêsu hũ đờm sơ̆ng drơi: “Dơlhơu tŭ mơnŭ kơ-iòk dua amăng, hã rơŭ klơu amăng đờm kơmlah la hã 'buh thơu kơu.” Ñu sơdơ̆r truh nư̆n hia sơngơh-sơngờt. ");
INSERT INTO cje_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Pơrpa rìng sơrdah, du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt, du mơnih gơnuăr-tha, du mơnih gơnuăr-pơto pơnuaĭ adăt-adia găm sơ̆ng abih Tơrpuơl Gơnuăr Apăn-Akŏ, pơgùm-pơtòm gơŭ wơ̆ tô tămbơyai. Hơdơi mư̆ng nư̆n, buơl guñu c̆ă Yàng Jêsu wơ̆, sơ̆ng ba nau jào tơ Pilat. ");
INSERT INTO cje_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilat tơnia Pô: “Hã hũ iơŭ la Pơtau buơl làng Juđa ơu?” Yàng Jêsu đờm: “Iơŭ yơu kơi đờm.” ");
INSERT INTO cje_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt đờm yă Pô lô glài, ");
INSERT INTO cje_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","nư̆n Pilat tơnia Pô wơ̆: “Hã 'buh đờm sơđồ hơgĕ ơu? Păng dih, buơl guñu đờm yă hã lô glài biă.” ");
INSERT INTO cje_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Bloh Yàng Jêsu 'buh đờm sơđồ hơgĕ tra, ngă tơ Pilat păl mă ngă krơi-takơtuă biă. ");
INSERT INTO cje_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Lăm yàu pơnuaĭ pơjŭm 'bơ̆ng prŏng, Pilat jiăng hũ adăt-lơđăp toh tơleh tơ buơl làng sa aràng mơnih glài kŏng jàm, tui yơu hơtai buơl làng yòng. ");
INSERT INTO cje_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Tŭ nư̆n hũ sa aràng mơnih angăn la 'Baraba, dò kơđòng jàm lăm anuh găm sơ̆ng du mơnih tơgồ tămdră-wơ̆ sơ̆ng gơnuăr apăn-akŏ ia-lơgăr, kơyoa lăm tŭ tơgồ tămdră, buơl guñu hũ ngă glài pơmơtai mơnih. ");
INSERT INTO cje_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Tơrpuơl buơl làng ba gơŭ truh, sơ̆ng yòng Pilat ngă tui pơnuaĭ adăt-lơđăp bloh Pilat jiăng ngă tơ buơl guñu. ");
INSERT INTO cje_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilat tơnia: “Buơl guhã hũ khiăng kơu toh-tơleh Pơtau buơl làng Juđa tơ buơl guhã ơu?” ");
INSERT INTO cje_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Kơyoa Pilat thơu loh-làng, mĭn kơyoa mư̆ng hơtai-hơtiàn oàn-mơbai bloh du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt hũ jào Pô tơ ñu. ");
INSERT INTO cje_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Bloh du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt pơsŭt-pơđăr buơl làng yòng Pilat toh-tơleh 'Baraba tơ buơl guñu. ");
INSERT INTO cje_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilat tơnia buơl guñu wơ̆: “Yơu nư̆n, buơl guhã khiăng kơu ngă hơyơu sơ̆ng mơnih bloh buơl guhã iơu la Pơtau buơl làng Juđa?” ");
INSERT INTO cje_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Buơl guñu driau prŏng: “Pơ̆ng bĕ ñu tơ kơyơu pơkăl!” ");
INSERT INTO cje_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilat tơnia buơl guñu: “Bloh mơnih ni hũ ngă pơnuaĭ mơsak-jơhà hơgĕ?” Buơl guñu 'brŏ driau prŏng rơlau wơ̆: “Pơ̆ng bĕ ñu tơ kơyơu pơkăl!” ");
INSERT INTO cje_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Kơyoa khiăng ngă tô siàm hơtai buơl làng, Pilat hũ toh-tơleh 'Baraba tơ buơl guñu, sơ̆ng hơdơi tŭ pơđăr mơnih glih pờng Yàng Jêsu, Pilat jào Pô tơ buơl guñu tô ba nau pơ̆ng tơ kơyơu pơkăl. ");
INSERT INTO cje_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Buơl lĭng ba Yàng Jêsu tơma lăm gah dơrlăm sàng-glăng kwăng apăn-akŏ du c̆àr lăm lơgăr, sơ̆ng pơgùm-pơtòm abih tơrpuơl lĭng wơ̆. ");
INSERT INTO cje_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Buơl guñu pơc̆ù tơ Pô sa blah ào mơr-yah, sơ̆ng pă sa boh dơwàng druơi ngă sơgơ̆n pơtruă tơ akŏ Pô; ");
INSERT INTO cje_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","bloh nư̆n guñu kơkuh tơ anaŭ Pô đờm: “Khoai-dơlbăt Pơtau buơl làng Juđa!” ");
INSERT INTO cje_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Buơl guñu kŭng mă gai pờng tơ akŏ Pô, kơc̆uh ia bơbah lăm Pô, bloh nư̆n c̆ĕ tơ-ù khoai Pô. ");
INSERT INTO cje_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Hơdơi tŭ klau-pơtăt Pô srăp bơjơ, guñu wà ào mơr-yah nư̆n sơ̆ng pơc̆ù ào Pô tơ Pô wơ̆, sơ̆ng ba Pô nau tô pơ̆ng tơ kơyơu pơkăl. ");
INSERT INTO cje_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Lăm jơlàn nau, guñu păp sa aràng mơnih mư̆ng plơi đì nau tơ plơi-prŏng Jerusalem, guñu mă mơnih nư̆n glăm kơyơu pơkăl tơ Pô. Mơnih nư̆n angăn la Simôn, mơnih plơi Siren. Ñu la ama Aleksandrơ sơ̆ng Ruphus. ");
INSERT INTO cje_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Buơl guñu ba Yàng Jêsu truh tơ sa anih, angăn la Gôgôtha, mơblàng la anih Brò Akŏ. ");
INSERT INTO cje_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Buơl guñu brơi Pô mơñŭm tơpai jrơu sơ̆ng c̆ài-trŭ, bloh Pô 'buh mơñŭm. ");
INSERT INTO cje_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Tŭ pơ̆ng Pô tơ kơyơu pơkăl bơjơ, buơl guñu pơrpha gơŭ ào agàh Pô, suă khà tô thơu aràng sơi hũ hơgĕ. ");
INSERT INTO cje_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Guñu pơ̆ng Pô tơ kơyơu pơkăl lăm tŭ sơlpăn jơ ờm. ");
INSERT INTO cje_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Pơnuaĭ ngă nìn-glài Pô hũ wă tơ ngŏ sa blơ kơmàn la: “Pơtau Buơl Làng Juđa.” ");
INSERT INTO cje_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Tŭ nư̆n, buơl guñu kŭng pơ̆ng dua aràng mơnih blơ̆ găm sơ̆ng Pô rơi, sa aràng pơ̆ng lăm kơyơu pơkăl gah hơnuă, sa aràng pơ̆ng lăm kơyơu pơkăl gah ơñiau. ");
INSERT INTO cje_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Nư̆n la hũ iơŭ yơu pơnuaĭ lăm 'Bồn Bơ-àr Sơc̆ih-Sri lài: “Pô hũ kŏng kơrhia găm lăm tơrpuơl du mơnih glài-sơnoh.” ");
INSERT INTO cje_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Tơgrơ̆ mơnih nau găn nư̆n klau-pơtăt tơ Pô, rơñah akŏ sơ̆ng đờm: “Hơi! Hã la mơnih hũ rơgơi ngă jơrlơh-tơrlŭng sàng duh-dơlbăt sơ̆ng bơ̆ pơdơ̆ng wơ̆ lăm klơu hơrơi, ");
INSERT INTO cje_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","c̆ơ dŏng bĕ rùp-phŭn drơi sơ̆ng trŭn klàh mư̆ng kơyơu pơkăl c̆ơ!” ");
INSERT INTO cje_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt sơ̆ng du mơnih gơnuăr-pơto pơnuaĭ adăt-adia kŭng đờm klau-pơtăt Pô yơu nư̆n rơi. Buơl guñu đờm sơ̆ng gơŭ: “Ñu hũ dŏng mơnih pơkơ̆n; bloh 'buh rơgơi dŏng rùp-phŭn drơi! ");
INSERT INTO cje_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ơ Pô Krist, Pơtau buơl làng Israel, tŭ ni c̆ơ trŭn bĕ mư̆ng kơyơu pơkăl, tô buơl gudrơi 'buh sơ̆ng păng tui!” Dua aràng mơnih blơ̆ kŏng pơ̆ng găm sơ̆ng Pô kŭng đờm klau-pơtăt Pô rơi. ");
INSERT INTO cje_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Mư̆ng sa-pluh dua jơ hơrơi dơ̆ng tơ̆l truh tơ klơu jơ diơŭ, abih tơgrơ̆ anih jiơ̆ng mơsrư̆-kơnăm c̆ik-c̆òk. ");
INSERT INTO cje_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Tŭ klơu jơ diơŭ, Yàng Jêsu iơu prŏng săp: “Elôi, Elôi, lama sabaktani?” Kơtha mơblàng la: “Khoai Yàng Pô Lơngì dơlhă, khoai Yàng Pô Lơngì dơlhă, kơđa hơgĕ Pô klà luơi dơlhă?” ");
INSERT INTO cje_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Mơhư̆ yơu nư̆n, du mơnih dò dơ̆ng jĕ tơ anih nư̆n đờm lài: “C̆ơ dih, ñu iơu Eli.” ");
INSERT INTO cje_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Hũ sa aràng mơnih lăm tơrpuơl buơl guñu đuaĭ mă sa boh phơ̆n kơsồp, ơñrŭ baŭ ia mơsăm, akă tơ akŏ gai pơrbo, pơyơ̆r đì tơ Pô mơñŭm, sơ̆ng đờm: “Kừ luơi yơu nư̆n, c̆ơ Eli hũ truh dŏng ñu trŭn ơu.” ");
INSERT INTO cje_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yàng Jêsu iơu sa săp prŏng, bloh nư̆n kloh suàn. ");
INSERT INTO cje_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Khăn dơrnìng lăm sàng duh-dơlbăt tơrhĕt jiơ̆ng dua mư̆ng ngŏ trŭn tơ ala. ");
INSERT INTO cje_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Mơnih apăn-akŏ sa rơtùh lĭng dò dơ̆ng tơ anaŭ kơyơu pơkăl, 'buh Pô kloh suàn yơu nư̆n, đờm lài: “Mơnih ni iơŭ biă la Anà Yàng Pô Lơngì!” ");
INSERT INTO cje_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Kŭng hũ du mơnih kơmơi dò dơ̆ng c̆ơ mư̆ng atàh. Lăm du mơnih kơmơi nư̆n hũ Mari Mađơlen, Mari ame Jakơ tìt sơ̆ng Jôse, sơ̆ng Salôme. ");
INSERT INTO cje_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Du mơnih kơmơi ni la du mơnih jiăng nau tui sơ̆ng dŏng duh bruă Yàng Jêsu tŭ Pô dò lăm Galile; kŭng hũ lô mơnih kơmơi pơkơ̆n rơi, la du mơnih hũ tui Pô đì nau tơ Jerusalem. ");
INSERT INTO cje_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Tŭ nư̆n la hơrơi Rơc̆ăng Dơlhơu, nư̆n la hơrơi dơlhơu tơ hơrơi sa'bat; tŭ glai diơŭ bơjơ, ");
INSERT INTO cje_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","hũ sa aràng mơnih angăn la Jôsep, dò lăm plơi-prŏng Arimathe, sa aràng mơnih hũ c̆ơ la prŏng-màng lăm Tơrpuơl Gơnuăr Apăn-Akŏ, sơ̆ng kŭng la mơnih sơđaŭ kraŭ-c̆àng lơgăr Yàng Pô Lơngì. Ñu hĭl-pràn hơtai-hơtiàn truh tòm sơ̆ng Pilat tô yòng mă rùp atơu Yàng Jêsu. ");
INSERT INTO cje_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Tŭ mơhư̆ đờm la Pô mơtai bơjơ, Pilat mă ngă krơi-takơtuă, nư̆n iơu mơnih apăn-akŏ sa rơtùh lĭng truh tô tơnia c̆ơ Pô mơtai suơi jơ. ");
INSERT INTO cje_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Hơdơi tŭ hũ păng mơnih apăn-akŏ sa rơtùh lĭng đờm akhàn wơ̆ mư̆ng abih tơgrơ̆ bruă, Pilat jào rùp atơu tơ Jôsep. ");
INSERT INTO cje_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Jôsep blơi sa blah bơ-yài lơmŭn, apăn rùp atơu Pô trŭn mư̆ng kơyơu pơkăl, mă bơ-yài lơmŭn nư̆n pơpò wơ̆, bloh nư̆n apăn daŭ lăm sa boh kŭt atơu hũ phàt lờih lăm tơli pơtơu prŏng. Ñu kŭng pơrlơ̆ sa boh pơtơu kơdrơ̆ bơbah kŭt atơu wơ̆. ");
INSERT INTO cje_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mari Mađơlen sơ̆ng Mari ame Jôse hũ 'buh loh-làng anih buơl guñu dơ̆r Pô. ");
INSERT INTO cje_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Pơrpa abih hơrơi sa'bat, Mari Mađơlen, Mari ame Jakơ, sơ̆ng Salôme, blơi jrào 'bơu bơlhơu tô nau lŭ atơu Yàng Jêsu. ");
INSERT INTO cje_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Hơrơi c̆ơmrừp lăm sa tơjuh, mư̆ng ờm rìng, tŭ ia-hơrơi pơrpa tơgồ, klơu aràng buơl guñu nau truh tơ kŭt atơu. ");
INSERT INTO cje_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Buơl guñu đờm sơ̆ng gơŭ: “Aràng sơi rơŭ pơlơ̆ boh pơtơu kơdrơ̆ tơ bơbah kŭt atơu tơ buơl gudrơi?” ");
INSERT INTO cje_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Kơyoa boh pơtơu nư̆n prŏng biă. Bloh tŭ c̆ơ tơ ngŏ, buơl guñu 'buh boh pơtơu kơdrơ̆ bơbah kŭt atơu hũ pơlơ̆ sơgah bơjơ. ");
INSERT INTO cje_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Tŭ tơma lăm kŭt atơu, buơl guñu 'buh sa aràng mơnih lơkơi dăm c̆ù ào kò, dò guh tơ gah hơnuă, nư̆n buơl guñu takơtuă huơĭ biă. ");
INSERT INTO cje_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Bloh mơnih nư̆n đờm sơ̆ng buơl guñu: “Juơi huơĭ kơđa! Kơu thơu buơl guhã duah Yàng Jêsu mơnih Nasaret, la Pô hũ kŏng pơ̆ng tơ kơyơu pơkăl. Pô hơdiŭ wơ̆ bơjơ, 'buh dò tơ anih ni tra. C̆ơ bĕ, nư̆n la anih buơl guñu hũ daŭ Pô. ");
INSERT INTO cje_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Bloh nau bĕ, đờm tơ du mơnih tui-mơgru Pô sơ̆ng Pier thơu lài Pô rơŭ truh tơ Galile dơlhơu buơl guhã. Tơ anih nư̆n, buơl guhã rơŭ hũ 'buh Pô, yơu Pô hũ đờm dơlhơu sơ̆ng buơl guhã.” ");
INSERT INTO cje_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Du mơnih kơmơi nư̆n tơbiă mư̆ng kŭt atơu, đuaĭ dò dơŭ, kơyoa kơtơ̆ drơi sơ̆ng takơtuă huơĭ biă. Buơl guñu 'buh khĭn đờm hơgĕ sơ̆ng aràng sơi, kơyoa huơĭ kìr biă. ");
INSERT INTO cje_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Hơdơi tŭ hơdiŭ wơ̆ lăm ờm rìng hơrơi c̆ơmrừp lăm sa tơjuh, dơlhơu biă Yàng Jêsu tơbiă pơ'buh tơ Mari Mađơlen, la mơnih hũ Pô prơh pơtơbiă tơjuh drơi kơmlài mơsak-jơhà. ");
INSERT INTO cje_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ñu nau akhàn pơthơu tơ abih du mơnih mư̆ng dơlhơu hũ dò sơ̆ng Pô bloh ni dò dơnuh-dơnà hia c̆ŏ. ");
INSERT INTO cje_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Bloh tŭ buơl guñu mơhư̆ Mari Mađơlen đờm lài Pô hũ hơdiŭ wơ̆ bơjơ sơ̆ng rùp-phŭn ñu hũ 'buh Pô, nư̆n buơl guñu 'buh păng-tui. ");
INSERT INTO cje_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Hơdơi mư̆ng nư̆n, Yàng Jêsu angui rùp-rơ̆p pơkơ̆n tơbiă pơ'buh tơ dua aràng lăm tơrpuơl du mơnih tui-mơgru, tŭ buơl guñu lăm jơlàn nau wơ̆ tơ plơi. ");
INSERT INTO cje_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Dua aràng mơnih ni gài mơrai nau đờm akhàn wơ̆ tơ du mơnih tui-mơgru pơkơ̆n, bloh buơl guñu kŭng 'buh păng-tui. ");
INSERT INTO cje_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Hơdơi mư̆ng nư̆n wơ̆, Yàng Jêsu tơbiă pơ'buh tơ sa-pluh sa aràng mơnih tui-mơgru lăm tŭ buơl guñu dò huă 'bơ̆ng. Pô puaĭ buah buơl guñu mư̆ng pơnuaĭ 'buh păng-tui sơ̆ng kră-khăng hơtai-hơtiàn, kơyoa buơl guñu 'buh păng-tui du mơnih hũ 'buh Pô hơdơi tŭ Pô hơdiŭ wơ̆. ");
INSERT INTO cje_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Pô đờm sơ̆ng buơl guñu: “Nau bĕ lăm abih dun-ya, pơto-akhàn Pơnuaĭ-Siàm tơ tơgrơ̆ mơnih. ");
INSERT INTO cje_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Aràng sơi păng-tui sơ̆ng đồ-mă pơnuaĭ 'baptem, rơŭ hũ dŏng-pơklàh; bloh aràng sơi 'buh păng-tui, nư̆n rơŭ kŏng ngă nìn-glài. ");
INSERT INTO cje_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Du mơnih păng-tui rơŭ hũ du nàl-c̆rih ni tui găm: Buơl guñu rơŭ mă angăn Kơu pơtrơh kơmlài, buơl guñu rơŭ đờm du ia bơrhơu, ");
INSERT INTO cje_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","mă ala lăm tơngàn, yah buơl guñu mơñŭm gò jrào mă ngă pơmơtai mơnih, buơl guñu kŭng 'buh kơđòng mơtai lơhiă hơgĕ, sơ̆ng tŭ buơl guñu daŭ tơngàn tơ ngŏ mơnih lơ-ơ̆n lơngoh rơwă-sơkì, nư̆n mơnih lơ-ơ̆n lơngoh rơwă-sơkì rơŭ hũ pơsồ-pơsaih.” ");
INSERT INTO cje_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Hơdơi tŭ đờm tơgrơ̆ pơnuaĭ nư̆n sơ̆ng du mơnih tui-mơgru, Yàng Jêsu hũ rò-đì tơ ngŏ lơngì sơ̆ng dò guh tơ gah hơnuă Yàng Pô Lơngì. ");
INSERT INTO cje_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Du mơnih tui-mơgru tơbiă nau pơto-akhàn Pơnuaĭ-Siàm lăm abih tơgrơ̆ anih. Yàng ngă bruă găm sơ̆ng buơl guñu, sơ̆ng angui du nàl-c̆rih tui găm tô ngă pràn-kơjăp jơlàn păng-tui.");
INSERT INTO cje_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ơ Theôphil, mơnih siàm-mơyòm biă, kơyoa hũ lô mơnih abih hơtai-hơtiàn wă pioh luơi wơ̆ mư̆ng tơgrơ̆ bruă hũ ngă tơbiă tơkrah buơl gudrơi, ");
INSERT INTO cje_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","tui yơu pơnuaĭ du mơnih hũ tơ mơta 'buh mư̆ng tŭ c̆ơmrừp sơ̆ng tơbiă jiơ̆ng mơnih pơto-akhàn pơnuaĭ Yàng, hũ đờm akhàn wơ̆ tơ buơl gudrơi. ");
INSERT INTO cje_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Kơyoa nư̆n, hơdơi tŭ c̆ơ-duah nĭ-nùn mư̆ng c̆ơmrừp abih tơgrơ̆ bruă, dơlhă sơnư̆ng kŭng păl tui rơnaŭ dơlhơu-hơdơi bloh wă tơ kơi, ");
INSERT INTO cje_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","tô kơi thơu tơgrơ̆ pơnuaĭ drơi hũ mơgru la nìn-kơjăp biă. ");
INSERT INTO cje_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Lăm rài Herôt, pơtau lơgăr Juđe, hũ sa aràng mơnih gơnuăr pơyă phơ̆n duh-dơlbăt, lăm tơrpuơl Abija, angăn la Sac̆ari. Sơdiŭ ñu la Elisabet, kŭng lăm jơi-pơtiàn Arôn. ");
INSERT INTO cje_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Abih dua aràng buơl guñu la mơnih rĭng-tơpă tơ anaŭ Yàng Pô Lơngì, hơdiŭ păng-bơbah ngă tui tơgrơ̆ pơnuaĭ adăt-pơđăr sơ̆ng pơnuaĭ Yàng pơto-pơđăr, 'buh hũ anih lơi tô puaĭ 'buah jiơ̆ng. ");
INSERT INTO cje_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Bloh dua aràng buơl guñu 'buh hũ anà, kơyoa Elisabet kơtuăl, sơ̆ng abih dua aràng prŏng thŭn bơjơ. ");
INSERT INTO cje_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Bruă tơbiă truh tŭ Sac̆ari tui rơnaŭ tơrpuơl drơi, ngă gơnuăr bruă pơyă phơ̆n duh-dơlbăt tơ anaŭ Yàng Pô Lơngì. ");
INSERT INTO cje_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Tŭ suă-khà tui adăt-lơđăp du mơnih gơnuăr pơyă phơ̆n duh-dơlbăt, nư̆n Sac̆ari hũ iơŭ khà tơma pơyă gơlhơu lăm anih sơc̆ih-sri Yàng. ");
INSERT INTO cje_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Lăm jơ pơyă gơlhơu, abih tơrpuơl buơl làng dò iơu-lài tơ gah agàh. ");
INSERT INTO cje_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Tŭ nư̆n hũ sa aràng mơnih gơdrưh Yàng tơbiă pơ'buh sơ̆ng Sac̆ari, dò dơ̆ng tơ gah hơnuă c̆ơnừng c̆uh gơlhơu. ");
INSERT INTO cje_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","'Buh mơnih gơdrưh, Sac̆ari 'buh suk dò, sơ̆ng huơĭ kơđa biă. ");
INSERT INTO cje_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Bloh mơnih gơdrưh đờm sơ̆ng ñu: “Ơ Sac̆ari, juơi huơĭ! Kơyoa pơnuaĭ hã iơu-lài hũ Yàng Pô Lơngì păng bơjơ. Elisabet, sơdiŭ hã, rơŭ đih apui sa aràng anà lơkơi, sơ̆ng hã rơŭ pơ-angăn mơta tơ anà lơkơi nư̆n la Jăng. ");
INSERT INTO cje_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Anà lơkơi nư̆n rơŭ la pơnuaĭ sờh-sài prŏng tơ hã, sơ̆ng lô mơnih kŭng rơŭ sờh-sài tŭ ñu hũ đih apui. ");
INSERT INTO cje_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Kơyoa anà tìt nư̆n rơŭ hũ c̆ơ prŏng-màng tơ anaŭ Yàng, ñu 'buh mơñŭm tơpai halài phơ̆n hơgĕ ngă tô mơbŭ, sơ̆ng rơŭ hũ baŭ-bèng Yàng Bơngă Sơc̆ih-Sri mư̆ng tŭ dò lăm tŭng ame. ");
INSERT INTO cje_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Anà tìt nư̆n rơŭ ba lô mơnih Israel gài mơrai wơ̆ sơ̆ng Yàng, la Yàng Pô Lơngì buơl guñu, ");
INSERT INTO cje_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","anà lơkơi nư̆n rơŭ mă hơtai-bơngă sơ̆ng gơnăp-gơnuăr mơnih gơnuăr-hwơ̆r Eli bloh nau tơ anaŭ Yàng, tô ngă tơ hơtai-hơtiàn ama gài mơrai wơ̆ sơ̆ng anà, du mơnih 'buh păng-bơbah ngă tui gài mơrai wơ̆ tui pơnuaĭ jak-khờh mơnih rĭng-tơpă, tô rơc̆ăng lờih sa buơl làng hũ hơtai-hơtiàn wă-rò Yàng.” ");
INSERT INTO cje_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sac̆ari đờm sơ̆ng mơnih gơdrưh: “Ngă hơyơu dơlhă thơu bruă ni rơŭ tơbiă truh? Kơyoa dơlhă tha bơjơ, sơ̆ng sơdiŭ dơlhă kŭng prŏng thŭn bơjơ!” ");
INSERT INTO cje_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Mơnih gơdrưh đờm: “Kơu la Gabriel. Kơu jiăng dò dơ̆ng tơ anaŭ Yàng Pô Lơngì. Pô hũ pơđăr kơu truh đờm sơ̆ng hã sơ̆ng đờm brơi tơ hã thơu mư̆ng pơnuaĭ sờh-sài ni. ");
INSERT INTO cje_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ni, hã rơŭ kơmlo, 'buh đờm jiơ̆ng tơ̆l truh tơ hơrơi du bruă nư̆n tơbiă truh, kơyoa hã 'buh păng-tui pơnuaĭ kơu, la du pơnuaĭ rơŭ tơbiă truh iơŭ tŭ-hơrơi hũ ngă-nìn tơ guñu.” ");
INSERT INTO cje_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Lăm tŭ nư̆n, buơl làng dò c̆àng Sac̆ari tơbiă, sơ̆ng mă ngă krơi-takơtuă kơyoa ñu dò suơi lăm anih sơc̆ih-sri. ");
INSERT INTO cje_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Tŭ nau tơbiă, Sac̆ari 'buh rơgơi đờm jiơ̆ng sơ̆ng buơl làng, nư̆n ka buơl guñu kràn-thơu lài Sac̆ari hũ 'buh sa pơnuaĭ brơi pơ'buh lăm anih sơc̆ih-sri. Sac̆ari mĭn ngă nàl sơ̆ng buơl guñu bloh 'buh rơgơi đờm, kơyoa ñu sơđaŭ dò kơmlo. ");
INSERT INTO cje_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Tŭ du hơrơi ngă gơnuăr bruă lăm anih sàng duh-dơlbăt hũ abih, Sac̆ari gài nau wơ̆ sàng. ");
INSERT INTO cje_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Hơdơi du hơrơi nư̆n, sơdiŭ ñu la Elisabet hũ mơtiàn, sơ̆ng hơdiŭ bơdơŭ rùp lăm lơma blàn, bloh đờm lài: ");
INSERT INTO cje_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Ni la pơnuaĭ anĭt Yàng hũ ngă tơ dơlhă, tŭ Pô hũ sơdơ̆r truh dơlhă, tô suă thĭt pơnuaĭ mơlơu alah dơlhă tơkrah tơgrơ̆ mơnih.” ");
INSERT INTO cje_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Tŭ Elisabet hũ mơtiàn năm blàn, nư̆n Yàng Pô Lơngì pơđăr mơnih gơdrưh Gabriel truh tơ sa plơi-prŏng lăm c̆àr Galile, angăn la Nasaret, ");
INSERT INTO cje_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","tòm sa aràng mơnih kơmơi dra sơc̆ih-sơc̆ăn hũ c̆ĕ-sơnuai sơ̆ng sa aràng mơnih lơkơi angăn la Jôsep, lăm jơi-pơtiàn Đabit. Mơnih kơmơi dra sơc̆ih-sơc̆ăn nư̆n angăn la Mari. ");
INSERT INTO cje_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Mơnih gơdrưh truh sơ̆ng Mari, sơ̆ng đờm: “Ơ mơnih hũ pơnuaĭ anĭt, sờh-sài tơ hã, Yàng dò sơ̆ng hã!” ");
INSERT INTO cje_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mơhư̆ pơnuaĭ nư̆n, Mari 'buh suk dò, sơ̆ng tơnia rùp-phŭn pơnuaĭ tơnia-c̆uă nư̆n hũ mơblàng hơgĕ. ");
INSERT INTO cje_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Mơnih gơdrưh đờm: “Ơ Mari, juơi huơĭ! Kơyoa hã hũ pơnuaĭ anĭt tơ anaŭ Yàng Pô Lơngì. ");
INSERT INTO cje_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ni, hã rơŭ hũ mơtiàn sơ̆ng đih apui sa aràng anà lơkơi; hã rơŭ pơ-angăn mơta tơ anà lơkơi nư̆n la Jêsu. ");
INSERT INTO cje_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Anà lơkơi nư̆n rơŭ hũ c̆ơ prŏng-màng, hũ angăn la Anà Pô Ngŏ Glòng Rơlau Abih; sơ̆ng Yàng, la Yàng Pô Lơngì, rơŭ brơi tơ Pô sơbàn Đabit, la kơi-kŏ pàng-yau Pô. ");
INSERT INTO cje_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Pô rơŭ apăn-akŏ sàng Jakôp rài pơdò rài, lơgăr Pô rơŭ dò mĭt-mĭt 'buh tŭ lơi luĭ.” ");
INSERT INTO cje_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mari đờm sơ̆ng mơnih gơdrưh: “Dơlhă ka đih dò sơ̆ng sa aràng mơnih lơkơi lơi, nư̆n ngă hơyơu hũ pơnuaĭ nư̆n jiơ̆ng?” ");
INSERT INTO cje_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Mơnih gơdrưh đờm: “Yàng Bơngă Sơc̆ih-Sri rơŭ truh tơ ngŏ hã, sơ̆ng gơnăp-gơnuăr Pô Ngŏ Glòng Rơlau Abih rơŭ jơ̆m gòm hã. Kơyoa nư̆n, Anà sơc̆ih-sri tơbiă rài, rơŭ hũ angăn la Anà Yàng Pô Lơngì. ");
INSERT INTO cje_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Dih, Elisabet, mơnih gơŭ-pơtiàn hã, kŭng hũ mơtiàn sa aràng anà lơkơi lăm tŭ tha-rơma bơjơ. Mơnih nư̆n sơđaŭ hũ tiơ̆ng la kơtuăl, bloh ni hũ mơtiàn năm blàn bơjơ. ");
INSERT INTO cje_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kơyoa, 'buh hũ bruă hơgĕ Yàng Pô Lơngì 'buh ngă jiơ̆ng.” ");
INSERT INTO cje_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mari đờm: “Dơlhă ni la mơnih hơlŭn-hơlă Yàng. Yòng pơnuaĭ nư̆n tơbiă truh tơ dơlhă yơu pơnuaĭ pô đờm!” Bloh nư̆n, mơnih gơdrưh luơi Mari sơ̆ng nau. ");
INSERT INTO cje_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Lăm du hơrơi nư̆n, Mari tơgồ dơ̆ng, tơmbah-tơmbàn nau truh tơ sa plơi-prŏng lăm c̆àr c̆ơ̆-c̆ờr lơgăr Juđe. ");
INSERT INTO cje_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ñu tơma lăm sàng Sac̆ari sơ̆ng tơnia c̆uă-rơwăng Elisabet. ");
INSERT INTO cje_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Pơrpa mơhư̆ săp Mari tơnia c̆uă-rơwăng, anà lăm tŭng Elisabet c̆oh-sơglŏng mư. Elisabet hũ baŭ-bèng Yàng Bơngă Sơc̆ih-Sri. ");
INSERT INTO cje_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ñu pồ săp đờm prŏng: “Adơi la mơnih hũ lơngai-pơtuah biă tơkrah tơgrơ̆ mơnih kơmơi, anà lăm tŭng adơi kŭng hũ lơngai-pơtuah rơi. ");
INSERT INTO cje_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Kơyoa mư̆ng lơi dơlhă hũ pơnuaĭ sờh prŏng ni, nư̆n la ame Yàng dơlhă truh c̆uă-rơwăng dơlhă? ");
INSERT INTO cje_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Kơyoa ni, tŭ tơnia dơlhă pơrpa mơhư̆ săp adơi tơnia c̆uă-rơwăng, nư̆n anà lăm tŭng dơlhă sờh-sài c̆oh-sơglŏng mư. ");
INSERT INTO cje_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Lơngai-pơtuah tơ mơnih hũ păng-tui lài Yàng rơŭ ngă tơgrơ̆ pơnuaĭ Pô hũ đờm sơ̆ng drơi.” ");
INSERT INTO cje_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mari đờm: “Bơngă-joa dơlhă mơyòm-pơglòng Yàng, ");
INSERT INTO cje_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Hơtai-bơngă dơlhă sờh-sài lăm Yàng Pô Lơngì la Yàng dŏng-pơklàh dơlhă. ");
INSERT INTO cje_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Kơyoa Pô hũ c̆ơ-sơnư̆ng truh pơnuaĭ 'buh sơ̆p 'buh màng mơnih hơlŭn-hơlă Pô. Ni, mư̆ng ni truh hơdơi, tơgrơ̆ jơi-rài rơŭ mơyòm dơlhă la mơnih hũ lơngai-pơtuah; ");
INSERT INTO cje_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Kơyoa Pô Gơnăp-Gơnuăr Wĭl-Tơ̆l hũ ngă du bruă prŏng tơ dơlhă, Angăn Pô la Sơc̆ih-Sri, ");
INSERT INTO cje_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Sơ̆ng Pô anĭt-rơnăm tơgrơ̆ mơnih duh-huơĭ Pô, Mư̆ng rài ni truh rài dih. ");
INSERT INTO cje_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Pô hũ angui tơngàn Pô ngă tơgrơ̆ bruă gơnăp-gơnuăr, Ngă kơprah-kơprĭng du mơnih hũ hơtai sơnư̆ng pơglòng-rùp. ");
INSERT INTO cje_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Pô suă pơtrŭn du mơnih hũ gơnuăr klàh mư̆ng sơbàn buơl guñu, Sơ̆ng pồ-pơđì tơgrơ̆ mơnih pơ-ơneh rùp đì. ");
INSERT INTO cje_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Pô brơi tơ mơnih ờ-lơpa hũ baŭ phơ̆n-kơya 'bơ̆ng bơngi, Sơ̆ng prơh mơnih mơda nau wơ̆ tơngàn soh. ");
INSERT INTO cje_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Pô hũ dŏng-kờl Israel, hơlŭn-hơlă Pô, Sơ̆ng sơdơ̆r wơ̆ pơnuaĭ anĭt-rơnăm Pô, ");
INSERT INTO cje_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Yơu hũ đờm pơguăn sơ̆ng kơi-kŏ pàng-yau buơl gudrơi, Sơ̆ng Abraham sơ̆ng jơi-pơtiàn ñu truh rài pơdò rài.” ");
INSERT INTO cje_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mari dò sơ̆ng Elisabet pơgăp klơu blàn, bloh nư̆n gài mơrai wơ̆ tơ sàng drơi. ");
INSERT INTO cje_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Truh hơrơi đih apui, Elisabet đih apui sa aràng anà lơkơi. ");
INSERT INTO cje_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Mơhư̆ thơu pơnuaĭ Yàng hũ ràng-tơbiă hơtai-hơtiàn anĭt-rơnăm prŏng sơ̆ng Elisabet, nư̆n gơŭ-plơi jơi-pơtiàn truh pơrpha pơnuaĭ sờh-sài sơ̆ng ñu. ");
INSERT INTO cje_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Tŭ anà tìt hũ tơlpăn hơrơi, buơl guñu truh ngă adăt koh kơlì tơ anà tìt sơ̆ng pơ-angăn mơta la Sac̆ari, tui mơta ama ñu. ");
INSERT INTO cje_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Bloh mơnih ame đờm lài: “'Buh ơu! Păl pơ-angăn mơta ñu la Jăng.” ");
INSERT INTO cje_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Buơl guñu đờm sơ̆ng Elisabet: “Lăm gơŭ-pơtiàn mò 'buh aràng sơi hũ mơta nư̆n!” ");
INSERT INTO cje_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Buơl guñu ngă nàl tơnia ama adơi tìt tô c̆ơ ñu khiăng pơ-angăn mơta anà la hơgĕ. ");
INSERT INTO cje_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sac̆ari pơđăr apăn tơ ñu sa blah kơmàn tìt, sơ̆ng wă: “Mơta ñu la Jăng.” Aràng sơi aràng nư̆n kŭng mă ngă takơtuă soh. ");
INSERT INTO cje_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Lăm tŭ nư̆n mư, pơbah Sac̆ari hũ pơh tơbiă, dơlah ñu hũ bơhiàn siàm; ñu đờm jiơ̆ng sơ̆ng adoh-mơyòm Yàng Pô Lơngì. ");
INSERT INTO cje_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Abih gơŭ-plơi jơi-pơtiàn huơĭ kơđa biă, sơ̆ng aràng đờm rak-sa mư̆ng bruă ni lăm abih c̆àr c̆ơ̆-c̆ờr lơgăr Juđe. ");
INSERT INTO cje_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Abih tơgrơ̆ mơnih lơi mơhư̆ pơnuaĭ nư̆n, aràng sơi kŭng pioh sơdơ̆r lăm hơtai-hơtiàn, sơ̆ng đờm: “'Buh thơu hơdơi ni anà tìt nư̆n rơŭ hơyơu lơi?” Kơyoa biă, tơngàn Yàng hũ dò sơ̆ng anà tìt nư̆n. ");
INSERT INTO cje_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Sac̆ari, ama anà tìt nư̆n, hũ baŭ-bèng Yàng Bơngă Sơc̆ih-Sri đờm hwơ̆r lài: ");
INSERT INTO cje_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Mơyòm-pơglòng Yàng, la Yàng Pô Lơngì Israel, Kơyoa Pô hũ c̆uă-rơwăng sơ̆ng dŏng-pơklàh buơl làng Pô. ");
INSERT INTO cje_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Pô hũ pồ-pơtơgồ tơ buơl gudrơi, lăm sàng Đabit, hơlŭn-hơlă Pô, Sa Pô Dŏng-Pơklàh hũ gơnăp-gơnuăr. ");
INSERT INTO cje_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Yơu Pô hũ angui bơbah du mơnih gơnuăr-hwơ̆r sơc̆ih-sri đờm pơguăn mư̆ng rài yau, ");
INSERT INTO cje_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Pô dŏng-pơklàh buơl gudrơi klàh mư̆ng du mơnih mơbai-tămdră, Sơ̆ng klàh mư̆ng tơngàn du mơnih mơbai-lơmù buơl gudrơi. ");
INSERT INTO cje_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Pô hũ ràng-tơbiă hơtai-hơtiàn anĭt-rơnăm sơ̆ng kơi-kŏ pàng-yau buơl gudrơi, Sơ̆ng sơdơ̆r wơ̆ pơnuaĭ pơguăn-pơđoàn sơc̆ih-sri Pô, ");
INSERT INTO cje_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Yơu pơnuaĭ Pô hũ tơpah-sri sơ̆ng Abraham, la kơi-kŏ pàng-yau buơl gudrơi, ");
INSERT INTO cje_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Lài tŭ buơl gudrơi hũ dŏng-tơleh klàh mư̆ng tơngàn mơnih mơbai-tămdră, Pô rơŭ brơi buơl gudrơi hũ dŏng duh bruă Pô 'buh sa-sĭt huơĭ kơđa, ");
INSERT INTO cje_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Lăm pơnuaĭ sơc̆ih-sri sơ̆ng rĭng-tơpă, Tơ anaŭ Pô luĭ rài buơl gudrơi. ");
INSERT INTO cje_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ơ anà tìt, aràng rơŭ iơu angăn anà la mơnih gơnuăr-hwơ̆r Pô Ngŏ Glòng Rơlau Abih, Anà rơŭ nau tơ anaŭ Yàng, waìh rơc̆ăng jơlàn tơ Pô, ");
INSERT INTO cje_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Tô buơl làng Pô, gơnừm tơ pơnuaĭ anĭt toh-luơi glài-sơnoh, Bloh thơu pơnuaĭ dŏng-pơklàh. ");
INSERT INTO cje_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Kơyoa hơtai-hơtiàn anĭt-rơnăm mư̆ng Yàng Pô Lơngì buơl gudrơi, Bloh ia-hơrơi mư̆ng anih lơngì glòng c̆uă-rơwăng buơl gudrơi, ");
INSERT INTO cje_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Tô pơsàng sơrdah tơ du mơnih dò guh lăm anih kơnăm-mơsrư̆, Sơ̆ng tơ du mơnih dò guh lăm lơhui pơnuaĭ mơtai, Tô dùi ba plà tơkai buơl gudrơi tơma lăm jơlàn pơnuaĭ rĭng-lơngai.” ");
INSERT INTO cje_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Anà tìt 'brŏ prŏng, hơtai-bơngă 'brŏ pràn-khăng, hơdiŭ lăm anih 'blàng-jơhua tơ̆l truh tơ hơrơi tơbiă mơta sơ̆ng buơl làng Israel. ");
INSERT INTO cje_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Tŭ nư̆n, pơtau Rôma Sesa Ôgustơ, pơtơbiă pơnuaĭ gơnuăr-pơđăr, pơđăr abih tơgrơ̆ buơl làng lăm du lơgăr dò tơ ala gơnuăr Sesa Rôma apăn-akŏ, păl wă angăn mơta lăm bơ-àr. ");
INSERT INTO cje_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ni la pơnuaĭ wă angăn mơta buơl làng amăng c̆ơmrừp rơlau abih, hũ ngă lăm rài Kirinius la mơnih kwăng-prŏng apăn-akŏ c̆àr Siri. ");
INSERT INTO cje_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Abih tơgrơ̆ mơnih păl mơrai wơ̆ tơ plơi-phŭn tô wă angăn mơta lăm bơ-àr. ");
INSERT INTO cje_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Kơyoa Jôsep la jơi-pơtiàn sàng Đabit, nư̆n kŭng mư̆ng plơi-prŏng Nasaret, c̆àr Galile, đì tơ plơi-prŏng Đabit, angăn la 'Betlehem, lăm c̆àr Juđe, ");
INSERT INTO cje_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","tô wă angăn mơta drơi sơ̆ng mơta Mari, la mơnih hũ c̆ĕ-sơnuai sơ̆ng drơi, tŭ nư̆n dò hũ mơtiàn. ");
INSERT INTO cje_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Lăm tŭ dua aràng dò tơ 'Betlehem, nư̆n hơrơi Mari đih apui anà hũ truh. ");
INSERT INTO cje_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ñu đih apui anà lơkơi kơc̆oa, mă khăn pơpò anà drơi, pơđih lăm bòng rơ̆, kơyoa sàng apah-đih 'buh dò anih tơ buơl guñu. ");
INSERT INTO cje_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Kŭng lăm c̆àr nư̆n, hũ du mơnih glăng abo hơdiŭ lăm 'blàng, dò guah mơlăm khiă-gàr tơrpuơl abo. ");
INSERT INTO cje_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Sa aràng mơnih gơdrưh Yàng tơbiă pơ'buh sơ̆ng buơl guñu, pơnuaĭ màng-kơc̆rà Yàng pơsàng kơc̆rà tòmdăr, nư̆n buơl guñu huơĭ kơđa biă. ");
INSERT INTO cje_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Bloh mơnih gơdrưh đờm sơ̆ng buơl guñu: “Juơi huơĭ! Kơyoa ni, kơu akhàn brơi pơthơu tơ buơl guhã sa pơnuaĭ siàm, rơŭ la sa pơnuaĭ sờh-sài prŏng tơ abih tơgrơ̆ mơnih; ");
INSERT INTO cje_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","nư̆n la hơrơi ni, lăm plơi-prŏng Đabit, hũ đih apui tơ buơl guhã sa Pô Dŏng-Pơklàh, la Pô Krist, la Yàng. ");
INSERT INTO cje_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ni la nàl pơto tô buơl guhã kràn thơu Pô: Buơl guhã rơŭ 'buh sa aràng Anà Mơnga pơpò sơ̆ng khăn, đih lăm bòng rơ̆.” ");
INSERT INTO cje_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Mơre-mơro, hũ rơbơu-rơbơu lĭng gơdrưh ngŏ lơngì găm sơ̆ng mơnih gơdrưh nư̆n pồ săp adoh-mơyòm Yàng Pô Lơngì lài: ");
INSERT INTO cje_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Sơrdah angăn Yàng tơ ngŏ du tăl lơngì glòng, Rĭng-lơngai lăm ala lơ̆n tơ du mơnih hũ Yàng rơnăm.” ");
INSERT INTO cje_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Hơdơi tŭ du mơnih gơdrưh luơi buơl guñu đì tơ ngŏ lơngì bơjơ, du mơnih glăng abo đờm sơ̆ng gơŭ lài: “Buơl gudrơi nau truh bĕ tơ plơi-prŏng 'Betlehem, c̆ơ bruă pơrpa hũ tơbiă truh, bloh Yàng hũ brơi buơl gudrơi thơu.” ");
INSERT INTO cje_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Yơu nư̆n, buơl guñu tơmbah-tơmbàn nau jơlàn. Truh anih, buơl guñu 'buh Mari, Jôsep, sơ̆ng Anà Mơnga dò đih lăm bòng rơ̆. ");
INSERT INTO cje_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","'Buh yơu nư̆n, buơl guñu đờm akhàn wơ̆ tơgrơ̆ pơnuaĭ mơnih gơdrưh hũ đờm mư̆ng Anà Tìt nư̆n. ");
INSERT INTO cje_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Mơhư̆ pơnuaĭ du mơnih glăng abo đờm yơu nư̆n, aràng sơi kŭng mă ngă c̆rih-takơtuă biă. ");
INSERT INTO cje_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Bloh Mari nư̆n pioh sơdơ̆r abih tơgrơ̆ pơnuaĭ nư̆n, sơ̆ng sơnư̆ng-bơngoàn lăm hơtai-hơtiàn. ");
INSERT INTO cje_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Du mơnih glăng abo gài mơrai wơ̆, ngă màng-kơc̆rà angăn sơ̆ng adoh-mơyòm Yàng Pô Lơngì mư̆ng tơgrơ̆ pơnuaĭ buơl guñu hũ mơhư̆ sơ̆ng 'buh, iơŭ yơu pơnuaĭ hũ đờm pơthơu dơlhơu tơ buơl guñu. ");
INSERT INTO cje_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Tŭ Anà Mơnga hũ tơ̆l tơlpăn hơrơi, la tŭ păl ngă adăt sơkaŭ-kơlì tơ Anà Mơnga, nư̆n buơl guñu pơ-angăn la Jêsu, la mơta bloh mơnih gơdrưh hũ pơ-angăn, dơlhơu tơ tŭ Mari hũ mơtiàn. ");
INSERT INTO cje_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Tŭ du hơrơi ngă pơsơc̆ih-goh tui adăt Môise hũ kloh, Jôsep sơ̆ng Mari apăn anà tìt đì tơ plơi-prŏng Jerusalem tô pơyă tơ Yàng, ");
INSERT INTO cje_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","yơu hũ wă lăm pơnuaĭ adăt-adia Yàng lài: “Yàu anà lơkơi kơc̆oa, păl pioh krơi sơc̆ih-sri tơ Yàng,” ");
INSERT INTO cje_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","sơ̆ng pơyă sa yơu c̆ĭm kơtrơu, halài dua drơi c̆ĭm kơtrơu tìt, yơu pơnuaĭ adăt-adia Yàng hũ pơto-pơđăr. ");
INSERT INTO cje_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Tŭ nư̆n, lăm plơi-prŏng Jerusalem hũ sa aràng mơnih rĭng-tơpă sơ̆ng abih hơtai-hơtiàn păng-tui pơnuaĭ Yàng, angăn la Simeôn. Ñu dò kraŭ-c̆àng pơnuaĭ pơluơ-pơrơngài buơl làng Israel, sơ̆ng Yàng Bơngă Sơc̆ih-Sri dò sơ̆ng ñu. ");
INSERT INTO cje_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Yàng Bơngă Sơc̆ih-Sri hũ brơi ñu thơu dơlhơu lài ñu rơŭ 'buh mơtai dơlhơu tơ tŭ hũ 'buh Pô Krist Yàng. ");
INSERT INTO cje_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Hũ Bơngă Sơc̆ih-Sri dùi ba, ñu tơma lăm sàng duh-dơlbăt, iơŭ lăm tŭ Mari sơ̆ng Jôsep ba anà tìt la Jêsu truh, tô ngă tơ̆l tơ Pô du bruă tui yơu pơnuaĭ adăt-adia hũ ngă-nìn. ");
INSERT INTO cje_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeôn pồ anà tìt lăm tơngàn sơ̆ng mơyòm-pơglòng Yàng Pô Lơngì lài: ");
INSERT INTO cje_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Khoai Yàng, tŭ ni yòng brơi mơnih hơlŭn-hơlă Pô hũ mơtai rĭng-lơngai, Tui yơu pơnuaĭ Pô hũ đờm. ");
INSERT INTO cje_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Kơyoa mơta anà hũ 'buh pơnuaĭ dŏng-pơklàh Pô, ");
INSERT INTO cje_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Bloh Pô hũ rơc̆ăng dơlhơu tơ anaŭ abih tơgrơ̆ buơl làng, ");
INSERT INTO cje_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","La pơnuaĭ sơrdah pơsàng jơlàn tơ du buơl làng agàh, Sơ̆ng la pơnuaĭ màng-kơc̆rà tơ buơl làng Israel, la buơl làng Pô.” ");
INSERT INTO cje_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ame ama anà tìt, la Jôsep sơ̆ng Mari, mă ngă krơi-takơtuă biă mư̆ng du pơnuaĭ Simeôn hũ đờm mư̆ng Pô. ");
INSERT INTO cje_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeôn lơkơu lơngai-pơtuah tơ dua aràng sơdiŭ pơsàng, bloh nư̆n đờm sơ̆ng Mari, ame Pô: “Anà tìt ni hũ ngă-nìn, rơŭ la pơnuaĭ ngă tơ lô mơnih lăm Israel sơnĕ lơbuh halài tơgồ dơ̆ng, sơ̆ng la sa nàl ngă tơbiă pơnuaĭ đờm tăm-mơsau tămdră, ");
INSERT INTO cje_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","tô du pơnuaĭ sơnư̆ng-bơngoàn tơrđơŭ-dơrlăm lăm hơtai-hơtiàn lô mơnih rơŭ hũ ràng-tơbiă. Dò rùp-phŭn hã, hã rơŭ pơđì-pơđoa yơu kŏng sa 'bĕ đào klơŭ hơluh tơma lăm hơtai-hơtiàn.” ");
INSERT INTO cje_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Kŭng hũ mò gơnuăr-hwơ̆r Anne, anà kơmơi Phanuel, lăm jơi-pơtiàn Aser. Mò prŏng thŭn biă, hơdơi tŭ khiăng lơkơi sơ̆ng hơdiŭ sơ̆ng pơsàng hũ tơjuh thŭn, ");
INSERT INTO cje_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","bloh nư̆n dò bơdrau, truh ni hũ tơlpăn pluh pà thŭn bơjơ. Mò 'buh tŭ lơi tơbiă mư̆ng sàng duh-dơlbăt, kừ mơlăm-hơrơi dŏng duh bruă Yàng, wèr 'bơ̆ng sơ̆ng iơu-lài. ");
INSERT INTO cje_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Lăm tŭ nư̆n, mò kŭng truh tơ anih nư̆n, adoh-mơyòm Yàng Pô Lơngì, sơ̆ng đờm mư̆ng anà tìt tơ tơgrơ̆ mơnih dò kraŭ-c̆àng pơnuaĭ dŏng-pơklàh plơi-prŏng Jerusalem. ");
INSERT INTO cje_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Tŭ Jôsep sơ̆ng Mari hũ ngă tơ̆l abih tơgrơ̆ bruă tui pơnuaĭ adăt-adia Yàng pơto-pơđăr, nư̆n buơl guñu gài mơrai wơ̆ tơ plơi-prŏng phŭn drơi la Nasaret, lăm c̆àr Galile. ");
INSERT INTO cje_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Anà tìt 'brŏ hơrơi 'brŏ prŏng, sơ̆ng pràn-khăng, hũ baŭ-bèng pơnuaĭ jak-khờh, sơ̆ng pơnuaĭ anĭt-brơi-soh Yàng Pô Lơngì dò tơ ngŏ Pô. ");
INSERT INTO cje_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Yàu thŭn, truh pơnuaĭ pơjŭm 'bơ̆ng Nau-Găn, ame ama Yàng Jêsu jiăng đì nau tơ plơi-prŏng Jerusalem. ");
INSERT INTO cje_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Tŭ hũ sa-pluh dua thŭn, Pô găm sơ̆ng ame ama Pô, đì nau tơ Jerusalem tui lơđăp-bơhiàn. ");
INSERT INTO cje_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Tŭ du hơrơi pơjŭm 'bơ̆ng hũ kloh bơjơ, buơl guñu gài mơrai wơ̆ tơ sàng, bloh lơkơi dăm tìt Jêsu nư̆n dò wơ̆ tơ Jerusalem, bloh ame ama Pô 'buh thơu. ");
INSERT INTO cje_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Buơl guñu sơnư̆ng la Pô nau găm sơ̆ng tơrpuơl mơnih lăm jơlàn nau wơ̆, nư̆n hơdơi sa hơrơi nau jơlàn nư̆n ka duah tơnia Pô tơkrah du mơnih gơŭ-găn sơ̆ng du mơnih adơi-ai gơŭ. ");
INSERT INTO cje_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Bloh tŭ duah 'bu 'buh Pô, Mari sơ̆ng Jôsep gài wơ̆ tơ plơi-prŏng Jerusalem tô duah Pô. ");
INSERT INTO cje_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Hơdơi klơu hơrơi, Jôsep sơ̆ng Mari duah 'buh Pô lăm anih sàng duh-dơlbăt, dò guh tơkrah du mơnih pôgru prŏng, găm dò păng găm đờm tơnia. ");
INSERT INTO cje_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Abih tơgrơ̆ mơnih dò păng Pô, aràng sơi aràng nư̆n kŭng mă ngă krơi-takơtuă biă mư̆ng pơnuaĭ jak-khờh sơ̆ng tơgrơ̆ pơnuaĭ Pô đờm sơđồ. ");
INSERT INTO cje_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Tŭ Jôsep sơ̆ng Mari 'buh Pô, nư̆n mă ngă krơi-takơtuă biă, sơ̆ng ame Pô đờm sơ̆ng Pô: “Ơ anà, kơđa hơgĕ anà ngă tơ ame ama yơu nư̆n? Ni, ama anà sơ̆ng ame hũ nau duah anà sơ̆ng sơnư̆ng kơ-ù tơ anà thơu hơdùm!” ");
INSERT INTO cje_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Pô đờm sơđồ: “Kơđa ame ama păl sơnư̆ng kơ-ù duah anà? Ame ama 'buh thơu lài anà păl sơnư̆ng-rơc̆ăng bruă tơ sàng Ama anà ơu?” ");
INSERT INTO cje_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Bloh Jôsep sơ̆ng Mari 'buh wờng du pơnuaĭ Pô đờm sơ̆ng buơl guñu. ");
INSERT INTO cje_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Hơdơi mư̆ng nư̆n, Pô nau tui ame ama gài mơrai wơ̆ tơ Nasaret, sơ̆ng păng-bơbah ngă tui ame ama. Ame Pô pioh sơdơ̆r abih tơgrơ̆ pơnuaĭ nư̆n lăm hơtai-hơtiàn. ");
INSERT INTO cje_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yàng Jêsu 'brŏ jak-khờh rơlau, rùp-phàp 'brŏ prŏng, 'brŏ hũ siàm hơtai Yàng Pô Lơngì sơ̆ng anà mơnih. ");
INSERT INTO cje_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Thŭn sa-pluh lơma lăm rài Sesa Tiber, tŭ 'Bônsơ Pilat ngă kwăng-prŏng apăn-akŏ c̆àr Juđe, Herôt Antipa ngă pơtau-tìt apăn-akŏ c̆àr Galile, Philip adơi pơtau nư̆n, ngă pơtau-tìt apăn-akŏ c̆àr Iture sơ̆ng c̆àr Trakônit, Lisanias ngă pơtau-tìt apăn-akŏ c̆àr Abilen. ");
INSERT INTO cje_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anne sơ̆ng Kaiphe ngă mơnih gơnuăr prŏng apăn-akŏ pơyă phơ̆n duh-dơlbăt — nư̆n hũ pơnuaĭ Yàng Pô Lơngì đờm sơ̆ng Jăng, anà Sac̆ari, lăm anih 'blàng jơhua. ");
INSERT INTO cje_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Jăng nau truh lăm abih tơgrơ̆ c̆àr tòmdăr ia-sơdờng Jôđăn, pơto-akhàn adăt 'baptem mư̆ng bruă mơbai prah-luơi pơnuaĭ sŭng tô hũ anĭt toh-luơi glài-sơnoh, ");
INSERT INTO cje_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","yơu pơnuaĭ hũ wă lăm 'Bồn Bơ-àr mơnih gơnuăr-hwơ̆r Êsai: “Hũ săp mơnih iơu driau lăm 'blàng-jơhua: Waìh rơc̆ăng bĕ jơlàn tơ Yàng, ngă pơtơpă jơlàn nau tơ Pô. ");
INSERT INTO cje_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Du anih plŭng-gờl păl dơ̆r baŭ, Du c̆ơ̆-c̆ờr păl lài pơtrŭn tơ ala; Jơlàn kwĕt-kwĕl păl ngă pơtơpă, Jơlàn plŭng-gờl păl ngă tô rĭng. ");
INSERT INTO cje_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Sơ̆ng abih dun-ya rơŭ 'buh pơnuaĭ dŏng-pơklàh Yàng Pô Lơngì.” ");
INSERT INTO cje_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Kơyoa nư̆n, Jăng đờm sơ̆ng tơrpuơl buơl làng truh tô đồ-mă pơnuaĭ 'baptem lài: “Ơ jơi-pơtiàn ala mơsak-jơhà dih! Aràng sơi hũ đờm tơ buơl guhã thơu tô pleh klàh pơnuaĭ anok-anoa prŏng kơjĕ truh? ");
INSERT INTO cje_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Yơu nư̆n, tơbiă bơnga boh bĕ iơŭ păl sơ̆ng pơnuaĭ buơl guhã mơbai prah-luơi glài-sơnoh; sơ̆ng juơi sơnư̆ng lài: ‘Abraham la kơi-kŏ pàng-yau buơl gudrơi.’ Kơyoa kơu đờm tơ buơl guhã thơu: Yàng Pô Lơngì hũ rơgơi ngă du boh pơtơu ni tơbiă jiơ̆ng anà-tơc̆o tơ Abraham jiơ̆ng. ");
INSERT INTO cje_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ni, jòng hũ daŭ jĕ tơ phŭn kơyơu bơjơ. Yah kơyơu lơi 'buh tơbiă boh siàm, nư̆n rơŭ kŏng dròm sơ̆ng prah lăm apui.” ");
INSERT INTO cje_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Buơl làng tơnia Jăng: “Yơu nư̆n buơl dơlhă păl ngă hơgĕ?” ");
INSERT INTO cje_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Jăng đờm: “Aràng sơi hũ dua blah ào, mă bĕ sa blah pơrpha tơ mơnih 'buh hũ; sơ̆ng aràng sơi hũ phơ̆n-kơya 'bơ̆ng, nư̆n kŭng ngă yơu nư̆n rơi.” ");
INSERT INTO cje_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Kŭng hũ du mơnih rì-mă jia truh tô đồ-mă pơnuaĭ 'baptem, buơl guñu tơnia: “Ơ pô-pơto, buơl dơlhă păl ngă hơgĕ?” ");
INSERT INTO cje_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Jăng đờm lài: “Juơi rì-mă rơlau tơ khà hũ ngă-nìn.” ");
INSERT INTO cje_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Du mơnih lĭng kŭng tơnia: “Dò buơl dơlhă nư̆n păl ngă hơgĕ?” Jăng đờm sơđồ: “Juơi pơhuơĭ halài yă-bơdah lơ̆r aràng sơi tô mă priă, bloh păl sờh-siàm hơtai-hơtiàn mư̆ng priă blàn drơi đồ-lĕng hũ.” ");
INSERT INTO cje_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Kơyoa abih buơl làng sơđaŭ kraŭ-c̆àng, sơ̆ng lăm hơtai-hơtiàn, aràng sơi aràng nư̆n kŭng khiăng thơu Jăng hũ iơŭ la Pô Krist ơu. ");
INSERT INTO cje_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Nư̆n Jăng đờm sơ̆ng abih tơgrơ̆ mơnih: “Dơlhă ngă 'baptem tơ buơl adơi-ai sơ̆ng ia; bloh hũ sa Pô gơnăp-gơnuăr rơlau tơ dơlhă rơŭ truh, dơlhă 'buh iơŭ păl tô tơleh tơlơi kơjuă tơ Pô. Pô rơŭ ngă 'baptem tơ buơl adơi-ai sơ̆ng Yàng Bơngă Sơc̆ih-Sri sơ̆ng apui. ");
INSERT INTO cje_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Tơngàn Pô apăn kơrnừh tô ngă goh làn bơdai drơi, sơ̆ng mă bơdai pioh lăm bŭng; bloh pồng sơ̆ng bơdai bo nư̆n c̆uh lăm apui 'buh tŭ lơi mơtai.” ");
INSERT INTO cje_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jăng kŭng angui lô pơnuaĭ pơto-pơthơu pơkơ̆n bloh pơto-akhàn Pơnuaĭ-Siàm tơ buơl làng. ");
INSERT INTO cje_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Bloh tŭ Herôt, mơnih hũ Sesa Rôma brơi gơnuăr ngă pơtau-tìt apăn-akŏ c̆àr Galile, hũ kŏng Jăng đờm pơkơŭ-khă mư̆ng bruă khiăng sơ̆ng Herôđias, sơdiŭ adơi ñu, sơ̆ng mư̆ng tơgrơ̆ bruă glài-sơnoh mơsak-jơhà bloh Herôt hũ ngă, ");
INSERT INTO cje_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","nư̆n Herôt dò ngă sa pơnuaĭ glài-sơnoh mơsak-jơhà tra wơ̆, la mă Jăng krơ̆ lăm sàng jàm. ");
INSERT INTO cje_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Tŭ abih buơl làng hũ đồ-mă pơnuaĭ 'baptem, Yàng Jêsu kŭng truh đồ-mă pơnuaĭ 'baptem. Tŭ Pô dò iơu-lài, nư̆n lơngì pơh tơbiă, ");
INSERT INTO cje_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","sơ̆ng Yàng Bơngă Sơc̆ih-Sri lăm rùp-rơ̆p mơhiơ̆ yơu c̆ĭm kơtrơu, trŭn đơ̆m tơ ngŏ Pô. Sơ̆ng hũ săp mư̆ng ngŏ lơngì đờm lài: “Anà la Anà Kơu uơ̆n-rơnăm, siàm hơtai Kơu lăm abih tơgrơ̆ mơta!” ");
INSERT INTO cje_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yàng Jêsu tơma ngă gơnuăr bruă tŭ Pô pơgăp klơu pluh thŭn. Tui aràng păng-tui nư̆n Pô la anà Jôsep, Jôsep anà Heli, ");
INSERT INTO cje_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli anà Mattat, Mattat anà Lebi, Lebi anà Melc̆i, Melc̆i anà Jane, Jane anà Jôsep, ");
INSERT INTO cje_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Jôsep anà Matathias, Matathias anà Amôs, Amôs anà Nahum, Nahum anà Etli, Etli anà Nage, ");
INSERT INTO cje_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nage anà Maat, Maat anà Matathias, Matathias anà Semein, Semein anà Jôsek, Jôsek anà Jôđa, ");
INSERT INTO cje_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Jôđa anà Jôanan, Jôanan anà Resa, Resa anà Sôrôbabel, Sôrôbabel anà Salathiel, Salathiel anà Neri, ");
INSERT INTO cje_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri anà Melc̆i, Melc̆i anà Ađi, Ađi anà Kôsam, Kôsam anà Elmađam, Elmađam anà Er, ");
INSERT INTO cje_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er anà Jêsu, Jêsu anà Eliese, Eliese anà Jôrim, Jôrim anà Matthat, Matthat anà Lebi, ");
INSERT INTO cje_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lebi anà Simeôn, Simeôn anà Juđa, Juđa anà Jôsep, Jôsep anà Jônam, Jônam anà Eliakim, Eliakim anà Melea, ");
INSERT INTO cje_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Melea anà Menna, Menna anà Mattatha, Mattatha anà Nathan, Nathan anà Đabit, ");
INSERT INTO cje_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Đabit anà Jese, Jese anà Ôbet, Ôbet anà Bôô, Bôô anà Salmôn, Salmôn anà Naasôn, ");
INSERT INTO cje_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasôn anà Aminađap, Aminađap anà Atni, Atni anà Hesrôn, Hesrôn anà Pheres, Pheres anà Juđa, ");
INSERT INTO cje_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juđa anà Jakôp, Jakôp anà Isak, Isak anà Abraham, Abraham anà Terah, Terah anà Nakôr, ");
INSERT INTO cje_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nakôr anà Seruk, Seruk anà Rehu, Rehu anà Pelek, Pelek anà Heber, Heber anà Selah, ");
INSERT INTO cje_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Selah anà Kainan, Kainan anà Arpaksat, Arpaksat anà Sem, Sem anà Nôe, Nôe anà Lemek, ");
INSERT INTO cje_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lemek anà Metusela, Metusela anà Enôk, Enôk anà Jeret, Jeret anà Mahalalel, Mahalalel anà Kenan, ");
INSERT INTO cje_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan anà Enôs, Enôs anà Set, Set anà Ađam, Ađam anà Yàng Pô Lơngì. ");
INSERT INTO cje_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yàng Jêsu baŭ-bèng Yàng Bơngă Sơc̆ih-Sri, mư̆ng ia sơdờng Jôđăn gài mơrai wơ̆, sơ̆ng hũ Bơngă Sơc̆ih-Sri ba tơma lăm 'blàng-jơhua. ");
INSERT INTO cje_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Pô dò tơ anih nư̆n pà pluh hơrơi sơ̆ng kŏng kơmlài pơluơ-ơñiai. Lăm du hơrơi nư̆n, Pô 'buh 'bơ̆ng phơ̆n hơgĕ. Hơdơi du hơrơi nư̆n, Pô lơpa. ");
INSERT INTO cje_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Kơmlài đờm sơ̆ng Pô: “Yah hã la Anà Yàng Pô Lơngì, nư̆n pơđăr bĕ pơtơu ni tơbiă jiơ̆ng pah!” ");
INSERT INTO cje_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yàng Jêsu đờm: “Hũ pơnuaĭ wă: ‘Anà mơnih hơdiŭ 'buh iơŭ mĭn gơnừm tơ pah soh.’ ” ");
INSERT INTO cje_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Hơdơi mư̆ng nư̆n, kơmlài ba Pô đì tơ anih glòng, pơto tơ Pô 'buh abih tơgrơ̆ lơgăr dun-ya lăm sa-sĭt tŭ, ");
INSERT INTO cje_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","bloh nư̆n ñu đờm sơ̆ng Pô: “Kơu rơŭ brơi tơ hã abih tơgrơ̆ gơnuăr apăn-akŏ găm sơ̆ng pơnuaĭ màng-kơc̆rà du lơgăr nư̆n, kơyoa gơnuăr nư̆n hũ jào tơ kơu bơjơ, sơ̆ng kơu khiăng brơi tơ aràng sơi tui hơtai kơu. ");
INSERT INTO cje_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Nư̆n tŭ ni, yah hã c̆ĕ khoai kơu, kơu rơŭ brơi tơ hã abih tơgrơ̆ pơnuaĭ nư̆n.” ");
INSERT INTO cje_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yàng Jêsu đờm: “Hũ pơnuaĭ wă: ‘Hã păl duh-dơlbăt Yàng, la Yàng Pô Lơngì hã, sơ̆ng mĭn duh bruă sa aràng Pô soh.’ ” ");
INSERT INTO cje_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Kơmlài kŭng ba Pô truh tơ plơi-prŏng Jerusalem, daŭ Pô tơ ngŏ bơbŭng sàng duh-dơlbăt sơ̆ng đờm: “Yah hã la Anà Yàng Pô Lơngì, nư̆n c̆ơ kơsĕt trŭn bĕ; ");
INSERT INTO cje_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","kơyoa hũ pơnuaĭ wă: ‘Yàng rơŭ pơđăr du mơnih gơdrưh Pô c̆ơ-gàr hã,’ ");
INSERT INTO cje_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","‘Du pô nư̆n rơŭ pồ-đơ̆ng hã lăm tơngàn, huơĭ tơkai hã sơnĕ gò tơ pơtơu ơu!’ ” ");
INSERT INTO cje_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yàng Jêsu đờm: “Hũ pơnuaĭ đờm: ‘Hã juơi lòng Yàng la Yàng Pô Lơngì hã.’ ” ");
INSERT INTO cje_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Hơdơi tŭ hũ angui abih tơgrơ̆ pơnuaĭ tô pơluơ-ơñiai Pô, kơmlài luơi Pô bloh nau, dò c̆àng tŭ hơnàn pơkơ̆n. ");
INSERT INTO cje_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yàng Jêsu gài mơrai wơ̆ tơ c̆àr Galile sơ̆ng baŭ-bèng gơnăp-gơnuăr Bơngă Sơc̆ih-Sri. Angăn Pô hũ tiơ̆ng-dơnài lăm abih tơgrơ̆ c̆àr tòmdăr. ");
INSERT INTO cje_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Pô pơto-pơsài lăm du sàng pơtòm, sơ̆ng hũ abih tơgrơ̆ mơnih mơyòm-pơglòng. ");
INSERT INTO cje_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yàng Jêsu truh tơ plơi-prŏng Nasaret, la anih Pô hơdiŭ mư̆ng tìt truh tơ prŏng. Tui lơđăp-bơhiàn, lăm hơrơi sa'bat, Pô truh tơ sàng pơtòm, dò dơ̆ng tô pơrpoh-c̆ơ 'Bồn Bơ-àr Sơc̆ih-Sri. ");
INSERT INTO cje_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Hũ mơnih brơi tơ Pô 'Bồn Bơ-àr mơnih gơnuăr-hwơ̆r Êsai, Pô pơh bơ-àr, sơ̆ng duah 'buh anih hũ wă: ");
INSERT INTO cje_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Bơngă Sơc̆ih-Sri Yàng dò tơ ngŏ Kơu, Kơyoa Pô hũ lŭ mơñà tơ Kơu tô pơto-akhàn Pơnuaĭ-Siàm tơ mơnih rơ'bah rơ'bừp. ");
INSERT INTO cje_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Pô hũ pơđăr Kơu tô đờm pơthơu tơ du mơnih kơđòng jàm-krơ̆ hũ toh-tơleh, Mơnih bồm-mơsrư̆ hũ sơrdah mơta, Mơnih kŏng kơtơ̆-juă hũ akŏ-lơhuai tơkai-lơnàng, Sơ̆ng đờm brơi thơu tŭ-hơrơi Yàng rơŭ ràng-tơbiă hơtai-hơtiàn siàm Pô.” ");
INSERT INTO cje_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yàng Jêsu blì 'bồn bơ-àr wơ̆, jào tơ mơnih dŏng bruă sàng pơtòm, bloh nư̆n dò guh. Abih tơgrơ̆ mơnih lăm sàng pơtòm nĭ-nùn c̆ơ tơ Pô. ");
INSERT INTO cje_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Pô đờm sơ̆ng buơl guñu: “Hơrơi ni pơnuaĭ lăm 'Bồn Bơ-àr Sơc̆ih-Sri bloh buơl guhã pơrpa păng-mơhư̆ hũ tơbiă iơŭ tơpă.” ");
INSERT INTO cje_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Abih tơgrơ̆ mơnih ngă grơh siàm mư̆ng Pô, sơ̆ng mă ngă krơi-takơtuă mư̆ng du pơnuaĭ baŭ pơnuaĭ anĭt tơbiă mư̆ng bơbah Pô. Buơl guñu đờm tơnia gơŭ: “Mơnih ni 'buh iơŭ la anà Jôsep ơu?” ");
INSERT INTO cje_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Pô đờm sơ̆ng buơl guñu: “Kơu thơu buơl guhã khiăng đờm sơ̆ng Kơu pơnuaĭ kơtha-pơđik ni: ‘Ơ mơnih gơnuăr jrào, pơsồ-pơsaih bĕ tơ rùp-phŭn drơi! Tơgrơ̆ bruă hơgĕ buơl dơlhă mơhư̆ kơi hũ ngă lăm Kapenaum, nư̆n kŭng ngă bĕ tơ anih ni, la plơi-lơgăr phŭn kơi!’ ” ");
INSERT INTO cje_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Bloh nư̆n Pô đờm: “Iơŭ biă, Kơu đờm sơ̆ng buơl guhã, 'buh sa aràng mơnih gơnuăr-hwơ̆r lơi hũ wă-rò lăm plơi-lơgăr phŭn drơi. ");
INSERT INTO cje_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Biă yơu nư̆n, Kơu đờm sơ̆ng buơl guhã, lăm rài Eli, tŭ lơngì kơtoa lăm luĭ klơu thŭn năm blàn, abih sa lơgăr kơđòng pơnuaĭ ờ lơpa prŏng, sơ̆ng lăm buơl làng Israel kŭng hũ lô mơnih kơmơi bơdrau, ");
INSERT INTO cje_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","bloh Eli 'buh hũ pơđăr nau truh sơ̆ng sa aràng mơnih lơi lăm du mơnih kơmơi bơdrau nư̆n, bloh hũ pơđăr truh sơ̆ng sa aràng mơnih kơmơi bơdrau dò lăm Sarepta, c̆àr Siđôn. ");
INSERT INTO cje_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Lăm rài mơnih gơnuăr-hwơ̆r Elise, kŭng hũ lô mơnih dŭn lăm lơgăr Israel, bloh 'buh sa aràng mơnih lơi lăm buơl guñu hũ goh, mĭn sa aràng Naaman, mơnih lơgăr Siri soh.” ");
INSERT INTO cje_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Tŭ mơhư̆ yơu nư̆n, abih tơgrơ̆ mơnih lăm sàng pơtòm anok hơtai biă. ");
INSERT INTO cje_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Buơl guñu tơgồ dơ̆ng, hua Pô tơbiă tơ agàh plơi-prŏng, ba Pô đì tơ bơbŭng c̆ơ̆, la anih aràng bơ̆ plơi-prŏng, tô prah Pô trŭn tơ ala. ");
INSERT INTO cje_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Bloh Pô sơrlèt găn tơkrah buơl guñu sơ̆ng nau tơ anih pơkơ̆n. ");
INSERT INTO cje_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yàng Jêsu trŭn tơ plơi-prŏng Kapenaum, sa plơi-prŏng dò lăm c̆àr Galile, sơ̆ng pơto-pơsài lăm hơrơi sa'bat. ");
INSERT INTO cje_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Buơl guñu mă ngă krơi-takơtuă biă mư̆ng pơnuaĭ Pô pơto-mơblàng, kơyoa pơnuaĭ Pô hũ gơnăp-gơnuăr. ");
INSERT INTO cje_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Tŭ nư̆n, lăm sàng pơtòm hũ sa aràng mơnih kơđòng kơmlài ngă. Mơnih nư̆n driau prŏng: “Ơ Jêsu mơnih Nasaret! ");
INSERT INTO cje_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Buơl dơlhă sơ̆ng Pô hũ pơnuaĭ hơgĕ rơi bloh Pô truh tô pơluĭ-pơlơhiă buơl dơlhă? Dơlhă thơu Pô la aràng sơi. Pô la Pô Sơc̆ih-Sri Yàng Pô Lơngì!” ");
INSERT INTO cje_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Bloh Yàng Jêsu puaĭ traŭ tơ ñu: “Dò kơđơ̆ng bĕ, sơ̆ng tơbiă klàh mư̆ng mơnih ni!” Kơmlài sơboh lơbuh mơnih nư̆n tơkrah tơrpuơl mơnih lô, bloh nư̆n tơbiă klàh, 'buh ngă jơhà hơgĕ truh tơ mơnih nư̆n. ");
INSERT INTO cje_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Abih tơgrơ̆ mơnih huơĭ kơđa biă, đờm sơ̆ng gơŭ: “Pơnuaĭ nư̆n la hơyơu? Pô mă gơnăp-gơnuăr sơ̆ng gơnuăr-pràn bloh pơtrơh du kơmlài sơ̆ng guñu păl tơbiă mư!” ");
INSERT INTO cje_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Sơ̆ng pơnuaĭ tiơ̆ng-dơnài mư̆ng angăn Pô hũ dơlờng tơbiă lăm abih tơgrơ̆ c̆àr tòmdăr. ");
INSERT INTO cje_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Hơdơi tŭ tơbiă mư̆ng sàng pơtòm, Yàng Jêsu tơma lăm sàng Simôn. Tŭ nư̆n, ame-tămhã Simôn dò kơđòng lơ-ơ̆n pơrmă-mơrềt traŭ biă. Buơl guñu yòng Pô pơsồ-pơsaih tơ mò. ");
INSERT INTO cje_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Pô truh jĕ tơ gah c̆ơnừng, puaĭ pơđăr tơ pơnuaĭ pơrmă-mơrềt, pơnuaĭ pơrmă-mơrềt tơbiă klàh mư̆ng mò mư. Lăm tơk tŭ nư̆n, mò tơgồ dơ̆ng sơ̆ng rơc̆ăng duh bruă tơ tơgrơ̆ mơnih. ");
INSERT INTO cje_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Tŭ ia-hơrơi tơma, aràng ba du mơnih kơđòng tơ̆l tơgrơ̆ mơta lơ-ơ̆n lơngoh rơwă-sơkì truh sơ̆ng Pô. Pô daŭ tơngàn tơ ngŏ yàu aràng sơ̆ng pơsồ-pơsaih tơ buơl guñu. ");
INSERT INTO cje_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Du kơmlài kŭng tơbiă klàh mư̆ng lô mơnih sơ̆ng driau prŏng: “Pô la Anà Yàng Pô Lơngì!” Bloh Pô puaĭ traŭ tơ guñu sơ̆ng 'buh brơi gơnuăr guñu đờm, kơyoa guñu thơu Pô la Pô Krist. ");
INSERT INTO cje_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Pơrpa rìng sơrdah, Yàng Jêsu nau truh tơ sa anih jơhua-kơđơ̆ng. Tơrpuơl buơl làng nau duah Pô; tŭ păp hũ Pô, buơl guñu lơkơu-yòng Pô dò wơ̆ sơ̆ng buơl guñu, 'buh khiăng luơi Pô nau. ");
INSERT INTO cje_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Bloh Pô đờm sơ̆ng buơl guñu: “Kơu kŭng păl pơto-akhàn Pơnuaĭ-Siàm lơgăr Yàng Pô Lơngì tơ du plơi-prŏng pơkơ̆n wơ̆, kơyoa Kơu hũ pơđăr truh la tô ngă bruă-phŭn nư̆n.” ");
INSERT INTO cje_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Yơu nư̆n Pô truh pơto-akhàn lăm du sàng pơtòm c̆àr Juđe. ");
INSERT INTO cje_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Sa hơrơi dih, tŭ Yàng Jêsu dò dơ̆ng tơ gah dơnau prŏng Genesaret, tơrpuơl buơl làng sŭl-pơjeh gơŭ tòmdăr Pô tô păng pơnuaĭ Yàng Pô Lơngì. ");
INSERT INTO cje_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Pô 'buh dua boh gơlài dò pơdơh jĕ tơ gah ia; du mơnih ngă akàn nư̆n tơbiă mư̆ng gơlài sơ̆ng dò boh jàl sơñuăl. ");
INSERT INTO cje_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Pô đì sa boh gơlài lăm dua boh gơlài nư̆n, la gơlài Simôn, sơ̆ng pơđăr ñu wah nau đoh mư̆ng gah ia sa-sĭt; bloh nư̆n Pô dò guh lăm gơlài tô pơto-pơsài buơl làng. ");
INSERT INTO cje_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Hơdơi mư̆ng nư̆n, Pô đờm sơ̆ng Simôn: “Wah bĕ tơbiă tơ anih ia dơrlăm bloh dăng sơñuăl tô mă akàn.” ");
INSERT INTO cje_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simôn đờm: “Ơ Pô-Pơto, buơl dơlhă hũ ngă gleh-glăr luĭ mơlăm bloh 'buh mă hũ hơgĕ. Bloh păng-bơbah Pô-Pơto, dơlhă rơŭ dăng sơñuăl trŭn.” ");
INSERT INTO cje_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Buơl guñu dăng sơñuăl trŭn sơ̆ng mă hũ lô akàn biă, tơ̆l truh kơjĕ kloh sơñuăl. ");
INSERT INTO cje_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Kơyoa nư̆n buơl guñu păl ngă nàl iơu du adơi-ai gơŭ mư̆ng gơlài pơkơ̆n truh dŏng. Du mơnih nư̆n truh, pơdiăng akàn baŭ dua sruh gơlài, tơ̆l truh kơjĕ krăm. ");
INSERT INTO cje_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","'Buh yơu nư̆n, Simôn Pier pơđih rùp tơ anih tơkai Yàng Jêsu sơ̆ng đờm: “Khoai Yàng, yòng pleh atàh dơlhă, kơyoa dơlhă la mơnih glài-sơnoh.” ");
INSERT INTO cje_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Kơyoa Simôn sơ̆ng abih du mơnih dò tơ anih nư̆n sơ̆ng ñu, mă ngă krơi-takơtuă biă mư̆ng bruă dăng sơñuăl mă akàn nư̆n, găm Jakơ sơ̆ng Jăng anà Sebeđe, adơi-ai gơŭ sơ̆ng Simôn kŭng yơu nư̆n rơi. ");
INSERT INTO cje_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Yàng Jêsu đờm sơ̆ng Simôn: “Juơi huơĭ, mư̆ng ni hã rơŭ tơbiă jiơ̆ng mơnih dŏng ba mơnih pơkơ̆n mơrai tơ Kơu mơhiơ̆ yơu tơrgùm mă akàn.” ");
INSERT INTO cje_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Hơdơi tŭ kơtŭng gơlài tơma truh tơ gah ia, buơl guñu luơi abih tơgrơ̆ mơta bloh nau tui Pô. ");
INSERT INTO cje_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Tŭ Yàng Jêsu dò lăm sa plơi-prŏng dih, hũ sa aràng mơnih dŭn lơka baŭ rùp, 'buh Pô nư̆n pơđih rùp tơ ala lơ̆n, bloh lơkơu yòng: “Khoai Yàng, yah Yàng khiăng, Pô hũ rơgơi pơsồ tơ dơlhă hũ goh!” ");
INSERT INTO cje_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yàng Jêsu yơ̆r tơngàn tŭp truh mơnih nư̆n, sơ̆ng đờm: “Kơu khiăng, goh bĕ!” Lăm tơk tŭ nư̆n mư, dŭn lơka thĭt abih. ");
INSERT INTO cje_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yàng Jêsu pơkơŭ mơnih nư̆n 'buh hũ đờm akhàn wơ̆ sơ̆ng aràng sơi; bloh kơkơi pơđăr lài: “Nau bĕ truh pơto rùp sơ̆ng mơnih gơnuăr pơyă phơ̆n duh-dơlbăt, sơ̆ng pơyă phơ̆n c̆ĕ-pơyơ̆r duh-dơlbăt mư̆ng bruă hã hũ goh, tui yơu Môise hũ pơto, tô ngă grơh tơ buơl guñu.” ");
INSERT INTO cje_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Tŭ nư̆n pơnuaĭ tiơ̆ng-dơnài mư̆ng angăn Pô 'brŏ hơrơi 'brŏ dơlờng tơbiă. Lô tơrpuơl buơl làng ba gơŭ truh tô păng Pô, sơ̆ng buơl guñu ba du mơnih lơ-ơ̆n lơngoh rơwă-sơkì truh tô hũ Pô pơsồ-pơsaih. ");
INSERT INTO cje_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Bloh Pô jiăng pleh tơma lăm anih 'blàng jơhua tô iơu-lài. ");
INSERT INTO cje_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Sa hơrơi dih, tŭ Yàng Jêsu dò pơto-mơblàng, hũ du mơnih Pharisi sơ̆ng du mơnih gơnuăr-pơto pơnuaĭ adăt-adia mư̆ng du plơi lăm c̆àr Galile, c̆àr Juđe, sơ̆ng plơi-prŏng Jerusalem truh, dò guh tơ anih nư̆n. Gơnăp-gơnuăr Yàng dò sơ̆ng Pô tô pơsồ-pơsaih lơ-ơ̆n lơngoh rơwă-sơkì. ");
INSERT INTO cje_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Tŭ nư̆n, aràng sơkồng truh sa aràng mơnih lơ-ơ̆n mơtai tơkai-tơngàn dò đih lăm c̆ơnừng, buơl guñu duah ngă hơyơu tô ba mơnih nư̆n tơma lăm sàng sơ̆ng daŭ tơ anaŭ Pô. ");
INSERT INTO cje_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Bloh kơyoa tơrpuơl mơnih lô biă, 'buh rơgơi ba mơnih lơ-ơ̆n mơtai tơkai-tơngàn tơma jiơ̆ng, nư̆n buơl guñu đì tơ bơbŭng sàng, toh akiă tơbiă, bloh nư̆n pơtrŭn găm mơnih sơ̆ng c̆ơnừng trŭn tơpă tơ anaŭ Yàng Jêsu, tơkrah buơl mơnih lô. ");
INSERT INTO cje_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","'Buh buơl guñu hũ hơtai-hơtiàn păng-tui yơu nư̆n, Pô đờm: “Ơ anà, glài-sơnoh anà hũ anĭt toh-luơi bơjơ!” ");
INSERT INTO cje_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Du mơnih gơnuăr-pơto pơnuaĭ adăt-adia sơ̆ng mơnih Pharisi tơma đờm tăm-tơnia gơŭ: “Mơnih ni la aràng sơi bloh khĭn đờm sơk-sơrbĭl khĭn-dơmĭn yơu nư̆n? Rơlau tơ Yàng Pô Lơngì, aràng sơi hũ gơnuăr toh-luơi glài-sơnoh?” ");
INSERT INTO cje_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Bloh Yàng Jêsu thơu pơnuaĭ lăm hơtai-akŏ buơl guñu sơnư̆ng, nư̆n Pô đờm: “Kơđa hơgĕ buơl guhã sơnư̆ng tơnia lăm hơtai-hơtiàn yơu nư̆n? ");
INSERT INTO cje_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Lăm dua pơnuaĭ: sa la đờm: ‘Glài sơnoh anà hũ anĭt toh-luơi bơjơ,’ dua la đờm: ‘Tơgồ dơ̆ng sơ̆ng nau bĕ,’ pơnuaĭ lơi 'buơ̆n rơlau? ");
INSERT INTO cje_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Bloh tô buơl guhã thơu lài Anà Mơnih dò lăm dun-ya ni hũ gơnuăr toh-luơi glài-sơnoh...” Pô đờm sơ̆ng mơnih mơtai tơkai-tơngàn: “Kơu pơđăr anà, tơgồ dơ̆ng bĕ, gơlăm c̆ơnừng nau wơ̆ tơ sàng!” ");
INSERT INTO cje_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Lăm tŭ nư̆n mư, mơnih nư̆n tơgồ dơ̆ng tơ anaŭ buơl guñu, gơlăm c̆ơnừng drơi hũ đih, nau wơ̆ tơ sàng, sơ̆ng adoh-mơyòm Yàng Pô Lơngì. ");
INSERT INTO cje_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Aràng sơi aràng nư̆n kŭng mă ngă krơi-takơtuă biă; buơl guñu mơyòm-pơglòng Yàng Pô Lơngì sơ̆ng huơĭ-kơđa đờm sơ̆ng gơŭ: “Hơrơi ni buơl gudrơi hũ 'buh du bruă c̆rih-krơi biă.” ");
INSERT INTO cje_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Hơdơi mư̆ng nư̆n, Yàng Jêsu nau tơbiă tơ agàh sơ̆ng 'buh sa aràng mơnih rì-mă jia, angăn la Lebi, tŭ nư̆n dò guh tơ anih sàng rì-mă jia. Pô đờm sơ̆ng ñu: “Sơ-ai tui bĕ Kơu!” ");
INSERT INTO cje_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lebi luơi abih tơgrơ̆ mơta, tơgồ dơ̆ng nau tui Pô. ");
INSERT INTO cje_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lebi pồ pơnuaĭ 'bơ̆ng huă prŏng jà-rò Yàng Jêsu tơ sàng drơi. Hũ lô mơnih rì-mă jia sơ̆ng du mơnih pơkơ̆n dò guh huă 'bơ̆ng găm sơ̆ng Pô. ");
INSERT INTO cje_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Du mơnih Pharisi sơ̆ng du mơnih gơnuăr-pơto pơnuaĭ adăt-adia đờm yuăm sơ̆ng du mơnih tui-mơgru Pô lài: “Kơđa hơgĕ buơl guhã 'bơ̆ng huă găm sơ̆ng buơl mơnih rì-mă jia sơ̆ng buơl mơnih glài-sơnoh?” ");
INSERT INTO cje_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yàng Jêsu đờm sơ̆ng buơl guñu: “Mơnih pràn-khăng 'buh c̆àng mơnih gơnuăr jrào ơu, bloh la mơnih lơ-ơ̆n lơngoh rơwă-sơkì. ");
INSERT INTO cje_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Kơu 'buh truh tô iơu mơnih rĭng-tơpă, bloh iơu mơnih hũ glài-sơnoh mơbai prah-luơi pơnuaĭ sŭng.” ");
INSERT INTO cje_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Buơl guñu đờm sơ̆ng Pô: “Du mơnih tui-mơgru Jăng kŭng yơu du mơnih tui-mơgru tơrpuơl Pharisi jiăng wèr 'bơ̆ng sơ̆ng iơu-lài, bloh du mơnih tui-mơgru Pô-Pơto nư̆n 'bơ̆ng sơ̆ng mơñŭm!” ");
INSERT INTO cje_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yàng Jêsu đờm: “Lăm tŭ mơnih mơrtơu-lơkơi sơđaŭ dò sơ̆ng du mơnih adơi-ai gơŭ truh mơ-in sờh lăm pơnuaĭ mơñŭm 'bơ̆ng khiăng-gơŭ, buơl guhã hũ rơgơi pơkơŭ-pơđăr buơl guñu păl wèr 'bơ̆ng jiơ̆ng rơi? ");
INSERT INTO cje_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Bloh truh tŭ-hơrơi mơnih mơrtơu-lơkơi păl kŏng apăn nau klàh mư̆ng buơl guñu, tŭ nư̆n buơl guñu rơŭ wèr 'bơ̆ng.” ");
INSERT INTO cje_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Pô kŭng mă sa pơnuaĭ pơgăp-pơmơyơu bloh đờm sơ̆ng buơl guñu: “'Buh aràng sơi hĕt ào bơrhơu tô mă biài bàl ào klă. Kơyoa yơu nư̆n, ào bơrhơu rơŭ tơrhĕt, sơ̆ng pĕt biài bơrhơu kŭng 'buh iơŭ rơgăm sơ̆ng ào klă. ");
INSERT INTO cje_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Kŭng 'buh aràng sơi trĭng tơpai bơrhơu lăm gơdoh kơlì klă, kơyoa yơu nư̆n, tơpai bơrhơu ngă tơrhĕt gơdoh kơlì klă, tơpai hŏ abih, sơ̆ng gơdoh kơlì kŭng rơŭ 'buh angui jiơ̆ng tra. ");
INSERT INTO cje_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Bloh tơpai bơrhơu păl trĭng lăm gơdoh kơlì bơrhơu. ");
INSERT INTO cje_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Kŭng 'buh aràng sơi mơñŭm tơpai klă bloh đồ tơpai bơrhơu, kơyoa mơnih nư̆n đờm lài: ‘Tơpai klă bơngi rơlau.’ ” ");
INSERT INTO cje_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Lăm sa hơrơi sa'bat, Yàng Jêsu nau găn 'blàng hơma bơdai, du mơnih tui-mơgru Pô rơhòt du amùng bơdai, mă tơngàn pơrơpau bloh 'bơ̆ng. ");
INSERT INTO cje_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Hũ du mơnih Pharisi 'buh yơu nư̆n, đờm: “Kơđa hơgĕ buơl sơ-ai ngă pơnuaĭ 'buh hũ gơnuăr ngă lăm hơrơi sa'bat?” ");
INSERT INTO cje_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yàng Jêsu đờm: “Buơl guhã ka pơrpoh-c̆ơ mư̆ng pơnuaĭ pơtau Đabit hũ ngă tŭ ñu găm sơ̆ng du mơnih nau tui ñu lơpa tŭng ơu? ");
INSERT INTO cje_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ñu tơma lăm sàng Yàng Pô Lơngì, mă pah sơc̆ih-sri hũ pơyă bloh 'bơ̆ng, sơ̆ng kŭng brơi tơ du mơnih nau tui drơi 'bơ̆ng rơi, yah pah nư̆n tui pơnuaĭ adăt-adia mĭn du mơnih gơnuăr pơyă phơ̆n duh-dơlbăt nư̆n ka hũ gơnuăr 'bơ̆ng.” ");
INSERT INTO cje_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Bloh nư̆n Pô đờm sơ̆ng buơl guñu: “Anà Mơnih la Yàng hơrơi sa'bat.” ");
INSERT INTO cje_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Lăm sa hơrơi sa'bat pơkơ̆n, Yàng Jêsu tơma lăm sàng pơtòm sơ̆ng pơto-mơblàng. Tơ anih nư̆n, hũ sa aràng mơnih srĕt-mơtai plà tơngàn gah hơnuă. ");
INSERT INTO cje_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Du mơnih gơnuăr-pơto pơnuaĭ adăt-adia sơ̆ng du mơnih Pharisi kraŭ c̆ơ nĭ-nùn, c̆ơ Pô hũ pơsồ-pơsaih tơ mơnih nư̆n lăm hơrơi sa'bat ơu, tô duah pơnuaĭ yă Pô. ");
INSERT INTO cje_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Bloh Yàng Jêsu thơu pơnuaĭ lăm hơtai-akŏ buơl guñu sơnư̆ng, nư̆n đờm sơ̆ng mơnih srĕt-mơtai tơngàn lài: “Tơgồ dơ̆ng bĕ sơ̆ng truh dò dơ̆ng tơkrah anih ni.” Mơnih nư̆n tơgồ sơ̆ng truh dò dơ̆ng tơ anih nư̆n. ");
INSERT INTO cje_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Pô đờm sơ̆ng buơl guñu: “Kơu tơnia buơl guhã: Lăm hơrơi sa'bat, hũ gơnuăr ngă bruă siàm halài bruă mơsak-jơhà, păl dŏng mơnih halài pơmơtai mơnih?” ");
INSERT INTO cje_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Hơdơi tŭ c̆ơ mơta tòmdăr tơgrơ̆ mơnih, Pô đờm sơ̆ng mơnih srĕt-mơtai tơngàn: “Yơ̆r bĕ tơngàn hã tơbiă.” Mơnih nư̆n yơ̆r tơngàn tơbiă, nư̆n tơngàn hũ pơsồ-pơsaih. ");
INSERT INTO cje_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Bloh du mơnih Pharisi sơ̆ng du mơnih gơnuăr-pơto pơnuaĭ adăt-adia anok hơtai biă, buơl guñu tămbơyai sơ̆ng gơŭ c̆ơ hũ rơgơi ngă hơgĕ jiơ̆ng tơ Yàng Jêsu ơu. ");
INSERT INTO cje_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Lăm du hơrơi nư̆n, Yàng Jêsu đì tơ c̆ơ̆ tô iơu-lài, sơ̆ng Pô dò guah luĭ mơlăm tô iơu-lài sơ̆ng Yàng Pô Lơngì. ");
INSERT INTO cje_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Truh ờm hơrơi hơdơi, Pô iơu du mơnih tui-mơgru truh sơ̆ng rơwah sa-pluh dua aràng lăm buơl guñu, sơ̆ng angăn la mơnih tơdi-tơdài: ");
INSERT INTO cje_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simôn, Pô pơ-angăn la Pier, Andre la adơi phŭn Pier, Jakơ, Jăng, Philip, 'Bathelemi, ");
INSERT INTO cje_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mathiơ, Thôma, Jakơ anà Alphe, Simôn angăn la Selôt, ");
INSERT INTO cje_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Juđa anà Jakơ, sơ̆ng Juđa Iskariôt, la mơnih hơdơi pơblơ̆-dră Pô. ");
INSERT INTO cje_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yàng Jêsu sơ̆ng du mơnih tơdi-tơdài trŭn mư̆ng c̆ơ̆ sơ̆ng dò dơ̆ng tơ sa anih lơ̆n 'blàng rĭng. Hũ lô mơnih tui-mơgru Pô găm sơ̆ng tơrpuơl lô buơl làng mư̆ng abih c̆àr Juđe, plơi-prŏng Jerusalem, kŭng yơu mư̆ng du c̆àr gah ia-tơsì Tirơ sơ̆ng Siđôn, ba gơŭ truh tô păng Pô pơto-mơblàng sơ̆ng tô hũ Pô pơsồ-pơsaih lơ-ơ̆n lơngoh rơwă-sơkì. ");
INSERT INTO cje_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Tơgrơ̆ mơnih kơđòng du kơmlài sơŭ-sơnoh ngă kŭng hũ pơsồ-pơsaih abih rơi. ");
INSERT INTO cje_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Abih tơrpuơl mơnih lô duah ngă hơyơu tô hũ rơwơ̆ tŭp Pô, kơyoa mư̆ng Pô hũ gơnăp-gơnuăr tơbiă sơ̆ng pơsồ-pơsaih tơgrơ̆ mơnih. ");
INSERT INTO cje_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yàng Jêsu tơ̆ mơta c̆ơ tơgrơ̆ mơnih tui-mơgru sơ̆ng đờm: “Lơngai-pơtuah tơ buơl guhã la du mơnih siơŭ rơ'bah, Kơyoa lơgăr Yàng Pô Lơngì la găm sơ̆ng buơl guhã. ");
INSERT INTO cje_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Lơngai-pơtuah tơ buơl guhã la du mơnih tŭ ni dò ờ-lơpa, Kơyoa rơŭ hũ trơi tơ̆l. Lơngai-pơtuah tơ buơl guhã la du mơnih tŭ ni dò hia-c̆ŏ, Kơyoa rơŭ hũ klau sờh. ");
INSERT INTO cje_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Lơngai-pơtuah tơ buơl guhã tŭ kơyoa mư̆ng Anà Mơnih bloh kŏng aràng mơbai-lơmù, prơh tơluh, puaĭ jrăm, sơ̆ng luơi mơta buơl guhã yơu phơ̆n sơŭ jơhà! ");
INSERT INTO cje_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Lăm hơrơi nư̆n, buơl guhã sờh-sài kơsĕt mơya bĕ, kơyoa phơ̆n mơyòm-brơi hũ pioh lờih tơ buơl guhã tơ ngŏ lơngì la prŏng biă. Kơyoa kơi-kŏ pàng-yau buơl guñu kŭng hũ ngă tơ du mơnih gơnuăr-hwơ̆r yơu nư̆n rơi. ");
INSERT INTO cje_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Bloh gleh-glăr dồn-să biă tơ buơl guhã la du mơnih mơda gơn-hư̆p, Kơyoa buơl guhã hũ pơ-ơnah pơluơ-pơrơngài drơi bơjơ! ");
INSERT INTO cje_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Gleh-glăr dồn-să biă tơ buơl guhã la du mơnih tŭ ni trơi tơ̆l, Kơyoa buơl guhã rơŭ ờ-lơpa. Gleh-glăr dồn-să biă tơ buơl guhã la du mơnih tŭ ni klau sờh, Kơyoa rơŭ pơđì-pơđoa hia-c̆ŏ. ");
INSERT INTO cje_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Gleh-glăr dồn-să biă tơ buơl guhã, tŭ hũ tơgrơ̆ mơnih đờm mơyòm buơl guhã, Kơyoa kơi-kŏ pàng-yau buơl guñu kŭng hũ ngă sơ̆ng du mơnih gơnuăr-hwơ̆r lơ̆r yơu nư̆n rơi!” ");
INSERT INTO cje_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Bloh Kơu đờm sơ̆ng buơl guhã, la du mơnih păng Kơu: Rơnăm bĕ tơ mơnih mơbai-tămdră drơi, ngă siàm bĕ tơ mơnih mơbai-lơmù drơi, ");
INSERT INTO cje_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","lơkơu lơngai-pơtuah tơ mơnih pơc̆ĕ-pơtrah drơi, sơ̆ng iơu-lài tơ mơnih pơtăt-pơmơlơu drơi. ");
INSERT INTO cje_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Aràng sơi pah buơl guhã 'bò gah ni, nư̆n brơi bĕ găm 'bò gah dih tơ buơl guñu. Aràng sơi khiăng tămblah mă ào agàh buơl guhã, kừ brơi buơl guñu mă găm ào dơrlăm, yah buơl guñu khiăng. ");
INSERT INTO cje_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Aràng sơi yòng, brơi bĕ. Aràng sơi tămblah mă phơ̆n buơl guhã, nư̆n juơi đồ wơ̆. ");
INSERT INTO cje_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Pơnuaĭ hơgĕ buơl guhã khiăng mơnih pơkơ̆n ngă tơ drơi, nư̆n ngă bĕ pơnuaĭ nư̆n tơ buơl guñu. ");
INSERT INTO cje_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Yah buơl guhã uơ̆n-rơnăm du mơnih uơ̆n-rơnăm drơi, nư̆n hũ hơgĕ păl mơyòm ơu? Du mơnih glài-sơnoh kŭng uơ̆n-rơnăm du mơnih uơ̆n-rơnăm buơl guñu rơi. ");
INSERT INTO cje_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Yah buơl guhã siàm sơ̆ng du mơnih siàm sơ̆ng drơi, nư̆n hũ hơgĕ păl mơyòm ơu? Du mơnih glài-sơnoh kŭng ngă yơu nư̆n rơi. ");
INSERT INTO cje_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Yah buơl guhã brơi aràng sơi ơñàm bloh kraŭ-c̆àng buơl guñu bơ-yàr c̆iŭ wơ̆, nư̆n hũ hơgĕ păl mơyòm ơu? Du mơnih glài-sơnoh kŭng brơi du mơnih glài-sơnoh ơñàm, tô hũ đồ-mă wơ̆ tơ̆l khà. ");
INSERT INTO cje_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Păl rơnăm bĕ mơnih mơbai-tămdră sơ̆ng drơi, păl siàm sơ̆ng abih tơgrơ̆ mơnih, brơi ơñàm bĕ bloh juơi kraŭ-c̆àng hũ bơ-yàr c̆iŭ wơ̆. Yơu nư̆n, phơ̆n mơyòm-brơi pioh tơ buơl guhã rơŭ prŏng biă, sơ̆ng buơl guhã rơŭ la anà Pô Ngŏ Glòng Rơlau Abih, kơyoa Pô sơđaŭ ràng-tơbiă hơtai-hơtiàn siàm sơ̆ng găm du mơnih 'buh thơu ưnjơmừn kŭng yơu du mơnih mơsak-jơhà. ");
INSERT INTO cje_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Buơl guhã păl hũ bĕ hơtai-hơtiàn anĭt-rơnăm, yơu Ama buơl guhã la Pô jiăng anĭt-rơnăm.” ");
INSERT INTO cje_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Juơi c̆ahrơña aràng sơi, tô buơl guhã rơŭ 'buh kơđòng c̆ahrơña. Juơi yă glài aràng sơi, tô buơl guhã rơŭ 'buh kơđòng yă glài. Anĭt toh-luơi bĕ tơ mơnih pơkơ̆n, tô buơl guhã rơŭ hũ anĭt toh-luơi. ");
INSERT INTO cje_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Brơi bĕ, nư̆n buơl guhã rơŭ hũ aràng brơi wơ̆. Aràng rơŭ mă thŭng prŏng wăl baŭ, kơtơ̆ trŭn, sơkruh tơ̆l truh tơ tŭ baŭ jrài, bloh nư̆n tuh lăm pha buơl guhã. Kơyoa buơl guhã wăl tơ aràng kàr lơi, nư̆n aràng kŭng rơŭ wăl wơ̆ tơ buơl guhã kàr nư̆n rơi.” ");
INSERT INTO cje_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Pô kŭng đờm sơ̆ng buơl guñu sa pơnuaĭ pơgăp-pơmơyơu: “Mơnih bồm hũ rơgơi dùi mơnih bồm jiơ̆ng rơi? Dua aràng 'buh iơŭ rơŭ lĕ abih lăm lơbàng ơu? ");
INSERT INTO cje_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Mơnih tui-mơgru 'buh rơlau pô-pơto, bloh yah mơnih tui-mơgru hũ mơgru-pơsrăm wĭl-tơ̆l, nư̆n rơŭ mơhiơ̆ yơu pô-pơto drơi. ");
INSERT INTO cje_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Hơyơu hã c̆ơ 'buh thŭl lăm mơta adơi-ai drơi, bloh 'bu 'buh kơyơu gih lăm mơta drơi? ");
INSERT INTO cje_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Hơyơu hã hũ rơgơi đờm sơ̆ng adơi-ai hã lài: ‘Ơ sơ-ai, luơi dơlhă mă thŭl lăm mơta sơ-ai tơbiă,’ lăm tŭ hã 'bu 'buh jiơ̆ng kơyơu gih lăm mơta drơi? Ơ mơnih hơtai-hơtiàn mơthĭ-lơ̆r! Mă bĕ kơyơu gih tơbiă klàh mư̆ng mơta drơi dơlhơu ka, bloh nư̆n ka hã hũ 'buh loh-làng tô mă thŭl lăm mơta adơi-ai hã jiơ̆ng. ");
INSERT INTO cje_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Kơyơu tơbiă boh jơhà 'buh iơŭ la kơyơu siàm, kơyơu tơbiă boh siàm 'buh iơŭ la kơyơu jơhà. ");
INSERT INTO cje_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kơyoa c̆ơ boh nư̆n thơu kơyơu. 'Buh aràng sơi pĕ boh hra lăm anih puk druơi, halài pĕ boh ño lăm anih puk druơi kòng-lai. ");
INSERT INTO cje_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Mơnih siàm kơyoa hơtai-hơtiàn tơrgùm-pioh pơnuaĭ siàm bloh pơtơbiă pơnuaĭ siàm. Mơnih jơhà kơyoa hơtai-hơtiàn tơrgùm-pioh pơnuaĭ mơsak-jơhà bloh pơtơbiă pơnuaĭ mơsak-jơhà. Kơyoa baŭ-bèng lăm hơtai-hơtiàn bloh kàng đờm tơbiă.” ");
INSERT INTO cje_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Kơđa hơgĕ buơl guhã iơu Kơu: ‘Khoai Yàng! Khoai Yàng!’ bloh 'buh ngă tui pơnuaĭ Kơu pơto? ");
INSERT INTO cje_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Kơu rơŭ pơto tơ buơl guhã 'buh mơnih truh sơ̆ng Kơu, păng pơnuaĭ Kơu pơto, sơ̆ng ngă tui nư̆n rơŭ mơhiơ̆ yơu aràng sơi. ");
INSERT INTO cje_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Mơnih nư̆n rơŭ mơhiơ̆ yơu sa aràng mơnih dih bơ̆-ngă sàng, klơi lơ̆n trŭn dơrlăm biă, sơ̆ng bơ̆ rơnơ̆ tơ ngŏ sa boh pơtơu prŏng. Tŭ ia rơlèng đì glòng, ia đuaĭ khăng jroh tơma lăm sàng nư̆n, kŭng 'buh mơgơi lơ̆ng-gơh jiơ̆ng, kơyoa sàng hũ bơ̆-ngă kơjăp biă. ");
INSERT INTO cje_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Dò mơnih lơi păng pơnuaĭ Kơu bloh 'buh ngă tui, nư̆n mơhiơ̆ yơu sa aràng mơnih bơ̆ pơdơ̆ng sàng tơ ngŏ lơ̆n bloh 'buh bơ̆-ngă rơnơ̆. Tŭ ia đuaĭ khăng jroh tơma, sàng nư̆n rơŭ jơrlơh-tơrlơ̆m mư, sơ̆ng jơrlơh-tơrlơ̆m prŏng traŭ biă.” ");
INSERT INTO cje_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Hơdơi tŭ đờm pơto-mơblàng tơgrơ̆ pơnuaĭ nư̆n tơ buơl làng păng bơjơ, Yàng Jêsu tơma lăm plơi-prŏng Kapenaum. ");
INSERT INTO cje_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Sa aràng mơnih apăn-akŏ sa rơtùh lĭng dih hũ mơnih hơlŭn-hơlă bloh ñu rơnăm biă, lơ-ơ̆n traŭ kơjĕ mơtai. ");
INSERT INTO cje_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Tŭ mơhư̆ đờm mư̆ng Yàng Jêsu, ñu pơđăr du mơnih gơnuăr-tha lăm buơl làng Juđa truh tòm Pô, tô yòng jà Pô truh pơsồ-pơsaih tơ mơnih hơlŭn-hơlă drơi. ");
INSERT INTO cje_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Du mơnih nư̆n truh sơ̆ng Yàng Jêsu, bloh lơkơu-yòng lài: “Mơnih apăn-akŏ sa rơtùh lĭng ni iơŭ păl biă tô Pô-Pơto dŏng-kờl, ");
INSERT INTO cje_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","kơyoa ñu rơnăm tơ buơl làng drơi, sơ̆ng kŭng hũ bơ̆-ngă sàng pơtòm tơ buơl gudrơi wơ̆.” ");
INSERT INTO cje_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yơu nư̆n, Yàng Jêsu nau sơ̆ng buơl guñu. Tŭ Pô kơjĕ truh sàng, mơnih apăn-akŏ sa rơtùh lĭng pơđăr du mơnih adơi-ai gơŭ drơi tơbiă rò Pô sơ̆ng đờm: “Khoai Yàng, 'buh khĭn ngă pơ-uă pơgleh Pô yơu nư̆n ơu, kơyoa dơlhă 'buh iơŭ păl tô wă-rò Pô tơma lăm sàng dơlhă. ");
INSERT INTO cje_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Dơlhă kŭng sơnư̆ng drơi 'buh iơŭ păl tô truh sơ̆ng Yàng. Mĭn yòng Pô đờm sa pơnuaĭ soh, nư̆n mơnih hơlŭn-hơlă dơlhă rơŭ hũ pơsồ-pơsaih. ");
INSERT INTO cje_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Kơyoa rùp-phŭn dơlhă kŭng dò tơ ala gơnuăr mơnih pơkơ̆n, bloh dơlhă kŭng hũ du lĭng-klàng dò tơ ala gơnuăr dơlhă. Dơlhă pơđăr mơnih ni: ‘Nau!’ nư̆n ñu nau. Dơlhă pơđăr mơnih dih: ‘Truh!’ nư̆n ñu truh. Sơ̆ng dơlhă pơđăr mơnih hơlŭn-hơlă dơlhă: ‘Ngă bĕ bruă ni!’ nư̆n ñu ngă.” ");
INSERT INTO cje_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Mơhư̆ du pơnuaĭ nư̆n, Yàng Jêsu mă ngă krơi-takơtuă biă mư̆ng mơnih apăn-akŏ sa rơtùh lĭng, Pô gài pơtrah wơ̆ đờm sơ̆ng tơrpuơl buơl làng nau tui Pô lài: “Kơu đờm sơ̆ng buơl guhã, yah lăm buơl làng Israel, Kơu kŭng ka 'buh sa pơnuaĭ păng-tui prŏng yơu nư̆n.” ");
INSERT INTO cje_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Tŭ du mơnih hũ pơđăr nau tòm Yàng Jêsu mơrai wơ̆ truh tơ sàng, buơl guñu 'buh mơnih hơlŭn-hơlă hũ pơsồ-pơsaih bơjơ. ");
INSERT INTO cje_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Hơrơi hơdơi, Yàng Jêsu nau truh tơ sa plơi-prŏng angăn la Nain, hũ lô mơnih tui-mơgru găm sơ̆ng sa tơrpuơl lô buơl làng nau sơ̆ng Pô. ");
INSERT INTO cje_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Tŭ Pô truh jĕ bơh 'băng plơi-prŏng, nư̆n păp aràng sơkồng sa aràng mơnih mơtai apăn nau dơ̆r; mơnih mơtai nư̆n la anà lơkơi sa, ame ñu la sa aràng kơmơi bơdrau. Hũ lô mơnih lăm plơi-prŏng nau pơrlau atơu găm sơ̆ng kơmơi bơdrau nư̆n. ");
INSERT INTO cje_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Tŭ Yàng 'buh mơnih kơmơi bơdrau, Pô hũ hơtai-hơtiàn anĭt-rơnăm, nư̆n đờm: “Juơi hia tra!” ");
INSERT INTO cje_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Bloh nư̆n Pô truh jĕ, mă tơngàn rơwơ̆ tơ bòng atơu, sơ̆ng du mơnih sơkồng atơu dò dơ̆ng wơ̆. Pô đờm: “Ơ mơnih lơkơi dăm, Kơu pơđăr hã tơgồ!” ");
INSERT INTO cje_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Mơnih mơtai tơgồ dò guh mư sơ̆ng tơma đờm glai. Yàng Jêsu jào mơnih lơkơi dăm nư̆n tơ ame ñu. ");
INSERT INTO cje_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Abih tơgrơ̆ mơnih mă ngă huơĭ-kơđa biă, sơ̆ng mơyòm-pơglòng Yàng Pô Lơngì lài: “Hũ mơnih gơnuăr-hwơ̆r prŏng tơbiă truh tơkrah buơl gudrơi, sơ̆ng Yàng Pô Lơngì hũ c̆uă-rơwăng buơl làng Pô.” ");
INSERT INTO cje_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Pơnuaĭ ni hũ ba pơtiơ̆ng lăm abih c̆àr Juđe, sơ̆ng du c̆àr tòmdăr. ");
INSERT INTO cje_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Du mơnih tui-mơgru Jăng đờm akhàn wơ̆ tơ Jăng thơu mư̆ng abih tơgrơ̆ bruă nư̆n. ");
INSERT INTO cje_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Jăng iơu dua aràng mơnih tui-mơgru drơi, sơ̆ng pơđăr buơl guñu truh đờm sơ̆ng Yàng: “Pô-Pơto hũ iơŭ la Pô păl truh, halài buơl dơlhă păl c̆àng Pô pơkơ̆n?” ");
INSERT INTO cje_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Buơl guñu truh tòm Yàng Jêsu, sơ̆ng đờm: “Jăng 'Baptis pơđăr buơl dơlhă truh tơnia Pô-Pơto: ‘Pô-Pơto hũ iơŭ la Pô păl truh, halài buơl dơlhă păl c̆àng Pô pơkơ̆n?’ ” ");
INSERT INTO cje_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Lăm tŭ nư̆n, Yàng Jêsu pơrpa pơsồ-pơsaih tơ lô mơnih lơ-ơ̆n lơngoh, rơwă-sơkì, sơ̆ng kơđòng kơmlài ngă. Pô kŭng pơsồ-pơsaih tơ lô mơnih bồm hũ c̆ơ 'buh. ");
INSERT INTO cje_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Pô đờm sơđồ sơ̆ng buơl guñu: “Nau wơ̆ đờm akhàn bĕ tơ Jăng mư̆ng abih tơgrơ̆ pơnuaĭ buơl guhã hũ 'buh sơ̆ng mơhư̆: Mơnih bồm hũ 'buh, mơnih joh-je hũ nau, mơnih dŭn hũ goh, mơnih tĭ hũ mơhư̆, mơnih mơtai hũ hơdiŭ wơ̆, sơ̆ng mơnih rơ'bah rơ'bừp hũ păng Pơnuaĭ-Siàm. ");
INSERT INTO cje_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Lơngai-pơtuah tơ mơnih lơi 'buh sơnĕ lơbuh lăm glài sŭng kơyoa mư̆ng Kơu!” ");
INSERT INTO cje_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Tŭ du mơnih hũ Jăng pơđăr mơrai truh tơnia tơbiă nau wơ̆ bơjơ, Yàng Jêsu tơma đờm sơ̆ng buơl làng mư̆ng Jăng lài: “Buơl guhã nau c̆ơ hơgĕ lăm anih 'blàng-jơhua? C̆ơ sa 'bĕ phŭn bơrbo kơđòng rơbù pơrpuh mơgơi? ");
INSERT INTO cje_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Buơl guhã tơbiă nau c̆ơ hơgĕ wơ̆? C̆ơ sa aràng mơnih c̆ù khăn kơbuă ào mơkrư? Dih, du mơnih c̆ù khăn-ào c̆ơk-màng, sơ̆ng hơdiŭ 'bơ̆ng lơngai dò soh nư̆n dò lăm du glăng pơtau! ");
INSERT INTO cje_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Yơu nư̆n, buơl guhã nau c̆ơ hơgĕ? C̆ơ sa aràng mơnih gơnuăr-hwơ̆r? Biă, Kơu đờm sơ̆ng buơl guhã: ni dò prŏng-màng rơlau tơ mơnih gơnuăr-hwơ̆r wơ̆! ");
INSERT INTO cje_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Nư̆n la mư̆ng rùp-phŭn mơnih nư̆n bloh hũ pơnuaĭ wă lài: ‘Ni, Kơu pơđăr mơnih Kơu nau dơlhơu tơ anaŭ Anà, Mơnih nư̆n rơŭ waìh rơc̆ăng jơlàn dơlhơu tơ Anà.’ ");
INSERT INTO cje_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Kơu đờm sơ̆ng buơl guhã, lăm du mơnih kơyoa mư̆ng mơnih kơmơi đih apui tơbiă, 'buh hũ aràng sơi prŏng-màng rơlau tơ Jăng 'Baptis ơu; bloh mơnih tìt rơlau abih lăm lơgăr Yàng Pô Lơngì dò prŏng-màng rơlau tơ Jăng wơ̆.” ");
INSERT INTO cje_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Abih buơl làng găm sơ̆ng tơgrơ̆ mơnih rì-mă jia, la du mơnih hũ đồ-mă pơnuaĭ 'baptem Jăng, mơhư̆ Pô đờm pơto nư̆n kràn-thơu Yàng Pô Lơngì la rĭng-tơpă. ");
INSERT INTO cje_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Bloh du mơnih Pharisi sơ̆ng du mơnih gơnuăr-pơto pơnuaĭ adăt-adia nư̆n kơmlah-luơi hơtai-khiăng Yàng Pô Lơngì hũ ngă-nìn pioh tơ buơl guñu, nư̆n buơl guñu 'buh truh yòng Jăng ngă 'baptem tơ buơl guñu. ");
INSERT INTO cje_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","“Kơyoa nư̆n, Kơu rơŭ pơc̆àu-pơgăp du mơnih lăm jơi-rài ni sơ̆ng hơgĕ? Buơl guñu mơhiơ̆ yơu aràng sơi? ");
INSERT INTO cje_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Buơl guñu mơhiơ̆ yơu lơ-ơneh tìt dò guh lăm anih drà, driau iơu gơŭ sơ̆ng đờm: Buơl dơlhă ơyù tơliă, bloh buơl adơi-ai gơŭ 'buh tăm-ya; buơl dơlhă adoh kơtha-pơđik dơnuh-dơnà, bloh buơl adơi-ai gơŭ 'buh hia-c̆ŏ. ");
INSERT INTO cje_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Kơyoa Jăng 'Baptis hũ truh, 'buh 'bơ̆ng pah, 'buh mơñŭm tơpai, nư̆n buơl guhã đờm: ‘Ñu kơđòng kơmlài ngă.’ ");
INSERT INTO cje_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Anà Mơnih truh, 'bơ̆ng sơ̆ng mơñŭm, nư̆n buơl guhã đờm: ‘Dih, nư̆n la mơnih hrạ 'bơ̆ng hrạ mơñŭm, ngă gô sơ̆ng du mơnih rì-mă jia sơ̆ng mơnih hũ glài-sơnoh.’ ");
INSERT INTO cje_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Bloh pơnuaĭ jak-khờh hũ kràn thơu gơnừm tơ bơnga boh ñu.” ");
INSERT INTO cje_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Sa aràng mơnih Pharisi jà Yàng Jêsu truh sàng huă 'bơ̆ng sơ̆ng drơi. Pô tơma lăm sàng mơnih Pharisi nư̆n sơ̆ng dò guh tơ anih c̆ơnừng huă 'bơ̆ng. ");
INSERT INTO cje_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Tŭ nư̆n, hũ sa aràng mơnih kơmơi lăm plơi-prŏng nư̆n, hũ tiơ̆ng dơnài la mơnih glài-sơnoh; tŭ mơhư̆ thơu Pô truh huă 'bơ̆ng lăm sàng mơnih Pharisi, nư̆n apăn truh sa klŏ mơñà 'bơu bơlhơu, mơñà nư̆n hũ daŭ lăm sa boh klŏ ngă sơ̆ng pơtơu màng. ");
INSERT INTO cje_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ñu dò dơ̆ng gah rŏng, anih tơkai Yàng Jêsu bloh hia, ia mơta ñu hŏ pơsah tơkai Pô. Ñu mă 'bù drơi uă, bloh nư̆n c̆ŭm tơkai Pô sơ̆ng lŭ mơñà 'bơu bơlhơu lăm tơkai Pô. ");
INSERT INTO cje_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Mơnih Pharisi hũ jà Pô huă 'bơ̆ng, 'buh yơu nư̆n, sơnư̆ng lăm hơtai-hơtiàn: “Yah mơnih ni biă la mơnih gơnuăr-hwơ̆r, nư̆n rơŭ thơu mơnih kơmơi tŭp truh drơi ni la aràng sơi, sơ̆ng la mơnih hơyơu lơi, kơyoa kơmơi nư̆n la mơnih glài-sơnoh.” ");
INSERT INTO cje_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yàng Jêsu đờm sơ̆ng ñu: “Ơ Simôn, kơu hũ sa-sĭt pơnuaĭ đờm sơ̆ng hã.” Ñu đờm: “Ơ Pô-Pơto, yòng Pô-Pơto kừ đờm.” ");
INSERT INTO cje_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yàng Jêsu đờm: “Sa aràng mơnih pô sre dih, hũ dua aràng mơnih kơđòng sre: Sa aràng mơnih sre lơma rơtùh đơnie, sa aràng mơnih sre lơma pluh. ");
INSERT INTO cje_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Kơyoa abih dua aràng 'buh hũ hơgĕ tô c̆iŭ sre, nư̆n mơnih pô sre anĭt luơi abih tơ dua aràng. Yơu nư̆n, aràng sơi lăm dua aràng mơnih nư̆n rơnăm tơ mơnih pô sre rơlau?” ");
INSERT INTO cje_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simôn đờm: “Dơlhă sơnư̆ng la mơnih bloh pô sre hũ anĭt luơi lô sre rơlau!” Yàng Jêsu đờm: “Hã đờm iơŭ biă.” ");
INSERT INTO cje_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Pô pơtrah tơ gah mơnih kơmơi bloh đờm sơ̆ng Simôn: “Hã 'buh mơnih kơmơi ni ơu? Kơu tơma lăm sàng hã, hã 'buh brơi Kơu ia tô rào tơkai; bloh mơnih kơmơi ni hũ mă ia mơta rào tơkai Kơu, sơ̆ng mă 'bù ñu bloh uă. ");
INSERT INTO cje_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Hã 'buh c̆ŭm Kơu, bloh mư̆ng tŭ Kơu tơma lăm sàng hã, mơnih kơmơi ni c̆ŭm tơkai Kơu 'buh bơdơh. ");
INSERT INTO cje_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Hã 'buh lŭ mơñà tơ akŏ Kơu, bloh mơnih kơmơi ni mă mơñà 'bơu bơlhơu lŭ tơkai Kơu. ");
INSERT INTO cje_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kơyoa nư̆n, Kơu đờm sơ̆ng hã, glài-sơnoh mơnih kơmơi ni lô biă, bloh hũ anĭt toh-luơi abih, nư̆n ñu rơnăm lô. Dò mơnih hũ anĭt toh-luơi tơkì, nư̆n rơnăm tơkì.” ");
INSERT INTO cje_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Bloh nư̆n Pô đờm sơ̆ng mơnih kơmơi: “Glài-sơnoh hã hũ anĭt toh-luơi bơjơ.” ");
INSERT INTO cje_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Du mơnih dò guh lăm c̆ơnừng huă 'bơ̆ng găm sơ̆ng Pô đờm: “Mơnih ni la aràng sơi bloh hũ gơnuăr toh-luơi glài-sơnoh?” ");
INSERT INTO cje_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Bloh Pô đờm sơ̆ng mơnih kơmơi lài: “Pơnuaĭ păng-tui anà hũ dŏng-pơklàh anà. Nau bĕ lơngai-lơngò.” ");
INSERT INTO cje_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Hơdơi mư̆ng nư̆n, Yàng Jêsu nau mư̆ng plơi-prŏng ni truh plơi-prŏng dih, mư̆ng plơi ni truh plơi dih, pơto-mơblàng sơ̆ng pơto-akhàn Pơnuaĭ-Siàm lơgăr Yàng Pô Lơngì. Sa pluh dua aràng mơnih tơdi-tơdài nau găm sơ̆ng Pô. ");
INSERT INTO cje_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Kŭng hũ du mơnih kơmơi nau tui Pô, la du mơnih hũ pơsồ-pơsaih klàh mư̆ng du kơmlài mơsak-jơhà sơ̆ng pơnuaĭ lơ-ơ̆n lơngoh rơwă-sơkì. Lăm du mơnih kơmơi nư̆n hũ Mari, angăn la Mađơlen, la mơnih hũ Yàng pơtrơh tơjuh drơi kơmlài mơsak-jơhà tơbiă klàh, ");
INSERT INTO cje_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Jana sơdiŭ C̆usa, la mơnih c̆ơ apăn-akŏ bruă sàng pơtau Herôt, Susan sơ̆ng lô mơnih kơmơi pơkơ̆n wơ̆. Du mơnih nư̆n hũ mă phơ̆n-bơna drơi bloh dŏng-kờl Yàng Jêsu sơ̆ng du mơnih tui-mơgru Pô. ");
INSERT INTO cje_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Tŭ hũ sa tơrpuơl lô buơl làng mư̆ng du plơi-prŏng truh pơtòm-pơgùm gơŭ tòmdăr Yàng Jêsu. Pô angui pơnuaĭ pơgăp-pơmơyơu đờm sơ̆ng buơl guñu: ");
INSERT INTO cje_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Hũ sa aràng mơnih tơbiă nau drà găr-pơjeh. Tŭ drà, sa-sĭt găr lĕ rò gah jơlàn, kơđòng aràng juă, sơ̆ng c̆ĭm lơngì 'bơ̆ng abih. ");
INSERT INTO cje_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Sa-sĭt găr pơkơ̆n lĕ iơŭ lăm anih lơ̆n pơtơu-rơđeh, tŭ pơrpa tơmuh tơgồ, nư̆n lơdiơu thu mư, kơyoa 'buh tơ̆l ia lơ-ơ̆. ");
INSERT INTO cje_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Du găr pơkơ̆n lĕ iơŭ tơkrah puk druơi, druơi tơmuh tơgồ găm sơ̆ng găr-pơjeh, ngă tơ ñu mơtai bơlhăt. ");
INSERT INTO cje_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Du găr pơkơ̆n wơ̆ lĕ iơŭ lăm lơ̆n siàm, tŭ tơmuh tơgồ, tơbiă bơnga boh rơlau rơtùh amăng wơ̆.” Tŭ dò đờm du pơnuaĭ nư̆n, Pô đờm prŏng: “Aràng sơi hũ tơnia păng, nư̆n păng-mơhư̆ bĕ!” ");
INSERT INTO cje_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Hơdơi mư̆ng nư̆n, du mơnih tui-mơgru Pô tơnia Pô pơnuaĭ pơgăp-pơmơyơu nư̆n hũ kơtha-mơblàng la hơgĕ. ");
INSERT INTO cje_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Pô đờm: “Sơ̆ng buơl guhã nư̆n hũ pơnuaĭ anĭt brơi wờng-thơu du pơnuaĭ tơrđơŭ-dơrlăm lơgăr Yàng Pô Lơngì, bloh sơ̆ng tơgrơ̆ mơnih pơkơ̆n, nư̆n sơđaŭ păl angui pơnuaĭ pơgăp-pơmơyơu, tô buơl guñu c̆ơ bloh 'bu 'buh, păng bloh 'buh wờng. ");
INSERT INTO cje_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Pơnuaĭ pơgăp-pơmơyơu nư̆n hũ kơtha-mơblàng yơu ni: Găr-pơjeh, nư̆n la Pơnuaĭ Yàng Pô Lơngì. ");
INSERT INTO cje_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Du găr lĕ rò gah jơlàn, la du mơnih hũ păng Pơnuaĭ Yàng, bloh hơdơi nư̆n kơmlài-jĭnràk truh, tămblah-mă Pơnuaĭ nư̆n klàh mư̆ng hơtai-hơtiàn buơl guñu, huơĭ lài buơl guñu păng-tui bloh hũ dŏng-pơklàh ơu. ");
INSERT INTO cje_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Du găr lĕ iơŭ lăm anih lơ̆n pơtơu-rơđeh, la du mơnih tŭ păng Pơnuaĭ nư̆n sờh-sài đồ-mă mư; bloh kơyoa 'buh hũ akha, mĭn păng-tui sơdăng soh, truh tŭ păp pơnuaĭ pơlòng-ơñiai, nư̆n buơl guñu sơnĕ lơbuh mư. ");
INSERT INTO cje_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Du găr lĕ iơŭ tơkrah puk druơi, la du mơnih hũ păng Pơnuaĭ Pô, bloh buơl guñu luơi du pơnuaĭ sơnư̆ng kơ-ù, pơnuaĭ mơda gơn-hư̆p, sơ̆ng pơnuaĭ sờh-sờr rài ni ngă tơ gơrềt-bơlhăt, nư̆n 'buh prŏng jiơ̆ng, 'buh tơbiă boh lơi hũ să. ");
INSERT INTO cje_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Bloh du găr lĕ iơŭ lăm anih lơ̆n siàm, la du mơnih păng Pơnuaĭ sơ̆ng hơtai-hơtiàn tơpă-siàm, bloh nư̆n kừ kơjăp hơtai-hơtiàn păng-rơmiă bloh tơbiă bơnga boh. ");
INSERT INTO cje_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","'Buh aràng sơi tuĭ apui đèng bloh nư̆n mă thŭng druă wơ̆, halài apăn daŭ tơ ala jờng c̆ơnừng, bloh păl daŭ ñu tơ ngŏ tơkai đèng, tô aràng sơi tơma lăm sàng kŭng 'buh pơnuaĭ sơrdah soh. ");
INSERT INTO cje_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Kơyoa 'buh hũ pơnuaĭ hơgĕ bơdơŭ-tơrđơŭ bloh rơŭ 'buh kŏng ràng-tơbiă; 'buh hũ pơnuaĭ hơgĕ ac̆ĭng-bơdơŭ bloh rơŭ 'buh thơu truh sơ̆ng 'buh kŏng ba pơtơbiă tơ pơnuaĭ sơrdah. ");
INSERT INTO cje_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Yơu nư̆n, păl nĭ-nùn bĕ mư̆ng pơnuaĭ buơl guhã păng. Kơyoa aràng sơi hũ, rơŭ hũ brơi pơtơ̆l wơ̆; dò aràng sơi 'buh hũ, nư̆n găm pơnuaĭ hơgĕ buơl guñu sơnư̆ng la buơl guñu hũ, kŭng rơŭ kŏng mă thĭt rơi.” ");
INSERT INTO cje_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ame sơ̆ng adơi-ai Yàng Jêsu truh duah Pô, bloh kơyoa mơnih lô biă, nư̆n 'buh rơgơi truh jĕ Pô jiơ̆ng. ");
INSERT INTO cje_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Hũ mơnih akhàn tơ Pô thơu: “Ơ Pô-Pơto, hũ Ame sơ̆ng adơi-ai Pô-Pơto dò tơ agàh, khiăng tòm Pô-Pơto.” ");
INSERT INTO cje_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Bloh Pô đờm: “Ame Kơu sơ̆ng adơi-ai Kơu la du mơnih păng pơnuaĭ Yàng Pô Lơngì sơ̆ng ngă tui.” ");
INSERT INTO cje_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Sa hơrơi dih, Yàng Jêsu sơ̆ng du mơnih tui-mơgru Pô trŭn gơlài. Pô đờm sơ̆ng buơl guñu: “Buơl gudrơi nau bĕ truh tơ gah dih dơnau prŏng.” Yơu nư̆n, buơl guñu wah gơlài nau. ");
INSERT INTO cje_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Lăm tŭ gơlài dò nau, nư̆n Pô đih. Hũ sa pơnuaĭ rơbù angĭn prŏng tơgồ tơbiă lăm dơnau, ia tơma baŭ lăm gơlài, sơ̆ng buơl guñu păp pơnuaĭ mơtai-lơhiă biă. ");
INSERT INTO cje_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Du mơnih tui-mơgru truh blơ̆ Pô tơgồ sơ̆ng đờm: “Ơ Pô-Pơto! Ơ Pô-Pơto! Buơl gudrơi kơjĕ mơtai-lơhiă bơjơ!” Pô tơgồ, đờm puaĭ tơ rơbù sơ̆ng rơyà ia, nư̆n rơbù angĭn sơ̆ng rơyà ia kơđơ̆ng-rik mư. ");
INSERT INTO cje_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Pô đờm sơ̆ng du mơnih tui-mơgru: “Pơnuaĭ păng-tui buơl guhã anih lơi?” Du mơnih tui-mơgru huơĭ-kơđa sơ̆ng mă ngă krơi-takơtuă biă, đờm tơnia gơŭ: “Pô la aràng sơi bloh tŭ đờm pơđăr rơbù angĭn sơ̆ng ia, nư̆n guñu kŭng păl păng-bơbah Pô rơi?” ");
INSERT INTO cje_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yàng Jêsu sơ̆ng du mơnih tui-mơgru Pô truh tơ c̆àr Jerase, nư̆n la c̆àr găn tơ anaŭ gah dih c̆àr Galile. ");
INSERT INTO cje_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Tŭ Yàng Jêsu đì tơ ngŏ lơ̆n gah ia, nư̆n hũ sa aràng mơnih lăm plơi-prŏng nư̆n kơđòng kơmlài ngă, tơbiă truh tòm Pô. Suơi ni bơjơ mơnih nư̆n 'buh c̆ù khăn-ào, kŭng 'buh dò lăm sàng, bloh dò lăm anih kŭt atơu. ");
INSERT INTO cje_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Tŭ 'buh Yàng Jêsu, ñu driau iơu, pơđih rùp drơi tơ anaŭ Pô, sơ̆ng đờm prŏng: “Khoai Yàng Jêsu, Anà Yàng Pô Lơngì Ngŏ Glòng Rơlau Abih, dơlhă sơ̆ng Pô hũ pơnuaĭ hơgĕ rơi? Dơlhă yòng-lơkơu Pô juơi ngă gleh-glăr dơlhă.” ");
INSERT INTO cje_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Nư̆n la kơyoa Yàng Jêsu hũ pơđăr kơmlài sơŭ-sơnoh păl tơbiă klàh mư̆ng mơnih nư̆n. Biă yơu nư̆n, lô amăng bơjơ kơmlài tơma ngă ñu, sơ̆ng yah aràng hũ angui tơlơi srĕng, anuh tô mă-pơkơŭ sơ̆ng kraŭ-gàr, bloh ñu kŭng sơđaŭ pruĭ kloh tơlơi akă sơ̆ng ngă joh abih anuh, bloh nư̆n tui kơmlài ba pơđăr bloh tơma hơdiŭ lăm du anih 'blàng jơhua. ");
INSERT INTO cje_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yàng Jêsu tơnia: “Hã angăn mơta hơgĕ?” Ñu đờm: “Tơrpuơl lĭng.” Kơyoa lô kơmlài biă tơma lăm ñu. ");
INSERT INTO cje_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Du kơmlài yòng lơkơu Pô juơi prơh pơđăr guñu păl trŭn lăm drŏng dơrlăm 'buh luĭ. ");
INSERT INTO cje_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Tŭ nư̆n, hũ sa kơtàr bơbui lô biă dò 'bơ̆ng tơ rơnòng c̆ơ̆. Du kơmlài yòng Yàng Jêsu brơi guñu tơma lăm kơtàr bơbui nư̆n, sơ̆ng Pô brơi gơnuăr. ");
INSERT INTO cje_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Yơu nư̆n, du kơmlài tơbiă klàh mư̆ng mơnih nư̆n sơ̆ng tơma lăm kơtàr bơbui. Kơtàr bơbui mư̆ng rơnòng c̆ơ̆ đuaĭ kơsĕt trŭn lăm dơnau prŏng, sơ̆ng mơtai krăm abih lăm ia. ");
INSERT INTO cje_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Du mơnih glăng bơbui 'buh yơu nư̆n, ba gơŭ đuaĭ dơŭ; buơl guñu tơma lăm plơi-prŏng sơ̆ng lăm du plơi bloh đờm akhàn wơ̆ mư̆ng abih tơgrơ̆ bruă. ");
INSERT INTO cje_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Buơl làng ba gơŭ tơbiă nau c̆ơ bruă pơrpa hũ tơbiă truh. Tŭ buơl guñu truh sơ̆ng Yàng Jêsu, sơ̆ng 'buh mơnih bloh du kơmlài pơrpa tơbiă klàh dò guh tơ anih tơkai Yàng Jêsu, c̆ù khăn-ào, akŏ gơlo saih bơhiàn, nư̆n huơĭ-kơđa biă. ");
INSERT INTO cje_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Du mơnih tơ mơta hũ 'buh tơgrơ̆ bruă nư̆n, đờm akhàn wơ̆ tơ buơl guñu păng mư̆ng pơnuaĭ mơnih kơđòng kơmlài ngă hũ pơsồ-pơsaih hơyơu lơi. ");
INSERT INTO cje_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Abih buơl làng tòmdăr c̆àr Jerase yòng Yàng Jêsu tơbiă klàh mư̆ng c̆àr buơl guñu, kơyoa buơl guñu huơĭ-kơđa biă. Yơu nư̆n, Pô trŭn gơlài sơ̆ng gài mơrai wơ̆. ");
INSERT INTO cje_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Mơnih hũ Yàng Jêsu pơtrơh du kơmlài tơbiă, yòng lơkơu Pô brơi ñu nau tui Pô, bloh Pô pơđăr ñu nau wơ̆, sơ̆ng đờm: ");
INSERT INTO cje_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Nau wơ̆ bĕ tơ sàng hã, đờm akhàn wơ̆ abih tơgrơ̆ bruă prŏng bloh Yàng Pô Lơngì hũ ngă tơ hã.” Mơnih nư̆n gài mơrai wơ̆, nau abih tơgrơ̆ anih lăm plơi-prŏng, đờm akhàn wơ̆ tơ abih tơgrơ̆ mơnih thơu mư̆ng du bruă Yàng Jêsu hũ ngă tơ drơi. ");
INSERT INTO cje_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Tŭ Yàng Jêsu gài mơrai wơ̆, hũ sa tơrpuơl lô buơl làng tơbiă nau rò Pô, kơyoa aràng sơi aràng nư̆n kŭng kraŭ-c̆àng Pô. ");
INSERT INTO cje_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Hũ sa aràng mơnih c̆ơ-apăn sàng pơtòm angăn la Jeru, truh pơđih rùp tơ tơkai Yàng Jêsu sơ̆ng yòng lơkơu Pô tơma lăm sàng drơi; ");
INSERT INTO cje_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","kơyoa ñu hũ mĭn sa aràng anà kơmơi mư, pơgăp sa-pluh dua thŭn, tŭ nư̆n lơ-ơ̆n traŭ kơjĕ mơtai. Tŭ Yàng Jêsu nau, tơrpuơl mơnih lô kŭng nau tui; buơl guñu sŭl-pơjeh gơŭ tòmdăr Pô. ");
INSERT INTO cje_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Tŭ nư̆n, hũ sa aràng mơnih kơmơi kơđòng lơ-ơ̆n tuh drah sa-pluh dua thŭn bơjơ, sơ̆ng yah hũ kŏng lơhiă abih phơ̆n-priă tơ lô mơnih gơnuăr jrào, bloh 'buh aràng sơi hũ rơgơi rak-pơsồ tơ ñu jiơ̆ng. ");
INSERT INTO cje_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ñu truh mư̆ng gah rŏng Yàng Jêsu sơ̆ng rơwơ̆ tơ aku ào Pô. Lăm tơk tŭ nư̆n mư, drah 'buh tuh tra. ");
INSERT INTO cje_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yàng Jêsu tơnia: “Aràng sơi tŭp truh Kơu?” Abih tơgrơ̆ mơnih đờm kơmlah. Nư̆n Pier đờm: “Ơ Pô-Pơto, tơrpuơl buơl làng sŭl-pơjeh gơŭ tòmdăr Pô-Pơto sơ̆ng asŭ tŭp gò Pô-Pơto nư̆n.” ");
INSERT INTO cje_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Bloh Yàng Jêsu đờm: “Hũ mơnih pơrpa rơwơ̆ tŭp Kơu, kơyoa Kơu kràn-thơu hũ gơnăp-gơnuăr mư̆ng Kơu tơbiă.” ");
INSERT INTO cje_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Tŭ mơnih kơmơi thơu lài drơi 'buh rơgơi bơdơŭ jiơ̆ng tra, nư̆n kơtơ̆ drơi, truh pơđih rùp tơ anaŭ Pô, sơ̆ng đờm akhàn tơpă abih tơ anaŭ buơl làng kơyoa hơgĕ ñu hũ rơwơ̆ tŭp Pô, sơ̆ng ñu hũ pơsồ-pơsaih lăm tơk mư hơyơu lơi. ");
INSERT INTO cje_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yàng Jêsu đờm sơ̆ng ñu: “Ơ anà kơmơi Kơu, pơnuaĭ păng-tui anà hũ pơsồ-pơsaih tơ anà. Nau bĕ rĭng-lơngai.” ");
INSERT INTO cje_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Lăm tŭ Pô dò đờm, nư̆n hũ mơnih mư̆ng sàng-dơnò Jeru truh đờm brơi pơthơu tơ ñu: “Anà kơmơi kơi mơtai bơjơ, juơi pơ-uă pơgleh Pô-Pơto tra.” ");
INSERT INTO cje_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Tŭ Yàng Jêsu mơhư̆ yơu nư̆n, Pô đờm sơ̆ng Jeru: “Juơi huơĭ! Mĭn păng-tui soh, nư̆n anà kơmơi hã rơŭ hũ dŏng hơdiŭ.” ");
INSERT INTO cje_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Tŭ truh sàng, Pô mĭn brơi Pier, Jakơ, Jăng, sơ̆ng ame ama anà kơmơi tìt nư̆n tơma găm sơ̆ng Pô. ");
INSERT INTO cje_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Tŭ nư̆n, abih tơgrơ̆ mơnih dò hia-c̆ŏ sơ̆ng wờl-dơmàn mư̆ng anà kơmơi tìt nư̆n. Bloh Pô đờm: “Juơi hia, anà kơmơi tìt ni 'buh mơtai ơu, bloh ñu dò đih.” ");
INSERT INTO cje_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Buơl guñu klau-pơtăt Pô, kơyoa thơu anà kơmơi tìt nư̆n mơtai bơjơ. ");
INSERT INTO cje_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Bloh Yàng Jêsu truh apăn tơ tơngàn anà kơmơi tìt, sơ̆ng iơu prŏng: “Ơ anà kơmơi tìt, tơgồ bĕ!” ");
INSERT INTO cje_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Bơngă-joa anà kơmơi tìt gài mơrai wơ̆, sơ̆ng ñu tơgồ sừp mư. Yàng Jêsu pơđăr aràng brơi ñu 'bơ̆ng. ");
INSERT INTO cje_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ame ama anà kơmơi tìt mă ngă c̆rih-takơtuă biă; bloh Pô pơkơŭ buơl guñu 'buh brơi đờm sơ̆ng aràng sơi thơu mư̆ng bruă hũ tơbiă truh. ");
INSERT INTO cje_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yàng Jêsu iơu sa-pluh dua aràng mơnih tơdi-tơdài pơgùm-pơtòm wơ̆, brơi tơ buơl guñu gơnăp-gơnuăr sơ̆ng gơnuăr-pràn tô pơtrơh kơmlài sơ̆ng pơsồ-pơsaih lơ-ơ̆n lơngoh rơwă-sơkì. ");
INSERT INTO cje_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Pô pơđăr buơl guñu nau pơto-akhàn mư̆ng lơgăr Yàng Pô Lơngì sơ̆ng pơsồ-pơsaih tơ du mơnih lơ-ơ̆n lơngoh rơwă-sơkì. ");
INSERT INTO cje_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Pô pơto-pơđăr buơl guñu: “Tŭ nau jơlàn juơi apăn hơgĕ tui, juơi apăn gai jra, juơi apăn kơdŭng nau jơlàn, juơi apăn pah, juơi apăn priă, kŭng juơi apăn dua blah ào. ");
INSERT INTO cje_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Tŭ buơl guhã tơma lăm sàng lơi, dò bĕ tơ anih nư̆n tơ̆l truh tơ tŭ tơbiă nau. ");
INSERT INTO cje_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Yah anih lơi aràng 'buh wă-rò buơl guhã, nư̆n tŭ tơbiă mư̆ng plơi-prŏng nư̆n, tơrtuh bĕ hơbơu lơ̆n hũ klĕm tơ tơkai buơl guhã, tô ngă grơh tămdră-wơ̆ sơ̆ng buơl guñu.” ");
INSERT INTO cje_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Yơu nư̆n, du mơnih tơdi-tơdài tơbiă nau, mư̆ng plơi ni truh plơi dih, pơto-akhàn Pơnuaĭ-Siàm lăm abih tơgrơ̆ anih, sơ̆ng pơsồ-pơsaih tơ mơnih hũ lơ-ơ̆n lơngoh rơwă-sơkì. ");
INSERT INTO cje_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Tŭ nư̆n, Herôt Antipa, mơnih hũ Sesa Rôma brơi ngă pơtau apăn-akŏ c̆àr Galile, hũ mơhư̆ thơu mư̆ng abih tơgrơ̆ bruă hũ tơbiă truh. Pơtau dò 'buh suk sơ̆ng 'buh thơu sơnư̆ng hơyơu lơi. Kơyoa hũ mơnih đờm: nư̆n la Jăng 'Baptis mư̆ng mơnih mơtai hơdiŭ wơ̆. ");
INSERT INTO cje_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Du mơnih pơkơ̆n đờm: la mơnih gơnuăr-hwơ̆r Eli hũ tơbiă pơ'buh rùp. Sơ̆ng du mơnih pơkơ̆n wơ̆ đờm: nư̆n la sa aràng mơnih gơnuăr-hwơ̆r rài yau hơdiŭ wơ̆. ");
INSERT INTO cje_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herôt nư̆n đờm: “Jăng, nư̆n kơu hũ koh akŏ bơjơ, bloh mơnih ni la aràng sơi bloh kơu hũ mơhư̆ hũ ngă du bruă c̆rih-krơi yơu nư̆n?” Pơtau duah ngă hơyơu tô tòm Yàng Jêsu. ");
INSERT INTO cje_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Du mơnih tơdi-tơdài gài mơrai đờm-akhàn wơ̆ sơ̆ng Yàng Jêsu mư̆ng abih tơgrơ̆ bruă buơl guñu hũ ngă. Pô ba buơl guñu nau krơi sơ̆ng Pô, truh tơ sa plơi-prŏng angăn la 'Betsaiđa ");
INSERT INTO cje_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Tŭ buơl làng mơhư̆ thơu pơnuaĭ nư̆n, buơl guñu ba gơŭ nau tui Pô. Yàng Jêsu wă-rò buơl guñu sơ̆ng pơto-mơblàng tơ buơl guñu mư̆ng lơgăr Yàng Pô Lơngì. Pô kŭng pơsồ-pơsaih tơ du mơnih lơ-ơ̆n lơngoh rơwă-sơkì păl c̆àng hũ pơsồ-pơsaih. ");
INSERT INTO cje_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Tŭ kơjĕ sùp, sa-pluh dua aràng mơnih tơdi-tơdài truh đờm sơ̆ng Pô: “Yòng Pô brơi buơl làng nau wơ̆, tô buơl guñu tơma lăm du plơi sơ̆ng du anih jĕ tòmdăr anih ni, duah anih đih sơ̆ng duah phơ̆n 'bơ̆ng, kơyoa anih buơl gudrơi dò ni la anih 'blàng-jơhua.” ");
INSERT INTO cje_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Bloh Pô đờm: “Rùp-phŭn buơl guhã păl brơi buơl guñu 'bơ̆ng!” Du mơnih tơdi-tơdài đờm: “Yah rùp-phŭn buơl dơlhă 'buh nau blơi phơ̆n 'bơ̆ng tơ abih buơl làng ni, nư̆n buơl dơlhă mĭn hũ lơma boh pah sơ̆ng dua drơi akàn soh.” ");
INSERT INTO cje_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Kơyoa hũ truh pơgăp lơma rơbơu aràng mơnih lơkơi, nư̆n Pô đờm sơ̆ng du mơnih tui-mơgru: “Pơđăr bĕ buơl guñu dò guh tui tơrpuơl, yàu tơrpuơl lơma pluh aràng.” ");
INSERT INTO cje_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Du mơnih tui-mơgru ngă tui yơu nư̆n, sơ̆ng đờm pơđăr abih tơgrơ̆ mơnih dò guh. ");
INSERT INTO cje_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yàng Jêsu mă lơma boh pah sơ̆ng dua drơi akàn, ngừk mơta tơ ngŏ lơngì, ưnjơmừn, bloh nư̆n 'bĕt sơ̆ng brơi tơ du mơnih tui-mơgru, tô buơl guñu pơrpha tơ tơrpuơl buơl làng. ");
INSERT INTO cje_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Abih tơgrơ̆ mơnih 'bơ̆ng trơi. Du pĕt pah dò dơlah, buơl guñu duơ̆n wơ̆ hũ sa-pluh dua bài baŭ. ");
INSERT INTO cje_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Sa hơrơi dih, tŭ Yàng Jêsu dò krơi tô iơu-lài, du mơnih tui-mơgru Pô kŭng dò tơ anih nư̆n sơ̆ng Pô. Pô tơnia buơl guñu: “Buơl làng đờm Kơu la aràng sơi?” ");
INSERT INTO cje_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Buơl guñu đờm: “Hũ mơnih đờm la Jăng 'Baptis, mơnih pơkơ̆n đờm la Eli; mơnih pơkơ̆n wơ̆ đờm la sa aràng lăm du mơnih gơnuăr-hwơ̆r rài yau hơdiŭ wơ̆.” ");
INSERT INTO cje_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Pô tơnia buơl guñu: “Mư̆ng pơ-ơnah buơl guhã, buơl guhã đờm Kơu la aràng sơi?” Pier đờm: “Pô-Pơto la Pô Krist Yàng Pô Lơngì.” ");
INSERT INTO cje_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yàng Jêsu pơkơŭ du mơnih tui-mơgru 'buh hũ đờm pơnuaĭ nư̆n sơ̆ng aràng sơi. ");
INSERT INTO cje_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Yàng Jêsu đờm: “Anà Mơnih păl kŏng lô pơnuaĭ pơđì-pơđoa gleh-glăr, păl kŏng du mơnih gơnuăr-tha, du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt, sơ̆ng du mơnih gơnuăr-pơto pơnuaĭ adăt-adia kơmlah-luơi, păl kŏng pơmơtai, bloh hơdơi klơu hơrơi rơŭ hơdiŭ wơ̆.” ");
INSERT INTO cje_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Bloh nư̆n Pô đờm sơ̆ng abih tơgrơ̆ mơnih: “Yah aràng sơi khiăng tui Kơu, păl prah luơi rùp-phŭn drơi, yàu hơrơi glăm kơyơu pơkăl drơi bloh tui Kơu. ");
INSERT INTO cje_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kơyoa aràng sơi khiăng dŏng pơnuaĭ hơdiŭ drơi nư̆n rơŭ lơhiă pơnuaĭ hơdiŭ biă. Dò aràng sơi kơyoa mư̆ng Kơu bloh lơhiă pơnuaĭ hơdiŭ, nư̆n rơŭ đồ-mă hũ pơnuaĭ hơdiŭ biă. ");
INSERT INTO cje_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Yah mơnih lơi hũ abih dun-ya, bloh rùp-phŭn drơi păl kŏng lơhiă halài kŏng mơtai-lơhiă, nư̆n hũ kwơ-màng hơgĕ? ");
INSERT INTO cje_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Kơyoa yah aràng sơi mơlơu alah mư̆ng Kơu sơ̆ng pơnuaĭ Kơu, nư̆n Anà Mơnih kŭng rơŭ mơlơu alah mư̆ng mơnih nư̆n tŭ Pô truh lăm pơnuaĭ màng-kơc̆rà drơi, pơnuaĭ màng-kơc̆rà Ama sơ̆ng du mơnih gơdrưh sơc̆ih-sri. ");
INSERT INTO cje_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Iơŭ biă, Kơu đờm sơ̆ng buơl guhã, lăm du mơnih dò dơ̆ng tơ anih ni, hũ du mơnih rơŭ 'buh mơtai dơlhơu tŭ 'buh lơgăr Yàng Pô Lơngì.” ");
INSERT INTO cje_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Pơgăp tơlpăn hơrơi hơdơi tŭ đờm du pơnuaĭ ni, Yàng Jêsu ba Pier, Jăng sơ̆ng Jakơ nau sơ̆ng Pô đì tơ ngŏ c̆ơ̆ tô iơu-lài. ");
INSERT INTO cje_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Lăm tŭ iơu-lài, 'bò mơta Pô pơsơlih krơi, ào Pô tơbiă jiơ̆ng kò-pơtih sơ̆ng kơc̆rà sơrdah. ");
INSERT INTO cje_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Sơ̆ng dih, hũ dua aràng mơnih đờm glai sơ̆ng Pô, nư̆n la Môise sơ̆ng Eli. ");
INSERT INTO cje_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Buơl guñu tơbiă pơ'buh rùp lăm pơnuaĭ màng-kơc̆rà, sơ̆ng đờm mư̆ng pơnuaĭ Pô rơŭ păl kŏng mơtai tơ Jerusalem, tô ngă wĭl-tơ̆l bruă Yàng Pô Lơngì hũ ngă-nìn. ");
INSERT INTO cje_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pier sơ̆ng du mơnih adơi-ai gơŭ nau găm sơ̆ng ñu tơnò mơta biă, bloh tŭ mơdơh tơgồ, buơl guñu 'buh pơnuaĭ màng-kơc̆rà Yàng Jêsu sơ̆ng dua aràng mơnih dò dơ̆ng sơ̆ng Pô. ");
INSERT INTO cje_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Tŭ Môise sơ̆ng Eli kơjĕ tơbiă nau, nư̆n Pier đờm sơ̆ng Pô lài: “Ơ Pô-Pơto, buơl gudrơi dò tơ anih ni siàm biă. Luơi buơl dơlhă ngă klơu boh pờ: sa boh tơ Pô, sa boh tơ Môise, sơ̆ng sa boh tơ Eli.” Pier đờm bloh 'buh thơu drơi đờm hơgĕ. ");
INSERT INTO cje_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Lăm tŭ Pier dò đờm, nư̆n hũ sa puk hwăl truh jơ̆m-ac̆ĭng buơl guñu. Klơu aràng mơnih tui-mơgru huơĭ kơđa biă tŭ tơma lăm puk hwăl. ");
INSERT INTO cje_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Sơ̆ng mư̆ng puk hwăl hũ săp đờm lài: “Ni la Anà Kơu, Mơnih bloh Kơu hũ rơwah, păng bĕ pơnuaĭ Ñu.” ");
INSERT INTO cje_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Tŭ săp nư̆n đờm abih, nư̆n mĭn dò 'buh sa aràng Yàng Jêsu. Lăm du hơrơi nư̆n, du mơnih tui-mơgru pioh kơđơ̆ng-rik pơnuaĭ nư̆n, 'buh đờm sơ̆ng aràng sơi thơu mư̆ng tơgrơ̆ bruă hơgĕ drơi hũ 'buh. ");
INSERT INTO cje_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Hơrơi hơdơi, tŭ Yàng Jêsu sơ̆ng du mơnih tui-mơgru mư̆ng glòng c̆ơ̆ trŭn, hũ sa tơrpuơl lô buơl làng truh c̆àng tòm Pô. ");
INSERT INTO cje_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Tŭ nư̆n, hũ sa aràng mơnih lăm tơrpuơl mơnih lô iơu driau lài: “Ơ Pô-Pơto, yòng Pô-Pơto anĭt-anăr tơ anà lơkơi dơlhă, kơyoa dơlhă mĭn hũ sa aràng ñu soh. ");
INSERT INTO cje_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Tŭ kơđòng kơmlài ngă, ñu mơre-mơro kơmrào driau; kơmlài pơsơboh ñu pràn-mơsak biă, tơ̆l truh tơbiă ia kơmbuh mư̆ng kàng, rùp-phàp brơ̆p lơka abih, sơ̆ng tơkì tŭ kơmlài luơi ñu dò kơđơ̆ng. ");
INSERT INTO cje_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Dơlhă hũ yòng du mơnih tui-mơgru Pô-Pơto pơtrơh kơmlài nư̆n, bloh buơl guñu pơtrơh 'buh jiơ̆ng.” ");
INSERT INTO cje_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yàng Jêsu đờm: “Ơ jơi-pơtiàn 'buh păng-tui sơ̆ng kră-khăng hơtai-hơtiàn dih! Kơu păl dò sơ̆ng buơl guhã sơ̆ng kŏng ă-ư̆n buơl guhã tơ̆l truh tơ tŭ lơi? Ba bĕ anà hã truh tơ anih ni.” ");
INSERT INTO cje_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Tŭ adơi lơkơi tìt pơrpa truh jĕ, nư̆n kơmlài pơsơboh ñu lơbuh tơ ala lơ̆n, sơ̆ng sơkruh ñu pràn biă. Bloh Yàng Jêsu puaĭ pơtrơh kơmlài, pơsồ-pơsaih tơ adơi tìt, sơ̆ng jào ñu wơ̆ tơ ama ñu. ");
INSERT INTO cje_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Abih tơgrơ̆ mơnih mă ngă krơi-takơtuă biă mư̆ng gơnăp-gơnuăr prŏng Yàng Pô Lơngì. Lăm tŭ abih tơgrơ̆ mơnih dò mă ngă c̆rih-takơtuă mư̆ng tơgrơ̆ bruă Yàng Jêsu hũ ngă, nư̆n Pô đờm sơ̆ng du mơnih tui-mơgru: ");
INSERT INTO cje_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Buơl guhã păl păng-mơhư̆ nĭ-nùn bĕ du pơnuaĭ Kơu đờm ni: Anà Mơnih rơŭ kŏng jào lăm tơngàn aràng.” ");
INSERT INTO cje_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Bloh du mơnih tui-mơgru 'buh wờng pơnuaĭ nư̆n. Kơyoa tha mơblàng du pơnuaĭ nư̆n dò kŏng ac̆ĭng-tơrđơŭ sơ̆ng buơl guñu, nư̆n buơl guñu 'buh kràn-thơu jiơ̆ng, sơ̆ng buơl guñu kŭng huơĭ nư̆n 'buh khĭn tơnia Pô mư̆ng pơnuaĭ nư̆n. ");
INSERT INTO cje_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Du mơnih tui-mơgru đờm tămpơrjai sơ̆ng gơŭ, c̆ơ aràng sơi lăm buơl guñu la mơnih prŏng-màng rơlau abih. ");
INSERT INTO cje_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yàng Jêsu thơu pơnuaĭ lăm hơtai-akŏ buơl guñu sơnư̆ng, nư̆n Pô ba sa aràng lơ-ơneh tìt, luơi dò dơ̆ng jĕ tơ gah Pô, ");
INSERT INTO cje_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","bloh nư̆n Pô đờm sơ̆ng buơl guñu: “Aràng sơi kơyoa mư̆ng angăn Kơu bloh wă-rò lơ-ơneh tìt ni, nư̆n la wă-rò Kơu. Aràng sơi wă-rò Kơu, nư̆n la wă-rò Pô hũ pơđăr Kơu. Kơyoa mơnih lơi tìt rơlau abih lăm buơl guhã, nư̆n la mơnih prŏng-màng rơlau abih.” ");
INSERT INTO cje_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jăng pồ săp đờm: “Ơ Pô-Pơto, buơl dơlhă hũ 'buh sa aràng mơnih mă angăn Pô-Pơto bloh pơtrơh kơmlài. Buơl dơlhă hũ pơkơŭ mơnih nư̆n, kơyoa mơnih nư̆n 'buh nau tui Pô-Pơto sơ̆ng buơl dơlhă.” ");
INSERT INTO cje_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Bloh Yàng Jêsu đờm sơ̆ng ñu: “Juơi pơkơŭ buơl guñu, kơyoa aràng sơi 'buh tămdră sơ̆ng buơl guhã, nư̆n la siàm-tămsòr sơ̆ng buơl guhã.” ");
INSERT INTO cje_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Kơjĕ truh hơrơi Yàng Jêsu hũ rò-đì tơ ngŏ lơngì, Pô ngă-nìn nau truh tơ plơi-prŏng Jerusalem. ");
INSERT INTO cje_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Pô pơđăr du mơnih nau dơlhơu drơi. Buơl guñu nau tơma lăm sa plơi mơnih Samari tô rơc̆ăng dơlhơu anih dò tơ Pô. ");
INSERT INTO cje_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Bloh mơnih Samari 'buh wă-rò Pô, kơyoa Pô nau tơpă tơ plơi-prŏng Jerusalem. ");
INSERT INTO cje_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Jakơ sơ̆ng Jăng la du mơnih tui-mơgru Pô 'buh yơu nư̆n, buơl guñu đờm: “Khoai Yàng, Yàng hũ khiăng buơl dơlhă pơđăr apui mư̆ng ngŏ lơngì trŭn pơluĭ-pơlơhiă buơl guñu ơu?” ");
INSERT INTO cje_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Bloh Yàng Jêsu pơtrah wơ̆ đờm puaĭ tơ dua aràng buơl guñu. ");
INSERT INTO cje_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Bloh nư̆n Pô sơ̆ng du mơnih tui-mơgru nau tơ plơi pơkơ̆n. ");
INSERT INTO cje_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Lăm tŭ Yàng Jêsu sơ̆ng du mơnih tui-mơgru Pô nau jơlàn, nư̆n hũ mơnih đờm sơ̆ng Pô lài: “Pô-Pơto nau anih lơi dơlhă rơŭ tui anih nư̆n!” ");
INSERT INTO cje_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yàng Jêsu đờm: “Mơja hũ lơbàng, c̆ĭm lơngì hũ sruh, bloh Anà Mơnih 'buh hũ anih guơ̆l akŏ.” ");
INSERT INTO cje_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yàng Jêsu đờm sơ̆ng sa aràng mơnih pơkơ̆n: “Hã tui bĕ Kơu!” Bloh mơnih nư̆n đờm: “Khoai Yàng, yòng brơi dơlhă mơrai wơ̆ dơ̆r ama dơlhă dơlhơu ka.” ");
INSERT INTO cje_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Bloh Yàng Jêsu đờm: “Luơi bĕ mơnih mơtai dơ̆r mơnih mơtai buơl guñu. Dò pơ-ơnah hã, nau bĕ sơ̆ng pơto-akhàn mư̆ng lơgăr Yàng Pô Lơngì.” ");
INSERT INTO cje_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Sa aràng mơnih pơkơ̆n wơ̆ đờm: “Khoai Yàng, dơlhă rơŭ tui Pô, bloh yòng brơi dơlhă nau wơ̆ apăn tơngàn sơ̆ng mơnih lăm sàng-dơnò dơlhă dơlhơu ka.” ");
INSERT INTO cje_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yàng Jêsu đờm: “Aràng sơi hũ apăn lơngăl lơ-ua bloh dò pơtrah c̆ơ wơ̆ tơ gah rŏng, nư̆n 'buh iơŭ păl sơ̆ng lơgăr Yàng Pô Lơngì.” ");
INSERT INTO cje_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Hơdơi mư̆ng nư̆n, Yàng Jêsu rơwah tơjuh pluh aràng mơnih tui-mơgru pơkơ̆n, sơ̆ng pơđăr tui yơu nau dơlhơu Pô, truh tơ du plơi-prŏng sơ̆ng du anih bloh rùp-phŭn Pô rơŭ nau. ");
INSERT INTO cje_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Pô đờm sơ̆ng buơl guñu: “Blàn yuă nư̆n hũ biă, bloh mơnih yuă nư̆n tơkì. Yơu nư̆n, yòng bĕ Pô blàn yuă pơđăr lô mơnih yuă rơlau tơma lăm 'blàng hơma Pô. ");
INSERT INTO cje_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Nau bĕ; ni, Kơu pơđăr buơl guhã nau, 'buh krơi yơu du abo anà nau tơkrah kơtàr asơu sĭng. ");
INSERT INTO cje_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Juơi apăn tui kơdŭng priă, kơdŭng nau jơlàn, kơlì kơjuă, sơ̆ng kŭng juơi dò pơdơh tơnia c̆uă aràng sơi rò jơlàn. ");
INSERT INTO cje_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Yah buơl guhã tơma lăm sàng lơi, dơlhơu biă đờm bĕ: ‘Yòng lơkơu pơnuaĭ rĭng-lơngai dò sơ̆ng sàng-dơnò ni!’ ");
INSERT INTO cje_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Yah lăm sàng-dơnò nư̆n hũ mơnih iơŭ păl đồ-mă pơnuaĭ rĭng-lơngai, nư̆n pơnuaĭ rĭng-lơngai buơl guhã rơŭ truh sơ̆ng mơnih nư̆n. Yah 'buh ơu nư̆n, pơnuaĭ rĭng-lơngai nư̆n rơŭ gài mơrai wơ̆ sơ̆ng buơl guhã. ");
INSERT INTO cje_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Dò bĕ lăm sàng nư̆n, 'bơ̆ng mơñŭm sơ̆ng buơl guñu tơgrơ̆ phơ̆n hơgĕ buơl guñu jà, kơyoa mơnih ngă bruă iơŭ păl hũ lĕng priă blàn drơi. Juơi luơi sàng ni nau sàng pơkơ̆n. ");
INSERT INTO cje_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Tŭ buơl guhã tơma lăm plơi-prŏng lơi bloh aràng wă-rò buơl guhã, nư̆n 'bơ̆ng bĕ du phơ̆n-kơya buơl guñu pồ tơ buơl guhã. ");
INSERT INTO cje_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Pơsồ-pơsaih bĕ tơ du mơnih lơ-ơ̆n lơngoh rơwă-sơkì lăm anih nư̆n, sơ̆ng đờm sơ̆ng buơl guñu lài: ‘Lơgăr Yàng Pô Lơngì hũ truh jĕ buơl guhã bơjơ’ ");
INSERT INTO cje_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Bloh tŭ buơl guhã tơma lăm plơi-prŏng lơi, bloh buơl làng lăm anih nư̆n 'buh wă-rò buơl guhã, nư̆n tơbiă bĕ tơ jơlàn prŏng buơl guñu sơ̆ng đờm: ");
INSERT INTO cje_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Găm truh hơbơu lơ̆n lăm plơi-prŏng buơl guhã klĕm tơ tơkai buơl dơlhă, buơl dơlhă kŭng tơrtuh abih, tô ngă grơh tămdră wơ̆ sơ̆ng buơl guhã. Bloh buơl guhã păl thơu pơnuaĭ ni: Lơgăr Yàng Pô Lơngì hũ truh jĕ buơl guhã bơjơ!’ ");
INSERT INTO cje_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Kơu đờm tơ buơl guhã thơu: truh hơrơi c̆ahrơña, plơi-prŏng Sôđôm rơŭ kŏng ngă glài sơ-uơ̆l rơlau tơ plơi-prŏng nư̆n wơ̆. ");
INSERT INTO cje_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Gleh-glăr dồn-să tơ hã, ơ plơi-prŏng Kôrasin! Gleh-glăr dồn-să tơ hã, ơ plơi-prŏng 'Betsaiđa! Kơyoa yah du pơnuaĭ c̆rih-krơi hũ ngă tơkrah buơl guhã bloh apăn ngă tơ plơi-prŏng Tirơ sơ̆ng plơi-prŏng Siđôn, nư̆n buơl guñu hũ c̆ù ào biài blơu kơtăl, đoa hơbơu gìng, sơ̆ng mơbai prah-luơi glài-sơnoh mư̆ng suơi bơjơ. ");
INSERT INTO cje_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Kơyoa nư̆n, lăm hơrơi c̆ahrơña, plơi-prŏng Tirơ sơ̆ng plơi-prŏng Siđôn rơŭ kŏng ngă glài sơ-uơ̆l rơlau tơ buơl guhã. ");
INSERT INTO cje_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Dò hã wơ̆, ơ plơi-prŏng Kapenaum, hã sơnư̆ng la drơi rơŭ hũ pồ-pơđì truh tơ ngŏ lơngì? 'Buh ơu, hã rơŭ kŏng pơtrŭn truh tơ ala lơgăr atơu! ");
INSERT INTO cje_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Aràng sơi păng buơl guhã, nư̆n la păng Kơu. Aràng sơi kơmlah-luơi buơl guhã, nư̆n la kơmlah-luơi Kơu. Aràng sơi kơmlah-luơi Kơu, nư̆n la kơmlah-luơi Pô hũ pơđăr Kơu.” ");
INSERT INTO cje_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Tơjuh pluh aràng mơnih tui-mơgru gài mơrai wơ̆, sờh-sài đờm sơ̆ng Pô: “Khoai Yàng, gơnừm tơ angăn Pô, bloh du kơmlài păl păng-huơĭ buơl dơlhă.” ");
INSERT INTO cje_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Pô đờm sơ̆ng buơl guñu: “Kơu hũ 'buh Satăn mư̆ng lơngì lĕ trŭn yơu kơrla c̆ă. ");
INSERT INTO cje_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ni, Kơu brơi tơ buơl guhã gơnăp-gơnuăr tô juă trơ̆m ala, adiăng, sơ̆ng tơ ngŏ tơgrơ̆ gơnuăr-pràn mơnih mơbai-tămdră. 'Buh hũ pơnuaĭ hơgĕ ngă jơhà buơl guhã jiơ̆ng. ");
INSERT INTO cje_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Bloh yah yơu nư̆n, juơi sờh kơyoa du kơmlài păng-huơĭ tơ buơl guhã, bloh sờh-sài bĕ kơyoa mơta buơl guhã hũ wă tơ ngŏ lơngì bơjơ.” ");
INSERT INTO cje_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Kŭng lăm jơ nư̆n, Yàng Jêsu sờh-sài lăm Yàng Bơngă Sơc̆ih-Sri sơ̆ng đờm: “Khoai Ama, la Yàng lơngì sơ̆ng tơnah! Anà mơyòm-pơglòng Ama, kơyoa Ama hũ bơdơŭ du pơnuaĭ ni sơ̆ng mơnih jak-khờh, mơnih jak-sơrdah, bloh ràng-tơbiă tơ du lơ-ơneh tìt! Biă yơu nư̆n, ơ Ama, kơyoa pơnuaĭ ni siàm hơtai Ama. ");
INSERT INTO cje_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ama Kơu hũ jào abih tơgrơ̆ mơta tơ Kơu. Rơlau tơ Ama 'buh hũ aràng sơi thơu Anà, rơlau tơ Anà sơ̆ng du mơnih lơi Anà khiăng ràng-tơbiă, nư̆n kŭng 'buh hũ aràng sơi thơu Ama.” ");
INSERT INTO cje_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Bloh nư̆n Pô pơtrah wơ̆ sơ̆ng du mơnih tui-mơgru bloh đờm krơi sơ̆ng buơl guñu: “Lơngai-pơtuah tơ mơta lơi hũ 'buh pơnuaĭ buơl guhã 'buh! ");
INSERT INTO cje_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Kơyoa Kơu đờm sơ̆ng buơl guhã, hũ lô mơnih gơnuăr-hwơ̆r sơ̆ng lô kwăng-pơtau khiăng 'buh du pơnuaĭ buơl guhã 'buh, bloh 'buh hũ 'buh, khiăng mơhư̆ du pơnuaĭ buơl guhã mơhư̆, bloh 'buh hũ mơhư̆.” ");
INSERT INTO cje_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Tŭ nư̆n, hũ sa aràng mơnih gơnuăr-pơto pơnuaĭ adăt-adia tơgồ dơ̆ng tơnia tô lòng Yàng Jêsu lài: “Ơ Pô-Pơto, dơlhă păl ngă hơgĕ tô hũ đồ-mă pơnuaĭ hơdiŭ rài pơdò rài?” ");
INSERT INTO cje_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Pô đờm: “Lăm pơnuaĭ adăt-adia hũ wă pơnuaĭ hơgĕ? Hã pơrpoh-c̆ơ sơ̆ng wờng hơyơu lơi?” ");
INSERT INTO cje_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Mơnih nư̆n đờm: “Hã păl abih hơtai-hơtiàn, abih bơngă-joa, abih pràn, abih hơtai-akŏ bloh duh-rơnăm Yàng la Yàng Pô Lơngì hã; sơ̆ng rơnăm tơ mơnih gơŭ sa plơi adơi sa 'băng yơu rùp-phŭn drơi.” ");
INSERT INTO cje_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yàng Jêsu đờm: “Hã đờm sơđồ iơŭ biă. Ngă bĕ pơnuaĭ nư̆n, hã rơŭ hũ hơdiŭ.” ");
INSERT INTO cje_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Bloh mơnih nư̆n khiăng angăn drơi la mơnih rĭng-tơpă, nư̆n đờm sơ̆ng Yàng Jêsu: “Aràng sơi la mơnih gơŭ sa plơi adơi sa 'băng dơlhă?” ");
INSERT INTO cje_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yàng Jêsu đờm: “Hũ sa aràng mơnih mư̆ng plơi-prŏng Jerusalem trŭn tơ plơi-prŏng Jerikô, lăm jơlàn nau lĕ kơđòng lăm tơngàn buơl blơ̆. Guñu wà mă abih khăn-ào, pờng ngă rơ-o rùp bloh nư̆n nau, luơi mơti mơnih nư̆n mơtưh hơdiŭ mơtưh mơtai. ");
INSERT INTO cje_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Tŭ nư̆n, hũ sa aràng mơnih gơnuăr pơyă phơ̆n duh-dơlbăt nau trŭn găn jơlàn nư̆n, 'buh mơnih ni, ñu pleh gah dih jơlàn bloh nau. ");
INSERT INTO cje_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Kŭng yơu nư̆n rơi, sa aràng mơnih Lebi nau găn anih nư̆n, kŭng 'buh, bloh nư̆n kŭng pleh gah dih jơlàn bloh nau. ");
INSERT INTO cje_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Bloh hũ sa aràng mơnih Samari nau jơlàn, truh jĕ mơnih nư̆n, c̆ơ 'buh nư̆n hũ hơtai-hơtiàn anĭt-anăr. ");
INSERT INTO cje_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ñu truh jĕ, mă mơñà sơ̆ng alak lŭ lăm anih brơ̆p lơka, akă pơpò wơ̆; bloh nư̆n đơ̆ng mơnih nư̆n đì tơ rŏng alàng drơi, sơ̆ng ba truh tơ anih sàng apah-đih tô c̆ơ rak. ");
INSERT INTO cje_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Hơrơi hơdơi, mơnih nư̆n mă dua đơnie brơi tơ mơnih pô sàng apah-đih sơ̆ng đờm: ‘Yòng c̆ơ rak bĕ mơnih ni, yah lơhiă rơlau hơdùm priă, nư̆n tŭ gài mơrai wơ̆ dơlhă rơŭ bơ-yàr c̆iŭ wơ̆.’ ");
INSERT INTO cje_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Tui hã sơnư̆ng, lăm klơu aràng mơnih nư̆n, aràng sơi la mơnih gơŭ sa plơi adơi sa 'băng sơ̆ng mơnih kơđòng lĕ tơma lăm tơngàn buơl blơ̆?” ");
INSERT INTO cje_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Mơnih gơnuăr-pơto pơnuaĭ adăt-adia đờm: “Nư̆n la mơnih hũ ràng-tơbiă hơtai-hơtiàn anĭt-anăr sơ̆ng mơnih nư̆n.” Yàng Jêsu đờm: “Nau bĕ, ngă tui yơu nư̆n.” ");
INSERT INTO cje_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Tŭ Yàng Jêsu sơ̆ng du mơnih tui-mơgru nau jơlàn, Pô pleh tơma lăm sa plơi dih. Hũ sa aràng mơnih kơmơi angăn la Mathe, wă-rò Pô tơma lăm sàng drơi. ");
INSERT INTO cje_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mathe hũ sa aràng adơi kơmơi angăn la Mari, dò guh tơ ala tơkai Yàng tô păng pơnuaĭ Pô pơto. ");
INSERT INTO cje_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Bloh Mathe nư̆n sŭn-dŭn sơ̆ng lô bruă păl rơc̆ăng ngă tô duh bruă, nư̆n ñu truh đờm sơ̆ng Pô: “Khoai Yàng, adơi dơlhă luơi sa aràng dơlhă duh bruă, bloh Pô 'buh c̆ơ sơnư̆ng hơgĕ truh ơu? Yòng Pô đờm pơđăr ñu dŏng dơlhă sa tơngàn!” ");
INSERT INTO cje_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Yàng đờm: “Ơ Mathe, Mathe, hã sơnư̆ng kơ-ù sơ̆ng dò 'buh suk mư̆ng lô bruă; ");
INSERT INTO cje_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","bloh mĭn hũ sa bruă prŏng-màng soh. Mari hũ rơwah pơ-ơnah siàm rơlau, la pơ-ơnah rơŭ 'buh hũ aràng sơi tămblah mă jiơ̆ng.” ");
INSERT INTO cje_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Hũ sa amăng, Yàng Jêsu dò iơu-lài tơ sa anih dih. Hơdơi tŭ iơu-lài abih, sa aràng mơnih tui-mơgru đờm sơ̆ng Pô: “Khoai Yàng, yòng pơto buơl dơlhă iơu-lài, kŭng yơu Jăng hũ pơto du mơnih tui-mơgru ñu rơi.” ");
INSERT INTO cje_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Pô đờm sơ̆ng buơl guñu: “Tŭ buơl guhã iơu-lài, đờm bĕ: ‘Khoai Ama! Yòng angăn sơc̆ih-sri Ama hũ màng-kơc̆rà. Lơgăr Ama hũ truh. ");
INSERT INTO cje_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Yòng brơi buơl dơlhă phơ̆n-kơya 'bơ̆ng hơrơi lơi tơ̆l hơrơi nư̆n. ");
INSERT INTO cje_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Yòng anĭt toh-luơi glài-sơnoh tơ buơl dơlhă, kơyoa buơl dơlhă kŭng anĭt toh-luơi tơ du mơnih ngă sŭng glài sơ̆ng buơl dơlhă. Yòng juơi luơi buơl dơlhă lĕ-tơma lăm pơnuaĭ pơluơ-ơñiai!’ ” ");
INSERT INTO cje_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Bloh nư̆n Pô đờm sơ̆ng buơl guñu: “Aràng sơi lăm buơl guhã hũ sa aràng mơnih adơi-ai gơŭ, mơtưh mơlăm truh đờm lài: ‘Ơ adơi-ai gơŭ, yòng brơi dơlhă ơñàm klơu boh pah, ");
INSERT INTO cje_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","kơyoa dơlhă hũ mơnih adơi-ai gơŭ mư̆ng anih atàh pơrpa truh, sơ̆ng dơlhă 'buh hũ phơ̆n hơgĕ tô pồ tơ ñu 'bơ̆ng.’ ");
INSERT INTO cje_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Yah mơnih dih mư̆ng dơrlăm sàng đờm sơđồ: ‘Juơi pơ-uă pơrnŭng dơlhă, bơh 'băng krơ̆ bơjơ, du anà dơlhă sơ̆ng dơlhă tơma đih abih bơjơ. Dơlhă 'buh rơgơi tơgồ mă pah tơ sơ-ai jiơ̆ng!’ ");
INSERT INTO cje_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Kơu đờm sơ̆ng buơl guhã, yah mơnih dih 'buh tơgồ mă pah brơi tơ mơnih nư̆n kơyoa la mơnih adơi-ai gơŭ drơi, bloh kŭng rơŭ tơgồ, tô brơi tơ mơnih nư̆n tơgrơ̆ pơnuaĭ hơgĕ ñu păl c̆àng, kơyoa mơnih nư̆n kừ kơjăp-hơtai tơtoh bơh 'băng mĭt. ");
INSERT INTO cje_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Yơu nư̆n, Kơu đờm sơ̆ng buơl guhã: Yòng bĕ, rơŭ hũ; duah bĕ, rơŭ tòm; tơtoh bĕ, bơh 'băng rơŭ pơh tơ buơl guhã. ");
INSERT INTO cje_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kơyoa yah aràng sơi yòng nư̆n hũ, aràng sơi duah nư̆n tòm, sơ̆ng aràng sơi tơtoh nư̆n bơh 'băng rơŭ hũ pơh. ");
INSERT INTO cje_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Lăm buơl guhã, hũ aràng sơi la mơnih ama, tŭ anà drơi yòng akàn, bloh brơi ala tơ ñu ơu? ");
INSERT INTO cje_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Halài yòng boh mơnŭ, bloh brơi tơ ñu adiăng ơu? ");
INSERT INTO cje_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Yơu nư̆n, yah buơl guhã la mơnih jơhà, bloh dò thơu brơi tơ anà drơi du phơ̆n siàm, tơ-ài lài Ama buơl guhã tơ ngŏ lơngì, bloh 'buh brơi Yàng Bơngă Sơc̆ih-Sri tơ du mơnih yòng lơkơu Pô ơu!” ");
INSERT INTO cje_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yàng Jêsu pơtrơh sa drơi kơmlài kơmlo. Tŭ kơmlài tơbiă klàh bơjơ, nư̆n mơnih kơmlo đờm jiơ̆ng. Tơrpuơl buơl làng mă ngă c̆rih-takơtuă biă. ");
INSERT INTO cje_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Bloh hũ du mơnih lăm buơl guñu đờm: “Mơnih ni gơnừm tơ Beelsebul la pơtau kơmlài bloh pơtrơh kơmlài.” ");
INSERT INTO cje_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Du mơnih pơkơ̆n wơ̆ khiăng lòng Pô, nư̆n buơl guñu yòng Pô brơi sa nàl-c̆rih mư̆ng ngŏ lơngì. ");
INSERT INTO cje_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Yàng Jêsu thơu hơtai sơnư̆ng buơl guñu, nư̆n đờm: “Sa lơgăr bloh pơc̆ơrlah krơi duă gơŭ drơi wơ̆, nư̆n rơŭ kŏng pơluĭ-pơlơhiă, sa boh sàng bloh pơc̆ơrlah krơi duă gơŭ drơi wơ̆, nư̆n rơŭ jơrlơh-tơrlŭng abih. ");
INSERT INTO cje_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Yơu nư̆n, yah Satăn pơc̆ơrlah krơi sơ̆ng rùp-phŭn ñu wơ̆, nư̆n ngă hơyơu lơgăr ñu dò dơ̆ng kơjăp jiơ̆ng? — Kơyoa buơl guhã đờm lài Kơu gơnừm tơ gơnuăr Beelsebul tô pơtrơh kơmlài. ");
INSERT INTO cje_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Yah Kơu gơnừm tơ gơnuăr Beelsebul tô pơtrơh kơmlài, nư̆n anà-tơc̆o buơl guhã gơnừm tơ gơnuăr aràng sơi tô pơtrơh kơmlài? Kơyoa nư̆n, rùp-phŭn buơl guñu rơŭ c̆ahrơña buơl guhã. ");
INSERT INTO cje_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Bloh yah Kơu gơnừm tơ gơnăp-gơnuăr Yàng Pô Lơngì bloh pơtrơh kơmlài, nư̆n lơgăr Yàng Pô Lơngì hũ truh sơ̆ng buơl guhã bơjơ. ");
INSERT INTO cje_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Tŭ sa aràng mơnih pràn-khăng hũ rơc̆ăng apăn tơ̆l phơ̆n tămngă tô khiă-gàr sàng-glăng drơi, nư̆n phơ̆n-bơna mơnih nư̆n hũ dò kơjăp lơngai. ");
INSERT INTO cje_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Bloh tŭ hũ mơnih pơkơ̆n pràn-khăng rơlau truh tămngă, sơ̆ng hũ pha-jai rơlau, nư̆n rơŭ mă abih phơ̆n tămngă bloh mơnih nư̆n gơnừm-gơnàng, sơ̆ng rơŭ apăn pơrpha abih du phơ̆n-bơna bloh drơi tămblah mă hũ. ");
INSERT INTO cje_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Aràng sơi 'buh dò sơ̆ng Kơu, nư̆n tămdră-wơ̆ sơ̆ng Kơu. Aràng sơi 'buh pơgùm-pơtòm sơ̆ng Kơu, nư̆n kơprah-kơprĭng. ");
INSERT INTO cje_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Tŭ kơmlài sơŭ-sơnoh tơbiă mư̆ng sa aràng mơnih, ñu nau găn du anih thu-thàng tô duah anih pơdời gleh, bloh 'buh duah hũ, nư̆n ñu đờm: ‘Kơu rơŭ gài mơrai wơ̆ tơ sàng kơu, la anih kơu pơrpa tơbiă klàh!’ ");
INSERT INTO cje_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Tŭ mơrai wơ̆ truh anih, ñu 'buh sàng hũ bah uă goh sơ̆ng pơsăng daŭ siàm, ");
INSERT INTO cje_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","nư̆n ñu nau jà tơjuh drơi kơmlài pơkơ̆n mơsak rơlau tơ ñu wơ̆, tơma dò lăm sàng nư̆n. Yơu nư̆n, rài hơdiŭ mơnih nư̆n, tŭ hơdơi rơŭ jơhà rơlau tơ tŭ dơlhơu wơ̆.” ");
INSERT INTO cje_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Lăm tŭ Yàng Jêsu đờm du pơnuaĭ nư̆n, hũ sa aràng mơnih kơmơi mư̆ng tơrpuơl mơnih lô pồ săp đờm: “Lơngai-pơtuah tơ mơnih ame hũ đih apui Pô, sơ̆ng bòp hũ brơi Pô mơ̆m!” ");
INSERT INTO cje_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Bloh Yàng Jêsu đờm: “Du mơnih păng sơ̆ng păng-rơmiă ngă tui pơnuaĭ Yàng Pô Lơngì dò hũ lơngai rơlau!” ");
INSERT INTO cje_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Tŭ tơrpuơl buơl làng tơrgùm pơtòm gơŭ lô rơlau, Yàng Jêsu tơma đờm: “Jơi-pơtiàn rài ni la sa jơi-pơtiàn mơsak-jơhà. Buơl guñu tui duah sa nàl-c̆rih, bloh rơŭ 'buh hũ sa nàl-c̆rih lơi pơkơ̆n hũ brơi tơ buơl guñu rơlau tơ nàl-c̆rih Jôna. ");
INSERT INTO cje_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Kơyoa Jôna la nàl-c̆rih tơ buơl làng Ninibe hơyơu lơi, nư̆n Anà Mơnih kŭng rơŭ la nàl-c̆rih tơ jơi-pơtiàn rài ni yơu nư̆n rơi. ");
INSERT INTO cje_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Lăm hơrơi c̆ahrơña, mơnih pơtau-kơmơi gah-yù rơŭ tơgồ dơ̆ng tămdră wơ̆ sơ̆ng du mơnih lăm jơi-pơtiàn ni sơ̆ng ngă nìn-glài buơl guñu, kơyoa ñu hũ mư̆ng anih akŏ luĭ-dŭt boh tơnah truh păng pơnuaĭ jak-khờh pơtau Salômôn, bloh ni, tơ anih ni hũ Pô prŏng rơlau tơ pơtau Salômôn! ");
INSERT INTO cje_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Lăm hơrơi c̆ahrơña, buơl làng plơi-prŏng Ninibe rơŭ tơgồ dơ̆ng đờm yă jơi-pơtiàn ni sơ̆ng ngă nìn-glài buơl guñu, kơyoa buơl làng nư̆n hũ păng pơnuaĭ Jôna pơto-akhàn sơ̆ng mơbai prah-luơi glài-sơnoh; bloh ni, tơ anih ni hũ Pô prŏng rơlau tơ Jôna! ");
INSERT INTO cje_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","'Buh aràng sơi tuĭ apui đèng bloh daŭ tơ anih tơrđơŭ halài daŭ tơ ala thŭng, bloh daŭ tơ ngŏ tơkai đèng, tô tơgrơ̆ mơnih tơma hũ 'buh pơnuaĭ sơrdah. ");
INSERT INTO cje_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Mơta la apui đèng rùp-phàp. Tŭ mơta hã sơrdah, nư̆n abih rùp-phàp hã kŭng sơrdah. Bloh tŭ mơta hã jơhà, nư̆n abih rùp-phàp hã kŭng kơnăm-mơsrư̆. ");
INSERT INTO cje_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Yơu nư̆n, c̆ơ-kơrhia bĕ, tô pơnuaĭ sơrdah lăm hã 'buh iơŭ la pơnuaĭ kơnăm-mơsrư̆. ");
INSERT INTO cje_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Yah abih rùp-phàp hã sơrdah, 'buh hũ pơ-ơnah lơi kơnăm-mơsrư̆, nư̆n ñu rơŭ sơrdah wĭl-tơ̆l, kŭng yơu apui đèng pơsàng sơrdah tơ hã rơi.” ");
INSERT INTO cje_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Tŭ Yàng Jêsu dò đờm, nư̆n hũ sa aràng mơnih Pharisi jà Pô truh tơ sàng ñu huă 'bơ̆ng. Pô tơma lăm sàng sơ̆ng dò guh tơ anih c̆ơnừng huă 'bơ̆ng. ");
INSERT INTO cje_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Mơnih Pharisi ni mă ngă krơi-takơtuă tŭ 'buh Pô 'buh rào tơngàn dơlhơu tŭ huă 'bơ̆ng. ");
INSERT INTO cje_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Bloh Yàng đờm: “Mơnih Pharisi buơl guhã rào goh gah agàh c̆uàn sơ̆ng prèng, bloh gah dơrlăm nư̆n baŭ-bèng du pơnuaĭ hàm-kơrlih sơ̆ng mơsak-jơhà. ");
INSERT INTO cje_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ơ mơnih bơrngư̆l gơla! Pô hũ c̆rơ̆ng-tơbiă gah agàh, bloh 'buh c̆rơ̆ng-tơbiă gah dơrlăm ơu? ");
INSERT INTO cje_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Siàm rơlau, sơrmah-lơnàng hơtai-hơtiàn brơi-soh bĕ tơgrơ̆ phơ̆n hơgĕ drơi hũ, nư̆n tơgrơ̆ mơta rơŭ goh-sơc̆ih tơ buơl guhã. ");
INSERT INTO cje_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Gleh-glăr dồn-să tơ buơl guhã, ơ du mơnih Pharisi! Kơyoa buơl guhã daŭ sa pơ-ơnah sa-pluh mư̆ng ơñiăm lơboa, ơñiăm krồng, găm sơ̆ng tơgrơ̆ ơñiăm pơkơ̆n, bloh luơi wơ̆rglai pơnuaĭ rĭng-tơpă sơ̆ng hơtai-hơtiàn duh-rơnăm Yàng Pô Lơngì! Buơl guhã păl ngă du pơnuaĭ ni, bloh kŭng 'buh hũ luơi wơ̆rglai du pơnuaĭ dih. ");
INSERT INTO cje_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Gleh-glăr dồn-să tơ buơl guhã, ơ du mơnih Pharisi! Kơyoa buơl guhã khiăng dò guh anih siàm rơlau abih lăm sàng pơtòm, sơ̆ng khiăng hũ aràng kù akŏ tơnia c̆uă drơi tơkrah anih drà lô mơnih! ");
INSERT INTO cje_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Gleh-glăr dồn-să tơ buơl guhã! Kơyoa buơl guhã mơhiơ̆ yơu kŭt atơu jơhua 'buh hũ hơgĕ ngă nàl, aràng juă tơ ngŏ bloh 'buh thơu!” ");
INSERT INTO cje_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Tŭ nư̆n, sa aràng lăm du mơnih gơnuăr-pơto pơnuaĭ adăt-adia đờm sơ̆ng Pô: “Ơ Pô-Pơto, Pô-Pơto đờm yơu nư̆n la pơtăt-pơmơlơu găm buơl dơlhă rơi.” ");
INSERT INTO cje_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yàng Jêsu đờm: “Gleh-glăr dồn-să tơ buơl guhã rơi, la du mơnih gơnuăr-pơto pơnuaĭ adăt-adia! Kơyoa buơl guhã ngă tơbiă thơu hơdùm pơnuaĭ adăt-adia kăn-dơmăn sơ̆ng pơkơŭ-pơđăr mơnih pơkơ̆n păl păng-rơmiă ngă tui, lăm tŭ rùp-phŭn buơl guhã nư̆n 'buh păng-rơmiă ngă tui sa pơnuaĭ lơi. ");
INSERT INTO cje_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Gleh-glăr dồn-să tơ buơl guhã! Kơyoa buơl guhã bơ̆ kŭt-pơsàt tơ du mơnih gơnuăr-hwơ̆r bloh kơi-kŏ pàng-yau buơl guhã hũ pơmơtai! ");
INSERT INTO cje_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Yơu nư̆n, buơl guhã la du mơnih ngă grơh sơ̆ng sa hơtai-hơtiàn mư̆ng bruă kơi-kŏ pàng-yau drơi hũ ngă. Kơyoa buơl guñu hũ pơmơtai du mơnih gơnuăr-hwơ̆r, dò buơl guhã nư̆n bơ̆ kŭt-pơsàt tơ du mơnih gơnuăr-hwơ̆r. ");
INSERT INTO cje_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Kơyoa nư̆n, pơnuaĭ jak-khờh Yàng Pô Lơngì hũ đờm: ‘Kơu rơŭ pơđăr du mơnih gơnuăr-hwơ̆r sơ̆ng du mơnih tơdi-tơdài truh sơ̆ng guñu. Guñu rơŭ pơmơtai mơnih ni, mă-pơkơŭ mơnih dih.’ ");
INSERT INTO cje_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Yơu nư̆n, jơi-pơtiàn ni rơŭ kŏng đồ sre mư̆ng drah abih tơgrơ̆ mơnih gơnuăr-hwơ̆r hũ hŏ tơbiă mư̆ng tŭ c̆rơ̆ng-tơbiă lơngì-tơsì tơnah-rơya, ");
INSERT INTO cje_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","nư̆n la mư̆ng drah Abel tơ̆l truh tơ drah Sac̆ari, la mơnih hũ kŏng pơmơtai tơkrah anih c̆ơnừng pơyă phơ̆n duh-dơlbăt sơ̆ng anih sơc̆ih-sri. Biă, Kơu đờm sơ̆ng buơl guhã, jơi-pơtiàn ni rơŭ kŏng đồ mư̆ng sre drah nư̆n. ");
INSERT INTO cje_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Gleh-glăr dồn-să tơ buơl guhã, la du mơnih gơnuăr-pơto pơnuaĭ adăt-adia! Kơyoa buơl guhã hũ mă bơdơŭ kai-kăl bơh 'băng pơnuaĭ wờng-thơu, rùp-phŭn buơl guhã nư̆n 'buh tơma, bloh aràng sơi tơma nư̆n buơl guhã pơkơŭ-pơkăl 'buh brơi!” ");
INSERT INTO cje_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Tŭ Yàng Jêsu tơbiă klàh mư̆ng anih nư̆n, du mơnih gơnuăr-pơto pơnuaĭ adăt-adia sơ̆ng du mơnih Pharisi tơma tămdră sơ̆ng Pô pràn-mơsak biă, buơl guñu tơnia pơkăl Pô lô pơnuaĭ, ");
INSERT INTO cje_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","sơ̆ng kraŭ c̆ơ Pô hũ đờm pơnuaĭ hơgĕ sŭng ơu, tô hũ pơnuaĭ mă Pô. ");
INSERT INTO cje_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Tŭ nư̆n, buơl làng truh pơgùm-pơtòm gơŭ 'brŏ tŭ 'brŏ lô, rơtùh-rơbơu mơnih sŭl pơjeh gơŭ tơ̆l truh juă gơŭ juă găn. Dơlhơu biă Yàng Jêsu đờm sơ̆ng du mơnih tui-mơgru Pô: “Păl c̆ơ-kơrhia bĕ mư̆ng tơpơi mơnih Pharisi, nư̆n la pơnuaĭ lơ̆r-mơthĭ. ");
INSERT INTO cje_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","'Buh hũ pơnuaĭ hơgĕ ac̆ĭng-bơdơŭ bloh rơŭ 'buh kŏng ràng-tơbiă, 'buh hũ pơnuaĭ hơgĕ bơdơŭ-tơrđơŭ bloh aràng rơŭ 'buh thơu. ");
INSERT INTO cje_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Kơyoa nư̆n, du pơnuaĭ buơl guhã hũ đờm lăm anih kơnăm, rơŭ hũ mơhư̆ lăm anih sơrdah; du pơnuaĭ buơl guhã hũ đờm lăm anih kơpăng tơrđơŭ, rơŭ hũ đờm tơbiă mư̆ng ngŏ bơbŭng sàng. ");
INSERT INTO cje_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Kơu đờm sơ̆ng buơl guhã, la du mơnih adơi-ai gơŭ Kơu: Juơi huơĭ du mơnih pơmơtai gah rùp-phàp drah-rơlo, bloh nư̆n hơdơi 'buh ngă hơgĕ jiơ̆ng tra. ");
INSERT INTO cje_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Bloh Kơu pơto tơ buơl guhã thơu păl huơĭ aràng sơi: Păl huơĭ Pô hơdơi tŭ pơmơtai bơjơ, hũ gơnuăr prah trŭn lăm brŏng-apui. Biă, Kơu đờm sơ̆ng buơl guhã, nư̆n la Pô buơl guhã păl huơĭ! ");
INSERT INTO cje_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","'Buh iơŭ lơma drơi c̆ĭm c̆ek mĭn pơblơi hũ dua su priă ơu? Yơu nư̆n bloh, Yàng Pô Lơngì 'buh luơi wơ̆rglai sa drơi lơi ơu. ");
INSERT INTO cje_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Găm truh 'bù lăm akŏ buơl guhã kŭng hũ yàu abih bơjơ. Juơi huơĭ, kơyoa buơl guhã c̆ơk-màng rơlau tơ lô c̆ĭm c̆ek. ");
INSERT INTO cje_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Kơu đờm sơ̆ng buơl guhã, aràng sơi đờm angăn tơbiă ñu la mơnih tui-mơgru Kơu tơ anaŭ tơgrơ̆ mơnih, nư̆n Anà Mơnih kŭng rơŭ angăn tơbiă mơnih nư̆n tơ anaŭ du mơnih gơdrưh Yàng Pô Lơngì. ");
INSERT INTO cje_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Bloh aràng sơi đờm kơmlah-luơi Kơu tơ anaŭ tơgrơ̆ mơnih, nư̆n buơl guñu kŭng rơŭ kŏng kơmlah-luơi tơ anaŭ du mơnih gơdrưh Yàng Pô Lơngì. ");
INSERT INTO cje_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Aràng sơi đờm tămdră sơ̆ng Anà Mơnih, nư̆n rơŭ hũ anĭt toh-luơi; bloh aràng sơi đờm sơk-sơrbĭl truh Yàng Bơngă Sơc̆ih-Sri, nư̆n rơŭ 'buh hũ anĭt toh-luơi ơu. ");
INSERT INTO cje_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Tŭ aràng ba buơl guhã truh tơ anaŭ du sàng pơtòm, tơ anaŭ du mơnih apăn-akŏ, sơ̆ng tơ anaŭ du gơnuăr apăn-akŏ plơi lơgăr, nư̆n buơl guhã juơi sơnư̆ng kơ-ù păl đờm hơyơu lơi halài păl đờm hơgĕ tô dŏng rùp-phŭn drơi. ");
INSERT INTO cje_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Kơyoa lăm iơŭ tŭ jơ nư̆n, Yàng Bơngă Sơc̆ih-Sri rơŭ pơto buơl guhã tơgrơ̆ pơnuaĭ păl đờm.” ");
INSERT INTO cje_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Tŭ nư̆n, hũ sa aràng mơnih lăm tơrpuơl mơnih lô đờm sơ̆ng Yàng Jêsu: “Ơ Pô-Pơto, yòng pơđăr sơ-ai dơlhă pơrpha phŭm-kơsai phơ̆n-bơna tơ dơlhă.” ");
INSERT INTO cje_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Bloh Yàng Jêsu đờm: “Ơ mơnih dih, aràng sơi pồ Kơu ngă mơnih gơnuăr c̆ahrơña halài mơnih pơrpha phơ̆n-bơna phŭm-kơsai tơ buơl guhã?” ");
INSERT INTO cje_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Bloh nư̆n, Pô đờm sơ̆ng buơl guñu: “C̆ơ-kơrhia bĕ sơ̆ng gàr-rơmiă bĕ rùp drơi klàh mư̆ng tơgrơ̆ pơnuaĭ hàm-làm, kơyoa pơnuaĭ hơdiŭ anà mơnih 'buh iơŭ mĭn gơnừm tơ phơ̆n-bơna phŭm-kơsai drơi dơlah-dơlài ơu.” ");
INSERT INTO cje_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Hơdơi mư̆ng nư̆n, Pô đờm sơ̆ng buơl guñu sa pơnuaĭ pơgăp-pơmơyơu ni: “Hơma sa aràng mơnih mơda dih hũ iơŭ bơdai biă. ");
INSERT INTO cje_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Mơnih nư̆n sơnư̆ng lăm hơtai-hơtiàn lài: ‘Kơu păl ngă hơgĕ ni? Kơyoa 'buh dò tơ̆l anih tô pioh du bơdai bràh tra.’ ");
INSERT INTO cje_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Bloh nư̆n ñu đờm: ‘Kơu rơŭ ngă yơu ni: Kơu rơŭ toh abih du sàng pioh phơ̆n ni sơ̆ng bơ̆-ngă du sàng pioh phơ̆n pơkơ̆n prŏng rơlau, bloh nư̆n kơu rơŭ tơrgùm pioh abih du bơdai bràh sơ̆ng phơ̆n-bơna kơu lăm nư̆n. ");
INSERT INTO cje_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Kơu rơŭ đờm sơ̆ng bơngă-joa kơu lài: Ơ bơngă-joa! Hã hũ lô phơ̆n-bơna tô pioh tèm angui tơ lô thŭn bơjơ. Nư̆n, dò pơgleh bĕ, mơñŭm 'bơ̆ng, sơ̆ng sờh-sài!’ ");
INSERT INTO cje_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Bloh Yàng Pô Lơngì đờm sơ̆ng mơnih nư̆n: ‘Ơ mơnih bơrngư̆l-gơla dih! Lăm mơlăm ni, bơngă-joa hã rơŭ kơđòng đồ wơ̆; nư̆n du phơ̆n-bơna hã hũ rơc̆ăng pioh nư̆n rơŭ mơrai tơ tơngàn aràng sơi?’ ");
INSERT INTO cje_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Du mơnih mĭn rơc̆ăng tơrgùm-pioh phơ̆n-bơna tơ drơi, bloh 'buh mơda gơn-hư̆p anih Yàng Pô Lơngì, nư̆n kŭng yơu nư̆n rơi.” ");
INSERT INTO cje_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yàng Jêsu đờm sơ̆ng du mơnih tui-mơgru: “Kơyoa nư̆n, Kơu đờm sơ̆ng buơl guhã, juơi kơyoa pơnuaĭ hơdiŭ bloh sơnư̆ng kơ-ù mư̆ng phơ̆n 'bơ̆ng, kŭng juơi kơyoa rùp-phàp bloh sơnư̆ng kơ-ù mư̆ng phơ̆n c̆ù. ");
INSERT INTO cje_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kơyoa pơnuaĭ hơdiŭ c̆ơk-màng rơlau tơ phơ̆n 'bơ̆ng, sơ̆ng rùp-phàp c̆ơk-màng rơlau tơ phơ̆n c̆ù. ");
INSERT INTO cje_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","C̆ơ bĕ jơi c̆ĭm ạ: Guñu 'buh drà, 'buh yuă, kŭng 'buh hũ sàng halài anih pioh phơ̆n-bơna, nư̆n bloh Yàng Pô Lơngì sơđaŭ ròng guñu. Buơl guhã dò c̆ơk-màng rơlau jơi c̆ĭm la thơu hơdùm! ");
INSERT INTO cje_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Hũ aràng sơi lăm buơl guhã, gơnừm tơ sơnư̆ng kơ-ù, bloh ngă tơ rài hơdiŭ drơi hũ atàh rơlau sa-sĭt tŭ rơi? ");
INSERT INTO cje_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Yơu nư̆n, yah buơl guhã 'buh rơgơi ngă jiơ̆ng sa bruă tìt yơu nư̆n, kơđa hơgĕ buơl guhã păl sơnư̆ng kơ-ù mư̆ng du bruă pơkơ̆n? ");
INSERT INTO cje_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","C̆ơ bĕ jơi bơnga lăm 'blàng tơmuh tơgồ hơyơu lơi: Guñu 'buh ngă bruă gleh-glăr, kŭng 'buh kơtŭng mơrài; bloh Kơu đờm sơ̆ng buơl guhã, yah pơtau Salômôn màng gơn-hư̆p truh kàr lơi, kŭng 'buh hũ c̆ù mơkrư yơu sa bơnga lơi lăm du bơnga nư̆n ơu. ");
INSERT INTO cje_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ơ du mơnih tơkì pơnuaĭ păng-tui, yah jơi bơnga-rơ̆, la jơi hơrơi ni dò hơdiŭ lăm 'blàng, bơgi prah lăm gìng apui, bloh Yàng Pô Lơngì dò brơi c̆ù mơkrư yơu nư̆n, tơ-ài la buơl guhã! ");
INSERT INTO cje_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Yơu nư̆n, buơl guhã juơi mĭt tui duah mư̆ng phơ̆n 'bơ̆ng, phơ̆n mơñŭm, kŭng juơi hũ hơtai-hơtiàn sơnư̆ng kơ-ù. ");
INSERT INTO cje_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kơyoa tơgrơ̆ pơnuaĭ nư̆n, du buơl làng agàh lăm dun-ya sơđaŭ jiăng tui duah, sơ̆ng Ama buơl guhã hũ thơu buơl guhã păl c̆àng du pơnuaĭ nư̆n bơjơ. ");
INSERT INTO cje_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Bloh păl tui duah bĕ lơgăr Yàng Pô Lơngì, nư̆n Pô rơŭ brơi pơtơ̆l tơgrơ̆ pơnuaĭ nư̆n tơ buơl guhã rơi. ");
INSERT INTO cje_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ơ tơrpuơl abo tìt, juơi huơĭ, kơyoa Ama buơl guhã hũ sờh hơtai-hơtiàn brơi Lơgăr Pô tơ buơl guhã bơjơ. ");
INSERT INTO cje_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Pơblơi bĕ phơ̆n-bơna drơi bloh ngă bruă siàm anĭt-dŏng mơnih pơkơ̆n. Sơgăp-rơc̆ăng bĕ tơ drơi du kơdŭng priă 'buh tơrhĕt hơluh, sơ̆ng phơ̆n c̆ơk-màng 'buh siơŭ-lơhiă dò tơ ngŏ lơngì, la anih mơnih klĕ 'buh truh jĕ jiơ̆ng, mŏ hơlă 'buh ngă brŭ-lơhiă jiơ̆ng. ");
INSERT INTO cje_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kơyoa phơ̆n-bơna buơl guhã dò anih lơi, nư̆n hơtai-hơtiàn buơl guhã kŭng dò anih nư̆n rơi. ");
INSERT INTO cje_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Păl rơc̆ăng lờih tô duh bruă, kơ-iăng buơl guhã păl akă wơ̆, apui-đèng buơl guhã păl tuĭ sơrdah. ");
INSERT INTO cje_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Buơl guhã păl ngă yơu du mơnih dò kraŭ-c̆àng pô drơi mư̆ng anih mơñŭm 'bơ̆ng khiăng-gơŭ mơrai wơ̆, tô tŭ mơnih pô mơrai truh sơ̆ng tơtoh bơh 'băng, nư̆n pơh mư. ");
INSERT INTO cje_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Lơngai-pơtuah tơ du mơnih hơlŭn-hơlă nư̆n, tŭ mơnih pô mơrai wơ̆ 'buh buơl guñu dò mơdơh-kraŭ! Iơŭ biă Kơu đờm sơ̆ng buơl guhã, mơnih pô rơŭ akă ào drơi tơ kơ-iăng, pơđăr du mơnih hơlŭn-hơlă nư̆n dò guh lăm anih c̆ơnừng 'bơ̆ng, sơ̆ng truh bloh duh bruă buơl guñu. ");
INSERT INTO cje_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Yah tŭ mơtưh mơlăm halài kơjĕ sơrdah, mơnih pô gài mơrai wơ̆ sơ̆ng 'buh buơl guñu dò mơdơh-kraŭ, nư̆n lơngai-pơtuah biă tơ buơl guñu. ");
INSERT INTO cje_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Buơl guhã thơu bĕ pơnuaĭ ni: Yah mơnih pô sàng thơu dơlhơu mơnih klĕ rơŭ truh jơ lơi, nư̆n rơŭ mơdơh-kraŭ, 'buh luơi mơnih klĕ tơma iờp lăm sàng drơi ơu. ");
INSERT INTO cje_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Buơl guhã kŭng yơu nư̆n rơi, păl rơc̆ăng lờih bĕ, kơyoa Anà Mơnih rơŭ truh lăm tŭ jơ buơl guhã 'buh sơnư̆ng thơu.” ");
INSERT INTO cje_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pier tơnia: “Khoai Yàng, Yàng đờm pơnuaĭ pơgăp-pơmơyơu ni tơ buơl dơlhă halài tơ abih tơgrơ̆ mơnih?” ");
INSERT INTO cje_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Yàng đờm: “Aràng sơi la mơnih c̆ơ apăn-akŏ bruă sàng jak-khờh sơ̆ng dơlhơu-hơdơi tơpă sa hơtai-hơtiàn, hũ mơnih pô jào c̆ơ-apăn abih bruă sàng-dơnò drơi, tô brơi pơrpha phơ̆n-kơya 'bơ̆ng iơŭ jơ iơŭ tŭ? ");
INSERT INTO cje_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Lơngai-pơtuah tơ mơnih hơlŭn-hơlă nư̆n tŭ mơnih pô mơrai wơ̆ 'buh ngă iơŭ yơu nư̆n! ");
INSERT INTO cje_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Iơŭ biă Kơu đờm sơ̆ng buơl guhã, mơnih pô rơŭ jào tơ mơnih hơlŭn-hơlă nư̆n c̆ơ-apăn abih phŭm-kơsai phơ̆n-bơna drơi. ");
INSERT INTO cje_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Bloh yah mơnih hơlŭn-hơlă nư̆n sơnư̆ng lăm hơtai-hơtiàn lài: ‘Pô kơu ka mơrai wơ̆ mư ơu,’ bloh nư̆n kừ ngă pờng du hơlŭn kơmơi hơlŭn lơkơi, sơ̆ng mơñŭm 'bơ̆ng mơbŭ-mơbèng. ");
INSERT INTO cje_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Pô ñu rơŭ truh lăm hơrơi ñu 'buh sơnư̆ng truh, lăm jơ ñu 'buh thơu; mă hwai glih tơrhĕt kơlì ñu, sơ̆ng mă pơtơma ñu găm sơ̆ng du mơnih dơlhơu-hơdơi 'buh tơpă sa hơtai-hơtiàn. ");
INSERT INTO cje_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Mơnih hơlŭn-hơlă lơi thơu hơtai-khiăng mơnih pô drơi bloh 'buh rơc̆ăng kraŭ lờih sơ̆ng 'buh ngă tui hơtai mơnih pô khiăng, nư̆n rơŭ kơđòng glih pờng lô. ");
INSERT INTO cje_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Bloh mơnih hơlŭn-hơlă lơi 'buh thơu hơtai-khiăng mơnih pô, bloh ngă tơgrơ̆ bruă iơŭ păl kŏng ngă glài, nư̆n rơŭ kơđòng ngă glài sơ-uơ̆l rơlau. Kơyoa aràng sơi hũ brơi lô, nư̆n rơŭ kŏng đồ wơ̆ lô; sơ̆ng aràng sơi hũ jào lô, nư̆n rơŭ kŏng đồ wơ̆ lô rơlau.” ");
INSERT INTO cje_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Kơu hũ truh tô prah apui trŭn lăm lơ̆n. Yah apui gùh 'bơ̆ng bơjơ, Kơu dò eh-uăn hơgĕ wơ̆! ");
INSERT INTO cje_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Hũ sa pơnuaĭ 'baptem bloh Kơu păl kŏng, sơ̆ng Kơu pơđì-pơđoa thơu hơdùm tơ̆l truh tơ tŭ bruă nư̆n hũ wĭl-tơ̆l! ");
INSERT INTO cje_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Buơl guhã sơnư̆ng Kơu truh tô apăn pơnuaĭ rĭng-lơngai tơ dun-ya? Kơu đờm sơ̆ng buơl guhã, 'buh iơŭ ơu, bloh la apăn pơnuaĭ pơc̆ơrlah krơi. ");
INSERT INTO cje_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kơyoa mư̆ng ni, lơma aràng mơnih dò lăm sa boh sàng sơ̆ng gơŭ, rơŭ pơc̆ơrlah krơi gơŭ, klơu aràng tămdră-wơ̆ sơ̆ng dua, dua aràng tămdră-wơ̆ sơ̆ng klơu. ");
INSERT INTO cje_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Buơl guñu rơŭ pơc̆ơrlah krơi gơŭ: Ama tămdră-wơ̆ sơ̆ng anà lơkơi, anà lơkơi tămdră-wơ̆ sơ̆ng ama; ame tămdră-wơ̆ sơ̆ng anà kơmơi, anà kơmơi tămdră-wơ̆ sơ̆ng ame; ame tămhã tămdră-wơ̆ sơ̆ng mơrtơu-kơmơi, mơrtơu-kơmơi tămdră-wơ̆ sơ̆ng ame tămhã.” ");
INSERT INTO cje_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yàng Jêsu kŭng đờm sơ̆ng tơrpuơl buơl làng lài: “Tŭ buơl guhã 'buh puk hwăl đì tơgồ gah ia-hơrơi tơma, buơl guhã đờm mư: ‘Rơŭ hũ hơjàn,’ nư̆n biă hũ yơu nư̆n. ");
INSERT INTO cje_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Tŭ buơl guhã 'buh rơbù gah yù blùh truh, buơl guhã đờm: ‘Lơngì rơŭ pơ-uh kluơĭ,’ nư̆n biă hũ yơu nư̆n. ");
INSERT INTO cje_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ơ du mơnih hơtai-hơtiàn mơthĭ-lơ̆r! Buơl guhã khờh biă kràn-kơnăl nàl glai-glo lơngì-tơnah, yơu nư̆n kơđa hơgĕ 'buh thơu kràn-kơnăl tŭ-rài ni? ");
INSERT INTO cje_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Kơđa hơgĕ buơl guhã kŭng 'buh mư̆ng rùp-phŭn drơi c̆ơ-sơnư̆ng pơnuaĭ hơgĕ la iơŭ? ");
INSERT INTO cje_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Tŭ hã nau sơ̆ng mơnih yă bă hã truh tơ anaŭ kwăng c̆ahrơña, lăm jơlàn nau, nư̆n abih pràn-hơtai pơhơlàr-tămsòr bĕ sơ̆ng buơl guñu, juơi luơi buơl guñu hua hã truh tơ anaŭ kwăng c̆ahrơña, kwăng c̆ahrơña jào hã tơ mơnih apăn-akŏ sàng jàm, sơ̆ng mơnih apăn-akŏ sàng jàm rơŭ pơtơma hã lăm sàng jàm. ");
INSERT INTO cje_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Kơu đờm sơ̆ng hã, hã rơŭ 'buh tơbiă klàh mư̆ng jàm jiơ̆ng tơ̆l truh tŭ bơ-yàr abih sa đŏng priă sre luĭ-dŭt.” ");
INSERT INTO cje_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Lăm tŭ nư̆n, hũ du mơnih tơ anih nư̆n đờm akhàn wơ̆ tơ Yàng Jêsu păng mư̆ng bruă Pilat pơmơtai du mơnih Galile, bloh nư̆n mă drah buơl guñu jrơu sơgơŭ sơ̆ng phơ̆n c̆ĕ-pơyơ̆r duh-dơlbăt buơl guñu pơyă. ");
INSERT INTO cje_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yàng Jêsu đờm lài: “Buơl guhã sơnư̆ng du mơnih Galile ni păl kŏng yơu nư̆n la kơyoa glài-sơnoh buơl guñu traŭ rơlau tơ du mơnih Galile pơkơ̆n? ");
INSERT INTO cje_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Kơu đờm sơ̆ng buơl guhã, 'buh iơŭ ơu; bloh yah buơl guhã 'buh mơbai prah-luơi glài-sơnoh, nư̆n abih buơl guhã kŭng rơŭ kơđòng mơtai-lơhiă yơu nư̆n rơi. ");
INSERT INTO cje_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Halài sa-pluh tơlpăn aràng mơnih kơđòng rơñàn Silôe tơ-glŭng kơtơ̆ mơtai dih, buơl guhã sơnư̆ng du mơnih nư̆n glài-sơnoh rơlau tơ du mơnih pơkơ̆n lăm plơi-prŏng Jerusalem? ");
INSERT INTO cje_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Kơu đờm tơ buơl guhã thơu: 'buh iơŭ yơu nư̆n ơu; bloh yah buơl guhã 'buh khiăng mơbai prah-luơi glài-sơnoh, nư̆n abih buơl guhã kŭng rơŭ kŏng mơtai-lơhiă yơu nư̆n rơi.” ");
INSERT INTO cje_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yàng Jêsu đờm pơnuaĭ pơgăp-pơmơyơu ni: “Sa aràng mơnih dih pla sa phŭn kơyơu hra lăm apùh ño drơi. Mơnih nư̆n truh pĕ boh, bloh 'buh hũ boh lơi. ");
INSERT INTO cje_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Nư̆n ñu đờm sơ̆ng mơnih ngă apùh: ‘Sơ-ai c̆ơ, klơu thŭn ni bơjơ kơu truh pĕ boh anih kơyơu hra ni bloh 'buh hũ boh lơi. Dròm ñu bĕ, luơi ngă hơgĕ tô gơniă lơ̆n?’ ");
INSERT INTO cje_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Bloh mơnih ngă apùh đờm: ‘Ơ pô, yòng pô luơi ñu dò sa thŭn ni tra. Dơlhă rơŭ klơi lơ̆n tòmdăr phŭn ñu sơ̆ng tuh phơ̆ng tơ ñu. ");
INSERT INTO cje_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Hũ rơgơi hơdơi ni ñu rơŭ tơbiă boh; yah 'buh ơu nư̆n, pô rơŭ dròm.’ ” ");
INSERT INTO cje_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sa hơrơi sa'bat dih, Yàng Jêsu dò pơto-mơblàng lăm sa boh sàng pơtòm. ");
INSERT INTO cje_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Tơ anih nư̆n, hũ sa aràng mơnih kơmơi kơđòng kơmlài ngă, păl kŏng pơnuaĭ lơ-ơ̆n lơngoh rơwă-sơkì lăm sa-pluh tơlpăn thŭn, kơ-iăng kwĕt trŭn tơ ala, 'buh rơgơi dò dơ̆ng tơpă jiơ̆ng. ");
INSERT INTO cje_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Tŭ 'buh mơnih kơmơi nư̆n, Yàng Jêsu iơu ñu mơrai truh sơ̆ng đờm: “Ơ anà, anà hũ tơleh-pơklàh mư̆ng pơnuaĭ lơ-ơ̆n lơngoh rơwă-sơkì bơjơ!” ");
INSERT INTO cje_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Sơ̆ng Pô daŭ tơngàn tơ ngŏ ñu. Lăm tơk tŭ nư̆n mư, ñu dò dơ̆ng tơpă jiơ̆ng, sơ̆ng adoh-mơyòm Yàng Pô Lơngì. ");
INSERT INTO cje_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Bloh mơnih c̆ơ-apăn sàng pơtòm anok hơtai kơyoa 'buh Yàng Jêsu pơsồ-pơsaih lơ-ơ̆n lơngoh rơwă-sơkì lăm hơrơi sa'bat. Ñu đờm sơ̆ng tơrpuơl mơnih lô: “Hũ năm hơrơi tô ngă bruă. Khiăng hũ pơsồ-pơsaih lơ-ơ̆n lơngoh rơwă-sơkì nư̆n truh bĕ lăm du hơrơi nư̆n, juơi truh lăm hơrơi sa'bat.” ");
INSERT INTO cje_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Bloh Yàng đờm: “Ơ du mơnih hơtai-hơtiàn mơthĭ-lơ̆r! Hũ aràng sơi lăm buơl guhã, hơrơi sa'bat, 'buh tơleh tơlơi tơ lơmo halài phơ̆n pà gah tơkai drơi tơbiă mư̆ng bòng rơ̆, tô dùi ñu nau mơñŭm ia ơu? ");
INSERT INTO cje_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Tơ-ài la mơnih kơmơi bloh Kơu hũ pơsồ-pơsaih ni la anà-tơc̆o Abraham, hũ kŏng Satăn akă-pơkơŭ lăm luĭ sa-pluh tơlpăn thŭn, bloh lài 'buh rơgơi tơleh-pơklàh tơ ñu lăm hơrơi sa'bat ơu?” ");
INSERT INTO cje_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Tŭ Pô đờm yơu nư̆n, abih tơgrơ̆ mơnih tămdră sơ̆ng Pô mă ngă mơlơu alah biă, sơ̆ng abih buơl làng nư̆n sờh-sài kơyoa mư̆ng du bruă c̆rih-krơi Pô hũ ngă. ");
INSERT INTO cje_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Nư̆n, Yàng Jêsu đờm: “Lơgăr Yàng Pô Lơngì mơhiơ̆ yơu hơgĕ? Kơu păl pơc̆àu-pơmơyơu lơgăr nư̆n sơ̆ng hơgĕ? ");
INSERT INTO cje_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Lơgăr Yàng Pô Lơngì mơhiơ̆ yơu sa găr sơbơi mơnih dih mă dơnih lăm apùh drơi. Ñu tơmuh tơgồ sơ̆ng tơbiă jiơ̆ng yơu sa phŭn kơyơu, c̆ĭm lơngì truh ngă sruh lăm thàn ñu jiơ̆ng.” ");
INSERT INTO cje_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Pô đờm wơ̆: “Kơu păl pơc̆àu-pơmơyơu lơgăr Yàng Pô Lơngì sơ̆ng hơgĕ? ");
INSERT INTO cje_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Lơgăr Yàng Pô Lơngì mơhiơ̆ yơu tơpơi bloh mơnih kơmơi dih mă apăn jrơu lăm klơu thĕ tơpŭng, tơ̆l truh tơ tŭ tơpŭng rồ đì abih.” ");
INSERT INTO cje_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Lăm jơlàn đì nau tơ Jerusalem, Yàng Jêsu nau găn du plơi-prŏng plơi tìt, pơto-mơblàng tơ buơl làng. ");
INSERT INTO cje_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Hũ mơnih đờm sơ̆ng Pô: “Khoai Yàng, mĭn sa-sĭt mơnih soh hũ dŏng-pơklàh, iơŭ rơi?” ");
INSERT INTO cje_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Pô đờm sơ̆ng buơl guñu: “Păl abih pràn-hơtai tô tơma lăm bơh 'băng gơniă, kơyoa, Kơu đờm sơ̆ng buơl guhã, lô mơnih rơŭ duah ngă hơyơu tô tơma lăm nư̆n bloh 'buh tơma jiơ̆ng. ");
INSERT INTO cje_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Tŭ mơnih pô sàng tơgồ sơ̆ng kăl krơ̆ bơh 'băng bơjơ, buơl guhã dò tơ agàh tơtoh bơh 'băng sơ̆ng đờm: ‘Khoai Yàng, yòng pơh tơ buơl dơlhă!’ Mơnih pô rơŭ đờm sơđồ: ‘Kơu 'buh thơu buơl guhã mư̆ng lơi truh!’ ");
INSERT INTO cje_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Tŭ nư̆n buơl guhã rơŭ đờm: ‘Buơl dơlhă hũ 'bơ̆ng sơ̆ng mơñŭm tơ anaŭ Yàng, sơ̆ng Yàng hũ pơto-mơblàng lăm du jơlàn-rơya buơl dơlhă.’ ");
INSERT INTO cje_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Bloh mơnih Pô rơŭ đờm sơ̆ng buơl guhã: ‘Kơu 'buh thơu buơl guhã truh mư̆ng lơi! Ơ abih du mơnih ngă pơnuaĭ mơsak-jơhà dih, nau bĕ tô tơrđơŭ thĭt mư̆ng mơta Kơu!’ ");
INSERT INTO cje_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Tŭ nư̆n, buơl guhã rơŭ 'buh Abraham, Isak, Jakôp, găm sơ̆ng abih du mơnih gơnuăr-hwơ̆r dò lăm lơgăr Yàng Pô Lơngì, dò buơl guhã nư̆n rơŭ kơđòng prah tơ agàh, la anih hũ hia-c̆ŏ sơ̆ng kĕ tơgơi. ");
INSERT INTO cje_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Lô mơnih mư̆ng gah ia-hơrơi tơbiă, gah ia-hơrơi tơma, gah yù, gah ngŏ, rơŭ truh dò guh huă 'bơ̆ng lăm pơnuaĭ pơjŭm 'bơ̆ng prŏng lăm lơgăr Yàng Pô Lơngì. ");
INSERT INTO cje_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Biă yơu nư̆n, hũ du mơnih tŭ ni aràng c̆ơ la 'buh prŏng-màng, hơdơi ni rơŭ tơbiă jiơ̆ng du mơnih prŏng-màng biă sơ̆ng Yàng Pô Lơngì, dò du mơnih tŭ ni hũ aràng c̆ơ la prŏng-màng, hơdơi ni rơŭ 'buh hũ Yàng Pô Lơngì c̆ơ la prŏng-màng.” ");
INSERT INTO cje_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Kŭng lăm tŭ nư̆n, hũ du mơnih Pharisi truh đờm sơ̆ng Yàng Jêsu: “Pô-Pơto păl nau klàh bĕ mư̆ng anih ni, kơyoa pơtau Herôt khiăng pơmơtai Pô-Pơto.” ");
INSERT INTO cje_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Pô đờm sơ̆ng buơl guñu: “Nau đờm bĕ sơ̆ng anà mơja nư̆n lài: ‘Hơrơi ni, hơrơi bơgi, Kơu pơtrơh kơmlài sơ̆ng pơsồ-pơsaih lơ-ơ̆n lơngoh rơwă-sơkì, truh hơrơi klơu Kơu rơŭ ngă wĭl-tơ̆l gơnuăr-bruă Kơu. ");
INSERT INTO cje_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Bloh hơrơi ni, hơrơi bơgi, sơ̆ng hơrơi kơdih Kơu păl nau, kơyoa sa aràng mơnih gơnuăr-hwơ̆r 'buh rơgơi mơtai tơ agàh plơi-prŏng Jerusalem jiơ̆ng.’ ” ");
INSERT INTO cje_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Ơ Jerusalem, Jerusalem! Hã pơmơtai du mơnih gơnuăr-hwơ̆r sơ̆ng prah pơtơu pơmơtai du mơnih hũ pơđăr truh sơ̆ng hã! Lô amăng bơjơ Kơu khiăng tơrgùm-pơtòm anà-tơc̆o hã, yơu mơnŭ ơna pơkruk iơu anà drơi tơma lăm ala siạu, bloh buơl guhã 'buh khiăng! ");
INSERT INTO cje_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ni, sàng buơl guhã rơŭ kơđòng luơi jơhua. Kơu đờm sơ̆ng buơl guhã, buơl guhã rơŭ 'buh dò 'buh Kơu tra tơ̆l truh tơ tŭ buơl guhã đờm lài: Lơngai-pơtuah tơ Pô mă angăn Yàng bloh truh!” ");
INSERT INTO cje_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sa hơrơi sa'bat dih, Yàng Jêsu truh sàng sa aràng mơnih apăn-akŏ lăm tơrpuơl Pharisi tô huă 'bơ̆ng. Du mơnih dò tơ anih nư̆n kraŭ c̆ơ Pô. ");
INSERT INTO cje_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Tŭ nư̆n, hũ sa aràng mơnih lơ-ơ̆n jiơ̆ng pŭ dò dơ̆ng tơ anaŭ Pô. ");
INSERT INTO cje_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yàng Jêsu tơnia du mơnih gơnuăr-pơto pơnuaĭ adăt-adia sơ̆ng du mơnih Pharisi lài: “Lăm hơrơi sa'bat hũ gơnuăr pơsồ-pơsaih lơ-ơ̆n lơngoh rơwă-sơkì ơu?” ");
INSERT INTO cje_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Bloh abih buơl guñu dò kơđơ̆ng. Pô apăn tơ tơngàn mơnih lơ-ơ̆n, pơsồ-pơsaih tơ ñu, bloh nư̆n brơi ñu nau wơ̆. ");
INSERT INTO cje_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Pô đờm sơ̆ng buơl guñu: “Aràng sơi lăm buơl guhã, pă iơŭ hơrơi sa'bat, hũ anà lơkơi halài anà lơmo drơi lĕ lăm ia bơmŭn, bloh 'buh lăm tơk kơtŭng ñu đì mư ơu?” ");
INSERT INTO cje_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Buơl guñu 'buh rơgơi đờm sơđồ hơgĕ jiơ̆ng mư̆ng pơnuaĭ nư̆n. ");
INSERT INTO cje_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Tŭ 'buh du mơnih thuai hũ aràng jà truh huă 'bơ̆ng, aràng sơi aràng nư̆n kŭng rơwah anih màng-glòng soh bloh dò guh, nư̆n Yàng Jêsu đờm sơ̆ng buơl guñu pơnuaĭ pơgăp-pơmơyơu ni: ");
INSERT INTO cje_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Tŭ hã hũ aràng jà truh mơñŭm 'bơ̆ng khiăng-gơŭ, nư̆n juơi dò guh tơ anih màng-glòng, huơĭ lài lăm du mơnih thuai hũ pô sàng jà truh pơjŭm 'bơ̆ng hũ mơnih prŏng-màng rơlau tơ hã, ");
INSERT INTO cje_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","bloh nư̆n mơnih pô sàng rơŭ truh đờm sơ̆ng hã: ‘Yòng sơ-ai luơi anih tơ mơnih ni dò guh!’ tŭ nư̆n hã rơŭ mơlơu alah kơyoa păl trŭn dò guh tơ anih luĭ-dŭt. ");
INSERT INTO cje_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Bloh tŭ hã hũ aràng jà truh mơñŭm 'bơ̆ng, nư̆n rơwah bĕ du anih tơluĭ bloh dò guh, tô tŭ mơnih pô hũ jà hã mơñŭm 'bơ̆ng truh đờm sơ̆ng hã: ‘Ơ mơnih adơi-ai gơŭ, yòng jà đì dò guh tơ anih glòng ni.’ Tŭ nư̆n, hã rơŭ hũ c̆ơ prŏng-màng tơ anaŭ du mơnih thuai dò guh lăm anih c̆ơnừng huă 'bơ̆ng găm sơ̆ng drơi. ");
INSERT INTO cje_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Kơyoa aràng sơi pồ pơglòng rùp-phŭn drơi đì, rơŭ păl kŏng pơtrŭn; dò aràng sơi pơ-ơneh rùp-phŭn drơi trŭn, rơŭ hũ pồ pơglòng.” ");
INSERT INTO cje_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yàng Jêsu kŭng đờm sơ̆ng mơnih hũ jà Pô lài: “Tŭ hã jà aràng sơi truh huă 'bơ̆ng jơla halài huă 'bơ̆ng mơlăm, nư̆n juơi jà mơnih adơi-ai gơŭ, adơi-ai phŭn, gơŭ-pơtiàn halài mơnih gơŭ-plơi mơda gơn-hư̆p, huơĭ lài buơl guñu kŭng rơŭ jà hã wơ̆ tô bơ-yàr c̆iŭ pơnuaĭ hã hũ jà buơl guñu. ");
INSERT INTO cje_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Bloh tŭ hã pồ pơnuaĭ huă 'bơ̆ng, nư̆n jà bĕ du mơnih rơ'bah rơ'bừp, mơnih joh-je, mơnih kwĕt-kơlte, mơnih bồm mơsrư̆, ");
INSERT INTO cje_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","nư̆n hã rơŭ hũ lơngai-pơtuah, kơyoa buơl guñu 'buh hũ hơgĕ tô jà bơ-yàr wơ̆; sơ̆ng truh hơrơi mơnih rĭng-tơpă hơdiŭ wơ̆, hã rơŭ hũ bơ-yàr wơ̆.” ");
INSERT INTO cje_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Sa aràng mơnih thuai dò guh lăm anih c̆ơnừng 'bơ̆ng găm sơ̆ng Yàng Jêsu, păng du pơnuaĭ ni, nư̆n đờm sơ̆ng Pô: “Lơngai-pơtuah tơ mơnih lơi hũ tơma lăm pơnuaĭ huă 'bơ̆ng prŏng lăm lơgăr Yàng Pô Lơngì!” ");
INSERT INTO cje_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yàng Jêsu đờm: “Sa aràng mơnih dih pồ sa pơnuaĭ huă 'bơ̆ng prŏng, sơ̆ng hũ jà lô mơnih truh huă 'bơ̆ng. ");
INSERT INTO cje_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Tŭ truh jơ 'bơ̆ng, ñu pơđăr mơnih hơlŭn-hơlă drơi nau truh đờm sơ̆ng du mơnih hũ jà lài: ‘Jà truh bĕ, kơyoa abih tơgrơ̆ mơta hũ rơc̆ăng lờih bơjơ.’ ");
INSERT INTO cje_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Bloh abih buơl guñu sa pơnuaĭ đờm yòng lơkơu drơi. Mơnih c̆ơmrừp đờm: ‘Dơlhă hũ blơi sa bĭ hơma, nư̆n păl nau c̆ơ. Yòng brơi dơlhă lơkơu drơi.’ ");
INSERT INTO cje_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Mơnih pơkơ̆n đờm: ‘Dơlhă pơrpa blơi lơma yơu lơmo, nư̆n dơlhă păl nau c̆ơ. Yòng brơi dơlhă lơkơu drơi.’ ");
INSERT INTO cje_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Mơnih pơkơ̆n wơ̆ đờm: ‘Dơlhă pơrpa khiăng kơmơi, kơyoa nư̆n, dơlhă 'buh rơgơi truh jiơ̆ng.’ ");
INSERT INTO cje_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Mơnih hơlŭn-hơlă gài mơrai wơ̆, đờm akhàn wơ̆ bruă nư̆n sơ̆ng mơnih pô drơi. Mơnih pô anok hơtai, pơđăr mơnih hơlŭn-hơlă: ‘Nau sơmăr bĕ, truh tơ du jơlàn-rơya sơ̆ng du jơlàn lăm plơi-prŏng, ba du mơnih rơ'bah rơ'bừp, mơnih joh-je, mơnih bồm mơsrư̆, mơnih kwĕt-kơlte, truh tơ anih ni.’ ");
INSERT INTO cje_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Mơnih hơlŭn-hơlă đờm: ‘Ơ pô, bruă pô pơđăr, buơl dơlhă hũ ngă bơjơ, bloh sơđaŭ dò dơlah anih.’ ");
INSERT INTO cje_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Nư̆n mơnih pô sàng đờm pơđăr mơnih hơlŭn-hơlă: ‘Tơbiă bĕ tơ agàh du jơlàn prŏng sơ̆ng rò gah bơga, păp aràng sơi nư̆n pơkơŭ jà tơma, tô baŭ sàng kơu. ");
INSERT INTO cje_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Kơyoa kơu đờm sơ̆ng buơl guhã, lăm abih tơgrơ̆ mơnih hũ jà dơlhơu, rơŭ 'buh sa aràng mơnih lơi hũ tiăm sa-sĭt hơgĕ lăm pơnuaĭ pồ 'bơ̆ng prŏng kơu ơu.’ ” ");
INSERT INTO cje_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Hũ tơrpuơl buơl làng lô nau găm sơ̆ng Yàng Jêsu. Pô pơtrah wơ̆, đờm sơ̆ng buơl guñu: ");
INSERT INTO cje_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Yah aràng sơi truh tui Kơu bloh rơnăm tơ ame ama, sơdiŭ anà, adơi-ai, gơŭ kơmơi, sơ̆ng pơnuaĭ hơdiŭ rùp-phŭn drơi rơlau tơ Kơu, nư̆n 'buh rơgơi ngă mơnih tui-mơgru Kơu jiơ̆ng. ");
INSERT INTO cje_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Aràng sơi 'buh glăm kơyơu pơkăl drơi bloh tui Kơu, kŭng 'buh rơgơi ngă mơnih tui-mơgru Kơu. ");
INSERT INTO cje_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Aràng sơi lăm buơl guhã khiăng bơ̆-ngă sa boh sàng glòng, bloh dơlhơu biă 'buh dò guh khi-kơrhia tô c̆ơ thơu drơi hũ tơ̆l priă ngă truh wĭl-tơ̆l bruă nư̆n ơu? ");
INSERT INTO cje_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Yah 'buh ơu nư̆n, tŭ hũ bơ̆-ngă rơnơ̆ bơjơ, bloh nư̆n 'buh rơgơi ngă truh wĭl-tơ̆l jiơ̆ng, nư̆n tơgrơ̆ mơnih 'buh, rơŭ klau-pơtăt, ");
INSERT INTO cje_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","sơ̆ng đờm lài: ‘Mơnih ni hũ bơ̆-ngă, bloh 'buh rơgơi ngă truh wĭl-tơ̆l jiơ̆ng!’ ");
INSERT INTO cje_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Halài hũ pơtau lơi ba lĭng nau tămngă sơ̆ng pơtau pơkơ̆n, bloh dơlhơu biă 'buh dò guh sơnư̆ng bơyai c̆ơ, drơi apăn nau sa-pluh rơbơu lĭng hũ rơgơi tămngă jai sơ̆ng pơtau dih apăn dua pluh rơbơu lĭng ơu? ");
INSERT INTO cje_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Yah bơyai c̆ơ 'buh tămngă jai, nư̆n tŭ pơtau dih sơđaŭ dò atàh, pơđăr bĕ mơnih drơi truh yòng pơhơlàr-tămsòr. ");
INSERT INTO cje_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Yơu nư̆n, yah aràng sơi lăm buơl guhã 'buh prah luơi abih tơgrơ̆ hơgĕ drơi hũ, nư̆n 'buh rơgơi ngă mơnih tui-mơgru Kơu jiơ̆ng. ");
INSERT INTO cje_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Sra la phơ̆n siàm, bloh yah sra lơhiă kơya 'bă, nư̆n mă hơgĕ ngă tơ ñu 'bă wơ̆ jiơ̆ng? ");
INSERT INTO cje_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Sra nư̆n 'buh rơgơi angui tô daŭ lăm hơma halài tô jrơu ngă phơ̆ng jiơ̆ng tra, aràng păl prah ñu tơbiă tơ agàh. Aràng sơi hũ tơnia tô păng, nư̆n păng bĕ!” ");
INSERT INTO cje_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Tŭ nư̆n, abih du mơnih rì-mă jia sơ̆ng du mơnih glài-sơnoh truh jĕ tô păng Yàng Jêsu pơto-mơblàng. ");
INSERT INTO cje_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Du mơnih Pharisi sơ̆ng du mơnih gơnuăr-pơto pơnuaĭ adăt-adia đờm yuăm lài: “Mơnih ni wă-rò du mơnih glài-sơnoh sơ̆ng huă 'bơ̆ng sơ̆ng guñu!” ");
INSERT INTO cje_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Kơyoa nư̆n, Pô đờm sơ̆ng buơl guñu pơnuaĭ pơgăp-pơmơyơu ni: ");
INSERT INTO cje_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Aràng sơi lăm buơl guhã hũ sa rơtùh drơi abo, yah lơhiă sa drơi, bloh 'buh luơi sơlpăn pluh sơlpăn drơi abo dih lăm anih 'blàng-jơhua, tô nau duah gơhũ abo c̆ơrlah lơhiă ơu? ");
INSERT INTO cje_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Tŭ duah hũ bơjơ, nư̆n sờh-sài glăm ñu tơ ngŏ bra. ");
INSERT INTO cje_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Sơ̆ng tŭ mơrai wơ̆ truh sàng, mơnih nư̆n iơu jà du mơnih adơi-ai gơŭ sơ̆ng mơnih gơŭ-plơi truh bloh đờm: ‘Sờh-sài bĕ sơ̆ng dơlhă, kơyoa dơlhă hũ duah hũ abo c̆ơrlah lơhiă.’ ");
INSERT INTO cje_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Kŭng yơu nư̆n rơi, Kơu đờm sơ̆ng buơl guhã, tơ ngŏ lơngì rơŭ sờh-sài mư̆ng sa aràng mơnih glài-sơnoh thơu mơbai prah-luơi glài-sơnoh, rơlau la sơlpăn pluh sơlpăn aràng mơnih rĭng-tơpă 'buh c̆àng păl mơbai prah-luơi glài-sơnoh. ");
INSERT INTO cje_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Halài, hũ mơnih kơmơi lơi hũ sa-pluh boh priă, yah lơhiă sa boh, bloh 'buh tuĭ apui đèng, bah sàng, sơ̆ng duah nĭ-nùn gơhũ boh priă lơhiă ơu? ");
INSERT INTO cje_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Tŭ duah hũ bơjơ, ñu iơu jà du mơnih adơi-ai gơŭ sơ̆ng mơnih gơŭ-plơi truh bloh đờm: ‘Sờh-sài bĕ sơ̆ng dơlhă, kơyoa dơlhă hũ duah 'buh boh priă lơhiă.’ ");
INSERT INTO cje_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Kŭng yơu nư̆n rơi, Kơu đờm sơ̆ng buơl guhã, du mơnih gơdrưh Yàng Pô Lơngì rơŭ sờh-sài mư̆ng sa aràng mơnih hũ glài-sơnoh thơu mơbai prah-luơi glài-sơnoh.” ");
INSERT INTO cje_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yàng Jêsu đờm wơ̆: “Sa aràng mơnih dih hũ dua aràng anà lơkơi. ");
INSERT INTO cje_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Mơnih adơi đờm sơ̆ng ama: ‘Ơ ama, yòng pơrpha brơi tơ anà pơ-ơnah phŭm-kơsai phơ̆n-bơna bloh anà rơŭ hũ.’ Sơ̆ng mơnih ama hũ pơrpha phŭm-kơsai phơ̆n-bơna drơi tơ dua aràng anà. ");
INSERT INTO cje_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Du hơrơi hơdơi, mơnih adơi tơrgùm abih phŭm-kơsai phơ̆n-bơna drơi hũ, sơ̆ng nau truh tơ sa anih atàh. Dò tơ anih nư̆n, ñu 'bơ̆ng mơ-in lềng-làng, pròng-preh abih phơ̆n-priă drơi. ");
INSERT INTO cje_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Hơdơi tŭ 'bơ̆ng angui abih phơ̆n-priă drơi hũ bơjơ, lăm lơgăr nư̆n păp sa pơnuaĭ ờ-lơpa prŏng, sơ̆ng ñu tơbiă jiơ̆ng siơŭ rơ'bah biă. ");
INSERT INTO cje_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ñu păl nau ngă tồ-apah tơ sa aràng mơnih lăm lơgăr phŭn nư̆n. Mơnih nư̆n pơđăr ñu tơbiă tơ 'blàng glăng bơbui. ");
INSERT INTO cje_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ñu lơkơu khiăng biă hũ mă kơđuh rơtà bơbui 'bơ̆ng bloh 'bơ̆ng tô trơi, bloh 'buh aràng sơi brơi. ");
INSERT INTO cje_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Tŭ nư̆n ñu sơnư̆ng sơdơ̆r wơ̆ sơ̆ng đờm: ‘Lô mơnih ngă tồ-apah lăm sàng ama kơu hũ pah 'bơ̆ng dơlah-dơlài, bloh kơu tơ anih ni păl mơtai ờ! ");
INSERT INTO cje_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Kơu rơŭ tơgồ dơ̆ng, gài mơrai wơ̆ sơ̆ng ama kơu, bloh đờm: Ơ ama, anà hũ sŭng glài sơ̆ng Lơngì sơ̆ng ama, ");
INSERT INTO cje_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","'buh iơŭ păl tô hũ angăn la anà ama tra. Yòng ama c̆ơ anà yơu sa aràng mơnih ngă tồ-apah tơ ama rơi.’ ");
INSERT INTO cje_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Bloh nư̆n ñu tơgồ dơ̆ng, gài mơrai wơ̆ sơ̆ng ama drơi. Bloh tŭ dò mư̆ng atàh, mơnih ama 'buh ñu nư̆n hũ hơtai-hơtiàn anĭt-rơnăm, đuaĭ truh kwăr tơkuai ñu bloh c̆ŭm. ");
INSERT INTO cje_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Tŭ nư̆n mơnih anà đờm sơ̆ng ama: ‘Ơ ama, anà hũ ngă sŭng glài sơ̆ng Lơngì sơ̆ng ama, 'buh iơŭ păl tô hũ angăn la anà ama tra.’ ");
INSERT INTO cje_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Bloh mơnih ama đờm sơ̆ng du mơnih hơlŭn-hơlă: ‘Sơmăr-sơmăr bĕ, mă ào mơkrư-siàm rơlau abih pơc̆ù tơ ñu, pơbuh krah lăm tơngàn, pơjuă tơkhŏ lăm tơkai. ");
INSERT INTO cje_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Bloh nư̆n mă bĕ sa drơi anà lơmo lơmă ngă rơlo, tô buơl gudrơi mơñŭm 'bơ̆ng sờh-sài sơ̆ng gơŭ! ");
INSERT INTO cje_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kơyoa anà kơu ni hũ mơtai bơjơ bloh tŭ ni hơdiŭ wơ̆, hũ lơhiă bơjơ bloh tŭ ni duah hũ wơ̆.’ Bloh nư̆n buơl guñu tơma sờh-sài mơñŭm 'bơ̆ng. ");
INSERT INTO cje_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Tŭ nư̆n, mơnih anà lơkơi kơc̆oa dò tơ 'blàng hơma. Tŭ mơrai wơ̆ kơjĕ truh tơ sàng, ñu mơhư̆ săp kơñi pĕ sơ̆ng săp adoh mơya, ");
INSERT INTO cje_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","nư̆n ñu iơu sa aràng mơnih hơlŭn-hơlă truh sơ̆ng tơnia c̆ơ hũ bruă hơgĕ. ");
INSERT INTO cje_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Mơnih hơlŭn-hơlă đờm: ‘Adơi miă pơrpa mơrai wơ̆, sơ̆ng ama miă hũ ngă rơlo anà lơmo lơmă, kơyoa 'buh adơi miă mơrai wơ̆ hũ pràn lơngai.’ ");
INSERT INTO cje_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Mơnih sơ-ai kơc̆oa anok hơtai sơ̆ng 'buh khiăng tơma lăm sàng. Nư̆n mơnih ama nau tơbiă sơ̆ng đờm pơluơ-pơto ñu. ");
INSERT INTO cje_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Bloh ñu đờm sơ̆ng ama drơi: ‘Ama c̆ơ nư̆n, thơu hơdùm thŭn ni bơjơ anà dŏng duh bruă ama, sơ̆ng 'buh tŭ lơi ngă sŭng pơnuaĭ ama pơđăr, nư̆n bloh ama ka tŭ lơi brơi tơ anà sa drơi bơbe tìt tô anà 'bơ̆ng mơ-in sờh sơ̆ng buơl adơi-ai gơŭ. ");
INSERT INTO cje_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Bloh anà lơkơi ama dih, la mơnih hũ 'bơ̆ng mơ-in pròng-preh abih phơ̆n-priă ama sơ̆ng buơl kơmơi dri, tŭ ni ñu gài mơrai wơ̆, nư̆n ama kơyoa ñu bloh ngă rơlo anà lơmo lơmă tô sờh-sài mơñŭm 'bơ̆ng!’ ");
INSERT INTO cje_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Mơnih ama đờm: ‘Ơ anà, anà mĭt-mĭt dò sơ̆ng ama, abih tơgrơ̆ hơgĕ phơ̆n ama la phơ̆n anà. ");
INSERT INTO cje_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Bloh biă păl pồ pơnuaĭ mơñŭm 'bơ̆ng sơ̆ng sờh-sài, kơyoa adơi anà ni hũ mơtai bơjơ bloh ni hơdiŭ wơ̆, hũ lơhiă bơjơ bloh ni duah hũ wơ̆.’ ” ");
INSERT INTO cje_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Tŭ nư̆n Yàng Jêsu đờm sơ̆ng du mơnih tui-mơgru Pô: “Sa aràng mơnih mơda gơn-hư̆p dih hũ sa aràng mơnih c̆ơ apăn-akŏ bruă sàng; mơnih c̆ơ-apăn bruă sàng nư̆n hũ kơđòng aràng đờm yă la pròng-preh phơ̆n-priă mơnih pô. ");
INSERT INTO cje_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Nư̆n, mơnih pô iơu ñu truh sơ̆ng đờm: Bruă kơu hũ mơhư̆ aràng đờm yă mư̆ng hã la hơyơu? Đờm akhàn bĕ mư̆ng bruă c̆ơ apăn-akŏ bruă sàng hã tơ kơu c̆ơ, kơyoa mư̆ng ni hã 'buh hũ ngă mơnih c̆ơ apăn-akŏ bruă sàng tra. ");
INSERT INTO cje_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Mơnih c̆ơ apăn-akŏ bruă sàng sơnư̆ng lăm hơtai-hơtiàn: ‘Mơnih pô suă-mă gơnuăr bruă drơi bơjơ, drơi rơŭ ngă hơgĕ ni? C̆oh lơ̆n nư̆n drơi 'buh tơ̆l pràn, bloh nau yòng 'bơ̆ng nư̆n mơlơu mơta biă. ");
INSERT INTO cje_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Kơu thơu kơu păl ngă hơgĕ bơjơ, tô hơdơi tŭ lơhiă gơnuăr bruă, rơŭ hũ mơnih jà-rò kơu mơrai wơ̆ sàng buơl guñu.’ ");
INSERT INTO cje_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Yơu nư̆n, ñu iơu krơi yàu aràng mơnih kơđòng sre sơ̆ng mơnih pô drơi truh, sơ̆ng tơnia mơnih c̆ơmrừp lài: ‘Hã kơđòng sre sơ̆ng pô kơu hơdùm?’ ");
INSERT INTO cje_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Mơnih nư̆n đờm: ‘Sa rơtùh thŭng mơñà.’ Mơnih c̆ơ apăn-akŏ bruă sàng đờm: ‘Mă apăn bĕ bơ-àr sre, dò guh tơ anih nư̆n, wă sơmăr: Lơma pluh!’ ");
INSERT INTO cje_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Bloh nư̆n ñu tơnia mơnih pơkơ̆n: ‘Hã sre hơdùm?’ Mơnih nư̆n đờm: ‘Sa rơtùh yòt bơdai.’ Mơnih c̆ơ apăn-akŏ bruă sàng đờm: ‘Mă apăn bĕ bơ-àr sre sơ̆ng wă: Tơlpăn pluh yòt!’ ");
INSERT INTO cje_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Mơnih pô đờm mơyòm mơnih c̆ơ apăn-akŏ bruă sàng 'buh rĭng-tơpă nư̆n hũ ngă jak-rơgơi. Kơyoa du anà rài ni jak-rơgơi rơlau du anà pơnuaĭ sơrdah lăm bruă hơdiŭ sơ̆ng du mơnih hơdiŭ lăm rài sơ̆ng drơi. ");
INSERT INTO cje_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Pơ-ơnah Kơu, Kơu đờm sơ̆ng buơl guhã: Păl angui bĕ phơ̆n-priă dun-ya ni, la phơ̆n-priă 'buh rĭng-tơpă, bloh ngă adơi-ai gơŭ, tô tŭ phơ̆n-priă nư̆n abih, buơl guhã rơŭ hũ wă-rò tơma lăm sàng rài pơdò rài. ");
INSERT INTO cje_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Aràng sơi tơpă sa hơtai-hơtiàn lăm bruă tìt, kŭng rơŭ tơpă sa hơtai-hơtiàn lăm bruă prŏng. Aràng sơi 'buh tơpă sa hơtai-hơtiàn lăm bruă tìt, kŭng rơŭ 'buh tơpă sa hơtai-hơtiàn lăm bruă prŏng. ");
INSERT INTO cje_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Yơu nư̆n, yah buơl guhã 'buh tơpă sa hơtai-hơtiàn mư̆ng phơ̆n-bơna dun-ya, la phơ̆n-bơna 'buh rĭng-tơpă, nư̆n aràng sơi khĭn păng-tui tô jào phơ̆n-bơna biă tơ buơl guhã? ");
INSERT INTO cje_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Yah buơl guhã 'buh tơpă sa hơtai-hơtiàn mư̆ng phơ̆n-priă mơnih pơkơ̆n, nư̆n aràng sơi rơŭ brơi tơ buơl guhã phơ̆n-priă pioh krơi tơ buơl guhã? ");
INSERT INTO cje_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","'Buh mơnih hơlŭn-hơlă lơi hũ rơgơi ngă hơlŭn dua aràng mơnih pô, kơyoa rơŭ mơbai pô ni bloh rơnăm pô dih, halài c̆ơ prŏng-màng tơ pô ni bloh c̆ơ 'buh sơ̆p tơ pô dih. Buơl guhã 'buh rơgơi găm duh bruă Yàng Pô Lơngì, găm duh bruă phơ̆n-priă jiơ̆ng.” ");
INSERT INTO cje_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Mơnih Pharisi la du mơnih hàm jền-priă, mơhư̆ Yàng Jêsu đờm yơu nư̆n, buơl guñu klau pơtăt Pô. ");
INSERT INTO cje_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Pô đờm sơ̆ng buơl guñu: “Buơl guhã ngă mơthĭ yơu drơi la du mơnih rĭng-tơpă tơ anaŭ aràng, bloh Yàng Pô Lơngì thơu loh-làng lăm hơtai-hơtiàn buơl guhã, kơyoa pơnuaĭ jơi anà mơnih c̆ơ prŏng-màng la pơnuaĭ kìr-sơŭ tơ anaŭ Yàng Pô Lơngì. ");
INSERT INTO cje_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Pơnuaĭ adăt-adia sơ̆ng du pơnuaĭ đờm hwơ̆r hũ truh tơ rài Jăng soh. Mư̆ng hơrơi nư̆n, Pơnuaĭ-Siàm mư̆ng lơgăr Yàng Pô Lơngì hũ pơto-akhàn, sơ̆ng aràng sơi kŭng angui pràn-khăng tămpơjeh gơŭ bloh tơma. ");
INSERT INTO cje_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Lơngì sơ̆ng tơnah nau rơlau thĭt dò 'buơ̆n rơlau la sa c̆reh akhăr lăm pơnuaĭ adăt-adia păl klà luơi. ");
INSERT INTO cje_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Aràng sơi pơkloh sơdiŭ bloh khiăng sơ̆ng sơdiŭ pơkơ̆n la kơđòng glài klĕ sơdiŭ-aràng pơsàng-gơŭ. Aràng sơi khiăng sơ̆ng mơnih kơmơi kơđòng pơsàng pơkloh, nư̆n kŭng kơđòng glài klĕ sơdiŭ-aràng pơsàng-gơŭ.” ");
INSERT INTO cje_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Hũ sa aràng mơnih mơda gơn-hư̆p dih, tŭ lơi kŭng c̆ù khăn-ào sơ̆ng bơ-yài c̆ơk-màng, hơdiŭ 'bơ̆ng lơngai dò soh, yàu hơrơi pồ pơnuaĭ mơñŭm 'bơ̆ng dơlah-dơlài. ");
INSERT INTO cje_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Kŭng hũ sa aràng mơnih rơ'bah rơ'bừp, angăn la Lasarơ, dò đih tơ agàh bơh 'băng sàng mơnih mơda gơn-hư̆p nư̆n, lồk baŭ du kơtăl lơka. ");
INSERT INTO cje_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Lasarơ mơhau sơ̆ng eh-uăn biă hũ 'bơ̆ng du phơ̆n-kơya mư̆ng c̆ơnừng 'bơ̆ng mơnih mơda gơn-hư̆p nư̆n hŏ tơ ala. Kŭng hũ du asơu truh lơ-yah kơtăl lơka lăm lồk ñu. ");
INSERT INTO cje_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Mơnih rơ'bah mơtai, du mơnih gơdrưh apăn ñu truh dò sơ̆ng Abraham. Mơnih mơda gơn-hư̆p kŭng mơtai, sơ̆ng aràng apăn nau dơ̆r. ");
INSERT INTO cje_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Lăm anih mơnih mơtai, mơnih mơda kŏng pơđì-pơđoa gleh-glăr biă, ngừk mơta tơ ngŏ, 'buh Abraham dò mư̆ng atàh, sơ̆ng 'buh Lasarơ dò sơ̆ng Abraham. ");
INSERT INTO cje_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Nư̆n mơnih mơda iơu driau: ‘Ơ kơi-kŏ pàng-yau Abraham, yòng anĭt-anăr anà, sơ̆ng pơđăr Lasarơ ơñrŭ anà tơngàn lăm ia, tô ngă tơ mơrềt dơlah anà; kơyoa anà kŏng pơđì-pơđoa biă lăm apui ni!’ ");
INSERT INTO cje_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Bloh Abraham đờm sơđồ: ‘Ơ anà, sơdơ̆r wơ̆ bĕ tŭ anà dò hơdiŭ, anà hũ đồ-mă tơgrơ̆ pơnuaĭ lơngai-sờh drơi bơjơ, dò Lasarơ nư̆n păl kŏng lô pơnuaĭ jơhà sơ̆ng pơđì-pơđoa. Tŭ ni, ñu dò tơ anih ni hũ pơluơ-pơrơngài, dò anà păl kŏng pơđì-pơđoa gleh-glăr. ");
INSERT INTO cje_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Rơlau wơ̆, tơkrah buơl gudrơi sơ̆ng anà hũ sa boh drŏng dơrlăm prŏng biă pơklah krơi, tơ̆l truh aràng sơi khiăng mư̆ng gah ni nau truh tơ gah nư̆n, halài mư̆ng gah nư̆n nau truh tơ gah ni, kŭng 'buh jiơ̆ng ơu rơi.’ ");
INSERT INTO cje_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Mơnih mơda đờm: ‘Ơ kơi-kŏ pàng-yau! Yah yơu nư̆n, yòng kơi-kŏ pàng-yau pơđăr Lasarơ truh tơ sàng ama anà, ");
INSERT INTO cje_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","kơyoa anà hũ lơma aràng adơi-ai, tô Lasarơ ngă grơh tơ buơl guñu mư̆ng tơgrơ̆ pơnuaĭ ni, huơĭ buơl guñu kŭng kơđòng lĕ tơma lăm anih pơđì-pơđoa gleh-glăr ni rơi.’ ");
INSERT INTO cje_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Bloh Abraham đờm: ‘Buơl guñu hũ Môise sơ̆ng du mơnih gơnuăr-hwơ̆r. Buơl guñu păl păng pơnuaĭ du mơnih nư̆n.’ ");
INSERT INTO cje_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Mơnih mơda đờm: ‘Ơ kơi-kŏ pàng-yau Abraham, 'buh iơŭ yơu nư̆n ơu, bloh yah hũ mơnih mơtai hơdiŭ wơ̆ truh sơ̆ng buơl guñu, nư̆n buơl guñu rơŭ mơbai prah-luơi glài-sơnoh!’ ");
INSERT INTO cje_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abraham đờm: ‘Yah buơl guñu 'buh khiăng păng Môise sơ̆ng du mơnih gơnuăr-hwơ̆r, nư̆n yah hũ mơnih mơtai hơdiŭ wơ̆, buơl guñu kŭng 'buh păng-tui ơu.’ ” ");
INSERT INTO cje_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yàng Jêsu đờm sơ̆ng du mơnih tui-mơgru: “'Buh rơgơi 'buh hũ du pơnuaĭ ngă tơ aràng sơnĕ lơbuh lăm pơnuaĭ sŭng glài, bloh gleh-glăr dồn-să biă tơ mơnih lơi la mơnih ngă pơnuaĭ nư̆n! ");
INSERT INTO cje_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Yah akă lơsŭng pơtơu tơ tơkuai ñu bloh prah trŭn lăm ia-tơsì, dò siàm rơlau la luơi mơnih nư̆n ngă tơ sa aràng lăm du mơnih tìt ni sơnĕ lơbuh lăm pơnuaĭ sŭng glài! ");
INSERT INTO cje_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Păl c̆ơ-kơrhia bĕ! Yah buơl adơi-ai hã hũ ngă glài sŭng, nư̆n đờm puaĭ pơto bĕ; sơ̆ng yah buơl guñu mơbai prah-luơi glài-sơnoh, nư̆n anĭt toh-luơi bĕ. ");
INSERT INTO cje_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Yah lăm sa hơrơi, adơi-ai hã ngă glài sŭng sơ̆ng hã tơjuh amăng, sơ̆ng tơjuh amăng gài truh sơ̆ng hã bloh đờm: ‘Dơlhă mơbai prah-luơi glài-sơnoh,’ nư̆n hã kŭng păl anĭt toh-luơi tơ buơl guñu.” ");
INSERT INTO cje_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Du mơnih tơdi-tơdài đờm sơ̆ng Yàng: “Yòng Yàng brơi pơtơ̆l pơnuaĭ păng-tui tơ buơl dơlhă!” ");
INSERT INTO cje_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Yàng đờm: “Yah buơl guhã hũ pơnuaĭ păng-tui kàr sa găr sơbơi, buơl guhã hũ rơgơi đờm pơđăr phŭn sơ-ơyo ni lài: ‘Buĭ akha tơgồ bĕ, bloh trŭn pla lăm ia-tơsì,’ nư̆n ñu kŭng rơŭ păng-bơbah buơl guhã. ");
INSERT INTO cje_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Aràng sơi lăm buơl guhã hũ mơnih hơlŭn-hơlă nau lơ-ua halài nau glăng abo, tŭ ñu pơrpa mư̆ng 'blàng hơma mơrai wơ̆, bloh đờm pơđăr ñu lài: ‘Sơmăr truh dò guh huă 'bơ̆ng bĕ!’ ");
INSERT INTO cje_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Tơrblơ̆ wơ̆, 'buh iơŭ buơl guhã rơŭ đờm pơđăr ñu lài: ‘Pồ bĕ bu-sơi tơ kơu 'bơ̆ng, akă ào tơ kơ-iăng duh bruă lăm tŭ kơu huă 'bơ̆ng, bloh nư̆n hã huă 'bơ̆ng hơdơi,’ ơu? ");
INSERT INTO cje_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Mơnih hơlŭn-hơlă păng-bơbah bloh ngă, nư̆n mơnih pô hũ thơu ưnjơmừn ñu ơu? ");
INSERT INTO cje_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Buơl guhã kŭng yơu nư̆n rơi, tŭ ngă abih du bruă hũ pơđăr păl ngă, nư̆n đờm bĕ lài: ‘Buơl dơlhă la du mơnih hơlŭn-hơlă 'buh kwơ-màng, pơnuaĭ buơl dơlhă hũ ngă mĭn la pơnuaĭ buơl dơlhă păl ngă soh.’ ” ");
INSERT INTO cje_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Lăm jơlàn truh tơ plơi-prŏng Jerusalem, Yàng Jêsu nau găn nàl pơklah-krơi tơkrah dua c̆àr Samari sơ̆ng Galile. ");
INSERT INTO cje_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Tŭ Pô tơma lăm sa plơi dih, hũ sa-pluh aràng mơnih dŭn tơbiă nau rò Pô. Buơl guñu dò dơ̆ng mư̆ng atàh, ");
INSERT INTO cje_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","sơ̆ng prŏng săp iơu lơkơu: “Khoai Jêsu, khoai Pô-Pơto, yòng anĭt-anăr buơl dơlhă!” ");
INSERT INTO cje_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Tŭ 'buh buơl guñu, Yàng Jêsu đờm: “Nau pơto rùp bĕ sơ̆ng du mơnih gơnuăr pơyă phơ̆n duh-dơlbăt!” Tŭ buơl guñu dò nau, nư̆n dŭn hũ pơsồ goh abih. ");
INSERT INTO cje_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Sa aràng lăm tơrpuơl buơl guñu 'buh drơi hũ pơsồ goh, nư̆n gài mơrai wơ̆ mư sơ̆ng prŏng săp mơyòm-pơglòng Yàng Pô Lơngì. ");
INSERT INTO cje_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Mơnih nư̆n truh pơđih rùp tơ tơkai Yàng Jêsu bloh ưnjơmừn Pô. Mơnih nư̆n la sa aràng mơnih Samari. ");
INSERT INTO cje_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yàng Jêsu đờm: “'Buh iơŭ abih sa-pluh aràng hũ pơsồ goh ơu? Dò sơlpăn aràng mơnih dih anih lơi? ");
INSERT INTO cje_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Kơđa hơgĕ 'buh hũ aràng sơi lăm buơl guñu gài mơrai mơyòm-pơglòng Yàng Pô Lơngì, mĭn sa aràng mơnih lơgăr agàh ni soh?” ");
INSERT INTO cje_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Bloh nư̆n Pô đờm sơ̆ng mơnih nư̆n: “Tơgồ dơ̆ng sơ̆ng nau bĕ! Pơnuaĭ păng-tui anà hũ pơsồ-pơsaih tơ anà!” ");
INSERT INTO cje_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Mơnih Pharisi tơnia Yàng Jêsu lơgăr Yàng Pô Lơngì tŭ lơi ka truh, Pô đờm: “Lơgăr Yàng Pô Lơngì 'buh truh yơu sa pơnuaĭ hũ rơgơi c̆ơ 'buh jiơ̆ng. ");
INSERT INTO cje_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Sơ̆ng aràng rơŭ 'buh đờm: Dih ñu dò tơ anih ni halài tơ anih nư̆n! Kơyoa lơgăr Yàng Pô Lơngì dò lăm buơl guhã.” ");
INSERT INTO cje_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Yàng Jêsu đờm sơ̆ng du mơnih tui-mơgru Pô: “Rơŭ hũ tŭ-hơrơi, buơl guhã lơkơu-khiăng hũ 'buh sa hơrơi lăm du hơrơi Anà Mơnih, bloh 'bu 'buh jiơ̆ng. ");
INSERT INTO cje_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Aràng rơŭ đờm sơ̆ng buơl guhã: ‘Dih, Pô dò tơ anih nư̆n!’ halài ‘Ni, Pô dò tơ anih ni!’ Buơl guhã juơi nau sơ̆ng juơi đuaĭ tui buơl guñu. ");
INSERT INTO cje_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kơyoa mơhiơ̆ yơu c̆ă kơrla kơc̆rà sơrdah mư̆ng gah lơngì ni truh gah lơngì dih, nư̆n Anà Mơnih lăm hơrơi Pô kŭng yơu nư̆n rơi. ");
INSERT INTO cje_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Bloh dơlhơu biă, Pô păl kŏng lô pơnuaĭ pơđì-pơđoa gleh-glăr, sơ̆ng kŏng jơi-pơtiàn ni kơmlah-luơi. ");
INSERT INTO cje_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Lăm rài Nôe hơyơu lơi, nư̆n lăm hơrơi Anà Mơnih kŭng yơu nư̆n rơi. ");
INSERT INTO cje_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Aràng 'bơ̆ng, mơñŭm, puaĭ-lơkơi khiăng-kơmơi, tơ̆l truh tơ hơrơi Nôe tơma lăm ahò, bloh nư̆n ia-tơsì đì ia-dơba truh pơluĭ-pơlơhiă abih. ");
INSERT INTO cje_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Bruă hũ tơbiă truh lăm rài Lot kŭng yơu nư̆n rơi, aràng 'bơ̆ng, mơñŭm, pơblơi sơlih, pla drà, sơ̆ng bơ̆-pơdơ̆ng, ");
INSERT INTO cje_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","tơ̆l truh tơ hơrơi Lot tơbiă mư̆ng Sôđôm, nư̆n hơjàn apui sơ̆ng siau-apui mư̆ng lơngì trŭn, pơluĭ-pơlơhiă abih buơl làng plơi-prŏng nư̆n. ");
INSERT INTO cje_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Hơrơi Anà Mơnih tơbiă pơ'buh kŭng yơu nư̆n rơi. ");
INSERT INTO cje_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Lăm hơrơi nư̆n, aràng sơi dò tơ ngŏ bơbŭng sàng bloh hũ phơ̆n-bơna lăm dơrlăm sàng, nư̆n juơi trŭn mă. Kŭng yơu nư̆n rơi, aràng sơi dò tơ 'blàng hơma nư̆n juơi gài mơrai wơ̆ tơ sàng tra. ");
INSERT INTO cje_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Sơdơ̆r wơ̆ bĕ sơdiŭ Lot! ");
INSERT INTO cje_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Aràng sơi duah pơnuaĭ gàr-dŏng pơnuaĭ hơdiŭ drơi, nư̆n rơŭ lơhiă; aràng sơi lơhiă pơnuaĭ hơdiŭ drơi, nư̆n rơŭ hũ wơ̆. ");
INSERT INTO cje_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Kơu đờm sơ̆ng buơl guhã, lăm mơlăm nư̆n, dua aràng mơnih đih lăm sa boh c̆ơnừng sơ̆ng gơŭ, sa aràng rơŭ hũ ba nau, sa aràng kơđòng luơi wơ̆. ");
INSERT INTO cje_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Dua aràng mơnih kơmơi xài bơdai sơ̆ng gơŭ lăm sa boh xài, sa aràng rơŭ hũ ba nau, sa aràng kơđòng luơi wơ̆. ");
INSERT INTO cje_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Hũ dua aràng mơnih lơkơi dò tơ 'blàng hơma, sa aràng rơŭ hũ ba nau, sa aràng kơđòng luơi wơ̆.” ");
INSERT INTO cje_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Du mơnih tui-mơgru đờm sơ̆ng Pô: “Ơ Yàng, pơnuaĭ nư̆n rơŭ tơbiă truh tơ anih lơi?” Pô đờm: “Rùp atơu mơtai anih lơi, c̆ĭm grơ̆ pơgùm tơ anih nư̆n!” ");
INSERT INTO cje_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yàng Jêsu đờm sơ̆ng du mơnih tui-mơgru sa pơnuaĭ pơgăp-pơmơyơu tô pơto buơl guñu păl iơu-lài mĭt, juơi pơblơ̆ hơtai-hơtiàn. ");
INSERT INTO cje_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Pô đờm: “Lăm plơi-prŏng dih, hũ sa aràng mơnih kwăng c̆ahrơña 'buh duh-huơĭ tơ Yàng Pô Lơngì, kŭng 'buh huơĭ-kơmlưh tơ aràng sơi. ");
INSERT INTO cje_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Lăm plơi-prŏng nư̆n kŭng hũ sa aràng mơnih kơmơi bơdrau. Kơmơi nư̆n kừ truh lơkơu yòng sơ̆ng kwăng c̆ahrơña: ‘Yòng c̆ahrơña rĭng-tơpă tơ dơlhă tô tămdră-wơ̆ sơ̆ng mơnih mơbai-tămdră sơ̆ng dơlhă!’ ");
INSERT INTO cje_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Kwăng c̆ahrơña nư̆n kơmlah-luơi suơi bơjơ, bloh truh luĭ-dŭt ñu sơnư̆ng lăm hơtai-hơtiàn: ‘Yah kơu 'buh duh-huơĭ tơ Yàng Pô Lơngì sơ̆ng kŭng 'buh huơĭ-kơmlưh tơ aràng sơi, ");
INSERT INTO cje_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","bloh kơyoa mơnih kơmơi bơdrau ni truh pơ-uă pơgleh kơu mĭt, nư̆n kơu rơŭ c̆ahrơña rĭng-tơpă tơ ñu, huơĭ ñu kừ truh mĭt, ngă tơ kơu pơđì akŏ.’ ” ");
INSERT INTO cje_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Bloh nư̆n Yàng đờm: “Buơl guhã păng mơhư̆ bĕ pơnuaĭ mơnih kwăng c̆ahrơña 'buh rĭng-tơpă nư̆n đờm. ");
INSERT INTO cje_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Yàng Pô Lơngì tŭ lơi kŭng c̆ahrơña rĭng-tơpă tơ du mơnih Pô hũ pơlih-rơwah, la du mơnih mơlăm-hơrơi lơkơu-yòng sơ̆ng Pô. Pô 'buh suơi-rơlĕ lăm bruă truh dŏng-kờl buơl guñu ơu. ");
INSERT INTO cje_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Kơu đờm tơ buơl guhã thơu, Pô rơŭ sơmăr mư c̆ahrơña rĭng-tơpă tơ buơl guñu. Bloh tŭ Anà Mơnih truh, Pô rơŭ dò 'buh pơnuaĭ păng-tui lăm lơ̆n-tơnah ơu?” ");
INSERT INTO cje_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yàng Jêsu đờm pơnuaĭ pơgăp-pơmơyơu ni tô pơto du mơnih brơi rùp-phŭn drơi la mơnih rĭng-tơpă, bloh c̆ơ 'buh sơ̆p tơ mơnih pơkơ̆n: ");
INSERT INTO cje_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Hũ dua aràng mơnih đì nau tơ sàng duh-dơlbăt tô iơu-lài. Sa aràng la mơnih Pharisi sơ̆ng sa aràng la mơnih rì-mă jia. ");
INSERT INTO cje_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Mơnih Pharisi dò dơ̆ng sơ̆ng iơu-lài yơu ni: ‘Khoai Yàng Pô Lơngì, dơlhă ưnjơmừn Pô, kơyoa dơlhă 'buh iơŭ yơu du mơnih pơkơ̆n, hàm-làm, 'buh rĭng-tơpă, klĕ sơdiŭ-aràng pơsàng-gơŭ, kŭng 'buh iơŭ yơu mơnih rì-mă jia ni. ");
INSERT INTO cje_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Dơlhă wèr 'bơ̆ng yàu tơjuh dua amăng, sơ̆ng pơyă tơ Yàng sa pơ-ơnah sa-pluh mư̆ng abih tơgrơ̆ phơ̆n dơlhă ngă hũ.’ ");
INSERT INTO cje_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Dò mơnih rì-mă jia nư̆n dò dơ̆ng đoh-đoh, 'buh khĭn tơ̆ mơta tơ ngŏ lơngì, mĭn sơđŭ hărda đờm: ‘Khoai Yàng Pô Lơngì, yòng anĭt-anăr tơ dơlhă, kơyoa dơlhă la sa aràng mơnih glài-sơnoh!’ ");
INSERT INTO cje_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Kơu đờm tơ buơl guhã thơu: mơnih rì-mă jia ni tŭ gài nau wơ̆ tơ sàng, hũ angăn la rĭng-tơpă bloh 'buh iơŭ la mơnih dih. Kơyoa aràng sơi pồ-pơglòng rùp-phŭn drơi đì, rơŭ păl kŏng pơtrŭn, dò aràng sơi pơ-ơneh rùp-phŭn drơi trŭn, rơŭ hũ pồ-pơglòng.” ");
INSERT INTO cje_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Tŭ nư̆n aràng ba du lơ-ơneh tìt truh sơ̆ng Yàng Jêsu tô Pô daŭ tơngàn tơ ngŏ guñu, du mơnih tui-mơgru 'buh yơu nư̆n, đờm puaĭ tơ du mơnih ba truh. ");
INSERT INTO cje_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Bloh Yàng Jêsu iơu buơl guñu truh sơ̆ng đờm lài: “Kừ luơi du lơ-ơneh tìt truh sơ̆ng Kơu, juơi pơkơŭ-c̆ơkhă buơl guñu, kơyoa lơgăr Yàng Pô Lơngì la găm sơ̆ng du mơnih hũ hơtai-hơtiàn mơhiơ̆ yơu du lơ-ơneh tìt nư̆n. ");
INSERT INTO cje_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Iơŭ biă, Kơu đờm sơ̆ng buơl guhã, aràng sơi 'buh đồ-mă lơgăr Yàng Pô Lơngì sơ̆ng hơtai-hơtiàn yơu sa aràng lơ-ơneh tìt, nư̆n rơŭ 'buh hũ tơma lăm nư̆n jiơ̆ng.” ");
INSERT INTO cje_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Hũ sa aràng mơnih kwăng dih tơnia Yàng Jêsu: “Ơ Pô-Pơto siàm, dơlhă păl ngă hơgĕ tô hũ đồ-lĕng pơnuaĭ hơdiŭ rài pơdò rài?” ");
INSERT INTO cje_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yàng Jêsu đờm: “Kơđa hơgĕ hã iơu Kơu la mơnih siàm? 'Buh hũ aràng sơi la mơnih siàm ơu, mĭn sa aràng Pô siàm soh, la Yàng Pô Lơngì. ");
INSERT INTO cje_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Biă hã hũ thơu du pơnuaĭ adăt-adia ni: ‘Hã juơi ngă glài klĕ sơdiŭ-aràng pơsàng-gơŭ; juơi pơmơtai mơnih; juơi klĕ blơ̆; juơi đờm ngă grơh lơ̆r; păng-duh bĕ tơ ame ama.’ ” ");
INSERT INTO cje_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Mơnih nư̆n đờm lài: “Dơlhă hũ păng-rơmiă ngă tui abih tơgrơ̆ pơnuaĭ nư̆n mư̆ng tŭ dơlhă dò lơ-ơneh.” ");
INSERT INTO cje_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Tŭ Yàng Jêsu mơhư̆ yơu nư̆n, Pô đờm: “Hã dò siơŭ sa pơnuaĭ: Pơblơi bĕ abih tơgrơ̆ hơgĕ hã hũ, bloh nư̆n apăn pơrpha brơi tơ mơnih rơ'bah, nư̆n hã rơŭ hũ phơ̆n-bơna c̆ơk-màng tơ ngŏ lơngì; tŭ nư̆n truh bĕ bloh tui Kơu.” ");
INSERT INTO cje_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Bloh tŭ mơhư̆ yơu nư̆n, ñu tơbiă jiơ̆ng dơnuh-dơnà, kơyoa ñu mơda gơn-hư̆p biă. ");
INSERT INTO cje_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yàng Jêsu c̆ơ tơ ñu sơ̆ng đờm: “Mơnih mơda tơma lăm lơgăr Yàng Pô Lơngì la kăn-dơmăn thơu hơdùm! ");
INSERT INTO cje_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Biă yơu nư̆n, lakđa rŏ găn lơbàng jrŭm dò 'buơ̆n rơlau mơnih mơda tơma lăm lơgăr Yàng Pô Lơngì!” ");
INSERT INTO cje_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Du mơnih mơhư̆ pơnuaĭ nư̆n, đờm lài: “Yơu nư̆n aràng sơi rơgơi hũ dŏng-pơklàh?” ");
INSERT INTO cje_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Pô đờm: “Tơgrơ̆ hơgĕ jơi anà mơnih 'buh rơgơi ngă jiơ̆ng, nư̆n Yàng Pô Lơngì rơgơi ngă jiơ̆ng abih.” ");
INSERT INTO cje_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pier đờm: “Pô-Pơto hũ 'buh nư̆n, buơl dơlhă hũ luơi abih tơgrơ̆ hơgĕ drơi hũ bloh tui Pô-Pơto.” ");
INSERT INTO cje_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Pô đờm: “Iơŭ biă, Kơu đờm sơ̆ng buơl guhã, 'buh aràng sơi klà luơi sàng-dơnò, ame ama, adơi-ai, sơdiŭ anà, kơyoa lơgăr Yàng Pô Lơngì, ");
INSERT INTO cje_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","bloh rơŭ 'buh đồ-mă wơ̆ hũ lô amăng rơlau lăm rài ni, sơ̆ng pơnuaĭ hơdiŭ rài pơdò rài lăm rài hơdơi!” ");
INSERT INTO cje_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yàng Jêsu ba sa-pluh dua aràng mơnih tơdi-tơdài tơbiă krơi bloh đờm sơ̆ng buơl guñu: “Ni, buơl gudrơi đì nau tơ plơi-prŏng Jerusalem, sơ̆ng tơgrơ̆ pơnuaĭ bloh du mơnih gơnuăr-hwơ̆r hũ wă mư̆ng Anà Mơnih, rơŭ hũ tơbiă truh iơŭ tơpă yơu nư̆n. ");
INSERT INTO cje_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Kơyoa Pô rơŭ kŏng jào tơ buơl làng agàh; buơl guñu rơŭ klau-pơtăt Pô, ngă mơlơu alah, sơ̆ng kơc̆uh ia bơbah lăm Pô. ");
INSERT INTO cje_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Buơl guñu rơŭ glih-pờng sơ̆ng pơmơtai Pô. Bloh hơdơi klơu hơrơi, Pô rơŭ hơdiŭ wơ̆.” ");
INSERT INTO cje_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Bloh du mơnih tui-mơgru 'buh wờng hơgĕ mư̆ng du pơnuaĭ nư̆n, kơyoa du pơnuaĭ nư̆n dò kŏng bơdơŭ-tơrđơŭ sơ̆ng buơl guñu, sơ̆ng buơl guñu 'buh thơu Yàng khiăng đờm hơgĕ. ");
INSERT INTO cje_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Tŭ Yàng Jêsu truh jĕ tơ plơi-prŏng Jerikô, hũ sa aràng mơnih bồm dò guh yòng 'bơ̆ng tơ gah jơlàn. ");
INSERT INTO cje_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Mơhư̆ săp tơrpuơl mơnih lô nau găn, ñu tơnia suơ̆ hũ bruă hơgĕ. ");
INSERT INTO cje_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Aràng brơi ñu thơu, Yàng Jêsu, mơnih Nasaret, kơjĕ nau găn nư̆n. ");
INSERT INTO cje_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Nư̆n mơnih bồm prŏng săp iơu: “Khoai Jêsu, Anà pơtau Đabit, yòng anĭt-anăr dơlhă!” ");
INSERT INTO cje_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Du mơnih nau dơlhơu đờm puaĭ ñu, pơđăr dò kơđơ̆ng. Bloh ñu 'brŏ iơu prŏng rơlau wơ̆: “Khoai Anà pơtau Đabit, yòng anĭt-anăr dơlhă!” ");
INSERT INTO cje_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yàng Jêsu dò dơ̆ng wơ̆, pơđăr ba mơnih bồm truh. Tŭ mơnih bồm truh jĕ, Pô tơnia: ");
INSERT INTO cje_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Anà khiăng Kơu ngă hơgĕ tơ anà?” Mơnih bồm đờm: “Khoai Yàng, yòng brơi mơta dơlhă c̆ơ 'buh jiơ̆ng.” ");
INSERT INTO cje_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yàng Jêsu đờm: “Sơrdah mơta wơ̆ bĕ! Pơnuaĭ păng-tui anà hũ pơsồ-pơsaih tơ anà.” ");
INSERT INTO cje_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Lăm tơk tŭ nư̆n mư, mơta mơnih bồm hũ c̆ơ 'buh jiơ̆ng. Ñu nau tui Pô sơ̆ng adoh-mơyòm Yàng Pô Lơngì. 'Buh yơu nư̆n, abih tơrpuơl buơl làng pồ-săp mơyòm-pơglòng Yàng Pô Lơngì. ");
INSERT INTO cje_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Hơdơi tŭ tơma lăm Jerikô, Yàng Jêsu nau găn plơi-prŏng nư̆n. ");
INSERT INTO cje_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Tơ anih nư̆n, hũ sa aràng mơnih angăn la Sac̆e. Ñu la mơnih apăn-akŏ du mơnih rì-mă jia, sơ̆ng la mơnih mơda gơn-hư̆p. ");
INSERT INTO cje_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ñu khiăng duah ngă hơyơu tô c̆ơ thơu Yàng Jêsu la aràng sơi, bloh 'bu 'buh jiơ̆ng, kơyoa tơrpuơl buơl làng nư̆n lô, bloh rùp ñu nư̆n bièr. ");
INSERT INTO cje_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Yơu nư̆n, Sac̆e đuaĭ dơlhơu, đì tơ ngŏ kơyơu hra, tô hũ rơgơi c̆ơ 'buh Yàng Jêsu, kơyoa Pô kơjĕ nau găn nư̆n. ");
INSERT INTO cje_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Tŭ Yàng Jêsu truh anih nư̆n, Pô tơ̆ mơta c̆ơ tơ ngŏ bloh đờm sơ̆ng ñu: “Ơ Sac̆e, trŭn sơmăr bĕ, kơyoa hơrơi ni Kơu păl dò lăm sàng hã!” ");
INSERT INTO cje_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sac̆e tơmbah-tơmbàn trŭn sơ̆ng sờh-sài wă-rò Pô. ");
INSERT INTO cje_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","'Buh yơu nư̆n, buơl làng yuăm đờm sơ̆ng gơŭ: “Kơđa hơgĕ Pô-Pơto tơma lăm sàng mơnih glài-sơnoh bloh dò!” ");
INSERT INTO cje_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Bloh Sac̆e dò dơ̆ng tơ anaŭ Yàng sơ̆ng đờm: “Khoai Yàng, ni, dơlhă mă sa mơtưh phơ̆n-bơna dơlhă bloh brơi tơ mơnih rơ'bah, sơ̆ng yah dơlhă hũ lơ̆r pơ̆ng-gơla mă soh phơ̆n hơgĕ mư̆ng aràng sơi, dơlhă yòng bơ-yàr wơ̆ pà amăng.” ");
INSERT INTO cje_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yàng Jêsu đờm sơ̆ng ñu: “Hơrơi ni, pơnuaĭ dŏng-pơklàh hũ tơma sàng ni, kơyoa mơnih ni kŭng la anà-tơc̆o Abraham. ");
INSERT INTO cje_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Kơyoa Anà Mơnih hũ truh tô duah sơ̆ng dŏng du mơnih kơđòng lơhiă.” ");
INSERT INTO cje_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Lăm tŭ buơl guñu păng du pơnuaĭ nư̆n, Yàng Jêsu đờm pơtơ̆l sa pơnuaĭ pơgăp-pơmơyơu tra, kơyoa Pô kơjĕ truh tơ plơi-prŏng Jerusalem, sơ̆ng aràng sơnư̆ng lài lơgăr Yàng Pô Lơngì rơŭ tơbiă truh mư. ");
INSERT INTO cje_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Kơyoa nư̆n, Pô đờm: “Hũ sa aràng mơnih prŏng-màng, nau truh tơ sa lơgăr atàh tô đồ-mă gơnuăr pơtau, bloh nư̆n gài mơrai wơ̆. ");
INSERT INTO cje_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ñu iơu sa-pluh aràng lăm tơrpuơl mơnih hơlŭn-hơlă drơi truh, jào tơ buơl guñu sa-pluh kleh priă sơ̆ng đờm: ‘Apăn bĕ priă ni nau pơblơi-sơlih akă-bơnia tơ̆l truh tơ tŭ kơu gài mơrai wơ̆!’ ");
INSERT INTO cje_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Bloh buơl làng lăm lơgăr ñu mơbai ñu, nư̆n pơđăr sa tơrpuơl mơnih nau tui hơdơi ñu sơ̆ng đờm lài: ‘Buơl dơlhă 'buh khiăng mơnih ni apăn-akŏ buơl dơlhă!’ ");
INSERT INTO cje_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Hơdơi tŭ hũ đồ-mă gơnuăr pơtau gài mơrai wơ̆, pơtau iơu du mơnih hơlŭn-hơlă bloh ñu hũ jào priă truh, tô thơu yàu aràng pơblơi-sơlih akă-bơnia ngă tơbiă phŭn-hơjŭng hũ hơdùm. ");
INSERT INTO cje_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Mơnih hơlŭn-hơlă c̆ơmrừp truh đờm akhàn: ‘Ơ pô, kleh priă pô tơbiă phŭn-hơjŭng hũ sa-pluh kleh.’ ");
INSERT INTO cje_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Mơnih pô đờm: ‘Ơ mơnih hơlŭn-hơlă tơpă-siàm dih, iơŭ biă! Kơyoa hã hũ tơpă sa hơtai-hơtiàn lăm bruă tìt, hã rơŭ hũ apăn-akŏ sa-pluh plơi-prŏng.’ ");
INSERT INTO cje_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Mơnih hơlŭn-hơlă dua truh đờm akhàn: ‘Ơ pô, kleh priă pô tơbiă phŭn-hơjŭng hũ lơma kleh.’ ");
INSERT INTO cje_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Mơnih pô đờm sơ̆ng mơnih nư̆n: ‘Hã hũ apăn-akŏ lơma plơi-prŏng.’ ");
INSERT INTO cje_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Sa aràng mơnih hơlŭn-hơlă pơkơ̆n truh đờm akhàn: ‘Ơ pô, ni la kleh priă pô, dơlhă hũ mă c̆ơnră pơpò wơ̆ sơ̆ng pioh rơmiă nĭ-nùn. ");
INSERT INTO cje_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Kơyoa dơlhă huơĭ pô, kơyoa pô la mơnih kơđơ̆ng-mơsak, jiăng mă lăm anih 'buh daŭ, yuă lăm anih 'buh drà.’ ");
INSERT INTO cje_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Mơnih pô đờm: ‘Ơ mơnih hơlŭn-hơlă mơsak-jơhà dih! Kừ tui yơu pơnuaĭ hã đờm bloh kơu c̆ahrơña hã. Hã thơu kơu la mơnih mơsak-kơđơ̆ng, mă lăm anih 'buh daŭ, yuă lăm anih 'buh drà. ");
INSERT INTO cje_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Yơu nư̆n kơđa hơgĕ hã 'buh jào priă kơu tơ mơnih pơblơi-sơlih priă, tô tŭ kơu mơrai wơ̆, rơŭ rì-mă wơ̆ găm priă phŭn sơ̆ng priă hơjŭng?’ ");
INSERT INTO cje_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Bloh nư̆n mơnih pô đờm sơ̆ng du mơnih dò dơ̆ng tơ anih nư̆n: ‘Mă bĕ kleh priă mư̆ng ñu sơ̆ng brơi tơ mơnih hũ sa-pluh kleh priă.’ ");
INSERT INTO cje_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Buơl guñu đờm: ‘Ơ pô, mơnih nư̆n hũ sa-pluh kleh bơjơ!’ ");
INSERT INTO cje_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","‘Kơu đờm sơ̆ng buơl guhã: Aràng sơi hũ, rơŭ hũ brơi pơtơ̆l rơlau, bloh aràng sơi 'buh hũ, nư̆n găm tơgrơ̆ hơgĕ buơl guñu hũ kŭng rơŭ kŏng mă abih rơi. ");
INSERT INTO cje_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Dò tơrpuơl mơnih mơbai-tămdră sơ̆ng Kơu dih, du mơnih 'buh khiăng Kơu ngă pơtau apăn-akŏ buơl guñu, nư̆n ba bĕ guñu mơrai tơ anih ni, sơ̆ng pơmơtai guñu tơ anaŭ kơu.’ ” ");
INSERT INTO cje_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Hơdơi tŭ đờm du pơnuaĭ nư̆n, Yàng Jêsu nau dơlhơu, ba akŏ buơl guñu đì tơ plơi-prŏng Jerusalem. ");
INSERT INTO cje_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Tŭ truh jĕ plơi 'Betphage sơ̆ng 'Bethani, tơ gah rơnòng c̆ơ̆ angăn la c̆ơ̆ Ôlibe, Pô pơđăr dua aràng mơnih tui-mơgru Pô nau, ");
INSERT INTO cje_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","sơ̆ng đờm pơđăr lài: “Nau tơma bĕ lăm plơi dò tơ anaŭ buơl guhã. Tŭ tơma lăm plơi, buơl guhã rơŭ 'buh sa drơi alàng anà, ka tŭ lơi hũ aràng sơi đì, aràng akă lờih tơ anih nư̆n. Tơleh bĕ tơlơi sơ̆ng dùi ñu mơrai tơ Kơu. ");
INSERT INTO cje_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Yah hũ aràng sơi tơnia: ‘Kơđa hơgĕ buơl sơ-ai tơleh alàng?’ nư̆n đờm sơđồ bĕ: ‘Yàng khiăng angui ñu!’ ” ");
INSERT INTO cje_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Dua aràng mơnih tui-mơgru nư̆n tơbiă nau, sơ̆ng păp tơgrơ̆ bruă iơŭ tơpă yơu Yàng Jêsu hũ đờm. ");
INSERT INTO cje_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Lăm tŭ buơl guñu dò tơleh tơlơi alàng, nư̆n du mơnih pô alàng đờm sơ̆ng buơl guñu: “Kơđa hơgĕ buơl sơ-ai tơleh alàng ni?” ");
INSERT INTO cje_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Buơl guñu đờm sơđồ: “Yàng khiăng angui ñu.” ");
INSERT INTO cje_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Dua aràng buơl guñu dùi alàng mơrai tơ Yàng Jêsu, bloh nư̆n mă ào drơi làng tơ rŏng alàng, sơ̆ng đơ̆ng Pô đì. ");
INSERT INTO cje_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Tŭ Yàng Jêsu đì alàng nau, hũ lô mơnih làng ào drơi lăm jơlàn. ");
INSERT INTO cje_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Tŭ truh jĕ tơkai c̆ơ̆ Ôlibe, abih tơrpuơl mơnih tui-mơgru mă ngă sờh-sài, sơ̆ng prŏng săp adoh-mơyòm Yàng Pô Lơngì mư̆ng abih tơgrơ̆ bruă gơnăp-gơnuăr bloh buơl guñu hũ 'buh. ");
INSERT INTO cje_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Buơl guñu driau prŏng đờm: “Mơyòm-pơglòng Pơtau mă angăn Yàng bloh truh! Rĭng-lơngai tơ ngŏ lơngì, sơ̆ng màng-kơc̆rà tơ anih ngŏ glòng rơlau abih!” ");
INSERT INTO cje_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Hũ du mơnih Pharisi dò lăm tơrpuơl mơnih lô đờm sơ̆ng Pô: “Ơ Pô-Pơto, yòng đờm puaĭ tơ du mơnih tui-mơgru Pô-Pơto!” ");
INSERT INTO cje_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Pô đờm: “Kơu đờm sơ̆ng buơl guhã, yah buơl guñu dò kơđơ̆ng, nư̆n pơtơu rơŭ driau!” ");
INSERT INTO cje_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Tŭ Yàng Jêsu truh jĕ plơi-prŏng Jerusalem, Pô 'buh plơi-prŏng, nư̆n hia mư̆ng ñu sơ̆ng đờm: ");
INSERT INTO cje_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“Lơkơu hơgĕ hơrơi ni, hã wờng-thơu jiơ̆ng pơnuaĭ hơgĕ apăn pơnuaĭ rĭng-lơngai truh tơ hã! Bloh tŭ ni, pơnuaĭ nư̆n sơđaŭ dò kơđòng ac̆ĭng-tơrđơŭ, mơta hã 'bu 'buh jiơ̆ng. ");
INSERT INTO cje_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Kơyoa du hơrơi truh, buơl lĭng mơbai-tămdră sơ̆ng hã rơŭ klơi lơbàng tòmdăr hã, gơrwàng-sơkă hã kơjăp mư̆ng pà gah. ");
INSERT INTO cje_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Buơl guñu rơŭ pơluĭ-pơlơhiă hã găm sơ̆ng du anà dò tơkrah hã. Buơl guñu rơŭ 'buh luơi sa boh pơtơu lơi rờng tơ ngŏ sa boh pơtơu lơi. Kơyoa hã 'buh kràn-thơu tŭ-hơrơi drơi hũ Yàng Pô Lơngì c̆uă-rơwăng.” ");
INSERT INTO cje_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yàng Jêsu tơma lăm sàng duh-dơlbăt, prơh abih du mơnih dò pơblơi-sơlih lăm nư̆n tơbiă tơ agàh. ");
INSERT INTO cje_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Pô đờm sơ̆ng buơl guñu: “Hũ pơnuaĭ wă: ‘Sàng Kơu rơŭ la sàng iơu-lài,’ bloh buơl guhã hũ ngă tơ ñu tơbiă jiơ̆ng gồ-lơbàng buơl klĕ blơ̆!” ");
INSERT INTO cje_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yàu hơrơi, Pô pơto-mơblàng lăm sàng duh-dơlbăt. Du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt, du mơnih gơnuăr-pơto pơnuaĭ adăt-adia, sơ̆ng du mơnih apăn-akŏ lăm buơl làng, duah pơnuaĭ pơmơtai Pô, ");
INSERT INTO cje_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","bloh buơl guñu 'buh thơu păl ngă hơyơu, kơyoa abih buơl làng aràng sơi kŭng khiăng biă sơ̆ng nĭ-nùn păng Pô pơto-mơblàng. ");
INSERT INTO cje_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Sa hơrơi, tŭ Yàng Jêsu dò pơto-pơsài buơl làng lăm sàng duh-dơlbăt sơ̆ng pơto-akhàn Pơnuaĭ-Siàm, nư̆n du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt, du mơnih gơnuăr-pơto pơnuaĭ adăt-adia, sơ̆ng du mơnih gơnuăr-tha ba gơŭ truh, ");
INSERT INTO cje_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","tơnia Pô yơu ni: “Đờm bĕ tơ buơl dơlhă thơu, Pô-Pơto mă gơnuăr lơi bloh ngă du bruă ni? Aràng sơi brơi tơ Pô-Pơto gơnuăr nư̆n?” ");
INSERT INTO cje_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yàng Jêsu đờm: “Kơu kŭng tơnia buơl guhã sa pơnuaĭ, đờm bĕ tơ Kơu thơu: ");
INSERT INTO cje_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Tŭ Jăng 'Baptis ngă adăt 'baptem tơ buơl làng, nư̆n Jăng mă gơnuăr mư̆ng Yàng Pô Lơngì halài mư̆ng jơi anà mơnih?” ");
INSERT INTO cje_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Buơl guñu đờm tămbơyai sơ̆ng gơŭ: “Yah buơl gudrơi đờm: ‘Mư̆ng Yàng Pô Lơngì,’ nư̆n ñu rơŭ đờm: ‘Yơu nư̆n kơđa hơgĕ buơl guhã 'buh păng-tui Jăng?’ ");
INSERT INTO cje_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Bloh yah buơl gudrơi đờm: ‘Mư̆ng jơi anà mơnih,’ nư̆n abih buơl làng rơŭ prah pơtơu pơmơtai buơl gudrơi, kơyoa buơl guñu hũ păng-tui nìn-kơjăp Jăng la sa aràng mơnih gơnuăr-hwơ̆r.” ");
INSERT INTO cje_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Kơyoa nư̆n, buơl guñu đờm sơđồ lài buơl guñu 'buh thơu adăt 'baptem nư̆n truh mư̆ng lơi. ");
INSERT INTO cje_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yàng Jêsu đờm sơ̆ng buơl guñu: “Kơu kŭng 'buh đờm tơ buơl guhã thơu kơyoa mư̆ng gơnuăr lơi bloh Kơu ngă du bruă ni!” ");
INSERT INTO cje_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yàng Jêsu đờm sơ̆ng buơl làng pơnuaĭ pơgăp-pơmơyơu ni: “Sa aràng mơnih dih pla sa apùh ño sơ̆ng brơi tơ du mơnih pla ño apah, bloh nư̆n nau truh tơ sa lơgăr pơkơ̆n lăm suơi hơrơi. ");
INSERT INTO cje_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Truh blàn pĕ boh ño, mơnih pô apùh pơđăr sa aràng mơnih hơlŭn-hơlă truh tòm du mơnih pla ño tô đồ-mă pơ-ơnah phŭn-hơjŭng mư̆ng apùh ño drơi. Bloh du mơnih pla ño ngă pờng mơnih hơlŭn-hơlă nư̆n sơ̆ng prơh mơrai wơ̆ tơngàn soh. ");
INSERT INTO cje_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Mơnih pô apùh pơđăr sa aràng mơnih hơlŭn-hơlă pơkơ̆n truh, bloh buơl guñu kŭng ngă pờng mơnih hơlŭn-hơlă nư̆n, c̆ơ-ua ngă pơmơlơu, sơ̆ng prơh mơrai wơ̆ tơngàn soh. ");
INSERT INTO cje_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Mơnih pô apùh pơđăr wơ̆ sa aràng mơnih hơlŭn-hơlă klơu, bloh buơl guñu kŭng ngă pờng mơnih hơlŭn-hơlă nư̆n traŭ biă, sơ̆ng prơh nau. ");
INSERT INTO cje_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Tŭ nư̆n, mơnih pô apùh ño đờm: ‘Kơu păl ngă hơyơu ni? Kơu rơŭ pơđăr anà lơkơi uơ̆n-rơnăm kơu truh. Hũ rơgơi buơl guñu rơŭ huơĭ-kơmlưh tơ anà kơu.’ ");
INSERT INTO cje_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Bloh tŭ 'buh anà lơkơi nư̆n, du mơnih pla ño tămbơyai sơ̆ng gơŭ: ‘Ni la anà tui-jơnuă, la mơnih bơgi-kơdih rơŭ jiơ̆ng pô phŭn apùh ño ni. Buơl gudrơi pơmơtai ñu bĕ, nư̆n phŭm-kơsai ñu rơŭ mơrai abih lăm tơngàn buơl gudrơi.’ ");
INSERT INTO cje_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Buơl guñu prah anà lơkơi nư̆n tơ agàh apùh ño, sơ̆ng pơmơtai. Yơu nư̆n, mơnih pô apùh ño rơŭ ngă hơgĕ sơ̆ng buơl nư̆n? ");
INSERT INTO cje_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Pô apùh rơŭ truh sơ̆ng pơluĭ-pơlơhiă abih du mơnih pla ño nư̆n, bloh nư̆n mă apùh jào tơ du mơnih pơkơ̆n.” Tŭ mơhư̆ du pơnuaĭ nư̆n, buơl guñu đờm: “'Buh tŭ lơi hũ pơnuaĭ yơu nư̆n ơu!” ");
INSERT INTO cje_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yàng Jêsu c̆ơ tơ buơl guñu sơ̆ng đờm: “Yơu nư̆n, pơnuaĭ lăm 'Bồn Bơ-àr Sơc̆ih-Sri wă ni hũ mơblàng hơgĕ: ‘Boh pơtơu mơnih khờh bơ̆-ngă sàng prah luơi, Hũ tơbiă jiơ̆ng pơtơu akiăng sàng.’ ");
INSERT INTO cje_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Aràng sơi lơbuh iơŭ pơtơu ni, nư̆n rơŭ kơđòng lơmuĭ-phư̆; pơtơu ni lĕ iơŭ aràng sơi, nư̆n rơŭ ngă lơmuĭ-phư̆ mơnih nư̆n!” ");
INSERT INTO cje_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt sơ̆ng du mơnih gơnuăr-pơto pơnuaĭ adăt-adia khiăng mă Pô tŭ nư̆n mư, kơyoa buơl guñu thơu Pô angui pơnuaĭ pơgăp-pơmơyơu nư̆n la đờm mư̆ng buơl guñu, bloh buơl guñu 'buh rơgơi ngă hơgĕ jiơ̆ng, kơyoa huơĭ tơ buơl làng. ");
INSERT INTO cje_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Buơl guñu kraŭ c̆ơ Pô sơ̆ng pơđăr du mơnih tui-tơkai ngă mơthĭ-lơ̆r yơu mơnih siàm tơpă, khiăng mă pơkăl Pô lăm pơnuaĭ đờm, tô jào Pô tơ gơnuăr apăn-akŏ plơi-lơgăr sơ̆ng lăm tơngàn kwăng apăn-akŏ du c̆àr lăm lơgăr. ");
INSERT INTO cje_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Du mơnih nư̆n tơnia Yàng Jêsu: “Ơ Pô-Pơto, buơl dơlhă thơu Pô-Pơto đờm sơ̆ng pơto tui pơnuaĭ tơpă, 'buh huơĭ-kơmlưh tơ aràng sơi, mă pơnuaĭ tơpă bloh pơto-pơsài jơlàn sơnah Yàng Pô Lơngì. ");
INSERT INTO cje_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Yơu nư̆n, buơl dơlhă hũ păl daŭ jia tơ Sesa ơu?” ");
INSERT INTO cje_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","C̆ơ thơu loh-làng mư̆ng hơtai-hơtiàn blơ̆ lơ̆r buơl guñu, nư̆n Pô đờm: ");
INSERT INTO cje_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Brơi bĕ tơ Kơu c̆ơ sa boh priă. Boh priă ni hũ rơ̆p sơ̆ng angăn aràng sơi?” Buơl guñu đờm sơđồ: “Sesa.” ");
INSERT INTO cje_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Pô đờm: “Yơu nư̆n, phơ̆n Sesa bơ-yàr wơ̆ bĕ tơ Sesa, phơ̆n Yàng Pô Lơngì bơ-yàr wơ̆ bĕ tơ Yàng Pô Lơngì.” ");
INSERT INTO cje_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Tơ anaŭ buơl làng, buơl guñu 'buh rơgơi mă pơkăl Pô sa pơnuaĭ lơi jiơ̆ng. Buơl guñu mă ngă krơi-takơtuă biă mư̆ng pơnuaĭ Pô đờm sơđồ, nư̆n păl dò kơđơ̆ng rik. ");
INSERT INTO cje_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Hũ du mơnih Sađuse, la du mơnih đờm lài 'buh hũ pơnuaĭ hơdiŭ wơ̆, truh sơ̆ng Yàng Jêsu, bloh tơnia Pô: ");
INSERT INTO cje_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Ơ Pô-Pơto, Môise hũ wă pơnuaĭ adăt-adia ni tơ buơl dơlhă: ‘Yah sa aràng mơnih lơkơi hũ adơi-ai drơi mơtai, luơi sơdiŭ wơ̆, 'buh hũ anà, nư̆n mơnih adơi-ai nư̆n păl khiăng sơ̆ng kơmơi bơdrau nư̆n tô hũ anà pơtui jơi tơ adơi-ai drơi.’ ");
INSERT INTO cje_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Lăm sàng-dơnò dih hũ tơjuh aràng adơi-ai lơkơi, mơnih sơ-ai kơc̆ua khiăng kơmơi bloh nư̆n mơtai, 'buh hũ anà. ");
INSERT INTO cje_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Mơnih dua, ");
INSERT INTO cje_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","bloh nư̆n truh mơnih klơu kŭng khiăng sơ̆ng mơnih kơmơi nư̆n; abih tơjuh aràng adơi-ai kŭng yơu nư̆n rơi, aràng sơi kŭng khiăng sơ̆ng mơnih kơmơi nư̆n soh, sơ̆ng kŭng mơtai, 'buh hũ anà. ");
INSERT INTO cje_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Hơdơi luĭ, mơnih kơmơi nư̆n kŭng mơtai. ");
INSERT INTO cje_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Yơu nư̆n lăm hơrơi hơdiŭ wơ̆, mơnih kơmơi nư̆n rơŭ la sơdiŭ aràng sơi? Kơyoa abih tơjuh aràng adơi-ai aràng sơi kŭng hũ khiăng sơ̆ng mơnih kơmơi nư̆n soh!” ");
INSERT INTO cje_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yàng Jêsu đờm: “Anà mơnih rài ni khiăng kơmơi puaĭ lơkơi, ");
INSERT INTO cje_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","bloh du mơnih hũ c̆ơ la iơŭ păl tô đồ-mă pơnuaĭ lơngai-pơtuah rài hơdơi, sơ̆ng hũ hơdiŭ wơ̆ mư̆ng pơnuaĭ mơtai, nư̆n 'buh khiăng kơmơi halài puaĭ lơkơi. ");
INSERT INTO cje_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Buơl guñu rơŭ 'buh mơtai tra, kơyoa mơhiơ̆ yơu du mơnih gơdrưh, sơ̆ng la anà Yàng Pô Lơngì, nư̆n la anà pơnuaĭ hơdiŭ wơ̆. ");
INSERT INTO cje_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Dò mư̆ng bruă mơnih mơtai hơdiŭ wơ̆, nư̆n rùp-phŭn Môise kŭng hũ brơi thơu lăm tăl bơ-àr đờm mư̆ng puk druơi, tŭ ñu iơu Yàng la Yàng Pô Lơngì Abraham, Yàng Pô Lơngì Isak, sơ̆ng Yàng Pô Lơngì Jakôp. ");
INSERT INTO cje_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Yơu nư̆n, Pô 'buh iơŭ la Yàng Pô Lơngì mơnih mơtai, bloh la Yàng Pô Lơngì mơnih hơdiŭ. Kơyoa sơ̆ng Pô, abih tơgrơ̆ mơnih la dò hơdiŭ.” ");
INSERT INTO cje_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Hũ du mơnih gơnuăr-pơto pơnuaĭ adăt-adia đờm sơ̆ng Pô: “Ơ Pô-Pơto, Pô-Pơto đờm iơŭ biă!” ");
INSERT INTO cje_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Sơ̆ng buơl guñu 'buh khĭn tơnia Pô pơnuaĭ hơgĕ tra. ");
INSERT INTO cje_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yàng Jêsu tơnia buơl guñu: “Kơđa hơgĕ aràng đờm Pô Krist la anà pơtau Đabit? ");
INSERT INTO cje_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Lăm tŭ rùp-phŭn pơtau Đabit hũ đờm lăm 'bồn bơ-àr pơnuaĭ Pơđik Adoh Mơyòm lài: ‘Yàng đờm sơ̆ng Yàng dơlhă: Dò guh bĕ gah hơnuă Kơu, ");
INSERT INTO cje_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Tơ̆l truh tơ tŭ Kơu daŭ du mơnih mơbai-tămdră sơ̆ng Anà ngă gơnŭl tơ ala tơkai Anà.’ ");
INSERT INTO cje_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Yơu nư̆n, pơtau Đabit hũ iơu Pô la Yàng, nư̆n ngă hơyơu Pô la anà pơtau nư̆n jiơ̆ng?” ");
INSERT INTO cje_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Lăm tŭ buơl làng dò păng, nư̆n Yàng Jêsu đờm sơ̆ng du mơnih tui-mơgru Pô: ");
INSERT INTO cje_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Păl c̆ơ-kơrhia bĕ mư̆ng du mơnih gơnuăr-pơto pơnuaĭ adăt-adia, la du mơnih khiăng c̆ù ào jruh nau-nau mơrai-mơrai; khiăng hũ aràng tơnia c̆uă drơi tơkrah du anih drà, khiăng dò guh tơ du anih prŏng-màng rơlau abih lăm sàng pơtòm, sơ̆ng khiăng dò guh tơ du c̆ơnừng akŏ lăm anih mơñŭm 'bơ̆ng. ");
INSERT INTO cje_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Buơl guñu pơ̆ng-gơla klĕ-mă abih sàng dơnò du mơnih kơmơi bơdrau, bloh tŭ lơi kŭng ngă mơthĭ-lơ̆r yơu drơi la du mơnih sơc̆ih-tơpă sơ̆ng bruă pơrpoh-c̆ơ du pơnuaĭ iơu-lài atàh sơ̆ng suơi. Buơl guñu rơŭ kơđòng ngă glài traŭ rơlau!” ");
INSERT INTO cje_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yàng Jêsu c̆ơ tơ ngŏ sơ̆ng 'buh lô mơnih mơda daŭ priă pơyă lăm thŭng priă. ");
INSERT INTO cje_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Pô kŭng 'buh sa aràng kơmơi bơdrau rơ'bah daŭ lăm nư̆n dua su priă kòng. ");
INSERT INTO cje_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Pô đờm: “Iơŭ biă Kơu đờm sơ̆ng buơl guhã, mơnih kơmơi bơdrau rơ'bah ni hũ daŭ lăm thŭng priă pơyă lô rơlau tơ abih tơgrơ̆ mơnih pơkơ̆n. ");
INSERT INTO cje_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Kơyoa abih du mơnih pơkơ̆n mă phơ̆n-priă dơlah drơi bloh pơyă, dò mơnih kơmơi bơdrau ni, yah siơŭ rơ'bah biă, bloh hũ pơyă abih tơgrơ̆ hơgĕ ñu hũ tô ròng hơdiŭ drơi.” ");
INSERT INTO cje_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Tŭ hũ du mơnih đờm mư̆ng bruă sàng duh-dơlbăt hũ ngă mơkrư sơ̆ng du pơtơu mơkrư, kŭng yơu du phơ̆n màng aràng hũ pơyă, Yàng Jêsu đờm: ");
INSERT INTO cje_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Rơŭ hũ hơrơi abih tơgrơ̆ hơgĕ buơl guhã 'buh ni rơŭ kơđòng jơrlơh-tơrlŭng abih, 'buh dò sa boh pơtơu lơi rờng tơ ngŏ boh pơtơu pơkơ̆n.” ");
INSERT INTO cje_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Buơl guñu tơnia Pô: “Ơ Pô-Pơto, tŭ lơi du bruă ni rơŭ tơbiă truh, sơ̆ng hũ nàl lơi brơi thơu dơlhơu du bruă nư̆n kơjĕ tơbiă truh ơu?” ");
INSERT INTO cje_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yàng Jêsu đờm: “Păl c̆ơ-kơrhia bĕ, juơi luơi aràng sơi pơluơ pơ̆ng-gơla buơl guhã, kơyoa hũ lô mơnih rơŭ mă angăn Kơu truh bloh đờm lài: ‘Rùp-phŭn kơu la Pô Krist,’ sơ̆ng ‘Hơrơi-tŭ hũ truh jĕ bơjơ!’ Buơl guhã juơi tui buơl guñu. ");
INSERT INTO cje_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Tŭ buơl guhã mơhư̆ đờm mư̆ng pơnuaĭ mơsuh-mơtă, pơnuaĭ kơprah-kơprĭng nư̆n juơi kìr-huơĭ, kơyoa du bruă ni păl tơbiă truh dơlhơu, bloh ka iơŭ la luĭ-dŭt mư ơu.” ");
INSERT INTO cje_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Bloh nư̆n Pô đờm sơ̆ng buơl guñu: “Buơl làng ni rơŭ tơgồ tămdră-wơ̆ sơ̆ng buơl làng pơkơ̆n, lơgăr ni tămdră-wơ̆ sơ̆ng lơgăr dih. ");
INSERT INTO cje_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Rơŭ hũ pơnuaĭ tơtuơ̆n-jơrlơh lơ̆n-tơnah prŏng, sơ̆ng lô anih rơŭ hũ ờ lơpa sơ̆ng suh-ru; kŭng rơŭ hũ du bruă kìr-huơĭ biă sơ̆ng du nàl-c̆rih prŏng tơ ngŏ lơngì. ");
INSERT INTO cje_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Bloh dơlhơu tŭ du bruă nư̆n tơbiă truh, kơyoa mư̆ng angăn Kơu aràng rơŭ mă-pơkơŭ sơ̆ng ngă jơhà biă tơ buơl guhã. Buơl guñu rơŭ mă jào buơl guhã tơ du sàng pơtòm, sơ̆ng mă buơl guhã krơ̆ lăm sàng jàm. Buơl guhã rơŭ kơđòng hua truh tơ anaŭ du pơtau sơ̆ng du kwăng apăn-akŏ c̆àr lăm lơgăr. ");
INSERT INTO cje_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ni rơŭ la tŭ hơnàn-siàm tô buơl guhã ngă grơh mư̆ng Pơnuaĭ-Siàm tơ buơl guñu. ");
INSERT INTO cje_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Yơu nư̆n, buơl guhã pioh-sơdơ̆r nĭ-nùn bĕ lăm hơtai-akŏ pơnuaĭ ni: juơi sơnư̆ng kơ-ù dơlhơu păl đờm hơgĕ tô dŏng rùp-phŭn drơi, ");
INSERT INTO cje_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","kơyoa Kơu rơŭ brơi tơ buơl guhã kơtha-pơnuaĭ đờm găm sơ̆ng pơnuaĭ jak-khờh, ngă tơ abih du mơnih mơbai-tămdră sơ̆ng buơl guhã 'buh hũ rơgơi tămdră-wơ̆ halài pơkăl-c̆ơkhă jiơ̆ng. ");
INSERT INTO cje_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Buơl guhã rơŭ kơđòng ame ama, adơi-ai, gơŭ pơtiàn, sơ̆ng adơi-ai gơŭ drơi mă jào. Buơl guñu rơŭ ngă tơ lô mơnih lăm buơl guhã păl mơtai. ");
INSERT INTO cje_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Buơl guhã rơŭ kơđòng tơgrơ̆ mơnih mơbai-lơmù kơyoa mư̆ng angăn Kơu. ");
INSERT INTO cje_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Bloh sa dĕt 'bù tơ akŏ buơl guhã kŭng 'buh lơhiă ơu. ");
INSERT INTO cje_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Gơnừm tơ pơnuaĭ kơjăp hơtai-hơtiàn kŏng ă-ư̆n bloh buơl guhã rơŭ păng-rơmiă jiơ̆ng bơngă-joa drơi.” ");
INSERT INTO cje_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Tŭ buơl guhã 'buh plơi-prŏng Jerusalem kơđòng tơrpuơl lĭng gơrwàng-c̆ơkhă tòmdăr, nư̆n thơu bĕ lài pơnuaĭ pơluĭ-pơlơhiă plơi-prŏng nư̆n kơjĕ truh bơjơ. ");
INSERT INTO cje_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Tŭ nư̆n, aràng sơi dò lăm c̆àr Juđe, đuaĭ dơŭ bĕ tơ ngŏ c̆ơ̆; aràng sơi dò lăm plơi-prŏng, đuaĭ tơbiă bĕ tơ agàh; aràng sơi dò tơ agàh plơi-prŏng, juơi gài tơma lăm plơi-prŏng. ");
INSERT INTO cje_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kơyoa nư̆n la du hơrơi Yàng Pô Lơngì ngă glài, hơrơi bloh abih tơgrơ̆ pơnuaĭ hơgĕ hũ wă rơŭ hũ tơbiă iơŭ tơpă. ");
INSERT INTO cje_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Lăm du hơrơi nư̆n, gleh-glăr dồn-să biă tơ du mơnih kơmơi hũ mơtiàn sơ̆ng du mơnih kơmơi hũ anà dò mơ̆m! Kơyoa rơŭ hũ pơnuaĭ rŭng-rài prŏng lăm lơ̆n, găm sơ̆ng pơnuaĭ anok-anoa prŏng tămdră-wơ̆ sơ̆ng buơl làng ni. ");
INSERT INTO cje_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Buơl guñu rơŭ lơbuh mơtai tơ ala mơta đào, sơ̆ng rơŭ kơđòng mă ba nau ngă hơlŭn-hơlă tơkrah du lơgăr. Plơi-prŏng Jerusalem rơŭ kơđòng kơtơ̆-juă kơyoa du buơl làng agàh, tơ̆l truh tŭ abih tŭ-hơrơi buơl làng agàh. ");
INSERT INTO cje_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Rơŭ hũ du nàl-c̆rih lăm ia-hơrơi, ia-blàn, sơ̆ng du ia-pơtŭ. Lăm ala lơ̆n, buơl làng tơgrơ̆ lơgăr rơŭ huơĭ-kơđa kìr kơ-ù, kơyoa săp ia-tơsì kơmrào-dơnài rơyà poh rơbù prŏng. ");
INSERT INTO cje_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Aràng rơŭ mơtai-sơrngă kơyoa huơĭ-kơđa lăm tŭ dò sơnư̆ng kơ-ù kraŭ-c̆àng tơgrơ̆ hơgĕ kơjĕ tơbiă truh tơ dun-ya, kơyoa du gơnăp-gơnuăr tơ ngŏ lơngì rơŭ tơtuơ̆n-mơgơi. ");
INSERT INTO cje_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Tŭ nư̆n aràng rơŭ 'buh Anà Mơnih mă gơnăp-gơnuăr sơ̆ng pơnuaĭ màng-kơc̆rà prŏng, mư̆ng ngŏ hwăl lơngì bloh truh. ");
INSERT INTO cje_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Tŭ buơl guhã 'buh du bruă nư̆n tơma tơbiă truh, dò dơ̆ng tơpă bĕ sơ̆ng tơ̆ akŏ tơ ngŏ, kơyoa pơnuaĭ dŏng-pơklàh buơl guhã hũ truh jĕ bơjơ.” ");
INSERT INTO cje_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Bloh nư̆n Yàng Jêsu đờm sơ̆ng buơl guñu sa pơnuaĭ pơgăp-pơmơyơu: “C̆ơ bĕ kơyơu hra sơ̆ng abih tơgrơ̆ jơi kơyơu pơkơ̆n. ");
INSERT INTO cje_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Tŭ sơla mơda tơmuh tơbiă, nư̆n buơl guhã thơu lài brơñàn phàng kơjĕ truh. ");
INSERT INTO cje_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Kŭng yơu nư̆n rơi, tŭ buơl guhã 'buh du pơnuaĭ nư̆n tơbiă truh, nư̆n thơu bĕ lài lơgăr Yàng Pô Lơngì hũ truh jĕ bơjơ. ");
INSERT INTO cje_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Iơŭ biă Kơu đờm sơ̆ng buơl guhã, jơi-pơtiàn ni rơŭ 'buh nau rơlau dơlhơu tơ tŭ tơgrơ̆ pơnuaĭ nư̆n tơbiă truh. ");
INSERT INTO cje_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Lơngì sơ̆ng tơnah rơŭ lơhiă abih, bloh pơnuaĭ Kơu đờm rơŭ 'buh tŭ lơi lơhiă ơu. ");
INSERT INTO cje_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Yơu nư̆n, buơl guhã păl c̆ơ-kơrhia, juơi luơi hơtai-hơtiàn drơi traŭ đơ̆i mư̆ng bruă mơñŭm 'bơ̆ng 'buh thơu-tư̆ng, mơbŭ-mơbèng, sơ̆ng du pơnuaĭ sơnư̆ng kơ-ù mư̆ng rài ni, bloh hơrơi nư̆n rơŭ mơre-mơro duă trŭn tơ ngŏ buơl guhã yơu kơđòng jàl trah, ");
INSERT INTO cje_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","kơyoa hơrơi nư̆n rơŭ truh tơ ngŏ abih tơgrơ̆ mơnih dò lăm abih tơgrơ̆ anih lăm lơ̆n-tơnah, kŭng yơu nư̆n rơi. ");
INSERT INTO cje_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Yơu nư̆n, păl mĭt-mĭt mơdơh-kraŭ sơ̆ng iơu-lài, tô buơl guhã hũ tơ̆l pràn bloh pleh klàh jiơ̆ng mư̆ng tơgrơ̆ pơnuaĭ rơŭ tơbiă truh, sơ̆ng hũ dò dơ̆ng kơjăp tơ anaŭ Anà Mơnih.” ");
INSERT INTO cje_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Glai hơrơi, Yàng Jêsu pơto-mơblàng lăm sàng duh-dơlbăt; bloh truh mơlăm, Pô tơbiă mư̆ng plơi-prŏng sơ̆ng dò mơlăm tơ ngŏ c̆ơ̆ angăn la c̆ơ̆ Ôlibe. ");
INSERT INTO cje_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Pơrpa rìng ờm, abih buơl làng truh sơ̆ng Pô lăm sàng duh-dơlbăt, tô păng Pô pơto-mơblàng. ");
INSERT INTO cje_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Hơrơi pơjŭm 'bơ̆ng Pah 'Buh Hũ Tơpơi, kŭng angăn la pơnuaĭ Pơjŭm 'Bơ̆ng Nau-Găn, hũ truh jĕ. ");
INSERT INTO cje_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt sơ̆ng du mơnih gơnuăr-pơto pơnuaĭ adăt-adia duah pơc̆òng bơ-yai pơnuaĭ tô pơmơtai Yàng Jêsu, kơyoa buơl guñu huơĭ tơ buơl làng. ");
INSERT INTO cje_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Tŭ nư̆n, kơmlài Satăn tơma lăm Juđa, angăn la Iskariôt, la sa aràng lăm tơrpuơl sa-pluh dua aràng mơnih tơdi-tơdài. ");
INSERT INTO cje_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ñu nau đờm tămbơyai sơ̆ng du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt sơ̆ng du mơnih gơnuăr apăn-akŏ tơrpuơl lĭng khiă-gàr sàng duh-dơlbăt, mư̆ng bruă hơyơu bloh ñu rơgơi jào Pô tơ buơl mơnih nư̆n. ");
INSERT INTO cje_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Du mơnih dih uơ̆n drơi biă, sơ̆ng đờm pơguăn rơŭ brơi priă tơ ñu. ");
INSERT INTO cje_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Juđa hũ sa hơtai sơ̆ng buơl guñu, sơ̆ng duah tŭ hơnàn-iơŭ tô jào Yàng Jêsu tơ buơl guñu, tŭ 'buh hũ tơrpuơl mơnih lô. ");
INSERT INTO cje_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Truh hơrơi pơjŭm 'bơ̆ng Pah 'Buh Hũ Tơpơi, la hơrơi aràng păl pơmơtai abo anà pơnuaĭ pơjŭm 'bơ̆ng Nau-Găn, ");
INSERT INTO cje_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yàng Jêsu pơđăr Pier sơ̆ng Jăng nau bloh đờm kơkơi: “Nau bĕ, rơc̆ăng pồ pơnuaĭ pơjŭm 'bơ̆ng Nau-Găn tô buơl gudrơi 'bơ̆ng.” ");
INSERT INTO cje_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Dua aràng buơl guñu tơnia: “Pô-Pơto khiăng buơl dơlhă rơc̆ăng pồ pơnuaĭ pơjŭm 'bơ̆ng nư̆n tơ anih lơi?” ");
INSERT INTO cje_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Pô đờm: “Tŭ tơma lăm plơi-prŏng, buơl guhã rơŭ tòm sa aràng mơnih đoa abŭ ia. Nau tui bĕ mơnih nư̆n. Mơnih nư̆n tơma sàng lơi, buơl guhã tui tơma bĕ sàng nư̆n, ");
INSERT INTO cje_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","sơ̆ng đờm sơ̆ng mơnih pô sàng lài: ‘Pô-Pơto tơnia hã lài: Adŭ thuai la anih Kơu rơŭ 'bơ̆ng pơnuaĭ pơjŭm 'bơ̆ng Nau-Găn sơ̆ng du mơnih tui-mơgru Kơu, tơ anih lơi?’ ");
INSERT INTO cje_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Mơnih pô sàng rơŭ pơto tơ buơl guhã sa adŭ prŏng tơ tăl ngŏ sàng, tơgrơ̆ phơ̆n angui hũ rơc̆ăng lờih abih bơjơ. Buơl guhã rơc̆ăng pồ bĕ pơnuaĭ pơjŭm 'bơ̆ng tơ anih nư̆n!” ");
INSERT INTO cje_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Dua aràng mơnih tui-mơgru nau sơ̆ng păp tơgrơ̆ pơnuaĭ iơŭ yơu Pô hũ đờm dơlhơu sơ̆ng buơl guñu; nư̆n buơl guñu rơc̆ăng pồ pơnuaĭ pơjŭm 'bơ̆ng Nau-Găn. ");
INSERT INTO cje_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Tŭ truh jơ, Yàng Jêsu dò guh lăm c̆ơnừng 'bơ̆ng, du mơnih tơdi-tơdài dò guh găm sơ̆ng Pô. ");
INSERT INTO cje_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Pô đờm sơ̆ng buơl guñu: “Kơu khiăng biă 'bơ̆ng pơnuaĭ pơjŭm 'bơ̆ng Nau-Găn ni sơ̆ng buơl guhã dơlhơu tŭ Kơu kŏng pơđì-pơđoa gleh-glăr. ");
INSERT INTO cje_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Kơyoa Kơu đờm sơ̆ng buơl guhã, Kơu rơŭ 'buh 'bơ̆ng pơnuaĭ pơjŭm 'bơ̆ng ni tra, tơ̆l truh tơ tŭ pơnuaĭ pơjŭm 'bơ̆ng ni hũ wĭl-tơ̆l lăm lơgăr Yàng Pô Lơngì.” ");
INSERT INTO cje_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Pô apăn c̆uàn, ưnjơmừn, bloh nư̆n đờm: “Mă bĕ sơ̆ng pơrpha tơ gơŭ. ");
INSERT INTO cje_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Kơyoa Kơu đờm sơ̆ng buơl guhã, mư̆ng ni Kơu rơŭ 'buh mơñŭm ia ño ni tra tơ̆l truh tơ tŭ lơgăr Yàng Pô Lơngì truh.” ");
INSERT INTO cje_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Bloh nư̆n Pô mă pah, ưnjơmừn, 'bĕt pơrpha tơ du mơnih tui-mơgru sơ̆ng đờm: “Ni la rùp-phàp Kơu, kơyoa mư̆ng buơl guhã bloh pơyă brơi. Ngă bĕ pơnuaĭ ni tô sơdơ̆r truh Kơu!” ");
INSERT INTO cje_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Hơdơi tŭ 'bơ̆ng, Pô kŭng ngă yơu nư̆n rơi, mă c̆uàn brơi tơ du mơnih tui-mơgru sơ̆ng đờm: “C̆uàn ni la pơnuaĭ Pơguăn-Pơđoàn Bơrhơu lăm drah Kơu, kơyoa mư̆ng buơl guhã bloh hŏ tơbiă. ");
INSERT INTO cje_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ni, tơngàn mơnih pơblơ̆-dră Kơu dò jĕ Kơu, anih c̆ơnừng 'bơ̆ng ni. ");
INSERT INTO cje_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Anà Mơnih nau yơu pơnuaĭ hũ ngă-nìn, bloh gleh-glăr dồn-să biă tơ mơnih pơblơ̆-dră Anà Mơnih!” ");
INSERT INTO cje_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Du mơnih tui-mơgru tơma tơnia gơŭ lăm tơrpuơl drơi aràng sơi la mơnih rơŭ ngă pơnuaĭ nư̆n. ");
INSERT INTO cje_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Du mơnih tui-mơgru tămpơrjai mơsau sơ̆ng gơŭ, c̆ơ aràng sơi la mơnih prŏng rơlau abih lăm tơrpuơl drơi. ");
INSERT INTO cje_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yàng Jêsu đờm sơ̆ng buơl guñu: “Du pơtau buơl làng agàh mă gơnuăr bloh apăn-akŏ buơl làng, sơ̆ng du mơnih apăn-akŏ ni pơ-angăn drơi la du mơnih ngă pơnuaĭ anĭt, du mơnih dŏng-kờl buơl làng. ");
INSERT INTO cje_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Bloh buơl guhã nư̆n 'buh iơŭ yơu nư̆n ơu. Mơnih prŏng rơlau abih tơkrah buơl guhã păl tơbiă jiơ̆ng yơu mơnih tìt rơlau abih, sơ̆ng mơnih apăn-akŏ păl tơbiă jiơ̆ng yơu mơnih duh bruă. ");
INSERT INTO cje_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Kơyoa tơkrah mơnih dò guh 'bơ̆ng sơ̆ng mơnih duh bruă, aràng sơi la mơnih prŏng rơlau? Hũ iơŭ la mơnih dò guh 'bơ̆ng ơu? Bloh Kơu dò tơkrah buơl guhã, Kơu hơdiŭ yơu sa aràng mơnih duh bruă. ");
INSERT INTO cje_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Buơl guhã la du mơnih hũ kơjăp sa hơtai-hơtiàn tui Kơu, tơkrah du tŭ Kơu păp pơnuaĭ pơlòng gleh-glăr. ");
INSERT INTO cje_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Kơyoa nư̆n, Kơu brơi lơgăr tơ buơl guhã, kŭng yơu Ama Kơu hũ brơi tơ Kơu rơi, ");
INSERT INTO cje_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","tô buơl guhã rơŭ hũ 'bơ̆ng mơñŭm găm sa boh c̆ơnừng sơ̆ng Kơu lăm lơgăr Kơu, sơ̆ng hũ dò guh tơ ngŏ sơbàn tô c̆ahrơña sa-pluh dua jơi-pơtiàn Israel.” ");
INSERT INTO cje_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Ơ Simôn, Simôn! Kơmlài Satăn hũ yòng gơnuăr tô pơlòng-ơñiai buơl guhã yơu aràng tơpơi pruh bơdai. ");
INSERT INTO cje_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Bloh Kơu hũ iơu-lài tơ hã, tô hã 'buh lơhiă pơnuaĭ păng-tui. Yơu nư̆n, hơdơi tŭ hã gài mơrai wơ̆, ngă bĕ tơ buơl adơi-ai drơi pràn-kơjăp pơnuaĭ păng-tui.” ");
INSERT INTO cje_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pier đờm sơ̆ng Pô: “Ơ Yàng, dơlhă hũ rơc̆ăng lờih hơtai-hơtiàn tô nau sơ̆ng Yàng, yah păl kŏng jàm-krơ̆ halài păl kŏng mơtai sơ̆ng Yàng.” ");
INSERT INTO cje_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yàng Jêsu đờm: “Ơ Pier, Kơu đờm tơ hã thơu, hơrơi ni, dơlhơu tŭ mơnŭ kơ-iòk, hã rơŭ klơu amăng đờm kơmlah la hã 'buh thơu Kơu!” ");
INSERT INTO cje_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Bloh nư̆n Yàng Jêsu đờm sơ̆ng du mơnih tui-mơgru Pô: “Tŭ Kơu pơđăr buơl guhã nau, 'buh apăn tui kơdŭng priă, kơdŭng, halài tơkhŏ kơjuă, buơl guhã hũ siơŭ hơgĕ ơu?” Du mơnih tui-mơgru đờm lài: “'Buh siơŭ hơgĕ ơu!” ");
INSERT INTO cje_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Pô đờm: “Bloh tŭ ni, aràng sơi hũ kơdŭng priă nư̆n apăn tui bĕ, aràng sơi hũ kơdŭng kŭng yơu nư̆n rơi. Aràng sơi 'buh hũ đào, nư̆n pơblơi bĕ ào agàh bloh blơi sa 'bĕ đào. ");
INSERT INTO cje_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Kơyoa Kơu đờm sơ̆ng buơl guhã, pơnuaĭ 'Bồn Bơ-àr Sơc̆ih-Sri ni păl hũ tơbiă iơŭ tơpă lăm Kơu: ‘Guñu hũ ngă tơ Pô yơu ngă tơ sa aràng mơnih hũ glài-sơnoh.’ Biă yơu nư̆n, tơgrơ̆ hơgĕ hũ wă mư̆ng Kơu păl tơbiă iơŭ tơpă.” ");
INSERT INTO cje_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Du mơnih tui-mơgru đờm: “Khoai Yàng, ni hũ dua 'bĕ đào.” Pô đờm: “Nư̆n kŭng tơ̆l bơjơ!” ");
INSERT INTO cje_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Hơdơi mư̆ng nư̆n, Yàng Jêsu tơbiă nau, sơ̆ng tui lơđăp-bơhiàn, Pô nau truh tơ c̆ơ̆ Ôlibe. Du mơnih tui-mơgru nau tui Pô. ");
INSERT INTO cje_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Tŭ truh anih, Pô đờm sơ̆ng buơl guñu: “Păl iơu-lài bĕ tô buơl guhã 'buh kơđòng lĕ-tơma lăm pơnuaĭ pơluơ-ơñiai.” ");
INSERT INTO cje_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Bloh nư̆n Pô nau đoh mư̆ng anih buơl guñu pơgăp atàh kàr prah sa boh pơtơu. Pô c̆ĕ tơ-ù trŭn sơ̆ng iơu-lài: ");
INSERT INTO cje_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Khoai Ama, yah Ama khiăng, yòng suă c̆uàn pơnuaĭ pơđì-pơđoa gleh-glăr ni klàh mư̆ng Anà! Bloh yah yơu nư̆n, yòng hơtai-khiăng Ama hũ jiơ̆ng, 'buh iơŭ tui hơtai-khiăng Anà.” ");
INSERT INTO cje_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Tŭ nư̆n hũ sa aràng mơnih gơdrưh mư̆ng ngŏ lơngì truh sơ̆ng pơtơ̆l pràn tơ Pô. ");
INSERT INTO cje_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Lăm pơnuaĭ pơđì-pơđoa dơnuh-dơnà, Pô iơu-lài 'brŏ abih pràn-hơtai, ia sơ-uh Pô tơbiă jiơ̆ng yơu du tơ-ioh drah, hŏ trŭn tơ ala lơ̆n. ");
INSERT INTO cje_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Tŭ iơu-lài abih, Pô tơgồ dơ̆ng, truh tơ anih du mơnih tui-mơgru, 'buh buơl guñu dò đih kơyoa dơnuh-dơnà biă. ");
INSERT INTO cje_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Pô đờm sơ̆ng buơl guñu: “Kơđa hơgĕ buơl guhã đih? Tơgồ bloh iơu-lài bĕ, tô buơl guhã 'buh lĕ-tơma lăm pơnuaĭ pơluơ-ơñiai!” ");
INSERT INTO cje_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Lăm tŭ Yàng Jêsu dò đờm, nư̆n dih, sa tơrpuơl mơnih lô ba gơŭ truh. Nau dơlhơu ba akŏ la Juđa, sa aràng lăm tơrpuơl sa-pluh dua aràng mơnih tơdi-tơdài. Ñu truh jĕ Yàng Jêsu tô c̆ŭm Pô. ");
INSERT INTO cje_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Bloh Yàng Jêsu đờm: “Ơ Juđa, hã mă pơnuaĭ c̆ŭm tô pơblơ̆-dră Anà Mơnih?” ");
INSERT INTO cje_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Du mơnih dò sơ̆ng Pô 'buh bruă kơjĕ tơbiă truh, nư̆n đờm sơ̆ng Pô: “Ơ Yàng, buơl dơlhă păl angui đào tô tămngă ơu?” ");
INSERT INTO cje_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Sa aràng lăm tơrpuơl buơl guñu tă hơlŭn-hơlă mơnih gơnuăr prŏng apăn-akŏ pơyă phơ̆n duh-dơlbăt kloh tơnia gah hơnuă. ");
INSERT INTO cje_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Bloh Yàng Jêsu đờm: “Luơi, juơi ngă tra!” Sơ̆ng Pô rơwơ̆ tơ tơnia mơnih hơlŭn-hơlă nư̆n sơ̆ng pơsồ-pơsaih tơ ñu. ");
INSERT INTO cje_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Bloh nư̆n Yàng Jêsu đờm sơ̆ng du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt, du mơnih apăn-akŏ tơrpuơl lĭng khiă-gàr sàng duh-dơlbăt, sơ̆ng du mơnih gơnuăr-tha truh mă Pô: “Kơđa hơgĕ buơl guhã apăn đào-sơdrà sơ̆ng gai-hwai truh mă Kơu yơu mă mơnih klĕ blơ̆? ");
INSERT INTO cje_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Hơrơi hơrơi Kơu dò lăm sàng duh-dơlbăt sơ̆ng buơl guhã, bloh buơl guhã 'buh mă Kơu. Bloh ni la jơ buơl guhã, sơ̆ng gơnuăr pơnuaĭ mơsrư̆-kơnăm.” ");
INSERT INTO cje_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Buơl guñu mă Yàng Jêsu sơ̆ng ba Pô nau; buơl guñu ba Pô truh tơ sàng mơnih gơnuăr prŏng apăn-akŏ pơyă phơ̆n duh-dơlbăt. Pier nau tui Pô đoh-đoh. ");
INSERT INTO cje_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Buơl guñu c̆uh apui tơkrah 'blàng, bloh nư̆n dò guh sơ̆ng gơŭ, Pier kŭng dò guh sơ̆ng buơl guñu rơi. ");
INSERT INTO cje_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Sa aràng mơnih hơlŭn-hơlă kơmơi 'buh Pier dò guh jĕ apui, nư̆n c̆ơ kơnăl Pier nĭ-nùn sơ̆ng đờm: “Mơnih ni kŭng dò sơ̆ng mơnih nư̆n rơi!” ");
INSERT INTO cje_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Bloh Pier kơmlah mư sơ̆ng đờm: “Ni kơmơi dih, kơu 'buh thơu mơnih nư̆n ơu!” ");
INSERT INTO cje_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Hơdơi mư̆ng nư̆n 'buh suơi, hũ mơnih pơkơ̆n 'buh Pier sơ̆ng đờm: “Hã kŭng la sa aràng mơnih găm lăm tơrpuơl mơnih nư̆n rơi!” Bloh Pier đờm: “Ni sơ-ai, kơu 'buh iơŭ la mơnih lăm tơrpuơl nư̆n ơu!” ");
INSERT INTO cje_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Pơgăp sa jơ hơdơi, hũ sa aràng mơnih pơkơ̆n đờm nìn biă lài: “Mơnih ni iơŭ tơpă biă kŭng la mơnih dò sơ̆ng Jêsu rơi, kơyoa ñu la mơnih Galile.” ");
INSERT INTO cje_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Bloh Pier đờm: “Ni sơ-ai, kơu 'buh thơu sơ-ai đờm hơgĕ!” Lăm tŭ Pier dò đờm, nư̆n mơnŭ kơ-iòk. ");
INSERT INTO cje_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Yàng pơtrah wơ̆ c̆ơ Pier. Pier sơdơ̆r wơ̆ pơnuaĭ Yàng hũ đờm sơ̆ng drơi lài: “Hơrơi ni, dơlhơu tŭ mơnŭ ka kơ-iòk, hã rơŭ klơu amăng đờm kơmlah la hã 'buh thơu Kơu.” ");
INSERT INTO cje_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pier nau tơbiă tơ agàh sơ̆ng hia-c̆ŏ pơđì-pơđoa biă. ");
INSERT INTO cje_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Tŭ nư̆n, du mơnih khiă-gàr Yàng Jêsu klau-pơtăt sơ̆ng pờng-ngă Pô. ");
INSERT INTO cje_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Buơl guñu kơbơ̆ mơta Pô wơ̆, bloh nư̆n tơnia: “C̆ơ đờm hwơ̆r bĕ, aràng sơi ngă hã nư̆n?” ");
INSERT INTO cje_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Buơl guñu dò đờm sơk-sơrbĭl klau-pơtăt Pô lô pơnuaĭ pơkơ̆n wơ̆. ");
INSERT INTO cje_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Truh ờm hơrơi hơdơi, du mơnih gơnuăr-tha lăm buơl làng, du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt, sơ̆ng du mơnih gơnuăr-pơto pơnuaĭ adăt-adia pơgùm-pơtòm gơŭ wơ̆, bloh nư̆n buơl guñu ba Yàng Jêsu truh tơ anaŭ Tơrpuơl Gơnuăr Apăn-Akŏ Buơl Làng Juđa. ");
INSERT INTO cje_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Buơl guñu tơnia Pô: “Yah hã la Pô Krist, nư̆n đờm bĕ tơ buơl gukơu thơu.” Pô đờm: “Yah Kơu đờm, buơl guhã kŭng 'buh păng-tui; ");
INSERT INTO cje_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","yah Kơu tơnia, buơl guhã kŭng 'buh đờm sơđồ. ");
INSERT INTO cje_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Bloh mư̆ng ni truh hơdơi, Anà Mơnih rơŭ dò guh tơ gah hơnuă Yàng Pô Lơngì gơnăp-gơnuăr.” ");
INSERT INTO cje_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Abih buơl guñu tơnia: “Yơu nư̆n hã la anà Yàng Pô Lơngì?” Pô đờm: “Iơŭ yơu buơl guhã đờm, Kơu la Pô nư̆n.” ");
INSERT INTO cje_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Buơl guñu đờm: “Tŭ ni buơl gudrơi c̆àng hơgĕ mơnih ngă grơh tra? Rùp-phŭn buơl gudrơi hũ mơhư̆ mư̆ng kàng ñu đờm tơbiă bơjơ!” ");
INSERT INTO cje_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Tŭ nư̆n, abih tơrpuơl mơnih lô tơgồ dơ̆ng, ba Yàng Jêsu truh tơ anaŭ Pilat. ");
INSERT INTO cje_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Buơl guñu tơma đờm yă Pô lài: “Buơl dơlhă hũ 'buh mơnih ni pơsŭt-pơđăr buơl làng lăm lơgăr buơl dơlhă, pơkơŭ 'buh brơi buơl dơlhă daŭ jia tơ Sesa, sơ̆ng ñu pơ-angăn rùp-phŭn ñu la Pô Krist, nư̆n la Pơtau!” ");
INSERT INTO cje_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilat tơnia Pô: “Hã hũ iơŭ la Pơtau buơl làng Juđa ơu?” Yàng Jêsu đờm sơđồ: “Iơŭ yơu kơi đờm.” ");
INSERT INTO cje_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilat đờm sơ̆ng du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt sơ̆ng tơrpuơl buơl làng: “Kơu 'bu 'buh mơnih ni hũ glài-sơnoh hơgĕ!” ");
INSERT INTO cje_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Bloh buơl guñu sa pơnuaĭ đờm nìn lài: “Mơnih ni pơsŭt-pơđăr buơl làng, pơto-akhàn lăm abih c̆àr Juđe, tơma c̆ơmrừp mư̆ng c̆àr Galile tơ̆l truh tơ anih ni.” ");
INSERT INTO cje_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Tŭ mơhư̆ yơu nư̆n, Pilat tơnia hũ iơŭ Pô la mơnih Galile ơu. ");
INSERT INTO cje_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Tŭ thơu Pô dò tơ ala gơnuăr pơtau Herôt apăn-akŏ, nư̆n Pilat pơđăr ba bơnau Pô tơ pơtau Herôt, tŭ nư̆n kŭng hũ mơta lăm Jerusalem rơi. ");
INSERT INTO cje_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herôt 'buh Yàng Jêsu nư̆n sờh-sài biă, kơyoa suơi ni bơjơ pơtau hũ mơhư̆ đờm mư̆ng Pô, nư̆n khiăng tòm Pô sơ̆ng kŭng khiăng c̆ơ Pô ngă pơnuaĭ-c̆rih. ");
INSERT INTO cje_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Kơyoa nư̆n, pơtau tơnia Pô lô pơnuaĭ, bloh Pô 'buh đờm sơđồ hơgĕ. ");
INSERT INTO cje_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt sơ̆ng du mơnih gơnuăr-pơto pơnuaĭ adăt-adia dò dơ̆ng jĕ tơ anih nư̆n, đờm yă Pô pràn mơsak biă. ");
INSERT INTO cje_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herôt sơ̆ng tơrpuơl lĭng ñu c̆ơ 'buh sơ̆p tơ Pô sơ̆ng klau-pơtăt Pô. Buơl guñu pơc̆ù tơ Pô sa blah ào bơnga c̆ơlìr-c̆ơlàr, bloh nư̆n ba jào Pô wơ̆ tơ Pilat. ");
INSERT INTO cje_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Dơlhơu thrơi, Pilat sơ̆ng Herôt mơbai-lơmù gơŭ, bloh lăm hơrơi nư̆n buơl guñu tơbiă jiơ̆ng adơi-ai gơŭ. ");
INSERT INTO cje_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilat pơgùm-pơtòm abih du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt, du mơnih gơnuăr apăn-akŏ, sơ̆ng buơl làng wơ̆, bloh đờm lài: ");
INSERT INTO cje_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","“Buơl guhã ba jào mơnih ni tơ kơu, mư̆ng glài ñu pơsŭt-pơđăr buơl làng tơgồ ngă klùk-klờk; bloh kơu hũ tơnia-khào tơ anaŭ buơl guhã, nư̆n 'bu 'buh mơnih ni hũ ngă sa pơnuaĭ glài lơi yơu buơl guhã hũ đờm yă. ");
INSERT INTO cje_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herôt kŭng 'buh yơu nư̆n rơi, kơyoa pơtau hũ jào ñu mơrai wơ̆ tơ kơu. Yơu nư̆n, mơnih ni 'buh hũ ngă pơnuaĭ hơgĕ păl mơtai. ");
INSERT INTO cje_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Nư̆n kơu rơŭ glih-atòng, bloh nư̆n toh luơi ñu nau.” ");
INSERT INTO cje_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Tŭ nư̆n, lăm yàu pơnuaĭ pơjŭm 'bơ̆ng prŏng, Pilat jiăng hũ adăt-lơđăp toh-tơleh tơ buơl làng sa aràng mơnih glài jàm. ");
INSERT INTO cje_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Bloh abih tơgrơ̆ mơnih sơ̆ng gơŭ driau prŏng: “Pơmơtai mơnih nư̆n bĕ, sơ̆ng toh-tơleh 'Baraba tơ buơl dơlhă!” ");
INSERT INTO cje_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","'Baraba la mơnih hũ kŏng jàm kơyoa glài tơgồ ngă klùk-klờk lăm plơi-prŏng, sơ̆ng kơyoa glài pơmơtai mơnih. ");
INSERT INTO cje_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilat khiăng toh-tơleh Yàng Jêsu, nư̆n đờm sơ̆ng buơl làng sa amăng tra wơ̆. ");
INSERT INTO cje_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Bloh buơl guñu kừ driau kơmrào prŏng: “Pơ̆ng ñu tơ kơyơu pơkăl! Pơ̆ng ñu tơ kơyơu pơkăl!” ");
INSERT INTO cje_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilat tơnia buơl guñu amăng klơu wơ̆: “Kơđa hơgĕ? Mơnih ni hũ ngă pơnuaĭ mơsak-jơhà hơgĕ? Kơu 'buh duah hũ mơnih ni ngă glài hơgĕ tô păl mơtai. Kơyoa nư̆n, kơu rơŭ pơđăr glih-atòng bloh nư̆n toh luơi ñu nau!” ");
INSERT INTO cje_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Bloh buơl guñu 'brŏ driau kơmrào prŏng rơlau wơ̆, ngă-nìn đồ păl pơ̆ng Pô tơ kơyơu pơkăl, sơ̆ng săp buơl guñu driau kơmrào hũ pha-jai rơlau. ");
INSERT INTO cje_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pilat ngă nìn-glài tui yơu pơnuaĭ buơl guñu yòng. ");
INSERT INTO cje_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ñu toh-tơleh 'Baraba, mơnih glài jàm bloh buơl guñu hũ yòng, la mơnih hũ kŏng jàm kơyoa glài tơgồ ngă klùk-klờk lăm plơi-prŏng sơ̆ng pơmơtai mơnih. Dò Yàng Jêsu, nư̆n Pilat jào tơ buơl guñu tui hơtai buơl guñu khiăng. ");
INSERT INTO cje_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Tŭ ba Yàng Jêsu nau, buơl guñu mă sa aràng mơnih Siren, angăn la Simôn, pơrpa mư̆ng plơi đì tơ Jerusalem, sơ̆ng mă pơkơŭ ñu păl glăm kơyơu pơkăl nau tui hơdơi Yàng Jêsu. ");
INSERT INTO cje_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Hũ tơrpuơl buơl làng lô biă nau tui Yàng Jêsu, lăm tơrpuơl mơnih nư̆n hũ lô mơnih kơmơi sơrđŭ hărda hia-anĭt mư̆ng Pô. ");
INSERT INTO cje_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Bloh Yàng Jêsu pơtrah wơ̆ đờm sơ̆ng buơl guñu: “Ơ anà kơmơi Jerusalem! Juơi hia mư̆ng Kơu, bloh hia bĕ mư̆ng rùp-phŭn buơl guhã sơ̆ng anà-tơc̆o buơl guhã. ");
INSERT INTO cje_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kơyoa ni, du hơrơi truh, aràng rơŭ đờm: ‘Lơngai-pơtuah tơ du mơnih kơmơi kơtuăl, tơ du mơnih 'buh đih apui bă anà, sơ̆ng tơ du mơnih kơmơi 'buh hũ anà tô brơi mơ̆m!’ ");
INSERT INTO cje_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Tŭ nư̆n aràng rơŭ đờm sơ̆ng c̆ơ̆ lài: ‘Jơrlơh trŭn bĕ tơ ngŏ buơl dơlhă!’ đờm sơ̆ng bồt lài: ‘Ac̆ĭng-tơrđơŭ bĕ buơl dơlhă!’ ");
INSERT INTO cje_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kơyoa yah aràng hũ ngă yơu ni sơ̆ng kơyơu săt, nư̆n kơyơu thu rơŭ hơyơu lơi?” ");
INSERT INTO cje_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Buơl guñu kŭng ba dua aràng mơnih glài pơkơ̆n nau rơi, la du mơnih klĕ blơ̆, tô pơmơtai găm sơ̆ng Pô. ");
INSERT INTO cje_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Tŭ truh tơ sa anih angăn la anih Brò Akŏ, buơl guñu pơ̆ng Pô lăm kơyơu pơkăl, găm sơ̆ng dua aràng mơnih ngă glài klĕ blơ̆, sa aràng pơ̆ng tơ kơyơu pơkăl gah hơnuă sơ̆ng sa aràng pơ̆ng tơ kơyơu pơkăl gah ơñiau Pô. ");
INSERT INTO cje_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Tŭ nư̆n Yàng Jêsu đờm: “Khoai Ama, yòng anĭt toh-luơi tơ buơl guñu, kơyoa buơl guñu 'buh thơu drơi ngă pơnuaĭ hơgĕ.” Bloh nư̆n buơl guñu suă-khà tô pơrpha gơŭ ào agàh Pô. ");
INSERT INTO cje_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Buơl làng dò dơ̆ng c̆ơ, dò du mơnih apăn-akŏ nư̆n đờm klau-pơtăt Pô lài: “Ñu hũ dŏng mơnih pơkơ̆n jiơ̆ng. Yah ñu biă la Pô Krist, Pô hũ Yàng Pô Lơngì rơwah, nư̆n c̆ơ luơi ñu dŏng bĕ rùp-phŭn drơi!” ");
INSERT INTO cje_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Buơl lĭng kŭng klau-pơtăt Pô. Guñu truh jĕ, mă ia mơsăm brơi tơ Pô mơñŭm, ");
INSERT INTO cje_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","sơ̆ng đờm: “Yah hã la Pơtau buơl làng Juđa, nư̆n c̆ơ dŏng bĕ rùp-phŭn drơi!” ");
INSERT INTO cje_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Gah ngŏ akŏ Pô, hũ sa blơ kơmàn wă: MƠNIH NI LA PƠTAU BUƠL LÀNG JUĐA. ");
INSERT INTO cje_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Sa aràng lăm dua aràng mơnih glài klĕ blơ̆ kơđòng pơ̆ng tơ kơyơu pơkăl jĕ sơ̆ng Pô, kŭng đờm klau-pơtăt Pô lài: “Hã 'buh iơŭ la Pô Krist ơu? C̆ơ dŏng bĕ rùp-phŭn drơi sơ̆ng dŏng găm buơl dơlhă rơi!” ");
INSERT INTO cje_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Bloh mơnih dih đờm puaĭ tơ ñu: “Hã kŭng kŏng găm sa pơnuaĭ ngă glài bloh dò 'buh thơu huơĭ tơ Yàng Pô Lơngì ơu? ");
INSERT INTO cje_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Buơl gudrơi kŏng yơu ni la iơŭ păl biă, kơyoa pơnuaĭ ngă glài buơl gudrơi kŏng iơŭ păl sơ̆ng bruă buơl gudrơi ngă; bloh Mơnih ni 'buh hũ ngă sa pơnuaĭ hơgĕ sŭng asŭ ơu!” ");
INSERT INTO cje_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Bloh nư̆n ñu đờm sơ̆ng Yàng Jêsu: “Khoai Pô Jêsu, tŭ Pô truh lăm lơgăr drơi bơjơ, yòng sơdơ̆r truh dơlhă!” ");
INSERT INTO cje_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yàng Jêsu đờm sơ̆ng ñu: “Iơŭ biă, Kơu đờm sơ̆ng hã, hơrơi ni hã rơŭ hũ dò sơ̆ng Kơu lăm anih Lơngai-Sờh, angăn la Parađi.” ");
INSERT INTO cje_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Tŭ nư̆n, pơgăp sa-pluh dua jơ hơrơi dơ̆ng, abih tơgrơ̆ anih jiơ̆ng kơnăm-mơsrư̆, tơ̆l truh tơ klơu jơ diơŭ. ");
INSERT INTO cje_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ia-hơrơi tơbiă jiơ̆ng kơnăm, sơ̆ng khăn dơrnìng lăm sàng duh-dơlbăt tơrhĕt găn tơkrah jiơ̆ng dua. ");
INSERT INTO cje_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yàng Jêsu iơu prŏng săp lài: “Ơ Ama, Anà yòng jào bơngă-joa Anà lăm tơngàn Ama!” Hơdơi tŭ đờm yơu nư̆n, Pô kloh suàn. ");
INSERT INTO cje_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Tŭ mơnih apăn-akŏ sa rơtùh lĭng 'buh bruă hũ tơbiă truh yơu nư̆n, ñu pồ săp mơyòm-pơglòng Yàng Pô Lơngì sơ̆ng đờm lài: “Mơnih ni iơŭ tơpă biă la mơnih rĭng-tơpă!” ");
INSERT INTO cje_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Abih tơrpuơl buơl làng nau c̆ơ, 'buh bruă hũ tơbiă truh yơu nư̆n, buơl guñu sơrđŭ hărda bloh gài mơrai wơ̆. ");
INSERT INTO cje_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Du mơnih lơđăp-thơu Yàng Jêsu kŭng yơu du mơnih kơmơi hũ nau tui Pô mư̆ng Galile, nư̆n dò dơ̆ng mư̆ng atàh bloh c̆ơ sơ'buai tơgrơ̆ bruă. ");
INSERT INTO cje_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Tŭ nư̆n, hũ sa aràng mơnih siàm sơ̆ng rĭng-tơpă, angăn la Jôsep, sa aràng mơnih lăm Tơrpuơl Gơnuăr Apăn-Akŏ buơl làng. ");
INSERT INTO cje_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ñu 'buh sa hơtai lăm bruă Tơrpuơl Gơnuăr Apăn-Akŏ buơl làng ngă-nìn, kŭng yơu lăm bruă du mơnih dih ngă. Ñu la mơnih plơi-prŏng Arimathe, sa plơi-prŏng lăm c̆àr Juđe, sơ̆ng kŭng la mơnih sơđaŭ kraŭ-c̆àng lơgăr Yàng Pô Lơngì. ");
INSERT INTO cje_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ñu truh tòm Pilat, sơ̆ng yòng rùp atơu Yàng Jêsu. ");
INSERT INTO cje_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Tŭ hũ mă rùp atơu Pô mư̆ng kơyơu pơkăl trŭn, Jôsep pơpò wơ̆ sơ̆ng bơ-yài lơmŭn, bloh nư̆n daŭ Pô lăm sa boh kŭt hũ phàt lờih lăm pơtơu, kŭt nư̆n ka hũ dơ̆r aràng sơi. ");
INSERT INTO cje_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Tŭ nư̆n la hơrơi Rơc̆ăng Dơlhơu, sơ̆ng hơrơi sa'bat kơjĕ truh. ");
INSERT INTO cje_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Du mơnih kơmơi nau găm sơ̆ng Pô mư̆ng c̆àr Galile, kŭng nau tui truh tơ anih nư̆n tô c̆ơ. Buơl guñu 'buh kŭt atơu sơ̆ng 'buh loh-làng rùp atơu Pô hũ daŭ hơyơu lơi. Bloh nư̆n buơl guñu gài mơrai wơ̆, rơc̆ăng lờih du jrào sơ̆ng mơñà 'bơu bơlhơu. ");
INSERT INTO cje_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Hơrơi sa'bat buơl guñu dò pơdời-gleh tui pơnuaĭ adăt-adia hũ ngă-nìn. ");
INSERT INTO cje_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Hơrơi c̆ơmrừp lăm sa-tơjuh, tŭ pơrpa rìng sơrdah, du mơnih kơmơi nư̆n mă jrào 'bơu bơlhơu bloh buơl guñu hũ rơc̆ăng, apăn truh tơ kŭt atơu Pô. ");
INSERT INTO cje_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Buơl guñu 'buh boh pơtơu hũ pơrlơ̆ng tơbiă klàh mư̆ng bơh 'băng kŭt, ");
INSERT INTO cje_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","bloh tŭ nau tơma, buơl guñu 'bu 'buh rùp atơu Yàng Jêsu. ");
INSERT INTO cje_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Lăm tŭ buơl guñu 'buh thơu sơnư̆ng-bơngoàn hơyơu lơi mư̆ng bruă nư̆n, phŭ-phă hũ dua aràng mơnih lơkơi c̆ù ào kơc̆rà sơrdah, tơbiă pơ'buh, dò dơ̆ng tơ anaŭ buơl guñu. ");
INSERT INTO cje_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Lăm tŭ buơl guñu huơĭ-kơđa sơ̆ng trŭp mơta tơ ala lơ̆n, nư̆n dua aràng mơnih nư̆n đờm sơ̆ng buơl guñu: “Kơđa hơgĕ buơl guhã duah mơnih hơdiŭ lăm tơkrah mơnih mơtai? ");
INSERT INTO cje_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Pô 'buh dò tơ anih ni ơu. Pô hũ hơdiŭ wơ̆ bơjơ! Sơdơ̆r wơ̆ bĕ tŭ dò tơ Galile, Pô hũ đờm sơ̆ng buơl guhã hơyơu lơi, ");
INSERT INTO cje_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Pô đờm lài: ‘Anà Mơnih păl kơđòng jào lăm tơngàn du mơnih glài-sơnoh, păl kŏng pơ̆ng tơ kơyơu pơkăl, sơ̆ng hơdơi klơu hơrơi rơŭ hơdiŭ wơ̆.’ ” ");
INSERT INTO cje_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Tŭ nư̆n buơl guñu sơdơ̆r wơ̆ du pơnuaĭ Yàng Jêsu hũ đờm. ");
INSERT INTO cje_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Mư̆ng kŭt atơu gài mơrai wơ̆, buơl guñu đờm akhàn abih tơgrơ̆ bruă nư̆n tơ sa-pluh sa aràng mơnih tơdi-tơdài sơ̆ng du mơnih pơkơ̆n thơu. ");
INSERT INTO cje_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Du mơnih hũ đờm akhàn wơ̆ tơgrơ̆ pơnuaĭ nư̆n tơ du mơnih tơdi-tơdài la Mari Mađơlen, Jannơ, Mari ame Jakơ, sơ̆ng du mơnih kơmơi pơkơ̆n nau găm sơ̆ng buơl guñu. ");
INSERT INTO cje_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Bloh du mơnih tơdi-tơdài 'buh păng-tui, brơi du pơnuaĭ nư̆n yơu la pơnuaĭ đờm mơ-in, 'buh hũ biă. ");
INSERT INTO cje_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Yah yơu nư̆n, Pier tơgồ dơ̆ng, đuaĭ truh tơ kŭt atơu sơ̆ng kù tơ ala c̆ơ, bloh mĭn 'buh khăn pơpò atơu soh. Ñu gài mơrai wơ̆ tơ sàng, mă ngă c̆rih-takơtuă biă mư̆ng bruă hũ tơbiă truh. ");
INSERT INTO cje_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Kŭng lăm hơrơi nư̆n, hũ dua aràng mơnih tui-mơgru nau truh tơ sa plơi dih, angăn la Emmaus, plơi nư̆n atàh mư̆ng Jerusalem pơgăp năm pluh estadơ. ");
INSERT INTO cje_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Buơl guñu đờm glai sơ̆ng gơŭ mư̆ng tơgrơ̆ bruă hũ tơbiă truh. ");
INSERT INTO cje_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Lăm tŭ buơl guñu đờm glai sơ̆ng tămpơrjai-bơyai sơ̆ng gơŭ, nư̆n rùp-phŭn Yàng Jêsu truh jĕ, nau jơlàn găm sơ̆ng buơl guñu. ");
INSERT INTO cje_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Bloh mơta buơl guñu hũ kơđòng ac̆ĭng-tơrđơŭ, nư̆n 'buh c̆ơ thơu Pô. ");
INSERT INTO cje_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Pô tơnia buơl guñu: “Buơl sơ-ai đờm tămpơrjai-bơyai sơ̆ng gơŭ mư̆ng bruă hơgĕ lăm tŭ nau jơlàn nư̆n?” Buơl guñu dò dơ̆ng wơ̆, 'bò mơta dơnuh-dơnà biă. ");
INSERT INTO cje_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Bloh nư̆n lăm dua aràng buơl guñu, sa aràng angăn la Kleôpa, đờm sơđồ: “Hũ iơŭ mĭn sa aràng kơi la mơnih thuai-c̆rih lăm Jerusalem, 'buh mơhư̆ thơu mư̆ng tơgrơ̆ bruă hũ tơbiă truh tơ anih nư̆n lăm du hơrơi ni ơu?” ");
INSERT INTO cje_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Pô tơnia: “Bruă hơgĕ nư̆n?” Buơl guñu đờm sơđồ: “Nư̆n la bruă hũ tơbiă truh tơ Jêsu mơnih Nasaret; Pô la sa aràng mơnih gơnuăr-hwơ̆r hũ gơnăp-gơnuăr lăm bruă ngă sơ̆ng pơnuaĭ đờm tơ anaŭ Yàng Pô Lơngì sơ̆ng abih buơl làng, ");
INSERT INTO cje_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","bloh 'buh wờng kơđa hơgĕ, du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt sơ̆ng du mơnih gơnuăr apăn-akŏ buơl gudrơi hũ mă jào Pô tô kơđòng ngă nìn-glài pơmơtai, sơ̆ng hũ pơ̆ng Pô tơ kơyơu pơkăl. ");
INSERT INTO cje_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Buơl dơlhă gơnừm-c̆àng lài Pô rơŭ dŏng-pơklàh buơl làng Israel. Bloh yah hơyơu lơi, nư̆n tơgrơ̆ bruă ni kŭng hũ tơbiă truh klơu hơrơi bơjơ. ");
INSERT INTO cje_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Rơlau wơ̆, hũ du mơnih kơmơi lăm tơrpuơl buơl dơlhă hũ ngă tơ buơl dơlhă mă ngă krơi-takơtuă biă: Tŭ rìng-rìng ờm, buơl guñu truh tơ kŭt atơu, ");
INSERT INTO cje_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","bloh 'bu 'buh rùp atơu Pô, sơ̆ng buơl guñu gài mơrai wơ̆ đờm lài hũ mơnih gơdrưh tơbiă pơ'buh, đờm brơi thơu Pô hũ hơdiŭ wơ̆ bơjơ. ");
INSERT INTO cje_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Hũ du mơnih lăm tơrpuơl buơl dơlhă kŭng nau truh rơwăng kŭt atơu, sơ̆ng 'buh tơgrơ̆ bruă iơŭ yơu pơnuaĭ du mơnih kơmơi hũ đờm; dò rùp-phŭn Pô nư̆n buơl guñu 'bu 'buh.” ");
INSERT INTO cje_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yàng Jêsu đờm sơ̆ng buơl guñu: “Ơ du mơnih bơrngư̆l-gơla, hũ hơtai-hơtiàn suơi păng-tui tơgrơ̆ pơnuaĭ du mơnih gơnuăr-hwơ̆r đờm! ");
INSERT INTO cje_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","'Buh iơŭ Pô Krist păl kŏng pơđì-pơđoa gleh-glăr yơu nư̆n, bloh nư̆n ka tơma lăm pơnuaĭ màng-kơc̆rà Pô ơu?” ");
INSERT INTO cje_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Bloh nư̆n Pô tơma mư̆ng Môise truh tơ abih du mơnih gơnuăr-hwơ̆r, Pô đờm mơblàng tơ buơl guñu tơgrơ̆ anih lăm 'Bồn Bơ-àr Sơc̆ih-Sri hũ wă mư̆ng Pô. ");
INSERT INTO cje_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Tŭ dua aràng mơnih tui-mơgru truh jĕ tơ plơi buơl guñu khiăng truh, nư̆n Yàng Jêsu ngă yơu khiăng nau atàh rơlau wơ̆. ");
INSERT INTO cje_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Bloh buơl guñu pơkơŭ-jà Pô lài: “Yòng dò wơ̆ sơ̆ng buơl dơlhă, kơyoa lơngì kơjĕ mơlăm bơjơ!” Yơu nư̆n, Pô tơma dò wơ̆ sơ̆ng buơl guñu. ");
INSERT INTO cje_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Lăm tŭ dò guh 'bơ̆ng sơ̆ng dua aràng buơl guñu, Pô mă pah, ưnjơmừn, bloh nư̆n 'bĕt brơi tơ buơl guñu. ");
INSERT INTO cje_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Tŭ nư̆n mơta buơl guñu hũ pơh sơ̆ng buơl guñu kràn-thơu Pô, bloh Pô mơre-mơro sơrlơŭ thĭt. ");
INSERT INTO cje_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Dua aràng buơl guñu đờm sơ̆ng gơŭ: “Lăm tŭ jơlàn nau, Pô đờm glai sơ̆ng mơblàng tơbiă mư̆ng 'Bồn Bơ-àr Sơc̆ih-Sri tơ buơl gudrơi, lăm hơtai-hơtiàn buơl gudrơi 'buh kluơĭ yơu apui ơu?” ");
INSERT INTO cje_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Lăm tŭ jơ nư̆n mư, buơl guñu tơgồ dơ̆ng, gài mơrai wơ̆ tơ plơi-prŏng Jerusalem, tòm sa-pluh sa aràng mơnih tơdi-tơdài găm sơ̆ng du mơnih tui-mơgru pơkơ̆n dò pơgùm-pơtòm gơŭ tơ anih nư̆n. ");
INSERT INTO cje_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Du mơnih ni đờm sơ̆ng dua aràng buơl guñu: “Yàng hũ hơdiŭ wơ̆ biă bơjơ, sơ̆ng hũ tơbiă pơ'buh tơ Simôn!” ");
INSERT INTO cje_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Bloh nư̆n dua aràng buơl guñu đờm akhàn wơ̆ bruă hũ tơbiă truh tŭ buơl guñu nau jơlàn, sơ̆ng buơl guñu hũ kràn-thơu Pô tŭ 'bĕt pah la hơyơu lơi. ");
INSERT INTO cje_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Lăm tŭ buơl guñu dò đờm, nư̆n rùp-phŭn Yàng Jêsu tơbiă pơ'buh dò dơ̆ng tơkrah buơl guñu sơ̆ng đờm: “Rĭng-lơngai tơ buơl guhã!” ");
INSERT INTO cje_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Bloh du mơnih tui-mơgru kơtuă kơ'bla, huơĭ-kơđa biă, sơnư̆ng lài buơl guñu 'buh atơu. ");
INSERT INTO cje_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Pô đờm sơ̆ng buơl guñu: “Kơđa hơgĕ buơl guhã huơĭ, sơ̆ng kơđa hơgĕ lăm hơtai-hơtiàn buơl guhã sơđaŭ dò sơnư̆ng wĭ-wơ̆ 'buh păng-tui? ");
INSERT INTO cje_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","C̆ơ bĕ tơngàn sơ̆ng tơkai Kơu. Iơŭ biă la rùp-phŭn Kơu ni! Buơl guhã rơwơ̆ c̆ơ bĕ, kơyoa atơu nư̆n 'buh hũ tơlàng 'buh hũ rơlo, bloh buơl guhã 'buh Kơu hũ!” ");
INSERT INTO cje_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Hơdơi tŭ đờm yơu nư̆n, Pô yơ̆r tơngàn sơ̆ng tơkai Pô tơ buơl guñu c̆ơ. ");
INSERT INTO cje_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Lăm tŭ buơl guñu hơ̆l-dơmơ̆l kơyoa sơđaŭ dò mă ngă takơtuă sơ̆ng sờh-sài biă, nư̆n Pô đờm sơ̆ng buơl guñu: “Tơ anih ni buơl guhã hũ hơgĕ 'bơ̆ng rơi?” ");
INSERT INTO cje_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Buơl guñu pơyơ̆r brơi tơ Pô sa kleh akàn ăm. ");
INSERT INTO cje_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Pô apăn sơ̆ng 'bơ̆ng tơ anaŭ buơl guñu. ");
INSERT INTO cje_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Bloh nư̆n, Pô đờm sơ̆ng guñu: “Ni la du pơnuaĭ bloh Kơu hũ đờm sơ̆ng buơl guhã tŭ Kơu dò sơ̆ng buơl guhã: Tơgrơ̆ pơnuaĭ hũ wă mư̆ng Kơu lăm 'bồn bơ-àr pơnuaĭ Adăt-Adia Môise, du bơ-àr pơnuaĭ Gơnuăr Hwơ̆r, găm sơ̆ng du pơnuaĭ Pơđik Adoh Mơyòm, păl hũ tơbiă iơŭ tơpă.” ");
INSERT INTO cje_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Tŭ nư̆n Pô pơh akŏ-glo tơ buơl guñu, tô buơl guñu wờng thơu 'Bồn Bơ-àr Sơc̆ih-Sri. ");
INSERT INTO cje_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Pô đờm: “Hũ pơnuaĭ wă: Pô Krist păl kŏng pơđì-pơđoa gleh-glăr, bloh nư̆n truh klơu hơrơi hơdơi, rơŭ mư̆ng pơnuaĭ mơtai hơdiŭ wơ̆, ");
INSERT INTO cje_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","sơ̆ng aràng rơŭ mă angăn Pô bloh pơto-akhàn tơ abih tơgrơ̆ buơl làng tơgrơ̆ lơgăr, sơ̆ng iơu jà buơl guñu mơbai prah-luơi pơnuaĭ sŭng tô hũ anĭt toh-luơi glài-sơnoh, tơma c̆ơmrừp mư̆ng plơi-prŏng Jerusalem. ");
INSERT INTO cje_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Rùp-phŭn buơl guhã la du mơnih ngă grơh mư̆ng tơgrơ̆ bruă nư̆n. Kơu ni, rơŭ brơi tơ buơl guhã pơnuaĭ Ama Kơu hũ pơguăn; ");
INSERT INTO cje_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","dò mư̆ng pơ-ơnah buơl guhã, dò c̆àng bĕ lăm plơi-prŏng tơ̆l truh tơ tŭ hũ đồ-mă gơnăp-gơnuăr mư̆ng ngŏ glòng.” ");
INSERT INTO cje_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Hơdơi mư̆ng nư̆n, Pô ba du mơnih tui-mơgru truh jĕ plơi 'Bethani sơ̆ng yơ̆r tơngàn brơi lơngai-pơtuah tơ buơl guñu. ");
INSERT INTO cje_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Lăm tŭ brơi lơngai-pơtuah, Pô luơi buơl guñu sơ̆ng hũ rò đì tơ ngŏ lơngì. ");
INSERT INTO cje_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Du mơnih tui-mơgru c̆ĕ-dơlbăt Pô, bloh nư̆n gài mơrai wơ̆ tơ Jerusalem, lăm hơtai-hơtiàn baŭ-bèng pơnuaĭ sờh-sài. ");
INSERT INTO cje_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Buơl guñu kừ dò lăm sàng duh-dơlbăt mĭt, mơyòm-pơglòng Yàng Pô Lơngì.");
INSERT INTO cje_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Mư̆ng c̆ơmrừp hũ Pô-Pơnuaĭ, Pô-Pơnuaĭ dò sơ̆ng Yàng Pô Lơngì, sơ̆ng Pô-Pơnuaĭ la Yàng Pô Lơngì. ");
INSERT INTO cje_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Mư̆ng c̆ơmrừp Pô dò sơ̆ng Yàng Pô Lơngì. ");
INSERT INTO cje_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Abih tơgrơ̆ jơi-phơ̆n kơyoa Pô c̆rơ̆ng-tơbiă, 'buh sa jơi-phơ̆n lơi hũ c̆rơ̆ng-tơbiă bloh 'buh kơyoa Pô. ");
INSERT INTO cje_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Lăm Pô hũ pơnuaĭ hơdiŭ, sơ̆ng pơnuaĭ hơdiŭ la pơnuaĭ sơrdah tơ jơi anà mơnih. ");
INSERT INTO cje_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Pơnuaĭ sơrdah pơsàng lăm kơnăm-mơsrư̆, sơ̆ng kơnăm-mơsrư̆ 'buh pơluĭ jiơ̆ng pơnuaĭ sơrdah. ");
INSERT INTO cje_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Hũ sa aràng mơnih Yàng Pô Lơngì pơđăr truh, angăn la Jăng. ");
INSERT INTO cje_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ñu truh tô ngă grơh, sơ̆ng ngă grơh mư̆ng pơnuaĭ sơrdah, tô gơnừm tơ ñu tơgrơ̆ mơnih hũ rơgơi păng-tui. ");
INSERT INTO cje_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Rùp-phŭn Jăng 'buh iơŭ la pơnuaĭ sơrdah, bloh ñu truh tô ngă grơh mư̆ng pơnuaĭ sơrdah. ");
INSERT INTO cje_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Pơnuaĭ sơrdah ni la pơnuaĭ sơrdah biă, hũ truh lăm dun-ya tô pơsàng sơrdah tơgrơ̆ mơnih. ");
INSERT INTO cje_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Pô-Pơnuaĭ dò lăm dun-ya, sơ̆ng dun-ya hũ c̆rơ̆ng-tơbiă kơyoa Pô, bloh dun-ya 'buh kràn-thơu Pô. ");
INSERT INTO cje_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Pô hũ truh lăm c̆àr-tơnah Pô, bloh buơl làng Pô 'buh păng-tui đồ-mă Pô. ");
INSERT INTO cje_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Bloh yah aràng sơi păng-tui đồ-mă Pô, la păng-tui lăm angăn Pô, nư̆n Pô brơi tơ buơl guñu gơnuăr tơbiă jiơ̆ng anà Yàng Pô Lơngì, ");
INSERT INTO cje_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","la du mơnih hũ đih apui tơbiă 'buh iơŭ kơyoa drah-lơnah, halài kơyoa rùp-phàp drah-rơlo hàm-khiăng, halài kơyoa hơtai anà mơnih, bloh la kơyoa Yàng Pô Lơngì. ");
INSERT INTO cje_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Pô-Pơnuaĭ hũ tơbiă jiơ̆ng rùp-phàp drah-rơlo, dò tơkrah buơl gudrơi, baŭ-bèng pơnuaĭ anĭt-brơi-soh sơ̆ng pơnuaĭ-tơpă. Buơl dơlhă hũ c̆ơ 'buh pơnuaĭ màng-kơc̆rà Pô, la pơnuaĭ màng-kơc̆rà Anà Sa truh mư̆ng anih Ama. ");
INSERT INTO cje_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jăng hũ ngă grơh mư̆ng Pô sơ̆ng prŏng săp đờm lài: “Ni la Pô bloh dơlhă hũ đờm: ‘Pô truh hơdơi dơlhă bloh prŏng-màng rơlau dơlhă, kơyoa Pô sơđaŭ hũ dơlhơu dơlhă.’ ” ");
INSERT INTO cje_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Gơnừm tơ pơnuaĭ dơlah-dơlài Pô, bloh buơl gudrơi đồ-mă hũ abih pơnuaĭ anĭt-brơi-soh ni truh pơnuaĭ anĭt-brơi-soh dih. ");
INSERT INTO cje_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Biă yơu nư̆n, pơnuaĭ adăt-adia hũ brơi tơbiă kơyoa Môise, dò pơnuaĭ anĭt-brơi-soh sơ̆ng pơnuaĭ-tơpă nư̆n truh mư̆ng Yàng Jêsu Krist. ");
INSERT INTO cje_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ka aràng sơi hũ 'buh Yàng Pô Lơngì, mĭn Anà Sa dò lăm hơtai-hơtiàn Ama, la Pô hũ akhàn-tơbiă Ama tơ buơl gudrơi thơu. ");
INSERT INTO cje_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ni la pơnuaĭ Jăng ngă grơh, tŭ du mơnih Juđa pơđăr du mơnih gơnuăr pơyă phơ̆n duh-dơlbăt, sơ̆ng mơnih Lebi mư̆ng plơi-prŏng Jerusalem truh tòm sơ̆ng tơnia ñu lài: “Kơi la aràng sơi?” ");
INSERT INTO cje_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Jăng đờm tơbiă tơpă, 'buh kơmlah bơdơŭ hơgĕ. Jăng đờm: “Dơlhă 'buh iơŭ la Pô Krist.” ");
INSERT INTO cje_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Buơl guñu tơnia wơ̆: “Yơu nư̆n kơi la aràng sơi? Kơi hũ iơŭ la Eli ơu?” Jăng đờm: “'Buh iơŭ!” “Nư̆n kơi hũ iơŭ la mơnih gơnuăr-hwơ̆r ơu?” Jăng đờm: “'Buh iơŭ!” ");
INSERT INTO cje_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Nư̆n buơl guñu đờm: “Yơu nư̆n kơi la aràng sơi? Yòng đờm brơi buơl dơlhă thơu tô buơl dơlhă hũ rơgơi đờm akhàn wơ̆ sơ̆ng du mơnih hũ pơđăr buơl dơlhă truh. Kơi pơ-angăn rùp-phŭn drơi la aràng sơi?” ");
INSERT INTO cje_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Jăng đờm: “Dơlhă la săp mơnih driau iơu lăm 'blàng-jơhua: ‘Ngă pơrĭng-pơtơpă bĕ jơlàn tơ Yàng.’ Yơu pơnuaĭ mơnih gơnuăr-hwơ̆r Êsai hũ đờm.” ");
INSERT INTO cje_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Lăm tơgrơ̆ mơnih hũ pơđăr mơrai truh, hũ du mơnih lăm tơrpuơl Pharisi. ");
INSERT INTO cje_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Buơl guñu tơnia Jăng: “Yah kơi 'buh iơŭ la Pô Krist, 'buh iơŭ la Eli, kŭng 'buh iơŭ la mơnih gơnuăr-hwơ̆r, nư̆n kơđa hơgĕ kơi hũ gơnuăr ngă 'baptem?” ");
INSERT INTO cje_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jăng đờm sơđồ: “Dơlhă ngă 'baptem sơ̆ng ia, bloh hũ sa Pô dò tơkrah buơl kơi bloh buơl kơi 'buh thơu, ");
INSERT INTO cje_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Pô nư̆n truh hơdơi dơlhă, sơ̆ng dơlhă 'buh sơ̆p păl tô tơleh tơlơi tơkhŏ tơ Pô.” ");
INSERT INTO cje_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Du bruă nư̆n hũ tơbiă truh lăm 'Bethani, gah dih ia sơdờng Jôđăn, anih Jăng 'Baptis ngă 'baptem. ");
INSERT INTO cje_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Hơrơi hơdơi, Jăng 'buh Yàng Jêsu truh sơ̆ng drơi, nư̆n đờm lài: “Dih, Abo Anà Yàng Pô Lơngì, la Pô suă prah glài-sơnoh tơ dun-ya! ");
INSERT INTO cje_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ni la Pô bloh dơlhă hũ đờm: ‘Hũ sa Pô truh hơdơi dơlhă bloh prŏng-màng rơlau dơlhă, kơyoa Pô sơđaŭ hũ dơlhơu dơlhă.’ ");
INSERT INTO cje_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Rùp-phŭn dơlhă, dơlhă 'buh thơu Pô, bloh kơyoa tô Pô hũ ràng-tơbiă tơ buơl làng Israel, nư̆n dơlhă truh tô ngă 'baptem sơ̆ng ia.” ");
INSERT INTO cje_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Jăng kŭng ngă grơh lài: “Dơlhă hũ 'buh Bơngă Sơc̆ih-Sri mư̆ng ngŏ lơngì trŭn yơu c̆ĭm kơtrơu, đơ̆m tơ ngŏ Pô. ");
INSERT INTO cje_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Rùp-phŭn dơlhă, dơlhă 'buh thơu Pô, bloh Pô pơđăr dơlhă ngă 'baptem sơ̆ng ia hũ đờm sơ̆ng dơlhă lài: ‘Pô bloh hã rơŭ 'buh Bơngă Sơc̆ih-Sri trŭn sơ̆ng dò tơ ngŏ, nư̆n la Pô ngă 'baptem sơ̆ng Yàng Bơngă Sơc̆ih-Sri.’ ");
INSERT INTO cje_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Dơlhă hũ 'buh sơ̆ng ngă grơh lài, ni la rùp-phŭn Anà Yàng Pô Lơngì.” ");
INSERT INTO cje_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Hơrơi hơdơi, Jăng dò dơ̆ng tơ anih nư̆n sơ̆ng dua aràng mơnih tui-mơgru drơi. ");
INSERT INTO cje_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Tŭ 'buh Yàng Jêsu nau găn, Jăng đờm: “Dih, Abo Anà Yàng Pô Lơngì!” ");
INSERT INTO cje_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Dua aràng mơnih tui-mơgru mơhư̆ Jăng đờm, nư̆n nau tui Yàng Jêsu mư. ");
INSERT INTO cje_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yàng Jêsu pơtrah wơ̆, 'buh dua aràng buơl guñu nau tui drơi, nư̆n tơnia: “Buơl guhã duah aràng sơi?” Buơl guñu đờm: “Rabi (mơblàng la Pô-Pơto), Pô-Pơto dò anih lơi?” ");
INSERT INTO cje_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Pô đờm: “Truh c̆ơ bĕ!” Buơl guñu truh c̆ơ anih Pô dò, sơ̆ng dò wơ̆ sơ̆ng Pô hơrơi nư̆n. Tŭ nư̆n pơgăp pà jơ diơŭ. ");
INSERT INTO cje_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Sa lăm dua aràng hũ mơhư̆ pơnuaĭ Jăng đờm sơ̆ng nau tui Yàng Jêsu, la Andre, adơi Simôn Pier. ");
INSERT INTO cje_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Dơlhơu biă, Andre nau duah sơ-ai ñu la Simôn, sơ̆ng đờm: “Buơl dơlhă hũ tòm Pô Mesi.” (mơblàng la Pô Krist). ");
INSERT INTO cje_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Bloh nư̆n ñu ba sơ-ai drơi truh tòm Yàng Jêsu. Yàng Jêsu c̆ơ tơ Simôn sơ̆ng đờm: “Hã la Simôn, anà kơi Jăng, hã rơŭ hũ angăn la Sepha,” mơblàng la Pier. ");
INSERT INTO cje_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Hơrơi hơdơi, Yàng Jêsu ngă-nìn nau truh tơ c̆àr Galile. Pô duah Philip, sơ̆ng đờm lài: “Tui bĕ Kơu!” ");
INSERT INTO cje_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Philip la mơnih 'Betsaiđa, găm sa plơi-prŏng sơ̆ng Andre sơ̆ng Pier. ");
INSERT INTO cje_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Philip duah Nathanael, sơ̆ng đờm: “Buơl dơlhă hũ tòm Pô bloh Môise hũ wă lăm 'bồn bơ-àr pơnuaĭ Adăt-Adia, sơ̆ng du mơnih gơnuăr-hwơ̆r kŭng hũ wă mư̆ng Pô rơi; nư̆n la Yàng Jêsu, anà kơi Jôsep, mơnih plơi-prŏng Nasaret.” ");
INSERT INTO cje_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nathanael đờm: “Hũ pơnuaĭ hơgĕ siàm tơbiă mư̆ng Nasaret rơi?” Philip đờm: “Truh c̆ơ bĕ!” ");
INSERT INTO cje_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yàng Jêsu 'buh Nathanael truh sơ̆ng Pô, nư̆n đờm mư̆ng ñu lài: “Ni la sa aràng mơnih Israel biă, lăm ñu 'buh hũ pơnuaĭ hơgĕ lơ̆r 'bơ̆r!” ");
INSERT INTO cje_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nathanael tơnia: “Ngă hơyơu Pô-Pơto thơu dơlhă?” Yàng Jêsu đờm: “Dơlhơu tŭ Philip iơu hã, Kơu hũ 'buh hã tơ ala kơyơu hra!” ");
INSERT INTO cje_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nathanael đờm: “Ơ Pô-Pơto, Pô-Pơto la anà Yàng Pô Lơngì! Pô-Pơto la pơtau buơl làng Israel!” ");
INSERT INTO cje_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yàng Jêsu đờm: “Kơyoa Kơu đờm sơ̆ng hã lài Kơu hũ 'buh hã dò tơ ala kơyơu hra, nư̆n hã păng-tui! Hã rơŭ 'buh du bruă prŏng rơlau wơ̆.” ");
INSERT INTO cje_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Bloh nư̆n Pô đờm: “Iơŭ biă Kơu đờm sơ̆ng buơl guhã, buơl guhã rơŭ 'buh lơngì pơh tơbiă, sơ̆ng mơnih gơdrưh Yàng Pô Lơngì đì trŭn tơ ngŏ Anà Mơnih.” ");
INSERT INTO cje_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Klơu hơrơi hơdơi, hũ sa pơnuaĭ mơñŭm 'bơ̆ng khiăng-gơŭ tơ plơi-prŏng Kana, lăm c̆àr Galile, sơ̆ng Ame Yàng Jêsu hũ mơta tơ anih nư̆n. ");
INSERT INTO cje_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yàng Jêsu sơ̆ng du mơnih tui-mơgru Pô kŭng hũ aràng jà truh mơñŭm 'bơ̆ng rơi. ");
INSERT INTO cje_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Tŭ 'buh tơpai abih, ame Yàng Jêsu đờm sơ̆ng Pô: “Aràng abih tơpai bơjơ.” ");
INSERT INTO cje_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yàng Jêsu đờm sơđồ: “Ơ ame, kơđa hơgĕ ame truh đờm bruă nư̆n sơ̆ng anà? Jơ anà ka truh!” ");
INSERT INTO cje_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ame Pô đờm sơ̆ng du mơnih dŏng bruă: “Ñu pơđăr hơgĕ, buơl guhã ngă tui bĕ!” ");
INSERT INTO cje_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Tơ anih nư̆n hũ năm boh c̆eh sơ̆ng pơtơu, pioh angui lăm bruă pơsơc̆ih-goh tui adăt mơnih Juđa, yàu boh pơdơ̆ng hũ pơgăp sa rơtùh lĭt ia. ");
INSERT INTO cje_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yàng Jêsu đờm pơđăr buơl guñu: “Tuh bĕ ia baŭ lăm tơgrơ̆ c̆eh ni.” Buơl guñu tuh ia baŭ truh tơ bơbah c̆eh. ");
INSERT INTO cje_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Bloh nư̆n Pô đờm sơ̆ng buơl guñu: “Tŭ ni sŏ bĕ, apăn truh tơ mơnih c̆ơ thuai.” Yơu nư̆n buơl guñu apăn truh tơ mơnih c̆ơ thuai. ");
INSERT INTO cje_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Tŭ mơnih c̆ơ thuai tiăm ia hũ tơbiă jiơ̆ng tơpai (bloh 'buh thơu tơpai truh mư̆ng lơi, dò du mơnih dŏng bruă hũ sŏ ia, nư̆n thơu), nư̆n mơnih c̆ơ thuai iơu mơnih mơrtơu-lơkơi truh ");
INSERT INTO cje_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","sơ̆ng đờm: “Aràng sơi aràng nư̆n kŭng jà tơpai bơngi dơlhơu, sơ̆ng hơdơi tŭ thuai mơñŭm lô bơjơ, nư̆n ka apăn tơpai găp-nư̆ tơbiă, bloh sơ-ai nư̆n pioh tơpai bơngi tơ̆l truh tŭ ni.” ");
INSERT INTO cje_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yàng Jêsu hũ ngă nàl-c̆rih c̆ơmrừp nư̆n tơ Kana, lăm c̆àr Galile. Pô ràng-tơbiă pơnuaĭ màng-kơc̆rà Pô, sơ̆ng du mơnih tui-mơgru Pô păng-tui Pô. ");
INSERT INTO cje_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Hơdơi bruă nư̆n, Pô sơ̆ng ame Pô, adơi-ai Pô, sơ̆ng du mơnih tui-mơgru Pô nau trŭn tơ plơi-prŏng Kapenaum, sơ̆ng dò wơ̆ tơ anih nư̆n sa-sĭt hơrơi. ");
INSERT INTO cje_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Pơnuaĭ pơjŭm 'bơ̆ng Nau-Găn buơl làng Juđa kơjĕ truh, Yàng Jêsu đì tơ plơi-prŏng Jerusalem. ");
INSERT INTO cje_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Pô 'buh lăm anih sàng duh-dơlbăt hũ du mơnih pơblơi lơmo, abo, c̆ĭm kơtrơu, sơ̆ng du mơnih dò guh sơlih priă. ");
INSERT INTO cje_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Pô pă sa 'bĕ hwai sơ̆ng tơlơi, bloh nư̆n prơh abih buơl guñu, găm sơ̆ng abo, lơmo, tơbiă klàh mư̆ng sàng duh-dơlbăt. Pô tuh abih priă mơnih sơlih priă, sơ̆ng tơlơ̆ lơbuh c̆ơnừng buơl guñu. ");
INSERT INTO cje_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Pô đờm sơ̆ng du mơnih pơblơi c̆ĭm kơtrơu lài: “Apăn bĕ abih tơgrơ̆ phơ̆n ni tơbiă klàh mư̆ng anih ni. Juơi ngă tơ sàng Ama Kơu tơbiă jiơ̆ng anih pơblơi-sơlih.” ");
INSERT INTO cje_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Du mơnih tui-mơgru Pô sơdơ̆r wơ̆ pơnuaĭ hũ wă: “Pơnuaĭ abih hơtai-hơtiàn mư̆ng sàng Yàng hŭr 'bơ̆ng dơlhă.” ");
INSERT INTO cje_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Mơnih Juđa tơnia Pô: “Pô-Pơto hũ nàl-c̆rih lơi tô ràng-tơbiă tơ buơl dơlhă 'buh la Pô-Pơto hũ gơnuăr ngă du pơnuaĭ ni ơu?” ");
INSERT INTO cje_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yàng Jêsu đờm: “Ngă pơjơrlơh bĕ sàng duh-dơlbăt ni, bloh nư̆n lăm klơu hơrơi Kơu rơŭ bơ̆ pơdơ̆ng wơ̆!” ");
INSERT INTO cje_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Mơnih Juđa đờm: “Aràng bơ̆-ngă sàng duh-dơlbăt ni lơhiă pà pluh năm thŭn, bloh Pô-Pơto nư̆n rơŭ bơ̆-pơdơ̆ng wơ̆ lăm klơu hơrơi!” ");
INSERT INTO cje_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Bloh sàng duh-dơlbăt Yàng Jêsu khiăng đờm tơ anih ni la rùp-phàp Pô. ");
INSERT INTO cje_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Kơyoa nư̆n, hơdơi tŭ Pô mư̆ng mơnih mơtai hơdiŭ wơ̆, du mơnih tui-mơgru Pô sơdơ̆r wơ̆ pơnuaĭ Pô hũ đờm, nư̆n păng-tui 'Bồn Bơ-àr Sơc̆ih-Sri sơ̆ng păng-tui pơnuaĭ Yàng Jêsu hũ đờm. ");
INSERT INTO cje_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Lăm tŭ Yàng Jêsu dò tơ plơi-prŏng Jerusalem lăm pơnuaĭ pơjŭm 'bơ̆ng Nau-Găn, lô mơnih 'buh du nàl-c̆rih Pô ngă, nư̆n păng-tui angăn Pô. ");
INSERT INTO cje_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Bloh rùp-phŭn Yàng Jêsu nư̆n Pô 'buh păng-tui buơl guñu, kơyoa Pô thơu loh-làng tơgrơ̆ mơnih. ");
INSERT INTO cje_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Pô kŭng 'buh c̆àng aràng sơi đờm ngă grơh mư̆ng mơnih lơi, kơyoa rùp-phŭn Pô thơu loh-làng abih tơgrơ̆ pơnuaĭ lăm hơtai-hơtiàn anà mơnih. ");
INSERT INTO cje_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Lăm tơrpuơl Pharisi, hũ sa aràng mơnih angăn la Nikôđem; ñu la sa aràng lăm du mơnih apăn-akŏ buơl làng Juđa. ");
INSERT INTO cje_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Glai mơlăm, mơnih ni truh tòm Yàng Jêsu sơ̆ng đờm: “Ơ Pô-Pơto, buơl dơlhă thơu Pô-Pơto la pôgru-prŏng mư̆ng Yàng Pô Lơngì truh. Kơyoa yah Yàng Pô Lơngì 'buh dò sơ̆ng Pô-Pơto, nư̆n 'buh aràng sơi rơgơi ngă jiơ̆ng du nàl-c̆rih bloh Pô-Pơto hũ ngă.” ");
INSERT INTO cje_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yàng Jêsu đờm: “Iơŭ biă, Kơu đờm sơ̆ng hã, yah sa aràng mơnih 'buh đih apui wơ̆ amăng dua, nư̆n 'buh rơgơi 'buh jiơ̆ng lơgăr Yàng Pô Lơngì.” ");
INSERT INTO cje_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikôđem đờm sơđồ: “Mơnih tha bơjơ nư̆n ngă hơyơu đih apui wơ̆ amăng dua jiơ̆ng? Hũ rơgơi gài tơma lăm tŭng ame tô hũ đih apui wơ̆ sa amăng tra rơi?” ");
INSERT INTO cje_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yàng Jêsu đờm: “Iơŭ biă Kơu đờm sơ̆ng hã, yah sa aràng mơnih 'buh gơnừm tơ ia sơ̆ng Bơngă Sơc̆ih-Sri bloh đih apui tơbiă, nư̆n 'buh rơgơi tơma jiơ̆ng lăm lơgăr Yàng Pô Lơngì. ");
INSERT INTO cje_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Rùp-phàp drah-rơlo đih apui tơbiă pơ-ơnah drah-rơlo, Bơngă Sơc̆ih-Sri đih apui tơbiă pơ-ơnah bơngă. ");
INSERT INTO cje_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Juơi mă ngă c̆rih-takơtuă mư̆ng pơnuaĭ Kơu hũ đờm sơ̆ng hã: Buơl guhã păl đih apui wơ̆. ");
INSERT INTO cje_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Rơbù khiăng blùh nau anih lơi nư̆n blùh, hã mơhư̆ săp rơbù, bloh 'buh thơu rơbù mư̆ng anih lơi truh sơ̆ng rơŭ nau anih lơi. Mơnih hũ Bơngă Sơc̆ih-Sri đih apui tơbiă, kŭng yơu nư̆n rơi.” ");
INSERT INTO cje_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikôđem đờm wơ̆: “Ngă hơyơu pơnuaĭ nư̆n hũ rơgơi tơbiă truh jiơ̆ng?” ");
INSERT INTO cje_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yàng Jêsu đờm: “Hã la pôgru-prŏng lăm buơl làng Israel, bloh 'buh wờng thơu du pơnuaĭ nư̆n ơu? ");
INSERT INTO cje_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Iơŭ biă Kơu đờm sơ̆ng hã: Buơl dơlhă đờm du pơnuaĭ buơl dơlhă thơu, buơl dơlhă ngă grơh mư̆ng du pơnuaĭ buơl dơlhă hũ 'buh, bloh buơl guhã 'buh đồ-mă pơnuaĭ ngă grơh buơl dơlhă. ");
INSERT INTO cje_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Yah Kơu đờm sơ̆ng buơl guhã mư̆ng du bruă tơ ala lơ̆n bloh buơl guhã dò 'buh păng-tui, tơ-ài lài Kơu đờm mư̆ng du bruă tơ ngŏ lơngì, nư̆n ngă hơyơu buơl guhã păng-tui jiơ̆ng? ");
INSERT INTO cje_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","'Buh ka hũ aràng sơi đì tơ ngŏ lơngì, mĭn hũ Pô mư̆ng ngŏ lơngì trŭn, nư̆n la Anà Mơnih. ");
INSERT INTO cje_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Yơu rài yau Môise yuăl ala tơ ngŏ lăm anih 'blàng-jơhua hơyơu lơi, nư̆n Anà Mơnih kŭng păl kŏng yuăl tơ ngŏ yơu nư̆n rơi, ");
INSERT INTO cje_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","tô aràng sơi păng-tui truh Pô nư̆n hũ pơnuaĭ hơdiŭ rài pơdò rài. ");
INSERT INTO cje_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Kơyoa Yàng Pô Lơngì anĭt-rơnăm dun-ya, tơ̆l truh hũ brơi Anà Sa Pô, tô aràng sơi păng-tui Anà nư̆n 'buh kơđòng roh-rui mơtai lơhiă, bloh hũ pơnuaĭ hơdiŭ rài pơdò rài. ");
INSERT INTO cje_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kơyoa Yàng Pô Lơngì hũ pơđăr Anà Pô truh dun-ya, 'buh iơŭ tô c̆ahrơña dun-ya, bloh tô dun-ya gơnừm tơ Anà nư̆n bloh hũ dŏng-pơklàh. ");
INSERT INTO cje_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Aràng sơi păng-tui Anà Yàng Pô Lơngì nư̆n 'buh kơđòng c̆ahrơña ngă nìn-glài, bloh aràng sơi 'buh păng-tui nư̆n hũ kơđòng c̆ahrơña ngă nìn-glài bơjơ, kơyoa 'buh păng-tui truh angăn Anà Sa Yàng Pô Lơngì. ");
INSERT INTO cje_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Pơnuaĭ c̆ahrơña ngă nìn-glài nư̆n la yơu ni: Pơnuaĭ sơrdah hũ truh lăm dun-ya, bloh jơi anà mơnih rơnăm-ư̆ng pơnuaĭ mơsrư̆-kơnăm rơlau pơnuaĭ sơrdah, kơyoa tơgrơ̆ bruă buơl guñu ngă la sơŭ-jơhà. ");
INSERT INTO cje_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Kơyoa aràng sơi ngă bruă mơsak-jơhà nư̆n mơbai tơ pơnuaĭ sơrdah sơ̆ng 'buh truh sơ̆ng pơnuaĭ sơrdah, huơĭ lài tơgrơ̆ bruă drơi ngă rơŭ păl kơđòng ràng pơtơbiă. ");
INSERT INTO cje_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Bloh aràng sơi ngă tui pơnuaĭ-tơpă nư̆n truh sơ̆ng pơnuaĭ sơrdah, tô tơgrơ̆ bruă drơi ngă hũ ràng pơtơbiă, kơyoa hũ ngă lăm Yàng Pô Lơngì.” ");
INSERT INTO cje_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Hơdơi du bruă nư̆n, Yàng Jêsu sơ̆ng du mơnih tui-mơgru Pô nau truh tơ c̆àr Juđe. Pô dò sơ̆ng du mơnih tui-mơgru Pô tơ anih nư̆n, sơ̆ng ngă 'baptem. ");
INSERT INTO cje_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jăng kŭng dò ngă 'baptem tơ Enôn, jĕ Salim, kơyoa anih nư̆n hũ lô ia, sơ̆ng aràng ba gơŭ truh tô đồ-mă pơnuaĭ 'baptem. ");
INSERT INTO cje_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Tŭ nư̆n, Jăng ka kơđòng aràng mă jàm. ");
INSERT INTO cje_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Tŭ nư̆n, du mơnih tui-mơgru Jăng đờm tămpơrjai gơŭ sơ̆ng sa aràng mơnih Juđa mư̆ng adăt pơsơc̆ih-goh. ");
INSERT INTO cje_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Buơl guñu truh tòm Jăng sơ̆ng đờm: “Ơ pô-pơto, Mơnih hũ dò sơ̆ng pô-pơto gah dih ia sơdờng Jôđăn, Mơnih bloh pô-pơto hũ đờm ngă grơh, dih, tŭ ni Mơnih nư̆n kŭng dò ngă 'baptem, sơ̆ng lô mơnih ba gơŭ truh sơ̆ng Mơnih nư̆n.” ");
INSERT INTO cje_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jăng đờm sơđồ: “Yah 'buh iơŭ mư̆ng ngŏ lơngì brơi, nư̆n 'buh aràng sơi đồ-mă hũ pơnuaĭ hơgĕ. ");
INSERT INTO cje_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Rùp-phŭn buơl adơi-ai hũ rơgơi ngă grơh tơ dơlhă lài, dơlhă hũ đờm: Dơlhă 'buh iơŭ la Pô Krist, bloh dơlhă mĭn la mơnih hũ pơđăr truh dơlhơu Pô. ");
INSERT INTO cje_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Aràng sơi pơrpa khiăng sơdiŭ, nư̆n la mơnih mơrtơu-lơkơi. Dò mơnih adơi-ai gơŭ sơ̆ng mơnih mơrtơu-lơkơi mĭn dò dơ̆ng păng, sơ̆ng sờh-sài biă tŭ hũ mơhư̆ săp mơnih mơrtơu-lơkơi. Nư̆n la pơnuaĭ sờh-sài dơlhă, sơ̆ng pơnuaĭ sờh-sài nư̆n tŭ ni hũ wĭl-tơ̆l. ");
INSERT INTO cje_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Pô păl hũ pồ-pơglòng, dò dơlhă păl pơtrŭn. ");
INSERT INTO cje_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Pô mư̆ng ngŏ glòng bloh truh nư̆n dò tơ ngŏ abih tơgrơ̆ jơi. Mơnih mư̆ng lơ̆n bloh tơbiă nư̆n găm sơ̆ng lơ̆n, sơ̆ng đờm du pơnuaĭ tơ ala lơ̆n. Pô mư̆ng ngŏ lơngì bloh truh nư̆n dò tơ ngŏ abih tơgrơ̆ mơnih. ");
INSERT INTO cje_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Pô ngă grơh mư̆ng tơgrơ̆ pơnuaĭ hơgĕ Pô hũ 'buh sơ̆ng mơhư̆, bloh 'buh hũ aràng sơi păng-tui đồ-mă pơnuaĭ ngă grơh Pô. ");
INSERT INTO cje_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Aràng sơi păng-tui đồ-mă pơnuaĭ ngă grơh Pô, nư̆n ngă grơh nìn-kơjăp lài Yàng Pô Lơngì la tơpă biă. ");
INSERT INTO cje_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Kơyoa Pô bloh Yàng Pô Lơngì hũ pơđăr truh, nư̆n pơto-akhàn pơnuaĭ Yàng Pô Lơngì, kơyoa Yàng Pô Lơngì brơi Bơngă Sơc̆ih-Sri tơ Pô baŭ-bèng 'buh luĭ abih jiơ̆ng. ");
INSERT INTO cje_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ama rơnăm Anà, sơ̆ng hũ jào abih tơgrơ̆ mơta lăm tơngàn Anà. ");
INSERT INTO cje_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Aràng sơi păng-tui Anà, nư̆n hũ pơnuaĭ hơdiŭ rài pơdò rài. Aràng sơi 'buh khiăng păng-tui Anà, nư̆n 'buh hũ pơnuaĭ hơdiŭ ơu, bloh pơnuaĭ anok-anoa prŏng Yàng Pô Lơngì sơđaŭ dò tơ ngŏ mơnih nư̆n.” ");
INSERT INTO cje_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Tŭ Yàng Jêsu thơu lài mơnih Pharisi hũ mơhư̆ đờm tiơ̆ng Pô iơu sơ̆ng ngă 'baptem hũ lô mơnih tui-mơgru rơlau tơ Jăng. ");
INSERT INTO cje_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Iơŭ biă 'buh iơŭ rùp-phŭn Yàng Jêsu ngă 'baptem, bloh la du mơnih tui-mơgru Pô ngă), ");
INSERT INTO cje_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","nư̆n Pô tơbiă mư̆ng c̆àr Juđe sơ̆ng gài mơrai wơ̆ tơ c̆àr Galile. ");
INSERT INTO cje_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Bloh Pô păl nau găn c̆àr Samari. ");
INSERT INTO cje_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Yơu nư̆n, Pô truh sa plơi-prŏng lăm c̆àr Samari, angăn la Sikha, jĕ tơ 'blàng hơma bloh Jakôp hũ brơi tơ anà drơi la Jôsep. ");
INSERT INTO cje_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Tơ anih nư̆n hũ ia bơmŭn Jakôp. Kơyoa nau jơlàn gleh-glăr, nư̆n Yàng Jêsu dò guh pơgleh tơ gah ia bơmŭn. Tŭ nư̆n pơgăp sa-pluh dua jơ hơrơi dơ̆ng. ");
INSERT INTO cje_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Sa aràng mơnih kơmơi Samari truh sŏ ia. Yàng Jêsu đờm sơ̆ng mơnih kơmơi: “Yòng brơi tơ Kơu sa-sĭt ia mơñŭm!” ");
INSERT INTO cje_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Tŭ nư̆n, du mơnih tui-mơgru Pô hũ nau tơma lăm plơi-prŏng tô blơi phơ̆n 'bơ̆ng. ");
INSERT INTO cje_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Mơnih kơmơi Samari đờm: “Kơi la sa aràng mơnih Juđa, bloh lài tơnia dơlhă, sa aràng mơnih kơmơi Samari, tô yòng ia mơñŭm?” (Kơyoa mơnih Juđa 'buh nau-mơrai halài tŭp truh tơgrơ̆ phơ̆n hơgĕ mơnih Samari angui.) ");
INSERT INTO cje_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yàng Jêsu đờm: “Yah hã thơu pơnuaĭ anĭt brơi-soh mư̆ng Yàng Pô Lơngì, sơ̆ng thơu mơnih đờm: ‘Yòng brơi tơ Kơu sa-sĭt ia mơñŭm’ la aràng sơi, nư̆n nìn-kơjăp biă, hã rơŭ yòng lơkơu mơnih nư̆n, sơ̆ng mơnih nư̆n rơŭ brơi tơ hã ia hơdiŭ.” ");
INSERT INTO cje_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Mơnih kơmơi đờm: “Ơ kơi, kơi 'buh hũ hơgĕ tô sŏ ia, bloh ia bơmŭn nư̆n dơrlăm. Yơu nư̆n kơi mă mư̆ng lơi tơbiă ia hơdiŭ nư̆n? ");
INSERT INTO cje_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Kơi-kŏ pàng-yau buơl dơlhă la Jakôp hũ brơi tơ buơl dơlhă ia bơmŭn ni, rùp-phŭn Jakôp, du anà-tơc̆o ñu, sơ̆ng du kơtàr jơi-phơ̆n ñu ròng hũ mơñŭm ia bơmŭn ni. Yơu nư̆n kơi prŏng rơlau tơ Jakôp làh?” ");
INSERT INTO cje_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yàng Jêsu đờm: “Aràng sơi mơñŭm ia ni rơŭ dò mơhau mĭt, ");
INSERT INTO cje_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","bloh aràng sơi mơñŭm ia Kơu rơŭ brơi, nư̆n 'buh tŭ lơi mơhau tra. Ia Kơu brơi rơŭ tơbiă jiơ̆ng sa tơ-o ia c̆ă tơbiă mư̆ng dơrlăm mơnih nư̆n, sơ̆ng ba truh pơnuaĭ hơdiŭ rài pơdò rài.” ");
INSERT INTO cje_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Mơnih kơmơi đờm: “Ơ kơi, yòng brơi tơ dơlhă ia nư̆n, tô dơlhă 'buh dò mơhau sơ̆ng 'buh truh tơ anih ni tô sŏ ia tra.” ");
INSERT INTO cje_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yàng Jêsu đờm: “Hã nau wơ̆ bĕ, iơu pơsàng hã truh tơ anih ni.” ");
INSERT INTO cje_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Mơnih kơmơi đờm: “Dơlhă 'buh hũ pơsàng.” Yàng Jêsu đờm: “Hã đờm lài hã 'buh hũ pơsàng la iơŭ biă, ");
INSERT INTO cje_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","kơyoa hã hũ lơma găn pơsàng bơjơ, sơ̆ng mơnih tŭ ni dò hơdiŭ sơ̆ng hã 'buh iơŭ la pơsàng hã. Pơnuaĭ ni hã hũ đờm tơpă.” ");
INSERT INTO cje_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Mơnih kơmơi đờm: “Ơ kơi, dơlhă kràn-thơu kơi la sa aràng mơnih gơnuăr-hwơ̆r. ");
INSERT INTO cje_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Kơi-kŏ pàng-yau buơl dơlhă hũ duh-dơlbăt tơ ngŏ c̆ơ̆ ni, dò buơl kơi nư̆n đờm lài: Jerusalem nư̆n la anih tô duh-dơlbăt.” ");
INSERT INTO cje_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yàng Jêsu đờm: “Ơ mơnih kơmơi, păng-tui bĕ Kơu, jơ truh, buơl guhã rơŭ duh-dơlbăt Ama, 'buh iơŭ tơ ngŏ c̆ơ̆ ni, kŭng 'buh iơŭ lăm plơi-prŏng Jerusalem. ");
INSERT INTO cje_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Buơl guhã duh-dơlbăt Pô buơl guhã 'buh thơu. Buơl dơlhă duh-dơlbăt Pô buơl dơlhă thơu. Kơyoa pơnuaĭ anĭt dŏng-pơklàh truh mư̆ng mơnih Juđa. ");
INSERT INTO cje_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Bloh jơ rơŭ truh, sơ̆ng hũ truh bơjơ, tŭ du mơnih duh-dơlbăt tơpă biă, rơŭ mă hơtai-bơngă sơ̆ng pơnuaĭ-tơpă bloh duh-dơlbăt Ama, kơyoa Ama duah du mơnih duh-dơlbăt Pô yơu nư̆n. ");
INSERT INTO cje_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Yàng Pô Lơngì la Bơngă Gơdrưh, nư̆n du mơnih duh-dơlbăt Pô păl mă hơtai-bơngă, pơnuaĭ-tơpă bloh duh-dơlbăt Pô.” ");
INSERT INTO cje_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Mơnih kơmơi đờm: “Dơlhă thơu lài Pô Mesi, kŭng angăn la Pô Krist, păl truh. Tŭ Pô truh, Pô rơŭ pơto-akhàn tơ buơl gudrơi abih tơgrơ̆ pơnuaĭ.” ");
INSERT INTO cje_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yàng Jêsu đờm: “Kơu, mơnih dò đờm sơ̆ng hã ni, la rùp-phŭn Pô nư̆n!” ");
INSERT INTO cje_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Tŭ nư̆n, du mơnih tui-mơgru mơrai truh. Buơl guñu mă ngă krơi-takơtuă tŭ 'buh Pô đờm glai sơ̆ng sa aràng mơnih kơmơi; bloh 'buh sa aràng mơnih lơi tơnia lài: “Pô-Pơto tơnia mơnih nư̆n pơnuaĭ hơgĕ?” Halài: “Kơđa hơgĕ Pô-Pơto đờm glai sơ̆ng mơnih kơmơi nư̆n?” ");
INSERT INTO cje_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Mơnih kơmơi luơi c̆eh ia drơi tơ anih nư̆n sơ̆ng nau tơma lăm plơi-prŏng, đờm sơ̆ng tơgrơ̆ mơnih lài: ");
INSERT INTO cje_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Truh c̆ơ bĕ, sa aràng mơnih hũ đờm iơŭ abih tơgrơ̆ pơnuaĭ hơgĕ dơlhă hũ ngă. Nư̆n 'buh iơŭ la Pô Krist ơu?” ");
INSERT INTO cje_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Buơl làng tơbiă mư̆ng plơi-prŏng, ba gơŭ truh sơ̆ng Yàng Jêsu. ");
INSERT INTO cje_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Lăm tŭ nư̆n, du mơnih tui-mơgru lơkơu-jà Pô: “Ơ Pô-Pơto, yòng Pô-Pơto angui sa-sĭt phơ̆n 'bơ̆ng.” ");
INSERT INTO cje_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Bloh Pô đờm: “Kơu hũ sa phơ̆n 'bơ̆ng tô ròng rùp bloh buơl guhã 'buh thơu.” ");
INSERT INTO cje_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Kơyoa nư̆n, du mơnih tui-mơgru đờm sơ̆ng gơŭ: “Hũ mơnih lơi apăn phơ̆n hơgĕ tơ Pô-Pơto 'bơ̆ng bơjơ đà?” ");
INSERT INTO cje_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yàng Jêsu đờm sơ̆ng buơl guñu: “Phơ̆n 'bơ̆ng Kơu la ngă tui hơtai-khiăng Pô hũ pơđăr Kơu, sơ̆ng ngă wĭl-tơ̆l bruă Pô. ");
INSERT INTO cje_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","'Buh iơŭ buơl guhã đờm: ‘Dò pà blàn tra la truh brơñàn-blàn yuă ơu?’ Bloh Kơu đờm sơ̆ng buơl guhã: ‘Tơ̆ bĕ mơta tơ ngŏ sơ̆ng c̆ơ, 'blàng hơma hũ asă khuh bơjơ, dò c̆àng hơrơi yuă! ");
INSERT INTO cje_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Mơnih yuă rơŭ đồ-mă priă hơrơi ngă bruă sơ̆ng tơrgùm-pioh bơnga boh tơ pơnuaĭ hơdiŭ rài pơdò rài, tô abih mơnih drà sơ̆ng mơnih yuă hũ găm sơ̆ng gơŭ sờh-sài.’ ");
INSERT INTO cje_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Sơ̆ng kơtha pơnuaĭ aràng đờm: ‘Mơnih ni drà, mơnih dih yuă,’ la iơŭ biă. ");
INSERT INTO cje_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Kơu hũ pơđăr buơl guhã nau yuă anih rùp-phŭn buơl guhã 'buh păl gleh-glăr ngă tơbiă. Du mơnih pơkơ̆n hũ ngă bruă gleh-glăr, dò buơl guhã, nư̆n hũ tơma đồ-lĕng bơnga boh mư̆ng bruă ngă buơl guñu.” ");
INSERT INTO cje_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Lô mơnih Samari lăm plơi-prŏng nư̆n păng-tui Pô, kơyoa mơnih kơmơi hũ ngă grơh lài: “Pô hũ đờm sơ̆ng dơlhă abih tơgrơ̆ pơnuaĭ dơlhă hũ ngă.” ");
INSERT INTO cje_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Yơu nư̆n, tŭ truh tòm Pô, du mơnih Samari yòng Pô dò wơ̆ sơ̆ng buơl guñu. Pô dò wơ̆ sơ̆ng buơl guñu dua hơrơi. ");
INSERT INTO cje_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Tŭ hũ păng pơnuaĭ Pô bơjơ, mơnih păng-tui Pô 'brŏ lô rơlau wơ̆. ");
INSERT INTO cje_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Buơl guñu đờm sơ̆ng mơnih kơmơi: “Tŭ ni buơl dơlhă păng-tui, 'buh iơŭ mĭn kơyoa pơnuaĭ sơ-ai đờm ơu, bloh kơyoa rùp-phŭn buơl dơlhă hũ păng pơnuaĭ Pô, sơ̆ng buơl dơlhă thơu nìn-kơjăp lài Pô iơŭ tơpă biă la Yàng Dŏng Pơklàh dun-ya.” ");
INSERT INTO cje_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Dua hơrơi hơdơi, Yàng Jêsu luơi anih nư̆n, nau truh tơ c̆àr Galile. ");
INSERT INTO cje_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(Kơyoa rùp-phŭn Pô hũ đờm lài, sa aràng mơnih gơnuăr-hwơ̆r 'buh tŭ lơi hũ aràng c̆ơ prŏng-màng lăm plơi-lơgăr phŭn drơi.) ");
INSERT INTO cje_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Tŭ truh tơ c̆àr Galile, Pô hũ buơl làng Galile wă-rò siàm, kơyoa buơl guñu hũ 'buh tơgrơ̆ bruă Pô ngă tơ Jerusalem lăm hơrơi pơjŭm 'bơ̆ng; kơyoa buơl guñu kŭng hũ nau pơjŭm 'bơ̆ng rơi. ");
INSERT INTO cje_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yơu nư̆n, Pô gài wơ̆ tơ Kana lăm c̆àr Galile, la anih Pô hũ ngă ia tơbiă jiơ̆ng tơpai. Tơ plơi-prŏng Kapenaum, hũ sa aràng mơnih kwăng prŏng dih, anà lơkơi ñu kơđòng lơ-ơ̆n traŭ kơjĕ mơtai. ");
INSERT INTO cje_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Tŭ mơnih kwăng ni mơhư̆ lài Yàng Jêsu hũ mư̆ng Juđe truh tơ Galile, nư̆n duah Pô, sơ̆ng yòng-lơkơu Pô truh pơsồ-pơsaih tơ anà drơi, kơyoa ñu kơjĕ mơtai. ");
INSERT INTO cje_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yàng Jêsu đờm sơ̆ng mơnih kwăng: “Yah buơl guhã 'bu 'buh du nàl-c̆rih sơ̆ng pơnuaĭ-krơi, nư̆n buơl guhã biă 'buh păng-tui ơu!” ");
INSERT INTO cje_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Mơnih kwăng đờm: “Khoai Yàng, yòng Yàng truh dơlhơu tơ tŭ anà dơlhă mơtai!” ");
INSERT INTO cje_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yàng Jêsu đờm: “Nau bĕ, anà hã rơŭ hơdiŭ.” Mơnih kwăng păng-tui pơnuaĭ Yàng Jêsu đờm sơ̆ng drơi, nư̆n ñu nau wơ̆. ");
INSERT INTO cje_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Lăm tŭ ñu dò nau jơlàn, nư̆n du mơnih hơlŭn-hơlă ñu truh tòm ñu sơ̆ng đờm: “Anà lơkơi pô hũ hơdiŭ bơjơ!” ");
INSERT INTO cje_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Mơnih kwăng tơnia buơl guñu anà lơkơi drơi hũ saih-tơgồ lăm jơ lơi. Buơl guñu đờm sơđồ: “Hơrơi kơbrơi, lăm tŭ sa jơ diơŭ, nư̆n anà lơkơi pô thĭt sơc̆ừng-mơrềt.” ");
INSERT INTO cje_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Mơnih ama kràn-thơu lài nư̆n la jơ bloh Yàng Jêsu hũ đờm sơ̆ng drơi: “Anà hã rơŭ hơdiŭ.” Yơu nư̆n ñu, sơ̆ng abih sàng-dơnò ñu păng-tui Yàng. ");
INSERT INTO cje_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Nư̆n la pơnuaĭ-c̆rih amăng dua bloh Yàng Jêsu hũ ngă, hơdơi tŭ Pô mư̆ng c̆àr Juđe gài wơ̆ tơ c̆àr Galile. ");
INSERT INTO cje_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Hơdơi mư̆ng nư̆n, lăm sa pơnuaĭ pơjŭm 'bơ̆ng buơl làng Juđa, Yàng Jêsu đì nau tơ plơi-prŏng Jerusalem. ");
INSERT INTO cje_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Tơ Jerusalem, jĕ Bơh 'Băng Abo, hũ sa boh dơnau, ia Hebrơ angăn la 'Betetđa. Tòmdăr dơnau hũ lơma boh sơndờp ac̆ĭng. ");
INSERT INTO cje_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Tơ ala du sơndờp hũ lô mơnih lơ-ơ̆n lơngoh rơwă-sơkì, bồm mơsrư̆, joh-je, sơ̆ng mơtai tơkai-tơngàn dò đih tơ anih nư̆n. (Buơl guñu c̆àng tŭ ia lơ̆ng-kàt. ");
INSERT INTO cje_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Kơyoa suơi-suơi hũ sa aràng mơnih gơdrưh trŭn lăm dơnau, ngă tơ ia lơ̆ng-kàt. Tŭ ia lơ̆ng-kàt, aràng sơi trŭn lăm dơnau dơlhơu, nư̆n yah hũ lơ-ơ̆n lơngoh rơwă-sơkì hơgĕ, kŭng hũ pơsồ-pơsaih abih). ");
INSERT INTO cje_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Tơ anih nư̆n, hũ sa aràng mơnih kơđòng lơ-ơ̆n lơngoh rơwă-sơkì klơu pluh tơlpăn thŭn bơjơ. ");
INSERT INTO cje_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yàng Jêsu 'buh ñu dò đih tơ anih nư̆n, sơ̆ng thơu ñu kơđòng lơ-ơ̆n lơngoh rơwă-sơkì suơi bơjơ, nư̆n Pô tơnia: “Hã khiăng hũ pơsồ-pơsaih ơu?” ");
INSERT INTO cje_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Mơnih lơ-ơ̆n lơngoh rơwă-sơkì đờm: “Ơ kơi, 'buh hũ aràng sơi dŏng prah dơlhă trŭn lăm dơnau tŭ ia lơ̆ng-kàt. Tŭ dơlhă truh, nư̆n mơnih pơkơ̆n hũ trŭn dơlhơu tơ dơlhă bơjơ!” ");
INSERT INTO cje_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yàng Jêsu đờm: “Tơgồ dơ̆ng bĕ, apăn c̆iau hã sơ̆ng nau.” ");
INSERT INTO cje_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Tŭ nư̆n mư mơnih lơ-ơ̆n hũ pơsồ-pơsaih, apăn c̆iau drơi sơ̆ng nau. Hơrơi nư̆n la hơrơi sa'bat. ");
INSERT INTO cje_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Du mơnih Juđa đờm sơ̆ng mơnih hũ pơsồ-pơsaih: “Hơrơi ni la hơrơi sa'bat, hã 'buh hũ gơnuăr apăn c̆iau nau yơu nư̆n!” ");
INSERT INTO cje_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Bloh mơnih nư̆n đờm: “Mơnih hũ pơsồ-pơsaih tơ dơlhă, đờm pơđăr dơlhă: ‘Apăn bĕ c̆iau hã sơ̆ng nau!’ ” ");
INSERT INTO cje_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Buơl guñu tơnia: “Aràng sơi la mơnih pơđăr hã: Apăn bĕ c̆iau sơ̆ng nau?” ");
INSERT INTO cje_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Bloh mơnih hũ pơsồ-pơsaih 'buh thơu la aràng sơi, kơyoa Yàng Jêsu hũ sơrlèt tơma tơkrah tơrpuơl mơnih lô tơ anih nư̆n bơjơ. ");
INSERT INTO cje_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Hơdơi mư̆ng nư̆n, Yàng Jêsu păp mơnih ni lăm sàng duh-dơlbăt, Pô đờm sơ̆ng ñu: “Ni, hã hũ pơsồ-pơsaih bơjơ, juơi ngă glài-sơnoh tra, huơĭ hũ pơnuaĭ 'brŏ jơhà rơlau tơbiă truh tơ hã ơu.” ");
INSERT INTO cje_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Mơnih ni nau đờm sơ̆ng du mơnih Juđa lài rùp-phŭn Yàng Jêsu la mơnih hũ pơsồ-pơsaih lơ-ơ̆n lơngoh rơwă-sơkì tơ drơi. ");
INSERT INTO cje_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Kơyoa nư̆n, mơnih Juđa ngă kăn-dơmăn tơ Yàng Jêsu, sơ̆ng duah pơnuaĭ pơmơtai Pô, kơyoa Pô hũ ngă bruă nư̆n lăm hơrơi sa'bat. ");
INSERT INTO cje_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Bloh Yàng Jêsu đờm sơ̆ng buơl guñu: “Ama Kơu sơđaŭ dò ngă bruă tơ̆l truh tơ tŭ ni, Kơu kŭng ngă bruă yơu nư̆n rơi.” ");
INSERT INTO cje_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Kơyoa nư̆n, mơnih Juđa 'brŏ duah pơnuaĭ tô pơmơtai Pô, 'buh iơŭ mĭn kơyoa Pô ngă sŭng pơnuaĭ adăt hơrơi sa'bat soh, bloh kŭng kơyoa Pô angăn Yàng Pô Lơngì la Ama Pô, sơ̆ng yơu nư̆n la Pô brơi rùp-phŭn drơi kàr gơŭ sơ̆ng Yàng Pô Lơngì. ");
INSERT INTO cje_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Kơyoa nư̆n, Yàng Jêsu đờm sơ̆ng buơl guñu: “Iơŭ biă, Kơu đờm sơ̆ng buơl guhã, Anà 'buh rơgơi mư̆ng rùp-phŭn drơi ngă pơnuaĭ hơgĕ, bloh mĭn ngă pơnuaĭ Anà 'buh Ama ngă. Pơnuaĭ hơgĕ Ama ngă, Anà kŭng ngă yơu nư̆n rơi. ");
INSERT INTO cje_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Kơyoa Ama rơnăm Anà, sơ̆ng ràng-tơbiă tơ Anà tơgrơ̆ pơnuaĭ Ama ngă. Ama rơŭ dò ràng-tơbiă tơ Anà tơgrơ̆ bruă prŏng rơlau tơgrơ̆ bruă ni wơ̆, tô buơl guhã păl mă ngă c̆rih-takơtuă. ");
INSERT INTO cje_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Yơu Ama hũ ngă tơ du mơnih mơtai hơdiŭ wơ̆ sơ̆ng brơi pơnuaĭ hơdiŭ tơ buơl guñu hơyơu lơi, nư̆n Anà kŭng rơŭ brơi pơnuaĭ hơdiŭ tơ mơnih lơi Anà khiăng yơu nư̆n rơi. ");
INSERT INTO cje_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ama 'buh c̆ahrơña aràng sơi, bloh hũ jào wĭl-tơ̆l gơnuăr c̆ahrơña tơ Anà, ");
INSERT INTO cje_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","tô abih tơgrơ̆ mơnih c̆ơ prŏng-màng tơ Anà, kŭng yơu c̆ơ prŏng-màng tơ Ama rơi. Aràng sơi 'buh c̆ơ prŏng-màng tơ Anà, nư̆n kŭng 'buh c̆ơ prŏng-màng tơ Ama, la Pô hũ pơđăr Anà truh. ");
INSERT INTO cje_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Iơŭ biă, Kơu đờm sơ̆ng buơl guhã, aràng sơi mơhư̆ pơnuaĭ Kơu sơ̆ng păng-tui Pô hũ pơđăr Kơu, nư̆n hũ pơnuaĭ hơdiŭ rài pơdò rài, sơ̆ng 'buh kơđòng c̆ahrơña, bloh sơrlèt klàh mư̆ng pơnuaĭ mơtai truh tơ pơnuaĭ hơdiŭ. ");
INSERT INTO cje_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Iơŭ biă, Kơu đờm sơ̆ng buơl guhã, jơ rơŭ truh, sơ̆ng hũ truh bơjơ, la tŭ du mơnih mơtai rơŭ hũ mơhư̆ săp Anà Yàng Pô Lơngì, sơ̆ng du mơnih mơhư̆ rơŭ hũ hơdiŭ. ");
INSERT INTO cje_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Kơyoa yơu Ama hũ pơnuaĭ hơdiŭ lăm rùp-phŭn Pô hơyơu lơi, nư̆n Ama kŭng brơi tơ Anà hũ pơnuaĭ hơdiŭ lăm rùp-phŭn Anà yơu nư̆n rơi. ");
INSERT INTO cje_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ama hũ jào gơnuăr c̆ahrơña tơ Anà, kơyoa Anà la Anà Mơnih. ");
INSERT INTO cje_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Juơi mă ngă krơi-takơtuă mư̆ng pơnuaĭ ni, kơyoa jơ rơŭ truh, tŭ abih tơgrơ̆ mơnih dò lăm kŭt atơu rơŭ mơhư̆ săp Pô, sơ̆ng nau tơbiă; ");
INSERT INTO cje_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","aràng sơi hũ ngă pơnuaĭ siàm, nư̆n rơŭ hơdiŭ wơ̆ tô hũ hơdiŭ; aràng sơi hũ ngă pơnuaĭ mơsak-jơhà, nư̆n rơŭ hơdiŭ wơ̆ tô kŏng c̆ahrơña. ");
INSERT INTO cje_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Kơu 'buh rơgơi mư̆ng hơtai rùp-phŭn drơi ngă pơnuaĭ hơgĕ; Kơu c̆ahrơña tui pơnuaĭ Kơu mơhư̆, sơ̆ng pơnuaĭ Kơu c̆ahrơña la rĭng-tơpă, kơyoa Kơu 'buh duah pơnuaĭ ngă tui hơtai-khiăng Kơu, bloh Kơu ngă tui hơtai-khiăng Pô hũ pơđăr Kơu. ");
INSERT INTO cje_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Yah Kơu ngă grơh tơ rùp-phŭn drơi, nư̆n pơnuaĭ Kơu ngă grơh la 'buh tơpă. ");
INSERT INTO cje_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Hũ Pô pơkơ̆n ngă grơh mư̆ng Kơu, sơ̆ng Kơu thơu pơnuaĭ Pô ngă grơh mư̆ng Kơu la tơpă biă. ");
INSERT INTO cje_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Buơl guhã hũ pơđăr mơnih truh sơ̆ng Jăng, sơ̆ng Jăng hũ ngă grơh mư̆ng pơnuaĭ tơpă. ");
INSERT INTO cje_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","'Buh iơŭ Kơu c̆àng gơnừm pơnuaĭ ngă grơh mư̆ng jơi anà mơnih, bloh Kơu đờm du pơnuaĭ ni tô buơl guhã hũ dŏng-pơklàh. ");
INSERT INTO cje_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jăng la apui-đèng pơsàng sơrdah, sơ̆ng buơl guhã sờh hơtai-hơtiàn đồ-lĕng pơnuaĭ sơrdah nư̆n lăm sa-sĭt tŭ. ");
INSERT INTO cje_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Bloh Kơu hũ sa pơnuaĭ ngă grơh prŏng pràn rơlau tơ pơnuaĭ ngă grơh Jăng, nư̆n la tơgrơ̆ bruă Ama jào tơ Kơu tô ngă wĭl-tơ̆l. Tơgrơ̆ bruă Kơu ngă rơŭ ngă grơh tơ Kơu lài Ama hũ pơđăr Kơu. ");
INSERT INTO cje_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Rùp-phŭn Ama, la Pô hũ pơđăr Kơu, kŭng ngă grơh tơ Kơu. Buơl guhã ka tŭ lơi mơhư̆ săp Pô, halài 'buh 'bò mơta Pô, ");
INSERT INTO cje_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","sơ̆ng pơnuaĭ Pô kŭng 'buh dò lăm buơl guhã, kơyoa buơl guhã 'buh păng-tui Pô bloh Ama hũ pơđăr truh. ");
INSERT INTO cje_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Buơl guhã c̆ơ-mơgru 'Bồn Bơ-àr Sơc̆ih-Sri, kơyoa sơnư̆ng lài lăm nư̆n buơl guhã rơŭ duah hũ pơnuaĭ hơdiŭ rài pơdò rài. Rùp-phŭn 'Bồn Bơ-àr Sơc̆ih-Sri hũ wă tơbiă tô ngă grơh mư̆ng Kơu. ");
INSERT INTO cje_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Nư̆n bloh buơl guhã 'buh khiăng truh sơ̆ng Kơu tô hũ pơnuaĭ hơdiŭ rài pơdò rài! ");
INSERT INTO cje_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Kơu 'buh duah pơnuaĭ màng-kơc̆rà anih jơi anà mơnih, ");
INSERT INTO cje_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","bloh Kơu thơu lài buơl guhã 'buh hũ hơtai-hơtiàn duh-rơnăm Yàng Pô Lơngì ơu. ");
INSERT INTO cje_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Kơu hũ mă angăn Ama Kơu bloh truh, bloh buơl guhã 'buh đồ-mă Kơu; bloh yah hũ mơnih lơi pơkơ̆n mă angăn drơi bloh truh, nư̆n buơl guhã rơŭ đồ-mă. ");
INSERT INTO cje_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Buơl guhã mĭn khiăng mơyòm-pơglòng duă gơŭ drơi, bloh 'buh khiăng tui duah pơnuaĭ màng-kơc̆rà truh mư̆ng Yàng Pô Lơngì mĭn sa soh, nư̆n ngă hơyơu buơl guhã păng-tui jiơ̆ng? ");
INSERT INTO cje_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Juơi sơnư̆ng lài Kơu rơŭ đờm yă buơl guhã tơ anaŭ Ama. Mơnih rơŭ đờm yă buơl guhã nư̆n la Môise, mơnih bloh buơl guhã hũ c̆àng-gơnừm. ");
INSERT INTO cje_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kơyoa yah buơl guhã păng-tui Môise, nư̆n kŭng păng-tui Kơu, kơyoa Môise wă mư̆ng Kơu. ");
INSERT INTO cje_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Bloh yah buơl guhã 'buh păng-tui tơgrơ̆ pơnuaĭ Môise wă, nư̆n ngă hơyơu buơl guhã păng-tui pơnuaĭ Kơu jiơ̆ng?” ");
INSERT INTO cje_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Hơdơi du bruă nư̆n, Yàng Jêsu nau truh tơ gah dih ia-tơsì Galile, kŭng angăn la ia-tơsì Tiberias. ");
INSERT INTO cje_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Sa tơrpuơl lô buơl làng nau tui Pô, kơyoa buơl guñu hũ 'buh du nàl-c̆rih Pô ngă tơ du mơnih lơ-ơ̆n lơngoh rơwă-sơkì. ");
INSERT INTO cje_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yàng Jêsu đì tơ ngŏ c̆ơ̆, sơ̆ng dò guh tơ anih nư̆n sơ̆ng du mơnih tui-mơgru. ");
INSERT INTO cje_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Tŭ nư̆n, kơjĕ truh pơnuaĭ pơjŭm 'bơ̆ng Nau-Găn, la pơnuaĭ pơjŭm 'bơ̆ng prŏng lăm buơl làng Juđa. ");
INSERT INTO cje_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Tơ̆ mơta c̆ơ tơ ngŏ, Yàng Jêsu 'buh sa tơrpuơl lô biă buơl làng truh sơ̆ng Pô, nư̆n Pô đờm sơ̆ng Philip: “Buơl gudrơi păl blơi pah anih lơi tô brơi tơ du mơnih ni 'bơ̆ng?” ");
INSERT INTO cje_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Pô đờm yơu nư̆n tô lòng Philip, bloh Pô hũ thơu pơnuaĭ Pô rơŭ ngă bơjơ. ");
INSERT INTO cje_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Philip đờm: “Yah mă dua rơtùh đơnie tô blơi phơ̆n 'bơ̆ng, kŭng 'buh tơ̆l tô pơrpha tơ yàu aràng yàu pĕt tìt ơu rơi.” ");
INSERT INTO cje_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Sa aràng lăm du mơnih tui-mơgru, la Andre, adơi Simôn Pier, đờm sơ̆ng Pô: ");
INSERT INTO cje_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Tơ anih ni hũ sa aràng adơi lơkơi tìt, ñu hũ lơma boh pah sơ̆ng dua drơi akàn, bloh kàr nư̆n hũ tơ̆l-ñàm hơgĕ sơ̆ng tơrpuơl mơnih lô ni?” ");
INSERT INTO cje_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yàng Jêsu đờm: “Đờm pơđăr bĕ tơrpuơl buơl làng dò guh.” Anih nư̆n hũ lô rơ̆. Yơu nư̆n buơl làng dò guh, khà mơnih pơgăp lơma rơbơu aràng. ");
INSERT INTO cje_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yàng Jêsu apăn pah, pồ săp ưnjơmừn, bloh nư̆n pơrpha tơ du mơnih dò guh tơ anih nư̆n. Akàn kŭng hũ pơrpha yơu nư̆n rơi, aràng sơi khiăng 'bơ̆ng kàr lơi tui hơtai. ");
INSERT INTO cje_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Hơdơi tŭ abih tơgrơ̆ mơnih 'bơ̆ng trơi bơjơ, Pô đờm sơ̆ng du mơnih tui-mơgru: “Duơ̆n wơ̆ bĕ abih du pĕt pah dơlah, tô 'buh luơi lơhiă sa-sĭt lơi.” ");
INSERT INTO cje_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Yơu nư̆n, du mơnih tui-mơgru nau duơ̆n wơ̆ abih du pĕt pah dơlah mư̆ng lơma boh pah, hơdơi tŭ abih tơgrơ̆ mơnih hũ 'bơ̆ng trơi, sơ̆ng daŭ baŭ sa-pluh dua bài. ");
INSERT INTO cje_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Buơl làng 'buh nàl-c̆rih Yàng Jêsu hũ ngă, nư̆n đờm: “Mơnih ni la rùp-phŭn mơnih gơnuăr-hwơ̆r păl truh lăm dun-ya.” ");
INSERT INTO cje_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yàng Jêsu kràn thơu lài buơl guñu kơjĕ truh pơkơŭ Pô, tô pồ Pô ngă pơtau, nư̆n Pô pleh dò sa aràng Pô tơ ngŏ c̆ơ̆. ");
INSERT INTO cje_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Truh diơŭ, du mơnih tui-mơgru Pô trŭn anih ia-tơsì, ");
INSERT INTO cje_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","đì lăm sa boh gơlài, nau tơpă tơ gah dih ia, gah plơi-prŏng Kapenaum. Tŭ nư̆n, lơngì kơnăm biă bơjơ, bloh Yàng Jêsu sơđaŭ ka truh sơ̆ng buơl guñu. ");
INSERT INTO cje_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Rơbù prŏng blùh đì, sơ̆ng rơyà ia-tơsì poh pràn biă. ");
INSERT INTO cje_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Tŭ du mơnih tui-mơgru wah gơlài nau pơgăp hũ lơma halài năm kơsồ, nư̆n 'buh Yàng Jêsu nau tơ ngŏ sơla ia-tơsì, truh jĕ gơlài. 'Buh yơu nư̆n abih buơl guñu huơĭ kơđa biă. ");
INSERT INTO cje_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Bloh Yàng Jêsu đờm sơ̆ng buơl guñu: “Kơu ni. Juơi huơĭ!” ");
INSERT INTO cje_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Buơl guñu khiăng rò Pô tơma lăm gơlài, bloh tŭ nư̆n mư gơlài pơdơh tơ gah ia, la anih buơl guñu khiăng nau truh. ");
INSERT INTO cje_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Hơrơi hơdơi, buơl làng dò tơ gah dih ia-tơsì kràn thơu lài tơ anih nư̆n mĭn hũ sa boh gơlài, sơ̆ng Yàng Jêsu 'buh trŭn gơlài găm sơ̆ng du mơnih tui-mơgru Pô, mĭn du mơnih tui-mơgru nau soh. ");
INSERT INTO cje_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Bloh hũ du gơlài pơkơ̆n mư̆ng Tiberias truh, dò pơdơh jĕ tơ anih buơl guñu hũ 'bơ̆ng pah hơdơi tŭ Yàng ưnjơmừn. ");
INSERT INTO cje_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Tŭ tơrpuơl buơl làng 'bu 'buh Yàng Jêsu sơ̆ng du mơnih tui-mơgru Pô dò tơ anih nư̆n, buơl guñu đì gơlài sơ̆ng truh tơ plơi-prŏng Kapenaum tô duah Yàng Jêsu. ");
INSERT INTO cje_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Tŭ tòm 'buh Pô tơ gah dih ia-tơsì, buơl guñu đờm sơ̆ng Pô: “Ơ Pô-Pơto, Pô-Pơto truh tơ anih ni tŭ lơi?” ");
INSERT INTO cje_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yàng Jêsu đờm: “Iơŭ biă, Kơu đờm sơ̆ng buơl guhã, buơl guhã duah Kơu 'buh iơŭ kơyoa hũ 'buh du nàl-c̆rih, bloh kơyoa buơl guhã hũ 'bơ̆ng pah trơi tŭng. ");
INSERT INTO cje_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Juơi ngă bruă kơyoa phơ̆n 'bơ̆ng sơmăr brŭ-lơhiă, bloh kơyoa phơ̆n 'bơ̆ng dò mĭt truh pơnuaĭ hơdiŭ rài pơdò rài, la phơ̆n 'bơ̆ng Anà Mơnih rơŭ brơi tơ buơl guhã; kơyoa nư̆n la Pô bloh Yàng Pô Lơngì, la Ama, hũ tơ̆m 'băng-kì c̆ơ̆ng-grơh.” ");
INSERT INTO cje_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Buơl guñu đờm sơ̆ng Pô: “Buơl dơlhă păl ngă hơgĕ tô hũ ngă du bruă Yàng Pô Lơngì khiăng?” ");
INSERT INTO cje_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yàng Jêsu đờm: “Bruă Yàng Pô Lơngì khiăng buơl guhã ngă la păng-tui Pô bloh Yàng Pô Lơngì hũ pơđăr truh.” ");
INSERT INTO cje_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Buơl guñu đờm wơ̆: “Yơu nư̆n, Pô-Pơto ngă nàl-c̆rih hơgĕ tô buơl dơlhă 'buh sơ̆ng păng-tui? Pô-Pơto rơŭ ngă pơnuaĭ hơgĕ? ");
INSERT INTO cje_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Kơi-kŏ pàng-yau buơl gudrơi hũ 'bơ̆ng mana lăm 'blàng-jơhua, yơu hũ pơnuaĭ wă: ‘Pô hũ brơi buơl guñu 'bơ̆ng pah mư̆ng lơngì.’ ” ");
INSERT INTO cje_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yàng Jêsu đờm sơ̆ng buơl guñu: “Iơŭ biă, Kơu đờm sơ̆ng buơl guhã, 'buh iơŭ Môise hũ brơi tơ buơl guhã pah mư̆ng lơngì ơu, bloh nư̆n la Ama Kơu hũ brơi tơ buơl guhã pah biă, la pah truh mư̆ng ngŏ lơngì trŭn. ");
INSERT INTO cje_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Kơyoa pah Yàng Pô Lơngì, la pah mư̆ng ngŏ lơngì trŭn, brơi pơnuaĭ hơdiŭ tơ dun-ya.” ");
INSERT INTO cje_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Buơl guñu đờm: “Khoai Yàng, yòng brơi pah nư̆n tơ buơl dơlhă mĭt-mĭt!” ");
INSERT INTO cje_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yàng Jêsu đờm: “Kơu la pah pơnuaĭ hơdiŭ. Aràng sơi truh sơ̆ng Kơu rơŭ 'buh tŭ lơi lơpa, sơ̆ng aràng sơi păng-tui Kơu rơŭ 'buh tŭ lơi mơhau. ");
INSERT INTO cje_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Bloh Kơu hũ đờm sơ̆ng buơl guhã lài: Buơl guhã hũ 'buh Kơu, bloh sơđaŭ 'buh păng-tui. ");
INSERT INTO cje_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Abih tơgrơ̆ mơnih Ama Kơu brơi tơ Kơu, rơŭ truh sơ̆ng Kơu; aràng sơi truh sơ̆ng Kơu, Kơu rơŭ 'buh luơi tơ agàh ơu. ");
INSERT INTO cje_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Kơyoa Kơu mư̆ng lơngì trŭn, 'buh iơŭ tô ngă tui hơtai-khiăng Kơu, bloh ngă tui hơtai-khiăng Pô hũ pơđăr Kơu. ");
INSERT INTO cje_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ni la hơtai-khiăng Pô hũ pơđăr Kơu: Abih tơgrơ̆ mơnih Pô hũ brơi tơ Kơu, nư̆n Kơu rơŭ 'buh luơi lơhiă sa aràng mơnih lơi, bloh Kơu păl ngă tơ mơnih nư̆n hơdiŭ wơ̆ lăm hơrơi luĭ-dŭt. ");
INSERT INTO cje_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Kơyoa ni la hơtai-khiăng Ama Kơu: Abih tơgrơ̆ mơnih lơi c̆ơ thơu Anà sơ̆ng păng-tui Anà, nư̆n hũ pơnuaĭ hơdiŭ rài pơdò rài, sơ̆ng Kơu rơŭ ngă tơ mơnih nư̆n hơdiŭ wơ̆ lăm hơrơi luĭ-dŭt.” ");
INSERT INTO cje_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Bloh kơyoa Pô hũ đờm: Kơu la pah mư̆ng ngŏ lơngì trŭn, nư̆n du mơnih Juđa đờm yuăm mư̆ng Pô. ");
INSERT INTO cje_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Buơl guñu đờm: “Mơnih ni 'buh iơŭ la Jêsu, anà Jôsep ơu? Ame ama ñu la aràng sơi, buơl gudrơi thơu loh-làng, nư̆n bloh hơyơu ñu đờm lài: ‘Kơu mư̆ng ngŏ lơngì trŭn’?” ");
INSERT INTO cje_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yàng Jêsu đờm: “Buơl guhã juơi đờm yuăm tìt-prŏng sơ̆ng gơŭ tra. ");
INSERT INTO cje_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","'Buh sa aràng mơnih lơi hũ rơgơi truh sơ̆ng Kơu, yah Ama Kơu, la Pô hũ pơđăr Kơu, 'buh kơtŭng ba truh, sơ̆ng Kơu rơŭ ngă tơ mơnih nư̆n hơdiŭ wơ̆ lăm hơrơi luĭ-dŭt. ");
INSERT INTO cje_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Du 'bồn bơ-àr pơnuaĭ gơnuăr-hwơ̆r hũ wă: ‘Abih tơgrơ̆ mơnih rơŭ hũ Yàng Pô Lơngì pơto-pơsài.’ Abih tơgrơ̆ mơnih lơi hũ păng sơ̆ng mơgru mư̆ng Ama, nư̆n truh sơ̆ng Kơu. ");
INSERT INTO cje_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","'Buh aràng sơi hũ 'buh Ama, mĭn Pô mư̆ng Yàng Pô Lơngì truh; mĭn Pô nư̆n hũ 'buh Ama. ");
INSERT INTO cje_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Iơŭ biă, Kơu đờm sơ̆ng buơl guhã, aràng sơi păng-tui Kơu nư̆n hũ pơnuaĭ hơdiŭ rài pơdò rài. ");
INSERT INTO cje_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Kơu la pah pơnuaĭ hơdiŭ! ");
INSERT INTO cje_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Kơi-kŏ pàng-yau buơl guhã hũ 'bơ̆ng mana lăm anih 'blàng-jơhua, bloh nư̆n kŭng mơtai. ");
INSERT INTO cje_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ni la pah mư̆ng lơngì trŭn, tô aràng sơi 'bơ̆ng nư̆n 'buh mơtai. ");
INSERT INTO cje_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Kơu la pah pơnuaĭ hơdiŭ mư̆ng lơngì trŭn; yah aràng sơi 'bơ̆ng pah ni, nư̆n rơŭ hơdiŭ rài pơdò rài. Sơ̆ng pah bloh Kơu rơŭ brơi tô dun-ya hũ hơdiŭ, nư̆n la rơlo Kơu.” ");
INSERT INTO cje_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Kơyoa nư̆n, tơkrah du mơnih Juđa hũ pơnuaĭ mơsau tămpơrjai sơ̆ng gơŭ. Buơl guñu đờm: “Ngă hơyơu mơnih ni mă rơlo ñu bloh brơi buơl gudrơi 'bơ̆ng jiơ̆ng?” ");
INSERT INTO cje_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yàng Jêsu đờm sơ̆ng buơl guñu: “Iơŭ biă, Kơu đờm sơ̆ng buơl guhã, yah buơl guhã 'buh 'bơ̆ng rơlo sơ̆ng mơñŭm drah Anà Mơnih, nư̆n 'buh hũ pơnuaĭ hơdiŭ rài pơdò rài lăm buơl guhã ơu. ");
INSERT INTO cje_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Aràng sơi 'bơ̆ng rơlo sơ̆ng mơñŭm drah Kơu, nư̆n hũ pơnuaĭ hơdiŭ rài pơdò rài, sơ̆ng Kơu rơŭ ngă tơ mơnih nư̆n hơdiŭ wơ̆ lăm hơrơi luĭ-dŭt. ");
INSERT INTO cje_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Kơyoa rơlo Kơu biă la phơ̆n 'bơ̆ng, sơ̆ng drah Kơu biă la phơ̆n mơñŭm. ");
INSERT INTO cje_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Aràng sơi 'bơ̆ng rơlo Kơu sơ̆ng mơñŭm drah Kơu, nư̆n dò lăm Kơu, sơ̆ng Kơu dò lăm mơnih nư̆n. ");
INSERT INTO cje_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Yơu Ama, la Pô hơdiŭ mĭt-mĭt, hũ pơđăr Kơu truh, sơ̆ng Kơu hơdiŭ gơnừm tơ Ama hơyơu lơi, nư̆n mơnih 'bơ̆ng Kơu, kŭng rơŭ hơdiŭ gơnừm tơ Kơu yơu nư̆n rơi. ");
INSERT INTO cje_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ni la pah mư̆ng lơngì trŭn, 'buh iơŭ yơu mana bloh kơi-kŏ pàng-yau buơl guhã hũ 'bơ̆ng, bloh nư̆n kŭng mơtai. Aràng sơi 'bơ̆ng pah ni rơŭ hơdiŭ rài pơdò rài.” ");
INSERT INTO cje_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yàng Jêsu đờm du pơnuaĭ nư̆n tŭ dò pơto-mơblàng lăm sàng pơtòm tơ plơi-prŏng Kapenaum. ");
INSERT INTO cje_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Lô mơnih tui-mơgru Pô păng pơnuaĭ ni, nư̆n đờm: “Pơnuaĭ pơto ni kăn-dơmăn biă, aràng sơi bloh păng jiơ̆ng?” ");
INSERT INTO cje_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Bloh Yàng Jêsu thơu du mơnih tui-mơgru Pô đờm yuăm mư̆ng bruă ni, nư̆n Pô đờm sơ̆ng buơl guñu: “Pơnuaĭ nư̆n ngă tơ buơl guhã sơnĕ-pơtŭp lăm pơnuaĭ sŭng? ");
INSERT INTO cje_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Yơu nư̆n, yah buơl guhã 'buh Anà Mơnih đì tơ anih Pô hũ dò dơlhơu thrơi nư̆n hơyơu? ");
INSERT INTO cje_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Rùp-phŭn bơngă gơdrưh ngă tơ hơdiŭ, rùp-phàp drah-rơlo 'buh kwơ-màng hơgĕ. Tơgrơ̆ pơnuaĭ Kơu đờm sơ̆ng buơl guhã la bơngă gơdrưh sơ̆ng pơnuaĭ hơdiŭ. ");
INSERT INTO cje_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Bloh lăm buơl guhã hũ du mơnih 'buh păng-tui.” Kơyoa Yàng Jêsu hũ thơu mư̆ng c̆ơmrừp, aràng sơi la du mơnih 'buh păng-tui, sơ̆ng aràng sơi la mơnih rơŭ pơblơ̆-dră Pô. ");
INSERT INTO cje_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Pô đờm wơ̆: “Kơyoa nư̆n, Kơu hũ đờm sơ̆ng buơl guhã, yah Ama 'buh brơi, nư̆n 'buh aràng sơi hũ rơgơi truh sơ̆ng Kơu jiơ̆ng!” ");
INSERT INTO cje_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Mư̆ng tŭ nư̆n, hũ lô mơnih tui-mơgru rŭt gơdŭn wơ̆, 'buh tui Pô tra. ");
INSERT INTO cje_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Yàng Jêsu đờm sơ̆ng sa-pluh dua aràng mơnih tơdi-tơdài: “Dò buơl guhã, buơl guhã kŭng khiăng rŭt gơdŭn rơi?” ");
INSERT INTO cje_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simôn Pier đờm: “Khoai Yàng, buơl dơlhă rơŭ tui aràng sơi? Yàng hũ pơnuaĭ ba truh pơnuaĭ hơdiŭ rài pơdò rài! ");
INSERT INTO cje_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Buơl dơlhă hũ păng-tui, sơ̆ng kràn-thơu lài Yàng la Pô Sơc̆ih-Sri Yàng Pô Lơngì.” ");
INSERT INTO cje_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yàng Jêsu đờm: “'Buh iơŭ Kơu hũ rơwah buơl guhã la sa-pluh dua aràng mơnih tơdi-tơdài ơu? Nư̆n bloh sa aràng lăm buơl guhã la kơmlài.” ");
INSERT INTO cje_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Pô khiăng đờm mư̆ng Juđa, anà Simôn Iskariôt, la sa aràng lăm sa-pluh dua aràng mơnih tơdi-tơdài. Rùp-phŭn ñu la mơnih hơdơi rơŭ pơblơ̆-dră Pô. ");
INSERT INTO cje_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Hơdơi du bruă nư̆n, Yàng Jêsu nau lăm abih c̆àr Galile. Pô 'buh khiăng nau lăm c̆àr Juđe, kơyoa buơl làng Juđa duah pơmơtai Pô. ");
INSERT INTO cje_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Bloh tŭ pơnuaĭ pơjŭm 'bơ̆ng Pờ-Sơndờp Sơdăng mơnih Juđa truh jĕ, ");
INSERT INTO cje_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","adơi-ai Yàng Jêsu đờm sơ̆ng Pô: “Sơ-ai luơi bĕ anih ni sơ̆ng nau truh tơ c̆àr Juđe, tô du mơnih tui-mơgru sơ-ai hũ 'buh tơgrơ̆ bruă sơ-ai ngă. ");
INSERT INTO cje_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Kơyoa 'buh aràng sơi khiăng hũ tơgrơ̆ mơnih thơu truh bloh lài ngă bruă lăm sa anih tơrđơŭ-bơdơŭ jiơ̆ng. Yah sơ-ai hũ ngă jiơ̆ng du bruă ni, nư̆n sơ-ai ràng-tơbiă bĕ rùp-phŭn drơi tơ plơi-lơgăr thơu!” ");
INSERT INTO cje_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Kơyoa tŭ nư̆n, rùp-phŭn du adơi Pô kŭng 'buh păng-tui Pô. ");
INSERT INTO cje_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yàng Jêsu đờm sơ̆ng buơl guñu: “Tŭ-jơ kơu ka truh, bloh sơ̆ng buơl adơi, nư̆n tŭ lơi kŭng jiơ̆ng. ");
INSERT INTO cje_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Dun-ya 'buh rơgơi mơbai buơl adơi, bloh mơbai kơu, kơyoa kơu ngă grơh lài du bruă buơl guñu ngă la mơsak-jơhà. ");
INSERT INTO cje_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Buơl adơi nau pơjŭm 'bơ̆ng bĕ. Dò kơu, tŭ ni kơu ka rơgơi nau jiơ̆ng, kơyoa tŭ-jơ kơu ka truh.” ");
INSERT INTO cje_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Hơdơi tŭ đờm du pơnuaĭ ni, Pô dò wơ̆ lăm c̆àr Galile. ");
INSERT INTO cje_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Bloh hơdơi tŭ adơi-ai Pô hũ đì nau pơjŭm 'bơ̆ng bơjơ, nư̆n Pô kŭng nau, bloh Pô nau tơrđơŭ bơdơŭ, 'buh luơi aràng 'buh. ");
INSERT INTO cje_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Du mơnih Juđa duah Pô lăm hơrơi pơjŭm 'bơ̆ng, sơ̆ng đờm: “Anih lơi ñu dò haìh?” ");
INSERT INTO cje_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Lăm tơrpuơl buơl làng đờm bơyai-sơnư̆ng lô mư̆ng Pô. Mơnih nư̆n đờm: “Nư̆n la sa aràng mơnih siàm.” Mơnih pơkơ̆n wơ̆ đờm: “'Buh iơŭ ơu, ñu la mơnih pơluơ pơ̆ng-gơla buơl làng!” ");
INSERT INTO cje_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Bloh 'buh hũ aràng sơi khĭn đờm mư̆ng Pô tơ anaŭ mơnih lô, kơyoa buơl guñu huơĭ tơ du mơnih apăn-akŏ buơl làng Juđa. ");
INSERT INTO cje_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Truh tơkrah pơnuaĭ pơjŭm 'bơ̆ng, Yàng Jêsu đì tơ sàng duh-dơlbăt sơ̆ng pơto-mơblàng. ");
INSERT INTO cje_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Du mơnih Juđa mă ngă krơi-takơtuă biă, đờm lài: “Mơnih ni 'buh ka nau mơgru bloh hơyơu wờng thơu dơrlăm mư̆ng 'Bồn Bơ-àr Sơc̆ih-Sri yơu nư̆n?” ");
INSERT INTO cje_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yàng Jêsu đờm: “Pơnuaĭ Kơu pơto 'buh iơŭ la mư̆ng Kơu, bloh la mư̆ng Pô hũ pơđăr Kơu truh. ");
INSERT INTO cje_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Yah aràng sơi hũ hơtai-hơtiàn ngă tui hơtai-khiăng Yàng Pô Lơngì, nư̆n rơŭ thơu pơnuaĭ Kơu pơto la truh mư̆ng Yàng Pô Lơngì halài Kơu đờm tui hơtai drơi. ");
INSERT INTO cje_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Mơnih lơi đờm tui hơtai rùp-phŭn drơi, nư̆n duah pơnuaĭ màng-kơc̆rà tơ rùp-phŭn drơi, bloh aràng sơi duah pơnuaĭ màng-kơc̆rà tơ Pô hũ pơđăr drơi, nư̆n la mơnih tơpă-tơpe, sơ̆ng lăm mơnih nư̆n 'buh hũ pơnuaĭ hơgĕ 'buh rĭng-tơpă. ");
INSERT INTO cje_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Môise 'buh hũ brơi pơnuaĭ adăt-adia tơ buơl guhã ơu? Nư̆n bloh 'buh sa aràng mơnih lơi lăm buơl guhã păng-rơmiă ngă tui pơnuaĭ adăt-adia! Kơđa hơgĕ buơl guhã khiăng duah pơmơtai Kơu?” ");
INSERT INTO cje_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Buơl làng đờm sơđồ: “Pô-Pơto kơđòng kơmlài ngă bơjơ! Aràng sơi la mơnih duah pơmơtai Pô-Pơto?” ");
INSERT INTO cje_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yàng Jêsu đờm: “Kơu hũ ngă sa bruă bloh abih buơl guhã mă ngă krơi-takơtuă. ");
INSERT INTO cje_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Môise hũ brơi adăt sơkaŭ-kơlì tơ buơl guhã (iơŭ biă, adăt nư̆n 'buh iơŭ kơyoa mư̆ng Môise, bloh kơyoa mư̆ng du kơi-kŏ pàng-yau), sơ̆ng buơl guhã sơkaŭ-kơlì tơ mơnih lơkơi lăm hơrơi sa'bat. ");
INSERT INTO cje_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Yah sa aràng mơnih lơkơi hũ rơgơi đồ-mă adăt sơkaŭ-kơlì lăm hơrơi sa'bat tô 'buh ngă sŭng adăt-adia Môise, nư̆n kơđa hơgĕ buơl guhã anok hơtai sơ̆ng Kơu tŭ Kơu hũ pơsồ-pơsaih tơ abih sa boh rùp-phàp tơ sa aràng mơnih lăm hơrơi sa'bat? ");
INSERT INTO cje_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Juơi c̆ahrơña tui gah agàh, bloh păl c̆ahrơña bĕ tui adăt rĭng-tơpă.” ");
INSERT INTO cje_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Hũ du mơnih lăm buơl làng plơi-prŏng Jerusalem đờm lài: “Ni 'buh iơŭ la mơnih bloh aràng duah pơmơtai ơu? ");
INSERT INTO cje_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","C̆ơ dih, ñu đờm tơ anaŭ abih tơgrơ̆ mơnih, bloh 'buh aràng sơi đờm hơgĕ tơ ñu. Halài du mơnih gơnuăr apăn-akŏ hũ kràn thơu mơnih ni biă la Pô Krist? ");
INSERT INTO cje_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Bloh tŭ Pô Krist truh, nư̆n 'buh aràng sơi thơu Pô mư̆ng lơi truh, dò mơnih ni nư̆n buơl gudrơi thơu truh mư̆ng lơi.” ");
INSERT INTO cje_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Tŭ dò pơto-mơblàng lăm sàng duh-dơlbăt, Yàng Jêsu pồ săp đờm prŏng lài: “Biă, buơl guhã thơu Kơu sơ̆ng kŭng thơu Kơu mư̆ng lơi truh! Kơu 'buh kơyoa mư̆ng rùp-phŭn drơi bloh truh, bloh Pô hũ pơđăr Kơu la Pô tơpă-tơpe. Buơl guhã 'buh thơu Pô. ");
INSERT INTO cje_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Bloh Kơu thơu Pô, kơyoa Kơu mư̆ng Pô truh, sơ̆ng Pô la Pơtau hũ pơđăr Kơu truh.” ");
INSERT INTO cje_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Yơu nư̆n, buơl guñu duah pơnuaĭ mă Pô, bloh 'buh aràng sơi khĭn gơ-yời tơngàn mă Pô, kơyoa tŭ jơ Pô ka truh. ");
INSERT INTO cje_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Bloh hũ lô mơnih lăm buơl làng păng-tui Pô, sơ̆ng đờm lài: “Tŭ Pô Krist truh, Pô rơŭ ngă lô nàl-c̆rih rơlau tơ mơnih ni hũ ngă ơu?” ");
INSERT INTO cje_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Tŭ du mơnih Pharisi mơhư̆ pơnuaĭ buơl làng đờm sơnư̆ng bơyai mư̆ng Yàng Jêsu yơu nư̆n, buơl guñu sơ̆ng du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt pơđăr du mơnih lĭng khiă-gàr sàng duh-dơlbăt nau mă Pô. ");
INSERT INTO cje_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Kơyoa nư̆n, Yàng Jêsu đờm sơ̆ng buơl guñu: “Kơu rơŭ dò sơ̆ng buơl guhã sa-sĭt suơi tra soh, bloh nư̆n Kơu nau truh sơ̆ng Pô hũ pơđăr Kơu. ");
INSERT INTO cje_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Buơl guhã rơŭ duah Kơu, bloh 'buh tòm, sơ̆ng anih Kơu dò, buơl guhã 'buh rơgơi truh jiơ̆ng.” ");
INSERT INTO cje_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Du mơnih Juđa đờm sơ̆ng gơŭ: “Mơnih ni rơŭ nau anih lơi bloh buơl gudrơi 'buh duah jiơ̆ng? Hũ iơŭ ñu rơŭ nau truh sơ̆ng buơl làng gudrơi dò hơdiŭ c̆ơrlah-c̆ơrlờp tơkrah du mơnih Grek, sơ̆ng pơto-akhàn tơ mơnih Grek ơu? ");
INSERT INTO cje_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ñu khiăng đờm hơgĕ tŭ đờm: ‘Buơl guhã rơŭ duah Kơu, bloh 'buh tòm,’ sơ̆ng: ‘anih Kơu dò, buơl guhã 'buh rơgơi truh jiơ̆ng’?” ");
INSERT INTO cje_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Hơrơi luĭ-dŭt, la hơrơi prŏng-màng rơlau abih lăm pơnuaĭ pơjŭm 'bơ̆ng, Yàng Jêsu tơgồ dơ̆ng sơ̆ng đờm prŏng săp lài: “Yah mơnih lơi mơhau, truh bĕ sơ̆ng Kơu bloh mơñŭm! ");
INSERT INTO cje_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Aràng sơi păng-tui Kơu, nư̆n du kròng ia pơnuaĭ hơdiŭ rơŭ c̆ă tơbiă mư̆ng hơtai-hơtiàn drơi, iơŭ yơu pơnuaĭ 'Bồn Bơ-àr Sơc̆ih-Sri hũ wă.” ");
INSERT INTO cje_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yàng Jêsu khiăng đờm mư̆ng Bơngă Sơc̆ih-Sri bloh du mơnih păng-tui Pô rơŭ đồ-mă hũ. Kơyoa tŭ nư̆n Bơngă Sơc̆ih-Sri ka hũ brơi trŭn, kơyoa Yàng Jêsu ka hũ màng-kơc̆rà. ");
INSERT INTO cje_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Tŭ tơrpuơl buơl làng mơhư̆ du pơnuaĭ ni, hũ du mơnih đờm: “Mơnih ni iơŭ tơpă biă la sa aràng mơnih gơnuăr-hwơ̆r.” ");
INSERT INTO cje_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Du mơnih pơkơ̆n nư̆n đờm: “Ni la Pô Krist.” Bloh du mơnih pơkơ̆n wơ̆ đờm: “Pô Krist bloh lài truh mư̆ng c̆àr Galile? ");
INSERT INTO cje_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","'Buh iơŭ 'Bồn Bơ-àr Sơc̆ih-Sri đờm lài, Pô Krist păl tơbiă mư̆ng jơi-pơtiàn pơtau Đabit, sơ̆ng păl truh mư̆ng 'Betlehem, la plơi pơtau Đabit ơu?” ");
INSERT INTO cje_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Yơu nư̆n, kơyoa Pô bloh buơl làng pơc̆ơrlah krơi gơŭ. ");
INSERT INTO cje_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Hũ du mơnih lăm buơl làng khiăng mă Pô, bloh 'buh aràng sơi khĭn gơ-yời tơngàn mă Pô. ");
INSERT INTO cje_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Kơyoa nư̆n, tơrpuơl lĭng khiă-gàr sàng duh-dơlbăt gài mơrai wơ̆ sơ̆ng du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt sơ̆ng du mơnih Pharisi. Du mơnih ni tơnia buơl guñu: “Kơđa hơgĕ buơl guhã 'buh ba ñu truh tơ ni?” ");
INSERT INTO cje_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Buơl lĭng khiă-gàr sàng duh-dơlbăt đờm sơđồ: “Buơl dơlhă ka tŭ lơi mơhư̆ mơnih lơi đờm yơu mơnih ni.” ");
INSERT INTO cje_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Du mơnih Pharisi đờm sơ̆ng buơl guñu: “Găm buơl guhã kŭng kơđòng pơluơ pơ̆ng-gơla rơi? ");
INSERT INTO cje_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Hũ ràng sơi lăm du mơnih gơnuăr apăn-akŏ halài lăm du mơnih Pharisi păng-tui mơnih nư̆n ơu? ");
INSERT INTO cje_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Mĭn hũ tơrpuơl buơl làng ni soh, buơl mơnih 'buh thơu pơnuaĭ adăt-adia sa-sĭt lơi. Biă, guñu la buơl làng iơŭ păl kŏng pơc̆ĕ-pơtrah!” ");
INSERT INTO cje_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Lăm tơrpuơl Pharisi, hũ sa aràng mơnih angăn la Nikôđem, mơnih mư̆ng dơlhơu hũ truh tòm Yàng Jêsu lăm glai mơlăm, đờm sơ̆ng buơl guñu: ");
INSERT INTO cje_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Pơnuaĭ adăt-adia buơl gudrơi hũ brơi gơnuăr buơl gudrơi ngă nìn-glài mơnih lơi, dơlhơu tơ tŭ păng mơnih nư̆n đờm sơ̆ng thơu loh-làng mơnih nư̆n ngă hơgĕ ơu?” ");
INSERT INTO cje_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Buơl guñu đờm: “Hã kŭng la mơnih Galile rơi? Hã kừ c̆ơ duah bĕ, bloh nư̆n rơŭ 'buh: 'buh sa aràng mơnih gơnuăr-hwơ̆r lơi tơbiă mư̆ng Galile ơu!” ");
INSERT INTO cje_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Bloh nư̆n, aràng sơi aràng nư̆n gài wơ̆ tơ sàng drơi. ");
INSERT INTO cje_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Bloh Yàng Jêsu nư̆n đì tơ c̆ơ̆ Ôlibe. ");
INSERT INTO cje_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Truh rìng sơrdah, Pô gài wơ̆ tơ sàng duh-dơlbăt. Buơl làng ba gơŭ truh sơ̆ng Pô. Pô dò guh sơ̆ng pơto-mơblàng buơl guñu. ");
INSERT INTO cje_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Tŭ nư̆n, du mơnih gơnuăr-pơto pơnuaĭ adăt-adia sơ̆ng du mơnih Pharisi ba truh tơ Pô sa aràng mơnih kơmơi kơđòng aràng mă lăm tŭ ngă glài klĕ sơdiŭ-aràng pơsàng-gơŭ. Buơl guñu luơi mơnih kơmơi nư̆n dò dơ̆ng tơkrah tơrpuơl mơnih lô, ");
INSERT INTO cje_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","bloh nư̆n đờm sơ̆ng Pô: “Ơ Pô-Pơto, mơnih kơmơi ni kơđòng aràng mă lăm tŭ ngă glài klĕ-sơdiŭ aràng pơsàng-gơŭ. ");
INSERT INTO cje_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Lăm pơnuaĭ adăt-adia, Môise hũ pơto buơl gudrơi păl prah pơtơu pơmơtai du mơnih yơu nư̆n. Dò Pô-Pơto, nư̆n Pô-Pơto sơnư̆ng hơyơu lơi?” ");
INSERT INTO cje_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Buơl guñu đờm yơu nư̆n tô lòng Pô, tô hũ rơgơi yă Pô. Bloh Yàng Jêsu kù tơ ala, mă anà tơngàn wă tơ ngŏ lơ̆n. ");
INSERT INTO cje_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Kơyoa buơl guñu kừ tơnia mĭt, nư̆n Pô tơgồ dơ̆ng sơ̆ng đờm: “Aràng sơi lăm buơl guhã la mơnih 'buh hũ glài-sơnoh, nư̆n mă bĕ pơtơu bloh prah mơnih kơmơi ni dơlhơu!” ");
INSERT INTO cje_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Bloh nư̆n Pô kù tơ ala wơ̆ sơ̆ng wă tơ ngŏ lơ̆n. ");
INSERT INTO cje_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Tŭ buơl guñu mơhư̆ pơnuaĭ ni nư̆n tui tơkai gơŭ tơbiă nau, du mơnih glòng thŭn nau dơlhơu. Mĭn dò wơ̆ sa aràng Yàng Jêsu sơ̆ng mơnih kơmơi, sơđaŭ dò dơ̆ng tơkrah anih nư̆n. ");
INSERT INTO cje_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yàng Jêsu tơgồ dơ̆ng, đờm sơ̆ng mơnih kơmơi: “Ơ mơnih kơmơi dih, du mơnih đờm yă hã, buơl guñu nau anih lơi abih bơjơ? 'Buh aràng sơi ngă nìn-glài hã ơu?” ");
INSERT INTO cje_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Mơnih kơmơi đờm: “Khoai Yàng, 'buh hũ aràng sơi ơu!” Yàng Jêsu đờm: “Kơu kŭng 'buh ngă nìn-glài hã ơu. Nau bĕ, mư̆ng ni juơi ngă glài-sơnoh tra.” ");
INSERT INTO cje_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yàng Jêsu đờm wơ̆ sơ̆ng buơl guñu lài: “Kơu la pơnuaĭ sơrdah dun-ya, mơnih lơi tui Kơu rơŭ 'buh nau lăm pơnuaĭ mơsrư̆-kơnăm, bloh rơŭ đồ-mă hũ pơnuaĭ sơrdah ba truh pơnuaĭ hơdiŭ.” ");
INSERT INTO cje_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Du mơnih Pharisi đờm: “Rùp-phŭn Pô-Pơto ngă grơh tơ rùp-phŭn drơi, nư̆n pơnuaĭ Pô-Pơto ngă grơh la 'buh tơpă.” ");
INSERT INTO cje_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yàng Jêsu đờm: “Yah Kơu hũ ngă grơh mư̆ng rùp-phŭn drơi, nư̆n pơnuaĭ ngă grơh Kơu sơđaŭ la tơpă, kơyoa Kơu thơu drơi mư̆ng lơi truh sơ̆ng rơŭ nau anih lơi. Bloh buơl guhã 'buh thơu Kơu truh mư̆ng lơi sơ̆ng rơŭ nau anih lơi. ");
INSERT INTO cje_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Buơl guhã c̆ahrơña tui rùp-phàp drah-rơlo; dò Kơu 'buh c̆ahrơña aràng sơi ơu. ");
INSERT INTO cje_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Bloh yah Kơu c̆ahrơña, nư̆n pơnuaĭ Kơu c̆ahrơña sơđaŭ iơŭ pơnuaĭ tơpă, kơyoa Kơu 'buh c̆ahrơña sa aràng drơi, bloh hũ Kơu sơ̆ng Ama la Pô hũ pơđăr Kơu. ");
INSERT INTO cje_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Lăm pơnuaĭ adăt-adia buơl guhã hũ wă lài yah hũ dua aràng mơnih ngă grơh, nư̆n pơnuaĭ ngă grơh nư̆n la tơpă biă. ");
INSERT INTO cje_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Kơu ngă grơh tơ rùp-phŭn Kơu, sơ̆ng Ama, la Pô hũ pơđăr Kơu, kŭng ngă grơh tơ Kơu.” ");
INSERT INTO cje_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Kơyoa nư̆n, buơl guñu tơnia Pô: “Ama Pô-Pơto dò anih lơi?” Yàng Jêsu đờm: “Buơl guhã 'buh thơu Kơu, kŭng 'buh thơu Ama Kơu. Yah buơl guhã thơu Kơu, nư̆n kŭng thơu Ama Kơu rơi.” ");
INSERT INTO cje_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yàng Jêsu hũ đờm du pơnuaĭ nư̆n tŭ Pô pơto-mơblàng lăm sàng duh-dơlbăt, jĕ tơ anih daŭ thŭng pioh priă pơyă. Bloh 'buh hũ aràng sơi mă Pô, kơyoa jơ Pô ka truh. ");
INSERT INTO cje_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yàng Jêsu đờm wơ̆ sơ̆ng buơl guñu: “Kơu nau, buơl guhã rơŭ duah Kơu, sơ̆ng buơl guhã rơŭ mơtai lăm glài-sơnoh drơi. Anih Kơu nau, buơl guhã 'buh rơgơi truh jiơ̆ng.” ");
INSERT INTO cje_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Du mơnih Juđa đờm: “Ñu rơŭ pơmơtai rùp-phŭn halài hơyơu bloh ñu đờm lài: ‘Anih Kơu nau, buơl guhã 'buh rơgơi truh jiơ̆ng?’ ” ");
INSERT INTO cje_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yàng Jêsu đờm: “Buơl guhã mư̆ng dun-ya ni bloh tơbiă, dò Kơu mư̆ng ngŏ lơngì bloh trŭn. Buơl guhã găm sơ̆ng dun-ya ni, dò Kơu 'buh găm sơ̆ng dun-ya ni. ");
INSERT INTO cje_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Kơyoa nư̆n, Kơu hũ đờm tơ buơl guhã thơu, buơl guhã rơŭ mơtai lăm glài-sơnoh drơi. Biă yơu nư̆n, yah buơl guhã 'buh păng-tui Kơu la Pô nư̆n, buơl guhã rơŭ mơtai lăm glài-sơnoh drơi.” ");
INSERT INTO cje_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Buơl guñu tơnia Pô: “Yơu nư̆n Pô-Pơto la aràng sơi?” Yàng Jêsu đờm: “Yơu Kơu hũ đờm sơ̆ng buơl guhã mư̆ng tŭ c̆ơmrừp. ");
INSERT INTO cje_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Kơu hũ lô pơnuaĭ tô đờm sơ̆ng c̆ahrơña mư̆ng buơl guhã. Bloh Pô hũ pơđăr Kơu truh la tơpă-tơpe, sơ̆ng Kơu păl đờm tơ dun-ya thơu tơgrơ̆ pơnuaĭ hơgĕ Kơu hũ mơhư̆ anih Pô.” ");
INSERT INTO cje_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Buơl guñu 'buh wờng lài Yàng Jêsu dò đờm sơ̆ng buơl guñu mư̆ng Pô Yàng Ama. ");
INSERT INTO cje_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Kơyoa nư̆n, Yàng Jêsu đờm lài: “Tŭ buơl guhã yuăl Anà Mơnih tơ ngŏ, tŭ nư̆n buơl guhã rơŭ thơu Kơu la Pô nư̆n, sơ̆ng buơl guhã rơŭ thơu lài Kơu 'buh mư̆ng rùp-phŭn drơi ngă pơnuaĭ hơgĕ, bloh Kơu đờm du pơnuaĭ Ama hũ pơto Kơu. ");
INSERT INTO cje_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Pô hũ pơđăr Kơu sơđaŭ dò sơ̆ng Kơu. Pô 'buh luơi Kơu dò sa aràng, kơyoa Kơu mĭt-mĭt ngă tơgrơ̆ pơnuaĭ siàm hơtai Pô.” ");
INSERT INTO cje_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Tŭ Pô đờm du pơnuaĭ ni, nư̆n hũ lô mơnih păng-tui Pô. ");
INSERT INTO cje_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Tŭ nư̆n Yàng Jêsu đờm sơ̆ng du mơnih Juđa hũ păng-tui Pô: “Yah buơl guhã kừ dò mĭt lăm pơnuaĭ Kơu, nư̆n buơl guhã biă la mơnih tui-mơgru Kơu. ");
INSERT INTO cje_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Buơl guhã rơŭ thơu pơnuaĭ-tơpă, sơ̆ng pơnuaĭ-tơpă rơŭ toh-tơleh buơl guhã.” ");
INSERT INTO cje_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Mơnih Juđa tơnia Pô: “Buơl dơlhă la jơi-pơtiàn Abraham. Buơl dơlhă ka tŭ lơi ngă hơlŭn-hơlă aràng sơi. Kơđa hơgĕ Pô-Pơto đờm lài: ‘Buơl guhã rơŭ hũ akŏ-lơhuai tơkai-lơnàng’?” ");
INSERT INTO cje_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yàng Jêsu đờm: “Iơŭ biă, Kơu đờm sơ̆ng buơl guhã, aràng sơi ngă glài-sơnoh la ngă hơlŭn-hơlă tơ glài-sơnoh. ");
INSERT INTO cje_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Mơnih hơlŭn-hơlă nư̆n 'buh dò mĭt lăm sàng, bloh du anà nư̆n hũ dò lăm sàng mĭt-mĭt. ");
INSERT INTO cje_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Yơu nư̆n, yah Anà toh-tơleh tơ buơl guhã, nư̆n buơl guhã rơŭ biă-biài hũ akŏ-lơhuai tơkai-lơnàng. ");
INSERT INTO cje_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Kơu thơu buơl guhã la jơi-pơtiàn Abraham, bloh buơl guhã duah pơnuaĭ tô pơmơtai Kơu, kơyoa pơnuaĭ Kơu 'buh hũ anih lăm hơtai-hơtiàn buơl guhã. ");
INSERT INTO cje_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Kơu đờm du pơnuaĭ Kơu hũ 'buh anih Ama Kơu; dò buơl guhã ngă du pơnuaĭ buơl guhã hũ mơhư̆ anih ama drơi.” ");
INSERT INTO cje_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Buơl guñu đờm sơ̆ng Pô: “Ama buơl dơlhă la Abraham!” Yàng Jêsu đờm: “Yah buơl guhã la anà-tơc̆o Abraham, nư̆n buơl guhã păl ngă du bruă Abraham hũ ngă. ");
INSERT INTO cje_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Bloh tŭ ni buơl guhã duah pơmơtai Kơu, la mơnih hũ đờm tơ buơl guhã pơnuaĭ-tơpă hũ mơhư̆ mư̆ng Yàng Pô Lơngì. Abraham 'buh hũ ngă du bruă yơu nư̆n! ");
INSERT INTO cje_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Buơl guhã ngă du bruă ama buơl guhã ngă.” Buơl guñu đờm: “Buơl dơlhă 'buh iơŭ la anà pơyu-pơjàng. Buơl dơlhă mĭn hũ sa Ama, la Yàng Pô Lơngì.” ");
INSERT INTO cje_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yàng Jêsu đờm sơ̆ng buơl guñu: “Yah Yàng Pô Lơngì la Ama buơl guhã, nư̆n buơl guhã păl rơnăm Kơu; kơyoa Kơu tơbiă mư̆ng Yàng Pô Lơngì, sơ̆ng Kơu mư̆ng Pô bloh truh. Kơu 'buh kơyoa rùp-phŭn drơi truh tơ anih ni, bloh rùp-phŭn Pô hũ pơđăr Kơu truh. ");
INSERT INTO cje_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Kơđa hơgĕ buơl guhã 'buh wờng pơnuaĭ Kơu đờm? Nư̆n la kơyoa buơl guhã 'buh rơgơi păng jiơ̆ng pơnuaĭ Kơu. ");
INSERT INTO cje_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Buơl guhã tơbiă mư̆ng ama drơi la kơmlài-jĭnràk, sơ̆ng buơl guhã rơwah ngă tui pơnuaĭ ama buơl guhã khiăng. Mư̆ng tŭ c̆ơmrừp, ñu la mơnih pơmơtai mơnih. Ñu 'buh dò dơ̆ng gah pơnuaĭ-tơpă, kơyoa pơnuaĭ-tơpă 'buh dò lăm ñu. Tŭ ñu đờm lơ̆r, nư̆n ñu đờm tui hơtai-phŭn drơi, kơyoa ñu la mơnih đờm lơ̆r, sơ̆ng la ama pơnuaĭ đờm lơ̆r. ");
INSERT INTO cje_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Bloh kơyoa Kơu đờm pơnuaĭ-tơpă, nư̆n buơl guhã 'buh păng-tui Kơu. ");
INSERT INTO cje_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Aràng sơi lăm buơl guhã ngă grơh jiơ̆ng la Kơu hũ glài? Yơu nư̆n yah Kơu đờm pơnuaĭ tơpă, kơđa hơgĕ buơl guhã 'buh păng-tui Kơu? ");
INSERT INTO cje_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Aràng sơi tơbiă mư̆ng Yàng Pô Lơngì, nư̆n păng pơnuaĭ Yàng Pô Lơngì. Buơl guhã 'buh khiăng păng, kơyoa buơl guhã 'buh iơŭ la du anà Yàng Pô Lơngì.” ");
INSERT INTO cje_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Du mơnih Juđa đờm: “Buơl dơlhă đờm Pô-Pơto la mơnih Samari, sơ̆ng kơđòng kơmlài ngă, 'buh iơŭ ơu?” ");
INSERT INTO cje_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yàng Jêsu đờm sơđồ: “Kơu 'buh kơđòng kơmlài ngă, bloh Kơu mơyòm-pơglòng Ama Kơu, dò buơl guhã nư̆n ngă pơtăt-pơmơlơu Kơu. ");
INSERT INTO cje_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Kơu 'buh tui duah pơnuaĭ màng-kơc̆rà tơ rùp-phŭn drơi, kơyoa hũ Pô duah pơnuaĭ nư̆n tơ Kơu sơ̆ng c̆ahrơña tơ Kơu. ");
INSERT INTO cje_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Iơŭ biă, Kơu đờm sơ̆ng buơl guhã, yah aràng sơi păng-rơmiă pơnuaĭ Kơu, nư̆n rơŭ 'buh tŭ lơi 'buh pơnuaĭ mơtai.” ");
INSERT INTO cje_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Du mơnih Juđa đờm: “Tŭ ni, buơl dơlhă thơu nìn biă la Pô-Pơto kơđòng kơmlài ngă. Abraham mơtai bơjơ, du mơnih gơnuăr-hwơ̆r kŭng yơu nư̆n rơi; nư̆n bloh Pô-Pơto đờm: ‘Yah aràng sơi păng-rơmiă pơnuaĭ Kơu, nư̆n rơŭ 'buh tŭ lơi păl mơtai.’ ");
INSERT INTO cje_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Kơi-kŏ pàng-yau buơl dơlhă la Abraham, mơnih mơtai bơjơ. Pô-Pơto khĭn brơi drơi prŏng rơlau tơ Abraham? Du mơnih gơnuăr-hwơ̆r kŭng mơtai bơjơ. Pô-Pơto brơi rùp-phŭn drơi la aràng sơi?” ");
INSERT INTO cje_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yàng Jêsu đờm: “Yah Kơu mơyòm-pơglòng rùp-phŭn drơi, nư̆n pơnuaĭ màng-kơc̆rà nư̆n 'buh tơbiă hơgĕ. Pô mơyòm-pơglòng Kơu la rùp-phŭn Ama Kơu, Pô bloh buơl guhã angăn la Yàng Pô Lơngì drơi. ");
INSERT INTO cje_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Buơl guhã 'buh thơu Pô, bloh Kơu thơu Pô. Yah Kơu đờm Kơu 'buh thơu Pô, nư̆n Kơu kŭng đờm lơ̆r yơu buơl guhã rơi. Bloh Kơu thơu Pô sơ̆ng păng-bơbah păng-rơmiă pơnuaĭ Pô. ");
INSERT INTO cje_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Kơi-kŏ pàng-yau buơl guhã la Abraham hũ sờh-sài kraŭ-c̆àng hũ 'buh hơrơi Kơu. Ñu hũ 'buh bơjơ, sơ̆ng sờh-sài.” ");
INSERT INTO cje_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Du mơnih Juđa đờm: “Pô-Pơto ngă hơyơu 'buh jiơ̆ng Abraham lăm tŭ Pô-Pơto ka tơ̆l lơma pluh thŭn?” ");
INSERT INTO cje_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yàng Jêsu đờm: “Iơŭ biă, Kơu đờm sơ̆ng buơl guhã, dơlhơu tŭ ka hũ Abraham, hũ Kơu bơjơ.” ");
INSERT INTO cje_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Tŭ nư̆n, buơl guñu duơ̆n pơtơu tô prah pơmơtai Pô, bloh Yàng Jêsu pleh nau iờp, sơ̆ng tơbiă mư̆ng sàng duh-dơlbăt. ");
INSERT INTO cje_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Lăm tŭ nau jơlàn, Yàng Jêsu 'buh sa aràng mơnih bồm mư̆ng tŭ pơrpa đih apui. ");
INSERT INTO cje_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Du mơnih tui-mơgru tơnia Pô: “Ơ Pô-Pơto, aràng sơi la mơnih ngă glài, mơnih ni halài ame ama ñu, bloh pơrpa đih apui tơbiă ñu păl kŏng bồm yơu nư̆n?” ");
INSERT INTO cje_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yàng Jêsu đờm: “'Buh iơŭ kơyoa ñu, kŭng 'buh iơŭ kơyoa ame ama ñu hũ ngă glài ơu, bloh nư̆n la tô du bruă Yàng Pô Lơngì hũ ràng-tơbiă lăm ñu. ");
INSERT INTO cje_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Tŭ dò glai hơrơi, Kơu păl ngă tơgrơ̆ bruă Pô hũ pơđăr Kơu. Mơlăm truh, nư̆n 'buh aràng sơi ngă bruă jiơ̆ng. ");
INSERT INTO cje_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Lăm tŭ Kơu dò lăm dun-ya, Kơu la pơnuaĭ sơrdah dun-ya.” ");
INSERT INTO cje_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Hơdơi tŭ đờm yơu nư̆n, Pô kơc̆uh tơ ala lơ̆n, mă ia bơbah jrơu jiơ̆ng gluh, sơ̆ng lŭ lăm mơta mơnih bồm, ");
INSERT INTO cje_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","bloh nư̆n Pô đờm sơ̆ng ñu: “Nau bĕ, truh dơnau Silôe bloh rào.” (Silôe hũ mơblàng la: “hũ pơđăr nau”). Yơu nư̆n ñu nau, rào, sơ̆ng gài wơ̆, nư̆n mơta hũ 'buh jiơ̆ng. ");
INSERT INTO cje_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Du mơnih gơŭ-plơi găm sơ̆ng du mơnih dơlhơu thrơi jiăng 'buh ñu nau yòng, đờm lài: “Ni hũ iơŭ la mơnih sơđaŭ jiăng dò guh yòng ơu?” ");
INSERT INTO cje_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Hũ mơnih đờm: “Rùp-phŭn ñu nư̆n!” Mơnih pơkơ̆n wơ̆ đờm: “'Buh iơŭ ơu, bloh la sa aràng mơnih lơi mơhiơ̆ yơu ñu.” Bloh mơnih bồm đờm: “Rùp-phŭn dơlhă ni!” ");
INSERT INTO cje_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Du mơnih nư̆n tơnia ñu: “Ngă hơyơu mơta hã hũ c̆ơ 'buh jiơ̆ng?” ");
INSERT INTO cje_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ñu đờm sơđồ lài: “Sa aràng mơnih angăn la Jêsu, mơnih nư̆n mă gluh lŭ lăm mơta dơlhă, bloh nư̆n pơđăr dơlhă nau truh tơ dơnau Silôe bloh rào. Dơlhă nau truh, rào tơ anih nư̆n, sơ̆ng mơta dơlhă hũ 'buh jiơ̆ng.” ");
INSERT INTO cje_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Buơl guñu tơnia wơ̆: “Mơnih nư̆n dò anih lơi?” Ñu đờm: “Dơlhă 'buh thơu!” ");
INSERT INTO cje_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Buơl guñu ba mơnih bồm pơrpa hũ pơsồ-pơsaih truh sơ̆ng du mơnih Pharisi. ");
INSERT INTO cje_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Hơrơi Yàng Jêsu jrơu gluh sơ̆ng pơh mơta tơ mơnih bồm la hơrơi sa'bat. ");
INSERT INTO cje_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Du mơnih Pharisi tơnia ñu ngă hơyơu mơta hũ c̆ơ 'buh jiơ̆ng. Ñu đờm sơđồ: “Mơnih nư̆n mă gluh lŭ lăm mơta dơlhă, bloh nư̆n dơlhă nau rào sơ̆ng c̆ơ 'buh jiơ̆ng.” ");
INSERT INTO cje_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Lăm tơrpuơl Pharisi, hũ du mơnih đờm: “Mơnih ni 'buh iơŭ mư̆ng Yàng Pô Lơngì truh ơu, kơyoa c̆ơ 'buh sơ̆p tơ hơrơi sa'bat.” Bloh du mơnih pơkơ̆n nư̆n đờm: “Sa aràng mơnih glài-sơnoh hơyơu hũ rơgơi ngă jiơ̆ng du nàl-c̆rih yơu nư̆n?” Nư̆n la tơkrah buơl guñu hũ pơnuaĭ pơc̆ơrlah krơi gơŭ. ");
INSERT INTO cje_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Kơyoa nư̆n, buơl guñu pơtrah wơ̆ tơnia mơnih bồm pơrpa hũ pơsồ-pơsaih mơta: “Hã sơnư̆ng hơyơu lơi mư̆ng mơnih hũ pơsồ-pơsaih mơta tơ hã?” Ñu đờm: “Mơnih nư̆n la sa aràng mơnih gơnuăr-hwơ̆r.” ");
INSERT INTO cje_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Bloh, mơnih Juđa 'buh păng-tui lài mơnih ni mư̆ng dơlhơu la mơnih bồm bloh ni hũ c̆ơ 'buh jiơ̆ng, tơ̆l truh tŭ buơl guñu iơu ame ama ñu truh. ");
INSERT INTO cje_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Buơl guñu tơnia: “Ni hũ iơŭ la anà lơkơi buơl guhã ơu? Mơnih bloh buơl guhã đờm lài ñu bồm mơta mư̆ng tŭ pơrpa đih apui! Yơu nư̆n kơđa hơgĕ tŭ ni mơta ñu hũ c̆ơ 'buh jiơ̆ng?” ");
INSERT INTO cje_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ame ama ñu đờm sơđồ: “Buơl dơlhă thơu ni la rùp-phŭn anà lơkơi buơl dơlhă, sơ̆ng ñu hũ bồm mơta mư̆ng tŭ pơrpa đih apui. ");
INSERT INTO cje_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Bloh tŭ ni ngă hơyơu mơta ñu hũ c̆ơ 'buh jiơ̆ng, nư̆n buơl dơlhă 'buh thơu. Buơl dơlhă kŭng 'buh thơu aràng sơi hũ pơsồ-pơsaih mơta tơ ñu. Ñu hũ tơ̆l thŭn sơ̆ng prŏng bơjơ, tơnia bĕ ñu, rùp-phŭn ñu rơŭ đờm tơbiă.” ");
INSERT INTO cje_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ame ama mơnih bồm đờm yơu nư̆n kơyoa huơĭ tơ mơnih Juđa. Kơyoa mơnih Juđa hũ đờm ngă-nìn sơ̆ng gơŭ lài yah aràng sơi angăn Yàng Jêsu la Pô Krist, nư̆n rơŭ păl kŏng prơh tơbiă klàh mư̆ng sàng pơtòm. ");
INSERT INTO cje_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Kơyoa nư̆n, ame ama mơnih bồm đờm lài: “Ñu hũ tơ̆l thŭn sơ̆ng prŏng bơjơ, yòng tơnia bĕ ñu.” ");
INSERT INTO cje_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Sa amăng tra wơ̆, du mơnih Pharisi iơu mơnih bồm pơrpa hũ pơsồ-pơsaih truh, sơ̆ng đờm: “Mơyòm-pơglòng bĕ Yàng Pô Lơngì. Buơl gudrơi thơu mơnih nư̆n la mơnih glài-sơnoh.” ");
INSERT INTO cje_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Bloh ñu đờm: “Dơlhă 'buh thơu mơnih nư̆n hũ iơŭ la mơnih hũ glài halài 'buh ơu. Bloh dơlhă mĭn thơu sa pơnuaĭ, nư̆n la dơlhơu dơlhă bồm, bloh tŭ ni dơlhă hũ c̆ơ 'buh jiơ̆ng.” ");
INSERT INTO cje_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Buơl guñu tơnia wơ̆: “Mơnih nư̆n hũ ngă hơgĕ tơ hã? Mơnih nư̆n hũ pơh mơta tơ hã hơyơu lơi?” ");
INSERT INTO cje_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ñu đờm sơđồ: “Dơlhă hũ đờm sơ̆ng buơl kơi bơjơ, bloh buơl kơi 'buh khiăng păng. Kơđa hơgĕ buơl kơi khiăng păng pơnuaĭ nư̆n wơ̆? Halài buơl kơi kŭng khiăng ngă mơnih tui-mơgru mơnih nư̆n rơi?” ");
INSERT INTO cje_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Buơl nư̆n puaĭ c̆ơ-ua ñu sơ̆ng đờm: “Rùp-phŭn hã nư̆n la mơnih tui-mơgru mơnih nư̆n; dò buơl gukơu, buơl gukơu la mơnih tui-mơgru Môise! ");
INSERT INTO cje_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Buơl gudrơi thơu Yàng Pô Lơngì hũ đờm sơ̆ng Môise, bloh mư̆ng mơnih ni, buơl gudrơi 'buh thơu mư̆ng lơi truh.” ");
INSERT INTO cje_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Mơnih bồm đờm sơđồ: “C̆rih-krơi biă! Mơnih hũ pơh mơta tơ dơlhă bloh buơl kơi 'buh thơu mơnih nư̆n mư̆ng lơi truh! ");
INSERT INTO cje_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Buơl gudrơi thơu lài Yàng Pô Lơngì 'buh păng pơnuaĭ du mơnih hũ glài, bloh yah aràng sơi duh-huơĭ Yàng Pô Lơngì sơ̆ng ngă tui hơtai-khiăng Pô, nư̆n Pô păng pơnuaĭ mơnih nư̆n. ");
INSERT INTO cje_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Mư̆ng yau truh ară ni, ka tŭ lơi mơhư̆ đờm hũ aràng sơi pơh mơta tơ mơnih bồm mư̆ng tŭ pơrpa đih apui. ");
INSERT INTO cje_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Yah mơnih ni 'buh iơŭ truh mư̆ng Yàng Pô Lơngì, nư̆n 'buh rơgơi ngă hơgĕ jiơ̆ng.” ");
INSERT INTO cje_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Buơl guñu đờm sơđồ: “Abih rùp-phàp hã đih apui tơbiă lăm glài-sơnoh, bloh tŭ ni hã dò khiăng pơto buơl gukơu wơ̆?” Bloh nư̆n buơl guñu prơh mơnih bồm pơrpa hũ pơsồ-pơsaih tơbiă tơ agàh. ");
INSERT INTO cje_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yàng Jêsu mơhư̆ đờm buơl mơnih nư̆n hũ prơh ñu tơbiă, nư̆n tŭ păp ñu, Pô tơnia: “Hã hũ păng-tui Anà Yàng Pô Lơngì ơu?” ");
INSERT INTO cje_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ñu đờm sơđồ: “Ơ Yàng, Pô nư̆n la aràng sơi tô dơlhă păng-tui?” ");
INSERT INTO cje_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yàng Jêsu đờm: “Hã hũ 'buh mơnih nư̆n bơjơ. La rùp-phŭn Mơnih dò đờm glai sơ̆ng hã ni.” ");
INSERT INTO cje_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ñu đờm: “Khoai Yàng, dơlhă păng-tui!” Bloh nư̆n ñu pơđih rùp c̆ĕ-dơlbăt Pô. ");
INSERT INTO cje_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yàng Jêsu đờm: “Kơu hũ truh lăm dun-ya tô ngă pơnuaĭ c̆ahrơña ni: dŏng mơnih bồm hũ 'buh, sơ̆ng brơi mơnih sơrdah thơu buơl guñu bồm.” ");
INSERT INTO cje_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Du mơnih Pharisi dò dơ̆ng jĕ tơ anih nư̆n, mơhư̆ yơu nư̆n, đờm sơ̆ng Pô: “Yơu nư̆n găm buơl dơlhă kŭng bồm abih rơi?” ");
INSERT INTO cje_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yàng Jêsu đờm: “Yah buơl guhã thơu drơi bồm nư̆n 'buh hũ glài-sơnoh hơgĕ, bloh kơyoa buơl guhã đờm lài: ‘Buơl dơlhă 'buh,’ nư̆n glài-sơnoh buơl guhã sơđaŭ dò!” ");
INSERT INTO cje_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Iơŭ biă, Kơu đờm sơ̆ng buơl guhã, mơnih lơi 'buh kơyoa bơh 'băng bloh tơma lăm wàr abo, bloh đì tơma sơ̆ng jơlàn pơkơ̆n, mơnih nư̆n la mơnih klĕ blơ̆. ");
INSERT INTO cje_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Bloh aràng sơi kơyoa bơh 'băng bloh tơma, la mơnih glăng abo. ");
INSERT INTO cje_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Mơnih kraŭ-khiă bơh 'băng pơh bơh 'băng tơ mơnih glăng tơma; abo mơhư̆ săp mơnih glăng; mơnih glăng iơu mơta abo drơi, sơ̆ng ba guñu tơbiă tơ agàh. ");
INSERT INTO cje_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Tŭ hũ brơi abo tơbiă abih bơjơ, mơnih glăng nau dơlhơu sơ̆ng abo nau tui hơdơi, kơyoa abo mừng-lơđăp săp mơnih glăng. ");
INSERT INTO cje_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Abo 'buh nau tui mơnih c̆rih; tơrblơ̆ wơ̆, rơŭ đuaĭ dơŭ, kơyoa guñu 'buh kràn-thơu săp mơnih c̆rih.” ");
INSERT INTO cje_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yàng Jêsu đờm pơnuaĭ pơgăp-pơmơyơu ni tơ buơl guñu, bloh buơl guñu 'buh wờng Pô khiăng đờm hơgĕ. ");
INSERT INTO cje_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Kơyoa nư̆n, Yàng Jêsu đờm wơ̆: “Iơŭ biă, Kơu đờm sơ̆ng buơl guhã, Kơu la bơh 'băng tô abo tơma tơbiă. ");
INSERT INTO cje_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Abih tơgrơ̆ mơnih truh dơlhơu Kơu la buơl klĕ blơ̆, sơ̆ng abo 'buh păng tui guñu. ");
INSERT INTO cje_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Kơu la bơh 'băng. Yah aràng sơi kơyoa Kơu bloh tơma, nư̆n rơŭ hũ dŏng-pơklàh. Buơl guñu rơŭ tơma tơbiă sơ̆ng păp 'blàng rơ̆. ");
INSERT INTO cje_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Mơnih klĕ mĭn truh tô tămblah-mă, pơmơtai, sơ̆ng pơluĭ-pơlơhiă. Pơ-ơnah Kơu, Kơu truh tô abo hũ pơnuaĭ hơdiŭ, sơ̆ng hũ pơnuaĭ hơdiŭ dơlah-dơlài. ");
INSERT INTO cje_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Kơu la mơnih glăng lơnguh-siàm, mơnih glăng lơnguh-siàm kơyoa tơrpuơl abo drơi prah luơi pơnuaĭ hơdiŭ drơi. ");
INSERT INTO cje_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Mơnih glăng tồ-apah 'buh iơŭ la mơnih glăng, kơyoa tơrpuơl abo 'buh găm sơ̆ng ñu, nư̆n tŭ 'buh du asơu sĭng truh, ñu luơi abo bloh đuaĭ dơŭ. Du asơu sĭng brồ mă abo sơ̆ng ngă tơ abo c̆ơrlah-c̆ơrlờp. ");
INSERT INTO cje_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Kơyoa la mơnih glăng tồ-apah, nư̆n ñu 'buh sơnư̆ng kơ-ù hơgĕ truh tơrpuơl abo. ");
INSERT INTO cje_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Kơu la mơnih glăng lơnguh-siàm. Kơu thơu abo Kơu, sơ̆ng abo Kơu thơu Kơu; ");
INSERT INTO cje_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","kŭng yơu Ama thơu Kơu, sơ̆ng Kơu thơu Ama rơi. Kơu kơyoa tơrpuơl abo prah-luơi pơnuaĭ hơdiŭ drơi. ");
INSERT INTO cje_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Kơu dò hũ du abo pơkơ̆n 'buh găm mư̆ng wàr ni. Kơu kŭng păl ba guñu mơrai wơ̆ rơi. Abo nư̆n rơŭ mơhư̆ săp Kơu, bloh nư̆n rơŭ mĭn hũ sa tơrpuơl abo sơ̆ng sa aràng mơnih glăng soh. ");
INSERT INTO cje_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ni, kơđa hơgĕ Ama rơnăm Kơu, nư̆n la kơyoa Kơu prah-luơi pơnuaĭ hơdiŭ drơi, tô hũ đồ-mă wơ̆. ");
INSERT INTO cje_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","'Buh aràng sơi suă-mă pơnuaĭ hơdiŭ Kơu jiơ̆ng, bloh rùp-phŭn Kơu sờh hơtai-hơtiàn prah-luơi pơnuaĭ hơdiŭ drơi. Kơu hũ gơnuăr prah-luơi pơnuaĭ hơdiŭ drơi, sơ̆ng Kơu hũ gơnuăr mă ñu wơ̆. Kơu hũ đồ-mă gơnuăr-pơđăr ni mư̆ng anih Ama Kơu.” ");
INSERT INTO cje_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Kơyoa mư̆ng tơgrơ̆ pơnuaĭ ni, du mơnih Juđa 'brŏ pơc̆ơrlah krơi gơŭ wơ̆. ");
INSERT INTO cje_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Lô mơnih lăm buơl guñu đờm: “Ñu kơđòng kơmlài ngă sơ̆ng mòih-hơnrui bơjơ! Kơđa hơgĕ buơl guhã dò păng ñu ngă hơgĕ?” ");
INSERT INTO cje_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Du mơnih pơkơ̆n nư̆n đờm: “Mơnih kơđòng kơmlài ngă hơyơu đờm jiơ̆ng yơu nư̆n! Kơmlài hũ rơgơi pơh mơta tơ mơnih bồm jiơ̆ng rơi?” ");
INSERT INTO cje_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Tơ plơi-prŏng Jerusalem hũ pơnuaĭ pơjŭm 'bơ̆ng sơdơ̆r wơ̆ bruă pơyă sàng duh-dơlbăt. Tŭ nư̆n la blàn mơrềt. ");
INSERT INTO cje_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yàng Jêsu nau tơkai lăm sàng duh-dơlbăt, tơ ala sơndờp bơh 'băng Salômôn. ");
INSERT INTO cje_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Mơnih Juđa pơgùm gơŭ tòmdăr Pô sơ̆ng đờm: “Pô-Pơto luơi buơl dơlhă sơnư̆ng wĭ-wơ̆ mĭt tơ̆l truh tơ tŭ lơi? Yah Pô-Pơto la Pô Krist, yòng đờm loh-làng bĕ tơ buơl dơlhă thơu!” ");
INSERT INTO cje_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yàng Jêsu đờm: “Kơu hũ đờm sơ̆ng buơl guhã bơjơ, bloh buơl guhã 'buh păng-tui. Tơgrơ̆ bruă Kơu mă angăn Ama Kơu bloh ngă hũ ngă grơh tơ Kơu. ");
INSERT INTO cje_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Bloh buơl guhã 'buh păng-tui, kơyoa buơl guhã 'buh iơŭ la tơrpuơl abo Kơu. ");
INSERT INTO cje_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Abo Kơu mơhư̆ săp Kơu, Kơu thơu guñu, sơ̆ng guñu tui Kơu. ");
INSERT INTO cje_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Kơu brơi tơ guñu pơnuaĭ hơdiŭ rài pơdò rài. Guñu rơŭ 'buh tŭ lơi mơtai lơhiă, sơ̆ng 'buh hũ aràng sơi tămblah-mă guñu jiơ̆ng mư̆ng tơngàn Kơu. ");
INSERT INTO cje_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ama Kơu, la Pô prŏng rơlau abih, hũ brơi tơ Kơu du abo nư̆n, sơ̆ng 'buh hũ aràng sơi tămblah-mă guñu jiơ̆ng mư̆ng tơngàn Ama. ");
INSERT INTO cje_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Kơu sơ̆ng Ama la sa.” ");
INSERT INTO cje_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Du mơnih Juđa duơ̆n pơtơu tô prah pơmơtai Pô. ");
INSERT INTO cje_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yàng Jêsu đờm sơ̆ng buơl guñu: “Kơu hũ ngă tơ anaŭ buơl guhã lô bruă siàm Ama hũ jào tơ Kơu ngă. Yơu nư̆n, kơyoa pơnuaĭ hơgĕ bloh buơl guhã khiăng prah pơtơu pơmơtai Kơu?” ");
INSERT INTO cje_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Du mơnih Juđa đờm: “'Buh iơŭ buơl dơlhă prah pơtơu pơmơtai Pô-Pơto kơyoa mư̆ng du bruă siàm Pô-Pơto hũ ngă, bloh kơyoa Pô-Pơto đờm sơk-sơrbĭl truh Yàng Pô Lơngì: Pô-Pơto mĭn la mơnih bơhiàn, bloh đờm angăn rùp-phŭn drơi la Yàng Pô Lơngì.” ");
INSERT INTO cje_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yàng Jêsu đờm lài: “Lăm pơnuaĭ adăt-adia buơl guhã 'buh hũ wă pơnuaĭ ni ơu: ‘Kơu hũ đờm: buơl guhã la du yàng,’? ");
INSERT INTO cje_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Yah pơnuaĭ adăt-adia angăn du mơnih đồ-mă pơnuaĭ Yàng Pô Lơngì la ‘yàng,’ sơ̆ng pơnuaĭ 'Bồn Bơ-àr Sơc̆ih-Sri 'buh rơgơi klà luơi jiơ̆ng, ");
INSERT INTO cje_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","nư̆n Kơu ni, la Pô hũ Ama pioh krơi sơc̆ih-sri, sơ̆ng pơđăr truh lăm dun-ya, đờm: ‘Kơu la Anà Yàng Pô Lơngì,’ nư̆n kơđa hơgĕ buơl guhã đờm yă Kơu la đờm khĭn-dơmĭn sơk-sơrbĭl? ");
INSERT INTO cje_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Yah Kơu 'buh ngă du bruă Ama Kơu, nư̆n buơl guhã juơi păng-tui Kơu. ");
INSERT INTO cje_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Bloh yah Kơu ngă, nư̆n yah buơl guhã 'buh păng-tui Kơu, păng-tui bĕ du bruă Kơu ngă, tô buơl guhã hũ rơgơi thơu sơ̆ng wờng lài Ama dò lăm Kơu sơ̆ng Kơu dò lăm Ama.” ");
INSERT INTO cje_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Buơl guñu duah pơnuaĭ tô mă Pô, bloh Pô pleh klàh tơngàn buơl guñu. ");
INSERT INTO cje_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Mư̆ng nư̆n, Yàng Jêsu gài nau tơ gah dih ia sơdờng Jôđăn, la anih dơlhơu thrơi Jăng hũ ngă 'baptem, sơ̆ng dò tơ anih nư̆n. ");
INSERT INTO cje_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Hũ lô mơnih truh sơ̆ng Pô. Buơl guñu đờm lài: “Jăng 'buh ngă sa nàl-c̆rih lơi, bloh abih tơgrơ̆ pơnuaĭ Jăng hũ đờm mư̆ng mơnih ni la iơŭ tơpă biă!” ");
INSERT INTO cje_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Tơ anih nư̆n hũ lô mơnih păng-tui Pô. ");
INSERT INTO cje_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Hũ sa aràng mơnih lơ-ơ̆n traŭ, angăn la Lasarơ, plơi tơ 'Bethani, la plơi dua aràng adơi-ai Mathe sơ̆ng Mari. ");
INSERT INTO cje_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mari la mơnih hũ lŭ mơñà 'bơu bơlhơu tơ Yàng, sơ̆ng mă 'bù drơi uă tơkai Pô. Rùp-phŭn Lasarơ, sơ-ai ñu, la mơnih lơ-ơ̆n traŭ. ");
INSERT INTO cje_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Dua aràng adơi-ai yòng mơnih truh đờm sơ̆ng Yàng Jêsu: “Khoai Yàng, mơnih Yàng rơnăm, dò kơđòng lơ-ơ̆n traŭ biă.” ");
INSERT INTO cje_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Mơhư̆ yơu nư̆n, Yàng Jêsu đờm: “Lơ-ơ̆n ni 'buh truh păl mơtai ơu, bloh la kơyoa pơnuaĭ màng-kơc̆rà Yàng Pô Lơngì, tô Anà Yàng Pô Lơngì kơyoa nư̆n hũ mơyòm-pơglòng.” ");
INSERT INTO cje_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yàng Jêsu rơnăm Mathe, adơi kơmơi ñu, sơ̆ng Lasarơ. ");
INSERT INTO cje_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Bloh tŭ mơhư̆ Lasarơ lơ-ơ̆n traŭ, Pô sơđaŭ kừ dò lăm anih Pô dò, dua hơrơi tra wơ̆. ");
INSERT INTO cje_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Hơdơi mư̆ng nư̆n, Pô đờm sơ̆ng du mơnih tui-mơgru: “Buơl gudrơi gài wơ̆ bĕ tơ Juđe.” ");
INSERT INTO cje_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Du mơnih tui-mơgru đờm lài: “Ơ Pô-Pơto, pơrpa ni mơnih Juđa duah prah pơtơu pơmơtai Pô-Pơto, bloh tŭ ni Pô-Pơto dò khiăng gài mơrai tơ anih nư̆n wơ̆?” ");
INSERT INTO cje_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yàng Jêsu đờm: “Glai hơrơi 'buh iơŭ hũ sa-pluh dua jơ ơu? Yah aràng sơi nau lăm glai hơrơi, nư̆n 'buh sơnĕ lơbuh, kơyoa 'buh pơnuaĭ sơrdah ia-hơrơi. ");
INSERT INTO cje_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Bloh yah aràng sơi nau lăm glai mơlăm, nư̆n sơnĕ lơbuh, kơyoa 'buh hũ pơnuaĭ sơrdah.” ");
INSERT INTO cje_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Hơdơi tŭ đờm yơu nư̆n, Pô đờm pơtui wơ̆: “Lasarơ, adơi-ai gơŭ buơl gudrơi, dò đih; bloh Kơu nau blơ̆ sơ-ai nư̆n.” ");
INSERT INTO cje_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Du mơnih tui-mơgru đờm: “Ơ Yàng, yah sơ-ai nư̆n đih, biă rơŭ hũ saih.” ");
INSERT INTO cje_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yàng Jêsu đờm mư̆ng pơnuaĭ Lasarơ mơtai, bloh du mơnih tui-mơgru sơnư̆ng Pô đờm mư̆ng bruă đih bơhiàn. ");
INSERT INTO cje_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Kơyoa nư̆n, Yàng Jêsu đờm loh-làng tơ buơl guñu thơu: “Lasarơ mơtai bơjơ. ");
INSERT INTO cje_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Bloh kơyoa buơl guhã, Kơu sờh kơyoa 'buh hũ Kơu tơ anih nư̆n, tô buơl guhã păng-tui. Tŭ ni buơl gudrơi truh bĕ sơ̆ng Lasarơ.” ");
INSERT INTO cje_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Kơyoa nư̆n, Thôma, kŭng angăn la Điđim, đờm sơ̆ng du mơnih tui-mơgru pơkơ̆n lài: “Buơl gudrơi kŭng nau bĕ truh tơ nư̆n tô mơtai sơ̆ng Pô.” ");
INSERT INTO cje_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Tŭ Yàng Jêsu truh anih, Pô thơu Lasarơ hũ dơ̆r lăm kŭt atơu pà hơrơi bơjơ. ");
INSERT INTO cje_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Plơi 'Bethani đoh tơ plơi-prŏng Jerusalem pơgăp klơu kơsồ, ");
INSERT INTO cje_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","nư̆n hũ lô mơnih Juđa truh c̆uă-rơwăng Mathe sơ̆ng Mari, tô pơluơ-pơrơngài buơl guñu mư̆ng bruă sơ-ai buơl guñu mơtai. ");
INSERT INTO cje_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Tŭ mơhư̆ Yàng Jêsu truh, Mathe tơbiă nau rò Pô, bloh Mari nư̆n sơđaŭ dò guh lăm sàng. ");
INSERT INTO cje_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mathe đờm sơ̆ng Yàng Jêsu: “Ơ Yàng, yah Yàng hũ tơ anih ni, nư̆n sơ-ai anà 'buh mơtai. ");
INSERT INTO cje_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Bloh anà thơu tŭ ni, abih tơgrơ̆ bruă hơgĕ Pô yòng sơ̆ng Yàng Pô Lơngì, Yàng Pô Lơngì kŭng rơŭ brơi tơ Pô rơi.” ");
INSERT INTO cje_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yàng Jêsu đờm: “Sơ-ai anà rơŭ hơdiŭ wơ̆.” ");
INSERT INTO cje_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Mathe đờm: “Anà thơu sơ-ai anà rơŭ hơdiŭ wơ̆, tŭ mơnih mơtai hơdiŭ wơ̆ lăm hơrơi luĭ-dŭt.” ");
INSERT INTO cje_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yàng Jêsu đờm sơ̆ng Mathe: “Kơu la pơnuaĭ hơdiŭ wơ̆ sơ̆ng pơnuaĭ hơdiŭ. Aràng sơi păng-tui Kơu, nư̆n yah mơtai bơjơ, kŭng rơŭ hũ hơdiŭ. ");
INSERT INTO cje_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Dò aràng sơi hơdiŭ bloh păng-tui Kơu, nư̆n rơŭ 'buh tŭ lơi mơtai. Anà păng-tui pơnuaĭ nư̆n ơu?” ");
INSERT INTO cje_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Mathe đờm: “Ơ Yàng, anà păng-tui! Anà păng-tui lài Yàng la Pô Krist, Anà Yàng Pô Lơngì, la Pô păl truh lăm dun-ya.” ");
INSERT INTO cje_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Hơdơi tŭ đờm yơu nư̆n, Mathe nau wơ̆ tơ sàng, iơu adơi drơi la Mari, sơ̆ng đờm iờp: “Pô-Pơto truh bơjơ, sơ̆ng pơđăr iơu adơi.” ");
INSERT INTO cje_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mơhư̆ yơu nư̆n, Mari tơmbah-tơmbàn tơgồ dơ̆ng, nau truh sơ̆ng Pô. ");
INSERT INTO cje_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Tŭ nư̆n, Yàng Jêsu ka tơma lăm plơi, bloh sơđaŭ dò dơ̆ng tơ anih Mathe hũ tơbiă rò Pô. ");
INSERT INTO cje_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Tŭ du mơnih Juđa dò lăm sàng sơ̆ng Mari, tô pơluơ-pơrơngài ñu, 'buh ñu tơmbah-tơmbàn tơgồ dơ̆ng sơ̆ng tơbiă nau, nư̆n nau tui hơdơi, kơyoa sơnư̆ng lài ñu truh tơ kŭt atơu tô hia. ");
INSERT INTO cje_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Tŭ truh anih Yàng Jêsu, sơ̆ng 'buh Pô, nư̆n Mari pơđih rùp tơ tơkai Pô, sơ̆ng đờm: “Ơ Yàng, yah hũ Yàng tơ anih ni, nư̆n sơ-ai anà 'buh mơtai.” ");
INSERT INTO cje_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yàng Jêsu 'buh Mari hia, sơ̆ng du mơnih Juđa nau găm sơ̆ng ñu kŭng hia, nư̆n lăm hơtai-hơtiàn Pô rơngoh-rơngĕt 'buh suk dò. ");
INSERT INTO cje_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Pô tơnia: “Buơl guhã dơ̆r sơ-ai nư̆n anih lơi?” Buơl guñu đờm: “Khoai Yàng, yòng truh c̆ơ bĕ.” ");
INSERT INTO cje_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yàng Jêsu hia. ");
INSERT INTO cje_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","'Buh yơu nư̆n, du mơnih Juđa đờm sơ̆ng gơŭ: “C̆ơ dih, ñu rơnăm Lasarơ thơu kàr lơi!” ");
INSERT INTO cje_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Hũ du mơnih lăm buơl guñu đờm: “Ñu hũ pơh mơta tơ mơnih bồm jiơ̆ng, 'buh iơŭ kŭng hũ rơgơi ngă tơ mơnih ni 'buh mơtai ơu?” ");
INSERT INTO cje_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Tŭ nư̆n, Yàng Jêsu dơnuh-dơnà biă lăm hơtai-hơtiàn, nư̆n nau truh tơ kŭt atơu. Kŭt atơu la sa boh lơbàng, tơ anaŭ hũ sa boh pơtơu kơdrơ̆ wơ̆. ");
INSERT INTO cje_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yàng Jêsu đờm: “Pơrlơ̆ bĕ boh pơtơu sơgah!” Mathe, la adơi mơnih mơtai, đờm lài: “Khoai Yàng, sơ-ai nư̆n 'bơu bơjơ, kơyoa sơ-ai nư̆n mơtai pà hơrơi bơjơ!” ");
INSERT INTO cje_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yàng Jêsu đờm: “Kơu 'buh iơŭ hũ đờm bơjơ sơ̆ng anà lài, yah anà păng-tui, nư̆n rơŭ 'buh pơnuaĭ màng-kơc̆rà Yàng Pô Lơngì ơu?” ");
INSERT INTO cje_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Yơu nư̆n, buơl guñu pơrlơ̆ boh pơtơu sơgah. Yàng Jêsu tơ̆ mơta tơ ngŏ sơ̆ng đờm: “Ơ Ama, dơlhă ưnjơmừn Ama, kơyoa Ama hũ păng đồ-mă pơnuaĭ dơlhă. ");
INSERT INTO cje_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Dơlhă thơu Ama mĭt-mĭt păng đồ-mă pơnuaĭ dơlhă, bloh dơlhă đờm yơu nư̆n la kơyoa buơl làng dò dơ̆ng tòmdăr anih ni, tô buơl guñu păng-tui lài rùp-phŭn Ama la Pô hũ pơđăr dơlhă truh!” ");
INSERT INTO cje_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Hơdơi tŭ đờm yơu nư̆n, Pô iơu prŏng săp: “Ơ Lasarơ, tơbiă bĕ!” ");
INSERT INTO cje_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Mơnih mơtai nau tơbiă, tơkai tơngàn dò wăr bơ-yài pơpò, sơ̆ng 'bò mơta sơđaŭ dò yùp c̆ơnră. Yàng Jêsu đờm sơ̆ng buơl guñu: “Yờh bĕ c̆ơnră sơ̆ng bơ-yài tơ ñu, sơ̆ng luơi ñu nau.” ");
INSERT INTO cje_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Lô mơnih Juđa hũ truh c̆uă-rơwăng sơ̆ng Mari, 'buh bruă Yàng Jêsu hũ ngă, nư̆n păng-tui Pô. ");
INSERT INTO cje_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Bloh hũ du mơnih lăm buơl guñu nau truh sơ̆ng mơnih Pharisi, sơ̆ng đờm akhàn wơ̆ tơ buơl guñu thơu mư̆ng tơgrơ̆ hơgĕ Yàng Jêsu hũ ngă. ");
INSERT INTO cje_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Kơyoa nư̆n, du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt sơ̆ng du mơnih Pharisi pơgùm-pơtòm Tơrpuơl Gơnuăr Apăn-Akŏ Buơl Làng, sơ̆ng đờm lài: “Buơl gudrơi păl ngă hơgĕ ni? Kơyoa mơnih ni hũ ngă lô pơnuaĭ-c̆rih biă. ");
INSERT INTO cje_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Yah buơl gudrơi kừ luơi kơđơ̆ng yơu nư̆n, abih tơgrơ̆ mơnih rơŭ păng-tui ñu, bloh nư̆n mơnih Rôma rơŭ truh, pơluĭ-pơlơhiă anih ni găm sơ̆ng abih lơgăr buơl gudrơi.” ");
INSERT INTO cje_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Bloh sa aràng lăm tơrpuơl buơl guñu, angăn la Kaiphe, ñu la mơnih gơnuăr prŏng apăn-akŏ pơyă phơ̆n duh-dơlbăt lăm thŭn nư̆n, đờm lài: “Buơl guhã 'buh thơu hơgĕ ơu! ");
INSERT INTO cje_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Buơl guhã 'buh wờng lài, yah luơi sa aràng mơnih mơtai ala tơ abih buơl làng, la siàm rơlau luơi abih lơgăr păl kŏng pơluĭ-pơlơhiă.” ");
INSERT INTO cje_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Pơnuaĭ ni ñu 'buh đờm tui hơtai rùp-phŭn drơi, bloh kơyoa la mơnih gơnuăr prŏng apăn-akŏ pơyă phơ̆n duh-dơlbăt lăm thŭn nư̆n, nư̆n ñu hũ đờm hwơ̆r mư̆ng bruă Yàng Jêsu rơŭ kơyoa buơl làng bloh kŏng mơtai, ");
INSERT INTO cje_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","sơ̆ng 'buh iơŭ mĭn kơyoa buơl làng Juđa soh, bloh kŭng tô pơgùm-pơtòm abih du anà Yàng Pô Lơngì dò c̆ơrlah-c̆ơrlờp lăm abih tơgrơ̆ anih mơrai sa tơrpuơl. ");
INSERT INTO cje_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Mư̆ng hơrơi nư̆n, buơl guñu ngă-nìn bơyai gơŭ tô pơmơtai Yàng Jêsu. ");
INSERT INTO cje_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Kơyoa nư̆n, Yàng Jêsu 'buh nau mơrai brơi 'buh mơta tơkrah buơl làng Juđa tra; bloh mư̆ng anih nư̆n, Pô truh tơ sa c̆àr jĕ 'blàng-jơhua, truh tơ sa plơi-prŏng angăn la Epraim. Pô dò wơ̆ tơ anih nư̆n sơ̆ng du mơnih tui-mơgru. ");
INSERT INTO cje_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Tŭ nư̆n, kơjĕ truh pơnuaĭ pơjŭm 'bơ̆ng prŏng lăm buơl làng Juđa, angăn la pơnuaĭ pơjŭm 'bơ̆ng Nau-Găn. Mư̆ng tơgrơ̆ plơi, lô mơnih đì nau tơ plơi-prŏng Jerusalem dơlhơu tơ pơnuaĭ pơjŭm 'bơ̆ng, tô ngă adăt pơsơc̆ih-goh. ");
INSERT INTO cje_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Buơl guñu duah Yàng Jêsu, sơ̆ng tŭ dò dơ̆ng lăm sàng duh-dơlbăt, buơl guñu đờm sơ̆ng gơŭ: “Buơl guhã sơnư̆ng hơyơu? Ñu khĭn truh lăm pơnuaĭ pơjŭm 'bơ̆ng ơu?” ");
INSERT INTO cje_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Dò du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt sơ̆ng du mơnih Pharisi nư̆n hũ brơi gơnuăr-pơđăr, yah aràng sơi thơu Yàng Jêsu dò anih lơi, nư̆n păl đờm akhàn tơ buơl guñu thơu mư, tô buơl guñu truh mă Pô. ");
INSERT INTO cje_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Năm hơrơi dơlhơu tơ pơnuaĭ pơjŭm 'bơ̆ng Nau-Găn, Yàng Jêsu truh tơ 'Bethani, plơi Lasarơ dò, la mơnih Pô hũ ngă hơdiŭ wơ̆ mư̆ng pơnuaĭ mơtai. ");
INSERT INTO cje_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Buơl guñu pồ pơnuaĭ huă 'bơ̆ng tơ Yàng Jêsu tơ anih nư̆n. Mathe duh bruă, dò Lasarơ la sa aràng lăm du mơnih dò guh huă 'bơ̆ng găm sơ̆ng Pô. ");
INSERT INTO cje_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mari mă sa khàr mơñà 'bơu bơlhơu sơ̆ng c̆ơk-màng biă, lŭ tơkai Yàng Jêsu, sơ̆ng mă 'bù drơi bloh uă. Abih sa boh sàng 'bơu bơlhơu mơñà nư̆n. ");
INSERT INTO cje_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Bloh Juđa Iskariôt, la sa aràng lăm du mơnih tui-mơgru Yàng Jêsu, mơnih hơdơi ni pơblơ̆-dră Pô, đờm lài: ");
INSERT INTO cje_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Kơđa hơgĕ 'buh pơblơi mơñà 'bơu bơlhơu nư̆n mă klơu rơtùh đơnie tô dŏng brơi-soh tơ mơnih rơ'bah?” ");
INSERT INTO cje_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ñu đờm yơu nư̆n, 'buh iơŭ kơyoa ñu sơnư̆ng-anĭt hơgĕ truh tơ mơnih rơ'bah, bloh kơyoa ñu la sa aràng mơnih klĕ blơ̆, sơ̆ng kŭng la mơnih pioh kơdŭng priă, nư̆n ñu jiăng klĕ mă priă aràng daŭ lăm nư̆n tô angui krơi tơ rùp-phŭn drơi. ");
INSERT INTO cje_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yàng Jêsu đờm: “Luơi bĕ ñu kơđơ̆ng, kơyoa ñu hũ pioh mơñà 'bơu bơlhơu ni tơ hơrơi dơ̆r rùp Kơu! ");
INSERT INTO cje_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Kơyoa buơl guhã jiăng hũ mơnih rơ'bah dò sơ̆ng drơi mĭt, bloh buơl guhã 'buh hũ Kơu mĭt ơu!” ");
INSERT INTO cje_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Sa tơrpuơl lô mơnih Juđa thơu Yàng Jêsu dò tơ anih nư̆n, buơl guñu ba gơŭ truh, 'buh iơŭ mĭn kơyoa buơl guñu khiăng 'buh Yàng Jêsu soh, bloh kŭng tô c̆ơ Lasarơ, la mơnih bloh Pô hũ ngă hơdiŭ wơ̆ mư̆ng pơnuaĭ mơtai. ");
INSERT INTO cje_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt 'buh yơu nư̆n, buơl guñu ngă-nìn rơŭ pơmơtai găm Lasarơ rơi. ");
INSERT INTO cje_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Kơyoa mư̆ng bruă Lasarơ hơdiŭ wơ̆ bloh lô mơnih Juđa luơi buơl guñu sơ̆ng păng-tui Yàng Jêsu. ");
INSERT INTO cje_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Hơrơi hơdơi, hũ sa tơrpuơl lô buơl làng truh tô pơjŭm 'bơ̆ng. Tŭ mơhư̆ thơu Yàng Jêsu truh tơ plơi-prŏng Jerusalem, ");
INSERT INTO cje_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","nư̆n buơl guñu mă sơla guăl, tơbiă nau rò Pô, sơ̆ng driau prŏng lài: “Hôsana! Lơngai-pơtuah tơ Pô mă angăn Yàng bloh truh, la Pơtau buơl làng Israel.” ");
INSERT INTO cje_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yàng Jêsu duah hũ sa drơi alàng anà, Pô đì tơ ngŏ, iơŭ yơu pơnuaĭ hũ wă: ");
INSERT INTO cje_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Ơ anà kơmơi Siôn, juơi huơĭ! Dih, pơtau hã truh, đì tơ ngŏ alàng anà!” ");
INSERT INTO cje_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Tŭ c̆ơmrừp, du mơnih tui-mơgru Pô 'buh wờng tơgrơ̆ pơnuaĭ nư̆n, bloh hơdơi tŭ Yàng Jêsu hũ màng-kơc̆rà bơjơ, buơl guñu sơdơ̆r wơ̆ du pơnuaĭ nư̆n hũ wă mư̆ng Pô, sơ̆ng buơl làng hũ ngă tơ Pô iơŭ yơu nư̆n. ");
INSERT INTO cje_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Tơrpuơl mơnih hũ dò sơ̆ng Yàng Jêsu tŭ Pô iơu Lasarơ tơbiă mư̆ng kŭt atơu, sơ̆ng ngă tơ ñu mư̆ng pơnuaĭ mơtai hơdiŭ wơ̆, nau ngă grơh lăm abih tơgrơ̆ anih. ");
INSERT INTO cje_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Kơyoa hơgĕ buơl làng ba gơŭ tơbiă nau rò Pô, la kơyoa buơl guñu mơhư̆ thơu Pô hũ ngă nàl-c̆rih nư̆n. ");
INSERT INTO cje_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Kơyoa nư̆n, du mơnih Pharisi đờm sơ̆ng gơŭ: “Buơl guhã 'buh jơ, buơl gudrơi 'buh ngă hơgĕ jiơ̆ng ơu! C̆ơ dih, abih buơl làng plơi-lơgăr đuaĭ tui ñu!” ");
INSERT INTO cje_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Tŭ nư̆n, lăm du mơnih đì tơ Jerusalem duh-dơlbăt Yàng lăm pơnuaĭ pơjŭm 'bơ̆ng Nau Găn, hũ du mơnih Grek. ");
INSERT INTO cje_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Du mơnih ni truh tòm Philip, la mơnih plơi-prŏng 'Betsaiđa, c̆àr Galile, sơ̆ng đờm lài: “Ơ kơi, buơl dơlhă khiăng tòm Yàng Jêsu.” ");
INSERT INTO cje_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Philip nau đờm sơ̆ng Andre; bloh nư̆n Andre sơ̆ng Philip truh đờm sơ̆ng Yàng Jêsu. ");
INSERT INTO cje_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yàng Jêsu đờm: “Jơ Anà Mơnih hũ màng-kơc̆rà hũ truh bơjơ! ");
INSERT INTO cje_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Iơŭ biă, iơŭ biă, Kơu đờm sơ̆ng buơl guhã: Yah găr bơdai dih, 'buh mơtai hơdơi tŭ drà trŭn lăm lơ̆n, nư̆n ñu sơđaŭ mĭn la sa găr soh; bloh yah ñu mơtai, nư̆n tơbiă phŭn-hơjŭng hũ lô. ");
INSERT INTO cje_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Aràng sơi rơnăm pơnuaĭ hơdiŭ drơi nư̆n rơŭ lơhiă, aràng sơi mơbai pơnuaĭ hơdiŭ drơi lăm rài ni, nư̆n rơŭ păng-rơmiă wơ̆ tơ pơnuaĭ hơdiŭ rài pơdò rài. ");
INSERT INTO cje_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Yah aràng sơi duh-bruă Kơu, nư̆n păl tui Kơu; sơ̆ng Kơu dò anih lơi, mơnih duh-bruă Kơu kŭng rơŭ dò anih nư̆n. Yah aràng sơi duh-bruă Kơu, nư̆n rơŭ hũ Ama Kơu c̆ơ prŏng-màng.” ");
INSERT INTO cje_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Tŭ ni bơngă-joa Kơu dơnuh-dơnà biă. Kơu rơŭ đờm hơgĕ ni? ‘Ơ Ama, yòng dŏng anà klàh mư̆ng jơ ni! Bloh kŭng kơyoa mư̆ng jơ ni bloh Anà hũ truh. ");
INSERT INTO cje_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ơ Ama, yòng ngă màng-kơc̆rà angăn Ama!’ ” Tŭ nư̆n hũ săp mư̆ng ngŏ lơngì đờm lài: “Kơu hũ ngă màng-kơc̆rà bơjơ, sơ̆ng Kơu rơŭ ngă màng-kơc̆rà wơ̆!” ");
INSERT INTO cje_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Mơhư̆ săp nư̆n, buơl làng dò dơ̆ng tơ anih nư̆n đờm lài: “Nư̆n la săp grơ̆m.” Du mơnih pơkơ̆n wơ̆ đờm: “Nư̆n la sa aràng mơnih gơdrưh đờm glai sơ̆ng Pô.” ");
INSERT INTO cje_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yàng Jêsu đờm: “'Buh iơŭ kơyoa Kơu bloh săp nư̆n hũ dơlờng trŭn ơu, bloh la kơyoa buơl guhã. ");
INSERT INTO cje_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Tŭ ni la tŭ dun-ya kơđòng c̆ahrơña, sơ̆ng Satăn, la mơnih apăn-akŏ dun-ya ni rơŭ kŏng prơh tơbiă tơ agàh. ");
INSERT INTO cje_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Pơ-ơnah Kơu, tŭ Kơu hũ yuăl tơ ngŏ kơyơu pơkăl, Kơu rơŭ kơtŭng tơgrơ̆ mơnih truh sơ̆ng Kơu.” ");
INSERT INTO cje_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Pô đờm yơu nư̆n tô pơto brơi thơu Pô rơŭ păl mơtai hơyơu lơi. ");
INSERT INTO cje_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Tơrpuơl buơl làng đờm lài: “Buơl dơlhă hũ mơhư̆ pơnuaĭ adăt-adia đờm Pô Krist rơŭ dò rài pơdò rài. Nư̆n kơđa hơgĕ Pô-Pơto đờm Anà Mơnih păl kơđòng yuăl tơ ngŏ? Anà Mơnih nư̆n la aràng sơi?” ");
INSERT INTO cje_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yàng Jêsu đờm: “Pơnuaĭ sơrdah mĭn dò sơ̆ng buơl guhã sa-sĭt suơi tra soh. Nau bĕ lăm tŭ buơl guhã dò hũ pơnuaĭ sơrdah, huơĭ lài pơnuaĭ kơnăm-mơsrư̆ mơre-mơro gơrwàng-jơ̆m buơl guhã. Mơnih lơi nau lăm pơnuaĭ kơnăm-mơsrư̆, nư̆n 'buh thơu drơi nau anih lơi. ");
INSERT INTO cje_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Lăm tŭ buơl guhã dò hũ pơnuaĭ sơrdah, păng-tui bĕ lăm pơnuaĭ sơrdah, tô buơl guhã tơbiă jiơ̆ng du anà pơnuaĭ sơrdah.” Hơdơi tŭ đờm yơu nư̆n, Yàng Jêsu nau, sơ̆ng pleh mơta 'buh brơi buơl guñu 'buh. ");
INSERT INTO cje_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yah lài Yàng Jêsu hũ ngă lô nàl-c̆rih tơ anaŭ buơl guñu, bloh buơl guñu sơđaŭ 'buh păng-tui Pô. ");
INSERT INTO cje_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Yơu nư̆n la tơbiă iơŭ yơu pơnuaĭ mơnih gơnuăr-hwơ̆r Êsai hũ đờm dơlhơu lài: “Khoai Yàng, aràng sơi hũ păng-tui pơnuaĭ buơl dơlhă pơto-akhàn, Sơ̆ng tơngàn Yàng hũ ràng-tơbiă tơ aràng sơi?” ");
INSERT INTO cje_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Kơyoa nư̆n buơl guñu 'buh rơgơi păng-tui, kơyoa Êsai kŭng hũ đờm: ");
INSERT INTO cje_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Yàng hũ ngă tơ mơta buơl guñu bồm, Hơtai-hơtiàn buơl guñu kră-khăng, Huơĭ mơta buơl guñu 'buh, Hơtai-hơtiàn buơl guñu wờng jiơ̆ng, bloh gài pơsơlih wơ̆, Sơ̆ng Kơu rơŭ pơsồ-pơsaih tơ buơl guñu.” ");
INSERT INTO cje_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Êsai đờm pơnuaĭ ni, kơyoa hũ 'buh pơnuaĭ màng-kơc̆rà Pô sơ̆ng đờm mư̆ng Pô. ");
INSERT INTO cje_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Yah lài yơu nư̆n, sơđaŭ hũ lô mơnih lăm tơrpuơl gơnuăr apăn-akŏ buơl làng Juđa păng-tui Pô, bloh buơl guñu 'buh khĭn akhàn tơbiă angăn Pô, kơyoa buơl guñu huơĭ du mơnih Pharisi rơŭ prơh buơl guñu tơbiă mư̆ng sàng pơtòm. ");
INSERT INTO cje_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Kơyoa buơl guñu ư̆ng-tơkrư pơnuaĭ màng-kơc̆rà truh mư̆ng jơi anà mơnih rơlau la pơnuaĭ màng-kơc̆rà truh mư̆ng Yàng Pô Lơngì. ");
INSERT INTO cje_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yàng Jêsu prŏng săp đờm lài: “Aràng sơi păng-tui Kơu, 'buh iơŭ mĭn păng-tui Kơu, bloh păng-tui Pô hũ pơđăr Kơu. ");
INSERT INTO cje_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Aràng sơi 'buh Kơu nư̆n la 'buh Pô hũ pơđăr Kơu. ");
INSERT INTO cje_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Kơu la pơnuaĭ sơrdah hũ truh lăm dun-ya, tô aràng sơi păng-tui Kơu rơŭ 'buh dò lăm pơnuaĭ kơnăm-mơsrư̆. ");
INSERT INTO cje_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Yah aràng sơi păng pơnuaĭ Kơu, bloh 'buh păng-rơmiă ngă tui, nư̆n 'buh iơŭ Kơu c̆ahrơña mơnih nư̆n. Kơyoa Kơu truh 'buh iơŭ tô c̆ahrơña dun-ya, bloh tô dŏng-pơklàh dun-ya. ");
INSERT INTO cje_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Mơnih lơi kơmlah-luơi Kơu, 'buh đồ-mă pơnuaĭ Kơu, nư̆n hũ mơnih gơnuăr c̆ahrơña bơjơ; rùp-phŭn tơgrơ̆ pơnuaĭ Kơu đờm rơŭ c̆ahrơña mơnih nư̆n lăm hơrơi luĭ-dŭt. ");
INSERT INTO cje_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Kơyoa Kơu 'buh iơŭ mư̆ng rùp-phŭn drơi đờm tơbiă, bloh la rùp-phŭn Ama, Pô hũ pơđăr Kơu truh, hũ brơi pơnuaĭ gơnuăr-pơđăr tơ Kơu păl đờm pơnuaĭ hơgĕ sơ̆ng pơto-akhàn pơnuaĭ hơgĕ. ");
INSERT INTO cje_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Sơ̆ng Kơu thơu: pơnuaĭ gơnuăr-pơđăr Pô la pơnuaĭ hơdiŭ rài pơdò rài. Kơyoa nư̆n, tơgrơ̆ pơnuaĭ Kơu đờm, la đờm iơŭ yơu pơnuaĭ Ama hũ kơkơi pơđăr.” ");
INSERT INTO cje_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Dơlhơu pơnuaĭ pơjŭm 'bơ̆ng Nau-Găn, Yàng Jêsu thơu tŭ jơ Pô păl luơi dun-ya ni tô gài wơ̆ sơ̆ng Pô Yàng Ama hũ truh. Pô hũ rơnăm du mơnih găm sơ̆ng Pô lăm dun-ya, nư̆n Pô kừ rơnăm buơl guñu tơ̆l truh luĭ-dŭt. ");
INSERT INTO cje_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Lăm tŭ 'bơ̆ng diơŭ, kơmlài-jĭnràk hũ daŭ pơnuaĭ pơblơ̆-dră Pô lăm hơtai-hơtiàn Juđa Iskariôt, anà Simôn. ");
INSERT INTO cje_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yàng Jêsu thơu lài Ama hũ jào abih tơgrơ̆ mơta lăm tơngàn Pô, sơ̆ng Pô mư̆ng Yàng Pô Lơngì truh, kŭng rơŭ mơrai wơ̆ sơ̆ng Yàng Pô Lơngì, ");
INSERT INTO cje_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","nư̆n Pô tơgồ dơ̆ng mư̆ng anih c̆ơnừng 'bơ̆ng, wà ào agàh, mă c̆ơnră wăr găn kơ-iăng drơi, ");
INSERT INTO cje_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","bloh nư̆n Pô tuh ia lăm thồng 'bàt, sơ̆ng rào tơkai tơ du mơnih tui-mơgru. Pô kŭng mă c̆ơnră hũ wăr tơ kơ-iăng drơi bloh uă tơkai tơ buơl guñu. ");
INSERT INTO cje_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Tŭ Pô truh sơ̆ng Simôn Pier, nư̆n Pier đờm: “Ơ Yàng, rùp-phŭn Yàng bloh rào tơkai tơ dơlhă?” ");
INSERT INTO cje_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yàng Jêsu đờm: “Tŭ ni, hã ka wờng bruă Kơu ngă, bloh hơdơi ni hã rơŭ wờng.” ");
INSERT INTO cje_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pier đờm: “Dơlhă rơŭ 'buh tŭ lơi luơi Yàng rào tơkai dơlhă ơu.” Yàng Jêsu đờm: “Yah Kơu 'buh rào tơ hã, nư̆n hã 'buh hũ pơ-ơnah hơgĕ sơ̆ng Kơu tra.” ");
INSERT INTO cje_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simôn Pier đờm: “Ơ Yàng, yah yơu nư̆n 'buh iơŭ mĭn rào tơkai soh, bloh yòng rào abih găm tơngàn sơ̆ng akŏ dơlhă rơi.” ");
INSERT INTO cje_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yàng Jêsu đờm: “Aràng sơi hũ mơnưi bơjơ, mĭn păl rào tơkai soh, nư̆n hũ goh abih. Buơl guhã hũ goh-sơc̆ih bơjơ, bloh 'buh iơŭ la abih tơgrơ̆ aràng buơl guhã hũ goh-sơc̆ih ơu.” ");
INSERT INTO cje_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Kơyoa Pô thơu aràng sơi rơŭ pơblơ̆-dră Pô, nư̆n jiơ̆ng Pô đờm: “'Buh iơŭ la abih tơgrơ̆ aràng buơl guhã hũ goh-sơc̆ih ơu.” ");
INSERT INTO cje_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Hơdơi tŭ rào tơkai tơ du mơnih tui-mơgru, Pô c̆ù ào wơ̆, bloh nư̆n dò guh tơ anih c̆ơnừng 'bơ̆ng sơ̆ng đờm: “Buơl guhã hũ wờng bruă Kơu pơrpa ngă tơ buơl guhã ơu? ");
INSERT INTO cje_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Buơl guhã iơu Kơu la Pô-Pơto, la Yàng. Buơl guhã đờm iơŭ, kơyoa Kơu biă yơu nư̆n. ");
INSERT INTO cje_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Bloh yah Kơu la Pô-Pơto, la Yàng, bloh dò rào tơkai tơ buơl guhã, nư̆n buơl guhã kŭng păl rào tơkai tơ gơŭ yơu nư̆n rơi. ");
INSERT INTO cje_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Kơyoa Kơu hũ ngă krơh tơ buơl guhã, tô buơl guhã kŭng ngă yơu Kơu hũ ngă tơ buơl guhã. ");
INSERT INTO cje_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Iơŭ biă, Kơu đờm sơ̆ng buơl guhã: Hơlŭn-hơlă 'buh prŏng rơlau mơnih pô, mơnih kŏng pơđăr 'buh prŏng rơlau mơnih pơđăr drơi. ");
INSERT INTO cje_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Yah buơl guhã thơu du pơnuaĭ ni sơ̆ng ngă tui, nư̆n buơl guhã hũ lơngai-pơtuah. ");
INSERT INTO cje_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Kơu 'buh đờm mư̆ng abih tơgrơ̆ aràng buơl guhã ơu. Kơu thơu du mơnih Kơu hũ rơwah. Bloh pơnuaĭ ni lăm 'Bồn Bơ-àr Sơc̆ih-Sri păl hũ iơŭ tơpă: ‘Mơnih 'bơ̆ng pah Kơu, gài kơđuơ̆l tơkai tămdră wơ̆ sơ̆ng Kơu.’ ");
INSERT INTO cje_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Tŭ ni, Kơu đờm pơnuaĭ ni sơ̆ng buơl guhã dơlhơu tŭ bruă tơbiă truh, tô tŭ bruă tơbiă truh, buơl guhã rơŭ păng-tui Kơu la Pô nư̆n. ");
INSERT INTO cje_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Iơŭ biă, Kơu đờm sơ̆ng buơl guhã, aràng sơi wă-rò mơnih Kơu pơđăr truh, nư̆n la wă-rò Kơu, sơ̆ng aràng sơi wă-rò Kơu, nư̆n la wă-rò Pô hũ pơđăr Kơu.” ");
INSERT INTO cje_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Hơdơi tŭ đờm du pơnuaĭ nư̆n bơjơ, lăm hơtai-bơngă Pô 'buh suk dò. Yàng Jêsu đờm loh-làng: “Iơŭ biă, Kơu đờm sơ̆ng buơl guhã, sa aràng lăm buơl guhã rơŭ pơblơ̆-dră Kơu.” ");
INSERT INTO cje_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Du mơnih tui-mơgru c̆ơ mơta gơŭ, 'buh thơu Pô đờm mư̆ng aràng sơi. ");
INSERT INTO cje_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Sa aràng lăm du mơnih tui-mơgru, la mơnih hũ Yàng Jêsu rơnăm, mơnih nư̆n dò guh jĕ Pô. ");
INSERT INTO cje_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simôn Pier ngă nàl tơ mơnih nư̆n, pơđăr tơnia Pô c̆ơ: aràng sơi la mơnih bloh Pô đờm nư̆n. ");
INSERT INTO cje_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Mơnih tui mơgru ni pơkiăng rùp drơi jĕ tơ hărda Yàng Jêsu, sơ̆ng tơnia: “Ơ Yàng, mơnih nư̆n la aràng sơi?” ");
INSERT INTO cje_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yàng Jêsu đờm: “Nư̆n la mơnih bloh Kơu rơŭ brơi pĕt pah Kơu kơjĕ ơñrŭ ni.” Bloh nư̆n Pô ơñrŭ sa pĕt pah sơ̆ng brơi tơ Juđa Iskariôt, anà Simôn. ");
INSERT INTO cje_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Hơdơi tŭ Juđa đồ-mă pĕt pah, nư̆n Satăn tơma lăm hơtai-hơtiàn ñu. Yàng Jêsu đờm sơ̆ng Juđa: “Bruă hã ngă, nư̆n ngă sơmăr bĕ.” ");
INSERT INTO cje_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Bloh 'buh sa aràng mơnih lơi dò guh lăm anih c̆ơnừng 'bơ̆ng thơu kơđa hơgĕ Pô đờm sơ̆ng ñu yơu nư̆n. ");
INSERT INTO cje_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Hũ du mơnih sơnư̆ng lài, kơyoa Juđa la mơnih pioh kơdŭng priă, nư̆n Yàng Jêsu pơđăr ñu nau blơi du phơ̆n păl hũ tô angui lăm pơnuaĭ pơjŭm 'bơ̆ng, halài nau dŏng-kờl mơnih rơ'bah. ");
INSERT INTO cje_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Hơdơi tŭ đồ-mă pĕt pah bơjơ, Juđa tơbiă nau mư. Tŭ nư̆n, lơngì kơnăm bơjơ. ");
INSERT INTO cje_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Tŭ Juđa tơbiă nau bơjơ, Yàng Jêsu đờm: “Tŭ ni Anà Mơnih hũ màng-kơc̆rà, sơ̆ng Yàng Pô Lơngì hũ màng-kơc̆rà anih Anà Mơnih. ");
INSERT INTO cje_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Yah Yàng Pô Lơngì hũ màng-kơc̆rà anih Anà Mơnih, nư̆n Yàng Pô Lơngì kŭng rơŭ ngă màng-kơc̆rà Anà Mơnih lăm rùp-phŭn Pô, sơ̆ng Pô rơŭ ngă màng-kơc̆rà mư. ");
INSERT INTO cje_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ơ du anà tìt Kơu, Kơu mĭn dò sơ̆ng buơl guhã sa-sĭt suơi tra soh. Buơl guhã rơŭ duah Kơu, sơ̆ng yơu Kơu hũ đờm sơ̆ng mơnih Juđa lài: ‘Anih Kơu nau buơl guhã 'buh rơgơi truh jiơ̆ng,’ nư̆n tŭ ni Kơu kŭng đờm sơ̆ng buơl guhã yơu nư̆n rơi. ");
INSERT INTO cje_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Kơu brơi tơ buơl guhã sa pơnuaĭ adăt-pơđăr bơrhơu, nư̆n la buơl guhã păl rơnăm gơŭ. Yơu Kơu hũ rơnăm buơl guhã hơyơu hơi, nư̆n buơl guhã kŭng păl rơnăm gơŭ bĕ yơu nư̆n rơi. ");
INSERT INTO cje_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Yah buơl guhã rơnăm gơŭ, nư̆n kơyoa pơnuaĭ nư̆n, tơgrơ̆ mơnih rơŭ kràn-thơu buơl guhã la mơnih tui-mơgru Kơu.” ");
INSERT INTO cje_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simôn Pier đờm sơ̆ng Yàng Jêsu: “Ơ Yàng, Yàng nau anih lơi?” Yàng Jêsu đờm: “Anih Kơu nau, tŭ ni hã 'buh rơgơi tui jiơ̆ng, bloh hơdơi ni hã rơŭ tui.” ");
INSERT INTO cje_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pier tơnia Pô: “Khoai Yàng, kơđa hơgĕ tŭ ni dơlhă 'buh rơgơi tui Yàng jiơ̆ng? Dơlhă rơŭ prah-luơi pơnuaĭ hơdiŭ dơlhă kơyoa Yàng!” ");
INSERT INTO cje_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yàng Jêsu đờm: “Hã rơŭ prah-luơi pơnuaĭ hơdiŭ hã kơyoa Kơu? Iơŭ biă, Kơu đờm sơ̆ng hã: Dơlhơu tŭ mơnŭ kơ-iòk, hã rơŭ klơu amăng kơmlah la hã 'buh thơu Kơu.” ");
INSERT INTO cje_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Hơtai-hơtiàn buơl guhã juơi sơnư̆ng kơ-ù. Păng-tui bĕ Yàng Pô Lơngì, sơ̆ng kŭng păng-tui Kơu rơi. ");
INSERT INTO cje_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Lăm sàng Ama Kơu hũ lô anih dò; yah 'buh iơŭ yơu nư̆n, kơđa hơgĕ Kơu đờm sơ̆ng buơl guhã, Kơu nau tô rơc̆ăng tơ buơl guhã sa anih? ");
INSERT INTO cje_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Tŭ Kơu nau sơ̆ng hũ rơc̆ăng anih tơ buơl guhã, nư̆n Kơu rơŭ gài wơ̆ ba buơl guhã nau sơ̆ng Kơu, tô Kơu dò anih lơi, buơl guhã kŭng dò anih nư̆n. ");
INSERT INTO cje_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Buơl guhã thơu Kơu nau anih lơi, sơ̆ng thơu jơlàn nau rơi.” ");
INSERT INTO cje_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Thôma đờm sơ̆ng Yàng Jêsu: “Ơ Yàng, buơl dơlhă 'buh thơu Yàng nau anih lơi, ngă hơyơu thơu jơlàn jiơ̆ng?” ");
INSERT INTO cje_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yàng Jêsu đờm: “Kơu la jơlàn nau, pơnuaĭ-tơpă sơ̆ng pơnuaĭ hơdiŭ. 'Buh kơyoa Kơu nư̆n 'buh aràng sơi hũ truh sơ̆ng Ama. ");
INSERT INTO cje_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Yah buơl guhã thơu Kơu, nư̆n kŭng thơu Ama Kơu, sơ̆ng mư̆ng tŭ ni buơl guhã thơu sơ̆ng hũ 'buh Pô.” ");
INSERT INTO cje_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Philip đờm: “Ơ Yàng, yòng pơto Ama tơ buơl dơlhă nư̆n tơ̆l bơjơ.” ");
INSERT INTO cje_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yàng Jêsu đờm: “Ơ Philip, Kơu dò sơ̆ng buơl guhã suơi ni bơjơ, bloh buơl guhã sơđaŭ ka thơu Kơu ơu? Aràng sơi hũ 'buh Kơu, nư̆n la hũ 'buh Ama. Kơđa hơgĕ hã đờm lài: ‘Yòng pơto Ama tơ buơl dơlhă’? ");
INSERT INTO cje_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Hã 'buh păng-tui lài Kơu dò lăm Ama sơ̆ng Ama dò lăm Kơu ơu? Tơgrơ̆ pơnuaĭ Kơu đờm sơ̆ng buơl guhã, 'buh iơŭ mư̆ng rùp-phŭn Kơu đờm, bloh la Ama, Pô dò lăm Kơu, rùp-phŭn Pô ngă du bruă drơi. ");
INSERT INTO cje_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Tŭ Kơu đờm, Kơu dò lăm Ama sơ̆ng Ama dò lăm Kơu, nư̆n păng-tui bĕ Kơu. Yah 'buh ơu nư̆n, păng-tui bĕ kơyoa mư̆ng tơgrơ̆ bruă Kơu ngă. ");
INSERT INTO cje_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Iơŭ biă, Kơu đờm sơ̆ng buơl guhã, aràng sơi păng-tui Kơu kŭng rơŭ ngă du bruă Kơu ngă, sơ̆ng rơŭ ngă du bruă prŏng rơlau wơ̆, kơyoa Kơu nau wơ̆ sơ̆ng Ama. ");
INSERT INTO cje_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Abih tơgrơ̆ pơnuaĭ hơgĕ buơl guhã mă angăn Kơu bloh yòng, nư̆n Kơu rơŭ ngă, tô Ama hũ mơyòm-pơglòng anih Anà. ");
INSERT INTO cje_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Yah buơl guhã mă angăn Kơu bloh lơkơu-yòng pơnuaĭ hơgĕ, nư̆n Kơu rơŭ ngă.” ");
INSERT INTO cje_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Yah buơl guhã uơ̆n-rơnăm Kơu, nư̆n rơŭ păng-rơmiă du pơnuaĭ adăt-pơđăr Kơu. ");
INSERT INTO cje_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Kơu rơŭ yòng-lơkơu Ama, Pô rơŭ brơi tơ buơl guhã sa Pô Pơluơ-Pơrơngài pơkơ̆n, tô dò sơ̆ng buơl guhã rài pơdò rài, ");
INSERT INTO cje_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","nư̆n la Bơngă Sơc̆ih-Sri, Pô ràng-tơbiă pơnuaĭ-tơpă mư̆ng Yàng Pô Lơngì, bloh dun-ya 'buh rơgơi đồ-mă jiơ̆ng, kơyoa dun-ya 'bu 'buh sơ̆ng 'buh thơu Pô. Bloh buơl guhã thơu Pô, kơyoa Pô sơđaŭ dò sơ̆ng buơl guhã, sơ̆ng rơŭ dò lăm buơl guhã. ");
INSERT INTO cje_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Kơu 'buh luơi buơl guhã lơ-ời ơu. Kơu rơŭ truh sơ̆ng buơl guhã. ");
INSERT INTO cje_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","'Buh hơdùm suơi tra, dun-ya rơŭ 'bu 'buh Kơu tra, bloh buơl guhã rơŭ 'buh Kơu. Kơyoa Kơu hơdiŭ nư̆n buơl guhã kŭng rơŭ hơdiŭ. ");
INSERT INTO cje_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Lăm hơrơi nư̆n, buơl guhã rơŭ thơu lài Kơu dò lăm Ama Kơu, buơl guhã dò lăm Kơu, sơ̆ng Kơu dò lăm buơl guhã. ");
INSERT INTO cje_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Aràng sơi hũ du pơnuaĭ adăt-pơđăr Kơu sơ̆ng păng-rơmiă, nư̆n la mơnih uơ̆n-rơnăm Kơu; mơnih lơi uơ̆n-rơnăm Kơu rơŭ hũ Ama Kơu uơ̆n-rơnăm, Kơu kŭng rơŭ uơ̆n-rơnăm mơnih nư̆n, sơ̆ng ràng-tơbiă rùp-phŭn Kơu tơ mơnih nư̆n.” ");
INSERT INTO cje_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Juđa, 'buh iơŭ la Juđa Iskariôt, đờm lài: “Ơ Yàng, kơđa hơgĕ Yàng mĭn ràng-tơbiă rùp-phŭn drơi tơ buơl dơlhă bloh 'buh ràng-tơbiă tơ dun-ya?” ");
INSERT INTO cje_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yàng Jêsu đờm: “Yah aràng sơi uơ̆n-rơnăm Kơu, nư̆n rơŭ păng-rơmiă pơnuaĭ Kơu, Ama Kơu rơŭ uơ̆n-rơnăm mơnih nư̆n. Ama Kơu sơ̆ng Kơu rơŭ truh sơ̆ng mơnih nư̆n, sơ̆ng rơŭ dò sơ̆ng mơnih nư̆n. ");
INSERT INTO cje_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Aràng sơi 'buh uơ̆n-rơnăm Kơu, nư̆n 'buh păng-rơmiă du pơnuaĭ Kơu. Du pơnuaĭ buơl guhã mơhư̆ nư̆n, 'buh iơŭ la pơnuaĭ Kơu, bloh la pơnuaĭ Ama, Pô hũ pơđăr Kơu. ");
INSERT INTO cje_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Kơu hũ đờm du pơnuaĭ ni sơ̆ng buơl guhã lăm tŭ Kơu dò sơ̆ng buơl guhã. ");
INSERT INTO cje_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Bloh Pô Pơluơ-Pơrơngài, nư̆n la Yàng Bơngă Sơc̆ih-Sri, bloh Ama rơŭ mă angăn Kơu pơđăr truh, Pô nư̆n rơŭ pơto-pơsài buơl guhã tơgrơ̆ pơnuaĭ. Pô rơŭ ngă tơ buơl guhã sơdơ̆r wơ̆ abih tơgrơ̆ pơnuaĭ Kơu hũ đờm sơ̆ng buơl guhã. ");
INSERT INTO cje_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Kơu luơi pơnuaĭ rĭng-lơngai wơ̆ tơ buơl guhã. Kơu brơi pơnuaĭ rĭng-lơngai Kơu tơ buơl guhã. Pơnuaĭ rĭng-lơngai Kơu brơi tơ buơl guhã 'buh iơŭ yơu dun-ya brơi. Hơtai-hơtiàn buơl guhã juơi sơnư̆ng kơ-ù sơ̆ng juơi huơĭ kơđa. ");
INSERT INTO cje_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Buơl guhã hũ mơhư̆ Kơu đờm: ‘Kơu nau, sơ̆ng Kơu rơŭ gài truh wơ̆ sơ̆ng buơl guhã.’ Yah buơl guhã uơ̆n-rơnăm Kơu, nư̆n buơl guhã păl sờh-sài bĕ kơyoa Kơu nau wơ̆ sơ̆ng Ama, kơyoa Ama prŏng-màng rơlau Kơu. ");
INSERT INTO cje_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Tŭ ni, Kơu đờm du pơnuaĭ nư̆n sơ̆ng buơl guhã dơlhơu tơ tŭ bruă tơbiă truh, tô tŭ bruă tơbiă truh, nư̆n buơl guhã rơŭ păng-tui. ");
INSERT INTO cje_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Kơu 'buh dò tŭ-jơ đờm lô sơ̆ng buơl guhã tra, kơyoa mơnih apăn-akŏ dun-ya ni kơjĕ truh bơjơ. Ñu 'buh hũ gơnuăr hơgĕ tơ ngŏ Kơu. ");
INSERT INTO cje_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Bloh Kơu rơŭ ngă tui pơnuaĭ Ama Kơu đờm pơđăr, tô dun-ya thơu lài Kơu uơ̆n-rơnăm Ama. Tơgồ dơ̆ng bĕ! Buơl gudrơi păl nau klàh mư̆ng ni.” ");
INSERT INTO cje_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Kơu la phŭn ño biă, Ama Kơu la mơnih pla ño. ");
INSERT INTO cje_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Yah thàn lơi lăm Kơu bloh 'buh tơbiă boh, nư̆n Pô koh prah. Dò du thàn lơi tơbiă boh, nư̆n Pô treh-kơtrĕ siàm, tô hũ lô boh rơlau. ");
INSERT INTO cje_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Buơl guhã hũ goh-sơc̆ih, gơnừm tơ pơnuaĭ Kơu hũ đờm pơto buơl guhã. ");
INSERT INTO cje_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Dò bĕ mĭt lăm Kơu, nư̆n Kơu rơŭ dò lăm buơl guhã. Mơhiơ̆ yơu thàn ño, yah 'buh klĕm lăm phŭn ño, nư̆n 'buh mư̆ng rùp-phŭn drơi tơbiă boh jiơ̆ng. Buơl guhã kŭng yơu nư̆n rơi, yah buơl guhã 'buh dò mĭt lăm Kơu, nư̆n kŭng 'buh mư̆ng rùp-phŭn drơi tơbiă boh jiơ̆ng. ");
INSERT INTO cje_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Kơu la phŭn ño, buơl guhã la thàn. Aràng sơi dò mĭt lăm Kơu, sơ̆ng Kơu dò mĭt lăm buơl guñu, nư̆n rơŭ tơbiă lô boh, kơyoa 'buh hũ Kơu, buơl guhã 'buh ngă hơgĕ jiơ̆ng. ");
INSERT INTO cje_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Yah aràng sơi 'buh dò mĭt lăm Kơu, nư̆n păl prah tơ agàh, kŭng mơhiơ̆ yơu thàn ño, thàn thu, aràng duơ̆n wơ̆, prah lăm apui, nư̆n ñu 'bơ̆ng gùh. ");
INSERT INTO cje_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Yah buơl guhã dò mĭt lăm Kơu, sơ̆ng du pơnuaĭ Kơu dò mĭt lăm buơl guhã, yòng-lơkơu bĕ tơgrơ̆ pơnuaĭ hơgĕ drơi khiăng, nư̆n buơl guhã rơŭ đồ-mă hũ pơnuaĭ nư̆n. ");
INSERT INTO cje_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Pơnuaĭ rơŭ ngă tơ Ama Kơu hũ mơyòm-pơglòng nư̆n la: Buơl guhã hũ tơbiă lô boh sơ̆ng tơbiă jiơ̆ng mơnih tui-mơgru Kơu. ");
INSERT INTO cje_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Yơu Ama hũ uơ̆n-rơnăm Kơu hơyơu lơi, Kơu kŭng uơ̆n-rơnăm buơl guhã yơu nư̆n rơi. Dò bĕ mĭt lăm pơnuaĭ uơ̆n-rơnăm Kơu. ");
INSERT INTO cje_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Yah buơl guhã păng-rơmiă du pơnuaĭ adăt-pơđăr Kơu, nư̆n rơŭ dò lăm pơnuaĭ uơ̆n-rơnăm Kơu, kŭng yơu Kơu hũ păng-rơmiă du pơnuaĭ adăt-pơđăr Ama Kơu, sơ̆ng dò mĭt lăm pơnuaĭ uơ̆n-rơnăm Pô. ");
INSERT INTO cje_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Kơu đờm sơ̆ng buơl guhã du pơnuaĭ ni, tô pơnuaĭ sờh-sài Kơu dò lăm buơl guhã, sơ̆ng pơnuaĭ sờh-sài buơl guhã hũ wĭl-tơ̆l. ");
INSERT INTO cje_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ni la pơnuaĭ adăt-pơđăr Kơu: Buơl guhã păl rơnăm gơŭ bĕ, kŭng yơu Kơu hũ rơnăm buơl guhã. ");
INSERT INTO cje_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","'Buh hũ pơnuaĭ uơ̆n-rơnăm lơi prŏng rơlau pơnuaĭ uơ̆n-rơnăm la kơyoa mư̆ng mơnih adơi-ai gơŭ bloh prah-luơi pơnuaĭ hơdiŭ drơi. ");
INSERT INTO cje_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Yah buơl guhã ngă tui du pơnuaĭ Kơu pơto pơđăr, nư̆n buơl guhã la adơi-ai gơŭ Kơu. ");
INSERT INTO cje_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Kơu 'buh iơu buơl guhã la hơlŭn-hơlă tra, kơyoa hơlŭn-hơlă 'buh thơu du bruă mơnih pô drơi ngă. Bloh Kơu iơu buơl guhã la adơi-ai gơŭ, kơyoa Kơu hũ ràng-tơbiă tơ buơl guhã thơu abih tơgrơ̆ pơnuaĭ Kơu hũ mơhư̆ anih Ama Kơu. ");
INSERT INTO cje_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","'Buh iơŭ buơl guhã hũ rơwah Kơu, bloh Kơu hũ rơwah sơ̆ng pồ-pơđăr buơl guhã, tô buơl guhã nau sơ̆ng hũ tơbiă bơnga boh, sơ̆ng boh buơl guhã kừ dò mĭt; tô abih tơgrơ̆ pơnuaĭ hơgĕ buơl guhã mă angăn Kơu bloh lơkơu-yòng sơ̆ng Ama, nư̆n Pô brơi tơ buơl guhã. ");
INSERT INTO cje_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Kơu pơto pơđăr pơnuaĭ ni tơ buơl guhã, tô buơl guhã uơ̆n-rơnăm duă gơŭ.” ");
INSERT INTO cje_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Yah dun-ya mơbai buơl guhã, nư̆n thơu bĕ lài buơl guñu hũ mơbai tơ Kơu dơlhơu tơ buơl guhã. ");
INSERT INTO cje_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Yah buơl guhã găm sơ̆ng dun-ya, nư̆n dun-ya rơŭ uơ̆n-rơnăm du mơnih găm sơ̆ng ñu. Bloh kơyoa buơl guhã 'buh găm sơ̆ng dun-ya, sơ̆ng Kơu hũ pơlih-rơwah buơl guhã tơbiă klàh mư̆ng dun-ya, nư̆n dun-ya mơbai buơl guhã. ");
INSERT INTO cje_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Sơdơ̆r bĕ pơnuaĭ Kơu hũ đờm sơ̆ng buơl guhã: ‘Hơlŭn-hơlă 'buh prŏng rơlau pô drơi.’ Yah buơl guñu hũ mă-pơkơŭ Kơu, nư̆n kŭng rơŭ mă-pơkơŭ buơl guhã. Yah buơl guñu păng-rơmiă pơnuaĭ Kơu, nư̆n kŭng rơŭ păng-rơmiă pơnuaĭ buơl guhã. ");
INSERT INTO cje_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Bloh kơyoa angăn Kơu, buơl guñu rơŭ ngă tơgrơ̆ pơnuaĭ nư̆n tơ buơl guhã, kơyoa buơl guñu 'buh thơu Pô hũ pơđăr Kơu truh. ");
INSERT INTO cje_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Yah Kơu 'buh truh sơ̆ng 'buh đờm sơ̆ng buơl guñu, nư̆n buơl guñu 'buh hũ glài hơgĕ. Bloh tŭ ni, buơl guñu 'buh rơgơi đờm dŏng tơ glài-sơnoh buơl guñu jiơ̆ng. ");
INSERT INTO cje_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Aràng sơi mơbai Kơu, nư̆n kŭng mơbai Ama Kơu rơi. ");
INSERT INTO cje_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Yah Kơu 'buh ngă tơkrah buơl guñu tơgrơ̆ bruă bloh ka hũ mơnih lơi ngă, nư̆n buơl guñu 'buh hũ glài. Bloh tŭ ni buơl guñu hũ 'buh tơgrơ̆ bruă nư̆n bơjơ, bloh sơđaŭ dò mơbai tơ Kơu sơ̆ng Ama Kơu wơ̆. ");
INSERT INTO cje_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Yơu nư̆n la tơbiă iơŭ tơpă yơu pơnuaĭ hũ wă lăm 'bồn bơ-àr Adăt-Adia buơl guñu: ‘Guñu mơbai tơ Kơu soh-săr 'buh kơyoa pơnuaĭ hơgĕ.’ ");
INSERT INTO cje_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Bloh tŭ Pô Pơluơ-Pơrơngài truh, la Pô bloh Kơu rơŭ mư̆ng Ama pơđăr truh sơ̆ng buơl guhã. Pô la Bơngă Sơc̆ih-Sri pơnuaĭ-tơpă tơbiă mư̆ng Ama, rùp-phŭn Pô rơŭ ngă grơh mư̆ng Kơu. ");
INSERT INTO cje_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Buơl guhã kŭng rơŭ ngă grơh mư̆ng Kơu, kơyoa buơl guhã hũ dò sơ̆ng Kơu mư̆ng tŭ c̆ơmrừp.” ");
INSERT INTO cje_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Kơu đờm sơ̆ng buơl guhã du pơnuaĭ ni, tô tŭ păp pơnuaĭ gleh-glăr kăn-dơmăn buơl guhã rơŭ 'buh sơnĕ lơbuh. ");
INSERT INTO cje_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Buơl guñu rơŭ prơh-tơluh buơl guhã tơbiă mư̆ng sàng pơtòm. Sơ̆ng rơŭ truh tŭ du mơnih pơmơtai buơl guhã sơnư̆ng lài yơu nư̆n la duh bruă Yàng Pô Lơngì! ");
INSERT INTO cje_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Buơl guñu rơŭ ngă du pơnuaĭ nư̆n, kơyoa buơl guñu 'buh thơu Ama sơ̆ng kŭng 'buh thơu Kơu. ");
INSERT INTO cje_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Bloh Kơu hũ đờm du pơnuaĭ ni tơ buơl guhã, tô tŭ truh jơ buơl guñu, buơl guhã rơŭ sơdơ̆r wơ̆ lài Kơu hũ đờm tơ buơl guhã bơjơ. Kơu 'buh đờm du pơnuaĭ ni sơ̆ng buơl guhã mư̆ng tŭ c̆ơmrừp, kơyoa tŭ nư̆n Kơu dò sơ̆ng buơl guhã. ");
INSERT INTO cje_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Bloh tŭ ni Kơu kơjĕ nau wơ̆ sơ̆ng Pô hũ pơđăr Kơu truh, sơ̆ng 'buh hũ aràng sơi lăm buơl guhã tơnia Kơu: ‘Pô-Pơto nau anih lơi?’ ");
INSERT INTO cje_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Kơyoa Kơu đờm dơlhơu du pơnuaĭ ni sơ̆ng buơl guhã, nư̆n lăm hơtai-hơtiàn buơl guhã baŭ pơnuaĭ dơnuh-dơnà. ");
INSERT INTO cje_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Bloh yah yơu nư̆n, Kơu đờm biă sơ̆ng buơl guhã: Kơu nau la kwơ-màng tơ buơl guhã. Kơyoa yah Kơu 'buh nau, nư̆n Pô Pơluơ-Pơrơngài rơŭ 'buh truh sơ̆ng buơl guhã. Bloh yah Kơu nau, nư̆n Kơu rơŭ pơđăr Pô truh. ");
INSERT INTO cje_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Tŭ Pô truh, Pô rơŭ puaĭ pơto dun-ya mư̆ng glài-sơnoh, mư̆ng pơnuaĭ rĭng-tơpă sơ̆ng mư̆ng pơnuaĭ c̆ahrơña. ");
INSERT INTO cje_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Mư̆ng glài-sơnoh, kơyoa buơl guñu 'buh păng-tui Kơu; ");
INSERT INTO cje_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","mư̆ng pơnuaĭ rĭng-tơpă, kơyoa Kơu nau truh sơ̆ng Ama, sơ̆ng buơl guhã rơŭ 'bu 'buh Kơu tra; ");
INSERT INTO cje_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","mư̆ng pơnuaĭ c̆ahrơña, kơyoa mơnih apăn-akŏ dun-ya ni hũ kơđòng c̆ahrơña bơjơ. ");
INSERT INTO cje_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Kơu dò lô pơnuaĭ tô đờm sơ̆ng buơl guhã, bloh tŭ ni buơl guhã 'buh rơgơi wờng jai. ");
INSERT INTO cje_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Tŭ Bơngă Sơc̆ih-Sri, la Pô ràng-tơbiă pơnuaĭ-tơpă truh, Pô rơŭ ba buơl guhã tơma lăm tơgrơ̆ pơnuaĭ-tơpă. Kơyoa Pô rơŭ 'buh mư̆ng rùp-phŭn drơi đờm pơnuaĭ hơgĕ, bloh rơŭ đờm tơgrơ̆ pơnuaĭ hơgĕ Pô hũ mơhư̆, sơ̆ng đờm tơ buơl guhã thơu mư̆ng tơgrơ̆ bruă rơŭ tơbiă truh. ");
INSERT INTO cje_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Pô rơŭ mơyòm-pơglòng Kơu, kơyoa Pô rơŭ mă tơgrơ̆ hơgĕ đồ-mă hũ mư̆ng Kơu bloh brơi pơthơu tơ buơl guhã. ");
INSERT INTO cje_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Abih tơgrơ̆ hơgĕ Ama hũ la hơnù Kơu. Kơyoa nư̆n Kơu đờm lài Pô rơŭ mă tơgrơ̆ hơgĕ đồ-mă hũ mư̆ng Kơu bloh brơi pơthơu tơ buơl guhã.” ");
INSERT INTO cje_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Dò 'buh hơdu suơi tra, buơl guhã rơŭ 'bu 'buh Kơu, bloh nư̆n 'buh hơdu suơi tra, buơl guhã rơŭ 'buh Kơu wơ̆.” ");
INSERT INTO cje_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Kơyoa nư̆n, du mơnih tui-mơgru đờm sơ̆ng gơŭ: “Pô-Pơto khiăng đờm hơgĕ tŭ đờm lài, ‘Dò 'buh hơdu suơi tra buơl guhã rơŭ 'bu 'buh Kơu, bloh nư̆n 'buh hơdu suơi tra buơl guhã rơŭ 'buh Kơu wơ̆’, sơ̆ng ‘Kơyoa Kơu nau wơ̆ sơ̆ng Ama?’ ” ");
INSERT INTO cje_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Buơl guñu đờm: “Pô-Pơto khiăng đờm hơgĕ tŭ Pô-Pơto đờm, ‘Dò 'buh hơdu suơi tra’? Buơl gudrơi biă 'buh wờng Pô-Pơto khiăng đờm mư̆ng bruă hơgĕ.” ");
INSERT INTO cje_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yàng Jêsu thơu du mơnih tui-mơgru khiăng tơnia Pô, nư̆n đờm lài: “Hũ iơŭ buơl guhã tăm-tơnia gơŭ mư̆ng pơnuaĭ Kơu pơrpa đờm: ‘Dò 'buh hơdu suơi tra buơl guhã rơŭ 'bu 'buh Kơu; bloh nư̆n 'buh hơdu suơi tra buơl guhã rơŭ 'buh Kơu wơ̆,’ hũ mơblàng la hơgĕ, iơŭ ơu? ");
INSERT INTO cje_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Iơŭ biă, Kơu đờm sơ̆ng buơl guhã, buơl guhã rơŭ hia c̆ŏ sơ̆ng wờl lồk, dò mơnih dun-ya rơŭ sờh-sài. Buơl guhã rơŭ dơnuh-dơnà, bloh pơnuaĭ dơnuh-dơnà buơl guhã rơŭ tơbiă jiơ̆ng pơnuaĭ sờh-sài. ");
INSERT INTO cje_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Mơnih kơmơi tŭ đih apui nư̆n pơđì-pơđoa, kơyoa hũ truh jơ drơi; bloh tŭ anà hũ đih apui tơbiă, nư̆n mơnih ame 'buh dò sơdơ̆r truh pơnuaĭ pơđì-pơđoa tra, bloh sờh-sài kơyoa sa aràng mơnih hũ đih apui tơbiă lăm dun-ya. ");
INSERT INTO cje_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Kŭng yơu nư̆n rơi, tŭ ni buơl guhã pơđì-pơđoa dơnuh-dơnà, bloh Kơu rơŭ tòm buơl guhã wơ̆, nư̆n hơtai-hơtiàn buơl guhã rơŭ sờh-sài, sơ̆ng 'buh aràng sơi hũ rơgơi tămblah mă pơnuaĭ sờh-sài buơl guhã jiơ̆ng. ");
INSERT INTO cje_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Lăm hơrơi nư̆n, buơl guhã rơŭ 'buh tơnia Kơu pơnuaĭ hơgĕ tra. Iơŭ biă, Kơu đờm sơ̆ng buơl guhã, abih tơgrơ̆ pơnuaĭ hơgĕ buơl guhã lơkơu-yòng sơ̆ng Ama, nư̆n Pô rơŭ mă angăn Kơu bloh brơi tơ buơl guhã. ");
INSERT INTO cje_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Truh tŭ ni, buơl guhã sơđaŭ ka mă angăn Kơu bloh lơkơu-yòng pơnuaĭ hơgĕ. Lơkơu-yòng bĕ, nư̆n buơl guhã rơŭ đồ-mă hũ, tô pơnuaĭ sờh-sài buơl guhã hũ wĭl-tơ̆l. ");
INSERT INTO cje_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Kơu hũ angui pơnuaĭ pơgăp-pơmơyơu tô đờm du pơnuaĭ ni sơ̆ng buơl guhã. Bloh rơŭ truh tŭ, Kơu 'buh dò angui pơnuaĭ pơgăp-pơmơyơu tô đờm sơ̆ng buơl guhã tra, bloh Kơu rơŭ đờm loh-làng mư̆ng Ama tơ buơl guhã. ");
INSERT INTO cje_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Lăm hơrơi nư̆n, buơl guhã rơŭ mă angăn Kơu bloh lơkơu-yòng. Kơu 'buh đờm lài Kơu rơŭ kơyoa buơl guhã bloh lơkơu-yòng sơ̆ng Ama ơu; ");
INSERT INTO cje_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","kơyoa rùp-phŭn Ama uơ̆n-rơnăm buơl guhã, kơyoa buơl guhã hũ uơ̆n-rơnăm Kơu, sơ̆ng păng-tui lài Kơu mư̆ng Yàng Pô Lơngì truh. ");
INSERT INTO cje_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Kơu mư̆ng Ama truh lăm dun-ya, sơ̆ng Kơu rơŭ klà luơi dun-ya tô gài wơ̆ sơ̆ng Ama.” ");
INSERT INTO cje_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Du mơnih tui-mơgru đờm lài: “Tŭ ni Pô-Pơto đờm loh-làng, 'buh angui pơnuaĭ pơgăp-pơmơyơu tra. ");
INSERT INTO cje_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Tŭ ni buơl dơlhă thơu lài Pô-Pơto thơu loh-làng abih tơgrơ̆ pơnuaĭ, sơ̆ng Pô-Pơto 'buh c̆àng păl tơnia aràng sơi pơnuaĭ hơgĕ. Kơyoa nư̆n, buơl dơlhă păng-tui lài Pô-Pơto truh mư̆ng Yàng Pô Lơngì.” ");
INSERT INTO cje_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yàng Jêsu đờm: “Tŭ ni buơl guhã păng-tui jơ? ");
INSERT INTO cje_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ni, jơ truh, sơ̆ng hũ truh bơjơ, la tŭ buơl guhã rơŭ c̆ơrlah-c̆ơrlờp, yàu aràng yàu sơnah, sơ̆ng buơl guhã rơŭ luơi Kơu wơ̆ sa aràng. Bloh Kơu 'buh dò sa aràng ơu, kơyoa Ama dò sơ̆ng Kơu. ");
INSERT INTO cje_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Kơu hũ đờm sơ̆ng buơl guhã tơgrơ̆ pơnuaĭ ni, tô buơl guhã hũ pơnuaĭ rĭng-lơngai lăm Kơu. Buơl guhã rơŭ hũ pơnuaĭ rŭng-rài lăm dun-ya, bloh kơjăp hơtai-hơtiàn bĕ, Kơu hũ pha-jai rơlau tơ dun-ya bơjơ.” ");
INSERT INTO cje_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Hơdơi tŭ đờm du pơnuaĭ nư̆n, Yàng Jêsu tơ̆ mơta tơ ngŏ lơngì sơ̆ng đờm lài: “Ơ Ama! Jơ hũ truh. Yòng Ama ngă màng-kơc̆rà Anà, tô Anà kŭng ngă màng-kơc̆rà Ama. ");
INSERT INTO cje_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Kơyoa Ama hũ brơi tơ Anà gơnuăr tơ ngŏ abih tơgrơ̆ jơi drah-rơlo, tô brơi pơnuaĭ hơdiŭ rài pơdò rài tơ abih tơgrơ̆ mơnih Ama hũ jào tơ Anà. ");
INSERT INTO cje_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Pơnuaĭ hơdiŭ rài pơdò rài la kràn-thơu Ama, la Yàng Pô Lơngì mĭn hũ sa sơ̆ng tơpă-biă, sơ̆ng kràn-thơu Yàng Jêsu Krist, la Pô Ama hũ pơđăr truh. ");
INSERT INTO cje_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Anà hũ mơyòm-pơglòng Ama tơ ngŏ lơ̆n, sơ̆ng ngă wĭl-tơ̆l bruă Ama jào tơ Anà ngă. ");
INSERT INTO cje_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ơ Ama! Tŭ ni, yòng mă pơnuaĭ màng-kơc̆rà Anà sơđaŭ hũ sơ̆ng Ama dơlhơu tơ tŭ hũ dun-ya, bloh ngă màng-kơc̆rà Anà tơ anaŭ Ama. ");
INSERT INTO cje_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Anà hũ akhàn-tơbiă angăn Ama tơ du mơnih Ama brơi tơ Anà mư̆ng tơkrah dun-ya ni. Buơl guñu găm sơ̆ng Ama. Ama hũ brơi buơl guñu tơ Anà, sơ̆ng buơl guñu hũ păng-rơmiă ngă tui pơnuaĭ Ama. ");
INSERT INTO cje_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Tŭ ni buơl guñu thơu lài abih tơgrơ̆ pơnuaĭ hơgĕ Ama hũ brơi tơ Anà la mư̆ng Ama bloh truh. ");
INSERT INTO cje_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Kơyoa Anà hũ brơi tơ buơl guñu du pơnuaĭ Ama hũ brơi tơ Anà, sơ̆ng buơl guñu hũ đồ-mă tơgrơ̆ pơnuaĭ nư̆n. Buơl guñu kŭng thơu tơpă biă lài Anà mư̆ng Ama bloh truh, sơ̆ng buơl guñu hũ păng-tui lài Ama hũ pơđăr Anà. ");
INSERT INTO cje_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Anà kơyoa mư̆ng buơl guñu bloh lơkơu-yòng, 'buh iơŭ kơyoa dun-ya bloh Anà lơkơu-yòng ơu, bloh kơyoa du mơnih Ama hũ brơi tơ Anà, kơyoa buơl guñu la găm sơ̆ng Ama. ");
INSERT INTO cje_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Abih tơgrơ̆ hơgĕ Anà hũ la hơnù Ama, abih tơgrơ̆ hơgĕ Ama hũ la hơnù Anà; sơ̆ng Anà hũ mơyòm-pơglòng anih buơl guñu. ");
INSERT INTO cje_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Anà 'buh dò lăm dun-ya tra, Anà nau wơ̆ sơ̆ng Ama, bloh buơl guñu sơđaŭ dò lăm dun-ya. Khoai Ama sơc̆ih-sri! Yòng grăp-gròng buơl guñu lăm angăn Ama, la angăn Ama hũ brơi tơ Anà, tô buơl guñu hũ rơgơi tơbiă jiơ̆ng sa yơu Ama sơ̆ng Anà. ");
INSERT INTO cje_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Tŭ Anà dò sơ̆ng buơl guñu, Anà grăp-gròng buơl guñu lăm angăn Ama, la angăn Ama hũ brơi tơ Anà. Anà hũ c̆ơ-gàr buơl guñu, 'buh luơi lơhiă sa aràng mơnih lơi, mĭn sa aràng anà pơnuaĭ mơtai-lơhiă soh, tô pơnuaĭ 'Bồn Bơ-àr Sơc̆ih-Sri hũ iơŭ tơpă biă. ");
INSERT INTO cje_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Bloh tŭ ni Anà nau wơ̆ sơ̆ng Ama, sơ̆ng Anà đờm du pơnuaĭ ni tŭ dò lăm dun-ya, tô buơl guñu hũ đồ-lĕng wĭl-tơ̆l pơnuaĭ sờh-sài Anà. ");
INSERT INTO cje_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Anà hũ brơi tơ buơl guñu pơnuaĭ Ama, sơ̆ng dun-ya mơbai-lơmù buơl guñu, kơyoa buơl guñu 'buh găm sơ̆ng dun-ya, kŭng yơu Anà 'buh găm sơ̆ng dun-ya. ");
INSERT INTO cje_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Anà 'buh yòng lơkơu Ama suă buơl guñu klàh mư̆ng dun-ya, bloh yòng Ama grăp-gròng buơl guñu klàh mư̆ng pơnuaĭ mơsak-jơhà. ");
INSERT INTO cje_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Buơl guñu 'buh găm sơ̆ng dun-ya, kŭng yơu Anà 'buh găm sơ̆ng dun-ya. ");
INSERT INTO cje_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Yòng Ama angui pơnuaĭ-tơpă pơsơc̆ih-sri buơl guñu. Pơnuaĭ Ama la pơnuaĭ-tơpă. ");
INSERT INTO cje_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Yơu Ama hũ pơđăr Anà tơma lăm dun-ya, nư̆n Anà kŭng pơđăr buơl guñu tơma lăm dun-ya. ");
INSERT INTO cje_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Anà kơyoa buơl guñu ngă tơ rùp-phŭn drơi jiơ̆ng sơc̆ih-sri, tô buơl guñu kŭng gơnừm tơ pơnuaĭ-tơpă bloh hũ jiơ̆ng sơc̆ih-sri rơi. ");
INSERT INTO cje_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Anà 'buh mĭn iơu-lài tơ du mơnih ni soh, bloh Anà kŭng iơu-lài tơ du mơnih lơi păng pơnuaĭ buơl guñu bloh păng-tui Anà rơi, ");
INSERT INTO cje_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","tô abih buơl guñu rơŭ tơbiă jiơ̆ng sa, yơu Ama dò lăm Anà, sơ̆ng Anà dò lăm Ama, sơ̆ng buơl guñu kŭng dò lăm buơl gudrơi, tô dun-ya păng-tui lài Ama hũ pơđăr Anà truh. ");
INSERT INTO cje_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Anà hũ brơi tơ buơl guñu pơnuaĭ màng-kơc̆rà bloh Ama hũ brơi tơ Anà, tô buơl guñu tơbiă jiơ̆ng sa, yơu buơl gudrơi la sa. ");
INSERT INTO cje_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Anà dò lăm buơl guñu sơ̆ng Ama dò lăm Anà, tô buơl guñu hũ tơbiă jiơ̆ng sa wĭl-tơ̆l, gơnừm tơ nư̆n dun-ya thơu lài Ama hũ pơđăr Anà truh, sơ̆ng Ama hũ uơ̆n-rơnăm buơl guñu yơu Ama hũ uơ̆n-rơnăm Anà. ");
INSERT INTO cje_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ơ Ama, Anà khiăng Anà dò anih lơi, nư̆n du mơnih Ama hũ brơi tơ Anà kŭng dò tơ anih nư̆n sơ̆ng Anà, tô buơl guñu niăm-c̆ơ pơnuaĭ màng-kơc̆rà bloh Ama hũ brơi tơ Anà; kơyoa Ama hũ rơnăm Anà mư̆ng dơlhơu tơ tŭ ka c̆rơ̆ng-tơbiă lơngì-tơsì tơnah-rơya. ");
INSERT INTO cje_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Khoai Ama la Pô rĭng-tơpă, dun-ya 'buh thơu Ama, bloh Anà hũ thơu Ama; sơ̆ng du mơnih ni thơu lài Ama hũ pơđăr Anà truh. ");
INSERT INTO cje_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Anà hũ brơi buơl guñu thơu angăn Ama, sơ̆ng rơŭ dò brơi buơl guñu thơu wơ̆, tô pơnuaĭ uơ̆n-rơnăm bloh Ama uơ̆n-rơnăm Anà rơŭ dò lăm buơl guñu, sơ̆ng rùp-phŭn Anà kŭng dò lăm buơl guñu rơi.” ");
INSERT INTO cje_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Hơdơi tŭ iơu-lài, Yàng Jêsu nau sơ̆ng du mơnih tui-mơgru truh gah dih c̆roh ia Ketrôn. Tơ anih nư̆n hũ sa boh apùh, Pô sơ̆ng du mơnih tui-mơgru nau tơma lăm nư̆n. ");
INSERT INTO cje_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Juđa, mơnih pơblơ̆-dră Pô, kŭng thơu anih ni, kơyoa Yàng Jêsu sơ̆ng du mơnih tui-mơgru jiăng pơtòm-pơjŭm gơŭ tơ anih ni. ");
INSERT INTO cje_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Yơu nư̆n, Juđa ba sa tơrpuơl lĭng găm sơ̆ng du mơnih dò tơ ala gơnuăr du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt sơ̆ng mơnih Pharisi, apăn apui đèng, apui sơnuh, sơ̆ng đào-sơdrà truh tơ anih nư̆n. ");
INSERT INTO cje_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yàng Jêsu thơu abih tơgrơ̆ bruă hơgĕ rơŭ tơbiă truh tơ drơi, nư̆n yàm truh bloh tơnia: “Buơl guhã duah aràng sơi?” ");
INSERT INTO cje_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Buơl guñu đờm: “Duah Jêsu, mơnih Nasaret.” Yàng Jêsu đờm: “La rùp-phŭn Kơu ni!” Juđa, mơnih pơblơ̆-dră Pô kŭng dò dơ̆ng tơ anih nư̆n sơ̆ng buơl guñu rơi. ");
INSERT INTO cje_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Tŭ Yàng Jêsu đờm: “La rùp-phŭn Kơu ni,” nư̆n buơl guñu gơdŭn wơ̆ sơ̆ng lơbuh tơ ala lơ̆n. ");
INSERT INTO cje_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Pô tơnia buơl guñu sa amăng tra wơ̆: “Buơl guhã duah aràng sơi?” Buơl guñu đờm: “Duah Jêsu, mơnih Nasaret.” ");
INSERT INTO cje_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yàng Jêsu đờm: “Kơu hũ đờm sơ̆ng buơl guhã bơjơ, la rùp-phŭn Kơu ni. Yơu nư̆n, yah buơl guhã duah mă Kơu, nư̆n luơi bĕ du mơnih ni nau.” ");
INSERT INTO cje_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Pơnuaĭ ni hũ tơbiă iơŭ yơu pơnuaĭ Pô hũ đờm: “Anà 'buh luơi lơhiă sa aràng mơnih lơi lăm du mơnih Ama hũ jào tơ Anà.” ");
INSERT INTO cje_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Tŭ nư̆n, Simôn Pier hũ sa 'bĕ đào; Pier suă đào tơbiă, ngă mơnih hơlŭn-hơlă mơnih gơnuăr prŏng apăn-akŏ pơyă phơ̆n duh-dơlbăt, tă kloh tơnia gah hơnuă mơnih nư̆n. Mơnih hơlŭn-hơlă nư̆n angăn la Malc̆u. ");
INSERT INTO cje_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yàng Jêsu đờm sơ̆ng Pier: “C̆rò bĕ đào hã tơma lăm srŭm! C̆uàn bloh Ama hũ jào tơ Kơu, hơyơu Kơu 'buh mơñŭm ơu?” ");
INSERT INTO cje_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Tŭ nư̆n, buơl lĭng, mơnih apăn-akŏ buơl lĭng, găm sơ̆ng du mơnih dò tơ ala gơnuăr buơl làng Juđa mă Yàng Jêsu sơ̆ng c̆aŭ wơ̆. ");
INSERT INTO cje_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Dơlhơu biă, buơl guñu ba Pô truh tơ Anne, kơyoa Anne la ama-tămhã Kaiphe. Kaiphe la mơnih gơnuăr prŏng apăn-akŏ pơyă phơ̆n duh-dơlbăt lăm thŭn nư̆n. ");
INSERT INTO cje_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Rùp-phŭn Kaiphe la mơnih hũ đờm bơyai sơ̆ng mơnih Juđa lài: “Yah luơi sa aràng mơnih kŏng mơtai ala tơ abih buơl làng, nư̆n sơđaŭ kwơ rơlau.” ");
INSERT INTO cje_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simôn Pier sơ̆ng sa aràng mơnih tui-mơgru pơkơ̆n nau tui Yàng Jêsu. Kơyoa hũ mừng-thơu sơ̆ng mơnih gơnuăr prŏng apăn-akŏ pơyă phơ̆n duh-dơlbăt, nư̆n mơnih tui-mơgru ni tui Yàng Jêsu tơma truh 'blàng dơrlăm sàng-glăng mơnih gơnuăr prŏng apăn-akŏ pơyă phơ̆n duh-dơlbăt. ");
INSERT INTO cje_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Bloh Pier nư̆n dò dơ̆ng tơ agàh jĕ bơh 'băng prŏng. Kơyoa nư̆n, mơnih tui-mơgru dih, la mơnih hũ mừng-thơu sơ̆ng mơnih gơnuăr prŏng apăn-akŏ pơyă phơ̆n duh-dơlbăt, tơbiă nau đờm sơ̆ng mơnih kơmơi kraŭ-khiă bơh 'băng prŏng, bloh nư̆n ba Pier tơma. ");
INSERT INTO cje_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Mơnih kơmơi dò kraŭ-khiă bơh 'băng prŏng đờm sơ̆ng Pier: “'Buh iơŭ kơi kŭng la sa aràng lăm du mơnih tui-mơgru mơnih nư̆n ơu?” Pier đờm sơđồ: “'Buh iơŭ dơlhă ơu!” ");
INSERT INTO cje_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Kơyoa glai mơrềt, nư̆n du mơnih hơlŭn-hơlă sơ̆ng du mơnih lĭng khiă-gàr c̆uh sa puk apui, bloh nư̆n dò dơ̆ng tòmdăr apui tô pơđau. Pier kŭng dò dơ̆ng tơ anih nư̆n, dò apui sơ̆ng buơl guñu rơi. ");
INSERT INTO cje_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Mơnih gơnuăr prŏng apăn-akŏ pơyă phơ̆n duh-dơlbăt tơnia Yàng Jêsu mư̆ng du mơnih tui-mơgru Pô sơ̆ng mư̆ng du pơnuaĭ pơto-akhàn Pô. ");
INSERT INTO cje_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yàng Jêsu đờm: “Kơu hũ đờm loh-làng tơ anaŭ plơi-lơgăr. Kơu jiăng pơto-mơblàng lăm du sàng pơtòm, sàng duh-dơlbăt, la anih du mơnih Juđa pơgùm-pơtòm, Kơu 'buh đờm bơdơŭ tơrđơŭ pơnuaĭ hơgĕ. ");
INSERT INTO cje_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Kơđa hơgĕ hã tơnia Kơu? Tơnia bĕ du mơnih hũ păng Kơu đờm. Rùp-phŭn buơl guñu thơu tơgrơ̆ pơnuaĭ Kơu hũ đờm.” ");
INSERT INTO cje_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Tŭ Yàng Jêsu dò đờm yơu nư̆n, hũ sa aràng lăm tơrpuơl mơnih dò tơ ala gơnuăr buơl guñu hũ mơta anih nư̆n, mă tơngàn pah găn 'bò Pô, sơ̆ng đờm: “Hã khĭn đờm sơđồ yơu nư̆n sơ̆ng mơnih gơnuăr prŏng apăn-akŏ pơyă phơ̆n duh-dơlbăt?” ");
INSERT INTO cje_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yàng Jêsu đờm: “Yah Kơu đờm sŭng, pơto bĕ anih sŭng tơ Kơu c̆ơ; bloh yah Kơu đờm iơŭ, nư̆n kơđa hơgĕ hã ngă Kơu?” ");
INSERT INTO cje_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Anne pơđăr ba bơnau Yàng Jêsu sơđaŭ dò c̆aŭ yơu nư̆n truh tơ Kaiphe, la mơnih gơnuăr prŏng apăn-akŏ pơyă phơ̆n duh-dơlbăt. ");
INSERT INTO cje_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Tŭ Pier sơđaŭ dò dơ̆ng suơ apui tơ anih 'blàng agàh, nư̆n du mơnih dò dơ̆ng tơ anih nư̆n tơnia Pier: “Sơ-ai kŭng la sa aràng lăm du mơnih tui-mơgru kơi nư̆n rơi, iơŭ ơu?” Pier kơmlah sơ̆ng đờm: “'Buh iơŭ dơlhă ơu.” ");
INSERT INTO cje_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Sa aràng lăm du mơnih hơlŭn-hơlă mơnih gơnuăr prŏng apăn-akŏ pơyă phơ̆n duh-dơlbăt, hũ gơŭ-găn sơ̆ng mơnih bloh Pier tă kloh tơnia, đờm: “Dơlhă sơdơ̆r, rùp-phŭn dơlhă hũ 'buh kơi lăm anih apùh găm sơ̆ng mơnih nư̆n rơi, iơŭ ơu?” ");
INSERT INTO cje_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pier đờm kơmlah sa amăng tra wơ̆; tŭ nư̆n mư hũ săp mơnŭ kơ-iòk. ");
INSERT INTO cje_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ờm prŭ hơrơi nư̆n, buơl guñu ba bơnau Yàng Jêsu mư̆ng sàng Kaiphe truh tơ sàng-glăng Pilat, la kwăng apăn-akŏ du c̆àr lăm lơgăr. Rùp-phŭn buơl guñu 'buh tơma lăm sàng-glăng, tô klàh kơđòng sơŭ-sơnoh, sơ̆ng tô hũ 'bơ̆ng pơnuaĭ pơjŭm 'bơ̆ng Nau-Găn. ");
INSERT INTO cje_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Kơyoa nư̆n, Pilat nau tơbiă tòm buơl guñu sơ̆ng tơnia: “Buơl guhã yă mơnih ni mư̆ng glài hơgĕ?” ");
INSERT INTO cje_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Buơl guñu đờm sơđồ: “Yah mơnih ni 'buh iơŭ la mơnih ngă pơnuaĭ mơsak-jơhà, nư̆n buơl dơlhă 'buh jào ñu tơ mơnih kwăng ơu.” ");
INSERT INTO cje_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilat đờm sơ̆ng buơl guñu: “Buơl guhã kừ ba ñu nau, sơ̆ng c̆ahrơña tui adăt-adia buơl guhã.” Mơnih Juđa đờm: “Buơl dơlhă 'buh hũ gơnuăr ngă nìn-glài pơmơtai aràng sơi ơu.” ");
INSERT INTO cje_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Pơnuaĭ ni tơbiă iơŭ tơpă yơu pơnuaĭ Yàng Jêsu hũ đờm, tŭ đờm truh bruă Pô păl mơtai hơyơu lơi. ");
INSERT INTO cje_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilat gài tơma wơ̆ lăm dơrlăm sàng-glăng, pơđăr mơnih ba Yàng Jêsu truh sơ̆ng tơnia Pô: “Hũ iơŭ hã la Pơtau buơl làng Juđa ơu?” ");
INSERT INTO cje_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yàng Jêsu đờm: “Mư̆ng hơtai rùp-phŭn kơi đờm pơnuaĭ nư̆n, halài hũ mơnih lơi pơkơ̆n đờm sơ̆ng kơi mư̆ng Kơu?” ");
INSERT INTO cje_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilat đờm sơđồ: “Kơu hũ iơŭ la mơnih Juđa rơi? Buơl làng hã sơ̆ng du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt hũ jào hã tơ kơu. Yơu nư̆n hã hũ ngă pơnuaĭ hơgĕ?” ");
INSERT INTO cje_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yàng Jêsu đờm: “Lơgăr Kơu 'buh găm sơ̆ng dun-ya ni. Yah lơgăr Kơu găm sơ̆ng dun-ya ni, nư̆n du mơnih tui Kơu hũ tămngă bơjơ, 'buh luơi Kơu kơđòng jào lăm tơngàn mơnih Juđa. Bloh lơgăr Kơu 'buh găm sơ̆ng dun-ya ni.” ");
INSERT INTO cje_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilat đờm: “Yơu nư̆n hã la pơtau làh?” Yàng Jêsu đờm: “Iơŭ yơu pơnuaĭ đờm, Kơu la pơtau. Ni la pơnuaĭ phŭn kơđa hơgĕ Kơu hũ tơbiă rài, kơđa hơgĕ Kơu hũ truh lăm dun-ya: Nư̆n la tô ngă grơh tơ pơnuaĭ-tơpă. Aràng sơi găm sơ̆ng pơnuaĭ-tơpă nư̆n păng pơnuaĭ Kơu.” ");
INSERT INTO cje_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilat tơnia Pô: “Pơnuaĭ-tơpă la hơgĕ?” Hơdơi tŭ đờm yơu nư̆n, Pilat nau tơbiă tòm mơnih Juđa wơ̆, sơ̆ng đờm: “Kơu 'bu 'buh mơnih ni hũ glài hơgĕ ơu. ");
INSERT INTO cje_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Bloh buơl guhã hũ adăt-lơđăp ni, kừ truh pơnuaĭ pơjŭm 'bơ̆ng Nau-Găn, nư̆n kơu toh-tơleh tơ buơl guhã sa aràng mơnih glài jàm. Yơu nư̆n, buơl guhã hũ khiăng kơu toh-tơleh pơtau buơl làng Juđa tơ buơl guhã ơu?” ");
INSERT INTO cje_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Buơl guñu driau prŏng lài: “Juơi toh-tơleh ñu, bloh yòng toh-tơleh 'Baraba!” 'Baraba la sa aràng mơnih blơ̆. ");
INSERT INTO cje_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Tŭ nư̆n, Pilat pơđăr ba Yàng Jêsu nau sơ̆ng pơđăr glih-pờng Pô. ");
INSERT INTO cje_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Buơl lĭng mơñàm sa boh kơlmu ngă sơ̆ng druơi, pơklŭm tơ akŏ Pô, sơ̆ng pơc̆ù tơ Pô sa blah ào mơr-yah. ");
INSERT INTO cje_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Buơl guñu truh jĕ Pô, sơ̆ng đờm: “Khoai pơtau buơl làng Juđa!” Bloh nư̆n guñu pah tơ 'bò Pô. ");
INSERT INTO cje_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilat tơbiă tơ agàh sa amăng tra wơ̆, đờm sơ̆ng buơl làng: “Ni, kơu ba ñu tơbiă tơ agàh gơ buơl guhã, tô buơl guhã thơu la kơu 'buh duah 'buh ñu hũ glài-sơnoh hơgĕ ơu.” ");
INSERT INTO cje_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Yơu nư̆n, Yàng Jêsu nau tơbiă, akŏ klŭm kơlmu sơ̆ng druơi, rùp c̆ù ào mơr-yah. Pilat đờm sơ̆ng buơl guñu: “Ni, ñu ni.” ");
INSERT INTO cje_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Bloh tŭ du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt sơ̆ng du mơnih dò tơ ala gơnuăr buơl guñu 'buh Pô, nư̆n kơmrào driau lài: “Pơ̆ng ñu tơ kơyơu pơkăl! Pơ̆ng ñu tơ kơyơu pơkăl!” Pilat đờm sơ̆ng buơl guñu: “Rùp-phŭn buơl guhã mă bĕ ñu sơ̆ng ba nau pơ̆ng tơ kơyơu pơkăl, kơyoa kơu 'buh duah 'buh ñu hũ glài-sơnoh hơgĕ ơu.” ");
INSERT INTO cje_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Du mơnih Juđa đờm: “Buơl dơlhă hũ adăt-adia, sơ̆ng tui adăt-adia buơl dơlhă, nư̆n ñu păl mơtai, kơyoa ñu hũ pơ-angăn rùp-phŭn ñu la Anà Yàng Pô Lơngì.” ");
INSERT INTO cje_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Tŭ Pilat mơhư̆ yơu nư̆n, ñu 'brŏ huơĭ-kơđa rơlau wơ̆. ");
INSERT INTO cje_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ñu gài tơma wơ̆ lăm sàng-glăng bloh đờm sơ̆ng Yàng Jêsu: “Hã mư̆ng lơi truh?” Bloh Yàng Jêsu 'buh đờm sơđồ. ");
INSERT INTO cje_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Kơyoa nư̆n, Pilat đờm sơ̆ng Pô: “Hã 'buh đờm hơgĕ sơ̆ng kơu ơu? Hã 'buh thơu lài kơu hũ gơnuăr toh-tơleh hã, kŭng hũ gơnuăr pơ̆ng hã tơ kơyơu pơkăl ơu?” ");
INSERT INTO cje_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yàng Jêsu đờm: “Yah 'buh kơyoa mư̆ng ngŏ brơi tơ kơi, nư̆n kơi 'buh hũ gơnuăr hơgĕ tơ ngŏ Kơu. Kơyoa nư̆n, mơnih jào Kơu tơ kơi hũ glài traŭ rơlau.” ");
INSERT INTO cje_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Mư̆ng tŭ nư̆n, Pilat duah pơnuaĭ tô toh-tơleh Pô, bloh du mơnih Juđa driau prŏng lài: “Yah kwăng toh-tơleh mơnih ni, nư̆n kwăng 'buh iơŭ la mơnih tơpă sa hơtai-hơtiàn sơ̆ng Sesa. Kơyoa mơnih lơi pơ-angăn rùp-phŭn drơi la pơtau, nư̆n la tămdră-wơ̆ sơ̆ng Sesa.” ");
INSERT INTO cje_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Tŭ Pilat mơhư̆ du pơnuaĭ ni, nư̆n ba Yàng Jêsu tơbiă tơ agàh, bloh nư̆n dò guh tơ anih c̆ahrơña, tơ anih angăn la Rơnơ̆-Pơtơu, ia Hebrơ angăn la Gabatha. ");
INSERT INTO cje_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Hơrơi nư̆n la hơrơi Rơc̆ăng-Dơlhơu tơ pơnuaĭ pơjŭm 'bơ̆ng Nau-Găn, tŭ pơgăp sa-pluh dua jơ glai hơrơi, Pilat đờm sơ̆ng du mơnih Juđa lài: “Ni la pơtau buơl guhã!” ");
INSERT INTO cje_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Buơl guñu driau prŏng: “Pơluĭ-pơlơhiă ñu bĕ! Pơluĭ-pơlơhiă ñu bĕ! Pơ̆ng bĕ ñu tơ kơyơu pơkăl!” Pilat đờm: “Kơu rơŭ pơ̆ng pơtau buơl guhã tơ kơyơu pơkăl la?” Du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt đờm: “Buơl dơlhă mĭn hũ sa aràng pơtau soh, nư̆n la Sesa.” ");
INSERT INTO cje_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Pilat jào Yàng Jêsu tơ buơl guñu, tô ba nau pơ̆ng tơ kơyơu pơkăl. Yơu nư̆n, guñu mă Pô sơ̆ng ba nau. ");
INSERT INTO cje_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yàng Jêsu glăm kơyơu pơkăl nau truh tơ sa anih angăn la Brò Akŏ, ia Hebrơ angăn la Gôgôtha. ");
INSERT INTO cje_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Tơ anih nư̆n, buơl guñu pơ̆ng Pô lăm kơyơu pơkăl. Hũ dua aràng mơnih pơkơ̆n kŭng kŏng pơ̆ng lăm kơyơu pơkăl yơu Pô; sa aràng gah ni sơ̆ng sa aràng gah dih, dò Yàng Jêsu nư̆n tơkrah. ");
INSERT INTO cje_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilat kŭng pơđăr mă sa blơ kơmàn sơ̆ng yuăl tơ ngŏ kơyơu pơkăl. Lăm blơ kơmàn nư̆n hũ wă: “Jêsu Mơnih Nasaret, Pơtau Buơl Làng Juđa.” ");
INSERT INTO cje_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Kơyoa anih Yàng Jêsu kŏng pơ̆ng tơ kơyơu pơkăl dò jĕ tơ plơi-prŏng, sơ̆ng blơ kơmàn hũ wă sơ̆ng ia Hebrơ, ia Latin sơ̆ng ia Grek, nư̆n hũ lô mơnih Juđa pơrpoh-c̆ơ. ");
INSERT INTO cje_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt mơnih Juđa đờm sơ̆ng Pilat: “Yòng juơi wă: ‘Pơtau buơl làng Juđa,’ bloh wă bĕ: ‘Mơnih ni đờm: Kơu la Pơtau buơl làng Juđa.’ ” ");
INSERT INTO cje_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilat đờm sơđồ: “Pơnuaĭ kơu hũ wă, nư̆n kơu hũ wă bơjơ.” ");
INSERT INTO cje_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Hơdơi tŭ pơ̆ng Yàng Jêsu lăm kơyơu pơkăl, du mơnih lĭng mă ào agàh Pô, pơrpha ngă pà pơ-ơnah, yàu aràng mă sa pơ-ơnah. Buơl guñu kŭng mă găm ào jruh Pô, bloh ào jruh ni la sa blah bơ-yài mơñàm mư̆ng ngŏ trŭn tơ ala, 'buh hũ jơlàn sì. ");
INSERT INTO cje_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Nư̆n buơl guñu đờm sơ̆ng gơŭ: “Juơi hĕt ào ni, bloh buơl gudrơi suă khà bĕ, c̆ơ aràng sơi hũ.” Bruă tơbiă truh iơŭ yơu pơnuaĭ 'Bồn Bơ-àr Sơc̆ih-Sri: “Buơl guñu pơrpha gơŭ khăn-ào Kơu, Suă khà mă ào jruh Kơu.” Nư̆n la bruă buơl lĭng hũ ngă. ");
INSERT INTO cje_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Dò dơ̆ng tơ tơkai kơyơu pơkăl aràng pơ̆ng Yàng Jêsu hũ ame Pô, sơ-ai ame Pô, Mari sơdiŭ Klôpa, sơ̆ng Mari Mađơlen. ");
INSERT INTO cje_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yàng Jêsu 'buh ame Pô, sơ̆ng mơnih tui-mơgru Pô rơnăm dò dơ̆ng jĕ, nư̆n Pô đờm sơ̆ng ame Pô: “Ơ ame, nư̆n la anà ame!” ");
INSERT INTO cje_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Bloh nư̆n Pô đờm sơ̆ng mơnih tui-mơgru nư̆n: “Ni la ame hã!” Mư̆ng jơ nư̆n, mơnih tui-mơgru ni ba mò mơrai wơ̆ tơ sàng drơi. ");
INSERT INTO cje_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Hơdơi mư̆ng nư̆n, Yàng Jêsu thơu tơgrơ̆ bruă hũ wĭl-tơ̆l bơjơ, tô pơnuaĭ 'Bồn Bơ-àr Sơc̆ih-Sri hũ tơbiă iơŭ tơpă, nư̆n đờm lài: “Kơu mơhau ia!” ");
INSERT INTO cje_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Tơ anih nư̆n hũ sa boh bìng pơdơ̆ng baŭ ia mơsăm. Buơl guñu mă sa kleh phơ̆n kơsồp, ơñrŭ baŭ ia mơsăm, akă tơ akŏ sa 'bĕ gai, bloh nư̆n pơyơ̆r truh tơ kàng Yàng Jêsu. ");
INSERT INTO cje_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Hơdơi tŭ Yàng Jêsu tiăm ia mơsăm, Pô đờm: “Tơgrơ̆ bruă hũ wĭl-tơ̆l bơjơ.” Bloh nư̆n Pô kŭn akŏ trŭn sơ̆ng kloh suàn. ");
INSERT INTO cje_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Kơyoa tŭ nư̆n la hơrơi Rơc̆ăng Dơlhơu, nư̆n du mơnih Juđa 'buh khiăng luơi du rùp atơu sơđaŭ dò kơđòng yuăl tơ ngŏ kơyơu pơkăl lăm hơrơi sa'bat, kơyoa hơrơi sa'bat ni la prŏng-màng biă. Kơyoa nư̆n, buơl guñu yòng Pilat pơđăr mơnih pờng pơc̆ah tơlàng tơkai du mơnih nư̆n, sơ̆ng mă rùp atơu trŭn. ");
INSERT INTO cje_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Yơu nư̆n, du mơnih lĭng truh, pờng pơc̆ah tơlàng tơkai mơnih c̆ơmrừp, bloh nư̆n truh mơnih dih, la dua aràng mơnih kơđòng pơ̆ng tơ kơyơu pơkăl găm sơ̆ng Pô. ");
INSERT INTO cje_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Bloh tŭ truh anih Yàng Jêsu, buơl guñu 'buh Pô mơtai bơjơ, nư̆n 'buh pờng pơc̆ah tơlàng tơkai Pô. ");
INSERT INTO cje_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Bloh hũ sa aràng mơnih lĭng mă sơdrà jră găn rơsŭ Pô, lăm tơk mư drah sơ̆ng ia hŏ tơbiă. ");
INSERT INTO cje_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Mơnih hũ tơ mơta c̆ơ 'buh ngă grơh mư̆ng bruă ni, sơ̆ng pơnuaĭ ngă grơh mơnih nư̆n la tơpă biă, kơyoa mơnih nư̆n thơu drơi đờm pơnuaĭ tơpă, tô buơl guhã kŭng păng-tui rơi. ");
INSERT INTO cje_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Tơgrơ̆ bruă hũ tơbiă truh iơŭ tơpă yơu pơnuaĭ 'Bồn Bơ-àr Sơc̆ih-Sri hũ đờm dơlhơu: “'Buh sa 'bĕ tơlàng lơi lăm rùp Pô rơŭ kơđòng joh.” ");
INSERT INTO cje_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Sơ̆ng kŭng hũ pơnuaĭ pơkơ̆n lăm 'Bồn Bơ-àr Sơc̆ih-Sri wă lài: “Buơl guñu rơŭ c̆ơ 'buh mơnih bloh drơi hũ jră.” ");
INSERT INTO cje_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Hơdơi du bruă nư̆n, Jôsep mơnih plơi Arimathe, la sa aràng mơnih tui-mơgru Yàng Jêsu, bloh la sa aràng mơnih tui-mơgru tơrđơŭ-bơdơŭ, kơyoa huơĭ tơ mơnih Juđa, ñu truh yòng Pilat brơi gơnuăr mă rùp atơu Yàng Jêsu trŭn. Pilat brơi gơnuăr tơ ñu. Yơu nư̆n, Jôsep truh sơ̆ng mă rùp atơu Pô apăn nau. ");
INSERT INTO cje_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikôđem, la mơnih tŭ dơlhơu hũ truh sơ̆ng Yàng Jêsu lăm glai mơlăm, kŭng truh. Nikôđem apăn tui klơu pluh lĭt c̆ài-trŭ jrơu sơ̆ng gơlhơu. ");
INSERT INTO cje_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Buơl guñu mă rùp atơu Yàng Jêsu bloh nư̆n angui bơ-yài lơmŭn sơ̆ng jrào 'bơu bơlhơu bloh pơpò wơ̆, tui adăt-lơđăp pơpò atơu mơnih Juđa. ");
INSERT INTO cje_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Tơ anih Yàng Jêsu kŏng pơ̆ng tơ kơyơu pơkăl hũ sa boh apùh, sơ̆ng lăm apùh nư̆n hũ sa boh kŭt atơu dò bơrhơu, ka dơ̆r aràng sơi. ");
INSERT INTO cje_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Kơyoa hơrơi nư̆n la hơrơi Rơc̆ăng Dơlhơu tơ hơrơi pơjŭm 'bơ̆ng mơnih Juđa, sơ̆ng kŭt nư̆n kŭng dò jĕ, nư̆n buơl guñu dơ̆r Yàng Jêsu tơ anih nư̆n. ");
INSERT INTO cje_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Hơrơi c̆ơmrừp lăm sa tơjuh, tŭ lơngì dò rìng rìng sơrdah, Mari Mađơlen nau truh tơ kŭt atơu, 'buh boh pơtơu kơdrơ̆ tơ anaŭ kŭt hũ pơrlơ̆ng nau sơgah. ");
INSERT INTO cje_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ñu tơmbah-tơmbàn đuaĭ truh tòm Simôn Pier sơ̆ng mơnih tui-mơgru dih, la mơnih tui-mơgru Yàng Jêsu rơnăm, sơ̆ng đờm: “Aràng hũ apăn Yàng nau klàh mư̆ng kŭt atơu bơjơ, sơ̆ng buơl dơlhă 'buh thơu buơl guñu luơi Pô anih lơi.” ");
INSERT INTO cje_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Pier sơ̆ng mơnih tui-mơgru dih tơbiă nau mư, tô truh tơ kŭt atơu. ");
INSERT INTO cje_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Abih dua aràng sơ̆ng gơŭ đuaĭ, bloh mơnih tui-mơgru dih đuaĭ sơmăr rơlau Pier, sơ̆ng truh tơ kŭt dơlhơu. ");
INSERT INTO cje_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Mơnih tui-mơgru nư̆n kù tơ ala, c̆ơ lăm dơrlăm kŭt, sơ̆ng 'buh bơ-yài pơpò atơu dò tơ anih nư̆n, bloh 'buh tơma. ");
INSERT INTO cje_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simôn Pier tui hơdơi kŭng truh anih. Ñu tơma tơpă lăm kŭt atơu, sơ̆ng 'buh bơ-yài pơpò atơu dò tơ anih nư̆n, ");
INSERT INTO cje_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","sơ̆ng c̆ơnră jơ̆m akŏ Yàng Jêsu nư̆n 'buh dò sơgơŭ sa anih sơ̆ng bơ-yài pơpò, bloh blì wơ̆, daŭ krơi sa anih. ");
INSERT INTO cje_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Tŭ nư̆n, mơnih tui-mơgru dih, la mơnih hũ truh tơ kŭt dơlhơu, kŭng nau tơma, 'buh sơ̆ng păng-tui. ");
INSERT INTO cje_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Bloh buơl guñu sơđaŭ ka wờng pơnuaĭ 'Bồn Bơ-àr Sơc̆ih-Sri wă lài Pô păl mư̆ng mơnih mơtai hơdiŭ wơ̆. ");
INSERT INTO cje_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Hơdơi mư̆ng nư̆n, dua aràng mơnih tui-mơgru gài wơ̆ tơ sàng. ");
INSERT INTO cje_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Bloh Mari dò dơ̆ng tơ agàh kŭt atơu bloh hia. Ñu hia găm, kù c̆ơ găm lăm dơrlăm kŭt atơu, ");
INSERT INTO cje_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","nư̆n 'buh dua aràng mơnih gơdrưh c̆ù ào kò, dò guh tơ anih hũ daŭ rùp atơu Yàng Jêsu, sa aràng dò guh gah akŏ, sa aràng gah tơkai. ");
INSERT INTO cje_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Dua aràng mơnih gơdrưh tơnia: “Ơ mơnih kơmơi, kơđa hơgĕ hã hia?” Mari đờm sơđồ: “Kơyoa aràng apăn Yàng dơlhă nau thĭt bơjơ, dơlhă 'buh thơu buơl guñu luơi Pô anih lơi!” ");
INSERT INTO cje_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Hơdơi tŭ đờm yơu nư̆n, ñu pơtrah wơ̆ sơ̆ng 'buh Yàng Jêsu dò dơ̆ng tơ anih nư̆n, bloh ñu 'buh thơu nư̆n la Yàng Jêsu. ");
INSERT INTO cje_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yàng Jêsu tơnia ñu: “Ni mơnih kơmơi, kơđa hơgĕ hã hia? Hã duah aràng sơi?” Mari sơnư̆ng lài nư̆n la mơnih ngă apùh, nư̆n đờm: “Ơ kơi, yah kơi hũ apăn Pô nau, yòng đờm brơi dơlhă thơu kơi hũ daŭ Pô anih lơi, tô dơlhă rơŭ truh bloh mă.” ");
INSERT INTO cje_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yàng Jêsu iơu: “Mari!” Mari pơtrah wơ̆, angui ia Hebrơ bloh đờm lài: “Rabôni!” (mơblàng la Pô-Pơto). ");
INSERT INTO cje_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yàng Jêsu đờm: “Juơi tŭp truh Kơu, kơyoa Kơu ka đì sơ̆ng Ama! Bloh nau truh bĕ sơ̆ng buơl adơi-ai Kơu, đờm sơ̆ng buơl guñu lài: Kơu păl đì sơ̆ng Ama Kơu, kŭng la Ama buơl guhã, sơ̆ng Yàng Pô Lơngì Kơu, kŭng la Yàng Pô Lơngì buơl guhã.” ");
INSERT INTO cje_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mari Mađơlen nau akhàn tơ du mơnih tui-mơgru thơu lài ñu hũ 'buh Yàng, sơ̆ng đờm akhàn wơ̆ du pơnuaĭ Pô hũ đờm sơ̆ng ñu. ");
INSERT INTO cje_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Glai diơŭ hơrơi nư̆n, la hơrơi c̆ơmrừp lăm sa tơjuh, tơgrơ̆ bơh 'băng anih du mơnih tui-mơgru dò sơđaŭ kăl-kơdrơ̆ kơjăp, kơyoa huơĭ tơ mơnih Juđa. Yàng Jêsu truh dò dơ̆ng tơkrah buơl guñu sơ̆ng đờm: “Lơngai-siàm tơ buơl guhã!” ");
INSERT INTO cje_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Hơdơi tŭ đờm yơu nư̆n, Pô brơi buơl guñu c̆ơ tơngàn sơ̆ng rơsŭ drơi. Tŭ 'buh Yàng, du mơnih tui-mơgru sờh-sài biă. ");
INSERT INTO cje_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yàng Jêsu đờm sơ̆ng buơl guñu: “Lơngai-siàm tơ buơl guhã! Yơu Ama hũ pơđăr Kơu hơyơu lơi, Kơu kŭng pơđăr buơl guhã yơu nư̆n rơi!” ");
INSERT INTO cje_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Hơdơi tŭ Pô đờm yơu nư̆n, Pô blùh joa tơ ngŏ buơl guñu, sơ̆ng đờm: “Đồ-mă bĕ Yàng Bơngă Sơc̆ih-Sri! ");
INSERT INTO cje_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Yah buơl guhã toh-luơi glài tơ aràng sơi, glài mơnih nư̆n rơŭ hũ toh-luơi. Yah buơl guhã 'buh toh-luơi glài tơ aràng sơi, glài mơnih nư̆n rơŭ 'buh hũ toh-luơi.” ");
INSERT INTO cje_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tŭ Yàng Jêsu truh, nư̆n Thôma, angăn la Điđim, la sa aràng lăm sa-pluh dua aràng mơnih tơdi-tơdài, 'buh hũ mơta tơ anih nư̆n sơ̆ng du mơnih tui-mơgru. ");
INSERT INTO cje_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Du mơnih tui-mơgru pơkơ̆n đờm sơ̆ng ñu: “Buơl dơlhă hũ 'buh Yàng.” Bloh Thôma đờm: “Yah dơlhă 'bu 'buh nàl đĭn lăm plà tơngàn Pô, yah dơlhă 'buh daŭ anà tơngàn dơlhă lăm anih hũ nàl đĭn, sơ̆ng 'buh daŭ plà tơngàn dơlhă lăm anih rơsŭ Pô, nư̆n dơlhă rơŭ 'buh păng-tui.” ");
INSERT INTO cje_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Tơlpăn hơrơi hơdơi, du mơnih tui-mơgru dò pơtòm-pơjŭm gơŭ lăm sàng, Thôma kŭng hũ mơta tơ anih nư̆n sơ̆ng buơl guñu rơi. Tŭ tơgrơ̆ bơh 'băng hũ kăl-kơdrơ̆ kơjăp, Yàng Jêsu truh dò dơ̆ng tơkrah buơl guñu, sơ̆ng đờm: “Lơngai-siàm tơ buơl guhã!” ");
INSERT INTO cje_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Bloh nư̆n Pô đờm sơ̆ng Thôma: “Daŭ bĕ anà tơngàn hã lăm ni, sơ̆ng c̆ơ plà tơngàn Kơu. Kŭng yơ̆r bĕ plà tơngàn hã tơbiă, sơ̆ng daŭ lăm anih rơsŭ Kơu. Juơi kră-khăng hơtai-hơtiàn, bloh păng-tui bĕ!” ");
INSERT INTO cje_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Thôma đờm lài: “Khoai Yàng dơlhă sơ̆ng Yàng Pô Lơngì dơlhă!” ");
INSERT INTO cje_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yàng Jêsu đờm: “Kơyoa hã hũ 'buh Kơu nư̆n hã păng-tui. Lơngai-pơtuah tơ du mơnih 'bu 'buh bloh păng-tui.” ");
INSERT INTO cje_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yàng Jêsu hũ ngă tơ anaŭ du mơnih tui-mơgru Pô lô nàl-c̆rih pơkơ̆n wơ̆, bloh 'buh wă lăm bơ-àr ni. ");
INSERT INTO cje_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Bloh tơgrơ̆ bruă ni hũ wă tơbiă, tô buơl guhã păng-tui lài Yàng Jêsu la Pô Krist, Anà Yàng Pô Lơngì, sơ̆ng tô tŭ buơl guhã păng-tui, nư̆n gơnừm tơ angăn Pô bloh hũ pơnuaĭ hơdiŭ. ");
INSERT INTO cje_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Hơdơi mư̆ng nư̆n, Yàng Jêsu hũ tơbiă pơ'buh rùp sơ̆ng du mơnih tui-mơgru Pô jĕ tơ gah ia-tơsì Tiberias. Bruă Pô tơbiă pơ'buh rùp yơu ni: ");
INSERT INTO cje_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simôn Pier, Thôma angăn la Điđim, Nathanael, mơnih plơi-prŏng Kana c̆àr Galile, du anà lơkơi Sebeđe, sơ̆ng dua aràng mơnih tui-mơgru pơkơ̆n dò pơgùm-pơtòm sơ̆ng gơŭ. ");
INSERT INTO cje_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simôn Pier đờm sơ̆ng buơl guñu: “Dơlhă nau mă akàn!” Du mơnih dih đờm: “Buơl dơlhă kŭng nau sơ̆ng sơ-ai!” Buơl guñu trŭn gơlài sơ̆ng tơbiă nau, bloh lăm mơlăm nư̆n, buơl guñu 'buh mă hũ hơgĕ ơu. ");
INSERT INTO cje_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Truh glai ờm, Yàng Jêsu dò dơ̆ng tơ gah ia, bloh du mơnih tui-mơgru 'buh thơu nư̆n la Yàng Jêsu. ");
INSERT INTO cje_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yàng Jêsu đờm sơ̆ng buơl guñu: “Ơ buơl anà, mă hũ akàn ơu?” Buơl guñu đờm: “'Buh ơu.” ");
INSERT INTO cje_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Pô đờm: “Dăng bĕ sơñuăl gah hơnuă gơlài, nư̆n buơl guhã rơŭ mă hũ akàn.” Buơl guñu dăng sơñuăl trŭn, bloh nư̆n 'buh rơgơi kơtŭng đì jiơ̆ng, kơyoa lăm sơñuăl baŭ du akàn. ");
INSERT INTO cje_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Mơnih tui-mơgru hũ Yàng Jêsu rơnăm đờm sơ̆ng Pier: “Nư̆n la Yàng!” Tŭ Simôn Pier mơhư̆ đờm “nư̆n la Yàng!” Pier tơmbah-tơmbàn mă ào c̆ù, kơyoa tŭ nư̆n ñu dò kŭl, bloh nư̆n kơsĕt trŭn lăm ia. ");
INSERT INTO cje_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Du mơnih tui-mơgru pơkơ̆n wah gơlài tơma, hua tui sa sơñuăl baŭ du akàn, kơyoa buơl guñu 'buh atàh hơdùm mư̆ng gah ia, mĭn pơgăp sa rơtùh met soh. ");
INSERT INTO cje_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Tŭ đì truh tơ gah ia, buơl guñu 'buh tơ anih nư̆n hũ apui a-ngàh, tơ ngŏ hũ akàn, sơ̆ng hũ pah wơ̆. ");
INSERT INTO cje_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yàng Jêsu đờm: “Apăn bĕ du drơi akàn bloh buơl guhã pơrpa mă hũ mơrai tơ ni.” ");
INSERT INTO cje_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simôn Pier trŭn lăm gơlài, hua sơñuăl đì tơ gah ia. Lăm sơñuăl baŭ du akàn prŏng, yàu hũ sa rơtùh lơma pluh klơu drơi. Sơ̆ng yah akàn lô yơu nư̆n bloh sơñuăl sơđaŭ 'buh kloh. ");
INSERT INTO cje_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yàng Jêsu đờm: “Buơl guhã truh bloh 'bơ̆ng ờm bĕ!” 'Buh sa aràng mơnih lơi lăm du mơnih tui-mơgru khĭn tơnia lài: “Kơi la aràng sơi?” Kơyoa buơl guñu thơu nư̆n la Yàng. ");
INSERT INTO cje_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yàng Jêsu truh, mă pah brơi tơ buơl guñu, sơ̆ng kŭng brơi găm akàn rơi. ");
INSERT INTO cje_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ni la amăng klơu Yàng Jêsu tơbiă pơ'buh rùp sơ̆ng du mơnih tui-mơgru Pô, hơdơi tŭ Pô mư̆ng mơnih mơtai hơdiŭ wơ̆. ");
INSERT INTO cje_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Hơdơi tŭ buơl guñu 'bơ̆ng bơjơ, Yàng Jêsu đờm sơ̆ng Simôn Pier: “Ơ Simôn, anà Jôna, hã rơnăm Kơu rơlau du mơnih ni ơu?” Pier đờm: “Khoai Yàng, Yàng thơu lài dơlhă rơnăm Yàng.” Yàng Jêsu đờm: “Ròng-glăng bĕ du abo anà Kơu.” ");
INSERT INTO cje_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Pô tơnia ñu amăng dua: “Ơ Simôn, anà Jôna, hã rơnăm Kơu ơu?” Pier đờm: “Khoai Yàng, Yàng thơu lài dơlhă rơnăm Yàng.” Yàng Jêsu đờm: “Glăng bĕ abo Kơu.” ");
INSERT INTO cje_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Pô tơnia ñu amăng klơu wơ̆: “Ơ Simôn, anà Jôna, hã rơnăm Kơu ơu?” Pier dơnuh-dơnà biă kơyoa Pô tơnia drơi truh klơu amăng lài: “Hã rơnăm Kơu ơu?” Ñu đờm sơ̆ng Pô: “Khoai Yàng, Yàng thơu abih tơgrơ̆ bruă. Yàng thơu lài dơlhă rơnăm Yàng.” Yàng Jêsu đờm: “Ròng-glăng bĕ abo Kơu.” ");
INSERT INTO cje_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Iơŭ biă, “Kơu đờm sơ̆ng hã, tŭ hã dò dăm, hã akă tơlơi kơ-iăng tơ hã, sơ̆ng khiăng nau anih lơi nư̆n nau; bloh tŭ hã tha, hã rơŭ yơ̆r tơngàn tơbiă, bloh nư̆n mơnih pơkơ̆n rơŭ akă tơlơi kơ-iăng tơ hã, sơ̆ng ba hã nau truh anih hã 'buh khiăng.” ");
INSERT INTO cje_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Pô đờm yơu nư̆n tô brơi thơu mư̆ng Pier rơŭ mơtai hơyơu lơi tô ngă màng-kơc̆rà angăn Yàng Pô Lơngì. Sơ̆ng hơdơi tŭ đờm yơu nư̆n, Pô đờm sơ̆ng Pier: “Tui bĕ Kơu!” ");
INSERT INTO cje_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pier pơtrah wơ̆, 'buh mơnih tui-mơgru bloh Yàng Jêsu rơnăm nau tui hơdơi; nư̆n la mơnih bloh lăm tŭ huă 'bơ̆ng diơŭ, hũ pơkiăng rùp jĕ tơ hărda Yàng Jêsu sơ̆ng tơnia: “Khoai Yàng, aràng sơi la mơnih rơŭ pơblơ̆-dră Pô?” ");
INSERT INTO cje_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Tŭ 'buh mơnih nư̆n, Pier tơnia Yàng Jêsu: “Ơ Yàng, dò mơnih ni nư̆n hơyơu?” ");
INSERT INTO cje_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yàng Jêsu đờm: “Yah Kơu khiăng mơnih nư̆n kừ hơdiŭ tơ̆l truh tơ tŭ Kơu truh nư̆n hũ bruă hơgĕ truh tơ hã? Pơ-ơnah hã, tui bĕ Kơu!” ");
INSERT INTO cje_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Kơyoa nư̆n, hũ pơnuaĭ pơtiơ̆ng tơkrah buơl adơi-ai lài mơnih tui-mơgru nư̆n rơŭ 'buh mơtai. Bloh Yàng Jêsu 'buh đờm sơ̆ng Pier lài: “Mơnih ni rơŭ 'buh mơtai,” bloh mĭn đờm: “Yah Kơu khiăng mơnih ni kừ dò hơdiŭ tơ̆l truh tơ tŭ Kơu truh nư̆n hũ bruă hơgĕ truh tơ hã?” ");
INSERT INTO cje_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Rùp-phŭn mơnih tui-mơgru nư̆n ngă grơh mư̆ng tơgrơ̆ bruă ni, sơ̆ng hũ wă luơi wơ̆. Buơl gudrơi thơu lài pơnuaĭ ngă grơh ñu la tơpă biă. ");
INSERT INTO cje_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yàng Jêsu dò ngă lô bruă pơkơ̆n wơ̆. Yah kừ wă abih tui yàu bruă, nư̆n dơlhă sơnư̆ng lài abih dun-ya kŭng 'buh tơ̆l anih tô pioh abih du 'bơ-àr hũ wă tơbiă.");
INSERT INTO cje_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ơ Theôphil, lăm bơ-àr c̆ơmrừp, dơlhă hũ wă mư̆ng abih tơgrơ̆ bruă Yàng Jêsu hũ ngă sơ̆ng pơto-pơsài mư̆ng c̆ơmrừp, ");
INSERT INTO cje_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","tơ̆l truh tơ hơrơi Pô hũ rò-đì tơ ngŏ lơngì, hơdơi tŭ Pô gơnừm tơ Yàng Bơngă Sơc̆ih-Sri bloh pơto-pơđăr du mơnih tơdi-tơdài Pô hũ pơlih-rơwah. ");
INSERT INTO cje_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Hơdơi tŭ kŏng pơnuaĭ pơđì-pơđoa gleh-glăr, nư̆n tơ anaŭ du mơnih tơdi-tơdài, Pô mă lô pơnuaĭ c̆ơ̆ng-grơh ràng-tơbiă brơi thơu la Pô dò hơdiŭ. Pô tơbiă pơ'buh rùp sơ̆ng buơl guñu lăm pà pluh hơrơi, sơ̆ng pơto-pơđăr buơl guñu tơgrơ̆ pơnuaĭ mư̆ng lơgăr Yàng Pô Lơngì. ");
INSERT INTO cje_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Lăm tŭ dò sơ̆ng du mơnih tơdi-tơdài, Pô đờm kơkơi-pơđăr buơl guñu: “Juơi tơbiă klàh mư̆ng plơi-prŏng Jerusalem, bloh păl dò tơ anih nư̆n c̆àng pơnuaĭ Pô Yàng Ama hũ pơguăn, la pơnuaĭ buơl guhã hũ mơhư̆ Kơu đờm. ");
INSERT INTO cje_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Kơyoa Jăng hũ ngă 'baptem sơ̆ng ia, bloh lăm sa-sĭt hơrơi tra, buơl guhã rơŭ hũ 'baptem sơ̆ng Yàng Bơngă Sơc̆ih-Sri.” ");
INSERT INTO cje_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Nư̆n, du mơnih dò pơtòm gơŭ tơ anih nư̆n đờm sơ̆ng Pô lài: “Khoai Yàng, hũ iơŭ lăm tŭ ni Yàng rơŭ pơtơgồ wơ̆ lơgăr Israel ơu?” ");
INSERT INTO cje_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Pô đờm sơ̆ng buơl guñu: “Hơrơi-tŭ sơ̆ng tŭ-jơ bloh Pô Yàng Ama hũ ngă-nìn tui gơnuăr Pô, nư̆n la bruă buơl guhã 'buh păl thơu. ");
INSERT INTO cje_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Bloh tŭ Yàng Bơngă Sơc̆ih-Sri trŭn tơ ngŏ buơl guhã, nư̆n buơl guhã rơŭ đồ-mă gơnăp-gơnuăr, sơ̆ng ngă grơh mư̆ng Kơu tơ plơi-prŏng Jerusalem, abih c̆àr Juđe, c̆àr Samari, tơ̆l truh tơ luĭ-dŭt boh tơnah.” ");
INSERT INTO cje_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Hơdơi tŭ đờm sơ̆ng buơl guñu du pơnuaĭ nư̆n, Pô hũ rò-đì tơ ngŏ lơngì lăm tŭ du mơnih tui-mơgru dò c̆ơ tui Pô. Hũ sa puk hwăl rò Pô tơrđơŭ thĭt, buơl guñu 'buh c̆ơ 'buh Pô tra. ");
INSERT INTO cje_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Sơ̆ng lăm tŭ buơl guñu dò nĭ-nùn c̆ơ tơ ngŏ lơngì tŭ Pô hũ rò-đì, nư̆n phŭ-phă hũ dua aràng mơnih lơkơi c̆ù ào kò tơbiă truh, dò dơ̆ng jĕ buơl guñu, ");
INSERT INTO cje_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","sơ̆ng đờm: “Ơ du mơnih Galile, kơđa hơgĕ buơl guhã sơđaŭ dò dơ̆ng c̆ơ mĭt tơ ngŏ lơngì yơu nư̆n? Yàng Jêsu ni hũ rò-đì tơ ngŏ lơngì mư̆ng tơkrah buơl guhã bơjơ, Pô kŭng rơŭ gài truh wơ̆ yơu pơnuaĭ buơl guhã hũ 'buh Pô đì tơ ngŏ lơngì rơi.” ");
INSERT INTO cje_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Hơdơi mư̆ng nư̆n, du mơnih tui-mơgru mư̆ng c̆ơ̆ angăn la Ôlibe gài mơrai wơ̆ tơ plơi-prŏng Jerusalem. C̆ơ̆ nư̆n dò jĕ sơ̆ng Jerusalem, mĭn atàh pơgăp kàr sa ơwĕt jơlàn hũ gơnuăr nau lăm hơrơi Sa'bat. ");
INSERT INTO cje_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Tŭ nau wơ̆ truh lăm plơi-prŏng, buơl guñu đì tơ sa boh adŭ tăl ngŏ sàng, la anih buơl guñu dò. Du mơnih nư̆n la Pier, Jăng, Jakơ, Andre, Philip, Thôma, 'Bathelemi, Mathiơ, Jakơ anà Alphe, Simôn Selôt, sơ̆ng Juđa anà Jakơ. ");
INSERT INTO cje_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Abih du mơnih nư̆n hũ kơjăp sa hơtai-hơtiàn, sa akŏ-sơnư̆ng sơ̆ng gơŭ bloh iơu-lài sơ̆ng du mơnih kơmơi, sơ̆ng Mari la ame Yàng Jêsu, găm sơ̆ng du adơi-ai Pô. ");
INSERT INTO cje_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Lăm du hơrơi nư̆n, Pier tơgồ dơ̆ng tơkrah du buơl adơi-ai — Hũ pơgăp sa rơtùh dua pluh aràng mơnih dò pơtòm-pơjŭm tơ anih nư̆n — bloh đờm lài: ");
INSERT INTO cje_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Ơ buơl adơi-ai, pơnuaĭ lăm 'Bồn Bơ-àr Sơc̆ih-Sri bloh Yàng Bơngă Sơc̆ih-Sri hũ gơnừm tơ kàng pơtau Đabit đờm hwơ̆r mư̆ng Juđa, la mơnih ba jơlàn tơ buơl mơnih truh mă Yàng Jêsu, păl hũ tơbiă iơŭ tơpă. ");
INSERT INTO cje_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Kơyoa ñu sơđaŭ la mơnih lăm tơrpuơl buơl gudrơi, sơ̆ng hũ pơ-ơnah lăm gơnuăr bruă ni. ");
INSERT INTO cje_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Ñu mă priă mơyòm-brơi mư̆ng glài-sơnoh drơi bloh blơi sa bĭ hơma, bloh nư̆n lơbuh pơc̆ơ̆ng akŏ trŭn, pơc̆ah tŭng, tơbiă pruaĭ tơ agàh bloh mơtai. ");
INSERT INTO cje_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Bruă nư̆n abih buơl làng lăm plơi-prŏng Jerusalem hũ thơu loh-làng, tơ̆l truh buơl guñu angăn hơma nư̆n la ‘Hakeldama,’ tui ia phŭn buơl guñu mơblàng la Hơma Drah. ");
INSERT INTO cje_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Kơyoa lăm 'bồn bơ-àr Pơđik Adoh Mơyòm kŭng hũ wă lài: ‘Lơkơu anih ñu dò tơbiă jiơ̆ng jơhua-ngơ̆t, Juơi aràng sơi dò tơ anih nư̆n.’ Sơ̆ng: ‘Lơkơu tơ hũ sa aràng mơnih pơkơ̆n đồ-mă gơnuăr bruă ñu.’ ");
INSERT INTO cje_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Yơu nư̆n, lăm du mơnih hũ dò sơ̆ng buơl gudrơi lăm luĭ hơrơi-tŭ Yàng Jêsu nau mơrai tơkrah buơl gudrơi, ");
INSERT INTO cje_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","mư̆ng Jăng ngă 'baptem tơ Pô tơ̆l truh tơ hơrơi Pô hũ rò-đì mư̆ng tơkrah buơl gudrơi, păl hũ sa aràng mơnih ngă grơh găm sơ̆ng buơl gudrơi mư̆ng pơnuaĭ Pô hơdiŭ wơ̆.” ");
INSERT INTO cje_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Du mơnih tui-mơgru rơwah-pồ dua aràng, sa aràng la Jôsep kŭng angăn la Barsaba, ñu kŭng hũ mơta pơkơ̆n la Justus, sơ̆ng mơnih dih la Mathia. ");
INSERT INTO cje_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Bloh nư̆n buơl guñu iơu-lài: “Khoai Yàng, Yàng la Pô thơu loh-làng lăm hơtai-hơtiàn abih tơgrơ̆ mơnih, yòng pơto brơi tơ buơl dơlhă thơu lăm dua aràng mơnih ni, aràng sơi la mơnih Yàng hũ rơwah, ");
INSERT INTO cje_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","tô hũ pơ-ơnah lăm gơnuăr bruă tơdi-tơdài, bloh Juđa hũ prah luơi tô nau tơma lăm anih pioh krơi tơ ñu.” ");
INSERT INTO cje_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Buơl guñu suă khà, iơŭ Mathia, nư̆n Mathia hũ rơwah pơtơma lăm tơrpuơl sa-pluh sa aràng mơnih tơdi-tơdài. ");
INSERT INTO cje_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Truh hơrơi pơjŭm 'bơ̆ng Pentikôt, abih du mơnih tui-mơgru Yàng pơtòm-pơjŭm gơŭ tơ sa anih. ");
INSERT INTO cje_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Phŭ-phă, hũ săp mư̆ng ngŏ lơngì trŭn, yơu săp rơbù blùh pràn biă, ŭr-ŭr tơma baŭ abih lăm sàng anih du mơnih tui-mơgru dò pơtòm-pơjŭm gơŭ. ");
INSERT INTO cje_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Du mơnih tui-mơgru 'buh du rơ̆p dơlah mơhiơ̆ yơu dơlah apui tơbiă truh, pơklah krơi sơ̆ng đơ̆m tơ ngŏ yàu aràng buơl guñu. ");
INSERT INTO cje_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Abih tơgrơ̆ mơnih hũ baŭ-bèng Yàng Bơngă Sơc̆ih-Sri, buơl guñu tơma đờm du ia pơkơ̆n, tui yơu Bơngă Sơc̆ih-Sri brơi buơl guñu đờm. ");
INSERT INTO cje_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Tŭ nư̆n, lăm plơi-prŏng Jerusalem, hũ du mơnih Juđa păng-duh Yàng Pô Lơngì, truh mư̆ng tơgrơ̆ buơl làng lăm dun-ya. ");
INSERT INTO cje_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Tŭ mơhư̆ săp nư̆n, buơl làng ba gơŭ đuaĭ truh, sơ̆ng buơl guñu krơi-takơtuă biă, kơyoa yàu aràng hũ mơhư̆ du mơnih tui-mơgru đờm ia phŭn drơi. ");
INSERT INTO cje_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Buơl guñu mă ngă c̆rih-takơtuă biă sơ̆ng đờm tơnia gơŭ: “Abih du mơnih dò đờm nư̆n 'buh iơŭ la mơnih Galile ơu? ");
INSERT INTO cje_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Nư̆n kơđa hơgĕ yàu aràng buơl gudrơi mơhư̆ buơl guñu đờm ia phŭn buơl gudrơi? ");
INSERT INTO cje_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Buơl gudrơi ni, hũ mơnih la buơl làng Pathe, Međi, Elamit, sơ̆ng du mơnih dò lăm Mesôpôtami, Juđe, Kapadôs, Pôntu, Asi, ");
INSERT INTO cje_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","hũ mơnih la buơl làng Phirigi, Pamphili, Ejiptơ, buơl làng c̆àr Libi jĕ Siren; du mơnih thuai truh mư̆ng Rôma, ");
INSERT INTO cje_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","găm mơnih Juđa halài mơnih buơl làng lơgăr agàh păng-tui jơlàn mơnih Juđa duh-dơlbăt, mơnih Kret sơ̆ng mơnih Arap rơi; abih buơl gudrơi hũ mơhư̆ buơl guñu angui ia phŭn buơl gudrơi bloh đờm mư̆ng du bruă gơnăp-gơnuăr Yàng Pô Lơngì.” ");
INSERT INTO cje_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Abih tơgrơ̆ mơnih mă ngă krơi-takơtuă sơ̆ng 'buh thơu sơnư̆ng hơyơu lơi, nư̆n đờm sơ̆ng gơŭ lài: “Bruă ni mơblàng la hơyơu?” ");
INSERT INTO cje_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Bloh hũ du mơnih pơkơ̆n klau-pơtăt, đờm lài: “Buơl guñu mơbŭ tơpai bơrhơu nư̆n.” ");
INSERT INTO cje_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Tŭ nư̆n, Pier dò dơ̆ng găm sơ̆ng sa-pluh sa aràng mơnih tơdi-tơdài, pồ săp đờm sơ̆ng buơl làng: “Ơ buơl adơi-ai la mơnih Juđa sơ̆ng abih du mơnih dò lăm Jerusalem. Yòng thơu loh-làng bĕ pơnuaĭ ni, sơ̆ng pơh tơnia păng pơnuaĭ dơlhă đờm: ");
INSERT INTO cje_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Du mơnih ni buh iơŭ mơbŭ ia tơpai yơu buơl adơi-ai sơnư̆ng ơu, kơyoa tŭ ni mĭn pơrpa sơlpăn jơ glai ờm. ");
INSERT INTO cje_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Bloh ni la pơnuaĭ mơnih gơnuăr-hwơ̆r Jôel hũ đờm: ");
INSERT INTO cje_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Yàng Pô Lơngì đờm: Lăm du hơrơi luĭ-dŭt, Kơu rơŭ tuh Bơngă Sơc̆ih-Sri Kơu tơ ngŏ tơgrơ̆ mơnih, Anà lơkơi sơ̆ng anà kơmơi buơl guhã rơŭ đờm hwơ̆r, Du lơkơi dăm rơŭ 'buh pơnuaĭ brơi pơ'buh, Sơ̆ng du mơnih tha rơŭ hũ pơnuaĭ lơpơi. ");
INSERT INTO cje_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Lăm du hơrơi nư̆n, Kơu rơŭ tuh Bơngă Sơc̆ih-Sri Kơu tơ ngŏ du mơnih hơlŭn-hơlă lơkơi sơ̆ng hơlŭn-hơlă kơmơi Kơu, Sơ̆ng buơl guñu rơŭ đờm hwơ̆r. ");
INSERT INTO cje_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Kơu rơŭ ngă du pơnuaĭ c̆rih-krơi tơ ngŏ lơngì, Sơ̆ng du nàl-krơi tơ ala lơ̆n; nư̆n la drah, apui, sơ̆ng joa asă, ");
INSERT INTO cje_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ia-hơrơi rơŭ tơbiă jiơ̆ng kơnăm-mơsrư̆, Ia-blàn rơŭ mơr-yah yơu drah, Dơlhơu tơ hơrơi prŏng sơ̆ng màng-kơc̆rà Yàng truh. ");
INSERT INTO cje_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Sơ̆ng aràng sơi iơu-lơkơu angăn Yàng nư̆n rơŭ hũ dŏng-pơklàh.’ ");
INSERT INTO cje_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Ơ gơŭ-găn jơi-pơtiàn Israel, yòng păng bĕ pơnuaĭ dơlhă đờm: Yàng Jêsu mơnih Nasaret, la Mơnih bloh Yàng Pô Lơngì hũ angui ngă du bruă gơnăp-gơnuăr, pơnuaĭ-c̆rih sơ̆ng nàl-krơi tơkrah buơl adơi-ai, tô ngă grơh tơ Pô tơ anaŭ buơl adơi-ai, yơu rùp-phŭn buơl adơi-ai hũ thơu loh-làng. ");
INSERT INTO cje_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Pô hũ kŏng pơblơ̆ jào tui pơnuaĭ Yàng Pô Lơngì hũ ngă-nìn sơ̆ng thơu dơlhơu, sơ̆ng buơl adơi-ai hũ jồm tơngàn mơnih mơsak-jơhà bloh pơ̆ng Pô tơ ngŏ kơyơu pơkăl sơ̆ng pơmơtai. ");
INSERT INTO cje_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Bloh Yàng Pô Lơngì hũ ngă tơ Pô hơdiŭ wơ̆, toh-tơleh Pô klàh mư̆ng pơnuaĭ pơđì-pơđoa pơnuaĭ mơtai, kơyoa pơnuaĭ mơtai 'buh rơgơi mă-pơkơŭ Pô jiơ̆ng. ");
INSERT INTO cje_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Kơyoa pơtau Đabit hũ đờm mư̆ng Pô lài: ‘Dơlhă jiăng mĭt 'buh Yàng dò tơ anaŭ dơlhă, Kơyoa Pô dò tơ gah hơnuă dơlhă, nư̆n dơlhă rơŭ 'buh kơđòng mơgơi-lơnggơh. ");
INSERT INTO cje_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Kơyoa nư̆n, hơtai-hơtiàn dơlhă sờh-sài, dơlah dơlhă sờh-sờr, Sơ̆ng rùp-phàp drah-rơlo dơlhă kŭng rơŭ dò-pơgleh lăm pơnuaĭ gơnừm-c̆àng. ");
INSERT INTO cje_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Kơyoa Yàng rơŭ 'buh luơi bơngă-joa dơlhă lăm anih mơnih mơtai dò, Kŭng 'buh luơi Pơtau Sơc̆ih-Sri Pô 'buh pơnuaĭ brŭ-brăm. ");
INSERT INTO cje_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Yàng hũ brơi dơlhă thơu jơlàn pơnuaĭ hơdiŭ, Kŭng rơŭ ngă tơ dơlhă baŭ-bèng pơnuaĭ sờh-sài tơ anaŭ Pô.’ ");
INSERT INTO cje_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Ơ buơl adơi-ai, dơlhă hũ rơgơi đờm nìn-kơjăp sơ̆ng buơl adơi-ai mư̆ng kơi-kŏ pàng-yau Đabit lài: ñu hũ mơtai sơ̆ng dơ̆r bơjơ, sơ̆ng kŭt-pơsàt ñu sơđaŭ dò tơkrah buơl gudrơi tơ̆l truh tơ hơrơi ni. ");
INSERT INTO cje_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Bloh kơyoa pơtau Đabit la sa aràng mơnih gơnuăr-hwơ̆r, sơ̆ng thơu Yàng Pô Lơngì hũ mă pơnuaĭ tơpah-sri bloh đờm pơguăn sơ̆ng pơtau lài Pô rơŭ daŭ sa aràng mơnih mư̆ng lăm jơi-pơtiàn pơtau dò guh tơ ngŏ sơbàn pơtau. ");
INSERT INTO cje_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Kơyoa nư̆n pơtau Đabit hũ 'buh dơlhơu sơ̆ng đờm mư̆ng pơnuaĭ Pô Krist hơdiŭ wơ̆ lài: Pô rơŭ 'buh kơđòng luơi lăm anih mơnih mơtai dò, sơ̆ng rùp-phàp Pô rơŭ 'buh păl kŏng brŭ-brăm. ");
INSERT INTO cje_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Yàng Pô Lơngì hũ ngă tơ Yàng Jêsu ni hơdiŭ wơ̆, sơ̆ng abih buơl dơlhă la du mơnih ngă grơh mư̆ng pơnuaĭ nư̆n. ");
INSERT INTO cje_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Yơu nư̆n, hơdơi tŭ Pô hũ rò đì dò tơ gah hơnuă Yàng Pô Lơngì, sơ̆ng hũ đồ-mă Yàng Bơngă Sơc̆ih-Sri bloh Pô Yàng Ama hũ pơguăn brơi, nư̆n Pô tuh Yàng Bơngă Sơc̆ih-Sri tơbiă, yơu buơl adơi-ai hũ 'buh sơ̆ng mơhư̆. ");
INSERT INTO cje_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Kơyoa pơtau Đabit ka tŭ lơi đì tơ ngŏ lơngì, bloh rùp-phŭn pơtau hũ đờm: ‘Yàng hũ đờm sơ̆ng Yàng dơlhă lài: Dò guh bĕ tơ gah hơnuă Kơu, ");
INSERT INTO cje_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Tơ̆l truh tơ tŭ lơi Kơu daŭ du mơnih mơbai-tămdră sơ̆ng Anà ngă gơnŭl juă tơ ala tơkai Anà.’ ");
INSERT INTO cje_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Kơyoa nư̆n, abih tơgrơ̆ mơnih Israel păl thơu nìn-kơjăp lài: Yàng Jêsu ni, la Pô bloh buơl adơi-ai hũ pơ̆ng tơ ngŏ kơyơu pơkăl, hũ Yàng Pô Lơngì pồ-pơđì ngă jiơ̆ng Yàng sơ̆ng Pô Krist.” ");
INSERT INTO cje_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Tŭ păng pơnuaĭ nư̆n, lăm hơtai-hơtiàn buơl guñu pơđì-pơđoa dơnuh-dơnà biă, nư̆n tơnia Pier sơ̆ng du mơnih tơdi-tơdài pơkơ̆n lài: “Ơ buơl sơ-ai, buơl dơlhă păl ngă hơyơu ni?” ");
INSERT INTO cje_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pier đờm sơ̆ng buơl guñu: “Buơl adơi-ai păl mơbai prah-luơi glài-sơnoh bĕ, yàu aràng păl mă angăn Yàng Jêsu bloh đồ-mă pơnuaĭ 'baptem tô hũ anĭt toh-luơi glài-sơnoh drơi, bloh nư̆n rơŭ đồ-mă hũ phơ̆n anĭt-brơi soh la Yàng Bơngă Sơc̆ih-Sri. ");
INSERT INTO cje_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Kơyoa pơnuaĭ đờm pơguăn nư̆n hũ pioh tơ buơl adơi-ai, tơ anà-tơc̆o buơl adơi-ai, sơ̆ng tơ abih tơgrơ̆ mơnih dò atàh, nư̆n la abih tơgrơ̆ mơnih bloh Yàng la Yàng Pô Lơngì buơl gudrơi rơŭ iơu rơwah.” ");
INSERT INTO cje_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pier kŭng angui lô pơnuaĭ pơkơ̆n wơ̆ tô ngă grơh sơ̆ng iơu-jà buơl guñu. Pier đờm: “Buơl adơi-ai păl dŏng bĕ rùp-phŭn drơi klàh mư̆ng jơi-pơtiàn mơsak-jơhà ni!” ");
INSERT INTO cje_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Yơu nư̆n, du mơnih păng-tui đồ-mă pơnuaĭ Pier đờm, đồ-mă pơnuaĭ 'baptem. Sơ̆ng lăm hơrơi nư̆n, hũ pơgăp klơu rơbơu aràng păng-tui Yàng. ");
INSERT INTO cje_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Du mơnih păng-tui Yàng kơjăp hơtai-hơtiàn păng-rơmiă ngă tui pơnuaĭ du mơnih tơdi-tơdài pơto-pơđăr, pơnuaĭ nau-mơrai sơ̆ng buơl adơi-ai, pơnuaĭ 'bĕt pah 'bơ̆ng sơdơ̆r Yàng, sơ̆ng pơnuaĭ iơu-lài. ");
INSERT INTO cje_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Abih tơgrơ̆ mơnih huơĭ-kơđa, kơyoa hũ lô pơnuaĭ-c̆rih nàl-krơi hũ ngă tơbiă mư̆ng du mơnih tơdi-tơdài. ");
INSERT INTO cje_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Abih tơgrơ̆ mơnih păng-tui Yàng hũ sa hơtai-hơtiàn sơ̆ng gơŭ, mă abih tơgrơ̆ phơ̆n drơi hũ ngă jiơ̆ng phơ̆n găm sơ̆ng gơŭ. ");
INSERT INTO cje_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Buơl guñu pơblơi phŭm-kơsai phơ̆n-bơna drơi hũ, bloh nư̆n pơrpha brơi tơ gơŭ, tui yơu pơnuaĭ yàu aràng păl hũ tô angui 'bơ̆ng. ");
INSERT INTO cje_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Hơrơi lơi buơl guñu kŭng abih hơtai-hơtiàn truh tơ sàng duh-dơlbăt; sơ̆ng mư̆ng sàng ni truh sàng pơkơ̆n, buơl guñu 'bĕt pah sơ̆ng huă 'bơ̆ng găm sơ̆ng gơŭ sơ̆ng hơtai-hơtiàn sờh-sài, tơpă-tơpe. ");
INSERT INTO cje_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Buơl guñu adoh-mơyòm Yàng Pô Lơngì sơ̆ng hũ siàm hơtai abih tơgrơ̆ mơnih. Yàu hơrơi, Yàng brơi lô mơnih rơlau hũ dŏng-pơklàh tơma lăm Tơrpuơl Goh-Sơc̆ih. ");
INSERT INTO cje_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Sa hơrơi dih, Pier sơ̆ng Jăng đì tơ sàng duh-dơlbăt lăm jơ iơu-lài tŭ klơu jơ diơŭ. ");
INSERT INTO cje_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Hũ sa aràng mơnih joh mư̆ng tŭ tơbiă mư̆ng tŭng ame, yàu hơrơi hũ aràng ba truh daŭ tơ anih bơh 'băng sàng duh-dơlbăt, angăn la Bơh 'Băng Mơkrư, tô yòng priă sơ̆ng du mơnih nau tơma lăm sàng duh-dơlbăt. ");
INSERT INTO cje_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Tŭ 'buh Pier sơ̆ng Jăng nau tơma lăm sàng duh-dơlbăt, ñu yòng dua aràng brơi-soh tơ ñu sa-sĭt phơ̆n priă. ");
INSERT INTO cje_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pier sơ̆ng Jăng c̆ơ tơpă tơ ñu bloh nư̆n đờm: “C̆ơ bĕ tơ buơl dơlhă!” ");
INSERT INTO cje_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ñu c̆ơ nĭ-nùn tơ dua aràng, sơnư̆ng lài rơŭ đồ-mă hũ sa-sĭt phơ̆n hơgĕ. ");
INSERT INTO cje_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Bloh Pier đờm sơ̆ng ñu: “Dơlhă 'buh hũ mừh priă ơu, bloh pơnuaĭ dơlhă hũ nư̆n dơlhă brơi tơ sơ-ai: Mă angăn Yàng Jêsu Krist mơnih Nasaret, tơgồ dơ̆ng bĕ bloh nau!” ");
INSERT INTO cje_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Pier apăn tơ tơngàn gah hơnuă ñu sơ̆ng đơ̆ng ñu tơgồ. Lăm tơk tŭ nư̆n mư, dua gah plà tơkai sơ̆ng tơlàng mơta-akàn ñu tơbiă jiơ̆ng khăng-pràn. ");
INSERT INTO cje_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ñu tơgồ sừp mư, dò dơ̆ng tơpă sơ̆ng nau tơma lăm sàng duh-dơlbăt găm sơ̆ng dua aràng mơnih tơdi-tơdài. Nau găm kơsĕt-mơya găm sơ̆ng adoh-mơyòm Yàng Pô Lơngì. ");
INSERT INTO cje_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Tŭ abih buơl làng 'buh ñu nau găm adoh-mơyòm Yàng Pô Lơngì găm, ");
INSERT INTO cje_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","sơ̆ng kràn-thơu rùp-phŭn ñu la mơnih sơđaŭ dò guh yòng brơi-soh tơ gah Bơh 'Băng Mơkrư anih sàng duh-dơlbăt, nư̆n mă ngă c̆rih-takơtuă biă mư̆ng bruă hũ tơbiă truh tơ ñu. ");
INSERT INTO cje_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Lăm tŭ ñu sơđaŭ dò apăn kơjăp tơ tơngàn Pier sơ̆ng Jăng, nư̆n abih buơl làng mă ngă c̆rih-takơtuă biă, ba gơŭ đuaĭ truh sơ̆ng buơl guñu tơ anih angăn la sơndờp bơh 'băng Salômôn. ");
INSERT INTO cje_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","'Buh yơu nư̆n, Pier đờm sơ̆ng buơl làng: “Ơ adơi-ai jơi-pơtiàn Israel, kơđa hơgĕ buơl adơi-ai mă ngă c̆rih-takơtuă mư̆ng bruă ni? Kơđa hơgĕ buơl adơi-ai c̆ơ nĭ-nùn tơ buơl dơlhă, ngă yơu buơl dơlhă hũ gơnừm tơ gơnăp-gơnuăr halài hơtai-hơtiàn tơpă-siàm rùp-phŭn drơi, bloh ngă tơ mơnih joh ni nau jiơ̆ng? ");
INSERT INTO cje_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Yàng Pô Lơngì Abraham, Isak sơ̆ng Jakôp, Yàng Pô Lơngì kơi-kŏ pàng-yau buơl gudrơi hũ ngă màng-kơc̆rà mơnih duh bruă Pô la Yàng Jêsu, Pô bloh buơl adơi-ai hũ mă jào sơ̆ng kơmlah-luơi tơ anaŭ Pilat lăm tŭ ñu hũ hơtai khiăng toh-tơleh tơ Pô. ");
INSERT INTO cje_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Buơl adơi-ai hũ kơmlah-luơi Pô Sơc̆ih-Sri sơ̆ng Pô Rĭng-Tơpă, bloh yòng toh-tơleh tơ drơi sa aràng mơnih pơmơtai mơnih. ");
INSERT INTO cje_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Buơl adơi-ai hũ pơmơtai Yàng pơnuaĭ hơdiŭ, bloh Yàng Pô Lơngì hũ ngă tơ Pô hơdiŭ wơ̆ mư̆ng pơnuaĭ mơtai, sơ̆ng buơl dơlhă la du mơnih ngă grơh tơ pơnuaĭ nư̆n. ");
INSERT INTO cje_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Kơyoa pơnuaĭ păng-tui lăm angăn Pô, la angăn hũ ngă tơ mơnih ni, mơnih bloh buơl adơi-ai hũ 'buh sơ̆ng thơu ni hũ pràn-khăng. Rùp-phŭn angăn Pô sơ̆ng pơnuaĭ păng-tui lăm anih Pô hũ ngă tơ mơnih ni pràn-khăng wĭl-tơ̆l, yơu abih buơl adơi-ai hũ 'buh. ");
INSERT INTO cje_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Ơ buơl adơi-ai, tŭ ni dơlhă thơu buơl adơi-ai sơ̆ng du mơnih apăn-akŏ buơl adơi-ai hũ ngă pơnuaĭ nư̆n kơyoa siơŭ pơnuaĭ wờng thơu. ");
INSERT INTO cje_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Bloh Yàng Pô Lơngì hũ angui pơnuaĭ nư̆n tô ngă iơŭ tơpă pơnuaĭ Pô hũ angui kàng du mơnih gơnuăr-hwơ̆r bloh đờm pơthơu dơlhơu lài Pơtau Krist Pô păl kŏng pơđì-pơđoa gleh-glăr. ");
INSERT INTO cje_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Yơu nư̆n, buơl adơi-ai păl mơbai prah-luơi glài-sơnoh bĕ, gài mơrai wơ̆ sơ̆ng Yàng Pô Lơngì tô pơnuaĭ glài-sơnoh drơi hũ anĭt toh-luơi, ");
INSERT INTO cje_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","tô du tŭ-hơrơi lơngai-siàm bloh Yàng brơi tơ buơl adơi-ai rơŭ truh, tô Pô hũ rơgơi pơđăr Pô Krist, nư̆n la Yàng Jêsu, Pô hũ ngă-nìn mư̆ng dơlhơu, truh sơ̆ng buơl adơi-ai. ");
INSERT INTO cje_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Pô nư̆n păl hũ rò nau wơ̆ tơ ngŏ lơngì tơ̆l truh tơ tŭ-hơrơi abih tơgrơ̆ jơi-phơ̆n pơsơlih bơrhơu, la tŭ-hơrơi Yàng Pô Lơngì hũ angui kàng-bơbah du mơnih gơnuăr-hwơ̆r sơc̆ih-sri Pô bloh đờm pơthơu dơlhơu mư̆ng yau thrơi. ");
INSERT INTO cje_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Biă yơu nư̆n, Môise hũ đờm: ‘Yàng la Yàng Pô Lơngì buơl gudrơi rơŭ pơtơgồ mư̆ng tơkrah adơi-ai buơl guhã sa Pô gơnuăr-hwơ̆r yơu dơlhă, sơ̆ng buơl guhã păl păng ngă tui abih tơgrơ̆ pơnuaĭ Pô đờm pơđăr. ");
INSERT INTO cje_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Yah aràng sơi 'buh păng Pô gơnuăr-hwơ̆r nư̆n rơŭ kŏng pơluĭ-pơlơhiă klàh mư̆ng buơl làng.’ ");
INSERT INTO cje_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Abih du mơnih gơnuăr-hwơ̆r, mư̆ng Samuel tơ̆l truh tơ du mơnih gơnuăr-hwơ̆r hơdơi, tŭ đờm hwơ̆r kŭng hũ đờm brơi pơthơu mư̆ng du hơrơi ni. ");
INSERT INTO cje_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Buơl adơi-ai la anà-tơc̆o du mơnih gơnuăr-hwơ̆r sơ̆ng pơnuaĭ pơguăn-pơđoàn bloh Yàng Pô Lơngì hũ ngă tơbiă sơ̆ng kơi-kŏ pàng-yau buơl gudrơi, tŭ Pô đờm sơ̆ng Abraham: ‘Tơgrơ̆ buơl làng lăm dun-ya rơŭ gơnừm tơ jơi-pơtiàn anà bloh hũ pơnuaĭ lơngai-pơtuah.’ ");
INSERT INTO cje_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Yàng Pô Lơngì hũ pồ-pơđăr Mơnih Hơlŭn-Hơlă Pô, sơ̆ng pơđăr Pô truh brơi pơnuaĭ lơngai-pơtuah tơ buơl adơi-ai dơlhơu, sơ̆ng bruă ngă tơ yàu aràng lăm buơl adơi-ai prah-luơi du jơlàn-sơnah mơsak-jơhà drơi.” ");
INSERT INTO cje_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Lăm tŭ Pier sơ̆ng Jăng dò đờm sơ̆ng buơl làng, nư̆n du mơnih gơnuăr pơyă phơ̆n duh-dơlbăt, mơnih apăn-akŏ lĭng gàr-c̆ơ sàng duh-dơlbăt, sơ̆ng du mơnih Sađuse ba gơŭ truh. ");
INSERT INTO cje_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Buơl guñu anok hơtai biă, kơyoa Pier sơ̆ng Jăng hũ pơto-pơsài tơ buơl làng sơ̆ng đờm pơto-akhàn lài Yàng Jêsu hũ hơdiŭ wơ̆, kơyoa nư̆n mơnih mơtai bơjơ kŭng rơŭ hơdiŭ wơ̆. ");
INSERT INTO cje_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Buơl guñu mă Pier sơ̆ng Jăng krơ̆ lăm sàng jàm tơ̆l truh tơ hơrơi hơdơi, kơyoa tŭ nư̆n lơngì tơma mơlăm bơjơ. ");
INSERT INTO cje_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Bloh yah yơu nư̆n, lô mơnih hũ mơhư̆ pơnuaĭ Pier sơ̆ng Jăng pơto-akhàn nư̆n păng-tui, sơ̆ng mĭn khà mơnih lơkơi păng-tui soh đì truh pơgăp lơma rơbơu aràng. ");
INSERT INTO cje_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Hơrơi hơdơi, du mơnih gơnuăr apăn-akŏ buơl làng Juđa, du mơnih gơnuăr-tha sơ̆ng du mơnih gơnuăr-pơto pơnuaĭ adăt-adia, pơgùm-pơtòm gơŭ lăm Jerusalem, ");
INSERT INTO cje_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","găm sơ̆ng Anne, la mơnih gơnuăr prŏng apăn-akŏ pơyă phơ̆n duh-dơlbăt, Kaiphe, Jăng, Aleksandrơ, sơ̆ng abih du mơnih lăm sàng-dơnò mơnih gơnuăr prŏng apăn-akŏ pơyă phơ̆n duh-dơlbăt. ");
INSERT INTO cje_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Buơl guñu mă Pier sơ̆ng Jăng truh dò dơ̆ng tơkrah buơl guñu sơ̆ng tơnia khào: “Gơnừm tơ gơnăp-gơnuăr lơi halài mă angăn aràng sơi bloh buơl guhã ngă pơnuaĭ ni?” ");
INSERT INTO cje_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Tŭ nư̆n Pier, hũ baŭ-bèng Yàng Bơngă Sơc̆ih-Sri, đờm lài: “Ơ du mơnih gơnuăr apăn-akŏ buơl làng sơ̆ng du mơnih gơnuăr-tha! ");
INSERT INTO cje_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Yah hơrơi ni buơl dơlhă kơđòng tơnia-khào kơyoa sa bruă siàm hũ ngă tơ sa aràng mơnih joh-je, mư̆ng pơnuaĭ hơyơu mơnih nư̆n hũ pơsồ-pơsaih, ");
INSERT INTO cje_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","nư̆n yòng abih buơl kơi sơ̆ng abih buơl làng Israel thơu bĕ lài: gơnừm tơ angăn Yàng Jêsu Krist mơnih Nasaret, Pô bloh buơl kơi hũ pơ̆ng tơ kơyơu pơkăl, sơ̆ng Yàng Pô Lơngì hũ ngă hơdiŭ wơ̆ mư̆ng pơnuaĭ mơtai, nư̆n la gơnừm tơ Pô bloh mơnih ni hũ pơsồ-pơsaih sơ̆ng tŭ ni dò dơ̆ng tơ anaŭ buơl kơi. ");
INSERT INTO cje_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yàng Jêsu ni la boh pơtơu bloh buơl kơi la du mơnih khờh bơ̆-ngă sàng, prah-luơi, Bloh hũ tơbiă jiơ̆ng boh pơtơu akiăng sàng. ");
INSERT INTO cje_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","'Buh hũ pơnuaĭ dŏng-pơklàh lăm pô lơi pơkơ̆n, kơyoa tơ ala lơngì, 'buh hũ angăn lơi pơkơ̆n brơi tơ jơi anà mơnih, tô buơl gudrơi gơnừm tơ angăn nư̆n bloh hũ dŏng-pơklàh.” ");
INSERT INTO cje_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Tŭ buơl guñu 'buh pơnuaĭ hĭl-pràn Pier sơ̆ng Jăng, sơ̆ng thơu loh-làng dua aràng la du mơnih bơhiàn soh, 'buh hũ mơgru lô, nư̆n buơl guñu mă ngă krơi-takơtuă biă. Buơl guñu kŭng kràn thơu Pier sơ̆ng Jăng la du mơnih mư̆ng dơlhơu hũ dò sơ̆ng Yàng Jêsu. ");
INSERT INTO cje_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Bloh kơyoa 'buh mơnih joh hũ pơsồ-pơsaih dò dơ̆ng jĕ gah dua aràng mơnih tơdi-tơdài, nư̆n buơl guñu 'buh thơu đờm sơđồ wơ̆ hơyơu lơi. ");
INSERT INTO cje_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Hơdơi tŭ pơđăr Pier sơ̆ng Jăng tơbiă mư̆ng anih adŭ Tơrpuơl Gơnuăr Apăn-Akŏ Buơl Làng Juđa pơgùm-pơtòm, buơl guñu tămbơyai sơ̆ng gơŭ ");
INSERT INTO cje_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","lài: “Buơl gudrơi păl ngă hơyơu sơ̆ng du mơnih ni? Kơyoa abih buơl làng lăm Jerusalem hũ thơu loh-làng biă la buơl guñu hũ ngă sa pơnuaĭ c̆rih-krơi, sơ̆ng buơl gudrơi 'buh rơgơi đờm kơmlah jiơ̆ng. ");
INSERT INTO cje_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Bloh tô bruă ni 'buh hũ đờm ba pơtiơ̆ng prŏng-lơnàng rơlau lăm buơl làng, buơl gudrơi păl đờm pơkơŭ-pơhuơĭ buơl guñu, 'buh brơi gơnuăr buơl guñu đờm truh angăn nư̆n sơ̆ng aràng sơi tra.” ");
INSERT INTO cje_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Yơu nư̆n, buơl guñu iơu Pier sơ̆ng Jăng tơma, sơ̆ng pơkơŭ dua aràng buơl guñu 'buh brơi mă angăn Yàng Jêsu bloh đờm halài pơto tra. ");
INSERT INTO cje_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Bloh Pier sơ̆ng Jăng đờm sơđồ: “Yòng buơl kơi c̆ơ-sơnư̆ng bĕ, hơyơu la iơŭ, tơ anaŭ Yàng Pô Lơngì, buơl dơlhă păl păng bơbah buơl kơi rơlau la păng bơbah Yàng Pô Lơngì? ");
INSERT INTO cje_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Kơyoa buơl dơlhă 'buh rơgơi 'buh đờm mư̆ng tơgrơ̆ pơnuaĭ buơl dơlhă hũ 'buh sơ̆ng păng.” ");
INSERT INTO cje_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Hơdơi tŭ đờm pơhuơĭ sa amăng tra wơ̆, buơl guñu toh-tơleh brơi Pier sơ̆ng Jăng tơbiă, kơyoa buơl guñu 'buh duah hũ pơnuaĭ hơgĕ tô ngă glài Pier sơ̆ng Jăng, sơ̆ng kŭng kơyoa buơl guñu huơĭ tơ buơl làng rơi. Kơyoa abih buơl làng, aràng sơi aràng nư̆n kŭng mơyòm-pơglòng Yàng Pô Lơngì mư̆ng bruă hũ tơbiă truh. ");
INSERT INTO cje_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Mơnih lơkơi hũ pơnuaĭ c̆rih-krơi pơsồ-pơsaih nư̆n, la mơnih rơlau pà pluh thŭn bơjơ. ");
INSERT INTO cje_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Hơdơi tŭ hũ toh-tơleh, Pier sơ̆ng Jăng truh sơ̆ng buơl adơi-ai drơi, đờm-akhàn wơ̆ mư̆ng abih tơgrơ̆ pơnuaĭ du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt sơ̆ng du mơnih gơnuăr-tha hũ đờm. ");
INSERT INTO cje_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Tŭ mơhư̆ yơu nư̆n, abih tơgrơ̆ aràng sa hơtai sơgơŭ pồ-săp iơu-lài sơ̆ng Yàng Pô Lơngì lài: “Khoai Yàng, la Pô c̆rơ̆ng-tơbiă lơngì, lơ̆n-tơnah, ia-tơsì, găm sơ̆ng abih tơgrơ̆ jơi-phơ̆n lăm nư̆n. ");
INSERT INTO cje_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Rùp-phŭn Pô hũ gơnừm Yàng Bơngă Sơc̆ih-Sri, angui kàng-bơbah kơi-kŏ pàng-yau buơl dơlhă la Đabit, mơnih duh bruă Pô, bloh đờm: ‘Kơyoa hơgĕ du buơl làng anok hơtai, Sơ̆ng kơyoa hơgĕ du lơgăr duah bơyai-rơc̆ăng pơnuaĭ 'buh kwơ-màng? ");
INSERT INTO cje_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Du pơtau lăm dun-ya đì-tơgồ, Du gơnuăr apăn-akŏ pơtòm-pơjŭm gơŭ wơ̆, Bloh tămdră-wơ̆ sơ̆ng Yàng sơ̆ng Pô Krist Pô.’ ");
INSERT INTO cje_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Biă yơu nư̆n, Herôt sơ̆ng 'Bônsơ Pilat, găm sơ̆ng du buơl làng agàh sơ̆ng buơl làng Israel, hũ pơgùm-pơtòm gơŭ lăm plơi-prŏng ni tô tămdră-wơ̆ sơ̆ng Mơnih Hơlŭn-Hơlă sơc̆ih-sri Pô la Yàng Jêsu, Pô bloh Yàng hũ lŭ mơñà, ");
INSERT INTO cje_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","tô ngă tơgrơ̆ bruă kơyoa tơngàn Pô sơ̆ng hơtai-khiăng Pô hũ ngă-nìn dơlhơu. ");
INSERT INTO cje_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Tŭ ni, ơ Yàng, yòng Yàng c̆ơ truh du pơnuaĭ buơl guñu pơkơŭ-pơhuơĭ, sơ̆ng yòng brơi tơ du mơnih hơlŭn-hơlă Pô hũ hĭl-pràn hơtai-hơtiàn pơto-akhàn pơnuaĭ Pô. ");
INSERT INTO cje_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Yòng yơ̆r tơngàn Pô tơbiă tô pơsồ-pơsaih lơ-ơ̆n lơngoh rơwă-sơkì, sơ̆ng ngă du pơnuaĭ-c̆rih nàl-krơi lăm angăn Mơnih Hơlŭn-Hơlă sơc̆ih-sri Pô, la Yàng Jêsu.” ");
INSERT INTO cje_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Hơdơi tŭ buơl guñu iơu-lài, nư̆n anih buơl guñu pơtòm-pơjŭm mơgơi-lơnggơ̆r, abih tơgrơ̆ mơnih hũ baŭ-bèng Yàng Bơngă Sơc̆ih-Sri, sơ̆ng hĭl-pràn hơtai-hơtiàn pơto-akhàn pơnuaĭ Yàng Pô Lơngì. ");
INSERT INTO cje_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Tŭ nư̆n, abih tơgrơ̆ mơnih păng-tui Yàng hũ sa hơtai-hơtiàn sa akŏ sơnư̆ng sơ̆ng gơŭ, 'buh hũ aràng sơi c̆ơ phơ̆n-bơna drơi hũ la phơ̆n krơi, bloh c̆ơ kơrhia abih tơgrơ̆ phơ̆n la phơ̆n găm sơ̆ng gơŭ. ");
INSERT INTO cje_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Du mơnih tơdi-tơdài mă gơnăp-gơnuăr prŏng bloh ngă grơh mư̆ng pơnuaĭ hơdiŭ wơ̆ Yàng Jêsu, sơ̆ng Pô tuh pơnuaĭ anĭt-brơi-soh dơlah-dơlài tơ ngŏ buơl guñu. ");
INSERT INTO cje_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Kơyoa nư̆n, lăm tơkrah du mơnih păng-tui 'buh hũ aràng sơi siơŭ-kơđòng hơgĕ, kơyoa du mơnih hũ hơma-tơnah halài sàng-dơnò, mă pơblơi abih, sơ̆ng apăn priă pơblơi hũ, ");
INSERT INTO cje_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","daŭ tơ ala tơkai du mơnih tơdi-tơdài. Priă nư̆n hũ pơrpha tơ yàu aràng tui yơu pơnuaĭ yàu aràng c̆àng păl hũ tô angui 'bơ̆ng. ");
INSERT INTO cje_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Jôsep, mơnih bloh du mơnih tơdi-tơdài pơ-angăn la 'Banaba, mơblàng la “anà lơkơi pơnuaĭ pơluơ-pơrơngài,” dò lăm jơi-pơtiàn Lebi, plơi tơ C̆iprơ, ");
INSERT INTO cje_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","hũ sa bĭ hơma, ñu pơblơi hơma nư̆n, mă priă apăn daŭ tơ anih tơkai du mơnih tơdi-tơdài. ");
INSERT INTO cje_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Bloh hũ sa aràng mơnih angăn la Anania, găm sơ̆ng sơdiŭ la Sapira, pơblơi hơma tơnah drơi. ");
INSERT INTO cje_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ñu sa hơtai sơ̆ng sơdiŭ, mă pioh wơ̆ sa pơ-ơnah priă pơblơi hũ, bloh nư̆n apăn pơ-ơnah priă dò wơ̆ daŭ tơ tơkai du mơnih tơdi-tơdài. ");
INSERT INTO cje_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pier đờm: “Ni Anania! Kơyoa hơgĕ sơ-ai luơi kơmlài Satăn dò baŭ-bèng lăm hơtai-hơtiàn sơ-ai, tơ̆l truh sơ-ai đờm lơ̆r sơ̆ng Yàng Bơngă Sơc̆ih-Sri, bloh mă pioh wơ̆ sa pơ-ơnah priă pơblơi hơma nư̆n? ");
INSERT INTO cje_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Tŭ sơ-ai ka pơblơi hơma nư̆n, ñu 'buh iơŭ la hơma sơ-ai ơu? Tŭ pơblơi bơjơ, nư̆n sơ-ai 'buh hũ gơnuăr angui priă nư̆n ơu? Kơđa hơgĕ lăm hơtai-hơtiàn sơ-ai sơnư̆ng-bơyai bruă yơu nư̆n? 'Buh iơŭ sơ-ai đờm lơ̆r sơ̆ng anà mơnih ơu bloh la đờm lơ̆r sơ̆ng Yàng Pô Lơngì.” ");
INSERT INTO cje_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Păng du pơnuaĭ nư̆n, Anania lơbuh tơ ala sơ̆ng kloh suàn. Abih tơgrơ̆ mơnih mơhư̆ pơnuaĭ nư̆n mă ngă huơĭ-kơđa biă. ");
INSERT INTO cje_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Du mơnih dăm tơgồ dơ̆ng pơpò atơu Anania, bloh nư̆n sơkồng nau dơ̆r. ");
INSERT INTO cje_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Pơgăp klơu jơ hơdơi, sơdiŭ Anania nau tơma bloh ka hũ thơu mư̆ng bruă pơrpa tơbiă truh. ");
INSERT INTO cje_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pier đờm sơ̆ng ñu: “Đờm bĕ tơ dơlhă thơu, hũ iơŭ sơ-ai pơblơi bĭ hơma mĭn kàr nư̆n priă soh?” Ñu đờm: “Hơ, mĭn hũ kàr nư̆n soh.” ");
INSERT INTO cje_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pier đờm: “Kơđa hơgĕ sơdiŭ pơsàng guhã khĭn sa hơtai-hơtiàn sơ̆ng gơŭ tô lòng Bơngă Sơc̆ih-Sri Yàng? Dih, tơkai du mơnih nau dơ̆r pơsàng sơ-ai mơrai wơ̆ truh tơ bơh 'băng bơjơ, buơl guñu kŭng rơŭ sơkồng sơ-ai nau rơi.” ");
INSERT INTO cje_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Lăm tơk tŭ nư̆n mư, ñu lơbuh tơ tơkai Pier sơ̆ng kloh suàn. Du mơnih dăm nau tơma, 'buh ñu mơtai bơjơ, nư̆n sơkồng nau dơ̆r jĕ gah pơsàng ñu. ");
INSERT INTO cje_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Abih Tơrpuơl Goh-Sơc̆ih sơ̆ng abih tơgrơ̆ mơnih mơhư̆ mư̆ng bruă ni, aràng sơi aràng nư̆n kŭng huơĭ-kơđa biă. ");
INSERT INTO cje_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Tŭ nư̆n, hũ lô pơnuaĭ-c̆rih nàl-krơi hũ ngă tơbiă tơkrah buơl làng gơnừm tơ tơngàn du mơnih tơdi-tơdài. Abih tơgrơ̆ mơnih păng-tui Yàng hũ sa hơtai-hơtiàn pơtòm-pơjŭm sơ̆ng gơŭ tơ ala sơndờp bơh 'băng Salômôn. ");
INSERT INTO cje_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","'Buh sa aràng mơnih lơi pơkơ̆n khĭn tơma lăm tơrpuơl buơl guñu, bloh buơl làng nư̆n mơyòm tơ buơl guñu biă. ");
INSERT INTO cje_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Mơnih păng-tui Yàng 'brŏ hơrơi 'brŏ hũ lô, găm mơnih lơkơi găm mơnih kơmơi lô biă, ");
INSERT INTO cje_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","tơ̆l truh aràng păl sơkồng du mơnih lơ-ơ̆n lơngoh rơwă-sơkì daŭ tơ jơlàn, brơi pơđih lăm c̆ơnừng tìt halài lăm c̆iau, tô tŭ Pier nau găn, lơhui bơngă ñu tơkì biă kŭng hũ jơ̆m-lơhui tơ ngŏ dua klơu aràng mơnih lơ-ơ̆n lơngoh rơwă-sơkì rơi. ");
INSERT INTO cje_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Buơl làng dò lăm du plơi-prŏng tòmdăr Jerusalem kŭng ŭr-ŭr ba du mơnih lơ-ơ̆n lơngoh rơwă-sơkì sơ̆ng du mơnih kơđòng kơmlài ngă truh, sơ̆ng abih tơgrơ̆ mơnih hũ pơsồ-pơsaih abih. ");
INSERT INTO cje_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Tŭ nư̆n, mơnih gơnuăr prŏng apăn-akŏ pơyă phơ̆n duh-dơlbăt sơ̆ng du mơnih tui ñu, nư̆n la tơrpuơl Sađuse, tơgồ dơ̆ng sơ̆ng hơtai-hơtiàn baŭ-bèng pơnuaĭ oàn-mơbai, ");
INSERT INTO cje_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","mă du mơnih tơdi-tơdài krơ̆ lăm sàng jàm. ");
INSERT INTO cje_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Bloh lăm glai mơlăm, hũ sa aràng mơnih gơdrưh Yàng truh pơh bơh 'băng sàng jàm, ba buơl guñu tơbiă tơ agàh, sơ̆ng đờm kơkơi: ");
INSERT INTO cje_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Nau bĕ, dò dơ̆ng tơ anih sàng duh-dơlbăt bloh đờm pơto-akhàn tơ buơl làng du pơnuaĭ brơi pơnuaĭ hơdiŭ.” ");
INSERT INTO cje_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Mơhư̆ yơu nư̆n, du mơnih tơdi-tơdài nau tơma lăm sàng duh-dơlbăt mư̆ng tŭ pơrpa rìng ờm, sơ̆ng tơma pơto-akhàn tơ buơl làng. Tŭ mơnih gơnuăr prŏng apăn-akŏ pơyă phơ̆n duh-dơlbăt sơ̆ng du mơnih tui ñu truh, buơl guñu pơgùm-pơtòm Tơrpuơl Gơnuăr Apăn-Akŏ Buơl Làng găm sơ̆ng abih du mơnih gơnuăr-tha lăm buơl làng Israel wơ̆, bloh nư̆n pơđăr mơnih tơma lăm sàng jàm tô ba du mơnih tơdi-tơdài truh. ");
INSERT INTO cje_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Bloh tŭ du mơnih lĭng khiă-gàr sàng duh-dơlbăt truh tơ anih nư̆n, buơl guñu 'bu 'buh hũ mơnih tơdi-tơdài lơi lăm sàng jàm, nư̆n buơl guñu gài mơrai đờm akhàn wơ̆: ");
INSERT INTO cje_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Buơl dơlhă 'buh sàng jàm hũ kăl-kơdrơ̆ nĭ-nùn biă, du mơnih lĭng khiă-gàr dò dơ̆ng tơ anaŭ bơh 'băng, bloh tŭ pơh bơh 'băng tơbiă, buơl dơlhă 'bu 'buh mơnih lơi lăm dơrlăm nư̆n ơu.” ");
INSERT INTO cje_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Mơhư̆ du pơnuaĭ nư̆n, mơnih gơnuăr apăn-akŏ lĭng khiă-gàr sàng duh-dơlbăt sơ̆ng du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt 'buh thơu sơnư̆ng hơyơu lơi mư̆ng du mơnih tơdi-tơdài, 'buh thơu pơnuaĭ hơgĕ rơŭ tơbiă truh. ");
INSERT INTO cje_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Bloh hũ mơnih truh đờm akhàn sơ̆ng buơl guñu lài: “Dih, du mơnih bloh buơl kơi hũ mă jàm, tŭ ni dò dơ̆ng lăm anih sàng duh-dơlbăt sơ̆ng pơto-mơblàng tơ buơl làng.” ");
INSERT INTO cje_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Mơnih gơnuăr apăn-akŏ lĭng khiă-gàr sàng duh-dơlbăt găm sơ̆ng du mơnih lĭng nau truh anih sơ̆ng mă du mơnih tơdi-tơdài ba nau, bloh 'buh khĭn angui pơnuaĭ pràn-mơsak, kơyoa buơl guñu huơĭ kơđòng buơl làng prah pơtơu. ");
INSERT INTO cje_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Buơl guñu ba du mơnih tơdi-tơdài nau sơ̆ng ba truh tơ anaŭ Tơrpuơl Gơnuăr Apăn-Akŏ Buơl Làng. Mơnih gơnuăr prŏng apăn-akŏ pơyă phơ̆n duh-dơlbăt tơnia du mơnih tơdi-tơdài: ");
INSERT INTO cje_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Buơl kơu hũ đờm pơkơŭ buơl sơ-ai bơjơ, 'buh brơi mă angăn nư̆n bloh pơto-akhàn, nư̆n bloh buơl sơ-ai ngă tơ Jerusalem baŭ-bèng du pơnuaĭ pơto-mơblàng buơl sơ-ai soh. Buơl sơ-ai khiăng ngă tơ drah Mơnih nư̆n tuh wơ̆ tơ ngŏ akŏ buơl kơu?” ");
INSERT INTO cje_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pier sơ̆ng du mơnih tơdi-tơdài đờm sơđồ: “Buơl dơlhă păl păng-bơbah Yàng Pô Lơngì rơlau la păng-bơbah anà mơnih! ");
INSERT INTO cje_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Yàng Pô Lơngì kơi-kŏ pàng-yau buơl gudrơi hũ ngă tơ Yàng Jêsu hơdiŭ wơ̆, la Pô bloh buơl kơi hũ pơ̆ng tơ kơyơu pơkăl sơ̆ng pơmơtai. ");
INSERT INTO cje_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Yàng Pô Lơngì hũ apăn Pô nư̆n đì dò guh tơ gah hơnuă Pô, ngă Pơtau sơ̆ng Yàng Dŏng Pơklàh, tô brơi pơnuaĭ mơbai prah-luơi glài-sơnoh sơ̆ng pơnuaĭ anĭt toh-luơi glài-sơnoh tơ buơl làng Israel. ");
INSERT INTO cje_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Rùp-phŭn buơl dơlhă la du mơnih ngă grơh tơ du bruă nư̆n, găm sơ̆ng Yàng Bơngă Sơc̆ih-Sri bloh Yàng Pô Lơngì hũ brơi tơ du mơnih păng-bơbah Pô.” ");
INSERT INTO cje_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Tŭ mơhư̆ du pơnuaĭ ni, buơl guñu anok hơtai biă sơ̆ng khiăng pơmơtai du mơnih tơdi-tơdài. ");
INSERT INTO cje_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Bloh lăm Tơrpuơl Gơnuăr Apăn-Akŏ Buơl Làng hũ sa aràng mơnih Pharisi, angăn la Gamaliel, ngă pô-pơto pơnuaĭ adăt-adia, hũ abih buơl làng c̆ơ prŏng-màng, tơgồ dơ̆ng tơkrah Tơrpuơl Gơnuăr Apăn-Akŏ Buơl Làng, sơ̆ng pơđăr ba du mơnih tơdi-tơdài tơbiă tơ agàh lăm sa-sĭt tŭ. ");
INSERT INTO cje_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Bloh nư̆n ñu đờm sơ̆ng Tơrpuơl Gơnuăr Apăn-Akŏ Buơl Làng: “Ơ mơnih Israel, yòng c̆ơ-kơrhia nĭ-nùn bĕ mư̆ng bruă buơl kơi rơŭ ngă sơ̆ng du mơnih ni. ");
INSERT INTO cje_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Mư̆ng dơlhơu thrơi, hũ Theuđa đì-tơgồ tămdră-wơ̆, pơ-angăn rùp-phŭn drơi la mơnih prŏng-màng, hũ pơgăp pà rơtùh aràng tui ñu. Bloh hơdơi tŭ ñu kơđòng aràng pơmơtai, nư̆n abih du mơnih tui ñu kơprah-kơprĭng, 'buh dò hơgĕ tra. ");
INSERT INTO cje_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Hơdơi tơ ñu kŭng hũ Juđa, mơnih Galile, đì-tơgồ tămdră-wơ̆ lăm thŭn pơtau Rôma wă-angăn khà buơl làng, sơ̆ng ba-pơsờh lô mơnih tui drơi; bloh nư̆n kŭng mơtai, abih du mơnih tui ñu kŭng kơđòng kơprah-kơprĭng abih. ");
INSERT INTO cje_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Nư̆n tŭ ni dơlhă yòng đờm sơ̆ng buơl sơ-ai: Pleh atàh bĕ mư̆ng du mơnih ni, kừ luơi mơti buơl guñu. Kơyoa yah pơnuaĭ sơnư̆ng-bơyai sơ̆ng bruă ngă ni la kơyoa mư̆ng jơi anà mơnih, nư̆n rơŭ kơđòng pơluĭ-pơlơhiă. ");
INSERT INTO cje_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Bloh yah la kơyoa mư̆ng Yàng Pô Lơngì, nư̆n buơl sơ-ai 'buh rơgơi pơluĭ-pơlơhiă jiơ̆ng; tơrblơ̆ wơ̆, buơl sơ-ai tơbiă jiơ̆ng du mơnih tămdră-wơ̆ sơ̆ng Yàng Pô Lơngì.” Buơl guñu sa hơtai păng sơ̆ng ngă tui pơnuaĭ Gamaliel đờm bơyai. ");
INSERT INTO cje_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Buơl guñu iơu du mơnih tơdi-tơdài gài tơma wơ̆, pơđăr mơnih glih-atòng, sơ̆ng pơkơŭ 'buh brơi mă angăn Yàng Jêsu bloh pơto-akhàn tra, bloh nư̆n toh-tơleh brơi du mơnih tơdi-tơdài tơbiă. ");
INSERT INTO cje_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Du mơnih tơdi-tơdài tơbiă klàh mư̆ng anih Tơrpuơl Gơnuăr Apăn-Akŏ Buơl Làng pơgùm-pơtòm gơŭ, lăm hơtai-hơtiàn sờh-sài kơyoa buơl guñu hũ c̆ơ la iơŭ păl tô kŏng pơnuaĭ klau-pơtăt kơyoa angăn Yàng Jêsu. ");
INSERT INTO cje_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Yàu hơrơi, lăm anih sàng duh-dơlbăt halài mư̆ng sàng ni truh sàng pơkơ̆n, du mơnih tơdi-tơdài kừ sơđaŭ pơto-pơsài sơ̆ng pơto-akhàn Pơnuaĭ-Siàm Yàng Jêsu, la Pô Krist. ");
INSERT INTO cje_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Lăm tŭ nư̆n, kơyoa khà mơnih păng-tui Yàng 'brŏ hơrơi 'brŏ lô rơlau, du mơnih Juđa đờm ia Grek yuăm 'buah tơ du mơnih Juđa đờm ia Hebrơ, kơyoa du mơnih kơmơi bơdrau lăm tơrpuơl buơl guñu, hũ kŏng aràng luơi wơ̆rglai lăm bruă brơi pơrpha phơ̆n-kơya 'bơ̆ng yàu hơrơi. ");
INSERT INTO cje_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Kơyoa nư̆n, sa-pluh dua aràng mơnih tơdi-tơdài iơu abih du mơnih tui-mơgru pơgùm-pơtòm wơ̆, sơ̆ng đờm: “Luơi bruă pơto-akhàn pơnuaĭ Yàng Pô Lơngì tô rơc̆ăng bruă brơi pơrpha phơ̆n-kơya 'bơ̆ng, la pơnuaĭ 'buh iơŭ sa-sĭt lơi. ");
INSERT INTO cje_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Yơu nư̆n, yòng buơl adơi-ai rơwah bĕ lăm tơkrah tơrpuơl drơi tơjuh aràng mơnih hũ tiơ̆ng-mơyòm siàm, baŭ-bèng Bơngă Sơc̆ih-Sri sơ̆ng jak-khờh, bloh nư̆n buơl dơlhă rơŭ jào gơnuăr bruă ni tơ buơl guñu. ");
INSERT INTO cje_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Gah buơl dơlhă, buơl dơlhă rơŭ abih hơtai-hơtiàn lăm pơnuaĭ iơu-lài sơ̆ng lăm gơnuăr bruă pơto-akhàn Pơnuaĭ Yàng.” ");
INSERT INTO cje_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Abih tơgrơ̆ mơnih hũ sờh-siàm hơtai-hơtiàn mư̆ng du pơnuaĭ nư̆n. Buơl guñu rơwah Etien, la mơnih hũ baŭ pơnuaĭ păng-tui sơ̆ng Yàng Bơngă Sơc̆ih-Sri, găm sơ̆ng Philip, Brôkôr, Nikanor, Timôn, Bamena, sơ̆ng Nikôla la mơnih Antiôt pơrpa păng-tui jơlàn mơnih Juđa duh-dơlbăt. ");
INSERT INTO cje_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Buơl guñu ba tơjuh aràng mơnih nư̆n truh tơ anaŭ du mơnih tơdi-tơdài. Du mơnih tơdi-tơdài iơu-lài bloh nư̆n daŭ tơngàn tơ ngŏ du mơnih ni. ");
INSERT INTO cje_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Pơnuaĭ Yàng Pô Lơngì 'brŏ hơrơi 'brŏ prŏng lơnàng, khà mơnih tui-mơgru Yàng lăm Jerusalem 'brŏ đì-tơgồ lô rơlau. Kŭng hũ lô mơnih gơnuăr pơyă phơ̆n duh-dơlbăt păng tui jơlàn pơnuaĭ păng-tui rơi. ");
INSERT INTO cje_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Etien hũ baŭ pơnuaĭ anĭt-brơi-soh sơ̆ng gơnăp-gơnuăr, ngă du pơnuaĭ-c̆rih nàl-krơi prŏng biă lăm buơl làng. ");
INSERT INTO cje_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Tŭ nư̆n hũ du mơnih lăm sàng pơtòm tơrpuơl angăn la Du Mơnih Hũ Akŏ-Lơhuai Tơkai-Lơnàng, găm sơ̆ng du mơnih plơi tơ Siren, du mơnih plơi tơ Aleksandri, sơ̆ng du mơnih Juđa dò tơ Silisi sơ̆ng c̆àr Asi, tơgồ đờm tămpơrjai sơ̆ng Etien. ");
INSERT INTO cje_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Bloh buơl guñu 'buh tămdră jai sơ̆ng kơtha pơnuaĭ jak-khờh găm sơ̆ng Yàng Bơngă Sơc̆ih-Sri, la Pô hũ brơi tơ Etien tơgrơ̆ kơtha pơnuaĭ nư̆n. ");
INSERT INTO cje_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Kơyoa nư̆n buơl guñu pơsŭt-pơđăr iờp du mơnih pơkơ̆n đờm yă bơdah Etien lài: “Buơl dơlhă hũ mơhư̆ ñu đờm du pơnuaĭ sơk-sơrbĭl truh Môise sơ̆ng Yàng Pô Lơngì.” ");
INSERT INTO cje_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Buơl guñu pơsŭt-pơđăr buơl làng, du mơnih gơnuăr-tha sơ̆ng du mơnih gơnuăr-pơto pơnuaĭ adăt-adia, bloh nư̆n brồ mă Etien sơ̆ng ba truh tơ anaŭ Tơrpuơl Gơnuăr Apăn-Akŏ Buơl Làng. ");
INSERT INTO cje_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Buơl guñu angui du mơnih ngă grơh lơ̆r, tơgồ dơ̆ng đờm yă lài: “Mơnih ni jiăng đờm du pơnuaĭ sơk-sơrbĭl truh Anih Sơc̆ih-Sri sơ̆ng pơnuaĭ Adăt-Adia. ");
INSERT INTO cje_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Kơyoa buơl dơlhă hũ mơhư̆ ñu đờm lài Jêsu mơnih Nasaret ni rơŭ pơluĭ-pơlơhiă anih ni sơ̆ng pơsơlih abih du pơnuaĭ adăt-lơđăp bloh Môise hũ pioh luơi tơ buơl gudrơi.” ");
INSERT INTO cje_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Abih tơgrơ̆ mơnih dò guh lăm anih Tơrpuơl Gơnuăr Apăn-Akŏ Buơl Làng pơgùm-pơtòm, c̆ơ nĭ-nùn tơ Etien, sơ̆ng 'buh 'bò mơta ñu mơhiơ̆ yơu 'bò mơta mơnih gơdrưh. ");
INSERT INTO cje_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Mơnih gơnuăr prŏng apăn-akŏ pơyă phơ̆n duh-dơlbăt tơnia Etien: “Hũ iơŭ yơu nư̆n ơu?” ");
INSERT INTO cje_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Etien đờm sơđồ: “Ơ buơl sơ-ai, buơl ama, yòng păng pơnuaĭ dơlhă đờm! Yàng Pô Lơngì màng-kơc̆rà hũ tơbiă pơ'buh sơ̆ng kơi-kŏ pàng-yau buơl gudrơi la Abraham, tŭ ñu dò lăm Mesôpôtami, dơlhơu tơ tŭ ñu truh dò lăm C̆aran, ");
INSERT INTO cje_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","sơ̆ng đờm lài: ‘Tơbiă bĕ mư̆ng lơgăr phŭn sơ̆ng gơŭ-pơtiàn hã, bloh nau truh tơ c̆àr-tơnah Kơu rơŭ pơto tơ hã.’ ");
INSERT INTO cje_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Nư̆n, Abraham tơbiă mư̆ng c̆àr Kălđe sơ̆ng truh dò tơ C̆aran. Hơdơi tŭ ama ñu mơtai, Yàng Pô Lơngì pơđăr ñu luơi anih nư̆n bloh nau truh tơ lơ̆n-tơnah ni, la lơgăr buơl adơi-ai dò tŭ ni. ");
INSERT INTO cje_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Pô 'buh brơi tơ ñu phŭm-kơsai lơi lăm c̆àr-tơnah ni, yah sa pĕt lơ̆n daŭ plà tơkai kŭng 'buh hũ ơu rơi. Bloh Pô pơguăn brơi tơ ñu sơ̆ng jơi-pơtiàn ñu gơnuăr ngă pô c̆àr-tơnah ni, yah tŭ nư̆n ñu ka hũ anà. ");
INSERT INTO cje_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Yàng Pô Lơngì đờm: ‘Jơi-pơtiàn hã rơŭ dò sơdăng anih lơ̆n thuai tơnah aràng, bloh nư̆n aràng rơŭ mă buơl guñu ngă hơlŭn-hơlă sơ̆ng juă-klơ̆m buơl guñu lăm pà rơtùh thŭn.’ ");
INSERT INTO cje_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Yàng Pô Lơngì đờm: ‘Bloh Kơu rơŭ c̆ahrơña buơl làng hũ mă buơl guñu ngă hơlŭn-hơlă. Hơdơi mư̆ng nư̆n, buơl guñu rơŭ tơbiă nau sơ̆ng duh-dơlbăt Kơu tơ anih ni.’ ");
INSERT INTO cje_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Bloh nư̆n, Yàng Pô Lơngì brơi tơ ñu pơnuaĭ pơguăn-pơđoàn mư̆ng adăt sơkaŭ-kơlì. Kơyoa nư̆n, hơdơi tŭ đih apui Isak hũ tơlpăn hơrơi, Abraham ngă adăt sơkaŭ-kơlì tơ Isak. Isak ngă adăt sơkaŭ-kơlì tơ Jakôp, sơ̆ng Jakôp kŭng ngă adăt nư̆n tơ sa-pluh dua aràng kơi-kŏ pàng-yau buơl gudrơi. ");
INSERT INTO cje_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Du kơi-kŏ pàng-yau oàn-mơbai sơ̆ng Jôsep, nư̆n hũ mă ñu pơblơi tơ lơgăr Ejiptơ. Bloh Yàng Pô Lơngì dò sơ̆ng ñu. ");
INSERT INTO cje_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Pô dŏng-suă ñu klàh mư̆ng tơgrơ̆ pơnuaĭ gleh-glăr, brơi tơ ñu pơnuaĭ anĭt-brơi-soh sơ̆ng pơnuaĭ jak-khờh tơ anaŭ Pharaôn, pơtau Ejiptơ, pơtau nư̆n rơwah-pồ ñu ngă mơnih apăn-akŏ abih lơgăr Ejiptơ sơ̆ng abih sàng-dơnò pơtau. ");
INSERT INTO cje_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Tŭ nư̆n, hũ sa pơnuaĭ ờ-lơpa tơbiă truh lăm abih lơgăr Ejiptơ sơ̆ng lơgăr Kanaan, pơnuaĭ ờ-lơpa nư̆n prŏng biă, ngă tơ du kơi-kŏ pàng-yau buơl gudrơi 'buh duah hũ phơ̆n-kơya 'bơ̆ng. ");
INSERT INTO cje_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Tŭ Jakôp mơhư̆ lài lăm Ejiptơ hũ bơdai bràh, nư̆n pơđăr du kơi-kŏ pàng-yau buơl gudrơi nau truh tơ anih nư̆n amăng sa. ");
INSERT INTO cje_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Truh amăng dua, nư̆n ka Jôsep brơi buơl adơi-ai ñu thơu mư̆ng ñu, sơ̆ng kơyoa nư̆n Pharaôn kŭng thơu mư̆ng sàng-dơnò Jôsep rơi. ");
INSERT INTO cje_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Jôsep pơđăr mơnih nau rò Jakôp la ama drơi sơ̆ng abih sàng-dơnò, abih-tih la tơjuh pluh lơma aràng. ");
INSERT INTO cje_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yơu nư̆n, Jakôp trŭn tơ lơgăr Ejiptơ, bloh nư̆n mơtai tơ anih nư̆n. Du kơi-kŏ pàng-yau buơl gudrơi kŭng yơu nư̆n rơi. ");
INSERT INTO cje_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Tơlàng buơl guñu hũ ba mơrai wơ̆ tơ Sic̆em, sơ̆ng dơ̆r lăm kŭt atơu bloh Abraham hũ mă priă blơi mư̆ng du anà lơkơi Hamôr tơ Sic̆em. ");
INSERT INTO cje_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Tŭ kơjĕ truh tŭ-hơrơi Yàng Pô Lơngì ngă iơŭ tơpă pơnuaĭ Pô hũ đờm pơguăn sơ̆ng Abraham, nư̆n buơl làng buơl gudrơi tơ Ejiptơ kừ c̆eh-pơsài rài-pơjiơ̆ng lô biă, ");
INSERT INTO cje_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","tơ̆l truh tơ tŭ lăm lơgăr nư̆n hũ sa aràng pơtau pơkơ̆n đì apăn gơnuăr, sơ̆ng pơtau nư̆n 'buh thơu Jôsep. ");
INSERT INTO cje_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Pơtau ni angui pơnuaĭ sơnư̆ng-bơyai blơ̆ lơ̆r tô ngă jơhà tơ jơi-pơtiàn buơl gudrơi, sơ̆ng juă-klơ̆m kơi-kŏ pàng-yau buơl gudrơi, pơkơŭ-pơđăr buơl guñu păl klà-luơi du anà mơnga pơrpa đih apui, 'buh brơi guñu hơdiŭ. ");
INSERT INTO cje_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Lăm tŭ-hơrơi nư̆n, Môise hũ đih apui tơbiă, ñu bơlai-mơkrư biă tơ anaŭ Yàng Pô Lơngì, sơ̆ng hũ ròng lăm sàng ama drơi lăm klơu blàn. ");
INSERT INTO cje_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Tŭ Môise kơđòng ba nau klà lăm ia, nư̆n hũ anà kơmơi Pharaôn apăn mơrai wơ̆ ròng, sơ̆ng ròng yơu anà phŭn drơi. ");
INSERT INTO cje_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Môise hũ mơgru abih tơgrơ̆ pơnuaĭ jak-khờh mơnih Ejiptơ, sơ̆ng la mơnih hũ gơnuăr-pràn lăm pơnuaĭ đờm kŭng yơu bruă ngă. ");
INSERT INTO cje_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Tŭ Môise hũ pà pluh thŭn, lăm hơtai-hơtiàn ñu sơnư̆ng sơdơ̆r wơ̆, khiăng nau c̆uă-rơwăng adơi-ai jơi-pơtiàn drơi, la anà-tơc̆o Israel. ");
INSERT INTO cje_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Tŭ 'buh sa aràng mơnih adơi-ai jơi-pơtiàn drơi kŏng sa aràng mơnih Ejiptơ ngă jơhà, nư̆n Môise dŏng mư, sơ̆ng tô apăn pơnuaĭ rĭng-tơpă tơ mơnih kŏng juă-klơ̆m, Môise pờng pơmơtai mơnih Ejiptơ dih. ");
INSERT INTO cje_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Môise sơnư̆ng buơl adơi-ai drơi rơŭ wờng lài Yàng Pô Lơngì angui tơngàn drơi tô dŏng-suă buơl guñu, bloh buơl guñu 'buh wờng. ");
INSERT INTO cje_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Hơrơi hơdơi, tŭ 'buh buơl guñu tămngă duă sơ̆ng gơŭ drơi wơ̆, nư̆n Môise truh jĕ sơ̆ng duah pơnuaĭ tô ngă pơhơlàr dua gah. Môise đờm: ‘Ơ buơl sơ-ai, la adơi-ai sơ̆ng gơŭ, kơyoa hơgĕ ngă jơhà sơ̆ng gơŭ yơu nư̆n?’ ");
INSERT INTO cje_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Bloh mơnih dò ngă jơhà tơ adơi-ai drơi tơlơ̆ Môise sơgah sơ̆ng đờm: ‘Aràng sơi hũ pồ sơ-ai ngă mơnih apăn-akŏ sơ̆ng mơnih c̆ahrơña tơ ngŏ buơl dơlhă? ");
INSERT INTO cje_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Halài sơ-ai kŭng khiăng pơmơtai dơlhă yơu hũ pơmơtai mơnih Ejiptơ hơrơi kơbrơi rơi?’ ");
INSERT INTO cje_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Mơhư̆ du pơnuaĭ nư̆n, Môise luơi lơgăr Ejiptơ sơ̆ng đuaĭ dơŭ, truh dò sơdăng lăm c̆àr Madian. Tơ anih nư̆n, ñu pơjiơ̆ng hũ dua aràng anà lơkơi. ");
INSERT INTO cje_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Pà pluh thŭn hơdơi, sa aràng mơnih gơdrưh tơbiă pơ'buh sơ̆ng Môise lăm anih 'blàng-c̆uah c̆ơ̆ Sinai, lăm dơlah apui anih puk druơi apui dò 'bơ̆ng gùh. ");
INSERT INTO cje_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Môise 'buh sơ̆ng mă ngă krơi-takơtuă biă mư̆ng pơnuaĭ brơi pơ'buh nư̆n. Lăm tŭ ñu truh jĕ tô c̆ơ loh-làng, nư̆n hũ săp Yàng đờm sơ̆ng ñu: ");
INSERT INTO cje_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Kơu la Yàng Pô Lơngì kơi-kŏ pàng-yau hã, Yàng Pô Lơngì Abraham, Isak sơ̆ng Jakôp.’ Môise kơtơ̆ drơi huơĭ-kơđa biă, 'buh khĭn c̆ơ. ");
INSERT INTO cje_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Yàng đờm wơ̆ sơ̆ng ñu: ‘Wà bĕ kơjuă mư̆ng tơkai hã, kơyoa anih hã dò dơ̆ng nư̆n la anih sơc̆ih-sri. ");
INSERT INTO cje_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Kơu hũ c̆ơ sơ̆ng hũ 'buh pơnuaĭ pơđì-pơđoa gleh-glăr bloh buơl làng Kơu păl kŏng lăm lơgăr Ejiptơ. Kơu hũ mơhư̆ du pơnuaĭ buơl guñu să-joa ba-săp, nư̆n Kơu trŭn tô dŏng-suă buơl guñu. Tŭ ni truh bĕ! Kơu rơŭ pơđăr hã nau truh tơ lơgăr Ejiptơ.’ ");
INSERT INTO cje_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Rùp-phŭn Môise ni la mơnih bloh buơl guñu hũ kơmlah-luơi sơ̆ng đờm: ‘Aràng sơi hũ pồ sơ-ai ngă mơnih apăn-akŏ sơ̆ng mơnih c̆ahrơña tơ ngŏ buơl dơlhă?’ nư̆n ni Yàng Pô Lơngì hũ pơđăr ñu ngă mơnih apăn-akŏ sơ̆ng mơnih dŏng-suă kơyoa mư̆ng sa aràng mơnih gơdrưh hũ tơbiă pơ'buh sơ̆ng ñu lăm puk druơi. ");
INSERT INTO cje_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Rùp-phŭn Môise la mơnih hũ ba buơl guñu tơbiă klàh, hơdơi tŭ hũ ngă du pơnuaĭ-c̆rih nàl-krơi lăm lơgăr Ejiptơ, lăm Ia-Tơsì Mơr-yah, sơ̆ng anih 'blàng-c̆uah lăm pà pluh thŭn. ");
INSERT INTO cje_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Rùp phŭn Môise ni la mơnih hũ đờm sơ̆ng buơl làng Israel: ‘Yàng Pô Lơngì rơŭ pồ-pơtơgồ mư̆ng tơkrah buơl adơi-ai sa aràng mơnih gơnuăr-hwơ̆r mơhiơ̆ yơu dơlhă.’ ");
INSERT INTO cje_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Rùp-phŭn ñu la mơnih hũ dò sơ̆ng tơrpuơl buơl làng lăm anih 'blàng-jơhua, găm sơ̆ng mơnih gơdrưh, la Pô hũ đờm glai sơ̆ng ñu tơ ngŏ c̆ơ̆ Sinai, sơ̆ng hũ dò sơ̆ng du kơi-kŏ pàng-yau buơl gudrơi. Ñu kŭng la mơnih hũ đồ-mă du kơtha pơnuaĭ hơdiŭ tô brơi wơ̆ tơ buơl gudrơi. ");
INSERT INTO cje_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Bloh du kơi-kŏ pàng-yau buơl gudrơi 'buh khiăng păng-bơbah ñu, luơi ñu sơgah sơ̆ng pơtrah hơtai khiăng gài mơrai wơ̆ tơ lơgăr Ejiptơ. ");
INSERT INTO cje_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Buơl guñu đờm sơ̆ng Arôn: ‘Yòng ngă bĕ tơ buơl dơlhă du yàng tô nau dơlhơu dùi ba buơl dơlhă, kơyoa Môise ni, la mơnih ba buơl dơlhă tơbiă mư̆ng lơgăr Ejiptơ, buơl dơlhă 'buh thơu pơnuaĭ hơgĕ hũ tơbiă truh sơ̆ng ñu bơjơ.’ ");
INSERT INTO cje_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Lăm du hơrơi nư̆n, buơl guñu tuh-ngă sa boh rơ̆p-rùp lơmo anà, pơyă phơ̆n c̆ĕ-pơyơ̆r duh-dơlbăt tơ rơ̆p-rùp nư̆n, sơ̆ng sờh-sài mư̆ng bruă tơngàn drơi ngă tơbiă. ");
INSERT INTO cje_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Kơyoa nư̆n, Yàng Pô Lơngì hũ klà luơi buơl guñu, luơi mơti buơl guñu duh-dơlbăt ia-hơrơi, ia-blàn sơ̆ng du ia-pơtŭ tơ ngŏ lơngì, yơu hũ wă lăm 'bồn bơ-àr du mơnih gơnuăr-hwơ̆r lài: ‘Ơ sàng Israel, hũ iơŭ buơl guhã hũ pơyă phơ̆n sì c̆ĕ-pơyơ̆r duh-dơlbăt găm sơ̆ng phơ̆n c̆ĕ-pơyơ̆r duh-dơlbăt tơ Kơu, Lăm pà pluh thŭn tơ anih 'blàng-jơhua ơu? ");
INSERT INTO cje_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Buơl guhã hũ sơkồng tui pờ bơ-yài duh-dơlbăt yàng Môlôk, Sơ̆ng ia-pơtŭ yàng Romphan, Nư̆n la du rơ̆p-rùp bloh buơl guhã ngă tơbiă tô duh-dơlbăt. Kơyoa nư̆n, Kơu kŭng rơŭ apăn buơl guhã truh tơ gah dih lơgăr 'Babilôn.’ ");
INSERT INTO cje_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Tŭ dò lăm 'blàng-jơhua, du kơi-kŏ pàng-yau buơl gudrơi hũ Pờ bơ-yài Pơnuaĭ Grơh-Pơđoàn, yơu Yàng hũ đờm pơđăr Môise păl ngă iơŭ tui yơu rơ̆p bloh ñu hũ 'buh. ");
INSERT INTO cje_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Kơi-kŏ pàng-yau buơl gudrơi hũ đồ-mă pờ bơ-yài nư̆n, sơ̆ng hũ găm sơ̆ng Jôsue apăn ñu tơma lăm lơgăr buơl guñu tămblah mă hũ mư̆ng du buơl làng bloh Yàng Pô Lơngì hũ prơh klàh tơ anaŭ buơl guñu. Pờ bơ-yài nư̆n dò truh tơ rài pơtau Đabit, ");
INSERT INTO cje_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","la mơnih hũ pơnuaĭ anĭt tơ anaŭ Yàng Pô Lơngì, sơ̆ng ñu yòng duah sa anih dò tơ Yàng Pô Lơngì Jakôp. ");
INSERT INTO cje_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Hơdơi mư̆ng nư̆n, pơtau Salômôn bơ̆ tơ Yàng sa boh sàng. ");
INSERT INTO cje_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Bloh Pô Ngŏ Glòng Rơlau Abih 'buh dò lăm sàng kơyoa tơngàn anà mơnih ngă tơbiă, yơu mơnih gơnuăr-hwơ̆r hũ đờm: ");
INSERT INTO cje_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Yàng đờm: Lơngì la sơbàn Kơu, Lơ̆n-tơnah la gơnŭl tơ ala tơkai Kơu juă. Sàng lơi buơl guhã rơŭ bơ̆ tơ Kơu, Anih lơi la anih tơ Kơu pơdời-gleh? ");
INSERT INTO cje_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","'Buh iơŭ tơngàn Kơu hũ c̆rơ̆ng-tơbiă abih tơgrơ̆ phơ̆n ni ơu?’ ");
INSERT INTO cje_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Ơ du mơnih khăng akŏ, hơtai-hơtiàn sơ̆ng tơnia ka hũ ngă adăt sơkaŭ-kơlì dih! Buơl kơi mĭt-mĭt tămdră-wơ̆ sơ̆ng Yàng Bơngă Sơc̆ih-Sri. Kơi-kŏ pàng-yau buơl kơi hơyơu lơi, buơl kơi kŭng yơu nư̆n rơi! ");
INSERT INTO cje_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Hũ mơnih gơnuăr-hwơ̆r lơi bloh kơi-kŏ pàng-yau buơl kơi 'buh mă-pơkơŭ ơu? Buơl guñu kŭng pơmơtai du mơnih đờm hwơ̆r mư̆ng pơnuaĭ Pô Rĭng-Tơpă rơŭ truh, la Pô bloh tŭ ni buơl kơi pơblơ̆-dră wơ̆ sơ̆ng pơmơtai. ");
INSERT INTO cje_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Buơl kơi hũ đồ-mă pơnuaĭ adăt-adia kơyoa mư̆ng du mơnih gơdrưh brơi, bloh buơl kơi 'buh păng-rơmiă pơnuaĭ adăt-adia nư̆n.” ");
INSERT INTO cje_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Tŭ buơl guñu mơhư̆ du pơnuaĭ nư̆n, lăm hơtai-hơtiàn buơl guñu anok-anoa biă; buơl guñu kĕ tơgơi tămdră-wơ̆ sơ̆ng Etien. ");
INSERT INTO cje_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Bloh Etien, hũ baŭ-bèng Yàng Bơngă Sơc̆ih-Sri, mơta c̆ơ tơ ngŏ lơngì, 'buh pơnuaĭ màng-kơc̆rà Yàng Pô Lơngì, sơ̆ng 'buh Yàng Jêsu dò dơ̆ng tơ gah hơnuă Yàng Pô Lơngì. ");
INSERT INTO cje_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ñu đờm: “Dih, dơlhă 'buh du tăl lơngì pơh tơbiă, sơ̆ng Anà Mơnih dò dơ̆ng tơ gah hơnuă Yàng Pô Lơngì.” ");
INSERT INTO cje_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Tŭ nư̆n, buơl guñu driau prŏng, kơdrơ̆ tơnia wơ̆, sơ̆ng sơgơŭ brồ mă Etien, ");
INSERT INTO cje_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","hua tơbiă tơ agàh plơi-prŏng, bloh nư̆n prah pơtơu pơmơtai ñu. Du mơnih ngă grơh mă ào drơi daŭ tơ anih tơkai sa aràng mơnih lơkơi dăm angăn la Sol. ");
INSERT INTO cje_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Tŭ buơl guñu dò prah pơtơu, nư̆n Etien iơu-lài: “Khoai Yàng Jêsu, yòng rò-mă bơngă-joa anà.” ");
INSERT INTO cje_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Bloh nư̆n ñu c̆ĕ tơ-ù trŭn, iơu prŏng săp lài: “Khoai Yàng, yòng juơi tuh glài ni tơ buơl guñu!” Hơdơi tŭ đờm yơu nư̆n bơjơ, ñu kloh suàn. ");
INSERT INTO cje_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sol la mơnih sa hơtai-hơtiàn sơ̆ng buơl guñu lăm bruă pơmơtai Etien. Lăm tŭ nư̆n, Tơrpuơl Goh-Sơc̆ih lăm Jerusalem păp pơnuaĭ kơđòng mă-pơkơŭ prŏng biă. Abih tơgrơ̆ mơnih păng-tui Yàng păl đuaĭ c̆ơrlah-c̆ơrlờp lăm du c̆àr Juđe sơ̆ng Samari, dò mĭn du mơnih tơdi-tơdài soh. ");
INSERT INTO cje_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Yah yơu nư̆n, kŭng hũ du mơnih păng-duh Yàng, nau mă rùp atơu Etien apăn nau dơ̆r, sơ̆ng hia-c̆ŏ tơ ñu dơnuh-dơnà biă. ");
INSERT INTO cje_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Bloh Sol nư̆n kừ ngă kơprah-kơprĭng Tơrpuơl Goh-Sơc̆ih. Ñu tơma rơnùh mư̆ng sàng ni truh sàng pơkơ̆n, mă abih găm mơnih lơkơi mơnih kơmơi apăn krơ̆ lăm sàng jàm. ");
INSERT INTO cje_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Yơu nư̆n, du mơnih păl đuaĭ c̆ơrlah-c̆ơrlờp, nau mư̆ng anih ni truh anih pơkơ̆n, pơto-akhàn Pơnuaĭ-Siàm. ");
INSERT INTO cje_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Philip trŭn tơ plơi-prŏng Samari, pơto-akhàn mư̆ng Pô Krist tơ buơl làng lăm anih nư̆n. ");
INSERT INTO cje_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Tơrpuơl buơl làng păng pơnuaĭ Philip pơto-mơblàng sơ̆ng 'buh du nàl-c̆rih ñu ngă, nư̆n sa hơtai-hơtiàn păng ñu đờm. ");
INSERT INTO cje_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Kơyoa hũ lô kơmlài-kơmloh kơmrào prŏng săp bloh tơbiă mư̆ng lô mơnih kơđòng ñu ngă. Lô mơnih krŭn-khuĕt tơkai-tơngàn sơ̆ng mơnih joh-je kŭng hũ pơsồ-pơsaih. ");
INSERT INTO cje_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Kơyoa nư̆n, lăm plơi-prŏng hũ pơnuaĭ sờh-sài biă. ");
INSERT INTO cje_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Tŭ nư̆n, lăm plơi-prŏng nư̆n hũ sa aràng mơnih angăn la Simôn, mư̆ng dơlhơu hơdiŭ sơ̆ng bruă ngă pơjơu juh-proh, sơ̆ng ñu pơ-angăn rùp-phŭn drơi la sa aràng mơnih prŏng-màng, ngă tơ buơl làng Samari mă ngă krơi-takơtuă biă. ");
INSERT INTO cje_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Abih tơgrơ̆ mơnih dò tơ anih nư̆n, mư̆ng lơ-ơneh tìt tơ̆l truh tơ mơnih tha, aràng sơi aràng nư̆n kŭng păng tui ñu soh, bloh đờm lài: “Mơnih ni la gơnăp-gơnuăr Yàng Pô Lơngì, angăn la Gơnăp-Gơnuăr Prŏng.” ");
INSERT INTO cje_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Buơl nư̆n păng tui ñu, kơyoa mư̆ng suơi ni bơjơ, ñu hũ angui pơnuaĭ kơmlài-kơmloh ngă tơ buơl nư̆n păl mă ngă c̆rih-takơtuă. ");
INSERT INTO cje_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Bloh tŭ buơl guñu păng Philip pơto-akhàn tơ buơl guñu mư̆ng Pơnuaĭ-Siàm lơgăr Yàng Pô Lơngì sơ̆ng mư̆ng angăn Yàng Jêsu Krist, nư̆n abih buơl guñu, găm mơnih lơkơi sơ̆ng mơnih kơmơi đồ-mă pơnuaĭ 'baptem abih. ");
INSERT INTO cje_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Rùp-phŭn Simôn kŭng păng-tui rơi, sơ̆ng hơdơi tŭ đồ-mă pơnuaĭ 'baptem, nư̆n dò mĭt sơ̆ng Philip. Sơ̆ng tŭ ñu 'buh du pơnuaĭ-c̆rih nàl-krơi prŏng hũ ngă tơbiă, nư̆n mă ngă krơi-takơtuă biă. ");
INSERT INTO cje_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Du mơnih tơdi-tơdài dò lăm Jerusalem mơhư̆ thơu buơl làng Samari hũ đồ-mă Pơnuaĭ-Siàm Yàng Pô Lơngì, nư̆n pơđăr Pier sơ̆ng Jăng truh sơ̆ng buơl guñu. ");
INSERT INTO cje_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Tŭ truh anih, Pier sơ̆ng Jăng iơu-lài tơ du mơnih bơrhơu păng-tui tô buơl guñu đồ-mă Yàng Bơngă Sơc̆ih-Sri. ");
INSERT INTO cje_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Kơyoa Yàng Bơngă Sơc̆ih-Sri ka trŭn tơ ngŏ sa aràng mơnih lơi lăm tơrpuơl buơl guñu: buơl guñu mĭn mă angăn Yàng Jêsu bloh đồ-mă pơnuaĭ 'baptem soh. ");
INSERT INTO cje_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Pier sơ̆ng Jăng daŭ tơngàn tơ ngŏ buơl guñu, nư̆n buơl guñu đồ-mă hũ Yàng Bơngă Sơc̆ih-Sri. ");
INSERT INTO cje_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Tŭ 'buh du mơnih tơdi-tơdài daŭ tơngàn tơ ngŏ nư̆n Bơngă Sơc̆ih-Sri hũ brơi trŭn, nư̆n Simôn mă priă truh brơi tơ dua aràng mơnih tơdi-tơdài, sơ̆ng đờm: ");
INSERT INTO cje_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Yòng kŭng brơi tơ dơlhă gơnuăr nư̆n rơi, tô dơlhă daŭ tơngàn tơ ngŏ aràng sơi nư̆n mơnih nư̆n kŭng hũ đồ-mă Yàng Bơngă Sơc̆ih-Sri.” ");
INSERT INTO cje_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Bloh Pier đờm sơđồ lài: “Priă-jền sơ-ai kŭng mơtai-lơhiă bĕ sơ̆ng sơ-ai. Kơyoa sơ-ai sơnư̆ng, hũ rơgơi mă jền-priă blơi jiơ̆ng pơnuaĭ anĭt-brơi-soh mư̆ng Yàng Pô Lơngì! ");
INSERT INTO cje_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Sơ-ai 'buh hũ pơ-ơnah hơgĕ sơ̆ng kŭng 'buh hũ pơ-ơnah pơrpha lơi lăm bruă ni ơu, kơyoa hơtai-hơtiàn sơ-ai 'buh tơpă-siàm tơ anaŭ Yàng Pô Lơngì. ");
INSERT INTO cje_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Yơu nư̆n, păl mơbai prah-luơi bĕ bruă mơsak-jơhà sơ-ai bloh iơu-lài sơ̆ng Yàng, tô hũ rơgơi Yàng rơŭ anĭt toh-luơi tơ sơ-ai mư̆ng glài-sơnoh hũ sơnư̆ng-bơyai yơu nư̆n lăm hơtai-hơtiàn. ");
INSERT INTO cje_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Kơyoa dơlhă 'buh sơ-ai sơđaŭ dò lăm pơnuaĭ oàn-mơbai sơ̆ng lăm srĕng-anuh pơnuaĭ glài-sơnoh.” ");
INSERT INTO cje_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simôn đờm sơđồ: “Yòng dua aràng buơl kơi iơu-lài sơ̆ng Yàng tơ dơlhă, tô dơlhă 'buh păl kơđòng lăm pơnuaĭ buơl kơi đờm nư̆n.” ");
INSERT INTO cje_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Hơdơi tŭ ngă grơh sơ̆ng pơto-akhàn pơnuaĭ Yàng, Pier sơ̆ng Jăng gài mơrai wơ̆ tơ Jerusalem; lăm jơlàn nau, buơl guñu nau găm pơto-akhàn Pơnuaĭ-Siàm găm lăm lô plơi mơnih Samari. ");
INSERT INTO cje_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Tŭ nư̆n, hũ sa aràng mơnih gơdrưh Yàng đờm sơ̆ng Philip: “Tơgồ dơ̆ng bĕ sơ̆ng nau trŭn tơ jơlàn ba truh gah yù, la jơlàn mư̆ng Jerusalem nau trŭn tơ Gasa.” Nư̆n la sa boh jơlàn jơhua tơkì mơnih nau mơrai. ");
INSERT INTO cje_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Philip tơgồ dơ̆ng sơ̆ng nau. Tŭ nư̆n hũ sa aràng mơnih kwăng Etiôpi, ñu la mơnih kwăng-prŏng duh bruă tơ mò Kandas, mơnih pơtau kơmơi apăn-akŏ lơgăr Etiôpi. Mơnih kwăng ni c̆ơ-apăn abih du sàng pioh phơ̆n-priă tơ mò. Ñu hũ truh tơ Jerusalem tô duh-dơlbăt. ");
INSERT INTO cje_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Lăm jơlàn nau wơ̆, ñu dò guh lăm rơdeh aseh sơ̆ng pơrpoh-c̆ơ 'bồn bơ-àr mơnih gơnuăr-hwơ̆r Êsai. ");
INSERT INTO cje_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Yàng Bơngă đờm sơ̆ng Philip: “Truh jĕ bĕ, sơ̆ng tui sơmào rơdeh aseh nư̆n.” ");
INSERT INTO cje_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Philip đuaĭ truh jĕ, sơ̆ng mơhư̆ mơnih kwăng nư̆n pơrpoh-c̆ơ lăm 'bồn bơ-àr mơnih gơnuăr-hwơ̆r Êsai, nư̆n tơnia: “Kơi wờng du pơnuaĭ kơi pơrpoh-c̆ơ nư̆n ơu?” ");
INSERT INTO cje_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Mơnih kwăng Etiôpi đờm sơđồ: “Yah 'buh hũ aràng sơi mơblàng-pơto, ngă hơyơu dơlhă wờng jiơ̆ng?” Bloh nư̆n mơnih kwăng jà Philip đì dò guh sơ̆ng drơi. ");
INSERT INTO cje_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Tăl 'Bồn Bơ-àr Sơc̆ih-Sri bloh ñu dò pơrpoh-c̆ơ nư̆n la anih ni: “Ñu hũ kŏng aràng hua nau yơu abo nau truh tơ anih aràng ngă rơlo, Yơu abo anà kơmlo-kơđơ̆ng tơ anaŭ mơnih kơtrĕ blơu, Ñu 'buh pơh kàng iơu kơmrào. ");
INSERT INTO cje_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Lăm tŭ Ñu kŏng pơnuaĭ pơtăt-pơmơlơu, Nư̆n pơnuaĭ rĭng-tơpă pioh tơ Ñu hũ kŏng suă-mă thĭt. Aràng sơi rơŭ đờm truh jơi-pơtiàn Ñu? Kơyoa pơnuaĭ hơdiŭ Ñu hũ kŏng suă klàh mư̆ng lơ̆n bơjơ.” ");
INSERT INTO cje_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Mơnih kwăng Etiôpi đờm sơ̆ng Philip: “Dơlhă yòng tơnia kơi, mơnih gơnuăr-hwơ̆r hũ đờm pơnuaĭ nư̆n mư̆ng aràng sơi? Mư̆ng rùp-phŭn ñu halài mư̆ng mơnih lơi pơkơ̆n?” ");
INSERT INTO cje_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Philip pơh kàng đờm sơđồ, sơ̆ng tơma mư̆ng tăl 'Bồn Bơ-àr Sơc̆ih-Sri nư̆n bloh pơto-akhàn Pơnuaĭ-Siàm mư̆ng Yàng Jêsu tơ mơnih kwăng Etiôpi. ");
INSERT INTO cje_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Rò jơlàn nau, buơl guñu truh tơ sa anih hũ ia, mơnih kwăng Etiôpi đờm: “Tơ anih ni lờih hũ ia, hũ pơnuaĭ hơgĕ pơkơŭ-pơkăl dơlhă đồ-mă pơnuaĭ 'baptem ơu?” ");
INSERT INTO cje_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Philip đờm: “Yah kơi abih hơtai-hơtiàn păng-tui, nư̆n hũ rơgơi jiơ̆ng.” Mơnih kwăng Etiôpi đờm sơđồ: “Dơlhă păng-tui Yàng Jêsu Krist la Anà Yàng Pô Lơngì.” ");
INSERT INTO cje_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Mơnih kwăng Etiôpi pơđăr rơdeh pơdơh wơ̆, bloh nư̆n abih dua aràng trŭn lăm ia, sơ̆ng Philip ngă 'baptem tơ mơnih kwăng Etiôpi. ");
INSERT INTO cje_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Tŭ đì tơbiă mư̆ng ia, Yàng Bơngă Yàng ba Philip nau thĭt, mơnih kwăng Etiôpi 'bu 'buh Philip tra, sơ̆ng kừ sơđaŭ sờh-sài nau jơlàn. ");
INSERT INTO cje_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Dò Philip, nư̆n aràng 'buh ñu tơ plơi-prŏng Asôt; sơ̆ng lăm jơlàn nau truh tơ plơi-prŏng Sesare, ñu pơto-akhàn Pơnuaĭ-Siàm tơ abih du plơi-prŏng ñu hũ nau pleh găn. ");
INSERT INTO cje_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Tŭ nư̆n, Sol sơđaŭ mơsak-pràn hơtai-hơtiàn khơ̆m pơmơtai du mơnih tui-mơgru Yàng. Ñu truh sơ̆ng mơnih gơnuăr prŏng apăn-akŏ pơyă phơ̆n duh-dơlbăt, ");
INSERT INTO cje_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","sơ̆ng yòng du bơ-àr pơyoa tơ du sàng pơtòm lăm Đamas, tô yah ñu duah hũ aràng sơi păng-tui jơlàn duh-dơlbăt Yàng, 'buh kơrhia la lơkơi halài kơmơi, nư̆n rơŭ mă c̆aŭ, ba mơrai tơ Jerusalem. ");
INSERT INTO cje_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Bloh tŭ Sol nau kơjĕ truh tơ plơi-prŏng Đamas, nư̆n phŭ-phă hũ pơnuaĭ sơrdah mư̆ng ngŏ lơngì pơkơc̆rà trŭn tòmdăr ñu. ");
INSERT INTO cje_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ñu lơbuh tơ ala lơ̆n sơ̆ng mơhư̆ hũ săp đờm sơ̆ng drơi: “Ơ Sol, Sol! Kơđa hơgĕ hã mă-pơkơŭ Kơu?” ");
INSERT INTO cje_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ñu đờm: “Ơ Yàng, Pô la aràng sơi?” Yàng đờm: “Kơu la Jêsu bloh hã mă-pơkơŭ. ");
INSERT INTO cje_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Bloh tơgồ dơ̆ng bĕ, nau tơma lăm plơi-prŏng, hũ mơnih rơŭ đờm tơ hã thơu tơgrơ̆ pơnuaĭ hơgĕ păl ngă.” ");
INSERT INTO cje_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Du mơnih nau găm sơ̆ng ñu dò dơ̆ng wơ̆, hơ̆l-dơmơ̆l biă, kơyoa buơl guñu hũ mơhư̆ săp đờm, bloh 'bu 'buh aràng sơi ơu. ");
INSERT INTO cje_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sol tơgồ dơ̆ng mư̆ng lơ̆n, mơta yah pơh, bloh 'bu 'buh hơgĕ ơu. Aràng apăn tơngàn ñu sơ̆ng dùi ñu tơma lăm plơi-prŏng Đamas. ");
INSERT INTO cje_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ñu dò tơ anih nư̆n klơu hơrơi, mơta 'buh c̆ơ 'buh hơgĕ jiơ̆ng, sơ̆ng kŭng 'buh 'bơ̆ng 'buh mơñŭm hơgĕ. ");
INSERT INTO cje_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Tŭ nư̆n, tơ plơi-prŏng Đamas hũ sa aràng mơnih tui-mơgru Yàng angăn la Anania. Lăm sa pơnuaĭ brơi pơ'buh, Yàng đờm sơ̆ng ñu: “Ơ Anania!” Ñu đờm sơđồ: “Ơ Yàng, hũ anà ni.” ");
INSERT INTO cje_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Yàng đờm pơđăr: “Tơgồ dơ̆ng bĕ, nau truh tơ jơlàn angăn la Tơpă-Biă, duah sàng Juđa, tô păp sa aràng mơnih angăn la Sol, plơi tơ Tarsơ. Dih, mơnih nư̆n dò iơu-lài. ");
INSERT INTO cje_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Lăm sa pơnuaĭ brơi pơ'buh, mơnih nư̆n 'buh hũ sa aràng mơnih angăn la Anania, nau tơma, daŭ tơngàn tơ ngŏ drơi tô hũ sơrdah mơta wơ̆.” ");
INSERT INTO cje_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Anania đờm: “Ơ Yàng, anà hũ mơhư̆ lô mơnih đờm mư̆ng mơnih ni, mư̆ng abih tơgrơ̆ pơnuaĭ jơhà mơnih nư̆n hũ ngă tơ buơl làng sơc̆ih-sri Yàng lăm Jerusalem. ");
INSERT INTO cje_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Tŭ ni mơnih nư̆n dò tơ anih ni, hũ tơ̆l gơnuăr mư̆ng du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt, tô mă c̆aŭ abih du mơnih iơu-lơkơu truh angăn Pô.” ");
INSERT INTO cje_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Bloh Yàng đờm sơ̆ng Anania: “Nau bĕ, kơyoa Kơu hũ rơwah mơnih ni ngă sa phơ̆n angui tơ Kơu, tô apăn angăn Kơu truh sơ̆ng du buơl làng agàh, du pơtau, sơ̆ng du anà Israel. ");
INSERT INTO cje_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Kơu rơŭ brơi mơnih nư̆n thơu păl kŏng pơđì-pơđoa gleh-glăr kơyoa mư̆ng angăn Kơu la hơyơu lơi.” ");
INSERT INTO cje_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Anania tơbiă nau, tơma lăm sàng, bloh nư̆n daŭ tơngàn tơ ngŏ Sol sơ̆ng đờm: “Ơ sơ-ai Sol, Yàng la Yàng Jêsu, Pô hũ tơbiă pơ'buh sơ̆ng sơ-ai lăm jơlàn sơ-ai nau truh tơ anih ni, pơđăr dơlhă truh tô brơi sơ-ai hũ sơrdah mơta wơ̆ sơ̆ng hũ baŭ-bèng Yàng Bơngă Sơc̆ih-Sri.” ");
INSERT INTO cje_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Lăm tơk tŭ nư̆n mư, hũ phơ̆n hơgĕ yơu kơrkàh akàn mư̆ng mơta Sol hŏ tơ ala, sơ̆ng ñu hũ sơrdah mơta wơ̆; bloh nư̆n tơgồ dơ̆ng sơ̆ng đồ-mă pơnuaĭ 'baptem. ");
INSERT INTO cje_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Hơdơi tŭ huă 'bơ̆ng, ñu hũ pràn-khăng wơ̆. Sol dò wơ̆ sơ̆ng du mơnih tui-mơgru Yàng lăm Đamas du hơrơi, ");
INSERT INTO cje_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","bloh nư̆n lăm tơk mư, ñu nau tơma lăm du sàng pơtòm đờm pơto-akhàn lài Yàng Jêsu la Anà Yàng Pô Lơngì. ");
INSERT INTO cje_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Du mơnih mơhư̆ pơnuaĭ ñu pơto-akhàn, aràng sơi aràng nư̆n kŭng mă ngă krơi-takơtuă biă, sơ̆ng đờm: “Ni 'buh iơŭ la mơnih hũ pơluĭ-pơmơtai du mơnih iơu-lơkơu angăn nư̆n lăm Jerusalem, sơ̆ng kŭng truh tơ anih ni tô mă c̆aŭ buơl mơnih nư̆n ba mơrai wơ̆ tơ du mơnih gơnuăr apăn-akŏ pơyă phơ̆n duh-dơlbăt ơu?” ");
INSERT INTO cje_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Bloh Sol nư̆n 'brŏ hơrơi 'brŏ hĭl-pràn, đờm tămpơrjai sơ̆ng du mơnih Juđa dò lăm Đamas, sơ̆ng đờm ngă grơh loh-làng lài Yàng Jêsu la Pô Krist. ");
INSERT INTO cje_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Hơdơi lô hơrơi đờm pơto-akhàn yơu nư̆n, mơnih Juđa tămbơyai sơ̆ng gơŭ tô pơmơtai Sol. ");
INSERT INTO cje_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Bloh hũ mơnih đờm tơ Sol thơu mư̆ng pơnuaĭ buơl guñu tămbơyai. Buơl guñu kraŭ-khiă du bơh 'băng plơi-prŏng găm hơrơi găm mơlăm, tô pơmơtai gơhũ Sol. ");
INSERT INTO cje_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Bloh lăm glai mơlăm, du mơnih tui-mơgru mă bài pơtrŭn ñu trŭn tơ gah agàh pơga plơi-prŏng. ");
INSERT INTO cje_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Tŭ truh tơ Jerusalem, Sol khiăng tơma sa tơrpuơl sơ̆ng du mơnih tui-mơgru Yàng, bloh abih tơgrơ̆ mơnih sơđaŭ dò sơnư̆ng huơĭ mư̆ng ñu, kơyoa 'buh păng-tui ñu la mơnih tui-mơgru biă. ");
INSERT INTO cje_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Bloh 'Banaba dŏng ñu sơ̆ng ba ñu truh tòm sơ̆ng du mơnih tơdi-tơdài. 'Banaba đờm akhàn wơ̆ tơ buơl guñu thơu mư̆ng bruă Yàng hũ tơbiă pơ'buh sơ̆ng Sol hơyơu lơi lăm jơlàn nau truh tơ Đamas, sơ̆ng Pô hũ đờm pơđăr ñu pơnuaĭ hơgĕ, kŭng yơu bruă ñu hũ hĭl-pràn hơtai-hơtiàn đờm pơto-akhàn mư̆ng angăn Yàng Jêsu lăm Đamas hơyơu lơi. ");
INSERT INTO cje_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Mư̆ng nư̆n, Sol nau-mơrai sơ̆ng du mơnih tui-mơgru lăm Jerusalem, ");
INSERT INTO cje_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","sơ̆ng mă angăn Yàng bloh pơto-akhàn hĭl-pràn biă. Ñu kŭng đờm glai sơ̆ng tămpơrjai sơ̆ng du mơnih Juđa đờm ia Grek; bloh du mơnih nư̆n duah pơnuaĭ tô pơmơtai ñu. ");
INSERT INTO cje_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Mơhư̆ thơu pơnuaĭ nư̆n, buơl adơi-ai ba mư ñu trŭn tơ Sesare, bloh nư̆n pơyoa ñu nau tơ Tarsơ. ");
INSERT INTO cje_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Yơu nư̆n, Tơrpuơl Goh-Sơc̆ih lăm abih c̆àr Juđe, Galile sơ̆ng Samari hũ đồ-mă pơnuaĭ rĭng-lơngai, hũ bơ̆-tơgồ pràn-kơjăp. Tơrpuơl Goh-Sơc̆ih hơdiŭ lăm pơnuaĭ duh-huơĭ Yàng, sơ̆ng gơnừm tơ Yàng Bơngă Sơc̆ih-Sri dŏng-kờl, nư̆n khà mơnih păng-tui Yàng 'brŏ hơrơi 'brŏ lô rơlau. ");
INSERT INTO cje_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Tŭ nư̆n, Pier nau lăm abih tơgrơ̆ anih, kŭng truh sơ̆ng du mơnih păng-tui Yàng lăm plơi-prŏng Liđa rơi. ");
INSERT INTO cje_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Tơ anih nư̆n, Pier păp sa aràng mơnih lơ-ơ̆n mơtai tơkai-tơngàn, mơnih nư̆n dò đih lăm c̆iau hũ tơlpăn thŭn bơjơ, angăn mơta ñu la Ene. ");
INSERT INTO cje_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pier đờm sơ̆ng ñu: “Ơ Ene, Yàng Jêsu Krist pơsồ-pơsaih tơ hã! Tơgồ dơ̆ng bĕ, blì pioh c̆iau hã!” Lăm tơk tŭ nư̆n mư, ñu tơgồ dơ̆ng. ");
INSERT INTO cje_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Abih buơl làng lăm Liđa sơ̆ng Sarôn 'buh Ene hũ pơsồ-pơsaih, nư̆n gài mơrai păng-tui Yàng. ");
INSERT INTO cje_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Tơ plơi-prŏng Jôppe, lăm tơrpuơl mơnih tui-mơgru, hũ sa aràng mơnih kơmơi angăn la Tabitha; mơta ñu lăm ia Grek la Đôrkas. Ñu ngă lô bruă siàm anĭt-dŏng mơnih pơkơ̆n sơ̆ng jiăng brơi-soh. ");
INSERT INTO cje_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Lăm du hơrơi nư̆n, ñu kơđòng lơ-ơ̆n sơ̆ng mơtai. Aràng pơmơnưi rùp atơu ñu, bloh nư̆n apăn daŭ lăm sa boh adŭ tăl ngŏ sàng. ");
INSERT INTO cje_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Kơyoa Liđa dò jĕ Jôppe, nư̆n tŭ du mơnih tui-mơgru mơhư̆ thơu hũ Pier dò tơ anih nư̆n, buơl guñu pơđăr mư dua aràng mơnih truh tòm Pier sơ̆ng đờm: “Yòng jà kơi truh mư sơ̆ng buơl dơlhă.” ");
INSERT INTO cje_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pier tơgồ dơ̆ng nau sơ̆ng dua aràng buơl guñu. Tŭ truh anih, aràng ba Pier truh tơ adŭ tăl ngŏ sàng. Abih du mơnih kơmơi bơdrau pơgùm gơŭ tòmdăr Pier bloh hia, sơ̆ng pơto tơ ñu c̆ơ du ào agàh sơ̆ng khăn-ào pơkơ̆n bloh mò Đôrkas hũ sì brơi tơ buơl guñu tŭ mò dò hơdiŭ. ");
INSERT INTO cje_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pier yòng abih tơgrơ̆ mơnih tơbiă tơ agàh, bloh nư̆n c̆ĕ tơ-ù trŭn sơ̆ng iơu-lài. Hơdơi mư̆ng nư̆n, ñu pơtrah gah rùp atơu sơ̆ng đờm: “Ơ Tabitha, tơgồ bĕ!” Mò Tabitha pơh mơta, 'buh Pier, nư̆n tơgồ dò guh mư. ");
INSERT INTO cje_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pier mă tơngàn đơ̆ng mò tơgồ, bloh nư̆n iơu du mơnih sơc̆ih-sri sơ̆ng du mơnih kơmơi bơdrau truh sơ̆ng pơto tơ buơl guñu 'buh mò hơdiŭ. ");
INSERT INTO cje_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Bruă nư̆n hũ ba pơtiơ̆ng lăm abih plơi-prŏng Jôppe, nư̆n hũ lô mơnih păng-tui Yàng. ");
INSERT INTO cje_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pier dò wơ̆ lăm plơi-prŏng Jôppe lô hơrơi, tơ sàng sa aràng mơnih khờh ngă kơlì, angăn la Simôn. ");
INSERT INTO cje_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Tơ plơi-prŏng Sesare, hũ sa aràng mơnih angăn la Kornai, la mơnih apăn-akŏ sa rơtùh lĭng, lăm tơrpuơl lĭng angăn la Itali. ");
INSERT INTO cje_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ñu sơ̆ng du mơnih lăm sàng-dơnò ñu la tơgrơ̆ mơnih duh-huơĭ Yàng Pô Lơngì. Ñu jiăng sơrmah hơtai-hơtiàn brơi-soh dŏng du mơnih rơ'bah rơ'bừp lăm buơl làng, sơ̆ng jiăng mĭt iơu-lài sơ̆ng Yàng Pô Lơngì. ");
INSERT INTO cje_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Lăm sa hơrơi dih, pơgăp klơu jơ diơŭ, lăm sa pơnuaĭ brơi pơ'buh, ñu 'buh loh-làng sa aràng mơnih gơdrưh Yàng Pô Lơngì tơma lăm sàng drơi sơ̆ng đờm: “Ơ Kornai!” ");
INSERT INTO cje_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ñu huơĭ-kơđa c̆ơ nĭ-nùn tơ mơnih gơdrưh sơ̆ng đờm: “Khoai Yàng, hũ bruă hơgĕ nư̆n?” Mơnih gơdrưh đờm: “Du pơnuaĭ hã iơu-lài găm sơ̆ng bruă hã brơi-soh dŏng mơnih pơkơ̆n hũ đì truh tơ Yàng Pô Lơngì, sơ̆ng Pô hũ sơdơ̆r truh. ");
INSERT INTO cje_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Nư̆n tŭ ni, pơđăr bĕ mơnih nau truh tơ plơi-prŏng Jôppe, jà rò Simôn, kŭng angăn la Pier. ");
INSERT INTO cje_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Mơnih nư̆n tŭ ni dò sơdăng lăm sàng Simôn, mơnih khờh ngă kơlì, sàng dò jĕ tơ gah ia-tơsì.” ");
INSERT INTO cje_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Hơdơi tŭ mơnih gơdrưh đờm glai sơ̆ng Kornai nau bơjơ, Kornai iơu dua aràng lăm tơrpuơl mơnih hơlŭn-hơlă drơi găm sơ̆ng sa aràng mơnih lĭng hũ hơtai-hơtiàn duh-huơĭ Yàng Pô Lơngì, tŭ nư̆n dò duh bruă tơ ala gơnuăr ñu truh, ");
INSERT INTO cje_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","sơ̆ng đờm-akhàn wơ̆ tơ buơl guñu păng mư̆ng abih tơgrơ̆ bruă, bloh nư̆n pơđăr buơl guñu nau truh tơ Jôppe. ");
INSERT INTO cje_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Hơrơi hơdơi, pơgăp sa-pluh dua jơ hơrơi dơ̆ng, lăm tŭ klơu aràng mơnih nư̆n dò nau jơlàn sơ̆ng truh jĕ tơ plơi-prŏng Jôppe, nư̆n Pier đì tơ ngŏ 'blàng bơbŭng sàng tô iơu-lài. ");
INSERT INTO cje_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ñu lơpa tŭng sơ̆ng khiăng hũ phơ̆n hơgĕ 'bơ̆ng. Bloh lăm tŭ aràng dò rơc̆ăng pồ phơ̆n huă 'bơ̆ng, nư̆n ñu 'buh sa pơnuaĭ Yàng brơi pơ'buh. ");
INSERT INTO cje_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ñu 'buh lơngì pơh tơbiă, sơ̆ng hũ phơ̆n hơgĕ mơhiơ̆ yơu sa blah khăn prŏng, akă tơ pà gah akiăng, hũ pơtrŭn truh tơ ala lơ̆n. ");
INSERT INTO cje_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Lăm khăn nư̆n hũ tơ̆l abih tơgrơ̆ jơi-phơ̆n pà gah tơkai, du jơi-phơ̆n rơwơi lăm ala lơ̆n, sơ̆ng jơi c̆ĭm tơ ngŏ lơngì. ");
INSERT INTO cje_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Bloh nư̆n ñu mơhư̆ hũ săp đờm sơ̆ng ñu: “Ơ Pier, tơgồ bĕ, ngă rơlo bloh 'bơ̆ng.” ");
INSERT INTO cje_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pier đờm: “Khoai Yàng, 'buh jiơ̆ng ơu, kơyoa anà 'buh tŭ lơi 'bơ̆ng du jơi-phơ̆n hơgĕ sơŭ-sơnoh halài 'buh goh-sơc̆ih.” ");
INSERT INTO cje_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Săp nư̆n đờm sơ̆ng ñu amăng dua wơ̆: “Phơ̆n hơgĕ Yàng Pô Lơngì hũ ngă tơ sơc̆ih-goh, nư̆n juơi c̆ơ la sơŭ-sơnoh.” ");
INSERT INTO cje_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Bruă nư̆n tơbiă truh klơu amăng, bloh nư̆n phơ̆n mơhiơ̆ yơu khăn prŏng hũ sơrùi đì wơ̆ tơ ngŏ lơngì. ");
INSERT INTO cje_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Lăm tŭ Pier dò sơnư̆ng-bơngoàn tô wờng thơu mư̆ng pơnuaĭ Yàng hũ brơi pơ'buh tơ drơi mơblàng la hơgĕ, nư̆n dih, du mơnih bloh Kornai hũ pơđăr nau kŭng tơnia duah hũ sàng Simôn bơjơ, sơ̆ng tŭ nư̆n buơl guñu dò dơ̆ng tơ anaŭ bơh 'băng. ");
INSERT INTO cje_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Buơl guñu pồ săp tơnia hũ iơŭ Simôn, kŭng angăn la Pier, dò tơ anih ni ơu. ");
INSERT INTO cje_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Lăm tŭ Pier dò sơnư̆ng-bơngoàn mư̆ng pơnuaĭ Yàng hũ brơi pơ'buh, nư̆n Bơngă Sơc̆ih-Sri đờm sơ̆ng ñu: “Dih, hũ klơu aràng mơnih dò duah anà. ");
INSERT INTO cje_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Tơgồ dơ̆ng bĕ, trŭn nau sơ̆ng buơl guñu, juơi sơnư̆ng-huơĭ hơgĕ, kơyoa rùp-phŭn Kơu hũ pơđăr buơl guñu truh.” ");
INSERT INTO cje_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pier trŭn nau tòm du mơnih nư̆n sơ̆ng đờm: “Dơlhă ni la rùp-phŭn mơnih buơl kơi dò duah. Yòng tơnia, buơl kơi truh anih ni hũ bruă hơgĕ rơi?” ");
INSERT INTO cje_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Buơl guñu đờm sơđồ: “Kornai, mơnih apăn-akŏ sa rơtùh lĭng, la sa aràng mơnih tơpă-siàm sơ̆ng duh-huơĭ Yàng Pô Lơngì, hũ abih buơl làng Juđa ngă grơh siàm. Ñu hũ sa aràng mơnih gơdrưh sơc̆ih-sri ba pơto, pơđăr păl duah kơi sơ̆ng jà kơi mơrai tơ sàng, tô păng du pơnuaĭ kơi pơto-pơđăr.” ");
INSERT INTO cje_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Pier jà buơl guñu tơma lăm sàng, sơ̆ng jà buơl guñu dò pơgleh mơlăm tơ anih nư̆n. Hơrơi hơdơi, Pier tơgồ nau sơ̆ng buơl guñu. Kŭng hũ du adơi-ai mư̆ng Jôppe nau găm rơi. ");
INSERT INTO cje_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Hơrơi hơdơi wơ̆, buơl guñu truh tơ Sesare. Tŭ nư̆n, Kornai hũ jà du gơŭ-pơtiàn, du adơi-ai gơŭ lơđăp-mừng biă sơ̆ng ñu, pơgùm-pơtòm gơŭ dò c̆àng lờih lăm sàng. ");
INSERT INTO cje_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Tŭ Pier pơrpa tơma, nư̆n Kornai tơbiă nau rò, sơ̆ng pơđih rùp tơ ala tơkai Pier bloh dơlbăt. ");
INSERT INTO cje_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Bloh Pier đơ̆ng ñu tơgồ sơ̆ng đờm: “Yòng kơi tơgồ dơ̆ng bĕ. Rùp-phŭn dơlhă ni kŭng mĭn la mơnih bơhiàn soh.” ");
INSERT INTO cje_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Hơdơi tŭ đờm glai sơ̆ng Kornai, Pier nau tơma lăm sàng, 'buh lô mơnih dò pơgùm-pơtòm gơŭ tơ anih nư̆n. ");
INSERT INTO cje_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Pier đờm sơ̆ng buơl guñu: “Buơl kơi kŭng thơu la mơnih Juđa 'buh hũ gơnuăr nau-mơrai halài tơma lăm sàng mơnih buơl làng agàh. Bloh Yàng Pô Lơngì hũ brơi dơlhă thơu lài dơlhă 'buh hũ gơnuăr angăn aràng sơi la sơŭ-sơnoh halài 'buh goh-sơc̆ih. ");
INSERT INTO cje_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Kơyoa nư̆n, tŭ hũ jà nư̆n dơlhă mơrai truh mư, 'buh kơmlah-huơĭ hơgĕ. Yơu nư̆n dơlhă yòng tơnia, kơyoa mư̆ng pơnuaĭ hơgĕ bloh buơl kơi jà dơlhă truh tơ anih ni?” ");
INSERT INTO cje_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kornai đờm sơđồ: “Pà hơrơi dơlhơu, kŭng pơgăp jơ ni rơi, nư̆n la pơgăp klơu jơ diơŭ, dơlhă dò iơu-lài lăm sàng, phŭ-phă hũ sa aràng mơnih c̆ù ào kơc̆rà sơrdah, tơbiă truh dò dơ̆ng tơ anaŭ dơlhă. ");
INSERT INTO cje_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Mơnih nư̆n đờm: ‘Ơ Kornai, pơnuaĭ hã iơu-lài hũ Yàng Pô Lơngì păng bơjơ, sơ̆ng bruă hã brơi-soh dŏng mơnih pơkơ̆n hũ Pô sơdơ̆r truh. ");
INSERT INTO cje_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Yơu nư̆n, hã pơđăr bĕ mơnih truh tơ Jôppe, jà Simôn, angăn la Pier truh tơ anih ni. Mơnih nư̆n tŭ ni dò lăm sàng Simôn, mơnih khờh ngă kơlì, sàng dò jĕ tơ gah ia-tơsì.’ ");
INSERT INTO cje_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Lăm tơk dơlhă pơđăr mơnih truh jà kơi, sơ̆ng kơi hũ hơtai-hơtiàn siàm truh tơ anih ni. Yơu nư̆n tŭ ni, abih buơl dơlhă dò tơ anaŭ Yàng Pô Lơngì, tô păng tơgrơ̆ pơnuaĭ Yàng hũ kơkơi-pơđăr kơi đờm tơ buơl dơlhă.” ");
INSERT INTO cje_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pier pơh kàng đờm sơ̆ng buơl guñu: “Iơŭ biă, dơlhă thơu Yàng Pô Lơngì 'buh c̆ơ prŏng-màng tơ mơnih ni halài c̆ơ 'buh sơ̆p tơ mơnih dih ơu, ");
INSERT INTO cje_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","bloh lăm abih tơgrơ̆ buơl làng, yah aràng sơi duh-huơĭ Yàng sơ̆ng ngă pơnuaĭ rĭng-tơpă, nư̆n hũ siàm hơtai Yàng. ");
INSERT INTO cje_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Nư̆n la pơnuaĭ Pô hũ đờm sơ̆ng anà-tơc̆o Israel, tŭ pơto-akhàn Pơnuaĭ-Siàm mư̆ng pơnuaĭ rĭng-lơngai kơyoa Yàng Jêsu Krist, la Yàng abih tơgrơ̆ mơnih. ");
INSERT INTO cje_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Buơl kơi hũ thơu loh-làng bruă hũ tơbiă truh lăm abih c̆àr Juđe, tơma c̆ơmrừp mư̆ng c̆àr Galile, hơdơi tŭ Jăng hũ pơto-akhàn mư̆ng pơnuaĭ 'baptem. ");
INSERT INTO cje_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Hơyơu lơi Yàng Pô Lơngì hũ lŭ mơñà tơ Yàng Jêsu mơnih Nasaret sơ̆ng Yàng Bơngă Sơc̆ih-Sri sơ̆ng gơnăp-gơnuăr, bloh nư̆n Pô nau mư̆ng anih ni truh anih dih ngă bruă siàm sơ̆ng pơsồ-pơsaih tơ abih tơgrơ̆ mơnih kơđòng kơmlài-jĭnràk mă pơkơŭ-pơđăr, kơyoa Yàng Pô Lơngì dò sơ̆ng Pô. ");
INSERT INTO cje_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Buơl dơlhă la du mơnih ngă grơh mư̆ng abih tơgrơ̆ bruă Pô hũ ngă lăm Juđe sơ̆ng Jerusalem. Guñu hũ yuăl Pô tơ ngŏ kơyơu pơkăl bloh pơmơtai. ");
INSERT INTO cje_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Bloh klơu hơrơi hơdơi, Yàng Pô Lơngì hũ ngă tơ Pô hơdiŭ wơ̆ sơ̆ng tơbiă pơ'buh, ");
INSERT INTO cje_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","'buh iơŭ tơ abih buơl làng, bloh tơ buơl dơlhă, la du mơnih ngă grơh bloh Yàng Pô Lơngì hũ pơlih-rơwah mư̆ng dơlhơu, nư̆n la du mơnih hũ 'bơ̆ng hũ mơñŭm sơ̆ng Pô, hơdơi tŭ Pô mư̆ng pơnuaĭ mơtai hơdiŭ wơ̆. ");
INSERT INTO cje_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Pô hũ pơto-pơđăr buơl dơlhă păl pơto-akhàn tơ buơl làng, sơ̆ng ngă grơh lài Pô la rùp-phŭn Pơtau Yàng Pô Lơngì hũ rơwah-pồ ngă Gơnuăr C̆ahrơña, tô c̆ahrơña mơnih hơdiŭ sơ̆ng mơnih mơtai. ");
INSERT INTO cje_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Abih tơgrơ̆ mơnih gơnuăr-hwơ̆r hũ ngă grơh mư̆ng Pô lài yah aràng sơi păng-tui Pô nư̆n gơnừm tơ angăn Pô bloh hũ anĭt toh-luơi glài-sơnoh.” ");
INSERT INTO cje_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Tŭ Pier dò đờm, nư̆n Yàng Bơngă Sơc̆ih-Sri trŭn tơ ngŏ abih tơgrơ̆ mơnih dò păng pơnuaĭ Yàng. ");
INSERT INTO cje_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Du mơnih păng-tui Yàng hũ ngă adăt koh kơlì, la du mơnih nau găm sơ̆ng Pier, mă ngă krơi-takơtuă biă, kơyoa 'buh Yàng Pô Lơngì kŭng brơi Yàng Bơngă Sơc̆ih-Sri trŭn tơ ngŏ du mơnih buơl làng agàh rơi, ");
INSERT INTO cje_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","kơyoa buơl guñu mơhư̆ tơgrơ̆ mơnih ni đờm du ia pơkơ̆n sơ̆ng mơyòm-pơglòng Yàng Pô Lơngì. ");
INSERT INTO cje_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Tŭ nư̆n Pier đờm: “Aràng sơi hũ rơgơi kơmlah 'buh brơi du mơnih ni đồ-mă pơnuaĭ 'baptem sơ̆ng ia, la du mơnih hũ đồ-mă Yàng Bơngă Sơc̆ih-Sri kŭng mơhiơ̆ yơu buơl gudrơi hũ đồ-mă ơu?” ");
INSERT INTO cje_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Bloh nư̆n Pier pơđăr ngă 'baptem tơ buơl guñu lăm angăn Yàng Jêsu Krist. Hơdơi mư̆ng nư̆n, buơl guñu jà Pier dò wơ̆ sơ̆ng buơl guñu du hơrơi tra. pơnuaĭ siàm tui Kơu. ");
INSERT INTO cje_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Tŭ nư̆n, du mơnih tơdi-tơdài sơ̆ng du buơl adơi-ai dò lăm c̆àr Juđe hũ păng mơhư̆ buơl làng agàh kŭng hũ đồ-mă Pơnuaĭ Yàng Pô Lơngì. ");
INSERT INTO cje_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Nư̆n bloh, tŭ Pier đì tơ Jerusalem, du mơnih păng-tui Yàng hũ ngă adăt sơkaŭ-kơlì, đờm yuăm 'buah tơ Pier lài: ");
INSERT INTO cje_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Kơi hũ tơma lăm sàng du mơnih 'buh ngă adăt sơkaŭ-kơlì bloh 'bơ̆ng huă găm sơ̆ng buơl guñu!” ");
INSERT INTO cje_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Nư̆n Pier đờm mơblàng tơ buơl guñu thơu mư̆ng abih tơgrơ̆ bruă hũ tơbiă truh hơyơu lơi, tui daŭ-rơnaŭ dơlhơu-hơdơi. Pier đờm: ");
INSERT INTO cje_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Tŭ dơlhă dò iơu-lài lăm plơi-prŏng Jôppe, nư̆n dơlhă 'buh sa pơnuaĭ Yàng brơi pơ'buh. Dơlhă 'buh sa phơ̆n hơgĕ mơhiơ̆ yơu sa blah khăn prŏng, akă tơ pà gah akiăng, mư̆ng ngŏ lơngì pơtrŭn truh tơ anaŭ dơlhă. ");
INSERT INTO cje_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Dơlhă c̆ơ nĭ-nùn, 'buh lăm nư̆n hũ du jơi-phơ̆n pà gah tơkai, du jơi-phơ̆n dò lăm glai, du jơi rơwơi lăm ala lơ̆n sơ̆ng du jơi c̆ĭm ngŏ lơngì. ");
INSERT INTO cje_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Dơlhă kŭng mơhư̆ hũ săp đờm pơđăr dơlhă: ‘Ơ Pier, tơgồ dơ̆ng bĕ, ngă rơlo bloh 'bơ̆ng.’ ");
INSERT INTO cje_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Dơlhă đờm sơđồ: ‘Khoai Yàng, 'buh jiơ̆ng ơu. Kơyoa du phơ̆n hơgĕ sơŭ-sơnoh sơ̆ng 'buh sơc̆ih-goh, rơŭ 'buh tŭ lơi tơma lăm kàng dơlhă ơu!’ ");
INSERT INTO cje_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Bloh hũ săp mư̆ng ngŏ lơngì đờm sơ̆ng dơlhă amăng dua lài: ‘Juơi c̆ơ du phơ̆n hơgĕ Yàng Pô Lơngì hũ ngă sơc̆ih-goh la sơŭ-sơnoh!’ ");
INSERT INTO cje_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Pơnuaĭ nư̆n đờm nau-mơrai klơu amăng yơu nư̆n, bloh nư̆n abih tơgrơ̆ phơ̆n hũ sơrùi đì wơ̆ tơ ngŏ lơngì. ");
INSERT INTO cje_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Kŭng iơŭ lăm tŭ nư̆n, klơu aràng mơnih mư̆ng Sesare hũ aràng pơđăr truh sơ̆ng dơlhă, kŭng hũ truh dò dơ̆ng tơ anaŭ bơh 'băng anih sàng dơlhă dò. ");
INSERT INTO cje_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Yàng Bơngă pơđăr dơlhă păl nau sơ̆ng klơu aràng mơnih nư̆n, juơi sơnư̆ng-huơĭ hơgĕ. Năm aràng buơl adơi-ai ni kŭng nau găm sơ̆ng dơlhă rơi, sơ̆ng buơl dơlhă tơma lăm sàng Kornai. ");
INSERT INTO cje_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Mơnih ni đờm akhàn wơ̆ tơ buơl dơlhă thơu mư̆ng bruă hơyơu ñu hũ 'buh sa aràng mơnih gơdrưh dò dơ̆ng lăm sàng ñu sơ̆ng đờm pơđăr ñu: ‘Pơđăr bĕ mơnih nau truh tơ plơi-prŏng Jôppe, jà rò Simôn kŭng angăn la Pier. ");
INSERT INTO cje_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Mơnih nư̆n rơŭ đờm tơ hã du pơnuaĭ, tô gơnừm tơ du pơnuaĭ nư̆n, hã sơ̆ng abih sàng-dơnò hã rơŭ hũ dŏng-pơklàh.’ ");
INSERT INTO cje_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Tŭ dơlhă pơrpa tơma đờm, nư̆n Yàng Bơngă Sơc̆ih-Sri trŭn tơ ngŏ buơl guñu, kŭng yơu tŭ c̆ơmrừp Pô hũ trŭn tơ ngŏ buơl gudrơi rơi. ");
INSERT INTO cje_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Dơlhă sơdơ̆r wơ̆ pơnuaĭ Yàng hũ đờm: ‘Jăng hũ ngă pơnuaĭ 'baptem sơ̆ng ia, bloh buơl guhã rơŭ hũ 'baptem sơ̆ng Yàng Bơngă Sơc̆ih-Sri.’ ");
INSERT INTO cje_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Yơu nư̆n, yah Yàng Pô Lơngì hũ brơi tơ buơl guñu găm sa pơnuaĭ brơi-soh yơu Pô hũ brơi tơ buơl gudrơi tŭ buơl gudrơi păng-tui Yàng la Yàng Jêsu Krist, nư̆n dơlhă la aràng sơi bloh khĭn pơkơŭ-c̆ơkhă Yàng Pô Lơngì?” ");
INSERT INTO cje_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Tŭ mơhư̆ du pơnuaĭ nư̆n, buơl guñu luơi 'buh đờm yuăm 'buah tra, bloh nư̆n mơyòm-pơglòng Yàng Pô Lơngì lài: “Yơu nư̆n, Yàng Pô Lơngì kŭng hũ brơi pơnuaĭ mơbai prah-luơi glài-sơnoh tơ du buơl làng agàh, tô buơl guñu kŭng hũ pơnuaĭ hơdiŭ rơi!” ");
INSERT INTO cje_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Tŭ nư̆n, du mơnih kơđòng kơprah-kơprĭng kơyoa pơnuaĭ mă-pơkơŭ tơbiă truh hơdơi tơ bruă Etien, nau truh tơ c̆àr Phenesi, aguăn ia-tơsì C̆iprơ sơ̆ng plơi-prŏng Antiôt, bloh buơl guñu mĭn pơto-akhàn Pơnuaĭ-Siàm tơ du mơnih Juđa soh. ");
INSERT INTO cje_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Bloh lăm tơrpuơl du mơnih nư̆n, hũ du mơnih plơi-phŭn lăm C̆iprơ sơ̆ng Siren; du mơnih ni, tŭ truh tơ Antiôt, kŭng pơto-akhàn tơ mơnih Grek rơi, pơto-akhàn Pơnuaĭ-Siàm mư̆ng Yàng Jêsu tơ buơl guñu. ");
INSERT INTO cje_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Tơngàn Yàng dò sơ̆ng buơl guñu, nư̆n hũ lô mơnih păng-tui sơ̆ng gài mơrai wơ̆ sơ̆ng Yàng. ");
INSERT INTO cje_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Mơhư̆ thơu pơnuaĭ nư̆n, Tơrpuơl Goh-Sơc̆ih tơ Jerusalem pồ-pơđăr 'Banaba truh tơ plơi-prŏng Antiôt. ");
INSERT INTO cje_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Tŭ truh anih sơ̆ng 'buh pơnuaĭ anĭt-brơi-soh Yàng Pô Lơngì yơu nư̆n, 'Banaba sờh-sài sơ̆ng pơto-kơkơi tơgrơ̆ mơnih păl kừ kơjăp hơtai-hơtiàn tui Yàng. ");
INSERT INTO cje_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Kơyoa 'Banaba la mơnih siàm, baŭ-bèng Yàng Bơngă Sơc̆ih-Sri sơ̆ng pơnuaĭ păng-tui, nư̆n hũ lô mơnih rơlau wơ̆ păng-tui Yàng. ");
INSERT INTO cje_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Hơdơi mư̆ng nư̆n, 'Banaba nau truh tơ Tarsơ tô duah Sol. ");
INSERT INTO cje_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Tŭ duah păp hũ Sol bơjơ, ñu ba Sol truh tơ plơi-prŏng Antiôt. Lăm luĭ sa thŭn, dua aràng buơl guñu pơjŭm-pơtòm sơ̆ng Tơrpuơl Goh-Sơc̆ih sơ̆ng pơto-mơblàng lô mơnih. Nư̆n la tơ plơi-prŏng Antiôt, aràng tơma angăn du mơnih tui-mơgru Yàng la “Mơnih Pô Krist.” ");
INSERT INTO cje_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Lăm du hơrơi nư̆n, hũ du mơnih gơnuăr-hwơ̆r mư̆ng Jerusalem trŭn tơ Antiôt. ");
INSERT INTO cje_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Sa aràng lăm buơl guñu angăn la Agabus; hũ Bơngă Sơc̆ih-Sri ba-pơto, ñu tơgồ dơ̆ng đờm brơi thơu dơlhơu lài rơŭ hũ sa pơnuaĭ ờ-lơpa prŏng tơbiă truh lăm abih dun-ya. Biă yơu nư̆n, pơnuaĭ ờ-lơpa ni hũ tơbiă truh lăm rài pơtau Klôdơ apăn-akŏ. ");
INSERT INTO cje_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Du mơnih tui-mơgru ngă-nìn, yàu aràng tui sơ̆ng pràn drơi hũ, rơŭ pơyoa sa-sĭt phơ̆n-priă dŏng-kờl du buơl adơi-ai dò lăm c̆àr Juđe. ");
INSERT INTO cje_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Buơl guñu hũ ngă jiơ̆ng bruă nư̆n, gơnừm tơ tơngàn 'Banaba sơ̆ng Sol apăn truh tơ du mơnih gơnuăr-tha. ");
INSERT INTO cje_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Lăm tŭ nư̆n, pơtau Herôt ngă jơhà biă tơ du mơnih lăm Tơrpuơl Goh-Sơc̆ih. ");
INSERT INTO cje_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Pơtau pơđăr koh akŏ Jakơ, la sơ-ai Jăng. ");
INSERT INTO cje_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Tŭ 'buh bruă nư̆n ngă siàm hơtai buơl làng Juđa, pơtau kŭng pơđăr mă găm Pier rơi. Bruă nư̆n tơbiă truh iơŭ lăm du hơrơi pơjŭm 'bơ̆ng Pah 'Buh Hũ Tơpơi. ");
INSERT INTO cje_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Hơdơi tŭ mă hũ Pier, pơtau mă krơ̆ ñu lăm sàng jàm, sơ̆ng jào tơ pà tơrpuơl lĭng ala gơŭ kraŭ-khiă, yàu tơrpuơl pà aràng. Pơtau ngă-nìn hơdơi pơnuaĭ pơjŭm 'bơ̆ng Nau-Găn, rơŭ ba Pier tơbiă tô c̆ahrơña tơ anaŭ buơl làng. ");
INSERT INTO cje_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Lăm tŭ Pier kơđòng jàm-krơ̆ yơu nư̆n, Tơrpuơl Goh-Sơc̆ih abih hơtai-hơtiàn iơu-lài mĭt sơ̆ng Yàng Pô Lơngì tơ ñu. ");
INSERT INTO cje_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Bloh, lăm mơlăm dơlhơu tơ hơrơi Herôt ba Pier tơbiă tô c̆ahrơña, Pier dò đih tơkrah dua aràng mơnih lĭng, kơđòng akă sơ̆ng dua dĕng tơlơi srĕng. Tŭ nư̆n, tơ anaŭ bơh 'băng sàng jàm hũ du mơnih lĭng dò kraŭ-khiă nĭ-nùn. ");
INSERT INTO cje_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Phŭ-phă, sa aràng mơnih gơdrưh Yàng tơbiă truh, pơnuaĭ sơrdah pơsàng kơc̆rà lăm abih adŭ jàm. Mơnih gơdrưh pờng tơ rơsŭ Pier, blơ̆ ñu tơgồ sơ̆ng đờm: “Tơgồ sơmăr bĕ!” Sơ̆ng du tơlơi srĕng tơsuă abih klàh mư̆ng tơngàn ñu. ");
INSERT INTO cje_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Mơnih gơdrưh đờm: “Akă tơlơi kơ-iăng sơ̆ng juă kơlì-juă bĕ.” Pier ngă tui. Mơnih gơdrưh đờm wơ̆: “C̆ù bĕ ào agàh sơ̆ng nau tui kơu.” ");
INSERT INTO cje_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pier nau tui mơnih gơdrưh tơbiă tơ agàh, bloh 'buh thơu bruă mơnih gơdrưh ba ñu nau la biă, ñu kừ sơnư̆ng lài drơi 'buh pơnuaĭ brơi pơ'buh. ");
INSERT INTO cje_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Tŭ nau klàh anih kraŭ-khiă c̆ơmrừp, bloh nư̆n truh anih kraŭ-khiă dua, nư̆n truh tơ bơh 'băng pơsơi ba tơma lăm plơi-prŏng. Bơh 'băng nư̆n pơh tơ ñu tơ anaŭ dua aràng, sơ̆ng buơl guñu tơbiă truh tơ agàh jơlàn prŏng. Nau sơ̆ng gơŭ abih sa ơwĕt jơlàn, bloh nư̆n phŭ-phă mơnih gơdrưh luơi Pier bloh nau. ");
INSERT INTO cje_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Tŭ nư̆n ka Pier mơdơh sơdơ̆r wơ̆ sơ̆ng đờm: “Tŭ ni dơlhă thơu nìn-kơjăp biă la Yàng hũ pơđăr mơnih gơdrưh Pô truh dŏng-tơleh dơlhă klàh mư̆ng tơngàn Herôt, sơ̆ng klàh mư̆ng tơgrơ̆ pơnuaĭ buơl làng Juđa dò kraŭ-c̆àng.” ");
INSERT INTO cje_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Tŭ hũ kràn sơnư̆ng jiơ̆ng pơnuaĭ nư̆n, Pier nau sơmăr mư truh tơ sàng Mari, ame Jăng, kŭng hũ angăn la Mak. Tơ anih ni, hũ lô mơnih dò pơtòm-pơjŭm wơ̆ sơ̆ng iơu-lài. ");
INSERT INTO cje_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pier tơtoh bơh 'băng agàh, sa aràng mơnih kơmơi dŏng bruă angăn la Rôda, đuaĭ truh păng-suơ̆. ");
INSERT INTO cje_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Kràn thơu săp Pier, ñu sờh-sài biă tơ̆l truh wơ̆rglai pơh bơh 'băng, bloh tơmbah-tơmbàn đuaĭ tơma đờm akhàn wơ̆ sơ̆ng tơgrơ̆ mơnih thơu lài Pier dò dơ̆ng tơ anaŭ bơh 'băng. ");
INSERT INTO cje_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Bloh du mơnih nư̆n đờm: “Hã hơnrui bơjơ!” Bloh ñu kừ đờm nìn-kơjăp nư̆n la biă. Buơl guñu đờm: “Hũ rơgơi nư̆n la mơnih gơdrưh ñu.” ");
INSERT INTO cje_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Bloh Pier kừ sơđaŭ tơtoh bơh 'băng, sơ̆ng tŭ buơl guñu pơh bơh 'băng, 'buh Pier, buơl guñu takơtuă biă. ");
INSERT INTO cje_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pier mă tơngàn ngă nàl pơđăr buơl guñu dò kơđơ̆ng, bloh nư̆n đờm akhàn wơ̆ tơ buơl guñu păng bruă Yàng hũ dŏng-tơleh drơi tơbiă mư̆ng sàng jàm hơyơu lơi. Pier đờm: “Yòng đờm brơi tơ Jakơ sơ̆ng buơl adơi-ai thơu mư̆ng bruă ni.” Hơdơi mư̆ng nư̆n, Pier tơbiă nau sơ̆ng truh tơ sa anih pơkơ̆n. ");
INSERT INTO cje_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Truh glai ờm, hũ pơnuaĭ sơlŭng-sơlăng klùk-klờk prŏng tơkrah buơl lĭng, kơyoa buơl guñu 'buh thơu bruă hơgĕ hũ tơbiă truh tơ Pier. ");
INSERT INTO cje_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herôt pơđăr nau duah Pier lăm abih tơgrơ̆ anih, bloh 'buh duah hũ. Pơtau tơnia-khào du mơnih lĭng kraŭ-khiă, bloh nư̆n pơđăr ba buơl guñu nau pơmơtai abih. Hơdơi mư̆ng nư̆n, pơtau luơi c̆àr Juđe trŭn tơ Sesare, sơ̆ng dò wơ̆ tơ anih nư̆n. ");
INSERT INTO cje_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Tŭ nư̆n, Herôt anok hơtai biă tơ buơl làng Tirơ sơ̆ng Siđôn; nư̆n, buơl guñu sa hơtai sơ̆ng gơŭ truh tòm pơtau. Hơdơi tŭ angui phơ̆n-priă blơi hũ hơtai-hơtiàn Blastơ, la mơnih gơnuăr prŏng dò jĕ sơ̆ng pơtau, buơl guñu truh sơ̆ng pơtau bloh yòng pơhơlàr-tămsòr, kơyoa lơgăr buơl guñu hơdiŭ gơnừm tơ phơ̆n-kơya 'bơ̆ng blơi mư̆ng lơgăr pơtau. ");
INSERT INTO cje_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Truh iơŭ hơrơi hũ ngă-nìn, Herôt c̆ù khăn-ào pơtau, dò guh tơ ngŏ sơbàn, đờm glai sơ̆ng buơl guñu. ");
INSERT INTO cje_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Buơl làng driau prŏng đờm: “Ni la săp đờm yàng, 'buh iơŭ la săp anà mơnih bơhiàn ơu.” ");
INSERT INTO cje_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Lăm tơk tŭ nư̆n mư, sa aràng mơnih gơdrưh Yàng ngă pơtau Herôt, kơyoa pơtau 'buh pioh pơnuaĭ màng-kơc̆rà tơ Yàng Pô Lơngì. Pơtau kơđòng hơlă 'bơ̆ng hơluh pruaĭ bloh mơtai. ");
INSERT INTO cje_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Tŭ nư̆n, pơnuaĭ Yàng Pô Lơngì kừ sơđaŭ đì-tơgồ sơ̆ng 'brŏ hơrơi 'brŏ prŏng-lơnàng rơlau. ");
INSERT INTO cje_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Hơdơi tŭ ngă wĭl-tơ̆l gơnuăr bruă hũ jào, 'Banaba sơ̆ng Sol mư̆ng Jerusalem gài mơrai wơ̆ tơ Antiôt, ba tui găm Jăng, kŭng angăn la Mak. ");
INSERT INTO cje_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Lăm Tơrpuơl Goh-Sơc̆ih tơ Antiôt, hũ du mơnih gơnuăr-hwơ̆r sơ̆ng du pô-pơto. Nư̆n la 'Banaba, Simeôn kŭng angăn la Nije, Lusius mơnih Siren, Manahen, la mơnih adơi-ai gơŭ sơ̆ng pơtau Herôt rơh dò lơ-ơneh, sơ̆ng Sol. ");
INSERT INTO cje_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Lăm tŭ buơl guñu duh-dơlbăt Yàng sơ̆ng wèr 'bơ̆ng, nư̆n Yàng Bơngă Sơc̆ih-Sri đờm: “Pioh krơi bĕ 'Banaba sơ̆ng Sol tơ Kơu, tô ngă gơnuăr-bruă Kơu hũ iơu-rơwah buơl guñu ngă.” ");
INSERT INTO cje_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Hơdơi tŭ wèr 'bơ̆ng sơ̆ng iơu-lài, buơl guñu daŭ tơngàn tơ ngŏ dua aràng sơ̆ng pơđăr nau. ");
INSERT INTO cje_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Hũ Yàng Bơngă Sơc̆ih-Sri pơđăr nau, 'Banaba sơ̆ng Sol trŭn tơ plơi-prŏng Selơsi, bloh nư̆n, mư̆ng nư̆n đì ahò truh tơ aguăn ia-tơsì C̆iprơ. ");
INSERT INTO cje_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Tŭ truh tơ Salamin, buơl guñu pơto-akhàn Pơnuaĭ Yàng Pô Lơngì lăm du sàng pơtòm mơnih Juđa. Kŭng hũ Jăng nau tui tô dŏng buơl guñu rơi. ");
INSERT INTO cje_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Buơl guñu nau lăm abih aguăn ia-tơsì tơ̆l truh tơ Paphô. Tơ anih ni buơl guñu păp sa aràng mơnih Juđa dih, la mơnih pơjơu sơ̆ng gơnuăr-hwơ̆r lơ̆r, angăn mơta ñu la Barjesu. ");
INSERT INTO cje_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Mơnih pơjơu nư̆n dò sơ̆ng kwăng apăn-akŏ du c̆àr lăm lơgăr, angăn la Sejus Pôlus, la sa aràng mơnih jak-khờh biă. Mơnih kwăng nư̆n pơđăr jà 'Banaba sơ̆ng Sol truh, tô đờm tơ ñu păng mư̆ng Pơnuaĭ Yàng Pô Lơngì. ");
INSERT INTO cje_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Bloh mơnih pơjơu nư̆n, angăn tui ia Grek la Elima, tămdră-wơ̆ sơ̆ng dua aràng buơl guñu, duah tơ̆l pơnuaĭ tô pơklah-c̆ơkhă 'buh brơi kwăng apăn-akŏ du c̆àr lăm lơgăr păng-tui Yàng. ");
INSERT INTO cje_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Tŭ nư̆n, Sol kŭng angăn la Pôl, hũ baŭ-bèng Yàng Bơngă Sơc̆ih-Sri, c̆ơ tơpă tơ mơnih pơjơu nư̆n sơ̆ng đờm: ");
INSERT INTO cje_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Hã la anà-tơc̆o kơmlài-kơmloh, mơnih mơbai-tămdră sơ̆ng tơgrơ̆ pơnuaĭ rĭng-tơpă, baŭ-bèng pơnuaĭ blơ̆ lơ̆r sơ̆ng mơsak-jơhà! Hã hũ pơdơh luơi mư bruă ngă we-wăng du jơlàn tơpă Yàng ơu? ");
INSERT INTO cje_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ni, tŭ ni tơngàn Yàng ngă glài hã. Hã rơŭ kơđòng bồm mơta, 'bu 'buh ia-hơrơi lăm sa-sĭt tŭ-hơrơi.” Lăm tơk tŭ nư̆n mư, pơnuaĭ bồm-mơsrư̆ sơ̆ng mơsrư̆-kơnăm trŭn tơ ngŏ Elima, sơ̆ng ñu păl tămbư rơwơ̆ duah mơnih tô apăn tơngàn dùi ñu nau. ");
INSERT INTO cje_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Mơnih kwăng apăn-akŏ du c̆àr lăm lơgăr 'buh bruă hũ tơbiă truh nư̆n păng-tui, kơyoa ñu mă ngă c̆rih-takơtuă biă mư̆ng jơlàn păng-tui Yàng. ");
INSERT INTO cje_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pôl sơ̆ng du adơi-ai gơŭ nau găm sơ̆ng ñu mư̆ng Paphô đì ahò nau truh tơ Perje lăm c̆àr Pamphili. Tơ anih nư̆n, Jăng luơi dua aràng buơl guñu bloh gài mơrai wơ̆ tơ Jerusalem. ");
INSERT INTO cje_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Dò dua aràng buơl guñu kừ sơđaŭ nau jơlàn, buơl guñu luơi plơi-prŏng Perje sơ̆ng truh tơ Antiôt c̆àr Pisiđi. Truh hơrơi sa'bat, buơl guñu tơma lăm sàng pơtòm sơ̆ng dò guh. ");
INSERT INTO cje_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Hơdơi tŭ pơrpoh-c̆ơ 'bồn bơ-àr pơnuaĭ Adăt-Adia sơ̆ng 'bồn bơ-àr pơnuaĭ Gơnuăr Hwơ̆r, du mơnih apăn-akŏ sàng pơtòm pơđăr mơnih truh đờm sơ̆ng dua aràng buơl guñu: “Ơ buơl adơi-ai, yah buơl adơi-ai hũ pơnuaĭ hơgĕ khiăng đờm pơto-kơkơi buơl làng, nư̆n yòng jà đờm bĕ.” ");
INSERT INTO cje_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pôl tơgồ dơ̆ng, mă tơngàn ngă nàl, bloh nư̆n đờm: “Ơ adơi-ai gơŭ-pơtiàn Israel sơ̆ng du mơnih duh-huơĭ tơ Yàng Pô Lơngì, yòng păng bĕ dơlhă đờm: ");
INSERT INTO cje_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Yàng Pô Lơngì buơl làng Israel ni hũ rơwah kơi-kŏ pàng-yau buơl gudrơi, sơ̆ng ngă tơ buơl làng nư̆n tơbiă jiơ̆ng prŏng-pràn lăm tŭ buơl guñu dò sơdăng lăm lơgăr Ejiptơ, sơ̆ng Pô angui tơngàn gơnăp-gơnuăr ba buơl guñu tơbiă klàh mư̆ng lơgăr nư̆n. ");
INSERT INTO cje_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Sơ̆ng pơgăp pà pluh thŭn, Pô kŏng ă-ư̆n buơl guñu lăm anih 'blàng-jơhua. ");
INSERT INTO cje_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Hơdơi tŭ hũ pơluĭ-pơlơhiă tơjuh buơl làng lăm c̆àr Kanaan, Pô brơi lơ̆n-tơnah nư̆n tơ buơl guñu ngă phŭm-kơsai. ");
INSERT INTO cje_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Abih tơgrơ̆ bruă nư̆n hũ tơbiă truh lăm pà rơtùh lơma pluh thŭn. Hơdơi mư̆ng nư̆n, Pô brơi tơ buơl guñu du mơnih gơnuăr-c̆ahrơña tơ̆l truh tơ rài mơnih gơnuăr-hwơ̆r Samuel. ");
INSERT INTO cje_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Tŭ nư̆n, buơl guñu yòng sa pơtau, nư̆n Yàng Pô Lơngì brơi tơ buơl guñu Sol, anà lơkơi Kis, mơnih lăm jơi-pơtiàn 'Benjamin. Pơtau nư̆n apăn-akŏ buơl guñu lăm pà pluh thŭn. ");
INSERT INTO cje_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Bloh nư̆n Pô luơi Sol sơ̆ng rơwah-pồ Đabit đì ngă pơtau apăn-akŏ buơl guñu. Đabit la mơnih Pô hũ đờm ngă grơh siàm lài: ‘Kơu hũ duah 'buh Đabit anà lơkơi Jese, la mơnih Kơu siàm hơtai, mơnih rơŭ ngă tui tơgrơ̆ hơtai-khiăng Kơu.’ ");
INSERT INTO cje_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Mư̆ng jơi-pơtiàn Đabit, Yàng Pô Lơngì hũ brơi tơ buơl làng Israel sa Pô Dŏng-Pơklàh, nư̆n la Yàng Jêsu, yơu pơnuaĭ Pô hũ đờm pơguăn. ");
INSERT INTO cje_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Dơlhơu tŭ Yàng Jêsu truh, Jăng hũ pơto-akhàn adăt 'baptem mư̆ng pơnuaĭ mơbai prah-luơi glài-sơnoh tơ abih buơl làng Israel. ");
INSERT INTO cje_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Tŭ Jăng kơjĕ ngă wĭl-tơ̆l gơnuăr bruă drơi, Jăng hũ đờm: ‘Buơl kơi sơnư̆ng dơlhă la aràng sơi? Dơlhă 'buh iơŭ la Pô buơl kơi sơnư̆ng ơu, bloh dih hũ Pô truh hơdơi dơlhă, dơlhă 'buh sơ̆p păl tô wà tơlơi kơlì-juă tơ Pô ơu.’ ");
INSERT INTO cje_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Ơ buơl adơi-ai, la anà-tơc̆o jơi-pơtiàn Abraham sơ̆ng la du mơnih duh-huơĭ Yàng Pô Lơngì, pơnuaĭ pơto-akhàn mư̆ng pơnuaĭ dŏng-pơklàh ni hũ pơyoa truh tơ rùp-phŭn buơl gudrơi. ");
INSERT INTO cje_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Kơyoa buơl làng sơ̆ng du mơnih apăn-akŏ buơl guñu lăm Jerusalem 'buh kràn-thơu Yàng Jêsu, kŭng 'buh wờng du pơnuaĭ gơnuăr-hwơ̆r bloh aràng jiăng pơrpoh-c̆ơ lăm yàu hơrơi sa'bat; nư̆n tŭ ngă-nìn glài pơmơtai Pô, buơl guñu hũ ngă tơ du pơnuaĭ gơnuăr-hwơ̆r nư̆n hũ tơbiă iơŭ tơpă. ");
INSERT INTO cje_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Yah 'buh duah hũ pơnuaĭ hơgĕ tô ngă-nìn glài pơmơtai Pô, buơl guñu sơđaŭ yòng lơkơu Pilat pơmơtai Pô. ");
INSERT INTO cje_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Tŭ buơl guñu hũ ngă iơŭ tơbiă biă tơgrơ̆ pơnuaĭ hũ wă mư̆ng Pô bơjơ, nư̆n apăn Pô trŭn mư̆ng kơyơu pơkăl sơ̆ng daŭ Pô lăm sa boh kŭt atơu. ");
INSERT INTO cje_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Bloh Yàng Pô Lơngì hũ ngă tơ Pô hơdiŭ wơ̆ mư̆ng pơnuaĭ mơtai. ");
INSERT INTO cje_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Lăm lô hơrơi, Pô hũ tơbiă pơ'buh sơ̆ng du mơnih nau tui Pô mư̆ng Galile đì tơ Jerusalem, sơ̆ng tŭ ni du mơnih nư̆n dò ngă grơh mư̆ng Pô tơ buơl làng lăm lơgăr. ");
INSERT INTO cje_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Dò buơl dơlhă, nư̆n pơto-akhàn tơ buơl adơi-ai Pơnuaĭ-Siàm bloh Yàng Pô Lơngì hũ đờm pơguăn sơ̆ng kơi-kŏ pàng-yau buơl gudrơi, ");
INSERT INTO cje_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","lài Pô hũ ngă iơŭ tơpă biă pơnuaĭ đờm pơguăn nư̆n tơ buơl gudrơi la anà-tơc̆o buơl guñu, lăm bruă ngă tơ Yàng Jêsu hơdiŭ wơ̆, yơu hũ wă lăm 'bồn bơ-àr Pơđik Adoh Mơyòm tăl dua lài: ‘Anà la Anà lơkơi Kơu, hơrơi ni Kơu hũ pơjiơ̆ng Anà.’ ");
INSERT INTO cje_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Pô hũ ngă tơ Yàng Jêsu hơdiŭ wơ̆ mư̆ng pơnuaĭ mơtai, 'buh tŭ lơi kơđòng brŭ-brăm, yơu pơnuaĭ Pô hũ đờm: ‘Kơu rơŭ brơi tơ buơl anà pơnuaĭ lơngai-siàm sơc̆ih-sri sơ̆ng nìn-kơjăp biă bloh Kơu hũ đờm pơguăn sơ̆ng Đabit.’ ");
INSERT INTO cje_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Kơyoa nư̆n, lăm sa anih pơkơ̆n, kŭng hũ đờm lài: ‘Yàng rơŭ 'buh luơi Pơtau Sơc̆ih-Sri Pô 'buh pơnuaĭ brŭ-brăm.’ ");
INSERT INTO cje_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Kơyoa pơtau Đabit, hơdơi tŭ duh bruă tui hơtai-khiăng sơc̆ih-sri Yàng Pô Lơngì lăm tŭ-rài drơi, pơtau mơtai, hũ dơ̆r jĕ sơ̆ng kơi-kŏ pàng-yau drơi, sơ̆ng rùp-phàp ñu păl kŏng brŭ-brăm. ");
INSERT INTO cje_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Dò Pô bloh Yàng Pô Lơngì hũ ngă hơdiŭ wơ̆, nư̆n 'buh păl brŭ-brăm. ");
INSERT INTO cje_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Yơu nư̆n, ơ buơl adơi-ai, yòng kràn-thơu bĕ lài gơnừm tơ Pô nư̆n bloh pơnuaĭ anĭt toh-luơi glài-sơnoh hũ pơto-akhàn tơ buơl adơi-ai. ");
INSERT INTO cje_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Gơnừm tơ Pô, bloh abih tơgrơ̆ mơnih păng-tui rơŭ hũ angăn la rĭng-tơpă mư̆ng abih tơgrơ̆ bruă bloh yah tui adăt-adia Môise nư̆n 'buh aràng sơi hũ rơgơi angăn la rĭng-tơpă jiơ̆ng. ");
INSERT INTO cje_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Kơyoa nư̆n, buơl adơi-ai păl c̆ơ-kơrhia bĕ mư̆ng tơgrơ̆ pơnuaĭ du mơnih gơnuăr-hwơ̆r hũ đờm, tô tơgrơ̆ pơnuaĭ nư̆n 'buh tơbiă truh sơ̆ng buơl adơi-ai, ");
INSERT INTO cje_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Ơ mơnih jiăng c̆ơ 'buh sơ̆p dih, c̆ơ bĕ, huơĭ-takơtuă sơ̆ng mơtai thĭt bĕ! Kơyoa lăm rài buơl guhã, Kơu rơŭ ngă sa bruă, Yah hũ aràng sơi đờm akhàn wơ̆, buơl guhã kŭng 'buh păng-tui!’ ” ");
INSERT INTO cje_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Tŭ Pôl sơ̆ng 'Banaba nau tơbiă, buơl guñu yòng jà dua aràng đờm pơto-mơblàng wơ̆ mư̆ng du pơnuaĭ nư̆n lăm hơrơi sa'bat hơdơi. ");
INSERT INTO cje_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Hơdơi tŭ tơgrơ̆ mơnih pơjŭm-pơtòm tơbiă nau wơ̆ abih, lô mơnih Juđa sơ̆ng mơnih buơl làng agàh tui jơlàn mơnih Juđa duh-dơlbăt nau tui Pôl sơ̆ng 'Banaba. Pôl sơ̆ng 'Banaba đờm glai sơ̆ng pơto-kơkơi buơl guñu kừ dò dơ̆ng kơjăp lăm pơnuaĭ anĭt-brơi-soh Yàng Pô Lơngì. ");
INSERT INTO cje_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Hơrơi sa'bat hơdơi, kơjĕ abih buơl làng lăm plơi-prŏng pơtòm-pơjŭm gơŭ wơ̆ tô păng Pơnuaĭ Yàng. ");
INSERT INTO cje_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Bloh tŭ mơnih Juđa 'buh tơrpuơl buơl làng lô, nư̆n lăm hơtai-hơtiàn buơl guñu baŭ-bèng pơnuaĭ oàn-mơbai; buơl guñu tămdră-wơ̆ sơ̆ng du pơnuaĭ Pôl pơto-mơblàng sơ̆ng đờm pơtăt-pơmơlơu Pôl. ");
INSERT INTO cje_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Bloh Pôl sơ̆ng 'Banaba hĭl-pràn hơtai-hơtiàn đờm sơ̆ng buơl guñu: “Buơl dơlhă 'buh, păl dơlhơu biă pơto-akhàn pơnuaĭ Yàng Pô Lơngì tơ buơl adơi-ai. Bloh kơyoa buơl adơi-ai hũ kơmlah-luơi, sơ̆ng c̆ơ rùp-phŭn drơi 'buh iơŭ păl tô đồ-mă pơnuaĭ hơdiŭ rài pơdò rài, nư̆n tŭ ni buơl dơlhă pơtrah tơ gah du mơnih buơl làng agàh. ");
INSERT INTO cje_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Kơyoa Yàng hũ đờm pơđăr buơl dơlhă yơu ni: ‘Kơu hũ pồ-pơđăr hã ngă pơnuaĭ sơrdah tơ tơgrơ̆ buơl làng, Tô apăn pơnuaĭ anĭt dŏng-pơklàh truh tơ abih tơgrơ̆ anih lăm dun-ya.’ ” ");
INSERT INTO cje_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Tŭ păng pơnuaĭ ni, du mơnih buơl làng agàh sờh-sài, mơyòm-pơglòng jơlàn păng-tui Pơnuaĭ Yàng, sơ̆ng du mơnih hũ Yàng Pô Lơngì ngă-nìn tô đồ-mă pơnuaĭ hơdiŭ rài pơdò rài, păng-tui Yàng abih. ");
INSERT INTO cje_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Pơnuaĭ Yàng hũ pơto-akhàn lăm abih c̆àr nư̆n. ");
INSERT INTO cje_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Bloh du mơnih Juđa pơsŭt-pơđăr du mơnih kơmơi màng-mơda hũ păng-tui jơlàn mơnih Juđa duh-dơlbăt, sơ̆ng du mơnih apăn-akŏ lăm plơi-prŏng, pơsŭt-pơđăr buơl guñu mă-pơkơŭ Pôl sơ̆ng 'Banaba, sơ̆ng prơh dua aràng tơbiă klàh mư̆ng c̆àr-tơnah buơl guñu. ");
INSERT INTO cje_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Nư̆n Pôl sơ̆ng 'Banaba tơrtuh hơbơu lơ̆n klĕm tơ tơkai drơi tô tămdră-wơ̆ sơ̆ng buơl guñu, bloh nư̆n nau truh tơ plơi-prŏng Ikôni. ");
INSERT INTO cje_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Dò du mơnih tui-mơgru nư̆n hũ baŭ-bèng pơnuaĭ sờh-sài sơ̆ng baŭ-bèng Yàng Bơngă Sơc̆ih-Sri. ");
INSERT INTO cje_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Tơ Ikôni, Pôl sơ̆ng 'Banaba nau tơma lăm sàng pơtòm mơnih Juđa sơ̆ng kŭng pơto-akhàn yơu nư̆n rơi, ngă tơ lô mơnih Juđa sơ̆ng mơnih Grek păng-tui Yàng. ");
INSERT INTO cje_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Bloh du mơnih Juđa 'buh păng-tui nư̆n pơsŭt-pơđăr du mơnih lăm buơl làng agàh, ngă tơ hơtai-akŏ buơl guñu sơnư̆ng jơhà tămdră-wơ̆ sơ̆ng du adơi-ai păng-tui Yàng. ");
INSERT INTO cje_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Kơyoa nư̆n, Pôl sơ̆ng 'Banaba păl dò wơ̆ tơ anih nư̆n suơi hơrơi, hĭl-kơjăp hơtai-hơtiàn pơto-akhàn mư̆ng Yàng, sơ̆ng Yàng angui tơngàn buơl guñu ngă lô pơnuaĭ-c̆rih nàl-krơi tô ngă grơh tơ jơlàn pơnuaĭ anĭt-brơi-soh Pô. ");
INSERT INTO cje_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Bloh buơl làng lăm plơi-prŏng pơklah-krơi ngă dua tơrpuơl: sa tơrpuơl nư̆n tui mơnih Juđa, dò tơrpuơl dih nư̆n tui dua aràng mơnih tơdi-tơdài. ");
INSERT INTO cje_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Tŭ nư̆n, du mơnih buơl làng agàh sơ̆ng mơnih Juđa găm sơ̆ng du mơnih apăn-akŏ buơl guñu, tămbơyai sơ̆ng gơŭ duah pơnuaĭ ngă jơhà-pơmơlơu sơ̆ng prah pơtơu dua aràng mơnih tơdi-tơdài. ");
INSERT INTO cje_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Hũ thơu mư̆ng pơnuaĭ nư̆n, dua aràng mơnih tơdi-tơdài pleh nau tơ Listrơ sơ̆ng Đerbơ, la du plơi-prŏng dò lăm c̆àr Likaoni sơ̆ng du anih tòmdăr c̆àr nư̆n. ");
INSERT INTO cje_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Tơ du anih nư̆n, dua aràng buơl guñu sơđaŭ pơto-akhàn Pơnuaĭ-Siàm. ");
INSERT INTO cje_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Lăm Listrơ hũ sa aràng mơnih dih kơđòng mơtai abih dua gah tơkai, hũ aràng ba truh daŭ dò guh tơ anih nư̆n. Mơnih nư̆n kơđòng joh-je mư̆ng tŭ pơrpa hũ đih apui tơbiă mư̆ng tŭng ame, nư̆n ka tŭ lơi nau jiơ̆ng. ");
INSERT INTO cje_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ñu dò guh păng Pôl pơto-mơblàng. Pôl c̆ơ nĭ-tơpă tơ ñu sơ̆ng 'buh ñu hũ pơnuaĭ păng-tui tô hũ pơsồ-pơsaih, ");
INSERT INTO cje_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","nư̆n đờm prŏng: “Tơgồ dò dơ̆ng tơpă bĕ!” Ñu tơgồ sừp mư sơ̆ng yàm nau. ");
INSERT INTO cje_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Tơrpuơl buơl làng 'buh bruă Pôl hũ ngă, nư̆n driau prŏng sơ̆ng ia Likaoni: “Du yàng hũ mă rùp jơi anà mơnih trŭn sơ̆ng buơl gudrơi!” ");
INSERT INTO cje_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Buơl guñu angăn 'Banaba la yàng Jubite sơ̆ng Pôl la yàng Merkur, kơyoa ñu la mơnih đờm pơto-mơblàng phŭn. ");
INSERT INTO cje_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Mơnih apăn-akŏ pơyă phơ̆n c̆ĕ-dơlbăt tơ yàng Jubite hũ bơmùng tơ agàh plơi-prŏng, apăn lơmo tơno sơ̆ng dwàng-bơnga truh tơ anaŭ bơh 'băng plơi-prŏng, khiăng găm sơ̆ng buơl làng pơyă phơ̆n c̆ĕ-pơyơ̆r duh-dơlbăt tơ du mơnih tơdi-tơdài. ");
INSERT INTO cje_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Hũ mơhư̆ thơu mư̆ng pơnuaĭ nư̆n, dua aràng mơnih tơdi-tơdài la 'Banaba sơ̆ng Pôl hĕt ào drơi, brồ tơma tơkrah tơrpuơl mơnih lô, sơ̆ng đờm prŏng: ");
INSERT INTO cje_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Ơ buơl adơi-ai, kơđa hơgĕ buơl adơi-ai ngă pơnuaĭ nư̆n? Buơl dơlhă mĭn la mơnih bơhiàn mơhiơ̆ yơu buơl adơi-ai rơi. Buơl dơlhă pơto-akhàn Pơnuaĭ-Siàm tô buơl adơi-ai klà luơi du rơ̆p-rùp 'buh kwơ-màng dih bloh gài mơrai wơ̆ sơ̆ng Yàng Pô Lơngì, la Yàng hơdiŭ rài pơdò rài, la Pô hũ c̆rơ̆ng-tơbiă lơngì, lơ̆n-tơnah, ia-tơsì, sơ̆ng abih tơgrơ̆ jơi-phơ̆n lăm nư̆n. ");
INSERT INTO cje_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Lăm du rài dơlhơu, Pô luơi tơ tơgrơ̆ buơl làng nau tui jơlàn-sơnah krơi buơl guñu. ");
INSERT INTO cje_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Bloh yah yơu nư̆n, Pô sơđaŭ mĭt ngă grơh mư̆ng rùp-phŭn drơi sơ̆ng bruă brơi pơnuaĭ lơngai-siàm, ngă hơjàn mư̆ng ngŏ lơngì trŭn, brơi tơ brơñàn-blàn lô bơnga boh, phơ̆n kơya 'bơ̆ng dơlah-dơlài, ngă tơ hơtai-hơtiàn buơl adơi-ai baŭ-bèng pơnuaĭ sờh-sài.” ");
INSERT INTO cje_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Yah dua aràng mơnih tơdi-tơdài đờm abih pơnuaĭ yơu nư̆n bơjơ, bloh kŭng păl gleh-glăr biă nư̆n ka c̆ơkhă-pơkơŭ jiơ̆ng buơl làng pơyă phơ̆n duh-dơlbăt tơ dua aràng buơl guñu. ");
INSERT INTO cje_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Tŭ nư̆n, hũ du mơnih Juđa mư̆ng Antiôt sơ̆ng Ikôni truh, pơsŭt-pơđăr buơl làng. Buơl guñu prah pơtơu Pôl, bloh nư̆n hua Pôl tơbiă tơ agàh plơi-prŏng, kơyoa buơl guñu sơnư̆ng lài Pôl mơtai bơjơ. ");
INSERT INTO cje_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Bloh tŭ du mơnih tui-mơgru truh dò dơ̆ng tòmdăr ñu, nư̆n Pôl tơgồ dơ̆ng sừp mư sơ̆ng nau tơma lăm plơi-prŏng. Hơrơi hơdơi, Pôl nau sơ̆ng 'Banaba truh tơ plơi-prŏng Đerbơ. ");
INSERT INTO cje_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Hơdơi tŭ Pôl sơ̆ng 'Banaba hũ pơto-akhàn Pơnuaĭ-Siàm lăm plơi-prŏng nư̆n sơ̆ng dŏng lô mơnih tơbiă jiơ̆ng mơnih tui-mơgru Yàng, buơl guñu gài mơrai wơ̆ tơ plơi-prŏng Listrơ, plơi-prŏng Ikôni, sơ̆ng plơi-prŏng Antiôt, ");
INSERT INTO cje_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","ngă kơjăp-pràn hơtai-hơtiàn du mơnih tui-mơgru, pơto-kơkơi buơl guñu păng-rơmiă kơjăp pơnuaĭ păng-tui, sơ̆ng đờm lài buơl gudrơi păl kŏng ơnòng lô pơnuaĭ pơđì-pơđoa gleh-glăr nư̆n ka hũ tơma jiơ̆ng lăm lơgăr Yàng Pô Lơngì. ");
INSERT INTO cje_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Hơdơi tŭ rơwah-pồ du mơnih gơnuăr-tha lăm yàu Tơrpuơl Goh-Sơc̆ih, dua ràng mơnih tơdi-tơdài iơu-lài, wèr 'bơ̆ng sơ̆ng jào du mơnih nư̆n tơ Yàng, la Pô drơi păng-gơnừm. ");
INSERT INTO cje_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Dua aràng mơnih tơdi-tơdài nau găn c̆àr Pisiđi bloh truh tơ c̆àr Pamphili. ");
INSERT INTO cje_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Hơdơi tŭ buơl guñu pơto-akhàn Pơnuaĭ Yàng lăm plơi-prŏng Perje, buơl guñu nau trŭn tơ plơi-prŏng Attali. ");
INSERT INTO cje_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Mư̆ng anih nư̆n, buơl guñu đì ahò mơrai wơ̆ tơ Antiôt, la anih mư̆ng dơlhơu buơl guñu hũ jào tơ pơnuaĭ anĭt-brơi-soh Yàng Pô Lơngì, tô ngă gơnuăr bruă bloh buơl guñu pơrpa ngă wĭl-tơ̆l. ");
INSERT INTO cje_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Tŭ truh anih, Pôl sơ̆ng 'Banaba jà abih Tơrpuơl Goh-Sơc̆ih pơtòm-pơjŭm wơ̆, bloh nư̆n đờm akhàn wơ̆ mư̆ng abih tơgrơ̆ bruă Yàng Pô Lơngì hũ ngă găm sơ̆ng buơl guñu, mư̆ng bruă hơyơu lơi Pô hũ pơh bơh 'băng pơnuaĭ păng-tui tơ du buơl làng agàh. ");
INSERT INTO cje_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Dua aràng buơl guñu dò wơ̆ tơ anih nư̆n suơi hơrơi sơ̆ng du mơnih tui-mơgru. ");
INSERT INTO cje_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Hũ du mơnih mư̆ng c̆àr Juđe truh sơ̆ng đờm pơto buơl adơi-ai lài: “Yah adơi-ai 'buh kŏng sơkaŭ-kơlì tui adăt Môise hũ pơto, nư̆n buơl adơi-ai 'buh rơgơi hũ dŏng-pơklàh.” ");
INSERT INTO cje_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pơnuaĭ nư̆n ba truh bruă 'buh sa hơtai sơ̆ng gơŭ, sơ̆ng tơkrah Pôl sơ̆ng 'Banaba sơ̆ng du mơnih nư̆n hũ bruă tămpơrjai-mơsau gơŭ pràn-sơtăng biă. Kơyoa nư̆n, du mơnih tui-mơgru ngă-nìn pồ-pơđăr Pôl sơ̆ng 'Banaba găm sơ̆ng du mơnih ala mơta gah tơrpuơl dih đì nau tơ Jerusalem, truh sơ̆ng du mơnih tơdi-tơdài sơ̆ng du mơnih gơnuăr-tha tô tơnia mư̆ng bruă ni. ");
INSERT INTO cje_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Yơu nư̆n, hơdơi tŭ hũ Tơrpuơl Goh-Sơc̆ih pơrlau nau jơlàn, buơl guñu nau găn c̆àr Phenesi sơ̆ng Samari, đờm-akhàn wơ̆ mư̆ng bruă hơyơu lơi du buơl làng agàh hũ gài mơrai wơ̆ sơ̆ng Yàng, ngă tơ abih buơl adơi-ai dò lăm du anih nư̆n sờh-sài biă. ");
INSERT INTO cje_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Tŭ truh Jerusalem, buơl guñu hũ Tơrpuơl Goh-Sơc̆ih, du mơnih tơdi-tơdài sơ̆ng du mơnih gơnuăr-tha wă-rò, bloh nư̆n buơl guñu đờm akhàn wơ̆ mư̆ng abih tơgrơ̆ bruă Yàng Pô Lơngì hũ ngă găm sơ̆ng buơl guñu. ");
INSERT INTO cje_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Bloh hũ du mơnih lăm tơrpuơl Pharisi hũ păng-tui Yàng, tơgồ dơ̆ng đờm lài: “Păl ngă adăt sơkaŭ-kơlì tơ du mơnih buơl làng agàh păng-tui Yàng, sơ̆ng pơđăr buơl guñu păl păng-rơmiă ngă tui adăt-adia Môise.” ");
INSERT INTO cje_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Du mơnih tơdi-tơdài sơ̆ng du mơnih gơnuăr-tha pơtòm-pơjŭm gơŭ wơ̆ tô c̆ơ bơ-yai mư̆ng bruă ni. ");
INSERT INTO cje_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Hơdơi tŭ đờm tămbơyai nĭ-nùn bơjơ, Pier tơgồ dơ̆ng đờm sơ̆ng buơl guñu: “Ơ buơl adơi-ai, buơl adơi-ai thơu lài mư̆ng du hơrơi c̆ơmrừp, Yàng Pô Lơngì hũ rơwah dơlhă lăm tơkrah buơl adơi-ai, tô kơyoa mư̆ng kàng-bơbah dơlhă bloh du mơnih buơl làng agàh hũ mơhư̆ Pơnuaĭ-Siàm sơ̆ng păng-tui. ");
INSERT INTO cje_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Yàng Pô Lơngì la Pô thơu hơtai-hơtiàn anà mơnih, hũ ngă grơh tơ du buơl làng agàh sơ̆ng bruă brơi tơ buơl guñu Yàng Bơngă Sơc̆ih-Sri, kŭng yơu brơi tơ buơl gudrơi rơi. ");
INSERT INTO cje_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Pô 'buh pơklah-krơi buơl gudrơi sơ̆ng buơl làng agàh ơu, bloh Pô ngă pơsơc̆ih-goh hơtai-hơtiàn buơl guñu kơyoa pơnuaĭ păng-tui. ");
INSERT INTO cje_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Yơu nư̆n tŭ ni, kơđa hơgĕ buơl adơi-ai khĭn lòng Yàng Pô Lơngì sơ̆ng bruă pơbuh tơ tơkuai du mơnih tui-mơgru sa boh yơu bloh du kơi-kŏ pàng-yau buơl gudrơi halài rùp-phŭn buơl gudrơi kŭng 'buh rơgơi glăm jai? ");
INSERT INTO cje_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Tơrblơ̆ wơ̆, buơl gudrơi păng-tui lài gơnừm tơ pơnuaĭ anĭt-brơi-soh Yàng la Yàng Jêsu, buơl gudrơi hũ dŏng-pơklàh kŭng mơhiơ̆ yơu du buơl làng agàh rơi.” ");
INSERT INTO cje_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Abih tơrpuơl mơnih pơtòm-pơjŭm dò kơđơ̆ng-rik, păng 'Banaba sơ̆ng Pôl đờm akhàn wơ̆ mư̆ng du pơnuaĭ-c̆rih nàl-krơi bloh Yàng Pô Lơngì hũ angui dua aràng buơl guñu ngă tơbiă tơkrah du buơl làng agàh. ");
INSERT INTO cje_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Tŭ buơl guñu đờm abih pơnuaĭ, Jakơ pồ săp đờm: “Ơ buơl adơi-ai, yòng păng bĕ dơlhă đờm. ");
INSERT INTO cje_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simôn hũ đờm-akhàn wơ̆ tơ buơl gudrơi thơu bruă hơyơu lơi mư̆ng tŭ c̆ơmrừp Yàng Pô Lơngì hũ c̆uă-rơwăng du buơl làng agàh, tô mư̆ng buơl guñu rơwah mă sa buơl làng tơ Angăn Pô. ");
INSERT INTO cje_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Pơnuaĭ nư̆n rơgăm-iơŭ biă sơ̆ng pơnuaĭ du mơnih gơnuăr-hwơ̆r hũ wă: ");
INSERT INTO cje_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Hơdơi tơgrơ̆ bruă ni, Kơu rơŭ gài mơrai wơ̆, Bơ̆ pơdơ̆ng wơ̆ sàng Đabit hũ kơđòng jơrlơh-pơc̆ah. Kơu rơŭ bơ̆ ngă wơ̆ du anih jơrlơh-tơrlŭng, Sơ̆ng bơ̆ pơdơ̆ng ñu wơ̆; ");
INSERT INTO cje_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Tô du mơnih dò wơ̆ lăm dun-ya, Sơ̆ng abih du buơl làng agàh hũ iơu-angăn sơ̆ng angăn Kơu, rơŭ tui-duah Yàng. Yàng la Pô hũ ngă tơgrơ̆ bruă ni đờm yơu nư̆n. ");
INSERT INTO cje_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Nư̆n la du bruă hũ thơu truh mư̆ng rài yau.’ ");
INSERT INTO cje_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Yơu nư̆n, tui hơtai dơlhă sơnư̆ng, buơl gudrơi juơi ngă kăn-dơmăn tơ du mơnih buơl làng agàh khiăng gài mơrai sơ̆ng Yàng Pô Lơngì. ");
INSERT INTO cje_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Bloh buơl gudrơi wă bĕ bơ-àr pơyoa tơ buơl guñu, kơkơi-pơđăr buơl guñu păl wèr-rơmiă rùp klàh mư̆ng du phơ̆n 'bơ̆ng sơŭ-sơnoh hũ pơyă tô duh-dơlbăt tơ rùp-ràk, juơi ngă glài dri-sơnoh bŭng-pơkăl, juơi 'bơ̆ng rơlo phơ̆n mơtai bơlhăt, sơ̆ng juơi 'bơ̆ng drah. ");
INSERT INTO cje_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Kơyoa mư̆ng du jơi-rài dơlhơu bơjơ, lăm yàu plơi-prŏng sơđaŭ hũ du mơnih pơto-mơblàng pơnuaĭ adăt-adia Môise, sơ̆ng buơl guñu pơrpoh-c̆ơ pơnuaĭ adăt-adia nư̆n yàu hơrơi sa'bat lăm du sàng pơtòm.” ");
INSERT INTO cje_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Hơdơi mư̆ng nư̆n, du mơnih tơdi-tơdài sơ̆ng mơnih gơnuăr-tha găm sơ̆ng abih Tơrpuơl Goh-Sơc̆ih ngă-nìn rơwah du mơnih lăm buơl guñu tô nau sơ̆ng Pôl sơ̆ng 'Banaba truh tơ Antiôt. Buơl guñu rơwah-pơđăr Juđa, kŭng angăn la 'Baraba sơ̆ng Sila, la dua aràng mơnih dò lăm tơrpuơl du mơnih apăn-akŏ tơkrah buơl adơi-ai păng-tui Yàng, ");
INSERT INTO cje_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","bloh nư̆n jào tơ buơl guñu sa blah bơ-àr wă pơyoa, wă yơu ni: “Adơi-ai buơl dơlhă la du mơnih tơdi-tơdài, mơnih gơnuăr-tha, pơyoa pơnuaĭ c̆uă-rơwăng truh buơl adơi-ai lăm buơl làng agàh tơ plơi-prŏng Antiôt, c̆àr Siri sơ̆ng c̆àr Silisi! ");
INSERT INTO cje_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Kơyoa buơl dơlhă hũ mơhư̆ thơu lài, hũ du mơnih mư̆ng tơkrah buơl dơlhă, yah lài 'buh hũ buơl dơlhă jào-pơđăr, bloh nau truh đờm tơgrơ̆ pơnuaĭ ngă tơ hơtai-akŏ buơl adơi-ai sơnư̆ng kơ-ù wĭ-wơ̆. ");
INSERT INTO cje_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Kơyoa nư̆n, buơl dơlhă sa hơtai-hơtiàn sơ̆ng gơŭ ngă-nìn jào-pơđăr du mơnih ni nau găm sơ̆ng dua aràng mơnih buơl dơlhă uơ̆n-rơnăm biă la 'Banaba sơ̆ng Pôl, truh sơ̆ng buơl adơi-ai. ");
INSERT INTO cje_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Dua aràng mơnih ni la du mơnih hũ kŏng prah-luơi pơnuaĭ hơdiŭ drơi kơyoa mư̆ng angăn Yàng Jêsu Krist, la Yàng buơl gudrơi. ");
INSERT INTO cje_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Yơu nư̆n, buơl dơlhă hũ rơwah-pơđăr Juđa sơ̆ng Sila truh, tô rùp-phŭn buơl guñu rơŭ đờm sơ̆ng buơl adơi-ai mư̆ng tơgrơ̆ pơnuaĭ nư̆n. ");
INSERT INTO cje_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Kơyoa Yàng Bơngă Sơc̆ih-Sri sơ̆ng buơl dơlhă 'buh lài, siàm rơlau abih la 'buh daŭ tơ ngŏ bra buơl adơi-ai sa gui-anòng traŭ lơi pơkơ̆n. Bloh buơl adơi-ai păl ngă du pơnuaĭ ni: ");
INSERT INTO cje_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Nư̆n la buơl adơi-ai juơi 'bơ̆ng du phơ̆n juh rùp-ràk, juơi 'bơ̆ng drah, juơi 'bơ̆ng rơlo du jơi-phơ̆n mơtai bơlhăt, sơ̆ng juơi ngă glài dri-sơnoh bŭng-pơkăl. Nư̆n la tơgrơ̆ pơnuaĭ bloh buơl adơi-ai păl wèr-pơkăl. Dò kơjăp krơu lăm Yàng!” ");
INSERT INTO cje_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Yơu nư̆n, hơdơi tŭ apăn tơngàn sơ̆ng Tơrpuơl Goh-Sơc̆ih tô nau jơlàn, buơl guñu trŭn tơ Antiôt, pơgùm-pơjŭm abih buơl adơi-ai wơ̆ sơ̆ng jào bơ-àr pơyoa. ");
INSERT INTO cje_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Hơdơi tŭ pơrpoh-c̆ơ bơ-àr pơyoa, abih tơgrơ̆ mơnih sờh-sài biă kơyoa mư̆ng du pơnuaĭ pơluơ-pơrơngài nư̆n. ");
INSERT INTO cje_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Juđa sơ̆ng Sila la du mơnih gơnuăr-hwơ̆r, kŭng mă lô pơnuaĭ pơto-mơblàng tô pơto-kơkơi sơ̆ng ngă tơ buơl adơi-ai hũ pràn-kơjăp hơtai-hơtiàn rơlau. ");
INSERT INTO cje_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Hơdơi tŭ dò tơ anih nư̆n lăm sa-sĭt hơrơi, buơl guñu hũ buơl adơi-ai nau pơrlau gài mơrai wơ̆ rĭng-lơngai sơ̆ng du mơnih hũ pơđăr buơl guñu nau. ");
INSERT INTO cje_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Bloh Sila nư̆n ngă-nìn dò wơ̆, mĭn sa aràng Juđa nau. ");
INSERT INTO cje_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Bloh Pôl sơ̆ng 'Banaba nư̆n dò wơ̆ lăm Antiôt, sa hơtai-hơtiàn sơ̆ng du mơnih pơkơ̆n pơto-akhàn Pơnuaĭ-Siàm sơ̆ng pơto-pơsài pơnuaĭ Yàng. ");
INSERT INTO cje_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Hơdơi mư̆ng nư̆n 'buh suơi, Pôl đờm sơ̆ng 'Banaba: “Buơl gudrơi gài wơ̆ c̆uă-rơwăng bĕ du buơl adơi-ai lăm yàu plơi-prŏng bloh buơl gudrơi hũ pơto-akhàn pơnuaĭ Yàng, c̆ơ buơl guñu hơyơu lơi.” ");
INSERT INTO cje_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","'Banaba khiăng ba găm Jăng kŭng angăn la Mak tui. ");
INSERT INTO cje_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Bloh Pôl nư̆n 'buh khiăng ba Mak tui, kơyoa Mak hũ luơi dua aràng buơl guñu tơ Pamphili, 'buh nau ngă bruă găm sơ̆ng buơl guñu. ");
INSERT INTO cje_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Kơyoa nư̆n, tơkrah dua aràng buơl guñu hũ pơnuaĭ tămpơrjai-mơsau gơŭ, tơ̆l truh dua aràng păl pơklah-krơi: 'Banaba ba Mak đì ahò nau tơ aguăn ia-tơsì C̆iprơ. ");
INSERT INTO cje_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Dò Pôl nư̆n rơwah Sila. Hơdơi tŭ hũ buơl adơi-ai iơu-lài jào drơi tơ pơnuaĭ anĭt-brơi-soh Yàng, dua aràng buơl guñu tơbiă nau. ");
INSERT INTO cje_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ñu nau lăm abih c̆àr Siri sơ̆ng Silisi, ngă tơ abih du Tơrpuơl Goh-Sơc̆ih hũ pràn kơjăp. ");
INSERT INTO cje_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pôl truh tơ plơi-prŏng Đerbơ sơ̆ng Listrơ. Tơ anih nư̆n, hũ sa aràng mơnih tui-mơgru angăn la Timôthe, anà lơkơi sa aràng mơnih kơmơi Juđa păng-tui Yàng. Ama Timôthe la mơnih Grek. ");
INSERT INTO cje_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Timôthe la mơnih hũ buơl adơi-ai lăm Listrơ sơ̆ng Ikôni đờm ngă grơh siàm. ");
INSERT INTO cje_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pôl khiăng ba Timôthe tui, nư̆n Pôl ngă adăt sơkaŭ-kơlì tơ ñu, kơyoa du mơnih Juđa lăm c̆àr nư̆n aràng sơi kŭng thơu ama Timôthe la mơnih Grek. ");
INSERT INTO cje_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Tŭ truh tơ plơi-prŏng lơi, buơl guñu kŭng kơkơi-pơđăr buơl adơi-ai păng-tui Yàng păl păng-rơmiă ngă tui du pơnuaĭ ngă-nìn bloh du mơnih tơdi-tơdài sơ̆ng du mơnih gơnuăr-tha lăm Jerusalem hũ ngă tơbiă. ");
INSERT INTO cje_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Kơyoa nư̆n, du Tơrpuơl Goh-Sơc̆ih hũ pràn-kơjăp lăm pơnuaĭ păng-tui, sơ̆ng khà mơnih păng-tui Yàng 'brŏ hơrơi 'brŏ lô rơlau. ");
INSERT INTO cje_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Buơl guñu nau lăm abih c̆àr Phirigi sơ̆ng Galati, kơyoa Yàng Bơngă Sơc̆ih-Sri hũ pơkơŭ buơl guñu 'buh brơi pơto-akhàn pơnuaĭ Yàng lăm c̆àr Asi. ");
INSERT INTO cje_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Tŭ truh jĕ c̆àr Mesi, buơl guñu khiăng tơma lăm c̆àr Bithini, bloh Bơngă Sơc̆ih-Sri Yàng Jêsu 'buh brơi gơnuăr, ");
INSERT INTO cje_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","nư̆n buơl guñu nau găn c̆àr Misi sơ̆ng trŭn tơ Trôas. ");
INSERT INTO cje_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Lăm glai mơlăm, Pôl 'buh sa pơnuaĭ Yàng brơi pơ'buh: Hũ sa aràng mơnih Maseđoan dò dơ̆ng tơ anaŭ drơi, lơkơu yòng lài: “Yòng kơi truh tơ Maseđoan dŏng-kờl buơl dơlhă!” ");
INSERT INTO cje_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Hơdơi tŭ Pôl 'buh pơnuaĭ Yàng brơi pơ'buh nư̆n, lăm tơk buơl dơlhă duah ngă hơyơu tô truh tơ c̆àr Maseđoan, kơyoa buơl dơlhă păng-tui lài Yàng Pô Lơngì hũ iơu-rơwah buơl dơlhă truh pơto-akhàn Pơnuaĭ-Siàm tơ anih nư̆n. ");
INSERT INTO cje_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Yơu nư̆n, mư̆ng Trôas buơl dơlhă đì ahò tơpă truh tơ aguăn ia-tơsì Samôtras, bloh nư̆n hơrơi hơdơi, truh tơ Neapôli. ");
INSERT INTO cje_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Mư̆ng anih nư̆n, buơl dơlhă truh tơ Philip, la plơi-prŏng prŏng-màng rơlau abih lăm c̆àr Maseđoan, sơ̆ng la plơi-prŏng dò tơ ala gơnuăr lơgăr Rôma apăn-akŏ. Buơl dơlhă dò wơ̆ tơ anih nư̆n du hơrơi. ");
INSERT INTO cje_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Lăm hơrơi Sa'bat, buơl dơlhă nau tơbiă tơ agàh bơh 'băng plơi-prŏng, jĕ tơ gah ia sơdờng, la anih buơl dơlhă păng-tui lài aràng pơtòm-pơjŭm gơŭ wơ̆ tô iơu-lài. Buơl dơlhă dò guh sơ̆ng đờm mư̆ng Pơnuaĭ Yàng tơ du mơnih kơmơi dò pơtòm-pơjŭm tơ anih nư̆n. ");
INSERT INTO cje_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Hũ sa aràng mơnih kơmơi păng buơl dơlhă đờm, angăn la Liđa, plơi phŭn tơ Thiatirơ. Bruă ñu ngă la pơblơi-sơlih bơ-yài ia mơr-yah Ñu la mơnih hũ hơtai-hơtiàn păng-duh Yàng Pô Lơngì. Yàng pơh hơtai-hơtiàn tơ Liđi, ngă tơ ñu păng nĭ-nùn du pơnuaĭ Pôl đờm. ");
INSERT INTO cje_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Hơdơi tŭ Liđi găm sơ̆ng abih sàng ñu hũ đồ-mă pơnuaĭ 'baptem, Liđi lơkơu jà buơl dơlhă: “Yah buơl kơi c̆ơ thơu dơlhă la mơnih tơpă sa hơtai-hơtiàn sơ̆ng Yàng, nư̆n yòng jà buơl kơi truh sàng dơlhă dò.” Bloh nư̆n ñu pơkơŭ jà buơl dơlhă păl tơma. ");
INSERT INTO cje_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Sa hơrơi dih, tŭ buơl dơlhă nau truh tơ anih tô pơtòm-pơjŭm iơu-lài, nư̆n păp sa aràng mơnih kơmơi hơlŭn-hơlă kơđòng kơmlài ngă, nư̆n la kơmlài ba c̆ơ ia. Gơnừm tơ bruă thơu c̆ơ ia, mơnih kơmơi hơlŭn-hơlă nư̆n ngă tơbiă lô phơ̆n-priă tơ du mơnih pô ñu. ");
INSERT INTO cje_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Mơnih kơmơi nư̆n kừ nau tui Pôl sơ̆ng buơl dơlhă bloh driau prŏng lài: “Du mơnih ni la hơlŭn-hơlă Yàng Pô Lơngì Ngŏ Glòng Rơlau Abih. Buơl guñu pơto-akhàn tơ buơl guhã jơlàn pơnuaĭ dŏng-pơklàh.” ");
INSERT INTO cje_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ñu kừ ngă mĭt yơu nư̆n lăm lô hơrơi, ngă tơ Pôl anok hơtai biă, nư̆n gài pơtrah wơ̆ đờm sơ̆ng kơmlài lài: “Kơu mă angăn Yàng Jêsu Krist, pơđăr hã păl tơbiă klàh mư̆ng mơnih ni.” Lăm tŭ nư̆n mư, kơmlài tơbiă klàh mư̆ng mơnih kơmơi hơlŭn-hơlă. ");
INSERT INTO cje_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Bloh tŭ du mơnih pô ñu 'buh pơnuaĭ drơi gơnừm tô duah phơ̆n-priă hũ lơhiă bơjơ, nư̆n mă Pôl sơ̆ng Sila, hua truh tơ anih 'blàng plơi, sơ̆ng jào tơ du mơnih gơnuăr apăn-akŏ plơi-lơgăr. ");
INSERT INTO cje_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Tŭ ba Pôl sơ̆ng Sila truh tơ anaŭ du mơnih kwăng c̆ahrơña, buơl guñu đờm yă: “Du mơnih ni ngă sơlŭng-sơlăng lăm plơi-prŏng buơl gudrơi; buơl guñu la mơnih Juđa, ");
INSERT INTO cje_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","buơl guñu pơto-pơsài du pơnuaĭ adăt-lơđăp bloh mơnih Rôma buơl gudrơi 'buh hũ gơnuăr đồ-mă halài ngă tui.” ");
INSERT INTO cje_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Tơrpuơl buơl làng kŭng sa hơtai tơgồ tămdră-wơ̆ sơ̆ng dua aràng mơnih tơdi-tơdài. Du mơnih kwăng c̆ahrơña pơđăr hĕt ào Pôl sơ̆ng Sila, bloh nư̆n pơđăr mơnih glih-pờng buơl guñu. ");
INSERT INTO cje_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Hơdơi tŭ glih-pờng, buơl guñu mă dua aràng mơnih tơdi-tơdài krơ̆ lăm sàng jàm, sơ̆ng pơđăr mơnih apăn-akŏ sàng jàm păl kraŭ-khiă nĭ-nùn. ");
INSERT INTO cje_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Hũ pơnuaĭ gơnuăr-pơđăr nư̆n, mơnih apăn-akŏ sàng jàm mă dua aràng mơnih tơdi-tơdài krơ̆ lăm anih adŭ kơnăm, sơ̆ng buh anuh tơ tơkai. ");
INSERT INTO cje_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Pơgăp mơtưh mơlăm, lăm tŭ Pôl sơ̆ng Sila dò iơu-lài, adoh-mơyòm Yàng Pô Lơngì; sơ̆ng du mơnih dò jàm pơkơ̆n hũ mơhư̆. ");
INSERT INTO cje_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Mơre-mơro, hũ pơnuaĭ tơtuơ̆n-jơrlơh lơ̆n-tơnah prŏng biă, ngă tơ rơnơ̆ sàng jàm mơgơi-tơtuơ̆n. Lăm tơk tŭ nư̆n mư, du bơh 'băng tơrpơh abih, sơ̆ng tơlơi srĕng akă du mơnih glài-jàm kŭng tơrsuă-tơryơh abih. ");
INSERT INTO cje_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Mơnih apăn akŏ sàng jàm takơtuă tơgồ, sơ̆ng 'buh du bơh 'băng sàng jàm tơrpơh abih; ñu sơnư̆ng lài du mơnih glài-jàm đuaĭ thĭt abih bơjơ, nư̆n suă đào sơmŏng pơmơtai rùp-phŭn. ");
INSERT INTO cje_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Bloh Pôl prŏng săp driau iơu: “Juơi ngă jơhà tơ rùp-phŭn yơu nư̆n! Kơyoa buơl dơlhă sơđaŭ dò tơ̆l abih tơ anih ni!” ");
INSERT INTO cje_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Mơnih apăn akŏ sàng jàm pơđăr mă apui đèng, bloh nư̆n tơmbah-tơmbàn đuaĭ tơma lăm dơrlăm, truh tơ anih krơ̆ Pôl sơ̆ng Sila, kơtơ̆ drơi pơđih rùp tơ anaŭ Pôl sơ̆ng Sila, ");
INSERT INTO cje_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","bloh nư̆n ba dua aràng tơbiă tơ agàh sơ̆ng đờm: “Ơ buơl kơi, dơlhă păl ngă hơgĕ tô hũ dŏng-pơklàh?” ");
INSERT INTO cje_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Dua aràng buơl guñu đờm: “Păng-tui bĕ Yàng Jêsu nư̆n kơi sơ̆ng abih sàng-dơnò kơi rơŭ hũ dŏng-pơklàh.” ");
INSERT INTO cje_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Dua aràng mơnih tơdi-tơdài pơto-akhàn pơnuaĭ Yàng tơ ñu, sơ̆ng tơ abih du mơnih dò lăm sàng ñu rơi. ");
INSERT INTO cje_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Lăm jơ nư̆n mư, tơkrah glai mơlăm, mơnih apăn-akŏ sàng jàm ba dua aràng mơnih tơdi-tơdài tơbiă, rào abih du anih lơka tơ buơl guñu; bloh nư̆n lăm tơk ñu sơ̆ng abih sàng-dơnò ñu đồ-mă pơnuaĭ 'baptem. ");
INSERT INTO cje_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Mơnih apăn akŏ sàng jàm jà dua aràng mơnih tơdi-tơdài đì tơ sàng, sơ̆ng pồ pơnuaĭ huă 'bơ̆ng tơ dua aràng. Ñu sơ̆ng abih sàng-dơnò ñu sờh-sài biă kơyoa hũ păng-tui Yàng Pô Lơngì. ");
INSERT INTO cje_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Truh glai ờm, du mơnih kwăng c̆ahrơña pơđăr mơnih lĭng khiă-gàr truh đờm sơ̆ng mơnih apăn-akŏ sàng jàm: “Toh-tơleh bĕ dua aràng mơnih nư̆n tơbiă.” ");
INSERT INTO cje_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Mơnih apăn akŏ sàng jàm truh đờm pơthơu sơ̆ng Pôl: “Du mơnih kwăng c̆ahrơña brơi mơnih truh đờm pơđăr toh-tơleh dua aràng buơl kơi tơbiă! Kơyoa nư̆n, buơl kơi tơbiă bĕ, sơ̆ng nau rĭng-lơngai.” ");
INSERT INTO cje_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Bloh Pôl đờm sơ̆ng buơl guñu: “Buơl dơlhă la du mơnih buơl làng lơgăr Rôma, nư̆n bloh tŭ ka hũ ngă nìn-glài, buơl guñu hũ pơđăr mơnih glih-pờng buơl dơlhă tơkrah buơl làng, bloh nư̆n mă krơ̆ lăm sàng jàm. Tŭ ni buơl guñu khiăng ngă bơdơŭ-tơrđơŭ toh-tơleh buơl dơlhă tơbiă? 'Buh jiơ̆ng ơu! Rùp-phŭn buơl guñu păl truh tơ anih ni tô ba buơl dơlhă tơbiă.” ");
INSERT INTO cje_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Du mơnih kwăng c̆ahrơña mơhư̆ buơl lĭng khiă-gàr đờm akhàn wơ̆ du pơnuaĭ nư̆n, sơ̆ng thơu dua aràng mơnih nư̆n la buơl làng lơgăr Rôma, nư̆n huơĭ kơ-ù biă. ");
INSERT INTO cje_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Nư̆n buơl guñu truh yòng lơkơu drơi, bloh nư̆n ba dua aràng mơnih tơdi-tơdài tơbiă, sơ̆ng yòng dua aràng mơnih tơdi-tơdài nau klàh mư̆ng plơi-prŏng. ");
INSERT INTO cje_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Tơbiă mư̆ng sàng jàm, dua aràng mơnih tơdi-tơdài truh tơ sàng Liđi. Hơdơi tŭ c̆uă-rơwăng sơ̆ng đờm kơkơi-pơto buơl adơi-ai, dua aràng mơnih tơdi-tơdài tơbiă nau. ");
INSERT INTO cje_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Hơdơi tŭ Pôl sơ̆ng Sila pleh găn dua plơi-prŏng Amphipôlit sơ̆ng Apôlôni, buơl guñu truh tơ plơi-prŏng Tesalônika; tơ anih ni hũ sa boh sàng pơtòm mơnih Juđa. ");
INSERT INTO cje_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Tui lơđăp-mừng, Pôl truh tơ sàng pơtòm, sơ̆ng lăm klơu hơrơi sa'bat, tămpơrjai mơblàng 'Bồn Bơ-àr Sơc̆ih-Sri sơ̆ng buơl guñu. ");
INSERT INTO cje_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Mă 'Bồn Bơ-àr Sơc̆ih-Sri đờm mơblàng sơ̆ng ngă grơh lài Pô Krist păl kŏng pơđì-pơđoa gleh-glăr, bloh nư̆n hơdiŭ wơ̆ mư̆ng pơnuaĭ mơtai. Pôl đờm: “Yàng Jêsu bloh dơlhă pơto-akhàn tơ buơl adơi-ai ni, nư̆n la rùp-phŭn Pô Krist.” ");
INSERT INTO cje_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Lăm tơrpuơl buơl guñu, hũ du mơnih đồ-mă pơnuaĭ pơto-akhàn, nư̆n păng-tui Yàng sơ̆ng nau tui Pôl sơ̆ng Sila; kŭng hũ găm du mơnih Grek