﻿USE sofia;
DROP TABLE IF EXISTS sofia.chqNT_vpl;
CREATE TABLE chqNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES chqNT_vpl WRITE;
INSERT INTO chqNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","'E lo‑o coon²¹ jí² 'e taai² jileei'²¹ tsacøøi'¹³ tya' Jesucristo, jaain²¹ jún² tya' 'lɨɨ²¹² David joongɨ tya' 'lɨɨ²¹² Abraham 'ii. ");
INSERT INTO chqNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","'In Abraham do jmii²¹ Isaac, joon Isaac do jmii²¹ Jacob, Jacob do jmii²¹ Judá coon'¹³ 'in ruu'²¹i catyaai² do. ");
INSERT INTO chqNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá do jmii²¹ Fares coon'¹³ Zara joon sáa³o sii²¹ Tamar. Joon 'in Fares do jmii²¹ Esrom, Esrom do jmii²¹ Aram. ");
INSERT INTO chqNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram do jmii²¹ Aminadab, Aminadab do jmii²¹ Naasón, Naasón do jmii²¹ Salmón. ");
INSERT INTO chqNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón do jmii²¹ Booz joon sáa³a sii²¹ Rahab. Joon 'in Booz do jmii²¹ Obed joon sáa³a Obed sii²¹ Rut. Obed do jmii²¹ Isaí. ");
INSERT INTO chqNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí do jmii²¹ rǿøi¹³ David. Joon rǿøi¹³ David do gasáa¹i Salomón coon'¹³ tsamɨ́² 'in galɨ́² tsamɨ́² tya' Urías. ");
INSERT INTO chqNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","'In Salomón do jmii²¹ Roboam, Roboam do jmii²¹ Abías, Abías do jmii²¹ Asa, ");
INSERT INTO chqNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa do jmii²¹ Josafat, Josafat do jmii²¹ Joram, Joram do jmii²¹ Uzías. ");
INSERT INTO chqNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías do jmii²¹ Jotam, Jotam do jmii²¹ Acaz, Acaz do jmii²¹ Ezequías. ");
INSERT INTO chqNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías do jmii²¹ Manasés, Manasés do jmii²¹ Amón, Amón do jmii²¹ Josías. ");
INSERT INTO chqNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías do jmii²¹ Jeconías coon'¹³ tsaruu'²¹i. 'Yiia'¹³ joon ngajée¹i tsá² seein²¹ Babilonia 'in tsá² Israel sɨ'ñúu¹mo fu goo¹o. ");
INSERT INTO chqNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Joon mo taain²¹² tsá² Israel Babilonia Jeconías do gasáa¹i Salatiel. Joon 'in Salatiel do jmii²¹ Zorobabel. ");
INSERT INTO chqNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel do jmii²¹ Abiud, Abiud do jmii²¹ Eliaquim, Eliaquim do jmii²¹ Azor. ");
INSERT INTO chqNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor do jmii²¹ Sadoc, Sadoc do jmii²¹ Aquim, Aquim do jmii²¹ Eliud. ");
INSERT INTO chqNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud do jmii²¹ Eleazar, Eleazar do jmii²¹ Matán, Matán do jmii²¹ Jacob. ");
INSERT INTO chqNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob do jmii²¹ José. José do gacu'²mo cwoo²¹o María 'in lɨ́ɨ¹i sáa³ Jesús 'in sii²¹o jon Cristo. ");
INSERT INTO chqNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Joon mo galiseein²¹ 'lɨɨ²¹² Abraham ca galiseein²¹ 'lɨɨ²¹² David galiseein²¹ daytyúuin² jmii²¹ tsá². La joon jon galiseein²¹ dyatyúuin² jmii²¹ tsá² ca mo galiseein²¹ 'lɨɨ²¹² David ca ngalíin² tsá² Israel sɨ'ñúu¹mo fu Babilonia. Joon dyatyúuin²gɨ jmii²¹ tsá² galiseein²¹ 'e la nʉ'gɨ 'e galiseein²¹ Cristo. ");
INSERT INTO chqNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","La no‑o galɨ́² mo galiseein²¹ Jesucristo. María, 'in ilíin²in sáa³ Jesús, niganá¹ júu³ coon'¹³ Sé³. Pe la nʉ'gɨ icwaa¹a caain²¹ coon'¹³ Sé³ do gacáan¹in María yʉʉn²¹ coon'¹³ 'ii'²¹ tya' Espíritu Tyʉ́² tya' Dios. ");
INSERT INTO chqNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Joon ñʉʉ'¹ tya'o Sé³ do, tsʉ jaain²¹ tsá² tyúi¹ 'ii, jo gali'iin²¹²in 'e faa'²¹ tsá² 'laa'²¹ tya'a, jiin'¹³ 'iin²¹²in itíuu²mo 'ido la jo ñii¹ tsá² fuu²¹. ");
INSERT INTO chqNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Joon la 'ɨɨ²¹² 'ɨ¹‑tsi Sé³ jilaa'²¹ 'elo lawa'a 'e cɨɨ¹o gajnéi¹ jaain²¹ ángel tya' Ña'ñʉ'¹ʉ' tyaníi¹i joon gajin'²in: ―Sé³, jún² tya' 'lɨɨ²¹² David 'nʉ, 'ii'¹³mo'o María do lawa tsamɨ́² tyi'i. Jo jmaa²'a 'goo'²¹ tsʉ 'in yʉʉn²¹ gacáan¹in do, 'ii'²¹ tya' Espíritu Tyʉ́² tya' Dios do. ");
INSERT INTO chqNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Iliseein²¹ jaain²¹ xuui²¹² tsañʉʉ'¹ tya'a iunsii²¹'i JESÚS. Ilisii²¹ la joon tsʉ 'wii'¹³ ijmáa¹a tiin'¹³ tsá² tya'a jilaa'²¹ tsaa² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Jilaa'²¹ 'elo galɨ́¹ la joon 'e untsiin¹in júu³ tya' Ña'ñʉ'¹ʉ' 'e gafaa'²¹ tsá² tya'a la mo jéei¹³. Gajin'²o: ");
INSERT INTO chqNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Jaain²¹ sɨmɨ́² icáan²in yʉʉn²¹, joon iliseein²¹ yʉʉn²¹ tsañʉʉ'¹ tya'a. Joon iunsii²¹ 'ii Emanuel. ('E 'øø'²¹tsi tsá² 'e sii²¹: Dios jee²¹² jna'.) ");
INSERT INTO chqNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Joon mo gajná²‑tsi Sé³ do gajmaa¹a jiin'¹³ la jin'² ángel tya' Ña'ñʉ'¹ʉ'. Joon ga'ii'²¹mo María lawa tsamɨ́² tya'o. ");
INSERT INTO chqNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pe jo 'ee gajmaa¹a coon'¹³ 'ido ca galiseein²¹ 'in xuui²¹² tsañʉʉ'¹ nifu joon gaunsii²¹ 'ii JESÚS. ");
INSERT INTO chqNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesús galiseein²¹ fu coon²¹ fuu²¹ sii²¹ Belén 'e náa¹ coon²¹ 'wó² 'e sii²¹ Judea. Herodes lɨ́ɨ¹i rǿøi¹³ 'yiia'¹³ joon. Joon gatyalíin² 'inlɨ́ɨ¹³ rǿøi¹³ magos, tsá² jmɨɨ²¹²‑tsi 'ii. Gatyalíin² fu Jerusalén jalíin² lɨ 'yeei²¹ ñi'¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Joon gaunngɨɨ¹ɨ 'in tsá² do: ―¿Xiiafu tyíin¹ 'in rǿøi¹³ 'in nigaliseein²¹ tya' tsá² Israel? Tsʉ jna'a naa²¹a'a lɨ' lɨ 'yeei²¹ ñi'¹ joon ganee²¹²na'a nʉ́ʉ¹ tya'a. Joon nijalii²¹i'i jaun'goo²¹o'o 'ii. ");
INSERT INTO chqNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Joon mo ganúu²un rǿøi¹³ Herodes 'elo lɨ́ɨ¹ 'láai² ga'ɨ¹‑tsi 'áai¹ coon'¹³ jileei'²¹ 'in néei¹ Jerusalén do. ");
INSERT INTO chqNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Joon 'in rǿøi¹³ do gatø'¹ø jileei'²¹ 'in tyʉ'² to² tya' untsá² coon'¹³ 'in tɨfo'² tya' ley tya' 'in tsá² do. 'E 'iin²¹²in litsáai¹‑tsi xiiafu iliseein²¹ Cristo. ");
INSERT INTO chqNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Joon 'in tsá² do 'in gatø'¹ rǿøi¹³ do gajin'²in: ―Fuu²¹ Belén joon iliseein²¹ Cristo. Tsʉ 'in tsá² 'in gafaa'²¹ júu³ tya' Dios calɨɨ gataan¹an ni jí² 'elo: ");
INSERT INTO chqNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Joon 'nʉ‑ʉ, fuu²¹ Belén 'e náa¹ lɨ roon¹on 'wó² tya' Judá, jo lɨ́ɨ²u'u 'in pi'³gɨ la jee²¹² jileei'²¹ 'in tyʉ'² to² 'e 'wó² lo; tsʉ icwo'ɨ́ɨ¹i jee²¹² lo jaain²¹ tsá² feei'¹ 'in tyʉ'² to² tsá² tyiia 'in seein²¹ Israel. ");
INSERT INTO chqNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Joon gatø'¹ø Herodes 'in tsá² 'øøi'²¹‑tsi do 'uun²¹mo, gaunngɨɨ¹ɨ coon'²¹ tún² lɨɨ gangoo¹o ni'íi¹in 'in nʉ́ʉ¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Joon gasii¹ ni'²i 'in tsá² 'øøi'²¹‑tsi do fu Belén. Joon jin'²in: ―Cwolíin²naa', cwo'nee'²¹naa' 'in xuui²¹² do. Joon mi tyee'¹naa' 'ii joon jmáa¹³aa' jna júu³ iní³ii niun'goo²¹oo jon 'ii. ");
INSERT INTO chqNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Joon mo ganúu²un 'in tsá² 'øøi'²¹‑tsi do júu³ tya' rǿøi¹³ do ngalíin²mo joon no. Joon 'in nʉ́ʉ¹ do 'in ganíi²in 'in tsá² 'øøi'²¹‑tsi fu lɨ née¹i fu lɨ 'yeei²¹ ñi'¹ ngóo¹o nifugɨxʉ lɨ ngalíin² 'in tsá² do. Ngoo²¹o ca ga'ɨ́ɨ² fu yʉ' lɨ raain¹ 'in xuui²¹² do. ");
INSERT INTO chqNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Jløø'³mo 'áai¹ 'in tsá² 'øøi'²¹‑tsi mo ganíi²in 'in nʉ́ʉ¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Joon mo gangatáa¹i inʉʉ do gangaa¹i yʉʉn²¹ do coon'¹³ sáa³a. Joon gasi'²i 'wojníi¹i tyani 'in yʉʉn²¹ do joon gaun'goo²¹o 'ido. Joon ganá¹ cwóo¹ tya'a icwo'¹o 'in yʉʉn²¹ do cwanáa¹ coon'¹³ fuu²¹² sʉ́n² coon'¹³ jmɨ'³ 'mó² jmafuu²¹ sii²¹ mirra. ");
INSERT INTO chqNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Joon Dios gajmaa¹a gacɨɨ¹ɨ 'in tsá² do 'e jo tsalíin²gɨ lɨ' lɨ tyíin¹ Herodes do. Joon ngaliin¹mo fuu²¹ goo¹o fu¹ lɨ' xiia'²¹. ");
INSERT INTO chqNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Mo ngayuui'¹³ ngaliin¹ 'in tsá² 'øøi'²¹‑tsi do la 'ɨɨ²¹² cɨ́¹ Sé³ gajné¹i jaain²¹ ángel tya' Ña'ñʉ'¹ʉ' gajin'²in sɨɨ'²¹ɨ Sé³ do: ―Ráan²u, jée¹i yʉʉn²¹ coon'¹³ sáa³a cwolíin²naa' Egipto. Joon cwotaan²¹²moo' do ca mi jmáa³aa júu³ tsʉ Herodes i'naa'²¹in 'in yʉʉn²¹ do ijnga'²mo. ");
INSERT INTO chqNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Joon garoon¹on Sé³ joon lɨ 'woo¹ ngalíin² jée¹i yʉʉn²¹ do coon'¹³ sáa³a fu Egipto. ");
INSERT INTO chqNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Do‑o taan¹in ca gajún¹mo Herodes do. La lo‑o galɨ́¹ 'e gatsín¹ júu³ tya' tsá² gafaa'²¹a júu³ tya' Ña'ñʉ'¹ʉ' la mo jéei¹ 'in gajin'²in: “Tø'³oo Yʉʉn²¹ Tyiia 'in taain²¹² fu Egipto.” ");
INSERT INTO chqNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Mo galili'³i Herodes 'e nigacon'²on 'in tsá² 'øøi'²¹‑tsi 'ii tóo², 'áa¹mo gatsá² 'nii'²¹‑tsi joon gatyʉ'²ʉ to² júun²in jileei'²¹ yʉʉn²¹ tsañʉʉ'¹ 'in ni ngó¹ tún² jiin'¹ lɨ la 'wó¹. Jileei'²¹ yʉʉn²¹ tsañʉʉ'¹ 'in seein²¹ Belén joongɨ lɨ' caai¹ Belén gatyʉ'²ʉ to² júun²in. Tsʉ la joon gajin'²in 'in tsá² 'øøi'²¹‑tsi do 'e nigangaa¹i 'in nʉ́ʉ¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Joon coon'¹³ la joon ngatiin'¹³ júu³ tya' 'lɨɨ²¹² Jeremías 'in gacwo¹ júu³ tya' Dios ca la mo jéei¹. Gajin'²in: ");
INSERT INTO chqNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","'Áai¹ 'náa¹ 'goo²¹ fuu²¹ Ramá cɨ'²ɨ xuui²¹²‑tsi 'áai¹ tsʉ Raquel cɨ'²ɨ cwáain¹ tya' jóon¹on. Pe jo 'iin²¹²in wa'a cwo'¹ tsá² 'ii fo'feei'¹ tsʉ najún¹mo yʉʉn²¹ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Pe mo gangɨɨ¹in gajúin¹ Herodes gacɨ́ɨ¹ɨ Sé³ fu Egipto do joon gajnéi¹ jaain²¹ ángel tya' Ña'ñʉ'¹ʉ' 'in jin'² sɨɨ'²¹ɨ 'ii: ");
INSERT INTO chqNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―Ráan²un, cweei'¹ tee¹e xuui²¹² coon'¹³ sáa³a fu Israel tsʉ nijúun²mo 'in 'iin²¹²in ijngaai'² 'ii. ");
INSERT INTO chqNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Joon Sé³ do garoon¹on joon gatǿø¹ø xuui²¹² do coon'¹³ sáa³a fu Israel. ");
INSERT INTO chqNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Pe mo galili'³i Sé³ do 'e jóon¹ Herodes sii²¹ Arquelao tyʉ'²ʉ to² fu Judea 'goo'²¹o tsalíin² do. Joon coon'¹³ 'e cʉʉ¹o gajmaa¹a Dios 'ii júu³ wa tsalíin² fu lɨ sii²¹ Galilea. ");
INSERT INTO chqNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Joon mo gatyalíin² lɨ sii²¹ Galilea joon ngacwaa²¹ coon²¹ fuu²¹ sii²¹ Nazaret. La joon galɨ́¹ 'e gatsín¹ júu³ gafaa'²¹a tsá² cwoo¹o júu³ tyʉ́² tya' Dios la mo féei¹ 'in jin'²in: ―Iunsii²¹ tsá² 'ii: tsá² Nazaret. ");
INSERT INTO chqNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","La jee²¹² tyíin¹ Jesús Nazaret ga'láa² Wó³ saai²¹ tsá² jmɨɨ²¹ 'wii²¹² cwoo¹o júu³ tyʉ́² tya' Dios lɨ jo 'in tsá² seein²¹ coon²¹ lɨ sii²¹ Judea. ");
INSERT INTO chqNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Joon gajin'²in: ―Cwojaa'²¹‑'oo' coon'¹³ Dios tsʉ tɨ lɨ tyʉ'² Dios to² jee²¹² tsá². ");
INSERT INTO chqNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jaain²¹ tsá² 'in gacwoo¹o júu³ tya' Dios la mo jéei¹ sii²¹ Isaías gafaa'²¹a cwáain¹ tya' Wó³ do mo gajin'²in: Tá² coon²¹ ni 'oo¹o jaain²¹ tsá² fu coon²¹ lɨ jo 'in tsá² seein²¹, jin'²in: “'Ijó¹ Ña'ñʉ'¹ʉ'. Tyaa²aa' tyʉ́² tyii' i'ii'¹³moo' 'ii, tsáa¹mo‑'oo' 'e tyú¹moo'”, jin'² Isaías. ");
INSERT INTO chqNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Joon sɨɨn'³ Wó³ lɨ́¹ jñʉ́² camello, joon 'e 'ñʉ́ʉ¹ tu'²gɨ lɨ́¹ coon'¹³ loo²¹. Joongɨ 'e gø'²ø jmaai'² sɨnii'²¹ coon'¹³ to'² sá² moo'²¹. ");
INSERT INTO chqNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Joon 'in néei¹ ciudóo¹³ Jerusalén coon'¹³ 'in néei¹ la caain²¹ lɨ sii²¹ Judea coon'¹³ 'in néei¹ coo'¹³ lɨ ngɨ́ɨ¹i jmɨɨ²¹ Jordán jalíin² janʉ́ʉ²ʉn júu³ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Joon la jee²¹² jmoo¹o tyañii²¹ tya'a tyani Dios gasaa¹i Wó³ 'ii jmɨɨ²¹ tsi jmɨɨ²¹ Jordán. ");
INSERT INTO chqNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Pe mo gacón² Wó³ cwáain¹ 'e 'áai¹ fúui¹ tsá² fariseos coon'¹³ tsá² saduceos jalíin² saa¹i jmii²¹, gajin'²¹in: ―¡Tsá² 'in coon'²¹ tsá² tóo² 'naa'! ¿'Iin nigasɨɨ'²¹ɨ 'naa' 'e laa²¹²naa' yaanaa' jee²¹² coon²¹ wúu¹ 'e nijatyéein¹? ");
INSERT INTO chqNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Cwojmaa²aa' jiin'¹³ la tɨ́ɨ²i jmá¹ 'in nigajoo'²¹‑tsi. ");
INSERT INTO chqNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Joon jo 'ɨ¹‑'oo': “Jo 'e tsangɨɨ¹na' tsʉ jún² tya' 'lɨɨ²¹² Abraham jna'.” Tsʉ fuu²¹²uu 'naa' 'e ca 'e cuun²¹² roon¹ lo lí² jmá² Dios ca jún² tya' 'lɨɨ²¹² Abraham. ");
INSERT INTO chqNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","La lɨ́¹ 'mó²‑o lɨ́ɨ¹i tsá² jon, joon Dios nityaa¹ tyʉ́² ñityí² tya'a 'e tyʉ'²ʉ 'mó² ca tɨ'² jmóo³, joon jilaa'²¹ 'mó² 'e jo cwo¹ 'oofuu²¹ tyʉ́² tya'a ityʉ'²o joon ijún² coon'¹³ jɨ́². ");
INSERT INTO chqNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","'E la ja'²mo jna sáa³na 'naa' jiin'¹³ coon'¹³ jmɨɨ²¹ 'e lɨ́¹ lawa coon²¹ li² 'e nigajoo'²¹‑'oo'. Pe 'in jó¹ cɨɨin²¹gɨxʉ la jna isáa¹i 'naa' jmɨɨ²¹ coon'¹³ Espíritu Tyʉ́² tya' Dios joon coon'¹³ jɨ́². Feei'¹gɨ 'ii lagɨ jna ce jiin'¹³ jo tɨ́ɨ²na cón³oon mɨ́ɨ¹ɨ. ");
INSERT INTO chqNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Joon san'²o 'ido 'mó² tyʉʉn'²¹ trigo tsʉ tɨ lí² untyʉ́² trigo tya'a. Ijmáa¹a coon'²¹ tyi¹ tya' trigo do. I'má² trigo fu lɨ 'má² tsá² trigo pe tyi¹ do tya'a ijún² coon'¹³ jɨ́² 'e jo dyʉʉ¹. ");
INSERT INTO chqNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Joon gacwo'ɨ́ɨ¹ Jesús lɨ sii²¹ Galilea joon gangóo¹ fu lɨ taain²¹² Wó³ do tɨ'² jmɨɨ²¹ Jordán. Gangóo¹ 'e saa¹i Wó³ 'ii jmɨɨ²¹. ");
INSERT INTO chqNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Pe jo 'iin²¹²in Wó³ saa¹i Jesús jmɨɨ²¹. Joon gasɨɨ'²¹ɨ Jesús: ―'Nʉ‑ʉ 'ná¹ sáa²u'u jna jmɨɨ²¹. ¿Tɨ ñi²'i 'e sáa¹³na 'nʉ jmɨɨ²¹? ");
INSERT INTO chqNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Pe gajin'² Jesús sɨɨ'²¹ɨ 'ii: ―Cwó²du'u lí² jiin'¹³ la 'iin²¹²na. Tsʉ tyʉ́²‑ʉ 'e jmoo²¹o' jilaa'²¹ jiin'¹³ la to² tyʉ'² Dios. Joon Wó³ do gacwoo¹o júu³. ");
INSERT INTO chqNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Joon mo ngayuui'¹³ gasaa¹i Wó³ jmɨɨ²¹ Jesús joon gacwo'ɨ́ɨ¹ Jesús tsi jmɨɨ²¹ do. Joon tsifu joon ganó¹ fu ñʉ'fú² joon Jesús gangaa¹i 'in Espíritu Tyʉ́² tya' Dios lɨ́ɨ¹i maa²¹² gajngáa¹i yʉ' lɨ siin'²¹ Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Joon ganúu²un coon²¹ júu³ fu ñʉ'fú² 'e jin'²: ―'In no‑o yʉʉn²¹ tyiia 'in 'iin²¹²na. Jløø'³moo 'áai¹ coon'¹³on. ");
INSERT INTO chqNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Tsifu joon gangajée¹i 'in Espíritu Tyʉ́² tya' Dios Jesús fu coon²¹ lɨ jo 'in tsá² seein²¹. Icón² Satanás cwáain¹ xiiala lɨ́ɨi¹ Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Joon jee²¹² tunló¹ jmɨɨ¹ joon tunló¹ 'woo¹ jo 'ee gø'²ø jiin'¹³ xʉ. Joon gatsá² un'áa¹i mo ngɨ́ɨi¹ joon. ");
INSERT INTO chqNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Joon Satanás gangatyéen¹in lɨ sin'² Jesús 'e 'iin²¹²in cón² cwáain¹ xiiala lɨ́ɨi¹ Jesús. Joon gajin'²in sɨɨ'²¹ɨ Jesús: ―Wana 'nʉ‑ʉ jóon¹ Dios tyʉʉ'¹³ to² cwolí² 'iñi'¹ 'e cuun²¹² roon¹on no. ");
INSERT INTO chqNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Pe Jesús gañii¹i: ―Ni jí² tya' Dios jin'²in: “Jo taain²¹² tsá² tyʉ́²‑ʉ fu juncwii²¹ lo jiin'¹³ coon'¹³ 'e 'iñi'¹ 'e sá² dø'²ø pe coon'¹³ jilaa'²¹ júu³ tyʉ́² 'e gafaa'²¹ Dios Jmii²¹.” ");
INSERT INTO chqNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Joon ngajée¹i Satanás Jesús ngalíin² 'e fuu²¹ nicwaai'³ Jerusalén. Joon gasáa¹i Jesús fu yʉ' cwo'¹ fee'¹ si'² do. ");
INSERT INTO chqNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Joon gajin'² Satanás sɨɨ'²¹ɨ Jesús: ―Wana 'nʉ‑ʉ jóon¹ Dios, cwó² cwotee'²¹'u tsʉ ni jí² tya' Dios 'e jin'²: Ityʉ'² Dios to² 'e 'áa¹i 'nʉ ángeles tya'a. Isáa¹i 'nʉ coon'¹³ cwoo²¹o la coon'²¹ jo tyʉʉn'²¹ cuun²¹² tɨ́ɨ¹³'ɨ. ");
INSERT INTO chqNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Joon gañii¹i Jesús: ―Jin'²o jon ni jí² tya' Dios: “Jo untsáai¹‑'o'o xiiala lɨ́ɨ¹i Ña'ñʉ'¹ʉ' Dios tyi'i.” ");
INSERT INTO chqNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Xiia'²¹gɨ tún² ngajée¹i Satanás Jesús fu yʉ' moo'²¹ ñíi¹ 'áai¹. Joon ga'e'²e Jesús jilaa'²¹ fuu²¹ náa¹ la 'ui juncwii²¹ coon'¹³ jilaa'²¹ 'e 'ya'²gɨ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Joon gajin'²in: ―Cwóo³‑oo jilaa'²¹ 'elo tyi'i wana sii'¹³'i wojní²'i tyaní³ii 'e un'goo²'o jna. ");
INSERT INTO chqNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Joon jin'² Jesús sɨɨ'²¹ɨ 'ii: ―Cwei'², Satanás, tsʉ ni jí² tya' Dios jin'²: “Un'goo²'o Ña'ñʉ'¹ʉ' Dios tyi'i; joon jmoo²'o jiin'¹³ to² tyʉ'² 'ii.” ");
INSERT INTO chqNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Joon Satanás do gajeen'²¹mo coon'¹³ Jesús. Joon gatyalíin² ángeles 'e unjíi²in Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Joon mo ganúu²un Jesús 'e Wó³ do 'yúu¹i 'nʉñí³ gangóo¹on fu lɨ sii²¹ Galilea. ");
INSERT INTO chqNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Pe jo gajaan¹ fuu²¹ Nazaret, gangacwaa²¹a fu Capernaum, coon²¹ fuu²¹ náa¹ tɨ' tyíia¹ do. 'Wó² tya' 'lɨɨ²¹² tsacøøi'¹³ Zabulón coon'¹³ Neftalí. ");
INSERT INTO chqNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","La joon galɨ́¹ 'e gatsín¹ júu³ tya' jaain²¹ tsá² sii²¹ Isaías. 'Ii jaain²¹ 'in gafaa'²¹ júu³ tya' Dios la mo jéei¹. Joon gataan¹an ni jí² júu³ 'e jin'²: ");
INSERT INTO chqNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","'Wó² tya' Zabulón coon'¹³ Neftalí 'e roon¹ lɨ' caai¹ tyíia¹, lɨ' caai¹ lɨ 'yee²¹i ñi'¹ jmɨɨ²¹ Jordán lɨ sii²¹ Galilea, lɨ néei¹ tsá² 'in jo seein²¹ Israel. ");
INSERT INTO chqNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","'In tsá² 'in néei¹ lɨ 'íi¹ nʉʉ²¹ ganii²¹i coon²¹ jɨ́² fee'¹. Joon nigajná² joo'²¹ tya' 'in tsá² 'in tói¹ 'mó¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Joon ga'láa² Jesús 'wii²¹² cwoo¹o júu³ tyʉ́², jin'²in: ―Cwojaa'²¹‑'oo' coon'¹³ Dios tsʉ tɨ lɨ tyʉ'² Dios to² jee²¹² tsá². ");
INSERT INTO chqNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","La 'ɨɨ²¹² ngóo¹o Jesús tɨ' tyíia¹ Galilea gangaa¹i gái¹ tsá² taain²¹² to² pii²¹i 'mó¹ tsi tyíia¹ do. Tsʉ joon to² tya'a. La 'oo'²¹ ruu'²¹mo 'in tsá² gái² do. Jaain²¹ sii²¹ Simón 'in sii²¹o jon Tʉ́³, 'in jaain²¹gɨ sii²¹ Dɨ́ɨ³. ");
INSERT INTO chqNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Joon gajin'² Jesús sɨɨ'²¹ɨ 'ido: ―Moo²¹o' coon'¹³ jna joon jmée³na 'naa' tsá² jmoo¹o to² saain'²¹ tsá² 'in líin² tsá² tyiia. ");
INSERT INTO chqNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Tsifu joon gatʉʉ²¹ʉ 'mó¹ tya'a joon ngalíin²mo coon'¹³ Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Xʉʉ ngó¹xʉ joon mo gangaa¹i gái¹gɨ tsaruu'²¹i. Jaain²¹ sii²¹ Jacobo, 'in jaain²¹gɨ sii²¹ Wó³. Jóon¹on Zebedeo 'ii. Táa¹i tsi barco coon'¹³ jmii²¹ 'míi¹i nʉ́ʉ³. Joon gatø'²ø Jesús 'ii. ");
INSERT INTO chqNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Joon tsifu joon ga'woo²¹mo 'e barco do. Do‑o gatíuu²mo jmii²¹ joon ngalíin²mo coon'¹³ Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Joon gangó¹ Jesús la caain²¹ lɨ sii²¹ Galilea 'e'²e tsá² inʉʉ cwo'¹ tya' tsá² Israel sii²¹ sinagoga. Ga'e'²e tsá² xiiala ilí² mi tyʉ'² Dios to² tsá² joon gaun'láa¹i Jesús tsatsaa'¹³ 'in tyán¹an jilaa'²¹ nii² jmoowúu¹. ");
INSERT INTO chqNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Joon galicwii¹mo tsá² Jesús la caain²¹ lɨ sii²¹ Siria joon gangajée¹i tsatsaa'¹³ 'in tyán¹an jmoowúu¹ 'láai² 'ii'¹³. Seein²¹ 'in taai² tyí². Seen²¹mo 'inlɨ́ɨi¹³ 'in taai² 'in'lɨɨi'³ alma tya'a, seen²¹mo 'inlɨ́ɨ¹i jmoo²¹ wúu¹ jooinñii'¹, seen²¹mo jon 'in sɨtsʉʉ'¹³ cwoo²¹ tɨɨ²ɨ. Joon gaun'láa²mo Jesús 'ii. ");
INSERT INTO chqNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Joon fúu¹mo tsá² néei¹ Galilea ngalíin²mo coon'¹³ Jesús. Ngalíin²mo jon 'inlɨ́ɨi¹³ tsá² néei¹ Decápolis, coon'¹³ Jerusalén. Seen²¹mo jon 'in ningalíin² coon'¹³ fu lɨ sii²¹ Judea joongɨ fu cwoo'¹³ roon¹on lɨ' caai¹ lɨ 'yeei²¹ ñi'¹ jmɨɨ²¹ Jordán. ");
INSERT INTO chqNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Joon mo gangaa¹i Jesús 'in tsá² fúui¹ lɨ¹ gasoo¹o coon²¹ moo'²¹ joon do‑o gacwó²o. Joon gangatyéein¹ tsá² tya'a cu' lɨ' lɨ tyíin¹in, ");
INSERT INTO chqNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","joon ga'laa²¹ Jesús 'wii²¹² 'e'²e 'in tsá² do, jin'²in: ");
INSERT INTO chqNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Jløø'³mo 'in ñí²i 'e 'ná¹ licwii¹in Dios, tsʉ tyʉ'² Dios to² 'ii. ");
INSERT INTO chqNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Jløø'³mo 'in néi¹ fa'í³ tsʉ icwo'¹o Dios 'ii fo'feei'¹ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Jløø'³mo 'in 'wo²‑tsi 'áai¹ tsʉ i'ii'²¹mo 'e juncwii²¹ 'múui². ");
INSERT INTO chqNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Jløø'³mo 'in 'iin²¹²in 'áai¹ jmá¹a la to² tyʉ'² Dios, tsʉ Dios iuncoon'¹³on 'ii 'e jmoo¹o jiin'¹³ la 'iin²¹²in. ");
INSERT INTO chqNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Jløø'³mo 'in feei'¹‑tsi tya' tsá² xeei'²¹ tsʉ ilifeei'¹‑tsi Dios coon'²¹ tún² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Jløø'³mo 'in jo tóin¹ júu³ tya'a tsʉ 'ii‑o iníi²i Dios. ");
INSERT INTO chqNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Jløø'³mo 'in jmoo¹o 'e seein²¹ tsá² tyʉ́² la 'oo'²¹ 'ii tsʉ ilii¹in jóon¹ Dios. ");
INSERT INTO chqNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Jløø'³mo 'in ní²i wúu¹ tsʉ 'wii'¹³ jmoo¹o la to² tyʉ'² Dios tsʉ Dios tyʉ'²ʉ to² 'ii. ");
INSERT INTO chqNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Jløø'³mo 'naa' mo jíi²in tsá² 'naa' joon jmaai'²¹ tsá² 'naa' joon faa'²¹a tsá² júu³ tajuu²¹ gó² tyi'naa' 'wii'¹³ cwáain¹ tyiia. ");
INSERT INTO chqNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Jmaa²aa' jløø'³naa' jo cwolii¹innaa' caain'²¹ tsʉ i'ii'¹³naa' coon²¹ 'e tyʉ́² 'áai¹ tyii' fu ñʉ'fú². Tsʉ la joon jon gajmaa¹a tsá² tya' 'in nigacwoo¹o júu³ tyʉ́² tya' Dios ca la mo jéei¹, ga'ǿø¹mo tsá² 'ii. ");
INSERT INTO chqNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’'Naa' lɨ́ɨ¹naa' lawa ñi² jee²¹² tsá² taain²¹² juncwii²¹ lo. Pe wana jo jmaai'²¹gɨ to² ñi² tya'a, jo li ñi²gɨ 'uunñi² tya'a. Jo lí² liñi²gɨ tún¹. Jo jmeei¹gɨ to² jiin'¹³ 'e dya'² tsá² tya'i fu¹ 'ø'¹ tsá² joon. ");
INSERT INTO chqNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’'Naa', 'in lɨ́ɨi¹ tsá² tyiia, lɨ́ɨ¹naa' lawa coon²¹ jɨ́² 'e coo²¹ tya' tsá² taain²¹² juncwii²¹. Wana ná¹ coon²¹ fuu²¹ yʉ' moo'²¹ jo lí² 'meei'²¹ 'ña'a. ");
INSERT INTO chqNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","La joon jon jiin'¹³ jaain²¹ tsá² jo lí² 'úi¹ jɨ́² coon²¹ jɨ́² coo²¹o joon sii'²¹i nʉ' coon²¹ 'mó² 'ii'²¹ cwuu²¹. Pe xʉ joon isii'²¹i lɨ yʉ'gɨ do joon lí² jnee¹i jleei'²¹ 'in néei¹ tsi inʉʉ do. ");
INSERT INTO chqNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Joon la joon 'naa' jmaa²aa' 'e tyʉ́² 'e tɨ́ɨ²naa' joon coon'¹³ la joon icón² tsá² cwáain¹ 'e tyʉ́² jmoo²oo' joon iun'goo²¹o tsá² Dios Jmii²¹ tyii' tyíin¹ nʉ'fú². ");
INSERT INTO chqNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Jo cwolíi²naa' gacwéi¹na 'a jmáa³aa 'e jo 'ee to² tí¹gɨ ley tya' 'lɨɨ²¹² Moisés coon'¹³ júu³ ga'ee¹ 'in nigacwoo¹o júu³ tya' Dios la mo jéei¹. Jon'on gagóo³oo jmáa³aa la joon, gagóo³oo jmaa'¹³aa tsá² júu³ 'ee 'øøi'²¹‑tsi tsá² 'e júu³ do. ");
INSERT INTO chqNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","'E la ja'²mo fuu²¹²uu 'naa' la 'ɨɨ²¹² roon¹on ñʉ'fú² coon'¹³ cwoo'¹³ juncwii²¹ jiin'¹³ ca pii'³ wa'a lí¹ 'e jo 'ee to² tí¹ 'e ley do. Jmaa²¹mogɨ to² ca gatsín¹ jilaa'²¹ 'e 'ná² lí¹. ");
INSERT INTO chqNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Joon doñi'iin wana jo jmoo¹o la to² tyʉ'² ley do, xʉfiin'¹³ 'e 'wéi¹gɨ 'e ley do, joon 'e'²e tsá² 'e jmáa¹a tsá² la joon, xaai²¹gɨ 'in tsá² do la jee²¹² jileei'²¹ lɨ tyʉ'² Dios to². Pe 'in jmoo¹o jiin'¹³ la tí² to² tyʉ'²ʉ joon 'e'²e tsá² 'e jmáa¹a la joon, tsafee'¹mo ilii¹in lɨ tyʉ'² Dios to². ");
INSERT INTO chqNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Tsʉ fuu²¹²uu 'naa' wana jo 'øøi'²¹gɨ‑'oo' joon wana jo jmaa²gɨɨ' jiin'¹³ la 'iin²¹²in Dios jmá¹ tsá² lagɨ 'in tɨfo'² tya' ley coon'¹³ 'in tsá² fariseos jo jmɨɨ²¹² cwotáan²naa' lɨ tyʉ'² Dios to². ");
INSERT INTO chqNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Nanʉʉ²ʉʉn' júu³ tya' 'lɨɨ²¹² tsacøøi'¹³ jin'²: “Jo jngaa'¹²naa' tsá², tsʉ 'ná¹‑a lisá² 'ii'²¹ tya' 'in jngaai'¹² tsá².” ");
INSERT INTO chqNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pe fuu²¹²uu 'naa', doñi'iin 'in tya'nii'²¹‑tsi coon'¹³ ruu'²¹i ilisá² 'ii'²¹ tya' 'ii. Joon tya' jileei'²¹ 'in jíi²in ruu'²¹i 'in tsacøøi'¹³ jee²¹² 'in tyʉ'² to nifu ijmáa¹a 'ii'²¹ tya' 'ii. Joon 'in unsii²¹ ruui'²¹: “Tsá² caai²¹ 'nʉ.” 'Áai¹ tyan' 'íi¹ fo'² lɨ sɨtyʉ́² 'in jin'² la joon. ");
INSERT INTO chqNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’'Wii'¹³ joon wa 'iin²¹²u'u cwo'²'o Dios coon²¹ 'e 'yaai¹‑'o'o inʉʉ cwo'¹ pe la jee²¹² siin'¹³'in tyani altar do wa'a gatɨɨ'²¹‑'o'o 'e 'ee'¹mo ruu'²¹'u 'nʉ, ");
INSERT INTO chqNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","tʉ́² 'e cwo'²'o Dios 'e 'yaai¹‑'o'o do tyani altar. Joon cweei'², cwojmaa'¹³'a júu³ røø²¹ coon'¹³ ruu'²¹'u. Joongɨ ñi²'i ñicwo'²'o 'e 'yaai¹‑'o'o do. ");
INSERT INTO chqNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Joon wana 'iin²¹²in tsajée¹i 'nʉ tyani tsaa'to² 'e cwo'¹o 'nʉ tsaa², síin¹³ coon'¹³on júu³ røø²¹ tya'i fu lɨ cwolíin²naa' coon'¹³on joon coon'¹³ la joon jo tsajée¹i 'nʉ tyani tsaa'to². Tsʉ wana gajée¹i 'nʉ tyani tsaa'to² do, joon ityʉ'²ʉ to² 'ɨɨ'¹³ tya'a tsajéei¹ 'nʉ 'nʉñí³. ");
INSERT INTO chqNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Joon 'e la ja'²mo fuu²¹²uu 'nʉ jo lí² júu¹³'u 'nʉñí³ do ca cɨ́²'ɨ coonti 'e cuu² do. ");
INSERT INTO chqNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’'Nanʉʉ²ʉʉn' júu³ tya' 'lɨɨ²¹² tsacøøi'¹³ 'e jin'²: “Jo foo¹u'u tsamɨ́² tya' tsá² xeei'²¹.” ");
INSERT INTO chqNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pe fuu²¹²uu 'naa' doñi'iin 'in jǿø²i jaain²¹ tsamɨ́² joon wana sooin²¹ tsá² 'ii lawa'a 'e niga'laa²¹o coon'¹³ 'ido. ");
INSERT INTO chqNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Wana unní²'i tsáa¹ jmoo¹ 'le'²u, tyí²ta, pí²ta wíin² tsʉ tyʉ́²gɨ wa'a tsa'ɨ́ɨ¹ unní²'i do lagɨ wa cwoo'¹³'o lɨ 'ii²¹ la tøø²¹u'u. ");
INSERT INTO chqNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Sɨna cwoo¹'o tsáa¹ jmoo¹ 'le'²u tyʉʉ'¹³'ʉ, pí²ta wíin² tsʉ tyʉ́²gɨ tyi'i tsa'ɨ́ɨ¹ cwoo¹'o lagɨ wa cwoo'¹³'o lɨ 'ii²¹ la tøø²¹u'u. ");
INSERT INTO chqNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Gajin'²in tsá² la mo jéei¹: “Wana tíui² tsá² tsamɨ́² tya'a 'ná¹ cwo'¹o coon²¹ mo'jí² jin'²in 'e nigatíu¹mo 'oo²¹²o.” ");
INSERT INTO chqNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pe fuu²¹²uu 'naa' wa gatíui² tsá² 'oo²¹²o, wana jo mo 'láa¹a coon'¹³ tsañʉʉ'¹ xeei'²¹, 'in tsañʉʉ'¹ do jmoo¹o 'e 'lee'²¹i 'in tsamɨ́² do wa cuu'²¹i cwoo²¹o tún¹ coon'¹³ tsá² xeei'²¹. La joon jon doñi'iin tsañʉʉ'¹ 'in cuui'²¹ cwoo²¹o coon'¹³ jaain²¹ tsamɨ́² 'in nigatíui² nʉʉ'¹ tya'a i'noo¹o 'in tsañʉʉ'¹ do tsaa² lawa'a fee'²¹i tsamɨ́² tya' tsá² xee'²¹mo. ");
INSERT INTO chqNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Nanʉʉ²ʉʉn' júu³ tya' 'lɨɨ²¹² tsacøøi'¹³ 'e jin'²: “Jo cuu'¹³'u júu³ tyi'i 'e niga'é¹u tyani Ña'ñʉ'¹ʉ'.” ");
INSERT INTO chqNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pe fuu²¹²uu 'naa' jo 'é¹u'u tyani tsá² coonti. Jo 'é¹u'u coon'¹³ ñʉ'fú² tsʉ joon si'² lɨ sɨlɨɨ²¹² tya' Dios. ");
INSERT INTO chqNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Jon'gɨ'ɨ 'é¹u'u coon'¹³ cwoo'¹³ juncwii²¹ tsʉ do‑o 'ø'²ø Dios. Jon'gɨ'ɨ coon'¹³ Jerusalén tsʉ do‑o fuu²¹ tya' rǿøi¹³ 'in feei'¹. ");
INSERT INTO chqNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Jo 'é¹u'u Dios coon'¹³ po'tyi²'i tsʉ jo lí² litaa²¹ sɨ 'wii'¹ 'ee jiin'¹³ coon²¹ jnʉ́¹ tyi'i. ");
INSERT INTO chqNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Jiin'¹³ fóo¹³'o “joon” sɨ “'ún³” 'ee. Wana foo'²¹gɨ'ɨ 'áai¹ lawa 'e faa'²¹a 'in 'lɨɨi'³. ");
INSERT INTO chqNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Nanʉʉ²ʉʉn' júu³ tya' 'lɨɨ²¹² tsacøøi'¹³ 'e jin'²: “Wana gatyí²'i coon²¹ mɨ'² unní² tsá² la joon jon tyí¹ tsá² mɨ'² unní²'i. Joon wana gatyí²'i moojon² tsá² la joon tyí¹ tsá² moojón²'on.” ");
INSERT INTO chqNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pe fuu²¹²uu 'naa': Jo tɨ́ɨ¹³u'u coon'¹³ 'in gó². Lɨ' cɨɨ'¹³'ɨ jmaa²'a. Wana gatyʉʉn¹ʉn tsá² ju'²'u cataain²¹² pe cwóo¹³'o lɨ' cataain²¹gɨ ju'²'u cwotyʉʉn¹ʉn. ");
INSERT INTO chqNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Wana 'in 'iin²¹²in tsajée¹i 'nʉ tyani tsaa'to² 'e 'iin²¹²in tyí¹i 'mɨ'² tyii'¹³'i. Cwoo¹³'o 'mɨ'² tyii'¹³'i, cwóo¹³'o jon 'mɨ'³ jnʉ́¹ yʉ lúu¹³'u. ");
INSERT INTO chqNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Joon wana 'in jin'² cwocón²'on láa¹a coon²¹ kilometro cwocón²'on coon²¹gɨ lɨ́ɨ¹. Joon wana 'in mɨɨ'¹³ 'nʉ cwoo'¹³'o 'ee mɨɨ¹ɨ do. ");
INSERT INTO chqNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Joon mo 'iin²¹² tsá² 'e tyí² tyi'i cwoo'¹³ta. ");
INSERT INTO chqNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Nanʉʉ²oo' jon júu³ tya' 'lɨɨ²¹² tsacøøi'¹³ 'e jin'²: “Cwoli'iin²¹²mo'o tsá² 'in seen²¹u'u tyʉ́² coon'¹³on joon 'ee'¹mo'o 'in 'eei'¹ 'nʉ.” ");
INSERT INTO chqNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pe jna‑gɨɨ fuu²¹²uu 'naa', ―gajin'² Jesús― cwoli'née¹moo' 'in 'eei'¹ 'naa', fáa¹³aa' tyʉ́² tya' 'in faa'²¹a 'laa'²¹ tyii', jmaa²aa' jmaai'² 'e tyʉ́² tya' 'in 'eei'¹ 'naa', fáa¹³aa' júu³ tyʉ́² tya' 'in jíi²in 'naa' joon tya' 'in jmaai'²¹ 'naa'. ");
INSERT INTO chqNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Joon coon'¹³ la joon ilii²naa' jóon¹ Dios ñʉ²ʉʉ' 'in tyíin¹ ñʉ'fú². Tsʉ Dios jmoo¹ 'yeei²¹ ñi'¹ tya' tsá² gó² la joon jon tya' tsá² tyúi¹, jmoo¹o jon 'e tsáa¹ jmɨ́¹ jee²¹² tsá² jmoo¹o la to² tyʉ'²ʉ la joon jon jee²¹² 'in tsá² 'in jo jmoo¹o la to² tyʉ'². ");
INSERT INTO chqNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","¿Tɨ lɨ́ɨ²naa' 'e tɨ́²‑tsi Dios tyii' wa'a 'iin²¹²naa' jiin'¹³ 'in 'iin²¹²in 'naa'? Tsʉ 'in cón²on 'laa'¹³ tya' lɨ 'nɨɨ¹ tsá² jmoo¹o la joon. ");
INSERT INTO chqNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","¿Tɨ lɨ́ɨ²naa' 'e tyʉ́² jmoo²oo' mo foo'¹³naa' 'e tyʉ́² tya' jiin'¹³ 'in tyʉ́² seen²¹naa' coon'¹³on? Ca 'in jo cwii¹in Dios jmoo¹o la joon. ");
INSERT INTO chqNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Tsʉ 'wii'¹³ joon jmaa²aa' tyʉ́² tya' jileei'²¹ tsá² la jmoo¹o Dios tyíin¹ ñʉ'fú² tyʉ́² tya' jileei'²¹ tsá². ");
INSERT INTO chqNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’Jo jmaa²aa' 'e tyʉ́² tya' tsá² jiin'¹³ la ní²i tsá² xeei'²¹, tsʉ wana jmoo²oo' la joon jo 'ii'¹³naa' tya' Ña'ñʉ'¹ʉ' Dios tyii' 'in tyíin¹ ñʉ'fú² jiin'¹³xʉ tya' 'e tyʉ́² 'e nigajmaa²aa' do. ");
INSERT INTO chqNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Tsʉ 'wii'¹³ joon jo fu'²'u tsá² mo 'e cwo'²'o tsá² sɨtyéein¹³ jmɨɨ²¹². Tsʉ seein²¹ tsá² 'in sɨsɨ́ɨ²i 'ɨ¹‑tsi 'e jmoo¹o inʉʉ cwo'¹ sinagagas joon jee²¹² 'nʉ́¹ 'in jmoo¹o 'e tyʉ́² tya' 'in sɨtyéein¹³ jmɨɨ²¹² pe jiin'¹³ 'e ní²i tsá². Joon faa'²¹ tsá² tyʉ́² tya'a. Pe 'e la ja'²mo fuu²¹²uu 'naa', coon'¹³ 'e tyʉ́² do 'e nigafaa'²¹ tsá² tya'a ga'ii'²¹mo 'ido jiin'¹³ i'ii'²¹i 'e gatɨ́ɨ²i. ");
INSERT INTO chqNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","4","Pe mo cwo'²'o 'e 'in sɨtyéein¹³ jmɨɨ²¹², 'uun²¹mo cwo'²'o, ce jiin'¹³ 'in seein²¹ tyʉ́² coon'¹³on jo ñii¹i. Joon Ña'ñʉ'¹ʉ' tyi'i 'in ni¹ jilaa'²¹ 'e jmoo¹o tsá² 'uuin²¹ icwo'¹o 'nʉ 'e gatɨ́ɨ²u. ");
INSERT INTO chqNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Joon mo foo²oo' júu³ tyʉ́² jo jmaa²aa' la jmoo¹o 'in tsá² 'in sɨsɨ́ɨ²i 'ɨ¹‑tsi 'e jmoo¹o. 'In tsá² do tɨ́²‑tsi téen²in inʉʉ cwo'¹ sinagogas joon lɨ lɨ́¹ tyʉʉ'¹³ jee²¹² 'nʉ́¹ téen²in faa'²¹a júu³ tyʉ́² tya'a lɨ ni¹ tsá². Pe 'e la ja'²mo fuu²¹²uu 'naa': niga'ii'²¹mo 'in tsá² do 'e gatɨ́ɨ²i. ");
INSERT INTO chqNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Pe mi fo'²'o júu³ tyʉ́² tyi'i joon 'ú¹'u tsi inʉʉ joon jnɨ²'ɨ 'ñʉ́¹ do joon mɨ²'ɨ 'uuin²¹ tyani Ñʉ'²'ʉ. Joon Ñʉ'²'ʉ 'in ni¹o jilaa'²¹ 'e jmoo¹o tsá² 'uuin²¹ icwo'¹o nʉ 'e gatɨ́ɨ²u. ");
INSERT INTO chqNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Joon mo fó²oo' júu³ tyʉ́² jo jmaa²aa' la jmoo¹o 'in jo cwii¹in Dios Jmii²¹, tsá² 'in faa'²¹a júu³ 'e jo 'ee to² tí² 'ii. Joon 'ɨ¹‑tsi 'e nuu¹un dios tya'a wa faa'²¹a 'láai² naa' júu³ tyʉ́² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Jo jmaa²aa' la jmoo¹o 'ino tsʉ Ñʉ́²ʉʉ' nii¹o jilaa'²¹ 'e 'naa²aa' la nʉ'gɨ 'e mɨ́²ɨɨ'. ");
INSERT INTO chqNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Tsʉ 'wii'¹³ joon mo fó²oo' júu³ tyʉ́² joon fo²oo' la no: Nʉ'¹ʉ' tyíin¹ ñʉ'fú², cwoun'goo²¹o tsá² jiin'¹³ 'nʉ‑ʉ. ");
INSERT INTO chqNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Cwolí² 'e tyʉ'²'ʉ to² jee²¹² tsá². Cwojmaa¹a tsá² taain²¹² juncwii²¹ jiin'¹³ la 'iin²¹²u'un la jmoo¹o 'in taai² ñʉ'fú². ");
INSERT INTO chqNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Cwoo'¹³ jna'a 'uunñi² tyii'i jmɨɨ²¹² no jiin'¹³ la 'naa²¹a'a. ");
INSERT INTO chqNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Jmaa²'a fee'¹‑'o'o 'wii²¹² tyii'i jilaa'²¹ 'e gó² 'e nigajmoo²o'o. Tsʉ la joon jna'a nigajmoo²¹o'o fee'¹‑tsii'i 'e gó² 'e nigajmaa¹a tsá² tyii'i. ");
INSERT INTO chqNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Jo cwo'²'o wa'a 'e 'naa²¹a'a tsaa²; 'láa²i jna'a jee²¹² jilaa'²¹ 'e gó². Tsʉ tyi'nʉ‑ʉ jilaa'²¹ to² coon'¹³ jilaa'²¹ 'ii'²¹ coon'¹³ jilaa'²¹ 'e 'ya'²gɨ coon²¹ tøø²mo. Amén. ");
INSERT INTO chqNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Tsʉ wana 'naa' jmoo²oo' feei'¹‑'oo' tya' 'in nigajmaa¹a 'e gó² tyii' la joon jon Ñʉ́²ʉʉ' 'in tyíin¹ ñʉ'fú² ijmáa¹a feei'¹‑tsi 'wii²¹² tyii'. ");
INSERT INTO chqNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pe wana jo jmoo²oo' feei'¹‑'oo' tya' tsá² xeei'²¹ la joon jon 'Ñʉ́²ʉʉ' jo ijmáa¹a feei'¹‑tsi 'wii²¹² tsaa² tyii'. ");
INSERT INTO chqNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Joon mo cøø²øø' tyiiañi'¹ jo jmaa²aa' fa'í³ lɨ́ɨ²naa' la jmoo¹o 'in sɨsɨ́ɨ²i 'e 'ɨ¹‑tsí 'e jmoo¹o. Tsʉ 'iin²¹²in 'in tsá² do 'e iñí² tsá² 'e gø'²ø tyiiañi'¹. 'E la ja'²mo fuu²¹²uu 'naa' niga'ii'²¹mo jilaa'²¹ itɨ́ɨ²i. ");
INSERT INTO chqNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","18","Pe mo cøø'¹³'ø tyiiañi'¹ roon'¹³'un ní²'i joon xaai²¹² tyí²'i wuu'²¹ 'e jo liñí²i tsá² 'e cøø'¹³'ø tyiiañi'¹. Wa cøø'¹³'ø tyiiañi'¹ 'uuin²¹ 'e liñii¹o Ñʉ'²'ʉ joon 'ii icwo'¹o 'nʉ 'e gatɨ́ɨ²u. ");
INSERT INTO chqNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Jo saa²aa' jilaa'²¹ 'e tyʉ́² tyii' fu ni cwoo'¹³ juncwii²¹ tsʉ fu ni cwoo'¹³ juncwii²¹ joo'fu² cuu'²¹u, sɨ ili'oo² 'ee sɨ itsataai² 'uun²¹ icón² 'ee. ");
INSERT INTO chqNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","'Áa¹mo tyʉ́²gɨ tyii' wa saa²aa' 'e tyʉ́² tyii' fu ñʉ'fú² lɨ jo icuu'²¹u joo'fu² jon'gɨ ili'oo² joon jo lí² tsataai² 'uun²¹ icón². ");
INSERT INTO chqNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Joon doñilɨɨ' 'e sáai¹ tsá² 'e tyʉ́² tya'a do‑o jon 'iin²¹²in cwá²a ―jin'² Jesús. Faa'²¹gɨ Jesús jin'²in: ");
INSERT INTO chqNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","―La 'ɨ¹‑tsi tsá² la joon ingɨ́¹. Joon wana canii² 'ɨ¹‑tsi tsá² coon²¹ tsáa¹ ingɨ́¹ la ngɨ́¹ tsá² mo jmɨɨ¹. ");
INSERT INTO chqNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pe wana gó² 'ɨ¹‑tsi tsá² jo ñii¹i xiiafu tsáa¹a la mo ngɨ́¹ tsá² mo 'woo¹. Joon wa lɨ́ɨ²i tsá² 'e ngɨɨ¹ɨ mo jmɨɨ¹ pe 'e gó²o 'ɨ¹‑tsi 'áa¹mo 'íi¹ nʉʉ²¹ lɨ ngɨɨ¹ɨ. ");
INSERT INTO chqNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Jiin'¹³ jaain²¹ tsá² jo lí² jmáa¹a la to² tyʉ'² gái¹ ñi'fii²¹². Tsʉ ili'ee'¹i 'in jaain²¹ joongɨ 'in jaain²¹gɨ ili'iin²¹²mo. Joon wana ijmáa¹a la to² tyʉ'²ʉ jaain²¹ 'e jo 'ee ilitsáai¹‑tsi 'in jaain²¹ do. Joon jo lí² jmá¹a tsá² la to² tyʉ'² cuu² la 'ɨɨ²¹² jmoo¹o la to² tyʉ'² Dios. ");
INSERT INTO chqNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Tsʉ 'wii'¹³ joon fuu²¹²uu 'naa', jo cuu'¹³‑'oo' coon'¹³ jilaa'²¹ 'e cøø²øø' coon'¹³ 'e 'uu²uu' 'e taan²¹²naa' juncwii²¹ jon'gɨ tya' 'mɨ'² tyi²ii'. Tsʉ tyiin²gɨ juncwii²¹ tya' tsá² lagɨ 'e gø'² tsá² joon tyiin²gɨ cuerpo tya' tsá² lagɨ 'mɨ'² 'e tyi'²i. ");
INSERT INTO chqNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Coon²oon' cwáain¹ tya' ton¹ 'øø¹i tya'cwí² tsʉ jo 'ee jñii¹i, jon'gɨ 'ee roo²¹ tya'a 'e coon¹on, jon'gɨ 'e coon¹on wa 'máa¹a tsi tyʉʉ², xʉ lɨ'ɨ Ñʉ'²oo' 'in tyíin¹ ñʉ'fú² cwoo¹o 'e gø'²ø 'ido. Joon tyiin²gɨ 'naa' lagɨ ton¹. ");
INSERT INTO chqNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Jiin'¹³ jaain²¹ jee²¹² 'naa' lí² jmé¹i 'ña'a ca'no'³ metro lɨ níi¹gɨ coon'¹³ jilaa'²¹ 'e cu'²‑tsi lɨ́ɨ²i. ");
INSERT INTO chqNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’¿'Ee lɨ' cu'²‑'oo' coon'¹³ jilaa'²¹ 'mɨ'² tyii²ii'? Tyaan²aan' cwáain¹ lí³ cartu'² 'e cwaain²¹ jiin'¹³ lɨ cwii'²¹. 'E lí³ do jo jmoo¹o to² jon'gɨ 'mii¹i 'mɨ'² ");
INSERT INTO chqNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","pe fuu²¹²uu 'naa', ca 'lɨɨ²¹² rǿøi¹³ Salomón coon'¹³ jilaa'²¹ 'e 'ya'²gɨ tya'a jo lɨ la lɨ 'e lí³ do. ");
INSERT INTO chqNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Joon wana gajmaa¹a Dios jilaa'²¹ lí³ 'ya'²gɨ 'e taa'²¹ coon²¹ jmɨɨ²¹² joon coo²¹o coon'¹³ jɨ́², cwoliñí² 'naa' icwo'¹ Dios 'naa' jilaa'²¹ sɨɨn'¹³ɨɨn'. ¡Tsá² 'in cu'²‑tsi coon'¹³ Dios 'naa'! ");
INSERT INTO chqNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Tsʉ 'wii'¹³ joon jo cwotaan²naa' cu'²‑'oo' coon'¹³ Dios. Jo 'ɨ¹‑'oo' 'ee icøø²øø' jon'gɨ tya' i'uu²uu' jon'gɨ tya' 'mɨ'² ityíi¹³ii'. ");
INSERT INTO chqNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","'Áa¹mo 'ɨ¹‑tsi 'in jo cwii¹in Dios tya' jilaa'²¹ 'e júu³ lo, pe Ña'ñʉ'¹ʉ' 'in tyíin¹ ñʉ'fú² ñii¹o jilaa'²¹ 'e 'ná¹ jméi¹ to² tyii'. ");
INSERT INTO chqNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Pe cwoo'¹³‑'oo' 'e tyʉ'² Dios to² 'naa' joon jmaa²aa' jiin'¹³ la 'iin²¹²in. Joon wana jmoo²oo' la joon i'ii'¹³naa' jilaa'²¹ 'e catyiia² do. ");
INSERT INTO chqNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Jo 'ɨ¹‑'oo' jmɨɨ²¹² nano tya' fa'í³ ilisá² tsa'oo²¹ tsʉ fa'í³ ilisá² tsa'oo²¹ 'e tya' tsa'oo²¹‑o joon. 'E fa'í³ 'e sá² la coon²¹ jmɨɨ²¹² líin²mo tya' jmɨɨ²¹² joon. ");
INSERT INTO chqNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Jo jmaa²aa' 'ii'²¹ tya' tsá² xeei'²¹ joon jo ijmá¹a Dios 'ii'²¹ tyii'. ");
INSERT INTO chqNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Tsʉ Dios ijmáa¹a 'ii'²¹ tyii' jiin'¹³ la nigajmaa²aa' do. Coon'¹³ 'ii'²¹ 'e gatyiin²aan' tya' tsá² coon'¹³ 'ii'²¹ joon icoon¹on Dios 'ii'²¹ tyi'naa'. ");
INSERT INTO chqNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Tyʉ́² jøø²'ø 'e tyi¹ pi'³ 'yʉ unní² tsaruu'²¹'u pe jo cón²'on cwáain¹ coon²¹ po'³ 'mó² 'yʉ unni²'i 'wo'o. ");
INSERT INTO chqNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿'Ee lɨ' fu'²'u tsaruu'²¹'u: “Cwó² tyíi³ii tyi¹ 'yʉ unni²'i”, pe joongɨ 'yʉ coon²¹ po'³ 'mó² 'yʉ unni²'i? ");
INSERT INTO chqNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡'In sɨsɨɨ¹i 'ɨ¹‑tsi 'e jmoo¹o 'naa'! Tyi¹du' po'³ 'mó² 'yʉ unni²'i jéei¹ joongɨ lí² tyi²'i tyi¹ 'yʉ unní² tsaruu'²¹'u. ");
INSERT INTO chqNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Jo cwoo²oo' 'e júu³ cwaai'³ tya' Dios tya' tsá² 'in lɨ́ɨ¹i la lɨ́ɨ¹i tsii²¹, 'in jo tsí¹ tsa'goo¹o, jo 'ee ilinʉʉ'¹³ʉ jiin'¹³ ijmee'²¹mo 'naa'. La joon jon jo cwoo²oo' jilaa'²¹ 'e jai'² lɨ́ɨ²naa', 'e lɨ la lɨ perlas tyii', tya' 'in tsá² 'in lɨ́ɨ¹i la lɨ́ɨ¹i ñí¹ tsʉ jiin'¹³ i'ø'¹o 'e júu³ do ―jin'² Jesús. Faa'²¹gɨ Jesús jin'²in: ");
INSERT INTO chqNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","―Mɨ́²ɨɨ' joon icwo'¹ Dios 'naa'; joon wana 'naa'²¹naa' Dios joon ityee'²¹moo' 'ii; joon wana pó²oo' 'ooca'nʉ́¹, Dios i'ná² tyii'. ");
INSERT INTO chqNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Tsʉ tya' jileei'²¹ 'in mɨ́¹ɨ, i'ii'²¹mo; joon jileei'²¹ 'in 'noo'¹o ityii'¹³a; joon 'in pó² 'ooca'nʉ́¹ 'e 'náa¹a i'ná¹ tya'o. ");
INSERT INTO chqNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’Jiin'¹³ jaain²¹ jee²¹² 'naa' jo icwoo²oo' yʉʉn²¹ tyii' coon²¹ cuun²¹² wa'a gamɨɨ¹ɨ coon²¹ 'iñi'¹. ");
INSERT INTO chqNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Jon'gɨ cwoo'¹³naa' jaain²¹ mɨɨ'²¹ wa'a gamuu¹i jaain²¹ joo'²¹ taai² jmɨɨ²¹. ");
INSERT INTO chqNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Joon wana 'naa', 'in lɨ́ɨi¹ 'in gó², ñí²oo' 'e cwoo²oo' 'e tyʉ́² tya' yʉʉn²¹ tyii', fee'¹gɨ 'áai¹ icwo'¹ Dios 'e tyʉ́² tya' 'in mɨ́¹ɨ. ");
INSERT INTO chqNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Tsʉ 'wii'¹³ joon jmaa²aa' tya' tsá² xeei'²¹ jiin'¹³ la 'iin²¹²naa' jmaa¹a tsá² xeei'²¹ tyii'. Coon'¹³ la joon itiin'¹³moo' 'e ley tya' Moisés coon'¹³ jilaa'²¹ júu³ tya' 'in tsá² 'in gacwoo¹o júu³ tyʉ́² tya' Dios ca la mo jéei¹. ");
INSERT INTO chqNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’'Ii¹ 'naa' 'ooca'nʉ́¹ cu'² 'áai¹ tsʉ 'ú² 'áai¹ 'e 'ooca'nʉ́¹ si'² lɨ 'ii²¹ joon 'e fu¹ 'e tsá¹a lɨ 'ii²¹ 'áa¹mo 'ú² 'e fu¹ joon. Joon fúu¹mo tsá² tsalíin² fu¹ joon. ");
INSERT INTO chqNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Pe cu'² áai¹ 'e 'ooca'nʉ́¹ tyi² fu ñʉ'fú² joon tii² 'e fu¹ 'e ngo'² fu ñʉ'fú². Joon xʉ tsá² 'in tsaa'²¹ 'e fu¹ 'e tsá¹a ñʉ'fú². ");
INSERT INTO chqNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Un'øø'¹naa' yaanaa' coon'¹³ 'in tsá² 'in jin'² 'e faa'²¹a cwáain¹ tya' Dios pe jo jo'¹. Jalíin²mo jee²¹² 'naa' lawa joo'saa'²¹ xuui²¹² 'in 'wo²‑tsi 'áai¹ pe 'yiia'¹ tsiinuu²¹ 'in 'lɨɨ'³mo 'ii. ");
INSERT INTO chqNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Lí²‑i licwii²¹naa' 'ii coon'¹³ jilaa'²¹ 'e jmoo¹o tsʉ jo cún¹ tsá² mɨ'³ wuunjøø'³ 'mó² tóon¹, jon'gɨ cún¹ tsá² mɨ'³ cwaríi³ 'mó² tóon¹ náa². ");
INSERT INTO chqNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","La joon jon coon²¹ 'mó² 'oofuu²¹ tyʉ́² cwoo¹o jiin'¹³ 'oofuu²¹ tyʉ́²‑ʉ. Coon²¹ 'mó² 'e gó² cwó¹o jmaai'² 'oofuu²¹ 'e gó²‑o. ");
INSERT INTO chqNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Coon²¹ 'mó² 'oofuu²¹ tyʉ́² jo lí² cwo¹ 'oofuu²¹ gó² jon'gɨ lí² cwo¹o coon²¹ 'mó² 'oofuu²¹ gó² 'oofuu²¹ tyʉ́². ");
INSERT INTO chqNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Joon jilaa'²¹ 'mó² 'oofuu²¹ 'e jo cwo¹o 'oofuu²¹ tyʉ́² 'ná¹ 'wiin'²¹in joon coo¹o. ");
INSERT INTO chqNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Iliñí² 'naa' xiiala lɨ́ɨ¹i tsá² coon'¹³ jilaa'²¹ 'e jmoo¹o. ");
INSERT INTO chqNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Jo jileei'²¹ itsataai² lɨ tyíin¹ Dios Jmii²¹, 'in nigasɨɨ'²¹ɨ jna jin'²in: “Ña'ñʉ'¹ʉ', Ña'ñʉ'¹ʉ'.” Jiin'¹³ 'in nigajmaa¹a la to² tyʉ'² Ñʉ'³oo itsataai² lɨ tyíin¹in ñʉ'fú². ");
INSERT INTO chqNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Joon mi tyé¹ jmɨɨ²¹² joon fúu¹mo 'in jin'²in sɨɨ'²¹ɨ jna: “Ña'ñʉ'¹ʉ', nigafaa'²¹ jna'a coon'¹³ 'e sii²¹ 'nʉ, joon coon'¹³ 'e sii²¹ 'nʉ niga'wóo³na'a 'in 'lɨɨi'³ taai² 'alma tya' tsá², la joon jon nigajmoo²¹o'o milagros fee'¹ 'láai² tya' tsá².” ");
INSERT INTO chqNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Pe joon ifuu²¹²uu 'ii: “Jo mo galicwíi³na 'naa', jeen'¹³naa' tyaní³ii jileei'²¹naa' 'in nigajmaa¹a 'e gó²” ―jin'² Jesús. Faa'²¹gɨ Jesús jin'²in: ");
INSERT INTO chqNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","―Jileei'²¹ tsá² 'in nuu¹un joon jmoo¹o la to² tyʉ'²ʉʉ lɨ́ɨ¹i la lɨ́ɨi¹ tsá² 'in 'øøi'²¹‑tsi, 'in jmoo'¹³ 'nʉ́¹ ni cuun²¹². ");
INSERT INTO chqNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Joon mi jó¹ jmɨ́¹ mɨɨ'²¹, joon galifee'¹ jmɨɨ²¹, joon 'la'¹ tyí² 'e 'nʉ́¹ do pe jo gacɨɨi'² tsʉ si'² ni cuun²¹². ");
INSERT INTO chqNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Pe 'in nuu¹un joon jo jmoo¹o la to² tyʉ'²ʉʉ lɨ́ɨ¹i la lɨ́ɨi¹ tsá² 'in bái¹ 'in gajmaa'¹³ 'nʉ́¹ ni too'¹³. ");
INSERT INTO chqNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Joon mo najó² jmɨ́¹ joon galifee'¹ jmɨɨ²¹, ga'la'² tyí² 'e 'nʉ́¹ do. Joon gacɨ'²mo 'e 'nʉ́¹ do coonti. ");
INSERT INTO chqNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Joon mo gauntyeei¹ Jesús júu³ tyaa¹a do 'áai¹ tsa'goo'²¹‑tsi jileei'²¹ coon'¹³ 'e ga'ee¹e Jesús do. ");
INSERT INTO chqNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Tsʉ ga'e'²e Jesús tsá² lawa 'in 'oo¹o to² jo 'ee¹ la 'é¹ 'in tɨfo'² tya' ley tya' Moisés. ");
INSERT INTO chqNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Mo gajngáa¹i Jesús 'e moo'²¹ do fúu¹mo tsá² ngalíin² caluu. ");
INSERT INTO chqNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Joon gangatyéen¹in jaain²¹ tsá² 'in lɨ́ɨi¹ jmoowúu¹ 'e jgoo'²¹ tya' coo'¹³ lɨ ngaai'¹ Jesús. Joon 'in tsá² do gasii'²¹i wojníi¹i tyani Jesús joon jin'²in sɨɨ'²¹ɨ Jesús: ―Tsañʉʉ'¹, feei'¹du'‑'o'o, wana 'iin²¹²u'un lí²‑i un'láa²u jna. ");
INSERT INTO chqNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Joon gataan¹an Jesús cwoo²¹o tya' 'ido joon jin'²in sɨɨ'²¹ɨ 'ido: ―'Iin²¹²moo jon. Un'láa²moo 'nʉ. Joon tsifu joon ga'láa²mo 'e jmoowúu¹ 'e jgoo'²¹ 'e lɨ́ɨ¹i. ");
INSERT INTO chqNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Joon jin'² Jesús sɨɨ'²¹ɨ 'ido: ―Jo 'in fu'²'u jiin'¹³ jaain²¹. Jiin'¹³ cwoo'¹³'o cwo'eei'¹³ 'wo'o untsá². Joon cwocwoo²'o fa'¹ tya' Dios jiin'¹³ la to² gatyʉ'² ley tya' Moisés. Joon coon'¹³ la joon liñi¹ tsá² 'e niga'láa²mo'o. ");
INSERT INTO chqNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Joon mo ga'í² Jesús fuu²¹ Capernaum joon gangatyéen¹in jaain²¹ 'in tyʉ'² to² 'láa² Roma co' lɨ siin'¹² Jesús ");
INSERT INTO chqNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","joon gajin'²in sɨɨ'²¹i 'ii: ―Tsañʉʉ'¹, jmaa²'a feei'¹‑'o'o 'wii²¹² tyiia tsʉ jaain²¹ tsa'leei'¹³ tyiia raain¹ tsaa'¹³a coo'¹³ 'mó² fu tyiia. 'Áai¹ jó¹ tsaa'¹³a cuu'¹³ 'áai¹. ");
INSERT INTO chqNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Joon Jesús gajin'²in: ―Iníi³oo, niun'láa²na. ");
INSERT INTO chqNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Joon 'in tyʉ'² to² 'láa² do gañii¹i: ―Tsañʉʉ'¹, jo tɨ́ɨ²na 'e 'u'²'u inʉʉ tyiia, jiin'¹³ tyʉ'²'ʉ to² 'e un'láa²mo tsa'leei'¹³ tyiia joon i'láa²mo. ");
INSERT INTO chqNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Seen²¹mo jaain²¹ 'in tyʉ'² to² jna; jna‑a jon tyʉ'³ʉʉ to² 'láa². Joon mo tyʉ'³ʉʉ to² 'láa² tyiia 'e tsáa¹a, tsaa²¹o. Joon wa fuu²¹²uu, “na¹” joon joo²¹‑o. Joon wana tyʉ'³ʉʉ to² tsa'leei'¹³ tyiia 'ee jmáa¹a, jmaa¹o. ");
INSERT INTO chqNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Joon mo ganúu²un Jesús 'e júu³ lo joon ganga'goo²¹‑tsi, joon jin'²in sɨɨ'²¹ɨ 'in ngalíin² caluu: ―'E la ja'²mo fuu²¹²uu 'naa', jo mo gatsee'²¹na jiin'¹³ jaain²¹ jee²¹² tsá² Israel 'in jo'¹ lɨ́ɨ²i la jo'¹ lɨ́ɨi² 'ino. ");
INSERT INTO chqNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Fuu²¹²uu 'naa' 'e fúu¹mo jalíin² lɨ 'yeei²¹ ñi'¹, jalíin²mo jon lɨ' lɨ yooi'¹³ ñi'¹ jaa'¹³i 'í¹ coon'¹³ Abraham, coon'¹³ Isaac coon'¹³ Jacob fu lɨ tyʉ'² Dios to² ñʉ'fú². ");
INSERT INTO chqNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Pe i'woo²¹mo Dios fu caluu 'in nanáa¹ tyʉ́² tya' 'e dø'¹ do. I'woo²¹mo fu caluu lɨ 'íi¹ nʉʉ²¹. Joon ityi'²i, joon cuu'²¹i moojóon¹on ―jin'² Jesús sɨɨ'²¹ɨ tsá² fúui¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Joon gajin'² Jesús sɨɨ'²¹ɨ 'in tyʉ'² to² 'láa² do: ―Cwei'¹ fu tyi'i, 'e jo'¹ ni galɨ́ɨ²u'u ilí² tyi'i. Joon 'in tsa'leei'¹³ tya'a tsifu joon ga'láa²mo. ");
INSERT INTO chqNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Joon gangó¹o Jesús fu lɨ tyíin¹ Tʉ́³, joon do‑o gangaa¹i 'yiiaunsáa³ Tʉ́³ taain¹ yʉ tyíi². ");
INSERT INTO chqNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Joon gason'¹ Jesús cwoo²¹o joon tsifu gacwó² tyíi². Joon tsifu joon garoon¹on joon gatyaa¹ tyʉ́² 'e idø'¹ Jesús coon'¹³ 'in catyaai² do. ");
INSERT INTO chqNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Joon mo gatséi¹ ñi'¹ gangajée¹i tsá² 'in taai²¹² 'in 'lɨɨi'³ alma tya'a lɨ sin'² Jesús. Joon mo gatyʉ'² Jesús to² 'e 'wé¹i 'in 'lɨɨi'³ do joon ga'woo²¹mo. Joon Jesús gaun'láai² ce jileei'²¹ 'in tsatsaa'¹³ do. ");
INSERT INTO chqNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","La joon galɨ́¹ 'e gatsín¹ júu³ ga'ɨ́ɨ² 'in tsá² gacwoo¹o júu³ tya' Dios la mo jéei¹ sii²¹ Isaías mo gajin'²in: “Gajeen'¹³mo 'e jo pí³‑tsi', joon ga'wo'²o jmoowúu¹ 'e lee²e'.” ");
INSERT INTO chqNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Joon mo gangó¹ Jesús 'áai¹ fúui¹ tsá² niteen¹in ce cu' lɨ' lɨ siin'¹²in, joon gatyʉ'² Jesús to² wa'a tsalíin² tsá² tya'a lɨ' ngoo'¹³ lɨ náa¹ tyíia¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Joon jaain²¹ jee²¹² 'in tɨfo'² tya' ley do gangatyéen¹in lɨ sin'² Jesús joon jin'²in sɨɨ'²¹ɨ Jesús: ―Tɨfo'², 'iin²¹²na níi³ii coon'¹³ 'nʉ doñixiia' cwoo'¹³'o. ");
INSERT INTO chqNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Joon Jesús do gañii¹i: ―'In cwii¹ sá² too²¹ tya'a tɨɨ² xá¹ joon 'in ton¹ sá² sɨɨ²ɨ pe 'in Ruu'²¹i Tsá² jo sá² tya'a lɨ ján³. ");
INSERT INTO chqNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Jaain²¹gɨ 'in lɨ́ɨ¹i tsá² tya'a gajin'²in sɨɨ'²¹ɨ Jesús: ―Ña'ñʉ'¹ʉ', 'iin²¹²na níi³ii coon'¹³ 'nʉ pe cwo'²'o ni'áai¹³duu ñʉ'³ʉʉ jéei¹ nifu. ");
INSERT INTO chqNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Joon Jesús do gañii¹i: ―Na¹ coon'¹³ jna. Cwolí² cwo'aai¹ 'in jo cwii¹in Dios 'in 'lɨɨ²¹² do. ");
INSERT INTO chqNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Joon ga'í² Jesús tsi barco coon'¹³ tsá² tya'a 'in ngalíin² coon'¹³. ");
INSERT INTO chqNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Joon garóon² coon²¹ tyí² tá² lɨɨlɨ́¹ ca ganga'ó² jmɨɨ²¹ tsi barco do. Joon cwuu²¹mo Jesús la jee²¹² do. ");
INSERT INTO chqNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Joon tsá² tya'a ngalíin² ngaunjnaa¹‑tsi 'ido. Joon gajin'²in: ―¡Ña'ñʉ'¹ʉ'! Laai²¹² jna'a. Tɨ lɨ te²moo'o. ");
INSERT INTO chqNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Joon Jesús do gañii¹i: ―¿'Ee lɨ' 'goo'²¹oo' 'áai¹? ¡'Áai¹ xʉ jai'² lɨ́ɨ²naa'! Joon garóon² Jesús joon gatyʉ'²ʉ to² 'e tyí² do coon'¹³ jmɨɨ²¹ do 'e ján² tii². Joon coonti gajaan¹an tii². ");
INSERT INTO chqNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","'Áai¹ tsa'goo²¹‑tsi 'in tsá² do joon gajin'²in: ―¿'Iin‑gɨ 'in tsañʉʉ'¹ no? Ca tyí² coon'¹³ jmɨɨ²¹ nʉʉ'¹³ʉ to² tyʉ'² 'ino. ");
INSERT INTO chqNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Joon mo gatyíi¹a Jesús lɨ' ngóo'¹³ tyíia¹ cataain²¹ do lɨ roon¹ cwoo'¹³ 'wó² tya' tsá² seein²¹ Gadara gái¹ tsañʉʉ'¹ 'in taai² 'in 'lɨɨi'³ alma tya'a ga'woo²¹i lɨ taa'¹³ 'áan³ tya' 'lɨɨ²¹². 'In gái¹ do 'in 'lɨɨ'³mo ca jo lí² ngɨ́i¹ tsá² lɨ' co' lɨ táa¹i. Joon gangatyéen¹in lɨ sin'² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Joon ga'láa² 'wii²¹² 'oo¹o gajin'²in: ―¿'Ee to² ñi'²'i jee²¹² jna'a, Jesús? Jóon¹ Dios 'nʉ. ¿Tɨ ñi'²'i 'e 'e'²'e jna'a wúu¹ la nʉ'gɨ ijó¹ 'ii'²¹? ");
INSERT INTO chqNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Joon coo'¹³ joon taain²¹² ca poo²¹² ñí¹ fúui¹ lɨɨlɨ́¹ gø'²ø. ");
INSERT INTO chqNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Joon 'in 'lɨɨi'³ taai² tya' 'in tsá² do gamɨɨ¹ɨ tyani Jesús jin'²in: ―Wana 'woo²¹o'o jna'a wa'a cwo'²'o tsatoo²¹o'o alma tya' 'in ñí¹ no. ");
INSERT INTO chqNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Joon gajin'² Jesús sɨɨ'²¹ɨ 'in 'lɨɨi'³ do: ―Cwolíin²naa'. Joon 'in 'lɨɨi'³ taai² alma tya' 'in tsá² gái¹ do ga'woo²¹mo joon ngataa²¹²i alma tya' 'in ñí¹ do. Joon tsifu joon 'in ñí¹ do ngalíin² cwiin¹in lɨ' sɨjɨ́² joon gaxuu'²¹i tsi tyíia¹ do, joon gajgoo'²¹ jmɨɨ²¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Joon 'in 'aai¹ ñí¹ do ngalíin² cwiin¹in 'goo'²¹o fu ifuu²¹ gajmaa'¹³a tsá² júu³ xiiala galɨ́¹ tya' 'in tsá² 'in taai² 'in 'lɨɨi'³ alma tya'. ");
INSERT INTO chqNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Joon jileei'²¹ tsá² néei¹ 'e fuu²¹ do ngalíin² ngajǿø²i Jesús. Joon mo gangaai¹ 'in tsá² do Jesús gamɨɨ¹ɨ tyani Jesús wa cwo'ɨ́ɨ¹i 'ido fu goo¹o. ");
INSERT INTO chqNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Joon ga'í² Jesús tsi barco do joon gangɨ́ɨ¹i lɨ' cataain²¹ caai¹ tyíia¹ do. Joon gatyee'¹²i fuu²¹ lɨ taain¹. ");
INSERT INTO chqNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Joon gajée¹i tsá² jaain²¹ tsá² 'in 'ii'¹³ tá² cwoo²¹ tɨɨ²ɨ 'yuui² coon²¹ jmoo²¹. Joon mo ganí² Jesús xiiala jo'¹ lɨ́ɨ²i 'in jalíin² do gajin'²in sɨɨ'²¹i 'in tsatsaa'¹³ do: ―Tya¹‑'o'o yú², ni'iin²moo tsaa² tyi'i. ");
INSERT INTO chqNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Joon 'inlɨ́ɨi¹³ tɨfo'² tya' ley 'in taai² do niga'ɨ¹‑tsi: “'In tsá² lo faa'²¹a 'laa'²¹ tya' Dios coon'¹³ júu³ tya'a.” ");
INSERT INTO chqNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Joon galiñii¹i Jesús 'ee 'ɨ¹‑tsi 'in tsá² do joon gaunngɨɨ¹ɨ, jin'²in: ―¿'Ee lɨ 'ɨ¹‑'oo' 'e gó²? ");
INSERT INTO chqNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿No‑o jo taai²¹²gɨ fuu²¹²uu 'in tsá² no: “Ni'iin²moo tsaa² tyi'i”, sɨ fuu²¹²uu 'e: “Ráan²un ngɨ́² tɨ́ɨ¹³'ɨ”? ");
INSERT INTO chqNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Pe 'e liñí² 'naa' 'e Ruu'²¹i Tsá² 'oo¹o 'ii'²¹ ili'iin²in tsaa² tya' tsá² mo taain²¹² juncwii²¹, jøø²øø' 'elo. Joon gajin'² Jesús sɨɨ'²¹ɨ 'in tsatsaa'¹³ dó²: ―Ráan²un no; pé¹ jmoo²¹ tyi'i no, cwei'¹ fu tyi'i. ");
INSERT INTO chqNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Tsifu joon garoon¹on 'in tsá² do joon nga'²mo fu tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Joon gafoo'¹³mo 'in tsá² néei¹ do mo ganí² 'elo, joon gaun'goo²¹o Dios 'e nigacwo'¹o Dios 'ii'²¹ 'e li 'iin² tsá² tsaa² tya' tsá². ");
INSERT INTO chqNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Joon mo gacwo'ɨ́ɨ¹ɨ Jesús fu lɨ taain¹ do gangaa¹i jaain²¹ tsá² sii²¹ Mateo tyíin¹in cón² 'laa'¹³ 'e 'nɨɨ¹ tsá². Joon gajin'² Jesús sɨɨ'²¹ɨ Mateo do: ―Na¹ coon'¹³ jna. Joon 'in Mateo do garóon²on lɨ tyíin¹in joon gangó¹ coon'¹³ Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Joon ga'í² Jesús coon²¹ inʉʉ. Gøø'²¹ø 'íi¹i. Joon gatyalíin² fúui¹ 'in cón² 'laa'¹³ lɨ 'nɨɨ¹ tsá² coon'¹³ fúu¹mogɨ 'in røøi²¹ tsaa². Coon²¹ caan²mo néei¹ gø'²ø coon'¹³ Jesús joongɨ coon'¹³ tsá² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Joon mo gangó¹ tsá² fariseos 'e tyíin¹ Jesús gø'²ø coon'¹³ 'in cón² 'laa'¹³ do gajin'²in sɨɨ'²¹ tsá² tya' Jesús: ―¿'Ee lɨ' tyíin¹ tɨfo'² tyii' gø'²ø coon'¹³ 'in cón² 'laa'¹³ joongɨ coon'¹³ 'in tsá² røøi²¹ tsaa²? ");
INSERT INTO chqNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Joon nuu¹un Jesús 'e jin'² 'in tsá² do joon gajin'²in: ―'In tsá² tyúi¹ coon'¹³ 'in tsá² tyʉ́² sɨ'ɨ́ɨ¹‑tsi jo 'néi¹ tɨmɨ́¹ tya'a, jiin'¹³ tsatsaa'¹³ 'néi¹ tɨmɨ́¹ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Cwolíin²naa', cwolitɨ́ɨ²moo' 'ee 'øøi'²¹‑tsi tsá² 'e júu³ tya' Dios 'e jin'²: “'Iin²¹²gɨɨ 'e jmá¹a tsá² fee'¹‑tsi tya' tsá² xeei'²¹ lagɨ'ɨ cwo'¹o jna fa'¹.” Tsʉ jo gagoo²¹²oo wa'a tǿ³øø 'in tsá² tyúi¹, gagoo²¹²oo 'e tǿ³øø 'in røøi²¹ tsaa² wa'a ijaa'²¹‑tsi. ");
INSERT INTO chqNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Joon gangatyéen¹in 'in tsá² 'in ngɨ́¹ coon'¹³ Wó³ saai¹ tsá² jmɨɨ²¹ co'² lɨ tyíin¹ Jesús joon gaungɨɨ¹ɨ: ―'In tsá² fariseos la joon jon jna'a tyé²e'e tyiiañi'¹. ¿Ee lɨ jo gø'²ø tsá² tyi'i tyiiañi'¹? ");
INSERT INTO chqNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Joon gañii¹i Jesús: ―Jo jmoo¹o tsá² fa'í³ mo tsáa¹a lɨ cuui'¹³ cwoo²¹ tsá² la 'ɨɨ²¹² tyíin¹ 'in tsá² cuui'¹³ cwoo²¹ do. Pe ijó¹‑o coon²¹ jmɨɨ²¹² mo jo tyíin¹gɨ 'in nigacuui'¹³ cwoo²¹ do joongɨ idø'²ø tyiiañi'¹. ");
INSERT INTO chqNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Jiin'¹³ jaain²¹ jo toon'¹³ 'mɨ'² fiin²¹ coon²¹ 'mɨ'² natsáai² tsʉ mi ron'² tsá² itsʉʉ'² 'e 'mɨ'² fiin²¹ do joon ilifee'²gɨ lɨ 'gɨɨ¹ɨ. ");
INSERT INTO chqNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","La joon jon jo tyiia'²¹ tsá² jmɨ'³ móo¹ tsi loo²¹ tsáai² tsʉ wana jmoo¹o tsá² la joon i'gɨɨ¹ɨ 'e loo²¹ tsáai² do joon tsa'ɨ́ɨ¹ɨ 'e jmɨ'³ móo¹ do coon'¹³ loo²¹. Tsʉ 'wii'¹³ joon tyiia'²¹ tsá² jmɨ'³ móo¹ tsi loo²¹ 'mɨ́ɨ² joon tyʉ́² jee²¹² tún² do. ");
INSERT INTO chqNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","La jee²¹² tyíin¹ Jesús faa'²¹a 'e júu³ do gatyía¹ jaain²¹ tsá² feei'¹ tya' tsá² Israel. Joon gasi'²i wojníi¹i tyani Jesús joon gajin'²in: ―La ngayuui'¹³ júun²mogɨ yʉʉn²¹ tyiia. Pe wana cwoo'¹³'o cwotaan'¹³'an cwoo¹'o tya'a joon ijiin'¹in tún¹. ");
INSERT INTO chqNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Joon garóon²on Jesús gangóo¹o coon'¹³ 'ido coon'¹³ tsá² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Joon lɨ ningóo¹o 'yuui fu¹ gason'²on jaain²¹ tsamɨ́² tsaa'¹³ tɨ' sɨɨn'³. Dyatun¹ jiin²¹ ningó¹ 'e tuuin²¹ 'in tsamɨ́² do. Ga'ɨ¹‑tsi 'in tsamɨ́² do: “Xʉfiin'¹³ coon'²¹ son'³oon sɨɨn'³ 'ido in'láa²moo.” Tsʉ 'wii'¹³ joon gangatyéen¹in caluu lɨ ngó¹ Jesús gason'²on sɨɨn'³ɨn. ");
INSERT INTO chqNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Joon gajiin¹in 'ña'a Jesús gajǿø²i 'in tsamɨ́² do joon gajin'²in: ―Tya¹‑'o'o yú². Tsʉ niga'láa²mo'o tsʉ 'wii'¹³i jo'¹o galɨ́ɨ²u'u. Joon tsifu joon ga'láa²mo 'in tsamɨ́² do. ");
INSERT INTO chqNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","La jee²¹² joon gatyía¹ Jesús tya' 'in tsafeei'¹ do. Joon mo gangoo¹o nataai² tɨ́² 'e tɨ lɨ tsa'áa¹mo 'ido joon ganaa²¹² 'goo¹ 'áai¹. ");
INSERT INTO chqNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Joon gajin'² Jesús: ―'Wóo²naa', tsʉ jo mo 'lɨɨi²¹² 'in sɨmɨ́² no lɨ' cwuu²¹mo 'ino. Joon 'in tsá² do gacoo'²¹ ngɨ́ɨ² tya' Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Mo ga'wóo²i 'in tsá² do ga'í² Jesús lɨ raain¹ 'in sɨmɨ́² do joon gason'²on cwoo²¹o 'ido. Joon garóon²o 'ido. ");
INSERT INTO chqNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Joon galiñi¹ tsá² 'in néei¹ la caain²¹ fuu²¹ taa'¹³ do jilaa'²¹ 'e nigalɨ́¹. ");
INSERT INTO chqNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Mo gacwo'ɨ́ɨ¹ Jesús tsi inʉʉ do gái¹ tsá² tiui² ngalíin² caluu Jesús 'oo¹o tá² jin'²in: ―¡Fúu² cwolii¹u jna'a, Jóon¹ David! ");
INSERT INTO chqNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Joon mo gatyee'¹²i Jesús fu tya'a 'in tsá² tiui² do gangatyéen¹in joon gaungɨɨ¹ɨ Jesús 'ii: ―¿Tɨ la jai'² lɨ́ɨ²naa' 'e liun'láa²na 'naa'? Joon gañii¹i 'in tsá² do: ―Jo'¹o lɨ́ɨi² jna'a, Ña'ñʉ'¹ʉ'. ");
INSERT INTO chqNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Joon gataan¹an Jesús cwoo²¹o unni² tsá² tiui² do joon jin'²in sɨɨ'²¹ɨ 'ido: ―Cwolí² jiin'¹³ la jo'¹ lɨ́ɨ²naa'. ");
INSERT INTO chqNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Joon ga'lóo²o unníi¹i. Joon Jesús ga'ɨ́ɨ²ɨ júu³ jin'²in sɨɨ'²¹ɨ 'ido: ―Xúun² fú²uu' jiin'¹³ jaain²¹ 'e niga'lóo²o unní²ii'. ");
INSERT INTO chqNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Pe xʉʉ joon xʉʉ 'wóo²i xʉ do joon gajma'²a júu³ jileei'²¹ 'in néei¹ do jilaa'²¹ 'e nigajmaa¹a Jesús tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Joon mo ga'wóo²i 'in gái¹ do joon 'in xeei'²¹gɨ ngataai² jée¹i jaain²¹gɨ tsá² 'in jo lí² faa'²¹a lɨ tyíin¹ Jesús. 'In 'lɨɨ'³mo 'yuui² alma tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Joon mo gatyii¹in Jesús 'in 'lɨɨi'³ 'yuui² alma tya'a do tsifu joon ga'láa² 'in tsá² do 'wii²¹² faa'²¹a. 'Áa¹mo tsa'goo²¹‑tsi 'in tsá² taai² do joon gajin'²in: ―Jiin'¹³ cafu jo mo nee²¹e' fu goo²¹o' Israel la lɨ́¹ 'e ganee²¹e' nano. ");
INSERT INTO chqNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pe 'in tsá² tya' fariseos do gajin'²in: ―'In tsañʉʉ'¹ no 'woo²¹i 'in 'lɨɨi'³ taai² alma tya' tsá² coon'¹³ 'ii'²¹ tya' 'in tyʉ'² to² 'ii. ");
INSERT INTO chqNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ngóo¹ Jesús la caain²¹ fuu²¹ coon'¹³ fuu²¹ pi'³ náa¹ do. Tsi inʉʉ cwo'¹ sinagogas gacwo¹ júu³ tyʉ́² tya' mi li tyʉ'² Dios to² tsá². Joon gaun'láa²i jileei'²¹ tsatsaa'¹³ 'in tyaan¹an 'láai² nii² jmoowúu¹. ");
INSERT INTO chqNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Joon mo gajǿø²i Jesús 'in tsá² do fúu² galɨ́ɨ²i ni'i 'ido tsʉ 'in tsá² do lɨ́ɨ¹i la lɨ́ɨi¹ joo'saa'²¹ 'in jo seein²¹ 'in 'aa¹i 'ii, 'woo'²¹o joon caain'²¹ lɨ́ɨ¹i. ");
INSERT INTO chqNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Joon Jesús jin'²in sɨɨ'²¹ɨ tsá² tya'a: ―'E la ja'²mo, fee'¹ 'áai¹ 'e sá² 'e roo¹ pe xʉʉ tsa'leei'¹³ seein²¹ 'in jmaa¹a to². ");
INSERT INTO chqNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Tsʉ 'wii'¹³ joon mɨ́²ɨɨ' tyani Fii²¹² 'in cwó¹ 'e roo¹ 'e sá² 'e síi¹in tsa'leei'¹³ tya'a jee to² 'e cóon¹on 'e garoo¹o do. ");
INSERT INTO chqNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Joon gatø'²ø Jesús dyatooin¹ tsá² tya'a joon gacwo'¹o Jesús 'in tsá² do 'ii'²¹ 'e lí² 'wóo²i 'ido 'in 'lɨɨi'³ taai² alma tya' tsá² joon 'e lí² un'láa²i tsá² jilaa'²¹ jmoowúu¹ 'e lɨ́ɨi¹ tsá². ");
INSERT INTO chqNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","'Elo‑o 'e sii²¹ 'in dyatooin¹ tsá² tya'a ilíi²in apóstoles: 'in nifu sii²¹ Simón, sii²¹o jon Tʉ́³; coon'¹³ ruu'²¹i Dɨ́ɨ³. Joon gái¹ jóon¹ Zebedeo 'in sii²¹ Jacobo coon'¹³ Wó³. ");
INSERT INTO chqNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Seein²¹ jon Lii²¹² coon'¹³ Bartolomé coon'¹³ Tomóo¹³ coon'¹³ Untøø², 'in gacón² 'laa'¹³ tya' 'e 'nɨɨ¹ɨ tsá² la mo jéei¹. Joon seein²¹ Jacobo, jóon¹ Alfeo; joon seein²¹ jon Lebeo, 'in sii²¹o jon Tadeo. ");
INSERT INTO chqNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Joon jaain²¹ jee²¹² 'ido sii²¹ Simón, jaain²¹ tsá² tya' tsá² coon²¹ poo²¹² sii²¹ cananistas. Joon seein²¹ jon Judas Iscariote, 'in ga'nɨɨ¹i Jesús mo lɨ cɨɨin¹gɨ. ");
INSERT INTO chqNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Joon Jesús gasii¹in 'in dyatooin¹ tsá² tya'a do joon gatyʉ'²ʉ to² jin'²in: ―Jo cwolíin²naa' lɨ néei¹ 'in tsá² 'in jo seein²¹ Israel, joon jo cwotaan²naa' fuu²¹ náa¹ lɨ sii²¹ Samaria. ");
INSERT INTO chqNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Tyʉ́²gɨ wa'a cwolíin²naa' tya' jiin'¹³ tsá² Israel 'in lɨ́ɨi¹ la lɨ́ɨi¹ joo'saa'²¹ 'in nituu¹i. ");
INSERT INTO chqNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Cwolíin²naa', cwocwoo²oo' júu³ 'e tɨ lɨ tyʉ'² Dios to² tsá². ");
INSERT INTO chqNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Un'láa²naa' 'in tsatsaa'¹³ joon 'in tsá² lɨ́ɨi¹ jmoowúu¹ 'e jgoo'²¹ tya'a. Jmaa²aa' jiin'¹ 'in najúin¹. 'Wóo²naa' caluu 'in 'lɨɨi'³ taai² alma tya' tsá². 'Naa' niga'ii'¹³'naa' 'e 'ii'²¹ lo 'e jo 'ee gacɨɨin¹ tyii' la joon jo 'ee 'laa'¹³ cón²oon'. ");
INSERT INTO chqNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Jo cwotyaan²aan' cuu² cwanáa¹ jon'gɨ cuu² cwataa²¹ jon'gɨ cuu² yʉ́ʉn² ");
INSERT INTO chqNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","jon'gɨ tulóo¹³oo'. Coon²¹ 'mɨ'² cwaa²¹ cwotyíi¹³ii' joon jo cón²oon' mɨ́ɨ¹³ɨɨ' jon'gɨ soon²oon' 'mo'u². Tsʉ 'in jmoo¹o to² tɨ́ɨ²i 'ii'²¹i 'e dø'²ø. ");
INSERT INTO chqNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Mi tyalíin²naa' coon²¹ fuu²¹ sɨ coon²¹ fuu²¹ pi'³ 'ee, 'naa'¹³naa' jaain²¹ tsá² tyúi¹ joon do‑o jón²oon' ca 'wóo²naa' do. ");
INSERT INTO chqNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Joon mi cwotaa²naa' inʉʉ joon fú²uu': 'Aa²¹²moo' tyʉ́²‑ʉ sɨ'ɨ́ɨ¹‑'oo'. ");
INSERT INTO chqNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Joon wana ga'ii'²¹i tyʉ́² 'e 'aa²¹²i do iliseein²¹ tyʉ́²‑ʉ. Pe wa jo ga'ii'²¹i júu³ tyii' tyiin¹aan' 'e 'aa²¹²i nigasíi¹³ii' do. ");
INSERT INTO chqNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Joon wana jo 'ii'²¹i jon'gɨ jo 'iin²¹²in núu¹un júu³ tyii' cwo'wóo²naa' 'e 'nʉ́¹ do sɨ fuu²¹ do 'ee joon xʉʉ²ʉʉ' 'laa²¹ toon²¹² tɨ́ɨ¹³ɨɨ'. ");
INSERT INTO chqNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","'E la ja'²mo fuu²¹²uu 'naa' 'áai¹gɨ iní² wúu¹ 'in tsá² néei¹ 'e fuu²¹ do mi cwá¹ jmɨɨ²¹² ijmá¹ Dios 'ii'²¹ tya' tsá² lagɨ 'in tsá² néei¹ fuu²¹ Sodoma coon'¹³ Gomorra. ");
INSERT INTO chqNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’Tyan²duu' cwáain¹, sɨ́ɨ³na 'naa' lawa joo'saa'²¹ 'e cwolíin²naa' jee²¹² tsiinuu²¹. Tsʉ 'wii'¹³ joon jmaa²aa' lí³ii' la jmoo¹o mɨɨ'²¹ li'³i pe seein²¹naa' 'wo²‑'oo' lawa jaain²¹ maa²¹². ");
INSERT INTO chqNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Lí³ii' jmaa²aa' tya' tsá² tsʉ tsajée¹i 'naa' tyani tsaa'to² joon ipóo¹i 'naa' tsi inʉʉ cwo'¹ sinagogas. ");
INSERT INTO chqNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Joon 'wii'¹³ jna ijéi¹ tsá² 'naa' tyani tsaa'to² tsacøøi'¹³ joongɨ tyani rǿøi¹³. Joon coon'¹³ la joon lí² fó³oo' 'wii²¹² tyiia tyaníi¹i joongɨ tyani 'in jo tsáa¹‑tsi Dios. ");
INSERT INTO chqNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Joon mi jéi¹ tsá² 'naa' tyani tsaa'to² jo cuu'¹³‑'oo' 'ee ifó³oo' tyani tsaa'to² do tsʉ mi tɨ 'ii'²¹ ifó³oo' Dios icwo'¹o 'naa' 'ee ifó³oo' do. ");
INSERT INTO chqNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Jon' 'naa' 'in faa'²¹a do pe 'in Espíritu Tyʉ́² tya' Ñʉ'²ʉʉ' Dios Jmii²¹ 'in faa'²¹a coon'¹³ 'naa'. ");
INSERT INTO chqNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’La 'oo'²¹ ruu'²¹i tsajée¹i ruu'²¹i tyani tsaa'to² ijngaa'¹³i la joon jon tsacøøi'¹³ tsajée¹i jóon¹on. La joon ijmá¹ jóon¹on coon'¹³ sáa³ jmii²¹ itsajée¹i tyani tsaa'to² ijngaa'¹³i tsá² 'ii. ");
INSERT INTO chqNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Jileei'²¹ tsá² taain²¹² juncwii²¹ ili'ee'¹i 'naa' tsʉ 'wii'¹³ ja'²mo lɨ́ɨ²naa' cwáain¹ tyiajna. Pe jileei'²¹ 'in jmaa¹a taa'²¹ ca lɨ tyéi¹ itiin'¹³mo. ");
INSERT INTO chqNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Mo ga'ǿi¹ tsá² 'naa' coon²¹ fuu²¹ cwíin¹³iin' fuu²¹ lɨ xiia'²¹gɨ. Tsʉ 'e la ja'²mo fuu²¹²uu 'naa' 'in Ruui'²¹ Tsá² ijó¹ la nʉ'gɨ icwíin¹³iin' la caain²¹ fuu²¹ lɨ néei¹ tsá² Israel. ");
INSERT INTO chqNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Jiin'¹³ jaain²¹ 'in untsáa¹a ilifeei'¹gɨ lagɨ tɨfo'² tya'a, jon'gɨ ilifeei'¹gɨ tsa'leei'¹³ lagɨ ñi'fii²¹²i. ");
INSERT INTO chqNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","'Ná¹‑a 'yaai¹‑tsi 'in untsáa¹a 'e 'yee'¹i jiin'¹³ la tɨfo'² tya'a do, joon 'in tsa'leei'¹³ do 'e 'yee'¹i jiin'¹³ la ñi'fii²¹²i. Joon wana gaunsii²¹ tsá² 'in tyʉ'² to² inʉʉ do Beelzebú, ¿'ee iunsii²¹ 'in tsá² taai² inʉʉ do? (Wana gasɨɨ'²¹ɨ jna 'e gó² xʉfoo'³ 'naa'gɨ jo sɨɨ'²¹ɨ 'e gó².) ");
INSERT INTO chqNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Tsʉ 'wii'¹³ joon jo jmaa²aa' 'goo'²¹ tyani tsá². Jo 'e sá² jiin'¹³ coon²¹ júu³ 'e 'uuin²¹ wa' jo 'in liñi¹. Joon jiin'¹³ coon²¹ 'e sɨ'mó¹ wa'a jo lijná² nii²i. ");
INSERT INTO chqNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Jilaa'²¹ júu³ 'e fuu²¹²uu 'naa' coon'²¹ cwofáa¹³aa' jee²¹² lɨ nuu¹un tsá². Joon jilaa'²¹ 'e fuu²¹²uu 'naa' lɨ 'uuin²¹ ca yʉ' 'nʉ́¹ cwo'oo²oo'. ");
INSERT INTO chqNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Jo jmaa²aa' 'gøø'²¹naa' 'in jngaai'¹² tsá² pe jo lí² jngaai'¹² alma tya' tsá². Jmaa²aa' 'gøø'²¹naa' 'in lí² 'iin² cuerpo coon'¹³ alma tya' tsá² fu lɨ 'ii²¹. ");
INSERT INTO chqNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Xʉfiin'¹³ gái¹ ton¹ tyíin¹ coon²¹ cuu² pe jiin'¹³ jaain²¹ ton¹ do ijúun²in wa jo cwo¹ Dios Ñʉ'¹ʉ' 'ii'²¹ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Joon ca jñʉ́² tyi'naa' sɨ'í³ tɨ ca mɨ'² ce jilaa'²¹. ");
INSERT INTO chqNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Tsʉ 'wii'¹³ tyiin²mo 'naa' lagɨ ton¹ fúui¹ jo jmaa²aa' 'goo'²¹oo'. ");
INSERT INTO chqNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Jileei'²¹ 'in jmoo¹o júu³ tyani tsá² 'e cwii¹in jna la joon jon jna ijmáa³aa júu³ 'e cwii¹na 'ii tyani Ñʉ'³oo 'in tyíin¹ ñʉ'fú². ");
INSERT INTO chqNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pe tya' jileei'²¹ 'in jo rǿø¹i 'e cwii¹in jna tyani tsá² la joon jon jna ifo'³oo 'e jo cwii¹na 'ido tyani Ñʉ'³ʉʉ tyíin¹ ñʉ'fú². ");
INSERT INTO chqNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","'Jo cwolíin²naa' 'e gagó³oo 'e jmáa³aa 'ii'²¹ 'e liseein²¹ tsá² tyʉ́² coon'¹³ tsá² taain²¹² juncwii²¹. Gagó³oo 'e 'wiin²¹ mɨɨ'¹³ jee²¹² tsá² jon' wa' liseein²¹ tsá² tyʉ́² coon'¹³ tsá². ");
INSERT INTO chqNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nigagó³oo ilisá² mɨɨ'¹³ jee²¹² tsá² coon'¹³ jmii²¹. La joon jon ilisá² mɨɨ'¹³ jee²¹² sɨmɨ́² coon'¹³ sáa³a. Ilisá² mɨɨ'¹³ jee²¹² unloo²¹² tya'a coon'¹³ 'yiiaunsáa³a. ");
INSERT INTO chqNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","La joon 'in tsá² la 'oo'²¹ inʉʉ tya'a ili'ee'¹mo ruu'²¹i inʉʉ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Jileei'²¹ 'in 'iin²¹²gɨ sáa³ jmii²¹ lagɨ jna jo tɨ́ɨ²i ilíin² tsá² tyiia. Joon wana 'iin²¹²gɨ tsá² jóon¹on lagɨ jna jo tɨ́ɨ²i ilíin² tsá² tyiia. ");
INSERT INTO chqNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Joon wa jo 'iin²¹²in júun²in 'wii'¹³ tyiia jo tɨ́ɨ²i ilíin² tsá² tyiia. ");
INSERT INTO chqNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Joon 'in 'iin²¹²in intiin'¹³ juncwii²¹ tya'a icaa¹mo juncwii²¹ tya'a. Pe 'in caa¹mo juncwii²¹ tya'a tsʉ 'wii'¹³ cwáain¹ tyiajna, intiin'¹³ juncwii²¹ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Joon mi 'ii'²¹ tsá² 'naa' inʉʉ tya'a tsʉ 'wii'¹³ lɨ́ɨ²naa' tsá² tyiia lawa'a 'e 'ii'²¹ 'in tsá² do jna ñiia'oo. Joon mo 'ii'²¹ tsá² jna lawa'a 'e 'ii'²¹ tsá² Nʉ'³oo 'in gasii¹in jna. ");
INSERT INTO chqNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Joon doñi'iin tsá² 'in 'ii'²¹i jaain²¹ tsá² 'in cwoo¹ júu³ tya' Dios inʉʉ tya'a i'ii'²¹i 'in tsá² do coon²¹ røø²¹ 'e la 'ii'²¹ 'in tsá² cwoo¹ júu³ tyʉ́² do tsʉ ga'iin'²¹ ni 'ido tsʉ 'wii'¹³ tsá² cwoo¹ júu³ tyʉ́² 'ido. Joon doñi'iin tsá² 'in 'ii'²¹i jaain²¹ tsá² tyúi¹ tsʉ 'wii'¹³ 'in tyú¹mo 'ii i'ii'²¹ 'in tsá² do jon coon²¹ røø²¹ la in'ii'²¹ 'in tsá² tyúi¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Joon doñi'iin tsá² 'in cwo'¹ tsá² tyiia xaai¹gɨ doñiee coon²¹ 'e pi'³, 'e la ja'²mo fuu²¹²uu 'naa', xʉfiin'¹³ coon²¹ vaso jmɨɨ²¹ cwii'²¹ gacwo'¹o 'ido, i'ii'²¹i 'in tsá² do coon²¹ 'e tyʉ́² tya' Dios. ");
INSERT INTO chqNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Joon mo ngayuui'¹³ gatyʉ'² Jesús to² 'in dyatooin¹ tsá² tya'a jilaa'²¹ 'e 'ná¹ jmáa¹a joon gacwa'ɨ́ɨ¹ɨ do ganga'e'²e tsá² joon gacwoo¹o júu³ tyʉ́² la caain²¹ fuu²¹ náa¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yiia'¹³ joon 'nʉñí³ yuui² Wó³ saai²¹ tsá² jmɨɨ²¹. Joon mo galiñi¹ xiiala jmoo¹o Cristo do, joon gasii¹in Wó³ tsá² tya'a tsajǿø²i Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ngaunngɨɨ¹ɨ: ―¿Tɨ 'nʉ‑ʉ 'in Cristo 'in ijó¹ sɨ sɨjeen²na'a 'in xeei'²¹ 'ee? ");
INSERT INTO chqNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Joon Jesús do gañii¹i: ―Cwolíin²naa' cwosíi¹³ii' Wó³ do jilaa'²¹ 'e niganí²ii' joongɨ 'e niganʉʉ²ʉʉ'. ");
INSERT INTO chqNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Cwojmáa¹³aa' Wó³ júu³ xiiala nigalɨjnaa'²¹ 'in tsá² tiui². Joon 'in jluui'¹³ nigangɨɨ¹ɨ, joon niga'láa²mo 'in tsá² jgøøi'²¹, joon ganá¹ loocwóo¹o tya' 'in tsá² jo nuu¹un, joon 'in najúin¹ gajiin'¹o. Joon tya' 'in tsá² tañíi² niganuu¹o júu³ tyʉ́² tya' Dios. ");
INSERT INTO chqNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Joon jløø'³mo 'in jo cu'²‑tsi coon'¹³ jna. ");
INSERT INTO chqNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Joon ngaliin¹mo 'in tsá² do joon ga'láa² Jesús 'wii²¹² tyaa¹ júu² cwáain¹ tya' Wó³ coon'¹³ 'in tsá² taai² do. Gajin'²in: ―¿'Ee lɨ' tyalíin²naa' tyajøø²øø' fu lɨ jo 'iin tsá² seein²¹? ¿Tɨ tyalíin²naa' tyajøø²øø' coon²¹ tó² 'e si'² jøø'²¹ lɨ 'ɨ́ɨ²ɨ tyí²? ");
INSERT INTO chqNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Wa jo la joon ¿'ee lɨ' tyalíin²naa'? ¿Tɨ tyalíin²naa' tyajøø²naa' jaain²¹ tsá² tyi'³ 'mɨ'² 'ya'²gɨ? Niñí² 'naa' 'in tsá² 'in tyi'³ 'mɨ'² 'ya'²gɨ néei¹ fu lɨ tyíin¹in rǿøi¹³. ");
INSERT INTO chqNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","'Naa' tyalíin²naa' tyajøø²naa' jaain²¹ tsá² 'in cwo¹ júu³ tyʉ́² tya' Dios. Pe 'e la ja'²mo fuu²¹²uu 'naa' nigajøø²naa' jaain²¹ feei'¹gɨ lagɨ 'in gacwo¹ júu³ tyʉ́² tya' Dios la mo jéei¹. ");
INSERT INTO chqNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Tsʉ ni jí² tya' Dios 'e jin'² cwáain¹ tya' Wó³ do: Sɨ́ɨ³na jaain²¹ tsá² tyiia 'e tsáa¹a tyaní²'i. Joon ityaa¹ tyʉ́² coon²¹ fu¹ lɨ ngɨ́²'ɨ. ");
INSERT INTO chqNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Pe 'e la ja'²mo fuu²¹²uu 'naa' jiin'¹³ jaain²¹ jee²¹² tsá² taai² juncwii²¹ jo seein²¹ 'in feei'¹gɨ lagɨ Wó³ saai²¹ tsá² jmɨɨ²¹. Pe feei'¹gɨ lagɨ Wó³ do doñi'iin 'in xaai²¹gɨ 'in 'í² lɨ tyʉ'² Dios to² tsá². ");
INSERT INTO chqNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Ca mo 'láa² 'wii²¹² cwó² Wó³ júu³ tyʉ́² la ca nano jo ga'øøi'²¹‑tsi tsá² røø²¹ xiiala ilí² 'e tyʉ'² Dios to² tsá². Joon tyitsaa¹mo 'iin²¹²in ilí² jiin'¹³ la 'ɨ¹‑tsi yaamo. ");
INSERT INTO chqNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Jileei'²¹ 'in gafaa'²¹a júu³ tya' Dios la mo jéei¹ coon'¹³ jilaa'²¹ ley tya' Moisés faa'²¹a cwáain¹ tya' xiiala tyʉ'² Dios to² ca mi jó¹ Wó³. ");
INSERT INTO chqNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Joon wana lí² jai'² ilíi²naa' 'in Wó³ no lɨ́ɨ¹i Elías 'in 'ná¹ jó¹ tún¹ jiin'¹³ la jin'² ni jí² tya' Dios. Ii jaain²¹ 'in gacwo¹o júu³ tya' Dios la mo jéei¹. ");
INSERT INTO chqNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Joon jileei'²¹ 'naa' 'in nuu¹un, nʉʉ²ʉʉ'. ");
INSERT INTO chqNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’¿'Ee 'ii'²¹ ilijmá¹a tsá² tya' 'in tsá² no ilí² coon²¹ rǿø²i? Lɨ́ɨ¹i la lɨ́ɨi¹ xuui²¹² taai²¹² to² coo¹o lɨ lɨ' 'moo'¹³ joon 'oo¹o jin'²in sɨɨ'²¹ɨ ruu'²¹i: ");
INSERT INTO chqNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Xʉʉ²¹ʉ' lúu¹ tyi' jmoo²¹o' sóoin¹³ pe jo 'in gatséen¹en. Joon ga'øø²¹ø' sóoin¹³ tya' lɨ raan¹in 'lɨɨ²¹² pe jo 'in gatyi'² jiin'¹³ jaain²¹.” ");
INSERT INTO chqNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Tsʉ gajó² 'in Wó³ do jo 'ee gø'² jon'gɨ 'ee 'uun'²¹un joon 'naa' foo²oo' 'e 'yuui² 'in 'lɨɨi'³ alma tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Mi yuui'¹³ joon jna‑gɨ lɨ́ɨ¹na Ruu'²¹i Tsá² gagoo²¹²oo joon gagu'³uu joongɨ gagø'¹oo, joon 'naa' foo²oo' 'e lɨ́ɨ¹na tsá² jlo² tu'²'u. Joongɨ lɨ́ɨ¹na tsá² 'uun'²¹ vino 'áai¹, jaain²¹ tsá² 'in tyʉ́² seein²¹ coon'¹³ tsá² 'in rǿø²i tsaa² joongɨ coon'¹³ 'in tsá² cón² 'laa'¹³ lɨ 'nɨɨ¹ tsá². Tsʉ xiiala cwo'ɨ́ɨi¹ 'e jmoo¹o tsá² jmoo¹o júu³ xiiala 'ɨ¹‑tsi 'in tsá² do sɨ tyʉ́² sɨ 'e gó² 'ee. ");
INSERT INTO chqNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Joon ga'láa² Jesús 'wii²¹² 'gáa²i sɨɨ'²¹ɨ 'in tsá² fuu²¹ lɨ gajmaa¹a 'láai² 'ii'¹³ milagros tya'a tsʉ 'in tsá² néei¹ 'e fuu²¹ do jo gajoo'²¹‑tsi. Jin'² Jesús: ");
INSERT INTO chqNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―¡Fúu² 'naa' 'in néei¹ Corazín! ¡Fúu² jon 'naa' 'in néei¹ Betsaida! Wana nigalɨ́¹ milagros fee'¹ jee²¹² fuu²¹ Tiro coon'¹³ fuu²¹ Sidón la nigalɨ́¹ jee²¹² 'naa' 'e nigajoo'²¹‑tsi 'in tsá² do jmoono. Joon i'e'²e tsá² 'e nigajoo'²¹‑tsi 'e cɨ'²ɨ 'mɨ'² lɨ́¹ tyiia²¹² joon 'ee¹e fó² tyíi¹i. ");
INSERT INTO chqNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Joon fuu²¹²uu 'naa' xʉgɨ wúu¹ iní² 'in tsá² Tiro coon'¹³ Sidón lagɨ 'naa' mi tɨ́² jmɨɨ²¹² ijmá¹a Dios 'ii'²¹ tya' tsá². ");
INSERT INTO chqNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","La joon jon 'naa' tsá² néei¹ Capernaum, ¿tɨ lɨ́ɨ²naa' 'e cwolíin²naa' fu ñʉ'fú²? Xʉ joon, ¡cwolíin²naa' fu lɨ 'ii²¹! Tsʉ wana nigalɨ́¹ fuu²¹ Sodoma milagros fee'¹ la nigalɨ́¹ jee²¹² 'naa' 'e taa'²¹a 'e fuu²¹ do ca nano. ");
INSERT INTO chqNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Pe 'e fuu²¹²uu 'naa' mi tɨ́² jmɨɨ²¹² 'e jmá¹a Dios 'ii'²¹ tya' tsá² imoo²gɨɨ' wúu¹ lagɨ 'in tsá² néei¹ Sodoma do. ");
INSERT INTO chqNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","'Yiia'¹³ joon gajin'² Jesús sɨɨ'²¹ɨ Jmii²¹: ―Cwo'³oo 'nʉ 'maai'¹³, Ñʉ'². 'Nʉ‑ʉ fii²¹² ni cwoo'¹³ juncwii²¹ coon'¹³ ñʉ'fú². Cwo'³oo 'nʉ 'máa²u'u tsʉ niga'ma'²'a 'e júu³ lo 'e jo lí² 'øøi'²¹‑tsi 'in jmɨɨ²¹²‑tsi, 'in 'øøi'²¹‑tsi joon ga'ee'¹³'e tya' 'in 'wói¹gɨ. ");
INSERT INTO chqNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Tyʉ́²‑ʉ, Ñʉ'², tsʉ la joon gali'iin²¹²u'un. ");
INSERT INTO chqNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Faa'²¹gɨ Jesús sɨɨ'²¹ɨ 'in tsá² taain²¹² do: ―Ñʉ'³ʉʉ nigacwo'¹o jna jilaa'²¹. Joon jiin'¹³ jaain²¹ jo lí² licwii¹in 'in Jóon¹ Dios wa'a jo cwo¹ Jmii²¹. La joon jon jo lí² licwii¹in jiin'¹³ jaain²¹ 'in Jmii²¹ do wa'a jo cwo¹ Jóon¹ Dios. Joon cwo¹ 'in Jóon¹ do jiin'¹³ 'in 'iin²¹²in ilicwii¹in Jmii²¹. ");
INSERT INTO chqNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ñilíin²naa' tyaní³ii jileei'²¹ 'naa' 'in 'woo'²¹ coon'¹³ to² 'e jmoo²oo' joon coon'¹³ laa²¹² tyán²aan'. Joon jna‑a icwóo³oo 'e 'ii'²¹ 'woo²¹oo'. ");
INSERT INTO chqNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","'Ii'¹³naa' júu³ tyʉ́² tyiia joon cwolicwii¹moo' jna, jmoo²oo' la to² tyʉ'³ʉʉ. 'E to² tyʉ'³ʉʉ do ilɨ́¹ la lɨ́¹ coon²¹ 'motsityi² tyii'. Pe 'wo²‑tsíi³oo joon jo tyʉ'³ʉʉ to² 'ii²¹. Joon alma tyii' i'ii'²¹i 'woo'²¹. ");
INSERT INTO chqNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","'E 'motsityi² 'e cwo'³oo 'naa' jo tyan¹ to² cón²oon' joon 'e laa²¹² cwo'³oo 'naa' jo 'áai¹ 'ii²¹. ");
INSERT INTO chqNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","La jee²¹² joon gangóo¹ Jesús fu lɨ jñi¹ tsá² trigo coon²¹ jmɨɨ²¹² mo 'ii'²¹ 'woo'²¹ tsá². Joon gatsá² un'áa¹i tsá² tya'a joon ga'láa² 'wii²¹² cúun¹un 'e 'mɨ'³ trigo do. Gauntyʉ́² coon'¹³ ja'cwoo²¹o joon gagøø'²¹o. ");
INSERT INTO chqNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Joon mo ganí² tsá² fariseos 'e jmoo¹o 'ido gajin'²in sɨɨ'²¹ɨ Jesús: ―Jǿø², jmoo¹o tsá² tyi'i to² 'e jo tɨ́ɨ²i jmá¹ tsá² mo jmɨɨ²¹² 'ii'²¹ 'woo'²¹ tsá². ");
INSERT INTO chqNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Pe 'i‑gɨ gajin'²in: ―Ñí² 'naa' xiiala gajmaa¹a 'lɨɨ²¹² David. Coon²¹ jmɨɨ²¹² mo gatsá² un'áa¹i coon'¹³ tsá² tya'a ngatáa¹i tsi inʉʉ tya' Dios ");
INSERT INTO chqNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","joon gagøø'²¹o 'e 'iñi'¹ nicwaai'³ do 'e jiin'¹³ untsá² do tɨ́ɨ²i dø'³ø. 'Lɨɨ²¹² David do jo tɨ́ɨ²i dø'²ø jon'gɨ tsá² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ñí² 'naa' jon 'e ni ley tya' Moisés tyʉ'²ʉ to² untsá² 'e jmoo¹o to² inʉʉ cwo'¹ do jmɨɨ²¹² 'ii'²¹ 'woo'²¹ tsá², joon jo 'nóo¹o tsaa². ");
INSERT INTO chqNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Joon fuu²¹²uu 'naa' jaain²¹ 'in feei'¹gɨ lagɨ 'e cwo'¹ do nacwéi¹ lo. ");
INSERT INTO chqNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Gajin'² Dios ni jí² tya'a: “'Iin²¹²moo 'e seein²¹naa' 'née²in ruu'²¹naa' lagɨ ijngaa'¹³naa' joo'²¹ joon cwoo²oo' jna fa'¹.” Wana niga'øøi'²¹‑'oo' 'e júu³ no jo 'nɨɨ²naa' 'in jo 'e tsaa² røø²¹i. ");
INSERT INTO chqNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Tsʉ jna‑a, 'in Ruu'²¹i Tsá², tyʉ'²ʉ to² jon jmɨɨ²¹² 'ii'²¹ 'woo'²¹ tsá². ");
INSERT INTO chqNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Joon gacwo'ɨ́ɨ¹ɨ Jesús fu do joon ga'í² inʉʉ cwo'¹ sinagoga. ");
INSERT INTO chqNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Joon inʉʉ cwo'¹ do ni'yuui² jaain²¹ tsá² sɨtsʉʉ'¹³ cwoo²¹o. Joon tsʉ 'wii'¹³ 'iin²¹²in 'in tsá² do i'nɨɨ²i Jesús gaunngɨɨ¹ɨ: ―¿Tɨ tsaa² fee'¹ 'e un'láa²o jaain²¹ tsatsaa'¹³ jmɨɨ²¹² 'ii'²¹ 'woo'²¹ tsá²? ");
INSERT INTO chqNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Joon Jesús‑gɨ gañii¹i: ―Doñi'iin jee²¹² 'naa' wa gatøø'²¹i tsi too²¹ jaain²¹ joo'saa'²¹ tyii' ityíi²moo' xʉfiin'¹³ jmɨɨ²¹² mo 'ii'²¹ 'woo'²¹ tsá². ");
INSERT INTO chqNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Pe 'áai¹gɨ tyiin² jaain²¹ tsañʉʉ'¹ lagɨ jaain²¹ joo'saa'²¹. La joon, lí²‑i jmá¹ tsá² 'e tyʉ́² mo jmɨɨ²¹² 'ii'²¹ 'woo'²¹ tsá². ");
INSERT INTO chqNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Joon gajin'² Jesús sɨɨ'²¹ɨ 'in tsá² sɨtsʉʉ'¹³ cwoo²¹o: ―Nii'¹³ cwoo¹'o. Joon mo ganii'¹³ 'in tsá² do cwoo²¹o, joon ga'lóo²o, galɨ́²‑ɨ la lɨ́¹ 'e cwoo²¹o coon²¹. ");
INSERT INTO chqNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Joon ga'wóo²mo tsá² fariseos do fu inʉʉ cwo'¹ do joon ga'láa² 'wii²¹² ga'noo'¹³o xiiala ijngaa'¹³i Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Joon mo galiñii¹ Jesús 'e 'iin²¹²in tsá² jnga'¹mo 'ii joon gacwo'ɨ́ɨ¹o do joon fúu¹mo tsá² gangalíin²mo coon'¹³on. Joon gaun'láa²mo Jesús jileei'²¹ tsatsaa'¹³. ");
INSERT INTO chqNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Joon gatyʉ'² Jesús to² 'e jo jma'¹ 'ido júu³ tsá² 'iin 'ii. ");
INSERT INTO chqNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Coon'¹³ la joon gatséi¹ júu³ ga'ɨ́ɨ²ɨ 'in tsá² gacwo¹ júu³ tya' Dios la mo jéei¹ sii²¹ Isaías mo gajin'²in: ");
INSERT INTO chqNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","'Ino 'in tsá² jmoo¹o la to² tyʉ'³ʉʉ, 'in gatyi'³na. 'Áa¹mo 'iin²¹²na 'ii joon 'áa¹mo jløø'³na 'wii²¹² tya'a. Icwóo¹³moo Espíritu Tyʉ́² tyiia tya'a, joon 'ii 'in jma'²a tsá² taain²¹² juncwii²¹ júu³ xiiala jmóo³oo 'ii'²¹. ");
INSERT INTO chqNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","'E jo jmá²a 'ido mɨɨ'¹³, jon'gɨ 'óo¹o jon'gɨ inuu¹un tsá² faa'²¹a jee²¹² 'nʉ́¹. ");
INSERT INTO chqNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Joon jileei'²¹ tsá² seein²¹ fa'í³ iuncoon'¹³o joon jileei'²¹ 'in jo 'e wa'² pí² 'oo¹o icwo'¹o 'ido wa'² pí² tya' ca mi tyʉ'² 'ii to² coon'¹³ 'ii'²¹ røø²¹. ");
INSERT INTO chqNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Joon ilitsáai¹‑tsi tsá² taain²¹² juncwii²¹ 'ii. ");
INSERT INTO chqNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Joon 'in tsá² do ngajée¹i tyani Jesús jaain²¹ tsá² tiui² 'in jo faa'²¹a joon 'yuui² 'in 'lɨɨi'³ alma tya'a. Joon gaun'láa²mo Jesús 'in tsá² do galɨ́²‑ɨ jǿø²ø joon ga'láa² 'wii²¹² faa'²¹o. ");
INSERT INTO chqNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Joon 'áai¹ ganga'goo²¹‑tsi tsá² joon gajin'²in ino wa'a jon'on jóon¹ 'lɨɨ²¹² David 'in tsá² no. ");
INSERT INTO chqNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Pe mo ganúu²un 'in tsá² fariseos 'e jin'² tsá² la do gajin'²in: ―'In tsañʉʉ'¹ no 'woo¹i 'in 'lɨɨi'³ taai² alma tya' tsá² coon'¹³ 'ii'²¹ tya' Beelzebú 'in tyʉ'² to² 'in 'lɨɨi'³. ");
INSERT INTO chqNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Joon ñii¹ Jesús 'ee 'ɨ¹‑tsi 'in tsá² do joon gajin'²in sɨɨ'²¹i 'ido: ―Wana 'in gobierno lɨ́¹ 'láai² poo²¹² 'ii joon tíin¹in la 'oo'²¹ 'ii joon 'in gobierno do jo taa'²¹a. La joon jon wana coon²¹ fuu²¹ sɨ la 'oo'²¹ ruu'²¹i 'ee jmoo¹o mɨɨ'¹³ jo wóo² taa'²¹a. ");
INSERT INTO chqNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Joon wana Satanás 'woo¹i Satanás 'ña'a tún² 'ii'¹³ lɨ́ɨ¹i. ¿Xiiala li taa'²¹a 'ido wa lɨ́ɨ¹i la joon? ");
INSERT INTO chqNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","'Naa' fó²oo' 'e 'wóo²na 'in 'lɨɨi'³ taai² alma tya' tsá² coon'¹³ 'ii'²¹ tya' Beelzebú joon wana la joon, ¿'iin cwo¹o 'ii'²¹ tya' tsá² tyii' 'e 'woo¹i 'in 'lɨɨi'³ taai² alma tya' tsá²? Coon'¹³ 'e jmoo¹o tsá² tyii' liñí²ii' 'e lɨ' cɨɨ'²ɨ 'ɨ¹‑'oo'. ");
INSERT INTO chqNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Pe 'wóo²na 'in 'lɨɨi'³ taai² alma tya' tsá² coon'¹³ 'ii'²¹ tya' Espíritu Tyʉ́² tya' Dios joon wana jmóo³oo la joon gatɨ́² 'ii'²¹ 'e tyʉ'² Dios to² jee²¹² 'naa'. ");
INSERT INTO chqNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Jo lí² tsataai² tsá² inʉʉ tya' tsá² pí²‑tsi 'e 'wo'¹ tsá² 'e sá² tya'a wa jo jéei¹ 'nʉ́ʉ¹i. La joon lí² 'wó²o 'e sá² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Jileei'²¹ 'in jo seein²¹ tyʉ́² coon'¹³ jna 'ee'¹mo jna joon jileei'²¹ 'in jo uncaain²¹ tsá² ilíin² tsá² tya' Dios coon'¹³ jna 'ǿø¹mo tsá² wíin². ");
INSERT INTO chqNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Tsʉ 'wii'¹³ joon fuu²¹²uu 'naa' doñi'ee tsaa² 'e 'noo¹o tsá² sɨ doñi'ee júu³ 'laa'²¹ 'e faa'²¹ tsá² lí²‑i 'iin² Dios tsaa² tya'a pe wana faa'²¹a tsá² 'laa'²¹ tya' Espíritu Tyʉ́² tya' Dios jo 'iin²gɨ tsaa² tya' 'ii. ");
INSERT INTO chqNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Joon doñi'ee júu³ 'laa'²¹ 'e faa'²¹ tsá² tya' Ruu'²¹i Tsá² lí²‑i 'iin² Dios tsaa² tya'a pe wana faa'²¹a tsá² 'laa'²¹ tya' Espíritu Tyʉ́² tya' Dios jo 'iin²gɨ tsaa² tya'a 'e juncwii²¹ lo la joon jon lɨ' cataain²¹². ");
INSERT INTO chqNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Wana tyʉ́² coon²¹ 'mó² 'oofuu²¹ cwo¹o 'oofuu²¹ 'e tyʉ́² joon wana gó² 'e 'mó² do gó²o jon 'e 'oofuu²¹ 'e i'ɨ́¹ɨ. Tsʉ coon²¹ 'mó² 'oofuu²¹ cwii¹i tsá² coon'¹³ 'oofuu²¹ 'e tsí². ");
INSERT INTO chqNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Xuui²¹² tya' 'in 'lɨɨi'³ 'naa! ¿Xiiala lí² fó²oo' 'naa' júu³ tyʉ́² joon yaamoo' 'lɨɨi'³ 'naa'? Tsʉ faa'²¹a tsá² jiin'¹³ la 'ɨ¹‑tsio. ");
INSERT INTO chqNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","'In tsá² tyúi¹ faa'²¹o 'e tyʉ́² 'e tyʉ́²ʉ 'ɨ¹‑tsi. La joon jon 'in tsá² gó² faa'²¹o 'e gó² tsʉ 'wii'¹³ 'e gó² 'ɨ¹‑tsi. ");
INSERT INTO chqNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Joon fuu²¹²uu 'naa', mi tɨ́² jmɨɨ²¹² ijmá¹a Dios 'ii'²¹ tya' tsá² icoon¹on tya'a tya' jilaa'²¹ júu³ 'e nigasɨ́ɨi² tsá² 'e jo 'ee to² tí². ");
INSERT INTO chqNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Tsʉ 'e 'ii'²¹ ijmá¹a Dios tya' tsá² ilí² jiin'¹³ la júu³ 'e nigafaa'²¹a tsá². Coon'¹³ júu³ tya'a icwo'ɨ́ɨ¹i 'in tyúi¹ sɨ 'in gó² 'ee. ");
INSERT INTO chqNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Joon 'in lɨ́ɨi¹³ tsá² fariseos coon'¹³ tɨfo'² tya' ley gajin'²in sɨɨ'²¹ɨ Jesús: ―Tɨfo'², 'ii²¹²i'i 'e 'e'¹'e jna'a coon²¹ li² milagro. ");
INSERT INTO chqNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Joon gañii¹i Jesús: ―'In tsá² gó² 'in jo tsáa¹‑tsi Dios mɨɨ¹ɨ li² milagro pe i'ii'²¹i jiin'¹³ 'e li² gacwo¹o 'in tsá² cwo¹ júu³ tya' Dios la mo jéei¹ sii²¹ Jonás. ");
INSERT INTO chqNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Tsʉ Jonás do ga'í² nʉ' tu'² joo'²¹ taai² jmɨɨ²¹ 'nɨ¹ jmɨɨ²¹² 'nɨ¹gɨ nʉ́ʉ¹ la joon jon 'in Ruu'²¹i Tsá² tsa'ii²¹ 'nɨ¹ jmɨɨ²¹² 'nɨ¹gɨ nʉ́ʉ¹ lɨ taai² tsá² 'in najúin¹. ");
INSERT INTO chqNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Joon mi jmá¹a Dios 'ii'²¹ tya' tsá² 'in tsá² 'in née¹i Nínive i'nɨ́ɨ¹i ni 'in tsá² seein²¹ nano tsʉ gajoo'²¹o‑tsi 'in tsá² née¹i Nínive mo gangó¹ Jonás ngacwoo¹o júu³ tyʉ́² tya' Dios. Joon gacwéi¹ jaain²¹ 'in feei'¹gɨ lagɨ Jonás no. ");
INSERT INTO chqNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Joon 'in tsamɨ́² 'in tyʉ'² to² cwoo'¹³ roon¹on lɨ cwoo²¹ tsáa² lɨ' 'yee²¹e ñi'¹ i'nɨ́ɨ¹i ni 'in tsá² seein²¹ nano tsʉ 'in tsamɨ́² do gajó² janʉ́ʉ²ʉn júu³ 'e jmɨɨ²¹²‑tsi tya' Salomón. Gajó² lɨ wíin²gɨ la jee²¹² jilaa'²¹ fuu²¹ 'e sá² la 'ui juncwii²¹. Joon gacwéi¹ jaain²¹ 'in feei'¹gɨ lagɨ Salomón ―jin'² Jesús. Faa'²¹gɨ Jesús jin'²in: ");
INSERT INTO chqNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","―Mo gacwo'ɨ́ɨ¹ɨ 'in 'lɨɨi'³ alma tya' jaain²¹ tsañʉʉ'¹ ngɨɨ¹ɨ la caain²¹ lɨ tyʉʉn²¹ 'noo'¹o lɨ 'ii'²¹ 'woo'²¹o. Joon mo jo tyii'²¹a lɨ 'ii'²¹ 'woo'²¹o i'ɨ¹‑tsi: ");
INSERT INTO chqNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Nii'¹³moo lɨ gajú³uu.” Joon mi cɨɨ'¹³ɨ tún¹ ityee'²¹i 'in tsá² do lawa coon²¹ 'nʉ́¹ 'e jø² 'e tyʉ́² sɨ 'ya'² joon lɨ tyʉ́². ");
INSERT INTO chqNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Joon 'in 'lɨɨi'³ do 'e tsatee¹e dyái¹ 'in 'lɨɨi'³gɨ lagɨ 'ii 'e tsataa²i tsi alma tya'a. Joon lɨ gatséi¹ 'e gó²gɨ tya'a lagɨ lɨ ga'láa² 'wii²¹². La joon ilí² tya' 'in tsá² gó² 'in seein²¹ nano. ");
INSERT INTO chqNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","La 'ɨɨ²¹² faa'²¹gɨ Jesús coon'¹³ 'in tsá² do gatyalíin² ruu'²¹i coon'¹³ sáa³a. Caluu gajaan¹an 'iin²¹²in fee'²¹i Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Joon jaain²¹ tsá² gajma'²a Jesús júu³ jin'²in: ―Saa²'a coon'¹³ ruu'²¹'u téen²in caluu no 'iin²¹²in fee'²¹i 'nʉ. ");
INSERT INTO chqNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Pe Jesús gasɨɨ'²¹ɨ 'in tsá² gajma'²a júu³ 'ii jin'²in: ―¿'Iin sáa³aa joongɨ 'iin ruu'²¹na? ");
INSERT INTO chqNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Joon ga'ɨ́ɨ²ɨ cwoo²¹o la caain²¹ lɨ née¹i tsá² tya'a joon gajin'²in: ―'Inlo‑o sáa³aa joongɨ ruu'²¹na. ");
INSERT INTO chqNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Tsʉ doñi'iin 'in jmoo¹o la to² tyʉ'² Ñʉ'³ʉʉ tyíin¹³ ñʉ'fú² 'ii ruu'²¹na tsañʉʉ'¹, joongɨ 'ii ruu'²¹na tsamɨ́², joongɨ 'ii sáa³aa ―jin'² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","'E jmɨɨ²¹² joon gacwo'ɨ́ɨ¹ɨ Jesús inʉʉ tya'a joon gangacwaa¹a tɨ' tyíia¹. ");
INSERT INTO chqNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Joon galicaain²¹ tsá² fúui¹ lɨ tyíin¹ Jesús do. Joon ga'í² Jesús tsi barco 'íi¹ tɨ' jmɨɨ²¹ do joon do‑o gacwoo²¹o. Joon 'in tsá² do gajaan¹an ni tsaa² do. ");
INSERT INTO chqNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Joon ga'e'²e Jesús 'in tsá² do coon'¹³ 'láai² júu³ cwáain¹ gajin'²in: ―Lawa jaain²¹ tsá² gajñii¹ mɨ'³ trigo. ");
INSERT INTO chqNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","La 'ɨɨ²¹² ngóo¹ dya'²a 'e mɨ'³ do 'elɨ́ɨi¹³ mɨ'³ trigo do gaxʉʉ'²¹ʉ tya'i fu¹ joon gatyalíin² ton¹ gagɨɨ'²¹ɨ mɨ'³ trigo do. ");
INSERT INTO chqNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","'Elɨ́ɨi¹³gɨ mɨ'³ do gaxʉʉ'²¹ʉ ni cuun²¹² lɨ jo 'náa¹ cwoo'¹³ 'láai². Tyʉ́²‑ʉ ganii'¹³ mɨ'³ trigo do jo 'o'² 'náa¹ cwoo'¹³ do. ");
INSERT INTO chqNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Pe mo ga'yee²¹ ñi'¹ gacó³o coon'¹³ 'yiia²¹. Joon tsʉ 'wii'¹³ jo jmóo³ tya'a sá² galityʉʉn²¹. ");
INSERT INTO chqNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Joon 'elɨ́ɨi¹³gɨ mɨ'³ gaxʉʉ'²¹ʉ jee²¹² 'motóon¹. Joon 'e tóon¹ do gacwaan²¹mo joon gajlɨɨ²¹ 'e trigo do. ");
INSERT INTO chqNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Pe 'elɨ́ɨi¹³gɨ mɨ'³ do gaxʉʉ'²¹ʉ jee²¹² cwoo'¹³ 'oo'³ joon tyʉ́²‑ʉ gacwaain²¹. 'Elɨ́ɨi¹³ mɨ'³ jún² do gacwo¹ coon²¹ ciein¹³ mɨ'³, 'elɨ́ɨi¹³gɨ gacwo¹ sesenta mɨ'³, 'elɨ́ɨi¹³gɨ gacwo¹ dyadya¹ mɨ'³. ");
INSERT INTO chqNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Jileei'²¹ 'naa' 'in nuu¹un, nʉʉ²ʉʉn'. ");
INSERT INTO chqNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Joon gangatyéen¹in tsá² tya' Jesús co' lɨ siin'¹³in joon gaunngɨɨ¹ɨ: ―¿'Ee lɨ' 'e'²'e tsá² coon'¹³ jmai'² júu³ cwáan¹mo? ");
INSERT INTO chqNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Joon gañii¹i: ―Dios gacwo'¹o 'naa' 'e 'øø'²¹mo‑'oo' 'e júu³ 'uuin²¹ tya' xiiala ityʉ'² Dios to² tsá², pe 'in catyaai² do jo cwei² wa' 'øøi'²¹‑tsi. ");
INSERT INTO chqNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Joon 'in 'øøi'²¹‑tsi, icwo'¹o Dios 'ii i'øøi'²¹‑tsi tyʉ́²gɨ 'áai¹. Pe 'in jo ga'øøi'²¹‑tsi i'wo'²o 'e xʉ 'e 'øøi'²¹‑tsi do. ");
INSERT INTO chqNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","'Wii'¹³ joon tyíi³aa júu³ tya' 'in tsá² lo coon'¹³ jmai'² júu³ cwáan¹mo. 'In tsá² lo ñi²o jilaa'²¹ 'e jmó³oo pe tsalíin²mo lawa jo 'ee gañí²o. Joon nuu¹o júu³ tyiia pe jo 'øøi'²¹‑tsi lawa jo 'ee ganuu¹o. ");
INSERT INTO chqNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","La joon gatsín¹ júu³ ga'ɨ́ɨ²ɨ 'lɨɨ²¹² Isaías, 'in gacwo¹o júu³ tya' Dios la mo jéei¹ mo gajin'²in: 'E la ja'²mo, inúu² 'naa' joon jo i'øøi'²¹‑'oo'. 'E la ja'²mo, ijǿø² 'naa' pe jo iunjii²ii'. ");
INSERT INTO chqNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Tsʉ nigalɨ'wa'²a‑tsi 'in tsá² no jo 'iin²¹²gɨ nuu¹un joon gajnɨ¹ unníi¹i yʉ² to² 'e jo lí²gɨ jnaa'²¹a, jon'gɨ li núu¹gɨ coon'¹³ loocwóo¹o. Coon'¹³ la joon jo lí²gɨ i'øøi'²¹‑tsi 'e cɨɨ'¹³ɨ coon'¹³ jna 'e un'láa²na 'ii, jin'² Isaías do. ");
INSERT INTO chqNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Pe jløø'³mo 'naa' tsʉ jøø²øø' coon'¹³ unní²iin' joon nuu²uun' coon'¹³ loocwoo¹oo'. ");
INSERT INTO chqNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","'E la ja'²mo fuu²¹²uu 'naa' fúu¹mo 'in gacwo¹o júu³ tya' Dios la mo jéei¹ coon'¹³ tsá² 'in tyúi¹ nigali'iin²¹²in jǿø²ø jilaa'²¹ 'e jøø² 'naa' pe jo ganí²i. Nigali'iin²¹²in 'in tsá² do núu¹un jilaa'²¹ 'e nuu² 'naa' pe jo ganúu²un. ");
INSERT INTO chqNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Faa'²¹gɨ Jesús jin'²in: ―Tyaan²aan' cwáain¹ 'ee 'øøi'²¹‑tsi tsá² 'e cwáain¹ tya' 'in tsá² gajñii¹ mɨ'³ trigo. ");
INSERT INTO chqNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","'In tsá² 'in nuu¹un júu³ tya' xiiala tyʉ'² Dios to² tsá² pe jo 'øøi'²¹‑tsi lɨ́ɨ¹i la lɨ mɨ'³ trigo 'e xʉʉ'²¹ʉ tya'i fu¹. Gajó² 'in 'lɨɨi'³ gatyii²¹ júu³ ganúu²un 'in tsá² do. ");
INSERT INTO chqNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","'E mɨ'³ trigo gaxʉʉ'²¹ jee²¹² cuun²¹² lɨ la lɨ́ɨ¹i 'in tsá² ganúu²un júu³ tya' Dios joon ga'ii'²¹i jløø'³mo, ");
INSERT INTO chqNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","pe jo jmóo³ jée¹i. Joon mo nii²¹² wúu¹ sɨ 'ǿø¹i tsá² 'ii 'ee 'wii'¹³ cwáain¹ tya' júu³ do tsifu joon tʉʉ²¹ 'e júu³ do. ");
INSERT INTO chqNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","'E mɨ'³ trigo gaxʉʉ'²¹ jee²¹² 'motóon¹ lɨ la lɨ́ɨi¹ 'in tsá² 'in ganúu²un júu³ do pe cu'²‑tsi coon'¹³ jilaa'²¹ 'e sá² juncwii²¹. Cuu² gacoon²¹ 'ido tóo² joon jo untsín¹ to² tya' júu³ tya' Dios coon'¹³ juncwii²¹ tya' 'in tsá² do. ");
INSERT INTO chqNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Pe 'e mɨ'³ trigo do 'e gaxʉʉ'²¹ jee²¹² cwoo'¹³ 'oo'³ lɨ la lɨ́ɨi¹ tsá² 'in ganúu²un júu³ tya' Dios do joon gajmaa¹a nʉʉ'¹³ʉn. Gajmee¹mo to² 'e júu³ do tya'a. 'Inlɨ́ɨi¹ la lɨ 'e mɨ'³ trigo 'e gacwo¹ coon²¹ ciein¹³ mɨ'³, 'inlɨ́ɨi¹³gɨ lɨ́ɨi¹ la lɨ 'e mɨ'³ trigo 'e gacwo¹ sesenta mɨ'³, 'inlɨ́ɨi¹³gɨ lɨ́ɨi¹ la lɨ 'e mɨ'³ trigo 'e gacwo¹ dyadya¹ mɨ'³. ");
INSERT INTO chqNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Joon gatyaa¹a Jesús 'e júu³ cwáain¹ lo tya' 'in tsá² do jin'²in: ―'E tyʉ'² Dios to² tsá² lɨ la lɨ mo gajñii¹ jaain²¹ tsañʉʉ'¹ jún² trigo tyʉ́² 'wó² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Pe la 'ɨɨ²¹² cwuu²¹mo 'in tsá² do joon ga'í² jaain²¹ tsá² 'in 'eei'¹ 'ii joon gajñii¹ jún² tóon¹ ñii²¹ jee²¹² trigo do joon nga'²mo mi yuui'¹³ joon. ");
INSERT INTO chqNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Joon mo ganii'¹³ mɨ'³ trigo do joon galisá² mɨ'³ tya'a ga'yee'²¹mo joon 'e tóon¹ ñii²¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Joon 'in tsa'leei'¹³ do gangóo¹o gangasii'¹³i ñi'fii²¹²i: “Patróoin¹³, tyʉ́²‑ʉ jún² gajñii²¹i' lɨ 'wó² do, ¿xiialɨ'ɨ ga'yee'²¹ tóon¹ ñii²¹ do?” ");
INSERT INTO chqNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Joon 'in ñi'fii²¹² do gajin'²in sɨɨ'²¹ɨ 'ii: “Jaain²¹ tsá² 'in 'eei'²¹ jna gajmaa¹a 'yee'²¹ tóon¹ ñii²¹ no”, jin'²in. Joon 'in tsa'leei'¹³ do gaunngɨɨ¹ɨ: “¿Tɨ 'iin²¹²u'un wa'a tsaa²¹a'a tsasé²e'e 'e tóon¹ ñii²¹ do?” jin'²in. ");
INSERT INTO chqNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Pe ñi'fii²¹²i do gajin'²in: “'Ún², jo søø²øø' tsʉ wana gacwotøø'¹³ 'e tóon¹ ñii²¹ do 'ná¹ cwotøø'¹³ jon 'e trigo do. ");
INSERT INTO chqNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Tyʉ́²gɨ cwocwáain²¹ caan²¹mo ce roo²¹o. Joon ityʉ'³ʉʉ to² tsa'leei'¹³ tsalíin² tsasee'¹e jéei¹ 'e tóon¹ ñii²¹ do joon jmáa¹a la catsi¹ joon coo¹o. Joon mi yuui'¹³ joon isø'²ø 'e trigo do to'¹o inʉʉ tyiia”, jin'² fii²¹²i ―jin'² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Tyaa¹a Jesús jon 'e júu³ cwáain¹ lo jin'²in: ―'E tyʉ'² Dios to² tsá² lɨ la lɨ coon²¹ jún² mostaza 'e gajñii¹ tsá² 'wó² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Pi'³gɨ jún² tya' la jee²¹² jilaa'²¹ jún² tya' nuu²¹ pe mi nii'¹³ joon cwaain²¹ fee'¹gɨ 'mó² tya' lagɨ nuu²¹ catyiia² ca tɨ la ti coon²¹ 'mó². Fee'¹ 'áai¹ ca jalíin² ton¹ jmáa¹a sɨɨ²ɨ jee²¹² cwáa¹ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Tyaa¹a Jesús jon 'e júu³ cwáain¹ lo jin'²in: ―'E tyʉ'² Dios to² tsá² lɨ la lɨ tyiian'³ 'e gacaai'²¹ jaain²¹ tsamɨ́² 'nɨ¹ 'ii'¹³ fu² 'iñi'¹ joon garoon²on jilaa'²¹. ");
INSERT INTO chqNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jmai'² coon'¹³ júu³ cwáan¹mo gasɨɨ'²¹ɨ Jesús 'in tsá² do. ");
INSERT INTO chqNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Coon'¹³ la joon gauntsiin¹ júu³ tya' jaain²¹ tsá² 'in gacwo¹o júu³ tyʉ́² tya' Dios la mo jéei¹ mo gajin'²in: Jmai'² coon'¹³ júu³ cwáain¹ ifo'³oo; ifo'³oo júu³ 'uuin²¹ 'e sɨ'mo² ca mo gajmaa¹a Dios juncwii²¹. ");
INSERT INTO chqNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Joon Jesús ga'ɨ́ɨ²ɨ júu³ tya' 'in tsá² do joon ga'í² inʉʉ. Joon tsá² tya'a gangatyéen¹in lɨ tyíin¹ Jesús joon gajin'²in sɨɨ'²¹ɨ Jesús: ―Jmaa'¹³ jna'a júu³, 'ee 'øøi'²¹‑tsi tsá² 'e júu³ cwáain¹ 'e gatya²'a mo jñii¹ tsá² jún² tóon¹ ñii²¹ jee²¹² trigo. ");
INSERT INTO chqNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Joon gajin'²in Jesús: ―'In tsá² do 'in gajñii¹ 'e jún² trigo tyʉ́² lɨ́ɨi¹ Ruu'²¹i Tsá², ");
INSERT INTO chqNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","joon 'wó² tya'a do lɨ ni cwoo'¹³ juncwii²¹. Joon 'e jún² trigo tyʉ́² lɨ la lɨ́ɨi¹ 'in tsá² jmoo¹o la to² tyʉ'² Dios. Joon 'e jún² tya' tóon¹ ñii²¹ lɨ la lɨ́ɨi¹ 'in tsá² jmoo¹o la to² tyʉ'² 'in 'lɨɨi'³. ");
INSERT INTO chqNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Joon 'in gajñii¹ 'e jún² tya' tóon¹ ñii²¹ do 'in 'lɨɨ'³mo 'i. Joon mo gasø'²ø 'e trigo do lɨ la lɨ mi tyéi¹ juncwii²¹. Joon 'in tsa'leei'¹³ do 'in gasø'² 'e trigo do lɨ́ɨi¹ la lɨ́ɨi¹ ángeles tya' Dios. ");
INSERT INTO chqNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Joon la gasø'²ø 'in tsa'leei'¹³ do 'e tóon¹ ñii²¹ gadya'²a ni jɨ́² la joon ilí² lɨ tyéi¹ juncwii²¹. ");
INSERT INTO chqNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","'In Ruu'²¹i Tsá² ityʉ'²ʉ to² ángeles tya'a iuncaain²¹ jileei'²¹ 'in jmoo¹o 'leei'²¹ tsá² coon'¹³ jileei'²¹ 'in ga'noo¹o tsaa² 'e 'wóo²mo 'ido fu lɨ tyʉ'²ʉ 'ii to². ");
INSERT INTO chqNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Joon ipíi²in 'in tsá² do lɨ 'ii²¹. Joon ityi'²i 'áai¹ joon cuu'¹i moojóon¹on. ");
INSERT INTO chqNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Joon jileei'²¹ 'in jmoo¹o la to² tyʉ'² Dios ilijɨɨi'¹ la jɨɨi'¹ ñi'¹ fu lɨ tyʉ'² Jmii²¹ to². Jileei'²¹ 'naa' 'in nuu¹un, nʉʉ²ʉʉ'. ");
INSERT INTO chqNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’'E tyʉ'² Dios to² tsá² lɨ la lɨ cuu² sɨ'mo² nʉ' 'wó². Joon mo gatsaa'²¹a jaain²¹ tsá² 'e cuu² sɨ'mo² do ga'maa¹a tún¹. Galijløø'³i 'áai¹ joon gangaa'¹³i nga'nɨ́ɨ²ɨ jilaa'²¹ 'e sá² tya'a joon galó¹o 'e 'wó² do lɨ taa'¹³ cuu² do. ");
INSERT INTO chqNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’La joon jon 'e tyʉ'² Dios to² tsá² lɨ la lɨ́ɨi¹ jaain²¹ tsá² 'in ló¹o 'e 'nɨ́ɨ²ɨ. 'In tsá² do ngɨɨ¹ to² 'noo'¹o perlas tyʉ́². ");
INSERT INTO chqNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Joon mo gatsaa'²¹a coon²¹ 'e tyíin¹ 'áai¹ joon tsa'nɨ́ɨ²ɨ jilaa'²¹ 'e sá² tya'a joon galó¹o 'e perla do. ");
INSERT INTO chqNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’La joon jon 'e tyʉ'² Dios to² tsá² lɨ la lɨ coon²¹ nʉ́ʉ³ 'e 'ɨɨ¹ɨ tsá² tsi jmii²¹ joon tsataa²i jilaa'²¹ nii² joo'²¹ taai² jmɨɨ²¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Joon mo garǿ¹i 'e nʉ́ʉ³ do 'in tsá² do unron'²on fu ni tsaa² joon cwa¹a in tyii'¹³in 'in joo'²¹ taai² jmɨɨ²¹ do. Joon 'in joo'²¹ tyúi¹ do taa'¹i tsi motó² joon 'in joo'²¹ jo tyúi¹ do dyee'¹³mo. ");
INSERT INTO chqNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","La joon ilí² lɨ tyéi¹ juncwii²¹. Joon ijalíin² 'in ángeles 'in jmáa¹a coon'²¹ 'in tyúi² coon'¹³ 'in gó². ");
INSERT INTO chqNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Joon 'in gó² idyee'¹³i lɨ 'ii²¹ joon do‑o ityi'²i joon cuu'¹i moojóon¹on. ");
INSERT INTO chqNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Joon jin'²in Jesús sɨɨ'²¹ɨ tsá² tya'a: ―¿Tɨ 'øø'²¹mo‑'oo' jilaa'²¹ 'elo? Joon gañii¹i tsá² tya'a jin'²in: ―Joon, 'øø'²¹mo‑tsii'i. ");
INSERT INTO chqNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Joon gajin'² Jesús: ―Jaain²¹ tɨfo'² tya' ley 'in gauntsáa¹ xiiala ityʉ'² Dios to² tsá² lɨ́ɨi¹ la lɨ́ɨi¹ tsá² fii²¹² 'nʉ́¹ 'in lí² tyi'² 'e 'mɨ́ɨ² coon'¹³ 'e tsáai² jee²¹² 'e sá² tya'a. Lí²‑i 'e'²e 'in tɨfo'² do tsá² 'e júu³ 'múui² joongɨ júu³ 'e tsáai². ");
INSERT INTO chqNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Joon mo ngayuui'¹³ ga'ɨ́ɨ²ɨ Jesús 'e júu³ cwáain¹ lo ");
INSERT INTO chqNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","joon gangaa'¹mo fu cwoo'¹³ goo¹o. Joon do‑o ga'láa² 'wii²¹² 'e'²e tsá² inʉʉ cwo'¹ sinagoga tya'a. Joon 'in tsá² goo¹o do ganga'goo²¹o‑tsi, jin'²in: ―¿Xiiafu lɨ' galitɨɨ²¹i 'in tsañʉʉ'¹ no 'e júu³ faa'²¹a? ¿Xiiala 'e galɨ́² jmoo¹o ino milagros la no? ");
INSERT INTO chqNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Tsʉ jóon¹on tɨ'mó² ino joon sáa³a sii²¹ María. Joon ruu'²¹mo Jacobo, coon'¹³ José, coon'¹³ Simón coon'¹³ Judas. ");
INSERT INTO chqNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Joongɨ 'in ruu'²¹i tsamɨ́² seein²¹ jee²¹² jna' jon. ¿Xiialɨ' galiñii¹i jilaa'²¹ 'eno? ");
INSERT INTO chqNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Tsʉ 'wii'¹³ joon ga'aa¹a tsii²¹² wúu¹ tya' Jesús jo ganúu²un júu³ tya'. Pe Jesús gajin'²in sɨɨ'²¹ɨ 'in tsá² do: ―Un'goo²¹o tsá² jaain²¹ 'in cwo¹ júu³ tyʉ́² tya' Dios pe jiin'¹³ tsá² goo¹o coon'¹³ tsá² inʉʉ tya'a jo un'goo²¹o 'ii. ");
INSERT INTO chqNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Joon jo 'ee milagros gajmaa¹a Jesús jee²¹² 'in tsá² goo¹o do tsʉ jo jai'² galɨ́ɨi² 'ido 'ii. ");
INSERT INTO chqNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","'Yiia'¹³ joon 'in tyʉ'² to² lɨ sii²¹ Galilea, 'in sii²¹ Herodes, nigaliñii¹i xiiala jmoo¹o Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Joon gasɨɨ'²¹ɨ 'in née¹i coon'¹³on cwáain¹ tya' Jesús: ―Wó³ saai¹ tsá² jmɨɨ²¹ ino 'in nigajiin'¹in jee²¹² 'lɨɨ²¹². 'Wii'¹³ joon lí² jmáa¹a milagros do. ");
INSERT INTO chqNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ga'ɨ¹‑tsi Herodes la joon tsʉ nigataan'¹³in 'nʉñí³ Wó³ do. Herodes iliseein²¹ tyʉ́² coon'¹³ Herodías gatyʉ'²ʉ to² i'ñʉ́¹ʉ cadenas cwoo²¹o Wó³ lɨ' 'yuu²i 'nʉñí³. Herodes do nigacán¹mo Herodías 'in lɨ́ɨi¹ tsamɨ́² tya' ruu'²¹i 'in sii²¹ Lii²¹². ");
INSERT INTO chqNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Joon Wó³ do gasɨɨ'²¹ɨ Herodes 'e jo tɨ́ɨ²i jmáa¹a la no. ");
INSERT INTO chqNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","'Iin²¹²in Herodes jngaa'¹³i Wó³ pe 'gøø'²¹mo tsá². Tsʉ jilee'²¹mo tsá² 'e ñii¹i 'e faa'²¹ Wó³ cwáain¹ tya' Dios. ");
INSERT INTO chqNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Joon mo gatséi¹ jiin²¹ tya' Herodes gajmaa¹a jmɨɨ²¹². Joon ga'í² jamɨ́² Herodías gatséen¹in lɨ taai² tsá² lɨ náa¹ jmɨɨ²¹² do. Joon 'áa¹mo gatɨ́²‑tsi Herodes lagɨ tséen¹in 'in sɨmɨ́² do. ");
INSERT INTO chqNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Joon gajin'²in ga'ée¹i Dios gasɨɨ'²¹ɨ 'in sɨmɨ́² do: ―Cwóo³oo doñi'ee mɨ́²'ɨ. ");
INSERT INTO chqNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Joon 'in sɨmɨ́² do mo ngayuui'¹³ gafee'²¹i sáa³a jin'²in sɨɨ'²¹ɨ Herodes: ―Cwoo'¹³ jna lo mootyi² Wó³ saai¹ tsá² jmɨɨ²¹ 'e 'yʉ² coon²¹ tsi wúun¹. ");
INSERT INTO chqNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Galixuu²¹²mo‑tsi Herodes pe jo lí² un'naa¹i júu³ tya'a 'e niga'ée¹i Dios lɨ nuu¹un 'in tsá² taai² do. Gatyʉ'²ʉ to² 'e lí² la joon. ");
INSERT INTO chqNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Gasii¹in tsá² gangatʉ́² luu²¹²u Wó³ lɨ' 'yuui² 'nʉñí³ do. ");
INSERT INTO chqNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Joon gacóon¹on ton'²on coon²¹ tsi wúun¹ gacwo'¹o 'in sɨmɨ́² do. Joon 'ii‑gɨ gacwo'¹o sáa³a. ");
INSERT INTO chqNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Joon tyalíin² 'inlɨ́ɨi¹³ tsá² tya' Wó³ do gacoon¹ cuerpo tya'a 'a tsa'áa¹i. Joon ngalíin²mo ngajmaa'¹³a Jesús júu³ xiiala galɨ́¹. ");
INSERT INTO chqNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Joon mo galiñi¹ Jesús xiiala gangɨ́i¹ Wó³ do ga'í² tsi coon²¹ barco joon gangóo¹ coon'²¹ coon'¹³ tsá² tya'a fu coon²¹ lɨ jo 'in tsá² seein²¹. Pe galiñi¹ tsá² née¹i la caain²¹ fuu²¹ náa¹ do joon ngalíin²mo ngɨɨ¹ɨ tɨɨ²ɨ. ");
INSERT INTO chqNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Joon mo gacwo'ɨ́ɨ¹ Jesús 'e barco do gangaa¹i tsá² fúui¹. Joon galifee'¹mo‑tsi 'wii²¹² tya' 'ido. Joon gaun'láa²mo tsatsaa'¹³ jée¹i 'in tsá² do. ");
INSERT INTO chqNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Joon nangó¹ xʉʉ jnaa¹ tyalíin² tsá² tya' Jesús sɨɨ'²¹ɨ 'ii: ―Nixʉʉ jnaa¹ lo. 'Íi² júu³ 'in tsá² no tsʉ jo 'in seein²¹ 'e 'nɨɨ¹ 'e dø'¹ 'ino. Síi¹³'i wa tsalíin² fuu²¹ pi'³ taa'¹³ co' no 'e ló¹xʉ 'e dø'¹ø. ");
INSERT INTO chqNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Joon Jesús gajin'²in: ―Jo 'ná² tsalíin² 'ino. 'Naa', cwó²xʉʉ' 'e dø'¹ 'ino. ");
INSERT INTO chqNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Joon gajin'² tsá² tya'a: ―Jo 'ee 'oo²gɨɨ'ɨ jiin'¹³ 'ñá² 'iñi'¹ coon'¹³ gái¹ joo'²¹ taai² jmɨɨ²¹. ");
INSERT INTO chqNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesús gañii¹i: ―Cwooi²duu' fu lo. ");
INSERT INTO chqNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Joon gatyʉ'² Jesús to² wa'a cwá² 'in tsá² fúui¹ do jee²¹² ñii²¹ do. Joon gason'²on 'e 'ñá² 'iñi'¹ do coon'¹³ 'in gái¹ joo'²¹ taai² jmɨɨ²¹. Joon gajǿø²ø fu ñʉ'fú², gacwoo¹ 'maai'¹² Dios. Gajmaa¹a 'no'³ 'e 'iñi'¹ do joon gacwo'¹o tsá² tya'a. Joon 'in tsá² tya'a do gajmaa¹a jmai'²xʉ jee²¹² 'in tsá² fúui¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Jilee'²¹mo gagøø'²¹ø joon jløø'³mo. Joon gauncaain²¹ jilaa'²¹ 'e gasái¹gɨ, joon garǿi¹ dyatun¹ 'motó². ");
INSERT INTO chqNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Joon 'in tsá² 'in gagøø'²¹ø do tí² 'ñá² mil jmai'² tsañʉʉ'¹ jo sɨ'ii²in tsamɨ́² coon'¹³ xuui²¹². ");
INSERT INTO chqNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Mo ngayuui'¹³ joon gatyʉ'² Jesús to² tsá² tya'a wa' tsalíin² lɨ' ngoo'¹³ tyíia¹ cataain²¹ do jéei¹gɨ lagɨ 'ii la 'ɨɨ²¹² 'ɨɨ¹gɨ júu³ 'in tsá² do. ");
INSERT INTO chqNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Joon mo ngayuui'¹³ ga'ɨɨ¹ Jesús júu³ 'in tsá² do gasoo²¹o 'ña'a coon²¹ moo'²¹ ngafee'¹³i Dios. Joon mo ga'í² nʉ́ʉ³ do‑o táain² Jesús 'ña'o. ");
INSERT INTO chqNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Joon 'e barco do tya' tsá² tya'a ngó¹ tún² tsa' ni tyíia¹ do. 'Áai¹ jnóo¹ jmɨɨ²¹ tsaa'¹ barco do tsʉ 'áai¹ 'ɨɨ¹ tyí² lɨ' cɨɨ'¹³. ");
INSERT INTO chqNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Joon niiu²¹mogɨ mo ngatyéen¹in Jesús lɨ 'íi¹ barco do ngɨɨ¹ tɨɨ²o ni jmɨɨ²¹ ngóo¹o. ");
INSERT INTO chqNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Joon mo gango¹ tsá² tya'a ngóo¹on ngɨɨ¹ tɨɨ²ɨ ni jmɨɨ²¹ do gafoo'¹mo 'áai¹ joon ga'oo¹o gajin'²in: ―Jaain²¹ tsá² 'mootyí² 'in jó¹ no. ");
INSERT INTO chqNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Pe Jesús gajin'²in sɨɨ'²¹ɨ 'in tsá² do: ―Tá² téen¹‑'oo', jna‑a lo; jo foo'¹³naa'. ");
INSERT INTO chqNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Joon Tʉ́³ gasɨɨ'²¹ɨ 'ii jin'²in: ―Wana 'nʉ no, Ña'ñʉ'¹ʉ', tyʉʉ'¹³ to² góo³oo tɨ lɨ síin¹³u'un no. ");
INSERT INTO chqNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Joon Jesús gajin'²in: ―Na¹ joon. Joon tsifu‑u gajngái² Tʉ́³ lɨ' caai²¹ barco do joon ga'láa² 'wii²¹² ngɨɨ¹ ni jmɨɨ²¹ fu lɨ siin'¹² Jesús do. ");
INSERT INTO chqNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pe gafoo'¹³mo mo gacón² cwáain¹ xiiala 'ɨɨ¹ tyí² joon tɨ'xʉ‑ʉ ganga'aa'¹³i jmɨɨ²¹ do. Joon ga'oo¹o gajin'²in: ―¡Jmáa² tiin'¹³na, Ña'ñʉ'¹ʉ'! ");
INSERT INTO chqNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Tsifu joon gason'²on Jesús cwoo²¹o gajin'²in sɨɨ'²¹ɨ 'ido: ―'Áai¹ xʉʉ jo'¹ lɨ́ɨ²'u. ¿'Ee lɨ' gacu'²‑'o'o coon'¹³ jna? ");
INSERT INTO chqNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Joon mo gangatáa¹i tsi barco do tsifu gaján¹ 'ɨɨ¹ tyí². ");
INSERT INTO chqNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Joon 'in tsá² taai²¹² tsi barco do gasii'²¹i wojníi¹i tyani Jesús joon gajin'²in: ―'E la ja'²mo, Jóon¹ Dios 'nʉ. ");
INSERT INTO chqNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Mo gatáan¹in lɨ' ngoo'¹³ cataain²¹² lɨ roon¹ 'wó² tya' tsá² Genesaret. ");
INSERT INTO chqNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Joon mo galicwii¹in 'in tsá² néei¹ do Jesús tsifu joon ganii'¹³ júu³ la caain²¹ 'in fuu²¹ joon ngajée¹i tsatsaa'¹³ lɨ tyíin¹ Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Gamɨɨ¹ɨ wa'a cwo¹o lii'²¹ 'ido tɨ' sɨɨn'¹³ɨn joon jileei'²¹ 'in galii'²¹ sɨɨn'³ 'ido ga'láa²mo. ");
INSERT INTO chqNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Joon gangatyéen¹in 'inlɨ́ɨi¹³ tsá² fariseos coon'¹³ tɨfo'² tya' ley lɨ siin'¹ Jesús. Jalíin² Jerusalén. Joon gaunngɨɨ¹ɨ: ");
INSERT INTO chqNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿'Ee lɨ' jo jmoo¹o tsá² tyi'i la tɨɨ² 'e si'² tya' 'lɨɨ²¹² tsacøøi'¹³ tyi'? Jo untsiin¹in jiin'¹³ la tɨɨsi'² 'e ruun'¹³ tsá² cwoo²¹o mo gø'²ø. ");
INSERT INTO chqNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Pe Jesús do gaunngɨɨ¹ɨ: ―Joon 'naa', ¿'ee lɨ' jo jmoo²oo' nʉ́ʉ¹³ʉʉ' la to² tyʉ'² Dios mo jmoo²oo' la tɨɨ² 'e si'² tyii'? ");
INSERT INTO chqNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Tsʉ Dios gatyʉ'² to² jin'²in: “Un'goo²'o saa²'a ñʉ'²'ʉ.” Joon gajin'²in: “'Ná¹ júun²mo jileei'²¹ 'in faa'²¹ 'laa'²¹ tya' sáa³ jmii²¹.” ");
INSERT INTO chqNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Pe 'naa'gɨɨ' fó²oo' 'e lí² sɨɨ'²¹ɨ tsá² sáa³ jmii²¹: “Jo lí² uncoon'¹³gɨɨ 'nʉ tsʉ jilaa'²¹ 'e 'oo²¹oo nigacwo'³oo Dios.” ");
INSERT INTO chqNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Joon wana jin'² la joon jo 'ná¹ uncoon'¹³gɨ sáa³a jmii²¹. Joon coon'¹³ la joon tʉʉ'¹³naa' to² tyʉ'² Dios lawa' jo 'e to² 'íin³gɨ 'e jmaa²aa' jiin'¹³ la tɨɨ² 'e si'² tyii'. ");
INSERT INTO chqNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Tsá² sɨsɨɨ¹i 'e 'ɨ¹‑tsi la jmoo¹o 'naa'! Tyʉ́²‑ʉ gataan¹ ni jí² cwáain¹ tyii' 'in tsá² gacwoo¹o júu³ tya' Dios la mo jéei¹ sii²¹ Isaías mo gajin'²in cwáain¹ tya' Dios: ");
INSERT INTO chqNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","'In tsá² lo untyú¹i jna coon'¹³ 'oo²o pe 'wíin² sɨ'ɨ́ɨ¹ 'a 'ɨ¹‑tsi coon'¹³ jna. ");
INSERT INTO chqNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Jo 'ee to² 'íi³in 'e un'goo²¹o jna². Jilaa'²¹ la 'ee¹e jmai'² 'e tyʉ'²ʉ to² tsá²‑a, jin'² Dios. ");
INSERT INTO chqNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Joon ga'láa² Jesús 'wii²¹² sɨɨ'²¹ɨ 'in tsá² néei¹ lɨ' co' do jin'²in: ―Nʉʉ²ʉʉn' joon cwo'øøi'²¹‑'oo'. ");
INSERT INTO chqNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Jilaa'²¹ 'e to'² tsá² 'oo²o jo 'leei'²¹ tsá² coon'¹³ 'e joon. 'E 'yee'² 'oo²o tsá² 'e joon 'e 'lee'²¹i. ");
INSERT INTO chqNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Joon gangatyéen¹in tsá² tya'a joon gasɨɨ'²¹ɨ Jesús: ―¿Tɨ ñí²'i, jo gatɨ́²‑tsi tsá² fariseos do júu³ tyi'i no? ");
INSERT INTO chqNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Pe Jesús gajin'²in sɨɨ'²¹ɨ 'ii: ―Jilaa'²¹ 'mó² 'e jo gajnii¹ Ñʉ'³ʉʉ 'in sø'¹o la tyan¹ jmóo³. ");
INSERT INTO chqNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Jo cuu'¹³‑'oo' coon'¹³ 'in tsá² no tsʉ lawa tsá² tiui² 'in soon'²¹ 'mo'u² tya' tsá² tiui² ruu'²¹i 'ino. Wana tsá² tiui² 'méei¹ ruu'²¹i la 'oo'²¹ tsá² tiui² joon jee²¹² waai²¹ do xuu'²¹i tsi too²¹. ");
INSERT INTO chqNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Joon Tʉ́³ do gajin'²in sɨɨ'²¹ɨ Jesús: ―Jmaa'¹³ jna'a júu³, ¿'ee 'øøi'²¹‑tsi tsá² 'e júu³ cwáain¹ lo? ");
INSERT INTO chqNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesús‑gɨ gajin'²in: ―¿Tɨ jo 'øøi'²¹‑'oo' 'naa' jon? ");
INSERT INTO chqNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Tɨ jo 'øøi'²¹‑'oo' 'e jilaa'²¹ 'e gøø'²¹ tsá² tsatoo'¹³ nʉ' tu'² tsá² joon 'woo²o tún¹? ");
INSERT INTO chqNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pe jilaa'²¹ 'e 'yee'²¹i 'oo²o tsá² 'e 'ɨ¹‑tsi tsá² 'e joon. 'E joon 'e 'leei'²¹ tsá². ");
INSERT INTO chqNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Tsʉ la 'ɨ¹‑tsi tsá² la joon lɨ́ɨ¹i joon. 'ɨ¹‑tsi tsá² 'e gó² tsʉ 'in gó²o 'ii. 'I jngaa'¹³i tsá² la joon 'e ga'ɨ¹‑tsio. Fee'²¹i tsá² tsamɨ́² tya' tsá² xeei'²¹ tsʉ ni ga'ɨ¹‑tsi la joon. 'Láa¹a tsamɨ́² coon'¹³ tsañʉʉ'¹ jiin'¹³ la niga'ɨ¹‑tsi. La joon jon jmoo¹o tsá² 'uun²¹, faa'²¹a tsá² júu³ tajuu²¹, faa'²¹a tsá² júu³ 'atsaa²¹. ");
INSERT INTO chqNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Coon'¹³ jilaa'²¹ 'elo un'leei'²¹ tsá² yaai. Pe wana gøø'²¹ø tsá² la jo mo roon'²¹on cwoo²¹o la tɨɨ² 'e si'² jo mo ga'lee'²¹i. ");
INSERT INTO chqNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Joon gacwo'ɨ́ɨ¹ Jesús fu do joon gangó¹ fu lɨ tyʉ'² to² fuu²¹ Tiro coon'¹³ fuu²¹ Sidón. ");
INSERT INTO chqNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Joon gajó² jaain²¹ tsamí² cananea 'in néei¹ do fu lɨ siin'¹³ Jesús joon ga'oo¹o jin'²in: ―¡Ña'ñʉ'¹ʉ', Jóon¹ David, fúu² cwolíi²u jna! 'In 'lɨɨi'³ 'úui² alma tya' sɨmɨ́² tyiia. Joon 'áai¹ wúu¹ nigangóo¹. ");
INSERT INTO chqNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Pe Jesús jo gañii¹i jiin'¹³xʉ. Joon tsá² tya'a gamɨɨ¹ɨ tyaníi¹i wa 'a sɨɨ'²¹ Jesús 'in tsamɨ́² do wa'a tsee'¹i tsʉ lɨ́ɨ¹ to'²o mɨɨ'¹³ jó¹ caluu lɨ ngalíin² do. ");
INSERT INTO chqNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Joon gajin'² Jesús sɨɨ'²¹ɨ 'in tsamɨ́² do: ―Dios gasii²¹in jna jiin'¹³ 'e 'naa'³na 'in tsá² sɨtuui¹ tya' tsá² Israel. ");
INSERT INTO chqNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Pe 'in tsamɨ́² do gangatyéen¹in lɨ siin'² Jesús, gasii'²¹i wojníi¹i tyaníi¹i joon gajin'²in: ―Ña'ñʉ'¹ʉ', uncoon'¹³ jna. ");
INSERT INTO chqNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Joon Jesús gañii¹i: ―Jo tyʉ́² wa'a tyi'² tsá² 'iñi'¹ tya' xuui²¹² cwo'¹o tsii²¹. ");
INSERT INTO chqNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Pe 'in tsamɨ́² do gajin'²in: ―Jo'¹o Ña'ñʉ'¹ʉ'; pe ca tsii²¹ téein² nʉ' mesa lí²‑i dø'²ø 'no'³ xʉʉ'²¹ lɨ gøø'²¹ø fii²¹² 'nʉ́¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Joon gasɨɨ'²¹ɨ Jesús 'ii: ―¡'Áai¹ fee'¹ jai'² lɨ́ɨ²u, rán³! Cwolí² jiin'¹³ la 'iin²¹²u'un. Joon tsifu joon ga'láa²mo jamɨ́ɨ¹ɨ 'in tsamɨ́² do. ");
INSERT INTO chqNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Gacwo'ɨ́ɨ¹ɨ Jesús do joon gangɨ́ɨ¹i lɨ' co' tyíia¹ Galilea. Joon gasóo²o coon²¹ moo'²¹ si'² do joon do‑o gacwoo²¹o. ");
INSERT INTO chqNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Fúu¹mo tsá² gatyalíin² lɨ tyíin¹ joon jée¹i tsatsaa'¹³ 'in lɨ́ɨ²i 'láai² nii² jmoowúu¹. Jée¹mo tsá² jluui'¹³, tsá² tiui² coon'¹³ 'in jo faa'²¹a. Jée¹mo jon tsá² poo'¹³ cwoo²¹ tɨɨ². Joon gatyéei¹ ni'i 'ido lɨ' 'wii²¹² tɨɨ² Jesús joon gaun'láa²mo Jesús 'ido. ");
INSERT INTO chqNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","'Áai¹ ganga'goo²¹o‑tsi tsá² do mo ganí² 'in tsá² do nafaa'²¹a 'in tsá² jo mo to² faa'²¹ joon 'in tsá² poo'¹³ cwoo²¹ tɨɨ² na'láa²mo joon tsá² jluui'¹³ tyʉ́²‑ʉ ningɨɨ¹ joon tsá² tiui² nijnaa'²¹o. Joon ga'láa² 'wii²¹² cwoo¹o 'maai'¹³ Dios tya' tsá² Israel. ");
INSERT INTO chqNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Joon gatø'²ø Jesús tsá² tya'a joon gajin'²in sɨɨ'²¹ɨ 'ido: ―Fúu² lɨ́ɨ²na 'in tsá² no tsʉ ningó¹ 'nɨ¹ jmɨɨ²¹² táan¹in coon'¹³ jna lo joon jo 'e 'oo¹o 'e dø'²ø. Jo 'iin²¹²na sɨɨ'¹³na fu tya'a la jo 'ee mo gøø'²¹ø sɨ no xiia'²¹ ga'woo'²¹o tya'i fu¹. ");
INSERT INTO chqNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Joon tsá² tya'a gajin'²in: ―¿Xiialɨ ijíin² jna'a 'e dø'²ø 'in tsá² fúui¹ no tsʉ jo 'in tsá² taain²¹² lo? ");
INSERT INTO chqNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Joon Jesús gaunngɨɨ¹ɨ: ―¿Joo' 'iñi'¹ 'oo²gɨɨ'? Joon ganii¹i: ―'Oo²gɨɨ'ɨ dyía¹ 'iñi'¹ coon'¹³ jaain²¹ gái¹ joo'²¹ taai² jmɨɨ²¹ pi'³. ");
INSERT INTO chqNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Joon gatyʉ'² Jesús to² wa' cwá² tsá² ni 'wó². ");
INSERT INTO chqNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Joon gason'²on 'e dyía¹ 'iñi'¹ coon'¹³ 'in joo'²¹ taai² jmɨɨ²¹ joon gacwo'¹o 'maai'¹³ Dios. Joon gajmaa¹a 'no'³ joon gacwo'¹o tsá² tya'a 'e jmáa¹a jmai'²xʉ jee²¹² 'in tsá² do. ");
INSERT INTO chqNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Jilee'²¹mo gagøø'²¹ø ca galijløø'³mo. Joon garǿø²i dyía¹ 'motó²gɨ 'e 'no'³ 'e gasáai¹. ");
INSERT INTO chqNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Joon 'in gagøø'²¹ do ti tyʉ́n² mil jmai'² tsañʉʉ'¹ jo 'e 'ii²¹in tsamɨ́² coon'¹³ xuui²¹². ");
INSERT INTO chqNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Mo ngayuui'¹³ joon ga'ɨ́ɨ²ɨ Jesús 'in tsá² do júu³. Ga'í² Jesús tsi coon²¹ barco joon gangó¹ cwoo'¹³ lɨ sii²¹ Magdala. ");
INSERT INTO chqNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Gatyalíin² 'in tsá² fariseos coon'¹³ 'in tsá² saduceos fu lɨ siin'¹³ Jesús. Joon 'e 'iin²¹²in lawa lɨ 'íi¹ goon²¹ lá² wa'a iteei'²¹ Jesús gamɨɨ¹ɨ 'in tsá² do wa jmá¹a coon²¹ li² jó¹ fu ñʉ'fú². ");
INSERT INTO chqNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Pe Jesús gañii¹i: ―'Naa' mo jøø²øø' coo²¹ jníi¹ mo xʉʉ jnáa² fó²oo': “'E tyʉ́² ijmá¹a tsʉ coo²¹ jníi¹.” ");
INSERT INTO chqNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Joon mo coo²¹ jníi¹ mo 'aa²¹ fó²oo': “Gó²xʉ jmá¹a no tsʉ coo²¹ 'e jníi¹ roon¹on.” Tsá² 'in sɨsɨɨ¹i 'ɨ¹‑tsi 'e jmoo¹o 'naa'. Ñii²¹ 'naa' xiiala ilí² mo coo²¹ jníi¹ mo 'áa²¹ coon'¹³ mo xʉʉ jnáa² pe jo ñí²ii' 'e 'øøi'²¹‑tsi 'e li² 'e sá² nano. ");
INSERT INTO chqNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Tsá² gó² coon'¹³ tsá² 'in nigatiui² Dios 'iin²¹²in coon²¹ li² pe jo ilisá² li² tya'a. Ilisá²gon li² jiin'¹³ lagɨ lisá² li² tya' Jonás. Joon gatiu²mo Jesús 'in tsá² do joon gangaa²¹o. ");
INSERT INTO chqNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Mo gangalíin tsá² tya' Jesús lɨ' ngoo'¹³ tyíia¹ lɨ' ca taain²¹² do niga'iin²mo‑tsi coon²¹on 'iñi'¹. ");
INSERT INTO chqNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Joon Jesús gajin'²in sɨɨ'²¹ɨ 'ido: ―Tyán²duu' cwáain¹, un'øø'¹³naa' yaanaa' tya' tyiian'³ tya' tsá² fariseos coon'¹³ tsá² saduceos. ");
INSERT INTO chqNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Joon ga'láa² tsá² tya'a do 'wii²¹² sɨ́ɨ¹i la 'oo'²¹ jee²¹² 'ii: ―'Wii'¹³ jo ga'lee²¹e' 'iñi'¹ 'e joon 'e jin'² la joon. ");
INSERT INTO chqNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Joon mo galili'³i Jesús 'ee 'ɨ¹‑tsi 'ii joon gajin'²in: ―Laa'¹³ 'áai¹ xʉ jo'¹ lɨ́ɨ²naa'. ¿'E lɨ' 'ɨ¹‑'oo' 'e jo 'iñi'¹ tyán²aan'? ");
INSERT INTO chqNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Tɨ jo mo ga'øø'²¹mogɨ‑'oo', tɨ jo tɨɨ'¹³‑'oo' xiiala mo gajmáa³aa tyíia³ 'a 'iñi'¹ 'ñá² do jee²¹² 'ñá² mil tsañʉʉ'¹? ¿Joo' 'motó² 'no'³ 'iñi'¹ 'e gasái¹gɨ? ");
INSERT INTO chqNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Tɨ jo tɨɨ'¹³‑'oo' mo gajmáa³aa tyíia³ 'e 'iñi'¹ dyía¹ do jee²¹² tyʉ́n² mil tsá²? ¿Joo' 'motó² 'no'³ 'e gasái¹gɨ? ");
INSERT INTO chqNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","'Áai¹ jo mo ga'øøi'²¹‑'oo' 'e jon'on fuu²¹²uu 'naa' cwáain¹ tya' 'iñi'¹ mo fuu²¹²uu 'naa' 'e un'øøi'¹³ yaanaa' coon'¹³ tyiian'³ tya' tsá² fariseos coon'¹³ tsá² saduceos. ");
INSERT INTO chqNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Joon gali'øøi'²¹‑tsi tsá² tya' Jesús 'e jon'on cwáain¹ tya' tyiian'³ tya' 'iñi'¹ jin'² Jesús pe cwáain¹ tya' júu² 'ee¹ tsá² fariseos coon'¹³ tsá² saduceos. ");
INSERT INTO chqNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Mo gatyía¹ Jesús coon'¹³ tsá² tya'a coon²¹ lɨ tyʉ'² to² fuu²¹ Cesarea tya' Filipo gaunngɨɨ¹ɨ Jesús tsá² tya'a jin'²in: ―¿'Iin jna, Ruu'²¹i Tsá², jin'² tsá²? ");
INSERT INTO chqNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Joon gañii¹i tsá² tya'a: ―'Inlɨ́ɨi¹³ jin'²in 'e Wó³ saai¹ tsá² jmɨɨ²¹ 'nʉ. 'Inlɨ́ɨi¹³gɨ jin'²in 'e Elías 'nʉ. Joon tsá² xeei'²¹ jin'²in 'e Jeremías 'nʉ sɨ jaain²¹ 'in nigacwo¹ júu³ tya' Dios la mo jéei¹ 'ee 'nʉ. ");
INSERT INTO chqNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Joon gaunngɨɨ¹ɨ Jesús 'ii: ―'Naa', ¿'iin jna fó²oo' 'naa'? ");
INSERT INTO chqNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Joon Simón Pedro do gajin'²in: ―'Nʉ‑ʉ Cristo 'in gasii¹in Dios. Jóon¹ Dios 'in jiin'¹ 'nʉ. ");
INSERT INTO chqNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Joon Jesús gajin'²in: ―Jløø'³mo 'nʉ, Simón, jóon¹ Jonás, tsʉ jon' tsá² ga'e'² 'nʉ 'e júu³ lo. Pe Ñʉ'³oo 'in tyíin¹ ñʉ'fú² ga'e'²e 'nʉ. ");
INSERT INTO chqNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Joon fuu²¹²uu 'nʉ, 'e sii²¹ 'nʉ Tʉ́³, joon júu³ tyi'i 'e foo²¹'o 'e lɨ́ɨ¹na Cristo, 'in gasii¹in Dios, ilɨ la lɨ coon²¹ cuun²¹² fee'¹ 'e jo jøøi'²¹ tya' 'in jai'² lɨ́ɨ²i jna tsʉ jileei'²¹ 'in jmoo¹o la to² tyʉ'² Dios lɨ́ɨ¹i la joon. Joon ca 'mó¹ jo lí² lii'¹i 'e júu³ do. ");
INSERT INTO chqNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Joon cwo'³oo 'nʉ jonñí³ tya' lɨ tyʉ'² Dios to² tsá². Jilaa'²¹ 'e untsaa'¹³u fu juncwii²¹ lo nigalɨuntsaa'¹²a fu ñʉ'fú². Joon jilaa'²¹ icwo'²'o lí² juncwii²¹ lo la joon galɨ́² fu ñʉ'fú² jon. ");
INSERT INTO chqNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Joon gatyʉ'² Jesús to² tsá² tya'a 'e jo 'in jma'¹a 'ido júu³ jiin'¹³ jaain²¹ 'e Cristo ii. ");
INSERT INTO chqNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Joon 'yiia'¹³ joon ga'láa² Jesús 'wii²¹² jmo'²o tsá² tya'a júu³ 'e 'ná¹ tsáa¹a Jerusalén joon do‑o i'e'²e tsacøøi'¹³ coon'¹³ 'in tyʉ'² to² untsá² coon'¹³ tɨfo'² tya' ley 'ii wúu¹. Joon ijnga'²mo 'ido 'ii pe ijiin'¹o tún¹ mi tɨ 'nɨ¹ jmii²¹². ");
INSERT INTO chqNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Joon Tʉ́³ do ngajée¹i lɨ coon'²¹ joon gasɨɨ'²¹ɨ Tʉ́³ Jesús júu³ wúu¹ jin'²in: ―¡Jo icwó² Dios 'e lí² la joon, Ña'ñʉ'¹ʉ'! ¡Jo lí² wa' itsangɨɨ¹i 'nʉ la joon! ");
INSERT INTO chqNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Joon gajiin'¹³ Jesús níi¹i joon gajin'²in sɨɨ'²¹ɨ Tʉ́³ do: ―Jeein'¹³ coon'¹³ jna, Satanás, tsʉ ijnɨɨ'¹³moo coon'¹³ júu³ tyi'i. Jo 'ɨ¹‑'o'o la 'ɨ¹‑tsi Dios. La 'ɨ¹‑tsi tsá²‑a 'ɨ¹‑'o'o. ");
INSERT INTO chqNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Joon gajin'² Jesús sɨɨ'²¹ɨ tsá² tya'a: ―Wa 'iin²¹²in tsá² ngɨ́¹ coon'¹³ jna 'ná¹ tʉʉ²¹ 'e 'ɨ¹‑tsi tya' 'ña'a, 'ná¹ tyá²a tyʉ́² tya'a ijúun²in la ijúuin³ jna. Joon jó¹ coon'¹³ jna. ");
INSERT INTO chqNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Tsʉ jileei'²¹ 'in 'iin²¹²in láa¹i juncwii²¹ tya'a 'ña'a incaa²¹mo juncwii²¹ tya'a fu lɨ 'ii²¹ pe jileei'²¹ 'in caai²¹ juncwii²¹ tya'a 'wii'¹³ jna pe intii'¹³mo juncwii²¹ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿'Ee to² 'íi³ tya' tsá² wa'a li'³i jilaa'²¹ 'e sá² la tøøi² ni cwoo'¹³ juncwii²¹ pe caa¹mo alma tya'a? ¿'Ee coon'¹³ lí² tyí² tsá² tya' alma tya'a? ");
INSERT INTO chqNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Tsʉ 'in Ruu'²¹i Tsá² ijó¹ coon'¹³ jilaa'²¹ 'e 'ya'²gɨ tya' Jmii²¹ coon'¹³ ángeles tya'a joon ityí³ tya' jileei'²¹ tsá² tɨ jaain²¹ tɨ jaain²¹ jiin'¹³ la nigajmaa¹a. ");
INSERT INTO chqNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","'E la ja'²mo fuu²¹²uu 'naa', seein²¹ 'inlɨ́ɨi¹³ 'in teein² lo 'in jo ijúun²in ca mi jǿø²i 'in Ruu'²¹i Tsá² jó¹ ityʉ'²ʉ to². ");
INSERT INTO chqNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Joon mo gangɨ́ɨi¹ jnʉ́ʉ² jmɨɨ²¹² ngajéei¹ Jesús Tʉ́³ coon'¹³ Jacobo coon'¹³ Wó³ ruu'²¹i Jacobo do fu yʉ' coon²¹ moo'²¹ ñíi¹ la jee²¹² tyúuin² do. ");
INSERT INTO chqNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Joon do‑o gaunsɨ́ɨ²i 'e lɨ́ɨ¹i tyani 'in tsá² do. Joon níi¹i galijɨɨ'¹ la jɨɨi'¹ ñi'¹, sɨɨn'³gɨ galitaa²¹ la taa²¹ 'yiia²¹ tya' ñi'¹. ");
INSERT INTO chqNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Joon tsifu joon gangaa¹in Moisés coon'¹³ Elías teen¹in tyaa¹ júu³ coon'¹³ Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Joon gajin'² Tʉ́³ sɨɨ'²¹ɨ Jesús: ―Ña'ñʉ'¹ʉ', ¡'áai¹ tyʉ́² 'e toon²¹o'on lo! Wana 'iin²¹²u'u, jmoo²¹o'o 'nɨ¹ 'nʉ́¹ pi'³: coon²¹ tyi'nʉ, coon²¹ tya' Moisés joongɨ coon²¹ tya' Elías. ");
INSERT INTO chqNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","La jee²¹² faa'²¹a Tʉ́³ do gajgó¹ coon²¹ jníi¹ taa²¹ jɨɨ'¹ lɨ teein¹. Joon ganúu²un coon²¹ júu³ jee²¹² jníi¹ do 'e jin'²in: ―'In lo‑o yʉʉn²¹ tyiia 'in 'iin²¹²na, 'áa¹mo jløø'³na 'wii'¹³ tya'a. Nʉʉ²ʉʉ' 'e jin'². ");
INSERT INTO chqNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Joon mo ganúu²un 'e júu³ do gafoo'¹mo 'áai¹ joon gatyii²¹a lɨ' rɨ'íi²in ni 'wó². ");
INSERT INTO chqNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Joon Jesús gangatyéen¹in lɨ teei'¹³ tsá² tya'a joon gataan¹an cwoo²¹o tya' 'ido, sɨɨ'²¹ɨ: ―Ráan²naa'; jo foo'¹³naa'. ");
INSERT INTO chqNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Joon mo gajǿø²ø jo 'in gangaai¹gɨ jiin'¹³ 'ña'a Jesús siin'¹²gɨ. ");
INSERT INTO chqNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Joon mo gajgáa¹i 'e moo'²¹ do ga'ɨ́ɨ²ɨ Jesús júu³ tsá² tya'a jin'²in: ―Jo 'e fú²uu', jiin'¹³ jaain²¹, ca mi yuui'¹³ jiin'¹ 'in Ruu'²¹i Tsá² jee²¹² 'lɨɨ²¹². ");
INSERT INTO chqNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Joon gaunngɨɨ¹ɨ tsá² tya'a: ―¿'Ee lɨ' jin'²in 'in tɨfo'² tya' ley 'e 'ná¹ jó¹ Elías nifu? ");
INSERT INTO chqNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesús‑gɨ gañii¹i: ―'E la ja'²mo 'ná¹ jó¹ Elías joon 'e tyá² tyʉ́² jilaa'²¹. ");
INSERT INTO chqNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pe fuu²¹²uu 'naa' 'e najó²‑o Elías joon jo galicwii¹in 'in tɨfo'² tya' ley do 'ii, lɨ jiin'¹³ gajmaa¹a jiin'¹³ la 'iin²¹²in tya' 'ido. La joon jon i'e'²e wúu¹ 'in Ruu'²¹i Tsá². ");
INSERT INTO chqNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Joon ga'øø'²¹mo‑tsi tsá² tya' Jesús 'e faa'²¹a Jesús cwáain¹ tya' Wó³ saai¹ tsá² jmɨɨ²¹. ");
INSERT INTO chqNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Joon mo gatyía¹ Jesús lɨ taai² tsá² gangatyéein¹ jaain²¹ tsá² lɨ siin'¹² Jesús joon gasii'²¹i wojníi¹i tyani Jesús joon gajin'²in: ");
INSERT INTO chqNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Jmaa²'a feei'¹‑'o'o 'wii'¹³ tyiia. Fúu² cwolíi²u xuui²¹² tyiia tsʉ júuin² ñii'¹ tsʉ 'áai¹ wúu¹ ní²i. Cɨɨ'¹³i ni jɨ́² sɨ tsi jmii²¹ 'ee 'láai² naa'¹³. ");
INSERT INTO chqNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ningajée¹moo xuui²¹² tyiia fu lɨ néei¹ tsá² tyi'i pe jo galɨ'²ɨ gaun'láa² ni'i lo. ");
INSERT INTO chqNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesús gañii¹i: ―¡Tsá² 'in jo tsáai¹‑tsi 'naa'; sɨcaai'¹³ 'ɨ¹‑'oo'! ¿Tɨ wóo²gɨ 'áai¹ 'ná¹ taan²¹²na coon'¹³ 'naa'? ¿Tɨ wóo²gɨ 'áai¹ 'ná¹ lifeei'¹‑tsii 'wii'¹³ tyii'? Ñijeei¹duu' xuui²¹² do fu lo. ");
INSERT INTO chqNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Joon gatyʉ'² Jesús to² 'in 'lɨɨi'³ 'yuui² alma tya' 'in xuui²¹² do joon ga'wóo²mo. Joon tsifu joon ga'láa²mo 'in xuui²¹² do joon. ");
INSERT INTO chqNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Joon coon²¹ lɨ néei¹ Jesús coon'²¹ la 'oo'²¹ tsá² tya'a joon gaunngɨɨ¹ɨ tsá² tya'a: ―¿'Ee lɨ'ɨ jo galɨ'²ɨ'ɨ tyí² jna'a 'in 'lɨɨi'³ 'yuui² alma tya' 'in xuui²¹² do? ");
INSERT INTO chqNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Joon Jesús gajin'²in: ―Jo galɨ́²ɨɨ' gatyí² 'naa' 'ido tsʉ 'wii'¹³ xʉ jai'² lɨ́ɨ²naa'. 'E la ja'²mo fuu²¹²uu 'naa' wana jai'² lɨ́ɨ²naa', fiin'¹³ coon'¹³ coon²¹ 'e pii'³, lí²‑i fú²uu' 'e moo'²¹ si'² dó²: “Jiin'¹³ lo; cwó² lɨ' lɨ xiia'²¹.” Joon ijeen'²¹mo 'e moo'²¹ do. Jilaa'²¹ ilí² tya' 'in jai'² lɨ́ɨ²i. ");
INSERT INTO chqNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Pe 'in 'lɨɨi'³ la no 'wóo²mo jiin'¹³ wa'a faa'²¹a tsá² júu³ tyʉ́² joongɨ gøø'²¹ tsá² tyiiañi'¹. ");
INSERT INTO chqNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Joon mo taan²¹²in caain²¹ fu lɨ sii²¹ Galilea gajma'²a Jesús tsá² tya'a júu³ 'e tsá²‑a i'nɨ́ɨ¹i Ruu'²i Tsá². ");
INSERT INTO chqNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Joon ijngaa'¹³mo 'ido 'ii. Pe mi tɨ 'nɨ¹ jmɨɨ²¹² ijiin'¹o tún¹. Joon 'áai¹ ga'aa¹a fa'í³ 'e ganúu²un 'e júu³ do. ");
INSERT INTO chqNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Joon mo gatyalíin² Jesús coon'¹³ tsá² tya'a fuu²¹ Capernaum 'in tsá² 'in cón² 'laa'¹³ tya' cwo'¹ gafee'²¹i Tʉ́³, gaunngɨɨ¹ɨ: ―¿Tɨ jo tyí² tɨfo'² tyii' 'laa'¹³ cwo'¹? ");
INSERT INTO chqNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Joon Tʉ́³ gajin'²in: ―Tyí²o 'ino. Joon mo ga'í² Tʉ́³ inʉʉ tsifu gajin'²in Jesús sɨɨ'²¹ɨ 'ii: ―¿'Ee 'ɨ¹‑'o'o, Simón? ¿'Iin tyí² 'laa'¹³ tya' rǿøi¹³ taain²¹² juncwii²¹, tɨ tsá² tya'a sɨ tsá² coon²¹ fuu²¹ 'ee? ");
INSERT INTO chqNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Joon Tʉ́³ do gañii¹i: ―Tsá² coon²¹ fuu²¹ tyí². Joon Jesús gajin'²in sɨɨ'²¹ɨ Tʉ́³ do: ―Wana la joon jna jo 'ná¹ cɨ́ɨ³ɨɨ 'laa'¹³ tya' cwo'¹. ");
INSERT INTO chqNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pe la coon'²¹ 'e jo 'e ifaa'²¹a 'in tsá² no 'laa'²¹ tyi', cwó² fu tɨ' tyíia¹ cwo'i'²'i moocuu². Joon 'in joo'²¹ in téen¹u'u nifu ityii'¹'a coon²¹ cuu² nʉ' 'oo²¹²o. Joon 'e cuu² do ilíin²mo 'e cɨ²'ɨ 'laa'¹³ tyi'i coon'¹³ tyiajna. Cwocón² tya' 'in tsá² cón² 'laa'¹³ do. ");
INSERT INTO chqNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","'Yiia'¹³ joon gangatyéen¹in tsá² tya' Jesús fu lɨ tyíin¹in joon gaunngɨɨ¹ɨ: ―¿'Iin 'in tyiin²gɨ lɨ tyʉ'² Dios to² tsá²? ");
INSERT INTO chqNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Joon gatø'² Jesús jaain²¹ xuui²¹² 'e jmáa¹a siin'¹²in tuntsa' jee²¹² 'in tsá² do, ");
INSERT INTO chqNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","joon gajin'²in: ―'E la ja'²mo fuu²¹²uu 'naa', wa jo unsɨ́ɨ²naa' 'e 'ɨ¹‑'oo' joon líin²naa' la lɨ́ɨ¹i 'in xuui²¹² no jo cwotaan²naa' fu lɨ tyʉ'² Dios to² tsá². ");
INSERT INTO chqNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","'E coon'¹³ la joon 'in tyiin²gɨ fu lɨ tyʉ'² Dios to² tsá² ilíin² la 'in xuui²¹² no 'in jo jmaa'²i jloo'³ 'ña'a. ");
INSERT INTO chqNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Joon doñi'iin 'in 'ii'²¹ jaain²¹ xuui²¹² coon'¹³ 'e sii²¹ jna la 'ino, joon 'ii'²¹mo jna jon. ");
INSERT INTO chqNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Wa seein²¹ tsá² itɨlí² jmáa¹a 'e 'noo¹o xuui²¹² 'in jo'² lɨ́ɨ²i jna tsaa², tyʉ́²gɨ tya'a wa'a jéei¹gɨ 'ñʉ́¹ʉ tsá² luu²¹²u coon'¹³ coon²¹ too¹ fee¹ joon pii¹in tsá² 'ii tsi jmɨ'ñi'³ lɨ 'o'². ");
INSERT INTO chqNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡'Áa¹mo gó² 'e sá² 'e 'leei'²¹ tsá² taain²¹² juncwii²¹! Joon la joon 'e 'ná¹ ilí² pe fúu² 'in tsá² 'in jmoo¹o 'e un'leei'²¹ tsá² yaai. ");
INSERT INTO chqNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Tsʉ 'wii'¹³ joon wa gajmaa¹a cwoo¹'o sɨ tɨ́ɨ¹³'ɨ 'ee 'lee'²¹'u, cwotʉ́ʉ¹nu'u joon cwopíi¹nu'u lɨ wíin². Tsʉ tyʉ́²gɨ tyi'i 'e seen²¹un juncwii²¹ tsá² pooi'¹³ sɨ tsá² jluui'¹³ 'ee lagɨ cwoo'¹³'o lɨ 'ii²¹ lɨ coo²¹ coon²¹ tøø²mo coon'¹³ je tún² cwoo¹'o sɨ jé² tún² tɨ́ɨ¹³'ɨ 'ee. ");
INSERT INTO chqNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Joon wa unní²'i jmoo¹o 'e 'nóo²'o tsaa², tyii²'i, píi¹nu'u lɨ wíin² tsʉ tyʉ́²gɨ tyi'i 'e seen²¹mo'o coon'¹³ coon²¹ unní²'i lagɨ cwoo'¹³'o lɨ 'ii²¹ lɨ coo²¹ coon²¹ tøø²mo. ");
INSERT INTO chqNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Jo jmaa²aa' wa' jo tsáai¹‑'oo' xuui²¹² no. Tsʉ fuu²¹²uu 'naa', 'in ángeles tya'a taa²i tyani Nʉ'³ʉʉ 'in tyíin¹ ñʉ'fú². ");
INSERT INTO chqNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","In Ruui'²¹ Tsá² gajó² juncwii²¹ jmáa¹a tiin'¹³ tsá² 'in ngɨ́² sɨtuui¹. ");
INSERT INTO chqNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿Xiiala lɨ́ɨ²naa'? Wa' jaain²¹ tsá² 'aa¹i coon²¹ cíein¹³ joo'saa'²¹ joon wa gatuui¹ jaain²¹, itiu²mo 'in noventa y nueve jee²¹² moo'²¹ joon 'e tsa'nee'¹³i 'in sɨtuui¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Joon wa gatsee'²¹i joon ilijløøi'³gɨ tya' 'in joo'saa'²¹ gatsee'²¹i do lagɨ 'in noventa y nueve do 'in jo ituui¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","La joon jon 'Ñʉ́²ʉʉ', 'in tyíin¹ ñʉ'fú², jo 'iin²¹²in wa' 'e ngɨ́² sɨtuui¹ jiin'¹³ jaain²¹ jee²¹² 'in xuui²¹² pi'³. ");
INSERT INTO chqNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Wa ga'láa²a ruu'²¹'u tyi'i sii'¹³du' la 'oo'²¹ gáa¹naa' joon jmaa²'a júu³ xiiala ga'láa¹a. Joon wana gajmaa¹a nʉʉ'¹³ʉn júu³ tyi'i joon lɨ'²ɨ 'e seen²¹naa' tyʉ́² coon'¹³. ");
INSERT INTO chqNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Pe wa jo gajmaa¹a nʉʉ'¹³ʉn te'² jaain²¹ gaí¹gɨ tsá² 'e núu¹un 'e sɨ́ɨ¹³naa' ilíi²in tsá² jmoo¹o júu³ jai'² 'in tsá² do. ");
INSERT INTO chqNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Joon wana jo gajmaa¹a ruu'²¹'u nʉʉ'¹³ʉn tyani 'in tsá² jmoo¹o júu³ jai'² do joon cwojee¹u 'in ruu'²¹'u do tyani lɨ sɨcaain²¹ jileei'²¹ 'in tsaa'¹‑tsi Dios. Joon wana jo galinʉʉ'¹³ʉn tún¹ tyani 'in tsá² fúui¹ 'in tsaa'¹‑tsi Dios joon líi²in 'in ruu'²¹'u do lawa jaain²¹ 'in jo tsaa'¹‑tsi Dios sɨ lawa jaain²¹ 'in cón² 'laa'¹³ tya' 'e 'nɨɨ¹ɨ tsá² 'ee. ");
INSERT INTO chqNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’'E la ja'²mo fuu²¹²uu 'naa', 'e jilaa'²¹ 'e untsaa'¹³naa' fu juncwii²¹ lo la joon jon 'e lí² tsaai'¹³ fu ñʉ'fú². Joon jilaa'²¹ 'e cwó²oo' lí² fu juncwii²¹ lo la joon ilí² fu ñʉ'fú² jon. ");
INSERT INTO chqNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Fuu²¹²uu 'naa' jon, wana ti gáa¹naa' 'in cwoo²oo' júu³ ruu'²¹naa' coon'¹³ coon²¹ júu³ tyʉ́² 'e mɨ́²ɨɨ', Ñʉ'³ʉʉ 'in tyíin¹ ñʉ'fú² icwo'¹o 'naa' 'e gamɨ́²ɨɨ' do. ");
INSERT INTO chqNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Mo natí² fiin'¹³ gaí¹ gaai²¹ tsá² 'in sɨcaain²¹ iun'goo²¹o jna siin'¹³moo jee²¹² 'ii²¹ ―jin'² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Joon Tʉ́³ do gangóo¹ ngafee'¹³i Jesús jin'²in: ―Ña'ñʉ'¹ʉ', wa gajmaa¹a ruu'²¹na 'e gó² tyiia ¿joo' naa'¹³ 'ná¹ jmáa³aa feei'¹‑tsii 'wii²¹² tya'a? ¿Tɨ ca tɨ́² dyía¹ naa'¹³? ");
INSERT INTO chqNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Joon gañii¹i Jesús: ―Jo fuu²¹²uu 'nʉ ca tɨ́² dyía¹ naa'¹³ pe fuu²¹²uu 'nʉ ca gatyía¹ setenta naa'¹³ 'e gafuu²¹²uu 'nʉ dyía¹ naa'¹³. ");
INSERT INTO chqNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Tsʉ 'wii'¹³ joon 'e tyʉ'¹ Dios to² tsá² lɨ la lɨ́ɨ¹i jaain²¹ rǿøi¹³ 'in gali'iin²¹²in jmaa'¹³a cwáain¹ tya' tsa'leei'¹³ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Joon mo ga'láa² 'wii²¹² gatø'¹ø 'in rǿøi² do tsá² tya'a joon gatyía¹ jaain²¹ 'in rǿøi² tya'a 'láai¹ 'áai¹. ");
INSERT INTO chqNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Joon 'in tsa'leei'¹³ do jo 'e 'oo¹o wa'a tyí² tya'a. Joon 'in rǿøi¹³ do gatyʉ'²ʉ to² tsa'leei'¹³ tya'a wa' 'nɨɨ¹ ni 'ido coon'¹³ 'oo² 'ido coon'¹³ jóon¹on coon'¹³ jilaa'²¹ 'e sá² tya'a 'e tyí² 'e rǿøi² do. ");
INSERT INTO chqNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Pe 'in tsa'leei'¹³ do gasii'²¹i wojníi¹i tyani ñi'fii²¹²i joon gamɨɨ¹ɨ tyani 'ido 'áai¹: “Ñi'fí²i' cwolifee'¹mo‑'o'o 'wii²¹² tyiia joon icɨ́ɨ³oo jilaa'²¹ 'e rǿø²na tyi'i.” ");
INSERT INTO chqNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Joon ñi'fii²¹²i do galifee'¹mo‑tsi 'wii²¹² tya' jilaa'²¹ 'e rǿøi² joon galáa²mo 'ido 'ii. ");
INSERT INTO chqNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Joon tsifu cwo'ɨ́ɨ¹ɨ tya' ñi'fii²¹²i do joon xʉ ngai'²xʉ mo gajiin'¹in jaain²¹ tsañʉʉ'¹ 'in nirǿøi²xʉ coon²¹ tún² 'ii'²¹ cuu². Joon tsifu gason'²on luu²¹² 'ido sɨɨ'²¹ɨ: “¡Tyí² gon 'e rǿø²u tyiia do la no la!” ");
INSERT INTO chqNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Joon gasii'²¹ 'in tsá² do wojníi¹i tyaníi¹i joon gamɨɨ¹: “Cwolifee'¹mo‑'o'o 'wii²¹² tyiia joon icɨ́ɨ³oo jilaa'²¹ 'e rǿø²na tyi'i.” ");
INSERT INTO chqNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Pe 'ii‑gɨ jo galifeei'¹‑tsi 'wii²¹² tya' 'in tsá² do. Joon gatan'²ni'i 'ido 'nʉñi'³ ca tyí² jilaa'²¹ 'e rǿøi². ");
INSERT INTO chqNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Pe mo ganí²i 'in tsa'leei'¹³ catyaai² do xiiala gajmaa¹a 'in tsá² do galixuu²¹²mo‑tsi joon ngalíin² ngajmaa'¹³a júu³ ñi'fii²¹²i jilaa'²¹ 'e nigalɨ́². ");
INSERT INTO chqNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Joon 'in ñi'fii²¹² do gatyʉ'²ʉ to² tsa'leei'¹³ tya'a wa'a tsate'¹e 'in tsá² do. Joon mo gatyía¹ 'in tsá² do gajin'² rǿøi¹³ sɨɨ'²¹ɨ 'ido: “¡Tsa'leei'¹³ 'in gó² 'nʉ! Ga'iin²moo 'e rǿø²u tyiia 'wii'¹³i gamɨ́²'ɨ tyaní³ii. ");
INSERT INTO chqNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","'Ná¹‑a jon jmaa²'a feei'¹‑'o'o 'wii²¹² tya' tsaruu'²¹'u jiin'¹³ la nigajmáa³aa feei'¹‑tsii 'wii²¹² tyi'i.” ");
INSERT INTO chqNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Joon gatsá² 'nii'²¹‑tsi ñi'fii²¹²i do tya'a 'áai¹gɨ. Joon gatyʉ'²ʉ to² i'e'²e tsá² 'ido wúu¹ ca mi tyí² jilaa'²¹ 'e rǿøi². ");
INSERT INTO chqNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","’La joon jon ijmá¹a Ñʉ'³ʉʉ, 'in tyíin¹ ñʉ'fú², coon'¹³ 'naa' wa jo jmaa²aa' feei'¹‑'oo' 'wii²¹² tya' tsaruu'²¹naa' 'e 'yaai²¹²‑'oo' ―jin'² Jesús do. ");
INSERT INTO chqNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Mo ngayuui'¹³ gajin'² Jesús jilaa'²¹ 'e júu³ lo gacwo'ɨ́ɨ¹ɨ lɨ sii²¹ Galilea joon gangó¹o lɨ roon¹on coon²¹ 'wó² lɨ sii²¹ Judea 'e roon¹on lɨ' ngoo'¹³ jmɨɨ²¹ Jordán lɨ' lɨ 'yeei²¹ ñi'¹. ");
INSERT INTO chqNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Fúu¹mo tsá² gangalíin² coon'¹³on. Joon gaun'láa²mo Jesús 'in tsá² do. ");
INSERT INTO chqNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Joon 'inlɨ́ɨi¹³ tsá² fariseos gangatyéen¹in lɨ ngó¹o Jesús 'e 'iin²¹²in 'e teei'²¹ Jesús lawa coon²¹ nilá² joon gaunngɨɨ¹ɨ: ―¿Ja ilí² tiui² tsá² tsamɨ́² tya' coon'¹³ doñi'ee cwáain¹? ");
INSERT INTO chqNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Joon gañii¹i 'ii: ―Ñí² 'naa' 'ee jin'² júu³ tyʉ́² tya' Dios 'e mo 'láa² 'wii²¹² gajmee¹i Dios tsañʉʉ'¹ coon'¹³ tsamɨ́². ");
INSERT INTO chqNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Jin'²o jon: “Tsʉ 'wii'¹³ joon itiu²mo tsá² sáa³ jmii²¹ ilicaain²¹ coon'¹³ 'oo²o joon jee²¹² gáa¹i do ilíi²in lawa jaan²¹mo.” ");
INSERT INTO chqNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Joon jo lɨ́ɨi¹gɨ gáa¹i jaan²¹mo galɨ́ɨ¹i joon. Tsʉ 'wii'¹³ joon jo lí² xee¹i tsá² 'in gauncaain²¹ Dios. ");
INSERT INTO chqNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Joon gaunngɨɨ¹ɨ 'in tsá² do: ―Wa la joon, ¿'ee lɨ'ɨ gatyʉ'²ʉ 'lɨɨ²¹² Moisés to² wa lí² cwo'¹ tsá² 'oo²o coon²¹ mo'jí² 'e lí² tiui² tsá² 'ii? Joon coon'¹³ la joon tiu²mo 'ido. ");
INSERT INTO chqNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Joon gajin'² Jesús sɨɨ'²¹ɨ 'in tsá² do: ―Galɨ́²‑ɨ la joon tsʉ 'wii'¹³ 'áai¹ sóo²‑'oo' 'naa'. Tsʉ jo la joon lɨ́² la mo 'wiin²¹². ");
INSERT INTO chqNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Jna fuu²¹²uu 'naa', wana tiui² tsá² 'oo²o wa mo jo mo 'láa¹a coon'¹³ tsañʉʉ'¹ xeei'²¹ joon cuu'²¹i cwoo²¹o coon'¹³ jaain²¹gɨ tsamɨ́² 'noo¹on tsaa² coon'¹³ 'in tsamɨ́² do. Joon wana cuu'²¹i tsá² cwoo²¹o coon'¹³ jaain²¹ tsamɨ́² 'in natiui² ñʉʉ'¹ tya'a joon 'noo¹on tsá² tsaa² 'e la joon. ");
INSERT INTO chqNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Joon gajin'² tsá² tya'a sɨɨ'²¹ɨ Jesús: ―Wana la joon jmoo¹o tsañʉʉ'¹ coon'¹³ 'oo²o tsáai¹gɨ‑tsi wa jo cuu'²¹mo cwoo²¹o. ");
INSERT INTO chqNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesús‑gɨ gajin'²in: ―Jo jileei'²¹ lí² 'øøi'²¹‑tsi 'elo. Lɨ jiin'¹³ 'in nityii'¹³in Dios ilí² 'øøi'²¹‑tsi. ");
INSERT INTO chqNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","'Láa²mo 'ii'¹³ 'e sá² 'e jo lí² cui'² cwoo²¹o tsá². 'Inlɨ́ɨi¹³ jo 'íi¹in 'e cui'² cwoo²¹o ca mi liseen²¹mo. 'Inlɨ́ɨi¹³gɨ tsá² jo cwó² tsá² jon cui'² cwoo²¹o. 'Inlɨ́ɨi¹³gɨ tsá² jo 'iin²¹²in cui'² cwoo²¹o tsʉ 'wii'¹³ cwáain¹ tya' lɨ tyʉ'² Dios to². Jileei'²¹ 'in lí² jmá¹ 'elo, cwojmaa¹a. ");
INSERT INTO chqNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Joon gangajée¹i tsá² xuui²¹² tya'a lɨ sin'² Jesús wa'a taan¹an Jesús cwoo²¹o tya' 'ido joon faa'²¹a júu³ tyʉ́². Pe tsá² tya'a ga'láa² 'wii²¹² jíi² ni'i 'in tsá² jée¹i xuui²¹² do. ");
INSERT INTO chqNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Pe Jesús gajin'²in: ―Cwó²duu', cwojalíin² xuui²¹² no tyaní³ii joon jo untsaa'¹³naa' tsʉ jiin'¹³ 'in lɨ́ɨ¹i la no‑o tsataai² lɨ tyʉ'² Dios to². ");
INSERT INTO chqNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Joon gataan¹an cwoo²¹o tya' 'in xuui²¹² do. Joon mo ngayuui'¹³ joon gacwo'ɨ́ɨ¹o do. ");
INSERT INTO chqNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Joon gatyía¹ jaain²¹gɨ tsá² 'in gaunngɨɨ¹ɨ gajin'²in sɨɨ'²¹ɨ Jesús: ―Tɨfo'² tyúi¹, ¿'ee 'e tyʉ́² 'ná¹ jmáa³aa 'e liseen²¹na tyʉ́² coon²¹ tøøi²? ");
INSERT INTO chqNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesús gajin'²in: ―¿'Ee lɨ'ɨ fu'²'u jna 'in tyúi¹? Jaan²¹mo 'in seein²¹ 'in tyúi¹ jiin'¹³ 'ña'a Dios. Pe wana 'iin²¹²u'u liseen²¹mo'o tyʉ́² jmaa²'a la to² tyʉ'² Dios. ");
INSERT INTO chqNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Joon gajin'² 'in sɨmii'²¹ do: ―¿Noo to² tyʉ'² Dios? Joon Jesús ganii¹i: ―Jo jngá¹u'u tsá²; jo 'laa²¹²'a coon'¹³ tsamɨ́² tya' tsá² xeei'²¹; jo jmaa²'a 'uun²¹; jo fu'²'u júu³ tajuu²¹ jiin'¹³ jaain²¹; ");
INSERT INTO chqNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","un'goo²'o nʉ'²'ʉ coon'¹³ saa²'a; cwoli'iin²¹²u'u tsaruu'²¹'u lawa 'wo'o. ");
INSERT INTO chqNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Joon gañii¹i 'in sɨmii'²¹ do: ―Jilaa'²¹ la no nigajmáa³aa jiin'¹³ la mo xuu²¹²na. ¿'Ee 'ná¹ jmáa³gɨɨ? ");
INSERT INTO chqNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Joon Jesús gajin'²in: ―Wana 'iin²¹²u'un 'e jo 'e sɨ'naai²¹gɨ 'e 'naa²¹ cwo'nɨɨ²¹²'ɨ 'e 'oo²¹²'o joon cwo'²'o tsá² tañíi² joon lisá² 'láai²gɨ tyi'i fu ñʉ'fú². Mi yuui'¹³ joon na¹, ngɨ'²'ɨ coon'¹³ jna. ");
INSERT INTO chqNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Pe mo ngayuui'¹³ ganúu²un 'e júu³ lo gangaa'¹³i fa'í³ 'áai¹ tsʉ 'áa¹mo sá² cuu² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Joon gajin'² Jesús sɨɨ'²¹ɨ tsá² tya'a: ―'E la ja'²mo fuu²¹²uu 'naa', 'áai¹ wúui¹ cwói¹ yaai tsá² sá² cuu² tyʉ'²ʉ Dios to² 'ii. ");
INSERT INTO chqNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Fuu²¹²uu 'naa' tún¹, tyan²gɨ to² wa'a tsa'í² jaain²¹ tsá² sá² cuu² lɨ tyʉ'² Dios to² tsá² lagɨ wa' ngɨ́ɨ¹ camello coon²¹ too²¹ tya' moocuu². ");
INSERT INTO chqNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","'Áai¹ tsa'goo²¹o‑tsi tsá² tya'a mo ganúu²un 'elo. Joon gaunngɨɨ¹ɨ la 'oo'²¹ yaai: ―¿'Iin lí² tsataai² lɨ tyʉ'² Dios to² tsá²? ");
INSERT INTO chqNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Joon gajǿø²i Jesús 'ii joon gajin'²in: ―Jo lí² jmá¹a tsá² 'elo pe jilaa'²¹ lí² jmá¹a Dios. ");
INSERT INTO chqNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Joon gajin'² Tʉ́³ sɨɨ'²¹ɨ Jesús: ―Ña'ñʉ'¹ʉ', nigatʉʉ²¹oo'o 'e 'oo²¹o'o joon nigangɨ́²ɨ'ɨ coon'¹³ 'nʉ. ¿'Ee ilí² tyii'i? ");
INSERT INTO chqNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Joon gañii¹i Jesús: ―'E la ja'²mo fuu²¹²uu 'naa', mi li'múui² jilaa'²¹ 'e sá² joon 'in Ruu'²¹i Tsá² tyíin¹ lɨ sɨlɨɨ²¹² tya'a coon'¹³ jilaa'²¹ 'e 'ya'²gɨ tya'a joon 'naa' 'in nigangɨ́¹ coon'¹³ jna iní²ii' dyatun¹ lɨ sɨlɨɨ²¹² tyii'. Joon ityʉ́²ʉʉ' to² 'in dyatun¹ poo²¹² tsá² Israel. ");
INSERT INTO chqNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","La joon jon jileei'²¹ 'in nigatʉ́² 'nʉ́¹ sɨ nigatiui¹ ruu'²¹i tsañʉʉ'¹ sɨ ruu'²¹i tsamɨ́² 'ee sɨ nigatiui² sáa³ jmii²¹ 'ee sɨ tsamɨ́² tya'a sɨ jóon¹on 'ee sɨ nigatʉ́² 'wó² tya'a tsʉ 'wii'¹³ jna‑a; i'ii'²¹mo cíein¹³ lɨ́ɨ¹gɨ joon i'ii'²¹mo jon juncwii²¹ tya'a 'e taa'²¹a coon²¹ tøø²mo. ");
INSERT INTO chqNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Pe fúu¹mo tsá² 'in seein²¹ nano 'in lɨ́ɨ¹i nifu 'ii‑i lɨtséi¹ cɨɨin²¹gɨ. Joon fúu¹mo 'in lɨtséi¹ nano joon 'ii‑i nifu cɨɨin²¹gɨ ―jin'² Jesús sɨɨ'²¹ɨ 'in tsá² do. ");
INSERT INTO chqNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Faa'²¹gɨ Jesús jin'²in: ―'E tyʉ'² Dios to² lɨ la lɨ́ɨ¹i jaain²¹ ñi'fii²¹² tsá² lɨ náa¹ to². Joon mo 'aa²¹ tsáa¹a tsa'née¹i tsa'leei'¹³ tya' 'in cún² mi'³ wuunjøø'³ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Joon jin'²in xiiati tyí² la coon²¹ jmɨɨ²¹². Joon gasii¹in 'in tsá² do jee²¹² to² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Joon la 'iin² ñʉ́² gangó¹ lɨ lɨ' 'moo'¹³ joon gatsee'²¹i tsá² 'in jøøi². ");
INSERT INTO chqNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Joon gajin'²in: “¿Ja cwolíin²naa' cwojmaa²aa' to² tyiia joon icwóo³oo 'e tɨ́ɨ²naa'?” Joon gangalíin²mo 'in tsá² do. ");
INSERT INTO chqNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Joon mo gatɨ́² tyiiañi'¹ coon'¹³ la 'iin²¹ 'nɨ¹ ca 'loo¹ gangó¹o 'in ñi'¹ do lɨ lɨ' 'moo'¹³ do 'náa²i tsa'leei'¹³ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Joon la 'iin² 'ñá² ca'loo¹ gatsee'²¹i 'inlɨ́ɨi¹³ 'in jøøi², joon gajin'²in: “¿'Ee lɨ' née¹³naa' lo tøøi² jmɨɨ²¹² jo 'ee to² jmoo²oo'?” ");
INSERT INTO chqNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","'Ido‑gɨ gañii¹i: “Tsʉ jo 'iin²¹²mo galɨ́² 'neei²¹ jna'a 'e jmoo²¹o'o to².” Joon gajin'² in ñi'¹ do: “Cwolíin²naa' cwojmaa²aa' to² 'wó² tyiia joon icɨ́ɨ³ɨɨ 'lee'¹³naa' jiin'¹³ la gatɨ́ɨi².” ");
INSERT INTO chqNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Joon la xʉʉ jnaa² gatyʉ'² ñi'¹ do to² tsa'leei'¹³ tya'a 'in tyʉ'² to² gajin'²in: “Cwote²du' tsa'leei'¹³ do joon cwo'¹o 'leei'¹³, joon 'láa² 'wii²¹² cwo'¹o 'leei'¹³ 'in ngataai² lɨ tséi¹ do. Joon 'in ngataai² jee²¹² to² nifu cwo'¹o 'leei'¹³ lɨ gatséi¹.” ");
INSERT INTO chqNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Joon 'in ngataai² jee²¹² to² la 'iin² 'ñá² ca'loo¹ ga'ii'²¹mo 'lee'¹³i tya' la tøøi² jmɨɨ²¹². ");
INSERT INTO chqNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Joon mo ga'ii'²¹i 'in ngataai² nifu do 'lee'¹³i lɨ́ɨ²i i'ii'²¹ 'láai²gɨ 'lee'¹³i lagɨ 'in ngataai² ca'loo¹ do. Pe xʉ joon coon²¹ rǿø² ga'ii'²¹i 'lee'¹³i coon'¹³ 'ido. ");
INSERT INTO chqNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Joon mo ga'ii'²¹i 'e 'leei'¹³ do ga'láa² 'wii²¹² jo cwo'¹o júu³ ruu'²¹i coon'¹³ ñi'fii²¹²i do ");
INSERT INTO chqNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","jin'²in: “'In gacwolíin² lɨ tséi¹ rǿø² ga'ii'¹³na'a 'lee'¹³na'a coon'¹³ 'ido joongɨ coon²¹ hora gajmaa¹a 'ido to² joon jna'gɨɨ'ɨ tøøi² jmɨɨ²¹² taan²¹a'an jee²¹² 'yiia²¹.” ");
INSERT INTO chqNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Pe 'in tsá² fii²¹² do gañii¹i jin'²in sɨɨ'²¹ɨ jaain²¹ 'in tsá² do: “Tsaru'¹u', jo jmóo³oo 'e gó² tyi'naa'. ¿Tɨ jo gajmoo²¹o' júu³ xiiati 'e 'lée¹³'u tya' coon²¹ jmɨɨ²¹²? ");
INSERT INTO chqNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Con'²'on jiin'¹³ 'lée¹³'u 'e gatɨ́ɨ²u joon cweei'². Iin²¹²na cwo'³oo 'in ngataai² jee²¹² to² lɨ tséi¹ do jiin'¹³ la cwo'³oo 'nʉ. ");
INSERT INTO chqNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Lí²‑i tyʉ'³ʉʉ to² cúu³uu jiin'¹³ la 'iin²¹²na. ¿Tɨ ga'aa²¹²'a tsiiwúu¹ tsʉ tsá² tyú¹mo jna? ");
INSERT INTO chqNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","La joon lí¹, 'in lɨ tséi¹ 'ii 'in nifu, joon 'in nifu 'ii 'in lɨ tyéi¹. Tsʉ itø'²ø Dios fúui¹ tsá² pe xʉʉ 'in gacwai'² jmáa¹a.” ");
INSERT INTO chqNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Mo ngó¹ Jesús fu Jerusalén 'yúu²i fu¹ joon gajée¹i coon'²¹ jɨ dyatúuin² tsá² tya'a joon gajin'²in: ");
INSERT INTO chqNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Tyán²duu' cwáain¹. 'E ningalii²¹i' lo fu Jerusalén. Joon do‑o i'nɨ́i¹ tsá² 'in Ruui'²¹ Tsá² ja'cwoo²¹o 'in tyʉ'² to² untsá² coon'¹³ 'in tɨfo'² tya' ley. Joon ityʉ'² to² ijúun²in 'ido. ");
INSERT INTO chqNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Joon ijaan'¹³mo 'ido tya' tsá² jo seein²¹ Israel, joon iungøø¹ni'i 'ido, ipoo¹ni'i joongɨ itéen¹in tsaa'² crúu¹³. Pe mi tɨ jmɨɨ²¹² 'nɨ¹ ijiin'¹o tún¹ jee²¹² 'lɨɨ²¹². ");
INSERT INTO chqNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Joon gangatyéen¹in Jacobo jóon¹ Zebedeo coon'¹³ ruu'²¹i Wó³ coon'¹³ sáa³a fu lɨ siin'¹³ Jesús joon gaun'goo²¹o Jesús tsʉ sáa³ Jacobo coon'¹³ Wó³ gali'iin²¹²in mɨɨ¹ɨ jmɨɨ'aa²¹². ");
INSERT INTO chqNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Joon gaunngɨɨ¹ɨ Jesús 'ii: ―¿'E 'iin²¹²u'un jmáa³aa tyi'i? Joon sáa³ 'ido gajin'²in: ―Mi tyé¹u'u lɨ tyu'²'ʉ to² joon cwo'²'o cwá²a 'in yʉʉn²¹ tyiia gái² lo, jaain²¹ lɨ' cwoo¹'o tsáa¹ jaain²¹gɨ lɨ' cwoo¹'o tooin²¹². ");
INSERT INTO chqNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Pe Jesús gañii¹i: ―Jo ñí² 'naa' 'ee mɨ́²ɨɨ'. ¿Tɨ lí² taa²¹aa' moo²oo' wúu¹ la wúu¹ imóo³ jna? Joon, ¿tɨ lí² ijúun²naa' la ijúuin² jna? 'Ii‑gɨ gajin'²in: ―Lí²‑i. ");
INSERT INTO chqNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Joon gajin'² Jesús sɨɨ'²¹ɨ 'ii: ―Ja'²mo, imoo²oo' wúu¹ la wúu¹ imóo³ jna joon ijúun²naa' la ijúuin² jna pe jo tɨ́ɨ²na cwóo³oo ní²ii' jaan²¹naa' lɨ' cwóo³oo tsáa¹ jaain²¹gɨ lɨ' cwóo³oo tooin²¹². 'E joon 'e tya' tsá² 'in nigatyá¹a Ñʉ'³ʉʉ tyʉ́². ");
INSERT INTO chqNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Joon mo ganúu²un 'in dyéi¹ tsá² tya'a catyaai² do gatsá² 'nii'²¹‑tsi tya' 'in gái¹ ruu'²¹i do. ");
INSERT INTO chqNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Pe Jesús gatø'²ø 'ii gajin'²in: ―Jiin'¹³ la ñí² 'naa', 'in tsá² tyʉ'² to² juncwii²¹ tyʉ'²ʉ to² 'ii²¹, joon 'in tsá² 'in tyʉ'² to² 'in tyiin² jee²¹² 'in tyʉ'² to² do gøø'¹³gɨ to² tyʉ'²ʉ. ");
INSERT INTO chqNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Pe jo lí² la joon jee²¹² 'naa'. Tsʉ 'in 'iin²¹²in jmá¹ feei'¹gɨ jee²¹² 'naa', 'ii 'ná¹ unjíi²in 'in catyaai²gɨ. ");
INSERT INTO chqNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Joon 'in 'iin²¹²in líi²in nifu 'ná¹ jmá¹ la to² 'e tyʉ'² 'in catyaai²gɨ do. ");
INSERT INTO chqNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Tsʉ jna‑a, 'in Ruu'²¹na Tsá², jo gagoo²¹²oo 'e unjíi²in tsá² jna pe gagoo²¹²oo wa'a unjíi³na tsá². Gagoo²¹²oo 'e cwó³oo juncwii²¹ tyiia la wa' 'e 'laa'¹³ ilí² tiin'¹³ tsá² fúui¹. ");
INSERT INTO chqNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Joon mo gacwo'ɨ́ɨ¹ɨ Jesús fuu²¹ Jericó do fúu¹mo tsá² ngalíin² coon'¹³ Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Joon lɨ' caai²¹ fu¹ lɨ ngó¹o Jesús néei¹ gái¹ tsá² tiui². Joon mo galili'³i ingɨ́i¹ Jesús lɨ née¹i do joon ga'oo¹o jin'²in: ―¡Ña'ñʉ'¹ʉ', Jóon¹ 'lɨɨ²¹² David, fúu² cwolii¹u jna'a! ");
INSERT INTO chqNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","'In tsá² 'in ngalíin² do sɨɨ'²¹ɨ 'ido wa'a jo to'²o lɨ́ɨ¹ 'ido mɨɨ'¹³. Pe xʉ joon lɨ́¹ lɨ́ɨ¹gɨ tá² ga'oo¹o jin'²in: ―¡Ña'ñʉ'¹ʉ', Jóon¹ 'lɨɨ²¹² David, fúu² cwolii¹u jna'a! ");
INSERT INTO chqNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Joon Jesús gajaan¹an lɨ ngóo¹ joon gatø'²ø 'in tsá² tiui² do joon gaunngɨɨ¹ɨ: ―¿'Ee 'iin²¹²naa' ijmáa³aa tyii'? ");
INSERT INTO chqNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Joon gañii¹i 'ido: ―¡Ña'ñʉ'¹ʉ', 'e 'iin²¹²na'a jǿ²ø'ø! ");
INSERT INTO chqNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Joon fúu² galɨ́ɨ²i Jesús 'ii, joon ga'lii'²¹i unní¹ 'ido. Tsifu joon galɨ́¹ jǿø²ø 'in tsá² tiui² do joon ngalíin²mo coon'¹³ Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Joon mo xʉ 'ná¹gɨ tyía¹ Jesús fuu²¹ Jerusalén, joon gatyalíin² coon²¹ fuu²¹ sii²¹ Betfagé, fuu²¹ náa¹ caai²¹ moo'²¹ sii²¹ Olivos. ");
INSERT INTO chqNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Joon Jesús gatyʉ'²ʉ to² gái¹ tsá² tya'a jin'²in: ―Cwolíin²naa' 'e fuu²¹ pi'³ náa¹ tyani no. Joon do‑o ityee'¹³naa' jaain²¹ bu'³ 'yiia²¹² sɨ'ñúu¹i coon'¹³ yʉʉn²¹ tya'a. Joon sɨɨ'¹³ɨɨ' 'nii²¹² tya'a joon jøø²¹²naa' fu lo. ");
INSERT INTO chqNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Wa' 'in sɨɨ'²¹ɨ 'naa' cwáain¹ tya' bu'³ do joon fú²uu': “Ña'ñʉ'¹oo'o 'né¹ ni'i 'inlo joon nacun'un jajaa²¹²na'a.” ");
INSERT INTO chqNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Joon la lo galɨ́¹ 'e gatsín¹ júu³ gataan¹an ni mo'jí² jaain²¹ 'in gacwo¹o júu³ tya' Dios la mo jéei¹ 'e jin'²: ");
INSERT INTO chqNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Síi¹³ii' 'e fuu²¹ do sii²¹ Sión: “Jøø²øø', Rǿøi¹³ tyii' jó¹ lawa tsá² 'wói¹ tyíin¹in jaain²¹ bu'³, jaain²¹ bu'³ xuui²¹², 'in lɨ́ɨ¹i jóon¹on jaain²¹ joo'núu³ tyaan¹ laa²¹².” ");
INSERT INTO chqNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Joon 'in tsá² tya' Jesús do ngalíin²mo ngajmaa¹a la to² tyʉ'² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ngatee¹e bu'³ do joon gaunfuu¹u sɨɨn'¹³ɨn moo'wó¹o bu'³ do. Joon gacwó² Jesús 'in bu'³ do. ");
INSERT INTO chqNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Joon 'in tsá² fúui¹ do ganii'¹²i sɨɨn'¹³ɨn tya'i fu¹ lɨ ngó¹ Jesús. Joon 'inlɨ́ɨi¹³ gatyʉ'²ʉ nii²¹² moo²¹ joon gatyaa¹a tya'i fu¹. ");
INSERT INTO chqNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Joon 'in tsá² 'in ngalíin² nifu lagɨ 'in jalíin² lɨ' caluu 'oo¹o jin'²in: ―¡Cwoseein²¹ Jóon¹ 'lɨɨ²¹² rǿøi¹³ David wóo²! ¡In cwa'³mo 'i 'in jó¹ coon'¹³ 'e sii²¹ Ña'ñʉ'¹ʉ'! ¡Un'goo²¹oo' Dios! ");
INSERT INTO chqNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Joon mo ga'í² Jesús fuu²¹ Jerusalén joon ganáa¹ 'goo²¹ 'áai¹ joon fúu¹mo gaunngɨɨ¹ɨ gajin'²in: ―¿'Iin‑gɨ 'ino? ");
INSERT INTO chqNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Joon tsá² gañii¹i: ―Jaain²¹ tsá² 'in cwo¹ júu³ tya' Dios 'in sii²¹ Jesús 'ino. 'In jó¹ fuu²¹ Nazaret 'e náa¹ lɨ sii²¹ Galilea no. ");
INSERT INTO chqNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Mo ngayuui'¹³ joon ga'í² Jesús inʉʉ cwo'¹ fee'¹ tya' Dios sii'²¹ do. Joon ga'ǿø¹²mo jileei'²¹ 'in taai² do fu caluu. Lagɨ 'in taai² ló¹ do la joon jon 'in taai² 'nɨɨ¹ɨ ga'ǿø¹²mo. Gajiin²¹ Jesús mesa lɨ taa'¹³ cuu² tya' tsá² 'in unsɨɨ²¹ɨ cuu² tya' tsá². Gajiin²¹mo jon 'mosíi¹³ lɨ néei¹ 'in 'nɨɨ¹i maa²¹². ");
INSERT INTO chqNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Joon gajin'² Jesús sɨɨ'²¹ɨ 'ido: ―Ni jí² tya' Dios jin'²in: “'E 'nʉ́³ʉʉ lo iunsii²¹ tsá² coon²¹ lɨ faa'²¹a tsá² júu³ tyʉ́²”, pe 'naa' nigajmaa²aa' lo lawa coon²¹ too²¹ lɨ taai²¹² 'uun²¹. ");
INSERT INTO chqNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Joon tsi inʉʉ cwo'¹ do gangatyéen¹in 'inlɨ́ɨi¹³ tsá² tiui² coon'¹³ 'inlɨ́ɨi¹³ tsá² jluui'¹³ lɨ siin'²¹ Jesús joon gaun'láa²mo Jesús 'ido. ");
INSERT INTO chqNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Taai² jon inʉʉ cwo'¹ do 'inlɨ́ɨi¹³ xuui²¹² 'in ga'oo¹o gajin'²in: “¡Cwoseein²¹ Jóon¹ 'lɨɨ²¹² rǿøi¹³ David wóo²!” Joon mo ganí² 'in tsá² tyʉ'² to² tya' untsá² coon'¹³ 'in tɨfo'² tya' ley jilaa'²¹ milagro gajmaa¹a Jesús joon mo ganúu²un 'e 'oo¹o 'in xuui²¹² do gatsá² 'nii'²¹‑tsi. ");
INSERT INTO chqNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Joon gajin'²in gasɨɨ'²¹ɨ Jesús: ―¿Tɨ jo nuu²'un 'ee 'e jin'² 'in xuui²¹² no? Joon gañii¹i Jesús: ―Núu³oo. ¿Tɨ jo mo gauntsaa'¹³naa' 'ee 'e jin'² jí² tya' Dios cwáain¹ tya' 'elo? Jin'²o la no: 'E 'øø¹ø xuui²¹² coon'¹³ yʉʉn²¹ pi'³ iuntyúi¹ jna‑a joon. ");
INSERT INTO chqNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Joon gacwo'ɨ́ɨ¹o do, gatʉ́ʉ²mo 'in tsá² do joon gangó¹ coon²¹ fuu²¹ sii²¹ Betania. Joon do‑o gajaan¹an canʉ́ʉ¹. ");
INSERT INTO chqNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Mo gajná² joon gacɨɨ'¹³ɨ Jesús fu Jerusalén joon gatsá² un'aa²¹²i. ");
INSERT INTO chqNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Joon gango¹o si'² lɨ' caai²¹ fu¹ coon²¹ 'mó² cwaríi³. Joon gangatyéen¹in co' lɨ si'²i pe jo 'e gatsaa'²¹a jiin'¹³ coon²¹ 'oofuu²¹ tya'a. Jmaai'² mo'²o tsí². Joon Jesús gajin'²in sɨɨ'²¹ɨ 'e 'mó² cwaríi³ do: ―¡Jiin'¹³ coon²¹ naa'¹³ jo 'ee 'oofuu²¹ 'ɨ́ɨ¹gɨ 'nʉ! Joon tsifu joon lityʉʉn²¹ 'e 'mó² cwaríi³ do. ");
INSERT INTO chqNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Joon mo ganí¹i tsá² tya' Jesús 'elo ganga'goo²¹o‑tsi 'áai¹ joon gajin'²in: ―¡Laa'¹³ lɨɨlɨ́¹ jmoono galityʉʉn²¹ 'e 'mó² cwaríi³ no! ");
INSERT INTO chqNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Joon gajin'² Jesús: ―'E la ja'²mo fuu²¹²uu 'naa', wana jo'¹ lɨ́ɨ²naa' joon jo tóin¹ júu³ tyii' lɨ́ɨ¹gɨ lijmaa²aa' lagɨ jmaa²¹²aa tya' 'e 'mó² cwaríi³ no. Lí²‑i fú²uu' 'e moo'²¹ si'² do: “Jiin'¹³ lo, cwó², cwoté²u'u tsi jmɨ'ñi'³”, joon la joon ilí². ");
INSERT INTO chqNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Joon jilaa'²¹ imɨ́²ɨɨ' coon'¹³ júu³ tyʉ́² tyii' i'ii'¹³naa' wa jo'² lɨ́ɨ²naa'. ");
INSERT INTO chqNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Joon ga'í² Jesús inʉʉ cwo'¹ fee'¹ do joon la 'ɨɨ²¹² siin'²¹ 'e'²e tsá² joon gangatyéen¹in 'in tyʉ'² to² tya' untsá² coon'¹³ 'in tsacøøi'¹³ tya' tsá² Israel joon gaunngɨɨ¹ɨ: ―¿'Ee to² 'oo²'o 'e jmoo²'o la no? ¿'Iin gacwo¹o 'e to² no? ");
INSERT INTO chqNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Joon Jesús gañii¹i: ―Joongɨ iunngɨ́ɨ³duu 'naa' joon wana ñí²ii' la joon jon jna ifuu²¹²uu 'naa' 'iin gacwo¹o to² jmóo³oo. ");
INSERT INTO chqNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿'Iin gatyʉ'² to² saa¹i Wó³ tsá² jmɨɨ²¹? ¿Tɨ Dios 'e wa tsá² 'ee? Pe 'in tsá² jo cwo'¹o júu³ la 'oo'²¹ ruu'²¹i jin'²in: ―Wana fá²a' Dios gatyʉ'² to² 'in Wó³ do ijin'² 'ino: “¿'Ee lɨ' jo gajo'¹ galɨ́ɨ²naa' júu³ tya' 'ido?” ");
INSERT INTO chqNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Joon wana fá²a' 'e tsá²‑a gatyʉ'¹ to² Wó³ do ijme'¹mo tsá² jna' tsʉ jilee'²¹mo tsá² lɨ́ɨ²i 'e faa'²¹a Wó³ do cwáain¹ tya' Dios. ");
INSERT INTO chqNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Tsʉ 'wii'¹³ joon gasɨɨ'²¹ɨ 'in tsá² do Jesús jin'²in: ―Jo né² jna'a. Joon gajin'²in Jesús: ―La² joon jon jna jo fuu²¹²uu 'naa' 'in gacwo'¹o jna to² 'e 'óo³oo. ");
INSERT INTO chqNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Joon Jesús gasɨɨ'²¹ɨ 'in tsá² do jin'²in: ―¿'Ee 'ɨ¹‑'oo'? Galiseein²¹ jaain²¹ tsá² 'in seein²¹ gái¹ jóon¹on. Joon gajin'²in sɨɨ'²¹ɨ 'in jaain²¹ do: “Yʉʉn²¹ tyi', cwoo²'o cwocun'²'un mɨ'³ wuunjøø'³ tyiia no.” ");
INSERT INTO chqNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Joon 'in jóon¹ do gañii¹i: “Jo níi³ jna.” Pe mo li cɨɨn²¹gɨxʉ gajoo'²¹o‑tsi joon gango¹‑o, ngajmaa²¹a to². ");
INSERT INTO chqNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Joon gangó¹o jmii²¹ do ngajǿø²ø 'in jaain²¹ dogɨ. Joon la do‑o gajin'²in. Joon 'in jaain²¹ do gajin'²in: “Tyʉ́²‑ʉ, ñʉ'³, níi³oo.” Pe jo gangóo¹o. ¿'Ee 'ɨ¹‑'oo'? ");
INSERT INTO chqNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿'Iin jee²¹² 'in gái¹ do gajmaa¹a la 'iin²¹²in jmii²¹ do? Joon gañii¹i 'in tsá² do: ―'In nifu do‑o. Joon gajin'²in Jesús: ―'E la ja'²mo fuu²¹²uu 'naa', 'in tsá² 'in cón² 'laa'¹³ 'e 'nɨɨ¹ɨ tsá² coon'¹³ 'in 'yiiatsangó¹ itsataa²i lɨ tyʉ'² Dios to² jéei¹gɨ lagɨ 'naa'. ");
INSERT INTO chqNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Tsʉ Wó³ saai¹ tsá² jmɨɨ²¹ gajó² gajma'¹ 'naa' júu³ xiiala 'ná¹ taan²¹²naa' joon jo gajo'¹ galɨ́ɨ²naa'. Pe 'in tsá² 'in cón² 'laa'¹³ 'e 'nɨɨ¹ɨ tsá² coon'¹³ 'in 'yiiatsangó¹ jo'¹o galɨ́ɨ²i. Pe 'naa' fiin'¹³ gañí²oo' 'elo jo gajoo'²¹‑'oo' wa' jai'² lɨ́ɨ²naa' ―jin'² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","―Nʉ́ʉ²duu' coon²¹gɨ júu³ ―gajin'² Jesús― lawa jaain²¹ tsá² fii²¹² 'wó² 'in gajñi¹i wuunjøø'³ jee²¹² 'wó² tya'a joon gajmaa'¹³a coon²¹ 'yá² la caain²¹ tɨ' tyiia²¹ tya'a. Joon gajmaa'¹³a coon²¹ lɨ niui² mɨ'³ wuunjøø'³ do. Gajmaa'¹³o jon coon²¹ po' ñíi¹ i'á¹a 'wó² do. ’Mo ngayuui'¹³ joon gacwo'¹o tsá² iní² do. Joon gangóo¹o coon²¹ cwoo'¹³ lɨ wíin². ");
INSERT INTO chqNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Joon mo gatɨ́² liroo²¹ mɨ'³ wuunjøø'³ do 'in fii²¹² 'wó² do gasii²¹in jaain²¹ gaí¹ tsa'leei'¹³ tya'a wa tsatyíin²an 'e tyáa¹ 'e gatɨ́ɨ²i 'e garoo²¹ 'wó² do. ");
INSERT INTO chqNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pe 'in tsá² taain²¹² ní² do gasan'²mo 'in tsa'leei'¹³ 'in gatyalíin² do, jaain²¹ gapoo²¹i, jaain²¹gɨ gajngaa'¹³mo, joon gatyuu'¹³i cuun²¹² 'in jaain²¹gɨ do. ");
INSERT INTO chqNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","'In fii²¹² 'wó² do gasiin²¹gɨ tsa'leei'¹³ tya'a fúui¹gɨ pe la do‑o tún¹ gajmaa¹a 'in ní² 'wó² do. ");
INSERT INTO chqNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Joon lɨ gatséi¹ gasii²¹in jóon¹on ga'ɨ¹‑tsi: “Fowa ili'gɨɨ'²¹mo yʉʉn²¹ tyiia”, lɨ́ɨ²i. ");
INSERT INTO chqNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Pe mo gangaa¹i jóon² 'in tsá² fii²¹² 'wó² do 'in gatyí¹a do gasɨ́ɨ²i la 'oo'²¹ 'ii: “'Ino‑o 'in lí² tya'a 'e 'wó² no, joon wa jngaa'¹²mo' 'ino joon ilí² tyi' 'e 'wó² no.” ");
INSERT INTO chqNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","La joon gasaan'²¹mo 'ido, joon gapii²in lɨ' co' 'yá² do joon gajngaa'¹²mo. ");
INSERT INTO chqNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Joon gaunngɨɨ¹ɨ Jesús 'in tsá² teein²¹ co' lɨ siin'¹²in do jin'²in: ―Mi tyía¹ 'in fii²¹² 'wó² do, ¿'ee ijmáa¹a tya' 'in tsá² taain²¹² 'wó² tya'a do lɨ́ɨ²naa'? ");
INSERT INTO chqNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Joon gañii¹i 'in tsá² do: ―Ijngaa'¹²mo 'in tsá² gó² do jo 'ee fúu² lɨ́ɨi²gɨ 'ido. Joon icwo'¹o tsá² xee'²¹mo 'e 'wó² do joon 'in tsá² do ityáa¹ cwoo²¹o 'in fii²¹² 'wó² do itɨ́ɨ²i 'e garoo²¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Joon gajin'² Jesús sɨɨ'²¹ɨ 'in tsá² do: 'Naa' niganʉʉ²ʉʉn' júu³ tya' Dios 'e jin'²in: 'E cuun²¹² 'e gadya'²a 'in tsá² jmoo'¹³o 'nʉ́¹ lɨ' caai²¹ lawa jo 'ee²¹² to² 'íi³. 'E cuun²¹² joon galɨ́¹ cuun²¹² nifu. Gajmaa¹a Ña'ñʉ'¹ʉ' 'elo. Joon ganga'goo²¹‑tsi tsá² 'áai¹ 'in ganí² 'elo. ");
INSERT INTO chqNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Wii'¹³ joon fuu²¹²uu 'naa', jo ityʉ'²gɨ Dios to² 'naa' joon ityʉ'² to² tsá² xeei'²¹ 'in lí² jmá¹a jiin'¹³ la to² tyʉ'²ʉ do. ");
INSERT INTO chqNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Joon cwáain¹ tya' 'e cuun²¹² nifu do, doñi'iin 'in cɨɨi'² ni cuun²¹² do ilitʉʉ'¹³ 'ii coonti joon wana 'iin gatsiin¹in 'e cuun²¹² do joon lí² fu² 'ii coonti. ");
INSERT INTO chqNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Joon mo ganúu²un 'in tsá² tyʉ'² to² tya' untsá² coon'¹³ 'in tsá² fariseos do 'e júu³ cwáain¹ gatyaa¹ Jesús do galili'³o 'e faa'²¹a 'wii'¹³ tya' 'ii‑o. ");
INSERT INTO chqNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Gali'iin²¹²in 'e teen'¹³mo 'ido pe gøø'²¹mo tsá² tsʉ 'in tsá² do 'ɨ¹‑tsi 'e Jesús do faa'²¹a cwáain¹ tya' Dios. ");
INSERT INTO chqNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Joon ga'láa² Jesús 'wii²¹² 'e tyaa¹ jmai'² júu³ cwáain¹ tya' 'in tsá² do gajin'²in: ");
INSERT INTO chqNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―'E tyʉ'² Dios to² tsá² lɨ la lɨ mo gajmaa¹a jaain²¹ rǿøi¹³ jmɨɨ²¹² mo gacui'² cwoo²¹ jóon¹on. ");
INSERT INTO chqNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","'In rǿøi¹³ do gasii²¹in tsa'leei'¹³ tya'a wa'a tsate'²e 'in tsá² nigatø'²ø itsalíin² jmɨɨ²¹² do. Pe 'in tsá² nigatø'²ø do jo 'iin²¹²in tsalíin². ");
INSERT INTO chqNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Joon gasii²¹in 'in xeei'²¹gɨ tún¹ tsa'leei'¹³ tya'a joon gasɨɨ'²¹ɨ 'ido: “Cwosii'¹³duu' 'in tsá² nigatø'²ø do, niná¹ tyʉ́² 'uunñi² tyiia no. Nigajúin¹ joo'tsáa² coon'¹³ 'in catyaai² 'in 'ooin'¹³. Joon jilaa'²¹ niná¹ tyʉ́² tya'a jin'²in fu'²u. Cwolíin²moo' lɨ ná¹ jmɨɨ²¹² do.” ");
INSERT INTO chqNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Pe 'in tsá² do jo gaunjíi²i tún¹. Jaain²¹ jee²¹² 'in tsá² jo gangalíin² lɨ ná¹ jmɨɨ²¹² do gangó¹o ngajǿø²ø 'wó² tya'a. Jaain²¹gɨ gangó¹o nga'nɨɨ¹xʉ 'e 'oo¹o. ");
INSERT INTO chqNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","'Inlɨ́ɨi¹³gɨ gajmee'²¹mo 'in tsa'leei'¹³ tya' rǿøi'³ 'in gangate'² 'ii ce gajngaa'¹²mo 'ido. ");
INSERT INTO chqNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Joon 'in rǿøi¹³ do gatɨ́² 'nii'²¹‑tsi joon gatyʉ'²ʉ to² 'láa² tya'a wa tsalíin² tsajngaa'¹²mo 'in tsá² do 'in gajngaai'¹² tsa'leei'¹³ tya'a joon i'úi¹ jɨ́² goo¹o 'ido. ");
INSERT INTO chqNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Mo ngayuui'¹³ joon 'in rǿøi¹³ do gasɨɨ'²¹ɨ tsa'leei'¹³ tya'a jin'²in: “Jilaa'²¹ niná¹ tyʉ́² tya' icwui'² cwoo²¹ xuui²¹² tyiia pe jo tɨ́ɨ²i jalíin² 'in nigatǿø²øø' do. ");
INSERT INTO chqNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Cwolíin²naa' jon fu la caain²¹ tyʉʉ'¹³ jee²¹² 'nʉ́¹ joon tǿ²øø' doñi'iin tsá² 'in máa¹³naa' ijalíin² li tɨ́² jmɨɨ²¹² lo.” ");
INSERT INTO chqNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Joon ngalíin²mo 'in tsa'leei'¹³ do jee²¹² 'nʉ́¹ do joon galicaain²¹ jileei'²¹ tsá² 'in gatsee'²¹i 'in tyúi¹ coon'¹³ 'in gó². Joon coon'¹³ la joon garǿi¹ inʉʉ tya' 'in rǿøi¹³ do. ");
INSERT INTO chqNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Joon 'in rǿøi¹³ do ga'í² inʉʉ lɨ nataai²¹² 'in tsá² gatø'²ø do. Joon gangaa¹i jaain²¹ tsañʉʉ'¹ 'in jo tyi'² 'mɨ'² 'a la tyi'² tsá² 'in taai²¹² lɨ cui'² cwoo²¹ tsá². ");
INSERT INTO chqNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Joon gajin'²in sɨɨ'²¹ɨ 'ido: “Tsaru'¹u', ¿'ee lɨ jo tyii'¹³'i 'mɨ'² 'e la tyi'² 'in catyaai² no?” Joon 'in tsá² do gajaan¹an tii². ");
INSERT INTO chqNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Joon 'in rǿøi¹³ do gatyʉ'² to² tsa'leei'¹³ tya'a jin'²in: “Cwo'nʉʉ²ʉʉ' cwoo²¹ tɨɨ² 'ino joon cwopíin¹naa' fu caluu lɨ nʉʉ²¹.” Do‑o ityi'²i tsá² joon icuu'²¹i moojóon¹on. ");
INSERT INTO chqNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Tsʉ itø'²ø Dios fúu¹mo tsá² pe xʉʉ 'in cwai'³ jee²¹² do‑o jmáa¹a. ");
INSERT INTO chqNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Joon 'in tsá² fariseos gasɨɨ²¹i la 'oo'²¹ yaai xiiala lí² 'nɨ́ɨ²i Jesús coon'¹³ júu³ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","To² joon gasii²¹in tsá² fariseos 'inlɨ́ɨi¹³ tsá² tya'a caan²¹mo coon'¹³ 'inlɨ́ɨi¹³ tsá² tya' Herodes 'e sɨɨ'²¹ɨ Jesús, joon gajin'²in: ―Tɨfo'², né³oo'o 'e fo'²'o jmai'² 'e la jai'². Joon 'e'²'e tsá² fu¹ tya' Dios la jai'² jo 'ee unjii²'i jilaa'²¹ 'e faa'²¹a tsá². Tsʉ jo jmoo²'o 'ii'²¹ jiin'¹³ la 'ɨ¹‑tsi tsá². ");
INSERT INTO chqNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Sii'¹³ jna'a, ¿tɨ² tyʉ́² wa tyí² tsá² cuu² tya' 'in tsaa'to² tyíin¹ Roma 'owa jo tyí² tsá² 'ee? ");
INSERT INTO chqNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Pe Jesús ñi¹o 'ee 'e gó² 'ɨ¹‑tsi 'in tsá² do joon gajin'²in: ―Tsá² 'in sɨsɨ́ɨ²i 'e 'ɨ¹‑tsi 'e jmoo¹o 'naa'. ¿'Ee lɨ' 'iin²¹²naa' tøø'¹³naa' jna nilá²? ");
INSERT INTO chqNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","'Ee'¹³duu' jna coon²¹ cuu² 'e cɨ́²ɨɨ' tya' rǿøi¹³ do. Joon gacwo'¹o coon²¹ cuu² yʉʉn²¹. ");
INSERT INTO chqNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Mo ganí²i Jesús 'e cuu² do gaunngɨɨ¹ɨ: ―¿'Iin ni² 'e toon¹on ni cuu² lo? Joon, ¿'iingɨ coon'¹³ 'e toon¹on 'e sii²¹ ni cuu² lo? ");
INSERT INTO chqNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Joon 'in tsá² do gañii¹i: ―Ni² 'in tyʉ'² to² do‑o no. Joon gajin'² Jesús: ―Cwoo²oo' jon 'in tyʉ'² to² Roma jiin'¹³ 'e gatɨ́ɨ²i, la joon jon cwoo²oo' jon Dios 'e gatɨ́ɨ²i. ");
INSERT INTO chqNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Joon mo ganúu²un 'in tsá² do júu³ tya' Jesús do ganga'goo²¹‑tsi. Gatiu²mo 'ido 'ii jon gangaliin¹mo. ");
INSERT INTO chqNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Jmɨɨ²¹² joon gangalíin² 'inlɨ́ɨi¹³ tsá² saduceos, 'in jin'² 'e jo jiin'¹in tsá² jee²¹² 'lɨɨ²¹², ngaunngɨɨ¹ɨ Jesús 'e júu³ lo: ");
INSERT INTO chqNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Tɨfo'², Moisés gatyʉ'²ʉ to² jna' wana gajúin¹ tsá² mo nasɨcui'² cwoo²¹o joon jo xuui²¹² tya'a liseein²¹ ná¹ cu'²mo cwoo²¹ 'in ruui'²¹ 'in 'lɨɨ²¹² nijúin¹ do 'in 'yiia'nɨ́ɨ². Joon iliseein²¹ xuui²¹² tya' 'in ruu'²¹i najúin¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Joon galiseein²¹ dyái¹ tsañʉʉ'¹ la 'oo'²¹ ruu'²¹i. Joon 'in nifu do gacu'²mo cwoo²¹o joon gajúun¹mo joon jo xuui²¹² tya'a galiseein²¹. Joon 'in ruu'²¹i lɨ gatɨ́² gái¹ do gacu'²mo cwoo²¹o jon coon'¹³ 'in 'yiia'nɨ́ɨ² do. ");
INSERT INTO chqNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","La galɨ́¹ tya' 'in nifu do la joon galɨ́¹ tya' 'in gatɨ́² gái¹ do. La joon tya' 'in gatɨ́² gaai²¹ jon. La joon galɨ́¹ tya' jɨ dyáa¹i do. ");
INSERT INTO chqNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Joon mo gangɨ́ɨ²i joon, joon gajún¹mo jon 'in tsamɨ́² do. ");
INSERT INTO chqNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Joon mi jiin'¹in tsá² jee²¹² 'lɨɨ²¹², ¿'iin jee²¹² 'in dyái¹ tsaruu'²¹i do ilíi²in nʉʉ'¹ tya' 'in tsamɨ́² do tsʉ jilee'²¹mo do gacu'²mo cwoo²¹o coon'¹³? ");
INSERT INTO chqNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Joon gañii¹i Jesús: ―Lɨ' cɨɨ'¹²ɨ 'ɨ¹‑'oo' 'naa' tsʉ jo ñí²ii' 'ee jin'² júu³ tya'a Dios jon'gɨ ñí²ii' 'ii'²¹ tya' Dios. ");
INSERT INTO chqNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Tsʉ mi jiin'¹in 'lɨɨ²¹² jo cui'²gɨ cwoo²¹o tsañʉʉ'¹ jon'gɨ tsamɨ́². Ilíi²in lawa ángeles tya' Dios 'in taai²¹² ñʉ'fú². ");
INSERT INTO chqNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Pe cwáain¹ tya' 'e jiin'¹in tsá², ¿tɨ jo mo gauntsáa¹³ 'naa' xiiala nigajin'² Dios 'ña'a? La joon gajin'²in: ");
INSERT INTO chqNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Jna‑a Dios tya' Abraham, joongɨ tya' Isaac, joongɨ tya' Jacob.” 'In Dios Jmii²¹ do jon' Dios tya' 'in nijuin¹, Dios tya' tsá² jiin'¹ 'ii. ");
INSERT INTO chqNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","'Áai¹ ganga'goo²¹‑tsi 'in tsá² fúui¹ taai² do mo ganúu²un júu³ ga'ee¹ Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Joon mo galiñi¹ tsá² fariseos 'e Jesús nigalɨ'¹o tsá² saduceos do joon gauncaain²¹ yaai 'in tsá² fariseos lɨ siin'²¹ Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Joon 'e 'iin²¹²in wa iliñii¹ 'ee 'ɨ¹‑tsi Jesús joon jaain²¹ tɨfo'² tya' ley jee²¹² 'ii gaunngɨɨ¹ɨ Jesús jin'²in: ");
INSERT INTO chqNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Tɨfo'², ¿'ee júu³ 'e ga'ɨ́ɨ²ɨ 'lɨɨ²¹² Moisés to² tyʉ'² Dios 'e tyiin²gɨ? ");
INSERT INTO chqNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Joon Jesús gajin'²in: ―Cwoli'iin²¹²mo'o Dios tyi'i jiin'¹³ la'a 'e seen²¹un, joon jiin'¹³ la'a 'e 'ɨ¹‑'o'o. Jo 'iin²¹²gɨ'ɨ jiin'¹³xʉ fee'¹gɨ lagɨ 'iin²¹²u'un Dios tyi'i. ");
INSERT INTO chqNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","'E loo¹ 'e júu³ 'e tyiin²gɨ nifu la jee²¹² jilaa'²¹. ");
INSERT INTO chqNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Joon la joon lɨ júu³ lɨ gatɨ́² tún² 'e jin'²: “Cwoli'iin²¹²mo'o jileei'²¹ tsaruu'²¹'u lawa 'wo'o.” ");
INSERT INTO chqNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Tsʉ 'e júu³ tún² lo 'e tyʉ'² to² tya' jilaa'²¹ júu³ 'e catyiia² tya' Moisés coon'¹³ jilaa'²¹ 'e ga'e¹ 'in tsá² gacwoo²¹o júu³ tya' Dios la mo jéei¹. ");
INSERT INTO chqNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","La jee²¹² téen²mogɨ tsá² fariseos coon'¹³ Jesús ");
INSERT INTO chqNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","joon gaunngɨɨ¹ɨ Jesús 'ii: ―¿'Ee 'ɨ¹‑'oo' cwáain¹ tya' Cristo? ¿'Iin‑gɨ jóon¹ no? 'Ido‑gɨ gañii¹i: ―Jóon¹ David 'ino. ");
INSERT INTO chqNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Joon gajin'² Jesús gasɨɨ'²¹ɨ 'ii: ―Wa'a la joon, ¿'ee lɨ' gaunsii²¹in David Ña'ñʉ'¹ʉ' coon'¹³ 'ii'²¹ tya' Espíritu Tyʉ́² tya' Dios? Tsʉ David do gajin'²in: ");
INSERT INTO chqNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Ña'ñʉ'¹ʉ' Dios Jmii²¹ jin'²in sɨɨ'²¹ɨ Ña'ñʉ'¹ʉ' tyiia: “Ní² lɨ' cwóo³oo tsáa¹ ca mi tyée¹³na 'in 'eei'¹ 'nʉ 'wii²¹² tɨ́ɨ¹³'ɨ.” ");
INSERT INTO chqNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Wana gajin'² 'in David do “Ña'ñʉ'¹ʉ'” mo nagafaa'²¹a cwáain¹ tya' Cristo, ¿xiiala 'e lí² 'e líi²in jóon¹ David 'in Cristo no? ");
INSERT INTO chqNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Joon jiin'¹³ jaain²¹ jo galɨ'²ɨ gañii¹i jiin'¹³xʉ. Joon ca jmɨɨ²¹² joon lɨ ngó¹gɨ jo gata'²gɨ tsá² wa'a 'e unngɨɨ¹gɨ Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Joon gajin'² Jesús sɨɨ'²¹ɨ 'in tsá² fúui¹ téein² do coon'¹³ tsá² tya'a: ");
INSERT INTO chqNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―'In tɨfo'² tya' ley coon'¹³ 'in tsá² fariseos née¹i 'áan³ tya' Moisés. ");
INSERT INTO chqNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Joon 'naa' jmaa²aa' nʉ́ʉ¹³ʉʉ' ce jilaa'²¹ 'e jin'²in pe jo jmaa²aa' la jmoo¹o tsʉ jo jmoo¹o jiin'¹³ la jin'²in. ");
INSERT INTO chqNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Tsʉ coon'¹³ jilaa'²¹ 'e jin'²in 'e lɨ la lɨ coon²¹ laa²¹² 'e 'ii²¹ 'áai¹ ce jiin'¹³ jaain²¹ jo lí² roon'²¹, joon 'ii tyʉ'²ʉ to² cón² tsá² 'e laa²¹² do pe 'ii‑gɨ jo 'ee uncoon'¹³on jiin'¹³xʉ. ");
INSERT INTO chqNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","'Yʉ to² jmoo¹o jilaa'²¹ 'e jǿø² tsá². Tɨ́²‑tsi 'in tsá² do ngɨɨ¹ɨ sɨ'ñʉ́ʉ¹³ tuloo²¹ pi'³ 'e taa'¹³ mo'jí² 'e toon²¹² júu³ tya' Dios tya'tyí¹. Sɨ'ñʉ́ʉ¹³ jon 'e tuloo²¹ pi'³ do cwáa¹a. Pe 'in tsá² do coo'¹³gɨ tuloo²¹ pi'³ tya'a lagɨ 'in catyaai² do. Joongɨ tɨ́²‑tsi jmoo¹o cwaa²¹ po'³ ñi¹ sɨ'ɨ́ɨ¹³ 'ée² sɨɨn'¹³ɨn. ");
INSERT INTO chqNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Joon 'iin²¹²in 'in tsá² do cwá²a jmai'² lɨ tyʉ́²‑ʉ mo née¹i gøø'²¹ø coon'¹³ tsá². 'Iin²¹²in jon cwá¹a ni 'mosíi¹ 'e tyiin² nifú² 'e sá² inʉʉ cwo'¹ sinagoga. ");
INSERT INTO chqNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","'Iin²¹²in 'e fee'²¹ tsá² 'ii coon'tun mo jiin'¹ tsá² 'ii jee²¹² 'nʉ́¹, 'e sɨɨ'²¹ tsá² 'ii: “Rabbi”, 'e 'øøi'²¹‑tsi tsá², tɨfo'² tyi' ―jin'² Jesús sɨɨ'²¹ɨ tsá² fúui¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Joon faa'²¹gɨ Jesús jin'²in sɨɨ'²¹ɨ tsá² tya'a: ―'Naa' jo cweei¹ sɨɨ'²¹ tsá² 'naa': “Tɨfo'² tyi'”, tsʉ 'naa' lɨ́ɨ¹naa' tsaruui'²¹ tsá² joon jaan²¹mo tɨfo'² tyii' seein²¹ jiin'¹³ Cristo. ");
INSERT INTO chqNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Joon jo fú²uu' jiin'¹³ jaain²¹: “Ñʉ'¹ʉ'”, ni cwoo'¹³ juncwii²¹ tsʉ jaan²¹mo Jmii²¹ tsá² seein²¹ 'in tyíin¹ ñʉ'fú². ");
INSERT INTO chqNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Jo cweei¹ sɨɨ'²¹ tsá² 'naa': “Ñi'fii²¹i'”, tsʉ jiin'¹³ Cristo lɨ́ɨ¹i fii²¹² tsá². ");
INSERT INTO chqNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Tsʉ jee²¹² 'naa' 'in unjíi²in 'in catyaai²gɨ, 'ii 'in feei'¹gɨ. ");
INSERT INTO chqNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Tsʉ jileei'²¹ 'in jmoo¹o cøøi'¹³gɨ yaai 'ii 'in pi'³gɨ tyani Ña'ñʉ'¹ʉ' pe 'in jmoo¹o pi'³gɨ yaai 'ii 'in cøøi'¹³gɨ ―jin'² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Joon gajǿø²ø Jesús lɨ téein² tɨfo'² tya' ley coon'¹³ tsá² fariseos joon gajin'²in: ―¡Fúu² 'naa', tɨfo'² tya' ley coon'¹³ 'naa' tsá² fariseos, tsá² 'in sɨsɨ́ɨ²i 'e 'ɨ¹‑tsi la jmoo¹ 'naa'!, tsʉ jnɨɨ'¹³moo' wa tsataai²¹² tsá² lɨ tyʉ'² Dios to² tsá². Pe tyíin³ 'naa' jo cwotáan²naa' lɨ tyʉ'² Dios to² jon'gɨ cwoo²oo' tsataai²¹² 'in catyaai²gɨ 'in 'iin²¹²in tsataai². ");
INSERT INTO chqNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’¡Fúu² 'naa', tɨfo'² tya' ley coon'¹³ 'naa' tsá² fariseos, tsá² 'in sɨsɨ́ɨ²i 'e 'ɨ¹‑tsi la jmoo¹ 'naa'! Tsʉ 'woo'¹³naa' 'nʉ́¹ 'yiia'nɨ́ɨ² joongɨ fó²oo' júu³ tyʉ́² 'e cwaa²¹ lɨ́ɨ¹ wa iun'goo²¹ tsá² 'naa'. Tsʉ 'wii'¹³ joon imoo²oo' wúu¹ 'áai¹gɨ. ");
INSERT INTO chqNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’¡Fúu² 'naa', tɨfo'² tya' ley coon'¹³ 'naa' tsá² fariseos, tsá² 'in sɨsɨ́ɨ²i 'ɨ¹‑tsi la 'e jmoo¹ 'naa'! Tsʉ 'naa' cwolíin²naa' 'naa'²¹naa' xʉfiin'¹³ jaain²¹ tsá² 'in lí² nuu¹un júu³ tyʉ́² tyii' 'e xiiala un'goo²¹ 'naa' Dios tyii'. Cwolíin²naa' la caain²¹ ni cwoo'¹³ juncwii²¹ 'naa'²¹naa' 'in tsá² do, joon mi tyeei¹ 'naa' jaain²¹ 'in nuu¹un júu³ tyii' jmée¹³naa' 'in tsá² do tún² 'ii'¹³gɨ lɨ́ɨ¹i jóon¹ 'in 'lɨɨi'³ lagɨ 'naa'. ");
INSERT INTO chqNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’¡Fúu² 'naa', tsá² 'in coon'²¹ tóo² yaanaa'!, 'naa' fó²oo': “Wa 'ɨɨ¹ɨ tsá² júu³ 'ée¹ tsá² cwo'¹ fee'¹ si' Jerusalén jo 'ee to² 'íi³in 'e júu³ joon fó²oo' 'naa'. Pe wana 'ɨɨ¹ɨ tsá² júu³ 'ée¹ tsá² cwanáa¹ 'e sá² inʉʉ cwo'¹ do 'e joon 'ná¹ untsín¹ tsá² júu³ do fó²oo' 'naa'.” ");
INSERT INTO chqNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Tsá² bón¹ 'naa' joongɨ tiuu² 'naa'! ¿'Ee 'e tyiin²gɨ: 'e cwanáa¹ do owa 'e cwo'¹ 'e si'² jmoo¹o cwaai'³ 'e cwanáa¹ do? ");
INSERT INTO chqNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Joongɨ fó²oo' 'naa': “Wa 'ɨɨ¹ɨ tsá² júu³ 'ée¹ tsá² altar, jo tséin¹ 'e júu³ joon, pe wana 'ɨɨ¹ɨ tsá² júu³ 'ée¹ tsá² 'e roon¹on ni altar do 'e joon 'ná¹ untsín² tsá² 'e júu³ do.” ");
INSERT INTO chqNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Tsá² bón¹ 'naa' joongɨ tiuu² 'naa'! ¿'Ee 'e tyiin²gɨ: owa 'e roon¹on ni altar do owa 'ña'a altar do 'ee 'e jmoo¹o licwaai'³ 'e roon¹on ni do? ");
INSERT INTO chqNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Tsʉ jileei'²¹ 'in 'e¹ altar do 'e¹o jon jilaa'²¹ 'e ná¹a ni do. ");
INSERT INTO chqNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","La joon jon 'in 'e¹ cwo'¹ do 'ée¹mo jon Dios Jmii²¹ 'in tyíin¹ ñʉ'fú², 'in jmoo¹o cwaai'³ 'e cwo'¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Joon jileei'²¹ 'in 'e¹ ñʉ'fú² 'ee¹o jon lɨ sɨlɨɨ²¹² tya' Dios 'ée¹mo jon Dios 'in tyíin¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’¡Fúu² 'naa', tɨfo'² tya' ley joon 'naa' tsá² fariseos! ¡Tsá² 'in sɨsɨ́ɨ²i 'e 'ɨ¹‑tsi 'e jmoo¹o 'naa'! Cwó² 'naa' Dios ca'ii'¹³ jee²¹² dyá² 'ii'¹³ tya' jilaa'²¹ 'oo² tya' 'uunñi² pe jo coon²oon' cwáain¹ 'e júu³ 'e tyiin²gɨ lagɨ 'e jmaa²aa' 'ii'²¹ røø²¹, joon lagɨ jmaa²aa' feei'¹‑'oo' tya' tsá², lagɨ 'e tsáai¹‑'oo' Dios. 'Ná¹‑a jmaa²aa' jilaa'²¹ 'elo joon jo 'iin²‑'oo' jmaa²aa' 'e catyiia² do. ");
INSERT INTO chqNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Tsá² 'in coon'²¹ tóo² yaamo 'naa'! ¡Tyíi¹³ 'naa' lu¹ mo 'yuu²i 'e 'uu²uu' pe jo lí²ii' 'nɨɨ'¹³naa' jaain²¹ camello! ");
INSERT INTO chqNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’¡Fúu² 'naa', tɨfo'² tya' ley coon'¹³ 'naa' tsá² fariseos! ¡Tsá² 'in sɨsɨ́ɨ²i 'e 'ɨ¹‑tsi 'e jmoo¹o 'naa'! 'Naa' rúun¹³uun' 'naa' tyʉ́² lɨ' caluu vaso coon'¹³ jilaa'²¹ wúun¹ 'e jmaa'¹³naa' to² pe coon'¹³ jilaa'²¹ 'e niga'uun²¹²uun' sɨ rǿø²mo tsi do. Sɨrǿø²mo jon jiin'¹³ coon'¹³ 'e 'yaa¹‑'oo'. ");
INSERT INTO chqNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Tsá² tiui² 'naa', tsá² fariseo: 'Ná¹ rúu¹³naa' vasos coon'¹³ wúun¹ tyii' lɨ tsi nifu, joon coon'¹³ la joon ilityʉ́²‑u lɨ' caluu jon. ");
INSERT INTO chqNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’¡Fúu² 'naa', tɨfo'² tya' ley coon'¹³ 'naa' tsá² fariseos! ¡Tsá² 'in sɨsɨ́ɨ²i 'e 'ɨ¹‑tsi 'e jmoo¹o 'naa'! Lɨ́ɨ¹naa' la lɨ 'nʉ́¹ pi'³ lɨ sɨ'aai²¹² 'lɨɨ²¹² 'e gasuun¹ tsá² loo²¹² jnéei¹ taa²¹ 'ya'²gɨ pe lɨ tsi jmai'² moo¹ tya' 'lɨɨ²¹² taa'¹³ tsi. ");
INSERT INTO chqNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","La joon jon 'naa' tyʉ́²‑ʉ jnée¹naa' lɨ caluu jǿø²i tsá² 'naa' pe lɨ' tsi alma tyii' sɨrǿøi² tóo² 'e coon²oon' tsá² coon'¹³ jilaa'²¹ nii²¹² 'e gó². ");
INSERT INTO chqNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’¡Fúu² 'naa', tɨfo'² tya' ley coon'¹³ 'naa' tsá² fariseos! ¡Tsá² 'in sɨsɨ́ɨ²i 'e 'ɨ¹‑tsi 'e jmoo¹o 'naa'! Jmaa²aa' 'nʉ́¹ pi'³ tya' tsá² 'in najúin¹, 'in gacwó² júu³ Dios la mo jéei¹, joon jmaa²aa' 'ya'²gɨ lɨ sɨ'aai²¹² 'in tsá² tyúi¹. ");
INSERT INTO chqNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Joon fó²oo' 'naa': “Wa mo'o ni'i sáan²a'an mo nigaliseein²¹ 'lɨɨ²¹² tsacøøi'¹³ tyii'i jo gajngaa'¹³na'a 'in tsá² 'in gacwó² júu³ tya' Dios la nigajngaai'¹² tsacøøi'¹³ tyii'i.” ");
INSERT INTO chqNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Joon coon'¹³ la joon jmóo'¹³naa' júu³ 'e lɨ́ɨ¹naa' jún² tya' 'in tsá² 'in nigajngaai'¹² 'in tsá² 'in nigacwó² júu³ tya' Dios la mo jéei¹. ");
INSERT INTO chqNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Untséin¹naa' jiin'¹³ la niga'láa² tsacøøi'¹³ tyii' 'wii²¹² jmaa¹a! ");
INSERT INTO chqNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’Jóon¹ mɨɨ'²¹ 'lɨɨ'³mo 'naa'. Coonti jo ilaa²¹naa' 'e wúu¹ ní² tsá² lɨ 'ii²¹. ");
INSERT INTO chqNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Tsʉ 'wii'¹³ joon isɨ́ɨ³na tsá² 'in cwo'¹ 'naa' júu³ tyʉ́² tyiia coon'¹³ tsá² jmɨɨ²¹²‑tsi coon'¹³ tɨfo'² 'in 'e'² 'naa' júu³ tyʉ́² tyiia. Pe 'naa' ijngaa'¹³naa' 'inlɨ́ɨi¹³ joon 'inlɨ́ɨi¹³gɨ taa¹³naa' tsaa'² crúu¹³. Joon 'inlɨ́ɨi¹³gɨ ipoo²¹²naa' inʉʉ cwo'¹ sinagogas tyii', icwolíin²naa' cwo'øø²¹naa' la coon²¹ fuu²¹ lɨ tsalíin² 'ido. ");
INSERT INTO chqNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Coon'¹³ la joon ilí² tsaa² tyii' tya' jilaa'²¹ jmɨ¹ 'e nigatuun²¹un tya' 'in tsá² tyúi¹ 'in nigajngaai'¹² tsá². Ilí² tsaa² tyii' tya' jileei'²¹ 'in najúin¹ joon 'láa² 'wii²¹² coon'¹³ Abel, 'in tsá² tyúi¹ 'in gajngaa'¹²i nifu, ca Zacarías, jóon¹ Berequías, 'in gajngaai'¹² tsá² Israel tyani cwo'¹ lɨ si'² altar. ");
INSERT INTO chqNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","'E la ja'²mo fuu²¹²uu 'naa', jilaa'²¹ 'elo ilí² tsaa² tya' 'in tsá² seein²¹ nano. Joon gajin'²in Jesús: ");
INSERT INTO chqNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","―¡'Áai¹ xuui²¹²‑tsii tyii' tsá² seein²¹ Jerusalén! Tsʉ nigajngaa'¹²naa' 'in tsá² cwó² júu³ tyʉ́² tya' Dios la mo jéei¹ joongɨ nigatyuu'¹³naa' cuun²¹² 'in tsá² 'in gasii²¹in Dios tyan¹ júu³ tya'a. ¡'Áai gali'iin²¹²na ilicaan²¹naa' coon'¹³ jna 'láai² naa'¹³ la uncaain²¹ tui'yiia²¹² jóon¹on nʉ' cwáa¹a pe jo gali'iin²¹²naa'! ");
INSERT INTO chqNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Pe nano nigatʉ́ʉ² Dios fuu²¹ goo²oo' joon lí² jmaa²aa' jiin'¹³ la 'iin²¹²naa'. ");
INSERT INTO chqNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Tsʉ fuu²¹²uu 'naa' jo máai¹³gɨɨ' jna no ca mi fó²oo': “Nicwaa'³mo 'in nijó¹ no coon'¹³ 'e sii²¹ Ña'ñʉ'¹ʉ'.” ");
INSERT INTO chqNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Joon gacwo'ɨ́ɨ¹ɨ Jesús 'e cwo'¹ fee'¹ do joon lɨ nangaa'¹³i 'yuui fu¹ gangatyéen¹in tsá² tya' lɨ ngóo¹o joon ga'láa² tsá² tya'a 'wii²¹² jin'²in xiiala 'ya'²gɨ 'e cwo'¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Pe Jesús gañii¹i jin'²in: ―Jøø²øø' jilaa'²¹ 'elo. 'E la ja'²mo fuu²¹²uu 'naa', Ce jiin'¹³ coon²¹ cuun²¹² wa' iján²an sɨfúui¹gɨ do, i'iin²mo tsá² coonti. ");
INSERT INTO chqNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Joon gangalíin²mo fu moo'²¹ sii²¹ Olivos. Joon do‑o gacwó² Jesús joon tsá² tya'a la 'oo'²¹ yaai gatyalíin² lɨ tyíin¹ Jesús joon gajin'²in: ―'Ii²¹²i'i fu'²'u jna'a lɨ́ɨ¹³gɨ ilí² jilaa'²¹ 'elo. ¿'Ee li² ilisá² 'e line²e'e mi ñí²'i joongɨ mi tɨ́² i'iin² juncwii²¹? ");
INSERT INTO chqNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Joon gajin'² Jesús sɨɨ'²¹ɨ tsá² tya'a: ―Jo cwoo²oo' wa'a coon'²¹ tsá² 'naa' tóo². ");
INSERT INTO chqNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Tsʉ fúu¹mo 'in jalíin² coon'¹³ 'e sii²¹ jna ijin'²in: “Jna‑a Cristo joon, Dios gasii¹in jna 'e jmáa³aa tiin'¹³naa'.” Joon icoon'²¹ 'in tsá² do tóo² tsá² fúui¹ 'áai¹. ");
INSERT INTO chqNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Imoo²oo' ico'² tsá² 'nii²¹ joon, inʉʉ²ʉʉn' 'e faa'²¹a tsá² tya' 'nii²¹ pe jo foo'¹³naa' tsʉ jilaa'²¹ 'elo 'ná¹ ilí², pe jo mo tɨ́²gɨ lɨ tyéi¹ mi lí² 'elo. ");
INSERT INTO chqNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Tsʉ coon²¹ nación intíin¹in coon'¹³ coon²¹ nación xiia'²¹, la joon jon fuu²¹ intíin¹in coon'¹³ fuu²¹ xiia'²¹. Joon la caain²¹ lí² 'í² 'oo², joongɨ lí² 'í² jmoowúu¹ joon injøø'²¹ 'wó² 'áai¹. ");
INSERT INTO chqNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Pe coon'¹³ la joon i'láa² 'wiin²¹² wúu¹ iní² tsá². ");
INSERT INTO chqNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Joon ijaain'²¹ tsá² 'naa' tyani tsaa'to² ijmee'²¹i 'naa' joon ijngaa'¹²mo 'inlɨ́ɨi¹³. Joon ili'eei'¹ jileei'²¹ tsá² taain²¹ juncwii²¹ 'naa' 'wii'¹³ cwáain¹ tyiajna. ");
INSERT INTO chqNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Joon mi ngɨ́ɨ¹ joon fúu¹mo tsá² 'in tiu²mo jna joon ili'eei'¹ tsaruu'²¹i, i'nɨ́ɨ¹i la jaain²¹ la jaain²¹. ");
INSERT INTO chqNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Fúu¹mo tsá² tajuui²¹ ijalíin² jin'²in 'e faa'²¹a cwáain¹ tya' Dios joon icoon'²¹ tsá² tóo² fúui¹ 'áai¹. ");
INSERT INTO chqNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Joon jo 'ee li'iin²¹²gɨ tsaruu'²¹i la jaain²¹ la jaain²¹ tsʉ 'áai¹gɨ ilisá² jilaa'²¹ 'e gó². ");
INSERT INTO chqNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pe jileei'²¹ 'in jmá¹a taa'²¹ ca lɨ tyéi¹ itiin'¹³mo 'i. ");
INSERT INTO chqNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Joon ingɨ́¹ tsá² la caain²¹ juncwii²¹ icwó²o júu³ tyʉ́² tya' xiiala ityʉ'² Dios to² tsá² 'e iliñí² jileei'²¹ tsá². Joon mi yuui'¹³ joon ityé¹mo. ");
INSERT INTO chqNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Joon mi moo²oo' siin'¹² lɨ jo tɨ́ɨ²i siin'¹³in 'in un'lɨɨ'³, siin'¹³in lɨ cwaai'³ jiin'¹³ lagɨ jin'²in 'in tsá² Dañiel do 'in gacwó² júu³ tya' Dios la mo jéei¹ ―cwo'øøi'²¹‑tsi 'in nuu¹un 'e júu³ lo―, ");
INSERT INTO chqNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","jileei'²¹ 'naa' tsá² seein²¹ Judea 'ná¹ cwiin²iin' fu moo'²¹. ");
INSERT INTO chqNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Joon mi tɨ́² jmɨɨ²¹² joon wa téein¹ tsá² yʉ'ʉ 'nʉ́ʉ¹ʉ jo¹ litiin¹ tsataai²¹² tsá² inʉʉ tya'a 'e wó¹o tsá² 'e sá² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Joon 'in jmoo¹o to² jee²¹² tyiia²¹ jo litiin¹ tsatyiian¹ sɨɨn'¹³ɨn. ");
INSERT INTO chqNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Fúu² 'in tsamɨ́² tyéen¹in yʉʉn²¹ mi tɨ́² jmɨɨ²¹² joon! ¡Fúu² jon 'in tsamɨ́² 'in nijéei¹ yʉʉn²¹ cuu'²¹ tuu'²¹! ");
INSERT INTO chqNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mɨ́ɨ¹³ɨɨ' tyani Dios wa jo tsatiin'¹³ cwiin²iin' mi tɨ́² jiin²¹ cwíi² sɨ jmɨɨ²¹² 'ii'²¹ woo'²¹ tsá² 'ee. ");
INSERT INTO chqNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Tsʉ ilisá² goon²¹ wúu¹ iní²i tsá² 'e 'gøøi'¹³gɨ 'áai¹ lagɨ nilisá² la jéei¹, 'gøøi'¹³gɨ 'áai¹ jon lagɨ ilisá² mi li cɨɨin²gɨ. ");
INSERT INTO chqNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Joon wana jo tyuu'¹³i Dios 'e ní² tsá² wúu¹ do jiin'¹³ jaain²¹ jo taa'²¹ 'e wúu¹ ní² tsá² do ilí² itiin'¹³in. Pe tsʉ 'wii'¹³ 'iin²¹²mo Dios 'in nigatyii'¹³in ityuu'¹³mo 'e wúu¹ iní² tsá² do. ");
INSERT INTO chqNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Tsʉ 'wii'¹³ joon wana sɨɨ'²¹ɨ tsá² 'naa' jin'²in: “Jøø²øø', no siin'²¹ Cristo, 'in gasii¹in Dios 'e jmaa¹a tiin'¹³ tsá²” sɨ jin'²in 'ee: “Jøø²øø', do‑o siin'²¹in”, jo jai'² cwolíi²naa'. ");
INSERT INTO chqNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Tsʉ iliseein²¹ tsá² 'in lɨ́ɨ¹i la lɨ́ɨ¹i Cristo pe jo jo'¹, iliseein²¹ jon tsá² ijin'²in 'e lɨ́ɨ¹i tsá² 'in cwó² júu³ tya' Dios pe jo jo'¹. Joon 'in tsá² do ijmáa¹a li² 'e coo'¹³ 'áai¹ joon coon'¹³ milagros tya'a icoon'²¹ tsá² tóo². Ca 'in nigatyii'¹³in Dios 'iin²¹²in coon'²¹ tóo² wu xʉ'ʉ lii'¹i. ");
INSERT INTO chqNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Nigajmaa'¹³oo 'naa' júu³ jéei¹gɨ ");
INSERT INTO chqNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","tsʉ 'wii'¹³ joon wa sɨɨ'²¹ɨ tsá² 'naa': “Do‑o taain² lɨ' cwoo'¹³ tyʉʉn²¹ lɨ jo 'in tsá² néei¹”, jo cwolíin²naa' do, sɨ wa jin'²in tsá² sɨɨ'²¹ɨ 'naa' 'ee; “lo tyíin¹ 'in cristo do tsi inʉʉ”, jo jai'² cwolíin²naa'. ");
INSERT INTO chqNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Tsʉ mi cwéi¹na 'e lɨ la lɨ coon²¹ jí² cwaain'ñá³ 'e jná² joo'²¹ ca tɨ' lɨ 'yeei²¹ ñi'¹ joongɨ ca tɨ' lɨ yooi'¹³ ñi'¹. La joon ilí² mi cwéei²na 'in Ruui'²¹ Tsá². ");
INSERT INTO chqNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Lɨ raain¹ 'lɨɨ²¹² do‑o sɨcaain²¹ tuu'¹ ―jin'² Jesús. Faa'²¹gɨ Jesús jin'²in: ");
INSERT INTO chqNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","―Joon tsifu mi ngɨɨi¹ 'e jmɨɨ²¹² 'e ní² tsá² wúu¹ do i'ɨɨ¹ɨ nʉʉ²¹ lɨ 'ii²¹ ñi'¹ joon jo 'yiia²¹ sɨɨ'²¹ sá²gɨ. Ixuu'²¹mo nʉ́ʉ¹ fu ñʉ'fú² joon jilaa'²¹ 'e sá² tya'cwii²¹ ilisɨ́ɨ²i. ");
INSERT INTO chqNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Joon iní² tsá² yʉ' juncwii²¹ li² 'e tɨ lí² jó¹ 'in Ruui'²¹ Tsá². Joon jileei'²¹ tsá² taain²¹² juncwii²¹ ityi'²i xuui²¹²‑tsi joon iní²mo jna, 'in Ruui'²¹ Tsá², goo²¹²oo jee²¹² jníi¹ tya'cwii²¹ joon fee'¹ 'ii'²¹ i'óo³oo joon 'ya'²gɨ 'áai¹ ijnée²na. ");
INSERT INTO chqNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Joon mi 'íin²in lúu¹ tá² lɨɨlɨ¹ ityʉ'³ʉʉ to² ángeles tyiia 'e tsauncaain²¹ jileei'²¹ 'in gatiin'¹³in, 'in néei¹ la caain²¹ ni cwoo'¹³ juncwii²¹. ");
INSERT INTO chqNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Tyaan²aan' cwáain¹ 'e júu³ jmoo¹o 'mó² cwaríi³: Mo 'yeei'²¹ 'nii²¹² sii'²¹ tya'a joon nii'¹³ mo'³ tya'a joon ñii²¹oo'²¹ 'e tɨ li tɨ́² jiin²¹ 'yiia²¹. ");
INSERT INTO chqNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Coon'¹³ la joon jon mi moo²oo' ngɨ́ɨ¹ jilaa'²¹ 'e gafuu²¹²uu 'naa' lí² iñí²ii' la joon 'e tɨ lɨ tyé¹mo juncwii²¹. ");
INSERT INTO chqNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","'E la ja'²mo fuu²¹²uu 'naa', Jilaa'²¹ 'elo ilí² la jéei¹gɨ ijúuin² 'in tsá² taain²¹² nicwoo'¹³ juncwii²¹. ");
INSERT INTO chqNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Iyuun'¹³mo yʉ' juncwii²¹ coon'¹³ ni'wó² pe jiin'¹³ coon²¹ júu³ tyiia wa jo tsatiin'¹³ ilí². ");
INSERT INTO chqNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Pe jo 'in ñí² jiin'¹³ jaain²¹ 'ee 'ii'²¹ sɨ 'ee jmɨɨ²¹² 'ee ijó¹ 'ido. 'In ángeles néei¹ ñʉ'fú² jo ñii¹i, jon'gɨ ñi¹ jon 'in Ruui'²¹ Tsá² do. Jiin'¹³ 'ña'a Dios Jmii²¹ ñii¹i. ");
INSERT INTO chqNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’La gajmaa¹a tsá² mo galiseein²¹ Noé la joon jon ilí² mi jó¹ 'in Ruui'²¹ Tsá². ");
INSERT INTO chqNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Mo galiseein²¹ Noé la nʉ'gɨ ijó¹ jmɨ́¹ 'in tsá² seein²¹ yiia'¹³ joon²¹ taain²¹² 'uun'²¹, gøø'²¹ø, joon cui'²cwoo²¹o joon cuu'¹³mo cwoo²¹o jóon¹on jon ca jmɨɨ²¹² mo ngataai² Noé coon'¹³ familia tya'a tsi arca do. ");
INSERT INTO chqNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Jo gaunjíi²in 'in tsá² do ca mo gangó¹ jmɨ́¹ 'áai¹ joon nigajúun¹mo jilee'²¹mo. ");
INSERT INTO chqNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Joon mi jó¹ 'in Ruui'²¹ Tsá², gái¹ 'in taain²¹² jee²¹² tyiia²¹ joon jaan²¹mo 'in tøø¹ø joon 'in jaain²¹ do injaan²¹o do‑o. ");
INSERT INTO chqNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Joon gái¹ tsamɨ́² 'in taai² tsí¹, joon jaan²¹mo 'in tøø¹ø jaain²¹gɨ 'in ján². ");
INSERT INTO chqNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Cwoseen²¹naa' tsá² 'in ñii²¹²‑tsi tsʉ jo ñí² 'naa' 'ee 'ii'²¹ ijó¹ Ña'ñʉ'¹ʉ'. ");
INSERT INTO chqNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Tsʉ ñí² 'naa' wana niliñí² jaain²¹ fii²¹² 'nʉ́¹ 'ee 'ii'²¹ ijó¹ jaain²¹ 'uun²¹ mo 'woo¹ li'²o jmoo¹o jo cwó¹ tsataai² 'in 'uun²¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Tsʉ 'wii'¹³ joon 'ná¹ niná¹ tyʉ́² tyii' tsʉ mo jo 'in 'ɨ¹‑tsi ijó¹ Ruui'²¹ Tsá² coon²¹ 'in cwéei¹ la no‑o ―jin'² Jesús. Faa'²¹gɨ Jesús jin'²in: ");
INSERT INTO chqNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","―Wa tyʉ'² jaain²¹ ñi'fii²¹² to² jaain²¹ tsa'leei'¹³ tya'a 'e cwo'¹o 'in catyaai² do 'í¹ 'e dø'²ø mi tɨ 'ii'²¹ 'e dø'² tsá², ¿'ee ijmoo¹o jaain²¹ tsa'leei'¹³ 'in tyúi¹ joon 'in 'øøi'²¹‑tsi? ");
INSERT INTO chqNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Jløø'³mo 'in tsa'leei'¹³ do wa tyee'¹i ñi'fii²¹²i nigajmaa¹a jiin'¹³ la to² nigatyʉ'²ʉ 'ido. ");
INSERT INTO chqNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","'E la ja'²mo fuu²¹²uu 'naa', 'in ñi'fii²¹² do icwo'¹ 'in tsa'leei'¹³ tyúi¹ do 'e tyʉ'² to² jilaa'²¹ 'e 'oo¹o. ");
INSERT INTO chqNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pe wana 'in tsa'leei'¹³ do 'in gó² 'ii joon in'ɨ¹‑tsi 'e ili'ɨɨ²¹²mogɨ ñi'fii²¹²i ");
INSERT INTO chqNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","joon i'láa² 'wii²¹² jmee'²¹mo 'in catyaai² do joon 'in 'uun'²¹un dø'¹ø coon'¹³ tsá² 'íin¹. ");
INSERT INTO chqNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Pe xʉ coon²¹ jmɨɨ²¹² mo jo gajéen¹ ni 'in ñi'fii²¹²i do, jmɨɨ²¹² joon gacwée¹mo 'ido. ");
INSERT INTO chqNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Joon i'e'²e 'ido 'ii wúu¹ 'áai¹gɨ. Ipíi²in 'in ñi'fii²¹² do 'ii lɨ taai²¹² 'in sɨsɨ́ɨ²i 'e 'ɨ¹‑tsi 'e jmoo¹o. Joon do‑o ityi'²o lixuui²¹²‑tsi 'áai¹ joon icuu'²¹i moojóon¹on ―jin'² Jesús sɨɨ'²¹ɨ tsá² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Faa'²¹gɨ Jesús jin'²in: ―Joon 'e tyʉ'² Dios to² tsá² lɨ la lɨ́ɨi¹ dyéi¹ sɨmɨ́² 'in ngalíin² lɨ cui'² cwoo²¹o tsá². Joon la jaain²¹ 'in sɨmɨ́² do tyaan¹an jmaai'² coon²¹ candi'³ lɨ sɨ'o² aceite 'e coo²¹. Itsalíin² tsajéen¹in 'in tsá² cui'² cwoo²¹o do. ");
INSERT INTO chqNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Pe 'ñéei² 'in sɨmɨ́² do jo tsáa¹‑tsi pe 'in 'ñéei² do ñíi²mo‑tsi 'áai¹. ");
INSERT INTO chqNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","'In 'ñéei² 'in jo tsáa¹‑tsi do tyaan¹an candi'³ tya'a pe jo 'e aceite nityaan¹gɨ lɨ́ɨ². ");
INSERT INTO chqNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","'In 'ñéei² do ñíi²gɨ‑tsi 'áai¹ tyaan¹an candi'³ tya'a joon tyaan¹gɨxʉ aceite 'e lɨ́ɨ¹gɨxʉ. ");
INSERT INTO chqNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Pe gali'ɨɨ²¹²mo 'in tsá² cui'² cwoo²¹o do joon gatsá² jalicwúu²i jilee'²¹mo. Joon gacwúu²mota. ");
INSERT INTO chqNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Joon mo gatɨ́² tyiianúu¹ joon ganúu²un ga'oo¹o tsá² jin'²in: “'Woo²¹naa', cwounjiin'¹naa' tsʉ no‑o ni jalíin² 'in tsá² 'in cui'² cwoo²¹o do.” ");
INSERT INTO chqNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Joon garoon¹o jileei'²¹ do gatyaa¹ tyʉ́² candi'³ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Joon 'in 'ñéei² 'in jo tsáa¹‑tsi jin'²in sɨɨ'²¹ɨ 'in catyaai² do: “Láa¹³ 'guu¹u candi'³ tyii'i, cwó²xʉʉ' aceite tyii' 'ná²a'a.” ");
INSERT INTO chqNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Pe 'e catyaai² do gañii¹i jin'²in: “'Esa lí² tsʉ jo líin² 'elo tyijna'a. Cwolíin²naa' lɨ 'nɨɨ¹ɨ, joon ló²xʉʉ' 'e tyii'.” ");
INSERT INTO chqNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Pe la 'ɨɨ²¹² ngalíin² ngalá¹ aceite tya'a do gatyalíin² 'in tsá² 'in cui'² cwoo²¹o do. Joon 'in sɨmɨ́² 'in naná¹ tyʉ́² tya'a gangatáa²i inʉʉ coon'¹³ 'in tsá² 'in cui'² cwoo²¹o do. Joon gajnii¹o 'ooca'nʉ́¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Mi yuui'¹³ joon gatyalíin² 'in sɨmɨ́² catyaai² do gajin'²in: “¡'Náa¹ 'ooca'nʉ́¹ lo tsataai²¹² fu tsi!” ");
INSERT INTO chqNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Pe 'in tsá² 'in cui'² cwoo²¹o gañii¹i: “'E la ja'²mo fuu²¹²uu 'naa' jo cwíi³na 'naa'.” ");
INSERT INTO chqNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Joon gajin'² Jesús sɨɨ'²¹ɨ 'in tsá² do: ―Cwoseen²¹naa' ñí²‑'oo' tsʉ jo ñí²ii' 'ee jmɨɨ²¹² sɨ 'ee 'ii'²¹ 'ee mi jó¹ 'in Ruui'²¹ Tsá². ");
INSERT INTO chqNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’'E tyʉ'² Dios to² tsá² 'e lɨ la lɨ́ɨi¹ jaain²¹ tsá² 'e tɨ lɨ cwo'ɨ́ɨ¹ fuu²¹ goo¹o joon gatø'²ø tsa'leei'¹³ tya'a gacwo'¹o cuu². ");
INSERT INTO chqNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’Jaain²¹ gacwo'¹o 'ná² mil cuu² joon 'in jaain²¹ dogɨ gacwo'¹o tún² mil. 'In lɨ gatɨ́² gaai²¹ do gacwo'¹o coon²¹ mil cuu². Gacwo'¹o la jaain²¹ jiin'¹³ la lí¹ lii'¹i 'ido jmaa¹a to². Mo ngayuui'¹³ joon ngoo²¹o 'in tsá² fii²¹² cuu² do lɨ wíin². ");
INSERT INTO chqNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Joon 'in tsa'leei'¹³ do 'in ga'ii'²¹ 'ñá² mil cuu² galó¹ 'e 'nɨɨ¹ɨ coon'¹³ cuu² do joon gauntsi¹ 'ñá² mil tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","La joon jon 'in ga'ii'²¹ tún² mil cuu² do gauntsi¹ jon tún² mil. ");
INSERT INTO chqNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pe 'in ga'ii'²¹ coon²¹ mil cuu² do joon gangóo¹on gangataan'¹an nʉ' 'wó² 'edo. ");
INSERT INTO chqNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Wóo²xʉ ningó¹ mo gatyei'² fii²¹² cuu² do. Joon gajmaa'¹³a cwáain¹ coon'¹³ 'in tsá² 'in cwo'¹o cuu² do. ");
INSERT INTO chqNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Nifu gatyía¹ 'in gacwo'¹o 'ñá² mil cuu² do joon gajon'²on 'ido 'e 'ñá² mil 'e gauntsi¹ 'ido. Joon gajin'²in sɨɨ'²¹ɨ fii²¹²i: “Ñi'fí²i', gacwoo¹³'o jna 'ñá² mil cuu² joon saan'¹³'an 'ñá² mil‑gɨ 'e galɨ'²ɨ gauntsi¹.” ");
INSERT INTO chqNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Joon fii²¹² do gajin'²in: “Tyʉ́²‑ʉ, jaain²¹ tsa'leei'¹³ 'in tyú¹mo 'nʉ, jo cu'²‑tsii coon'¹³ 'nʉ. Joon tsʉ 'wii'¹³ gajmaa²'a røø²¹ coon'¹³ 'e xʉ gacwo'³oo 'nʉ icwo'³oo 'nʉ lɨ́ɨ¹gɨ. Ngɨɨi²¹² fu lɨ tyíin¹³na joon jmaa²'a jløø'³u coon'¹³ jna.” ");
INSERT INTO chqNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Mo ngayuui'¹³ joon gatyía¹ 'in tsa'leei'¹³ lɨ gatɨ́² gái² 'in ga'ii'²¹ tún² mil cuu² joon gajin'²in sɨɨ'²¹ɨ fii²¹² do: “Ñi'fí²i', gacwoo¹³'o jna tún² mil cuu² joon saan'¹³'an tún² mil‑gɨ 'e galɨ'²ɨ gauntsi¹.” ");
INSERT INTO chqNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ñi'fii²¹² gajin'²in sɨɨ'²¹ɨ 'ido: “Tyʉ́²‑ʉ, jaain²¹ tsa'leei'¹³ 'in tyú¹mo 'nʉ, jo cu'²‑tsii coon'¹³ 'nʉ. Joon tsʉ 'wii'¹³ gajmaa²'a røø²¹ coon'¹³ 'e xʉ gacwo'³oo 'nʉ icwo'³oo 'nʉ lɨ́ɨ¹gɨ. Ngɨɨi²¹² lɨ tyíin¹³na joon jmaa²'a jløø'³u coon'¹³ jna.” ");
INSERT INTO chqNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Pe mo gatyía¹ 'in ga'ii'²¹ coon²¹ mil cuu² do. Joon gajin'²in sɨɨ'²¹ɨ ñi'fii²¹²i: “Ñi'fii²¹²i', ñí²oo 'e jaain²¹ tsá² 'wa'²‑tsi 'nʉ. Wuu²'u cwuu²¹ lɨ jo gajñi²'i joongɨ coon²'on lɨ jo 'ee to² gajmaa²'a. ");
INSERT INTO chqNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Tsʉ 'wii'¹³ joon gafoo'¹³moo joon gato'¹oo 'e cuu² do nʉ' 'wó². Lo náa¹ 'e gatɨ́ɨ²u.” ");
INSERT INTO chqNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Joon gañii¹i 'in ñi'fii²¹² do gajin'²in: “Tsa'leei'¹³ 'in gó² 'nʉ, fu'²mo 'nʉ. Nañí²o'o 'e wúu³na cwuu²¹ lɨ jo gajñíi³ii joon cóon¹³oon lɨ jo 'ee to² gajmáa³aa. ");
INSERT INTO chqNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Tsʉ 'wii'¹³ joon wa mo gata'²a cuu² lɨ cwáain² tsi¹ joon lisá² lɨ́ɨ¹gɨ tyiia.” ");
INSERT INTO chqNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Joon gajin'²in fii²¹² cuu² sɨɨ'²¹ɨ 'in tsá² téein² do: “Tyi² 'e coon²¹ mil cuu² do joon cwo'²oo' 'in 'oo¹o dyá² mil do. ");
INSERT INTO chqNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Tsʉ 'in 'oo¹o 'láai²gɨ iñíi²i ca sái¹ tya'a, pe 'iin 'in jo 'e 'oo¹o 'e 'woo¹gɨ 'e xʉ 'e 'oo¹o do. ");
INSERT INTO chqNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Joon 'in tsa'leei'¹³ 'in jo 'e to² 'íin³ píi²naa' fu caluu lɨ nʉʉ²¹ joon do‑o ityi'²i 'áai¹ joongɨ icuu'²¹i moojóon¹on”, jin'² rǿøi¹³ do ―jin'² Jesús. Faa'²¹gɨ Jesús jin'²in: ");
INSERT INTO chqNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","―Joon mi jó¹ 'in Ruui'²¹ Tsá² ijó¹ lawa Rǿøi¹ tyíin¹ lɨ sɨlɨɨ²¹² 'ya'²gɨ 'áai¹ joon la cu'² lɨ' lɨ tyíin¹in do inéei¹ ángeles tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Joon jileei'²¹ tsá² taain²¹² juncwii²¹ ilicaain²¹ tyaníi¹i. Joon 'in Rǿøi¹³ do injmáa¹a tún² poo²¹² 'in tsá² do. Injmáa¹a la jmoo¹o tsá² 'in 'aa¹i joo'saa'²¹, ijmáa¹a coon'²¹ 'in joo'saa'²¹ coon'¹³ 'in joo'²¹ chivo ");
INSERT INTO chqNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","joon isiin'¹³in 'in joo'saa'²¹ do lɨ' caai²¹ tsáa¹ joon 'in joo'²¹ chivo do‑gɨ isiin'¹³in lɨ' caai²¹ tooi²¹². ");
INSERT INTO chqNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Joon 'in Rǿøi¹³ Tsá² do ijin'²in sɨɨ'²¹ɨ 'in téein² lɨ' cwoo²¹o tsáa¹ do: “Ñilíin²naa' jileei'²¹ 'naa' 'in nigauncwaai'³ Ñʉ'³ʉʉ. Ngɨɨ²¹²naa' lɨ tyʉ'² Dios to² lɨ naná¹ tyʉ́² tyi'naa' ca mo garón² juncwii²¹. ");
INSERT INTO chqNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Tsʉ mo gatsá² un'áa³na, 'naa' gacwoo²oo' jna 'e gagø'¹øø, la joon jon mo gatsá² unjmɨɨ²¹na, 'naa'a jon gacwoo²oo' jna 'e gagu'¹uu. Joon mo gangɨ́³ɨɨ 'e jo cwíi²naa' jna gatee²oo' jna inʉʉ tyii'. ");
INSERT INTO chqNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Joon mo gangɨ́³ɨɨ jo sɨn'³ɨɨn sá² gacwó²oo' jna. Joon mo galitsaa'¹³aa gañifee'¹³moo' jna. Joon mo 'ú³uu 'nʉñí³ ñijøø²¹²moo' jna jon.” ");
INSERT INTO chqNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Joon 'in tsá² tyúi¹ 'in téein² lɨ' cwoo²¹o Rǿøi¹³ do tsáa¹ ijin'²in: “Ña'ñʉ'¹ʉ', ¿lɨɨgɨ ganee²¹²na'a 'nʉ 'e un'aa²u'u joon gacwóo¹³o'o 'nʉ 'e gatyee'²'e? Joon, ¿lɨɨgɨ ganee²¹²na'a 'nʉ 'e unjmɨɨ²¹u'un 'e gacwóo¹³o'o 'nʉ 'e ga'iin'²'in? ");
INSERT INTO chqNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","La joon jon, ¿lɨɨgɨ ganee²¹²na'a 'nʉ 'e jo cwii¹na'a 'nʉ joon gatee²e'e 'nʉ fu tyii'i sɨ jo sɨɨn'²¹'ɨn 'oo²'o 'ee joon gacwóo¹³o'o 'nʉ sɨɨn'²¹'ɨn? ");
INSERT INTO chqNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Lɨɨgɨ jon nigalitsaa'¹³ 'nʉ sɨ ni'u'²u 'nʉñí³ 'ee 'e ningafee'¹³na'a 'nʉ?” ");
INSERT INTO chqNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Joon iñí¹i 'in Rǿøi¹³ do: “'E la ja'²mo fuu²¹²uu 'naa', doñi'ee 'e tyʉ́² 'e nigajmaa²aa' tya' ruu'²¹na, xʉfiin'¹³, 'in 'wéei¹gɨ, lawa'a gajmaa²aa' tyiia”, gajin'² Rǿøi¹³ do. ");
INSERT INTO chqNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Joon injin'² 'in Rǿøi¹³ do sɨɨ'²¹ɨ 'in tsá² téein² lɨ' cwoo²¹o tooin²¹²: “Jeen'¹³naa' coon'¹³ jna jileei'²¹ 'in 'eei'¹ Dios. Cwolíin²naa' lɨ 'ii²¹ lɨ nigatyaa¹a Dios tyʉ́² tya' 'in 'lɨɨi'³ coon'¹³ 'ɨɨ'¹³ tya'a lɨ coo²¹ jɨ́² coon²¹ tøø²mo jon. ");
INSERT INTO chqNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Gatsá² un'áa³na pe 'naa' jo 'ee gacwó¹oo' jna joon gatsá² unjmɨɨ²¹na jon'gɨ'ɨ 'e joon gacwó²oo' jna jon. ");
INSERT INTO chqNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Joon mo gangɨ́³ɨɨ 'e jo cwíi²naa' jna pe 'naa'gɨɨ' jo gatee²ee' jna fu inʉʉ tyii'. Gali'náa³aa sɨn'³ɨɨn pe 'naa' jo 'ee gacwó²oo' jna. Galitsaa'¹³aa joongɨ ga'uu²¹²uu 'nʉñí³ pe 'naa'gɨɨ' jo 'ee ñifee'¹³naa' jna.” ");
INSERT INTO chqNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Joon 'in tsá² do injin'²in: “Ña'ñʉ'¹ʉ', ¿lɨɨgɨ ganee²¹²na'a 'nʉ 'e un'aa²u'u sɨ 'e unjmɨɨ²¹u'un 'ee sɨ gangɨ'¹'ɨ 'e jo cwíi²na'a 'nʉ sɨ jo sɨɨn'²¹'ɨn sá² 'ee, sɨ tsaa'¹³'a 'ee sɨ ga'u²'u 'nʉñí³ 'ee joon jo gauncoon'¹³ jna'a 'nʉ?” ");
INSERT INTO chqNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Joon iñí¹i 'in Rǿøi¹³ do: “E la ja'²mo fuu²¹²uu 'naa', doñi'ee 'e tyʉ́² 'e jo nigajmaa²aa' tya' 'in tsá² 'wéei¹ lo lawa'a jo 'ee tyʉ́² gajmaa²aa' tya' jna‑a jon.” ");
INSERT INTO chqNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Joon 'in gó² do itsalíin² lɨ ní²i wúu¹ coon²¹ tøø²mo joon 'in tsá² tyúi¹ do tsataai² lɨ seein²¹ tyʉ́² coon²¹ tøø²mo. ");
INSERT INTO chqNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Joon mo gatséi¹ faa'²¹a Jesús 'e júu³ lo gajin'²in sɨɨ'²¹ɨ tsá² tya'a: ");
INSERT INTO chqNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Niñí²oo' jee²¹² tún² jmɨɨ²¹² itɨ́² jmɨɨ²¹² cwaa'²¹ jmɨɨ²¹² 'e unsii²¹ tsá² Israel, pascua. Joon ijaan'²¹mo tsá² jna, 'e lɨ́ɨ¹na Ruu'²¹na Tsá², itéen¹in tsá² jna tsaa'¹ crúu¹³. ");
INSERT INTO chqNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Joon 'in tyʉ'² to² tya' untsá² coon'¹³ 'in tɨfo'² tya' ley coon'¹³ tsacøøi'¹³ tya' tsá² Israel gauncaain²¹ yaai tyani 'nʉ́¹ lɨ tyíin¹ Caifás 'in tyʉ́² to² nifu tya' untsá² do. ");
INSERT INTO chqNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Joon do‑o gasɨ́ɨ²i xiiala ijmáa¹a insaan'¹an Jesús coon'¹³ júu³ tajuu²¹ joon ijnga'²mo 'ido. ");
INSERT INTO chqNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","―Pe jo lí² jee²¹² jmɨɨ²¹² jee²¹² ―gajin'²in― tsʉ ito'² tsá² mɨɨ'¹³ 'áai¹. ");
INSERT INTO chqNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Joon la 'ɨɨ²¹² taain¹ Jesús fuu²¹ Betania tyíin¹in tya' Simón, 'in nigacón² jmoowúu¹ 'e jgoo'²¹ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Joon ga'í²i jaain²¹ tsamɨ́² 'in tyán¹an coon²¹ sɨ́² lɨ cuun²¹² alabastro sɨ'o² jmɨɨ²¹ jmafuu²¹. Joon 'e jmɨɨ²¹ jmafuu²¹ do 'áai¹ tyíin¹ cuu². Ga'í² 'in tsamɨ́² do tya' Simón. Joon la jee²¹² tyíin¹ Jesús lɨ si'² mesa joon ga'ee²e 'in tsamɨ́² do 'e jmɨɨ²¹ jmafuu²¹ do yʉ' tyi² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Joon mo ganí² tsá² tya' Jesús 'elo gatsá² 'nii'²¹‑tsi gajin'²in: ―¿'Ee galɨ'²ɨ 'e un'ɨ́ɨ¹ɨ 'in tsamɨ́² no 'e jmɨɨ²¹ jmafuu²¹ no? ");
INSERT INTO chqNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Li²‑i tsa'nɨɨ²¹ɨ' no, lɨ́ɨ¹ incɨ́in¹ 'e no. Joon lí²‑i cwoo¹³o' tsá² tañíi². ");
INSERT INTO chqNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Joon mo galili'³i Jesús xiiala sɨ́ɨ²i 'ido joon gajin'²in: ―¿'Ee lɨ' untyíi² 'naa' 'in tsamɨ́² lo? 'E nigajmaa¹a no 'e tyʉ́²‑ʉ no tyiia. ");
INSERT INTO chqNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Coon²¹ tøø²mo taan²¹²naa' coon'¹³ 'in tañíi² pe jna jo tyíin¹³na jee²¹² 'naa' coon²¹ tøøi². ");
INSERT INTO chqNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","'A nisuun¹un 'in tsamɨ́² no 'e jmɨɨ²¹ jmafuu²¹ lo tyiia lawa 'e tyaa¹ tyʉ́² 'e tɨ li 'á¹moo. ");
INSERT INTO chqNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","'E la ja'²mo fuu²¹²uu 'naa', doñixiia' la 'úui¹ juncwii²¹ 'e cwó¹ tsá² júu³ tyʉ́² tya' xiiala itiin'¹³ tsá² joongɨ ityá²a tsá² júu³ la lɨ' 'e gajmaa¹a 'in tsamɨ́² lo. Joon itɨ'²‑tsi tsá² 'ii ―jin'² Jesús ");
INSERT INTO chqNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Joon jaain²¹ jee²¹² 'in dyatooin¹ tsá² tya' Jesús, 'in sii²¹ Judas Iscariote, gangó¹o ngafee'¹³i 'in tyʉ'² to² tya' untsá² ");
INSERT INTO chqNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","joon gajin'²in: ―¿Xiiati cuu² cwoo²oo' wa' jaan'¹³na Jesús do tyii'? Joon 'in tsá² do gacwo'¹o Judas dyadya¹ cuu² cwataa²¹. ");
INSERT INTO chqNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Joon tsifu joon ga'láa² Judas 'wii²¹² 'noo'¹o xiiala lí² jaan'²¹in Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Joon mo ga'láa² 'wii²¹² jmɨɨ²¹² coon²¹ tya' 'e jmɨɨ²¹² gatɨ́² do mo gøø'²¹ø tsá² 'iñi'¹ 'e jo tyiian'³ jeei¹, 'in tsá² tya' Jesús gangatyéen¹in lɨ tyíin¹ Jesús joon gaunngɨɨ¹ɨ: ―¿Xiia 'iin²¹²u'un ityaa²¹a'a tyʉ́² ityee²e' tya' jmɨɨ²¹² pascua lo? ");
INSERT INTO chqNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Joon gañii¹i: ―Cwolíin²naa' lɨ náa¹ fuu²¹ no joon cwosii'¹³duu' jaain²¹ tsá² tyíin¹ do joon fú²uu': “Tɨfó² tyi' jin'²in: 'E tɨ lɨ tɨ́² 'ii'²¹ tya'a joon fu tyi'i 'iin²¹²in jmaa'¹³a jmɨɨ²¹² pascua coon'¹³ tsá² tya'a.” ");
INSERT INTO chqNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Joon 'in tsá² tya' Jesús do gajmaa¹a la to² tyʉ'²ʉ joon gatyaa¹ tyʉ́² idø'²ø tya' jmɨɨ²¹² pascua do. ");
INSERT INTO chqNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Joon mo canʉʉ²¹ jmɨɨ²¹² joon nanéei¹ Jesús coon'¹³ dyatooin¹ tsá² tya'a idø'²ø. ");
INSERT INTO chqNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Joon la jee²¹² lɨ néei¹ gøø'²¹ø gajin'²in Jesús: ―'E la ja'²mo fuu²¹²uu 'naa', jmoo²¹ joon jaain²¹ jee²¹² 'naa' in'nɨ́ɨ¹³naa' jna². ");
INSERT INTO chqNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Joon tsifu joon gajmaa¹a tsá² tya'a fa'í³ 'áai¹. Joon garóon²on tɨ' jaain²¹ tɨ' jaain²¹ gaunngɨɨ¹ɨ Jesús: ―Ña'ñʉ'¹ʉ', ¿tɨ jna‑a 'i? ");
INSERT INTO chqNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Joon gañii¹i Jesús gajin'²in: ―'In tyé³e'e coon²¹ wúu¹ coon'¹³, 'i‑i 'i in'nɨ́¹i jna. ");
INSERT INTO chqNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","'Ná¹‑a tsín¹ jiin'¹³ la jin'² ni jí² tya' Dios cwáain¹ tya' 'in Ruui'²¹ Tsá² pe ifúu² 'in 'nɨ́¹i Ruui'²¹ Tsá² do. Tyʉ́²gɨ tya'a wa mo'o jo galiseen²¹mo. ");
INSERT INTO chqNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Joon Judas, 'in tɨ li 'nɨ́¹i 'ii, gajin'²in sɨɨ'²¹ɨ Jesús: ―Tɨfo'² tyi', ¿tɨ jna‑a 'i? Joon Jesús gañii¹i gasɨɨ'²¹ɨ Judas jin'²in: ―Jiin'¹³ la joon niga'ɨ¹‑'o'o 'nʉ. ");
INSERT INTO chqNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Joon la jee²¹² gøø'²¹ø gatɨɨ²¹i Jesús coon²¹ 'iñi'¹, gacwo'¹o 'maai'¹³ Dios, joon gajmaa¹a jmai'²xʉ jee²¹² tsá² tya'a joon gajin'²in: ―Tyee²ee', tsʉ la lɨ ngú¹ taan²moo lo. ");
INSERT INTO chqNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Mo ngayuui'¹³ joon gatɨɨ²¹i coon²¹ po'³xʉ lɨ sɨ'ó¹o jmɨ'³ wuunjøø'³ joon gacwo'¹o 'maai'¹³ Dios. Mo ngayuui'¹³ joon gacwo'¹o tsá² tya'a gajin'²in: ―'Iin²¹iin' 'elo jileei'²¹ 'naa', ");
INSERT INTO chqNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","tsʉ 'e lɨ la lɨ jmɨ¹ 'ǿø³moo lo 'e tɨ li tʉ́n¹ʉn joon coon'¹³ 'elo itsín¹ 'e júu³ 'múui². Joon 'e jmɨ¹ 'ǿø³na itʉ́n¹ʉn lo i'iin² tsaa² tya' tsá² fúui¹. ");
INSERT INTO chqNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Pe fuu²¹²uu 'naa' jo 'e i'né³e'gɨ' caain²¹ 'e jmɨ'³ wuunjøø'³ lo coon'¹³ 'naa' ca mi tɨ jmɨɨ²¹² ityʉ'² Ñʉ'³ʉʉ tó² tsá², joon jmɨɨ²¹² joon i'né³e' tún¹ coon'¹³ 'naa'. ");
INSERT INTO chqNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Joon mo ngayuui'¹³ ga'øø¹ø coon²¹ Salmo joon ngalíin²mo coon'¹³ tsá² tya'a fu yʉ' moo'²¹ Olivos. ");
INSERT INTO chqNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Joon gajin'² Jesús sɨɨ'²¹ɨ tsá² tya'a do: ―'E 'woo¹ no jilee'²¹naa' ixée¹mo‑'oo' coon'¹³ jna tsʉ ni jí² tya' Dios 'e jin'²in: “Ijngaa'¹²moo 'in 'aa¹i joo'saa'²¹ joon ixée²i joo'saa'²¹ tya'a.” ");
INSERT INTO chqNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pe mi yuui'¹³ injmá¹a Dios injiin'¹in jna iníi³ii jéei¹³gɨ lagɨ 'naa' fu lɨ sii²¹ Galilea. ");
INSERT INTO chqNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pe jin'² Tʉ́³ gañii¹i: ―Xʉfiin'¹³ jileei'²¹ 'in catyaai² no ixée²i‑tsi coon'¹³ 'nʉ pe jna lo jo jmɨɨ²¹² xée²i‑tsii coon'¹³ 'nʉ. ");
INSERT INTO chqNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Pe Jesús gajin'²in gasɨɨ'²¹ɨ Tʉ́³ do: ―'E la ja'²mo fuu²¹²uu 'nʉ, 'nɨ¹ naa'¹³ ifoo¹³'o 'e jo cwii¹un jna la nʉ'gɨ i'oo¹o tuuitsáa². ");
INSERT INTO chqNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pe Tʉ́³ do‑gɨ gajin'²in tún¹: ―Xʉfiin'¹³ júun³moo coon'¹³ 'nʉ pe jo fo'³oo wa'a jo cwii¹na 'nʉ. Joon la joon jon gajin'² 'in catyaai² do jon. ");
INSERT INTO chqNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Joon gatyalíin² Jesús coon'¹³ tsá² tya'a coon²¹ lɨ sii²¹ Getsemaní joon Jesús gajin'²in: ―Ní²duu' lo la 'ɨɨ²¹² níi³ii nifo'³oo júu³ tyʉ́² lɨ'do. ");
INSERT INTO chqNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Joon gajée¹mo Tʉ́³ coon'¹³ 'in gái¹ jóon¹ Zebedeo ngalíin² coon'¹³. Joon Jesús gatsá² goon²¹ 'e fa'í³ lɨ́ɨ²i 'áai¹ joongɨ gajmaa¹a cu'²‑tsi 'ña'a 'áai¹. ");
INSERT INTO chqNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Joon gajin'²in: ―'E fa'í³ 'e seen²na lo 'e lɨ'ɨ ijúun²moo. Ján²duu' lo joon jmaa²aa' lí²ii' coon'¹³ jna. ");
INSERT INTO chqNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Joon gangó¹o Jesús capi'³ nifugɨxʉ joon gatyíi²a lɨ' ri'íi²in ni 'wó² gamɨɨ¹ɨ tyani Dios jin'²in: ―Ñʉ'³, wa xʉ'ʉ lí² 'e jo móo³oo ilí²no pe jo cwolí² jiin'¹³ la 'iin²¹² jna, cwolí² jiin'¹³ la 'iin²¹² 'nʉ‑ʉ. ");
INSERT INTO chqNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Joon ganga'²mo tún¹ fu lɨ néei¹ 'in gaai²¹ tsá² tya'a joon nateei'¹³ 'ido cwuu²¹mo. Joon gajin'²in sɨɨ'²¹ɨ Tʉ́³: ―¿Tɨ jo nilii¹i 'naa' 'e jo cwuu²¹naa' coon'¹³ jna coon²¹ hora? ");
INSERT INTO chqNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Jmaa²aa' lí²ii' joon faa²aa' júu³ tyʉ́² 'e jo xuu'²¹naa' ja'cwoo²¹ 'in 'lɨɨi'³. 'E la ja'²mo 'ɨ¹‑tsi tsá² jmáa¹a 'e tyʉ́² pe² ngʉ́¹ taain²¹² jo cwo¹. ");
INSERT INTO chqNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Gangó¹ Jesús tún¹ ngafee'¹³i Dios jin'²in: ―Ñʉ'³, wana jo lí² 'e cuu'¹³u imóo³oo wúu¹ no pe cwolí² jiin'¹³ la niga'ɨ¹‑'o'o² 'nʉ. ");
INSERT INTO chqNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Joon ganga'²mo tún¹ joon, joon nateei'¹³ 'ido cwuu²¹mo tún¹ tsʉ 'áai¹ jlɨɨ¹ɨ unníi¹i. ");
INSERT INTO chqNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Joon jo gatø'²gɨ 'ido gango¹o tún¹ ngafaa'¹²a júu³ tyʉ́² lɨ gatɨ́² 'nɨ¹ naa'¹³ do. Gajin'²in la nigajin' do tún¹. ");
INSERT INTO chqNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Joon ganga'²mo tún¹ lɨ tee'¹i 'in gaai²¹ tsá² tya' do joon gajin'²in: ―Cwocwuu²¹mogɨɨ', cwo'ii'¹xʉ 'wó²oo'. Tsʉ gatɨ́² 'ii'²¹ ijaain'¹ tsá² 'in Ruui'²¹ Tsá² ja'cwoo²¹o 'in tsá² røøi²¹ tsaa². ");
INSERT INTO chqNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Raan²¹naa' no, moo²¹o' tsʉ no‑o nijó¹ 'in 'nɨ́ɨi¹ jna do. ");
INSERT INTO chqNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","La jee²¹² faa'²¹gɨ Jesús siin'¹³in gatyía¹ Judas, 'in lɨ́ɨ¹i tsá² tya'a jee²¹² 'in dyatooin¹ do, coon'¹³ tsá² fúui¹ lɨɨ¹. Joon 'in tsá² do tyaan¹an ñí³ espadas tyaan¹an jon 'no'³ 'mó² gatyalíin² to² gatyʉ'² 'in tsá² tyʉ'² to² untsá² coon'¹³ 'in tsacøøi'¹³ tya' tsá² Israel. ");
INSERT INTO chqNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Joon Judas do, 'in i'nɨ́ɨ¹i Jesús, ni gasɨ́ɨ²i júu³ coon'¹³ 'in tsá² do xiiala li² ijmáa¹a gajin'²in: ―'In jun'³uun caain²¹ ju'² 'ii do. 'I‑i 'in saan'¹³naa'. ");
INSERT INTO chqNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Joon gangatyéen¹in lɨ siin'¹² Jesús joon gajin'²in: ―¡'Aa²¹²mo'o, tɨfo'² tyi'! Joon gajun'²un caain²¹ ju'² 'ido. ");
INSERT INTO chqNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesús gañii¹i: ―Ru'¹u', ¿'ee to² ñí²'i? Joon tsifu joon gasan'²mo 'in tsá² do Jesús joon gatǿø²o 'ido sɨ'ñú¹mo. ");
INSERT INTO chqNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Joon jaain²¹ jee²¹² 'in tsá² tya'a do gasø'²ø ñí³ tya'a joon gatyʉ'²ʉ cataain²¹² loocwóo¹o jaain²¹ tsa'leei'¹³ tya' 'in tyʉ'² to² tya' untsá² nifu. ");
INSERT INTO chqNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Pe Jesús gajin'²in sɨɨ'²¹ɨ 'ido: ―Taan'¹ ñí³ tyi'i tsi 'nʉ́¹ tya'a. Tsʉ jileei'²¹ 'in jngaai'¹² tsá² coon'¹³ ñí³ coon'¹³ 'ñí³‑i jon ijúun²in. ");
INSERT INTO chqNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Tɨ jo ñí²'i, lí²‑i fuu²¹² jna Ñʉ'³ʉʉ joon 'ii tsifu insii¹in setenta mil ángeles iun'øø¹i jna? ");
INSERT INTO chqNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pe wa'a lí² la joon, ¿xiiala itsín¹ jiin'¹³ la jin'² ni jí² tya' Dios, xiiala 'ná¹ ilí²? ");
INSERT INTO chqNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Joon gajin'² Jesús sɨɨ'²¹ɨ 'in tsá² fúui¹ do: ―¿'Ee lɨ' ñilíin²naa' saan'¹³aan' 'no'³ 'mó² coon'¹³ ñí³ itøø²øø' jna lawa jaain²¹ 'uun²¹? Tsʉ la coon²¹ jmɨɨ²¹² tyíin¹na inʉʉ cwo'¹ fee'¹ do 'e'³ee 'naa' júu³ tyʉ́² joon jo mo gaseen'²¹naa' jna. ");
INSERT INTO chqNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pe la lo‑o galɨ́² 'e gatsín¹ júu³ tya' Dios 'e gataan¹an ni mo'jí² 'in tsá² cwo¹ júu³ tya' Dios la mo jéei¹. Joon 'in tsá² tya' Jesús do gacwiin¹o gatiu²mo Jesús 'ña'a do. ");
INSERT INTO chqNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Joon 'in tsá² fúui¹ do 'in gasain'² Jesús joon gangajaa²¹² ni'i 'ido tyani Caifás, 'i‑i 'in nifu 'in tyʉ'² to² tya' untsá². Joon do‑o nisɨcaain²¹ tsacøøi'¹³ coon'¹³ tɨfo'² tya' ley. ");
INSERT INTO chqNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pe Tʉ́³ do gangaa'¹³i cɨ́ɨn²mo caluu do joon gatyee'¹³i tya'i tyi¹ lɨ si'² 'nʉ́¹ lɨ néei¹ 'in tyʉ'² to² nifu do. Joon do‑o gacwó² Tʉ́³ caluu do coon'¹³ 'in 'ɨɨ'¹³ tya' 'in tsá² tyʉ'² to² do. 'E 'iin²¹²in jǿø²ø xiiala itsangɨɨ¹i Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Joon 'in tyʉ'² to² tya' untsá² do coon'¹³ 'in tsacøøi'¹³ coon'¹³ jileei'²¹ 'in catyaai²gɨ 'in tyʉ'² to², 'in sii²¹ Junta Suprema, ga'noo'¹on 'ee tsaa² ilijmáa¹a tya' Jesús, fiin'¹³ coon'¹³ júu³ tajuu²¹ joon ilí² jnga'¹ni 'ido. ");
INSERT INTO chqNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Pe jo 'ee tsaa² tya' Jesús gatsaa'¹a jiin'¹³ coon²¹ joongɨ lɨɨlɨ́¹ fúui¹ tsá² taai² jmoo¹o júu³ tajuu²¹. Pe mo ga'yá² gatsín¹ garoon¹on gái¹ tajuui²¹, ");
INSERT INTO chqNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","'in gajin'²in: ―Niganʉʉ²¹ʉ'ʉ jin'² 'in tsañʉʉ'¹ no: “Jna‑a lí² fiin¹na 'e cwo'¹ fee'¹ tya' Dios no, joon jee²¹² 'nɨ¹ jmɨɨ²¹² lí² jmaa'¹³aa tún¹.” ");
INSERT INTO chqNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Joon 'in nifu 'in tyʉ'² to² jee²¹² untsá² garoon¹on, joon gajin'²in sɨɨ'²¹ɨ Jesús: ―¿Tɨ jo ngɨɨ²'ɨ coonti? ¿'Ee 'e tsaa² jmoo¹o 'in tsá² no tyi'i? ");
INSERT INTO chqNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Pe Jesús‑gɨ gajaan¹an tii². Joon 'in nifu 'in tyʉ'² to² jee²¹² untsá² do gajin'²in tún¹ gasɨɨ'²¹ɨ Jesús: ―Tyani Dios, 'in jiin'¹, sii'¹³ jna'a, ¿tɨ 'nʉ‑ʉ Cristo Jóon¹ Dios? ");
INSERT INTO chqNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Joon Jesús gañii¹i gajin'²in: ―'Ii‑gɨ jna jiin'¹³ la foo'²¹ 'nʉ. Joongɨ fuu²¹²uu 'naa' imoo²oo' 'in Ruui'²¹ Tsá² tyíin¹in lɨ' cwoo²¹o Dios tsáa¹. Joon 'in Dios do lí² jmáa¹a jilaa'²¹ 'e 'iin²¹²in. Imoo²oo' 'in Ruui'²¹ Tsá² do ijó¹ jee²¹² jníi¹ tya'cwii²¹. ");
INSERT INTO chqNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Joon Caifás do ga'gɨ́ɨ¹ɨ sɨɨn'¹³ɨn joon gajin'²in: ―'In tsañʉʉ'¹ lo nigafaa'²¹a 'e lawa Dios 'ii. Jo 'néi¹‑gɨ tsá² 'in jmá¹ júu³ røø²¹. Jileei'²¹ 'naa' niganʉ́ʉ¹³ʉʉ' jilaa'²¹ júu³ gó² 'e gafaa'²¹a. ");
INSERT INTO chqNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Xiiagɨ la 'ɨ¹‑'oo' 'naa'? Joon 'in tsá² néei¹ do gajin'²in: ―'Ná¹ júun²mo 'ino 'wii'¹³ tsaa² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Joon ga'ñíi¹ 'in tsá² do ni² Jesús joongɨ gajmee'²¹mo 'ido joongɨ gajnáa¹a ni² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Joon gajin'²in 'in tsá² do: ―'Ñʉ‑ʉ lɨ́ɨ¹u'u Cristo 'in gasiin¹ Dios, laa'¹³ jmaa²'a júu³, ¿'iin gatyuun¹in 'nʉ? ");
INSERT INTO chqNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Joon la jee²¹² siin'¹² Jesús tyani 'in tsá² do Tʉ́³‑gɨ tyíin¹in fu caluu tya'i tyi¹. Joon jaain²¹ 'yiia²¹² 'in jmoo¹o 'e gø'² Caifás do gangatyéen¹in lɨ tyíin¹ Tʉ́³ joon gajin'² 'in tsamɨ́² do: ―'Nʉ jon 'in ngɨ¹ coon'¹³ Jesús 'in jó² Galilea. ");
INSERT INTO chqNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pe Tʉ́³ do‑gɨ jo garǿø¹i tyani 'in tsá² fúui¹ néei¹ do, gajin'²in: ―Jo ñí³ii 'ee 'e foo'²¹'o no. ");
INSERT INTO chqNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Joon gajeein'²¹gɨxʉ Tʉ́³ lɨ tyíin¹in do joon gangó¹ tyan'gɨxʉ lɨ tyí³ 'oo² 'yá² lɨ 'wooi²¹ tsá². Joon jaain²¹gɨ 'in gangaa¹i 'ii joon gasɨɨ'²¹ɨ 'in téein² do: ―'In tsañʉʉ'¹ no ngɨɨ¹o 'ino jon coon'¹³ Jesús tsá² Nazaret. ");
INSERT INTO chqNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Joon xiia'²¹gɨ tún¹ jo garǿø¹i Tʉ́³ tún¹ ga'íi¹i Dios gajin'²in: ―Jo cwii¹na 'in tsañʉʉ'¹ no. ");
INSERT INTO chqNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Joon xʉʉ lɨ'ɨɨi²¹²xʉ joon mo gangatyéen¹in 'in néei¹ do lɨ siin'¹² Tʉ́³ joon gajin'²in: ―'E la ja'²mo, 'nʉ lɨ́ɨ¹u'u jaain²¹ jee²¹² 'ino tsʉ no li² la faa'²¹ 'ido‑o foo'²¹ 'nʉ. ");
INSERT INTO chqNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Joon 'láa² Tʉ́³ 'wii²¹² ga'íi¹i Dios jin'²in: ―Wa jo fo'³oo 'e la jai'² ijmee'²¹mo Dios jna, jo cwii¹na 'in tsañʉʉ'¹ no. Joon tsifu joon ga'oo¹o jaain²¹ tuuitsáa². ");
INSERT INTO chqNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Joon gatɨ'²‑tsi Tʉ́³ jiin'¹³ la nigajin'² Jesús gasɨɨ'²¹ɨ 'ii mo gajin'²in: “La nʉ'gɨ i'óo¹o tuuitsáa², 'nɨ¹ naa'¹³ nifaa'¹³'a 'e jo cwii¹u'u jna.” Joon mo gatɨ'²‑tsi Tʉ́³ 'e júu³ do gacwo'ɨ́ɨ¹o fu jee²¹² 'nʉ́¹ joon gatyi'²o xuui²¹²‑tsi 'áai¹. ");
INSERT INTO chqNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Joon mo gajná² do joon gasɨ́ɨ²i røø²¹ jileei'²¹ 'in tyʉ'² to² tya' untsá² coon'¹³ 'in tsacøøi'¹³ tya' tsá² Israel xiiala ilijúuin² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Joon gangajée¹³mo Jesús sɨ'ñúu¹mo tyani Poncio Pilato 'in lɨ́ɨ¹i to² gobernador. ");
INSERT INTO chqNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Joon mo galiñii¹i Judas, 'in ga'nɨɨi¹ Jesús, 'e nisɨɨ²¹i tsá² røø²¹ xiiala ijúuin² Jesús gajoo'²¹o‑tsi 'áai¹ joon ngajoon'¹³o 'ido 'e dyadya¹ cuu² cwataa²¹ tya' 'in tsá² 'in tyʉ'² to² tya' untsá² joongɨ tya' 'in tsacøøi'¹³ do. ");
INSERT INTO chqNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Joon gajin'² Judas sɨɨ'²¹ɨ 'in tsá² do: ―Jna‑a niga'noo²¹²oo tsaa² mo ga'nɨ́³na jaain²¹ tsañʉʉ'¹ 'in jo 'ee tsaa² tya'a sá². 'In tsá² do‑gɨ gañii¹i: ―Jo 'ee cwáain¹ tyijna'a 'e joon 'e cwáain¹ jon 'e tyi'nʉ 'woo'o joon. ");
INSERT INTO chqNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Joon Judas coon²¹ gadya'² goon²¹ la no‑o 'e cuu² do ni 'wó² inʉʉ cwo'¹ fee'¹ do. Joon gacwo'ɨ́ɨ¹o do joon nga'nʉʉ²¹ʉ 'nii²¹² luu²¹²u 'ña'a, joon coon'¹³ la joon gajngaa'¹²mo 'ña'a. ");
INSERT INTO chqNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Joon 'in tsá² 'in tyʉ'² to² tya' untsá² do gataa'¹³i, gauntɨɨ'¹i 'e cuu² do. Joon gajin'²in: ―Jo tɨɨ²¹i taa'¹³ jna' 'e cuu² lo tsi lɨ taa'¹³ cuu² tya' cwo'¹ tsʉ cuu² gacɨɨn¹in tya' ijúuin² tsá²‑a no. ");
INSERT INTO chqNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Joon tsifu joon gasɨɨ²¹i 'in tsá² do røø²¹ iló² coon'¹³ sii'¹³ 'wó² coon'¹³ 'e cuu² do. 'E coon'²¹ sii'¹³ 'wó² do sii²¹ 'Wó² tya' Tɨtu'². Galó¹ 'e 'wó² ilisá² coon²¹ lí² ái¹ tsá² jalíin² lɨ' xiia'²¹ 'in júun²in fuu²¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Tsʉ 'wii'¹³ joon sii²¹ 'e 'wó² do ca jmɨɨ²¹² no, 'Wó² tya' Jmɨ¹. ");
INSERT INTO chqNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Joon coon'¹³ la joon gatsín¹ júu³ tya' Jeremías, jaain²¹ 'in gacwó¹ júu³ tya' Dios la mo jéei¹ 'in gajin'²in: “Tsá² Israel gajin'² icɨ́ɨn¹in 'in tsá² do dyadya¹ cuu² cwataa²¹. ");
INSERT INTO chqNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Joon coon'¹³ 'e cuu² do galó¹ coon'²¹ sii'¹³ 'wó² tya' tɨtu'² jíin'¹³ la to² 'e nigatyʉ'² Ña'ñʉ'¹ʉ'.” ");
INSERT INTO chqNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Gajée¹mo tsá² Jesús tyani 'in gobernador joon 'ido gaunngɨɨ¹ɨ 'ii: ―¿Tɨ 'nʉ‑ʉ Rǿøi¹³ tya' tsá² Israel? Joon Jesús gajin'²in: ―Jiin'¹³ la nigafaa'¹³'a no, 'e joon 'e jo'¹. ");
INSERT INTO chqNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Joon mo ga'nɨ́ɨ¹i 'in tyʉ'² to² tya' untsá² coon'¹³ 'in tsacøøi'¹³ do lɨ coon²¹ gaján¹ Jesús tii². ");
INSERT INTO chqNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Joon Pilato gajin'²in sɨɨ'²¹ɨ Jesús: ―¿Tɨ jo nuu²'un jilaa'²¹ 'e gó² faa'²¹ 'ido tyi'i? ");
INSERT INTO chqNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Joon jo 'ee gañii¹i Jesús coonti. 'Wii'¹³ joon ganga'goo²¹‑tsi 'in gobernador do 'áai¹. ");
INSERT INTO chqNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Jiin'¹³ la tɨɨsi'² mo gatɨ́² jmɨɨ²¹² 'e gatɨ́² 'in gobernador do 'ná¹ láa¹i jaain²¹ tsá² taai² 'nʉñí³ tya' 'in tsá² néei¹ 'e fuu²¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Joon jee²¹² jmɨɨ²¹² joon 'yuui² jaain²¹ tsá² 'nʉñí³ do 'in sii²¹ Barrabás. Tyʉ́²‑ʉ cwii¹mo tsá² 'ii. ");
INSERT INTO chqNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Joon la jee²¹² sɨcaain²¹ 'in tsá² do gaunngɨɨ¹ɨ Pilato 'in tsá² do: ―¿'Iin‑in 'iin²¹²naa' ilaa²¹²na tyii'? ¿Tɨ 'iin²¹²naa' laa²¹²na Barrabás sɨ Jesús 'in sii²¹ Cristo 'ee? ");
INSERT INTO chqNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Tsʉ galili'³o Pilato 'e 'wii'¹³ tsiiwúu¹mo 'e gajaan'²¹ ni 'ido ja'cwoo²¹o. ");
INSERT INTO chqNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","La jee²¹² tyíin¹ Pilato lɨ jmoo¹o 'ii'²¹ do gasiin²¹ tsamɨ́² tya'a coon²¹ júu³ 'e jin'²: “Jo cɨɨin'¹³ 'wo'²o 'áai¹ 'e cwáain¹ tya' 'in tsá² tyúi¹ no tsʉ lɨɨlɨ¹ caain'²¹ 'e gacɨ́³ɨɨ cwáain¹ tya' 'ino coon²¹ 'e canʉʉ²¹.” ");
INSERT INTO chqNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pe 'in tsá² tyʉ'² to² tya' untsá² coon'¹³ 'in tsacøøi'¹³ do gasɨɨ'²¹ɨ 'in tsá² fúui¹ 'in téein² do wa' ilí² laa¹i Barrabás joon ijúun²mo Jesús. Joon gatɨɨ'² júu³ tya'a 'e laa¹i 'ii. ");
INSERT INTO chqNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Joon gafeei'¹ 'in gobernador do tún¹ 'in tsá² do joon gaunngɨɨ¹ɨ: ―¿'Iin jee²¹² 'in gái¹ no 'in 'iin²¹²naa' lá²i? Joon gañii¹i 'in tsá² do: ―'Iin²¹²moo'o lá²i Barrabás. ");
INSERT INTO chqNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Joon gaunngɨɨ¹ɨ Pilato tún¹: ―¿'Ee‑gɨ ijmáa³aa tya' 'in Jesús no, 'in sii²¹ Cristo? Jilee'²¹mo gañii¹i joon: ―¡Cwotéen¹in tsaa' crúu¹³ 'ino! ");
INSERT INTO chqNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Joon gañii¹i Pilato tún¹: ―¿'Ee 'e gó² 'e nigajmaa¹a 'ino tyii'? Pe 'in tsá² do xʉjoon ga'oo¹o tá² lɨ́ɨ¹gɨ gajin'²in: ―¡Cwotéen¹in tsaa' crúu¹³ 'ino! ");
INSERT INTO chqNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Joon mo galili'³ Pilato 'e jo lí² tɨɨ'² júu³ tya'a pe lɨɨlɨ¹ gato'² 'in tsá² do mɨɨ'¹³ joon gatyʉ'² 'in Pilato do to² 'e jó¹ coon²¹ wúun¹ sɨ'ó¹ jmɨɨ²¹ joon garun'²un cwoo²¹o tyani 'in tsá² taai²¹² do joon gajin'²in: ―Jo tsaa² tyiia ijúuin² 'in tsañʉʉ'¹ 'in tyúi¹ lo, tsaa² tyi'naa' no. ");
INSERT INTO chqNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Joon jileei'²¹ 'in tsá² do gañii¹i: ―Tsaa² tyijna'a coon'¹³ xuui²¹² tyioo'o ijúin¹ 'ino. ");
INSERT INTO chqNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Joon Pilato do galáa²mo Barrabás joon gatyʉ'²ʉ to² ipóo²i 'nii²¹² Jesús joon gajan'² ni 'ido ja'cwoo²¹ 'in tsatéen¹in 'ido tsaa' crúu¹³. ");
INSERT INTO chqNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Mo ngayuui'¹³ joon gatǿ¹ø 'láa² Jesús tsi inʉʉ lɨ née¹i joon gauncaain²¹ jileei'²¹ 'in 'láa² taain² do lɨ siin'¹² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Joon gatyii²¹ sɨɨn'³ 'ido joon gapaa'²¹ ni 'ido coon²¹ 'mɨ'² yʉ́ʉn². ");
INSERT INTO chqNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Joon gajmaa¹a coon²¹ corona lɨ́¹ tóon¹ gaton'²on tyi² 'ido. Joon gacwo'¹o 'ido coon²¹ sɨɨ²¹ 'e son'² 'ido coon'¹³ cwoo²¹o tsáa¹. Joon gasi'²i 'wojníi¹i tyani 'ido joon ungøø¹ ni 'ido. Gajin'²in: ―¡Wóo² cwoseein²¹ 'in rǿøi¹³ tya' tsá² Israel! ");
INSERT INTO chqNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Joon ga'ñíi¹i ni 'ido. Joon coon'¹³ sɨɨ²¹ 'e san'²an do gapó²o 'in 'láa² do tyíi¹i. ");
INSERT INTO chqNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Joon ngayuui'¹³ gaungøøi¹ 'in 'láa² do 'ii joon gatyii²¹o 'e sɨɨn'³ yʉ́ʉn² do joon gatyin'²in Jesús 'e sɨɨn'¹³ɨn do tún¹. ");
INSERT INTO chqNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Joon mo gangalíin² itsatéen¹in Jesús tsaa' crúu¹³ joon gajiin'¹in jaain²¹ tsañʉʉ'¹ lɨ ningalíin² do. Joon 'in 'láa² do gatyʉ'²ʉ to² 'in tsañʉʉ'¹ do sii²¹ Simón, jaain²¹ tsá² Cirene, 'e cón²on crúu¹³ tya' Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Joon gatyalíin² coon²¹ lɨ sii²¹ Gólgota, 'øøi'²¹‑tsi tsá² sii²¹, Cwoon'¹ Po'³ Mootyi² 'Lɨɨ²¹². ");
INSERT INTO chqNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Joon do gacwo'¹o Jesús vino 'e sɨcaai'¹³ jmɨ'³ tsi'³ tya' joo'²¹. Joon mo gatii¹i 'óo¹o 'e vino do sɨcaai'¹³ 'e tyi'¹ joon jo ga'un'²un. ");
INSERT INTO chqNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Joon mo ngayuui'¹³ gatéen¹in Jesús tsaa' crúu¹³ gacoo¹o 'in 'láa² do mɨ'³ 'iin inli'¹ sɨɨn'³ Jesús. Joon coon'¹³ la joon gatsín¹ júu³ tya' 'in gacwo¹ júu³ tya' Dios la mo jéei¹ mo gajin'²in: “Icóo¹o sɨɨn'¹³ɨɨn, ijmáa¹a jmai'²xʉ 'iin inli'¹.” ");
INSERT INTO chqNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Joon do‑o gacwó²o 'aa¹ ni 'ido. ");
INSERT INTO chqNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Joon yʉ' tyíi¹i gataan¹an 'e tsaa² tya' Jesús 'e jin'²: “'In no‑o Jesús, Rǿøi¹³ tya' tsá² Israel.” ");
INSERT INTO chqNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Joon gatéein² jon gái¹ 'uun²¹ jmai'² coon²¹ crúu¹³ tya'a coon'¹³ Jesús, jaain²¹ lɨ cwoo²¹o Jesús tsáa¹ joongɨ jaain²¹ lɨ' cwoo²¹o tooin²¹². ");
INSERT INTO chqNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Joon 'in tsá² 'in la coon²¹ gangɨ́i¹ la jee²¹² taain¹ Jesús tsaa' crúu¹³ joon gajaan¹ jǿøi² Jesús gajíi²in, gajø'²ø mootyíi¹i ");
INSERT INTO chqNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","gajin'²in: ―'Ñʉ‑ʉ, 'in fín¹ cwo'¹ fee'¹ do joon jmaa'¹³'a jee²¹² 'nɨ¹ jmɨɨ²¹² tún¹, laai²¹² 'wo'o no. Wana Jóon¹ Dios 'nʉ cwúui¹ tsaa' crúu¹³ no. ");
INSERT INTO chqNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","La joon jon gaungøø¹i 'in tyʉ'² to² tya' untsá² coon'¹³ 'in tɨfo'² tya' ley coon'¹³ tsá² fariseos coon'¹³ tsacøøi'¹³. Joon sɨ́ɨ²i la 'oo'²¹ 'ii jin'²in: ");
INSERT INTO chqNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Gaun'láai² 'ino tsá² xeei'²¹ pe jo lí² láa¹i 'ña'a. Wana la jai'² 'ii Rǿøi¹³ tya' tsá² Israel cwoxáa¹i tsaa' crúu¹³ no joon iun'goo²o' 'ii. ");
INSERT INTO chqNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Tsaa'¹‑tsi 'in tsañʉʉ'¹ no Dios jin'²in, né²du' wana 'iin²¹²in Dios 'ii joon 'e láa¹i 'ido 'ii tsʉ gajin'²in 'e Jóon¹ Dios 'ii. ");
INSERT INTO chqNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Joon ca 'in 'uun²¹ 'in taan¹in coon'¹³on do gajíi²in 'ii jon. ");
INSERT INTO chqNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Joon ga'ɨ́ɨ² nʉʉ²¹ la caain²¹ juncwii²¹ mo gatɨ́² tyiiañi'¹ ca 'iin² 'nɨ¹ ca'loo¹. ");
INSERT INTO chqNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Joon mo gatɨ́² 'e 'ii'²¹ joon ga'oo¹o Jesús tá² gajin'²in: ―Elí, Elí, ¿lama sabactani? ('E 'øøi'²¹‑tsi tsá² gajin'²in: Dios tyiia, Dios tyiia, ¿'ee lɨ'²ɨ nigatiu²mo'o jna?) ");
INSERT INTO chqNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","'Inlɨ́ɨi¹³ 'in teein¹ do ganúu²un joon gajin'²in: ―'In tsañʉʉ'¹ no tø'¹ø Elías 'in nigacwo¹ júu³ tya' Dios la mo jéei¹. ");
INSERT INTO chqNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Joon tsifu joon jaain²¹ 'in teein¹ do gangó¹ cwiin¹ ngatyaan¹ coon²¹ esponja joon gaun'lá²a esponja do coon'¹³ vino tiin'²¹ joon gauntyii¹ nii²¹² sɨɨ²¹ joon saa'¹³a do 'e la mo cwo'¹o Jesús i'un'²un 'e do. ");
INSERT INTO chqNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Pe 'in catyaai² do gajin'²in: ―Cwoján¹du'; né¹du' wa ijó¹ Elías jalaa²¹² ni 'ino. ");
INSERT INTO chqNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Joon Jesús ga'oo¹o tún¹ tá² joon gajúun²mo mo ngayuui'¹³ jon. ");
INSERT INTO chqNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Joon tsifu joon ga'gɨɨ¹ɨ 'e 'mɨ'² 'í¹i inʉʉ cwo'¹ fee'¹ do ca tɨ' yʉ' ca tɨ' 'wii²¹². Joongɨ gajøø'²¹ 'wó² joongɨ cuun²¹² gajlɨ'². ");
INSERT INTO chqNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Joon ganó² 'aan²¹ lɨ sɨ'aai²¹² 'lɨɨ²¹² joon fúu¹mo 'in najúin¹ 'in nigatsaa'¹‑tsi Dios gajiin'¹in. ");
INSERT INTO chqNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Joon mo ngayuui'¹³ gajiin'¹in Jesús ga'wóo²mo 'in tsá² do 'aan¹ tya'a ngatáa¹i 'e fuu²¹ nacwai'³ Jerusalén joon fúu¹mo tsá² gangaa¹i 'ii. ");
INSERT INTO chqNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Joon mo ganí² fii²¹² 'láa² coon'¹³ 'in 'láa² catyaai² do 'in 'aai¹ Jesús xiiala gajøø'²¹ 'wó² joon jilaa'²¹ 'e nigangó¹ gafoo'¹mo 'áai¹ joon gajin'²in: ―'E la ja'²mo Jóon¹ Dios 'in tsañʉʉ'¹ no. ");
INSERT INTO chqNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Do‑o teein¹ tsamɨ́² fúui¹ wíin²gɨxʉ jǿø²ø. Nigangɨ¹ 'in tsamɨ́² do coon'¹³ Jesús fu Galilea joon nigaunjíi²in Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Joon jee²¹² do sin'² María Magdalena coon'¹³ María sáa³ Jacobo coon'¹³ José. Sin'²mo jon in sáa³ jóon¹ Zebedeo do. ");
INSERT INTO chqNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","58","Capii'³ teein¹gɨ jmɨɨ²¹² joon mo gangó¹ jaain²¹ tsá² sá² cuu² seein²¹ fuu²¹ Arimatea 'in sii²¹ Sé³. Gango¹ 'ido tyani Pilato, ngamɨɨ¹ɨ cuerpo tya' Jesús. 'Ii jaain²¹ tsá² 'in tsaa'¹‑tsi Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Joon gaxíia² cuerpo tya' Jesús joon gacɨɨn'¹³in coon²¹ 'mɨ'² taa²¹ 'e tyʉ́². ");
INSERT INTO chqNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","'In Sé³ do natyʉ'² to² 'e nalɨ́¹ coon²¹ 'aan¹ tya'a tsaa' xá¹ 'e tsa'ii²¹ mi júun²in pe gatan'²mo Sé³ Jesús tsi 'aan¹ 'mɨ́ɨ² do. Joon² mo ngayuui'¹³ gataan'¹in Jesús do joon gajnii²o 'oo²¹ too²¹ 'aan¹ do coon'¹³ coon²¹ cuun²¹² fee'¹ 'áai¹. Joon gangaa'¹³mo mo ngayuui'¹³ do. ");
INSERT INTO chqNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Pe do‑o née¹i María Magdalena coon'¹³ 'in María jaain²¹gɨ do co' do. ");
INSERT INTO chqNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Mo ngayuui'¹³ jmɨɨ²¹² 'e gatyaa¹ tsá² tyʉ́² tya' 'e gatɨ́² jmɨɨ²¹² do 'in tsá² 'in tyʉ'² to² tya' untsá² coon'¹³ 'in tsá² fariseos do ngalíin² ngafee'¹³i Pilato ");
INSERT INTO chqNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","gajin'²in: ―Tsaa'to² tyi', tɨɨ'¹²‑tsii'i la gajin'² 'in tajuui²¹ do la mo jiin'¹gɨ ijiin'¹in mi tɨ́² 'nɨ¹ jmɨɨ²¹² 'e gajúun²in. ");
INSERT INTO chqNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Tsʉ 'wii'¹³ joon siin¹u'un 'láa² tsa'áa² 'aan¹ do ca mi tsín¹ 'nɨ¹ jmɨɨ²¹² tsɨ 'neei'² tsalíin² tsá² tya'a tsatyíi¹ ni 'ido la 'woo¹ joon la joon ilí² jin'²in 'e gajiin'¹ 'ido jee²¹² 'lɨɨ²¹². Tsʉ la joon 'e ilifee'¹gɨ 'e tajuu²¹i lagɨ mo 'wiin²¹² do. ");
INSERT INTO chqNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Joon Pilato do gajin'²in sɨɨ'²¹ɨ 'in tsá² do: ―Cwolíin²naa' coon'¹³ 'láa² joon cwoun'øø'¹naa' 'aan¹ do jiin'¹³ la cwéei¹. ");
INSERT INTO chqNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Joon ngalíin²mo jon lɨ roon¹on 'aan¹ do. Joon gajníi¹i tyʉ́² 'e 'oo²¹ too²¹ 'aan¹ do. Gataan¹an sello tya' cuun²¹² 'e sɨjnɨɨ¹ do joon gajaan¹an 'láa² i'áa¹a 'aan¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Joon mo gangɨ́¹i jmɨɨ²¹² 'ii'²¹ 'woo'²¹ tya' 'in tsá² do, mo tɨ li jná² domingo, 'in María Magdalena coon'¹³ 'in María catyaai² do ngalíin² ngajǿø² lɨ roon¹on 'e 'aan¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Joon gajøø'²¹ 'wó² 'áai¹. Joon jaain²¹ ángel tya' Ña'ñʉ'¹ʉ' gajgáa¹i fu ñʉ'fú² joon gajiin¹in 'e cuun²¹² do 'e sɨjnɨ¹ 'oo²¹ too²¹ 'aan¹ do. Joon gacwó¹o ni cuun²¹² do. ");
INSERT INTO chqNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Jɨɨ'¹i 'áai¹ la jɨɨ'¹ jɨ́² cwaain'ñá³. Joon sɨɨn'¹³ɨn taa²¹ la taa²¹ 'moo²¹. ");
INSERT INTO chqNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Joon mo ganí² 'in 'láa² do lo gafoo'¹i joongɨ gajlée¹i 'áai¹ joon gacɨɨ'¹³i lawa'a 'lɨɨ²¹²mo coonti. ");
INSERT INTO chqNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Joon 'in ángel do gajin'²in sɨɨ'²¹ɨ 'in tsamɨ́² do: ―Jo foo'¹³naa'. Ñí²oo 'e 'naa'²¹naa' Jesús 'in gateen¹in tsá² tsaa' crúu¹³. ");
INSERT INTO chqNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Pe jo 'yuui²gɨ lo, nigajiin'¹o jiin'¹³ la nigajin'²in. Ñilíin²naa', jǿø²duu' lɨ ga'í². ");
INSERT INTO chqNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Cwoliin¹naa' la jmoono cwojmaa²aa' tsá² tya'a júu³ 'e nigajiin'¹o 'ido. Joon itsáa¹a 'ido nifugɨ lagɨ 'ii fu Galilea. Joon do‑o iníi²in. Jiin'¹³ joon 'e 'ná¹ fuu²¹²uu 'naa'. ");
INSERT INTO chqNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Joon ngalíin¹mo 'in tsamɨ́² do la jmoono, 'goo'²¹ 'áai¹ joongɨ jløø'³i. Ngaliin¹ cwiin¹in ngajmaa¹a júu³ tsá² tya' Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Joon la jee²¹² taa²i fu¹ 'in tsamɨ́² do gajnéi¹ Jesús lɨ ngaliin¹ joon gafee'¹i 'ido 'ii. Joon gangatyéen¹in lɨ siin'¹² Jesús joon gasoon'¹on tɨɨ² Jesús gaun'goo²¹o 'áai¹. ");
INSERT INTO chqNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Joon gajin'² Jesús sɨɨ'²¹ɨ 'ii: ―Jo foo'¹³naa', cwojmáa²aa' tsaruu'²¹na júu³ 'e 'ná¹ tsalíin² Galilea joon do‑o iníi²in jna. ");
INSERT INTO chqNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","La jee²¹² ngaliin¹ 'in tsamɨ́² do joon 'in 'láa² 'in 'oo¹ 'aan¹ tya' Jesús ngalíin²in jaain²¹ gáa¹i ngajmaa'¹³a 'in tyʉ'² to² untsá² júu³ jilaa'² 'e nigalɨ́². ");
INSERT INTO chqNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Joon 'in tyʉ'² to² do‑gɨ ngalíin² ngafee'¹³i tsacøøi'¹³ isíin¹in røø²¹. Joon gacwo'²‑o 'in 'láa² do cuu² 'áai¹ ");
INSERT INTO chqNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","joon gajin'²in sɨɨ'²¹ɨ 'in 'láa² do: ―'Naa' foo²oo': “'E tsá² tya' Jesús gangatyíi¹i cuerpo tya' Jesús la 'woo¹ la jee²¹² nigacwuu²taa'a.” ");
INSERT INTO chqNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Joon wa mi liñi¹ gobernador 'e nigacwuu²moo', jna'oo'o tyaa²¹a'a júu³ coon'¹³on tsʉ joon jo jngaa'¹²i 'naa'. ");
INSERT INTO chqNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Joon 'in 'láa² do ga'ii'²¹mo 'e cuu² gacwo¹ 'in tyʉ'² to² do joon ngaliin¹mo joon gajmaa¹a jiin'¹³ la júu³ gasɨ́ɨ²i coon'¹³ 'in tyʉ'² to² do. Joon 'in tsá² Israel ca jmɨɨ²¹² no jo'¹o lɨ́ɨ²i jiin'¹³ la júu³ tajuu²¹ gatyá¹ 'láa² do. ");
INSERT INTO chqNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Joon 'in dyajaain²¹ tsá² tya' Jesús ngalíin² fu Galilea fu yuui'¹³ moo'²¹ jiin'¹³ la nigajin'² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Joon mo gangaai¹ Jesús gaun'goo²¹o 'ido 'áai¹. Pe 'inlɨ́ɨi¹³ gacu'²xʉ‑tsi lɨ́ɨ²i jon'on ñí² tɨ 'i 'ino. ");
INSERT INTO chqNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Joon gangatyéen¹in Jesús lɨ téein² tsá² tya'a joon gajin'²in sɨɨ'²¹ɨ 'ido: ―Nigacwo'¹o Dios jna jilaa'²¹ 'ii'²¹ 'e sá² ñʉ'fú² coon'¹³ 'ii'²¹ 'e sá² ni cwoo'¹³ juncwii²¹. ");
INSERT INTO chqNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Tsʉ 'wii'¹³ joon cwolíin²naa' la 'ui juncwii²¹ cwo'ne'²naa' tsá² 'e líin² tsá² tyiia. Cwosáa¹naa' 'ido jmɨɨ²¹ coon'¹³ 'e sii²¹ Ñʉ'¹ʉ' joongɨ coon'¹³ 'e sii²¹ Jóon¹on joongɨ coon'¹³ 'e sii²¹ 'in Espíritu Tyʉ́² tya' Dios. ");
INSERT INTO chqNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Joon 'ee²ee' 'ido 'e jmaa¹a nʉʉ'¹³ʉ jilaa'²¹ to² 'e nigatyʉ'¹ʉʉ 'naa'. Joon niñii²¹oo' 'e ngɨ́ɨ³ jna coon'¹³ 'naa' la coon²¹ jmɨɨ²¹² ca mi tyéi¹ juncwii²¹. Amén.");
INSERT INTO chqNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","La lo ga'láa² 'wii²¹² júu³ tyʉ́² tya' Jesucristo, Jóon¹ Dios 'ii. ");
INSERT INTO chqNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","La lɨ́² 'e gajin'² Isaías, 'ii jaain²¹ tsá² 'in gafaa'²¹ júu³ tya' Dios calɨɨ lɨɨlɨ¹: Dios sii¹in jaain²¹ tsá² 'in tyan¹ júu³ tya'a. 'Ii tsáa¹ jéei¹gɨ lagɨ 'nʉ. 'Ii tsajmaa¹ júu³ xiiala tya¹ tsá² tyʉ́² tya'a mi ñi'²'i. ");
INSERT INTO chqNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Tá² ni'oo¹o jaain²¹ tsá² coon²¹ lɨ jo 'in tsá² seein²¹. Jin'²in: “Nʉʉ²duu' nijó² Cristo. 'Ná¹‑a tyaa²¹aa' tyʉ́² tyii'. Tsáa²mo‑'oo' 'e tyú¹‑moo'”, jin'²in. ");
INSERT INTO chqNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","La joon mo gajó² Wó³ saai²¹ tsá² jmɨɨ²¹ lɨ jo 'in tsá² seein²¹ gajin'²in: ―'Ná¹‑a unsɨɨ²naa' 'e 'ɨ¹‑'oo' joongɨ 'ná¹ saa¹naa' jmɨɨ²¹. Joon 'íin²mo Dios tsaa² tyii'. ");
INSERT INTO chqNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Jileei'²¹ tsá² 'in néei¹ coon²¹ lɨ sii²¹ Judea joongɨ 'in néei¹ fuu²¹ Jerusalén tsalíin² tsanʉʉ²¹ júu³ tya' Wó³ do. Joon la 'ɨɨ²¹² jmoo¹o 'in tsá² do tyañii²¹ tya'a tyani Dios gasaa¹mo Wó³ 'ii jmɨɨ²¹ tɨ' jmɨɨ²¹ cwo² Jordán. ");
INSERT INTO chqNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Sɨɨn'³ Wó³ lɨ́¹ coon'¹³ jñʉ́² camello. 'E 'ñʉ́ʉ¹ tu'²gɨ lɨ́¹ coon'¹³ loo²¹. Joon 'e gø'²ø jmai'² sɨnii'²¹ coon'¹³ to'² sá² moo'²¹. ");
INSERT INTO chqNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Feei'²¹ Wó³ tsá² júu³ tyʉ́² joon gajin'²in: ―Mi yuui'¹³ jna joon 'injó¹ jaain²¹ tsá² feei'¹. 'Ii feei'¹gɨ lagɨ jna jiin'¹³ jo tɨ́ɨ²na juu'¹³na wojníi³ii sɨɨ'³ɨɨ loo²¹ tsi mɨ́ɨ¹ɨ. ");
INSERT INTO chqNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Jna‑a saa²¹na 'naa' jiin'¹³ coon'¹³ jmɨɨ²¹ pe 'ii‑gɨ nicwo'²o 'naa' 'in Espíritu Tyʉ́² tya' Dios 'e ngɨ¹ coon'¹³ 'naa'. ");
INSERT INTO chqNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Jiin'¹³ jee²¹² jmɨɨ²¹² joon cwa'ɨ́ɨ¹ Jesús fuu²¹ Nazaret náa¹ lɨ sii²¹ Galilea. Joon gasaa¹mo Wó³ Jesús jmɨɨ²¹ tsi jmɨɨ²¹ cwo² Jordán. ");
INSERT INTO chqNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Mo gacwa'ɨ́ɨ¹ Jesús tsi jmɨɨ²¹ do joon ganii²¹ nó¹ 'oo² ñʉ'fú². Joon nii²¹ 'in Espíritu Tyʉ́² tya' Dios lɨ́ɨi¹ maa²¹² jgaa¹i fu lɨ siin'¹²in. Joongɨ gajaan¹an fu yʉ' tyíi¹i. ");
INSERT INTO chqNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Joon ganúu²un coon²¹ júu³ jó² fu ñʉ'fú² jin'²: ―Yʉʉn²¹ tyiia‑oo 'nʉ 'in 'nee¹na. 'Áai¹ lɨ́¹ jløø'³na 'wii'¹³ 'nʉ. ");
INSERT INTO chqNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Tsifu joon gangajéei¹ 'in Espíritu Tyʉ́² tya' Dios Jesús fu coon²¹ lɨ jo 'in tsá² seein²¹gɨ. ");
INSERT INTO chqNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Joon do‑o gateen¹in Jesús ca tséin¹ tunló¹ jmɨɨ²¹² jee²¹² joo'²¹ nuu²¹. Joon Satanás gacón²on cwáain¹ xiiala lɨ́ɨi¹ Jesús. Mi yuui'¹³ joon gatyalíin² ángeles tya' Dios gaunjíi²mo Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Mo lɨcɨɨin²¹ 'e ga'í² Wó³ 'nʉñí³ joon gangóo¹o Jesús coon²¹ lɨ sii²¹ Galilea. Cwoo¹o Jesús júu³ tyʉ́² tya' Dios. ");
INSERT INTO chqNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Joon gajin'² Jesús sɨɨ'²¹ɨ tsá²: ―Gatyii²¹a, gatɨ́² 'ii'²¹. Xʉʉ 'ná¹gɨ 'e tɨ́² jiin²¹ wa'a tyʉ'² Dios to² tsá². Unsɨ́ɨ²naa' 'e 'ɨ¹‑'oo' joon la ja'²mo 'ɨ¹‑'oo' 'e júu³ tya' xiiala 'itiin'¹³ tsá² ―jin'² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ngoo²¹o Jesús tɨ'¹ tyíia¹ Galilea mo ganíi²in Simón coon'¹³ ruu'²¹i sii²¹ Dɨ́ɨ³ 'in saain'²¹ joo'²¹ taai² jmɨɨ²¹ do. Taain²¹² to² pii²¹ 'mó¹ tsi jmɨɨ²¹. ");
INSERT INTO chqNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Joon gajin'² Jesús sɨɨ'²¹ɨ 'ido: ―Ñilíin²duu' coon'¹³ jna. Joon ijmée¹na 'naa' tsá² 'in jée¹i tsá² 'e licwii¹in Dios. ");
INSERT INTO chqNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Tsifu joon gatʉʉ²¹ʉ 'mó¹ tya'a joon gangaliin¹mo coon'¹³ Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Joon xʉ ngoo²¹gɨ Jesús mo ganíi²in Jacobo coon'¹³ ruu'²¹i Wó³ jóon¹ Zebedeo. Táa¹i tsi coon²¹ barco 'mii¹ 'nʉ́ʉ³ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Joon gatø'¹ Jesús 'ii. Do‑o gatiui²¹ jmii²¹. Do‑o gajaan¹ Zebedeo coon'¹³ tsa'leei'¹³ tya'a. Joon Jacobo coon'¹³ Wó³ ngalíin²mo coon'¹³ Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Tyaliin¹ Jesús coon'¹³ 'in ngɨ¹ coon'¹³on coon²¹ fuu²¹ sii²¹ Capernaum. Joon mo gatɨ́² jmɨɨ²¹² 'e 'ii'² 'woo'²¹ tsá² Israel ga'í² Jesús 'e cwo'¹ sinagoga do. Joon ga'láa² 'wii²¹² 'e'²e tsá² júu³ tyʉ́². ");
INSERT INTO chqNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Lɨ́ɨ¹ tsa'goo²¹‑tsi tsá² jilaa'²¹ 'e jin'² Jesús tsʉ 'wii'¹³ ga'e'²e Jesús tsá² lawa jaain²¹ tsá² feei'¹ jon'on la lɨ́ɨi¹ 'in tɨfo'² tya' ley tya' Moisés. ");
INSERT INTO chqNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Joon tsi inʉʉ cwo'¹ do 'yui jaain²¹ tsá² 'in 'yui 'in 'lɨɨi'³ alma tya'a. Joon gafaa'²¹ 'in tsá² do cwáain¹ tya' 'in 'lɨɨi'³ do joon gajin'²in sɨɨ'²¹ɨ Jesús: ");
INSERT INTO chqNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","―¿'Ee lɨ 'u'²'u jee²¹² jna'a Jesús tsá² Nazaret? ¿Tɨ gañi'¹'i 'e untyee¹u'u jna'a? Cwii¹moo 'nʉ. Jóon¹ Dios 'nʉ. 'In tyú¹mo 'nʉ ―gajin'² 'in tsá² do cwáain¹ tya' 'in 'lɨɨi'³ 'yui alma tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Joon gajin'² Jesús sɨɨ'²¹ɨ 'in 'lɨɨi'³ 'yui alma tya' 'ido: ―Jo too'²¹ mɨ́ɨ'¹³. Tiui² 'in tsañʉʉ'¹ no. ");
INSERT INTO chqNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Joon 'in 'lɨɨi'³ do gajmaa¹a cɨi'¹ 'in tsañʉʉ'¹ do. Joon mi yuui'¹³ ga'oo¹o joon gacwa'ɨ́ɨ¹ɨ 'in 'lɨɨi'³ 'yui alma tya' 'ido. ");
INSERT INTO chqNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Jilee'²¹mo ganga'goo²¹‑tsi lɨɨlɨ¹. Joon gaunngɨɨ¹ɨ la 'oo'³ ruu'²¹i: ―¿'Ee‑gɨ lo no? ¿'Ee‑gɨ júu³ 'múui² lo no? ¿'Iin‑gɨ 'in tsañʉʉ'¹ lo? Tyʉ'² to² ca jileei'²¹, ca 'in 'lɨɨi'³ taai² alma tya' tsá² nʉʉ'¹²ʉ to² tyʉ'² 'ino. ");
INSERT INTO chqNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Jmoono‑o galicwii¹in tsá² seein²¹ la caain²¹ Galilea Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ga'woo²¹i Jesús 'e cwo'¹ sinagoga do joon ngalíin¹ fu tya' Simón coon'¹³ ruu'²¹i Dɨ́ɨ³. Ngoo²¹o Jacobo coon'¹³ Wó³ coon'¹³on. ");
INSERT INTO chqNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","'Yiiaunsáa³ Simón do raan²¹mo lɨ́ɨ¹i tsaa²¹² tyíi². Joon gasɨɨ'²¹ɨ tsá² Jesús: ―Tsaa'¹²a 'ino. ");
INSERT INTO chqNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Joon gangatyéen¹in Jesús lɨ raain¹ 'in tsatsaa'¹³ do. Joon gason'¹on cwoo²¹o 'ido. Joon mo saa'¹²a cwoo²¹o, tsifu joon gajaan¹ 'e lɨ́ɨ¹i 'ido. Joon garóon²on 'ido joon gacwoo¹o 'e dø'¹ø 'ido. ");
INSERT INTO chqNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Mo galɨcɨɨin²¹gɨ joon mo gayoin'² ñi'¹ joongɨ mi canʉʉ²¹xʉ joon gajajéei¹³ tsá² jileei'²¹ tsatsaa'¹³ lɨ siin'¹² Jesús. Joongɨ jajéei¹ tsá² jileei'²¹ 'in taai² 'in 'lɨɨi'³ alma tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","La tøøi² fuu²¹ gangatyéein¹ 'ooca'nʉ́¹ lɨ tyíin¹ Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Fúu¹mo 'in gaun'láai² Jesús. 'Láai² nii² jmoowúu¹ lɨ́ɨi¹ 'in tsá² do. Joongɨ fúu¹mo 'in 'lɨɨi'³ ga'woo¹i Jesús alma tya' tsá². Pe Jesús do jo gacwoo¹o faa'²¹ 'in 'lɨɨi'³ do tsʉ ñi¹ 'ido 'iin 'i. ");
INSERT INTO chqNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Coon²¹ jmɨɨ²¹² jéei¹, nʉʉ²¹mogɨ jiin'¹³ jo rǿø²mo jnáa¹gɨ garóon² Jesús. Joongɨ gacwa'ɨ́ɨ¹ɨ 'e fuu²¹ do. Ngoo²¹o tɨ' fuu²¹ lɨ jo 'in tsá² seein²¹gɨ. Ngafee'¹³i Dios. ");
INSERT INTO chqNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simón coon'¹³ 'in catyaai²gɨ gangalíin² nga'nee'¹³i Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Joon mo gatsee'²¹i 'ido joon gajin'²in: ―Jilee'²¹mo 'néei'² 'nʉ. ");
INSERT INTO chqNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Pe 'ii‑gɨ gañii¹i: ―Moo²¹o' lɨ caain²¹ fuu²¹ lɨ' tyan'¹. Joongɨ do‑o jon 'ná¹ cwóo³oo júu³ tyʉ́² tsʉ 'wii'¹³ joon 'e gajúu³uu ―jin'² Jesús sɨɨ'²¹ɨ 'in tsá² do. ");
INSERT INTO chqNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Joon la joon gacwo¹ Jesús júu³ tyʉ́² tya' Dios la caain²¹ lɨ tyʉ'² to² Galilea. Tsi inʉʉ cwo'¹ tya' tsá² Israel gacwoo¹o júu³ tyʉ́². Joongɨ ga'woo²¹i jileei'²¹ 'in 'lɨɨi'³ alma tya' tsá². ");
INSERT INTO chqNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Gangatyéein¹ jaain²¹ tsañʉʉ'¹ 'in nijgøøi'²¹ lɨ siin'¹² Jesús. Gajuu'²¹i 'wojníi¹i tyani Jesús joon gajin'²in: ―Lí²o'o un'láa²mo'o jna wana 'iin²¹²u'un. ");
INSERT INTO chqNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Joon galifee'¹mo‑tsi Jesús 'wii²¹² tya'a. Joon ganii'¹³o cwoo²¹o gasʉʉ²¹ tya'a. Joon gajin'²o: ―'Iin²¹²moo 'láa²mo'o. Cwo'láa²modu'u. ");
INSERT INTO chqNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Mo gajin'²in 'elo joon tsifu gajeen'²¹mo 'e jngøø'¹i. Joon ga'láa²mo coonti. ");
INSERT INTO chqNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Tsifu ga'ɨ́ɨ² Jesús júu³ pe lɨ¹ ga'ɨ́ɨ² júu³. Joon gajin'²in: ");
INSERT INTO chqNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","―Jo 'in fu'³'u coonti jiin'¹³ jaain²¹ pe cwoo'³mo'o; cwo'eei'¹³du'u untsá² 'woo'²'o 'e ga'láa²mo'o. Joon cwo'²'o Dios la gatyʉ'² Moisés to² wii'¹³ 'e galityú¹mo'o. ");
INSERT INTO chqNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Pe tsifu joon ngai'² 'in tsañʉʉ'¹ do ga'láa² 'wii²¹² jmo'²o tsá² júu³ 'ee galɨ́². 'Wii'¹³ joon Jesús jo lí²gɨ 'ii²¹ jiin'¹³ coon²¹ fuu²¹ la jøø² tsá². Ngɨɨ²¹o la caain²¹ caluu lɨ jo 'in tsá² seein²¹. Pe la caan²¹mo jalíin² tsá² 'iin²¹²in jøøi² 'ii. ");
INSERT INTO chqNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","2","Ningóo¹³xʉ tún² mo ga'í² Jesús fuu²¹ Capernaum. Joon mo galiñii¹ tsá² tyíin¹in coon²¹ inʉʉ galicaain²¹ tsá² fúui¹ lɨɨlɨ¹. Gacuui'¹ tsá² jiin'¹³ jo 'í²gɨ inʉʉ. Jo 'í²gɨ tsá² 'ooca'nʉ́¹. Joon Jesús gacwoo¹ júu³ tyʉ́² tya' Dios. ");
INSERT INTO chqNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","La 'ɨɨ²¹² joon tyaliin¹in tyúuin² tsañʉʉ'¹. Jée¹i jaain²¹ tsá² sɨtsʉʉ'¹³. Jo lí²gɨ nii'¹²i cwoo²¹o tɨɨ²ɨ. ");
INSERT INTO chqNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Pe jo lí² tyaliin¹ ca tɨ lɨ siin'¹² Jesús 'wii'¹³ fúui¹ lɨɨlɨ¹ tsá² taai² inʉʉ do. Joon ganáa¹ coon²¹ too²¹ lɨ 'yʉ' 'nʉ́¹. Náa¹a 'yʉ' lɨ tyíin¹ Jesús. Joon lɨ ganáa¹ do‑o, joon gaxiia²¹ 'in tsatsaa'¹³ do tsíin² ni tyi¹. ");
INSERT INTO chqNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Mo ganí² Jesús 'e jo'¹o lɨ́ɨ²i 'in tsá² tyúuin² do. Joon gajin'² Jesús sɨɨ'²¹ɨ 'in tsatsaa'¹³ do: ―Yʉʉn²¹ tyiia, 'íin¹³moo tsaa² tyi'i. ");
INSERT INTO chqNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Pe 'inlɨ́ɨi¹³ tɨfo'² tya' ley 'in néei¹ do ga'ɨ¹‑tsi: ");
INSERT INTO chqNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿'Ee lɨ 'e faa'²¹ 'in tsañʉʉ'¹ lo la no? Júu³ 'laa'²¹ tya' Dios faa'²¹ 'ino. Jiin'¹³ jaain²¹ jo lí² 'íin² tsaa² tya' tsá². Jiin'¹³ 'ña'a Dios lí² 'íin² tsaa² tya' tsá²”. ");
INSERT INTO chqNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ñi¹ Jesús 'ee 'ɨ¹‑tsi 'in tɨfo'² joon gajin'²in: ―¿'Ee lɨ 'ɨ¹‑'oo' la no? ");
INSERT INTO chqNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Noo 'e jo taai²¹gɨ fuu²¹²uu 'in tsatsaa'¹³ no: “'Íin¹³moo tsaa² tyi'i”, sɨ fuu²¹²uu 'ee; “Ráan²un no, saa'¹³ tyi¹ raan¹un ni no joon ngɨ² no”? ");
INSERT INTO chqNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Pe joon cwolini²ii' 'e jna‑a 'in Ruu'²¹na Tsá² mo taan¹na fu juncwii²¹ lii'²¹oo 'íi¹³na tsaa² tya' tsá². Ñíi²duu' 'elo ―jin'² Jesús sɨɨ'²¹ɨ tɨfo'² do. Joon gajin'² Jesús sɨɨ'²¹ɨ 'in tsatsaa'¹³ do: ");
INSERT INTO chqNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―'Nʉ‑ʉ fuu²¹²uu, ráan²un no, saa'¹³ tyi¹ raan'un no, joon cweei'² fu tyi'i. ");
INSERT INTO chqNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Tsifu joon 'in tsatsaa'¹³ garóon²on 'a lɨ raain¹ do. Joon saa'¹²a tyi¹ tya'a do joon gacwo'ɨ́ɨ¹ɨ la jǿø² jileei'²¹ 'in taai² do. 'Wii'¹³ joon jilee'²¹mo ganga'goo²¹‑tsi. Joon gacwo'¹o 'maai'¹³ Dios joon gajin'²in: ―Jiin'¹³ coon²¹ 'naa'¹³ jo mo nee²¹e' 'e la no. ");
INSERT INTO chqNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Mi la cɨɨin²¹ tún¹ ngóo¹ Jesús tɨ' tyíia¹ do. Joon jileei'²¹ tsá² ngalíin² lɨ siin'¹²in. 'E'²e Jesús 'ido. ");
INSERT INTO chqNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","La 'ɨɨ²¹² mo ngɨɨ¹ Jesús do ganíi²in Leví jóon¹ Alfeo. Leví do coon²¹ 'laa'¹³ lɨ cɨ¹ tsá² 'laa'¹³. Joon gajin'² Jesús sɨɨ'²¹ɨ 'ido: ―Moo²¹o' coon'¹³ jna. Joon garóon² Leví fu lɨ tyíin¹in joon ngoo²¹o coon'¹³on. Joon lɨ́ɨ¹ fúui¹ 'in coon²¹ 'laa'¹³ coon'¹³ 'in 'oo² tsaa² ngaliin¹ coon'¹³on. ");
INSERT INTO chqNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Joon gatø'¹ Leví Jesús ngaa'¹²in coon'¹³ 'ido fu tya'a. Joon fúu¹mo 'in cón² 'laa'¹³ coon'¹³ 'in 'oo² tsaa² tyaliin¹ lɨ néei¹ Jesús. Caa²¹mo néei¹ coon'¹³ Jesús joon coon'¹³ tsá² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ganí² tɨfo'² tya' ley coon'¹³ tsá² coon²¹ poo²¹² sii²¹ fariseos 'e néei¹ gø'²ø 'uun'²¹un jilee'²¹mo coon'¹³ Jesús. Joon gajin'²in sɨɨ'²¹ɨ 'in tsá² ngɨ¹ coon'¹³ Jesús do: ―¿'Ee lɨ' tyíin¹ tɨfo'² tyii' gø'²ø 'uun'²¹un coon'¹³ 'in cón² 'laa'¹³ coon'¹³ 'in 'oo² tsaa² tyi¹? ");
INSERT INTO chqNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Mo ganúu²un Jesús 'elo joon gajin'²in: ―Jileei'²¹ 'in tyúi¹ jo 'neei¹ tɨmɨ́¹ tya' 'i. Pe jileei'²¹ 'in tsaa'¹³ 'ii 'neei¹ tɨmɨ́¹ tya'a. Jo goo²¹² jna wa'a tø'³øø 'in tyúi¹, gagoo²¹²oo wa'a tø'³øø 'in 'oo² tsaa² ―jin'² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Mo lɨ́ɨi¹³ gajmaa¹a tsá² tya' Wó³ taa'²¹a tyani Dios joon jo gagøø'²¹ø. Coon²¹ 'naa'¹³ mo jmaa¹a la joon coon'¹³ tsá² fariseos 'inlɨ́ɨi¹³ tsá² ngaliin¹ lɨ siin'¹² Jesús. Joon gajin'² 'in tsá² do sɨɨ'²¹ɨ Jesús: ―Jmoo¹o tsá² tya' Wó³ coon'¹³ fariseos taa'²¹a tyani Dios. Jo gøø'²¹ø. ¿'Ee lɨ jo jmoo¹o tsá² tyi'nʉ‑gɨ la no? ");
INSERT INTO chqNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Joon gañii¹i Jesús: ―Mo tsalíin² tsá² coon²¹ lɨ cui'² cwoo²¹ tsá² 'e gó jmoo¹o wa'a jo gø'² mo gø'² 'in tsá² gacui'² cwoo²¹ do. Jo lí² wa'a jo gø'²ø. ");
INSERT INTO chqNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pe coon²¹ jmɨɨ²¹² jéei¹ 'e jo taain²¹²gɨ 'in tsá² cui'² cwoo²¹ do joon lí² jmáa¹a tsá² taa'²¹a tyani Dios joon jo dø'¹ø. ");
INSERT INTO chqNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Jiin'¹³ jaain²¹ jo toon'¹ 'mɨ'² sɨɨin'¹³ coon'¹³ ca 'no'³ 'mɨ'² 'mɨ́ɨ². Wa'a jmoo¹o tsá² la joon mo tsʉ'² 'e 'no'³ 'mɨ'² 'mɨ́ɨ² do joon ilifee'¹gɨ 'e 'gɨɨ²¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Joongɨ jiin'¹³ jaain²¹ jo tyii'²¹a jmɨ'³ móo¹ tsi loo²¹ tsáai². Wana jmoo¹o tsá² la joon, joon mo 'ya'² jmɨ'³ móo¹ do joon idyii¹i 'e loo²¹ tsáai² do. 'Láa²mo jmɨ'³ móo¹ itsa'ɨ́ɨ¹. Joongɨ tsa'ɨ́ɨ¹ 'e loo²¹ do. 'Wii'¹³ joon tyiia'²¹ tsá² jmɨ'³ móo¹ do tsi loo²¹ 'mɨ́ɨ² ―jin'² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Coon²¹ jmɨɨ²¹² mo 'ii'²¹ 'woo'²¹ tsá² ngaliin¹ Jesús coon'¹³ tsá² tya'a jee²¹² coon²¹ lɨ injná² trigo. Pe 'in tsá² tya'a do ga'láa² 'wii²¹² cuun¹un mi'³ trigo la 'ɨɨ²¹² gangɨ́ɨ¹i. ");
INSERT INTO chqNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Joon gajin'² tsá² fariseos sɨɨ'²¹ɨ Jesús: ―Jǿø², ¿'ee lɨ' jmoo¹o tsá² tyi'i la no? Jo tɨ́ɨi² jmáa¹a to² mo jmɨɨ²¹² mo 'ii'²¹ 'woo'²¹ tsá². ");
INSERT INTO chqNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Pe 'i‑gɨ gajin'²in: ―'Naa'‑a, ñii²oo' la lɨ 'e gajmaa¹a 'lɨɨ²¹² David. David do coon'¹³ tsá² tya'a gauntyéen²in jmɨɨ²¹² joon gatsaun'aai². Jaain²¹ tsá² sii Abiatar tyʉ'²ʉ to² tya' jileei'²¹ untsá² yiia'¹³ joon. Joon David ga'ii²¹ tsi inʉʉ tya' Dios. Joon gagøø'²¹ø 'e 'iñi'¹ nicwaai'³ do. Pe jiin'¹³ untsá² tɨ́ɨ²i dø'¹ø 'e 'iñi'¹ do. Joongɨ gacwo'² David 'e 'iñi'¹ do ca 'in tsá² ngɨ¹ coon'¹³on do. ");
INSERT INTO chqNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","’Gajmaa¹a Dios jmɨɨ²¹² 'ii'²¹ 'woo'²¹ tsá². 'E jmɨɨ²¹² do gajmaa¹a Dios 'e uncoon'¹³on tsá² jon'on gajmee¹i Dios tsá² wa'a 'e uncoon'¹³on 'e jmɨɨ²¹² do. ");
INSERT INTO chqNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Wii'¹³ joon 'in Ruu'²¹na Tsá² lí²‑i tyʉ'² to² tya' jmɨɨ²¹² mo 'ii'²¹ 'woo'²¹ tsá² ―jin'² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ga'ii²¹ tún¹ Jesús 'e cwo'¹ tya' tsá² Israel. Mo gatyiia²¹ do joon tyíin¹ jaain²¹ tsá² 'in tuu'²¹ cwoo²¹. ");
INSERT INTO chqNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Joon gacón² tsá² fariseos cwáain¹ wana un'láa²i Jesús 'ii mo jmɨɨ²¹² 'ii'²¹ 'woo'²¹ tsá². Joon 'e ilí² xiia'la i'nɨ́ɨ¹i Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Joon gajin'² Jesús sɨɨ'²¹ɨ 'in tsá² tuu'²¹ cwoo²¹o do: ―Ráan²un no; jmaa² siin'¹²u'un tún² tsa'¹ lo. ");
INSERT INTO chqNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Joon gaunngɨɨ¹ɨ Jesús 'in tsá² catyaai² do: ―¿'Ee tɨ́ɨ²na' jmoo²¹o' mo jmɨɨ²¹² 'ii'²¹ 'woo'²¹ tsá², 'e tyʉ́² sɨ 'e gó² 'ee? ¿Tɨ lí² un'láa²na' tsá² sɨ 'e jngaa'¹²na' tsá² 'ee? ―gajin'² Jesús. Pe 'in catyaai² do lɨgoon gajaan¹ tii². ");
INSERT INTO chqNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Joon gajǿøi² Jesús 'in néei¹ do. Nii'²¹‑tsi Jesús tya'a. Joon fa'í³ lɨ́ɨi² 'wii'¹³ jo 'iin²¹²in 'ido 'øøi'²¹‑tsi. Joon gasɨɨ'²¹ɨ Jesús 'in tsatsaa'¹³ do: ―Nii'¹³ cwoo¹'o no. Joon ganii'¹²in 'ido cwoo²¹o. Joon ga'lóo² cwoo²¹o coonti. ");
INSERT INTO chqNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Joon ga'woo²¹mo jileei'²¹ tsá² fariseos joon gasɨ́ɨ²i coon'¹³ tsá² tya' Herodes xiiala ilí² jngaa'¹²mo Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Joon gangalíin² Jesús coon'¹³ tsá² tya'a tɨ' tyíia¹. Joon lɨɨlɨ¹ fúui¹ tsá² seein²¹ Galilea ngalíin² caluu Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Mo galiñi¹ tsá² jilaa'²¹ 'e jmoo¹o Jesús lɨ́ɨ¹ fúui¹ tsá² seein²¹ Judea ngalíin² ngajǿøi² Jesús. Joongɨ jalíin² tsá² seein²¹ Jerusalén coon'¹³ tsá² seein²¹ Idumea, joongɨ coon'¹³ tsá² seein²¹ lɨ' ngoo'¹³ jmɨɨ²¹ Jordán jalíin². Joon jalíin² tsá² ca tɨ́² lɨ tyʉ'² to² fuu²¹ Tiro coon'¹³ 'in jalíin² ca tɨ́² lɨ tyʉ'² to² fuu²¹ Sidón. Jileei'²¹ tsá² lo ngalíin² ngajǿøi² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","'Wii'¹³ fúui¹ lɨɨlɨ¹ tsá² seein²¹ joon gajin'² Jesús sɨɨ'²¹ɨ tsá² tya'a: ―Tyaa²aa' tyʉ́² coon²¹ barco joon jo lí² 'la'²a 'in tsá² fúui¹ lɨɨlɨ¹ no. ");
INSERT INTO chqNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Lɨɨlɨ¹ fúui¹ tsá² nigaun'láai² Jesús. Joon jilee'²¹mo tsatsaa'¹³ leei'¹² ruu'²¹i 'iin²¹²in soon'²¹ tya' Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Joon mo ní² jileei'²¹ tsá² 'in taai² 'in 'lɨɨi'³ alma tya'a joon gasii'²¹i 'wojníi¹i tyani Jesús joon ga'oo¹o jin'²in: ―Jóon¹ Dios 'nʉ. ");
INSERT INTO chqNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Pe Jesús tyʉ'² to² sɨɨ'²¹ɨ 'ido: ―Jo fó³oo' coonti 'iin jna. ");
INSERT INTO chqNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Mo gangayuui'¹³ joon gasóo²o Jesús coon²¹ moo'²¹. Joon gatø'¹ Jesús jiin'¹³ 'in 'iin²¹²in. Joon ngalíin² 'in tsá² do lɨ siin'¹²in. ");
INSERT INTO chqNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Joon gajmaa¹a Jesús coon²¹ poo²¹² ti dyatuuin¹. 'Ii ingɨ¹ coon'¹³on. Joongɨ sii¹in 'ido tsacwoo¹ júu³ tyʉ́² tya' Dios. ");
INSERT INTO chqNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Joon gatyʉ'² Jesús to² 'e un'láai² tsatsaa'¹³ joongɨ 'wooi²¹ jileei'²¹ 'in 'lɨɨi'³ taai² alma tya' tsá². ");
INSERT INTO chqNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","'In lo‑o jee²¹² 'in dyatuuin¹ do: Simón, 'in sii²¹o jon Tʉ́³. ");
INSERT INTO chqNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jacobo coon'¹³ ruu'²¹i Wó³, 'in jóon¹ Zebedeo. Jacobo coon'¹³ Wó³ do gaunsii²¹ Boanerges. 'øøi'²¹‑tsi tsá² 'e taain¹ sii²¹ 'Óon² Cwaain'ña³ 'wii'¹³ tsifu li'nii'²¹‑tsi. ");
INSERT INTO chqNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","'In catyaai² do sii²¹ Dɨ́ɨ³, Lii²¹², Bartolomé, Untøø², Tomóo¹³, Jacobo jóon¹ Alfeo, Tadeo, Simóoi¹³ tsá² tya' coon²¹ poo²¹² sii²¹ cananistas, ");
INSERT INTO chqNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","coon'¹³ Judas Iscariote 'in gajaain'¹³ Jesús mo galɨcɨɨin²¹gɨ. Mo galɨcɨɨin²¹ joon ga'ii²¹ Jesús coon²¹ tsi inʉʉ coon'¹³ tsá² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Joon galicaain²¹ tsá² fúui¹ lɨɨlɨ¹ jiin'¹³ jo jøø²i dø'¹ø. ");
INSERT INTO chqNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Mo galiñi¹ ruu'²¹i Jesús joon jin'²in 'e nicaa²¹²mo Jesús. Joon gajalíin² 'iin²¹²in tøø¹ø tyitsaa²¹mo 'ido. ");
INSERT INTO chqNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Joongɨ 'in tɨfo'² tya' ley 'in jalíin² tɨ' Jerusalén gajin'²in: ―Beelzebú 'yuui² alma tya' 'ino. 'Wii'¹³ joon lí²‑i 'woo²i 'in 'lɨɨi'³ taai² alma tya' tsá² ―gajin'² 'in tsá² do. (Beelzebú sii²¹ 'in 'lɨɨi'³ 'in tyʉ² to² tya' 'in 'lɨɨi'³ catyaai².) ");
INSERT INTO chqNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Joon gatø'¹ Jesús 'in tɨfo'² tya' ley do. Joon ga'e'²e 'ido coon'¹³ coon²¹ cwáain¹ do jin'²in: ―¿Xiiala lɨ Satanás tyíi¹in 'ña'a? ");
INSERT INTO chqNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Wana jee²¹² gobierno tya' tsá² téein¹ la 'oo'²¹ 'ii, 'e gobierno do jo itaa'²¹a. ");
INSERT INTO chqNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Wana la 'oo'²¹ tsá² inʉʉ tya' tsá² tɨ́ɨ¹i pe 'in tsá² inʉʉ do jo itaa'²¹a. ");
INSERT INTO chqNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Joon wana 'in 'lɨɨi'³ 'in tyʉ'² Beelzebú to' jmoo¹o 'nii²¹ la 'oo'²¹ jee²¹² 'ii joon jo itaa'²¹a. Jéei¹gɨxʉ 'ii‑o ityée¹mo coonti. ");
INSERT INTO chqNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Jiin'¹³ jaain²¹ jo lí² 'ii²¹ coon²¹ lɨ tyíin¹ jaain²¹ tsañʉʉ'¹ gøøi'¹³ wana jo jéei¹gɨ 'ñuui² tsá² 'ii. Pe wana jéei¹gɨ 'ñuui² tsá² 'ii joon lí²‑i 'woo² tsá² jilaa'²¹ 'e 'oo¹o. ");
INSERT INTO chqNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’E la ja'²mo fuu²¹²uu 'naa'. Jileei'²¹ tsá² 'in 'oo¹o tsaa² lí²‑i 'íin²in Dios tsaa² tya' 'ii coon'¹³ jilaa'²¹ 'e gó² 'e faa'²¹a. ");
INSERT INTO chqNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Pe jileei'²¹ 'in faa'²¹a 'e gó² tya' 'in Espíritu Tyʉ́² tya' Dios coonti jo 'ín² Dios tsaa² tya' 'i. Tsaa² tya'a taa'²¹a coon²¹ tøø²mo. ");
INSERT INTO chqNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","La joon gajin'² Jesús sɨɨ'²¹ɨ 'ido 'wii'¹³ gajin'²in tsá² do 'e 'ii‑o 'yuui² 'in 'lɨɨi'³ alma tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Mo lɨcɨɨin²¹gɨ joon gatyalíin² sáa³ Jesús coon'¹³ ruu'²¹i. Joon gajaan¹an caluu. Joon gatø'¹ø Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Jileei'²¹ 'in néei¹ co' lɨ tyíin¹ Jesús gajin'²in: ―Saa²'a coon'¹³ ruu'²¹'u no‑o natéein² ca'nʉ́¹ 'naa'¹i 'nʉ. ");
INSERT INTO chqNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Pe joon Jesús gajin'²in sɨɨ'²¹ɨ 'ido: ―¿'Iin sáa³aa joon 'iin ruu'²¹na? ");
INSERT INTO chqNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Joon gajǿø²ø Jesús la 'ui. Jǿø²mo jilee'²¹mo 'in néei¹ coon'¹³on joon gajin'²in: ―Jileei'²¹ 'in néei¹ coon'¹³ jna lo 'ii sáa³aa joongɨ 'ii ruu'²¹na. ");
INSERT INTO chqNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Tsʉ la jaain²¹ 'in jmoo¹o la to² tyʉ'² Dios 'ii ruu'²¹na joongɨ 'ii sáa³aa ―jin'² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Coongɨ tún¹ ga'láa² Jesús 'wii²¹² 'e 'e'²e tsá² júu³ tyʉ́² 'a tɨ' tyíia¹ do. Lɨɨlɨ¹ fúui¹ tsá² galicaain²¹. 'Wii'¹³ joon ga'í²i Jesús tsi coon²¹ barco 'íi¹ ni jmɨɨ²¹ joon do‑o gacwoo²¹. Pe jilee'²¹mo tsá² gajaan¹ tɨ' jmɨɨ²¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Gasɨɨ'²¹ɨ Jesús 'in tsá² do 'láai² cwáain¹. Joon mo 'e'² Jesús 'in tsá² do joon gajin'²in: ");
INSERT INTO chqNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―'Nʉʉ²duu' 'elo. Lawa jaain²¹ tsá² 'in ngó¹ gangajñi¹ trigo. ");
INSERT INTO chqNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Mo gadya'²xʉ 'e trigo do joon gaxʉʉ'²¹xʉ mɨ'³ trigo do tɨ' fu¹. Joon tsifu gatyalíin² ton¹ joon gagøø'²¹o 'edo. ");
INSERT INTO chqNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","'Elɨ́ɨi¹³gɨ mɨ'³ do gaxʉʉ'²¹ jee²¹² cuun²¹² lɨ jo 'e cwoo'¹³ náa¹ 'láai². Joon 'e trigo do tsifu ga'yiia²¹ 'wii'¹³ jo 'láai² cwoo'¹³ náa¹ lɨ gaxʉʉ'²¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Joon mo ga'yeei²¹ ñi'¹ galifin'³in 'wii'¹³ jo jmóo³ 'láai² sá². Joon galityʉʉn²¹. ");
INSERT INTO chqNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","'Elɨ́ɨi¹³gɨ mɨ'³ gaxʉʉ'²¹ jee²¹² 'motóon¹. Pe 'motóon¹ do jmoonogɨ gacwaain²¹. Joon galipii'³ 'e trigo do. La do‑o jon jo lí² cwo¹ mi'³ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Joon 'elɨ́ɨi¹³gɨ mɨ'³ gaxʉʉ'²¹ jee²¹² cwoo'¹³ 'oo'³. Joon mo ga'yiia¹ joon gacwáan¹mo tyʉ́². Tsifu gacwo¹ mɨ'³ tya'a. 'Elɨ́ɨi¹³ mɨ'³ do gacwo¹ dyadya¹ mɨ'². 'Elɨ́ɨi¹³gɨ gacwo¹ sesente mɨ'³. 'Elɨ́ɨi¹³gɨ ca cíein¹³ mɨ'³ gacwo¹ 'e trigo do. ");
INSERT INTO chqNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Joongɨ jin'² Jesús: ―Wana sá² loocwoo¹oo', nʉ́ʉ²duu'. ");
INSERT INTO chqNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Mo ngayuui'¹³ joon gatuui¹ Jesús yaai. Jiin'¹³ 'in téein²gɨ co' lɨ siin'¹²in joongɨ jiin'¹³ dyatuuin² tsá² tya'o gajaan¹gɨ coon'¹³on. Joon gaunngɨɨ¹ɨ 'ii: ―¿'Ee 'øøi'²¹‑tsi tsá² 'e júu³ gatya'²'a do? ");
INSERT INTO chqNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Joon gajin'² Jesús sɨɨ'²¹ɨ 'ido: ―Ca jiin'¹³ 'naa' nigacwoo¹o Dios 'e 'øøi'²¹‑'oo' júu³ 'uuin²¹ tya'a tya' xiiala tyʉ'² Dios to² tsá². Pe jileei'²¹ 'in catyaai² do jmaai'¹³ coon'¹³ cwáan¹mo nuu¹un. ");
INSERT INTO chqNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Lí²‑i jǿø² 'ido pe jo ñi¹‑i 'ee jnéei². Nuu¹o pe jo 'øøi'²¹‑tsi. Pe wana tsáai¹‑tsi 'e jnéei² joongɨ 'øøi'²¹‑tsi 'ee nuu¹un fowa'a niunsɨ́ɨ²mo 'e 'ɨ¹‑tsi joongɨ fowa'a 'íin²mo Dios tsaa² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Joon gajin'² Jesús sɨɨ'²¹ɨ 'ido: ―¿Xiiagɨla 'øøi'²¹‑'oo' 'e cwáain¹ catyiia² do wa jo 'øøi'²¹‑'oo' 'e cwáain¹ lo? ");
INSERT INTO chqNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","'Iin gajñi¹ jún² trigo do lɨ́ɨi¹ lawa'a 'in tsá² 'in 'e¹ júu³ tyʉ́². ");
INSERT INTO chqNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Joon 'inlɨ́ɨi¹³ tsá² lɨ́ɨi¹ la lɨ 'e jún² trigo 'e gatoo'²¹ co' fu¹. Nuu¹o júu³ tyʉ́² pe mo galicɨɨin²¹ 'a ganúu²un do joon jó² Satanás tyii²¹ tún¹ 'e júu³ tyʉ́² do 'e nataa'¹³ alma tya' tsá². ");
INSERT INTO chqNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","'Inlɨɨi¹³gɨ lɨ́ɨi¹ la lɨ jún² 'e gangajna² jee²¹² cuun²¹². Nuu¹o 'ido júu³ tyʉ́² joon 'ii'²¹mo røø²¹. ");
INSERT INTO chqNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Pe jo gatoo'¹³ jmóo³ 'láai² joon jo taa'²¹a. Ce tsifu 'e gatoo'¹³ fa'í³ tya'a sɨ 'e 'in 'eei'¹ 'ii 'wii'¹³ núu²un júu³ tyʉ́² joon tʉʉ²o júu³ tyʉ́². Jo seein'¹ tá². ");
INSERT INTO chqNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","'Inlɨ́ɨi¹³gɨ lɨ́ɨi¹ la lɨ jún² 'e gangajna² jee²¹² 'motóon¹. Nuu¹o 'ido júu³ tyʉ́². ");
INSERT INTO chqNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Pe lɨ́ɨ¹ 'ɨ¹‑tsi jilaa'²¹ 'e sá² fu juncwii²¹. 'ɨ¹‑tsi 'e lisá² cuu², joon cuu² do coon'²¹ 'ii tóo². Joon 'iin²¹²in jilaa'²¹ 'e catyiia². Jilaa'²¹ 'elo lɨ¹ 'ɨ¹‑tsi tsá² jiin'¹³ jo jøøi²gɨ wa'a 'ɨ¹‑tsi júu³ tyʉ́². Joon jo nʉʉ'¹³gɨ. ");
INSERT INTO chqNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Pe 'inlɨ́ɨi¹³gɨ núu²o joon 'ii'²¹mo júu³ tya' Dios. Joon jmaa¹o la to² tyʉ'² Dios. 'Ii lɨ́ɨi¹ la lɨ jún² 'e gangajna² lɨ cwoo'¹³ 'oo'³. 'Inlɨ́ɨi¹³ lɨ́ɨi¹ la lɨ jún² 'e gacwo¹ dyadya¹ mɨ'³. 'Inlɨ́ɨ¹³gɨ lɨ́ɨi¹ la lɨ jún² 'e gacwo¹ sesenta mɨ'³ sɨ la lɨ 'e gacwo¹ cíein¹³ mi'³ do 'ee. ");
INSERT INTO chqNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Joon gajin'²o jon Jesús: ―Wana tyan¹ tsá² coon²¹ jɨ́² coo²¹, ¿tɨ sii'²¹i tsi cajóoi¹³ sɨ nʉ' coo'mó² 'ee? Jo jmoo¹o tsá² la joon. Lɨ yʉ' 'ɨ́ɨ² tsá² jɨ́² coo²¹ do joon coon'¹³ la joon jnée²mo tsá². ");
INSERT INTO chqNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Jilaa'²¹ 'e sɨ'mo² nano 'ná¹‑a jnéei² mi lɨcɨɨin²¹gɨ. Joon jiin'¹³ coon²¹ júu³ 'uuin²¹ ilisá² wa'a jo liñi¹ tsá². ");
INSERT INTO chqNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Wana sá² loocwoo¹oo', nʉ́ʉ²duu'. ");
INSERT INTO chqNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Joongɨ jin'² Jesús: ―Tyán²duu' cwáain¹ jilaa'²¹ 'e nuu²uun'. Jileei'²¹ 'in núu²unxʉ, xʉ jon i'øøi'²¹‑tsi. Pe jileei'²¹ 'in núu²un coon'²¹ ce tún² joon tyʉ́²‑ʉ 'øøi'²¹‑tsi. ");
INSERT INTO chqNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Joongɨ jileei'²¹ 'in tyʉ́² 'øøi'²¹‑tsi joon i'øøi'²¹gɨ‑tsi. Pe jileei'²¹ 'in xʉ 'øøi'²¹‑tsi joon 'íin²mo‑tsi jiin'¹³ 'e xʉ 'øøi'²¹‑tsi do. ");
INSERT INTO chqNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Faa'³¹gɨ Jesús jin'²in: ―La tyʉ'² Dios to² la joon lɨ́¹ mo jaain²¹ tsañʉʉ'¹ gajnii¹ jún² ni 'wó². ");
INSERT INTO chqNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Mi ngayuui'¹³ joon tsacwuu²¹mo. Mi lɨ cɨɨin²¹xʉ tún² joon róon²o. Joon 'láa²mo jmɨɨ¹ coon'¹³ 'woo¹ gangɨ́ɨi¹³. 'A jún² do nii'¹³i joon cwaain²¹ pe jo ñi¹ tsá² xiiala cwaain²¹. ");
INSERT INTO chqNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Coon'¹³ 'ña'a cwoo'¹³ do cwaain²¹ do. Nifu 'yeei'²¹ mo'² tya' joongɨ tóon¹ tya'a joongɨ tsatoo'¹³ mɨ'³ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Mo naróo² mɨ'³ tya'a joon tsatyʉʉ'²¹ tsá², tsatyiian¹ tsá² tsʉ gatɨ́² tiempo 'e garoo²¹. ");
INSERT INTO chqNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Joon gajin' Jesús: ―'E júu³ lo lɨ la lɨ 'e cwáain¹ fuu²¹²uu 'naa'. ");
INSERT INTO chqNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Lawa coon²¹ mɨ'³ jún² tya' mostaza 'e jñí² tsá² ni 'wó². 'E joon jún² 'e pii'³gɨ la jee²¹² jilaa'²¹ jún² 'e sá² ni cwoo'¹³ juncwii²¹. ");
INSERT INTO chqNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Pe mi jñí² tsá² joon cwaain²¹ coo'¹³gɨ lagɨ jilaa'²¹ 'oonuu²¹. Tsí³ cwáa¹ coo'¹³ ca ton¹ 'in 'ɨɨi¹ lɨ' yʉ' lí²‑i cwaa²¹ nʉ' 'iin'³ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","La joon ga'e'² Jesús tsá² júu³ tyʉ́² coon'¹³ 'láai² cwáain¹ la lɨ́¹ 'elo. Ga'e'² Jesús tsá² ca jiin'¹³ tɨ lí² 'øøi'²¹‑tsi tsá². ");
INSERT INTO chqNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Jiin'¹³ coon'¹³ jmaai'¹³ cwáan¹mo sɨɨ'²¹ɨ Jesús tsá². Jo jmaa'¹³a tsá² fúui¹ júu³ xiiala lɨ́², jiin'¹³ tsá² tya'o gajma'²a júu³ xiiala lɨ́². ");
INSERT INTO chqNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Jmɨɨ²¹² joon mo ga'i² nʉʉ²¹ joon gasɨɨ'²¹ɨ Jesús tsá² tya'a: ―Moo²¹o' lɨ' ngoo'¹³ tyíia¹ no. ");
INSERT INTO chqNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Joon natáa¹i tsá² tya' Jesús tsi barco lɨ tyíin¹ Jesús. Joon do‑o gatiui²¹ jilee'²¹mo tsá² téein² tɨ' tyíia¹ do. Joon ngaliin¹gɨxʉ barcos 'elɨ́ɨi¹³ coon'¹³on. ");
INSERT INTO chqNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Pe joon garoon¹on coon²¹ tyí² tá² lɨɨlɨ¹. Joon gajnáa¹ jmɨɨ²¹ ca tsi barco do. La do‑o garøøi¹ jmɨɨ²¹ tsi barco tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Joon raain¹ Jesús cwuu²¹i ca tɨ́² tʉ'mɨɨ² barco do. Cwuu²¹i tsín² mootyíi¹i coon²¹ ni tu'mɨ'²xʉ. Joon gaunjnaa¹‑tsi tsá². Joon gajin'²in gasɨɨ'²¹ɨ 'ii: ―¡Tɨfo'² tyii'i! ¿Tɨ jo cwáain¹ tyi'i 'e júun²mo'? ");
INSERT INTO chqNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Joon garóon²on Jesús. Joon gatyuu'¹³mo 'e tyí² do. Joon gasɨɨ'²¹ɨ jmɨɨ²¹: ―Jo too'²¹ mɨɨ'¹³, catii². Joon tsifu gajaan¹ 'e tyí² do. Jilaa'²¹ ga'ɨ́ɨ² tii². ");
INSERT INTO chqNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Joon gasɨɨ'²¹ɨ Jesús tsá² tya'a: ―¿'Ee lɨ' 'goo'²¹ 'lɨɨ'²¹? ¿'Ee lɨ' jo jai'² lɨ́ɨi²gɨɨ' Dios? ");
INSERT INTO chqNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Jileei'²¹ tsá² tya'a gafoo'¹i lɨɨlɨ¹ joon sɨ́ɨ²i jee²¹² 'ii: ―¿'Iin‑gɨ lo no? Jilaa'²¹ tyí² joon jilaa'²¹ jmɨɨ²¹ nʉʉ'¹³ʉn to² tyʉ'² 'ino. ");
INSERT INTO chqNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Mo gatyalíin² lɨ' ngoo'¹³ tyíia¹ cataain²¹ do lɨ seein²¹ tsá² Gadara. ");
INSERT INTO chqNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Mo gacwo'ɨ́ɨ¹ Jesús tsi barco do joon gajó² jaain²¹ tsá² 'in 'yuui² 'in 'lɨɨi'³ alma tya'a. Jee²¹² 'aan¹ tya' 'lɨɨ²¹² cwo'ɨ́ɨ¹i 'in tsá² do. ");
INSERT INTO chqNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Tsʉ jee²¹² 'aan¹ tya' 'lɨɨ²¹² do ni taain¹ 'in tsá² do. Jiin'¹³ jaain²¹ jo lí² 'ñúu¹i. Jon'on coon'¹³ ñí³ lí² 'ñúu¹i. ");
INSERT INTO chqNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Lɨ́ɨ¹ 'láai² naa'¹³ niga'ñúui¹ tsá² 'ii coon'¹³ ñí³. Ni'ñʉ́ʉ² tsá² tɨɨ² cwoo²¹ pe joon tsifu 'gɨɨ¹o 'e 'ñʉ́ʉ¹ cwoo²¹. Joon jmoo¹o 'no'³ 'e 'ñʉ́ʉ¹ tɨ́ɨ¹ɨ. Jo 'e lí² 'woo¹‑tsi. ");
INSERT INTO chqNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Lɨ' jmɨɨ¹ tiin'¹³ lɨ' 'woo¹ ngɨɨ¹ la caain²¹ moo'²¹ joon la caain²¹ jee²¹² 'aan¹ tya' 'lɨɨ²¹² 'oo¹o taa²¹ lɨɨlɨ¹. Joongɨ tyuu'¹²i 'ña'a cuun²¹². ");
INSERT INTO chqNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Pe joon wíin²gɨ mo ganíi² Jesús. Joon tsifu cwiin¹ ngóo¹o ngasii'¹i 'wojníi¹i tyani Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Mi yuui'¹³ joon gajin'² Jesús sɨɨ'²¹ɨ 'in 'lɨɨi'³ 'yuui² alma tya'a: ―Tíui¹ 'in tsañʉʉ'¹ no. Joon ga'oo¹o tá² lɨɨlɨ¹ 'in 'lɨɨi'³ do 'in 'yuui² alma tya' 'in tsañʉʉ'¹ do jin'²in: ―¿'Ee 'ná¹ jmáa³aa coon'¹³ 'nʉ? Jóon¹ Dios 'in tyíin¹ ñʉ'fú² 'nʉ. Mɨ́³ɨɨ tyani'i tyani Dios jo jmáa¹u'un jna. ");
INSERT INTO chqNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Joon gaunngɨɨ¹ Jesús 'ii: ―¿Xiiala sii²¹ 'nʉ? Joon gañii¹i 'in 'lɨɨi'³ do: ―Legión sii²¹ jna'a 'wii'¹³ lɨɨlɨ¹ fúu²u'u saan²¹a'an joon sii²¹ jna'a la joon. ");
INSERT INTO chqNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Lɨ́ɨ¹ gamɨɨ¹ 'in 'lɨɨi'³ do tyani Jesús 'a jo 'ǿøi¹ 'ido 'ii. ");
INSERT INTO chqNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Joon lɨɨlɨ¹ fúui¹ ñí¹ taain²¹² gøø'²¹ coon²¹ tsa'² moo'²¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Joon 'in 'lɨɨi'³ do gasɨɨ'²¹ɨ Jesús jin'²in: ―Siin¹ jna'a fu lɨ taain²¹² ñí³ do. Cwo'²'o júu³ wa'a tsatoo²o'o alma tya' ñí¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Joon gacwoo¹ Jesús 'ii júu³. Tsifu gacwo'ɨ́ɨ¹ 'in 'lɨɨi'³ taai² alma tya' 'in tsañʉʉ'¹ do joon gangataa²i alma tya' ñí¹ do. Taain²¹² jiin'¹³ tún² mil ñí¹ 'a tsa'² moo'²¹ do. Gacwiin¹in 'in ñí¹ do gaxuui'²¹ yaai tyisɨɨ² joon gaxuu'²¹i fu tsi tyíia¹ do. Joon gajgoo'²¹o jmɨɨ²¹. ");
INSERT INTO chqNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","'In taain²¹² 'aai²¹ ñí¹ do ngaliin¹ 'e fuu²¹ do joongɨ ngaliin¹ la caain²¹ lɨ taain²¹² tsá². Ngajmaa'¹³a tsá² júu³ 'ee‑gɨ lɨ́ɨi¹ ñí³ tya'a. Joon gangalíin² tsá² ngajǿø² 'ee galɨ́². ");
INSERT INTO chqNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Joon gatyalíin² tsá² fúui¹ lɨ siin'¹² Jesús. Joon ganí² 'in tsañʉʉ'¹ 'in mo ta 'yuui² 'in 'lɨɨi'³ alma tya'a do. Joon nityíin¹in tyi'²i sɨɨn'¹³ɨn røø²¹ jo caai²¹²gɨ. Ni'láa²mo. Joon lɨ́ɨ¹ gafoo'¹i 'in tsá² tyalíin² do. ");
INSERT INTO chqNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Joon jileei'²¹ tsá² 'in niganí² 'ee galɨ́² tyaa¹ tsá² júu³ 'in tsá² tyalíin² do xiiala galɨ́ɨi¹ 'in tsañʉʉ'¹ 'in mo ta 'yuui² 'in 'lɨɨi'³ alma tya'a. Tyaa¹o júu³ jon la lɨ́² 'e gangangɨ́ɨ¹i 'in ñí¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Joon gamɨɨ¹ tsá² fúui¹ lɨɨlɨ¹ do tyani Jesús wa'a cwo'ɨ́ɨ¹ 'ido fuu²¹ goo¹o. ");
INSERT INTO chqNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ga'ii²¹ Jesús tsi barco do. Joon 'in tsá² 'in mo ta 'yuui² 'in 'lɨɨi'³ alma tya'a gasɨɨ'²¹ɨ Jesús wa'a tsalíin² coon'¹³ 'ido. ");
INSERT INTO chqNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Pe jo gacwo¹ Jesús júu³. Joon gajin'²in sɨɨ'²¹ɨ 'ido: ―Cwei'² fu tyi'i. Cwojmaa'¹³du' júu³ ruu'²¹'u 'e fee'¹ lɨɨlɨ¹ 'e nigajmaa¹a Dios 'wii'¹³ tyi'i. Joongɨ lɨɨlɨ¹ nagalifeei'¹‑tsi Dios 'wii²¹² tyi'i. ");
INSERT INTO chqNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Joon gangaa'¹³mo 'in tsañʉʉ'¹ do. Joon ga'láa² 'wii²¹² jmo'²o tsá² júu³ la caain²¹ fuu²¹ taa'¹³ Decápolis. Gajmaa¹a júu³ 'e fee'¹ lɨɨlɨ¹ 'e nigajmaa¹a Jesús 'wii'¹³ 'ii. Joon jilee'²¹mo tsá² tsa'goo'¹‑tsi lɨɨlɨ¹. ");
INSERT INTO chqNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Gatyiia²¹ Jesús lɨ ngoo'¹³ tyíia¹ lɨ cataain²¹ do. Joon gatyalíin² tsá² fúui¹ lɨɨlɨ¹ lɨ siin'¹²in. Joon tɨ' tyíia¹ do‑o gajaan¹. ");
INSERT INTO chqNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Joon gajó² jaain²¹ tsá² 'in tyʉ'² to² cwo'¹ sinagoga. Jairo sii²¹ 'ido. Mo ganí²i Jairo Jesús joon gatyíia² 'wii²¹² tɨɨ² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Joon gamɨɨ¹ɨ tyani Jesús jin'²in: ―Ijúun²mo xuui²¹² tsamɨ́² tyiia. Jmaa² feei'¹‑'o'o 'wii²¹² tyiia. Ñí²'in; ñitaan'¹²'an cwoo¹'o tya'a. Joon cwo'láai², cwoseen²¹mo. ");
INSERT INTO chqNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Joon gangóo¹ Jesús coon'¹³ 'in tsañʉʉ'¹ do. Pe lɨ́ɨ¹ fúui¹ tsá² ngalíin² coon'¹³on. Joon lɨɨlɨ¹ cuu'¹³ lɨ ngóo¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Joon jee²¹² 'in tsá² fúui¹ do ningóo¹ jaain²¹ tsamɨ́² tsaa'¹³. Ningóo¹ jiin'¹³ dyatun¹ jiin²¹ 'e tooin²¹ jmɨ¹. ");
INSERT INTO chqNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Niganii²¹ wúu¹ lɨɨlɨ¹ 'a lɨ́² mɨ² tya'a. Joon na'íin² jilaa'²¹ 'e 'oo¹xʉ pe jo mo gajaan¹ 'e lɨ́ɨ¹i 'ido coonti, xʉ lɨ' 'e ngafuu'¹gɨ. ");
INSERT INTO chqNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Mo ganúu²un 'in tsamɨ́² do jilaa'²¹ 'e jmoo¹o Jesús ga'ɨ¹‑tsi: “Wana gason'¹oon sɨɨn'³ 'ino joon i'láa²moo.” Joon gangatyéen¹in lɨ caluu Jesús joon gason'¹on sɨɨn'³ 'ido. ");
INSERT INTO chqNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Mo gason'¹on sɨɨn'³ Jesús tsifu gajaan¹ 'e tooin²¹ jmɨ¹ do. Joon galili'³i 'e ga'láa²mo coonti. ");
INSERT INTO chqNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Joon mo galili'³i Jesús 'a naga'láa²mo jaain²¹ tsá² coon'¹³ 'ii'²¹ tya'a joon gajǿø² lɨ' caluu jee²¹² tsá² fúui¹ do. Joon gaunngɨɨ¹ɨ: ―¿'Iin gason'¹ sɨn'³ɨɨn? ");
INSERT INTO chqNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Joon gajin'² tsá² tya'a sɨɨ'²¹ɨ 'ii: ―Moo²¹o'o lɨɨlɨ¹ 'la'² tsá² tyi'i xiiala lí² unngɨ́ɨ¹u'un: “¿'Iin gason'¹ sɨn'³ɨɨn?” ");
INSERT INTO chqNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Pe jǿø² Jesús la cataain²¹ caai²¹ 'iin²¹²in 'in gason'¹ sɨɨn'³ do. ");
INSERT INTO chqNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Joon 'in tsamɨ́² do jlee¹e joongɨ 'goo'²¹o lɨɨlɨ¹ ñi¹o 'ee 'e galɨ́² do. Joon ngoo²¹o lɨ siin'¹² Jesús. Joon gasii'²¹i 'wojníi¹i tyani 'ido. Gajin'²o la ja'²mo ce jilaa'²¹ 'e galɨ́². ");
INSERT INTO chqNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Joon gajin'² Jesús sɨɨ'²¹ɨ 'in tsamɨ́² do: ―Yʉʉn²¹ tyiia, ga'láa²mo'o 'wii'¹³ jo'¹o lɨ́ɨ²u. Cwei'² júu³ røø²¹. 'Láa²mo'o coonti jmoowúu¹ lɨ́ɨ¹u'u. ");
INSERT INTO chqNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Faa'²¹gɨ Jesús siin'¹²in mo gatyalíin² tsá². Jalíin² tya' 'in tyʉ'² to² cwo'¹ do. Joon gajin'² 'in tsá² tyalíin² do sɨɨ'²¹ɨ jmii²¹ 'in xuui²¹² tsaa'¹³ do: ―Najúun²mo yʉʉn²¹ tyi'i. Jo untyíi²in‑gɨ'ɨ 'in tɨfo'² no. ");
INSERT INTO chqNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Pe Jesús, mo ganúu²un 'e faa'²¹ 'in tsá² tyalíin² do joon gajin'² Jesús sɨɨ'²¹ɨ 'in tsá² tyʉ'² to² cwo'¹ do: ―Jo foo'¹³'o, jiin'¹³ jo'¹o cwolíi²naa'. ");
INSERT INTO chqNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Joon jo 'in cwo¹gɨ Jesús tsalíin² coon'¹³on, jiin'¹³ Tʉ́³, coon'¹³ Jacobo coon'¹³ Wó³ ruu'²¹i Jacobo. ");
INSERT INTO chqNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Joon mo gatyalíin² tya' 'in tsá² tyʉ'² to² cwo'¹ do joon ganí²in Jesús tsá² fúui¹ lɨɨlɨ¹. In cɨ'² to'² mɨɨ'¹³ lɨɨlɨ¹. ");
INSERT INTO chqNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Joon ga'í²i Jesús joon jin'²in: ―¿'Ee lɨ' to'² lɨ¹ mɨɨ'¹³? ¿'Ee lɨ'cɨ'² lɨ'? Jo mo júuin² 'in xuui²¹² no lɨ'ɨ cwuu²¹mo 'ino. ");
INSERT INTO chqNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Pe 'in tsá² do gaungøø¹mo Jesús. Joon ga'wooi²¹ Jesús tsá² ce jilee'²¹mo. Joon gatø'¹ø jiin'¹³ jmii²¹ coon'¹³ sáa³ xuui²¹² tsaa'¹³ do, joongɨ fiin'¹³ coon'¹³ 'in ngaliin¹ coon'¹³on do. Joon ga'í²i lɨ raain¹ 'in xuui²¹² do. ");
INSERT INTO chqNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Gason'¹ Jesús cwoo²¹ 'ido joon gajin'²in sɨɨ'²¹ɨ xuui²¹² do coon'¹³ jmíi¹ tya'a: ―Talita cumi. ('E 'øøi'²¹‑tsi tsá² jin'²in: 'Nʉ fuu²¹²uu mí², ráan²un no.) ");
INSERT INTO chqNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Tsifu joon garóon²on 'in xuui²¹² tsamɨ́² do. Joon gangɨɨ¹o. Joon dyatun¹ jiin'²gɨ ngóo¹o. Jileei'²¹ tsá² do ganga'goo²¹‑tsi. ");
INSERT INTO chqNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Pe joon ga'ɨ́ɨ² Jesús júu³ sɨɨ'²¹ɨ 'in tsá² taai² tsi inʉʉ do: ―Jo 'iin fu'²uu' ce jiin'¹³ jaain²¹. Joon gatyʉ'²ʉ to² wa'a dø'¹ 'in xuui²¹² tsamɨ́² 'in najiin'¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Mo ngayuui'¹³ gaun'láai² Jesús 'in xuui²¹² tsamɨ́² tsaa'¹³ do joon gangaliin¹mo fu goo¹o Nazaret coon'¹³ tsá² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Mo tɨ́² jmɨɨ²¹² 'ii'²¹ woo'²¹ tsá² ga'láa² Jesús 'wii²¹² 'e 'e'²e tsá² júu³ tyʉ́² tsi inʉʉ cwo'¹ sinagoga si'² do. Joon fúu¹mo 'in núu²un 'e faa'²¹ 'ido. Joon lɨ́ɨ¹ tsa'goo²¹‑tsi tsá² joon jin'² 'in tsagoo¹o do: ―¿Xiiala galitɨ́ɨ²i 'in tsañʉʉ'¹ no 'e faa'²¹ no? ¿'Ee júu³ lo 'e¹ 'ino? ¿Xiiala jmoo¹o jilaa'²¹ milagro lo? ");
INSERT INTO chqNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","'In tsañʉʉ'¹ lo jaain²¹ tɨ'mó² 'ii. Jóon¹ María, joon ruu'²¹mo Jacobo coon'¹³ Sé³ coon¹³ Judas coon'¹³ Simóoi¹³. Joongɨ ruu'²¹i tsamɨ́² seen²¹mo jee²¹² jna' lo. La joon gajin'² tsá² Nazaret 'wii'¹³ joon jo jo'¹ lɨ́ɨ²i Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Pe joon gasɨɨ'²¹ɨ Jesús 'ii: ―Jilee'²¹mo jmoo¹o nʉʉ'¹³ʉn jaain²¹ tsá² 'in faa'²¹a júu³ tyʉ́² tya' Dios pe tsagoo¹o coon'¹³ ruu'²¹i 'in seein²¹ inʉʉ tya'a jo cón²on cwáain¹. ");
INSERT INTO chqNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","'Wii'¹³ joon jiin'¹³ coon²¹ milagro jo gajmaa¹a do. Xʉ tsá² gaun'láai². ");
INSERT INTO chqNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Lɨ́ɨ¹ ganga'goo²¹‑tsi Jesús 'wii'¹³ jo jo'¹ galɨ́ɨ²i tsagoo¹o 'ii. Joon mo galɨcɨɨin²¹gɨ gangó¹ Jesús ga'e'²e tsá² la caain²¹ fuu²¹ pi'³ taa'¹³ lɨ tyan' Nazaret do. Joon ga'e'² Jesús 'in tsá² do júu³ tyʉ́². ");
INSERT INTO chqNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Joon gatø'¹ Jesús jiin'¹³ dyatuuin¹ tsá² tya'a joon gasii¹in 'ido tɨ' ngái¹. Joon gacwoo¹ júu³ 'e lí² 'wooi² 'ido 'in 'lɨɨi'³ taai² alma tya' tsá². ");
INSERT INTO chqNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Joon gatyʉ'² to² wa'a jo 'e coon²¹ 'ido jiin'¹³ 'mo'u² soon'²¹on. Jo lí² coon²¹ jiin'¹³ coon²¹ 'iñi'¹ jon'gɨ tu'mɨ'² jon'gɨ cuu² lí² coon²¹. ");
INSERT INTO chqNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","'Ná¹ 'ø'¹ø mɨɨ²¹ saa'¹³ joon tyi'¹i coon²¹ 'mɨ'tyi'² jon'on la tún². ");
INSERT INTO chqNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Joongɨ gajin'² Jesús sɨɨ'²¹ɨ 'in tsá² tya'a do: ―Mi cwotaa²naa' coon²¹ inʉʉ do‑o jón²oo' ca mi 'woo²¹naa' 'e fuu²¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Wana jo 'iin²¹²in 'in tsá² do 'ii'²¹ 'naa' xiialɨ' cwolíin²naa' sɨ jo núu²un tsá² júu³ tyii' 'ee joon cwo'woo²¹moo' do. Joon xʉʉ²ʉʉ' 'laa²¹ toon¹ tɨ́ɨ¹³ɨɨ' lawa coon²¹ li² 'e jmaa²aa' tya'a. 'E la ja'²mo fuu²¹²uu 'naa': mi tɨ 'e 'íin² fu juncwii²¹ iwúu¹ ní² tsá² seein²¹ Sodoma coon'¹³ tsá² seein²¹ Gomorra. 'In tsá² fuu²¹ do‑o jo ga'ii'²¹i júu³ tya' Dios mo ganúu²un. Pe wúu¹gɨ iní² tsá² 'in jo 'ii'²¹ 'naa' lɨ cwolíin²naa' la coon'²¹gɨ tsá² seein²¹ Sodoma coon'¹³ Gomorra. ");
INSERT INTO chqNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Joon ga'woo²¹mo 'in tsá² tya' Jesús do tsacwoo¹ júu³ tyʉ́². Joon gajin'²in sɨɨ'²¹ɨ tsá² lɨ gatyalíin² 'ido: ―'Ná¹ unsɨɨ²¹moo' 'e 'ɨ¹‑'oo' ―jin'²in. ");
INSERT INTO chqNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Joongɨ lɨ́ɨ¹ fúui¹ 'in 'lɨɨi'³ ga'woo¹i almas tya' tsá². Joon gasoon²¹on aceite tya' tsatsaa'¹³ joon coon'¹³ la joon ga'láa²mo. ");
INSERT INTO chqNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Galitsáa¹mo‑tsi rǿøi¹³ Herodes jilaa'²¹ 'elo tsʉ jilee'²¹mo tsá² niñii¹ 'e jmoo¹o Jesús. Pe jin'²in tsá² 'e nigajiin'¹in tún¹ Wó³ saai²¹ tsá² jmɨɨ²¹, 'wii'¹³ joon lɨɨlɨ¹ 'oo¹ Jesús milagro. 'ɨ¹‑tsi tsá² 'e Jesús jmoo¹o milagro coon'¹³ júu³ tya' Wó³. ");
INSERT INTO chqNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Pe seen²¹mo 'in gajin'²in: ―Elías no. 'Inlɨ́ɨi¹³gɨ gajin'²in: ―'In faa'²¹a júu³ tyʉ́² tya' Dios la lɨ́ɨi¹ 'in gafaa'²¹ júu³ tya' Dios calɨɨ 'ino. ");
INSERT INTO chqNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Joon mo ganúu²un Herodes 'elo joon gajin'²in: ―Wó³‑o 'ino, joon jna‑a gatyʉ'¹ʉʉ to² wiin'²¹ luu²¹²u. Nigajiin'¹o 'ino tún¹ ―jin'² Herodes. ");
INSERT INTO chqNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","20","Herodes do nigacáan¹in 'in tsamɨ́² sii²¹ Herodías. 'In Herodías lo lɨ́ɨi¹ 'oo²¹²o Lii²¹² ruui'²¹ Herodes. Joon Wó³ do nigasɨɨ'²¹ɨ Herodes: ―Jo lí² caan²¹u'un 'oo²¹² ruu'²¹'u tsʉ́ seen²¹mogɨ. Joon 'wii'¹³ joon gali'ee'¹mo 'in tsamɨ́ do Wó³. Joon Herodes tyʉ'²ʉ to² 'e tsa'í² Wó³ 'nʉñí³ 'wii'¹³ Herodías. 'Iin²¹²in Herodías wa'a júun²in Wó³ pe jo cwo¹ rǿøi¹³ Herodes júu³ 'wii'¹³ gøø'²¹mo Wó³. Joon ñi¹ Herodes 'e Wó³ jaain²¹ tsañʉʉ'¹ 'in tyúi¹ joongɨ jaain²¹ tsá² 'in ñi¹ júu³ tya' Dios. Coon²¹o Herodes cwáain¹ coon'¹³ ce tún² jilaa'²¹ 'e faa'²¹ Wó³ fiin'¹³ jo tyʉ́² 'øøi'²¹‑tsi. ");
INSERT INTO chqNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Joon galɨ́² 'e gajmaa'¹²a Herodes jmɨɨ²¹² 'e tsín¹ jiin'²¹in. Gacwoo¹o 'ee dø'² tsacøøi'¹³ tya'a coon'¹³ 'in tyʉ'² to² 'láa² coon'¹³ jileei'²¹ tsá² tyiin² seein²¹ lɨ sii²¹ Galilea do. Joon Herodías gatsaa'²¹o xiia' la ijmáa¹a. ");
INSERT INTO chqNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","'In jamɨ́² Herodías do ga'í² jee²¹² lɨ néei¹ 'in tsá² gøø'²¹ do. Joon gatséen¹in. Joon lɨ́ɨ¹ gatɨ́²‑tsi Herodes coon'¹³ 'in tsá² néei¹ gøø'²¹ coon'¹³ 'ido la gatseein¹ 'in sɨmɨ́² do. Joon gajin'² rǿøi¹³ sɨɨ'²¹ɨ 'in sɨmɨ́² do: ―Mɨ́²'ɨ doñi'ee 'iin²¹²mo'o joon cwo'³oo 'nʉ. ");
INSERT INTO chqNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Joon ga'ee²¹ 'in rǿøi¹³ do tyani Dios 'e cwoo¹o doñi'ee gamɨɨ¹ɨ 'in sɨmɨ́² do fiin'¹³ ca coon'²¹ tsa'¹ 'a to² lɨ́ɨ¹i 'ido. ");
INSERT INTO chqNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Joon gacwo'ɨ́ɨ¹i 'in sɨmɨ́² do joon gasɨɨ'²¹ɨ sáa³a: ―¿'Ee mɨ́³ɨɨ tya' 'ino? Joon sáa³gɨ gajin'²: ―Sii'¹²'i cwocwoo¹ mootyi² Wó³ saai²¹ tsá² jmɨɨ²¹. ");
INSERT INTO chqNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Joon tsifu ga'í² tún² 'in sɨmɨ́² do lɨ tyíin¹ rǿøi¹³ joon ngasii'¹²i 'ido: ―La lo‑o 'iin²¹²na: cwo'²'o coon²¹ wúun¹ 'yʉ mootyi² Wó³ saai²¹ tsá² jmɨɨ²¹. ");
INSERT INTO chqNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Joon gajaan¹ 'in rǿøi¹³ do fa'í³. Pe jo 'ee futyigɨ tsʉ nigalɨ'ee'²mo Dios icwo¹ doñi'ee mɨɨ¹ɨ. Joon niganúu²un jileei'²¹ 'in néei¹ coon'¹³on do. Jo gatyuui'¹²gɨ to² 'e mɨɨ¹ɨ 'in sɨmɨ́² do. ");
INSERT INTO chqNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Tsifu gatyʉ'² rǿøi¹³ to² jaain²¹ 'láa² 'e tsatyíian¹ mootyi² Wó³. ");
INSERT INTO chqNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Joon gangó¹ 'in 'láa² do fu 'nʉñí³ lɨ 'yuui Wó³ 'e tsatyʉʉ'¹²ʉ mootyi² 'ido. Joon gacóon¹on 'yʉ tsi coon²¹ wúun¹. Joon gacwo'¹o 'in sɨmɨ́² do. Joon 'idogɨ gacwo'¹o sáa³o. ");
INSERT INTO chqNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Mo galiñii¹ tsá² tya' Wó³ 'e najúun²mo joon gangatyiian¹o mootaai² Wó³ joon ganga'áa¹mo. ");
INSERT INTO chqNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Mo galɨcɨɨin²¹ joon galicaain²¹ dyatuuin¹ tsá² tya' Jesús coon'¹³ Jesús. Joon gajma'²a júu³ Jesús jilaa'²¹ 'e nigajmaa¹a joon jilaa'²¹ 'e niga'e'²e tsá². ");
INSERT INTO chqNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","'Wii'¹³ tsataai² tsá² joongɨ jalíin² tsá² fúui¹ lɨɨlɨ¹ jiin'¹³ jo cwo¹ 'ido dø'¹ø joon gasɨɨ'²¹ɨ Jesús tsá² tya'a: ―Ñilíin²duu' coon'¹³ jna. Moo²¹o', 'yii²¹a' ta' tɨ' catá² lɨ jo 'in tsá² seein²¹. ");
INSERT INTO chqNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Joon ngalíin²mo Jesús coon'¹³ tsá² tya'a joon yaamo gataai² tsi coon²¹ barco. 'Iin²¹²in tsalíin² coon²¹ lɨ jo 'in tsá² seein²¹. ");
INSERT INTO chqNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pe fúu¹mo 'in ganí² 'ii lɨ ngaliin¹ do. Joon galicwii¹mo tsá² Jesús. Joon gangalíin² cwiin¹in coon'¹³ tɨɨ²o jilee'²¹mo 'in seein²¹ la coon²¹ fuu²¹. Joongɨ tyalíin² jée¹gɨ lɨ ngó¹ Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Mo gacwo'ɨ́ɨ¹ Jesús tsi barco gangaa¹mo tsá² fúui¹ lɨɨlɨ¹. Joon galɨfee'¹mo‑tsi 'wii'¹³ tya' 'ido. Téen¹in la téein¹ joo'saa'²¹ jo 'in fii²¹² seen²¹mo. Joon ga'láa² Jesús 'wii²¹² 'e'²e 'ido júu³ 'láai² lɨɨlɨ¹. ");
INSERT INTO chqNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Joon ni ca'lóo² jalíin² tsá² tya'a lɨ siin'¹²in joon sɨɨ'²¹ 'ido 'ii: ―Ca'lóo² lo joongɨ jo 'in taain²¹² lo coonti. ");
INSERT INTO chqNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","'I'² júu³ 'in tsá² no wa'a cwotyalíin²mo la caain²¹ fuu²¹ tyan' lɨ taain²¹² tsá² cwoláa¹a 'iñi'¹ dø'¹ø, tsʉ jo 'ee sá² 'e dø'¹ 'ino. ");
INSERT INTO chqNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Joon gañii¹i Jesús: ―Cwoo'¹³ 'naa' 'e dø'¹ 'ino. Joon 'in tsá² tya'a do gajin'²in: ―Jo liin¹ wa'a tsalaa²¹a'a coon²¹ mil tsi catyuui'¹³ 'iñi'¹ 'e cwoo¹o'o 'ino 'e dø'¹ø. ");
INSERT INTO chqNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Joon gajin'² Jesús sɨɨ'²¹ɨ 'ido: ―¿Joo' 'iñi'¹ 'oo²gɨɨ'? Cwojøø²duu'. Mo galiñi¹i joon gajin'²in: ―'Ñá² 'iñi'¹ sá²gɨ tyi' coon'¹³ gái¹gɨ joo'²¹ taai² jmɨɨ²¹. ");
INSERT INTO chqNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Joon gatyʉ'² Jesús to² wa'a cwó² 'in tsá² do jmaai'¹³ coon'¹³ poo²¹² jee²¹² ñii²¹ røø'²¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Joon gacwó² tsá² tɨ' cíein¹³ joongɨ tɨ' cincuenta. ");
INSERT INTO chqNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Joon gason'¹ Jesús 'e 'iñi'¹ 'ñá² do joongɨ jiin'¹³ gái¹ 'in joo'²¹ taai² jmɨɨ²¹² do. Joon gajǿø² lɨ' ñʉ'fú² joon gacwo'¹o 'maai'¹³ Dios tya' 'e 'iñi'¹ do. Joon gajmaa¹a 'no'³ 'e 'iñi'¹ do. Joon gacwo'¹o tsá² tya'a wa'a jmáa¹a tyíia³ 'e 'iñi'¹ do jee²¹² 'in tsá² fúui¹ do. Joongɨ gajmaa¹a tyíia³ 'in joo'²¹ taai² jmɨɨ²¹ gái¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Garǿ¹mo tu'² jileei'²¹ 'in gagøø'²¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Joongɨ garǿ¹mogɨ dyatun¹ 'motó² coon'¹³ 'no'³ 'iñi'¹ coon'¹³ 'no'³ 'in joo'²¹ taai² jmɨɨ²¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Gagøø'²¹ 'ná² mil tsañʉʉ'¹ 'e 'iñi'¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Joon gatyʉ'² Jesús to² 'e tsataai² tsá² tya'a tsi barco. Joon tsalíin² 'ido jéei¹gɨ lagɨ 'ña'a lɨ ngoo'¹³ tyíia¹ do. Joon 'iin²¹²in tsalíin² coon²¹ fuu²¹ sii²¹ Betsaida la 'ɨɨ²¹² 'ɨ'² Jesús tsá² júu³. ");
INSERT INTO chqNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Joon mo ngayuui'¹³ joon gangó¹ Jesús fu moo'²¹ ngafee'¹²i Dios Jmii²¹. ");
INSERT INTO chqNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Nicanʉʉ²¹ mo ganii²¹ Jesús 'e barco do. 'Ii²¹ ca tún² tsa'¹ ni tyíia¹ do. Pe Jesús‑gɨ siin'¹²in ca tsaa'¹ moo'²¹ do 'ña'a. ");
INSERT INTO chqNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Joon ganí² Jesús 'e jo lí² ngɨɨ¹gɨ barco tya' tsá² tya'a 'wii'¹³ lɨɨlɨ¹ 'ɨɨ¹ tyí² lɨ' cɨɨ'¹³. Ta'aa²¹ góo¹ mo gangó¹ Jesús lɨ ngalíin² tsá² tya'a. Gangó¹o ngɨɨ¹ tɨɨ²o ni jmɨɨ²¹ do. 'Iin²¹²mo ngɨ́ɨ¹i lɨ' caai²¹ lɨ ngaliin¹mo 'ido. ");
INSERT INTO chqNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ganíi²in tsá² tya'a 'ii jó¹ ngɨɨ¹ ni jmɨɨ²¹. Galɨ́ɨ¹i 'e tsamoojɨɨ'¹ jó¹. Joon ga'oo¹ lɨɨlɨ¹. ");
INSERT INTO chqNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Jilee'²¹mo ganíi² 'ii. Joon gafoo'²mo 'ii. Pe joon gafee'²¹mo Jesús 'ii gajin'²in: ―¡Tá² téein¹‑'oo'! ¡Jna‑a lo, jo foo'¹³naa'! ");
INSERT INTO chqNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Joon ga'ii²¹o tsi barco lɨ taai² tsá² tya'a. Joon gaján² 'ɨ́ɨ² tyí² do. ");
INSERT INTO chqNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","'Áai¹ 'waa'²¹a‑tsi tsá² tya' Jesʉs tsʉ jo mo toon¹‑tsi 'e júu³ tya' 'e 'iñi'¹ do 'wii'¹³ joon lɨ́ɨ¹ ganga'goo²¹‑tsi. ");
INSERT INTO chqNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Mo gatyalíin² lɨ ngoo'¹³ tyíia¹ ga'ñúu² barco tya'a coon²¹ tɨ' tyíia¹ lɨ sii²¹ Genesaret. ");
INSERT INTO chqNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Mo cwo'ɨ́ɨ¹ɨ 'ido tsi barco tsifu joon galicwii¹in tsá² 'ii. ");
INSERT INTO chqNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Joon 'in tsá² do gangalíin¹ cwiin¹in la caain²¹ joon ga'láa² 'wii²¹² jajée¹i tsatsaa'¹³ 'in tsíin² 'mó² fu lɨ siin'¹² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","La caain²¹ fuu²¹ pi'³ sɨ fuu²¹ fee'¹ 'ee sɨ tɨ' fuu²¹ 'ee lɨ tsáa¹ Jesús gatyía¹ tsá² tsatsaa'¹³ tya'a tya'i fu¹ lɨ ngɨ́ɨ¹i Jesús joon gamɨɨ¹ɨ tyani Jesús wa'a cwo¹ Jesús jiin'¹³ tɨ' sɨɨn'¹³ɨn soon'²¹on. Joon jileei'²¹ 'in gason'¹ sɨɨn'³ Jesús ga'láa²mo 'i. ");
INSERT INTO chqNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Joon galicaain²¹ tsá² tya' coon²¹ poo²¹² sii²¹ fariseos coon'¹³ 'inlɨ́ɨi¹³ tɨfo'² tya' ley lɨ siin'¹² Jesús. 'In tɨfo'² do jalíin² Jerusalén. ");
INSERT INTO chqNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Joon 'in tsá² lo gacón² cwáain¹ 'e 'in tsá² tya' Jesús néei¹ gø'¹ø joon 'lɨɨ'² cwoo²¹o. 'øøi'²¹‑tsi tsá² 'e jo mo jngɨ́ɨ² cwoo²¹ la tɨɨsi'², 'wii'¹³ joon gafaa'²¹a 'láai². ");
INSERT INTO chqNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Jileei'²¹ fariseos coon'¹³ tsá² seein²¹ Israel jmoo¹o la lɨ́² gajmaa¹a 'lɨɨ²¹² tsacøøi'¹³. Jo dø'¹ tsá wana jo jngɨ́ɨ² cwoo²¹ la tɨɨsi'² mo jéei¹. ");
INSERT INTO chqNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Mo jalíin² 'moo'¹³ jo dø'¹ø wana jo mo run'²un cwoo²¹ la tɨɨsi'². Joongɨ lɨ́ɨ¹ 'láai² jilaa'²¹ tɨɨsi'² 'e sá² calɨɨ jmoo¹o. Jmoo¹o tsá² la tɨɨsi'² run'²un tasa 'un'²un jmɨɨ²¹ joon tsʉʉ² coon'¹³ jilaa'²¹ nii² 'e jmaai'²¹ to² mo gø'²ø. ");
INSERT INTO chqNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Joon 'in fariseos do coon'¹³ tɨfo'² tya' ley do gaunngɨɨ¹ɨ Jesús jin'²in: ―¿'Ee lɨ' jo jmoo¹o tsá² tyi'i la lɨ' gajmaa¹a 'lɨɨ²¹² tsacøøi'¹³ tyi'? Gø'²ø pe jo mo run'¹un cwoo²¹o la tɨɨsi'². ");
INSERT INTO chqNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Joon gañii¹i Jesús: ―Calɨɨ 'in gafaa'²¹a júu³ tya' Dios sii²¹ Isaías gajmaa¹a coon²¹ jí². Joon tsi jí² do gafaa'²¹o xiiala lɨ́ɨ²naa' tsá² 'in jo tiin'¹³ 'e 'e'²e tsá² xeei'²¹. Gajin'²in ni jí² do: 'In tsá² lo untyúi¹ Dios jiin'¹³ coon'¹³ 'e faa'²¹a pe jo tɨ́²‑tsi jiin'¹³ la to² tyʉ'² Dios. ");
INSERT INTO chqNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Jo 'e to² 'íi³ 'e un'goo²¹o jna. Jilaa'²¹a 'e 'e'²e tsá² jiin'¹³ lɨ' to² tyʉ'² tsá², jin'² Isaías. ");
INSERT INTO chqNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Faa'²¹gɨ Jesús jin'²in: ―Ga'íin²mo‑'oo' jilaa'²¹ to² tyʉ'² Dios, pe coon'²¹ tún² jmoo²oo' la tɨɨsi'² 'e jmoo¹o tsá² la mo jéei¹ la rúun¹³uun' tsʉʉ² joongɨ tasa 'uun'²¹un jmɨɨ²¹. Joongɨ 'láa²mo 'e lɨ la lɨ 'elo jmoo²oo' la jmoo¹o tsá². ");
INSERT INTO chqNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","La joongɨ gajin'² Jesús: ―'Iin²¹² 'naa' núu³gɨɨ' la to² tyʉ'² 'lɨɨ²¹² tsacøøi'¹³ jon'gɨ la to² tyʉ'² Dios la no. ");
INSERT INTO chqNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","La lɨ gajin'² Moisés calɨɨ mo gacwo'¹o tsá² ley: “Un'gøø'²¹mo'o ñʉ'²'ʉ coon'¹³ saa²'a.” Joon gajin'²in: “'In sɨɨ'²¹ júu³ 'laa'²¹ jmii²¹ sɨ sáa³a 'ee 'ná¹ jnga'²mo tsá² 'ii.” ");
INSERT INTO chqNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pe joon, 'naa'gɨɨ', jo cwoo²oo' júu³ 'e uncoon'¹³ tsá² jmii²¹ sɨ sáa³a 'ee wana gajin'²: “Jilaa'²¹ 'e sá² tyiia 'e lí² uncoon'¹³ jna 'nʉ lɨ́ Corbán.” ('øøi'²¹‑tsi tsá² jin'²in: nigacwo'³oo Dios.) ");
INSERT INTO chqNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Wa'a jin'² tsá² la no, joon 'naa'gɨɨ' jo cwoo²oo' wa'a uncoon'¹³on sáa³ jmii²¹. ");
INSERT INTO chqNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Mo jmoo² 'naa' la joon tʉ¹oo' júu³ tya' Dios lawa'a jo 'e tyiin²mo. 'Iin²¹²gɨɨ' jmoo²oo' tɨɨsi'² 'e gacwo'¹ tsá² 'naa' lagɨ júu³ tya' Dios. Joongɨ lɨ́ɨ¹ 'láai² tɨɨsi'² 'e jmoo²oo' la lɨ́¹ 'elo ―jin'² Jesús sɨɨ'²¹ɨ 'in tsá² fariseos coon'¹³ tɨfo'² tya' ley. ");
INSERT INTO chqNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Joon gatø'¹ Jesús 'in tsá² fúui¹ taain²¹² do joon gajin'²in: ―Nʉʉ²duu' jilaa'²¹ 'e fo'²oo lo. Joon cwo'øøi'²¹‑'oo'. ");
INSERT INTO chqNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Jilaa'²¹ 'e gø'² tsá² jo lí² un'lɨɨi'³ 'ii la joon. Jiin'¹³ 'e 'woo²¹ tsi tsá² 'e jmoo¹o 'e faa'²¹ tsá² 'e joon un'lɨɨi'³ tsá². ");
INSERT INTO chqNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Wana sá² loocwoo¹oo' nʉ́ʉ²duu'. ");
INSERT INTO chqNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Mo gatíui² Jesús tsá² joon ga'í² coon²¹ inʉʉ joon gaunngɨɨ¹ tsá² tya'a 'ee 'e júu³ gatyaa¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Joon gajin'² Jesús sɨɨ'²¹ɨ 'ii: ―¿Tɨ jon'gɨ 'naa' 'øøi'²¹‑'oo'? Ní²‑i 'naa' 'e jilaa'²¹ 'e gø'² tsá² jo tsatoo'¹³ tsi alma tya' tsá² pe jiin'¹³ tu'²o. ");
INSERT INTO chqNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Joon mi yuui'¹³ joon 'woo²¹o fu caluu tún¹. 'Wii'¹² joon jo lí² un'lɨɨi'³ tsá² tyani Dios. 'Wii'¹³ jiin'¹³ coon'¹³ júu³ la joon jin'² Jesús 'e lí²‑i dø'¹ tsá² doñi'ee. ");
INSERT INTO chqNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jin'²o jon Jesús: ―'E 'woo²¹ lɨ tsi alma tya' tsá² 'e joon un'lɨɨi'³ tsá² tyani Dios. ");
INSERT INTO chqNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Tsʉ lɨ tsi alma tya' tsá² 'øøi'²¹‑tsi 'e 'øøi'²¹‑tsi tsá². Lɨ' alma tya' tsá² 'woo²¹ jilaa'²¹ 'e gó² 'e 'ɨ¹‑tsi tsá². Do‑o 'ɨ¹‑tsi 'e lɨ́² feei'² tsamɨ́² tsá² xeei'²¹ sɨ doñi'ee 'e gó² 'ɨ¹‑tsi tsá² cwáain¹ tya' tsamɨ́² sɨ tsañʉʉ'¹ 'ee. Do‑o 'ɨ¹‑tsi tsá² wa'a jngaa'¹²i tsá² ");
INSERT INTO chqNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","sɨ jmoo¹o 'uun²¹ 'ee. Tsi alma tya'a gali'iin²¹²in tsá² jilaa'²¹ 'e sá² tya' tsá² xeei'²¹; 'aa'¹a tsii²¹² wúu¹i; jmoo¹o júu³ 'atsaa²¹; 'ɨ¹‑tsi jiin'¹³ tya' 'ña'a. Jo li'³i 'e jmáa¹a. ");
INSERT INTO chqNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","'Wii'¹³ 'ɨ¹‑tsi tsá² jilaa'²¹ 'elo, 'wii'¹³ joon 'in 'lɨɨ'³mo 'ii tyani Dios. ");
INSERT INTO chqNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Joon gangó¹ Jesús fu coon²¹ fuu²¹ sii²¹ Tiro coon'¹³ Sidón. Joon ga'í² coon²¹ inʉʉ. Joon jo 'iin²¹²in wa'a liñi¹ tsá² coonti pe jo galɨ'²ɨ jiin'¹³ la gali'iin²¹²in. ");
INSERT INTO chqNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Joon tsifu galiñi¹ jaain²¹ tsamɨ́². Joon 'in xuui²¹² tya' 'in tsamɨ́² lo 'yuui² 'in 'lɨɨi'³ alma tya'a. Joon gajó² 'in tsamɨ́² do gasii'²¹i 'wojníi¹i wii²¹² tɨɨ² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","'In tsamɨ́² lo galiseein²¹ Sirofenicia, jon' tsagoo¹ tsá² seein²¹ Israel. Pe gajó² jamɨɨ¹ɨ tyani Jesús wa'a tyii²in 'ido 'in 'lɨɨi'³ 'yuui alma tya' jóon¹on. ");
INSERT INTO chqNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Pe Jesús gasɨɨ'²¹ɨ 'ii: ―Cwo²du'u jéei¹ wa'a dø'¹ xuui²¹² lagɨ tsii²¹ tsʉ jo tseein²¹ tyii²¹i' 'no'³ gø'² xuui²¹² joon cwóo¹³o' tsii²¹. ");
INSERT INTO chqNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Pe joon gañii¹i 'in tsamɨ́² do jin'²in: ―Jo'¹o, pe cagɨ tsii²¹ 'in tee'¹² nʉ' mesa gø'²o 'no'³ xʉʉ'²¹ mo gø'² xuui²¹². ");
INSERT INTO chqNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Joon gajin'² Jesús sɨɨ'²¹ɨ 'in tsamɨ́² do: ―Tyʉ́²‑ʉ la gafa'²'a. Lí²‑i cwoo'²mo'o no nicwo'ɨ́ɨ¹ɨ 'in 'lɨɨi'³ 'yuui² alma tya' xuui²¹² tyi'i. ");
INSERT INTO chqNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Joon mo gatyee'¹²i tya'a gatsee'²¹i xuui²¹² tya'a raain¹ ni coo'mó². Nicwo'ɨ́ɨ¹ɨ 'in 'lɨɨi'³ 'yuui² alma tya' 'ido. ");
INSERT INTO chqNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Gacwo'ɨ́ɨ¹ Jesús co' fuu²¹ Tiro gangɨ́ɨ¹i Sidón joon ngɨ́ɨ¹i fu lɨ' co' Decápolis, joon gatyía¹ tɨ' jmɨɨ²¹ tyíia¹ Galilea. ");
INSERT INTO chqNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Joon mo gatyía¹ do joon gangajée¹i tsá² jaain²¹ tsá² cwuui²¹² 'yʉcaai²¹² jo faa'²¹. Joon gamɨɨ¹ wa'a taan¹ Jesús cwoo²¹o tya' 'ido. ");
INSERT INTO chqNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Joon gangajéei¹ Jesús 'ii coon²¹ lɨ jo 'in tsá² jǿø². Joon gafoo'²¹ Jesús uniicwoo²¹o tsi loocwoo²¹ 'ido. Joon ga'ñíi¹i joongɨ galii'²¹i uniisɨɨ'¹³ 'ido. ");
INSERT INTO chqNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Joon gajǿø² lɨ' ñʉ'fú² gasaai²¹‑tsi joon gajin'²in: ―¡'Efata! ('øøi'²¹‑tsi jin'²in: ¡Néei² 'wo'o!) ");
INSERT INTO chqNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","La joon ganó¹ loocwóo¹o. Sɨɨ'¹³ɨ galɨ́² tyʉ́²‑ʉ joon galɨ́²‑ɨ faa'²¹a røø²¹. ");
INSERT INTO chqNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Joon gajin'² Jesús sɨɨ'²¹ɨ 'in tsá² 'in gajée¹i 'in jo faa'²¹ do: ―Jo 'in fuu²uu' ce jiin'¹³ jaain²¹. Pe lɨ' tyʉ'²gɨ to² 'e sɨɨ'²¹o tsá². ");
INSERT INTO chqNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Lɨ́ɨ¹ tsa'goo²¹‑tsi tsá², joon jin'²in: ―Jilaa'²¹ 'e jmoo¹o 'ino 'e tyʉ́² tsʉ ca 'in cwuu²¹² jmoo¹‑o núu²un joongɨ 'in jo faa'²¹a jmoo¹‑o 'e faa'²¹ 'ido. ");
INSERT INTO chqNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Jee²¹² jmɨɨ²¹² lo galicaain²¹ tsá² fúui¹ lɨɨlɨ¹. Jo 'ee sá² dø'¹ coonti. Joon gatø'¹ Jesús tsá² tya'a joon gasɨɨ'²¹ɨ 'ido: ");
INSERT INTO chqNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Lɨ́ɨ¹ fúu² lɨ́ɨ²na 'in tsá² lo 'wii'¹³ ningó¹ 'nɨ¹ jmɨɨ²¹² 'e taain²¹² coon'¹³ jna lo. Joon jo 'ee sá²gɨ dø'¹ø coonti. ");
INSERT INTO chqNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Wa'a 'ɨ́ɨ³ɨɨ júu³ fu tya'a la jo mo gø'²ø joon jo li píin³ ngɨ́¹. 'Inlɨ́ɨi¹³ jalíin² wíin². ");
INSERT INTO chqNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Joon gañii¹i tsá² tya'a: ―¿Xiiala lí² cwóo¹³o' 'ino 'e dø'¹ø? Jo 'in seein²¹ waa'a 'nɨ́¹ coonti. ");
INSERT INTO chqNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Joon gaunngɨɨ¹ɨ Jesús: ―¿Joo' 'iñi'¹ 'oo²gɨ 'naa'? 'Ii‑gɨ gajin'²in: ―Dyía¹ tigɨ. ");
INSERT INTO chqNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Joon gatyʉ'² Jesús to² wa'a cwó² ni 'wó² do joon gason'¹on 'e 'iñi'¹ dyía¹ do joon gacwo'¹o 'maai'¹³ Dios. Joon gajmaa¹a 'no'³ 'e 'iñi'¹ do gacwo'¹o tsá² tya'a 'e tsajmaa¹a tyíia³ jee²¹² 'in tsá² fúui¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Joongɨ ni'aa¹mogɨ jaain²¹ gái¹ joo'²¹ taai² jmɨɨ²¹ pi'³. Joon gacwo'¹o Jesús 'maai'¹³ Dios tya' 'in joo'²¹ taai² jmɨɨ²¹ pi'³ do joon gatyʉ'²ʉ to² jmaa¹a tsá² tya'a tyíia³ 'in joo'²¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Tyʉ́²‑ʉ gagøø'²¹ø jilee'²¹mo. Joongɨ tɨɨ²¹gɨ dyía¹ 'motó² røøi¹ 'e gasái¹. ");
INSERT INTO chqNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Xʉʉ jogɨ tí¹ tyʉ́n² mil tsá² 'in gagøø'²¹ø do. Joon ga'ɨ́ɨ² Jesús 'in tsá² do júu³. ");
INSERT INTO chqNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Joon 'ña'gɨ ga'í² tsi coon²¹ barco coon'¹³ tsá² tya'a. Joon ngaliin¹ fu coon²¹ lɨ sii²¹ Dalmanuta. ");
INSERT INTO chqNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Joon jee²¹² jmɨɨ²¹² joon gajalíin² 'inlɨ́ɨi¹³ tsá² fariseos joon ga'láa² 'wii²¹² jo cwo'¹o júu³ ruu'²¹i coon¹³ Jesús. 'Iin²¹²in 'in tsá² fariseos do tyaan¹ cwáain¹ xiiala lɨ́ɨ¹ Jesús, 'wii'¹³ joon gamɨɨ¹ɨ waa'a 'e'² Jesús 'ido coon²¹ li² tya' ñʉ'fú². ");
INSERT INTO chqNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Pe gasaai²¹‑tsi Jesús lɨɨlɨ¹ joon gajin'²in: ―'In tsá² lo jo tsáai¹‑tsi Dios mo mɨɨ¹ɨ coon²¹ milagro. 'E la ja'²mo fuu²¹²uu 'naa', jiin'¹³ coon²¹ li² tya' milagro jo cwo'³oo 'in tsá² lo. ");
INSERT INTO chqNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Joon gatʉ́ʉ²mo Jesús 'in tsá² do. Ngatáa¹i tsi barco joon gangó¹ fu lɨ' ngoo'¹³ tyíia¹ cataain do tún¹. ");
INSERT INTO chqNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","'In tsá² tya' Jesús do niga'íin¹mo‑tsi 'e coon²¹ 'ee dø'¹ø. Jɨ tɨɨi² coon²¹ 'iñi'¹ nityaan¹ tsi barco do. ");
INSERT INTO chqNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Joon gajin'² Jesús sɨɨ'²¹ɨ tsá² tya'a: ―Ñíi²duu, tɨ́ɨ¹moo' coon'¹³ tyiian'³ tya' fariseos joongɨ tɨ́ɨ¹moo' coon'¹³ tyiian'³ tya' tsá² tya' rǿøi¹³ Herodes. ");
INSERT INTO chqNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Joon tsá² tya'gɨ ga'láa² 'wii²¹² sɨ́ɨ²i la 'oo'²¹ jee²¹² yaai jin'²in: ―'Wii'¹³ jo 'e 'iñi'² lee²o' 'e joon 'e gajin'²in la no. ");
INSERT INTO chqNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ñii¹ Jesús 'ee 'e sɨ́ɨ²i 'ido joon gajin'²in sɨɨ'²¹ɨ 'ido: ―¿'Ee lɨ' foo'²¹ 'naa' 'e jo 'oo²oo' 'iñi'¹? ¿Tɨ jo mo 'øøi'²¹‑'oo'? ¿Tɨ jo mo lilii²ii'? ¿Tɨ 'áai¹ ni 'waa'²¹ tyi² 'naa'? ");
INSERT INTO chqNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Tɨ jo jǿø²øø' coon'¹³ unní²ii'? ¿Tɨ jo nuu²uun' coon'¹³ loocwoo²oo'? ¿Tɨ jo tɨɨ'²‑'oo'? ");
INSERT INTO chqNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Mo gajmáa³aa tyíia³ 'e 'iñi'¹ 'ñá² do jee²¹² 'ñá² mil tsá², ¿joo'gɨ 'motó² 'e garǿøi¹ do? Joon gajin'² tsá² tya'a: ―Dyatun¹gɨ gatɨ́². ");
INSERT INTO chqNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","―Joon mo gajmáa³gɨɨ tyíia³ dyía¹ 'iñi'¹ jee²¹² tyʉ́n² mil tsá² ―jin'² Jesús― ¿joo' 'motó² rǿøi¹ 'e gatyiian²¹gɨɨ'? Joon gajin'²in tún¹ tsá² tya'a: ―Dyía¹gɨ gatɨ́². ");
INSERT INTO chqNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Joon gajin'² Jesús sɨɨ'²¹ɨ tsá² tya'a: ―¿Tɨ jo mo 'øø'²¹mogɨ‑'oo'? ");
INSERT INTO chqNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Mo gatyalíin² Jesús fuu²¹ Betsaida gangajée¹i tsá² jaain²¹ tsatiui² lɨ siin'¹² Jesús. Gamɨɨ¹ɨ wa'a soon'²¹ Jesús tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Joon gason'¹ Jesús cwoo²¹ 'in tsatiui² do. Gangajée¹i lɨ' tɨ' fuu²¹. Joon gasúun² jmɨɨ'e'²e unni² 'ido. Joongɨ gataan¹ cwoo²¹o tya' 'ido. Joon gaunngɨɨ¹ɨ wana nijnéei²xʉ. ");
INSERT INTO chqNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Gajǿø² 'in tsatiui² do joon jin'²in: ―Jǿø³moo tsá². Jǿø²na tsá² 'in lɨ́ɨi¹ la lɨ 'mó² pe ngɨɨ¹o. ");
INSERT INTO chqNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Joon gataan¹ tún¹ Jesús cwoo²¹o unní² 'ido. 'In tsatiui² do gajǿø²ø coon'¹³ ce tún² joon ga'láa²mo coonti. Najǿø²o jilaa'²¹ røø²¹. ");
INSERT INTO chqNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Joon gatyʉ'² Jesús to² 'a tsei'² 'ido fu tya'o. Joon gajin'²in: ―Jo ngɨɨ²¹un 'e fuu²¹ do, jogɨ 'in fu'²'u coonti jilaa'²¹ 'e nigalɨ́² tyi'i. ");
INSERT INTO chqNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Mo galicɨ́ɨin²gɨ ngalíin² Jesús coon'¹³ tsá² tya'a fu la caain²¹ fuu²¹ pi'³ náa¹ co' Cesarea de Filipo. Lɨ ngalíin² tya'i fu¹ gaunngɨɨ¹ɨ Jesús sɨɨ'²¹ɨ tsá² tya'a: ―¿'Iin jna jin'² tsá²? ");
INSERT INTO chqNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Joon gañii¹i tsá² tya'a: ―'Inlɨ́ɨi¹³ jin'² 'e Wó³ saai²¹ tsá² jmɨɨ²¹ 'nʉ. 'Inlɨ́ɨi¹³gɨ jin'² 'e Elías 'nʉ. Joon 'in catyaai²gɨ jin'² 'e jaain²¹ 'in gafaa'²¹ júu³ tya' Dios calɨɨ 'nʉ. ");
INSERT INTO chqNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Joon gaunngɨɨ¹ɨ Jesús tsá² tya'a: ―'Naa'gɨɨ', ¿'iin jna fáa¹³aa'? Joon gajin'² Tʉ́³: ―'Nʉ Cristo, 'in gasii¹in Dios 'nʉ. ");
INSERT INTO chqNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Pe gatyʉ'² Jesús to² 'e jo 'in sɨɨ'²¹ɨ tsá² tya'a ce jiin'¹³ jaain²¹ 'e Cristo 'ii, 'in gasii¹in Dios. ");
INSERT INTO chqNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Joon ga'láa² Jesús 'wii²¹² 'e'²e tsá² tya'a do jin'²in: ―Jna‑a 'in Ruu'²¹na Tsá². Joon 'ná¹‑a móo³oo wúu¹ lɨɨlɨ¹. Jileei'²¹ tsacøøi'¹³ coon'¹³ 'in tyʉ'² to² tya' untsá² coon'¹³ tɨfo'² tya' ley 'ee'¹mo jna. Joon 'ii ijngaa'¹²mo jna pe jiin'¹oo tún¹ mi tɨ́² 'nɨ¹ jmɨɨ²¹² 'e gajúun²na. ");
INSERT INTO chqNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Gafaa'²¹a coon²¹ júu³ coon²¹ tsáa¹gɨ. Joon gatø'¹ Tʉ́³ Jesús coon²¹ lɨ gái¹. Joon gajin'² Tʉ́² sɨɨ'²¹ɨ Jesús: ―Jo foo'³gɨ'ɨ la no. ");
INSERT INTO chqNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Pe gajiin'¹² Jesús níi¹i, gajǿøi² tsá² tya'a joon gajin'²in sɨɨ'²¹ɨ Tʉ́³ do: ―Jeein'¹³ coon'¹³ jna. Satanás 'nʉ tsʉ jo 'ɨ¹‑'o' 'nʉ júu³ tya' Dios. Jiin'¹³ jmaai'¹³ júu³ tya' tsá²‑a 'ɨ¹‑'o' 'nʉ. ");
INSERT INTO chqNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Joon gatø'¹ tún¹ Jesús tsá² tya'a coon'¹³ jileei'²¹ tsá² taain²¹² coon'¹³on joon gasɨɨ'²¹ɨ 'ido: ―Wana 'in 'iin²¹²in jalíin² coon'¹³ jna 'ná¹‑a cwo'íin²mo‑tsi 'wii²¹² tya' 'ña'o joon 'ná¹ tyaa¹ tyʉ́² 'ña'a 'e júun²in lagɨ ijúun²na. Joon 'ná¹ cwojmaa¹a la to² tyʉ'² jna. ");
INSERT INTO chqNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Tsʉ jileei'²¹ 'in 'iin²¹²in tiin'¹³ juncwii²¹ tya' yaai 'e joon i'íin²mo juncwii²¹ tya'a. Pe jileei'²¹gɨ 'in 'íin²in juncwii²¹ tya'a 'wii'¹³ jna, joongɨ 'wii'¹³ júu³ tyʉ́² tya' Dios joon tiin'¹³mo 'i juncwii²¹ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Jo 'ee to² 'íi³in tya' tsá² wa'a jnaa'²¹a la tøøi² cwoo'¹³ fu juncwii²¹ pe caa²¹mo alma tya'a lɨ 'ii²¹. ");
INSERT INTO chqNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Jo lí² tyii²¹ tsá² coon'¹³ cuu² alma tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Wa jaain²¹ 'oo¹o fa'ɨɨ'²¹ 'wii'¹³ jna joongɨ 'wii'¹³ júu³ tyiia jee²¹² 'in tsá² jo 'naai'² Dios joongɨ jee²¹² 'in 'oo¹o tsaa² tyi¹ joon jna‑a jon, 'in Ruui'²¹ Tsá², in'óo³oo fa'ɨɨ'²¹ 'wii'¹³ tya' 'ii mi yíi³aa coon'¹³ ángeles tyúi¹ joon ungoo²¹ tsá² jna la ungoo²¹ tsá² Dios Jmii²¹ nano ―gajin'² Jesús sɨɨ'²¹ɨ tsá². ");
INSERT INTO chqNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Joon gajin'² Jesús: ―'E la ja'²mo fuu²¹²uu 'naa' 'inlɨ́ɨi¹³ jee²¹² 'in téein² lo jo ijúun²in ca iliñii¹ xiiala tyʉ'² Dios to² tsá². ");
INSERT INTO chqNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Jnʉ́ʉ² jmɨɨ²¹² 'e gangɨ́ɨi¹ joon gajée¹i Jesús Tʉ́³ coon'¹³ Jacobo coon'¹³ Wó³. Joon ngalíin² coon'¹³ 'ido coon²¹ ni moo'²¹ ñíi¹. Joon do‑o gaunsɨ́ɨ²i Jesús 'e lɨ́ɨi¹ tyani 'in catyaai² do. ");
INSERT INTO chqNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Sɨɨn'¹³ɨn galijɨɨ'¹ lɨɨlɨ¹. Jnéei¹ taa²¹ ca la taa²¹ 'moo²¹ ce jiin'¹³ jaain²¹ taain²¹² ni cwoo'¹³ juncwii²¹ mo run'²un sɨɨn'³ jo lí² ta' taa²¹. ");
INSERT INTO chqNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Joon gajnéi¹ 'lɨɨ²¹² Elías coon'¹³ 'lɨɨ²¹² Moisés 'e lɨ téein² do. Joon gasɨ́ɨ²i coon'¹³ Jesús ");
INSERT INTO chqNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Joon gajin'² Tʉ́³ sɨɨ'²¹ɨ Jesús: ―Tɨfo'² tyii'i, ¡lɨ́ɨ¹ tyʉ́² 'e toon²¹o'on lo! Jmóo¹³o'o 'nɨ¹ 'nʉ́¹ pi'³. Coon²¹ tyi'nʉ coongɨ tya' Moisés coongɨ tya' Elías. ");
INSERT INTO chqNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pe Tʉ́³‑gɨ do jo ñii¹ 'ee faa'²¹a, lɨ' faa'²¹a 'goo'²¹o. Joon 'goo'²¹o jon 'in tsá² gái¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Joon gajgó¹ coon²¹ jníi¹ yʉ' lɨ téein² joon ga'ɨ́ɨ² 'iin'³ tya' lɨ téein² 'ido. Joon jee²¹² 'e jníi¹ do ganúu²un coon²¹ júu³ 'e jin'²: ―'In lo‑o yʉʉn²¹ tyiia 'in 'iin²¹²na. Tyaan²¹duu' cwáain¹ 'e jin'²in. ");
INSERT INTO chqNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Tsifu joon mo gajǿø²ø la 'ui jo 'in ganíi²gɨ jiin'¹³ jaain²¹, jiin'¹³ 'ña'a Jesús ganíi²gɨ. ");
INSERT INTO chqNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Mo gajgaai²¹ 'e moo'²¹ do joon gasɨɨ'²¹ɨ Jesús 'in tsá² gaai²¹ do 'e jo 'in sɨɨ'²¹ɨ 'ido jiin'¹³ jaain²¹ jilaa'²¹ 'e ganíi² do ca mi jiin'¹in tún¹. ");
INSERT INTO chqNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","'Wii'¹³ joon ga'maa²¹o 'e júu³ do jee²¹² 'ii. Joon gaunngɨɨ¹ɨ jee²¹² ruu'²¹i 'ee 'øøi'²¹‑tsi tsá² mo gajin'² Jesús: “Ijiin'¹o tún¹ Ruu'²¹i Tsá².” ");
INSERT INTO chqNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Joon gaunngɨɨ¹ɨ tsá² tya' Jesús: ―¿'Ee lɨ' jin'² tɨfo'² tya' ley 'e 'lɨɨ²¹² Elías 'ná¹ jó¹ nifu? ");
INSERT INTO chqNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Joon gañii¹i Jesús sɨɨ'²¹ɨ 'ido: ―'E ja'²mo Elías jó¹ nifu. Joon tyaa¹o tyʉ́² jilaa'²¹. Júu³ la ja'²mo gajin'² jí² tya' Dios tya' Ruu'²¹i Tsá² mo jin'² 'e inii²¹ wúu¹. Joongɨ jin'² jí² tya' Dios 'e jo 'iin²¹²in tsacøøi'¹³ tsáai¹gɨ‑tsi 'ii. ");
INSERT INTO chqNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","'E ja'²mo fo'³gɨɨ ―jin'² Jesús― Elías najó¹ joon 'inlɨ́ɨi¹³ tsá² gajmee'²¹mo 'ii jilaa'²¹ 'e 'iin²¹²in jiin'¹³ la gajin'² ni jí² tya' Dios ilí². ");
INSERT INTO chqNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Joon mo ngayuui'¹³ joon ngaliin¹ lɨ néei¹ 'in tsá² tya'a catyaai²gɨ do. Joon ganíi²in tsá² fúui¹ lɨ¹ taain²¹² cu' lɨ' lɨ tyíin¹ 'in tsá² tya'a catyaai² do. Joon coon'¹³ tɨfo'² tya' ley téein² jo cwo'¹o júu³ ruu'²¹i. ");
INSERT INTO chqNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Joon tsifu mo gajnée¹i Jesús jilee'²¹mo ganga'goo²¹‑tsi. Joon ngaliin¹ cwiin¹in ngaunjiin'¹in Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Joon gaunngɨɨ¹ɨ Jesús tsá² tya'a: ―¿'Ee júu³ jo cwoo²oo' ruu'²¹naa' coon'¹³ 'ido? ");
INSERT INTO chqNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Joon jaain²¹ 'in tsá² téein² do gañii¹i: ―Tɨfo'², lo jee²na yʉʉn²¹ tyiia 'in 'yuui² 'in 'lɨɨi'³ alma tya'a. Joon jo cwoo²¹ faa'²¹ 'inlo. ");
INSERT INTO chqNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Joon doñixiia' siin'¹²mo 'in 'lɨɨi'³ lo jmoo¹o saain'¹ cɨɨ'¹³i ni'wó² joon 'yee'²¹ jon¹ moo'oo²o joongɨ cuu'²¹i moojóon¹on. 'Wii'¹³ joon 'wo² ga'ɨ́ɨ²‑tsi. Namɨ́³oo tya' tsá² tyi'i wa'a 'e tyii²in 'in 'lɨɨi'³ do pe jo galɨ'¹ɨ. ");
INSERT INTO chqNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Joon gañii¹i Jesús sɨɨ'²¹ɨ 'ido: ―'Naa' lɨ́ɨ¹naa' tsá² 'in jo jo'¹ lɨ́ɨ²i. ¿Tɨ wóo²gɨ 'áai¹ 'ná¹ taan²¹²na coon'¹³ 'naa'? ¿Tɨ wóo²gɨ 'áai¹ 'ná¹ lifeei'¹‑tsii 'wii'¹³ tyii'? Nijee²¹duu' 'in xuui²¹² do fu lo. ");
INSERT INTO chqNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Joon ngajée¹mo 'in xuui²¹² do. Mo ganíi²in 'in 'lɨɨi'³ 'yuui² alma tya' 'in xuui²¹² do Jesús joon gajmaa¹a júuin² ñi'¹ 'in xuui²¹² do. Joon gacɨɨ'²¹i 'in xuui²¹² do ni 'wó², 'yee'²¹ jon¹ moo'oo²o. ");
INSERT INTO chqNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Joon gaunngɨɨ¹ɨ Jesús jmii²¹ xuui²¹² do: ―¿Xiiati ningóo¹ 'e lɨ́ɨ¹i la no? Joon gajin' jmii²¹ xuui²¹² do: ―Ca mo xuui²¹² pi'³ 'ii. ");
INSERT INTO chqNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Joon lɨ́ɨ¹ 'láai² naa'¹³ nipii¹in ni jɨ́² joongɨ tsi jmɨɨ²¹ 'e 'iin²¹²in jngaa'¹³mo 'ino. 'Wii'¹³ joon wana 'e lii'²'i fúu² cwoliin¹un jna'a joon uncoon'¹³'on jna'a. ");
INSERT INTO chqNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Gasɨɨ'²¹ɨ Jesús 'ii: ―Wa lijai'² lɨ́ɨ²u, jilaa'²¹ ilí² tya' 'in jai'² lɨ́ɨi². ");
INSERT INTO chqNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Joon ga'oo¹o 'in jmii²¹ xuui²¹² do: ―¡Jo'¹o lɨ́ɨ²na! ¡Uncoon'¹³ 'nʉ jna 'e ilí² jai'²gɨ lɨ́ɨ²na! ");
INSERT INTO chqNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Mo ganí² Jesús 'e lɨ́ɨ¹ fúui¹ tsá² galicaain²¹ gasɨɨ'²¹ɨ 'in 'lɨɨi'³ do: ―'Nʉ‑ʉ 'in jo cwo'¹o faa'²¹ 'in xuui²¹² lo jogɨ cwo'¹o núu²un, jna‑a tyʉ'³ʉʉ to² 'e juu'¹²'u, tíui¹ 'in xuui²¹² no. Jo 'ú²gɨ'ɨ alma tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Joon ga'oo¹o 'in 'lɨɨi'³ do joon gajmaa¹a júuin² ñi'¹ tún¹ 'in xuui²¹² do. Joon gacwo'ɨ́ɨ¹ɨ. Gatiui² 'in xuui²¹² do lawa jaain²¹ 'lɨɨ²¹². 'E joon gajin'² 'in tsá² fúui¹ do 'e 'lɨɨ²¹²mo 'ido. ");
INSERT INTO chqNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Pe joon gason'¹ Jesús cwoo²¹ xuui²¹² do joon gasaa'¹³a joon gasiin'¹²mo 'in xuui²¹² do. ");
INSERT INTO chqNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Joon mo ga'í² Jesús tsi coon²¹ inʉʉ joon gaunngɨɨ¹ɨ tsá² tya' 'ii: ―¿'Ee lɨ' jo galɨ'² jna'a 'e tyí² jna'a 'in 'lɨɨi'³ do? ");
INSERT INTO chqNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesús‑gɨ gajin'²in sɨɨ'²¹ɨ tsá² tya'a: ―Jiin'¹³ mo jmoo¹o tsá² taa'²¹ tyani Dios joon jo dø'¹ø joongɨ feei'¹ tsá² Dios, jiin'¹³ la joon cwo'ɨ́ɨ¹ɨ 'in 'lɨɨi'³ la no. ");
INSERT INTO chqNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Mo gangalíin² 'ido gangɨ́ɨ¹i fu Galilea. Joon jo gali'iin²¹²in Jesús 'e liñii¹ jiin'¹³ jaain²¹ 'wii'¹³ 'e'²o jiin'¹³ tsá² tya'a. Gajin'²in sɨɨ'²¹ɨ 'ii 'e isaan'¹mo tsá² 'in Ruu'²¹i Tsá² jaan'¹²in ja'cwoo²¹ tsá² joongɨ ijngaa'¹²mo 'ii. Pe mi tsín¹ 'nɨ¹ jmɨɨ²¹² ijúun²in joon ijiin'¹o tún¹. ");
INSERT INTO chqNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Pe 'in tsá² tya'a do jo 'øøi'²¹‑tsi 'e sɨɨ'²¹ 'ido 'ii. Joongɨ 'goo'²¹‑o wa' unngɨɨ¹gɨ. ");
INSERT INTO chqNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Joon gatyalíin² fuu²¹ Capernaum. Mo ngataai² Jesús coon²¹ inʉʉ joon gaunngɨɨ¹ɨ tsá² tya'a: ―¿'Ee júu³ jo cwoo²oo' ñilíin²naa' tya'i fu¹ do? ");
INSERT INTO chqNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Pe joon lɨ coon²¹ gajaan¹ tii² 'wii'¹³ lɨ jalíin² do nasɨ́ɨ²i jo cwo'¹ júu³ ruu'²¹i 'e 'iin 'in tyiin²gɨ jee²¹² 'ii. ");
INSERT INTO chqNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Joon gacwó² Jesús. Joon gatø'¹ø jiin'¹³ dyatuuin¹ tsá² tya'a joon gasɨɨ'²¹ɨ: ―Wana in 'iin²¹²in jmaa¹a to² nifu jee²¹² 'naa' 'ná¹ jméi¹ 'ña'a lawa'a tsá² 'wéi¹ joon unjíi²o jon jilee'²¹mo 'in catyaai² do. ");
INSERT INTO chqNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Joon gatɨɨi²¹ Jesús jaain²¹ xuui²¹² gatyéei¹ tún² tsá'¹ jee²¹² lɨ née¹i. Joon gataan'¹²in cwáa¹a 'ido joon gajin'²in: ");
INSERT INTO chqNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Wana 'ii'²¹ tsá² xuui²¹² la lɨ́ɨi¹ 'ino cwáain¹ tyiia, 'ii'²¹mo jon 'ido jna. Joon 'in 'ii'²¹ jna do pe jon'on jiin'¹³ jna 'in 'ii'²¹ 'ido joongɨ 'ii'²¹mo jon 'in gasii¹in jna do. ");
INSERT INTO chqNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Joon gajin'² Wó³ sɨɨ'²¹ɨ Jesús: ―Tɨfo'², ganee²¹²moo'o jaain²¹ 'in jin'² 'e 'wooi²¹ 'in 'lɨɨi'³ taai² alma tya' tsá². Joon mo 'wooi²¹ 'in 'lɨɨi'³ do joon jin'²in sɨɨ'²¹ɨ 'in lɨɨi'³ do: “Jesús tyʉ'²ʉ to² 'e 'woo²¹moo'.” Pe jo ngɨɨ¹ɨ 'ido coon'¹³ jna' 'wii'¹³ joon gatyuu'¹³moo'o. ");
INSERT INTO chqNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Pe gajin'² Jesús: ―Jo untsaa'¹³naa'. Jiin'¹³ jaain²¹ lí² faa'²¹ 'e gó² 'wii'¹³ tyiajna joongɨ jmaa¹a coon²¹ milagro coon'¹³ to² 'e 'óo³oo. ");
INSERT INTO chqNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","'In jo 'eei'¹ jna' 'ii jon 'nee¹mo jna'. ");
INSERT INTO chqNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Doñi'iin 'in 'iin²¹²in uncoon'¹³ jna joon cwo'¹o 'naa' fiin'¹³ coon²¹ vasa jmɨɨ²¹ 'wii'¹³ tsá² tya' Cristo 'naa' la ja'²mo sá² 'lee'¹²i. ");
INSERT INTO chqNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Faa'²¹gɨ Jesús jin'²in: ―'Áai¹ gó² tya' doñi'iin 'in jmá¹ 'e lí² 'oo¹o tsaa² 'in xuui²¹² 'in jo'¹ lɨ́ɨi² jna. 'E tyʉ́²gɨ tya'a wa'a 'nʉʉ¹ tsá² luu²¹²u coon²¹ too¹ fee'¹ joon pii¹in tsá² 'ii fu tsi jmɨ'ñi'³. ");
INSERT INTO chqNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Wana coon'¹³ cwoo¹'o jmoo¹ lí² 'óo¹²'o tsaa² tyʉ́²gɨ tyi'i wa'a tyʉʉ'³o'o. Tsʉ tyʉ́²gɨ wa'a taan²u'un juncwii²¹ coon'¹³ coon²¹ cwoo¹'o lagɨ 'a cwóo¹³'o lɨ 'ii²¹ coon'¹³ jɨ tún² cwoo¹'o. Tsʉ lɨ 'ii²¹ do jo lí² dyʉʉ¹ tsá² jɨ́² tya'a coonti ");
INSERT INTO chqNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","joon jo júuin² joo'¹³ jogɨ guu¹ jɨ́² coonti. ");
INSERT INTO chqNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Joongɨ wana tɨ́ɨ¹³'ɨ jmaa¹ ga'aa¹'a tsaa² tyʉʉ'³o'o jon. Tsʉ tyʉ́²gɨ tyi'i wa'a jmaa²'a to² tyʉ'² Dios mo taan²un juncwii²¹ jluu'¹³mo'o lagɨ tɨɨ¹u'u fu lɨ 'ii²¹ coon'¹³ jɨ tún² tɨ́ɨ¹³'ɨ. Tsʉ fu lɨ 'ii²¹ do jo lí² dyʉʉ¹ tsá² jɨ́² tya'a ");
INSERT INTO chqNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","joon jo júuin² joo'¹³ joon jogɨ guu¹ jɨ́² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Wana unní²'i jmoo¹o 'e lí² 'oo²'o tsaa² tyí²du'u coonti tsʉ tyʉ́²gɨ tyi'i 'e 'uu¹u'u coon'¹³ coon²¹ unní²'i lɨ tyʉ'² Dios to² lagɨ coon'¹³ jɨ tún² unní²'i cwóo¹³'o lɨ 'ii²¹. ");
INSERT INTO chqNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Tsʉ lɨ 'ii²¹ do jo júuin² joo'¹³ jo'gɨ jɨ́² coonti. ");
INSERT INTO chqNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Tsʉ jilee'²¹mo liñii¹mo coon'¹³ jɨ́². Joon 'ná¹ caai'²¹ tsá² ñi² jilaa'²¹ fa'¹ 'e cwo'¹ tsá² Dios. ");
INSERT INTO chqNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","'E tyʉ́²‑ʉ ñi² pe wana ga'ín¹ jmá² tya', ¿'ee coon'¹³ iliñi³gɨ tún¹? Cwolɨ́ɨ¹naa' la lɨ́¹ ñi² tyʉ́² joon cwolisein²¹moo' 'e tyʉ́² coon'¹³ la jaain²¹ la jaain²¹. ");
INSERT INTO chqNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Gacwo'ɨ́ɨ¹ Jesús fuu²¹ Capernaum. Gangóo¹ li sii²¹ Judea. Gangóo¹ lɨ' ngoo'¹³ jmɨɨ²¹ Jordán lɨ 'yeei²¹ ñi'¹. Do‑o galicaain²¹ tsá² fúui¹ lɨɨlɨ¹ 'e lɨ siin'¹²in do. 'E'²e Jesús tsá² tún¹ la lɨ 'e gatɨ́ɨ²i. ");
INSERT INTO chqNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Joon gangatyéen¹in tsá² coon²¹ poo²¹² sii²¹ fariseos lɨ siin'¹² Jesús. 'In fariseos do 'iin²¹²in jmáa¹a 'e tøø'²¹ Jesús coon²¹ tsaa² tya'a. Joon gaunngɨɨ¹ɨ: ―¿Tɨ cwo¹ ley tya' Moisés júu³ wa'a xeei¹ tsá² 'in gacui'² cwoo²¹ coon'¹³? ");
INSERT INTO chqNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Joon gañii¹i Jesús: ―¿'Ee to² gatyʉ'² Moisés? ");
INSERT INTO chqNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","'Ii‑gɨ gajin'²in: ―Moisés gacwo'o tsá² júu³ 'e cwo'¹ tsañʉʉ'¹ 'in tsamɨ́² do coon²¹ mo'jí² 'e tíu²mo 'ii. Joon coon'¹³ mo'jí² do lí²‑i xeei¹ tsá² 'in gacui'² cwoo²¹ coon'¹³. ");
INSERT INTO chqNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesús‑gɨ gajin'²in: ―Moisés gacwo¹ júu³ 'e joon tsʉ 'wii'¹³ 'e soo²¹‑'oo' 'naa' yaamoo'. ");
INSERT INTO chqNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pe mo gajmaa¹ Dios la jilaa'²¹ 'e sá² gajmeei¹ Dios tsañʉʉ'¹ coon'¹³ tsamɨ́². ");
INSERT INTO chqNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","'Wii'¹³ joon ilí² tíui² tsañʉʉ'¹ jmii²¹ coon'¹³ sáa³a joon licaain²¹ coon'¹³ tsamɨ́² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Jee²¹² 'in gái¹ do liin¹ lawa jaain²¹ tsá². La joon jo tigɨ gái¹. Joon galɨ́ɨ¹i jaan²¹mo. ");
INSERT INTO chqNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","'Wii'¹³ joon jo lí²gɨ xeei¹ tsá² 'e gauncaain²¹ Dios. ");
INSERT INTO chqNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Mo ngataai² coon²¹ inʉʉ joon gaunngɨɨ¹ɨ tún¹ tsá² tya'a 'ee 'øøi'²¹‑tsi tsá² 'e júu³ do. ");
INSERT INTO chqNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Joon gasɨɨ'²¹ɨ Jesús 'ii: ―'In tsá² 'in tíui² tsamɨ́² tya'a joon cui'² cwoo²¹ coon'¹³ 'in xeei'²¹ unrøøi¹ 'ña'a tsaa². ");
INSERT INTO chqNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Wana tsamɨ́² tíui² ñʉʉ'¹ tya'a joon cui'² cwoo²¹ coon'¹³ 'in xeei'²¹gɨ 'e unrøøi¹ 'ña'a tsaa². ");
INSERT INTO chqNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Joon gangajée¹i tsá² jaain²¹ gái¹ xuui²¹² tyani Jesús joon 'iin²¹²in wa'a son'¹ Jesús tya' 'ido. Pe 'in tsá² tya'a do gajíi²mo 'in tsá² ngajéei¹ xuui²¹² do. ");
INSERT INTO chqNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Mo ganí² Jesús galɨ́² 'nii'²¹‑tsi joon gajin'²in: ―Cwoo²oo' cwojalíin² 'in xuui²¹² no lɨ siin'¹²na. Jo jnɨɨ'¹³naa' tsʉ la lɨ́ɨi¹ 'in xuui²¹² no lɨ́ɨ¹i 'in tyʉ'² Dios to². ");
INSERT INTO chqNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","La ja'²mo fuu²¹²uu 'naa' 'in tsá² 'in jo 'ii'²¹ to² tyʉ'² Dios lawa jaain²¹ xuui²¹², 'ii jo 'e itsa'ii²¹ coonti lɨ tyʉ'² Dios to². ");
INSERT INTO chqNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Joon tɨ́ɨ²i Jesús 'in xuui²¹² do, gataan'¹²in cwáa¹a 'ido joon mo gataan¹an cwoo²¹ tya' 'ido joon gauncwaa'³i. ");
INSERT INTO chqNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Lɨ ningóo¹ Jesús tún¹ gajó² jaain²¹ tsañʉʉ'¹ cwiin¹in gasii'²¹i 'wojníi¹i tyani Jesús. Joon gasɨɨ'²¹ɨ Jesús: ―Tɨfo'² tyúi¹, ¿'ee 'ná¹ jmáa³aa 'e tiin'¹³moo juncwii²¹ tyiia? ");
INSERT INTO chqNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Joon gajin'² Jesús: ―¿'Ee lɨ' fu'²'u jna 'in tyúi¹? Jaan²¹mo 'in tyúi¹ joon Dios 'i. ");
INSERT INTO chqNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ñí³o'o to² tyʉ'² ley tya' Dios: “Jo foo'¹³'o tsamɨ́². Jo jngáa'¹³mo'o tsá². Jo jmaa²'a 'uun²¹. Jo fu'²'u júu³ tajuu²¹ jiin'¹³ jaain²¹. Jo cón²'on tsá² tóo². Cwoli'gɨɨ²¹mo'o ñʉ'²'ʉ coon'¹³ saa²'a.” ");
INSERT INTO chqNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Joon gañii¹i 'in tsañʉʉ'¹ do: ―Tɨfo'², jilaa'²¹ 'elo galinʉʉ'¹³oo ca mo galixuu²¹²moo. ");
INSERT INTO chqNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Joon gajǿøi² Jesús 'ii 'e 'neei²¹ ni 'ido. Joon gasɨɨ'²¹ɨ 'ii: ―Coon²¹ 'e 'ná¹gɨ tyi'i: cwo'nɨɨ²¹² jilaa'²¹ 'e 'oo²¹²'o. Cwo'²'o jileei'²¹ tsá² tañíi² joon lí² 'oo²¹²'o 'láai²gɨ ñʉ'fú². Joon uncaan²¹un coon'¹³ jna fiin'¹³ ca júun²mo'o tsaa'¹ crúu¹³. ");
INSERT INTO chqNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Pe mo ganúu²un 'elo lɨ́ɨ¹ gajmaa¹a fa'í³ joon nga'²mo 'wii'¹³ lɨ́ɨ¹ galisá² cúu¹u. ");
INSERT INTO chqNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Joon gajǿø² Jesús cu' lɨ' lɨ siin'¹²in joon gajin'²in sɨɨ'²¹ɨ tsá² tya'a: ―'Áai¹ tyan¹ to² wa'a cwói¹ tsá² sá² cuu² 'ña'a tyʉ'² Dios to² 'ii. ");
INSERT INTO chqNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Tsá² tya'a do lɨ́ɨ¹ ganga'goo²¹‑tsi 'e gajin'² Jesús do. Pe Jesús gafaa'²¹a tún¹: ―Yʉʉn²¹ tyiia, lɨ́ɨ¹ tyan¹ to² tsa'í² jaain²¹ tsá² 'in tsáai¹‑tsi 'e sá² cuu² lɨ tyʉ'² Dios to². ");
INSERT INTO chqNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Tyan¹gɨ to² 'e tsa'í² jaain²¹ 'in sá² cuu² lɨ tyʉ'² Dios to² lagɨ jaain²¹ camello ngɨɨi¹ jee²¹² too²¹ tya' moocuu². ");
INSERT INTO chqNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Mo ganúu²un tsá² tya'a 'elo lɨɨlɨ¹ ganga'goo²¹‑tsi. Joon gaunngɨɨ¹ɨ la 'oo'²¹ ruu'²¹i: ―¿'Iin inlitiin'¹³mo wa la joon? ");
INSERT INTO chqNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Joon gajǿøi² Jesús 'ii. Joon gasɨɨ'²¹ɨ 'ido: ―Jo lí² jmá¹ tsá² tiin'¹³ 'ña'a pe lii'²¹i Dios, tsʉ 'e tya' Dios jiin'¹³ coon²¹ 'e sá² wa'a jo lí² jmáa¹a. ");
INSERT INTO chqNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Joon ga'láa² Tʉ́³ 'wii²¹² faa'²¹a jin'²in: ―Nigatʉʉ²¹² jna'a jilaa'²¹ 'e 'oo²o'o joongɨ nigajalíi²oo'o coon'¹³ 'nʉ. ");
INSERT INTO chqNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesús‑gɨ gañii¹i: ―'E la ja'²mo fuu²¹²uu 'naa', doñi'iin 'in gatú² 'nʉ́¹ sɨ gatíui² ruu'²¹i 'ee sɨ jmii²¹ sɨ sáa³ 'ee sɨ 'oo²¹²o sɨ jóon¹on 'ee sɨ tʉ́²o 'wó² tya'a 'ee 'wii'¹³ jna‑a sɨ 'wii'¹³ júu³ tya' xiiala itiin'¹³ tsá² 'ee; ");
INSERT INTO chqNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","'in jmoo¹o la joon i'ii'²¹mo cíein¹³ lɨ́ɨ²gɨ 'in taain²¹² fu juncwii²¹ lo. I'ii'²¹mo 'nʉ́¹, ruu'²¹i, sáa³a, jóon¹on, 'wó² tya'a fiin'¹³ wúu¹ iní². Joongɨ itiin'¹³mo mi 'íin² juncwii²¹. ");
INSERT INTO chqNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Pe fúu¹mo 'in lɨ́ɨi¹ tsá² tyiin²mo nano pe mi tɨ́² jmɨɨ²¹² joon tsá² 'wéi¹ iliin¹. Joon fúu¹mo 'in tsá² 'wéi¹ nano iliin¹ tsá² tyiin² mi tɨ́² jmɨɨ²¹² joon. ");
INSERT INTO chqNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ngalíin² Jesús coon'¹³ tsá² tya'a soo²¹o fu Jerusalén joon gangó¹ Jesús nifu. Li'³i tsá² tya'a 'e tsáa¹a 'ido fu Jerusalén 'wii'¹³ joon lɨ́ɨ¹ tsa'goo²¹‑tsi tsá² tya'a. Joon 'in catyaai² do gangalíin² 'goo'²¹o. Joon gatø'¹ tún¹ Jesús jiin'¹³ 'in dyatuuin¹ tsá² tya'a. Joon ga'láa² 'wii²¹² gasɨɨ'²¹ɨ tsá² tya'a jilaa'²¹ 'e 'noogɨ 'e tsangɨ́ɨ²i. ");
INSERT INTO chqNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Gajin'²in: ―Ñíi²duu' la ngalii²¹i' lo fu Jerusalén. Joon do‑o injaan'¹³in tsá² jna, 'in Ruu'²¹na Tsá², tyani 'in tyʉ'² to² tya' untsá² coon'¹³ 'in tɨfo'² tya' ley. Joon 'ii ityʉ'² to² ijúun²na. Joon injaan'¹³in jna ja'cwoo²¹ tsá² coon²¹ fuu²¹. ");
INSERT INTO chqNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Joon 'in tsá² do iungøø¹i jna joongɨ ipóo²i jna joongɨ i'ñíi¹i ní³ii joongɨ ijngaa'¹²in jna. Pe mi tsín¹ 'nɨ¹ jmɨɨ²¹² ijiin'¹oo tún¹. ");
INSERT INTO chqNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Joon gangatyéen¹in Jacobo coon'¹³ Wó³ jóon¹ Zebedeo lɨ siin'¹² Jesús. Joon gasɨɨ'²¹ɨ: ―Tɨfo'², 'iin²¹²moo'o 'e jmaa²o'o coon²¹ 'e mɨɨ²¹ɨ'ɨ. ");
INSERT INTO chqNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Joon gaunngɨɨ¹ɨ Jesús: ―¿'Ee 'e 'iin²¹²naa' ilí² tyii'? ");
INSERT INTO chqNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","'Ii‑gɨ gajin'²in: ―Cwo'³'o jna'a wa'a yii²¹a'a jmaai'¹³ la cataain²¹ caa¹o'o. Jaain²¹ lɨ' tsáa¹ jaain²¹gɨ lɨ' tooin²¹² mi tyʉʉ'¹³'ʉ to². ");
INSERT INTO chqNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Joon gasɨɨ'²¹ɨ Jesús 'ii: ―Jo ñí³ 'naa' 'ee 'e mɨ́²ɨɨ' no. ¿Tɨ taa'²¹ wúu¹ la lɨ 'e wúu¹ 'e tsangɨ́ɨ²na? ¿Tɨ lí² júun²naa' la ijúun²na? ");
INSERT INTO chqNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","'Ii‑gɨ gañii¹i: ―Li'³oo'o ―jin'²in. Pe Jesús‑gɨ gajin'²in: ―Ja'²mo, 'naa' 'ná¹ moo²oo' wúu¹ la imó³ jna joon 'ná¹ júun²moo' la ijúun²na. ");
INSERT INTO chqNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pe 'e cwaa²¹ tsá² caa¹na lɨ' tsáa¹ tiin'¹³ lɨ' tooin²¹² jo tɨɨ²¹na cwó³oo 'e joon. Pe 'e tɨɨi²¹ ñii²¹ jiin'¹³ 'in nináa¹ tyʉ́² tya'o. 'E lo‑o tya' 'e 'iin²¹²in Dios. ");
INSERT INTO chqNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Joon mo ganúu²un 'in tsá² tya'a dyéi¹ do gatsa'nii'²¹‑tsi tya' Jacobo coon'¹³ Wó³. ");
INSERT INTO chqNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Pe joon gatø'¹ Jesús 'ii joon gajin'²in: ―La lɨ' 'e ñí² 'naa', 'in tsá² 'in 'oo¹o to² tya' nacíoi¹³ fu juncwii²¹ tyʉ'²o to² 'ii²¹. Joongɨ jileei'¹³ tsacøøi'¹³ jee²¹² 'ii tyʉ'²ʉ to² ce tyíi². ");
INSERT INTO chqNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pe jo lí² la joon jee²¹¹² 'naa'. Lɨ' cɨɨ'¹³ɨ ilí². 'In 'iin²¹²in jméi¹ 'ña'a tsafeei'¹ jee²¹² 'naa', 'ii 'in tɨɨi²¹ uncoon'¹³o 'in catyaai²gɨ do. ");
INSERT INTO chqNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Joon doñi'iin jee²¹² 'naa' 'in tyʉ'² to² nifu, 'ii 'in uncoon'¹³ jileei'²¹. ");
INSERT INTO chqNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Jo mo cwéei¹ 'in Ruu'²¹i Tsá² wa'a uncoon'¹³ tsá² 'ii. 'Ii‑o gacwée¹i 'e uncoon'¹³o tsá². Joongɨ gacwée¹i 'e cwoo¹ juncwii²¹ tya'a lawa 'e 'laa'¹³ 'e jmaa¹ tiin'¹³ tsá² fúui¹. ");
INSERT INTO chqNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Joon gatyalíin² Jericó. Joon mo ga'wooi²¹ Jesús coon'¹³ tsá² tya'a coon'¹³ tsá² fúui¹ lɨɨlɨ¹ 'a fuu²¹ do, do‑o nityíin¹in jaain²¹ tsatíui² sii²¹ Bartimeo, jóon¹ Timeo, co' fu¹. Mɨɨ¹ɨ caridad. ");
INSERT INTO chqNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Mo ganúu²un 'e gangɨ́i¹ Jesús tsá² Nazaret 'in tsatíui² do ga'láa² 'wii²¹² 'oo¹o jin'²in: ―¡Jesús, jóon¹ David, fúu² cwoliin¹un jna! ");
INSERT INTO chqNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Fúu¹mo gajíi²mo 'ii jin'²in: ―Jo to'²'o mɨɨ'¹³. Pe 'ii‑gɨ gatǿ² tá²gɨ: ―¡Jóon¹ David, fúu² cwoliin¹un jna! ");
INSERT INTO chqNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Joon gajaan¹ Jesús. Joon gajin'²in: ―Te'duu' lo. Joon gangalíin² 'in gasɨɨ'²¹ 'in tsatíui² do: ―Tya²‑'o'o. Ráan²un no tsʉ do tø'¹ø 'nʉ. ");
INSERT INTO chqNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Joon tsifu gatʉʉ²¹ 'mɨ'jnʉ́³ 'yaa'²¹i joon ga'ɨ́ɨ²i 'e ngatyéen¹in lɨ siin'¹² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Joon gaunngɨɨ¹ɨ Jesús 'ii: ―¿'Ee 'iin²¹²un 'e lí² tyi'i? In tsatíui² do gañii¹i: ―Tɨfo'², 'iin²¹²na jǿø³øø. ");
INSERT INTO chqNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesús‑gɨ gajin'²in: ―Lí²‑i cwoo'²'o. Ni'láa²mo'o 'wii'¹³ jo'¹o lɨ́ɨ²u'u. Tsifu joon 'in tsatíui² do galɨ́²‑ɨ jǿø². Joon gangoo²¹o la caain²¹ tya'i fu lɨ ngóo¹ Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Mo gatyalíin² tyan' Jerusalén co' fuu²¹ Betfagé coon'¹³ Betania joon gatyalíin² tsaa'¹ moo'²¹ sii²¹ moo'²¹ Olivos. Joon gasii¹in Jesús gái¹ tsá² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Gasɨɨ'²¹ɨ: ―Cwolíin²duu' 'e fuu²¹ pi'³ náa¹ do. Mi tyalíin²naa' joon imáa¹naa' jaain²¹ bu'³ siin'¹² 'neei²¹². Jaain²¹ bu'³ 'in jo mo cwó² jiin'¹³ jaain²¹. Joon laa²¹²naa' joon tǿ²øø' fu lo. ");
INSERT INTO chqNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Wana 'in jin'²in: “'Ee lɨ' jmoo²oo' la no”, joon fuu²uu': “Fii²¹²oo'o 'néi¹ta 'in bu'³ lo. Joon tsifu yajaa²¹²na'a 'inlo.” ");
INSERT INTO chqNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Joon gangalíin²mo joon gatsee'²¹mo 'in bu'³ do siin'¹² 'neei²¹² coon²¹ tya'i fu¹ tyan' coon²¹ 'ooca'nʉ́¹. Joon gasi'²i 'nii²¹² tya' 'ido. ");
INSERT INTO chqNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","'Inlɨ́ɨi¹³ 'in teein¹ do gajin'²in: ―¿'Ee jmoo²oo'? ¿'Ee lɨ' síi¹³ii' 'nii²¹² tya' 'in bu' no? ");
INSERT INTO chqNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","'Ii‑gɨ gañii¹i la to² nigatyʉ'² Jesús 'e jin'²in. Joon gacwoo¹ 'ido ngaliin¹. ");
INSERT INTO chqNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Tsifu gatǿø¹³o 'in bu' do lɨ siin'¹² Jesús. Joon gaunfuu²¹ sɨɨ'¹³ɨn moo'wóo¹ bu'³ do. Joon gacwó² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Lɨ́ɨ¹ fúui¹ 'in ganii'¹³ sɨɨn'³ tya'i fu¹. 'Inlɨ́ɨi¹³ gatyʉ'²ʉ nii²¹² moo²¹ joon gatyaa¹a nifu lɨ ngóo¹ Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","La 'in ngalíin² nifu lagɨ 'in jalíin² lɨ caluu 'oo¹o. Jløø'³mo 'oo¹o jin'²in: ―¡Viva tsá² cwaa'³mo 'in nigasii¹in Dios! ");
INSERT INTO chqNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Lɨ́ɨ¹ tyʉ́² mi tyʉ'² 'ii to² la to² 'e gatyʉ'² 'lɨɨ²¹² rǿøi¹³ David! ¡Ña'ñʉ'¹ʉ' uncoon'¹³ jna'a! ―jin'² tsá² do. ");
INSERT INTO chqNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","La joon ga'í² Jesús Jerusalén. Joongɨ ga'í² iyíia² cwo'¹ do. Mo ngayuui'¹³ gajǿø² ce jilaa'²¹ 'e sá² la 'ui joon gangaa'¹³in fu Betania tún¹ coon'¹³ jiin'¹³ 'in dyatuuin¹ tsá² tya'a tsʉ joon nica'lóo². ");
INSERT INTO chqNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Mo ca jná² tún¹ mo ga'wooi²¹ Jesús Betania joon galili'³i un'aa²i. ");
INSERT INTO chqNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Joon wíin² ganii²¹ coon²¹ 'mó² cwaríi³ tsi mo'³. Joon ngajǿø²ø wana tsi cwaríi³ 'e 'mó² do pe jiin'¹³ mo'³o ganii²¹ mo tyíia² tsʉ jo mo tɨ́² jiin'²¹ 'e sá² do. ");
INSERT INTO chqNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Joon gasɨɨ'²¹ Jesús 'e 'mó² cwaríi³ do. Joon gajin'²in: ―Ce jiin'¹³ jaain²¹ jo 'in dø'¹ 'oofuu²¹ tyi'nʉ coonti ―jin'² Jesús. Joon ganúu²un tsá² tya'a 'e jin'²in do. ");
INSERT INTO chqNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Mo lɨcɨɨin²¹ joon tyalíin² Jerusalén. Mo ga'í² Jesús fu i'yíia² cwo'¹ feei'¹ si'² do ga'láa² 'wii²¹² 'woo¹i jileei'²¹ 'in 'nɨɨ¹ coon'¹³ 'in ló². Gajiin¹mo mesa lɨ néei¹ 'in unfuui²¹² cuu² joongɨ lɨ néei¹ 'in 'nɨɨi¹ maa²¹². ");
INSERT INTO chqNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Joon jo cwoo¹ Jesús 'in ngɨ́ɨi¹ tyan¹ jiin'¹³ coon²¹ laa²¹² lɨ' tsi i'yíia² cwo'¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Joon gajin'²in: ―Ni jí² tya' Dios jin'²: 'Nʉ́³ʉʉ lo ilisii²¹ 'nʉ́¹ tya' júu³ tyʉ́² tya' la tøøi² cwoo'¹³ juncwii²¹. Pe 'naa'gɨɨ' najmaa²aa' lawa coon²¹ tsi too²¹ tya' 'uun²¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Joon jileei'¹³ 'in tyʉ'² to² tya' untsá² coon'¹³ 'in tɨfo'² tya' ley ganúu²un. Joon 'wii'¹³ ninga'goo²¹‑tsi tsá² jilaa'²¹ 'e 'ee¹ Jesús 'gøø'²¹mo 'in tsacøøi'¹³ do coon'¹³ tɨfo'² tya' ley. 'Wii'¹³ joon ga'noo'¹²on xiiala ijngaa'¹²i Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Pe mo ga'í² nʉ́ʉ³ gacwo'ɨ́ɨ¹ Jesús coon'¹³ tsá² tya'a 'e fuu²¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Mo gajná² 'áa³gɨ gangɨ́ɨ¹i tya'i fu¹ li si'² 'e 'mó² cwaríi³ do. Joon ganí²i 'e 'mó² cwaríi³ do nigalityʉʉn²¹ ca tɨ́² jmóo³. ");
INSERT INTO chqNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Joon gatɨ'²‑tsi Tʉ́³ joon jin'²in sɨɨ'²¹ɨ Jesús: ―Tɨfo'², jǿø²du', nigalityʉʉ²¹ 'e 'mó² cwaríi³ do 'e ga'ii²'i tsiifú² tya'a do. ");
INSERT INTO chqNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Joon gañii¹i Jesús sɨɨ'²¹ɨ tsá² tya'a: ―Jo cuu'¹³‑'oo' coon'¹³ Dios. ");
INSERT INTO chqNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","'E la ja'²mo fuu²¹²uu 'naa', doñi'iin 'in gajin'²in sɨɨ'²¹ɨ 'e moo'²¹ lo: “Jiin'¹³ joon 'u'²'u fu tsi jmɨ'ñi'¹.” Wana jo toin² 'ɨ¹‑tsi joon jo'¹o lɨ́ɨi² 'e tsatiin'¹³mo 'e la lɨ́² 'e nigajin'²in do, joon la joon ilí². ");
INSERT INTO chqNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","'Wii'¹³ joon fuu²¹²uu 'naa', jilaa'²¹ 'e mɨ́²ɨɨ' 'naa' coon'¹³ júu³ tyʉ́² wana jo'¹o lɨ́ɨ²naa' 'e 'ii'¹³naa' joon la joon ilí². ");
INSERT INTO chqNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Mo foo'¹³naa' Dios joon seein²¹ jaain²¹ 'in 'eei'¹ 'naa' jmaa²aa' feei'¹‑'oo' tsaa² tya'a. Joon la joon i'íin²mo Ñʉ'¹ʉ' tyíin¹ ñʉ'fú² tsaa² tyi'naa'. ");
INSERT INTO chqNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Wana 'naa' jo 'íin²naa' tsaa² tya' tsá² joon la joon Ñʉ'¹ʉ' 'in tyíin¹ ñʉ'fú² jo 'íin² tsaa² tyi'naa'. ");
INSERT INTO chqNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Joon gangalíin² tún¹ fu Jerusalén. La 'ɨɨ²¹² ngɨɨ¹ Jesús i'yíia² cwo'¹ do joon gangatyéen¹in 'in tyʉ'² to² tya' untsá² coon'¹³ tɨfo'² tya' ley joongɨ coon'¹³ tsacøøi'¹³. ");
INSERT INTO chqNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Joon gaunngɨɨ¹ɨ 'ido 'ii: ―¿'Iin tyʉ'² to² 'e jmoo²'o la no? ¿'Iin gatyʉ'² to² 'e jmaa²'a la no? ");
INSERT INTO chqNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesús‑gɨ gañii¹i sɨɨ'²¹ɨ 'ido: ―Jna‑gɨ iunngɨɨ²duu. Wana gañii²ii' tyiia joongɨ ifo'³oo 'naa' 'in tyʉ'² to² 'e jmóo³oo 'elo. ");
INSERT INTO chqNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿'Iin gasii¹in Wó³ saai²¹ tsá² jmɨɨ²¹? ¿Tɨ Dios owa tsá² 'ee? Ñii²duu' jna. ");
INSERT INTO chqNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","32","Joon ga'láa² 'in tsá² do 'wii²¹² jo cwo'¹o júu³ ruu'²¹i, jin'²in: ―¿'Ee síi¹³i'? Jo lí² jin'²in 'e Dios gasii¹in 'i, jon'gɨ lí² jin'²in 'e tsá² gasii¹in 'i 'wii'¹³ 'goo'²¹o. Wana gajin'²: “Dios gasii¹in 'ii”, joon 'ɨ¹‑tsi ijin'²in Jesús: ¿'Ee lɨ' jo jo'¹ lɨ́ɨ²naa' 'ii? Pe wana gajin'²in: “Tsá²‑a gasii¹in 'ii”, ityá² 'nii'²¹‑tsi jileei'²¹ tsá² 'wii²¹² jilee'²¹mo 'ɨ¹‑tsi 'e la ja'²mo Wó³ do cwoo¹ júu³ tyʉ́² tya' Dios. ");
INSERT INTO chqNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","'Wii'¹³ joon gasɨɨ'²¹ɨ 'in tsá² do Jesús: ―Jo ne² jna'a. Jesús‑gɨ gasɨɨ'²¹ɨ 'ii: ―Jon'gɨ jna fo'³oo 'naa' 'in tyʉ'² to² 'e jmóo³oo la no. ");
INSERT INTO chqNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ga'láa² Jesús 'wii²¹² gatyaa¹ júu³ cwáain¹ ejemplo. Joongɨ gasɨɨ'²¹ɨ tsá²: ―Galiseein²¹ jaain²¹ tsá² 'in gajñii¹ 'mó² wuunjøø'³. Coon²¹ tyiia²¹ fee'¹ ngajna². Joon gajmaa'¹²a coon²¹ 'yá² joongɨ gajmaa¹a coon²¹ lɨ 'woo²¹ jmɨ'³ mɨ'³ wuunjøø'³ do. Gajmaa¹o jon coon²¹ po'³ níi¹ lɨ tsaun'øø'¹i tyiia²¹ tya'a. ’Mi yuui'¹³ joon gatyaa¹a cwoo²¹ 'in xeei'²¹ 'wó² tya'a do. Joon 'ña'gɨ gangóo¹ wíin². ");
INSERT INTO chqNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Mo gatɨ́² jiin²¹ 'e gafuu²¹ mɨ'³ wuunjøø'³ do joon gasii¹in jaain²¹ tsa'leei'¹³ tya'a 'e cón² 'ido jiin'¹³ mɨ'³ wuunjøø'³ 'e tsíi²i. ");
INSERT INTO chqNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Pe 'in tsá² ní² 'wó² do gasaan'¹²in 'in tsa'leei'¹³ tya' fii²¹² 'wó² do. Gajmee'²¹i joon gasiin'¹in ni 'ido jo 'e tyiian¹ coonti. ");
INSERT INTO chqNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Joon 'in tsá² fii²¹² 'wó² do gasii¹in jaain²¹gɨ tsa'leei'¹³ tya'a. Pe 'inlo‑gɨ ga'øøi¹ 'in ní² 'wó² do. Coon'¹³ cuun²¹² gauncwuu'²¹i 'in tsá² do, galiwúui¹ mootyíi¹i. Joongɨ gajíi²mo. ");
INSERT INTO chqNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Pe gasii¹mo tún¹ jaain²¹gɨ. 'Ii‑gɨ gajngaa'¹²mo. Mo lɨcɨɨin²¹ gasii¹in fúui¹gɨ pe 'inlɨ́ɨi¹³ gajmee'²¹i joon 'inlɨ́ɨi¹³gɨ gajngaa'¹²mo. ");
INSERT INTO chqNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Joon jaain²¹ jóon¹on 'ña'a 'in seein²¹ tya' fii²¹² 'wó² do 'in 'iin²¹²in 'áai¹. Joon lɨ' tséi¹ gasii¹in 'ii ga'ɨ¹‑tsi: “'Ná¹‑a ili'gøø'²¹mo yʉʉn²¹ tyiia lo.” ");
INSERT INTO chqNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pe 'in tsá² gajmaa¹a to² do gasɨ́ɨ²i jee²¹² 'ii: “'Inlo‑o 'in 'ii'²¹ jilaa'²¹ 'e 'oo¹o jmii²¹ mi júun²in 'ido. Cwojngaa'¹²na' 'ino joon ilí² tyijna'o' jilaa'²¹ 'e 'oo¹o lo.” ");
INSERT INTO chqNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","La joon gasaan'¹²in joon gajngaa'¹²mo 'in jóon¹ fii²¹² 'wó² do. Gatyii²mo 'ido lɨ tɨ' tyiia²¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","’Joon, ¿'ee ijmá¹ 'in fii²¹² 'wó² do? Ijó¹ tsifu joon ijngaa'¹²mo jileei'²¹ 'in gajmaa¹a to² do. Joon icwo'¹o 'in xeei'²¹ 'e 'wó² do. ");
INSERT INTO chqNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’¿Tɨ jo mo gauntsáa¹ 'naa' 'e jin'² ni jí² tya' Dios? 'E cuun²¹² 'e gapii²¹ 'in jmoo'¹³o 'nú¹ lɨ' co' lawaa' jo tseein²¹. Pe 'e joon cuun²¹² nifu. ");
INSERT INTO chqNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","'Elo‑o gajmaa¹a Ña'ñʉ'¹ʉ' joon 'áa¹mo 'ya'²gɨ lɨ́ɨ²na'. ");
INSERT INTO chqNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","'Wii'¹³ ñii¹ 'in tsá² do 'e faa'²¹a Jesús 'e júu³ cwáain¹ tya'a joon 'iin²¹²in saan'¹mo. Pe 'wii'¹³ 'gøø'²¹mo tsá² gatʉ́ʉ²mo 'ido. Joon ngaliin¹mo. ");
INSERT INTO chqNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Mo galɨcɨɨin²¹ gasii¹in tsacøøi'¹³ 'inlɨ́ɨi¹³ tsá² fariseos coon'¹³ tsá² tya' Herodes lɨ siin'¹² Jesús. 'Iin²¹²in jmá¹ xiiala ili'nɨ́ɨ¹i Jesús coon'¹³ júu³ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Joon gangalíin² 'inlo gasɨɨ'²¹ɨ Jesús: ―Tɨfo'², ne² jna'a 'e 'nʉ‑ʉ fo'²'o 'e la jai'² joon jo nʉʉ'¹³'ʉn 'ee jin'² jiin'¹³ jaain²¹ tsá², 'wii'¹³ joon jo jmoo²'o la lɨ́ɨi¹ tsá². Jiin'¹³ fu² tyʉ́² tya' Dios 'e'²o'o. Fu'²'u jna'a, ¿tɨ 'ná¹ tyii²¹²i' cuu² tya' tsaa'to² César tyíin¹ Roma owa'a jo tyii²¹²i' 'ee? ¿Tyii²¹²i' sɨ jo tyii²¹²i' 'ee? ");
INSERT INTO chqNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Pe li'³i Jesús 'e gó² 'e faa'²¹ 'ido. Joon gajin'²in: ―¿'Ee lɨ' 'iin²¹²naa' 'e tee'²¹ jna? Cwotyiian¹duu' coon²¹ cuu² joon jǿø³duu. ");
INSERT INTO chqNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Gangatyíian¹o joon mo ganii²¹ Jesús joon gaunngɨɨ¹ɨ: ―¿'Iin ni² 'elo joongɨ 'iin 'e sii²¹ 'e toon¹ lo? 'Ii‑gɨ gañii¹i: ―Tya' César 'edo. ");
INSERT INTO chqNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Joon gasɨɨ'²¹ɨ Jesús 'ii: ―Cwoo²oo' jon 'in tyʉ'² to² Roma jiin'¹³ 'e gatɨ́ɨ²i, la joon jon cwoo²oo' jon Dios 'e gatɨ́ɨ²i. ");
INSERT INTO chqNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Joon gangalíin² lɨ siin'¹² Jesús 'inlɨ́ɨi¹³ tsá² coon²¹ poo²¹² sii²¹ saduceos. 'In tsá² do 'ɨ¹‑tsi 'e jo jiin'¹gɨ tsá² mi júun²in. Joon gajin'² 'in tsá² do sɨɨ'²¹ɨ Jesús: ");
INSERT INTO chqNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Tɨfo'², gatyʉ'² Moisés to² jna' wana júin¹ jaain²¹ tsañʉʉ'¹ joon jo xuui²¹² seein²¹ tya' tsamɨ́² tya'a 'in ruui'²¹ 'in najúin¹ do 'ná¹ cu'²mo cwoo²¹o coon'¹³ 'in tsamɨ́² 'nɨ́ɨ² do. Joon liseein²¹ yʉʉn²¹ tya' 'in ruui'²¹ najúin¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Galɨ́² 'e galiseein²¹ dyái¹ sɨmii'²¹ la 'oo'²¹ ruu'²¹i. Joon 'in feei'¹gɨ do gacui'² cwoo²¹o. Pe gajún¹mo jo jóon¹on gasái¹. ");
INSERT INTO chqNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","'In lɨ tɨ́² ngái¹ do joon gacui'² cwoo²¹o coon'¹³ 'in tsamɨ́² 'nɨ́ɨ² do. Jún¹mo jon pe jo 'in jóon¹on 'e gasáa¹i. La joon jon galɨ́² coon'¹³ 'in lɨ gatɨ́² ngaai²¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","La joon gacui'² cwoo²¹o la jɨ dyái¹ do coon'¹³ 'in tsamɨ́² jaain²¹ do. Pe jiin'¹³ jaain²¹ jo gasáai¹ jóon¹on. Coon²¹ mo gajún¹mo jon 'in tsamɨ́² do. ");
INSERT INTO chqNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Galɨ́²‑ɨ la joon, joon nano fu'²'u jna'a, mi jiin'¹in tsá² jee²¹² 'lɨɨ²¹², ¿'naai jee 'in dyái¹ do iliin¹ tsamɨ́² tya'a? Tsʉ jɨ dyái¹ do gacu'²mo cwoo²¹o coon'¹³ 'in tsamɨ́² do. ");
INSERT INTO chqNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Joon gañii¹i Jesús tya'a: ―Jo joon, lɨ' cɨɨ'¹²ɨ 'ɨ¹‑'oo'naa' 'wii'¹³ jo cwii¹ii' jí² tya' Dios jon'gɨ 'ii'²¹ tya' Dios. ");
INSERT INTO chqNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Tsʉ mi jiin'¹ 'in najúin¹ jon'on tsañʉʉ'¹ tiin'¹³ jon'on tsamɨ́² lɨ́²gɨ cui'² cwoo²¹o. Iliin¹ la lɨ́ɨi¹ ángeles taai² ñʉ'fú². ");
INSERT INTO chqNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Joon fo'³gɨɨ júu³ xiia' cwáain¹ tya' mi jiin'¹ tsá² tún¹. ¿Tɨ jo mo ñíi² 'naa' ni jí² tya' Moisés 'e gafaa'²¹ Dios coon²¹ jee²¹² 'mó² 'e coo²¹? Gajin'²o la lo: “Jna‑a Dios tya' Abraham, joongɨ tya' Isaac, joongɨ Dios tya' Jacob”, jin'² Dios. ");
INSERT INTO chqNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Coon'¹³ la joon 'øøi'²¹‑tsi tsá² 'e Dios jon'on Dios tya' 'lɨɨ²¹² 'i pe Dios tya' 'in nijiin'¹in. 'Wii'¹³ joon jo la joon 'e 'ɨ¹‑'oo' no tsʉ jiin'¹in tsá² tún¹. ");
INSERT INTO chqNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Joon gatyiia²¹ jaain²¹ tɨfo'² tya' ley. 'Ido‑gɨ ganúu²un 'e sɨ́ɨi¹ Jesús coon'¹³ 'in saduceo do. Joon 'wii'¹³ ñii¹o 'e nigañii¹i Jesús 'e la ja'²mo joon gaunngɨɨ¹ɨ jin'²in: ―¿'Noo 'e nifu tya' jilaa'²¹ to² tyʉ'² Dios? ");
INSERT INTO chqNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesús‑gɨ gañii¹i: ―'Elo‑o nifu tya' jilaa'²¹ 'e tyʉ'² Dios to²: “Nʉʉ²duu' tsá² Israel, 'in Ña'ñʉ'¹ʉ' Dios jaan²¹mo 'i seein²¹. ");
INSERT INTO chqNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Cwoli'iin²¹²naa' Ña'ñʉ'¹ʉ' Dios tyii' ce caain²¹‑'oo'. Joon cwoli'iin²¹²naa' 'ii coon'¹³ jilaa'²¹ alma tyii' joongɨ coon'¹³ jilaa'²¹ 'e 'ɨ¹‑'oo' joongɨ coon'¹³ jilaa'²¹ wa'² pí³ tyii'. 'Elo‑o 'e nifu to² tyʉ'² Dios.” ");
INSERT INTO chqNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Joon 'e lɨ tɨ́² tún² lɨ la lɨ 'elo‑o jon: “Cwoli'iin²¹²naa' jileei'²¹ tsá² xeei'²¹ lawa yaamoo'.” Jo 'e sá² 'e to² tyʉ'² Dios 'e tyiin²gɨ lagɨ 'elo. ");
INSERT INTO chqNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Joon gajin'² 'in tɨfo'² tya' ley do: ―Tɨfo'², ja'²mo júu³ tyi'i. Jo'¹o 'e fo'² 'nʉ no. Jaan²¹mo Dios seein²¹. Jo 'in xeei'²¹gɨ seein²¹ jiin'¹³ 'ii‑o. ");
INSERT INTO chqNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Tyiin²gɨ 'e li'iin²¹²na' Dios ce caain²¹‑tsi' joongɨ 'e 'iin²¹²na' 'ii coon'¹³ jilaa'²¹ 'e 'ɨ¹‑tsi' joongɨ coon'¹³ jilaa'²¹ alma tyi' joongɨ coon'¹³ jilaa'²¹ wa'² pí³ tyi' joongɨ un'néei¹na' jileei'²¹ tsá² xeei'²¹ lawa yiia‑o'. Tyiin²gɨ 'elo lagɨ jilaa'²¹ fa'¹ 'e cwo'¹ tsá² Dios coon'¹³ jilaa'²¹ 'e jún¹ tsá² ni altar. ");
INSERT INTO chqNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Mo ganí² Jesús 'e gañii¹i 'ido røø²¹ tiin'¹³ la ja'²mo ce jilaa'²¹ joon gasɨɨ'²¹ɨ Jesús 'ii: ―Xʉʉ 'ná¹gɨ 'e tyʉ'² Dios to² 'nʉ ―jin'² Jesús. Joon jiin'¹³ jaain²¹gɨ jo tá²gɨ‑tsi 'e unngɨɨ¹gɨ. ");
INSERT INTO chqNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Joon tyíin¹ Jesús fu i'yíia² cwo'¹ 'e'²e tsá² joon jin'²in: ―¿Xiiala lɨ 'e jin'² tɨfo'² tya' ley 'e Cristo jóon¹ David 'i? ");
INSERT INTO chqNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Tsʉ 'lɨɨ²¹² David 'ña'o gajin'²in coon'¹³ 'ii'²¹ tya' 'in Espíritu Tyʉ́² tya' Dios: Dios Jmii²¹ gasɨɨ'²¹ɨ Señor tyiia: “Ní²'i caa¹na tsáa¹ ca mi lii'²oo jileei'²¹ 'in 'eei'¹ 'nʉ, joongɨ núu²o jilaa'²¹ to² 'e tyʉ'²'ʉ.” ");
INSERT INTO chqNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","¿Pe xiiala lɨ́² 'e jóon¹ David Cristo? Tsʉ 'wii'¹³ David do gaunsii²¹ 'ii Señor tyiia ―gajin'² Jesús. Joon fúu¹mo 'in tsá² taain²¹² do núu²o jløø'³mo. Núu²o coon'¹³ ce tún² jilaa'²¹ 'e jin'² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","La jee²¹² 'e'²e Jesús tsá² gajin'²o: ―Tɨ́ɨ¹moo' coon'¹³ 'in tɨfo'² tya' ley 'in 'iin²¹²in ngɨ¹ jee²¹² 'nʉ́¹ coon'¹³ 'mɨ'² cwaa²¹ joon sɨɨ'²¹ɨ tsá² 'aa²¹²u coon'²¹ tún². ");
INSERT INTO chqNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","'Ii 'noo'¹o lɨ tyiin²gɨ icwá² inʉʉ cwo'¹ sinagogas joongɨ lɨ tyʉ́²gɨ lɨ gø'² tsá². ");
INSERT INTO chqNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Joongɨ ngɨɨ¹o to² 'uun²¹ 'e sá² tya' tsamɨ́² 'nɨ́ɨi² joon wa'a jo lɨ li'³ tsá² jmoo¹‑o cwaa²¹ lɨɨlɨ júu³ tyʉ́² tya'a. Pe 'ii‑gɨ inii²¹ wúu¹gɨ. ");
INSERT INTO chqNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Joon galɨ́²‑ɨ cafu mo tyíin¹ Jesús fu i'yíia² cwo'¹ do co' lɨ si' caja to'² tsá² cuu². Jǿø² Jesús xiiala to'² tsá² cuu² do. Joon lɨ́ɨ¹ fúui¹ 'in sá² cuu² gato'¹o 'láai²gɨ. ");
INSERT INTO chqNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Jee²¹² lo‑o gatyiia²¹ jaain²¹ tsamɨ́² 'nɨ́ɨi², jaain²¹ 'yiia'nɨ́ɨ² tañíi² 'áai¹. Joon gato'¹o 'in tsamɨ́² 'nɨ́ɨi² lo tsi caja tún² centavo pi'³ ñí³ yʉ́ʉn², 'e tyíin¹xʉ lɨɨlɨ¹. ");
INSERT INTO chqNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Joon gatø'¹ Jesús tsá² tya'a joon gasɨɨ'²¹ɨ: ―'E la ja'²mo fuu²¹²uu 'naa', 'in tsamɨ́² 'nɨ́ɨi² lo nigacwoo¹ 'láai²gɨ tyani Dios la jee²¹² jileei'²¹ 'in nigato'¹ cuu² 'e caja lo. ");
INSERT INTO chqNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Tsʉ 'in catyaai² do nigacwoo¹ jiin'¹³ 'e nigasái¹ tya'a pe 'in tañíi² lo nigacwoo¹ jilaa'²¹ 'e 'oo¹o tya' 'e taain¹ fu juncwii²¹. ");
INSERT INTO chqNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Mo gacwo'ɨ́ɨ¹ Jesús fu i'yíia² cwo'¹ fee'¹ do jaain²¹ tsá² tya'a gasɨɨ'²¹ɨ 'ii jin'²in: ―Tɨfo'², ¡jǿø²du'u 'e cuun²¹² lo joon jǿø²du'u 'e 'nʉ́¹ coo'¹³ lɨɨlɨ¹ no! ¡Lɨ́ɨ¹ 'ya'²gɨ jilaa'²¹ 'elo! ");
INSERT INTO chqNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Pe Jesús‑gɨ gañii¹i: ―Nano jǿø¹³'ø 'e 'nʉ́¹ coo'¹³ lɨɨlɨ¹. Pe jée¹gɨxʉ jo iján² jiin'¹³ coon²¹ cuun²¹² 'e sɨfúui¹gɨ. Jilaa'²¹a ixée²mo. ");
INSERT INTO chqNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Joon ngalíin² fu moo' Olivos 'e si'² tyani 'e cwo'¹ fee'¹ do. Coon²¹ lɨ tyíin¹ Jesús coon'¹³ Tʉ́³ coon'¹³ Jacobo coon'¹³ Wó³ coon'¹³ Dɨ́ɨ³ gasɨɨ'²¹ɨ 'ii Jesús 'uun²¹mo: ");
INSERT INTO chqNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―'Ii²¹²i'i 'e fuu²¹du'u jna'a, ¿lɨɨ ilí² 'e nafaa'¹³'a do? ¿Noo 'e li² jmáa¹a 'e jin'² jilaa'²¹ 'elo mi lí²? ");
INSERT INTO chqNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesús‑gɨ gañii¹i: ―Tɨ́ɨ¹moo' 'e ce jiin'¹³ jaain²¹ jo 'in coon'²¹ 'naa' tóo². ");
INSERT INTO chqNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Tsʉ lɨ́ɨ¹ fúui¹ 'in jalíin² coon'¹³ 'e sii²¹ jna. Joon ijin'²in: “Jna‑a Cristo.” Joon coon'¹³ la joon icoon'¹on tsá² fúui¹ lɨɨlɨ¹ tóo². ");
INSERT INTO chqNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Pe mi núu³uun' 'e faa'²¹ tsá² 'nii²¹ jmoo¹o tsá² sɨ ijmáa¹a tsá² 'ee jo foo'¹³naa' tsʉ la joon ilí² pe jon'on mo tsée¹mogɨ joon. ");
INSERT INTO chqNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","La coon²¹ la coon²¹ nacíoi¹³ itéen²mo jon, joon la jaain²¹ la jaain²¹ tsaa'to² itéen²mo jon. Joongɨ ijøø'²¹ 'wó² lɨɨlɨ¹ la caain²¹ juncwii²¹. Joon iliun'aai² tsá² joon ito'¹ tsá² mɨɨ'¹³. Joon jiin'¹³ coon'¹³ 'elo‑o i'láa² 'wii²¹² 'e wúu¹ ijó¹. ");
INSERT INTO chqNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Pe lí'³ii' jmaa²aa', un'øø'²naa' yaanaa' tsʉ ijaain'²¹ tsá² naa' tyani tsacøøi'¹³ nisɨcaain²¹. Joon do‑o i'nɨ́ɨ¹i 'naa' joongɨ ipóo²i 'naa' tsi inʉʉ cwo'¹ sinagogas. Ilitɨɨ²¹moo' cwolíin²naa' tyani tsaa'to² tsafeei'¹ joongɨ tyani rǿøi¹³ 'wii'¹³ tyiajna‑a. Joon tyani 'in tsá² do ifoo²oo' cwáain¹ tyiia. ");
INSERT INTO chqNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Joon la nʉ'gɨ ityéi¹ juncwii²¹ 'ná¹‑a tyá² tsá² júu³ tya' xiiala ijmá¹ Dios tiin'¹³ tsá² tyani jileei'²¹ tsá² taain²¹² juncwii²¹. ");
INSERT INTO chqNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Joon mi tsajée¹i tsá² 'naa' tyani tsaa'to² jo cuu'¹³‑'oo' 'e isɨɨ'²¹naa'. Jo 'e 'ɨ¹‑'oo', jiin'¹³ cwosíi¹³ii' 'e cwo¹ 'in Espíritu Tyʉ́² tya' Dios 'naa' tsʉ jon' 'naa' 'in faa'²¹ do pe 'in Espíritu do faa'²¹a. ");
INSERT INTO chqNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ruu'²¹mo ijaan'²¹i ruu'²¹i ijúun²in, joon jmii²¹gɨ ijaan'²¹i jóon¹on. Jileei'²¹gɨ jóon¹on ili'ee'¹mo jmii²¹ joongɨ ijngaa'¹²mo. ");
INSERT INTO chqNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","'Wii'¹³ jna‑a jilee'²¹mo ili'ee'¹mo 'naa' pe tya' jileei'²¹ 'in jmoo¹o taa'²¹ coon'¹³ jna ca mi tyei¹ joon itiin'¹³mo 'ii. ");
INSERT INTO chqNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’'Lɨɨ²¹² Daniel, 'in gacwoo¹ júu³ tyʉ́² tya' Dios, gataan¹an ni mo'jí² cwáain¹ tya' jileei'²¹ 'in un'lɨɨi'³ tsá² joongɨ 'in jmoo¹o caai'²¹ tsá². Joon mi moo²oo' 'inlo taain¹ lɨ jo tɨ́ɨ²i taain¹ ('in núu²un, cwo'øø'²¹mo‑'o'o) joon 'in néei¹ Israel 'ná¹ cwiin¹in fu moo'²¹. ");
INSERT INTO chqNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Mi tɨ́² jmɨɨ²¹² joon wana teen¹in caluu 'nʉ́¹ jo lí² wa'a tsatáa¹i i'woo²¹ 'e sá² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Joongɨ wa mo 'in taain²¹² jmoo¹o to² jo lí² cwotyaliin¹ wa'a tsatyiian²¹ sɨɨ'¹³ɨn. ");
INSERT INTO chqNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","'Áai¹ gó² tya' tsamɨ́² 'in tyéin¹ yʉʉn²¹. Joongɨ lɨ́ɨ¹ fúu² 'in seein²¹ yʉʉn²¹ cuu'²¹ tʉʉ'²¹ mi tɨ́² 'e jmɨɨ²¹² joon. ");
INSERT INTO chqNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mɨ́²ɨɨ' tyani Dios wa'a jo 'ná¹ cwiin²iin' mi tɨ́² jiin²¹ cwíi². ");
INSERT INTO chqNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Lɨ́ɨ¹ lisá² wúu¹ jee²¹² jmɨɨ²¹² joon. Coon²¹ wúu¹ 'e jo mo ñii¹ tsá² ca la mo gajmaa¹a Dios juncwii²¹. Joongɨ jo lisá²gɨ mi lɨcɨɨin²¹. ");
INSERT INTO chqNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Joon wana jo unxʉ²gɨ Ña'ñʉ'¹ʉ' 'e jmɨɨ²¹² joon jo 'in taa'²¹ ce jiin'¹³ jaain²¹. Pe tsʉ 'wii'¹³ 'iin²¹²mo Dios 'áai¹ 'in tsá² do 'in gatyii'¹³in nigalixʉ²gɨ 'e jmɨɨ²¹² do. ");
INSERT INTO chqNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Joon wana 'in sɨɨ'²¹ 'naa' jin'²in: “Jǿø²øø', lo siin'¹² Cristo” sɨ jin'²in 'ee: “Jǿø²øø', do‑o siin'¹² 'i”, jo jo'¹ cwoliin¹naa'. ");
INSERT INTO chqNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Jo jo'¹ cwoliin¹naa' júu³ tya'a tsʉ ijalíin² tsá² 'in jin'² 'e Cristo 'ii sɨ 'in jin'² 'ee 'e cwoo¹ júu³ tyʉ́² tya' Dios pe jo jo'¹. Jalíin² jajmaa¹a li² milagro 'a coon'²¹on tóo² ca 'in gatyii'¹³in Dios wa' ilí². ");
INSERT INTO chqNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Pe gafuu²¹²uu 'naa' jilaa'²¹ 'elo jée¹gɨ 'e 'naa' jmaa²aa' li'³‑'oo'. ");
INSERT INTO chqNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Faa'²¹gɨ Jesús jin'in: ―Pe jee²¹² jmɨɨ²¹² joon, mi yuui'¹³ iní² tsá² wúu¹ ilinʉʉ²¹ lɨ 'íi¹ ñi'¹ jon'gɨ sɨɨ'²¹ ijnéei²gɨ. ");
INSERT INTO chqNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Joongɨ nʉ́ʉ¹ ixuu'²¹mo 'i. Joongɨ jilaa'²¹ 'e sá² lɨ' yʉ' juncwii²¹ ijlee¹. ");
INSERT INTO chqNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Joon imáa¹naa' jna, 'in Ruui'²¹ Tsá², igóo³oo jee²¹² jníi¹. Joon ityʉ'³ʉʉ to² joon 'ya'²gɨ jilaa'²¹ 'e sá² tyiia. ");
INSERT INTO chqNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Joon isɨ́ɨ³na ángeles tyiia 'e uncaain²¹ jileei'²¹ 'in gatyi'³na la jee²¹² la tøøi² cwoo'¹³ juncwii²¹. ");
INSERT INTO chqNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’'Nʉ́ʉ²duu' 'e júu³ cwáain¹ tya' 'mó² cwaríi³. Mo sii'²¹ cwáa¹a tya' joon nii'¹³ mo'³ joon ñi¹ tsá² 'e nijó¹ jiin²¹ tya' jmɨ¹. ");
INSERT INTO chqNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","La joon jon mi móo³ 'naa' 'e lɨ́² la 'e fuu²¹²uu 'naa' no liñí²ii' 'e najó² tyan'an, 'e nijatyéen¹³in. ");
INSERT INTO chqNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","'E la ja'²mo fuu²¹²uu 'naa', ilí²‑i 'elo la nʉ'gɨ ijúun²in tsá² seein²¹ nano. ");
INSERT INTO chqNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","I'íin²mo juncwii²¹ joongɨ i'íin²mo ni 'wó² pe júu³ tyiia jo 'íin² coonti. ");
INSERT INTO chqNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Pe jo ñii¹ jiin'¹³ jaain²¹ tsá² 'ee 'ii'²¹ sɨ 'ee jmɨɨ²¹² ilí² jilaa'²¹ 'elo. Jon'on ángeles taa²i ñʉ'fú² ñii¹i. Jon'gɨ ñii¹ 'in Jóon¹ Dios, jiin'¹³ la 'ña'a Dios Jmii²¹ ñii¹i. ");
INSERT INTO chqNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’'Wii'¹³ joon tyee²moo' tyʉ́² yaanaa', tyaan²aan' cwáain¹ coon'¹³ ce tún². Fee'¹³naa' Dios tsʉ jo 'in ñi¹ mi cwá² hora joon. ");
INSERT INTO chqNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","'E lɨ la lɨ lawa jaain²¹ tsañʉʉ'¹ gacwo'ɨ́ɨ¹. Ngóo¹ wíin². La jee²¹² icwo'ɨ́ɨ¹ do joon gatyʉ'²ʉ to² tsaleei'¹³. Gacwo'¹o la jaain²¹ to² jmáa¹a. Joon gasɨɨ'²¹ɨ jaain²¹ wa'a tsa'áa¹i 'ido. ");
INSERT INTO chqNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Gajin'²in: Tyee²moo' tyʉ́² yaanaa' tsʉ jo ñíi³ii' lɨɨ icwaai'² 'in fii²¹² do. Jo ñíi³ii' sɨ cwaa'²i mi 'íi¹ nʉ́ʉ³ sɨ la 'woo¹ tyíia² nʉ́ʉ¹ 'ee sɨ mi 'oo¹ tuuitsáa² 'ee sɨ 'e 'aa²¹ 'ee. ");
INSERT INTO chqNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Tyán²duu' cwáain¹ 'e joon 'e tyee²moo' tyʉ́² yaanaa' mi yíi³aa ―jin'² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Jin'²gɨ jon Jesús: ―'E fuu²¹²uu 'naa 'e fuu²¹²uu jon jilee'²¹mo: Tyee²naa' tyʉ́² yaanaa'. ");
INSERT INTO chqNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Tún² jmɨɨ²¹² 'ná¹gɨ wa'a tɨ́² pascua tya' tsá² Israel coon'¹³ jmɨɨ²¹² tya' 'e gø'² tsá² Israel 'iñi'¹ jo tyiian'³ jéei¹. Jileei'²¹ 'in tyʉ'² to² untsá² coon'¹³ tɨfo'² tya' ley 'noo'¹o xiiala ilí² saan'¹in Jesús coon'¹³ 'e coon²¹ tóo². Joon ijngaa'¹²mo 'ido. ");
INSERT INTO chqNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Pe jin'²in: ―Jo lí² jmoo²¹o' jiin'¹³ la tɨ́² jmɨɨ²¹² lo tsʉ lɨɨlɨ¹ ito'² tsá² mɨɨ'¹³. ");
INSERT INTO chqNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Taain¹ Jesús fu Betania tsi inʉʉ tya' Simon 'in jngøøi'²¹. La 'ɨɨ²¹² tyíin¹in coon²¹ lɨ si'² mesa gatyii²a jaain²¹ tsamɨ́² tyaan¹ coon²¹ sɨ́² sɨ'o² jmɨɨ²¹ jmafuu²¹ sii²¹ nardo. 'Moo'³ tyíin¹ 'e nardo do. Joon 'in tsamɨ́² do gajaa¹a luu²¹² 'e sɨ́³ do joon ga'íi²in 'e jmɨɨ²¹ jmafuu²¹ do mootyi² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Joon 'inlɨ́ɨi¹³ 'in néei¹ do gali'nii'²¹i‑tsi joon gasɨ́ɨ²i jee²¹² 'ii: ―¿'Ee lɨ' ganga'ɨ́ɨ¹ 'e jmɨɨ²¹ jmafuu²¹ lo? ");
INSERT INTO chqNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Tsʉ ilí² tsa'nɨɨ²¹² do coon'¹³ coon²¹ mil tsi ca 'no'³ cuu². Joon li cwo'¹o tsá² tañíi². Joon gali'ee'¹mo 'in tsamɨ́² do. ");
INSERT INTO chqNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Pe gajin'²in Jesús: ―Jo 'ee fuu'²¹gɨɨ' 'ino. ¿'Ee lɨ' untyíi²naa' 'ino? Coon²¹ 'e tyʉ́²‑ʉ gajmaa¹a 'ino tyiia. ");
INSERT INTO chqNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Tsʉ 'in tañíi² ngɨ¹ coon'¹³ 'naa' coon²¹ tøø²mo pe jna‑gɨ jo seen²¹na coon'¹³ 'naa' coon²¹ tøøi². ");
INSERT INTO chqNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","'In tsamɨ́² lo gajmaa¹o jiin'¹³ 'e li'³i, nigaya'²o jmɨɨ²¹ jmafuu²¹ cuerpo tyiia tya' mi 'á¹na. ");
INSERT INTO chqNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","'E la ja'²mo fuu²¹²uu 'naa', doñixiia' 'e licwá² júu³ tya' xiiala itiin'¹³ tsá² la caain²¹ juncwii²¹ ityá² tsá² júu³ 'e gajmaa¹a 'in tsamɨ́² lo. Joon untii'¹³‑tsi tsá² 'ii. ");
INSERT INTO chqNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Joon Judas Iscariote, jaain²¹ jee²¹² 'in dyatuuin¹ tsá² tya'a, gangóo¹ ngasíin¹in coon'¹³ 'in tyʉ'² to² tya' untsá² xiiala lí² jaan'²¹in Jesús ja'cwoo²¹o 'ido. ");
INSERT INTO chqNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Joon mo ganúu²un 'ido 'elo joon galijløø'³mo lɨɨlɨ¹. Joon gasɨɨ'²¹ɨ Judas 'e cwo'¹o 'ido cuu². Coon'¹³ la joon ga'noo'¹²on Judas xiiala jaan'²¹in Jesús. Joon ga'noo'¹²on 'ee hora 'e ilí² jaan'²¹in. ");
INSERT INTO chqNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Gacwaa²¹ jmɨɨ²¹² joon ga'láa² 'wii²¹² jmɨɨ²¹² 'e gø'² tsá² Israel 'iñi'¹ jo tyiian'³ jeei¹. Mo jmoo¹o tsá² Israel jmɨɨ²¹² cwaa'²¹ jmɨɨ²¹² tya'a 'e joon jngaai'¹² tsá² joo'saa'²¹ tya' 'e jmɨɨ²¹² joon. Joon gaunngɨɨ¹ɨ tsá² tya' Jesús 'ii: ―¿Xiiafu 'iin²¹²u'un tsatyaa²¹a'a tyʉ́² 'e tyee²e' tya' jmɨɨ²¹² pascua 'e gatɨ́²? ");
INSERT INTO chqNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Joon gasii¹in Jesús gái¹ tsá² tya'a sɨɨ'²¹ɨ: ―Cwolíin²naa' 'e fuu²¹ fee'¹ joon do‑o imáa¹naa' jaain²¹ tsañʉʉ'¹ tyan¹ coon²¹ tsʉʉ² sɨ'o² jmɨɨ²¹. Joon cwolíin²moo' xiiafu lɨ tsee'¹²i. ");
INSERT INTO chqNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Joon lɨ 'íi¹ do‑o jon fú²uu' 'in tsá² fii²¹² 'nʉ́¹ do: “Gajin'²o Tɨfo'²: ¿Xiia cuarto lɨ ityee²e'e coon'¹³ tsá² tyiia tya' jmɨɨ²¹² 'e gatɨ́²?” ");
INSERT INTO chqNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Joon i'e'²e 'naa' coon²¹ cuarto fee'¹ 'e nilɨ́² tyʉ́² lɨ' yʉ'. Do‑o tyá²aa' tyʉ́² 'e tyee²e'. ");
INSERT INTO chqNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ga'woo²¹mo 'in tsá² tya'a do. Gangalíin²mo 'e fuu²¹ fee'¹ do joon galɨ́²‑ɨ jilaa'²¹ jiin'¹³ la gajin'² Jesús do. Joon do‑o gatya¹ tyʉ́² 'ee dø'¹ø tya' jmɨɨ²¹² do. ");
INSERT INTO chqNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Mo ga'í¹ nʉ́ʉ³ joon gatyii²¹a Jesús coon'¹³ jiin'¹³ dyatuuin¹ tsá² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Joon la 'ɨɨ²¹² néei¹ gø'²ø gajin'² Jesús sɨɨ'²¹ɨ tsá² tya'a do: ―'E la ja'²mo fuu²¹²uu 'naa', jaain²¹ jee²¹² 'naa' 'in néei¹ gø'² coon'¹³ jna lo ijaan'²¹mo jna. ");
INSERT INTO chqNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Gatoo'²¹ fa'í³ tya' 'in catyaai² do. Joon gaunngɨɨ¹ɨ tɨ' jaain²¹, jin'²in: ―¿Tɨ jna‑a 'i? Joon jaain²¹gɨ gajin'²in: ―¿Tɨ jna‑a 'i? ");
INSERT INTO chqNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesús‑gɨ gañii¹i tya' tsá² tya'a: ―'Ii jaain²¹ jee²¹² 'in dyatuuin 'naa' lo. 'In gø'² coon'¹³ jna coon'¹³ coon²¹ wúun¹ 'ii 'i. ");
INSERT INTO chqNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","La joon ijúuin² 'in Ruu'²¹i Tsá² jiin'¹³ la jin'² ni jí² tya' Dios pe fúu² 'in jaain'²¹ 'ii do. Tyʉ́²‑gɨ tya' 'in jaain'²¹ 'ii do wa mo'o jo galiseen²¹mo. ");
INSERT INTO chqNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","La 'ɨɨ²¹² néei¹ Jesús gø'²ø joon gatøø¹i coon²¹ 'iñi'¹, gason'¹on joon gacwo'¹o 'maai'¹³ Dios joon gafiin¹in, joon cwo'¹o jileei'²¹ tsá² tya'a jin'²in: ―Tyé²ee' 'e lo tsʉ cuerpo tyiia‑oo lo. ");
INSERT INTO chqNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Mi yuui'¹³ joon gaunrøø¹i coon²¹ vaso vino. Joon mo ngayuui'¹³ gacwo'¹o 'maai'¹³ Dios joon gajmaa¹a jmai'xʉ 'uun'²¹ jilee'²¹mo. ");
INSERT INTO chqNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Mo ngayuui'¹³ joon gasɨɨ'²¹ɨ tsá² tya'a: ―'Elo‑o jmɨ́³ɨɨ tya' coon²¹ júu³ 'e 'mɨ́ɨ² 'e nigacwóo³‑oo tuun²¹ 'wii'¹³ tya' 'in fúui¹ lɨɨlɨ¹. ");
INSERT INTO chqNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","'E la ja'²mo fuu²¹²uu 'naa', jo 'e duu'¹³gɨɨ e jmɨ'³ 'mi'³ wuunjøø'³ ca mi cwá² jmɨɨ²¹² mi tyʉ'² Dios to². Joongɨ lí²‑i duu'¹³uu vino 'múui² tún¹. ");
INSERT INTO chqNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Mo ngayuui'¹³ ga'øø¹ø joon ngalíin²mo fu moo'²¹ sii²¹ moo'²¹ Olivos. ");
INSERT INTO chqNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Joon gasɨɨ'²¹ɨ Jesús tsá² tya'a: ―Jilee'naa' 'e jo litsáai¹‑'oo' jna 'e woo¹ no tsʉ ni jí² tya' Dios jin'²in: “Ijngaa'¹³moo 'in 'aai¹ joo'saa'²¹ joon ingɨ¹ sɨtuu¹mo 'in joo'saa'²¹ do.” ");
INSERT INTO chqNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Pe mi yuui'¹³ 'e gajiin'¹ jna iní³ii nifugɨ la 'naa' fu Galilea. ");
INSERT INTO chqNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Joon gasɨɨ'²¹ɨ Tʉ́³ 'ii: ―Fiin'¹³ jilee'²¹mo jo litsáai¹‑tsi 'nʉ pe jna‑a jo lɨ́ɨ¹na la joon. ");
INSERT INTO chqNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Pe Jesús‑gɨ gasɨɨ'²¹ɨ 'ii: ―'E la ja'²mo fuu²¹²uu 'nʉ, 'e 'woo¹ no la jée¹gɨ 'i'oo¹o tún² naa'¹³ 'in tuuitsáa², 'nɨ¹ naa'¹³ jo røø²¹u 'e cwii¹u'un jna. ");
INSERT INTO chqNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pe 'ii‑gɨ jo gacwoo¹ júu³ jin'²in: ―Fiin'¹³ júun²moo coon'¹³ 'nʉ jo fo'³oo 'e jo cwii¹na 'nʉ. Joongɨ jilee'²¹mo jin'²in la do‑o jon. ");
INSERT INTO chqNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Joon mo gatyalíin² coon²¹ lɨ sii²¹ Getsemaní joon gasɨɨ'²¹ɨ Jesús tsá² tya'a: ―Ní²duu' lo la 'ɨɨ²¹² ní³ii nifoo'¹³na Dios. ");
INSERT INTO chqNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Joon gajée¹i jiin'¹³ Tʉ́³ coon'¹³ Jacobo coon'¹³ Wó³. Joon ga'láa² 'wii²¹² lɨ́² xuui²¹²‑tsi joongɨ 'áai¹ fa'í³ lɨ́ɨ²i. ");
INSERT INTO chqNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Joon gajin'² Jesús: ―Lɨ́ɨ¹ fa'í³ lɨ́ɨ²na ca la lɨ́² ijúun²moo, jan²duu' lo jo cwocwuui²¹du'naa'. ");
INSERT INTO chqNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Joon gangó¹ Jesús ca nifugɨxʉ. Joon gatyii²¹a ni 'wó² joon gamɨɨ¹ɨ tyani Dios Jmii²¹ wa'a ilí² sɨ'nee'¹³mo 'e jo nii²¹ wúu¹ la lɨ́² ilí² 'e hora joon. ");
INSERT INTO chqNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","La jee²¹² faa'²¹a fo'² do joon gajin'²in: ―Ñʉ'², tyi'nʉ‑ʉ jilaa'²¹a ilí², jo cwo'²'o 'e mó³oo wúu¹ la lɨ́² 'elo. Pe jo cwo'²'o lí² la lɨ́ɨi² jna, cwolí²‑i la lɨ́ɨ²i 'nʉ‑ʉ. ");
INSERT INTO chqNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Mo ngayuui'¹³ do joon gacwéi¹ tún¹ lɨ néei¹ tsá² tya'a joon mo gatyee'¹²i joon nitee'¹²i 'ido cwuu²¹mo. Joon gasɨɨ'²¹ɨ Jesús Tʉ́³: ―Simón, ¿tɨ cwuu²¹mo'o? ¿Tɨ jo galɨ́² 'e jo cwuu²¹mo'o jiin'¹³ coon²¹ hora? ");
INSERT INTO chqNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Unjnaa'²¹‑'oo' joon fee'¹³naa' Dios joon jo coon'²¹ Satanás 'naa' tóo². 'E la ja'²mo, náa¹ tyʉ́² tya' alma tyii' 'e 'iin²¹²mo pe cuerpo‑gɨ 'wo² sɨ'ɨ́ɨ¹‑tsi. ");
INSERT INTO chqNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Joon gangó¹ Jesús tún¹, ngafee'¹³i Dios tún¹ joon jin'²in 'e nafaa'²¹a do tún¹. ");
INSERT INTO chqNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Joon gacwéi¹ tún¹ joon gatsee'²¹i tsá² tya'a tee'¹²i cwuu²¹mo tún¹ 'wii'¹³ unníi¹i do jnɨɨ¹ jalicwuu²¹i. Joon jo ñíi¹i 'ee ñii¹i. ");
INSERT INTO chqNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Gangó¹ Jesús gatɨ́² 'nɨ¹ naa' joon mo gacwéi¹ tún¹ gajin'²in: ―Cwocwuu²¹moo' no. Cwo'ii'²¹ 'woo'²¹oo'. Naliin¹mo jiin'¹³ la no 'wii'¹³ nigacwá² hora. Ijaan'²¹in 'in Ruu'²¹i Tsá² ja'cwoo²¹o 'in 'oo¹o tsaa². ");
INSERT INTO chqNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Raan²naa' no, moo²¹o' no. Ni joo¹‑o 'in jaain'²¹ jna ―gajin'² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Faa'²¹gɨ Jesús siin'¹²in mo gacwéi¹ Judas, 'ii jaain²¹ jee²¹² 'in dyatuuin¹ tsá² tya'a. Joon jalíin² coon'¹³on 'in tsá² fúui¹ lɨɨlɨ¹ 'in tyan¹ ñí² espadas coon'¹³ 'in san'¹ 'no'³ 'mó². Jalíin² to² tyʉ'³ 'in tyʉ'² to² tya' untsá² joongɨ to² tyʉ'² jileei'²¹ tsacøøi'¹³. ");
INSERT INTO chqNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Joon 'in Judas do, 'in gajaain'²¹ Jesús, nigacwoo¹ coon²¹ li² jin'²in: ―'In cu'³uu ju'² do 'ii 'i. Seen'¹²naa' tá², ñʉʉ²ʉʉ' tyʉ́² lɨɨlɨ¹. ");
INSERT INTO chqNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Joon mo gatyii²¹a Judas joon gangatyéen¹in lɨ siin'¹² Jesús joon gasɨɨ²¹ɨ: ―Tɨfo'², Tɨfo'². Joon gacuu'²¹u ju'² 'ido. ");
INSERT INTO chqNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Joon tsifu gasaan'¹²in 'in nitéein¹ do Jesús. Joon gatǿø¹ø tyitsaa²¹²mo Jesús ");
INSERT INTO chqNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Pe jaain²¹ 'in téein² do gasø'¹ø ñí³ espada tya'a joon gatyʉ'²ʉ cataain²¹ loocwoo² tsa'leei'¹³ tya' 'in tyʉ'² to² tya' untsá² nifu do. ");
INSERT INTO chqNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Joon gasɨɨ'²¹ɨ Jesús 'in catyaai² do: ―¿Tɨ niga'woo²¹naa' coon'¹² ñí³ espada coon'¹³ 'no'³ 'mó² wa'a saan'¹²naa' jna lawa jaain²¹ 'uun²¹? ");
INSERT INTO chqNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","La coon²¹ jmɨɨ²¹² siin'¹²na coon'¹³ 'naa' fu i'yíia² cwo'¹ do joon jo‑gɨ mo seen'¹²naa' jna. Pe 'elo‑o ilí² joon itsín¹ jiin'¹³ la jin'² ni jí² tya' Dios. ");
INSERT INTO chqNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Joon tsifu joon gacwiin¹in 'in tsá² tya'a 'goo'²¹o. Joon Jesús do gajaan¹o. ");
INSERT INTO chqNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Pe jaain²¹ sɨmii'²¹ 'in paai'²¹ 'mɨ'² taa²¹ ngóo¹ caluu lɨ ngóo¹ Jesús. Joon gasan'²mo tsá² 'ii. ");
INSERT INTO chqNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Joon tsifu joon gatʉ́² 'ido 'e 'mɨ'² taa²¹ do joon gacwiin¹o tɨ' ringúu¹i coonti. ");
INSERT INTO chqNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Joon gangajée¹i 'in tsá² do Jesús tyani 'in tyʉ'² to² nifu tya' untsá² coon'¹³ 'in tyʉ'² to² tya' untsá² coon'¹³ tsacøøi'¹³ coon'¹³ tɨfo'² tya' ley lɨ sɨcaain²¹. ");
INSERT INTO chqNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Joon wíin²gɨxʉ ngóo¹ Tʉ́³ caluu joon gatyii²¹a 'ii tyi¹ ca'nʉ tya' 'in tyʉ'² to² nifu tya' untsá². Joon do‑o gacwó²o coon'¹³ 'láa² 'in néei¹ do untyaa'¹i yaai co' jɨ́². ");
INSERT INTO chqNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","'In tyʉ'² to² untsá² coon¹³ jileei'²¹ tsacøøi'¹³ néei¹ do 'noo'¹o coon²¹ tsaa² tya' Jesús 'e 'nɨɨ¹i joon lisá² júu³ ijngaa'¹²mo 'ido. Pe jo gatsaa'²¹a jiin'¹³ coon²¹. ");
INSERT INTO chqNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Tsʉ lɨ́ɨ¹ fúui¹ 'in faa'²¹a júu³ tajuu²¹ tya' Jesús pe jo coon²¹ røø²¹ faa'²¹a la jaain²¹. ");
INSERT INTO chqNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","'Inlɨ́ɨ¹³ garóon²on 'nɨɨ¹i 'ido coon'¹³ júu³ tajuu²¹ jin'²'in: ");
INSERT INTO chqNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Jna'a ninʉʉ²¹ʉ'ʉ 'e jin'² 'ino: “Jna ifíin³na 'e cwo'¹ fee'¹ no 'e nigajmaa'¹² tsá² joon jee²¹² 'nɨ¹ jmɨɨ²¹² isaa'¹³aa coon²¹ cwo'¹ jon'on jma'² tsá².” Júu³ joon ganʉʉ²¹ʉ'ʉ tya' 'in tsá² no ―jin'² 'in tsá² tajuui²¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Pe jiin'¹³ coon²¹ júu³ 'e tyaa¹ lo jo røø²¹ sɨ́ɨ¹i. ");
INSERT INTO chqNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Joon garóon²on jee²¹² 'in tsá² do 'in tyʉ'² to² nifu tya' untsá² joon gaunngɨɨ¹ɨ Jesús: ―¿Tɨ jo 'ee ngɨɨ²'ɨ coonti? ¿'Ee fo'²'o 'wii²¹² tyi'i no? ");
INSERT INTO chqNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Pe lɨ goon²¹ gajaan¹ tii² Jesús. Jo 'ee gañii¹i coonti. 'In tyʉ'² to² nifu tya' untsá² do gaunngɨɨ¹ɨ tún¹ jin'²in: ―¿Tɨ 'nʉ‑ʉ Cristo, 'in Jóon¹ Dios nicwaai'³? ");
INSERT INTO chqNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesús‑gɨ gasɨɨ'²¹ɨ 'ii: ―Jna‑gɨ 'i. Joon imáa¹naa' 'in Ruui'²¹ Tsá² tyíin¹ lɨ' caai²¹ Dios Jmii²¹ tsáa¹. Joongɨ ijó¹ jee²¹² jníi¹ lɨ' yʉ'. ");
INSERT INTO chqNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Tsifu joon ga'gɨ́ɨ¹ɨ sɨ́ɨn'¹³ɨn 'in tyʉ'² to² untsá² do joon gajin'²in: ―Jo 'néi¹gɨ' 'in jmá² júu³ røø²¹ no. ");
INSERT INTO chqNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ganʉʉ²¹o' jilee'²¹na' xiiala nigaungøøi¹ 'ino Dios coon'¹³ júu³ tya'a. ¿'Ee lɨ́ɨ²naa' 'e jmoo²¹o' coon'¹³ 'ino? Joon jilee'²¹mo gajin'²in 'e 'ná¹ júun²mo Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Joon 'inlɨ́ɨi¹³ ga'láa² 'wii²¹² 'ñíi¹i Jesús. Gajnii¹i unni² 'ido joongɨ poo¹i Jesús joon sɨɨ'²¹ɨ 'ido jin'²in: ―Faa'¹³du'u, ¿'iin 'in gapooi¹ 'nʉ? Joon ga'láa² 'wii²¹² 'ɨɨ'¹³ jnóo¹o mooni² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ca tɨ́² 'wii²¹² 'iityi¹ siin'¹² Tʉ́³. Joon gatyii²¹a jaain²¹ jee²¹² 'in jmoo¹o 'ee gø'² 'in tyʉ'² to² nifu tya' untsá² do. ");
INSERT INTO chqNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Joon mo ganí²i Tʉ́³ 'e siin'¹²in do untyaai'² 'ña'a co' jɨ́² joon gajaan¹ jǿø²i joon gajin'²in: ―Ngɨ́² 'nʉ jon coon'¹³ Jesús tsá² Nazaret. ");
INSERT INTO chqNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pe Tʉ́³gɨ jo garøøi²¹ jin'²in: ―Jo cwii¹na 'ino. Jo ñí³ii 'ee 'e fo'²'o no. Joongɨ gacwo'ɨ́ɨ¹o lɨ' 'oo¹ lɨ tsataai² tsá². Joon ga'oo¹o tuuitsáa². ");
INSERT INTO chqNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","'In tsamɨ́² do gajǿø²i Tʉ́³ tún¹ joon gasɨɨ'²¹ɨ tún¹ 'in téein² do: ―Jaain²¹ tsá² tya' 'ido‑o 'in tsañʉʉ'¹ lo. ");
INSERT INTO chqNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pe jo garǿø¹i Tʉ́³ tún¹. Jee²¹² catá²‑a tún¹ 'in téein² do gasɨɨ'²¹ɨ tún¹ Tʉ́³: ―La ja'²mo, 'nʉ‑ʉ jaain²¹ 'in tya' 'ido tsʉ 'in seein²¹ Galilea 'nʉ, joongɨ la faa'²¹ 'ido‑o la joon foo'²¹ 'nʉ. ");
INSERT INTO chqNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Joon ga'láa² Tʉ́³ 'wii²¹² faa'²¹a 'laa'²¹ 'ée¹i Dios jin'²in: ―Ni Dios jo cwii¹na 'in tsañʉʉ'¹ no 'in 'ée¹naa' no. ");
INSERT INTO chqNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Joon tsifu gatɨ́² tún² naa'¹³ ga'oo¹o tuuitsáa². Joon gatɨ'²‑tsi Tʉ́³ do 'ee nigasɨɨ'²¹ɨ Jesús 'ii: “La jo‑gɨ mo 'oo¹o tún² naa'¹³ tuuitsáa² jo røø²¹u 'e cwii¹u jna 'nɨ¹ naa'¹³.” Joon mo gatɨ'²‑tsi Tʉ́³ 'elo joon gatyi'²o. ");
INSERT INTO chqNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Mo gajná² joon, joon 'in tyʉ'² to² tya' untsá² galicaain²¹ tún¹ coon'¹³ jileei'¹³ tsacøøi'¹³ coon'¹³ 'in tɨfo'² tya' ley coon' jileei'²¹ tsacøøi'¹³ 'in tyiin²gɨ. Joon ngajée¹i Jesús sɨñuu¹mo joon gangajaan'¹²in tyani Pilato. ");
INSERT INTO chqNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Joon gaunngɨɨ¹ɨ Pilato Jesús: ―¿Tɨ 'nʉ rǿøi¹³ tya' tsá² Israel? Jesús‑gɨ gañii¹i: ―'E joon foo'²¹gɨ 'nʉ. ");
INSERT INTO chqNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Jileei'²¹ 'in tyʉ'² to² tya' untsá² ga'nɨɨ¹i Jesús lɨɨlɨ¹. ");
INSERT INTO chqNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Joon gaunngɨɨ¹ɨ Pilato Jesús tún¹ jin'²in: ―¿Tɨ jo 'ee ngɨ́ɨ¹²'ɨ coonti? Jǿø²du'u xiiala 'nɨ́ɨ¹i 'nʉ lɨɨlɨ¹. ");
INSERT INTO chqNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Pe jo gañii¹i Jesús coonti. 'Wii'¹³ joon lɨ́ɨ¹ tsa'goo²¹‑tsi Pilato. ");
INSERT INTO chqNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","La nitɨ́ɨ²i Pilato 'e láa²i jaain²¹ 'in 'yuui² 'nʉñí³ la jee²¹² 'e tɨ́² jmɨɨ²¹² joon. Joon galáa²mo jaain²¹ 'in muui¹ 'in tsá² do. ");
INSERT INTO chqNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Joon 'yuui² 'nʉñí³ jaain²¹ 'in sii²¹ Barrabás, 'ii jee²¹² 'in nigajngaai'¹²gɨ tsá² coon²¹ lɨ nigatíin¹in coon'¹³ tsaa'to². ");
INSERT INTO chqNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Joon gangalíin² tsá² joon gamɨɨ¹ɨ tyani Pilato 'e jmá¹ 'ido 'e la tɨɨsi'². ");
INSERT INTO chqNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilato‑gɨ gañii¹i: ―¿Tɨ 'iin²¹²naa' 'e láa²na Rǿøi¹³ tya' tsá² Israel? ");
INSERT INTO chqNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Jin'² Pilato la no 'wii'¹³ li'³o 'e gajaan'¹²in 'in tyʉ'² to² tya' untsá² Jesús 'wii'¹³ tsiiwúu¹mo tya' Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pe 'in tyʉ'² to² tya' untsá² do nigasɨɨ'²¹o Pilato 'e tyʉ²gɨ wa'a láa¹i 'ido Barrabás. ");
INSERT INTO chqNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Joon gaunngɨɨ¹ɨ tún¹ Pilato: ―¿'Ee 'iin²¹²naa' lí² coon'¹³ 'in sii²¹ Rǿøi¹³ tya' tsá² Israel lo? ");
INSERT INTO chqNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Joon gañii¹i tsá², 'oo¹o tá² lɨɨlɨ¹ jin'²in: ―¡Téen¹in 'ido tsaa' crúu¹³ no! ");
INSERT INTO chqNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Gasɨɨ'²¹ Pilato tún¹ 'in tsá² do jin'²in: ―¿'Ee gó² nigajmaa¹a 'inlo? Pe 'in tsá² do gañii¹i tún¹ tá² lɨɨlɨ¹ jin'²in: ―¡Téen¹in 'ido tsaa' crúu¹³ no! ");
INSERT INTO chqNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Joon 'wii'¹³ 'iin²¹²in Pilato ján² røø²¹ coon'¹³ 'in tsá¹ do joon galáa²mo Barrabás joongɨ gatyʉ'²ʉ to² póo²i Jesús joon gajaan'¹²in 'ido wa'a téen¹in tsaa' crúu¹³. ");
INSERT INTO chqNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Mo ngayuui'¹³ joon, joon gatyii¹mo 'láa² Jesús tyani Pilato joon gangajée¹i 'ii tyi¹ tya' rǿøi¹³ lɨ sii²¹ Pretoria. Joon gauncaain²¹ ce jileei'²¹ 'láa². ");
INSERT INTO chqNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Joon tyii'²¹i Jesús coon²¹ 'mɨ'² yóoin² nʉʉ'² la lɨ́¹ 'e tyi'² rǿøi¹³. Coon²¹gɨ corona lɨ́² jmaai'² tóon¹ gaton'¹ mootyi² Jesús. Coon'¹³ la joon ga'láa² 'wii²¹² lʉʉ'²¹i Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Joon ga'láa² tsá² do 'wii²¹² 'aa'²¹i Jesús jin'²in: ―¡Viva Rǿøi¹³ tya' tsá² Israel! ¡Wóo²‑o cwoseein²¹! ");
INSERT INTO chqNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Joon coon'¹³ 'no'³ sɨɨ² cwaa²¹ gapó² mootyi² Jesús joon ga'ñíi¹i Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Mo ngayuui'¹³ gaungøøi¹ la no joon gatyíi³o 'a 'mɨ'² yóoin² nʉʉ'² do joon gacɨ'¹ɨ tún¹ Jesús sɨɨn'³ɨn do‑o. Tsifu joon gatyii¹mo Jesús itéen¹in 'ido crúu¹³. ");
INSERT INTO chqNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Jaain²¹ tsá² seein²¹ Cirene sii²¹ Simón, jmii²¹ Alejandro coon'¹³ Rufo, najaa'¹²i lɨ tsajmaa¹a to². Joon mo gangɨ́ɨ¹i do 'in 'láa² do gatyʉ'²ʉ to² 'ido wa'a coon²¹ crúu¹³ tya' Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Joon gangajée¹i Jesús fu coon²¹ lɨ sii²¹ Gólgota, coon²¹ lɨ 'øøi'²¹‑tsi tsá² sii²¹ Mootyi² 'Lɨɨ²¹². ");
INSERT INTO chqNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Joon gacwo'¹o 'ido Jesús vino caai'¹³ jmɨ'³ 'mó² sii²¹ mirra pe Jesús‑gɨ jo ga'un'²un 'edo. ");
INSERT INTO chqNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Joon gateen¹in tsaa' crúu¹³ do. Joon 'in 'láa² do gajmaa¹a jmaai'²xʉ sɨɨn'³ Jesús. Gacoo¹o 'iin lii'¹i la jaain²¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","'Iin² ñʉ́³ ningóo¹ mo gateen¹in Jesús tsaa' crúu¹³. ");
INSERT INTO chqNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Joon gataan¹an coon²¹ júu³ yʉ' tyi² Jesús 'e faa'²¹a 'e ga'nɨɨ¹i Jesús. Faa'²¹a la lo: “Rǿøi¹³ tya' tsá² Israel 'ino.” ");
INSERT INTO chqNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Caan²¹mo gataain¹ Jesús tsaa' crúu¹³ coon'¹³ gái¹ 'uun²¹, jaain²¹ lɨ' caai tsáa¹ jaain²¹gɨ lɨ' caai²¹ tooin²¹². ");
INSERT INTO chqNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","La joon 'e gatsín¹ 'e jin'² ni jí² tya' Dios: “Gaun'íi³in tsá² 'ii jee²¹² 'in gó².” ");
INSERT INTO chqNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Jileei'²¹ 'in ngɨɨ¹i do gajíi²mo Jesús joon gajøø'²¹ø mootyíi¹i jin'²in: ―'Nʉ‑ʉ 'in ifiin¹ cwo'¹ do joon jee²¹² 'nɨ¹ jmɨɨ²¹² ijmáa³o'o tún¹, ");
INSERT INTO chqNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","laai²¹² 'wo'o no. Cwúui¹ tsaa' crúu¹³ no. ");
INSERT INTO chqNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","La joon jon 'in tyʉ'² to² tya' untsá² coon'¹³ tɨfo' tya' ley gaungøøi¹ Jesús sɨɨ'²¹ɨ ruu'²¹i: ―Galáa²mo 'in xeei'²¹ joon 'ña'gɨ jo lí² lái¹ 'ña'a. ");
INSERT INTO chqNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Wana ganee²¹e' gajngaa¹i tsaa' crúu¹³ tya'a 'ña'a joongɨ lí² jo'¹o lɨ́ɨ²na' 'e 'ii‑o Cristo, Rǿøi¹³ tya' tsá² Israel. Joon cagɨ 'in gataain¹ crúu¹³ coon'¹³ Jesús gajíi²mo 'ii. ");
INSERT INTO chqNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Mo gatɨ́² tyiiañi'¹ galinʉʉ²¹ coonti ca 'iin² 'nɨ¹ ca'lóo². ");
INSERT INTO chqNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Mo gatɨ́² 'e hora joon ga'oo¹o Jesús jin'²in: ―Eloi, Eloi, ¿lama sabactani? ('E 'øøi'²¹‑tsi jin'²in: Dios tyiia, Dios tyiia, ¿'ee lɨ' nigatíiu¹³'u jna?) ");
INSERT INTO chqNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","'Inlɨ́ɨi¹³ 'in téein² do niganúu²un joon gajin'²in: ―Nʉ́ʉ²duu', nitø'¹ø Elías. ");
INSERT INTO chqNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Joon gangó¹ jaain²¹ cwiin¹in. Mo ngayuui'¹³ gaun'laa²¹ coon²¹ esponja coon'¹³ vino tiin'²¹ joon gauntyii²¹ coon nii²¹² sɨɨ² gacwo'¹o Jesús. Joon gajin'²in: ―Jaan²duu', nee²du' wana jó¹ Elías jaxáa¹i 'ino. ");
INSERT INTO chqNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Tsifu joon ga'oo¹o Jesús coon²¹ naa'¹³ tá² lɨɨlɨ¹ joon gajún¹mo. ");
INSERT INTO chqNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Joon coon²¹ 'mɨ'² 'íi¹ inʉʉ cwo'¹ fee'¹ do ga'gɨɨ²¹ coonti tún² fóo¹³. Tɨ́² yʉ' joongɨ ca tɨ́² 'wii²¹² ga'gɨɨ²¹. ");
INSERT INTO chqNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Joon 'in tyʉ'² to² 'láa² romano 'in siin'¹² tyani lɨ taain¹ Jesús do mo ganii²¹ xiiala ga'oo¹o Jesús joongɨ xiiala gajúin¹ 'ido joon gajin'²in: ―'E la ja'²mo, 'in tsañʉʉ'¹ lo Jóon¹ Dios 'i. ");
INSERT INTO chqNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Coon²¹ lɨ téein² tsamɨ́² wíin²gɨ gajǿø²ø. Jee²¹² 'ii siin'¹² María Magdalena joongɨ María sáa³ Jacobo 'in xuui²¹²gɨ Sé³. Joongɨ siin'¹² Salomé do. ");
INSERT INTO chqNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","'In tsamɨ́² lo nigangɨɨ¹ coon'¹³ Jesús. Joongɨ nigajmaa¹a 'e dø'¹ 'ido la 'ɨɨ²¹² gangɨɨ¹ Jesús Galilea. Joongɨ fúu¹mo tsamɨ́² 'in téein² do 'in gangalíin² coon'¹³ Jesús Jerusalén. ");
INSERT INTO chqNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Joon la xʉʉ tiin¹xʉ 'wii'¹³ 'e jmɨɨ²¹² tya' 'e tyaa¹ tyʉ́² ('øøi'²¹‑tsi tsá² cwoon'¹ 'ló¹ jmɨɨ²¹² 'ii'²¹ 'woo'²¹ tsá²) ");
INSERT INTO chqNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","joon gajó² Sé³, tsá² seein²¹ coon fuu²¹ sii²¹ Arimatea. 'In Sé³ no jaain²¹ jee²¹² tsacøøi'¹³ joon jaain²¹ tsá² 'in sɨján¹an jmɨɨ²¹² mi tyʉ'² Dios to². Jo 'goo'²¹o coonti. Ga'í¹ 'ido tyani Pilato joon gamɨɨ¹o cuerpo tya' Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato do ganga'goo²¹‑tsi 'e najún¹mo Jesús jmoono. Joon gatø'¹ø 'in tyʉ'² to² 'láa² do gaunngɨɨ¹ɨ wa'a jo'¹o gajúun²in. ");
INSERT INTO chqNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Mo gajin'² 'in tyʉ'² to² 'láa² do 'e jo'¹o gajúun²in joon gacwoo¹ Pilato cuerpo tya' Jesús 'e cón² Sé³ do. ");
INSERT INTO chqNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Tsifu joon galó² Sé³ do coon²¹ 'mɨ'² taa²¹ tyʉ́². Joon gaxíia² cuerpo tya' Jesús joon gacɨn'¹ɨn 'e 'mɨ'² taa²¹ do. Joon gataan'¹²in coon²¹ tsi 'aan¹ lɨ² coon²¹ tsaa' xá¹. Joon gasii'²¹i coon²¹ cuun²¹² 'ootoo²¹ 'aan¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Joon ganii²¹ María Magdalena coon'¹³ María sáa³ Sé³ lɨ ga'ái¹ Jesús do. ");
INSERT INTO chqNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Mo gangɨɨ¹i jmɨɨ²¹² 'ii'²¹ 'woo'²¹ tsá² joon María Magdalena coon'¹³ Salomé coon'¹³ María sáa³ Jacobo galó² jmɨɨ²¹ jmafuu²¹ 'e tsaxee¹i tya' Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Joon 'áa³ jmɨɨ²¹² 'láa² 'wii²¹² semóo¹³, mo ga'yeei²¹ ñi'¹, tyalíin² lɨ ga'ái¹ Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Sɨɨ'²¹ɨ ruu'²¹i: ―¿'Iin 'in jan'¹ 'e cuun²¹² 'e jnɨ¹ 'oo'aan¹ do? ―sɨ́ɨ²i. ");
INSERT INTO chqNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Pe mo ganii²¹ jo 'e cuun²¹² fee'¹ lɨ do. Jo si'²gɨ 'áan³ tya'. ");
INSERT INTO chqNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Mo gangatáa¹i tsi too²¹ 'aan¹ do ganii²¹i jaain²¹ sɨmii'²¹, taa²¹ sɨɨn'³ lɨɨlɨ¹, tyíin¹in lɨ' caai²¹ 'aan¹ tsáa¹ do. Joon gafoo'¹mo 'in tsamɨ́² do. ");
INSERT INTO chqNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Pe 'in sɨmii'²¹ dogɨ gasɨɨ'²¹ɨ 'ii: ―Jo foo'¹³naa'. 'Naa'²¹naa' Jesús tsá² Nazaret 'in gateein¹ tsá² tsaa' crúu¹ do. Pe nigajiin'¹o. Jo 'yuui²gɨ lo. Jǿø²duu' lɨ ga'ii²¹ do. ");
INSERT INTO chqNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Cwolíin²naa', cwosíi¹³ii' tsá² tya'a coon'¹³ Tʉ́³ 'e tsáa¹a Jesús nifugɨ tyii' fu Galilea. Joon do‑o imáa¹naa' 'i jiin'¹³ la nigajin'²in. ");
INSERT INTO chqNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Joon gangalíin²mo cwiin¹in lɨ roon¹ 'aan¹ do 'wii'¹³ jleei¹ gafoo'²¹i lɨɨlɨ¹. Jo 'iin gasɨɨ'²¹ coonti jiin'¹³ jaain²¹ 'wii'¹³ gafoo'²¹i lɨɨlɨ¹. ");
INSERT INTO chqNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Mo ngayuui'¹³ joon 'e gajiin'¹ Jesús, mo gajná² 'e ga'láa² 'wii²¹² semóo¹ do joon gajnée¹in Jesús 'láa² 'wii²¹² tyani María Magdalena, jaain²¹ tsamɨ́² 'in ga'woo¹i Jesús dyái¹ 'in 'lɨɨi' alma tya'a. ");
INSERT INTO chqNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Joon 'ido‑o gangóo¹ ngasii'¹²i 'in nigangɨ¹ coon'¹³ Jesús. Joon do‑o taai¹ xuui²¹²‑tsi joon cɨ'²o. ");
INSERT INTO chqNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Joon mo ganúu²un 'ii 'e seen²¹mogɨ Jesús joongɨ 'e niganii²¹mo 'in tsamɨ́² do 'ii jo gajo'¹ galɨ́ɨ²i 'e jin'² 'in tsamɨ́² do. ");
INSERT INTO chqNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Mo ngayuui'¹³ joon gajnée¹in Jesús xiia'²¹gɨ lɨ́ɨ¹i tyani gái¹ tsá² 'in ngaliin¹ coon²¹ tya'i fu¹. ");
INSERT INTO chqNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","'Ii‑gɨ ngalíin²mo ngasii'¹²i tsá² tya' Jesús pe jon'gɨ júu³ tya' 'ii jo'¹ galɨ́ɨ²i. ");
INSERT INTO chqNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Mo lɨcɨɨin²¹xʉ joon gajnée¹in tún¹ Jesús coon²¹ lɨ néei¹ 'in dyajaain²¹ tsá² tya'a gø'²ø. Joon gaunngɨɨ¹ɨ tsá² tya'a do xiiala lɨ' 'e jo jo'¹ lɨ́ɨi² 'ido, joongɨ 'waa'²¹‑tsi 'ido tsʉ 'wii'¹³ jo jo'¹ galɨ́ɨi² la jileei'²¹ 'in gasɨɨ'²¹ɨ 'ii 'e nijiin'¹ Jesús. ");
INSERT INTO chqNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Joon gajin' Jesús sɨɨ'²¹ɨ tsá² tya'a: ―Cwolíin²naa' la 'ui fu juncwii²¹. Síi¹³ii' jileei'²¹ tsá² júu³ tyʉ́² tya' xiiala itiin'¹³ tsá² tyani Dios. ");
INSERT INTO chqNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Joon jileei'²¹ 'in jo'¹ lɨ́ɨi² 'e júu³ tyʉ́² do joon 'in sáai² jmɨɨ²¹ itiin'¹³mo 'i. Pe 'in jo jo'¹ lɨ́ɨi² lɨ 'lɨɨ'³ itsáa¹a. ");
INSERT INTO chqNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Joon 'in jo'¹ lɨ́ɨi² ijmáa¹a 'e li² lo: Coon'¹³ 'ii'²¹ tyiajna i'wooi²¹ jileei'²¹ 'in 'lɨɨi'³ taai² almas tya' tsá². Joon ifaa'²¹o jmíi¹ xiia'²¹. ");
INSERT INTO chqNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Joongɨ isaan'²¹in coon'¹³ cwoo²¹o mɨɨ'²¹ pe jo ijmá¹ 'nii'²¹ tya'a. Joongɨ wana 'uun'²¹ 'ootyíi² jo ijmá¹ 'ii'²¹. Joongɨ táan¹an cwoo²¹o tya' 'in tsatsaa'¹³ joon 'láa²mo 'i. ");
INSERT INTO chqNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Mo ngayuui'¹³ gafee'²¹i Jesús tsá² tya'a do joon ganga'²mo Ña'ñʉ'¹ʉ' Jesús fu ñʉ'fú². Joon do‑o gangacwaa²¹ lɨ' caai²¹ Dios Jmii²¹ tsáa¹. ");
INSERT INTO chqNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Joon ga'woo²¹mo tsá² tya'a ngasii'¹²i tsá² xiiala itiin'¹³ tsá² la caan²¹mo. Joon coon'¹³ 'ña'a Jesús 'e uncoon'¹³on. Joon coon'¹³ milagro 'e jmoo¹o tsá² tya'a litsáai¹‑tsi tsá² 'e jo'¹o júu³ tya' Jesús. Amén.");
INSERT INTO chqNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Fúu¹mo tsá² nigataan¹an ni mo'jí² la galɨ́² jilaa'²¹ 'e nigalɨ́² jee²¹² jna'. ");
INSERT INTO chqNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Joon 'in tsá² 'in niga'e'¹e jna' niganii²¹o ca la mo 'wiin²¹² joon gatyaa¹o júu³. ");
INSERT INTO chqNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","La joon jon jna nigacoon²¹oo cwáain¹ coon'²¹ tún² ca la mo 'wiin²¹². 'Wii'¹² joon lɨ́ɨ²na 'e tyʉ́²‑ʉ 'e tóon¹³oon ni mo'jí² jilaa'²¹ la lɨ́² 'e nigalɨ́². ");
INSERT INTO chqNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","La joon jmáa³aan tsá² tyúi¹ Teófilo 'e litsáai¹‑'o'o 'e la ja'²mo jilaa'²¹ júu³ 'e niga'e'² tsá² 'nʉ. ");
INSERT INTO chqNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","La jee²¹² lɨ́ɨ¹i Herodes rǿøi¹³ fu lɨ sii²¹ Judea seein²¹ jaain²¹ tsá² Israel 'in sii²¹ Zacarías. Lɨ́ɨ¹i tsá² coon²¹ poo²¹² sii²¹ Abías. Tsamɨ́² tya'a sii²¹ Elisabet. Jaain²¹ jún² tya' 'lɨɨ²¹² Aarón 'ii. ");
INSERT INTO chqNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Jiwáa²mo do tyú¹mo tyani Dios i. Joongɨ jmaa¹a jilaa'²¹ tɨɨsi'² coon'¹³ jilaa'²¹ to² tyʉ'² Dios. Jo 'e tsaa² tya'a sá². ");
INSERT INTO chqNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Jo 'in xuui²¹² tya'a seein²¹ tsʉ 'wii'¹³ Elisabet do jo lí² tsatyéen¹in. Joongɨ nitsáa²mo jiwáa²mo. ");
INSERT INTO chqNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Cafu mo lɨ́ɨ¹i Zacarías untsá² tyani Dios gatɨ́ɨi² tsajiin²¹ fuusún² ni altar tya' Dios. Gatɨ́ɨi² tsajmaa¹a 'elo jiin'¹³ la tɨɨ²si'² 'e jmoo¹o untsá² do. Gacoo¹o untsá² 'iin²¹²in litsáai¹‑tsi 'ee to² ijmáa¹a. Joon mo gatɨ́² 'ii'²¹ ga'í² Zacarías cwo'¹ tya' Dios do 'e tsajiin²¹ fuusʉ́n². ");
INSERT INTO chqNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Jileei'²¹ 'in catyaai²gɨ do gajaan¹an caluu faa'²¹a júu³ tyʉ́². ");
INSERT INTO chqNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","La tsifu joon gajnéi¹ jaain²¹ ángel tya' Dios Jmii²¹ siin'¹³in lɨ' tsáa¹ 'e lɨ juun¹un fuusʉ́n². ");
INSERT INTO chqNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Mo gajnéi¹ 'in ángel do 'áa¹mo gafooi'²¹ Zacarías jiin'¹³ jo ñii¹ 'ee jmáa¹a. ");
INSERT INTO chqNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Joon 'in ángel do gajin'²in sɨɨ'²¹ɨ 'ii: ―Jo foo'¹³'o, Zacarías, tsʉ Dios niganúu²o júu³ tyʉ́² tyi'i. Itsatyéen¹³mo tsamɨ́² tyi'i jaain²¹ yʉʉn²¹. Joon unsii²¹o'o Wó² 'ii. ");
INSERT INTO chqNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Lɨ́ɨ¹ tyuu'¹³'u jløø'³mo'o 'wii²¹² tya'a. Fúu¹mo 'in jløø'³mo 'e galiseein²¹. ");
INSERT INTO chqNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Tsʉ 'in yʉʉn²¹ tyi'i do 'in lityú¹mo tyani Dios. Jo 'e 'uun'²¹un coonti jon' vino jon'gɨ máa¹. Joon ca la mi liseen²¹mo un'øø'²mo Espíritu Tyʉ́² tya' Dios 'ii. ");
INSERT INTO chqNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Joon coon'¹² júu² tya'o fúu¹mo tsá² seein²¹ Israel icɨ'²o coon'¹³ 'Ña'ñʉ'¹ʉ' Dios tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","'In Wó³ no tsáa¹a jée'¹gɨ lagɨ Ña'ñʉ'¹ʉ' ijmáa¹a la gajmaa¹a Elías. Joon 'ii'²¹ tya' 'ii ijmáa¹a 'e jileei'²¹ tsá² coon'¹³ jóon¹on iliseein² mo tyʉ́². Joon 'in jo mo nʉʉ'¹³ ninuu¹o júu² røø²¹. Joon la joon tyaa¹ tyʉ́² tya'a tsá² i'ii'²¹mo Ña'ñʉ'¹ʉ' ―jin'² ángel do. ");
INSERT INTO chqNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Joon Zacarías do gaunngɨɨ¹ɨ 'in ángel do: ―Xiiala ijmáa²aa 'e iun'øø'¹²na 'elo tsʉ 'áa¹mo nitsaa¹moo la joon tsaamɨ́² tyiia jon. ");
INSERT INTO chqNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","'In ángel do gañii¹i: ―Jna‑a Gabriel. Siin'¹³moo tyani Dios. 'Ii gasii¹in jna 'e fuu²¹²uu 'nʉ. Joongɨ 'e jmáa³aa 'nʉ júu³ jilaa'²¹ júu³ tyʉ́² lo. ");
INSERT INTO chqNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Pe nano jo lí² foo'¹³gɨ'ɨ ca gatsín¹ jilaa'²¹ júu³ lo tsʉ jo gajo'¹ lɨ́ɨ²u'u júu³ tyiia. 'E júu³ lo 'ná¹ tsín¹ mo gatɨ́² 'ii'²¹ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","La 'ɨɨ²¹² joon 'in tsá² catyaai² téein² caluu²¹²‑u sɨjéen¹³mo Zacarías. Lɨ́ɨ¹ tsa'goo¹‑tsi 'wii'¹³ lɨ́ɨ¹ gali'ɨɨ²¹²i inʉʉ cwo'¹ do. ");
INSERT INTO chqNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Pe galili'²o 'e nigajǿø² coon²¹ li² tsʉ 'wii'¹³ mo gacwa'ɨ́ɨ¹ɨ jo lí² faa'²¹gɨ. Joon gajmaa¹a li² coon'¹³ cwoo²¹o tsʉ jo lí² faa'²¹gɨ. ");
INSERT INTO chqNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","La tsifu joon mo gatsín¹ to² tya'a 'e cwo'¹ do ganga'²mo fu tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Mo gangɨ́ɨi¹gɨxʉ jmɨɨ²¹² joon gacán¹mo tsamɨ́² tya'a yʉʉn²¹. Joon gajaan¹o inʉʉ, jo gacwa'ɨ́ɨ¹ɨ ce gatsín¹ 'ñéei² sɨɨ'²¹. Gajin'²in: ");
INSERT INTO chqNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","―Ña'ñʉ'¹o' nigajmaa¹a coon²¹ 'e tyʉ́² tyiia joon nigatyíi³o fa'ɨɨ'²¹ tyiia tyani tsá². ");
INSERT INTO chqNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ningóo¹ jnúui² sɨɨ'²¹ 'e tyéein¹ Elisabet do yʉʉn²¹ mo gasii¹in Dios 'in ángel Gabriel do fu coon²¹ fuu²¹ sii²¹ Nazaret lɨ náa¹ Galilea. ");
INSERT INTO chqNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ngafee'¹³i jaain²¹ sɨmɨ́² sii²¹ María. 'Ido‑o náa¹ júu³ tya'a coon'¹³ jaain²¹ tsañʉʉ'¹ sii²¹ Sé³. Sé³ do jún² tya' 'lɨɨ²¹² David 'ii. ");
INSERT INTO chqNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","'In ángel do gangatyéein¹ lɨ tyíin¹in 'in sɨmɨ́² do. Joon gajin'²in: ―¡'Aa²¹²mo'o fuu²¹²uu 'nʉ! Nigauncwai'² Dios 'nʉ lɨ́ɨ¹gɨ lagɨ jileei'²¹ tsamɨ́² ―jin'² ángel do. ");
INSERT INTO chqNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mo ganii²¹ María 'in ángel do lɨ́ɨ¹ ganga'goo²¹‑tsi. Joon ga'ɨ́¹‑tsi 'ee 'øøi'²¹‑tsi 'e júu³ do. ");
INSERT INTO chqNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Joon 'in ángel do gasɨɨ'²¹ɨ 'ii: ―Jo foo'¹³'o, María. Nigajmaa¹a Dios coon²¹ 'e tyʉ́²‑ʉ tyi'i. ");
INSERT INTO chqNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Cwoliñi'²'in icaan²¹²mo'o yʉʉn²¹ joon liliseein²¹ jaain²¹ yʉʉn²¹ tyi'i 'e unsii²¹o'o JESÚS. ");
INSERT INTO chqNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","'In lifee'¹mo 'ii. Ilisii²¹ Jóon¹ Dios 'in feei'¹gɨ. Joon Ña'ñʉ'¹ʉ' Dios Jmii²¹ icwo'²o 'ii 'án³ lɨ gatyʉ'² jún² tya' 'lɨɨ²¹² yʉʉ'¹³ tya'a David to². ");
INSERT INTO chqNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ilíin²in rǿøi¹³ tya' jileei'²¹ tsá² Israel coon²¹ tøø²mo. Jo tyee²¹ 'ii'²¹ tya'a coonti. ");
INSERT INTO chqNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Joon gaunngɨɨ¹ɨ María 'in ángel do: ―¿Xiiala ilí² 'elo, tsʉ jo 'in ñʉʉ'¹ tyiia seein²¹? ");
INSERT INTO chqNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","'In ángel do gajin'²in: ―Ijoo²¹o Espíritu Tyʉ́² tya' Dios tyi'i. Joon coon'¹³ 'ii'²¹ tya' Dios, 'in feei'¹gɨ, icaan²¹un yʉʉn²¹, tsʉ 'wii'¹³ joon ilicwaa'³mo 'in yʉʉn²¹ do. Joon ilisii²¹ Jóon¹ Dios. ");
INSERT INTO chqNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Iliseen²¹mo jon jaain²¹ yʉʉn²¹ tya' ruu'²¹'u Elisabet fiin'¹³ nitsáa¹mo. Jin'² tsá² 'e jo lí² caain²¹ yʉʉn²¹ pe nano ningóo¹ jnúui² sɨɨ'²¹ 'e tyéein¹in yʉʉn²¹. ");
INSERT INTO chqNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Tsʉ 'wii'¹³ Dios ce jilaa'²¹‑a lii'¹i ―jin'² 'in ángel do. ");
INSERT INTO chqNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","María do gajin'²in: ―Lo‑o siin'¹³na 'e jmáa³oo jilaa'²¹ to² 'e tyʉ'² Ña'ñʉ'¹ʉ'. Cwalí²‑i la lɨ́¹ 'e nigasɨɨ'²¹'ɨ jna. Mo ngayuui'¹³ joon gatʉ́ʉ²mo 'in ángel do 'ii. ");
INSERT INTO chqNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Jee²¹² jmɨɨ²¹² joon María do gangóo¹ la jmoono coon²¹ fuu²¹ ná¹ jee²¹² moo'²¹. Coon²¹ fuu²¹ náa¹ cwoo'¹³ 'wó² sii²¹ Judea. ");
INSERT INTO chqNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Mo gatyíi¹a tya' Zacarías do gafee'¹i Elisabet. ");
INSERT INTO chqNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Joon mo ganúu² Elisabet do júu³ tya' María do joon 'in yʉʉn²¹ 'yuui tu'²u gajøø'²i. ");
INSERT INTO chqNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Joon 'in Espíritu Tyʉ́² tya' Dios ga'ii²¹ Elisabet do. Joon ga'láa² 'wii²¹² faa'²¹a coon'¹³ júu³ tá²xʉ, jin'²in: ―Nigauncwaai'³ Dios 'nʉ lɨ́ɨ¹gɨ lagɨ jileei'²¹ tsamɨ́². Joongɨ nigauncwaai'³ Dios yʉʉn²¹ 'in tyéen²un. ");
INSERT INTO chqNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿'Iin jna wa'a jó¹ sáa³ 'Ña'ñʉ'¹o' jafee'¹³i jna? ");
INSERT INTO chqNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","La tsifu mo ganúu³uun júu³ tyi'i 'in yʉʉn²¹ tyiia lo gajøø'²¹i jløø'³mo nʉ' tu'³uu. ");
INSERT INTO chqNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Jløø'³mo'o 'e nigalitsáa¹mo‑'o'o 'e tyʉ́²‑ʉ 'ii'²¹ tya' Ña'ñʉ'¹ʉ' 'e nigajin'²in. ");
INSERT INTO chqNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Joon María do gajin'²in: Fee'¹mo Ña'ñʉ'¹ʉ' 'áai¹. ");
INSERT INTO chqNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Joon jløø'³moo coon'¹³ jilaa'²¹ 'e jmoo¹o Dios 'in jmoo¹o tiin'¹³na. ");
INSERT INTO chqNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Dios nigacón² cwáain¹ 'e tañíi² jna. Tsʉ fúu² nigalɨ́ɨ¹i jna 'in jmoo¹o to² tyʉ'²ʉ. Pe jilaa'²¹ jmɨɨ²¹² lɨ ngóo¹gɨ jilee'²¹mo tsá² iuntyú¹mo jna. ");
INSERT INTO chqNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Tsʉ Dios 'in jmɨɨ²¹²gɨ‑tsi nigajmaa¹a coon²¹ to² fee'¹ tyiia. Jiin'¹³ 'ii‑o 'in tyú¹mo. ");
INSERT INTO chqNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","'Woo²¹‑tsio tya' ce jileei'²¹ 'in un'goo²¹ 'ii la tsá² seein²¹ nano lagɨ tsá² 'in nogɨ iliseein²¹. ");
INSERT INTO chqNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Jilaa'²¹ to² fee'¹ jmoo¹o Dios. 'In jmaa¹ jløøi'³ yaai tyaníi¹³i ga'aa¹o fa'ɨɨ'²¹. ");
INSERT INTO chqNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ga'woo¹mo Dios tsá² 'in tyíin² 'án³ tya'a. Joon jileei'²¹ 'in tsá² 'wói¹ gasaa'²¹mo. ");
INSERT INTO chqNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","'In sɨtyéein¹³ jmɨɨ²¹² gaunrøø²¹mo Dios 'ii coon'¹² 'e tyʉ́²‑ʉ. Pe 'in tsá² sá² cuu² gasii'¹in lɨ́ɨ²mo. ");
INSERT INTO chqNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Gauncoon'¹³o tsá² Israel 'in jmoo¹o to² tyʉ'²ʉ. ");
INSERT INTO chqNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Fúu² galɨ́ɨ²i 'in jo ga'ín¹‑tsi júu³ ga'ɨɨ¹ 'lɨɨ²¹² tsacøøi'¹³ tyi' Abraham coon'¹³ jileei'²¹ jún² tya'a coon²¹ tøø²mo ―jin'² María do. ");
INSERT INTO chqNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Gaai²¹ sɨɨ'²¹gɨ gajan¹ María coon'¹³ Elisabet do. Mo ngayuui'¹³ joon ganga'²mo fu tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Mo gatsín¹ jmɨɨ²¹² 'e Elisabet do 'ná¹‑a liseein²¹ jóon¹on. Joon galiseen²¹mo. ");
INSERT INTO chqNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Joon lɨ́ɨ¹ jløøi'³ jileei'²¹ tsá² néei¹ tyan' coon'¹³ jileei'²¹ ruu'²¹i mo ganúu² 'e tyʉ́²‑ʉ 'e nigajmaa¹a Ña'ñʉ'¹ʉ' tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Mo gatɨ́² jñá² jmɨɨ²¹² gatɨ́² 'ii'²¹ i'ii'²¹in 'in yʉʉn²¹ do li² jiin'¹³ la tɨɨsi'². Jmɨɨ²¹² joon 'in tsá² jalíin² tɨ́² jmɨɨ²¹² gali'iin²¹²in lisii²¹ 'in yʉʉn²¹ do la sii²¹ jmɨɨ²¹. ");
INSERT INTO chqNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Pe sáa³o gajin'²in: ―Jon' la joon, 'ná¹‑a lisii²¹ Wó³‑o. ");
INSERT INTO chqNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","'In catyaai² do jo cwoo¹ júu³, jin'²in: ―Pe jiin'¹³ jaain²¹ tsacøøi'¹² tyi'i jo sii²¹ la joon ―jin'². ");
INSERT INTO chqNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Joon gajmaa¹a li² coon'¹³ cwoo²¹o tya' jmii²¹ yʉʉn²¹ do 'ee 'iin²¹²in lisii²¹ yʉʉn²¹ do. ");
INSERT INTO chqNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","'I‑igɨ gamɨɨ¹ɨ coon²¹ mo'jí². Joon gataan¹an ni do 'e lisii²¹o Wó³. Ganga'goo²¹‑tsi jilee'²¹mo. La tsifu joon galɨ́²‑ɨ gafaa'²¹ Zacarías do. ");
INSERT INTO chqNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Joon gacwo'²o 'maai'¹³ Dios. ");
INSERT INTO chqNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Coon'¹³ 'e lo‑o gafoo'¹mo jileei'²¹ 'in néei¹ la 'ui tsaa' moo'²¹ lɨ sii²¹ Judea do. Tyaa¹ júu³ jee²¹² 'ii jilaa'²¹ 'e nigalɨ́². ");
INSERT INTO chqNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Jileei'²¹ 'in nuu¹un 'elo gacón² cwáain¹. Joon gajin'²in: ―¿'Ee ilíin² 'in xuui²¹² no? Tsʉ 'e la ja'²mo uncoon'¹³ Ña'ñʉ'¹ʉ' 'ii. ");
INSERT INTO chqNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Joon Zacarías, jmii²¹ 'in Wó³ do, røøi¹ Espíritu Tyʉ́² tya' Dios gafaa'²¹a júu² tya' Dios. Jin'²in: ");
INSERT INTO chqNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Untyú¹moo Ña'ñʉ'¹ʉ' Dios Jmii²¹ tya' tsá² Israel. Tsʉ nigauncoon'¹³ tsá² tya'a joon gauntiin'¹³mo jna'. ");
INSERT INTO chqNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","'Lɨɨ²¹² David gajmaa¹a la to² tyʉ'²ʉ joon nigatyii'¹²mo Dios jaain²¹ jún² tya'a 'in píin²gɨ 'e ijmáa¹a tiin'¹³ jna'. ");
INSERT INTO chqNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","La joon júu³ ga'ɨ́ɨ² 'wii²¹² tya' tsá² tyúi¹ 'in gacwo¹ júu³ tyʉ́² ca lɨɨ²¹². ");
INSERT INTO chqNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ga'ɨ́ɨ² júu³ itiin'¹³ jna' tya' jileei'²¹ 'in 'eei'¹ jna'. Joon i'wóo¹i jna' ja'cwoo²o jileei'²¹ 'in 'iin²¹²in jmeei'²¹ jna' jilaa'²¹ 'e gó². ");
INSERT INTO chqNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Dios ga'ɨ́ɨ²o júu³ tya' 'lɨɨ²¹² tsacøøi'¹² tyi' 'e fúu² iliin¹ Dios 'ii. Jo 'íin²‑tsi 'e júu³ tyiin² do 'e nigajmaa¹a coon'¹³. ");
INSERT INTO chqNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","La lo‑o 'e júu³ ga'ɨ́ɨ² Dios tya' 'lɨɨ²¹² yʉʉ'¹³ tyi' Abraham: ");
INSERT INTO chqNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Gacwo'²o 'ii'²¹ 'e tiin'¹³na' 'e lí²‑i tsáa¹mo‑tsi' 'ii. Jo cu'²‑tsi' coon'¹³ 'in 'eei'¹ jna'. ");
INSERT INTO chqNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Joon lí²‑i jmoo²¹o' jilaa'²¹ to² tyʉ'²ʉ coon'¹³ jilaa'²¹ 'e tyʉ́²‑ʉ la 'ɨɨ²¹² sáan³an'. ");
INSERT INTO chqNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Joon 'nʉ‑ʉ, yʉʉn²¹ tyiia, iunsii²¹ tsá² 'nʉ jaain²¹ tsá² 'in cwó¹ júu³ tya' Dios 'in feei'¹. Joon' 'nʉ‑ʉ icwoo'²'o nifu itya'²'a tyʉ́'² tsá² i'ii'²¹mo Ña'ñʉ'¹ʉ'. ");
INSERT INTO chqNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Joon la joon litsáai¹‑tsi tsá² tya'a xiiala itiin'¹³ Dios tsá² mi 'íin²in tsaa² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","'Wii'¹³ fúu² lɨ́ɨi² Dios jna' joon gasii¹in jóon¹on 'in nigajmaa¹a jná² joo'²¹ ni cwoo'¹³ juncwii²¹ lɨ ngɨɨ²¹ɨ'. ");
INSERT INTO chqNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Nigajná² joo'²¹ tya' jileei'²¹ 'in néei¹ lɨ nʉʉ²¹, joongɨ 'in néei¹ lɨ 'íi¹ foo'¹³ 'mó¹. Joon lí²‑i linee²¹e' xiiala ngɨɨ²¹ɨ' 'e tyʉ́²‑ʉ tyani Ña'ñʉ'¹ʉ', jin'² Zacarías do. ");
INSERT INTO chqNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Joon 'in xuui²¹² Wó³ do gacwán¹mo. Joon gali'øø'²¹mo‑tsi 'áai¹ jilaa'²¹ 'e 'iin²¹²in Dios. Joon gatéein² coon²¹ lɨ jo 'in tsá² seein²¹ ca gatsín¹ jmɨɨ²¹² 'e 'ná¹ licwii¹in tsá² Israel 'ii. ");
INSERT INTO chqNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Jee²¹² jmɨɨ²¹² joon 'in tsaa'to² tyíin¹ Roma sii²¹ Augusto. Joon 'in Augusto do gatyʉ'²ʉ to² 'e tsataai² tsá² ni jí² ce jileei'²¹ tsá² 'in seein²¹ coonti. ");
INSERT INTO chqNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","'E jí² lo nifu ga'láa² 'wii²¹² gajmaa¹a mo lɨ́ɨ¹i Cerenio to² fu lɨ sii²¹ Siria. ");
INSERT INTO chqNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Jilee'²¹mo tsá² 'ná¹‑a tsalíin² fu goo¹o 'e tsataai² ni jí². ");
INSERT INTO chqNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","'Wii'¹³ joon gacwo'ɨ́ɨ¹ Sé³ fuu²¹ Nazaret náa¹ lɨ sii²¹ Galilea. Joon gangóo¹ fuu²¹ Belén, coon²¹ fuu²¹ náa¹ lɨ sii²¹ Judea. Do‑o lɨ galiseein²¹ 'lɨɨ²¹² David tsʉ Sé³ do jaain²¹ jún² 'lɨɨ²¹² David. ");
INSERT INTO chqNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ngóo¹ fu Belén caan²¹mo coon'¹³ María 'e tsataai² ni jí². Nináa¹³a júu³ tya'a 'e tɨ́² lɨ cui'² cwoo²¹o. Joongɨ nityéen²mo yʉʉn²¹. ");
INSERT INTO chqNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Joon galɨ́² la 'ɨɨ²¹² taain²¹² fu Belén joon do‑o lɨ galiseein²¹ jóon¹ María. ");
INSERT INTO chqNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","'Ido‑o jóon¹on 'láa² 'wii²¹². Joon gapaa'²¹ ni 'ido coon²¹ 'mɨ'². Joon gatyaa¹i coon²¹ tsi momóo¹ tsʉ jo sá² 'nʉ́¹ lɨ ján³. ");
INSERT INTO chqNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Tyan'¹ fuu²¹ Belén ningɨ¹ coon²¹ poo²¹² tsá² 'in 'aai¹ joo'saa'²¹. Do‑o nijoon¹o la coon²¹ 'woo¹ 'aa¹mo joo'saa'²¹ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","La tsifu joon gajnéi¹ jaain²¹ ángel tya' Ña'ñʉ'¹ʉ'. Joon la tøøi² 'oo² ñʉ'fú² tya' Ña'ñʉ'¹ʉ' gajná² joo'²¹ la cu'² lɨ' lɨ née¹i. ");
INSERT INTO chqNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Joon lɨ́ɨ¹ gafoo'²¹i pe 'in ángel‑gɨ do gajin'²in sɨɨ'²¹ɨ 'ido: ―Jo foo'¹³naa' tsʉ coon²¹ júu³ tyʉ́²‑ʉ 'e tyaan² 'e fuu²¹²uu 'naa' ilijløøi'³ jilee'²¹mo tsá². ");
INSERT INTO chqNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Nano galiseein²¹ fuu²¹ goo¹o David jaain²¹ 'in jmá¹ tiin'¹³ 'naa' 'in sii²¹ CRISTO. Ña'ñʉ'¹ʉ' 'ii. ");
INSERT INTO chqNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Lawa coon²¹ li² imáa¹³naa' 'in yʉʉn²¹ do raain¹ coon²¹ tsi momóo¹ sɨpaa'²¹i 'mɨ'² ―jin'² 'in ángel do. ");
INSERT INTO chqNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","La tsifu joon co' lɨ siin'¹³ 'in ángel do joon gajnéi¹ fúui¹gɨ ángeles. Joon cwoo¹ 'maai'¹³ Dios. Joon jin'²in: ");
INSERT INTO chqNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Cwocwoo¹ 'maai'¹³ Dios jileei'²¹ 'in néei¹ ñʉ'fú²! La joon jon ni 'wó² cwolisá² 'ii'²¹ tya' tsá² 'in jløøi'³ 'wii²¹² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Joon mo ngalíin²in 'in ángeles do fu ñʉ'fú² 'in tsá² 'aai¹ joo'saa'²¹ do ga'láa² 'wii²¹² gasɨɨ'²¹ɨ ruu'²¹i: ―Moo²¹o'. Mojøø²¹ø' fu Belén jilaa'²¹ 'e nigalɨ́² lo. Mojøø²¹ø' jilaa'²¹ 'e nigajin'² Ña'ñʉ'¹ʉ'. ");
INSERT INTO chqNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Joon ngalíin²mo jmoono lɨ́¹. Joon mo gatyalíin²in gatsee'²¹mo María coon'¹³ Sé³ joongɨ 'in yʉʉn²¹ do raain¹ tsi momóo¹. ");
INSERT INTO chqNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Mo gatsee'²¹i gatya¹o júu³ jilaa'²¹ 'e nigajin'² 'in ángel do cwáain¹ tya' 'in yʉʉn²¹ do. ");
INSERT INTO chqNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Joon jileei'²¹ 'in ganúu² lɨ́ɨ¹ tsa'goo²¹‑tsi jilaa'²¹ júu³ tya' 'ido. ");
INSERT INTO chqNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Joon María tɨɨ'¹³ɨ‑tsi jilaa'²¹ 'elo. Joon ga'ɨ¹‑tsi 'wii²¹² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Joon 'in tsá² 'aai¹ joo'saa'²¹ do ngalíin²mo jløø'³mo cwáain¹ tya'a. Ngalíin²mo un'goo²¹o Dios. Cwoo¹o 'maai'¹³ Dios jilaa'²¹ 'e niganúu² joongɨ 'e niganii²¹. Tsʉ 'wii'¹³ jilaa'²¹‑a nigalɨ́² la nigajin'² 'in ángel do sɨɨ'²¹ɨ 'ii. ");
INSERT INTO chqNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Mo gatɨ́² jñá² jmɨɨ²¹² 'e galiseein²¹ Jesús gajmaa¹a tsacøøi'¹³ tya'a li² 'ii. Joon gaunsii²¹ JESÚS jiin'¹³ la 'e nigajin'² 'in ángel do nigasɨɨ'²¹ɨ María la nʉ'gɨ 'e gacaain²¹ María Jesús. ");
INSERT INTO chqNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Mo gatsiin¹ jmɨɨ²¹² 'e gauntyú¹‑i jiin'¹² la tɨɨsi'² tya' Moisés gangajée¹³mo Jesús fu Jerusalén 'e tyá² cwoo²¹o Dios. ");
INSERT INTO chqNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","La lo‑o gajmaa¹a tsʉ 'wii'¹³ ni jí² tya' Ña'ñʉ'¹ʉ' jin'²: “Jileei'²¹ yʉʉn²¹ tsañʉʉ'¹ 'in liseein²¹ nifu jmaa¹a tsá² coon'²¹ tya' Ña'ñʉ'¹ʉ'.” ");
INSERT INTO chqNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Gangalíin²mo gacwo'²o Ña'ñʉ'¹ʉ' Dios jiin'¹³ la to² tyʉ'² ni jí² tya'a. 'E jin'² jí² do 'e 'ná² cwóo¹i tsá² canéei¹ posɨɨ²¹² sɨ gái¹ maa²¹² 'ee lawa coon²¹ fa'¹. ");
INSERT INTO chqNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Jee²¹² jmɨɨ²¹² joon niseein²¹ Jerusalén jaain²¹ tsañʉʉ'¹ sii²¹ Simeón. 'Ii jaain²¹ tsañʉʉ'¹ 'in tyúi¹ coon'¹³ Dios. Lɨ́ɨ¹ un'goo²¹ 'ii Dios. Joongɨ sɨjan²o mi jó¹ 'in jmá² tiin'¹³ tsá² Israel. Joon 'in Espíritu Tyʉ́² tya' Dios siin'¹³mo coon'¹³ Simeón do. ");
INSERT INTO chqNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Nigajin'²in Espíritu tya' Dios 'e jo ijúuin² jiin'¹³ la jo mo nii²¹ Cristo 'in siin¹in Ña'ñʉ'¹ʉ'. ");
INSERT INTO chqNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","'In tsañʉʉ'¹ lo gangó¹ fu cwo'¹ fee'¹ si'² Jerusalén to² tyʉ'² Espíritu Tyʉ́² tya' Dios. Joon mo gajalíin²in tsacøøi'¹³ tya' Jesús coon'¹³on fu cwo'¹ 'e jmáa¹a jiin'¹³ la to² tyʉ'² ley. ");
INSERT INTO chqNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Joon garɨɨin¹ 'in Simeón do 'in yʉʉn²¹ do. Joon gacwo'²o 'maai'¹³ Dios. Jin'²in: ");
INSERT INTO chqNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Ña'ñʉ'¹ʉ', lí²‑i cwo'³'o júun²moo 'e tyʉ́²‑ʉ, tsʉ nigauntsiin¹mo 'ii'²¹ 'e gajmaa²'a coon'¹³ tsá² tyi'i. ");
INSERT INTO chqNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Nigamá¹moo coon'¹³ unníi³oo 'in jmá² tiin'¹³ tsá², ");
INSERT INTO chqNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","'in nigasíin²un tyani jileei'²¹ tsá². ");
INSERT INTO chqNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Joon 'ino‑o lɨ́ɨ¹i lawa coon²¹ jɨ́² 'e jnéei² tya' jileei'²¹ 'in jo seein²¹ Israel. Joon coon²¹ 'e tyʉ́²‑ʉ tya' tsá² tyi'i 'in seein²¹ Israel. ");
INSERT INTO chqNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Sé³ coon'¹³ sáa³ Jesús lɨ́ɨ¹ ganga'goo²¹‑tsi jilaa'²¹ 'e gajin'² Simeón cwáain¹ tya' xuui²¹² do. ");
INSERT INTO chqNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","La 'ɨɨ²¹² joon gataain'² Simeón cwa'³ 'ii. Joon gajin'²in sɨɨ'²¹ɨ María, sáa³ Jesús: ―'In yʉʉn²¹ lo 'yuui 'ii'²¹ 'e jmáa¹a 'e cɨɨ'¹²i tsá² Israel sɨxʉ 'e róon²on 'ee. 'E joon lawa coon²¹ li² 'e lɨ́ɨ¹ fúui¹ 'in faa'²¹ 'laa'²¹ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Coon'¹³ 'e la joon 'e nilí² xiiala 'ɨ¹‑tsi tsá² la jaain²¹ la jaain²¹. Joon 'e tyi'nʉ‑ʉ jilaa'²¹ 'elo lawa coon²¹ ñí³ 'e ga'í² tsi alma tyi'i ―jin'² Simeón do. ");
INSERT INTO chqNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Do‑o jon 'yuu²i jaain²¹ tsamɨ́² 'in nisii²¹ Ana. Jamɨ́ɨ¹ɨ jaain²¹ tsañʉʉ'¹ sii²¹ Fanuel. 'Ido‑o lɨ́ɨ¹i tsá² tya' coon²¹ poo²¹² tsá² seein²¹ Israel 'in¹ nisii²¹ Aser. Ana do‑o tɨ́ɨ²i cwoo¹o júu³ tya' Dios. Lɨ́ɨ¹ natsáai² tsʉ sɨmɨɨ²¹²gɨ 'ii la mo gacui'² cwoo²¹o. Joon dyía¹ jiin²¹ nigacwoo²¹ coon'¹³ ñʉʉ'¹ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Joon nano ningóo¹ dyajñʉ́ʉ² jiin²¹ 'ná¹gɨ itsín¹ coon²¹ cíein¹³ jiin'²¹in. Jo ga'woo²i 'e cwo'¹ do. 'Yuu²i cwo'¹ la 'woo¹ tiin'¹³ la jmɨɨ¹ 'e untyú¹i Ña'ñʉ'¹ʉ'. Faa'²¹o júu³ tyʉ́² joongɨ jo gøø'²¹ø la tɨɨ² si'². ");
INSERT INTO chqNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","'In tsamɨ́² do gangatyéein¹ la tsifu joon. Joon mo ngayuui'¹³ gacwo'²o 'maai'¹³ Dios ga'láa² 'wii²¹² gafee'²¹i tsá² cwáain¹ tya' 'in yʉʉn²¹ Jesús do. Fee'²¹i jilee'²¹mo 'in sɨján² 'ii'²¹ iláa²mo 'in seein²¹ Jerusalén. ");
INSERT INTO chqNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Mo ngayuui'¹³ gauntsiin¹ jilaa'²¹ 'e tyʉ'² to² ni jí² tya' Ña'ñʉ'¹ʉ' gangaliin¹mo fu Galilea. Gangalíin¹in fu goo¹o Nazaret. ");
INSERT INTO chqNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Joon 'in yʉʉn²¹ do gacwán¹mo. Lɨ́¹gɨ pí²‑tsi joongɨ lɨ́¹gɨ 'øøi'²¹gɨ‑tsi. Joon lɨ́ɨ¹ gauncwai'³ Dios 'ii. ");
INSERT INTO chqNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Joon tsacøøi'¹³ tya'a la coon²¹ jiin²¹ tsalíin² Jerusalén 'e tsajǿø² jmɨɨ²¹² sii²¹ pascua mo tii'¹³‑tsi tsá² Israel mo gacwa'woo²¹i tsacøøi'¹³ tya'a Egipto. ");
INSERT INTO chqNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Mo gatsín¹ Jesús dyatun¹ jiin'¹in ngalíin²mo coon'¹³ tsacøøi'¹³ tya'a fu Jerusalén jiin'¹³ la tɨɨsi'² 'e tɨ́² jmɨɨ²¹² do. ");
INSERT INTO chqNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Mo gacɨɨ'¹²ɨ jaliin¹mo gatséi¹ jmɨɨ²¹² do 'in xuui²¹² Jesús do gajaan¹o fu cwo'¹ fee'¹ Jerusalén. Ce jiin'¹³ jo galili'³ tsacøøi'¹³ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ga'ɨ¹‑tsi 'e jaa'¹³mo Jesús jee²¹² tsá² fúui¹ lɨɨlɨ́¹ do. La joon ngatáai² fu² coon²¹ jmɨɨ²¹². Joon ga'naa'¹²i jee²¹² tsaruu'²¹i coon'¹³ jileei'²¹ 'in cwii¹ingɨ. ");
INSERT INTO chqNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Pe jo gatsee'²¹i. Joon ngalíin²mo tún¹ fu Jerusalén 'e tsa'nee'¹³i 'ido fu joon. ");
INSERT INTO chqNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Joon mo gatsín¹ 'nɨ¹ jmɨɨ²¹² joongɨ gatsee'²¹i 'ido fu inʉʉ cwo'¹ do. Tyíin¹³in jee²¹² tɨfo'² tya' ley nuu¹u joongɨ ungɨɨ¹ɨ 'ido. ");
INSERT INTO chqNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Jileei'²¹ 'in nuu¹u júu² tya'a lɨ́ɨ¹ tsa'goo²¹‑tsi jilaa'²¹ júu³ cwáain¹ cwoo¹ Jesús coon'¹³ jilaa'²¹ 'e 'øøi'²¹‑tsi. ");
INSERT INTO chqNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Mo ganí²i tsacøøi'¹³ tya'a 'ii lɨ́ɨ¹ ganga'goo²¹‑tsi. Joon gajin'² sáa³a: ―Yʉʉn²¹ tyiia, ¿'ee lɨ' gacwoo'¹³'o jna'a fa'í³ la no? Ñʉ'²'ʉ coon'¹³ jna lɨ́ɨ¹ cu'²‑tsii'i naga'nee'¹³na'a 'nʉ. ");
INSERT INTO chqNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Joon gasɨɨ'²¹ Jesús 'ii: ―¿'Ee lɨ' 'naa'²¹naa' jna? ¿Tɨ jo ñí²ii' 'e 'ná²a jmá³aa jilaa'²¹ to² 'e nicwo¹ Ñʉ'³ʉʉ jmáa³aa? ");
INSERT INTO chqNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Pe tsacøøi'¹³ tya'a jo ga'øøi'²¹‑tsi 'e gajin'² Jesús gasɨɨ'²¹ɨ 'ii. ");
INSERT INTO chqNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Joon gangaliin¹mo coon'¹³ Jesús fu Nazaret. La joon galinʉʉ'¹³ʉ to² tyʉ'²ʉ. Pe sáa³o jo ga'ín¹‑tsi jilaa'²¹ 'elo. ");
INSERT INTO chqNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","La joon Jesús lɨ́ɨ¹ tyʉ́² gacwáan¹in. Joongɨ 'øøi'²¹gɨ‑tsi. 'Yaa¹mo‑tsi Dios coon'¹³ Jesús. La joon jon 'yaa¹mo‑tsi jileei'²¹ tsá² coon'¹³ Jesús. ");
INSERT INTO chqNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ningóo¹ dya'ñá² jiin²¹ 'e Tiberio 'in tyíin¹³ Roma lɨ́ɨ¹i tsaa'to² nifu. Joon Poncio Pilato‑gɨ lɨ́ɨi¹ tsaa'to² fu Judea. Joon Herodes‑gɨ lɨ́ɨi¹ tsaa'to² fu Galilea. Joon ruu'²¹i dogɨ sii²¹ Lii²¹² tyʉ'²ʉ to² fu Iturea coon'¹³ lɨ sii²¹ Traconite. Joon Lisanias lɨ́ɨi¹ tsaa'to² fu Abilinia. ");
INSERT INTO chqNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Joon Anás coon'¹³ Caifás lɨ́ɨi¹ untsá² 'in tyíin¹gɨ nifu. La 'ɨɨ²¹² joon taain²¹² Wó³ jóon¹ Zacarías coon²¹ lɨ jo 'in tsá² seein²¹. Joon gacwo'²o Dios 'ii coon²¹ júu³ 'e tya¹ tsá². ");
INSERT INTO chqNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Joon Wó³ gangɨ́ɨ¹i la caain²¹ co' tɨ' jmɨɨ²¹ Jordán 'e sɨɨ'²¹ɨ tsá² 'e 'ná²‑a unsɨɨ¹i 'e 'ɨ¹‑tsi jilaa'²¹ 'e gó² joon 'ná²‑a saai²¹ jmɨɨ²¹. Joon la joon 'íin²mo tsaa² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","'Elo‑o gauntiin'¹³mo jiin'¹³ la jin'² ni jí² 'e gajmaa¹a 'in gacwo¹ júu² tyʉ́² ca lɨɨ²¹² 'in sii²¹ Isaías: Tá² coon²¹ ni'oo¹o jaain²¹ tsá² fu coon²¹ lɨ jo 'in tsá² seein²¹. Nijin'²in: “'Ijó¹ Ña'ñʉ'¹ʉ'. Tyaa²aa' tyʉ́² tyii' i'ii'²¹moo' 'ii. Tsáa¹mo‑'oo' 'e tyú¹moo'. Jmáa²aa' fu uncwii²¹ tyii' lawa coon²¹ fu¹ coon²¹ tsáa¹. ");
INSERT INTO chqNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Unrøø¹moo' jilaa'²¹ juu'¹³ cwó². 'E unrøø²¹moo' jilaa'²¹ po'³ moo'²¹. Joongɨ fu¹ tuu'²¹ nijmaa²aa' tsáa¹. Jilaa'²¹ fu¹ gó² 'ná² lí² røø²¹. ");
INSERT INTO chqNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Joon jileei'²¹ tsá² taain²¹² juncwii²¹ ni ní²o xiiala tiin'¹³ Dios tsá².” Jin'² jí² tya' Dios do. ");
INSERT INTO chqNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Mo tsalíin² tsá² 'e saai¹ Wó³ 'ii jmɨɨ²¹ joon jin'²in Wó³: ―¡Tsá² 'in coon'²¹ tsá² to² 'naa'! ¿'Iin nigasɨɨ'¹³ 'naa' 'e laa²¹²naa' yaanaa' jee²¹² coon²¹ wúu¹ 'e nijatyéein¹? ");
INSERT INTO chqNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Cwojmáa²aa' jiin'¹³ la tɨ́ɨi² jmá¹ 'in nigajo'²‑tsi. Joon jo 'ɨ¹‑'oo': “Jo 'e tsangɨɨ¹na' tsʉ jún² tya' 'lɨɨ²¹² Abraham jna'”, tsʉ fuu²¹²uu 'naa' 'e ca 'e cuun²¹² roon¹ lo lí² jmá² Dios jún² tya' 'lɨɨ²¹² Abraham. ");
INSERT INTO chqNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Dios nityaa¹ tyʉ́² ñityí² tya'a 'e tyʉ'²ʉ 'mó², joon jilaa'²¹ 'mó² 'e jo cwó² 'oofuu²¹ tyʉ́² tya'a ityʉ'²o joon ijún² coon'¹³ jɨ́² ―jin'² Wó². ");
INSERT INTO chqNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Joon gaunngɨɨ¹ɨ 'in tsá² do 'ii jin'²in: ―¿'Ee‑gɨ 'ná² jmoo²¹o'on jon? ");
INSERT INTO chqNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Wó²gɨ gajin'²in sɨɨ'²¹ɨ 'ido: ―Jileei'²¹ 'in 'oo¹o tún² 'mɨ'tyi'² 'ná²‑a cwo'¹o coon²¹ tya' 'in jo 'oo¹o coon²¹ tí². ");
INSERT INTO chqNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Gajalíin²mo jon 'inlɨ́ɨi¹³ 'in cón² 'laa'¹³ tya' 'e 'nɨɨ¹ tsá² wa'a 'e saai²¹ jmɨɨ²¹. Joon gaunngɨɨ¹ɨ, jin'²in sɨɨ'²¹ɨ Wó²: ―Tɨfo'², ¿'ee 'ná¹ jmó³ jna'a? ");
INSERT INTO chqNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Joon gajin'² Wó³: ―Jo mɨ́²ɨɨ' lɨ́ɨ¹gɨ jiin'¹³ la 'ii'²¹ na tyan¹. ");
INSERT INTO chqNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","'Inlɨ́ɨi¹³gɨ 'láa² gaungɨɨ¹ɨ 'ii jin'²in: ―Jna'gɨɨ'ɨ, ¿'ee‑gɨ 'ná² jmoo²¹o'o? Joon gajin'² Wó³: ―Jo tɨ' tyíi²ii' coon²¹ tí² tya' doñi'iin tyitsaai²¹², jogɨ tyíi²ii' cuu² coon'¹³ tajúu³. Cwoli'yaa¹mo‑'oo' jiin'¹³ la 'lee'¹³naa'. ");
INSERT INTO chqNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","'In tsá² do téein² 'áai¹ sɨjáan¹³an. Joon 'ɨ¹‑tsi wana jon' Wó² no lɨ́ɨi² Cristo 'in sín¹ Dios. ");
INSERT INTO chqNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Pe Wó³ dogɨ gajin'²in sɨɨ'²¹ɨ jileei'²¹: ―Jna‑a, 'e la ja'²mo jiin'¹³ coon'¹³ jmɨɨ²¹ saa²na 'naa' jmɨɨ²¹. Pe jó¹‑o jaain²¹ 'in cwói¹ Espíritu Tyʉ́² tya' Dios 'in ngɨ́¹ coon'¹³ 'naa'. Joon iuntyú¹mo 'naa' coon'¹³ coon²¹ lawa coon²¹ jɨ́². Joon 'oo¹gɨ 'ii'²¹ lagɨ jna ce jiin'¹³ jo tɨ́ɨ²na 'e sii'¹³ii loo²¹ tsi mɨɨ²¹²ɨ. ");
INSERT INTO chqNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","'Ijó¹o ijmáa¹a la jmoo¹ tsá² mi untyʉʉ²¹ trigo. Mo untyʉʉ²¹ trigo do tyii'¹³o jilaa'²¹ jún² tyʉ́² joon coon¹o fu tya'a. Pe jilaa'²¹gɨ tyi¹ dya'²o ni jɨ́² lɨ jo guu²¹. ");
INSERT INTO chqNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Coon'¹³ láai²gɨ júu³ la lo‑o ga'e'² Wó³ tsá² júu³ tyʉ́². ");
INSERT INTO chqNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Joon ca‑gɨ tsaa'to² Herodes gajíin²mo tsʉ 'wii'¹³ Herodes do tyíin¹³in coon'¹³ Herodías tsamɨ́² tya' ruu'²¹i Lii²¹² lawa tsamɨ́² tya'o. Gajíin²mo jon 'wii'¹³ jilaa'²¹gɨ 'e gó² nigajmaa¹a. ");
INSERT INTO chqNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Joon coon'¹³ jilaa'²¹ 'elo‑o gajmaa¹a 'e gó²gɨ ca gataan'¹²in Wó³ 'nʉñí³. ");
INSERT INTO chqNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","La nʉ'gɨ 'e lɨ́² jilaa'²¹ 'elo mo gangɨ¹ Wó³ saai¹ tsá² jmɨɨ²¹ joon gasaa¹mo jon Jesús jmɨɨ²¹. Joon la 'ɨɨ²¹² cwo'²o 'maai'¹³ Dios ganó¹ 'ooñʉ'fú². ");
INSERT INTO chqNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Joon 'in Espíritu Tyʉ́² tya' Dios gajngáa¹i lɨ́ɨi¹ maa²¹² fu lɨ siin'¹³ Jesús. Joon ganúu² coon²¹ júu³ jó¹ fu ñʉ'fú² 'e jin'²: ―'Nʉ‑ʉ yʉʉn²¹ tyiia 'in 'iin²¹²na. ");
INSERT INTO chqNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ningóo¹ Jesús jiin'¹³ dyadya¹ jiin'¹in xʉlɨ́ɨ¹ xʉxaai¹ la mo ga'láa² 'wii²¹² cwoo¹o júu³ tyʉ́² tya' Dios. Jiin'¹³ la 'øøi'²¹‑tsi tsá² 'e 'ii jóon¹on Sé³. Sé³ do‑gɨ jóon¹on Elí. ");
INSERT INTO chqNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí do‑gɨ jóon¹on Matat. Matat do‑gɨ jóon¹on Leví. Leví do‑gɨ jóon¹on Melqui. Melqui do‑gɨ jóon¹on Jana. Jana do‑gɨ jóon¹on Sé³. ");
INSERT INTO chqNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Sé³ do‑gɨ jóon¹on Matatías. Matatías do‑gɨ jóon¹on Amós. Amós do‑gɨ jóon¹on Nahum. Nahum do‑gɨ jóon¹on Esli. Esli do‑gɨ jóon¹on Nagai. ");
INSERT INTO chqNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai do‑gɨ jóon¹on Maat. Maat do‑gɨ jóon¹on Matatías. Matatías do‑gɨ jóon¹on Semei. Semei do‑gɨ jóon¹on Sé³. Sé³ do‑gɨ jóon¹on Judá. ");
INSERT INTO chqNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá do‑gɨ jóon¹on Joana. Joana do‑gɨ jóon¹on Resa. Resa do‑gɨ jóon¹on Zorobabel. Zorobabel do‑gɨ jóon¹on Saltiel. Saltiel do‑gɨ jóon¹on Neri. ");
INSERT INTO chqNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri do‑gɨ jóon¹on Melqui. Melqui do‑gɨ jóon¹on Adi. Adi do‑gɨ jóon¹on Cosam. Cosam do‑gɨ jóon¹on Elmodam. Elmodam do‑gɨ jóon¹on Er. ");
INSERT INTO chqNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er do‑gɨ jóon¹on Josué. Josué do‑gɨ jóon¹on Eliezer. Eliezer do‑gɨ jóon¹on Jorim. Jorim do‑gɨ jóon¹on Matat. ");
INSERT INTO chqNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat do‑gɨ jóon¹on Leví. Leví do‑gɨ jóon¹on Simeón. Simeón do‑gɨ jóon¹on Judá. Judá do‑gɨ jóon¹on Sé³. Sé³ do‑gɨ jóon¹on Jonán. Jonán do‑gɨ jóon¹on Eliaquim. ");
INSERT INTO chqNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim do‑gɨ jóon¹on Melea. Melea do‑gɨ jóon¹on Mainán. Mainán do‑gɨ jóon¹on Matata. Matata do‑gɨ jóon¹on Natán. ");
INSERT INTO chqNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán do‑gɨ jóon¹on David. David do‑gɨ jóon¹on Isaí. Isaí do‑gɨ jóon¹on Obed. Obed do‑gɨ jóon¹on Booz. Booz do‑gɨ jóon¹on Salmón. Salmón do‑gɨ jóon¹on Naasón. ");
INSERT INTO chqNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón do‑gɨ jóon¹on Aminadab. Aminadab do‑gɨ jóon¹on Aram. Aram do‑gɨ jóon¹on Esrom. Esrom do‑gɨ jóon¹on Fares. Fares do‑gɨ jóon¹on Judá. ");
INSERT INTO chqNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá do‑gɨ jóon¹on Jacob. Jacob do‑gɨ jóon¹on Isaac. Isaac do‑gɨ jóon¹on Abraham. Abraham do‑gɨ jóon¹on Taré. Taré do‑gɨ jóon¹on Nacor. ");
INSERT INTO chqNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor do‑gɨ jóon¹on Serug. Serug do‑gɨ jóon¹on Ragau. Ragau do‑gɨ jóon¹on Peleg. Peleg do‑gɨ jóon¹on Heber. Heber do‑gɨ jóon¹on Sala. ");
INSERT INTO chqNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala do‑gɨ jóon¹on Cainán. Cainán do‑gɨ jóon¹on Arfaxad. Arfaxad do‑gɨ jóon¹on Sem. Sem do‑gɨ jóon¹on Noé. Noé do‑gɨ jóon¹on Lamec. ");
INSERT INTO chqNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec do‑gɨ jóon¹on Matusalén. Matusalén do‑gɨ jóon¹on Enoc. Enoc do‑gɨ jóon¹on Jared. Jared do‑gɨ jóon¹on Mahalaleel. Mahalaleel do‑gɨ jóon¹on Cainán. ");
INSERT INTO chqNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán do‑gɨ jóon¹on Enós. Enós do‑gɨ jóon¹on Set. Set do‑gɨ jóon¹on Adán. Joon 'in Adán do jóon¹on Dios 'ii. ");
INSERT INTO chqNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesús røø²¹mo 'in Espíritu Tyʉ́² tya' Dios gacɨɨ'¹²ɨ fu tɨ' jmɨɨ²¹ Jordán. Joon 'in Espíritu do‑o gangajéei¹ 'ii coon²¹ lɨ jo 'in tsá² seein²¹. ");
INSERT INTO chqNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Do‑o gateen¹in tunló¹ jmɨɨ²¹². Jo 'ee gagøø'²¹ø jiin'¹³xʉ. Jee²¹² jmɨɨ²¹² joon gatsaa²¹² un'aa²i. Joon Satanás do gacón²du cwáain¹ xiiala lɨ́ɨi² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Joon gajin'² Satanás do gasɨɨ'²¹ɨ 'ii: ―Wana Jóon¹ Dios 'nʉ jmaa²'a 'e cuun²¹² lo lɨ́¹ 'iñi'¹. ");
INSERT INTO chqNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Pe Jesús‑gɨ gañii¹i: ―Jin'² ni jí² tya' Dios: “Jon'¹ jiin'¹³ coon'¹³ 'iñi'¹ 'e seein²¹ tsá², ca‑gɨ jilaa'²¹ júu³ tya' Dios seein²¹ tsá².” ");
INSERT INTO chqNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Joon gangajéei Satanás do Jesús coon²¹ moo'²¹ ñíi¹ lɨ́². Joon ga'e'²e Jesús coon²¹ catá² la tøøi² fuu²¹ 'e sá² ni cwoo'¹³ juncwii²¹. ");
INSERT INTO chqNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Joon gajin'²: ―Nicwo'³oo 'nʉ jilaa'²¹ 'ii'²¹ tya' jilaa'²¹ 'e fuu²¹ lo coon'¹³ jilaa'²¹ 'e 'ya'³gɨ tya'a. Tsʉ jna niga'ii'¹³na jilaa'²¹ 'elo. Joon cwo'³oo doñi'iin 'in 'yaai¹‑tsii. ");
INSERT INTO chqNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Cwo'³oo 'nʉ wana sii'¹³'i 'wojni'²'i tyaní³ii joongɨ mɨ'³'ɨ tyaní³ii. ");
INSERT INTO chqNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Pe Jesús‑gɨ gañii¹i: ―Jeen'¹³mo'o coon'²¹on coon'¹³ jna. Satanás 'nʉ. Tsʉ ni jí² tya' Dios jin'²: “Un'goo²¹ 'naa' jiin'¹³ 'ña'‑o Dios. Joon untiin'¹³moo' jiin'¹³ la to² tyʉ'² 'ii.” ");
INSERT INTO chqNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Mo ngayuui'¹² joon Satanás do gangajéei¹ Jesús fu Jerusalén. Joon gasaa¹i tɨ yʉ' cwo'¹ fee'¹ do. Joon gajin'² Satanás gasɨɨ'²¹ɨ Jesús: ―Wana Jóon¹ Dios 'nʉ cwó² cwotee'²'u ni 'wó² ");
INSERT INTO chqNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","tsʉ ni jí² tya' Dios jin'²: Dios cwoo²¹ 'ii'²¹ 'e jalíin² ángeles tya'a 'e 'aa¹i 'nʉ. ");
INSERT INTO chqNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Nisaan'²¹in 'nʉ coon'¹³ cwoo²¹o. Joon jo liwúui¹ tɨɨ'¹³'ɨ coon'¹³ cuun²¹². ");
INSERT INTO chqNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesús‑gɨ gajin'²in: ―Jin'²in jon ni jí² tya' Dios: “Jo jmaa²'a litsáai¹‑'o'o Ña'ñʉ'¹ʉ' Dios.” ");
INSERT INTO chqNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Mo jo gatsaa'²¹a Satanás 'e jmaa²¹gɨ coon'¹³ Jesús gangawíin²mo coon'¹³ Jesús coon'²¹ sii'¹³. ");
INSERT INTO chqNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesús do nga'²mo fu Galilea røø²¹mo 'in Espíritu Tyʉ́² tya' Dios. Joon líi¹ faa'²¹ tsá² 'wii²¹² tya'a la caan²¹mo co' do. ");
INSERT INTO chqNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Joon Jesús ga'e'³e tsá² tsi inʉʉ la caan²¹mo cwo'¹ sinagoga. Joon jilee'²¹mo untyúi¹ 'ii la caan²¹mo do. ");
INSERT INTO chqNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Joon gangai'² Jesús fu Nazaret. Fuu²¹ do‑o lɨ gacwáan¹in. Joon mo gatɨ́² jmɨɨ²¹² 'ii'²¹ 'woo'²¹ tsá² ngaa'¹³i fu cwo'¹ sinagoga tya' tsá² Israel si'² do jiin'¹³ la tɨɨsi'² tya'a. Joon gajmaa¹a siin'¹²in 'e faa'²¹a jí² taa'¹³ júu³ tyʉ́² tya' Dios. ");
INSERT INTO chqNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Joon gacwo'² tsá² 'ii coon²¹ jí² tya' 'in gafaa'²¹ júu³ tyʉ́² ca lɨɨ²¹² sii²¹ Isaías; joon mo ganá¹ joon gatsaa'²¹a coon²¹ lɨ jin'² la lo: ");
INSERT INTO chqNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","In Espíritu Tyʉ́² tya' Ña'ñʉ'¹ʉ' ngɨɨ¹ coon'¹³ jna tsʉ nigauntyú¹mo jna 'e cwó²oo júu³ tyʉ́² tya'a tya' jileei'²¹ tsá² tañíi². Joongɨ 'e jmáa³aa júu³ xiiala iláa²mo jileei'²¹ 'in sɨjnɨ́ɨi¹³. Joongɨ unjnaa¹ unni² jileei'²¹ tsá² 'in tíuui². Joongɨ jmáa³aa tiin'¹³ jileei'²¹ tsá² 'in jmaai'²¹ tsá². ");
INSERT INTO chqNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","La joon lisá²‑a júu³ 'e gacwaa²¹² jiin²¹ mo jmoo¹o Ña'ñʉ'¹ʉ' 'e tyʉ́²‑ʉ tya' tsá². ");
INSERT INTO chqNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Mo ngayuui'¹² joon gajni¹ Jesús 'e jí² do joon gacwo'²o 'in tsá² 'in uncoon'¹³ 'in tyʉ'² to² cwo'¹ do. Joon gacwoo²¹‑o. Joon jilee'²¹mo 'in tsá² taai² cwo'¹ do jǿøi² Jesús 'áai¹. ");
INSERT INTO chqNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Joon ga'láa² Jesús 'wii²¹² gafaa'²¹a jin'²in: ―Nano‑o nigatsín¹mo 'e jin'² ni jí² tya' Dios lo tyaní²ii' ―jin'² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Jilee'²¹mo tsá² faa'²¹ a tyʉ́² tya' Jesús. Joongɨ lɨ́ɨ¹ tsa'goo²¹tsi júu³ 'ya'² 'e sɨɨ'²¹ Jesús 'ii. Joon gaunngɨɨ¹ɨ la 'oo'²¹ jee²¹² 'ii. Jin'²in: ―¿Tɨ jon' 'in lo‑o 'in jóon¹ Sé³ do? ");
INSERT INTO chqNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Joon gasɨɨ'²¹ɨ Jesús 'ii: ―'E la ja'²mo ifu'³naa' jna 'e júu³ lo: “Tɨmɨ́¹, un'láai² 'wo'o.” Joongɨ 'e fú²uu' jna: “Jilaa'²¹ 'e ganʉʉ²¹ʉ'ʉ 'e gajmaa²'a fu Capernaum jmaa²'a jon fuu²¹ góo²'o lo.” ");
INSERT INTO chqNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Joon gafaa'²¹gɨ Jesús gasɨɨ'²¹ɨ 'ido: ―'E la ja'²mo fuu²¹²uu 'naa', ce jiin'¹³ jaain²¹ tsá² 'in gacwo¹ júu³ tyʉ́² jo faa'²¹ tsagoo¹o tyʉ́² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","'E ja'²mo fuu²¹²uu 'naa' 'e fúui¹ 'yiia'nɨ́ɨ² 'in seein²¹ fu Israel mo gacwo¹ jaain²¹ tsá² sii²¹ Elías júu³ tyʉ́² tya' Dios. Joon jo gajó² jmɨ́¹ 'nɨ¹ jiin²¹ tsi ca'no'³. Joon lɨ́ɨ¹ galisá² 'oo² la caain²¹ fuu²¹. ");
INSERT INTO chqNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Pe Dios jo gasii¹in Elías tya' jiin'¹³ jaain²¹ 'yiia'nɨ́ɨ² 'in néei¹ fu Israel do. Gasii¹mo Dios 'ii tya' jaain²¹ 'yiia'nɨ́ɨ² 'in seein²¹ fu lɨ sii²¹ Sarepta tyan' co' fuu²¹ Sidón. ");
INSERT INTO chqNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Lɨ́ɨ¹ jon seein²¹ tsatsaa'¹³ jgøøi'¹³ fu Israel jee²¹² jmɨɨ²¹² tya' tsá² gacwo¹ júu³ tyʉ́² sii²¹ Eliseo. Pe jiin'¹³ jaain²¹ jo ga'láai². Jiin'¹³ Naamán 'in seein²¹ lɨ tyʉ'² to² Siria gaun'láai² Eliseo ―jin'² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Mo ganúu² jileei'² 'in tsá² táai² cwo'¹ do jilaa'²¹ 'elo lɨ́ɨ¹ gatɨ́² 'nii'²¹‑tsi. ");
INSERT INTO chqNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Joon garóon². Joon gatyii¹mo Jesús fu caluu²¹² fuu²¹ do. Joon gangajée¹³i Jesús fu coon²¹ yʉ' moo'²¹ lɨ náa¹ fuu²¹ do. Do‑o la mo 'iin²¹²in 'e 'lee'¹²i Jesús fu tyi² xá² do. ");
INSERT INTO chqNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pe Jesús‑gɨ gangɨ́ɨ¹i tún² tsa'¹ jee²¹² 'ii. Joon ganga'¹mo. ");
INSERT INTO chqNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Joon gangó¹ Jesús fuu²¹ Capernaum, coon²¹ fuu²¹ náa¹ lɨ sii²¹ Galilea. Joon do‑o gajaan¹an 'e'²e tsá² fu inʉʉ cwo'¹ sinagoga mo tɨ́² jmɨɨ²¹² 'ii'²¹ 'woo'²¹ tsá². ");
INSERT INTO chqNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Lɨ́ɨ¹ tsa'goo²¹‑tsi tsá² jilaa'²¹ 'e 'ee¹e tsʉ 'wii'¹³ faa'²¹a lawa jaain²¹ 'in 'oo¹o to². ");
INSERT INTO chqNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Cwo'¹ do‑o 'yuui jaain²¹ tsá² 'in 'yuui² 'in 'lɨɨi'³ alma tya'a. Joon ga'oo¹o jin'²in: ");
INSERT INTO chqNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―Tʉ́ʉi¹ jna'a. ¿'Ee lɨ' 'u'¹'u jee²¹² jna'a, Jesús tsá² Nazaret? ¿Tɨ ñi'²'i 'e untyee¹u jna'a? Ñí²oo 'iin 'nʉ. 'In tyú¹mo tya' Dios 'nʉ ―jin'² 'in 'lɨɨi'³ do. ");
INSERT INTO chqNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Pe Jesús gajíi²in 'in espíritu gó² do. Joon gajin'²in: ―¡Ca tii²! ¡Tiuui² 'in tsañʉʉ'¹ lo! Joon 'in espíritu gó² do gajmaa¹a cɨɨ'²¹mo 'in tsañʉʉ'¹ do ni 'wó² tyani jileei'²¹ 'in táai² do. Joon gacwo'ɨ́ɨ¹o 'in espíritu gó² 'ii. Ce jiin'¹³ coon²¹ 'e gó² jo gajmee'²¹i. ");
INSERT INTO chqNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Joon jilee'²¹mo gafoo'i¹. Joon gasɨɨ'²¹ɨ ruu'²¹i: ―¿'Ee‑gɨ júu³ 'elo? ¿'Ee to² 'oo¹o 'in tsañʉʉ'¹ lo? ¡Jǿø² xiiala tyʉ'²ʉ to² 'in espíritu gó² do, gatyʉ'²ʉ to² 'woo¹i, joon ga'woo¹mo! ");
INSERT INTO chqNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Joon lɨ́ɨ¹ faa'²¹ tsá² tya' Jesús la caan²¹mo co' do. ");
INSERT INTO chqNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Joon gacwo'ɨ́ɨ¹ Jesús fu cwo'¹ do. Joon gangaa'¹²i fu tya' Simóoi¹³. Joon 'in 'yiiaunsáa³ Simóoi¹³ nitsaa'¹³o joongɨ 'yʉ tyíi²mo. Joon gamɨɨ¹ɨ tyani Jesús 'wii²¹² tya' 'ido. ");
INSERT INTO chqNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Joon gangatyéen¹ Jesús tyani lɨ raain¹ 'ido. Joon ga'wó² 'e tyíi²in do. Joon gajeen'²¹mo. La tsifu joon garóon²o joon ga'láa² 'wii²¹² 'e unjíi¹mo 'in tsá² do. ");
INSERT INTO chqNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Mo gayoin'² ñi'¹ jileei'²¹ 'in 'aai¹ tsatsaa'¹³, coon'¹³ 'láai² nii² jmoowúu¹ 'e tyaan¹ tsá² gangajée¹³i lɨ siin'¹³ Jesús. Joon gauntsii¹i Jesús cwoo²¹o tya' 'ido. Joon gaun'láa²mo fúu¹mo tsatsaa'¹³. ");
INSERT INTO chqNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Joongɨ ga'wooi¹ 'in 'lɨɨi'³ taai² alma tya' tsá². Joon mo ga'woo¹i gajin'²in: ―Jóon¹ Dios 'nʉ. Pe Jesús‑gɨ gajii²mo 'ido, jo gacwo¹gɨ faa'²¹ 'ido tsʉ ñii²¹ 'in 'lɨɨi'³ do 'e 'ii‑o Cristo. ");
INSERT INTO chqNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Mo gajná² jmɨɨ²¹² Jesús do gacwo'ɨ́ɨ¹o 'e fuu²¹ do. Joon gangóo¹ coon²¹ lɨ 'ña'a. Pe 'in tsá² do ga'na'²mo 'ii. Joon gatyalíin²mo lɨ siin'¹² Jesús. 'Iin²¹²in jnii'²¹i wa'a jo tsáa¹a. ");
INSERT INTO chqNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Pe Jesús‑gɨ gajin'²in: ―'Ná²‑a cwóo³oo júu³ tyʉ́² tya' xiiala tyʉ'² Dios to² tsá² ce jilaa'²¹ fuu²¹ tsʉ 'wii'¹³ cwáain¹ la lo‑o gagoo²¹²oo. ");
INSERT INTO chqNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","La joon gangɨ́¹ Jesús cwoo¹o júu³ tyʉ́² la caain²¹ cwo'¹ sinagoga lɨ san'² Galilea. ");
INSERT INTO chqNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Coon'²¹ naa'¹³ galɨ́² siin'¹³ Jesús tɨ' jmɨɨ²¹ tyíia¹ lɨ sii²¹ Genesaret. Joon lɨ́ɨ¹ fúui¹ tsá² gatyalíin². Joon lɨ' cuu'¹² lɨ' lɨ siin'²¹ Jesús tsʉ 'iin²¹²in núu¹un júu³ tyʉ́² tya' Dios. ");
INSERT INTO chqNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Joon ganí² Jesús tún² barco lɨ́ɨi² sɨ'ɨ́ɨ¹³ co' do. Jo 'in tsafii²¹² do seein²¹. Ni'woo²¹mo caluu²¹² run'²un nʉ́ʉ³ tya'a¹. ");
INSERT INTO chqNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Joon ga'í² Jesús tsi coon²¹ barco do 'e nitya' Simóoi¹³. Joon gatyʉ'² Jesús to² nga'ii²¹ 'ido ga'la'²gɨxʉ 'e barco do tɨ tsigɨ jmɨɨ²¹. Joon gacwó¹ Jesús tsi barco do. Joon ga'láa² wii²¹² 'e'²e tsá² júu³ tyʉ́² tɨ lɨ tyíin¹in do. ");
INSERT INTO chqNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Mo ngayuui'¹³ ga'e'²e tsá², joon gasɨɨ'²¹ɨ Simóoi¹³: ―Tyán² barco lo tɨ lɨ 'o'² jmɨɨ²¹. Joon 'ɨ́ɨ³ɨɨ' nʉ́ʉ³ tyii'. Joon saan'¹³naa' joo'²¹ jmɨɨ²¹. ");
INSERT INTO chqNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simóoi¹³gɨ gañii¹i: ―Tɨfo'², la tøøi² 'woo¹ nigajmoo²¹o'o to² saain'²¹ joo'²¹ pe coonti jo 'in mo taan'¹³na'a. Pe nano 'wii'¹³ tyʉ'²gɨ'ɨ to² 'ɨ́ɨ³duu nʉ́ʉ³ tyiia. ");
INSERT INTO chqNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Mo ngayuui'¹³ gajmaa¹a la joon lɨ́ɨ¹ fúui¹ joo'²¹ jmɨɨ²¹ galɨ'¹ɨ ca ga'gɨɨ²¹ nʉ́ʉ³ do. ");
INSERT INTO chqNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Joon gajmaa¹a li² gasɨɨ'²¹ɨ 'in tsá² ngɨ¹ coon'¹³on do, 'in taai² barco coon²¹ do 'e tsaliin² tsauncoon'¹³on. Gajalíin²mo. Joon gaunrøø¹mo la jɨ tún² barco ca xʉʉ jo gatá². ");
INSERT INTO chqNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Mo ngayuui'¹³ 'elo Simóoi¹³ Tʉ́³ gasii'²¹i wojníi¹i tyani Jesús. Joon gajin'²in: ―Tʉ́ʉi² jna Ña'ñʉ'¹ʉ' tsʉ jaain²¹ 'in 'oo¹o tsaa² jna. ");
INSERT INTO chqNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simóoi¹³ do lɨ́ɨ¹ ganga'goo²¹‑tsi coon'¹³ 'in catyaai²gɨ 'in téein² coon'¹³ do mo ganii² jileei'²¹ joo'²¹ jmɨɨ²¹ do. ");
INSERT INTO chqNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Lɨ́ɨ¹ jon ganga'goo²¹‑tsi Jacobo coon'¹³ Wó³ jóon¹ Zebedeo. 'Ii jmoo¹o to² caain²¹ coon'¹³ Simóoi¹³ do. Pe joon gasɨɨ'²¹ Jesús Simóoi¹³ do: ―Jo foo'¹³naa'. La mo jée¹ jmoo²oo' to² saain'²¹ joo'²¹ jmɨɨ²¹ pe nano jmáa³aa' to² tyiia saan'¹³naa' tsá². ");
INSERT INTO chqNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Joon gatyii²¹ barco do fu tɨ' jmɨɨ²¹. Do‑o gasáa¹a coon'²¹ tyaa¹. Joon ngalíin²mo coon'¹³ Jesús. ");
INSERT INTO chqNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Gatyía¹ Jesús coon²¹ fuu²¹. Joon ganíi² jaain²¹ tsañʉʉ'¹ lɨ́ɨi¹ jgøøi'²¹ 'ii. Joon gasii'²¹i moojníi¹i ca ni 'wó² tyani Jesús. Joon gamɨɨ¹ɨ tyani Jesús, gajin'²in: ―Ña'ñʉ'¹ʉ', wa' 'iin²¹²u'un lí²‑i un'láa²u jna. ");
INSERT INTO chqNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Joon gason'¹ Jesús tya' 'ido. Gajin'²in: ―'Iin²¹²moo un'láa²na 'nʉ. Jmáa³oo 'láa²‑o ―jin'² Jesús. La tsifu mo gajin'²in 'elo gajeen'²¹mo 'e jgoo'²¹ do tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Joon gatyʉ'² Jesús to² 'e jo 'in sɨɨ'²¹ɨ ce jiin'¹³ jaain²¹. Gasɨɨ'²¹o 'ido: ―Cwoo²'o jiin'¹³ tyani untsá². Joon untyúi¹ 'wo'o coon'¹³ to² 'e nigatyʉ'² Moisés. Coon'¹³ 'e la joon liñí² tsá² 'e niga'láa²mo'o. ");
INSERT INTO chqNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Jin'² Jesús sɨɨ'²¹ɨ 'in tsá² do la do, pe jilaa'²¹ 'e tyʉ́² 'e jmoo¹ Jesús 'áai¹gɨ gafaa'²¹ tsá² tya'a. Joon fúui¹gɨ tsá² licaain²¹ janʉ́ʉ² júu³ tya'a, joongɨ 'e un'láa²i Jesús 'ii coon'¹³ jmoowúu¹ 'e tyaan¹an. ");
INSERT INTO chqNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Pe Jesús gatyíin¹mo 'ña'a coon²¹ lɨ jo 'in tsá² seein²¹. Joon do‑o ngafee'¹³i Dios. ");
INSERT INTO chqNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Coon²¹ jmɨɨ²¹² 'yuui Jesús coon²¹ tsi inʉʉ 'e'²e tsá². Joon néei¹ 'in lɨ́ɨi¹³ tsá² fariseo coon'¹³ tɨfo'² tya' ley 'in nijalíin² la caain²¹ co' Galilea coon'¹³ Judea coon'¹³ Jerusalén. Coon'¹³ 'ii'²¹ tya' Dios jmoo¹o Jesús un'láai² jileei'²¹ tsatsaa'¹³. ");
INSERT INTO chqNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","La 'ɨɨ²¹² joon gatyalíin² jaain²¹ gái¹ tsañʉʉ'¹ jée¹i jaain²¹ tsá² sɨtsʉʉ'¹³ cwoo²¹ tɨɨ² 'in raan¹in coon²¹ nityi¹. La 'iin²¹²mo taan'¹in inʉʉ do joon tyáai¹ tyani Jesús. ");
INSERT INTO chqNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Pe jo gatsaa'²¹a xiia' fu tsataai² tsʉ lɨ́ɨ¹ fúui¹ tsá² taai². Joon gasoo²¹o fu yʉ' 'nʉ́¹ do. Joon gajan'²an coon'²¹ sii'¹³ teja. Joon gaxáai² 'in tsatsaa'¹³ do tsiin¹in nityi¹ do jee²¹² tsá² fúui¹ do tyani lɨ siin'¹³ Jesús do. ");
INSERT INTO chqNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Mo ganí² Jesús 'e tsáa¹mo‑tsi 'ido joon gasɨɨ'²¹ɨ 'in tsatsaa'¹³ do: ―Tsañʉʉ'¹, niga'íin²mo tsaa² tyi'i. ");
INSERT INTO chqNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Joon 'in tɨfo'² tya' ley coon'¹³ tsá² fariseo do ga'láa² 'wii²¹² 'ɨ¹‑tsi. Jin'²in: ―'In tsañʉʉ'¹ lo faa'²¹a 'laa'²¹ tya' Dios coon'¹³ júu³ tya'a. Ce jiin'¹³ jaain²¹ jo 'in lí² 'íin² tsaa² tya' tsá² ce jiin'¹³ 'ña'a Dios. ");
INSERT INTO chqNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Tsʉ nii² Jesús jilaa'²¹ 'e 'ɨ¹‑tsi 'in tsá² do joon gajin'²in: ―¿'Ee lɨ'ɨ 'ɨ¹‑'oo' la no? ");
INSERT INTO chqNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Noo 'e jogɨ tyan¹ to² fuu²¹²uu 'in tsá² lo: “Jo 'ee tsaa² røøi²¹gɨ'ɨ”, owa fuu²¹²uu 'ee: “Ráan²un no, ngɨ² no”? ");
INSERT INTO chqNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Pe nano ijmáa³aa tyaní²ii' 'e tsáa¹mo‑'oo' 'e Ruu'²¹i Tsá² tɨ́ɨi² 'íin² tsaa² tya' tsá² mo taain¹ fu juncwii²¹. Joon gajin'²in sɨɨ'²¹ɨ 'in tsá² 'in sɨtsʉʉ'¹³ cwoo²¹ tɨɨ² do: ―'Nʉ‑ʉ, fuu²¹²uu. Ráan²un, saa'¹³ tyi¹ tyi'i, cwee'²¹ fu tyi'i ―jin'² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","La tsifu joon 'in tsá² sɨtsʉʉ'¹³ cwoo²¹ tɨɨ² do garoon¹on tyani jileei'²¹ 'in tsá² do. Joon gasaa'¹³a tyi¹ tya'a lɨ raan¹in. Joon gangaa'¹²i fu tya'a cwo'²o 'maai'¹³ Dios. ");
INSERT INTO chqNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Jilee'²¹mo ganga'goo²¹‑tsi. Joon gacwo'²o 'maai'¹³ Dios. 'Goo'²¹o lɨɨlɨ¹ gajin'²in: ―Nano niganee²¹e' coon²¹ 'e fee'¹ 'áai¹. ");
INSERT INTO chqNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Mo ngayuui'¹³ jilaa'²¹ 'elo gacwo'ɨ́ɨ¹ Jesús. Joon ganíi² jaain²¹ 'in cón² 'laa'¹³ 'e 'nɨɨ¹ tsá² sii²¹ Leví. Tyíin¹³in coon²¹ lɨ cɨ́¹ tsá² 'laa'¹³ tya' jilaa'²¹ 'e 'nɨɨ¹ɨ. Joon gasɨɨ'²¹ɨ Jesús 'ido, jin'²in: ―Ná¹ coon'¹³ jna. ");
INSERT INTO chqNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Joon garóon² Leví do. Gatʉ́²o jilaa'²¹. Joon gangóo¹ coon'¹³ Jesús. ");
INSERT INTO chqNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Mo lɨ cɨɨin²¹gɨxʉ joon gajmaa¹a Leví coon²¹ jmɨɨ²¹² fee'¹ lɨ fu tya'a tya' Jesús. Joon lɨ́ɨ¹ fúui¹ 'in cón² 'laa'¹³ tya' 'e 'nɨɨ¹ tsá² taai² coon'¹³. 'In lɨ́ɨi¹³gɨ tsá² néei¹ coon'¹³. ");
INSERT INTO chqNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Pe tsá² fariseo coon'¹³ 'in tɨfo'² tya' ley ga'láa² 'wii²¹² sɨɨ'²¹ɨ tsá² tya' Jesús, jin'²in: ―¿'Ee lɨ'ɨ cǿ²øø' joongɨ 'ú²uu' coon'¹³ 'in cón² 'laa'¹³ tya' 'e 'nɨɨ¹ tsá² coon'¹³ 'in catyaai²gɨ 'in røøi²¹ tsaa²? ");
INSERT INTO chqNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesús‑gɨ gasɨɨ'²¹ɨ 'ido: ―Jo 'néi¹ tɨmɨ́¹ tya' jileei'²¹ 'in tyúi¹. 'Né¹mo jiin'¹³ tya' tsatsaa'¹³. ");
INSERT INTO chqNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Jo mo gagoo²¹²oo wa'a tø'³øø jileei'²¹ 'in tyúi¹. Tø'³oo jiin'¹³ 'in røøi²¹ tsaa² 'e jaa'²¹a‑tsi. ");
INSERT INTO chqNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Joon gaungɨɨ¹ɨ 'in tsá² do Jesús jin'²in: ―¿'Ee lɨ' jmoo¹ 'in tsá² ngɨ¹ coon'¹³ Wó³ taa'²¹a jo gøø'²¹ø joongɨ faa'²¹a júu³ tyʉ́²? Joon la joon jon jmoo¹ tsá² fariseo. Pe tsá² tyi'gɨ'ɨ gø'²o joongɨ 'un'²o ―jin'² 'in tsá² do. ");
INSERT INTO chqNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Joon gajin'² Jesús: ―'Goo²¹ wa'a jo dø'¹ tsá² mi tyalíin² coon²¹ lɨ gacui'² cwoo²¹ tsá² la 'ɨɨ²¹² tyíin¹³ 'in tsá² gacui'² cwoo²¹ do gø'²ø. ");
INSERT INTO chqNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pe ijó² coon²¹ jmɨɨ²¹² mo jo seein²¹gɨ 'in tsá² gacui'² cwoo²¹ do jee²¹² 'naa'. Joon jmɨɨ²¹² joon lí²‑i jmá¹ tsá² taa'²¹a jo døø'²¹ø. ");
INSERT INTO chqNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Gajin'²in jon Jesús gasɨɨ'²¹ɨ 'ido 'e cwáain¹ lo: ―Jin'²in tsá² 'e jo tyʉ́² wa'a tyʉ'² tsá² ca'no'³ sɨɨn'¹³ 'mɨ́ɨ² joon taan'¹²an coon'¹³ sɨɨn'³ tsáai². Wana gajmaa¹ tsá² la joon tsa'ɨ́ɨ¹³ɨ sɨɨn'³ 'mɨ́ɨ² joon jo jnee¹in rǿø² coon'¹³ sɨɨn'³ tsáai² do. ");
INSERT INTO chqNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Joongɨ tún² jo lí³ wa'a tyiia'²¹ tsá² jmɨ'móo¹ 'mɨ́ɨ² tsi loo²¹ tsáai² tsʉ wana gajmaa¹ tsá² la joon 'e jmɨ'móo¹ do mo 'yá² joon 'gɨ́¹o 'e loo²¹ tsáai² do. Joon la joon 'e tsa'ɨ́ɨ¹³ jmɨ'móo¹ coon'¹³ 'e loo²¹ do. ");
INSERT INTO chqNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Tsʉ 'ná²‑a tyiia'²¹ tsá² jmɨ'móo¹ 'mɨ́ɨ² coon²¹ tsi loo²¹ 'mɨ́ɨ². Joon la joon røø²¹ tsatiin'¹³. ");
INSERT INTO chqNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Jo 'iin²¹²in tsá² 'uun'²un vino 'múui² tsifu mo ngayuui'¹³ gaun'¹ tsá² vino tsáai² tsʉ jin'² tsá² 'e jmá²gɨ vino tsáai². ");
INSERT INTO chqNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Coon²¹ jmɨɨ²¹² galɨ́² mo gatɨ́² jmɨɨ²¹² 'ii'²¹ 'woo'²¹ tsá² ngóo¹ Jesús coon²¹ jee²¹² lɨ sɨjna² trigo. Joon tsá² tya'a ngalíin² cuun¹un mɨ'² trigo do. Joon untyʉʉ²¹ coon'¹³ cwoo²¹o. Joon gø'²ø mɨ'² tya'. ");
INSERT INTO chqNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Joon 'in lɨ́ɨi¹³ tsá² fariseo gaunngɨɨ¹ɨ sɨɨ'²¹ɨ 'ido: ―¿'Ee lɨ' jmoo²oo' to² 'e jo tɨ́ɨi² jmoo¹ tsá² mo jmɨɨ²¹² 'ii'²¹ 'woo'² tsá²? ");
INSERT INTO chqNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","4","Jesús‑gɨ gañii¹i: ―Tyʉ́²‑ʉ ñí³ 'naa' 'e gajmaa¹ 'lɨɨ²¹² David. Coon²¹ jmɨɨ²¹² ga'ii²¹ coon'¹³ tsá² seein²¹ tyʉ́² coon'¹³ mo gatsá² un'áai² fu tsi inʉʉ cwo'¹ tya' Dios. Joon gagøø'²¹ø 'e 'iñi'¹ ni cwaai'³ fiin'¹³ jiin'¹³ untsá² tɨ́ɨi² gø'¹ø 'e 'iñi'¹ do. ");
INSERT INTO chqNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","La joon jon Ruu'²¹i Tsá² tɨ́ɨ²mo tyʉ'²ʉ to² mo jmɨɨ²¹² 'ii'²¹ 'woo'²¹ tsá². ");
INSERT INTO chqNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Mo gatɨ́² coon²¹gɨ jmɨɨ²¹² 'e 'ii'²¹ 'woo'²¹ tsá² Jesús nga'ii²¹ fu inʉʉ cwo'¹. Joon ga'láa² 'wii²¹² 'e'²e tsá². Joon do‑o 'yúui² jaain²¹ tsá² 'in tyʉʉn²¹ cwoo²¹ tsáa¹. ");
INSERT INTO chqNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Joon 'in tɨfo'² tya' ley coon'¹³ tsá² fariseo jǿø²i Jesús. Gacón² cwáain¹ wana iun'láai² Jesús 'in tsá² do mo jmɨɨ²¹² 'ii'²¹ 'woo'²¹ tsá². Coon'¹³ 'e la joon lí²‑i jmáa¹a tsaa² tya' Jesús. ");
INSERT INTO chqNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pe Jesús ñi¹o 'e 'ɨ¹‑tsi 'in tsá² do. Joon gasɨɨ'²¹ɨ 'in tsá² tyʉʉn²¹ cwoo²¹ do: ―Ráan²un. Jmáa² siin'¹³u'un tún² tsa'² no. Joon garóon² 'in tsá² do. Joon gajmaa¹ siin'¹²in. ");
INSERT INTO chqNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Joon gajin'² Jesús gasɨɨ'²¹ɨ 'in tsá² catyaai² do: ―Niunngɨɨ²duu 'naa', ¿'ee 'e tɨ́ɨi² jmaa¹ tsá² mo 'e jmɨɨ²¹² 'ii'²¹ 'woo'²¹ tsá², tɨ 'e tyʉ́² owa 'e gó² 'ee? ¿Tɨ 'e jmá¹ tsá² tiin'¹³ tsá² owa 'e jóoin² tsá² 'ee? ");
INSERT INTO chqNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Joon gajǿø²i Jesús jileei'²¹ 'in téein² co' lɨ siin'¹³in. Joon gasɨɨ'²¹ɨ 'in tsañʉʉ'¹ do: ―Nii'¹³ cwoo¹'o. Joon gajmaa¹ 'in tsá² do. Joon ga'lóo² cwoo²¹. ");
INSERT INTO chqNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Pe 'in catyaai²gɨ do gatsá² 'nii'²¹‑tsio. Joon ga'láa² 'wii²¹² unngɨɨ¹ɨ la 'oo'²¹ jee²¹² 'ii 'ee ijmáa¹a 'e gó² tya' Jesús. ");
INSERT INTO chqNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Jee²¹² jmɨɨ²¹² joon gangó¹ Jesús fu coon²¹ moo'²¹. Ngafaa'¹²a júu³ tyʉ́². Joon do‑o gajaan¹ la tøø²mo 'woo¹ fee'¹i Dios. ");
INSERT INTO chqNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Joon mo gajná² joon gatø'² Jesús tsá² tya'a 'in ngɨ́¹ coon'¹³. Joon gatyii'¹³in dyatuuin¹ jee²¹² 'ii. 'Ii 'in galisii²¹ apóstol. ('øøi'²¹‑tsi tsá²: tsá² tya'a 'in gasii¹in.) ");
INSERT INTO chqNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","'In lo do 'in sii²¹ Simóoi¹³, 'in gaunsii²¹o jon Tʉ́³. Jaain²¹gɨ 'in sii²¹ Dɨ́ɨ³, ruu'²¹i Simóoi¹³. 'In catyaai²gɨ do sii²¹ Jacobo coon'¹³ Wó³ coon'¹³ Lii²¹² joongɨ coon'¹³ Bartolomé coon'¹³ ");
INSERT INTO chqNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Untǿø³ coon'¹³ Tomóo¹³. Joongɨ coon'¹³ Jacobo jóon¹ Alfeo coon'¹³ Simóoi¹³, jaain²¹ tsá² tya' coon²¹ poo²¹² sii²¹ cananista. ");
INSERT INTO chqNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Coon'¹³ Judas ruu'²¹i Jacobo coon'¹³ Judas Iscariote, 'in mo lɨcɨɨin²¹ ga'nɨɨi¹ Jesús. ");
INSERT INTO chqNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jesús gajgáai¹ fu moo'²¹ do coon'¹³ 'in tsá² ngɨɨ¹ coon'¹³. Joon gajaan¹ coon²¹ ni míi³ coon'¹³ 'in ngɨɨ¹ coon'¹³. Joon lɨ́ɨ¹ fúui¹ tsá² seein²¹. 'In tsá² do nijalíin² la caain²¹ lɨ san'² Judea coon'¹³ Jerusalén coon'¹³ lɨ tyʉ'² to² Tiro coon'¹³ Sidón. 'In tsá² lo nijalíin² 'e janʉ́ʉ² júu³ tya' Jesús. Joongɨ jalíin² wa'a un'láai² Jesús 'ii jilaa'²¹ jmoowúu¹ 'e tyaan¹. ");
INSERT INTO chqNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Joongɨ jileei'²¹ 'in ní² wúu¹ coon'¹³ espíritu gó² un'láa²mo. ");
INSERT INTO chqNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Jileei'²¹mo tsá² 'iin²¹²in 'in soon'²¹on tya' Jesús tsʉ tyʉ́² jmoo¹o mɨ́ɨ¹ coon'¹³ jilaa'²¹ 'ii'²¹ tya'o. Joon ga'láa²mo jileei'²¹. ");
INSERT INTO chqNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Joon gajǿøi² Jesús tsá² ngɨɨ¹ coon'¹³. Joon gajin'²in: ―Tyʉ́²‑ʉ sɨ'ɨ́ɨ¹³‑'oo' tsá² tañíi² 'naa', tsʉ ityʉ'² Dios to² 'naa'. ");
INSERT INTO chqNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Tyʉ́²‑ʉ sɨ'ɨ́ɨ¹³‑'oo' 'naa' 'in un'aai² no, tsʉ mi lɨ cɨɨin²¹ nirǿ¹mo tu¹uu'. ’Tyʉ́²‑ʉ sɨ'ɨ́ɨ¹³‑'oo', 'naa' 'in cɨ'² nano, tsʉ mi lɨ cɨɨin²¹gɨ nilijløø'³moo'. ");
INSERT INTO chqNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Tyʉ́²‑ʉ si'ɨ́ɨ¹³‑'oo' jileei'²¹ 'naa' mo 'eei'¹ tsá² 'naa', joongɨ mo 'wooi¹ tsá² 'naa' fu caluu, mo faa'²¹a tsá² 'laa'²¹ tyii', mo faa'²¹ tsá² gó² 'wii'¹³ tyii' tsʉ 'wii'¹³ ngɨɨ¹ɨɨ' coon'¹³ 'in Ruu'²¹i Tsá². ");
INSERT INTO chqNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Unjløøi'³ 'yaanaa' coon'¹³ 'e jmɨɨ²¹² joon tsʉ lɨ́ɨ¹ fee'¹gɨ tyii' mo tyalíin²naa' ñʉ'fú². La joon jon gajmaa¹a 'in 'lɨɨ²¹² tsacøøi'¹³ tya' 'in tsá² no, gajmee'²¹i 'in tsá² 'in gacwo¹ júu³ tyʉ́² calɨɨ. ");
INSERT INTO chqNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Lɨ́ɨ¹ fúu² 'naa' tsá² sá² cuu² tsʉ nigali'óo²oo' 'e tyʉ́² seen²¹naa'. ");
INSERT INTO chqNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Lɨ́ɨ¹ fúu² jileei'²¹ 'in seein²¹ tyʉ́² nano tsʉ mi lɨ cɨɨin²¹gɨxʉ nityaa²¹² un'aa²naa'. ’Lɨ́ɨ¹ fúu² 'naa' 'in jløøi'³ nano tsʉ mi lɨ cɨɨin²¹gɨxʉ 'incɨɨ'³oo' coon'¹³ jilaa'²¹ fa'í². ");
INSERT INTO chqNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Lɨ́ɨ¹ fúu² 'naa' jileei'²¹ 'in faa'²¹ tsá² tyʉ́² tyii' nano tsʉ la joon gajmaa¹a 'lɨɨ²¹² tsacøøi'¹³ tya'a coon'¹³ 'in gacwo¹ júu³ gó² lawa júu³ tyʉ́². Faa'²¹gɨ Jesús jin'²in: ");
INSERT INTO chqNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","―Pe jilee'²¹naa' 'in nuu¹u júu³ tyiia fuu²¹²uu 'elo: Cwoli'iin²¹²moo' jileei'²¹ 'in 'eei'¹ 'naa'. Joongɨ jmaa²aa' jilaa'²¹ 'e tyʉ́² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Cwauncwaa'³naa' jileei'²¹ 'in un'lɨɨi'³ 'naa'. Mɨ́²ɨɨ' 'wii²¹² tya'a tyani Dios jileei'²¹ 'in cwo¹ tsaa² 'naa'. ");
INSERT INTO chqNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Wana 'in gapó² cataain²¹ ni'¹'i, cwoo'¹³'o wa'a pó² 'e cataain²¹gɨ do. Wana 'in gatyí² 'mɨ'² tyíia² tyi'i cwoo'¹³'o cwotyaan²¹ jon 'e 'mɨ'² tyii'¹³'i. ");
INSERT INTO chqNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Cwoo'¹³ doñi'iin 'in gamɨ́¹. Wana 'in gacón² 'e 'óo²‑o'o jo mɨ́ɨ²gɨ'ɨ. ");
INSERT INTO chqNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Jmaa²aa' tya' tsá² xeei'²¹ ce jilaa'²¹ 'e 'iin²¹²naa' 'e jmá¹ tsá² tyii'. ");
INSERT INTO chqNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Jmaa²aa' 'e tyʉ́² jon' jiin'¹³ tya' 'in tsá² 'in 'néei¹ 'naa' tsʉ tsá² gó² jmoo¹o 'e tyʉ́² tya' jiin'¹³ 'in 'iin²¹²mo. ");
INSERT INTO chqNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Jo jmaa²aa' 'e tyʉ́² wana jmoo²oo' tyʉ́²‑ʉ jiin'¹³ tya' 'in tyúi¹ coon'¹³ 'naa' tsʉ cagɨ 'in jo tyú¹mo jmoo¹o la joon. ");
INSERT INTO chqNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Joongɨ jo jmaa²aa' 'e tyʉ́² wana tyíi²oo' jiin'¹³ coon'¹³ 'e lɨ́ɨ² 'naa' 'e joon'¹³on jilaa'²¹ tún¹ tsʉ la joon jon 'in gó² tyí²o tya' 'in gó². 'ɨ¹‑tsi 'e 'ii'²¹mo jilaa'²¹ tún¹ tya' 'ido. ");
INSERT INTO chqNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Pe 'naa' 'ná¹ un'nee²¹naa' ce jileei'²¹ 'in 'eei'²¹ 'naa'. 'Ná¹‑a jmaa²aa' jilaa'²¹ 'e tyʉ́¹ tya'a. 'Ná²‑a tyí²oo' tya'a. Cwoo²oo', jo 'e 'ɨ¹gɨ‑'oo' 'e có²gɨɨ' tún¹ jiin'¹³ xʉ. Tsʉ la joon jon lí² lifee'¹gɨ jilaa'²¹ 'e cwo'¹ Dios 'naa'. Joon la joon líin²naa' jóon¹ Dios 'in Ñíi¹gɨ. Tsʉ 'in feei'¹‑tsi 'ii coon'¹³ jileei'²¹ 'in jo cwoo'²¹ 'maa'¹³i 'ii coon'¹³ jileei'²¹ 'in gó². ");
INSERT INTO chqNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Cwoli'woo¹‑'oo' jon la 'woo¹‑tsi Ñʉ'¹ʉ'. 'E'²gɨ Jesús tsá² gajin'²in: ");
INSERT INTO chqNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","―Jo cwó²oo' tsaa² tya' tsaruu'²¹naa' la joon jon Dios jo icwó¹ tsaa² tyii'. Jo piin²¹²naa' tsá² xeei'²¹ la joon jon Dios jo píin² 'naa'. ");
INSERT INTO chqNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Cwoo'¹³gɨɨ' tsá² xeei'²¹ 'e tyʉ́² la joon jon cwo'²gɨ Dios 'naa' 'e tyʉ́². Mo tyaa¹ 'ii'²¹ tyii' coon'¹³ 'mó² 'ii'²¹ cwuu²¹ rǿøi²gɨ tó²oo'. Tá²gɨ táa²aa'. Nijmaa¹ Dios 'ii'²¹ tyii' coon'¹³ 'ii'²¹ 'e 'naa' gajmee'¹³ 'naa' to² coon'¹³ tsá² xeei'²¹. ");
INSERT INTO chqNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesús gasɨɨ'²¹gɨ tsá² cwáain¹ lo: ―Jo lii'¹i jaain²¹ tsatiuui² 'méei² jaain²¹gɨ tsatiuui² tsʉ la jiwáa²mo ixuu'²¹i coon²¹ tsi too²¹. ");
INSERT INTO chqNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Xʉfiin'¹³ cwo'²‑tsi 'áai¹ 'in untsáa¹ do pe jo lí² tɨ́ɨi²gɨ jiin'¹³ la tɨ́ɨi² tɨfo'² tya'a. Pe mo natɨ́ɨi² tyʉ́²‑ʉ itɨ́ɨi² la tɨ́ɨ² tɨfo'² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’Áai¹ jo tyan¹ to² lí² jǿø¹³'ø coon²¹ tyi¹ 'yʉ unni² ruu'²¹'u. Pe joon jo mo tyaan²du'u cwáain¹ coon²¹ po'mó² sɨcu'³ unni'²'i 'wo'o. ");
INSERT INTO chqNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿Xiiala tá²‑'o'o fu'³'u ruu'²¹'u?: “Ru'¹u' cwodu' tyíi³ii tyi¹ 'yʉ unni'²'i.” Pe jo mo tyan¹du'u cwáain¹ xiiala lɨ́¹ po'mó² 'yʉ unni'²'i 'wo'o. ¡Tsá² tajuui²¹ 'nʉ! Tyi²du' jéei¹ po'mó² 'yʉ unni'²i joongɨ lí² jǿø¹³'ø 'e lí² tyi'³'i tyi¹ 'yʉ unni² ruu'²¹u ―gajin'² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Faa'²¹gɨ Jesús jin'²in: ―Jo sá² 'mó² 'oofuu²¹ tyʉ́² 'e cwo¹ 'oofuu²¹ gó² jon'gɨ sá² 'mó² 'oofuu²¹ gó² 'e cwo¹ 'oofuu²¹ tyʉ́². ");
INSERT INTO chqNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Cwii¹ tsá² 'mó² 'e 'ɨ́ɨ¹ 'oofuu²¹ coon'¹³ 'oofuu²¹ sɨ'ɨ́ɨ¹. Jo cun¹ tsá² mɨ'³ cworíi³ 'e tsi wuu²¹ tóon¹ fii'¹. ");
INSERT INTO chqNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Jileei'²¹ tsá² tyúi¹ faa'²¹o jilaa'²¹ 'e tyʉ́²‑ʉ tsʉ tsi alma tya'o náa¹ jilaa'²¹ 'e tyʉ́². Jileei'²¹gɨ tsá² gó² faa'²¹o jilaa'²¹ 'e go tsʉ tsi alma tya'o náa¹ jilaa'²¹ 'e gó². Ce jilaa'²¹ 'e gafaa'²¹ tsá² coon'¹³ 'oo²o 'e jalí² tsi alma tya'a tsá² joon. ");
INSERT INTO chqNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Jesús jin'²in: ―'Naa' fuu'²¹ jna: “Ña'ñʉ'¹ʉ'.” Pe jogɨ jmoo²oo' la to² tyʉ'³ʉʉ. ");
INSERT INTO chqNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Fú³duu 'naa' xiiala lɨ́ɨi² jileei'²¹ 'in jalíin² janʉ́ʉ² júu³ tyiia, joongɨ jmoo¹o la to² tyʉ'³ʉʉ. ");
INSERT INTO chqNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Lɨ́ɨ¹i lawa jaain²¹ tsañʉʉ'¹ 'in gajmaa'¹² coon²¹ 'nʉ́¹. Pe nifu ga'iin¹in 'o'² lɨɨlɨ¹. Joongɨ gajmaa¹a tɨɨfuu²¹ ni cuun²¹² do. Joon la joon mo gali'láai² jmɨɨ²¹ do lɨ́ɨ¹ ga'la'²a 'e 'nʉ́¹ do. Pe jo galɨ'²ɨ gatyíian² tsʉ 'wii'¹³ ni cuun²¹² lɨ́¹ tɨɨfuu²¹ do. ");
INSERT INTO chqNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pe jileei'²¹ 'in nuu¹un joon jo jmoo¹o la to² tyʉ'³ʉʉ lɨ́ɨi² lawa jaain²¹ tsañʉʉ'¹ 'in gajmaa'¹²a 'nʉ́¹ ni 'wó². Jo 'ee tɨɨfuu²¹ gasii'²¹i. Joon mo gali'láai² jmɨɨ²¹ joon gatyíian²o 'e 'nʉ́¹ do. Joon gacɨ'²mo. Joon nga'ɨ́ɨ¹ coonti ―jin'² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Mo ngayuui'¹³ gatséi¹ gafeei'²¹ Jesús 'in tsá² do joon gangóo¹ fu Capernaum. ");
INSERT INTO chqNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Do‑o ni seein²¹ jaain²¹ 'in tyʉ'² to² cíein¹³ 'láa² tya' Roma. Joon ni'áa¹i jaain²¹ tsá² tya'a 'in ni'iin²¹²in lɨɨlɨ́¹. Niraain¹ tɨ lɨ júun²mo. ");
INSERT INTO chqNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Mo ganúu² 'in tyʉ'² to² 'láa² do 'e faa'²¹ tsá² tya' Jesús joon gasii¹in jaain²¹ gái¹ tsacøøi'¹³ jee²¹² tsá² Israel 'e tsamɨɨ¹ɨ tyaníi¹i wa'a jó¹ jaun'láai² tsá² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Joon gangatyéein¹ 'in tsá² do tyani Jesús. Joon ga'láa² 'wii²¹² gamɨɨ¹ɨ tyani Jesús, jin'²in: ―'In tyʉ'² to² 'láa² do tɨ́ɨ²mo 'e uncoon'¹³on ");
INSERT INTO chqNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","tsʉ lɨ́ɨ¹ fee'¹‑tsi tya' fuu²¹ goo²¹o'. Joon 'i‑o tyʉ'² to² lɨɨ¹ɨ cwo'¹ tyii'i. ");
INSERT INTO chqNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Joon gangó¹ Jesús coon'¹³on. Pe mo gatyíia¹ tyan' co' lɨ si'² 'nʉ́¹ do joon 'in tyʉ'² to² 'láa² do gasii¹in jaain²¹ tsá² seein²¹ tyʉ́² coon'¹³ 'e tsasii'¹³i Jesús: ―Ñi'fii²¹i', jo untyíin²gɨ 'wo'o, tsʉ jo tɨ́ɨ²na 'u'²'u 'inʉʉ tyiia. ");
INSERT INTO chqNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","'Wii'¹³ joon jo gatá²‑tsii ga'nee'²¹na 'nʉ. Lɨ goon foo'²¹o'o joon la joon i'láa²mo tsá² tyiia. ");
INSERT INTO chqNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Lawa'a jna 'ii'¹³moo to² tyʉ'² tsá² xeei'²¹ joongɨ tyʉ'³oo to² tsá². Joon mo tyʉ'³ʉʉ to² 'e tsalíin² tsá², tsalíin²mo jon. Joongɨ motyʉ'³ʉʉ jó¹, jó¹‑o. Joongɨ mo tyʉ'³ʉʉ to² tsá² tyiia jilaa'²¹a jmoo¹‑o. ");
INSERT INTO chqNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Joon mo ganúu² Jesús 'elo lɨ́ɨ¹ ganga'goo²¹‑tsi. Joon gajǿøi² jileei'¹³ tsá² jalíin² coon'¹³ do. Joon gajin'²in: ―'E la ja'²mo, jiin'¹³ jaain²¹ jee²¹² tsá² Israel jo mo gatsee'²¹na 'in tsáai¹‑tsi la tsáai¹‑tsi 'in tsañʉʉ'¹ lo. ");
INSERT INTO chqNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Joon mo gangaliin¹in 'in tsá² gasii¹in do gatsee'²¹i 'in tsá² do nityú¹mo. ");
INSERT INTO chqNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Mo ngayuui'¹³ jilaa'²¹ 'elo Jesús ngóo¹ fu coon²¹ fuu²¹ sii²¹ Naín. Joon ngalíin²mo coon'¹³ tsá² ngɨ¹ coon'¹³on coon'¹³ fúui¹gɨ tsá² xeei'²¹. ");
INSERT INTO chqNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Joon mo gatyíia¹ co' fuu²¹ do ganii²¹ jéei¹ tsá² jaain²¹ 'lɨɨ²¹² itsa'áa¹³i. Jiin'³ 'in do‑o jóon¹ 'yiia'ñɨɨ² 'in niseein²¹. Lɨ́ɨ¹ fúui¹ tsá² seein²¹ fuu²¹ do ngalíin² coon'¹³on. ");
INSERT INTO chqNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Mo ganíi¹in Jesús 'ii fúu² galɨ́ɨi² 'ido. Joon gajin'²in gasɨɨ'²¹ɨ 'ido: ―Jo cɨɨ'²¹'ɨ. ");
INSERT INTO chqNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Joon gangatyéein¹ Jesús. Joon gasʉʉ²¹ 'e cwóo¹ do. Joon 'in tyan¹ cwóo¹ do gajan¹o. Joon gasɨɨ'²¹ Jesús 'in 'lɨɨ²¹² do: ―Sɨmii'²¹, jna‑a fuu²¹²uu 'nʉ: ¡Raan²un no! ");
INSERT INTO chqNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Joon 'in tsá² nigajúin¹ do nigacwoo²¹‑o. Joon ga'láa² 'wii²¹² faa'²¹a. Joon Jesús gajaan'²¹mo sáa³o 'ido. ");
INSERT INTO chqNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Mo ganii²¹ 'in tsá² taain²¹² do jilaa'²¹ 'elo jmai'² 'in gafoo'²¹mo. Joon ga'láa² 'wii²¹² cwo'²o 'maai'¹³ Dios. Jin'²in: ―Jaain²¹ tsá² feei'¹ 'in cwo¹ júu² tyʉ́² nigajnéi¹ jee²¹² jna'. Jin'²o jon: ―Dios nigajó² 'e uncoon'¹³on fuu²¹ goo²¹o'. ");
INSERT INTO chqNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","La tǿøi² Judea coon'¹³ la cu' lɨ' lɨ san'² galiñii¹ tsá² 'e nigajmaa¹a Jesús. ");
INSERT INTO chqNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","'In tsá² ngɨɨ¹ coon'¹³ Wó³ gajma'²o júu³ jilaa'²¹ 'e nigalí². Mo galiñí² Wó³ 'elo joon gatø'²ø ngái¹ jee²¹² 'ii. ");
INSERT INTO chqNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Joon gasii¹in tyani Jesús 'e tsasii'¹³i wana jo'²o 'i‑o Cristo 'in 'ná² jó¹ owa'a sɨjéen¹in 'in xee'²¹mo 'ee. ");
INSERT INTO chqNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","'In tsá² gasii¹in Wó³ do gangatyéen¹mo lɨ siin'¹² Jesús. Joon gasɨɨ'²¹ɨ 'ido: ―Wó³ saai¹ tsá² jmɨɨ²¹ nigasii¹in jna'a 'e unngɨɨ²ɨ'ɨ 'nʉ wana 'nʉ‑ʉ Cristo 'in 'ná² jó¹ owa 'ná²‑a jeen²na'a 'in xee'²¹mo 'ee. ");
INSERT INTO chqNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","La tsifu joon mo gatyalíin² 'in tsá² do, Jesús gaun'láai² fúui¹ tsatsaa'¹³ coon'¹³ jmoowúu¹ tsáai² coon'¹³ 'láai² nii²gɨ jmoowúu¹. Ga'wooi¹ 'in 'lɨɨi'³ táai² alma tya' tsá². Lɨ́ɨ¹ jon fúui¹ tsatiuui² gaun'láai². ");
INSERT INTO chqNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","La joon gasɨɨ'²¹ɨ Jesús 'in tsá² do: ―Cwolíin²naa', joon cwosíi²ii' Wó³ la lɨ 'e nigañíi²ii' joongɨ ninʉ́ʉ²ʉʉ'. Cwosíi²ii' xiiala la lí² jǿø² tsatiuui². Joongɨ tsajluui'¹³ lí²‑i ngɨ́³. Joongɨ tsá² jgøøi'²¹ ga'láa²mo. Joongɨ tsá² cwuui²¹² nuu¹o. Joongɨ 'lɨɨ²¹² gajiin'²¹o. Joongɨ tsá² tañíi² nuu¹o júu³ tyʉ́² tya' 'e tiin'¹³ tsá². ");
INSERT INTO chqNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Jløø'³mo 'áai¹ jileei'²¹ 'in jo cu'²‑tsi coon'¹³ jna. ");
INSERT INTO chqNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Mo ngayuui'¹³ gangalíin² 'in tsá² gasii¹in Wó³ Jesús ga'láa² 'wii²¹² gasɨɨ'²¹ɨ tsá² cwáain¹ tya' Wó³, jin'²in: ―'Naa' jo mo tyalíin²naa' tyajǿø²oo' lɨ jo 'in tsá² seein²¹ coon²¹ tó² 'e jøø'²¹ coon'¹³ tyí². ");
INSERT INTO chqNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Jon'gɨ mo tyajøøi'²¹ 'naa' jaain²¹ tsá² 'in tyi'² 'mɨ'² tyʉ́². Niñíi³ 'naa' jileei'²¹ 'in tyi'³ 'mɨ'² tyʉ́² 'in seein²¹ tyʉ́² 'ii néei¹ lacaain²¹ tya' rǿø¹³mo. ");
INSERT INTO chqNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","'Naa' nigatyajøø²¹²naa' jaain²¹ tsá² 'in cwo¹ júu³ tyʉ́². Joon la joon gañíi²ii'. La joon fo'²oo 'e 'ido‑o 'in tyíin²gɨ la jee²¹² jileei'²¹ 'in nigacwo¹ júu³ tyʉ́². ");
INSERT INTO chqNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Tsʉ cwáain¹ tya' 'ii la mo gajin'² ni jí² tya' Dios la lo: Sɨ́ɨ³na tsá² tyan¹ júu³ tyʉ́² nifugɨ lɨ cwóo²'o. Joon 'e tyáa² tyʉ́² tsá² i'ii'²¹mo 'nʉ. ");
INSERT INTO chqNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","'E la ja'²mo fuu²¹²uu 'naa', jee²¹² jileei'²¹ tsá² jo mo cwai'² jaain²¹ tsá² 'in cwo¹ júu³ tyʉ́² 'in feei'¹gɨ lagɨ Wó³ sai¹ tsá² jmɨɨ²¹. Pe doñi'iin 'in 'wói¹gɨ 'in seein²¹ lɨ tyʉ'² Dios to² 'ido 'in feei'¹gɨ lagɨ Wó³. ");
INSERT INTO chqNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Mo ganuu¹un jileei'²¹ tsá² 'elo coon'¹³ 'in cón² 'laa'¹³ tya' jilaa'²¹ 'e 'nɨɨ¹ tsá² 'in nigasaai¹ Wó³ jmɨɨ²¹ gajin'²o 'e ja'²mo Dios. ");
INSERT INTO chqNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pe 'in tsá² fariseo coon'¹³ tɨfo'² tya' ley 'in cwói¹ yaai 'e saai¹ Wó³ 'ii jmɨɨ jo ga'ii'²¹i jilaa'²¹ 'e la mo 'iin²¹² Dios jmáa¹a 'wii²¹² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Gajin'²gɨ Jesús: ―Nanogɨ cóon³duu cwáain¹ xiiala lɨ́ɨi¹ tsá² 'in seein²¹ nano. Fo'³duu xiiala lɨ́ɨi¹. ");
INSERT INTO chqNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Lɨ́ɨi¹ la lɨ́ɨi¹ xuui²¹² 'in néei¹ to² coo¹o la caain²¹ fu 'moo'¹³. Tøø'²¹ø xuui²¹² ngɨɨ¹ coon'¹³ jin'²in: “Xʉʉ²¹ʉ'ʉ lúu¹ pe jo tseen²¹²naa'. 'øø²¹ø'ø coon²¹ júu³ fa'í³ tyii' pe jo cɨ́²ɨɨ'.” ");
INSERT INTO chqNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Gajó² Wó³ saai¹ tsá² jmɨɨ²¹ joon jo 'ee gø'²ø 'iñi'¹ jon'gɨ vino 'uun'²¹un. Joon 'naa'gɨɨ' foo'²¹oo' 'e tyaan¹ coon²¹ espíritu gó². ");
INSERT INTO chqNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Joon mo ngayuui'¹³ joongɨ gagó² jna 'in Ruu'²¹na Tsá². Gø'³oo joongɨ gu'³oo. Joongɨ foo'²¹oo' 'e jlo² tu'³uu, 'e gø'³øø joongɨ gu'³uu lɨ́ɨ¹gɨ. Joongɨ foo'²¹oo' 'e seen²¹na tyʉ́² coon'¹³ jileei'²¹ 'in røøi²¹ tsaa² coon'¹³ 'in cón² 'laa'¹³ tya' 'e 'nɨɨ¹ tsá². ");
INSERT INTO chqNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Iliñi¹ tsá² 'e jmɨɨ¹‑tsi Dios coon'¹³ jilaa'²¹ 'e jmoo¹ 'in jai'² lɨ́ɨ²i 'ii. ");
INSERT INTO chqNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Jaain²¹ tsá² fariseo gatø'¹ø Jesús 'e tsa'ee'²¹e 'í¹ fu tya'a. Joon gangó¹ Jesús fu tya'a. Joon jiin'¹³ la tɨɨsi'² gacwoo²¹ Jesús caai¹ mesa. ");
INSERT INTO chqNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Joon galiñi¹ jaain²¹ tsamɨ́² 'in nirøøi²¹ tsaa² 'in seein²¹ 'e fuu²¹ do 'e nigangó¹ Jesús nga'ee'²¹ 'í¹ fu tya' 'in fariseo do. Joon gatyíi¹a 'in tsamɨ́² do tyaan¹ coon²¹ tsʉʉ² lɨ́¹ cʉʉn²¹² alabastro sɨ'²o jmɨɨ²¹ jmafuu²¹. ");
INSERT INTO chqNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Joon lɨɨlɨ¹ cɨ'²ɨ xuui²¹²‑tsi. Gatyíi¹a caluu lɨ tyíin¹² Jesús. Joon ga'láa² 'wii²¹² garun'²un tɨɨ² Jesús coon'¹³ jmɨɨ²¹ toon²¹ uníi¹i. Mo ngayuui'¹³ joon gauntyʉʉn²¹ coon'¹³ jñʉtyíi¹i. Joon gajun'¹un tɨɨ² Jesús. Joongɨ ga'íi² jmɨɨ²¹ jmafuu²¹ tɨɨ² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Joon mo ganí² 'in tsá² fariseo 'in nigatø'¹ Jesús do joon ga'ɨ¹‑tsi: “Wana 'in tsañʉʉ'¹ no 'e la jai'² jaain²¹ tsá² cwo¹ júu³ tyʉ́² nilili'³o 'iin 'in sʉ́² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Joongɨ nilili'³o xiiala lɨ́ɨi¹ 'in tsamɨ́² do. Tsʉ jaain²¹ tsamɨ́² 'in røøi²¹ tsaa² no.” Joon gasɨɨ'²¹ɨ Jesús 'in tsá² fariseo do: ―Simóoi¹³, sá² coon²¹ 'e fuu²¹²uu 'nʉ. Joon gañii¹i 'in tsá² fariseo do: ―Faa'¹³du', tɨfo'². ");
INSERT INTO chqNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Joon gajin'² Jesús: ―Lawa gái¹ tsañʉʉ'¹ nirøøi²¹ cuu² tya' jaain²¹ tsañʉʉ'¹ 'in tyí² cuu². Jaain²¹ 'ido nirøøi²¹ 'ñá² cíein¹³ cuu². 'In jaain²¹ dogɨ nirøøi²¹ ca'no'³ cíein¹³. ");
INSERT INTO chqNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Joon jo nii²¹ 'e ityí²gɨ 'e røøi²¹ tya' 'ido. Joon 'in tsá² tyí² cuu² do galifee'¹mo‑tsi 'e røøi²¹ 'ido tya' la jiwaa²mo. Joon nano jmáa²du' júu³, ¿'iin jee²¹² ngái¹ do 'in gali'iin²¹²gɨ 'in tsá² tyí² cuu² do? ");
INSERT INTO chqNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Joon gañii¹i Simóoi¹³: ―Lɨ́ɨ²na 'in tsañʉʉ'¹ 'in garøøi²¹gɨ lɨ́ɨ¹gɨ. Joon gajin'² Jesús: ―Jo'²o júu³ tyi'i. ");
INSERT INTO chqNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Joon gajǿøi² Jesús 'in tsamɨ́² do. Joon gasɨɨ'²¹ɨ Simóoi¹³: ―Jøøi²¹²du' 'in tsamɨ́² lo. Ga'uu²¹²uu fu tyi'i. Joon jo gacwo'²'o jmɨɨ²¹ 'e ruun'¹³uun tɨ́ɨ³ɨɨ, pe 'in tsamɨ́² logɨ garun'²un tɨ́ɨ³ɨɨ coon'¹³ jmɨɨ²¹ toon²¹ unníi¹i. Joon gauntyʉʉn²¹ coon'¹³ jñʉtyíi¹i. ");
INSERT INTO chqNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Jo gajiin'¹'in tyiia pe 'in tsamɨ́² logɨ jo mo jan¹ jun'²o tɨ́ɨ³ɨɨ jiin'¹³ la ga'uu²¹ tyi'i. ");
INSERT INTO chqNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Jo ga'ee²'e aceite mootyíi³ii, pe 'i‑gɨ nigaxéi² jmɨɨ²¹ jmafuu²¹ tɨ́ɨ³ɨɨ. ");
INSERT INTO chqNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","'Wii'¹³ joon fo'³oo: Lɨɨlɨ¹ røøi²¹ tsaa² pe 'ee²¹o xiiala 'íin²na tsaa² tya'a tsʉ 'wii'¹³ lɨ́ɨ¹ gali'iin²¹² jna. Pe jileei'²¹ tsá² 'in xʉʉ tsaa² 'íin²na tya'a 'e joon xʉʉ 'e 'iin²¹²in jna ―jin'² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Joon gajin'²in sɨɨ'²¹ɨ 'in tsamɨ́² do: ―Niga'íin¹moo tsaa² tyi'i. ");
INSERT INTO chqNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Joon jileei'²¹ tsá² 'in nijalíin² néei¹ do coon'¹³ 'i ga'láa² 'wii²¹² sɨ́ɨ¹i jee²¹² 'ii: ―¿'Iin 'in tsañʉʉ'¹ lo 'e ca jɨgɨ tsaa² tya' tsá² 'íin²in? ");
INSERT INTO chqNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Pe Jesús‑gɨ gasɨɨ'²¹ɨ 'in tsamɨ́² do: ―Nigajmaa²¹²aa tiin'¹³mo'o tsʉ 'wii'¹³ ja'²mo galɨ́ɨ²u. Jløø'³mo'o cwoo'²mo'o. ");
INSERT INTO chqNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Mo ngayuui'¹³ jilaa'²¹ 'elo Jesús ngɨɨ¹ la caan²¹mo fuu²¹ coo'¹³ coon'¹³ fuu²¹ pi'³ do. Cwoo¹o júu³ tyú² joongɨ 'e'²e tsá² xiiala tyʉ'² Dios to² tsá². Ngalíin²mo coon'¹³ jɨ dyatuuin¹ tsá² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ngalíin²mo jon 'in lɨ́ɨi¹³gɨ tsamɨ́² 'in niga'wooi¹ 'in 'lɨɨi'³ taai² alma tya'a coon'¹³ 'láai² nii²gɨ jmoowúu¹. Jee²¹² 'ii ngóo¹ María 'in sii²¹ Magdalena. 'Ido‑o niga'wooi¹ dyái¹ 'in 'lɨɨi'³ taai² alma tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Do‑o jon ngóo¹ Yawuun², tsamɨ́² tya' jaain²¹ tsañʉʉ'¹ sii²¹ Chuza 'in lɨ́ɨi¹ to² tya' Herodes. Do‑o jon ngóo¹ Susana coon'¹³ 'in lɨ́ɨi¹³gɨ tsamɨ́² 'in uncoon'¹³ Jesús coon'¹³ jilaa'²¹ 'e jmaa'²¹i to². ");
INSERT INTO chqNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Lɨ́ɨ¹ fúui¹ tsá² ga'wooi²¹ la caain²¹ fuu²¹ do 'e tsajøøi²¹² Jesús. Joon mo galicaain²¹ tsá² fúui¹ lɨɨlɨ¹ joon gafaa'²¹ Jesús coon'¹³ coon²¹ cwáain¹. Gajin'²in: ");
INSERT INTO chqNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Lawa jaain²¹ tsá² gacwo'ɨ́ɨ¹ ijñí² mɨ'³ jún². La 'ɨɨ²¹² ngóo¹ dya'²a 'e mɨ'³ jún² do 'e lɨ́ɨi¹³ mɨ'³ jún² do gaxʉʉ'²¹ tya'i fu. Joon ga'ø'²ø tsá² joongɨ gagøø'²¹ø tón¹‑on 'e mɨ'³ do. ");
INSERT INTO chqNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Joon 'e lɨ́ɨi¹³gɨ gaxʉʉ'²¹ jee²¹² cuun²¹². Joon mo ga'yiia¹ ñi'¹ galityʉʉn²¹ tsʉ jo 'ee cwoo'¹³ sá². ");
INSERT INTO chqNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","'E lɨ́ɨi¹³gɨ gaxʉʉ'²¹ jee²¹² tóon¹. Joon gajgoo'²¹o coon'¹³ 'e tóon¹ ga'yiia¹ caain²¹ coon'¹³ do. ");
INSERT INTO chqNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Pe 'e lɨ́ɨi¹²gɨ mɨ'³ jún² do gaxʉʉ'²¹ jee²¹² cwoo'¹³ lɨ tyʉ́². Joon mo gacwáin¹ tyʉ́²ʉ gacwo¹. Ca cíein¹³ mɨ'³ lɨ́ɨ¹gɨ la ca mɨ'³ gacwo¹. Mo ngayuui'¹³ gafaa'²¹ Jesús 'elo joon gasɨɨ'²¹ɨ tsá² coon'¹³ coon²¹ júu³ tá² lɨɨlɨ¹: ―Wa'a sá² loocwoo¹oo', nʉ́ʉ²duu'. ");
INSERT INTO chqNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Joon gaunngɨɨ¹ɨ tsá² tya'a: ―¿'Ee 'øøi'²¹‑tsi tsá² 'e júu³ cwáain¹ tya' jún² do? ");
INSERT INTO chqNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Joon gasɨɨ'²¹ Jesús 'ii: ―Dios ijmáa¹a 'e liñí² 'naa' coon²¹ júu³ 'uuin²¹ tya'a. Coon²¹ júu³ tya' xiiala ityʉ'² Dios to² tsá². Pe 'in catyaai²gɨ fuu²¹²uu coon'¹³ jmai'² júu³ cwáan¹mo. Tsʉ joon mo jǿø² jan²o lawa'a jo jǿø²o. Joongɨ mo ganúu²o ján² lawa'a jo 'ee ga'øøi'²¹‑tsio. ");
INSERT INTO chqNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Joon gajin'² Jesús sɨɨ'²¹ɨ 'ido: ―'Elo‑o 'øøi'²¹‑tsi tsá² 'e júu³ cwáain¹ lo: 'E mɨ'³ jún² do lɨ la lɨ júu³ tya' Dios. ");
INSERT INTO chqNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Joon mo gaxʉʉ'²¹ 'e jún² tya'i fu do 'e gagøø'²¹ ton¹ 'øøi'²¹‑tsi tsá² la lɨ mo ganúu² tsá² júu³ tyʉ́². Joon 'in 'lɨɨi'³ jóo¹o joon tyí²o júu³ tyʉ́² do yʉ tsi alma tya'a. Joon jo lí²‑in litsáai¹‑tsi 'e tiin'¹³in. ");
INSERT INTO chqNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Joon mo gaxʉʉ'²¹ jún² do jee²¹² cuun²¹² 'øøi'²¹‑tsi tsá² lɨ la lɨ mo ganúu² tsá² júu² tyʉ́². Yaa¹mo‑tsi ga'ii'²¹i 'e júu³ tyʉ́² do. Pe mi tɨ 'ii'²¹ iníi²in wúu¹ 'wii'¹³ tya' 'e júu³ do ilicoon'²¹on. Lɨ́ɨi¹ la lɨ coon²¹ sa'³ 'mó² 'e jo jmóo³ 'láai² sá². Jo ta'²¹a. ");
INSERT INTO chqNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Mo gaxʉʉ'²¹ 'e mɨ'³ jún² jee²¹² tóon¹ do 'øøi'²¹‑tsi lawa'a mo ganúu² tsá² júu³ tyʉ́². Nuu¹o pe ngalíin²mo jiin'¹³ la fu¹ taai². Jiin'¹³ la gajgoo'²¹ 'e sa'³ do jee²¹² tóon¹ do lawa la joon jon jileei'²¹ 'in ngɨ́¹ cu'²‑tsi coon'¹³ jilaa'²¹ 'e tyíin² coon'¹³ jilaa'²¹ 'e tyʉ́² seein²¹. Jo 'ee garoo²¹ mi'³ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Joon mo gaxʉʉ'²¹ jún² do jee²¹² cwoo'¹³ 'oo'³ 'øøi'²¹‑tsi tsá² mo ganúu² tsá² júu³ tyʉ́² do. Nuu¹o joon cón²o cwáain¹ 'e júu³ tyʉ́² do. Joon jmoo¹‑o taa'²¹a. Joon 'e la joon garoo²¹ 'láai²gɨ. ");
INSERT INTO chqNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Jin'²gɨ Jesús: ―Ce jiin'¹³ jaain²¹ jo 'iin dyi'² coon²¹ jɨ́² joon mi yuui'¹³ joon jlɨɨ²¹ sɨ sii'²¹i nʉ' coo'mó² 'ee. Mo dyi'² tsá² jɨ́² lɨ' yʉ'ʉ sii'²¹ tsá² joon jnéei² tya' jileei'²¹ 'in tsá² taai²¹². ");
INSERT INTO chqNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ce jiin'¹³ coon²¹ 'e sɨ'mo² jo lí² wa'a jo lí² jneei¹. Jon'gɨ sá² coon²¹ júu³ 'uuin²¹ wa'a 'e jo liñi¹ tsá². Joon nilisá² júu³. ");
INSERT INTO chqNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’La joon nʉ́ʉ²duu' tyʉ́² tsʉ jileei'²¹ 'in 'ii'²¹mo júu³ tyʉ́² do cwo² Dios 'e 'øøi'²¹‑tsi tyʉ́²gɨ. Pe jileei'²¹ 'in jo 'ii'²¹ 'e júu³ tyʉ́² do cwo² Dios 'e jo 'øøi'²¹‑tsi coonti. ");
INSERT INTO chqNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Joon gatyalíin² ruu'²¹i Jesús coon'¹³ sáa³a lɨ siin'¹² Jesús. Pe jo lí² tsatyéein¹ tyan'¹ tsʉ lɨ́ɨ¹ fúui¹ tsá² taai²¹². ");
INSERT INTO chqNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Pe 'in lɨ́ɨi¹³ tsá² gasɨɨ'²¹o Jesús: ―Saa²'a coon'¹³ ruu'²¹'u téein² caluu. Joon 'iin²¹²in jǿøi² 'nʉ. ");
INSERT INTO chqNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Pe joon gajin'² Jesús: ―Jileei'²¹ 'in nuu¹ júu³ tyʉ́² tya' Dios joongɨ cón²du cwáain¹ coon'²¹ tún² 'ii sáa³aa joongɨ 'ii ruu'²¹na. ");
INSERT INTO chqNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Coon²¹ jmɨɨ²¹² galɨ́² nga'í² Jesús tsi coon barco coon'¹³ tsá² tya'a. Joon gasɨɨ'²¹ɨ: ―Tsaa²¹a' lɨ' tɨ cataain² tyíia¹ no. Joon ngalíin²mo. ");
INSERT INTO chqNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Joon la 'ɨɨ²¹² ngalíin² ni jmɨɨ²¹ do‑o gacwuu²¹mo Jesús. Joon galɨ́² lɨ ngalíin² do ga'ɨ́ɨ² coon²¹ tyí² tá² lɨ' 'e ni jmɨɨ²¹ do. Joon ga'láa¹ 'wii²¹² garǿ¹mo jmɨɨ²¹ tsi barco do. Joon ga'íi¹ fo'²‑tsi lɨ táai² do itá². ");
INSERT INTO chqNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Joon ngalíin² gaunjnaa¹‑tsi Jesús. Joon gasɨɨ'²¹ɨ Jesús: ―¡Tɨfo'²! ¡Tɨfo'²! ¡Nitee²mo'! Joon garóon² Jesús. Joon ga'woo¹ 'e tyí² do coon'¹³ 'e jnóo¹ jmɨɨ²¹ do coon'¹³ júu³ tya'a. Joon coon²¹ ga'ɨ́ɨ² tii². ");
INSERT INTO chqNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Joon gajin'² Jesús gasɨɨ'²¹ɨ tsá² tya'a: ―¿'Ee lɨ' jo tsáai¹‑'oo'? Pe 'ido‑gɨ gafoo'²¹mo. Joon tsa'goo²¹‑tsi. Joon gaunngɨɨ¹ɨ ruu'²¹i la jaain²¹ la jaain²¹: ―¿'Iin 'in tsañʉʉ'¹ lo 'e tyʉ'²o to² tyí² coon'¹³ jmɨɨ²¹² joon nʉʉ'¹³o? ");
INSERT INTO chqNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Pe gatyalíin²mo fu cwoo'¹³ sii²¹ Gadara. 'E náa¹ lɨ' ngoo'¹³ tyíia¹ do tyani Galilea. ");
INSERT INTO chqNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Mo gacwo'ɨ́ɨ¹ Jesús fu tsi barco do gangatyéein¹ jaain²¹ tsañʉʉ'¹ seein¹ fuu²¹ do. Lɨɨ²¹² 'áai¹ ningóo¹ 'in tsañʉʉ'¹ do 'yuui jaain²¹ 'in 'lɨɨi'³ alma tya'a. Jo tyi'²gɨ 'mɨ'². Jon'gɨ jon¹gɨ inʉʉ. Jee²¹² 'aan¹ tya' 'lɨɨ²¹² joon¹on. ");
INSERT INTO chqNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Mo ganii¹in Jesús joon gasii'²¹i 'wojníi¹i tyani Jesús. Joon ga'oo¹o jin'²in: ―¿'Ee jmaa²'a tyiia, Jesús? Jóon¹ Dios 'in ñíi¹mo 'nʉ. Mɨ́³ɨɨ tyaní²'i 'e jo 'e'²'e wúu¹ jna. ");
INSERT INTO chqNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","La lo‑o gajin'²in tsʉ 'wii'¹³ Jesús nigatyʉ'²ʉ to² 'in espíritu taai² alma tya' 'ido 'e 'woo²¹mo. Lɨ́ɨ¹ 'láai² fu 'in espíritu gó² do nigasaan'¹in 'in tsá² do. Joon niga'ñʉ́ʉ² tsá² cwoo²¹ tɨɨ². Niga'ñʉ́ʉ² coon'¹³ cadena joon jo laai²¹gɨ. Pe 'gɨɨ¹o cadena do. Joon 'in espíritu gó² taai² jmoo¹o cwiin¹ 'ido tɨ lɨ jo 'in tsá² seein²¹. ");
INSERT INTO chqNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Joon gaunngɨɨ¹ɨ Jesús 'ii: ―¿Xiiala sii²¹ 'nʉ? 'Ido‑gɨ gañii¹i: ―Legión‑mo sii²¹ jna. 'E lo‑o gajin'²in tsʉ 'wii'¹³ lɨ́ɨ¹ fúui¹ espíritu gó² 'in nigataai² alma tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Joon 'in espíritu do gamɨ'²ɨ Jesús 'e jo sii'¹²in 'ii lɨ 'lɨɨ'³. ");
INSERT INTO chqNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Joon lɨ́ɨ¹ fúui¹ ñí¹ taai² gø'²ø co'² do. Joon 'in espíritu gó² do gamɨ'²ɨ Jesús 'e cwoo²¹ tsataai² tu'² 'in ñí¹ do. Joon gacwóo¹o Jesús 'ii'²¹. ");
INSERT INTO chqNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Joon 'in espíritu do ga'woo²¹mo tya' 'in tsañʉʉ'¹ do. Joon ngataai² tu'² 'in ñí¹ do. Joon 'in ñí¹ do gacwiin¹in lɨ sɨjɨ́² joon gapée¹i xuu'²¹i tsi tyíia¹ do. Joon do‑o gajgoo'²¹o jmɨɨ²¹. ");
INSERT INTO chqNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Mo ganí² jileei'²¹ 'in 'aai¹ ñí¹ do jlaa'²¹ 'e galɨ́² gafoo'¹mo 'áai¹ joon gacwiin¹o. Joon gangaliin¹ ngajmaa'¹²a júu³ tsá² fuu²¹ coon'¹³ la caain²¹gɨ lɨ taain²¹² tsá². ");
INSERT INTO chqNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Joon ga'woo²¹mo 'in tsá² seein²¹ do ngajǿø²ø jilaa'²¹ 'e nigalí². Mo gatyalíin² tɨ lɨ siin'¹² Jesús gatsee'²¹mo 'in tsañʉʉ'¹ 'in niga'wooi²¹ espíritu gó² alma tya' 'ido. Tyíin¹³in 'wii²¹² tɨɨ² Jesús. Tyi'²i 'mɨ'² joon niga'ɨ'²ɨ‑tsi. Joon gafo'¹mo 'in tsá² do. ");
INSERT INTO chqNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Joon jileei'²¹ 'in niganí² gatya¹o júu³ xiiala niga'láai² 'in tsañʉʉ'¹ 'yuui 'in 'lɨɨi'³ alma tya' do. ");
INSERT INTO chqNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Coon'¹³ cwáain¹ lo‑o jileei'²¹ tsá² seein²¹ lɨ sii²¹ Gadara do ga'láa² 'wii²¹² mɨɨ¹ɨ tyani Jesús 'e cwo'ɨ́ɨ¹o 'e fuu²¹ do, tsʉ lɨ́ɨ¹ 'goo'²¹o. La joon nga'í² Jesús tsi barco. Joon ganga'²mo. ");
INSERT INTO chqNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","La nʉ'gɨ 'e tsee'²i, 'in tsañʉʉ'¹ 'in ga'wooi²¹ 'in 'lɨɨi'³ alma tya' do gamɨɨ¹ɨ tyani Jesús 'e tse'²mo coon'¹³on. Pe Jesús‑gɨ gatyʉ'²ʉ to² 'e ján²o. Joon gasɨɨ'²¹ɨ 'ido: ");
INSERT INTO chqNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Cweei'¹ fu tyi'i joon cwotya²'a júu³ jilaa'²¹ 'e nigajmaa¹a Dios coon'¹³ 'nʉ. Joon ganga'²mo 'in tsañʉʉ'¹ do. Joon gatya¹o júu³ la jilaa'²¹ 'e nigajmaa¹a Jesús 'wii²¹² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Mo gacɨɨ'¹² Jesús fu 'ngoo'¹³ jmɨɨ²¹ do ga'ii'²¹mo tsá² 'ii jløø'³mo tsʉ jilee'²¹mo sɨjéen¹³in 'ii. ");
INSERT INTO chqNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Joon gacwéi¹ jaain²¹ tsá² sii²¹ Jairo. 'Ii 'in tyʉ'² to² cwo'¹. 'In tsañʉʉ'¹ lo gasii'²¹i 'wojníi¹i 'wii²¹² tɨɨ² Jesús joon gamɨɨ¹ tyani Jesús 'e tsáa¹a fu tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Jaan²¹mo jóon¹ seein²¹ 'in ngóo¹ dyatun¹ jiin'¹. 'In raain¹ tɨ lɨ júun²mo. Mo gangó¹ Jesús lɨ́ɨ¹ fúui¹ tsá² ngalíin² coon'¹³on. 'Áa¹mo cuu'¹² lɨ ngalíin² do. ");
INSERT INTO chqNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Joon jee²¹² 'ii ngóo¹ jaain²¹ tsamɨ́² tsaa'¹³. Ningóo¹ dyatun¹ jiin²¹ 'e niganii²¹ wúu¹ 'áai¹ coon'¹³ 'e jmoowúu¹ tuuin²¹ do. Joon 'áa¹mo niga'íin² cuu² coon'¹³ tɨmɨ́¹. Nigatsaa²¹² jilaa'²¹ 'e 'oo¹o pe jo mo ga'láai². ");
INSERT INTO chqNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Joon gangatyéen¹in lɨ caluu Jesús. Joon gasʉʉ²¹ tɨ' sɨɨn'³ 'ido. Joon la tsifu joon gawuun'¹³mo tuuin²¹. ");
INSERT INTO chqNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Joon gaunngɨɨ¹ɨ Jesús: ―¿'Iin gasʉ́² sɨn'³ɨɨn? Jilee'²¹mo tsá² jo júu³ gatyaa¹a. Joon Tʉ́³ coon'¹³ 'in catyaai²gɨ do gajin'²in: ―Tɨfo'², lɨ́ɨ¹ cuui'²¹ tsá² 'nʉ joongɨ 'lee'¹²i tsá² 'nʉ. Joon unngɨɨ²'ɨ: “¿'Iin gason'¹ tyi'i?” ");
INSERT INTO chqNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Joon gajin'² Jesús: ―Lɨ́ɨ¹³moo la lɨ'ɨ seein²¹ 'in gasʉ́² tyiia tsʉ galili'³oo gaun'láa²moo jaain²¹ tsá² coon'¹³ 'ii'²¹ tyiia. ");
INSERT INTO chqNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Mo galili'³i 'in tsamɨ́² do 'e galili'²i Jesús 'e niga'láa²mo joon gajó² jlee¹i. Joon gasii'²¹i 'wojníi¹i tyani Jesús. Joon gatyaa¹a júu³ tyani jileei'²¹ tsá² do 'ee cwáain¹ nigason'¹on sɨɨn'¹³ɨn joon xiiala niga'láa²mo coon'¹³ jmoowúu¹ 'e tyaan¹. ");
INSERT INTO chqNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Joon gasɨɨ'²¹ Jesús 'ii: ―Niga'láa²mo'o, 'mí², tsʉ 'wii'¹³ nigalitsáa¹mo‑'o'o jna. Jløø'³mo'o icwoo'²mo'o. ");
INSERT INTO chqNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Siin'¹²mogɨ Jesús faa'²¹gɨ mo gatyía¹ jaain²¹ 'in jó¹ fu tya' Jairo, 'in tyʉ'² to² cwo'¹ do. Joon gasɨɨ'²¹ɨ Jairo jin'²in: ―Najuun²¹mo yʉʉn²¹ tyi'i. Jo untyíin²gɨ'ɨ 'in tɨfo'² no. ");
INSERT INTO chqNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Pe ganúu² Jesús joon gajin'²in: ―Jo jmaa²'a 'goo'²¹o canii² jmáa² tsáai¹‑'o'o. Joon i'láa²mo yʉʉn²¹ tyi'i. ");
INSERT INTO chqNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Mo gatyía¹ Jesús 'a inʉʉ do joon jo gacwoo¹ ngatáai² jiin'¹³ jaain²¹ 'in catyáai². Jiin'¹³ Tʉ́³‑ʉ nga'í² coon'¹³ Jacobo coon'¹³ Wó³. Joongɨ jiin'¹³ jmii²¹ 'in yʉʉn²¹ do coon'¹³ jiin'¹³ sáa³o nga'í². ");
INSERT INTO chqNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Jilee'²¹mo tsá² cɨ'²ɨ xuui²¹²‑tsi tya' 'ido. Joon gajin'² Jesús: ―Jo cɨ́²ɨɨ' tsʉ jo mo júuin¹ 'in yʉʉn²¹ no jiin'¹³ lɨ' 'e cwuu²¹mo. ");
INSERT INTO chqNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Pe jmai'² 'in gangɨ́ɨ³ɨ tsʉ ñi¹o 'e najuun²¹mo 'ido. ");
INSERT INTO chqNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Joon gason'¹ Jesús cwoo²¹o tya' 'in najóin¹ do. Joon gafaa'²¹a coon'¹³ coon²¹ júu³ tá² lɨ́², jin'²in: ―Sɨmɨ́², ráan¹un. ");
INSERT INTO chqNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Joon gajiin'¹o 'ido tún¹. Joon la tsifu joon garóon². Joon gatyʉ'² Jesús to² 'in tsá² do 'e cwoo²¹xʉ 'e dø'¹ 'ido. ");
INSERT INTO chqNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Joon lɨ́ɨ¹ tsa'goo²¹‑tsi tsacøøi'¹³ tya'a. Pe joon gatyʉ'² Jesús to² 'e jo 'in sɨɨ'²¹ɨ ce jiin'¹³ jaain²¹ jilaa'²¹ 'e nigalɨ́¹ do. ");
INSERT INTO chqNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesús gauncaain²¹ jɨ dyatuuin¹ tsá² tya'a joon gacwo'²o 'ido 'ii'²¹ to² jmáa¹a 'e 'wooi²¹ 'ido jileei'²¹ nii² espíritu gó² taai² alma tya' tsá² joongɨ un'láai² tsatsaa'¹³: ");
INSERT INTO chqNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","―Sɨ́ɨ³na 'naa', jin'²in, 'e cwolíin²naa cwocwó²oo' tsá² júu³ tyʉ́² tya' xiiala tyʉ'² Dios to² tsá² joongɨ un'láa²naa tsatsaa'¹³. ");
INSERT INTO chqNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Joongɨ sɨɨ'²¹ Jesús 'ii: ―Jo 'ee cón²oon' coonti tya' tya'i fu lɨ cwolíin²naa'. Jo són²oo' 'mo'u² jon'gɨ cón²oon' mora'². Jon'gɨ cón²oon' 'iñi'¹ jon'gɨ cuu² cón²oon'. Tyaan¹aan' jmai'² coon²¹ 'mɨ'² tyí²ii' jo cón²oon' tún². ");
INSERT INTO chqNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Joon jmoo³ joon³ coon²¹ 'nʉ́¹ lɨ tyalíin²naa', do‑o jon²oon' jiin'¹³ la i'woo²¹naa' 'e fuu²¹ do. ");
INSERT INTO chqNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Joon doñixiia' lɨ jo 'iin²¹²in tsá² 'ii'²¹ 'naa' joon xʉ́²ʉʉ' 'laa²¹ toon²¹² tɨ́ɨ¹³ɨɨ' lawa coon²¹ li² 'e jmá²aa' cwáain¹ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Joon ga'woo²¹mo. Joon ngalíin² lacaain²¹ lɨ san'² do ngacwoo¹ júu³ tyʉ́² tya' xiiala tyʉ'² Dios to² tsá². Joongɨ gaun'láai² jileei'²¹ tsatsaa'¹³ 'in seein²¹ lacaain²¹ do. ");
INSERT INTO chqNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Tsaa'to² Herodes mo galiñii¹ jilaa'²¹ 'e jmoo¹o Jesús jiin'¹³ jo ñii¹ 'ee 'ɨ́‑tsi tsʉ 'wii'¹³ 'inlɨ́ɨi¹³ tsá² jin'²in 'e Wó³‑o nigajiin'¹in jee²¹² 'lɨɨ²¹². ");
INSERT INTO chqNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","'Inlɨ́ɨi¹³gɨ tsá² jin'²in 'e nigajnéi¹ jaain²¹ tsá² nigacwo¹ júu³ tyʉ́² sii²¹ Elías. 'Inlɨ́ɨi¹³gɨ jin'²in 'e nigajiin'¹in jaain²¹ tsá² 'in nigacwo¹ júu³ tyʉ́² calɨɨ. ");
INSERT INTO chqNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Pe joon gajin'² Herodes: ―Jna‑a tsai' gatyʉ'³ʉʉ to² gawuun'²¹ mootyi² Wó³. ¿'Iingɨ 'in lo 'in núu³uu faa'²¹ tsá² lɨɨlɨ¹? 'Áai¹ lɨ́ɨ¹ gajóoin²‑tsi Herodes wa'a tyii'¹²a xiiala nii¹in Jesús. ");
INSERT INTO chqNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Mo gatyaliin¹in tsá² tya' Jesús joon gasɨɨ'²¹o jilaa'²¹ 'e nigajmaa¹a. Joon gajée¹i Jesús 'ii 'e gangalíin² coon²¹ co'² fuu²¹ Betsaida. ");
INSERT INTO chqNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Joon mo galiñi¹ tsá² joon ngalíin²mo jon. Joon ga'ii'²¹ Jesús 'ii. Joon gasɨɨ'²¹ɨ 'ido xiiala mo tyʉ'² Dios to² tsá². Joon gaun'láai² tsatsaa'¹³. ");
INSERT INTO chqNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ningóo¹ nica'lóo²xʉ. Joon gangatyéen¹in tsá² tya' Jesús. Joon gasɨɨ'²¹ɨ 'ido: ―'I'² júu³ tsá² 'e cwotyalíin² 'ii'²¹xʉ 'woo'²¹o. Joongɨ tsa'naa'²¹xʉ 'e dø'¹ø 'e lɨ tyan' no tsʉ 'e lɨ toon²¹²on' lo jo 'ee sá² coonti. ");
INSERT INTO chqNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Joon gajin'² Jesús sɨɨ'²¹ɨ 'ido: ―Cwoo'¹³xʉ 'naa' 'ino 'e dø'¹ø. Joon gajin'² tsá² tya'a do: ―Jo 'ee sá² coonti. Lɨ́ɨ²mo jiin'¹³ 'ñá² 'iñi'¹ joongɨ gá¹mo joo'²¹ taai² jmɨɨ²¹. Joon xiiala lí² laa²¹na'a 'e dø'¹ jileei'²¹ 'in tsá² lo. ");
INSERT INTO chqNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Tsʉ tii² la coon'²¹ 'ñá² mil 'in tsá² do. Joon gajin'² Jesús gasɨɨ'²¹ɨ tsá² tya'a: ―Sii'¹³ tsá² cwocwaa¹ tɨ' coon'²¹ 'iin'¹³ ca'no'³ cíein¹³. ");
INSERT INTO chqNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","La joon gajmaa¹a. Gacwó² jilee'²¹mo. ");
INSERT INTO chqNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Joon gason'¹ Jesús jɨ 'ñá² 'iñi'¹ do coon'¹³ 'in gái¹ joo'²¹ taai² jmɨɨ²¹ do. Joon gajǿø² fu yʉ' fu uncwii²¹. Joon gacwo'²o 'maai'¹³ Dios tya' 'e dø'¹ø do. Joon mo ngayuui'¹³ gajmaa¹a 'no'³ joon gacwo'²o tsá² tya'a 'e jmaa¹a jmai'²xʉ jee²¹² tsá² do. ");
INSERT INTO chqNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Jilee'²¹mo tsá² gagøø'²¹ø ce ganeei'¹³ tyʉ́²‑tsi. Joon mo ngayuui'¹³ joon jilaa'²¹ 'no'³ 'e gasái¹ garǿø²mogɨ dyatun¹ 'motó²gɨ. ");
INSERT INTO chqNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Coon²¹ jmɨɨ²¹² mo gafaa'²¹a Jesús júu³ tyʉ́² coon²¹ lɨ yaa‑i joon téen²mo tsá² tya'a coon'¹³on. Joon gaunngɨɨ¹ɨ Jesús: ―¿'Iin jna jin'² tsá²? ");
INSERT INTO chqNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","'Idogɨ gañii¹, jin'²in: ―'Inlɨ́ɨi¹³ tsá² jin'²in 'e 'nʉ‑ʉ Wó³ saai¹ tsá² jmɨɨ²¹. 'Inlɨ́ɨi¹³gɨ tsá² jin'² in 'e 'nʉ‑ʉ Elías. Pe 'inlɨ́ɨi¹³ jin'²in 'e 'nʉ‑ʉ jaain²¹ tsá² 'in nigacwo¹ júu³ tyʉ́² calɨɨ 'in nigajiin'¹ tún¹. ");
INSERT INTO chqNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Joon gaunngɨɨ¹ɨ tún¹ Jesús: ―¿'Naa'gɨɨ', 'ee fó²oo' 'in jna? Joon gañii¹ Tʉ́³ do jin'²in: ―'Nʉ‑ʉ Cristo Jóon¹ Dios. ");
INSERT INTO chqNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pe Jesús lɨ́ɨ¹ ga'ɨɨ¹ júu³ joongɨ gauntsaa'¹²i 'e jo 'in sɨɨ'²¹ tsá² tya'a 'elo ce jiin'¹³ jaain²¹. ");
INSERT INTO chqNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Joon gajin'²in: ―'In Tsá² Ruu'²¹mo tsá² noogɨ iní² wúu¹ lɨɨlɨ¹. Joongɨ jo i'ii'²¹ tsacøøi'¹³ 'ii. Caan²¹mo coon'¹³ 'in tyʉ'² to² tya' untsá² coon'¹³ tɨfo'² tya' ley ijaan'²¹in injnga'²mo 'i. Pe mo tɨ 'nɨ¹ jmɨɨ²¹² ijmáa¹a jiin'¹o tún¹. ");
INSERT INTO chqNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Mo ngayuui'¹³ joon gasɨɨ'²¹ɨ jileei'²¹: ―Wana 'in 'iin²¹²in jó¹ coon'¹³ jna cwojmaa¹a 'íin²‑tsi jilaa'²¹ 'e 'oo¹o. 'Ná²‑a cwotyaan¹an crúu¹³ tya'a la coon²¹ jmɨɨ²¹² joon cwojaa¹ coon'¹³ jna. ");
INSERT INTO chqNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Tsʉ jileei'²¹ 'in 'iin²¹²in lái¹ yaai icaa²¹mo fu juncwii²¹ tya'a. Pe jileei'²¹ 'in caai²¹ fu juncwii²¹ tya' 'wii²¹² tyiia 'in tiin'¹³mo 'ii. ");
INSERT INTO chqNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Jo 'ee to² 'íi³ tya' tsá² wa'a 'e galɨ́² tya'a la tǿøi² fu juncwii²¹ joon caa²¹mo fu juncwii²¹ tya'a 'ña'a. ");
INSERT INTO chqNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Tsʉ wana 'in ga'aa¹ fa'ɨɨ'²¹ 'wii²¹² tyiia coon'¹³ jilaa'²¹ júu³ tya' xiiala mo tyʉ'² Dios to² la joon jon jna, 'in Ruu'²¹na Tsá², ni 'aa²¹oo fa'ɨɨ'²¹ 'wii²¹² tya'a mi yíi³aa lawa Rǿøi¹³ coon'¹³ 'ii'²¹ tya' Ña'ñʉ'¹ʉ' coon'¹³ jileei'²¹ ángeles tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","'E la ja'²mo fuu²¹²uu 'naa' 'inlɨ́ɨi¹³ jee²¹² 'in téein² lo nano jo ijúun²in nʉ'gɨ la jo mo gatyʉ'² Dios to² tsá². ");
INSERT INTO chqNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Mo gatɨ́² jñá² jmɨɨ²¹² 'e gafaa'²¹ Jesús 'elo joon gasoo¹o coon²¹ moo'²¹ 'e tsafaa'¹²a júu³ tyʉ́². Ngoo²¹‑o coon'¹³ Tʉ́³ coon'¹³ Jacobo coon'¹³ Wó³. ");
INSERT INTO chqNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Joon la 'ɨɨ²¹² faa'²¹ Jesús júu³ tyʉ́² la tøøi² níi¹i coonti coon²¹ galɨsɨ́ɨ²mo la 'ɨɨ¹. Joongɨ sɨɨn'¹³ɨn galɨ taa²¹ jɨɨ'¹ lɨɨlɨ¹. ");
INSERT INTO chqNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Joon gajnéi¹ gái¹ tsañʉʉ'¹ co' lɨ siin'¹²in. Gajná² joo'²¹ la 'ui lɨ siin'¹³in. Jaain²¹ sii²¹ Moisés, jaain²¹gɨ sii²¹ Elías. ");
INSERT INTO chqNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Téein² coon'¹³ Jesús sɨ́ɨ¹i xiiala mi jóon²in. 'E 'ná² nii²¹ wúu¹ fu Jerusalén. ");
INSERT INTO chqNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Lɨ́ɨ¹ jalicwuu¹i Tʉ́³ coon'¹³ 'in tsá² catyaai²¹gɨ do. Pe jo gacwuu²¹i. Joon ganii²¹o jilaa'²¹ 'e 'ya'²gɨ tya' Jesús. Joon ganíi²in jɨ gái¹ tsañʉʉ'¹ do 'in téein² coon'¹³on. ");
INSERT INTO chqNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Mo gangalíin² 'in tsá² do co' lɨ siin'¹² Jesús joon gajin'² Tʉ́³ do: ―Tɨfo'², ¡lɨ́ɨ¹ tyʉ́² 'e toon²¹o'on lo! Jmoo²¹o'o 'nɨ¹ 'nʉ́¹ lo; coon²¹ 'nʉ́²'ʉ coongɨ tya' Moisés coongɨ tya' Elías. Pe Tʉ́³ do coonti jo ñi¹ jilaa'²¹ 'e faa'²¹a. ");
INSERT INTO chqNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","La 'ɨɨ²¹² faa'²¹a do‑o gajó² coon²¹ jníi¹ 'e gacɨɨn'¹³in. Joon gafoo'¹mo mo gatáai² jee²¹² jníi¹ do. ");
INSERT INTO chqNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Joon ganuu¹ coon²¹ júu³ jee²¹² jníi¹ do 'e gajin'² 'elo: ―Yʉʉn²¹ tyiia 'in 'iin²¹²na lo. Nʉʉ²ʉʉ' júu³ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Mo ngayuui'¹³ gafaa'²¹a 'e júu³ do joon ganíi²mo jiin'¹³ 'ña'a Jesús. Jo 'ee gajin'²in coonti jon'gɨ gasɨɨ'²¹ɨ tsá² ce jilaa'²¹ 'e niganí²i. ");
INSERT INTO chqNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Mo gajná² jmɨɨ²¹² do coon²¹ gajgáa¹i 'e moo'²¹ do joon lɨ́ɨ¹ fúui¹ tsá² ngaunjiin'²¹in Jesús. ");
INSERT INTO chqNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Joon jaain²¹ tsañʉʉ'¹ 'in ngó¹ jee²¹² tsá² do gasɨɨ'²¹ɨ coon²¹ júu³ tá² lɨ¹, jin'³in: ―Tɨfo'², jmaa²'a feei'¹‑'o'o jøøi²¹²du' yʉʉn²¹ tyiia lo tsʉ camuui'¹³ 'in no seein²¹ tyiia. ");
INSERT INTO chqNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","'Yuui jaain²¹ espíritu gó² 'e jmoo¹ 'e 'oo¹o joongɨ joon²¹in ñii'¹i. Joongɨ 'yee'²¹ jon¹ moo'oo²o. Joongɨ 'e'²e wúu¹. Jo 'iin²¹²in tʉ́ʉ¹i. ");
INSERT INTO chqNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nigamɨ́³oo tyani tsá² tyi'i 'e tyíi²mo 'in 'lɨɨi'³ 'yuui alma tya'a pe jo mo galɨ'²ɨ. ");
INSERT INTO chqNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Joon gajin'² Jesús sɨɨ'²¹ɨ 'in tsá² fúui¹ do: ―¡Tsá² 'in jo tsáai¹‑tsi 'naa'! Jiin'¹³ 'e gó² 'øøi'²¹‑'oo'. Jo ní³ii lɨɨ'²¹ 'e 'ná²‑a 'e siin'¹³na coon'¹³ 'naa' joongɨ jmáa³aa taa'²¹a 'wii²¹² tyii'. Joon jin'² Jesús sɨɨ'²¹ɨ jmii²¹ xuui²¹² do: ―Ñijee¹du' yʉʉn²¹ tyi'i fu lo. ");
INSERT INTO chqNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Pe mo gangatyéen¹ 'in sɨmii'²¹ do 'in espíritu gó² do gapíin² 'ii ni 'wó². Gajmaa¹a 'e gajooin²¹ ñii'¹i 'ido tún¹. Pe Jesús gatyʉ'² to² 'in espíritu do wa'a cwo'ɨ́ɨ¹ɨ. Joon gaun'láa²mo 'in sɨmii'²¹ do. Joon gajaan'¹mo 'ido jmii²¹. ");
INSERT INTO chqNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Jilee'²¹mo tsá² ganga'goo²¹‑tsi jilaa'²¹ 'e jmɨɨ²¹² cɨɨ'¹³ Dios jmaa¹a. La 'ɨɨ²¹² jmoo¹o tsa'goo²¹‑tsi tsá² coon'¹³ jilaa'²¹ 'e faa'²¹ Jesús joon gasɨɨ'²¹ɨ Jesús tsá² tya'a: ");
INSERT INTO chqNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Nʉ́ʉ²duu' coon'²¹ tún² 'elo. Joon jo cwa'iin'¹³‑'oo'. Jna‑a 'e Ruu'²¹na Tsá². Pe 'ná²‑a ijaain'²¹ tsá² jna ja'cwoo²¹ tsá². ");
INSERT INTO chqNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Pe tsá² tya' Jesús do jo ga'øøi'²¹‑tsi jilaa'²¹ 'e sɨɨ'²¹ɨ 'ii tsʉ jo mo galisá² 'ii'²¹ wa'a 'øøi'²¹‑tsi. Joon 'goo'²¹‑o wa'a mɨɨ'²¹ɨ Jesús wa 'e nijin'²in la lɨ 'e najin'²in. ");
INSERT INTO chqNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Joon tsá² tya'a ga'láa² 'wii²¹² jo cwo'²o júu³ ruu'²¹i 'iin jee²¹² 'ii 'in tyíin¹³gɨ. ");
INSERT INTO chqNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Pe Jesús galili'³o jilaa'²¹ 'e 'ɨ¹‑tsi 'ido. Joon gasaan'¹²in jaain²¹ xuui²¹² joon gasiin'²¹in jee²¹² 'ii. ");
INSERT INTO chqNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Joon gasɨɨ'²¹ɨ 'ido: ―Jileei'²¹ 'in 'ii'²¹ 'in xuui²¹² lo coon'¹³ 'e sii²¹ jna 'ii'²¹mo jon jna. Joon jileei'²¹ 'in 'ii'²¹ jna 'ii'²¹mo jon 'in gasii²¹in jna. Jileei'²¹ 'in 'woi¹gɨ jee²¹² 'naa' 'ii 'in tyíin¹³gɨ la jee²¹² jileei'²¹. ");
INSERT INTO chqNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Joon gajin'² Wó³ gasɨɨ'²¹ɨ Jesús: ―Tɨfo'², nigajøø²¹ø'ø jaain²¹ 'in ngɨ́¹ to² 'wooi¹ espíritu gó² coon'¹³ 'e sii²¹ 'nʉ. Joon gauntsaa'¹³moo'o tsʉ jo ngɨɨ¹ coon'¹³ jna'. ");
INSERT INTO chqNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Joon gajin'² Jesús gasɨɨ'²¹ɨ 'ido: ―Jo untsaa'¹³naa' tsʉ jileei'²¹ 'in jo jmoo¹o 'e gó² tyi' 'ii 'in uncaain²¹ coon'¹³ jna'. ");
INSERT INTO chqNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Mo gatɨ́² li tsei'² Jesús fu ñʉfú² ga'ii²¹o fu¹ tsáa¹a fu Jerusalén tá²‑a taain²‑tsi. ");
INSERT INTO chqNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Joon gasii¹in tsá² tya'a nifugɨ. Joon ngalíin² coon²¹ fuu²¹ 'e náa¹ co' Samaria gamɨɨ¹ɨ lɨ ján². ");
INSERT INTO chqNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pe tsá² seein²¹ Samaria do jo ga'ii'²¹i Jesús tsʉ galili'³o 'e tsáa¹ 'ido fu Jerusalén. ");
INSERT INTO chqNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Mo ganí² tsá² tya'a Jacobo coon'¹³ Wó³ 'elo joon gasɨɨ'²¹ɨ: ―Ña'ñʉ'¹ʉ', ¿ja 'iin²¹²u'un wa'a siin²¹na'a júu³ 'e xii¹a goon²¹ po'³ jɨ́² fu yʉ' fu juncwii² tya'a? Joon ityee²¹mo coon'²¹ tya' jilee'²¹i 'in tsá² no la gajmaa¹a jaain²¹ tsá² 'in gacwo¹ júu³ tyʉ́² calɨɨ 'in sii²¹ Elías. ");
INSERT INTO chqNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Joon gajǿøi² Jesús 'ii joon gajin'²in: ―'Naa'a jo ñí²ii' coonti xiiala lɨ́ɨi¹ espíritu jeei¹³ 'naa'. ");
INSERT INTO chqNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Jna‑a, 'in Ruu'²¹na Tsá², jo góo³oo wa'a 'e 'iin²¹²na fu juncwii²¹ tya' tsá² xʉlɨ'ɨ jmáa³aa tiin'¹³mo tsá². Joon gangalíin² coon fuu²¹ pi'³ lɨ xiia'. ");
INSERT INTO chqNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Mo gangalíin² fu¹ táai² jaain²¹ tsañʉʉ'¹ nijin'² gasɨɨ'²¹ɨ Jesús: ―'Iin²¹²na ní³ii coon'¹³ 'nʉ doñixiia' ca cwoo'²'o. ");
INSERT INTO chqNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Joon gañii¹ Jesús: ―Jileei'²¹ cwii¹ sá² tóo²‑o tsa' xá² joongɨ jileei'²¹gɨ ton¹ sá² sɨ́ɨ²‑ɨ pe jna‑a Ruu'²¹na Tsá² jo 'óo³oo xiia' lɨ cwuu²¹na. ");
INSERT INTO chqNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Joon gajin'² Jesús gasɨɨ'²¹ɨ jaain²¹gɨ: ―Na¹ coon'¹³ jna. Pe 'idogɨ gajin'²in: ―Cwó³du'u cata ní³ii jéei¹ ni'áai¹duu ñʉ'³ʉʉ. ");
INSERT INTO chqNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Joon gajin'² Jesús: ―Já¹du' cwo'aa¹i 'in jo tsáai¹‑tsi jna 'in 'lɨɨ²¹² do. Pe 'nʉ‑ʉ cwoo²du'u, cwocwo'²'o júu³ tyʉ́² tya' xiiala mi tyʉ'² Dios to² tsá². ");
INSERT INTO chqNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","'In xeei'²¹gɨ gajin'²in: ―Ña'ñʉ'¹ʉ' 'iin²¹²na ní³ii coon'¹³ 'nʉ pe jéei¹ cwoo²du'u ni'i'³ii júu³ tsá² néei¹ inʉʉ tyiia. ");
INSERT INTO chqNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Pe Jesús gajin'²in: ―Tsʉ lawa jaain²¹ tsá² 'in ga'láa² 'wii²¹² núu²un júu³ tya' Dios pe jo gacón² cwáain¹ coon²¹ tún². Jo tɨ́ɨ²i 'ii'²¹ Dios 'ii lɨ tyʉ'² Dios to². ");
INSERT INTO chqNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Mo ngayuui'¹³ jilaa'²¹ 'elo joon gatyiin'¹² Jesús coon²¹gɨ setenta tsá² tún¹. Joon gasii¹in tɨ' gái¹ tɨ' gái¹ tyaníi¹i 'e tsacwoo¹ júu³ tyʉ́² la caain²¹ fuu²¹ lɨ 'ná² tsáa¹a. ");
INSERT INTO chqNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Joon gasɨɨ'²¹ɨ: ―'E la ja'²mo, lɨ́ɨ¹ fúui¹ tsá² seein²¹ 'in 'ná²gɨ núu² júu³ 'e 'iin²¹²mo Dios tsá². Pe xʉ tsá² seein²¹ 'e lí² tsalíin² tsajmáa² júu³. 'Wii'¹³ joon mɨ́²ɨɨ' tyani Dios 'in 'iin²¹²in tsá² wa'a sín¹gɨ tsá² 'in cwó¹gɨ 'e júu³ lo. ");
INSERT INTO chqNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Cwolíin²naa'. Tyán²aan' cwáain¹ tsʉ sɨ́ɨ³na 'naa' lawa joo'saa'²¹ yʉʉn²¹ jee²¹² 'yiia'¹ tsiinuu²¹. ");
INSERT INTO chqNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Jo 'ee cón²oon' jon' mora'² jon'gɨ tuloo²¹ taa'¹³ cuu² jon'gɨ mɨ́ɨ¹³ɨɨ'. Joon jo un'ɨɨi²¹² yaanaa' foo'¹³naa' tsá² tya'i fu¹. ");
INSERT INTO chqNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Mi cwotaa²¹naa' tsi inʉʉ jée¹ foo'²¹oo' 'in tsá² do: “Mɨɨ²¹ɨ'ɨ tyani Dios 'e uncwaa'³i inʉʉlo.” ");
INSERT INTO chqNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Wana 'in tsá² do røø²¹ 'ii'²¹ tya'a i'ii'²¹mo coon²¹ 'e tyʉ́² la lɨ 'e nuu¹. Wana jo la joon jo tɨ́ɨi² 'e júu³ tyʉ́² do. ");
INSERT INTO chqNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Do‑o jóon¹³oo', dogɨ jon cǿø²øø' joongɨ 'úu²uu' jilaa'²¹ 'e cwoo¹ 'naa' tsʉ jileei'²¹ tsá² 'in jmoo¹o to² tɨ́ɨ²mo 'e 'uun'²¹un dø'¹ø. Jo ngɨ́²ɨɨ' la tyi 'nʉ́¹. ");
INSERT INTO chqNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Wana xiia' fu lɨ gatyalíin²naa' 'ii'²¹ tsá² 'naa' cǿ²øø' jilaa'²¹ 'e cwo'²o 'naa'. ");
INSERT INTO chqNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Un'láa²naa' tsatsaa'¹³ 'in seein²¹ do. Joon síi¹³ii': “Tya'an nijó¹ 'e tyʉ'² Dios to² 'naa'.” ");
INSERT INTO chqNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pe wana gatyalíin²naa' coon²¹ fuu²¹ lɨ jo 'ii'²¹i tsá² 'naa' cwo'woo²¹naa' tya'i fu¹ joon fóo¹³oo' la lo: ");
INSERT INTO chqNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Cagɨ 'laa²¹ sá² góo²oo' lo 'e taa'¹³ mɨɨ²¹ɨ'ɨ xʉʉ²ʉ'ʉ lo lawa coon²¹ li² 'e jmoo²¹o'o tya' 'e gó² tyii'. Pe cwoliñí²ii' 'áa¹mo nijatyéen¹in 'e tyʉ'² Dios to² 'naa'.” ");
INSERT INTO chqNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","'E la ja'²mo fuu²¹²uu 'naa' ―jin'² Jesús―, mi 'íin² fu juncwii²¹ lɨ́ɨ¹gɨ wúu¹ iní² 'in tsá² seein²¹ fuu²¹ do lagɨ tya' tsá² seein²¹ fuu²¹ Sodoma. ");
INSERT INTO chqNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","’Fuu²¹²uu 'naa' tsá² néei¹ Corazin. Fuu²¹²uu 'naa' jon tsá² néei¹ Betsaida. Wa'a la caain²¹ fuu²¹ Tiro coon'¹³ Sidón wa galɨ́² coon²¹ milagro 'e nigalɨ́² jee²¹² 'naa' ca la mo jéei¹ la mo 'iin²¹²in unsɨ́ɨi² 'e 'ɨ¹‑tsi. Joongɨ 'e tyii¹ coon²¹ 'mɨ'² lí¹ tyiia²¹² joon ga'ɨ́ɨ²i fó² mootyíi¹i lawa coon²¹ li² 'e gajo'²o‑tsi. ");
INSERT INTO chqNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Pe mi 'íin²in fu juncwii²¹ 'naa'²¹a lɨ́ɨ¹ wúu¹gɨ móo³'naa' lagɨ 'in tsá² néei¹ Tiro coon'¹³ Sidón. ");
INSERT INTO chqNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Joongɨ 'naa'a 'in néei¹ Capernaum, ¿tɨ lɨ́ɨ²naa' isaa'²¹ 'naa' fu 'ñʉ'fú²? Xʉjoon ixaa²¹moo' fu lɨ 'ii²¹. ");
INSERT INTO chqNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jileei'²¹ 'in nuu¹u júu³ tyii' ―jin'² Jesús sɨɨ'²¹ɨ tsá² tya'a―, nuu¹o jon júu³ tyiia. Jileei'²¹ 'in jo 'ii'¹² 'naa' la joon jon jo 'ii'¹i jna. 'In jo 'ii'¹³ jna la joon jon jo 'ii'¹i 'in gasii¹in jna. Joon mi yuui'¹³ gajin'² Jesús 'elo gangalíin²mo tsá² tya'a do. ");
INSERT INTO chqNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Joon gacwolíin²mo 'in setenta tsá² do jløø'³mo jin'²in: ―Ña'ñʉ'¹ʉ', cagɨ espíritu gó² galɨnʉʉ'¹³o to² tyʉʉ'¹³ jna'a coon'¹³ 'e sii²¹ 'nʉ. ");
INSERT INTO chqNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Joon gajin'² Jesús: ―Jo'²o. Gamóo³oo xiiala mo gatøø'²¹i Satanás fu yʉ' fu juncwii²¹ lawa coon²¹ jɨ́² cwaain²¹ 'ñá². ");
INSERT INTO chqNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Jna gacwo'²oo 'naa' 'ii'²¹ 'e 'ǿø¹³øø' moo'woo²¹ mɨɨ'²¹ coon'¹³ tɨcún³ joongɨ ilii'²¹oo' jilaa'²¹ wa' pí³ tya' tsá² 'lɨɨi'³. Joon jo tɨ́² 'nii'²¹ tyii'. ");
INSERT INTO chqNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Mo tyʉ́'²ʉʉ' to² 'in 'wói¹ 'in 'lɨɨi'³ taai² alma tya'a tsá² joon 'woo²¹mo jon pe jo jmaa²aa' jløø'³naa' 'wii'¹³ joon, pe jmáa²aa' jløø'³naa' tsʉ 'wii'¹³ nigatyii'¹³mo Dios 'naa' 'e cwolíin²naa' ñʉ'fú². ");
INSERT INTO chqNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","La tsifu joon gajmaa¹ 'in Esíritu Tyʉ́² tya' Dios galijløø'³mo Jesús. Joon gajin'²in: ―Cwóo³oo 'maai'¹³ Ña'ñʉ'¹ʉ'. 'Nʉ‑ʉ fii²¹² ni 'wó² joongɨ fu juncwii²¹. Cwóo³oo 'maai'¹³ tsʉ niga'máa²o'o jilaa'²¹ júu³ tyi'i 'e jo ñí² tsá² jmɨɨ¹‑tsi coon'¹³ 'in tsá² 'øøi'²¹‑tsi. Joon niga'ee'¹²o'o tyani tsá² 'woi¹ 'in lɨ́ɨi¹ la lɨ́ɨi¹ xuui²¹² 'in jo mo gauntsáa¹. Tsʉ la joon Ña'ñʉ'¹ʉ' nigali'iin²¹²mo'o. ");
INSERT INTO chqNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","’Ñʉ'²oo nigacwo'²o jna jilaa'²¹. Ce jiin'¹³ jaain²¹ tsá² jo lí² licwii¹in Jóon¹ Dios jiin'¹³ 'ña'a Dios Jmii²¹ cwii¹in 'ii. La joongɨ jon ce jiin'¹³ jaain²¹ jo lí² licwii¹in Dios Jmii²¹ jiin'¹³ 'ña'a Jóon¹on licwii¹in 'i coon'¹³ jileei'²¹ 'in 'iin²¹²in 'in Jóon¹‑o 'e licwii¹in 'ii. ");
INSERT INTO chqNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Joon gajǿøi² Jesús tsá² tya'a. Joon jin'²in gasɨɨ'²¹ɨ 'ido: ―Jløø'³mo ce jileei'²¹ 'in jǿø² jilaa'²¹ coon'¹³ unníi¹i 'e jǿø² 'naa'. ");
INSERT INTO chqNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Tsʉ 'ela ja'²mo fuu²¹²uu 'naa', lɨ́ɨ¹ fúui¹ tsá² 'in gacwo¹ júu³ tyʉ́² calɨɨ coon'¹³ jileei'²¹ rǿøi¹³ nigali'iin²¹²in jǿø² jilaa'²¹ 'e jǿø² 'naa' nano. Pe jo gangoo¹o. Nigali'iin²¹²in núu²un ce jilaa'²¹ 'e núu²uu' nano. Pe jo ganúu²un. ");
INSERT INTO chqNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Joon garoon¹ jaain²¹ tɨfo'² tya' ley. Joon gangasii'¹²i Jesús. 'Iin²¹²in jǿø²do xiiala lɨ́ɨi¹ Jesús. Joon gaunngɨɨ¹ɨ: ―Tɨfo'², ¿'ee 'ná¹ jmáa³aa itiin'¹³na fu juncwii²¹ tyiia? ");
INSERT INTO chqNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Joon gañii¹ Jesús: ―¿'Ee to² tyʉ'² ni jí² tya' ley? ¿Xiiala gafaa'¹²a 'e ley do lɨ́ɨ²u? ");
INSERT INTO chqNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Joon gañii¹i 'in tɨfo'² tya' ley do: ―“Cwoli'née¹mo'o Ña'ñʉ'¹ʉ' Dios tyi'i la tǿøi² alma tyi'i, joongɨ coon'¹³ la tǿøi² 'waa'²¹ pí² tyi'i, joongɨ coon'¹³ la tǿøi² 'e 'ɨ¹‑'o'o. Joongɨ cwoli'née¹mo'o tsagóo²'o lawa'a woo²o'o” ―jin'² tɨfo'² tya' ley do. ");
INSERT INTO chqNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Joon gajin'² Jesús: ―Tyʉ́²‑ʉ nigafaa'¹³'a. Wana gajmaa'¹³'a jilaa'²¹ 'elo tiin'¹³mo'o. ");
INSERT INTO chqNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Pe 'in tɨfo'² tya' ley do 'iin²¹²in untyú¹mo 'ña'a joon gajin'²in gasɨɨ'²¹ɨ Jesús: ―¿'Iin tsagóo³oo? ");
INSERT INTO chqNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Joon gajin'² Jesús: ―Lawa jaain²¹ tsá² gajgáa¹i fu¹ tya'i fu Jerusalén 'e tsáa¹a fu Jericó. Joon gasain'² 'uun²¹ 'ii. Joon ga'uun²¹o ce jilaa'²¹a cagɨ sɨɨn'¹³ɨn. Joongɨ gajmee'²¹i lɨɨlɨ¹ coon²¹ xʉʉ jo gajnga'²mo. ");
INSERT INTO chqNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","La coon²¹ jo ngaa²¹mo joon jaain²¹ untsá² gajgáa¹i 'e fu¹ do‑o jon. Pe mo ganí² 'ido lɨ' tɨ' gangɨ́ɨ¹i. ");
INSERT INTO chqNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","La joon jon jaain²¹gɨ tsá² levita gangɨ́ɨ¹i fu do. Joongɨ coon²¹ tsáa¹ joon gangɨ́ɨ¹i mo ganí²i. ");
INSERT INTO chqNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Pe jaain²¹ tsá² coon²¹ fuu²¹ 'in seein²¹ Samaria 'in gangɨ́ɨ¹i fu do‑o jon. Joon mo ganí² 'ido joon fúu² galɨ́ɨ¹i. ");
INSERT INTO chqNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Joon gangatyéen¹in lɨ ráain² 'in tsañʉʉ'¹ do. Joon gajmaa¹o mɨ́¹ lɨ sɨcwuu'²¹ tya' 'ido. Gasuun²¹ aceite coon'¹³ vino. Joon gapaa'²¹a 'mɨ'² lɨ sɨcwuu'²¹ tya' 'ido. Joon gatyée¹mo 'ido bu'³ tya'a. Joon gangajée¹i 'ido coon²¹ lɨ cwói¹ ján². Joon ga'aa¹i. ");
INSERT INTO chqNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Mo gajná² jmɨɨ²¹² do itsei'² 'in tsá² do joon gatyii²¹xʉ cuu² gacwo'²o fii²¹² 'e 'nʉ́¹ do. Joon gasɨɨ'²¹ɨ 'ido: “Jǿø² 'in tsañʉʉ'¹ no. Jǿø²du' joon wana ga'íin¹gɨ'ɨ cuu² no icɨ́ɨ³oo tyi'i mi lɨ gaa'¹³na.” ");
INSERT INTO chqNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Joon gajin'² Jesús gasɨɨ'²¹ɨ 'in tɨfo'³ tya' ley do: ―¿'Iin lɨ́ɨ²u jee²¹² 'in gaai²¹ do galɨ́ɨ¹i lawa jaain²¹ tsagoo¹o 'in tsañʉʉ'¹ 'in gajmeei'²¹ 'uun²¹ do? ―jin'² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Joon gajin'² tɨfo'² tya' ley do: ―'In tsá² coon²¹ fuu²¹ do 'in fúu² galɨ́ɨ¹i 'in tsá² sɨcwuui'²¹ do. Joon gajin'² Jesús gasɨɨ'²¹ɨ 'ido: ―Ngɨ́², cwajmáa² ce tí² la joon. ");
INSERT INTO chqNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Joon ngoo²¹² Jesús la fu¹ 'yúu²i. Joon gatyíi¹a coon²¹ fuu²¹. Joon do‑o jaain²¹ tsamɨ́² sii²¹ Marta gatǿø¹ø fu tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Joon Marta do seein²¹ jaain²¹ ruu'²¹i sii²¹ María. Joon 'ido‑o gacwoo²¹ 'wii²¹² tɨɨ² Jesús 'e 'iin²¹²in núu² jilaa'²¹ 'e jin'² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Pe Marta do lɨ́ɨ¹ cwo'²‑tsi coon'¹³ jilaa'²¹ to² jmoo¹o. Joon gangatyéein¹³ lɨ tyíin¹ Jesús joon gasɨɨ'²¹ɨ: ―Ña'ñʉ'¹ʉ', ¿tɨ jo cu'²xʉ‑'o'o coonti 'in ruu'²¹na no coonti tuui¹ jna 'ñii'a coon'¹³ jilaa'²¹ to² jmóo³oo? Sii'¹³'i cwouncoon'¹³xʉ jna. ");
INSERT INTO chqNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Joon gañii¹ Jesús: ―Marta, ¿'ee lɨ' cu'²‑'o'o coon'¹³ jilaa'²¹ to² 'e jmoo²'o? ");
INSERT INTO chqNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Pe coon²¹ 'e sá² 'e tyiin²gɨ. María lo nigatyii'¹³o coon²¹ 'e tyʉ́²gɨ. Joon ce jiin'¹³ jaain²¹ jo 'in cwooi²¹ tyí² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Cafu mo galɨ́² gafaa'²¹ Jesús júu³ tyʉ́² joon mo ngayuuí'¹³ gafaa'²¹a joon jaain²¹ jee²¹² tsá² tya'a gasɨɨ'²¹ɨ Jesús: ―Ña'ñʉ'¹ʉ', 'e'²'e jna'a xiiala faa'¹³a'a júu³ tyʉ́² la ga'e'² Wó³ tsá² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Joon gajin'² Jesús: ―Mi fó²oo' júu³ tyʉ́² tyii' fá²aa' la lo: Ña'ñʉ'¹ʉ' tyín¹u'un ñʉ'fú² tyi'i. Jiin'¹³ 'nʉ‑ʉ 'in tyúi¹ la jee²¹² jileei'²¹ 'in seein²¹. Tyʉʉ'²¹ to² jna'a. Fu ñʉ'fú² jilaa'²¹ ilɨ́² jiin'¹³ la 'iin²¹²u'un. Jmáa² jon ni cwoo'¹³ juncwii²¹. ");
INSERT INTO chqNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Cwo'³'o jna'a 'e liin¹ 'e tyée³e'e jmɨɨ²¹² no. ");
INSERT INTO chqNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Joon 'íin¹u'un tsaa² tyii'i tsʉ la joon jon jna'a 'íin²moo'o tsaa² tya' jileei'²¹ 'in gajmaa¹a 'e gó² tyii'i. Un'øø¹u'u jna'a 'e jo 'naa'¹³a'a tsaa². ");
INSERT INTO chqNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Gajin'²in jon Jesús gasɨɨ'²¹ɨ 'ido: ―Jmoo'¹³du' cwáain¹ lawa jaain²¹ jee²¹² 'naa' 'in 'aa¹i jaain²¹ tsá² seein²¹ tyʉ́² coon'¹³. Joon la 'woo¹ tyíia² nʉ́ʉ¹ ngóo¹‑o fu tya' 'ido. Joon gasɨɨ'²¹ɨ 'ido: “Jmáa² fee'¹‑'o'o, tyí³ta'a 'nɨ¹ 'iñi¹ 'ná³aa. ");
INSERT INTO chqNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Tsʉ jaain²¹ tsá² seen²'na tyʉ́² coon'¹³ sá² coon²¹ lɨ jaa'¹²i. Joon gacwaa'¹²i fu tyiia joon jo 'ee 'óo³oo coonti wa'a 'e cwo'³oo.” ");
INSERT INTO chqNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Joon 'in dogɨ gajin'²in ca tɨ tsi inʉʉ li raain²¹: “Jo untyíi²u jna tsʉ sɨjnɨɨ¹ 'nʉ́³ʉʉ. Joongɨ yʉʉn²¹ tyiia tee'¹³mo coon'¹³ jna cwuu²¹mo ni coo'mó². Jo lí² raan²¹na wa'a 'e lí² cwo'³oo 'nʉ coonti.” ");
INSERT INTO chqNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","'E la ja'²mo fo'³oo ―jin'² Jesús― fiin'¹³ jo roon¹on 'e cwo'²o 'ido tsʉ 'wii'¹³ tsá² seein²¹ tyʉ́² coon'¹³on do ilí² roon¹on cwo'²xʉ 'ido la coon'²¹ 'e jo untyíi²gɨ 'ido 'ii. Joon cwo'¹o jiin'¹³ 'e 'ná¹xʉ. ");
INSERT INTO chqNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","'E la joon fuu²¹²uu 'naa', mɨ́²ɨɨ' tyani Dios tsʉ joon cwo'²o 'naa'. 'Nee'¹³naa' tsʉ joon tyee'²¹moo'. Pó²oo' 'ooca'nʉ́¹ tsʉ joon inaa²¹o. ");
INSERT INTO chqNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Tsʉ jileei'²¹ 'in mɨ¹ 'ii'²¹mo. Joongɨ jileei'²¹ 'in 'noo'² tyiia'¹³o. Joongɨ jileei'²¹ 'in pó² 'ooca'nʉ́¹ naa²¹o tya' 'i. ");
INSERT INTO chqNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’Jmoo² joon² jaain²¹ 'naa' lɨ́ɨi¹naa' tsacǿøi'¹³, ¿tɨ cwó²oo' yʉʉn²¹ tyii' coon²¹ cuun²¹² wa mo gamɨɨ¹ɨ 'iñi'¹? ¿Tɨ cwoo'¹³naa' jaain²¹ mɨɨ'²¹ wa mo móo¹i joo'²¹ taai² jmɨɨ²¹, ");
INSERT INTO chqNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","owa cwoo'¹³naa' 'ee jaain²¹ tɨcún³ wa mo gamɨɨ¹ɨ coon²¹ mootú²? ");
INSERT INTO chqNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Pe wana 'naa', 'in jo tyú¹naa' cwó²oo' yʉ́ʉn² tyii' 'e tyʉ́² xiiati lɨ́ɨ¹gɨ icwo'²o Ña'ñʉ'¹ʉ' tyíin¹ ñʉ'fú² 'in Espíritu Tyʉ́² tya'a tya' jileei'²¹ 'in mɨ¹. ");
INSERT INTO chqNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Seein²¹ jaain²¹ tsá² 'in ga'í² 'in 'lɨɨi'³ alma tya'a. Joon jo cwo¹ faa'²¹ 'ido. Mo gatyii¹ Jesús 'in 'lɨɨi'³ 'yuui alma tya'a galɨ́²‑ɨ faa'²¹o. Joon lɨɨlɨ¹ ganga'goo²¹‑tsi tsá² 'elo. ");
INSERT INTO chqNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pe 'in lɨ́ɨi¹³gɨ gajin'²in: ―'In tsañʉʉ'¹ lo 'wooi¹ 'in 'lɨɨi'³ coon'¹³ 'ii'²¹ tya' Beelzebú 'in tyʉ'² to² 'ii. ");
INSERT INTO chqNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","'In xeei'²¹gɨ gali'iin²¹²in coon²¹du cwáain¹ xiiala lɨ́ɨi¹ Jesús joon gamɨɨ¹ɨ coon²¹ milagro. ");
INSERT INTO chqNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pe ñii¹ Jesús 'ee 'ɨ¹‑tsi 'in tsá² do. Joon gasɨɨ'²¹ɨ 'ii: ―Lawa coon²¹ fuu²¹ 'e tún² 'ii'¹³ lɨ́ɨi² joon tɨ́ɨ¹i jee²¹² yaa‑i. 'E fuu²¹ do jo taa'²¹a. Joon wana tɨ́ɨi¹ tsá² la 'oo'²¹ ruu'²¹i tsi inʉʉ jo taa'²¹a. ");
INSERT INTO chqNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","¿Xiiala ilí² tyʉ'² Satanás to² wa'a téen¹in jiin'¹³ la 'ña'a? Pe 'naa' fó²oo' 'e 'wóo³na 'in 'lɨɨi'³ coon'¹³ 'ii'²¹ tya' Beelzebú. ");
INSERT INTO chqNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Wana jmáa³aa la joon, ¿'iin coon'²¹ cwo¹ 'ii'²¹ tsagoo²oo' wa'a 'wooi¹ 'ido 'in 'lɨɨi'³ taai² alma tya' tsá²? Coon'¹³ to² 'e jmoo¹ 'ii‑o cwoliñi¹ tsá² 'e lɨ' cɨɨ'¹² fó²oo'. ");
INSERT INTO chqNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Coon'¹³ 'ii'²¹ tya' Dios 'wóo³na espíritu gó² ―jin'² Jesús―, joon coon'¹³ 'e joon 'øøi'²¹‑tsi tsá² 'e nigacwa'¹ 'ii'²¹ tya' Dios jee²¹² 'naa'. ");
INSERT INTO chqNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Lawa jaain²¹ tsañʉʉ'¹ pí²‑tsi joongɨ 'oo¹o ñí³ wa'a un'øøi¹ 'ña'a joon jǿø²o tya'a. Jilaa'²¹ 'e sɨ'móo¹ tya'a jo lí² coon¹ tsá² coonti. ");
INSERT INTO chqNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pe wana tyíia¹ jaain²¹ 'in pí²gɨ‑tsi lagɨ 'ii joon lii'¹i 'ii. Joon 'woo²¹‑o jilaa'²¹ ñí³ tya'a 'e gajmaa¹ 'e jo cu'²‑tsi. Joon gajmaa¹ mai'²xʉ ce jilaa'²¹ 'e ga'wo'²o tya' 'ido. ");
INSERT INTO chqNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Jileei'²¹ 'in jo faa'²¹ tyʉ́² tyiia 'laa'²¹a faa'²¹a tyiia. Joongɨ jileei'²¹ 'in jo jéei¹ tsá² 'e uncaain²¹ coon'¹³ jna jmaa¹a 'e 'eei'¹ tsá² jna. ");
INSERT INTO chqNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Faa'²¹gɨ Jesús jin'²in: ―Mo cwo'ɨ́ɨ¹ espíritu gó² tya' tsá² ngɨ¹o la caain²¹ cwoo'¹³ tyʉʉn²¹ 'noo'²¹o lɨ ján². Joon mo jo tyii'¹a joon 'ɨ¹‑tsi: “Nii'¹³moo fu tyiia lɨ gajúu³uu.” ");
INSERT INTO chqNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Mo gatyee'¹²i joon ní²in 'in tsañʉʉ'¹ do lawa coon²¹ 'nʉ́¹ 'e lɨ́ɨi² joongɨ sii'¹i tyʉ́². ");
INSERT INTO chqNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Joon tsaa²¹o tsate'²e dyái¹gɨ espíritu 'in 'lɨɨi'³gɨ. Joon jilee'²¹mo itsataa²i tya' 'in tsañʉʉ'¹ do. Joon lɨ́ɨ¹ galɨgoo²¹gɨ seein²¹ 'in tsañʉʉ'¹ nano lagɨ mo jéei¹. ");
INSERT INTO chqNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","La 'ɨɨ²¹² siin'¹² Jesús faa'²¹a 'elo jaain²¹ tsamɨ́² jee²¹² 'in tsá² do ga'oo¹o jin'²in: ―¡Lɨ́ɨ¹ tyú¹‑i 'in ningatyéein¹ 'nʉ joongɨ 'in gacwo¹ tʉʉ'²¹ cu'²'u! ");
INSERT INTO chqNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jesús‑gɨ gajin'²in: ―¡Pe lɨ́ɨ¹gɨ tyúi¹ 'in ganúu² joongɨ nʉʉ'¹³o júu³ tya' Dios! ");
INSERT INTO chqNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","La 'ɨɨ²¹² joon lɨ́ɨ¹ ngafúui¹ tsá² la cu'² lɨ' lɨ siin'¹² Jesús joon ga'láa² Jesús 'wii²¹² gafaa'²¹a sɨɨ'²¹ɨ 'ido: ―Tsá² gó² 'in seein²¹ nano mɨɨ¹ɨ coon²¹ li² milagro. Pe jiin'¹³ coon²¹ li² ilisá² tya' 'in tsá² no jiin'¹³ la li² gacwoo¹ jaain²¹ tsá² 'in gacwo¹ júu³ tyʉ́² calɨɨ sii²¹ Jonás. ");
INSERT INTO chqNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Lawa Jonás, 'ii jaain²¹ lawa coon²¹ li² 'e galɨ́² tya' tsá² seein²¹ Nínive. La joongɨ jna 'in Ruu'²¹na Tsá², jna‑a lawa coon²¹ li² tya' tsá² seein²¹ nano. ");
INSERT INTO chqNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Mi 'íin² fu juncwii² ilí² 'ii'²¹ tya' tsá² seein²¹ nano jaain²¹ 'in tyʉ'² to² coon²¹ fuu²¹ náa¹ lɨ' cwoo²¹ tooin²¹² lɨ' yuui'² ñi'¹ niroon²¹ nijmáa¹a 'ii'²¹ tya'a tsʉ 'ii gajó² lɨ wiingɨ ni cwoo'¹³ fu juncwii²¹ 'e janʉ́ʉ²du jilaa'²¹ 'e jmɨɨ¹‑tsi Salomón. Joon 'elo seen²¹mo jaain²¹ 'in feei'¹gɨ lagɨ Salomón. ");
INSERT INTO chqNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Jileei'²¹ tsá² seein²¹ fuu²¹ Nínive do mi 'iin² fu juncwii²¹ niroon²¹ mi jmáa¹ Dios 'ii'²¹ tya' tsá² seein²¹ nano. Joon icwoo¹ tsaa² tya'a. Tsʉ tsá² seein²¹ Nínive do gaunsɨɨ²¹mo 'e 'ɨ¹‑tsi mo ga'ɨ́ɨ² Jonás do júu³ tyʉ́² tya' Dios. Joon nano lo‑o seein²¹ jaain²¹ 'in tyúi¹gɨ lagɨ Jonás. ");
INSERT INTO chqNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’Ce jiin'¹³ jaain²¹ jo 'in dyi'² coon²¹ jɨ́² joon sii'²¹i coon²¹ lɨ 'uuin²¹ jon'gɨ nʉ' coon²¹ cwóo¹. Sii'²¹i tsá² coon²¹ yʉ'‑ʉ joon jnéei² tya' tsá² 'in taai². ");
INSERT INTO chqNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Unni² tsá² 'e lɨ́ lawa coon²¹ jɨ́² coo²¹ tya' tsá² wana tyʉ́² unni² tsá² la joon jon rǿøi³ coon'¹³ 'e tyʉ́² la tǿøi². Joon ngɨɨ¹ lɨ jná². Pe wana gó² unni² tsá² la joon jon gó² la tǿøi². Ngɨɨ¹o lɨ nʉʉ²¹. ");
INSERT INTO chqNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Tɨ́ɨ²mo'o ñí²'i 'e tyʉ́² 'e jo ngɨ́²'ɨ lɨ nʉʉ²¹. ");
INSERT INTO chqNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Wana røø²¹u coon'¹³ 'e jɨ́² do jiin'¹³ capi'² jo 'ii²¹gɨ nʉʉ²¹ la joon jon nijǿø²o'o coon'²¹ tyaa² lawa mo coo²¹ jɨ́² jnéei² tyi'i. ");
INSERT INTO chqNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Mo gatséi¹ gafaa'²¹ Jesús 'elo jaain²¹ tsá² fariseo gatøø¹o Jesús fu tya'a 'e dø'²ø. Ga'í² Jesús joon gacwoo²¹ tɨ' mesa. ");
INSERT INTO chqNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ganga'goo²¹‑tsi tsá² fariseo do mo ganí²i 'e jo gauntiin'¹²in Jesús 'e run'²un cwoo²¹ jiin'¹³ la tɨɨsi'² la nʉ'gɨ dø'²ø. ");
INSERT INTO chqNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Pe joon gajin'² Jesús: ―'Naa', tsá² fariseo, ruun'¹³naa' jiin'¹³ lɨ' caluu coon²¹ vaso coon'¹³ wúun¹ pe 'naa'gɨɨ' lɨ' tsi sɨrøø²¹moo' coon'¹³ jilaa'²¹ 'e niga'uun²¹²uun' joongɨ coon'¹³ jilaa'²¹ 'e nigatyáa²aa' coon'¹³ 'e gó². ");
INSERT INTO chqNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Tsá² bón¹ 'naa'! ¿Tɨ jo ñí²ii' 'in gajmaa¹ lɨ' caluu 'ii‑gɨ jon gajmaa¹ lɨ' tsi? ");
INSERT INTO chqNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","La joon cwoo²¹xʉʉ' tsá² tañíi² 'e dø'²ø 'uunñi² tyii' la joon jilaa'²¹a nilí² tyʉ́² tyii'. ");
INSERT INTO chqNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’Fúu² 'naa' tsá² fariseo, cwo'²naa' Dios diesmo tya' jilaa'²¹ 'oosee²¹² coon'¹³ jilaa'²¹ 'oo² ruda coon'¹³ jilaa'²¹ nii²gɨ 'oonuu²¹, pe coonti jo unjíi² 'naa' 'e jmaa²aa' 'e tyʉ́² tya' tsá² jon'gɨ 'iin²¹²naa' Dios. 'Elo‑ogɨ 'ná¹ jmaa²aa' la jéei¹gɨ. Pe la joon jon jo 'íin²‑'oo' 'e jmaa²aa' 'e xiia'²¹gɨ do. ");
INSERT INTO chqNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’¡Fúu² 'naa' tsá² fariseo, 'iin²¹²naa' ní²ii' lɨ tɨ́ɨi² cwa² 'in tyíin²mo inʉʉ cwo'¹ tyii' sii²¹ sinagogas! Joongɨ 'iin²¹²naa' 'e li'gøø'²mo tsá² 'naa' mo ngɨ́²ɨɨ' jee²¹² 'nʉ́¹. ");
INSERT INTO chqNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’¡Fúu² 'naa' tɨfo'² tya' ley coon'¹³ 'naa' tsá² fariseo! Lɨ' cɨɨ'¹²ɨ jmoo²oo' 'e 'é²ee' tsá² no. Lɨ́ɨ¹naa' la lɨ 'e 'aan¹ roon¹ jo jnée³in do‑o. Jilee'²¹mo tsá² ngɨ́ɨ¹mo lɨ ni do‑o mo jo li'²i. ");
INSERT INTO chqNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Joon gañii¹i jaain²¹ tɨfo'² tya' ley jin'²in: ―Tɨfo'², jilaa'²¹ 'e fó²'o no lawa'a 'e fu'²'u jna'oo'o. ");
INSERT INTO chqNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Joon gajin'² Jesús: ―¡Fúu² 'naa' jon tɨfo'² tya' ley! Coon'¹³ tɨɨsi'² tyii' cwó²oo' tsá² coon²¹ laa²¹² 'e jo roon'²¹ jiin'¹³ jaain²¹. Joon jogɨ 'iin²¹²naa' uncóon¹³oon' jiin'¹³xʉ. ");
INSERT INTO chqNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’¡Fúu² 'naa', jmoo'²¹oon' ni'aan¹ tya' tsá² 'in nigacwo² júu³ tyʉ́² calɨɨ 'in nigangaai'¹² 'lɨɨ²¹² tsacøøi'¹³ tyii' calɨɨ! ");
INSERT INTO chqNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","La no‑o 'øøi'²¹‑tsi 'e røø²¹ sɨ́ɨ¹³naa' coon'¹³ 'e gajmaa¹ 'lɨɨ²¹² tsacøøi'¹³ tyii'. 'Ii‑o nigajngaa'¹²i joon 'naa'gɨɨ' jmoo'²¹oo' ni'aan¹ tya'o. ");
INSERT INTO chqNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Joon ñí² Dios mo nigajin'²in: “Sɨ́ɨ³na tsá² cwo² júu³ tyʉ́² tyiia coon'¹³ 'in lɨ́ɨi¹³gɨ tsá² tya'a joon 'in lɨ́ɨi¹³ ijnga'²mo 'in lɨ́ɨi¹³gɨ 'ǿø¹mo.” ");
INSERT INTO chqNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","'Wii'¹³ joon tsá² seein²¹ nano nityii²¹o cwáain¹ tya' tsá² 'in nigacwó² júu³ tyʉ́² tya' Dios 'in nigajúin¹ ca mo nigaroon¹ cwoo'¹³ juncwii²¹. ");
INSERT INTO chqNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ityi² jmɨ¹ 'øøi² ca Abel joongɨ ca tɨ́² Zacarías 'in nigajngaa'¹³i 'oo² cwo'¹ do. 'Wii'¹³ joon fo'³oo icoon¹ Dios cwáain¹ tya' 'in nigajúin¹ la joon 'in seein² nano icoon¹ cwáain¹ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’¡Fúu² 'naa' tɨfo'² tya' ley! Tsʉ ñí² 'naa' xiiala li cwii¹in tsá² Dios pe yaaigɨɨ' jo mo jmaa²aa' jogɨ cwó²oo' 'e licwii¹in 'in xeei'²¹ Dios. ");
INSERT INTO chqNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Mo gasɨɨ'²¹ Jesús 'ii 'elo 'in tɨfo'² tya' ley do coon'¹³ tsá² fariseo lɨ́ɨ¹ gatɨ́² 'nii'²¹‑tsi 'ido tya'a. Joon ga'láa² 'wii²¹² gauntyíi² coon'¹³ júu³ 'láai² lɨɨlɨ¹. ");
INSERT INTO chqNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Coon²¹ cwáain¹ wa'a isá² coon²¹ júu³ 'e xiiala i'nɨɨ¹ ni do. ");
INSERT INTO chqNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","La jee²¹² joon galicaain²¹ tsá² fúui¹ lɨɨlɨ¹ ca 'øøi'²¹ tsaruu'²¹i la jaain²¹ la jaain²¹. Joon ga'láa² Jesús 'wii²¹² sɨɨ'²¹ɨ tsá² tya'a: ―Lii'³ jmaa²aa' coon'²¹ tún² 'e 'ɨ¹‑tsi tsá² fariseo no. Jmoo¹‑o lawa 'in tyú¹mo 'ii. ");
INSERT INTO chqNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Tsʉ jiin'¹³ coon²¹ júu³ 'uuin²¹ 'e sá² wa'a jo liñi¹ tsa². Jon'gɨ jiin'¹³ coon²¹ 'e sɨ'mó¹ wa'a jo li sá² júu³. ");
INSERT INTO chqNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Joongɨ la joon jon wa'a 'e nifaa'²¹ tsá² linʉʉ²¹ inʉʉ joon lijmɨɨ²¹². Joongɨ jilaa'²¹ 'e sɨ́ɨi¹ tsá² 'uuin²¹ 'e jni¹ 'nʉ́¹ inúu² cayʉ' 'nʉ́¹. ");
INSERT INTO chqNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Faa'²¹gɨ Jesús: ―La lo‑o fuu²¹²uu 'naa' 'wii'¹³ tyʉ́²‑ʉ seen²¹na coon'¹³ 'naa'. Jo foo'¹³naa' 'in jngaai'¹³ tsá² pe mi yʉʉi'¹³ joon jo 'e sá²gɨ jmáa¹a. ");
INSERT INTO chqNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Fuu²¹²oo 'naa' 'in cwooi¹ jmaa²aa' 'gøø'²¹naa'. Jmaa²oo' 'gøø'²¹naa' 'in mi yuui'¹³ jngai'² tsá² tyʉ'²o jon to² 'e tsalíin² lɨ 'lɨɨ'³. Jmaa²oo' 'gøø'²¹naa' 'ii. ");
INSERT INTO chqNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’¿Tɨ jo 'nɨɨi¹ tsá² 'ñeei² tón¹ coon'¹³ jee²¹² tún² wi'³? Pe Dios‑gɨ jo 'íin²‑tsi ce jiin'¹³ jaain²¹ tón¹ do. ");
INSERT INTO chqNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ca jilaa'²¹ jñʉ́² tsí³ mootyí²ii' nigaun'ii²¹ Dios la ca mɨ'³ la ca mɨ'³‑ɨ. Jo jmaa²aa' 'goo'²¹ tsʉ tyíin¹gɨ 'naa'a lagɨ tón¹ fúui¹gɨ. Faa'²¹gɨ Jesús: ");
INSERT INTO chqNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","―'E fuu²¹²uu 'naa', jileei'²¹ 'in jin'²in 'iin jna tyani tsá², jna‑a jon, 'in Ruu'²¹na Tsá², ifo'³oo jon 'e cwii¹na 'ii tyani ángeles tya' Dios Jmii²¹. ");
INSERT INTO chqNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pe jileei'²¹ 'in jo røøi²¹ cwii¹in jna tyani tsá² la joon jon jna jo rǿø¹na 'ii tyani ángeles tya' Dios. ");
INSERT INTO chqNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Doñi'iin 'in gafaa'²¹a 'laa'²¹ tyiia 'e Ruu'²¹na Tsá², lí²‑i 'íin²mo tsaa² do tya'a pe jileei'²¹ 'in faa'²¹ júu³ 'laa'²¹ tya' 'in Espíritu Tyʉ́² tya' Dios jo lí² 'íin²gɨ 'e tsaa² do tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Mi tsajéei¹³ tsá² 'naa' inʉʉ cwo'¹ sɨ tyani 'in jmoo¹ 'ii'²¹ 'ee sɨ tyani tsaa'to² 'ee jo cuu'¹³‑'oo' xiiala ifó²oo' sɨ xiiala ingɨ́²ɨɨ' 'ee. ");
INSERT INTO chqNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Mi tɨ́² 'ii'²¹ joon i'ee²¹² 'in Espíritu Tyʉ́² tya' Dios 'naa' xiiala 'ná² fó²oo'. ");
INSERT INTO chqNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Jaain²¹ jee²¹² tsá² do gasɨɨ'²¹ɨ Jesús: ―Tɨfo'², sii'¹³ ruu'²¹na cwocwoo¹‑o jiin'¹³ tyíia³ 'e gatɨ́ɨ²na. ");
INSERT INTO chqNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Joon gajin'² Jesús sɨɨ'²¹ɨ 'ido: ―Tsañʉʉ'¹, ¿'iin gajin'² 'e lɨ́ɨ¹na tsaa'to² sɨ 'in jmoo¹ jmai'xʉ jee²¹² 'naa' 'ee? ");
INSERT INTO chqNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Gajin'²o jon: ―Tyaan²duu' cwáain¹ joongɨ un'øøi'¹³ yaanaa' wana caníi² 'iin²¹²naa' cuu² tsʉ fu juncwii²¹ tya' tsá² jon' wa'a jilaa'²¹ 'e 'oo¹ tsá². ");
INSERT INTO chqNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Joon gasɨɨ'²¹ɨ 'e cwáain¹ lo: ―Galiseein²¹ jaain²¹ tsá² sá² cuu². Joon cwoo'¹³ 'wó² tya'a lɨ́ɨ¹ 'láai² garoo²¹ 'e gajñii²¹ do. ");
INSERT INTO chqNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Joon 'in tsá² sá² cuu² do ga'ɨ¹‑tsi: “¿'Ee ijmáa³aa coon'¹³ jilaa'²¹ 'e garoo²¹ tyiia lo? Jo 'óo³gɨɨ xiia' lɨ to'³oo.” ");
INSERT INTO chqNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Joon ga'ɨ¹‑tsi jin'²in: “Liñí³oo xiiala ijmáa³aa. Cɨɨ'¹³moo jilaa'²¹ 'nʉ́³ʉʉ lo. Joon ijmaa'¹³aa 'e fee'¹gɨ. Joon do‑o i'máa³aa jilaa'²¹ 'e roo²¹ tyiia coon'¹³ jilaa'²¹ 'e 'óo³oo. ");
INSERT INTO chqNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Joon ifuu²¹²uu 'ñii'a: Alma tyiia, cwo'i'²i 'woo'²¹o tsʉ 'láa²mo 'e nisɨ'mo²'o. Taa'²¹o tya' 'láa²mo jiin²¹. 'Iin'²¹in, tyee'²¹. Unjløøi'³ 'wo'o.” ");
INSERT INTO chqNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Pe Dios gasɨɨ'²¹ 'ii: “Tsañʉʉ'¹, 'in jo 'øøi'²¹‑tsi 'nʉ. Nano‑o ijuun²¹mo'o. Joon jilaa'²¹ 'e 'oo²o'o, ¿'iin lí² tya'?” ");
INSERT INTO chqNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","La joon tsangɨɨ¹i 'in tsá² 'in 'iin²¹² 'e sá² tya' 'ña'a 'láai¹ lɨɨlɨ¹ pe joon tañíi²mo tyani Dios 'i ―jin'² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Mo ngayuui'¹³ joon²¹ gasɨɨ'²¹ Jesús tsá² tya'a: ―'E joon fuu²¹²uu 'naa'. Jo cuu'¹³‑'oo' coon'¹³ jilaa'²¹ 'e cøø²øø' taa²¹²naa' fu juncwii²¹ jon'gɨ coon'¹³ sɨɨn'²ɨɨn' 'e cɨɨ²ɨɨ'. ");
INSERT INTO chqNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Fu juncwii²¹ tya' tsá² 'e tyiin²gɨ lagɨ 'e dø'² tsá². Joongɨ 'e cuerpo tya' tsá² tyiin²gɨ lagɨ sɨɨn'³ tsá² 'e tyi'²i. ");
INSERT INTO chqNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Tyaan²duu' cwáain¹ lawa jaain²¹ tyalaa'²¹ jo jñii¹i jon'gɨ roo¹ tya'a jon'gɨ 'oo¹ lɨ' 'má¹ jon'gɨ tyʉʉ²¹ sá² lɨ to'²o. Pe Dios cwoo¹ 'e gø'²ø. Joon 'naa', tyiin²gɨ 'naa' lagɨ ton¹. ");
INSERT INTO chqNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿'Iin jee²¹² 'naa' 'e 'áai¹gɨ cu'²‑tsi gajmeei¹ 'ña'a coon²¹ ñii²gɨ coon'¹³ 'e cu'²‑tsi do? ");
INSERT INTO chqNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Wa jo lí² jmaa²aa' ce jiin'¹³ 'e xʉgɨ coon'¹³ 'e cu'²‑'oo', ¿'ee lɨ' cu'²‑'oo' coon'¹³ jilaa'²¹ 'e fee'¹gɨ? ");
INSERT INTO chqNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Tyaan²duu' cwáain¹ xiiala cwáain¹ lí³ 'e jo 'ee to¹ jmoo¹o. 'E la ja'²mo fuu²¹²uu 'naa', ca 'lɨɨ²¹² rǿøi¹³ Salomón jo galisá² sɨɨn'³ 'e 'ya'²gɨ tya'a lagɨ 'e lí³ do. ");
INSERT INTO chqNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Wana ijmá¹ Dios 'e 'ya'²gɨ 'oonuu²¹ 'e sá² nano jee²¹² tyiia²¹ joongɨ mi jná² tsa'oo²¹ ijún² coon'¹³ jɨ́² 'e ja'²mo ityi'² Dios 'naa' 'mɨ'². ¡Tsá² 'in jo tsáai¹‑tsi 'naa'! ");
INSERT INTO chqNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Jo ngɨ́²ɨɨ' 'e cu'²‑'oo' 'e 'nó²oo' 'e cøø²øø' joongɨ 'e 'ú²uu'. ");
INSERT INTO chqNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Tsʉ tsá² 'in jo tsái¹‑tsi Dios 'in seein²¹ fu juncwii²¹ ngɨ¹o 'noo'²¹o jilaa'²¹ 'elo, pe 'naa' seen²¹mo jaain²¹ Ñʉ́²ʉʉ' 'in ñi¹ jilaa'²¹ 'e 'ná²gɨ tyii'. ");
INSERT INTO chqNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","'Áai¹gɨ tyʉ́² wa'a 'e cwooi'¹³naa' yaanaa' 'e tyʉ'² Dios to² 'naa' joon i'ii'¹³mo jilaa'²¹ 'elo. ");
INSERT INTO chqNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Faa'²¹gɨ Jesús: ―Tsá² tyiia, jo jmoo²gɨɨ' 'goo'²¹‑'oo'. Tsʉ xʉʉ 'naa' pe Ñʉ́²ʉʉ' 'áa¹mo 'yáai²‑tsi cwo'¹o 'naa' to² 'e 'oo¹o. ");
INSERT INTO chqNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","'Nɨ́ɨ²ɨɨ' jilaa'²¹ 'e sá² tyii' joon cwó²oo' 'in sɨtyéein¹ jmɨɨ²¹². Jmaa²aa' la joon coon²¹ tuloo²¹ tyii' 'e jo litsáai¹ joon 'áai¹gɨ ilisá² tyii' fu ñʉ'fú² 'e jo tya¹. Jileei'²¹ 'uun²¹ jo lí² tsataai² do jon'gɨ joo'¹³ fu² lí² ngɨ́ɨ¹. ");
INSERT INTO chqNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Xiia' lɨ 'óo²oo' jilaa'²¹ 'e 'yaai'²¹‑'oo' do‑o jon i'ɨ¹‑'oo'. ");
INSERT INTO chqNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Faa'²¹gɨ Jesús: ―'Ná²‑a tyá²aa' tyʉ́² tyii'. 'Ná²‑a téen³naa' coon'¹³ jɨ́² 'e coo²¹. ");
INSERT INTO chqNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Jmáa²aa' lawa tsaleei'¹³ 'in sɨjéen¹³in fii²¹²i. Mi cwaa'¹i fii²¹²i lɨ cui'² cwoo²¹ tsá² joon pó² 'ooca'nʉ́¹ do tsifu lí² no'²'o 'ooca'nʉ́¹. ");
INSERT INTO chqNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","'Áa²mo tyʉ́² 'ii²¹‑tsi 'in tsa'leei'¹³ do 'in jo cwuu²¹i mi cwai'² fii²¹²i. Tsʉ júu³ ja'²mo fuu²¹²uu 'naa', 'in fii²¹²i do ityá² tyʉ́² sɨɨn'³ 'ido joongɨ iunjíi²mo 'ido. Joon ityʉ'²ʉ to² cwá¹ tsá² lɨ si'² mesa 'e dø'²ø. Joon cwaa²¹o dø'²ø. ");
INSERT INTO chqNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Fiin'¹³ la 'woo²¹ tyiia² nʉ́ʉ¹ cwaa'²¹i sɨ la ngóo¹ ca jná² 'ee tyʉ́² 'ii²¹‑tsi tsa'leei'¹³ wana 'in jnaa¹‑tsi mi tyee'¹³i fii²¹²i do. ");
INSERT INTO chqNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Joon cwoliñi²ii' 'elo, wana jaain²¹ tsá² fii²¹² 'nʉ́¹ ini¹ 'ee 'ii'²¹ cwée¹i 'uun²¹ nijmaa¹o li'²o. Joon jo ná¹ 'nʉ́ʉ¹ʉ 'e jmá² 'ido 'uun²¹. ");
INSERT INTO chqNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","La joon jon 'naa' cwotyá²aa' tyʉ́² tyii' tsʉ coon²¹ wa jo 'ɨ¹‑'oo' ijó¹ 'in Ruu'²¹i Tsá² ―jin'² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Joon gaunngɨɨ¹ɨ Tʉ́³ sɨɨ'²¹ɨ Jesús: ―Ña'ñʉ'¹ʉ', ¿tɨ gafaa'¹³'a 'e cwáain¹ lo jiin'¹³ tyijna'a owa'a tya' ce jileei'²¹ tsá² 'ee? ");
INSERT INTO chqNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Jin'² Jesús: ―¿'Iin tsa'leei'¹³ 'in tyúi¹ joongɨ 'in 'øøi'²¹‑tsi mo tyʉ'² fii²¹²i to² 'e tyaa¹ cwoo²¹ jileei'²¹ tsá² taai² inʉʉ 'e cwoo¹ 'e dø'²ø mi tɨ́² 'ii'²¹? ");
INSERT INTO chqNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","'Áa¹mo tyúi¹ 'in tsa'leei'¹³ mi tyeei'¹² fii²¹²i tyee'¹³mo 'ido jmaa¹a la to² nigatyʉ'²ʉ. ");
INSERT INTO chqNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","'E la ja'²mo fo'³oo, 'in fii²¹² do nityaa¹o cwoo²¹ 'ido jilaa'²¹ 'e 'oo¹o 'e tyʉ'² 'ido to². ");
INSERT INTO chqNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pe wana 'in tsa'leei'¹³ do 'ɨ¹‑tsi 'e li'ɨɨ²¹²mogɨ fii²¹²i do tyee'¹²i joon 'láa² 'wii²¹² jíi²in 'in tsa'leei'¹³ catyaai²¹ do. Joongɨ 'láa² 'wii²¹² gø'²ø joongɨ 'uun'²¹o. Joon li'íin²mo. ");
INSERT INTO chqNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Joon 'in fii²¹² do ijó¹ coon²¹ jmɨɨ²¹² 'e jo sɨjée¹³in tsa'leei'¹³ tya'a do. Jon'gɨ ñi¹ 'ee 'ii'²¹. Joon lɨ́ɨ¹ i'e'²e 'ido wúu¹. Joon idye'²mo 'ido fu lɨ 'ii²¹ coon'¹³ jileei'²¹ 'in jo nʉʉ'¹²ʉ. ");
INSERT INTO chqNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Jileei'²¹ tsa'leei'¹³ 'in ñii¹o jilaa'²¹ 'e 'iin²¹²in fii²¹²i pe jo tyaa¹ tyʉ́² jon'gɨ unjíi²i i'e'²o wúu¹ joongɨ ijmee'¹³mo lɨɨlɨ¹. ");
INSERT INTO chqNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pe jileei'²¹ tsa'leei'¹³ 'in jo ñii¹ pe jmoo¹‑o jiin'¹³ 'e tɨ́ɨ²i xʉgɨ wúu¹ iní² 'ii. 'In nigacwo'²o Dios 'láai²gɨ imɨ́¹ jon Dios 'láai²gɨ. Joon 'in jo cu'²‑tsi coon'¹³ lɨɨlɨ¹ imɨ́¹ 'ido 'láai¹gɨ. ");
INSERT INTO chqNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Joon faa'²¹gɨ Jesús: ―Gagoo²¹² jna ga'uu²na jɨ́² ni cwoo'¹³ fu juncwii²¹. Joon tsei'² nisɨjaan¹oo wa'a icoo²¹. ");
INSERT INTO chqNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","'Ná²‑a tsangɨ́ɨ¹na coon²¹ 'e la jai'². Joon lí² móo³oo wúu¹ ca gatséi². ");
INSERT INTO chqNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Tɨ lɨ́ɨ²naa' 'e gagoo²¹²oo 'e sín¹ tsá² rǿø² coon'¹³ tsaruu'²¹i nicwoo'¹³ fu juncwii²¹? Fo'³oo 'e jo la joon. Jiin'¹³ gagoo²¹²oo wa'a jmáa³aa 'ii'¹³ tya' tsá². ");
INSERT INTO chqNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Tsʉ nano la ngóo¹ 'naai'¹³ 'in tsá² coon²¹ inʉʉ ilíin² tún² 'ii'¹³. Wana néei¹ 'ñéei² tsá² tsi coon²¹ inʉʉ gaai²¹ ili'ee'²¹i 'in gái¹ do, joon 'in gái¹ do ili'ee'²¹i 'in gaai²¹ do. ");
INSERT INTO chqNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","'In jmii²¹ do niseein²¹ gó² coon'¹³ jóon¹on. La joon gó² seein²¹ jóon¹on coon'¹³ jmii²¹. Joon sáa³gɨ seein²¹ gó² coon'¹³ jamɨ́ɨ¹ɨ. Jamɨ́ɨ¹ɨ la joon jon seein²¹ gó² coon'¹³ sáa³a. Joon 'yiiaunsáa³a niseein²¹ gó² coon'¹³ tsaunloo²¹ tya'a. Joon tsaunloo²¹ tya'gɨ niseein²¹ gó² coon'¹³ 'yiiaunsáa³a. ");
INSERT INTO chqNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Gasɨɨ'²¹ɨ jon Jesús tsá²: ―Mo moo²oo' róon² jníi¹ lɨ' li yuuin'¹² ñi'¹ joon jin'² tsá² ijó¹ jmɨ́¹. Joon 'e la joon lí². ");
INSERT INTO chqNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Joon mo 'ɨɨ¹ tyí² lɨ' tooin²¹² lɨ yuuin'¹³ ñi'¹ joon jin'² tsá² ilityíi² 'yiia²¹ no. Joon 'e la joon lí². ");
INSERT INTO chqNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","'Naa', ¡lɨ́ɨ¹naa' tsá² 'in jo untiin'¹³ 'e 'é²ee' tsá²! Tyʉ́²‑ʉ nii'² 'naa' xiiala lɨ́² juncwii²¹ joongɨ cwoo'¹³ fu juncwii²¹. ¿Xiiala jo ñí²ii' 'ee jiin²¹ taan²¹²naa'? ");
INSERT INTO chqNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Faa'²¹gɨ Jesús: ―¿'Ee lɨ' jo jmaa²aa' 'ii'²¹ la 'oo'²¹ yaanaa' coon'¹³ coon²¹ 'ii'²¹ 'e tyʉ́²? ");
INSERT INTO chqNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Wana 'in jmoo¹o tsaa² tyi'i joon cwóo²'o coon'¹³on tyani tsaa'to² pe 'nʉ‑ʉ jmaa²'a coon'²¹ tún² coon'¹³on la 'ɨɨ²¹² cwolíin²naa' tya'i fu. Joon jo tsajéei¹ 'nʉ tyani 'in jmoo¹o 'ii'²¹. Tsʉ 'in jmoo¹o 'ii'²¹ dogɨ nijaan'²¹in 'nʉ miyóo¹³. ");
INSERT INTO chqNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Joon miyóo¹³ dogɨ tsajéei¹ 'nʉ 'nʉñí³. 'E la ja'²mo fo'³oo jo júu¹³'u do ca gatyí²'i 'e rǿø²u tya'a joon gatsee²¹ coonti. ");
INSERT INTO chqNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Jee²¹² jmɨɨ²¹² joon gatyalíin² tsá² sɨɨ'²¹ɨ Jesús xiiala gajngaa'¹²i Pilato tsá² seein²¹ Galilea. Joongɨ xiiala gacaai'²¹ Pilato jmɨ¹ 'ǿø²i 'in tsá² do jmɨ¹ joo'²¹ núu³ 'e gajngaa'¹³i 'in tsá² do tya' 'e un'goo²¹ Dios. ");
INSERT INTO chqNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Joon gajin'² Jesús: ―¿Tɨ 'ɨ¹‑'oo' 'e jilaa'²¹ 'elo nigangɨ́ɨi¹ 'in tsá² seein²¹ Galilea do tsʉ 'áai¹gɨ røøi²¹ tsaa² lagɨ 'in tsá² ca tyaai²¹ do 'in seein²¹ Galilea? ");
INSERT INTO chqNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Pe jna fo'³oo jon' la joon. Joon wana 'naa' jo unsɨ́ɨ²naa' 'e 'ɨ¹‑'oo' la joon jon ijuun²¹mo 'naa'. ");
INSERT INTO chqNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","¿Tɨ lɨ́ɨ²naa' 'e 'áai¹gɨ røøi²¹ tsaa² 'in dyajñéei² tsá² gajúin¹ do mo gacɨɨi'²¹ 'e po'² ñíi¹³ tya' Siloé? ¿Tɨ 'áai¹gɨ røøi²¹ tsaa² 'ido lagɨ jileei'²¹ 'in néei¹ Jerusalén? ");
INSERT INTO chqNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Pe jna fo'³oo jon' la joon. Joon la joon wana 'naa' jo unsɨ́ɨ²naa' 'e 'ɨ¹‑'oo' la joon jon i'íin²mo 'naa'. ");
INSERT INTO chqNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Joon gajin'² Jesús 'e cwáain¹ lo tya' 'in tsá² do: ―Jaain²¹ tsañʉʉ'¹ ni'oo¹o 'mocwaríi³ sɨjná² cwoo'¹³ 'wó² tya'a. Joon ngajǿø²ø wana tsí³ cwaríi³. Pe jo 'ee gatsaa'²¹a ce jiin'¹³ coon²¹. ");
INSERT INTO chqNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Joon gasɨɨ'²¹ɨ 'in tsá² jǿø² cwoo'¹³ 'wó² tya'a do: “Jǿø²du', ningóo¹ 'nɨ¹ jiin²¹ góo³oo ga'naa'¹³aa cwaríi³ 'e² 'mó² lo pe jo mo gatsaa'³aa. Tyʉʉ'¹³ coonti 'e 'mó² no tsʉ lɨ' tɨ' jmoo¹gɨ jín¹ cwoo'¹³ 'wó².” ");
INSERT INTO chqNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Pe 'in tsá² jǿø² cwoo'¹³ 'wó² do gañii¹i: “Ñi'fii²¹i', cwojan¹du' coon²¹ jiin²¹gɨ. Joon nogɨ tyí³aa jla'¹ cwoo'¹³ joon to'³oo 'oo'³. ");
INSERT INTO chqNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Jongaa²¹mo wana nicwo¹, wana jo gacwo¹ joon tyʉ'³oo.” ");
INSERT INTO chqNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Coon²¹ jmɨɨ²¹² 'ii'²¹ 'woo'²¹ tsá² Jesús 'yuui cwo'¹ 'e'²e tsá². ");
INSERT INTO chqNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Joon do‑o 'yuui jaain²¹ tsamɨ́² ningóo¹ dyajñá² jiin²¹ 'e 'yuui jaain²¹ espíritu gó² alma tya'a 'e nigajmaa¹a tuu'²¹ moo'wó¹. Joon jo lí² siin'¹² 'ña'a røø²¹ coonti. ");
INSERT INTO chqNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Mo ganí² Jesús 'ii joon gatø'²ø. Joon gajin'²in: ―Tsamɨ́², ni'láa²mo'o 'e jmoowúu¹ tyán²'an no. ");
INSERT INTO chqNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Joon gataan¹ cwoo²¹o tya' 'ido. Joon la tsifu joon ganii'¹³mo 'ña'a 'in tsamɨ́² do røø²¹. Joon ga'láa² 'wii²¹² cwo'²o 'maai'¹³ Dios. ");
INSERT INTO chqNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Pe 'in tsá² tyʉ'² to² cwo'¹ sinagoga do gatɨ́² 'nii'²¹‑tsi tsʉ 'wii'¹³ gaun'láai² Jesús 'ido mo jmɨɨ²¹² 'ii'²¹ 'woo'²¹ tsá². Joon 'in tyʉ'² to² cwo'¹ do gasɨɨ'²¹ɨ tsá²: ―Sá²‑a jñʉ́ʉ² jmɨɨ²¹² 'e lí² to². Lí²‑i jalíin² tsá² jee²¹² jmɨɨ²¹² joon ilí² mɨ́¹ tya'a. Joon jo jalíin² jmɨɨ²¹² 'ii'²¹ 'woo'²¹ tsá². ");
INSERT INTO chqNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Joon gajin'² Jesús: ―'Naa' lɨ́ɨ¹naa' tsá² 'in jo untiin'¹³ jiin'¹³ 'e 'é²ee' tsá². ¿Tɨ jo sɨɨi'¹³naa' doñi'iin jee²¹² 'naa' sɨ joo'²¹ sɨ bu'³ 'ee cwotya'iin'²¹xʉ mo jmɨɨ²¹² 'ii'²¹ 'woo'²¹ tsá²? ");
INSERT INTO chqNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Joongɨ 'in tsamɨ́² lo jún² 'lɨɨ²¹² Abraham‑mo 'ii. Joon ningóo¹ dyajna¹ jiin²¹ jmoo¹ 'in 'lɨɨi'³ tsaa'¹³ 'in tsamɨ́² no. ¿Tɨ jo lí² un'láai² coon²¹ jmoowúu¹ tyaan¹ mo jmɨɨ²¹² 'ii'²¹ 'woo'²¹ tsá²? ");
INSERT INTO chqNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Mo ngayuui'¹³ gajin'² Jesús 'elo jileei'²¹ tsá² 'in 'eei'¹ 'ii ga'aa¹o fa'ɨɨ'²¹. Pe jileei'²¹gɨ tsá² jløø'³i coon'¹³ jilaa'²¹ 'e fee'¹ 'e gajmaa¹ Jesús. ");
INSERT INTO chqNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","'E joon gajin'² Jesús: ―¿Xiiala cwooi²¹ lɨ́² lɨ tyʉ'² Dios to²? ¿Joon 'ee coon'¹³ 'e lí² jmaa¹ coon²¹ røøi²¹ coon'¹³ joon? ");
INSERT INTO chqNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","'E lɨ́² la lɨ́² jún² jon'² tasa 'e jñí² tsá² cwoo'¹³ 'wó² tya'a. Joon do‑o cwaain²¹ ca galɨ́² 'mó² fee'¹. Cagɨ ton¹ jmaa¹ sɨ́ɨ²ɨ ni cwáa¹ 'mó² do. ");
INSERT INTO chqNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Joon gajin'² Jesús: ―¿Xiiala cwooi²¹ 'e jmáa³aa 'e litsáai¹‑tsi tsá² lɨ tyʉ'² Dios to²? ");
INSERT INTO chqNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","'E lɨ́² lawa tyiian'³ 'e gacaai'²¹ tsamɨ́² 'nɨ¹ cwaa'¹³ fu² 'iñi'¹. Joongɨ ca galɨ́² con² 'e fu² 'iñi'¹ la tøøi²¹. ");
INSERT INTO chqNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Gangóo¹gɨ Jesús fu Jerusalén. Ngɨ́ɨ¹i fuu²¹ coo'¹³ joongɨ fuu²¹ pi'³. La caain²¹ joon lɨ ga'ee¹e. ");
INSERT INTO chqNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Joon gaunngɨɨ¹xʉ tsá² 'ii: ―Ña'ñʉ'¹ʉ', ¿tɨ xʉ‑ʉ 'in itiin'¹³? Joon gañii¹i Jesús: ");
INSERT INTO chqNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Tyán²duu' cwáain¹ xiiala ngɨɨ²¹²naa'. Tyán²duu' cwáain¹ 'e ngɨɨ²¹²naa' lɨ' 'ooca'nʉ́¹ lɨ cuu'¹³ tsʉ 'e la ja'²mo fo'³oo: lɨ́ɨ¹ fúui¹ tsá² 'iin²¹²in tsataai² pe jo lí². ");
INSERT INTO chqNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Tsʉ mi yuui'¹³ 'in tsafii²¹² 'nʉ́¹ do iroon¹ jnii¹i 'ooca'nʉ́¹ joon 'naa' téen¹naa lɨ' caluu pó²oo' 'ooca'nʉ́². Joon ifó²oo': “Na² no, tsañʉʉ'¹.” Pe 'ii‑gɨ iñii¹i: “Jo ñí³ii 'iin 'naa'.” ");
INSERT INTO chqNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Joon 'naa' ifó²oo': “Niga'nee²¹e', nigatyee²¹e' coon'¹³ 'nʉ. Joon 'nʉgɨ niga'e'²'e jna'a tya'i fu¹ tyii'i.” ");
INSERT INTO chqNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Pe 'ido‑gɨ niñii¹i: “Jna fo'³oo: jo ñí³ii xiia seen²¹naa'. Tíuui¹duu' jna jileei'²¹ 'naa' 'in jmoo²oo' jilaa'²¹ 'e gó².” ");
INSERT INTO chqNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Do‑o cwotyíi¹³ii' joongɨ cwocuu'¹³naa' moojón²oon' mi máa¹³naa' Abraham coon'¹³ Isaac coon'¹³ Jacob coon'¹³ jileei'²¹ tsá² 'in gacwo¹ júu³ tyʉ́² calɨɨ. Do‑o táa²mo lɨ tyʉ'² Dios to² joon 'naa'gɨɨ' taa²¹²naa' fu caluu. ");
INSERT INTO chqNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Tsʉ ijalíin²mo tsá² fu lɨ 'yeei²¹ ñi'¹ joongɨ fu lɨ' lɨ yuuin'¹³ ñi'¹. Joongɨ lɨ' caai²¹ tsáa¹ lɨ' lɨ 'yeei²¹ ñi'¹ joongɨ lɨ' caai²¹ tooin²¹² lɨ' lɨ 'yeei²¹ ñi'² ijalíin² tsá². Joon icwaa¹ dø'²ø lɨ tyʉ'² Dios to² tsá². ");
INSERT INTO chqNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Joon 'inlɨ́ɨi¹³ sɨcɨɨin²¹ nano 'ii ijmáa¹a nifu, joongɨ 'inlɨ́ɨi¹³ 'in sɨjéei¹ nano 'ii ijmáa¹a lɨ cɨɨin²¹. ");
INSERT INTO chqNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Jee²¹² jmɨɨ²¹² joon gatyalíin² 'inlɨ́ɨi¹³ tsá² fariseo. Joon gajin'²in sɨɨ'²¹ɨ Jesús: ―Lo‑o júu¹³'u nano tsʉ Herodes 'iin²¹²in jnga'²mo 'nʉ. ");
INSERT INTO chqNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Joon gañii¹i Jesús: ―Cwolíin²naa' joon cwosíi¹³ii' 'in gó² do: “Jǿø²du' no. Jmɨɨ²¹² no joongɨ tsa'oo²¹ 'woo²na espíritu gó² alma tya' tsá². Joongɨ un'láa²na tsatsaa'¹³. Joongɨ 'yíia¹ untyée¹moo to² tyiia.” ");
INSERT INTO chqNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Joon níi³oo jiin'¹³ la fu¹ 'yúu³na no coon'¹³ tsa'oo²¹ joongɨ 'yíia¹. Tsʉ jiin'¹³ fu Jerusalén lí² júun²in jaain²¹ tsá² cwo¹ júu³ tyʉ́². ");
INSERT INTO chqNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’¡Tsá² Jerusalén, tsá² Jerusalén, 'naa' jngaa'¹³naa' jileei'²¹ tsá² cwo¹ júu³ tyʉ́² joongɨ tyʉ́²ʉʉ' cuun²¹² jileei'²¹ tsá² 'in gasii¹in Dios ijma'²a 'naa' júu³ 'e fu¹ táa²naa'! ¡Joon jna‑a gali'iin²¹²na 'e uncaan²¹na 'naa' la jmoo¹o jaain²¹ tuiyʉ́² 'e uncaain²¹ tutɨ'² nʉ' cwáa¹a! ¡Pe jo gali'iin²¹²naa'! ");
INSERT INTO chqNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Jǿø²du' 'naa' isɨján¹ 'naa' itʉʉ¹mo 'naa'. Joon fuu²¹²uu 'naa' 'e jo jǿøi²gɨ 'naa' jna ca mi gacwá² jmɨɨ²¹² ifó²oo': “Cwaa'³mo 'in jó¹ coon'¹³ 'e sii²¹ Ña'ñʉ'¹ʉ'.” ");
INSERT INTO chqNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Galɨ́² coon²¹ jmɨɨ²¹² 'ii'²¹ 'woo'²¹ tsá² 'e gangóo¹ Jesús nga'ee'²¹e fu tya' jaain²¹ 'in tyʉ'² to² fariseo. Joon 'inlɨ́ɨi¹³ tsá² fariseo gacoon²¹ cwáain¹ do. ");
INSERT INTO chqNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Joon tyíin¹ jaain²¹ tsañʉʉ'¹ jee²¹² 'in tyan¹ jmoowúu¹ 'e yiian²¹ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Joon gajin'² Jesús sɨɨ'²¹ɨ tɨfo'² tya' ley coon'¹³ tsá² fariseo: ―¿Tɨ cwooi¹ un'láai² tsá² jaain²¹ tsatsaa'¹³ mo jmɨɨ²¹² 'ii'²¹ 'woo'²¹ tsá² owa jo lí² 'ee? ");
INSERT INTO chqNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Pe 'ido‑gɨ gajoon¹ ti‑i. Joon gataan¹ Jesús cwoo²¹o 'in tsatsaa'¹³ do joon gaun'láa²mo. Joon gasɨɨ'²¹ɨ 'ido 'e tsee'²¹mo 'ido. ");
INSERT INTO chqNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Joon gasɨɨ'²¹ɨ Jesús tsá² fariseo do: ―¿'Iin jee²¹² 'naa' wana gatøøi'²¹ bu'³ tyii' sɨ joo'tsáa² 'ee coon²¹ tsi too²¹, tɨ jo tyiin'¹³naa' la tsifu fiin'¹³ jmɨɨ²¹² 'ii'²¹ 'woo'²¹ tsá²? ");
INSERT INTO chqNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Joon 'in tsá² do jo ñii² 'e ñii¹gɨ jiin'¹³ coon²¹. ");
INSERT INTO chqNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Mo ganii²¹ Jesús jileei'²¹ tsá² 'in gatø'¹ tsá² lɨ cuui'¹³ cwoo²¹ tsá² 'noo'²¹o lɨ cwaa¹a lɨ tyiin²gɨ joon gasɨɨ'²¹ɨ Jesús 'e cwáain¹ lo: ");
INSERT INTO chqNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Wana 'in gatø'¹ 'nʉ coon²¹ lɨ cuui'¹³ cwoo²¹ tsá² jo ní²'i 'e 'mosíi¹ nifu tsʉ coon²¹ jo ngá¹mo cwéei¹² jaain²¹ 'in tyíin²gɨ lagɨ 'nʉ. ");
INSERT INTO chqNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Joon 'in gatø'¹ 'naa' cwee¹i sɨɨ'²¹ɨ 'nʉ: “Cwóo¹³'o 'ino 'mosíi¹ tyíin¹u'un no.” Joon la joon ráan²un coon'¹³ fa'ɨɨ'²¹. Cwaní²'i 'mosíi¹ ca lɨ gatséi². ");
INSERT INTO chqNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Lɨ' cɨɨ'¹³ɨ jmaa²'a. Mo tø'¹ tsá² 'nʉ coon²¹ lɨ cuui'¹³ cwoo²¹ tsá² ní²'i 'mosíi¹ lɨ tséi². La coon'¹³ mi jó¹ 'in gatø'¹ 'nʉ sɨɨ'²¹ɨ 'nʉ: “Ngɨɨi²¹² ní²'i 'e 'mosíi¹ nifu do.” La joon 'e tyʉ́²gɨ tyi'i tyani 'in néei¹ coon'¹³ 'nʉ. ");
INSERT INTO chqNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Tsʉ jileei'²¹ 'in jmaai'²¹ cøøi'¹³ yaai, 'ii lɨ tséi¹ joon jileei'²¹ 'in jmaai'²¹ yaai lɨ tséi² 'ii nifu. ");
INSERT INTO chqNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Gasɨɨ'²¹o joon 'in tsañʉʉ'¹ 'in nigatø'¹ 'ido: ―Mo 'iin²¹²u'un tø'²'ø tsá² cwo'²xʉ'ʉ 'e dø'¹ 'ido jo tø'²'ø 'in seein²¹un tyʉ́² coon'¹³ jon'gɨ ruu'²¹'u jon'gɨ tsá² néei¹ co' lɨ tyíin¹u'un wa' 'in sá² cuu². Tsʉ icɨ'²o tún¹ icwó²'o do. ");
INSERT INTO chqNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Jo jmaa²'a la joon, pe mo 'ee coon²¹ jmɨɨ²¹² jmaa²'a tø'²'ø jileei'²¹ tsá² tañíi²mo coon'¹³ jileei'²¹ 'in 'wo² sɨ'ɨ́¹‑tsi coon'¹³ tsajluui'¹³ coon'¹³ tsatiui². ");
INSERT INTO chqNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","La joon tyʉ́²‑ʉ 'ɨ¹‑'o'o tsʉ 'ii jo lí²gɨ tyí² tyi'i 'e cwo'²'o do. La joon ityii²¹² tyi'i mi jiin'¹ jileei'²¹ 'in jo røøi²¹ tsaa². ");
INSERT INTO chqNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Mo ganúu² jaain²¹ 'in néei¹ gøø'²¹ coon'¹³ Jesús 'e do joon gajin'²in sɨɨ'²¹ɨ 'ii: ―'In jløø'³mo 'in dø'¹ 'iñi'¹ lɨ tyʉ'² Dios to² tsá². ");
INSERT INTO chqNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Joon gajin'² Jesús: ―Jaain²¹ tsañʉʉ'¹ gajmaa¹a coon²¹ jmɨɨ²¹² lɨ gø'² tsá². Joon gatø'¹ fúui¹ tsá² 'e dø'¹o do. ");
INSERT INTO chqNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Joon mo gatɨ́² 'ii'²¹ 'e dø'¹ tsá² gasii¹in tsa'leei'¹³ tya'a 'in ngajmaa'¹³a júu³ 'in tsá² nitø'¹ø do. Jin'²in: “Naná¹‑a tyʉ́².” ");
INSERT INTO chqNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Joon jilee'²¹mo ga'láa² 'wii²¹² mɨɨ¹ɨ jmɨɨ²¹² 'aa²¹². 'In ni fu do gajin'²in: “Jmáa² feei'¹‑'o'o jo níi³ii. No‑o tá²gɨ galoo²¹²oo coon²¹ cwoo'¹³ 'wó². Joon 'ná¹ níi³ii nijǿø²øø.” ");
INSERT INTO chqNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","'In xeei'²¹gɨ jin'²: “Feei'¹du‑'o'o 'wii²¹² tyiia. Nilǿø²na 'néei² jmuui¹ joo'²¹. 'Inijǿø²duu wa'a tɨ́ɨ²i jɨ́ɨ¹ɨ.” ");
INSERT INTO chqNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","'In xeei'²¹gɨ jin'²: “La gangayuu'¹³mogɨ cui'² cwóo³oo joon jo lí² níi³ii.” ");
INSERT INTO chqNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Joon mo gangai'² 'in tsa'leei'¹³ do, ngajmaa'¹²a júu³ ñi'fii²¹²i do. Joon lɨ́ɨ¹ gatɨ́² 'nii'²¹‑tsi tsafii²¹² do. Joon gasɨɨ'²¹ɨ tún¹ 'ido: “Jmoono cwoo'¹³'o jee²¹² 'nʉ́¹ 'e fuu²¹ lo. Cwotee²'e jileei'²¹ tsá² tañíi² coon'¹³ tsá² 'wo² sɨ'ɨ́ɨ¹‑tsi coon'¹³ tsajluui'¹³ coon'¹³ tsatiui².” ");
INSERT INTO chqNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Mo ca'loo¹gɨxʉ joon gajin'² 'in tsa'leei'¹³ tya'a do: “Nigajmáa³oo to² gatyʉ'²'ʉ do. Joon sá²gɨ li cwá² tsá².” ");
INSERT INTO chqNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Joon gajin'² 'in tsafii²¹² do gasɨɨ'²¹ɨ tún¹ tsa'leei'¹³ tya'a: “Cwoo'¹³'o tya'i fu¹ ca tɨ́² fuu²¹ coonti. Cwote'²'e tsá² tyitsaai²¹² 'in xeei'²¹gɨ cwongɨ́ɨi¹, tsʉ cworøøi²¹ tyiia lo coonti. ");
INSERT INTO chqNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Tsʉ fo'³oo ce jiin'¹³ jaain²¹ 'in gatø'²oo nifu jo idø'¹gɨ jiin'¹³ coon²¹ 'yʉ'oo² 'e 'uunñi² sá² tya' jmɨɨ²¹² tyiia lo,” jin'² 'in tsafii²¹² ―gajin'² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Fúu¹mo tsá² ngalíin² coon'¹³ Jesus. Joon gajiin'¹³ Jesús níi¹i joon gajin'²in: ");
INSERT INTO chqNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Wana 'in 'iin²¹²in jó¹ coon'¹³ jna 'ná¹‑a li 'iin²¹²in jna. Wana jo 'iin²¹²in jna lɨ́ɨ¹gɨ lagɨ jmii²¹ joongɨ lagɨ sáa³a, lagɨ tsamɨ́² tya'a, lagɨ jóon¹on, lagɨ ruu'²¹i, joongɨ ca fu juncwii²¹ tya'a 'ña'a jo lí² líin² 'ido tsá² tyiia. ");
INSERT INTO chqNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Wa 'in jo náa¹ tyʉ́² tya'a júuin² la ijúuin² jna jo lí² líin² tsá² tyiia. ");
INSERT INTO chqNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Wana jaain²¹ jee²¹² 'naa' 'iin²¹²in jmaa'¹²a coon 'nʉ́¹, ¿tɨ jo jéei¹ tyí¹du cwáain¹ xiiati jiin'¹² i'íin² wana 'yeei¹? ");
INSERT INTO chqNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Tsʉ wana jmoo'¹²o tɨɨfuu²¹ joongɨ gatsá² cúu¹u la jo mo 'yeei¹ 'nʉ́ʉ¹ʉ joon i'láa² tsá² 'wii²¹² ungøø²mo 'i. ");
INSERT INTO chqNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ijin'²in: “In tsañʉʉ'¹ no ga'láa² 'wii²¹² jmaa'¹²a joon jo lí² un'yeei¹gɨ.” ");
INSERT INTO chqNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Wana jaain²¹ rǿøi¹³ 'iin²¹²in jmáa¹a 'níi³ coon'¹³ jaain²¹gɨ rǿøi¹³, ¿tɨ jo cwá²a nifu joon i'ɨ¹‑tsi wa'a ilíin² dyái¹ mil 'láa² tya'a ilii'¹i 'in dyáai² mil 'láa² tya' 'in rǿøi¹³ jaain²¹gɨ do? ");
INSERT INTO chqNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Joon wana jo lí², la 'ɨɨ²¹² 'e taain²¹² wíin²gɨ 'in tsá² rǿøi¹³ jaain²¹gɨ do joon isín¹mo tsá² tya'a mɨɨ¹ɨ júu² røø²¹. ");
INSERT INTO chqNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","La joon jon jmoo²¹ joon jaain²¹ 'naa' 'in jo tʉʉ¹ jilaa'²¹ 'e 'oo¹o jo lí² líin² tsá² tyiia. ");
INSERT INTO chqNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’'Ee tyʉ́²‑ʉ ñi² pe wana jo ñi²gɨ xiiala cwooi¹ 'e liñi²gɨ tún¹. ");
INSERT INTO chqNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Jo 'e to² 'íin³gɨ tya' cwoo'¹³ 'wó² jon'gɨ tya' poo²¹² 'oo'². Lɨgon dya'²a tsá². Jileei'²¹ 'in núu² cwonʉʉ¹o. ");
INSERT INTO chqNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Jileei'²¹ tsá² cón² 'laa'¹³ 'e 'nɨɨ¹ tsá² coon'¹³ tsá² røøi²¹ tsaa² gangatyéen¹in lɨ siin'¹² Jesús 'e núu² júu³ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","'Wii'¹³ joon tsá² fariseo coon'¹³ tɨfo'² tya' ley 'laa'²¹ gafaa'²¹a tya' Jesús jin'²in: ―'In tsañʉʉ'¹ lo 'ii'²¹mo jileei'²¹ 'in røøi²¹ tsaa² joongɨ gøø'²¹o coon'¹³ 'ido. ");
INSERT INTO chqNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Joon gasɨɨ'²¹ɨ Jesús 'ii 'e cwáain¹ lo: ");
INSERT INTO chqNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―'Iin jee²¹² 'naa' wana 'aa¹i cíein¹³ joo'saa'²¹ joon tsa'iin²¹² jaain²¹ jee²¹² 'ii, ¿tɨ jo tiui²¹ 'in catyaai² do jee²¹² nuu²¹ joon tsa'nee'¹²i 'in jaain²¹gɨ do ca gatsee'²¹i? ");
INSERT INTO chqNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Joon mo gatsee'²¹i gauntseen¹ yʉ' 'nóo¹on jløø'³mo. ");
INSERT INTO chqNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Joon mo gatyee'¹²i tya'a gauncaain²¹ tsá² seein²¹ tyʉ́² coon'¹³ coon'¹³ tsá² néei¹ co' lɨ tyíin¹in. Joon gasɨɨ'²¹ɨ: “Jløø'³naa' jmaa²aa' coon'¹³ jna tsʉ nigatsee'³moo 'in joo'saa'²¹ 'in ga'ín¹ tyiia do.” ");
INSERT INTO chqNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","La joon jon fuu²¹²uu 'naa' mo joo'²¹‑tsi jaain²¹ tsá² røøi²¹ tsaa² jløøi'¹³gɨ 'áai¹ fu ñʉ'fu 'wii'¹³ 'ii lagɨ 'in noventa y nueve tsá² 'in jo 'oo¹o tsaa², 'in jo 'ná² jaa'²¹‑tsi. ");
INSERT INTO chqNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Faa'²¹gɨ Jesús: ―Wa' jaain²¹ tsamɨ́² 'in 'oo¹o dyá² cuu² joon ganga'ín¹ coon²¹ cuu² do, ¿tɨ jo dyi'¹i coon²¹ jɨ́² joon 'ya'¹a inʉʉ do? Coon'²¹ tún² 'noo'¹o ca gatsaa'²¹a. ");
INSERT INTO chqNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Joon mo gatsaa'²¹a joon uncaain²¹ tsá² seein²¹ tyʉ́² coon'¹³on coon'¹³ tsá² 'in néei¹ co' lɨ tyíin¹in. Joon sɨɨ'²¹ɨ 'ido: “Jløø'³naa' jmaa²aa' coon'¹³ jna tsʉ nigatsaa'²¹oo cuu 'e nga'ín¹.” ");
INSERT INTO chqNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","La joon jon fuu²¹²uu 'naa', jløø'³mo ángeles tya' Dios mi jaa'²¹‑tsi xʉfiin'¹³ jaain²¹ tsá² 'in røøi²¹ tsaa². ");
INSERT INTO chqNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Gajin'²in jon Jesús gasɨɨ'²¹ɨ tsá²: ―Lawa jaain²¹ tsañʉʉ'¹ 'aa¹i gái¹ sɨmii'²¹ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Joon jaain²¹ 'in xaai²¹gɨ do gasɨɨ'²¹ɨ jmii²¹: “Ñʉ'², cwo'²'o jna jiin'¹³ tyiia tya' cwoo'¹³ 'wó² 'e gatɨ́ɨ²na.” Joon gajmaa¹a jmii²¹ do jmai'²xʉ jee²¹² 'ii jilaa'²¹. ");
INSERT INTO chqNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Xʉ‑ʉ ngoo²¹gɨ joon 'in xaai²¹gɨ do gajmaa'¹² caain²¹ jilaa'²¹ 'e 'oo¹o. Joon gangóo¹ coon²¹ fuu²¹ lɨ wíin². Joon do‑o ga'íin² cúu¹u jilaa'²¹ coon'¹³ 'e gó². ");
INSERT INTO chqNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Joon mo gatsá² cúu² do ga'í² coon²¹ 'oo² 'e fuu²¹ lɨ ngóo¹on do. Joon gatsá² un'aa²i. ");
INSERT INTO chqNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Joon ganga'náa² to² jmáa¹a coon'¹³ jaain²¹ tsá² seein²¹ 'e fuu²¹ do. Joon 'idogɨ gasii¹ ni 'ido lɨ roon¹ 'wó² tya'a 'e tsa'áa¹i ñí¹. ");
INSERT INTO chqNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Joon 'áa¹mo gali'iin²¹²in unrǿø²i tu'²u coon'¹³ jilaa'²¹ 'e gø'² ñí¹ do. Pe jiin'¹³ jaain²¹ jo 'in cwo¹. ");
INSERT INTO chqNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Joon ga'ɨ¹‑tsi: “Jøøi'¹³ tsa'leei'¹³ 'in jmoo¹o to² tya' nʉ'³ʉʉ saai²¹gɨ 'e gø'²ø joon jnagɨ fu lo júun³na 'oo². ");
INSERT INTO chqNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nii'¹³moo fu lɨ tyíin¹ ñʉ'³ʉʉ. Joon fuu²¹²uu: Ñʉ'³, fee'¹ niga'lee'²¹na tyani Dios joongɨ tyani'i. ");
INSERT INTO chqNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Joon jo cwooi¹ 'e jmáa²gɨ'ɨ yʉʉn²¹ tyi'i jna. Jmaa'¹³ cwáain¹ lawa jaain²¹ tsa'leei'¹³ tyi'i jna.” ");
INSERT INTO chqNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Joon gangaa'¹³mo fu tya jmii²¹. ’Wíin²gɨ 'ná¹ tyee'¹²i lɨ siin'¹² jmii²¹ mo ganíi²in jmii²¹ 'ii. Galifeei'¹mo‑tsi 'wii²¹² tya'a. Joon gangóo¹o cwiin¹ ngajeen² ni 'ido. Joon ga'ii'³mo 'ido. Joon garɨɨn¹in joongɨ gacu'¹u 'oo² 'ido. ");
INSERT INTO chqNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Joon gasɨɨ'²¹ɨ jóon¹ 'ii: “Ñʉ'³, niga'lee'²¹moo tyani Dios joongɨ tyani'i. Jo tɨ́ɨi²gɨɨ 'e fo'²'o yʉʉn²¹ tyi'i jna.” ");
INSERT INTO chqNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Pe jmii²¹ dogɨ gasɨɨ'²¹ɨ tsa'leei'¹³ tya'a: “Tyí² goon' jmoono coon²¹ 'mɨ'² 'e tyʉ́²gɨ la jee²¹² jilaa'²¹, joon tyiin'¹³goon' yʉʉn²¹ tyiia lo. Joongɨ toon'²¹goon' ñí³ unnii²¹² cwoo²¹o. Joongɨ 'øøi'¹³ goon' mɨɨ²ɨ. ");
INSERT INTO chqNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Joon cwotée¹ee' jaain²¹ joo'²¹ xuui²¹² 'in na'ooin'¹³. Joon jngaa'¹³naa', cwotyé³e' joongɨ cwojmoo²¹o' jmɨɨ²¹². ");
INSERT INTO chqNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Tsʉ 'in yʉʉn²¹ tyiia lo lɨ́ɨ²na 'e nijuun²¹mo pe nano nigacwa'²mo tún¹. 'In ninga'íin¹³mo pe gatsee'²¹moo'o tún¹.” Joon ga'láa² 'wii²¹² jmaa¹a jmɨɨ²¹². ");
INSERT INTO chqNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’La jee²¹² joon 'in jóon¹ 'in nifeei'¹gɨ jee²¹² to² taain¹. Joon mo gatyee'¹²i tyan' co' 'nʉ́ʉ¹ʉ joon ganúu² nináa¹ súuin¹³. ");
INSERT INTO chqNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Joon gatø'¹ø jaain²¹ 'in tsá² do joon gaunngɨɨ¹ɨ 'ee jmɨɨ²¹² nináa¹. ");
INSERT INTO chqNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Joon gajin'² 'in tsá² do: “Nigacwa'²mo ruu'²¹mo'o. Joon gatyʉ'² ñʉ'²'ʉ to² gajngaa'¹²i jaain²¹ joo'²¹ 'ooin'¹³ tsʉ gacwa'²mo tyú¹mo jo tsaa'¹³a.” ");
INSERT INTO chqNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Joon gatsá² 'nii'²¹‑tsi 'in ruu'²¹i nifeei'¹gɨ do. Joon jo 'iin²¹²in tsa'ii²¹ fu tsi. Joon gacwo'ɨ́ɨ¹ jmii²¹ 'e gamɨɨ¹ɨ tyani 'ido 'e tsa'ii²¹. ");
INSERT INTO chqNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Pe gajin'² 'in sɨmii'²¹ gasɨɨ'²¹ɨ jmii²¹: “Niñii²¹o'o joo'¹³ jiin²¹ 'e nigajmáa³aa to² tyani'i. Pe jiin'¹³ coon²¹ 'naa'¹³ jo mo cwoo'¹³'o jna jiin'¹³ jaain²¹ chivo‑pi' 'e jmáa³aa jmɨɨ²¹² coon'¹³ tsá² seein²¹na tyʉ́² coon'¹³. ");
INSERT INTO chqNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Pe la no 'e gacwai'² 'in yʉʉn²¹ tyi'i no. Nga'íin¹in cúu²u coon'¹³ tsamɨ́². Joon gajngáa¹³u'un 'in joo'²¹ 'ooin'¹³gɨ no.” ");
INSERT INTO chqNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Joon gajin'² jmii²¹ do: “Yʉʉn²¹ tyi', coon²¹ tøø²mo tyíin¹u'un coon'¹³ jna. Joon jilaa'²¹ 'e 'óo³oo lo 'e tyi‑o'o. ");
INSERT INTO chqNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Joon nano tyiin²mo jmoo²¹o' jmɨɨ²¹² joongɨ jløø'³na' tsʉ 'in ruu'²¹'u 'e lɨ́ɨ²na najuun²¹mo pe cwa'²mo tún¹. Lɨ́ɨ²na 'e ninga'íin²mo joon nigatsee'²¹moo'o tún¹.” ");
INSERT INTO chqNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Gajin'²in jon Jesús sɨɨ'²¹ɨ tsá² tya'a: ―Galiseein²¹ jaain²¹ ñi'fii²¹² sá² cuu² joon seein²¹ jaain²¹ 'in tyʉ'² to² tsa'leei'¹³ tya'a. Joon gajma'²a tsá² 'in ñi'fii²¹² do júu³ 'e 'in tsá² tyʉ'² to² do 'áai¹ 'íin²in cuu² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Joon 'in ñi'fii²¹² do gatø'¹ø 'ido. Joon gasɨɨ'²¹ɨ: “¿Tɨ jo'² 'e sɨɨ'²¹ tsá² jna cwáain¹ tyi'i? Joon'¹²du'u cwáain¹ to² jmoo²'o tsʉ jo jmáa²gɨ'ɨ to² coon'¹³ jna. Jo cwooi tyʉ'²gɨ'ɨ to² tsa'leei'¹³ tyiia no.” ");
INSERT INTO chqNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Joon ga'ɨ¹‑tsi 'in tsá² tyʉ'² to² do: “¿'Ee ijmáa³aa? Tyí¹mo ñi'fíi³ii jna jee²¹² to² tya'a. Jo 'waa'²¹ pí² 'óo³oo wa'a jmáa³aa to² jee²¹² tyiia²¹ joon 'óo³oo fa'ɨɨ'²¹ wa'a mɨ́³ɨɨ caridad. ");
INSERT INTO chqNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ñíi³oo 'ee jmáa³aa 'e 'ii'²¹mo tsá² jna inʉʉ tya'a mo jo to² 'óo³gɨɨ.” ");
INSERT INTO chqNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Joon gatø'¹ø tɨ' jaain²¹ tɨ' jaain²¹ 'in røøi²¹ tya' ñi'fii²¹²i. Joon gaunngɨɨ¹ɨ 'in nifu: “¿Xiiati røø²¹u tya' ñi'fii²¹i'?” ");
INSERT INTO chqNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","'Idogɨ jin'²: “Røø²¹moo cíein¹³ barril aceite.” Joon 'in tsá² tyʉ'² to² do sɨɨ'²¹ɨ 'ido: “Lo‑o saan'¹³aan mo'jí² tyi'i. Ní²du' jmoono joon jmáa² coon²¹ 'e coon'²¹ tsa'²gɨ.” ");
INSERT INTO chqNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Joon gaunngɨɨ¹ɨ 'in xeei'²¹gɨ tún¹: “'Nʉgɨ, ¿xiiagɨ tɨ røø²¹u?” 'Idogɨ jin'²in: “Cíein¹³ 'motuu'¹ trigo.” Joon gasɨɨ'²¹ɨ: “Lo‑o saan'¹³aan mo'jí² tyi'i. Jmáa² coon²¹gɨ jiin'¹³ ochenta.” ");
INSERT INTO chqNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Pe galili'²i ñi'fii²¹² do 'e lɨ́ɨ¹ 'øøi'²¹‑tsi 'in tyʉ'² to² do coon'¹³ 'e gajmaa¹a do. Tsʉ li'²gɨ tsá² 'in jo tsaa'²‑tsi Dios coon'¹³ 'e jmoo¹o la jaain²¹ la jaain²¹ lagɨ 'in tsaaa'²‑tsi Dios. ");
INSERT INTO chqNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Fuu²¹² jna 'naa' ―jin'² Jesús― jmáa² 'naa' 'in liseein²¹ tyʉ́² coon'¹³ 'naa' coon'¹³ 'e 'oo²oo' fu juncwii²¹. Joon mi tyá¹ jilaa'²¹ 'e sá² fu juncwii²¹ iseen²¹mo 'in 'ii'²¹ 'naa'. In'ii'²¹ 'naa' lɨ taan²¹²naa' coon²¹ tøø²mo. ");
INSERT INTO chqNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Wa jmoo¹ tsá² 'e tyʉ́² fiin'¹³ capii'³ 'e 'oo¹o, ijmáa¹o 'e tyʉ́² jon wa'a sá² 'láai². Pe wana coon²¹ tóo² tya' capii'³, icoon²¹o jon tóo² tya' 'e 'láai². ");
INSERT INTO chqNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Wana jo jmoo²oo' tyʉ́² coon'¹³ jilaa'²¹ 'e sá² fu juncwii²¹ lo 'e jo tyiin² xiiala lɨ́ɨ²naa' icwo'¹o Dios 'naa' 'e sá² 'e tyiin² la jai'². ");
INSERT INTO chqNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Wana jo gajmaa²aa' røø²¹ coon'¹³ 'e sá² tya' 'inxeei'²¹ jo cwooi¹ cwo'¹o 'naa' 'e tyii' yaanaa'. ");
INSERT INTO chqNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Ce jiin'¹³ jaain²¹ tsa'leei'¹³ jo lí² jmaa¹a to² tyʉ'² gái¹ ñi'fii²¹². Tsʉ nili'ee'¹mo jaain²¹ joon 'in jaain²¹gɨ do nili'nee²¹mo sɨ ilɨtyúu¹mo coon'¹³ jaain²¹ joon coon'¹³ 'in jaain²¹gɨ do gó²o liseein²¹. Jo lí² 'iin²¹² tsá² Dios la jee²¹² 'iin²¹²in cuu². ");
INSERT INTO chqNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","'In tsá² fariseo do 'in lɨ́ɨ¹ 'iin²¹²in cuu² núu²o jilaa'²¹ 'elo. Joon gaungøø¹mo Jesús. ");
INSERT INTO chqNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Joon gajin'² Jesús sɨɨ'²¹ɨ 'ido: ―Ngɨɨ²¹naa' coon'¹³ 'e tyʉ́² jee²¹² tsá² pe ñi¹ Dios 'ee lɨ́ɨ²naa'. Jilaa'²¹ 'e 'øøi'²¹‑tsi tsá² 'e tyiin² 'e joon 'e 'ee'¹mo Dios. ");
INSERT INTO chqNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Jin'² Jesús: ―Ca mo jó¹ Wó³ gatyʉ'²ʉ to² 'e ley tya' Moisés coon'¹³ 'e júu³ tya' tsá² cwo¹ júu³ tyʉ́² calɨɨ. Ca 'yiia'¹³ joon galisá² júu³ tyʉ́² xiiala mi tyʉ'² Dios to² tsá². Joon jilee'²¹mo cwoo¹ pí² tsataai²¹² lɨ tyʉ'² Dios to². ");
INSERT INTO chqNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Tyan¹gɨ to² jo tsín¹ jiin'¹³ coon²¹ letra tya' ley la coon'²¹gɨ 'íin² coonti jilaa'²¹ yʉ' fu juncwii²¹ coon'¹³ cwoo'¹³ fu juncwii²¹. ");
INSERT INTO chqNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Wana jaain²¹ tsañʉʉ'¹ 'ee'¹mo tsamɨ́² tya'a joon cui'² cwoo²¹ coon'¹³ 'in xeei'²¹ fee'¹ tsaa² 'noo¹on. Joon wana cui'² tsá² cwoo²¹ coon'¹³ 'in tsamɨ́² do la joon jon fee'¹ tsaa² 'noo¹on. ");
INSERT INTO chqNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Gajin'²in jon Jesús gasɨɨ'²¹ɨ tsá²: ―Lawa jaain²¹ tsá² sá² cuu² 'in tyi'¹ jmaai'¹³ sɨɨn'³ tyʉ́² joongɨ 'ya'²gɨ. Joon la coon²¹ jmɨɨ²¹² jmaa¹a jmɨɨ²¹² coon'¹³ 'e 'ya'²gɨ lɨɨlɨ¹. ");
INSERT INTO chqNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Galiseen²¹mo jon jaain²¹ tsá² tañíi² 'in sii²¹ La'². La tøøi² ngúu¹u sɨrøøi²¹ 'mi'². Joon gacwó²o ni wó² 'ooca'nʉ́¹ tya' 'in tsá² sá² cuu² do. ");
INSERT INTO chqNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","'In tsá² tañíi² do 'iin²¹²in røøi²¹ tu'²u coon'¹³ jilaa'²¹ 'e xʉʉ'²¹ 'wii²¹² mesa lɨ gø'² 'in tsá² sá² cuu² do. Joon cagɨ tsii²¹ jalíin² lɨ tyíin¹in 'e 'lʉ'²ʉ lɨ jgoo'²¹ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Coon²¹ jmɨɨ²¹² gajuun²¹mo 'in tsá² tañíi² do. Joon ángeles gatøø²mo 'ii 'e cwaa¹ coon'¹³ Abraham fu ñʉ'fú². La joon jon gajúun²mo 'in tsá² sá² cuu² do. Joon ga'aa¹mo tsá² 'ii. ");
INSERT INTO chqNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","'In tsá² sá² cuu² do 'áai¹ ganí²in wúu¹ lɨ tsalíin² 'in najúin². Joon gasaa'¹³a unníi¹i. Joon wíin² ganí²in Abraham coon'¹³ La'². ");
INSERT INTO chqNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Joon ga'oo¹o jin'²in: “Nʉ'¹ʉ' Abraham, fúu² cwolíin²un jna. Síi²in La'² no cwoun'lá²xʉ unniicwoo²¹o coon'¹³ jmɨɨ²¹. Joon cwojaa²¹², cwouncwii'²¹xʉ unniisɨɨ'¹³ɨɨ tsʉ lɨ́ɨ¹ móo³oo wúu¹ jee²¹² jɨ́² lo.” ");
INSERT INTO chqNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Pe joon gajin'² Abraham: “Yʉʉn²¹ tyi', cwotii'¹³du‑'o'o 'áai¹ tyʉ́² 'íi¹‑'o'o mo gateen²¹²un fu juncwii²¹. Joon La'² logɨ 'áai¹ gó² gangɨɨ¹. Joon nano tyʉ́² seein²¹ lo. Joon 'nʉgɨ moo²'o wúu¹. ");
INSERT INTO chqNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Coon²¹gɨ 'e sá² lo. Sá² goon²¹ juu'¹³ cwó² jee²¹² jna'a coon'¹³ 'nʉ. Jileei'²¹ 'in 'iin²¹²in tsalíin² fu no jo lí². La joongɨ jileei'²¹ 'in 'iin²¹²in jalíin² lɨ' lo jo lí².” ");
INSERT INTO chqNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Joon gajin'² 'in tsá² sá² cuu² do: “Mɨ́ɨ³ɨɨ tyani'i jon, ñʉ'³ Abraham, sɨɨ²¹u La'² no fu tya' ñʉ'³ʉʉ. ");
INSERT INTO chqNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Seen²¹mo 'ñéei²gɨ ruu'²¹na. Cwofee'¹i la joon jon jo cwo'²o wa'a jalíin² lo 'a lɨ tyafo'² ní² tsá² wúu¹.” ");
INSERT INTO chqNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Pe joon gajin'² Abraham gasɨɨ'²¹ɨ 'ido: “'Oo¹‑o 'ido jilaa'²¹ 'e nigajin'² Moisés coon'¹³ tsá² cwo¹ júu³ tyʉ́². Lí²‑i unjii²¹o 'ido júu³ tya' 'ii.” ");
INSERT INTO chqNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Joon gañii¹ 'in tsá² sá² cuu² do: “'E ja'²mo, ñʉ'³ Abraham, pe wana tyíia¹ jee²¹² 'ii jaain²¹ 'in nigajúin² ija'²a‑tsi.” ");
INSERT INTO chqNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Joon gajin'² Abraham: “Wana jo 'iin²¹²in núu³ júu³ tya' Moisés coon'¹³ tsá² cwo¹ júu³ tyʉ́² jon'gɨ inúu²un júu³ tya' jaain²¹ 'in nigajiin'¹ jee²¹² 'lɨɨ²¹².” ");
INSERT INTO chqNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Gajin'²in jon Jesús gasɨɨ'²¹ɨ tsá² tya'a: ―'Láa²mo sá² 'e jmoo¹ un'leei'²¹ tsá² pe fúu² 'in tsá² jmoo¹ un'leei'²¹ 'in xeei'²¹ do. ");
INSERT INTO chqNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","'Áai¹gɨ tyʉ́² tya'a wa'a 'ñʉʉ¹ tsá² coon²¹ too¹ lúu¹u joon píin¹in tsi jmɨ'ñi'³ la coon²¹ jo jmáa¹a i'leei'²¹gɨ 'in xuui²¹² lo. ");
INSERT INTO chqNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Un'øøi'¹duu' yaanaa' coon'²¹ tún². ’Wana jmaa¹a ruu'²¹'u 'e gó² tyi'i joon fu'²'u: “Jo jmaa²gɨ'ɨ.” Joon wa gaunsɨ́ɨ²i 'e 'ɨ¹‑tsi jmáa² feei'¹‑'o'o 'wii²¹² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Xʉfiin'¹³ dyía¹ naa'¹³ la coon²¹ jmɨɨ²¹² gajmaa¹a 'ido 'e gó² tyi'i pe joon dyía¹ naa'¹³ cwooi¹ sɨɨ'²¹ 'nʉ: “Jo jmáa³gɨɨ.” Cwooi¹ jmaa²o'o feei'¹‑'o'o 'wii²¹² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Joon gajin'² tsá² tya' Jesús sɨɨ'²¹ 'ii: ―Jmáa² 'e lijai'²gɨ‑tsii'i 'nʉ. ");
INSERT INTO chqNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Joon gajin'² Jesús: ―Wuxʉ'ʉ tsáai¹du'‑'oo' fiin'¹³ la ti camɨ'³ jún² jon'² tasa lí²‑i fú²uu' 'e 'mó² fee'¹ lo: “Ráain²du'u no cwojñí²'i 'wo'o tsi jmɨ'ñi'³.” Joon ninúu²o 'e 'mó² do júu³ tyii'. ");
INSERT INTO chqNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’Wana 'in jee²¹² 'naa' seein²¹ jaain²¹ tsa'leei'¹³ tyii' 'in jaai'¹³ jee²¹² to², ngajii²¹i sɨ nga'aai¹ joo'²¹ 'ee, xʉfo'o fú²uu': “Ngɨɨi²¹², ní²'i, tyee'³ 'í¹.” ");
INSERT INTO chqNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Jon' la joon tɨ́ɨi² faa'²¹ tsá². Tyʉ́²gɨ isɨɨ'²¹ tsá² 'ii: “Tyá¹ tyʉ́² 'e døø'¹³øø. Cwoo'¹³‑'o'o tyá¹ tyʉ́² døø'¹³øø joongɨ 'e duu'¹³uu joon mi yuui'¹³ joon 'uu'¹²'u, cøø'¹²'ø.” ");
INSERT INTO chqNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Tɨ cwooi¹ cwo'¹o 'maai'¹³ tsa'leei'¹³ tya'a mo jmoo¹o jiin'¹³ to² 'e tyʉ'²ʉ? ");
INSERT INTO chqNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","La joon jon 'naa', mi yuui'¹³ jmaa²aa' jilaa'²¹ to² tyʉ'² Dios 'ná¹ fó²oo': “Tsa'leei'¹³ tyio'o jna'a 'in jo 'ee to² ti tsʉ nigajmoo²¹o'o jiin'¹³ 'e 'ná¹ jmoo²¹o'o.” ");
INSERT INTO chqNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Mo gangóo¹ Jesús la fu¹ 'yuui fu Jerusalén. Gangɨ́ɨ¹in la caain²¹ lɨ sii²¹ Samaria coon'¹³ Galilea. ");
INSERT INTO chqNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Mo gatyíi¹a coon²¹ fuu²¹ pi'³. Joon ga'wooi²¹ dyéi¹ tsá² 'in lɨ́ɨi¹ jmoowúu¹ jgøøi'²¹. Pe wíin² gajaan¹ lɨ siin'¹²in Jesús. ");
INSERT INTO chqNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Joon ga'oo¹o jin'²in: ―¡Jesús, Tɨfo'², fúu² cwolíin²un jna'a! ");
INSERT INTO chqNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Joon mo gajǿøi² Jesús 'ii joon gajin'²in: ―Cwolíin²naa' cwo'ee'¹³naa' untsá² yaanaa'. Joon la 'ɨɨ²¹² ngalíin² fu¹ joon ga'láa²mo. ");
INSERT INTO chqNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Joon jaain²¹ jee²¹² 'ii do mo ganí²i 'e ga'láa²mo joon gacɨɨ'¹³o cwoo¹o 'maai'¹³ Dios coon'¹³ júu³ tá² lɨɨlɨ¹. ");
INSERT INTO chqNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Joon gasii'²¹i wojníi¹i tyani Jesús. Joon gaxiia¹ níi¹i gajun'²un ca tɨ ni 'wó² 'e cwoo¹o 'maai'¹³ Jesús. Joon 'in tsá² lo seein²¹ lɨ sii²¹ Samaria. ");
INSERT INTO chqNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Joon gajin'² Jesús: ―¿Tɨ jo ga'láai² ce jɨ dyéi¹ do? ¿'Náai¹³gɨ 'in ñúi²gɨ do? ");
INSERT INTO chqNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Tɨ jiin'¹³ ino‑o tsá² coon²¹ fuu²¹ nigacɨɨ'¹³o cwoo¹o 'maai'¹³ Dios? ");
INSERT INTO chqNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Joon gasɨɨ'²¹ɨ 'in tsañʉʉ'¹ do: ―Ráan²un no. Cwei'². Niga'láa²mo'o tsʉ jo'²o galɨ́ɨ²u'u. ");
INSERT INTO chqNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Tsá² fariseo gaunngɨɨ¹ɨ Jesús lɨɨ²¹² mi cwá² 'e tyʉ'² Dios to². Joon gajin'² Jesús: ―Mi cwá² 'e tyʉ'² Dios to² joon'² wa'a coon²¹ 'e lí² jøǿ² tsá². ");
INSERT INTO chqNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Jo lí² wa'a jin'² tsá² 'elo sɨ 'e do‑o 'ee. Tsʉ nigalɨ́²‑ɨ 'e tyʉ'² Dios to² jee²¹² 'naa'. ");
INSERT INTO chqNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Joon gasɨɨ'²¹ɨ Jesús tsá² tya'a: ―Nicwaa²¹² jmɨɨ²¹² mi li 'iin²¹²naa' jǿø²øø' 'e jmɨɨ²¹² 'e jna‑a, 'in Ruu'²¹na Tsá², 'láa² 'wii²¹² tyʉ'²ʉ to². Joon jo lí² jǿø² 'naa'. ");
INSERT INTO chqNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Joon isɨɨ'²¹ tsá² 'naa': “Lo‑o siin'¹²in”, sɨ “Do‑o siin'¹³in”, 'ee. Pe jo cwolíin²naa' coon'¹³on. ");
INSERT INTO chqNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Tsʉ lawa coon²¹ jɨ́² cwaain² 'ñá³ 'e jná² joo'²¹ ca tɨ' cataain²¹ lɨ' caluu fu juncwii²¹ la joon jon jna 'in Ruu'²¹na Tsá² mi cwá² jmɨɨ²¹² tyiia. ");
INSERT INTO chqNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pe jéei¹ nifu 'ná¹ mó³oo wúu¹ lɨɨlɨ¹. Joon tsá² seein²¹ nano 'in jo 'e 'ii'²¹ jna. ");
INSERT INTO chqNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Jiin'¹³ la galɨ́² jmɨɨ²¹² mo seein²¹ Noé la joon jon ilí² jmɨɨ²¹² mi gó² jna 'in Ruu'²¹na Tsá². ");
INSERT INTO chqNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","'Gø'²ø tsá² joongɨ 'un'² tsá² joongɨ cui'² cwoo²¹ tsá². Joon gacwooi¹ tsá² jamɨ́ɨ¹ɨ 'e cui'² cwoo²¹ ca jmɨɨ²¹² mo ga'í² Noé fu tsi barco do. Joon gajó² coon²¹ jmɨ́¹ joon jilee'²¹mo gajúun²mo jon. ");
INSERT INTO chqNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","La joon galɨ́² mo seein²¹ jaain²¹ tsá² sii²¹ Lot. Gø'²ø joongɨ 'un'²un. Joon galó² joongɨ 'nɨɨ¹ɨ. Jñii¹ tsá² joongɨ jmoo'¹³ tsá² 'nʉ́¹. ");
INSERT INTO chqNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Pe mo gacwo'ɨ́ɨ¹ Lot 'e fuu²¹ Sodoma Dios gasii¹in coon²¹ jmɨ́¹ 'e lɨ́² jɨ́² caai'¹³ cuun²¹² 'e coo²¹. Joon gatsee²¹mo jileei'²¹ 'in néei¹ fuu²¹ do. ");
INSERT INTO chqNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","La joon ilí² mi jnee²¹na 'in Ruu'²¹na Tsá². ");
INSERT INTO chqNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Mo tɨ jmɨɨ²¹² joon wana 'in téein² yʉ' 'nʉ́¹ joon 'oo¹o jilaa'²¹ si'mo² inʉʉ tya'a jo cwoxaai¹ ja'woo'¹²o. Joon wa' 'in téein²¹ jee²¹² tyiia²¹ jo cwojaa'²¹i fu tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Cwotii'¹³‑'oo' 'e galí² tya' tsamɨ́² tya' Lot. ");
INSERT INTO chqNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Jileei'²¹ 'in 'iin²¹²in tiin'¹³ fu juncwii²¹ tya'a i'íin²mo joon. Pe jileei'²¹ 'in 'íin² fu juncwii²¹ tya'a tiin'¹³mo joon. ");
INSERT INTO chqNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’'E la ja'²mo fo'³oo: 'E 'woo¹ joon wana teei'¹³ gái¹ tsá² ni coo'mó² yatée³ee jaain²¹, 'in jaain²¹gɨ jan¹. ");
INSERT INTO chqNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Gái¹ tsamɨ́² taai²¹² tsii¹i caain²¹, yatée³ee jaain²¹ 'in jaain²¹gɨ jan¹. ");
INSERT INTO chqNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Gái¹ tsañʉʉ'¹ taain²¹² jee²¹² to² yatée³ee jaain²¹ 'in jaain²¹gɨ jan¹. ");
INSERT INTO chqNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Mo ganúu² tsá² tya'a 'elo joon gaunngɨɨ¹ɨ: ―¿Xiiala lɨ ilí² 'elo, Ña'ñʉ'¹ʉ'? Joon 'ii‑gɨ gajin'²in: ―Jileei'²¹ 'in jo cwoi¹ 'ña'a 'e tyʉ'² Dios to² 'ii i'íin²mo. ");
INSERT INTO chqNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Joon gasɨɨ'²¹ Jesús tsá² 'e cwáain¹ lo 'e 'ee¹ xiiala 'ná² faa'²¹a tsá² júu³ tyʉ́² joon jo cu'²‑tsi coon'¹³ Dios. ");
INSERT INTO chqNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Joon gajin'²in: ―Lawa coon²¹ fuu²¹ galiseein²¹ jaain²¹ tsá² jmoo¹o 'ii'²¹. Jo tsaa'²‑tsi Dios jon'gɨ un'goo²¹ tsá². ");
INSERT INTO chqNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Fuu²¹ do‑o jon seein²¹ jaain²¹ 'yiia'nɨ́ɨ² 'e coon²¹ tøø²mo tsafee'¹²i 'in tsá² jmoo¹o 'ii'²¹ do. Tsamɨɨ²¹ 'e jmaa¹ 'ido 'ii'²¹ coon²¹ mɨɨ'¹³ 'e seein²¹ coon'¹³ 'in 'eei'¹ 'ii. ");
INSERT INTO chqNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Wóo²‑o 'áai¹ nangóo¹ 'e jo 'iin²¹²in 'in tsá² jmoo¹o 'ii'²¹ do 'e jmáa¹a 'ii'²¹. Joon mo galicɨɨin²¹gɨ ga'ɨ¹‑tsi: “Jo tsaa'²‑tsii Dios jon'gɨ tsá² un'góo³oo pe tsʉ 'wii'¹³ untyíi²in 'in tsamɨ́² lo jna jmáa³oo 'ii'²¹ tya'a ");
INSERT INTO chqNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","la coon'²¹ jo untyíin²gɨ jna.” ");
INSERT INTO chqNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Joon gajin'² Jesús: ―Nʉ́ʉ²duu' 'e 'øøi'²¹‑tsi tsá² júu³ tya' 'in tsá² jmoo¹o 'ii'²¹ 'e gó² do. ");
INSERT INTO chqNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¿Tɨ lɨ́ɨ²naa' 'e li'ɨɨ²¹²‑i Dios un'øø'¹i tsá² tya'a, 'in nigatyii'¹²in, 'in nimɨɨ¹ɨ tyaníi¹i la 'woo¹ la jmɨɨ¹? ");
INSERT INTO chqNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Fuu²¹²uu 'naa' 'e la jmoono‑o ijmáa¹a 'ii'²¹ tya' 'ido. Pe jna‑a, 'in Ruu'²¹na Tsá² mi yíi³aa, ¿tɨ liseein²¹gɨ tsá² ni cwoo'¹³ juncwii²¹ 'in tsaa'²gɨ‑tsi jna? ");
INSERT INTO chqNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Gasɨɨ'²¹ɨ jon Jesús coongɨ cwáain¹ tya' 'inlɨ́ɨi¹³ 'in jmaai'²¹ yaai 'e tyú¹‑i joon un'woo¹i tsá² catyaai²gɨ. Joon jin'²in: ");
INSERT INTO chqNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Gái¹ tsañʉʉ'¹ ngalíin² fu cwo'¹. Ngafaa'¹³a júu³ tyʉ́². Jaain²¹ jee²¹² 'ii lɨ́ɨ¹i tsá² fariseo, 'in jaain²¹ dogɨ lɨ́ɨ¹i tsá² cón² 'laa'¹³ 'e 'nɨɨ¹ tsá². ");
INSERT INTO chqNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","'In tsá² fariseo do siin'¹²in, joon gafaa'²¹a la lo: “Ña'ñʉ'¹ʉ' Dios, cwóo³oo 'maa²u'un tsʉ² jo lɨ́ɨ¹na la lɨ́ɨi¹ 'in tsá² catyaai² do. Jo lɨ́ɨ¹na la 'in jmoo¹o 'uun²¹, lagɨ 'in jo nʉʉ'¹³. Jo lɨ́ɨ¹na la lɨ́ɨi¹ tsá² 'in fee'²¹i tsamɨ́². Ce jiin'¹³ capii'³ jo lɨ́ɨ¹na la lɨ́ɨi¹ 'in cón² 'laa'¹³ 'e 'nɨɨ¹ tsá² lo. ");
INSERT INTO chqNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Tún² fu 'gø'³øø tyiiañi'¹ la coon²¹ semóo¹³. Joon cwo'³oo 'nʉ coon²¹ 'e jee²¹² dyá² 'ii'¹³ 'e gajna'²aa.” ");
INSERT INTO chqNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Pe 'in tsá² cón² 'laa'¹³ 'e 'nɨɨ¹ tsá² do wíin² gajaan¹. Joon jo tá²‑tsi saa'¹²a unníi¹i fu yʉ' juncwii²¹. Jiin'¹³ 'e gajmaa¹a tyʉʉn¹ nitsi¹‑o. Joon gafaa'²¹a: “Ña'ñʉ'¹ʉ' Dios, cwolifee'¹mo‑'o'o 'wii²¹² tyiia tsʉ 'áa¹mo røø²¹na tsaa².” ");
INSERT INTO chqNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","'E la ja'²mo fo'³oo 'e nigauntyú¹mo Dios 'in tsá² cón² 'laa'¹³ tya' 'e 'nɨɨ¹ tsá² do pe 'in jaain²¹ do jiin'¹³ la lɨ́ɨ²mo lɨ́ɨ²i. Tsʉ jileei'²¹ 'in jmaa'²¹i yaai cøø'¹³gɨ xʉjoon li'weei²¹gɨ 'ii pe jileei'²¹ 'in un'weei²¹ yaai joon licøøi'¹³gɨ. ");
INSERT INTO chqNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Jajée¹mo tsá² xuui²¹² tya'a lɨ siin'¹² Jesús 'e taan¹ cwoo²¹ tya' 'ido. Pe joon mo ganí¹ tsá² tya'a ga'láa² 'wii²¹² 'ǿø¹³mo jileei'²¹ 'in jajéei¹ xuui²¹² do. ");
INSERT INTO chqNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Joon gatø'¹ Jesús 'in xuui²¹² do. Joon gajin'²in: ―Cwóo²oo' cwojalíin² xuui²¹² tyaní³ii joon jo 'øø²¹²naa' tsʉ lɨ tyʉ'² Dios to² líin² jmai'² 'in líi¹in la 'ii‑o jon. ");
INSERT INTO chqNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","'E la ja'²mo fo'³oo jileei'²¹ 'in jo cwooi¹ 'e tyʉ'² Dios to² 'ii lawa jaain²¹ xuui²¹² jo lí² tsataai² lɨ tyʉ'² Dios to². ");
INSERT INTO chqNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Jaain²¹ 'in tyʉ'² to² gaungɨɨ¹ɨ Jesús: ―Tɨfo'² tyúi¹, ¿'ee 'ná² jmáa³aa 'e tiin'¹³na juncwii²¹ tyiia? ");
INSERT INTO chqNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Joon gasɨɨ'²¹ Jesús 'ii: ―¿'Ee lɨ'ɨ fu'²'u jna 'in tyúi¹? Jaan²¹mo 'in tyúi¹ seein²¹gɨ, jiin'¹³ 'ña'a Dios. ");
INSERT INTO chqNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ñí³o'o jiin'¹³ la to² tyʉ'² Moisés: “Jo foo'¹³'o tsamɨ́². Jo jngáa¹u'un tsá². Jo jmaa²'a 'uun²¹. Jo jmaa²'a júu³ tajuu²¹. La joon jo con'²'on tsá² tóo² ce jiin'¹³ jaain²¹. Cwoli'gøø'²¹mo'o ñʉ'²'ʉ coon'¹³ saa²'a.” ");
INSERT INTO chqNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Joon gajin'² 'in tsañʉʉ'¹ do: ―Jilaa'²¹ 'elo nigalinʉʉ'¹³ʉʉ ca la mo xuu²¹²moo. ");
INSERT INTO chqNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Moganúu² Jesús 'elo joon gajin'²in: ―Coon²¹gɨ 'e 'ná² jmaa²'a. 'Nɨ́³'ɨ jilaa'²¹ 'e 'oo²‑o'o joon cwo'²'o tsá² tañíi². Joon lɨ́ɨ¹gɨ ili'oo²‑o'o ñʉ'fú². Mi yuui'¹³ joon na¹ coon'¹³ jna. ");
INSERT INTO chqNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Pe mo ganúu² 'in tsanʉʉ'¹ do 'elo 'áai¹ fa'í³ gajmaa¹a tsʉ 'áa¹mo sá² cuu² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Mo ganí² Jesús xiiala fa'í³ jmaa¹a joon gajin'²in: ―¡'Áa¹mo tyan¹ to² cwóoi¹ tsá² sá² cuu² yaai wa'a tyʉ'² Dios to² 'ii! ");
INSERT INTO chqNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","'Áai¹gɨ tyan¹ to² tya' jaain²¹ camello 'e ngɨ́ɨi¹ too²¹ lɨ ngɨ́i¹ ñi¹ tya' moocúu³ lagɨ jaain²¹ tsá² sá² cuu² tsa'ii¹in ñʉ'fú². ");
INSERT INTO chqNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","'In ganúu² 'elo gajin'²in: ―¿Xiiagɨ la itiin'¹³ tsá²? ");
INSERT INTO chqNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Joon gajin'² Jesús: ―Jilaa'²¹ 'e jo lí² jmaa¹a tsañʉʉ'¹ lí²‑i jmá¹ Dios. ");
INSERT INTO chqNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Joon gajin'² Tʉ́³: ―Ña'ñʉ'¹ʉ', jna'a nigatʉʉ²¹²oo'o jilaa'²¹ 'e 'oo²¹o'o joon nijalii²¹i'i coon'¹³ 'nʉ. ");
INSERT INTO chqNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Joon gajin'² Jesús: ―'E la ja'²mo fo'³oo, 'e doñi'iin sɨ tʉʉ²¹ 'nʉ́ʉ¹ʉ sɨ tiui² sáa³a jmɨɨ²¹ 'ee sɨ ruu'²¹i 'ee sɨ tsamɨ́² tya'a 'ee sɨ jóon¹ 'ee 'wii²¹² tya' cwáain¹ 'e tyʉ'² Dios to² ");
INSERT INTO chqNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","lɨ́ɨ¹gɨ 'ii'²¹i fu juncwii²¹ lo. Joon mi júun²in 'ii'²¹mo jon coon²¹ juncwii²¹ tya'a 'e ta'²a coon²¹ tøø²mo. ");
INSERT INTO chqNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesús gatø'¹ø coon'²¹ jɨ dyatuuin¹ tsá² tya'a joon gasɨɨ'²¹ɨ 'ido: ―Nano tsaa²¹a' fu Jerusalén. Do‑o lí² tsín¹ jilaa'²¹ 'e gafaa'²¹a tsá² gacwo¹ júu³ tyʉ́² calɨɨ cwáain¹ tya' 'in Ruu'²¹na Tsá². ");
INSERT INTO chqNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ijaan'²¹in tsá² 'ii tyani tsá² jalíin² wíin². Joongɨ niungøøi¹ tsá² 'ii. Joon ijmee'²¹i tsá² 'ii. Joongɨ i'ñí¹ tsá² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Joongɨ ipóoi² tsá² 'ii. Mi yuui'¹³ joon ijnga'²mo tsá² 'ii. Pe mi tɨ́² 'nɨ¹ jmɨɨ²¹² ijiin'¹o jee²¹² 'lɨɨ²¹². ");
INSERT INTO chqNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Pe 'idogɨ coonti jo ga'øøi'²¹‑tsi. Jo ñi¹ 'ee 'e sɨɨ'²¹ Jesús 'ii. Lawa coon²¹ júu³ 'e jo ñi¹ xiiala 'ee i'øøi'²¹‑tsi. ");
INSERT INTO chqNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Xʉʉ 'ná²gɨ 'e tyíi¹a Jesús fuu²¹ Jericó. Jaain²¹ tsá² tiui² tyíin¹in caai¹ fu¹ mɨɨ¹ caridad. ");
INSERT INTO chqNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Mo ganúu²un ningɨ́ɨ¹i tsá² fúui¹ lɨɨlɨ¹ joon gaunngɨɨ¹ɨ tsá² 'ee‑gɨ galɨ́². ");
INSERT INTO chqNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Joon gajin'² tsá² 'e Jesús tsá² Nazaret 'in ngɨ́ɨ¹i no. ");
INSERT INTO chqNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Joon ga'oo¹o 'in tsá² do jin'²in: ―¡Jesús, Jóon¹ David, fúu² cwolíin²un jna! ");
INSERT INTO chqNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Pe 'in tsá² do 'in ngalíin² nifu gasɨɨ'²¹ɨ 'ido: ―Ca tii², jo to'²'o mɨɨ'¹³. Joon jo cwofaa'²¹gɨ 'ido. Pe 'ii coon'²¹ 'ii'¹³gɨ tá² 'oo¹o: ―¡Jóon¹ David, fúu² cwolíin²un jna! ");
INSERT INTO chqNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Joon gajan¹ Jesús joon gatyʉ'²ʉ to² 'e tsatee²¹² tsá² 'ido. Joon mo gatyíi¹a tyan'² joon gaunngɨɨ¹ɨ Jesús 'ii: ");
INSERT INTO chqNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿'Ee 'iin²¹²u'un ijmáa³aa tyi'i? Joon gañi¹ 'in tsá² tiui² do: ―Ña'ñʉ'¹ʉ', 'iin²¹²na ijǿø³oo. ");
INSERT INTO chqNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Joon gajin'² Jesús: ―Jǿø²o'o tsʉ 'wii'¹³ nigalija'²mo lɨ́ɨ²u. ");
INSERT INTO chqNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Joon la tsifu joon 'in tsá² tiui² do gajǿø²o. Joon gangóo¹o coon'¹³ Jesús cwo'²o 'maai'¹³ Dios. Joon jileei'²¹ tsá² 'in gajǿø² 'elo la joon jon gacwo'²o 'maai'¹³ Dios. ");
INSERT INTO chqNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Joon ga'í² Jesus fuu²¹ Jericó. ");
INSERT INTO chqNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Joon do‑o niseein²¹ jaain²¹ tsá² sá² cuu² 'in ni sii²¹ Zaqueo. 'Ii tyʉ'² to² jileei'²¹ 'in cón² 'laa'¹³ 'e 'nɨɨ¹ tsá². ");
INSERT INTO chqNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","'In Zaqueo lo 'iin²¹²in jǿø²i Jesús. 'Iin²¹²in licwii¹in pe jo lí² tsʉ lɨ́ɨ¹ pi'³ 'ii. Joon lɨ́ɨ¹ fúui¹ tsá² taai². La 'ɨɨ²¹² ngɨ́ɨ¹i Jesús 'e fuu²¹ do ");
INSERT INTO chqNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","joon gangóo¹ Zaqueo do cwiin¹in nifugɨ 'e 'iin²¹²in jǿøi². Joon gasoo² coon²¹ yʉ' 'mó² si'² co'² fu¹ lɨ 'ná² ngɨ́ɨ¹i Jesús. ");
INSERT INTO chqNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Joon mo gangɨ́ɨ¹i 'ido joon gajǿø² fu yʉ'. Joon gajin'²in: ―Zaqueo, cwúui¹ jmoono tsʉ no 'ná¹ níi³ii nijáan³aan fu tyio'o. ");
INSERT INTO chqNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Joon gajngáa¹i Zaqueo jmoono. Joon lɨ́ɨ¹ jløø'³i ga'ii'²¹i Jesús. ");
INSERT INTO chqNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Mo ganí² 'in tsá² fariseo do jilaa'²¹ 'elo joon ga'láa² 'wii²¹² gafaa'²¹a 'laa'²¹ tya' Jesús joon jin'²in 'e Jesús nigajaan¹ tya' jaain²¹ tsá² rǿøi² tsaa². ");
INSERT INTO chqNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Joon Zaqueo do gajmaa¹a siin'¹²in joon gasɨɨ'²¹ɨ Jesús: ―Jǿø²dʉ, Ña'ñʉ'¹ʉ', cwo'³oo tsá² tañíi² coon'¹³ tsa'² jíin¹³ 'e 'óo³oo. Joon wana nigajmáa³aa 'uun²¹ coon'¹³ júu³ tajuu²¹ nicɨ́ɨ³oo tyʉ́n² 'ii'¹³gɨ lɨ́ɨ¹. ");
INSERT INTO chqNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Joon gajin'² Jesús: ―No‑o gatyía¹ 'e tiin'¹³ tsá² taai² inʉʉ lo. No‑o ilíin² 'in tsañʉʉ'¹ lo jún² tya' 'lɨɨ²¹² Abraham. ");
INSERT INTO chqNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Tsʉ jna, 'in Ruu'²¹na Tsá², gagoo²¹²oo 'e 'naa'²¹na tsá² joongɨ 'e jmóo³oo tiin'¹³ tsá² 'in rǿøi² tsaa². ");
INSERT INTO chqNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","La 'ɨɨ²¹² núu²un tsá² júu³ tya' Jesús faa'²¹a 'e júu³ lo joon gasɨɨ'²¹ɨ coon²¹ cwáain¹ tsʉ tyan'¹ niteein¹ co' Jerusalén. Tsʉ 'in tsá² fúui¹ ngɨ́¹ coon'¹³ Jesús do tya'i fu¹ lɨ́ɨ²i 'e tɨ li tɨ́² 'e tyʉ'² Dios to² tsá². ");
INSERT INTO chqNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Joon gasɨɨ'²¹ɨ Jesús 'ido: ―Lawa jaain²¹ tsá² 'in lɨ́ɨi¹ tsafeei'¹. Joon gangóo¹ coon²¹ fuu²¹ wíin² i'ii'²¹i to² rǿøi¹³ 'e fuu²¹ wíin² do. Joon mi yuui'¹³ joon cɨɨ'¹²ɨ fuu²¹ goo¹o. ");
INSERT INTO chqNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Pe la nʉ'gɨ cwo'ɨ́ɨ¹ɨ gatø'¹ø dyéi¹ tsa'leei'¹³ tya'a. Joon gajoon'²¹o la jaain²¹ la jaain²¹ 'ido jmaai'¹³ coon²¹ cuu² 'e tyíin² lɨ́ɨ¹. Joon gasɨɨ'²¹ɨ 'ido: “Jmaa²aa' to² coon'¹³ 'e cuu² lo ca mi cwaa'²¹na.” ");
INSERT INTO chqNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Pe tsagoo¹o do 'ee'¹mo 'ii. Joon gasii¹in júu³ ca lɨ ngóo¹on 'e jin'²: “Jo 'iin²¹²na'a wa'a líin² 'in tsañʉʉ'¹ lo rǿøi¹³ tyii'i.” ");
INSERT INTO chqNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Pe ga'ii'²¹mo to² rǿøi¹³ do. Joon ganga'²mo fu goo¹o. Joon mo gatyee'¹²i joon gatø'¹ø tsa'leei'¹³ tya'a 'in ngacwo'²o cuu² do. 'Iin²¹²in litsáai¹‑tsi xiiati nigajna'²a la jaain²¹ 'ido. ");
INSERT INTO chqNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","'In gatyía¹ nifu gajin'²in: “Ñi'fii²¹i', 'e cuu² do nigacwáa¹mo dyá²gɨ.” ");
INSERT INTO chqNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Joon 'in rǿøi¹³ do gajin'²in: “'Áa¹mo tyʉ́². Jaain²¹ tsa'leei'¹³ tyú¹mo 'nʉ. Nano, 'wii'¹³ 'e nigalityú¹mo'o coon'¹³ 'e xʉʉ, cwóo³oo 'e tyʉʉ'¹²'ʉ to² jee²¹² dyá² fuu²¹.” ");
INSERT INTO chqNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","'In xeei'²¹gɨ gatyía¹ joon gajin'²in: “Ñi'fii²¹i', 'e cuu² do nigacwáan¹mo 'ñá²gɨ.” ");
INSERT INTO chqNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","La joon jon gasɨɨ'²¹ɨ 'in rǿøi¹³ do 'ii: “'Nʉ‑gɨ lí² tyʉʉ'¹²'ʉ to² 'ñá² fuu²¹.” ");
INSERT INTO chqNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Joon 'in xeei'²¹gɨ gatyía¹. Joon gajin'²in: “Ñi'fii²¹i', lo‑o roon¹ 'e cuu² do. Ga'máa³oo gacɨ'¹ɨɨ coon²¹ póo¹. ");
INSERT INTO chqNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Galɨ'gøø'²¹moo 'nʉ tsʉ jaain²¹ tsá² 'waa'²¹‑tsi 'nʉ. Joon ñí³oo 'e cóon¹³o'o 'e jo gacwo'²'o. Joon coon'¹²'on lɨ jo gajñi'²'in.” ");
INSERT INTO chqNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Joon gajin'² rǿøi¹³ do: “Tsa'leei'¹³ 'in gó² 'nʉ. Coon'¹³ júu³ tyiio'o jmoo²'o 'ii'²¹ tyi'i. Ñí²'i 'e lɨ́ɨ¹na jaain²¹ tsá² 'waa'²¹‑tsi. Joon cón³oon lɨ jo 'e gacwóo³oo. Joongɨ cón³oo coon²¹ lɨ jo 'e gajñii²¹²ii. ");
INSERT INTO chqNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿'Ee lɨ jo gata'²'a cuu² banco joon lí² 'ii'¹³na láai²gɨxʉ mi tyee'¹²na tyiia?” ");
INSERT INTO chqNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Joon gajin'² rǿøi¹³ do sɨɨ'²¹ɨ 'in téein² do: “Tyí²ii' 'e cuu² no. Joon cwó²oo' 'in 'oo¹ dyá² no.” ");
INSERT INTO chqNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Joon gajin'² 'in téein² do: “Pe ñi'fii²¹i', ni'oo¹o 'ido dyá² cuu².” ");
INSERT INTO chqNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Joon gañii¹i 'in rǿøi¹³ do: “Fuu²¹²uu 'naa': jileei'²¹ 'in 'oo¹o lɨ́ɨ¹gɨ, la joon lɨ́ɨ¹gɨ icwóo³oo. Pe jileei'²¹ 'in jo 'oo¹o lɨ' 'woo'¹³gɨɨ 'e ca pi'³ 'e 'oo¹o. ");
INSERT INTO chqNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Joon jileei'²¹ 'in 'eei'¹ jna, 'in jo 'iin²¹²in jmáa³aa rǿøi¹³ tya'a cwotee²duu' lo joon jngaa'¹³naa' tyaní³ii lo.” ");
INSERT INTO chqNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Mo ngayuui'¹³ gajin'² Jesús 'elo joon gangóo¹ la fu 'yúu¹i fu Jerusalén. ");
INSERT INTO chqNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Xʉʉ 'ná²gɨ tyíi¹a fuu²¹ Betfagé coon'¹³ Betania co' moo'²¹ sii Olivos. Joon gasii¹in gái¹ tsá² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Joon gasɨɨ'²¹ɨ 'ido: ―Cwolíin²naa' 'e fuu²¹ pi'³ náa¹ tyan'² do. Joon mi tyalíin²naa' joon ityee'²naa' jaain²¹ bu'³ neei²¹². Ce jiin'¹³ jaain²¹ jo 'in mo cwó². Sii'¹³ 'nii²¹² tya'a joon tǿ²øø' fu lo. ");
INSERT INTO chqNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Joon wana 'in gajin'²in: “¿'Ee lɨ'ɨ sii'¹³ii' 'nii²¹² tya'a?” Joon fú²uu': “'Néi²ta cata Ña'ñʉ'¹ʉ'.” ");
INSERT INTO chqNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Joon ngalíin²mo tsá² tya'a. Joon gatsee'²¹mo jiin'¹³ la lɨ́² 'e nigajin'² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Joon teen²¹²mo si'¹i 'nii²¹² tya' bu'³ do joon gaunngɨɨ¹ɨ 'in tsá² fii²¹² do: ―¿'Ee lɨ'ɨ sii'¹³ii' 'nii²¹² tya' bu'³ no? ");
INSERT INTO chqNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","'Idogɨ gañii¹i: ―Ña'ñʉ'¹o' 'néi²ta cata. ");
INSERT INTO chqNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Joon gatøø²¹o 'ido tyani Jesús. Joon gaunfuu²¹ sɨɨn'¹³ɨn moo'wóo¹ bu'³ do. Joon gatyée¹e Jesús moo'wóo¹ bu'³ do. ");
INSERT INTO chqNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","La 'ɨɨ²¹² ningóo¹ Jesús joon ganii'¹³ tsá² sɨɨn'¹³ɨn tya'i fu¹. ");
INSERT INTO chqNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Mo gatɨ́² lixaai¹ moo'²¹ Olivos jileei'²¹ tsá² jo'² lɨ́ɨi² 'in ngalíin² coon'¹³on ga'láa² 'wii²¹² ga'oo¹ jløø'³i. Joongɨ gauntyúu¹i Dios coon'¹³ jilaa'²¹ milagro 'e niganí²i. ");
INSERT INTO chqNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Joon jin'²in: ―¡'In cwaa'³mo Rǿøi¹³ 'in jó¹ coon'¹³ júu³ tya' Ña'ñʉ'¹ʉ'! ¡Tyʉ́²‑ʉ 'íi¹ ñʉ'fú²! ¡'In tyú¹mo Dios! ");
INSERT INTO chqNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Joon 'inlɨ́ɨi¹³ tsá² fariseos 'in téein² jee²¹² 'in tsá² do gasɨɨ'²¹ɨ 'ido: ―Sii'¹³ tsá² ngɨ¹ coon'¹³ 'nʉ 'e jo cwota'²a lɨ́¹ mɨɨ'¹³. ");
INSERT INTO chqNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Joon gajin'² Jesús: ―'E la ja'²mo fo'³oo, wana 'inlo 'e jo to'²o mii'¹³ cagɨ 'e cuun²¹² roon¹ lo ito'²o mɨɨ'¹³. ");
INSERT INTO chqNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Mo gatyíi¹a tyan'² gajǿø²ø Jesús fuu²¹ Jerusalén joon gatyi'²i 'wii²¹² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Jin'²in: ―Wuxʉ'ʉ 'øøi'²¹‑'oo' fiin'¹³xʉ. Jmɨɨ²¹² no‑o jmɨɨ²¹² tyii', 'in jmá¹ 'ii'²¹ rǿø² tyii' nigacwéi¹. Pe nano 'e sɨ'mo². Joon jo lí² jǿø²øø'. ");
INSERT INTO chqNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Pe ijó² coon²¹ jmɨɨ²¹² 'e gó² tyii' mi jalíin² tsá² 'in 'eei'¹ 'naa'. Joon ijmáa¹a coon²¹ po'³ cwoo'¹³ ñíi¹ cu'² lɨ' lɨ née¹naa'. Joon nitsatáai² joon nijmeei'²¹ 'naa' la 'uui². ");
INSERT INTO chqNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Joon ifíin² 'e fuu²¹ lo tɨ ni'wó². Itsajngaa'¹³i tsá² néei¹ lɨ tsi joon jo isái²gɨ jiin'¹³ coon²¹ cuun²¹² 'e sɨfúui¹ tsʉ jo galiñii² 'naa' mo gajó² Dios itiin'¹³ 'naa'. ");
INSERT INTO chqNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Joon ga'ii²¹ Jesús tsi inʉʉ cwo'¹ fee'¹ si'² Jerusalén do joon ga'láa² 'wii²¹² ga'ǿø¹i 'in 'nɨɨ¹ coon'¹³ jileei'²¹ 'in ló¹. ");
INSERT INTO chqNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Joon gajin'²in gasɨɨ'²¹ɨ 'in taai² do: ―Ni jí² tya' Dios jin'²: “'Nʉ́³ʉʉ 'elo lɨ tsalíin² tsá² tsafee'¹³i Dios pe 'naa'gɨɨ' nigajmaa²aa' lawa coon²¹ too²¹ xá² tya' 'uun²¹.” ");
INSERT INTO chqNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","La coon²¹ jmɨɨ²¹² ga'ee¹ Jesús inʉʉ cwo'¹ fee'¹ do. Pe tsá² tyʉ'² to² tya' untsá² coon'¹³ tɨfo'² tya' ley la joon jon 'in tyʉ'² to² fuu²¹ do 'noo'²¹o xiiala ijngaa'¹³i Jesús. ");
INSERT INTO chqNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pe jo 'e tyii'²a xiiala ijmáa¹a tsʉ jilee'²¹mo tsá² taai² jløø'³mo núu²o. ");
INSERT INTO chqNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Coon²¹ jmɨɨ²¹² 'yuu²i Jesús fu tsi inʉʉ cwo'¹ fee'¹ 'e 'e'²e tsá². Joon cwoo¹ júu³ tyʉ́² tya' 'e tiin'¹³ tsá². Joon gatyalíin² 'in tyʉ'² to² tya' untsá² coon'¹³ tɨfo'² tya' ley coon'¹³ tsacøøi'¹³. ");
INSERT INTO chqNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Joon gajin'²in sɨɨ'²¹ɨ Jesús: ―Jmáa²du'u júu³, ¿'ee coon'¹³ to² 'e jmoo²'o jilaa'²¹ 'elo? ¿'Iin gacwo'² 'nʉ 'e to² do? ");
INSERT INTO chqNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Joon gañii¹i Jesús: ―La joon jon jna unngɨɨ¹duu 'naa'. Ñii²duu': ");
INSERT INTO chqNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿'Iin gasii¹in Wó³ saai¹ tsá² jmɨɨ²¹? ¿Tɨ gasii¹in Dios 'ii owa'a tsá² 'ee? ");
INSERT INTO chqNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Joon ga'láa² 'wii²¹² jo cwo'²o júu³ ruu'²¹i jee²¹² 'ii. Jin'²in: ―¿'Ee faa²a'? Wana faa²a' 'e Dios gasii¹in, joon iñii¹i: “¿'Ee lɨ' jo 'ii'¹³naa' júu³ tya'a?” ");
INSERT INTO chqNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Joon wana faa²a' 'e tsá²‑a jilee'²¹mo tsá² ityuu'¹²i jna' cuun²¹² tsʉ tsáai¹‑tsi tsá² 'e faa'²¹ Wó³ do cwáain¹ tya' Dios. ");
INSERT INTO chqNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Joon gañii¹i jin'²in: ―Jo nee²e'e 'iin gasii²in Wó³ saai¹ tsá² jmɨɨ²¹. ");
INSERT INTO chqNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Joon gajin'² Jesús: ―La joon jon jna jofo'³oo 'ee coon'¹³ to² 'e jmóo³oo 'elo. ");
INSERT INTO chqNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Joon ga'láa² Jesús 'wii²¹² gafaa'²¹a. Joon gasɨɨ'²¹ɨ tsá² 'e cwáain¹ lo: ―Lawa jaain²¹ tsañʉʉ'¹ 'in gajñi¹ wuunjøø'³ cwoo'¹³ 'wó² tya'a. Joon gacwo'²o 'áai¹ tsá² xee'²¹mo. Joon gangóo¹ lɨ xiia'²¹. Wóo² gali'ɨ́ɨ¹i. ");
INSERT INTO chqNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Joon la jee²¹² joon gatɨ́² jiin²¹ 'e garoo²¹ mɨ'² wuunjøø'³ do. Joon gasii¹in jaain²¹ tsa'leei'¹³ tya'a 'e tsamɨ́ɨ¹ɨ tya' 'in jmoo¹o to² do jiin'¹³ 'e gatɨ́ɨi² tya' fii²¹² cwoo'¹³ 'wó² do. Pe 'idogɨ gajmee'²¹mo 'ido. Joon gasiin'¹³mo 'ido tún¹ jo 'ee gacwo'²o coonti. ");
INSERT INTO chqNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Joon 'in tsá² fii²¹² do gasii¹in jaain²¹gɨ tsa'leei'¹³ tya'a. La joon jon 'ido gajii²i. Gajmee'²¹mo 'ido. Joon gasiin'¹³mo jon jo 'ee gacwo'²o coonti. ");
INSERT INTO chqNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Joon 'in tsá² fii²¹² do gasii¹in 'in xeei'²¹gɨ. Pe 'idogɨ la joon jon gajmee'²¹i. Joon ga'wooi¹ caluu. ");
INSERT INTO chqNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Mo gangɨ́ɨ¹ 'elo 'in tsá² fii²¹² 'wó² do ga'ɨ¹‑tsi: “¿'Ee jmáa³aa no? Isɨ́ɨ³na yʉʉn²¹ tyiia 'in 'iin²¹²na 'áai¹. Joon mi ní²i yʉʉn²¹ tyiia foowa nijmaa¹o nʉʉ'¹³ʉn.” ");
INSERT INTO chqNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pe joon mo ganí²i 'in tsá² jmoo¹o to² do 'ido joon gasɨɨ'²¹ɨ ruu'²¹i: “'In lo‑o 'in 'ii'²¹ 'e sá² tya' jmii²¹. Cwojngaa'¹³na' 'ii joon jna'o' ilíin²na' fii²¹² 'wó² do.” ");
INSERT INTO chqNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Joon gatyii¹mo caluu joon gajngaa'¹³mo. Joon gaunngɨɨ¹ɨ Jesús: ―¿'Ee cwooi¹ jmaa¹o 'in fii²¹² cwoo'¹³ 'wó² do coon'¹³ 'in tsá² do? ");
INSERT INTO chqNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Itsaa¹o joon tsajngaa'¹³i 'in tsá² jmoo¹o to² do. Joon cwo'²o 'in xee'²¹mo cwoo'¹³ 'wó² do. Mo ganúu²un 'in tsá² taai² do 'elo joon gajin'²in: ―¡Jo cwo¹ Dios ingɨɨi¹ 'elo! ");
INSERT INTO chqNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Joon gajǿø²i Jesús 'ii. Joon gajin'²in: ―¿'Ee cwooi¹ 'øøi'²¹‑tsi tsá² 'e júu³ taa'¹³ jí² tya' Dios? 'E jin'²: 'E cuun²¹² 'e nigapí² tsa² jmoo'¹³ 'nʉ́¹ 'e joon galɨ́² cuun²¹² nifu. ");
INSERT INTO chqNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Doñi'iin gatøøi'²¹ ni cuun²¹² do li'no'²o 'ii. Joon wana gatoo'²¹ 'e cuun²¹² do tya' tsá² fu² ilíin². ");
INSERT INTO chqNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","'E jmɨɨ²¹² joon 'in tyʉ'² to² tya' untsá² coon'¹³ tɨfo'² tya' ley 'iin²¹²in saan'¹in Jesús do. Tsʉ nii¹o 'e cwáain¹ 'e nagafaa'²¹ Jesús do cwáain¹ tya' 'ii‑o. Pe 'gøø'²¹mo tsá². ");
INSERT INTO chqNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Joon gasii¹in tsá² lawa tsá² tyúi¹ 'e tsasii'¹³i coon'¹³ júu³ tajuu²¹ lawa júu³ jai'² wa ilí² cwoo¹o tsaa² coon'¹³ júu³ tya'a. Joon ijaan'²¹in tyani 'in 'oo¹ to². ");
INSERT INTO chqNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Joon gaunngɨɨ¹ɨ: ―Tɨfo'², ne²oo'o 'e fo'²'o joongɨ 'e'²'e júu³ jo'². Jmoo²'o 'ii'²¹ rǿø². Jo con'²'on cwáain¹ wa tsá² sá² cuu² sɨ tsá² tañíi² 'ee. Jiin'¹³ fu¹ tyʉ́² tya' Dios 'e'²'e. ");
INSERT INTO chqNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Sii'¹³ jna'a, ¿tɨ cwooi¹ tyí²i' 'laa'¹³ tya' tsaa'to² tyíin¹ Roma? ¿Cwooi¹ owa jo cwooi¹ 'ee? ");
INSERT INTO chqNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Pe galili'³i Jesús jilaa'²¹ 'e gó² 'e 'ɨ¹‑tsi 'ido. Joon gasɨɨ'²¹ɨ 'ido: ―¿'Ee lɨ'ɨ jmaa²aa' lawa coon²¹ nilá² coon'¹³ júu³ tajuu²¹? ");
INSERT INTO chqNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","La 'ée¹duu' jna coon²¹ cuu², nee²¹e'. ¿'Iin ni² 'inlo? ¿'Ee tyan¹ 'e sii²¹ 'in taai² lo? Joon gañii¹i 'in tsá² do: ―Tya' tsaa'to² tyíin¹ Roma. ");
INSERT INTO chqNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Joon gajin'² Jesús: ―Cwoo²oo' tsaa'to² jiin'¹³ 'e tɨ́ɨi² joon cwoo²oo' Dios jiin'¹³ 'e tya'o. ");
INSERT INTO chqNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Joon jo galɨ'¹ɨ wa'a 'e teei'²¹ Jesús jiin'¹³ coon²¹ tsaa² coon'¹³ jilaa'²¹ 'e faa'²¹a jee²¹² tsá². Lɨ' cɨɨ'¹²ɨ, ganga'goo²¹o‑tsi tsá² coon'¹³ jilaa'²¹ 'e faa'²¹a. Joon gajaan¹ tii². ");
INSERT INTO chqNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Mo ngayuui'¹³ joon 'inlɨ́ɨi¹³ tsá² saduceos gangaliin¹ ngajǿøi² Jesús. Tsá² saduceos jin'²in 'e jo jo'² jiin'¹gɨ tsá² mo najúun²in. Joon gajin'²in sɨɨ'²¹ɨ Jesús: ");
INSERT INTO chqNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Tɨfo'², Moisés gataan¹ ni jí² tya'a 'e júu³ lo: “Wana jaain²¹ tsañʉʉ'¹ júun²in joon gatʉ́ʉ² tsamɨ́² tya'a 'ña'a jiin'¹³ jaain²¹ jóon¹ jo seein²¹. Ruu'²¹i 'in najóin¹ 'ná² cu'²i cwoo²¹ coon'¹³ 'in tsamɨ́² 'ña'a do. Joon liseein²¹ yʉʉn²¹ cwáain² tya' ruu'²¹i najóin¹ do.” ");
INSERT INTO chqNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","La joon galɨ́² dyái¹ ruu'²¹i seein²¹. 'In nifu gacu'²mo cwoo²¹. Joon jo 'in yʉʉn²¹ liseein²¹ tya'a. Gajúun¹mo 'ido. ");
INSERT INTO chqNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Joon 'in tɨ́² gái¹ do gacu'²mo cwoo²¹ coon'¹³ 'yiia'nɨ́ɨ² do. La joon jon gajúun¹mo. Jo 'in yʉʉn²¹ seein²¹ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Joon 'in gatɨ́² gaai²¹ gacu'²mo cwoo²¹ coon'¹³ 'ido. La joon jɨ dyái¹ do gajúun¹mo. Ce jiin'¹³ jaain²¹ yʉʉn²¹ jo lɨseein²¹gɨ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","La joon jon gajúun¹mo 'in tsamɨ́² do. ");
INSERT INTO chqNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Joon mi jiin'¹in, ¿'iin jee²¹² 'in dyái¹ do icwaai'²¹ tsamɨ́² tya' 'ido? ");
INSERT INTO chqNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Joon gañii¹i Jesús: ―Mo taain²¹² tsá² 'e fu juncwii²¹ lo tsañʉʉ'¹ coon'¹³ tsamɨ́² cu'²mo cwoo²¹. ");
INSERT INTO chqNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Pe jileei'²¹ 'in tyaliin¹ juncwii²¹ cataain²¹ joon jiin'¹in jee²¹² 'lɨɨ²¹² do jo cuui'¹³gɨ cwoo²¹ ruu'²¹i jon'gɨ cwooi¹gɨ tsá² jóon¹on wa'a icui'² cwoo²¹. ");
INSERT INTO chqNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Jon'gɨ lí² juuin²¹gɨ tsʉ nalɨ́ɨ¹i lawa'a ángeles. Jóon¹ Dios 'ii tsʉ 'wii'¹³ nigajiin'¹o. ");
INSERT INTO chqNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Cagɨ Moisés 'ña'a gajmaa¹a júu³ 'e jiin'¹ 'lɨɨ²¹². Mo gajǿø² 'e 'mó² pi'³ 'e coo²¹ do gaunsii²¹ Ña'ñʉ'¹ʉ' Dios tya' Abraham coon'¹³ tya' Isaac coon'¹³ tya' Jacob. ");
INSERT INTO chqNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Pe Dios jon' Dios tya' 'lɨɨ²¹², Dios tya' tsá² jiin'¹ 'ii tsʉ tyani Dios seen²¹mo jilee'²¹mo. ");
INSERT INTO chqNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Joon 'inlɨ́ɨi¹³ tɨfo'² tya' ley gasɨɨ'²¹ɨ 'ii jin'²in: ―'Áa¹mo tyʉ́² foo'²¹'o, Tɨfo'². ");
INSERT INTO chqNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Joon jo gatá²gɨ‑tsi 'e unngɨɨ¹gɨ. ");
INSERT INTO chqNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Joon gajin'² Jesús: ―¿Xiiala lɨ́² 'e jin'² tsá² 'e Cristo jún² tya' 'lɨɨ²¹² David? ");
INSERT INTO chqNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","'Ña'a David do gajin'²in jee²¹² jí² Salmo: “Ña'ñʉ'¹ʉ' Dios gajin'²in sɨɨ'²¹ɨ Ña'ñʉ'¹ʉ': Ní² lɨ' caa²¹na tsáa¹ ");
INSERT INTO chqNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ca mi tyée¹³na jileei'²¹ 'in 'eei'¹ 'nʉ 'wii²¹² tɨ́ɨ¹³'ɨ.” ");
INSERT INTO chqNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","¿Pe xiiala lí² Cristo ilí² jóon¹ David tsʉ 'ña'a David gaunsii²¹ 'ii Ña'ñʉ'¹ʉ'? ");
INSERT INTO chqNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Jilee'²¹mo tsá² núu²un mo gasɨɨ'²¹ Jesús tsá² tya'a: ");
INSERT INTO chqNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Tɨ́ɨ¹moo' coon'¹³ tɨfo'² tya' ley. Tɨ¹‑tsi ngɨɨ¹ coon'¹³ sɨɨn'³ cwaa²¹. Joon 'iin²¹²in 'e feei'²¹ tsá² 'ii coon'²¹ tún². Joongɨ 'noo'¹o 'mosíi¹ si'² nifu icwaa²¹ fu tsi inʉʉ cwo'¹. Joon 'iin²¹²in 'mosíi¹ tya' tsá² 'in tyíin²mo lɨ gø'² tsá². ");
INSERT INTO chqNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Joon tyii²¹o 'nʉ́¹ 'yiia'nɨ́ɨ² joon faa'²¹a júu³ tyʉ́² 'e cwaa²¹ wa'a coon'²¹on tsá² tóo². Pe 'ái¹gɨ wúu¹ inii²¹ 'ido. ");
INSERT INTO chqNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Tsi inʉʉ cwo'¹ ganí²i Jesús tsá² sá² cuu² 'in to'² cuu² tsi caja lɨ to'² tsá² cuu². ");
INSERT INTO chqNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ganí²mo jon jó¹ jaain²¹ 'yiia'nɨ́ɨ² tsá² tañíi² 'áai¹ 'in gato'² tún² cuu² yʉ́ʉn². ");
INSERT INTO chqNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Joon gajin'² Jesús: ―'E la ja'²mo fo'²oo 'in 'yiia'nɨ́ɨ² tsá² tañíi² lo nigacwoo¹o láai²gɨ la jee²¹² jileei'²¹. ");
INSERT INTO chqNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Tsʉ jileei'²¹ 'in catyaai² do cwoo¹o jiin'¹³ 'e sáai² tya'o. 'Inogɨ tañíi²mo 'áai¹ pe nigacwoo¹o jiin'¹³ 'e sá² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","'In lɨ́ɨi¹³ tsá² sɨ́ɨ¹i jee²¹² yaai xiiala jnéei² 'e cwo'¹ fee'¹ do tsʉ 'áai¹ 'ya'²gɨ jilaa'²¹ cuun²¹² coon'¹³ jilaa'²¹ 'e cwoo¹ tsá² 'yaai¹‑tsi. Joon gajin'² Jesús: ");
INSERT INTO chqNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Nijǿø³øø coon²¹ jmɨɨ²¹² mi fiin²¹ jilaa'²¹ 'e jǿø²øø'. Jiin'¹³ coon²¹ cuun²¹² jo 'e sá²gɨ ni 'e ruui'²¹ do. ");
INSERT INTO chqNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Joon gaunngɨɨ¹ɨ tsá² Jesús: ―Tɨfo'¹, ¿lɨɨ ilí² jilaa'²¹ 'elo? ¿Noo coon²¹ li² mi lí² jilaa'²¹ 'elo? ");
INSERT INTO chqNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Joon gajin'² Jesús: ―Tɨ́ɨ¹moo' jon. Jo cwóo¹³naa' yaanaa' 'in coon'²¹ 'naa' tóo². Tsʉ lɨ́ɨ¹ fúui¹ 'in jaliin¹ 'in jin'² sɨɨ'²¹ɨ 'naa': “Jna‑a Cristo.” Joongɨ jin'²in: “Nano gatɨ́² 'ii'²¹ ilí² sá² 'ii'²¹.” Pe 'naa' jo unjii²ii' júu³ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Joon mi núu¹³uu' 'e faa'²¹ tsá² tya' 'nii²¹ joongɨ 'e tɨ́ɨ²i tsá² jee²¹² yaai jo foo'¹³naa'. Tsʉ 'e joon 'ná¹ ilí² nifu. Pe 'ná¹gɨ ityía¹ 'ii'²¹ ilí² la joon. ");
INSERT INTO chqNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Joon gafaa'²¹gɨ Jesús: ―Coon²¹ fuu²¹ itéen¹in coon'¹³ fuu²¹ xiia'. Coongɨ fuu²¹ xiia' ijmáa¹a 'nii²¹ coon'¹³ fuu²¹ dogɨ. ");
INSERT INTO chqNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Joongɨ ijøø'²¹ 'wó² lɨɨlɨ́². Joon lɨ́ɨ¹ i'í² 'oo² coon'¹³ jmoowúu¹ la caain²¹ coonti. Joongɨ yʉ' juncwii²¹ imoo²oo' jilaa'²¹ 'e fo'² coon'¹³ li² 'e coo'¹³gɨ. ");
INSERT INTO chqNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Pe la nʉ'gɨ insaan'²mo tsá² 'naa'. Joon 'ǿø¹mo tsá² 'naa'. Joon tsajée¹i 'naa' lɨ lí² sá² 'ii'²¹ tyii' fu cwo'¹. Joon itaa'²¹i 'naa' 'nʉñí³. Joon tsajéei¹ 'naa' tyani rǿøi¹³ coon'¹³ tsá² 'oo¹ to² tsʉ 'wii'¹³ jo'²o lɨ́ɨ²naa' jna. ");
INSERT INTO chqNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Coon'¹³ 'e la joon lisá² coon²¹ 'ii'²¹ 'e foo²oo' 'e tyʉ́² 'wii²¹² tyiia. ");
INSERT INTO chqNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Tyá²‑'oo' mi ngɨ́ɨi² joon, jo cuu'¹³‑'oo' 'ee ifoo²oo' cwáain¹ tyii‑oo' la jéei¹. ");
INSERT INTO chqNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Tsʉ jna‑a icwóo³oo júu³ joongɨ 'e jmɨɨ¹‑'oo' ce jiin'¹³ jaain²¹ tsá² lí² lii'¹i 'naa' jon'gɨ lí² faa'²¹ 'laa'²¹ tyii'. ");
INSERT INTO chqNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Pe 'naa' i'nɨ́ɨ²mo tsá² 'naa'. Cagɨ 'ñʉ³ʉʉ' coon'¹³ ruu'²¹naa' coon'¹³ tsá² seen²naa' tyʉ́² coon'¹³ i'nɨ́ɨi² 'naa'. Ijnga'²mo tsá² 'inlɨ́ɨi¹³ 'naa'. ");
INSERT INTO chqNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Joon jilee'²¹mo tsá² seein²¹ ni cwoo'¹³ juncwii²¹ ni li 'eei'¹ 'naa' 'wii'¹³ jo'²o lɨ́ɨ²naa' jna. ");
INSERT INTO chqNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pe jiin'¹³ coon²¹ jñʉ¹ tsi tyí²ii' i'íin². ");
INSERT INTO chqNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","'Wii'¹³ 'e taa'²¹‑'oo' joon itiin'¹³naa' juncwii²¹ tyii'. ");
INSERT INTO chqNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Mi jǿø²naa' 'láa² la 'uui fuu²¹ Jerusalén joon lí² ñii²¹oo' 'e tɨ lɨ 'íin²mo. ");
INSERT INTO chqNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Joon jileei'²¹ 'in néei¹ fu Judea 'ná¹ cwiin²¹o fu moo'²¹. La joon jon jileei'²¹ 'in néei¹ fuu²¹ Jerusalén 'ná¹ 'woo²¹mo do. Joongɨ jileei'²¹ 'in taain²¹² jee²¹² to² jo li jaliin¹in. ");
INSERT INTO chqNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Tsʉ jmɨɨ²¹² joon jmɨɨ²¹² 'e ní² tsá² wúu¹. Jee²¹² jmɨɨ²¹² joon itséin¹ jiin'¹³ la jin'² ni jí² tya' Dios. ");
INSERT INTO chqNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Lɨ́ɨ¹ fúu² tsamɨ́² 'in tyéein¹ yʉʉn²¹ sɨ 'in cuu'²¹ tʉʉ'²¹ 'ee. Tsʉ lɨ́ɨ¹ wúu¹ 'in néei¹ la caain²¹ fuu²¹ do. Jmáa¹a Dios 'ii'²¹ tya' 'in tsá² do. ");
INSERT INTO chqNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","'Inlɨ́ɨi¹³ ijúun³in coon'¹³ ñí³. 'Inlɨ́ɨi¹³gɨ insaan'²mo tsá² joon tsajée¹i la caain²¹ fuu²¹ lɨ wíin². Joon tsá² jalíin² wíin² ityʉ'²ʉ to² Jerusalén ca mi tyeei¹ jmɨɨ²¹² tya' tsá² 'in jo seein²¹ Israel. ");
INSERT INTO chqNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Joon ñi'¹ coon'¹³ sɨɨ'²¹ coon'¹³ nʉ́ʉ¹ icwoo¹o li². Joon ni cwoo'¹³ 'wó² téein² tsá² 'goo²¹‑tsi. Xéei²‑tsi tsá² coon'¹³ 'e 'iin² jmɨ'ñi'³ coon'¹³ 'e jnóo¹ jmɨɨ²¹. ");
INSERT INTO chqNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Joon nityʉ'²ʉ‑tsi tsá² coon'¹³ 'e fo'² mi 'ɨ¹‑tsi jilaa'²¹ 'e gó² ijó² fu juncwii²¹. Tsʉ jilaa'²¹ 'ii'²¹ tya' juncwii²¹ 'ii²¹ yʉ' ilí² jleei¹. ");
INSERT INTO chqNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Mi yuui'¹³ joon imáa¹³naa' 'in Ruu'²¹i Tsá² jó² jee²¹² jníi¹ coon'¹³ jilaa'²¹ 'ii'²¹ tya'a coon'¹³ jilaa'²¹ 'ya'²gɨ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Joon mi 'láa² 'wii²¹² lí² jilaa'²¹ 'elo tyá²‑'oo' joon sáa¹³aa' mootyí²ii' tsʉ jmoono itiin'¹³naa'. ");
INSERT INTO chqNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Gasɨɨ'²¹o jon Jesús 'e cwáain¹ lo: ―Jǿø²duu' jilaa'²¹ 'mó² cwaríi³ coon'¹³ jilaa'²¹gɨ nii¹ 'mó². ");
INSERT INTO chqNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Mo gañii²ii' ganii'¹³ 'mo'² 'mó² sii'²¹ ñii²oo' yaanaa' 'e nijatyéein¹ jiin²¹ jmɨ́¹. ");
INSERT INTO chqNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","La joon jon mi moo²oo' ilí² jilaa'²¹ 'elo niñii²oo' 'e nijatyéen¹mo 'e tyʉ'² Dios to². ");
INSERT INTO chqNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’'E la ja'²mo fo'³oo, jilaa'²¹ 'elo nilí² la nʉ'gɨ ijúun²in tsá² 'in seein²¹ nano. ");
INSERT INTO chqNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Cwoo'¹³ 'wó² coon'¹³ juncwii²¹ 'ii²¹ yʉ' ityé²emo pe júu³ tyiia jo tyé²i coonti. ");
INSERT INTO chqNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Tɨ́ɨ¹moo', jo unbaan¹naa' yaanaa' coon'¹³ jilaa'²¹ 'e gó². Jo ngɨɨ²ɨɨ' to² 'íin¹. Jo unbaan¹naa' yaanaa' 'e 'ɨ¹‑'oo' jmaai'¹³ 'e jmaai¹ to² tyii'. Tsʉ la joon jo xuu'²¹naa' lawa nilá² mi cwá² 'e jmɨɨ²¹² do. ");
INSERT INTO chqNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Lawa coon²¹ nilá² lí¹ 'e jmɨɨ²¹² do 'e taain'¹³ jileei'²¹ tsá² 'in néei¹ la caain²¹ cwoo'¹³ juncwii²¹. ");
INSERT INTO chqNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Tyaa²aa' tyʉ́² tyii'. Foo²oo' júu³ tyʉ́² coon²¹ tøø²mo. La ilí² lá²naa' ilí² lá²naa' jilaa'²¹ 'elo 'e 'ná² ilí². Joongɨ lí²‑i tyalíin²naa' tyani 'in Ruu'²¹i Tsá². ");
INSERT INTO chqNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Mo jmɨɨ²¹² ga'ee¹ Jesús inʉʉ cwo'¹ joon mo 'woo¹ ngajáan¹an fu moo'²¹ sii²¹ Olivos. ");
INSERT INTO chqNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Joon jileei'²¹ tsá² jaliin¹ la coon²¹ mo 'aa²¹ fu cwo'¹ fee'¹ 'a núu²un júu³ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Nigajatyéen¹mo tyan'² jmɨɨ²¹² 'e gø'² tsá² 'iñi'¹ 'e jo tyiia'³ jeei¹. 'øøi'²¹‑tsi tsá² jmɨɨ²¹² 'e sii²¹ pascua. ");
INSERT INTO chqNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Joon 'in tyʉ'² to² tya' untsá² coon'¹³ tɨfo'² tya' ley 'noo'¹on xiiala ijngaa'¹³i Jesús pe 'gøø'²¹mo tsá². ");
INSERT INTO chqNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Joon ga'í² Satanás alma tya' Judas, 'in sii²¹o jon Iscariote. Jaain²¹ jee²¹² dyatuuin¹ tsá² tya' Jesús 'ii. ");
INSERT INTO chqNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","'Ido ngóo¹o ngafee'¹³i 'in tyʉ'² to² untsá² coon'¹³ 'in tyʉ'² to² 'in jǿø² inʉʉ cwo'¹ do. Joon ngafee'¹³i 'ido xiiala jmáa¹a cwáain¹ 'e 'í¹ Jesús ja'cwoo²¹. ");
INSERT INTO chqNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","'Idogɨ galijløø'³mo. Joon gaunrøø¹ júu³ 'e cwó² Judas cuu². ");
INSERT INTO chqNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Joon ga'ii'²¹mo. Joon ga'láa² 'wii²¹² 'noo'¹²on xiiala jaan'²in Jesús mo ga'ɨ́ɨ² tii², mo jo tsá² seein²¹. ");
INSERT INTO chqNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Joon gatɨ́² jmɨɨ²¹² 'e gø'² tsá² 'iñi'¹ 'e jo tyiian'³ jeei¹. Joon jngaai'¹³ tsá² joo'saa'²¹ jiin'¹³ la tɨɨsi'². ");
INSERT INTO chqNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Joon gasii¹in Jesús 'in sii²¹ Tʉ́³ coon'¹³ jaain²¹gɨ 'in sii²¹ Wó³ joon gasɨɨ'²¹ɨ 'ii²¹: ―Cwolíin²naa' joon cwotyá²aa' tyʉ́² 'e tyé³e' 'e gatɨ́² jmɨɨ²¹². ");
INSERT INTO chqNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","'Idogɨ gaunngɨɨ¹ɨ: ―¿Xiia 'iin²¹²u'un tsatyaa²¹a'a tyʉ́²? ―gajin'²in sɨɨ'²¹ɨ Jesús. ");
INSERT INTO chqNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Joon gajin'² Jesús: ―Mi cwotaa²¹naa' 'e fuu²¹ joon jiin'¹naa' jaain²¹ tsañʉʉ'¹ 'in tyiian¹ coon²¹ tsʉʉ² sɨ'o² jmɨɨ²¹. Cwolíin²naa' caluu‑u ca xiia'²¹ 'nʉ́¹ li 'í²i. ");
INSERT INTO chqNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Joon fuu²uu' 'in fii²¹² 'nʉ́¹ do: “La lo‑o jin'² tɨfo'² tyii'i sɨɨ'²¹ɨ 'nʉ: ¿Xiiali cwo'²'o yii²¹a'a tyee²e'e coon'¹³ tsá² tyiia tya' jmɨɨ²¹² 'e gatɨ́²?” ");
INSERT INTO chqNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Joon ni'e'²e 'naa' coon²¹ tsi inʉʉ fee'¹ lɨ ñii². Do‑o tyaa²aa' tyʉ́². ");
INSERT INTO chqNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Joon ngalíin²mo. Joon galɨ́² jiin'¹³ la nigajin'² Jesús. Joon gatyaa¹ tyʉ́² 'e dø'¹ø mo gatɨ́² jmɨɨ²¹² do. ");
INSERT INTO chqNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Mo gatɨ́² 'ii'²¹, joon gacwó²o Jesús coon'¹³ tsá² tya'a 'e dø'¹ø. ");
INSERT INTO chqNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Joon gajin'² Jesús: ―¡'Áa¹mo nagali'iin²¹²na jmáa³aa coon'¹³ 'naa' 'e tyee²e' tya' 'e jmɨɨ²¹² lo la nʉ'gɨ ijúun²na! ");
INSERT INTO chqNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Tsʉ fuu²¹²uu 'naa' 'e jo jmáa³gɨɨ ca mi tɨ́² 'ii'²¹ 'e tyʉ'² Dios to². ");
INSERT INTO chqNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Joon gason'¹on coon²¹ wúun¹xʉ sɨ'o² vino joon gacwo'²o 'maai'¹³ Dios joon gajin'²in: ―Jun'² 'elo, joon jmaa²aa' jmai'²xʉ jee²¹² 'naa'. ");
INSERT INTO chqNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Tsʉ la lo‑o fo'³oo, jo jmɨɨ²¹² yaai'¹³gɨɨ duu'¹³uu jmɨ'³ mɨ'³ wuunjøø'³ ca mi tyʉ'² Dios to². ");
INSERT INTO chqNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Mo ngayuui'¹³ joon gason'¹on coon²¹ 'iñi'¹. Joon gacwo'²o 'maai'¹³ Dios joon gajmaa¹a ca'no'³. Joon gacwo'²o tsá² tya'a sɨɨ'²¹ 'ido: ―'E lo‑o cuerpo tyiia ijoon'¹³oo 'wii²¹² tyii'. Jmaa²aa' 'elo joon itɨ'¹‑'oo' jna. ");
INSERT INTO chqNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","La joon jon gajmaa¹a coon'¹³ coon²¹ wúun¹xʉ do mo ngayuu'¹³ gagøø'²¹ø. Joon gajin'²in: ―'E wúun¹xʉ lo lawa coon²¹ 'ii'²¹ 'e 'múui². Joon 'e jmɨ¹ 'ǿø³na lo 'e nitʉʉn²¹ 'wii²¹² tyii' 'e li² tya' 'e 'ii'²¹ 'múui² do. ");
INSERT INTO chqNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Pe nano cwoo²¹ tsá² 'in i'nɨɨi¹ jna roon¹ coon'¹³ cwóo³oo ni mesa lo. ");
INSERT INTO chqNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Pe jna‑a 'in Ruu'²¹na Tsá² nilí²‑i jiin'¹³ la 'ii'²¹ nigalisá². Pe 'áa¹mo fúu² 'in 'nɨɨi¹ jna. ");
INSERT INTO chqNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Joon ga'láa² tsá² tya'a 'wii²¹² gaunngɨɨ¹ɨ jee²¹² 'ii: ―¿'Iin jee²¹² jna' 'in jmoo¹o 'e gó² lo? ");
INSERT INTO chqNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Mo ngayuui'¹³ joon gasɨ́ɨ²i jee²¹² 'ii 'iin 'in tyiin²gɨ jee²¹² 'ii. ");
INSERT INTO chqNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Joon gajin'² Jesús gasɨɨ'²¹ɨ 'ii: ―Jileei'²¹ rǿøi¹³ 'in tyʉ'² to² ni cwoo'¹³ juncwii²¹ tyʉ'²o to² ce caain²¹‑tsi. Joongɨ jileei'²¹ tsacøøi'¹³ tya' 'ii lawa 'ña'o sii²¹ tsá² tyúi¹. ");
INSERT INTO chqNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pe 'naa'gɨɨ' jo tɨ́ɨ²naa' jmaa²aa' la joon. Lɨ'² cɨɨ'¹²ɨ jmoo² 'naa'. Jileei'²¹ 'in tyiin²gɨ jee²¹² 'naa' 'ná² sɨ́ɨ¹³naa' lawa 'in xuui²¹²gɨ. Joon 'in tyʉ'² to² 'naa' 'ná¹ jmaa¹o la jmoo¹o tsa'leei'¹³. Jo cwooi¹ tyʉ'²ʉ to². ");
INSERT INTO chqNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿'Iin 'in tyiin²gɨ awa 'in tyíin¹ gø'²ø sɨ 'in gatyáa¹ tyʉ́² 'ee? Pe jna‑a 'yuu²na jee²¹² 'naa' lawa jaain²¹ 'in tyaa¹ tyʉ́². ");
INSERT INTO chqNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’'Naa' nigangɨ²ɨɨ' coon'¹³ jna coon²¹ tǿøi² la lɨ 'e móo³oo wúu¹. ");
INSERT INTO chqNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","'E joon jna cwo'³oo 'naa' coon²¹ lɨ ityʉʉ²ʉʉ' to² la lɨ́² 'e gacwo'² Ñʉ'³ʉʉ jna. ");
INSERT INTO chqNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","'E joon ilí² cøø²øø' joongɨ 'uu²uu' coon'¹³ jna mi tyʉ'³ʉʉ to². Joongɨ iní²ii' 'áan³ tyii' lawa tsacøøi'¹³ 'e jmaa¹aa' 'ii'²¹ tya' 'in dyatun¹ poo²¹² tsá² seein²¹ Israel. ");
INSERT INTO chqNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Gajin'²in jon Ña'ñʉ'¹ʉ': ―Simóoi¹³, Satanás nigamóoi¹ 'naa' 'e jøøi'¹² 'naa' la mo untyʉ́² tsá² trigo 'e coon'²¹ cwáain¹ 'naa'. ");
INSERT INTO chqNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pe jna nigamɨ́³ɨɨ tyani Dios 'wii²¹² tyi'i 'e jo tʉ́²'ʉ 'e jo'² cwolíin²un. Joon mi jaa'²¹‑o'o cwotyii'¹²a‑tsi 'in tsaruu'²¹'u. ");
INSERT INTO chqNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Joon gajin'² Simóoi¹³ do: ―Ña'ñʉ'¹ʉ', naná¹a tyʉ́² tyiia 'e ní³ii 'nʉñí³ coon'¹³ 'nʉ ca xʉfiin'¹³ jún¹moo coon'¹³ 'nʉ. ");
INSERT INTO chqNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Joon gajin'² Jesús: ―Tʉ́³, fuu²¹²uu 'nʉ 'e jmɨɨ²¹² no‑o la nʉ'gɨ i'ó¹ tuuitsáa² jo røø¹u 'e cwii¹un jna 'nɨ¹ naa'¹³. ");
INSERT INTO chqNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Joon gaunngɨɨ¹ɨ Jesús: ―Gasɨ́ɨ³na 'naa' jo 'ee tʉloo²¹ tyán²aan', jon'gɨ cuu² tyán²aan', jon'on mɨ́ɨ¹³ɨɨ' ga'ǿø¹³øø', ¿tɨ 'ee gali'ná¹gɨ tyii'? 'Ido‑gɨ gajin'²in: ―Jiin'¹³ coon²¹ jo 'ee ga'naai²¹ tyi jna'a. ");
INSERT INTO chqNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Joon gajin'² Jesús: ―E ningóo¹ lɨ' cɨɨ'¹²ɨ no joon jileei'²¹ 'in 'oo¹ tuloo²¹ 'ná² cwotyaan²¹o. Joongɨ 'in 'oo¹ cuu² 'ná² cwotyaan²¹. Joongɨ jileei'²¹ 'in jo 'oo¹ ñí³ 'ná² cwo'nɨɨ¹ 'mɨ'² tyíia² tya'a joon ló² ñí³ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Tsʉ la ja'²mo fo'³oo, 'ná²‑a tsangɨ́ɨ¹na jilaa'²¹ la lɨ 'e tyaan²¹ ni jí² tya' Dios 'e jin'²: “Sɨ́ɨ²i la jee²¹² yaai 'e tsá² gó² 'ii.” Tɨ lɨ tsín¹ jiin'¹³ la jin'² jí² cwáain¹ tyiia. ");
INSERT INTO chqNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Joon gajin'² 'ido: ―Sá² tún² ñí³ lo. Joon gañii¹ Jesús: ―Naleen¹mo jon. ");
INSERT INTO chqNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Joon gacwo'ɨ́ɨ¹ Jesús. Joon jiin'¹³ la tɨɨsi'² tya'a gangóo¹ fu moo'²¹ Olivos. Joon gangaliin¹mo tsá² tya'a coon'¹²on. ");
INSERT INTO chqNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Mo gatyalíin² do joon gasɨɨ'²¹ɨ Jesús 'ii: ―Mɨ́²ɨɨ' tyani Dios 'e jo xuu'²¹naa'²¹ tsaa² tyii'. ");
INSERT INTO chqNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Joon gangawíin² Jesús coon²¹ jiin'¹³ la wíin² mo tyʉ'² tsá² cuun²¹². Joon gasii'¹i wojníi¹i. Joon faa'²¹a júu³ tyʉ́². ");
INSERT INTO chqNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Joon gajin'²in: ―Ñʉ'², wana 'iin²¹²un un'øø²¹u jna 'e jo móo³oo wúu¹ coon'¹³ jilaa'²¹ 'e 'ná² lí². Pe jo lí² jiin'¹³ la 'iin²¹²na pe jiin'¹³ la 'ii'²¹ tyi'i. ");
INSERT INTO chqNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Joon gajnéi¹ jaain²¹ ángel jó¹ fu ñʉ'fú² joon gacwoo²¹gɨ 'waa'²¹ pí². ");
INSERT INTO chqNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Joon ga'í² 'e nii²¹ wúu¹ lɨɨlɨ¹. Joon gamɨɨ¹ɨ 'wii²¹² tya'a coon'¹³ 'láai²gɨ 'waa'²¹ pí². Joon ga'yá² untyiia²¹ tya'a lɨ la lɨ jmɨ¹ 'e xʉʉ'²¹ ni 'wó². ");
INSERT INTO chqNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Mo róon² joon ngaa'¹²in lɨ téein² tsá² tya'a. Joon gatsee'²¹i 'ido cwuu²¹mo coon'¹³ jilaa'²¹ fa'í³. ");
INSERT INTO chqNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Joon gajin'²in: ―¿'Ee lɨ cwuu²¹naa'? Ráan²naa', fee'¹²naa' Dios joon jo xuu'²¹naa' tsaa² tyii'. ");
INSERT INTO chqNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Faa'²¹gɨ Jesús siin'¹²in mo gacwolíin² tsá² fúui¹. Joon jaain²¹ jee²¹² jɨ dyatuuin¹ tsá² tya'a 'in sii²¹ Judas jó¹ nifu tya' 'in tsá² do. 'Ii ngatyeen¹in lɨ siin'¹² Jesús ijun'²un ju'² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Joon gajin'² Jesús: ―Judas, ¿tɨ ga'nɨɨ²¹²un jna, 'in Ruu'²¹na Tsá², coon'¹³ 'e gajiin'¹'in ju'³uu? ");
INSERT INTO chqNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Jileei'²¹ 'in téein² coon'¹³ Jesús mo ganí²i jilaa'²¹ 'e lɨ́² gajin'²in sɨɨ'²¹ɨ Jesús: ―¿Jatɨɨ²ɨ' coon'¹³ ñí³ 'ee? ");
INSERT INTO chqNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Joon jaain²¹ jee²¹² 'ii gauncwuu'²¹i jaain²¹ tsa'leei'¹³ tya' 'in tyʉ'² to² untsá² nifú². Gatyʉ'²ʉ cataain²¹ loocwo² lɨ tsáa¹. ");
INSERT INTO chqNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Joon gajin'² Jesús: ―Cwoján²xʉ la no. Jo caai'¹³gɨɨ' 'ino. Joon gasʉ́ʉ² Jesús loocwo² 'ido joon ga'láa²mo tsifu. ");
INSERT INTO chqNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Joon gajin'² Jesús sɨɨ'²¹ɨ 'in nijalíin² 'e tøø¹ 'ii. Sɨɨ'²¹ɨ 'in tyʉ'² to² tya' untsá² coon'¹³ 'in tyʉ'² to² 'in jǿø² inʉʉ cwo' coon'¹³ tsacøøi'¹³: ―Nañilíin²naa' coon'¹³ ñí³ coon'¹³ 'mó² 'e tøø²øø' jna lawa jaain²¹ 'uun²¹. ");
INSERT INTO chqNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","La coon²¹ jmɨɨ²¹² 'yuu²na jee²¹² 'naa' tsi inʉʉ cwo'¹ fee'¹ do. Joon jo mo gaseen'²naa' jna coonti. Pe jiin'¹³ lo‑o 'ii'²¹ tyii' mo ga'ɨ́ɨ² nʉʉ²¹. ");
INSERT INTO chqNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Joon gajée¹i Jesús sɨ'ñúu¹mo fu tya' 'in tyʉ'² to² untsá² nifú². Joon Tʉ́³ ngaa'¹³i caluu Jesús wíin²gɨxʉ. ");
INSERT INTO chqNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Joon do‑o gajiin'² coon²¹ jɨ́² tún² tsa'² tya'i tyi¹ do. Joon do‑o gacwó²o cu' lɨ' lɨ coo²¹ jɨ́² do. Tʉ́³‑gɨ do‑o jon tyíin¹in. ");
INSERT INTO chqNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Joon jaain²¹ tsamɨ́² 'in jmoo¹o to² inʉʉ do mo ganí²i tyíin¹ Tʉ́³ co' jɨ́² do joon gajaan¹ jǿøi² 'ido. Joon gajin'²in: ―Ngɨɨ¹ jon 'in tsañʉʉ'¹ lo coon'¹³ 'ido. ");
INSERT INTO chqNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Joon jo garǿø¹i Tʉ́³, gajin'²in: ―Tsamɨ́², jo cwii¹na 'ido. ");
INSERT INTO chqNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Mo galɨ́² cɨɨin²¹gɨxʉ joon 'in xee'²¹mo gasɨɨ'²¹ɨ 'ii: ―'Nʉ‑ʉ, jaain²¹ jee²¹² 'ii. Joon gajin'² Tʉ́³: ―Jon' 'i jna, tsañʉʉ'¹. ");
INSERT INTO chqNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Coon²¹ hora ngóo¹gɨxʉ mo gajin'² 'in xeei'²¹ gasɨɨ'²¹ɨ 'ii: ―'E la ja'²mo ngɨɨ¹ 'in tsañʉʉ'¹ lo coon'¹³on tsʉ 'in seein²¹ Galilea lo. ");
INSERT INTO chqNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Joon gajin'² Tʉ́³: ―Tsañʉʉ'¹, jo ñí³ii 'ee 'e fo'²'o. La tsifu joon, la 'ɨɨ²¹² faa'²¹gɨ Tʉ́³ ga'oo¹ jaain²¹ tuuitsáa². ");
INSERT INTO chqNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Joon jiin'²¹ 'ña'a Jesús níi¹i gajǿøi² Tʉ́³. Joon gatɨ'²‑tsi Tʉ́³ jiin'¹³ la nigajin'² Jesús sɨɨ'²¹ɨ 'ii: “La nʉ'gɨ i'oo¹ tuuitsáa² jo røø²¹u 'e cwii¹u jna 'nɨ¹ naa'¹³.” ");
INSERT INTO chqNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Joon gacwo'ɨ́ɨ¹ Tʉ́³ joon gatyi'²o xuui²¹²‑tsi 'áai¹. ");
INSERT INTO chqNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Jileei'²¹ tsá² do 'in 'aa¹i Jesús gaungøøi¹ 'ii 'áai¹ joongɨ gajmee'²¹mo lɨɨlɨ¹. ");
INSERT INTO chqNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Gajnii¹ unníi¹i 'ido joon gapoo²¹ ni² 'ido joon gasɨɨ'²¹ɨ 'ii: ―Faa'¹³du', ¿'iin pó² tyi'i? ");
INSERT INTO chqNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Joongɨ 'láai² júu³ 'laa'²¹ gafa'²o tya' Jesús. ");
INSERT INTO chqNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Mo gajná² joon galicaain²¹ tsacøøi'¹³ tya' tsá² Israel coon'¹³ 'in tyʉ'² to² untsá² coon'¹³ tɨfo'² tya' ley. Joon gangajée¹i Jesús lɨ sɨcaain²¹ tsá² 'in tyiin²gɨ do. Do‑o gaunngɨɨ¹ɨ: ");
INSERT INTO chqNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Sii'¹³ jna'a, ¿tɨ 'nʉ Cristo? Joon gañii¹i Jesús: ―Wana fo'³oo, jo jo'² ilíin²naa' júu³ tyiia. ");
INSERT INTO chqNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Joongɨ wa'a unngɨ́³ɨɨ 'naa' jo ñí²ii' jon'gɨ jo laa²¹²naa' jna. ");
INSERT INTO chqNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Pe ca nano‑o ca li ngoo²¹gɨ jna‑a, 'in Ruu'²¹na Tsá², ninii²¹²ii cáai¹ Dios Jmii²¹ lɨ' tsáa¹. ");
INSERT INTO chqNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Joon jilee'²¹mo gaunngɨɨ¹ɨ: ―¿Tɨ 'nʉ‑ʉ Jóon¹ Dios? Joon gañii¹i Jesús: ―Jnagɨɨ 'i jiin'¹³ la nafaa'¹³naa'. ");
INSERT INTO chqNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Joon gajin'²in jee²¹² 'ii do: ―Jo 'ee júu³ 'ná¹gɨ jna'. Yiiana' jon ninʉʉ²¹ʉ' júu³ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Joon jilee'²¹mo garoon¹ joon gangajée¹i Jesús tyani Pilato. ");
INSERT INTO chqNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Do‑o ga'láa² 'wii²¹² jmoo¹o tsaa² tya' Jesús jin'²in: ―Nigatsee'²¹na'a 'in tsañʉʉ'¹ lo 'e'¹e tsá² tyii'i 'e faa'²¹ 'laa'²¹ tya' 'in tsaa'to² tyíin¹ Roma. Jin'²in 'e jo 'ná² tyii²ii'i 'laa'¹³ 'e 'nɨɨ¹ tya' 'in tyʉ'² to² nifu tyíin¹ Roma. Joongɨ jin'²in 'e 'ii Cristo, 'e 'øøi'²¹‑tsi tsá² 'e jaain²¹ rǿøi¹³ 'ii. ");
INSERT INTO chqNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Joon gajin'² Pilato: ―¿Tɨ 'nʉ‑ʉ Rǿøi¹³ tya' tsá² Israel? Joon gajin'² Jesús: ―La joon nigafaa'¹³gɨ'ɨ. ");
INSERT INTO chqNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Joon gajin'² Pilato sɨɨ'²¹ɨ 'in tyʉ'² to² tya' untsá² coon'¹³ 'in tsá² catyaai²gɨ: ―Jiin'¹³ coon²¹ jo mo gatsaa'³aa tsaa² tya' 'in tsañʉʉ'¹ no. ");
INSERT INTO chqNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pe 'idogɨ gafaa'²¹a tá²gɨ jin'²in: ―Jileei'²¹ 'in núu²un júu³ tya' 'ino 'iin²¹²in to'² mɨɨ'¹³. Joon ga'e'¹o júu³ tya'a la caain²¹ Judea. Ga'láa² 'wii²¹² fu Galilea joon ca logɨ ga'ee¹ júu³ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Mo ganúu²un Pilato 'elo joon gaunngɨɨ¹ɨ wana seein²¹ Jesús fu Galilea. ");
INSERT INTO chqNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Joon mo gajin'² tsá² joon, joon gasii¹in tyani Herodes 'in tyʉ'² to² Galilea. Joon jee²¹² jmɨɨ²¹² joon taain¹ fu Jerusalén. ");
INSERT INTO chqNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Mo ganí²i Herodes Jesús jløø'³mo 'áai¹ tsʉ ningóo¹ 'e gali'iin²¹²in jǿøi² Jesús. Ninuu¹o faa'²¹ tsá² cwáain¹ tya'a. Joon ni'iin²¹²in jǿø² coon²¹ milagro 'e jmá¹ Jesús. ");
INSERT INTO chqNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Lɨ́ɨ¹ 'láai² 'e gangɨɨ¹ɨ pe Jesús coonti jo 'ee gañii¹i. ");
INSERT INTO chqNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Do‑o jon téein² 'in tyʉ'² to² tya' untsá² coon'¹³ tɨfo'² tya' ley. 'Ii jmoo¹o tsaa² fee'¹ tya'a coon'¹³ 'láai²gɨ lɨɨlɨ¹. ");
INSERT INTO chqNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Joon Herodes coon'¹³ 'láa² tya'a gatyii²mo Jesús joongɨ gaunngøø¹mo. Joon gatyii'²¹in Jesús coon²¹ 'mɨ'² jɨɨ'¹ la lɨ sɨɨn'³ rǿøi¹³. Joon gasii'¹³mo tún¹ tyani Pilato. ");
INSERT INTO chqNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Jmɨɨ²¹² joon røø²¹ gasɨ́ɨ²i Pilato coon'¹³ Herodes tsʉ la mo jéei¹³ 'ee'¹mo ruu'²¹i. ");
INSERT INTO chqNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Joon gauncaain²¹ Pilato 'in tyʉ'² to² tya' untsá² coon'¹³ tsacøøi'¹³ joongɨ coon'¹³ jileei'²¹ tsá². ");
INSERT INTO chqNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Joon gajin'²in sɨɨ'²¹ɨ 'ido: ―'Naa'‑a ñijee²¹naa' 'in tsañʉʉ'¹ lo foo²oo' 'e jmoo¹o 'ido to'² tsá² mɨɨ'¹³. Pe jna‑a ga'no'³oo tsaa² tya'a tyaní²ii' pe jo gatsaa'³aa. Joon jǿø²oo' 'e jo 'ee tsaa² sá² tya'a coonti jiin'¹³ la tsaa² jmoo²oo'. ");
INSERT INTO chqNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","La joon jon Herodes 'in nigasiin'¹²mo tún¹ fu lo jo nigatsaa'²¹a tsaa² tya' 'ido. Nijǿø²oo' 'e jo 'ee tsaa² sá² tya'a wa'a 'e tɨ́ɨi² júun²in. ");
INSERT INTO chqNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","'E'³duu wúu¹ joon mi yuui'¹³ joon láa²moo. ");
INSERT INTO chqNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Pilato jiin'¹³ la tɨɨsi'² 'ná² láai² jaain²¹ tsá² 'yuui²¹² 'nʉñí³ jiin'¹³ jee²¹² jmɨɨ²¹² joon. ");
INSERT INTO chqNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Joon jilee'²¹mo ga'láa² 'wii²¹² ga'oo¹. Jin'²in: ―¡Jngai'²ta 'ino! Cwolaai²¹ Barrabás. ");
INSERT INTO chqNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","'In Barrabás do nigataan'¹²in 'nʉñí³ 'wii'¹³ nigajmaa¹a 'e tsá² fuu²¹ lo jmoo¹o 'nii²¹ coon'¹³ tsaa'to² tyíin¹ Roma. Joon nigajnga'²mo tsá². ");
INSERT INTO chqNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato do 'iin²¹²in láai² Jesús. Joon gasɨɨ'²¹ɨ tsá² tún¹. ");
INSERT INTO chqNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Pe 'idogɨ ga'oo¹ tá²gɨ gajin'²in: ―¡Táan¹in tsaa' crúu¹³! ¡Táan¹in tsaa' crúu¹³! ");
INSERT INTO chqNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Joon mo gatɨ́² 'nɨ¹ fu joon gajin'² Pilato: ―¿'Ee 'e gó² nigajmaa¹a? Jna‑a jo gatyii'³aa jiin'¹³ coon²¹ tsaa² wa'a ijúun²in. 'E'³duu wúu¹ joon mi yuui'¹³ joon iláa²moo. ");
INSERT INTO chqNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pe 'ido‑gɨ gañii¹i tá² lɨɨlɨ¹. Gamɨɨ¹ɨ wa'a táan¹in tsaa' crúu¹³. Joon gatɨ'² júu³ tya' 'in tsá² do coon'¹³ 'in tyʉ'² to² tya' untsá². ");
INSERT INTO chqNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Joon Pilato do gajmaa¹a 'ii'²¹ jiin'¹³ la gali'iin²¹²in 'in tsá² do. ");
INSERT INTO chqNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Joon galáa²mo jiin'¹³ Barrabás 'in 'yuui² 'nʉñí³ 'wii'¹³ gajmaa¹a 'nii²¹ joon gajngaa'¹³i tsá². Joon gajaan'²¹mo Jesús jiin'¹³ la nigamɨɨ¹ɨ 'in tsá² do. ");
INSERT INTO chqNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","La 'ɨɨ²¹² ngalíin² jée¹i Jesús 'e táan¹in crúu¹³ gasaan'¹²in jaain²¹ tsañʉʉ'¹ 'e coon²¹ crúu¹³ tya' Jesús. Simóoi¹³ sii²¹ 'in tsá² do. Galiseein²¹ coon²¹ fuu²¹ sii²¹ Cirene. 'In jai'¹³ fu coon²¹ fuu²¹ pi'³ 'e ná¹ co' do. Joon joo²¹o caluu. ");
INSERT INTO chqNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Joon fúu¹mo tsá² ngalíin² coon'¹³on coon'¹³ tsamɨ́² 'in ngalíin² cɨ'². Joon 'oo¹o tá² coon'¹³ jilaa'²¹ fa'í³ 'wii²¹² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Joon gajǿø²i Jesús 'ii joon gasɨɨ'²¹ɨ 'ido: ―Tsamɨ́² seein²¹ Jerusalén, jo cɨɨ²ɨɨ' 'wii²¹² tyiia. Tyíi¹³ii' 'wii²¹² tyii' yaanaa' joongɨ 'wii²¹² tya' yʉʉn²¹ tyii'. ");
INSERT INTO chqNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Tsʉ nijó² jmɨɨ²¹² mi jin'² tsá²: “Tyúu¹mo 'in jo galiseein²¹ jóon¹on, joon 'in jiin'¹³ cafu jo gangatyéein¹ yʉʉn²¹, 'in jiin'¹³ coon²¹ naa'¹³ jo gacuu'²¹ xuui²¹² tʉʉ'²¹ tya'a.” ");
INSERT INTO chqNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Mi tɨ́² 'ii'²¹ joon ni'láa² tsá² 'wii²¹² faa'²¹a sɨɨ'²¹ɨ moo'²¹ coon'¹³ jilaa'²¹ tɨɨ'²¹: “Cwoxaa²o joon cwojlɨ́ɨ¹³u'u jna'a.” ");
INSERT INTO chqNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Tsʉ wana galɨ́² jilaa'²¹ 'elo coon'¹³ jna 'in jo røøi²¹ tsaa², ¿'ee coon'¹³ ilí² coon'¹³ tsá² goo²oo' 'in røøi²¹ tsaa² 'áai¹? ");
INSERT INTO chqNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Jée¹mo jon gái¹gɨ 'in røøi²¹ tsaa² ijngaa'¹³i caain²¹ coon'¹³ Jesús. ");
INSERT INTO chqNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Mo gatyalíin² coon²¹ lɨ sii²¹ Mootyi² 'Lɨɨ²¹² joon do‑o gateein¹ Jesús tsaa'¹ crúu¹³ coon'¹³ 'in tsá² gái¹gɨ do. Jaain²¹ lɨ' tsáa¹ jaain²¹gɨ lɨ' tuuin²¹². ");
INSERT INTO chqNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Joon la 'ɨɨ²¹² taain¹ Jesús tsaa'¹ crúu¹³ joon gajin'²in: ―Ñʉ'³, feei'¹ jmaa²‑'o'o 'wii²¹² tya' 'in tsá² no tsʉ joñi¹i 'ee 'e jmoo¹o. Joon 'in 'láa² do gacoo¹o xiiala ijmáa¹a jmai'²xʉ jee²¹² 'ii sɨɨn'³ Jesús. ");
INSERT INTO chqNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Jileei'²¹ tsá² téen²mo jǿø²ø joon cagɨ tsacøøi'¹³ ungøøi¹ Jesús jin'²in sɨɨ'²¹ɨ 'ido: ―Galáa²mo 'in xeei'²¹ 'ii. Joon cwoláai² 'ña'a wana sɨ najai'² 'ii Cristo, 'in nityii'¹²in Dios. ");
INSERT INTO chqNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","La joon jon 'láa² do ungøø¹mo Jesús. Gangatyéen¹in ca tyan'² joon gacwo'²o Jesús vino tin'³. ");
INSERT INTO chqNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Joon jin'²in: ―Wana 'nʉ Rǿøi¹³ tya' tsá² Israel laai²¹² 'wo'o. ");
INSERT INTO chqNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Joon nigataan¹ tsá² coon²¹ júu³ yʉ' tyíi¹i 'e jin'²: “'Inlo‑o Rǿøi¹³ tya' tsá² Israel.” 'E júu³ do lɨ́² jmíi¹ griego coon'¹³ jmíi¹ latín coon'¹³ jmíi¹ hebreo. ");
INSERT INTO chqNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Jaain²¹ 'in tsá² røøi²¹ tsaa² 'in táain² co' do gasɨɨ'²¹ɨ Jesús jin'²in: ―Wana 'nʉ Cristo laai²¹² 'wo'o joongɨ laai²¹² jna'a. ");
INSERT INTO chqNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Pe 'in jaain²¹gɨ do gatyuu'¹²i júu³ tya' 'in jaain²¹ do. Joon gasɨɨ'²¹ɨ 'ido: ―Jmaa² 'gøø'²¹'u Dios tsʉ 'e røø²¹na' tsaa². ");
INSERT INTO chqNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Jna' 'e tɨ́ɨ²mo' nee²¹e' wúu¹ tsʉ tyii²¹² jna' tsaa² tyii‑o' 'e nigajmoo²¹o'. Pe 'in tsañʉʉ'¹ lo jo 'ee gajmaa¹a 'e gó². ");
INSERT INTO chqNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Joon gajin'²in sɨɨ'²¹ɨ Jesús: ―Cwotii'¹³‑'o'o jna mi 'ii'¹³'u to² 'e gatɨɨ²u. ");
INSERT INTO chqNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Joon gañii¹i Jesús: ―'E la ja'²mo fo'³oo, no‑o tyalii²¹i' caan²¹mo coon'¹³ jna fu ñʉ'fú². ");
INSERT INTO chqNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ningóo¹ la tyiiañi'¹ mo galinʉʉ²¹ ni cwoo'¹³ juncwii²¹ gata'² ca gatɨ́² 'in² 'nɨ¹ ca 'lóo². ");
INSERT INTO chqNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Joon ñi'¹ galiniui²¹. Joon inʉʉ cwo'¹ fee'¹ si'² do lɨ 'íi¹ 'mɨ'², ga'gɨɨ¹ tún² tsa'² 'e 'mɨ'² 'íi¹ do. ");
INSERT INTO chqNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Joon ga'oo¹ Jesús jin'²in: ―Nʉ'³, ja'cwoo¹'o ityiia'¹³ alma tyiia. Joon mo ngayuui'¹³ gajin'² 'elo joon gajúun¹mo. ");
INSERT INTO chqNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Mo ganí²i 'in tyʉ'² to² fii²¹² 'láa² do jilaa'²¹ 'e galɨ́² joon gacwoo¹ 'maai'¹³ Dios jin'²in: ―'E la ja'²mo 'in tsañʉʉ'¹ lo 'in tyúui¹ 'áa¹mo no. ");
INSERT INTO chqNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Jileei'²¹ tsá² 'in téen²in jǿø²ø jilaa'²¹ 'e galɨ́² gangaliin¹ fa'í³ tyʉʉn¹ ni tsí². ");
INSERT INTO chqNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Pe jileei'²¹ 'in cwii¹in Jesús coon'¹³ tsamɨ́² 'in nigangɨ¹ coon'¹³on tɨ́² Galilea wíin² jaan¹ jǿø²ø jilaa'²¹ 'elo. ");
INSERT INTO chqNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Niseen²¹mo jaain²¹ tsañʉʉ'¹ tyúi¹, jo tsaa² røøi²¹, 'in nisii²¹ Sé². 'In seein²¹ fuu²¹ sii²¹ Arimatea lɨ tyʉ'² to² Judea 'ii. 'Ii jaain²¹ jee²¹² tsacøøi'¹³ 'in tyʉ'² to² tsá² Israel. ");
INSERT INTO chqNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","'In Sé² lo sɨjaan¹o mi tyʉ'² Dios to². La joon jo røø²¹ sɨ́ɨ²i coon'¹³ jilaa'²¹ 'e gajmaa¹a tsá² do. ");
INSERT INTO chqNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","'Wii'¹³ joon gangajǿøi² Pilato joon gangamɨɨ¹ɨ cuerpo tya' Jesús. ");
INSERT INTO chqNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Mo ngayuui'¹³ gaxaa²¹i Jesús tsaa' crúu¹³ joon gacɨɨn'²in coon'¹³ 'mɨ'² taa²¹. Joon ga'áa²mo tsi coon²¹ aan¹ lɨ́² tsaa' xá¹ lɨ jo 'in mo ga'áai² jiin'¹³ jaain²¹. ");
INSERT INTO chqNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","'E jmɨɨ²¹² no cwoun'ló² tya' jmɨɨ²¹² 'e 'ii'²¹ woo'²¹ tsá². Joon tɨ lɨ 'láa² 'wii²¹² 'e jmɨɨ²¹² do. ");
INSERT INTO chqNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","'In tsamɨ́² 'in ningɨɨ¹ coon'¹³ Jesús fu Galilea gangalíin² joon gajǿø²o 'oo² too²¹ 'aan¹ joongɨ xiiala roon¹ cuerpo tya' Jesús. ");
INSERT INTO chqNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Joon mo ngaliin¹ fu tya'a joon gatyaa¹ tyʉ́² jmɨɨ²¹ jmafuu²¹ coon'¹³ noo²¹². Joon gajaan¹o jmɨɨ²¹² 'ii'²¹ 'woo'²¹ tsá² jiin'¹³ la to² tyʉ'². ");
INSERT INTO chqNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Jmɨɨ²¹² ga'láa² 'wii²¹² semóo¹ 'in tsamɨ́² do gangalíin² 'áa³ 'oo²¹ too²¹ 'aan¹ do. Tyaan¹an jmɨɨ²¹ jmafuu²¹ 'e nigatyaa¹ tyʉ́². Joon ngalíin²mo tsamɨ́² catyaai²gɨ coon'¹³on. ");
INSERT INTO chqNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Mo gatyalíin² joon gatsaa'²¹ 'e cuun²¹² jnɨ¹ 'oo²¹ too²¹ 'aan¹ do jo si'²gɨ 'áan³ tya'. ");
INSERT INTO chqNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Joon ngataa²mo pe jo gatsaaa'²¹a cuerpo tya' Ña'ñʉ'¹ʉ' Jesús. ");
INSERT INTO chqNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","La 'ɨɨ²¹² téein² jo ñi¹i 'ee jmaa¹a coon²¹ gagoo¹‑o téein²¹ gái¹ tsañʉʉ'¹ 'in tyi'² 'mɨ'² jɨɨ'¹ co' lɨ téein². ");
INSERT INTO chqNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Joon gata'²a 'in tsamɨ́² do níi¹i ni 'wó² gafoo'²i lɨɨlɨ¹. Joon gajin'² 'in tsañʉʉ'¹ do: ―¿'Ee lɨ'ɨ 'naa'²¹naa' tsá² jiin'¹ jee²¹² 'lɨɨ²¹²? ");
INSERT INTO chqNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Jo 'yuui²gɨ lo. Najiin'¹o. Cwotii'¹³‑'oo' la gajin'²in mo gateein¹ Galilea. ");
INSERT INTO chqNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Gajin'²in 'e 'in Ruu'²¹i Tsá² 'ná² tsee'¹²i ja'cwoo²¹ tsá² røøi²¹ tsaa² 'e taan²in tsaa' crúu¹³. Joon mi tɨ́² 'nɨ¹ jmɨɨ²¹² joon jiin'¹o. ");
INSERT INTO chqNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Joon gatɨ'²‑tsi júu³ tya' Jesús. ");
INSERT INTO chqNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Joon mo ngayuui'¹³ gacɨɨ'¹²ɨ 'a 'oo²¹ too²¹ 'aan¹ do joon gasɨɨ'²¹o jɨ dyajaain²¹ tsá² tya' Jesús do coon'¹³ tsá² catyaai²gɨ 'e nigalɨ́². ");
INSERT INTO chqNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","'In ngacoon¹ júu³ tyani tsá² tya' Jesús do sii²¹ María Magdalena coon'¹³ Juana coon'¹³ María sáa³ Jacobo coon'¹³ tsamɨ́² catyaai²gɨ. ");
INSERT INTO chqNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pe tsá² tya' Jesús do galɨ́ɨ¹i 'e sɨxeei²¹²‑tsi 'in tsamɨ́² no. Joon jo jo'² galɨ́ɨ²i. ");
INSERT INTO chqNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pe gacwo'ɨ́ɨ¹ Tʉ́³ joon gangóo¹ cwiin¹ fu 'oo²¹ too²¹ 'aan¹ do. Joon mo gajǿø²ø joon ganí²i 'e 'mɨ'² taa²¹ do roon¹ lɨ' caai²¹. Joon ganga'²mo fu tya'a tsa'goo²¹‑tsi jilaa'²¹ 'e galɨ́². ");
INSERT INTO chqNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Jmɨɨ²¹² joon gái¹ jee²¹² 'ii do ngalíin² coon²¹ fuu²¹ sii²¹ Emaús 'e tɨ' jiin¹³ dyacoon²¹ kilómetros jiin'¹³ Jerusalén. ");
INSERT INTO chqNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ngalíin² tyaa¹ júu³ jilaa'²¹ 'e nigalɨ́² do. ");
INSERT INTO chqNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","La 'ɨɨ²¹² tyaa¹ júu³ sɨ́ɨ¹i 'e cwáain¹ do joon gangatyéein¹ Jesús. Joon ga'láa² 'wii²¹² ngɨɨ¹ coon'¹³on. ");
INSERT INTO chqNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Fiin'¹³ jǿø²o pe jo cwooi¹ licwii¹in 'ido. ");
INSERT INTO chqNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Joon gaunngɨɨ¹ɨ Jesús 'ii: ―¿'Ee 'e sɨ́ɨ¹³naa' lɨ cwolíin²naa' no? ¿'Ee lɨ'ɨ 'e ngɨɨ²ɨɨn' jmoo²oo' fa'í³? ");
INSERT INTO chqNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Jaain²¹ jee²¹² 'ii 'in sii²¹ Cleofas gañii¹i: ―La tóo²mo juncwii²¹ ñi¹i jilaa'²¹ 'e nigalɨ́² Jerusalén jee²¹² jmɨɨ²¹² lo. ¿Tɨ jaain²¹ 'nʉ‑ʉ 'in jó¹ fu do jo nagaliñí³'in? ");
INSERT INTO chqNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Joon gajin'² Jesús: ―¿'Ee ngalɨ́²? Joon gasɨɨ'²¹ɨ 'ido: ―La lɨ́² 'e galɨ́² cwáain¹ tya' Jesús tsá² Nazaret. Jaain²¹ tsá² cwo¹ júu³ tyʉ́² joon to² fee'¹ gajmaa¹a joon júu³ 'gøøi'¹² gafaa'²¹a tyani Dios coon'¹³ tyani tsá² taain²¹² juncwii²¹. ");
INSERT INTO chqNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Joon 'in tyʉ'² to² tya' untsá² coon'¹³ tsacøøi'¹³ tyi' gajaan'²¹mo 'ido 'e júun²mo 'ido joongɨ taan¹in tsaa' crúu¹³. ");
INSERT INTO chqNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Jna'oo'o mo lɨ́ɨ²na'a 'e ijmáa¹a tiin'¹³ tsá² seein²¹ Israel. Joon no nangóo¹ 'nɨ¹ jmɨɨ²¹² 'e gajúun¹in. ");
INSERT INTO chqNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Joon 'inlɨ́ɨi¹³ tsamɨ́² nangalíin² 'áa³ 'oo²¹ too²¹ 'aan¹. ");
INSERT INTO chqNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Joon jo gatsaa'²¹a cuerpo tya'a. Joon gajaliin¹ jajmaa'¹²a jna'a júu³ 'e niganii²¹ ángeles 'in gasɨɨ'²¹ 'ii 'e gajiin'¹in Jesús. ");
INSERT INTO chqNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Joon 'inlɨ́ɨi¹³gɨ tsá² jna'a gangalíin²mo 'oo²¹ too²¹ 'aan¹ do. Joon jin'²o la lɨ 'e jin'² 'in tsamɨ́² do, pe jo gangaai¹ Jesús. ");
INSERT INTO chqNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Joon gajin'² Jesús: ―¡Lɨ́ɨ¹ jo tsáai¹‑'oo' 'naa'! 'Áai¹ un'ɨɨi²¹²gɨ yaanaa' 'e litsáai¹‑'oo' la gajin'² tsá² 'in gacwo¹ júu³ tyʉ́². ");
INSERT INTO chqNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Tɨ jo 'ná² nii²¹ Cristo wúu¹ la nʉ'gɨ i'ii'²¹i to² tya'a ñʉ'fú²? ");
INSERT INTO chqNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Joon ga'láa² Jesús 'wii²¹² tyaa¹ júu³ la jin'² ni jí² tya' Dios. Ga'láa² 'wii²¹² coon'¹³ jí² tya' Moisés joon mi yuui'¹³ joon gatyaa¹gɨ júu³ cwáain¹ tya' 'e jí² catyiia²gɨ tya' tsá² gacwo¹ júu³ tyʉ́² calɨɨ. Gatyaa¹ júu³ jilaa'²¹a 'e faa'²¹ cwáain¹ tya' 'ña'a. ");
INSERT INTO chqNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Mo gatyaliin¹ la fuu²¹ lɨ ngaliin¹ do joon gajmaa¹a Jesús 'e tsáa¹gɨ la fu¹ 'yúu²i. ");
INSERT INTO chqNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Pe 'ido‑gɨ gamɨɨ¹ 'e jaan¹ Jesús, jin'²in: ―Ján² coon'¹³ jna'a tsʉ nica'loo¹. Joongɨ tɨ lɨ́² lɨnʉʉ²¹. Joon ga'ii'²¹ Jesús 'e jaan¹ coon'¹³on. ");
INSERT INTO chqNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Joon nityíin¹in caain²¹ 'e dø'²ø 'íi¹i coon'¹³ 'ido. Joon gason'¹o 'iñi'¹ joon gauncwaa'³i. Joon gajmaa¹a 'no'³. Joon gacwo'¹o 'ido. ");
INSERT INTO chqNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","La tsifu joon ganó¹ unníi¹in 'in tsá² do. Joon galicwii¹mo Jesús. Pe coon²¹ gaguu¹mo. ");
INSERT INTO chqNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Joon gasɨ́ɨ²i jee²¹² 'ii: ―'E la ja'²mo lɨ́ɨ¹ tyʉ́¹gɨ ga'ɨ́ɨ²‑tsi' la jalii²¹i' sɨ́ɨ¹³ɨ' tya'i fu¹ 'e tyaa²¹a' júu³ cwáain¹ tya' jí² tya' Dios. ");
INSERT INTO chqNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Joon jo 'ee gaun'ɨɨi²¹²gɨ. Tsifu joon gangatáa¹i fu¹ fu Jerusalén. Joon do‑o gatsee'²¹i jɨ dyajaain²¹ tsá² tya' Jesús sɨcaain²¹ coon'¹³ tsá² catyaai². ");
INSERT INTO chqNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Joon gasɨɨ'²¹ɨ 'in tsá² néei¹ Jerusalén 'ii: ―'E la ja'²mo nagajiin'¹in Jesús. Joon niganii²¹mo Simóoi¹³. ");
INSERT INTO chqNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Joon 'in tsá² gái¹ do gatyaa¹ júu³ 'e ningangɨɨi¹ tya'i fu¹ joon xiiala nigalicwii¹in Jesús mo gajmaa¹ Jesús tyíia³ 'e 'iñi'¹ do. ");
INSERT INTO chqNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Téen²mogɨ faa'²¹a 'e cwáain¹ do mo gajnéi¹ Jesús jee²¹² 'ii lɨ téein². Joon gajin'²in: ―Tyʉ́²‑ʉ 'íi¹ jee²¹² 'naa'. ");
INSERT INTO chqNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","'Ido‑gɨ gafoo'²mo. Joon lɨ́ɨ¹ 'goo'²¹o. 'ɨ¹‑tsi 'e jaain²¹ tsa'mootyí² níi²in. ");
INSERT INTO chqNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Pe gajin'² Jesús: ―¿'Ee lɨ'ɨ jo tsáai¹‑'oo' coon'¹³ almas tyii'? ");
INSERT INTO chqNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Jǿø²øø' cwóo³oo coon'¹³ tɨ́ɨ³ɨɨ. Tsei'² jna‑a lo. Sʉʉ'¹³ joongɨ jǿø²øø' tsʉ jaain²¹ tsa'mootyí² jo ngú¹ sá² jon'gɨ moo¹ taai² la 'óo³ jna. ");
INSERT INTO chqNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Mo gajin'²in 'elo joon ga'ee¹ cwoo²¹o coon'¹³ tɨ́ɨ¹ɨ. ");
INSERT INTO chqNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Pe 'ido‑gɨ jo tsáa¹mogɨ‑tsi coon'¹³ 'e jløø'³i coon'¹³ 'e tsa'goo²¹‑tsi. Joon gasɨɨ'²¹ Jesús 'ii: ―¿Tɨ 'oo²xʉʉ' 'uunñi² 'e døø'¹³øø? ");
INSERT INTO chqNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Joon gajin'²in: ―'E lo‑o ca'no'³ joo'²¹ taai² jmɨɨ²¹ 'e too'² coon'¹³ ca'no'³xʉ wa' to'². ");
INSERT INTO chqNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Joon ga'ii'²¹mo Jesús 'edo joon gagøø'²¹o tyani 'ido. ");
INSERT INTO chqNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Joon gasɨɨ'²¹ɨ 'ii: ―Jilaa'²¹ 'e nagangɨɨ¹na jiin'¹³ la nigafuu²¹²uu 'naa' mo gataain¹gɨɨ coon'¹³ 'naa'. Fuu²¹²uu 'naa' jilaa'²¹ 'ná¹ tséin¹ tyiia 'e taa'¹³ ni jí² tya' Moisés coon'¹³ jí² tya' tsá² gacwo¹ júu³ tyʉ́² calɨɨ coon'¹³ 'e jí² sii²¹ salmos. ");
INSERT INTO chqNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Joon gajmaa¹ Jesús 'e gangaai'²¹‑tsi 'ido 'e jin'² ni jí² do. ");
INSERT INTO chqNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Joon gasɨɨ'²¹ɨ 'ido: ―La lo‑o jin'² ni jí² tya' Dios 'e Cristo 'ná¹ nii²¹ wúu¹ joongɨ júun²in, joon mi tɨ́² jmɨɨ²¹² 'nɨ¹ 'ná¹ jiin'¹o jee²¹² 'lɨɨ²¹². ");
INSERT INTO chqNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Joon coon'¹³ jiin'¹³ 'e sii²¹ 'ii 'ná¹ cwo¹ tsá² júu³ la tǿøi² juncwii²¹. 'E 'láa² tsá² 'wii²¹² tɨ' Jerusalén 'e cwoo¹ júu³ 'e 'ná¹ ja'²a‑tsi tsá² tyani Dios joon 'íin²mo tsaa² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Joon 'naa' lɨ́ɨ¹naa' tsá² 'in jmaa¹a júu³ røø²¹ tya' 'e cwáain¹ lo. ");
INSERT INTO chqNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Tyaa¹aa' cwáain¹, jna‑a isɨ́ɨ³na jee²¹² 'naa' jiin'¹³ 'e gajin'² Ñʉ'³oo. Pe jan²duu' Jerusalén lo ca ga'ii'¹³naa' 'in Espíritu Tyʉ́² tya' Dios ijó¹ fu ñʉ'fú². ");
INSERT INTO chqNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Joon gangajée¹i Jesús 'ido fu lɨ ngɨ́ɨi¹ tɨ'² fuu²¹. Ca Betania ngalíin². Joon gasaa¹ Jesús cwoo²¹o. Joon gauncwaa'³i. ");
INSERT INTO chqNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Joon mo ngayuui'¹³ gauncwaa'³i joon gatyii¹mo 'ña'a. Joon ganga'²mo fu ñʉ'fú². ");
INSERT INTO chqNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Joon 'ido mo ngayuui'¹³ gaun'goo²¹ joon gangaliin¹mo fu Jerusalén jløø'³mo. ");
INSERT INTO chqNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Gangataai² cwo'¹ fee'¹ do cwoo¹ 'maai'¹³ Dios. Amén.");
INSERT INTO chqNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","La mo jéei¹ mo ga'láa² 'wii²¹² 'e sá² 'e galɨsá² seen²¹mo jaain²¹ 'in sii²¹ Júu³ tya' Dios. Joon 'in Júu³ do tyíin¹ coon'¹³ Dios Jmii²¹ la joon 'in Júu³ do lɨ́ɨ¹mo jon Dios Jmii²¹. ");
INSERT INTO chqNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","La mo 'wiin²¹² 'ii‑o siin'¹²in coon'¹³ Dios Jmii²¹. ");
INSERT INTO chqNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Joon to² tyʉ'²ʉ Dios Jmii²¹ 'ii‑o gajmaa¹a jilaa'²¹ 'e sá². Joon jiin'¹³ coon²¹ 'e sá² jo sá² wa jo gajmaa¹a 'ii. ");
INSERT INTO chqNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","'Ii‑o cwoo¹o juncwii²¹ tya' tsá². Joon lawa jɨ́² coo²¹ lɨ́ɨ¹i tsʉ coon'¹³ 'e jɨ́² do‑o jnéi¹ tsá² xiia'²¹ fu tsalíin². ");
INSERT INTO chqNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Joon 'e jɨ́² coo²¹ do cwoo¹o jɨ́² tya'a lɨ 'íi¹ nʉʉ²¹ joon 'e nʉʉ²¹ do jo mo lɨɨ'³ɨ dʉ́ʉ¹ʉ 'e jɨ́² do. ");
INSERT INTO chqNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Joon Dios gasii¹in jaain²¹ tsá² sii²¹ Wó³. ");
INSERT INTO chqNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","'In Wó³ do gajó² fu juncwii²¹ ifaa'²¹o cwáain¹ tya' 'e jɨ́² do 'e coon'¹³ la joon ilí² ñi¹ tsá² 'e gacwa'² 'e jɨ́² tya' Dios, joon jo'¹o iliin¹in. ");
INSERT INTO chqNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","'In Wó³ do jo lɨ́ɨ¹i 'e jɨ́² do jiin'¹³ 'e gasii¹in Dios 'ii 'e faa'²¹a cwáain¹ tya' 'e jɨ́² do. ");
INSERT INTO chqNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Joon 'e jɨ́² 'e jai'² do niga'láa² 'wii²¹² cwoo¹o 'e jɨ́² tya'a fu juncwii²¹ joon jnée²mo tsá² xiiala ngɨɨ¹ɨ tyani Dios. ");
INSERT INTO chqNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Gateen¹in 'in Júu³ tya' Dios do fu juncwii²¹ joon xʉfiin'¹³ 'ii‑o gajmaa¹a fu juncwii²¹ to² tyʉ'² Dios 'in tsá² taan²¹²in fu juncwii²¹ jo mo galicwii¹in. ");
INSERT INTO chqNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Gacwaa'¹³i fu ni cwoo'¹³ juncwii²¹ tya'a pe 'in tsagoo¹o jo ga'ii'²¹ 'ii. ");
INSERT INTO chqNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pe seen²¹mo 'in ga'ii'²¹ 'ii joon jo'¹o galɨ́ɨ²i. Joon tya' 'in tsá² 'in jmoo¹o la joon cwói¹ Dios 'ii iliin¹ jóon¹ Dios. ");
INSERT INTO chqNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Joon 'in tsá² 'in liin¹ jóon¹ Dios do jon'on galɨseein²¹ la lɨseein²¹ yʉʉn²¹ tsá² taain²¹² juncwii²¹ jon'gɨ galɨseein²¹ to² tyʉ'² tsá² jon'gɨ lɨseein²¹ la galɨseein²¹ jóon¹ tsamɨ́² coon'¹³ tsañʉʉ'¹ tsʉ lɨ́ɨ¹i jóon¹ Dios 'ii. ");
INSERT INTO chqNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Joon 'in Júu³ tya' Dios 'in seein²¹ coon'¹³on la mo 'wiin²¹² galɨ́ɨ¹i tsá² joon gacwoo²¹o jee²¹² jna' coon²¹ sii'¹³. Joon 'iin²¹²in tsá² 'áai¹ joon jmaai'² júu³ ja'²mo faa'²¹a. Galee²¹e' cwáain¹ 'e lɨ́ɨ¹i to² fee'¹gɨ joon 'e to² 'e lɨ́ɨi¹ do 'e tɨ́ɨ²i jiin'¹³ 'ii‑o tsʉ jiin'¹³ 'ii‑o Jóon¹ Dios Jmii²¹. ");
INSERT INTO chqNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Joon Wó³ gafaa'²¹o 'wii²¹² tya' 'e Júu³ do joon gajin'²in sɨɨ'²¹ɨ tsá² fúui¹: ―Mo gafuu²¹²uu 'naa': “Jaain²¹ 'in jó¹ cɨɨin²¹gɨ lagɨ jna, 'ii 'in feei'¹gɨ lagɨ jna tsʉ naseen²¹mo jéei¹gɨ lagɨ jna. 'Ino‑o 'i” ―jin'² Wó³. ");
INSERT INTO chqNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Joon tsʉ 'wii'¹³ feei'¹‑tsi 'áa¹mo ga'ii'¹³mo' 'e tyʉ́² tyi' la ca 'ii'¹³. ");
INSERT INTO chqNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Joon 'e ley do Moisés gacwo'¹o tsá² to² tyʉ'² Dios pe 'e liñi¹ tsá² 'e 'iin²¹²in Dios 'ii joon jilaa'²¹ júu³ 'e jai'² née³e' tsʉ 'wii'¹³ gacwéi¹ Jesucristo fu juncwii²¹. ");
INSERT INTO chqNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Jiin'¹³ jaain²¹ tsá² jo mo gangaa¹i Dios Jmii²¹ jiin'¹³ ca fu, pe 'in jaan²¹mo Jóon¹on niga'e'²mo jna' Dios Jmii²¹. Joon tɨɨ²¹i 'in Jóon¹on do 'e'²mo jna' xiiala lɨ́ɨ¹i Dios tsʉ tyíin¹mo coon'¹³ Dios Jmii²¹. ");
INSERT INTO chqNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jee²¹² jmɨɨ²¹² joon 'in tsá² Israel née¹i Jerusalén gasii¹in 'inlɨ́ɨi¹³ untsá² coon'¹³ 'inlɨ́ɨ¹³ tsá² coon²¹ poo²¹² sii²¹ levitas 'e tsafeei'¹³ Wó³. Joon mo gatyalíin² lɨ taan¹in Wó³ do gaunngɨɨ¹ɨ: ―¿'Iin 'nʉ? ");
INSERT INTO chqNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Joon coon'¹³ coon²¹ júu³ coon²¹ tsáa¹ gañii¹i: ―Jon'on jna Cristo. ");
INSERT INTO chqNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Joon gaunngɨɨ¹gɨ 'in tsá² do: ―¿'Iin 'nʉ jon? ¿Tɨ 'nʉ‑ʉ Elías, 'in tsá² 'in gacwo¹ júu³ tyʉ́² tya' Dios calɨɨ lɨ¹? Joon Wó³ do gañii¹i: ―Jon'on jna 'i. Joon tsifu gaunngɨɨ¹gɨ: ―'Áai¹ tɨ lɨ jó¹ jaain²¹ tsá² 'e ijacwoo²¹ júu³ tya' Dios; ¿tɨ 'nʉ‑ʉ 'i? Joon gañii¹i Wó³: ―Jon'on jna 'i. ");
INSERT INTO chqNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","'In tsá² do gajin'²in sɨɨ'²¹ɨ Wó³: ―¿'Iin 'nʉ jon? tsʉ 'ná¹‑a lee²¹e'e júu³ tya' 'in tsá² 'in gasii¹in jna'a. ¿Ee sii'¹³i'i cwáain¹ tyi'i? ");
INSERT INTO chqNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Wó³ dogɨ gañii¹i: ―Jna jaain²¹ 'in ngɨ¹ to² 'oo¹o fu coon²¹ lɨ jo 'in tsá² seein²¹, jna fuu²¹²uu tsá²: “'Ná²‑a ná³ coon²¹ fu¹ coon²¹ tsáa¹ tya' Ña'ñʉ'¹ʉ'” ―gajin'² Wó³ do. La nigajin'² 'in tsá² 'in gacwo¹ júu³ tya' Dios calɨɨ 'in sii²¹ Isaías. ");
INSERT INTO chqNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","'In tsá² do 'in jalíin² jafee'¹³i Wó³ do jalíin² to² tyʉ'² tsá² coon²¹ poo²¹² sii²¹ fariseos. ");
INSERT INTO chqNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Joon 'in tsá² jaliin¹ do gaunngɨɨ¹ɨ jin'²in gasɨɨ'²¹ɨ Wó³: ―¿'Ee lɨ' saa¹u'u tsá² jmɨɨ²¹ wa'a jon'on Cristo 'nʉ, jon'on Elías 'nʉ, jon'on 'in cwoo¹o júu³ tya' Dios 'nʉ? ");
INSERT INTO chqNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Joon Wó³ do gañii¹i: ―Jna‑a sáa¹³na tsá² jmɨɨ²¹ jiin'¹³ coon'¹³ jmɨɨ²¹; pe seen²¹mo jaain²¹ tsá² jee²¹² 'naa' 'in jo cwii¹naa'. ");
INSERT INTO chqNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Joon feei'¹gɨ 'ii lagɨ jna xʉfiin'¹³ cɨɨin²¹gɨxʉ lagɨ jna. Jo tɨ́ɨ²na sɨɨ'¹³ɨɨ loo²¹ tsi mɨ́ɨ¹ɨ. ");
INSERT INTO chqNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Jilaa'²¹ 'elo 'e galɨ́² coon²¹ lɨ sii²¹ Betábara lɨ 'ngoo'¹³ jmɨɨ²¹ Jordán lɨ 'yeei²¹ ñi'¹. Tsʉ do‑o taan¹in Wó³ saa¹i tsá² jmɨɨ²¹. ");
INSERT INTO chqNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Mo gajná² jmɨɨ²¹² joon Wó³ gangaa¹i Jesús jatyéen¹in co' lɨ siin'¹³ Wó³. Joon Wó³ do gasɨɨ'²¹ɨ 'in tsá² téen²in do: ―Tyaan²aan' cwáain¹. Ino‑o 'in 'iin² tsaa² tya' tsá² taain²¹² fu juncwii²¹ 'in gasii¹in Dios. Lɨ́ɨ¹i lawa joo'saa'²¹ 'in jngaai'¹³ tsá² Israel coon'¹³ la joon 'iin²in tsaa² tya' tsá². ");
INSERT INTO chqNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Nigafo'³oo cwáain¹ tya'a mo gafuu²¹²uu 'naa': “Cɨɨin²¹gɨ lagɨ jna ijó¹ jaain²¹gɨ 'in feei'¹gɨ lagɨ jna tsʉ 'ii 'in seein²¹ jée¹gɨ lagɨ jna.” ");
INSERT INTO chqNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ce jiin'¹³ jna jo ñíi³ii 'iin 'i, pe gagoo²¹²oo sáa¹³na tsá² jmɨɨ²¹ cwáain¹ 'e licwii¹in tsá² seein²¹ Israel 'i. ");
INSERT INTO chqNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Joon jin'²in Wó³ sɨɨ'²¹ɨ tsá²: ―Gamáa¹moo 'in Espíritu Tyʉ́² tya' Ña'ñʉ'¹ʉ' lɨ́ɨ¹i maa²¹² jgáa¹i fu ñʉ'fú² joon gajaan¹an coon'¹³ Jesús do. ");
INSERT INTO chqNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Jo mo lɨcwii¹na pe 'in nigasii¹in jna 'e sáa¹³na tsá² jmɨɨ²¹ sɨɨ'²¹ɨ jna: “Imáa¹mo'o 'in Espíritu Tyʉ́² tya' Ña'ñʉ'¹ʉ' xáa¹i joon iján² tya' jaain²¹ tsá². Joon 'in tsá² do‑o isáa¹i tsá² jmɨɨ²¹ coon'¹³ Espíritu Tyʉ́² tya' Dios.” ");
INSERT INTO chqNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Joon gamáa¹moo joon jmóo³oo júu³ jai'² 'e 'ido‑o lɨ́ɨ¹i Jóon¹ Dios Jmii²¹. ");
INSERT INTO chqNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Mo gajná² joon, jon do‑o tún¹ nisiin'¹²in Wó³ coon'¹³ gái¹gɨ 'in ngɨ́² coon'¹³on. ");
INSERT INTO chqNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Joon mo ganí²i Wó³ ngɨ́ɨ¹i Jesús, joon gajin'²in: ―Jǿøi²duu', 'ino‑o 'in gasii¹in Dios ityí²i tsaa² tya' tsá² lawa jaain²¹ joo'saa'²¹ xuui²¹² 'in jngaai'¹³ tsá² 'in tyí²i tsaa² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Joon 'in gái¹ 'in ngɨ́² coon'¹³ Wó³ do mo ganúu²un 'e faa'²¹a 'ido la do joon gangalíin² coon'¹³ Jesús. ");
INSERT INTO chqNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Joon gajiin'¹² Jesús níi¹i jǿø²ø ni 'ido 'e ngalíin²mo 'ido coon'¹³on. Joon gajin'²in sɨɨ'²¹ɨ 'ido: ―¿'Iin 'naa'²¹naa'? Joon gañii¹i 'ido: ―Tɨfo'² tyii'i, ¿xiia tyi' 'nʉ? ");
INSERT INTO chqNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesús gajin'²in: ―Ñiliin¹naa', cwojǿø²duu'. Joon gangaliin¹mo 'ido joon ganii²¹o xiia' tya' Jesús. Joon ca'lóo² 'e jmɨɨ²¹² joon 'e ningó¹ 'iin² tyʉ́n² ca'lóo² joon ganiuu'²mo. ");
INSERT INTO chqNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Joon Andrés sii²¹ jaain²¹ jee²¹² 'in gái¹ do 'in ganúu²un júu³ tya' Wó³ joon ngaliin¹mo coon'¹³ Jesús. Joon ruu'²¹i Dɨ́ɨ³ do tsá² ngaa'¹³i coon'¹³ sii²¹ Simón Pedro. ");
INSERT INTO chqNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Joon Dɨ́ɨ³ do tsifu nga'nee'¹³i Simóoi¹³ joon gasɨɨ'²¹ɨ: ―Nitsee'²¹moo'o Mesías (Mesías 'øøi'²¹‑tsi tsá² Cristo coon'¹³ jmíi¹ tya'a Dɨ́ɨ³ do. Joon coon'¹³ jmíi¹ 'øøi'²¹‑tsi tsá² Cristo 'in gatyii'¹³in Dios Jmii²¹.) ");
INSERT INTO chqNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Mo ngayuui'¹³ joon tø'²ø Dɨ́ɨ³ Simóoi¹³ fu lɨ tyíin¹ Jesús. Joon mo ganí² Jesús 'ii joon gajin'²in sɨɨ'²¹ɨ Tʉ́³: ―Simón sii²¹ 'nʉ, jóon¹ Jonás 'nʉ, pe cɨɨin²¹gɨ 'ilisii²¹ 'nʉ Cefas ('e 'øøi'²¹‑tsi tsá² Pedro.) ");
INSERT INTO chqNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Mo gajná² joon gali'iin²¹²in Jesús tsáa¹a coon²¹ lɨ sii²¹ Galilea. Joon do‑o gatsee'²¹i jaain²¹ tsá² sii²¹ Felipe, joon gajin'²in: ―Moo²¹o' coon'¹³ jna. ");
INSERT INTO chqNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Joon 'in Lii²¹² do tsagoo¹o Dɨ́ɨ³ coon'¹³ Tʉ́³ jaliin¹ coon²¹ fuu²¹ lɨ sii²¹ Betsaida. ");
INSERT INTO chqNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Joon Lii²¹² do ngóo¹o nga'nee'¹³i Natanael joon mo gatsee'²¹i joon sɨɨ'²¹ɨ: ―Ninee²¹²moo'o 'in tsañʉʉ'¹ do 'in faa'²¹a Moisés ni jí² tya' 'e ley do, joon 'in faa'²¹a 'in tsá² 'in gacwo¹o júu³ tya' Dios la mo jéei¹. Jesús 'ii, 'in jóon¹ José 'in seein²¹ fuu²¹ lɨ sii²¹ Nazaret. ");
INSERT INTO chqNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Joon gajin'²in Natanael: ―¿'Ee gon 'e tyʉ́² 'e cwo'ɨ́ɨi¹ Nazaret? Joon gañii¹i Lii²¹² do: ―Ñijǿø²du'. ");
INSERT INTO chqNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Joon mo ganí²i Jesús jatyéen¹in Natanael, joon gajin'²in: ―Logɨ nijó¹ jaain²¹ tsá² 'in la ja'²mo seein²¹ Israel, jo tajuui²¹ lɨ́¹. ");
INSERT INTO chqNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Joon gaunngɨɨ¹ɨ Natanael: ―¿Xiiala lɨ́² 'e cwii¹u jna? Joon Jesús‑gɨ gañii¹i: ―Nimáa¹moo 'nʉ 'wii²¹² 'mó² cworíi³ tyíin¹u'u la nʉ'gɨ itøø'²¹ Lii²¹² 'nʉ. ");
INSERT INTO chqNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Joon gajin'² Natanael sɨɨ'²¹ɨ Jesús: ―Tɨfo'² tyii'i, 'nʉ Jóon¹ Dios Jmii²¹; 'nʉ Rǿøi¹³ tya' tsá² Israel. ");
INSERT INTO chqNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Joon gañii¹i Jesús: ―¿Tɨ jo'¹o lɨ́ɨ²u jna tsʉ 'wii'¹³ gafuu²¹²uu 'nʉ 'e gamáa¹na 'nʉ 'wii²¹² 'mó² cwaríi³? Nogɨ imóo³gɨ'ɨ 'e fee'¹gɨ lagɨ la lɨ́² 'e gañi'²i do. ");
INSERT INTO chqNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","La joon jón² gajin'² Jesús: ―'E ja'²mo 'e fo'³oo lo, 'naa'oo' imoo²oo' ná¹ fu ñʉ'fú² joon imáa¹naa' ángeles tya' Dios Jmii²¹ soo²¹o joongɨ jgaa²¹i lɨ siin'¹³in jna 'in Ruu'²¹na Tsá². ");
INSERT INTO chqNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","'Nɨ́¹ jmɨɨ²¹² ningóo¹ joon gangó¹ sáa³ Jesús coon²¹ fuu²¹ sii²¹ Caná 'e ná¹ lɨ sii²¹ Galilea. Ngajǿø²ø coon²¹ lɨ cui'² cwoo²¹ tsá². ");
INSERT INTO chqNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ngó¹o jon Jesús coon'¹³ tsá² tya'a lɨ gatø'²ø tsá² 'ii 'e lɨ cui'² cwoo²¹ tsá². ");
INSERT INTO chqNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Joon la 'ɨɨ²¹² joon gatsá²‑a 'e vino 'uun'²¹un tsá². Joon gajin'²in sáa³ Jesús sɨɨ'²¹ɨ 'ii: ―Jo sá²gɨ vino 'uun'²¹un tsá². ");
INSERT INTO chqNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Pe joon gajin'²in Jesús: ―Saa²¹², ¿'ee lɨ 'e fu'²'u jna la joon? Jo mo tɨ́² 'ii'²¹ tyiia. ");
INSERT INTO chqNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Pe sáa³ Jesús gasɨɨ'²¹ɨ 'in tsá² jmoo¹o tyíia³ taa²i do: ―Jmaa²aa' jilaa'²¹ 'e jin'²in. ");
INSERT INTO chqNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Joon do‑o táan² jnʉ́ʉ² tu'² 'e lɨ́¹ cuun²¹² 'e nijmaai'²¹ 'in tsá² do to² jiin'¹³ la lɨ 'e nitɨ́ɨ²i run'²un. La coon²¹ tu'² do 'e ni'ó² ochenta joongɨ 'e 'ó² cíein¹³ litro jmɨɨ²¹. ");
INSERT INTO chqNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesús gajin'²in sɨɨ'²¹ɨ 'in tsá² jmoo¹o tyíia³ do: ―Tyíi¹³aa' jmɨɨ²¹ la røøi¹ tu'² no. Joon gaunrøø¹mo la tsijmuui²¹. ");
INSERT INTO chqNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Mo ngayuui'¹³ joon gajin'²in Jesús sɨɨ'²¹ɨ 'ido: ―'Naa' natyiin²xʉʉ' capii'³ joon cwocwóo¹³oo' 'in náa¹ ni² lɨ tɨ jmɨɨ²¹². La joon gajmaa¹a. ");
INSERT INTO chqNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Joon 'in tsá² náa¹ ni² lɨ tɨ jmɨɨ²¹² do ga'un'¹xʉ capi'³ 'e jmɨɨ²¹ do 'e galɨ́¹ vino, pe jo nii¹i xiia fu sá² 'edo. Jiin'¹³ la yaamo 'in jmoo¹o tyíia³ do ñii¹i. Tsʉ 'ii‑o gatyiin¹in 'e jmɨɨ²¹ do tsi tu'². La joon 'in náa¹ ni² do gatø'²o 'in tsá² gacui'² cwoo²¹o. ");
INSERT INTO chqNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Joon gajin'²in: ―Jiin'¹³ joon tɨɨ² 'e si'² tya' tsá² 'e cwo'¹o tsá² vino tyʉ́²gɨ tya' jileei'²¹ 'in tsá² taai² do nifu joon mo ngayuui'¹³ ga'un'¹un 'láai² joon cwo'¹o tsá² vino 'wéi¹gɨ. Pe 'nʉ‑ʉ ga'ma'²'a 'e vino tyʉ́²gɨ ca lɨ gatséi¹. ");
INSERT INTO chqNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","'Elo gajmaa¹a Jesús fu lɨ sii²¹ Caná lɨ tyʉ'² to² Galilea. 'E joon milagro 'e gajmaa¹a nifu 'e ga'ee¹e xiiala lɨ́ɨ¹i. Joon 'in tsá² ngɨ́¹ɨ coon'¹³on jo'¹o lɨ́ɨ²i. ");
INSERT INTO chqNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Mo ngɨ́ɨi¹ 'e galɨ́² la do gangóo¹ coon²¹ fuu²¹ sii²¹ Capernaum. Ngalíin² coon'¹³ sáa³a joongɨ coon'¹³ ruu'²¹i joongɨ coon'¹³ 'in tsá² 'in ngɨ́² coon'¹³on. Joon do‑o gajaan¹an coon²¹ tún² jmɨɨ²¹². ");
INSERT INTO chqNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Tsʉ najatyéein¹ jmɨɨ²¹² pascua tya' tsá² Israel gangó¹ Jesús fu fuu²¹ lɨ sii²¹ Jerusalén. ");
INSERT INTO chqNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Joon inʉʉ cwo'¹ fee'¹ si'² do gatsee'²¹i tsá² 'in 'nɨɨ¹i joo'²¹ joongɨ 'in 'nɨɨ¹i joo'saa'²¹ joongɨ 'in 'nɨɨ¹i maa²¹² joongɨ tsá² 'in née¹i lɨ unsɨɨ²¹i cuu² tya' tsá². ");
INSERT INTO chqNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Joon mo ganí²i Jesús 'elo joon gajmaa¹a coon²¹ sɨɨ² 'e tsí³ nii²¹² loo²¹ yʉ'. Joon ga'woo¹mo jileei'²¹ 'in taa²i co' cwo'¹ do fu caluu coon'¹³ jileei'²¹ 'in joo'saa'²¹ joongɨ coon'¹³ joo'²¹. Joongɨ tya' 'in unsɨɨ²¹i cuu² do gadya'²o cúu¹u ni'wó³ joongɨ gajiin¹mo mesa tya'a. ");
INSERT INTO chqNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Joongɨ jin'²in sɨɨ'²¹ɨ 'in tsá² 'nɨɨ²¹i maa²¹²: ―¡Wooi²naa' 'in no caluu! ¡Jo jmaa²aa' 'moo'¹³ inʉʉ tya' Ñʉ'³ʉʉ! ");
INSERT INTO chqNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Joon gatɨ'²‑tsi tsá² ngɨ́¹ɨ coon'¹³on 'e júu³ tyʉ́² taa'¹³ ni jí² tya' Dios 'e jin'²: “Áa¹mo 'iin²¹²na 'nʉ'²'ʉ joon jo cwóo³oo wa'a jmaa¹a tsá² 'e gó² tya'a.” ");
INSERT INTO chqNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Joon 'in tsá² seein²¹ Israel do gaunngɨɨ¹ɨ 'ido: ―¿'Ee li² lí² jmaa²'a jøø²¹ø'ø 'e cwee¹i 'e tsáai¹‑tsii'i 'e tɨ́ɨ²u jmaa²'a 'elo? ");
INSERT INTO chqNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Joon Jesús gajin'²i sɨɨ'²¹ɨ 'in tsá² do: ―Xee²naa' 'e cwo'¹ lo joon jee²¹² 'nɨ¹ jmɨɨ²¹² iun'yee¹moo tún¹. ");
INSERT INTO chqNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Joongɨ gañii¹i 'in tsá² Israel do: ―Tonló¹ tsi jnʉ́ʉ² jiin²¹ gala'ɨɨ²¹²i 'in gajmaa'¹³a 'e cwo'¹ lo; ¿tɨ 'nʉgɨ lii'¹i jmaa'¹³'a jee²¹² 'nɨ¹ jmii²¹²? ");
INSERT INTO chqNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Pe lɨ' jin'² Jesús cwáain¹ tya' 'e cwo'¹ tsʉ cuerpo tya'a 'ña'o 'e 'ee¹ do. ");
INSERT INTO chqNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","'Wii'¹³ cwáain¹ la joon mo gajiin'¹in Jesús jee²¹² 'lɨɨ²¹² joon gatɨ'¹‑tsi 'in tsá² ngɨ́² coon'¹³on 'e la lɨ́² 'e nijin'²i do jo'¹o galɨ́ɨ²i 'e júu³ taa'¹³ ni jí² tya' Dios coon'¹³ 'e júu³ 'e la lɨ́² 'e nijin'² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","La 'ɨɨ²¹² taan¹in Jesús fu Jerusalén do la 'ɨɨ²¹² joon gatɨ́² jmɨɨ²¹² pascua joon fúu¹mo 'áai¹ jo'¹o galɨ́ɨ²i 'ii. Jo'¹o galɨ́ɨ²i coon'¹³ jilaa'²¹ milagro nigajmaa¹a Jesús. ");
INSERT INTO chqNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pe cu'¹u‑tsi Jesús coon'¹³ 'ido tsʉ goon'¹³ ñii¹o 'e 'ɨ¹‑tsi 'ido. ");
INSERT INTO chqNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Jo 'in tyéen¹in jmɨɨ²¹² wa' 'in jma'² 'ii júu³ xiiala lɨ́ɨ¹i tsá² tsʉ 'ña'o niñii¹i jilaa'²¹ 'e 'ɨ¹‑tsi tsá². ");
INSERT INTO chqNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","'Yiia'¹³ joon seein²¹ jaain²¹ tsá² sii²¹ Nicodemo, lɨ́ɨ¹i tsá² fariseo. 'Ii 'in jée¹ jaain²¹ jee²¹² tsacøøi'¹³ 'in tyʉ'²ʉ to² jee²¹² 'in tsá² Israel. ");
INSERT INTO chqNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Joon 'in Nicodemo do ningóo¹o ngafee'¹³i Jesús lɨ' canʉʉ²¹. Joon nigasɨɨ'²¹ɨ: ―Tɨfo'² tyii'i, nee²oo'o 'e Dios gasii¹in 'nʉ i'e'²'e jna'a tsʉ ce jiin'¹³ jaain²¹ jo lí² jmá¹ milagro la lɨ 'e lii'¹ 'nʉ wa jo uncoon'¹³on Dios 'nʉ. ");
INSERT INTO chqNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Joon gajin'²in Jesús sɨɨ'²¹ɨ 'ii: ―'E júu³ ja'²mo fuu²¹²uu 'nʉ, 'in jo lɨseein²¹ 'múui² jo lí² tsatáa¹i lɨ tyʉ'² Dios to². ");
INSERT INTO chqNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Joon gaunngɨɨ¹ɨ Nicodemo: ―Pe ¿xiiala ilí² 'e lɨseein²¹ 'múui² jaain²¹ tsá² feei'¹? ¿Tɨ lí² tsa'ii¹i nʉ' tu'²u sáa³a wa'a liseein²¹ tún¹? ");
INSERT INTO chqNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Joon Jesús‑gɨ ganii¹i: ―'E júu³ ja'²mo fuu²¹²uu 'nʉ, 'in tsá² 'in jo mo galiseein²¹ coon'¹³ jmɨɨ²¹ joongɨ coon'¹³ 'in Espíritu Tyʉ́² tya' Dios jo lí² tsatáa¹i lɨ tyʉ'² Dios Jmii²¹ to². ");
INSERT INTO chqNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Tsʉ tsá²‑a lɨ́ɨ¹i 'in galiseein²¹ saa³ jmii²¹ tsá² pe jileei'²¹ 'in 'ii'²¹i juncwii²¹ tya'a tya' 'in Espíritu Tyʉ́² tya' Dios lawa'a coon²¹ juncwii²¹ 'e cwo¹ Dios. ");
INSERT INTO chqNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Jo tsa'goo'²¹‑'o'o 'e fuu²¹²uu 'nʉ: “Jilee'²¹mo 'ná¹ lɨseein²¹ 'múu²i.” ");
INSERT INTO chqNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Coon²¹ tyí² 'e 'íi¹ doñixiia' joon núu²un tsá² pe jo ñi¹i tsá² xiia' najó² sɨ xiia' tsáa¹a 'ee. La joon jon lɨ́ɨ¹i 'in nigacwo¹ 'in Espíritu Tyʉ́² tya' Dios juncwii²¹ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Joon gaunngɨɨ¹ɨ Nicodemo tún¹: ―¿Xiiala ilí² 'elo? ");
INSERT INTO chqNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Joon Jesús‑gɨ gañii¹i: ―¿Tɨ 'nʉ‑ʉ jaain²¹ tɨfo'² jee²¹² tsá² Israel 'in tɨɨ²¹i 'áai¹ joon jo 'øøi'²¹‑'o'o 'elo? ");
INSERT INTO chqNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","'E júu³ ja'²mo fuu²¹²uu 'nʉ, jna'a faa'¹³a'a jiin'¹³ 'e née³e'e. Joon júu³ ja'²mo jmoo²¹o'o jiin'¹³ 'e niganee²¹e'e. Pe 'naa' jo jo'¹ lɨ́ɨ²naa' 'e sii'¹³i'i. ");
INSERT INTO chqNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Wana jo jo'¹ lɨ́ɨ²naa' 'e fuu²¹²uu 'naa' cwáain¹ tya' 'e juncwii²¹ lo, 'áai jo i'øøi'²¹‑'oo' cwáain¹ tya' ñʉ'fú² fuu²¹²uu 'naa'. ");
INSERT INTO chqNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Ce jiin'¹³ jaain²¹ jo mo ngó¹o fu ñʉ'fú² jiin'¹³ 'ii 'in nigajgái¹ fu ñʉ'fú². Joon jiin'¹³ jna‑a 'in Ruu'²¹na Tsá² 'in gacwo² ñʉ'fú² nigajmaa¹a la joon. ");
INSERT INTO chqNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Joon la gasaa¹i Moisés 'in mɨɨ'²¹ lɨ́ɨ¹i ñí³ tsaa' 'mó² 'e jǿø²i tsá² 'ii fu lɨ jo 'in tsá² seein²¹ wa'a un'láai² Dios 'ii, la joon jon 'ná¹ saa¹i tsá² 'in Ruui'²¹ Tsá² tsaa' 'mó². ");
INSERT INTO chqNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Joon jileei'²¹ 'in jai'² lɨ́ɨ²i 'ii jo tee'²¹i lɨ 'ii²¹ pe taa'²¹a juncwii²¹ tya'a coon²¹ tøø²mo. ");
INSERT INTO chqNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Tsʉ 'áa¹mo gali'iin²¹²in Dios tsá² taain²¹² fu juncwii²¹, tsʉ 'wii'¹³ joon gacwóo¹i 'in jaan²¹mo Jóon¹on ijúun²in 'wii²¹² tya' tsá². 'E tya' jileei'²¹ 'in jai'² lɨ́ɨi² 'ii jo itsáa¹a fu lɨ 'ii²¹ pe taa'²¹a juncwii²¹ tya'a coon²¹ tøø²mo. ");
INSERT INTO chqNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Jo gasii¹in Dios Jóon¹on fu juncwii²¹ wa'a jmoo¹o 'ii'²¹ 'e júun²in tsá², gasii¹mo wa'a jmaa¹a tiin'¹³ tsá² 'wii'¹³ 'ii‑o. ");
INSERT INTO chqNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’Jileei'²¹ tsá² 'in jai'² lɨ́ɨ²i 'in Jóon¹ Dios do, jo ijmaa¹a Dios 'ii'²¹ tya'a wa'a tsáa¹a lɨ 'ii²¹ pe tya' jileei'²¹ 'in jo jai'² lɨ́ɨ²i 'ii nigajmaa¹a Dios 'ii'²¹ tya'a itsáa¹a lɨ 'ii²¹ tsʉ jo mo galijai'² lɨ́ɨ²i 'in jaan²¹mo Jóon¹ Dios Jmii²¹. ");
INSERT INTO chqNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Nigajmaa¹a Dios 'ii'²¹ itsalíin² lɨ 'ii²¹ 'in jo jai'² lɨ́ɨ²i Jóon¹on tsʉ 'in tsá² do jmoo¹o 'e gó². Joon mo gajó² 'e jɨ́² 'e jai'² 'e cwo¹ tsá² ñii¹i xiiala ngɨɨ¹ɨ tyani Dios jo ga'ii'²¹i 'in tsá² do 'e jɨ́² do tsʉ tɨ́²gɨ‑tsi ngɨɨ¹ɨ lɨ nʉʉ²¹ lagɨ lɨ sá² jɨ́². Joon tsʉ 'wii'¹³ joon nigajmaa¹a Dios 'ii'²¹ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Jileei'²¹ 'in jmoo¹o 'e gó² 'aa'¹o 'e jɨ́² do joon jo tsatyéen¹en co' 'e jɨ́² do tsʉ jo 'iin²¹²in 'e liñii¹i tsá² 'e gó² jmoo¹o. ");
INSERT INTO chqNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Pe tsatyéen¹mo co' 'e jɨ́² do jileei'²¹ 'in tɨ́²‑tsi jilaa'²¹ 'e jai'² tsʉ 'iin²¹²in liñii¹i tsá² 'e 'yaai¹‑tsi Dios coon'¹³ jilaa'²¹ 'e jmoo¹o. ");
INSERT INTO chqNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Mo ngayuui'¹³ joon, ningalíin²mo Jesús coon'¹³ 'in tsá² ngɨ¹ coon'¹³on fu lɨ sii²¹ Judea. Joon do‑o gajaan¹an coon'²¹ sii'¹³xʉ saa¹i tsá² jmɨɨ²¹. ");
INSERT INTO chqNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Taain¹ Wó³ fu lɨ sii²¹ Enón co' Salim. Saa¹i Wó³ jon tsá² jmɨɨ²¹ tsʉ 'áai¹ sá² jmɨɨ²¹ do. Joon do‑o gajalíin²mo tsá² wa'a saa¹i Wó³ 'ii jmɨɨ²¹. ");
INSERT INTO chqNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Jilaa'²¹ 'elo galɨ́² la nʉ'gɨ gataain'¹³ tsá² Wó³ 'nʉñí³. ");
INSERT INTO chqNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Joon 'inlɨ́ɨi¹³ tsá² 'in ngɨɨ¹ɨ coon'¹³ Wó³ ga'láa² 'wii²¹² jo cwo'¹o júu³ ruu'²¹i coon'¹³ 'inlɨ́ɨi¹³ tsá² Israel cwáain¹ tya' 'e run'²un tsá² jiin'¹³ la tɨɨsi'². ");
INSERT INTO chqNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Joon ngalíin², ngafee'¹³i Wó³ joon gajin'²in sɨɨ'²¹ɨ Wó³ do: ―Tɨfo'² tyii'i, 'in taain¹ coon'¹³ 'nʉ lɨ' ngoo'¹³ jmɨɨ²¹ Jordán lɨ 'yee²¹ 'ñi'¹ joon gasii'¹³'i jna'a cwáain¹ tya'a; nano saa¹i tsá² jmɨɨ²¹ joon jilee'²¹mo tsá² ngɨɨ¹ɨ coon'¹³on. ");
INSERT INTO chqNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Joon jin'² Wó³ sɨɨ'²¹ɨ 'ido: ―Cwó² Dios jilaa'²¹ 'e sá² tya' tsá². Joon jiin'¹²xʉ jo 'ee 'oo¹o wana jo mo cwó² Dios. ");
INSERT INTO chqNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","'Naa' niganʉʉ²ʉʉn' júu³ tyiia mo gafuu²¹²uu 'naa' júu³ coon²¹ tsáa¹ 'e jon'on jna Cristo. Jna jaain²¹ tsá² gasii'¹in Dios ingɨ́³ɨɨ tyaníi¹in 'e jmoo'¹³oo tsá² júu³ 'e tɨ́² lɨ jó¹ Cristo. ");
INSERT INTO chqNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Joon jløø'³moo 'e tsalíin² tsá² tsanʉ́ʉ²ʉn júu³ tya' 'ido. Jmóo³‑oo la jmoo¹o tsá² mo tsalíin² fu lɨ cui'² cwoo²¹ tsá². Jløø'³mo 'in tsá² do 'wii²¹² tya' tsá² gacui'² cwoo²¹. Ga'ii'²¹mo 'in tsamɨ́² do 'ii. La joon jon jna jløø'³moo mo 'ii'²¹i tsá² 'in Cristo do. ");
INSERT INTO chqNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","'Ná²‑a 'e lɨfeei'¹gɨ 'ii joon jna ixaai¹gɨɨ ―jin'² Wó³ do cwáain¹ tya' Jesús. Faa'²¹gɨ Wó³ do jin'²in: ");
INSERT INTO chqNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","―'In gajgái¹ fu juncwii²¹ feei'¹gɨ 'ii²¹ lagɨ jileei'²¹ tsá². 'In tsá² taain²¹² fu juncwii²¹ lo ñii¹o jiin'¹³ 'e sá² fu juncwii²¹ lo, la joon sɨ́ɨ¹i. Pe 'in nicwa'ɨ́ɨ¹ɨ ñʉ'fú² jgáa¹i fu juncwii²¹ feei'¹gɨ 'ii lagɨ jileei'²¹ tsá², ");
INSERT INTO chqNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","joon jmoo¹o júu³ jai'² jilaa'²¹ 'e niganii²¹²in coon'¹³ jilaa'²¹ 'e niganúu²un. Pe jiin'¹³ jaain²¹ jo 'in jo'¹ lɨ́ɨ²i júu³ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Pe jilee'²¹ 'in 'ii'²¹i júu³ tya'a jmo'²o tsá² júu³ 'e júu³ jai'² 'e júu³ tya' Dios do. ");
INSERT INTO chqNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Joon 'ii 'in gasii²in Dios faa'²¹a jmai'² júu³ tya' Dios, tsʉ gacwóoi¹ Dios 'in Espíritu Tyʉ́² tya'a 'e gasá¹i. ");
INSERT INTO chqNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Joon 'áa¹mo 'iin²¹²in Dios Jmii²¹ Jóon¹on joon gajan'²an cwoo²¹o jilaa'²¹ 'e sá². ");
INSERT INTO chqNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Jileei'²¹ 'in jai'² lɨ́ɨ²i 'in Jóon¹ Dios do taa'²¹a juncwii²¹ tya'a coon²¹ tøø²mo. Pe 'e'²e Dios wúu¹ 'áai¹ jileei'²¹ 'in jo 'ii'²¹i Jóon¹on. Joon jo taa'²¹a juncwii²¹ tya'a coon²¹ tøø²mo. ");
INSERT INTO chqNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Galiñii¹ 'in tsá² fariseos 'e fúu¹mo tsá² gangalíin² coon'¹³ Jesús lagɨ Wó³. La joon jon fúu¹mo 'in saai¹ jmɨɨ²¹ lagɨ Wó³. ");
INSERT INTO chqNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Pe tsei'² jo saai¹ Jesús tsá² jmɨɨ²¹ jiin'¹³ 'in ngɨ¹ coon'¹³o 'in saai¹ tsá² jmɨɨ²¹. ");
INSERT INTO chqNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Joon mo galiñii¹i Jesús 'elo joon gacwo'ɨ́ɨ¹ɨ fu lɨ sii²¹ Judea joon itsee'¹³i fu lɨ sii²¹ Galilea. ");
INSERT INTO chqNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","8","Joon fu lɨ ngangɨ́ɨ¹i 'ná¹ ngɨ́ɨ¹i coon²¹ lɨ sii²¹ Samaria. Joon náa¹ coon²¹ fuu²¹ sii²¹ Sicar. Joon co' joon roon¹on coon²¹ sii'¹³ 'wó² 'e gacwo'¹ 'lɨɨ²¹² Jacob jóon¹on 'lɨɨ²¹² Sé² calɨɨ. Joon nityí³ coon²¹ too²¹ lɨ nisá² jmɨɨ²¹ 'e sii²¹ la sii²¹ Jacob. Jesús tyaliin¹ coon'¹³ tsá² tya'a 'in ngɨɨ¹ɨ coon'¹³ 'e lɨ tyí³ too²¹ do mo tɨ́² tyiiañi'¹ joon ni'woo'²¹‑o 'áai¹. Joon tsá² tya'a do nilíin² 'e fuu²¹ ni náa¹ tyan' do ningalá¹ 'e idø'¹ø. Joon gacwó² Jesús caai² lɨ tyí³ too²¹ do. La 'ɨɨ²¹² tyíin¹in joon tyía¹ jaan²¹ tsamɨ́² seein²¹ Samaria tsacoon¹ jmɨɨ²¹ 'e tsi too²¹ do. Joon gajin'² Jesús: ―Cwoo'¹³xʉ jna jmɨ́ɨ¹³'ɨ. ");
INSERT INTO chqNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Joon 'in tsamɨ́² do nigajin'²in sɨɨ'²¹ɨ Jesús: ―¿Xiiala 'e mɨɨ'¹³ 'nʉ jna jmɨɨ²¹, tsʉ tsá² seein²¹ Israel 'nʉ joon jnagɨ 'in seein²¹ fu Samaria? (Joon gajin'²o la joon tsʉ jo tyʉ́² seein¹ coon'¹³ 'in tsá² seein²¹ fuu²¹ do.) ");
INSERT INTO chqNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Joon gañii¹i Jesús: ―Waxʉ' lɨ 'nʉ ñi²'i jilaa'²¹ 'e cwo¹ Dios joon 'iin 'in mɨ¹ jmɨɨ²¹ lɨ́ɨ²u, 'nʉ‑ʉ nogɨ mɨ́ɨ¹²'ɨ jna‑a joon jnagɨɨ icwo'²oo 'nʉ jmɨɨ²¹ 'e jiin'¹in. ");
INSERT INTO chqNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Joon gañii¹i 'in tsamɨ́² do sɨɨ'²¹ɨ Jesús: ―Tsañʉʉ'¹ jo ñi²'i xiiala søø'¹³'ø jmɨɨ²¹ 'e tsi too²¹ no jiin'¹³ 'nii²¹² jo tyan²'an tsʉ 'o'²o 'e tsi too²¹ no. ¿Xiiala icwo'²'o jna² jmɨɨ²¹ 'e jiin'¹? ");
INSERT INTO chqNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","'Lɨɨ²¹² tsacøøi'¹³ tyi' 'in ningɨɨ¹i Jacob 'in gasáa¹a 'e too²¹ sá² jmɨɨ²¹ no tyi jna'a. Tsʉ 'e jmɨɨ²¹ sá² noo jon ga'un'¹un 'ña'a coon'¹³ jóon¹on joongɨ coon'¹³ joo'núu³ tya'a. ¿Tɨ joon lɨ́ɨ²u 'e feei'¹gɨ 'nʉ lagɨ 'ii? ");
INSERT INTO chqNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Joon gajin'²in Jesús: ―Jileei'²¹ 'in 'uun'²¹ 'e jmɨɨ²¹ no 'in 'yá² 'unjmɨɨ²¹mo 'i tún¹. ");
INSERT INTO chqNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Pe jileei'²¹ 'in 'uun'²¹ 'e jmɨɨ²¹ cwóo³ jna jo jmɨɨ²¹² 'ya'²gɨ 'unjmɨ́ɨ¹i. Tsʉ jmɨɨ²¹ 'e cwóo³ jna lɨ lawa coon²¹ lɨ nii'¹³ jmɨɨ²¹ 'e lɨ tsi alma tya'a. Joon 'e jmɨɨ²¹ 'e nii'¹³ do icwoo¹o juncwii²¹ tya'a 'e seein²¹ coon²¹ tøø²mo. ");
INSERT INTO chqNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Joon gajin'²in 'in tsamɨ́² do: ―Tsañʉʉ'¹, sɨ cwoo'¹³ jna 'e jmɨɨ²¹ no tsʉ joon jo 'yá²gɨɨ unjmɨɨ²¹na. Joon jo 'ná²gɨɨ yatyíin³aan jmɨɨ²¹ 'e lɨ tyí³ too²¹ lo. ");
INSERT INTO chqNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Joon gajin'²in Jesús: ―Cwooi'², cwotee²'e ñʉʉ'¹ tyi'i. Joon ñiliin¹naa' fu lo. ");
INSERT INTO chqNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Joon ganii¹ 'in tsamɨ́² do: ―Jo seein²¹ ñʉʉ'¹ tyiia. Joon gajin'²in Jesús: ―Jo'¹o júu³ tyi'i 'e foo'²¹'o jo nʉʉ'¹ tyi'i seein²¹. ");
INSERT INTO chqNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Tsʉ nigacu'²mo cwoo¹'o 'ñá² naa'¹³, joon 'in coon'¹³on la no jon'¹ ñʉʉ'¹ tyi'i 'i. 'E nija'²mo 'e foo'²¹'o. ");
INSERT INTO chqNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Mo ganúu²un 'in tsamɨ́² 'e júu³ do joon gajin'²in: ―Tsañʉʉ'¹, 'ɨ¹‑tsii 'e lɨ́ɨ¹u'u jaain²¹ tsá² 'in cwo¹ júu³ tyʉ́² tya' Dios. ");
INSERT INTO chqNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","'Lɨɨ²¹² tsacøøi'¹³ tyii'i 'in galiseein²¹ Samaria gaun'goo²¹o Dios 'e moo'²¹ lo. Pe 'naa', tsá² seein²¹ Israel, foo'²¹ 'naa' 'e jiin'¹³ fuu²¹ lɨ sii²¹ Jerusalén lɨ lí² un'goo²¹o tsá² Dios. ");
INSERT INTO chqNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Joon gañii¹ Jesús: ―Jo'¹ cwolii¹un jna, yá³, 'e nijatyéen¹mo tyan'²an 'e un'goo²oo' Ña'ñʉ'¹ʉ' jo tyiin² ñilíin²naa' 'e moo'²¹ lo jogɨ tyiin² cwolíin²naa' fu Jerusalén. ");
INSERT INTO chqNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","'Naa' tsá² seein²¹ Samaria, jo ñii²ii' 'naa' 'iin 'in un'goo²oo'. Pe jna'a né²oo'o 'iin 'in un'goo²¹o'o, tsʉ Dios gacwo'¹o jna'a tsá² saan²¹a'an Israel 'e júu³ tya' 'e tiin'¹³ tsá². ");
INSERT INTO chqNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Pe itɨ́²‑ɨ 'ii'²¹ joon 'ii'²¹ joongɨ tɨ́² la no wana 'e la jai'² 'e un'goo²¹o tsá² Ñʉ'¹ʉ' iun'goo²¹o 'ii jiin'¹³ coon'¹³ 'ii'²¹ tya' 'in Espíritu Tyʉ́² tya'a joongɨ coon'¹³ 'e la jai'². Tsʉ la joon 'iin²¹²in Ñʉ'¹ʉ' 'e un'goo²¹o tsá² 'ii. ");
INSERT INTO chqNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Tsʉ Dios 'in Espíritu Tyʉ́² joon tsʉ 'wii'¹³ joon 'in un'goo²¹o 'ii 'ná¹ un'goo²¹o coon'¹³ 'ii'²¹ tya' 'in Espíritu Tyʉ́² tya'a joongɨ coon'¹³ 'e la jai'². ");
INSERT INTO chqNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Joon gajin'²in 'in tsamɨ́² do: ―Jna niñi²oo ijó¹ Mesías ―'øøi'²¹‑tsi tsá² 'e Cristo do―; joon mi cwee¹i joongɨ ijin'²in sɨɨ'²¹ɨ jna' jilaa'²¹. ");
INSERT INTO chqNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesús‑gɨ gajin'²in: ―Jna‑a 'in fee'²ee 'nʉ, jnagɨɨ jon fuu²¹²uu 'nʉ. Jna‑a 'i. ");
INSERT INTO chqNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Tsifu joon gatyaliin¹ tsá² tya'a gani'goo²¹o‑tsi 'e Jesús do siin'¹³in fee'²¹i jaain²¹ tsamɨ́². Pe jiin'¹³ jaain²¹ jo tá²‑tsi wa 'e ungɨɨ¹ɨ 'ee 'iin²¹²in 'ido owa 'ee‑gɨ júu³ tyaa¹ 'ido. ");
INSERT INTO chqNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Joon 'in tsamɨ́² do, do‑o gatʉʉ¹ʉ tsʉ́ʉ¹ʉ joon gangaa'¹³mo fu 'e fuu²¹ 'ido‑o. Joon ganijmaa'¹³a tsá² júu³: ");
INSERT INTO chqNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Ñijøø²¹²i duu' jaain²¹ tsañʉʉ'¹ 'in nigasɨɨ'²¹ɨ jna jilaa'²¹ 'e nigajmáa³aa. ¿Wa jon' 'ino‑o 'in Cristo? ");
INSERT INTO chqNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Joon ga'woo²¹i 'e fuu²¹ do joon ganilíin² lɨ siin'¹²in Jesús. ");
INSERT INTO chqNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","La 'ɨɨ²¹² joon 'in ngɨ́¹ɨ coon'¹³ Jesús do gamɨɨ¹ɨ tyani 'ido, gajin'²in sɨɨ'²¹ɨ 'ido: ―Tɨfo'² tyii'i, cøø'²¹xʉ'ʉ. ");
INSERT INTO chqNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Pe joon 'ii gajin'²in: ―'Óo³oo 'e døø'¹³øø lɨ 'naa' jo ñí³oo'. ");
INSERT INTO chqNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Joon 'in ngɨ́¹ɨ coon'¹³ 'ido gacaain'¹³ 'wii²¹² unngɨɨ¹ɨ ruu'²¹i: ―¿Xʉfoo' seen²¹in 'in nijacon¹on 'e dø'²ø 'ino 'ee? ");
INSERT INTO chqNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Pe joon gajin'²in Jesús sɨɨ'²¹ɨ 'ido: ―Mi jmáa³aa jilaa'²¹ 'e 'iin²¹²in 'in gasii²¹in jna joongɨ 'e tyee²¹ to² tya'a 'e joon lawa unñi² tyiia. ");
INSERT INTO chqNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","'Naa' foo²¹oo': “'Ná²gɨ tyúuin² sɨɨ'²¹ 'e joongɨ ilee²¹e' jilaa'²¹ 'e garoo²¹”; pe jna fuu²¹²uu 'naa': tyán²duu' cwáain¹ lɨ sɨjna² la gatón¹ náa² nilii²¹² coon¹on tsá². ");
INSERT INTO chqNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Joon jileei'²¹ 'in jmoo¹o to² joon coon¹o jilaa'²¹ 'e garoo¹o do 'e joon 'e nicɨ́² tya'a. Joon 'e garoo¹o do 'e coon¹on 'in tsá² do lɨ la lɨ́ɨ¹i 'in tsá² 'in 'ii'²¹ juncwii²¹ tya'a 'e taa'²¹ coon²¹ tøø²mo mo jai'² lɨ́ɨi² 'e júu³ tya' Dios. Joon coon²¹ la joon jløø'³mo coon²¹ caan²¹mo 'in gajñí²i coon'¹³ 'in gacón¹on do. ");
INSERT INTO chqNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Tsʉ júu³ ja'²mo 'e gasɨɨ'²¹ɨ tsá²: “In gajní²i do jmai'² tyiin²mo coon'¹³ 'in gacón¹on do.” ");
INSERT INTO chqNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Jna‑a gasɨ́ɨ²na 'naa' 'e cwotyiin²aan' 'e do lɨ jo 'e gajñí²ii' do. In xee'²¹mo gajmaa¹a to² do joon 'naa'gɨɨ' coon'²¹ tyatyiin²¹oo' 'e to² nijmaa¹a 'ido ―jin'² Jesús do. ");
INSERT INTO chqNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Joon fúu¹mo 'in tsá² seen²¹in 'e fuu²¹ do lɨ tyʉ'² to² Samaria jo'¹o galɨ́ɨ²i Jesús 'wii'¹³ 'e júu³ gatya¹ 'in tsamɨ́² do mo gajin'²in: “'In tsañʉʉ'¹ no gajin'²in jilaa'²¹ 'e nigajmáa³aa.” ");
INSERT INTO chqNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Joon mo gajalíin² 'in tsá² seen²¹in Samaria do gamɨɨ¹ɨ tyani Jesús wa iján²an 'ido coon'¹³on. Joon Jesús gajaan¹an tún² jmɨɨ²¹² coon'¹³ 'ido. ");
INSERT INTO chqNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Joon fúui¹ lɨ́¹ lɨ́ɨ¹gɨ 'in jo'¹ galɨ́ɨ²i mo ganúu²un jilaa'²¹ 'e jin'² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Joon jin'²in 'in tsá² do sɨɨ'²¹ɨ 'in tsamɨ́² do: ―Nogɨ jo'¹o nilɨ́ɨ²i jna'a jon' wa'a jiin'¹³ júu³ 'e ni tya'³ 'nʉ pe jna'a ninʉ́³oo'o júu³ tya'a joon nee²oo'o 'e ja'²mo Cristo 'ii 'in jmoo¹o tiin'¹³ tsá² taan²¹²in juncwii²¹. ");
INSERT INTO chqNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Mo gangɨ́ɨ¹i tún² jmɨɨ²¹² joon gacwo'ɨ́ɨ¹ Jesús lɨ sii²¹ Samaria joon gangóo¹‑o fu¹ 'yúu²i fu lɨ sii²¹ Galilea. ");
INSERT INTO chqNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jo gajaan¹an fuu²¹ lɨ sii²¹ Nazaret la lɨ 'e nigajin'²in 'ña'a Jesús, “Jaain²¹ 'in tsacwo¹o júu³ tyʉ́² jo 'ii'²¹i tsagoo¹o 'ii.” ");
INSERT INTO chqNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Joon mo gatyíi¹a lɨ sii²¹ Galilea joon 'in tsá² seen²¹in joon ga'ii'²¹mo 'ido 'e tyʉ́²‑ʉ. Tsʉ 'in tsá² do ni' nilíin²mo lɨ tɨ jmɨɨ²¹² pascua fu Jerusalén. Joon do‑o niganii²¹i jilaa'²¹ 'e nijmaa¹a Jesús lɨ tɨ jmɨɨ²¹² do. ");
INSERT INTO chqNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Joon gacɨɨ'¹³ɨ Jesús, gangaa'¹³i tún¹ fuu²¹ Caná náa¹ lɨ sii²¹ Galilea. Fuu²¹ joon lɨ nijmaa¹a jmɨɨ²¹ 'e galɨ́ɨ¹ vino. Joon tyíin¹in fuu²¹ Capernaum jaain²¹ 'in ni'oo¹o to² fee'¹ tyani² rǿøi¹³. Joon seen²¹in jaain²¹ jóon¹on 'in nitsaa'¹³. ");
INSERT INTO chqNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Joon mo ganúu²un 'in tsá² 'oo¹o to² do 'e nityía¹ Jesús fu Galilea, jaa'¹³i fu lɨ sii²¹i Judea, joon gangó¹o 'in tsá² do gangamɨɨ¹ɨ tyani Jesús wa 'ii'²¹i 'ido itsáa¹a fu tya' 'in tsañʉʉ'¹ do tsajmaa¹a mɨ́¹ tya' jóon¹on 'ido. Tsʉ tɨ li ijúun¹mo 'ido. ");
INSERT INTO chqNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Joon Jesús do gajin'²in gasɨɨ'²¹ɨ 'ido: ―'Naa' jo jo'¹ lɨ́ɨ²naa' wa jo jéei¹³ gañii²ii' li² coon'¹³ jilaa'²¹ milagros. ");
INSERT INTO chqNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Pe 'in tsá² 'oo¹o to² do gajin'²in: ―Laa'¹³xʉ'ʉ góo³oo, lɨ́ɨ³na tɨ jo jmaa²'a feei'¹‑'o'o 'wii²¹² tyiia wa'a tsá²a' cwojmaa'¹³'a mɨ́¹ tya' yʉʉn²¹ tyiia la nʉ'gɨ ijúun²in. ");
INSERT INTO chqNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Joon gajin'²in Jesús: ―Cwooi'¹³ fu tyi'i tsʉ yʉʉn²¹ tyi'i nityú¹mo. Joon 'in tsañʉʉ'¹ do jo'¹o lɨ́ɨ²i júu³ tya' Jesús joon ganga'²mo. ");
INSERT INTO chqNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Joon ngóo¹o gatye'²mo tya'a mo ga'wooi²¹ tsa'leei'¹³ tya'a gangaunjiin'¹ 'ii. Joon gajin'²in 'in tsa'leei'¹³ tya'a do: ―Nityú¹mo yʉʉn²¹ tyi'i do. ");
INSERT INTO chqNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Joon gaunngɨɨ¹ɨ 'ee 'ii'²¹ 'e ga'láa²i 'in jóon¹on do. Joon gajin'²in 'in tsa'leei'¹³ do: ―Ca mo tyíia² la ngó¹o 'iin² coon²¹ gacwó² tyíi². ");
INSERT INTO chqNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Joon galili'³ jmii²¹ 'in xuui²¹² do 'e 'ii'²¹ joon mo gajin'² Jesús do: “Cwooi'¹³ fu tyi'i tsʉ yʉʉn²¹ tyi'i nityú¹mo.” Joon 'ña'a 'in tsá² 'oo¹o to² do jo'¹o lɨ́ɨ²i Jesús coon'¹³ 'in tsá² seein²¹ inʉʉ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","'Elo galɨ́² tɨ tún² milagro 'e gajmaa¹a Jesús mo tyee'¹³i Galilea jaa'¹³i Judea. ");
INSERT INTO chqNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Mo ngayuui'¹³ 'elo joon gatɨ́² jmɨɨ²¹² tya' tsá² seein²¹ Israel joon Jesús gangó¹o tún¹ fu fuu²¹ lɨ sii²¹ Jerusalén. ");
INSERT INTO chqNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ce cu'² jiin²¹ 'e fuu²¹ do lɨ goon²¹ 'yá² lɨ́² cuun²¹² ñíi¹ 'áai¹. Joon tyí³ coon²¹ 'ooca'nʉ́¹ fee'¹ 'e sii²¹ la sii²¹ Joo'saa'²¹. Joon co' joon náa¹ coon²¹ pila fee'¹ 'e 'o² jmɨɨ²¹ 'e sii²¹ Betesda coon'¹³ jmíi¹ 'e sii²¹ hebreo. Joon cu' lɨ' do joon sá² 'ñá² 'ooca'nʉ́¹ coo'¹³. ");
INSERT INTO chqNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Joon do‑o teei'¹³ tsatsaa'¹³ fúui¹ 'e ni 'wó². Tsá² 'in tyan¹ jilaa'²¹ nii² jmoowúu¹. Seein²¹ 'in tíu¹i, joongɨ seein²¹ 'in jluui'¹³, joongɨ seein²¹ 'in 'ɨ́ɨ¹ tá² cwoo²¹o tɨɨ²ɨ. Joon 'in tsatsaa'¹³ do 'in jáan¹³an ijøø'²¹ 'e jmɨɨ²¹ do. ");
INSERT INTO chqNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Joongɨ la coon'²¹ naa'¹³ jgaa¹i jaain²¹ ángel lɨ náa¹ pila do joon jø'¹ø jmɨɨ²¹ do. Joon 'in nifu 'in ga'í² tsi jmɨɨ²¹ do joon ga'láa²mo coon'¹³ 'e jmoowúu¹ tyaan¹an do. ");
INSERT INTO chqNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Joon do‑o niraan¹in jaain²¹ tsá² 'in ni'oo¹o dyadya¹ tsi jná² jiin²¹ 'e nitsaa'¹³a. ");
INSERT INTO chqNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Joon mo ganíi²in Jesús 'indo 'e raan¹in joon galɨli'³ Jesús 'e lɨ́ɨ¹‑ɨ nitsaa'¹³a 'ido joon nigajin'²in Jesús: ―¿Tɨ 'iin²¹²un 'láa²o? ");
INSERT INTO chqNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Joon gañii¹i 'in tsatsaa'¹³ do: ―Tsañʉʉ'¹, jo 'in seein²¹ taan'²i jna tsi pila no mo jøø'²¹ jmɨɨ²¹. La coon²¹ naa'¹³ mo 'iin²¹²na 'úu³uu 'in xee'²¹mo tsa'í² jéei¹gɨ lagɨ jna. ");
INSERT INTO chqNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Joon gajin'² Jesús sɨɨ'²¹ɨ 'in tsatsaa'¹³ do: ―Ráan²un no, joon saa'¹³ tyi¹ raan¹un, joon ngɨ² no. ");
INSERT INTO chqNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Joon tsifu joon ga'láa²mo 'in tsañʉʉ'¹ do. Joon gasaa'¹³ tyi¹ tya'a joon ga'láa² 'wii²¹² gangɨ¹ɨ. Pe 'e jmɨɨ²¹² joon jmɨɨ²¹² 'e 'ii'²¹ 'woo'²¹ tsá², ");
INSERT INTO chqNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","joon gajin'² 'in tsá² seein²¹ Israel 'in taan²¹²in do sɨɨ'²¹ɨ 'in tsá² ga'láa²i do: ―Jmɨɨ²¹² 'e 'ii'²¹ 'woo'²¹ tsá² no. Jo cwoo²¹i ngɨ²'ɨ, tyan²'an tyi¹ tyi'i. ");
INSERT INTO chqNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Joon gañii¹i 'in tsañʉʉ'¹ do: ―'In gaun'láa²i jna joon gajin'²in sɨɨ'²¹ɨ jna: “Saa'¹³ tyi¹ raan¹un tsíin²un joon ngɨ² no.” ");
INSERT INTO chqNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Joon gaunngɨɨ¹ɨ 'ido jin'²in: ―¿'Iin gasɨɨ'²¹ɨ 'nʉ la joon 'e saa'¹³'a tyi² tyi'i joongɨ ngɨ² no? ");
INSERT INTO chqNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Pe 'in tsañʉʉ'¹ do jo ñii¹i 'iin 'in gaun'láa²i 'ii do tsʉ 'áa¹mo fúui¹ tsá² 'in taa²i do, joon Jesús ni'ngaa'¹³mo. ");
INSERT INTO chqNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Mo ngɨ́ɨ²i joon gajii²in Jesús 'in tsañʉʉ'¹ do co' cwo'¹ fee'¹ do. Joon gajin'² Jesús sɨɨ'²¹ɨ 'ido: ―Ni'láa²mo'o no, jo 'laa²¹²gɨ'ɨ sɨ no‑o gacɨ'² jo¹gɨ 'e mo lɨ́ɨ¹u'u do. ");
INSERT INTO chqNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Joon ganga'²mo 'in tsañʉʉ'¹ do ganijmaa'¹³a 'in tsá² seein²¹ Israel júu³ 'e Jesús do‑o 'in nigaun'láa²i 'ii. ");
INSERT INTO chqNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Joon tsʉ 'wii'¹³ gaun'láa²i Jesús 'in tsá² do jmɨɨ²¹² 'e 'ii'²¹ 'woo'²¹ tsá² 'e joon 'áai¹ gauntyíi²in 'in tsá² seein²¹ Israel do Jesús, 'iin²¹²in jnga'²mo 'ido. ");
INSERT INTO chqNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Pe Jesús‑gɨ gasɨɨ'²¹ɨ 'ido: ―Ñʉ'³ʉʉ gajmaa¹a to² ca jmɨɨ²¹² no la joon jna jon jmóo³oo to². ");
INSERT INTO chqNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","'Wii'¹³ joon 'in tsá² seein²¹ Israel do 'áai¹gɨ gali'iin²¹²in jngaa'¹³i 'ido. 'Iin²¹²in jngaa'¹³i 'ido tsʉ jo gauntiin'¹³in 'e ley tya' jmɨɨ²¹² 'ii'²¹ 'woo'²¹ tsá², joon mo gajin'²in 'e Dios jmii²¹i joon gajmee¹i 'ña'a coon²¹ røø²¹mo coon'¹³ Dios Jmii²¹. ");
INSERT INTO chqNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Joon gajin'² Jesús: ―'E júu³ ja'²mo fuu²¹²uu 'naa', jo lí² jmaa¹a 'in Jóon¹ Dios jiin'¹³ coon²¹ wa'a 'ña'a. Jmoo¹‑o jiin'¹³ 'e nii²¹i jmoo¹o Jmii²¹ do. Jilaa'²¹ 'e jmoo¹o Jmii²¹ do jmoo¹‑o jon 'in Jóon¹on do. ");
INSERT INTO chqNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Joon Dios Jmii²¹ 'iin²¹²mo 'áai¹ Jóon¹on joongɨ 'e'²o jilaa'²¹ 'e jmoo¹o, joon nogɨ i'ee²¹gɨ 'e fee'¹gɨ 'áai¹ 'e itsa'goo²¹‑'oo'. ");
INSERT INTO chqNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","La jmoo¹o Dios Jmii²¹ 'e jiin'¹ 'lɨɨ²¹² joon cwo'¹o juncwii²¹ tya'a, la joon jon 'in Jóon¹on cwoo¹o juncwii²¹ tya' jiin'¹³ 'in 'iin²¹²in cwo'¹o. ");
INSERT INTO chqNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Joon 'in Jmii²¹ do jo jmoo¹o 'ii'²¹ tya' jiin'¹³ jaain²¹ pe jiin'¹³ Jóon¹on do nicwo'¹o 'ii'²¹ 'e lí² jmáa¹a 'ii'²¹ tya' jileei'²¹. ");
INSERT INTO chqNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","'E coon'¹³ la joon ilitsáai¹‑tsi tsá² la tsáai¹‑tsi tsá² Dios Jmii²¹. Wana jo tsáai¹‑tsi tsá² Jóon¹on Dios Jmii²¹ joon la joon jon jo tsáai¹‑tsi tsá² Dios Jmii²¹ tsʉ Dios Jmii²¹ gasii¹in Jóon¹on do. ");
INSERT INTO chqNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Tsʉ júu³ ja'²mo 'e fuu²¹²uu 'naa': Jileei'²¹ 'in cón² cwáain¹ 'e fo'³oo lo joongɨ ja'²mo lɨ́ɨ²i 'in gasii¹in jna taa'²¹ juncwii²¹ tya'a coon²¹ tøø²mo. Joon jo jmá¹a Dios 'ii'²¹ tya'a 'e tsáa¹a lɨ 'lɨɨ'³ tsʉ jo júuin²gɨ, jiin'¹o coon²¹ tøø²mo. ");
INSERT INTO chqNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Tsʉ júu³ ja'²mo 'e fuu²¹²uu 'naa', nogɨ ijó¹‑o 'ii'²¹ joon jmɨɨ²¹² no‑o do, inú¹un 'lɨɨ²¹² júu³ tya' Jóon¹on Dios joon jileei'²¹ 'in ganúu²un seen²¹mo coon²¹ tøø²mo. ");
INSERT INTO chqNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Tsʉ Dios Jmii²¹ cwo'¹o 'ña'a juncwii²¹ tya'a 'ña'a la joon jon Dios Jmii²¹ gacwo'¹o Jóon¹on 'ii'²¹ 'e lisá² juncwii²¹ tya'a 'ña'a. ");
INSERT INTO chqNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Joon Dios Jmii²¹ gacwo'¹o Jóon¹on to² ijmáa¹a 'ido 'ii'²¹ tya' tsá² tsʉ Ruu'²¹mo Tsá² 'ii. ");
INSERT INTO chqNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Jo cwotya'goo²¹‑'oo' coon'¹³ jilaa'²¹ 'elo ―jin'²in Jesús― tsʉ icwá² 'ii'²¹ mi nú¹un jileei'²¹ 'lɨɨ²¹² júu³ tya'a ");
INSERT INTO chqNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","joon i'woo²¹i tsi 'aan¹ tya'a. Jileei'²¹ 'in nigajmaa¹a 'e tyʉ́² ijiin'¹o joon iseen²¹mo coon²¹ tøø²mo; pe jileei'²¹ 'in gajmaa¹a 'e gó² ijiin'¹o 'e ilisá² 'ii'²¹ tya'a joon tsaliin² fu lɨ 'lɨɨ'³. ");
INSERT INTO chqNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Jna, jo li'¹ii jmáa³aa cwáain¹ tyiia 'ñii'a jiin'¹³xʉ ―jin'²in Jesús―. Jmáa³aa 'ii'²¹ jiin'¹³ la to² nʉʉ'¹³oo, joon røø²¹ 'ii'²¹ jmáa³aa. La joon jo jmáa³aa jiin'¹³ la 'iin²¹²na 'ñii'a 'ná¹‑a jmáa³aa jiin'¹³ la 'iin²¹²in Ñʉ'³ʉʉ, 'in gasii²¹in jna. ");
INSERT INTO chqNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Jo lí² fo'³oo 'wii²¹² tyiia 'ñii'a tsʉ jo tyiin². ");
INSERT INTO chqNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Seen²¹mo jaain²¹gɨ tsá² xeei'²¹ 'in faa'²¹a 'wii²¹² tyiia joon ñí³oo 'e jin'² 'ido 'e tyíin¹³mo joon. ");
INSERT INTO chqNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Joon 'naa' gasii²¹naa' 'in ganiunngɨɨ¹ɨ Wó³ do cwáain¹ tyiia joon 'e júu³ gafaa'²¹a 'ido 'e ja'²mo joon. ");
INSERT INTO chqNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Jo 'ná¹ 'ii'¹³na júu³ 'e faa'²¹a jaain²¹ tsá² cwáain¹ tyiia. Jiin'¹³ fo'³oo la joon 'e ilí² tiin'¹³naa' 'wii'¹³ 'e júu³ tya¹a Wó³ cwáain¹ tyiia. ");
INSERT INTO chqNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Wó³ do lɨ́ɨ¹i lawa coon²¹ jɨ́² 'e coo²¹ joongɨ jná² joo'²¹. Joon 'naa'gɨɨ' galijløø'³moo' coon²¹ sii'¹³xʉ coon'¹³ 'e jɨ́² do. ");
INSERT INTO chqNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Pe jilaa'²¹ 'e jmóo³oo 'e tyʉ́²gɨ 'e joon lagɨ 'e júu³ tya¹a Wó³. Joon jilaa'²¹ 'e jmóo³oo 'e joon gajin'²in Ñʉ'¹ʉ' 'e jmáa³aa. Jilaa'²¹ 'elo 'e ja'²mo 'e gasii¹in Ñʉ'¹ʉ' jna. ");
INSERT INTO chqNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","La joon jon 'in Ñʉ'¹ʉ' 'in gasii¹in jna faa'²¹o 'wii²¹² tyiia xʉfiin'¹³ jo mo ganʉʉ²ʉʉn' júu³ tya'a, jon'gɨ mo gañíi² 'naa'. ");
INSERT INTO chqNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Joon 'e júu³ tya'a jo mo ga'í² tsi alma tyii' tsʉ jo jo'¹ lɨ́ɨ²naa' Ñʉ'¹ʉ' do 'in gasii¹in jna. ");
INSERT INTO chqNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","'E la joon 'naa' untsáa¹³oo' 'e Jí² tya' Dios coon'²¹ ce tún² 'áai¹ tsʉ 'ɨ¹‑'oo' jee²¹² joon ityii²aa' juncwii²¹ tyii' itaa'²¹ coon²¹ tøø²mo pe la jee²¹² joon gatɨ́² unní²ii' lɨ faa'²¹a cwáain¹ tyiia. ");
INSERT INTO chqNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Joon 'naa' jo 'iin²¹²naa' 'wa' iliin²naa' jna i'ii'¹³naa' 'e juncwii²¹ do. ");
INSERT INTO chqNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Jna røø²¹ náa¹ tyiia wana tsáai¹‑tsi tsá² jna owa jo tsáai¹‑tsi tsá² jna 'ee. ");
INSERT INTO chqNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Pe jna, cwii¹moo 'naa', joon ñí³oo 'e jo 'iin²¹²naa' Dios Jmii²¹. ");
INSERT INTO chqNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Jna nigoo²¹²oo cwáain¹ tya' Ñʉ'³ʉʉ pe 'naa' jo ga'ii'¹³naa' jna. Pe wa'a cwée¹i jaain²¹ 'in xeei'²¹ 'in jó¹o cwáain¹ tya'a 'ña'a joon 'ii'¹³moo' 'i. ");
INSERT INTO chqNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Xiiala jo'¹ iliin¹ 'naa' jiin'¹³ la 'e tsáai¹‑'oo' yaanaa' la jaain²¹ la jaan²¹naa'? Joon jo cón² 'naa' cwáain¹ wa'a jløø'³mo Dios cwáain¹ tyi'naa'. ");
INSERT INTO chqNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Jo jmáa³aa tsaa² tyii' tyani Ñʉ'³ʉʉ. Moisés, 'in jo cu'²‑'oo' coon'¹³, 'ii 'in cwo'¹ 'naa' tsaa². ");
INSERT INTO chqNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Wana jai'² lɨ́ɨ²naa' 'e gajin'² Moisés, la joon jon jo'¹o ilíin²naa'²¹ jna tsʉ jí² gajmaa¹a Moisés do faa'²¹ a cwáain¹ tyiajna. ");
INSERT INTO chqNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Pe wa jo jo'¹ lɨ́ɨ²naa' 'e jí² gajmaa¹a Moisés, ¿xiiagɨ la jo'¹ ilíin²naa' júu³ 'e fuu²¹²uu 'naa'? ");
INSERT INTO chqNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Mo gangɨɨ¹i 'elo gangóo¹o Jesús fu lɨ 'ngoo'¹³ tyíia¹ sii²¹ Galilea, sii²¹ jon Tiberias. ");
INSERT INTO chqNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Joon 'áai¹ fúui¹ tsá² ngalíin²in cɨɨin²¹gɨ tsʉ goon'¹³ niní² jilaa'²¹ milagro joongɨ niun'láa²i tsá² 'in tsaa'¹³. ");
INSERT INTO chqNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Joon nigasóo²o Jesús coon²¹ moo'²¹ joon do‑o gacwó² coon'¹³ tsá² 'in ngɨ¹ coon'¹³on. ");
INSERT INTO chqNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Joon tɨ lɨ tɨ́² jmɨɨ²¹² pascua tya' tsá² Israel. ");
INSERT INTO chqNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Joon mo gajǿø² Jesús joon ganí² tsá² fúui¹ 'in jalíin² caluu joon gasɨɨ'²¹ɨ Lii²¹²: ―¿Xiia 'e tsalaa²¹²a' 'e dø'¹ 'in tsá² fúui¹ no? ");
INSERT INTO chqNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jesús gasɨɨ'²¹ɨ Lii²¹² do la joon tsʉ 'iin²¹²in litsáai¹‑tsi 'ee ijin'² Lii²¹², tsʉ 'ña'a Jesús niñii¹o xiiala ijmáa¹a. ");
INSERT INTO chqNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Joon gajin'² Lii²¹²: ―Jo leen²¹in cuu² jiin'¹³ 'e 'lee'¹³i tsá² tya' jɨ́² jñéi¹ sɨɨ'²¹ wa 'e lɨ 'laa²¹²a' 'iñi'¹ dø'¹ 'in tsá² no fiin'¹³ jmai'²xʉ‑ʉ 'e tɨi²xʉ la jaain²¹ tsá². ");
INSERT INTO chqNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Joon jaain³¹ 'in ngɨ¹ coon'¹³on do, 'in sii²¹i Dɨ́ɨ³, ruu'²¹i Simón Pedro, gajin'²in: ");
INSERT INTO chqNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Lo‑o siin'¹³ jaain²¹ xuui²¹² 'in san'² 'ñá² 'iñi'¹ joon gái¹gɨ joo'²¹ taai² jmɨɨ²¹. Pe jo lɨ tsanʉ́ʉ²ʉn 'elo tya' 'in tsá² fúui¹ lo. ");
INSERT INTO chqNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Joon gajin'² Jesús sɨɨ'²¹ɨ 'in tsá² ngɨɨ¹ɨ coon'¹³: ―Síi¹³ii' 'in tsá² no cwocwaa²¹a. Joon 'áai¹ sá² ñii²¹ do joon gacwó²o 'in 'ñá² mil tsá². ");
INSERT INTO chqNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Joon ga'ii'²¹i Jesús 'e 'iñi'¹ do. Gacwo'¹o 'maai'¹³ Dios joon mo ngayuui'¹² joon gacwo'¹o 'in coon'¹³on do. Joon 'in tsá² do gajmaa¹a jmai'²xʉ cwo'¹o 'in tsá² fúui¹ 'in née¹i do. Joon la joon jon gajmaa¹a jmai'²xʉ 'in joo'²¹ taa²i jmɨɨ²¹ do. Cwo'¹o jiin'¹³ la 'iin²¹²in do. ");
INSERT INTO chqNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Joon mo garǿ¹i tu'² 'ido joon gajin'²in Jesús sɨɨ'²¹ɨ 'in ngɨɨ¹ɨ coon'¹³on: ―Ngɨ́ɨ¹³ɨɨ' jee²¹² tsá² no, tyiin²aan' jilaa'²¹ 'e gasá¹i joon jo tsa'ɨ́ɨ¹ jiin'¹³xʉ. ");
INSERT INTO chqNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Joon gacoon²¹o, joon 'e 'no'² 'e gasá¹i tya' 'e 'ñá² 'iñi'¹ do garǿ¹mo dyatún² mɨɨ'tó³. ");
INSERT INTO chqNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Joon mo ganí² 'in tsá² do 'e milagro do 'e gajmaa¹a Jesús, joon gajin'²in: ―'In tsañʉʉ'¹ no 'e la ja'²mo 'in 'ná¹ ijó¹o ni cwoo'¹³ juncwii²¹ cwo¹o júu³ tyʉ́² tya' Dios. ");
INSERT INTO chqNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Pe joon galili'³i Jesús 'e 'iin²¹²in 'in tsá² do 'e tøø¹ø 'ido tyitsaa²¹mo wa iliin¹in 'ido rǿøi¹³ tya'o, joon gajeen'²¹mo Jesús 'ña'o tún¹ jee²¹² moo'²¹. ");
INSERT INTO chqNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Joon mo canʉʉ²¹ 'in tsá² 'in ngɨ¹ coon'¹³ Jesús gajgá¹mo fu lɨ náa¹ tyíia¹ do. ");
INSERT INTO chqNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Joon gangatáa¹i tsi coon²¹ barco joon gata'²mo fu¹ itáan¹in lɨ 'ngoo'¹³ tyíia¹ do lɨ sii²¹ Capernaum. Joon 'aa²¹ mo niniuu²¹mogɨ joon jo mo tyee'¹³mogɨ Jesús. ");
INSERT INTO chqNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Joon garóon²on coon²¹ tyí² tá² 'áai¹ joon gajnáa¹a jmɨɨ²¹ tsaa' barco. ");
INSERT INTO chqNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Joon mo ningó¹o jiin'¹³ 'ñá² sɨ jnʉ́ʉ² kilómetro ni jmɨɨ²¹ joon ganíi²mo Jesús 'e nijó¹‑o jatyéen¹in tyan' lɨ ngó¹on barco. Joon gafoo'¹³mo. ");
INSERT INTO chqNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Pe Jesús gajin'²in sɨɨ'²¹ɨ 'ido: ―Jna‑a lo. Jo jmoo¹oo' 'goo'²¹oo'. ");
INSERT INTO chqNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Joon jløø'³mo 'in tsá² do ga'ii'²¹mo Jesús tsi barco do. Joon la 'ɨɨ²¹² do‑o tyalíin²mo 'wó² tyʉʉn²¹ lɨ 'ná² lɨ nitsalíin² do. ");
INSERT INTO chqNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Mo gajná² joon 'in tsá² gajan¹an lɨ' la 'ngoo'¹³ tyíia¹ do galili'²i 'e 'in tsá² ngɨ¹ɨ coon'¹³on do‑o gacón² 'e barco do tsʉ jiin'¹³ do‑o 'e barco 'e sá². Joon gañii¹i 'e jo gangó¹on Jesús coon'¹³ 'ido. ");
INSERT INTO chqNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","La 'ɨɨ²¹² joon gatyalí² barcos xiia'²¹ taa²i tsá² 'in jalíin² coon²¹ fuu²¹ sii²¹ Tiberias tyan'an lɨ gacwo'¹ Jesús 'maai'¹³ Dios cwáain¹ tya' 'iñi'¹ gagøø'²¹ø 'in tsá² do. ");
INSERT INTO chqNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Joon mo galili'³ 'in tsá² do 'e jo taan¹in Jesús jon'gɨ tsá² tya'a taan²¹²in joon gangataa²mo tsi barco do joon gangalíin²mo jon fuu²¹ lɨ sii²¹ Capernaum ganga'nee'¹³i Jesús. ");
INSERT INTO chqNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Joon mo gatyalíin² lɨ 'ngoo'¹³ tyíia¹ do joon gatsee'²¹i Jesús joon gaunngɨɨ¹ɨ: ―Tɨfo'² tyii'i, ¿lɨɨgɨ gacwe²o'o lo? ");
INSERT INTO chqNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Pe Jesús‑gɨ gajin'²in: ―'E ja'²mo fuu²¹²uu 'naa', 'naa'²¹naa' jna tsʉ gatyee'²¹oo' ce rǿ¹i tuu¹uu' jon'gɨ wa 'wii'¹³ 'øøi'²¹‑'oo' 'e li² milagro gajmáa³aa do. ");
INSERT INTO chqNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Jo jmaa²aa' to² wa 'ná¹ 'e jnaa¹aa' 'e cøø²øø' 'e tyá² jmoono pe jmaa²aa' to² tya' 'e jnaa¹aa' juncwii²¹ tyii' 'e taa'²¹ coon²¹ tøø²mo. Joon jna‑a, Ruu'²¹na Tsá² cwó³oo 'e juncwii²¹ do tsʉ coon'¹³ 'e li² milagro 'e jmóo³oo do jmaa¹a Dios Jmii²¹ júu³ 'e jmoo³oo to² 'e tyʉ'²ʉ. ");
INSERT INTO chqNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Joon gaunngɨɨ¹ɨ 'in tsá² do: ―Wa'a jmó²o'o to² tya' Dios, ¿'eegɨ 'ná² jmaa²¹a'a? ");
INSERT INTO chqNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Joon gañii¹i Jesús: ―'E 'ná¹ jmaa²aa' to² tya' Dios 'e jo'¹o liin¹naa 'in gasii¹in Dios Jmii²¹. ");
INSERT INTO chqNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","'I‑gɨ gaunngɨɨ¹ɨ: ―¿'Ee li² cwee¹i 'e jmaa²'a jøø²¹ø'ø tsʉ joon jo'¹ lii¹na'a 'nʉ? ¿'Ee 'e jmaa²'a? ");
INSERT INTO chqNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","'Lɨɨ²¹² tsacøøi'¹³ tyi' 'in ningɨɨ² gagøø'²¹ø 'e sii²¹ maná coon²¹ cwoo'¹³ lɨ tyʉʉn²¹. Jiin'¹³ la jin'² ni jí² tya' Dios: “Dios gacwo'¹o 'in tsá² do 'iñi'¹ jó¹o fu ñʉ'fú².” ");
INSERT INTO chqNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Joon gañii¹i Jesús: ―'E la ja'²mo fuu²¹²uu 'naa': Jon' Moisés 'in gacwo'¹ 'naa' 'e 'iñi'¹ jó¹o fu ñʉ'fú², pe Ñʉ'³oo 'in gacwo'¹ 'naa' 'e 'iñi'¹ la jai'² 'e jó¹o fu ñʉ'fú². ");
INSERT INTO chqNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Tsʉ 'e 'iñi'¹ 'e cwo¹ Dios Jmii²¹ 'e gajgó¹ fu ñʉ'fú² joon, 'e 'iñui'¹ do‑o 'e cwo¹ fu juncwii²¹ tya' tsá². ");
INSERT INTO chqNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Joon 'in tsá² do gajin'²in sɨɨ'²¹ɨ Jesús: ―Tsañʉʉ'¹, cwoo'¹³ jna'a coon²¹ tøø²mo 'e 'iñi'¹ no. ");
INSERT INTO chqNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Joon Jesús‑gɨ gajin'²in: ―Jna‑a 'e 'iñi'¹ no 'e cwo¹ juncwii²¹ tya' tsá². Joon jileei'²¹ 'in uncaan²¹in coon'¹³ jna jo jmɨɨ²¹² 'yá² un'áa¹i joongɨ 'in jo'¹ lɨ́ɨ²i jna jo jmɨɨ²¹² 'yá² unjmúu¹i. ");
INSERT INTO chqNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Pe jiin'¹³ la 'e nifuu²¹²uu 'naa', jo jo'¹ lɨ́ɨ²naa' jna xʉfiin'¹³ wa niñii¹ii'. ");
INSERT INTO chqNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Jileei'²¹ 'in gacweei'¹² 'Ñʉ'³ʉʉ jna inuncaan²¹in coon'¹³ jna joon jileei'²¹ in uncaan²¹in coon'¹³ jna jo 'woo²na fu caluu. ");
INSERT INTO chqNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Tsʉ jo gó²oo ni cwoo'¹³ juncwii²¹ wa'a 'e tyʉ'³ʉʉ to² 'ñii'a, gagó³oo ni cwoo'¹³ juncwii²¹ 'e jmáa³aa jilaa'²¹ 'e 'iin²¹²in 'in gasii¹in jna. ");
INSERT INTO chqNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Joon 'e 'iin²¹²in Ñʉ'³ʉʉ 'in gasii¹in jna 'e jo tsa'ɨ́ɨ¹i jiin'¹³ jaain²¹ 'in nigacwoo'¹³i jna. Iin²¹²in 'e jmáa³aa jiin'¹in 'in tsá² do mi tɨ jmɨɨ²¹² lɨ gatséi¹. ");
INSERT INTO chqNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Jiin'¹³ 'e 'iin²¹²in 'in gasii¹in jna 'e jileei'²¹ 'in jǿø²i jna, Jóon¹on Dios jna, joongɨ jo'¹o lɨ́ɨ²i jna, itaa'²¹a juncwii²¹ tya'a coon²¹ tøø²mo. Joongɨ jna‑a jmáa³aa ijiin'¹o mi tɨ jmɨɨ²¹² lɨ gatséi¹. ");
INSERT INTO chqNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Joon coon'¹³ 'e júu³ tya' Jesús lo ga'láa² 'in tsá² Israel do 'wii'²¹² gasɨ́ɨ²i cwáain¹ tya' Jesús 'e 'wii²¹² gajin'²in: “Jna‑a 'e 'iñi'¹ 'e gajó² ñʉ'fú².” ");
INSERT INTO chqNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Joon gajin'²in 'in tsá² do: ―Ino‑o Jesús jóon¹on José. Cwii¹mo' jmii²¹i joongɨ cwii¹mo' sáa³a. ¿Xiiala lɨ 'e jin'²in 'e gajgáa¹i ñʉ'fú²? ");
INSERT INTO chqNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Joon Jesús gasɨɨ'²¹ɨ 'ido: ―Jo sɨ́ɨ¹³naa' jee²¹² yaanaa' cwáain¹ tyiajna. ");
INSERT INTO chqNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Jiin'¹³ jaain²¹ jo 'iin uncaan²¹in coon'¹³ jna wa jo 'iin cwoo'¹³i Ñʉ'¹ʉ' jna. Joon jna‑a jmáa³aa ijiin'¹in mi tɨ jmɨɨ²¹² lɨ gatséi¹. ");
INSERT INTO chqNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Jee²¹² jí² tya'a 'e gajmaa¹a 'in tsá² cwo¹o júu³ tyʉ́² tya' Dios calɨɨ 'e 'e jin'¹: “Dios i'e'²e jileei'²¹ tsá².” La joon jileei'²¹ 'in nuu¹u júu³ tya' Ñʉ'¹ʉ' joon galicwii¹mo, joon 'ii 'in tsá² in uncaan²¹in coon'¹³ jna². ");
INSERT INTO chqNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Jiin'¹³ jaain²¹ tsá² 'in taan²¹²in ni cwoo'¹³ juncwii²¹ jo mo ganii¹in Dios Jmii²¹. Pe seein²¹ jaan²¹mo 'in gajó² fu ñʉ'fú² jiin'¹³ 'ii niganii¹in Dios Jmii²¹. ");
INSERT INTO chqNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","'E la ja'²mo fuu²¹²uu 'naa'; 'in jai'² lɨ́ɨ²i jna 'oo¹o juncwii²¹ tya'a 'e taa'²¹ coon²¹ tøø²mo. ");
INSERT INTO chqNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Jna‑a 'e 'iñi'¹ 'e cwo¹o fu juncwii²¹ tya' tsá² 'e taa'²¹ coon²¹ tøø²mo. ");
INSERT INTO chqNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","'In 'lɨɨ²¹² tsacøøi'¹³ tyii' 'ii 'in gagøø'²¹ø 'e sii²¹ maná fu cwoo'¹³ tyʉʉn²¹ do joon jo gasɨ'neei'¹³ gajún¹mo. ");
INSERT INTO chqNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Pe jna fo'³oo cwáain¹ tya' 'e 'iñi'¹ 'e gajó² fu ñʉ'fú², joon jileei'²¹ 'in gagøø'²¹ø 'e 'iñi'¹ do jo júun²in. ");
INSERT INTO chqNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Joon jna‑a 'e 'iñi'¹ do 'e cwo¹o juncwii²¹ tya' tsá² 'e gajó² fu ñʉ'fú². Joon jileei'²¹ 'in gø'²ø 'e 'iñi'¹ lo taa'²¹a juncwii²¹ tya'a coon²¹ tøø²mo. Joon 'e 'iñi'¹ icwóo³oo lo, 'ñii'a lo. Icwóo³oo 'wii²¹² tya' jileei'²¹ 'in taan²¹²in ni cwoo'¹³ fu juncwii²¹ 'e lí² sá² juncwii²¹ tya'a ―jin'² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Joon ga'láa² 'in tsá² Israel 'wii²¹² jo cwo'¹o júu³ ruu'²¹i, jin'²in: ―¿Xiiala icwo¹i 'ña'a ityee'³ jna' 'ii? ");
INSERT INTO chqNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Joon gajin'²in Jesús: ―'E la ja'²mo fuu²¹²uu 'naa', wa'a jo cǿø¹³øø' 'naa' 'iñi'¹ ngú¹ Ruu'²¹i Tsá², joongɨ wa'a jo 'úu¹³uu' jmɨ¹ 'øø²i jo sá² juncwii²¹ tyii'. ");
INSERT INTO chqNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Pe jileei'²¹ 'in gø'² 'iñi'¹ ngúu³uu joongɨ 'in 'uun'²¹un jmɨ¹ 'øø²na taa'²¹ juncwii²¹ tya'a coon²¹ tøø²mo. Joon jna‑a jmáa³aa ijiin'¹in mi tɨ jmɨɨ²¹² lɨ gatséi¹. ");
INSERT INTO chqNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Tsʉ ngú¹ taan²na joongɨ coon'¹³ jmɨ¹ 'øø²na 'e la ja'²mo cwo¹o 'waa'²¹ pí² tya' tsá². ");
INSERT INTO chqNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Joon jileei'²¹ 'in gø'² ngú¹ taan²na joongɨ 'uun'²¹un jmɨ¹ 'øø²na incaan²¹in coon'¹³ jna, joongɨ jna coon'¹³ 'ii. ");
INSERT INTO chqNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Joon Ñʉ'¹ʉ', 'in gasii²¹in jna sá²‑a juncwii²¹ tya'a, joon 'ii‑o cwo'¹o jna juncwii²¹ tyiia. La joon jon jna jileei'²¹ 'in 'ii'²¹ 'waa'²¹ pí² tyiia cwo'²oo juncwii²¹ tya'a joon. ");
INSERT INTO chqNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Fo'³oo cwáain¹ tya' 'e 'iñi'¹ 'e gajó² fu ñʉ'fú². Joon 'e 'iñi'¹ no jo lɨ la lɨ 'e sii²¹ maná 'e gagøø'²¹ 'lɨɨ²¹² tsacøøi'¹³ tyii' 'in ningɨ́ɨ²i, gagøø'²¹o 'e maná do pe jo gasɨ'neei'¹² jún¹mo. Pe 'in gø'² 'e 'iñi'¹ 'e fuu²¹²uu 'naa' lo itaa'²¹ fu juncwii²¹ tya'a coon²¹ tøø²mo 'i ―jin'² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesús ga'ee¹e 'e júu³ lo 'e la caan²¹in tsá² inʉʉ cwo'¹ sinagoga 'e si'² coon²¹ fuu²¹ lɨ sii²¹ Capernaum. ");
INSERT INTO chqNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Joon mo ganúu²un tsá² 'e júu³ lo joon fúu¹mo 'áai¹ 'in ngɨ¹ coon'¹³ Jesús jin'²in: ―'Wúu¹mo 'áai¹ i'ii'²¹ tsá² 'e júu³ lo. ¿'Iin in unjíi² 'e júu³ lo? ");
INSERT INTO chqNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Joon galili'³ Jesús 'e júu³ sɨ́ɨ¹i 'in tsá² do joon gaunngɨɨ¹ɨ sɨɨ'²¹ɨ 'ido: ―¿Tɨ jo tɨ́²‑'oo' 'e júu³ tyiia lo? ");
INSERT INTO chqNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿'Ee i'ɨ¹‑'oo' wa'a ñii¹ii' 'in Ruu'²¹i Tsá² sóo²o fu ñʉ'fú² lɨ mo tyíin¹in la jéei¹? ");
INSERT INTO chqNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","'E cuerpo tya' tsá² jo to² 'íi³in 'e joon, jiin'¹³ espíritu tya' tsá² 'e taa'²¹ juncwii²¹ tya' coon²¹ tøø²mo. Joon 'in Espíritu Tyʉ́² tya' Dios cwo'¹o juncwii²¹ tya' espíritu tya' tsá². Joon 'e júu³ fuu²¹²uu 'naa' lo cwáain¹ tya' 'e espíritu do. Joon coon'¹³ 'e júu³ fo'³oo lo lí²‑i cwo¹o juncwii²¹ tya' tsá² 'e taa'²¹ coon²¹ tøø²mo. ");
INSERT INTO chqNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pe seen²¹mo jee²¹² 'naa' 'in jo jo'¹ lɨ́ɨ²i ―jin'² Jesús. Tsʉ ñii¹i Jesús ca la mo 'wiin²¹² 'iin 'in jo jo'¹ lɨ́ɨ²i 'ii joongɨ ñii¹o 'iin 'in 'nɨɨ¹i 'ii. ");
INSERT INTO chqNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Joon gajin'²in sɨɨ'²¹ɨ 'in tsá² do: ―'Wii'¹³ joon nifuu²¹²uu 'naa' 'e jiin'¹³ jaain²¹ jo lii'¹ uncaa²¹in coon'¹³ jna wa'a jo 'in mo cwóo¹i Ñʉ'¹ʉ' jna. ");
INSERT INTO chqNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Mo ngɨ́ɨ²i gajin'² Jesús 'e júu³ lo, fúu¹mo 'in tsá² 'in la mo ta ngɨ¹ɨ coon'¹³on gatíuu²mo 'ii, joon jo ngɨ¹gɨ 'ido coon'¹³on. ");
INSERT INTO chqNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Joon gaunngɨɨ¹ɨ Jesús sɨɨ'²¹ɨ la jɨ dyatuuin¹ tsá² tya'a do: ―¿Tɨ 'iin²¹²naa' cwoliin¹naa' jon? ");
INSERT INTO chqNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Pe joon gajin'² Simón Pedro: ―Ña'ñʉ'¹ʉ', ¿'iin coon'¹³ tsaa²¹a'a? Jiin'¹³ júu³ tyi'i no 'e cwo¹ juncwii²¹ tya' tsá² 'e taa'²¹ coon²¹ tøø²mo. ");
INSERT INTO chqNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Joon jna'a jo'¹o nilɨ́³na'a 'nʉ joon ne²oo'o 'e 'nʉ‑ʉ Cristo, Jóon¹on Dios Jmii²¹ 'in seein²¹ coon²¹ tøø²mo. ");
INSERT INTO chqNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Joon Jesús gajin'²in: ―Xʉfiin'¹³ 'ñiia'oo nigatyi'²moo 'naa' jɨ dyatuuin¹ 'naa' pe jaain²¹ 'naa' lɨ́ɨ¹i 'in 'lɨɨ'³mo. ");
INSERT INTO chqNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Faa'²¹a Jesús cwáain¹ tya' 'in sii²¹ Judas Iscariote, jóon¹on Simón, tsʉ 'ii in'nɨ́¹i Jesús cɨɨin²¹gɨ. Ijmáa¹a la joon xʉfiin'¹³ lɨ́ɨ¹i tsá² tya' Jesús jee²¹² 'in dyatuuin¹ do. ");
INSERT INTO chqNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Mo ngayuui'¹³ gajin'² Jesús 'e júu³ lo joon gangɨɨ¹ɨ la caain²¹ Galilea. Jo 'iin²¹²in ján² coon²¹ lɨ sii²¹ Judea tsʉ 'in tyʉ'² to² tsá² Israel 'iin²¹²in jnga'²mo 'ido. ");
INSERT INTO chqNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Joon tsʉ 'wii'¹³ tɨ lɨ tɨ jmɨɨ²¹² tya' tsá² Israel 'e sii²¹ 'e jmɨɨ²¹² jon¹ tsá² tsi 'nʉ́¹ nuu²¹, ");
INSERT INTO chqNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","'in ruu'²¹i Jesús gajin'²in sɨɨ'²¹ɨ 'ido: ―Jo jon'³'on lo, cwoo'¹'i fu Judea 'e coon'¹³ la joon 'in ngɨ́¹ɨ coon'¹³ 'nʉ 'in taan²¹²in lijǿø²ø jilaa'²¹ 'e jmoo²'o. ");
INSERT INTO chqNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Joon wana 'iin²¹²un 'e li cwii¹in tsá² 'nʉ jo jmaa²'a milagro tyi'i lɨ 'uuin²¹. Jmaa²'a lɨ jǿø²ø jileei'²¹ tsá² wana ijmaa²'a milagro. ");
INSERT INTO chqNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Jin'² ruu'²¹i la joon tsʉ jo jo'¹ lɨ́ɨ²i ruu'²¹i 'ii. ");
INSERT INTO chqNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Joon gajin'² Jesús sɨɨ²¹ɨ 'ido: ―Jo mo tɨ 'ii'²¹ tyiia, pe tyi'naa' jmoo²¹ joon²¹ coon²¹ hora 'e tyʉ́²‑ʉ. ");
INSERT INTO chqNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","'In tsá² taan²¹²in juncwii²¹ jo 'ee'¹i 'naa' pe 'ee'¹mo jna tsʉ jna‑a jmóo³oo júu³ røø²¹ 'e jilaa'²¹ 'e jmoo¹o jmai'² 'e gó². ");
INSERT INTO chqNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Cwolíin²naa' fu lɨ tɨ jmɨɨ²¹² tsʉ jna jo ní³ii tsʉ jo mo gatséi¹ cwáain¹ tya' 'ii'²¹ tyiia. ");
INSERT INTO chqNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Joon mo ngayuui'¹³ gajin'²in 'elo, gajan¹o coon²¹ lɨ sii²¹ Galilea. ");
INSERT INTO chqNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Pe mo ngayuui'¹³ gangalíin²in ruu'²¹i Jesús, Jesús gangó¹o cɨɨn²¹mo fu lɨ tɨ jmɨɨ²¹² do. 'Uun²¹mo tyíi¹a, jo gangɨɨ¹ɨ jee²¹² tsá². ");
INSERT INTO chqNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Joon 'in tsá² Israel do 'áa¹mo 'naa'¹i 'ido 'ii jee²¹² lɨ tɨ jmɨɨ²¹². Jin'²in: ―¿Xiiafu tyee'¹i 'in tsañʉʉ'¹ no? ");
INSERT INTO chqNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Joon jee²¹² 'in tsá² taan²¹²in lɨ tɨ jmɨɨ²¹² do 'áa¹mo sɨ́ɨ¹i cwáain¹ tya' Jesús do. 'Inlɨ́ɨi¹³ jin'²in: “Jaain²¹ tsañʉʉ'¹ 'in tyú¹mo 'ino.” Pe 'inlɨ́ɨi¹³gɨ jin'²: “Jon'¹ 'in tyúi¹ no, tsʉ 'in coon'²¹on tsá² tóo² 'ino.” ");
INSERT INTO chqNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pe jiin'¹³ jaain²¹ jo faa'²¹a jná² nii²in 'wii²¹² tya' 'ido, tsʉ 'wii'¹³ gøø'²¹mo 'in tyʉ'² to² tsá² Israel do. ");
INSERT INTO chqNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Joon jmɨɨ²¹² do ningó¹o coon²¹ tsa'¹ mo ga'í² Jesús inʉʉ cwo'¹ fee'¹ si'² do, joon ga'láa² 'wii²¹² 'e'²e tsá² júu³ tyʉ́². ");
INSERT INTO chqNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Joon 'áai¹ ninga'goo²¹‑tsi 'in tsá² tyʉ'² to² Israel do joon gajin'²in: ―¿Xiiala lɨ 'e galitɨɨ²¹i 'in tsañʉʉ'¹ no jilaa'²¹ 'e jin'²in no, tsʉ jo mo gauntsáa¹a? ");
INSERT INTO chqNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Joon Jesús‑gɨ gañii¹i: ―Jilaa'²¹ 'e 'ée³ee lo jon' 'e tyiia lo tsʉ 'e tya' 'in gasii¹in jna. ");
INSERT INTO chqNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Joon wa 'iin²¹²in jaain²¹ tsá² jmáa¹a la to² tyʉ'² Dios Jmii²¹, joon iliñii¹i 'e 'ée³ee lo júu³ tya' Dios sɨ 'e fo'³oo la 'øøi'²¹‑tsii 'ñii'a 'ee. ");
INSERT INTO chqNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","'In faa'²¹a jilaa'²¹ 'e 'øøi'²¹‑tsi yaai 'e la joon wa' 'e un'goo²¹o tsá² 'ii‑o. Pe 'in faa'²¹a 'wii²¹² tya' 'inxeei'²¹ 'e un'goo²¹o tsá² 'in gasii¹in 'ii‑o infaa'²¹a 'e la ja'²mo jo júu³ tajuu²¹ lɨ́². ");
INSERT INTO chqNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’Moisés gacwo'¹ 'naa' 'e ley do, ¿ja jo'? Pe jiin'¹³ jaain²¹ 'naa' jo gauntiin'¹³naa' 'e ley do. ¿'Ee lɨ' 'iin²¹²naa' jngaa'¹³naa' jna? ");
INSERT INTO chqNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Joon 'in tsá² taan²¹²in do gañii¹i: ―'In 'lɨɨ'³mo 'yuui² alma tyi'i. ¿'Iin 'iin²¹²in jngai'² 'nʉ? ");
INSERT INTO chqNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Joon gajin'² Jesús: ―Gajmáa³aa coon²¹ milagro jmɨɨ²¹² 'e 'ii'²¹ 'woo'²¹ tsá² 'e joon ni'goo²¹‑'oo' jilee'²¹naa'. ");
INSERT INTO chqNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moisés do gacwo'¹o 'naa' 'e tɨɨ² 'e nisii'²¹ jee²¹² 'naa' 'e sii²¹ circuncisión (pe jon' 'ña'a Moisés gasi'²¹i tɨɨ², 'lɨɨ²¹² tsacøøi'¹³ tya'a 'in ningɨ́ɨ²mo gasii'²¹ 'e tɨɨ² do). Tsʉ 'wii'¹³ joon jmoo² 'naa' 'e tɨɨsi'² no mo jmɨɨ²¹² 'ii'²¹ 'woo'²¹ tsá². ");
INSERT INTO chqNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Joon 'naa' 'e untiin'¹³naa' 'e ley tya' Moisés jmoo²oo' li² xuui²¹² tsañʉʉ'¹ 'e sii²¹ circuncisión xʉfiin'¹³ jmɨɨ²¹² 'e 'ii'²¹ 'woo'²¹ tsá². Wa 'naa' jmoo²oo' la joon jmɨɨ²¹² 'ii'²¹ 'woo'²¹ tsá², ¿'e lɨ' jmoo²oo' 'nii'²¹‑'oo' tyiia 'wii'¹³ gaun'láa²na jaain²¹ tsañʉʉ'¹ jmoowúu¹ 'e tyaan¹an jmɨɨ²¹² 'ii'²¹ 'woo'²¹ tsá²? ");
INSERT INTO chqNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Jo cwojmaa²aa' 'ii'²¹ jiin'¹³ la 'øøi'²¹‑'oo' yaanaa'. Mo jmoo²oo' 'ii'²¹, cwojmaa²aa' coon²¹ tsáa¹. ");
INSERT INTO chqNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Joon 'inlɨ́ɨi¹³ 'in taan²¹²in Jerusalén do ga'láa² 'wii²¹² unngɨɨ¹ɨ, jin'²in: ―¿Tɨ jon' 'ino 'in 'naa'¹i 'ido 'e jngaa'¹³i? ");
INSERT INTO chqNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","No siin'¹³in faa'²¹a jee²¹² tsá² jná² nii²mo joon jiin'¹³ jaain²¹ jo 'in sɨɨ'²¹ 'ii. Xʉfoo'³ lɨ́ɨ²i tsaa'to² 'e 'ino‑o Cristo 'in gasii¹in Dios Jmii²¹. ");
INSERT INTO chqNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Pe jna' ne²o' xiiafu lɨ gajó² 'in tsañʉʉ'¹ no pe mi jó¹ Cristo jiin'¹³ jaain²¹ jo 'in ñi¹i xiiafu lɨ jó¹o, ―jin'² 'in tsá² do. ");
INSERT INTO chqNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Joon mo ganúu²un Jesús 'elo lɨ siin'¹³in 'e'²e tsá² júu³ tyʉ́² inʉʉ cwo'¹ fee'¹ do, joon gafaa'²¹a tá², jin'²in: ―¿Tɨ jo'¹ 'e cwii¹mo 'naa' jna? ¿Tɨ jo'¹ ñí²oo' xiia'fu lɨ gó³oo? Jo mo gó³oo 'wii²¹² tyiia 'ñii'a. Pe gó³oo to² tyʉ'² jaain²¹ 'in ja'²mo seein²¹, 'in jo cwii¹naa'. ");
INSERT INTO chqNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Pe jna, cwii¹moo tsʉ gó³oo fu lɨ tyíin¹in joongɨ 'ii‑o sii¹in jna ―jin'² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Joon 'iin²¹²in 'in tsá² do saan'¹mo 'ii tsajée¹i fu 'nʉñí³. Pe jiin'¹³ jaain²¹ jo gason'¹ tya'a tsʉ jo mo gatɨ́² 'ii'²¹ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Pe fúu¹mo 'áai¹ 'in jo'¹o galɨ́ɨ² 'ii. Joon gafaa'²¹a 'ido jin'²in: ―'Láai² milagro jmaa¹a 'in tsañʉʉ'¹ no. ¿Tɨ 'ná¹ jmá¹a Cristo mi jó¹o 'láai²gɨ milagro lagɨ 'in tsañʉʉ'¹ no? Jo 'ná¹ líi²na'a. Lɨ́ɨ²na'a 'e Cristo 'ino. ");
INSERT INTO chqNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Joon mo ganúu²un 'in tsá² coon²¹ poo²¹² sii²¹i fariseo 'e faa'²¹a tsá² cwáain¹ tya' Jesús gasɨɨ¹i røø²¹ coon'¹³ 'in tyʉ'² to² untsá² do 'e sii¹in 'ɨɨ'¹³ moyóo¹³ 'in taa²i cwo'¹ fee'¹ do tsaseen'¹³in Jesús. ");
INSERT INTO chqNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Joon gajin'²in Jesús: ―Taain²¹²taa coon'¹³ 'naa' coon²¹ ca tá² joon mi yuui'¹³ joon nii'¹³moo tún¹ fu lɨ tyíin¹in 'in gasii¹in jna. ");
INSERT INTO chqNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Joon 'naa' i'naa'¹³moo' jna pe jo tyee'¹naa' jna tsʉ jo li tyalíin²naa' fu lɨ nii'¹³na. ");
INSERT INTO chqNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Joon gacáin¹ unngɨɨ¹ɨ ruu'²¹i 'in tyʉ'² to² tsá² Israel do, jin'²in: ―¿Xiiafu lɨ tsei'² 'ino 'e jo tyee'¹na'? Wa jo tsáa¹a 'ino fu lɨ taan²¹²in tsá² Israel jee²¹² tsá² faa'²¹a jmíi¹ griego, joon i'e'²e 'in tsá² faa'²¹a jmíi¹ griego júu³ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿'Ee 'øøi'²¹‑tsi 'e gasɨɨ'²¹ɨ jna' 'e 'nee'¹³na' joon jo tyee'¹na' tsʉ jo li tsaa²¹a' xiiafu lɨ tsáa¹a? ");
INSERT INTO chqNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","'E jmɨɨ²¹² tyiin²gɨ la jee²¹² jilaa'²¹ 'e lɨ gatséi¹ 'e jmɨɨ²¹², joon jmɨɨ²¹² joon garoon¹on Jesús gafaa'²¹a tá², jin'²in: ―Wana 'in 'ɨ¹‑tsi 'e lɨcwii¹in Dios Jmii²¹ lawa jaain²¹ tsá² 'in unjmuu²i 'áai¹ 'ɨ¹‑tsi 'e tyee'¹³i lɨ sá² jmɨɨ²¹ 'ná¹ 'e jai'² lɨ́ɨ²i jna. Joon lawa tsá² 'in ga'un'²un jmɨɨ²¹ tyʉ́²‑ʉ 'ɨ́ɨ¹‑tsi la joon jon 'in jai'² lɨ́ɨ²i jna tyʉ́² i'ɨ́ɨ¹‑tsi 'e lɨcwii¹in Dios. ");
INSERT INTO chqNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Tsʉ tya' jileei'²¹ 'in jai'² lɨ́ɨ²i jna ilí² tya'a la lɨ́¹ 'e jin'² ni jí² taa'¹³ júu³ tyʉ́² tya' Dios 'e jin'²: “Alma tya' 'in jai'² lɨ́ɨ²i ilí² lawa coon²¹ jmɨɨ²¹ fee'¹ 'e nii'¹³ coon²¹ tøø²mo. Joon la cwaa¹a tɨ' jmɨɨ²¹ do 'e cwaan²¹mo jilaa'²¹ nuu²¹ la joon jon 'e jmɨɨ²¹ nii'¹³ alma tya' tsá² icwo¹o juncwii²¹ tya' tsá² 'e taa'²¹ coon²¹ tøø²mo.” ");
INSERT INTO chqNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Coon'¹³ 'e la joon 'øøi'²¹‑tsi 'e faa'²¹ Jesús 'e i'ii'²¹i 'in tsá² jai'² lɨ́ɨ²i 'ii 'in Espíritu Tyʉ́² tya' Dios. Tsʉ 'in Espíritu Tyʉ́² do jo mo ga'í¹i alma tya' 'in jai'² lɨ́ɨ²i 'ii tsʉ jo mo júin¹ Jesús wa' 'e 'ii'²¹i 'e 'ya'²gɨ tya'a 'e cwo'¹o Dios Jmii²¹ 'ii. ");
INSERT INTO chqNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","'Inlɨ́ɨi¹³ jee²¹² 'in tsá² do mo ganúu²un 'e júu³ lo, joon gajin'²in: ―'E ja'²mo 'ino 'in tsañʉʉ'¹ 'in 'ná¹ jó¹ cwo¹o júu³ tyʉ́². ");
INSERT INTO chqNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","'Inlɨ́ɨi¹³gɨ jin'²in: ―Cristo no. Pe 'in xeei'²¹gɨ gañii¹i: ―¿Xiiala cwoo¹i 'e Galilea 'e jó¹ Cristo? ");
INSERT INTO chqNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ni jí² tya' Dios faa'²¹a 'e jún² tya' 'lɨɨ²¹² rǿøi'³ David Cristo. Joon wa'a jún² tya' David 'ná²‑a liseein²¹ Belén lɨ galiseein²¹ David do. ");
INSERT INTO chqNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","La joon gaxé¹i tsá², galɨ́² tsá² coon²¹ tún² poo²¹² 'wii²¹² tya' Jesús. ");
INSERT INTO chqNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","'Inlɨ́ɨi³ 'iin²¹²in tøø¹ø 'ido 'nʉñí³ pe jiin'¹³ jaain²¹ jo gasan'² nii 'ido. ");
INSERT INTO chqNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Joon 'in 'ɨɨ'¹³ moyóo¹³ taai²¹² cwo'¹ fee'¹ ngalíin² tún¹ fu lɨ née¹i 'in fariseos do coon'¹³ 'in tsá² tyʉ'² to² untsá², joon 'in née¹i do sɨɨ'²¹ɨ 'ɨɨ'¹³ moyóo¹³: ―¿'Ee lɨ' jo té²ee' 'ido? ");
INSERT INTO chqNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Joon gañii¹i 'in 'ɨɨ'¹³ moyóo¹³ do: ―¡Jiin'¹³ jaain²¹ jo mo gafaa'²¹a la lɨ́¹ 'e faa'²¹a 'in tsañʉʉ'¹ no! ");
INSERT INTO chqNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Joon gajin'²in 'in tsá² fariseos do sɨɨ'²¹ɨ 'ɨɨ'¹³ moyóo¹³: ―¿Tɨ gacwoo²i yaanaa' con'² 'ido 'naa' tóo²? ");
INSERT INTO chqNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ce jiin'¹³ jaain²¹ tsacøøi'¹³ 'in tyʉ'² to² jna' jo jo'¹ mo galɨ́ɨ²i, jon'gɨ tsá² fariseos do jo'¹ lɨ́ɨ²i. ");
INSERT INTO chqNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Pe jiin'¹³ tsá² 'in jo cwii¹i 'e ley do ja'²mo lɨ́ɨ²i, joon Dios ijmáa¹a 'ii'²¹ tya' 'ido. ");
INSERT INTO chqNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Joon jaain²¹ tsá² 'in nityiin'¹³ jee²¹² fariseos do 'in nisii²¹ Nicodemo, 'in ningó¹o ngafee'¹³i Jesús lɨ canʉʉ²¹. Joon nigasɨɨ'²¹ɨ 'in catyaai² do: ");
INSERT INTO chqNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Jiin'¹³ la tyʉ'² to² ley tyi' jo li un'lɨ'³ɨ' jmoo²¹o' 'ii'²¹ tya' jaain²¹ tsañʉʉ'¹ 'e jo mo ganʉ́²ʉ' nifu 'ee 'e gó² 'e nigajmaa¹a. ");
INSERT INTO chqNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Joon gañii¹i 'in tsá² do sɨɨ'²¹ɨ Nicodemo: ―¿Tɨ 'in seen²¹in Galilea 'nʉ jon? Untsáa¹³du' jí² tya' Dios joon liñí²'i ce jiin'¹³ jaain²¹ tsá² cwo¹o júu³ tya' Dios jo mo jó² fu Galilea. ");
INSERT INTO chqNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Joon la jaain²¹ la jaain²¹ ngaliin¹mo fu tya'a. ");
INSERT INTO chqNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Pe Jesús ngóo¹o fu coon²¹ moo'²¹ lɨ sii²¹ Olivos. ");
INSERT INTO chqNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Mo jná² joon 'aa²¹a nga'²mo fu inʉʉ cwo'¹ fee'¹ si'² Jerusalén. Joon jileei'²¹ tsá² gangalíin² lɨ siin'¹³in Jesús. Joon gacwó² Jesús joon ga'láa² 'wii²¹² ga'e'²e tsá² júu³ tyʉ́². ");
INSERT INTO chqNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Joon 'in tɨfo'² tya' ley do joongɨ coon'¹³ tsá² fariseos nijée¹i jaain²¹ tsamɨ́² 'in gatsee'²¹i 'in ngó¹o 'no'³ 'láa¹ coon'¹³ tsañʉʉ'¹. Joon gasiin'¹in tún² tsa'² jee²¹² 'in tsá² taai² do, ");
INSERT INTO chqNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","joon gasɨɨ'²¹ɨ 'in tsá² do Jesús: ―Tɨfo'² tyii'i, 'in tsamɨ́² lo nigaseen'¹³moo'o lɨ ngó¹o 'no'³ 'láa¹a coon'¹³ tsañʉʉ'¹. ");
INSERT INTO chqNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Joon 'e ley tya' Moisés tyʉ'²ʉ to² jna'a 'e jngaa'¹³na'a coon'¹³ cuun²¹² jileei'²¹ 'in 'láa¹ la 'láa¹ 'in tsamɨ́² no. ¿'Nʉ‑gɨ xiiala foo'²¹'o? ");
INSERT INTO chqNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Jin'² 'in tsá² do la joon sɨɨ'²¹ɨ Jesús coon'¹³ 'iin²¹²in tsáai¹‑tsi 'ee ijin'² Jesús tsʉ la joon wa iuntyifu¹ 'nɨ́ɨ¹i Jesús. Joon gajuu'²¹i Jesús 'ña'a joon ga'láa² 'wii²¹² jmaa¹a letra ni 'wó². ");
INSERT INTO chqNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Joon 'in tsá² do ngóo¹gɨ 'naai'¹³ 'e unngɨɨ¹ɨ. Joon ganii'¹³i Jesús 'ña'a, joon gasɨɨ'²¹ɨ 'in tsá² do: ―Jmoo²¹ joon²¹ jaain²¹ 'naa' 'in jo mo ga'nóo²o tsaa² joon 'ii tyʉ'²ʉ 'e cuun²¹² do nifu. ");
INSERT INTO chqNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Joon gajmaa¹a 'in tuu'²¹i, gajmaa¹a letra ni 'wó² tún¹. ");
INSERT INTO chqNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Joon mo ganúu²un 'in tsá² do 'e júu³ lo joon ga'aa¹o fa'ɨɨ'²¹. Joon ga'woo²¹i tɨ' jaan²¹mo, ga'láa² 'wii²¹² 'in yʉʉ'¹³gɨ ga'woo²¹i nifu lɨ tséi¹gɨ ga'woo²¹i 'in xaai¹gɨ. Joon mo gatoo'¹ 'woo²¹i jileei'²¹ joon 'ña'a Jesús gatuui¹gɨ coon'¹³ 'in tsamɨ́² do. ");
INSERT INTO chqNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Joon ganii'¹³i Jesús 'ña'a, joon mo gajǿø²ø jo 'iin seein²¹ jiin'¹³ jaain²¹, jiin'¹² tsamɨ́² do 'in tyíin¹gɨ, joon gasɨɨ'²¹ɨ 'in tsamɨ́² do: ―Yá³, ¿'naaigɨ 'in jmoo¹o tsaa² tyi'i? ¿Tɨ jiin'¹³ jaain²¹ jo 'iin gapíin² 'nʉ? ");
INSERT INTO chqNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Joon gajin'² 'in tsamɨ́² do: ―'Un², jiin'¹³ jaain²¹ jo 'iin cwo'¹o jna tsaa². Joon gajin'² Jesús sɨɨ'²¹ɨ 'in tsamɨ́² do: ―Jon'gɨ jna píin²na 'nʉ. Cwooi'¹³ no, jo cwo'laa²¹²gɨ'ɨ. ");
INSERT INTO chqNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesús sɨɨ'²¹ɨ tsá² tún¹, joon gajin'²in: ―Jna‑a lɨ́ɨ¹na 'yiia²¹ tɨ ni cwoo'¹³ fu juncwii²¹. La jnaa'²¹ tsá² coon'¹³ 'yiia²¹ tya' ñi'¹ la joon jon tsʉ 'wii'¹³ jna iliñi¹i tsá² xiiala 'e ngɨ́²i tyani Dios. Joon 'in ngɨ¹ coon'¹³ jna sá²‑a 'yiia²¹ tya'a 'e cwo¹o juncwii²¹ tya'a. Joon jo jmɨɨ²¹² ngɨ¹ lɨ nʉʉ²¹. ");
INSERT INTO chqNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Joon jin'² 'in tsá² fariseos do sɨɨ'²¹ɨ Jesús: ―'Nʉ foo'²¹'o cwáain¹ tyi'i 'wo'o, 'e foo'²¹'o do jo to² 'íi³in. ");
INSERT INTO chqNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Joon Jesús‑gɨ gañii¹i: ―Tyíin²mo júu³ tyiia xʉfiin'¹³ jna 'ñii'a fo'³oo cwáain¹ tyiia. Pe 'ñiia'oo ñí³ii fu lɨ gagoo²¹²oo joongɨ fu lɨ ní³ii. Pe 'naa'gɨɨ' jo ñí²ii' xiiafu lɨ gagoo²¹²oo jon'gɨ fu lɨ ní³ii. ");
INSERT INTO chqNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","'Naa' jmoo²oo' 'ii'²¹ jiin'¹³ la 'ii'²¹ tya' tsá² taan²¹²in juncwii²¹. Pe jna‑a, jo 'in 'ii'²¹ tya'a jmóo³oo. ");
INSERT INTO chqNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Pe wa jmáa³aa 'ii'²¹ tya' tsá², jmáa³aa 'ii'²¹ røø²¹, tsʉ jo jmóo³oo 'ii'²¹ 'ñii'a, Ñʉ'³oo, 'in gasii¹in jna jmóo³oo 'ii'²¹ caan²¹mo coon'¹³on. ");
INSERT INTO chqNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ni ley tyi'naa' faa'²¹a: wana seein²¹ gái¹ 'in jmoo¹o júu³ røø²¹ faa'²¹a røø²¹, joon 'ná¹‑a 'ii'¹³moo' júu³ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Joon 'ñii'a fo'³oo 'wii²¹² tyiia 'e la goo²¹o'o coon'¹³ Ñʉ'¹ʉ' 'in gasii¹in jna. ");
INSERT INTO chqNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Joon gaunngɨɨ¹ɨ 'in tsá² do sɨɨ'²¹ɨ Jesús: ―¿Xiiafu tyíin¹ ñʉ'²'ʉ? Joon gajin'²in Jesús: ―'Naa' jo cwii¹naa' jna jon'gɨ Ñʉ'³ʉʉ cwii¹naa'. Tsʉ wa'a cwii¹naa' jna, cwii¹moo' jon Ñʉ'³ʉʉ. ");
INSERT INTO chqNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesús gajin'²in 'elo la 'ɨɨ²¹² 'ee¹e júu³ tyʉ́² inʉʉ cwo'¹ fee'¹ do co' lɨ roon¹on cwóo¹ to'² tsá² cuu². Pe ce jiin'¹³ jaain²¹ jo 'iin²¹ gasan'² ni Jesús tsʉ jo mo tɨ 'ii'²¹ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesús sɨɨ'²¹gɨ 'in tsá² do: ―Nii'¹³moo jna, joon 'naa'gɨɨ' 'naa'¹³moo' jna pe mi júun²naa' røø²¹moo' tsaa². Joon fu lɨ nii'¹³na jo lí² cwolíin²naa'. ");
INSERT INTO chqNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Joon 'in tyʉ'² to² tsá² Israel do faa'²¹a, ¿wa jon' ijngai'² 'ino 'ña'o 'e sɨɨ'²¹ɨ jna' 'e jo lí² tsaa²¹a' fu lɨ tsee'¹³i? ");
INSERT INTO chqNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Joon gajin'² Jesús sɨɨ'²¹ɨ 'in tsá² do: ―'Naa', 'in seein²¹ lɨ 'wii²¹² lo 'naa', pe jna 'in seein²¹ lɨ yʉ'³ do: 'naa' jiin'¹³ 'in niseein²¹ fu juncwii²¹ lo‑o pe jon' jiin'¹³ 'in seein²¹ fu juncwii²¹ lo jna. ");
INSERT INTO chqNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Tsʉ 'wii'¹³ joon fuu²¹²uu 'naa' mi júun²naa' røø²¹moo' tsaa². Mi júun²naa' røø²¹moo' tsaa² tsʉ jo mo galijai'² galɨ́ɨ²naa' jna jiin'¹³ la lɨ' 'e lɨ́ɨ¹na. ");
INSERT INTO chqNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Joon gaunngɨɨ¹ɨ 'in tsá² do: ―¿'Iin‑gɨ 'nʉ joon? Joon gajin'² Jesús: ―Ca la mo 'wii²¹²mo gafuu²¹²uu 'naa' 'iin jna. ");
INSERT INTO chqNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","'Láa²mo 'nogɨ 'e 'ná¹ fuu²¹²uu 'naa' xiiala lɨ́ɨ¹naa'. Pe fuu²¹²uu 'naa' tsá² taan²¹²in juncwii²¹ jiin'¹³ 'e ninúu³oo faa'²¹a 'in gasii¹in jna joon jmai'² 'e ja'²mo faa'²¹a 'ido. ");
INSERT INTO chqNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Pe 'in tsá² do jo mo ga'øøi'²¹‑tsi 'e faa'²¹a 'ido cwáain¹ tya' Ñʉ'¹ʉ'. ");
INSERT INTO chqNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Tsʉ 'wii'¹³ joon gajin'² Jesús sɨɨ²¹ɨ 'in tsá² do: ―Mi saa'¹³naa' jna, 'in Ruu'²¹i Tsá², joon ilicwii¹naa' jna jiin'¹³ la lɨ́ɨ¹na. Joon iliñí²ii' 'e jo jmóo³oo ce jiin'¹³ coon²¹ 'e 'øøi'²¹‑tsii 'ñii'a. Pe jiin'¹³ 'e ga'e'²e Ñʉ'¹ʉ' jna fuu²¹²uu 'naa'. ");
INSERT INTO chqNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Tsʉ 'in gasii¹in jna 'ii‑o ngɨ¹ɨ coon'¹³ jna. Joon Ñʉ'³ʉʉ jo mo gatíuu²i jna 'ñii'a, tsʉ jna jmóo³oo jiin'¹³ 'e 'yaai¹‑tsi. ");
INSERT INTO chqNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Joon mo gajin'² Jesús 'elo 'áa¹mo fúui¹ 'in jo'¹ galɨ́¹i 'ii. ");
INSERT INTO chqNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Joon gajin'² Jesús sɨɨ'²¹ɨ 'in tsá² Israel 'in jo'¹ galɨ́ɨ¹i 'ii: ―Wa gasii'¹³naa' yaanaa' tá², jo tʉ́ʉ²ʉʉ' 'e nigafuu²¹²uu 'naa', nilíin²naa' tsá² tyiia 'e la jai'². ");
INSERT INTO chqNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Joon iliñí²ii' la jai'², joon coon'¹³ 'e la jai'² do iláa²moo'. ");
INSERT INTO chqNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Joon gajin'² 'in tsá² do: ―Jún² tya' Abraham‑mo jna'a, joon ce jiin'¹³ cafu jo mo gajmoo²¹o'o to² tya' 'in seein²¹ fuu²¹ xiia' wa 'nogɨ 'e láa²na'a. ¿'Ee lɨ'ɨ 'e fu'²'u jna'a 'e láa²na'a? ");
INSERT INTO chqNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Joon gajin'²in Jesús: ―'E júu³ ja'²mo fuu²¹²uu 'naa' lo, jileei'²¹ 'in 'lá¹a tsaa² tyí¹ jo la tɨ́¹i coon'¹³ tsaa² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Jaain²¹ tsa'leei'¹³ jo jmɨɨ²¹² wa'a ilíin² tsá² inʉʉ. Pe jaain²¹ jóon¹on tsá² 'in lɨ́ɨ¹i tsá² inʉʉ coon²¹ tøø²mo 'i. ");
INSERT INTO chqNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Joon wana 'in Jóon¹on Dios jmaa¹a láa²naa', joon la joon 'e ja'²mo 'e in láa²naa'. ");
INSERT INTO chqNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Niñíi³oo 'e 'naa'oo' jún² tya' 'lɨɨ²¹² Abraham, pe 'iin²¹²naa' jngaa'¹³moo' jna tsʉ jo 'ii'¹³naa' 'e nifuu²¹²uu 'naa'. ");
INSERT INTO chqNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Pe fo'³oo jiin'¹³ 'e ni'e'²e Ñʉ'³ʉʉ jna joon 'naa' jmaa²aa' jiin'¹³ 'e nijin'² ñʉ'²ʉʉ'. ");
INSERT INTO chqNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Joon 'ii dogɨ gañii¹i: ―Abraham‑mo ñʉ'¹ jna'a. Pe Jesús gasɨɨ'²¹ɨ 'ido: ―Waxʉ lɨ'ɨ 'e jai'² 'e ñʉ'¹ 'naa' Abraham ijmáa¹³naa' la lɨ' 'e gajmaa¹a. ");
INSERT INTO chqNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Xʉfiin'¹³ wa'a fuu²¹²uu 'naa' 'e júu³ jai'² 'e ga'e'²e Dios jna, pe 'naa' 'iin²¹²naa' jngaa'¹³moo' jna. ¡Abraham jo gajmaa¹a la joon! ");
INSERT INTO chqNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","'Naa' 'ná¹ jmaa²aa' la joon la lɨ 'e gajmaa¹a ñʉ'²ʉʉ'. Joon 'ii dogɨ gajin'²in: ―Jna'a jo lɨ́ɨ¹na'a tsá² 'in jo jmii²¹ seein²¹ tsʉ seein²¹ jaan²¹o ñʉ'¹ʉ'ʉ 'in sii²¹ Dios 'i. ");
INSERT INTO chqNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesús joon gasɨɨ'²¹ɨ 'ido: ―Waxʉ lɨ' 'e la jai'² ñʉ'²naa' Dios Jmii²¹ 'e la 'iin²¹²moo' jna, tsʉ goo²¹²oo fu tyani Dios, joon lo‑o tyíin¹na. Jon' gagoo²¹²oo cwáain¹ tyiia 'ñii'a tsʉ Dios Jmii²¹ gasii¹in jna. ");
INSERT INTO chqNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿'Ee lɨ'ɨ jo 'e 'øøi'²¹‑'oo' 'e fo'³oo lo? Jo 'øøi'²¹‑'oo' tsʉ jo 'iin²¹²naa' núu³oo' júu³ tyiia. ");
INSERT INTO chqNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Joon ñʉ'²naa' 'in 'lɨɨ'³mo 'ii. Joon jóon¹on 'ii 'naa' 'e joon 'iin²¹²naa' jmaa²aa' 'e 'iin²¹²in 'ii tsʉ ca la mo nifu gajngaa'¹³i 'in 'lɨɨi'³ do tsá². Ce jiin'¹³ cafu jo mo gajmaa¹a 'e jai'² jogɨ faa'²¹a 'e jai'². Mo faa'²¹a júu³ tajuu²¹ faa'²¹a jiin'¹³ la 'e lɨ́² lɨ́ɨ¹i. Tajuu²¹mo 'ii, joon jilaa'²¹ júu³ tajuu²¹ 'e faa'²¹a tsá² 'in 'lɨɨ'³mo jmii²¹i 'e júu³ tajuu²¹ joon. ");
INSERT INTO chqNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Pe jna fo'³oo 'e ja'²mo, joon 'naa' jo jo'¹ lɨ́ɨ²naa' jna. ");
INSERT INTO chqNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Tɨ seein²¹ jaain²¹ jee²¹² 'naa' 'in jmá¹a júu³ røø²¹ 'e 'oo² jna tsaa² tyi¹? Joon wa'a fuu²¹²uu 'naa' júu³ 'e jai'², ¿'ee lɨ' jo jo'¹ lɨ́ɨ²naa' jna? ");
INSERT INTO chqNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Jileei'²¹ 'in jóon¹on Dios nuu¹o júu³ tya' Dios, pe 'naa'gɨɨ' jon' jóon¹on Dios 'naa' tsʉ 'wii'¹³ joon jo 'iin²¹²naa' nuu²uu' júu³ tya' Dios ―jin'² Jesús sɨɨ'²¹ɨ 'in tyʉ'² to² tsá² Israel do. ");
INSERT INTO chqNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Joon gajin'² tsá² Israel sɨɨ'²¹ɨ 'ido: ―'E ja'²mo mo nigafaa'¹³a'a 'e tsá² seein²¹ Samaria 'nʉ joongɨ 'e 'yuui² 'in 'lɨɨ'³mo alma tyi'i. ");
INSERT INTO chqNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Joon Jesús‑gɨ gañii¹i: ―Jo 'in 'lɨɨi'³ 'yuui² alma tyiia. Jilaa'²¹ 'e jmóo³oo jmai'² tya' 'e untyuu²¹²na Ñʉ'³oo pe 'naa'gɨɨ' jmai'² 'e un'lɨɨ'³moo' jna. ");
INSERT INTO chqNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Pe jna jo 'noo'¹³oon wa' 'e untyuu²¹²i tsá² jna xʉfiin'¹³ seein²¹ jaain²¹ 'in 'noo'¹on la joon, joon 'ii jmoo¹o 'ii'²¹. ");
INSERT INTO chqNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","'E la ja'²mo fuu²¹²u 'naa', jileei'²¹ 'in unjíi²i júu³ tyiia 'e fo'³oo lo, jo jmɨɨ²¹² ijúun²in. ");
INSERT INTO chqNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Joon gajin'² 'in tyʉ'² to² tsá² Israel sɨɨ'²¹ɨ Jesús: ―Nogɨ tsei'² 'e ja'²mo lɨ́ɨ²na'a 'e 'yuui² 'in 'lɨɨ'³mo alma tyi'i. 'Lɨɨ²¹² Abraham joongɨ jileei'²¹ 'in cwo¹o júu³ tyʉ́² 'in gajún¹mo 'i joon 'nʉgɨ fu'²'u jna'a: “'In unjíi²i jilaa'²¹ 'e fo'³oo lo, jo jmɨɨ²¹² ijúun²in.” ");
INSERT INTO chqNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Tɨ lɨ́ɨ²u 'e feei'¹gɨ'ɨ la 'lɨɨ²¹² nʉ'¹ʉ' Abraham? Gajún²mo 'i la joon jon gajún²mo 'in gacwo¹o júu³ tyʉ́² la mo jéei¹. ¿'Iin 'nʉ lɨ́ɨ²u jon? ");
INSERT INTO chqNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesús gajin'²in: ―Jo lí² untyuu²¹²na 'ñii'a, tsʉ wana untyuun²¹²na 'ñii'a jo to² 'íi³in. Pe 'in untyuu²¹²u jna Ñʉ'³oo 'i, tsʉ 'ii jon foo'²¹ 'naa' Dios tyii'. ");
INSERT INTO chqNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Pe 'naa' jo cwii¹naa' 'ii. Pe jna cwii¹moo. Joon wa jna fo'³oo 'e jo cwii¹na 'ido joon jna tajuu²¹moo la lɨ́ɨi¹ 'naa'oo'. Pe la jai'² cwii¹moo joongɨ unjíi²oo 'e jin'²in. ");
INSERT INTO chqNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","'Lɨɨ²¹² tsafeei'¹ tyii' Abraham galijløøi'³ 'áa¹mo mo galɨñii¹i iní² jmɨɨ²¹² tyiia. Ganii²¹, joon galijløøi'³ 'áai¹. ");
INSERT INTO chqNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Joon gajin'²in 'in tyʉ'² to² tsá² Israel do sɨɨ'²¹ɨ Jesús: ―Jo mo 'oo²gɨ'ɨ cincuenta jiin²¹. ¿Xiiala lɨ́² 'e foo'²¹'o 'e gañíi¹³u'u Abraham? ");
INSERT INTO chqNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Joon gajin'² Jesús: ―'E la ja'²mo fuu²¹²uu 'naa', la nʉ'gɨ 'e la seein²¹ Abraham, niseen²¹mo jna ―jin'² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Joon 'in tsá² do gasaa'¹³a cuun²¹² ityuu'¹³i Jesús. Pe Jesús do ga'mée¹mo 'ña'a joon cwo'ɨ́ɨ¹o 'e cwo'¹ fee'¹ do. Joon gangɨ́ɨ¹i jee²¹² 'ido, ganga'²mo. ");
INSERT INTO chqNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Joon lɨ gangɨ́ɨ¹i do nii²in jaain²¹ tsañʉʉ'¹ 'in nigangaai'¹³ tiui². ");
INSERT INTO chqNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Joon 'in tsá² ngɨ¹ɨ coon'¹³on do nigaunngɨɨ¹ɨ 'ido, joon nigajin'²in: ―Tɨfo'² tyii'i, ¿'ee lɨ' gangaa'¹³i 'in tsañʉʉ'¹ tiui²? ¿Xʉfo' røøi²¹ sáa³ jmɨɨ²¹ tsaa² 'ee sɨ' røøi²¹ 'ña'a no tsaa² 'ee? ");
INSERT INTO chqNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Joon gajin'² Jesús: ―Jo galɨ́² tiui² cwáain¹ tya' tsaa² tya'a 'ña'a jon'gɨ tsaa² tya' sáa³ jmii²¹; 'e galɨ́² tiui² 'wii'¹³ tya' coon'¹³ 'e la joon ilí² 'e'²e Dios tsá² jilaa'²¹ 'e lí² jmáa¹a. ");
INSERT INTO chqNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ná¹‑a jmáa³aa to² tya' 'in gasii¹in jna mo jmɨɨ²¹² tsʉ najó²‑o 'e lɨ nʉʉ²¹ joon jo 'iin lii'¹gɨ jmá¹ to². ");
INSERT INTO chqNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","La 'ɨɨ²¹² 'e taan¹na 'e fu juncwii²¹ lo lɨ́ɨ¹na jɨ́² coo²¹ 'e ni cwoo'¹³ juncwii²¹ lo. ");
INSERT INTO chqNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Joon mo ngayuui'¹³ gajin'²in 'e júu³ lo Jesús gañíi¹³i ni 'wó² joon gajmaa¹a xʉ capiléen³ jiin¹ coon'¹³ jmɨɨ²¹ 'e'²e. Joon gasoon²¹on unni² 'in tsá² tiui² do. ");
INSERT INTO chqNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Joon gajin'²in sɨɨ'²¹ɨ 'in tsá² tiui² do: ―Cwó², cworuun'¹³un unní²'i coon'¹³ jmɨɨ²¹ 'in 'o² tsi pila sii²¹ Siloé ―'øøi'²¹‑tsi tsá² 'e sii²¹, 'in gasii¹in do, coon'¹³ jmíi¹. Joon gangoo²¹‑o 'in tsá² tiui² do, niruun'¹³un unníi¹in joon mo gacɨɨ'¹³ɨ joon nijnaa'²¹o. ");
INSERT INTO chqNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Joon 'in tsá² née¹i tyan' lɨ tyíin¹in 'in tʉʉ² do coon'¹³ tsá² 'in niganíi²in 'in tiui do gajin'²in: ―¿Tɨ jon' 'ino 'in tsá² la mo tyíin¹in 'in mɨ¹ɨ caridad? ");
INSERT INTO chqNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","'Inlɨ́ɨi¹³ gajin'²in: ―'Inoo do. 'Inlɨ́ɨi¹³gɨ gajin'²in: ―Jon' 'ino do, pe coonti‑i la joon jnée²i. Pe 'ña'a 'in tsá² do 'e noo²¹²ta tiui² gajin'²in: ―Jna‑a 'in tsá² ta tiui² do. ");
INSERT INTO chqNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Joon gaunngɨɨ¹ɨ 'in tsá² do: ―¿Xiiala lɨ 'e nijnaa'²¹o'o? ");
INSERT INTO chqNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Joon ganii¹i 'in tsá² ta tiui² do: ―Jaain²¹ tsañʉʉ'¹ sii²¹ Jesús 'in gajmaa¹xʉ jiin¹ gasúun²un unní³ii, joon jin'²in sɨɨ'²¹ɨ jna²: “Cwó² fu lɨ náa¹ pila sii²¹i Siloé, joon roon'¹³'on unní²'i.” Joon gangoo²¹²oon joon mo garuun'¹³uun unní³ii do joon galɨ́² jnaa'²¹oo. ");
INSERT INTO chqNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Joon gaunngɨɨ¹ɨ 'in tsá² do sɨɨ'²¹ɨ 'in tsá² ta tiui² do: ―¿Náai¹³gɨ 'in tsañʉʉ'¹ do? Joon gajin'² 'in tsá² ta tiui² do: ―Jo ñii²ii naai¹. ");
INSERT INTO chqNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Joon 'in tsá² taai² do nijaa²¹²mo 'in tsá² ta tiui² do tyani tsá² fariseo. ");
INSERT INTO chqNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Pe jmɨɨ²¹² 'ii'¹ 'woo'²¹ tsá² 'e jmɨɨ²¹² 'e gaun'láa²i Jesús 'in tsá² tiui² do. ");
INSERT INTO chqNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","'Wii'¹³ joon gaunngɨɨ¹ɨ 'in fariseos do 'in tsá² ta tiui² do xiiala galɨ́² 'e la no nilí²‑i jǿø²ø. Joon gajin'²in 'ido: ―Jiin¹in gasúun²un 'ido unní³ii mo ngayuui'¹³ joon joon garuun'¹³oo, 'wii'¹³ joon nijnaa'²¹oo la no. ");
INSERT INTO chqNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Joon 'inlɨ́ɨi¹³ tsá² fariseo jin'²in: ―'In tsañʉʉ'¹ 'in gajmaa¹a 'elo jo gajmaa¹a 'ii'²¹ tya' Dios tsʉ jo tsáai¹‑tsi jmɨɨ²¹² 'ii'²¹ 'woo'²¹ tsá². Pe 'inlɨ́ɨi¹³gɨ gajin'²in: ―¿Xiiala lí² jmáa¹a 'e li² milagro no wa'a røøi²¹ tsaa² tyi¹? Coon'¹³ la joon galɨ́² tún² poo²¹² 'ii. ");
INSERT INTO chqNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Joon gaunngɨɨ¹ɨ tún¹ 'in tsañʉʉ'¹ ta tiui² do: ―'Nʉ‑gɨ, ¿xiiala foo'²¹'o cwáain¹ tya' 'in tsañʉʉ'¹ 'in gacwo¹o unní²'i do? Joon 'i‑gɨ gajin'²in: ―Jna fo'³oo, jaain²¹ tsá² 'in cwo¹o júu³ tyʉ́² tya' Dios 'ido. ");
INSERT INTO chqNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Pe 'in tyʉ'² to² tsá² Israel jo jo'¹ mo lɨ́ɨ²mogɨ 'e ta tiui² 'in tsañʉʉ'¹ do ce gatø'¹o 'in sáa³ jmii²¹ 'in tsá² ni'láa²i do. ");
INSERT INTO chqNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Joon gaunngɨɨ¹ɨ tsacøøi'¹³ tya' 'in tsá² do: ―¿Tɨ 'ino‑o yʉʉn²¹ tyii' 'in ca la mo gangaa'¹³mo 'e foo²oo' nitiuu²mo? ¿Xiiala lɨ 'e la no nijnaa'²¹o? ");
INSERT INTO chqNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Joon tsacøøi'¹³ tya' 'in tsá² ta tiui² do gañii¹i: ―Ne²oo'o 'e yʉʉn²¹ tyi‑oo'o 'ino, joon ca la mo gangaa'¹³i tiuu²mo. ");
INSERT INTO chqNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Pe jo né²e'e xiiala lɨ 'e la no nijnaa'²¹o. Jo mo la né²e'e 'iin gaun'lá² unníi¹i. Unngɨɨ¹ duu' 'ña'a no, tsʉ tsá² 'in nifee'¹mo no. 'Ña'a noo jmá¹a júu³ røø²¹. ");
INSERT INTO chqNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Jmii²¹i gajin'²in la joon tsʉ 'wii'¹³ 'e 'goo'²¹‑o. Tsʉ 'in tyʉ'² to² tsá² Israel gasɨ́ɨ²i røø²¹ 'e jo cwo¹gɨ tsataa²i inʉʉ cwo'¹ sinagoga jileei'²¹ 'in jin'² 'e Cristo Jesús. ");
INSERT INTO chqNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Tsu 'wii'¹³ joon gajin'² tsacøøi'¹³ tya'¹a: “Unngɨɨ¹duu' 'ña'a no, tsʉ tsá² 'in nifee'¹mo no.” ");
INSERT INTO chqNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Joon gatø'¹ø 'in tyʉ'²ʉ to² tsá² Israel do 'in tsañʉʉ'¹ ta tiui² do, joon gasɨɨ'²¹ɨ: ―Sii'¹³ jna'a júu³ ja'²mo tyani Dios. Jna'a ne²oo'o 'e tsá² røøi²¹ tsaa² tyi¹ 'ino. ");
INSERT INTO chqNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Joon gañii¹i 'in tsá² ta tiui² do: ―Jo ñí³ jna tɨ røøi¹ 'ino tsaa² tyi¹ sɨ jo røøi²¹ 'ee. Jiin'¹³ 'e ñí³ii 'e jna‑a tsá² ta tiuu²mo joon la no nijnaa'²¹oo. ");
INSERT INTO chqNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Joon gaunngɨɨ¹ɨ 'in tsá² do tún¹: ―¿'Ee gajmaa¹a tyi'i? ¿Xiiala jmaa¹a 'e gacwo'¹o 'nʉ unni²'i? ");
INSERT INTO chqNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Joon 'in tsá² ta tiui² do gajin'²in: ―Nifuu²¹²gɨ jna 'naa' joon jogɨ unjii²ii'. ¿'Ee lɨ' 'iin²¹²naa' 'e fo'³oo tún¹ 'e nifo'³oo do? ¿Tɨ 'iin²¹²naa' líin²naa' tsá² tya'a? ");
INSERT INTO chqNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Joon 'in tyʉ'² to² tsá² Israel do gauntyíi²in 'ido joon gasɨɨ'²¹ɨ 'ido: ―'Nʉ‑ʉ, lɨ́ɨ²u'u tsá² tya' 'in tsañʉʉ'¹ do pe jna'gɨɨ'ɨ lɨ́ɨ²na'a tsá² tya' Moisés ");
INSERT INTO chqNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","tsʉ jna'a ne²oo'o 'e Dios nigafee'²¹mo Moisés pe 'in tsañʉʉ'¹ do jo né²e'e xiia fu seein²¹. ");
INSERT INTO chqNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Joon 'in tsá² ta tiui² do gajin'²in: ―¡'Áa¹i tsa'góo²‑tsii 'e foo'²¹ 'naa' 'e jo ñí²ii' xiia' seein²¹ 'ido pe 'ido nigacwo'¹o jna unní³ii! ");
INSERT INTO chqNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tyʉ́²‑ʉ né² jna' 'e jo unjíi²i Dios júu³ tyʉ́² 'e faa'²¹a tsá² røøi²¹ tsaa² tyi¹. Unjíi²i Dios jiin'¹³ júu³ tya' tsá² 'in un'goo²¹o 'ii joongɨ jmoo¹o 'ido jiin'¹³ 'e 'iin²¹²in Dios. ");
INSERT INTO chqNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Jo mo lɨ sá² júu³ 'e galɨ́ jnaa'²¹a jaain²¹ tsañʉʉ'¹ 'in tiui² ca la mo gangaa'¹³i. ");
INSERT INTO chqNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Wa' 'in tsañʉʉ'¹ no jo gasii¹in Dios 'ii jo 'e lí² jmáa¹a jiin'¹³ coon²¹. ");
INSERT INTO chqNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Joon 'in tyʉ'² to² tsá² Israel gajin'²in sɨɨ'²¹ɨ 'in tsá² ta tiui² do: ―'Nʉ‑ʉ, 'in gangaai'¹³ coon'¹³ tsaa² tyi¹, joongɨ 'iin²¹²un 'e'³'e jna'a júu³ tyʉ́². Joon gatyii¹mo 'in tsá² ta tiui² do jee²¹² 'ii. ");
INSERT INTO chqNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Joon galiñii¹i Jesús 'e gatyii¹in tsá² Israel 'in tsá² ta tiui² jee²¹² 'ii joon mo jiin'¹in Jesús 'in tsá² ta tiui² do joon gajin'²in sɨɨ'²¹ɨ 'ido: ―¿Tɨ jo'¹ lɨ́ɨ²u Jóon¹on Dios? ");
INSERT INTO chqNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Joon gajin'² 'in tsañʉʉ'¹ do: ―Sii'¹³ jna 'iin²¹² 'i tsʉ joon jo'¹o lɨ́ɨ²na 'ii. ");
INSERT INTO chqNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Joon gajin'² Jesús: ―'In niñíi¹mo 'nʉ 'i. Jna‑a 'i 'in sɨɨ'¹³u coon'¹³on. ");
INSERT INTO chqNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Joon 'in tsañʉʉ'¹ do tsifu gasii'²¹i moojníi¹i tyani Jesús joon gajin'²in: ―Jo'¹o lɨ́ɨ²na 'nʉ, Ña'ñʉ'¹ʉ'. Joon gaun'goo¹o Jesús. ");
INSERT INTO chqNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Joon gajin'² Jesús: ―Jna goo²¹²oo ni cwoo'¹³ juncwii²¹ lo 'e 'ná¹‑a lɨ sá² 'ii'²¹ 'e lɨ jnaa'²¹ 'in tiui² joon 'in jnaa'²¹ ilitiuu²mo cwáain¹ tya' júu³ tyʉ́² tya' Dios. ");
INSERT INTO chqNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Joon 'inlɨ́ɨi¹³ tsá² fariseos 'in taai² do coon'¹³ Jesús mo ganúu²un 'e júu³ do joon gaunngɨɨ¹ɨ sɨɨ'²¹ɨ Jesús: ―¿Tɨ joon tsá² tiuu²mo jna'a jon? ");
INSERT INTO chqNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Joon gajin'² Jesús: ―Wa'a 'naa' 'e tiuu²naa' jo 'e tsaa² røø²¹naa' cwáain¹ tya' tsaa² tyi¹. Pe 'e foo²oo' 'e jnaa'²¹oo' joon 'oo²oo' tsaa² tyi¹. ");
INSERT INTO chqNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Faa'²¹gɨ Jesús: ―'E la ja'²mo fuu²¹²uu 'naa' ―jin'² Jesús― jileei'²¹ 'in jo tsataai² lɨ 'oo² 'yá² lɨ taai² joo'saa'²¹ pe tsataai² fu lɨ' lɨ xiia' 'uun²¹ 'i. ");
INSERT INTO chqNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Pe 'in tsa'í² lɨ 'oo² 'yá² do 'ii 'in tsá² 'in ngɨ¹ to² 'aai¹ joo'saa'²¹ do. ");
INSERT INTO chqNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Joon 'in tsá² 'in ní² 'oo² 'yá² do inó² 'e 'oo² 'yá² do tya' 'in tsá² 'in 'aai¹ joo'saa'²¹ 'e tsa'í² 'ido. Joon 'in joo'saa'²¹ do cwii¹o jmíi¹ tya' 'in 'aa¹i 'ii. Joon 'in tsá² 'aa¹i joo'saa'²¹ do ñii¹o 'ee sii²¹ 'ido la jaain²¹ la jaain²¹. Joon 'woo¹ ni 'ido fu caluu. ");
INSERT INTO chqNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Joon mo ngayuui'¹³ 'woo¹ ni 'in joo'saa'²¹ do jileei'²¹ joon 'in 'aai¹ 'ii gangɨ́ɨ¹i ngóo¹‑o nifugɨ lɨ ningalíin² 'in joo'saa'²¹ do. Joon 'in joo'saa'²¹ do ngalíin² caluu tsʉ cwii¹i 'ido jmíi¹ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Pe jo tsalíin² 'in joo'saa'²¹ do caluu 'in jo cwii¹in xʉjoon 'e cwiin¹o, tsʉ jo cwii¹i jmíi¹i tya' 'in tsá² jo cwii¹in ―jin'² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesús gatyaa¹ 'e júu³ lo tya' 'e 'e'²e tsá² pe 'in tsá² fariseos do jo ga'øøi'²¹‑tsi 'e cwoo¹i 'øøi'²¹‑tsi 'e júu³ do. ");
INSERT INTO chqNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Joon gajin'² Jesús tún¹ sɨɨ'²¹ɨ 'in tsá² do: ―'E la ja'²mo fuu²¹²uu 'naa': Jiin'¹³ jna‑a lɨ́ɨ¹na 'oo² 'yá² do 'e lɨ tsataai² joo'saa'²¹, tsʉ la taai² joo'saa'²¹ tsi 'yá² coon'¹³ 'oo² 'yá² do la joon jon 'wii'¹³ jna‑a lí²‑i tsataai² tsá² ñʉ'fú². ");
INSERT INTO chqNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Jileei'²¹ 'in jalíin² jée¹gɨ la jna 'uun²¹ 'i, la jo unjíi²in 'in joo'saa'²¹ do 'in jo cwii¹in la joon jon jo unjíi²in 'in tsá² tsataai² ñʉ'fú² 'in jalíin² jée¹gɨ lagɨ jna. ");
INSERT INTO chqNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Jna‑a lɨ́ɨ¹na 'e 'oo² 'yá² do joon jileei'²¹ 'in tsataai² 'wii'¹³ jna itiin'¹³mo 'ii. Lɨ́ɨ¹i lawa joo'saa'²¹ 'in tsataai² tsi 'yá² joongɨ 'woo¹i seen²¹in tyʉ́² sá² 'e dø'¹ø. ");
INSERT INTO chqNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Pe 'in 'uun²¹ do canii² jó² jajmaa¹a 'uun²¹, joongɨ jajngaa'¹³i 'in joo'saa'²¹ do joongɨ tyaa¹ cwiin'¹³in. Pe jna nigoo²¹²oo 'e cwoo²oo juncwii²¹ tya' tsá² joon jna cwóo³oo coon²¹ juncwii²¹ tya'a 'e tyʉ́² 'áa¹mo. ");
INSERT INTO chqNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","La 'in tsá² tɨ́ɨ²i tyʉ́² 'aa¹i joo'saa'²¹ la joon jon jna tɨ́ɨ²moo tyʉ́² 'aa²na tsá². 'In tsá² 'in tɨ́ɨ²i tyʉ́² 'aa¹i joo'saa'²¹ cwoo¹o juncwii²¹ tya'a 'wii²¹² tya' joo'saa'²¹ 'áa¹i. ");
INSERT INTO chqNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Pe 'in ní² joo'saa'²¹ 'e 'lee'¹³mo jo jmoo¹o la joon tsʉ mo níi²in jó¹ jaain²¹ 'yiia'¹ lobo joon gatíuu²mo joo'saa'²¹ 'aa¹i, gacwiin¹o tsʉ jo 'née²e 'in joo'saa'²¹ do tsʉ jon' joo'saa'²¹ tya'a. Joon 'in 'yiia'¹ lobo do gasan'²mo 'in joo'saa'²¹ do joon 'in catyaai² do gaxé¹mo. ");
INSERT INTO chqNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","'In tsañʉʉ'¹ do gacwiin¹o tsʉ jmoo¹o to² 'lee'¹³mo jo 'ee cwáain¹ tya'a 'in joo'saa'²¹ do. ");
INSERT INTO chqNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","’Jna‑a lɨ́ɨ¹na tsá² 'in tɨ́ɨ²i tyʉ́² 'aa¹i joo'saa'²¹. La cwii¹in Ñʉ'³ʉʉ jna la joon jon cwii¹moo. La joon jon cwii¹moo tsá² tyiia 'in jai'² lɨ́ɨ²i jna 'in lɨ́ɨ¹i lawa joo'saa'²¹ tyiia. Joon 'ido cwii¹mo jna jon. Joon cwó³oo juncwii²¹ tyiia 'wii²¹² tya' 'in joo'saa'²¹ do. ");
INSERT INTO chqNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Joon 'aa²mogɨɨ joo'saa'²¹ xeei'²¹ 'in taa²i tsi 'yá² lɨ xiia' 'in jon' taai² tsi 'yá² lo, 'ná¹ nitee²oo jon. Joon ijmáa¹a nʉʉ'¹³o júu³ tyiia joon jilee'²¹mo tsataai² coon²¹ 'yá² tya'a joon jaan²¹mo 'in 'aa¹i 'ii. ");
INSERT INTO chqNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’'Nee¹mo Ñʉ'³ʉʉ jna tsʉ cwóo³oo juncwii²¹ tyiia 'wii²¹² tya' tsá² joon iñii¹moo tún¹. ");
INSERT INTO chqNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ce jiin'¹³ jaain²¹ jo 'in jnga'²i jna pe 'ñiia'oo cwó³oo juncwii²¹ tyiia tsʉ jiin'¹³ la joon 'iin²¹²na. 'E tɨ́ɨ²moo cwó³oo joon coon'¹³ la joon iñii¹moo tún¹. Tsʉ 'ii'²¹ joon nijmaa¹a Nʉ'³ʉʉ ―jin'² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Joon mo ganúu²un tsá² Israel 'e júu³ lo joon gacoon²¹gɨ tún²‑un gaxeei¹ yaai. ");
INSERT INTO chqNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Joon fúui¹ tsá² jee²¹² 'ii do gajin'²in: ―¿'Ee lɨ' 'e unjíi²i' júu³ tya' 'in tsañʉʉ'¹ no tsʉ 'in 'lɨɨ'³mo 'in yuui² alma tya' 'ino joongɨ yʉ caa²¹²mo 'ino? ");
INSERT INTO chqNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Pe 'inlɨ́ɨ¹³gɨ gajin'²in: ―Wa'a 'yuui² 'in 'lɨɨi'² alma tya' tsá² jo lí² faa'²¹a tsá² la no. Jo lí² cwó¹o espíritu gó² unni² tya' jaain²¹ tsañʉʉ'¹ 'in tiui². ");
INSERT INTO chqNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ningóo¹o jiin²¹ cwíi² joon gatɨ́² jmɨɨ²¹² 'e unjmuu²¹²i tsá² Israel cwo'¹ fee'¹ si'² fu Jerusalén tɨɨ² la joon nigasi'² 'e unjmuu²¹²i tsá² la coon²¹ jiin²¹ ca la mo niga'yee²¹i. ");
INSERT INTO chqNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Joon sá² coon²¹ ni'nʉ́¹ fee'¹ tya' cwo'¹ do 'e sii²¹i Salomón joon ni'nʉ́¹ joon ngɨ¹ɨ Jesús. ");
INSERT INTO chqNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Joon 'in tsá² seein²¹ Israel do gajmaa¹a coon²¹ lɨɨ²¹ ce cu'² jiin¹ lɨ siin'¹²in Jesús joon gajin'²in sɨɨ'²¹ɨ 'ido: ―¿Lɨɨ ca 'e cwo'²'o jna'a 'e la né²e'e 'iin 'nʉ? Wana 'nʉ Cristo sii'¹³ jna' coonti júu³ coon²¹ tsáa¹. ");
INSERT INTO chqNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesús gajin'²in: ―Nifuu²¹² jna 'naa' pe 'naa' jo jo'¹ lɨ́ɨ²naa' jna. Jilaa'²¹ 'e jmóo³oo to² tyʉ'² Ñʉ'³oo 'e ni'e'²e 'naa' 'e Cristo jna. ");
INSERT INTO chqNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Pe 'naa' jo jo'¹ lɨ́ɨ²naa' tsʉ jo lɨ́ɨ¹naa' joo'saa'²¹ tyiia jiin'¹³ la lɨ 'e nigafuu²¹²uu 'naa' la mo jée¹. ");
INSERT INTO chqNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Tsʉ joo'saa'²¹ tyiia cwii¹o jmíi¹ tyiia joongɨ cwii¹moo joon 'ii‑gɨ jalíin²mo coon'¹³ jna. ");
INSERT INTO chqNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Joon jna icwó³oo juncwii²¹ tya' 'e taa'²¹ coon²¹ tøø²mo joon jo jmɨɨ²¹² 'iin²gɨ. Joon jiin'¹³ jaain²¹ jo 'iin tyí²in 'ido ja'cwóo³oo. ");
INSERT INTO chqNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ñʉ'³oo nicwoo'¹³i jna joon 'ii‑gɨ 'in feei'¹gɨ la jee²¹² jileei'²¹ joon jiin'¹³ jaain²¹ jo 'in li'² tyí²in 'ido ja'cwoo²¹o. ");
INSERT INTO chqNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Jna‑a coon'¹³ Ñʉ'¹ʉ', jaan²¹mo jna'a lɨ́ɨ¹na'a. ");
INSERT INTO chqNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Joon 'in tyʉ'² to² tsá² Israel do son'²on cuun²¹² la mo 'e tyuu'¹³i Jesús. ");
INSERT INTO chqNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Joon gajin'²in Jesús sɨɨ'²¹ɨ 'ido: ―'Láa²mo 'e tyʉ́² nigajmáa³aa tyani 'naa' coon'¹³ 'ii'²¹ tya' Ñʉ'³ʉʉ ¿noo 'e tyʉ́² lo 'e tyuu'¹³naa' jna cuun²¹²? ");
INSERT INTO chqNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Joon gajin'²in 'in tsá² tyʉ'² to² Israel do: ―Jo tyuu'¹³na'a 'nʉ cuun²¹² cwáain¹ tya' 'e tyʉ́² nigajmaa'¹³'a pe cwáain¹ 'e nigafaa'¹³'a 'laa'²¹ tya' Dios coon'¹³ júu³ tyi'i. Tsʉ 'nʉ‑ʉ jaain²¹ tsañʉʉ'¹ 'in jmaa¹i 'ña'a Dios. ");
INSERT INTO chqNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Joon gajin'² Jesús sɨɨ'²¹ɨ 'in tsá² do: ―Ni jí² ley tyi'naa' 'e faa'²¹a 'e jin'²in Dios: “'Naa' lɨ́ɨ¹naa' dioses jon.” ");
INSERT INTO chqNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Né²o' 'e jin'² jí² tya' Dios joon jo lí² wa' jo røø²¹²na'. Joon Dios gaunsii²¹i jna' 'in 'ii'²¹ júu³ tyʉ́² tya'a, “dioses.” ");
INSERT INTO chqNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Joon wa gatyii¹in Dios jna joongɨ sii¹in jna ni cwoo'¹³ fu juncwii²¹, ¿xiiala lii'¹naa' 'e foo²oo' 'e nifo'³oo júu³ 'laa'²¹ mo gafo'³oo Jóon¹on Dios jna? ");
INSERT INTO chqNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Joon wa jo jmá³aa jilaa'²¹ 'e jmoo¹o Ñʉ'³ʉʉ joon jo 'ná¹ jo'¹ lɨ́ɨ²naa' jna. ");
INSERT INTO chqNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pe wa'a jmá³aa, xʉfiin'¹³ jo jo'¹ líɨ²naa' jna, jo'¹ cwolíin²naa' jilaa'²¹ 'e jmóo³oo 'e coon'¹³ la joon 'e liní²ii' coonti 'e ngɨ¹ɨ Ñʉ'¹ʉ' coon'¹³ jna joongɨ jna ngɨɨ³oo coon'¹³ Ñʉ'¹ʉ'. ");
INSERT INTO chqNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Coongɨ tún¹‑un 'iin²¹²in 'in tyʉ'² to² tsá² Israel do saan'¹i pe Jesús galáa²mo 'ña'a. ");
INSERT INTO chqNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Joon Jesús gangaa'¹³i fu lɨ 'ngoo'¹³ jmɨɨ²¹ sii²¹ Jordán lɨ' lɨ 'yeei'²¹ ñi'¹. Joon joon gajaan¹an lɨ mo ta natyíin¹in Wó³ nisaa¹i tsá² jmɨɨ²¹² ca la jéei¹³. ");
INSERT INTO chqNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Joon fúu¹mo tsá² 'in gangalíin² ngajǿøi² Jesús. Joon jin'² 'in tsá² do cwáain¹ tya' Jesús: ―'E la ja'²mo xʉfiin'¹³ jo gajmaa¹a Wó³ do jiin'¹³ coon²¹ li² milagro pe jilaa'²¹ 'e gajin'²in 'wii²¹² cwáain¹ 'in tsañʉʉ'¹ no 'e nilaja'²mo. ");
INSERT INTO chqNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Joon fúui¹ 'áa¹mo tsá² 'in jo'¹o galɨ́ɨ²i Jesús lɨ taain¹ do. ");
INSERT INTO chqNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Joon née¹i gaai²¹ la 'oo'²¹ ruu'²¹i coon²¹ fuu²¹ lɨ sii²¹ Betania, Lázaro coon'¹³ María coon'¹³ Marta. 'In María do, 'ii 'in nigaxée²i jmɨɨ²¹ jmafuu²¹ tɨɨ² Jesús joon gauntyʉʉn²¹ tɨɨ² Jesús coon'¹³ jnʉtyi²o. La 'ɨɨ²¹² joon galɨtsaa'¹³a Lázaro do. ");
INSERT INTO chqNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Joon gasii¹in 'in gái¹ ruui'²¹ Lázaro do júu³ fu lɨ taain² Jesús, sɨɨ'²¹ɨ 'ido: ―'Áa¹mo jo¹ tsaa'¹³a amigo tyi'i Lázaro. ");
INSERT INTO chqNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Joon mo ganúu²un Jesús 'elo, joon gajin'²in: ―Jo ijúun¹in coon'¹³ 'e jmoowúu¹ do 'e 'íi³in to² tya' 'e 'e'²e tsá² jiin'¹³ 'ii'²¹ tya' Dios Jmii²¹ joon coon'¹³ la joon jon iliñi¹ tsá² 'ii'²¹ tya' Jóon¹on Dios. ");
INSERT INTO chqNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","6","Joon mo ganúu²un Jesús 'e júu³ lo 'e tsaa'¹³ Lázaro gajaan¹o tún² jmɨɨ²¹²gɨ fu lɨ taan¹in xʉfiin'¹³ 'áa¹mo 'iin²¹²in Marta coon'¹³ ruu'²¹i Lázaro. ");
INSERT INTO chqNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Mo ngayuui'¹³ joon gajin'² Jesús sɨɨ'²¹ɨ tsá² 'in ngɨ¹ɨ coon'¹³on: ―Tsaa²¹a' tún¹ fu Judea. ");
INSERT INTO chqNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Joon gajin'² 'in ngɨ¹ɨ coon'¹³on do: ―Tɨfo'² tyii'i, ¿tɨ coon²¹gɨ tún¹ 'iin²¹²u'un cwoo'¹³'o? Jo 'áai¹ mo ngó¹ 'e 'iin²¹²in 'in tsá² do jngaa'¹²i 'nʉ coon'¹³ cuun²¹². ");
INSERT INTO chqNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesús do gajin'²in: ―Sá² dyatun¹ hora 'e tɨ 'yiia²¹. Wa 'e ngɨ¹ tsá² mo jmɨɨ²¹² jo tyuin'² tsá² tsʉ sá²‑a 'yiia²¹ tya' juncwii²¹ lo tya' 'e jnée²in jǿø²ø tsá². ");
INSERT INTO chqNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Pe wa ngɨ¹ tsá² mo canʉʉ²¹, tyui'² tsá² tsʉ jo 'yiia²¹ jnée²in. ");
INSERT INTO chqNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Mo ngayuui'¹³ joon gajin'² Jesús sɨɨ'²¹ɨ tsá² tya'a: ―Nicwuu²¹mo amigo tyi' Lázaro. Pe no cun'un ní²ii niunjnaa¹‑tsi. ");
INSERT INTO chqNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Joon gajin'²in 'in tsá² ngɨ́¹ coon'¹³on do: ―Ña'ñʉ'¹ʉ', wana jiin'¹³ 'e nicwuu¹i lí²‑i un'láa²mo 'ña'a. Jo 'ná¹gɨ cwoo'¹³'o. ");
INSERT INTO chqNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Pe Jesús gajin'²in 'e 'øøi'²¹‑tsi júu³ tya'a 'e nijún¹mo Lázaro joon ga'øøi'²¹‑tsi 'in tsá² 'in ngɨ¹ coon'¹³on do 'e faa'²¹a Jesús 'e jiin'¹³ 'e canii² 'e cwuu¹mo 'ido. ");
INSERT INTO chqNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Joongɨ gajin'² Jesús la tí²: ―Nijún¹mo Lázaro. ");
INSERT INTO chqNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Joon jløø'²moo 'e jo nitiin'¹³ taan¹na do tsʉ coon'¹³ la joon 'e tyʉ́²gɨ tyii' tya' 'e ja'²mo lɨ́ɨ²naa'. Pe tsaa²¹a' tsajøø²¹²na'. ");
INSERT INTO chqNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Joon gajin'² Tomás, 'in nisii²¹ jon Gemelo, sɨɨ'²¹ɨ 'in tsá² ngɨ¹ coon'¹³on Jesús catyaai² do: ―Tsaa²¹² jna' jon, joon júun²na' caan²¹mo coon'¹³on. ");
INSERT INTO chqNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Joon mo gatyía¹ Jesús Betania ningó¹o tyʉ́n² jmɨɨ²¹² jiin'¹³ la ni'ái¹ Lázaro. ");
INSERT INTO chqNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Joon tsʉ 'wii'¹³ náa¹ tyan' Jerusalén Betania, tɨ tún² kilómetros tsi ca'no'³o, ");
INSERT INTO chqNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","joon 'áa¹mo fúui¹ tsá² seein²¹ Israel ningalíin² nifee'¹³i Marta coon'¹³ María cwo'¹o 'ido fo'feei'¹ cwáain¹ tya' 'e gajúin¹ ruui'²¹ 'ido. ");
INSERT INTO chqNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Joon mo galiñii¹ Marta 'e ngó¹o jmoo²¹ tye'²mo Jesús joon cwo'ɨ́ɨ¹i Marta nijeen²en ni 'ido. Pe María‑gɨ do gajaan¹o inʉʉ. ");
INSERT INTO chqNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Joon gajin'² Marta sɨɨ'²¹ɨ Jesús: ―Ña'ñʉ'¹ʉ', wa mo'o tyíin¹u'un jo gajúun¹in ruu'²¹na do. ");
INSERT INTO chqNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pe jna ñí³oo 'e cwo'¹o Dios 'nʉ jilaa'²¹ 'e mɨ'³'ɨ. ");
INSERT INTO chqNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Joon gajin'² Jesús sɨɨ'²¹ɨ Marta: ―Injiin'¹in ruui'²¹ 'nʉ tún¹. ");
INSERT INTO chqNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta‑gɨ gajin'²in: ―Jo'¹o, jna ñí³oo 'e injiin'¹o mi tɨ jmɨɨ²¹² lɨ gatséi¹ mo jiin'¹in 'lɨɨ²¹². ");
INSERT INTO chqNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Joon gajin'²in Jesús sɨɨ'²¹ɨ 'ido: ―Jna‑a jon jmáa³aa 'e jiin'¹in tsá² jee²¹² 'lɨɨ²¹², jna‑a cwo'³oo tsá² juncwii²¹ tya'a 'e taa'²¹ coon²¹ tøø²mo. 'In jo'¹ lɨ́ɨ²i jna xʉfiin'¹³ júun²in, ijiin'¹o tún¹. ");
INSERT INTO chqNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Joon jileei'²¹ 'in jiin'¹ 'in jo'¹ lɨ́ɨ²i jna jo júun²in. ¿Tɨ jo'¹ lɨ́ɨ²u 'e júu³ lo? ");
INSERT INTO chqNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Joon gajin'² 'in tsamɨ́² do: ―Ña'ñʉ'¹ʉ', jo'¹o lɨ́ɨ²na 'e 'nʉ‑ʉ Cristo, Jóon¹on Dios Jmii²¹ 'in 'ná¹ jó¹o ni cwoo'¹³ juncwii²¹. ");
INSERT INTO chqNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Joon mo ngayuui'¹³ gajin'² Marta 'e júu³ lo gangaté²e ruu'²¹i María sɨɨ'²¹ɨ 'ido 'uun²¹mo: ―Nicwa'²mo Tɨfo'² tyi' joon gajmaa¹a júu³ tøø'²¹ø 'nʉ. ");
INSERT INTO chqNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Joon mo ganúu²un María 'e júu² do tsifuu garoon¹on gangóo¹o ngafee'¹³i Jesús. ");
INSERT INTO chqNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jo ga'í¹in Jesús tɨ 'i fuu²¹ do pe do‑o tyíin¹in lɨ gafee'²¹i Marta 'ii. ");
INSERT INTO chqNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Joon mo ganí²i 'in tsá² Israel 'in taai² cwo'¹o fo'feei'¹ María 'e garoon¹on 'ido ce tyíi² cwo'ɨ́ɨ¹ɨ 'ido fu caluu joon ngalíin² caluu María lɨ́ɨ²i 'e tsá¹ 'ido fu ni 'aa¹ do 'e ngatyii'¹³i 'ido. ");
INSERT INTO chqNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Joon mo gatyía¹ María lɨ siin'¹³in Jesús, joon gasi'²¹i wojníi¹i tyani Jesús joon jin'²in: ―Ña'ñʉ'¹ʉ', wa mo'o tyíin¹u'un jo gajúin¹ ruu'²¹na do. ");
INSERT INTO chqNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Joon mo ganí² Jesús 'e cɨ'²ɨ María coon'¹³ 'in tsá² Israel 'in ningalíin² coon'¹³ María joon galili'²i Jesús fa'í²‑i 'áai¹ joongɨ gangatyin'²‑tsi. ");
INSERT INTO chqNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Joon gaunngɨɨ¹ɨ: ―¿Xiia lɨ' ga'áa¹naa'? Joon 'ido‑gɨ gajin'²in: ―Ña'ñʉ'¹ʉ', na¹ du' cwojøø²'ø. ");
INSERT INTO chqNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Joon gatyi'²i Jesús. ");
INSERT INTO chqNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Joon gajin'² 'in tsá² Israel do: ―Jǿø²duu' áa¹mo ni 'iin²¹²in ni 'ido. ");
INSERT INTO chqNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Pe 'inlɨ́ɨi¹³ jee²¹² 'in tsá² seein²¹ Israel do gajin'²in: ―In no‑o 'in gacwo¹o unni² 'in tsá² tiui² do, ¿tɨ jo 'ee nilii'¹i jmá¹xʉ tya' 'e jo júuin² Lázaro no? ");
INSERT INTO chqNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Joon Jesús ngatyin'²‑tsi tún¹, joon gangatyéen¹in ni 'aa¹ do. Joon 'e 'aa¹ do nilɨ́² too²¹ xá² joon ni injnɨ¹ coon'¹³ coon²¹ cuun²¹² fee'¹. ");
INSERT INTO chqNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Joon gajin'² Jesús: ―Jan'² cuun²¹² 'e injnɨ¹ 'oo² no. Joon Marta, ruui'²¹ 'in 'lɨɨ²¹² do gajin'²in: ―Ña'ñʉ'¹ʉ', wa jo nijmaa²¹a tsʉ ningóo¹on tyʉ́n² jmɨɨ²¹² jiin'¹³ la júin¹ Lázaro. ");
INSERT INTO chqNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Pe joon gajin'²in Jesús: ―Nifuu²¹²oo 'nʉ wana jo'¹ lɨ́ɨ²u imóo³o'o xiiala 'e tsafee'¹mo Dios. ");
INSERT INTO chqNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Joon gajan'²o cuun²¹² do joon gajǿø²ø Jesús fu yʉ' joon faa'²¹a júu³ tyʉ́², jin'²in: ―Nʉ'³, cwo'³‑oo 'nʉ maa'¹³mo'o tsʉ niganʉ́ʉ²o'o júu³ tyiia. ");
INSERT INTO chqNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Jna ñí³oo 'e nuu²¹o'o júu³ tyiia coon²¹ tøø²mo. Foo'¹³na 'nʉ 'wii²¹² tya' 'e jǿø²ø 'in tsá² no 'e ilitsáai¹‑tsi 'e 'nʉ‑ʉ gasii¹un jna. ");
INSERT INTO chqNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Mo ngayuui'¹³ jin'²in la joon, joon ga'oo¹o tá², tøø'²¹ø Lázaro: ―¡Lázaro, júu¹ fu lo! ");
INSERT INTO chqNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Joon 'in 'lɨɨ²¹² do gacwo'ɨ́ɨ¹o joon 'in paa'²¹ 'mɨ'²ɨ cwoo²¹o coon'¹³ tɨɨ²ɨ joon 'in jnɨ'² 'mɨ'²ɨ tsi níi¹i. Joon gajin'²in Jesús: ―Sii'¹³ cwoo²¹o tɨɨ²ɨ cwotyee'²¹mo. ");
INSERT INTO chqNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Joon fúu¹mo tsá² Israel 'in ningalíin² coon'¹³ María joon ganí² 'e nigajmaa¹a Jesús jo'¹o lɨ́ɨ²i. ");
INSERT INTO chqNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pe 'inlɨ́ɨi¹³ 'in tsá² do ngalíin² nijmaa'¹³a tsá² fariseos júu³ jilaa'²¹ 'e niganii²¹i 'e gajmaa¹a Jesús. ");
INSERT INTO chqNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Joon 'in tsá² fariseos do joongɨ coon'¹³ 'in tyʉ'² to² untsá² do gauncaain²¹ yaai coon'¹³ jileei'²¹ tsacøøi'¹³ joon gajin'²in: ―¿'Ee ijmoo²¹o'? 'In tsanʉʉ'¹ no 'áa¹mo jmoo¹o li² milagro. ");
INSERT INTO chqNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Wana tuu²¹²na' 'ino, jilee'²¹mo jo'¹o ilíin² 'ii. Joon 'in tsá² 'oo¹o to² Roma ijalíin² 'e jafiin²mo cwo'¹ fee'¹ tyi' joongɨ ija'iin²mo jna'. ");
INSERT INTO chqNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Pe jaain²¹ jee²¹² 'ii do 'in sii²¹ Caifás 'in tyʉ'² to² fii²¹² untsá² jiin²¹ joon gajin'²in: ―'Naa' jo ñí²ii' jiin'¹³xʉ, ");
INSERT INTO chqNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","jon'gɨ li'²naa' 'e tyʉ́² tyi‑o' 'e júuin² jaan²¹mo tsañʉʉ'¹ tya' goo²¹o' lagɨ 'e 'iin²in la tøøi² lɨ saan²¹an'. ");
INSERT INTO chqNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","52","Pe Caifás do jo gajin'²in jiin'¹³ 'e 'øøi'²¹‑tsi 'ña'a, Dios gacwo'¹ 'ii 'e ga'øøi'²¹‑tsi 'e faa'²¹a do 'e ijúuin² Jesús 'wii²¹² tya' jileei'²¹ 'in seein²¹ Israel. Jon' ijúuin² 'wii²¹² tya' jiin'¹³ tsá² 'in seein²¹ Israel pe ijúuin² tya' iuncaain²¹ jileei'²¹ jóon¹on Dios 'in née¹i lɨ caain²¹ ni cwoo'¹³ fu juncwii²¹. 'E gacwo'¹o Dios 'ii 'e ga'øøi'²¹‑tsi la do tsʉ 'wii'¹³ tsafeei'¹ tyʉ'² to² fii²¹² untsá² 'ii. ");
INSERT INTO chqNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ca jmɨɨ²¹² joon gasɨ́ɨ²i 'in tsá² 'oo¹o to² do seein²¹ Israel xiiala ijngaa'¹³i Jesús. ");
INSERT INTO chqNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Wii'¹³ joon jo lí² ngɨ¹gɨ Jesús jee²¹² tsá² seein²¹ Israel, joon gacwa'ɨ́ɨ¹o fu lɨ' Judea joon gangóo¹o co' coon²¹ cwoo'¹³ tyʉʉn²¹ fu lɨ sii²¹ Efraín. Joon do‑o gajaan¹an coon'¹³ 'in ngɨ¹ɨ coon'¹³on. ");
INSERT INTO chqNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Joon xʉ 'ná¹gɨ tɨ jmɨɨ²¹² pascua tya' tsá² Israel. Joon fúu¹mo tsá² 'in née¹i 'e fuu²¹ náa¹ la caain²¹ co' Jerusalén ngalíin² fu Jerusalén nʉ'gɨ lagɨ itɨ́² jmɨɨ²¹² pascua 'e tsaruuin'¹³ yaai joon coon'¹³ la joon lɨtyúu¹i. ");
INSERT INTO chqNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","'In tsá² jalíin²in Jerusalén ngɨɨ¹ɨ 'naa'²¹i Jesús joon la 'ɨɨ²¹² taai² inʉʉ cwo'¹ fee'¹ do unngɨɨ¹ɨ ruu'²¹i: ―Xiiala lɨ́ɨ²u, ¿tɨ ijó¹o lɨ tɨ jmɨɨ²¹² lo 'owa jo jó¹ 'ee? ");
INSERT INTO chqNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Joon 'in tsá² fariseos coon'¹³ 'in tyʉ'² to² untsá² nityʉ'²ʉ to² wana 'in niñíi²in xiia' tyíin¹in Jesús joon 'ná¹ cwatyajmaa'¹³ 'ido 'ii júu³ tsʉ joon isaan'¹mo 'ido. ");
INSERT INTO chqNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Jñʉ́ʉ² jmɨɨ²¹²gɨ 'ná¹ tɨ jmɨɨ²¹² pascua gangó¹on Jesús fu Betania lɨ tyíin¹ Lázaro 'in gaunjiin'¹in Jesús jee²¹² 'lɨɨ²¹². ");
INSERT INTO chqNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Joon do‑o gatyaa¹ tyʉ́² 'e dø'²ø tsá² 'e jløø'³i 'e tyíin¹ Jesús jee²¹² 'ii. Marta tyaa¹ 'uunñi² ni mesa la 'ɨɨ²¹² tyíin¹ Lázaro coon'¹³ Jesús gø'²ø. ");
INSERT INTO chqNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","La 'ɨɨ²¹² joon tyei'² María tyiin¹an jmɨɨ²¹ jmafuu²¹ 'éein³ ti coon'²¹ tsa'² litro 'e tyíin¹ 'moo'³ 'áa¹mo. 'E jmɨɨ²¹ jmafuu²¹ 'e sii²¹ nardo do gasóon²on tɨɨ² Jesús joon mo ngayuui'¹³ joon tsifu gasii²¹i coon'¹³ jnʉ́² tyíi¹i. Joon la caain²¹ tsi inʉʉ garǿ¹i jma² tya' 'e jmɨɨ²¹ jmáfuu²¹ do. ");
INSERT INTO chqNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Joon jaain²¹ 'in tsá² tya' Jesús 'in sii²¹ Judas Iscariote, jóon¹on Simón, 'in tɨ li 'nɨ́ɨ¹i Jesús gajin'²in: ");
INSERT INTO chqNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―¿'Ee lɨ' jo ga'nɨɨ²¹² 'e jmɨɨ²¹ jmafuu²¹ do 'e uncoon'¹³ tya' 'in taníi²in tsʉ tyíin¹ la ti 'e jnaa'¹a tsá² jee²¹² coon²¹ jiin²¹? ");
INSERT INTO chqNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Pe Judas do jo gajin'²in wa' 'e jo'¹ 'nee¹i tsá² tañíi²in, 'e gajin'²in la do tsʉ 'uun²¹ 'ii joongɨ tsʉ 'wii'¹³ 'e 'ii‑o náa¹ cwoo²¹o tu'mɨ'² taa'¹³ cuu². Joon 'wo'²o 'e cuu² taa'¹³ tsi. ");
INSERT INTO chqNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Joon gajin'² Jesús sɨɨ'²¹ɨ Judas do: ―Jo jnɨɨ'³ nu'u, tsʉ lawa 'e sóon²i jna mi 'á¹na. ");
INSERT INTO chqNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Coon²¹ tøø²mo seein²¹ tsá² taníi²in jee²¹² 'naa' 'e lí² uncóon¹³oon' pe jna jo coon²¹ tøøi² iseen²¹na jee²¹² 'naa'. ");
INSERT INTO chqNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Joon mo galiñii¹ tsá² Israel 'e tyíin¹ Jesús fuu²¹ Betania joon 'áa²mo fúui¹ ngalíin² ngajøø²¹²i Jesús, jon' wa' jiin'¹³ 'e 'iin²¹²in níi²in Jesús 'e 'iin²¹²in níi²mo jon Lázaro 'in gajmaa¹a Jesús gajiin'¹in jee²¹² 'lɨɨ²¹². ");
INSERT INTO chqNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Joon gasɨ́ɨ¹i 'in tsá² tyʉ'² to² untsá² do røø²¹ 'e jngaa'¹³mo jon Lázaro, ");
INSERT INTO chqNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","tsʉ 'wii²¹² tya' 'ido‑o fúu¹mo tsá² Israel jo'¹o galɨ́ɨ¹i Jesús joon gatuu²mo 'in untsá² do. ");
INSERT INTO chqNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Fúu¹mo 'áai¹ tsá² 'in gangalíin² Jerusalén lɨ tɨ jmɨɨ²¹² pascua. Mo jná² joon mo galiñi¹i 'in tsá² fúui¹ do ityíi¹a Jesús 'e fuu²¹ do, ");
INSERT INTO chqNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","joon ganga'naa'¹a ni moo²¹ joon ga'woo²¹i ngajeen¹in Jesús, joon faa'²¹a tá¹, jin'²i: ―¡'In tyú¹mo Dios! ¡'In cwaa'³mo 'in gajó² cwáain¹ tya' Ña'ñʉ'¹ʉ'! ¡'In cwaa'³mo 'in Rǿøi¹³ tya' tsá² Israel! ");
INSERT INTO chqNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Joon Jesús gatsee'²¹i jaain²¹ bu'³ joon gacwó²o 'ido jiin'¹³ la lɨ́² 'e faa'²¹a ni jí² tya' Dios: ");
INSERT INTO chqNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Jo toon²oon' fo'²‑'oo' tsá² seein²¹ fuu²¹ lɨ sii²¹ Sion. Jǿø²duu' no‑o cwéi¹ Rǿøi¹³ tyii', tyíin¹ jaain²¹ bu'³. ");
INSERT INTO chqNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","La mo 'láa² 'wii²¹² jo 'øøi'²¹‑tsi 'in tsá² ngɨ¹ɨ coon'¹³ Jesús jilaa'²¹ 'e nigalɨ́². Pe mo ngayuui'¹³ gangai'² Jesús fu ñʉ'fú² joongɨ gatɨ'²ɨ‑tsi 'e jilaa'²¹ 'elo 'e toon²¹² ni jí² 'e faa'²¹a cwáain¹ tya' Jesús joon la joon nigajmaa¹a tya' 'ido. ");
INSERT INTO chqNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","'In tsá² 'in nitéen²in coon'¹³ Jesús la mo gatø'²ø Jesús Lázaro 'oo² 'aan¹ joon gaunjiin'¹o jee²¹² 'lɨɨ²¹², 'in tsá² do 'áa¹mo tyaa¹a júu³ cwáain¹ tya' jilaa'²¹ 'e ganí²i. ");
INSERT INTO chqNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Tsʉ 'wii'¹³ 'e júu³ gatyaa¹a 'ido joon ga'woo²¹i 'in tsá² fúui¹ do ngajéen²in Jesús. ");
INSERT INTO chqNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Joon 'in tsá² fariseos sɨ́ɨ¹i la jee²¹² yaai: ―Jǿø²oo', jo jmé¹i tyi' jilaa'²¹ 'elo. Ñíi²duu', jilee'²¹mo tsá² ngalíin² coon'¹³ 'ii. ");
INSERT INTO chqNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Jee²¹² 'in tsá² ngalíin² fu lɨ gatɨ́² jmɨɨ²¹² Jerusalén seein²¹ 'inlɨ́ɨi¹³ 'in nifaa'²¹a jmíi¹ griego. 'E nijalíin² 'e un'goo²¹o Dios. ");
INSERT INTO chqNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","'In tsá² faa'²¹a jmíi¹ griego do gangatyéen¹in co' lɨ siin'¹²in Felipe 'in seein²¹ coon²¹ fuu²¹ lɨ sii²¹ Betsaida náa¹ cwoo'¹³ 'wó² tya' Galilea. 'In tsá² griego do gamɨɨ¹ɨ tyani Lii²¹² do sɨɨ'²¹ɨ 'ido: ―Tsañʉʉ'¹, 'iin²¹²na'a nee²¹²na'a Jesús. ");
INSERT INTO chqNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","'In Lii²¹² do ngajmaa'¹³a júu³ Andrés joon mo ngayuui'¹³ joon ngalíin² mo je wáai² do ngatyaa¹a júu³ coon'¹³ Jesús. ");
INSERT INTO chqNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Joon gajin'²in Jesús: ―'E gatyíi¹a gatɨ́²‑ɨ 'ii'²¹ 'e untyú²i Dios jna, 'in Ruui'²¹ Tsá², mi júun²na. ");
INSERT INTO chqNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","'E la ja'²mo fuu²¹²uu 'naa', wa ca mɨ'² trigo 'e jo jní²i tsá² ni 'wó² joon wa jo júun²mo, joon la mo lɨɨ²¹² ca mɨ'²ɨ. Pe wa najúin¹ 'e ca mɨ'² do joon 'e iyii¹a 'láai²gɨ. ");
INSERT INTO chqNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Jileei'²¹ 'in un'øøi'¹ juncwii²¹ tya'a icaa²mo juncwii²¹ tya'a pe 'in jo tsáai¹‑tsi juncwii²¹ tya'a 'e ni cwoo'¹³ juncwii²¹ lo iun'øø'¹i juncwii²¹ tya' 'e taa'²¹ coon²¹ tøø²mo. ");
INSERT INTO chqNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Wana 'in 'iin²¹²in jmá¹a to² tyʉ'³ʉʉ 'ná²a 'e jo tiui² jna. Joon doñixiia' siin'¹³na joon jon siin'¹²in 'in jmoo¹o to² tyʉ'³ʉʉ. Joon iuntyú¹mo Ñʉ'³ʉʉ 'ii. ");
INSERT INTO chqNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’No no 'áai¹ ni'ɨ¹‑tsii tya' 'e tsangɨɨ¹na ―jin'²in Jesús―. ¿'Ee ifo'³oo? ¿Tɨ lí² fo'³oo: “Ñʉ'³, un'øøi'¹ jna wa'a jo cwotyangɨ́ɨ²na jilaa'²¹ 'e itsangɨ́ɨ²na?” Pe jo lí² fo'³oo la joon tsʉ 'ii'²¹ joon 'yuu²na. Ifo'³oo: ");
INSERT INTO chqNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","“Ñʉ'³, 'ii²i 'wo'²o coon'¹³ 'e la joon un'goo²¹o tsá² 'nʉ” ―jin'² Jesús sɨɨ'²¹ɨ Jmii²¹ tyíin¹ ñʉ'fú². Joon ganuu¹un coon²¹ júu³ jó¹ fu nʉ'fú² 'e nijin'²in: ―Ni'e²moo 'ñii'a joongɨ i'ée¹³moo 'ñii'a tún¹ tya' 'e un'goo²¹o tsá² jna. ");
INSERT INTO chqNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","'Inlɨ́ɨi¹³ 'in tsá² téen²in do jin'²i: ―Cwaain² 'ñá³ 'in niga'óon²on do. 'In lɨ́ɨi¹³gɨ gajin'²in: ―Jaain²¹ ángel gafee'²¹i Jesús. ");
INSERT INTO chqNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Joon gajin'² Jesús sɨɨ'²¹ɨ 'in tsá² do: ―Jon' gafaa'²¹a 'e júu³ lo 'wii²¹² tyiajna, 'e gafaa'²¹a 'wii²¹² tyi'naa'oo'. ");
INSERT INTO chqNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Pe 'e la no‑o gatɨ́³ 'e jmá¹a Dios 'ii'²¹ tya' tsá² taain²¹² ni cwoo'¹³ juncwii²¹. Joon la no i'wó¹mo Dios 'in tyʉ'² to² ni cwoo'¹³ juncwii²¹. ");
INSERT INTO chqNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Joon mi sá¹i tsá² jna tsaa' 'mó² joon ityiin'²¹an jna jileei'²¹ tsá² ―jin'² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Joon coon'¹³ la joon gajmaa¹a 'e i'øøi'²¹‑tsi tsá² xiiala mi júun²in. ");
INSERT INTO chqNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Joon gañii¹i 'in tsá² do: ―Ninʉ́³oo'o lɨ faa'²¹a jí² tya' ley tyii'i 'e Cristo seein²¹ coon²¹ tøø²mo. ¿Xiiala lɨ 'e foo'²¹'o 'e 'ná¹‑a sá¹i tsá² tsaa' 'mó² 'in Ruui'²¹ Tsá² no? ¿'Iin 'in Ruui'²¹ Tsá² no? ");
INSERT INTO chqNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Joon gajin'² Jesús sɨɨ'²¹ɨ 'in tsá² do: ―Joon jee²¹² 'naa' coo²¹gɨ jɨ́² pe coon'²¹ catá²‑a. Ngɨɨ²ɨɨ' la 'ɨɨ²¹² 'e jnée²mogɨɨ' coon'¹³ 'e jɨ́² lo tsʉ joon jó¹ lɨnʉʉ²¹ lɨ ngɨɨ²ɨɨ', tsʉ 'in ngɨ¹ɨ lɨ nʉʉ²¹ jo ñii¹i xiiafu tsáa¹a. ");
INSERT INTO chqNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Jo'¹ cwolíin²naa' 'e jɨ́² lo la 'ɨɨ²¹² 'e 'oo²gɨɨ' tsʉ coon'¹³ la joon ilíin²naa' tsá² tya' 'e jɨ́² lo. Joon mo ngayuui'¹³ gajin'²in 'e júu³ lo, ganga'²mo Jesús, ganga'mée¹³mo 'ña'a tya' 'in tsá² do. ");
INSERT INTO chqNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jesús gajmaa¹a 'láa²mo li² milagro 'e nijǿø²ø 'in tsá² do pe jo jo'¹ lɨ́ɨ²mogɨ, ");
INSERT INTO chqNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","tsʉ 'ná¹gɨ 'e litiin'¹³ jiin'¹³ la lɨ 'e nigataan¹an ni jí² 'in tsá² 'in gacwo¹o júu³ tyʉ́² ca la jéei¹ 'in sii²¹ Isaías: Ña'ñʉ'¹ʉ', ¿'iin 'in jo'¹ nilɨ́ɨi² júu³ tyʉ́² tyi'? ¿'In niga'e'² Ña'ñʉ'¹ʉ' 'ii'²¹ tya'a? ");
INSERT INTO chqNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Tsʉ 'wii'¹³ joon jo lí² jo'¹ lɨ́ɨ²i 'in tsá² do. Joon gataan¹an Isaías ni jí² tya'a: ");
INSERT INTO chqNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Dios 'e gajmaa¹a tiui² 'ido joongɨ gajmaa¹a 'e 'waa'²¹ alma tya' 'ido, tsʉ joon jo cwolijǿø²ø 'ido coon'¹³ unníi¹i joongɨ jo cwo'øøi'²¹‑tsi coon'¹³ alma tya'a, joongɨ jo cwojalíin² fu lɨ siin'¹³na wa 'e un'láa²na. ");
INSERT INTO chqNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaías gajin'²in 'e júu³ lo tsʉ 'e gacɨɨ¹o 'e tyʉ́² tya' Jesús. Joongɨ 'e tya¹ 'ido júu³ 'wii²¹² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Fúu¹mo 'in tsá² Israel jo'¹o lɨ́ɨ²i Jesús pe jo faa'²¹a la joon jee²¹² tsá² tsʉ 'wii'¹³ 'gøø'²¹mo tsá² fariseos. Cagɨ tsacøøi'¹³ seein²¹ Israel jo'¹o lɨ́ɨ²i Jesús. Lɨ' 'goo'²¹o wa gatyii¹in tsá² 'ii fu caluu cwo'¹. ");
INSERT INTO chqNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","'In tsá² do 'iin²¹²in 'e seein²¹ tyʉ́²gɨ coon'¹³ tsá² lagɨ wa 'e iseein²¹ 'ido tyʉ́² coon'¹³ Dios. ");
INSERT INTO chqNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Joon Jesús gafaa'²¹a tá², jin'²in: ―'In jo'¹ lɨ́ɨ²i jna jon' jiin'¹³ jna jo'¹ lɨ́ɨ²i, jo'¹o jon lɨ́ɨ²i Ñʉ'¹ʉ' 'in gasii¹in jna. ");
INSERT INTO chqNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","'In níi²in jna níi²mo jon 'in gasii¹in jna. ");
INSERT INTO chqNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Gagoo²¹²oo ni cwoo'¹³ juncwii²¹ lawa coon²¹ jɨ́² coo²¹ joon jileei'²¹ 'in jai'² lɨ́ɨ²i jna jo ján¹ lɨ 'íi¹i nʉʉ²¹. ");
INSERT INTO chqNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Wana seein²¹ 'inlɨ́ɨi¹³ nuu¹un júu³ tyiia, joon jogɨ unjíi²i, jon' jna jmá³a 'ii'²¹ tya'a tsee'¹³i lɨ 'lɨɨ'³, tsʉ jo gagoo²¹²oo 'e jmáa³aa 'ii'²¹ tya' tsá² 'e tsalíin² lɨ 'lɨɨ'³ 'in taain²¹² ni cwoo'¹³ juncwii²¹. Pe gagoo²¹²oo 'e jmáa³aa 'e tiin'¹³mo tsá². ");
INSERT INTO chqNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","'In jo tsáai¹‑tsi jna joongɨ jo unjíi²i júu³ tyíia ni'oo¹o coon²¹ 'e 'lei'² 'ii lɨ 'lɨɨ'³. 'E júu³ nifo'³oo 'e joon 'e 'lei'² 'ii lɨ 'lɨɨ'³ jmɨɨ²¹² mi 'iin² juncwii²¹. ");
INSERT INTO chqNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Tsʉ jo fo'³oo 'e 'øøi'²¹‑tsii 'ñii'a, Ñʉ'¹ʉ', 'in gasii¹in jna‑a, 'ii gacwo'¹o jna jilaa'²¹ 'e 'ná¹ fuu²¹²uu tsá² joongɨ 'e 'ná¹ 'e'³ee tsá². ");
INSERT INTO chqNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Joon ñi³oo jilaa'²¹ to² tyʉ'² Ñʉ'³ʉʉ cwo'¹o tsá² juncwii²¹ tya'a 'e taa'²¹ coon²¹ tøøi². La joon 'e fo'³oo lo fo'²oo jiin'¹³ la to² tyʉ'² Ñʉ'¹ʉ' jna. ");
INSERT INTO chqNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","'Yiia'¹³ cwoun'ló¹ pascua galiñii¹i Jesús 'e gatɨ́²‑ɨ 'ii'²¹ 'e itiui² tsá² taain²¹² ni cwoo'¹³ juncwii²¹, joon itse'²mo fu lɨ tyíin¹ Jmii²¹i. 'Áa¹mo gali'iin²¹²in tsá² tya'a 'in taain²¹² ni cwoo'¹³ fu juncwii²¹. Joon la no i'é¹mo 'ña'a jiin'¹³ la ti 'e gali'iin²¹²in tsá². ");
INSERT INTO chqNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","4","'In 'lɨɨ'³mo ni'í³i alma tya' Judas Iscariote, jóon¹on Simón. Joon Judas do 'ɨ¹‑tsí 'nɨ́ɨ¹i Jesús. Pe Jesús niñii¹o 'e gajó²o lɨ tyíin¹³in Dios Jmii²¹ joongɨ joon itsee'¹³i tún¹. Joongɨ niñii¹o 'e Jmii²¹ do‑o nigacwo'¹ 'ii to² 'e tyʉ'²o to² jileei'²¹. Tsʉ 'wii'¹³ joon la 'ɨɨ²¹² 'e tyíin¹³in gø'²ø 'í¹ canʉʉ²¹ coon'¹³ tsá² tya'a joon gajmaa¹a siin'¹²i lɨ si'² mesa joon gatyii¹o 'mɨ'² cwaa²¹ 'e tyi'²i. Joon ga'aa'²¹i coon²¹ 'mɨ'² toalla ñuu'²¹i. ");
INSERT INTO chqNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Joon gatyii'²¹a jmɨɨ²¹ tsi coon²¹ 'ú¹ ñí³. Joon ga'láa² 'wii²¹² run'²un tɨɨ² tsá² tya'a, joon gauntyʉʉn²¹o coon'¹³ 'mɨ'² toalla 'e in'aai'¹³ 'ñuu'²¹i. ");
INSERT INTO chqNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Joon mo gatɨ́² irun'²un tɨɨ² Simón Pedro, joon gajin'²in 'ido: ―Ña'ñʉ'¹ʉ', ¿tɨ 'nʉ iruun'¹³'un tɨ́ɨ³ jna? ");
INSERT INTO chqNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Joon gañii¹i Jesús: ―Jo 'øøi'²¹‑'o'o la no 'e jmóo³oo pe cɨɨin²¹xʉ i'øø'²¹mo‑'o'o. ");
INSERT INTO chqNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pe Tʉ́³ dogɨ gajin'²in: ―Jo jmɨɨ²¹² ruun'¹³'un tɨ́ɨ³ jna. Joon gajin'²in Jesús: ―Wa jo ruun'¹³uun tɨ́ɨ¹³'ɨ jo lí² liin²u tsá² tyiia. ");
INSERT INTO chqNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Joon gajin'² Simón Pedro: ―Wana 'e la joon, Ña'ñʉ'¹ʉ', jon' jiin'¹³ tɨ́ɨ³ɨɨ ruun'¹³'un, ruun'¹³o'o cwóo³oo joongɨ mootyíi³ii. ");
INSERT INTO chqNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Pe gajin'²in Jesús sɨɨ²¹ɨ Tʉ́³ do: ―'In ningayuui'¹³ galo'¹o jo lɨ 'ná¹ idyii¹i tya'a jiin'¹³ tɨɨ²o 'ná¹ idyii¹i tsʉ nilo'¹o. Joon nilaa'¹naa' xʉfiin'¹³ jo jilee'²¹naa'. ");
INSERT INTO chqNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Tsʉ niñii¹o Jesús 'iin in'nɨ́¹i 'ii 'wii'¹³ joon jin'²in: “Jo mo laa'¹naa' jilee'²¹naa'.” ");
INSERT INTO chqNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Joon mo ngayuui'¹³ garun'²un tɨɨ² 'ido jileei'²¹ joon gacɨ'¹o sɨɨn'¹³ɨn 'mɨ'² cwaa²¹ do tún¹, joon gacwó²o tún¹ lɨ si'² mesa. Joon gajin'²in sɨɨ'²¹ɨ tsá² tya'a do: ―¿Tɨ 'øøi'²¹‑'oo' 'e nijmá³aa? ");
INSERT INTO chqNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","'Naa' fuu²uu' jna: “Tɨfo'² tyi'.” Joongɨ gasii²ii' jna: “Ña'ñʉ'¹ʉ'.” Joon 'e tɨɨ²¹moo' fuu²uu' jna la joon tsʉ 'ii jna. ");
INSERT INTO chqNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Joon wana jna garuun'¹³uun tɨ́ɨ¹³ɨɨ' joon lɨ́ɨ¹moo Tɨfo'² tyii' joongɨ Ña'ñʉʉ²ʉʉ', la joon jon 'naa' 'ná¹ jon rúun¹³uun' tɨɨ² ruu'²¹naa'. ");
INSERT INTO chqNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Jna‑a ni'e'²ee 'naa' xiiala 'e jmaa²aa' jiin'¹³ la lɨ 'e nigajmá¹ jna. ");
INSERT INTO chqNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","'E la ja'²mo fuu²¹²uu 'naa', ce jiin'¹³ jaain²¹ tsa'leei'¹³ jo fee'¹i la feei'¹ ñifii²¹²i. Ce jiin'¹³ jaain²¹ 'in sɨɨ¹i tsá² wa 'e feei'¹gɨ lagɨ 'in sii¹in 'ii. ");
INSERT INTO chqNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Joon wana 'øøi'²¹‑'oo' 'elo, jløø'³moo' wa' jmoo²oo'. ");
INSERT INTO chqNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Pe jo fo'²oo 'wii²¹² tyii' jilee'²¹naa'. Jna niñi²oo 'iin 'in nityi'³na. 'Ná¹‑a untiin'¹³ la lɨ 'e faa'²¹a ni jí² tyaa'¹³ júu³ tyʉ́² tya' Dios 'e jin'²: “Jaain²¹ 'in gø'² coon'¹³ jna nijmaa¹a 'e gó² tyiajna.” ");
INSERT INTO chqNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Jmoo'¹³oon 'naa' júu³ jéei¹ tsʉ joon mi lí² 'e ja'²mo lɨ́ɨ²naa' 'e jna‑a Cristo jiin'¹³ la lɨ 'e nifuu²¹²uu 'naa'. ");
INSERT INTO chqNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","'E la ja'²mo fuu²¹²uu 'naa', jileei'²¹ 'in 'ii'²¹i 'in gasɨ́ɨ²na, 'ii'²¹mo jon jna. Joon jileei'²¹ 'in 'ii'²¹i jna 'ii'²¹mo jon 'in gasii¹in jna. ");
INSERT INTO chqNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Joon mo ngayuui'¹³ gajin'²in Jesús 'elo joon galɨtyin'²‑tsi 'áa¹mo alma tya'a joon gajin'²in: ―'E la ja'²mo fuu²¹²uu 'naa', jaain²¹² jee²¹² 'naa' i'nɨ́¹mo jna. ");
INSERT INTO chqNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Joon 'in tsá² tya'a do ga'láa² 'wii²¹² jǿø²i ruu'²¹i la jaain²¹ la jaain²¹ jo ñii¹i naai¹ 'in jin'²in Jesús. ");
INSERT INTO chqNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Jaain²¹ jee²¹² tsá² tya'a do 'in 'nee¹i Jesús 'áai¹ tyíin¹in gø'²ø caai¹ lɨ tyíin¹ Jesús. ");
INSERT INTO chqNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Joon Simón Pedro do gajmaa¹a li² tya'a wa'a cwounngɨɨ¹ɨ 'iin 'in 'í¹i Jesús 'e faa'²¹a la do. ");
INSERT INTO chqNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Joon 'in tsá² do 'in 'nee¹i Jesús joon ganityéen¹in tyan'gɨ joon jin'²in: ―Ña'ñʉ'¹ʉ', ¿'Iin 'in 'ee¹u'u? ");
INSERT INTO chqNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Joon gajin'²i Jesús: ―'Oo'³duu coon²¹ 'no'³ 'iñi'¹ tsi 'uunñi², joon 'in cwo'³oo do, 'ii do. Joon mo ngayuui'¹³ gajin'²in la joon, joon ga'oo'²¹o 'no' 'iñi'¹ do tsi 'uunñi² joon gacwo'¹o Judas Iscariote, jóon¹on Simón. ");
INSERT INTO chqNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Joon tsifuu mo gatɨ́ɨ²i Judas 'e 'iñi'¹ do joon ga'í²i 'in 'lɨɨi'³ alma tya'a. Joon gajin'² Jesús sɨɨ'²¹ɨ 'ido: ―'E 'nogɨ jmaa²'a, jmaa²'a jmoono. ");
INSERT INTO chqNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Pe jiin'¹³ jaain²¹ 'in nee¹i gø'²ø ni mesa do jo mo 'øø'²¹mogɨ‑tsi 'e 'wii²¹² 'e gajin'²in 'ido la do. ");
INSERT INTO chqNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Joon tsʉ 'wii'¹³ Judas do 'e 'in 'mo'³o tu'mɨ'² taa'¹³ cuu², 'inlɨ́ɨi¹³ ga'ɨ¹‑tsi 'e Jesús sɨɨ'²¹ɨ 'ido 'e tsalá¹a 'e 'ná² tya' mi tɨ jmɨɨ²¹² sɨxʉ 'e cwo'¹xʉ tsá² taníi² cuu². ");
INSERT INTO chqNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Joon mo ngayuui'¹³ gøø'²¹ø Judas 'e 'no'³ 'iñi'¹ do joon gacwo'ɨ́ɨ¹o tsifu tsʉ canʉʉ²¹. ");
INSERT INTO chqNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Mo ngayuui'¹³ cwo'ɨ́ɨ¹ Judas, joon gajin'² Jesús sɨɨ'²¹ɨ tsá² tya'a: ―La no iní²i tsá² 'e 'ya'²gɨ tya' 'in Ruui'²¹ Tsá². Joon 'wii'¹³o iní²i tsá² 'e 'ya'²gɨ tya' Dios Jmii²¹. ");
INSERT INTO chqNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Joon wana 'in Ruui'²¹ Tsá² do 'é²e 'e 'ya'²gɨ tya' Dios Jmii²¹, joon Dios Jmii²¹ i'é²o jon 'e 'ya'²gɨ tya' Jóon¹on. Joon la jmoono ijmáa¹a. ");
INSERT INTO chqNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Tsaru'¹u', jo taain²¹²gɨɨ coon'¹³ 'naa' 'wóo². 'Naa' i'naa'¹³moo' jna, pe la lɨ 'e gafuu²¹²uu 'in tsá² Israel do la joon fuu²¹²uu 'naa': Jo lí² cwolíin²naa' fu lɨ nii'¹³ jna. ");
INSERT INTO chqNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Icwo'³oo 'naa' 'e júu³ 'múui² lo 'e jmaa²aa': 'e un'nee¹naa' ruu'²¹naa' la jaain²¹ la jaan²¹naa'. La 'nee¹na 'naa' la joon jon 'ná¹ 'e 'nee¹naa' ruu'²¹naa' la jaain²¹ la jaan²¹naa'. ");
INSERT INTO chqNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Sɨ na 'nee¹mo ruu'²¹naa' la jaain²¹ la jaan²¹naa' jilee'²¹mo tsá² seein²¹ ni cwoo'¹³ juncwii²¹ ilili'³o 'e 'naa'oo' lɨ́ɨ¹naa' tsá² tyiia. ");
INSERT INTO chqNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Joon Simón Pedro gaunngɨɨ¹ɨ sɨɨ'²¹ɨ Jesús: ―¿Xiiafu cwoo'²u, Ña'ñʉ'¹ʉ'? Joon gajin'² Jesús: ―Fu lɨ nii'¹³ jna jo lí² cwoo'²u la no coon'¹³ jna pe cɨɨin²¹gɨ ñíi¹³u'un. ");
INSERT INTO chqNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Joon gajin'² Tʉ́³: ―Ña'ñʉ'¹ʉ', ¿'Ee lɨ' jo lí² tsaa²¹a' caain²¹? La no nináa¹ tyʉ́² tyiia 'e júun²na 'wii²¹² tyi'i. ");
INSERT INTO chqNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Joon gajin'² Jesús: ―¿Tɨ jo'¹ nináa¹ tyʉ́² tyi'i 'e júun²mo'o 'wii²¹² tyiia? 'E la ja'²mo fuu²¹²uu 'nʉ, pe joon 'e ifo'²'o 'nɨ¹ naa'¹³ 'e jo cwii¹u jna la nʉ'gɨ i'ó¹o tuitsáa². ");
INSERT INTO chqNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Faa'²¹gɨ Jesús: ―Jo cwotaan²¹²naa' cu'²‑'oo'. Jo jmaa²aa' cuu'¹³‑'oo' coon'¹³ Dios jon'gɨ cuu'¹³‑'oo' coon'¹³ jna jon. ");
INSERT INTO chqNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Fu lɨ tyíin¹ Nʉ'³ʉʉ joo²¹ 'áa¹mo lɨ cwá²a tsá². Wa jo la joon lɨ́² nifuu²¹²oo 'naa'. Joon inii'¹³na nityíi³aa tyʉ́² coon²¹ lɨ ní³ii'. ");
INSERT INTO chqNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Nii'¹³na nityíi³aa tyʉ́² joon mi yuui'¹³ joon yíia³oo tún¹, yatee²ee 'naa', tsaa²¹a' coon'¹³ jna. Joon coon'¹³ la joon ili'yii²¹a' coon'¹³ jna lɨ tyíin¹³na. ");
INSERT INTO chqNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ñí³ii' 'naa' fu lɨ nii'¹³na joongɨ niñii²oo' fu¹ lɨ' lɨ nii'¹³na. ");
INSERT INTO chqNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Joon gajin'² Tomás sɨɨ'²¹ɨ Jesús: ―Ña'ñʉ'¹ʉ', jo ne² jna'a xiia fu cwoo'²'o, ¿xiiala 'e la ne²e'e fu¹ lɨ' lɨ cwoo'²u? ");
INSERT INTO chqNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Joon gajin'² Jesús: ―Jiin'¹³ jna‑a 'e fu¹ do, joongɨ jiin'¹³ jna‑a 'e júu³ jai'², joongɨ jiin'¹³ jna‑a cwó³oo juncwii²¹ tya' tsá². Jiin'¹³ 'wii'¹³ jna‑a 'e lí² tyaliin¹in tsá² lɨ tyíin¹ Ña'ñʉ'¹ʉ' Dios Jmii²¹. ");
INSERT INTO chqNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Joon wana galicwii¹moo' jna joon ilicwii¹moo' joon Ñʉ'³ʉʉ. Ca lano joongɨ lɨ ngóo¹gɨ cwii¹moo' Ñʉ'³ʉʉ joon nijǿø²moo'. ");
INSERT INTO chqNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Joon gajin'² Felipe sɨɨ'²¹ɨ Jesús: ―Ña'ñʉ'¹ʉ', cwoo'¹³du' jna'a 'e nee²¹²na'a Ña'ñʉ'¹ʉ' Dios Jmii²¹, coon'¹³ la joon líin²mo tyii'i. ");
INSERT INTO chqNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Joon Jesús‑gɨ gañii¹i: ―Ningóo¹ 'áai¹ 'e taan²na jee²¹² 'naa' Felipe, ¿tɨ joon jo mo cwii¹mogɨ'ɨ jna? Tsʉ 'in ní² jna níi²mo jon Ña'ñʉ'¹ʉ' Dios Jmii²¹, ¿'ee lɨ'ɨ 'e mɨ²'ɨ 'e 'ee'¹³na 'naa' Ña'ñʉ'¹ʉ' Dios Jmii²¹? ");
INSERT INTO chqNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Tɨ jo jo'¹ lɨ́ɨ²u 'e ngɨɨ¹ɨ Ña'ñʉ'¹ʉ' Dios Jmii²¹ coon'¹³ jna joongɨ jna ngɨ́ɨ³oo coon'¹³ 'ii? Jilaa'²¹ 'e fo'²oo jo fo'²oo 'e 'ɨ¹‑tsii 'ñii'a. Ña'ñʉ'¹ʉ' Dios Jmii²¹ 'in ngɨɨ¹ɨ coon'¹³ jna, 'ii‑o 'in jmoo¹o 'e to² tya'a lo. ");
INSERT INTO chqNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Jo'¹ cwolíin²naa' jna 'e fuu²¹²uu 'naa' 'e jna‑a ngɨɨ²ɨɨ coon'¹³ Ña'ñʉ'ʉ' Dios Jmii²¹ joongɨ 'ii ngɨɨ¹o jon coon'¹³ jna. Joon wa jo jo'¹ lɨ́ɨ²naa' jna 'wii²¹² júu³ tyiia jo'¹o cwolíin²naa' jna 'wii²¹² tya' jilaa'²¹ to² 'e jmóo³oo. ");
INSERT INTO chqNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","'E la ja'²mo fuu²¹²uu 'naa', 'in jo'¹ lɨ́ɨ²i jna ijmá¹o jon la jmóo³oo joongɨ ijmáa¹a 'e fee'¹gɨ lagɨ jna tsʉ nii'¹³moo fu lɨ tyíin¹ Ña'ñʉ'¹ʉ' Dios Jmii²¹. ");
INSERT INTO chqNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Joon jilaa'²¹ 'e mɨ́² 'naa' coon'¹³ 'e la sii²¹ jna, jna ijmáa³oo tyii' tsʉ coon'¹³ la joon 'í¹i Jóon¹on Dios 'ña'a jilaa'²¹ 'e 'ya'²gɨ tya' Jmii²¹. ");
INSERT INTO chqNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Jna‑a ijmáa³aa doñi'ee 'e mɨ́² 'naa' coon'¹³ 'e la sii²¹ jna. ");
INSERT INTO chqNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Sɨno 'naa' 'nee¹moo' jna ijmaa²aa' to² tyʉ'³ʉʉ. ");
INSERT INTO chqNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Joon imɨ́ɨ³ɨɨ tyani Ña'ñʉ'¹ʉ' Dios 'e síi¹in jaain²¹gɨ 'in cwo'¹ 'naa' fo'feei'¹ in sii²¹ Espíritu tya' 'e jai'². Joon 'ii ingɨ́¹ coon'¹³ 'naa' coon²¹ tøøi². ");
INSERT INTO chqNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","'In tsá² taain²¹² ni cwoo'¹³ juncwii²¹, 'in jo cwii¹in Dios, jo lí² 'ii'²¹in tsʉ jo lí² jǿø³i jogɨ lí² licwii¹in. Pe 'naa' nicwii¹moo' tsʉ ngɨɨ¹o coon'¹³ 'naa' joongɨ i'ii²¹mo alma tyii' joon 'e 'yuu²i coon²¹ tøø²mo. ");
INSERT INTO chqNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Jo tuu²na 'naa' lawa xuui²¹² 'nɨ́ɨi², tsʉ yíia³oo itaan²¹²na coon'¹³ 'naa'. ");
INSERT INTO chqNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Cɨɨin²¹gɨxʉ tsá² taan²¹²in ni cwoo'¹³ juncwii²¹ jo níi²gɨ jna pe 'naa' máa¹moo' jna. Joon tsʉ 'wii'¹³ ijiin'¹i jna 'wii'¹³ joon ijiin'¹ 'naa' jon. ");
INSERT INTO chqNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Joon mi tɨ jmɨɨ²¹² joon, joon iliñí³ 'naa' 'e 'yuu²na alma tya' Ñʉ'³oo joon 'naa'gɨɨ' taa²naa' alma tyiajna‑a joon jna‑gɨ 'yuu²na alma tyi'naa'oo'. ");
INSERT INTO chqNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Jileei'²¹ 'in ñi¹i joongɨ 'in ijmáa¹a to² tyʉ'²ʉʉ 'in 'íi¹i yaai 'e ja'²mo 'nee¹i jna. Joongɨ Ñʉ'³ʉʉ ili'nee¹mo jon 'ii, joon jna 'nee¹moo jon. Joon 'íi¹moo jon 'ñii'a 'ii ―jin'² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Joon Judas (jon' Iscariote 'ii) gajin'²in sɨɨ'²¹ɨ Jesús: ―Ña'ñʉ'¹ʉ', ¿'ee lɨ' i'íi¹i 'wo'o jna'a pe jo 'íi¹i 'wo'o tsá² taain²¹² ni cwoo'¹³ juncwii²¹? ");
INSERT INTO chqNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Joon gajin'² Jesús: ―'In 'nee¹i jna unjíi²o 'e fo'²oo joon ili'nee¹mo Ñʉ'³ʉʉ 'ii. Joongɨ Ñʉ'³ʉʉ ijá²oo'o coon'¹³on 'e toon²¹²o'on alma tya'a. ");
INSERT INTO chqNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Joon 'in jo 'nee¹i jna jo unjíi²i 'e fo'²oo. 'E júu³ tyʉ́² 'e nuu²¹ 'naa' jon' 'e tyiajna, 'e tya' Ñʉ'¹o' in gasii¹in jna. ");
INSERT INTO chqNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Fuu²¹²uu 'naa' jilaa'²¹ 'elo la 'ɨɨ²¹² 'e taan¹na coon'¹³ 'naa'. ");
INSERT INTO chqNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Pe Ña'ñʉ'¹ʉ' Dios isíi¹in 'in Espíritu Tyʉ́² tya'a coon'¹³ 'e la sii²¹ jna 'e cwo'³oo 'naa' fo'feei'¹. Joon 'in Espíritu do i'e'² 'naa' jilaa'²¹ joongɨ 'e untii'¹³‑'oo' jilaa'²¹ 'e nifuu²¹²uu 'naa'. ");
INSERT INTO chqNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Coon²¹ 'e tyʉ́² cwóo³oo 'naa' 'e tyʉ́² sɨ'ɨ́ɨ¹‑'oo' la tyʉ́² 'íi¹‑tsii. Joon jo lɨ la lɨ 'e tyʉ́² 'in 'ɨ́ɨ¹‑tsi tsá² taain²¹² ni cwoo'¹³ juncwii²¹. Jo cu'²‑'oo' jogɨ jmaa²aa' 'goo²¹oo'. ");
INSERT INTO chqNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ninʉ́ʉ²oo' 'e nifo'²oo 'e nii'¹³moo joongɨ 'e yíia³oo 'e taan²¹²na coon'¹³ 'naa' tún¹. Joon wana jo'¹ 'nee¹naa' jna ilijløø'³moo' mi liñí²ii' 'e nii'¹³na lɨ tyíiin¹ Ñʉ'¹ʉ', tsʉ 'in feei'¹gɨ 'i lagɨ jna. ");
INSERT INTO chqNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Fuu²¹²uu 'naa' 'elo jéei¹gɨ tsʉ mi lí² joon jo'¹ ilíin²naa'. ");
INSERT INTO chqNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Jo fú³gɨɨ 'láai² 'áai¹ 'naa' tsʉ nijó¹‑o 'in tyʉ'² to² ni cwoo'¹³ juncwii²¹ lo. Joon xʉfiin'¹³ jo to² cwooi¹ tyʉ'² jna ");
INSERT INTO chqNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","la joon 'ná¹ lí² tsʉ coon'¹³ la joon iliñí² tsá² taain²¹² ni cwoo'¹³ juncwii²¹ 'e 'nee¹mo Ñʉ'¹ʉ' joongɨ jmóo³oo jilaa'²¹ to² tyʉ'²ʉ. Téen²naa' jmaa²aa'. Moo'²¹na. ");
INSERT INTO chqNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","'E'²gɨ Jesús tsá² tya'a jin'²in: ―Coon²¹ wuunjøø'³ lɨ́² 'mó² 'ñá'² coon'¹³ jilaa'¹³ cwáa¹ tya'a. Joon seen²¹mo jaain²¹ 'in un'øøi'¹ sa'³ do. Joon jna‑a lɨ́ɨ²na lawa 'mó² 'ña'² wuunjøø'³ joon 'naa' 'in jai'² lɨ́ɨ²i jna lɨ́ɨ¹naa' lawa cwáa¹ do. Joon 'e tyʉ́² seein²¹ 'in jai'² lɨ́ɨ²i Dios lɨ la lɨ 'oofuu²¹ 'in'ɨ́ɨ¹³ tya'a. Joon Ñʉ'³ʉʉ lɨ́ɨ¹i lawa 'in un'øøi'¹ sa'³ do. ");
INSERT INTO chqNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Joon 'in un'øøi'¹ wuunjøø'³ tyʉ'¹o jilaa'²¹ cwáa¹ 'e jo cwoo¹o 'oofuu²¹ pe jɨ'²ɨ to² tya' jilaa'²¹ cwáa¹ 'e cwoo¹o 'oofuu²¹ 'e joon cwoo¹o 'láai²gɨ. La joon jmoo¹o Ñʉ'³ʉʉ, tyuu'¹³i jileei'²¹ 'in jo 'in'ɨ́ɨ¹³ 'oofuu²¹ tya'a. Pe jileei'²¹ 'in 'in'ɨ́ɨ¹³ 'oofuu²¹ tya'a untyúu¹i Dios 'ii wa'a sɨ'ɨ́ɨ¹³ 'láai²gɨ 'oofuu²¹. ");
INSERT INTO chqNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Coon'¹³ júu³ tyiia 'e ga'e'²ee 'naa' nigalityúu¹moo'. ");
INSERT INTO chqNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Joon la sɨseen'¹³ cwáa¹ wuunjøø'³ 'mó² 'ña'², la joon jon 'naa' 'ná¹ seen²¹naa' 'in caan²¹naa' coon'¹³ jna la 'in caan²¹na coon'¹³ 'naa'. Coon²¹ cwáa¹ wuunjøø'³ jo lí² cwoo¹o 'oofuu²¹ tya'a wa jo sɨseen'¹³ 'mó² 'ña'² tya'a, la joon jon 'naa' jo lí² cwoo²oo' 'oofuu²¹ tyii' wa jo seen²¹naa' 'in caan²¹naa' coon'¹³ jna. ");
INSERT INTO chqNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Jna‑a lɨ́ɨ¹na 'mó² 'ña'² do joon 'naa' lɨ́ɨ¹naa' cwáa¹ do. Joon jileei'²¹ 'in ngɨ́¹ sɨcaaain²¹ coon'¹³ jna joongɨ jna sɨcan²¹na coon'¹³ 'ido, 'láai² 'oofuu²¹ 'in'ɨ́ɨ¹³ tya'a. Tsʉ 'naa' jo lí² jmaa²aa' jiin'¹³xʉ wa'a jo uncoon'¹³ jna 'naa'. ");
INSERT INTO chqNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Joon jilee'²¹ 'in jo jón² sɨcaain²¹ coon'¹³ jna lɨ́ɨ¹i la lɨ coon²¹ cwáa¹ wuunjøø'³ 'e gapí² joon galityʉʉn²¹ joon tsʉʉ'¹³ʉ tsá² joon dya'² tsá² ni jɨ́² 'e jún¹. ");
INSERT INTO chqNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Joon wana ján²naa' sɨcaan²¹naa' coon'³ jna joon jo tʉʉ²ʉʉ' júu³ tyiia lí²‑i mɨ́²ɨɨ' doñi'ee 'iin²¹²naa' joon cwo'³‑oo 'naa'. ");
INSERT INTO chqNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Mo sɨ'ɨ́ɨ¹³ 'láai² 'oofuu²¹ tyii' un'goo²¹o tsá² Ñʉ'³ʉʉ joon coon'¹³ la joon 'ii¹ 'naa' yaanaa' 'e líin²naa' tsá² tyiia. ");
INSERT INTO chqNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","'Nee¹moo 'naa' la 'nee¹i Ñʉ'¹ʉ' jna, ngɨ́ɨ¹³ɨɨ', jmoo²oo' ce jilaa'²¹ 'e 'iin²¹²na. ");
INSERT INTO chqNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Wa'a jmaa²aa' jilaa'²¹ to² tyʉ'³ʉʉ ngɨ́ɨ¹³ɨɨ', jmoo²oo' 'e li'nee¹moo 'naa'. Tsʉ jmóo³oo jilaa'²¹ to² tyʉ'² Ñʉ'³ʉʉ joon ngɨ́ɨ³ɨɨ, jmóo³oo 'e li'neemo jna. ");
INSERT INTO chqNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Fuu²¹²uu 'naa' la joon 'e lí² jmaa²aa' jløø'³naa' coon'¹³ jna joon jo 'nái¹ 'e jløø'³naa'. ");
INSERT INTO chqNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Joon 'e to² tyʉ'³ʉʉ lɨ la lɨ 'elo: 'nee¹naa' la jaain²¹ la jaan²¹naa' jiin'¹³ la 'nee¹moo 'naa'. ");
INSERT INTO chqNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Joon 'ii¹i tsá² 'ña'a 'e 'nee¹i 'in seein²¹ tyʉ́² coon'¹³ mi júun²in 'wii²¹² tya'o. Jo sá² 'e fee'¹gɨ lijmáa¹a. ");
INSERT INTO chqNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Joon 'naa' lɨ́ɨ¹naa' tsá² seein²¹ tyʉ́² coon'¹³ jna wa jmoo²oo' jilaa'²¹ to² tyʉ'²ʉʉ. ");
INSERT INTO chqNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Jo mo gafuu²¹²uu 'naa' lawa tsa'leei'¹³ tyiia pe gafuu²¹²uu 'naa' lawa tsá² seein²¹ tyʉ́² coon'¹³ jna, tsʉ 'in tsa'leei'¹³ jo ñii¹i 'e jmoo¹o fii²¹²i. Pe gafuu²¹²uu 'naa' tsá² seein²¹ tyʉ́² coon'¹³ jna tsʉ ni'e'²ee 'naa' jilaa'²¹ 'e gasɨɨ'²¹ɨ Ñʉ'³ʉʉ jna. ");
INSERT INTO chqNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Jo gatyii'¹³naa' jna pe jna‑gɨ gatyi'²na 'naa' 'e jmaa²aa' to² tya' Dios joon 'láa²mo 'oofuu²¹ ilisá² tyii'. Joon 'iin²¹²na 'e wóo² taa'²¹ 'e 'oofuu²¹ tyii' do. 'E la joon icwó¹ Ñʉ'¹ʉ' jilaa'²¹ 'e mɨ́¹ɨ tsá² coon'¹³ la sii²¹ jna. ");
INSERT INTO chqNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Joon 'e lo‑o to² tyʉ'³ʉʉ: 'nee¹moo' la jaain²¹ la jaan²¹naa'. ");
INSERT INTO chqNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Faa'²¹gɨ Jesús: ―Wa 'ee'¹mo 'in tsá² 'in tɨ́²‑tsi jilaa'²¹ 'e sá² juncwii²¹ 'naa', cwoliñí²ii' 'e gali'ee'²mo 'ido jna nifu. ");
INSERT INTO chqNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Joon wa'a 'iin²¹²naa' jilaa'²¹ 'e sá² juncwii²¹ ili'nee¹mo 'naa' jileei'²¹ tsá² 'in tɨ́²‑tsi 'e sá² juncwii²¹ la 'nee¹mo 'in tsá² tya'a catyaai². Pe jna‑a ga'woo²¹moo 'naa' jee²¹² 'in tsá² do 'in tɨ́²‑tsi 'e sá² juncwii²¹ tsʉ 'wii'¹³ joon 'ee'¹mo 'in tsá² do 'naa' tsʉ jo lɨ́ɨ¹naa' tsá² 'in tɨ́²‑tsi 'e sá² juncwii²¹. ");
INSERT INTO chqNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Untii'¹³‑'oo' 'e júu³ gafuu²¹²uu 'naa': “Jo fee'¹gɨ jiin'¹³ jaain²¹ tsa'leei'¹³ lagɨ fii²¹²i.” Wana ga'ǿø¹i 'in tsá² do jna, la joon jon in'øøi²¹² 'naa' jon. Joon wana gajmaa¹a nʉʉ'¹³ʉn tsá² júu³ tyiia la joon jon ijmá¹a nʉʉ'¹³ʉn júu³ tyii'. ");
INSERT INTO chqNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Joon tsʉ 'wii'¹³ jo cwii¹in 'in tsá² do 'in gasii¹in jna ijmáa¹a jilaa'²¹ 'elo tyi'naa' tsʉ lɨ́ɨ¹naa' tsá² tyiia. ");
INSERT INTO chqNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Joon wa mo'o jo gagoo²¹²oo fuu²¹²uu 'in tsá² do jo 'ee tsaa² sá² tya'a. Pe gagoo²¹²oo joon nano jo tɨ́ɨ²igɨ 'noo'¹o tsaa². ");
INSERT INTO chqNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Joon jileei'²¹ 'in 'ee'¹i jna 'ee'¹mo jon Ñʉ'³ʉʉ. ");
INSERT INTO chqNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Joon wa mo'o jo gajmaa³aa jee²¹² 'ido to² 'e jo gajmaa¹a jiin'¹³ jaain²¹ jo 'ee tsaa² sá² tya'a. Pe ganí²i 'in tsá² do jilaa'²¹ 'e gajmaa³aa. Joon xʉfiin'¹³ ganí²i jilaa'²¹ 'e gajmaa³aa, gali'ee'¹mo 'in tsá² do jna, joon gali'ee'¹mo Ñʉ'³ʉʉ. ");
INSERT INTO chqNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Pe 'ná¹ lí² jilaa'²¹ 'elo 'e coon'¹³ la joon lí² untiin'³in 'e júu³ taa'¹³ ley tya'a 'e jin'²: “Xʉfiin'¹³ jo tɨ́ɨ²i gali'ee'¹mo 'in tsá² do jna.” ");
INSERT INTO chqNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Sɨ́ɨ³na 'naa' 'in Espíritu 'e la Jai'² 'in jai'¹ fu lɨ tyíin¹ Ñʉ'¹ʉ', ijó¹o cwáain¹ tya' Ñʉ'¹ʉ'. Joon mi jó¹ ifaa'²¹o 'wii²¹² tyiia. ");
INSERT INTO chqNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","La joon jon 'naa' isɨɨ²¹²naa' tsá² 'wii²¹² tyiia tsʉ gangɨ́²ɨɨ' coon'¹³ jna ca mo 'wiin²¹². ");
INSERT INTO chqNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Fuu²¹²uu 'naa' jilaa'²¹ 'elo 'e jo tiui¹‑'oo'. ");
INSERT INTO chqNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","I'woo¹mo tsá² 'naa' caluu cwo'¹ sinagogas tya'a joon tɨ lɨ tyíia¹ jmɨɨ²¹² mo lɨ́ɨ²i 'in tsá² 'in jngaa'¹³i 'naa' 'e jmoo¹o to² tyʉ'² Dios. ");
INSERT INTO chqNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Jmóo¹o la joon tsʉ jo mo galicwii¹in Ñʉ'¹ʉ' jon'gɨ galicwii¹in jna. ");
INSERT INTO chqNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Fuu²¹²uu 'naa' jilaa'²¹ 'elo joon mi lí² joon itɨsɨɨi'¹³‑'oo' 'e gafuu²¹²uu 'naa'²¹ ―jin'² Jesús. Faa'²¹gɨ Jesús: ―Jo gafuu²¹²uu 'naa' 'elo mo 'wiin²¹² tsʉ taan²na jee²¹² 'naa'. ");
INSERT INTO chqNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Pe nano nii'¹³moo fu lɨ tyíin¹ 'in gasii¹in jna. Joon jiin'¹³ jaain²¹ jee²¹² 'naa' nigaunngɨɨ¹ɨ xiiafu nii'¹³na. ");
INSERT INTO chqNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Lɨ' jmoo²oo' fa'í³ tsʉ 'wii'¹³ fuu²¹²uu 'naa' 'elo. ");
INSERT INTO chqNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Pe fuu²¹²uu 'naa' la jai': 'e tyʉ́²gɨ tyii' 'e nii'¹³na, tsʉ wa'a jo nii'¹³na jo ijó¹ ingɨ́¹ coon'¹³ 'naa' 'in icwo'¹o 'naa' fo'feei'¹. Pe wa nii'¹³na isɨɨ²na 'ido. ");
INSERT INTO chqNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Joon mi jó¹ 'ido 'in tsá² taain²¹² juncwii²¹ icoon²¹ cwáain¹ 'ña'a 'e jo røø²¹ 'ɨ¹‑tsi cwáain¹ tya' 'e røøi²¹ tsaa², jon'gɨ cwáain¹ tya' xiiala ngɨ́¹ tsá² tyʉ́² tyani Dios, jon'gɨ røø²¹ 'ɨ¹‑tsi cwáain¹ tya' ijmá¹a Dios 'ii'²¹ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Røø²¹i tsaa² tsʉ jo jai'² lɨ́ɨ²i jna. ");
INSERT INTO chqNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Joon iliñi¹ 'e fu¹ coon²¹ tsáa¹ tsʉ nii'¹³na fu lɨ tyíin¹ Ñʉ'¹ʉ'. Joon jo móo¹gɨɨ' jna. ");
INSERT INTO chqNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Joon iliñi¹ 'in tsá² do ijmá¹a Dios 'ii'²¹ tya' tsá² tsʉ nigajmaa¹a 'ii'²¹ tya' 'in 'lɨɨi'³ 'in tyʉ'² to² fu juncwii²¹ lo. ");
INSERT INTO chqNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’'Áai¹ 'láai² jilaa'²¹ 'e 'ɨ¹‑tsii fuu²¹²uu 'naa' pe nano 'naa' jo lii'¹ii' 'ii'¹³naa'. ");
INSERT INTO chqNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Pe mi jó¹ 'in Espíritu 'e la Jai'², 'ii 'in 'e'²e 'naa' jilaa'²¹ 'e la jai'², tsʉ jo ifaa'²¹a 'in Espíritu do cwáain¹ tya' 'ña'a. Ifaa'²¹o jiin'¹³ jilaa'²¹ 'e ninúu²un, joon isɨɨ'²¹ɨ 'naa' jilaa'²¹ 'e 'ná¹ lí². ");
INSERT INTO chqNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Iuntyúu¹i jna tsʉ i'e'²e 'naa' júu³ tyiia. ");
INSERT INTO chqNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Joon jilaa'²¹ júu³ tya' Ñʉ'¹ʉ' la joon jon júu³ tyiia. Tsʉ 'wii'¹³ joon lí²‑i fuu²¹²uu 'naa' 'in Espíritu do i'e'²e 'naa' júu³ tyiia. ");
INSERT INTO chqNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’'E coon²¹ nogɨ jó¹ 'e jo máa¹moo' jna pe jée'¹gɨxʉ joon imáa¹moo' jna tún¹ tsʉ nii'¹³na fu lɨ tyíin¹ Ñʉ'¹ʉ' ―jin'² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Joon gaunngɨɨ¹ɨ 'in tsá² tya'a do la jee²¹² 'ii: ―¿'Ee cwoo¹i 'øøi'²¹‑tsi tsá² 'e júu³ no 'e gatyaa¹a 'ido? Gafaa'²¹a jna' 'e coon²¹ nogɨ jó¹ 'e jo nee²¹²mo' pe mi lí² cɨɨin²¹gɨxʉ nee²¹²mo' tún¹. Joon jin'²in 'e lí² la joon tsʉ tse'³mo lɨ tyíin¹ Ñʉ'¹ʉ'. ");
INSERT INTO chqNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿'Ee 'øøi'²¹‑tsi tsá² júu³ tya'a 'e jin'² “coon²¹ nogɨ jó¹”? Jo 'øøi'²¹‑tsi' 'ee faa'²¹a 'ino. ");
INSERT INTO chqNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Joon galiñi²mo‑tsi Jesús 'e 'in tsá² do 'iin²¹²in unngɨɨ¹ɨ tsʉ 'wii'¹³ joon gajin'² Jesús sɨɨ'²¹ɨ 'in tsá² do: ―Jna gafuu²¹²uu 'naa' 'e coon²¹ nogɨ jó¹ 'e jo máa¹moo' jna, joon cɨɨin²¹gɨxʉ imáa¹naa' jna tún¹. ¿Tɨ 'inoo júu³ tyiia 'e sɨ́ɨ¹³ɨɨ' jee²¹² yaanaa'? ");
INSERT INTO chqNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","'E la ja'²mo fuu²¹²uu 'naa', icɨɨ²ɨɨ' 'e joongɨ fa'í³ jmoo²oo' pe 'in tsá² 'in tɨ́²‑tsi 'e sá² juncwii²¹ lo, jløø'³mo 'e seen²¹in. Joon xʉfiin'¹³ fa'í³ jmoo²oo', 'e fa'í³ do jmoo²oo' ilisɨɨ²i 'e seen²¹moo' jløø'³moo'. ");
INSERT INTO chqNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","'E lɨ la lɨ mo lɨseein²¹ yʉʉn²¹. Wúu¹ ni² 'in sáa³a yʉʉn²¹ do tsʉ gatɨ́² 'ii'²¹ ilɨseein²¹ yʉʉn²¹ tya'a. Pe mo galɨseein²¹ yʉʉn²¹ do jo tɨ'²gɨ‑tsi sáa³a 'e wúu¹ ganii²¹i do tsʉ jløø'³mo 'áai¹ 'e galɨseein²¹ jaain²¹ xuui²¹² tsañʉʉ'¹. ");
INSERT INTO chqNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","La joon jon 'naa' jmoo²oo' fa'í³ nano pe la joon góo³oo yajǿø²na 'naa' tún¹ la joon jløøi'³ alma tyii' 'áai¹. Joon jiin'¹³ jaain²¹ jo lí² tyii¹i 'e jløøi'³ yʉ alma tyii'. ");
INSERT INTO chqNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Joon mi tɨ́² jmɨɨ²¹² joon jo 'e iunngɨɨ¹ɨɨ' jna jiin'¹³xʉ. 'E la ja'²mo fuu²¹²uu 'naa': Ñʉ'¹ʉ' icwo'¹o 'naa' jilaa'²¹ 'e mɨ́¹³ɨɨ' coon'¹³ la sii²¹ jna. ");
INSERT INTO chqNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ca nano jo mo gamɨ́²ɨɨ' coon'¹³ la sii²¹ jna jiin'¹³xʉ. Mɨ́³ 'naa' joon i'ii'¹³naa' 'e coon'¹³ la joon ilijløø'³naa' 'áai¹. ");
INSERT INTO chqNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Nifuu²¹²uu 'naa' coon'¹³ júu³ jnɨɨ²i pe tɨ lɨ tɨ́² 'ii'²¹ 'e jo fuu²¹²gɨɨ júu³ jnɨɨ²i pe ifuu²¹²uu 'naa' cwáain¹ tya' Ñʉ'³ʉʉ coon'¹³ júu³ coon²¹ tsáa¹. ");
INSERT INTO chqNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Joon mi tɨ' jmɨɨ²¹² joon imɨ́²ɨɨ' coon'¹³ la sii²¹ jna pe jo 'ná¹gɨ mɨ́ɨ³ɨɨ tyani Ñʉ'¹ʉ' 'wii²¹² 'naa' ");
INSERT INTO chqNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","tsʉ 'ña'a Ñʉ'¹ʉ' 'nee¹mo 'naa'. 'Nee¹mo Ñʉ'¹ʉ' 'naa' tsʉ 'wii'¹³ galɨ'nee¹moo' jna, joon jo'¹o lɨ́ɨ²naa' 'e Dios gasii²¹in jna. ");
INSERT INTO chqNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Gajúu³uu fu lɨ tyíin¹ Ñʉ¹ʉ' joon gagoo²¹²oo 'e juncwii²¹ lo. Joon nano itʉ́³ʉʉ 'e juncwii²¹ lo joon nii'¹³moo tún¹ fu lɨ tyíin¹ Ñʉ'¹ʉ'. ");
INSERT INTO chqNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Joon gajin'²in tsá² tya'a sɨɨ'²¹ɨ Jesús: ―Nano foo'²¹gɨ'ɨ coon'¹³ júu³ coon²¹ tsáa¹ jo foo'²¹gɨ'ɨ coon'¹³ júu³ jnɨɨ²i. ");
INSERT INTO chqNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ni lee²¹e'e cwáain¹ 'e ñi'²i jilaa'²¹ 'e 'ɨ¹‑tsi tsá², joon jo 'ná¹ wa'a unngɨɨ¹ɨ tsá² 'nʉ. Tsʉ 'wii'¹³ joon jo'¹o lɨ́ɨ²na'a 'e gañi'²i lɨ tyíin¹ Dios Jmii²¹. ");
INSERT INTO chqNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Joon Jesús‑gɨ gañii¹i: ―¿Tɨ jo'¹ jo'¹o lɨ́ɨ²naa'? ");
INSERT INTO chqNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ijó¹o 'ii'²¹ joon 'ii'²¹ joon ixee²¹moo', joon ituu²moo' jna. Pe jo 'ñii'a 'e jóon³oon tsʉ sii'¹³mo Ñʉ'¹ʉ' coon'¹³ jna. ");
INSERT INTO chqNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Fuu²¹²uu 'naa' jilaa'²¹ 'elo 'e jo cu'³‑'oo' coon'¹³ jna joon coon'¹³ la joon seen²'naa' tyʉ́². La 'ɨɨ²¹² taan²¹²naa' jee²¹² tsá² 'in tɨ́²‑tsi 'e sá² juncwii²¹ imoo²oo' wúu¹. Pe tá² taain²¹²‑'oo' tsʉ nigalɨ'¹oo 'e sá² juncwii²¹ ―gajin'² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Joon mo ngayuui'¹³ gafaa'²¹a Jesús 'e júu³ no joon gasaa'¹³a níi¹i gajǿø²ø ñʉ'fú² joon gafaa'²¹a júu³ tyʉ́², gajin'²in: ―Ñʉ'³, 'e gatɨ́² 'ii'²¹ tyiia. Untyúu¹³'u yʉʉn²¹ tyi'i, joon coon'¹³ la joon jon iuntyúu¹i 'nʉ. ");
INSERT INTO chqNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","'Nʉ nigacwo'²'o 'ii'²¹ yʉʉn²¹ tyi'i 'e lí² tyʉ'²o to² jileei'²¹ tsá². Joon lí² cwoo¹o coon²¹ juncwii²¹ 'e taa'²¹ coon²¹ tøø²mo jileei'²¹ 'in gacwoo'¹³mo'o 'ido. ");
INSERT INTO chqNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Joon 'e juncwii²¹ do 'e taa'²¹ coon²¹ tøø²mo lɨ la lɨ 'e cwii¹mo 'in tsá² do 'nʉ, 'in jaan²¹mo Dios 'in jai'² joongɨ 'e cwii¹mo jon Jesucristo 'in gasii¹un. ");
INSERT INTO chqNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Jna nigauntyúu¹moo 'nʉ jiin'¹³ la taan²na fu juncwii²¹ lo, joon gajmáa³oo jiin'¹³ la tí² to² gatyʉ'²'ʉ jmáa³aa ");
INSERT INTO chqNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Joon nano, Ñʉ'³, cwo'²'o 'e siin'¹³na tyani'i coon'¹³ jilaa'²¹ 'e 'ya'²gɨ tyiia 'e ga'oo²oo mo tyíin¹na coon'¹³ 'nʉ la nʉ'gɨ garón¹ ni cwoo'¹³ juncwii²¹. ");
INSERT INTO chqNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Niga'e'²ee 'in tsá² 'in ga'woo²u'u jee²¹² 'in tsá² tɨ́²‑tsi 'e sá² juncwii²¹ xiiala lɨ́ɨ²u. Ga'wóo²u'u 'in tsá² do wa'a cwoo'¹³u jna. Tsá² tyi'i 'ido joon gacwoo'¹³u jna 'e liin¹mo tsá² tyiia. Joon 'in tsá² do gajmaa¹a nʉʉ'¹³ʉn júu³ tyi'i. ");
INSERT INTO chqNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Joon galiñii¹o 'e 'nʉ gacwo'²'o jna jilaa'²¹ 'e sá² tyiia. ");
INSERT INTO chqNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Joon gacwo'³oo 'in tsá² do 'e júu³ tyi'i 'e nigacwoo'¹³'o jna, joon ga'ii'¹mo. Gacón²o cwáain¹ 'e gagoo²¹²oo fu lɨ tyíin¹u'un joon ja'²mo lɨ́ɨ²i 'e gasii¹un jna. ");
INSERT INTO chqNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Joon mɨ́³ɨɨ tyani'i 'wii²¹² tya' 'in tsá² do 'in gacwoo'¹³u jna tsʉ tsá² tyi'i 'ido. Jo mɨ́³ɨɨ 'wii²¹² tya' 'in tsá² 'in tɨ́²‑tsi 'e sá² juncwii²¹. ");
INSERT INTO chqNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Jileei'²¹ tsá² tyiia lɨ́ɨ²i jon tsá² tyi'i. La joon jon 'in tsá² tyi'i lɨ́ɨ²i jon tsá² tyiia. Joon 'wii'¹³ jmoo¹o 'ido 'e tyʉ́² faa'²¹ tsá² tyʉ́² tyiia. ");
INSERT INTO chqNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Jo joon²gɨɨ ni cwoo'¹³ juncwii²¹ tsʉ nii'¹³moo iní³ii coon'¹³ 'nʉ pe 'in tsá² tyi'i do iján²a fu juncwii²¹. Ñʉ'³, 'nʉ‑ʉ jaain²¹ 'in tyúi² tyanii²¹i'i, un'øø¹u'u coon'¹³ 'ii'²¹ tyi'i 'in tsá² do 'in gacwoo'¹³u jna 'e coon'¹³ la joon 'e coon²¹ júu³ sɨ́ɨ¹i lagɨ sɨɨ'¹³ɨ'. ");
INSERT INTO chqNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","La 'ɨɨ²¹² taan²na coon'¹³on gaunjíi³na coon'¹³ 'ii'²¹ tyi'i 'in tsá² do 'in gacwoo'¹³u jna joon ga'aa²moo. Joon ce jiin'¹³ jaain²¹ jo nga'iin², ga'iin²mo jiin'¹³ 'in 'lɨɨi'³ do 'in 'ná¹ 'iin² 'e coon'¹³ la joon 'e tiin'¹³ jiin'¹³ la jin'² ni jí² tya' Dios. ");
INSERT INTO chqNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Joon nano 'e nii'¹³na lɨ tyíin¹u'un, pe la 'ɨɨ²¹² taain²gɨɨ fu juncwii²¹ lo fuu²¹²uu 'e júu³ lo 'e lijløø'³mo 'ido 'áai¹ coon'¹³ la jløø'³na. ");
INSERT INTO chqNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Gacwo'²oo 'ido júu³ tyi'i, joon gali'ee'¹mo 'in tsá² tɨ́²‑tsi 'e sá² juncwii²¹ 'ii, tsʉ 'in tsá² tyi'i do jo lɨ́ɨ¹i tsá² 'in tɨ́²‑tsi 'e sá² juncwii²¹ la jo lɨ́ɨ¹na jon. ");
INSERT INTO chqNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Jo mɨ́³ɨɨ tyani'i wa'a 'wóo²u'u 'in tsá² do jee²¹² 'in tsá² tɨ́²‑tsi 'e sá² juncwii²¹, mɨ́³ɨɨ tyani'i wa'a jiin'¹³ 'aa²mo'o 'e jo lii'¹ 'in 'lɨɨi'³ 'ii. ");
INSERT INTO chqNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","La jo tɨ́²‑tsii jilaa'²¹ 'e sá² fu juncwii²¹ la joon jon 'in tsá² do jo tɨ́²‑tsi. ");
INSERT INTO chqNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Untyúu¹mo'o 'in tsá² do coon'¹³ 'e jai'² lɨ́ɨ²i 'e lí² jmáa¹a to² tyi'i. Joon júu³ tyi'i 'e la ja'²mo. ");
INSERT INTO chqNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Joon la gasii¹un jna jee²¹² 'in tsá² 'in tɨ́²gɨ‑tsi 'e sá² juncwii²¹ la joon jon jna sɨ́ɨ³na 'in tsá² no jee²¹² 'in tsá² 'in tɨ́²gɨ‑tsi 'e sá² juncwii²¹. ");
INSERT INTO chqNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Joon 'wii'¹³ 'ii‑o untyúu¹na 'ñii'a 'e coon'¹³ la joon ilityúu¹i 'ido coon'¹³ 'e la jai'². ");
INSERT INTO chqNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Mɨ́³ɨɨ tyani'i 'wii²¹² tya' 'ino joon jon' jiin'¹³ tya' 'ino mɨ́³ɨɨ tyani'i pe mɨ́³ɨɨ jon 'wii²¹² tya' jileei'²¹ 'in jo'¹ lɨ́ɨ²i jna cɨɨin²¹gɨ mi nuu¹un júu³ tya' 'ido. ");
INSERT INTO chqNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Mɨ́³ɨɨ tyani'i 'e coon²¹ júu³ sɨ́ɨ¹i 'ido, 'e seein²¹ caain²¹ coon'¹³ jna', la 'yúi¹ 'nʉ alma tyiia joon la joon jon 'yú¹na alma tyi'i. Mɨ́³ɨɨ tyani'i 'e coon²¹ júu³ sɨ́ɨ¹i 'e coon'¹³ la joon 'in tsá² 'in tɨ́²gɨ‑tsi 'e sá² juncwii²¹ ilijo'² lɨ́ɨ²i 'e gasii¹un jna. ");
INSERT INTO chqNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nigacwo'²oo 'ido 'e 'ii'²¹ tyiia 'e gacwo'²'o jna 'e coon'¹³ la joon coon²¹ júu³ sɨ́ɨ¹i 'ido la sɨɨ'¹³ɨ'. ");
INSERT INTO chqNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Jna 'yú¹na alma tya'a la joon jon 'nʉ‑ʉ 'yú¹'u alma tyiia, la joon jon sɨ́ɨ¹i 'ido coon²¹ júu³ joon 'in tsá² 'in tɨ́²gɨ‑tsi 'e sá² juncwii²¹ icoon²¹on cwáain¹ 'e gasii¹un jna. Joongɨ icoon²¹on cwáain¹ 'e 'nee¹mo'o 'in tsá² tyiia jiin'¹³ la 'nee¹u' jna. ");
INSERT INTO chqNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Ñʉ'³, 'nʉ‑ʉ gacwoo'¹³u 'in tsá² do tyiia joon 'iin²¹²na wa'a taan²in fu lɨ tyíin¹na 'e coon'¹³ la joon lí² ñii¹o 'e 'ya'²gɨ tyiia 'e gacwo'³'o jna. Gacwo'²'o jna 'e 'ya'²gɨ tyiia do tsʉ 'wii'¹³ gali'nee¹mo'o jna la nʉ'gɨ garoon¹on ni cwoo'¹³ juncwii²¹. ");
INSERT INTO chqNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ñʉ'³, røø²¹ 'ii'²¹ jmoo²'o, joon xʉfiin'¹³ 'in tsá² 'in tɨ́²gɨ‑tsi 'e sá² juncwii²¹ jo cwii¹in 'nʉ, pe cwii¹moo 'nʉ. Joon galiñi²i 'in tsá² tyiia do 'e gasii¹un jna. ");
INSERT INTO chqNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Joon gajmáa³aa 'ido júu³ xiiala lɨ́ɨ²u, joon ijmáa³oo jon. Ijmáa³aa 'ido júu³ xiiala 'nee¹u jna 'e coon'¹³ la joon lí² 'nee¹e 'ido tsá² la 'nee¹mo'o jna joon 'ñii'a 'yú¹na alma tya'a. ");
INSERT INTO chqNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Mo ngayuui'¹³ faa'²¹a Jesús 'e júu³ lo ga'wóo²mo Jesús coon'¹³ tsá² tya'a joon ngalíin² lɨ ngoo'¹³ cwo² 'e sii²¹ Cedrón. Joon do‑o ga'í²i Jesús coon'¹³ tsá² tya'a coon²¹ lɨ sɨjna² 'mó² olivos. ");
INSERT INTO chqNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Joon ñii¹i Judas, 'in tɨ li'nɨ́ɨ¹i Jesús jee²¹² 'mó² do tsʉ 'láai² naa'¹³ ngóo¹o Jesús do coon'¹³ tsá² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Joon do‑o gatyíi¹a Judas, jee¹mo coon²¹ poo²¹² 'láa² coon'¹³ 'inlɨ́ɨi¹³ 'ɨɨ'¹³ tya' 'e cwo'¹ fee'¹ do. Jalíin² to² tyʉ'² 'in tyʉ'² to² untsá², joongɨ to² tyʉ'² tsá² fariseos. Joon san'¹an ñí³ joongɨ san'¹an jɨ́² coon'¹³ 'no'³ cɨɨ¹. ");
INSERT INTO chqNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Joon tsʉ 'wii'¹³ ñii¹o Jesús jilaa'²¹ 'e 'ná¹ ilí² gacwo'ɨ́ɨ¹o joon gaunngɨɨ¹ɨ: ―¿'Iin 'naa'²¹naa'? ");
INSERT INTO chqNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Joon gañii¹i 'in tsá² do: ―'Nee'¹³na'a Jesús tsá² Nazaret. Joon gajin'²i Jesús sɨɨ'²¹ɨ 'ido: ―Jna‑a 'ii. Joon Judas, 'in ga'nɨɨ¹i Jesús, siin'¹³mo jee²¹² 'ii do. ");
INSERT INTO chqNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Joon mo gajin'² Jesús: “Jna‑a 'ii”, 'in tsá² fúui¹ do gajiin¹in lɨ' caluu joon gacɨ'²mo ni 'wó². ");
INSERT INTO chqNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Joon gaunngɨɨ¹ɨ Jesús tún¹: ―¿'Iin 'naa'²¹naa'? Joon gajin'² 'in tsá² do: ―'Nee'¹³na'a Jesús tsá² Nazaret. ");
INSERT INTO chqNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Joon Jesús‑gɨ gajin'²in: ―Gafuu²¹²uu 'naa' 'e jna‑a 'ii. Joon wana 'naa'²¹moo' jna cwo²oo' wa'a cwolíin²mo 'in catyaai² no. ");
INSERT INTO chqNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Coon'¹³ la joon gatiin'¹³ júu³ tya' Jesús mo gajin'²in: “Jee²¹² jileei'²¹ 'in gacwoo'¹³i Ñʉ'¹ʉ' jna, jo ga'iin² jiin'¹³ jaain²¹.” ");
INSERT INTO chqNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Joon Simón Pedro do, 'in 'oo¹o coon²¹ ñí³, gasø'¹o joon gatʉʉ¹ʉ loocwóo¹o tsáa¹ tya' jaain²¹ tsa'leei'¹³ tya' 'in tyʉ'² to² untsá². Malco sii²¹ 'in tsa'leei'¹³ do. ");
INSERT INTO chqNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Pe Jesús gatyʉ'² Pedro to² jin'²in: ―Ton'²‑o'o ñí³ tyi'i 'nʉ́¹ tya'¹a, 'Ná² móo³oo jilaa'²¹ wúu¹ icwo'² Ñʉ'¹ʉ' jna. ");
INSERT INTO chqNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Joon 'in 'láa² do coon'¹³ 'in tyʉ'² to² 'ii caan²¹mo coon'¹³ 'in 'ɨɨ'¹³ tya' tsá² Israel do gasan'²mo Jesús, ga'ñʉʉ¹ʉ cwoo¹o 'ido. ");
INSERT INTO chqNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Joon gatø¹o fu tya' Anás, tsajmii²¹ Caifás. Caifás do lɨ́ɨ¹i 'in tyʉ'² to² nifu tya' untsá² jiin²¹ no. ");
INSERT INTO chqNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","La mo jéei¹ 'in Caifás do gajin'²in sɨɨ'²¹ɨ tsá² Israel 'e tyʉ́²gɨ tya'a wa'a júun²in jiin'¹³ jaan²¹mo tsá² tya' goo¹o. ");
INSERT INTO chqNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simón Pedro coon'¹³ jaain²¹gɨ tsá² tya' Jesús ngalíin² caluu Jesús. Joon 'in tyʉ'² to² nifu tya' untsá² galicwii¹mo 'in tsá² jaain²¹ do, tsʉ 'wii'¹³ joon lɨ'¹o ga'íi¹i coon'¹³ Jesús tya'i tyi¹ tya' 'in tyʉ'² to² nifu do. ");
INSERT INTO chqNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pe Tʉ́³ dogɨ gajaan¹an lɨ' caluu' 'ooca'nʉ́¹ do. Pe 'in jaain²¹ do 'in cwii¹in 'in tyʉ'² to² do gangó¹o, ngafee'¹³i 'in tsamɨ́² 'in 'oo¹o 'ooca'nʉ́¹ do joon ga'íi¹mo jon Tʉ́³. ");
INSERT INTO chqNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Joon 'in tsamɨ́² do 'in 'oo¹o 'ooca'nʉ́¹ gajin'²in, sɨɨ'²¹ɨ Tʉ́³ do: ―¿Tɨ jon' 'nʉ‑ʉ jaain²¹ tsá² tya' 'ido? Joon Tʉ́³‑gɨ ganii¹i: ―'Un², 'e wa jon' jna‑a 'ii. ");
INSERT INTO chqNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Joon tsʉ 'wii'¹³ cwii² jmoo¹o 'in tsa'leei'¹³ coon'¹³ 'in 'ɨɨ'¹³ do gajmaa¹a coon²¹ jɨ́² lɨ tyaai'¹ tsá². Joon do‑o siin'¹³in. Do‑o jon siin'¹³in Tʉ́³ untyaa'¹³i 'ña'a. ");
INSERT INTO chqNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Joon ga'láa² 'wii²¹² 'in tyʉ'² to² nifu untsá² unngɨɨ¹ɨ Jesús cwáain¹ tya' 'in tsá² ngɨ¹ coon'¹³on joongɨ cwáain¹ tya' 'e 'ee¹e do. ");
INSERT INTO chqNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Joon Jesús do gajin'²in sɨɨ'²¹ɨ 'ido: ―Nigafuu²¹²uu tyani jileei'²¹ tsá². Ga'e'²ee tsá² inʉʉ cwo'¹ sinagogas joongɨ inʉʉ 'e cwo'¹ fee'¹ lɨ lɨcaain²¹ tsá² Israel, jiin'¹³ coon²¹ jo 'ee gafo'²oo li 'uuin²¹. ");
INSERT INTO chqNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿'Ee lɨ unngɨɨ¹ɨɨ' jna? Cwounngɨɨ¹duu' 'in ganúu²un júu³ tyiia tsʉ ñii¹o 'ido jilaa'²¹ 'e ga'é³ee. ");
INSERT INTO chqNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Mo gajin'² Jesús 'elo jaain²¹ 'ɨɨ'¹³ tya' cwo'¹ fee'¹ do 'in sin'² do 'e gajnáa¹ ni² Jesús, joon gajin'²in: ―¿'Ee lɨ' gañii¹'i 'in tyʉ'² to² nifu untsá² la no? ");
INSERT INTO chqNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Joon Jesús‑gɨ gañii¹i: ―Faa'²¹du' 'e gó² 'e gafo'²oo wa gafo'²oo 'e gó², pe wa gafo'²oo 'e tyʉ́²‑ʉ, ¿'ee lɨ' gajnaa¹'a ní³ii? ");
INSERT INTO chqNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Joon mi yuui'¹³ joon gasii¹in Anás Jesús, sɨ'ñuu¹mo, tyani Caifás 'in tyʉ'² to² nifu tya' untsá². ");
INSERT INTO chqNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","La 'ɨɨ²¹² untyaa'¹i Tʉ́³ 'ña'a gajin'³ 'in tsá² do sɨɨ'²¹ɨ Tʉ́³ tún¹: ―¿Tɨ jon' 'nʉ‑ʉ jaain²¹ tsá² tya' 'ino? Pe jo garǿi¹ Tʉ́³, joon gajin'²in: ―'Un², 'e wa jon' jna‑a 'ii. ");
INSERT INTO chqNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Joon jaain²¹gɨ tsa'leei'¹³ tya' 'in tyʉ'² to² nifu tya' untsá² siin'¹³in do. Ruu'²¹mo 'in gatʉ́² Tʉ́³ loocwóo¹o. Joon 'in tsa'leei'¹³ no gajin'²in sɨɨ'²¹ɨ Tʉ́³: ―¿Tɨ jon'on gamaa²¹²moo 'nʉ jee²¹² 'mó² do coon'¹³ 'ido? ");
INSERT INTO chqNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Joon jo garǿi¹ Tʉ́³ tún¹, joon tsifu joon ga'oo¹o jaain²¹ tuuitsáa². ");
INSERT INTO chqNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Mi yuui'¹³ joon gatyii¹mo 'in tsá² do Jesús tya' Caifás joon gajee¹mo tyani Pilato. 'In Pilato do lɨ́ɨ¹i gobernado to² tyʉ'² Roma. La ngoo¹gɨ gataai² 'wó² ijná² joon jo ga'íi¹i 'in tsá² Israel do tyani gobernado tsʉ jo 'iin²¹²in un'lɨɨ'³i yaai jiin'¹³ la tɨɨsi'². Tsʉ wa mo'o gaun'lɨɨi'³ yaai jo lí² dø'¹ø 'uunñi² tya' pascua. ");
INSERT INTO chqNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Tsʉ 'wii'¹³ joon gacwo'ɨ́ɨ¹ɨ Pilato ngafee'¹³i 'in tsá² do: ―¿'Ee tsaa² cwo²oo' 'ino? ―jin'²in. ");
INSERT INTO chqNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Joon gañii¹i 'in tsá² do jin'²in: ―Wa jo 'lɨɨ'³mo 'ino, jo lí² jee²¹²na'a tyani'i. ");
INSERT INTO chqNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Joon gajin'² Pilato sɨɨ'²¹ɨ 'in tsá² do: ―'Ná¹ jøø²moo' 'ino, cwojmaa²aa' 'ii'²¹ tya' 'ino jiin'¹³ la to² tyʉ'² ley tyi'naa'. Pe 'in tsá² Israel do gajin'²in sɨɨ'²¹ɨ Pilato: ―Pe jna'a, tsá² Israel, jo tɨɨ²¹na'a wa'a jngaa'¹³na'a tsá². ");
INSERT INTO chqNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Coon'¹³ la joon gauntiin'¹³mo júu³ tya' Jesús 'e xiiala ijúun²in. ");
INSERT INTO chqNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Joon ga'í² Pilato inʉʉ palacio tya'a joon gatø'¹ø Jesús joon gaunngɨɨ¹ɨ jin'²in: ―¿Tɨ 'nʉ‑ʉ 'in Rǿøi¹³ tya' tsá² Israel? ");
INSERT INTO chqNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Joon gajin'² Jesús: ―¿Tɨ la 'ɨ¹‑'o'o 'wo'o sɨ 'e gafee'¹i tsá² 'nʉ cwáain¹ tyiia 'ee? ");
INSERT INTO chqNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Joon Pilato‑gɨ gañii¹i: ―¿Tɨ lɨ́ɨ²u 'e tsá² Israel jna? Tsá² goo²'o coon'¹³ 'in tyʉ'² to² untsá² 'in gajajee¹ 'nʉ tyaní³ii. ¿Ee goon²¹ gó² gajmaa²'a tyani 'ido? ");
INSERT INTO chqNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Joon gajin'² Jesús: ―Jo lɨ́ɨ¹na rǿøi¹³ fu juncwii²¹ lo. Wa'a lɨ́ɨ¹na la joon 'e gatiin²mo tsá² tyiia 'e jo gataan'¹³mo tsá² Israel jna. Pe lɨ́ɨ¹na rǿøi¹³ fu lɨ xiia'²¹. ");
INSERT INTO chqNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Joon gajin'² Pilato: ―¿Tɨ joon rǿø¹³mo 'nʉ? Joon Jesús gañii¹i: ―Jna‑a rǿøi¹³ jiin'¹³ la foo'²¹ 'nʉ‑ʉ. Cwáain¹ joon galiseen²¹na, joon cwáain¹ joon goo²¹²oo ni cwoo'¹³ juncwii²¹. Gagoo²¹²oo gafo'²oo júu³ 'e la ja'²mo. Joon jileei'²¹ 'in galinʉʉ'¹³, nuu¹o jilaa'²¹ 'e fo'²oo. ");
INSERT INTO chqNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Joon Pilato‑do gajin'²in: ―¿Noo 'e júu³ do 'e jai'²? Mo ngayuui'¹³ gaunngɨɨ¹ɨ Pilato Jesús 'elo, gacwo'ɨ́ɨ¹i tún¹, ngafee'¹³i 'in tsá² Israel do tún¹. Jin'²in: ―Jo gatsa'³aa ce jiin'¹³ coon²¹ tsaa² tya' 'in tsañʉʉ'¹ no. ");
INSERT INTO chqNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Pe sá² coon²¹ tɨɨsi'² tyii' 'e láa²na jaain²¹ tsá² 'yuui² 'nʉñí³ mi tɨ jmɨɨ²¹² pascua no. ¿Tɨ 'iin²¹²naa' wa'a láa²na tyii' 'in Rǿøi¹³ no tya' tsá² Israel? ");
INSERT INTO chqNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Joon 'in tsá² do ga'oo¹o, jin'²in: ―¡Jo láa²u 'ino! ¡Cwoláa²u'u Barrabás tyii'i! 'In Barrabás do 'uun²¹ 'i. ");
INSERT INTO chqNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Joon 'in Pilato gatyʉ'²ʉ to² 'láa² wa'a tsajée¹i ipóo²i. ");
INSERT INTO chqNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Joon 'in 'láa² do gajmaa¹a coon²¹ corona lɨ jmai'² tóon¹, joon gaton'¹on tyi² Jesús. Joon gatyii'¹³in 'in 'láa² do Jesús coon'¹³ coon²¹ 'mɨ'² nʉʉ'¹. ");
INSERT INTO chqNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Joon gajatyéen¹in joon gaunlee¹i jin'²in: ―¡Wóo²o seein²¹ 'in Rǿøi¹³ tya' tsá² Israel! Joon gajnáa¹a. ");
INSERT INTO chqNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Joon gangó¹o Pilato caluu tún¹ ngafee'¹³i tsá² Israel, jin'²in: ―Tyaan²aan' cwáain¹, tyiin³duu 'in tsañʉʉ'¹ no 'e litsaa²mo‑'oo' 'e jo gatsa'³aa tsaa² tya'a jiin'¹³ coon²¹. ");
INSERT INTO chqNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Joon gacwo'ɨ́ɨ¹ Jesús 'e inʉʉ do 'e 'yʉ' tyíi¹i corona lɨ tóon¹, joon tyi'²i 'mɨ'² nʉʉ'¹ do. Joon gajin'² Pilato sɨɨ'²¹ɨ 'in tsá² Israel do: ―¡Lo‑o siin'¹³in 'in tsañʉʉ'¹ do! ");
INSERT INTO chqNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Joon mo ganii¹in 'in tyʉ'³ to² untsá² joongɨ 'in 'ɨɨ'¹³ do Jesús joon ga'láa² 'wii²¹² 'oo¹o tá², jin'in: ―¡Cwotáan²in tsaa' crúu¹³ 'ino! ¡Cwotáan²in tsaa' crúu¹³ 'ino! Joon gajin'² Pilato sɨɨ'²¹ɨ 'in tsá² do: ―'Naa' jeei¹duu', joon cwotéen¹naa' 'ido tsaa' crúu¹³ yaanaa'. Pe jna‑a cwáain¹ tyiia jo gatsa'³aa tsaa² tya'a jiin'¹³ coon²¹. ");
INSERT INTO chqNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Pe 'in tsá² Israel do gañii¹i: ―Sá² coon²¹ ley tyii'i, joon 'e ley do jin'²in 'e 'ná¹ júun²in 'ido tsʉ gajmee¹mo 'ña'a Jóon¹on Dios. ");
INSERT INTO chqNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Joon mo ganúu²un Pilato 'e júu³ lo 'goo'¹gɨ 'áai¹. ");
INSERT INTO chqNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Joon ga'í²i tún¹ palacio tya'a joon gaunngɨɨ¹ɨ, sɨɨ'²¹ɨ Jesús: ―¿Xiiafu seen²¹u? Pe Jesús do jo gañii¹i jiin'¹³xʉ. ");
INSERT INTO chqNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Joon Pilato gajin'²in: ―¿'Ee lɨ' jo ngɨ́ɨ¹³'ɨ? ¿Tɨ jo ñí²'i 'e tɨɨ²¹moo tyʉ'²ʉʉ to² taan²u tsaa' crúu¹³ sɨ laa²¹²moo 'nʉ 'ee? ");
INSERT INTO chqNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Joon Jesús‑gɨ gañii¹i: ―'Nʉ‑ʉ jo lí² tyʉ'²'ʉ to² jna wa'a jo cwoo'¹³i Dios tyi'i. Tsʉ 'wii'¹³ joon fee'¹gɨ tsaa² tya' 'in tsá² 'in gajajée¹i jna tyani'i lagɨ tsaa² tyi'i. ");
INSERT INTO chqNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Tsifu joon ga'láa² Pilato 'wii²¹² 'noo'¹on xiiala lí² laai²¹ Jesús. Pe 'in tsá² Israel do ga'oo¹o, jin'²in: ―¡Wa'a láa²u 'ino jo tyʉ́² seen²¹u coon'¹³ 'in tyʉ'² to² nifu tyíin¹ Roma! ¡Doñi'iin 'in jmee¹i 'ña'a rǿøi¹³ la jmoo¹o 'ido, faa'²¹a 'laa'²¹ tya' 'in tyʉ'² to² nifu tyíin¹ Roma! ");
INSERT INTO chqNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Joon mo ganúu²un Pilato júu³ tya'a, joon gatyʉ'²ʉ to² 'láa² tsajée¹i Jesús fu lɨ jmoo¹o 'ii'²¹ tya' tsá². Joon do‑o gacwoo¹o Pilato ni 'mosíi¹³ tya'a ijmáa¹a 'ii'. Ni 'wó² do lɨ si'² 'mosíi¹³ tya'a taa'¹³ jmai'² cuun²¹² coo'¹³. Joon do‑o galisii²¹ tsá² faa'²¹a jmíi¹ hebreo, Gabata. ");
INSERT INTO chqNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ningóo¹o itɨ́² tyíia² ñi'¹ cwoun'ló¹ jmɨɨ²¹² pascua. Joon gajin'² Pilato sɨɨ'²¹ɨ 'in tsá² Israel do: ―¡Lo‑o siin'¹³ rǿøi¹³ tyi'naa'! ");
INSERT INTO chqNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Pe 'idogɨ ga'oo¹o tá², jin'²in: ―¡Cwojúun²mo 'ino tsaa' crúu¹³ tya'a! ¡Cwojúun²mo 'ino tsaa' crúu¹³ tya'a! Pilato do gajin'²in: ―¿Tɨ 'iin²¹²naa' wa'a jngaa'¹³na rǿøi¹³ tyii'? Pe 'in tyʉ'² to² untsá² do gajin'²in: ―Jo rǿøi¹³ xeei'gɨ seein²¹ tyijna'a jiin'¹³ 'in tyʉ'² to² nifu tyíin¹ Roma lɨ́ɨ¹i rǿøi¹³ tyijna'a. ");
INSERT INTO chqNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Lɨ gatséi¹ gajoon'¹³ Pilato Jesús tya' 'in tsá² do wa'a téen¹in 'ido tsaa' crúu¹³. Joon 'in tsá² do gajée¹mo Jesús. ");
INSERT INTO chqNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Gacwo'ɨ́ɨ¹ Jesús tyaan¹an crúu¹³ tya'a, tsalíin² coon²¹ lɨ sii²¹ Mootyi² 'Lɨɨ²¹². Joon coon'¹³ jmíi¹ hebreo sii²¹ Gólgota. ");
INSERT INTO chqNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Joon do‑o gateen¹in tsaa' crúu¹³ caan²mo coon'¹³ gái¹gɨ tsañʉʉ'¹, jmai'² jaain²¹ la cataain²¹² caai¹ Jesús. ");
INSERT INTO chqNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Joon gatyʉ'²ʉ Pilato to² 'e toon²¹²on tsá² coon²¹ júu³ yʉʉ'¹³ tyi² crúu¹³ tya' Jesús 'e jin'²: “Jesús tsá² Nazaret, Rǿøi¹³ tya' tsá² Israel.” ");
INSERT INTO chqNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Joon fúu¹mo tsá² Israel gauntsáa¹a 'e júu³ do tsʉ 'e júu³ do lɨ 'nɨ¹ 'ii'¹³ jmíi¹, jmíi¹ hebreo, jmíi¹ griego joongɨ jmíi¹ latín. Joon lɨ tyan' ciudad do lɨ gateen¹in tsá² Jesús tsaa' crúu¹³. ");
INSERT INTO chqNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Tsʉ 'wii'¹³ joon 'in tyʉ'² to² untsá² tya' tsá² Israel gajin'²in sɨɨ'²¹ɨ Pilato: ―Jo tóon¹³'on 'e júu³ do 'e jin'² “Rǿøi¹³ tya' tsá² Israel.” 'E tyʉ́²gɨ wa'a tóon¹³'on: “'Iin 'in gajin'²in 'e lɨ́ɨ¹i Rǿøi¹³ tya' tsá² Israel.” ");
INSERT INTO chqNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pe gañii¹i Pilato: ―Jiin'¹³ la 'e tóon³oon, la joon ilí². ");
INSERT INTO chqNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Joon 'in tyúuin² 'láa² do 'in gateen¹in Jesús tsaa' crúu¹³ gajmaa¹a jmai'²xʉ sɨɨn'³ Jesús la 'oo'²¹ yaai. Joon coon²¹gɨ 'no'³ 'mɨ'² 'e tyʉ́² gasái¹. 'E 'mɨ'² do lɨ́¹ coon²¹ 'no'³ 'mɨ'². ");
INSERT INTO chqNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Joon 'in 'láa² do jin'²in sɨɨ'²¹ɨ la 'oo'²¹ 'ii: ―Jo dyii²¹i' 'e 'mɨ'² no, tsacoo²¹o', joon jøø²¹ø' 'iin 'in lii'¹i. Joon coon'¹³ la joon gauntiin'¹³in 'e júu³ taa'¹³ jí² tya' Dios 'e jin'²: “Gajmaa¹a jmai'²xʉ sɨn'³ɨɨn jee²¹² 'ii, joon tya' sɨn'³ɨɨn dya'¹a mɨ'³.” La joon gajmaa¹a 'in 'láa² do. ");
INSERT INTO chqNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Joon tyan' lɨ si'² crúu¹³ tya' Jesús siin'¹³in sáa³ Jesús coon'¹³ tsamɨ́² ruu'²¹i sáa³a, coon'¹³ María tsamɨ́² tya' Cleofas joongɨ coon'¹³ María Magdelena. ");
INSERT INTO chqNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Joon gajǿø²i Jesús sáa³a joongɨ jaain²¹ tsá² tya'a 'in 'nee¹mo 'áai¹ joon gajin'² Jesús sɨɨ'²¹ɨ sáa³a: ―Saa²¹², jin'²in ―lo‑o siin'¹²in yʉʉn²¹ tyi'i. ");
INSERT INTO chqNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Joon gajin'²in sɨɨ'²¹ɨ tsá² tya'a do: ―Lo‑o siin'¹² in saa²'a. Joon jmɨɨ²¹² joon ga'i'²i 'in tsá² tya' Jesús do María, sáa³ Jesús, inʉʉ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Noo²¹²xʉ mo galiñii¹ Jesús 'e jilaa'²¹ gauntiin'¹³in, 'e untiin'¹³in jiin'¹³ la jin'² ni jí² tya' Dios, Jesús gajin'²in: ―'Unjmɨɨ²na. ");
INSERT INTO chqNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Joon do‑o si'² coon²¹ tsʉʉ² sɨ'oo¹o vino tiin'²¹. Joon 'in tsá² do gauncwii'²¹i coon²¹ lawa joo²¹ 'e sii²¹ esponja coon'¹³ vino do. Joon gatyin'² 'e joo²¹ do nii²¹² sɨɨ² 'mó² sii²¹ hisopo joon gasaa'¹³a 'oo²o Jesús. ");
INSERT INTO chqNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Joon mo ngayuui'¹³ ga'un'¹un Jesús 'e vino tiin'²¹ do joon gajin'²in: ―Jilaa'²¹ 'e la tí²‑i lɨ́². Joon tsifu joon gajgó¹ tyíi¹i joon gajúun²mo. ");
INSERT INTO chqNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Cwoun'ló² jmɨɨ²¹² no tya' pascua, joon tsʉ 'wii'¹³ coon²¹ jmɨɨ²¹² fee'¹ 'áai¹ mi jná² joon jo 'iin²¹²in 'in tsá² Israel wa'a taain²gɨ tsaa' crúu¹³ 'in tsá² do mi tɨ́² jmɨɨ²¹² 'ii'²¹ 'woo'²¹ tsá² ijó¹. Joon ngalíin²mo 'in tsá² do tsamɨ́¹ɨ Pilato wa'a tyʉ'²ʉ to² fiin¹in tsaa'mootɨɨ²ɨ 'in tsá² taan¹in crúu¹ do. Joon jmoono ijúun²in joon lí² xiia¹ cuerpos tya'a. ");
INSERT INTO chqNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Joon 'in 'láa² ngalíin² ngafíin¹in tsaa'mootɨɨ² tya' 'in nifu do joongɨ tya' 'in jaain²¹gɨ do 'in gateen¹in tsaa' crúu¹ coon'¹³ Jesús. ");
INSERT INTO chqNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Pe mo ngalíin² ngatyéen¹in caai²¹ Jesús galili'³i 'e najún¹mo Jesús tsʉ 'wii'¹³ joon jo gafiin¹in tsaa'mootɨɨ² 'ido. ");
INSERT INTO chqNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Lɨ coon'²¹ ga'ya¹a 'in 'láa² do 'mosʉʉn'²¹ caai²¹ Jesús joon tsifu la joon gatuun²¹un jmɨ¹ sɨcaai'¹³ jmɨɨ²¹. ");
INSERT INTO chqNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Joon 'iin 'in jmaa¹a júu³ lo 'e ganí² joon jmoo¹o júu³ jai'². Nii¹o 'e júu³ la ja'²mo faa'²¹a joon jmaa¹a 'naa' júu³ 'e lí² jo'¹o lɨ́ɨ²naa'. ");
INSERT INTO chqNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Joon jilaa'²¹ 'elo galɨ́² wa'a untiin'¹³mo 'e júu³ taa'¹³ ni jí² tya' Dios 'e jin'²: “Ce jiin'¹³ coon²¹ mootáa²i ifíin¹³in.” ");
INSERT INTO chqNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Joon lɨ xiia' jin'²in ni jí² tya' Dios: “Ijǿø²i tsá² 'in niga'yá² tya'a.” ");
INSERT INTO chqNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Mo ngayuui'¹³ gajúun²in Jesús jaain²¹ 'in jai'² lɨ́ɨ²i Jesús sii²¹ José ngamɨɨ¹ɨ Pilato wa'a cwo¹ 'ido cuerpo tya' Jesús. 'In Sé³ no ja'²mo coon²¹ fuu²¹ sii²¹ Arimatea joon 'uun²¹mo ngɨɨ¹ coon'¹³ Jesús tsʉ 'goo'²¹o 'in tsá² tyʉ'² to² tya' Israel. Ga'ii'²¹mo Pilato júu³ tya'a joon gangó¹o Sé³ ngatyiin¹an cuerpo tya' Jesús. ");
INSERT INTO chqNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Joon 'in Nicodemo, 'in ngafee'¹³i Jesús lɨ 'woo¹, gatyíi¹³a tyaan¹an 'oo²¹ jmafuu²¹ mirra coon'¹³ áloes ti dyadya¹ kilo. ");
INSERT INTO chqNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Je wáai² do gapaa'¹³i cuerpo tya' Jesús coon'¹³ 'mɨ'² caai'¹³ 'oo²¹ jmafuu²¹ do jiin'¹³ la tɨɨsi'² tya' tsá² Israel mi 'áa¹³i tsá². ");
INSERT INTO chqNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Tyan' lɨ taan¹in Jesús tsaa' crúu¹³ sá² goon²¹ jee²¹² 'mó². Joon jee²¹² do sá² goon²¹ 'aan¹ tya' 'lɨɨ²¹² tsi too²¹ tsaa' xá². Jo mo ga'aa¹i tsá² tsá² 'e tsi too²¹ do, jiin'¹³ jaain²¹. ");
INSERT INTO chqNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Tsi 'aan¹ do‑o ga'aa¹i cuerpo tya' Jesús tsʉ tyan'an 'áai¹, joongɨ tɨ lɨ 'láa² 'wii²¹² jmɨɨ²¹² 'ii'²¹ 'woo'²¹ tsá² Israel. ");
INSERT INTO chqNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","'Aa²¹ jmɨɨ²¹² láa² 'wii²¹² semóo¹³ ngóo¹o María Magdalena fu lɨ niga'áai¹ Jesús. 'Nʉʉ²¹mogɨ. Joon ganii²¹i 'e jo si'²gɨ 'áan³ tya'a 'e cuun²¹² 'in jnɨ¹ 'oo²¹ 'aan¹ do. ");
INSERT INTO chqNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Joon gangóo¹ cwiin¹in fu lɨ taain²¹ Simón Pedro coon'¹³ 'in jaain²¹gɨ tsá² tya' Jesús 'in 'nee¹i Jesús 'ái¹. Joon gajin'² María do sɨɨ'²¹ɨ 'ido: ―Nigatyii¹mo tsá² Ña'ñʉ'¹ʉ' tsi 'aan¹ joon jo nee³e'e xiiafu ngajée¹³i. ");
INSERT INTO chqNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","4","Joon Tʉ́³ coon'¹³ 'in tsá² tya' Jesús catyaai² ngalíin²in cwiin¹in fu lɨ roon²¹on 'aan¹ do. Joon 'in jaain²¹ do, cwii²¹gɨ cwiin¹in lagɨ Tʉ́³ joon tyíi¹a 'aan¹ do nifu. Joon nga'ee²¹²e 'oo²¹ 'aan¹ jǿø²ø. ");
INSERT INTO chqNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Nii²¹o 'e 'no'³ 'mɨ'² roon¹on do pe jo ga'í²i 'aan¹ do. ");
INSERT INTO chqNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Mi yuui'¹³ joon gatyíi¹a Simón Pedro caluu joon ga'í²o tsi 'aan¹ do. Nii²¹o jon 'e 'no'³ 'mɨ'² roon¹on do. ");
INSERT INTO chqNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Nii²¹o jon 'e 'mɨ'² 'e gapaa'²¹i ni² Jesús jo roon¹on coon'¹³ 'e 'no'³ 'mɨ'² 'e catyiia² pe ijuui'¹³ roon¹on coon'²¹. ");
INSERT INTO chqNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Joon ga'í²i jon 'in tsá² jaain²¹ do 'in gatyíi¹a nifu 'aan¹ do, joon ganii²¹i jilaa'²¹ 'e nigalí² joon jo'¹o galɨ́ɨ²i. ");
INSERT INTO chqNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Joon jo mo ga'øøi'²¹‑tsí jiin'¹³ la nijin'² ni jí² tya' Dios 'e 'ná¹ jiin'¹ Jesús jee²¹² 'lɨɨ²¹². ");
INSERT INTO chqNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Joon gangaa'¹³mo 'in tsá² tya'a do fu tya'a. ");
INSERT INTO chqNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Pe 'in María do gajaan¹an caluu 'oo²¹ 'aan¹, gatyi'²i. La 'ɨɨ²¹² cɨ'²ɨ do ga'íi¹i jǿø²ø tsi 'aan¹ do. ");
INSERT INTO chqNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Joon do‑o gangoo²¹o gái¹ ángeles tyi'²i 'mɨ'² taa²¹. Do‑o née¹i lɨ garoon¹on cuerpo tya' Jesús. Joon jaain²¹ tyíin¹ yʉ' lɨ garoon¹on tyíi¹i joon jaain²¹gɨ tyíin¹ 'ée² tɨɨ² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Joon gaunngɨɨ¹ɨ 'in ángeles do 'ii: ―Tsamɨ́², ¿'ee lɨ cɨɨ'²¹'ɨ? Joon gajin'² 'in tsamɨ́² do: ―Cɨ'²oo tsʉ nigajee¹mo tsá² Ñʉ'³ Fíi³ii joon jo ñí³ii xiiafu ngajée¹i. ");
INSERT INTO chqNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Joon mo gajin'²in 'elo gajiin'¹in níi¹i joon gangóo¹o Jesús siin'¹³in do. Pe jo galili'³i 'e Jesús 'ii. ");
INSERT INTO chqNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Joon gaunngɨɨ¹ɨ Jesús sɨɨ'²¹ɨ 'ido: ―Tsamɨ́², ¿'ee lɨ cɨɨ'²¹'ɨ? ¿'Iin 'naai'²¹ 'nʉ? Joon tsʉ 'wii'¹³ 'ɨ¹‑tsi 'e 'in 'aa¹a 'wó² do fee'¹³i 'ii gajin'²in: ―Tsañʉʉ'¹, owa gajee²mo'o, foo'²'o xiiafu gatʉʉ²¹u'u joon jna‑a nitee²¹²ee. ");
INSERT INTO chqNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Joon gajin'² Jesús sɨɨ'²¹ɨ 'in tsamɨ́² do: ―¡María! Joon María do gajiin¹mo joon gajin'²in sɨɨ'²¹ɨ Jesús coon'¹³ jmíi¹ hebreo: ―¡Raboni! ―'e 'øøi'²¹‑tsi tsá² jin'²in: Tɨfo'² tyi'. ");
INSERT INTO chqNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Joon Jesús‑gɨ gajin'²in: ―Jo 'li²u'u jna, tsʉ jo mo ngóo³gɨɨ lɨ tyíin¹ Ñʉ'³ʉʉ. Pe cwoo'²¹'o, cwosii'¹³'i 'in ruu'²¹na 'e nii'¹³na lɨ tyíin¹ Ñʉ'³ʉʉ 'in lɨ́ɨ¹i Ñʉ²ʉʉ' jon, lɨ tyíin¹ Dios tyiia 'in lɨ́ɨ¹i jon Dios tyii'. ");
INSERT INTO chqNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Joon gangóo¹o María Magdalena do ngajmaa¹a 'in tsá² tya' Jesús júu³ 'e niganí²in Ña'ñʉ'¹ʉ' Jesús joon 'e nigafee'²¹i 'e júu³ do. ");
INSERT INTO chqNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Canʉʉ²¹ jmɨɨ²¹² joon, jmɨɨ²¹² 'láa² 'wii²¹² semóo¹³ 'in caan²¹in tsá² tya' Jesús. Joon tsʉ 'wii'¹³ 'gøø'¹mo tsá² tyʉ'² to² tya' Israel 'in jnɨɨ¹ɨ ca'nʉ́¹. Joon ga'í²i Jesús tún² tsa'² jee²¹² 'ii joon ga'ɨ'¹ɨ júu³ jin'²in: ―Tyʉ́²‑ʉ cwoseen²¹naa'. ");
INSERT INTO chqNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Mo ngayuui'¹³ joon ga'e'²e Jesús tsá² tya'a cwoo²¹o, caa¹i. Joon 'in tsá² tya'a do galijløø'³mo 'áai¹ mo jǿø²i Ña'ñʉ'¹ʉ' Jesús. ");
INSERT INTO chqNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Mo ngayuui'¹³ joon gajin'² Jesús sɨɨ'²¹ɨ 'ido tún¹: ―Tyʉ́²‑ʉ cwoseen²¹naa'. La gasii¹in Ñʉ'¹ʉ' jna la joon jon sɨɨ¹na 'naa'. ");
INSERT INTO chqNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Joon gaxʉʉ¹ʉ ni² 'ido joon gajin'²in: ―Cwo'ii'¹³naa' 'in Espíritu Tyʉ́² tya' Dios Jmii²¹. ");
INSERT INTO chqNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Wa'a 'naa' jmaa²aa' feei'¹‑'oo' tsaa² tya' tsá², sɨ'iin²mo tsaa² tya' 'ido. Pe joon wa'a jo jmaa²aa' feei'¹‑'oo' tsaa² tya' tsá² jo sɨ'iin²in tsaa² tya' 'ido. ");
INSERT INTO chqNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Pe jaain²¹ jee²¹² 'in apóstoles tya' Jesús 'in sii²¹i Tomás jo tyíin¹in mi tyíi¹a Jesús. Suuin²¹² 'in Tomás do. ");
INSERT INTO chqNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Joon 'in tsá² tya'a catyaai² gajin'²in sɨɨ'²¹ɨ 'ii: ―Ganee²¹²moo'o Ña'ñʉ'¹ʉ' Jesús. Pe 'in Tomás do gajin'²in: ―Jo ijai'² lɨ́ɨ²na wa jo nijǿø³øø lɨ ga'yá² cwotóon¹ cwoo¹o, joon ngɨ́ɨ³na unnicwóo³oo lɨ ga'yá² cwotóon¹ do joongɨ ngɨ́ɨ³na cwóo³oo lɨ ga'yá² 'mosʉʉn'²¹ caa¹i. ");
INSERT INTO chqNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","La coon²¹ dyía¹ 'in caain²¹ tsá² tya'a coon²¹ inʉʉ joon taan²mo Tomás coon'¹³on. Joon xʉfiin'¹³ tyʉ́² injnɨ¹ jnɨ'nʉ́¹ ga'í² Jesús joon gajmaa¹a siin'¹³in tún² tsa'² jee²¹² 'ii. Joon ga'ɨ'¹ɨ júu³ jin'²in: ―Tyʉ́²‑ʉ cwoseen²¹naa'. ");
INSERT INTO chqNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Mi yuui'¹³ joon gajin'²in sɨɨ'²¹ɨ Tomás: ―Ngɨɨ²u unnicwoo²'o lo joon jǿø²'ø lɨ ga'yá² cwotóon¹ cwóo³oo. Xá² cwoo²'o joon taan'¹ caa¹na. Jo ngɨɨ²¹gɨ'ɨ 'e jo jai'² lɨ́ɨ²u la joon cwolitsáa¹mo‑'o'o. ");
INSERT INTO chqNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Joon gañii¹i Tomás jin'²in: ―¡Ñʉ'fii³ii, joongɨ Dios tyiia 'nʉ! ");
INSERT INTO chqNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Joon gajin'² Jesús sɨɨ'²¹ɨ 'ido: ―Tomás, jo'¹o galɨ́ɨ²u'u jna tsʉ 'wii'¹³ gañi²mo'o jna. Pe jløø'³mo 'in jai'² lɨ́ɨ²i jna xʉfiin'¹³ jo mo ngaa¹i jna. ");
INSERT INTO chqNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Lɨ́ɨ¹ 'láai²gɨ li² milagro gajmaa¹a Jesús tyani tsá² tya'a 'e jo taa'¹³ 'e jí² lo. ");
INSERT INTO chqNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Pe 'e jí² lo taa'¹³ jilaa'²¹ 'e júu³ lo 'yʉto² 'e lí² jai'² lɨ́ɨ²naa' 'e lɨ́ɨ¹i Jesús Cristo, Jóon¹on Dios. Joon tsʉ 'wii'¹³ jo'¹o lɨ́ɨ²naa' Jesús 'e seen²¹moo' coon²¹ tøø²mo coon'¹³ 'ii'²¹ tya' 'e sii²¹ 'ii. ");
INSERT INTO chqNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Mo ngayuui'¹³ joon gajnéi² Jesús tyani tsá² tya'a coon²¹ fu lɨ tɨ'² tyíia¹ sii²¹ Tiberias. La no galɨ́²: ");
INSERT INTO chqNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Dyái¹ tsá² tya' Jesús taain²¹² caan²¹mo. 'In tsá² do sii²¹ Simón Pedro, coon'¹³ Tomás suuin²¹², coon'¹³ Natanael, joon jaain²¹ tsá² seein²¹ Caná náa¹ lɨ sii²¹ Galilea 'ii. Taain²¹² jon 'in gái¹ jóon¹on Zebedeo coon'¹³ gái¹gɨ tsá² tya' Jesús. ");
INSERT INTO chqNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Joon Simón Pedro do gajin'²in sɨɨ'²¹ɨ 'in catyaai² do: ―Níi³ii, niseen'¹²na joo'²¹ jmɨɨ²¹. Joon gajin'² 'in catyaai² do: ―Jna'a jon tsaa²¹a' coon'¹³ 'nʉ. Joon ngalíin²mo, ngatáa¹i coon²¹ barco. La tøøi² 'woo¹ táa¹i 'naa'¹i joo'²¹ jmɨɨ²¹ pe jo gataan'¹³in jiin'¹³ jaain²¹. ");
INSERT INTO chqNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Mo tɨ lɨ ngó¹o cajná² gajnéi¹ Jesús lɨ tɨ' tyíia¹ do pe jo galicwii¹in tsá² tya'a 'ii. ");
INSERT INTO chqNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Joon gajin'² Jesús sɨɨ'²¹ɨ 'in tsá² taai² barco do: ―'Naa', ¿tɨ jo mo taan'¹³naa'? Joon 'in tsá² do gañii¹i: ―'Un², jiin'¹³ jaain²¹. ");
INSERT INTO chqNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Joon gajin'² Jesús sɨɨ'²¹ɨ 'ido: ―Lɨ' tsáa¹ caai²¹ barco do nii'¹³ii' nʉ́ʉ³, joongɨ iteen'¹³naa' joo'²¹. La joon gajmaa¹a, joon jo lí² saa'¹³a 'e nʉ́ʉ³ tsi barco tsʉ røø¹mo joo'²¹ jmɨɨ²¹ do. ");
INSERT INTO chqNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Joon 'in tsá² tya' Jesús 'in 'nee¹i Jesús 'áai¹ gajin'²in sɨɨ'²¹ɨ Tʉ́³: ―¡Ña'ñʉ'¹ʉ' 'ido! Joon mo ganúu²un Simón Pedro 'e jin'²in: “Ña'ñʉ'¹ʉ' 'ido”, joon gacɨ'²ɨ sɨɨn'¹³ɨn (tsʉ gatyii¹i 'e saan'¹in joo'²¹ jmɨɨ²¹). Joon mo ngayuui'¹³ joon ga'ɨ́ɨ²i tsi jmɨɨ²¹ itsáa¹a lɨ sin'² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Joon 'in tsá² tya'a catyaai² 'in taai² barco do gatyalíin²mo tɨ' jmɨɨ²¹ do jñʉʉ¹ʉ nʉ́ʉ³ do røøi¹ joo'²¹ jmɨɨ²¹. Ga'ii²¹ barco do lɨ 'oo² coon²¹ cíein¹³ metros 'e lɨ' tɨ' do. ");
INSERT INTO chqNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Joon mo cwo'ɨ́ɨ¹ 'e barco do lɨ' cwoo'¹³ tyʉʉn²¹ gajnée¹i coon²¹ jí² lɨ coo²¹ jɨ́² joon ni jɨ́² do untyúun²in jaain²¹ joo'²¹ jmɨɨ²¹. Joon náa¹ 'iñi'¹ caai²¹ do. ");
INSERT INTO chqNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Joon gajin'² Jesús sɨɨ'²¹ɨ 'in tsá² do: ―Cwotyiin²naa' jaain²¹ gái¹gɨ joo'²¹ do 'in la ngayuui'¹³ gataan'¹³naa' do. ");
INSERT INTO chqNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Joon Simón Pedro ga'í² tsi barco do joon gaun'ǿø¹i 'e nʉ́ʉ³ do fu nitsaa². Røø¹mo 'e nʉ́ʉ³ do joo'²¹ jmɨɨ²¹ cøøi'¹³, ti jiin'¹³ coon²¹ cíein¹³ tsi ca'no'³ tsigɨ gaai²¹. Joon xʉfiin'¹³ 'áa¹mo røøi¹ 'e nʉ́ʉ³ do jo ga'gɨɨ²¹ɨ. ");
INSERT INTO chqNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Joon gajin'² Jesús sɨɨ'²¹ɨ 'ido: ―Ñilíin²naa', cøø'³xʉʉ'. Joon jo gatá²‑tsi jiin'¹³ jaain²¹ tsá² tya'a do wa'a unngɨɨ¹ɨ 'iin 'ii tsʉ ñi¹o 'e Ña'nʉ'¹ʉ' Jesús 'ii. ");
INSERT INTO chqNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Joon gajatyéen¹mo Jesús joon gajmaa¹a jmai'²xʉ 'e 'iñi'¹ do jee²¹² 'ii. La joon gajmaa¹a coon'¹³ 'in joo'²¹ jmɨɨ²¹ do. ");
INSERT INTO chqNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ningóo¹ 'nɨ́¹ naa'¹³ 'e gajné¹i Jesús tyani tsá² tya'a mi yuui'¹³ gajiin'¹in jee²¹² 'lɨɨ²¹². ");
INSERT INTO chqNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Mo ngayuui'¹³ gagøø'²¹ø gaunngɨɨ¹ɨ Jesus sɨɨ'²¹ɨ Simón Pedro: ―Simón, jóon¹on Jonás ¿tɨ 'nee¹mo'o jna 'láai²gɨ lagɨ 'in no? Joon Tʉ́³ do gañii¹i: ―Joon, Ña'nʉ'¹ʉ', ñi²o'o 'e 'iin²¹²moo 'nʉ. Jesús‑gɨ gajin'²in: ―Joon, cwo'²'o 'e dø'² joo'saa'²¹ xuui²¹² tyiia. ");
INSERT INTO chqNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Joon gatɨ́² tún² naa'¹³ 'e gaunngɨɨ¹ɨ jin'²in: ―Simón, jóon¹on Jonás, ¿tɨ 'nee¹mo'o jna? Joon gañii¹i Tʉ́³ do: ―Joon, Ña'ñʉ'¹ʉ', ñi²o'o 'e 'iin²¹²moo 'nʉ. Joon gajin'² Jesús: ―Joon, 'aa²mo'o joo'saa'²¹ tyiia. ");
INSERT INTO chqNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Joon gatɨ́² 'nɨ́¹ naa'¹³ 'e gaunngɨɨ¹ɨ Jesús 'ii, jin'²in: ―Simón, jóon¹on Jonás, ¿tɨ 'iin²¹²mo'o jna? Joon Tʉ́³ do gajmaa¹o fa'í³ tsʉ wii'¹³ Jesús nigaunngɨɨ¹ɨ 'nɨ́¹ naa'¹³ wa'a 'iin²¹²in Tʉ́³ 'ii. Joon Tʉ́³ gajin'²in sɨɨ'²¹ɨ Jesús: ―Ña'ñʉ'¹ʉ', ñi²o'o jilaa'²¹. Ñi²o'o 'e 'iin²¹²moo 'nʉ. Joon gajin'² Jesús: ―Joon, cwo'²'o 'e dø'² joo'saa'²¹ tyiia. ");
INSERT INTO chqNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","'E la ja'²mo fuu²¹²uu 'nʉ: mo lɨ́ɨ¹u'u sɨmii'²¹ gatyii'¹'i sɨɨn'²¹'ɨn 'wo'o joon gatyii²'a doñixiia' fu 'iin²¹²u'un. Pe mi lɨ yʉʉ'¹³ 'nʉ inii'¹³'i cwaa¹'a joon tsá² xee'²¹mo ityii'¹³i 'nʉ sɨɨn'²¹'ɨn joon ijee²¹²mo tsá² 'nʉ xiia'lɨ jo 'iin²¹²u'un cwoo'¹³'o. ");
INSERT INTO chqNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Coon'¹³ 'e júu³ joon gajmaa¹a Jesús júu³ xiiala ijúun²in Tʉ́³ joongɨ xiiala iuntyúu¹i Dios. Mo ngayuui'¹³ joon gajin'² Jesús sɨɨ'²¹ɨ Tʉ́³: ―¡'Na¹ coon'¹³ jna! ");
INSERT INTO chqNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Joon gajiin'¹³in Tʉ́³ níi¹i joon gajǿø²i jaai'¹³ caluu 'in tsá² tya' Jesús do 'in 'née¹i Jesús 'ido. 'In tsá² do tyíin¹in caai¹ Jesús mo gagøø'²¹ø lɨ tséi¹ do. Joon gaunngɨɨ¹ɨ Tʉ́³ sɨɨ'²¹ɨ Jesús: “Ña'ñʉ'¹ʉ', ¿'iin 'in i'nɨ́ɨ¹i 'nʉ?” ");
INSERT INTO chqNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Joon mo gangaa²¹i Tʉ́³ 'ii, gajin'²in sɨɨ'²¹ɨ Jesús: ―Ña'ñʉ'¹ʉ', coon'¹³ 'in no, ¿'ee 'ilí²? ");
INSERT INTO chqNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Joon Jesús do gañii¹i: ―Wa' 'iin²¹²na 'e seein²¹ 'ido ca mi gaa'¹³na tún¹, ¿'ee cwáain¹ tyi'nʉ? Jiin'¹³ cwáain¹ tyi'i 'e 'na¹ coon'¹³ jna. ");
INSERT INTO chqNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Joon coon²¹ júu³ 'atsaa²¹ gasɨɨ¹i 'in tsá² jai'² lɨ́ɨ²i Jesús 'e jo ijúun²in 'in tsá² do tsʉ Jesus gajin'²in: “Wa' 'iin²¹²na 'e seein²¹ 'ido ca mi gaa'¹³na tún¹, ¿'ee cwáain¹ tyi'nʉ?” Pe jo gajin'²in 'e jo ijúun²in, gajin'²o: “Wa' 'iin²¹²na 'e seein²¹ 'ido ca mi gaa'¹³na tún¹, ¿'ee cwáain¹ tyi'nʉ?” ");
INSERT INTO chqNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Joon 'in tsá² tya' Jesus no, 'ii 'in nigataan¹an ni jí² 'e júu³ lo. Joon 'ii jin'²in 'e ja'²mo júu³ tya'a. Joon nee²¹e' 'e ja'²mo júu³ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Joon 'láai²gɨ nigajmaa¹a Jesús. Joon wana to'²o tsá² ni jí² jilaa'²¹ 'e nigajmaa¹a Jesús iunrøøi¹ jí² 'láai² 'áai¹. Amén.");
INSERT INTO chqNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Coon'¹³ jí³ tyiia la mo 'láa² 'wii²¹² nifu, tsá² tyúi¹ Teofilo, gajmaa'¹³aa 'nʉ júu² ce jilaa'²¹ 'e ga'láa² Jesús 'wii²¹² jmáa¹a joongɨ 'e ga'e'²e tsá² ca gangaa'¹²i ñʉ'fú². La jo mo 'yaa¹i Jesús ñʉ'fú² gauncoon'¹³ Espíritu Tyʉ́² tya' Dios 'ii 'e icwo'¹o tsá² tya'a, 'in gatyii'¹³in, to² 'e 'ná¹ jmaa¹a. ");
INSERT INTO chqNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Mo gangɨ́ɨi² gajúin¹ Jesús do gajné¹mo 'e jiin'¹o jee²¹² tsá² tya'a. La jee²¹² tunlo¹ jmɨɨ²¹² do jnée²mo jee²¹² tsá² tya'a. Joon gajmaa¹a 'láai² nii² to² 'e 'ee¹ 'e nigalija'²mo 'e seen²¹mogɨ, 'e jo lí² jin'² tsá² 'e jo nijo'¹. Joongɨ gajin'²o xiiala mi tyʉ'² Dios to² tsá². ");
INSERT INTO chqNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","La jee²¹² ngɨ¹gɨ Jesús coon'¹³ tsá² tya'a ga'ɨ́ɨ² júu³ 'e jo mo 'woo²¹duu' Jerusalén lo ca gatséin¹ júu³ ga'ɨ́ɨ² Dios Jmii²¹. ");
INSERT INTO chqNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","―'E ja'²mo ―jin'² Jesús sɨɨ'²¹ɨ tsá² tya'a do―, Wó³‑o gasaai¹ tsá² jmɨɨ²¹ jiin'¹³ coon'¹³ jmɨɨ²¹ pe cɨɨin²¹gɨxʉ icwoo'¹²i Dios 'naa' 'in Espíritu Tyʉ́² tya'a iuncoon'¹³ 'naa'. ");
INSERT INTO chqNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Cafu mo gaicaain²¹ Jesús coon'¹³ tsá² tya'a gaunngɨɨ¹ɨ tsá² tya'a 'ii: ―Ña'ñʉ'¹ʉ', ¿tɨ gatɨ́² 'ii'²¹ 'e laa²¹²mo'o tsá² Israel joon la joon lí²‑i tyʉ'¹ʉ to² yaai? ");
INSERT INTO chqNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Joon gañii¹i Jesús: ―Jo tɨ́ɨi² 'naa' liñí³ii' lɨɨ²¹² tsei'² 'e ilí² jilaa'²¹ 'elo. Jiin'¹³ 'ña'a Ña'ñʉ'¹ʉ' Dios Jmii²¹ tɨ́ɨi² liñii¹i lɨɨ²¹² 'e ijmáa¹a 'elo. ");
INSERT INTO chqNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Pe ijoo²¹‑o 'in Espíritu Tyʉ́² tya' Dios joon 'ii ingɨ́¹ coon'¹³ 'naa'. Joon 'ii'²¹ tya' 'ii cwolíin²naa' Jerusalén, joongɨ la caain²¹ lɨ san'² Judea, joongɨ lɨ sii²¹ Samaria coon'¹³ la caain²¹ lɨ wíin²gɨ ni cwoo'¹³ juncwii²¹. Icwolíin²naa' cwojmaa²aa' júu³ 'iin jna. ");
INSERT INTO chqNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Mo ngayuui'¹³ gajin'² 'elo, la 'ɨɨ²¹² jǿø²mogɨ 'ido 'ii, joon gasaa¹mo Jesús. Ngaa'¹²i fu yʉ'. Joon gajó² coon²¹ jníi¹ gacɨɨ'¹²i Jesús. Joon jo jnéei²gɨ. ");
INSERT INTO chqNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Téen²mogɨ 'ido jǿø²ø fu ñʉ'fú² la 'ɨɨ²¹² ngaa'¹²i Jesús. Joon gajnéi¹ co' lɨ téein² 'ido gái¹ tsañʉʉ'¹ taa²¹ sɨɨn'¹³ɨn. ");
INSERT INTO chqNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Joon gajin'²in sɨɨ'²¹ɨ 'ido: ―Tsañʉʉ'¹ seein²¹ Galilea jo 'ee to² 'íi³in‑gɨ téen²naa' lo jǿø²øø' fu yʉ' juncwii²¹. 'In Jesús no, 'in cwo'ɨ́ɨ¹ jee²¹² 'naa' ngaa'¹²i fu yʉ' do coon²¹ røø²¹ 'ii la mo ngaa'¹²i do, la joon jon ijó¹ tún¹. ");
INSERT INTO chqNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Joon ngalíin²mo 'a moo'²¹ sii²¹ Olivos do. Joon ngaliin¹ tún¹ Jerusalén 'e ná¹ coon²¹ sii'¹³xʉ jiin'¹³ la to² gatyʉ'² ley tya' Moisés 'e sá² ngɨ¹ tsá² mo jmɨɨ²¹² 'ii'²¹ 'woo'²¹ tsá². ");
INSERT INTO chqNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Mo tyaliin¹in 'e fuu²¹ do gasóo²o coon²¹ 'nʉ́¹ lɨ tɨ́² tún² fúi¹. 'In gatyaliin¹in do sii²¹ Tʉ́³ coon'¹³ Jacobo coon'¹³ Wó³ coon'¹³ Dɨ́ɨ³ coon'¹³ Tomóo¹³ coon'¹³ Bartolomé coon'¹³ Untøø² coon'¹³ Jacobo, jóon¹ Alfeo, coon'¹³ Simóoi¹³, jaain²¹ tsá² tya' coon²¹ poo²¹² sii²¹ cananistas. Joon coon'¹³ Judas ruu'²¹i Jacobo, ");
INSERT INTO chqNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Jilee'²¹mo 'in lɨ caain²¹ coon'¹³ ruu'²¹i Jesús coon'¹³ María sáa³ Jesús coon'¹³ 'in tsamɨ́² catyaai² do. Lɨcaain²¹ fee'²¹i Dios. ");
INSERT INTO chqNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Jiin'¹³ jee²¹² joon galicaain²¹ tsá² jiin'¹³ coon²¹ cíein¹³ tsi dyáai² 'in jai'² lɨ́ɨi². Joon gajmaa¹a Tʉ́³ siin'¹³in jee²¹² tsaruu'²¹i, joon gajin'²in sɨɨ'²¹ɨ 'in tsá² catyaai² do: ");
INSERT INTO chqNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Tsaru'¹u', 'ná¹‑a tsín¹ jiin'¹³ la gataan¹an 'lɨɨ²¹² yʉʉ'¹³ David ni jí² tya' Dios coon'¹³ 'ii'²¹ tya' Espíritu Tyʉ́² tya' Dios. David do gafaa'²¹o xiiala 'e itsangɨ́ɨi² Judas. 'Ii‑o jee²¹² 'in gasaain'¹² Jesús. ");
INSERT INTO chqNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judas jaain²¹² jee²¹² jna'a, joon tɨ́ɨ²mo jmáa¹a to² coon'¹³ jna'a. ");
INSERT INTO chqNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Pe joon ngoo²¹‑o Judas ngala¹ coon²¹ si'² 'wó² coon'¹³ 'e cuu² gajna'¹an coon'¹³ 'e gó² gajmaa¹a do. Tsifu joon gacɨɨ'¹²i lɨ' sɨjɨɨi². Joon ga'gɨɨ²¹ɨ tu'²u. Joon ga'woo²¹o jilaa'²¹ 'un'mɨɨ²ɨ. ");
INSERT INTO chqNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Joon mo galiñi¹ 'in seein²¹ Jerusalén do joon gaunsii²¹ 'e 'wó² do Acéldama, 'øøi'²¹‑tsi tsá² sii²¹ Coon²¹ Sii'¹³ Tyiia²¹ 'in 'O² Jmɨ¹. ");
INSERT INTO chqNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Tsʉ 'wii'¹³ ni Salmos jin'² la no: Cwosii'²¹i 'nʉ́ʉ¹ʉ sɨtuu¹mo. Jo 'in seein²¹gɨ 'in cwaa²¹gɨ. Joongɨ jin'²in: Cwocwoo²oo' 'in xee'²¹mo 'in jmá¹ to² jmoo¹o 'ido. ");
INSERT INTO chqNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","’'Wii'¹³ joon tsajmoo²¹o' 'elo ―jin'² Tʉ́³―. Jee²¹² jna' jeei¹ 'inlɨ́ɨi¹³ tsá² 'in ningɨ¹ coon'¹³ jna' la tøøi² nigangɨɨ²¹ɨ' coon'¹³ Jesús. ");
INSERT INTO chqNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Ca la mo gasaa¹i Wó³ Ña'ñʉ'¹ʉ' Jesús jmɨɨ²¹ joon ca gangaa'¹²i ñʉ'fú². Tyii'¹³mo' jon jaain²¹ jee²¹² 'ii wa'a 'in licaain²¹ coon'¹³ jna'a 'e ijmáa¹a júu³ 'e nijiin'¹in Jesús ―gajin'² Tʉ́³. ");
INSERT INTO chqNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Joon ga'wooi²¹ gái¹ tsá² jee²¹² 'ii. Jaain²¹ 'in sii²¹ Sé³, 'in sii²¹o jon Barsabás, sii²¹o jon Justo. 'In jain²¹gɨ do sii²¹ Matías. ");
INSERT INTO chqNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","La 'ɨɨ²¹² fee'²¹i Dios jin'²in: ―Ña'ñʉ'¹ʉ', 'nʉ‑ʉ jøø²'ø jilaa'²¹ alma tya' tsá². 'Ee'¹³du' jna'a 'naai²¹² 'in jee²¹² gái¹ lo nityi¹u'u 'in jmá¹ to² tsá² tya' Jesús cwáain¹ tya' Judas. Gajaan¹an Judas do 'e to² jmoo¹o 'wii'¹³ tsaa² tya'o. Joon ngoo²¹‑o lɨ 'iin²¹²mo. ");
INSERT INTO chqNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Joon gacoo¹o jee²¹² 'ii. Joon gatɨ́ɨ²mo Tíi¹³. Tsifu joon ga'í² Tíi¹³ do cwáain¹ tya' Judas jee²¹² 'in dyajaain²¹ tsá² tya' Jesús. ");
INSERT INTO chqNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Mo gatsín¹ cincuenta jmɨɨ²¹² mo gangɨ́ɨ²i cwaa'²¹ jmɨɨ²¹² gatɨ́² jmɨɨ²¹² sii²¹ Pentecostés. Coon²¹ lɨ sɨcaain²¹ la jilee'²¹mo 'in jai'² lɨ́ɨi². ");
INSERT INTO chqNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","La 'ɨɨ²¹² joon coon²¹ ga'iin² lɨ' yʉ' lawa mo 'ɨɨ¹ɨ tyí² tá² lɨɨlɨ¹. Ga'iin² la tøøi² inʉʉ lɨ néei¹ 'ido. ");
INSERT INTO chqNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Joon gajnéi¹ coon²¹ 'e lɨ la lɨ sɨɨ'¹³ jɨ́² lɨ néei¹ la jaain²¹. ");
INSERT INTO chqNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Joon ga'í² 'in Espíritu Tyʉ́² tya' Dios almas tya' ce jilee'²¹mo 'in néei¹ do. Joon ga'láa² 'wii²¹² faa'²¹ jmai'² jmíi¹ xiia'²¹ 'e cwoo¹o 'in Espíritu Tyʉ́² do faa'²¹a. ");
INSERT INTO chqNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Jee²¹² jmɨɨ²¹² lo fúu¹mo tsá² Israel 'in untiin'¹³ to² tyʉ'² Dios sɨcaain²¹. Jalíin² Jerusalén la caain²¹ juncwii²¹. ");
INSERT INTO chqNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Mo ganúu²un 'e ga'iin² do joon galicaain²¹ 'in tsá² do lɨ ga'iin². Pe jo ñii¹ 'in tsá² fúui¹ do 'ee nigalɨ́² mo ganúu²un la jaain²¹ la jaain²¹ 'in tsá² tya' Jesús do faa'²¹a jmíi¹ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Jmai'² 'in ganga'goo²¹‑tsi. Joon jmai'² 'in gafo'²mo joon sɨ́ɨ¹i jee²¹² 'ii: ―'Owa'a jon 'in seein²¹ Galilea jileei'²¹ 'in faa'²¹a no. ");
INSERT INTO chqNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Xiiala lɨ́¹ 'e nʉʉ²¹ʉn' faa'²¹a jmíi¹ tyi jna'? ");
INSERT INTO chqNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","11","Lɨ́ɨ¹ fúui¹ tsá² seein²¹ lo, 'in seein²¹ Partia, Media, Elam, Mesopotamia, Judea, Capadocia, Ponto, joon lɨ sii²¹ Asia seein²¹ lo. Seen²¹mo jon 'in jalíin² Frigia, Panfilia, Egipto joongɨ Africa lɨ' ngoo'¹³gɨ lɨ' Cirene. Joongɨ tsá² seein²¹ Roma 'in seein²¹ lo. Caa'¹²mo 'inlɨ́ɨi¹³ 'in seein²¹ Israel ca la mo galiseen²¹mo coon'¹³ 'inlɨ́ɨi¹³gɨ 'in nigatʉ́ʉ²mo dioses tya'a 'in gajmeei¹ tsá² joon niga'ii'²¹mo jon 'in Dios tya' tsá² Israel. Caa'¹²mo tsá² seein²¹ Creta coon'¹³ Arabia pe jilee'²¹mo' nʉʉ²¹ʉn' faa'²¹a coon'¹³ jmíi¹ tyi‑o' júu³ tyʉ́² tya' Dios. ");
INSERT INTO chqNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Jilee'²¹mo tsa'goo²¹‑tsi pe joon jo 'øøi'²¹‑tsi 'ee galɨ́². Joon gaunngɨɨ¹ɨ ruu'²¹i: ―¿Ee 'øøi'²¹‑tsi jilaa'²¹ 'elo? ");
INSERT INTO chqNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Pe 'inlɨ́ɨi¹³gɨ ungøø¹i, jin'²in: ―Tsá² 'íin¹mo no. ");
INSERT INTO chqNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Joon gajmaa¹a Tʉ́³ siin'¹³in coon'¹³ jɨ dyajaain²¹ apóstoles catyaai² do joon gafaa'²¹a tá² jin'²in: ―Tsá² seein²¹ Israel, joongɨ coon'¹³ tsá² seein²¹ Jerusalén, cwoliñí²ii' 'elo. Joongɨ nʉ́ʉ²duu' coon'²¹ tún² 'e ifo'³oo lo. ");
INSERT INTO chqNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","'In tsañʉʉ'¹ lo jon' 'in 'íin¹ no la lɨ́² 'e 'ɨ¹‑'oo' tsʉ 'aa²¹gɨ lo. Jo mo tɨ́² 'ii'²¹ wa'a ngɨ¹ tsá² 'íin¹. Jiin'¹³ la 'iin²¹ ñʉ́² ningóo¹. ");
INSERT INTO chqNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","'Elo‑o gatsín¹ 'e gajin'² 'in gafaa'²¹a júu³ tya' Dios calɨɨ sii²¹ Joel. Joel do gajin'²in: ");
INSERT INTO chqNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","La lo‑o gajin'² Dios: La nʉ'gɨ mi 'iin² juncwii²¹ icwo'³oo Espíritu Tyʉ́² tyiia la jileei'²¹ 'in taain²¹² fu juncwii²¹. Yʉʉn²¹ tyii'i tsañʉʉ'¹ coon'¹³ yʉʉn²¹ tyii'i tsamɨ́² ifaa'²¹a cwáain¹ tyiia. Joongɨ sɨmii'²¹ sá² coon²¹ iní²i. Joongɨ yʉʉ'¹³ icwuu²¹mo ilisá² tyisáa² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Nicwóo³oo 'in Espíritu Tyʉ́² tyiia 'e jmɨɨ²¹² joon tya' jileei'²¹ 'in jmoo¹o la to² tyʉ'³ʉʉ la tsañʉʉ'¹ teen'¹³ la tsamɨ́². Joon ifaa'²¹o cwáain¹ tyiia. ");
INSERT INTO chqNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Lɨ' yʉ' juncwii²¹ 'ée³ee 'a tsa'goo²¹‑'oo'. Jmáa³oo jon li² lɨ ni 'wó². Coon'¹³ jmɨ¹, joongɨ coon'¹³ jníi¹ tya' uñi² ijmá³aa 'e li² do. ");
INSERT INTO chqNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","La nʉ'gɨ 'e icwá¹ jmɨɨ²¹² tya' Ña'ñʉ'¹ʉ' Jesús, coon²¹ jmɨɨ²¹² fee'¹ joongɨ coon²¹ jmɨɨ²¹² 'ya'²gɨ lɨɨlɨ¹, ilinʉʉ²¹ lɨ 'íi¹in ñi'¹. Joongɨ sɨɨ'²¹gɨ iliin¹ la lɨ́¹ jmɨ¹. ");
INSERT INTO chqNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Joon jilee'²¹mo 'in gamɨɨ¹ɨ coon'¹³ 'e sii²¹ Ña'ñʉ'¹ʉ' itiin'¹³mo. La joon júu³ niga'ɨ́ɨ² Joel cwáain¹ tya' Dios Jmii²¹ ―jin'² Tʉ́³. Faa'²¹gɨ Tʉ́³ jin'²in: ");
INSERT INTO chqNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","―'Wii'¹³ joon nʉ́ʉ²duu', tsañʉʉ'¹ seein²¹ Israel, jilaa'²¹ 'e ifuu²¹²uu 'naa' lo ―jin' Tʉ́³―. Tyʉ́²‑ʉ ñí³oo' jilaa'²¹ milagro 'ya'²gɨ 'e gajmaa¹a Jesús tsá² Nazaret coon'¹³ 'ii'²¹ tya' Dios Jmii²¹ jee²¹² 'naa'. Joon coon'¹³ jilaa'²¹ 'e gajmaa¹a Jesús do gajmaa¹a Dios júu³ 'e Jesús jaain²¹ tsá² 'in 'iin²¹²in. ");
INSERT INTO chqNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Pe jo 'ee futyí³ la mo gajaain'²¹ tsá² 'ii jee²¹² 'naa' tsʉ 'yʉ to²‑o 'e ni'ɨ¹‑tsi Dios ca la mo jée¹mo. 'Naa'gɨɨ' gaseen'²moo', joon cwáain¹ tyi'naa'oo' gajngaa'¹³i tsá² gó² 'ii, gateen¹in tsaa' crúu¹³. ");
INSERT INTO chqNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Pe Dios Jmii²¹ gajmaa¹a jiin'¹o tún¹. Nigaláa²mo tsʉ feei'¹gɨ 'ii lagɨ 'mó¹. Jo lí² tyʉ'² 'mó¹ 'ii to². ");
INSERT INTO chqNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Joon 'lɨɨ²¹² rǿøi¹³ David gafaa'²¹a ni jí² tya' Dios cwáain¹ tya' Jesús mo gajin'²in: Máa¹moo Ña'ñʉ'¹ʉ' Dios coon²¹ tøø²mo tyaní³ii. Lɨ caa²¹na tsáa¹ siin'¹²in joon jo 'ee jiin'¹³ coon²¹ goo'²¹oo. ");
INSERT INTO chqNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","'Wii'¹³ joon jløø'³mo alma tyiia. Joon coon'¹³ moo'óo³oo fo'³oo jmai'² júu³ tyʉ́²‑ʉ. 'Wii'¹³ joon mo 'ii'²¹ 'woo'²¹ cuerpo tyiia jo 'ee cu'²‑tsii coonti. ");
INSERT INTO chqNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Tsʉ ñí³oo 'e jo saa'¹²'a alma tyiia jee²¹² 'lɨɨ²¹². Joongɨ jo cwo'²'o 'e ixiia'²¹ cuerpo tya' 'in gatyii'¹³'in. ");
INSERT INTO chqNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ga'ee'¹³o'o jna xiiala ngɨ́ɨ³ɨɨ coon²¹ fu¹ coon²¹ tsáa¹ 'e cwo¹ juncwii²¹ tya' tsá². Joon nigalijløø'³moo 'wii'¹³ cwoo²¹'o coon'¹³ jna. La joon gajin'² David cwáain¹ tya' Jesús. ");
INSERT INTO chqNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","’Tsaru'¹u', tyʉ́²‑ʉ ñii²¹i' 'e 'lɨɨ²¹² tsafeei'¹ tyi' David juun²¹mo. Joon ga'áa²mo tsá² 'ii. Joon 'aan¹ tya'a roon¹gɨ coon'¹³ jna' ca jmɨɨ²¹² no. ");
INSERT INTO chqNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Pe David do jaain²¹ 'in gafaa'²¹a júu³ tyʉ́² tya' Dios. Joon ñii¹o David 'e gasɨɨ'²¹ɨ Dios 'ii 'e tyi'²mo jaain²¹ tyii²¹a 'in cwa¹ cwáain¹ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","La joon 'lɨɨ²¹² David do lawa jǿø²o ca la jée¹mo 'a ijiin'¹in Cristo. Joon gajin'²in 'e jo ján² alma tya'a jee²¹² 'lɨɨ²¹². Jon'gɨ xiia'² moo¹ taa²i. ");
INSERT INTO chqNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","'Ña'a Dios Jmii²¹ gajmaa¹a jiin'¹ 'in Jesús no. Jilaa'²¹ 'elo ganee²¹e'e. ");
INSERT INTO chqNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Joon gatǿ¹ Dios Jmii²¹ 'ii lɨ' cwoo²¹o tsáa¹. Joon gacwo'¹o Dios Jmii²¹ 'ii 'in Espíritu Tyʉ́² tya'a la lɨ 'e nigajin'²in. Joon jilaa'²¹ 'e nigalɨ́² nano, joongɨ nijǿø²øø' joongɨ ninʉ́ʉ²ʉʉn' 'e gajmaa¹a 'ii‑o joon. ");
INSERT INTO chqNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Jon' David do 'in gangaai'¹³ fu ñʉ'fú² tsʉ 'ñaa'o gajin'²in: Dios Jmii²¹ gasɨɨ'²¹ɨ Ña'ñʉ'¹ʉ' jin'²in: “Ní³'i caa¹na tsáa¹ ca mi jmáa³aa 'ii'²¹ 'e tyée¹na 'wii²¹² tɨ́ɨ¹³'ɨ jileei'²¹ 'in 'eei'¹ 'nʉ.” ");
INSERT INTO chqNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Jileei'²¹ tsá² Israel, cwoliñí³oo' 'e la ja'²mo 'in Jesús, 'in gatéen¹naa' tsaa' crúu¹³, Dios gajmee¹i 'e 'ii Ñi'fii²¹²i' joongɨ 'in jmaa¹a tiin'¹³naa' sii²¹ Cristo. La joon gajin'² Tʉ́³ sɨɨ'²¹ɨ 'in tsá² fúui¹ do. ");
INSERT INTO chqNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Joon mo ganúu²un 'in tsá² do 'elo joon ga'aa¹a fa'í³ joon gaunngɨɨ¹ɨ Tʉ́³ coon'¹³ 'in tsá² tya' Jesús catyaai² do: ―Tsaru'¹u', ¿'ee 'ná¹ jmoo²¹o'o? ");
INSERT INTO chqNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Joon gañii¹ Tʉ́³: ―Cwojaa'²¹‑'oo' coon'¹³ Dios joongɨ cwosaa²¹naa' jmɨɨ²¹ la jaan²¹naa' coon'¹³ la sii²¹ Jesucristo. Joon la joon 'iin²mo Dios tsaa² tyii'. La joon jon icwo'¹o Dios 'naa' 'in Espíritu Tyʉ́² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","'E júu³ lo 'e tyi'naa'oo' coon'¹³ yʉʉn²¹ tyii'. Joongɨ tya' jileei'²¹ 'in seein²¹ wíin². Joongɨ tya' jileei'²¹ 'in tøø¹ø Ña'ñʉ'¹ʉ' Dios Jmii²¹. ");
INSERT INTO chqNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Coon'¹³ 'e júu³ lo gafaa'²¹a Tʉ́³. Joon coon'¹³ láai²gɨ júu³ tyʉ́² gafaa'²¹a jin'²in: ―Woo²¹naa' yaanaa' jee²¹² 'in tsá² gó² no. ");
INSERT INTO chqNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Joon gasaa¹mo jmɨɨ²¹ jileei'²¹ 'in gacón² cwáain¹ júu³ tya'a. Jiin'¹³ jmɨɨ²¹² joon galicaan²¹mogɨ coon'¹³ 'in jai'² lɨ́ɨi² ca 'nɨ¹ mil‑gɨ tsá². ");
INSERT INTO chqNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Joon coon'²¹ tún¹‑un gacón² cwáain¹ jilaa'²¹ 'e 'ee¹e 'in apóstoles tya' Jesús do. Tyʉ́²‑ʉ seein²¹ la jaain²¹ la jaain²¹. Joongɨ galicaain²¹ fee'²¹i Dios joongɨ gajmaa¹a jmai'²xʉ 'iñi'¹. ");
INSERT INTO chqNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Joon lɨ́ɨ¹ tsa'goo²¹‑tsi tsá². Joon 'in tsá² tya' Jesús do lɨ́ɨ¹ 'láai² milagro gajmaa¹a coon'¹³ jilaa'²¹ li². ");
INSERT INTO chqNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Jileei'²¹ 'in nigajai'² lɨ́ɨi² do lɨ́ɨ¹ røø²¹ sɨ́ɨ¹i. Jmaa'²¹i to² jmai'²xʉ jmai'²xʉ‑ʉ la jaain²¹ la jaain²¹ jilaa'²¹ 'e 'oo¹o. ");
INSERT INTO chqNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Joongɨ ga'nɨɨ¹ɨ jilaa'²¹ 'e 'oo¹o. Joon jmoo¹o jmai'²xʉ cuu² coon'¹³ la jaain²¹ la jaain²¹ xiia'ti sɨtyéein¹³ jmɨɨ²¹² jee²¹² 'ii. ");
INSERT INTO chqNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","La coon²¹ jmɨɨ²¹² la coon²¹ jmɨɨ²¹² licaain²¹ inʉʉ cwo'¹ fee'¹ tya' tsá² Israel. La caain²¹ inʉʉ tya'a jmoo¹o jmai'²xʉ 'iñi'¹. Gø'²ø jløø'³mo coon'¹³ 'e 'yaai¹‑tsi alma tya'a. Joon gacwoo¹‑o 'maai'¹³ Dios. ");
INSERT INTO chqNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Joon la jilee'²¹mo jin'²o 'e tsá² tyʉ́²‑tsi 'in tsá² jai'² lɨ́ɨi². La coon²¹ jmɨɨ²¹² gajmaa¹a Ña'ñʉ'¹ʉ' 'e ngafúu¹mo 'in jo'¹ lɨ́ɨi². Joon 'in jai'² lɨ́ɨi² do uncaan¹mo coon'¹³ 'in catyaai² do. ");
INSERT INTO chqNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Coon²¹ jmɨɨ²¹² nica'lóo²xʉ, ngóo¹ 'iin² 'nɨ¹, mo gatɨ́² 'ii'²¹ 'e faa'²¹a tsá² júu³ tyʉ́². Joon Tʉ́³ coon'¹³ Wó³ gasóo²o caan²¹mo fu inʉʉ cwo'¹ fee'¹ tya' tsá² Israel. ");
INSERT INTO chqNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Tsajée¹i tsá² jaain²¹ tsá² jluui'¹³ tyan' 'oo² cwo'¹ do lɨ ingɨ́ɨ¹i. Jluu'¹³mo ca la mo galiseen²¹mo. Joon la coon²¹ jmɨɨ²¹² tsajéei¹ tsá² 'ii fu coon²¹ 'oo² cwo'¹ do sii²¹ 'Ya'²gɨ 'e mɨɨ¹ɨ caridad jileei'²¹ 'in tsatáa¹i cwo'¹ do. ");
INSERT INTO chqNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Mo ganí² 'in tsá² jluui'¹³ do itsataai² Tʉ́³ coon'¹³ Wó³ inʉʉ cwo'¹ do joon gamɨɨ¹ɨ coon²¹ caridad. ");
INSERT INTO chqNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Joon gajǿøi² Tʉ́³ coon'¹³ Wó³ do 'ii. Joon gajin'² Tʉ́³: ―Jøøi²¹²du' jna'a. ");
INSERT INTO chqNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Joon gacon² 'in tsá² jluui'¹³ do cwáain¹ coon'²¹ tún². 'E sá² 'ee cwo'¹o 'ido 'ii lɨ́ɨ²i. ");
INSERT INTO chqNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Joon gasɨɨ'²¹ɨ Tʉ́³ 'ii: ―Jo 'óo³oo cwataa²¹ jon'gɨ cwanáa¹³ sá² tyiia pe jiin'¹³ 'e 'óo³oo lo cwo'³‑oo 'nʉ. Coon'¹³ 'ii'²¹ tya' 'e sii²¹ Jesucristo tsá² Nazaret, ráan²un, ngɨ² no. ");
INSERT INTO chqNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Joon gason'¹ Tʉ́³ cwoo²¹o tsáa¹. Joon gauncoon'¹³on jmaa¹a siin'¹²in 'ido. La 'ɨɨ²¹² joon galipíin²mo moo¹ taa'¹³ luu²¹² tɨɨ²ɨ. ");
INSERT INTO chqNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Joon ga'ɨ́ɨ²i 'in tsá² jluui'¹³ do fu yʉ'. Joon ga'láa² 'wii²¹² ngɨɨ¹ɨ tɨɨ²ɨ. Joon ga'í² 'ɨ́ɨ²i fu tsi inʉʉ cwo'¹ do coon'¹³ Tʉ́³ coon'¹³ Wó³. 'ɨ́ɨ²ɨ jløø'³i lɨɨlɨ¹. Cwo'¹o 'maai'¹³ Dios. ");
INSERT INTO chqNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Joon jilee'²¹mo tsá² 'in téein² do jǿøi² 'ii ngɨɨ¹ɨ cwoo¹o 'maai'¹³ Dios. ");
INSERT INTO chqNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Jmai'² 'in tsa'goo²¹‑tsi 'e ganii²¹ do 'wii'¹³ ñi¹o 'e ido‑o 'in tsá² jluui'¹³ 'in tyíin¹ 'oo²¹ cwo'¹ sii²¹ 'Ya'²gɨ mɨɨ¹ɨ caridad. ");
INSERT INTO chqNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","'In tsá² jluui'¹³ 'in ni'láai² do jo mo gatíui² Tʉ́³ coon'¹³ Wó³ coonti. Joon jileei'²¹ tsá² 'in téein² 'in'yíia² cwo'¹ do ngalíin² cwiin¹in fu lɨ téein² Tʉ́³ do. Téen²in coon²¹ ni'nʉ́¹ fee'¹ 'e sii²¹ Salomón. ");
INSERT INTO chqNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Mo ganí² Tʉ́³ 'elo joon gasɨɨ'²¹ɨ tsá² 'in jalíin² do: ―Tsá² seein²¹ Israel, ¿'ee lɨ' tsa'goo²¹‑'oo'? ¿'Ee lɨ' jǿø²naa' jna'a lawa yiia‑oo'o nigaun'láa²na'a 'in tsañʉʉ'¹ lo? ¿Tɨ 'ɨ¹‑'oo' 'e nigangɨ¹ 'in tsá² lo coon'¹³ 'ii'²¹ tyijna'oo'o sɨ 'wii'¹³i 'e tyúi¹ jna'a 'ee? ");
INSERT INTO chqNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Jo lɨ́² la joon, Dios, 'in gaun'goo²¹o 'lɨɨ²¹² tsacøøi'¹³ tyi' Abraham coon'¹³ Isaac coon'¹³ Jacob, nigacwóo¹i jóon¹on Jesús, 'in feei'¹gɨ la jee²¹² jileei'²¹ pe 'naa' nigajaan'¹³moo' 'i tyani 'in tyʉ'² to². Joon mo gali'iin²¹²mo Pilato 'e iláa²i pe 'naa'gɨɨ' jo gali'iin²¹²naa'. ");
INSERT INTO chqNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","'E 'íi¹³ 'e mɨ́²ɨɨ' láai² jaain²¹ 'in tyúi¹, 'in jo 'ee tsaa² røøi²¹, naa'gɨɨ' gamɨ́²ɨɨ' galáai² jaain²¹ tsá² gó² 'in røøi²¹ tsaa². ");
INSERT INTO chqNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","La joon gajngaa'¹³moo' 'in cwo¹ juncwii²¹ tyi'. Pe Dios gajmaa¹a gajiin'¹o tún¹. Joon jna'gɨɨ'ɨ faa'¹³a'a 'e ja'²mo jilaa'²¹ 'elo. ");
INSERT INTO chqNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Joon 'in tsañʉʉ'¹ lo, 'in cwii¹moo', Dios gaun'láa²mo tsʉ 'wii'¹³ jo'¹o lɨ́ɨi² Jesús. Jmai'² coon'¹³ 'ii'²¹ tya' 'e sii²¹ Jesús nigalipíin²mo tɨɨ²ɨ la lɨ nigañi²ii'. ");
INSERT INTO chqNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Niñí³oo, tsaru'¹u', 'e 'naa'oo' coon'¹³ tsacøøi'¹³ tyi' mo gajngaa'¹³naa' Jesús do gajmaa²aa' 'e jo 'øøi'²¹‑'oo'. ");
INSERT INTO chqNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Pe la joon gatsín¹ 'e nii²¹ Cristo wúu¹ jiin'¹³ la gajin'² tsá² tyúi¹ coon'¹³ 'in gacwo¹ júu³ tyʉ́² tya' Dios la jéei¹gɨ. ");
INSERT INTO chqNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","'Wii'¹³ joon 'ná¹‑a jaa'²¹‑'oo' joon cɨɨ'¹³‑'oo' coon'¹³ Dios joon la joon 'iin²mo tsaa² tyii'. Joon ijó¹‑o Ña'ñʉ'¹ʉ' 'e untyúu¹mo 'naa'. ");
INSERT INTO chqNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","La joon 'e isíi¹in Dios Jesús, 'in sii²¹ jon Cristo, 'wii²¹² tyi'naa'. ");
INSERT INTO chqNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Fiin'¹³ ca la mo ñʉ'fú² tyíin¹ Jesucristo ca mi tyá² Dios tyʉ́² ce jilaa'²¹. La joon gajin'² tsá² tyúi¹ 'in gacwo¹ júu³ tyʉ́² tya' Dios calɨɨ. ");
INSERT INTO chqNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","La joon gajin'² 'lɨɨ²¹² Moisés sɨɨ'²¹ɨ 'lɨɨ²¹² tsacøøi'¹³ tyi'. Jin'²o: “Ña'ñʉ'¹ʉ' Dios 'e isíi¹in jaain²¹ 'in cwo¹ júu³ tyʉ́² jee²¹² 'naa', tsaru'¹u', jiin'¹³ la gasii¹in jna. Cwolinʉ́ʉ¹³ʉʉn' jilaa'²¹ 'e jin'²in ");
INSERT INTO chqNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","tsʉ jileei'²¹ 'in jo nʉʉ'¹³ 'in cwo¹ júu³ tyʉ́² do 'e i'iin²mo 'i jee²¹² tsagoo¹o.” La joon gajin'² Moisés. ");
INSERT INTO chqNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Joon la joon jileei'²¹ 'in gacwo¹ júu³ tyʉ́² tya' Dios ca Samuel nifu gafaa'²¹ cwáain¹³ tya' 'e jmɨɨ²¹² lo. ");
INSERT INTO chqNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Joon jilaa'²¹ júu³ tyi'naa'oo' lo 'e ga'ɨ́ɨ²ɨ Dios la mo jéei¹ coon'¹³ tsá² 'in cwo¹ júu³ tyʉ́² tya'a. 'E tyʉ́² tyi‑oo' mo ga'ɨ́ɨ² Dios coon²¹ júu³ jéei¹gɨ coon'¹³ 'lɨɨ²¹² tsacøøi'¹³ tyi' mo gajin'²in sɨɨ'²¹ɨ Abraham: “Jileei'²¹ tsá² taain²¹² fu juncwii²¹ ilicwaa'³mo mi jó¹ yʉʉn²¹ tyi'i.” ");
INSERT INTO chqNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Mo gajmaa¹a Dios jiin'¹ Jóon¹on gasii¹in nifu tyani²ii' iuncwaa'³i 'naa'. Joon la joon 'e uncoon'¹³o 'naa' 'e tʉ́²oo' jilaa'²¹ 'e gó². ");
INSERT INTO chqNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Faa'²¹gɨ Tʉ́³ coon'¹³ Wó³ téen²in mo gatyalíin² untsá² coon'¹³ 'in tyʉ'² to² 'in tsá² 'in ní² inʉʉ cwo' fee'¹ do. Joongɨ ngaliin² 'inlɨ́ɨi¹³ tsá² tya' coon²¹ poo²¹² sii²¹ saduceos. ");
INSERT INTO chqNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","'Nii'²¹‑tsi 'wii'¹³ Tʉ́³ coon'¹³ Wó³ 'e'²e tsá² júu³ tyʉ́² joongɨ 'wii'¹³ jin'²in la mo gajiin'¹ Jesús la joon jon ijiin'¹in tsá². ");
INSERT INTO chqNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Joon tsifu joon gasan'² ni 'ido. Joon ngajée¹i 'nʉñí³ ca nʉ́ʉ¹ tsʉ nica'lóo² do. ");
INSERT INTO chqNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Pe fúu¹mo 'in niganúu²un 'e júu³ do jo'¹o lɨ́ɨi². Joon jileei'²¹ 'in jai'² lɨ́ɨi² tɨ́² 'ñá² mil jmai'² tsañʉʉ'¹. ");
INSERT INTO chqNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Mo gajná² jmɨɨ²¹² joon galicaain²¹ fu Jerusalén 'in tyʉ'² to² tya' tsá² Israel coon'¹³ tsacøøi'¹³ coon'¹³ tɨfo'² tya' ley. ");
INSERT INTO chqNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Joongɨ néei¹ Anás 'in tyʉ'² to² tya' untsá², coon'¹³ Caifás coon'¹³ Juan, coon'¹³ Alejandro. Joon gauncaain²¹ jileei'²¹ tsá² inʉʉ tya' tsacøøi'¹³ tya' untsá². ");
INSERT INTO chqNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Joon gatyʉ'²ʉ to² gajalíin² Tʉ́³ coon'¹³ Wó³. Joon gasiin'¹²in tún² tsa'². Joon gaunngɨɨ¹ɨ 'in tyʉ'² to² do 'ii: ―¿'Iin 'ii'²¹ tya'a sɨ coon'¹³ 'e sii²¹ 'in xeei'²¹gɨ 'ee gajmaa²aa' jilaa'²¹ 'elo? ");
INSERT INTO chqNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Joon Tʉ́³ jin'²in coon'¹³ 'ii'²¹ tya' 'in Espíritu Tyʉ́² tya' Dios: ―Tsacøøi'¹³ 'e fuu²¹ lo joongɨ tsacøøi'¹³ tya' tsá² Israel: ");
INSERT INTO chqNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","wana 'iin²¹²naa' unngɨɨ¹ɨɨ' jna'a coon²¹ 'e tyʉ́²‑ʉ gajmoo²¹o'o tya' jaain²¹ tsatsaa'¹³ 'e xiiala ga'láai². ");
INSERT INTO chqNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Joon jna'a jmoo²¹o'o júu³ tyaní²ii'. Cwoliñí³ii' jileei'²¹ tsá² Israel 'e 'in tsañʉʉ'¹ 'in siin'¹² tyaní²ii' lo nano niga'láai² coon'¹³ 'e sii²¹ Jesucristo tsá² Nazaret. 'Ii 'in gatéen¹naa' tsaa'¹ crúu¹³ do. Joon Dios gajmaa¹a jiin'¹ tún¹. ");
INSERT INTO chqNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","'In Jesús lo lɨ́ɨ¹i lawa coon²¹ cuun²¹² nifu pe 'naa'gɨɨ' lawa 'in jmoo¹o to² do nigajaan²aan' lɨ' co'o. ");
INSERT INTO chqNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ce jiin'¹³ jaain²¹ 'in taain²¹² juncwii²¹ jo lí² jmáa¹a tiin'¹³naa' tsʉ² Dios nigacwoo¹o 'e jiin'¹³ Jesús tɨ́ɨ²i jmáa¹a tiin'¹³naa' ―jin'² Tʉ́³ do. ");
INSERT INTO chqNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Mo ganí² jileei'²¹ 'in tyʉ'² to² do xiiala jo 'goo'²¹ Tʉ́³ coon'¹³ Wó³ faa'²¹a joon galili'³o 'e jo 'e jí² tɨɨi²¹ 'ido jon'gɨ 'ee to² 'oo¹o ganga'goo²¹‑tsi. Joon galiñii¹i 'e 'ido‑o 'e nigangɨ¹ coon'¹³ Jesús. ");
INSERT INTO chqNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Joongɨ 'in tsá² 'in niga'láai² do, do‑o siin'¹²in jee²¹² 'ii‑o. 'Wii'¹³ joon jo 'ee sá² 'e faa'²¹gɨ coonti. ");
INSERT INTO chqNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Joon gatyʉ'²ʉ to² 'e 'woo²¹mo lɨ sɨcaain²¹ do. Joon gasɨ́ɨ²i la jee²¹² yaa‑mo 'ee 'e 'ná² jmáa¹a. ");
INSERT INTO chqNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Joon gajin'²in: ―¿'Ee jmoo²¹o' coon'¹³ 'in tsá² do? Jilee'²¹mo 'in seein²¹ Jerusalén niñi¹o jilaa'²¹ li² nigajmaa¹a 'in tsá² no. Coon²¹ milagro fee'¹ lɨɨlɨ¹ nigajmaa¹a 'ido. Joon jo lí² faa'¹³a' 'e jon' la joon galɨ́². ");
INSERT INTO chqNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Tsatáan¹³an' fo'²‑tsi 'e jo faa'²¹gɨ jiin'¹³ jaain²¹ cwáain¹ tya' Jesús. Joon coon'¹³ 'e la joon jo núu²gɨ tsá². ");
INSERT INTO chqNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Joon 'in tsá² do gatø'¹ø tún¹ Tʉ́³ coon'¹³ Wó³. Joon gatyʉ'²ʉ to² la jo faa'²¹gɨ 'ido coonti, jon'gɨ 'e'²gɨ tsá² cwáain¹ tya' Jesús. ");
INSERT INTO chqNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pe joon gañii¹i Tʉ́³ coon'¹³ Wó³: ―'Í²du'‑'oo' yaanaa' no. ¿Tɨ tyʉ́²gɨ tyani Dios 'e jmoo²¹o'o nʉ́ʉ¹³ʉ'ʉ to² tyʉ'² 'naa' lagɨ to² tyʉ'² Dios 'ee? ");
INSERT INTO chqNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Tsʉ jna'a jo cwooi¹ tʉʉ²¹ʉ'ʉ 'e faa'¹³a'a jilaa'²¹ 'e ganee²¹e'e joongɨ ganʉʉ²¹ʉ'ʉ. ");
INSERT INTO chqNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Joon 'in tyʉ'² to² do gaton'¹on fo'²‑tsi pe galáa²mo 'ido. Jo gatsaa'²¹a xiiala ijmeei'²¹ ni 'ido wúu¹ tsʉ 'gøø'²¹mo tsá². Jilee'²¹mo tsá² cwo'¹o 'maai'¹³ Dios jilaa'²¹ 'e nigalɨ́². ");
INSERT INTO chqNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","'In tsá² 'in ga'láai² coon'¹³ milagro do ningoo²¹‑o tunló² jiin²¹ lɨ́ɨ¹gɨxʉ. ");
INSERT INTO chqNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Mo galáai² Tʉ́³ coon'¹³ Wó³ joon nigalíin²mo fu lɨ néei¹ 'in tsaruu'²¹i catyaai² do. Jooon gatyaa¹ júu³ la jilaa'²¹ 'e nigajin'² 'in tyʉ'² to² tya' untsá² do coon'¹³ tsacøøi'¹³ do. ");
INSERT INTO chqNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Joon mo ganúu²un, jilee'²¹mo gamɨɨ¹ɨ sɨɨ'²¹ɨ Dios: ―Ña'ñʉ'¹ʉ', 'nʉ‑ʉ Dios 'in gajmaa¹a ñʉ'fú² joongɨ ni 'wó², joongɨ jmɨ'ñi'³ coon'¹³ jilaa'²¹gɨ 'e sá² ni cwoo'¹³ juncwii²¹. ");
INSERT INTO chqNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Joon 'lɨɨ²¹² tsafeei'¹ tyii'i David, 'in gajmaa¹a jiin'¹³ la to² gatyʉʉ'¹²'ʉ, gafaa'²¹a cwáain¹ tyi'i mogajin'²in coon'¹³ 'ii'²¹ tya' Espíritu Tyʉ́² tyi'i: ¿'Ee lɨ' to'² lɨ¹ tsá² taain²¹² juncwii²¹ mɨɨ'¹³? Joongɨ 'ɨ¹‑tsi tsá² jmai'² 'e jo 'ee to² 'íi³mo. ");
INSERT INTO chqNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Jileei'²¹ tsaa'to² garóon². Joongɨ tsacøøi'¹³ 'e fuu²¹ galicaain²¹. Joon gajmaa¹a 'ee'¹i Ña'ñʉ'¹ʉ' Dios joongɨ coon'¹³ 'in gasii¹in Dios sii²¹ Cristo. ");
INSERT INTO chqNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Tsʉ ja'²mo 'e fuu²¹ lo galicaain²¹ Herodes coon'¹³ Poncio Pilato coon'¹³ tsá² seein²¹ lɨ xiia'gɨ coon'¹³ tsá² Israel. Joon galicaain²¹ 'e jmáa¹a 'e gó² tya' yʉʉn²¹ tyi'i Jesús 'in 'iin²¹²un. ");
INSERT INTO chqNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Joon la jon gajmaa¹a jilaa'²¹ to² 'e nityʉʉ'¹²'ʉ 'e ilí² joongɨ jilaa'²¹ 'e ni'ɨ¹‑'o'o. ");
INSERT INTO chqNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Joon la no coon²¹du'u cwáain¹ fo'² gaton'¹on. Cwoo'¹³ jna'a yʉʉn²¹ tyi'i 'e jo ngɨɨ²¹ɨ'ɨ cu'²‑tsii'i. La joon jo 'goo'²¹‑oo'o 'e cwoo²¹o'o júu³ tyʉ́² tyi'i. ");
INSERT INTO chqNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Joon mɨɨ²¹ɨ'ɨ tyaní²'i 'e cwo'²'o jna'a 'ii'²¹ tyi‑o'o 'e un'láa²na'a jileei'²¹ tsatsaa'¹³ joongɨ coon'¹³ 'e sii²¹ yʉʉn²¹ tyi'i Jesús jmoo²¹o'o jilaa'²¹ li² coon'¹³ milagro fee'¹. ");
INSERT INTO chqNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Mo ngayuui'¹³ gafaa'²¹a júu³ tyʉ́² tya'a 'e lɨ́² lɨcaain²¹ do joon gajøø'²¹ 'wó² tá² lɨɨlɨ¹. Tsifu joon galiseein²¹ waa'²¹ pí² coon'¹³ 'ii'²¹ tya' 'in Espíritu Tyʉ́² tya' Dios. Joon jo 'goo'²¹gɨ faa'²¹a júu³ tyʉ́² tya' Dios. ");
INSERT INTO chqNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ca nii² 'e 'ɨ¹‑tsi jileei'²¹ 'in nijo'¹ lɨ́ɨi². Joongɨ coon²¹ røø²¹ lɨ́ɨ¹i jilee'²¹mo. Ce jiin'¹³ jaain²¹ jo jin'² wa'a 'e 'oo¹o tya'a 'ña'a. Jilaa'²¹ jmai'² tya' jilee'²¹mo. ");
INSERT INTO chqNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Faa'²¹gɨ 'in apóstoles tya' Jesús do 'e nigajiin'¹in Ña'ñʉ'¹ʉ' Jesús. Joon taain²¹² tá²‑tsi lɨɨlɨ¹. Joon Dios gataa'¹³i cwa'³ jilee'²¹mo. ");
INSERT INTO chqNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Jiin'¹³ jaain²¹ jo 'oo¹o fa'í³ 'wii'¹³ jilee'²¹mo 'in 'oo¹o 'wó² sɨ 'nʉ́¹ 'ee ni'nɨɨ¹o. ");
INSERT INTO chqNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Joon jilaa'²¹ 'e sá² cwo'¹o tsá² apóstoles. Joon 'ii‑gɨ gajmaa¹a jmai'²xʉ la jaain²¹ la jaain²¹ xiiala sɨtyéein¹ tsá² jmɨɨ²¹². ");
INSERT INTO chqNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Lawa la lo‑o jmoo¹o jileei'²¹. Seein²¹ jee²¹² 'ii jaain²¹ jún² Leví 'in sii²¹ Sé³. Galiseein²¹ coon²¹ 'wó² roon¹ ni jmɨɨ²¹ sii²¹ Chipre. Joon 'in apóstoles do gaunsii²¹o 'ii Bernabé. ('øøi'²¹‑tsi tsá² sii²¹: 'in untyʉ́²‑tsi tsá².) ");
INSERT INTO chqNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","'In tsañʉʉ'¹ lo ga'nɨɨ¹ɨ coon²¹ sii'¹³ 'wó² tya'a. Joon 'e cuu² gatɨ́ɨ²i do ngacoon¹on joon gacwo'¹o tya' apóstoles do. ");
INSERT INTO chqNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Pe jaain²¹gɨ tsá² sii²¹ Ananías coon'¹³ 'oo²¹²o 'in sii²¹ Safira ga'nɨɨ¹ɨ coon²¹ sii'¹³ 'wó². ");
INSERT INTO chqNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","'In tsá² lo gasɨ́ɨ²i røø²¹ coon'¹³ 'oo²¹²o. Joon gasáai¹³gɨxʉ 'e cuu² do tya'a. Joon ngacwoo'²¹o 'in apóstoles do lawa'a la jilaa'²¹a. ");
INSERT INTO chqNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Joon gajin'² Tʉ́³ sɨɨ'²¹ɨ 'ii: ―Ananías ¿'ee lɨ' niga'í² 'in 'lɨɨi'³ alma tyi'i 'e gaungøø¹u 'in Espíritu Tyʉ́² tya' Dios? Gasaa²¹²gɨ'ɨ 'e cuu² gatɨ́ɨ²u tya' 'wó² do. ");
INSERT INTO chqNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","'Wó² tyi‑o'o do mo ga'nɨɨ²¹²naa'. Joon 'e cuu²¹ gatɨ́ɨ²u tyi‑o'o jon, lí²‑i jmaa²aa' la 'iin²¹²naa'. ¿'Ee lɨ' ga'ɨ¹‑'oo' la joon? Nigafáa¹³'a coon²¹ júu³ tajuu²¹ tyani Dios jon' tyani tsá². ");
INSERT INTO chqNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Mo ganúu²un Ananías 'elo tsifu joon gacɨ'²mo jún¹mo. Jmai'² tsá² 'in gafoo'²mo mo ganúu²un 'elo. ");
INSERT INTO chqNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Joon gatyalíin² jaain²¹ gái¹ sɨmii'²¹ 'in gapaai'²¹ 'ii' 'mɨ'². Joon ngajée¹i 'ido 'ii nga'áa¹³mo. ");
INSERT INTO chqNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Jɨ 'nɨ¹ hora gangɨ́ɨ²i mo ngayuui'¹³ joon jon ga'í² 'oo²¹²o Ananías. Jo ñii¹i coonti 'ee galɨ́². ");
INSERT INTO chqNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Joon gaunngɨɨ¹ɨ Tʉ́³: ―¿Tɨ la gajin'²in do‑o gacɨ́ɨin² 'wó² ga'nɨɨ²¹ɨɨn' do? Joon gañii¹i: ―Jiin'¹³ la do‑o gacɨ́ɨin². ");
INSERT INTO chqNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Joon gasɨɨ'²¹ɨ Tʉ́³ 'ii: ―¿'Ee lɨ' gasíin¹³naa' røø²¹ 'e cóon¹³oon' 'in Espíritu Tyʉ́² tya' Ña'ñʉ'¹ʉ' Dios tóo²? Caluu no‑o nijaliin¹ 'in nga'áai¹³ ñʉʉ'¹ tyi'i. Joon 'nʉ‑gɨ 'injéi¹ 'ino. ");
INSERT INTO chqNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Tsifu joon cɨɨ'¹²i 'wii²¹² tɨɨ² Tʉ́³. Joon mo ngataai² 'in sɨmii'²¹ do joon gangaai¹ 'in tsamɨ́² ni 'lɨɨ²¹²mo jon. Joon gatyii¹i, nga'aa²mo caai¹ lɨ sɨ'aai²¹² ñʉʉ'¹ tya'a do. ");
INSERT INTO chqNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Joon jilee'²¹mo tsá² 'in jai'² lɨ́ɨi² Jesús coon'¹³ 'in galiñii¹ jilaa'²¹ 'elo gafoo'²i lɨɨlɨ¹. ");
INSERT INTO chqNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","'Láa¹mo li² coon'¹³ milagro gajmaa¹a apóstoles jee²¹² tsá². Joon galicaain²¹ tsá² coon²¹ ni'nʉ́¹ sii²¹ Salomón. ");
INSERT INTO chqNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Fúu¹mo 'in catyaai² do jo 'iin²¹²in uncaain²¹ coon'¹³ 'ii tsʉ 'wii'¹³ 'goo'²¹‑o. Pe jilee'²¹mo tsá² faa'²¹a tyʉ́²‑ʉ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Lɨ́ɨ¹ fúui¹ tsañʉʉ'¹ coon'¹³ tsamɨ́² 'in nigalijai'² lɨ́ɨi² Ña'ñʉ'¹ʉ' Jesús. ");
INSERT INTO chqNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Joon ga'wooi²¹ tsá² 'in tsatsaa'¹³ tya'i fu¹. Tya'i fu¹ tee'¹²i coo'¹³ 'mó² sɨ ni jmoo²¹ 'ee. Joon mo ngɨ́ɨ¹i Tʉ́³ fiin'¹³ jiin'¹³ tɨɨ'¹³ 'iin'³ tya'a joon 'láa²mo. ");
INSERT INTO chqNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Joon jileei'²¹ tsá² 'in seein²¹ fuu²¹ co' Jerusalén do jajée¹i tsatsaa'¹³ tya'a sɨ 'in 'yuui² 'in 'lɨɨi'³ alma tya'a 'ee joon jilee'²¹mo 'láa²mo. ");
INSERT INTO chqNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Joon ga'aa¹a tsiiwúu¹ jileei'²¹ 'in tyʉ'² to² tya' untsá² joongɨ tsá² coon²¹ poo²¹² sii²¹ saduceos. ");
INSERT INTO chqNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","'Wii'¹³ joon gasan'²mo tsá² 'in apóstoles do joon gataan'¹²in 'nʉñí³. ");
INSERT INTO chqNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Pe jaain²¹ ángel tya' Ña'ñʉ'¹ʉ' Dios ganá¹ 'e 'nʉñí³ do la 'woo¹. Joon ga'woo¹mo 'ido. Joon gasɨɨ'²¹ɨ 'in ángel do 'ii: ");
INSERT INTO chqNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―Cwolíin²naa' fu inʉʉ cwo'¹ do. Cwojmaa²aa' júu³ xiiala ngɨ¹ tsá² coon²¹ fu¹ coon²¹ tsáa¹ tya' Dios. ");
INSERT INTO chqNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Mo ganúu²un 'elo joon ngatáa¹i fu cwo'¹ do. 'Aa²¹ mo gajná² ga'láa² 'wii²¹² 'e'²e tsá². La 'ɨɨ²¹² joon 'in tyʉ'² to² tya' untsá² joongɨ 'in téein² coon'¹³on galicaain²¹ 'e Junta Suprema tya'a. ('øøi'²¹‑tsi tsá² 'e licaain²¹ jileei'²¹ tsacøø'¹³ tya' tsá² Israel.) Joon gatyʉ'²ʉ to² gajalíin² 'in apóstoles do 'in taai² 'nʉñí³. ");
INSERT INTO chqNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Mo gatyalíin² 'ɨɨ'¹³ tsi 'nʉñí³ do jo gatseei'²¹gɨ jiin'¹³ jaain²¹. Joon ngaliin¹ tún¹. ");
INSERT INTO chqNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Ngacoon¹on júu³ lɨ néei¹ tsacøøi'¹³ do gajin'²in: ―Mo gatyalii²¹i'i 'nʉñí³ do gatsaa'²¹a'a tyʉ́² sɨjnɨ¹. Joongɨ 'ooca'nʉ́² do téen²mo 'láa² 'aa¹a. Pe mo ganaa²¹²a'a jiin'¹³ jaain²¹ jo 'in seein²¹gɨ lɨ' tsi do. ");
INSERT INTO chqNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Mo ganúu²un tsacøøi'¹³ tya' untsá² coon'¹³ 'in tyʉ'² to² 'in ní² cwo'¹ do jilaa'²¹ 'elo joon gaunngɨɨ¹ɨ ruu'²¹i: ―Júu³ tya' fo'², ¿xiiala iján² jilaa'²¹ 'elo? ");
INSERT INTO chqNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","La jee²¹² joon tyía¹ jaain²¹ tsañʉʉ'¹ jin'²in: ―Inʉʉ cwo'¹ do 'yuui² 'in tsañʉʉ'¹ 'in gatai'² 'naa' 'nʉñí³ do. Do‑o 'yuu²i 'e'²e tsá² júu³ tyʉ́². ");
INSERT INTO chqNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Joon ngalíin² moyóo¹³ coon'¹³ 'ɨɨ'¹³ tya'a. Joon ngatee¹ 'ido tún¹. Jo 'ee gajmee'²¹i ni 'ido 'wii'¹³ 'goo'²¹o wana gatyuui'¹² tsá² 'ii cuun²¹². ");
INSERT INTO chqNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Mo tyaliin¹in tee¹e ngajée¹i tyani tsacøøi'¹³. Joon 'in tyʉ'² to² tya' untsá² do gajin'²in: ");
INSERT INTO chqNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","―Jna'a nigauntsaa'¹³moo'o 'naa' coonti 'e jo 'e'²gɨɨ' júu³ tya' Jesús do. Pe 'naa'gɨɨ' lɨ' cɨɨ'¹³ɨ nigajmaa²aa'. Nigarǿø¹mo la tøøi² Jerusalén coon'¹³ jilaa'²¹ 'e 'ee²ee'. Joon 'naa'oo' 'iin²¹²naa' cwo'¹ jna'a tsaa² 'e gajúin¹ 'in tsañʉʉ'¹ do. ");
INSERT INTO chqNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Joon gañii¹i Tʉ́³ coon'¹³ 'in apóstoles catyaai² do: ―'E tɨ́ɨ²mo jna'a jmoo²¹o'o nʉʉ'¹³ʉ'ʉn to² tyʉ'² Dios lagɨ to² tyʉ'² tsá². ");
INSERT INTO chqNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Dios tya' 'lɨɨ²¹² tsacøøi'¹³ tyii'i 'ii gajmaa¹a jiin'¹ Jesús 'in gajngaa'¹³naa' tsaa' crúu¹³ do. ");
INSERT INTO chqNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Joon Dios gasaa¹i 'ii 'e cwaa²¹ lɨ' cwoo²¹o tsáa¹. Joongɨ nicwo'¹o to² fee'¹ joongɨ 'e jmaa¹a tiin'¹³ tsá². Joon la joon lí²‑i jaa'²¹‑tsi jileei'²¹ tsá² Israel. Joongɨ 'iin²mo tsaa² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Faa'¹³ jna'a 'e la ja'²mo jilaa'²¹ 'elo. Joongɨ 'in Espíritu Tyʉ́² tya' Dios, 'in Dios cwóo¹i jilee'²¹ 'in nʉʉ'¹³ to² tyʉ'² Jesús, jmáa¹a júu³ 'e ja'²mo jilaa'²¹ 'elo. ");
INSERT INTO chqNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Mo núu²un jilaa'²¹ 'elo lɨ́ɨ¹ gatsá² 'nii'²¹‑tsi. Joon la mo 'iin²¹²in jnga'²mo 'ido. ");
INSERT INTO chqNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Jaain²¹ tsá² sii²¹ Gamaliel, 'in lɨ́ɨ¹i tsá² tya' fariseos, 'in tyíin¹ lɨ sɨcaain²¹ 'ido. Lɨ́ɨ¹i tɨfo'² tya' ley. 'Áa¹mo un'goo¹ tsá² 'ii. Joon garóon² lɨ tyíin¹in, joon gatyʉ'²ʉ to² ga'wooi²¹ 'in apóstoles do. ");
INSERT INTO chqNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Joon gasɨɨ'²¹ɨ 'in tyʉ'² to² do jin'²in: ―Tsá² Israel, tɨ́ɨ¹moo' 'e jmaa²aa' coon'¹³ 'in tsañʉʉ'¹ no. ");
INSERT INTO chqNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Cwotii'¹³du'‑'oo' xʉgɨ mo ngóo¹ ga'yeei'²¹ jaain²¹ tsá² sii²¹ Teudas. Tsá² tyiin²mo 'ii gajin'²in 'ña'a. Joon gajée¹i tyʉ́n² ciein¹³ lɨ́ɨ¹gɨ tsá² tya'a. Pe mo ngayuui'¹³ gajngaai'¹³ tsá² 'ii jilee'²¹mo tsá² tya'a gasojǿ¹mo. Joon gatsé¹mo jilaa'²¹. ");
INSERT INTO chqNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Mo galɨcɨɨin²¹gɨxʉ joon, mo gatáin¹ jilee'²¹ tsá² jí², ga'yeei'²¹ jaain²¹ tsá² seein²¹ Galilea sii²¹ Judas. Joon fúu¹mo tsá² gajée¹i 'ii. Pe la joon jon gajngaa'¹³mo tsá² 'ii. Joon jilee'²¹mo jon tsá² tya'a sojǿ¹mo. ");
INSERT INTO chqNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","'Wii'¹³ joon tʉ́ʉ¹naa' 'in tsañʉʉ'²¹ no. Joon jo untyíi²naa' 'ii. Wana júu³ tya' 'in tsá² lo jmai'² júu³ tya' tsá² joon tyee²¹mo jon. ");
INSERT INTO chqNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Pe wana júu³ tya' Dios jo lí² 'iin²naa'. Tɨ́ɨ¹moo', jo tɨ́ɨ¹³naa' coon'¹³ Dios. ");
INSERT INTO chqNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Joon gatɨɨ'¹²ɨ júu³ tya' Gamaliel do joon galinʉʉ'¹²ʉ jilee'²¹mo. Joon gasɨɨ²¹mo røø²¹. Joon gatø'¹ø 'in apóstoles do tún¹. Joon gajmee'²¹mo 'ido. Joongɨ gauntsaa'¹³mo 'a jo faa'²¹gɨ 'ido júu³ tya' Jesús. Joon galáa²mo. ");
INSERT INTO chqNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Joon ga'woo²¹mo 'in apóstoles do tyani tsacøøi'¹³ do. Jløø'³mo ngalíin² 'wii'¹³ Dios gacwoo¹o wa'a ganii²¹ wúu¹ 'wii'¹³ tya' Jesús. ");
INSERT INTO chqNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ca inʉʉ cwo'¹ lagɨ inʉʉ tya' tsá² jo gatʉ́²gɨ 'e 'e'²e tsá² júu³ tyʉ́². Joongɨ faa'²¹a cwáain¹ tya' Jesucristo la coon²¹ jmɨɨ²¹². ");
INSERT INTO chqNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Jee²¹² jmɨɨ²¹² joon gangafúu²mo 'in jo'¹ lɨ́ɨi². Joon 'in faa'²¹ jmíi¹ griego ga'láa² 'wii²¹² jmoo¹o tsaa² tya' 'in faa'²¹ jmíi¹ tya' tsá² Israel. Jin'²o: ―Mo jmoo¹o tsá² jmai'²xʉ la coon²¹ jmɨɨ²¹² 'in 'yiia'nɨ́ɨ² tyii'i xʉgɨ tɨ́ɨ²i gø'¹ø lagɨ 'in 'yiia'nɨ́ɨ² catyaai². ");
INSERT INTO chqNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Joon gatyʉ'² jɨ dyatuuin¹ apóstoles to² wa'a galicaain²¹ ce jileei'²¹ 'in jai'² lɨ́ɨi² do. Joon gasɨɨ'²¹ɨ: ―Jo tseein²¹ wa'a tʉʉ²¹ʉ'ʉ 'e cwoo²¹o'o júu³ tyʉ́² tya' Dios 'e jmoo²¹o'o jmai'²xʉ 'e dø'¹ tsá². ");
INSERT INTO chqNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","'Wii'¹³ joon, tsaru'¹u', 'nee'¹naa' dyái¹ tsá² jee²¹² 'naa' 'in jo cu'²‑'oo' coon'¹³, tsá² 'in 'øøi'²¹‑tsi joon 'in 'oo¹o 'ii'²¹ tya' 'in Espíritu Tyʉ́² tya' Dios. Joon cwóo¹³oo' 'ido‑o 'e to² no cwojmaa¹a jmai'²xʉ. ");
INSERT INTO chqNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Pe jna'gɨɨ'ɨ canii² 'e faa'¹³a'a fo'² joongɨ 'ee'¹³e'e jilaa'²¹ júu³ tyʉ́² tya' Dios. ");
INSERT INTO chqNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Røø²¹ gasɨ́ɨ²i jilee'²¹mo. Joon gatyii'¹³in Tée¹³, jaain²¹ 'in tsá²‑tsi Dios lɨɨlɨ¹. 'Áai¹ nʉʉ'¹³ʉn to² tyʉ'² 'in Espíritu Tyʉ́² tya' Dios. Jaain²¹gɨ 'in sii²¹ Lii²¹², coon'¹³ Prócoro, coon'¹³ Nicanor, coon'¹³ Timón, coon'¹³ Parmenas. Joongɨ jaain²¹ 'in seein²¹ fu Antioquía 'in sii²¹ Culáa¹³. Culáa¹³ do 'in niga'ii'²¹ tɨɨsi'² tya' tsá² Israel ca la mo jée¹mo. ");
INSERT INTO chqNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Joon ngajée¹i tyani 'in apóstoles do. Joon 'ii‑gɨ gafaa'²¹a júu³ tyʉ́² joongɨ gataan¹an cwoo²¹o tya' 'ido. ");
INSERT INTO chqNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Lɨ́ɨ¹ nganii'¹²i 'e júu³ tyʉ́² tya' Dios do. Joongɨ 'in jai'² lɨ́ɨi² 'in néei¹ Jerusalén lɨ́ɨ¹ ngafúu²i. Joongɨ fúu²mo untsá² tya' tsá² Israel galija'²mo lɨ́ɨi². ");
INSERT INTO chqNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","'Áa¹mo gauncoon'¹³ Dios 'e 'iin²¹²in Tée¹³ tsá². Jaain²¹ 'in 'oo¹o 'ii'²¹ tya' Dios 'ii. 'Láai² li² coon'¹³ milagro gajmaa¹a jee²¹² tsá² do. ");
INSERT INTO chqNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Joon 'inlɨ́ɨi¹³ tsá² tya' coon²¹ cwo'¹ sinagoga 'e sii²¹ Esclavos Libertados coon'¹³ 'inlɨ́ɨi¹³ tsá² seein²¹ Cirene, coon'¹³ tsá² Alejandría, coon'¹³ tsá² Cilicia, coon'¹³ 'inlɨ́ɨi¹³ tsá² seein²¹ Asia ga'láa² 'wii²¹² jo cwo'¹ júu³ ruu'²¹i coon'¹³ Tée¹³ do. ");
INSERT INTO chqNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Pe jo lí² lii'¹i 'in tsá² do coon'¹³ 'e júu³ røø²¹ 'e faa'²¹a Tée¹³ do. Jo lí² lii'¹i tsʉ Tée¹³ do faa'²¹a 'ii'²¹ tya' 'in Esíritu Tyʉ́² tya' Dios. ");
INSERT INTO chqNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Joon 'in tsá² do gatyii²¹o 'leei'¹³ 'in gafaa'²¹a júu³ tajuu²¹ jin'²in: ―Niñʉ³oo'o 'e faa'²¹ 'ido 'laa'²¹ tya' Moisés coon'¹³ Dios. ");
INSERT INTO chqNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Joon la joon gajmaa¹a gatɨ́² 'nii'²¹‑tsi tsá², coon'¹³ tsacøøi'¹³, coon'¹³ tɨfo'² tya' ley. Joon coon'¹³ la joon gasaan'² ni Tée¹³ do. Joon ngajée¹i lɨ náa¹ Junta Suprema. ");
INSERT INTO chqNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Joon ga'naa'¹²i 'inlɨ́ɨi¹³ tsá² 'in jmá² júu³ tajuu²¹ jin'²in: ―'In tsañʉʉ'¹ lo jo mo tʉʉ²¹ faa'²¹a júu³ 'laa'²¹ tya' 'e cwo'¹ nacwai'³ lo joongɨ tya' ley. ");
INSERT INTO chqNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ninʉʉ²¹ʉ'ʉn faa'²¹a 'e 'in Jesús tsá² Nazaret do 'e ifíin¹mo 'e cwo'¹ lo. Joongɨ 'e iunsɨ́ɨ²i jilaa'²¹ tɨɨsi'² tyi' 'e gacwo'¹o Moisés jna'. ");
INSERT INTO chqNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Joon 'in tyʉ'² to² do coon'¹³ jileei'²¹gɨ 'in néei¹ do mo gajǿø² ni² Tée¹³ do ganii²¹ lɨ níi¹i la lɨ ni² ángel. ");
INSERT INTO chqNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Joon 'in tyʉ'² to² tya' untsá² do gaunngɨɨ¹ɨ Tée¹³ jin'²in: ―¿Tɨ jo'¹o jilaa'²¹ 'elo? ");
INSERT INTO chqNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Joon 'ii‑gɨ gañii¹i: ―Tsaru'¹u' joongɨ jileei'²¹ tsacøøi'¹³ tyi', nʉ́ʉ²duu' 'e ifo'³oo lo. Ña'ñʉ'¹ʉ' Dios 'in tyíin¹ ñʉ'fú² ga'ee'¹²mo 'ña'a 'lɨɨ²¹² tsafeei'¹ tyi' Abraham mo gacwó²gɨta fu Mesopotamia la nʉ'gɨ itsacwaa¹a fu Harán. ");
INSERT INTO chqNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Joon gajin'² Dios sɨɨ'²¹ɨ 'ii: “Tʉ'³'ʉ goo²'o lo joongɨ jileei'²¹ ruu'²¹'u. Joon cwoo'²¹'o coon²¹ 'wó² lɨ i'é³ee lo.” ");
INSERT INTO chqNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Joon gacwo'ɨ́ɨ¹ Abraham lɨ sii²¹ Caldea. Joon gangacwaa²¹ fu lɨ sii²¹ Harán. Pe mo gajúin¹ jmii²¹ joon jajée¹mo Dios Abraham fu lɨ seen²¹naa' nano. ");
INSERT INTO chqNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Pe jo 'ee gasáa¹a coonti tya' 'ido fu lo. Jiin'¹³ coon²¹ sii'¹³xʉ lɨ sii'²¹xʉ tɨɨ²ɨ jo sá². Jiin'¹³ jo mo seen²¹mogɨ jóon¹on, joon Dios ga'ɨ́ɨ²ɨ júu³ Abraham 'e cwo'¹o jóon¹on 'e 'wó² do. ");
INSERT INTO chqNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Joon gajin'²in jon Dios sɨɨ'²¹ɨ Abraham 'e jileei'²¹ tyíi²a 'e tsacwaa²¹a goo¹o tsá² xeei'²¹ ca gatsín¹ tyʉ́n² cíein¹³ jiin²¹. Jin'²o jon inii²¹ wúu¹. Joon tsá² xee'²¹mo 'in tyʉ'² to² 'ii. ");
INSERT INTO chqNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Pe joon gajin'² Dios: “Jna‑a jmáa³aa 'ii'²¹ tya' 'in tyʉ'² to² tyíi²a do. Mi yuui'¹³ joon, joon i'woo²moo 'ido. Joon lo‑o lí² ijmáa¹a to tyiajna.” ");
INSERT INTO chqNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Dios gasɨ́ɨ²i coon²¹ júu³ jai'² coon'¹³ Abraham. Joon gatyʉ'²ʉ to² 'e jmá² 'ido li² circuncisión tya' jóon¹on. 'E li² do coon'¹³ 'e joon tɨ'²ɨ‑tsi tsá² 'e júu³ ga'ɨ́ɨ² Dios do. 'Wii'¹³ joon mo galiseein²¹ jóon¹on sii²¹ Isaac, joon gajmaa¹a Abraham 'e li² circuncisión do tya' jóon¹on. Gatyʉʉ¹ʉ loo²¹ yʉ' cúun¹ 'in xuui²¹² tsañʉʉ'¹ do. Joon Isaac‑gɨ gajmaa¹o jon 'e li² do tya' jóon¹on 'in sii²¹ Jacob. Jacob‑gɨ gajmaa¹o jon 'e li² do tya' 'in dyatuuin¹ jóon¹on 'in galiseein²¹ tya'a. Joon 'in dyatuuin¹ do‑o galɨ́ɨ¹i tsacøøi'¹³ tya' dyatun¹ poo²¹² tya' tsá² Israel 'e sá² nano. ");
INSERT INTO chqNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’'In xuui²¹² tya' Jacob do, 'in galɨ́ɨi¹ tsacøøi'¹³ tyi', ga'aa¹a tsiiwúu¹ tya' ruu'²¹i sii²¹ Sé³. Joon ga'nɨɨ¹mo 'ido tya' tsá² 'in tsalíin² Egipto. Pe Dios gauncoon'¹³ Sé³ do. ");
INSERT INTO chqNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Joon galáa²mo coon'¹³ jilaa'²¹ fa'í³ tya' 'ido. Joon gajmaa¹a 'e jmɨɨ¹gɨ‑tsi Sé³. Joon gajmaa¹a 'e gali'iin²¹²in Faraón 'ii. Faraón sii²¹ 'in rǿøi¹³ tsá² Egipto do. Joon 'in Faraón do gatyʉ'²ʉ to² 'e ga'í² Sé³ tsaa'to² tya'a. Joon gatyʉ'²ʉ Sé³ to² la tøøi² Egipto, ca jilee'²¹ tsá² néei¹ inʉʉ tya' rǿøi¹³ do gatyʉ'²ʉ Sé³ do to². ");
INSERT INTO chqNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Joon ga'í²gon 'oo² la Egipto coon'¹³ Canaán lɨ néei¹ 'lɨɨ²¹² tsacøøi'¹³ tyi'. Joon jo ñii¹gɨ 'ee dø'¹ø. ");
INSERT INTO chqNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Pe mo galiñii¹i Jacob 'e sá² trigo fu Egipto do joon gasii¹in jóon¹on 'in lɨ́ɨi¹ la lɨ́ɨ¹i tsacøøi'¹³ tyi'. Do‑gɨ ga'láa² 'wii²¹² ngalíin². ");
INSERT INTO chqNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Mo gatɨ́² tún² naa'¹³ tyalíin² do, 'in Sé³ do gajin'²o 'e ruu'²¹mo 'ido. Joon galiñii¹i 'in rǿøi¹³ tyíin¹ Egipto do xiiala nilɨ́ɨ²i tsacøøi'¹³ tya' Sé³. ");
INSERT INTO chqNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Joon gatyʉ'² Sé³ to² wa'a jalíin² jmii²¹ coon'¹³ jileei'²¹ ruu'²¹i. Gatɨ́²‑ɨ ca'no'³ cíein¹³ tsi dyiia'ñéei² tsá² coon'tya. ");
INSERT INTO chqNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","La joon galɨ́² gangó²‑o Jacob fu Egipto. Joon do‑o lɨ gajúun¹in coon'¹³ jileei'²¹ 'lɨɨ²¹² tsacøøi'¹³ tyi'. ");
INSERT INTO chqNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Joon moo¹ taai² 'in Jacob do ngalii¹gɨxʉ fu Siquem. Joon do‑o ga'áa¹i coon²¹ tsi 'aan¹ nigaló² Abraham tya' 'lɨɨ²¹² tya'a. Hamor sii²¹ 'in ga'nɨɨ¹ɨ 'e 'aan¹ do. ");
INSERT INTO chqNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’La do‑o gangó¹ ca gatsin¹ júu³ jai'² 'e gasɨ́ɨ²i Dios coon'¹³ Abraham. Tɨ'xʉ‑ʉ gangafúu²mo tsá² seein²¹ Israel lɨ nanée¹i Egipto do. ");
INSERT INTO chqNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Joon ga'í² jaain²¹ rǿøi¹³ to² Egipto do 'in jo cwii¹in 'lɨɨ²¹² Sé³ do. ");
INSERT INTO chqNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","'In rǿøi¹³ do gacon'¹on tóo² 'lɨɨ²¹² tsacøøi'¹³ tyi'. Joongɨ ga'e'²e wúu¹. Joon gatyʉ'²ʉ to² 'e tʉ́ʉ²mo 'ido la jaain²¹ xuui²¹² tsañʉʉ¹ tya'a mi liseein²¹. Joon la joon júun²mo 'ido. ");
INSERT INTO chqNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Yiia'¹³ joon galiseein²¹ Moisés, 'ii jaain²¹ yʉʉn²¹ 'in gali'iin²¹²in Dios. Gaai²¹ sɨɨ'²¹ gauncwaain²¹ tsacøøi'¹³ tya'a inʉʉ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Mo gatɨ́² 'ii'²¹ 'e gatíui² sáa³a 'ii la joon galɨ́² 'e 'ña'a 'in jamɨ́ɨ¹ɨ rǿøi¹³ do gatøø¹o 'in yʉʉn²¹ do. Joon gauncwaain²¹ lawa jóon¹‑o. ");
INSERT INTO chqNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","'Wii'¹³ joon gauntsáa¹ Moisés jilaa'²¹ 'e tɨɨ²¹i tsá² Egipto. 'Wii'¹³ joon tyʉ́²‑ʉ gatɨɨ²¹i jilaa'²¹ 'e faa'²¹a joongɨ jilaa'²¹ 'e jmoo¹o. ");
INSERT INTO chqNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Tunló¹ jiin²¹ ningóo¹ 'e seein²¹ mo gali'iin²¹²in tsafee'¹³i tsagoo¹o. ");
INSERT INTO chqNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Joon lɨ ngóo¹ do ganí² jaain²¹ tsá² Egipto taai² tɨ́ɨ¹i coon'¹³ tsagoo¹o Israel. Joon 'iin²¹²in Moisés do un'øø'¹i tsagoo¹o. Joon gacoon²¹‑o tya'a, gajngaa'¹³mo 'in tsá² Egipto do. ");
INSERT INTO chqNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Pe 'ɨ¹‑tsi Moisés 'e lí² lii'¹i tsagoo¹o tsʉ Dios nigasii¹in 'ii 'e tsaláai² 'ido. Pe tsagoo¹o do jo lɨ́ɨ²i la joon. ");
INSERT INTO chqNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Mo gajná² joon ganí² Moisés taa²i tsagoo¹o tɨ́ɨ¹i. Joon la mo 'iin²¹²in tyáai¹ 'nii²¹ joon gasɨɨ'²¹ɨ: “La 'oo'²¹ ruu'²¹moo' tɨ́ɨ¹³naa'. ¿'Ee lɨ' jmaai'¹³ ruu'²¹naa' la no?” ");
INSERT INTO chqNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Pe tsifu joon jaain²¹ 'in tɨ́ɨi¹ do ga'leei'¹³gon Moisés. Joon gasɨɨ'²¹ɨ 'ii: “¿Iin gatyʉ'² to² 'e jmaa²'a 'ii'²¹ tyii'i lawa tsaa'to²? ");
INSERT INTO chqNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Tɨ 'iin²¹²un jngaa'¹³un jna la gajngaa'¹³un 'in tsá² Egipto do tyíia²?” ");
INSERT INTO chqNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Mo ganúu²un Moisés 'elo gacwiin¹o. Ngoo²¹‑o lɨ sii²¹ Madián. Do‑o gateen¹in lawa tsá² seein²¹ lɨ wíin². Joon do‑o galiseein²¹ gái¹ jóon¹on. ");
INSERT INTO chqNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Ngó¹ Moisés coon²¹ lɨ jo 'in tsá² seein²¹ co' coon²¹ moo'²¹ sii²¹ Sinaí. Do‑o taain¹ ningóo¹ tunló¹ jiin²¹ mo gajnéi¹ jaain²¹ ángel. 'In ángel do 'yuui² coon²¹ jee²¹² 'mó² pi'³ 'e lɨ la lɨ 'e coo²¹ jɨ́². ");
INSERT INTO chqNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Joon lɨ́ɨ¹ ganga'goo²¹‑tsi Moisés mo ganí² 'edo. Joon gangatyéen¹in tyan'gɨ wa'a jǿø² tyʉ́²gɨ. Joon ganúu²un coon²¹ júu³ tya' Ña'ñʉ'¹ʉ' 'e jin'²: ");
INSERT INTO chqNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Jna‑a Dios tya' 'lɨɨ²¹² tsacøøi'¹³ tyi'i Abraham, coon'¹³ Isaac, coon'¹³ Jacob.” Tsifu joon gajlé¹mo Moisés. 'Goo'²¹‑o. Jo tá²gɨ‑tsi jǿø²ø. ");
INSERT INTO chqNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Joon gajin'² Ña'ñʉ'¹ʉ' sɨɨ'²¹ɨ 'ii: “Woo'¹³ mɨ́ɨ¹³'ɨ no, tsʉ lɨ 'øø'²¹'ø no lɨ cwaa'³mo no. ");
INSERT INTO chqNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nimóo³‑oo 'e niganí² yʉʉn²¹ tyiia wúu¹ Egipto. Ganúu³oo cɨ'²ɨ 'wii'¹³ joon gacwú¹na ilaa²¹na 'ii. Na¹du' jon. Sɨ́ɨ²na 'nʉ fu Egipto.” La joon jin'² júu³ ganúu²un Moisés. ");
INSERT INTO chqNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’Coon'¹³ 'in ángel 'in ganéi¹ tyani Moisés jee²¹² 'mó² pi'³ 'e coo²¹ do gasii¹in Dios Moisés lawa jaain²¹ tsafeei'¹ 'in jmaa¹a láa²i tsagoo¹o. Fiin'¹³ la mo jéei¹ 'in tsagoo¹o do jo mo ga'ii'²¹i 'e tyʉ'²ʉ to² 'ii. Joon nigajin'² tsagoo¹o sɨɨ'²¹ɨ 'ii: “¿Iin nigatain'² 'nʉ lawa tsaa'to² sɨ 'in jmoo¹o 'ii'²¹ 'ee?” ");
INSERT INTO chqNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moisés do ga'woo²¹i 'lɨɨ²¹² tsacøøi'¹³ tyi' Egipto do. Joongɨ gajmaa¹a jilaa'²¹ milagro coon'¹³ li² 'e fuu²¹ joon. Joongɨ lɨ ganó¹ coon²¹ jmɨ'ñi'³ sii²¹ Mar Rojo. Joongɨ gajmaa¹a milagro lɨ caain²¹ lɨ jo 'in tsá² seein²¹ do la jee²¹² tunló¹ jiin²¹. ");
INSERT INTO chqNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","'In Moisés do gasɨɨ'²¹ɨ tsá² Israel: “Dios ityii'¹³in jaain²¹ la 'oo'²¹ jee²¹² ruu'²¹naa' 'in cwo¹ júu³ tyʉ́² tya'a jee²¹² 'naa'. Jiin'¹³ la 'ii'²¹ 'oo² jna‑a jon i'aa¹a.” ");
INSERT INTO chqNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Gateen¹in 'in Moisés lo coon'¹³ tsá² Israel 'e lɨ jo 'in tsá² seein²¹ do. Mo gafee'¹i 'in ángel do Moisés lɨ' moo'²¹ sii²¹ Sinaí, Moisés‑gɨ gasɨɨ'²¹ɨ 'lɨɨ²¹² tsacøøi'¹³ tyi' 'e júu³ do ga'ɨ́ɨ²ɨ tya' xiiala 'e téein² tsá² tyʉ́². Coon'¹³ la joon ga'ii'¹³naa' 'e júu³ do. ");
INSERT INTO chqNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Pe 'lɨɨ²¹² tsacøøi'¹³ tyi' jo gali'iin²¹²in núu²un. Joon gajíi²mo Moisés. Joon la mo 'iin²¹²in 'lɨɨ²¹² tsácøøi'¹³ tyi' tsaliin¹ fu Egipto tún¹. ");
INSERT INTO chqNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Joon gasɨɨ'²¹ɨ 'in tsá² do Aarón: “Ii²¹i'i jmee'¹²un dioses tyii'i 'in tsalíin² jee²¹² jna'a. Tsʉ jo nee²e'e 'ee galɨ́ɨi¹ 'in Moisés 'in ga'wooi¹ jna'a Egipto do.” ");
INSERT INTO chqNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Joon gajmee¹i jaain²¹ joo'²¹ xuui²¹² ilɨ́ɨ¹i la lɨ́ɨi¹ fii'²¹² tya'a. Joon gajngaa'¹³i joo'núu³ 'e cwooi'¹³ 'in fii'²¹² tya'a 'in lɨ́ɨi¹ joo'²¹ xuui²¹² do. Joon gajmaa¹a jløø'³i coon'¹³ 'e nigajmeei¹ coon'¹³ cwoo²¹o do. ");
INSERT INTO chqNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Joon gatʉ́ʉ²mo Ña'ñʉ'¹ʉ' Dios. Joon ga'láa² 'wii²¹² fee'¹i jiin'¹³ nʉ́ʉ¹ 'in 'ii'¹³ yʉ' juncwii²¹. La gajin'² ni jí² tya' 'in cwo¹ júu³ tyʉ́² tya' Dios: 'Naa', tsá² Israel, jin'² Dios: ¿Tɨ gacwooi'¹³naa' jna 'in joo'núu³ 'in nigajngaa'¹³naa' do la 'ɨɨ²¹² taan²¹²naa' tunló¹ jiin²¹ lɨ jo 'in tsá² seein²¹ do? ");
INSERT INTO chqNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Jon'on la joon. Gatyii²ii' capillas pi'³ tya' dios tyii' 'in sii²¹ Moloc, joongɨ nʉ́ʉ¹ tya' dios 'in sii²¹ Renfán. 'Ii gajmee²¹²naa' yaanaa' ifoo'¹³naa'. 'Wii'¹³ joon i'woo²moo 'naa' fu goo²oo'. Joon sɨ́ɨ³na 'naa' ca lɨ ngɨ́ɨi¹gɨ fuu²¹ Babilonia. ");
INSERT INTO chqNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","’Mo gatéein² 'lɨɨ²¹² tsacøøi'¹³ tyi' 'e cwoo'¹³ tyʉʉn²¹ lɨ jo 'in tsá² seein²¹ do ga'oo¹o coon²¹ 'nʉ́¹ 'mɨ'² 'e lɨ la lɨ cwo'¹ tya'a lɨ 'maa¹a jilaa'²¹ cuun²¹² toon²¹² ley. Moisés gajmaa¹a 'e 'nʉ́¹ 'mɨ'² do la lɨ́² 'e niganii²¹, jiin'¹³ la nigatyʉ'² Dios to² 'e jmáa¹a. ");
INSERT INTO chqNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","'In 'lɨɨ²¹² tsacøøi'¹³ tyi' ga'ii'²¹mo 'e 'nʉ́¹ 'mɨ'² do. Joon gacoon²¹‑o mo galɨ'²ɨ 'e 'wó² do coon'¹³ tsafeei'¹ tya'a Josué. Dios ga'wooi²¹ 'in mo néei¹ 'e 'wó² do, joon gacwo'¹o 'ii‑o. La joon ngó¹ ca la mo ga'í² 'lɨɨ²¹² rǿøi¹³ David to². ");
INSERT INTO chqNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dios gali'iin²¹²in David. Joon David‑gɨ gali'iin²¹²in jmaa'¹²a coon²¹ cwo'¹ lɨ seein²¹ Dios tya' 'lɨɨ²¹² Jacob. ");
INSERT INTO chqNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Pe jóon¹ David sii²¹ Salomón²‑mo gamaa'¹³a 'e cwo'¹ do cwáai¹ tya' David. ");
INSERT INTO chqNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Pe Dios, 'in fee'¹mo, jiin'¹³ ñʉ'fú² tyíin¹in jo tyíin¹in cwo'¹ jmoo¹o tsá². Jiin'¹³ la gajin'² 'in cwo¹ júu³ tyʉ́² tya' Dios do: ");
INSERT INTO chqNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","50","Ñʉ'fú²‑u tyíin¹na jon, jin'² Dios. Jiin'¹³ coon²¹ 'nʉ́¹ jo lí² jmaa'¹³'a tyiia, jin'² Dios. Jon'gɨ 'án³ lɨ 'ii'²¹ 'woo'²¹oo 'ná²‑a, tsʉ jilaa'²¹ 'e sá² jna‑a gajmáa³aa. ");
INSERT INTO chqNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","’Pe 'naa'gɨɨ' ―jin'² Tée¹³ do― coon²¹ tøø²mo najmaa²aa' 'waa'²¹‑'oo'. Sá² loocwoo¹oo' pe jo nuu²uun' joon alma tyii' lawa'a jo cwii¹naa' Dios. Jo nʉʉ'¹³ʉʉn' jon'gɨ jmaa²aa' la to² tyʉ'² 'in Espíritu Tyʉ́² tya' Dios. Røø²¹ lɨ́ɨ¹naa' coon'¹³ 'lɨɨ²¹² tsacøøi'¹³ tyii'. ");
INSERT INTO chqNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","'Lɨɨ²¹² tsacøøi'¹³ tyii' do gamee'²¹mo jileei'²¹ 'in cwo¹ júu³ tyʉ́² calɨɨ do. 'Ii‑o gajngaa'¹³i 'in gajin'² 'e ijó¹ jaain²¹ 'in jmá¹ 'ii'²¹ røø²¹. Joon mo gajó² 'in jmá¹ 'ii'²¹ røø²¹ do 'naa'gɨɨ' gajaan'¹³moo' joongɨ gajngaa'¹³moo'. ");
INSERT INTO chqNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Fiin'¹³ niga'ii'¹³naa' 'e ley do coon'¹³ 'ii'²¹ tya' ángel pe jo galinʉʉ'¹³ʉʉn'. Jilaa'²¹ 'elo gajin'² Tée¹³ do. ");
INSERT INTO chqNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Pe joon jileei'²¹ 'in néei¹ do mo ganúu²un 'elo gatsá² 'nii'²¹‑tsi. Joon gacuu'²¹i moojóon¹on lɨɨlɨ¹. ");
INSERT INTO chqNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Pe Tée¹³ do røø²¹mo 'in Espíritu Tyʉ́² tya' Dios gajǿø²ø lɨ' yʉ'. Joon ganii²¹o xiiala jná² joo'²¹ Dios. Joon do‑o siin'¹² Jesús lɨ' cwoo²¹ Dios tsáa¹ coon'¹³ jilaa'²¹ 'ii'²¹ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Joon gajin'² Tée¹³: ―¡Jǿø²duu'! Jǿø³oo sɨno² 'oo² ñʉ'fú². Joon do‑o máa¹moo Jesús, 'in Ruu'²¹i Tsá², siin'¹³mo lɨ' caai¹ Dios Jmii²¹ tsáa¹. ");
INSERT INTO chqNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Pe 'in tsá² do jo taa'²¹gɨ núu²un. Joon gajnii¹o loocwóo¹o joon ga'oo¹o tá² lɨɨlɨ¹. Canii² ngalíin² cwiin¹in gasan'²mo 'ido. ");
INSERT INTO chqNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Joon gatyii¹mo 'ido 'e fuu²¹ do. Joon gatyuu'¹²i cuun²¹² lɨɨlɨ¹. 'In gafaa'²¹a 'laa'²¹ tya' 'ido gasáa¹o sɨɨn'¹³ɨn 'e jǿø²ø jaain²¹ tsañʉʉ'¹ 'in sii²¹ Saulo. ");
INSERT INTO chqNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Joon la 'ɨɨ²¹² tyuui'¹² tsá² 'ii cuun²¹² joon gasɨɨ'²¹ɨ Tée¹³ Jesús jin'²in: ―Ña'ñʉ'¹ʉ' Jesús, 'ii'¹³ alma tyiia. ");
INSERT INTO chqNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Mo ngayuui'¹³ lo gasii'²¹i wojníi¹i, joon ga'oo¹o tá² lɨɨlɨ¹ jin'²in: ―Ña'ñʉ'¹ʉ', jo cwo'²'o tsaa² tya'a 'e jmoo¹o lo. Mo ngayuui'¹³ gafaa'²¹a 'elo tsifu joon jún¹mo. ");
INSERT INTO chqNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Røø²¹ gasɨ́ɨ²i Saulo 'e gajúin¹ Tée¹³ do. Joon 'inlɨɨi¹³ tsá² 'in 'iin²¹²in Dios ganga'áa¹²mo Tée¹³ do. 'Áa¹mo galixuui²¹²‑tsi tya' 'ido. Jee²¹² jmɨɨ²¹² joon ga'láa² 'wii²¹² gajmee'²¹i tsá² lɨɨlɨ¹ jileei'²¹ 'in jo'¹ lɨ́ɨi² néei¹ Jerusalén. Jilee'²¹mo 'in jai'² lɨ́ɨi² ga'woo²¹mo Jerusalén. Ngalíin² la caain²¹ Judea coon'¹³ Samaria. Jiin'¹³ apóstoles do gajan¹gɨ. ");
INSERT INTO chqNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","La 'ɨɨ²¹² joon 'ǿø¹mo Saulo jileei'²¹ 'in jai'² lɨ́ɨi². Tsa'ii²¹ la coon²¹ 'nʉ́¹ la coon²¹ 'nʉ́¹‑ʉ jnúu¹i la tsañʉʉ'¹ tiin'¹³ la tsamɨ́². 'Woo¹i tsataa'¹²i 'nʉñí³. ");
INSERT INTO chqNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Pe 'in ga'woo²¹i Jerusalén do gatya¹o júu³ tya' xiiala 'e tiin'¹³ tsá² doñixiia' tyalíin². ");
INSERT INTO chqNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Jaain²¹ jee²¹² 'ii do, 'in sii²¹ Lii²¹², gangóo¹on coon²¹ fuu²¹ náa¹ lɨ sii²¹ Samaria. Joon ga'láa² 'wii²¹² faa'²¹a tya' Cristo do. ");
INSERT INTO chqNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Fúu¹mo tsá² galicaain²¹ nuu¹un coon'²¹ tún²‑un 'e faa'²¹a Lii²¹² do. Joon gajǿø²o jilaa'²¹ li² 'e jmoo¹o coon'¹³ milagro. ");
INSERT INTO chqNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Fúu¹mo 'in taai² 'in 'lɨɨi'³ alma tya'a 'woo²¹mo. Joon 'in 'lɨɨi'³ 'in 'wooi²¹ do ga'oo¹o lɨɨlɨ¹. Joongɨ fúu¹mo 'in sɨtsʉʉ'¹³ cwoo²¹ tɨɨ² coon'¹³ 'in jluui'¹³ ga'láa²mo. ");
INSERT INTO chqNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","'Wii'¹³ joon jløø'³mo jilee'²¹mo 'in néei¹ 'e fuu²¹ do. ");
INSERT INTO chqNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Pe seein²¹ jaan²¹ tsá² 'e fuu²¹ do 'in sii²¹ Simóoi¹³ 'in gauntsáa¹ júu³ loo¹ ca la jéei¹gɨ. Jin'²o 'ña'a jon 'e jaain²¹ tsá² tyiin²mo 'ii. ");
INSERT INTO chqNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Jilee'²¹mo nuu¹un coon'¹³ tún²‑un la tsacøøi'¹³ tiin'¹³ la 'in xuui²¹²gɨ. Jin'²o 'e coon'¹³ 'ii'²¹ fee'¹ tya' Dios ngɨ¹ 'in tsalaai¹ no. ");
INSERT INTO chqNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Jo'¹o lɨ́ɨi² tsá² 'ii tsʉ 'wii'¹³ ningóo¹o ungøø¹i tsá² coon'¹³ jilaa'²¹ júu³ loo¹ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Pe mo galɨ́ɨi² tsá² jo'¹o júu³ tya' Lii²¹² do fúu¹mo 'in gasaai¹ jmɨɨ²¹ la tsañʉʉ'¹ tiin'¹³ la tsamɨ́². Cwoo¹ Lii²¹² do júu³ tya' xiiala tyʉ'² Dios to² tsá². Júu³ tyʉ́² tya' Jesucristo cwoo¹o. ");
INSERT INTO chqNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Joon 'in Simóoi³ do jo'¹o jon galɨ́ɨ²i. Joon gasaa¹mo jmɨɨ²¹. Ga'láa² 'ido 'wii²¹² ngɨɨ¹ coon'¹³ Lii²¹² do. Lɨ́ɨ¹ tsa'goo²¹‑tsi jilaa'²¹ milagro coon'¹³ li² 'e jmoo¹o 'ido. ");
INSERT INTO chqNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Mo galiñii¹ 'in apóstoles néei¹ Jerusalén 'e ninúu²o júu³ tya' Dios 'in néei¹ Samaria do joon gasii¹in Tʉ́³ coon'¹³ Wó³. ");
INSERT INTO chqNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Joon mo gatyalíin² do gafee'²¹i Dios 'wii²¹² tya' 'in jo'¹ lɨ́ɨ²i do 'e cwooi'¹³ Dios 'ii 'in Espíritu Tyʉ́² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Tsʉ jo mo 'í²gɨ Espíritu Tyʉ́² tya' Dios jiin'¹³ jaain²¹. Lɨ coon'²¹ nisaa¹mo jmɨɨ²¹ jiin'¹³ coon'¹³ la sii²¹ Ña'ñʉ'¹ʉ' Jesús‑gɨ. ");
INSERT INTO chqNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Joon gataan¹an Tʉ́³ coon'¹³ Wó³ cwoo²¹o tya' 'ido. La joon ga'ii'²¹i Espíritu Tyʉ́² tya' Dios. ");
INSERT INTO chqNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","19","Mo ganí² Simóoi¹³ 'e ga'í² Espíritu Tyʉ́² tya' tsá² mo gataan¹an apóstoles cwoo²¹o joon gajin'²in sɨɨ'²¹ɨ 'in tsá² tya' Jesús do: ―Cwóo³‑oo cuu² wa'a cwoo²oo' jna 'ii'²¹ 'e ilí² jmáa³aa la no. Joon mi tón³oon cwóo³oo tya' doñi'iin joon 'ii'²¹mo jon 'in Espíritu Tyʉ́² tya' Dios ―gajin'² Simóoi¹³ do. ");
INSERT INTO chqNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Joon gajin'² Tʉ́³ sɨɨ'²¹ɨ 'ii: ―Cwo'iin²mo cuu²'u la tyan 'wo'o coon'¹³ lɨ 'ii²¹ tsʉ 'wii'¹³ ga'ɨ¹‑'o'o 'e jilaa'²¹ 'e cwo¹ Dios lí²‑i ló¹ tsá² coon'¹³ cuu². ");
INSERT INTO chqNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Jo tɨ́ɨi² 'nʉ coonti 'e to² lo jon'gɨ lí² jmáa³aa tsʉ jo tsáa¹ 'ɨ¹‑'o'o tyani Dios. ");
INSERT INTO chqNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Cwojaa'²¹‑'o'o 'e gó² jmoo²'o no. Mɨ́²'ɨ tyani Dios wa'a i'iin²mo tsaa² tyi'i jilaa'²¹ 'e gó² 'ɨ¹‑'o'o no. ");
INSERT INTO chqNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Galili'³oo 'e 'áai¹ ngɨ́²'ɨ tsiiwúu¹'u. 'Áa¹mo røø²¹u tsaa². ");
INSERT INTO chqNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Joon gajin'² Simóoi¹³ do: ―Mɨ́²ɨɨ' tyani Ña'ñʉ'¹ʉ' 'wii²¹² tyiia 'e jo 'ee cwotyangɨ́ɨ¹na coonti jilaa'²¹ 'e nifáa¹³aa' no. ");
INSERT INTO chqNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Mo ngayuui'¹³ gafaa'²¹a 'in tsá² tya'Jesús do jilaa'²¹ 'e ganii²¹ coon'¹³ jilaa'²¹ júu³ tyʉ́² tya' Dios ngalíin² la caain²¹ fuu²¹ pi'³ lɨ sii²¹ Samaria do. Ngacwoo¹ júu³ tyʉ́² tya' xiiala tiin'¹³ tsá². Joon ngaliin¹in tún¹ fu Jerusalén. ");
INSERT INTO chqNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Mo ngayuui'¹³ jilaa'²¹ 'elo jaain²¹ ángel tya' Ña'ñʉ'¹ʉ' gasɨɨ'²¹ɨ Lii²¹²: ―Ráan²un no, cwó² lɨ' tooin²¹² lɨ yooin'¹³ ñi'¹. Cwoo'¹²'o fu¹ ngóo¹ Jerusalén tyíia¹³ fu Gaza. 'E fu¹ do‑o ngɨ́ɨi¹ lɨ' cwoo'¹³ tyʉʉn²¹. ");
INSERT INTO chqNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Garoon¹on Lii²¹² joon ngó¹‑o. Joon 'yuu²i fu¹ lɨ ngóo¹ do joon gatsee'²¹i jaain²¹ tsá² te'² 'in seein²¹ Etiopía. Jaain²¹ tsá² tyiin² 'in 'má¹ cuu² tya' tsamɨ́² sii²¹ Candace 'in tyʉ'² to² tyíin¹ Etiopía lawa rǿøi¹³. Ngafee'¹²i Dios fu Jerusalén. ");
INSERT INTO chqNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","'In tsañʉʉ'¹ lo ningaa'¹²i fu goo¹o. 'Yuu²i coon²¹ tsi care'³ tya'a. Ngaa'¹²i untsáa¹a júu³ tya' Dios 'e gataan¹an 'lɨɨ²¹² Isaías ni mo'jí². Isaías do‑o jaain²¹ 'in gacwo¹ júu³ tya' Dios calɨɨ. ");
INSERT INTO chqNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Joon gajin'² Espíritu Tyʉ́² do sɨɨ'²¹ɨ Lii²¹²: ―Cwotyéen¹'un lɨ si'² care'³ do. ");
INSERT INTO chqNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Joon mo ngatyéein¹ Lii²¹² do joon ganúu²un 'e untsáa¹ 'ido jí² tya' Isaías do. Joon gaunngɨɨ¹ɨ 'ido: ―¿Tɨ 'øøi'²¹‑'o'o 'e untsáa¹'a no? ");
INSERT INTO chqNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Joon gajin'² 'in tsañʉʉ'¹ do: ―¿Xiiala lí² 'øøi'²¹‑tsii mo jo seein²¹ wa'a 'in cwo'¹ jna cwáain¹? Wúu² no, 'yii²¹a' coon'¹³ jna. ");
INSERT INTO chqNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Jee²¹² jí² tya' Dios lɨ untsáa¹ do jin'² la no: Lawa jaain²¹ joo'saa'²¹ 'in jéei¹ tsá² jngaa'¹³i sɨ 'in joo'saa'²¹ yʉʉn²¹ 'in gajan¹ tii² tyani 'in tyʉ'² jnʉ́², la joon jo 'ee gajin'²gɨ coonti. ");
INSERT INTO chqNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Fiin'¹³ jo tsaa² 'oo¹o pe ngoo²¹‑o tyani 'in 'oo¹o to². Pe jo 'ii'²¹ galisá² tya'a. ¿Xiiala lí² tyá² tsá² júu³ jilaa'²¹ 'e gó² gajmaa¹a tsá² goo¹o tya'a? Tsʉ gajngaa'¹³mo. Jo seein²¹gɨ juncwii²¹. ");
INSERT INTO chqNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Joon 'in tsá² tyiin² do gaunngɨɨ¹ɨ Lii²¹²: ―Jmaa² feei'¹‑'o'o sii'¹³du' jna, ¿'iin cwáain¹ tya'a faa'²¹a 'in cwo¹ júu³ tyʉ́² lo? ¿Tɨ tya' 'ña'a sɨ tya' 'inxeei'²¹ 'ee? ");
INSERT INTO chqNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Joon ga'láa² Lii²¹² doo 'wii²¹² faa'²¹a 'e lɨ untsáa¹ do. Joon ga'e'²e jilaa'²¹ júu³ tya' Jesús. ");
INSERT INTO chqNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Joon mo gangɨ́ɨ¹i coon²¹ lɨ sá² jmɨɨ²¹ 'in tsá² tyiin² do gajin'²in: ―Lo‑o sá² jmɨɨ²¹. ¿Tɨ jo lí² saa²¹na jmɨɨ²¹? ");
INSERT INTO chqNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Lii²¹²gɨ gasɨɨ'²¹ɨ 'ii: ―Wa jai'² lɨ́ɨ²u ce caain²¹‑'o'o, lí²‑i. Joon gañii¹i 'in tsañʉʉ'¹ do: ―Lɨ́ɨ²moo 'e Jóon¹ Dios Jesucristo. ");
INSERT INTO chqNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Joon gatyʉ'²ʉ to² wa'a jan¹ care'³ do. Joon gajngá¹mo lɨ sá² jmɨɨ²¹ do. Joon gasaa¹i Lii²¹² 'ii jmɨɨ²¹. ");
INSERT INTO chqNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Mo ga'woo¹i lɨ sá² jmɨɨ²¹ do 'e gatøø²¹o 'in Espíritu Tyʉ́² tya' Ña'ñʉ'¹ʉ' Lii²¹² do. Joon 'in tsá² tyiin² do jo ganíi²gɨ 'ii. Pe ngoo²¹‑o la fu¹ 'yuu²mo. Tyʉ́²‑ʉ ga'ɨ́ɨ²‑tsi. ");
INSERT INTO chqNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Coon²¹ fuu²¹ lɨ sii²¹ Azoto gajnéi¹ Lii²¹² do. Ngoo²¹‑o la coon²¹ fu¹ 'ee¹e júu³ tya' xiiala 'e tiin'¹³ tsá² ca gatyíi¹a coon²¹ fuu²¹ sii²¹ Cesarea. ");
INSERT INTO chqNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","La 'ɨɨ²¹² joon jo mo jan¹ Saulo do toon'²¹on fo'²‑tsi tsá². 'Iin²¹²in jnga'²mo 'in jo'¹ lɨ́ɨi² Ña'ñʉ'¹ʉ' Jesús. ");
INSERT INTO chqNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","'Wii'¹³ joon gamɨɨ¹ɨ coon²¹ jí² tyani tsaa'to² tya' untsá². 'Iin²¹²in tsáa¹a coon²¹ fuu²¹ sii²¹ Damasco tsa'nee'¹²i 'in jai'² lɨ́ɨi² tsi inʉʉ cwo'¹ sinagogas si'² 'e fuu²¹ do. Tsatee²i taan'¹in 'nʉñí³ fu Jerusalén do la tsañʉʉ'¹ tiin'¹³ la tsamɨ́². ");
INSERT INTO chqNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Pe la 'ɨɨ²¹² ngóo¹ tya'i fu¹ do lɨ tɨ́² lɨ tyíia¹ fuu²¹ Damasco. Joon coon²¹ gajná² joo'²¹ co' lɨ ngóo¹on. Coon²¹ 'yiia²¹ jó² fu ñʉ'fú². ");
INSERT INTO chqNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Joon gacɨ'²mo Saulo ni 'wó². Joon ganúu²un coon²¹ júu³ 'e jin'²: ―Saulo, ¿'ee lɨ' 'øø²¹u jna? ");
INSERT INTO chqNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Joon Saulo‑gɨ gañii¹i: ―¿'Iin 'nʉ, Señor? Joon ganii¹i 'e júu³ do: ―Jna‑a Jesús 'in 'øø²¹u no. 'Woo²¹‑'o'o jmaai'²¹ 'wo'o la mo jmoo¹o joo'²¹ jɨɨ¹ mo 'ø'²ø nii²¹² 'mó² sʉʉn'²¹. ");
INSERT INTO chqNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Saulo do‑gɨ gajlée¹i 'goo'²¹o. Gajin'²in: ―Ña'ñʉ'¹ʉ', ¿'ee 'iin²¹²un jmáa³aa? Joon Ña'ñʉ'¹ʉ' Jesús gasɨɨ'²¹ɨ 'ii: ―Ráan²un no. Cwoo'¹'u 'e fuu²¹ do. Do‑o ijin'²in 'ee 'ná¹ jmaa²'a. ");
INSERT INTO chqNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Jileei'²¹ 'in tsañʉʉ'¹ 'in ngalíin² coon'¹³ Saulo do lɨ́ɨ¹ gafoo'¹i. Ganúu²un 'e júu³ do pe jo 'iin ganíi²in coonti. ");
INSERT INTO chqNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Joon garóon²on tún¹ Saulo lɨ raain¹ ni 'wó² do, pe mo gatyaa¹i unníi¹i jo lí² jǿø²gɨ. La joon ngóo¹ fu Damasco san'² tsá² cwoo²¹o. ");
INSERT INTO chqNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Do‑o gateein¹ 'nɨ¹ jmɨɨ²¹² tiui². Jo 'ee gø'²ø jon'gɨ 'uun'²¹un coonti. ");
INSERT INTO chqNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Fuu²¹ do‑o seein²¹ jaain²¹ 'in jo'¹ lɨ́ɨi² sii²¹ Ananías. Joon ganéi¹ Jesús tyaníi¹i lawa tsacɨ¹. Joon gasɨɨ'²¹ɨ 'ii: ―¡Ananías! Joon 'ii‑gɨ gañii¹i: ―Lo‑o tyíin¹³na, Ña'nʉ'¹ʉ'. ");
INSERT INTO chqNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Joon Ña'ñʉ'¹ʉ' gasɨɨ'²¹ɨ 'ii: ―Ráan²un, cwó² fu calle sii²¹ Coon²¹ Tsáa¹ no. Joon mo tyii'¹²'a tya' jaain²¹ 'in sii²¹ Judas fu'³'u wa'a tyíin¹ jaain²¹ tsá² Tarso sii²¹ Saulo. Do‑o tyíin¹in fee'¹i Dios. ");
INSERT INTO chqNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Lawa 'e cɨ¹o niganíi²in jaain²¹ tsá² sii²¹ Ananías ga'í² lɨ tyíin¹in joon gataan¹an cwoo²¹o tya'a 'e lí²‑i jǿø² tún¹. ");
INSERT INTO chqNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Mo ganúu²un Ananías 'elo gajin'²in: ―Ña'ñʉ'¹ʉ', fúu¹mo 'in nigatya¹ júu³ tya' 'in tsañʉʉ'¹ no. Joongɨ ninúu³oo jilaa'²¹ 'e gó² jmoo¹o tya' 'in jai'² lɨ́ɨi² 'nʉ 'in néei¹ Jerusalén. ");
INSERT INTO chqNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","'E joon gajó² Saulo do la to² tyʉ'² untsá² 'e tøø¹ø 'nʉñí³‑i jileei'²¹ 'in fee'¹i 'nʉ. ");
INSERT INTO chqNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Pe Ña'ñʉ'¹ʉ' gasɨɨ'²¹ɨ 'ii: ―Cwó², tsʉ nityíi'¹³moo 'ido 'e cwoo¹o júu³ tyiia tya' tsá² seein²¹ fuu²¹ lɨ xiia'gɨ, joongɨ tyani rǿøi¹ coon'¹³ tsá² Israel. ");
INSERT INTO chqNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Jna‑a jmáa³aa 'ii'²¹ xiiati wúu¹ inii²¹ wii²¹² tyiia. ");
INSERT INTO chqNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Joon ngóo¹ Ananías fu lɨ tyíin¹ Saulo do. Mo gatan¹an cwoo²¹o tya' 'ido joon gajin'²in: ―Ru'¹u' Saulo, 'in Ña'ñʉ'¹ʉ' Jesús 'in gajnéi¹ tya'i fu lɨ ñi'¹'i do, 'ii gasii¹in jna ijmáa³aa 'e jøø²'ø tún¹ joongɨ 'e unrøø¹i 'in Espíritu Tyʉ́² tya' Dios alma tyi'i. ");
INSERT INTO chqNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Tsifu joon gaxʉʉ'²¹ 'e lɨ la lɨ wii'³ joo'²¹ taai² jmɨɨ²¹ unníi¹i. Joon gajǿø³o røø²¹ tún¹. Mo ngayuui'¹³ joon garoon¹on joon gasaai¹ jmɨɨ²¹. ");
INSERT INTO chqNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Mo gøø'²¹ø 'íi¹i joon gacoon²¹o waa'²¹ pí² tya'a. Joon gajaan¹gɨxʉ coon²¹ tún² jmɨɨ²¹²gɨ coon'¹³ 'in jai'² lɨ́ɨi² néei¹ Damasco do. ");
INSERT INTO chqNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Tsifu ga'láa² Saulo 'wii²¹² cwoo¹o júu³ tyʉ́² tya' Jesús la caain²¹ inʉʉ cwo' sinagoga tya' tsá² Israel. 'Ee¹o 'e Jóon¹ Dios Jesús. ");
INSERT INTO chqNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Lɨ́ɨ¹ tsa'goo²¹‑tsi jileei'²¹ 'in nuu¹un júu³ tya'a. Joon sɨ́ɨ¹i: ―¿Tɨ jon' 'in no 'in gangɨ¹ 'ǿøi¹ 'in jai'² lɨ́ɨi² Jesús 'in néei¹ Jerusalén do? ¿Tɨ jon' 'in no‑o 'in jó² jatee¹e tsá² tsajaan'¹²in tyani tsaa'to² tya' untsá² do? ");
INSERT INTO chqNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Pe coon'²¹ 'ii'¹³gɨ jo 'goo'²¹ Saulo gacwoo¹o júu³ tyʉ́². 'Ee¹e 'e Jesús do‑o 'e la jai'² 'ii 'in nigasii¹in Dios 'e ijmáa¹a tiin'¹³ tsá². Lɨ́ɨ¹ gafaa'²¹a Saulo ca gaxéi¹‑tsi tsá² Israel néei¹ Damasco do. ");
INSERT INTO chqNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Wóo²gɨxʉ ngó¹ mo gasɨ́ɨ²i tsá² Israel røø²¹ 'e ijnga'²mo Saulo. ");
INSERT INTO chqNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","La coon²¹ jmɨɨ¹ la coon²¹ 'woo¹ tsajeen² ni 'ido 'oo² lɨ suui²¹ 'e fuu²¹ do 'e ijngaa'¹³mo 'ido. Pe 'indogɨ galiñii¹o. ");
INSERT INTO chqNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Pe 'in jai'² lɨ́ɨi² do coon²¹ 'woo¹ gataan'¹³ ni 'ido coon²¹ tsi 'motó³. Joon la joon gaxáa² ni 'ido lɨ' coon²¹ tsaa' 'oo²¹ lɨ injuun¹ la 'ui tɨ' fuu²¹ do. Joon la joon galáa²mo Saulo do. ");
INSERT INTO chqNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Mo gatyía¹ Saulo Jerusalén joon 'iin²¹²in uncaain²¹ coon'¹³ 'in jo'¹ lɨ́ɨi² do. Pe jilee'²¹mo tsá² 'gøø'²¹mo 'ii. Jo jo'¹ lɨ́ɨi² 'e nija'²mo lɨ́ɨi² 'ido Jesús. ");
INSERT INTO chqNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Joon gajée¹mo Bernabé Saulo tyani 'in apóstoles do. Joon do‑o gatya¹o júu³ xiiala niganíi² Saulo Ña'nʉ'¹ʉ' Jesús tya'i fu¹ do. Joongɨ xiiala nigasɨɨ'²¹ Jesús 'ii. Joon gajin'²o jon xiiala jo cu'²‑tsi Saulo gacwoo¹o júu³ tya' Jesús fu Damasco. ");
INSERT INTO chqNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Mo ngayuui'¹³ joon gajaan¹an Saulo Jerusalén do. Caan²¹mo gangɨɨ¹ɨ coon'¹³ 'in jai'² lɨ́ɨi² catyaai² do. ");
INSERT INTO chqNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Jo cu'²‑tsi faa'²¹a júu³ tya' Ña'ñʉ'¹ʉ' Jesús. Tyaa¹a júu³ joongɨ jo cwo'¹o júu³ ruu'²¹i coon'¹³ tsá² Israel 'in faa'²¹a jmíi¹ griego. Pe 'ii‑gɨ ga'noo'¹²on xiiala 'e ijngaa'¹³i 'ii. ");
INSERT INTO chqNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Mo galiñii¹i 'in jai'² lɨ́ɨi² Jesús catyaai² do ngajée¹i Saulo coon²¹ fuu²¹ sii²¹ Cesarea. Joon do‑gɨ ganga'²mo fu Tarso. ");
INSERT INTO chqNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Jilee'²¹mo 'in jo'¹ lɨ́ɨi² jo 'iin 'in untyíin²gɨ 'ii la caain²¹ Judea, coon'¹³ Galilea coon'¹³ Samaria. Tya¹‑tsi lɨɨlɨ¹ 'e lí² jai'²gɨ lɨ́ɨi². Seein²¹ canii² gøø'²¹mo Ña'nʉ'¹ʉ' Jesús. Joon gauncoon'¹³ 'in Espíritu Tyʉ́² 'ii 'e seen²¹mo jløø'³mo. Joon gangafúu²mo 'in jai'² lɨ́ɨi². ");
INSERT INTO chqNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","La 'ɨɨ²¹² ngɨ¹ Tʉ́³ fee'¹i tsaru'¹u' la caain²¹ joon ngóo¹‑o ngafee'¹²i 'in jai'² lɨ́ɨi² néei¹ Lida. ");
INSERT INTO chqNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Joon do‑o gatsee'²¹i jaain²¹ tsá² sii²¹ Eneas. Jñá² jiin²¹ ningóo¹ raan¹in coo'mó² 'wii'¹³ jleei¹ sɨtsʉʉ'¹³ cwoo²¹o tɨɨ²ɨ. ");
INSERT INTO chqNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Joon gajin'² Tʉ́³ sɨɨ'²¹ɨ 'ii: ―Eneas, coon²¹ gaun'láa²mo Jesucristo 'nʉ. Ráan²un no. Tsʉʉ'¹³ 'mɨ'jñʉ¹'ʉ. Tsifu joon garáan²mo Eneas do. ");
INSERT INTO chqNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Joon jileei'²¹ 'in néei¹ fuu²¹ Lida coon'¹³ Sarón gajǿø²mo 'ii. Joon gatʉʉ²¹o la tɨɨsi'² goo¹o la mo jée¹. Joon galijai'² galɨ́ɨ²i Ña'ñʉ'¹ʉ' Jesús. ");
INSERT INTO chqNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","'E jmɨɨ²¹²joon jon galiseein²¹ jaain²¹ tsamɨ́² 'in jai'² lɨ́ɨi² coon²¹ fuu²¹ sii²¹ Jope. 'In tsamɨ́² lo sii²¹ Tabita. Pe coon'¹³ jmíi¹ griego sɨɨ'²¹ tsá² 'ii Dorcas. 'In tsamɨ́² lo jmoo¹o jilaa'²¹ 'e tyʉ́² tya' tsá². Uncoon'¹³o jileei'²¹ 'in sɨtyéen¹³ jmɨɨ²¹². ");
INSERT INTO chqNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Jee²¹² jmɨɨ²¹² joon gaton¹ tsaa'¹³a 'in Dorcas do. Joon gajún¹mo. Joon mo ngayuui'¹³ galaai'²¹ tsá² 'ii joon gatain'² tsá² 'ii lɨ tɨ́² tún² fúui¹ 'nʉ́¹. ");
INSERT INTO chqNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Tyan'¹an Lida náa¹ fuu²¹ Jope lɨ taain²¹² Tʉ́³ do. Joon mo ganúu²un 'in tsá² jai'² lɨ́ɨi² do 'e Tʉ́³ taain¹ Jope do gasii¹in gái¹ tsañʉʉ'¹ 'e tsasii'¹²i do: ―¡Jmaa² feei'¹‑'o'o! ¡Un'ø'¹'ø! Tsaa'³du' fu Jope do. ¡Jo un'ɨɨ²¹²'u! ");
INSERT INTO chqNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Joon ngoo²¹‑o Tʉ́³ coon'¹³ 'ii. Joon mo gatyíi¹a do ngajéei¹ tsá² 'ii lɨ raain¹ 'lɨɨ²¹² do. Joon jileei'²¹ tsamɨ́² 'nɨ́ɨi² néei¹ cɨ'²ɨ. Xuui²¹²‑tsi 'áai¹. Ga'e'²e Tʉ́³ jilaa'²¹ 'mɨ'² 'e nigajmaa¹a mo seein²¹. ");
INSERT INTO chqNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pe Tʉ́³‑gɨ ga'woo¹i jilee'²¹mo. Joon gasii'²¹i wojníi¹i gafaa'²¹a júu³ tyʉ́². Joon jǿø²i 'in 'lɨɨ²¹² do joon gajin'²in: ―Ráan²un, Tabita. Joon ganá¹ 'in tsamɨ́² do unníi¹i. Mo ganíi² Tʉ́³ do joon garoon¹on gacwó². ");
INSERT INTO chqNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Joon Tʉ́³‑gɨ gason'²on cwoo²¹o gajmaa¹a siin'¹²in. Mo ngayuui'¹³ joon gatø'¹ø 'in tsaru'¹u' catyaai² do coon'¹³ 'in tsamɨ́² 'nɨ́ɨi² do. Joon ga'e'²e 'ido 'e nijiin'¹in. ");
INSERT INTO chqNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Jilaa'²¹ 'elo galiñii¹i tsá² seein²¹ Jope do. Joon fúu¹mo gatsa'²‑tsi Ña'ñʉ'¹ʉ' Jesús. ");
INSERT INTO chqNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Joon 'láa²mo jmɨɨ²¹² gateein¹ Tʉ́³ 'e fuu²¹ do tya' jaain²¹ tɨloo²¹ sii²¹ Simóoi¹³. ");
INSERT INTO chqNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Fu Cesarea do‑o seein²¹ jaain²¹ tsá² sii²¹ Cornelio. Jaain²¹ 'in tyʉ'² to² tya' coon²¹ cíein¹³ 'láa² jee²¹² coon²¹ poo²¹² 'láa² sii²¹ Italiano. ");
INSERT INTO chqNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Tsaa'²‑tsi coon'¹³ la tøøi² tsá² inʉʉ tya'a. Un'goo²¹o Dios. Joon cwo'¹o cuu² 'e uncoon'¹³on tsá² Israel. La coon²¹ jmɨɨ²¹² fee'¹i Dios. ");
INSERT INTO chqNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Coon²¹ jmɨɨ²¹² ningóo¹ la 'iin²¹ 'nɨ¹ ca'lóo² mo gajnéi¹ jaain²¹ ángel tya' Dios lɨ tyíin¹in. Joon gajin'²in: ―¡Cornelio! ");
INSERT INTO chqNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Joon gafoo'¹²mo Cornelio. Joon gajaan¹an jǿø²i 'in ángel do. Joon gaunngɨɨ¹ɨ: ―Señor, ¿'ee fú³xʉ'ʉ jna? Joon 'in ángel do‑gɨ gasɨɨ'²¹ɨ 'ii: ―Ninúu² Dios júu³ tyʉ́² tyi'i. Joongɨ ninii²¹o xiiala uncoon'¹³'on 'in 'oo¹o fa'í³. ");
INSERT INTO chqNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Sɨɨ²¹u tsá² tyi'i 'e fuu²¹ Jope do 'e tsatee¹e Simóoi¹³, 'in sii²¹o jon Tʉ́³. ");
INSERT INTO chqNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Tyíin¹in tya' jaain²¹ tɨloo²¹ 'in sii²¹o jon Simóoi¹³. Si'² 'nʉ́ʉ¹ʉ tyan' tɨ' jmɨ'ñi'³ do. 'Ii ijin'² 'ee 'ná² jmaa²o'o no ―gajin'² 'in ángel do. ");
INSERT INTO chqNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Mo gangaa'¹²i 'in ángel do joon gatø'¹ø Cornelio do gái¹ tsá² tya'a coon'¹³ jaain²¹ 'láa² 'in tsaa'²‑tsi Dios. Joongɨ jo cu'²‑tsi coon'¹³on. ");
INSERT INTO chqNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Gajma'²o 'ido júu³ jilaa'²¹ 'ee galɨ́². Joon gasii¹in fu Jope. ");
INSERT INTO chqNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Mo gajná² jmɨɨ²¹² joon taa²mogɨ fu¹, tɨ lɨ́² tyalíin² Jope. La 'ɨɨ²¹² joon Tʉ́³‑gɨ gasoo²o yʉ' 'nʉ́¹ lɨ lɨ́² tún² fúui¹. La tyíia² ni'¹i gasoo²o ngafee'¹²i Dios. ");
INSERT INTO chqNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","'Áa¹mo niun'áa¹i. 'Iin²¹²in dø'¹ø. Joon la 'ɨɨ²¹² náa¹ tyʉ́² 'e dø'¹ø joon ganii²¹ coon²¹ lawa 'e cɨɨ¹ɨ. ");
INSERT INTO chqNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Jǿø²o lawa ganó² fu yʉ' juncwii²¹. Joon ganii²¹ jó² fu ni 'wó² lawa coon 'mɨ'² taa²¹ fee'¹ lɨɨlɨ¹. 'E sɨ'ñʉ́ʉ¹ʉ jɨ tyʉ́n² tyuui'¹³. ");
INSERT INTO chqNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","'E ni 'mɨ'² do tsíin¹³ jileei'²¹ nii² joo'nuu²¹ 'in sá² tyʉ́n² tɨɨ² coon'¹³ mɨɨ'²¹ coon'¹³ 'in sá² cwáa¹. ");
INSERT INTO chqNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Joon ganúu²un Tʉ́³ do coon²¹ júu³ 'e jin'²: ―Nano Tʉ́³, jngaa'¹²'i joongɨ cuu'¹'i 'in no. ");
INSERT INTO chqNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pe Tʉ́³‑gɨ do gañii¹i: ―'Un², Ña'ñʉ'¹ʉ', jo mo gø'¹øø jilaa'²¹ 'e gó² 'e jo tɨɨ¹na. ");
INSERT INTO chqNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Joon ganúu²un tún¹ 'e júu³ gajin'²: ―'E gauntyúi¹ Dios jo foo'²¹'o 'e gó². ");
INSERT INTO chqNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","'Nɨ¹ naa'¹³ galí² 'elo. Mo ngayuui'¹³ joon gasoo² tún¹ 'e 'mɨ'² taa²¹ do fu yʉ'. ");
INSERT INTO chqNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","'In tsá² 'in gasii¹in Cornelio do nigajalíin²mo unngɨɨ¹ɨ tya' Simóoi¹³. La 'ɨɨ²¹² 'ɨ¹‑tsi Tʉ́³ jilaa'²¹ 'e ganii²¹ do‑o gatyalíin² 'in tsá² do 'ooca'nʉ́¹. ");
INSERT INTO chqNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Tø'¹ø wa tyíin¹ jaain²¹ tsá² sii²¹ Simóoi¹³, 'in sii²¹o jon Tʉ́³. ");
INSERT INTO chqNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","La 'ɨɨ²¹² 'ɨ¹gɨ‑tsi Tʉ́³ 'e lawa'a gacɨɨ¹ do gasɨɨ'²¹ɨ 'in Espíritu Tyʉ́² tya' Dios 'ii: ―Ñíi², gaai²¹ tsañʉʉ'¹ 'naai'¹³ 'nʉ. ");
INSERT INTO chqNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Cwúi¹ no, cwó² coon'¹³on jo 'ee 'ɨ¹gɨ‑'o'o coonti tsʉ jna‑a gasɨ́ɨ²na 'ido. ");
INSERT INTO chqNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Joon jgá¹mo Tʉ́³ lɨ teein¹ 'in tsá² gasii¹in Cornelio do. Joon gasɨɨ'²¹ɨ: ―Jna‑a 'in 'naa'²¹naa' no. ¿'Ee to ñilíin²naa'? ");
INSERT INTO chqNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","'Ido‑gɨ gañii¹i: ―Jalii²¹i'i to² tyʉ'² jaain²¹ fii²¹² 'láa² sii²¹ Cornelio, jaain²¹ tsá² tyúi¹ 'in tsaa'²‑tsi Dios. Jileei'²¹ tsá² seein²¹ Israel jin'²in 'e tsá² tyú¹mo 'ii. Dios gasii¹in jaain²¹ ángel tya'a 'e jma'²a júu³ Cornelio do 'e tøø'²¹ø 'nʉ fu tya'a 'e núu¹un júu³ tyi'i. ");
INSERT INTO chqNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Joon gacwo¹ Tʉ́³ gataa²mo inʉʉ. Joon do‑o gajaan¹an canʉ́ʉ¹. Mo gajná² jmɨɨ²¹² joon ngaliin¹mo Tʉ́³ coon'¹³ 'ii. Ngalíin²mo jon 'in jai'² lɨ́ɨi² néei¹ Jope do. ");
INSERT INTO chqNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Mo gajná² jmɨɨ²¹² joongɨ tún¹ tyalíin² Cesarea lɨ sɨjéen¹in Cornelio 'ii. Sɨcaain²¹ coon'¹³ ruu'²¹i coon'¹³ 'inlɨ́ɨi¹³ tsá² seein²¹ tyʉ́² coon'¹³ 'in nigatø'¹ Cornelio do. ");
INSERT INTO chqNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Mo gatyía¹ Tʉ́³ do tsifu joon cwo'ɨ́ɨ¹ Cornelio ngajéein¹ 'ii. Joon gasii'²¹i wojníi¹i tyani Tʉ́³ 'e untyúui¹ 'ii. ");
INSERT INTO chqNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pe Tʉ́³ do‑gɨ gasaa'¹³mo 'ii. Joon gajin'²in: ―Jmaa² siin'¹³un. Tsañʉʉ'¹ la 'nʉ jon jna. ");
INSERT INTO chqNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","La 'ɨɨ²¹² tyaa¹ júu³ ngataa²i. Ga'ii²¹ lɨ fúui¹ tsá² néei¹. ");
INSERT INTO chqNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Joon gajin'² Tʉ́³ sɨɨ'²¹ɨ 'ii: ―Ñii²¹ 'naa' 'e jo tɨ́ɨi² tsá² Israel 'e uncaain²¹ coon'¹³ tsá² seein²¹ lɨ xiia'. Jon'gɨ tsataai² inʉʉ tya'a. Pe Dios ni'e'²o jna 'e jo tɨ́ɨ²na fo'³oo 'e gó² 'e jiin'¹³ jaain²¹. ");
INSERT INTO chqNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","'Wii'¹³ joon tsifu gagó³oo 'e gate'²e jna do. Jo 'ee fo'³oo coonti. 'Iin²¹²na liñii² 'ee to² tǿ²øø' jna. ");
INSERT INTO chqNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Joon gañii¹ Cornelio do: ―Tyʉ́n² jmɨɨ²¹² ningóo¹ jiin'¹³ la 'ii'²¹ nano tyíin¹na lo. Jmóo³oo taa'²¹ jo mo gøø'²¹øø 'í³ii. Foo'¹³na Dios la ca'loo. La jee²¹² joon gajnéi¹ jaain²¹ tsá² jɨɨ'¹ sɨɨn'³ lɨɨlɨ¹. ");
INSERT INTO chqNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Joon gasɨɨ'²¹ɨ jna: “Cornelio, nanúu²un Dios júu³ tyʉ́² tyi'i. Joon nacón² cwáain¹ tya' jilaa'²¹ 'e nigauncoon'¹³'on jileei'²¹ 'in 'oo¹o fa'í³. ");
INSERT INTO chqNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Sii¹in 'in tsalíin² 'e fuu²¹ Jope do. Tsatee¹e 'in sii²¹ Tʉ́³, 'in sii²¹o jon Simóoi¹³. Tyíin¹in tya' jaain²¹ tɨloo²¹ 'in sii²¹o jon Simóo¹³mo. Si'² 'nʉ́ʉ¹ʉ tyan' tɨ' jmɨ'ñi'³. Mo cwée¹i joon ityá² júu³ coon'¹³ 'nʉ.” ");
INSERT INTO chqNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Joon tsifu joon gasɨ́ɨ²na 'in ja'neei'¹³ 'nʉ. Tyʉ́²‑ʉ nigajmaa'¹³'a gañi¹o'o. Joon lo‑o náa¹oo'o tyani Dios. 'Ii²¹i'i nʉʉ²¹ʉ'ʉ jilaa'²¹ 'e nigatyʉ'² Ña'ñʉ'¹ʉ' to² 'e fu'³'u jna'a ―jin'² Cornelio. ");
INSERT INTO chqNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Joon ga'láa² Tʉ́³ 'wii²¹² faa'²¹a jin'²in: ―Niñí³oo no 'e tyani Dios jilee'²¹mo tsá² coon²¹ røø²¹mo. ");
INSERT INTO chqNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Joon 'ii'²¹mo doñi'iin tsá² seein²¹ Israel tiin'¹³ 'in jo seein²¹ joon wa'a tsaa'²‑tsi 'ii joon jmoo¹o 'e tyʉ́². ");
INSERT INTO chqNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Dios gasii¹in Jesucristo jee²¹² tsá² Israel. 'Ii Ñʉ'¹ʉ' jilee'²¹o'. Joon gajmaa¹a júu³ xiiala tyia'²‑tsi tsá² Dios 'e jo téen¹in coon'¹³on. ");
INSERT INTO chqNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Tyʉ́²‑ʉ ní²ii' 'e galɨ́² goo¹o tsá² Israel. Ga'láa² 'wii²¹² Galilea mo ngayuui'¹³ gacwo¹ Wó³ júu³ tyʉ́² 'e 'ná² saai¹ tsá² jmɨɨ²¹. ");
INSERT INTO chqNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Joon ñii²¹oo' xiiala gacwo'¹ Dios 'in Jesús tsá² Nazaret do 'in Espíritu Tyʉ́² tya'a. Joon gacwo'¹o 'ii'²¹ tya'a. La joon gangɨɨ¹ɨ lacaain²¹ jmoo¹o 'e tyʉ́². Joon un'láai² jileei'²¹ 'in ní² wúu¹ 'ii'²¹ tya' 'in 'lɨɨi'³. Jilaa'²¹ 'elo gajmaa¹a tsʉ ngɨ¹ Dios coon'¹³ 'ii. ");
INSERT INTO chqNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Niganee²¹²oo'o jilaa'²¹ 'e lɨ́². Jilaa'²¹ 'e gajmaa¹a Jesús lacaain²¹ Judea coon'¹³ 'e fuu²¹ Jerusalén. Mo gangɨ́ɨi² joon gajngaa'¹³mo tsá² 'ii. Gateen¹in tsá² 'ii tsaa' crúu¹³ do. ");
INSERT INTO chqNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Pe Dios gajmaa¹a jiin'¹o mo tɨ́² 'nɨ¹ jmɨɨ²¹². Joon gajmaa¹a jné¹mo tún¹ jee²¹² jna'a. ");
INSERT INTO chqNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Pe jiin'¹³ coon'¹³ jna'oo'o gajnée¹i jon' jileei'²¹ tsá². Jiin'¹³ 'in gatyii'¹²in Dios la jée¹mo gajnée¹i 'e cón² cwáain¹ 'ii‑o. Caan¹mo tún¹ gatyée²e'e joongɨ née²e'e coon'¹³on mo gangɨ́ɨi² jiin'¹in do. ");
INSERT INTO chqNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Joon gasii¹in jna'a sii'¹³i'i tsá² 'e Dios gatyée¹i 'in Jesús lo 'e jmá¹ 'ii'²¹ tya' tsá² jiin'¹ lagɨ 'in nijúin¹. ");
INSERT INTO chqNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Joongɨ ca la jée¹mo jileei'²¹ 'in gacwo¹ júu³ tyʉ́² tya' Dios gajin'²o xiiala lɨ́ɨi¹ Jesús 'e jileei'²¹ 'in jai'² lɨ́ɨi² 'ii 'iin²mo tsaa² tya'a coon'¹³ 'ii'²¹ tya' 'e sii²¹o. ");
INSERT INTO chqNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Faa'²¹gɨ Tʉ́³ siin'¹²in mo gajó² 'in Espíritu Tyʉ́² tya' Dios 'e ga'í² almas tya' jileei'²¹ 'in nuu¹un júu³ tya'a do. ");
INSERT INTO chqNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Lɨ́ɨ¹ tsa'goo²¹‑tsi tsá² Israel 'in jo'¹ lɨ́ɨi² 'in gajalíin² coon'¹³ Tʉ́³ do. La ga'í² Espíritu tya' Dios alma tya' tsá² Israel do‑o la joon jon niga'í² Espíritu tya' Dios tya' 'in jo seein²¹ joon. ");
INSERT INTO chqNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Nuu¹o faa'²¹ 'ido jmíi¹ xiia' joon gauntyúi¹ Dios jmai'² coon'¹³ júu³ tya'. ");
INSERT INTO chqNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Joon gajin'² Tʉ́³: ―¿Tɨ lí² jo cwoo²¹o' saai¹ 'in tsá² lo jmii²¹ tsʉ niga'ii'²¹mogɨ Esíritu Tyʉ́² la ga'ii'¹³na'? ");
INSERT INTO chqNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Joon gatyʉ'²ʉ to² gasaai¹ 'ido jmɨɨ²¹ coon'¹³ 'e sii²¹ Ña'ñʉ'¹ʉ' Jesús. Mo ngayuui'¹³ joon, joon gamɨ'²ɨ Tʉ́³ wa'a jaain²¹²ta 'ido coon²¹ tún² jmɨɨ²¹² coon'¹³on. ");
INSERT INTO chqNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ganúu²un 'in apóstoles coon'¹³ 'in tsaru'¹u' catyaai² néei¹ Judea 'e niga'ii'²¹mo júu³ tyʉ́² tya' Dios cagɨ 'in jo seein²¹ Israel. ");
INSERT INTO chqNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Mo gacwai'² Tʉ́³ Jerusalén 'inlɨ́ɨi¹³ tsá² Israel 'in jai'² lɨ́ɨi² ga'láa² 'wii²¹² unngɨɨ¹ɨ: ");
INSERT INTO chqNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","―¿'Ee lɨ' gatyíi²a tyatya'³'a júu³ coon'¹³ 'in tsá² jo seein²¹ Israel? Joongɨ gatyatyee'²¹'e coon'¹³on. ");
INSERT INTO chqNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Joon ga'láa² Tʉ́³ 'wii²¹² gatyaa¹ júu³ la jilaa'²¹a 'e nigalɨ́² do ca la nifu. Joon gajin'²in: ");
INSERT INTO chqNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","―Do‑o taan¹na Jope do. Joon la jiin'¹³ foo'¹³na Dios do‑o gamóo³oo coon²¹ li². Coon²¹ li² 'e lɨ la lɨ coon²¹ 'mɨ'² taa²¹. Gamóo³oo jgó² sɨ'ñʉ́ʉ¹ʉ jɨ tyʉ́n² tyuui'¹³. Joon gacwá² tɨ́² tyaní³ii. ");
INSERT INTO chqNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Mo gajǿø³øø coon'²¹ tún² lɨ' tsi, joon gamáa¹na jileei'²¹ nii² joo'nuu²¹ 'in tyúi¹ tiin'¹³ 'in gó². Joongɨ máa¹na mɨɨ'²¹ coon'¹³ 'in sá² cwáa¹. ");
INSERT INTO chqNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Joongɨ ganúu³uun coon²¹ júu³ 'e jin'²: “Ráan²un, Tʉ́³. Jngaai'¹³ 'in joo'²¹ lo joongɨ cøø'²¹xʉ'ʉ.” ");
INSERT INTO chqNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Pe joon gafo'³oo: “Jo lí² døø'¹³øø 'elo, Ñʉ'², tsʉ jiin'¹³ cafu jo mo gatoo'¹³ 'óo³oo jilaa'²¹ 'e gó² 'e jo tɨ́ɨi² dø'¹ tsá² Israel.” ");
INSERT INTO chqNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Joon gajin'² 'e júu³ do sɨɨ'²¹ɨ jna tún¹: “Jilaa'²¹ 'e untyúi¹ Dios jo foo'¹³'o 'e gó².” ");
INSERT INTO chqNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","La joon galɨ́² 'nɨ¹ naa'¹³. Joon mo ngayuui'¹³ joon gasoo² fu ñʉ'fú². ");
INSERT INTO chqNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","La 'ɨɨ²¹² joon gatyalíin² gaai²¹ tsañʉʉ'¹ 'in 'naai'¹ jna 'e 'nʉ́¹ lɨ tyíin¹na do. Nijalíin² fuu²¹ Cesarea. ");
INSERT INTO chqNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Joon 'in Espíritu Tyʉ́² tya' Dios gasii¹mo jna 'e gangóo¹oo coon'¹³ 'in tsá² do jo cu'²‑tsii. Joon ngalíin²mo jɨ jñúui² tsaru'¹u' no. Joon jile'¹oo'o ngatoo²¹o'o tsi inʉʉ tya' 'in tsá² do. ");
INSERT INTO chqNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Joon 'in tsá² do gatyaa¹ júu³ la lɨ 'e ganii²¹ jaain²¹ ángel 'in siin'¹³ tyaníi¹i. Joon gasɨɨ'²¹ 'in ángel do 'ii: “Sii¹in jaain²¹ gái¹ tsá² tyi'i fu 'e fuu²¹ Jope do. Tsate'²du jaain²¹ tsá² sii²¹ Simóoi¹³, 'in sii²¹o jon Tʉ́³. ");
INSERT INTO chqNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Joon 'ii 'in 'e'² 'naa' xiiala taan²¹²naa' coon'¹³ Dios coon'¹³ jileei'²¹ tsá² taai inʉʉ tyi'i.” ");
INSERT INTO chqNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Mo ga'láa² 'wii²¹² gafo'³na joon gajó² 'in Espíritu Tyʉ́² tya' Dios. Ga'í² lɨ lɨcaan²¹na'a do. Joon 'ii'²¹mo jileei'²¹ 'in néei¹ inʉʉ do la lɨ́² mo ga'ii'²¹in alma tyijna' la mo 'wiin²¹². ");
INSERT INTO chqNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Joon gatɨ'²‑tsi la lɨ́² 'e gajin'² Ña'ñʉ'¹ʉ': “'E jo'¹o 'e Wó³‑o gasaai¹ tsá² jmɨɨ²¹ jiin'¹³ coon'¹³ jmɨɨ²¹ pe Dios icwoo'¹²i 'naa'gɨɨ' 'in Espíritu Tyʉ́² tya'a wa'a ngɨ¹ coon'¹³ 'naa'.” ");
INSERT INTO chqNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Pe wana gacwo'¹ Dios 'ii la lɨ́² 'e nigacwo'¹o jna' 'in nigajo'¹ lɨ́ɨi² Ña'ñʉ'¹ʉ' Jesucristo, ¿'iin lɨ́ɨ¹na 'e fo'³oo 'laa'²¹ tya' Dios? ―jin'² Tʉ́³. ");
INSERT INTO chqNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Mo ganúu²un 'in tsá² jo'¹ lɨ́ɨi² néei¹ fu Jerusalén do gajaan¹an tii². Joon gacwo'¹o 'maai'¹³ Dios gajin'²in: ―¡Ca‑gɨ 'in jo seein²¹ Israel Dios nigacwo'¹o coon²¹ 'ii'²¹ 'e lí² jaa'²¹a‑tsi joon 'e tiin'¹³mo! ");
INSERT INTO chqNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Mo ngayuuui'¹³ gajngaa'¹³i tsá² Tée¹³ ga'láa² 'wii²¹² ga'ǿø¹i 'in catyaai²gɨ 'in tsáai¹‑tsi Dios. Joon 'inlɨ́ɨi¹³ gacwiin¹in fu Fenicia. 'Inlɨ́ɨi¹³gɨ gacwiin¹in fu Chipre joongɨ Antioquía. Joon do‑o ga'láa² 'wii²¹² cwoo¹o júu³ tyʉ́² tya' Dios jiin'¹³ tsá² Israel. ");
INSERT INTO chqNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Pe 'inlɨ́ɨi¹³ 'in jai'² lɨ́ɨi² tsá² seein²¹ Chipre coon'¹³ Cirene gangalíin² fu Antioquía. Do‑o ga'láa² 'wii²¹² cwoo¹o júu³ tyʉ́² tya' Ña'ñʉ'¹ʉ' Jesús. ");
INSERT INTO chqNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ca‑gɨ 'in jo seein²¹ Israel gacwoo¹o. 'Áa¹mo gauncoon'¹³ Ña'ñʉ'¹ʉ' 'ii. Joon la joon fúu¹mo galijai'² lɨ́ɨi². Joon ga'láa² 'in tsá² do 'wii²¹² tsaa'¹‑tsi Ña'ñʉ'¹ʉ'. ");
INSERT INTO chqNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Mo ganúu²un 'in jo'¹ lɨ́ɨi² 'in néei¹ Jerusalén 'e júu³ lo gasii¹in jaain²¹ tsá² sii²¹ Bernabé 'in gangó¹ fu Antioquía. ");
INSERT INTO chqNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Mo gatyía¹ Bernabé do gacón² cwáai¹ 'e Dios gajmaa¹a jilaa'²¹ 'e ganúu²un 'e galɨ́² do. Joongɨ galijløø'³mo. Joon ga'ɨ́ɨ² júu³ Bernabé jileei'²¹ 'in tsá² do cwotyia'²‑tsi ce caain²¹‑tsi Ña'ñʉ'¹ʉ'. ");
INSERT INTO chqNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Tsá² tyú¹mo 'in Bernabé do. Ja'²mo lɨ́ɨi² Jesús. Joon galinʉʉ'¹³ʉn 'in Espíritu Tyʉ́² tya' Dios. Joon la joon lɨ́ɨ¹ fúui¹ tsá² gatsa'²‑tsi júu³ tya' Jesús. ");
INSERT INTO chqNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Mo ngayuui'¹³ jon gangó¹ Bernabé fu Tarso. Nga'nee'¹³i jaain²¹ tsá² sii²¹ Saulo. Mo gatsee'²¹i joon gatǿø¹ø fu Antioquía. ");
INSERT INTO chqNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Joon do‑o gateen¹‑in la tøøi² coon²¹ jiin²¹ jee²¹² 'in tsá² jai'² lɨ́ɨi² do. Do‑o ga'e'²e fúu¹mo tsá². Joon fu Antioquía do‑o ga'láa² 'wii²¹² 'e galisii²¹ 'in jai'² lɨ́ɨ² Cristo, cristianos. ");
INSERT INTO chqNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Jee²¹² jmɨɨ²¹² lo‑o 'inlɨ́ɨi¹³ 'in cwo¹ júu³ tyʉ́² tya' Dios ga'woo²i Jerusalén. Joon ngalíin² fu Antioquía. ");
INSERT INTO chqNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Joon jaain²¹ jee²¹² 'ii, 'in sii²¹ Agabo, gajmaa¹a siin'¹²in jee²¹² la 'oo'²¹ tsaru'¹u' néei¹ do. Joon coon'¹³ 'ii'²¹ tya' Espíritu Tyʉ́² tya' Dios gafaa'²¹a ijó¹ goon²¹ 'oo² la tøøi² ni cwoo'¹³ juncwii²¹. La joon galɨ́² jiin²¹ mo gatyʉ'² rǿøi¹³ Claudio to². ");
INSERT INTO chqNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Joon 'in tsá² jai'² lɨ́ɨi² 'in néei¹ fu Antioquía do gaun'ii'²¹i júu³ 'e uncoon'¹³on tsaru'¹u' 'in néei¹ Judea. Joon cwo'¹o la jaain²¹ la jaain²¹ jiin'¹³ ti lí² lii'¹i. ");
INSERT INTO chqNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","La joon gajmaa¹a. Joon gasiin'¹²in 'e cuu² do coon'¹³ Bernabé coon'¹³ Saulo. ");
INSERT INTO chqNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Jee²¹² jmɨɨ²¹² joon ga'láa² Herodes 'wii²¹² ga'ǿø¹mo 'inlɨ́ɨi¹³ 'in jai'² lɨ́ɨi². ");
INSERT INTO chqNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Joongɨ gatyʉ'² to² 'e gajngaai'¹² tsá² Jacobo ruu'²¹i Wó³ coon'¹³ ñí³. ");
INSERT INTO chqNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Mo galili'³i 'e gatɨ́²‑tsi tsá² Israel 'e gajmaa¹a do joon gasaan'¹²in Tʉ́³. Jilaa'²¹ 'elo galɨ́² la 'ɨɨ²¹² 'e gatɨ́² jmɨɨ²¹² mo gø'² tsá² 'iñi'¹ 'e jo tyiian'² jeei¹. ");
INSERT INTO chqNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Joon gatyʉ'² Herodes to² 'e 'aa¹i tyʉ́n² poo²¹² 'láa² Tʉ́³ do. La coon²¹ poo²¹² tí¹ tyúuin² 'láa² do. Joon gataan'¹in Tʉ́³ do 'nʉñí³. Do‑o ga'aai¹ 'láa² do 'ii. Lɨ́ɨ²i Herodes itsajée¹i Tʉ́³ fu tyani tsá² Israel mi ngɨ́ɨi² cwaa'²¹ jmɨɨ²¹². ");
INSERT INTO chqNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","La joon lɨ́ɨ¹ tyʉ́² sɨjnɨ́ɨi¹³ Tʉ́³ 'nʉñí³. Pe 'in jai'² lɨ́ɨi² lɨ́ɨ¹ fee'¹i Dios 'wii²¹² tya' Tʉ́³ do. ");
INSERT INTO chqNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","'E 'woo¹ joon la nʉ'gɨ jmɨɨ²¹² 'e ityii¹in Herodes Tʉ́³ 'e tsajée¹i tyani tsá² Israel raan¹mo Tʉ́³ jee²¹² gái¹ 'láa² do. Do‑o raan¹in cwuu²¹i sɨ'ñúu¹³mo coon'¹³ cadenas. Joon 'inlɨ́ɨ¹³gɨ 'láa² do téen²mo 'oo² 'nʉñí³ do. ");
INSERT INTO chqNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","La tsifu joon gajnéi¹ jaain²¹ ángel 'in gasii¹in Dios. Joon gajná² joo'²¹ tsi 'nʉñí³ do. Joon 'in ángel do ga'lii'²¹i moo'wó¹ Tʉ́³ do. Joon gaunjnaa¹a‑tsi Tʉ́³ do. Joon gajin'²in sɨɨ'²¹ɨ 'ido: ―Jmoono ráan²un. Tsifu joon gaxʉʉ'²¹ cadena 'e 'ñʉ́ʉ¹ʉ cwoo²¹o Tʉ́³ do. ");
INSERT INTO chqNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Joon gajin'² 'in ángel do: ―Jmoono 'nʉ́ʉ² tuu'¹'u. 'øø'¹³ mɨ́ɨ¹³'ɨ no. Mo ngayuui'¹³ gajmaa¹a Tʉ́³ jilaa'²¹ 'elo gajin'² ángel sɨɨ'²¹ɨ 'ii: ―Jmoono tyán² 'mɨ'jñʉ¹'ʉ joon na¹ coon'¹³ jna. ");
INSERT INTO chqNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Joon gacwo'ɨ́ɨ¹ Tʉ́³ caluu coon'¹³ 'in ángel do. Jiin'¹³ jon' lɨ́ɨi² jo'¹ jilaa'²¹ 'e gajmaa¹a 'in ángel do. 'Áai¹gɨ galɨ́ɨ²i 'e lawa'a coon²¹ 'e cɨɨ¹o. ");
INSERT INTO chqNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Joon gangɨ́ɨ¹mo lɨ téen²in 'in 'láa² nifu. Joon la joon gangɨ́ɨ¹mo lɨ tɨ tún². Joon la joon gatyalíin²mo lɨ si'² jnɨ'nʉ́¹ do lɨ gasuui²¹ 'ooca'nʉ́¹. Joon 'e jnɨ'nʉ́¹ do lí¹ jmai'² ñí³. Joon mo gatyalíin² 'ooca'nʉ́¹ do, ña'a ganó¹. Joon ga'woo²¹mo. Joon ngalíin² caan²¹mo coon²¹ sii'¹³xʉ. Joon gatʉ́ʉ²mo 'in ángel do 'ii. ");
INSERT INTO chqNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Mo galili'³i Tʉ́³ 'e la ja'²mo jilaa'²¹ 'elo joon ga'ɨ¹‑tsi: ―No‑gɨ jo'¹ lɨ́ɨ²na 'e nigasii¹in Ña'ñʉ'¹ʉ' ángel tya'a 'e galaai¹ jna tyani Herodes do joon jilaa'²¹gɨ 'e la mo 'iin²¹²in tsá² Israel jmee'²¹i jna. ");
INSERT INTO chqNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Jmai'² 'edo‑o 'ɨ¹‑tsi Tʉ́³ gangaa'¹²i fu tya' María sáa³ Wó³, 'in sii²¹o jon Marcos. Do‑o lɨ lɨcaain²¹ jileei'²¹ 'in nigafaa'²¹ júu³ tyʉ́² 'wii²¹² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Mo gapoo²¹ 'ooca'nʉ́¹ do joon gajó² jaain²¹ sɨmɨ́² sii²¹ Rode. Ngajǿø² 'iin do. ");
INSERT INTO chqNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Mo galicwii¹i jmíi¹ tya' Tʉ́³ do jo ganá¹ 'ooca'nʉ́¹ do. Joon ga'ii²¹ jløø'³mo cwiin¹in gajmaa'¹²a tsá² catyaai²gɨ do júu³ 'e Tʉ́³‑ʉ siin'¹²in 'ooca'nʉ́¹ do. ");
INSERT INTO chqNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Pe 'in tsá² do gasɨɨ'²¹ɨ 'ii: ―¡Tsá² caa²¹²mo 'nʉ! Pe la jin'²o jin'²in 'e jo'¹o siin'¹² Tʉ́³. Pe joon gajin'² 'in tsá² do: ―Jon' Tʉ́³ 'in siin'¹² ca'nʉ́¹ do. Ángel tya'o do. ");
INSERT INTO chqNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","La 'ɨɨ²¹² joon siin'¹²o Tʉ́³ poo²¹ 'ooca'nʉ́¹ do. Joon mo ganá¹ 'ooca'nʉ́¹ do joon gajǿø²mo gafoo'¹mo. ");
INSERT INTO chqNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pe Tʉ́³ do gajmaa¹a coon²¹ li² coon'¹³ cwoo²¹o 'e jo cwota'³ tsá² do mɨɨ'¹³. Joon gatyaa¹ júu³ xiiala galaa¹i 'in ángel do 'ii tsi 'nʉñí³ do. Joon gajin'²in: ―Sii'¹³ Jacobo coon'¹³ tsaru'¹u'. Joon gacwo'ɨ́ɨ¹ Tʉ́³. Gangóo¹ fu lɨ xii'a. ");
INSERT INTO chqNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Mo gajná² jmɨɨ²¹² do ganá¹ 'goo²¹ jiin'¹³ la 'oo'²¹ jee²¹² 'in 'láa² do tsʉ jo ñii¹i 'ee galɨ́² coon'¹³ Tʉ́³ do. ");
INSERT INTO chqNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Joon gatyʉ'² Herodes to² 'e 'naa'²¹mo 'ido. Pe mo jo gatsee'²¹i gajmaa¹a cwáain¹ tya' 'in 'láa² do. Joon gatyʉ'²ʉ to² ijúun²mo 'ido. Pe mo lɨ cɨɨin²¹xʉ joon gacwo'ɨ́ɨ¹o Herodes coon²¹ lɨ sii²¹ Judea. Joon ngacwaa¹a coon²¹ fuu²¹ sii²¹ Cesarea. ");
INSERT INTO chqNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","'In tsá² seein²¹ Tiro coon'¹³ Sidón 'ná²‑a tsaláa¹ 'e dø'¹ø fu lɨ tyʉ'² Herodes to². Pe gatɨ́² 'nii'²¹‑tsi Herodes tya' 'in tsá² do, 'wii'¹³ la joon 'iin²¹²in 'in tsá² do ilisá² 'ii'²¹ røø²¹. Joon gajaan'²¹an cuu² tya' jaain²¹ tsá² 'in 'oo¹o to² tya' Herodes do 'e 'ido‑o faa'²¹o 'wii²¹² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Joon tyʉ'² Herodes do to² 'in tsá² do ilicaain²¹ coon²¹ jmɨɨ²¹². Joon mo gatɨ́² 'e jmɨɨ²¹² joon, joon cɨ'¹ Herodes sɨɨn'³ rǿøi¹³. Joon gacwó²o 'áan³ tya'a. Joon gacwo'¹o 'in tsá² do cwú¹. ");
INSERT INTO chqNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Joon ga'láa² 'in tsá² do 'wii²¹² faa'²¹a tá²: ―¡'In tsañʉʉ'¹ 'in faa'²¹ no jon' tsá² no, Dios no! ―jin'² 'in tsá² do. ");
INSERT INTO chqNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Joon 'wii'¹³ nigaunfee'¹mo 'ña'a tyani Dios, jo mo gauntyúi¹ Dios, gajó² jaain²¹ ángel tya' Dios Jmii²¹. Joon gajmaa¹a galitsaa'¹²a Herodes. Joon gajuun¹in Herodes do. Gagøø'²¹ joo'¹³ 'ii. ");
INSERT INTO chqNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Joon la joon lɨ́ɨ¹ nganii'¹³ júu³ tyʉ́² tya' Dios. ");
INSERT INTO chqNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Mo gatséi¹ to² tya' Bernabé coon'¹³ Saulo ga'woo²¹mo Jerusalén do. Ngaliin¹mo tún¹ fu Antioquía coon'¹³ jaain²¹ 'in sii²¹ Wó³. Sii²¹o jon Marcos. ");
INSERT INTO chqNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Jee²¹² 'in jai'² lɨ́ɨi² néei¹ fu Antioquía do‑o seein²¹ 'inlɨ́ɨi¹³ 'in cwo¹ júu³ tyʉ́² tya' Dios joongɨ 'e'²e tsá². Jaain²¹ jee²¹² 'ii sii²¹ Bernabé jaain²¹gɨ sii²¹ Simón, 'in sii²¹o jon Negro. Jaain²¹gɨ sii²¹ Lu'³, 'in seein²¹ fu Cirene. Jaain²¹gɨ sii²¹ Manaén, 'in gacwaain²¹ caain²¹ coon'¹³ Herodes. (Herodes do‑o gatyʉ'²ʉ to² coon²¹ lɨ sii²¹ Galilea.) Joon jaain²¹gɨ 'in sii²¹ Saulo. ");
INSERT INTO chqNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Joon coon²¹ jmɨɨ²¹² la 'ɨɨ²¹² faa'²¹a 'in tsá² do júu³ tyʉ́² jmoo¹o taa'²¹a jo mo gøø'²¹ø. La 'ɨɨ²¹² joon gajin'² Espíritu Tyʉ́² tya' Dios sɨɨ'²¹ɨ 'ii: ―Cwotyii'¹³naa' Bernabé coon'¹³ Saulo ijmáa¹a to² la lɨ 'e nigafuu²¹²uu ―jin'² 'in ángel do. ");
INSERT INTO chqNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Joon gajmaa¹‑o taa'²¹a jo gagøø'²¹ø 'in tsá² do ca mo ngayuui'¹³ gafaa'²¹a júu³ tyʉ́². Joon 'in tsaru'¹u' do ga'ɨ́ɨ² cwoo²¹o mootyi² Bernabé coon'¹³ Saulo. Joon coon'¹³ 'e la joon ga'ɨ'¹o júu³ ruu'²¹i. ");
INSERT INTO chqNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","La joon gasii¹in Espíritu Tyʉ́² tya' Dios 'ii. Ngalíin² fu Seleucia. Mo gatyalíin² do‑o joon ngatáa¹i tsi coon²¹ barco. Joon gatyalíin² coon²¹ 'wó² roon¹ tún² tsa'¹ jmɨ'ñi'³ sii²¹ Chipre. ");
INSERT INTO chqNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Mo gatyalíin² coon²¹ fuu²¹ sii²¹ Salamina ga'láa² 'wii²¹² cwoo¹o júu³ tyʉ́² tya' Dios tsi inʉʉ cwo'¹ sinagoga si'² do. Joon ngóo¹ coon'¹³on jaain²¹ 'in sii²¹ Wó³ 'e uncoon'¹³ 'ii. Ngɨɨ¹‑ɨ la caain²¹ do. ");
INSERT INTO chqNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Joon gatyalíin² coon²¹ fuu²¹ sii²¹ Pafos. Joon do‑o gatsee'²¹i jaain²¹ tsá² Israel 'in sii²¹ Barjesús. Tɨ́ɨ²i júu³ loo¹. Coon'²¹on tsá² tóo², gajin'²in 'e 'ii‑o cwoo¹o júu³ tyʉ́² tya' Dios. ");
INSERT INTO chqNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","'In tsalaai¹ do tyíin¹in coon'¹³ jaain²¹ 'in tyʉ'² to² sii²¹ Sergio Paulo. Jaain²¹ tsá² jmɨɨ¹‑tsi 'in Sergio do joon gatyʉ'²ʉ to² 'e gajó² Bernabé coon'¹³ Saulo tsʉ 'iin²¹²in nuu¹un júu³ tyʉ́² tya' Dios. ");
INSERT INTO chqNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Pe 'in tsalaai¹ do sii²¹o jon Elimas. ('øøi'²¹‑tsi tsá² sii²¹ Tsalaai¹.) Joon 'in tsalaai¹ do gauntyíi²in Bernabé coon'¹³ Saulo tsʉ jo 'iin²¹²in 'e jo'¹ liin¹ Sergio do. ");
INSERT INTO chqNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Joon 'in sii²¹ Saulo do, sii²¹o jon Poo², sɨrøøi²¹ Espíritu Tyʉ́² tya' Dios alma tya'a. Joon gajǿøi² coon'²¹ tún² lɨɨlɨ¹. ");
INSERT INTO chqNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Joon gajin'²in sɨɨ'²¹ɨ Elimas do: ―¡'In coon'²¹ tsá² tóo² 'nʉ‑ʉ! Joon 'in 'lɨɨ'³mo 'nʉ. 'In 'aa'¹ jilaa'²¹ 'e tyʉ́² 'nʉ, joon jmoo²'o jilaa'²¹ 'egó². ¿'Ee lɨ' fu'²'u tsá² 'e júu³ gó² 'e júu³ tyʉ́² tya' Ña'ñʉ'¹ʉ'? ");
INSERT INTO chqNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Pe la nano‑o ilisá² coon²¹ 'ii'²¹ tyi'i icwó² Ña'ñʉ'¹ʉ'. Ilitiuu²'u. Jo lí² jǿø¹³'ø 'yiia²¹ 'íi¹ juncwii²¹ coon²¹ sii'¹³xʉ ―jin'² Poo² do. La tsifu joon galitʉʉ²mo. Jo jnaa'²¹gɨ coonti. Joon ga'naa'¹²i jaain²¹ 'in tsajaa²¹²i 'ii. ");
INSERT INTO chqNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Galija'²mo lɨ́ɨi² 'in Sergio do mo ganí²in jilaa'²¹ 'elo. Lɨ́ɨ¹ ganga'goo²¹‑tsi jilaa'²¹ júu³ cwáain¹ tya' Jesús. ");
INSERT INTO chqNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Poo² coon'¹³ tsá² coon'¹³on ngataa²i tsi coon²¹ barco fu Pafos do. Joon ngaliin² fu Perge 'e náa¹ lɨ sii²¹ Panfilia. Pe do‑o gatʉ́ʉ²mo Wó³ 'ii. Joon ganga'²mo fu Jerusalén. ");
INSERT INTO chqNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Mo lɨ cɨɨin²¹gɨ 'in catyaai² do‑gɨ gangɨ́ɨ¹i fu Perge. Joongɨ tyalíin² fu Antioquía náa¹ lɨ sii²¹ Pisidia. Mo jmɨɨ²¹² 'ii'²¹ 'woo'²¹ tsá² ngataa²i tsi inʉʉ cwo'¹ sinagoga tya' tsá² Israel. Do‑o gacwó²o. ");
INSERT INTO chqNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Joon jaain²¹ tsá² do gauntsáa¹a coon'²¹ sii'¹³xʉ lɨ sii²¹ ley tya' Moisés. Jaain²¹gɨ coon'²¹ sii'¹³ tya' jí² 'e gajmaa¹a 'in gafaa'²¹a júu³ tyʉ́² tya' Dios calɨɨ. Mo ngayuui'¹³ joon 'in tsafeei'¹ tya' cwo'¹ do gatyʉ'²ʉ to² gajin'²in: ―Tsaru'¹u', wana 'oo²oo' coon²¹ júu³ tyʉ́² tya' 'in tsá² néei¹ no, lí²‑i foo²oo' nano. ");
INSERT INTO chqNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Joon garoon²on Poo² lɨ tyíin¹, gajmaa¹a coon²¹ li² coon'¹³ cwoo²¹o 'e ján² tsá² tii². Joon gajin'²in: ―Nʉ́ʉ²duu' tsá² Israel joongɨ jileei'²¹ 'in tsáai¹‑tsi Dios. ");
INSERT INTO chqNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Dios tya' tsá² Israel nigatyii'¹²in 'lɨɨ²¹² tsacøøi'¹³ tyi'. Joon mo gateen¹in lɨ sii²¹ Egipto, do‑o gangafúu²mo tsacøøi'¹³ tyi' fiin'¹³ jo taain²¹²gɨ goo¹o. Mo la cɨɨin²¹ joon Dios ga'woo²¹mo 'a Egipto do coon'¹³ 'ii'²¹ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Joon gacwoo²¹o Dios 'in tsá² do jilaa'²¹ 'e 'ná¹ la 'ɨɨ²¹² gangɨɨ¹ɨ lɨ jo 'in tsá² seein²¹ jiin'¹³ la gatséi¹ tunló¹ jiin²¹. ");
INSERT INTO chqNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Joon ga'in¹ ca la dyía¹ fuu²¹ náa¹ fu lɨ sii²¹ Canaán do. Joon gacwo'¹o jɨ dyía¹ fuu²¹ do 'lɨɨ²¹² tsacøøi'¹³ tyi' 'e galɨ́² tya'a. ");
INSERT INTO chqNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Mo la cɨɨin²¹ joon²¹ gatyʉ² Dios to² 'e liseein²¹ tsá² jmáa¹a 'ii'²¹ jee²¹² 'ii 'in tyʉ'² to² 'ii. La joon galí² ca gatséin¹ tyʉ́n² cíein¹³ tsi ca'no'³gɨ cíein¹³ jiin²¹. Ca mo gasii¹in Dios jaain²¹ 'in cwo¹ júu³ tyʉ́² tya'a sii²¹ Samuel. ");
INSERT INTO chqNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Mo ngayuui'¹³ joon gamúu¹i tsacøøi'¹³ tyi' jaain²¹ rǿøi¹³ 'in tyʉ'² to² 'ii. Joon gacwóoi¹ Dios 'ii jaain²¹ rǿøi¹³ sii²¹ Saúl. Jóon¹ Cis 'ii. Benjamín sii²¹ 'lɨɨ²¹² tsafeei'¹ tya'a. Tunló¹ jiin²¹ gatyʉ'² Saúl do to² lawa røøi'¹³. ");
INSERT INTO chqNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Mo la cɨɨin²¹ joon gatyii¹mo Dios 'ii 'e jo 'ee to² tyʉ'²gɨ. Joon gacwo'¹o 'lɨɨ²¹² David 'e tyʉ'²ʉ to² cwáain¹ tya' Saúl. Joon gajin'² Dios: “Ñíi³oo 'e David, jóon¹ Isaí do, jaain²¹ 'in 'ɨ¹‑tsi la 'ɨ¹‑tsii. Joon 'e 'ii‑o ijmáa¹a jilaa'²¹ to² 'e tyʉ'³ʉʉ.” ");
INSERT INTO chqNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Jaain²¹ jún² tsaruu'²¹i 'lɨɨ²¹² David do galisii²¹ Jesús. Joon Dios gajmaa¹a 'e Jesús do 'in jmaa¹a tiin'¹³ tsá² Israel. Jilaa'²¹ 'elo nigajin'² Dios calɨɨ. ");
INSERT INTO chqNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","La nʉ'gɨ ijó¹ Jesús gajó² Wó³ saai¹ tsá² jmɨɨ²¹. Joon gacwo'¹o jileei'²¹ tsá² Israel júu³ tyʉ́² jin'²in: “'E 'ná¹‑a sáa¹naa' jmɨɨ²¹. Joongɨ unsɨ́ɨ²naa' 'e 'ɨ¹‑'oo'.” ");
INSERT INTO chqNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Tɨ lɨ jatyéein¹ 'e tyéi¹ to² jmoo¹o Wó³ joon gajin'²in: “Tsá² xee'²¹mo jna jon' jna 'i 'in lɨ́ɨ²naa'. Mi yuui'¹³ jna ijó¹ jaain²¹gɨ 'e jiin'¹³ jo tɨ́ɨ²na jmáa³aa sɨtuu'²¹na 'e sii'¹³ii loo²¹ tsi mɨ́ɨ¹i” ―jin'² Wó³ saai¹ tsá² jmɨɨ²¹. ");
INSERT INTO chqNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Joon tyaa¹gɨ Poo² júu³: ―Tsaru'¹u', lɨ́ɨ¹naa' jún² tya' 'lɨɨ²¹² Abraham coon'¹³ jileei'²¹ 'in tsáai¹‑tsi Dios. Tyi'naa'oo' 'e júu³ lo tya' xiiala 'e tiin'¹³ tsá². ");
INSERT INTO chqNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jileei'²¹ 'in galiseein²¹ Jerusalén joongɨ tsacøøi'¹³ tya'a jo ñii¹i 'in Jesús do. Jon'gɨ 'øøi'²¹‑tsi júu³ tya' 'in gafaa'²¹ júu³ tya' Dios calɨɨ fiin'¹³ untsáa¹o júu³ tya' 'ido la coon²¹ mo sóo¹. Joon 'in tsá² do mo ga'nɨɨi¹ Jesús do gauntsiin¹in júu³ tya' 'in gafaa'²¹a júu³ tya' Dios calɨɨ. ");
INSERT INTO chqNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Joon mo jo gatsaa'²¹a jiin'¹³ coon²¹ tsaa² tya' 'ido gamɨɨ'¹ɨ Pilato wa'a ityʉ'²ʉ to² jnga'²mo. ");
INSERT INTO chqNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Joon la joon mo gatsín¹ jilaa'²¹ 'e jin'² ni jí² tya' Dios cwáain¹ tya' 'ii. Joon gaxíi²a tsá² cuerpo tya'a tsaa' crúu¹³. Joon ga'aa¹mo tsá² 'ii. ");
INSERT INTO chqNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Pe Dios gajmaa¹o 'e gajiin'¹o jee²¹² 'lɨɨ²¹². ");
INSERT INTO chqNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Joon lɨ́ɨ¹ 'láai² jmɨɨ²¹² gangɨ́ɨ²i 'in Jesús do gajnéi¹ tyani 'in ningalíin² coon'¹³on fu Galilea mo ngóo¹ fu Jerusalén. Joon la joon 'in tsá² do jmoo¹o júu³ jilaa'²¹ 'e ganii²¹ sɨɨ'²¹o tsá². ");
INSERT INTO chqNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","’Joon la joon jmoo'¹³o'o júu³ 'naa' jilaa'²¹ júu³ tyʉ́² 'e nigacwo'¹o Dios 'lɨɨ²¹² tsacøøi'¹³ tyi'. ");
INSERT INTO chqNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Joon mo gaunjiin'¹in Dios Jesús coon'¹³ 'e joon nigauntsiin¹mo 'ii'²¹ tya'a la lɨ́² 'e nigajin'²in sɨɨ'²¹ɨ 'lɨɨ²¹² tsacøøi'¹³ tyi'. Jilaa'²¹ 'elo niganee²¹e'e. La lɨ́² 'e nigajin'² ni jí² tya' Dios. Nʉ́ʉ²ʉʉ' lɨ tɨ tún² salmo: “Yʉʉn²¹ tyia‑oo 'nʉ. Nano‑o nicwóo³‑oo juncwii²¹ tyi'i”, jin'² Dios Jmii²¹. ");
INSERT INTO chqNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Jin'²in jon júu³ tya' Dios: “Icwo'³oo 'naa' 'e cwaai'³ la lɨ 'ii'²¹ 'e gafuu²¹²uu 'lɨɨ²¹² David.” Coon'¹³ 'e júu³ lo‑o ga'ɨ́ɨ² Dios Jmii²¹ júu³ 'e iunjiin'¹o Jesús jee²¹² 'lɨɨ²¹². Joon 'e jo ixiia'²¹ cuerpo tya'a. ");
INSERT INTO chqNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Jee²¹² salmo xiia' jin'² David do sɨɨ'²¹ɨ Dios: “Jo icwoo²'o 'e ixiia'²¹ cuerpo tya' tsá² tyi'i, 'in gatyii'¹³un.” ");
INSERT INTO chqNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Pe David do‑o gauncoon'¹³on tsá² jiin'¹³ la mo seein²¹ la lɨ 'e gatyʉ'² Dios to². Joon mo lɨ cɨɨin²¹ gajún¹mo jon. Ga'aa¹mo tsá² 'ii. Joon gajgoo'²¹ cuerpo tya' 'ido. ");
INSERT INTO chqNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Pe cuerpo 'e nigajmaa¹a Dios gajiin'¹ do jo gajgoo'²¹ 'e joon. ");
INSERT INTO chqNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Tsaru'¹u', 'ná¹‑a liñí³ii' 'e Dios lí²‑i 'iin² tsaa² tya' tsá² 'wii²¹² cwáain¹ tya' Jesús do. ");
INSERT INTO chqNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","'Wii²¹² tya' 'ii‑o jileei'²¹ 'in tsáai¹‑tsi 'ii 'iin²mo tsaa² tya'a. Pe jilee'²¹ 'in 'iin²¹²in jmá¹ jiin'¹³ la to² tyʉ'² Moisés jo 'iin²in tsaa² tya' 'ii. ");
INSERT INTO chqNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Tɨ́ɨ¹moo', un'øøi'¹ yaanaa'; xuun cwolí² la lɨ 'e gajin'² tsá² gafaa'²¹a júu³ tya' Dios calɨɨ mo gajin'²in: ");
INSERT INTO chqNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Jóo²duu' tsá² 'in un²gøøi¹ Dios, tsá² 'goo'²¹‑'oo' joongɨ cwojuun²naa'. Tsʉ jna‑a Dios, joon jmóo³oo coon²¹ to² fee'¹ 'e jo jai'² ilɨ́ɨ²naa' fiin'¹³ jmoo'¹³o tsá² 'naa' júu³. La joon jin'² jí² tya' Dios jin'² Poo² do. ");
INSERT INTO chqNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Mo gacwo'ɨ́ɨ¹ Poo² coon'¹³ tsá² ngɨ¹ coon'¹³ 'e cwo'¹ sinagoga do 'in tsá² jo seein²¹ Israel gamɨɨ'¹ɨ 'e cwo¹ Poo² 'e júu³ do mi tɨ tún² jmɨɨ²¹² 'ii'²¹ 'woo'²¹ tsá². ");
INSERT INTO chqNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Mo ngayuui' gatséi¹ 'e sɨcaain²¹ tsá² 'in taai² cwo'¹ do fúu¹mo tsá² Israel gauncaain²¹ coon'¹³ Poo² joongɨ coon'¹³ Bernabé. Joongɨ gauncaain²¹ 'inlɨ́ɨi¹³ tsá² 'in jo seein²¹ joon pe niga'láa²o 'wii²¹² tsáa¹mo‑tsi Dios la lɨ́ɨ¹i tsá² seein²¹ Israel. Joon Poo² coon'¹³ Bernabé ga'ɨ́ɨ² júu³ 'e jo 'iin²‑tsi xiiala 'neei¹ Dios tsá². ");
INSERT INTO chqNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Mo gatí² tún² jmɨɨ²¹² 'ii'²¹ 'woo'²¹ tsá² do galicaain²¹ jilee'²¹mo 'in tsá² seein²¹ 'e fuu²¹ do 'e janʉ́ʉ² júu³ tya' Dios do. ");
INSERT INTO chqNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Mo ganí²i 'in tsá² Israel do 'e lɨ́ɨ¹ fúui¹ tsá² galicaain²¹ ga'aa¹a tsiiwúu¹. Joon ga'láa² 'wii²¹² jo cwo'¹o júu³ ruu'²¹i coon'¹³ Poo². Joon ga'láa² 'wii²¹² jíi²in Poo². ");
INSERT INTO chqNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Joon Poo² coon'¹³ Bernabé do jo 'goo'²¹o coonti gafaa'²¹a jin'²in: ―'Naa'‑a tɨ́ɨ²naa' nuu²uu' júu³ tyʉ́² tya' Dios nifu tsʉ tsá² Israel 'naa'. Pe jogɨ 'iin²¹²naa' cwolíin²naa' coon'¹³ Dios coonti. Tsʉ la joon tsáa³oo'o tsacwoo²¹o'o júu³ 'in jo seein²¹ Israel do. ");
INSERT INTO chqNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Tsʉ la joon nigatyʉ'² Ña'ñʉ'¹ʉ' to² ni jí² tya'a 'e jin'²: Nigajmé¹na 'nʉ lawa jɨ́² 'e coo²¹ tyani tsá² taain²¹² fu juncwii²¹. 'Ná¹‑a jmaa²'a júu³ tya' xiiala 'e tiin'¹³ tsá² la tøøi² ni cwoo'¹³ juncwii²¹. ");
INSERT INTO chqNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Mo ganúu²un 'in tsá² jo seein²¹ Israel do 'elo lɨ́ɨ¹ gatɨ́²‑tsi. Joon ga'láa² 'wii²¹² gajin'²in 'e 'áa¹mo tyʉ́² 'e júu³ tya' Ña'ñʉ'¹ʉ'. Joon galija'²mo lɨ́ɨi² jileei'²¹ 'in nigatyiin'¹³ Dios. ");
INSERT INTO chqNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Joon la joon gafaa'²¹a tsá² júu³ tyʉ́² tya' Dios la caain²¹ lɨ san'² 'e fuu²¹ do. ");
INSERT INTO chqNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Joon 'in tsá² seein²¹ Israel do gasɨ́ɨ²i coon'¹³ tsacǿøi'¹³ 'in tyiin²gɨ seein²¹ 'e fuu²¹ do coon'¹³ 'inlɨ́ɨi¹³ tsamɨ́² tyúi¹ 'in tsaa'¹‑tsi dioses tya'a 'áai¹ joon coon'¹³ la joon ga'láa² 'wii²¹² untyíi²in Poo² coon'¹³ Bernabé. Joon gatyii¹mo 'e fuu²¹ do. ");
INSERT INTO chqNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Pe Poo² coon'¹³ Bernabé ga'wo'²o mɨɨ²ɨ. Joon gaxʉ'²ʉ 'laa²¹ toon²¹² mɨɨ²ɨ lawa coon²¹ li² 'e fuu²¹ do 'e nigajmaa¹o coon²¹ 'e gó². Joon ngalíin²mo fuu²¹ Iconio. ");
INSERT INTO chqNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Pe 'in jai'² lɨ́ɨi² 'in néei¹ Antioquía do lɨ́ɨ¹ jløø'³i, joon røø¹mo 'in Espíritu Tyʉ́² tya' Dios. ");
INSERT INTO chqNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Mo gatyalíin² Poo² fu Iconio gangataai² caan²¹mo fu cwo'¹ sinagoga. Joon gafaa'²¹a coon²¹ júu³ 'in sɨcaain²¹ do. Joon lɨ́ɨ¹ fúui¹ tsá² Israel do coon'¹³ tsá² jo seein²¹ joon gaja'²mo lɨ́ɨi². ");
INSERT INTO chqNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Pe 'in tsá² Israel do 'in jo jo'¹ lɨ́ɨi² gajmaa¹a 'e ga'ɨ¹‑tsi 'in tsá² jo seein²¹ Israel do jilaa'²¹ 'e gó² tya' 'in tsá² jai'² lɨ́ɨi² do. ");
INSERT INTO chqNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","'Wii'¹³ joon lɨ́ɨ¹ wóo² gajaan¹an do. Jo 'goo'²¹o. Gacwoo¹o júu³ 'wii'¹³ jo cu'²‑tsi coon'¹³ Ña'ñʉ'¹ʉ'. Joon Ña'ñʉ'¹ʉ' gacwoo¹o li² coon'¹³ milagro 'e jmoo¹o 'in tsá² do. Coon'¹³ 'e la joon litsáa¹mo‑tsi tsá² 'e la ja'²mo 'iin²¹²mo Dios tsá² la lɨ́² 'e faa'²¹a 'in tsá² do. ");
INSERT INTO chqNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Pe 'in tsá² fuu²¹ do jo cwo'¹o júu³ ruu'²¹i. 'Inlɨ́ɨi¹³ tsá² faa'²¹a tyʉ́² tya' tsá² Israel do joon 'inlɨ́ɨi¹³gɨ faa'²¹a tyʉ́² tya' tsá² tya' Jesús do. ");
INSERT INTO chqNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Joon 'in jo jo'¹ lɨ́ɨi² seein²¹ Israel coon'¹³ 'in jo seein²¹ joon sɨ́ɨi² røø²¹ coon'¹³ 'in tsaa'to² do itsajíi¹i joongɨ itsatyuu'¹²i cuun²¹² 'ido. ");
INSERT INTO chqNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Pe mo galili'³i Poo² coon'¹³ Bernabé do gacwiin¹o fu Listra coon'¹³ Derbe 'e náa¹ lɨ sii²¹ Licaonia coon'¹³ la cu' lɨ' joon. ");
INSERT INTO chqNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Do‑o jon nigacwoo¹o júu³ tyʉ́² tya' xiiala 'e tiin'¹³ tsá². ");
INSERT INTO chqNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Fu Listra do galiseein²¹ jaain²¹ tsañʉʉ'¹ 'in jo lí² ngɨ¹. Do‑o tyíin¹in tsʉ tsá² jluui'¹³ ca la mo lɨ seen²¹mo. Jiin'¹³ coon²¹ naa'¹³ jo mo gangɨɨ¹ɨ. ");
INSERT INTO chqNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Joon 'in tsañʉʉ'¹ do nuu¹o jilaa'²¹ júu³ tya' Poo² do. Joon gajǿøi² Poo² do 'ii. Joon galili'³i Poo² do 'e 'ii‑o jo'¹o lɨ́ɨi² Dios 'e 'láa²mo. ");
INSERT INTO chqNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Joon gajin'² Poo² coon'¹³ coon²¹ júu³ tá² lɨɨlɨ¹: ―Røø²¹ sii'²¹ tɨ́ɨ¹³'ɨ. Joon 'in tsañʉʉ'¹ do gasii'²¹o tɨɨ²ɨ. Coon²¹ ga'ɨ́ɨ²i la no‑o. Tsifu joon gangɨ¹o. ");
INSERT INTO chqNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Mo ganí²i 'in tsá² fuu²¹ do jilaa'²¹ 'e gajmaa¹a Poo² do joon ga'láa² 'wii²¹² ga'oo¹o coon'¹³ jmíi¹ tya' tsá² seein²¹ Licaonia, jin'²in: ―¡Dios 'in lɨ́ɨi¹ la lɨ́ɨi¹ tsá²‑a nigajgái¹ fu lɨ saa²¹²an'! ");
INSERT INTO chqNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Jin'²in 'in tsá² do 'e Bernabé do lɨ́ɨ¹i dios tya'a 'in sii²¹ Júpiter joongɨ 'e Poo² do lɨ́ɨ¹i dios tya'a 'in sii²¹ Mercurio, tsʉ 'ii lɨ́ɨ¹i 'in faa'²¹ do. ");
INSERT INTO chqNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Joon 'e cwo'¹ tya' Júpiter do si' tyan' tɨ' fuu²¹ do. Joon 'in untsá² do gajajée¹i joo'²¹ joongɨ jilaa'²¹ lí³ 'ya'²gɨ lɨ suui²¹ fuu²¹ do. 'I‑i coon'¹³ 'in tsá² do 'iin²¹²in un'goo²¹o Poo² coon'¹³ Bernabé do. Ijngaa'¹²i 'in joo'²¹ do 'e un'goo²¹o dios tya'a. ");
INSERT INTO chqNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Pe mo ganúu²un 'in tsá² tya' Jesús do, Bernabé coon'¹³ Poo², jilaa'²¹ 'elo, ga'láa² 'wii²¹² ga'gɨɨ²¹ɨ sɨɨn'¹³ɨn. Joon ngataai² jee²¹² 'in tsá² do 'oo¹o jin'²in: ");
INSERT INTO chqNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","―¡Tsañʉʉ'¹! ¿'Ee lɨ' jmoo²oo' la no? ¡Tsá² la 'naa'‑a jna'a! Canii² to² nijalii²¹i'i 'e sii'¹³i'i 'naa' 'e júu³ tyʉ́² 'e tʉ́³oo' jilaa'²¹ 'elo 'e jo 'ee to² tí¹. Joon ngɨ́³oo' coon'¹³ Dios, 'in seen²¹mo, tsʉ 'ii gajmaa¹a juncwii²¹. Joongɨ 'ii gajmaa¹a ni cwoo'¹³ coon'¹³ jmɨ'ñi'³ joongɨ jilaa'²¹ 'e sá² jee²¹² 'ii. ");
INSERT INTO chqNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","La mo jéei¹ gacwoo¹o 'e ngɨ¹ jileei'²¹ tsá² jiin'¹³ xiiala 'iin²¹²in. ");
INSERT INTO chqNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Pe cwoo¹‑o li² 'e seen²¹mo coon'¹³ jilaa'²¹ 'e tyʉ́² 'e jmoo¹o. No síi¹in jmɨ́¹ lɨ saan²¹²an' roo²¹ jilaa'²¹ 'e jñii²¹i'. Joon cwo'¹o jna' la líin²mo 'e tyú¹na' ―jin'² Poo². ");
INSERT INTO chqNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Pe fiin'¹³ gacwoo¹o Poo² jilaa'²¹ 'e júu³ lo 'in tsá² do 'iin²¹²mogɨ jngaa'¹²in 'in joo'²¹ do. 'Iin²¹²in un'goo²¹o 'in tsá² do. ");
INSERT INTO chqNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Joon gatyalíin² jaain²¹ gái¹ tsá² Israel 'in néei¹ fu Antioquía coon'¹³ 'in néei¹ Iconio. Joon galɨ'¹o gasɨɨ'²¹ɨ tsá² 'e tyuu'¹³mo cuun²¹² 'in Poo² do. La joon gajmaa¹a. Joon gajñuu¹in lɨ' tɨ' fuu²¹ do. Lɨ́ɨi² 'e nijúun²mo 'ido. ");
INSERT INTO chqNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Pe joon mo galicaain²¹ jaain²¹ gái¹ 'in jai'² lɨ́ɨi² do cu' lɨ' lɨ raain¹ Poo² do joon garóon²‑o. Ga'í²‑o 'e fuu²¹ do tún¹. Mo gajná² jmɨɨ²¹² joon ga'woo²¹mo coon'¹³ Bernabé. Ngalíin² fu Derbe. ");
INSERT INTO chqNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Mo gacwoo¹o júu³ tyʉ́² tya' 'e tiin'¹³ tsá² tya' 'in néei¹ Derbe do lɨ́ɨ¹ fúui¹ tsá² gajai'² lɨ́ɨi². Mo ngayuui'¹³ joon ngaliin¹ tún¹ fu Listra coon'¹³ Iconio coon'¹³ Antioquía. ");
INSERT INTO chqNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Do‑o nigatyaa¹‑tsi 'in nigajai'² lɨ́ɨi² lɨ ningaliin¹ do. Gajin'²in sɨɨ'²¹ɨ 'ido: ―'Ná¹‑a jai'²gɨ liin²¹naa' júu³ tya' Jesús. 'Ná¹‑a nee²¹e' wúu¹ jiin'¹³ la joon lí²‑i tsatoo²o' lɨ tyʉ'² Dios to² ―gajin'² Poo² do. ");
INSERT INTO chqNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Joongɨ gatyii'¹³mo tsacøøi'¹³ 'in tyʉ'² to² jee²¹² 'in jai'² lɨ́ɨi² la coon²¹ fuu²¹. La jo mo gøø'²¹ø gafaa'²¹o júu³ tyʉ́² jin'²in: ―Ña'ñʉ'¹ʉ', uncoon'¹³ jileei'²¹ tsá² lo tsʉ nigalija'²mo lɨ́ɨi² 'nʉ. ");
INSERT INTO chqNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Mo ngayuui'¹³ gangɨ́ɨi¹ fu lɨ sii²¹ Pisidia gatyaliin¹ lɨ sii²¹ Panfilia. ");
INSERT INTO chqNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Do‑o gacwoo¹o júu³ tyʉ́² fuu²¹ sii²¹ Perge. Joongɨ tyaliin¹ fu Atalia. ");
INSERT INTO chqNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Do‑o ngataai² tsi barco. Joon ngaliin¹ tún¹ fu Antioquía lɨ ga'láa² 'wii²¹² 'ee¹ júu³ tyʉ́². Mo ga'woo²¹i 'e fuu²¹ do nifu jileei'²¹ 'in jai'² lɨ́ɨi² Dios do nigamɨ'¹o Dios, 'in 'iin²¹²in tsá², 'e uncoon'¹³on Poo² coon'¹³ Bernabé jilaa'²¹ to² 'e nigaun'yee¹mo nano. ");
INSERT INTO chqNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Joon mo gatyaliin¹ fu Antioquía do gauncaain²¹ jileei'²¹ 'in jai'² lɨ́ɨi². Joon Poo² coon'¹³ Bernabé gatyaa¹ júu³ ce jilaa'²¹ 'e gajmaa¹a Dios lɨ ngalíin². Gajin'²o xiiala gajmaa¹a Dios 'e gajo'¹o lɨ́ɨ²i 'in jo seein²¹ Israel. ");
INSERT INTO chqNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Joon Poo² coon'¹³ Bernabé gajaan¹an coon²¹ sii'¹³ coon'¹³ 'in tsá² jo'¹ lɨ́ɨi² néei¹ do. ");
INSERT INTO chqNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Jee²¹² jmɨɨ²¹² joon 'inlɨ́ɨi¹³ tsá² ga'woo²¹i fu Judea. Mo gatyalíin² Antioquía do ga'láa² 'wii²¹² 'e'²e 'in jo'¹ lɨ́ɨi² do 'e 'ná¹ jmáa¹a 'ido jiin'¹³ la tɨɨsi'² to² 'e nigatyʉ'² Moisés. Jiin'¹³ la joon lí² tiin'¹³mo tsá². Lɨ́ɨ¹ jo cwo¹ Poo² coon'¹³ Bernabé júu³ ruu'²¹i coon'¹³ 'in tsá² do. ");
INSERT INTO chqNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pe Poo² coon'¹³ Bernabé galisá² 'ii'²¹ tya'a coon'¹³ 'in tsá² do 'e 'ii‑o coon'¹³ 'inlɨ́ɨi¹³ catyaai² do itsaliin¹ Jerusalén tsafee'¹²i 'in apóstoles néei¹ do coon'¹³ 'in tsacøøi'¹³ tya' 'in jai'² lɨ́ɨi² do cwaain²¹ tya' 'e júu³ do. ");
INSERT INTO chqNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Joon 'in jai'² lɨ́ɨi² fu Antioquía do ngóo¹o 'ɨɨ¹ɨ júu³ Poo² coon'¹³ 'in catyaai² do. Joon gangɨ́ɨ¹i la caain²¹ fuu²¹ náa¹ lɨ sii²¹ Fenicia coon'¹³ Samaria. Lɨ ngalíin² do gatyaa¹ júu³ 'e xiiala nigatʉʉ²¹ 'in jo seein²¹ Israel tɨɨ² tsáai² tya'a joon gatsa'²a‑tsi Dios. Joon jileei'²¹ 'in jai'² lɨ́ɨi² lɨ́ɨ¹ jløø'³i mo ganúu²un 'e cwáain¹ lo. ");
INSERT INTO chqNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Mo gatyalíin² Poo² coon'¹³ Bernabé fu Jerusalén 'in tsá² 'in jai'² lɨ́ɨi² néei¹ do coon'¹³ apóstoles coon'¹³ tsacøøi'¹³ ga'ii'²¹mo 'ii. Joon Poo² coon'¹³ Bernabé do gatyaa¹o júu³ xiiala nigajmaa¹a Dios 'wii²¹² tya'a lɨ ningalíin² do. ");
INSERT INTO chqNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Pe 'inlɨ́ɨi¹³ tsá² fariseos 'in nigajai'² lɨ́ɨi² gajmaa¹a siin'¹²in joon gajin'²in: ―Jileei'²¹ 'in nijai'² lɨ́ɨi² 'in jo seein²¹ Israel 'ná¹‑a jmáa¹a jiin'¹³ la to² tyʉ'² Moisés. ");
INSERT INTO chqNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Joon galicaain²¹ jileei'²¹ apóstoles coon'¹³ tsacøøi'¹³ do 'e lí² 'ɨ¹du'‑tsi 'e júu³ lo. ");
INSERT INTO chqNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Mo ngayuui'¹³ gatyaa¹ coon²¹ júu³ cwaa²¹ garóon² Tʉ́³ lɨ tyíin¹in joon gajin'²in: ―Tsaru'¹u', ñí²‑i 'naa' 'e ningóo¹on coon²¹ sii'¹³ mo gatyii'¹³in Dios jna jee²¹² 'naa' 'e cwóo³oo júu³ tya' xiiala 'e tiin'¹³ tsá² tya' 'in jo seein²¹ Israel. Joon lí² ja'²mo lɨ́ɨi². ");
INSERT INTO chqNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Joon Dios, 'in ñi¹ jilaa'²¹ 'e 'ɨ¹‑tsi tsá² nigacwóo¹o li² 'e niga'ii'²¹mo 'in jo seein²¹ Israel. Nigacwo'¹o 'in Espíritu Tyʉ́² tya'a la lɨ 'e nigacwo'¹o jna'. ");
INSERT INTO chqNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Coon²¹ røø²¹ lɨ́ɨ¹na' tyani Dios lagɨ 'ii. Gauntyú¹mo Dios 'ii mo galijai'² lɨ́ɨi². ");
INSERT INTO chqNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Joon nano, ¿'ee lɨ' jo jo'¹ lɨ́ɨ²naa' tsá² Israel jilaa'²¹ 'e nigajmaa¹a Dios? Cwoo²oo' coon²¹ to² 'ii²¹ 'e jo lí² jmáa¹a. Ca 'lɨɨ²¹² tsacøøi'¹³ tyi' coon'¹³ jna' jo mo galɨ'¹ɨ'. ");
INSERT INTO chqNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Lɨ' cɨɨ'¹²ɨ nitiin'¹³mo' jiin'¹³ la lɨ́² 'e nigatiin'¹³ 'in tsá² catyaai² do. Jo 'ee gacɨ́ɨin² tyi'. Untiin'¹³mo Ña'ñʉ'¹ʉ' Jesucristo jna' tsʉ 'wii'¹³ 'iin²¹²mo jna'. ");
INSERT INTO chqNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Mo ngayuui'¹³ joon jmai'² 'in gajaan¹an tii². Joon ganúu²o la 'ɨɨ²¹² tyaa¹ Bernabé coon'¹³ Poo² júu³ jilaa'²¹ li² coon'¹³ milagro 'e nigajmaa¹a Dios jee²¹² 'in jo seein²¹ Israel do. ");
INSERT INTO chqNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Mo ngayuui'¹³ gafaa'²¹a joon gajin'² Jacobo sɨɨ'²¹ɨ 'in tsá² sɨcaain²¹ do: ―Tsaru'¹u', nʉ́ʉ²duu' júu³ tyiia: ");
INSERT INTO chqNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simóoi¹³ Tʉ́³ lo nigatyaa¹a coon²¹ júu³ xiiala nigatyii'¹³in Dios nifu 'in jo seein²¹ Israel 'e galɨtsáa¹mo‑tsi 'ii. La joon galɨ́ɨ¹mo tsá² tya' Dios. ");
INSERT INTO chqNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Jilaa'²¹ 'elo lɨ la lɨ 'e gatón¹ mo'jí² tya' 'in gafaa'²¹a júu³ tyʉ́² tya' Dios calɨɨ. La nigajin'² ni jí² tya' Dios: ");
INSERT INTO chqNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Yiia²oo tún¹ mi tyá² jilaa'²¹ 'elo. Jon jmaa'¹³oo tún¹ 'nʉ́¹ David 'e nisɨcɨɨi'¹³ no. Un'mɨɨ'²moo jilaa'²¹ 'e sá²gɨ joon isaa'¹³oo, jin'² Dios. ");
INSERT INTO chqNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Joon la joon jileei'²¹ 'in seein²¹gɨ lí²‑i 'naa'²¹i Ña'ñʉ'¹ʉ' Dios. Joon jilee'²¹ tsá² jo seein²¹ Israel 'in nityi'²na lí²‑i fee'¹i jna. ");
INSERT INTO chqNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Ca la mo jée²mo Dios gajmaa¹a júu³ jilaa'²¹ ijmáa¹a. Jin'² jí² tya' Dios jin'² Jacobo. ");
INSERT INTO chqNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Faa'²¹gɨ Jacobo jin'²in: ―'Wii'¹³ joon, tsaru'¹u', la lo‑o lɨ́ɨ²na: 'E tyʉ́²gɨ wa'a jo untyíi²ingɨ' 'in jo seein²¹ Israel 'in nigatʉ́² tɨɨ² tsáai² tya'a joon nigatsáa¹‑tsi Dios. ");
INSERT INTO chqNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Liin¹mo wa'a jiin'¹³ 'e táan³a' ni jí² 'e jo lí²‑i dø'¹ø 'uunñi² 'e nisii'²¹ tsá² tyani dioses tya'a. Joongɨ jiin'¹³ coon'¹³ 'oo²¹o lí² cwuui²¹ tsá². La joongɨ 'oo²¹ tsá² jiin'¹³ coon'¹³ ñʉʉ'¹ tya'a. Joongɨ jo lí² dø'¹ø ngú¹ joo'²¹ 'in nigawuuin'²¹ tyí², jon'gɨ jmɨ¹ li²‑i dø'² tsá². ");
INSERT INTO chqNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Tsʉ ca mo lɨɨ la coon²¹ mo tɨ́² jmɨɨ²¹² 'ii'²¹ 'woo'²¹ tsá² 'e'²e tsá² inʉʉ cwo'¹ sinagoga la coon²¹ fuu²¹ jiin'¹³ ley tya' Moisés ―jilaa'²¹ 'elo gajin'² Jacobo. ");
INSERT INTO chqNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Joon la joon 'in apóstoles coon'¹³ 'in tsacøøi'¹³ coon'¹³ 'in jai'² lɨ́ɨi² do galisá² 'ii'²¹ 'e tyii'¹³in jaain²¹ gái¹ jee²¹² 'ii 'e síi¹in fu Antioquía coon'¹³ Poo² coon'¹³ Bernabé. Joon gatyii'³in Judas 'in sii²¹o jon Barsabás, coon'¹³ Silas. 'Ii jaain²¹ 'in tyiin²gɨ jee²¹² 'in tsaru'¹u' do. ");
INSERT INTO chqNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Joon coon'¹³ 'ii‑o gasii¹in 'e jí² do. 'E jí² do jin'² la lo: “'Aa²¹²moo' faa'¹³ jna'a. Jna'a, apóstoles tya' Jesús, coon'¹³ tsacøøi'¹³, coon'¹³ 'in jai'² lɨ́ɨi² catyaai², 'aa²¹²moo' sii'¹³i'i 'naa'²¹ jileei'²¹ tsaru'¹u' 'in jo seein²¹ Israel 'in néei¹ Antioquía coon'¹³ 'in seein²¹ lɨ sii²¹ Siria coon'¹³ Cilicia. ");
INSERT INTO chqNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Niganʉ́ʉ²oo'o 'e jaain²¹ gái¹ tsá² Israel 'in jai'² lɨ́ɨi² néei¹ Jerusalén nigacwalíin² lɨ seen²¹naa'. Joon nigauntyíi²in 'naa'. 'In tsá² do jo gasii²¹²na'a. Niganʉ́ʉ²oo'o 'e coon'¹³ júu³ tya'a nigaxé²mo‑'oo'. Nigajin'²in 'e 'ná¹ 'ii'¹³naa' li² 'e nigacwo¹ Moisés. Jin'²in jon 'e 'ná¹ jmaa²oo'o jiin'¹³ la 'ii'²¹ tya'o. ");
INSERT INTO chqNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Niga'ɨ¹‑tsii'i jilaa'²¹ 'elo. Joon røø²¹ gasɨɨ²¹ɨ'ɨ 'e tyʉ́² 'e tyii'¹³na'a jaain²¹ gái¹ jee²¹² jna'a 'in jalíin² fu lɨ seein²¹ 'naa' coon'¹³ Bernabé coon'¹³ Poo² 'in 'iin²¹²na'a. ");
INSERT INTO chqNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","'Ido‑o nigalíin² tóin¹ 'mó¹ 'wii²¹² tya' Ña'ñʉ'¹ʉ' Jesucristo. ");
INSERT INTO chqNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Joon sii²¹²na'a Judas coon'¹³ Silas ifee'¹i 'naa' jilaa'²¹ 'e faa'²¹ 'e jí² lo. ");
INSERT INTO chqNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","'In Espíritu Tyʉ́² tya' Dios niga'e'²e jna'a joon jna'a nigasɨɨ²¹ɨ'ɨ røø²¹ 'e jo cwoo'¹³gɨɨ'ɨ 'naa' coon²¹ to² 'e 'ii²¹‑gɨ. Jiin'¹³ 'e tyiin²gɨ la lɨ́² 'elo. ");
INSERT INTO chqNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Jo cøø²øø' jilaa'²¹ ngú¹ 'e nigasii'²¹ tsá² tyani dioses tya'a. Jon'gɨ jmɨ¹ cøø²øø'. Jon'gɨ cøø²øø' ngú¹ joo'²¹ 'in júuin² wuuin'²¹ tyí². Joongɨ jiin'¹³ coon'¹³ 'oo²¹²o lí² cwuui²¹ tsá² joon tsamɨ́² jiin'¹³ coon'¹³ ñʉʉ'¹ tya'a lí² cwuui²¹. Wana 'má²aa' jilaa'²¹ 'e júu³ lo canii²mo iliseen²¹naa'. Jiin'¹³ la joon júu³ tyii'i.” ");
INSERT INTO chqNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","La joon ngataa²mo fu¹ ngaliin¹in fu Antioquía. Mo gatyaliin¹in joon gauncaan²¹mo 'in tsá² jo'¹ lɨɨi². Joon gacwo'¹o 'e jí² do. ");
INSERT INTO chqNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Mo gajǿø²ø 'in tsá² jo'¹ lɨ́ɨi² do 'e jí² do lɨ́ɨ¹ jløø'³i jiin'¹³ cwáain¹ 'e cwo'¹o 'in tsá² do. ");
INSERT INTO chqNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas coon'¹³ Silas do tɨ́ɨ²¹mo 'e cwo¹ júu³ tya' Dios 'wii'¹³ joon gacwoo¹o júu³ 'in tsá² do. Joon lɨ́ɨ¹ fúui¹ 'in tsaru'¹u' 'in gatyá¹‑tsi. ");
INSERT INTO chqNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Mo gangɨ́ɨ²i coon²¹ tún² 'nɨ¹ jmɨɨ²¹² 'in tsaru'¹u' seein²¹ Antioquía do ga'ɨ́ɨ²o júu³ 'e ngaliin¹mo fu lɨ jalíin². ");
INSERT INTO chqNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Pe Silas do‑gɨ gatyá¹‑tsi 'e ján²‑o. ");
INSERT INTO chqNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Poo² coon'¹³ Bernabé gaján²o jon fu Antioquía do. 'Ii coon'¹³ 'in catyaai² do‑gɨ ga'e'²o joongɨ gacwoo¹o júu³ tyʉ́² tya' Dios. ");
INSERT INTO chqNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Mo lɨcɨɨin²¹ jmɨɨ²¹² joon gajin'² Poo² sɨɨ'²¹ɨ Bernabé: ―Tsaa²¹a' tún¹ tsafee'¹³na' jileei'²¹ tsaru'¹u' 'in néei¹ la caain²¹ fuu²¹ lɨ ningalii²¹i' cwoo²¹o' júu³ tyʉ́² tya' Dios. Tsajøø²¹ø' xiiala seein²¹. ");
INSERT INTO chqNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Pe Bernabé do 'iin²¹²in jée¹i Wó³, 'in sii²¹ jon Marcos. ");
INSERT INTO chqNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Pe Poo² do gajin'²in: ―'Áai¹gɨ tyʉ́² wa'a jo jee²¹²mo', tsʉ nigatʉ́ʉ²mo jna' Panfilia do. Jo gangóo¹on coon'¹³ jna' lɨ ngalii²¹i' do. ");
INSERT INTO chqNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Lɨ́ɨ¹ gasɨ́ɨ²i 'e ca gajmaa¹a tsá² jmai'² tyíin¹ la jaain²¹ la jaain²¹. Bernabé do gatyii'¹³in Marcos joon coon'¹³ 'ii ngataa²i tsi coon²¹ barco. Joon ngalíin² fu Chipre. ");
INSERT INTO chqNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","La 'ɨɨ²¹² joon Poo² do gatyii'¹³in Silas. Mo ngayuui'¹³ ga'ɨ́ɨ² tsaru'¹u' júu³ gamɨɨ¹ɨ tyani Ña'ñʉ'¹ʉ' 'e ngɨɨ¹o coon'¹³on, ga'woo²¹mo. ");
INSERT INTO chqNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Joon gangɨ́ɨ¹i fu lɨ' lɨ sii²¹ Siria joongɨ Cilicia. Do‑o gatya¹‑tsi 'in jo'¹ lɨ́ɨi² lɨ la caain²¹. ");
INSERT INTO chqNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Poo² coon'¹³ Silas gatyalíin² fuu²¹ sii²¹ Derbe coongɨ lɨ sii Listra. Joon do‑o gatsee'²¹i jaain²¹ 'in jai'² lɨ́ɨi² sii²¹ Timoteo. 'Ii jóon¹ jaain²¹ tsamɨ́² 'in niseein²¹ Israel. Pe jmii²¹gɨ jon' tsá² Israel. ");
INSERT INTO chqNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","'In jai'² lɨ́ɨi² seein²¹ fu Listra coon'¹³ Iconio tyʉ́² faa'²¹a tya' Timoteo do. ");
INSERT INTO chqNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Joon gali'iin²¹²in Poo² wa'a 'e tsáa¹a Timoteo coon'¹³on. Joon 'e jo faa'²¹gɨ tsá² Israel 'laa'²¹ tya' Timoteo Poo² do gatyʉ'²ʉ to² 'e liin¹ Timoteo 'e li² circuncisión tya' tsá² Israel, tsʉ ñii¹i tsá² 'e tsá² griego jmii²¹ 'ii. ");
INSERT INTO chqNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","La caain²¹ fuu²¹ lɨ ngalíin² gajmaa¹a júu³ jiin'¹³ la nigajin'² jí² tya' 'in apóstoles coon'¹³ 'in tsacøøi'¹³ 'in néei¹ Jerusalén. ");
INSERT INTO chqNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Joon gauntya¹‑tsi jileei'²¹ 'in ni jai'² lɨ́ɨi². La coon²¹ jmɨɨ²¹² gangafúu²mo 'in jai'² lɨ́ɨi². ");
INSERT INTO chqNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","'In Espíritu Tyʉ́² tya' Dios jo gacwoo¹o 'e tsacwó²o Poo² júu³ tyʉ́² tya' Dios fu co' li sii²¹ Asia. Joon la joon gangɨ́ɨ¹mo la caain²¹ lɨ sii²¹ Frigia coon'¹³ lɨ sii²¹ Galacia. ");
INSERT INTO chqNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","8","Joon gatyalíin²mo fu tɨ' Misia. 'ɨ¹‑tsi 'e tsataa²i lɨ sii²¹ Bitinia. Pe 'in Espíritu Tyʉ́² tya' Dios jo cwoo¹o. 'Wii'¹³ joon gangɨ́ɨ¹mo coon²¹ tsáa¹ co' lɨ sii²¹ Misia. Joon gatyalíin²mo fu Troas coon²¹ fuu²¹ náa¹ tɨ' jmɨ'ñi'³. ");
INSERT INTO chqNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Joon do‑o ganí²i Poo² coon²¹ 'e canʉʉ²¹ coon²¹ li². Ganii²¹ jaain²¹ tsañʉʉ'¹ 'in seein²¹ lɨ sii²¹ Macedonia. Siin'¹²in joon gamɨɨ¹ɨ tyani Poo² gajin'²in: ―Na¹ fu Macedonia. Na¹, uncoon'¹³ jna'a. ");
INSERT INTO chqNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Mo ngayuui'¹³ ganí²i Poo² 'e li² lo, jna‑a, Lucas gauncaan²¹na coon'¹³ Poo² do. Joon gatyaa²¹a'a tyʉ́² tyii'i. Ngalii²¹i'i fu Macedonia. Tsáa¹mo‑tsii'i 'e la ja'²mo Dios nigasii¹in jna'a tsacwoo²¹o'o júu³ tyʉ́² tya' 'e tiin'¹³ tsá². ");
INSERT INTO chqNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Ngatoo²¹o'o tsi coon²¹ barco fu Troas. Joon ngalii²¹i'i coon²¹ tsáa¹ fu coon²¹ cwoo'¹³ tyʉʉn²¹ roon¹ ni jmɨɨ²¹ sii²¹ Samotracia. Joon mo gajná² jmɨɨ²¹² joon gatyalii²¹i'i fu Neápolis. ");
INSERT INTO chqNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Mo ngayuui'¹² joon ga'woo²¹o'o gangalii²¹i'i fu Filipos. Coon²¹ fuu²¹ lɨ tyʉ'² to² Roma. Coon²¹ fuu²¹ 'e tyiin²gɨ la caain²¹ lɨ catyiia² Macedonia. Do‑o gatoon²¹o'on coon²¹ tún² 'nɨ¹ jmɨɨ²¹². ");
INSERT INTO chqNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Coon²¹ mo sóo¹ jmɨɨ²¹² 'ii'²¹ 'woo'²¹ tsá² Israel ngalii²¹i'i lɨ gasuui²¹ fuu²¹ do. Coon²¹ lɨ tɨ' jmɨɨ²¹. Coon²¹ lɨ lɨcaain²¹ tsá² tsafaa'¹²a júu³ tyʉ́². Do‑o gayii²¹a'a gacwóo¹³o'o júu³ tyʉ́² 'inlɨ́ɨi¹³ tsamɨ́² 'in nigalicaain²¹. ");
INSERT INTO chqNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Jaain²¹ jee²¹² 'in tsamɨ́² do sii²¹ Lidia. Lidia do galiseein²¹ coon²¹ fuu²¹ sii²¹ Tiatira. Joon jmoo¹o to² 'nɨɨ¹ɨ 'mɨ'² nʉʉ'¹ tyʉ́². Nitsáa¹‑tsi Dios. La 'ɨɨ²¹² nuu¹un 'e júu³ tya' Poo² do Dios gajmaa¹a 'e ga'øøi'²¹‑tsi. ");
INSERT INTO chqNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Joon gasáa²mo jmɨɨ²¹ coon'¹³ la tøøi² inʉʉ tya'a, Mo ngayuui'¹³ joon gamɨɨ¹ɨ tyanii²¹i'i jin'²in: ―Jmaa² fee'¹‑'oo' pe wana ja'²mo lɨ́ɨ²naa' 'e tsáa¹mo‑tsii Dios, mo'¹o' fu tyiia ―jin'² Lidia do. Joon gajmaa¹a 'e tyitsaa²¹²mo 'e gajóon¹³o'on. ");
INSERT INTO chqNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Cafu galɨ́² mo ngalii²¹i'i tɨ lɨ tsafaa'¹³a'a júu³ tyʉ́² gatseei'²¹na'a jaain²¹ sɨmɨ́² 'in 'oo¹o coon²¹ espíritu 'e jmoo'¹² júu³ tya' 'e unngɨɨ¹ɨ tsá². Joon lɨ́ɨ¹ jnaa'²¹ 'in ñi'fii²¹²i cuu² coon'¹³ 'e júu³ jmoo'¹²o do. ");
INSERT INTO chqNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","'In sɨmɨ́² lo ga'láa² 'wii²¹² gangɨɨ¹ɨ caluu Poo² joongɨ caluu²¹u'u. Ga'oo¹o tá² jin'²in: ―'In tsá² lo jmoo¹o la to² tyʉ'² Dios, 'in ñii²gɨ. Joongɨ tyaa¹ júu³ xiiala lí² tiin'¹³ tsá² ―jin'² sɨmɨ́² do. ");
INSERT INTO chqNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Jiin'¹³ la joon ngɨɨ¹ɨ faa'¹a la coon²¹ jmɨɨ²¹² ce jiin'¹³ do‑o gata'¹gɨ Poo² nuu¹un júu³ tya' 'in tsamɨ́² do. Joon gajiin'¹³ níi¹i joon gajin'²in sɨɨ'²¹ɨ 'in espíritu 'yuui² alma tya' 'in sɨmɨ́² do: ―Coon'¹³ 'ii'²¹ tya' 'e sii²¹ Jesucristo, tyʉ'³ʉʉ to² 'e júu¹³'u alma tya' 'in sɨmɨ́² lo ―jin'² Poo². La tsifu joon gacwo'ɨ́ɨ¹ɨ 'in espíritu gó¹ do. ");
INSERT INTO chqNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Mo galiñi¹ jileei'²¹ ñi'fii²¹i 'in sɨmɨ́² do 'e jo lí²gɨ jnaa'¹a cuu² coon'¹³on joon gasaan'¹²in Poo² coon'¹³ Silas. Joon ngajée¹i tyani tsaa'to² lɨ 'moo'¹³ nifu. ");
INSERT INTO chqNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","La joon gatyalíin²mo tyani tsaa'to² 'in jmoo¹o 'ii'²¹ nifu. Joon gacwoo¹o tsaa² jin'²in: ―'In tsá² Israel lo ngɨɨ¹ɨ untyíi²in goo²¹²o'. ");
INSERT INTO chqNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","'Ee¹e jilaa'²¹ cwáain¹ 'e jo tɨɨ²¹na' jmoo²¹o' tsʉ tsá² Roma jna' ―jin'² ñi'fii²¹² 'in sɨmɨ́² do. ");
INSERT INTO chqNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Joon fúui¹gɨ tsá² ga'láa² 'wii²¹² faa'²¹a 'laa'²¹ tya' Poo² do. 'In tsaa'to² do gatyʉ'²ʉ to² 'e gacwó² sɨɨn'³ 'in tsá² do. Joon gapóo¹i coon'¹³ sɨɨ² 'ido. ");
INSERT INTO chqNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Mo ngayuui'¹³ gapóo¹i lɨɨlɨ¹ gataa'¹i 'nʉñí³. Joon gatyʉ'²ʉ to² 'in tyʉ'² to² 'nʉní³ do 'e tsa'aa²i Poo² coon'²¹ tún². ");
INSERT INTO chqNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Mo ngayuui'¹³ ganúu²un 'in tyʉ'² to² 'nʉñí³ do jilaa'²¹ 'elo gangajée¹i Poo² coon'¹³ Silas tɨ tyan' tsi 'nʉñí³ do. Joon gato'¹o 'mó² luutɨɨ²ɨ 'ido. ");
INSERT INTO chqNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","La 'woo¹ tyianʉ́ʉ¹ Poo² coon'¹³ Silas do née¹i faa'²¹a júu³ tyʉ́² joon ga'øø¹ø 'e un'goo²¹o Dios. Jileei'²¹ 'in catyaai² do 'in taai² 'nʉñí³ do nuu¹o jilaa'²¹ 'elo. ");
INSERT INTO chqNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","La tsifu joon gajøø'²¹ goon 'wó² tá² lɨɨlɨ¹. Gadyeei'¹³ goon la tøøi² 'nʉñí³ do. Fuxʉ tsifu joon ganó¹ jilaa'²¹ 'oo² 'nʉñí³ do. Joon gaxʉʉ'²¹ʉ jilaa'²¹ cadena 'e 'ñʉ́ʉ¹ʉ cwoo²¹o 'in tsá² taai² do. ");
INSERT INTO chqNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Mo gajná²‑tsi 'in tyʉ'² to² 'nʉñí³ do ganii²¹ 'e niganó¹ jilaa'²¹ 'ooca'nʉ́¹ do. Lɨ́ɨ²i 'e niga'woo¹mo coon'²¹ tya¹. Joon gatyii¹ ñí³ tya'a 'e la mo ijngaai'¹³ 'ña'a. ");
INSERT INTO chqNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Joon gafaa'²¹a Poo² tá² lɨɨlɨ¹ jin'²in: ―Xuun'¹³ jmeei'¹³ wo'o tsʉ lo‑o taan² jna'a coon'²¹ tya¹. ");
INSERT INTO chqNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Joon 'in tyʉ'² to² 'nʉñí³ do gamɨɨ¹ɨ coon²¹ jɨ́² jneei². Joon ga'ii²¹ cwiin¹in jleei¹ 'goo'²¹o lɨɨlɨ¹. Joon gasii'²¹i 'wojníi¹i tyani Poo² coon'¹³ Silas. ");
INSERT INTO chqNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Joon ga'woo²¹mo 'ido. Joon gaunngɨɨ¹ɨ sɨɨ'²¹ɨ 'ii: ―Tsañʉʉ'¹, ¿'ee 'ná¹ jmáa³aa 'e itiin'¹³moo? ");
INSERT INTO chqNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","'Ido‑gɨ gañii¹i: ―Cwotya¹‑'o'o Ña'ñʉ'¹ʉ' Jesucristo. Joon la joon tiin'¹³mo'o coon'¹³ tsá² inʉʉ tyi'i. ");
INSERT INTO chqNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Joon gacwo'¹o Poo² júu³ tyʉ́² tya' Jesús 'ido coon'¹³ jileei'²¹ 'in taai² inʉʉ tya' 'in tsá² do. ");
INSERT INTO chqNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Joon 'woo¹ joon garun'²un 'in tyʉ'² to² 'nʉñí³ do moo'wó¹ Poo² coon'¹³ Silas lɨ icwuu'²¹. Joon 'ii coon'¹³ tsá² inʉʉ tya'a gasáa²mo jmɨɨ²¹. ");
INSERT INTO chqNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Mo ngayuui'¹³ joon gatǿ¹o fu tya'a. Do‑o gacwoo¹o 'e gagøø'²¹ø Poo² coon'¹³ Silas. Joon jløø'³mo la tøøi² inʉʉ tya'a tsʉ nigatsáa¹mo‑tsi Dios. ");
INSERT INTO chqNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Mo gajná² 'aa²¹ 'in tsaa'to² nifu do gasii¹in 'ɨɨ'¹³ tya'a 'e tsa'woo²i 'in taai² 'nʉñí³ do. ");
INSERT INTO chqNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Joon gajin'² 'in tyʉ'² to² 'nʉñí³ do sɨɨ'²¹ɨ Poo² do: ―Ningɨɨ¹mo 'ii'²¹ 'e laa²¹²moo 'naa'. La joon nilí²‑i 'woo²¹naa' 'e tyʉ́²‑ʉ. ");
INSERT INTO chqNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Pe Poo²gɨ gajin'²in sɨɨ'²¹ɨ 'in 'ɨɨ'¹³ do: ―Cwosii'¹³du'u 'in tyʉ² to² do 'e tsá² Roma jna'a. Tyíia² do nigapóo²i jna'a tyani tsá² fuu²¹. Jo gacón²du 'ii'²¹ coon'²¹ tún². Joongɨ gataa'¹²i jna'a 'nʉñí³. Joon nano‑gɨ 'iin²¹²in laai¹ jna'a 'uuin²¹. 'Ee sa lí² la joon. Ce cwojalíin²du yaai do ja'woo²i jna'a. ");
INSERT INTO chqNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","'In 'ɨɨ'¹³ do ngatya¹ júu³ tyani 'in tsaa'to² nifu do. 'Ido‑gɨ gafoo'¹mo mo ganúu²un 'e 'in tsá² Roma 'ii. Joon ngalíin²mo gamɨɨ¹ɨ wa'a jmáa¹a 'ido fee'¹‑tsi. ");
INSERT INTO chqNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Joon ga'woo¹mo 'ido fu 'nʉñí³. Joon gamɨɨ¹ɨ tyani Poo² coon'¹³ Silas wa'a 'wooi²¹ tsifu 'e fuu²¹ do. ");
INSERT INTO chqNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Mo ga'woo²i 'nʉñí³ do ngalíin²mo fu tya' 'in tsamɨ́² sii²¹ Lidia do. La nʉ'gɨ 'e tsalíin² ngajøø²¹i tsaru'¹u' joon gatya¹gɨ‑tsi 'ido. Joon ngalíin²mo. ");
INSERT INTO chqNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","La caain²¹ tya'i fu¹ lɨ ningalíin² Poo² coon'¹³ Silas gangɨ́ɨ¹i fuu²¹ 'e sii²¹ Anfípolis coon'¹³ Apolonia. Joon mo ngayuui'¹³ joon gatyalíin²mo fu lɨ sii²¹ Tesalónica. Do‑o si'² coon²¹ cwo'¹ sinagoga tya' tsá² Israel. ");
INSERT INTO chqNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","La jee²¹² 'nɨ¹ semóo¹ Poo², jiin'¹³ la tɨɨ² nisi'² tya'a, ngóo¹ fu cwo'¹ do mo gatɨ́² jmɨɨ²¹² 'ii'²¹ 'woo'²¹ tsá² Israel. ");
INSERT INTO chqNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ngatyaa¹a júu³ joon jo cwo'¹o júu³ ruu'²¹i coon'¹³on. Pe tyʉ́²‑ʉ ga'e'²e tsá² xiiala jin'² jí² tya' Dios 'e Cristo 'ná¹‑a nii²¹ wúu¹. Joon mi yuui'¹³ júun²in 'e 'ná¹‑a jiin'¹in tún¹. Joon gajin'²in sɨɨ'²¹ɨ 'in tsá² do: ―'In Jesús 'in fuu²¹²uu 'naa' lo, 'ii jon Cristo, 'in nigasii¹in Dios ijmá¹ tiin'¹³ tsá². ");
INSERT INTO chqNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","'Inlɨ́ɨi¹³ tsá² Israel do nigajo'¹ lɨ́ɨ²i. Joon gauncaain²¹ coon'¹³ Poo² coon'¹³ Silas. Joon fúu¹mo 'in jo seein²¹ Israel jo'¹ galɨ́ɨ²i. Nitsáa¹mo‑tsi Dios coon'¹³ 'inlɨ́ɨi¹³ tsamɨ́² tyiin²gɨ. ");
INSERT INTO chqNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Pe niga'aa¹a tsiiwúu¹ 'inlɨ́ɨi¹³ tsá² Israel 'in jo jo'¹ lɨ́ɨi². Gauncaain²¹ 'ido 'inlɨ́ɨi¹³ tsá² 'lɨɨi'³ soo²¹‑tsi 'in ngɨ¹ jøøi² jee²¹² 'nʉ́¹. Gajmaa'¹²a coon²¹ poo²¹² joon gatyaa¹ 'goo²¹ 'e fuu²¹ do. Gangɨɨ¹ɨ 'e fuu²¹ do 'naa'²¹i Poo² coon'¹³ Silas. Joon gangataa²i coon²¹ inʉʉ tya' jaain²¹ tsá² sii²¹ Jasón. ");
INSERT INTO chqNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Pe mo jo gatsee'²¹i Poo² coon'¹³ Silas do gajñúu¹i 'in tsá² sii²¹ Jasón do coon'¹³ 'inlɨ́ɨi¹³ tsá² jo'¹ lɨ́ɨi². Ngajée¹i tyani tsaa'to² do joon ga'oo¹o jin'²in: ―'In tsañʉʉ'¹, 'in nigauntyíi²in la tøøi² juncwii²¹ nigajalíin² lɨ' lo jon, ");
INSERT INTO chqNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","joon 'in Jasón lo niga'ii'²¹mo fu tya'a. Jilaa'²¹ 'e 'ee¹e 'in tsá² no faa'²¹a 'laa'²¹ tya' 'in tyʉ'² to² nifu 'in tyíin¹ Roma. Tsʉ jin'²in 'e seen²¹mo jaain²¹ rǿøi¹³ 'in sii²¹ Jesús 'in feei'¹gɨ lagɨ 'in tyʉ'² to² Roma. ");
INSERT INTO chqNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Mo ganúu²un 'elo 'in tsá² do coon'¹³ 'in tsaa'to² ga'láa² 'wii²¹² to'²o mɨɨ'¹³. ");
INSERT INTO chqNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Pe Jasón coon'¹³ 'in catyaai²gɨ do gacwoo¹o cuu² 'e tsáa¹mo‑tsi 'in tsaa'to² do 'e i'woo²¹mo Poo² coon'¹³ Silas 'e fuu²¹ do. Joon galáa²mo 'ido. ");
INSERT INTO chqNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","La tsifu joon 'in tsaru'¹u' do ga'woo²¹mo Poo² coon'¹³ Silas coon²¹ 'e canʉʉ²¹. Ngalíin² fu Berea. Mo gatyalíin² do joon ngalíin² cwo'¹ sinagoga. ");
INSERT INTO chqNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Wo²gɨ‑tsi 'in tsá² néei¹ Berea do lagɨ 'in tsá² néei¹ Tesalónica. Joon lɨ́¹gɨ 'yaai¹‑tsi ga'ii'²¹i júu³ tyʉ́². La coon²¹ jmɨɨ²¹² gauntsáa¹a júu³ tyʉ́² tya' Dios. Gacón²du cwáain¹ wana 'e jo'¹o 'e faa'²¹a 'in tsá² do. ");
INSERT INTO chqNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","'Wii'¹³ joon lɨ́ɨ¹ fúui¹ 'in gajo'¹ lɨ́ɨi². Jee²¹² 'in nijai'² lɨ́ɨi² do seein²¹ tsamɨ́² tyiin²gɨ 'in faa'²¹a jmíi¹ griego. Joon jo'¹o galɨ́ɨi² 'inlɨ́ɨi¹³ tsañʉʉ'¹. ");
INSERT INTO chqNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Mo galiñi¹ tsá² Israel néei¹ Tesalónica 'e Poo² taan¹in fu Berea cwoo¹o júu³ tyʉ́² tya' Dios ngalíin² ngajmáa² mɨɨ'¹³. ");
INSERT INTO chqNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Pe 'in tsá² jai'² lɨ́ɨi² seein²¹ do la tsifu joon gasii¹in Poo² lɨ tɨ' jmɨ'ñi'³. Pe joon Silas coon'¹³ Timoteo gajaan¹o fu Berea. ");
INSERT INTO chqNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","'In ningalíin² coon'¹³ Poo² ngajée¹i coon²¹ fuu²¹ sii²¹ Atenas. Joon cwoliin¹in tún¹ gatyaa¹ júu³ 'e Silas coon'¹³ Timoteo 'ná² tsalíin² tsauncaain²¹ coon'¹³ Poo la jmoono. ");
INSERT INTO chqNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","La 'ɨɨ²¹² jáan¹in Poo² Silas coon'¹³ Timoteo fu Atenas do lɨ́ɨ¹ fa'í³ lɨ́ɨ¹i. Tsʉ lɨ́ɨ¹ 'láai² nii² dioses 'in tsaa'²‑tsi 'in tsá² do. ");
INSERT INTO chqNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Tsʉ 'wii'¹³ joon ngafaa'¹²o fu cwo'¹ sinagoga joongɨ coon'¹³ 'in catyaai² 'in tsaa'²‑tsi Dios. La coon²¹ jmɨɨ²¹² ngafaa'¹²o coon'¹³ jilee'²¹ 'in taa²i 'moo'¹³ do. ");
INSERT INTO chqNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","'Inlɨ́ɨi¹³ tsá² 'in untsáa¹ júu³ tya' coon²¹ poo²¹² 'e sii²¹ epicúreos coon'¹³ 'inlɨ́ɨi¹³gɨ 'in niuntsáa¹ júu³ tya' coon²¹ poo²¹² 'e sii²¹ estoicos gatsee'²¹i Poo² joon ga'láa² 'wii²¹² gasɨ́ɨ²i: ―¿'Ee 'e jin'² 'in tsañʉʉ'¹ no? 'Áai¹ tyafo'² tyaa¹a 'goo²¹. 'Inlɨ́ɨi¹³gɨ jin'²in: ―La lɨ́ɨ¹i 'in tya¹ coon²¹gɨ júu³ tya' dioses 'in xee'²¹mo no. La lo gajin'²in tsʉ 'wii'¹³ Poo² do tyaa¹ júu³ tya' Jesús joongɨ tya' xiiala galɨ́² mo gajiin'¹in. ");
INSERT INTO chqNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Joon 'in tsá² do ngajée¹i Poo² fu coon²¹ lɨ sii²¹ Areópago. Do‑o lɨ tɨɨi²¹ lɨcaain²¹ mo sá² jilaa'²¹ 'e sɨ́ɨ¹i. Joon gasɨɨ'²¹ɨ 'ido: ―Lo‑o 'ná² lɨ ñii²i'in jilaa'²¹ 'e 'múui² 'e tyá²'a 'e'²'e. ");
INSERT INTO chqNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Fu'²'u jna'a coon²¹ júu³ 'e jo mo nʉʉ²¹ʉ'ʉ jiin'¹³ coon²¹ naa'¹³. 'Ii²¹²oo'o tsáai¹‑tsii'i 'ee 'øøi'²¹‑tsi 'e júu³ no ―jin'² 'in tsá² do. ");
INSERT INTO chqNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Tsʉ jileei'²¹ 'in seein²¹ Atenas coon'¹³ jileei'²¹ 'in jalíin² lɨ xiia' 'in néei¹ do canii² 'iin²¹²in 'e nuu¹un sɨ 'e faa'²¹a 'e jmai'² 'e 'múu²mo. ");
INSERT INTO chqNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Joon gamaa¹a Poo² siin'¹²in jee²¹² 'in tsá² do 'e fu yʉ' moo'²¹ lɨ sii²¹ Areópago do. Joon gajin'²in: ―Nʉ́ʉ³duu' tsá² seein²¹ Atenas. Nicón³oo cwáain¹ 'e 'áai¹gɨ tsáai¹‑'oo' jileei'²¹ dioses tyii'. ");
INSERT INTO chqNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Tsʉ mo ningɨ́³ɨɨ jǿø³øø la caain²¹ lɨ un'goo²oo' dioses tyii' joon gatsaa'³aa ni altar tyii' coon²¹ júu³ 'e jin'²: “Tya' 'in dios 'in jo mo galicwii¹naa'.” Pe 'in dios 'in un'goo²oo' no pe jo cwii¹naa' no 'in lo‑gɨ 'in Dios 'in foo'¹³na coon'¹³ 'naa'. ");
INSERT INTO chqNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","’'In Dios lo fii²¹² juncwii²¹ joongɨ ni cwoo'¹³ juncwii²¹ tsʉ nigajmaa¹o juncwii²¹ coon'¹³ jilaa'²¹ 'e sá². Jo seein²¹ 'ido tsi inʉʉ cwo'¹ 'e jmoo¹o tsá². ");
INSERT INTO chqNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Jon'gɨ sɨtyéen¹in jmɨɨ²¹² jilaa'²¹ 'e jmá¹ tsá². Tsʉ 'ii‑o nigacwo'¹o jna' jilaa'²¹ juncwii²¹ tyi'. 'Ii‑o nicwoo¹o tyi² 'e lee²¹e', coon'¹³ jilaa'²¹ 'e jmoo²¹o' jna' to². ");
INSERT INTO chqNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","’Coon'¹³ coon²¹ jmɨ¹ 'øø²mo gajmee¹i jileei'²¹ tsá² taain²¹² juncwii²¹. Joon 'ii gatyʉ'² to² lɨ́²‑ɨ liseein²¹ tsá² joongɨ lɨ icwá² tsá². ");
INSERT INTO chqNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","'Iin²¹²in Dios 'e 'naa'²¹mo tsá² 'ii. Coon'¹³ la joon tyee'¹³mo tsá² 'ii tsʉ jo wíin² seein²¹ Dios lɨ saan²¹ jna' la jaan²¹na'. ");
INSERT INTO chqNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Tsʉ 'ii'²¹ tya' Dios saan²¹o' joongɨ ngɨɨ²¹ɨ'. Joongɨ jmoo²¹o' jilaa'²¹a. La gajin'² 'inlɨ́ɨi¹³ poetas tyii': “Jóon¹ Dios jna'.” ");
INSERT INTO chqNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Wana jóon¹ Dios jna' jo 'ɨ¹‑tsi' 'e Dios lɨ́ɨ¹i lawa jaain²¹ fii²¹² 'in gajmeei¹ tsá² 'ña'a 'in lɨ́ɨi¹ cwanáa¹ sɨ cwataa²¹ 'ee sɨ cuun²¹² 'ee. ");
INSERT INTO chqNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","La mo jéei¹ la jo mo ñi¹ tsá² jo mo gajmaa¹a Dios jilaa'²¹ 'e jmoo¹o tsá². Pe nano nityʉ'²ʉ to² 'e jileei'²¹ 'in seein²¹ doñixiia' 'e unsɨ́ɨ²mo 'e 'ɨ¹‑tsi. ");
INSERT INTO chqNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Tsʉ nigatyii'¹³ Dios coon²¹ jmɨɨ²¹² mi jmáa¹a 'ii'²¹ tya' tsá² seein²¹ juncwii²¹. Joon coon²¹ tsáa¹ 'ii'²¹ tya'a. Joon ijmáa¹a 'ii'²¹ coon'¹³ jaain²¹ tsanʉʉ'¹ 'in nigatyii'¹³in. Joon la joon gacwo¹ Dios coon²¹ li² mo gaunjiin'¹in 'in Jesús do jee²¹² 'lɨɨ²¹² ―jin'² Poo² do sɨɨ'²¹ɨ 'in tsá² do. ");
INSERT INTO chqNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Joon mo ganúu²un júu³ tya' 'e jiin'¹ tsá² jee²¹² 'lɨɨ²¹² 'inlɨ́ɨi¹³ do gaungøø¹mo Poo² do. 'Inlɨ́ɨ¹³gɨ gajin'²in: ―'E tyʉ́²gɨ wa'a nʉʉ²¹ʉ' 'e júu³ lo mo coon'²¹ tún². ");
INSERT INTO chqNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Joon gatʉ́ʉ²mo Poo² 'ii. ");
INSERT INTO chqNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Pe 'inlɨ́ɨi¹³ tsá² do jo gatíui² Poo² do. Gajo'¹o lɨ́ɨ²i. Jaain²¹ jee²¹² 'in jo'¹ galɨ́ɨi² do 'in sii²¹ Dionisio. 'Ii jaain²¹ 'in tyʉ'² to² Areópago do. Joongɨ jo'¹o galɨ́ɨi² jaain²¹ tsamɨ́² sii²¹ Dámaris coon'¹³ 'inlɨ́ɨi¹³gɨ. ");
INSERT INTO chqNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Mo ngayuui'¹³ joon gacwo'ɨ́ɨ¹ɨ Poo² fuu²¹ Atenas. Joon gangóo¹on coon²¹ fuu²¹ sii²¹ Corinto. ");
INSERT INTO chqNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Joon do‑o gatsee'²¹i jaain²¹ tsá² Israel 'in sii²¹ Aquila, 'in galiseein²¹ coon²¹ lɨ sii²¹ Ponto. La mo jéei¹gɨxʉ Aquila do coon'¹³ 'oo²¹²o, 'in sii²¹ Priscila, ga'woo²¹i Italia gatyalíin² fu Corinto do. Ga'woo²¹mo do tsʉ 'in tyʉ'² to² nifu 'in sii²¹ Claudio gatyʉ'²ʉ to² 'e 'woo²¹mo jilee'²¹ tsá² Israel 'e Roma do. Joon ngafeei'¹³ Poo² do 'ii. ");
INSERT INTO chqNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Coon²¹ to² 'e nijmoo¹o coon'¹³ Poo². Jmoo¹‑o 'nʉ'mɨ'² tsʉ 'wii'¹³ joon do‑o gajaan¹o joon gajmaa¹o to² coon'¹³on. ");
INSERT INTO chqNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","La coon²¹ jmɨɨ²¹²mo 'ii'²¹ 'woo'²¹ tsá² Israel ngóo¹ Poo² fu cwo'¹ sinagoga. Do‑o gacwoo¹o júu³ tya' Dios. 'Iin²¹²in 'e litsáa¹mo‑tsi tsá² júu³ tya' Jesús. Gacwo'¹o júu³ tsá² Israel joongɨ 'in jo seein²¹ joon. ");
INSERT INTO chqNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Mo gatyalíin² Silas coon'¹³ Timoteo jalíin² fu Macedonia. Poo² canii² gajmaa¹a gacwoo¹o júu³ tyʉ́². Gasɨɨ'²¹ɨ júu³ coon²¹ tsáa¹ tya' tsá² Israel 'e Jesús do 'ii Cristo 'in sɨjéen¹in. ");
INSERT INTO chqNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Pe 'idogɨ gasɨɨ²i yaa‑i ga'láa² 'wii²¹² faa'²¹a 'laa'²¹ tya' Poo². Joon Poo² do gajø'²ø sɨɨn'¹³ɨn lawa coon²¹ li² joon gajin'²in: ―Tsaa² tyii' yaamoo' 'ejo tiin'¹³gɨɨ'. Jo tsaa² tyiia tsʉ lɨ́ɨ¹ nigajmáa³oo júu³. La nano‑o 'e níi³oo tya' tsá² 'in jo seein²¹ Israel. ");
INSERT INTO chqNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Joon gacwo'ɨ́ɨ¹o 'e cwo'¹ do. Joon gangaa'¹²i fu tya' jaain²¹ tsá² sii²¹ Justo. 'Ii jaain²¹ 'in un'goo²¹ Dios. Tyíin¹in caai¹ cwo'¹ do. ");
INSERT INTO chqNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Joon jaain²¹ 'in sii²¹ Crispo, 'in tyʉ'² to² cwo'¹ do, galitsáa¹mo‑tsi Ña'ñʉ'¹ʉ' Jesús coon'¹³ la tøøi² inʉʉ tya'a. La joon fúu¹mo tsá² seein²¹ Corinto do galitsáa¹mo‑tsi mo ganúu²un 'e júu³ tyʉ́² do. Mo gajo'¹ lɨ́ɨi² gasáa²mo jmɨɨ²¹. ");
INSERT INTO chqNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Joon Dios gasɨɨ'²¹ɨ Poo² coon²¹ lawa 'e cɨɨ¹ jin'²in: ―Jo jmáa³'a 'goo'²¹'o 'e cwo'³'o júu³ tyʉ́². Jo jón³'on tii² ");
INSERT INTO chqNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","tsʉ siin'¹³moo coon'¹³ 'nʉ. Joon jo 'in cwéei² saain'¹ 'nʉ jmee'²¹i 'nʉ jilaa'²¹ 'e gó². Lɨ́ɨ¹ fúui¹ tsá² tyiia 'in seein²¹ 'e fuu²¹ lo ―jin'² Dios. ");
INSERT INTO chqNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","La joon Poo² gajaan¹o coon²¹ jiin²¹ tsi ca'no'³ 'e fuu²¹ Corinto do. 'Ee¹e júu³ tyʉ́² tya' Dios jee²¹² 'in tsá² do. ");
INSERT INTO chqNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Pe la jee²¹² jmɨɨ²¹² joon gatyʉ'² Galión to² lɨ sii²¹ Acaya. Joon jee²¹² jmɨɨ²¹² joon 'in tsá² Israel do galicaain²¹ gafaa'²¹a 'laa'²¹ tya' Poo³. Joon ngajée¹i Poo² tyani tsaa'to² 'in tyʉ'² to² do. ");
INSERT INTO chqNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Joon 'in tsá² Israel do gacwoo¹o Poo² tsaa² tyani 'in tyʉ'² to² do jin'²in: ―'In tsañʉʉ'¹ lo ngɨɨ¹ to² 'e'²e tsá² júu³ 'e 'ná¹‑a tsá²‑tsi tsá² Dios 'e jo 'ee tɨɨsi'². ");
INSERT INTO chqNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Poo² ningóo¹ 'e faa'²¹o mo gajin'² Galión, 'in tyʉ² to² do, gasɨɨ'²¹ɨ tsá² Israel do: ―Tsá² Israel, nʉ́ʉ²duu' 'e ifo'³oo lo. Wana coon²¹ 'e niga'lee'²¹i 'in tsá² lo sɨ coon²¹ tsaa² fee'¹ inúu³oo coon'²¹ tún² júu³ tyii'. ");
INSERT INTO chqNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Pe wana jiin'¹³ coon²¹ la tɨɨsi'² tyii' jiin'¹³ la 'oo'²¹ yaamoo' unrøø²¹oo' 'e júu³ lo yaamoo'. Tsʉ jo 'iin²¹²moo jmáa³aa 'ii'²¹ jilaa'²¹ 'e júu³ lo. ");
INSERT INTO chqNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Joon ga'woo²¹mo tyitsaa²¹²mo fu caluu. ");
INSERT INTO chqNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Joon jileei'²¹ tsá² 'in faa'²¹ jmíi¹ griego 'in jo seein²¹ Israel gasaan'¹²in jaain²¹ tsá² sii²¹ Sóstenes 'in tyʉ'² to² cwo'¹ do. Joon gajmee'²¹i tyani 'in tsaa'to² do. Pe coonti jo 'ee gaunjíi²i Galión do. ");
INSERT INTO chqNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Wóo²gɨxʉ gajaan¹ Poo² do mo ngayuui'¹³ jilaa'²¹ 'elo. Mo lɨcɨɨin²¹ joon ga'ɨ́ɨ²o júu³ tsaru'¹u' do. Joon caan²¹mo ngalíin² coon'¹³ Priscila coon'¹³ Aquila. Joon fu Cencrea do nigauntsiin¹in Poo² coon²¹ 'ii'²¹ tya'a 'e nigamaa¹a joon gatyʉ'²ʉ po'tyíi¹i. Mo ngayuui'¹³ joon nga'ii²¹o tsi coon²¹ barco. Joon ngalíin²mo fu Siria. La nʉ'gɨ 'e tyalíin² Siria tyalíin² ");
INSERT INTO chqNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","coon²¹ fuu²¹ sii²¹ Efeso. Do‑o gatʉ́ʉ²mo Poo² Priscila coon'¹³ Aquila. Joon ngoo²¹‑o cwo'¹ sinagoga. Do‑o ngasiin¹in coon'¹³ tsá² Israel 'in lɨcaain²¹. ");
INSERT INTO chqNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Joon 'ido‑gɨ gamɨɨ¹ɨ tyani Poo² wa'a iján¹ wóo²gɨ pe jo gali'iin²¹²in. ");
INSERT INTO chqNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Pe Poo² ga'ɨ́ɨ²o júu³ 'ido gajin'²in: ―'Ná¹‑a taan¹na fu Jerusalén tsʉ 'ná¹‑a jmaa'¹³aa jmɨɨ²¹² 'e nijó¹. Pe wana cwo¹ Dios 'ii'²¹ yafoo'¹³moo 'naa' tún¹. Joon nga'ii²¹o tsi coon²¹ barco. Joon gacwo'ɨ́ɨ¹o fu Efeso. ");
INSERT INTO chqNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Mo gatyee'¹²i fu Cesarea joon ngóo¹ Poo² fu Jerusalén. Do‑o ngafee'¹³i 'in jai'² lɨ́ɨi² néei¹ do. Mo ngayuui'¹³ joon ngoo²¹‑o fu Antioquía. ");
INSERT INTO chqNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Do‑o gajaan¹an coon²¹ sii'¹³ cwaa²¹xʉ. Mo ngayuui'¹³ joon gangoo²¹‑o tún¹, gangɨ́ɨ¹i la coon²¹ fuu²¹ lɨ sii²¹ Galacia coon'¹³ Frigia. Do‑o gatya¹gɨ‑tsi 'in nijo'¹ lɨ́ɨi². ");
INSERT INTO chqNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","La jee²¹² jmɨɨ²¹² joon gatyía¹ fu Efeso jaain²¹ tsá² Israel 'in sii²¹ Apolos. Nigaliseein²¹ coon²¹ fuu²¹ sii²¹ Alejandría. Lɨ́ɨ¹ tyʉ́² tɨɨi²¹ cwoo¹o júu³ tyʉ́². Joongɨ lɨ́ɨ¹ tyʉ́² cwii¹i jí² tya' Dios. ");
INSERT INTO chqNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Joon nigauntsáa¹o fu¹ tya' Ña'nʉ'¹ʉ'. Mo faa'²¹a yaai¹‑tsi lɨɨlɨ¹. Joon 'ee¹e la ti cwáain¹ tya' Jesús fiin'¹³ ñi¹o jiin'¹³ la gasaai¹ Wó³ tsá² jmɨɨ²¹. ");
INSERT INTO chqNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Gatyaa¹ Apolos do júu³ tsi cwo'¹ sinagoga. Jo cu'²‑tsi. Pe mo ganúu²un Priscila coon'¹³ Aquila júu³ tya'a gatøø¹ Apolos do coon'²¹. Joon gacwo'¹gɨ cwáain¹ tya' Jesús tyʉ́²gɨ 'ido. ");
INSERT INTO chqNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","La mo 'iin²¹²in Apolos tsáa¹a fu lɨ sii²¹ Acaya 'in jai'² lɨ́ɨi² do gauncoon'¹³on. Joon 'in tsaru'¹u' do gacwo'¹o Apolos coon²¹ jí² 'a 'ii'²¹mo 'in tsaru'¹u' néei¹ lɨ tsáa¹a 'ii. Mo gatyíi¹a fu Acaya do lɨ́ɨ¹ tyʉ́² gauncoon'¹³on 'in tsaru'¹u' 'in nigalijai'² lɨ́ɨi² 'wii'¹³ fee'¹mo‑tsi Dios tya'a. ");
INSERT INTO chqNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Nigatyaa¹ júu³ tyani jileei'²¹ tsá² xiiala nigacai'²‑tsi tsá² Israel. Joon coon'¹³ jí² tya' Dios gajmaa¹a júu³ 'e Jesucristo 'in sɨjéen¹in do. Joon 'in tsá² seein²¹ Israel do jo lí² wa'a jo cwo'¹o júu³ ruu'²¹i. ");
INSERT INTO chqNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","La 'ɨɨ²¹² taain¹ Apolos fu Corinto do Poo² gangɨ́ɨ¹i fu tsaa' moo'²¹. Joon gajgáa¹i fu Efeso. Do‑o gatsee'²¹i 'inlɨ́ɨi¹³ 'in jai'² lɨ́ɨi². ");
INSERT INTO chqNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Joon gaunngɨɨ¹ɨ: ―¿Tɨ niga'ii'¹³naa' 'in Espíritu Tyʉ́² tya' Dios mo galitsáai¹‑'oo'? 'Ido‑gɨ gañii¹i: ―Coonti jo mo ganʉʉ²¹ʉ'ʉ 'e seein²¹ Espíritu Tyʉ́² tya' Dios. ");
INSERT INTO chqNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Joon gajin'² Poo² gasɨɨ'²¹ɨ 'ido: ―¿Xiiala nigasáa²naa' jmɨɨ²¹? 'Ido‑gɨ gañii¹i: ―Jiin'¹³ la nigasaai¹ Wó³ tsá² jmɨɨ²¹. ");
INSERT INTO chqNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Poo²‑gɨ gajin'²in: ―Mo gasaai¹ Wó³ tsá² jmɨɨ²¹ lawa'a coon²¹ li² 'e unsɨ́ɨ²mo tsá² 'e 'ɨ¹‑tsi. Pe gajin'²o 'e 'ná¹‑a tsáai¹‑tsi tsá² 'in jó¹ cɨɨin²¹gɨxʉ lagɨ 'ii. Joon 'ii Cristo. ");
INSERT INTO chqNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Mo ganúu²un 'elo jilee'²¹mo gasáa²mo jmɨɨ²¹ coon'¹³ 'e sii²¹ Ña'nʉ'¹ʉ' Jesús. ");
INSERT INTO chqNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Joon mo gataan¹an Poo² cwoo¹o tya' 'in tsá² do gajó² 'in Espíritu Tyʉ́² lɨ téen²in. Joon ga'láa² 'wii²¹² gafaa'²¹a jmíi¹ xiia'²¹. Joon gacwoo¹o júu³ 'e nigacwo¹ Dios. ");
INSERT INTO chqNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","'In tsá² do tí¹ 'ii dyatuuin¹ coon'tya. ");
INSERT INTO chqNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","La 'ɨɨ²¹² jiin'¹³ la gatsín¹ gaai²¹ sɨɨ'²¹ Poo² tsaa²¹o fu cwo'¹ sinagoga. Joon ngacwoo¹o júu³ jo cu'²‑tsi. Joon lɨɨ'²¹o tya¹‑tsi tsá² xiiala mi tyʉ'² Dios to² tsá². ");
INSERT INTO chqNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Pe 'inlɨ́ɨi¹³gɨ gali'waa'²¹‑tsi. Joon jo jo'¹ galɨ́ɨ¹i lɨ' faa'²¹gɨ 'laa'²¹ tya' júu³ tyʉ́² do tyani tsá². Joon gatyii¹mo Poo² 'ña'a jee²¹² 'in tsá² do. Joon gatøø¹o jiin'¹³ 'in nijai'² lɨ́ɨi² do coon'²¹. Ngalíin² coon²¹ lɨ untsáa¹ tsá² tya' jaain²¹ tsá² sii²¹ Tiranno. Joon do‑o gasɨ́ɨi² la coon²¹ jmɨɨ²¹². ");
INSERT INTO chqNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","La joon do‑o gateen¹in ce gatsín¹ tún² jiin²¹. Joon jilee'²¹mo 'in seein²¹ la caain²¹ lɨ sii²¹ Asia ganúu²o júu³ tyʉ́² tya' Ña'ñʉ'¹ʉ' Jesús. Lagɨ 'in tsá² Israel lagɨ 'in tsá² jo seein²¹ joon ganúu²o. ");
INSERT INTO chqNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Dios nigajmaa¹a coon²¹ milagro fee'¹ 'wii'¹³ cwáain¹ tya' Poo² do. ");
INSERT INTO chqNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Cagɨ póo¹ sɨ 'no'³ 'mɨ'² 'ee 'e nigasoin²¹ Poo² tsalii¹ fu lɨ teei'¹² tsatsaa'¹³ joon 'láa²mo coon'¹³ jmoowúu¹ 'e tyaan¹. Joon jileei'²¹ espíritu gó² 'woo²¹mo alma tya'a. ");
INSERT INTO chqNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Pe 'inlɨ́ɨi¹³ tsá² seein²¹ Israel do 'in jalíin² lɨ xiia' 'in 'wooi¹ espíritu gó² tya' tsá² gali'iin²¹²in 'wóo¹i espíritu gó² coon'¹³ 'e sii²¹ Ña'ñʉ'¹ʉ' Jesús. Joon gajin'²in sɨɨ'²¹ɨ 'in'lɨɨi'³ 'yuui² alma tya' tsá²: ―Tyʉ'³ʉʉ to² 'woo²¹naa' coon'¹³ 'e sii²¹ Jesús, 'in Jesús 'in faa'²¹a Poo² júu³ tyʉ́² tya'a do. ");
INSERT INTO chqNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","La joon nigamaa¹a dyái¹ jóon¹ tya' jaain²¹ tsá² Israel 'in sii²¹ Esceva, 'ii tsafeei'¹ 'in tyʉ'² to² untsá². ");
INSERT INTO chqNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Pe mo gajmaa¹a 'elo 'in'lɨɨi'³ do gañii¹i: ―Cwii¹moo Jesús do. Cwii¹mogɨɨ jon Poo². ¿Pe 'iin‑gɨ 'naa'? ");
INSERT INTO chqNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Mo ngayuui'¹³ joon 'in tsá² taai² 'in'lɨɨi'³ alma tya'a do ga'ɨ́ɨ²i jee²¹² 'in tsá² do. Coon'¹³ waa'²¹ pí² tya'a galɨ'¹o jileei'²¹ 'in tsá² do. Gajmee'²¹i 'ido lɨɨlɨ¹. Ce gacwiin¹in fu caluu tɨ' ringúu¹i joongɨ sɨcwuu'²¹i. ");
INSERT INTO chqNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Joon jileei'²¹ 'in tsá² Israel coon'¹³ 'in jo seein²¹ joon 'in néei¹ Efeso do galiñi¹i joon lɨ́ɨ¹ gafo'¹i. Joon lɨ́ɨ¹ gaun'goo²¹ tsá² Ña'ñʉ'¹ʉ' Jesús. ");
INSERT INTO chqNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Joon fúu¹mo 'in nijo'¹ lɨ́ɨi² jalíin² jatyaa¹ júu³ jilaa'²¹ 'e gó² 'e nigajmaa¹a la mo jéei¹. ");
INSERT INTO chqNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Fúu¹mo 'in nigauntsáa¹ júu³ loo¹ tyaan¹ jí² tya'a. Joon gajún²o tyani tsá². Mo gajmaa'¹²a cwáain¹ tya' 'e jí² lo gacɨ́ɨin² tún² cíein¹³ tsi ca'no'³ mil cuu². ");
INSERT INTO chqNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","La joon fúu¹mogɨ tsá² ganúu²o júu³ tya' Ña'ñʉ'¹ʉ'. Joon gatsá²‑tsi tsá² Dios mo nii²¹ 'ii'²¹ tya' Dios. ");
INSERT INTO chqNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Mo ngayuui'¹³ jilaa'²¹ 'elo Poo² ga'ɨ¹‑tsi 'e tsafee'¹²i tsá² 'in néei¹ fu lɨ sii²¹ Macedonia coon'¹³ lɨ sii²¹ Acaya. Joon ingɨ́¹mogɨ ca tɨ' Jerusalén. Joon gajin'²in: ―Mi yuui'¹³ níi³ii fu Jerusalén 'ná¹‑a jon níi³ii fu Roma. ");
INSERT INTO chqNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","La 'ɨɨ²¹² jan¹ Poo² coon²¹ sii'¹³gɨxʉ fu Asia gasii¹mo Timoteo coon'¹³ Erasto, 'in jmoo¹o to² coon'¹³on, fu Macedonia. ");
INSERT INTO chqNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","24","La jee²¹² jmɨɨ²¹² joon jaain²¹ tsá² sii²¹ Demetrio gajmaa¹a mɨɨ'¹³ tya' cwáain¹ tyʉ́² tya' Jesús. Demetrio do‑o jaain²¹ 'in jmoo¹o to² coon'¹³ cwataa²¹. Jmoo¹‑o jilaa'²¹ 'e 'ya'²gɨ tya' jaain²¹ diosa tya'a 'in sii²¹ Diana. Joon lɨ́ɨ¹ jnaa'¹a cuu² coon'¹³ jilaa'²¹ 'e jmoo¹o coon'¹³ jileei'²¹gɨ 'in jmoo¹o to² coon'¹³on. ");
INSERT INTO chqNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Joon gauncaain²¹ jileei'²¹ 'in jmoo¹o to² coon'¹³on coon'¹³ jileei'²¹ tsá² 'in jmoo¹o to² la do. Joon gajin'²in sɨɨ'²¹ɨ 'in tsá² do: ―Tsañʉʉ'¹, jnaa'¹o' jilaa'²¹ 'e tsangɨ́ɨ²na' 'e tyʉ́²‑ʉ saan²an' coon'¹³ jilaa'²¹ to² 'e jmoo²¹o'. ");
INSERT INTO chqNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Pe la lɨ́² 'e jøø²¹ø' joongɨ nʉʉ²¹ʉ' la lɨ júu³ tya¹ Poo² do ngɨɨ¹ jin'²in 'e jilee'²¹ dioses 'in jmaai¹ tsá² jon' dioses 'i. Joon la joon fúu¹mo 'in nigajai'² lɨ́ɨi² júu³ tya'a. Jon' jiin'¹³ lo‑o pe la caain²¹ lɨ sii²¹ Asia. ");
INSERT INTO chqNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","'Áai¹ tyafo'² gó² tyi' tsʉ jilaa'²¹ to² 'e jmoo²¹o' lo itsa'ɨ́ɨ¹‑ɨ. La joon intʉ́² tsá² cwo'¹ tya' diosa tyi' sii²¹ Diana. Nee²o' 'e jilee'¹³ tsá² Asia coon'¹³ la tøøi² juncwii²¹ un'goo²¹o 'ii. Pe nano 'áai¹ fo'² tya' diosa tyi' 'in fee'¹ wana jo 'in un'goo²¹gɨ 'ii ―jin'² Demetrio do. ");
INSERT INTO chqNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Mo ganúu²un jilaa'²¹ 'elo lɨ́ɨ¹ gatsá² 'nii'²¹‑tsi joon ga'oo¹o: ―¡Fee'¹mo diosa tyi'! ¡Fee'¹mo Diana, diosa tya' 'in néei¹ Efeso! ");
INSERT INTO chqNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Lɨ́ɨ¹ gatyaa¹a 'in tsá² do 'goo²¹. Gasan'²mo jaain²¹ tsá² sii²¹ Gayo coon'¹³ jaain²¹gɨ 'in sii²¹ Aristarco. Gái¹ tsá² seein²¹ Macedonia 'in ngɨ́¹ coon'¹³ Poo² do. Tsifu joon gajñúu¹in tɨ lɨ si'² 'nʉ́¹ lɨ lɨcaain²¹ tsá² fuu²¹ do. ");
INSERT INTO chqNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Joon Poo² la mo 'iin²¹²in tsa'ii²¹ tsafee'¹²i 'in tsá² do pe 'in jai'² lɨ́ɨi² catyaai² do jo gacwoo¹o. ");
INSERT INTO chqNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Joon 'inlɨ́ɨi¹³ tsacøøi'¹³ seein²¹ Asia do 'in seein²¹ Poo² tyʉ́² coon'¹³ gasii¹in júu³ 'e jo tsáa¹a 'ii jee²¹² do. ");
INSERT INTO chqNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","'Áai¹ sɨcaai'¹³ 'e faa'²¹a tsá² do la jaain²¹ la jaain²¹ tsʉ jiin'¹³ jo ñii¹gɨ 'ee to² 'e nigalicaain²¹ do. ");
INSERT INTO chqNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Joon 'in tsá² Israel do gatyii'¹³in jaain²¹ tsá² sii²¹ Alejandro 'in gajmaa¹a coon²¹ li² coon'¹³ cwoo²¹o. 'Iin²¹²in faa'²¹a cwáain¹ tya'a. ");
INSERT INTO chqNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Pe mo galili'³i 'in tsá² fúui¹ do 'e tsá² Israel do joon ga'oo¹o wóo² lɨɨlɨ¹. Xʉʉ jogɨ gatɨ́² tún² hora ga'oo¹o 'ido jin'²in: ―¡Fee'¹mo Diana diosa tyi' 'in néei¹ Efeso! ");
INSERT INTO chqNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Joon 'in tɨjí² tyiin¹ fuu²¹ do mo galɨ'¹ɨ 'ɨ́ɨ² tii² jee²¹² 'in tsá² do gajin'²in: ―Tsá² seein²¹ Efeso, la tøø²mo juncwii²¹ ñii¹i 'e fuu²¹ Efeso lo 'e tɨ́ɨ²mo un'øø'²¹mo cwo'¹ tya' diosa 'in feei'¹ sii²¹ Diana 'in nigatøøi'²¹ fu yʉ' juncwii²¹. ");
INSERT INTO chqNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","La joon jo cweei¹ faa'²¹a tsá² 'laa'²¹. Coon'tún²duu'. Jo jmaa²duu' jiin'¹³ la jo mo tyaa²aa' cwáain¹. ");
INSERT INTO chqNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Tsʉ 'in tsañʉʉ'¹ 'in jajéei¹ 'naa' lo jo 'ee mo gajmaa¹a jon'gɨ mo gafaa'²¹a 'laa'²¹ cwáain¹ tya' diosa tyii'. ");
INSERT INTO chqNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Wana 'in Demetrio no coon'¹³ jilee'²¹ 'in jmoo¹o to² coon'¹³ sá² coon²¹ tsaa² cwó² tya' doñi'iin, lí²‑i tsalíin² tyani tsaa'to². 'I‑gɨ unrøø²¹ júu³ no. ");
INSERT INTO chqNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Wana 'oo² 'naa' coon²¹ júu³ xiia'²¹gɨ lí²‑i mɨ́²ɨɨ' 'e licaain²¹ tsá² coon'²¹ tya¹. Joon sɨ́ɨ¹³oo' júu³ ja'²mo. ");
INSERT INTO chqNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Tsʉ 'íi¹‑i fo'² tyi' wana galiñi¹ tsaa'to² tyʉ'² to² fuu²¹ lo la lɨ́² 'e nigajmaa²aa' no. Jo 'ee lɨ́ɨ¹³ cwáain¹ sá² cwoo²¹o' tya' 'e mɨɨ'¹³ 'e nigalɨ́² no. ");
INSERT INTO chqNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Joon mo ngayuui'¹³ gajin'² 'elo ga'ɨ'¹ɨ júu³ gajø'²mo tsá². ");
INSERT INTO chqNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Mo gatséi¹ jilaa'²¹ 'e mɨɨ'¹³ do gatø'¹ø Poo² jileei'²¹ tsá² jo'¹ lɨ́ɨi². Joon gacwo'¹o cwáain¹ 'ido. Mo ngayuui'¹³ joon ga'ɨ'¹o júu³ 'ido. Garøøn¹in joon gangoo²¹o fu Macedonia. ");
INSERT INTO chqNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Joon ngafee'¹²i jileei'²¹ 'in néei¹ la náa¹ fuu²¹ do. Gatya¹gɨ‑tsi tsaru'¹u' coon'¹³ júu³ tya'a. Mo ngayuui'¹³ joon gatyía¹ fu lɨ sii²¹ Grecia. ");
INSERT INTO chqNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Do‑o gajaan¹an gaai²¹ sɨɨ'²¹. Ni'yuui² fu¹ 'e tsa'í² barco 'e tsáa¹a fu Siria mo galili'³i 'e 'in tsá² Israel do 'iin²¹²in saan'¹mo 'ii. 'Wii'¹³ joon ga'ɨ¹‑tsi gajaa'¹²i fu lɨ' cwoo'¹³ tyʉʉn²¹. Joon gangɨ́ɨ¹i fu Macedonia tún¹. ");
INSERT INTO chqNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Gangalíin² caan²¹mo coon'¹³ Sópater, jaain²¹ tsá² seein²¹ Berea. Joongɨ coon'¹³ Aristarco coon'¹³ jaain²¹ tsá² sii²¹ Segun